#include "60.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSerif-Condensed (Noto Serif Condensed)
// Generated on Wed Nov 19 19:11:49 CET 2025
static const uint8_t font_NotoSerif_Condensed_60_data[] PROGMEM = {
  
  // Header
  0x01, 0x02, 0x04, 0x02, 0x01, 0x03, 0x01, 0x01, 0x57, 0x15, 0xBB,
  0xF7, 0xF3, 0x40, 0x3B, 0x2E, 0xF2, 0x0D, 0x03, 0x42, 0x0F, 0x11, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x05, 0x00, 0x0B, 0x2B, 0x11, 0x00, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x03, 0x1E, 0x12, 0x2B, 0x16, 0x00, 0x00, 0x71, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x1B, 0x2B, 0x1D, 0x00, 0x00, 0xBD, // "#" (U+0023)
  0x00, 0x24, 0x03, 0xFC, 0x19, 0x2E, 0x1D, 0x00, 0x01, 0xC6, // "$" (U+0024)
  0x00, 0x25, 0x02, 0x00, 0x2B, 0x2C, 0x2E, 0x00, 0x03, 0x14, // "%" (U+0025)
  0x00, 0x26, 0x01, 0x00, 0x25, 0x2C, 0x27, 0x00, 0x04, 0xFD, // "&" (U+0026)
  0x00, 0x27, 0x03, 0x1E, 0x08, 0x2B, 0x0C, 0x00, 0x06, 0x75, // "'" (U+0027)
  0x00, 0x28, 0x03, 0xF9, 0x10, 0x2E, 0x12, 0x00, 0x06, 0x9A, // "(" (U+0028)
  0x00, 0x29, 0x01, 0xF9, 0x0F, 0x2E, 0x12, 0x00, 0x07, 0x4D, // ")" (U+0029)
  0x00, 0x2A, 0x02, 0x18, 0x16, 0x2E, 0x19, 0x00, 0x08, 0x0D, // "*" (U+002A)
  0x00, 0x2B, 0x03, 0x0A, 0x18, 0x23, 0x1C, 0x00, 0x08, 0xA6, // "+" (U+002B)
  0x00, 0x2C, 0x01, 0xF7, 0x09, 0x07, 0x0D, 0x00, 0x09, 0x0D, // "," (U+002C)
  0x00, 0x2D, 0x01, 0x0F, 0x0E, 0x12, 0x10, 0x00, 0x09, 0x45, // "-" (U+002D)
  0x00, 0x2E, 0x03, 0x00, 0x09, 0x08, 0x0D, 0x00, 0x09, 0x51, // "." (U+002E)
  0x00, 0x2F, 0x00, 0xFA, 0x0E, 0x2E, 0x0F, 0x00, 0x09, 0x6B, // "/" (U+002F)
  0x00, 0x30, 0x02, 0x00, 0x1A, 0x2C, 0x1D, 0x00, 0x0A, 0x1E, // "0" (U+0030)
  0x00, 0x31, 0x03, 0x01, 0x18, 0x2B, 0x1D, 0x00, 0x0B, 0x33, // "1" (U+0031)
  0x00, 0x32, 0x02, 0x01, 0x19, 0x2C, 0x1D, 0x00, 0x0B, 0xF9, // "2" (U+0032)
  0x00, 0x33, 0x02, 0x00, 0x19, 0x2C, 0x1D, 0x00, 0x0C, 0xE1, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x01, 0x1B, 0x2B, 0x1D, 0x00, 0x0D, 0xDF, // "4" (U+0034)
  0x00, 0x35, 0x02, 0x00, 0x18, 0x2B, 0x1D, 0x00, 0x0E, 0xDA, // "5" (U+0035)
  0x00, 0x36, 0x03, 0x00, 0x1A, 0x2C, 0x1D, 0x00, 0x0F, 0xC0, // "6" (U+0036)
  0x00, 0x37, 0x02, 0x01, 0x1A, 0x2B, 0x1D, 0x00, 0x10, 0xD1, // "7" (U+0037)
  0x00, 0x38, 0x02, 0x00, 0x1A, 0x2C, 0x1D, 0x00, 0x11, 0x8A, // "8" (U+0038)
  0x00, 0x39, 0x02, 0x00, 0x19, 0x2C, 0x1D, 0x00, 0x12, 0xAF, // "9" (U+0039)
  0x00, 0x3A, 0x04, 0x00, 0x0A, 0x20, 0x0E, 0x00, 0x13, 0xBC, // ":" (U+003A)
  0x00, 0x3B, 0x02, 0xF7, 0x0A, 0x20, 0x0E, 0x00, 0x13, 0xED, // ";" (U+003B)
  0x00, 0x3C, 0x03, 0x07, 0x18, 0x25, 0x1C, 0x00, 0x14, 0x43, // "<" (U+003C)
  0x00, 0x3D, 0x03, 0x0F, 0x18, 0x1D, 0x1C, 0x00, 0x14, 0xD4, // "=" (U+003D)
  0x00, 0x3E, 0x03, 0x07, 0x18, 0x25, 0x1C, 0x00, 0x14, 0xEB, // ">" (U+003E)
  0x00, 0x3F, 0x02, 0x00, 0x17, 0x2C, 0x1A, 0x00, 0x15, 0x7C, // "?" (U+003F)
  0x00, 0x40, 0x03, 0xF9, 0x2C, 0x2B, 0x2F, 0x00, 0x16, 0x41, // "@" (U+0040)
  0x00, 0x41, 0x00, 0x01, 0x24, 0x2B, 0x25, 0x00, 0x18, 0x6A, // "A" (U+0041)
  0x00, 0x42, 0x01, 0x01, 0x1E, 0x2B, 0x22, 0x00, 0x19, 0x8C, // "B" (U+0042)
  0x00, 0x43, 0x02, 0x00, 0x1E, 0x2C, 0x20, 0x00, 0x1A, 0xAF, // "C" (U+0043)
  0x00, 0x44, 0x01, 0x01, 0x22, 0x2B, 0x26, 0x00, 0x1B, 0xAF, // "D" (U+0044)
  0x00, 0x45, 0x01, 0x01, 0x1E, 0x2B, 0x20, 0x00, 0x1C, 0xE1, // "E" (U+0045)
  0x00, 0x46, 0x01, 0x01, 0x1C, 0x2B, 0x1F, 0x00, 0x1D, 0xCA, // "F" (U+0046)
  0x00, 0x47, 0x02, 0x00, 0x23, 0x2C, 0x25, 0x00, 0x1E, 0x98, // "G" (U+0047)
  0x00, 0x48, 0x01, 0x01, 0x26, 0x2B, 0x29, 0x00, 0x1F, 0xBB, // "H" (U+0048)
  0x00, 0x49, 0x01, 0x01, 0x11, 0x2B, 0x13, 0x00, 0x20, 0xF6, // "I" (U+0049)
  0x00, 0x4A, 0xFF, 0xF3, 0x11, 0x2B, 0x13, 0x00, 0x21, 0x94, // "J" (U+004A)
  0x00, 0x4B, 0x01, 0x01, 0x25, 0x2B, 0x24, 0x00, 0x22, 0x67, // "K" (U+004B)
  0x00, 0x4C, 0x01, 0x01, 0x1E, 0x2B, 0x20, 0x00, 0x23, 0xB3, // "L" (U+004C)
  0x00, 0x4D, 0x01, 0x01, 0x2E, 0x2B, 0x30, 0x00, 0x24, 0x8D, // "M" (U+004D)
  0x00, 0x4E, 0x01, 0x01, 0x25, 0x2B, 0x27, 0x00, 0x26, 0x83, // "N" (U+004E)
  0x00, 0x4F, 0x02, 0x00, 0x23, 0x2C, 0x26, 0x00, 0x28, 0x01, // "O" (U+004F)
  0x00, 0x50, 0x01, 0x01, 0x1D, 0x2B, 0x1F, 0x00, 0x29, 0x42, // "P" (U+0050)
  0x00, 0x51, 0x02, 0xF3, 0x23, 0x2C, 0x26, 0x00, 0x2A, 0x44, // "Q" (U+0051)
  0x00, 0x52, 0x01, 0x01, 0x22, 0x2B, 0x22, 0x00, 0x2B, 0xC1, // "R" (U+0052)
  0x00, 0x53, 0x02, 0x00, 0x19, 0x2C, 0x1C, 0x00, 0x2C, 0xF4, // "S" (U+0053)
  0x00, 0x54, 0x01, 0x01, 0x1E, 0x2B, 0x20, 0x00, 0x2D, 0xF3, // "T" (U+0054)
  0x00, 0x55, 0x00, 0x00, 0x24, 0x2B, 0x25, 0x00, 0x2E, 0xBC, // "U" (U+0055)
  0x00, 0x56, 0x00, 0x01, 0x22, 0x2B, 0x23, 0x00, 0x30, 0x0B, // "V" (U+0056)
  0x00, 0x57, 0x00, 0x01, 0x35, 0x2B, 0x36, 0x00, 0x31, 0x29, // "W" (U+0057)
  0x00, 0x58, 0x00, 0x01, 0x21, 0x2B, 0x22, 0x00, 0x33, 0x14, // "X" (U+0058)
  0x00, 0x59, 0xFF, 0x01, 0x20, 0x2B, 0x21, 0x00, 0x34, 0x45, // "Y" (U+0059)
  0x00, 0x5A, 0x01, 0x01, 0x1C, 0x2B, 0x1F, 0x00, 0x35, 0x49, // "Z" (U+005A)
  0x00, 0x5B, 0x05, 0xF9, 0x10, 0x2E, 0x13, 0x00, 0x36, 0x27, // "[" (U+005B)
  0x00, 0x5C, 0x00, 0xFA, 0x0E, 0x2E, 0x0F, 0x00, 0x36, 0xC7, // "\" (U+005C)
  0x00, 0x5D, 0x01, 0xF9, 0x0D, 0x2E, 0x13, 0x00, 0x37, 0x79, // "]" (U+005D)
  0x00, 0x5E, 0x02, 0x11, 0x19, 0x2B, 0x1C, 0x00, 0x38, 0x1F, // "^" (U+005E)
  0x00, 0x5F, 0xFF, 0xF8, 0x17, 0xFB, 0x17, 0x00, 0x38, 0xC1, // "_" (U+005F)
  0x00, 0x60, 0x02, 0x26, 0x0D, 0x2F, 0x0F, 0x00, 0x38, 0xD1, // "`" (U+0060)
  0x00, 0x61, 0x02, 0x00, 0x1B, 0x21, 0x1D, 0x00, 0x38, 0xF7, // "a" (U+0061)
  0x00, 0x62, 0x00, 0x00, 0x1C, 0x2E, 0x20, 0x00, 0x39, 0xD4, // "b" (U+0062)
  0x00, 0x63, 0x02, 0x00, 0x17, 0x21, 0x1A, 0x00, 0x3B, 0x03, // "c" (U+0063)
  0x00, 0x64, 0x02, 0x00, 0x1E, 0x2E, 0x20, 0x00, 0x3B, 0xBA, // "d" (U+0064)
  0x00, 0x65, 0x02, 0x00, 0x19, 0x21, 0x1C, 0x00, 0x3C, 0xE0, // "e" (U+0065)
  0x00, 0x66, 0x01, 0x01, 0x16, 0x2F, 0x13, 0x00, 0x3D, 0xA1, // "f" (U+0066)
  0x00, 0x67, 0x01, 0xF3, 0x1B, 0x22, 0x1C, 0x00, 0x3E, 0x72, // "g" (U+0067)
  0x00, 0x68, 0x00, 0x01, 0x1F, 0x2E, 0x21, 0x00, 0x3F, 0xAD, // "h" (U+0068)
  0x00, 0x69, 0x01, 0x01, 0x0F, 0x2E, 0x11, 0x00, 0x40, 0xC4, // "i" (U+0069)
  0x00, 0x6A, 0xFF, 0xF3, 0x0B, 0x2E, 0x10, 0x00, 0x41, 0x53, // "j" (U+006A)
  0x00, 0x6B, 0x00, 0x01, 0x1E, 0x2E, 0x1E, 0x00, 0x41, 0xFE, // "k" (U+006B)
  0x00, 0x6C, 0x00, 0x01, 0x0F, 0x2E, 0x10, 0x00, 0x43, 0x2B, // "l" (U+006C)
  0x00, 0x6D, 0x01, 0x01, 0x2F, 0x21, 0x31, 0x00, 0x43, 0xCE, // "m" (U+006D)
  0x00, 0x6E, 0x01, 0x01, 0x1F, 0x21, 0x21, 0x00, 0x45, 0x29, // "n" (U+006E)
  0x00, 0x6F, 0x02, 0x00, 0x1B, 0x21, 0x1E, 0x00, 0x46, 0x1B, // "o" (U+006F)
  0x00, 0x70, 0x00, 0xF3, 0x1C, 0x21, 0x20, 0x00, 0x46, 0xFB, // "p" (U+0070)
  0x00, 0x71, 0x02, 0xF3, 0x1E, 0x21, 0x20, 0x00, 0x48, 0x24, // "q" (U+0071)
  0x00, 0x72, 0x01, 0x01, 0x17, 0x21, 0x19, 0x00, 0x49, 0x46, // "r" (U+0072)
  0x00, 0x73, 0x02, 0x00, 0x15, 0x21, 0x17, 0x00, 0x49, 0xED, // "s" (U+0073)
  0x00, 0x74, 0x01, 0x00, 0x11, 0x28, 0x13, 0x00, 0x4A, 0xAB, // "t" (U+0074)
  0x00, 0x75, 0x01, 0x00, 0x1F, 0x20, 0x21, 0x00, 0x4B, 0x42, // "u" (U+0075)
  0x00, 0x76, 0x00, 0x01, 0x1D, 0x20, 0x1E, 0x00, 0x4C, 0x26, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x01, 0x2C, 0x20, 0x2C, 0x00, 0x4C, 0xF7, // "w" (U+0077)
  0x00, 0x78, 0x00, 0x01, 0x1D, 0x20, 0x1E, 0x00, 0x4E, 0x55, // "x" (U+0078)
  0x00, 0x79, 0x00, 0xF3, 0x1D, 0x20, 0x1D, 0x00, 0x4F, 0x32, // "y" (U+0079)
  0x00, 0x7A, 0x02, 0x01, 0x17, 0x20, 0x1A, 0x00, 0x50, 0x43, // "z" (U+007A)
  0x00, 0x7B, 0x02, 0xF9, 0x13, 0x2E, 0x16, 0x00, 0x50, 0xE7, // "{" (U+007B)
  0x00, 0x7C, 0x4C, 0xF3, 0x0F, 0x2E, 0x1D, 0x00, 0x51, 0xB3, // "|" (U+007C)
  0x00, 0x7D, 0x02, 0xF9, 0x13, 0x2E, 0x16, 0x00, 0x52, 0x2B, // "}" (U+007D)
  0x00, 0x7E, 0x02, 0x11, 0x19, 0x1B, 0x1C, 0x00, 0x52, 0xF9, // "~" (U+007E)
  0x00, 0xA1, 0x05, 0xF6, 0x0B, 0x21, 0x11, 0x00, 0x53, 0x4E, // "¡" (U+00A1)
  0x00, 0xA2, 0x03, 0x01, 0x19, 0x2B, 0x1D, 0x00, 0x53, 0xBE, // "¢" (U+00A2)
  0x00, 0xA3, 0x02, 0x00, 0x1B, 0x2C, 0x1D, 0x00, 0x54, 0xDE, // "£" (U+00A3)
  0x00, 0xA4, 0x03, 0x0A, 0x19, 0x23, 0x1D, 0x00, 0x55, 0xD3, // "¤" (U+00A4)
  0x00, 0xA5, 0x00, 0x01, 0x1C, 0x2B, 0x1D, 0x00, 0x56, 0x8F, // "¥" (U+00A5)
  0x00, 0xA6, 0x4C, 0xF3, 0x0F, 0x2E, 0x1D, 0x00, 0x57, 0x8F, // "¦" (U+00A6)
  0x00, 0xA7, 0x03, 0xFA, 0x19, 0x2E, 0x1C, 0x00, 0x58, 0x07, // "§" (U+00A7)
  0x00, 0xA8, 0x07, 0x28, 0x16, 0x2D, 0x1E, 0x00, 0x59, 0x43, // "¨" (U+00A8)
  0x00, 0xA9, 0x02, 0x00, 0x28, 0x2B, 0x2B, 0x00, 0x59, 0x69, // "©" (U+00A9)
  0x00, 0xAA, 0x01, 0x18, 0x12, 0x2B, 0x14, 0x00, 0x5B, 0x43, // "ª" (U+00AA)
  0x00, 0xAB, 0x04, 0x06, 0x16, 0x1C, 0x1B, 0x00, 0x5B, 0xC2, // "«" (U+00AB)
  0x00, 0xAC, 0x03, 0x08, 0x18, 0x18, 0x1C, 0x00, 0x5C, 0x56, // "¬" (U+00AC)
  0x00, 0xAE, 0x02, 0x00, 0x28, 0x2B, 0x2B, 0x00, 0x5C, 0x94, // "®" (U+00AE)
  0x00, 0xAF, 0xFF, 0x2F, 0x17, 0x32, 0x17, 0x00, 0x5E, 0x7E, // "¯" (U+00AF)
  0x00, 0xB0, 0x02, 0x1B, 0x11, 0x2C, 0x14, 0x00, 0x5E, 0x8E, // "°" (U+00B0)
  0x00, 0xB1, 0x03, 0x01, 0x18, 0x23, 0x1C, 0x00, 0x5E, 0xF2, // "±" (U+00B1)
  0x00, 0xB2, 0x02, 0x18, 0x11, 0x32, 0x14, 0x00, 0x5F, 0x65, // "²" (U+00B2)
  0x00, 0xB3, 0x01, 0x18, 0x12, 0x32, 0x14, 0x00, 0x5F, 0xE0, // "³" (U+00B3)
  0x00, 0xB4, 0x02, 0x26, 0x0C, 0x2F, 0x0F, 0x00, 0x60, 0x74, // "´" (U+00B4)
  0x00, 0xB5, 0x04, 0xF3, 0x1E, 0x20, 0x20, 0x00, 0x60, 0x94, // "µ" (U+00B5)
  0x00, 0xB6, 0x02, 0xFA, 0x1D, 0x2E, 0x20, 0x00, 0x61, 0x9F, // "¶" (U+00B6)
  0x00, 0xB7, 0x03, 0x13, 0x09, 0x1A, 0x0D, 0x00, 0x63, 0x0E, // "·" (U+00B7)
  0x00, 0xB8, 0x03, 0xF3, 0x0D, 0x01, 0x11, 0x00, 0x63, 0x25, // "¸" (U+00B8)
  0x00, 0xB9, 0x02, 0x18, 0x11, 0x31, 0x14, 0x00, 0x63, 0x5C, // "¹" (U+00B9)
  0x00, 0xBA, 0x02, 0x18, 0x12, 0x2B, 0x15, 0x00, 0x63, 0xC7, // "º" (U+00BA)
  0x00, 0xBB, 0x03, 0x06, 0x17, 0x1C, 0x1B, 0x00, 0x64, 0x3D, // "»" (U+00BB)
  0x00, 0xBC, 0x00, 0x01, 0x29, 0x2B, 0x2B, 0x00, 0x64, 0xD3, // "¼" (U+00BC)
  0x00, 0xBD, 0x00, 0x01, 0x28, 0x2B, 0x2B, 0x00, 0x66, 0x64, // "½" (U+00BD)
  0x00, 0xBE, 0x01, 0x01, 0x29, 0x2C, 0x2B, 0x00, 0x67, 0xF4, // "¾" (U+00BE)
  0x00, 0xBF, 0x02, 0xF5, 0x17, 0x21, 0x1A, 0x00, 0x69, 0xAA, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x24, 0x39, 0x25, 0x00, 0x6A, 0x6E, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x24, 0x39, 0x25, 0x00, 0x6B, 0xCA, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x01, 0x24, 0x39, 0x25, 0x00, 0x6D, 0x20, // "Â" (U+00C2)
  0x00, 0xC3, 0x00, 0x01, 0x24, 0x37, 0x25, 0x00, 0x6E, 0x87, // "Ã" (U+00C3)
  0x00, 0xC4, 0x00, 0x01, 0x24, 0x37, 0x25, 0x00, 0x6F, 0xEC, // "Ä" (U+00C4)
  0x00, 0xC5, 0x00, 0x01, 0x24, 0x36, 0x25, 0x00, 0x71, 0x3E, // "Å" (U+00C5)
  0x00, 0xC6, 0xFF, 0x01, 0x2E, 0x2B, 0x31, 0x00, 0x72, 0xB1, // "Æ" (U+00C6)
  0x00, 0xC7, 0x02, 0xF3, 0x1E, 0x2C, 0x20, 0x00, 0x74, 0x2B, // "Ç" (U+00C7)
  0x00, 0xC8, 0x01, 0x01, 0x1E, 0x39, 0x20, 0x00, 0x75, 0x6E, // "È" (U+00C8)
  0x00, 0xC9, 0x01, 0x01, 0x1E, 0x39, 0x20, 0x00, 0x76, 0x8D, // "É" (U+00C9)
  0x00, 0xCA, 0x01, 0x01, 0x1E, 0x39, 0x20, 0x00, 0x77, 0xA6, // "Ê" (U+00CA)
  0x00, 0xCB, 0x01, 0x01, 0x1E, 0x37, 0x20, 0x00, 0x78, 0xD0, // "Ë" (U+00CB)
  0x00, 0xCC, 0x01, 0x01, 0x11, 0x39, 0x13, 0x00, 0x79, 0xE7, // "Ì" (U+00CC)
  0x00, 0xCD, 0x01, 0x01, 0x11, 0x39, 0x13, 0x00, 0x7A, 0xB1, // "Í" (U+00CD)
  0x00, 0xCE, 0x01, 0x01, 0x11, 0x39, 0x13, 0x00, 0x7B, 0x76, // "Î" (U+00CE)
  0x00, 0xCF, 0x01, 0x01, 0x11, 0x37, 0x13, 0x00, 0x7C, 0x4B, // "Ï" (U+00CF)
  0x00, 0xD0, 0x01, 0x01, 0x22, 0x2B, 0x26, 0x00, 0x7D, 0x13, // "Ð" (U+00D0)
  0x00, 0xD1, 0x01, 0x01, 0x25, 0x37, 0x27, 0x00, 0x7E, 0x47, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x02, 0x00, 0x23, 0x39, 0x26, 0x00, 0x80, 0x0A, // "Ò" (U+00D2)
  0x00, 0xD3, 0x02, 0x00, 0x23, 0x39, 0x26, 0x00, 0x81, 0x82, // "Ó" (U+00D3)
  0x00, 0xD4, 0x02, 0x00, 0x23, 0x39, 0x26, 0x00, 0x82, 0xF3, // "Ô" (U+00D4)
  0x00, 0xD5, 0x02, 0x00, 0x23, 0x37, 0x26, 0x00, 0x84, 0x76, // "Õ" (U+00D5)
  0x00, 0xD6, 0x02, 0x00, 0x23, 0x37, 0x26, 0x00, 0x85, 0xFA, // "Ö" (U+00D6)
  0x00, 0xD7, 0x03, 0x0A, 0x18, 0x22, 0x1C, 0x00, 0x87, 0x69, // "×" (U+00D7)
  0x00, 0xD8, 0x02, 0xFE, 0x23, 0x2E, 0x26, 0x00, 0x88, 0x0D, // "Ø" (U+00D8)
  0x00, 0xD9, 0x00, 0x00, 0x24, 0x39, 0x25, 0x00, 0x89, 0xAC, // "Ù" (U+00D9)
  0x00, 0xDA, 0x00, 0x00, 0x24, 0x39, 0x25, 0x00, 0x8B, 0x36, // "Ú" (U+00DA)
  0x00, 0xDB, 0x00, 0x00, 0x24, 0x39, 0x25, 0x00, 0x8C, 0xBA, // "Û" (U+00DB)
  0x00, 0xDC, 0x00, 0x00, 0x24, 0x37, 0x25, 0x00, 0x8E, 0x4F, // "Ü" (U+00DC)
  0x00, 0xDD, 0xFF, 0x01, 0x20, 0x39, 0x21, 0x00, 0x8F, 0xCF, // "Ý" (U+00DD)
  0x00, 0xDE, 0x01, 0x01, 0x1D, 0x2B, 0x1F, 0x00, 0x91, 0x04, // "Þ" (U+00DE)
  0x00, 0xDF, 0x01, 0x00, 0x1F, 0x2E, 0x22, 0x00, 0x91, 0xFF, // "ß" (U+00DF)
  0x00, 0xE0, 0x02, 0x00, 0x1B, 0x2F, 0x1D, 0x00, 0x93, 0x67, // "à" (U+00E0)
  0x00, 0xE1, 0x02, 0x00, 0x1B, 0x2F, 0x1D, 0x00, 0x94, 0x75, // "á" (U+00E1)
  0x00, 0xE2, 0x02, 0x00, 0x1B, 0x2F, 0x1D, 0x00, 0x95, 0x7C, // "â" (U+00E2)
  0x00, 0xE3, 0x02, 0x00, 0x1B, 0x2D, 0x1D, 0x00, 0x96, 0x96, // "ã" (U+00E3)
  0x00, 0xE4, 0x02, 0x00, 0x1B, 0x2D, 0x1D, 0x00, 0x97, 0xB2, // "ä" (U+00E4)
  0x00, 0xE5, 0x02, 0x00, 0x1B, 0x31, 0x1D, 0x00, 0x98, 0xBA, // "å" (U+00E5)
  0x00, 0xE6, 0x02, 0x00, 0x28, 0x21, 0x2B, 0x00, 0x99, 0xE3, // "æ" (U+00E6)
  0x00, 0xE7, 0x02, 0xF3, 0x17, 0x21, 0x1A, 0x00, 0x9B, 0x2C, // "ç" (U+00E7)
  0x00, 0xE8, 0x02, 0x00, 0x19, 0x2F, 0x1C, 0x00, 0x9C, 0x1E, // "è" (U+00E8)
  0x00, 0xE9, 0x02, 0x00, 0x19, 0x2F, 0x1C, 0x00, 0x9D, 0x10, // "é" (U+00E9)
  0x00, 0xEA, 0x02, 0x00, 0x19, 0x2F, 0x1C, 0x00, 0x9D, 0xFC, // "ê" (U+00EA)
  0x00, 0xEB, 0x02, 0x00, 0x19, 0x2D, 0x1C, 0x00, 0x9E, 0xF9, // "ë" (U+00EB)
  0x00, 0xEC, 0x00, 0x01, 0x0F, 0x2F, 0x11, 0x00, 0x9F, 0xE6, // "ì" (U+00EC)
  0x00, 0xED, 0x01, 0x01, 0x0F, 0x2F, 0x11, 0x00, 0xA0, 0x86, // "í" (U+00ED)
  0x00, 0xEE, 0x00, 0x01, 0x0F, 0x2F, 0x11, 0x00, 0xA1, 0x1F, // "î" (U+00EE)
  0x00, 0xEF, 0x00, 0x01, 0x0F, 0x2D, 0x11, 0x00, 0xA1, 0xC9, // "ï" (U+00EF)
  0x00, 0xF0, 0x02, 0x00, 0x1B, 0x2F, 0x1E, 0x00, 0xA2, 0x65, // "ð" (U+00F0)
  0x00, 0xF1, 0x01, 0x01, 0x1F, 0x2D, 0x21, 0x00, 0xA3, 0x99, // "ñ" (U+00F1)
  0x00, 0xF2, 0x02, 0x00, 0x1B, 0x2F, 0x1E, 0x00, 0xA4, 0xCB, // "ò" (U+00F2)
  0x00, 0xF3, 0x02, 0x00, 0x1B, 0x2F, 0x1E, 0x00, 0xA5, 0xDC, // "ó" (U+00F3)
  0x00, 0xF4, 0x02, 0x00, 0x1B, 0x2F, 0x1E, 0x00, 0xA6, 0xE7, // "ô" (U+00F4)
  0x00, 0xF5, 0x02, 0x00, 0x1B, 0x2D, 0x1E, 0x00, 0xA8, 0x04, // "õ" (U+00F5)
  0x00, 0xF6, 0x02, 0x00, 0x1B, 0x2D, 0x1E, 0x00, 0xA9, 0x23, // "ö" (U+00F6)
  0x00, 0xF7, 0x03, 0x08, 0x18, 0x25, 0x1C, 0x00, 0xAA, 0x2F, // "÷" (U+00F7)
  0x00, 0xF8, 0x02, 0xFE, 0x1B, 0x23, 0x1E, 0x00, 0xAA, 0x78, // "ø" (U+00F8)
  0x00, 0xF9, 0x01, 0x00, 0x1F, 0x2F, 0x21, 0x00, 0xAB, 0x99, // "ù" (U+00F9)
  0x00, 0xFA, 0x01, 0x00, 0x1F, 0x2F, 0x21, 0x00, 0xAC, 0xB3, // "ú" (U+00FA)
  0x00, 0xFB, 0x01, 0x00, 0x1F, 0x2F, 0x21, 0x00, 0xAD, 0xC8, // "û" (U+00FB)
  0x00, 0xFC, 0x01, 0x00, 0x1F, 0x2D, 0x21, 0x00, 0xAE, 0xEE, // "ü" (U+00FC)
  0x00, 0xFD, 0x00, 0xF3, 0x1D, 0x2F, 0x1D, 0x00, 0xB0, 0x02, // "ý" (U+00FD)
  0x00, 0xFE, 0x00, 0xF3, 0x1C, 0x2E, 0x20, 0x00, 0xB1, 0x44, // "þ" (U+00FE)
  0x00, 0xFF, 0x00, 0xF3, 0x1D, 0x2D, 0x1D, 0x00, 0xB2, 0xAD, // "ÿ" (U+00FF)
  0x01, 0x00, 0x00, 0x01, 0x24, 0x33, 0x25, 0x00, 0xB3, 0xED, // "Ā" (U+0100)
  0x01, 0x01, 0x02, 0x00, 0x1B, 0x29, 0x1D, 0x00, 0xB5, 0x22, // "ā" (U+0101)
  0x01, 0x02, 0x00, 0x01, 0x24, 0x37, 0x25, 0x00, 0xB6, 0x10, // "Ă" (U+0102)
  0x01, 0x03, 0x02, 0x00, 0x1B, 0x2D, 0x1D, 0x00, 0xB7, 0x6B, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0xF3, 0x24, 0x2B, 0x25, 0x00, 0xB8, 0x7A, // "Ą" (U+0104)
  0x01, 0x05, 0x02, 0xF3, 0x1B, 0x21, 0x1D, 0x00, 0xB9, 0xE9, // "ą" (U+0105)
  0x01, 0x06, 0x02, 0x00, 0x1E, 0x39, 0x20, 0x00, 0xBB, 0x04, // "Ć" (U+0106)
  0x01, 0x07, 0x02, 0x00, 0x17, 0x2F, 0x1A, 0x00, 0xBC, 0x33, // "ć" (U+0107)
  0x01, 0x08, 0x02, 0x00, 0x1E, 0x39, 0x20, 0x00, 0xBD, 0x14, // "Ĉ" (U+0108)
  0x01, 0x09, 0x02, 0x00, 0x17, 0x2F, 0x1A, 0x00, 0xBE, 0x53, // "ĉ" (U+0109)
  0x01, 0x0A, 0x02, 0x00, 0x1E, 0x38, 0x20, 0x00, 0xBF, 0x44, // "Ċ" (U+010A)
  0x01, 0x0B, 0x02, 0x00, 0x17, 0x2E, 0x1A, 0x00, 0xC0, 0x67, // "ċ" (U+010B)
  0x01, 0x0C, 0x02, 0x00, 0x1E, 0x39, 0x20, 0x00, 0xC1, 0x3D, // "Č" (U+010C)
  0x01, 0x0D, 0x02, 0x00, 0x17, 0x2F, 0x1A, 0x00, 0xC2, 0x7E, // "č" (U+010D)
  0x01, 0x0E, 0x01, 0x01, 0x22, 0x39, 0x26, 0x00, 0xC3, 0x70, // "Ď" (U+010E)
  0x01, 0x0F, 0x02, 0x00, 0x23, 0x2E, 0x20, 0x00, 0xC4, 0xE7, // "ď" (U+010F)
  0x01, 0x10, 0x01, 0x01, 0x22, 0x2B, 0x26, 0x00, 0xC6, 0x37, // "Đ" (U+0110)
  0x01, 0x11, 0x02, 0x00, 0x1E, 0x2E, 0x20, 0x00, 0xC7, 0x6B, // "đ" (U+0111)
  0x01, 0x12, 0x01, 0x01, 0x1E, 0x33, 0x20, 0x00, 0xC8, 0x94, // "Ē" (U+0112)
  0x01, 0x13, 0x02, 0x00, 0x19, 0x29, 0x1C, 0x00, 0xC9, 0x90, // "ē" (U+0113)
  0x01, 0x14, 0x01, 0x01, 0x1E, 0x37, 0x20, 0x00, 0xCA, 0x62, // "Ĕ" (U+0114)
  0x01, 0x15, 0x02, 0x00, 0x19, 0x2D, 0x1C, 0x00, 0xCB, 0x81, // "ĕ" (U+0115)
  0x01, 0x16, 0x01, 0x01, 0x1E, 0x37, 0x20, 0x00, 0xCC, 0x74, // "Ė" (U+0116)
  0x01, 0x17, 0x02, 0x00, 0x19, 0x2E, 0x1C, 0x00, 0xCD, 0x80, // "ė" (U+0117)
  0x01, 0x18, 0x01, 0xF3, 0x1E, 0x2B, 0x20, 0x00, 0xCE, 0x61, // "Ę" (U+0118)
  0x01, 0x19, 0x02, 0xF3, 0x19, 0x21, 0x1C, 0x00, 0xCF, 0x8F, // "ę" (U+0119)
  0x01, 0x1A, 0x01, 0x01, 0x1E, 0x39, 0x20, 0x00, 0xD0, 0x89, // "Ě" (U+011A)
  0x01, 0x1B, 0x02, 0x00, 0x19, 0x2F, 0x1C, 0x00, 0xD1, 0xB4, // "ě" (U+011B)
  0x01, 0x1C, 0x02, 0x00, 0x23, 0x39, 0x25, 0x00, 0xD2, 0xB3, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x01, 0xF3, 0x1B, 0x2F, 0x1C, 0x00, 0xD4, 0x18, // "ĝ" (U+011D)
  0x01, 0x1E, 0x02, 0x00, 0x23, 0x37, 0x25, 0x00, 0xD5, 0x90, // "Ğ" (U+011E)
  0x01, 0x1F, 0x01, 0xF3, 0x1B, 0x2D, 0x1C, 0x00, 0xD6, 0xEA, // "ğ" (U+011F)
  0x01, 0x20, 0x02, 0x00, 0x23, 0x38, 0x25, 0x00, 0xD8, 0x57, // "Ġ" (U+0120)
  0x01, 0x21, 0x01, 0xF3, 0x1B, 0x2E, 0x1C, 0x00, 0xD9, 0x9D, // "ġ" (U+0121)
  0x01, 0x22, 0x02, 0xF4, 0x23, 0x2C, 0x25, 0x00, 0xDA, 0xF7, // "Ģ" (U+0122)
  0x01, 0x23, 0x01, 0xF3, 0x1B, 0x2E, 0x1C, 0x00, 0xDC, 0x4B, // "ģ" (U+0123)
  0x01, 0x24, 0x01, 0x01, 0x26, 0x39, 0x29, 0x00, 0xDD, 0xB1, // "Ĥ" (U+0124)
  0x01, 0x25, 0x00, 0x01, 0x1F, 0x3B, 0x21, 0x00, 0xDF, 0x33, // "ĥ" (U+0125)
  0x01, 0x26, 0x01, 0x01, 0x27, 0x2B, 0x29, 0x00, 0xE0, 0x8C, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x1F, 0x2E, 0x21, 0x00, 0xE1, 0xC7, // "ħ" (U+0127)
  0x01, 0x28, 0x00, 0x01, 0x12, 0x37, 0x13, 0x00, 0xE2, 0xE0, // "Ĩ" (U+0128)
  0x01, 0x29, 0xFE, 0x01, 0x10, 0x2D, 0x11, 0x00, 0xE3, 0xBD, // "ĩ" (U+0129)
  0x01, 0x2A, 0x01, 0x01, 0x11, 0x33, 0x13, 0x00, 0xE4, 0x6E, // "Ī" (U+012A)
  0x01, 0x2B, 0x00, 0x01, 0x0F, 0x29, 0x11, 0x00, 0xE5, 0x1C, // "ī" (U+012B)
  0x01, 0x2C, 0x01, 0x01, 0x11, 0x37, 0x13, 0x00, 0xE5, 0x9F, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x00, 0x01, 0x0F, 0x2D, 0x11, 0x00, 0xE6, 0x6C, // "ĭ" (U+012D)
  0x01, 0x2E, 0x01, 0xF3, 0x11, 0x2B, 0x13, 0x00, 0xE7, 0x0E, // "Į" (U+012E)
  0x01, 0x2F, 0x01, 0xF3, 0x0F, 0x2E, 0x11, 0x00, 0xE7, 0xE4, // "į" (U+012F)
  0x01, 0x30, 0x01, 0x01, 0x11, 0x38, 0x13, 0x00, 0xE8, 0xAB, // "İ" (U+0130)
  0x01, 0x31, 0x01, 0x01, 0x0F, 0x20, 0x11, 0x00, 0xE9, 0x66, // "ı" (U+0131)
  0x01, 0x32, 0x01, 0xF3, 0x24, 0x2B, 0x26, 0x00, 0xE9, 0xD8, // "Ĳ" (U+0132)
  0x01, 0x33, 0x01, 0xF3, 0x1C, 0x2E, 0x21, 0x00, 0xEB, 0x5B, // "ĳ" (U+0133)
  0x01, 0x34, 0xFF, 0xF3, 0x11, 0x39, 0x13, 0x00, 0xEC, 0xA2, // "Ĵ" (U+0134)
  0x01, 0x35, 0xFF, 0xF3, 0x0E, 0x2F, 0x10, 0x00, 0xED, 0xAD, // "ĵ" (U+0135)
  0x01, 0x36, 0x01, 0xF4, 0x25, 0x2B, 0x24, 0x00, 0xEE, 0x87, // "Ķ" (U+0136)
  0x01, 0x37, 0x00, 0xF4, 0x1E, 0x2E, 0x1E, 0x00, 0xF0, 0x07, // "ķ" (U+0137)
  0x01, 0x38, 0x00, 0x01, 0x1E, 0x20, 0x1E, 0x00, 0xF1, 0x64, // "ĸ" (U+0138)
  0x01, 0x39, 0x01, 0x01, 0x1E, 0x39, 0x20, 0x00, 0xF2, 0x52, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x00, 0x01, 0x0F, 0x3B, 0x10, 0x00, 0xF3, 0x5C, // "ĺ" (U+013A)
  0x01, 0x3B, 0x01, 0xF4, 0x1E, 0x2B, 0x20, 0x00, 0xF4, 0x25, // "Ļ" (U+013B)
  0x01, 0x3C, 0x00, 0xF4, 0x0F, 0x2E, 0x10, 0x00, 0xF5, 0x2E, // "ļ" (U+013C)
  0x01, 0x3D, 0x01, 0x01, 0x1E, 0x2B, 0x20, 0x00, 0xF5, 0xF6, // "Ľ" (U+013D)
  0x01, 0x3E, 0x00, 0x01, 0x13, 0x2E, 0x10, 0x00, 0xF6, 0xE8, // "ľ" (U+013E)
  0x01, 0x3F, 0x01, 0x01, 0x1E, 0x2B, 0x20, 0x00, 0xF7, 0xA7, // "Ŀ" (U+013F)
  0x01, 0x40, 0x00, 0x01, 0x14, 0x2E, 0x10, 0x00, 0xF8, 0x92, // "ŀ" (U+0140)
  0x01, 0x41, 0x01, 0x01, 0x1E, 0x2B, 0x20, 0x00, 0xF9, 0x5B, // "Ł" (U+0141)
  0x01, 0x42, 0x01, 0x01, 0x10, 0x2E, 0x11, 0x00, 0xFA, 0x4F, // "ł" (U+0142)
  0x01, 0x43, 0x01, 0x01, 0x25, 0x39, 0x27, 0x00, 0xFB, 0x06, // "Ń" (U+0143)
  0x01, 0x44, 0x01, 0x01, 0x1F, 0x2F, 0x21, 0x00, 0xFC, 0xB9, // "ń" (U+0144)
  0x01, 0x45, 0x01, 0xF4, 0x25, 0x2B, 0x27, 0x00, 0xFD, 0xDA, // "Ņ" (U+0145)
  0x01, 0x46, 0x01, 0xF4, 0x1F, 0x21, 0x21, 0x00, 0xFF, 0x8C, // "ņ" (U+0146)
  0x01, 0x47, 0x01, 0x01, 0x25, 0x39, 0x27, 0x01, 0x00, 0xAE, // "Ň" (U+0147)
  0x01, 0x48, 0x01, 0x01, 0x1F, 0x2F, 0x21, 0x01, 0x02, 0x73, // "ň" (U+0148)
  0x01, 0x49, 0x00, 0x01, 0x27, 0x2B, 0x29, 0x01, 0x03, 0xA8, // "ŉ" (U+0149)
  0x01, 0x4A, 0x01, 0xF3, 0x25, 0x2B, 0x27, 0x01, 0x04, 0xF5, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x01, 0xF3, 0x1B, 0x21, 0x21, 0x01, 0x06, 0xBE, // "ŋ" (U+014B)
  0x01, 0x4C, 0x02, 0x00, 0x23, 0x33, 0x26, 0x01, 0x07, 0xDE, // "Ō" (U+014C)
  0x01, 0x4D, 0x02, 0x00, 0x1B, 0x29, 0x1E, 0x01, 0x09, 0x32, // "ō" (U+014D)
  0x01, 0x4E, 0x02, 0x00, 0x23, 0x37, 0x26, 0x01, 0x0A, 0x23, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x02, 0x00, 0x1B, 0x2D, 0x1E, 0x01, 0x0B, 0x9B, // "ŏ" (U+014F)
  0x01, 0x50, 0x02, 0x00, 0x23, 0x39, 0x26, 0x01, 0x0C, 0xAD, // "Ő" (U+0150)
  0x01, 0x51, 0x02, 0x00, 0x1B, 0x2F, 0x1E, 0x01, 0x0E, 0x3C, // "ő" (U+0151)
  0x01, 0x52, 0x02, 0x00, 0x2F, 0x2C, 0x32, 0x01, 0x0F, 0x66, // "Œ" (U+0152)
  0x01, 0x53, 0x02, 0x00, 0x2C, 0x21, 0x2F, 0x01, 0x10, 0xF1, // "œ" (U+0153)
  0x01, 0x54, 0x01, 0x01, 0x22, 0x39, 0x22, 0x01, 0x12, 0x45, // "Ŕ" (U+0154)
  0x01, 0x55, 0x01, 0x01, 0x17, 0x2F, 0x19, 0x01, 0x13, 0xA9, // "ŕ" (U+0155)
  0x01, 0x56, 0x01, 0xF4, 0x22, 0x2B, 0x22, 0x01, 0x14, 0x7A, // "Ŗ" (U+0156)
  0x01, 0x57, 0x01, 0xF4, 0x17, 0x21, 0x19, 0x01, 0x15, 0xDF, // "ŗ" (U+0157)
  0x01, 0x58, 0x01, 0x01, 0x22, 0x39, 0x22, 0x01, 0x16, 0xB0, // "Ř" (U+0158)
  0x01, 0x59, 0x01, 0x01, 0x17, 0x2F, 0x19, 0x01, 0x18, 0x28, // "ř" (U+0159)
  0x01, 0x5A, 0x02, 0x00, 0x19, 0x39, 0x1C, 0x01, 0x19, 0x0B, // "Ś" (U+015A)
  0x01, 0x5B, 0x02, 0x00, 0x15, 0x2F, 0x17, 0x01, 0x1A, 0x34, // "ś" (U+015B)
  0x01, 0x5C, 0x02, 0x00, 0x19, 0x39, 0x1C, 0x01, 0x1B, 0x19, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x02, 0x00, 0x15, 0x2F, 0x17, 0x01, 0x1C, 0x54, // "ŝ" (U+015D)
  0x01, 0x5E, 0x02, 0xF3, 0x19, 0x2C, 0x1C, 0x01, 0x1D, 0x4B, // "Ş" (U+015E)
  0x01, 0x5F, 0x02, 0xF3, 0x15, 0x21, 0x17, 0x01, 0x1E, 0x86, // "ş" (U+015F)
  0x01, 0x60, 0x02, 0x00, 0x19, 0x39, 0x1C, 0x01, 0x1F, 0x7E, // "Š" (U+0160)
  0x01, 0x61, 0x02, 0x00, 0x15, 0x2F, 0x17, 0x01, 0x20, 0xBB, // "š" (U+0161)
  0x01, 0x62, 0x01, 0xF3, 0x1E, 0x2B, 0x20, 0x01, 0x21, 0xB4, // "Ţ" (U+0162)
  0x01, 0x63, 0x01, 0xF3, 0x11, 0x28, 0x13, 0x01, 0x22, 0xC4, // "ţ" (U+0163)
  0x01, 0x64, 0x01, 0x01, 0x1E, 0x39, 0x20, 0x01, 0x23, 0x90, // "Ť" (U+0164)
  0x01, 0x65, 0x01, 0x00, 0x13, 0x2E, 0x13, 0x01, 0x24, 0x9B, // "ť" (U+0165)
  0x01, 0x66, 0x01, 0x01, 0x1E, 0x2B, 0x20, 0x01, 0x25, 0x56, // "Ŧ" (U+0166)
  0x01, 0x67, 0x01, 0x00, 0x11, 0x28, 0x13, 0x01, 0x26, 0x25, // "ŧ" (U+0167)
  0x01, 0x68, 0x00, 0x00, 0x24, 0x37, 0x25, 0x01, 0x26, 0xBB, // "Ũ" (U+0168)
  0x01, 0x69, 0x01, 0x00, 0x1F, 0x2D, 0x21, 0x01, 0x28, 0x4F, // "ũ" (U+0169)
  0x01, 0x6A, 0x00, 0x00, 0x24, 0x33, 0x25, 0x01, 0x29, 0x74, // "Ū" (U+016A)
  0x01, 0x6B, 0x01, 0x00, 0x1F, 0x29, 0x21, 0x01, 0x2A, 0xD8, // "ū" (U+016B)
  0x01, 0x6C, 0x00, 0x00, 0x24, 0x37, 0x25, 0x01, 0x2B, 0xD0, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x01, 0x00, 0x1F, 0x2D, 0x21, 0x01, 0x2D, 0x59, // "ŭ" (U+016D)
  0x01, 0x6E, 0x00, 0x00, 0x24, 0x3B, 0x25, 0x01, 0x2E, 0x74, // "Ů" (U+016E)
  0x01, 0x6F, 0x01, 0x00, 0x1F, 0x31, 0x21, 0x01, 0x30, 0x1C, // "ů" (U+016F)
  0x01, 0x70, 0x00, 0x00, 0x24, 0x39, 0x25, 0x01, 0x31, 0x53, // "Ű" (U+0170)
  0x01, 0x71, 0x01, 0x00, 0x1F, 0x2F, 0x21, 0x01, 0x32, 0xF4, // "ű" (U+0171)
  0x01, 0x72, 0x00, 0xF3, 0x24, 0x2B, 0x24, 0x01, 0x34, 0x27, // "Ų" (U+0172)
  0x01, 0x73, 0x01, 0xF3, 0x1F, 0x20, 0x21, 0x01, 0x35, 0xBC, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x35, 0x39, 0x36, 0x01, 0x36, 0xE4, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x2C, 0x2F, 0x2C, 0x01, 0x39, 0x19, // "ŵ" (U+0175)
  0x01, 0x76, 0xFF, 0x01, 0x20, 0x39, 0x21, 0x01, 0x3A, 0xC0, // "Ŷ" (U+0176)
  0x01, 0x77, 0x00, 0xF3, 0x1D, 0x2F, 0x1D, 0x01, 0x3C, 0x07, // "ŷ" (U+0177)
  0x01, 0x78, 0xFF, 0x01, 0x20, 0x37, 0x21, 0x01, 0x3D, 0x59, // "Ÿ" (U+0178)
  0x01, 0x79, 0x01, 0x01, 0x1C, 0x39, 0x1F, 0x01, 0x3E, 0x8D, // "Ź" (U+0179)
  0x01, 0x7A, 0x02, 0x01, 0x17, 0x2F, 0x1A, 0x01, 0x3F, 0x98, // "ź" (U+017A)
  0x01, 0x7B, 0x01, 0x01, 0x1C, 0x38, 0x1F, 0x01, 0x40, 0x66, // "Ż" (U+017B)
  0x01, 0x7C, 0x02, 0x01, 0x17, 0x2E, 0x1A, 0x01, 0x41, 0x65, // "ż" (U+017C)
  0x01, 0x7D, 0x01, 0x01, 0x1C, 0x39, 0x1F, 0x01, 0x42, 0x29, // "Ž" (U+017D)
  0x01, 0x7E, 0x02, 0x01, 0x17, 0x2F, 0x1A, 0x01, 0x43, 0x47, // "ž" (U+017E)
  0x01, 0x7F, 0x00, 0x01, 0x16, 0x2F, 0x12, 0x01, 0x44, 0x27, // "ſ" (U+017F)
  0x03, 0xA9, 0x02, 0x01, 0x24, 0x2C, 0x27, 0x01, 0x44, 0xF5, // "Ω" (U+03A9)
  0x03, 0xBC, 0x04, 0xF3, 0x1E, 0x20, 0x20, 0x01, 0x46, 0x59, // "μ" (U+03BC)
  0x03, 0xC0, 0x01, 0x00, 0x1E, 0x20, 0x21, 0x01, 0x47, 0x64, // "π" (U+03C0)
  0x20, 0x13, 0xFF, 0x10, 0x1E, 0x13, 0x1E, 0x01, 0x48, 0x4F, // "–" (U+2013)
  0x20, 0x14, 0xFF, 0x10, 0x3C, 0x13, 0x3C, 0x01, 0x48, 0x5F, // "—" (U+2014)
  0x20, 0xAC, 0x01, 0x00, 0x1B, 0x2C, 0x1D, 0x01, 0x48, 0x6F, // "€" (U+20AC)
  0x20, 0xBF, 0x02, 0xFC, 0x1A, 0x2F, 0x1D, 0x01, 0x49, 0x59, // "₿" (U+20BF)
  0x20, 0x18, 0x02, 0x1B, 0x0B, 0x2B, 0x0D, 0x01, 0x4A, 0xA6, // "‘" (U+2018)
  0x20, 0x19, 0x01, 0x1B, 0x0A, 0x2B, 0x0D, 0x01, 0x4A, 0xE1, // "’" (U+2019)
  0x20, 0x1A, 0x01, 0xF8, 0x0A, 0x08, 0x0D, 0x01, 0x4B, 0x1A, // "‚" (U+201A)
  0x20, 0x1B, 0x02, 0x1B, 0x0B, 0x2B, 0x0D, 0x01, 0x4B, 0x53, // "‛" (U+201B)
  0x20, 0x1C, 0x03, 0x1B, 0x15, 0x2B, 0x17, 0x01, 0x4B, 0x8E, // "“" (U+201C)
  0x20, 0x1D, 0x02, 0x1B, 0x13, 0x2B, 0x17, 0x01, 0x4B, 0xFA, // "”" (U+201D)
  0x20, 0x1E, 0x02, 0xF8, 0x13, 0x08, 0x17, 0x01, 0x4C, 0x6E, // "„" (U+201E)
  0x20, 0x1F, 0x02, 0x1B, 0x15, 0x2B, 0x17, 0x01, 0x4C, 0xE4, // "‟" (U+201F)
  0x20, 0x20, 0x01, 0xFA, 0x15, 0x2E, 0x17, 0x01, 0x4D, 0x59, // "†" (U+2020)
  0x20, 0x21, 0x01, 0xFA, 0x15, 0x2E, 0x17, 0x01, 0x4E, 0x3E, // "‡" (U+2021)
  0x20, 0x22, 0x02, 0x0E, 0x10, 0x1E, 0x13, 0x01, 0x4F, 0x40, // "•" (U+2022)
  0x20, 0x26, 0x06, 0x00, 0x27, 0x08, 0x2C, 0x01, 0x4F, 0x7F, // "…" (U+2026)
  0x20, 0x30, 0x02, 0x00, 0x40, 0x2C, 0x42, 0x01, 0x4F, 0xD1, // "‰" (U+2030)
  0x20, 0x39, 0x03, 0x06, 0x0D, 0x1C, 0x11, 0x01, 0x52, 0x74, // "‹" (U+2039)
  0x20, 0x3A, 0x03, 0x06, 0x0D, 0x1C, 0x11, 0x01, 0x52, 0xBD, // "›" (U+203A)
  0x20, 0x44, 0xF7, 0x01, 0x0C, 0x2B, 0x03, 0x01, 0x53, 0x07, // "⁄" (U+2044)
  0x21, 0x22, 0x01, 0x17, 0x28, 0x2B, 0x2A, 0x01, 0x53, 0xB6, // "™" (U+2122)
  0x21, 0x52, 0x02, 0x01, 0x3A, 0x2B, 0x3C, 0x01, 0x54, 0xE5, // "⅒" (U+2152)
  0xFB, 0x01, 0x01, 0x01, 0x21, 0x2F, 0x23, 0x01, 0x57, 0x09, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0x01, 0x01, 0x21, 0x2F, 0x23, 0x01, 0x58, 0x45, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x05, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0x63, 0x01, // "c (U+0022 U+0063)
  0x00, 0x22, 0x00, 0x64, 0x01, // "d (U+0022 U+0064)
  0x00, 0x22, 0x00, 0x65, 0x01, // "e (U+0022 U+0065)
  0x00, 0x22, 0x00, 0x67, 0x02, // "g (U+0022 U+0067)
  0x00, 0x22, 0x00, 0x6F, 0x01, // "o (U+0022 U+006F)
  0x00, 0x22, 0x00, 0x71, 0x01, // "q (U+0022 U+0071)
  0x00, 0x22, 0x00, 0xC0, 0x05, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x05, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x05, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x05, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x05, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x05, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xC6, 0x07, // "Æ (U+0022 U+00C6)
  0x00, 0x22, 0x00, 0xE7, 0x01, // "ç (U+0022 U+00E7)
  0x00, 0x22, 0x00, 0xE8, 0x01, // "è (U+0022 U+00E8)
  0x00, 0x22, 0x00, 0xE9, 0x01, // "é (U+0022 U+00E9)
  0x00, 0x22, 0x00, 0xEA, 0x01, // "ê (U+0022 U+00EA)
  0x00, 0x22, 0x00, 0xEB, 0x01, // "ë (U+0022 U+00EB)
  0x00, 0x22, 0x00, 0xF0, 0x01, // "ð (U+0022 U+00F0)
  0x00, 0x22, 0x00, 0xF2, 0x01, // "ò (U+0022 U+00F2)
  0x00, 0x22, 0x00, 0xF3, 0x01, // "ó (U+0022 U+00F3)
  0x00, 0x22, 0x00, 0xF4, 0x01, // "ô (U+0022 U+00F4)
  0x00, 0x22, 0x00, 0xF5, 0x01, // "õ (U+0022 U+00F5)
  0x00, 0x22, 0x00, 0xF6, 0x01, // "ö (U+0022 U+00F6)
  0x00, 0x22, 0x00, 0xF8, 0x01, // "ø (U+0022 U+00F8)
  0x00, 0x22, 0x01, 0x00, 0x05, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x02, 0x05, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x04, 0x05, // "Ą (U+0022 U+0104)
  0x00, 0x22, 0x01, 0x07, 0x01, // "ć (U+0022 U+0107)
  0x00, 0x22, 0x01, 0x09, 0x01, // "ĉ (U+0022 U+0109)
  0x00, 0x22, 0x01, 0x0B, 0x01, // "ċ (U+0022 U+010B)
  0x00, 0x22, 0x01, 0x0D, 0x01, // "č (U+0022 U+010D)
  0x00, 0x22, 0x01, 0x0F, 0x01, // "ď (U+0022 U+010F)
  0x00, 0x22, 0x01, 0x11, 0x01, // "đ (U+0022 U+0111)
  0x00, 0x22, 0x01, 0x13, 0x01, // "ē (U+0022 U+0113)
  0x00, 0x22, 0x01, 0x15, 0x01, // "ĕ (U+0022 U+0115)
  0x00, 0x22, 0x01, 0x17, 0x01, // "ė (U+0022 U+0117)
  0x00, 0x22, 0x01, 0x19, 0x01, // "ę (U+0022 U+0119)
  0x00, 0x22, 0x01, 0x1B, 0x01, // "ě (U+0022 U+011B)
  0x00, 0x22, 0x01, 0x1D, 0x01, // "ĝ (U+0022 U+011D)
  0x00, 0x22, 0x01, 0x1F, 0x01, // "ğ (U+0022 U+011F)
  0x00, 0x22, 0x01, 0x21, 0x01, // "ġ (U+0022 U+0121)
  0x00, 0x22, 0x01, 0x23, 0x01, // "ģ (U+0022 U+0123)
  0x00, 0x22, 0x01, 0x4D, 0x01, // "ō (U+0022 U+014D)
  0x00, 0x22, 0x01, 0x4F, 0x01, // "ŏ (U+0022 U+014F)
  0x00, 0x22, 0x01, 0x51, 0x01, // "ő (U+0022 U+0151)
  0x00, 0x22, 0x01, 0x53, 0x01, // "œ (U+0022 U+0153)
  0x00, 0x26, 0x00, 0x3F, 0x02, // &? (U+0026 U+003F)
  0x00, 0x26, 0x00, 0x54, 0x02, // &T (U+0026 U+0054)
  0x00, 0x26, 0x00, 0x56, 0x02, // &V (U+0026 U+0056)
  0x00, 0x26, 0x00, 0x57, 0x02, // &W (U+0026 U+0057)
  0x00, 0x26, 0x00, 0x59, 0x02, // &Y (U+0026 U+0059)
  0x00, 0x26, 0x00, 0xDD, 0x02, // &Ý (U+0026 U+00DD)
  0x00, 0x26, 0x01, 0x62, 0x02, // &Ţ (U+0026 U+0162)
  0x00, 0x26, 0x01, 0x64, 0x02, // &Ť (U+0026 U+0164)
  0x00, 0x26, 0x01, 0x66, 0x02, // &Ŧ (U+0026 U+0166)
  0x00, 0x26, 0x01, 0x74, 0x02, // &Ŵ (U+0026 U+0174)
  0x00, 0x26, 0x01, 0x76, 0x02, // &Ŷ (U+0026 U+0176)
  0x00, 0x26, 0x01, 0x78, 0x02, // &Ÿ (U+0026 U+0178)
  0x00, 0x27, 0x00, 0x41, 0x05, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0x63, 0x01, // 'c (U+0027 U+0063)
  0x00, 0x27, 0x00, 0x64, 0x01, // 'd (U+0027 U+0064)
  0x00, 0x27, 0x00, 0x65, 0x01, // 'e (U+0027 U+0065)
  0x00, 0x27, 0x00, 0x67, 0x02, // 'g (U+0027 U+0067)
  0x00, 0x27, 0x00, 0x6F, 0x01, // 'o (U+0027 U+006F)
  0x00, 0x27, 0x00, 0x71, 0x01, // 'q (U+0027 U+0071)
  0x00, 0x27, 0x00, 0xC0, 0x05, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x05, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x05, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x05, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x05, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x05, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xC6, 0x07, // 'Æ (U+0027 U+00C6)
  0x00, 0x27, 0x00, 0xE7, 0x01, // 'ç (U+0027 U+00E7)
  0x00, 0x27, 0x00, 0xE8, 0x01, // 'è (U+0027 U+00E8)
  0x00, 0x27, 0x00, 0xE9, 0x01, // 'é (U+0027 U+00E9)
  0x00, 0x27, 0x00, 0xEA, 0x01, // 'ê (U+0027 U+00EA)
  0x00, 0x27, 0x00, 0xEB, 0x01, // 'ë (U+0027 U+00EB)
  0x00, 0x27, 0x00, 0xF0, 0x01, // 'ð (U+0027 U+00F0)
  0x00, 0x27, 0x00, 0xF2, 0x01, // 'ò (U+0027 U+00F2)
  0x00, 0x27, 0x00, 0xF3, 0x01, // 'ó (U+0027 U+00F3)
  0x00, 0x27, 0x00, 0xF4, 0x01, // 'ô (U+0027 U+00F4)
  0x00, 0x27, 0x00, 0xF5, 0x01, // 'õ (U+0027 U+00F5)
  0x00, 0x27, 0x00, 0xF6, 0x01, // 'ö (U+0027 U+00F6)
  0x00, 0x27, 0x00, 0xF8, 0x01, // 'ø (U+0027 U+00F8)
  0x00, 0x27, 0x01, 0x00, 0x05, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x02, 0x05, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x04, 0x05, // 'Ą (U+0027 U+0104)
  0x00, 0x27, 0x01, 0x07, 0x01, // 'ć (U+0027 U+0107)
  0x00, 0x27, 0x01, 0x09, 0x01, // 'ĉ (U+0027 U+0109)
  0x00, 0x27, 0x01, 0x0B, 0x01, // 'ċ (U+0027 U+010B)
  0x00, 0x27, 0x01, 0x0D, 0x01, // 'č (U+0027 U+010D)
  0x00, 0x27, 0x01, 0x0F, 0x01, // 'ď (U+0027 U+010F)
  0x00, 0x27, 0x01, 0x11, 0x01, // 'đ (U+0027 U+0111)
  0x00, 0x27, 0x01, 0x13, 0x01, // 'ē (U+0027 U+0113)
  0x00, 0x27, 0x01, 0x15, 0x01, // 'ĕ (U+0027 U+0115)
  0x00, 0x27, 0x01, 0x17, 0x01, // 'ė (U+0027 U+0117)
  0x00, 0x27, 0x01, 0x19, 0x01, // 'ę (U+0027 U+0119)
  0x00, 0x27, 0x01, 0x1B, 0x01, // 'ě (U+0027 U+011B)
  0x00, 0x27, 0x01, 0x1D, 0x01, // 'ĝ (U+0027 U+011D)
  0x00, 0x27, 0x01, 0x1F, 0x01, // 'ğ (U+0027 U+011F)
  0x00, 0x27, 0x01, 0x21, 0x01, // 'ġ (U+0027 U+0121)
  0x00, 0x27, 0x01, 0x23, 0x01, // 'ģ (U+0027 U+0123)
  0x00, 0x27, 0x01, 0x4D, 0x01, // 'ō (U+0027 U+014D)
  0x00, 0x27, 0x01, 0x4F, 0x01, // 'ŏ (U+0027 U+014F)
  0x00, 0x27, 0x01, 0x51, 0x01, // 'ő (U+0027 U+0151)
  0x00, 0x27, 0x01, 0x53, 0x01, // 'œ (U+0027 U+0153)
  0x00, 0x2A, 0x00, 0x26, 0x01, // *& (U+002A U+0026)
  0x00, 0x2A, 0x00, 0x2C, 0x06, // *, (U+002A U+002C)
  0x00, 0x2A, 0x00, 0x2E, 0x06, // *. (U+002A U+002E)
  0x00, 0x2A, 0x00, 0x41, 0x03, // *A (U+002A U+0041)
  0x00, 0x2A, 0x00, 0xC0, 0x03, // *À (U+002A U+00C0)
  0x00, 0x2A, 0x00, 0xC1, 0x03, // *Á (U+002A U+00C1)
  0x00, 0x2A, 0x00, 0xC2, 0x03, // *Â (U+002A U+00C2)
  0x00, 0x2A, 0x00, 0xC3, 0x03, // *Ã (U+002A U+00C3)
  0x00, 0x2A, 0x00, 0xC4, 0x03, // *Ä (U+002A U+00C4)
  0x00, 0x2A, 0x00, 0xC5, 0x03, // *Å (U+002A U+00C5)
  0x00, 0x2A, 0x00, 0xC6, 0x05, // *Æ (U+002A U+00C6)
  0x00, 0x2A, 0x01, 0x00, 0x03, // *Ā (U+002A U+0100)
  0x00, 0x2A, 0x01, 0x02, 0x03, // *Ă (U+002A U+0102)
  0x00, 0x2A, 0x01, 0x04, 0x03, // *Ą (U+002A U+0104)
  0x00, 0x2A, 0x20, 0x1A, 0x06, // *‚ (U+002A U+201A)
  0x00, 0x2A, 0x20, 0x1E, 0x06, // *„ (U+002A U+201E)
  0x00, 0x2A, 0x20, 0x26, 0x06, // *… (U+002A U+2026)
  0x00, 0x2C, 0x00, 0x3F, 0x04, // ,? (U+002C U+003F)
  0x00, 0x2C, 0x00, 0x43, 0x01, // ,C (U+002C U+0043)
  0x00, 0x2C, 0x00, 0x47, 0x01, // ,G (U+002C U+0047)
  0x00, 0x2C, 0x00, 0x4F, 0x01, // ,O (U+002C U+004F)
  0x00, 0x2C, 0x00, 0x51, 0x01, // ,Q (U+002C U+0051)
  0x00, 0x2C, 0x00, 0x54, 0x04, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x55, 0x01, // ,U (U+002C U+0055)
  0x00, 0x2C, 0x00, 0x56, 0x06, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x05, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x04, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0x75, 0x01, // ,u (U+002C U+0075)
  0x00, 0x2C, 0x00, 0x76, 0x04, // ,v (U+002C U+0076)
  0x00, 0x2C, 0x00, 0x77, 0x03, // ,w (U+002C U+0077)
  0x00, 0x2C, 0x00, 0x79, 0x03, // ,y (U+002C U+0079)
  0x00, 0x2C, 0x00, 0xC7, 0x01, // ,Ç (U+002C U+00C7)
  0x00, 0x2C, 0x00, 0xD2, 0x01, // ,Ò (U+002C U+00D2)
  0x00, 0x2C, 0x00, 0xD3, 0x01, // ,Ó (U+002C U+00D3)
  0x00, 0x2C, 0x00, 0xD4, 0x01, // ,Ô (U+002C U+00D4)
  0x00, 0x2C, 0x00, 0xD5, 0x01, // ,Õ (U+002C U+00D5)
  0x00, 0x2C, 0x00, 0xD6, 0x01, // ,Ö (U+002C U+00D6)
  0x00, 0x2C, 0x00, 0xD8, 0x01, // ,Ø (U+002C U+00D8)
  0x00, 0x2C, 0x00, 0xD9, 0x01, // ,Ù (U+002C U+00D9)
  0x00, 0x2C, 0x00, 0xDA, 0x01, // ,Ú (U+002C U+00DA)
  0x00, 0x2C, 0x00, 0xDB, 0x01, // ,Û (U+002C U+00DB)
  0x00, 0x2C, 0x00, 0xDC, 0x01, // ,Ü (U+002C U+00DC)
  0x00, 0x2C, 0x00, 0xDD, 0x04, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x00, 0xF9, 0x01, // ,ù (U+002C U+00F9)
  0x00, 0x2C, 0x00, 0xFA, 0x01, // ,ú (U+002C U+00FA)
  0x00, 0x2C, 0x00, 0xFB, 0x01, // ,û (U+002C U+00FB)
  0x00, 0x2C, 0x00, 0xFC, 0x01, // ,ü (U+002C U+00FC)
  0x00, 0x2C, 0x00, 0xFD, 0x03, // ,ý (U+002C U+00FD)
  0x00, 0x2C, 0x00, 0xFF, 0x03, // ,ÿ (U+002C U+00FF)
  0x00, 0x2C, 0x01, 0x06, 0x01, // ,Ć (U+002C U+0106)
  0x00, 0x2C, 0x01, 0x08, 0x01, // ,Ĉ (U+002C U+0108)
  0x00, 0x2C, 0x01, 0x0A, 0x01, // ,Ċ (U+002C U+010A)
  0x00, 0x2C, 0x01, 0x0C, 0x01, // ,Č (U+002C U+010C)
  0x00, 0x2C, 0x01, 0x1C, 0x01, // ,Ĝ (U+002C U+011C)
  0x00, 0x2C, 0x01, 0x1E, 0x01, // ,Ğ (U+002C U+011E)
  0x00, 0x2C, 0x01, 0x20, 0x01, // ,Ġ (U+002C U+0120)
  0x00, 0x2C, 0x01, 0x22, 0x01, // ,Ģ (U+002C U+0122)
  0x00, 0x2C, 0x01, 0x4C, 0x01, // ,Ō (U+002C U+014C)
  0x00, 0x2C, 0x01, 0x4E, 0x01, // ,Ŏ (U+002C U+014E)
  0x00, 0x2C, 0x01, 0x50, 0x01, // ,Ő (U+002C U+0150)
  0x00, 0x2C, 0x01, 0x52, 0x01, // ,Œ (U+002C U+0152)
  0x00, 0x2C, 0x01, 0x62, 0x04, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x04, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x04, // ,Ŧ (U+002C U+0166)
  0x00, 0x2C, 0x01, 0x68, 0x01, // ,Ũ (U+002C U+0168)
  0x00, 0x2C, 0x01, 0x69, 0x01, // ,ũ (U+002C U+0169)
  0x00, 0x2C, 0x01, 0x6A, 0x01, // ,Ū (U+002C U+016A)
  0x00, 0x2C, 0x01, 0x6B, 0x01, // ,ū (U+002C U+016B)
  0x00, 0x2C, 0x01, 0x6C, 0x01, // ,Ŭ (U+002C U+016C)
  0x00, 0x2C, 0x01, 0x6D, 0x01, // ,ŭ (U+002C U+016D)
  0x00, 0x2C, 0x01, 0x6E, 0x01, // ,Ů (U+002C U+016E)
  0x00, 0x2C, 0x01, 0x6F, 0x01, // ,ů (U+002C U+016F)
  0x00, 0x2C, 0x01, 0x70, 0x01, // ,Ű (U+002C U+0170)
  0x00, 0x2C, 0x01, 0x71, 0x01, // ,ű (U+002C U+0171)
  0x00, 0x2C, 0x01, 0x72, 0x01, // ,Ų (U+002C U+0172)
  0x00, 0x2C, 0x01, 0x73, 0x01, // ,ų (U+002C U+0173)
  0x00, 0x2C, 0x01, 0x74, 0x05, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x75, 0x03, // ,ŵ (U+002C U+0175)
  0x00, 0x2C, 0x01, 0x76, 0x04, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x77, 0x03, // ,ŷ (U+002C U+0177)
  0x00, 0x2C, 0x01, 0x78, 0x04, // ,Ÿ (U+002C U+0178)
  0x00, 0x2E, 0x00, 0x3F, 0x04, // .? (U+002E U+003F)
  0x00, 0x2E, 0x00, 0x43, 0x01, // .C (U+002E U+0043)
  0x00, 0x2E, 0x00, 0x47, 0x01, // .G (U+002E U+0047)
  0x00, 0x2E, 0x00, 0x4F, 0x01, // .O (U+002E U+004F)
  0x00, 0x2E, 0x00, 0x51, 0x01, // .Q (U+002E U+0051)
  0x00, 0x2E, 0x00, 0x54, 0x04, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x55, 0x01, // .U (U+002E U+0055)
  0x00, 0x2E, 0x00, 0x56, 0x06, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x05, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x04, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0x75, 0x01, // .u (U+002E U+0075)
  0x00, 0x2E, 0x00, 0x76, 0x04, // .v (U+002E U+0076)
  0x00, 0x2E, 0x00, 0x77, 0x03, // .w (U+002E U+0077)
  0x00, 0x2E, 0x00, 0x79, 0x03, // .y (U+002E U+0079)
  0x00, 0x2E, 0x00, 0xC7, 0x01, // .Ç (U+002E U+00C7)
  0x00, 0x2E, 0x00, 0xD2, 0x01, // .Ò (U+002E U+00D2)
  0x00, 0x2E, 0x00, 0xD3, 0x01, // .Ó (U+002E U+00D3)
  0x00, 0x2E, 0x00, 0xD4, 0x01, // .Ô (U+002E U+00D4)
  0x00, 0x2E, 0x00, 0xD5, 0x01, // .Õ (U+002E U+00D5)
  0x00, 0x2E, 0x00, 0xD6, 0x01, // .Ö (U+002E U+00D6)
  0x00, 0x2E, 0x00, 0xD8, 0x01, // .Ø (U+002E U+00D8)
  0x00, 0x2E, 0x00, 0xD9, 0x01, // .Ù (U+002E U+00D9)
  0x00, 0x2E, 0x00, 0xDA, 0x01, // .Ú (U+002E U+00DA)
  0x00, 0x2E, 0x00, 0xDB, 0x01, // .Û (U+002E U+00DB)
  0x00, 0x2E, 0x00, 0xDC, 0x01, // .Ü (U+002E U+00DC)
  0x00, 0x2E, 0x00, 0xDD, 0x04, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x00, 0xF9, 0x01, // .ù (U+002E U+00F9)
  0x00, 0x2E, 0x00, 0xFA, 0x01, // .ú (U+002E U+00FA)
  0x00, 0x2E, 0x00, 0xFB, 0x01, // .û (U+002E U+00FB)
  0x00, 0x2E, 0x00, 0xFC, 0x01, // .ü (U+002E U+00FC)
  0x00, 0x2E, 0x00, 0xFD, 0x03, // .ý (U+002E U+00FD)
  0x00, 0x2E, 0x00, 0xFF, 0x03, // .ÿ (U+002E U+00FF)
  0x00, 0x2E, 0x01, 0x06, 0x01, // .Ć (U+002E U+0106)
  0x00, 0x2E, 0x01, 0x08, 0x01, // .Ĉ (U+002E U+0108)
  0x00, 0x2E, 0x01, 0x0A, 0x01, // .Ċ (U+002E U+010A)
  0x00, 0x2E, 0x01, 0x0C, 0x01, // .Č (U+002E U+010C)
  0x00, 0x2E, 0x01, 0x1C, 0x01, // .Ĝ (U+002E U+011C)
  0x00, 0x2E, 0x01, 0x1E, 0x01, // .Ğ (U+002E U+011E)
  0x00, 0x2E, 0x01, 0x20, 0x01, // .Ġ (U+002E U+0120)
  0x00, 0x2E, 0x01, 0x22, 0x01, // .Ģ (U+002E U+0122)
  0x00, 0x2E, 0x01, 0x4C, 0x01, // .Ō (U+002E U+014C)
  0x00, 0x2E, 0x01, 0x4E, 0x01, // .Ŏ (U+002E U+014E)
  0x00, 0x2E, 0x01, 0x50, 0x01, // .Ő (U+002E U+0150)
  0x00, 0x2E, 0x01, 0x52, 0x01, // .Œ (U+002E U+0152)
  0x00, 0x2E, 0x01, 0x62, 0x04, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x04, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x04, // .Ŧ (U+002E U+0166)
  0x00, 0x2E, 0x01, 0x68, 0x01, // .Ũ (U+002E U+0168)
  0x00, 0x2E, 0x01, 0x69, 0x01, // .ũ (U+002E U+0169)
  0x00, 0x2E, 0x01, 0x6A, 0x01, // .Ū (U+002E U+016A)
  0x00, 0x2E, 0x01, 0x6B, 0x01, // .ū (U+002E U+016B)
  0x00, 0x2E, 0x01, 0x6C, 0x01, // .Ŭ (U+002E U+016C)
  0x00, 0x2E, 0x01, 0x6D, 0x01, // .ŭ (U+002E U+016D)
  0x00, 0x2E, 0x01, 0x6E, 0x01, // .Ů (U+002E U+016E)
  0x00, 0x2E, 0x01, 0x6F, 0x01, // .ů (U+002E U+016F)
  0x00, 0x2E, 0x01, 0x70, 0x01, // .Ű (U+002E U+0170)
  0x00, 0x2E, 0x01, 0x71, 0x01, // .ű (U+002E U+0171)
  0x00, 0x2E, 0x01, 0x72, 0x01, // .Ų (U+002E U+0172)
  0x00, 0x2E, 0x01, 0x73, 0x01, // .ų (U+002E U+0173)
  0x00, 0x2E, 0x01, 0x74, 0x05, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x75, 0x03, // .ŵ (U+002E U+0175)
  0x00, 0x2E, 0x01, 0x76, 0x04, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x77, 0x03, // .ŷ (U+002E U+0177)
  0x00, 0x2E, 0x01, 0x78, 0x04, // .Ÿ (U+002E U+0178)
  0x00, 0x40, 0x00, 0x41, 0x02, // @A (U+0040 U+0041)
  0x00, 0x40, 0x00, 0x59, 0x01, // @Y (U+0040 U+0059)
  0x00, 0x40, 0x00, 0xC0, 0x02, // @À (U+0040 U+00C0)
  0x00, 0x40, 0x00, 0xC1, 0x02, // @Á (U+0040 U+00C1)
  0x00, 0x40, 0x00, 0xC2, 0x02, // @Â (U+0040 U+00C2)
  0x00, 0x40, 0x00, 0xC3, 0x02, // @Ã (U+0040 U+00C3)
  0x00, 0x40, 0x00, 0xC4, 0x02, // @Ä (U+0040 U+00C4)
  0x00, 0x40, 0x00, 0xC5, 0x02, // @Å (U+0040 U+00C5)
  0x00, 0x40, 0x00, 0xDD, 0x01, // @Ý (U+0040 U+00DD)
  0x00, 0x40, 0x01, 0x00, 0x02, // @Ā (U+0040 U+0100)
  0x00, 0x40, 0x01, 0x02, 0x02, // @Ă (U+0040 U+0102)
  0x00, 0x40, 0x01, 0x04, 0x02, // @Ą (U+0040 U+0104)
  0x00, 0x40, 0x01, 0x76, 0x01, // @Ŷ (U+0040 U+0176)
  0x00, 0x40, 0x01, 0x78, 0x01, // @Ÿ (U+0040 U+0178)
  0x00, 0x41, 0x00, 0x22, 0x05, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x05, // A' (U+0041 U+0027)
  0x00, 0x41, 0x00, 0x2A, 0x04, // A* (U+0041 U+002A)
  0x00, 0x41, 0x00, 0x3F, 0x03, // A? (U+0041 U+003F)
  0x00, 0x41, 0x00, 0x43, 0x01, // AC (U+0041 U+0043)
  0x00, 0x41, 0x00, 0x47, 0x01, // AG (U+0041 U+0047)
  0x00, 0x41, 0x00, 0x4F, 0x01, // AO (U+0041 U+004F)
  0x00, 0x41, 0x00, 0x51, 0x01, // AQ (U+0041 U+0051)
  0x00, 0x41, 0x00, 0x54, 0x03, // AT (U+0041 U+0054)
  0x00, 0x41, 0x00, 0x55, 0x01, // AU (U+0041 U+0055)
  0x00, 0x41, 0x00, 0x56, 0x04, // AV (U+0041 U+0056)
  0x00, 0x41, 0x00, 0x57, 0x03, // AW (U+0041 U+0057)
  0x00, 0x41, 0x00, 0x59, 0x03, // AY (U+0041 U+0059)
  0x00, 0x41, 0x00, 0x63, 0x01, // Ac (U+0041 U+0063)
  0x00, 0x41, 0x00, 0x64, 0x01, // Ad (U+0041 U+0064)
  0x00, 0x41, 0x00, 0x65, 0x01, // Ae (U+0041 U+0065)
  0x00, 0x41, 0x00, 0x67, 0x01, // Ag (U+0041 U+0067)
  0x00, 0x41, 0x00, 0x6F, 0x01, // Ao (U+0041 U+006F)
  0x00, 0x41, 0x00, 0x71, 0x01, // Aq (U+0041 U+0071)
  0x00, 0x41, 0x00, 0x75, 0x01, // Au (U+0041 U+0075)
  0x00, 0x41, 0x00, 0x76, 0x03, // Av (U+0041 U+0076)
  0x00, 0x41, 0x00, 0x77, 0x02, // Aw (U+0041 U+0077)
  0x00, 0x41, 0x00, 0x79, 0x03, // Ay (U+0041 U+0079)
  0x00, 0x41, 0x00, 0xC7, 0x01, // AÇ (U+0041 U+00C7)
  0x00, 0x41, 0x00, 0xD2, 0x01, // AÒ (U+0041 U+00D2)
  0x00, 0x41, 0x00, 0xD3, 0x01, // AÓ (U+0041 U+00D3)
  0x00, 0x41, 0x00, 0xD4, 0x01, // AÔ (U+0041 U+00D4)
  0x00, 0x41, 0x00, 0xD5, 0x01, // AÕ (U+0041 U+00D5)
  0x00, 0x41, 0x00, 0xD6, 0x01, // AÖ (U+0041 U+00D6)
  0x00, 0x41, 0x00, 0xD8, 0x01, // AØ (U+0041 U+00D8)
  0x00, 0x41, 0x00, 0xD9, 0x01, // AÙ (U+0041 U+00D9)
  0x00, 0x41, 0x00, 0xDA, 0x01, // AÚ (U+0041 U+00DA)
  0x00, 0x41, 0x00, 0xDB, 0x01, // AÛ (U+0041 U+00DB)
  0x00, 0x41, 0x00, 0xDC, 0x01, // AÜ (U+0041 U+00DC)
  0x00, 0x41, 0x00, 0xDD, 0x03, // AÝ (U+0041 U+00DD)
  0x00, 0x41, 0x00, 0xE7, 0x01, // Aç (U+0041 U+00E7)
  0x00, 0x41, 0x00, 0xE8, 0x01, // Aè (U+0041 U+00E8)
  0x00, 0x41, 0x00, 0xE9, 0x01, // Aé (U+0041 U+00E9)
  0x00, 0x41, 0x00, 0xEA, 0x01, // Aê (U+0041 U+00EA)
  0x00, 0x41, 0x00, 0xEB, 0x01, // Aë (U+0041 U+00EB)
  0x00, 0x41, 0x00, 0xF0, 0x01, // Að (U+0041 U+00F0)
  0x00, 0x41, 0x00, 0xF2, 0x01, // Aò (U+0041 U+00F2)
  0x00, 0x41, 0x00, 0xF3, 0x01, // Aó (U+0041 U+00F3)
  0x00, 0x41, 0x00, 0xF4, 0x01, // Aô (U+0041 U+00F4)
  0x00, 0x41, 0x00, 0xF5, 0x01, // Aõ (U+0041 U+00F5)
  0x00, 0x41, 0x00, 0xF6, 0x01, // Aö (U+0041 U+00F6)
  0x00, 0x41, 0x00, 0xF8, 0x01, // Aø (U+0041 U+00F8)
  0x00, 0x41, 0x00, 0xF9, 0x01, // Aù (U+0041 U+00F9)
  0x00, 0x41, 0x00, 0xFA, 0x01, // Aú (U+0041 U+00FA)
  0x00, 0x41, 0x00, 0xFB, 0x01, // Aû (U+0041 U+00FB)
  0x00, 0x41, 0x00, 0xFC, 0x01, // Aü (U+0041 U+00FC)
  0x00, 0x41, 0x00, 0xFD, 0x03, // Aý (U+0041 U+00FD)
  0x00, 0x41, 0x00, 0xFF, 0x03, // Aÿ (U+0041 U+00FF)
  0x00, 0x41, 0x01, 0x06, 0x01, // AĆ (U+0041 U+0106)
  0x00, 0x41, 0x01, 0x07, 0x01, // Ać (U+0041 U+0107)
  0x00, 0x41, 0x01, 0x08, 0x01, // AĈ (U+0041 U+0108)
  0x00, 0x41, 0x01, 0x09, 0x01, // Aĉ (U+0041 U+0109)
  0x00, 0x41, 0x01, 0x0A, 0x01, // AĊ (U+0041 U+010A)
  0x00, 0x41, 0x01, 0x0B, 0x01, // Aċ (U+0041 U+010B)
  0x00, 0x41, 0x01, 0x0C, 0x01, // AČ (U+0041 U+010C)
  0x00, 0x41, 0x01, 0x0D, 0x01, // Ač (U+0041 U+010D)
  0x00, 0x41, 0x01, 0x0F, 0x01, // Aď (U+0041 U+010F)
  0x00, 0x41, 0x01, 0x11, 0x01, // Ađ (U+0041 U+0111)
  0x00, 0x41, 0x01, 0x13, 0x01, // Aē (U+0041 U+0113)
  0x00, 0x41, 0x01, 0x15, 0x01, // Aĕ (U+0041 U+0115)
  0x00, 0x41, 0x01, 0x17, 0x01, // Aė (U+0041 U+0117)
  0x00, 0x41, 0x01, 0x19, 0x01, // Aę (U+0041 U+0119)
  0x00, 0x41, 0x01, 0x1B, 0x01, // Aě (U+0041 U+011B)
  0x00, 0x41, 0x01, 0x1C, 0x01, // AĜ (U+0041 U+011C)
  0x00, 0x41, 0x01, 0x1D, 0x01, // Aĝ (U+0041 U+011D)
  0x00, 0x41, 0x01, 0x1E, 0x01, // AĞ (U+0041 U+011E)
  0x00, 0x41, 0x01, 0x1F, 0x01, // Ağ (U+0041 U+011F)
  0x00, 0x41, 0x01, 0x20, 0x01, // AĠ (U+0041 U+0120)
  0x00, 0x41, 0x01, 0x21, 0x01, // Aġ (U+0041 U+0121)
  0x00, 0x41, 0x01, 0x22, 0x01, // AĢ (U+0041 U+0122)
  0x00, 0x41, 0x01, 0x23, 0x01, // Aģ (U+0041 U+0123)
  0x00, 0x41, 0x01, 0x4C, 0x01, // AŌ (U+0041 U+014C)
  0x00, 0x41, 0x01, 0x4D, 0x01, // Aō (U+0041 U+014D)
  0x00, 0x41, 0x01, 0x4E, 0x01, // AŎ (U+0041 U+014E)
  0x00, 0x41, 0x01, 0x4F, 0x01, // Aŏ (U+0041 U+014F)
  0x00, 0x41, 0x01, 0x50, 0x01, // AŐ (U+0041 U+0150)
  0x00, 0x41, 0x01, 0x51, 0x01, // Aő (U+0041 U+0151)
  0x00, 0x41, 0x01, 0x52, 0x01, // AŒ (U+0041 U+0152)
  0x00, 0x41, 0x01, 0x53, 0x01, // Aœ (U+0041 U+0153)
  0x00, 0x41, 0x01, 0x62, 0x03, // AŢ (U+0041 U+0162)
  0x00, 0x41, 0x01, 0x64, 0x03, // AŤ (U+0041 U+0164)
  0x00, 0x41, 0x01, 0x66, 0x03, // AŦ (U+0041 U+0166)
  0x00, 0x41, 0x01, 0x68, 0x01, // AŨ (U+0041 U+0168)
  0x00, 0x41, 0x01, 0x69, 0x01, // Aũ (U+0041 U+0169)
  0x00, 0x41, 0x01, 0x6A, 0x01, // AŪ (U+0041 U+016A)
  0x00, 0x41, 0x01, 0x6B, 0x01, // Aū (U+0041 U+016B)
  0x00, 0x41, 0x01, 0x6C, 0x01, // AŬ (U+0041 U+016C)
  0x00, 0x41, 0x01, 0x6D, 0x01, // Aŭ (U+0041 U+016D)
  0x00, 0x41, 0x01, 0x6E, 0x01, // AŮ (U+0041 U+016E)
  0x00, 0x41, 0x01, 0x6F, 0x01, // Aů (U+0041 U+016F)
  0x00, 0x41, 0x01, 0x70, 0x01, // AŰ (U+0041 U+0170)
  0x00, 0x41, 0x01, 0x71, 0x01, // Aű (U+0041 U+0171)
  0x00, 0x41, 0x01, 0x72, 0x01, // AŲ (U+0041 U+0172)
  0x00, 0x41, 0x01, 0x73, 0x01, // Aų (U+0041 U+0173)
  0x00, 0x41, 0x01, 0x74, 0x03, // AŴ (U+0041 U+0174)
  0x00, 0x41, 0x01, 0x75, 0x02, // Aŵ (U+0041 U+0175)
  0x00, 0x41, 0x01, 0x76, 0x03, // AŶ (U+0041 U+0176)
  0x00, 0x41, 0x01, 0x77, 0x03, // Aŷ (U+0041 U+0177)
  0x00, 0x41, 0x01, 0x78, 0x03, // AŸ (U+0041 U+0178)
  0x00, 0x41, 0x20, 0x18, 0x04, // A‘ (U+0041 U+2018)
  0x00, 0x41, 0x20, 0x19, 0x04, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1C, 0x04, // A“ (U+0041 U+201C)
  0x00, 0x41, 0x20, 0x1D, 0x04, // A” (U+0041 U+201D)
  0x00, 0x41, 0x21, 0x22, 0x04, // A™ (U+0041 U+2122)
  0x00, 0x42, 0x00, 0x2A, 0x01, // B* (U+0042 U+002A)
  0x00, 0x42, 0x00, 0x3F, 0x01, // B? (U+0042 U+003F)
  0x00, 0x42, 0x00, 0x41, 0x01, // BA (U+0042 U+0041)
  0x00, 0x42, 0x00, 0x54, 0x01, // BT (U+0042 U+0054)
  0x00, 0x42, 0x00, 0x56, 0x02, // BV (U+0042 U+0056)
  0x00, 0x42, 0x00, 0x57, 0x01, // BW (U+0042 U+0057)
  0x00, 0x42, 0x00, 0x58, 0x01, // BX (U+0042 U+0058)
  0x00, 0x42, 0x00, 0x59, 0x02, // BY (U+0042 U+0059)
  0x00, 0x42, 0x00, 0x5A, 0x01, // BZ (U+0042 U+005A)
  0x00, 0x42, 0x00, 0x77, 0x01, // Bw (U+0042 U+0077)
  0x00, 0x42, 0x00, 0x79, 0x01, // By (U+0042 U+0079)
  0x00, 0x42, 0x00, 0xC0, 0x01, // BÀ (U+0042 U+00C0)
  0x00, 0x42, 0x00, 0xC1, 0x01, // BÁ (U+0042 U+00C1)
  0x00, 0x42, 0x00, 0xC2, 0x01, // BÂ (U+0042 U+00C2)
  0x00, 0x42, 0x00, 0xC3, 0x01, // BÃ (U+0042 U+00C3)
  0x00, 0x42, 0x00, 0xC4, 0x01, // BÄ (U+0042 U+00C4)
  0x00, 0x42, 0x00, 0xC5, 0x01, // BÅ (U+0042 U+00C5)
  0x00, 0x42, 0x00, 0xC6, 0x02, // BÆ (U+0042 U+00C6)
  0x00, 0x42, 0x00, 0xDD, 0x02, // BÝ (U+0042 U+00DD)
  0x00, 0x42, 0x00, 0xFD, 0x01, // Bý (U+0042 U+00FD)
  0x00, 0x42, 0x00, 0xFF, 0x01, // Bÿ (U+0042 U+00FF)
  0x00, 0x42, 0x01, 0x00, 0x01, // BĀ (U+0042 U+0100)
  0x00, 0x42, 0x01, 0x02, 0x01, // BĂ (U+0042 U+0102)
  0x00, 0x42, 0x01, 0x04, 0x01, // BĄ (U+0042 U+0104)
  0x00, 0x42, 0x01, 0x62, 0x01, // BŢ (U+0042 U+0162)
  0x00, 0x42, 0x01, 0x64, 0x01, // BŤ (U+0042 U+0164)
  0x00, 0x42, 0x01, 0x66, 0x01, // BŦ (U+0042 U+0166)
  0x00, 0x42, 0x01, 0x74, 0x01, // BŴ (U+0042 U+0174)
  0x00, 0x42, 0x01, 0x75, 0x01, // Bŵ (U+0042 U+0175)
  0x00, 0x42, 0x01, 0x76, 0x02, // BŶ (U+0042 U+0176)
  0x00, 0x42, 0x01, 0x77, 0x01, // Bŷ (U+0042 U+0177)
  0x00, 0x42, 0x01, 0x78, 0x02, // BŸ (U+0042 U+0178)
  0x00, 0x42, 0x01, 0x79, 0x01, // BŹ (U+0042 U+0179)
  0x00, 0x42, 0x01, 0x7B, 0x01, // BŻ (U+0042 U+017B)
  0x00, 0x42, 0x01, 0x7D, 0x01, // BŽ (U+0042 U+017D)
  0x00, 0x42, 0x20, 0x19, 0x01, // B’ (U+0042 U+2019)
  0x00, 0x42, 0x20, 0x1D, 0x01, // B” (U+0042 U+201D)
  0x00, 0x42, 0x21, 0x22, 0x01, // B™ (U+0042 U+2122)
  0x00, 0x44, 0x00, 0x2C, 0x01, // D, (U+0044 U+002C)
  0x00, 0x44, 0x00, 0x2E, 0x01, // D. (U+0044 U+002E)
  0x00, 0x44, 0x00, 0x3F, 0x01, // D? (U+0044 U+003F)
  0x00, 0x44, 0x00, 0x41, 0x01, // DA (U+0044 U+0041)
  0x00, 0x44, 0x00, 0x54, 0x01, // DT (U+0044 U+0054)
  0x00, 0x44, 0x00, 0x56, 0x01, // DV (U+0044 U+0056)
  0x00, 0x44, 0x00, 0x57, 0x01, // DW (U+0044 U+0057)
  0x00, 0x44, 0x00, 0x58, 0x01, // DX (U+0044 U+0058)
  0x00, 0x44, 0x00, 0x59, 0x02, // DY (U+0044 U+0059)
  0x00, 0x44, 0x00, 0xC0, 0x01, // DÀ (U+0044 U+00C0)
  0x00, 0x44, 0x00, 0xC1, 0x01, // DÁ (U+0044 U+00C1)
  0x00, 0x44, 0x00, 0xC2, 0x01, // DÂ (U+0044 U+00C2)
  0x00, 0x44, 0x00, 0xC3, 0x01, // DÃ (U+0044 U+00C3)
  0x00, 0x44, 0x00, 0xC4, 0x01, // DÄ (U+0044 U+00C4)
  0x00, 0x44, 0x00, 0xC5, 0x01, // DÅ (U+0044 U+00C5)
  0x00, 0x44, 0x00, 0xC6, 0x03, // DÆ (U+0044 U+00C6)
  0x00, 0x44, 0x00, 0xDD, 0x02, // DÝ (U+0044 U+00DD)
  0x00, 0x44, 0x01, 0x00, 0x01, // DĀ (U+0044 U+0100)
  0x00, 0x44, 0x01, 0x02, 0x01, // DĂ (U+0044 U+0102)
  0x00, 0x44, 0x01, 0x04, 0x01, // DĄ (U+0044 U+0104)
  0x00, 0x44, 0x01, 0x62, 0x01, // DŢ (U+0044 U+0162)
  0x00, 0x44, 0x01, 0x64, 0x01, // DŤ (U+0044 U+0164)
  0x00, 0x44, 0x01, 0x66, 0x01, // DŦ (U+0044 U+0166)
  0x00, 0x44, 0x01, 0x74, 0x01, // DŴ (U+0044 U+0174)
  0x00, 0x44, 0x01, 0x76, 0x02, // DŶ (U+0044 U+0176)
  0x00, 0x44, 0x01, 0x78, 0x02, // DŸ (U+0044 U+0178)
  0x00, 0x44, 0x20, 0x1A, 0x01, // D‚ (U+0044 U+201A)
  0x00, 0x44, 0x20, 0x1E, 0x01, // D„ (U+0044 U+201E)
  0x00, 0x44, 0x20, 0x26, 0x01, // D… (U+0044 U+2026)
  0x00, 0x45, 0x00, 0x56, 0x01, // EV (U+0045 U+0056)
  0x00, 0x45, 0x00, 0x57, 0x01, // EW (U+0045 U+0057)
  0x00, 0x45, 0x00, 0x59, 0x01, // EY (U+0045 U+0059)
  0x00, 0x45, 0x00, 0xDD, 0x01, // EÝ (U+0045 U+00DD)
  0x00, 0x45, 0x01, 0x74, 0x01, // EŴ (U+0045 U+0174)
  0x00, 0x45, 0x01, 0x76, 0x01, // EŶ (U+0045 U+0176)
  0x00, 0x45, 0x01, 0x78, 0x01, // EŸ (U+0045 U+0178)
  0x00, 0x46, 0x00, 0x26, 0x01, // F& (U+0046 U+0026)
  0x00, 0x46, 0x00, 0x2C, 0x06, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x06, // F. (U+0046 U+002E)
  0x00, 0x46, 0x00, 0x40, 0x02, // F@ (U+0046 U+0040)
  0x00, 0x46, 0x00, 0x41, 0x04, // FA (U+0046 U+0041)
  0x00, 0x46, 0x00, 0x61, 0x02, // Fa (U+0046 U+0061)
  0x00, 0x46, 0x00, 0x63, 0x02, // Fc (U+0046 U+0063)
  0x00, 0x46, 0x00, 0x64, 0x02, // Fd (U+0046 U+0064)
  0x00, 0x46, 0x00, 0x65, 0x02, // Fe (U+0046 U+0065)
  0x00, 0x46, 0x00, 0x67, 0x02, // Fg (U+0046 U+0067)
  0x00, 0x46, 0x00, 0x6F, 0x02, // Fo (U+0046 U+006F)
  0x00, 0x46, 0x00, 0x71, 0x02, // Fq (U+0046 U+0071)
  0x00, 0x46, 0x00, 0xC0, 0x04, // FÀ (U+0046 U+00C0)
  0x00, 0x46, 0x00, 0xC1, 0x04, // FÁ (U+0046 U+00C1)
  0x00, 0x46, 0x00, 0xC2, 0x04, // FÂ (U+0046 U+00C2)
  0x00, 0x46, 0x00, 0xC3, 0x04, // FÃ (U+0046 U+00C3)
  0x00, 0x46, 0x00, 0xC4, 0x04, // FÄ (U+0046 U+00C4)
  0x00, 0x46, 0x00, 0xC5, 0x04, // FÅ (U+0046 U+00C5)
  0x00, 0x46, 0x00, 0xC6, 0x07, // FÆ (U+0046 U+00C6)
  0x00, 0x46, 0x00, 0xE0, 0x02, // Fà (U+0046 U+00E0)
  0x00, 0x46, 0x00, 0xE1, 0x02, // Fá (U+0046 U+00E1)
  0x00, 0x46, 0x00, 0xE2, 0x02, // Fâ (U+0046 U+00E2)
  0x00, 0x46, 0x00, 0xE3, 0x02, // Fã (U+0046 U+00E3)
  0x00, 0x46, 0x00, 0xE4, 0x02, // Fä (U+0046 U+00E4)
  0x00, 0x46, 0x00, 0xE5, 0x02, // Få (U+0046 U+00E5)
  0x00, 0x46, 0x00, 0xE6, 0x02, // Fæ (U+0046 U+00E6)
  0x00, 0x46, 0x00, 0xE7, 0x02, // Fç (U+0046 U+00E7)
  0x00, 0x46, 0x00, 0xE8, 0x02, // Fè (U+0046 U+00E8)
  0x00, 0x46, 0x00, 0xE9, 0x02, // Fé (U+0046 U+00E9)
  0x00, 0x46, 0x00, 0xEA, 0x02, // Fê (U+0046 U+00EA)
  0x00, 0x46, 0x00, 0xEB, 0x02, // Fë (U+0046 U+00EB)
  0x00, 0x46, 0x00, 0xF0, 0x02, // Fð (U+0046 U+00F0)
  0x00, 0x46, 0x00, 0xF2, 0x02, // Fò (U+0046 U+00F2)
  0x00, 0x46, 0x00, 0xF3, 0x02, // Fó (U+0046 U+00F3)
  0x00, 0x46, 0x00, 0xF4, 0x02, // Fô (U+0046 U+00F4)
  0x00, 0x46, 0x00, 0xF5, 0x02, // Fõ (U+0046 U+00F5)
  0x00, 0x46, 0x00, 0xF6, 0x02, // Fö (U+0046 U+00F6)
  0x00, 0x46, 0x00, 0xF8, 0x02, // Fø (U+0046 U+00F8)
  0x00, 0x46, 0x01, 0x00, 0x04, // FĀ (U+0046 U+0100)
  0x00, 0x46, 0x01, 0x01, 0x02, // Fā (U+0046 U+0101)
  0x00, 0x46, 0x01, 0x02, 0x04, // FĂ (U+0046 U+0102)
  0x00, 0x46, 0x01, 0x03, 0x02, // Fă (U+0046 U+0103)
  0x00, 0x46, 0x01, 0x04, 0x04, // FĄ (U+0046 U+0104)
  0x00, 0x46, 0x01, 0x05, 0x02, // Fą (U+0046 U+0105)
  0x00, 0x46, 0x01, 0x07, 0x02, // Fć (U+0046 U+0107)
  0x00, 0x46, 0x01, 0x09, 0x02, // Fĉ (U+0046 U+0109)
  0x00, 0x46, 0x01, 0x0B, 0x02, // Fċ (U+0046 U+010B)
  0x00, 0x46, 0x01, 0x0D, 0x02, // Fč (U+0046 U+010D)
  0x00, 0x46, 0x01, 0x0F, 0x02, // Fď (U+0046 U+010F)
  0x00, 0x46, 0x01, 0x11, 0x02, // Fđ (U+0046 U+0111)
  0x00, 0x46, 0x01, 0x13, 0x02, // Fē (U+0046 U+0113)
  0x00, 0x46, 0x01, 0x15, 0x02, // Fĕ (U+0046 U+0115)
  0x00, 0x46, 0x01, 0x17, 0x02, // Fė (U+0046 U+0117)
  0x00, 0x46, 0x01, 0x19, 0x02, // Fę (U+0046 U+0119)
  0x00, 0x46, 0x01, 0x1B, 0x02, // Fě (U+0046 U+011B)
  0x00, 0x46, 0x01, 0x1D, 0x02, // Fĝ (U+0046 U+011D)
  0x00, 0x46, 0x01, 0x1F, 0x02, // Fğ (U+0046 U+011F)
  0x00, 0x46, 0x01, 0x21, 0x02, // Fġ (U+0046 U+0121)
  0x00, 0x46, 0x01, 0x23, 0x02, // Fģ (U+0046 U+0123)
  0x00, 0x46, 0x01, 0x4D, 0x02, // Fō (U+0046 U+014D)
  0x00, 0x46, 0x01, 0x4F, 0x02, // Fŏ (U+0046 U+014F)
  0x00, 0x46, 0x01, 0x51, 0x02, // Fő (U+0046 U+0151)
  0x00, 0x46, 0x01, 0x53, 0x02, // Fœ (U+0046 U+0153)
  0x00, 0x46, 0x20, 0x1A, 0x06, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x06, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x06, // F… (U+0046 U+2026)
  0x00, 0x47, 0x00, 0x3F, 0x01, // G? (U+0047 U+003F)
  0x00, 0x47, 0x00, 0x54, 0x01, // GT (U+0047 U+0054)
  0x00, 0x47, 0x00, 0x56, 0x01, // GV (U+0047 U+0056)
  0x00, 0x47, 0x00, 0x57, 0x01, // GW (U+0047 U+0057)
  0x00, 0x47, 0x00, 0x59, 0x01, // GY (U+0047 U+0059)
  0x00, 0x47, 0x00, 0xC6, 0x01, // GÆ (U+0047 U+00C6)
  0x00, 0x47, 0x00, 0xDD, 0x01, // GÝ (U+0047 U+00DD)
  0x00, 0x47, 0x01, 0x62, 0x01, // GŢ (U+0047 U+0162)
  0x00, 0x47, 0x01, 0x64, 0x01, // GŤ (U+0047 U+0164)
  0x00, 0x47, 0x01, 0x66, 0x01, // GŦ (U+0047 U+0166)
  0x00, 0x47, 0x01, 0x74, 0x01, // GŴ (U+0047 U+0174)
  0x00, 0x47, 0x01, 0x76, 0x01, // GŶ (U+0047 U+0176)
  0x00, 0x47, 0x01, 0x78, 0x01, // GŸ (U+0047 U+0178)
  0x00, 0x4B, 0x00, 0x43, 0x01, // KC (U+004B U+0043)
  0x00, 0x4B, 0x00, 0x47, 0x01, // KG (U+004B U+0047)
  0x00, 0x4B, 0x00, 0x4F, 0x01, // KO (U+004B U+004F)
  0x00, 0x4B, 0x00, 0x51, 0x01, // KQ (U+004B U+0051)
  0x00, 0x4B, 0x00, 0x63, 0x01, // Kc (U+004B U+0063)
  0x00, 0x4B, 0x00, 0x64, 0x01, // Kd (U+004B U+0064)
  0x00, 0x4B, 0x00, 0x65, 0x01, // Ke (U+004B U+0065)
  0x00, 0x4B, 0x00, 0x67, 0x01, // Kg (U+004B U+0067)
  0x00, 0x4B, 0x00, 0x6F, 0x01, // Ko (U+004B U+006F)
  0x00, 0x4B, 0x00, 0x71, 0x01, // Kq (U+004B U+0071)
  0x00, 0x4B, 0x00, 0x75, 0x01, // Ku (U+004B U+0075)
  0x00, 0x4B, 0x00, 0x77, 0x02, // Kw (U+004B U+0077)
  0x00, 0x4B, 0x00, 0x79, 0x02, // Ky (U+004B U+0079)
  0x00, 0x4B, 0x00, 0xC7, 0x01, // KÇ (U+004B U+00C7)
  0x00, 0x4B, 0x00, 0xD2, 0x01, // KÒ (U+004B U+00D2)
  0x00, 0x4B, 0x00, 0xD3, 0x01, // KÓ (U+004B U+00D3)
  0x00, 0x4B, 0x00, 0xD4, 0x01, // KÔ (U+004B U+00D4)
  0x00, 0x4B, 0x00, 0xD5, 0x01, // KÕ (U+004B U+00D5)
  0x00, 0x4B, 0x00, 0xD6, 0x01, // KÖ (U+004B U+00D6)
  0x00, 0x4B, 0x00, 0xD8, 0x01, // KØ (U+004B U+00D8)
  0x00, 0x4B, 0x00, 0xE7, 0x01, // Kç (U+004B U+00E7)
  0x00, 0x4B, 0x00, 0xE8, 0x01, // Kè (U+004B U+00E8)
  0x00, 0x4B, 0x00, 0xE9, 0x01, // Ké (U+004B U+00E9)
  0x00, 0x4B, 0x00, 0xEA, 0x01, // Kê (U+004B U+00EA)
  0x00, 0x4B, 0x00, 0xEB, 0x01, // Kë (U+004B U+00EB)
  0x00, 0x4B, 0x00, 0xF0, 0x01, // Kð (U+004B U+00F0)
  0x00, 0x4B, 0x00, 0xF2, 0x01, // Kò (U+004B U+00F2)
  0x00, 0x4B, 0x00, 0xF3, 0x01, // Kó (U+004B U+00F3)
  0x00, 0x4B, 0x00, 0xF4, 0x01, // Kô (U+004B U+00F4)
  0x00, 0x4B, 0x00, 0xF5, 0x01, // Kõ (U+004B U+00F5)
  0x00, 0x4B, 0x00, 0xF6, 0x01, // Kö (U+004B U+00F6)
  0x00, 0x4B, 0x00, 0xF8, 0x01, // Kø (U+004B U+00F8)
  0x00, 0x4B, 0x00, 0xF9, 0x01, // Kù (U+004B U+00F9)
  0x00, 0x4B, 0x00, 0xFA, 0x01, // Kú (U+004B U+00FA)
  0x00, 0x4B, 0x00, 0xFB, 0x01, // Kû (U+004B U+00FB)
  0x00, 0x4B, 0x00, 0xFC, 0x01, // Kü (U+004B U+00FC)
  0x00, 0x4B, 0x00, 0xFD, 0x02, // Ký (U+004B U+00FD)
  0x00, 0x4B, 0x00, 0xFF, 0x02, // Kÿ (U+004B U+00FF)
  0x00, 0x4B, 0x01, 0x06, 0x01, // KĆ (U+004B U+0106)
  0x00, 0x4B, 0x01, 0x07, 0x01, // Kć (U+004B U+0107)
  0x00, 0x4B, 0x01, 0x08, 0x01, // KĈ (U+004B U+0108)
  0x00, 0x4B, 0x01, 0x09, 0x01, // Kĉ (U+004B U+0109)
  0x00, 0x4B, 0x01, 0x0A, 0x01, // KĊ (U+004B U+010A)
  0x00, 0x4B, 0x01, 0x0B, 0x01, // Kċ (U+004B U+010B)
  0x00, 0x4B, 0x01, 0x0C, 0x01, // KČ (U+004B U+010C)
  0x00, 0x4B, 0x01, 0x0D, 0x01, // Kč (U+004B U+010D)
  0x00, 0x4B, 0x01, 0x0F, 0x01, // Kď (U+004B U+010F)
  0x00, 0x4B, 0x01, 0x11, 0x01, // Kđ (U+004B U+0111)
  0x00, 0x4B, 0x01, 0x13, 0x01, // Kē (U+004B U+0113)
  0x00, 0x4B, 0x01, 0x15, 0x01, // Kĕ (U+004B U+0115)
  0x00, 0x4B, 0x01, 0x17, 0x01, // Kė (U+004B U+0117)
  0x00, 0x4B, 0x01, 0x19, 0x01, // Kę (U+004B U+0119)
  0x00, 0x4B, 0x01, 0x1B, 0x01, // Kě (U+004B U+011B)
  0x00, 0x4B, 0x01, 0x1C, 0x01, // KĜ (U+004B U+011C)
  0x00, 0x4B, 0x01, 0x1D, 0x01, // Kĝ (U+004B U+011D)
  0x00, 0x4B, 0x01, 0x1E, 0x01, // KĞ (U+004B U+011E)
  0x00, 0x4B, 0x01, 0x1F, 0x01, // Kğ (U+004B U+011F)
  0x00, 0x4B, 0x01, 0x20, 0x01, // KĠ (U+004B U+0120)
  0x00, 0x4B, 0x01, 0x21, 0x01, // Kġ (U+004B U+0121)
  0x00, 0x4B, 0x01, 0x22, 0x01, // KĢ (U+004B U+0122)
  0x00, 0x4B, 0x01, 0x23, 0x01, // Kģ (U+004B U+0123)
  0x00, 0x4B, 0x01, 0x4C, 0x01, // KŌ (U+004B U+014C)
  0x00, 0x4B, 0x01, 0x4D, 0x01, // Kō (U+004B U+014D)
  0x00, 0x4B, 0x01, 0x4E, 0x01, // KŎ (U+004B U+014E)
  0x00, 0x4B, 0x01, 0x4F, 0x01, // Kŏ (U+004B U+014F)
  0x00, 0x4B, 0x01, 0x50, 0x01, // KŐ (U+004B U+0150)
  0x00, 0x4B, 0x01, 0x51, 0x01, // Kő (U+004B U+0151)
  0x00, 0x4B, 0x01, 0x52, 0x01, // KŒ (U+004B U+0152)
  0x00, 0x4B, 0x01, 0x53, 0x01, // Kœ (U+004B U+0153)
  0x00, 0x4B, 0x01, 0x69, 0x01, // Kũ (U+004B U+0169)
  0x00, 0x4B, 0x01, 0x6B, 0x01, // Kū (U+004B U+016B)
  0x00, 0x4B, 0x01, 0x6D, 0x01, // Kŭ (U+004B U+016D)
  0x00, 0x4B, 0x01, 0x6F, 0x01, // Ků (U+004B U+016F)
  0x00, 0x4B, 0x01, 0x71, 0x01, // Kű (U+004B U+0171)
  0x00, 0x4B, 0x01, 0x73, 0x01, // Kų (U+004B U+0173)
  0x00, 0x4B, 0x01, 0x75, 0x02, // Kŵ (U+004B U+0175)
  0x00, 0x4B, 0x01, 0x77, 0x02, // Kŷ (U+004B U+0177)
  0x00, 0x4C, 0x00, 0x22, 0x04, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x04, // L' (U+004C U+0027)
  0x00, 0x4C, 0x00, 0x2A, 0x05, // L* (U+004C U+002A)
  0x00, 0x4C, 0x00, 0x3F, 0x04, // L? (U+004C U+003F)
  0x00, 0x4C, 0x00, 0x54, 0x04, // LT (U+004C U+0054)
  0x00, 0x4C, 0x00, 0x56, 0x03, // LV (U+004C U+0056)
  0x00, 0x4C, 0x00, 0x57, 0x03, // LW (U+004C U+0057)
  0x00, 0x4C, 0x00, 0x59, 0x04, // LY (U+004C U+0059)
  0x00, 0x4C, 0x00, 0x76, 0x01, // Lv (U+004C U+0076)
  0x00, 0x4C, 0x00, 0x77, 0x01, // Lw (U+004C U+0077)
  0x00, 0x4C, 0x00, 0x79, 0x02, // Ly (U+004C U+0079)
  0x00, 0x4C, 0x00, 0xB7, 0x01, // L· (U+004C U+00B7)
  0x00, 0x4C, 0x00, 0xDD, 0x04, // LÝ (U+004C U+00DD)
  0x00, 0x4C, 0x00, 0xFD, 0x02, // Lý (U+004C U+00FD)
  0x00, 0x4C, 0x00, 0xFF, 0x02, // Lÿ (U+004C U+00FF)
  0x00, 0x4C, 0x01, 0x62, 0x04, // LŢ (U+004C U+0162)
  0x00, 0x4C, 0x01, 0x64, 0x04, // LŤ (U+004C U+0164)
  0x00, 0x4C, 0x01, 0x66, 0x04, // LŦ (U+004C U+0166)
  0x00, 0x4C, 0x01, 0x74, 0x03, // LŴ (U+004C U+0174)
  0x00, 0x4C, 0x01, 0x75, 0x01, // Lŵ (U+004C U+0175)
  0x00, 0x4C, 0x01, 0x76, 0x04, // LŶ (U+004C U+0176)
  0x00, 0x4C, 0x01, 0x77, 0x02, // Lŷ (U+004C U+0177)
  0x00, 0x4C, 0x01, 0x78, 0x04, // LŸ (U+004C U+0178)
  0x00, 0x4C, 0x20, 0x18, 0x05, // L‘ (U+004C U+2018)
  0x00, 0x4C, 0x20, 0x19, 0x05, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1C, 0x05, // L“ (U+004C U+201C)
  0x00, 0x4C, 0x20, 0x1D, 0x05, // L” (U+004C U+201D)
  0x00, 0x4C, 0x21, 0x22, 0x05, // L™ (U+004C U+2122)
  0x00, 0x4E, 0x00, 0xAB, 0x01, // N« (U+004E U+00AB)
  0x00, 0x4E, 0x00, 0xBB, 0x01, // N» (U+004E U+00BB)
  0x00, 0x4E, 0x20, 0x39, 0x01, // N‹ (U+004E U+2039)
  0x00, 0x4E, 0x20, 0x3A, 0x01, // N› (U+004E U+203A)
  0x00, 0x4F, 0x00, 0x2C, 0x01, // O, (U+004F U+002C)
  0x00, 0x4F, 0x00, 0x2E, 0x01, // O. (U+004F U+002E)
  0x00, 0x4F, 0x00, 0x3F, 0x01, // O? (U+004F U+003F)
  0x00, 0x4F, 0x00, 0x41, 0x01, // OA (U+004F U+0041)
  0x00, 0x4F, 0x00, 0x54, 0x01, // OT (U+004F U+0054)
  0x00, 0x4F, 0x00, 0x56, 0x01, // OV (U+004F U+0056)
  0x00, 0x4F, 0x00, 0x57, 0x01, // OW (U+004F U+0057)
  0x00, 0x4F, 0x00, 0x58, 0x01, // OX (U+004F U+0058)
  0x00, 0x4F, 0x00, 0x59, 0x02, // OY (U+004F U+0059)
  0x00, 0x4F, 0x00, 0xC0, 0x01, // OÀ (U+004F U+00C0)
  0x00, 0x4F, 0x00, 0xC1, 0x01, // OÁ (U+004F U+00C1)
  0x00, 0x4F, 0x00, 0xC2, 0x01, // OÂ (U+004F U+00C2)
  0x00, 0x4F, 0x00, 0xC3, 0x01, // OÃ (U+004F U+00C3)
  0x00, 0x4F, 0x00, 0xC4, 0x01, // OÄ (U+004F U+00C4)
  0x00, 0x4F, 0x00, 0xC5, 0x01, // OÅ (U+004F U+00C5)
  0x00, 0x4F, 0x00, 0xC6, 0x03, // OÆ (U+004F U+00C6)
  0x00, 0x4F, 0x00, 0xDD, 0x02, // OÝ (U+004F U+00DD)
  0x00, 0x4F, 0x01, 0x00, 0x01, // OĀ (U+004F U+0100)
  0x00, 0x4F, 0x01, 0x02, 0x01, // OĂ (U+004F U+0102)
  0x00, 0x4F, 0x01, 0x04, 0x01, // OĄ (U+004F U+0104)
  0x00, 0x4F, 0x01, 0x62, 0x01, // OŢ (U+004F U+0162)
  0x00, 0x4F, 0x01, 0x64, 0x01, // OŤ (U+004F U+0164)
  0x00, 0x4F, 0x01, 0x66, 0x01, // OŦ (U+004F U+0166)
  0x00, 0x4F, 0x01, 0x74, 0x01, // OŴ (U+004F U+0174)
  0x00, 0x4F, 0x01, 0x76, 0x02, // OŶ (U+004F U+0176)
  0x00, 0x4F, 0x01, 0x78, 0x02, // OŸ (U+004F U+0178)
  0x00, 0x4F, 0x20, 0x1A, 0x01, // O‚ (U+004F U+201A)
  0x00, 0x4F, 0x20, 0x1E, 0x01, // O„ (U+004F U+201E)
  0x00, 0x4F, 0x20, 0x26, 0x01, // O… (U+004F U+2026)
  0x00, 0x50, 0x00, 0x26, 0x01, // P& (U+0050 U+0026)
  0x00, 0x50, 0x00, 0x2C, 0x06, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x06, // P. (U+0050 U+002E)
  0x00, 0x50, 0x00, 0x41, 0x03, // PA (U+0050 U+0041)
  0x00, 0x50, 0x00, 0xC0, 0x03, // PÀ (U+0050 U+00C0)
  0x00, 0x50, 0x00, 0xC1, 0x03, // PÁ (U+0050 U+00C1)
  0x00, 0x50, 0x00, 0xC2, 0x03, // PÂ (U+0050 U+00C2)
  0x00, 0x50, 0x00, 0xC3, 0x03, // PÃ (U+0050 U+00C3)
  0x00, 0x50, 0x00, 0xC4, 0x03, // PÄ (U+0050 U+00C4)
  0x00, 0x50, 0x00, 0xC5, 0x03, // PÅ (U+0050 U+00C5)
  0x00, 0x50, 0x00, 0xC6, 0x05, // PÆ (U+0050 U+00C6)
  0x00, 0x50, 0x01, 0x00, 0x03, // PĀ (U+0050 U+0100)
  0x00, 0x50, 0x01, 0x02, 0x03, // PĂ (U+0050 U+0102)
  0x00, 0x50, 0x01, 0x04, 0x03, // PĄ (U+0050 U+0104)
  0x00, 0x50, 0x20, 0x1A, 0x06, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x06, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x06, // P… (U+0050 U+2026)
  0x00, 0x51, 0x00, 0x2C, 0x01, // Q, (U+0051 U+002C)
  0x00, 0x51, 0x00, 0x2E, 0x01, // Q. (U+0051 U+002E)
  0x00, 0x51, 0x00, 0x3F, 0x01, // Q? (U+0051 U+003F)
  0x00, 0x51, 0x00, 0x41, 0x01, // QA (U+0051 U+0041)
  0x00, 0x51, 0x00, 0x54, 0x01, // QT (U+0051 U+0054)
  0x00, 0x51, 0x00, 0x56, 0x01, // QV (U+0051 U+0056)
  0x00, 0x51, 0x00, 0x57, 0x01, // QW (U+0051 U+0057)
  0x00, 0x51, 0x00, 0x58, 0x01, // QX (U+0051 U+0058)
  0x00, 0x51, 0x00, 0x59, 0x02, // QY (U+0051 U+0059)
  0x00, 0x51, 0x00, 0xC0, 0x01, // QÀ (U+0051 U+00C0)
  0x00, 0x51, 0x00, 0xC1, 0x01, // QÁ (U+0051 U+00C1)
  0x00, 0x51, 0x00, 0xC2, 0x01, // QÂ (U+0051 U+00C2)
  0x00, 0x51, 0x00, 0xC3, 0x01, // QÃ (U+0051 U+00C3)
  0x00, 0x51, 0x00, 0xC4, 0x01, // QÄ (U+0051 U+00C4)
  0x00, 0x51, 0x00, 0xC5, 0x01, // QÅ (U+0051 U+00C5)
  0x00, 0x51, 0x00, 0xC6, 0x03, // QÆ (U+0051 U+00C6)
  0x00, 0x51, 0x00, 0xDD, 0x02, // QÝ (U+0051 U+00DD)
  0x00, 0x51, 0x01, 0x00, 0x01, // QĀ (U+0051 U+0100)
  0x00, 0x51, 0x01, 0x02, 0x01, // QĂ (U+0051 U+0102)
  0x00, 0x51, 0x01, 0x04, 0x01, // QĄ (U+0051 U+0104)
  0x00, 0x51, 0x01, 0x62, 0x01, // QŢ (U+0051 U+0162)
  0x00, 0x51, 0x01, 0x64, 0x01, // QŤ (U+0051 U+0164)
  0x00, 0x51, 0x01, 0x66, 0x01, // QŦ (U+0051 U+0166)
  0x00, 0x51, 0x01, 0x74, 0x01, // QŴ (U+0051 U+0174)
  0x00, 0x51, 0x01, 0x76, 0x02, // QŶ (U+0051 U+0176)
  0x00, 0x51, 0x01, 0x78, 0x02, // QŸ (U+0051 U+0178)
  0x00, 0x51, 0x20, 0x1A, 0x01, // Q‚ (U+0051 U+201A)
  0x00, 0x51, 0x20, 0x1E, 0x01, // Q„ (U+0051 U+201E)
  0x00, 0x51, 0x20, 0x26, 0x01, // Q… (U+0051 U+2026)
  0x00, 0x52, 0x00, 0x2A, 0x01, // R* (U+0052 U+002A)
  0x00, 0x52, 0x00, 0x3F, 0x01, // R? (U+0052 U+003F)
  0x00, 0x52, 0x00, 0x43, 0x01, // RC (U+0052 U+0043)
  0x00, 0x52, 0x00, 0x47, 0x01, // RG (U+0052 U+0047)
  0x00, 0x52, 0x00, 0x4F, 0x01, // RO (U+0052 U+004F)
  0x00, 0x52, 0x00, 0x51, 0x01, // RQ (U+0052 U+0051)
  0x00, 0x52, 0x00, 0x54, 0x01, // RT (U+0052 U+0054)
  0x00, 0x52, 0x00, 0x56, 0x01, // RV (U+0052 U+0056)
  0x00, 0x52, 0x00, 0x57, 0x01, // RW (U+0052 U+0057)
  0x00, 0x52, 0x00, 0x59, 0x01, // RY (U+0052 U+0059)
  0x00, 0x52, 0x00, 0x76, 0x01, // Rv (U+0052 U+0076)
  0x00, 0x52, 0x00, 0x77, 0x01, // Rw (U+0052 U+0077)
  0x00, 0x52, 0x00, 0x79, 0x01, // Ry (U+0052 U+0079)
  0x00, 0x52, 0x00, 0xC7, 0x01, // RÇ (U+0052 U+00C7)
  0x00, 0x52, 0x00, 0xD2, 0x01, // RÒ (U+0052 U+00D2)
  0x00, 0x52, 0x00, 0xD3, 0x01, // RÓ (U+0052 U+00D3)
  0x00, 0x52, 0x00, 0xD4, 0x01, // RÔ (U+0052 U+00D4)
  0x00, 0x52, 0x00, 0xD5, 0x01, // RÕ (U+0052 U+00D5)
  0x00, 0x52, 0x00, 0xD6, 0x01, // RÖ (U+0052 U+00D6)
  0x00, 0x52, 0x00, 0xD8, 0x01, // RØ (U+0052 U+00D8)
  0x00, 0x52, 0x00, 0xDD, 0x01, // RÝ (U+0052 U+00DD)
  0x00, 0x52, 0x00, 0xFD, 0x01, // Rý (U+0052 U+00FD)
  0x00, 0x52, 0x00, 0xFF, 0x01, // Rÿ (U+0052 U+00FF)
  0x00, 0x52, 0x01, 0x06, 0x01, // RĆ (U+0052 U+0106)
  0x00, 0x52, 0x01, 0x08, 0x01, // RĈ (U+0052 U+0108)
  0x00, 0x52, 0x01, 0x0A, 0x01, // RĊ (U+0052 U+010A)
  0x00, 0x52, 0x01, 0x0C, 0x01, // RČ (U+0052 U+010C)
  0x00, 0x52, 0x01, 0x1C, 0x01, // RĜ (U+0052 U+011C)
  0x00, 0x52, 0x01, 0x1E, 0x01, // RĞ (U+0052 U+011E)
  0x00, 0x52, 0x01, 0x20, 0x01, // RĠ (U+0052 U+0120)
  0x00, 0x52, 0x01, 0x22, 0x01, // RĢ (U+0052 U+0122)
  0x00, 0x52, 0x01, 0x4C, 0x01, // RŌ (U+0052 U+014C)
  0x00, 0x52, 0x01, 0x4E, 0x01, // RŎ (U+0052 U+014E)
  0x00, 0x52, 0x01, 0x50, 0x01, // RŐ (U+0052 U+0150)
  0x00, 0x52, 0x01, 0x52, 0x01, // RŒ (U+0052 U+0152)
  0x00, 0x52, 0x01, 0x62, 0x01, // RŢ (U+0052 U+0162)
  0x00, 0x52, 0x01, 0x64, 0x01, // RŤ (U+0052 U+0164)
  0x00, 0x52, 0x01, 0x66, 0x01, // RŦ (U+0052 U+0166)
  0x00, 0x52, 0x01, 0x74, 0x01, // RŴ (U+0052 U+0174)
  0x00, 0x52, 0x01, 0x75, 0x01, // Rŵ (U+0052 U+0175)
  0x00, 0x52, 0x01, 0x76, 0x01, // RŶ (U+0052 U+0176)
  0x00, 0x52, 0x01, 0x77, 0x01, // Rŷ (U+0052 U+0177)
  0x00, 0x52, 0x01, 0x78, 0x01, // RŸ (U+0052 U+0178)
  0x00, 0x52, 0x20, 0x19, 0x01, // R’ (U+0052 U+2019)
  0x00, 0x52, 0x20, 0x1D, 0x01, // R” (U+0052 U+201D)
  0x00, 0x52, 0x21, 0x22, 0x01, // R™ (U+0052 U+2122)
  0x00, 0x53, 0x00, 0x3F, 0x01, // S? (U+0053 U+003F)
  0x00, 0x53, 0x00, 0x41, 0x01, // SA (U+0053 U+0041)
  0x00, 0x53, 0x00, 0x54, 0x01, // ST (U+0053 U+0054)
  0x00, 0x53, 0x00, 0x56, 0x01, // SV (U+0053 U+0056)
  0x00, 0x53, 0x00, 0x57, 0x01, // SW (U+0053 U+0057)
  0x00, 0x53, 0x00, 0x58, 0x01, // SX (U+0053 U+0058)
  0x00, 0x53, 0x00, 0x59, 0x01, // SY (U+0053 U+0059)
  0x00, 0x53, 0x00, 0x77, 0x01, // Sw (U+0053 U+0077)
  0x00, 0x53, 0x00, 0x79, 0x01, // Sy (U+0053 U+0079)
  0x00, 0x53, 0x00, 0xC0, 0x01, // SÀ (U+0053 U+00C0)
  0x00, 0x53, 0x00, 0xC1, 0x01, // SÁ (U+0053 U+00C1)
  0x00, 0x53, 0x00, 0xC2, 0x01, // SÂ (U+0053 U+00C2)
  0x00, 0x53, 0x00, 0xC3, 0x01, // SÃ (U+0053 U+00C3)
  0x00, 0x53, 0x00, 0xC4, 0x01, // SÄ (U+0053 U+00C4)
  0x00, 0x53, 0x00, 0xC5, 0x01, // SÅ (U+0053 U+00C5)
  0x00, 0x53, 0x00, 0xC6, 0x01, // SÆ (U+0053 U+00C6)
  0x00, 0x53, 0x00, 0xDD, 0x01, // SÝ (U+0053 U+00DD)
  0x00, 0x53, 0x00, 0xFD, 0x01, // Sý (U+0053 U+00FD)
  0x00, 0x53, 0x00, 0xFF, 0x01, // Sÿ (U+0053 U+00FF)
  0x00, 0x53, 0x01, 0x00, 0x01, // SĀ (U+0053 U+0100)
  0x00, 0x53, 0x01, 0x02, 0x01, // SĂ (U+0053 U+0102)
  0x00, 0x53, 0x01, 0x04, 0x01, // SĄ (U+0053 U+0104)
  0x00, 0x53, 0x01, 0x62, 0x01, // SŢ (U+0053 U+0162)
  0x00, 0x53, 0x01, 0x64, 0x01, // SŤ (U+0053 U+0164)
  0x00, 0x53, 0x01, 0x66, 0x01, // SŦ (U+0053 U+0166)
  0x00, 0x53, 0x01, 0x74, 0x01, // SŴ (U+0053 U+0174)
  0x00, 0x53, 0x01, 0x75, 0x01, // Sŵ (U+0053 U+0175)
  0x00, 0x53, 0x01, 0x76, 0x01, // SŶ (U+0053 U+0176)
  0x00, 0x53, 0x01, 0x77, 0x01, // Sŷ (U+0053 U+0177)
  0x00, 0x53, 0x01, 0x78, 0x01, // SŸ (U+0053 U+0178)
  0x00, 0x54, 0x00, 0x26, 0x01, // T& (U+0054 U+0026)
  0x00, 0x54, 0x00, 0x2C, 0x04, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2E, 0x04, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0x40, 0x02, // T@ (U+0054 U+0040)
  0x00, 0x54, 0x00, 0x41, 0x03, // TA (U+0054 U+0041)
  0x00, 0x54, 0x00, 0x43, 0x01, // TC (U+0054 U+0043)
  0x00, 0x54, 0x00, 0x47, 0x01, // TG (U+0054 U+0047)
  0x00, 0x54, 0x00, 0x4F, 0x01, // TO (U+0054 U+004F)
  0x00, 0x54, 0x00, 0x51, 0x01, // TQ (U+0054 U+0051)
  0x00, 0x54, 0x00, 0x61, 0x02, // Ta (U+0054 U+0061)
  0x00, 0x54, 0x00, 0x63, 0x03, // Tc (U+0054 U+0063)
  0x00, 0x54, 0x00, 0x64, 0x03, // Td (U+0054 U+0064)
  0x00, 0x54, 0x00, 0x65, 0x03, // Te (U+0054 U+0065)
  0x00, 0x54, 0x00, 0x67, 0x03, // Tg (U+0054 U+0067)
  0x00, 0x54, 0x00, 0x6F, 0x03, // To (U+0054 U+006F)
  0x00, 0x54, 0x00, 0x71, 0x03, // Tq (U+0054 U+0071)
  0x00, 0x54, 0x00, 0xC0, 0x03, // TÀ (U+0054 U+00C0)
  0x00, 0x54, 0x00, 0xC1, 0x03, // TÁ (U+0054 U+00C1)
  0x00, 0x54, 0x00, 0xC2, 0x03, // TÂ (U+0054 U+00C2)
  0x00, 0x54, 0x00, 0xC3, 0x03, // TÃ (U+0054 U+00C3)
  0x00, 0x54, 0x00, 0xC4, 0x03, // TÄ (U+0054 U+00C4)
  0x00, 0x54, 0x00, 0xC5, 0x03, // TÅ (U+0054 U+00C5)
  0x00, 0x54, 0x00, 0xC6, 0x05, // TÆ (U+0054 U+00C6)
  0x00, 0x54, 0x00, 0xC7, 0x01, // TÇ (U+0054 U+00C7)
  0x00, 0x54, 0x00, 0xD2, 0x01, // TÒ (U+0054 U+00D2)
  0x00, 0x54, 0x00, 0xD3, 0x01, // TÓ (U+0054 U+00D3)
  0x00, 0x54, 0x00, 0xD4, 0x01, // TÔ (U+0054 U+00D4)
  0x00, 0x54, 0x00, 0xD5, 0x01, // TÕ (U+0054 U+00D5)
  0x00, 0x54, 0x00, 0xD6, 0x01, // TÖ (U+0054 U+00D6)
  0x00, 0x54, 0x00, 0xD8, 0x01, // TØ (U+0054 U+00D8)
  0x00, 0x54, 0x00, 0xE0, 0x02, // Tà (U+0054 U+00E0)
  0x00, 0x54, 0x00, 0xE1, 0x02, // Tá (U+0054 U+00E1)
  0x00, 0x54, 0x00, 0xE2, 0x02, // Tâ (U+0054 U+00E2)
  0x00, 0x54, 0x00, 0xE3, 0x02, // Tã (U+0054 U+00E3)
  0x00, 0x54, 0x00, 0xE4, 0x02, // Tä (U+0054 U+00E4)
  0x00, 0x54, 0x00, 0xE5, 0x02, // Tå (U+0054 U+00E5)
  0x00, 0x54, 0x00, 0xE6, 0x02, // Tæ (U+0054 U+00E6)
  0x00, 0x54, 0x00, 0xE7, 0x03, // Tç (U+0054 U+00E7)
  0x00, 0x54, 0x00, 0xE8, 0x03, // Tè (U+0054 U+00E8)
  0x00, 0x54, 0x00, 0xE9, 0x03, // Té (U+0054 U+00E9)
  0x00, 0x54, 0x00, 0xEA, 0x03, // Tê (U+0054 U+00EA)
  0x00, 0x54, 0x00, 0xEB, 0x03, // Të (U+0054 U+00EB)
  0x00, 0x54, 0x00, 0xF0, 0x03, // Tð (U+0054 U+00F0)
  0x00, 0x54, 0x00, 0xF2, 0x03, // Tò (U+0054 U+00F2)
  0x00, 0x54, 0x00, 0xF3, 0x03, // Tó (U+0054 U+00F3)
  0x00, 0x54, 0x00, 0xF4, 0x03, // Tô (U+0054 U+00F4)
  0x00, 0x54, 0x00, 0xF5, 0x03, // Tõ (U+0054 U+00F5)
  0x00, 0x54, 0x00, 0xF6, 0x03, // Tö (U+0054 U+00F6)
  0x00, 0x54, 0x00, 0xF8, 0x03, // Tø (U+0054 U+00F8)
  0x00, 0x54, 0x01, 0x00, 0x03, // TĀ (U+0054 U+0100)
  0x00, 0x54, 0x01, 0x01, 0x02, // Tā (U+0054 U+0101)
  0x00, 0x54, 0x01, 0x02, 0x03, // TĂ (U+0054 U+0102)
  0x00, 0x54, 0x01, 0x03, 0x02, // Tă (U+0054 U+0103)
  0x00, 0x54, 0x01, 0x04, 0x03, // TĄ (U+0054 U+0104)
  0x00, 0x54, 0x01, 0x05, 0x02, // Tą (U+0054 U+0105)
  0x00, 0x54, 0x01, 0x06, 0x01, // TĆ (U+0054 U+0106)
  0x00, 0x54, 0x01, 0x07, 0x03, // Tć (U+0054 U+0107)
  0x00, 0x54, 0x01, 0x08, 0x01, // TĈ (U+0054 U+0108)
  0x00, 0x54, 0x01, 0x09, 0x03, // Tĉ (U+0054 U+0109)
  0x00, 0x54, 0x01, 0x0A, 0x01, // TĊ (U+0054 U+010A)
  0x00, 0x54, 0x01, 0x0B, 0x03, // Tċ (U+0054 U+010B)
  0x00, 0x54, 0x01, 0x0C, 0x01, // TČ (U+0054 U+010C)
  0x00, 0x54, 0x01, 0x0D, 0x03, // Tč (U+0054 U+010D)
  0x00, 0x54, 0x01, 0x0F, 0x03, // Tď (U+0054 U+010F)
  0x00, 0x54, 0x01, 0x11, 0x03, // Tđ (U+0054 U+0111)
  0x00, 0x54, 0x01, 0x13, 0x03, // Tē (U+0054 U+0113)
  0x00, 0x54, 0x01, 0x15, 0x03, // Tĕ (U+0054 U+0115)
  0x00, 0x54, 0x01, 0x17, 0x03, // Tė (U+0054 U+0117)
  0x00, 0x54, 0x01, 0x19, 0x03, // Tę (U+0054 U+0119)
  0x00, 0x54, 0x01, 0x1B, 0x03, // Tě (U+0054 U+011B)
  0x00, 0x54, 0x01, 0x1C, 0x01, // TĜ (U+0054 U+011C)
  0x00, 0x54, 0x01, 0x1D, 0x03, // Tĝ (U+0054 U+011D)
  0x00, 0x54, 0x01, 0x1E, 0x01, // TĞ (U+0054 U+011E)
  0x00, 0x54, 0x01, 0x1F, 0x03, // Tğ (U+0054 U+011F)
  0x00, 0x54, 0x01, 0x20, 0x01, // TĠ (U+0054 U+0120)
  0x00, 0x54, 0x01, 0x21, 0x03, // Tġ (U+0054 U+0121)
  0x00, 0x54, 0x01, 0x22, 0x01, // TĢ (U+0054 U+0122)
  0x00, 0x54, 0x01, 0x23, 0x03, // Tģ (U+0054 U+0123)
  0x00, 0x54, 0x01, 0x4C, 0x01, // TŌ (U+0054 U+014C)
  0x00, 0x54, 0x01, 0x4D, 0x03, // Tō (U+0054 U+014D)
  0x00, 0x54, 0x01, 0x4E, 0x01, // TŎ (U+0054 U+014E)
  0x00, 0x54, 0x01, 0x4F, 0x03, // Tŏ (U+0054 U+014F)
  0x00, 0x54, 0x01, 0x50, 0x01, // TŐ (U+0054 U+0150)
  0x00, 0x54, 0x01, 0x51, 0x03, // Tő (U+0054 U+0151)
  0x00, 0x54, 0x01, 0x52, 0x01, // TŒ (U+0054 U+0152)
  0x00, 0x54, 0x01, 0x53, 0x03, // Tœ (U+0054 U+0153)
  0x00, 0x54, 0x20, 0x1A, 0x04, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x04, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x04, // T… (U+0054 U+2026)
  0x00, 0x55, 0x00, 0x2C, 0x01, // U, (U+0055 U+002C)
  0x00, 0x55, 0x00, 0x2E, 0x01, // U. (U+0055 U+002E)
  0x00, 0x55, 0x00, 0x40, 0x01, // U@ (U+0055 U+0040)
  0x00, 0x55, 0x00, 0x41, 0x01, // UA (U+0055 U+0041)
  0x00, 0x55, 0x00, 0xC0, 0x01, // UÀ (U+0055 U+00C0)
  0x00, 0x55, 0x00, 0xC1, 0x01, // UÁ (U+0055 U+00C1)
  0x00, 0x55, 0x00, 0xC2, 0x01, // UÂ (U+0055 U+00C2)
  0x00, 0x55, 0x00, 0xC3, 0x01, // UÃ (U+0055 U+00C3)
  0x00, 0x55, 0x00, 0xC4, 0x01, // UÄ (U+0055 U+00C4)
  0x00, 0x55, 0x00, 0xC5, 0x01, // UÅ (U+0055 U+00C5)
  0x00, 0x55, 0x00, 0xC6, 0x02, // UÆ (U+0055 U+00C6)
  0x00, 0x55, 0x01, 0x00, 0x01, // UĀ (U+0055 U+0100)
  0x00, 0x55, 0x01, 0x02, 0x01, // UĂ (U+0055 U+0102)
  0x00, 0x55, 0x01, 0x04, 0x01, // UĄ (U+0055 U+0104)
  0x00, 0x55, 0x20, 0x1A, 0x01, // U‚ (U+0055 U+201A)
  0x00, 0x55, 0x20, 0x1E, 0x01, // U„ (U+0055 U+201E)
  0x00, 0x55, 0x20, 0x26, 0x01, // U… (U+0055 U+2026)
  0x00, 0x56, 0x00, 0x26, 0x02, // V& (U+0056 U+0026)
  0x00, 0x56, 0x00, 0x2C, 0x06, // V, (U+0056 U+002C)
  0x00, 0x56, 0x00, 0x2E, 0x06, // V. (U+0056 U+002E)
  0x00, 0x56, 0x00, 0x40, 0x03, // V@ (U+0056 U+0040)
  0x00, 0x56, 0x00, 0x41, 0x04, // VA (U+0056 U+0041)
  0x00, 0x56, 0x00, 0x43, 0x01, // VC (U+0056 U+0043)
  0x00, 0x56, 0x00, 0x47, 0x01, // VG (U+0056 U+0047)
  0x00, 0x56, 0x00, 0x4F, 0x01, // VO (U+0056 U+004F)
  0x00, 0x56, 0x00, 0x51, 0x01, // VQ (U+0056 U+0051)
  0x00, 0x56, 0x00, 0x61, 0x03, // Va (U+0056 U+0061)
  0x00, 0x56, 0x00, 0x63, 0x03, // Vc (U+0056 U+0063)
  0x00, 0x56, 0x00, 0x64, 0x03, // Vd (U+0056 U+0064)
  0x00, 0x56, 0x00, 0x65, 0x03, // Ve (U+0056 U+0065)
  0x00, 0x56, 0x00, 0x67, 0x03, // Vg (U+0056 U+0067)
  0x00, 0x56, 0x00, 0x6F, 0x03, // Vo (U+0056 U+006F)
  0x00, 0x56, 0x00, 0x71, 0x03, // Vq (U+0056 U+0071)
  0x00, 0x56, 0x00, 0x73, 0x02, // Vs (U+0056 U+0073)
  0x00, 0x56, 0x00, 0xC0, 0x04, // VÀ (U+0056 U+00C0)
  0x00, 0x56, 0x00, 0xC1, 0x04, // VÁ (U+0056 U+00C1)
  0x00, 0x56, 0x00, 0xC2, 0x04, // VÂ (U+0056 U+00C2)
  0x00, 0x56, 0x00, 0xC3, 0x04, // VÃ (U+0056 U+00C3)
  0x00, 0x56, 0x00, 0xC4, 0x04, // VÄ (U+0056 U+00C4)
  0x00, 0x56, 0x00, 0xC5, 0x04, // VÅ (U+0056 U+00C5)
  0x00, 0x56, 0x00, 0xC6, 0x07, // VÆ (U+0056 U+00C6)
  0x00, 0x56, 0x00, 0xC7, 0x01, // VÇ (U+0056 U+00C7)
  0x00, 0x56, 0x00, 0xD2, 0x01, // VÒ (U+0056 U+00D2)
  0x00, 0x56, 0x00, 0xD3, 0x01, // VÓ (U+0056 U+00D3)
  0x00, 0x56, 0x00, 0xD4, 0x01, // VÔ (U+0056 U+00D4)
  0x00, 0x56, 0x00, 0xD5, 0x01, // VÕ (U+0056 U+00D5)
  0x00, 0x56, 0x00, 0xD6, 0x01, // VÖ (U+0056 U+00D6)
  0x00, 0x56, 0x00, 0xD8, 0x01, // VØ (U+0056 U+00D8)
  0x00, 0x56, 0x00, 0xE0, 0x03, // Và (U+0056 U+00E0)
  0x00, 0x56, 0x00, 0xE1, 0x03, // Vá (U+0056 U+00E1)
  0x00, 0x56, 0x00, 0xE2, 0x03, // Vâ (U+0056 U+00E2)
  0x00, 0x56, 0x00, 0xE3, 0x03, // Vã (U+0056 U+00E3)
  0x00, 0x56, 0x00, 0xE4, 0x03, // Vä (U+0056 U+00E4)
  0x00, 0x56, 0x00, 0xE5, 0x03, // Vå (U+0056 U+00E5)
  0x00, 0x56, 0x00, 0xE6, 0x03, // Væ (U+0056 U+00E6)
  0x00, 0x56, 0x00, 0xE7, 0x03, // Vç (U+0056 U+00E7)
  0x00, 0x56, 0x00, 0xE8, 0x03, // Vè (U+0056 U+00E8)
  0x00, 0x56, 0x00, 0xE9, 0x03, // Vé (U+0056 U+00E9)
  0x00, 0x56, 0x00, 0xEA, 0x03, // Vê (U+0056 U+00EA)
  0x00, 0x56, 0x00, 0xEB, 0x03, // Vë (U+0056 U+00EB)
  0x00, 0x56, 0x00, 0xF0, 0x03, // Vð (U+0056 U+00F0)
  0x00, 0x56, 0x00, 0xF2, 0x03, // Vò (U+0056 U+00F2)
  0x00, 0x56, 0x00, 0xF3, 0x03, // Vó (U+0056 U+00F3)
  0x00, 0x56, 0x00, 0xF4, 0x03, // Vô (U+0056 U+00F4)
  0x00, 0x56, 0x00, 0xF5, 0x03, // Võ (U+0056 U+00F5)
  0x00, 0x56, 0x00, 0xF6, 0x03, // Vö (U+0056 U+00F6)
  0x00, 0x56, 0x00, 0xF8, 0x03, // Vø (U+0056 U+00F8)
  0x00, 0x56, 0x01, 0x00, 0x04, // VĀ (U+0056 U+0100)
  0x00, 0x56, 0x01, 0x01, 0x03, // Vā (U+0056 U+0101)
  0x00, 0x56, 0x01, 0x02, 0x04, // VĂ (U+0056 U+0102)
  0x00, 0x56, 0x01, 0x03, 0x03, // Vă (U+0056 U+0103)
  0x00, 0x56, 0x01, 0x04, 0x04, // VĄ (U+0056 U+0104)
  0x00, 0x56, 0x01, 0x05, 0x03, // Vą (U+0056 U+0105)
  0x00, 0x56, 0x01, 0x06, 0x01, // VĆ (U+0056 U+0106)
  0x00, 0x56, 0x01, 0x07, 0x03, // Vć (U+0056 U+0107)
  0x00, 0x56, 0x01, 0x08, 0x01, // VĈ (U+0056 U+0108)
  0x00, 0x56, 0x01, 0x09, 0x03, // Vĉ (U+0056 U+0109)
  0x00, 0x56, 0x01, 0x0A, 0x01, // VĊ (U+0056 U+010A)
  0x00, 0x56, 0x01, 0x0B, 0x03, // Vċ (U+0056 U+010B)
  0x00, 0x56, 0x01, 0x0C, 0x01, // VČ (U+0056 U+010C)
  0x00, 0x56, 0x01, 0x0D, 0x03, // Vč (U+0056 U+010D)
  0x00, 0x56, 0x01, 0x0F, 0x03, // Vď (U+0056 U+010F)
  0x00, 0x56, 0x01, 0x11, 0x03, // Vđ (U+0056 U+0111)
  0x00, 0x56, 0x01, 0x13, 0x03, // Vē (U+0056 U+0113)
  0x00, 0x56, 0x01, 0x15, 0x03, // Vĕ (U+0056 U+0115)
  0x00, 0x56, 0x01, 0x17, 0x03, // Vė (U+0056 U+0117)
  0x00, 0x56, 0x01, 0x19, 0x03, // Vę (U+0056 U+0119)
  0x00, 0x56, 0x01, 0x1B, 0x03, // Vě (U+0056 U+011B)
  0x00, 0x56, 0x01, 0x1C, 0x01, // VĜ (U+0056 U+011C)
  0x00, 0x56, 0x01, 0x1D, 0x03, // Vĝ (U+0056 U+011D)
  0x00, 0x56, 0x01, 0x1E, 0x01, // VĞ (U+0056 U+011E)
  0x00, 0x56, 0x01, 0x1F, 0x03, // Vğ (U+0056 U+011F)
  0x00, 0x56, 0x01, 0x20, 0x01, // VĠ (U+0056 U+0120)
  0x00, 0x56, 0x01, 0x21, 0x03, // Vġ (U+0056 U+0121)
  0x00, 0x56, 0x01, 0x22, 0x01, // VĢ (U+0056 U+0122)
  0x00, 0x56, 0x01, 0x23, 0x03, // Vģ (U+0056 U+0123)
  0x00, 0x56, 0x01, 0x4C, 0x01, // VŌ (U+0056 U+014C)
  0x00, 0x56, 0x01, 0x4D, 0x03, // Vō (U+0056 U+014D)
  0x00, 0x56, 0x01, 0x4E, 0x01, // VŎ (U+0056 U+014E)
  0x00, 0x56, 0x01, 0x4F, 0x03, // Vŏ (U+0056 U+014F)
  0x00, 0x56, 0x01, 0x50, 0x01, // VŐ (U+0056 U+0150)
  0x00, 0x56, 0x01, 0x51, 0x03, // Vő (U+0056 U+0151)
  0x00, 0x56, 0x01, 0x52, 0x01, // VŒ (U+0056 U+0152)
  0x00, 0x56, 0x01, 0x53, 0x03, // Vœ (U+0056 U+0153)
  0x00, 0x56, 0x01, 0x5B, 0x02, // Vś (U+0056 U+015B)
  0x00, 0x56, 0x01, 0x5D, 0x02, // Vŝ (U+0056 U+015D)
  0x00, 0x56, 0x01, 0x5F, 0x02, // Vş (U+0056 U+015F)
  0x00, 0x56, 0x01, 0x61, 0x02, // Vš (U+0056 U+0161)
  0x00, 0x56, 0x20, 0x1A, 0x06, // V‚ (U+0056 U+201A)
  0x00, 0x56, 0x20, 0x1E, 0x06, // V„ (U+0056 U+201E)
  0x00, 0x56, 0x20, 0x26, 0x06, // V… (U+0056 U+2026)
  0x00, 0x57, 0x00, 0x2C, 0x05, // W, (U+0057 U+002C)
  0x00, 0x57, 0x00, 0x2E, 0x05, // W. (U+0057 U+002E)
  0x00, 0x57, 0x00, 0x40, 0x03, // W@ (U+0057 U+0040)
  0x00, 0x57, 0x00, 0x41, 0x03, // WA (U+0057 U+0041)
  0x00, 0x57, 0x00, 0x43, 0x01, // WC (U+0057 U+0043)
  0x00, 0x57, 0x00, 0x47, 0x01, // WG (U+0057 U+0047)
  0x00, 0x57, 0x00, 0x4F, 0x01, // WO (U+0057 U+004F)
  0x00, 0x57, 0x00, 0x51, 0x01, // WQ (U+0057 U+0051)
  0x00, 0x57, 0x00, 0x61, 0x04, // Wa (U+0057 U+0061)
  0x00, 0x57, 0x00, 0x63, 0x03, // Wc (U+0057 U+0063)
  0x00, 0x57, 0x00, 0x64, 0x03, // Wd (U+0057 U+0064)
  0x00, 0x57, 0x00, 0x65, 0x03, // We (U+0057 U+0065)
  0x00, 0x57, 0x00, 0x67, 0x03, // Wg (U+0057 U+0067)
  0x00, 0x57, 0x00, 0x6F, 0x03, // Wo (U+0057 U+006F)
  0x00, 0x57, 0x00, 0x71, 0x03, // Wq (U+0057 U+0071)
  0x00, 0x57, 0x00, 0x73, 0x03, // Ws (U+0057 U+0073)
  0x00, 0x57, 0x00, 0x7A, 0x02, // Wz (U+0057 U+007A)
  0x00, 0x57, 0x00, 0xC0, 0x03, // WÀ (U+0057 U+00C0)
  0x00, 0x57, 0x00, 0xC1, 0x03, // WÁ (U+0057 U+00C1)
  0x00, 0x57, 0x00, 0xC2, 0x03, // WÂ (U+0057 U+00C2)
  0x00, 0x57, 0x00, 0xC3, 0x03, // WÃ (U+0057 U+00C3)
  0x00, 0x57, 0x00, 0xC4, 0x03, // WÄ (U+0057 U+00C4)
  0x00, 0x57, 0x00, 0xC5, 0x03, // WÅ (U+0057 U+00C5)
  0x00, 0x57, 0x00, 0xC6, 0x06, // WÆ (U+0057 U+00C6)
  0x00, 0x57, 0x00, 0xC7, 0x01, // WÇ (U+0057 U+00C7)
  0x00, 0x57, 0x00, 0xD2, 0x01, // WÒ (U+0057 U+00D2)
  0x00, 0x57, 0x00, 0xD3, 0x01, // WÓ (U+0057 U+00D3)
  0x00, 0x57, 0x00, 0xD4, 0x01, // WÔ (U+0057 U+00D4)
  0x00, 0x57, 0x00, 0xD5, 0x01, // WÕ (U+0057 U+00D5)
  0x00, 0x57, 0x00, 0xD6, 0x01, // WÖ (U+0057 U+00D6)
  0x00, 0x57, 0x00, 0xD8, 0x01, // WØ (U+0057 U+00D8)
  0x00, 0x57, 0x00, 0xE0, 0x04, // Wà (U+0057 U+00E0)
  0x00, 0x57, 0x00, 0xE1, 0x04, // Wá (U+0057 U+00E1)
  0x00, 0x57, 0x00, 0xE2, 0x04, // Wâ (U+0057 U+00E2)
  0x00, 0x57, 0x00, 0xE3, 0x04, // Wã (U+0057 U+00E3)
  0x00, 0x57, 0x00, 0xE4, 0x04, // Wä (U+0057 U+00E4)
  0x00, 0x57, 0x00, 0xE5, 0x04, // Wå (U+0057 U+00E5)
  0x00, 0x57, 0x00, 0xE6, 0x04, // Wæ (U+0057 U+00E6)
  0x00, 0x57, 0x00, 0xE7, 0x03, // Wç (U+0057 U+00E7)
  0x00, 0x57, 0x00, 0xE8, 0x03, // Wè (U+0057 U+00E8)
  0x00, 0x57, 0x00, 0xE9, 0x03, // Wé (U+0057 U+00E9)
  0x00, 0x57, 0x00, 0xEA, 0x03, // Wê (U+0057 U+00EA)
  0x00, 0x57, 0x00, 0xEB, 0x03, // Wë (U+0057 U+00EB)
  0x00, 0x57, 0x00, 0xF0, 0x03, // Wð (U+0057 U+00F0)
  0x00, 0x57, 0x00, 0xF2, 0x03, // Wò (U+0057 U+00F2)
  0x00, 0x57, 0x00, 0xF3, 0x03, // Wó (U+0057 U+00F3)
  0x00, 0x57, 0x00, 0xF4, 0x03, // Wô (U+0057 U+00F4)
  0x00, 0x57, 0x00, 0xF5, 0x03, // Wõ (U+0057 U+00F5)
  0x00, 0x57, 0x00, 0xF6, 0x03, // Wö (U+0057 U+00F6)
  0x00, 0x57, 0x00, 0xF8, 0x03, // Wø (U+0057 U+00F8)
  0x00, 0x57, 0x01, 0x00, 0x03, // WĀ (U+0057 U+0100)
  0x00, 0x57, 0x01, 0x01, 0x04, // Wā (U+0057 U+0101)
  0x00, 0x57, 0x01, 0x02, 0x03, // WĂ (U+0057 U+0102)
  0x00, 0x57, 0x01, 0x03, 0x04, // Wă (U+0057 U+0103)
  0x00, 0x57, 0x01, 0x04, 0x03, // WĄ (U+0057 U+0104)
  0x00, 0x57, 0x01, 0x05, 0x04, // Wą (U+0057 U+0105)
  0x00, 0x57, 0x01, 0x06, 0x01, // WĆ (U+0057 U+0106)
  0x00, 0x57, 0x01, 0x07, 0x03, // Wć (U+0057 U+0107)
  0x00, 0x57, 0x01, 0x08, 0x01, // WĈ (U+0057 U+0108)
  0x00, 0x57, 0x01, 0x09, 0x03, // Wĉ (U+0057 U+0109)
  0x00, 0x57, 0x01, 0x0A, 0x01, // WĊ (U+0057 U+010A)
  0x00, 0x57, 0x01, 0x0B, 0x03, // Wċ (U+0057 U+010B)
  0x00, 0x57, 0x01, 0x0C, 0x01, // WČ (U+0057 U+010C)
  0x00, 0x57, 0x01, 0x0D, 0x03, // Wč (U+0057 U+010D)
  0x00, 0x57, 0x01, 0x0F, 0x03, // Wď (U+0057 U+010F)
  0x00, 0x57, 0x01, 0x11, 0x03, // Wđ (U+0057 U+0111)
  0x00, 0x57, 0x01, 0x13, 0x03, // Wē (U+0057 U+0113)
  0x00, 0x57, 0x01, 0x15, 0x03, // Wĕ (U+0057 U+0115)
  0x00, 0x57, 0x01, 0x17, 0x03, // Wė (U+0057 U+0117)
  0x00, 0x57, 0x01, 0x19, 0x03, // Wę (U+0057 U+0119)
  0x00, 0x57, 0x01, 0x1B, 0x03, // Wě (U+0057 U+011B)
  0x00, 0x57, 0x01, 0x1C, 0x01, // WĜ (U+0057 U+011C)
  0x00, 0x57, 0x01, 0x1D, 0x03, // Wĝ (U+0057 U+011D)
  0x00, 0x57, 0x01, 0x1E, 0x01, // WĞ (U+0057 U+011E)
  0x00, 0x57, 0x01, 0x1F, 0x03, // Wğ (U+0057 U+011F)
  0x00, 0x57, 0x01, 0x20, 0x01, // WĠ (U+0057 U+0120)
  0x00, 0x57, 0x01, 0x21, 0x03, // Wġ (U+0057 U+0121)
  0x00, 0x57, 0x01, 0x22, 0x01, // WĢ (U+0057 U+0122)
  0x00, 0x57, 0x01, 0x23, 0x03, // Wģ (U+0057 U+0123)
  0x00, 0x57, 0x01, 0x4C, 0x01, // WŌ (U+0057 U+014C)
  0x00, 0x57, 0x01, 0x4D, 0x03, // Wō (U+0057 U+014D)
  0x00, 0x57, 0x01, 0x4E, 0x01, // WŎ (U+0057 U+014E)
  0x00, 0x57, 0x01, 0x4F, 0x03, // Wŏ (U+0057 U+014F)
  0x00, 0x57, 0x01, 0x50, 0x01, // WŐ (U+0057 U+0150)
  0x00, 0x57, 0x01, 0x51, 0x03, // Wő (U+0057 U+0151)
  0x00, 0x57, 0x01, 0x52, 0x01, // WŒ (U+0057 U+0152)
  0x00, 0x57, 0x01, 0x53, 0x03, // Wœ (U+0057 U+0153)
  0x00, 0x57, 0x01, 0x5B, 0x03, // Wś (U+0057 U+015B)
  0x00, 0x57, 0x01, 0x5D, 0x03, // Wŝ (U+0057 U+015D)
  0x00, 0x57, 0x01, 0x5F, 0x03, // Wş (U+0057 U+015F)
  0x00, 0x57, 0x01, 0x61, 0x03, // Wš (U+0057 U+0161)
  0x00, 0x57, 0x01, 0x7A, 0x02, // Wź (U+0057 U+017A)
  0x00, 0x57, 0x01, 0x7C, 0x02, // Wż (U+0057 U+017C)
  0x00, 0x57, 0x01, 0x7E, 0x02, // Wž (U+0057 U+017E)
  0x00, 0x57, 0x20, 0x1A, 0x05, // W‚ (U+0057 U+201A)
  0x00, 0x57, 0x20, 0x1E, 0x05, // W„ (U+0057 U+201E)
  0x00, 0x57, 0x20, 0x26, 0x05, // W… (U+0057 U+2026)
  0x00, 0x58, 0x00, 0x43, 0x01, // XC (U+0058 U+0043)
  0x00, 0x58, 0x00, 0x47, 0x01, // XG (U+0058 U+0047)
  0x00, 0x58, 0x00, 0x4F, 0x01, // XO (U+0058 U+004F)
  0x00, 0x58, 0x00, 0x51, 0x01, // XQ (U+0058 U+0051)
  0x00, 0x58, 0x00, 0x53, 0x01, // XS (U+0058 U+0053)
  0x00, 0x58, 0x00, 0x77, 0x02, // Xw (U+0058 U+0077)
  0x00, 0x58, 0x00, 0x79, 0x03, // Xy (U+0058 U+0079)
  0x00, 0x58, 0x00, 0xC7, 0x01, // XÇ (U+0058 U+00C7)
  0x00, 0x58, 0x00, 0xD2, 0x01, // XÒ (U+0058 U+00D2)
  0x00, 0x58, 0x00, 0xD3, 0x01, // XÓ (U+0058 U+00D3)
  0x00, 0x58, 0x00, 0xD4, 0x01, // XÔ (U+0058 U+00D4)
  0x00, 0x58, 0x00, 0xD5, 0x01, // XÕ (U+0058 U+00D5)
  0x00, 0x58, 0x00, 0xD6, 0x01, // XÖ (U+0058 U+00D6)
  0x00, 0x58, 0x00, 0xD8, 0x01, // XØ (U+0058 U+00D8)
  0x00, 0x58, 0x00, 0xFD, 0x03, // Xý (U+0058 U+00FD)
  0x00, 0x58, 0x00, 0xFF, 0x03, // Xÿ (U+0058 U+00FF)
  0x00, 0x58, 0x01, 0x06, 0x01, // XĆ (U+0058 U+0106)
  0x00, 0x58, 0x01, 0x08, 0x01, // XĈ (U+0058 U+0108)
  0x00, 0x58, 0x01, 0x0A, 0x01, // XĊ (U+0058 U+010A)
  0x00, 0x58, 0x01, 0x0C, 0x01, // XČ (U+0058 U+010C)
  0x00, 0x58, 0x01, 0x1C, 0x01, // XĜ (U+0058 U+011C)
  0x00, 0x58, 0x01, 0x1E, 0x01, // XĞ (U+0058 U+011E)
  0x00, 0x58, 0x01, 0x20, 0x01, // XĠ (U+0058 U+0120)
  0x00, 0x58, 0x01, 0x22, 0x01, // XĢ (U+0058 U+0122)
  0x00, 0x58, 0x01, 0x4C, 0x01, // XŌ (U+0058 U+014C)
  0x00, 0x58, 0x01, 0x4E, 0x01, // XŎ (U+0058 U+014E)
  0x00, 0x58, 0x01, 0x50, 0x01, // XŐ (U+0058 U+0150)
  0x00, 0x58, 0x01, 0x52, 0x01, // XŒ (U+0058 U+0152)
  0x00, 0x58, 0x01, 0x5A, 0x01, // XŚ (U+0058 U+015A)
  0x00, 0x58, 0x01, 0x5C, 0x01, // XŜ (U+0058 U+015C)
  0x00, 0x58, 0x01, 0x5E, 0x01, // XŞ (U+0058 U+015E)
  0x00, 0x58, 0x01, 0x60, 0x01, // XŠ (U+0058 U+0160)
  0x00, 0x58, 0x01, 0x75, 0x02, // Xŵ (U+0058 U+0175)
  0x00, 0x58, 0x01, 0x77, 0x03, // Xŷ (U+0058 U+0177)
  0x00, 0x59, 0x00, 0x26, 0x01, // Y& (U+0059 U+0026)
  0x00, 0x59, 0x00, 0x2C, 0x04, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x04, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x00, 0x40, 0x02, // Y@ (U+0059 U+0040)
  0x00, 0x59, 0x00, 0x41, 0x03, // YA (U+0059 U+0041)
  0x00, 0x59, 0x00, 0x43, 0x02, // YC (U+0059 U+0043)
  0x00, 0x59, 0x00, 0x47, 0x02, // YG (U+0059 U+0047)
  0x00, 0x59, 0x00, 0x4F, 0x02, // YO (U+0059 U+004F)
  0x00, 0x59, 0x00, 0x51, 0x02, // YQ (U+0059 U+0051)
  0x00, 0x59, 0x00, 0x53, 0x01, // YS (U+0059 U+0053)
  0x00, 0x59, 0x00, 0x61, 0x03, // Ya (U+0059 U+0061)
  0x00, 0x59, 0x00, 0x63, 0x03, // Yc (U+0059 U+0063)
  0x00, 0x59, 0x00, 0x64, 0x03, // Yd (U+0059 U+0064)
  0x00, 0x59, 0x00, 0x65, 0x03, // Ye (U+0059 U+0065)
  0x00, 0x59, 0x00, 0x67, 0x03, // Yg (U+0059 U+0067)
  0x00, 0x59, 0x00, 0x6F, 0x03, // Yo (U+0059 U+006F)
  0x00, 0x59, 0x00, 0x71, 0x03, // Yq (U+0059 U+0071)
  0x00, 0x59, 0x00, 0x73, 0x03, // Ys (U+0059 U+0073)
  0x00, 0x59, 0x00, 0x7A, 0x01, // Yz (U+0059 U+007A)
  0x00, 0x59, 0x00, 0xC0, 0x03, // YÀ (U+0059 U+00C0)
  0x00, 0x59, 0x00, 0xC1, 0x03, // YÁ (U+0059 U+00C1)
  0x00, 0x59, 0x00, 0xC2, 0x03, // YÂ (U+0059 U+00C2)
  0x00, 0x59, 0x00, 0xC3, 0x03, // YÃ (U+0059 U+00C3)
  0x00, 0x59, 0x00, 0xC4, 0x03, // YÄ (U+0059 U+00C4)
  0x00, 0x59, 0x00, 0xC5, 0x03, // YÅ (U+0059 U+00C5)
  0x00, 0x59, 0x00, 0xC6, 0x04, // YÆ (U+0059 U+00C6)
  0x00, 0x59, 0x00, 0xC7, 0x02, // YÇ (U+0059 U+00C7)
  0x00, 0x59, 0x00, 0xD2, 0x02, // YÒ (U+0059 U+00D2)
  0x00, 0x59, 0x00, 0xD3, 0x02, // YÓ (U+0059 U+00D3)
  0x00, 0x59, 0x00, 0xD4, 0x02, // YÔ (U+0059 U+00D4)
  0x00, 0x59, 0x00, 0xD5, 0x02, // YÕ (U+0059 U+00D5)
  0x00, 0x59, 0x00, 0xD6, 0x02, // YÖ (U+0059 U+00D6)
  0x00, 0x59, 0x00, 0xD8, 0x02, // YØ (U+0059 U+00D8)
  0x00, 0x59, 0x00, 0xE0, 0x03, // Yà (U+0059 U+00E0)
  0x00, 0x59, 0x00, 0xE1, 0x03, // Yá (U+0059 U+00E1)
  0x00, 0x59, 0x00, 0xE2, 0x03, // Yâ (U+0059 U+00E2)
  0x00, 0x59, 0x00, 0xE3, 0x03, // Yã (U+0059 U+00E3)
  0x00, 0x59, 0x00, 0xE4, 0x03, // Yä (U+0059 U+00E4)
  0x00, 0x59, 0x00, 0xE5, 0x03, // Yå (U+0059 U+00E5)
  0x00, 0x59, 0x00, 0xE6, 0x03, // Yæ (U+0059 U+00E6)
  0x00, 0x59, 0x00, 0xE7, 0x03, // Yç (U+0059 U+00E7)
  0x00, 0x59, 0x00, 0xE8, 0x03, // Yè (U+0059 U+00E8)
  0x00, 0x59, 0x00, 0xE9, 0x03, // Yé (U+0059 U+00E9)
  0x00, 0x59, 0x00, 0xEA, 0x03, // Yê (U+0059 U+00EA)
  0x00, 0x59, 0x00, 0xEB, 0x03, // Yë (U+0059 U+00EB)
  0x00, 0x59, 0x00, 0xF0, 0x03, // Yð (U+0059 U+00F0)
  0x00, 0x59, 0x00, 0xF2, 0x03, // Yò (U+0059 U+00F2)
  0x00, 0x59, 0x00, 0xF3, 0x03, // Yó (U+0059 U+00F3)
  0x00, 0x59, 0x00, 0xF4, 0x03, // Yô (U+0059 U+00F4)
  0x00, 0x59, 0x00, 0xF5, 0x03, // Yõ (U+0059 U+00F5)
  0x00, 0x59, 0x00, 0xF6, 0x03, // Yö (U+0059 U+00F6)
  0x00, 0x59, 0x00, 0xF8, 0x03, // Yø (U+0059 U+00F8)
  0x00, 0x59, 0x01, 0x00, 0x03, // YĀ (U+0059 U+0100)
  0x00, 0x59, 0x01, 0x01, 0x03, // Yā (U+0059 U+0101)
  0x00, 0x59, 0x01, 0x02, 0x03, // YĂ (U+0059 U+0102)
  0x00, 0x59, 0x01, 0x03, 0x03, // Yă (U+0059 U+0103)
  0x00, 0x59, 0x01, 0x04, 0x03, // YĄ (U+0059 U+0104)
  0x00, 0x59, 0x01, 0x05, 0x03, // Yą (U+0059 U+0105)
  0x00, 0x59, 0x01, 0x06, 0x02, // YĆ (U+0059 U+0106)
  0x00, 0x59, 0x01, 0x07, 0x03, // Yć (U+0059 U+0107)
  0x00, 0x59, 0x01, 0x08, 0x02, // YĈ (U+0059 U+0108)
  0x00, 0x59, 0x01, 0x09, 0x03, // Yĉ (U+0059 U+0109)
  0x00, 0x59, 0x01, 0x0A, 0x02, // YĊ (U+0059 U+010A)
  0x00, 0x59, 0x01, 0x0B, 0x03, // Yċ (U+0059 U+010B)
  0x00, 0x59, 0x01, 0x0C, 0x02, // YČ (U+0059 U+010C)
  0x00, 0x59, 0x01, 0x0D, 0x03, // Yč (U+0059 U+010D)
  0x00, 0x59, 0x01, 0x0F, 0x03, // Yď (U+0059 U+010F)
  0x00, 0x59, 0x01, 0x11, 0x03, // Yđ (U+0059 U+0111)
  0x00, 0x59, 0x01, 0x13, 0x03, // Yē (U+0059 U+0113)
  0x00, 0x59, 0x01, 0x15, 0x03, // Yĕ (U+0059 U+0115)
  0x00, 0x59, 0x01, 0x17, 0x03, // Yė (U+0059 U+0117)
  0x00, 0x59, 0x01, 0x19, 0x03, // Yę (U+0059 U+0119)
  0x00, 0x59, 0x01, 0x1B, 0x03, // Yě (U+0059 U+011B)
  0x00, 0x59, 0x01, 0x1C, 0x02, // YĜ (U+0059 U+011C)
  0x00, 0x59, 0x01, 0x1D, 0x03, // Yĝ (U+0059 U+011D)
  0x00, 0x59, 0x01, 0x1E, 0x02, // YĞ (U+0059 U+011E)
  0x00, 0x59, 0x01, 0x1F, 0x03, // Yğ (U+0059 U+011F)
  0x00, 0x59, 0x01, 0x20, 0x02, // YĠ (U+0059 U+0120)
  0x00, 0x59, 0x01, 0x21, 0x03, // Yġ (U+0059 U+0121)
  0x00, 0x59, 0x01, 0x22, 0x02, // YĢ (U+0059 U+0122)
  0x00, 0x59, 0x01, 0x23, 0x03, // Yģ (U+0059 U+0123)
  0x00, 0x59, 0x01, 0x4C, 0x02, // YŌ (U+0059 U+014C)
  0x00, 0x59, 0x01, 0x4D, 0x03, // Yō (U+0059 U+014D)
  0x00, 0x59, 0x01, 0x4E, 0x02, // YŎ (U+0059 U+014E)
  0x00, 0x59, 0x01, 0x4F, 0x03, // Yŏ (U+0059 U+014F)
  0x00, 0x59, 0x01, 0x50, 0x02, // YŐ (U+0059 U+0150)
  0x00, 0x59, 0x01, 0x51, 0x03, // Yő (U+0059 U+0151)
  0x00, 0x59, 0x01, 0x52, 0x02, // YŒ (U+0059 U+0152)
  0x00, 0x59, 0x01, 0x53, 0x03, // Yœ (U+0059 U+0153)
  0x00, 0x59, 0x01, 0x5A, 0x01, // YŚ (U+0059 U+015A)
  0x00, 0x59, 0x01, 0x5B, 0x03, // Yś (U+0059 U+015B)
  0x00, 0x59, 0x01, 0x5C, 0x01, // YŜ (U+0059 U+015C)
  0x00, 0x59, 0x01, 0x5D, 0x03, // Yŝ (U+0059 U+015D)
  0x00, 0x59, 0x01, 0x5E, 0x01, // YŞ (U+0059 U+015E)
  0x00, 0x59, 0x01, 0x5F, 0x03, // Yş (U+0059 U+015F)
  0x00, 0x59, 0x01, 0x60, 0x01, // YŠ (U+0059 U+0160)
  0x00, 0x59, 0x01, 0x61, 0x03, // Yš (U+0059 U+0161)
  0x00, 0x59, 0x01, 0x7A, 0x01, // Yź (U+0059 U+017A)
  0x00, 0x59, 0x01, 0x7C, 0x01, // Yż (U+0059 U+017C)
  0x00, 0x59, 0x01, 0x7E, 0x01, // Yž (U+0059 U+017E)
  0x00, 0x59, 0x20, 0x1A, 0x04, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x04, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x04, // Y… (U+0059 U+2026)
  0x00, 0x61, 0x00, 0x22, 0x02, // a" (U+0061 U+0022)
  0x00, 0x61, 0x00, 0x27, 0x02, // a' (U+0061 U+0027)
  0x00, 0x61, 0x00, 0x3F, 0x01, // a? (U+0061 U+003F)
  0x00, 0x61, 0x00, 0x54, 0x01, // aT (U+0061 U+0054)
  0x00, 0x61, 0x00, 0x56, 0x02, // aV (U+0061 U+0056)
  0x00, 0x61, 0x00, 0x57, 0x02, // aW (U+0061 U+0057)
  0x00, 0x61, 0x00, 0x59, 0x02, // aY (U+0061 U+0059)
  0x00, 0x61, 0x00, 0x79, 0x01, // ay (U+0061 U+0079)
  0x00, 0x61, 0x00, 0xDD, 0x02, // aÝ (U+0061 U+00DD)
  0x00, 0x61, 0x00, 0xFD, 0x01, // aý (U+0061 U+00FD)
  0x00, 0x61, 0x00, 0xFF, 0x01, // aÿ (U+0061 U+00FF)
  0x00, 0x61, 0x01, 0x62, 0x01, // aŢ (U+0061 U+0162)
  0x00, 0x61, 0x01, 0x64, 0x01, // aŤ (U+0061 U+0164)
  0x00, 0x61, 0x01, 0x66, 0x01, // aŦ (U+0061 U+0166)
  0x00, 0x61, 0x01, 0x74, 0x02, // aŴ (U+0061 U+0174)
  0x00, 0x61, 0x01, 0x76, 0x02, // aŶ (U+0061 U+0176)
  0x00, 0x61, 0x01, 0x77, 0x01, // aŷ (U+0061 U+0177)
  0x00, 0x61, 0x01, 0x78, 0x02, // aŸ (U+0061 U+0178)
  0x00, 0x62, 0x00, 0x3F, 0x01, // b? (U+0062 U+003F)
  0x00, 0x62, 0x00, 0x41, 0x01, // bA (U+0062 U+0041)
  0x00, 0x62, 0x00, 0x54, 0x01, // bT (U+0062 U+0054)
  0x00, 0x62, 0x00, 0x56, 0x02, // bV (U+0062 U+0056)
  0x00, 0x62, 0x00, 0x57, 0x02, // bW (U+0062 U+0057)
  0x00, 0x62, 0x00, 0x59, 0x03, // bY (U+0062 U+0059)
  0x00, 0x62, 0x00, 0x79, 0x01, // by (U+0062 U+0079)
  0x00, 0x62, 0x00, 0xC0, 0x01, // bÀ (U+0062 U+00C0)
  0x00, 0x62, 0x00, 0xC1, 0x01, // bÁ (U+0062 U+00C1)
  0x00, 0x62, 0x00, 0xC2, 0x01, // bÂ (U+0062 U+00C2)
  0x00, 0x62, 0x00, 0xC3, 0x01, // bÃ (U+0062 U+00C3)
  0x00, 0x62, 0x00, 0xC4, 0x01, // bÄ (U+0062 U+00C4)
  0x00, 0x62, 0x00, 0xC5, 0x01, // bÅ (U+0062 U+00C5)
  0x00, 0x62, 0x00, 0xDD, 0x03, // bÝ (U+0062 U+00DD)
  0x00, 0x62, 0x00, 0xFD, 0x01, // bý (U+0062 U+00FD)
  0x00, 0x62, 0x00, 0xFF, 0x01, // bÿ (U+0062 U+00FF)
  0x00, 0x62, 0x01, 0x00, 0x01, // bĀ (U+0062 U+0100)
  0x00, 0x62, 0x01, 0x02, 0x01, // bĂ (U+0062 U+0102)
  0x00, 0x62, 0x01, 0x04, 0x01, // bĄ (U+0062 U+0104)
  0x00, 0x62, 0x01, 0x62, 0x01, // bŢ (U+0062 U+0162)
  0x00, 0x62, 0x01, 0x64, 0x01, // bŤ (U+0062 U+0164)
  0x00, 0x62, 0x01, 0x66, 0x01, // bŦ (U+0062 U+0166)
  0x00, 0x62, 0x01, 0x74, 0x02, // bŴ (U+0062 U+0174)
  0x00, 0x62, 0x01, 0x76, 0x03, // bŶ (U+0062 U+0176)
  0x00, 0x62, 0x01, 0x77, 0x01, // bŷ (U+0062 U+0177)
  0x00, 0x62, 0x01, 0x78, 0x03, // bŸ (U+0062 U+0178)
  0x00, 0x65, 0x00, 0x56, 0x02, // eV (U+0065 U+0056)
  0x00, 0x65, 0x00, 0x57, 0x02, // eW (U+0065 U+0057)
  0x00, 0x65, 0x00, 0x59, 0x03, // eY (U+0065 U+0059)
  0x00, 0x65, 0x00, 0xDD, 0x03, // eÝ (U+0065 U+00DD)
  0x00, 0x65, 0x01, 0x74, 0x02, // eŴ (U+0065 U+0174)
  0x00, 0x65, 0x01, 0x76, 0x03, // eŶ (U+0065 U+0176)
  0x00, 0x65, 0x01, 0x78, 0x03, // eŸ (U+0065 U+0178)
  0x00, 0x67, 0x00, 0x57, 0x01, // gW (U+0067 U+0057)
  0x00, 0x67, 0x01, 0x74, 0x01, // gŴ (U+0067 U+0174)
  0x00, 0x68, 0x00, 0x22, 0x02, // h" (U+0068 U+0022)
  0x00, 0x68, 0x00, 0x27, 0x02, // h' (U+0068 U+0027)
  0x00, 0x68, 0x00, 0x3F, 0x01, // h? (U+0068 U+003F)
  0x00, 0x68, 0x00, 0x54, 0x01, // hT (U+0068 U+0054)
  0x00, 0x68, 0x00, 0x56, 0x02, // hV (U+0068 U+0056)
  0x00, 0x68, 0x00, 0x57, 0x02, // hW (U+0068 U+0057)
  0x00, 0x68, 0x00, 0x59, 0x02, // hY (U+0068 U+0059)
  0x00, 0x68, 0x00, 0x79, 0x01, // hy (U+0068 U+0079)
  0x00, 0x68, 0x00, 0xDD, 0x02, // hÝ (U+0068 U+00DD)
  0x00, 0x68, 0x00, 0xFD, 0x01, // hý (U+0068 U+00FD)
  0x00, 0x68, 0x00, 0xFF, 0x01, // hÿ (U+0068 U+00FF)
  0x00, 0x68, 0x01, 0x62, 0x01, // hŢ (U+0068 U+0162)
  0x00, 0x68, 0x01, 0x64, 0x01, // hŤ (U+0068 U+0164)
  0x00, 0x68, 0x01, 0x66, 0x01, // hŦ (U+0068 U+0166)
  0x00, 0x68, 0x01, 0x74, 0x02, // hŴ (U+0068 U+0174)
  0x00, 0x68, 0x01, 0x76, 0x02, // hŶ (U+0068 U+0176)
  0x00, 0x68, 0x01, 0x77, 0x01, // hŷ (U+0068 U+0177)
  0x00, 0x68, 0x01, 0x78, 0x02, // hŸ (U+0068 U+0178)
  0x00, 0x6B, 0x00, 0x63, 0x01, // kc (U+006B U+0063)
  0x00, 0x6B, 0x00, 0x64, 0x01, // kd (U+006B U+0064)
  0x00, 0x6B, 0x00, 0x65, 0x01, // ke (U+006B U+0065)
  0x00, 0x6B, 0x00, 0x67, 0x01, // kg (U+006B U+0067)
  0x00, 0x6B, 0x00, 0x6F, 0x01, // ko (U+006B U+006F)
  0x00, 0x6B, 0x00, 0x71, 0x01, // kq (U+006B U+0071)
  0x00, 0x6B, 0x00, 0xE7, 0x01, // kç (U+006B U+00E7)
  0x00, 0x6B, 0x00, 0xE8, 0x01, // kè (U+006B U+00E8)
  0x00, 0x6B, 0x00, 0xE9, 0x01, // ké (U+006B U+00E9)
  0x00, 0x6B, 0x00, 0xEA, 0x01, // kê (U+006B U+00EA)
  0x00, 0x6B, 0x00, 0xEB, 0x01, // kë (U+006B U+00EB)
  0x00, 0x6B, 0x00, 0xF0, 0x01, // kð (U+006B U+00F0)
  0x00, 0x6B, 0x00, 0xF2, 0x01, // kò (U+006B U+00F2)
  0x00, 0x6B, 0x00, 0xF3, 0x01, // kó (U+006B U+00F3)
  0x00, 0x6B, 0x00, 0xF4, 0x01, // kô (U+006B U+00F4)
  0x00, 0x6B, 0x00, 0xF5, 0x01, // kõ (U+006B U+00F5)
  0x00, 0x6B, 0x00, 0xF6, 0x01, // kö (U+006B U+00F6)
  0x00, 0x6B, 0x00, 0xF8, 0x01, // kø (U+006B U+00F8)
  0x00, 0x6B, 0x01, 0x07, 0x01, // kć (U+006B U+0107)
  0x00, 0x6B, 0x01, 0x09, 0x01, // kĉ (U+006B U+0109)
  0x00, 0x6B, 0x01, 0x0B, 0x01, // kċ (U+006B U+010B)
  0x00, 0x6B, 0x01, 0x0D, 0x01, // kč (U+006B U+010D)
  0x00, 0x6B, 0x01, 0x0F, 0x01, // kď (U+006B U+010F)
  0x00, 0x6B, 0x01, 0x11, 0x01, // kđ (U+006B U+0111)
  0x00, 0x6B, 0x01, 0x13, 0x01, // kē (U+006B U+0113)
  0x00, 0x6B, 0x01, 0x15, 0x01, // kĕ (U+006B U+0115)
  0x00, 0x6B, 0x01, 0x17, 0x01, // kė (U+006B U+0117)
  0x00, 0x6B, 0x01, 0x19, 0x01, // kę (U+006B U+0119)
  0x00, 0x6B, 0x01, 0x1B, 0x01, // kě (U+006B U+011B)
  0x00, 0x6B, 0x01, 0x1D, 0x01, // kĝ (U+006B U+011D)
  0x00, 0x6B, 0x01, 0x1F, 0x01, // kğ (U+006B U+011F)
  0x00, 0x6B, 0x01, 0x21, 0x01, // kġ (U+006B U+0121)
  0x00, 0x6B, 0x01, 0x23, 0x01, // kģ (U+006B U+0123)
  0x00, 0x6B, 0x01, 0x4D, 0x01, // kō (U+006B U+014D)
  0x00, 0x6B, 0x01, 0x4F, 0x01, // kŏ (U+006B U+014F)
  0x00, 0x6B, 0x01, 0x51, 0x01, // kő (U+006B U+0151)
  0x00, 0x6B, 0x01, 0x53, 0x01, // kœ (U+006B U+0153)
  0x00, 0x6D, 0x00, 0x22, 0x02, // m" (U+006D U+0022)
  0x00, 0x6D, 0x00, 0x27, 0x02, // m' (U+006D U+0027)
  0x00, 0x6D, 0x00, 0x3F, 0x01, // m? (U+006D U+003F)
  0x00, 0x6D, 0x00, 0x54, 0x01, // mT (U+006D U+0054)
  0x00, 0x6D, 0x00, 0x56, 0x02, // mV (U+006D U+0056)
  0x00, 0x6D, 0x00, 0x57, 0x02, // mW (U+006D U+0057)
  0x00, 0x6D, 0x00, 0x59, 0x02, // mY (U+006D U+0059)
  0x00, 0x6D, 0x00, 0x79, 0x01, // my (U+006D U+0079)
  0x00, 0x6D, 0x00, 0xDD, 0x02, // mÝ (U+006D U+00DD)
  0x00, 0x6D, 0x00, 0xFD, 0x01, // mý (U+006D U+00FD)
  0x00, 0x6D, 0x00, 0xFF, 0x01, // mÿ (U+006D U+00FF)
  0x00, 0x6D, 0x01, 0x62, 0x01, // mŢ (U+006D U+0162)
  0x00, 0x6D, 0x01, 0x64, 0x01, // mŤ (U+006D U+0164)
  0x00, 0x6D, 0x01, 0x66, 0x01, // mŦ (U+006D U+0166)
  0x00, 0x6D, 0x01, 0x74, 0x02, // mŴ (U+006D U+0174)
  0x00, 0x6D, 0x01, 0x76, 0x02, // mŶ (U+006D U+0176)
  0x00, 0x6D, 0x01, 0x77, 0x01, // mŷ (U+006D U+0177)
  0x00, 0x6D, 0x01, 0x78, 0x02, // mŸ (U+006D U+0178)
  0x00, 0x6E, 0x00, 0x22, 0x02, // n" (U+006E U+0022)
  0x00, 0x6E, 0x00, 0x27, 0x02, // n' (U+006E U+0027)
  0x00, 0x6E, 0x00, 0x3F, 0x01, // n? (U+006E U+003F)
  0x00, 0x6E, 0x00, 0x54, 0x01, // nT (U+006E U+0054)
  0x00, 0x6E, 0x00, 0x56, 0x02, // nV (U+006E U+0056)
  0x00, 0x6E, 0x00, 0x57, 0x02, // nW (U+006E U+0057)
  0x00, 0x6E, 0x00, 0x59, 0x02, // nY (U+006E U+0059)
  0x00, 0x6E, 0x00, 0x79, 0x01, // ny (U+006E U+0079)
  0x00, 0x6E, 0x00, 0xDD, 0x02, // nÝ (U+006E U+00DD)
  0x00, 0x6E, 0x00, 0xFD, 0x01, // ný (U+006E U+00FD)
  0x00, 0x6E, 0x00, 0xFF, 0x01, // nÿ (U+006E U+00FF)
  0x00, 0x6E, 0x01, 0x62, 0x01, // nŢ (U+006E U+0162)
  0x00, 0x6E, 0x01, 0x64, 0x01, // nŤ (U+006E U+0164)
  0x00, 0x6E, 0x01, 0x66, 0x01, // nŦ (U+006E U+0166)
  0x00, 0x6E, 0x01, 0x74, 0x02, // nŴ (U+006E U+0174)
  0x00, 0x6E, 0x01, 0x76, 0x02, // nŶ (U+006E U+0176)
  0x00, 0x6E, 0x01, 0x77, 0x01, // nŷ (U+006E U+0177)
  0x00, 0x6E, 0x01, 0x78, 0x02, // nŸ (U+006E U+0178)
  0x00, 0x6F, 0x00, 0x3F, 0x01, // o? (U+006F U+003F)
  0x00, 0x6F, 0x00, 0x41, 0x01, // oA (U+006F U+0041)
  0x00, 0x6F, 0x00, 0x54, 0x01, // oT (U+006F U+0054)
  0x00, 0x6F, 0x00, 0x56, 0x02, // oV (U+006F U+0056)
  0x00, 0x6F, 0x00, 0x57, 0x02, // oW (U+006F U+0057)
  0x00, 0x6F, 0x00, 0x59, 0x03, // oY (U+006F U+0059)
  0x00, 0x6F, 0x00, 0x79, 0x01, // oy (U+006F U+0079)
  0x00, 0x6F, 0x00, 0xC0, 0x01, // oÀ (U+006F U+00C0)
  0x00, 0x6F, 0x00, 0xC1, 0x01, // oÁ (U+006F U+00C1)
  0x00, 0x6F, 0x00, 0xC2, 0x01, // oÂ (U+006F U+00C2)
  0x00, 0x6F, 0x00, 0xC3, 0x01, // oÃ (U+006F U+00C3)
  0x00, 0x6F, 0x00, 0xC4, 0x01, // oÄ (U+006F U+00C4)
  0x00, 0x6F, 0x00, 0xC5, 0x01, // oÅ (U+006F U+00C5)
  0x00, 0x6F, 0x00, 0xDD, 0x03, // oÝ (U+006F U+00DD)
  0x00, 0x6F, 0x00, 0xFD, 0x01, // oý (U+006F U+00FD)
  0x00, 0x6F, 0x00, 0xFF, 0x01, // oÿ (U+006F U+00FF)
  0x00, 0x6F, 0x01, 0x00, 0x01, // oĀ (U+006F U+0100)
  0x00, 0x6F, 0x01, 0x02, 0x01, // oĂ (U+006F U+0102)
  0x00, 0x6F, 0x01, 0x04, 0x01, // oĄ (U+006F U+0104)
  0x00, 0x6F, 0x01, 0x62, 0x01, // oŢ (U+006F U+0162)
  0x00, 0x6F, 0x01, 0x64, 0x01, // oŤ (U+006F U+0164)
  0x00, 0x6F, 0x01, 0x66, 0x01, // oŦ (U+006F U+0166)
  0x00, 0x6F, 0x01, 0x74, 0x02, // oŴ (U+006F U+0174)
  0x00, 0x6F, 0x01, 0x76, 0x03, // oŶ (U+006F U+0176)
  0x00, 0x6F, 0x01, 0x77, 0x01, // oŷ (U+006F U+0177)
  0x00, 0x6F, 0x01, 0x78, 0x03, // oŸ (U+006F U+0178)
  0x00, 0x70, 0x00, 0x3F, 0x01, // p? (U+0070 U+003F)
  0x00, 0x70, 0x00, 0x41, 0x01, // pA (U+0070 U+0041)
  0x00, 0x70, 0x00, 0x54, 0x01, // pT (U+0070 U+0054)
  0x00, 0x70, 0x00, 0x56, 0x02, // pV (U+0070 U+0056)
  0x00, 0x70, 0x00, 0x57, 0x02, // pW (U+0070 U+0057)
  0x00, 0x70, 0x00, 0x59, 0x03, // pY (U+0070 U+0059)
  0x00, 0x70, 0x00, 0x79, 0x01, // py (U+0070 U+0079)
  0x00, 0x70, 0x00, 0xC0, 0x01, // pÀ (U+0070 U+00C0)
  0x00, 0x70, 0x00, 0xC1, 0x01, // pÁ (U+0070 U+00C1)
  0x00, 0x70, 0x00, 0xC2, 0x01, // pÂ (U+0070 U+00C2)
  0x00, 0x70, 0x00, 0xC3, 0x01, // pÃ (U+0070 U+00C3)
  0x00, 0x70, 0x00, 0xC4, 0x01, // pÄ (U+0070 U+00C4)
  0x00, 0x70, 0x00, 0xC5, 0x01, // pÅ (U+0070 U+00C5)
  0x00, 0x70, 0x00, 0xDD, 0x03, // pÝ (U+0070 U+00DD)
  0x00, 0x70, 0x00, 0xFD, 0x01, // pý (U+0070 U+00FD)
  0x00, 0x70, 0x00, 0xFF, 0x01, // pÿ (U+0070 U+00FF)
  0x00, 0x70, 0x01, 0x00, 0x01, // pĀ (U+0070 U+0100)
  0x00, 0x70, 0x01, 0x02, 0x01, // pĂ (U+0070 U+0102)
  0x00, 0x70, 0x01, 0x04, 0x01, // pĄ (U+0070 U+0104)
  0x00, 0x70, 0x01, 0x62, 0x01, // pŢ (U+0070 U+0162)
  0x00, 0x70, 0x01, 0x64, 0x01, // pŤ (U+0070 U+0164)
  0x00, 0x70, 0x01, 0x66, 0x01, // pŦ (U+0070 U+0166)
  0x00, 0x70, 0x01, 0x74, 0x02, // pŴ (U+0070 U+0174)
  0x00, 0x70, 0x01, 0x76, 0x03, // pŶ (U+0070 U+0176)
  0x00, 0x70, 0x01, 0x77, 0x01, // pŷ (U+0070 U+0177)
  0x00, 0x70, 0x01, 0x78, 0x03, // pŸ (U+0070 U+0178)
  0x00, 0x72, 0x00, 0x2C, 0x07, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x07, // r. (U+0072 U+002E)
  0x00, 0x72, 0x00, 0x41, 0x01, // rA (U+0072 U+0041)
  0x00, 0x72, 0x00, 0x58, 0x01, // rX (U+0072 U+0058)
  0x00, 0x72, 0x00, 0x61, 0x01, // ra (U+0072 U+0061)
  0x00, 0x72, 0x00, 0xC0, 0x01, // rÀ (U+0072 U+00C0)
  0x00, 0x72, 0x00, 0xC1, 0x01, // rÁ (U+0072 U+00C1)
  0x00, 0x72, 0x00, 0xC2, 0x01, // rÂ (U+0072 U+00C2)
  0x00, 0x72, 0x00, 0xC3, 0x01, // rÃ (U+0072 U+00C3)
  0x00, 0x72, 0x00, 0xC4, 0x01, // rÄ (U+0072 U+00C4)
  0x00, 0x72, 0x00, 0xC5, 0x01, // rÅ (U+0072 U+00C5)
  0x00, 0x72, 0x00, 0xE0, 0x01, // rà (U+0072 U+00E0)
  0x00, 0x72, 0x00, 0xE1, 0x01, // rá (U+0072 U+00E1)
  0x00, 0x72, 0x00, 0xE2, 0x01, // râ (U+0072 U+00E2)
  0x00, 0x72, 0x00, 0xE3, 0x01, // rã (U+0072 U+00E3)
  0x00, 0x72, 0x00, 0xE4, 0x01, // rä (U+0072 U+00E4)
  0x00, 0x72, 0x00, 0xE5, 0x01, // rå (U+0072 U+00E5)
  0x00, 0x72, 0x00, 0xE6, 0x01, // ræ (U+0072 U+00E6)
  0x00, 0x72, 0x01, 0x00, 0x01, // rĀ (U+0072 U+0100)
  0x00, 0x72, 0x01, 0x01, 0x01, // rā (U+0072 U+0101)
  0x00, 0x72, 0x01, 0x02, 0x01, // rĂ (U+0072 U+0102)
  0x00, 0x72, 0x01, 0x03, 0x01, // ră (U+0072 U+0103)
  0x00, 0x72, 0x01, 0x04, 0x01, // rĄ (U+0072 U+0104)
  0x00, 0x72, 0x01, 0x05, 0x01, // rą (U+0072 U+0105)
  0x00, 0x72, 0x20, 0x1A, 0x07, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x07, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x07, // r… (U+0072 U+2026)
  0x00, 0x73, 0x00, 0x57, 0x01, // sW (U+0073 U+0057)
  0x00, 0x73, 0x00, 0x59, 0x03, // sY (U+0073 U+0059)
  0x00, 0x73, 0x00, 0xDD, 0x03, // sÝ (U+0073 U+00DD)
  0x00, 0x73, 0x01, 0x74, 0x01, // sŴ (U+0073 U+0174)
  0x00, 0x73, 0x01, 0x76, 0x03, // sŶ (U+0073 U+0176)
  0x00, 0x73, 0x01, 0x78, 0x03, // sŸ (U+0073 U+0178)
  0x00, 0x76, 0x00, 0x2C, 0x03, // v, (U+0076 U+002C)
  0x00, 0x76, 0x00, 0x2E, 0x04, // v. (U+0076 U+002E)
  0x00, 0x76, 0x00, 0x41, 0x03, // vA (U+0076 U+0041)
  0x00, 0x76, 0x00, 0xC0, 0x03, // vÀ (U+0076 U+00C0)
  0x00, 0x76, 0x00, 0xC1, 0x03, // vÁ (U+0076 U+00C1)
  0x00, 0x76, 0x00, 0xC2, 0x03, // vÂ (U+0076 U+00C2)
  0x00, 0x76, 0x00, 0xC3, 0x03, // vÃ (U+0076 U+00C3)
  0x00, 0x76, 0x00, 0xC4, 0x03, // vÄ (U+0076 U+00C4)
  0x00, 0x76, 0x00, 0xC5, 0x03, // vÅ (U+0076 U+00C5)
  0x00, 0x76, 0x01, 0x00, 0x03, // vĀ (U+0076 U+0100)
  0x00, 0x76, 0x01, 0x02, 0x03, // vĂ (U+0076 U+0102)
  0x00, 0x76, 0x01, 0x04, 0x03, // vĄ (U+0076 U+0104)
  0x00, 0x76, 0x20, 0x1A, 0x04, // v‚ (U+0076 U+201A)
  0x00, 0x76, 0x20, 0x1E, 0x04, // v„ (U+0076 U+201E)
  0x00, 0x76, 0x20, 0x26, 0x04, // v… (U+0076 U+2026)
  0x00, 0x77, 0x00, 0x2C, 0x03, // w, (U+0077 U+002C)
  0x00, 0x77, 0x00, 0x2E, 0x03, // w. (U+0077 U+002E)
  0x00, 0x77, 0x00, 0x41, 0x02, // wA (U+0077 U+0041)
  0x00, 0x77, 0x00, 0xC0, 0x02, // wÀ (U+0077 U+00C0)
  0x00, 0x77, 0x00, 0xC1, 0x02, // wÁ (U+0077 U+00C1)
  0x00, 0x77, 0x00, 0xC2, 0x02, // wÂ (U+0077 U+00C2)
  0x00, 0x77, 0x00, 0xC3, 0x02, // wÃ (U+0077 U+00C3)
  0x00, 0x77, 0x00, 0xC4, 0x02, // wÄ (U+0077 U+00C4)
  0x00, 0x77, 0x00, 0xC5, 0x02, // wÅ (U+0077 U+00C5)
  0x00, 0x77, 0x01, 0x00, 0x02, // wĀ (U+0077 U+0100)
  0x00, 0x77, 0x01, 0x02, 0x02, // wĂ (U+0077 U+0102)
  0x00, 0x77, 0x01, 0x04, 0x02, // wĄ (U+0077 U+0104)
  0x00, 0x77, 0x20, 0x1A, 0x03, // w‚ (U+0077 U+201A)
  0x00, 0x77, 0x20, 0x1E, 0x03, // w„ (U+0077 U+201E)
  0x00, 0x77, 0x20, 0x26, 0x03, // w… (U+0077 U+2026)
  0x00, 0x79, 0x00, 0x2C, 0x05, // y, (U+0079 U+002C)
  0x00, 0x79, 0x00, 0x2E, 0x05, // y. (U+0079 U+002E)
  0x00, 0x79, 0x00, 0x41, 0x03, // yA (U+0079 U+0041)
  0x00, 0x79, 0x00, 0xC0, 0x03, // yÀ (U+0079 U+00C0)
  0x00, 0x79, 0x00, 0xC1, 0x03, // yÁ (U+0079 U+00C1)
  0x00, 0x79, 0x00, 0xC2, 0x03, // yÂ (U+0079 U+00C2)
  0x00, 0x79, 0x00, 0xC3, 0x03, // yÃ (U+0079 U+00C3)
  0x00, 0x79, 0x00, 0xC4, 0x03, // yÄ (U+0079 U+00C4)
  0x00, 0x79, 0x00, 0xC5, 0x03, // yÅ (U+0079 U+00C5)
  0x00, 0x79, 0x01, 0x00, 0x03, // yĀ (U+0079 U+0100)
  0x00, 0x79, 0x01, 0x02, 0x03, // yĂ (U+0079 U+0102)
  0x00, 0x79, 0x01, 0x04, 0x03, // yĄ (U+0079 U+0104)
  0x00, 0x79, 0x20, 0x1A, 0x05, // y‚ (U+0079 U+201A)
  0x00, 0x79, 0x20, 0x1E, 0x05, // y„ (U+0079 U+201E)
  0x00, 0x79, 0x20, 0x26, 0x05, // y… (U+0079 U+2026)
  0x00, 0xA1, 0x00, 0x56, 0x02, // ¡V (U+00A1 U+0056)
  0x00, 0xA1, 0x00, 0x57, 0x01, // ¡W (U+00A1 U+0057)
  0x00, 0xA1, 0x00, 0x59, 0x02, // ¡Y (U+00A1 U+0059)
  0x00, 0xA1, 0x00, 0xDD, 0x02, // ¡Ý (U+00A1 U+00DD)
  0x00, 0xA1, 0x01, 0x74, 0x01, // ¡Ŵ (U+00A1 U+0174)
  0x00, 0xA1, 0x01, 0x76, 0x02, // ¡Ŷ (U+00A1 U+0176)
  0x00, 0xA1, 0x01, 0x78, 0x02, // ¡Ÿ (U+00A1 U+0178)
  0x00, 0xBF, 0x00, 0x3F, 0x01, // ¿? (U+00BF U+003F)
  0x00, 0xBF, 0x00, 0x54, 0x01, // ¿T (U+00BF U+0054)
  0x00, 0xBF, 0x00, 0x56, 0x03, // ¿V (U+00BF U+0056)
  0x00, 0xBF, 0x00, 0x57, 0x03, // ¿W (U+00BF U+0057)
  0x00, 0xBF, 0x00, 0x59, 0x03, // ¿Y (U+00BF U+0059)
  0x00, 0xBF, 0x00, 0xDD, 0x03, // ¿Ý (U+00BF U+00DD)
  0x00, 0xBF, 0x01, 0x62, 0x01, // ¿Ţ (U+00BF U+0162)
  0x00, 0xBF, 0x01, 0x64, 0x01, // ¿Ť (U+00BF U+0164)
  0x00, 0xBF, 0x01, 0x66, 0x01, // ¿Ŧ (U+00BF U+0166)
  0x00, 0xBF, 0x01, 0x74, 0x03, // ¿Ŵ (U+00BF U+0174)
  0x00, 0xBF, 0x01, 0x76, 0x03, // ¿Ŷ (U+00BF U+0176)
  0x00, 0xBF, 0x01, 0x78, 0x03, // ¿Ÿ (U+00BF U+0178)
  0x00, 0xC0, 0x00, 0x22, 0x05, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x05, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x00, 0x2A, 0x04, // À* (U+00C0 U+002A)
  0x00, 0xC0, 0x00, 0x3F, 0x03, // À? (U+00C0 U+003F)
  0x00, 0xC0, 0x00, 0x43, 0x01, // ÀC (U+00C0 U+0043)
  0x00, 0xC0, 0x00, 0x47, 0x01, // ÀG (U+00C0 U+0047)
  0x00, 0xC0, 0x00, 0x4F, 0x01, // ÀO (U+00C0 U+004F)
  0x00, 0xC0, 0x00, 0x51, 0x01, // ÀQ (U+00C0 U+0051)
  0x00, 0xC0, 0x00, 0x54, 0x03, // ÀT (U+00C0 U+0054)
  0x00, 0xC0, 0x00, 0x55, 0x01, // ÀU (U+00C0 U+0055)
  0x00, 0xC0, 0x00, 0x56, 0x04, // ÀV (U+00C0 U+0056)
  0x00, 0xC0, 0x00, 0x57, 0x03, // ÀW (U+00C0 U+0057)
  0x00, 0xC0, 0x00, 0x59, 0x03, // ÀY (U+00C0 U+0059)
  0x00, 0xC0, 0x00, 0x63, 0x01, // Àc (U+00C0 U+0063)
  0x00, 0xC0, 0x00, 0x64, 0x01, // Àd (U+00C0 U+0064)
  0x00, 0xC0, 0x00, 0x65, 0x01, // Àe (U+00C0 U+0065)
  0x00, 0xC0, 0x00, 0x67, 0x01, // Àg (U+00C0 U+0067)
  0x00, 0xC0, 0x00, 0x6F, 0x01, // Ào (U+00C0 U+006F)
  0x00, 0xC0, 0x00, 0x71, 0x01, // Àq (U+00C0 U+0071)
  0x00, 0xC0, 0x00, 0x75, 0x01, // Àu (U+00C0 U+0075)
  0x00, 0xC0, 0x00, 0x76, 0x03, // Àv (U+00C0 U+0076)
  0x00, 0xC0, 0x00, 0x77, 0x02, // Àw (U+00C0 U+0077)
  0x00, 0xC0, 0x00, 0x79, 0x03, // Ày (U+00C0 U+0079)
  0x00, 0xC0, 0x00, 0xC7, 0x01, // ÀÇ (U+00C0 U+00C7)
  0x00, 0xC0, 0x00, 0xD2, 0x01, // ÀÒ (U+00C0 U+00D2)
  0x00, 0xC0, 0x00, 0xD3, 0x01, // ÀÓ (U+00C0 U+00D3)
  0x00, 0xC0, 0x00, 0xD4, 0x01, // ÀÔ (U+00C0 U+00D4)
  0x00, 0xC0, 0x00, 0xD5, 0x01, // ÀÕ (U+00C0 U+00D5)
  0x00, 0xC0, 0x00, 0xD6, 0x01, // ÀÖ (U+00C0 U+00D6)
  0x00, 0xC0, 0x00, 0xD8, 0x01, // ÀØ (U+00C0 U+00D8)
  0x00, 0xC0, 0x00, 0xD9, 0x01, // ÀÙ (U+00C0 U+00D9)
  0x00, 0xC0, 0x00, 0xDA, 0x01, // ÀÚ (U+00C0 U+00DA)
  0x00, 0xC0, 0x00, 0xDB, 0x01, // ÀÛ (U+00C0 U+00DB)
  0x00, 0xC0, 0x00, 0xDC, 0x01, // ÀÜ (U+00C0 U+00DC)
  0x00, 0xC0, 0x00, 0xDD, 0x03, // ÀÝ (U+00C0 U+00DD)
  0x00, 0xC0, 0x00, 0xE7, 0x01, // Àç (U+00C0 U+00E7)
  0x00, 0xC0, 0x00, 0xE8, 0x01, // Àè (U+00C0 U+00E8)
  0x00, 0xC0, 0x00, 0xE9, 0x01, // Àé (U+00C0 U+00E9)
  0x00, 0xC0, 0x00, 0xEA, 0x01, // Àê (U+00C0 U+00EA)
  0x00, 0xC0, 0x00, 0xEB, 0x01, // Àë (U+00C0 U+00EB)
  0x00, 0xC0, 0x00, 0xF0, 0x01, // Àð (U+00C0 U+00F0)
  0x00, 0xC0, 0x00, 0xF2, 0x01, // Àò (U+00C0 U+00F2)
  0x00, 0xC0, 0x00, 0xF3, 0x01, // Àó (U+00C0 U+00F3)
  0x00, 0xC0, 0x00, 0xF4, 0x01, // Àô (U+00C0 U+00F4)
  0x00, 0xC0, 0x00, 0xF5, 0x01, // Àõ (U+00C0 U+00F5)
  0x00, 0xC0, 0x00, 0xF6, 0x01, // Àö (U+00C0 U+00F6)
  0x00, 0xC0, 0x00, 0xF8, 0x01, // Àø (U+00C0 U+00F8)
  0x00, 0xC0, 0x00, 0xF9, 0x01, // Àù (U+00C0 U+00F9)
  0x00, 0xC0, 0x00, 0xFA, 0x01, // Àú (U+00C0 U+00FA)
  0x00, 0xC0, 0x00, 0xFB, 0x01, // Àû (U+00C0 U+00FB)
  0x00, 0xC0, 0x00, 0xFC, 0x01, // Àü (U+00C0 U+00FC)
  0x00, 0xC0, 0x00, 0xFD, 0x03, // Àý (U+00C0 U+00FD)
  0x00, 0xC0, 0x00, 0xFF, 0x03, // Àÿ (U+00C0 U+00FF)
  0x00, 0xC0, 0x01, 0x06, 0x01, // ÀĆ (U+00C0 U+0106)
  0x00, 0xC0, 0x01, 0x07, 0x01, // Àć (U+00C0 U+0107)
  0x00, 0xC0, 0x01, 0x08, 0x01, // ÀĈ (U+00C0 U+0108)
  0x00, 0xC0, 0x01, 0x09, 0x01, // Àĉ (U+00C0 U+0109)
  0x00, 0xC0, 0x01, 0x0A, 0x01, // ÀĊ (U+00C0 U+010A)
  0x00, 0xC0, 0x01, 0x0B, 0x01, // Àċ (U+00C0 U+010B)
  0x00, 0xC0, 0x01, 0x0C, 0x01, // ÀČ (U+00C0 U+010C)
  0x00, 0xC0, 0x01, 0x0D, 0x01, // Àč (U+00C0 U+010D)
  0x00, 0xC0, 0x01, 0x0F, 0x01, // Àď (U+00C0 U+010F)
  0x00, 0xC0, 0x01, 0x11, 0x01, // Àđ (U+00C0 U+0111)
  0x00, 0xC0, 0x01, 0x13, 0x01, // Àē (U+00C0 U+0113)
  0x00, 0xC0, 0x01, 0x15, 0x01, // Àĕ (U+00C0 U+0115)
  0x00, 0xC0, 0x01, 0x17, 0x01, // Àė (U+00C0 U+0117)
  0x00, 0xC0, 0x01, 0x19, 0x01, // Àę (U+00C0 U+0119)
  0x00, 0xC0, 0x01, 0x1B, 0x01, // Àě (U+00C0 U+011B)
  0x00, 0xC0, 0x01, 0x1C, 0x01, // ÀĜ (U+00C0 U+011C)
  0x00, 0xC0, 0x01, 0x1D, 0x01, // Àĝ (U+00C0 U+011D)
  0x00, 0xC0, 0x01, 0x1E, 0x01, // ÀĞ (U+00C0 U+011E)
  0x00, 0xC0, 0x01, 0x1F, 0x01, // Àğ (U+00C0 U+011F)
  0x00, 0xC0, 0x01, 0x20, 0x01, // ÀĠ (U+00C0 U+0120)
  0x00, 0xC0, 0x01, 0x21, 0x01, // Àġ (U+00C0 U+0121)
  0x00, 0xC0, 0x01, 0x22, 0x01, // ÀĢ (U+00C0 U+0122)
  0x00, 0xC0, 0x01, 0x23, 0x01, // Àģ (U+00C0 U+0123)
  0x00, 0xC0, 0x01, 0x4C, 0x01, // ÀŌ (U+00C0 U+014C)
  0x00, 0xC0, 0x01, 0x4D, 0x01, // Àō (U+00C0 U+014D)
  0x00, 0xC0, 0x01, 0x4E, 0x01, // ÀŎ (U+00C0 U+014E)
  0x00, 0xC0, 0x01, 0x4F, 0x01, // Àŏ (U+00C0 U+014F)
  0x00, 0xC0, 0x01, 0x50, 0x01, // ÀŐ (U+00C0 U+0150)
  0x00, 0xC0, 0x01, 0x51, 0x01, // Àő (U+00C0 U+0151)
  0x00, 0xC0, 0x01, 0x52, 0x01, // ÀŒ (U+00C0 U+0152)
  0x00, 0xC0, 0x01, 0x53, 0x01, // Àœ (U+00C0 U+0153)
  0x00, 0xC0, 0x01, 0x62, 0x03, // ÀŢ (U+00C0 U+0162)
  0x00, 0xC0, 0x01, 0x64, 0x03, // ÀŤ (U+00C0 U+0164)
  0x00, 0xC0, 0x01, 0x66, 0x03, // ÀŦ (U+00C0 U+0166)
  0x00, 0xC0, 0x01, 0x68, 0x01, // ÀŨ (U+00C0 U+0168)
  0x00, 0xC0, 0x01, 0x69, 0x01, // Àũ (U+00C0 U+0169)
  0x00, 0xC0, 0x01, 0x6A, 0x01, // ÀŪ (U+00C0 U+016A)
  0x00, 0xC0, 0x01, 0x6B, 0x01, // Àū (U+00C0 U+016B)
  0x00, 0xC0, 0x01, 0x6C, 0x01, // ÀŬ (U+00C0 U+016C)
  0x00, 0xC0, 0x01, 0x6D, 0x01, // Àŭ (U+00C0 U+016D)
  0x00, 0xC0, 0x01, 0x6E, 0x01, // ÀŮ (U+00C0 U+016E)
  0x00, 0xC0, 0x01, 0x6F, 0x01, // Àů (U+00C0 U+016F)
  0x00, 0xC0, 0x01, 0x70, 0x01, // ÀŰ (U+00C0 U+0170)
  0x00, 0xC0, 0x01, 0x71, 0x01, // Àű (U+00C0 U+0171)
  0x00, 0xC0, 0x01, 0x72, 0x01, // ÀŲ (U+00C0 U+0172)
  0x00, 0xC0, 0x01, 0x73, 0x01, // Àų (U+00C0 U+0173)
  0x00, 0xC0, 0x01, 0x74, 0x03, // ÀŴ (U+00C0 U+0174)
  0x00, 0xC0, 0x01, 0x75, 0x02, // Àŵ (U+00C0 U+0175)
  0x00, 0xC0, 0x01, 0x76, 0x03, // ÀŶ (U+00C0 U+0176)
  0x00, 0xC0, 0x01, 0x77, 0x03, // Àŷ (U+00C0 U+0177)
  0x00, 0xC0, 0x01, 0x78, 0x03, // ÀŸ (U+00C0 U+0178)
  0x00, 0xC0, 0x20, 0x18, 0x04, // À‘ (U+00C0 U+2018)
  0x00, 0xC0, 0x20, 0x19, 0x04, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1C, 0x04, // À“ (U+00C0 U+201C)
  0x00, 0xC0, 0x20, 0x1D, 0x04, // À” (U+00C0 U+201D)
  0x00, 0xC0, 0x21, 0x22, 0x04, // À™ (U+00C0 U+2122)
  0x00, 0xC1, 0x00, 0x22, 0x05, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x05, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x00, 0x2A, 0x04, // Á* (U+00C1 U+002A)
  0x00, 0xC1, 0x00, 0x3F, 0x03, // Á? (U+00C1 U+003F)
  0x00, 0xC1, 0x00, 0x43, 0x01, // ÁC (U+00C1 U+0043)
  0x00, 0xC1, 0x00, 0x47, 0x01, // ÁG (U+00C1 U+0047)
  0x00, 0xC1, 0x00, 0x4F, 0x01, // ÁO (U+00C1 U+004F)
  0x00, 0xC1, 0x00, 0x51, 0x01, // ÁQ (U+00C1 U+0051)
  0x00, 0xC1, 0x00, 0x54, 0x03, // ÁT (U+00C1 U+0054)
  0x00, 0xC1, 0x00, 0x55, 0x01, // ÁU (U+00C1 U+0055)
  0x00, 0xC1, 0x00, 0x56, 0x04, // ÁV (U+00C1 U+0056)
  0x00, 0xC1, 0x00, 0x57, 0x03, // ÁW (U+00C1 U+0057)
  0x00, 0xC1, 0x00, 0x59, 0x03, // ÁY (U+00C1 U+0059)
  0x00, 0xC1, 0x00, 0x63, 0x01, // Ác (U+00C1 U+0063)
  0x00, 0xC1, 0x00, 0x64, 0x01, // Ád (U+00C1 U+0064)
  0x00, 0xC1, 0x00, 0x65, 0x01, // Áe (U+00C1 U+0065)
  0x00, 0xC1, 0x00, 0x67, 0x01, // Ág (U+00C1 U+0067)
  0x00, 0xC1, 0x00, 0x6F, 0x01, // Áo (U+00C1 U+006F)
  0x00, 0xC1, 0x00, 0x71, 0x01, // Áq (U+00C1 U+0071)
  0x00, 0xC1, 0x00, 0x75, 0x01, // Áu (U+00C1 U+0075)
  0x00, 0xC1, 0x00, 0x76, 0x03, // Áv (U+00C1 U+0076)
  0x00, 0xC1, 0x00, 0x77, 0x02, // Áw (U+00C1 U+0077)
  0x00, 0xC1, 0x00, 0x79, 0x03, // Áy (U+00C1 U+0079)
  0x00, 0xC1, 0x00, 0xC7, 0x01, // ÁÇ (U+00C1 U+00C7)
  0x00, 0xC1, 0x00, 0xD2, 0x01, // ÁÒ (U+00C1 U+00D2)
  0x00, 0xC1, 0x00, 0xD3, 0x01, // ÁÓ (U+00C1 U+00D3)
  0x00, 0xC1, 0x00, 0xD4, 0x01, // ÁÔ (U+00C1 U+00D4)
  0x00, 0xC1, 0x00, 0xD5, 0x01, // ÁÕ (U+00C1 U+00D5)
  0x00, 0xC1, 0x00, 0xD6, 0x01, // ÁÖ (U+00C1 U+00D6)
  0x00, 0xC1, 0x00, 0xD8, 0x01, // ÁØ (U+00C1 U+00D8)
  0x00, 0xC1, 0x00, 0xD9, 0x01, // ÁÙ (U+00C1 U+00D9)
  0x00, 0xC1, 0x00, 0xDA, 0x01, // ÁÚ (U+00C1 U+00DA)
  0x00, 0xC1, 0x00, 0xDB, 0x01, // ÁÛ (U+00C1 U+00DB)
  0x00, 0xC1, 0x00, 0xDC, 0x01, // ÁÜ (U+00C1 U+00DC)
  0x00, 0xC1, 0x00, 0xDD, 0x03, // ÁÝ (U+00C1 U+00DD)
  0x00, 0xC1, 0x00, 0xE7, 0x01, // Áç (U+00C1 U+00E7)
  0x00, 0xC1, 0x00, 0xE8, 0x01, // Áè (U+00C1 U+00E8)
  0x00, 0xC1, 0x00, 0xE9, 0x01, // Áé (U+00C1 U+00E9)
  0x00, 0xC1, 0x00, 0xEA, 0x01, // Áê (U+00C1 U+00EA)
  0x00, 0xC1, 0x00, 0xEB, 0x01, // Áë (U+00C1 U+00EB)
  0x00, 0xC1, 0x00, 0xF0, 0x01, // Áð (U+00C1 U+00F0)
  0x00, 0xC1, 0x00, 0xF2, 0x01, // Áò (U+00C1 U+00F2)
  0x00, 0xC1, 0x00, 0xF3, 0x01, // Áó (U+00C1 U+00F3)
  0x00, 0xC1, 0x00, 0xF4, 0x01, // Áô (U+00C1 U+00F4)
  0x00, 0xC1, 0x00, 0xF5, 0x01, // Áõ (U+00C1 U+00F5)
  0x00, 0xC1, 0x00, 0xF6, 0x01, // Áö (U+00C1 U+00F6)
  0x00, 0xC1, 0x00, 0xF8, 0x01, // Áø (U+00C1 U+00F8)
  0x00, 0xC1, 0x00, 0xF9, 0x01, // Áù (U+00C1 U+00F9)
  0x00, 0xC1, 0x00, 0xFA, 0x01, // Áú (U+00C1 U+00FA)
  0x00, 0xC1, 0x00, 0xFB, 0x01, // Áû (U+00C1 U+00FB)
  0x00, 0xC1, 0x00, 0xFC, 0x01, // Áü (U+00C1 U+00FC)
  0x00, 0xC1, 0x00, 0xFD, 0x03, // Áý (U+00C1 U+00FD)
  0x00, 0xC1, 0x00, 0xFF, 0x03, // Áÿ (U+00C1 U+00FF)
  0x00, 0xC1, 0x01, 0x06, 0x01, // ÁĆ (U+00C1 U+0106)
  0x00, 0xC1, 0x01, 0x07, 0x01, // Áć (U+00C1 U+0107)
  0x00, 0xC1, 0x01, 0x08, 0x01, // ÁĈ (U+00C1 U+0108)
  0x00, 0xC1, 0x01, 0x09, 0x01, // Áĉ (U+00C1 U+0109)
  0x00, 0xC1, 0x01, 0x0A, 0x01, // ÁĊ (U+00C1 U+010A)
  0x00, 0xC1, 0x01, 0x0B, 0x01, // Áċ (U+00C1 U+010B)
  0x00, 0xC1, 0x01, 0x0C, 0x01, // ÁČ (U+00C1 U+010C)
  0x00, 0xC1, 0x01, 0x0D, 0x01, // Áč (U+00C1 U+010D)
  0x00, 0xC1, 0x01, 0x0F, 0x01, // Áď (U+00C1 U+010F)
  0x00, 0xC1, 0x01, 0x11, 0x01, // Áđ (U+00C1 U+0111)
  0x00, 0xC1, 0x01, 0x13, 0x01, // Áē (U+00C1 U+0113)
  0x00, 0xC1, 0x01, 0x15, 0x01, // Áĕ (U+00C1 U+0115)
  0x00, 0xC1, 0x01, 0x17, 0x01, // Áė (U+00C1 U+0117)
  0x00, 0xC1, 0x01, 0x19, 0x01, // Áę (U+00C1 U+0119)
  0x00, 0xC1, 0x01, 0x1B, 0x01, // Áě (U+00C1 U+011B)
  0x00, 0xC1, 0x01, 0x1C, 0x01, // ÁĜ (U+00C1 U+011C)
  0x00, 0xC1, 0x01, 0x1D, 0x01, // Áĝ (U+00C1 U+011D)
  0x00, 0xC1, 0x01, 0x1E, 0x01, // ÁĞ (U+00C1 U+011E)
  0x00, 0xC1, 0x01, 0x1F, 0x01, // Áğ (U+00C1 U+011F)
  0x00, 0xC1, 0x01, 0x20, 0x01, // ÁĠ (U+00C1 U+0120)
  0x00, 0xC1, 0x01, 0x21, 0x01, // Áġ (U+00C1 U+0121)
  0x00, 0xC1, 0x01, 0x22, 0x01, // ÁĢ (U+00C1 U+0122)
  0x00, 0xC1, 0x01, 0x23, 0x01, // Áģ (U+00C1 U+0123)
  0x00, 0xC1, 0x01, 0x4C, 0x01, // ÁŌ (U+00C1 U+014C)
  0x00, 0xC1, 0x01, 0x4D, 0x01, // Áō (U+00C1 U+014D)
  0x00, 0xC1, 0x01, 0x4E, 0x01, // ÁŎ (U+00C1 U+014E)
  0x00, 0xC1, 0x01, 0x4F, 0x01, // Áŏ (U+00C1 U+014F)
  0x00, 0xC1, 0x01, 0x50, 0x01, // ÁŐ (U+00C1 U+0150)
  0x00, 0xC1, 0x01, 0x51, 0x01, // Áő (U+00C1 U+0151)
  0x00, 0xC1, 0x01, 0x52, 0x01, // ÁŒ (U+00C1 U+0152)
  0x00, 0xC1, 0x01, 0x53, 0x01, // Áœ (U+00C1 U+0153)
  0x00, 0xC1, 0x01, 0x62, 0x03, // ÁŢ (U+00C1 U+0162)
  0x00, 0xC1, 0x01, 0x64, 0x03, // ÁŤ (U+00C1 U+0164)
  0x00, 0xC1, 0x01, 0x66, 0x03, // ÁŦ (U+00C1 U+0166)
  0x00, 0xC1, 0x01, 0x68, 0x01, // ÁŨ (U+00C1 U+0168)
  0x00, 0xC1, 0x01, 0x69, 0x01, // Áũ (U+00C1 U+0169)
  0x00, 0xC1, 0x01, 0x6A, 0x01, // ÁŪ (U+00C1 U+016A)
  0x00, 0xC1, 0x01, 0x6B, 0x01, // Áū (U+00C1 U+016B)
  0x00, 0xC1, 0x01, 0x6C, 0x01, // ÁŬ (U+00C1 U+016C)
  0x00, 0xC1, 0x01, 0x6D, 0x01, // Áŭ (U+00C1 U+016D)
  0x00, 0xC1, 0x01, 0x6E, 0x01, // ÁŮ (U+00C1 U+016E)
  0x00, 0xC1, 0x01, 0x6F, 0x01, // Áů (U+00C1 U+016F)
  0x00, 0xC1, 0x01, 0x70, 0x01, // ÁŰ (U+00C1 U+0170)
  0x00, 0xC1, 0x01, 0x71, 0x01, // Áű (U+00C1 U+0171)
  0x00, 0xC1, 0x01, 0x72, 0x01, // ÁŲ (U+00C1 U+0172)
  0x00, 0xC1, 0x01, 0x73, 0x01, // Áų (U+00C1 U+0173)
  0x00, 0xC1, 0x01, 0x74, 0x03, // ÁŴ (U+00C1 U+0174)
  0x00, 0xC1, 0x01, 0x75, 0x02, // Áŵ (U+00C1 U+0175)
  0x00, 0xC1, 0x01, 0x76, 0x03, // ÁŶ (U+00C1 U+0176)
  0x00, 0xC1, 0x01, 0x77, 0x03, // Áŷ (U+00C1 U+0177)
  0x00, 0xC1, 0x01, 0x78, 0x03, // ÁŸ (U+00C1 U+0178)
  0x00, 0xC1, 0x20, 0x18, 0x04, // Á‘ (U+00C1 U+2018)
  0x00, 0xC1, 0x20, 0x19, 0x04, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1C, 0x04, // Á“ (U+00C1 U+201C)
  0x00, 0xC1, 0x20, 0x1D, 0x04, // Á” (U+00C1 U+201D)
  0x00, 0xC1, 0x21, 0x22, 0x04, // Á™ (U+00C1 U+2122)
  0x00, 0xC2, 0x00, 0x22, 0x05, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x05, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x00, 0x2A, 0x04, // Â* (U+00C2 U+002A)
  0x00, 0xC2, 0x00, 0x3F, 0x03, // Â? (U+00C2 U+003F)
  0x00, 0xC2, 0x00, 0x43, 0x01, // ÂC (U+00C2 U+0043)
  0x00, 0xC2, 0x00, 0x47, 0x01, // ÂG (U+00C2 U+0047)
  0x00, 0xC2, 0x00, 0x4F, 0x01, // ÂO (U+00C2 U+004F)
  0x00, 0xC2, 0x00, 0x51, 0x01, // ÂQ (U+00C2 U+0051)
  0x00, 0xC2, 0x00, 0x54, 0x03, // ÂT (U+00C2 U+0054)
  0x00, 0xC2, 0x00, 0x55, 0x01, // ÂU (U+00C2 U+0055)
  0x00, 0xC2, 0x00, 0x56, 0x04, // ÂV (U+00C2 U+0056)
  0x00, 0xC2, 0x00, 0x57, 0x03, // ÂW (U+00C2 U+0057)
  0x00, 0xC2, 0x00, 0x59, 0x03, // ÂY (U+00C2 U+0059)
  0x00, 0xC2, 0x00, 0x63, 0x01, // Âc (U+00C2 U+0063)
  0x00, 0xC2, 0x00, 0x64, 0x01, // Âd (U+00C2 U+0064)
  0x00, 0xC2, 0x00, 0x65, 0x01, // Âe (U+00C2 U+0065)
  0x00, 0xC2, 0x00, 0x67, 0x01, // Âg (U+00C2 U+0067)
  0x00, 0xC2, 0x00, 0x6F, 0x01, // Âo (U+00C2 U+006F)
  0x00, 0xC2, 0x00, 0x71, 0x01, // Âq (U+00C2 U+0071)
  0x00, 0xC2, 0x00, 0x75, 0x01, // Âu (U+00C2 U+0075)
  0x00, 0xC2, 0x00, 0x76, 0x03, // Âv (U+00C2 U+0076)
  0x00, 0xC2, 0x00, 0x77, 0x02, // Âw (U+00C2 U+0077)
  0x00, 0xC2, 0x00, 0x79, 0x03, // Ây (U+00C2 U+0079)
  0x00, 0xC2, 0x00, 0xC7, 0x01, // ÂÇ (U+00C2 U+00C7)
  0x00, 0xC2, 0x00, 0xD2, 0x01, // ÂÒ (U+00C2 U+00D2)
  0x00, 0xC2, 0x00, 0xD3, 0x01, // ÂÓ (U+00C2 U+00D3)
  0x00, 0xC2, 0x00, 0xD4, 0x01, // ÂÔ (U+00C2 U+00D4)
  0x00, 0xC2, 0x00, 0xD5, 0x01, // ÂÕ (U+00C2 U+00D5)
  0x00, 0xC2, 0x00, 0xD6, 0x01, // ÂÖ (U+00C2 U+00D6)
  0x00, 0xC2, 0x00, 0xD8, 0x01, // ÂØ (U+00C2 U+00D8)
  0x00, 0xC2, 0x00, 0xD9, 0x01, // ÂÙ (U+00C2 U+00D9)
  0x00, 0xC2, 0x00, 0xDA, 0x01, // ÂÚ (U+00C2 U+00DA)
  0x00, 0xC2, 0x00, 0xDB, 0x01, // ÂÛ (U+00C2 U+00DB)
  0x00, 0xC2, 0x00, 0xDC, 0x01, // ÂÜ (U+00C2 U+00DC)
  0x00, 0xC2, 0x00, 0xDD, 0x03, // ÂÝ (U+00C2 U+00DD)
  0x00, 0xC2, 0x00, 0xE7, 0x01, // Âç (U+00C2 U+00E7)
  0x00, 0xC2, 0x00, 0xE8, 0x01, // Âè (U+00C2 U+00E8)
  0x00, 0xC2, 0x00, 0xE9, 0x01, // Âé (U+00C2 U+00E9)
  0x00, 0xC2, 0x00, 0xEA, 0x01, // Âê (U+00C2 U+00EA)
  0x00, 0xC2, 0x00, 0xEB, 0x01, // Âë (U+00C2 U+00EB)
  0x00, 0xC2, 0x00, 0xF0, 0x01, // Âð (U+00C2 U+00F0)
  0x00, 0xC2, 0x00, 0xF2, 0x01, // Âò (U+00C2 U+00F2)
  0x00, 0xC2, 0x00, 0xF3, 0x01, // Âó (U+00C2 U+00F3)
  0x00, 0xC2, 0x00, 0xF4, 0x01, // Âô (U+00C2 U+00F4)
  0x00, 0xC2, 0x00, 0xF5, 0x01, // Âõ (U+00C2 U+00F5)
  0x00, 0xC2, 0x00, 0xF6, 0x01, // Âö (U+00C2 U+00F6)
  0x00, 0xC2, 0x00, 0xF8, 0x01, // Âø (U+00C2 U+00F8)
  0x00, 0xC2, 0x00, 0xF9, 0x01, // Âù (U+00C2 U+00F9)
  0x00, 0xC2, 0x00, 0xFA, 0x01, // Âú (U+00C2 U+00FA)
  0x00, 0xC2, 0x00, 0xFB, 0x01, // Âû (U+00C2 U+00FB)
  0x00, 0xC2, 0x00, 0xFC, 0x01, // Âü (U+00C2 U+00FC)
  0x00, 0xC2, 0x00, 0xFD, 0x03, // Âý (U+00C2 U+00FD)
  0x00, 0xC2, 0x00, 0xFF, 0x03, // Âÿ (U+00C2 U+00FF)
  0x00, 0xC2, 0x01, 0x06, 0x01, // ÂĆ (U+00C2 U+0106)
  0x00, 0xC2, 0x01, 0x07, 0x01, // Âć (U+00C2 U+0107)
  0x00, 0xC2, 0x01, 0x08, 0x01, // ÂĈ (U+00C2 U+0108)
  0x00, 0xC2, 0x01, 0x09, 0x01, // Âĉ (U+00C2 U+0109)
  0x00, 0xC2, 0x01, 0x0A, 0x01, // ÂĊ (U+00C2 U+010A)
  0x00, 0xC2, 0x01, 0x0B, 0x01, // Âċ (U+00C2 U+010B)
  0x00, 0xC2, 0x01, 0x0C, 0x01, // ÂČ (U+00C2 U+010C)
  0x00, 0xC2, 0x01, 0x0D, 0x01, // Âč (U+00C2 U+010D)
  0x00, 0xC2, 0x01, 0x0F, 0x01, // Âď (U+00C2 U+010F)
  0x00, 0xC2, 0x01, 0x11, 0x01, // Âđ (U+00C2 U+0111)
  0x00, 0xC2, 0x01, 0x13, 0x01, // Âē (U+00C2 U+0113)
  0x00, 0xC2, 0x01, 0x15, 0x01, // Âĕ (U+00C2 U+0115)
  0x00, 0xC2, 0x01, 0x17, 0x01, // Âė (U+00C2 U+0117)
  0x00, 0xC2, 0x01, 0x19, 0x01, // Âę (U+00C2 U+0119)
  0x00, 0xC2, 0x01, 0x1B, 0x01, // Âě (U+00C2 U+011B)
  0x00, 0xC2, 0x01, 0x1C, 0x01, // ÂĜ (U+00C2 U+011C)
  0x00, 0xC2, 0x01, 0x1D, 0x01, // Âĝ (U+00C2 U+011D)
  0x00, 0xC2, 0x01, 0x1E, 0x01, // ÂĞ (U+00C2 U+011E)
  0x00, 0xC2, 0x01, 0x1F, 0x01, // Âğ (U+00C2 U+011F)
  0x00, 0xC2, 0x01, 0x20, 0x01, // ÂĠ (U+00C2 U+0120)
  0x00, 0xC2, 0x01, 0x21, 0x01, // Âġ (U+00C2 U+0121)
  0x00, 0xC2, 0x01, 0x22, 0x01, // ÂĢ (U+00C2 U+0122)
  0x00, 0xC2, 0x01, 0x23, 0x01, // Âģ (U+00C2 U+0123)
  0x00, 0xC2, 0x01, 0x4C, 0x01, // ÂŌ (U+00C2 U+014C)
  0x00, 0xC2, 0x01, 0x4D, 0x01, // Âō (U+00C2 U+014D)
  0x00, 0xC2, 0x01, 0x4E, 0x01, // ÂŎ (U+00C2 U+014E)
  0x00, 0xC2, 0x01, 0x4F, 0x01, // Âŏ (U+00C2 U+014F)
  0x00, 0xC2, 0x01, 0x50, 0x01, // ÂŐ (U+00C2 U+0150)
  0x00, 0xC2, 0x01, 0x51, 0x01, // Âő (U+00C2 U+0151)
  0x00, 0xC2, 0x01, 0x52, 0x01, // ÂŒ (U+00C2 U+0152)
  0x00, 0xC2, 0x01, 0x53, 0x01, // Âœ (U+00C2 U+0153)
  0x00, 0xC2, 0x01, 0x62, 0x03, // ÂŢ (U+00C2 U+0162)
  0x00, 0xC2, 0x01, 0x64, 0x03, // ÂŤ (U+00C2 U+0164)
  0x00, 0xC2, 0x01, 0x66, 0x03, // ÂŦ (U+00C2 U+0166)
  0x00, 0xC2, 0x01, 0x68, 0x01, // ÂŨ (U+00C2 U+0168)
  0x00, 0xC2, 0x01, 0x69, 0x01, // Âũ (U+00C2 U+0169)
  0x00, 0xC2, 0x01, 0x6A, 0x01, // ÂŪ (U+00C2 U+016A)
  0x00, 0xC2, 0x01, 0x6B, 0x01, // Âū (U+00C2 U+016B)
  0x00, 0xC2, 0x01, 0x6C, 0x01, // ÂŬ (U+00C2 U+016C)
  0x00, 0xC2, 0x01, 0x6D, 0x01, // Âŭ (U+00C2 U+016D)
  0x00, 0xC2, 0x01, 0x6E, 0x01, // ÂŮ (U+00C2 U+016E)
  0x00, 0xC2, 0x01, 0x6F, 0x01, // Âů (U+00C2 U+016F)
  0x00, 0xC2, 0x01, 0x70, 0x01, // ÂŰ (U+00C2 U+0170)
  0x00, 0xC2, 0x01, 0x71, 0x01, // Âű (U+00C2 U+0171)
  0x00, 0xC2, 0x01, 0x72, 0x01, // ÂŲ (U+00C2 U+0172)
  0x00, 0xC2, 0x01, 0x73, 0x01, // Âų (U+00C2 U+0173)
  0x00, 0xC2, 0x01, 0x74, 0x03, // ÂŴ (U+00C2 U+0174)
  0x00, 0xC2, 0x01, 0x75, 0x02, // Âŵ (U+00C2 U+0175)
  0x00, 0xC2, 0x01, 0x76, 0x03, // ÂŶ (U+00C2 U+0176)
  0x00, 0xC2, 0x01, 0x77, 0x03, // Âŷ (U+00C2 U+0177)
  0x00, 0xC2, 0x01, 0x78, 0x03, // ÂŸ (U+00C2 U+0178)
  0x00, 0xC2, 0x20, 0x18, 0x04, // Â‘ (U+00C2 U+2018)
  0x00, 0xC2, 0x20, 0x19, 0x04, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1C, 0x04, // Â“ (U+00C2 U+201C)
  0x00, 0xC2, 0x20, 0x1D, 0x04, // Â” (U+00C2 U+201D)
  0x00, 0xC2, 0x21, 0x22, 0x04, // Â™ (U+00C2 U+2122)
  0x00, 0xC3, 0x00, 0x22, 0x05, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x05, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x00, 0x2A, 0x04, // Ã* (U+00C3 U+002A)
  0x00, 0xC3, 0x00, 0x3F, 0x03, // Ã? (U+00C3 U+003F)
  0x00, 0xC3, 0x00, 0x43, 0x01, // ÃC (U+00C3 U+0043)
  0x00, 0xC3, 0x00, 0x47, 0x01, // ÃG (U+00C3 U+0047)
  0x00, 0xC3, 0x00, 0x4F, 0x01, // ÃO (U+00C3 U+004F)
  0x00, 0xC3, 0x00, 0x51, 0x01, // ÃQ (U+00C3 U+0051)
  0x00, 0xC3, 0x00, 0x54, 0x03, // ÃT (U+00C3 U+0054)
  0x00, 0xC3, 0x00, 0x55, 0x01, // ÃU (U+00C3 U+0055)
  0x00, 0xC3, 0x00, 0x56, 0x04, // ÃV (U+00C3 U+0056)
  0x00, 0xC3, 0x00, 0x57, 0x03, // ÃW (U+00C3 U+0057)
  0x00, 0xC3, 0x00, 0x59, 0x03, // ÃY (U+00C3 U+0059)
  0x00, 0xC3, 0x00, 0x63, 0x01, // Ãc (U+00C3 U+0063)
  0x00, 0xC3, 0x00, 0x64, 0x01, // Ãd (U+00C3 U+0064)
  0x00, 0xC3, 0x00, 0x65, 0x01, // Ãe (U+00C3 U+0065)
  0x00, 0xC3, 0x00, 0x67, 0x01, // Ãg (U+00C3 U+0067)
  0x00, 0xC3, 0x00, 0x6F, 0x01, // Ão (U+00C3 U+006F)
  0x00, 0xC3, 0x00, 0x71, 0x01, // Ãq (U+00C3 U+0071)
  0x00, 0xC3, 0x00, 0x75, 0x01, // Ãu (U+00C3 U+0075)
  0x00, 0xC3, 0x00, 0x76, 0x03, // Ãv (U+00C3 U+0076)
  0x00, 0xC3, 0x00, 0x77, 0x02, // Ãw (U+00C3 U+0077)
  0x00, 0xC3, 0x00, 0x79, 0x03, // Ãy (U+00C3 U+0079)
  0x00, 0xC3, 0x00, 0xC7, 0x01, // ÃÇ (U+00C3 U+00C7)
  0x00, 0xC3, 0x00, 0xD2, 0x01, // ÃÒ (U+00C3 U+00D2)
  0x00, 0xC3, 0x00, 0xD3, 0x01, // ÃÓ (U+00C3 U+00D3)
  0x00, 0xC3, 0x00, 0xD4, 0x01, // ÃÔ (U+00C3 U+00D4)
  0x00, 0xC3, 0x00, 0xD5, 0x01, // ÃÕ (U+00C3 U+00D5)
  0x00, 0xC3, 0x00, 0xD6, 0x01, // ÃÖ (U+00C3 U+00D6)
  0x00, 0xC3, 0x00, 0xD8, 0x01, // ÃØ (U+00C3 U+00D8)
  0x00, 0xC3, 0x00, 0xD9, 0x01, // ÃÙ (U+00C3 U+00D9)
  0x00, 0xC3, 0x00, 0xDA, 0x01, // ÃÚ (U+00C3 U+00DA)
  0x00, 0xC3, 0x00, 0xDB, 0x01, // ÃÛ (U+00C3 U+00DB)
  0x00, 0xC3, 0x00, 0xDC, 0x01, // ÃÜ (U+00C3 U+00DC)
  0x00, 0xC3, 0x00, 0xDD, 0x03, // ÃÝ (U+00C3 U+00DD)
  0x00, 0xC3, 0x00, 0xE7, 0x01, // Ãç (U+00C3 U+00E7)
  0x00, 0xC3, 0x00, 0xE8, 0x01, // Ãè (U+00C3 U+00E8)
  0x00, 0xC3, 0x00, 0xE9, 0x01, // Ãé (U+00C3 U+00E9)
  0x00, 0xC3, 0x00, 0xEA, 0x01, // Ãê (U+00C3 U+00EA)
  0x00, 0xC3, 0x00, 0xEB, 0x01, // Ãë (U+00C3 U+00EB)
  0x00, 0xC3, 0x00, 0xF0, 0x01, // Ãð (U+00C3 U+00F0)
  0x00, 0xC3, 0x00, 0xF2, 0x01, // Ãò (U+00C3 U+00F2)
  0x00, 0xC3, 0x00, 0xF3, 0x01, // Ãó (U+00C3 U+00F3)
  0x00, 0xC3, 0x00, 0xF4, 0x01, // Ãô (U+00C3 U+00F4)
  0x00, 0xC3, 0x00, 0xF5, 0x01, // Ãõ (U+00C3 U+00F5)
  0x00, 0xC3, 0x00, 0xF6, 0x01, // Ãö (U+00C3 U+00F6)
  0x00, 0xC3, 0x00, 0xF8, 0x01, // Ãø (U+00C3 U+00F8)
  0x00, 0xC3, 0x00, 0xF9, 0x01, // Ãù (U+00C3 U+00F9)
  0x00, 0xC3, 0x00, 0xFA, 0x01, // Ãú (U+00C3 U+00FA)
  0x00, 0xC3, 0x00, 0xFB, 0x01, // Ãû (U+00C3 U+00FB)
  0x00, 0xC3, 0x00, 0xFC, 0x01, // Ãü (U+00C3 U+00FC)
  0x00, 0xC3, 0x00, 0xFD, 0x03, // Ãý (U+00C3 U+00FD)
  0x00, 0xC3, 0x00, 0xFF, 0x03, // Ãÿ (U+00C3 U+00FF)
  0x00, 0xC3, 0x01, 0x06, 0x01, // ÃĆ (U+00C3 U+0106)
  0x00, 0xC3, 0x01, 0x07, 0x01, // Ãć (U+00C3 U+0107)
  0x00, 0xC3, 0x01, 0x08, 0x01, // ÃĈ (U+00C3 U+0108)
  0x00, 0xC3, 0x01, 0x09, 0x01, // Ãĉ (U+00C3 U+0109)
  0x00, 0xC3, 0x01, 0x0A, 0x01, // ÃĊ (U+00C3 U+010A)
  0x00, 0xC3, 0x01, 0x0B, 0x01, // Ãċ (U+00C3 U+010B)
  0x00, 0xC3, 0x01, 0x0C, 0x01, // ÃČ (U+00C3 U+010C)
  0x00, 0xC3, 0x01, 0x0D, 0x01, // Ãč (U+00C3 U+010D)
  0x00, 0xC3, 0x01, 0x0F, 0x01, // Ãď (U+00C3 U+010F)
  0x00, 0xC3, 0x01, 0x11, 0x01, // Ãđ (U+00C3 U+0111)
  0x00, 0xC3, 0x01, 0x13, 0x01, // Ãē (U+00C3 U+0113)
  0x00, 0xC3, 0x01, 0x15, 0x01, // Ãĕ (U+00C3 U+0115)
  0x00, 0xC3, 0x01, 0x17, 0x01, // Ãė (U+00C3 U+0117)
  0x00, 0xC3, 0x01, 0x19, 0x01, // Ãę (U+00C3 U+0119)
  0x00, 0xC3, 0x01, 0x1B, 0x01, // Ãě (U+00C3 U+011B)
  0x00, 0xC3, 0x01, 0x1C, 0x01, // ÃĜ (U+00C3 U+011C)
  0x00, 0xC3, 0x01, 0x1D, 0x01, // Ãĝ (U+00C3 U+011D)
  0x00, 0xC3, 0x01, 0x1E, 0x01, // ÃĞ (U+00C3 U+011E)
  0x00, 0xC3, 0x01, 0x1F, 0x01, // Ãğ (U+00C3 U+011F)
  0x00, 0xC3, 0x01, 0x20, 0x01, // ÃĠ (U+00C3 U+0120)
  0x00, 0xC3, 0x01, 0x21, 0x01, // Ãġ (U+00C3 U+0121)
  0x00, 0xC3, 0x01, 0x22, 0x01, // ÃĢ (U+00C3 U+0122)
  0x00, 0xC3, 0x01, 0x23, 0x01, // Ãģ (U+00C3 U+0123)
  0x00, 0xC3, 0x01, 0x4C, 0x01, // ÃŌ (U+00C3 U+014C)
  0x00, 0xC3, 0x01, 0x4D, 0x01, // Ãō (U+00C3 U+014D)
  0x00, 0xC3, 0x01, 0x4E, 0x01, // ÃŎ (U+00C3 U+014E)
  0x00, 0xC3, 0x01, 0x4F, 0x01, // Ãŏ (U+00C3 U+014F)
  0x00, 0xC3, 0x01, 0x50, 0x01, // ÃŐ (U+00C3 U+0150)
  0x00, 0xC3, 0x01, 0x51, 0x01, // Ãő (U+00C3 U+0151)
  0x00, 0xC3, 0x01, 0x52, 0x01, // ÃŒ (U+00C3 U+0152)
  0x00, 0xC3, 0x01, 0x53, 0x01, // Ãœ (U+00C3 U+0153)
  0x00, 0xC3, 0x01, 0x62, 0x03, // ÃŢ (U+00C3 U+0162)
  0x00, 0xC3, 0x01, 0x64, 0x03, // ÃŤ (U+00C3 U+0164)
  0x00, 0xC3, 0x01, 0x66, 0x03, // ÃŦ (U+00C3 U+0166)
  0x00, 0xC3, 0x01, 0x68, 0x01, // ÃŨ (U+00C3 U+0168)
  0x00, 0xC3, 0x01, 0x69, 0x01, // Ãũ (U+00C3 U+0169)
  0x00, 0xC3, 0x01, 0x6A, 0x01, // ÃŪ (U+00C3 U+016A)
  0x00, 0xC3, 0x01, 0x6B, 0x01, // Ãū (U+00C3 U+016B)
  0x00, 0xC3, 0x01, 0x6C, 0x01, // ÃŬ (U+00C3 U+016C)
  0x00, 0xC3, 0x01, 0x6D, 0x01, // Ãŭ (U+00C3 U+016D)
  0x00, 0xC3, 0x01, 0x6E, 0x01, // ÃŮ (U+00C3 U+016E)
  0x00, 0xC3, 0x01, 0x6F, 0x01, // Ãů (U+00C3 U+016F)
  0x00, 0xC3, 0x01, 0x70, 0x01, // ÃŰ (U+00C3 U+0170)
  0x00, 0xC3, 0x01, 0x71, 0x01, // Ãű (U+00C3 U+0171)
  0x00, 0xC3, 0x01, 0x72, 0x01, // ÃŲ (U+00C3 U+0172)
  0x00, 0xC3, 0x01, 0x73, 0x01, // Ãų (U+00C3 U+0173)
  0x00, 0xC3, 0x01, 0x74, 0x03, // ÃŴ (U+00C3 U+0174)
  0x00, 0xC3, 0x01, 0x75, 0x02, // Ãŵ (U+00C3 U+0175)
  0x00, 0xC3, 0x01, 0x76, 0x03, // ÃŶ (U+00C3 U+0176)
  0x00, 0xC3, 0x01, 0x77, 0x03, // Ãŷ (U+00C3 U+0177)
  0x00, 0xC3, 0x01, 0x78, 0x03, // ÃŸ (U+00C3 U+0178)
  0x00, 0xC3, 0x20, 0x18, 0x04, // Ã‘ (U+00C3 U+2018)
  0x00, 0xC3, 0x20, 0x19, 0x04, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1C, 0x04, // Ã“ (U+00C3 U+201C)
  0x00, 0xC3, 0x20, 0x1D, 0x04, // Ã” (U+00C3 U+201D)
  0x00, 0xC3, 0x21, 0x22, 0x04, // Ã™ (U+00C3 U+2122)
  0x00, 0xC4, 0x00, 0x22, 0x05, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x05, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x00, 0x2A, 0x04, // Ä* (U+00C4 U+002A)
  0x00, 0xC4, 0x00, 0x3F, 0x03, // Ä? (U+00C4 U+003F)
  0x00, 0xC4, 0x00, 0x43, 0x01, // ÄC (U+00C4 U+0043)
  0x00, 0xC4, 0x00, 0x47, 0x01, // ÄG (U+00C4 U+0047)
  0x00, 0xC4, 0x00, 0x4F, 0x01, // ÄO (U+00C4 U+004F)
  0x00, 0xC4, 0x00, 0x51, 0x01, // ÄQ (U+00C4 U+0051)
  0x00, 0xC4, 0x00, 0x54, 0x03, // ÄT (U+00C4 U+0054)
  0x00, 0xC4, 0x00, 0x55, 0x01, // ÄU (U+00C4 U+0055)
  0x00, 0xC4, 0x00, 0x56, 0x04, // ÄV (U+00C4 U+0056)
  0x00, 0xC4, 0x00, 0x57, 0x03, // ÄW (U+00C4 U+0057)
  0x00, 0xC4, 0x00, 0x59, 0x03, // ÄY (U+00C4 U+0059)
  0x00, 0xC4, 0x00, 0x63, 0x01, // Äc (U+00C4 U+0063)
  0x00, 0xC4, 0x00, 0x64, 0x01, // Äd (U+00C4 U+0064)
  0x00, 0xC4, 0x00, 0x65, 0x01, // Äe (U+00C4 U+0065)
  0x00, 0xC4, 0x00, 0x67, 0x01, // Äg (U+00C4 U+0067)
  0x00, 0xC4, 0x00, 0x6F, 0x01, // Äo (U+00C4 U+006F)
  0x00, 0xC4, 0x00, 0x71, 0x01, // Äq (U+00C4 U+0071)
  0x00, 0xC4, 0x00, 0x75, 0x01, // Äu (U+00C4 U+0075)
  0x00, 0xC4, 0x00, 0x76, 0x03, // Äv (U+00C4 U+0076)
  0x00, 0xC4, 0x00, 0x77, 0x02, // Äw (U+00C4 U+0077)
  0x00, 0xC4, 0x00, 0x79, 0x03, // Äy (U+00C4 U+0079)
  0x00, 0xC4, 0x00, 0xC7, 0x01, // ÄÇ (U+00C4 U+00C7)
  0x00, 0xC4, 0x00, 0xD2, 0x01, // ÄÒ (U+00C4 U+00D2)
  0x00, 0xC4, 0x00, 0xD3, 0x01, // ÄÓ (U+00C4 U+00D3)
  0x00, 0xC4, 0x00, 0xD4, 0x01, // ÄÔ (U+00C4 U+00D4)
  0x00, 0xC4, 0x00, 0xD5, 0x01, // ÄÕ (U+00C4 U+00D5)
  0x00, 0xC4, 0x00, 0xD6, 0x01, // ÄÖ (U+00C4 U+00D6)
  0x00, 0xC4, 0x00, 0xD8, 0x01, // ÄØ (U+00C4 U+00D8)
  0x00, 0xC4, 0x00, 0xD9, 0x01, // ÄÙ (U+00C4 U+00D9)
  0x00, 0xC4, 0x00, 0xDA, 0x01, // ÄÚ (U+00C4 U+00DA)
  0x00, 0xC4, 0x00, 0xDB, 0x01, // ÄÛ (U+00C4 U+00DB)
  0x00, 0xC4, 0x00, 0xDC, 0x01, // ÄÜ (U+00C4 U+00DC)
  0x00, 0xC4, 0x00, 0xDD, 0x03, // ÄÝ (U+00C4 U+00DD)
  0x00, 0xC4, 0x00, 0xE7, 0x01, // Äç (U+00C4 U+00E7)
  0x00, 0xC4, 0x00, 0xE8, 0x01, // Äè (U+00C4 U+00E8)
  0x00, 0xC4, 0x00, 0xE9, 0x01, // Äé (U+00C4 U+00E9)
  0x00, 0xC4, 0x00, 0xEA, 0x01, // Äê (U+00C4 U+00EA)
  0x00, 0xC4, 0x00, 0xEB, 0x01, // Äë (U+00C4 U+00EB)
  0x00, 0xC4, 0x00, 0xF0, 0x01, // Äð (U+00C4 U+00F0)
  0x00, 0xC4, 0x00, 0xF2, 0x01, // Äò (U+00C4 U+00F2)
  0x00, 0xC4, 0x00, 0xF3, 0x01, // Äó (U+00C4 U+00F3)
  0x00, 0xC4, 0x00, 0xF4, 0x01, // Äô (U+00C4 U+00F4)
  0x00, 0xC4, 0x00, 0xF5, 0x01, // Äõ (U+00C4 U+00F5)
  0x00, 0xC4, 0x00, 0xF6, 0x01, // Äö (U+00C4 U+00F6)
  0x00, 0xC4, 0x00, 0xF8, 0x01, // Äø (U+00C4 U+00F8)
  0x00, 0xC4, 0x00, 0xF9, 0x01, // Äù (U+00C4 U+00F9)
  0x00, 0xC4, 0x00, 0xFA, 0x01, // Äú (U+00C4 U+00FA)
  0x00, 0xC4, 0x00, 0xFB, 0x01, // Äû (U+00C4 U+00FB)
  0x00, 0xC4, 0x00, 0xFC, 0x01, // Äü (U+00C4 U+00FC)
  0x00, 0xC4, 0x00, 0xFD, 0x03, // Äý (U+00C4 U+00FD)
  0x00, 0xC4, 0x00, 0xFF, 0x03, // Äÿ (U+00C4 U+00FF)
  0x00, 0xC4, 0x01, 0x06, 0x01, // ÄĆ (U+00C4 U+0106)
  0x00, 0xC4, 0x01, 0x07, 0x01, // Äć (U+00C4 U+0107)
  0x00, 0xC4, 0x01, 0x08, 0x01, // ÄĈ (U+00C4 U+0108)
  0x00, 0xC4, 0x01, 0x09, 0x01, // Äĉ (U+00C4 U+0109)
  0x00, 0xC4, 0x01, 0x0A, 0x01, // ÄĊ (U+00C4 U+010A)
  0x00, 0xC4, 0x01, 0x0B, 0x01, // Äċ (U+00C4 U+010B)
  0x00, 0xC4, 0x01, 0x0C, 0x01, // ÄČ (U+00C4 U+010C)
  0x00, 0xC4, 0x01, 0x0D, 0x01, // Äč (U+00C4 U+010D)
  0x00, 0xC4, 0x01, 0x0F, 0x01, // Äď (U+00C4 U+010F)
  0x00, 0xC4, 0x01, 0x11, 0x01, // Äđ (U+00C4 U+0111)
  0x00, 0xC4, 0x01, 0x13, 0x01, // Äē (U+00C4 U+0113)
  0x00, 0xC4, 0x01, 0x15, 0x01, // Äĕ (U+00C4 U+0115)
  0x00, 0xC4, 0x01, 0x17, 0x01, // Äė (U+00C4 U+0117)
  0x00, 0xC4, 0x01, 0x19, 0x01, // Äę (U+00C4 U+0119)
  0x00, 0xC4, 0x01, 0x1B, 0x01, // Äě (U+00C4 U+011B)
  0x00, 0xC4, 0x01, 0x1C, 0x01, // ÄĜ (U+00C4 U+011C)
  0x00, 0xC4, 0x01, 0x1D, 0x01, // Äĝ (U+00C4 U+011D)
  0x00, 0xC4, 0x01, 0x1E, 0x01, // ÄĞ (U+00C4 U+011E)
  0x00, 0xC4, 0x01, 0x1F, 0x01, // Äğ (U+00C4 U+011F)
  0x00, 0xC4, 0x01, 0x20, 0x01, // ÄĠ (U+00C4 U+0120)
  0x00, 0xC4, 0x01, 0x21, 0x01, // Äġ (U+00C4 U+0121)
  0x00, 0xC4, 0x01, 0x22, 0x01, // ÄĢ (U+00C4 U+0122)
  0x00, 0xC4, 0x01, 0x23, 0x01, // Äģ (U+00C4 U+0123)
  0x00, 0xC4, 0x01, 0x4C, 0x01, // ÄŌ (U+00C4 U+014C)
  0x00, 0xC4, 0x01, 0x4D, 0x01, // Äō (U+00C4 U+014D)
  0x00, 0xC4, 0x01, 0x4E, 0x01, // ÄŎ (U+00C4 U+014E)
  0x00, 0xC4, 0x01, 0x4F, 0x01, // Äŏ (U+00C4 U+014F)
  0x00, 0xC4, 0x01, 0x50, 0x01, // ÄŐ (U+00C4 U+0150)
  0x00, 0xC4, 0x01, 0x51, 0x01, // Äő (U+00C4 U+0151)
  0x00, 0xC4, 0x01, 0x52, 0x01, // ÄŒ (U+00C4 U+0152)
  0x00, 0xC4, 0x01, 0x53, 0x01, // Äœ (U+00C4 U+0153)
  0x00, 0xC4, 0x01, 0x62, 0x03, // ÄŢ (U+00C4 U+0162)
  0x00, 0xC4, 0x01, 0x64, 0x03, // ÄŤ (U+00C4 U+0164)
  0x00, 0xC4, 0x01, 0x66, 0x03, // ÄŦ (U+00C4 U+0166)
  0x00, 0xC4, 0x01, 0x68, 0x01, // ÄŨ (U+00C4 U+0168)
  0x00, 0xC4, 0x01, 0x69, 0x01, // Äũ (U+00C4 U+0169)
  0x00, 0xC4, 0x01, 0x6A, 0x01, // ÄŪ (U+00C4 U+016A)
  0x00, 0xC4, 0x01, 0x6B, 0x01, // Äū (U+00C4 U+016B)
  0x00, 0xC4, 0x01, 0x6C, 0x01, // ÄŬ (U+00C4 U+016C)
  0x00, 0xC4, 0x01, 0x6D, 0x01, // Äŭ (U+00C4 U+016D)
  0x00, 0xC4, 0x01, 0x6E, 0x01, // ÄŮ (U+00C4 U+016E)
  0x00, 0xC4, 0x01, 0x6F, 0x01, // Äů (U+00C4 U+016F)
  0x00, 0xC4, 0x01, 0x70, 0x01, // ÄŰ (U+00C4 U+0170)
  0x00, 0xC4, 0x01, 0x71, 0x01, // Äű (U+00C4 U+0171)
  0x00, 0xC4, 0x01, 0x72, 0x01, // ÄŲ (U+00C4 U+0172)
  0x00, 0xC4, 0x01, 0x73, 0x01, // Äų (U+00C4 U+0173)
  0x00, 0xC4, 0x01, 0x74, 0x03, // ÄŴ (U+00C4 U+0174)
  0x00, 0xC4, 0x01, 0x75, 0x02, // Äŵ (U+00C4 U+0175)
  0x00, 0xC4, 0x01, 0x76, 0x03, // ÄŶ (U+00C4 U+0176)
  0x00, 0xC4, 0x01, 0x77, 0x03, // Äŷ (U+00C4 U+0177)
  0x00, 0xC4, 0x01, 0x78, 0x03, // ÄŸ (U+00C4 U+0178)
  0x00, 0xC4, 0x20, 0x18, 0x04, // Ä‘ (U+00C4 U+2018)
  0x00, 0xC4, 0x20, 0x19, 0x04, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1C, 0x04, // Ä“ (U+00C4 U+201C)
  0x00, 0xC4, 0x20, 0x1D, 0x04, // Ä” (U+00C4 U+201D)
  0x00, 0xC4, 0x21, 0x22, 0x04, // Ä™ (U+00C4 U+2122)
  0x00, 0xC5, 0x00, 0x22, 0x05, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x05, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x00, 0x2A, 0x04, // Å* (U+00C5 U+002A)
  0x00, 0xC5, 0x00, 0x3F, 0x03, // Å? (U+00C5 U+003F)
  0x00, 0xC5, 0x00, 0x43, 0x01, // ÅC (U+00C5 U+0043)
  0x00, 0xC5, 0x00, 0x47, 0x01, // ÅG (U+00C5 U+0047)
  0x00, 0xC5, 0x00, 0x4F, 0x01, // ÅO (U+00C5 U+004F)
  0x00, 0xC5, 0x00, 0x51, 0x01, // ÅQ (U+00C5 U+0051)
  0x00, 0xC5, 0x00, 0x54, 0x03, // ÅT (U+00C5 U+0054)
  0x00, 0xC5, 0x00, 0x55, 0x01, // ÅU (U+00C5 U+0055)
  0x00, 0xC5, 0x00, 0x56, 0x04, // ÅV (U+00C5 U+0056)
  0x00, 0xC5, 0x00, 0x57, 0x03, // ÅW (U+00C5 U+0057)
  0x00, 0xC5, 0x00, 0x59, 0x03, // ÅY (U+00C5 U+0059)
  0x00, 0xC5, 0x00, 0x63, 0x01, // Åc (U+00C5 U+0063)
  0x00, 0xC5, 0x00, 0x64, 0x01, // Åd (U+00C5 U+0064)
  0x00, 0xC5, 0x00, 0x65, 0x01, // Åe (U+00C5 U+0065)
  0x00, 0xC5, 0x00, 0x67, 0x01, // Åg (U+00C5 U+0067)
  0x00, 0xC5, 0x00, 0x6F, 0x01, // Åo (U+00C5 U+006F)
  0x00, 0xC5, 0x00, 0x71, 0x01, // Åq (U+00C5 U+0071)
  0x00, 0xC5, 0x00, 0x75, 0x01, // Åu (U+00C5 U+0075)
  0x00, 0xC5, 0x00, 0x76, 0x03, // Åv (U+00C5 U+0076)
  0x00, 0xC5, 0x00, 0x77, 0x02, // Åw (U+00C5 U+0077)
  0x00, 0xC5, 0x00, 0x79, 0x03, // Åy (U+00C5 U+0079)
  0x00, 0xC5, 0x00, 0xC7, 0x01, // ÅÇ (U+00C5 U+00C7)
  0x00, 0xC5, 0x00, 0xD2, 0x01, // ÅÒ (U+00C5 U+00D2)
  0x00, 0xC5, 0x00, 0xD3, 0x01, // ÅÓ (U+00C5 U+00D3)
  0x00, 0xC5, 0x00, 0xD4, 0x01, // ÅÔ (U+00C5 U+00D4)
  0x00, 0xC5, 0x00, 0xD5, 0x01, // ÅÕ (U+00C5 U+00D5)
  0x00, 0xC5, 0x00, 0xD6, 0x01, // ÅÖ (U+00C5 U+00D6)
  0x00, 0xC5, 0x00, 0xD8, 0x01, // ÅØ (U+00C5 U+00D8)
  0x00, 0xC5, 0x00, 0xD9, 0x01, // ÅÙ (U+00C5 U+00D9)
  0x00, 0xC5, 0x00, 0xDA, 0x01, // ÅÚ (U+00C5 U+00DA)
  0x00, 0xC5, 0x00, 0xDB, 0x01, // ÅÛ (U+00C5 U+00DB)
  0x00, 0xC5, 0x00, 0xDC, 0x01, // ÅÜ (U+00C5 U+00DC)
  0x00, 0xC5, 0x00, 0xDD, 0x03, // ÅÝ (U+00C5 U+00DD)
  0x00, 0xC5, 0x00, 0xE7, 0x01, // Åç (U+00C5 U+00E7)
  0x00, 0xC5, 0x00, 0xE8, 0x01, // Åè (U+00C5 U+00E8)
  0x00, 0xC5, 0x00, 0xE9, 0x01, // Åé (U+00C5 U+00E9)
  0x00, 0xC5, 0x00, 0xEA, 0x01, // Åê (U+00C5 U+00EA)
  0x00, 0xC5, 0x00, 0xEB, 0x01, // Åë (U+00C5 U+00EB)
  0x00, 0xC5, 0x00, 0xF0, 0x01, // Åð (U+00C5 U+00F0)
  0x00, 0xC5, 0x00, 0xF2, 0x01, // Åò (U+00C5 U+00F2)
  0x00, 0xC5, 0x00, 0xF3, 0x01, // Åó (U+00C5 U+00F3)
  0x00, 0xC5, 0x00, 0xF4, 0x01, // Åô (U+00C5 U+00F4)
  0x00, 0xC5, 0x00, 0xF5, 0x01, // Åõ (U+00C5 U+00F5)
  0x00, 0xC5, 0x00, 0xF6, 0x01, // Åö (U+00C5 U+00F6)
  0x00, 0xC5, 0x00, 0xF8, 0x01, // Åø (U+00C5 U+00F8)
  0x00, 0xC5, 0x00, 0xF9, 0x01, // Åù (U+00C5 U+00F9)
  0x00, 0xC5, 0x00, 0xFA, 0x01, // Åú (U+00C5 U+00FA)
  0x00, 0xC5, 0x00, 0xFB, 0x01, // Åû (U+00C5 U+00FB)
  0x00, 0xC5, 0x00, 0xFC, 0x01, // Åü (U+00C5 U+00FC)
  0x00, 0xC5, 0x00, 0xFD, 0x03, // Åý (U+00C5 U+00FD)
  0x00, 0xC5, 0x00, 0xFF, 0x03, // Åÿ (U+00C5 U+00FF)
  0x00, 0xC5, 0x01, 0x06, 0x01, // ÅĆ (U+00C5 U+0106)
  0x00, 0xC5, 0x01, 0x07, 0x01, // Åć (U+00C5 U+0107)
  0x00, 0xC5, 0x01, 0x08, 0x01, // ÅĈ (U+00C5 U+0108)
  0x00, 0xC5, 0x01, 0x09, 0x01, // Åĉ (U+00C5 U+0109)
  0x00, 0xC5, 0x01, 0x0A, 0x01, // ÅĊ (U+00C5 U+010A)
  0x00, 0xC5, 0x01, 0x0B, 0x01, // Åċ (U+00C5 U+010B)
  0x00, 0xC5, 0x01, 0x0C, 0x01, // ÅČ (U+00C5 U+010C)
  0x00, 0xC5, 0x01, 0x0D, 0x01, // Åč (U+00C5 U+010D)
  0x00, 0xC5, 0x01, 0x0F, 0x01, // Åď (U+00C5 U+010F)
  0x00, 0xC5, 0x01, 0x11, 0x01, // Åđ (U+00C5 U+0111)
  0x00, 0xC5, 0x01, 0x13, 0x01, // Åē (U+00C5 U+0113)
  0x00, 0xC5, 0x01, 0x15, 0x01, // Åĕ (U+00C5 U+0115)
  0x00, 0xC5, 0x01, 0x17, 0x01, // Åė (U+00C5 U+0117)
  0x00, 0xC5, 0x01, 0x19, 0x01, // Åę (U+00C5 U+0119)
  0x00, 0xC5, 0x01, 0x1B, 0x01, // Åě (U+00C5 U+011B)
  0x00, 0xC5, 0x01, 0x1C, 0x01, // ÅĜ (U+00C5 U+011C)
  0x00, 0xC5, 0x01, 0x1D, 0x01, // Åĝ (U+00C5 U+011D)
  0x00, 0xC5, 0x01, 0x1E, 0x01, // ÅĞ (U+00C5 U+011E)
  0x00, 0xC5, 0x01, 0x1F, 0x01, // Åğ (U+00C5 U+011F)
  0x00, 0xC5, 0x01, 0x20, 0x01, // ÅĠ (U+00C5 U+0120)
  0x00, 0xC5, 0x01, 0x21, 0x01, // Åġ (U+00C5 U+0121)
  0x00, 0xC5, 0x01, 0x22, 0x01, // ÅĢ (U+00C5 U+0122)
  0x00, 0xC5, 0x01, 0x23, 0x01, // Åģ (U+00C5 U+0123)
  0x00, 0xC5, 0x01, 0x4C, 0x01, // ÅŌ (U+00C5 U+014C)
  0x00, 0xC5, 0x01, 0x4D, 0x01, // Åō (U+00C5 U+014D)
  0x00, 0xC5, 0x01, 0x4E, 0x01, // ÅŎ (U+00C5 U+014E)
  0x00, 0xC5, 0x01, 0x4F, 0x01, // Åŏ (U+00C5 U+014F)
  0x00, 0xC5, 0x01, 0x50, 0x01, // ÅŐ (U+00C5 U+0150)
  0x00, 0xC5, 0x01, 0x51, 0x01, // Åő (U+00C5 U+0151)
  0x00, 0xC5, 0x01, 0x52, 0x01, // ÅŒ (U+00C5 U+0152)
  0x00, 0xC5, 0x01, 0x53, 0x01, // Åœ (U+00C5 U+0153)
  0x00, 0xC5, 0x01, 0x62, 0x03, // ÅŢ (U+00C5 U+0162)
  0x00, 0xC5, 0x01, 0x64, 0x03, // ÅŤ (U+00C5 U+0164)
  0x00, 0xC5, 0x01, 0x66, 0x03, // ÅŦ (U+00C5 U+0166)
  0x00, 0xC5, 0x01, 0x68, 0x01, // ÅŨ (U+00C5 U+0168)
  0x00, 0xC5, 0x01, 0x69, 0x01, // Åũ (U+00C5 U+0169)
  0x00, 0xC5, 0x01, 0x6A, 0x01, // ÅŪ (U+00C5 U+016A)
  0x00, 0xC5, 0x01, 0x6B, 0x01, // Åū (U+00C5 U+016B)
  0x00, 0xC5, 0x01, 0x6C, 0x01, // ÅŬ (U+00C5 U+016C)
  0x00, 0xC5, 0x01, 0x6D, 0x01, // Åŭ (U+00C5 U+016D)
  0x00, 0xC5, 0x01, 0x6E, 0x01, // ÅŮ (U+00C5 U+016E)
  0x00, 0xC5, 0x01, 0x6F, 0x01, // Åů (U+00C5 U+016F)
  0x00, 0xC5, 0x01, 0x70, 0x01, // ÅŰ (U+00C5 U+0170)
  0x00, 0xC5, 0x01, 0x71, 0x01, // Åű (U+00C5 U+0171)
  0x00, 0xC5, 0x01, 0x72, 0x01, // ÅŲ (U+00C5 U+0172)
  0x00, 0xC5, 0x01, 0x73, 0x01, // Åų (U+00C5 U+0173)
  0x00, 0xC5, 0x01, 0x74, 0x03, // ÅŴ (U+00C5 U+0174)
  0x00, 0xC5, 0x01, 0x75, 0x02, // Åŵ (U+00C5 U+0175)
  0x00, 0xC5, 0x01, 0x76, 0x03, // ÅŶ (U+00C5 U+0176)
  0x00, 0xC5, 0x01, 0x77, 0x03, // Åŷ (U+00C5 U+0177)
  0x00, 0xC5, 0x01, 0x78, 0x03, // ÅŸ (U+00C5 U+0178)
  0x00, 0xC5, 0x20, 0x18, 0x04, // Å‘ (U+00C5 U+2018)
  0x00, 0xC5, 0x20, 0x19, 0x04, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1C, 0x04, // Å“ (U+00C5 U+201C)
  0x00, 0xC5, 0x20, 0x1D, 0x04, // Å” (U+00C5 U+201D)
  0x00, 0xC5, 0x21, 0x22, 0x04, // Å™ (U+00C5 U+2122)
  0x00, 0xC6, 0x00, 0x56, 0x01, // ÆV (U+00C6 U+0056)
  0x00, 0xC6, 0x00, 0x57, 0x01, // ÆW (U+00C6 U+0057)
  0x00, 0xC6, 0x00, 0x59, 0x01, // ÆY (U+00C6 U+0059)
  0x00, 0xC6, 0x00, 0xDD, 0x01, // ÆÝ (U+00C6 U+00DD)
  0x00, 0xC6, 0x01, 0x74, 0x01, // ÆŴ (U+00C6 U+0174)
  0x00, 0xC6, 0x01, 0x76, 0x01, // ÆŶ (U+00C6 U+0176)
  0x00, 0xC6, 0x01, 0x78, 0x01, // ÆŸ (U+00C6 U+0178)
  0x00, 0xC8, 0x00, 0x56, 0x01, // ÈV (U+00C8 U+0056)
  0x00, 0xC8, 0x00, 0x57, 0x01, // ÈW (U+00C8 U+0057)
  0x00, 0xC8, 0x00, 0x59, 0x01, // ÈY (U+00C8 U+0059)
  0x00, 0xC8, 0x00, 0xDD, 0x01, // ÈÝ (U+00C8 U+00DD)
  0x00, 0xC8, 0x01, 0x74, 0x01, // ÈŴ (U+00C8 U+0174)
  0x00, 0xC8, 0x01, 0x76, 0x01, // ÈŶ (U+00C8 U+0176)
  0x00, 0xC8, 0x01, 0x78, 0x01, // ÈŸ (U+00C8 U+0178)
  0x00, 0xC9, 0x00, 0x56, 0x01, // ÉV (U+00C9 U+0056)
  0x00, 0xC9, 0x00, 0x57, 0x01, // ÉW (U+00C9 U+0057)
  0x00, 0xC9, 0x00, 0x59, 0x01, // ÉY (U+00C9 U+0059)
  0x00, 0xC9, 0x00, 0xDD, 0x01, // ÉÝ (U+00C9 U+00DD)
  0x00, 0xC9, 0x01, 0x74, 0x01, // ÉŴ (U+00C9 U+0174)
  0x00, 0xC9, 0x01, 0x76, 0x01, // ÉŶ (U+00C9 U+0176)
  0x00, 0xC9, 0x01, 0x78, 0x01, // ÉŸ (U+00C9 U+0178)
  0x00, 0xCA, 0x00, 0x56, 0x01, // ÊV (U+00CA U+0056)
  0x00, 0xCA, 0x00, 0x57, 0x01, // ÊW (U+00CA U+0057)
  0x00, 0xCA, 0x00, 0x59, 0x01, // ÊY (U+00CA U+0059)
  0x00, 0xCA, 0x00, 0xDD, 0x01, // ÊÝ (U+00CA U+00DD)
  0x00, 0xCA, 0x01, 0x74, 0x01, // ÊŴ (U+00CA U+0174)
  0x00, 0xCA, 0x01, 0x76, 0x01, // ÊŶ (U+00CA U+0176)
  0x00, 0xCA, 0x01, 0x78, 0x01, // ÊŸ (U+00CA U+0178)
  0x00, 0xCB, 0x00, 0x56, 0x01, // ËV (U+00CB U+0056)
  0x00, 0xCB, 0x00, 0x57, 0x01, // ËW (U+00CB U+0057)
  0x00, 0xCB, 0x00, 0x59, 0x01, // ËY (U+00CB U+0059)
  0x00, 0xCB, 0x00, 0xDD, 0x01, // ËÝ (U+00CB U+00DD)
  0x00, 0xCB, 0x01, 0x74, 0x01, // ËŴ (U+00CB U+0174)
  0x00, 0xCB, 0x01, 0x76, 0x01, // ËŶ (U+00CB U+0176)
  0x00, 0xCB, 0x01, 0x78, 0x01, // ËŸ (U+00CB U+0178)
  0x00, 0xD0, 0x00, 0x2C, 0x01, // Ð, (U+00D0 U+002C)
  0x00, 0xD0, 0x00, 0x2E, 0x01, // Ð. (U+00D0 U+002E)
  0x00, 0xD0, 0x00, 0x3F, 0x01, // Ð? (U+00D0 U+003F)
  0x00, 0xD0, 0x00, 0x41, 0x01, // ÐA (U+00D0 U+0041)
  0x00, 0xD0, 0x00, 0x54, 0x01, // ÐT (U+00D0 U+0054)
  0x00, 0xD0, 0x00, 0x56, 0x01, // ÐV (U+00D0 U+0056)
  0x00, 0xD0, 0x00, 0x57, 0x01, // ÐW (U+00D0 U+0057)
  0x00, 0xD0, 0x00, 0x58, 0x01, // ÐX (U+00D0 U+0058)
  0x00, 0xD0, 0x00, 0x59, 0x02, // ÐY (U+00D0 U+0059)
  0x00, 0xD0, 0x00, 0xC0, 0x01, // ÐÀ (U+00D0 U+00C0)
  0x00, 0xD0, 0x00, 0xC1, 0x01, // ÐÁ (U+00D0 U+00C1)
  0x00, 0xD0, 0x00, 0xC2, 0x01, // ÐÂ (U+00D0 U+00C2)
  0x00, 0xD0, 0x00, 0xC3, 0x01, // ÐÃ (U+00D0 U+00C3)
  0x00, 0xD0, 0x00, 0xC4, 0x01, // ÐÄ (U+00D0 U+00C4)
  0x00, 0xD0, 0x00, 0xC5, 0x01, // ÐÅ (U+00D0 U+00C5)
  0x00, 0xD0, 0x00, 0xC6, 0x03, // ÐÆ (U+00D0 U+00C6)
  0x00, 0xD0, 0x00, 0xDD, 0x02, // ÐÝ (U+00D0 U+00DD)
  0x00, 0xD0, 0x01, 0x00, 0x01, // ÐĀ (U+00D0 U+0100)
  0x00, 0xD0, 0x01, 0x02, 0x01, // ÐĂ (U+00D0 U+0102)
  0x00, 0xD0, 0x01, 0x04, 0x01, // ÐĄ (U+00D0 U+0104)
  0x00, 0xD0, 0x01, 0x62, 0x01, // ÐŢ (U+00D0 U+0162)
  0x00, 0xD0, 0x01, 0x64, 0x01, // ÐŤ (U+00D0 U+0164)
  0x00, 0xD0, 0x01, 0x66, 0x01, // ÐŦ (U+00D0 U+0166)
  0x00, 0xD0, 0x01, 0x74, 0x01, // ÐŴ (U+00D0 U+0174)
  0x00, 0xD0, 0x01, 0x76, 0x02, // ÐŶ (U+00D0 U+0176)
  0x00, 0xD0, 0x01, 0x78, 0x02, // ÐŸ (U+00D0 U+0178)
  0x00, 0xD0, 0x20, 0x1A, 0x01, // Ð‚ (U+00D0 U+201A)
  0x00, 0xD0, 0x20, 0x1E, 0x01, // Ð„ (U+00D0 U+201E)
  0x00, 0xD0, 0x20, 0x26, 0x01, // Ð… (U+00D0 U+2026)
  0x00, 0xD1, 0x00, 0xAB, 0x01, // Ñ« (U+00D1 U+00AB)
  0x00, 0xD1, 0x00, 0xBB, 0x01, // Ñ» (U+00D1 U+00BB)
  0x00, 0xD1, 0x20, 0x39, 0x01, // Ñ‹ (U+00D1 U+2039)
  0x00, 0xD1, 0x20, 0x3A, 0x01, // Ñ› (U+00D1 U+203A)
  0x00, 0xD2, 0x00, 0x2C, 0x01, // Ò, (U+00D2 U+002C)
  0x00, 0xD2, 0x00, 0x2E, 0x01, // Ò. (U+00D2 U+002E)
  0x00, 0xD2, 0x00, 0x3F, 0x01, // Ò? (U+00D2 U+003F)
  0x00, 0xD2, 0x00, 0x41, 0x01, // ÒA (U+00D2 U+0041)
  0x00, 0xD2, 0x00, 0x54, 0x01, // ÒT (U+00D2 U+0054)
  0x00, 0xD2, 0x00, 0x56, 0x01, // ÒV (U+00D2 U+0056)
  0x00, 0xD2, 0x00, 0x57, 0x01, // ÒW (U+00D2 U+0057)
  0x00, 0xD2, 0x00, 0x58, 0x01, // ÒX (U+00D2 U+0058)
  0x00, 0xD2, 0x00, 0x59, 0x02, // ÒY (U+00D2 U+0059)
  0x00, 0xD2, 0x00, 0xC0, 0x01, // ÒÀ (U+00D2 U+00C0)
  0x00, 0xD2, 0x00, 0xC1, 0x01, // ÒÁ (U+00D2 U+00C1)
  0x00, 0xD2, 0x00, 0xC2, 0x01, // ÒÂ (U+00D2 U+00C2)
  0x00, 0xD2, 0x00, 0xC3, 0x01, // ÒÃ (U+00D2 U+00C3)
  0x00, 0xD2, 0x00, 0xC4, 0x01, // ÒÄ (U+00D2 U+00C4)
  0x00, 0xD2, 0x00, 0xC5, 0x01, // ÒÅ (U+00D2 U+00C5)
  0x00, 0xD2, 0x00, 0xC6, 0x03, // ÒÆ (U+00D2 U+00C6)
  0x00, 0xD2, 0x00, 0xDD, 0x02, // ÒÝ (U+00D2 U+00DD)
  0x00, 0xD2, 0x01, 0x00, 0x01, // ÒĀ (U+00D2 U+0100)
  0x00, 0xD2, 0x01, 0x02, 0x01, // ÒĂ (U+00D2 U+0102)
  0x00, 0xD2, 0x01, 0x04, 0x01, // ÒĄ (U+00D2 U+0104)
  0x00, 0xD2, 0x01, 0x62, 0x01, // ÒŢ (U+00D2 U+0162)
  0x00, 0xD2, 0x01, 0x64, 0x01, // ÒŤ (U+00D2 U+0164)
  0x00, 0xD2, 0x01, 0x66, 0x01, // ÒŦ (U+00D2 U+0166)
  0x00, 0xD2, 0x01, 0x74, 0x01, // ÒŴ (U+00D2 U+0174)
  0x00, 0xD2, 0x01, 0x76, 0x02, // ÒŶ (U+00D2 U+0176)
  0x00, 0xD2, 0x01, 0x78, 0x02, // ÒŸ (U+00D2 U+0178)
  0x00, 0xD2, 0x20, 0x1A, 0x01, // Ò‚ (U+00D2 U+201A)
  0x00, 0xD2, 0x20, 0x1E, 0x01, // Ò„ (U+00D2 U+201E)
  0x00, 0xD2, 0x20, 0x26, 0x01, // Ò… (U+00D2 U+2026)
  0x00, 0xD3, 0x00, 0x2C, 0x01, // Ó, (U+00D3 U+002C)
  0x00, 0xD3, 0x00, 0x2E, 0x01, // Ó. (U+00D3 U+002E)
  0x00, 0xD3, 0x00, 0x3F, 0x01, // Ó? (U+00D3 U+003F)
  0x00, 0xD3, 0x00, 0x41, 0x01, // ÓA (U+00D3 U+0041)
  0x00, 0xD3, 0x00, 0x54, 0x01, // ÓT (U+00D3 U+0054)
  0x00, 0xD3, 0x00, 0x56, 0x01, // ÓV (U+00D3 U+0056)
  0x00, 0xD3, 0x00, 0x57, 0x01, // ÓW (U+00D3 U+0057)
  0x00, 0xD3, 0x00, 0x58, 0x01, // ÓX (U+00D3 U+0058)
  0x00, 0xD3, 0x00, 0x59, 0x02, // ÓY (U+00D3 U+0059)
  0x00, 0xD3, 0x00, 0xC0, 0x01, // ÓÀ (U+00D3 U+00C0)
  0x00, 0xD3, 0x00, 0xC1, 0x01, // ÓÁ (U+00D3 U+00C1)
  0x00, 0xD3, 0x00, 0xC2, 0x01, // ÓÂ (U+00D3 U+00C2)
  0x00, 0xD3, 0x00, 0xC3, 0x01, // ÓÃ (U+00D3 U+00C3)
  0x00, 0xD3, 0x00, 0xC4, 0x01, // ÓÄ (U+00D3 U+00C4)
  0x00, 0xD3, 0x00, 0xC5, 0x01, // ÓÅ (U+00D3 U+00C5)
  0x00, 0xD3, 0x00, 0xC6, 0x03, // ÓÆ (U+00D3 U+00C6)
  0x00, 0xD3, 0x00, 0xDD, 0x02, // ÓÝ (U+00D3 U+00DD)
  0x00, 0xD3, 0x01, 0x00, 0x01, // ÓĀ (U+00D3 U+0100)
  0x00, 0xD3, 0x01, 0x02, 0x01, // ÓĂ (U+00D3 U+0102)
  0x00, 0xD3, 0x01, 0x04, 0x01, // ÓĄ (U+00D3 U+0104)
  0x00, 0xD3, 0x01, 0x62, 0x01, // ÓŢ (U+00D3 U+0162)
  0x00, 0xD3, 0x01, 0x64, 0x01, // ÓŤ (U+00D3 U+0164)
  0x00, 0xD3, 0x01, 0x66, 0x01, // ÓŦ (U+00D3 U+0166)
  0x00, 0xD3, 0x01, 0x74, 0x01, // ÓŴ (U+00D3 U+0174)
  0x00, 0xD3, 0x01, 0x76, 0x02, // ÓŶ (U+00D3 U+0176)
  0x00, 0xD3, 0x01, 0x78, 0x02, // ÓŸ (U+00D3 U+0178)
  0x00, 0xD3, 0x20, 0x1A, 0x01, // Ó‚ (U+00D3 U+201A)
  0x00, 0xD3, 0x20, 0x1E, 0x01, // Ó„ (U+00D3 U+201E)
  0x00, 0xD3, 0x20, 0x26, 0x01, // Ó… (U+00D3 U+2026)
  0x00, 0xD4, 0x00, 0x2C, 0x01, // Ô, (U+00D4 U+002C)
  0x00, 0xD4, 0x00, 0x2E, 0x01, // Ô. (U+00D4 U+002E)
  0x00, 0xD4, 0x00, 0x3F, 0x01, // Ô? (U+00D4 U+003F)
  0x00, 0xD4, 0x00, 0x41, 0x01, // ÔA (U+00D4 U+0041)
  0x00, 0xD4, 0x00, 0x54, 0x01, // ÔT (U+00D4 U+0054)
  0x00, 0xD4, 0x00, 0x56, 0x01, // ÔV (U+00D4 U+0056)
  0x00, 0xD4, 0x00, 0x57, 0x01, // ÔW (U+00D4 U+0057)
  0x00, 0xD4, 0x00, 0x58, 0x01, // ÔX (U+00D4 U+0058)
  0x00, 0xD4, 0x00, 0x59, 0x02, // ÔY (U+00D4 U+0059)
  0x00, 0xD4, 0x00, 0xC0, 0x01, // ÔÀ (U+00D4 U+00C0)
  0x00, 0xD4, 0x00, 0xC1, 0x01, // ÔÁ (U+00D4 U+00C1)
  0x00, 0xD4, 0x00, 0xC2, 0x01, // ÔÂ (U+00D4 U+00C2)
  0x00, 0xD4, 0x00, 0xC3, 0x01, // ÔÃ (U+00D4 U+00C3)
  0x00, 0xD4, 0x00, 0xC4, 0x01, // ÔÄ (U+00D4 U+00C4)
  0x00, 0xD4, 0x00, 0xC5, 0x01, // ÔÅ (U+00D4 U+00C5)
  0x00, 0xD4, 0x00, 0xC6, 0x03, // ÔÆ (U+00D4 U+00C6)
  0x00, 0xD4, 0x00, 0xDD, 0x02, // ÔÝ (U+00D4 U+00DD)
  0x00, 0xD4, 0x01, 0x00, 0x01, // ÔĀ (U+00D4 U+0100)
  0x00, 0xD4, 0x01, 0x02, 0x01, // ÔĂ (U+00D4 U+0102)
  0x00, 0xD4, 0x01, 0x04, 0x01, // ÔĄ (U+00D4 U+0104)
  0x00, 0xD4, 0x01, 0x62, 0x01, // ÔŢ (U+00D4 U+0162)
  0x00, 0xD4, 0x01, 0x64, 0x01, // ÔŤ (U+00D4 U+0164)
  0x00, 0xD4, 0x01, 0x66, 0x01, // ÔŦ (U+00D4 U+0166)
  0x00, 0xD4, 0x01, 0x74, 0x01, // ÔŴ (U+00D4 U+0174)
  0x00, 0xD4, 0x01, 0x76, 0x02, // ÔŶ (U+00D4 U+0176)
  0x00, 0xD4, 0x01, 0x78, 0x02, // ÔŸ (U+00D4 U+0178)
  0x00, 0xD4, 0x20, 0x1A, 0x01, // Ô‚ (U+00D4 U+201A)
  0x00, 0xD4, 0x20, 0x1E, 0x01, // Ô„ (U+00D4 U+201E)
  0x00, 0xD4, 0x20, 0x26, 0x01, // Ô… (U+00D4 U+2026)
  0x00, 0xD5, 0x00, 0x2C, 0x01, // Õ, (U+00D5 U+002C)
  0x00, 0xD5, 0x00, 0x2E, 0x01, // Õ. (U+00D5 U+002E)
  0x00, 0xD5, 0x00, 0x3F, 0x01, // Õ? (U+00D5 U+003F)
  0x00, 0xD5, 0x00, 0x41, 0x01, // ÕA (U+00D5 U+0041)
  0x00, 0xD5, 0x00, 0x54, 0x01, // ÕT (U+00D5 U+0054)
  0x00, 0xD5, 0x00, 0x56, 0x01, // ÕV (U+00D5 U+0056)
  0x00, 0xD5, 0x00, 0x57, 0x01, // ÕW (U+00D5 U+0057)
  0x00, 0xD5, 0x00, 0x58, 0x01, // ÕX (U+00D5 U+0058)
  0x00, 0xD5, 0x00, 0x59, 0x02, // ÕY (U+00D5 U+0059)
  0x00, 0xD5, 0x00, 0xC0, 0x01, // ÕÀ (U+00D5 U+00C0)
  0x00, 0xD5, 0x00, 0xC1, 0x01, // ÕÁ (U+00D5 U+00C1)
  0x00, 0xD5, 0x00, 0xC2, 0x01, // ÕÂ (U+00D5 U+00C2)
  0x00, 0xD5, 0x00, 0xC3, 0x01, // ÕÃ (U+00D5 U+00C3)
  0x00, 0xD5, 0x00, 0xC4, 0x01, // ÕÄ (U+00D5 U+00C4)
  0x00, 0xD5, 0x00, 0xC5, 0x01, // ÕÅ (U+00D5 U+00C5)
  0x00, 0xD5, 0x00, 0xC6, 0x03, // ÕÆ (U+00D5 U+00C6)
  0x00, 0xD5, 0x00, 0xDD, 0x02, // ÕÝ (U+00D5 U+00DD)
  0x00, 0xD5, 0x01, 0x00, 0x01, // ÕĀ (U+00D5 U+0100)
  0x00, 0xD5, 0x01, 0x02, 0x01, // ÕĂ (U+00D5 U+0102)
  0x00, 0xD5, 0x01, 0x04, 0x01, // ÕĄ (U+00D5 U+0104)
  0x00, 0xD5, 0x01, 0x62, 0x01, // ÕŢ (U+00D5 U+0162)
  0x00, 0xD5, 0x01, 0x64, 0x01, // ÕŤ (U+00D5 U+0164)
  0x00, 0xD5, 0x01, 0x66, 0x01, // ÕŦ (U+00D5 U+0166)
  0x00, 0xD5, 0x01, 0x74, 0x01, // ÕŴ (U+00D5 U+0174)
  0x00, 0xD5, 0x01, 0x76, 0x02, // ÕŶ (U+00D5 U+0176)
  0x00, 0xD5, 0x01, 0x78, 0x02, // ÕŸ (U+00D5 U+0178)
  0x00, 0xD5, 0x20, 0x1A, 0x01, // Õ‚ (U+00D5 U+201A)
  0x00, 0xD5, 0x20, 0x1E, 0x01, // Õ„ (U+00D5 U+201E)
  0x00, 0xD5, 0x20, 0x26, 0x01, // Õ… (U+00D5 U+2026)
  0x00, 0xD6, 0x00, 0x2C, 0x01, // Ö, (U+00D6 U+002C)
  0x00, 0xD6, 0x00, 0x2E, 0x01, // Ö. (U+00D6 U+002E)
  0x00, 0xD6, 0x00, 0x3F, 0x01, // Ö? (U+00D6 U+003F)
  0x00, 0xD6, 0x00, 0x41, 0x01, // ÖA (U+00D6 U+0041)
  0x00, 0xD6, 0x00, 0x54, 0x01, // ÖT (U+00D6 U+0054)
  0x00, 0xD6, 0x00, 0x56, 0x01, // ÖV (U+00D6 U+0056)
  0x00, 0xD6, 0x00, 0x57, 0x01, // ÖW (U+00D6 U+0057)
  0x00, 0xD6, 0x00, 0x58, 0x01, // ÖX (U+00D6 U+0058)
  0x00, 0xD6, 0x00, 0x59, 0x02, // ÖY (U+00D6 U+0059)
  0x00, 0xD6, 0x00, 0xC0, 0x01, // ÖÀ (U+00D6 U+00C0)
  0x00, 0xD6, 0x00, 0xC1, 0x01, // ÖÁ (U+00D6 U+00C1)
  0x00, 0xD6, 0x00, 0xC2, 0x01, // ÖÂ (U+00D6 U+00C2)
  0x00, 0xD6, 0x00, 0xC3, 0x01, // ÖÃ (U+00D6 U+00C3)
  0x00, 0xD6, 0x00, 0xC4, 0x01, // ÖÄ (U+00D6 U+00C4)
  0x00, 0xD6, 0x00, 0xC5, 0x01, // ÖÅ (U+00D6 U+00C5)
  0x00, 0xD6, 0x00, 0xC6, 0x03, // ÖÆ (U+00D6 U+00C6)
  0x00, 0xD6, 0x00, 0xDD, 0x02, // ÖÝ (U+00D6 U+00DD)
  0x00, 0xD6, 0x01, 0x00, 0x01, // ÖĀ (U+00D6 U+0100)
  0x00, 0xD6, 0x01, 0x02, 0x01, // ÖĂ (U+00D6 U+0102)
  0x00, 0xD6, 0x01, 0x04, 0x01, // ÖĄ (U+00D6 U+0104)
  0x00, 0xD6, 0x01, 0x62, 0x01, // ÖŢ (U+00D6 U+0162)
  0x00, 0xD6, 0x01, 0x64, 0x01, // ÖŤ (U+00D6 U+0164)
  0x00, 0xD6, 0x01, 0x66, 0x01, // ÖŦ (U+00D6 U+0166)
  0x00, 0xD6, 0x01, 0x74, 0x01, // ÖŴ (U+00D6 U+0174)
  0x00, 0xD6, 0x01, 0x76, 0x02, // ÖŶ (U+00D6 U+0176)
  0x00, 0xD6, 0x01, 0x78, 0x02, // ÖŸ (U+00D6 U+0178)
  0x00, 0xD6, 0x20, 0x1A, 0x01, // Ö‚ (U+00D6 U+201A)
  0x00, 0xD6, 0x20, 0x1E, 0x01, // Ö„ (U+00D6 U+201E)
  0x00, 0xD6, 0x20, 0x26, 0x01, // Ö… (U+00D6 U+2026)
  0x00, 0xD8, 0x00, 0x2C, 0x01, // Ø, (U+00D8 U+002C)
  0x00, 0xD8, 0x00, 0x2E, 0x01, // Ø. (U+00D8 U+002E)
  0x00, 0xD8, 0x00, 0x3F, 0x01, // Ø? (U+00D8 U+003F)
  0x00, 0xD8, 0x00, 0x41, 0x01, // ØA (U+00D8 U+0041)
  0x00, 0xD8, 0x00, 0x54, 0x01, // ØT (U+00D8 U+0054)
  0x00, 0xD8, 0x00, 0x56, 0x01, // ØV (U+00D8 U+0056)
  0x00, 0xD8, 0x00, 0x57, 0x01, // ØW (U+00D8 U+0057)
  0x00, 0xD8, 0x00, 0x58, 0x01, // ØX (U+00D8 U+0058)
  0x00, 0xD8, 0x00, 0x59, 0x02, // ØY (U+00D8 U+0059)
  0x00, 0xD8, 0x00, 0xC0, 0x01, // ØÀ (U+00D8 U+00C0)
  0x00, 0xD8, 0x00, 0xC1, 0x01, // ØÁ (U+00D8 U+00C1)
  0x00, 0xD8, 0x00, 0xC2, 0x01, // ØÂ (U+00D8 U+00C2)
  0x00, 0xD8, 0x00, 0xC3, 0x01, // ØÃ (U+00D8 U+00C3)
  0x00, 0xD8, 0x00, 0xC4, 0x01, // ØÄ (U+00D8 U+00C4)
  0x00, 0xD8, 0x00, 0xC5, 0x01, // ØÅ (U+00D8 U+00C5)
  0x00, 0xD8, 0x00, 0xC6, 0x03, // ØÆ (U+00D8 U+00C6)
  0x00, 0xD8, 0x00, 0xDD, 0x02, // ØÝ (U+00D8 U+00DD)
  0x00, 0xD8, 0x01, 0x00, 0x01, // ØĀ (U+00D8 U+0100)
  0x00, 0xD8, 0x01, 0x02, 0x01, // ØĂ (U+00D8 U+0102)
  0x00, 0xD8, 0x01, 0x04, 0x01, // ØĄ (U+00D8 U+0104)
  0x00, 0xD8, 0x01, 0x62, 0x01, // ØŢ (U+00D8 U+0162)
  0x00, 0xD8, 0x01, 0x64, 0x01, // ØŤ (U+00D8 U+0164)
  0x00, 0xD8, 0x01, 0x66, 0x01, // ØŦ (U+00D8 U+0166)
  0x00, 0xD8, 0x01, 0x74, 0x01, // ØŴ (U+00D8 U+0174)
  0x00, 0xD8, 0x01, 0x76, 0x02, // ØŶ (U+00D8 U+0176)
  0x00, 0xD8, 0x01, 0x78, 0x02, // ØŸ (U+00D8 U+0178)
  0x00, 0xD8, 0x20, 0x1A, 0x01, // Ø‚ (U+00D8 U+201A)
  0x00, 0xD8, 0x20, 0x1E, 0x01, // Ø„ (U+00D8 U+201E)
  0x00, 0xD8, 0x20, 0x26, 0x01, // Ø… (U+00D8 U+2026)
  0x00, 0xD9, 0x00, 0x2C, 0x01, // Ù, (U+00D9 U+002C)
  0x00, 0xD9, 0x00, 0x2E, 0x01, // Ù. (U+00D9 U+002E)
  0x00, 0xD9, 0x00, 0x40, 0x01, // Ù@ (U+00D9 U+0040)
  0x00, 0xD9, 0x00, 0x41, 0x01, // ÙA (U+00D9 U+0041)
  0x00, 0xD9, 0x00, 0xC0, 0x01, // ÙÀ (U+00D9 U+00C0)
  0x00, 0xD9, 0x00, 0xC1, 0x01, // ÙÁ (U+00D9 U+00C1)
  0x00, 0xD9, 0x00, 0xC2, 0x01, // ÙÂ (U+00D9 U+00C2)
  0x00, 0xD9, 0x00, 0xC3, 0x01, // ÙÃ (U+00D9 U+00C3)
  0x00, 0xD9, 0x00, 0xC4, 0x01, // ÙÄ (U+00D9 U+00C4)
  0x00, 0xD9, 0x00, 0xC5, 0x01, // ÙÅ (U+00D9 U+00C5)
  0x00, 0xD9, 0x00, 0xC6, 0x02, // ÙÆ (U+00D9 U+00C6)
  0x00, 0xD9, 0x01, 0x00, 0x01, // ÙĀ (U+00D9 U+0100)
  0x00, 0xD9, 0x01, 0x02, 0x01, // ÙĂ (U+00D9 U+0102)
  0x00, 0xD9, 0x01, 0x04, 0x01, // ÙĄ (U+00D9 U+0104)
  0x00, 0xD9, 0x20, 0x1A, 0x01, // Ù‚ (U+00D9 U+201A)
  0x00, 0xD9, 0x20, 0x1E, 0x01, // Ù„ (U+00D9 U+201E)
  0x00, 0xD9, 0x20, 0x26, 0x01, // Ù… (U+00D9 U+2026)
  0x00, 0xDA, 0x00, 0x2C, 0x01, // Ú, (U+00DA U+002C)
  0x00, 0xDA, 0x00, 0x2E, 0x01, // Ú. (U+00DA U+002E)
  0x00, 0xDA, 0x00, 0x40, 0x01, // Ú@ (U+00DA U+0040)
  0x00, 0xDA, 0x00, 0x41, 0x01, // ÚA (U+00DA U+0041)
  0x00, 0xDA, 0x00, 0xC0, 0x01, // ÚÀ (U+00DA U+00C0)
  0x00, 0xDA, 0x00, 0xC1, 0x01, // ÚÁ (U+00DA U+00C1)
  0x00, 0xDA, 0x00, 0xC2, 0x01, // ÚÂ (U+00DA U+00C2)
  0x00, 0xDA, 0x00, 0xC3, 0x01, // ÚÃ (U+00DA U+00C3)
  0x00, 0xDA, 0x00, 0xC4, 0x01, // ÚÄ (U+00DA U+00C4)
  0x00, 0xDA, 0x00, 0xC5, 0x01, // ÚÅ (U+00DA U+00C5)
  0x00, 0xDA, 0x00, 0xC6, 0x02, // ÚÆ (U+00DA U+00C6)
  0x00, 0xDA, 0x01, 0x00, 0x01, // ÚĀ (U+00DA U+0100)
  0x00, 0xDA, 0x01, 0x02, 0x01, // ÚĂ (U+00DA U+0102)
  0x00, 0xDA, 0x01, 0x04, 0x01, // ÚĄ (U+00DA U+0104)
  0x00, 0xDA, 0x20, 0x1A, 0x01, // Ú‚ (U+00DA U+201A)
  0x00, 0xDA, 0x20, 0x1E, 0x01, // Ú„ (U+00DA U+201E)
  0x00, 0xDA, 0x20, 0x26, 0x01, // Ú… (U+00DA U+2026)
  0x00, 0xDB, 0x00, 0x2C, 0x01, // Û, (U+00DB U+002C)
  0x00, 0xDB, 0x00, 0x2E, 0x01, // Û. (U+00DB U+002E)
  0x00, 0xDB, 0x00, 0x40, 0x01, // Û@ (U+00DB U+0040)
  0x00, 0xDB, 0x00, 0x41, 0x01, // ÛA (U+00DB U+0041)
  0x00, 0xDB, 0x00, 0xC0, 0x01, // ÛÀ (U+00DB U+00C0)
  0x00, 0xDB, 0x00, 0xC1, 0x01, // ÛÁ (U+00DB U+00C1)
  0x00, 0xDB, 0x00, 0xC2, 0x01, // ÛÂ (U+00DB U+00C2)
  0x00, 0xDB, 0x00, 0xC3, 0x01, // ÛÃ (U+00DB U+00C3)
  0x00, 0xDB, 0x00, 0xC4, 0x01, // ÛÄ (U+00DB U+00C4)
  0x00, 0xDB, 0x00, 0xC5, 0x01, // ÛÅ (U+00DB U+00C5)
  0x00, 0xDB, 0x00, 0xC6, 0x02, // ÛÆ (U+00DB U+00C6)
  0x00, 0xDB, 0x01, 0x00, 0x01, // ÛĀ (U+00DB U+0100)
  0x00, 0xDB, 0x01, 0x02, 0x01, // ÛĂ (U+00DB U+0102)
  0x00, 0xDB, 0x01, 0x04, 0x01, // ÛĄ (U+00DB U+0104)
  0x00, 0xDB, 0x20, 0x1A, 0x01, // Û‚ (U+00DB U+201A)
  0x00, 0xDB, 0x20, 0x1E, 0x01, // Û„ (U+00DB U+201E)
  0x00, 0xDB, 0x20, 0x26, 0x01, // Û… (U+00DB U+2026)
  0x00, 0xDC, 0x00, 0x2C, 0x01, // Ü, (U+00DC U+002C)
  0x00, 0xDC, 0x00, 0x2E, 0x01, // Ü. (U+00DC U+002E)
  0x00, 0xDC, 0x00, 0x40, 0x01, // Ü@ (U+00DC U+0040)
  0x00, 0xDC, 0x00, 0x41, 0x01, // ÜA (U+00DC U+0041)
  0x00, 0xDC, 0x00, 0xC0, 0x01, // ÜÀ (U+00DC U+00C0)
  0x00, 0xDC, 0x00, 0xC1, 0x01, // ÜÁ (U+00DC U+00C1)
  0x00, 0xDC, 0x00, 0xC2, 0x01, // ÜÂ (U+00DC U+00C2)
  0x00, 0xDC, 0x00, 0xC3, 0x01, // ÜÃ (U+00DC U+00C3)
  0x00, 0xDC, 0x00, 0xC4, 0x01, // ÜÄ (U+00DC U+00C4)
  0x00, 0xDC, 0x00, 0xC5, 0x01, // ÜÅ (U+00DC U+00C5)
  0x00, 0xDC, 0x00, 0xC6, 0x02, // ÜÆ (U+00DC U+00C6)
  0x00, 0xDC, 0x01, 0x00, 0x01, // ÜĀ (U+00DC U+0100)
  0x00, 0xDC, 0x01, 0x02, 0x01, // ÜĂ (U+00DC U+0102)
  0x00, 0xDC, 0x01, 0x04, 0x01, // ÜĄ (U+00DC U+0104)
  0x00, 0xDC, 0x20, 0x1A, 0x01, // Ü‚ (U+00DC U+201A)
  0x00, 0xDC, 0x20, 0x1E, 0x01, // Ü„ (U+00DC U+201E)
  0x00, 0xDC, 0x20, 0x26, 0x01, // Ü… (U+00DC U+2026)
  0x00, 0xDD, 0x00, 0x26, 0x01, // Ý& (U+00DD U+0026)
  0x00, 0xDD, 0x00, 0x2C, 0x04, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x04, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x00, 0x40, 0x02, // Ý@ (U+00DD U+0040)
  0x00, 0xDD, 0x00, 0x41, 0x03, // ÝA (U+00DD U+0041)
  0x00, 0xDD, 0x00, 0x43, 0x02, // ÝC (U+00DD U+0043)
  0x00, 0xDD, 0x00, 0x47, 0x02, // ÝG (U+00DD U+0047)
  0x00, 0xDD, 0x00, 0x4F, 0x02, // ÝO (U+00DD U+004F)
  0x00, 0xDD, 0x00, 0x51, 0x02, // ÝQ (U+00DD U+0051)
  0x00, 0xDD, 0x00, 0x53, 0x01, // ÝS (U+00DD U+0053)
  0x00, 0xDD, 0x00, 0x61, 0x03, // Ýa (U+00DD U+0061)
  0x00, 0xDD, 0x00, 0x63, 0x03, // Ýc (U+00DD U+0063)
  0x00, 0xDD, 0x00, 0x64, 0x03, // Ýd (U+00DD U+0064)
  0x00, 0xDD, 0x00, 0x65, 0x03, // Ýe (U+00DD U+0065)
  0x00, 0xDD, 0x00, 0x67, 0x03, // Ýg (U+00DD U+0067)
  0x00, 0xDD, 0x00, 0x6F, 0x03, // Ýo (U+00DD U+006F)
  0x00, 0xDD, 0x00, 0x71, 0x03, // Ýq (U+00DD U+0071)
  0x00, 0xDD, 0x00, 0x73, 0x03, // Ýs (U+00DD U+0073)
  0x00, 0xDD, 0x00, 0x7A, 0x01, // Ýz (U+00DD U+007A)
  0x00, 0xDD, 0x00, 0xC0, 0x03, // ÝÀ (U+00DD U+00C0)
  0x00, 0xDD, 0x00, 0xC1, 0x03, // ÝÁ (U+00DD U+00C1)
  0x00, 0xDD, 0x00, 0xC2, 0x03, // ÝÂ (U+00DD U+00C2)
  0x00, 0xDD, 0x00, 0xC3, 0x03, // ÝÃ (U+00DD U+00C3)
  0x00, 0xDD, 0x00, 0xC4, 0x03, // ÝÄ (U+00DD U+00C4)
  0x00, 0xDD, 0x00, 0xC5, 0x03, // ÝÅ (U+00DD U+00C5)
  0x00, 0xDD, 0x00, 0xC6, 0x04, // ÝÆ (U+00DD U+00C6)
  0x00, 0xDD, 0x00, 0xC7, 0x02, // ÝÇ (U+00DD U+00C7)
  0x00, 0xDD, 0x00, 0xD2, 0x02, // ÝÒ (U+00DD U+00D2)
  0x00, 0xDD, 0x00, 0xD3, 0x02, // ÝÓ (U+00DD U+00D3)
  0x00, 0xDD, 0x00, 0xD4, 0x02, // ÝÔ (U+00DD U+00D4)
  0x00, 0xDD, 0x00, 0xD5, 0x02, // ÝÕ (U+00DD U+00D5)
  0x00, 0xDD, 0x00, 0xD6, 0x02, // ÝÖ (U+00DD U+00D6)
  0x00, 0xDD, 0x00, 0xD8, 0x02, // ÝØ (U+00DD U+00D8)
  0x00, 0xDD, 0x00, 0xE0, 0x03, // Ýà (U+00DD U+00E0)
  0x00, 0xDD, 0x00, 0xE1, 0x03, // Ýá (U+00DD U+00E1)
  0x00, 0xDD, 0x00, 0xE2, 0x03, // Ýâ (U+00DD U+00E2)
  0x00, 0xDD, 0x00, 0xE3, 0x03, // Ýã (U+00DD U+00E3)
  0x00, 0xDD, 0x00, 0xE4, 0x03, // Ýä (U+00DD U+00E4)
  0x00, 0xDD, 0x00, 0xE5, 0x03, // Ýå (U+00DD U+00E5)
  0x00, 0xDD, 0x00, 0xE6, 0x03, // Ýæ (U+00DD U+00E6)
  0x00, 0xDD, 0x00, 0xE7, 0x03, // Ýç (U+00DD U+00E7)
  0x00, 0xDD, 0x00, 0xE8, 0x03, // Ýè (U+00DD U+00E8)
  0x00, 0xDD, 0x00, 0xE9, 0x03, // Ýé (U+00DD U+00E9)
  0x00, 0xDD, 0x00, 0xEA, 0x03, // Ýê (U+00DD U+00EA)
  0x00, 0xDD, 0x00, 0xEB, 0x03, // Ýë (U+00DD U+00EB)
  0x00, 0xDD, 0x00, 0xF0, 0x03, // Ýð (U+00DD U+00F0)
  0x00, 0xDD, 0x00, 0xF2, 0x03, // Ýò (U+00DD U+00F2)
  0x00, 0xDD, 0x00, 0xF3, 0x03, // Ýó (U+00DD U+00F3)
  0x00, 0xDD, 0x00, 0xF4, 0x03, // Ýô (U+00DD U+00F4)
  0x00, 0xDD, 0x00, 0xF5, 0x03, // Ýõ (U+00DD U+00F5)
  0x00, 0xDD, 0x00, 0xF6, 0x03, // Ýö (U+00DD U+00F6)
  0x00, 0xDD, 0x00, 0xF8, 0x03, // Ýø (U+00DD U+00F8)
  0x00, 0xDD, 0x01, 0x00, 0x03, // ÝĀ (U+00DD U+0100)
  0x00, 0xDD, 0x01, 0x01, 0x03, // Ýā (U+00DD U+0101)
  0x00, 0xDD, 0x01, 0x02, 0x03, // ÝĂ (U+00DD U+0102)
  0x00, 0xDD, 0x01, 0x03, 0x03, // Ýă (U+00DD U+0103)
  0x00, 0xDD, 0x01, 0x04, 0x03, // ÝĄ (U+00DD U+0104)
  0x00, 0xDD, 0x01, 0x05, 0x03, // Ýą (U+00DD U+0105)
  0x00, 0xDD, 0x01, 0x06, 0x02, // ÝĆ (U+00DD U+0106)
  0x00, 0xDD, 0x01, 0x07, 0x03, // Ýć (U+00DD U+0107)
  0x00, 0xDD, 0x01, 0x08, 0x02, // ÝĈ (U+00DD U+0108)
  0x00, 0xDD, 0x01, 0x09, 0x03, // Ýĉ (U+00DD U+0109)
  0x00, 0xDD, 0x01, 0x0A, 0x02, // ÝĊ (U+00DD U+010A)
  0x00, 0xDD, 0x01, 0x0B, 0x03, // Ýċ (U+00DD U+010B)
  0x00, 0xDD, 0x01, 0x0C, 0x02, // ÝČ (U+00DD U+010C)
  0x00, 0xDD, 0x01, 0x0D, 0x03, // Ýč (U+00DD U+010D)
  0x00, 0xDD, 0x01, 0x0F, 0x03, // Ýď (U+00DD U+010F)
  0x00, 0xDD, 0x01, 0x11, 0x03, // Ýđ (U+00DD U+0111)
  0x00, 0xDD, 0x01, 0x13, 0x03, // Ýē (U+00DD U+0113)
  0x00, 0xDD, 0x01, 0x15, 0x03, // Ýĕ (U+00DD U+0115)
  0x00, 0xDD, 0x01, 0x17, 0x03, // Ýė (U+00DD U+0117)
  0x00, 0xDD, 0x01, 0x19, 0x03, // Ýę (U+00DD U+0119)
  0x00, 0xDD, 0x01, 0x1B, 0x03, // Ýě (U+00DD U+011B)
  0x00, 0xDD, 0x01, 0x1C, 0x02, // ÝĜ (U+00DD U+011C)
  0x00, 0xDD, 0x01, 0x1D, 0x03, // Ýĝ (U+00DD U+011D)
  0x00, 0xDD, 0x01, 0x1E, 0x02, // ÝĞ (U+00DD U+011E)
  0x00, 0xDD, 0x01, 0x1F, 0x03, // Ýğ (U+00DD U+011F)
  0x00, 0xDD, 0x01, 0x20, 0x02, // ÝĠ (U+00DD U+0120)
  0x00, 0xDD, 0x01, 0x21, 0x03, // Ýġ (U+00DD U+0121)
  0x00, 0xDD, 0x01, 0x22, 0x02, // ÝĢ (U+00DD U+0122)
  0x00, 0xDD, 0x01, 0x23, 0x03, // Ýģ (U+00DD U+0123)
  0x00, 0xDD, 0x01, 0x4C, 0x02, // ÝŌ (U+00DD U+014C)
  0x00, 0xDD, 0x01, 0x4D, 0x03, // Ýō (U+00DD U+014D)
  0x00, 0xDD, 0x01, 0x4E, 0x02, // ÝŎ (U+00DD U+014E)
  0x00, 0xDD, 0x01, 0x4F, 0x03, // Ýŏ (U+00DD U+014F)
  0x00, 0xDD, 0x01, 0x50, 0x02, // ÝŐ (U+00DD U+0150)
  0x00, 0xDD, 0x01, 0x51, 0x03, // Ýő (U+00DD U+0151)
  0x00, 0xDD, 0x01, 0x52, 0x02, // ÝŒ (U+00DD U+0152)
  0x00, 0xDD, 0x01, 0x53, 0x03, // Ýœ (U+00DD U+0153)
  0x00, 0xDD, 0x01, 0x5A, 0x01, // ÝŚ (U+00DD U+015A)
  0x00, 0xDD, 0x01, 0x5B, 0x03, // Ýś (U+00DD U+015B)
  0x00, 0xDD, 0x01, 0x5C, 0x01, // ÝŜ (U+00DD U+015C)
  0x00, 0xDD, 0x01, 0x5D, 0x03, // Ýŝ (U+00DD U+015D)
  0x00, 0xDD, 0x01, 0x5E, 0x01, // ÝŞ (U+00DD U+015E)
  0x00, 0xDD, 0x01, 0x5F, 0x03, // Ýş (U+00DD U+015F)
  0x00, 0xDD, 0x01, 0x60, 0x01, // ÝŠ (U+00DD U+0160)
  0x00, 0xDD, 0x01, 0x61, 0x03, // Ýš (U+00DD U+0161)
  0x00, 0xDD, 0x01, 0x7A, 0x01, // Ýź (U+00DD U+017A)
  0x00, 0xDD, 0x01, 0x7C, 0x01, // Ýż (U+00DD U+017C)
  0x00, 0xDD, 0x01, 0x7E, 0x01, // Ýž (U+00DD U+017E)
  0x00, 0xDD, 0x20, 0x1A, 0x04, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x04, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x04, // Ý… (U+00DD U+2026)
  0x00, 0xDE, 0x00, 0x2C, 0x01, // Þ, (U+00DE U+002C)
  0x00, 0xDE, 0x00, 0x2E, 0x01, // Þ. (U+00DE U+002E)
  0x00, 0xDE, 0x00, 0x3F, 0x01, // Þ? (U+00DE U+003F)
  0x00, 0xDE, 0x00, 0x41, 0x01, // ÞA (U+00DE U+0041)
  0x00, 0xDE, 0x00, 0x54, 0x01, // ÞT (U+00DE U+0054)
  0x00, 0xDE, 0x00, 0x56, 0x01, // ÞV (U+00DE U+0056)
  0x00, 0xDE, 0x00, 0x57, 0x01, // ÞW (U+00DE U+0057)
  0x00, 0xDE, 0x00, 0x58, 0x01, // ÞX (U+00DE U+0058)
  0x00, 0xDE, 0x00, 0x59, 0x02, // ÞY (U+00DE U+0059)
  0x00, 0xDE, 0x00, 0xC0, 0x01, // ÞÀ (U+00DE U+00C0)
  0x00, 0xDE, 0x00, 0xC1, 0x01, // ÞÁ (U+00DE U+00C1)
  0x00, 0xDE, 0x00, 0xC2, 0x01, // ÞÂ (U+00DE U+00C2)
  0x00, 0xDE, 0x00, 0xC3, 0x01, // ÞÃ (U+00DE U+00C3)
  0x00, 0xDE, 0x00, 0xC4, 0x01, // ÞÄ (U+00DE U+00C4)
  0x00, 0xDE, 0x00, 0xC5, 0x01, // ÞÅ (U+00DE U+00C5)
  0x00, 0xDE, 0x00, 0xC6, 0x03, // ÞÆ (U+00DE U+00C6)
  0x00, 0xDE, 0x00, 0xDD, 0x02, // ÞÝ (U+00DE U+00DD)
  0x00, 0xDE, 0x01, 0x00, 0x01, // ÞĀ (U+00DE U+0100)
  0x00, 0xDE, 0x01, 0x02, 0x01, // ÞĂ (U+00DE U+0102)
  0x00, 0xDE, 0x01, 0x04, 0x01, // ÞĄ (U+00DE U+0104)
  0x00, 0xDE, 0x01, 0x62, 0x01, // ÞŢ (U+00DE U+0162)
  0x00, 0xDE, 0x01, 0x64, 0x01, // ÞŤ (U+00DE U+0164)
  0x00, 0xDE, 0x01, 0x66, 0x01, // ÞŦ (U+00DE U+0166)
  0x00, 0xDE, 0x01, 0x74, 0x01, // ÞŴ (U+00DE U+0174)
  0x00, 0xDE, 0x01, 0x76, 0x02, // ÞŶ (U+00DE U+0176)
  0x00, 0xDE, 0x01, 0x78, 0x02, // ÞŸ (U+00DE U+0178)
  0x00, 0xDE, 0x20, 0x1A, 0x01, // Þ‚ (U+00DE U+201A)
  0x00, 0xDE, 0x20, 0x1E, 0x01, // Þ„ (U+00DE U+201E)
  0x00, 0xDE, 0x20, 0x26, 0x01, // Þ… (U+00DE U+2026)
  0x00, 0xDF, 0x00, 0x3F, 0x01, // ß? (U+00DF U+003F)
  0x00, 0xDF, 0x00, 0x41, 0x01, // ßA (U+00DF U+0041)
  0x00, 0xDF, 0x00, 0x54, 0x01, // ßT (U+00DF U+0054)
  0x00, 0xDF, 0x00, 0x56, 0x02, // ßV (U+00DF U+0056)
  0x00, 0xDF, 0x00, 0x57, 0x02, // ßW (U+00DF U+0057)
  0x00, 0xDF, 0x00, 0x59, 0x03, // ßY (U+00DF U+0059)
  0x00, 0xDF, 0x00, 0x79, 0x01, // ßy (U+00DF U+0079)
  0x00, 0xDF, 0x00, 0xC0, 0x01, // ßÀ (U+00DF U+00C0)
  0x00, 0xDF, 0x00, 0xC1, 0x01, // ßÁ (U+00DF U+00C1)
  0x00, 0xDF, 0x00, 0xC2, 0x01, // ßÂ (U+00DF U+00C2)
  0x00, 0xDF, 0x00, 0xC3, 0x01, // ßÃ (U+00DF U+00C3)
  0x00, 0xDF, 0x00, 0xC4, 0x01, // ßÄ (U+00DF U+00C4)
  0x00, 0xDF, 0x00, 0xC5, 0x01, // ßÅ (U+00DF U+00C5)
  0x00, 0xDF, 0x00, 0xDD, 0x03, // ßÝ (U+00DF U+00DD)
  0x00, 0xDF, 0x00, 0xFD, 0x01, // ßý (U+00DF U+00FD)
  0x00, 0xDF, 0x00, 0xFF, 0x01, // ßÿ (U+00DF U+00FF)
  0x00, 0xDF, 0x01, 0x00, 0x01, // ßĀ (U+00DF U+0100)
  0x00, 0xDF, 0x01, 0x02, 0x01, // ßĂ (U+00DF U+0102)
  0x00, 0xDF, 0x01, 0x04, 0x01, // ßĄ (U+00DF U+0104)
  0x00, 0xDF, 0x01, 0x62, 0x01, // ßŢ (U+00DF U+0162)
  0x00, 0xDF, 0x01, 0x64, 0x01, // ßŤ (U+00DF U+0164)
  0x00, 0xDF, 0x01, 0x66, 0x01, // ßŦ (U+00DF U+0166)
  0x00, 0xDF, 0x01, 0x74, 0x02, // ßŴ (U+00DF U+0174)
  0x00, 0xDF, 0x01, 0x76, 0x03, // ßŶ (U+00DF U+0176)
  0x00, 0xDF, 0x01, 0x77, 0x01, // ßŷ (U+00DF U+0177)
  0x00, 0xDF, 0x01, 0x78, 0x03, // ßŸ (U+00DF U+0178)
  0x00, 0xE0, 0x00, 0x22, 0x02, // à" (U+00E0 U+0022)
  0x00, 0xE0, 0x00, 0x27, 0x02, // à' (U+00E0 U+0027)
  0x00, 0xE0, 0x00, 0x3F, 0x01, // à? (U+00E0 U+003F)
  0x00, 0xE0, 0x00, 0x54, 0x01, // àT (U+00E0 U+0054)
  0x00, 0xE0, 0x00, 0x56, 0x02, // àV (U+00E0 U+0056)
  0x00, 0xE0, 0x00, 0x57, 0x02, // àW (U+00E0 U+0057)
  0x00, 0xE0, 0x00, 0x59, 0x02, // àY (U+00E0 U+0059)
  0x00, 0xE0, 0x00, 0x79, 0x01, // ày (U+00E0 U+0079)
  0x00, 0xE0, 0x00, 0xDD, 0x02, // àÝ (U+00E0 U+00DD)
  0x00, 0xE0, 0x00, 0xFD, 0x01, // àý (U+00E0 U+00FD)
  0x00, 0xE0, 0x00, 0xFF, 0x01, // àÿ (U+00E0 U+00FF)
  0x00, 0xE0, 0x01, 0x62, 0x01, // àŢ (U+00E0 U+0162)
  0x00, 0xE0, 0x01, 0x64, 0x01, // àŤ (U+00E0 U+0164)
  0x00, 0xE0, 0x01, 0x66, 0x01, // àŦ (U+00E0 U+0166)
  0x00, 0xE0, 0x01, 0x74, 0x02, // àŴ (U+00E0 U+0174)
  0x00, 0xE0, 0x01, 0x76, 0x02, // àŶ (U+00E0 U+0176)
  0x00, 0xE0, 0x01, 0x77, 0x01, // àŷ (U+00E0 U+0177)
  0x00, 0xE0, 0x01, 0x78, 0x02, // àŸ (U+00E0 U+0178)
  0x00, 0xE1, 0x00, 0x22, 0x02, // á" (U+00E1 U+0022)
  0x00, 0xE1, 0x00, 0x27, 0x02, // á' (U+00E1 U+0027)
  0x00, 0xE1, 0x00, 0x3F, 0x01, // á? (U+00E1 U+003F)
  0x00, 0xE1, 0x00, 0x54, 0x01, // áT (U+00E1 U+0054)
  0x00, 0xE1, 0x00, 0x56, 0x02, // áV (U+00E1 U+0056)
  0x00, 0xE1, 0x00, 0x57, 0x02, // áW (U+00E1 U+0057)
  0x00, 0xE1, 0x00, 0x59, 0x02, // áY (U+00E1 U+0059)
  0x00, 0xE1, 0x00, 0x79, 0x01, // áy (U+00E1 U+0079)
  0x00, 0xE1, 0x00, 0xDD, 0x02, // áÝ (U+00E1 U+00DD)
  0x00, 0xE1, 0x00, 0xFD, 0x01, // áý (U+00E1 U+00FD)
  0x00, 0xE1, 0x00, 0xFF, 0x01, // áÿ (U+00E1 U+00FF)
  0x00, 0xE1, 0x01, 0x62, 0x01, // áŢ (U+00E1 U+0162)
  0x00, 0xE1, 0x01, 0x64, 0x01, // áŤ (U+00E1 U+0164)
  0x00, 0xE1, 0x01, 0x66, 0x01, // áŦ (U+00E1 U+0166)
  0x00, 0xE1, 0x01, 0x74, 0x02, // áŴ (U+00E1 U+0174)
  0x00, 0xE1, 0x01, 0x76, 0x02, // áŶ (U+00E1 U+0176)
  0x00, 0xE1, 0x01, 0x77, 0x01, // áŷ (U+00E1 U+0177)
  0x00, 0xE1, 0x01, 0x78, 0x02, // áŸ (U+00E1 U+0178)
  0x00, 0xE2, 0x00, 0x22, 0x02, // â" (U+00E2 U+0022)
  0x00, 0xE2, 0x00, 0x27, 0x02, // â' (U+00E2 U+0027)
  0x00, 0xE2, 0x00, 0x3F, 0x01, // â? (U+00E2 U+003F)
  0x00, 0xE2, 0x00, 0x54, 0x01, // âT (U+00E2 U+0054)
  0x00, 0xE2, 0x00, 0x56, 0x02, // âV (U+00E2 U+0056)
  0x00, 0xE2, 0x00, 0x57, 0x02, // âW (U+00E2 U+0057)
  0x00, 0xE2, 0x00, 0x59, 0x02, // âY (U+00E2 U+0059)
  0x00, 0xE2, 0x00, 0x79, 0x01, // ây (U+00E2 U+0079)
  0x00, 0xE2, 0x00, 0xDD, 0x02, // âÝ (U+00E2 U+00DD)
  0x00, 0xE2, 0x00, 0xFD, 0x01, // âý (U+00E2 U+00FD)
  0x00, 0xE2, 0x00, 0xFF, 0x01, // âÿ (U+00E2 U+00FF)
  0x00, 0xE2, 0x01, 0x62, 0x01, // âŢ (U+00E2 U+0162)
  0x00, 0xE2, 0x01, 0x64, 0x01, // âŤ (U+00E2 U+0164)
  0x00, 0xE2, 0x01, 0x66, 0x01, // âŦ (U+00E2 U+0166)
  0x00, 0xE2, 0x01, 0x74, 0x02, // âŴ (U+00E2 U+0174)
  0x00, 0xE2, 0x01, 0x76, 0x02, // âŶ (U+00E2 U+0176)
  0x00, 0xE2, 0x01, 0x77, 0x01, // âŷ (U+00E2 U+0177)
  0x00, 0xE2, 0x01, 0x78, 0x02, // âŸ (U+00E2 U+0178)
  0x00, 0xE3, 0x00, 0x22, 0x02, // ã" (U+00E3 U+0022)
  0x00, 0xE3, 0x00, 0x27, 0x02, // ã' (U+00E3 U+0027)
  0x00, 0xE3, 0x00, 0x3F, 0x01, // ã? (U+00E3 U+003F)
  0x00, 0xE3, 0x00, 0x54, 0x01, // ãT (U+00E3 U+0054)
  0x00, 0xE3, 0x00, 0x56, 0x02, // ãV (U+00E3 U+0056)
  0x00, 0xE3, 0x00, 0x57, 0x02, // ãW (U+00E3 U+0057)
  0x00, 0xE3, 0x00, 0x59, 0x02, // ãY (U+00E3 U+0059)
  0x00, 0xE3, 0x00, 0x79, 0x01, // ãy (U+00E3 U+0079)
  0x00, 0xE3, 0x00, 0xDD, 0x02, // ãÝ (U+00E3 U+00DD)
  0x00, 0xE3, 0x00, 0xFD, 0x01, // ãý (U+00E3 U+00FD)
  0x00, 0xE3, 0x00, 0xFF, 0x01, // ãÿ (U+00E3 U+00FF)
  0x00, 0xE3, 0x01, 0x62, 0x01, // ãŢ (U+00E3 U+0162)
  0x00, 0xE3, 0x01, 0x64, 0x01, // ãŤ (U+00E3 U+0164)
  0x00, 0xE3, 0x01, 0x66, 0x01, // ãŦ (U+00E3 U+0166)
  0x00, 0xE3, 0x01, 0x74, 0x02, // ãŴ (U+00E3 U+0174)
  0x00, 0xE3, 0x01, 0x76, 0x02, // ãŶ (U+00E3 U+0176)
  0x00, 0xE3, 0x01, 0x77, 0x01, // ãŷ (U+00E3 U+0177)
  0x00, 0xE3, 0x01, 0x78, 0x02, // ãŸ (U+00E3 U+0178)
  0x00, 0xE4, 0x00, 0x22, 0x02, // ä" (U+00E4 U+0022)
  0x00, 0xE4, 0x00, 0x27, 0x02, // ä' (U+00E4 U+0027)
  0x00, 0xE4, 0x00, 0x3F, 0x01, // ä? (U+00E4 U+003F)
  0x00, 0xE4, 0x00, 0x54, 0x01, // äT (U+00E4 U+0054)
  0x00, 0xE4, 0x00, 0x56, 0x02, // äV (U+00E4 U+0056)
  0x00, 0xE4, 0x00, 0x57, 0x02, // äW (U+00E4 U+0057)
  0x00, 0xE4, 0x00, 0x59, 0x02, // äY (U+00E4 U+0059)
  0x00, 0xE4, 0x00, 0x79, 0x01, // äy (U+00E4 U+0079)
  0x00, 0xE4, 0x00, 0xDD, 0x02, // äÝ (U+00E4 U+00DD)
  0x00, 0xE4, 0x00, 0xFD, 0x01, // äý (U+00E4 U+00FD)
  0x00, 0xE4, 0x00, 0xFF, 0x01, // äÿ (U+00E4 U+00FF)
  0x00, 0xE4, 0x01, 0x62, 0x01, // äŢ (U+00E4 U+0162)
  0x00, 0xE4, 0x01, 0x64, 0x01, // äŤ (U+00E4 U+0164)
  0x00, 0xE4, 0x01, 0x66, 0x01, // äŦ (U+00E4 U+0166)
  0x00, 0xE4, 0x01, 0x74, 0x02, // äŴ (U+00E4 U+0174)
  0x00, 0xE4, 0x01, 0x76, 0x02, // äŶ (U+00E4 U+0176)
  0x00, 0xE4, 0x01, 0x77, 0x01, // äŷ (U+00E4 U+0177)
  0x00, 0xE4, 0x01, 0x78, 0x02, // äŸ (U+00E4 U+0178)
  0x00, 0xE5, 0x00, 0x22, 0x02, // å" (U+00E5 U+0022)
  0x00, 0xE5, 0x00, 0x27, 0x02, // å' (U+00E5 U+0027)
  0x00, 0xE5, 0x00, 0x3F, 0x01, // å? (U+00E5 U+003F)
  0x00, 0xE5, 0x00, 0x54, 0x01, // åT (U+00E5 U+0054)
  0x00, 0xE5, 0x00, 0x56, 0x02, // åV (U+00E5 U+0056)
  0x00, 0xE5, 0x00, 0x57, 0x02, // åW (U+00E5 U+0057)
  0x00, 0xE5, 0x00, 0x59, 0x02, // åY (U+00E5 U+0059)
  0x00, 0xE5, 0x00, 0x79, 0x01, // åy (U+00E5 U+0079)
  0x00, 0xE5, 0x00, 0xDD, 0x02, // åÝ (U+00E5 U+00DD)
  0x00, 0xE5, 0x00, 0xFD, 0x01, // åý (U+00E5 U+00FD)
  0x00, 0xE5, 0x00, 0xFF, 0x01, // åÿ (U+00E5 U+00FF)
  0x00, 0xE5, 0x01, 0x62, 0x01, // åŢ (U+00E5 U+0162)
  0x00, 0xE5, 0x01, 0x64, 0x01, // åŤ (U+00E5 U+0164)
  0x00, 0xE5, 0x01, 0x66, 0x01, // åŦ (U+00E5 U+0166)
  0x00, 0xE5, 0x01, 0x74, 0x02, // åŴ (U+00E5 U+0174)
  0x00, 0xE5, 0x01, 0x76, 0x02, // åŶ (U+00E5 U+0176)
  0x00, 0xE5, 0x01, 0x77, 0x01, // åŷ (U+00E5 U+0177)
  0x00, 0xE5, 0x01, 0x78, 0x02, // åŸ (U+00E5 U+0178)
  0x00, 0xE6, 0x00, 0x56, 0x02, // æV (U+00E6 U+0056)
  0x00, 0xE6, 0x00, 0x57, 0x02, // æW (U+00E6 U+0057)
  0x00, 0xE6, 0x00, 0x59, 0x03, // æY (U+00E6 U+0059)
  0x00, 0xE6, 0x00, 0xDD, 0x03, // æÝ (U+00E6 U+00DD)
  0x00, 0xE6, 0x01, 0x74, 0x02, // æŴ (U+00E6 U+0174)
  0x00, 0xE6, 0x01, 0x76, 0x03, // æŶ (U+00E6 U+0176)
  0x00, 0xE6, 0x01, 0x78, 0x03, // æŸ (U+00E6 U+0178)
  0x00, 0xE8, 0x00, 0x56, 0x02, // èV (U+00E8 U+0056)
  0x00, 0xE8, 0x00, 0x57, 0x02, // èW (U+00E8 U+0057)
  0x00, 0xE8, 0x00, 0x59, 0x03, // èY (U+00E8 U+0059)
  0x00, 0xE8, 0x00, 0xDD, 0x03, // èÝ (U+00E8 U+00DD)
  0x00, 0xE8, 0x01, 0x74, 0x02, // èŴ (U+00E8 U+0174)
  0x00, 0xE8, 0x01, 0x76, 0x03, // èŶ (U+00E8 U+0176)
  0x00, 0xE8, 0x01, 0x78, 0x03, // èŸ (U+00E8 U+0178)
  0x00, 0xE9, 0x00, 0x56, 0x02, // éV (U+00E9 U+0056)
  0x00, 0xE9, 0x00, 0x57, 0x02, // éW (U+00E9 U+0057)
  0x00, 0xE9, 0x00, 0x59, 0x03, // éY (U+00E9 U+0059)
  0x00, 0xE9, 0x00, 0xDD, 0x03, // éÝ (U+00E9 U+00DD)
  0x00, 0xE9, 0x01, 0x74, 0x02, // éŴ (U+00E9 U+0174)
  0x00, 0xE9, 0x01, 0x76, 0x03, // éŶ (U+00E9 U+0176)
  0x00, 0xE9, 0x01, 0x78, 0x03, // éŸ (U+00E9 U+0178)
  0x00, 0xEA, 0x00, 0x56, 0x02, // êV (U+00EA U+0056)
  0x00, 0xEA, 0x00, 0x57, 0x02, // êW (U+00EA U+0057)
  0x00, 0xEA, 0x00, 0x59, 0x03, // êY (U+00EA U+0059)
  0x00, 0xEA, 0x00, 0xDD, 0x03, // êÝ (U+00EA U+00DD)
  0x00, 0xEA, 0x01, 0x74, 0x02, // êŴ (U+00EA U+0174)
  0x00, 0xEA, 0x01, 0x76, 0x03, // êŶ (U+00EA U+0176)
  0x00, 0xEA, 0x01, 0x78, 0x03, // êŸ (U+00EA U+0178)
  0x00, 0xEB, 0x00, 0x56, 0x02, // ëV (U+00EB U+0056)
  0x00, 0xEB, 0x00, 0x57, 0x02, // ëW (U+00EB U+0057)
  0x00, 0xEB, 0x00, 0x59, 0x03, // ëY (U+00EB U+0059)
  0x00, 0xEB, 0x00, 0xDD, 0x03, // ëÝ (U+00EB U+00DD)
  0x00, 0xEB, 0x01, 0x74, 0x02, // ëŴ (U+00EB U+0174)
  0x00, 0xEB, 0x01, 0x76, 0x03, // ëŶ (U+00EB U+0176)
  0x00, 0xEB, 0x01, 0x78, 0x03, // ëŸ (U+00EB U+0178)
  0x00, 0xF0, 0x00, 0x3F, 0x01, // ð? (U+00F0 U+003F)
  0x00, 0xF0, 0x00, 0x41, 0x01, // ðA (U+00F0 U+0041)
  0x00, 0xF0, 0x00, 0x54, 0x01, // ðT (U+00F0 U+0054)
  0x00, 0xF0, 0x00, 0x56, 0x02, // ðV (U+00F0 U+0056)
  0x00, 0xF0, 0x00, 0x57, 0x02, // ðW (U+00F0 U+0057)
  0x00, 0xF0, 0x00, 0x59, 0x03, // ðY (U+00F0 U+0059)
  0x00, 0xF0, 0x00, 0x79, 0x01, // ðy (U+00F0 U+0079)
  0x00, 0xF0, 0x00, 0xC0, 0x01, // ðÀ (U+00F0 U+00C0)
  0x00, 0xF0, 0x00, 0xC1, 0x01, // ðÁ (U+00F0 U+00C1)
  0x00, 0xF0, 0x00, 0xC2, 0x01, // ðÂ (U+00F0 U+00C2)
  0x00, 0xF0, 0x00, 0xC3, 0x01, // ðÃ (U+00F0 U+00C3)
  0x00, 0xF0, 0x00, 0xC4, 0x01, // ðÄ (U+00F0 U+00C4)
  0x00, 0xF0, 0x00, 0xC5, 0x01, // ðÅ (U+00F0 U+00C5)
  0x00, 0xF0, 0x00, 0xDD, 0x03, // ðÝ (U+00F0 U+00DD)
  0x00, 0xF0, 0x00, 0xFD, 0x01, // ðý (U+00F0 U+00FD)
  0x00, 0xF0, 0x00, 0xFF, 0x01, // ðÿ (U+00F0 U+00FF)
  0x00, 0xF0, 0x01, 0x00, 0x01, // ðĀ (U+00F0 U+0100)
  0x00, 0xF0, 0x01, 0x02, 0x01, // ðĂ (U+00F0 U+0102)
  0x00, 0xF0, 0x01, 0x04, 0x01, // ðĄ (U+00F0 U+0104)
  0x00, 0xF0, 0x01, 0x62, 0x01, // ðŢ (U+00F0 U+0162)
  0x00, 0xF0, 0x01, 0x64, 0x01, // ðŤ (U+00F0 U+0164)
  0x00, 0xF0, 0x01, 0x66, 0x01, // ðŦ (U+00F0 U+0166)
  0x00, 0xF0, 0x01, 0x74, 0x02, // ðŴ (U+00F0 U+0174)
  0x00, 0xF0, 0x01, 0x76, 0x03, // ðŶ (U+00F0 U+0176)
  0x00, 0xF0, 0x01, 0x77, 0x01, // ðŷ (U+00F0 U+0177)
  0x00, 0xF0, 0x01, 0x78, 0x03, // ðŸ (U+00F0 U+0178)
  0x00, 0xF1, 0x00, 0x22, 0x02, // ñ" (U+00F1 U+0022)
  0x00, 0xF1, 0x00, 0x27, 0x02, // ñ' (U+00F1 U+0027)
  0x00, 0xF1, 0x00, 0x3F, 0x01, // ñ? (U+00F1 U+003F)
  0x00, 0xF1, 0x00, 0x54, 0x01, // ñT (U+00F1 U+0054)
  0x00, 0xF1, 0x00, 0x56, 0x02, // ñV (U+00F1 U+0056)
  0x00, 0xF1, 0x00, 0x57, 0x02, // ñW (U+00F1 U+0057)
  0x00, 0xF1, 0x00, 0x59, 0x02, // ñY (U+00F1 U+0059)
  0x00, 0xF1, 0x00, 0x79, 0x01, // ñy (U+00F1 U+0079)
  0x00, 0xF1, 0x00, 0xDD, 0x02, // ñÝ (U+00F1 U+00DD)
  0x00, 0xF1, 0x00, 0xFD, 0x01, // ñý (U+00F1 U+00FD)
  0x00, 0xF1, 0x00, 0xFF, 0x01, // ñÿ (U+00F1 U+00FF)
  0x00, 0xF1, 0x01, 0x62, 0x01, // ñŢ (U+00F1 U+0162)
  0x00, 0xF1, 0x01, 0x64, 0x01, // ñŤ (U+00F1 U+0164)
  0x00, 0xF1, 0x01, 0x66, 0x01, // ñŦ (U+00F1 U+0166)
  0x00, 0xF1, 0x01, 0x74, 0x02, // ñŴ (U+00F1 U+0174)
  0x00, 0xF1, 0x01, 0x76, 0x02, // ñŶ (U+00F1 U+0176)
  0x00, 0xF1, 0x01, 0x77, 0x01, // ñŷ (U+00F1 U+0177)
  0x00, 0xF1, 0x01, 0x78, 0x02, // ñŸ (U+00F1 U+0178)
  0x00, 0xF2, 0x00, 0x3F, 0x01, // ò? (U+00F2 U+003F)
  0x00, 0xF2, 0x00, 0x41, 0x01, // òA (U+00F2 U+0041)
  0x00, 0xF2, 0x00, 0x54, 0x01, // òT (U+00F2 U+0054)
  0x00, 0xF2, 0x00, 0x56, 0x02, // òV (U+00F2 U+0056)
  0x00, 0xF2, 0x00, 0x57, 0x02, // òW (U+00F2 U+0057)
  0x00, 0xF2, 0x00, 0x59, 0x03, // òY (U+00F2 U+0059)
  0x00, 0xF2, 0x00, 0x79, 0x01, // òy (U+00F2 U+0079)
  0x00, 0xF2, 0x00, 0xC0, 0x01, // òÀ (U+00F2 U+00C0)
  0x00, 0xF2, 0x00, 0xC1, 0x01, // òÁ (U+00F2 U+00C1)
  0x00, 0xF2, 0x00, 0xC2, 0x01, // òÂ (U+00F2 U+00C2)
  0x00, 0xF2, 0x00, 0xC3, 0x01, // òÃ (U+00F2 U+00C3)
  0x00, 0xF2, 0x00, 0xC4, 0x01, // òÄ (U+00F2 U+00C4)
  0x00, 0xF2, 0x00, 0xC5, 0x01, // òÅ (U+00F2 U+00C5)
  0x00, 0xF2, 0x00, 0xDD, 0x03, // òÝ (U+00F2 U+00DD)
  0x00, 0xF2, 0x00, 0xFD, 0x01, // òý (U+00F2 U+00FD)
  0x00, 0xF2, 0x00, 0xFF, 0x01, // òÿ (U+00F2 U+00FF)
  0x00, 0xF2, 0x01, 0x00, 0x01, // òĀ (U+00F2 U+0100)
  0x00, 0xF2, 0x01, 0x02, 0x01, // òĂ (U+00F2 U+0102)
  0x00, 0xF2, 0x01, 0x04, 0x01, // òĄ (U+00F2 U+0104)
  0x00, 0xF2, 0x01, 0x62, 0x01, // òŢ (U+00F2 U+0162)
  0x00, 0xF2, 0x01, 0x64, 0x01, // òŤ (U+00F2 U+0164)
  0x00, 0xF2, 0x01, 0x66, 0x01, // òŦ (U+00F2 U+0166)
  0x00, 0xF2, 0x01, 0x74, 0x02, // òŴ (U+00F2 U+0174)
  0x00, 0xF2, 0x01, 0x76, 0x03, // òŶ (U+00F2 U+0176)
  0x00, 0xF2, 0x01, 0x77, 0x01, // òŷ (U+00F2 U+0177)
  0x00, 0xF2, 0x01, 0x78, 0x03, // òŸ (U+00F2 U+0178)
  0x00, 0xF3, 0x00, 0x3F, 0x01, // ó? (U+00F3 U+003F)
  0x00, 0xF3, 0x00, 0x41, 0x01, // óA (U+00F3 U+0041)
  0x00, 0xF3, 0x00, 0x54, 0x01, // óT (U+00F3 U+0054)
  0x00, 0xF3, 0x00, 0x56, 0x02, // óV (U+00F3 U+0056)
  0x00, 0xF3, 0x00, 0x57, 0x02, // óW (U+00F3 U+0057)
  0x00, 0xF3, 0x00, 0x59, 0x03, // óY (U+00F3 U+0059)
  0x00, 0xF3, 0x00, 0x79, 0x01, // óy (U+00F3 U+0079)
  0x00, 0xF3, 0x00, 0xC0, 0x01, // óÀ (U+00F3 U+00C0)
  0x00, 0xF3, 0x00, 0xC1, 0x01, // óÁ (U+00F3 U+00C1)
  0x00, 0xF3, 0x00, 0xC2, 0x01, // óÂ (U+00F3 U+00C2)
  0x00, 0xF3, 0x00, 0xC3, 0x01, // óÃ (U+00F3 U+00C3)
  0x00, 0xF3, 0x00, 0xC4, 0x01, // óÄ (U+00F3 U+00C4)
  0x00, 0xF3, 0x00, 0xC5, 0x01, // óÅ (U+00F3 U+00C5)
  0x00, 0xF3, 0x00, 0xDD, 0x03, // óÝ (U+00F3 U+00DD)
  0x00, 0xF3, 0x00, 0xFD, 0x01, // óý (U+00F3 U+00FD)
  0x00, 0xF3, 0x00, 0xFF, 0x01, // óÿ (U+00F3 U+00FF)
  0x00, 0xF3, 0x01, 0x00, 0x01, // óĀ (U+00F3 U+0100)
  0x00, 0xF3, 0x01, 0x02, 0x01, // óĂ (U+00F3 U+0102)
  0x00, 0xF3, 0x01, 0x04, 0x01, // óĄ (U+00F3 U+0104)
  0x00, 0xF3, 0x01, 0x62, 0x01, // óŢ (U+00F3 U+0162)
  0x00, 0xF3, 0x01, 0x64, 0x01, // óŤ (U+00F3 U+0164)
  0x00, 0xF3, 0x01, 0x66, 0x01, // óŦ (U+00F3 U+0166)
  0x00, 0xF3, 0x01, 0x74, 0x02, // óŴ (U+00F3 U+0174)
  0x00, 0xF3, 0x01, 0x76, 0x03, // óŶ (U+00F3 U+0176)
  0x00, 0xF3, 0x01, 0x77, 0x01, // óŷ (U+00F3 U+0177)
  0x00, 0xF3, 0x01, 0x78, 0x03, // óŸ (U+00F3 U+0178)
  0x00, 0xF4, 0x00, 0x3F, 0x01, // ô? (U+00F4 U+003F)
  0x00, 0xF4, 0x00, 0x41, 0x01, // ôA (U+00F4 U+0041)
  0x00, 0xF4, 0x00, 0x54, 0x01, // ôT (U+00F4 U+0054)
  0x00, 0xF4, 0x00, 0x56, 0x02, // ôV (U+00F4 U+0056)
  0x00, 0xF4, 0x00, 0x57, 0x02, // ôW (U+00F4 U+0057)
  0x00, 0xF4, 0x00, 0x59, 0x03, // ôY (U+00F4 U+0059)
  0x00, 0xF4, 0x00, 0x79, 0x01, // ôy (U+00F4 U+0079)
  0x00, 0xF4, 0x00, 0xC0, 0x01, // ôÀ (U+00F4 U+00C0)
  0x00, 0xF4, 0x00, 0xC1, 0x01, // ôÁ (U+00F4 U+00C1)
  0x00, 0xF4, 0x00, 0xC2, 0x01, // ôÂ (U+00F4 U+00C2)
  0x00, 0xF4, 0x00, 0xC3, 0x01, // ôÃ (U+00F4 U+00C3)
  0x00, 0xF4, 0x00, 0xC4, 0x01, // ôÄ (U+00F4 U+00C4)
  0x00, 0xF4, 0x00, 0xC5, 0x01, // ôÅ (U+00F4 U+00C5)
  0x00, 0xF4, 0x00, 0xDD, 0x03, // ôÝ (U+00F4 U+00DD)
  0x00, 0xF4, 0x00, 0xFD, 0x01, // ôý (U+00F4 U+00FD)
  0x00, 0xF4, 0x00, 0xFF, 0x01, // ôÿ (U+00F4 U+00FF)
  0x00, 0xF4, 0x01, 0x00, 0x01, // ôĀ (U+00F4 U+0100)
  0x00, 0xF4, 0x01, 0x02, 0x01, // ôĂ (U+00F4 U+0102)
  0x00, 0xF4, 0x01, 0x04, 0x01, // ôĄ (U+00F4 U+0104)
  0x00, 0xF4, 0x01, 0x62, 0x01, // ôŢ (U+00F4 U+0162)
  0x00, 0xF4, 0x01, 0x64, 0x01, // ôŤ (U+00F4 U+0164)
  0x00, 0xF4, 0x01, 0x66, 0x01, // ôŦ (U+00F4 U+0166)
  0x00, 0xF4, 0x01, 0x74, 0x02, // ôŴ (U+00F4 U+0174)
  0x00, 0xF4, 0x01, 0x76, 0x03, // ôŶ (U+00F4 U+0176)
  0x00, 0xF4, 0x01, 0x77, 0x01, // ôŷ (U+00F4 U+0177)
  0x00, 0xF4, 0x01, 0x78, 0x03, // ôŸ (U+00F4 U+0178)
  0x00, 0xF5, 0x00, 0x3F, 0x01, // õ? (U+00F5 U+003F)
  0x00, 0xF5, 0x00, 0x41, 0x01, // õA (U+00F5 U+0041)
  0x00, 0xF5, 0x00, 0x54, 0x01, // õT (U+00F5 U+0054)
  0x00, 0xF5, 0x00, 0x56, 0x02, // õV (U+00F5 U+0056)
  0x00, 0xF5, 0x00, 0x57, 0x02, // õW (U+00F5 U+0057)
  0x00, 0xF5, 0x00, 0x59, 0x03, // õY (U+00F5 U+0059)
  0x00, 0xF5, 0x00, 0x79, 0x01, // õy (U+00F5 U+0079)
  0x00, 0xF5, 0x00, 0xC0, 0x01, // õÀ (U+00F5 U+00C0)
  0x00, 0xF5, 0x00, 0xC1, 0x01, // õÁ (U+00F5 U+00C1)
  0x00, 0xF5, 0x00, 0xC2, 0x01, // õÂ (U+00F5 U+00C2)
  0x00, 0xF5, 0x00, 0xC3, 0x01, // õÃ (U+00F5 U+00C3)
  0x00, 0xF5, 0x00, 0xC4, 0x01, // õÄ (U+00F5 U+00C4)
  0x00, 0xF5, 0x00, 0xC5, 0x01, // õÅ (U+00F5 U+00C5)
  0x00, 0xF5, 0x00, 0xDD, 0x03, // õÝ (U+00F5 U+00DD)
  0x00, 0xF5, 0x00, 0xFD, 0x01, // õý (U+00F5 U+00FD)
  0x00, 0xF5, 0x00, 0xFF, 0x01, // õÿ (U+00F5 U+00FF)
  0x00, 0xF5, 0x01, 0x00, 0x01, // õĀ (U+00F5 U+0100)
  0x00, 0xF5, 0x01, 0x02, 0x01, // õĂ (U+00F5 U+0102)
  0x00, 0xF5, 0x01, 0x04, 0x01, // õĄ (U+00F5 U+0104)
  0x00, 0xF5, 0x01, 0x62, 0x01, // õŢ (U+00F5 U+0162)
  0x00, 0xF5, 0x01, 0x64, 0x01, // õŤ (U+00F5 U+0164)
  0x00, 0xF5, 0x01, 0x66, 0x01, // õŦ (U+00F5 U+0166)
  0x00, 0xF5, 0x01, 0x74, 0x02, // õŴ (U+00F5 U+0174)
  0x00, 0xF5, 0x01, 0x76, 0x03, // õŶ (U+00F5 U+0176)
  0x00, 0xF5, 0x01, 0x77, 0x01, // õŷ (U+00F5 U+0177)
  0x00, 0xF5, 0x01, 0x78, 0x03, // õŸ (U+00F5 U+0178)
  0x00, 0xF6, 0x00, 0x3F, 0x01, // ö? (U+00F6 U+003F)
  0x00, 0xF6, 0x00, 0x41, 0x01, // öA (U+00F6 U+0041)
  0x00, 0xF6, 0x00, 0x54, 0x01, // öT (U+00F6 U+0054)
  0x00, 0xF6, 0x00, 0x56, 0x02, // öV (U+00F6 U+0056)
  0x00, 0xF6, 0x00, 0x57, 0x02, // öW (U+00F6 U+0057)
  0x00, 0xF6, 0x00, 0x59, 0x03, // öY (U+00F6 U+0059)
  0x00, 0xF6, 0x00, 0x79, 0x01, // öy (U+00F6 U+0079)
  0x00, 0xF6, 0x00, 0xC0, 0x01, // öÀ (U+00F6 U+00C0)
  0x00, 0xF6, 0x00, 0xC1, 0x01, // öÁ (U+00F6 U+00C1)
  0x00, 0xF6, 0x00, 0xC2, 0x01, // öÂ (U+00F6 U+00C2)
  0x00, 0xF6, 0x00, 0xC3, 0x01, // öÃ (U+00F6 U+00C3)
  0x00, 0xF6, 0x00, 0xC4, 0x01, // öÄ (U+00F6 U+00C4)
  0x00, 0xF6, 0x00, 0xC5, 0x01, // öÅ (U+00F6 U+00C5)
  0x00, 0xF6, 0x00, 0xDD, 0x03, // öÝ (U+00F6 U+00DD)
  0x00, 0xF6, 0x00, 0xFD, 0x01, // öý (U+00F6 U+00FD)
  0x00, 0xF6, 0x00, 0xFF, 0x01, // öÿ (U+00F6 U+00FF)
  0x00, 0xF6, 0x01, 0x00, 0x01, // öĀ (U+00F6 U+0100)
  0x00, 0xF6, 0x01, 0x02, 0x01, // öĂ (U+00F6 U+0102)
  0x00, 0xF6, 0x01, 0x04, 0x01, // öĄ (U+00F6 U+0104)
  0x00, 0xF6, 0x01, 0x62, 0x01, // öŢ (U+00F6 U+0162)
  0x00, 0xF6, 0x01, 0x64, 0x01, // öŤ (U+00F6 U+0164)
  0x00, 0xF6, 0x01, 0x66, 0x01, // öŦ (U+00F6 U+0166)
  0x00, 0xF6, 0x01, 0x74, 0x02, // öŴ (U+00F6 U+0174)
  0x00, 0xF6, 0x01, 0x76, 0x03, // öŶ (U+00F6 U+0176)
  0x00, 0xF6, 0x01, 0x77, 0x01, // öŷ (U+00F6 U+0177)
  0x00, 0xF6, 0x01, 0x78, 0x03, // öŸ (U+00F6 U+0178)
  0x00, 0xF8, 0x00, 0x3F, 0x01, // ø? (U+00F8 U+003F)
  0x00, 0xF8, 0x00, 0x41, 0x01, // øA (U+00F8 U+0041)
  0x00, 0xF8, 0x00, 0x54, 0x01, // øT (U+00F8 U+0054)
  0x00, 0xF8, 0x00, 0x56, 0x02, // øV (U+00F8 U+0056)
  0x00, 0xF8, 0x00, 0x57, 0x02, // øW (U+00F8 U+0057)
  0x00, 0xF8, 0x00, 0x59, 0x03, // øY (U+00F8 U+0059)
  0x00, 0xF8, 0x00, 0x79, 0x01, // øy (U+00F8 U+0079)
  0x00, 0xF8, 0x00, 0xC0, 0x01, // øÀ (U+00F8 U+00C0)
  0x00, 0xF8, 0x00, 0xC1, 0x01, // øÁ (U+00F8 U+00C1)
  0x00, 0xF8, 0x00, 0xC2, 0x01, // øÂ (U+00F8 U+00C2)
  0x00, 0xF8, 0x00, 0xC3, 0x01, // øÃ (U+00F8 U+00C3)
  0x00, 0xF8, 0x00, 0xC4, 0x01, // øÄ (U+00F8 U+00C4)
  0x00, 0xF8, 0x00, 0xC5, 0x01, // øÅ (U+00F8 U+00C5)
  0x00, 0xF8, 0x00, 0xDD, 0x03, // øÝ (U+00F8 U+00DD)
  0x00, 0xF8, 0x00, 0xFD, 0x01, // øý (U+00F8 U+00FD)
  0x00, 0xF8, 0x00, 0xFF, 0x01, // øÿ (U+00F8 U+00FF)
  0x00, 0xF8, 0x01, 0x00, 0x01, // øĀ (U+00F8 U+0100)
  0x00, 0xF8, 0x01, 0x02, 0x01, // øĂ (U+00F8 U+0102)
  0x00, 0xF8, 0x01, 0x04, 0x01, // øĄ (U+00F8 U+0104)
  0x00, 0xF8, 0x01, 0x62, 0x01, // øŢ (U+00F8 U+0162)
  0x00, 0xF8, 0x01, 0x64, 0x01, // øŤ (U+00F8 U+0164)
  0x00, 0xF8, 0x01, 0x66, 0x01, // øŦ (U+00F8 U+0166)
  0x00, 0xF8, 0x01, 0x74, 0x02, // øŴ (U+00F8 U+0174)
  0x00, 0xF8, 0x01, 0x76, 0x03, // øŶ (U+00F8 U+0176)
  0x00, 0xF8, 0x01, 0x77, 0x01, // øŷ (U+00F8 U+0177)
  0x00, 0xF8, 0x01, 0x78, 0x03, // øŸ (U+00F8 U+0178)
  0x00, 0xFD, 0x00, 0x2C, 0x05, // ý, (U+00FD U+002C)
  0x00, 0xFD, 0x00, 0x2E, 0x05, // ý. (U+00FD U+002E)
  0x00, 0xFD, 0x00, 0x41, 0x03, // ýA (U+00FD U+0041)
  0x00, 0xFD, 0x00, 0xC0, 0x03, // ýÀ (U+00FD U+00C0)
  0x00, 0xFD, 0x00, 0xC1, 0x03, // ýÁ (U+00FD U+00C1)
  0x00, 0xFD, 0x00, 0xC2, 0x03, // ýÂ (U+00FD U+00C2)
  0x00, 0xFD, 0x00, 0xC3, 0x03, // ýÃ (U+00FD U+00C3)
  0x00, 0xFD, 0x00, 0xC4, 0x03, // ýÄ (U+00FD U+00C4)
  0x00, 0xFD, 0x00, 0xC5, 0x03, // ýÅ (U+00FD U+00C5)
  0x00, 0xFD, 0x01, 0x00, 0x03, // ýĀ (U+00FD U+0100)
  0x00, 0xFD, 0x01, 0x02, 0x03, // ýĂ (U+00FD U+0102)
  0x00, 0xFD, 0x01, 0x04, 0x03, // ýĄ (U+00FD U+0104)
  0x00, 0xFD, 0x20, 0x1A, 0x05, // ý‚ (U+00FD U+201A)
  0x00, 0xFD, 0x20, 0x1E, 0x05, // ý„ (U+00FD U+201E)
  0x00, 0xFD, 0x20, 0x26, 0x05, // ý… (U+00FD U+2026)
  0x00, 0xFE, 0x00, 0x3F, 0x01, // þ? (U+00FE U+003F)
  0x00, 0xFE, 0x00, 0x41, 0x01, // þA (U+00FE U+0041)
  0x00, 0xFE, 0x00, 0x54, 0x01, // þT (U+00FE U+0054)
  0x00, 0xFE, 0x00, 0x56, 0x02, // þV (U+00FE U+0056)
  0x00, 0xFE, 0x00, 0x57, 0x02, // þW (U+00FE U+0057)
  0x00, 0xFE, 0x00, 0x59, 0x03, // þY (U+00FE U+0059)
  0x00, 0xFE, 0x00, 0x79, 0x01, // þy (U+00FE U+0079)
  0x00, 0xFE, 0x00, 0xC0, 0x01, // þÀ (U+00FE U+00C0)
  0x00, 0xFE, 0x00, 0xC1, 0x01, // þÁ (U+00FE U+00C1)
  0x00, 0xFE, 0x00, 0xC2, 0x01, // þÂ (U+00FE U+00C2)
  0x00, 0xFE, 0x00, 0xC3, 0x01, // þÃ (U+00FE U+00C3)
  0x00, 0xFE, 0x00, 0xC4, 0x01, // þÄ (U+00FE U+00C4)
  0x00, 0xFE, 0x00, 0xC5, 0x01, // þÅ (U+00FE U+00C5)
  0x00, 0xFE, 0x00, 0xDD, 0x03, // þÝ (U+00FE U+00DD)
  0x00, 0xFE, 0x00, 0xFD, 0x01, // þý (U+00FE U+00FD)
  0x00, 0xFE, 0x00, 0xFF, 0x01, // þÿ (U+00FE U+00FF)
  0x00, 0xFE, 0x01, 0x00, 0x01, // þĀ (U+00FE U+0100)
  0x00, 0xFE, 0x01, 0x02, 0x01, // þĂ (U+00FE U+0102)
  0x00, 0xFE, 0x01, 0x04, 0x01, // þĄ (U+00FE U+0104)
  0x00, 0xFE, 0x01, 0x62, 0x01, // þŢ (U+00FE U+0162)
  0x00, 0xFE, 0x01, 0x64, 0x01, // þŤ (U+00FE U+0164)
  0x00, 0xFE, 0x01, 0x66, 0x01, // þŦ (U+00FE U+0166)
  0x00, 0xFE, 0x01, 0x74, 0x02, // þŴ (U+00FE U+0174)
  0x00, 0xFE, 0x01, 0x76, 0x03, // þŶ (U+00FE U+0176)
  0x00, 0xFE, 0x01, 0x77, 0x01, // þŷ (U+00FE U+0177)
  0x00, 0xFE, 0x01, 0x78, 0x03, // þŸ (U+00FE U+0178)
  0x00, 0xFF, 0x00, 0x2C, 0x05, // ÿ, (U+00FF U+002C)
  0x00, 0xFF, 0x00, 0x2E, 0x05, // ÿ. (U+00FF U+002E)
  0x00, 0xFF, 0x00, 0x41, 0x03, // ÿA (U+00FF U+0041)
  0x00, 0xFF, 0x00, 0xC0, 0x03, // ÿÀ (U+00FF U+00C0)
  0x00, 0xFF, 0x00, 0xC1, 0x03, // ÿÁ (U+00FF U+00C1)
  0x00, 0xFF, 0x00, 0xC2, 0x03, // ÿÂ (U+00FF U+00C2)
  0x00, 0xFF, 0x00, 0xC3, 0x03, // ÿÃ (U+00FF U+00C3)
  0x00, 0xFF, 0x00, 0xC4, 0x03, // ÿÄ (U+00FF U+00C4)
  0x00, 0xFF, 0x00, 0xC5, 0x03, // ÿÅ (U+00FF U+00C5)
  0x00, 0xFF, 0x01, 0x00, 0x03, // ÿĀ (U+00FF U+0100)
  0x00, 0xFF, 0x01, 0x02, 0x03, // ÿĂ (U+00FF U+0102)
  0x00, 0xFF, 0x01, 0x04, 0x03, // ÿĄ (U+00FF U+0104)
  0x00, 0xFF, 0x20, 0x1A, 0x05, // ÿ‚ (U+00FF U+201A)
  0x00, 0xFF, 0x20, 0x1E, 0x05, // ÿ„ (U+00FF U+201E)
  0x00, 0xFF, 0x20, 0x26, 0x05, // ÿ… (U+00FF U+2026)
  0x01, 0x00, 0x00, 0x22, 0x05, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x05, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x00, 0x2A, 0x04, // Ā* (U+0100 U+002A)
  0x01, 0x00, 0x00, 0x3F, 0x03, // Ā? (U+0100 U+003F)
  0x01, 0x00, 0x00, 0x43, 0x01, // ĀC (U+0100 U+0043)
  0x01, 0x00, 0x00, 0x47, 0x01, // ĀG (U+0100 U+0047)
  0x01, 0x00, 0x00, 0x4F, 0x01, // ĀO (U+0100 U+004F)
  0x01, 0x00, 0x00, 0x51, 0x01, // ĀQ (U+0100 U+0051)
  0x01, 0x00, 0x00, 0x54, 0x03, // ĀT (U+0100 U+0054)
  0x01, 0x00, 0x00, 0x55, 0x01, // ĀU (U+0100 U+0055)
  0x01, 0x00, 0x00, 0x56, 0x04, // ĀV (U+0100 U+0056)
  0x01, 0x00, 0x00, 0x57, 0x03, // ĀW (U+0100 U+0057)
  0x01, 0x00, 0x00, 0x59, 0x03, // ĀY (U+0100 U+0059)
  0x01, 0x00, 0x00, 0x63, 0x01, // Āc (U+0100 U+0063)
  0x01, 0x00, 0x00, 0x64, 0x01, // Ād (U+0100 U+0064)
  0x01, 0x00, 0x00, 0x65, 0x01, // Āe (U+0100 U+0065)
  0x01, 0x00, 0x00, 0x67, 0x01, // Āg (U+0100 U+0067)
  0x01, 0x00, 0x00, 0x6F, 0x01, // Āo (U+0100 U+006F)
  0x01, 0x00, 0x00, 0x71, 0x01, // Āq (U+0100 U+0071)
  0x01, 0x00, 0x00, 0x75, 0x01, // Āu (U+0100 U+0075)
  0x01, 0x00, 0x00, 0x76, 0x03, // Āv (U+0100 U+0076)
  0x01, 0x00, 0x00, 0x77, 0x02, // Āw (U+0100 U+0077)
  0x01, 0x00, 0x00, 0x79, 0x03, // Āy (U+0100 U+0079)
  0x01, 0x00, 0x00, 0xC7, 0x01, // ĀÇ (U+0100 U+00C7)
  0x01, 0x00, 0x00, 0xD2, 0x01, // ĀÒ (U+0100 U+00D2)
  0x01, 0x00, 0x00, 0xD3, 0x01, // ĀÓ (U+0100 U+00D3)
  0x01, 0x00, 0x00, 0xD4, 0x01, // ĀÔ (U+0100 U+00D4)
  0x01, 0x00, 0x00, 0xD5, 0x01, // ĀÕ (U+0100 U+00D5)
  0x01, 0x00, 0x00, 0xD6, 0x01, // ĀÖ (U+0100 U+00D6)
  0x01, 0x00, 0x00, 0xD8, 0x01, // ĀØ (U+0100 U+00D8)
  0x01, 0x00, 0x00, 0xD9, 0x01, // ĀÙ (U+0100 U+00D9)
  0x01, 0x00, 0x00, 0xDA, 0x01, // ĀÚ (U+0100 U+00DA)
  0x01, 0x00, 0x00, 0xDB, 0x01, // ĀÛ (U+0100 U+00DB)
  0x01, 0x00, 0x00, 0xDC, 0x01, // ĀÜ (U+0100 U+00DC)
  0x01, 0x00, 0x00, 0xDD, 0x03, // ĀÝ (U+0100 U+00DD)
  0x01, 0x00, 0x00, 0xE7, 0x01, // Āç (U+0100 U+00E7)
  0x01, 0x00, 0x00, 0xE8, 0x01, // Āè (U+0100 U+00E8)
  0x01, 0x00, 0x00, 0xE9, 0x01, // Āé (U+0100 U+00E9)
  0x01, 0x00, 0x00, 0xEA, 0x01, // Āê (U+0100 U+00EA)
  0x01, 0x00, 0x00, 0xEB, 0x01, // Āë (U+0100 U+00EB)
  0x01, 0x00, 0x00, 0xF0, 0x01, // Āð (U+0100 U+00F0)
  0x01, 0x00, 0x00, 0xF2, 0x01, // Āò (U+0100 U+00F2)
  0x01, 0x00, 0x00, 0xF3, 0x01, // Āó (U+0100 U+00F3)
  0x01, 0x00, 0x00, 0xF4, 0x01, // Āô (U+0100 U+00F4)
  0x01, 0x00, 0x00, 0xF5, 0x01, // Āõ (U+0100 U+00F5)
  0x01, 0x00, 0x00, 0xF6, 0x01, // Āö (U+0100 U+00F6)
  0x01, 0x00, 0x00, 0xF8, 0x01, // Āø (U+0100 U+00F8)
  0x01, 0x00, 0x00, 0xF9, 0x01, // Āù (U+0100 U+00F9)
  0x01, 0x00, 0x00, 0xFA, 0x01, // Āú (U+0100 U+00FA)
  0x01, 0x00, 0x00, 0xFB, 0x01, // Āû (U+0100 U+00FB)
  0x01, 0x00, 0x00, 0xFC, 0x01, // Āü (U+0100 U+00FC)
  0x01, 0x00, 0x00, 0xFD, 0x03, // Āý (U+0100 U+00FD)
  0x01, 0x00, 0x00, 0xFF, 0x03, // Āÿ (U+0100 U+00FF)
  0x01, 0x00, 0x01, 0x06, 0x01, // ĀĆ (U+0100 U+0106)
  0x01, 0x00, 0x01, 0x07, 0x01, // Āć (U+0100 U+0107)
  0x01, 0x00, 0x01, 0x08, 0x01, // ĀĈ (U+0100 U+0108)
  0x01, 0x00, 0x01, 0x09, 0x01, // Āĉ (U+0100 U+0109)
  0x01, 0x00, 0x01, 0x0A, 0x01, // ĀĊ (U+0100 U+010A)
  0x01, 0x00, 0x01, 0x0B, 0x01, // Āċ (U+0100 U+010B)
  0x01, 0x00, 0x01, 0x0C, 0x01, // ĀČ (U+0100 U+010C)
  0x01, 0x00, 0x01, 0x0D, 0x01, // Āč (U+0100 U+010D)
  0x01, 0x00, 0x01, 0x0F, 0x01, // Āď (U+0100 U+010F)
  0x01, 0x00, 0x01, 0x11, 0x01, // Āđ (U+0100 U+0111)
  0x01, 0x00, 0x01, 0x13, 0x01, // Āē (U+0100 U+0113)
  0x01, 0x00, 0x01, 0x15, 0x01, // Āĕ (U+0100 U+0115)
  0x01, 0x00, 0x01, 0x17, 0x01, // Āė (U+0100 U+0117)
  0x01, 0x00, 0x01, 0x19, 0x01, // Āę (U+0100 U+0119)
  0x01, 0x00, 0x01, 0x1B, 0x01, // Āě (U+0100 U+011B)
  0x01, 0x00, 0x01, 0x1C, 0x01, // ĀĜ (U+0100 U+011C)
  0x01, 0x00, 0x01, 0x1D, 0x01, // Āĝ (U+0100 U+011D)
  0x01, 0x00, 0x01, 0x1E, 0x01, // ĀĞ (U+0100 U+011E)
  0x01, 0x00, 0x01, 0x1F, 0x01, // Āğ (U+0100 U+011F)
  0x01, 0x00, 0x01, 0x20, 0x01, // ĀĠ (U+0100 U+0120)
  0x01, 0x00, 0x01, 0x21, 0x01, // Āġ (U+0100 U+0121)
  0x01, 0x00, 0x01, 0x22, 0x01, // ĀĢ (U+0100 U+0122)
  0x01, 0x00, 0x01, 0x23, 0x01, // Āģ (U+0100 U+0123)
  0x01, 0x00, 0x01, 0x4C, 0x01, // ĀŌ (U+0100 U+014C)
  0x01, 0x00, 0x01, 0x4D, 0x01, // Āō (U+0100 U+014D)
  0x01, 0x00, 0x01, 0x4E, 0x01, // ĀŎ (U+0100 U+014E)
  0x01, 0x00, 0x01, 0x4F, 0x01, // Āŏ (U+0100 U+014F)
  0x01, 0x00, 0x01, 0x50, 0x01, // ĀŐ (U+0100 U+0150)
  0x01, 0x00, 0x01, 0x51, 0x01, // Āő (U+0100 U+0151)
  0x01, 0x00, 0x01, 0x52, 0x01, // ĀŒ (U+0100 U+0152)
  0x01, 0x00, 0x01, 0x53, 0x01, // Āœ (U+0100 U+0153)
  0x01, 0x00, 0x01, 0x62, 0x03, // ĀŢ (U+0100 U+0162)
  0x01, 0x00, 0x01, 0x64, 0x03, // ĀŤ (U+0100 U+0164)
  0x01, 0x00, 0x01, 0x66, 0x03, // ĀŦ (U+0100 U+0166)
  0x01, 0x00, 0x01, 0x68, 0x01, // ĀŨ (U+0100 U+0168)
  0x01, 0x00, 0x01, 0x69, 0x01, // Āũ (U+0100 U+0169)
  0x01, 0x00, 0x01, 0x6A, 0x01, // ĀŪ (U+0100 U+016A)
  0x01, 0x00, 0x01, 0x6B, 0x01, // Āū (U+0100 U+016B)
  0x01, 0x00, 0x01, 0x6C, 0x01, // ĀŬ (U+0100 U+016C)
  0x01, 0x00, 0x01, 0x6D, 0x01, // Āŭ (U+0100 U+016D)
  0x01, 0x00, 0x01, 0x6E, 0x01, // ĀŮ (U+0100 U+016E)
  0x01, 0x00, 0x01, 0x6F, 0x01, // Āů (U+0100 U+016F)
  0x01, 0x00, 0x01, 0x70, 0x01, // ĀŰ (U+0100 U+0170)
  0x01, 0x00, 0x01, 0x71, 0x01, // Āű (U+0100 U+0171)
  0x01, 0x00, 0x01, 0x72, 0x01, // ĀŲ (U+0100 U+0172)
  0x01, 0x00, 0x01, 0x73, 0x01, // Āų (U+0100 U+0173)
  0x01, 0x00, 0x01, 0x74, 0x03, // ĀŴ (U+0100 U+0174)
  0x01, 0x00, 0x01, 0x75, 0x02, // Āŵ (U+0100 U+0175)
  0x01, 0x00, 0x01, 0x76, 0x03, // ĀŶ (U+0100 U+0176)
  0x01, 0x00, 0x01, 0x77, 0x03, // Āŷ (U+0100 U+0177)
  0x01, 0x00, 0x01, 0x78, 0x03, // ĀŸ (U+0100 U+0178)
  0x01, 0x00, 0x20, 0x18, 0x04, // Ā‘ (U+0100 U+2018)
  0x01, 0x00, 0x20, 0x19, 0x04, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1C, 0x04, // Ā“ (U+0100 U+201C)
  0x01, 0x00, 0x20, 0x1D, 0x04, // Ā” (U+0100 U+201D)
  0x01, 0x00, 0x21, 0x22, 0x04, // Ā™ (U+0100 U+2122)
  0x01, 0x01, 0x00, 0x56, 0x02, // āV (U+0101 U+0056)
  0x01, 0x01, 0x00, 0x57, 0x02, // āW (U+0101 U+0057)
  0x01, 0x01, 0x00, 0x59, 0x02, // āY (U+0101 U+0059)
  0x01, 0x01, 0x00, 0xDD, 0x02, // āÝ (U+0101 U+00DD)
  0x01, 0x01, 0x01, 0x74, 0x02, // āŴ (U+0101 U+0174)
  0x01, 0x01, 0x01, 0x76, 0x02, // āŶ (U+0101 U+0176)
  0x01, 0x01, 0x01, 0x78, 0x02, // āŸ (U+0101 U+0178)
  0x01, 0x02, 0x00, 0x22, 0x05, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x05, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x00, 0x2A, 0x04, // Ă* (U+0102 U+002A)
  0x01, 0x02, 0x00, 0x3F, 0x03, // Ă? (U+0102 U+003F)
  0x01, 0x02, 0x00, 0x43, 0x01, // ĂC (U+0102 U+0043)
  0x01, 0x02, 0x00, 0x47, 0x01, // ĂG (U+0102 U+0047)
  0x01, 0x02, 0x00, 0x4F, 0x01, // ĂO (U+0102 U+004F)
  0x01, 0x02, 0x00, 0x51, 0x01, // ĂQ (U+0102 U+0051)
  0x01, 0x02, 0x00, 0x54, 0x03, // ĂT (U+0102 U+0054)
  0x01, 0x02, 0x00, 0x55, 0x01, // ĂU (U+0102 U+0055)
  0x01, 0x02, 0x00, 0x56, 0x04, // ĂV (U+0102 U+0056)
  0x01, 0x02, 0x00, 0x57, 0x03, // ĂW (U+0102 U+0057)
  0x01, 0x02, 0x00, 0x59, 0x03, // ĂY (U+0102 U+0059)
  0x01, 0x02, 0x00, 0x63, 0x01, // Ăc (U+0102 U+0063)
  0x01, 0x02, 0x00, 0x64, 0x01, // Ăd (U+0102 U+0064)
  0x01, 0x02, 0x00, 0x65, 0x01, // Ăe (U+0102 U+0065)
  0x01, 0x02, 0x00, 0x67, 0x01, // Ăg (U+0102 U+0067)
  0x01, 0x02, 0x00, 0x6F, 0x01, // Ăo (U+0102 U+006F)
  0x01, 0x02, 0x00, 0x71, 0x01, // Ăq (U+0102 U+0071)
  0x01, 0x02, 0x00, 0x75, 0x01, // Ău (U+0102 U+0075)
  0x01, 0x02, 0x00, 0x76, 0x03, // Ăv (U+0102 U+0076)
  0x01, 0x02, 0x00, 0x77, 0x02, // Ăw (U+0102 U+0077)
  0x01, 0x02, 0x00, 0x79, 0x03, // Ăy (U+0102 U+0079)
  0x01, 0x02, 0x00, 0xC7, 0x01, // ĂÇ (U+0102 U+00C7)
  0x01, 0x02, 0x00, 0xD2, 0x01, // ĂÒ (U+0102 U+00D2)
  0x01, 0x02, 0x00, 0xD3, 0x01, // ĂÓ (U+0102 U+00D3)
  0x01, 0x02, 0x00, 0xD4, 0x01, // ĂÔ (U+0102 U+00D4)
  0x01, 0x02, 0x00, 0xD5, 0x01, // ĂÕ (U+0102 U+00D5)
  0x01, 0x02, 0x00, 0xD6, 0x01, // ĂÖ (U+0102 U+00D6)
  0x01, 0x02, 0x00, 0xD8, 0x01, // ĂØ (U+0102 U+00D8)
  0x01, 0x02, 0x00, 0xD9, 0x01, // ĂÙ (U+0102 U+00D9)
  0x01, 0x02, 0x00, 0xDA, 0x01, // ĂÚ (U+0102 U+00DA)
  0x01, 0x02, 0x00, 0xDB, 0x01, // ĂÛ (U+0102 U+00DB)
  0x01, 0x02, 0x00, 0xDC, 0x01, // ĂÜ (U+0102 U+00DC)
  0x01, 0x02, 0x00, 0xDD, 0x03, // ĂÝ (U+0102 U+00DD)
  0x01, 0x02, 0x00, 0xE7, 0x01, // Ăç (U+0102 U+00E7)
  0x01, 0x02, 0x00, 0xE8, 0x01, // Ăè (U+0102 U+00E8)
  0x01, 0x02, 0x00, 0xE9, 0x01, // Ăé (U+0102 U+00E9)
  0x01, 0x02, 0x00, 0xEA, 0x01, // Ăê (U+0102 U+00EA)
  0x01, 0x02, 0x00, 0xEB, 0x01, // Ăë (U+0102 U+00EB)
  0x01, 0x02, 0x00, 0xF0, 0x01, // Ăð (U+0102 U+00F0)
  0x01, 0x02, 0x00, 0xF2, 0x01, // Ăò (U+0102 U+00F2)
  0x01, 0x02, 0x00, 0xF3, 0x01, // Ăó (U+0102 U+00F3)
  0x01, 0x02, 0x00, 0xF4, 0x01, // Ăô (U+0102 U+00F4)
  0x01, 0x02, 0x00, 0xF5, 0x01, // Ăõ (U+0102 U+00F5)
  0x01, 0x02, 0x00, 0xF6, 0x01, // Ăö (U+0102 U+00F6)
  0x01, 0x02, 0x00, 0xF8, 0x01, // Ăø (U+0102 U+00F8)
  0x01, 0x02, 0x00, 0xF9, 0x01, // Ăù (U+0102 U+00F9)
  0x01, 0x02, 0x00, 0xFA, 0x01, // Ăú (U+0102 U+00FA)
  0x01, 0x02, 0x00, 0xFB, 0x01, // Ăû (U+0102 U+00FB)
  0x01, 0x02, 0x00, 0xFC, 0x01, // Ăü (U+0102 U+00FC)
  0x01, 0x02, 0x00, 0xFD, 0x03, // Ăý (U+0102 U+00FD)
  0x01, 0x02, 0x00, 0xFF, 0x03, // Ăÿ (U+0102 U+00FF)
  0x01, 0x02, 0x01, 0x06, 0x01, // ĂĆ (U+0102 U+0106)
  0x01, 0x02, 0x01, 0x07, 0x01, // Ăć (U+0102 U+0107)
  0x01, 0x02, 0x01, 0x08, 0x01, // ĂĈ (U+0102 U+0108)
  0x01, 0x02, 0x01, 0x09, 0x01, // Ăĉ (U+0102 U+0109)
  0x01, 0x02, 0x01, 0x0A, 0x01, // ĂĊ (U+0102 U+010A)
  0x01, 0x02, 0x01, 0x0B, 0x01, // Ăċ (U+0102 U+010B)
  0x01, 0x02, 0x01, 0x0C, 0x01, // ĂČ (U+0102 U+010C)
  0x01, 0x02, 0x01, 0x0D, 0x01, // Ăč (U+0102 U+010D)
  0x01, 0x02, 0x01, 0x0F, 0x01, // Ăď (U+0102 U+010F)
  0x01, 0x02, 0x01, 0x11, 0x01, // Ăđ (U+0102 U+0111)
  0x01, 0x02, 0x01, 0x13, 0x01, // Ăē (U+0102 U+0113)
  0x01, 0x02, 0x01, 0x15, 0x01, // Ăĕ (U+0102 U+0115)
  0x01, 0x02, 0x01, 0x17, 0x01, // Ăė (U+0102 U+0117)
  0x01, 0x02, 0x01, 0x19, 0x01, // Ăę (U+0102 U+0119)
  0x01, 0x02, 0x01, 0x1B, 0x01, // Ăě (U+0102 U+011B)
  0x01, 0x02, 0x01, 0x1C, 0x01, // ĂĜ (U+0102 U+011C)
  0x01, 0x02, 0x01, 0x1D, 0x01, // Ăĝ (U+0102 U+011D)
  0x01, 0x02, 0x01, 0x1E, 0x01, // ĂĞ (U+0102 U+011E)
  0x01, 0x02, 0x01, 0x1F, 0x01, // Ăğ (U+0102 U+011F)
  0x01, 0x02, 0x01, 0x20, 0x01, // ĂĠ (U+0102 U+0120)
  0x01, 0x02, 0x01, 0x21, 0x01, // Ăġ (U+0102 U+0121)
  0x01, 0x02, 0x01, 0x22, 0x01, // ĂĢ (U+0102 U+0122)
  0x01, 0x02, 0x01, 0x23, 0x01, // Ăģ (U+0102 U+0123)
  0x01, 0x02, 0x01, 0x4C, 0x01, // ĂŌ (U+0102 U+014C)
  0x01, 0x02, 0x01, 0x4D, 0x01, // Ăō (U+0102 U+014D)
  0x01, 0x02, 0x01, 0x4E, 0x01, // ĂŎ (U+0102 U+014E)
  0x01, 0x02, 0x01, 0x4F, 0x01, // Ăŏ (U+0102 U+014F)
  0x01, 0x02, 0x01, 0x50, 0x01, // ĂŐ (U+0102 U+0150)
  0x01, 0x02, 0x01, 0x51, 0x01, // Ăő (U+0102 U+0151)
  0x01, 0x02, 0x01, 0x52, 0x01, // ĂŒ (U+0102 U+0152)
  0x01, 0x02, 0x01, 0x53, 0x01, // Ăœ (U+0102 U+0153)
  0x01, 0x02, 0x01, 0x62, 0x03, // ĂŢ (U+0102 U+0162)
  0x01, 0x02, 0x01, 0x64, 0x03, // ĂŤ (U+0102 U+0164)
  0x01, 0x02, 0x01, 0x66, 0x03, // ĂŦ (U+0102 U+0166)
  0x01, 0x02, 0x01, 0x68, 0x01, // ĂŨ (U+0102 U+0168)
  0x01, 0x02, 0x01, 0x69, 0x01, // Ăũ (U+0102 U+0169)
  0x01, 0x02, 0x01, 0x6A, 0x01, // ĂŪ (U+0102 U+016A)
  0x01, 0x02, 0x01, 0x6B, 0x01, // Ăū (U+0102 U+016B)
  0x01, 0x02, 0x01, 0x6C, 0x01, // ĂŬ (U+0102 U+016C)
  0x01, 0x02, 0x01, 0x6D, 0x01, // Ăŭ (U+0102 U+016D)
  0x01, 0x02, 0x01, 0x6E, 0x01, // ĂŮ (U+0102 U+016E)
  0x01, 0x02, 0x01, 0x6F, 0x01, // Ăů (U+0102 U+016F)
  0x01, 0x02, 0x01, 0x70, 0x01, // ĂŰ (U+0102 U+0170)
  0x01, 0x02, 0x01, 0x71, 0x01, // Ăű (U+0102 U+0171)
  0x01, 0x02, 0x01, 0x72, 0x01, // ĂŲ (U+0102 U+0172)
  0x01, 0x02, 0x01, 0x73, 0x01, // Ăų (U+0102 U+0173)
  0x01, 0x02, 0x01, 0x74, 0x03, // ĂŴ (U+0102 U+0174)
  0x01, 0x02, 0x01, 0x75, 0x02, // Ăŵ (U+0102 U+0175)
  0x01, 0x02, 0x01, 0x76, 0x03, // ĂŶ (U+0102 U+0176)
  0x01, 0x02, 0x01, 0x77, 0x03, // Ăŷ (U+0102 U+0177)
  0x01, 0x02, 0x01, 0x78, 0x03, // ĂŸ (U+0102 U+0178)
  0x01, 0x02, 0x20, 0x18, 0x04, // Ă‘ (U+0102 U+2018)
  0x01, 0x02, 0x20, 0x19, 0x04, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1C, 0x04, // Ă“ (U+0102 U+201C)
  0x01, 0x02, 0x20, 0x1D, 0x04, // Ă” (U+0102 U+201D)
  0x01, 0x02, 0x21, 0x22, 0x04, // Ă™ (U+0102 U+2122)
  0x01, 0x04, 0x00, 0x22, 0x05, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x05, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x00, 0x2A, 0x04, // Ą* (U+0104 U+002A)
  0x01, 0x04, 0x00, 0x3F, 0x03, // Ą? (U+0104 U+003F)
  0x01, 0x04, 0x00, 0x43, 0x01, // ĄC (U+0104 U+0043)
  0x01, 0x04, 0x00, 0x47, 0x01, // ĄG (U+0104 U+0047)
  0x01, 0x04, 0x00, 0x4F, 0x01, // ĄO (U+0104 U+004F)
  0x01, 0x04, 0x00, 0x51, 0x01, // ĄQ (U+0104 U+0051)
  0x01, 0x04, 0x00, 0x54, 0x03, // ĄT (U+0104 U+0054)
  0x01, 0x04, 0x00, 0x55, 0x01, // ĄU (U+0104 U+0055)
  0x01, 0x04, 0x00, 0x56, 0x04, // ĄV (U+0104 U+0056)
  0x01, 0x04, 0x00, 0x57, 0x03, // ĄW (U+0104 U+0057)
  0x01, 0x04, 0x00, 0x59, 0x03, // ĄY (U+0104 U+0059)
  0x01, 0x04, 0x00, 0x63, 0x01, // Ąc (U+0104 U+0063)
  0x01, 0x04, 0x00, 0x64, 0x01, // Ąd (U+0104 U+0064)
  0x01, 0x04, 0x00, 0x65, 0x01, // Ąe (U+0104 U+0065)
  0x01, 0x04, 0x00, 0x67, 0x01, // Ąg (U+0104 U+0067)
  0x01, 0x04, 0x00, 0x6F, 0x01, // Ąo (U+0104 U+006F)
  0x01, 0x04, 0x00, 0x71, 0x01, // Ąq (U+0104 U+0071)
  0x01, 0x04, 0x00, 0x75, 0x01, // Ąu (U+0104 U+0075)
  0x01, 0x04, 0x00, 0x76, 0x03, // Ąv (U+0104 U+0076)
  0x01, 0x04, 0x00, 0x77, 0x02, // Ąw (U+0104 U+0077)
  0x01, 0x04, 0x00, 0x79, 0x03, // Ąy (U+0104 U+0079)
  0x01, 0x04, 0x00, 0xC7, 0x01, // ĄÇ (U+0104 U+00C7)
  0x01, 0x04, 0x00, 0xD2, 0x01, // ĄÒ (U+0104 U+00D2)
  0x01, 0x04, 0x00, 0xD3, 0x01, // ĄÓ (U+0104 U+00D3)
  0x01, 0x04, 0x00, 0xD4, 0x01, // ĄÔ (U+0104 U+00D4)
  0x01, 0x04, 0x00, 0xD5, 0x01, // ĄÕ (U+0104 U+00D5)
  0x01, 0x04, 0x00, 0xD6, 0x01, // ĄÖ (U+0104 U+00D6)
  0x01, 0x04, 0x00, 0xD8, 0x01, // ĄØ (U+0104 U+00D8)
  0x01, 0x04, 0x00, 0xD9, 0x01, // ĄÙ (U+0104 U+00D9)
  0x01, 0x04, 0x00, 0xDA, 0x01, // ĄÚ (U+0104 U+00DA)
  0x01, 0x04, 0x00, 0xDB, 0x01, // ĄÛ (U+0104 U+00DB)
  0x01, 0x04, 0x00, 0xDC, 0x01, // ĄÜ (U+0104 U+00DC)
  0x01, 0x04, 0x00, 0xDD, 0x03, // ĄÝ (U+0104 U+00DD)
  0x01, 0x04, 0x00, 0xE7, 0x01, // Ąç (U+0104 U+00E7)
  0x01, 0x04, 0x00, 0xE8, 0x01, // Ąè (U+0104 U+00E8)
  0x01, 0x04, 0x00, 0xE9, 0x01, // Ąé (U+0104 U+00E9)
  0x01, 0x04, 0x00, 0xEA, 0x01, // Ąê (U+0104 U+00EA)
  0x01, 0x04, 0x00, 0xEB, 0x01, // Ąë (U+0104 U+00EB)
  0x01, 0x04, 0x00, 0xF0, 0x01, // Ąð (U+0104 U+00F0)
  0x01, 0x04, 0x00, 0xF2, 0x01, // Ąò (U+0104 U+00F2)
  0x01, 0x04, 0x00, 0xF3, 0x01, // Ąó (U+0104 U+00F3)
  0x01, 0x04, 0x00, 0xF4, 0x01, // Ąô (U+0104 U+00F4)
  0x01, 0x04, 0x00, 0xF5, 0x01, // Ąõ (U+0104 U+00F5)
  0x01, 0x04, 0x00, 0xF6, 0x01, // Ąö (U+0104 U+00F6)
  0x01, 0x04, 0x00, 0xF8, 0x01, // Ąø (U+0104 U+00F8)
  0x01, 0x04, 0x00, 0xF9, 0x01, // Ąù (U+0104 U+00F9)
  0x01, 0x04, 0x00, 0xFA, 0x01, // Ąú (U+0104 U+00FA)
  0x01, 0x04, 0x00, 0xFB, 0x01, // Ąû (U+0104 U+00FB)
  0x01, 0x04, 0x00, 0xFC, 0x01, // Ąü (U+0104 U+00FC)
  0x01, 0x04, 0x00, 0xFD, 0x03, // Ąý (U+0104 U+00FD)
  0x01, 0x04, 0x00, 0xFF, 0x03, // Ąÿ (U+0104 U+00FF)
  0x01, 0x04, 0x01, 0x06, 0x01, // ĄĆ (U+0104 U+0106)
  0x01, 0x04, 0x01, 0x07, 0x01, // Ąć (U+0104 U+0107)
  0x01, 0x04, 0x01, 0x08, 0x01, // ĄĈ (U+0104 U+0108)
  0x01, 0x04, 0x01, 0x09, 0x01, // Ąĉ (U+0104 U+0109)
  0x01, 0x04, 0x01, 0x0A, 0x01, // ĄĊ (U+0104 U+010A)
  0x01, 0x04, 0x01, 0x0B, 0x01, // Ąċ (U+0104 U+010B)
  0x01, 0x04, 0x01, 0x0C, 0x01, // ĄČ (U+0104 U+010C)
  0x01, 0x04, 0x01, 0x0D, 0x01, // Ąč (U+0104 U+010D)
  0x01, 0x04, 0x01, 0x0F, 0x01, // Ąď (U+0104 U+010F)
  0x01, 0x04, 0x01, 0x11, 0x01, // Ąđ (U+0104 U+0111)
  0x01, 0x04, 0x01, 0x13, 0x01, // Ąē (U+0104 U+0113)
  0x01, 0x04, 0x01, 0x15, 0x01, // Ąĕ (U+0104 U+0115)
  0x01, 0x04, 0x01, 0x17, 0x01, // Ąė (U+0104 U+0117)
  0x01, 0x04, 0x01, 0x19, 0x01, // Ąę (U+0104 U+0119)
  0x01, 0x04, 0x01, 0x1B, 0x01, // Ąě (U+0104 U+011B)
  0x01, 0x04, 0x01, 0x1C, 0x01, // ĄĜ (U+0104 U+011C)
  0x01, 0x04, 0x01, 0x1D, 0x01, // Ąĝ (U+0104 U+011D)
  0x01, 0x04, 0x01, 0x1E, 0x01, // ĄĞ (U+0104 U+011E)
  0x01, 0x04, 0x01, 0x1F, 0x01, // Ąğ (U+0104 U+011F)
  0x01, 0x04, 0x01, 0x20, 0x01, // ĄĠ (U+0104 U+0120)
  0x01, 0x04, 0x01, 0x21, 0x01, // Ąġ (U+0104 U+0121)
  0x01, 0x04, 0x01, 0x22, 0x01, // ĄĢ (U+0104 U+0122)
  0x01, 0x04, 0x01, 0x23, 0x01, // Ąģ (U+0104 U+0123)
  0x01, 0x04, 0x01, 0x4C, 0x01, // ĄŌ (U+0104 U+014C)
  0x01, 0x04, 0x01, 0x4D, 0x01, // Ąō (U+0104 U+014D)
  0x01, 0x04, 0x01, 0x4E, 0x01, // ĄŎ (U+0104 U+014E)
  0x01, 0x04, 0x01, 0x4F, 0x01, // Ąŏ (U+0104 U+014F)
  0x01, 0x04, 0x01, 0x50, 0x01, // ĄŐ (U+0104 U+0150)
  0x01, 0x04, 0x01, 0x51, 0x01, // Ąő (U+0104 U+0151)
  0x01, 0x04, 0x01, 0x52, 0x01, // ĄŒ (U+0104 U+0152)
  0x01, 0x04, 0x01, 0x53, 0x01, // Ąœ (U+0104 U+0153)
  0x01, 0x04, 0x01, 0x62, 0x03, // ĄŢ (U+0104 U+0162)
  0x01, 0x04, 0x01, 0x64, 0x03, // ĄŤ (U+0104 U+0164)
  0x01, 0x04, 0x01, 0x66, 0x03, // ĄŦ (U+0104 U+0166)
  0x01, 0x04, 0x01, 0x68, 0x01, // ĄŨ (U+0104 U+0168)
  0x01, 0x04, 0x01, 0x69, 0x01, // Ąũ (U+0104 U+0169)
  0x01, 0x04, 0x01, 0x6A, 0x01, // ĄŪ (U+0104 U+016A)
  0x01, 0x04, 0x01, 0x6B, 0x01, // Ąū (U+0104 U+016B)
  0x01, 0x04, 0x01, 0x6C, 0x01, // ĄŬ (U+0104 U+016C)
  0x01, 0x04, 0x01, 0x6D, 0x01, // Ąŭ (U+0104 U+016D)
  0x01, 0x04, 0x01, 0x6E, 0x01, // ĄŮ (U+0104 U+016E)
  0x01, 0x04, 0x01, 0x6F, 0x01, // Ąů (U+0104 U+016F)
  0x01, 0x04, 0x01, 0x70, 0x01, // ĄŰ (U+0104 U+0170)
  0x01, 0x04, 0x01, 0x71, 0x01, // Ąű (U+0104 U+0171)
  0x01, 0x04, 0x01, 0x72, 0x01, // ĄŲ (U+0104 U+0172)
  0x01, 0x04, 0x01, 0x73, 0x01, // Ąų (U+0104 U+0173)
  0x01, 0x04, 0x01, 0x74, 0x03, // ĄŴ (U+0104 U+0174)
  0x01, 0x04, 0x01, 0x75, 0x02, // Ąŵ (U+0104 U+0175)
  0x01, 0x04, 0x01, 0x76, 0x03, // ĄŶ (U+0104 U+0176)
  0x01, 0x04, 0x01, 0x77, 0x03, // Ąŷ (U+0104 U+0177)
  0x01, 0x04, 0x01, 0x78, 0x03, // ĄŸ (U+0104 U+0178)
  0x01, 0x04, 0x20, 0x18, 0x04, // Ą‘ (U+0104 U+2018)
  0x01, 0x04, 0x20, 0x19, 0x04, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1C, 0x04, // Ą“ (U+0104 U+201C)
  0x01, 0x04, 0x20, 0x1D, 0x04, // Ą” (U+0104 U+201D)
  0x01, 0x04, 0x21, 0x22, 0x04, // Ą™ (U+0104 U+2122)
  0x01, 0x05, 0x00, 0x56, 0x02, // ąV (U+0105 U+0056)
  0x01, 0x05, 0x00, 0x57, 0x02, // ąW (U+0105 U+0057)
  0x01, 0x05, 0x00, 0x59, 0x02, // ąY (U+0105 U+0059)
  0x01, 0x05, 0x00, 0xDD, 0x02, // ąÝ (U+0105 U+00DD)
  0x01, 0x05, 0x01, 0x74, 0x02, // ąŴ (U+0105 U+0174)
  0x01, 0x05, 0x01, 0x76, 0x02, // ąŶ (U+0105 U+0176)
  0x01, 0x05, 0x01, 0x78, 0x02, // ąŸ (U+0105 U+0178)
  0x01, 0x0E, 0x00, 0x2C, 0x01, // Ď, (U+010E U+002C)
  0x01, 0x0E, 0x00, 0x2E, 0x01, // Ď. (U+010E U+002E)
  0x01, 0x0E, 0x00, 0x3F, 0x01, // Ď? (U+010E U+003F)
  0x01, 0x0E, 0x00, 0x41, 0x01, // ĎA (U+010E U+0041)
  0x01, 0x0E, 0x00, 0x54, 0x01, // ĎT (U+010E U+0054)
  0x01, 0x0E, 0x00, 0x56, 0x01, // ĎV (U+010E U+0056)
  0x01, 0x0E, 0x00, 0x57, 0x01, // ĎW (U+010E U+0057)
  0x01, 0x0E, 0x00, 0x58, 0x01, // ĎX (U+010E U+0058)
  0x01, 0x0E, 0x00, 0x59, 0x02, // ĎY (U+010E U+0059)
  0x01, 0x0E, 0x00, 0xC0, 0x01, // ĎÀ (U+010E U+00C0)
  0x01, 0x0E, 0x00, 0xC1, 0x01, // ĎÁ (U+010E U+00C1)
  0x01, 0x0E, 0x00, 0xC2, 0x01, // ĎÂ (U+010E U+00C2)
  0x01, 0x0E, 0x00, 0xC3, 0x01, // ĎÃ (U+010E U+00C3)
  0x01, 0x0E, 0x00, 0xC4, 0x01, // ĎÄ (U+010E U+00C4)
  0x01, 0x0E, 0x00, 0xC5, 0x01, // ĎÅ (U+010E U+00C5)
  0x01, 0x0E, 0x00, 0xC6, 0x03, // ĎÆ (U+010E U+00C6)
  0x01, 0x0E, 0x00, 0xDD, 0x02, // ĎÝ (U+010E U+00DD)
  0x01, 0x0E, 0x01, 0x00, 0x01, // ĎĀ (U+010E U+0100)
  0x01, 0x0E, 0x01, 0x02, 0x01, // ĎĂ (U+010E U+0102)
  0x01, 0x0E, 0x01, 0x04, 0x01, // ĎĄ (U+010E U+0104)
  0x01, 0x0E, 0x01, 0x62, 0x01, // ĎŢ (U+010E U+0162)
  0x01, 0x0E, 0x01, 0x64, 0x01, // ĎŤ (U+010E U+0164)
  0x01, 0x0E, 0x01, 0x66, 0x01, // ĎŦ (U+010E U+0166)
  0x01, 0x0E, 0x01, 0x74, 0x01, // ĎŴ (U+010E U+0174)
  0x01, 0x0E, 0x01, 0x76, 0x02, // ĎŶ (U+010E U+0176)
  0x01, 0x0E, 0x01, 0x78, 0x02, // ĎŸ (U+010E U+0178)
  0x01, 0x0E, 0x20, 0x1A, 0x01, // Ď‚ (U+010E U+201A)
  0x01, 0x0E, 0x20, 0x1E, 0x01, // Ď„ (U+010E U+201E)
  0x01, 0x0E, 0x20, 0x26, 0x01, // Ď… (U+010E U+2026)
  0x01, 0x10, 0x00, 0x2C, 0x01, // Đ, (U+0110 U+002C)
  0x01, 0x10, 0x00, 0x2E, 0x01, // Đ. (U+0110 U+002E)
  0x01, 0x10, 0x00, 0x3F, 0x01, // Đ? (U+0110 U+003F)
  0x01, 0x10, 0x00, 0x41, 0x01, // ĐA (U+0110 U+0041)
  0x01, 0x10, 0x00, 0x54, 0x01, // ĐT (U+0110 U+0054)
  0x01, 0x10, 0x00, 0x56, 0x01, // ĐV (U+0110 U+0056)
  0x01, 0x10, 0x00, 0x57, 0x01, // ĐW (U+0110 U+0057)
  0x01, 0x10, 0x00, 0x58, 0x01, // ĐX (U+0110 U+0058)
  0x01, 0x10, 0x00, 0x59, 0x02, // ĐY (U+0110 U+0059)
  0x01, 0x10, 0x00, 0xC0, 0x01, // ĐÀ (U+0110 U+00C0)
  0x01, 0x10, 0x00, 0xC1, 0x01, // ĐÁ (U+0110 U+00C1)
  0x01, 0x10, 0x00, 0xC2, 0x01, // ĐÂ (U+0110 U+00C2)
  0x01, 0x10, 0x00, 0xC3, 0x01, // ĐÃ (U+0110 U+00C3)
  0x01, 0x10, 0x00, 0xC4, 0x01, // ĐÄ (U+0110 U+00C4)
  0x01, 0x10, 0x00, 0xC5, 0x01, // ĐÅ (U+0110 U+00C5)
  0x01, 0x10, 0x00, 0xC6, 0x03, // ĐÆ (U+0110 U+00C6)
  0x01, 0x10, 0x00, 0xDD, 0x02, // ĐÝ (U+0110 U+00DD)
  0x01, 0x10, 0x01, 0x00, 0x01, // ĐĀ (U+0110 U+0100)
  0x01, 0x10, 0x01, 0x02, 0x01, // ĐĂ (U+0110 U+0102)
  0x01, 0x10, 0x01, 0x04, 0x01, // ĐĄ (U+0110 U+0104)
  0x01, 0x10, 0x01, 0x62, 0x01, // ĐŢ (U+0110 U+0162)
  0x01, 0x10, 0x01, 0x64, 0x01, // ĐŤ (U+0110 U+0164)
  0x01, 0x10, 0x01, 0x66, 0x01, // ĐŦ (U+0110 U+0166)
  0x01, 0x10, 0x01, 0x74, 0x01, // ĐŴ (U+0110 U+0174)
  0x01, 0x10, 0x01, 0x76, 0x02, // ĐŶ (U+0110 U+0176)
  0x01, 0x10, 0x01, 0x78, 0x02, // ĐŸ (U+0110 U+0178)
  0x01, 0x10, 0x20, 0x1A, 0x01, // Đ‚ (U+0110 U+201A)
  0x01, 0x10, 0x20, 0x1E, 0x01, // Đ„ (U+0110 U+201E)
  0x01, 0x10, 0x20, 0x26, 0x01, // Đ… (U+0110 U+2026)
  0x01, 0x12, 0x00, 0x56, 0x01, // ĒV (U+0112 U+0056)
  0x01, 0x12, 0x00, 0x57, 0x01, // ĒW (U+0112 U+0057)
  0x01, 0x12, 0x00, 0x59, 0x01, // ĒY (U+0112 U+0059)
  0x01, 0x12, 0x00, 0xDD, 0x01, // ĒÝ (U+0112 U+00DD)
  0x01, 0x12, 0x01, 0x74, 0x01, // ĒŴ (U+0112 U+0174)
  0x01, 0x12, 0x01, 0x76, 0x01, // ĒŶ (U+0112 U+0176)
  0x01, 0x12, 0x01, 0x78, 0x01, // ĒŸ (U+0112 U+0178)
  0x01, 0x13, 0x00, 0x56, 0x02, // ēV (U+0113 U+0056)
  0x01, 0x13, 0x00, 0x57, 0x02, // ēW (U+0113 U+0057)
  0x01, 0x13, 0x00, 0x59, 0x03, // ēY (U+0113 U+0059)
  0x01, 0x13, 0x00, 0xDD, 0x03, // ēÝ (U+0113 U+00DD)
  0x01, 0x13, 0x01, 0x74, 0x02, // ēŴ (U+0113 U+0174)
  0x01, 0x13, 0x01, 0x76, 0x03, // ēŶ (U+0113 U+0176)
  0x01, 0x13, 0x01, 0x78, 0x03, // ēŸ (U+0113 U+0178)
  0x01, 0x14, 0x00, 0x56, 0x01, // ĔV (U+0114 U+0056)
  0x01, 0x14, 0x00, 0x57, 0x01, // ĔW (U+0114 U+0057)
  0x01, 0x14, 0x00, 0x59, 0x01, // ĔY (U+0114 U+0059)
  0x01, 0x14, 0x00, 0xDD, 0x01, // ĔÝ (U+0114 U+00DD)
  0x01, 0x14, 0x01, 0x74, 0x01, // ĔŴ (U+0114 U+0174)
  0x01, 0x14, 0x01, 0x76, 0x01, // ĔŶ (U+0114 U+0176)
  0x01, 0x14, 0x01, 0x78, 0x01, // ĔŸ (U+0114 U+0178)
  0x01, 0x15, 0x00, 0x56, 0x02, // ĕV (U+0115 U+0056)
  0x01, 0x15, 0x00, 0x57, 0x02, // ĕW (U+0115 U+0057)
  0x01, 0x15, 0x00, 0x59, 0x03, // ĕY (U+0115 U+0059)
  0x01, 0x15, 0x00, 0xDD, 0x03, // ĕÝ (U+0115 U+00DD)
  0x01, 0x15, 0x01, 0x74, 0x02, // ĕŴ (U+0115 U+0174)
  0x01, 0x15, 0x01, 0x76, 0x03, // ĕŶ (U+0115 U+0176)
  0x01, 0x15, 0x01, 0x78, 0x03, // ĕŸ (U+0115 U+0178)
  0x01, 0x16, 0x00, 0x56, 0x01, // ĖV (U+0116 U+0056)
  0x01, 0x16, 0x00, 0x57, 0x01, // ĖW (U+0116 U+0057)
  0x01, 0x16, 0x00, 0x59, 0x01, // ĖY (U+0116 U+0059)
  0x01, 0x16, 0x00, 0xDD, 0x01, // ĖÝ (U+0116 U+00DD)
  0x01, 0x16, 0x01, 0x74, 0x01, // ĖŴ (U+0116 U+0174)
  0x01, 0x16, 0x01, 0x76, 0x01, // ĖŶ (U+0116 U+0176)
  0x01, 0x16, 0x01, 0x78, 0x01, // ĖŸ (U+0116 U+0178)
  0x01, 0x17, 0x00, 0x56, 0x02, // ėV (U+0117 U+0056)
  0x01, 0x17, 0x00, 0x57, 0x02, // ėW (U+0117 U+0057)
  0x01, 0x17, 0x00, 0x59, 0x03, // ėY (U+0117 U+0059)
  0x01, 0x17, 0x00, 0xDD, 0x03, // ėÝ (U+0117 U+00DD)
  0x01, 0x17, 0x01, 0x74, 0x02, // ėŴ (U+0117 U+0174)
  0x01, 0x17, 0x01, 0x76, 0x03, // ėŶ (U+0117 U+0176)
  0x01, 0x17, 0x01, 0x78, 0x03, // ėŸ (U+0117 U+0178)
  0x01, 0x18, 0x00, 0x56, 0x01, // ĘV (U+0118 U+0056)
  0x01, 0x18, 0x00, 0x57, 0x01, // ĘW (U+0118 U+0057)
  0x01, 0x18, 0x00, 0x59, 0x01, // ĘY (U+0118 U+0059)
  0x01, 0x18, 0x00, 0xDD, 0x01, // ĘÝ (U+0118 U+00DD)
  0x01, 0x18, 0x01, 0x74, 0x01, // ĘŴ (U+0118 U+0174)
  0x01, 0x18, 0x01, 0x76, 0x01, // ĘŶ (U+0118 U+0176)
  0x01, 0x18, 0x01, 0x78, 0x01, // ĘŸ (U+0118 U+0178)
  0x01, 0x19, 0x00, 0x56, 0x02, // ęV (U+0119 U+0056)
  0x01, 0x19, 0x00, 0x57, 0x02, // ęW (U+0119 U+0057)
  0x01, 0x19, 0x00, 0x59, 0x03, // ęY (U+0119 U+0059)
  0x01, 0x19, 0x00, 0xDD, 0x03, // ęÝ (U+0119 U+00DD)
  0x01, 0x19, 0x01, 0x74, 0x02, // ęŴ (U+0119 U+0174)
  0x01, 0x19, 0x01, 0x76, 0x03, // ęŶ (U+0119 U+0176)
  0x01, 0x19, 0x01, 0x78, 0x03, // ęŸ (U+0119 U+0178)
  0x01, 0x1A, 0x00, 0x56, 0x01, // ĚV (U+011A U+0056)
  0x01, 0x1A, 0x00, 0x57, 0x01, // ĚW (U+011A U+0057)
  0x01, 0x1A, 0x00, 0x59, 0x01, // ĚY (U+011A U+0059)
  0x01, 0x1A, 0x00, 0xDD, 0x01, // ĚÝ (U+011A U+00DD)
  0x01, 0x1A, 0x01, 0x74, 0x01, // ĚŴ (U+011A U+0174)
  0x01, 0x1A, 0x01, 0x76, 0x01, // ĚŶ (U+011A U+0176)
  0x01, 0x1A, 0x01, 0x78, 0x01, // ĚŸ (U+011A U+0178)
  0x01, 0x1B, 0x00, 0x56, 0x02, // ěV (U+011B U+0056)
  0x01, 0x1B, 0x00, 0x57, 0x02, // ěW (U+011B U+0057)
  0x01, 0x1B, 0x00, 0x59, 0x03, // ěY (U+011B U+0059)
  0x01, 0x1B, 0x00, 0xDD, 0x03, // ěÝ (U+011B U+00DD)
  0x01, 0x1B, 0x01, 0x74, 0x02, // ěŴ (U+011B U+0174)
  0x01, 0x1B, 0x01, 0x76, 0x03, // ěŶ (U+011B U+0176)
  0x01, 0x1B, 0x01, 0x78, 0x03, // ěŸ (U+011B U+0178)
  0x01, 0x1C, 0x00, 0x3F, 0x01, // Ĝ? (U+011C U+003F)
  0x01, 0x1C, 0x00, 0x54, 0x01, // ĜT (U+011C U+0054)
  0x01, 0x1C, 0x00, 0x56, 0x01, // ĜV (U+011C U+0056)
  0x01, 0x1C, 0x00, 0x57, 0x01, // ĜW (U+011C U+0057)
  0x01, 0x1C, 0x00, 0x59, 0x01, // ĜY (U+011C U+0059)
  0x01, 0x1C, 0x00, 0xC6, 0x01, // ĜÆ (U+011C U+00C6)
  0x01, 0x1C, 0x00, 0xDD, 0x01, // ĜÝ (U+011C U+00DD)
  0x01, 0x1C, 0x01, 0x62, 0x01, // ĜŢ (U+011C U+0162)
  0x01, 0x1C, 0x01, 0x64, 0x01, // ĜŤ (U+011C U+0164)
  0x01, 0x1C, 0x01, 0x66, 0x01, // ĜŦ (U+011C U+0166)
  0x01, 0x1C, 0x01, 0x74, 0x01, // ĜŴ (U+011C U+0174)
  0x01, 0x1C, 0x01, 0x76, 0x01, // ĜŶ (U+011C U+0176)
  0x01, 0x1C, 0x01, 0x78, 0x01, // ĜŸ (U+011C U+0178)
  0x01, 0x1E, 0x00, 0x3F, 0x01, // Ğ? (U+011E U+003F)
  0x01, 0x1E, 0x00, 0x54, 0x01, // ĞT (U+011E U+0054)
  0x01, 0x1E, 0x00, 0x56, 0x01, // ĞV (U+011E U+0056)
  0x01, 0x1E, 0x00, 0x57, 0x01, // ĞW (U+011E U+0057)
  0x01, 0x1E, 0x00, 0x59, 0x01, // ĞY (U+011E U+0059)
  0x01, 0x1E, 0x00, 0xC6, 0x01, // ĞÆ (U+011E U+00C6)
  0x01, 0x1E, 0x00, 0xDD, 0x01, // ĞÝ (U+011E U+00DD)
  0x01, 0x1E, 0x01, 0x62, 0x01, // ĞŢ (U+011E U+0162)
  0x01, 0x1E, 0x01, 0x64, 0x01, // ĞŤ (U+011E U+0164)
  0x01, 0x1E, 0x01, 0x66, 0x01, // ĞŦ (U+011E U+0166)
  0x01, 0x1E, 0x01, 0x74, 0x01, // ĞŴ (U+011E U+0174)
  0x01, 0x1E, 0x01, 0x76, 0x01, // ĞŶ (U+011E U+0176)
  0x01, 0x1E, 0x01, 0x78, 0x01, // ĞŸ (U+011E U+0178)
  0x01, 0x20, 0x00, 0x3F, 0x01, // Ġ? (U+0120 U+003F)
  0x01, 0x20, 0x00, 0x54, 0x01, // ĠT (U+0120 U+0054)
  0x01, 0x20, 0x00, 0x56, 0x01, // ĠV (U+0120 U+0056)
  0x01, 0x20, 0x00, 0x57, 0x01, // ĠW (U+0120 U+0057)
  0x01, 0x20, 0x00, 0x59, 0x01, // ĠY (U+0120 U+0059)
  0x01, 0x20, 0x00, 0xC6, 0x01, // ĠÆ (U+0120 U+00C6)
  0x01, 0x20, 0x00, 0xDD, 0x01, // ĠÝ (U+0120 U+00DD)
  0x01, 0x20, 0x01, 0x62, 0x01, // ĠŢ (U+0120 U+0162)
  0x01, 0x20, 0x01, 0x64, 0x01, // ĠŤ (U+0120 U+0164)
  0x01, 0x20, 0x01, 0x66, 0x01, // ĠŦ (U+0120 U+0166)
  0x01, 0x20, 0x01, 0x74, 0x01, // ĠŴ (U+0120 U+0174)
  0x01, 0x20, 0x01, 0x76, 0x01, // ĠŶ (U+0120 U+0176)
  0x01, 0x20, 0x01, 0x78, 0x01, // ĠŸ (U+0120 U+0178)
  0x01, 0x22, 0x00, 0x3F, 0x01, // Ģ? (U+0122 U+003F)
  0x01, 0x22, 0x00, 0x54, 0x01, // ĢT (U+0122 U+0054)
  0x01, 0x22, 0x00, 0x56, 0x01, // ĢV (U+0122 U+0056)
  0x01, 0x22, 0x00, 0x57, 0x01, // ĢW (U+0122 U+0057)
  0x01, 0x22, 0x00, 0x59, 0x01, // ĢY (U+0122 U+0059)
  0x01, 0x22, 0x00, 0xC6, 0x01, // ĢÆ (U+0122 U+00C6)
  0x01, 0x22, 0x00, 0xDD, 0x01, // ĢÝ (U+0122 U+00DD)
  0x01, 0x22, 0x01, 0x62, 0x01, // ĢŢ (U+0122 U+0162)
  0x01, 0x22, 0x01, 0x64, 0x01, // ĢŤ (U+0122 U+0164)
  0x01, 0x22, 0x01, 0x66, 0x01, // ĢŦ (U+0122 U+0166)
  0x01, 0x22, 0x01, 0x74, 0x01, // ĢŴ (U+0122 U+0174)
  0x01, 0x22, 0x01, 0x76, 0x01, // ĢŶ (U+0122 U+0176)
  0x01, 0x22, 0x01, 0x78, 0x01, // ĢŸ (U+0122 U+0178)
  0x01, 0x25, 0x00, 0x22, 0x02, // ĥ" (U+0125 U+0022)
  0x01, 0x25, 0x00, 0x27, 0x02, // ĥ' (U+0125 U+0027)
  0x01, 0x25, 0x00, 0x3F, 0x01, // ĥ? (U+0125 U+003F)
  0x01, 0x25, 0x00, 0x54, 0x01, // ĥT (U+0125 U+0054)
  0x01, 0x25, 0x00, 0x56, 0x02, // ĥV (U+0125 U+0056)
  0x01, 0x25, 0x00, 0x57, 0x02, // ĥW (U+0125 U+0057)
  0x01, 0x25, 0x00, 0x59, 0x02, // ĥY (U+0125 U+0059)
  0x01, 0x25, 0x00, 0x79, 0x01, // ĥy (U+0125 U+0079)
  0x01, 0x25, 0x00, 0xDD, 0x02, // ĥÝ (U+0125 U+00DD)
  0x01, 0x25, 0x00, 0xFD, 0x01, // ĥý (U+0125 U+00FD)
  0x01, 0x25, 0x00, 0xFF, 0x01, // ĥÿ (U+0125 U+00FF)
  0x01, 0x25, 0x01, 0x62, 0x01, // ĥŢ (U+0125 U+0162)
  0x01, 0x25, 0x01, 0x64, 0x01, // ĥŤ (U+0125 U+0164)
  0x01, 0x25, 0x01, 0x66, 0x01, // ĥŦ (U+0125 U+0166)
  0x01, 0x25, 0x01, 0x74, 0x02, // ĥŴ (U+0125 U+0174)
  0x01, 0x25, 0x01, 0x76, 0x02, // ĥŶ (U+0125 U+0176)
  0x01, 0x25, 0x01, 0x77, 0x01, // ĥŷ (U+0125 U+0177)
  0x01, 0x25, 0x01, 0x78, 0x02, // ĥŸ (U+0125 U+0178)
  0x01, 0x27, 0x00, 0x22, 0x02, // ħ" (U+0127 U+0022)
  0x01, 0x27, 0x00, 0x27, 0x02, // ħ' (U+0127 U+0027)
  0x01, 0x27, 0x00, 0x3F, 0x01, // ħ? (U+0127 U+003F)
  0x01, 0x27, 0x00, 0x54, 0x01, // ħT (U+0127 U+0054)
  0x01, 0x27, 0x00, 0x56, 0x02, // ħV (U+0127 U+0056)
  0x01, 0x27, 0x00, 0x57, 0x02, // ħW (U+0127 U+0057)
  0x01, 0x27, 0x00, 0x59, 0x02, // ħY (U+0127 U+0059)
  0x01, 0x27, 0x00, 0x79, 0x01, // ħy (U+0127 U+0079)
  0x01, 0x27, 0x00, 0xDD, 0x02, // ħÝ (U+0127 U+00DD)
  0x01, 0x27, 0x00, 0xFD, 0x01, // ħý (U+0127 U+00FD)
  0x01, 0x27, 0x00, 0xFF, 0x01, // ħÿ (U+0127 U+00FF)
  0x01, 0x27, 0x01, 0x62, 0x01, // ħŢ (U+0127 U+0162)
  0x01, 0x27, 0x01, 0x64, 0x01, // ħŤ (U+0127 U+0164)
  0x01, 0x27, 0x01, 0x66, 0x01, // ħŦ (U+0127 U+0166)
  0x01, 0x27, 0x01, 0x74, 0x02, // ħŴ (U+0127 U+0174)
  0x01, 0x27, 0x01, 0x76, 0x02, // ħŶ (U+0127 U+0176)
  0x01, 0x27, 0x01, 0x77, 0x01, // ħŷ (U+0127 U+0177)
  0x01, 0x27, 0x01, 0x78, 0x02, // ħŸ (U+0127 U+0178)
  0x01, 0x36, 0x00, 0x43, 0x01, // ĶC (U+0136 U+0043)
  0x01, 0x36, 0x00, 0x47, 0x01, // ĶG (U+0136 U+0047)
  0x01, 0x36, 0x00, 0x4F, 0x01, // ĶO (U+0136 U+004F)
  0x01, 0x36, 0x00, 0x51, 0x01, // ĶQ (U+0136 U+0051)
  0x01, 0x36, 0x00, 0x63, 0x01, // Ķc (U+0136 U+0063)
  0x01, 0x36, 0x00, 0x64, 0x01, // Ķd (U+0136 U+0064)
  0x01, 0x36, 0x00, 0x65, 0x01, // Ķe (U+0136 U+0065)
  0x01, 0x36, 0x00, 0x67, 0x01, // Ķg (U+0136 U+0067)
  0x01, 0x36, 0x00, 0x6F, 0x01, // Ķo (U+0136 U+006F)
  0x01, 0x36, 0x00, 0x71, 0x01, // Ķq (U+0136 U+0071)
  0x01, 0x36, 0x00, 0x75, 0x01, // Ķu (U+0136 U+0075)
  0x01, 0x36, 0x00, 0x77, 0x02, // Ķw (U+0136 U+0077)
  0x01, 0x36, 0x00, 0x79, 0x02, // Ķy (U+0136 U+0079)
  0x01, 0x36, 0x00, 0xC7, 0x01, // ĶÇ (U+0136 U+00C7)
  0x01, 0x36, 0x00, 0xD2, 0x01, // ĶÒ (U+0136 U+00D2)
  0x01, 0x36, 0x00, 0xD3, 0x01, // ĶÓ (U+0136 U+00D3)
  0x01, 0x36, 0x00, 0xD4, 0x01, // ĶÔ (U+0136 U+00D4)
  0x01, 0x36, 0x00, 0xD5, 0x01, // ĶÕ (U+0136 U+00D5)
  0x01, 0x36, 0x00, 0xD6, 0x01, // ĶÖ (U+0136 U+00D6)
  0x01, 0x36, 0x00, 0xD8, 0x01, // ĶØ (U+0136 U+00D8)
  0x01, 0x36, 0x00, 0xE7, 0x01, // Ķç (U+0136 U+00E7)
  0x01, 0x36, 0x00, 0xE8, 0x01, // Ķè (U+0136 U+00E8)
  0x01, 0x36, 0x00, 0xE9, 0x01, // Ķé (U+0136 U+00E9)
  0x01, 0x36, 0x00, 0xEA, 0x01, // Ķê (U+0136 U+00EA)
  0x01, 0x36, 0x00, 0xEB, 0x01, // Ķë (U+0136 U+00EB)
  0x01, 0x36, 0x00, 0xF0, 0x01, // Ķð (U+0136 U+00F0)
  0x01, 0x36, 0x00, 0xF2, 0x01, // Ķò (U+0136 U+00F2)
  0x01, 0x36, 0x00, 0xF3, 0x01, // Ķó (U+0136 U+00F3)
  0x01, 0x36, 0x00, 0xF4, 0x01, // Ķô (U+0136 U+00F4)
  0x01, 0x36, 0x00, 0xF5, 0x01, // Ķõ (U+0136 U+00F5)
  0x01, 0x36, 0x00, 0xF6, 0x01, // Ķö (U+0136 U+00F6)
  0x01, 0x36, 0x00, 0xF8, 0x01, // Ķø (U+0136 U+00F8)
  0x01, 0x36, 0x00, 0xF9, 0x01, // Ķù (U+0136 U+00F9)
  0x01, 0x36, 0x00, 0xFA, 0x01, // Ķú (U+0136 U+00FA)
  0x01, 0x36, 0x00, 0xFB, 0x01, // Ķû (U+0136 U+00FB)
  0x01, 0x36, 0x00, 0xFC, 0x01, // Ķü (U+0136 U+00FC)
  0x01, 0x36, 0x00, 0xFD, 0x02, // Ķý (U+0136 U+00FD)
  0x01, 0x36, 0x00, 0xFF, 0x02, // Ķÿ (U+0136 U+00FF)
  0x01, 0x36, 0x01, 0x06, 0x01, // ĶĆ (U+0136 U+0106)
  0x01, 0x36, 0x01, 0x07, 0x01, // Ķć (U+0136 U+0107)
  0x01, 0x36, 0x01, 0x08, 0x01, // ĶĈ (U+0136 U+0108)
  0x01, 0x36, 0x01, 0x09, 0x01, // Ķĉ (U+0136 U+0109)
  0x01, 0x36, 0x01, 0x0A, 0x01, // ĶĊ (U+0136 U+010A)
  0x01, 0x36, 0x01, 0x0B, 0x01, // Ķċ (U+0136 U+010B)
  0x01, 0x36, 0x01, 0x0C, 0x01, // ĶČ (U+0136 U+010C)
  0x01, 0x36, 0x01, 0x0D, 0x01, // Ķč (U+0136 U+010D)
  0x01, 0x36, 0x01, 0x0F, 0x01, // Ķď (U+0136 U+010F)
  0x01, 0x36, 0x01, 0x11, 0x01, // Ķđ (U+0136 U+0111)
  0x01, 0x36, 0x01, 0x13, 0x01, // Ķē (U+0136 U+0113)
  0x01, 0x36, 0x01, 0x15, 0x01, // Ķĕ (U+0136 U+0115)
  0x01, 0x36, 0x01, 0x17, 0x01, // Ķė (U+0136 U+0117)
  0x01, 0x36, 0x01, 0x19, 0x01, // Ķę (U+0136 U+0119)
  0x01, 0x36, 0x01, 0x1B, 0x01, // Ķě (U+0136 U+011B)
  0x01, 0x36, 0x01, 0x1C, 0x01, // ĶĜ (U+0136 U+011C)
  0x01, 0x36, 0x01, 0x1D, 0x01, // Ķĝ (U+0136 U+011D)
  0x01, 0x36, 0x01, 0x1E, 0x01, // ĶĞ (U+0136 U+011E)
  0x01, 0x36, 0x01, 0x1F, 0x01, // Ķğ (U+0136 U+011F)
  0x01, 0x36, 0x01, 0x20, 0x01, // ĶĠ (U+0136 U+0120)
  0x01, 0x36, 0x01, 0x21, 0x01, // Ķġ (U+0136 U+0121)
  0x01, 0x36, 0x01, 0x22, 0x01, // ĶĢ (U+0136 U+0122)
  0x01, 0x36, 0x01, 0x23, 0x01, // Ķģ (U+0136 U+0123)
  0x01, 0x36, 0x01, 0x4C, 0x01, // ĶŌ (U+0136 U+014C)
  0x01, 0x36, 0x01, 0x4D, 0x01, // Ķō (U+0136 U+014D)
  0x01, 0x36, 0x01, 0x4E, 0x01, // ĶŎ (U+0136 U+014E)
  0x01, 0x36, 0x01, 0x4F, 0x01, // Ķŏ (U+0136 U+014F)
  0x01, 0x36, 0x01, 0x50, 0x01, // ĶŐ (U+0136 U+0150)
  0x01, 0x36, 0x01, 0x51, 0x01, // Ķő (U+0136 U+0151)
  0x01, 0x36, 0x01, 0x52, 0x01, // ĶŒ (U+0136 U+0152)
  0x01, 0x36, 0x01, 0x53, 0x01, // Ķœ (U+0136 U+0153)
  0x01, 0x36, 0x01, 0x69, 0x01, // Ķũ (U+0136 U+0169)
  0x01, 0x36, 0x01, 0x6B, 0x01, // Ķū (U+0136 U+016B)
  0x01, 0x36, 0x01, 0x6D, 0x01, // Ķŭ (U+0136 U+016D)
  0x01, 0x36, 0x01, 0x6F, 0x01, // Ķů (U+0136 U+016F)
  0x01, 0x36, 0x01, 0x71, 0x01, // Ķű (U+0136 U+0171)
  0x01, 0x36, 0x01, 0x73, 0x01, // Ķų (U+0136 U+0173)
  0x01, 0x36, 0x01, 0x75, 0x02, // Ķŵ (U+0136 U+0175)
  0x01, 0x36, 0x01, 0x77, 0x02, // Ķŷ (U+0136 U+0177)
  0x01, 0x37, 0x00, 0x63, 0x01, // ķc (U+0137 U+0063)
  0x01, 0x37, 0x00, 0x64, 0x01, // ķd (U+0137 U+0064)
  0x01, 0x37, 0x00, 0x65, 0x01, // ķe (U+0137 U+0065)
  0x01, 0x37, 0x00, 0x67, 0x01, // ķg (U+0137 U+0067)
  0x01, 0x37, 0x00, 0x6F, 0x01, // ķo (U+0137 U+006F)
  0x01, 0x37, 0x00, 0x71, 0x01, // ķq (U+0137 U+0071)
  0x01, 0x37, 0x00, 0xE7, 0x01, // ķç (U+0137 U+00E7)
  0x01, 0x37, 0x00, 0xE8, 0x01, // ķè (U+0137 U+00E8)
  0x01, 0x37, 0x00, 0xE9, 0x01, // ķé (U+0137 U+00E9)
  0x01, 0x37, 0x00, 0xEA, 0x01, // ķê (U+0137 U+00EA)
  0x01, 0x37, 0x00, 0xEB, 0x01, // ķë (U+0137 U+00EB)
  0x01, 0x37, 0x00, 0xF0, 0x01, // ķð (U+0137 U+00F0)
  0x01, 0x37, 0x00, 0xF2, 0x01, // ķò (U+0137 U+00F2)
  0x01, 0x37, 0x00, 0xF3, 0x01, // ķó (U+0137 U+00F3)
  0x01, 0x37, 0x00, 0xF4, 0x01, // ķô (U+0137 U+00F4)
  0x01, 0x37, 0x00, 0xF5, 0x01, // ķõ (U+0137 U+00F5)
  0x01, 0x37, 0x00, 0xF6, 0x01, // ķö (U+0137 U+00F6)
  0x01, 0x37, 0x00, 0xF8, 0x01, // ķø (U+0137 U+00F8)
  0x01, 0x37, 0x01, 0x07, 0x01, // ķć (U+0137 U+0107)
  0x01, 0x37, 0x01, 0x09, 0x01, // ķĉ (U+0137 U+0109)
  0x01, 0x37, 0x01, 0x0B, 0x01, // ķċ (U+0137 U+010B)
  0x01, 0x37, 0x01, 0x0D, 0x01, // ķč (U+0137 U+010D)
  0x01, 0x37, 0x01, 0x0F, 0x01, // ķď (U+0137 U+010F)
  0x01, 0x37, 0x01, 0x11, 0x01, // ķđ (U+0137 U+0111)
  0x01, 0x37, 0x01, 0x13, 0x01, // ķē (U+0137 U+0113)
  0x01, 0x37, 0x01, 0x15, 0x01, // ķĕ (U+0137 U+0115)
  0x01, 0x37, 0x01, 0x17, 0x01, // ķė (U+0137 U+0117)
  0x01, 0x37, 0x01, 0x19, 0x01, // ķę (U+0137 U+0119)
  0x01, 0x37, 0x01, 0x1B, 0x01, // ķě (U+0137 U+011B)
  0x01, 0x37, 0x01, 0x1D, 0x01, // ķĝ (U+0137 U+011D)
  0x01, 0x37, 0x01, 0x1F, 0x01, // ķğ (U+0137 U+011F)
  0x01, 0x37, 0x01, 0x21, 0x01, // ķġ (U+0137 U+0121)
  0x01, 0x37, 0x01, 0x23, 0x01, // ķģ (U+0137 U+0123)
  0x01, 0x37, 0x01, 0x4D, 0x01, // ķō (U+0137 U+014D)
  0x01, 0x37, 0x01, 0x4F, 0x01, // ķŏ (U+0137 U+014F)
  0x01, 0x37, 0x01, 0x51, 0x01, // ķő (U+0137 U+0151)
  0x01, 0x37, 0x01, 0x53, 0x01, // ķœ (U+0137 U+0153)
  0x01, 0x38, 0x00, 0x63, 0x01, // ĸc (U+0138 U+0063)
  0x01, 0x38, 0x00, 0x64, 0x01, // ĸd (U+0138 U+0064)
  0x01, 0x38, 0x00, 0x65, 0x01, // ĸe (U+0138 U+0065)
  0x01, 0x38, 0x00, 0x67, 0x01, // ĸg (U+0138 U+0067)
  0x01, 0x38, 0x00, 0x6F, 0x01, // ĸo (U+0138 U+006F)
  0x01, 0x38, 0x00, 0x71, 0x01, // ĸq (U+0138 U+0071)
  0x01, 0x38, 0x00, 0xE7, 0x01, // ĸç (U+0138 U+00E7)
  0x01, 0x38, 0x00, 0xE8, 0x01, // ĸè (U+0138 U+00E8)
  0x01, 0x38, 0x00, 0xE9, 0x01, // ĸé (U+0138 U+00E9)
  0x01, 0x38, 0x00, 0xEA, 0x01, // ĸê (U+0138 U+00EA)
  0x01, 0x38, 0x00, 0xEB, 0x01, // ĸë (U+0138 U+00EB)
  0x01, 0x38, 0x00, 0xF0, 0x01, // ĸð (U+0138 U+00F0)
  0x01, 0x38, 0x00, 0xF2, 0x01, // ĸò (U+0138 U+00F2)
  0x01, 0x38, 0x00, 0xF3, 0x01, // ĸó (U+0138 U+00F3)
  0x01, 0x38, 0x00, 0xF4, 0x01, // ĸô (U+0138 U+00F4)
  0x01, 0x38, 0x00, 0xF5, 0x01, // ĸõ (U+0138 U+00F5)
  0x01, 0x38, 0x00, 0xF6, 0x01, // ĸö (U+0138 U+00F6)
  0x01, 0x38, 0x00, 0xF8, 0x01, // ĸø (U+0138 U+00F8)
  0x01, 0x38, 0x01, 0x07, 0x01, // ĸć (U+0138 U+0107)
  0x01, 0x38, 0x01, 0x09, 0x01, // ĸĉ (U+0138 U+0109)
  0x01, 0x38, 0x01, 0x0B, 0x01, // ĸċ (U+0138 U+010B)
  0x01, 0x38, 0x01, 0x0D, 0x01, // ĸč (U+0138 U+010D)
  0x01, 0x38, 0x01, 0x0F, 0x01, // ĸď (U+0138 U+010F)
  0x01, 0x38, 0x01, 0x11, 0x01, // ĸđ (U+0138 U+0111)
  0x01, 0x38, 0x01, 0x13, 0x01, // ĸē (U+0138 U+0113)
  0x01, 0x38, 0x01, 0x15, 0x01, // ĸĕ (U+0138 U+0115)
  0x01, 0x38, 0x01, 0x17, 0x01, // ĸė (U+0138 U+0117)
  0x01, 0x38, 0x01, 0x19, 0x01, // ĸę (U+0138 U+0119)
  0x01, 0x38, 0x01, 0x1B, 0x01, // ĸě (U+0138 U+011B)
  0x01, 0x38, 0x01, 0x1D, 0x01, // ĸĝ (U+0138 U+011D)
  0x01, 0x38, 0x01, 0x1F, 0x01, // ĸğ (U+0138 U+011F)
  0x01, 0x38, 0x01, 0x21, 0x01, // ĸġ (U+0138 U+0121)
  0x01, 0x38, 0x01, 0x23, 0x01, // ĸģ (U+0138 U+0123)
  0x01, 0x38, 0x01, 0x4D, 0x01, // ĸō (U+0138 U+014D)
  0x01, 0x38, 0x01, 0x4F, 0x01, // ĸŏ (U+0138 U+014F)
  0x01, 0x38, 0x01, 0x51, 0x01, // ĸő (U+0138 U+0151)
  0x01, 0x38, 0x01, 0x53, 0x01, // ĸœ (U+0138 U+0153)
  0x01, 0x39, 0x00, 0x22, 0x04, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x04, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x00, 0x2A, 0x05, // Ĺ* (U+0139 U+002A)
  0x01, 0x39, 0x00, 0x3F, 0x04, // Ĺ? (U+0139 U+003F)
  0x01, 0x39, 0x00, 0x54, 0x04, // ĹT (U+0139 U+0054)
  0x01, 0x39, 0x00, 0x56, 0x03, // ĹV (U+0139 U+0056)
  0x01, 0x39, 0x00, 0x57, 0x03, // ĹW (U+0139 U+0057)
  0x01, 0x39, 0x00, 0x59, 0x04, // ĹY (U+0139 U+0059)
  0x01, 0x39, 0x00, 0x76, 0x01, // Ĺv (U+0139 U+0076)
  0x01, 0x39, 0x00, 0x77, 0x01, // Ĺw (U+0139 U+0077)
  0x01, 0x39, 0x00, 0x79, 0x02, // Ĺy (U+0139 U+0079)
  0x01, 0x39, 0x00, 0xB7, 0x01, // Ĺ· (U+0139 U+00B7)
  0x01, 0x39, 0x00, 0xDD, 0x04, // ĹÝ (U+0139 U+00DD)
  0x01, 0x39, 0x00, 0xFD, 0x02, // Ĺý (U+0139 U+00FD)
  0x01, 0x39, 0x00, 0xFF, 0x02, // Ĺÿ (U+0139 U+00FF)
  0x01, 0x39, 0x01, 0x62, 0x04, // ĹŢ (U+0139 U+0162)
  0x01, 0x39, 0x01, 0x64, 0x04, // ĹŤ (U+0139 U+0164)
  0x01, 0x39, 0x01, 0x66, 0x04, // ĹŦ (U+0139 U+0166)
  0x01, 0x39, 0x01, 0x74, 0x03, // ĹŴ (U+0139 U+0174)
  0x01, 0x39, 0x01, 0x75, 0x01, // Ĺŵ (U+0139 U+0175)
  0x01, 0x39, 0x01, 0x76, 0x04, // ĹŶ (U+0139 U+0176)
  0x01, 0x39, 0x01, 0x77, 0x02, // Ĺŷ (U+0139 U+0177)
  0x01, 0x39, 0x01, 0x78, 0x04, // ĹŸ (U+0139 U+0178)
  0x01, 0x39, 0x20, 0x18, 0x05, // Ĺ‘ (U+0139 U+2018)
  0x01, 0x39, 0x20, 0x19, 0x05, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1C, 0x05, // Ĺ“ (U+0139 U+201C)
  0x01, 0x39, 0x20, 0x1D, 0x05, // Ĺ” (U+0139 U+201D)
  0x01, 0x39, 0x21, 0x22, 0x05, // Ĺ™ (U+0139 U+2122)
  0x01, 0x3B, 0x00, 0x22, 0x04, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x04, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x00, 0x2A, 0x05, // Ļ* (U+013B U+002A)
  0x01, 0x3B, 0x00, 0x3F, 0x04, // Ļ? (U+013B U+003F)
  0x01, 0x3B, 0x00, 0x54, 0x04, // ĻT (U+013B U+0054)
  0x01, 0x3B, 0x00, 0x56, 0x03, // ĻV (U+013B U+0056)
  0x01, 0x3B, 0x00, 0x57, 0x03, // ĻW (U+013B U+0057)
  0x01, 0x3B, 0x00, 0x59, 0x04, // ĻY (U+013B U+0059)
  0x01, 0x3B, 0x00, 0x76, 0x01, // Ļv (U+013B U+0076)
  0x01, 0x3B, 0x00, 0x77, 0x01, // Ļw (U+013B U+0077)
  0x01, 0x3B, 0x00, 0x79, 0x02, // Ļy (U+013B U+0079)
  0x01, 0x3B, 0x00, 0xB7, 0x01, // Ļ· (U+013B U+00B7)
  0x01, 0x3B, 0x00, 0xDD, 0x04, // ĻÝ (U+013B U+00DD)
  0x01, 0x3B, 0x00, 0xFD, 0x02, // Ļý (U+013B U+00FD)
  0x01, 0x3B, 0x00, 0xFF, 0x02, // Ļÿ (U+013B U+00FF)
  0x01, 0x3B, 0x01, 0x62, 0x04, // ĻŢ (U+013B U+0162)
  0x01, 0x3B, 0x01, 0x64, 0x04, // ĻŤ (U+013B U+0164)
  0x01, 0x3B, 0x01, 0x66, 0x04, // ĻŦ (U+013B U+0166)
  0x01, 0x3B, 0x01, 0x74, 0x03, // ĻŴ (U+013B U+0174)
  0x01, 0x3B, 0x01, 0x75, 0x01, // Ļŵ (U+013B U+0175)
  0x01, 0x3B, 0x01, 0x76, 0x04, // ĻŶ (U+013B U+0176)
  0x01, 0x3B, 0x01, 0x77, 0x02, // Ļŷ (U+013B U+0177)
  0x01, 0x3B, 0x01, 0x78, 0x04, // ĻŸ (U+013B U+0178)
  0x01, 0x3B, 0x20, 0x18, 0x05, // Ļ‘ (U+013B U+2018)
  0x01, 0x3B, 0x20, 0x19, 0x05, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1C, 0x05, // Ļ“ (U+013B U+201C)
  0x01, 0x3B, 0x20, 0x1D, 0x05, // Ļ” (U+013B U+201D)
  0x01, 0x3B, 0x21, 0x22, 0x05, // Ļ™ (U+013B U+2122)
  0x01, 0x41, 0x00, 0x22, 0x04, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x04, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x00, 0x2A, 0x05, // Ł* (U+0141 U+002A)
  0x01, 0x41, 0x00, 0x3F, 0x04, // Ł? (U+0141 U+003F)
  0x01, 0x41, 0x00, 0x54, 0x04, // ŁT (U+0141 U+0054)
  0x01, 0x41, 0x00, 0x56, 0x03, // ŁV (U+0141 U+0056)
  0x01, 0x41, 0x00, 0x57, 0x03, // ŁW (U+0141 U+0057)
  0x01, 0x41, 0x00, 0x59, 0x04, // ŁY (U+0141 U+0059)
  0x01, 0x41, 0x00, 0x76, 0x01, // Łv (U+0141 U+0076)
  0x01, 0x41, 0x00, 0x77, 0x01, // Łw (U+0141 U+0077)
  0x01, 0x41, 0x00, 0x79, 0x02, // Ły (U+0141 U+0079)
  0x01, 0x41, 0x00, 0xB7, 0x01, // Ł· (U+0141 U+00B7)
  0x01, 0x41, 0x00, 0xDD, 0x04, // ŁÝ (U+0141 U+00DD)
  0x01, 0x41, 0x00, 0xFD, 0x02, // Łý (U+0141 U+00FD)
  0x01, 0x41, 0x00, 0xFF, 0x02, // Łÿ (U+0141 U+00FF)
  0x01, 0x41, 0x01, 0x62, 0x04, // ŁŢ (U+0141 U+0162)
  0x01, 0x41, 0x01, 0x64, 0x04, // ŁŤ (U+0141 U+0164)
  0x01, 0x41, 0x01, 0x66, 0x04, // ŁŦ (U+0141 U+0166)
  0x01, 0x41, 0x01, 0x74, 0x03, // ŁŴ (U+0141 U+0174)
  0x01, 0x41, 0x01, 0x75, 0x01, // Łŵ (U+0141 U+0175)
  0x01, 0x41, 0x01, 0x76, 0x04, // ŁŶ (U+0141 U+0176)
  0x01, 0x41, 0x01, 0x77, 0x02, // Łŷ (U+0141 U+0177)
  0x01, 0x41, 0x01, 0x78, 0x04, // ŁŸ (U+0141 U+0178)
  0x01, 0x41, 0x20, 0x18, 0x05, // Ł‘ (U+0141 U+2018)
  0x01, 0x41, 0x20, 0x19, 0x05, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1C, 0x05, // Ł“ (U+0141 U+201C)
  0x01, 0x41, 0x20, 0x1D, 0x05, // Ł” (U+0141 U+201D)
  0x01, 0x41, 0x21, 0x22, 0x05, // Ł™ (U+0141 U+2122)
  0x01, 0x43, 0x00, 0xAB, 0x01, // Ń« (U+0143 U+00AB)
  0x01, 0x43, 0x00, 0xBB, 0x01, // Ń» (U+0143 U+00BB)
  0x01, 0x43, 0x20, 0x39, 0x01, // Ń‹ (U+0143 U+2039)
  0x01, 0x43, 0x20, 0x3A, 0x01, // Ń› (U+0143 U+203A)
  0x01, 0x44, 0x00, 0x22, 0x02, // ń" (U+0144 U+0022)
  0x01, 0x44, 0x00, 0x27, 0x02, // ń' (U+0144 U+0027)
  0x01, 0x44, 0x00, 0x3F, 0x01, // ń? (U+0144 U+003F)
  0x01, 0x44, 0x00, 0x54, 0x01, // ńT (U+0144 U+0054)
  0x01, 0x44, 0x00, 0x56, 0x02, // ńV (U+0144 U+0056)
  0x01, 0x44, 0x00, 0x57, 0x02, // ńW (U+0144 U+0057)
  0x01, 0x44, 0x00, 0x59, 0x02, // ńY (U+0144 U+0059)
  0x01, 0x44, 0x00, 0x79, 0x01, // ńy (U+0144 U+0079)
  0x01, 0x44, 0x00, 0xDD, 0x02, // ńÝ (U+0144 U+00DD)
  0x01, 0x44, 0x00, 0xFD, 0x01, // ńý (U+0144 U+00FD)
  0x01, 0x44, 0x00, 0xFF, 0x01, // ńÿ (U+0144 U+00FF)
  0x01, 0x44, 0x01, 0x62, 0x01, // ńŢ (U+0144 U+0162)
  0x01, 0x44, 0x01, 0x64, 0x01, // ńŤ (U+0144 U+0164)
  0x01, 0x44, 0x01, 0x66, 0x01, // ńŦ (U+0144 U+0166)
  0x01, 0x44, 0x01, 0x74, 0x02, // ńŴ (U+0144 U+0174)
  0x01, 0x44, 0x01, 0x76, 0x02, // ńŶ (U+0144 U+0176)
  0x01, 0x44, 0x01, 0x77, 0x01, // ńŷ (U+0144 U+0177)
  0x01, 0x44, 0x01, 0x78, 0x02, // ńŸ (U+0144 U+0178)
  0x01, 0x45, 0x00, 0xAB, 0x01, // Ņ« (U+0145 U+00AB)
  0x01, 0x45, 0x00, 0xBB, 0x01, // Ņ» (U+0145 U+00BB)
  0x01, 0x45, 0x20, 0x39, 0x01, // Ņ‹ (U+0145 U+2039)
  0x01, 0x45, 0x20, 0x3A, 0x01, // Ņ› (U+0145 U+203A)
  0x01, 0x46, 0x00, 0x22, 0x02, // ņ" (U+0146 U+0022)
  0x01, 0x46, 0x00, 0x27, 0x02, // ņ' (U+0146 U+0027)
  0x01, 0x46, 0x00, 0x3F, 0x01, // ņ? (U+0146 U+003F)
  0x01, 0x46, 0x00, 0x54, 0x01, // ņT (U+0146 U+0054)
  0x01, 0x46, 0x00, 0x56, 0x02, // ņV (U+0146 U+0056)
  0x01, 0x46, 0x00, 0x57, 0x02, // ņW (U+0146 U+0057)
  0x01, 0x46, 0x00, 0x59, 0x02, // ņY (U+0146 U+0059)
  0x01, 0x46, 0x00, 0x79, 0x01, // ņy (U+0146 U+0079)
  0x01, 0x46, 0x00, 0xDD, 0x02, // ņÝ (U+0146 U+00DD)
  0x01, 0x46, 0x00, 0xFD, 0x01, // ņý (U+0146 U+00FD)
  0x01, 0x46, 0x00, 0xFF, 0x01, // ņÿ (U+0146 U+00FF)
  0x01, 0x46, 0x01, 0x62, 0x01, // ņŢ (U+0146 U+0162)
  0x01, 0x46, 0x01, 0x64, 0x01, // ņŤ (U+0146 U+0164)
  0x01, 0x46, 0x01, 0x66, 0x01, // ņŦ (U+0146 U+0166)
  0x01, 0x46, 0x01, 0x74, 0x02, // ņŴ (U+0146 U+0174)
  0x01, 0x46, 0x01, 0x76, 0x02, // ņŶ (U+0146 U+0176)
  0x01, 0x46, 0x01, 0x77, 0x01, // ņŷ (U+0146 U+0177)
  0x01, 0x46, 0x01, 0x78, 0x02, // ņŸ (U+0146 U+0178)
  0x01, 0x47, 0x00, 0xAB, 0x01, // Ň« (U+0147 U+00AB)
  0x01, 0x47, 0x00, 0xBB, 0x01, // Ň» (U+0147 U+00BB)
  0x01, 0x47, 0x20, 0x39, 0x01, // Ň‹ (U+0147 U+2039)
  0x01, 0x47, 0x20, 0x3A, 0x01, // Ň› (U+0147 U+203A)
  0x01, 0x48, 0x00, 0x22, 0x02, // ň" (U+0148 U+0022)
  0x01, 0x48, 0x00, 0x27, 0x02, // ň' (U+0148 U+0027)
  0x01, 0x48, 0x00, 0x3F, 0x01, // ň? (U+0148 U+003F)
  0x01, 0x48, 0x00, 0x54, 0x01, // ňT (U+0148 U+0054)
  0x01, 0x48, 0x00, 0x56, 0x02, // ňV (U+0148 U+0056)
  0x01, 0x48, 0x00, 0x57, 0x02, // ňW (U+0148 U+0057)
  0x01, 0x48, 0x00, 0x59, 0x02, // ňY (U+0148 U+0059)
  0x01, 0x48, 0x00, 0x79, 0x01, // ňy (U+0148 U+0079)
  0x01, 0x48, 0x00, 0xDD, 0x02, // ňÝ (U+0148 U+00DD)
  0x01, 0x48, 0x00, 0xFD, 0x01, // ňý (U+0148 U+00FD)
  0x01, 0x48, 0x00, 0xFF, 0x01, // ňÿ (U+0148 U+00FF)
  0x01, 0x48, 0x01, 0x62, 0x01, // ňŢ (U+0148 U+0162)
  0x01, 0x48, 0x01, 0x64, 0x01, // ňŤ (U+0148 U+0164)
  0x01, 0x48, 0x01, 0x66, 0x01, // ňŦ (U+0148 U+0166)
  0x01, 0x48, 0x01, 0x74, 0x02, // ňŴ (U+0148 U+0174)
  0x01, 0x48, 0x01, 0x76, 0x02, // ňŶ (U+0148 U+0176)
  0x01, 0x48, 0x01, 0x77, 0x01, // ňŷ (U+0148 U+0177)
  0x01, 0x48, 0x01, 0x78, 0x02, // ňŸ (U+0148 U+0178)
  0x01, 0x49, 0x00, 0x22, 0x02, // ŉ" (U+0149 U+0022)
  0x01, 0x49, 0x00, 0x27, 0x02, // ŉ' (U+0149 U+0027)
  0x01, 0x49, 0x00, 0x3F, 0x01, // ŉ? (U+0149 U+003F)
  0x01, 0x49, 0x00, 0x54, 0x01, // ŉT (U+0149 U+0054)
  0x01, 0x49, 0x00, 0x56, 0x02, // ŉV (U+0149 U+0056)
  0x01, 0x49, 0x00, 0x57, 0x02, // ŉW (U+0149 U+0057)
  0x01, 0x49, 0x00, 0x59, 0x02, // ŉY (U+0149 U+0059)
  0x01, 0x49, 0x00, 0x79, 0x01, // ŉy (U+0149 U+0079)
  0x01, 0x49, 0x00, 0xDD, 0x02, // ŉÝ (U+0149 U+00DD)
  0x01, 0x49, 0x00, 0xFD, 0x01, // ŉý (U+0149 U+00FD)
  0x01, 0x49, 0x00, 0xFF, 0x01, // ŉÿ (U+0149 U+00FF)
  0x01, 0x49, 0x01, 0x62, 0x01, // ŉŢ (U+0149 U+0162)
  0x01, 0x49, 0x01, 0x64, 0x01, // ŉŤ (U+0149 U+0164)
  0x01, 0x49, 0x01, 0x66, 0x01, // ŉŦ (U+0149 U+0166)
  0x01, 0x49, 0x01, 0x74, 0x02, // ŉŴ (U+0149 U+0174)
  0x01, 0x49, 0x01, 0x76, 0x02, // ŉŶ (U+0149 U+0176)
  0x01, 0x49, 0x01, 0x77, 0x01, // ŉŷ (U+0149 U+0177)
  0x01, 0x49, 0x01, 0x78, 0x02, // ŉŸ (U+0149 U+0178)
  0x01, 0x4B, 0x00, 0x22, 0x02, // ŋ" (U+014B U+0022)
  0x01, 0x4B, 0x00, 0x27, 0x02, // ŋ' (U+014B U+0027)
  0x01, 0x4B, 0x00, 0x3F, 0x01, // ŋ? (U+014B U+003F)
  0x01, 0x4B, 0x00, 0x54, 0x01, // ŋT (U+014B U+0054)
  0x01, 0x4B, 0x00, 0x56, 0x02, // ŋV (U+014B U+0056)
  0x01, 0x4B, 0x00, 0x57, 0x02, // ŋW (U+014B U+0057)
  0x01, 0x4B, 0x00, 0x59, 0x02, // ŋY (U+014B U+0059)
  0x01, 0x4B, 0x00, 0x79, 0x01, // ŋy (U+014B U+0079)
  0x01, 0x4B, 0x00, 0xDD, 0x02, // ŋÝ (U+014B U+00DD)
  0x01, 0x4B, 0x00, 0xFD, 0x01, // ŋý (U+014B U+00FD)
  0x01, 0x4B, 0x00, 0xFF, 0x01, // ŋÿ (U+014B U+00FF)
  0x01, 0x4B, 0x01, 0x62, 0x01, // ŋŢ (U+014B U+0162)
  0x01, 0x4B, 0x01, 0x64, 0x01, // ŋŤ (U+014B U+0164)
  0x01, 0x4B, 0x01, 0x66, 0x01, // ŋŦ (U+014B U+0166)
  0x01, 0x4B, 0x01, 0x74, 0x02, // ŋŴ (U+014B U+0174)
  0x01, 0x4B, 0x01, 0x76, 0x02, // ŋŶ (U+014B U+0176)
  0x01, 0x4B, 0x01, 0x77, 0x01, // ŋŷ (U+014B U+0177)
  0x01, 0x4B, 0x01, 0x78, 0x02, // ŋŸ (U+014B U+0178)
  0x01, 0x4C, 0x00, 0x2C, 0x01, // Ō, (U+014C U+002C)
  0x01, 0x4C, 0x00, 0x2E, 0x01, // Ō. (U+014C U+002E)
  0x01, 0x4C, 0x00, 0x3F, 0x01, // Ō? (U+014C U+003F)
  0x01, 0x4C, 0x00, 0x41, 0x01, // ŌA (U+014C U+0041)
  0x01, 0x4C, 0x00, 0x54, 0x01, // ŌT (U+014C U+0054)
  0x01, 0x4C, 0x00, 0x56, 0x01, // ŌV (U+014C U+0056)
  0x01, 0x4C, 0x00, 0x57, 0x01, // ŌW (U+014C U+0057)
  0x01, 0x4C, 0x00, 0x58, 0x01, // ŌX (U+014C U+0058)
  0x01, 0x4C, 0x00, 0x59, 0x02, // ŌY (U+014C U+0059)
  0x01, 0x4C, 0x00, 0xC0, 0x01, // ŌÀ (U+014C U+00C0)
  0x01, 0x4C, 0x00, 0xC1, 0x01, // ŌÁ (U+014C U+00C1)
  0x01, 0x4C, 0x00, 0xC2, 0x01, // ŌÂ (U+014C U+00C2)
  0x01, 0x4C, 0x00, 0xC3, 0x01, // ŌÃ (U+014C U+00C3)
  0x01, 0x4C, 0x00, 0xC4, 0x01, // ŌÄ (U+014C U+00C4)
  0x01, 0x4C, 0x00, 0xC5, 0x01, // ŌÅ (U+014C U+00C5)
  0x01, 0x4C, 0x00, 0xC6, 0x03, // ŌÆ (U+014C U+00C6)
  0x01, 0x4C, 0x00, 0xDD, 0x02, // ŌÝ (U+014C U+00DD)
  0x01, 0x4C, 0x01, 0x00, 0x01, // ŌĀ (U+014C U+0100)
  0x01, 0x4C, 0x01, 0x02, 0x01, // ŌĂ (U+014C U+0102)
  0x01, 0x4C, 0x01, 0x04, 0x01, // ŌĄ (U+014C U+0104)
  0x01, 0x4C, 0x01, 0x62, 0x01, // ŌŢ (U+014C U+0162)
  0x01, 0x4C, 0x01, 0x64, 0x01, // ŌŤ (U+014C U+0164)
  0x01, 0x4C, 0x01, 0x66, 0x01, // ŌŦ (U+014C U+0166)
  0x01, 0x4C, 0x01, 0x74, 0x01, // ŌŴ (U+014C U+0174)
  0x01, 0x4C, 0x01, 0x76, 0x02, // ŌŶ (U+014C U+0176)
  0x01, 0x4C, 0x01, 0x78, 0x02, // ŌŸ (U+014C U+0178)
  0x01, 0x4C, 0x20, 0x1A, 0x01, // Ō‚ (U+014C U+201A)
  0x01, 0x4C, 0x20, 0x1E, 0x01, // Ō„ (U+014C U+201E)
  0x01, 0x4C, 0x20, 0x26, 0x01, // Ō… (U+014C U+2026)
  0x01, 0x4D, 0x00, 0x3F, 0x01, // ō? (U+014D U+003F)
  0x01, 0x4D, 0x00, 0x41, 0x01, // ōA (U+014D U+0041)
  0x01, 0x4D, 0x00, 0x54, 0x01, // ōT (U+014D U+0054)
  0x01, 0x4D, 0x00, 0x56, 0x02, // ōV (U+014D U+0056)
  0x01, 0x4D, 0x00, 0x57, 0x02, // ōW (U+014D U+0057)
  0x01, 0x4D, 0x00, 0x59, 0x03, // ōY (U+014D U+0059)
  0x01, 0x4D, 0x00, 0x79, 0x01, // ōy (U+014D U+0079)
  0x01, 0x4D, 0x00, 0xC0, 0x01, // ōÀ (U+014D U+00C0)
  0x01, 0x4D, 0x00, 0xC1, 0x01, // ōÁ (U+014D U+00C1)
  0x01, 0x4D, 0x00, 0xC2, 0x01, // ōÂ (U+014D U+00C2)
  0x01, 0x4D, 0x00, 0xC3, 0x01, // ōÃ (U+014D U+00C3)
  0x01, 0x4D, 0x00, 0xC4, 0x01, // ōÄ (U+014D U+00C4)
  0x01, 0x4D, 0x00, 0xC5, 0x01, // ōÅ (U+014D U+00C5)
  0x01, 0x4D, 0x00, 0xDD, 0x03, // ōÝ (U+014D U+00DD)
  0x01, 0x4D, 0x00, 0xFD, 0x01, // ōý (U+014D U+00FD)
  0x01, 0x4D, 0x00, 0xFF, 0x01, // ōÿ (U+014D U+00FF)
  0x01, 0x4D, 0x01, 0x00, 0x01, // ōĀ (U+014D U+0100)
  0x01, 0x4D, 0x01, 0x02, 0x01, // ōĂ (U+014D U+0102)
  0x01, 0x4D, 0x01, 0x04, 0x01, // ōĄ (U+014D U+0104)
  0x01, 0x4D, 0x01, 0x62, 0x01, // ōŢ (U+014D U+0162)
  0x01, 0x4D, 0x01, 0x64, 0x01, // ōŤ (U+014D U+0164)
  0x01, 0x4D, 0x01, 0x66, 0x01, // ōŦ (U+014D U+0166)
  0x01, 0x4D, 0x01, 0x74, 0x02, // ōŴ (U+014D U+0174)
  0x01, 0x4D, 0x01, 0x76, 0x03, // ōŶ (U+014D U+0176)
  0x01, 0x4D, 0x01, 0x77, 0x01, // ōŷ (U+014D U+0177)
  0x01, 0x4D, 0x01, 0x78, 0x03, // ōŸ (U+014D U+0178)
  0x01, 0x4E, 0x00, 0x2C, 0x01, // Ŏ, (U+014E U+002C)
  0x01, 0x4E, 0x00, 0x2E, 0x01, // Ŏ. (U+014E U+002E)
  0x01, 0x4E, 0x00, 0x3F, 0x01, // Ŏ? (U+014E U+003F)
  0x01, 0x4E, 0x00, 0x41, 0x01, // ŎA (U+014E U+0041)
  0x01, 0x4E, 0x00, 0x54, 0x01, // ŎT (U+014E U+0054)
  0x01, 0x4E, 0x00, 0x56, 0x01, // ŎV (U+014E U+0056)
  0x01, 0x4E, 0x00, 0x57, 0x01, // ŎW (U+014E U+0057)
  0x01, 0x4E, 0x00, 0x58, 0x01, // ŎX (U+014E U+0058)
  0x01, 0x4E, 0x00, 0x59, 0x02, // ŎY (U+014E U+0059)
  0x01, 0x4E, 0x00, 0xC0, 0x01, // ŎÀ (U+014E U+00C0)
  0x01, 0x4E, 0x00, 0xC1, 0x01, // ŎÁ (U+014E U+00C1)
  0x01, 0x4E, 0x00, 0xC2, 0x01, // ŎÂ (U+014E U+00C2)
  0x01, 0x4E, 0x00, 0xC3, 0x01, // ŎÃ (U+014E U+00C3)
  0x01, 0x4E, 0x00, 0xC4, 0x01, // ŎÄ (U+014E U+00C4)
  0x01, 0x4E, 0x00, 0xC5, 0x01, // ŎÅ (U+014E U+00C5)
  0x01, 0x4E, 0x00, 0xC6, 0x03, // ŎÆ (U+014E U+00C6)
  0x01, 0x4E, 0x00, 0xDD, 0x02, // ŎÝ (U+014E U+00DD)
  0x01, 0x4E, 0x01, 0x00, 0x01, // ŎĀ (U+014E U+0100)
  0x01, 0x4E, 0x01, 0x02, 0x01, // ŎĂ (U+014E U+0102)
  0x01, 0x4E, 0x01, 0x04, 0x01, // ŎĄ (U+014E U+0104)
  0x01, 0x4E, 0x01, 0x62, 0x01, // ŎŢ (U+014E U+0162)
  0x01, 0x4E, 0x01, 0x64, 0x01, // ŎŤ (U+014E U+0164)
  0x01, 0x4E, 0x01, 0x66, 0x01, // ŎŦ (U+014E U+0166)
  0x01, 0x4E, 0x01, 0x74, 0x01, // ŎŴ (U+014E U+0174)
  0x01, 0x4E, 0x01, 0x76, 0x02, // ŎŶ (U+014E U+0176)
  0x01, 0x4E, 0x01, 0x78, 0x02, // ŎŸ (U+014E U+0178)
  0x01, 0x4E, 0x20, 0x1A, 0x01, // Ŏ‚ (U+014E U+201A)
  0x01, 0x4E, 0x20, 0x1E, 0x01, // Ŏ„ (U+014E U+201E)
  0x01, 0x4E, 0x20, 0x26, 0x01, // Ŏ… (U+014E U+2026)
  0x01, 0x4F, 0x00, 0x3F, 0x01, // ŏ? (U+014F U+003F)
  0x01, 0x4F, 0x00, 0x41, 0x01, // ŏA (U+014F U+0041)
  0x01, 0x4F, 0x00, 0x54, 0x01, // ŏT (U+014F U+0054)
  0x01, 0x4F, 0x00, 0x56, 0x02, // ŏV (U+014F U+0056)
  0x01, 0x4F, 0x00, 0x57, 0x02, // ŏW (U+014F U+0057)
  0x01, 0x4F, 0x00, 0x59, 0x03, // ŏY (U+014F U+0059)
  0x01, 0x4F, 0x00, 0x79, 0x01, // ŏy (U+014F U+0079)
  0x01, 0x4F, 0x00, 0xC0, 0x01, // ŏÀ (U+014F U+00C0)
  0x01, 0x4F, 0x00, 0xC1, 0x01, // ŏÁ (U+014F U+00C1)
  0x01, 0x4F, 0x00, 0xC2, 0x01, // ŏÂ (U+014F U+00C2)
  0x01, 0x4F, 0x00, 0xC3, 0x01, // ŏÃ (U+014F U+00C3)
  0x01, 0x4F, 0x00, 0xC4, 0x01, // ŏÄ (U+014F U+00C4)
  0x01, 0x4F, 0x00, 0xC5, 0x01, // ŏÅ (U+014F U+00C5)
  0x01, 0x4F, 0x00, 0xDD, 0x03, // ŏÝ (U+014F U+00DD)
  0x01, 0x4F, 0x00, 0xFD, 0x01, // ŏý (U+014F U+00FD)
  0x01, 0x4F, 0x00, 0xFF, 0x01, // ŏÿ (U+014F U+00FF)
  0x01, 0x4F, 0x01, 0x00, 0x01, // ŏĀ (U+014F U+0100)
  0x01, 0x4F, 0x01, 0x02, 0x01, // ŏĂ (U+014F U+0102)
  0x01, 0x4F, 0x01, 0x04, 0x01, // ŏĄ (U+014F U+0104)
  0x01, 0x4F, 0x01, 0x62, 0x01, // ŏŢ (U+014F U+0162)
  0x01, 0x4F, 0x01, 0x64, 0x01, // ŏŤ (U+014F U+0164)
  0x01, 0x4F, 0x01, 0x66, 0x01, // ŏŦ (U+014F U+0166)
  0x01, 0x4F, 0x01, 0x74, 0x02, // ŏŴ (U+014F U+0174)
  0x01, 0x4F, 0x01, 0x76, 0x03, // ŏŶ (U+014F U+0176)
  0x01, 0x4F, 0x01, 0x77, 0x01, // ŏŷ (U+014F U+0177)
  0x01, 0x4F, 0x01, 0x78, 0x03, // ŏŸ (U+014F U+0178)
  0x01, 0x50, 0x00, 0x2C, 0x01, // Ő, (U+0150 U+002C)
  0x01, 0x50, 0x00, 0x2E, 0x01, // Ő. (U+0150 U+002E)
  0x01, 0x50, 0x00, 0x3F, 0x01, // Ő? (U+0150 U+003F)
  0x01, 0x50, 0x00, 0x41, 0x01, // ŐA (U+0150 U+0041)
  0x01, 0x50, 0x00, 0x54, 0x01, // ŐT (U+0150 U+0054)
  0x01, 0x50, 0x00, 0x56, 0x01, // ŐV (U+0150 U+0056)
  0x01, 0x50, 0x00, 0x57, 0x01, // ŐW (U+0150 U+0057)
  0x01, 0x50, 0x00, 0x58, 0x01, // ŐX (U+0150 U+0058)
  0x01, 0x50, 0x00, 0x59, 0x02, // ŐY (U+0150 U+0059)
  0x01, 0x50, 0x00, 0xC0, 0x01, // ŐÀ (U+0150 U+00C0)
  0x01, 0x50, 0x00, 0xC1, 0x01, // ŐÁ (U+0150 U+00C1)
  0x01, 0x50, 0x00, 0xC2, 0x01, // ŐÂ (U+0150 U+00C2)
  0x01, 0x50, 0x00, 0xC3, 0x01, // ŐÃ (U+0150 U+00C3)
  0x01, 0x50, 0x00, 0xC4, 0x01, // ŐÄ (U+0150 U+00C4)
  0x01, 0x50, 0x00, 0xC5, 0x01, // ŐÅ (U+0150 U+00C5)
  0x01, 0x50, 0x00, 0xC6, 0x03, // ŐÆ (U+0150 U+00C6)
  0x01, 0x50, 0x00, 0xDD, 0x02, // ŐÝ (U+0150 U+00DD)
  0x01, 0x50, 0x01, 0x00, 0x01, // ŐĀ (U+0150 U+0100)
  0x01, 0x50, 0x01, 0x02, 0x01, // ŐĂ (U+0150 U+0102)
  0x01, 0x50, 0x01, 0x04, 0x01, // ŐĄ (U+0150 U+0104)
  0x01, 0x50, 0x01, 0x62, 0x01, // ŐŢ (U+0150 U+0162)
  0x01, 0x50, 0x01, 0x64, 0x01, // ŐŤ (U+0150 U+0164)
  0x01, 0x50, 0x01, 0x66, 0x01, // ŐŦ (U+0150 U+0166)
  0x01, 0x50, 0x01, 0x74, 0x01, // ŐŴ (U+0150 U+0174)
  0x01, 0x50, 0x01, 0x76, 0x02, // ŐŶ (U+0150 U+0176)
  0x01, 0x50, 0x01, 0x78, 0x02, // ŐŸ (U+0150 U+0178)
  0x01, 0x50, 0x20, 0x1A, 0x01, // Ő‚ (U+0150 U+201A)
  0x01, 0x50, 0x20, 0x1E, 0x01, // Ő„ (U+0150 U+201E)
  0x01, 0x50, 0x20, 0x26, 0x01, // Ő… (U+0150 U+2026)
  0x01, 0x51, 0x00, 0x3F, 0x01, // ő? (U+0151 U+003F)
  0x01, 0x51, 0x00, 0x41, 0x01, // őA (U+0151 U+0041)
  0x01, 0x51, 0x00, 0x54, 0x01, // őT (U+0151 U+0054)
  0x01, 0x51, 0x00, 0x56, 0x02, // őV (U+0151 U+0056)
  0x01, 0x51, 0x00, 0x57, 0x02, // őW (U+0151 U+0057)
  0x01, 0x51, 0x00, 0x59, 0x03, // őY (U+0151 U+0059)
  0x01, 0x51, 0x00, 0x79, 0x01, // őy (U+0151 U+0079)
  0x01, 0x51, 0x00, 0xC0, 0x01, // őÀ (U+0151 U+00C0)
  0x01, 0x51, 0x00, 0xC1, 0x01, // őÁ (U+0151 U+00C1)
  0x01, 0x51, 0x00, 0xC2, 0x01, // őÂ (U+0151 U+00C2)
  0x01, 0x51, 0x00, 0xC3, 0x01, // őÃ (U+0151 U+00C3)
  0x01, 0x51, 0x00, 0xC4, 0x01, // őÄ (U+0151 U+00C4)
  0x01, 0x51, 0x00, 0xC5, 0x01, // őÅ (U+0151 U+00C5)
  0x01, 0x51, 0x00, 0xDD, 0x03, // őÝ (U+0151 U+00DD)
  0x01, 0x51, 0x00, 0xFD, 0x01, // őý (U+0151 U+00FD)
  0x01, 0x51, 0x00, 0xFF, 0x01, // őÿ (U+0151 U+00FF)
  0x01, 0x51, 0x01, 0x00, 0x01, // őĀ (U+0151 U+0100)
  0x01, 0x51, 0x01, 0x02, 0x01, // őĂ (U+0151 U+0102)
  0x01, 0x51, 0x01, 0x04, 0x01, // őĄ (U+0151 U+0104)
  0x01, 0x51, 0x01, 0x62, 0x01, // őŢ (U+0151 U+0162)
  0x01, 0x51, 0x01, 0x64, 0x01, // őŤ (U+0151 U+0164)
  0x01, 0x51, 0x01, 0x66, 0x01, // őŦ (U+0151 U+0166)
  0x01, 0x51, 0x01, 0x74, 0x02, // őŴ (U+0151 U+0174)
  0x01, 0x51, 0x01, 0x76, 0x03, // őŶ (U+0151 U+0176)
  0x01, 0x51, 0x01, 0x77, 0x01, // őŷ (U+0151 U+0177)
  0x01, 0x51, 0x01, 0x78, 0x03, // őŸ (U+0151 U+0178)
  0x01, 0x52, 0x00, 0x56, 0x01, // ŒV (U+0152 U+0056)
  0x01, 0x52, 0x00, 0x57, 0x01, // ŒW (U+0152 U+0057)
  0x01, 0x52, 0x00, 0x59, 0x01, // ŒY (U+0152 U+0059)
  0x01, 0x52, 0x00, 0xDD, 0x01, // ŒÝ (U+0152 U+00DD)
  0x01, 0x52, 0x01, 0x74, 0x01, // ŒŴ (U+0152 U+0174)
  0x01, 0x52, 0x01, 0x76, 0x01, // ŒŶ (U+0152 U+0176)
  0x01, 0x52, 0x01, 0x78, 0x01, // ŒŸ (U+0152 U+0178)
  0x01, 0x53, 0x00, 0x56, 0x02, // œV (U+0153 U+0056)
  0x01, 0x53, 0x00, 0x57, 0x02, // œW (U+0153 U+0057)
  0x01, 0x53, 0x00, 0x59, 0x03, // œY (U+0153 U+0059)
  0x01, 0x53, 0x00, 0xDD, 0x03, // œÝ (U+0153 U+00DD)
  0x01, 0x53, 0x01, 0x74, 0x02, // œŴ (U+0153 U+0174)
  0x01, 0x53, 0x01, 0x76, 0x03, // œŶ (U+0153 U+0176)
  0x01, 0x53, 0x01, 0x78, 0x03, // œŸ (U+0153 U+0178)
  0x01, 0x54, 0x00, 0x2A, 0x01, // Ŕ* (U+0154 U+002A)
  0x01, 0x54, 0x00, 0x3F, 0x01, // Ŕ? (U+0154 U+003F)
  0x01, 0x54, 0x00, 0x43, 0x01, // ŔC (U+0154 U+0043)
  0x01, 0x54, 0x00, 0x47, 0x01, // ŔG (U+0154 U+0047)
  0x01, 0x54, 0x00, 0x4F, 0x01, // ŔO (U+0154 U+004F)
  0x01, 0x54, 0x00, 0x51, 0x01, // ŔQ (U+0154 U+0051)
  0x01, 0x54, 0x00, 0x54, 0x01, // ŔT (U+0154 U+0054)
  0x01, 0x54, 0x00, 0x56, 0x01, // ŔV (U+0154 U+0056)
  0x01, 0x54, 0x00, 0x57, 0x01, // ŔW (U+0154 U+0057)
  0x01, 0x54, 0x00, 0x59, 0x01, // ŔY (U+0154 U+0059)
  0x01, 0x54, 0x00, 0x76, 0x01, // Ŕv (U+0154 U+0076)
  0x01, 0x54, 0x00, 0x77, 0x01, // Ŕw (U+0154 U+0077)
  0x01, 0x54, 0x00, 0x79, 0x01, // Ŕy (U+0154 U+0079)
  0x01, 0x54, 0x00, 0xC7, 0x01, // ŔÇ (U+0154 U+00C7)
  0x01, 0x54, 0x00, 0xD2, 0x01, // ŔÒ (U+0154 U+00D2)
  0x01, 0x54, 0x00, 0xD3, 0x01, // ŔÓ (U+0154 U+00D3)
  0x01, 0x54, 0x00, 0xD4, 0x01, // ŔÔ (U+0154 U+00D4)
  0x01, 0x54, 0x00, 0xD5, 0x01, // ŔÕ (U+0154 U+00D5)
  0x01, 0x54, 0x00, 0xD6, 0x01, // ŔÖ (U+0154 U+00D6)
  0x01, 0x54, 0x00, 0xD8, 0x01, // ŔØ (U+0154 U+00D8)
  0x01, 0x54, 0x00, 0xDD, 0x01, // ŔÝ (U+0154 U+00DD)
  0x01, 0x54, 0x00, 0xFD, 0x01, // Ŕý (U+0154 U+00FD)
  0x01, 0x54, 0x00, 0xFF, 0x01, // Ŕÿ (U+0154 U+00FF)
  0x01, 0x54, 0x01, 0x06, 0x01, // ŔĆ (U+0154 U+0106)
  0x01, 0x54, 0x01, 0x08, 0x01, // ŔĈ (U+0154 U+0108)
  0x01, 0x54, 0x01, 0x0A, 0x01, // ŔĊ (U+0154 U+010A)
  0x01, 0x54, 0x01, 0x0C, 0x01, // ŔČ (U+0154 U+010C)
  0x01, 0x54, 0x01, 0x1C, 0x01, // ŔĜ (U+0154 U+011C)
  0x01, 0x54, 0x01, 0x1E, 0x01, // ŔĞ (U+0154 U+011E)
  0x01, 0x54, 0x01, 0x20, 0x01, // ŔĠ (U+0154 U+0120)
  0x01, 0x54, 0x01, 0x22, 0x01, // ŔĢ (U+0154 U+0122)
  0x01, 0x54, 0x01, 0x4C, 0x01, // ŔŌ (U+0154 U+014C)
  0x01, 0x54, 0x01, 0x4E, 0x01, // ŔŎ (U+0154 U+014E)
  0x01, 0x54, 0x01, 0x50, 0x01, // ŔŐ (U+0154 U+0150)
  0x01, 0x54, 0x01, 0x52, 0x01, // ŔŒ (U+0154 U+0152)
  0x01, 0x54, 0x01, 0x62, 0x01, // ŔŢ (U+0154 U+0162)
  0x01, 0x54, 0x01, 0x64, 0x01, // ŔŤ (U+0154 U+0164)
  0x01, 0x54, 0x01, 0x66, 0x01, // ŔŦ (U+0154 U+0166)
  0x01, 0x54, 0x01, 0x74, 0x01, // ŔŴ (U+0154 U+0174)
  0x01, 0x54, 0x01, 0x75, 0x01, // Ŕŵ (U+0154 U+0175)
  0x01, 0x54, 0x01, 0x76, 0x01, // ŔŶ (U+0154 U+0176)
  0x01, 0x54, 0x01, 0x77, 0x01, // Ŕŷ (U+0154 U+0177)
  0x01, 0x54, 0x01, 0x78, 0x01, // ŔŸ (U+0154 U+0178)
  0x01, 0x54, 0x20, 0x19, 0x01, // Ŕ’ (U+0154 U+2019)
  0x01, 0x54, 0x20, 0x1D, 0x01, // Ŕ” (U+0154 U+201D)
  0x01, 0x54, 0x21, 0x22, 0x01, // Ŕ™ (U+0154 U+2122)
  0x01, 0x55, 0x00, 0x2C, 0x07, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x07, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x00, 0x41, 0x01, // ŕA (U+0155 U+0041)
  0x01, 0x55, 0x00, 0x58, 0x01, // ŕX (U+0155 U+0058)
  0x01, 0x55, 0x00, 0x61, 0x01, // ŕa (U+0155 U+0061)
  0x01, 0x55, 0x00, 0xC0, 0x01, // ŕÀ (U+0155 U+00C0)
  0x01, 0x55, 0x00, 0xC1, 0x01, // ŕÁ (U+0155 U+00C1)
  0x01, 0x55, 0x00, 0xC2, 0x01, // ŕÂ (U+0155 U+00C2)
  0x01, 0x55, 0x00, 0xC3, 0x01, // ŕÃ (U+0155 U+00C3)
  0x01, 0x55, 0x00, 0xC4, 0x01, // ŕÄ (U+0155 U+00C4)
  0x01, 0x55, 0x00, 0xC5, 0x01, // ŕÅ (U+0155 U+00C5)
  0x01, 0x55, 0x00, 0xE0, 0x01, // ŕà (U+0155 U+00E0)
  0x01, 0x55, 0x00, 0xE1, 0x01, // ŕá (U+0155 U+00E1)
  0x01, 0x55, 0x00, 0xE2, 0x01, // ŕâ (U+0155 U+00E2)
  0x01, 0x55, 0x00, 0xE3, 0x01, // ŕã (U+0155 U+00E3)
  0x01, 0x55, 0x00, 0xE4, 0x01, // ŕä (U+0155 U+00E4)
  0x01, 0x55, 0x00, 0xE5, 0x01, // ŕå (U+0155 U+00E5)
  0x01, 0x55, 0x00, 0xE6, 0x01, // ŕæ (U+0155 U+00E6)
  0x01, 0x55, 0x01, 0x00, 0x01, // ŕĀ (U+0155 U+0100)
  0x01, 0x55, 0x01, 0x01, 0x01, // ŕā (U+0155 U+0101)
  0x01, 0x55, 0x01, 0x02, 0x01, // ŕĂ (U+0155 U+0102)
  0x01, 0x55, 0x01, 0x03, 0x01, // ŕă (U+0155 U+0103)
  0x01, 0x55, 0x01, 0x04, 0x01, // ŕĄ (U+0155 U+0104)
  0x01, 0x55, 0x01, 0x05, 0x01, // ŕą (U+0155 U+0105)
  0x01, 0x55, 0x20, 0x1A, 0x07, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x07, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x07, // ŕ… (U+0155 U+2026)
  0x01, 0x56, 0x00, 0x2A, 0x01, // Ŗ* (U+0156 U+002A)
  0x01, 0x56, 0x00, 0x3F, 0x01, // Ŗ? (U+0156 U+003F)
  0x01, 0x56, 0x00, 0x43, 0x01, // ŖC (U+0156 U+0043)
  0x01, 0x56, 0x00, 0x47, 0x01, // ŖG (U+0156 U+0047)
  0x01, 0x56, 0x00, 0x4F, 0x01, // ŖO (U+0156 U+004F)
  0x01, 0x56, 0x00, 0x51, 0x01, // ŖQ (U+0156 U+0051)
  0x01, 0x56, 0x00, 0x54, 0x01, // ŖT (U+0156 U+0054)
  0x01, 0x56, 0x00, 0x56, 0x01, // ŖV (U+0156 U+0056)
  0x01, 0x56, 0x00, 0x57, 0x01, // ŖW (U+0156 U+0057)
  0x01, 0x56, 0x00, 0x59, 0x01, // ŖY (U+0156 U+0059)
  0x01, 0x56, 0x00, 0x76, 0x01, // Ŗv (U+0156 U+0076)
  0x01, 0x56, 0x00, 0x77, 0x01, // Ŗw (U+0156 U+0077)
  0x01, 0x56, 0x00, 0x79, 0x01, // Ŗy (U+0156 U+0079)
  0x01, 0x56, 0x00, 0xC7, 0x01, // ŖÇ (U+0156 U+00C7)
  0x01, 0x56, 0x00, 0xD2, 0x01, // ŖÒ (U+0156 U+00D2)
  0x01, 0x56, 0x00, 0xD3, 0x01, // ŖÓ (U+0156 U+00D3)
  0x01, 0x56, 0x00, 0xD4, 0x01, // ŖÔ (U+0156 U+00D4)
  0x01, 0x56, 0x00, 0xD5, 0x01, // ŖÕ (U+0156 U+00D5)
  0x01, 0x56, 0x00, 0xD6, 0x01, // ŖÖ (U+0156 U+00D6)
  0x01, 0x56, 0x00, 0xD8, 0x01, // ŖØ (U+0156 U+00D8)
  0x01, 0x56, 0x00, 0xDD, 0x01, // ŖÝ (U+0156 U+00DD)
  0x01, 0x56, 0x00, 0xFD, 0x01, // Ŗý (U+0156 U+00FD)
  0x01, 0x56, 0x00, 0xFF, 0x01, // Ŗÿ (U+0156 U+00FF)
  0x01, 0x56, 0x01, 0x06, 0x01, // ŖĆ (U+0156 U+0106)
  0x01, 0x56, 0x01, 0x08, 0x01, // ŖĈ (U+0156 U+0108)
  0x01, 0x56, 0x01, 0x0A, 0x01, // ŖĊ (U+0156 U+010A)
  0x01, 0x56, 0x01, 0x0C, 0x01, // ŖČ (U+0156 U+010C)
  0x01, 0x56, 0x01, 0x1C, 0x01, // ŖĜ (U+0156 U+011C)
  0x01, 0x56, 0x01, 0x1E, 0x01, // ŖĞ (U+0156 U+011E)
  0x01, 0x56, 0x01, 0x20, 0x01, // ŖĠ (U+0156 U+0120)
  0x01, 0x56, 0x01, 0x22, 0x01, // ŖĢ (U+0156 U+0122)
  0x01, 0x56, 0x01, 0x4C, 0x01, // ŖŌ (U+0156 U+014C)
  0x01, 0x56, 0x01, 0x4E, 0x01, // ŖŎ (U+0156 U+014E)
  0x01, 0x56, 0x01, 0x50, 0x01, // ŖŐ (U+0156 U+0150)
  0x01, 0x56, 0x01, 0x52, 0x01, // ŖŒ (U+0156 U+0152)
  0x01, 0x56, 0x01, 0x62, 0x01, // ŖŢ (U+0156 U+0162)
  0x01, 0x56, 0x01, 0x64, 0x01, // ŖŤ (U+0156 U+0164)
  0x01, 0x56, 0x01, 0x66, 0x01, // ŖŦ (U+0156 U+0166)
  0x01, 0x56, 0x01, 0x74, 0x01, // ŖŴ (U+0156 U+0174)
  0x01, 0x56, 0x01, 0x75, 0x01, // Ŗŵ (U+0156 U+0175)
  0x01, 0x56, 0x01, 0x76, 0x01, // ŖŶ (U+0156 U+0176)
  0x01, 0x56, 0x01, 0x77, 0x01, // Ŗŷ (U+0156 U+0177)
  0x01, 0x56, 0x01, 0x78, 0x01, // ŖŸ (U+0156 U+0178)
  0x01, 0x56, 0x20, 0x19, 0x01, // Ŗ’ (U+0156 U+2019)
  0x01, 0x56, 0x20, 0x1D, 0x01, // Ŗ” (U+0156 U+201D)
  0x01, 0x56, 0x21, 0x22, 0x01, // Ŗ™ (U+0156 U+2122)
  0x01, 0x57, 0x00, 0x2C, 0x07, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x07, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x00, 0x41, 0x01, // ŗA (U+0157 U+0041)
  0x01, 0x57, 0x00, 0x58, 0x01, // ŗX (U+0157 U+0058)
  0x01, 0x57, 0x00, 0x61, 0x01, // ŗa (U+0157 U+0061)
  0x01, 0x57, 0x00, 0xC0, 0x01, // ŗÀ (U+0157 U+00C0)
  0x01, 0x57, 0x00, 0xC1, 0x01, // ŗÁ (U+0157 U+00C1)
  0x01, 0x57, 0x00, 0xC2, 0x01, // ŗÂ (U+0157 U+00C2)
  0x01, 0x57, 0x00, 0xC3, 0x01, // ŗÃ (U+0157 U+00C3)
  0x01, 0x57, 0x00, 0xC4, 0x01, // ŗÄ (U+0157 U+00C4)
  0x01, 0x57, 0x00, 0xC5, 0x01, // ŗÅ (U+0157 U+00C5)
  0x01, 0x57, 0x00, 0xE0, 0x01, // ŗà (U+0157 U+00E0)
  0x01, 0x57, 0x00, 0xE1, 0x01, // ŗá (U+0157 U+00E1)
  0x01, 0x57, 0x00, 0xE2, 0x01, // ŗâ (U+0157 U+00E2)
  0x01, 0x57, 0x00, 0xE3, 0x01, // ŗã (U+0157 U+00E3)
  0x01, 0x57, 0x00, 0xE4, 0x01, // ŗä (U+0157 U+00E4)
  0x01, 0x57, 0x00, 0xE5, 0x01, // ŗå (U+0157 U+00E5)
  0x01, 0x57, 0x00, 0xE6, 0x01, // ŗæ (U+0157 U+00E6)
  0x01, 0x57, 0x01, 0x00, 0x01, // ŗĀ (U+0157 U+0100)
  0x01, 0x57, 0x01, 0x01, 0x01, // ŗā (U+0157 U+0101)
  0x01, 0x57, 0x01, 0x02, 0x01, // ŗĂ (U+0157 U+0102)
  0x01, 0x57, 0x01, 0x03, 0x01, // ŗă (U+0157 U+0103)
  0x01, 0x57, 0x01, 0x04, 0x01, // ŗĄ (U+0157 U+0104)
  0x01, 0x57, 0x01, 0x05, 0x01, // ŗą (U+0157 U+0105)
  0x01, 0x57, 0x20, 0x1A, 0x07, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x07, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x07, // ŗ… (U+0157 U+2026)
  0x01, 0x58, 0x00, 0x2A, 0x01, // Ř* (U+0158 U+002A)
  0x01, 0x58, 0x00, 0x3F, 0x01, // Ř? (U+0158 U+003F)
  0x01, 0x58, 0x00, 0x43, 0x01, // ŘC (U+0158 U+0043)
  0x01, 0x58, 0x00, 0x47, 0x01, // ŘG (U+0158 U+0047)
  0x01, 0x58, 0x00, 0x4F, 0x01, // ŘO (U+0158 U+004F)
  0x01, 0x58, 0x00, 0x51, 0x01, // ŘQ (U+0158 U+0051)
  0x01, 0x58, 0x00, 0x54, 0x01, // ŘT (U+0158 U+0054)
  0x01, 0x58, 0x00, 0x56, 0x01, // ŘV (U+0158 U+0056)
  0x01, 0x58, 0x00, 0x57, 0x01, // ŘW (U+0158 U+0057)
  0x01, 0x58, 0x00, 0x59, 0x01, // ŘY (U+0158 U+0059)
  0x01, 0x58, 0x00, 0x76, 0x01, // Řv (U+0158 U+0076)
  0x01, 0x58, 0x00, 0x77, 0x01, // Řw (U+0158 U+0077)
  0x01, 0x58, 0x00, 0x79, 0x01, // Řy (U+0158 U+0079)
  0x01, 0x58, 0x00, 0xC7, 0x01, // ŘÇ (U+0158 U+00C7)
  0x01, 0x58, 0x00, 0xD2, 0x01, // ŘÒ (U+0158 U+00D2)
  0x01, 0x58, 0x00, 0xD3, 0x01, // ŘÓ (U+0158 U+00D3)
  0x01, 0x58, 0x00, 0xD4, 0x01, // ŘÔ (U+0158 U+00D4)
  0x01, 0x58, 0x00, 0xD5, 0x01, // ŘÕ (U+0158 U+00D5)
  0x01, 0x58, 0x00, 0xD6, 0x01, // ŘÖ (U+0158 U+00D6)
  0x01, 0x58, 0x00, 0xD8, 0x01, // ŘØ (U+0158 U+00D8)
  0x01, 0x58, 0x00, 0xDD, 0x01, // ŘÝ (U+0158 U+00DD)
  0x01, 0x58, 0x00, 0xFD, 0x01, // Řý (U+0158 U+00FD)
  0x01, 0x58, 0x00, 0xFF, 0x01, // Řÿ (U+0158 U+00FF)
  0x01, 0x58, 0x01, 0x06, 0x01, // ŘĆ (U+0158 U+0106)
  0x01, 0x58, 0x01, 0x08, 0x01, // ŘĈ (U+0158 U+0108)
  0x01, 0x58, 0x01, 0x0A, 0x01, // ŘĊ (U+0158 U+010A)
  0x01, 0x58, 0x01, 0x0C, 0x01, // ŘČ (U+0158 U+010C)
  0x01, 0x58, 0x01, 0x1C, 0x01, // ŘĜ (U+0158 U+011C)
  0x01, 0x58, 0x01, 0x1E, 0x01, // ŘĞ (U+0158 U+011E)
  0x01, 0x58, 0x01, 0x20, 0x01, // ŘĠ (U+0158 U+0120)
  0x01, 0x58, 0x01, 0x22, 0x01, // ŘĢ (U+0158 U+0122)
  0x01, 0x58, 0x01, 0x4C, 0x01, // ŘŌ (U+0158 U+014C)
  0x01, 0x58, 0x01, 0x4E, 0x01, // ŘŎ (U+0158 U+014E)
  0x01, 0x58, 0x01, 0x50, 0x01, // ŘŐ (U+0158 U+0150)
  0x01, 0x58, 0x01, 0x52, 0x01, // ŘŒ (U+0158 U+0152)
  0x01, 0x58, 0x01, 0x62, 0x01, // ŘŢ (U+0158 U+0162)
  0x01, 0x58, 0x01, 0x64, 0x01, // ŘŤ (U+0158 U+0164)
  0x01, 0x58, 0x01, 0x66, 0x01, // ŘŦ (U+0158 U+0166)
  0x01, 0x58, 0x01, 0x74, 0x01, // ŘŴ (U+0158 U+0174)
  0x01, 0x58, 0x01, 0x75, 0x01, // Řŵ (U+0158 U+0175)
  0x01, 0x58, 0x01, 0x76, 0x01, // ŘŶ (U+0158 U+0176)
  0x01, 0x58, 0x01, 0x77, 0x01, // Řŷ (U+0158 U+0177)
  0x01, 0x58, 0x01, 0x78, 0x01, // ŘŸ (U+0158 U+0178)
  0x01, 0x58, 0x20, 0x19, 0x01, // Ř’ (U+0158 U+2019)
  0x01, 0x58, 0x20, 0x1D, 0x01, // Ř” (U+0158 U+201D)
  0x01, 0x58, 0x21, 0x22, 0x01, // Ř™ (U+0158 U+2122)
  0x01, 0x59, 0x00, 0x2C, 0x07, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x07, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x00, 0x41, 0x01, // řA (U+0159 U+0041)
  0x01, 0x59, 0x00, 0x58, 0x01, // řX (U+0159 U+0058)
  0x01, 0x59, 0x00, 0x61, 0x01, // řa (U+0159 U+0061)
  0x01, 0x59, 0x00, 0xC0, 0x01, // řÀ (U+0159 U+00C0)
  0x01, 0x59, 0x00, 0xC1, 0x01, // řÁ (U+0159 U+00C1)
  0x01, 0x59, 0x00, 0xC2, 0x01, // řÂ (U+0159 U+00C2)
  0x01, 0x59, 0x00, 0xC3, 0x01, // řÃ (U+0159 U+00C3)
  0x01, 0x59, 0x00, 0xC4, 0x01, // řÄ (U+0159 U+00C4)
  0x01, 0x59, 0x00, 0xC5, 0x01, // řÅ (U+0159 U+00C5)
  0x01, 0x59, 0x00, 0xE0, 0x01, // řà (U+0159 U+00E0)
  0x01, 0x59, 0x00, 0xE1, 0x01, // řá (U+0159 U+00E1)
  0x01, 0x59, 0x00, 0xE2, 0x01, // řâ (U+0159 U+00E2)
  0x01, 0x59, 0x00, 0xE3, 0x01, // řã (U+0159 U+00E3)
  0x01, 0x59, 0x00, 0xE4, 0x01, // řä (U+0159 U+00E4)
  0x01, 0x59, 0x00, 0xE5, 0x01, // řå (U+0159 U+00E5)
  0x01, 0x59, 0x00, 0xE6, 0x01, // řæ (U+0159 U+00E6)
  0x01, 0x59, 0x01, 0x00, 0x01, // řĀ (U+0159 U+0100)
  0x01, 0x59, 0x01, 0x01, 0x01, // řā (U+0159 U+0101)
  0x01, 0x59, 0x01, 0x02, 0x01, // řĂ (U+0159 U+0102)
  0x01, 0x59, 0x01, 0x03, 0x01, // řă (U+0159 U+0103)
  0x01, 0x59, 0x01, 0x04, 0x01, // řĄ (U+0159 U+0104)
  0x01, 0x59, 0x01, 0x05, 0x01, // řą (U+0159 U+0105)
  0x01, 0x59, 0x20, 0x1A, 0x07, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x07, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x07, // ř… (U+0159 U+2026)
  0x01, 0x5A, 0x00, 0x3F, 0x01, // Ś? (U+015A U+003F)
  0x01, 0x5A, 0x00, 0x41, 0x01, // ŚA (U+015A U+0041)
  0x01, 0x5A, 0x00, 0x54, 0x01, // ŚT (U+015A U+0054)
  0x01, 0x5A, 0x00, 0x56, 0x01, // ŚV (U+015A U+0056)
  0x01, 0x5A, 0x00, 0x57, 0x01, // ŚW (U+015A U+0057)
  0x01, 0x5A, 0x00, 0x58, 0x01, // ŚX (U+015A U+0058)
  0x01, 0x5A, 0x00, 0x59, 0x01, // ŚY (U+015A U+0059)
  0x01, 0x5A, 0x00, 0x77, 0x01, // Św (U+015A U+0077)
  0x01, 0x5A, 0x00, 0x79, 0x01, // Śy (U+015A U+0079)
  0x01, 0x5A, 0x00, 0xC0, 0x01, // ŚÀ (U+015A U+00C0)
  0x01, 0x5A, 0x00, 0xC1, 0x01, // ŚÁ (U+015A U+00C1)
  0x01, 0x5A, 0x00, 0xC2, 0x01, // ŚÂ (U+015A U+00C2)
  0x01, 0x5A, 0x00, 0xC3, 0x01, // ŚÃ (U+015A U+00C3)
  0x01, 0x5A, 0x00, 0xC4, 0x01, // ŚÄ (U+015A U+00C4)
  0x01, 0x5A, 0x00, 0xC5, 0x01, // ŚÅ (U+015A U+00C5)
  0x01, 0x5A, 0x00, 0xC6, 0x01, // ŚÆ (U+015A U+00C6)
  0x01, 0x5A, 0x00, 0xDD, 0x01, // ŚÝ (U+015A U+00DD)
  0x01, 0x5A, 0x00, 0xFD, 0x01, // Śý (U+015A U+00FD)
  0x01, 0x5A, 0x00, 0xFF, 0x01, // Śÿ (U+015A U+00FF)
  0x01, 0x5A, 0x01, 0x00, 0x01, // ŚĀ (U+015A U+0100)
  0x01, 0x5A, 0x01, 0x02, 0x01, // ŚĂ (U+015A U+0102)
  0x01, 0x5A, 0x01, 0x04, 0x01, // ŚĄ (U+015A U+0104)
  0x01, 0x5A, 0x01, 0x62, 0x01, // ŚŢ (U+015A U+0162)
  0x01, 0x5A, 0x01, 0x64, 0x01, // ŚŤ (U+015A U+0164)
  0x01, 0x5A, 0x01, 0x66, 0x01, // ŚŦ (U+015A U+0166)
  0x01, 0x5A, 0x01, 0x74, 0x01, // ŚŴ (U+015A U+0174)
  0x01, 0x5A, 0x01, 0x75, 0x01, // Śŵ (U+015A U+0175)
  0x01, 0x5A, 0x01, 0x76, 0x01, // ŚŶ (U+015A U+0176)
  0x01, 0x5A, 0x01, 0x77, 0x01, // Śŷ (U+015A U+0177)
  0x01, 0x5A, 0x01, 0x78, 0x01, // ŚŸ (U+015A U+0178)
  0x01, 0x5B, 0x00, 0x57, 0x01, // śW (U+015B U+0057)
  0x01, 0x5B, 0x00, 0x59, 0x03, // śY (U+015B U+0059)
  0x01, 0x5B, 0x00, 0xDD, 0x03, // śÝ (U+015B U+00DD)
  0x01, 0x5B, 0x01, 0x74, 0x01, // śŴ (U+015B U+0174)
  0x01, 0x5B, 0x01, 0x76, 0x03, // śŶ (U+015B U+0176)
  0x01, 0x5B, 0x01, 0x78, 0x03, // śŸ (U+015B U+0178)
  0x01, 0x5C, 0x00, 0x3F, 0x01, // Ŝ? (U+015C U+003F)
  0x01, 0x5C, 0x00, 0x41, 0x01, // ŜA (U+015C U+0041)
  0x01, 0x5C, 0x00, 0x54, 0x01, // ŜT (U+015C U+0054)
  0x01, 0x5C, 0x00, 0x56, 0x01, // ŜV (U+015C U+0056)
  0x01, 0x5C, 0x00, 0x57, 0x01, // ŜW (U+015C U+0057)
  0x01, 0x5C, 0x00, 0x58, 0x01, // ŜX (U+015C U+0058)
  0x01, 0x5C, 0x00, 0x59, 0x01, // ŜY (U+015C U+0059)
  0x01, 0x5C, 0x00, 0x77, 0x01, // Ŝw (U+015C U+0077)
  0x01, 0x5C, 0x00, 0x79, 0x01, // Ŝy (U+015C U+0079)
  0x01, 0x5C, 0x00, 0xC0, 0x01, // ŜÀ (U+015C U+00C0)
  0x01, 0x5C, 0x00, 0xC1, 0x01, // ŜÁ (U+015C U+00C1)
  0x01, 0x5C, 0x00, 0xC2, 0x01, // ŜÂ (U+015C U+00C2)
  0x01, 0x5C, 0x00, 0xC3, 0x01, // ŜÃ (U+015C U+00C3)
  0x01, 0x5C, 0x00, 0xC4, 0x01, // ŜÄ (U+015C U+00C4)
  0x01, 0x5C, 0x00, 0xC5, 0x01, // ŜÅ (U+015C U+00C5)
  0x01, 0x5C, 0x00, 0xC6, 0x01, // ŜÆ (U+015C U+00C6)
  0x01, 0x5C, 0x00, 0xDD, 0x01, // ŜÝ (U+015C U+00DD)
  0x01, 0x5C, 0x00, 0xFD, 0x01, // Ŝý (U+015C U+00FD)
  0x01, 0x5C, 0x00, 0xFF, 0x01, // Ŝÿ (U+015C U+00FF)
  0x01, 0x5C, 0x01, 0x00, 0x01, // ŜĀ (U+015C U+0100)
  0x01, 0x5C, 0x01, 0x02, 0x01, // ŜĂ (U+015C U+0102)
  0x01, 0x5C, 0x01, 0x04, 0x01, // ŜĄ (U+015C U+0104)
  0x01, 0x5C, 0x01, 0x62, 0x01, // ŜŢ (U+015C U+0162)
  0x01, 0x5C, 0x01, 0x64, 0x01, // ŜŤ (U+015C U+0164)
  0x01, 0x5C, 0x01, 0x66, 0x01, // ŜŦ (U+015C U+0166)
  0x01, 0x5C, 0x01, 0x74, 0x01, // ŜŴ (U+015C U+0174)
  0x01, 0x5C, 0x01, 0x75, 0x01, // Ŝŵ (U+015C U+0175)
  0x01, 0x5C, 0x01, 0x76, 0x01, // ŜŶ (U+015C U+0176)
  0x01, 0x5C, 0x01, 0x77, 0x01, // Ŝŷ (U+015C U+0177)
  0x01, 0x5C, 0x01, 0x78, 0x01, // ŜŸ (U+015C U+0178)
  0x01, 0x5D, 0x00, 0x57, 0x01, // ŝW (U+015D U+0057)
  0x01, 0x5D, 0x00, 0x59, 0x03, // ŝY (U+015D U+0059)
  0x01, 0x5D, 0x00, 0xDD, 0x03, // ŝÝ (U+015D U+00DD)
  0x01, 0x5D, 0x01, 0x74, 0x01, // ŝŴ (U+015D U+0174)
  0x01, 0x5D, 0x01, 0x76, 0x03, // ŝŶ (U+015D U+0176)
  0x01, 0x5D, 0x01, 0x78, 0x03, // ŝŸ (U+015D U+0178)
  0x01, 0x5E, 0x00, 0x3F, 0x01, // Ş? (U+015E U+003F)
  0x01, 0x5E, 0x00, 0x41, 0x01, // ŞA (U+015E U+0041)
  0x01, 0x5E, 0x00, 0x54, 0x01, // ŞT (U+015E U+0054)
  0x01, 0x5E, 0x00, 0x56, 0x01, // ŞV (U+015E U+0056)
  0x01, 0x5E, 0x00, 0x57, 0x01, // ŞW (U+015E U+0057)
  0x01, 0x5E, 0x00, 0x58, 0x01, // ŞX (U+015E U+0058)
  0x01, 0x5E, 0x00, 0x59, 0x01, // ŞY (U+015E U+0059)
  0x01, 0x5E, 0x00, 0x77, 0x01, // Şw (U+015E U+0077)
  0x01, 0x5E, 0x00, 0x79, 0x01, // Şy (U+015E U+0079)
  0x01, 0x5E, 0x00, 0xC0, 0x01, // ŞÀ (U+015E U+00C0)
  0x01, 0x5E, 0x00, 0xC1, 0x01, // ŞÁ (U+015E U+00C1)
  0x01, 0x5E, 0x00, 0xC2, 0x01, // ŞÂ (U+015E U+00C2)
  0x01, 0x5E, 0x00, 0xC3, 0x01, // ŞÃ (U+015E U+00C3)
  0x01, 0x5E, 0x00, 0xC4, 0x01, // ŞÄ (U+015E U+00C4)
  0x01, 0x5E, 0x00, 0xC5, 0x01, // ŞÅ (U+015E U+00C5)
  0x01, 0x5E, 0x00, 0xC6, 0x01, // ŞÆ (U+015E U+00C6)
  0x01, 0x5E, 0x00, 0xDD, 0x01, // ŞÝ (U+015E U+00DD)
  0x01, 0x5E, 0x00, 0xFD, 0x01, // Şý (U+015E U+00FD)
  0x01, 0x5E, 0x00, 0xFF, 0x01, // Şÿ (U+015E U+00FF)
  0x01, 0x5E, 0x01, 0x00, 0x01, // ŞĀ (U+015E U+0100)
  0x01, 0x5E, 0x01, 0x02, 0x01, // ŞĂ (U+015E U+0102)
  0x01, 0x5E, 0x01, 0x04, 0x01, // ŞĄ (U+015E U+0104)
  0x01, 0x5E, 0x01, 0x62, 0x01, // ŞŢ (U+015E U+0162)
  0x01, 0x5E, 0x01, 0x64, 0x01, // ŞŤ (U+015E U+0164)
  0x01, 0x5E, 0x01, 0x66, 0x01, // ŞŦ (U+015E U+0166)
  0x01, 0x5E, 0x01, 0x74, 0x01, // ŞŴ (U+015E U+0174)
  0x01, 0x5E, 0x01, 0x75, 0x01, // Şŵ (U+015E U+0175)
  0x01, 0x5E, 0x01, 0x76, 0x01, // ŞŶ (U+015E U+0176)
  0x01, 0x5E, 0x01, 0x77, 0x01, // Şŷ (U+015E U+0177)
  0x01, 0x5E, 0x01, 0x78, 0x01, // ŞŸ (U+015E U+0178)
  0x01, 0x5F, 0x00, 0x57, 0x01, // şW (U+015F U+0057)
  0x01, 0x5F, 0x00, 0x59, 0x03, // şY (U+015F U+0059)
  0x01, 0x5F, 0x00, 0xDD, 0x03, // şÝ (U+015F U+00DD)
  0x01, 0x5F, 0x01, 0x74, 0x01, // şŴ (U+015F U+0174)
  0x01, 0x5F, 0x01, 0x76, 0x03, // şŶ (U+015F U+0176)
  0x01, 0x5F, 0x01, 0x78, 0x03, // şŸ (U+015F U+0178)
  0x01, 0x60, 0x00, 0x3F, 0x01, // Š? (U+0160 U+003F)
  0x01, 0x60, 0x00, 0x41, 0x01, // ŠA (U+0160 U+0041)
  0x01, 0x60, 0x00, 0x54, 0x01, // ŠT (U+0160 U+0054)
  0x01, 0x60, 0x00, 0x56, 0x01, // ŠV (U+0160 U+0056)
  0x01, 0x60, 0x00, 0x57, 0x01, // ŠW (U+0160 U+0057)
  0x01, 0x60, 0x00, 0x58, 0x01, // ŠX (U+0160 U+0058)
  0x01, 0x60, 0x00, 0x59, 0x01, // ŠY (U+0160 U+0059)
  0x01, 0x60, 0x00, 0x77, 0x01, // Šw (U+0160 U+0077)
  0x01, 0x60, 0x00, 0x79, 0x01, // Šy (U+0160 U+0079)
  0x01, 0x60, 0x00, 0xC0, 0x01, // ŠÀ (U+0160 U+00C0)
  0x01, 0x60, 0x00, 0xC1, 0x01, // ŠÁ (U+0160 U+00C1)
  0x01, 0x60, 0x00, 0xC2, 0x01, // ŠÂ (U+0160 U+00C2)
  0x01, 0x60, 0x00, 0xC3, 0x01, // ŠÃ (U+0160 U+00C3)
  0x01, 0x60, 0x00, 0xC4, 0x01, // ŠÄ (U+0160 U+00C4)
  0x01, 0x60, 0x00, 0xC5, 0x01, // ŠÅ (U+0160 U+00C5)
  0x01, 0x60, 0x00, 0xC6, 0x01, // ŠÆ (U+0160 U+00C6)
  0x01, 0x60, 0x00, 0xDD, 0x01, // ŠÝ (U+0160 U+00DD)
  0x01, 0x60, 0x00, 0xFD, 0x01, // Šý (U+0160 U+00FD)
  0x01, 0x60, 0x00, 0xFF, 0x01, // Šÿ (U+0160 U+00FF)
  0x01, 0x60, 0x01, 0x00, 0x01, // ŠĀ (U+0160 U+0100)
  0x01, 0x60, 0x01, 0x02, 0x01, // ŠĂ (U+0160 U+0102)
  0x01, 0x60, 0x01, 0x04, 0x01, // ŠĄ (U+0160 U+0104)
  0x01, 0x60, 0x01, 0x62, 0x01, // ŠŢ (U+0160 U+0162)
  0x01, 0x60, 0x01, 0x64, 0x01, // ŠŤ (U+0160 U+0164)
  0x01, 0x60, 0x01, 0x66, 0x01, // ŠŦ (U+0160 U+0166)
  0x01, 0x60, 0x01, 0x74, 0x01, // ŠŴ (U+0160 U+0174)
  0x01, 0x60, 0x01, 0x75, 0x01, // Šŵ (U+0160 U+0175)
  0x01, 0x60, 0x01, 0x76, 0x01, // ŠŶ (U+0160 U+0176)
  0x01, 0x60, 0x01, 0x77, 0x01, // Šŷ (U+0160 U+0177)
  0x01, 0x60, 0x01, 0x78, 0x01, // ŠŸ (U+0160 U+0178)
  0x01, 0x61, 0x00, 0x57, 0x01, // šW (U+0161 U+0057)
  0x01, 0x61, 0x00, 0x59, 0x03, // šY (U+0161 U+0059)
  0x01, 0x61, 0x00, 0xDD, 0x03, // šÝ (U+0161 U+00DD)
  0x01, 0x61, 0x01, 0x74, 0x01, // šŴ (U+0161 U+0174)
  0x01, 0x61, 0x01, 0x76, 0x03, // šŶ (U+0161 U+0176)
  0x01, 0x61, 0x01, 0x78, 0x03, // šŸ (U+0161 U+0178)
  0x01, 0x62, 0x00, 0x26, 0x01, // Ţ& (U+0162 U+0026)
  0x01, 0x62, 0x00, 0x2C, 0x04, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2E, 0x04, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0x40, 0x02, // Ţ@ (U+0162 U+0040)
  0x01, 0x62, 0x00, 0x41, 0x03, // ŢA (U+0162 U+0041)
  0x01, 0x62, 0x00, 0x43, 0x01, // ŢC (U+0162 U+0043)
  0x01, 0x62, 0x00, 0x47, 0x01, // ŢG (U+0162 U+0047)
  0x01, 0x62, 0x00, 0x4F, 0x01, // ŢO (U+0162 U+004F)
  0x01, 0x62, 0x00, 0x51, 0x01, // ŢQ (U+0162 U+0051)
  0x01, 0x62, 0x00, 0x61, 0x02, // Ţa (U+0162 U+0061)
  0x01, 0x62, 0x00, 0x63, 0x03, // Ţc (U+0162 U+0063)
  0x01, 0x62, 0x00, 0x64, 0x03, // Ţd (U+0162 U+0064)
  0x01, 0x62, 0x00, 0x65, 0x03, // Ţe (U+0162 U+0065)
  0x01, 0x62, 0x00, 0x67, 0x03, // Ţg (U+0162 U+0067)
  0x01, 0x62, 0x00, 0x6F, 0x03, // Ţo (U+0162 U+006F)
  0x01, 0x62, 0x00, 0x71, 0x03, // Ţq (U+0162 U+0071)
  0x01, 0x62, 0x00, 0xC0, 0x03, // ŢÀ (U+0162 U+00C0)
  0x01, 0x62, 0x00, 0xC1, 0x03, // ŢÁ (U+0162 U+00C1)
  0x01, 0x62, 0x00, 0xC2, 0x03, // ŢÂ (U+0162 U+00C2)
  0x01, 0x62, 0x00, 0xC3, 0x03, // ŢÃ (U+0162 U+00C3)
  0x01, 0x62, 0x00, 0xC4, 0x03, // ŢÄ (U+0162 U+00C4)
  0x01, 0x62, 0x00, 0xC5, 0x03, // ŢÅ (U+0162 U+00C5)
  0x01, 0x62, 0x00, 0xC6, 0x05, // ŢÆ (U+0162 U+00C6)
  0x01, 0x62, 0x00, 0xC7, 0x01, // ŢÇ (U+0162 U+00C7)
  0x01, 0x62, 0x00, 0xD2, 0x01, // ŢÒ (U+0162 U+00D2)
  0x01, 0x62, 0x00, 0xD3, 0x01, // ŢÓ (U+0162 U+00D3)
  0x01, 0x62, 0x00, 0xD4, 0x01, // ŢÔ (U+0162 U+00D4)
  0x01, 0x62, 0x00, 0xD5, 0x01, // ŢÕ (U+0162 U+00D5)
  0x01, 0x62, 0x00, 0xD6, 0x01, // ŢÖ (U+0162 U+00D6)
  0x01, 0x62, 0x00, 0xD8, 0x01, // ŢØ (U+0162 U+00D8)
  0x01, 0x62, 0x00, 0xE0, 0x02, // Ţà (U+0162 U+00E0)
  0x01, 0x62, 0x00, 0xE1, 0x02, // Ţá (U+0162 U+00E1)
  0x01, 0x62, 0x00, 0xE2, 0x02, // Ţâ (U+0162 U+00E2)
  0x01, 0x62, 0x00, 0xE3, 0x02, // Ţã (U+0162 U+00E3)
  0x01, 0x62, 0x00, 0xE4, 0x02, // Ţä (U+0162 U+00E4)
  0x01, 0x62, 0x00, 0xE5, 0x02, // Ţå (U+0162 U+00E5)
  0x01, 0x62, 0x00, 0xE6, 0x02, // Ţæ (U+0162 U+00E6)
  0x01, 0x62, 0x00, 0xE7, 0x03, // Ţç (U+0162 U+00E7)
  0x01, 0x62, 0x00, 0xE8, 0x03, // Ţè (U+0162 U+00E8)
  0x01, 0x62, 0x00, 0xE9, 0x03, // Ţé (U+0162 U+00E9)
  0x01, 0x62, 0x00, 0xEA, 0x03, // Ţê (U+0162 U+00EA)
  0x01, 0x62, 0x00, 0xEB, 0x03, // Ţë (U+0162 U+00EB)
  0x01, 0x62, 0x00, 0xF0, 0x03, // Ţð (U+0162 U+00F0)
  0x01, 0x62, 0x00, 0xF2, 0x03, // Ţò (U+0162 U+00F2)
  0x01, 0x62, 0x00, 0xF3, 0x03, // Ţó (U+0162 U+00F3)
  0x01, 0x62, 0x00, 0xF4, 0x03, // Ţô (U+0162 U+00F4)
  0x01, 0x62, 0x00, 0xF5, 0x03, // Ţõ (U+0162 U+00F5)
  0x01, 0x62, 0x00, 0xF6, 0x03, // Ţö (U+0162 U+00F6)
  0x01, 0x62, 0x00, 0xF8, 0x03, // Ţø (U+0162 U+00F8)
  0x01, 0x62, 0x01, 0x00, 0x03, // ŢĀ (U+0162 U+0100)
  0x01, 0x62, 0x01, 0x01, 0x02, // Ţā (U+0162 U+0101)
  0x01, 0x62, 0x01, 0x02, 0x03, // ŢĂ (U+0162 U+0102)
  0x01, 0x62, 0x01, 0x03, 0x02, // Ţă (U+0162 U+0103)
  0x01, 0x62, 0x01, 0x04, 0x03, // ŢĄ (U+0162 U+0104)
  0x01, 0x62, 0x01, 0x05, 0x02, // Ţą (U+0162 U+0105)
  0x01, 0x62, 0x01, 0x06, 0x01, // ŢĆ (U+0162 U+0106)
  0x01, 0x62, 0x01, 0x07, 0x03, // Ţć (U+0162 U+0107)
  0x01, 0x62, 0x01, 0x08, 0x01, // ŢĈ (U+0162 U+0108)
  0x01, 0x62, 0x01, 0x09, 0x03, // Ţĉ (U+0162 U+0109)
  0x01, 0x62, 0x01, 0x0A, 0x01, // ŢĊ (U+0162 U+010A)
  0x01, 0x62, 0x01, 0x0B, 0x03, // Ţċ (U+0162 U+010B)
  0x01, 0x62, 0x01, 0x0C, 0x01, // ŢČ (U+0162 U+010C)
  0x01, 0x62, 0x01, 0x0D, 0x03, // Ţč (U+0162 U+010D)
  0x01, 0x62, 0x01, 0x0F, 0x03, // Ţď (U+0162 U+010F)
  0x01, 0x62, 0x01, 0x11, 0x03, // Ţđ (U+0162 U+0111)
  0x01, 0x62, 0x01, 0x13, 0x03, // Ţē (U+0162 U+0113)
  0x01, 0x62, 0x01, 0x15, 0x03, // Ţĕ (U+0162 U+0115)
  0x01, 0x62, 0x01, 0x17, 0x03, // Ţė (U+0162 U+0117)
  0x01, 0x62, 0x01, 0x19, 0x03, // Ţę (U+0162 U+0119)
  0x01, 0x62, 0x01, 0x1B, 0x03, // Ţě (U+0162 U+011B)
  0x01, 0x62, 0x01, 0x1C, 0x01, // ŢĜ (U+0162 U+011C)
  0x01, 0x62, 0x01, 0x1D, 0x03, // Ţĝ (U+0162 U+011D)
  0x01, 0x62, 0x01, 0x1E, 0x01, // ŢĞ (U+0162 U+011E)
  0x01, 0x62, 0x01, 0x1F, 0x03, // Ţğ (U+0162 U+011F)
  0x01, 0x62, 0x01, 0x20, 0x01, // ŢĠ (U+0162 U+0120)
  0x01, 0x62, 0x01, 0x21, 0x03, // Ţġ (U+0162 U+0121)
  0x01, 0x62, 0x01, 0x22, 0x01, // ŢĢ (U+0162 U+0122)
  0x01, 0x62, 0x01, 0x23, 0x03, // Ţģ (U+0162 U+0123)
  0x01, 0x62, 0x01, 0x4C, 0x01, // ŢŌ (U+0162 U+014C)
  0x01, 0x62, 0x01, 0x4D, 0x03, // Ţō (U+0162 U+014D)
  0x01, 0x62, 0x01, 0x4E, 0x01, // ŢŎ (U+0162 U+014E)
  0x01, 0x62, 0x01, 0x4F, 0x03, // Ţŏ (U+0162 U+014F)
  0x01, 0x62, 0x01, 0x50, 0x01, // ŢŐ (U+0162 U+0150)
  0x01, 0x62, 0x01, 0x51, 0x03, // Ţő (U+0162 U+0151)
  0x01, 0x62, 0x01, 0x52, 0x01, // ŢŒ (U+0162 U+0152)
  0x01, 0x62, 0x01, 0x53, 0x03, // Ţœ (U+0162 U+0153)
  0x01, 0x62, 0x20, 0x1A, 0x04, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x04, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x04, // Ţ… (U+0162 U+2026)
  0x01, 0x64, 0x00, 0x26, 0x01, // Ť& (U+0164 U+0026)
  0x01, 0x64, 0x00, 0x2C, 0x04, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2E, 0x04, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0x40, 0x02, // Ť@ (U+0164 U+0040)
  0x01, 0x64, 0x00, 0x41, 0x03, // ŤA (U+0164 U+0041)
  0x01, 0x64, 0x00, 0x43, 0x01, // ŤC (U+0164 U+0043)
  0x01, 0x64, 0x00, 0x47, 0x01, // ŤG (U+0164 U+0047)
  0x01, 0x64, 0x00, 0x4F, 0x01, // ŤO (U+0164 U+004F)
  0x01, 0x64, 0x00, 0x51, 0x01, // ŤQ (U+0164 U+0051)
  0x01, 0x64, 0x00, 0x61, 0x02, // Ťa (U+0164 U+0061)
  0x01, 0x64, 0x00, 0x63, 0x03, // Ťc (U+0164 U+0063)
  0x01, 0x64, 0x00, 0x64, 0x03, // Ťd (U+0164 U+0064)
  0x01, 0x64, 0x00, 0x65, 0x03, // Ťe (U+0164 U+0065)
  0x01, 0x64, 0x00, 0x67, 0x03, // Ťg (U+0164 U+0067)
  0x01, 0x64, 0x00, 0x6F, 0x03, // Ťo (U+0164 U+006F)
  0x01, 0x64, 0x00, 0x71, 0x03, // Ťq (U+0164 U+0071)
  0x01, 0x64, 0x00, 0xC0, 0x03, // ŤÀ (U+0164 U+00C0)
  0x01, 0x64, 0x00, 0xC1, 0x03, // ŤÁ (U+0164 U+00C1)
  0x01, 0x64, 0x00, 0xC2, 0x03, // ŤÂ (U+0164 U+00C2)
  0x01, 0x64, 0x00, 0xC3, 0x03, // ŤÃ (U+0164 U+00C3)
  0x01, 0x64, 0x00, 0xC4, 0x03, // ŤÄ (U+0164 U+00C4)
  0x01, 0x64, 0x00, 0xC5, 0x03, // ŤÅ (U+0164 U+00C5)
  0x01, 0x64, 0x00, 0xC6, 0x05, // ŤÆ (U+0164 U+00C6)
  0x01, 0x64, 0x00, 0xC7, 0x01, // ŤÇ (U+0164 U+00C7)
  0x01, 0x64, 0x00, 0xD2, 0x01, // ŤÒ (U+0164 U+00D2)
  0x01, 0x64, 0x00, 0xD3, 0x01, // ŤÓ (U+0164 U+00D3)
  0x01, 0x64, 0x00, 0xD4, 0x01, // ŤÔ (U+0164 U+00D4)
  0x01, 0x64, 0x00, 0xD5, 0x01, // ŤÕ (U+0164 U+00D5)
  0x01, 0x64, 0x00, 0xD6, 0x01, // ŤÖ (U+0164 U+00D6)
  0x01, 0x64, 0x00, 0xD8, 0x01, // ŤØ (U+0164 U+00D8)
  0x01, 0x64, 0x00, 0xE0, 0x02, // Ťà (U+0164 U+00E0)
  0x01, 0x64, 0x00, 0xE1, 0x02, // Ťá (U+0164 U+00E1)
  0x01, 0x64, 0x00, 0xE2, 0x02, // Ťâ (U+0164 U+00E2)
  0x01, 0x64, 0x00, 0xE3, 0x02, // Ťã (U+0164 U+00E3)
  0x01, 0x64, 0x00, 0xE4, 0x02, // Ťä (U+0164 U+00E4)
  0x01, 0x64, 0x00, 0xE5, 0x02, // Ťå (U+0164 U+00E5)
  0x01, 0x64, 0x00, 0xE6, 0x02, // Ťæ (U+0164 U+00E6)
  0x01, 0x64, 0x00, 0xE7, 0x03, // Ťç (U+0164 U+00E7)
  0x01, 0x64, 0x00, 0xE8, 0x03, // Ťè (U+0164 U+00E8)
  0x01, 0x64, 0x00, 0xE9, 0x03, // Ťé (U+0164 U+00E9)
  0x01, 0x64, 0x00, 0xEA, 0x03, // Ťê (U+0164 U+00EA)
  0x01, 0x64, 0x00, 0xEB, 0x03, // Ťë (U+0164 U+00EB)
  0x01, 0x64, 0x00, 0xF0, 0x03, // Ťð (U+0164 U+00F0)
  0x01, 0x64, 0x00, 0xF2, 0x03, // Ťò (U+0164 U+00F2)
  0x01, 0x64, 0x00, 0xF3, 0x03, // Ťó (U+0164 U+00F3)
  0x01, 0x64, 0x00, 0xF4, 0x03, // Ťô (U+0164 U+00F4)
  0x01, 0x64, 0x00, 0xF5, 0x03, // Ťõ (U+0164 U+00F5)
  0x01, 0x64, 0x00, 0xF6, 0x03, // Ťö (U+0164 U+00F6)
  0x01, 0x64, 0x00, 0xF8, 0x03, // Ťø (U+0164 U+00F8)
  0x01, 0x64, 0x01, 0x00, 0x03, // ŤĀ (U+0164 U+0100)
  0x01, 0x64, 0x01, 0x01, 0x02, // Ťā (U+0164 U+0101)
  0x01, 0x64, 0x01, 0x02, 0x03, // ŤĂ (U+0164 U+0102)
  0x01, 0x64, 0x01, 0x03, 0x02, // Ťă (U+0164 U+0103)
  0x01, 0x64, 0x01, 0x04, 0x03, // ŤĄ (U+0164 U+0104)
  0x01, 0x64, 0x01, 0x05, 0x02, // Ťą (U+0164 U+0105)
  0x01, 0x64, 0x01, 0x06, 0x01, // ŤĆ (U+0164 U+0106)
  0x01, 0x64, 0x01, 0x07, 0x03, // Ťć (U+0164 U+0107)
  0x01, 0x64, 0x01, 0x08, 0x01, // ŤĈ (U+0164 U+0108)
  0x01, 0x64, 0x01, 0x09, 0x03, // Ťĉ (U+0164 U+0109)
  0x01, 0x64, 0x01, 0x0A, 0x01, // ŤĊ (U+0164 U+010A)
  0x01, 0x64, 0x01, 0x0B, 0x03, // Ťċ (U+0164 U+010B)
  0x01, 0x64, 0x01, 0x0C, 0x01, // ŤČ (U+0164 U+010C)
  0x01, 0x64, 0x01, 0x0D, 0x03, // Ťč (U+0164 U+010D)
  0x01, 0x64, 0x01, 0x0F, 0x03, // Ťď (U+0164 U+010F)
  0x01, 0x64, 0x01, 0x11, 0x03, // Ťđ (U+0164 U+0111)
  0x01, 0x64, 0x01, 0x13, 0x03, // Ťē (U+0164 U+0113)
  0x01, 0x64, 0x01, 0x15, 0x03, // Ťĕ (U+0164 U+0115)
  0x01, 0x64, 0x01, 0x17, 0x03, // Ťė (U+0164 U+0117)
  0x01, 0x64, 0x01, 0x19, 0x03, // Ťę (U+0164 U+0119)
  0x01, 0x64, 0x01, 0x1B, 0x03, // Ťě (U+0164 U+011B)
  0x01, 0x64, 0x01, 0x1C, 0x01, // ŤĜ (U+0164 U+011C)
  0x01, 0x64, 0x01, 0x1D, 0x03, // Ťĝ (U+0164 U+011D)
  0x01, 0x64, 0x01, 0x1E, 0x01, // ŤĞ (U+0164 U+011E)
  0x01, 0x64, 0x01, 0x1F, 0x03, // Ťğ (U+0164 U+011F)
  0x01, 0x64, 0x01, 0x20, 0x01, // ŤĠ (U+0164 U+0120)
  0x01, 0x64, 0x01, 0x21, 0x03, // Ťġ (U+0164 U+0121)
  0x01, 0x64, 0x01, 0x22, 0x01, // ŤĢ (U+0164 U+0122)
  0x01, 0x64, 0x01, 0x23, 0x03, // Ťģ (U+0164 U+0123)
  0x01, 0x64, 0x01, 0x4C, 0x01, // ŤŌ (U+0164 U+014C)
  0x01, 0x64, 0x01, 0x4D, 0x03, // Ťō (U+0164 U+014D)
  0x01, 0x64, 0x01, 0x4E, 0x01, // ŤŎ (U+0164 U+014E)
  0x01, 0x64, 0x01, 0x4F, 0x03, // Ťŏ (U+0164 U+014F)
  0x01, 0x64, 0x01, 0x50, 0x01, // ŤŐ (U+0164 U+0150)
  0x01, 0x64, 0x01, 0x51, 0x03, // Ťő (U+0164 U+0151)
  0x01, 0x64, 0x01, 0x52, 0x01, // ŤŒ (U+0164 U+0152)
  0x01, 0x64, 0x01, 0x53, 0x03, // Ťœ (U+0164 U+0153)
  0x01, 0x64, 0x20, 0x1A, 0x04, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x04, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x04, // Ť… (U+0164 U+2026)
  0x01, 0x66, 0x00, 0x26, 0x01, // Ŧ& (U+0166 U+0026)
  0x01, 0x66, 0x00, 0x2C, 0x04, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2E, 0x04, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0x40, 0x02, // Ŧ@ (U+0166 U+0040)
  0x01, 0x66, 0x00, 0x41, 0x03, // ŦA (U+0166 U+0041)
  0x01, 0x66, 0x00, 0x43, 0x01, // ŦC (U+0166 U+0043)
  0x01, 0x66, 0x00, 0x47, 0x01, // ŦG (U+0166 U+0047)
  0x01, 0x66, 0x00, 0x4F, 0x01, // ŦO (U+0166 U+004F)
  0x01, 0x66, 0x00, 0x51, 0x01, // ŦQ (U+0166 U+0051)
  0x01, 0x66, 0x00, 0x61, 0x02, // Ŧa (U+0166 U+0061)
  0x01, 0x66, 0x00, 0x63, 0x03, // Ŧc (U+0166 U+0063)
  0x01, 0x66, 0x00, 0x64, 0x03, // Ŧd (U+0166 U+0064)
  0x01, 0x66, 0x00, 0x65, 0x03, // Ŧe (U+0166 U+0065)
  0x01, 0x66, 0x00, 0x67, 0x03, // Ŧg (U+0166 U+0067)
  0x01, 0x66, 0x00, 0x6F, 0x03, // Ŧo (U+0166 U+006F)
  0x01, 0x66, 0x00, 0x71, 0x03, // Ŧq (U+0166 U+0071)
  0x01, 0x66, 0x00, 0xC0, 0x03, // ŦÀ (U+0166 U+00C0)
  0x01, 0x66, 0x00, 0xC1, 0x03, // ŦÁ (U+0166 U+00C1)
  0x01, 0x66, 0x00, 0xC2, 0x03, // ŦÂ (U+0166 U+00C2)
  0x01, 0x66, 0x00, 0xC3, 0x03, // ŦÃ (U+0166 U+00C3)
  0x01, 0x66, 0x00, 0xC4, 0x03, // ŦÄ (U+0166 U+00C4)
  0x01, 0x66, 0x00, 0xC5, 0x03, // ŦÅ (U+0166 U+00C5)
  0x01, 0x66, 0x00, 0xC6, 0x05, // ŦÆ (U+0166 U+00C6)
  0x01, 0x66, 0x00, 0xC7, 0x01, // ŦÇ (U+0166 U+00C7)
  0x01, 0x66, 0x00, 0xD2, 0x01, // ŦÒ (U+0166 U+00D2)
  0x01, 0x66, 0x00, 0xD3, 0x01, // ŦÓ (U+0166 U+00D3)
  0x01, 0x66, 0x00, 0xD4, 0x01, // ŦÔ (U+0166 U+00D4)
  0x01, 0x66, 0x00, 0xD5, 0x01, // ŦÕ (U+0166 U+00D5)
  0x01, 0x66, 0x00, 0xD6, 0x01, // ŦÖ (U+0166 U+00D6)
  0x01, 0x66, 0x00, 0xD8, 0x01, // ŦØ (U+0166 U+00D8)
  0x01, 0x66, 0x00, 0xE0, 0x02, // Ŧà (U+0166 U+00E0)
  0x01, 0x66, 0x00, 0xE1, 0x02, // Ŧá (U+0166 U+00E1)
  0x01, 0x66, 0x00, 0xE2, 0x02, // Ŧâ (U+0166 U+00E2)
  0x01, 0x66, 0x00, 0xE3, 0x02, // Ŧã (U+0166 U+00E3)
  0x01, 0x66, 0x00, 0xE4, 0x02, // Ŧä (U+0166 U+00E4)
  0x01, 0x66, 0x00, 0xE5, 0x02, // Ŧå (U+0166 U+00E5)
  0x01, 0x66, 0x00, 0xE6, 0x02, // Ŧæ (U+0166 U+00E6)
  0x01, 0x66, 0x00, 0xE7, 0x03, // Ŧç (U+0166 U+00E7)
  0x01, 0x66, 0x00, 0xE8, 0x03, // Ŧè (U+0166 U+00E8)
  0x01, 0x66, 0x00, 0xE9, 0x03, // Ŧé (U+0166 U+00E9)
  0x01, 0x66, 0x00, 0xEA, 0x03, // Ŧê (U+0166 U+00EA)
  0x01, 0x66, 0x00, 0xEB, 0x03, // Ŧë (U+0166 U+00EB)
  0x01, 0x66, 0x00, 0xF0, 0x03, // Ŧð (U+0166 U+00F0)
  0x01, 0x66, 0x00, 0xF2, 0x03, // Ŧò (U+0166 U+00F2)
  0x01, 0x66, 0x00, 0xF3, 0x03, // Ŧó (U+0166 U+00F3)
  0x01, 0x66, 0x00, 0xF4, 0x03, // Ŧô (U+0166 U+00F4)
  0x01, 0x66, 0x00, 0xF5, 0x03, // Ŧõ (U+0166 U+00F5)
  0x01, 0x66, 0x00, 0xF6, 0x03, // Ŧö (U+0166 U+00F6)
  0x01, 0x66, 0x00, 0xF8, 0x03, // Ŧø (U+0166 U+00F8)
  0x01, 0x66, 0x01, 0x00, 0x03, // ŦĀ (U+0166 U+0100)
  0x01, 0x66, 0x01, 0x01, 0x02, // Ŧā (U+0166 U+0101)
  0x01, 0x66, 0x01, 0x02, 0x03, // ŦĂ (U+0166 U+0102)
  0x01, 0x66, 0x01, 0x03, 0x02, // Ŧă (U+0166 U+0103)
  0x01, 0x66, 0x01, 0x04, 0x03, // ŦĄ (U+0166 U+0104)
  0x01, 0x66, 0x01, 0x05, 0x02, // Ŧą (U+0166 U+0105)
  0x01, 0x66, 0x01, 0x06, 0x01, // ŦĆ (U+0166 U+0106)
  0x01, 0x66, 0x01, 0x07, 0x03, // Ŧć (U+0166 U+0107)
  0x01, 0x66, 0x01, 0x08, 0x01, // ŦĈ (U+0166 U+0108)
  0x01, 0x66, 0x01, 0x09, 0x03, // Ŧĉ (U+0166 U+0109)
  0x01, 0x66, 0x01, 0x0A, 0x01, // ŦĊ (U+0166 U+010A)
  0x01, 0x66, 0x01, 0x0B, 0x03, // Ŧċ (U+0166 U+010B)
  0x01, 0x66, 0x01, 0x0C, 0x01, // ŦČ (U+0166 U+010C)
  0x01, 0x66, 0x01, 0x0D, 0x03, // Ŧč (U+0166 U+010D)
  0x01, 0x66, 0x01, 0x0F, 0x03, // Ŧď (U+0166 U+010F)
  0x01, 0x66, 0x01, 0x11, 0x03, // Ŧđ (U+0166 U+0111)
  0x01, 0x66, 0x01, 0x13, 0x03, // Ŧē (U+0166 U+0113)
  0x01, 0x66, 0x01, 0x15, 0x03, // Ŧĕ (U+0166 U+0115)
  0x01, 0x66, 0x01, 0x17, 0x03, // Ŧė (U+0166 U+0117)
  0x01, 0x66, 0x01, 0x19, 0x03, // Ŧę (U+0166 U+0119)
  0x01, 0x66, 0x01, 0x1B, 0x03, // Ŧě (U+0166 U+011B)
  0x01, 0x66, 0x01, 0x1C, 0x01, // ŦĜ (U+0166 U+011C)
  0x01, 0x66, 0x01, 0x1D, 0x03, // Ŧĝ (U+0166 U+011D)
  0x01, 0x66, 0x01, 0x1E, 0x01, // ŦĞ (U+0166 U+011E)
  0x01, 0x66, 0x01, 0x1F, 0x03, // Ŧğ (U+0166 U+011F)
  0x01, 0x66, 0x01, 0x20, 0x01, // ŦĠ (U+0166 U+0120)
  0x01, 0x66, 0x01, 0x21, 0x03, // Ŧġ (U+0166 U+0121)
  0x01, 0x66, 0x01, 0x22, 0x01, // ŦĢ (U+0166 U+0122)
  0x01, 0x66, 0x01, 0x23, 0x03, // Ŧģ (U+0166 U+0123)
  0x01, 0x66, 0x01, 0x4C, 0x01, // ŦŌ (U+0166 U+014C)
  0x01, 0x66, 0x01, 0x4D, 0x03, // Ŧō (U+0166 U+014D)
  0x01, 0x66, 0x01, 0x4E, 0x01, // ŦŎ (U+0166 U+014E)
  0x01, 0x66, 0x01, 0x4F, 0x03, // Ŧŏ (U+0166 U+014F)
  0x01, 0x66, 0x01, 0x50, 0x01, // ŦŐ (U+0166 U+0150)
  0x01, 0x66, 0x01, 0x51, 0x03, // Ŧő (U+0166 U+0151)
  0x01, 0x66, 0x01, 0x52, 0x01, // ŦŒ (U+0166 U+0152)
  0x01, 0x66, 0x01, 0x53, 0x03, // Ŧœ (U+0166 U+0153)
  0x01, 0x66, 0x20, 0x1A, 0x04, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x04, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x04, // Ŧ… (U+0166 U+2026)
  0x01, 0x68, 0x00, 0x2C, 0x01, // Ũ, (U+0168 U+002C)
  0x01, 0x68, 0x00, 0x2E, 0x01, // Ũ. (U+0168 U+002E)
  0x01, 0x68, 0x00, 0x40, 0x01, // Ũ@ (U+0168 U+0040)
  0x01, 0x68, 0x00, 0x41, 0x01, // ŨA (U+0168 U+0041)
  0x01, 0x68, 0x00, 0xC0, 0x01, // ŨÀ (U+0168 U+00C0)
  0x01, 0x68, 0x00, 0xC1, 0x01, // ŨÁ (U+0168 U+00C1)
  0x01, 0x68, 0x00, 0xC2, 0x01, // ŨÂ (U+0168 U+00C2)
  0x01, 0x68, 0x00, 0xC3, 0x01, // ŨÃ (U+0168 U+00C3)
  0x01, 0x68, 0x00, 0xC4, 0x01, // ŨÄ (U+0168 U+00C4)
  0x01, 0x68, 0x00, 0xC5, 0x01, // ŨÅ (U+0168 U+00C5)
  0x01, 0x68, 0x00, 0xC6, 0x02, // ŨÆ (U+0168 U+00C6)
  0x01, 0x68, 0x01, 0x00, 0x01, // ŨĀ (U+0168 U+0100)
  0x01, 0x68, 0x01, 0x02, 0x01, // ŨĂ (U+0168 U+0102)
  0x01, 0x68, 0x01, 0x04, 0x01, // ŨĄ (U+0168 U+0104)
  0x01, 0x68, 0x20, 0x1A, 0x01, // Ũ‚ (U+0168 U+201A)
  0x01, 0x68, 0x20, 0x1E, 0x01, // Ũ„ (U+0168 U+201E)
  0x01, 0x68, 0x20, 0x26, 0x01, // Ũ… (U+0168 U+2026)
  0x01, 0x6A, 0x00, 0x2C, 0x01, // Ū, (U+016A U+002C)
  0x01, 0x6A, 0x00, 0x2E, 0x01, // Ū. (U+016A U+002E)
  0x01, 0x6A, 0x00, 0x40, 0x01, // Ū@ (U+016A U+0040)
  0x01, 0x6A, 0x00, 0x41, 0x01, // ŪA (U+016A U+0041)
  0x01, 0x6A, 0x00, 0xC0, 0x01, // ŪÀ (U+016A U+00C0)
  0x01, 0x6A, 0x00, 0xC1, 0x01, // ŪÁ (U+016A U+00C1)
  0x01, 0x6A, 0x00, 0xC2, 0x01, // ŪÂ (U+016A U+00C2)
  0x01, 0x6A, 0x00, 0xC3, 0x01, // ŪÃ (U+016A U+00C3)
  0x01, 0x6A, 0x00, 0xC4, 0x01, // ŪÄ (U+016A U+00C4)
  0x01, 0x6A, 0x00, 0xC5, 0x01, // ŪÅ (U+016A U+00C5)
  0x01, 0x6A, 0x00, 0xC6, 0x02, // ŪÆ (U+016A U+00C6)
  0x01, 0x6A, 0x01, 0x00, 0x01, // ŪĀ (U+016A U+0100)
  0x01, 0x6A, 0x01, 0x02, 0x01, // ŪĂ (U+016A U+0102)
  0x01, 0x6A, 0x01, 0x04, 0x01, // ŪĄ (U+016A U+0104)
  0x01, 0x6A, 0x20, 0x1A, 0x01, // Ū‚ (U+016A U+201A)
  0x01, 0x6A, 0x20, 0x1E, 0x01, // Ū„ (U+016A U+201E)
  0x01, 0x6A, 0x20, 0x26, 0x01, // Ū… (U+016A U+2026)
  0x01, 0x6C, 0x00, 0x2C, 0x01, // Ŭ, (U+016C U+002C)
  0x01, 0x6C, 0x00, 0x2E, 0x01, // Ŭ. (U+016C U+002E)
  0x01, 0x6C, 0x00, 0x40, 0x01, // Ŭ@ (U+016C U+0040)
  0x01, 0x6C, 0x00, 0x41, 0x01, // ŬA (U+016C U+0041)
  0x01, 0x6C, 0x00, 0xC0, 0x01, // ŬÀ (U+016C U+00C0)
  0x01, 0x6C, 0x00, 0xC1, 0x01, // ŬÁ (U+016C U+00C1)
  0x01, 0x6C, 0x00, 0xC2, 0x01, // ŬÂ (U+016C U+00C2)
  0x01, 0x6C, 0x00, 0xC3, 0x01, // ŬÃ (U+016C U+00C3)
  0x01, 0x6C, 0x00, 0xC4, 0x01, // ŬÄ (U+016C U+00C4)
  0x01, 0x6C, 0x00, 0xC5, 0x01, // ŬÅ (U+016C U+00C5)
  0x01, 0x6C, 0x00, 0xC6, 0x02, // ŬÆ (U+016C U+00C6)
  0x01, 0x6C, 0x01, 0x00, 0x01, // ŬĀ (U+016C U+0100)
  0x01, 0x6C, 0x01, 0x02, 0x01, // ŬĂ (U+016C U+0102)
  0x01, 0x6C, 0x01, 0x04, 0x01, // ŬĄ (U+016C U+0104)
  0x01, 0x6C, 0x20, 0x1A, 0x01, // Ŭ‚ (U+016C U+201A)
  0x01, 0x6C, 0x20, 0x1E, 0x01, // Ŭ„ (U+016C U+201E)
  0x01, 0x6C, 0x20, 0x26, 0x01, // Ŭ… (U+016C U+2026)
  0x01, 0x6E, 0x00, 0x2C, 0x01, // Ů, (U+016E U+002C)
  0x01, 0x6E, 0x00, 0x2E, 0x01, // Ů. (U+016E U+002E)
  0x01, 0x6E, 0x00, 0x40, 0x01, // Ů@ (U+016E U+0040)
  0x01, 0x6E, 0x00, 0x41, 0x01, // ŮA (U+016E U+0041)
  0x01, 0x6E, 0x00, 0xC0, 0x01, // ŮÀ (U+016E U+00C0)
  0x01, 0x6E, 0x00, 0xC1, 0x01, // ŮÁ (U+016E U+00C1)
  0x01, 0x6E, 0x00, 0xC2, 0x01, // ŮÂ (U+016E U+00C2)
  0x01, 0x6E, 0x00, 0xC3, 0x01, // ŮÃ (U+016E U+00C3)
  0x01, 0x6E, 0x00, 0xC4, 0x01, // ŮÄ (U+016E U+00C4)
  0x01, 0x6E, 0x00, 0xC5, 0x01, // ŮÅ (U+016E U+00C5)
  0x01, 0x6E, 0x00, 0xC6, 0x02, // ŮÆ (U+016E U+00C6)
  0x01, 0x6E, 0x01, 0x00, 0x01, // ŮĀ (U+016E U+0100)
  0x01, 0x6E, 0x01, 0x02, 0x01, // ŮĂ (U+016E U+0102)
  0x01, 0x6E, 0x01, 0x04, 0x01, // ŮĄ (U+016E U+0104)
  0x01, 0x6E, 0x20, 0x1A, 0x01, // Ů‚ (U+016E U+201A)
  0x01, 0x6E, 0x20, 0x1E, 0x01, // Ů„ (U+016E U+201E)
  0x01, 0x6E, 0x20, 0x26, 0x01, // Ů… (U+016E U+2026)
  0x01, 0x70, 0x00, 0x2C, 0x01, // Ű, (U+0170 U+002C)
  0x01, 0x70, 0x00, 0x2E, 0x01, // Ű. (U+0170 U+002E)
  0x01, 0x70, 0x00, 0x40, 0x01, // Ű@ (U+0170 U+0040)
  0x01, 0x70, 0x00, 0x41, 0x01, // ŰA (U+0170 U+0041)
  0x01, 0x70, 0x00, 0xC0, 0x01, // ŰÀ (U+0170 U+00C0)
  0x01, 0x70, 0x00, 0xC1, 0x01, // ŰÁ (U+0170 U+00C1)
  0x01, 0x70, 0x00, 0xC2, 0x01, // ŰÂ (U+0170 U+00C2)
  0x01, 0x70, 0x00, 0xC3, 0x01, // ŰÃ (U+0170 U+00C3)
  0x01, 0x70, 0x00, 0xC4, 0x01, // ŰÄ (U+0170 U+00C4)
  0x01, 0x70, 0x00, 0xC5, 0x01, // ŰÅ (U+0170 U+00C5)
  0x01, 0x70, 0x00, 0xC6, 0x02, // ŰÆ (U+0170 U+00C6)
  0x01, 0x70, 0x01, 0x00, 0x01, // ŰĀ (U+0170 U+0100)
  0x01, 0x70, 0x01, 0x02, 0x01, // ŰĂ (U+0170 U+0102)
  0x01, 0x70, 0x01, 0x04, 0x01, // ŰĄ (U+0170 U+0104)
  0x01, 0x70, 0x20, 0x1A, 0x01, // Ű‚ (U+0170 U+201A)
  0x01, 0x70, 0x20, 0x1E, 0x01, // Ű„ (U+0170 U+201E)
  0x01, 0x70, 0x20, 0x26, 0x01, // Ű… (U+0170 U+2026)
  0x01, 0x72, 0x00, 0x2C, 0x01, // Ų, (U+0172 U+002C)
  0x01, 0x72, 0x00, 0x2E, 0x01, // Ų. (U+0172 U+002E)
  0x01, 0x72, 0x00, 0x40, 0x01, // Ų@ (U+0172 U+0040)
  0x01, 0x72, 0x00, 0x41, 0x01, // ŲA (U+0172 U+0041)
  0x01, 0x72, 0x00, 0xC0, 0x01, // ŲÀ (U+0172 U+00C0)
  0x01, 0x72, 0x00, 0xC1, 0x01, // ŲÁ (U+0172 U+00C1)
  0x01, 0x72, 0x00, 0xC2, 0x01, // ŲÂ (U+0172 U+00C2)
  0x01, 0x72, 0x00, 0xC3, 0x01, // ŲÃ (U+0172 U+00C3)
  0x01, 0x72, 0x00, 0xC4, 0x01, // ŲÄ (U+0172 U+00C4)
  0x01, 0x72, 0x00, 0xC5, 0x01, // ŲÅ (U+0172 U+00C5)
  0x01, 0x72, 0x00, 0xC6, 0x02, // ŲÆ (U+0172 U+00C6)
  0x01, 0x72, 0x01, 0x00, 0x01, // ŲĀ (U+0172 U+0100)
  0x01, 0x72, 0x01, 0x02, 0x01, // ŲĂ (U+0172 U+0102)
  0x01, 0x72, 0x01, 0x04, 0x01, // ŲĄ (U+0172 U+0104)
  0x01, 0x72, 0x20, 0x1A, 0x01, // Ų‚ (U+0172 U+201A)
  0x01, 0x72, 0x20, 0x1E, 0x01, // Ų„ (U+0172 U+201E)
  0x01, 0x72, 0x20, 0x26, 0x01, // Ų… (U+0172 U+2026)
  0x01, 0x74, 0x00, 0x2C, 0x05, // Ŵ, (U+0174 U+002C)
  0x01, 0x74, 0x00, 0x2E, 0x05, // Ŵ. (U+0174 U+002E)
  0x01, 0x74, 0x00, 0x40, 0x03, // Ŵ@ (U+0174 U+0040)
  0x01, 0x74, 0x00, 0x41, 0x03, // ŴA (U+0174 U+0041)
  0x01, 0x74, 0x00, 0x43, 0x01, // ŴC (U+0174 U+0043)
  0x01, 0x74, 0x00, 0x47, 0x01, // ŴG (U+0174 U+0047)
  0x01, 0x74, 0x00, 0x4F, 0x01, // ŴO (U+0174 U+004F)
  0x01, 0x74, 0x00, 0x51, 0x01, // ŴQ (U+0174 U+0051)
  0x01, 0x74, 0x00, 0x61, 0x04, // Ŵa (U+0174 U+0061)
  0x01, 0x74, 0x00, 0x63, 0x03, // Ŵc (U+0174 U+0063)
  0x01, 0x74, 0x00, 0x64, 0x03, // Ŵd (U+0174 U+0064)
  0x01, 0x74, 0x00, 0x65, 0x03, // Ŵe (U+0174 U+0065)
  0x01, 0x74, 0x00, 0x67, 0x03, // Ŵg (U+0174 U+0067)
  0x01, 0x74, 0x00, 0x6F, 0x03, // Ŵo (U+0174 U+006F)
  0x01, 0x74, 0x00, 0x71, 0x03, // Ŵq (U+0174 U+0071)
  0x01, 0x74, 0x00, 0x73, 0x03, // Ŵs (U+0174 U+0073)
  0x01, 0x74, 0x00, 0x7A, 0x02, // Ŵz (U+0174 U+007A)
  0x01, 0x74, 0x00, 0xC0, 0x03, // ŴÀ (U+0174 U+00C0)
  0x01, 0x74, 0x00, 0xC1, 0x03, // ŴÁ (U+0174 U+00C1)
  0x01, 0x74, 0x00, 0xC2, 0x03, // ŴÂ (U+0174 U+00C2)
  0x01, 0x74, 0x00, 0xC3, 0x03, // ŴÃ (U+0174 U+00C3)
  0x01, 0x74, 0x00, 0xC4, 0x03, // ŴÄ (U+0174 U+00C4)
  0x01, 0x74, 0x00, 0xC5, 0x03, // ŴÅ (U+0174 U+00C5)
  0x01, 0x74, 0x00, 0xC6, 0x06, // ŴÆ (U+0174 U+00C6)
  0x01, 0x74, 0x00, 0xC7, 0x01, // ŴÇ (U+0174 U+00C7)
  0x01, 0x74, 0x00, 0xD2, 0x01, // ŴÒ (U+0174 U+00D2)
  0x01, 0x74, 0x00, 0xD3, 0x01, // ŴÓ (U+0174 U+00D3)
  0x01, 0x74, 0x00, 0xD4, 0x01, // ŴÔ (U+0174 U+00D4)
  0x01, 0x74, 0x00, 0xD5, 0x01, // ŴÕ (U+0174 U+00D5)
  0x01, 0x74, 0x00, 0xD6, 0x01, // ŴÖ (U+0174 U+00D6)
  0x01, 0x74, 0x00, 0xD8, 0x01, // ŴØ (U+0174 U+00D8)
  0x01, 0x74, 0x00, 0xE0, 0x04, // Ŵà (U+0174 U+00E0)
  0x01, 0x74, 0x00, 0xE1, 0x04, // Ŵá (U+0174 U+00E1)
  0x01, 0x74, 0x00, 0xE2, 0x04, // Ŵâ (U+0174 U+00E2)
  0x01, 0x74, 0x00, 0xE3, 0x04, // Ŵã (U+0174 U+00E3)
  0x01, 0x74, 0x00, 0xE4, 0x04, // Ŵä (U+0174 U+00E4)
  0x01, 0x74, 0x00, 0xE5, 0x04, // Ŵå (U+0174 U+00E5)
  0x01, 0x74, 0x00, 0xE6, 0x04, // Ŵæ (U+0174 U+00E6)
  0x01, 0x74, 0x00, 0xE7, 0x03, // Ŵç (U+0174 U+00E7)
  0x01, 0x74, 0x00, 0xE8, 0x03, // Ŵè (U+0174 U+00E8)
  0x01, 0x74, 0x00, 0xE9, 0x03, // Ŵé (U+0174 U+00E9)
  0x01, 0x74, 0x00, 0xEA, 0x03, // Ŵê (U+0174 U+00EA)
  0x01, 0x74, 0x00, 0xEB, 0x03, // Ŵë (U+0174 U+00EB)
  0x01, 0x74, 0x00, 0xF0, 0x03, // Ŵð (U+0174 U+00F0)
  0x01, 0x74, 0x00, 0xF2, 0x03, // Ŵò (U+0174 U+00F2)
  0x01, 0x74, 0x00, 0xF3, 0x03, // Ŵó (U+0174 U+00F3)
  0x01, 0x74, 0x00, 0xF4, 0x03, // Ŵô (U+0174 U+00F4)
  0x01, 0x74, 0x00, 0xF5, 0x03, // Ŵõ (U+0174 U+00F5)
  0x01, 0x74, 0x00, 0xF6, 0x03, // Ŵö (U+0174 U+00F6)
  0x01, 0x74, 0x00, 0xF8, 0x03, // Ŵø (U+0174 U+00F8)
  0x01, 0x74, 0x01, 0x00, 0x03, // ŴĀ (U+0174 U+0100)
  0x01, 0x74, 0x01, 0x01, 0x04, // Ŵā (U+0174 U+0101)
  0x01, 0x74, 0x01, 0x02, 0x03, // ŴĂ (U+0174 U+0102)
  0x01, 0x74, 0x01, 0x03, 0x04, // Ŵă (U+0174 U+0103)
  0x01, 0x74, 0x01, 0x04, 0x03, // ŴĄ (U+0174 U+0104)
  0x01, 0x74, 0x01, 0x05, 0x04, // Ŵą (U+0174 U+0105)
  0x01, 0x74, 0x01, 0x06, 0x01, // ŴĆ (U+0174 U+0106)
  0x01, 0x74, 0x01, 0x07, 0x03, // Ŵć (U+0174 U+0107)
  0x01, 0x74, 0x01, 0x08, 0x01, // ŴĈ (U+0174 U+0108)
  0x01, 0x74, 0x01, 0x09, 0x03, // Ŵĉ (U+0174 U+0109)
  0x01, 0x74, 0x01, 0x0A, 0x01, // ŴĊ (U+0174 U+010A)
  0x01, 0x74, 0x01, 0x0B, 0x03, // Ŵċ (U+0174 U+010B)
  0x01, 0x74, 0x01, 0x0C, 0x01, // ŴČ (U+0174 U+010C)
  0x01, 0x74, 0x01, 0x0D, 0x03, // Ŵč (U+0174 U+010D)
  0x01, 0x74, 0x01, 0x0F, 0x03, // Ŵď (U+0174 U+010F)
  0x01, 0x74, 0x01, 0x11, 0x03, // Ŵđ (U+0174 U+0111)
  0x01, 0x74, 0x01, 0x13, 0x03, // Ŵē (U+0174 U+0113)
  0x01, 0x74, 0x01, 0x15, 0x03, // Ŵĕ (U+0174 U+0115)
  0x01, 0x74, 0x01, 0x17, 0x03, // Ŵė (U+0174 U+0117)
  0x01, 0x74, 0x01, 0x19, 0x03, // Ŵę (U+0174 U+0119)
  0x01, 0x74, 0x01, 0x1B, 0x03, // Ŵě (U+0174 U+011B)
  0x01, 0x74, 0x01, 0x1C, 0x01, // ŴĜ (U+0174 U+011C)
  0x01, 0x74, 0x01, 0x1D, 0x03, // Ŵĝ (U+0174 U+011D)
  0x01, 0x74, 0x01, 0x1E, 0x01, // ŴĞ (U+0174 U+011E)
  0x01, 0x74, 0x01, 0x1F, 0x03, // Ŵğ (U+0174 U+011F)
  0x01, 0x74, 0x01, 0x20, 0x01, // ŴĠ (U+0174 U+0120)
  0x01, 0x74, 0x01, 0x21, 0x03, // Ŵġ (U+0174 U+0121)
  0x01, 0x74, 0x01, 0x22, 0x01, // ŴĢ (U+0174 U+0122)
  0x01, 0x74, 0x01, 0x23, 0x03, // Ŵģ (U+0174 U+0123)
  0x01, 0x74, 0x01, 0x4C, 0x01, // ŴŌ (U+0174 U+014C)
  0x01, 0x74, 0x01, 0x4D, 0x03, // Ŵō (U+0174 U+014D)
  0x01, 0x74, 0x01, 0x4E, 0x01, // ŴŎ (U+0174 U+014E)
  0x01, 0x74, 0x01, 0x4F, 0x03, // Ŵŏ (U+0174 U+014F)
  0x01, 0x74, 0x01, 0x50, 0x01, // ŴŐ (U+0174 U+0150)
  0x01, 0x74, 0x01, 0x51, 0x03, // Ŵő (U+0174 U+0151)
  0x01, 0x74, 0x01, 0x52, 0x01, // ŴŒ (U+0174 U+0152)
  0x01, 0x74, 0x01, 0x53, 0x03, // Ŵœ (U+0174 U+0153)
  0x01, 0x74, 0x01, 0x5B, 0x03, // Ŵś (U+0174 U+015B)
  0x01, 0x74, 0x01, 0x5D, 0x03, // Ŵŝ (U+0174 U+015D)
  0x01, 0x74, 0x01, 0x5F, 0x03, // Ŵş (U+0174 U+015F)
  0x01, 0x74, 0x01, 0x61, 0x03, // Ŵš (U+0174 U+0161)
  0x01, 0x74, 0x01, 0x7A, 0x02, // Ŵź (U+0174 U+017A)
  0x01, 0x74, 0x01, 0x7C, 0x02, // Ŵż (U+0174 U+017C)
  0x01, 0x74, 0x01, 0x7E, 0x02, // Ŵž (U+0174 U+017E)
  0x01, 0x74, 0x20, 0x1A, 0x05, // Ŵ‚ (U+0174 U+201A)
  0x01, 0x74, 0x20, 0x1E, 0x05, // Ŵ„ (U+0174 U+201E)
  0x01, 0x74, 0x20, 0x26, 0x05, // Ŵ… (U+0174 U+2026)
  0x01, 0x75, 0x00, 0x2C, 0x03, // ŵ, (U+0175 U+002C)
  0x01, 0x75, 0x00, 0x2E, 0x03, // ŵ. (U+0175 U+002E)
  0x01, 0x75, 0x00, 0x41, 0x02, // ŵA (U+0175 U+0041)
  0x01, 0x75, 0x00, 0xC0, 0x02, // ŵÀ (U+0175 U+00C0)
  0x01, 0x75, 0x00, 0xC1, 0x02, // ŵÁ (U+0175 U+00C1)
  0x01, 0x75, 0x00, 0xC2, 0x02, // ŵÂ (U+0175 U+00C2)
  0x01, 0x75, 0x00, 0xC3, 0x02, // ŵÃ (U+0175 U+00C3)
  0x01, 0x75, 0x00, 0xC4, 0x02, // ŵÄ (U+0175 U+00C4)
  0x01, 0x75, 0x00, 0xC5, 0x02, // ŵÅ (U+0175 U+00C5)
  0x01, 0x75, 0x01, 0x00, 0x02, // ŵĀ (U+0175 U+0100)
  0x01, 0x75, 0x01, 0x02, 0x02, // ŵĂ (U+0175 U+0102)
  0x01, 0x75, 0x01, 0x04, 0x02, // ŵĄ (U+0175 U+0104)
  0x01, 0x75, 0x20, 0x1A, 0x03, // ŵ‚ (U+0175 U+201A)
  0x01, 0x75, 0x20, 0x1E, 0x03, // ŵ„ (U+0175 U+201E)
  0x01, 0x75, 0x20, 0x26, 0x03, // ŵ… (U+0175 U+2026)
  0x01, 0x76, 0x00, 0x26, 0x01, // Ŷ& (U+0176 U+0026)
  0x01, 0x76, 0x00, 0x2C, 0x04, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x04, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x00, 0x40, 0x02, // Ŷ@ (U+0176 U+0040)
  0x01, 0x76, 0x00, 0x41, 0x03, // ŶA (U+0176 U+0041)
  0x01, 0x76, 0x00, 0x43, 0x02, // ŶC (U+0176 U+0043)
  0x01, 0x76, 0x00, 0x47, 0x02, // ŶG (U+0176 U+0047)
  0x01, 0x76, 0x00, 0x4F, 0x02, // ŶO (U+0176 U+004F)
  0x01, 0x76, 0x00, 0x51, 0x02, // ŶQ (U+0176 U+0051)
  0x01, 0x76, 0x00, 0x53, 0x01, // ŶS (U+0176 U+0053)
  0x01, 0x76, 0x00, 0x61, 0x03, // Ŷa (U+0176 U+0061)
  0x01, 0x76, 0x00, 0x63, 0x03, // Ŷc (U+0176 U+0063)
  0x01, 0x76, 0x00, 0x64, 0x03, // Ŷd (U+0176 U+0064)
  0x01, 0x76, 0x00, 0x65, 0x03, // Ŷe (U+0176 U+0065)
  0x01, 0x76, 0x00, 0x67, 0x03, // Ŷg (U+0176 U+0067)
  0x01, 0x76, 0x00, 0x6F, 0x03, // Ŷo (U+0176 U+006F)
  0x01, 0x76, 0x00, 0x71, 0x03, // Ŷq (U+0176 U+0071)
  0x01, 0x76, 0x00, 0x73, 0x03, // Ŷs (U+0176 U+0073)
  0x01, 0x76, 0x00, 0x7A, 0x01, // Ŷz (U+0176 U+007A)
  0x01, 0x76, 0x00, 0xC0, 0x03, // ŶÀ (U+0176 U+00C0)
  0x01, 0x76, 0x00, 0xC1, 0x03, // ŶÁ (U+0176 U+00C1)
  0x01, 0x76, 0x00, 0xC2, 0x03, // ŶÂ (U+0176 U+00C2)
  0x01, 0x76, 0x00, 0xC3, 0x03, // ŶÃ (U+0176 U+00C3)
  0x01, 0x76, 0x00, 0xC4, 0x03, // ŶÄ (U+0176 U+00C4)
  0x01, 0x76, 0x00, 0xC5, 0x03, // ŶÅ (U+0176 U+00C5)
  0x01, 0x76, 0x00, 0xC6, 0x04, // ŶÆ (U+0176 U+00C6)
  0x01, 0x76, 0x00, 0xC7, 0x02, // ŶÇ (U+0176 U+00C7)
  0x01, 0x76, 0x00, 0xD2, 0x02, // ŶÒ (U+0176 U+00D2)
  0x01, 0x76, 0x00, 0xD3, 0x02, // ŶÓ (U+0176 U+00D3)
  0x01, 0x76, 0x00, 0xD4, 0x02, // ŶÔ (U+0176 U+00D4)
  0x01, 0x76, 0x00, 0xD5, 0x02, // ŶÕ (U+0176 U+00D5)
  0x01, 0x76, 0x00, 0xD6, 0x02, // ŶÖ (U+0176 U+00D6)
  0x01, 0x76, 0x00, 0xD8, 0x02, // ŶØ (U+0176 U+00D8)
  0x01, 0x76, 0x00, 0xE0, 0x03, // Ŷà (U+0176 U+00E0)
  0x01, 0x76, 0x00, 0xE1, 0x03, // Ŷá (U+0176 U+00E1)
  0x01, 0x76, 0x00, 0xE2, 0x03, // Ŷâ (U+0176 U+00E2)
  0x01, 0x76, 0x00, 0xE3, 0x03, // Ŷã (U+0176 U+00E3)
  0x01, 0x76, 0x00, 0xE4, 0x03, // Ŷä (U+0176 U+00E4)
  0x01, 0x76, 0x00, 0xE5, 0x03, // Ŷå (U+0176 U+00E5)
  0x01, 0x76, 0x00, 0xE6, 0x03, // Ŷæ (U+0176 U+00E6)
  0x01, 0x76, 0x00, 0xE7, 0x03, // Ŷç (U+0176 U+00E7)
  0x01, 0x76, 0x00, 0xE8, 0x03, // Ŷè (U+0176 U+00E8)
  0x01, 0x76, 0x00, 0xE9, 0x03, // Ŷé (U+0176 U+00E9)
  0x01, 0x76, 0x00, 0xEA, 0x03, // Ŷê (U+0176 U+00EA)
  0x01, 0x76, 0x00, 0xEB, 0x03, // Ŷë (U+0176 U+00EB)
  0x01, 0x76, 0x00, 0xF0, 0x03, // Ŷð (U+0176 U+00F0)
  0x01, 0x76, 0x00, 0xF2, 0x03, // Ŷò (U+0176 U+00F2)
  0x01, 0x76, 0x00, 0xF3, 0x03, // Ŷó (U+0176 U+00F3)
  0x01, 0x76, 0x00, 0xF4, 0x03, // Ŷô (U+0176 U+00F4)
  0x01, 0x76, 0x00, 0xF5, 0x03, // Ŷõ (U+0176 U+00F5)
  0x01, 0x76, 0x00, 0xF6, 0x03, // Ŷö (U+0176 U+00F6)
  0x01, 0x76, 0x00, 0xF8, 0x03, // Ŷø (U+0176 U+00F8)
  0x01, 0x76, 0x01, 0x00, 0x03, // ŶĀ (U+0176 U+0100)
  0x01, 0x76, 0x01, 0x01, 0x03, // Ŷā (U+0176 U+0101)
  0x01, 0x76, 0x01, 0x02, 0x03, // ŶĂ (U+0176 U+0102)
  0x01, 0x76, 0x01, 0x03, 0x03, // Ŷă (U+0176 U+0103)
  0x01, 0x76, 0x01, 0x04, 0x03, // ŶĄ (U+0176 U+0104)
  0x01, 0x76, 0x01, 0x05, 0x03, // Ŷą (U+0176 U+0105)
  0x01, 0x76, 0x01, 0x06, 0x02, // ŶĆ (U+0176 U+0106)
  0x01, 0x76, 0x01, 0x07, 0x03, // Ŷć (U+0176 U+0107)
  0x01, 0x76, 0x01, 0x08, 0x02, // ŶĈ (U+0176 U+0108)
  0x01, 0x76, 0x01, 0x09, 0x03, // Ŷĉ (U+0176 U+0109)
  0x01, 0x76, 0x01, 0x0A, 0x02, // ŶĊ (U+0176 U+010A)
  0x01, 0x76, 0x01, 0x0B, 0x03, // Ŷċ (U+0176 U+010B)
  0x01, 0x76, 0x01, 0x0C, 0x02, // ŶČ (U+0176 U+010C)
  0x01, 0x76, 0x01, 0x0D, 0x03, // Ŷč (U+0176 U+010D)
  0x01, 0x76, 0x01, 0x0F, 0x03, // Ŷď (U+0176 U+010F)
  0x01, 0x76, 0x01, 0x11, 0x03, // Ŷđ (U+0176 U+0111)
  0x01, 0x76, 0x01, 0x13, 0x03, // Ŷē (U+0176 U+0113)
  0x01, 0x76, 0x01, 0x15, 0x03, // Ŷĕ (U+0176 U+0115)
  0x01, 0x76, 0x01, 0x17, 0x03, // Ŷė (U+0176 U+0117)
  0x01, 0x76, 0x01, 0x19, 0x03, // Ŷę (U+0176 U+0119)
  0x01, 0x76, 0x01, 0x1B, 0x03, // Ŷě (U+0176 U+011B)
  0x01, 0x76, 0x01, 0x1C, 0x02, // ŶĜ (U+0176 U+011C)
  0x01, 0x76, 0x01, 0x1D, 0x03, // Ŷĝ (U+0176 U+011D)
  0x01, 0x76, 0x01, 0x1E, 0x02, // ŶĞ (U+0176 U+011E)
  0x01, 0x76, 0x01, 0x1F, 0x03, // Ŷğ (U+0176 U+011F)
  0x01, 0x76, 0x01, 0x20, 0x02, // ŶĠ (U+0176 U+0120)
  0x01, 0x76, 0x01, 0x21, 0x03, // Ŷġ (U+0176 U+0121)
  0x01, 0x76, 0x01, 0x22, 0x02, // ŶĢ (U+0176 U+0122)
  0x01, 0x76, 0x01, 0x23, 0x03, // Ŷģ (U+0176 U+0123)
  0x01, 0x76, 0x01, 0x4C, 0x02, // ŶŌ (U+0176 U+014C)
  0x01, 0x76, 0x01, 0x4D, 0x03, // Ŷō (U+0176 U+014D)
  0x01, 0x76, 0x01, 0x4E, 0x02, // ŶŎ (U+0176 U+014E)
  0x01, 0x76, 0x01, 0x4F, 0x03, // Ŷŏ (U+0176 U+014F)
  0x01, 0x76, 0x01, 0x50, 0x02, // ŶŐ (U+0176 U+0150)
  0x01, 0x76, 0x01, 0x51, 0x03, // Ŷő (U+0176 U+0151)
  0x01, 0x76, 0x01, 0x52, 0x02, // ŶŒ (U+0176 U+0152)
  0x01, 0x76, 0x01, 0x53, 0x03, // Ŷœ (U+0176 U+0153)
  0x01, 0x76, 0x01, 0x5A, 0x01, // ŶŚ (U+0176 U+015A)
  0x01, 0x76, 0x01, 0x5B, 0x03, // Ŷś (U+0176 U+015B)
  0x01, 0x76, 0x01, 0x5C, 0x01, // ŶŜ (U+0176 U+015C)
  0x01, 0x76, 0x01, 0x5D, 0x03, // Ŷŝ (U+0176 U+015D)
  0x01, 0x76, 0x01, 0x5E, 0x01, // ŶŞ (U+0176 U+015E)
  0x01, 0x76, 0x01, 0x5F, 0x03, // Ŷş (U+0176 U+015F)
  0x01, 0x76, 0x01, 0x60, 0x01, // ŶŠ (U+0176 U+0160)
  0x01, 0x76, 0x01, 0x61, 0x03, // Ŷš (U+0176 U+0161)
  0x01, 0x76, 0x01, 0x7A, 0x01, // Ŷź (U+0176 U+017A)
  0x01, 0x76, 0x01, 0x7C, 0x01, // Ŷż (U+0176 U+017C)
  0x01, 0x76, 0x01, 0x7E, 0x01, // Ŷž (U+0176 U+017E)
  0x01, 0x76, 0x20, 0x1A, 0x04, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x04, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x04, // Ŷ… (U+0176 U+2026)
  0x01, 0x77, 0x00, 0x2C, 0x05, // ŷ, (U+0177 U+002C)
  0x01, 0x77, 0x00, 0x2E, 0x05, // ŷ. (U+0177 U+002E)
  0x01, 0x77, 0x00, 0x41, 0x03, // ŷA (U+0177 U+0041)
  0x01, 0x77, 0x00, 0xC0, 0x03, // ŷÀ (U+0177 U+00C0)
  0x01, 0x77, 0x00, 0xC1, 0x03, // ŷÁ (U+0177 U+00C1)
  0x01, 0x77, 0x00, 0xC2, 0x03, // ŷÂ (U+0177 U+00C2)
  0x01, 0x77, 0x00, 0xC3, 0x03, // ŷÃ (U+0177 U+00C3)
  0x01, 0x77, 0x00, 0xC4, 0x03, // ŷÄ (U+0177 U+00C4)
  0x01, 0x77, 0x00, 0xC5, 0x03, // ŷÅ (U+0177 U+00C5)
  0x01, 0x77, 0x01, 0x00, 0x03, // ŷĀ (U+0177 U+0100)
  0x01, 0x77, 0x01, 0x02, 0x03, // ŷĂ (U+0177 U+0102)
  0x01, 0x77, 0x01, 0x04, 0x03, // ŷĄ (U+0177 U+0104)
  0x01, 0x77, 0x20, 0x1A, 0x05, // ŷ‚ (U+0177 U+201A)
  0x01, 0x77, 0x20, 0x1E, 0x05, // ŷ„ (U+0177 U+201E)
  0x01, 0x77, 0x20, 0x26, 0x05, // ŷ… (U+0177 U+2026)
  0x01, 0x78, 0x00, 0x26, 0x01, // Ÿ& (U+0178 U+0026)
  0x01, 0x78, 0x00, 0x2C, 0x04, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x04, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x00, 0x40, 0x02, // Ÿ@ (U+0178 U+0040)
  0x01, 0x78, 0x00, 0x41, 0x03, // ŸA (U+0178 U+0041)
  0x01, 0x78, 0x00, 0x43, 0x02, // ŸC (U+0178 U+0043)
  0x01, 0x78, 0x00, 0x47, 0x02, // ŸG (U+0178 U+0047)
  0x01, 0x78, 0x00, 0x4F, 0x02, // ŸO (U+0178 U+004F)
  0x01, 0x78, 0x00, 0x51, 0x02, // ŸQ (U+0178 U+0051)
  0x01, 0x78, 0x00, 0x53, 0x01, // ŸS (U+0178 U+0053)
  0x01, 0x78, 0x00, 0x61, 0x03, // Ÿa (U+0178 U+0061)
  0x01, 0x78, 0x00, 0x63, 0x03, // Ÿc (U+0178 U+0063)
  0x01, 0x78, 0x00, 0x64, 0x03, // Ÿd (U+0178 U+0064)
  0x01, 0x78, 0x00, 0x65, 0x03, // Ÿe (U+0178 U+0065)
  0x01, 0x78, 0x00, 0x67, 0x03, // Ÿg (U+0178 U+0067)
  0x01, 0x78, 0x00, 0x6F, 0x03, // Ÿo (U+0178 U+006F)
  0x01, 0x78, 0x00, 0x71, 0x03, // Ÿq (U+0178 U+0071)
  0x01, 0x78, 0x00, 0x73, 0x03, // Ÿs (U+0178 U+0073)
  0x01, 0x78, 0x00, 0x7A, 0x01, // Ÿz (U+0178 U+007A)
  0x01, 0x78, 0x00, 0xC0, 0x03, // ŸÀ (U+0178 U+00C0)
  0x01, 0x78, 0x00, 0xC1, 0x03, // ŸÁ (U+0178 U+00C1)
  0x01, 0x78, 0x00, 0xC2, 0x03, // ŸÂ (U+0178 U+00C2)
  0x01, 0x78, 0x00, 0xC3, 0x03, // ŸÃ (U+0178 U+00C3)
  0x01, 0x78, 0x00, 0xC4, 0x03, // ŸÄ (U+0178 U+00C4)
  0x01, 0x78, 0x00, 0xC5, 0x03, // ŸÅ (U+0178 U+00C5)
  0x01, 0x78, 0x00, 0xC6, 0x04, // ŸÆ (U+0178 U+00C6)
  0x01, 0x78, 0x00, 0xC7, 0x02, // ŸÇ (U+0178 U+00C7)
  0x01, 0x78, 0x00, 0xD2, 0x02, // ŸÒ (U+0178 U+00D2)
  0x01, 0x78, 0x00, 0xD3, 0x02, // ŸÓ (U+0178 U+00D3)
  0x01, 0x78, 0x00, 0xD4, 0x02, // ŸÔ (U+0178 U+00D4)
  0x01, 0x78, 0x00, 0xD5, 0x02, // ŸÕ (U+0178 U+00D5)
  0x01, 0x78, 0x00, 0xD6, 0x02, // ŸÖ (U+0178 U+00D6)
  0x01, 0x78, 0x00, 0xD8, 0x02, // ŸØ (U+0178 U+00D8)
  0x01, 0x78, 0x00, 0xE0, 0x03, // Ÿà (U+0178 U+00E0)
  0x01, 0x78, 0x00, 0xE1, 0x03, // Ÿá (U+0178 U+00E1)
  0x01, 0x78, 0x00, 0xE2, 0x03, // Ÿâ (U+0178 U+00E2)
  0x01, 0x78, 0x00, 0xE3, 0x03, // Ÿã (U+0178 U+00E3)
  0x01, 0x78, 0x00, 0xE4, 0x03, // Ÿä (U+0178 U+00E4)
  0x01, 0x78, 0x00, 0xE5, 0x03, // Ÿå (U+0178 U+00E5)
  0x01, 0x78, 0x00, 0xE6, 0x03, // Ÿæ (U+0178 U+00E6)
  0x01, 0x78, 0x00, 0xE7, 0x03, // Ÿç (U+0178 U+00E7)
  0x01, 0x78, 0x00, 0xE8, 0x03, // Ÿè (U+0178 U+00E8)
  0x01, 0x78, 0x00, 0xE9, 0x03, // Ÿé (U+0178 U+00E9)
  0x01, 0x78, 0x00, 0xEA, 0x03, // Ÿê (U+0178 U+00EA)
  0x01, 0x78, 0x00, 0xEB, 0x03, // Ÿë (U+0178 U+00EB)
  0x01, 0x78, 0x00, 0xF0, 0x03, // Ÿð (U+0178 U+00F0)
  0x01, 0x78, 0x00, 0xF2, 0x03, // Ÿò (U+0178 U+00F2)
  0x01, 0x78, 0x00, 0xF3, 0x03, // Ÿó (U+0178 U+00F3)
  0x01, 0x78, 0x00, 0xF4, 0x03, // Ÿô (U+0178 U+00F4)
  0x01, 0x78, 0x00, 0xF5, 0x03, // Ÿõ (U+0178 U+00F5)
  0x01, 0x78, 0x00, 0xF6, 0x03, // Ÿö (U+0178 U+00F6)
  0x01, 0x78, 0x00, 0xF8, 0x03, // Ÿø (U+0178 U+00F8)
  0x01, 0x78, 0x01, 0x00, 0x03, // ŸĀ (U+0178 U+0100)
  0x01, 0x78, 0x01, 0x01, 0x03, // Ÿā (U+0178 U+0101)
  0x01, 0x78, 0x01, 0x02, 0x03, // ŸĂ (U+0178 U+0102)
  0x01, 0x78, 0x01, 0x03, 0x03, // Ÿă (U+0178 U+0103)
  0x01, 0x78, 0x01, 0x04, 0x03, // ŸĄ (U+0178 U+0104)
  0x01, 0x78, 0x01, 0x05, 0x03, // Ÿą (U+0178 U+0105)
  0x01, 0x78, 0x01, 0x06, 0x02, // ŸĆ (U+0178 U+0106)
  0x01, 0x78, 0x01, 0x07, 0x03, // Ÿć (U+0178 U+0107)
  0x01, 0x78, 0x01, 0x08, 0x02, // ŸĈ (U+0178 U+0108)
  0x01, 0x78, 0x01, 0x09, 0x03, // Ÿĉ (U+0178 U+0109)
  0x01, 0x78, 0x01, 0x0A, 0x02, // ŸĊ (U+0178 U+010A)
  0x01, 0x78, 0x01, 0x0B, 0x03, // Ÿċ (U+0178 U+010B)
  0x01, 0x78, 0x01, 0x0C, 0x02, // ŸČ (U+0178 U+010C)
  0x01, 0x78, 0x01, 0x0D, 0x03, // Ÿč (U+0178 U+010D)
  0x01, 0x78, 0x01, 0x0F, 0x03, // Ÿď (U+0178 U+010F)
  0x01, 0x78, 0x01, 0x11, 0x03, // Ÿđ (U+0178 U+0111)
  0x01, 0x78, 0x01, 0x13, 0x03, // Ÿē (U+0178 U+0113)
  0x01, 0x78, 0x01, 0x15, 0x03, // Ÿĕ (U+0178 U+0115)
  0x01, 0x78, 0x01, 0x17, 0x03, // Ÿė (U+0178 U+0117)
  0x01, 0x78, 0x01, 0x19, 0x03, // Ÿę (U+0178 U+0119)
  0x01, 0x78, 0x01, 0x1B, 0x03, // Ÿě (U+0178 U+011B)
  0x01, 0x78, 0x01, 0x1C, 0x02, // ŸĜ (U+0178 U+011C)
  0x01, 0x78, 0x01, 0x1D, 0x03, // Ÿĝ (U+0178 U+011D)
  0x01, 0x78, 0x01, 0x1E, 0x02, // ŸĞ (U+0178 U+011E)
  0x01, 0x78, 0x01, 0x1F, 0x03, // Ÿğ (U+0178 U+011F)
  0x01, 0x78, 0x01, 0x20, 0x02, // ŸĠ (U+0178 U+0120)
  0x01, 0x78, 0x01, 0x21, 0x03, // Ÿġ (U+0178 U+0121)
  0x01, 0x78, 0x01, 0x22, 0x02, // ŸĢ (U+0178 U+0122)
  0x01, 0x78, 0x01, 0x23, 0x03, // Ÿģ (U+0178 U+0123)
  0x01, 0x78, 0x01, 0x4C, 0x02, // ŸŌ (U+0178 U+014C)
  0x01, 0x78, 0x01, 0x4D, 0x03, // Ÿō (U+0178 U+014D)
  0x01, 0x78, 0x01, 0x4E, 0x02, // ŸŎ (U+0178 U+014E)
  0x01, 0x78, 0x01, 0x4F, 0x03, // Ÿŏ (U+0178 U+014F)
  0x01, 0x78, 0x01, 0x50, 0x02, // ŸŐ (U+0178 U+0150)
  0x01, 0x78, 0x01, 0x51, 0x03, // Ÿő (U+0178 U+0151)
  0x01, 0x78, 0x01, 0x52, 0x02, // ŸŒ (U+0178 U+0152)
  0x01, 0x78, 0x01, 0x53, 0x03, // Ÿœ (U+0178 U+0153)
  0x01, 0x78, 0x01, 0x5A, 0x01, // ŸŚ (U+0178 U+015A)
  0x01, 0x78, 0x01, 0x5B, 0x03, // Ÿś (U+0178 U+015B)
  0x01, 0x78, 0x01, 0x5C, 0x01, // ŸŜ (U+0178 U+015C)
  0x01, 0x78, 0x01, 0x5D, 0x03, // Ÿŝ (U+0178 U+015D)
  0x01, 0x78, 0x01, 0x5E, 0x01, // ŸŞ (U+0178 U+015E)
  0x01, 0x78, 0x01, 0x5F, 0x03, // Ÿş (U+0178 U+015F)
  0x01, 0x78, 0x01, 0x60, 0x01, // ŸŠ (U+0178 U+0160)
  0x01, 0x78, 0x01, 0x61, 0x03, // Ÿš (U+0178 U+0161)
  0x01, 0x78, 0x01, 0x7A, 0x01, // Ÿź (U+0178 U+017A)
  0x01, 0x78, 0x01, 0x7C, 0x01, // Ÿż (U+0178 U+017C)
  0x01, 0x78, 0x01, 0x7E, 0x01, // Ÿž (U+0178 U+017E)
  0x01, 0x78, 0x20, 0x1A, 0x04, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x04, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x04, // Ÿ… (U+0178 U+2026)
  0x20, 0x18, 0x00, 0x41, 0x04, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0xC0, 0x04, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x04, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x04, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x04, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x04, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x04, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xC6, 0x08, // ‘Æ (U+2018 U+00C6)
  0x20, 0x18, 0x01, 0x00, 0x04, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x02, 0x04, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x04, 0x04, // ‘Ą (U+2018 U+0104)
  0x20, 0x19, 0x00, 0x41, 0x06, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0x43, 0x01, // ’C (U+2019 U+0043)
  0x20, 0x19, 0x00, 0x47, 0x01, // ’G (U+2019 U+0047)
  0x20, 0x19, 0x00, 0x4F, 0x01, // ’O (U+2019 U+004F)
  0x20, 0x19, 0x00, 0x51, 0x01, // ’Q (U+2019 U+0051)
  0x20, 0x19, 0x00, 0x61, 0x02, // ’a (U+2019 U+0061)
  0x20, 0x19, 0x00, 0x63, 0x02, // ’c (U+2019 U+0063)
  0x20, 0x19, 0x00, 0x64, 0x02, // ’d (U+2019 U+0064)
  0x20, 0x19, 0x00, 0x65, 0x02, // ’e (U+2019 U+0065)
  0x20, 0x19, 0x00, 0x67, 0x02, // ’g (U+2019 U+0067)
  0x20, 0x19, 0x00, 0x6F, 0x02, // ’o (U+2019 U+006F)
  0x20, 0x19, 0x00, 0x71, 0x02, // ’q (U+2019 U+0071)
  0x20, 0x19, 0x00, 0x73, 0x03, // ’s (U+2019 U+0073)
  0x20, 0x19, 0x00, 0xC0, 0x06, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x06, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x06, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x06, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x06, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x06, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xC6, 0x05, // ’Æ (U+2019 U+00C6)
  0x20, 0x19, 0x00, 0xC7, 0x01, // ’Ç (U+2019 U+00C7)
  0x20, 0x19, 0x00, 0xD2, 0x01, // ’Ò (U+2019 U+00D2)
  0x20, 0x19, 0x00, 0xD3, 0x01, // ’Ó (U+2019 U+00D3)
  0x20, 0x19, 0x00, 0xD4, 0x01, // ’Ô (U+2019 U+00D4)
  0x20, 0x19, 0x00, 0xD5, 0x01, // ’Õ (U+2019 U+00D5)
  0x20, 0x19, 0x00, 0xD6, 0x01, // ’Ö (U+2019 U+00D6)
  0x20, 0x19, 0x00, 0xD8, 0x01, // ’Ø (U+2019 U+00D8)
  0x20, 0x19, 0x00, 0xE0, 0x02, // ’à (U+2019 U+00E0)
  0x20, 0x19, 0x00, 0xE1, 0x02, // ’á (U+2019 U+00E1)
  0x20, 0x19, 0x00, 0xE2, 0x02, // ’â (U+2019 U+00E2)
  0x20, 0x19, 0x00, 0xE3, 0x02, // ’ã (U+2019 U+00E3)
  0x20, 0x19, 0x00, 0xE4, 0x02, // ’ä (U+2019 U+00E4)
  0x20, 0x19, 0x00, 0xE5, 0x02, // ’å (U+2019 U+00E5)
  0x20, 0x19, 0x00, 0xE6, 0x02, // ’æ (U+2019 U+00E6)
  0x20, 0x19, 0x00, 0xE7, 0x02, // ’ç (U+2019 U+00E7)
  0x20, 0x19, 0x00, 0xE8, 0x02, // ’è (U+2019 U+00E8)
  0x20, 0x19, 0x00, 0xE9, 0x02, // ’é (U+2019 U+00E9)
  0x20, 0x19, 0x00, 0xEA, 0x02, // ’ê (U+2019 U+00EA)
  0x20, 0x19, 0x00, 0xEB, 0x02, // ’ë (U+2019 U+00EB)
  0x20, 0x19, 0x00, 0xF0, 0x02, // ’ð (U+2019 U+00F0)
  0x20, 0x19, 0x00, 0xF2, 0x02, // ’ò (U+2019 U+00F2)
  0x20, 0x19, 0x00, 0xF3, 0x02, // ’ó (U+2019 U+00F3)
  0x20, 0x19, 0x00, 0xF4, 0x02, // ’ô (U+2019 U+00F4)
  0x20, 0x19, 0x00, 0xF5, 0x02, // ’õ (U+2019 U+00F5)
  0x20, 0x19, 0x00, 0xF6, 0x02, // ’ö (U+2019 U+00F6)
  0x20, 0x19, 0x00, 0xF8, 0x02, // ’ø (U+2019 U+00F8)
  0x20, 0x19, 0x01, 0x00, 0x06, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x01, 0x02, // ’ā (U+2019 U+0101)
  0x20, 0x19, 0x01, 0x02, 0x06, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x03, 0x02, // ’ă (U+2019 U+0103)
  0x20, 0x19, 0x01, 0x04, 0x06, // ’Ą (U+2019 U+0104)
  0x20, 0x19, 0x01, 0x05, 0x02, // ’ą (U+2019 U+0105)
  0x20, 0x19, 0x01, 0x06, 0x01, // ’Ć (U+2019 U+0106)
  0x20, 0x19, 0x01, 0x07, 0x02, // ’ć (U+2019 U+0107)
  0x20, 0x19, 0x01, 0x08, 0x01, // ’Ĉ (U+2019 U+0108)
  0x20, 0x19, 0x01, 0x09, 0x02, // ’ĉ (U+2019 U+0109)
  0x20, 0x19, 0x01, 0x0A, 0x01, // ’Ċ (U+2019 U+010A)
  0x20, 0x19, 0x01, 0x0B, 0x02, // ’ċ (U+2019 U+010B)
  0x20, 0x19, 0x01, 0x0C, 0x01, // ’Č (U+2019 U+010C)
  0x20, 0x19, 0x01, 0x0D, 0x02, // ’č (U+2019 U+010D)
  0x20, 0x19, 0x01, 0x0F, 0x02, // ’ď (U+2019 U+010F)
  0x20, 0x19, 0x01, 0x11, 0x02, // ’đ (U+2019 U+0111)
  0x20, 0x19, 0x01, 0x13, 0x02, // ’ē (U+2019 U+0113)
  0x20, 0x19, 0x01, 0x15, 0x02, // ’ĕ (U+2019 U+0115)
  0x20, 0x19, 0x01, 0x17, 0x02, // ’ė (U+2019 U+0117)
  0x20, 0x19, 0x01, 0x19, 0x02, // ’ę (U+2019 U+0119)
  0x20, 0x19, 0x01, 0x1B, 0x02, // ’ě (U+2019 U+011B)
  0x20, 0x19, 0x01, 0x1C, 0x01, // ’Ĝ (U+2019 U+011C)
  0x20, 0x19, 0x01, 0x1D, 0x02, // ’ĝ (U+2019 U+011D)
  0x20, 0x19, 0x01, 0x1E, 0x01, // ’Ğ (U+2019 U+011E)
  0x20, 0x19, 0x01, 0x1F, 0x02, // ’ğ (U+2019 U+011F)
  0x20, 0x19, 0x01, 0x20, 0x01, // ’Ġ (U+2019 U+0120)
  0x20, 0x19, 0x01, 0x21, 0x02, // ’ġ (U+2019 U+0121)
  0x20, 0x19, 0x01, 0x22, 0x01, // ’Ģ (U+2019 U+0122)
  0x20, 0x19, 0x01, 0x23, 0x02, // ’ģ (U+2019 U+0123)
  0x20, 0x19, 0x01, 0x4C, 0x01, // ’Ō (U+2019 U+014C)
  0x20, 0x19, 0x01, 0x4D, 0x02, // ’ō (U+2019 U+014D)
  0x20, 0x19, 0x01, 0x4E, 0x01, // ’Ŏ (U+2019 U+014E)
  0x20, 0x19, 0x01, 0x4F, 0x02, // ’ŏ (U+2019 U+014F)
  0x20, 0x19, 0x01, 0x50, 0x01, // ’Ő (U+2019 U+0150)
  0x20, 0x19, 0x01, 0x51, 0x02, // ’ő (U+2019 U+0151)
  0x20, 0x19, 0x01, 0x52, 0x01, // ’Œ (U+2019 U+0152)
  0x20, 0x19, 0x01, 0x53, 0x02, // ’œ (U+2019 U+0153)
  0x20, 0x19, 0x01, 0x5B, 0x03, // ’ś (U+2019 U+015B)
  0x20, 0x19, 0x01, 0x5D, 0x03, // ’ŝ (U+2019 U+015D)
  0x20, 0x19, 0x01, 0x5F, 0x03, // ’ş (U+2019 U+015F)
  0x20, 0x19, 0x01, 0x61, 0x03, // ’š (U+2019 U+0161)
  0x20, 0x1A, 0x00, 0x3F, 0x04, // ‚? (U+201A U+003F)
  0x20, 0x1A, 0x00, 0x43, 0x01, // ‚C (U+201A U+0043)
  0x20, 0x1A, 0x00, 0x47, 0x01, // ‚G (U+201A U+0047)
  0x20, 0x1A, 0x00, 0x4F, 0x01, // ‚O (U+201A U+004F)
  0x20, 0x1A, 0x00, 0x51, 0x01, // ‚Q (U+201A U+0051)
  0x20, 0x1A, 0x00, 0x54, 0x04, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x55, 0x01, // ‚U (U+201A U+0055)
  0x20, 0x1A, 0x00, 0x56, 0x06, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x05, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x04, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0x75, 0x01, // ‚u (U+201A U+0075)
  0x20, 0x1A, 0x00, 0x76, 0x04, // ‚v (U+201A U+0076)
  0x20, 0x1A, 0x00, 0x77, 0x03, // ‚w (U+201A U+0077)
  0x20, 0x1A, 0x00, 0x79, 0x03, // ‚y (U+201A U+0079)
  0x20, 0x1A, 0x00, 0xC7, 0x01, // ‚Ç (U+201A U+00C7)
  0x20, 0x1A, 0x00, 0xD2, 0x01, // ‚Ò (U+201A U+00D2)
  0x20, 0x1A, 0x00, 0xD3, 0x01, // ‚Ó (U+201A U+00D3)
  0x20, 0x1A, 0x00, 0xD4, 0x01, // ‚Ô (U+201A U+00D4)
  0x20, 0x1A, 0x00, 0xD5, 0x01, // ‚Õ (U+201A U+00D5)
  0x20, 0x1A, 0x00, 0xD6, 0x01, // ‚Ö (U+201A U+00D6)
  0x20, 0x1A, 0x00, 0xD8, 0x01, // ‚Ø (U+201A U+00D8)
  0x20, 0x1A, 0x00, 0xD9, 0x01, // ‚Ù (U+201A U+00D9)
  0x20, 0x1A, 0x00, 0xDA, 0x01, // ‚Ú (U+201A U+00DA)
  0x20, 0x1A, 0x00, 0xDB, 0x01, // ‚Û (U+201A U+00DB)
  0x20, 0x1A, 0x00, 0xDC, 0x01, // ‚Ü (U+201A U+00DC)
  0x20, 0x1A, 0x00, 0xDD, 0x04, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x00, 0xF9, 0x01, // ‚ù (U+201A U+00F9)
  0x20, 0x1A, 0x00, 0xFA, 0x01, // ‚ú (U+201A U+00FA)
  0x20, 0x1A, 0x00, 0xFB, 0x01, // ‚û (U+201A U+00FB)
  0x20, 0x1A, 0x00, 0xFC, 0x01, // ‚ü (U+201A U+00FC)
  0x20, 0x1A, 0x00, 0xFD, 0x03, // ‚ý (U+201A U+00FD)
  0x20, 0x1A, 0x00, 0xFF, 0x03, // ‚ÿ (U+201A U+00FF)
  0x20, 0x1A, 0x01, 0x06, 0x01, // ‚Ć (U+201A U+0106)
  0x20, 0x1A, 0x01, 0x08, 0x01, // ‚Ĉ (U+201A U+0108)
  0x20, 0x1A, 0x01, 0x0A, 0x01, // ‚Ċ (U+201A U+010A)
  0x20, 0x1A, 0x01, 0x0C, 0x01, // ‚Č (U+201A U+010C)
  0x20, 0x1A, 0x01, 0x1C, 0x01, // ‚Ĝ (U+201A U+011C)
  0x20, 0x1A, 0x01, 0x1E, 0x01, // ‚Ğ (U+201A U+011E)
  0x20, 0x1A, 0x01, 0x20, 0x01, // ‚Ġ (U+201A U+0120)
  0x20, 0x1A, 0x01, 0x22, 0x01, // ‚Ģ (U+201A U+0122)
  0x20, 0x1A, 0x01, 0x4C, 0x01, // ‚Ō (U+201A U+014C)
  0x20, 0x1A, 0x01, 0x4E, 0x01, // ‚Ŏ (U+201A U+014E)
  0x20, 0x1A, 0x01, 0x50, 0x01, // ‚Ő (U+201A U+0150)
  0x20, 0x1A, 0x01, 0x52, 0x01, // ‚Œ (U+201A U+0152)
  0x20, 0x1A, 0x01, 0x62, 0x04, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x04, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x04, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1A, 0x01, 0x68, 0x01, // ‚Ũ (U+201A U+0168)
  0x20, 0x1A, 0x01, 0x69, 0x01, // ‚ũ (U+201A U+0169)
  0x20, 0x1A, 0x01, 0x6A, 0x01, // ‚Ū (U+201A U+016A)
  0x20, 0x1A, 0x01, 0x6B, 0x01, // ‚ū (U+201A U+016B)
  0x20, 0x1A, 0x01, 0x6C, 0x01, // ‚Ŭ (U+201A U+016C)
  0x20, 0x1A, 0x01, 0x6D, 0x01, // ‚ŭ (U+201A U+016D)
  0x20, 0x1A, 0x01, 0x6E, 0x01, // ‚Ů (U+201A U+016E)
  0x20, 0x1A, 0x01, 0x6F, 0x01, // ‚ů (U+201A U+016F)
  0x20, 0x1A, 0x01, 0x70, 0x01, // ‚Ű (U+201A U+0170)
  0x20, 0x1A, 0x01, 0x71, 0x01, // ‚ű (U+201A U+0171)
  0x20, 0x1A, 0x01, 0x72, 0x01, // ‚Ų (U+201A U+0172)
  0x20, 0x1A, 0x01, 0x73, 0x01, // ‚ų (U+201A U+0173)
  0x20, 0x1A, 0x01, 0x74, 0x05, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x75, 0x03, // ‚ŵ (U+201A U+0175)
  0x20, 0x1A, 0x01, 0x76, 0x04, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x77, 0x03, // ‚ŷ (U+201A U+0177)
  0x20, 0x1A, 0x01, 0x78, 0x04, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x04, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0xC0, 0x04, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x04, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x04, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x04, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x04, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x04, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xC6, 0x08, // “Æ (U+201C U+00C6)
  0x20, 0x1C, 0x01, 0x00, 0x04, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x02, 0x04, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x04, 0x04, // “Ą (U+201C U+0104)
  0x20, 0x1D, 0x00, 0x41, 0x06, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0x43, 0x01, // ”C (U+201D U+0043)
  0x20, 0x1D, 0x00, 0x47, 0x01, // ”G (U+201D U+0047)
  0x20, 0x1D, 0x00, 0x4F, 0x01, // ”O (U+201D U+004F)
  0x20, 0x1D, 0x00, 0x51, 0x01, // ”Q (U+201D U+0051)
  0x20, 0x1D, 0x00, 0x61, 0x02, // ”a (U+201D U+0061)
  0x20, 0x1D, 0x00, 0x63, 0x02, // ”c (U+201D U+0063)
  0x20, 0x1D, 0x00, 0x64, 0x02, // ”d (U+201D U+0064)
  0x20, 0x1D, 0x00, 0x65, 0x02, // ”e (U+201D U+0065)
  0x20, 0x1D, 0x00, 0x67, 0x02, // ”g (U+201D U+0067)
  0x20, 0x1D, 0x00, 0x6F, 0x02, // ”o (U+201D U+006F)
  0x20, 0x1D, 0x00, 0x71, 0x02, // ”q (U+201D U+0071)
  0x20, 0x1D, 0x00, 0x73, 0x03, // ”s (U+201D U+0073)
  0x20, 0x1D, 0x00, 0xC0, 0x06, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x06, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x06, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x06, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x06, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x06, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xC6, 0x05, // ”Æ (U+201D U+00C6)
  0x20, 0x1D, 0x00, 0xC7, 0x01, // ”Ç (U+201D U+00C7)
  0x20, 0x1D, 0x00, 0xD2, 0x01, // ”Ò (U+201D U+00D2)
  0x20, 0x1D, 0x00, 0xD3, 0x01, // ”Ó (U+201D U+00D3)
  0x20, 0x1D, 0x00, 0xD4, 0x01, // ”Ô (U+201D U+00D4)
  0x20, 0x1D, 0x00, 0xD5, 0x01, // ”Õ (U+201D U+00D5)
  0x20, 0x1D, 0x00, 0xD6, 0x01, // ”Ö (U+201D U+00D6)
  0x20, 0x1D, 0x00, 0xD8, 0x01, // ”Ø (U+201D U+00D8)
  0x20, 0x1D, 0x00, 0xE0, 0x02, // ”à (U+201D U+00E0)
  0x20, 0x1D, 0x00, 0xE1, 0x02, // ”á (U+201D U+00E1)
  0x20, 0x1D, 0x00, 0xE2, 0x02, // ”â (U+201D U+00E2)
  0x20, 0x1D, 0x00, 0xE3, 0x02, // ”ã (U+201D U+00E3)
  0x20, 0x1D, 0x00, 0xE4, 0x02, // ”ä (U+201D U+00E4)
  0x20, 0x1D, 0x00, 0xE5, 0x02, // ”å (U+201D U+00E5)
  0x20, 0x1D, 0x00, 0xE6, 0x02, // ”æ (U+201D U+00E6)
  0x20, 0x1D, 0x00, 0xE7, 0x02, // ”ç (U+201D U+00E7)
  0x20, 0x1D, 0x00, 0xE8, 0x02, // ”è (U+201D U+00E8)
  0x20, 0x1D, 0x00, 0xE9, 0x02, // ”é (U+201D U+00E9)
  0x20, 0x1D, 0x00, 0xEA, 0x02, // ”ê (U+201D U+00EA)
  0x20, 0x1D, 0x00, 0xEB, 0x02, // ”ë (U+201D U+00EB)
  0x20, 0x1D, 0x00, 0xF0, 0x02, // ”ð (U+201D U+00F0)
  0x20, 0x1D, 0x00, 0xF2, 0x02, // ”ò (U+201D U+00F2)
  0x20, 0x1D, 0x00, 0xF3, 0x02, // ”ó (U+201D U+00F3)
  0x20, 0x1D, 0x00, 0xF4, 0x02, // ”ô (U+201D U+00F4)
  0x20, 0x1D, 0x00, 0xF5, 0x02, // ”õ (U+201D U+00F5)
  0x20, 0x1D, 0x00, 0xF6, 0x02, // ”ö (U+201D U+00F6)
  0x20, 0x1D, 0x00, 0xF8, 0x02, // ”ø (U+201D U+00F8)
  0x20, 0x1D, 0x01, 0x00, 0x06, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x01, 0x02, // ”ā (U+201D U+0101)
  0x20, 0x1D, 0x01, 0x02, 0x06, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x03, 0x02, // ”ă (U+201D U+0103)
  0x20, 0x1D, 0x01, 0x04, 0x06, // ”Ą (U+201D U+0104)
  0x20, 0x1D, 0x01, 0x05, 0x02, // ”ą (U+201D U+0105)
  0x20, 0x1D, 0x01, 0x06, 0x01, // ”Ć (U+201D U+0106)
  0x20, 0x1D, 0x01, 0x07, 0x02, // ”ć (U+201D U+0107)
  0x20, 0x1D, 0x01, 0x08, 0x01, // ”Ĉ (U+201D U+0108)
  0x20, 0x1D, 0x01, 0x09, 0x02, // ”ĉ (U+201D U+0109)
  0x20, 0x1D, 0x01, 0x0A, 0x01, // ”Ċ (U+201D U+010A)
  0x20, 0x1D, 0x01, 0x0B, 0x02, // ”ċ (U+201D U+010B)
  0x20, 0x1D, 0x01, 0x0C, 0x01, // ”Č (U+201D U+010C)
  0x20, 0x1D, 0x01, 0x0D, 0x02, // ”č (U+201D U+010D)
  0x20, 0x1D, 0x01, 0x0F, 0x02, // ”ď (U+201D U+010F)
  0x20, 0x1D, 0x01, 0x11, 0x02, // ”đ (U+201D U+0111)
  0x20, 0x1D, 0x01, 0x13, 0x02, // ”ē (U+201D U+0113)
  0x20, 0x1D, 0x01, 0x15, 0x02, // ”ĕ (U+201D U+0115)
  0x20, 0x1D, 0x01, 0x17, 0x02, // ”ė (U+201D U+0117)
  0x20, 0x1D, 0x01, 0x19, 0x02, // ”ę (U+201D U+0119)
  0x20, 0x1D, 0x01, 0x1B, 0x02, // ”ě (U+201D U+011B)
  0x20, 0x1D, 0x01, 0x1C, 0x01, // ”Ĝ (U+201D U+011C)
  0x20, 0x1D, 0x01, 0x1D, 0x02, // ”ĝ (U+201D U+011D)
  0x20, 0x1D, 0x01, 0x1E, 0x01, // ”Ğ (U+201D U+011E)
  0x20, 0x1D, 0x01, 0x1F, 0x02, // ”ğ (U+201D U+011F)
  0x20, 0x1D, 0x01, 0x20, 0x01, // ”Ġ (U+201D U+0120)
  0x20, 0x1D, 0x01, 0x21, 0x02, // ”ġ (U+201D U+0121)
  0x20, 0x1D, 0x01, 0x22, 0x01, // ”Ģ (U+201D U+0122)
  0x20, 0x1D, 0x01, 0x23, 0x02, // ”ģ (U+201D U+0123)
  0x20, 0x1D, 0x01, 0x4C, 0x01, // ”Ō (U+201D U+014C)
  0x20, 0x1D, 0x01, 0x4D, 0x02, // ”ō (U+201D U+014D)
  0x20, 0x1D, 0x01, 0x4E, 0x01, // ”Ŏ (U+201D U+014E)
  0x20, 0x1D, 0x01, 0x4F, 0x02, // ”ŏ (U+201D U+014F)
  0x20, 0x1D, 0x01, 0x50, 0x01, // ”Ő (U+201D U+0150)
  0x20, 0x1D, 0x01, 0x51, 0x02, // ”ő (U+201D U+0151)
  0x20, 0x1D, 0x01, 0x52, 0x01, // ”Œ (U+201D U+0152)
  0x20, 0x1D, 0x01, 0x53, 0x02, // ”œ (U+201D U+0153)
  0x20, 0x1D, 0x01, 0x5B, 0x03, // ”ś (U+201D U+015B)
  0x20, 0x1D, 0x01, 0x5D, 0x03, // ”ŝ (U+201D U+015D)
  0x20, 0x1D, 0x01, 0x5F, 0x03, // ”ş (U+201D U+015F)
  0x20, 0x1D, 0x01, 0x61, 0x03, // ”š (U+201D U+0161)
  0x20, 0x1E, 0x00, 0x3F, 0x04, // „? (U+201E U+003F)
  0x20, 0x1E, 0x00, 0x43, 0x01, // „C (U+201E U+0043)
  0x20, 0x1E, 0x00, 0x47, 0x01, // „G (U+201E U+0047)
  0x20, 0x1E, 0x00, 0x4F, 0x01, // „O (U+201E U+004F)
  0x20, 0x1E, 0x00, 0x51, 0x01, // „Q (U+201E U+0051)
  0x20, 0x1E, 0x00, 0x54, 0x04, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x55, 0x01, // „U (U+201E U+0055)
  0x20, 0x1E, 0x00, 0x56, 0x06, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x05, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x04, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0x75, 0x01, // „u (U+201E U+0075)
  0x20, 0x1E, 0x00, 0x76, 0x04, // „v (U+201E U+0076)
  0x20, 0x1E, 0x00, 0x77, 0x03, // „w (U+201E U+0077)
  0x20, 0x1E, 0x00, 0x79, 0x03, // „y (U+201E U+0079)
  0x20, 0x1E, 0x00, 0xC7, 0x01, // „Ç (U+201E U+00C7)
  0x20, 0x1E, 0x00, 0xD2, 0x01, // „Ò (U+201E U+00D2)
  0x20, 0x1E, 0x00, 0xD3, 0x01, // „Ó (U+201E U+00D3)
  0x20, 0x1E, 0x00, 0xD4, 0x01, // „Ô (U+201E U+00D4)
  0x20, 0x1E, 0x00, 0xD5, 0x01, // „Õ (U+201E U+00D5)
  0x20, 0x1E, 0x00, 0xD6, 0x01, // „Ö (U+201E U+00D6)
  0x20, 0x1E, 0x00, 0xD8, 0x01, // „Ø (U+201E U+00D8)
  0x20, 0x1E, 0x00, 0xD9, 0x01, // „Ù (U+201E U+00D9)
  0x20, 0x1E, 0x00, 0xDA, 0x01, // „Ú (U+201E U+00DA)
  0x20, 0x1E, 0x00, 0xDB, 0x01, // „Û (U+201E U+00DB)
  0x20, 0x1E, 0x00, 0xDC, 0x01, // „Ü (U+201E U+00DC)
  0x20, 0x1E, 0x00, 0xDD, 0x04, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x00, 0xF9, 0x01, // „ù (U+201E U+00F9)
  0x20, 0x1E, 0x00, 0xFA, 0x01, // „ú (U+201E U+00FA)
  0x20, 0x1E, 0x00, 0xFB, 0x01, // „û (U+201E U+00FB)
  0x20, 0x1E, 0x00, 0xFC, 0x01, // „ü (U+201E U+00FC)
  0x20, 0x1E, 0x00, 0xFD, 0x03, // „ý (U+201E U+00FD)
  0x20, 0x1E, 0x00, 0xFF, 0x03, // „ÿ (U+201E U+00FF)
  0x20, 0x1E, 0x01, 0x06, 0x01, // „Ć (U+201E U+0106)
  0x20, 0x1E, 0x01, 0x08, 0x01, // „Ĉ (U+201E U+0108)
  0x20, 0x1E, 0x01, 0x0A, 0x01, // „Ċ (U+201E U+010A)
  0x20, 0x1E, 0x01, 0x0C, 0x01, // „Č (U+201E U+010C)
  0x20, 0x1E, 0x01, 0x1C, 0x01, // „Ĝ (U+201E U+011C)
  0x20, 0x1E, 0x01, 0x1E, 0x01, // „Ğ (U+201E U+011E)
  0x20, 0x1E, 0x01, 0x20, 0x01, // „Ġ (U+201E U+0120)
  0x20, 0x1E, 0x01, 0x22, 0x01, // „Ģ (U+201E U+0122)
  0x20, 0x1E, 0x01, 0x4C, 0x01, // „Ō (U+201E U+014C)
  0x20, 0x1E, 0x01, 0x4E, 0x01, // „Ŏ (U+201E U+014E)
  0x20, 0x1E, 0x01, 0x50, 0x01, // „Ő (U+201E U+0150)
  0x20, 0x1E, 0x01, 0x52, 0x01, // „Œ (U+201E U+0152)
  0x20, 0x1E, 0x01, 0x62, 0x04, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x04, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x04, // „Ŧ (U+201E U+0166)
  0x20, 0x1E, 0x01, 0x68, 0x01, // „Ũ (U+201E U+0168)
  0x20, 0x1E, 0x01, 0x69, 0x01, // „ũ (U+201E U+0169)
  0x20, 0x1E, 0x01, 0x6A, 0x01, // „Ū (U+201E U+016A)
  0x20, 0x1E, 0x01, 0x6B, 0x01, // „ū (U+201E U+016B)
  0x20, 0x1E, 0x01, 0x6C, 0x01, // „Ŭ (U+201E U+016C)
  0x20, 0x1E, 0x01, 0x6D, 0x01, // „ŭ (U+201E U+016D)
  0x20, 0x1E, 0x01, 0x6E, 0x01, // „Ů (U+201E U+016E)
  0x20, 0x1E, 0x01, 0x6F, 0x01, // „ů (U+201E U+016F)
  0x20, 0x1E, 0x01, 0x70, 0x01, // „Ű (U+201E U+0170)
  0x20, 0x1E, 0x01, 0x71, 0x01, // „ű (U+201E U+0171)
  0x20, 0x1E, 0x01, 0x72, 0x01, // „Ų (U+201E U+0172)
  0x20, 0x1E, 0x01, 0x73, 0x01, // „ų (U+201E U+0173)
  0x20, 0x1E, 0x01, 0x74, 0x05, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x75, 0x03, // „ŵ (U+201E U+0175)
  0x20, 0x1E, 0x01, 0x76, 0x04, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x77, 0x03, // „ŷ (U+201E U+0177)
  0x20, 0x1E, 0x01, 0x78, 0x04, // „Ÿ (U+201E U+0178)
  0x20, 0x26, 0x00, 0x3F, 0x04, // …? (U+2026 U+003F)
  0x20, 0x26, 0x00, 0x43, 0x01, // …C (U+2026 U+0043)
  0x20, 0x26, 0x00, 0x47, 0x01, // …G (U+2026 U+0047)
  0x20, 0x26, 0x00, 0x4F, 0x01, // …O (U+2026 U+004F)
  0x20, 0x26, 0x00, 0x51, 0x01, // …Q (U+2026 U+0051)
  0x20, 0x26, 0x00, 0x54, 0x04, // …T (U+2026 U+0054)
  0x20, 0x26, 0x00, 0x55, 0x01, // …U (U+2026 U+0055)
  0x20, 0x26, 0x00, 0x56, 0x06, // …V (U+2026 U+0056)
  0x20, 0x26, 0x00, 0x57, 0x05, // …W (U+2026 U+0057)
  0x20, 0x26, 0x00, 0x59, 0x04, // …Y (U+2026 U+0059)
  0x20, 0x26, 0x00, 0x75, 0x01, // …u (U+2026 U+0075)
  0x20, 0x26, 0x00, 0x76, 0x04, // …v (U+2026 U+0076)
  0x20, 0x26, 0x00, 0x77, 0x03, // …w (U+2026 U+0077)
  0x20, 0x26, 0x00, 0x79, 0x03, // …y (U+2026 U+0079)
  0x20, 0x26, 0x00, 0xC7, 0x01, // …Ç (U+2026 U+00C7)
  0x20, 0x26, 0x00, 0xD2, 0x01, // …Ò (U+2026 U+00D2)
  0x20, 0x26, 0x00, 0xD3, 0x01, // …Ó (U+2026 U+00D3)
  0x20, 0x26, 0x00, 0xD4, 0x01, // …Ô (U+2026 U+00D4)
  0x20, 0x26, 0x00, 0xD5, 0x01, // …Õ (U+2026 U+00D5)
  0x20, 0x26, 0x00, 0xD6, 0x01, // …Ö (U+2026 U+00D6)
  0x20, 0x26, 0x00, 0xD8, 0x01, // …Ø (U+2026 U+00D8)
  0x20, 0x26, 0x00, 0xD9, 0x01, // …Ù (U+2026 U+00D9)
  0x20, 0x26, 0x00, 0xDA, 0x01, // …Ú (U+2026 U+00DA)
  0x20, 0x26, 0x00, 0xDB, 0x01, // …Û (U+2026 U+00DB)
  0x20, 0x26, 0x00, 0xDC, 0x01, // …Ü (U+2026 U+00DC)
  0x20, 0x26, 0x00, 0xDD, 0x04, // …Ý (U+2026 U+00DD)
  0x20, 0x26, 0x00, 0xF9, 0x01, // …ù (U+2026 U+00F9)
  0x20, 0x26, 0x00, 0xFA, 0x01, // …ú (U+2026 U+00FA)
  0x20, 0x26, 0x00, 0xFB, 0x01, // …û (U+2026 U+00FB)
  0x20, 0x26, 0x00, 0xFC, 0x01, // …ü (U+2026 U+00FC)
  0x20, 0x26, 0x00, 0xFD, 0x03, // …ý (U+2026 U+00FD)
  0x20, 0x26, 0x00, 0xFF, 0x03, // …ÿ (U+2026 U+00FF)
  0x20, 0x26, 0x01, 0x06, 0x01, // …Ć (U+2026 U+0106)
  0x20, 0x26, 0x01, 0x08, 0x01, // …Ĉ (U+2026 U+0108)
  0x20, 0x26, 0x01, 0x0A, 0x01, // …Ċ (U+2026 U+010A)
  0x20, 0x26, 0x01, 0x0C, 0x01, // …Č (U+2026 U+010C)
  0x20, 0x26, 0x01, 0x1C, 0x01, // …Ĝ (U+2026 U+011C)
  0x20, 0x26, 0x01, 0x1E, 0x01, // …Ğ (U+2026 U+011E)
  0x20, 0x26, 0x01, 0x20, 0x01, // …Ġ (U+2026 U+0120)
  0x20, 0x26, 0x01, 0x22, 0x01, // …Ģ (U+2026 U+0122)
  0x20, 0x26, 0x01, 0x4C, 0x01, // …Ō (U+2026 U+014C)
  0x20, 0x26, 0x01, 0x4E, 0x01, // …Ŏ (U+2026 U+014E)
  0x20, 0x26, 0x01, 0x50, 0x01, // …Ő (U+2026 U+0150)
  0x20, 0x26, 0x01, 0x52, 0x01, // …Œ (U+2026 U+0152)
  0x20, 0x26, 0x01, 0x62, 0x04, // …Ţ (U+2026 U+0162)
  0x20, 0x26, 0x01, 0x64, 0x04, // …Ť (U+2026 U+0164)
  0x20, 0x26, 0x01, 0x66, 0x04, // …Ŧ (U+2026 U+0166)
  0x20, 0x26, 0x01, 0x68, 0x01, // …Ũ (U+2026 U+0168)
  0x20, 0x26, 0x01, 0x69, 0x01, // …ũ (U+2026 U+0169)
  0x20, 0x26, 0x01, 0x6A, 0x01, // …Ū (U+2026 U+016A)
  0x20, 0x26, 0x01, 0x6B, 0x01, // …ū (U+2026 U+016B)
  0x20, 0x26, 0x01, 0x6C, 0x01, // …Ŭ (U+2026 U+016C)
  0x20, 0x26, 0x01, 0x6D, 0x01, // …ŭ (U+2026 U+016D)
  0x20, 0x26, 0x01, 0x6E, 0x01, // …Ů (U+2026 U+016E)
  0x20, 0x26, 0x01, 0x6F, 0x01, // …ů (U+2026 U+016F)
  0x20, 0x26, 0x01, 0x70, 0x01, // …Ű (U+2026 U+0170)
  0x20, 0x26, 0x01, 0x71, 0x01, // …ű (U+2026 U+0171)
  0x20, 0x26, 0x01, 0x72, 0x01, // …Ų (U+2026 U+0172)
  0x20, 0x26, 0x01, 0x73, 0x01, // …ų (U+2026 U+0173)
  0x20, 0x26, 0x01, 0x74, 0x05, // …Ŵ (U+2026 U+0174)
  0x20, 0x26, 0x01, 0x75, 0x03, // …ŵ (U+2026 U+0175)
  0x20, 0x26, 0x01, 0x76, 0x04, // …Ŷ (U+2026 U+0176)
  0x20, 0x26, 0x01, 0x77, 0x03, // …ŷ (U+2026 U+0177)
  0x20, 0x26, 0x01, 0x78, 0x04, // …Ÿ (U+2026 U+0178)
  
  // Glyph data
  // "!" (U+0021)
  0x07, 0xD0, 0xE0, 0x6D, 0x0D, 0x05, 0xD0, 0xC0, 0x4D, 0x0B, 0x03, 0xD0, 0xA0, 0x2D, 0x09, 0x01,
  0xD0, 0x80, 0x1D, 0x08, 0x1D, 0x81, 0x70, 0xEC, 0x81, 0x60, 0xDC, 0x81, 0x50, 0xDC, 0x81, 0x40,
  0xCC, 0x81, 0x30, 0xBC, 0x81, 0x20, 0xAC, 0x81, 0x10, 0x9C, 0x81, 0x10, 0x8C, 0x20, 0x7B, 0x0E,
  0x20, 0x6B, 0x0D, 0x20, 0x5B, 0x0D, 0x20, 0x5B, 0x0C, 0x20, 0x4B, 0x0B, 0x20, 0x3B, 0x0A, 0x20,
  0x2B, 0x09, 0x20, 0x1B, 0x08, 0x3B, 0x07, 0x3B, 0x07, 0x30, 0xEA, 0x06, 0x30, 0xDA, 0x05, 0x30,
  0xCA, 0x04, 0x30, 0xBA, 0x03, 0x77, 0x77, 0x38, 0x13, 0x65, 0x30, 0x9B, 0x81, 0xD2, 0x3D, 0x0A,
  0x07, 0xD0, 0xE0, 0x8E, 0x07, 0xD0, 0xE0, 0x3D, 0x81, 0xA0, 0x9B, 0x0D, 0x02, 0x28, 0x13, 0x65,
  0x20,
  // """ (U+0022)
  0x0D, 0xC0, 0xC4, 0xD0, 0x0B, 0xC0, 0xA4, 0x0E, 0xC0, 0x09, 0xC0, 0x84, 0x0C, 0xC0, 0x70, 0x8C,
  0x07, 0x40, 0xAC, 0x05, 0x06, 0xC0, 0x54, 0x08, 0xC0, 0x30, 0x4C, 0x03, 0x40, 0x6C, 0x01, 0x02,
  0xC0, 0x14, 0x05, 0xC2, 0xC5, 0x03, 0xB0, 0xD2, 0x0E, 0xA0, 0xD5, 0x01, 0xB0, 0xB2, 0x0C, 0xA0,
  0xB6, 0x0E, 0xA0, 0x92, 0x0A, 0xA0, 0x96, 0x0D, 0xA0, 0x72, 0x08, 0xA0, 0x76, 0x0B, 0xA0, 0x62,
  0x06, 0xA0, 0x56, 0x09, 0xA0, 0x42, 0x05, 0xA0, 0x46, 0x07, 0xA0, 0x21,
  // "#" (U+0023)
  0x74, 0x0B, 0xA0, 0xA6, 0x07, 0xA0, 0xE7, 0x70, 0xEA, 0x07, 0x60, 0xAA, 0x0B, 0x76, 0x01, 0xB0,
  0x46, 0x0D, 0xA0, 0x87, 0x60, 0x4B, 0x01, 0x6B, 0x05, 0x76, 0x07, 0xA0, 0xE6, 0x03, 0xB0, 0x27,
  0x60, 0xAA, 0x0B, 0x60, 0x6A, 0x0E, 0x77, 0x0D, 0xA0, 0x86, 0x09, 0xA0, 0xC7, 0x7B, 0x05, 0x60,
  0xCA, 0x09, 0x76, 0x03, 0xB0, 0x26, 0x0E, 0xA0, 0x67, 0x60, 0x6A, 0x0E, 0x60, 0x2B, 0x03, 0x76,
  0x09, 0xA0, 0xB6, 0x05, 0xB7, 0x70, 0xCA, 0x09, 0x60, 0x8A, 0x0C, 0x70, 0x5F, 0xFF, 0xB0, 0xE2,
  0x05, 0xFF, 0xFB, 0x0E, 0x20, 0x5F, 0xFF, 0xB0, 0xE3, 0x80, 0x11, 0x0A, 0xA0, 0xC8, 0x02, 0x10,
  0x5B, 0x02, 0x80, 0x11, 0x71, 0x0C, 0xA0, 0x96, 0x07, 0xA0, 0xD7, 0x7B, 0x06, 0x60, 0xAA, 0x0A,
  0x76, 0x02, 0xB0, 0x36, 0x0D, 0xA0, 0x77, 0x60, 0x5B, 0x60, 0x1B, 0x04, 0x76, 0x08, 0xA0, 0xC6,
  0x04, 0xB0, 0x17, 0x60, 0xBA, 0x09, 0x60, 0x7A, 0x0E, 0x77, 0x0E, 0xA0, 0x76, 0x09, 0xA0, 0xB7,
  0x60, 0x1B, 0x04, 0x60, 0xCA, 0x08, 0x76, 0x04, 0xB0, 0x16, 0xB0, 0x57, 0x60, 0x7A, 0x0D, 0x60,
  0x3B, 0x02, 0x76, 0x0A, 0xA0, 0xA6, 0x06, 0xA0, 0xE7, 0x10, 0x4F, 0xFF, 0xC2, 0x04, 0xFF, 0xFC,
  0x20, 0x4F, 0xFF, 0xC3, 0x80, 0x01, 0x08, 0xA0, 0xE8, 0x02, 0x10, 0x4B, 0x03, 0x80, 0x21, 0x70,
  0xAA, 0x0B, 0x60, 0x6B, 0x77, 0x0D, 0xA0, 0x86, 0x09, 0xA0, 0xC7, 0x7B, 0x05, 0x60, 0xBA, 0x09,
  0x76, 0x03, 0xB0, 0x36, 0x0E, 0xA0, 0x77, 0x60, 0x5B, 0x60, 0x1B, 0x04, 0x76, 0x08, 0xA0, 0xC6,
  0x04, 0xB0, 0x17, 0x60, 0xBA, 0x0A, 0x60, 0x7A, 0x0E, 0x77, 0x0E, 0xA0, 0x76, 0x0A, 0xA0, 0xB7,
  0x60, 0x1B, 0x04, 0x60, 0xCA, 0x08, 0x76, 0x04, 0xB0, 0x16, 0xB0, 0x57, 0x60, 0x6A, 0x0E, 0x60,
  0x2B, 0x03, 0x76, 0x09, 0xA0, 0xB6, 0x05, 0xB7, 0x40,
  // "$" (U+0024)
  0x73, 0x81, 0xEF, 0x97, 0x76, 0x81, 0xEF, 0x97, 0x76, 0x81, 0xEF, 0x97, 0x76, 0x81, 0xEF, 0x97,
  0x74, 0x86, 0x14, 0xEF, 0xB5, 0x42, 0x76, 0x05, 0x0B, 0xF9, 0x0D, 0x07, 0x72, 0x02, 0x0C, 0xFD,
  0x0D, 0x02, 0x60, 0x40, 0xEB, 0x85, 0xC5, 0xEF, 0xA5, 0xCC, 0x0D, 0x01, 0x40, 0x20, 0xEB, 0x09,
  0x28, 0x1E, 0xF9, 0x20, 0xBC, 0x09, 0x40, 0xBB, 0x0C, 0x38, 0x1E, 0xF9, 0x20, 0x2C, 0x0E, 0x30,
  0x2C, 0x04, 0x38, 0x1E, 0xF9, 0x30, 0xAC, 0x01, 0x20, 0x7C, 0x48, 0x1E, 0xF9, 0x30, 0x6C, 0x02,
  0x20, 0xAB, 0x0D, 0x48, 0x1E, 0xF9, 0x30, 0x3B, 0x0E, 0x30, 0xBB, 0x0C, 0x48, 0x1E, 0xF9, 0x30,
  0x1B, 0x05, 0x30, 0xBB, 0x0D, 0x48, 0x1E, 0xF9, 0x48, 0x1D, 0xA4, 0x40, 0xAC, 0x01, 0x38, 0x1E,
  0xF9, 0x74, 0x08, 0xC0, 0x63, 0x81, 0xEF, 0x97, 0x40, 0x5C, 0x0D, 0x01, 0x28, 0x1E, 0xF9, 0x75,
  0x0E, 0xC0, 0xB2, 0x81, 0xEF, 0x97, 0x50, 0x8D, 0x83, 0xD3, 0xEF, 0x97, 0x60, 0xDF, 0x90, 0x97,
  0x60, 0x20, 0xDF, 0x0B, 0x01, 0x76, 0x01, 0x0C, 0xF0, 0xE0, 0x77, 0x70, 0x8F, 0x90, 0xD0, 0x37,
  0x60, 0x30, 0xCF, 0x90, 0x77, 0x70, 0x5F, 0x90, 0xA7, 0x70, 0xEF, 0x90, 0xA7, 0x68, 0x3E, 0xF9,
  0x5E, 0xD0, 0x77, 0x58, 0x4E, 0xF9, 0x02, 0xDD, 0x01, 0x74, 0x81, 0xEF, 0x92, 0x01, 0x0E, 0xC0,
  0x87, 0x48, 0x1E, 0xF9, 0x30, 0x5C, 0x0D, 0x28, 0x12, 0x89, 0x68, 0x1E, 0xF9, 0x40, 0xEC, 0x18,
  0x22, 0xEF, 0xE6, 0x81, 0xEF, 0x94, 0x0A, 0xC0, 0x20, 0xBB, 0x01, 0x58, 0x1E, 0xF9, 0x40, 0x8C,
  0x02, 0xC0, 0x45, 0x81, 0xEF, 0x94, 0x07, 0xC0, 0x1C, 0x08, 0x58, 0x1E, 0xF9, 0x40, 0x9B, 0x81,
  0xE0, 0xEB, 0x0D, 0x58, 0x1E, 0xF9, 0x40, 0xCB, 0x81, 0xA0, 0xBC, 0x05, 0x48, 0x1E, 0xF9, 0x30,
  0x2C, 0x81, 0x50, 0x5C, 0x0D, 0x48, 0x1E, 0xF9, 0x30, 0xBB, 0x0C, 0x30, 0xCC, 0x0C, 0x01, 0x28,
  0x4E, 0xF9, 0x01, 0xAB, 0x0E, 0x02, 0x30, 0x10, 0xDC, 0x86, 0xE9, 0x5E, 0xFB, 0x8E, 0xB0, 0xD0,
  0x35, 0x01, 0x0A, 0xFE, 0x09, 0x01, 0x71, 0x81, 0x39, 0xDF, 0x81, 0xC8, 0x27, 0x78, 0x32, 0x3E,
  0xFA, 0x77, 0x68, 0x1E, 0xF9, 0x77, 0x68, 0x1E, 0xF9, 0x77, 0x68, 0x1E, 0xF9, 0x77, 0x68, 0x1E,
  0xF9, 0x77, 0x68, 0x1E, 0xF9, 0x77, 0x68, 0x1E, 0xF9, 0x77, 0x68, 0x16, 0x74, 0x73,
  // "%" (U+0025)
  0x68, 0x33, 0x57, 0x64, 0x77, 0x77, 0x70, 0x50, 0xDD, 0x0E, 0x08, 0x77, 0x10, 0xDA, 0x07, 0x76,
  0x08, 0xB8, 0x1E, 0xBC, 0xB0, 0xC0, 0x17, 0x50, 0x5B, 0x01, 0x75, 0x05, 0xB0, 0xB0, 0x12, 0x04,
  0xB0, 0xB7, 0x50, 0xBA, 0x0A, 0x76, 0x0E, 0xB0, 0x14, 0x08, 0xB0, 0x67, 0x30, 0x2B, 0x03, 0x75,
  0x06, 0xB0, 0xA5, 0x02, 0xB0, 0xD7, 0x30, 0x9A, 0x0C, 0x76, 0x0C, 0xB0, 0x56, 0x0D, 0xB0, 0x37,
  0x10, 0x10, 0xEA, 0x06, 0x75, 0x01, 0xC0, 0x26, 0x0A, 0xB0, 0x87, 0x10, 0x7A, 0x0E, 0x76, 0x04,
  0xC7, 0x08, 0xB0, 0xC7, 0x10, 0xDA, 0x08, 0x76, 0x07, 0xB0, 0xE7, 0x06, 0xB0, 0xE7, 0x04, 0xB0,
  0x27, 0x60, 0x9B, 0x0C, 0x70, 0x5C, 0x01, 0x60, 0xBA, 0x0B, 0x77, 0x0A, 0xB0, 0xB7, 0x04, 0xC0,
  0x35, 0x02, 0xB0, 0x47, 0x70, 0xBB, 0x0B, 0x70, 0x4C, 0x03, 0x50, 0x9A, 0x0D, 0x77, 0x10, 0xBB,
  0x0B, 0x70, 0x3C, 0x04, 0x50, 0xEA, 0x07, 0x77, 0x10, 0xBB, 0x0B, 0x70, 0x3C, 0x04, 0x40, 0x6A,
  0x0E, 0x01, 0x77, 0x10, 0xAB, 0x0B, 0x70, 0x4C, 0x03, 0x40, 0xDA, 0x09, 0x77, 0x20, 0xAB, 0x0C,
  0x70, 0x4C, 0x02, 0x30, 0x4B, 0x02, 0x77, 0x20, 0x8B, 0x0D, 0x70, 0x5C, 0x40, 0xAA, 0x0B, 0x70,
  0x01, 0x71, 0x05, 0xB0, 0xE7, 0x07, 0xB0, 0xD3, 0x02, 0xB0, 0x54, 0x81, 0x4A, 0xEB, 0x0C, 0x07,
  0x50, 0x2C, 0x01, 0x60, 0x9B, 0x0A, 0x30, 0x8A, 0x0D, 0x40, 0x9F, 0x90, 0xC0, 0x24, 0x0D, 0xB0,
  0x46, 0x0B, 0xB0, 0x53, 0x0E, 0xA0, 0x73, 0x09, 0xB8, 0x3A, 0x20, 0x5E, 0xA0, 0xD0, 0x13, 0x09,
  0xB0, 0x76, 0xB0, 0xE0, 0x12, 0x06, 0xB0, 0x12, 0x04, 0xB0, 0xB4, 0x04, 0xB0, 0xA3, 0x02, 0xB0,
  0xD5, 0x05, 0xB0, 0x83, 0x0C, 0xA0, 0xA3, 0x0B, 0xB0, 0x45, 0x0C, 0xB0, 0x23, 0x09, 0xB0, 0x54,
  0x0C, 0xA0, 0xE0, 0x12, 0x03, 0xB0, 0x32, 0x02, 0xB0, 0xE6, 0x07, 0xB0, 0x94, 0x0D, 0xB8, 0x27,
  0x34, 0xCB, 0x04, 0x30, 0xAA, 0x0C, 0x30, 0x7B, 0x0B, 0x60, 0x4B, 0x0E, 0x40, 0x10, 0xCF, 0x0E,
  0x04, 0x30, 0x1B, 0x06, 0x30, 0xBB, 0x08, 0x60, 0x1C, 0x03, 0x58, 0x65, 0xAD, 0xFE, 0xC7, 0x14,
  0x08, 0xA0, 0xE4, 0x0E, 0xB0, 0x67, 0xC0, 0x67, 0x73, 0x0E, 0xA0, 0x83, 0x01, 0xC0, 0x57, 0x0E,
  0xB0, 0x87, 0x72, 0x05, 0xB0, 0x23, 0x02, 0xC0, 0x47, 0x0C, 0xB0, 0xA7, 0x72, 0x0C, 0xA0, 0xA4,
  0x03, 0xC0, 0x37, 0x0C, 0xB0, 0xB7, 0x71, 0x03, 0xB0, 0x44, 0x04, 0xC0, 0x37, 0x0C, 0xB0, 0xB7,
  0x71, 0x09, 0xA0, 0xD5, 0x04, 0xC0, 0x37, 0x0C, 0xB0, 0xC7, 0x70, 0x1B, 0x06, 0x50, 0x3C, 0x03,
  0x70, 0xCB, 0x0B, 0x77, 0x07, 0xA0, 0xE6, 0x03, 0xC0, 0x37, 0x0C, 0xB0, 0xA7, 0x70, 0xDA, 0x09,
  0x60, 0x1C, 0x04, 0x70, 0xDB, 0x09, 0x76, 0x05, 0xB0, 0x27, 0x0E, 0xB0, 0x67, 0x0E, 0xB0, 0x67,
  0x60, 0xBA, 0x0B, 0x71, 0x0C, 0xB0, 0x76, 0x01, 0xC0, 0x37, 0x50, 0x2B, 0x05, 0x71, 0x08, 0xB0,
  0xA6, 0x03, 0xB0, 0xE7, 0x60, 0x9A, 0x0D, 0x72, 0x03, 0xB0, 0xD6, 0x06, 0xB0, 0xA7, 0x50, 0x10,
  0xEA, 0x07, 0x73, 0x0D, 0xB0, 0x25, 0x0A, 0xB0, 0x47, 0x50, 0x7B, 0x01, 0x73, 0x06, 0xB0, 0x84,
  0x01, 0xB0, 0xC7, 0x60, 0xDA, 0x0A, 0x75, 0x0C, 0xB0, 0x42, 0x01, 0x0B, 0xB0, 0x27, 0x50, 0x4B,
  0x03, 0x75, 0x02, 0x0D, 0xB8, 0x1C, 0xBE, 0xB0, 0x57, 0x60, 0xBA, 0x0C, 0x77, 0x01, 0x09, 0xE0,
  0xC0, 0x37, 0x77, 0x76, 0x84, 0x14, 0x67, 0x52, 0x60,
  // "&" (U+0026)
  0x74, 0x86, 0x14, 0x67, 0x76, 0x41, 0x77, 0x76, 0x04, 0x0B, 0xF9, 0x0B, 0x03, 0x77, 0x73, 0x0A,
  0xFD, 0x08, 0x77, 0x71, 0x0A, 0xD8, 0x2D, 0x99, 0xBD, 0x08, 0x77, 0x60, 0x6D, 0x05, 0x40, 0x20,
  0xDC, 0x03, 0x77, 0x50, 0xDC, 0x06, 0x60, 0x3C, 0x09, 0x77, 0x40, 0x3C, 0x0D, 0x71, 0x0A, 0xB0,
  0xE7, 0x74, 0x07, 0xC0, 0x87, 0x10, 0x6C, 0x01, 0x77, 0x30, 0x9C, 0x06, 0x71, 0x03, 0xC0, 0x37,
  0x73, 0x09, 0xC0, 0x57, 0x10, 0x3C, 0x03, 0x77, 0x30, 0x8C, 0x06, 0x71, 0x03, 0xC0, 0x27, 0x73,
  0x07, 0xC0, 0x87, 0x10, 0x5B, 0x0E, 0x77, 0x40, 0x4C, 0x0C, 0x71, 0x09, 0xB0, 0xA7, 0x75, 0x0E,
  0xC0, 0x27, 0x0E, 0xB0, 0x37, 0x75, 0x0A, 0xC0, 0x96, 0x07, 0xB0, 0xA7, 0x76, 0x02, 0xD0, 0x24,
  0x04, 0xB0, 0xC7, 0x77, 0x10, 0x9C, 0x0C, 0x30, 0x5B, 0x0B, 0x01, 0x77, 0x71, 0x01, 0x0D, 0xC8,
  0x17, 0x2A, 0xB0, 0x77, 0x77, 0x40, 0x3F, 0x90, 0xB0, 0x27, 0xFA, 0x06, 0x72, 0x03, 0x0E, 0xD0,
  0xE0, 0x37, 0x2F, 0xA0, 0x67, 0x01, 0x0A, 0xF9, 0x07, 0x72, 0xFA, 0x06, 0x60, 0x40, 0xEF, 0xB0,
  0x37, 0x1D, 0x82, 0xC5, 0x31, 0x60, 0x6D, 0x0A, 0x08, 0xD0, 0xE0, 0x17, 0xC0, 0xA7, 0x20, 0x5D,
  0x07, 0x20, 0xAD, 0x0B, 0x60, 0x1C, 0x01, 0x71, 0x02, 0xD0, 0x94, 0x0D, 0xD0, 0x85, 0x03, 0xB0,
  0xA7, 0x20, 0xBC, 0x0C, 0x50, 0x20, 0xED, 0x04, 0x40, 0x4B, 0x07, 0x71, 0x03, 0xD0, 0x46, 0x04,
  0xD0, 0xE0, 0x13, 0x06, 0xB0, 0x37, 0x10, 0x8C, 0x0E, 0x71, 0x07, 0xD0, 0xC3, 0x08, 0xA0, 0xE7,
  0x20, 0xCC, 0x09, 0x72, 0x0A, 0xD0, 0x82, 0x0A, 0xA0, 0xB7, 0x2D, 0x07, 0x73, 0x0C, 0xD8, 0x15,
  0x0D, 0xA0, 0x77, 0x10, 0x1D, 0x05, 0x73, 0x01, 0x0E, 0xC0, 0xE0, 0x3B, 0x02, 0x71, 0x01, 0xD0,
  0x57, 0x40, 0x3D, 0x0E, 0xA0, 0xD7, 0x20, 0x1D, 0x05, 0x75, 0x06, 0xF0, 0x77, 0x3D, 0x06, 0x76,
  0x09, 0xE0, 0x27, 0x30, 0xEC, 0x08, 0x77, 0x0B, 0xD0, 0xA7, 0x30, 0xAC, 0x0B, 0x77, 0x01, 0x0D,
  0xD0, 0x87, 0x20, 0x7D, 0x01, 0x76, 0x01, 0x0E, 0xE0, 0x67, 0x10, 0x1D, 0x08, 0x76, 0x0C, 0xF9,
  0x04, 0x71, 0x0A, 0xD0, 0x47, 0x30, 0x10, 0xCA, 0x0D, 0x07, 0xD0, 0xE0, 0x27, 0x02, 0x0E, 0xD0,
  0x67, 0x10, 0x40, 0xDA, 0x82, 0xE2, 0x0B, 0xD0, 0xD0, 0x27, 0x05, 0xE8, 0x6C, 0x63, 0x11, 0x36,
  0xCC, 0x04, 0x20, 0x10, 0xED, 0x83, 0xE7, 0x31, 0x14, 0x06, 0xFF, 0x90, 0xD0, 0x34, 0x05, 0xFB,
  0x50, 0x40, 0xDF, 0xD0, 0xB0, 0x16, 0x09, 0xFA, 0x70, 0x60, 0xCF, 0x90, 0xB0, 0x57, 0x20, 0xDF,
  0x97, 0x28, 0x61, 0x45, 0x77, 0x64, 0x17, 0x76,
  // "'" (U+0027)
  0x0D, 0xC0, 0xC0, 0xBC, 0x0A, 0x09, 0xC0, 0x08, 0xC0, 0x70, 0x6C, 0x05, 0x04, 0xC0, 0x30, 0x2C,
  0x01, 0x1C, 0x20, 0xEA, 0x0D, 0x20, 0xCA, 0x0B, 0x20, 0xAA, 0x09, 0x20, 0x8A, 0x07, 0x20, 0x6A,
  0x05, 0x20, 0x5A, 0x04, 0x10,
  // "(" (U+0028)
  0x75, 0x01, 0x03, 0x74, 0x81, 0x7E, 0x87, 0x20, 0x40, 0xDA, 0x08, 0x71, 0x08, 0xB0, 0xD0, 0x27,
  0x0B, 0xB0, 0xC0, 0x17, 0x0B, 0xB0, 0xD0, 0x17, 0x0A, 0xB0, 0xE0, 0x27, 0x07, 0xC0, 0x67, 0x02,
  0xC0, 0xD7, 0x10, 0xBC, 0x06, 0x70, 0x3C, 0x0E, 0x71, 0x0A, 0xC0, 0x97, 0x01, 0xD0, 0x47, 0x05,
  0xD7, 0x10, 0xAC, 0x0C, 0x71, 0x0E, 0xC0, 0x97, 0x02, 0xD0, 0x67, 0x05, 0xD0, 0x47, 0x07, 0xD0,
  0x37, 0x09, 0xD0, 0x17, 0x0B, 0xD7, 0x10, 0xCC, 0x0E, 0x71, 0x0E, 0xC0, 0xD7, 0x1D, 0x0D, 0x71,
  0xD0, 0xC7, 0x1D, 0x0C, 0x71, 0xD0, 0xC7, 0x1D, 0x0C, 0x71, 0xD0, 0xC7, 0x1D, 0x0C, 0x71, 0xD0,
  0xD7, 0x10, 0xEC, 0x0D, 0x71, 0x0C, 0xC0, 0xE7, 0x10, 0xBD, 0x71, 0x09, 0xD0, 0x17, 0x07, 0xD0,
  0x37, 0x05, 0xD0, 0x47, 0x02, 0xD0, 0x67, 0x10, 0xEC, 0x09, 0x71, 0x0A, 0xC0, 0xC7, 0x10, 0x5D,
  0x71, 0x01, 0xD0, 0x47, 0x10, 0xAC, 0x09, 0x71, 0x03, 0xC0, 0xE7, 0x20, 0xBC, 0x05, 0x71, 0x02,
  0xC0, 0xD7, 0x20, 0x7C, 0x06, 0x72, 0x0B, 0xB0, 0xE0, 0x27, 0x20, 0xCB, 0x0C, 0x01, 0x71, 0x01,
  0x0C, 0xB0, 0xC7, 0x30, 0x9B, 0x0D, 0x02, 0x72, 0x05, 0x0E, 0xA0, 0x87, 0x38, 0x21, 0x9F, 0x87,
  0x50, 0x10, 0x40,
  // ")" (U+0029)
  0x00, 0x27, 0x68, 0x25, 0xF9, 0x17, 0x40, 0x5A, 0x0E, 0x06, 0x73, 0x01, 0x0B, 0xB0, 0xB0, 0x17,
  0x30, 0x9B, 0x0D, 0x02, 0x73, 0x0A, 0xB0, 0xD0, 0x27, 0x30, 0xDB, 0x0D, 0x73, 0x03, 0xC0, 0xA7,
  0x30, 0xAC, 0x05, 0x72, 0x02, 0xC0, 0xD7, 0x30, 0xCC, 0x06, 0x72, 0x06, 0xC0, 0xD7, 0x20, 0x1D,
  0x03, 0x72, 0x0C, 0xC0, 0x87, 0x20, 0x9C, 0x0D, 0x72, 0x06, 0xD0, 0x17, 0x10, 0x3D, 0x05, 0x71,
  0x01, 0xD0, 0x87, 0x2D, 0x0A, 0x72, 0x0D, 0xC0, 0xD7, 0x20, 0xCD, 0x72, 0x0B, 0xD7, 0x20, 0xAD,
  0x02, 0x71, 0x09, 0xD0, 0x37, 0x10, 0x9D, 0x03, 0x71, 0x08, 0xD0, 0x47, 0x10, 0x8D, 0x04, 0x71,
  0x08, 0xD0, 0x47, 0x10, 0x8D, 0x04, 0x71, 0x09, 0xD0, 0x37, 0x10, 0x9D, 0x03, 0x71, 0x0A, 0xD0,
  0x27, 0x10, 0xBD, 0x72, 0x0C, 0xD7, 0x20, 0xEC, 0x0D, 0x72, 0xD0, 0xA7, 0x10, 0x1D, 0x08, 0x71,
  0x03, 0xD0, 0x57, 0x10, 0x6D, 0x01, 0x71, 0x09, 0xC0, 0xD7, 0x20, 0xCC, 0x09, 0x71, 0x01, 0xD0,
  0x47, 0x10, 0x6C, 0x0D, 0x72, 0x0C, 0xC0, 0x67, 0x10, 0x2C, 0x0D, 0x72, 0x0A, 0xC0, 0x57, 0x10,
  0x3C, 0x0A, 0x72, 0x0D, 0xB0, 0xD0, 0x17, 0x10, 0xAB, 0x0E, 0x02, 0x71, 0x09, 0xB0, 0xD0, 0x27,
  0x01, 0x0B, 0xB0, 0xC0, 0x17, 0x10, 0x5B, 0x07, 0x73, 0x82, 0x5F, 0xA2, 0x74, 0x00, 0x37, 0x60,
  // "*" (U+002A)
  0x71, 0x0D, 0xB0, 0x87, 0x72, 0x0B, 0xB0, 0x67, 0x72, 0x08, 0xB0, 0x47, 0x72, 0x06, 0xB0, 0x17,
  0x20, 0x40, 0x75, 0x04, 0xB6, 0x07, 0x38, 0x1A, 0xFA, 0x40, 0x2A, 0x0D, 0x48, 0x42, 0xCF, 0x50,
  0x1B, 0x0D, 0x02, 0x3A, 0x0A, 0x30, 0x50, 0xEA, 0x81, 0xB0, 0x8C, 0x0E, 0x05, 0x28, 0x1D, 0xF8,
  0x20, 0x9D, 0x02, 0x09, 0xE8, 0x59, 0x0B, 0xF6, 0x2C, 0xD8, 0x4E, 0x50, 0x16, 0xCC, 0x83, 0xCB,
  0xF9, 0xEC, 0x0A, 0x05, 0x68, 0x12, 0x7D, 0xF8, 0x1C, 0x61, 0x74, 0x06, 0xC0, 0xD0, 0x37, 0x48,
  0x11, 0x6C, 0xF0, 0xB0, 0x57, 0x04, 0x0A, 0xC8, 0x2D, 0xBF, 0x9C, 0x81, 0xE9, 0x32, 0x07, 0x0E,
  0xD8, 0x5A, 0x0B, 0xF6, 0x2D, 0xD8, 0x1D, 0x49, 0xD0, 0x72, 0x81, 0xDF, 0x82, 0x0A, 0xD0, 0x30,
  0x2B, 0x0E, 0x03, 0x3A, 0x0A, 0x30, 0x6B, 0x0C, 0x28, 0x2B, 0xFB, 0x13, 0x02, 0xA0, 0xC4, 0x82,
  0x2D, 0xF6, 0x20, 0x40, 0x85, 0x04, 0xB6, 0x09, 0x73, 0x06, 0xB0, 0x17, 0x72, 0x08, 0xB0, 0x47,
  0x72, 0x0B, 0xB0, 0x67, 0x72, 0x0D, 0xB0, 0x87, 0x10,
  // "+" (U+002B)
  0x72, 0x0D, 0xA0, 0xA7, 0x74, 0x0D, 0xA0, 0xA7, 0x74, 0x0D, 0xA0, 0xA7, 0x74, 0x0D, 0xA0, 0xA7,
  0x74, 0x0D, 0xA0, 0xA7, 0x74, 0x0D, 0xA0, 0xA7, 0x74, 0x0D, 0xA0, 0xA7, 0x74, 0x0D, 0xA0, 0xA7,
  0x74, 0x0D, 0xA0, 0xA7, 0x74, 0x0D, 0xA0, 0xA7, 0x74, 0x0D, 0xA0, 0xA7, 0x28, 0x05, 0x10, 0xDA,
  0x0A, 0x80, 0x51, 0xFF, 0xF0, 0xEF, 0xFF, 0x0E, 0xFF, 0xF0, 0xE7, 0x20, 0xDA, 0x0A, 0x77, 0x40,
  0xDA, 0x0A, 0x77, 0x40, 0xDA, 0x0A, 0x77, 0x40, 0xDA, 0x0A, 0x77, 0x40, 0xDA, 0x0A, 0x77, 0x40,
  0xDA, 0x0A, 0x77, 0x40, 0xDA, 0x0A, 0x77, 0x40, 0xDA, 0x0A, 0x77, 0x40, 0xDA, 0x0A, 0x77, 0x40,
  0xDA, 0x0A, 0x77, 0x40, 0xDA, 0x0A, 0x72,
  // "," (U+002C)
  0x38, 0x38, 0xDE, 0xA1, 0x30, 0x8C, 0x0D, 0x30, 0xED, 0x07, 0x2E, 0x0C, 0x20, 0xDD, 0x0E, 0x20,
  0x5E, 0x30, 0x5C, 0x0E, 0x40, 0x30, 0xEA, 0x0C, 0x50, 0x9A, 0x09, 0x50, 0xAA, 0x05, 0x58, 0x1D,
  0xFE, 0x50, 0x6A, 0x07, 0x40, 0x4A, 0x0C, 0x30, 0x10, 0x8A, 0x0D, 0x01, 0x20, 0x10, 0xEA, 0x0C,
  0x01, 0x38, 0x22, 0xFE, 0x65, 0x01, 0x05, 0x70,
  // "-" (U+002D)
  0x0A, 0xFD, 0x09, 0x0A, 0xFD, 0x09, 0x0A, 0xFD, 0x09, 0x0A, 0xFD, 0x09,
  // "." (U+002E)
  0x28, 0x14, 0x75, 0x30, 0xBB, 0x81, 0xD1, 0x6D, 0x00, 0x9D, 0x0C, 0x0A, 0xD0, 0xD0, 0x9D, 0x0C,
  0x06, 0xD8, 0x19, 0x0B, 0xB0, 0xD0, 0x12, 0x81, 0x47, 0x52,
  // "/" (U+002F)
  0x74, 0x06, 0xA0, 0xA7, 0x40, 0x9A, 0x06, 0x74, 0x0D, 0xA0, 0x37, 0x30, 0x1B, 0x74, 0x04, 0xA0,
  0xC7, 0x40, 0x7A, 0x08, 0x74, 0x0B, 0xA0, 0x57, 0x40, 0xEA, 0x01, 0x73, 0x02, 0xA0, 0xE7, 0x40,
  0x6A, 0x0A, 0x74, 0x09, 0xA0, 0x77, 0x40, 0xDA, 0x03, 0x73, 0x01, 0xB7, 0x40, 0x4A, 0x0C, 0x74,
  0x07, 0xA0, 0x97, 0x40, 0xBA, 0x05, 0x74, 0x0E, 0xA0, 0x27, 0x30, 0x2A, 0x0E, 0x74, 0x05, 0xA0,
  0xB7, 0x40, 0x9A, 0x07, 0x74, 0x0C, 0xA0, 0x47, 0x4B, 0x01, 0x73, 0x04, 0xA0, 0xD7, 0x40, 0x7A,
  0x09, 0x74, 0x0B, 0xA0, 0x67, 0x40, 0xEA, 0x03, 0x73, 0x02, 0xA0, 0xE7, 0x40, 0x5A, 0x0B, 0x74,
  0x09, 0xA0, 0x87, 0x40, 0xCA, 0x04, 0x74, 0xB0, 0x17, 0x30, 0x3A, 0x0D, 0x74, 0x07, 0xA0, 0xA7,
  0x40, 0xAA, 0x06, 0x74, 0x0E, 0xA0, 0x37, 0x30, 0x2B, 0x74, 0x05, 0xA0, 0xC7, 0x40, 0x9A, 0x08,
  0x74, 0x0C, 0xA0, 0x57, 0x4B, 0x02, 0x73, 0x03, 0xA0, 0xE7, 0x40, 0x7A, 0x0A, 0x74, 0x0A, 0xA0,
  0x77, 0x40, 0xEA, 0x04, 0x73, 0x01, 0xB7, 0x40, 0x5A, 0x0C, 0x74, 0x08, 0xA0, 0x97, 0x40, 0xCA,
  0x05, 0x74, 0xB0, 0x27, 0x30, 0x3A, 0x0E, 0x74, 0x07, 0xA0, 0xB7, 0x40, 0xAA, 0x07, 0x74, 0x0D,
  0xA0, 0x47, 0x40,
  // "0" (U+0030)
  0x72, 0x85, 0x25, 0x67, 0x64, 0x17, 0x72, 0x06, 0x0D, 0xF0, 0xB0, 0x37, 0x50, 0x20, 0xCF, 0xC0,
  0x87, 0x30, 0x20, 0xEC, 0x82, 0xEA, 0x9B, 0xD0, 0xA7, 0x20, 0xDC, 0x09, 0x40, 0x20, 0xCC, 0x07,
  0x70, 0x8C, 0x0A, 0x60, 0x10, 0xEC, 0x02, 0x50, 0x2D, 0x01, 0x70, 0x6C, 0x0A, 0x50, 0x8C, 0x09,
  0x72, 0x0E, 0xC0, 0x14, 0x0E, 0xC0, 0x47, 0x20, 0x9C, 0x07, 0x30, 0x4D, 0x01, 0x72, 0x06, 0xC0,
  0xC3, 0x08, 0xC0, 0xD7, 0x30, 0x2D, 0x01, 0x20, 0xBC, 0x0A, 0x74, 0xD0, 0x52, 0x0E, 0xC0, 0x87,
  0x40, 0xDC, 0x81, 0x80, 0x2D, 0x06, 0x74, 0x0B, 0xC8, 0x1B, 0x04, 0xD0, 0x47, 0x40, 0x9C, 0x81,
  0xD0, 0x6D, 0x03, 0x74, 0x07, 0xD1, 0x08, 0xD0, 0x17, 0x40, 0x6D, 0x01, 0x09, 0xD7, 0x50, 0x5D,
  0x03, 0x0A, 0xD7, 0x50, 0x4D, 0x04, 0x0B, 0xD7, 0x50, 0x4D, 0x05, 0x0B, 0xC0, 0xE7, 0x50, 0x4D,
  0x05, 0x0B, 0xC0, 0xE7, 0x50, 0x3D, 0x06, 0x0C, 0xC0, 0xE7, 0x50, 0x3D, 0x06, 0x0B, 0xC0, 0xE7,
  0x50, 0x4D, 0x05, 0x0B, 0xC0, 0xE7, 0x50, 0x4D, 0x05, 0x0B, 0xD7, 0x50, 0x4D, 0x05, 0x0A, 0xD7,
  0x50, 0x5D, 0x04, 0x09, 0xD0, 0x17, 0x40, 0x5D, 0x03, 0x07, 0xD0, 0x27, 0x40, 0x7D, 0x01, 0x06,
  0xD0, 0x37, 0x40, 0x8D, 0x10, 0x4D, 0x04, 0x74, 0x09, 0xC8, 0x1D, 0x01, 0xD0, 0x67, 0x40, 0xBC,
  0x0A, 0x20, 0xEC, 0x08, 0x74, 0x0D, 0xC0, 0x72, 0x0B, 0xC0, 0xA7, 0x4D, 0x04, 0x20, 0x7C, 0x0D,
  0x73, 0x03, 0xD3, 0x03, 0xD0, 0x17, 0x20, 0x7C, 0x0B, 0x40, 0xDC, 0x05, 0x72, 0x0A, 0xC0, 0x54,
  0x07, 0xC0, 0xA7, 0x20, 0xEB, 0x0E, 0x50, 0x1D, 0x01, 0x70, 0x7C, 0x08, 0x60, 0x8C, 0x0A, 0x60,
  0x20, 0xEB, 0x0E, 0x01, 0x70, 0xDC, 0x09, 0x40, 0x20, 0xDC, 0x05, 0x71, 0x02, 0x0E, 0xC8, 0x2E,
  0xA9, 0xBD, 0x08, 0x73, 0x02, 0x0C, 0xFC, 0x07, 0x76, 0x06, 0x0D, 0xF0, 0xA0, 0x27, 0x72, 0x85,
  0x25, 0x77, 0x64, 0x17, 0x20,
  // "1" (U+0031)
  0x73, 0x04, 0x0E, 0xA0, 0xB7, 0x72, 0x07, 0xC0, 0xB7, 0x71, 0x09, 0xD0, 0xB7, 0x60, 0x10, 0xCE,
  0x0B, 0x75, 0x03, 0x0D, 0xA0, 0xEC, 0x0B, 0x74, 0x08, 0xB0, 0xB0, 0x9C, 0x0B, 0x72, 0x06, 0x0D,
  0xB8, 0x1D, 0x19, 0xC0, 0xB7, 0x07, 0x0E, 0xC8, 0x2E, 0x20, 0x9C, 0x0B, 0x70, 0xAD, 0x04, 0x20,
  0x9C, 0x0B, 0x70, 0x3B, 0x0E, 0x04, 0x30, 0x9C, 0x0B, 0x71, 0x82, 0x27, 0x61, 0x40, 0x9C, 0x0B,
  0x77, 0x20, 0x9C, 0x0B, 0x77, 0x20, 0x9C, 0x0B, 0x77, 0x20, 0x9C, 0x0B, 0x77, 0x20, 0x9C, 0x0B,
  0x77, 0x20, 0x9C, 0x0B, 0x77, 0x20, 0x9C, 0x0B, 0x77, 0x20, 0x9C, 0x0B, 0x77, 0x20, 0x9C, 0x0B,
  0x77, 0x20, 0x9C, 0x0B, 0x77, 0x20, 0x9C, 0x0B, 0x77, 0x20, 0x9C, 0x0B, 0x77, 0x20, 0x9C, 0x0B,
  0x77, 0x20, 0x9C, 0x0B, 0x77, 0x20, 0x9C, 0x0B, 0x77, 0x20, 0x9C, 0x0B, 0x77, 0x20, 0x9C, 0x0B,
  0x77, 0x20, 0x9C, 0x0B, 0x77, 0x20, 0x9C, 0x0B, 0x77, 0x20, 0x9C, 0x0B, 0x77, 0x20, 0x9C, 0x0B,
  0x77, 0x20, 0x9C, 0x0B, 0x77, 0x20, 0x9C, 0x0B, 0x77, 0x20, 0x9C, 0x0B, 0x77, 0x20, 0x9C, 0x0B,
  0x77, 0x20, 0x9C, 0x0B, 0x77, 0x20, 0x9C, 0x0C, 0x77, 0x20, 0xCC, 0x0E, 0x77, 0x10, 0x2E, 0x06,
  0x71, 0x80, 0x01, 0x81, 0x38, 0xEF, 0x83, 0x94, 0x21, 0x13, 0x0E, 0xFF, 0xC0, 0x52, 0x0E, 0xFF,
  0xC0, 0x52, 0x0E, 0xFF, 0xC0, 0x50,
  // "2" (U+0032)
  0x71, 0x85, 0x35, 0x67, 0x65, 0x37, 0x70, 0x40, 0xAF, 0x98, 0x1E, 0x92, 0x72, 0x01, 0x0A, 0xFE,
  0x07, 0x70, 0x10, 0xCD, 0x83, 0xEA, 0x9A, 0xED, 0x0A, 0x60, 0xAD, 0x07, 0x50, 0x8D, 0x08, 0x40,
  0x3D, 0x08, 0x70, 0xAD, 0x02, 0x30, 0x8C, 0x0D, 0x71, 0x01, 0xD0, 0xA3, 0x0B, 0xC0, 0x77, 0x20,
  0xBC, 0x0E, 0x30, 0xCC, 0x03, 0x72, 0x07, 0xD0, 0x32, 0x0A, 0xC0, 0x17, 0x20, 0x5D, 0x05, 0x20,
  0x4B, 0x0E, 0x73, 0x04, 0xD0, 0x63, 0x82, 0x4C, 0xFD, 0x73, 0x03, 0xD0, 0x55, 0x01, 0x02, 0x73,
  0x04, 0xD0, 0x47, 0x73, 0x05, 0xD0, 0x27, 0x73, 0x07, 0xC0, 0xE7, 0x74, 0x0A, 0xC0, 0xA7, 0x74,
  0x0E, 0xC0, 0x47, 0x73, 0x03, 0xC0, 0xD7, 0x74, 0x09, 0xC0, 0x57, 0x73, 0x01, 0x0E, 0xB0, 0xC7,
  0x74, 0x08, 0xC0, 0x37, 0x73, 0x01, 0x0E, 0xB0, 0x87, 0x74, 0x09, 0xB0, 0xC7, 0x74, 0x03, 0xC0,
  0x27, 0x74, 0x0D, 0xB0, 0x67, 0x74, 0x09, 0xB0, 0xA7, 0x74, 0x04, 0xB0, 0xC7, 0x74, 0x01, 0x0E,
  0xA0, 0xE0, 0x27, 0x74, 0x0C, 0xB0, 0x47, 0x74, 0x08, 0xB0, 0x77, 0x74, 0x05, 0xB0, 0xA7, 0x74,
  0x02, 0x0E, 0xA0, 0xC7, 0x75, 0x0C, 0xA0, 0xE0, 0x27, 0x74, 0x09, 0xB0, 0x47, 0x48, 0x16, 0x84,
  0x40, 0x6B, 0x07, 0x75, 0x81, 0xEF, 0x93, 0x03, 0xB0, 0xA7, 0x50, 0x3A, 0x09, 0x20, 0x10, 0xDA,
  0x0C, 0x76, 0x08, 0xA0, 0x82, 0x0A, 0xA0, 0xE0, 0x17, 0x50, 0x2B, 0x81, 0x80, 0x7B, 0x04, 0x74,
  0x81, 0x15, 0xDB, 0x08, 0x03, 0xFF, 0xF9, 0x08, 0x05, 0xFF, 0xF9, 0x07, 0x05, 0xFF, 0xF9, 0x07,
  0x05, 0xFF, 0xF9, 0x07, 0x05, 0xFF, 0xF9, 0x06,
  // "3" (U+0033)
  0x71, 0x85, 0x25, 0x67, 0x76, 0x47, 0x78, 0x12, 0x8E, 0xF9, 0x0B, 0x04, 0x73, 0x07, 0xFE, 0x0B,
  0x01, 0x70, 0x8D, 0x83, 0xEA, 0x9A, 0xDD, 0x0E, 0x02, 0x50, 0x5D, 0x08, 0x50, 0x6D, 0x0D, 0x50,
  0xEC, 0x0A, 0x70, 0x6D, 0x08, 0x30, 0x4C, 0x0E, 0x01, 0x71, 0x0D, 0xC0, 0xE3, 0x07, 0xC0, 0x97,
  0x20, 0x7D, 0x03, 0x20, 0x8C, 0x05, 0x72, 0x04, 0xD0, 0x62, 0x06, 0xC0, 0x27, 0x20, 0x1D, 0x08,
  0x20, 0x10, 0xEB, 0x01, 0x72, 0x01, 0xD0, 0x83, 0x81, 0x29, 0xE9, 0x73, 0x01, 0xD0, 0x77, 0x73,
  0x02, 0xD0, 0x57, 0x73, 0x04, 0xD0, 0x27, 0x73, 0x08, 0xC0, 0xC7, 0x74, 0x0D, 0xC0, 0x57, 0x73,
  0x05, 0xC0, 0xB7, 0x73, 0x01, 0x0E, 0xB0, 0xD0, 0x17, 0x72, 0x02, 0x0D, 0xB0, 0xD0, 0x27, 0x78,
  0x11, 0x49, 0xC0, 0xB0, 0x17, 0x50, 0xAF, 0x0B, 0x05, 0x77, 0x0A, 0xF8, 0x1B, 0x72, 0x76, 0x0A,
  0xFB, 0x0A, 0x02, 0x75, 0x84, 0x11, 0x23, 0x7C, 0xE0, 0x67, 0x73, 0x04, 0x0E, 0xD0, 0x67, 0x73,
  0x02, 0x0D, 0xD0, 0x37, 0x73, 0x03, 0xD0, 0xC7, 0x74, 0x0A, 0xD0, 0x37, 0x73, 0x04, 0xD0, 0x77,
  0x74, 0xD0, 0xA7, 0x74, 0x0D, 0xC0, 0xC7, 0x74, 0x0C, 0xC0, 0xD7, 0x74, 0x0C, 0xC0, 0xC7, 0x74,
  0x0D, 0xC0, 0xC2, 0x81, 0x7C, 0x77, 0x60, 0xEC, 0x81, 0xA0, 0xAA, 0x09, 0x75, 0x01, 0xD0, 0x70,
  0x3B, 0x0C, 0x75, 0x06, 0xD0, 0x30, 0x6C, 0x02, 0x74, 0x0C, 0xC8, 0x1D, 0x05, 0xC0, 0xA7, 0x30,
  0x5D, 0x81, 0x50, 0x2D, 0x06, 0x71, 0x03, 0x0E, 0xC0, 0xB3, 0x0A, 0xD0, 0x80, 0x14, 0x81, 0x17,
  0xEC, 0x0D, 0x01, 0x30, 0x10, 0xDE, 0x82, 0xB9, 0x9B, 0xE0, 0xD0, 0x15, 0x01, 0x0C, 0xFF, 0x08,
  0x72, 0x05, 0x0B, 0xFA, 0x81, 0xD7, 0x17, 0x68, 0x63, 0x56, 0x77, 0x64, 0x17, 0x20,
  // "4" (U+0034)
  0x77, 0x20, 0xDC, 0x0B, 0x77, 0x70, 0x6D, 0x0B, 0x77, 0x70, 0xED, 0x0B, 0x77, 0x60, 0x7E, 0x0B,
  0x77, 0x58, 0x21, 0xEF, 0xDC, 0x0B, 0x77, 0x50, 0x9A, 0x07, 0xC0, 0xB7, 0x74, 0x02, 0xA0, 0xA0,
  0x5C, 0x0B, 0x77, 0x40, 0xAA, 0x03, 0x06, 0xC0, 0xB7, 0x73, 0x03, 0xA8, 0x1B, 0x06, 0xC0, 0xB7,
  0x73, 0x0B, 0xA8, 0x13, 0x07, 0xC0, 0xB7, 0x72, 0x04, 0xA0, 0xB2, 0x07, 0xC0, 0xB7, 0x72, 0x0C,
  0xA0, 0x32, 0x08, 0xC0, 0xB7, 0x71, 0x05, 0xA0, 0xB3, 0x08, 0xC0, 0xB7, 0x71, 0x0D, 0xA0, 0x33,
  0x08, 0xC0, 0xB7, 0x70, 0x6A, 0x0B, 0x40, 0x8C, 0x0B, 0x77, 0x0E, 0xA0, 0x24, 0x08, 0xC0, 0xB7,
  0x60, 0x8A, 0x09, 0x50, 0x8C, 0x0B, 0x75, 0x01, 0x0E, 0xA0, 0x25, 0x08, 0xC0, 0xB7, 0x50, 0x9A,
  0x09, 0x60, 0x8C, 0x0B, 0x74, 0x02, 0xA0, 0xE0, 0x16, 0x08, 0xC0, 0xB7, 0x40, 0xAA, 0x07, 0x70,
  0x8C, 0x0B, 0x73, 0x03, 0xA0, 0xE7, 0x10, 0x8C, 0x0B, 0x73, 0x0B, 0xA0, 0x67, 0x10, 0x8C, 0x0B,
  0x72, 0x04, 0xA0, 0xD7, 0x20, 0x8C, 0x0B, 0x72, 0x0C, 0xA0, 0x57, 0x20, 0x8C, 0x0B, 0x71, 0x05,
  0xA0, 0xD7, 0x30, 0x8C, 0x0B, 0x71, 0x0D, 0xA0, 0x47, 0x30, 0x8C, 0x0B, 0x70, 0x6A, 0x0C, 0x80,
  0x71, 0x09, 0xC0, 0xB8, 0x02, 0x11, 0x0E, 0xFF, 0xFC, 0x0D, 0x02, 0xFF, 0xFD, 0x0D, 0x02, 0xFF,
  0xFD, 0x0D, 0x77, 0x20, 0x8C, 0x0B, 0x77, 0x71, 0x08, 0xC0, 0xB7, 0x77, 0x10, 0x8C, 0x0B, 0x77,
  0x71, 0x08, 0xC0, 0xB7, 0x77, 0x10, 0x8C, 0x0B, 0x77, 0x71, 0x09, 0xC0, 0xB7, 0x77, 0x10, 0xBC,
  0x0E, 0x77, 0x70, 0x2E, 0x04, 0x77, 0x28, 0x31, 0x13, 0x8E, 0xF8, 0x19, 0x31, 0x75, 0x03, 0xFF,
  0x90, 0x97, 0x40, 0x3F, 0xF9, 0x09, 0x74, 0x03, 0xFF, 0x90, 0x91,
  // "5" (U+0035)
  0x30, 0x2F, 0xFB, 0x05, 0x40, 0x3F, 0xFB, 0x05, 0x40, 0x5F, 0xFB, 0x06, 0x40, 0x6F, 0xFB, 0x06,
  0x40, 0x7F, 0xFB, 0x06, 0x40, 0x8A, 0x02, 0x73, 0x03, 0x0E, 0xA0, 0x64, 0x09, 0xA0, 0x17, 0x40,
  0x7A, 0x07, 0x40, 0xBA, 0x75, 0x02, 0xA0, 0x74, 0x81, 0xCF, 0xE7, 0x68, 0x1E, 0xF7, 0x48, 0x1D,
  0xFD, 0x76, 0x00, 0x15, 0x81, 0xEF, 0xB7, 0x76, 0xA0, 0xA7, 0x75, 0x01, 0xA0, 0x97, 0x75, 0x03,
  0xA0, 0x77, 0x75, 0x04, 0xA0, 0x67, 0x75, 0x05, 0xA0, 0x57, 0x75, 0x06, 0xA0, 0x47, 0x75, 0x07,
  0xA8, 0x91, 0x46, 0x9C, 0xEF, 0xED, 0xC8, 0x47, 0x20, 0x9F, 0xE0, 0xC0, 0x57, 0x0A, 0xFF, 0x90,
  0xA6, 0x0B, 0xA8, 0x7C, 0x74, 0x21, 0x24, 0x8E, 0xD0, 0xC5, 0x81, 0x59, 0x37, 0x10, 0x10, 0xBD,
  0x0A, 0x77, 0x30, 0xBD, 0x05, 0x77, 0x20, 0x10, 0xEC, 0x0C, 0x77, 0x30, 0x8D, 0x03, 0x77, 0x20,
  0x2D, 0x07, 0x77, 0x30, 0xEC, 0x0B, 0x77, 0x30, 0xCC, 0x0D, 0x77, 0x30, 0xAC, 0x0E, 0x77, 0x30,
  0x9D, 0x77, 0x30, 0xAD, 0x77, 0x30, 0xAC, 0x0E, 0x77, 0x30, 0xCC, 0x0C, 0x30, 0x47, 0x60, 0xEC,
  0x84, 0x90, 0x3E, 0xF1, 0x74, 0x01, 0xD8, 0x15, 0x0D, 0xA0, 0x47, 0x40, 0x6D, 0x01, 0x02, 0xB0,
  0x87, 0x40, 0xCC, 0x81, 0x90, 0x3B, 0x0E, 0x01, 0x72, 0x05, 0xD8, 0x12, 0x01, 0xC0, 0xA7, 0x10,
  0x20, 0xEC, 0x07, 0x30, 0xBC, 0x0A, 0x01, 0x50, 0x60, 0xEC, 0x0A, 0x40, 0x20, 0xED, 0x83, 0xC9,
  0x9B, 0xED, 0x0A, 0x60, 0x30, 0xDF, 0xD0, 0xE0, 0x67, 0x20, 0x70, 0xDF, 0x98, 0x1D, 0x81, 0x75,
  0x86, 0x14, 0x67, 0x76, 0x52, 0x72,
  // "6" (U+0036)
  0x73, 0x85, 0x25, 0x67, 0x65, 0x27, 0x71, 0x07, 0x0D, 0xF0, 0xD0, 0x67, 0x40, 0x30, 0xDF, 0xC0,
  0xC0, 0x17, 0x10, 0x5D, 0x82, 0xDA, 0x9B, 0xD0, 0xC7, 0x03, 0xC0, 0xE0, 0x54, 0x03, 0x0D, 0xC0,
  0x76, 0x0D, 0xC0, 0x36, 0x03, 0xC0, 0xD5, 0x09, 0xC0, 0x77, 0x10, 0xBC, 0x40, 0x1C, 0x0E, 0x72,
  0x07, 0xC4, 0x08, 0xC0, 0x77, 0x20, 0x4B, 0x0B, 0x40, 0xEC, 0x02, 0x72, 0x02, 0xA0, 0xC0, 0x23,
  0x04, 0xC0, 0xD7, 0x40, 0x50, 0x35, 0x09, 0xC0, 0x97, 0x74, 0x0D, 0xC0, 0x67, 0x73, 0x01, 0xD0,
  0x37, 0x73, 0x04, 0xD0, 0x17, 0x73, 0x06, 0xC0, 0xE7, 0x74, 0x09, 0xC0, 0xD7, 0x74, 0x0A, 0xC0,
  0xB7, 0x74, 0x0C, 0xC0, 0xA3, 0x81, 0x6C, 0xEA, 0x82, 0xEB, 0x71, 0x60, 0xDC, 0x82, 0x90, 0x4D,
  0xF9, 0x0E, 0x06, 0x50, 0xEC, 0x09, 0x08, 0xFD, 0x09, 0x40, 0xEC, 0x0E, 0xA8, 0x5D, 0x62, 0x01,
  0x4B, 0xD0, 0x83, 0xF0, 0x97, 0x08, 0xD0, 0x32, 0xE0, 0x77, 0x20, 0xCC, 0x0C, 0x2D, 0x0A, 0x73,
  0x04, 0xD8, 0x13, 0x0E, 0xC0, 0x87, 0x40, 0xEC, 0x81, 0x80, 0xEC, 0x08, 0x74, 0x0B, 0xC8, 0x1B,
  0x0C, 0xC0, 0x97, 0x40, 0x9C, 0x81, 0xE0, 0xBC, 0x0A, 0x74, 0x07, 0xD1, 0x0A, 0xC0, 0xB7, 0x40,
  0x6D, 0x01, 0x07, 0xC0, 0xD7, 0x40, 0x5D, 0x02, 0x05, 0xD7, 0x40, 0x5D, 0x01, 0x02, 0xD0, 0x17,
  0x30, 0x6D, 0x20, 0xEC, 0x04, 0x73, 0x07, 0xC0, 0xD2, 0x0A, 0xC0, 0x77, 0x30, 0x9C, 0x0B, 0x20,
  0x5C, 0x0B, 0x73, 0x0B, 0xC0, 0x73, 0x0E, 0xC0, 0x17, 0x20, 0xEC, 0x03, 0x30, 0x9C, 0x07, 0x71,
  0x03, 0xC0, 0xD4, 0x01, 0xC0, 0xE0, 0x17, 0x09, 0xC0, 0x65, 0x08, 0xC0, 0xA6, 0x03, 0xC0, 0xD7,
  0x0C, 0xC0, 0x94, 0x03, 0x0E, 0xC0, 0x37, 0x01, 0x0D, 0xC8, 0x2E, 0xA9, 0xCD, 0x05, 0x72, 0x01,
  0x0B, 0xFB, 0x0E, 0x04, 0x75, 0x05, 0x0C, 0xE8, 0x1E, 0x81, 0x77, 0x18, 0x42, 0x57, 0x76, 0x37,
  0x20,
  // "7" (U+0037)
  0x10, 0xEF, 0xFF, 0x90, 0x11, 0xFF, 0xFA, 0x01, 0x1F, 0xFF, 0x90, 0xD2, 0xFF, 0xF9, 0x08, 0x2F,
  0xFF, 0x98, 0x13, 0x01, 0xB0, 0xB0, 0x27, 0x50, 0x8B, 0x0E, 0x20, 0x1A, 0x0E, 0x01, 0x76, 0x0D,
  0xB0, 0x92, 0x02, 0xA0, 0xA7, 0x60, 0x3C, 0x04, 0x20, 0x2A, 0x07, 0x76, 0x08, 0xB0, 0xE3, 0x03,
  0xA0, 0x67, 0x60, 0xDB, 0x0A, 0x30, 0x3A, 0x05, 0x75, 0x03, 0xC0, 0x57, 0x75, 0x08, 0xC7, 0x76,
  0x0D, 0xB0, 0xA7, 0x75, 0x03, 0xC0, 0x67, 0x75, 0x08, 0xC0, 0x17, 0x75, 0x0D, 0xB0, 0xB7, 0x75,
  0x03, 0xC0, 0x67, 0x75, 0x09, 0xC0, 0x17, 0x75, 0x0E, 0xB0, 0xC7, 0x75, 0x04, 0xC0, 0x77, 0x75,
  0x09, 0xC0, 0x27, 0x75, 0x0E, 0xB0, 0xD7, 0x75, 0x04, 0xC0, 0x87, 0x75, 0x09, 0xC0, 0x37, 0x75,
  0x0E, 0xB0, 0xD7, 0x75, 0x04, 0xC0, 0x87, 0x75, 0x09, 0xC0, 0x37, 0x75, 0x0E, 0xB0, 0xE7, 0x75,
  0x04, 0xC0, 0x97, 0x75, 0x09, 0xC0, 0x47, 0x75, 0x0E, 0xB0, 0xE7, 0x75, 0x04, 0xC0, 0xA7, 0x75,
  0x0A, 0xC0, 0x57, 0x75, 0x0E, 0xC7, 0x75, 0x05, 0xC0, 0xB7, 0x75, 0x0A, 0xC0, 0x67, 0x75, 0x0E,
  0xC0, 0x17, 0x74, 0x05, 0xC0, 0xB7, 0x75, 0x0A, 0xC0, 0x67, 0x75, 0xD0, 0x17, 0x74, 0x05, 0xC0,
  0xC7, 0x75, 0x0A, 0xC0, 0x77, 0x75, 0xD0, 0x27, 0x60,
  // "8" (U+0038)
  0x72, 0x85, 0x35, 0x67, 0x65, 0x27, 0x71, 0x81, 0x29, 0xEF, 0x0D, 0x07, 0x75, 0x08, 0xFD, 0x0E,
  0x03, 0x72, 0x0A, 0xD8, 0x3D, 0xA9, 0xAE, 0xD0, 0x47, 0x08, 0xC0, 0xE0, 0x55, 0x08, 0xC0, 0xE0,
  0x25, 0x03, 0xD0, 0x37, 0x09, 0xC0, 0xA5, 0x0A, 0xC0, 0x87, 0x20, 0xEC, 0x02, 0x4D, 0x01, 0x72,
  0x07, 0xC0, 0x73, 0x04, 0xC0, 0xD7, 0x30, 0x3C, 0x0A, 0x30, 0x7C, 0x0B, 0x74, 0xC0, 0xC3, 0x08,
  0xC0, 0xA7, 0x4C, 0x0D, 0x30, 0x8C, 0x0A, 0x74, 0xC0, 0xD3, 0x07, 0xC0, 0xC7, 0x30, 0x1C, 0x0C,
  0x30, 0x6D, 0x73, 0x02, 0xC0, 0x93, 0x03, 0xD0, 0x67, 0x20, 0x6C, 0x06, 0x40, 0xDC, 0x0E, 0x01,
  0x71, 0x0B, 0xC0, 0x14, 0x07, 0xD0, 0xB7, 0x02, 0xC0, 0x86, 0x0D, 0xD0, 0xC0, 0x15, 0x0B, 0xB0,
  0xC7, 0x03, 0xE0, 0xE0, 0x43, 0x09, 0xB0, 0xD0, 0x17, 0x10, 0x4F, 0x81, 0xA3, 0xBB, 0x0C, 0x01,
  0x73, 0x04, 0x0E, 0xFB, 0x08, 0x76, 0x02, 0x0C, 0xF9, 0x07, 0x77, 0x10, 0x6F, 0xA0, 0xB0, 0x27,
  0x40, 0x20, 0xBB, 0x0D, 0xF9, 0x06, 0x72, 0x04, 0x0E, 0xB8, 0x26, 0x04, 0xCF, 0x09, 0x70, 0x5C,
  0x05, 0x40, 0x7F, 0x09, 0x50, 0x5C, 0x08, 0x60, 0x20, 0xDE, 0x06, 0x30, 0x20, 0xEB, 0x0D, 0x71,
  0x01, 0x0B, 0xE0, 0x22, 0x0A, 0xC0, 0x67, 0x30, 0xCD, 0x81, 0x80, 0x1D, 0x01, 0x73, 0x01, 0x0E,
  0xC8, 0x1E, 0x05, 0xC0, 0xC7, 0x50, 0x8D, 0x02, 0x08, 0xC0, 0x97, 0x50, 0x2D, 0x04, 0x0A, 0xC0,
  0x87, 0x60, 0xEC, 0x05, 0x0A, 0xC0, 0x77, 0x60, 0xDC, 0x05, 0x0A, 0xC0, 0x87, 0x60, 0xDC, 0x04,
  0x08, 0xC0, 0xA7, 0x60, 0xEC, 0x03, 0x05, 0xC0, 0xD7, 0x50, 0x2C, 0x81, 0xE0, 0x1D, 0x03, 0x74,
  0x08, 0xC0, 0xA2, 0x0A, 0xC0, 0xB7, 0x30, 0x10, 0xEC, 0x03, 0x20, 0x2D, 0x07, 0x71, 0x01, 0x0C,
  0xC0, 0xB4, 0x07, 0xD0, 0x90, 0x15, 0x04, 0x0D, 0xC0, 0xD0, 0x15, 0x08, 0xE8, 0x3C, 0x99, 0xAE,
  0xD0, 0xD0, 0x27, 0x05, 0x0E, 0xFE, 0x09, 0x73, 0x81, 0x17, 0xDF, 0x98, 0x1E, 0x92, 0x77, 0x86,
  0x14, 0x67, 0x76, 0x52, 0x72,
  // "9" (U+0039)
  0x71, 0x84, 0x14, 0x67, 0x64, 0x77, 0x20, 0x40, 0xBF, 0x0A, 0x03, 0x75, 0x09, 0xFC, 0x08, 0x73,
  0x0B, 0xD8, 0x2B, 0x9B, 0xEC, 0x0B, 0x71, 0x09, 0xC0, 0xD0, 0x23, 0x01, 0x0B, 0xC0, 0x96, 0x04,
  0xC0, 0xE0, 0x26, 0x0B, 0xC0, 0x55, 0x0C, 0xC0, 0x77, 0x02, 0xC0, 0xD4, 0x04, 0xD0, 0x17, 0x10,
  0x9C, 0x06, 0x30, 0x9C, 0x0B, 0x72, 0x03, 0xC0, 0xD3, 0x0E, 0xC0, 0x77, 0x30, 0xDC, 0x81, 0x30,
  0x1D, 0x05, 0x73, 0x0A, 0xC8, 0x17, 0x04, 0xD0, 0x37, 0x30, 0x7C, 0x81, 0xC0, 0x6D, 0x01, 0x73,
  0x04, 0xD1, 0x07, 0xD0, 0x17, 0x30, 0x2D, 0x02, 0x08, 0xD7, 0x5D, 0x04, 0x07, 0xD0, 0x17, 0x40,
  0xEC, 0x06, 0x07, 0xD0, 0x17, 0x40, 0xEC, 0x07, 0x05, 0xD0, 0x37, 0x40, 0xDC, 0x09, 0x03, 0xD0,
  0x57, 0x40, 0xCC, 0x81, 0x90, 0xEC, 0x09, 0x74, 0x0C, 0xC8, 0x1A, 0x0A, 0xC0, 0xE7, 0x30, 0x5D,
  0x81, 0xA0, 0x3D, 0x06, 0x71, 0x02, 0x0E, 0xD0, 0xA2, 0x0B, 0xD0, 0x36, 0x02, 0x0D, 0xE0, 0x92,
  0x01, 0x0E, 0xD8, 0x49, 0x31, 0x14, 0x8A, 0x0B, 0x0D, 0xC0, 0x93, 0x02, 0x0D, 0xFC, 0x81, 0xB0,
  0xEC, 0x08, 0x40, 0x10, 0x9F, 0xA0, 0x72, 0x0E, 0xC0, 0x76, 0x87, 0x28, 0xCE, 0xFE, 0xC8, 0x23,
  0xD0, 0x57, 0x73, 0x01, 0xD0, 0x47, 0x73, 0x03, 0xD0, 0x17, 0x73, 0x04, 0xC0, 0xE7, 0x74, 0x07,
  0xC0, 0xC7, 0x74, 0x09, 0xC0, 0x87, 0x74, 0x0C, 0xC0, 0x57, 0x74, 0xD0, 0x17, 0x73, 0x03, 0xC0,
  0xB7, 0x74, 0x08, 0xC0, 0x65, 0x02, 0x75, 0x0D, 0xB0, 0xE5, 0x81, 0x5F, 0x37, 0x30, 0x5C, 0x07,
  0x58, 0x1C, 0xFB, 0x73, 0x0D, 0xB0, 0xD6, 0x0E, 0xA0, 0x87, 0x10, 0xAC, 0x04, 0x60, 0xDB, 0x08,
  0x50, 0x20, 0xBC, 0x07, 0x70, 0x7C, 0x83, 0xEB, 0x99, 0xCD, 0x08, 0x72, 0x0B, 0xFC, 0x0E, 0x05,
  0x74, 0x07, 0x0E, 0xF8, 0x1D, 0x81, 0x77, 0x85, 0x35, 0x77, 0x65, 0x27, 0x40,
  // ":" (U+003A)
  0x18, 0x58, 0xDE, 0xA2, 0x08, 0xC8, 0x1E, 0x0D, 0xD0, 0x5E, 0x07, 0xE0, 0x70, 0xDD, 0x05, 0x08,
  0xC0, 0xE2, 0x83, 0x8D, 0xEA, 0x28, 0x09, 0xD6, 0x08, 0x21, 0x56, 0x32, 0x03, 0x0E, 0xB8, 0x18,
  0x0B, 0xD0, 0x2E, 0x06, 0xE0, 0x7E, 0x06, 0x0B, 0xD8, 0x12, 0x3E, 0xB0, 0x82, 0x82, 0x15, 0x63,
  0x20,
  // ";" (U+003B)
  0x38, 0x38, 0xDE, 0xB2, 0x30, 0x8C, 0x0E, 0x30, 0xDD, 0x05, 0x2E, 0x07, 0x2E, 0x07, 0x20, 0xDD,
  0x05, 0x20, 0x8C, 0x0E, 0x48, 0x38, 0xDE, 0xB2, 0x80, 0xAB, 0x10, 0x82, 0x37, 0x61, 0x40, 0x8B,
  0x0E, 0x03, 0x20, 0x2D, 0x0D, 0x20, 0x5E, 0x81, 0x50, 0x5E, 0x82, 0x80, 0x1E, 0xD0, 0xA2, 0x03,
  0x0E, 0xC0, 0xA3, 0x02, 0x0C, 0xB0, 0x84, 0x01, 0xB0, 0x65, 0x0D, 0xA0, 0x25, 0xA0, 0xC5, 0x06,
  0xA0, 0x54, 0x82, 0x2E, 0xFC, 0x48, 0x34, 0xEF, 0xE2, 0x20, 0x20, 0xAA, 0x0E, 0x03, 0x30, 0x7A,
  0x0A, 0x01, 0x48, 0x17, 0xA3, 0x60,
  // "<" (U+003C)
  0x77, 0x70, 0x17, 0x76, 0x05, 0x0D, 0x77, 0x48, 0x22, 0xBF, 0xE7, 0x73, 0x07, 0xB0, 0xE7, 0x71,
  0x03, 0x0D, 0xC0, 0xC7, 0x60, 0x10, 0x9D, 0x08, 0x76, 0x05, 0x0E, 0xC0, 0xC0, 0x37, 0x50, 0x20,
  0xBD, 0x07, 0x76, 0x07, 0x0E, 0xC0, 0xB0, 0x27, 0x50, 0x30, 0xCC, 0x0E, 0x06, 0x76, 0x09, 0xD0,
  0xA0, 0x17, 0x50, 0x50, 0xDC, 0x0D, 0x04, 0x75, 0x01, 0x0A, 0xD0, 0x97, 0x60, 0x60, 0xEC, 0x0D,
  0x03, 0x76, 0x0C, 0xD0, 0x87, 0x71, 0xD0, 0x47, 0x72, 0x0D, 0xC0, 0xE0, 0x57, 0x72, 0x08, 0xD0,
  0xB0, 0x27, 0x71, 0x02, 0x0C, 0xD0, 0x77, 0x72, 0x06, 0x0E, 0xC0, 0xC0, 0x37, 0x71, 0x01, 0x0A,
  0xD0, 0x97, 0x72, 0x04, 0x0D, 0xC0, 0xD0, 0x57, 0x72, 0x08, 0xD0, 0xA0, 0x17, 0x71, 0x03, 0x0C,
  0xC0, 0xE0, 0x67, 0x72, 0x06, 0x0E, 0xC0, 0xC0, 0x27, 0x71, 0x01, 0x0A, 0xD0, 0x87, 0x72, 0x04,
  0x0D, 0xC0, 0xC7, 0x73, 0x08, 0xB0, 0xE7, 0x74, 0x82, 0x3C, 0xFE, 0x77, 0x60, 0x60, 0xE7, 0x77,
  0x01,
  // "=" (U+003D)
  0xFF, 0xF0, 0xEF, 0xFF, 0x0E, 0xFF, 0xF0, 0xE8, 0x0A, 0x21, 0x80, 0xAA, 0x60, 0x80, 0xA2, 0x1F,
  0xFF, 0x0E, 0xFF, 0xF0, 0xEF, 0xFF, 0x0E,
  // ">" (U+003E)
  0x01, 0x77, 0x70, 0xE0, 0x57, 0x76, 0xA0, 0xB0, 0x27, 0x74, 0xB0, 0xE0, 0x77, 0x73, 0x0D, 0xC0,
  0xC0, 0x37, 0x72, 0x08, 0xD0, 0x97, 0x72, 0x03, 0x0D, 0xC0, 0xD0, 0x57, 0x72, 0x07, 0xD0, 0xA0,
  0x17, 0x71, 0x02, 0x0C, 0xC0, 0xE0, 0x67, 0x72, 0x06, 0x0E, 0xC0, 0xC0, 0x37, 0x71, 0x01, 0x0B,
  0xD0, 0x87, 0x72, 0x05, 0x0E, 0xC0, 0xD0, 0x47, 0x71, 0x01, 0x0A, 0xD0, 0xA0, 0x17, 0x71, 0x04,
  0x0D, 0xC0, 0xE0, 0x67, 0x72, 0x09, 0xD0, 0xB7, 0x72, 0x05, 0xC0, 0xE7, 0x71, 0x06, 0x0E, 0xC0,
  0xC7, 0x60, 0x20, 0xCD, 0x08, 0x76, 0x08, 0xD0, 0xB0, 0x27, 0x50, 0x40, 0xDC, 0x0E, 0x06, 0x75,
  0x01, 0x09, 0xD0, 0xA0, 0x17, 0x50, 0x50, 0xEC, 0x0D, 0x04, 0x75, 0x02, 0x0B, 0xD0, 0x87, 0x60,
  0x70, 0xEC, 0x0B, 0x02, 0x75, 0x03, 0x0C, 0xC0, 0xE0, 0x67, 0x60, 0x8D, 0x0A, 0x01, 0x76, 0x0D,
  0xC0, 0xD0, 0x47, 0x71, 0xC0, 0x87, 0x73, 0xA0, 0xB0, 0x27, 0x74, 0x0E, 0x06, 0x77, 0x60, 0x17,
  0x77,
  // "?" (U+003F)
  0x68, 0x62, 0x56, 0x77, 0x64, 0x17, 0x48, 0x11, 0x8E, 0xF9, 0x0C, 0x05, 0x71, 0x06, 0x0E, 0xFD,
  0x0D, 0x02, 0x50, 0x6E, 0x82, 0xC9, 0x9B, 0xD0, 0xE0, 0x43, 0x02, 0xD0, 0xC0, 0x24, 0x02, 0x0B,
  0xC0, 0xE0, 0x22, 0x09, 0xC0, 0xE0, 0x17, 0x0D, 0xC0, 0xC2, 0x0D, 0xC0, 0x77, 0x10, 0x4D, 0x81,
  0x40, 0xEC, 0x01, 0x72, 0x0D, 0xC8, 0x19, 0x0C, 0xB0, 0xD7, 0x30, 0x9C, 0x81, 0xD0, 0x4B, 0x0B,
  0x73, 0x07, 0xD2, 0x82, 0x39, 0xDA, 0x73, 0x06, 0xD0, 0x17, 0x71, 0x06, 0xD0, 0x27, 0x71, 0x06,
  0xD0, 0x17, 0x71, 0x09, 0xD7, 0x72, 0x0B, 0xC0, 0xC7, 0x71, 0x01, 0xD0, 0x97, 0x71, 0x06, 0xD0,
  0x37, 0x71, 0x0D, 0xC0, 0xC7, 0x71, 0x07, 0xD0, 0x47, 0x70, 0x3D, 0x08, 0x77, 0x03, 0x0E, 0xC0,
  0xA7, 0x70, 0x6D, 0x09, 0x76, 0x03, 0x0B, 0xC0, 0xE0, 0x67, 0x60, 0x1D, 0x0B, 0x02, 0x77, 0x01,
  0xB0, 0xC0, 0x47, 0x73, 0xB0, 0x77, 0x74, 0xB0, 0x67, 0x74, 0x0E, 0xA0, 0x57, 0x74, 0x0D, 0xA0,
  0x47, 0x74, 0x0C, 0xA0, 0x37, 0x74, 0x0C, 0xA0, 0x27, 0x74, 0x81, 0x46, 0x68, 0x09, 0xC7, 0x08,
  0x14, 0x75, 0x77, 0x40, 0xAB, 0x0D, 0x01, 0x77, 0x10, 0x4D, 0x09, 0x77, 0x10, 0x8D, 0x0D, 0x77,
  0x10, 0x9D, 0x0E, 0x77, 0x10, 0x8D, 0x0D, 0x77, 0x10, 0x4D, 0x09, 0x77, 0x20, 0xAB, 0x0D, 0x01,
  0x77, 0x38, 0x14, 0x75, 0x74,
  // "@" (U+0040)
  0x77, 0x48, 0x92, 0x37, 0xAC, 0xEE, 0xFE, 0xDA, 0x84, 0x77, 0x76, 0x81, 0x28, 0xEF, 0xD8, 0x1E,
  0x81, 0x77, 0x71, 0x01, 0x0A, 0xFF, 0xB0, 0xE0, 0x77, 0x76, 0x07, 0xE8, 0x90, 0xB7, 0x42, 0x11,
  0x24, 0x7C, 0xD0, 0xB0, 0x17, 0x72, 0x01, 0x0B, 0xC8, 0x1D, 0x71, 0x73, 0x01, 0x09, 0xC0, 0xD0,
  0x17, 0x70, 0x20, 0xDC, 0x08, 0x77, 0x10, 0x20, 0xCB, 0x0D, 0x01, 0x75, 0x03, 0x0E, 0xB0, 0xD0,
  0x37, 0x74, 0x09, 0xB0, 0xB7, 0x40, 0x20, 0xEB, 0x0B, 0x01, 0x77, 0x60, 0x9B, 0x06, 0x73, 0x0D,
  0xB0, 0xB7, 0x77, 0x20, 0xCA, 0x0E, 0x72, 0x0A, 0xB0, 0xC7, 0x77, 0x30, 0x2B, 0x07, 0x70, 0x5B,
  0x0E, 0x01, 0x77, 0x74, 0x08, 0xA0, 0xD7, 0x0E, 0xB0, 0x47, 0x28, 0x65, 0x9D, 0xEF, 0xDA, 0x42,
  0x81, 0x17, 0x44, 0x01, 0xB0, 0x45, 0x08, 0xB0, 0x97, 0x10, 0x50, 0xDF, 0x98, 0x3C, 0x6E, 0xF6,
  0x50, 0xAA, 0x08, 0x40, 0x1B, 0x0E, 0x01, 0x70, 0x8B, 0x84, 0xE7, 0x32, 0x5C, 0xD0, 0x35, 0x06,
  0xA0, 0xC4, 0x08, 0xB0, 0x77, 0x0A, 0xB0, 0xB0, 0x15, 0x0B, 0xC6, 0x01, 0xB4, 0x0E, 0xA0, 0xE0,
  0x16, 0x08, 0xB0, 0xD0, 0x16, 0x06, 0xB0, 0xD7, 0x0E, 0xA0, 0x22, 0x05, 0xB0, 0x96, 0x04, 0xC0,
  0x27, 0x09, 0xB0, 0xB7, 0x0C, 0xA0, 0x42, 0x0B, 0xB0, 0x36, 0x0D, 0xB0, 0x97, 0x10, 0xCB, 0x08,
  0x70, 0xAA, 0x05, 0x2B, 0x0D, 0x60, 0x7C, 0x01, 0x71, 0x0E, 0xB0, 0x57, 0x0A, 0xA8, 0x16, 0x05,
  0xB0, 0x86, 0x0E, 0xB0, 0xA7, 0x10, 0x1C, 0x03, 0x70, 0x9A, 0x81, 0x60, 0x9B, 0x04, 0x50, 0x5C,
  0x05, 0x71, 0x04, 0xC7, 0x10, 0x9A, 0x81, 0x60, 0xCB, 0x60, 0xAC, 0x72, 0x07, 0xB0, 0xD7, 0x10,
  0xAA, 0x05, 0x1B, 0x0C, 0x60, 0xEB, 0x0C, 0x72, 0x09, 0xB0, 0xA7, 0x10, 0xBA, 0x04, 0x02, 0xB0,
  0x95, 0x02, 0xC0, 0x87, 0x20, 0xCB, 0x08, 0x71, 0x0C, 0xA0, 0x20, 0x4B, 0x07, 0x50, 0x5C, 0x05,
  0x72, 0x0E, 0xB0, 0x57, 0x10, 0xEA, 0x01, 0x06, 0xB0, 0x55, 0x08, 0xC0, 0x37, 0x10, 0x2C, 0x02,
  0x70, 0x1A, 0x81, 0xD0, 0x7B, 0x04, 0x50, 0x9C, 0x01, 0x71, 0x04, 0xC7, 0x10, 0x4A, 0x81, 0xA0,
  0x8B, 0x03, 0x50, 0xAC, 0x72, 0x07, 0xB0, 0xD7, 0x10, 0x8A, 0x81, 0x60, 0x9B, 0x02, 0x50, 0xAC,
  0x72, 0x0A, 0xB0, 0xB7, 0x10, 0xDA, 0x81, 0x10, 0x9B, 0x02, 0x50, 0x9C, 0x72, 0x0E, 0xB0, 0xA7,
  0x03, 0xA0, 0xB2, 0x09, 0xB0, 0x25, 0x07, 0xC0, 0x17, 0x04, 0xC0, 0x97, 0x09, 0xA0, 0x52, 0x08,
  0xB0, 0x35, 0x04, 0xC0, 0x47, 0x0A, 0xC0, 0xA6, 0x02, 0xA0, 0xD3, 0x08, 0xB0, 0x36, 0xC0, 0x86,
  0x82, 0x2F, 0xDB, 0xA0, 0xC6, 0x0B, 0xA0, 0x63, 0x06, 0xB0, 0x56, 0x09, 0xB0, 0xE0, 0x15, 0x82,
  0xCF, 0x56, 0xB0, 0x24, 0x07, 0xA0, 0xB4, 0x04, 0xB0, 0x76, 0x02, 0x0E, 0xB0, 0xD0, 0x32, 0x82,
  0x2B, 0xFB, 0x20, 0xEA, 0x0D, 0x02, 0x20, 0x8A, 0x0E, 0x02, 0x40, 0x2B, 0x0A, 0x70, 0x5D, 0x00,
  0xDA, 0x0D, 0x01, 0x20, 0x6C, 0x0D, 0x0E, 0xA0, 0xE0, 0x36, 0x0E, 0xA0, 0xD7, 0x10, 0x50, 0xEE,
  0x0D, 0x02, 0x40, 0x9E, 0x0D, 0x03, 0x70, 0xBB, 0x02, 0x71, 0x85, 0x18, 0xDE, 0xEC, 0x77, 0x84,
  0x5B, 0xEF, 0xC7, 0x72, 0x07, 0xB0, 0x78, 0x0C, 0x10, 0x02, 0xB0, 0xD8, 0x0C, 0x20, 0x0A, 0xB0,
  0x58, 0x0C, 0x10, 0x04, 0xB0, 0xD8, 0x0C, 0x20, 0x0A, 0xB0, 0x98, 0x0C, 0x10, 0x01, 0x0E, 0xB0,
  0x67, 0x77, 0x20, 0x90, 0x17, 0x50, 0x5C, 0x07, 0x77, 0x68, 0x24, 0xDF, 0xB7, 0x60, 0x7C, 0x0A,
  0x01, 0x77, 0x20, 0x30, 0xBB, 0x07, 0x77, 0x07, 0xC8, 0x1E, 0x92, 0x75, 0x04, 0x0A, 0xB0, 0xD0,
  0x37, 0x72, 0x05, 0x0E, 0xD8, 0x92, 0xC8, 0x53, 0x21, 0x12, 0x46, 0xAE, 0xC0, 0x80, 0x17, 0x74,
  0x01, 0x0A, 0xFF, 0xC0, 0xB0, 0x27, 0x77, 0x18, 0x12, 0x9E, 0xFE, 0x0A, 0x04, 0x77, 0x76, 0x83,
  0x37, 0xAC, 0xEA, 0x84, 0xED, 0xB9, 0x51, 0x77, 0x20,
  // "A" (U+0041)
  0x77, 0x20, 0xEB, 0x0D, 0x77, 0x77, 0x30, 0x4D, 0x02, 0x77, 0x77, 0x20, 0x9D, 0x07, 0x77, 0x77,
  0x20, 0xED, 0x0C, 0x77, 0x77, 0x10, 0x3F, 0x01, 0x77, 0x77, 0x08, 0xF0, 0x67, 0x77, 0x70, 0xDA,
  0x0A, 0xC0, 0xB7, 0x77, 0x60, 0x3A, 0x0C, 0x05, 0xD0, 0x17, 0x77, 0x50, 0x8A, 0x09, 0x01, 0xD0,
  0x57, 0x77, 0x50, 0xDA, 0x81, 0x50, 0xDC, 0x0A, 0x77, 0x74, 0x02, 0xB8, 0x11, 0x09, 0xC0, 0xE7,
  0x77, 0x40, 0x7A, 0x0C, 0x20, 0x4D, 0x04, 0x77, 0x73, 0x0C, 0xA0, 0x83, 0xD0, 0x97, 0x77, 0x20,
  0x1B, 0x03, 0x30, 0xBC, 0x0E, 0x77, 0x72, 0x06, 0xA0, 0xE4, 0x07, 0xD0, 0x37, 0x77, 0x10, 0xBA,
  0x0A, 0x40, 0x2D, 0x08, 0x77, 0x70, 0x1B, 0x05, 0x50, 0xDC, 0x0D, 0x77, 0x70, 0x6B, 0x01, 0x50,
  0x9D, 0x02, 0x77, 0x60, 0xBA, 0x0B, 0x60, 0x4D, 0x07, 0x77, 0x6B, 0x07, 0x7D, 0x0C, 0x77, 0x50,
  0x5B, 0x02, 0x70, 0xBD, 0x01, 0x77, 0x40, 0xAA, 0x0D, 0x71, 0x06, 0xD0, 0x67, 0x74, 0x0E, 0xA0,
  0x87, 0x10, 0x2D, 0x0B, 0x77, 0x30, 0x4B, 0x04, 0x72, 0x0D, 0xD7, 0x73, 0x09, 0xA0, 0xE7, 0x30,
  0x8D, 0x05, 0x77, 0x20, 0xEA, 0x0A, 0x73, 0x04, 0xD0, 0xA7, 0x71, 0x04, 0xFF, 0xE0, 0xE7, 0x71,
  0x09, 0xFF, 0xF0, 0x47, 0x70, 0xDB, 0x80, 0x91, 0xED, 0x09, 0x76, 0x03, 0xB0, 0x57, 0x50, 0x1D,
  0x0E, 0x76, 0x08, 0xA0, 0xE7, 0x70, 0xBD, 0x03, 0x75, 0x0D, 0xA0, 0xA7, 0x70, 0x6D, 0x08, 0x74,
  0x02, 0xB0, 0x57, 0x70, 0x1D, 0x0D, 0x74, 0x07, 0xB0, 0x17, 0x71, 0x0C, 0xD0, 0x27, 0x30, 0xCA,
  0x0B, 0x77, 0x20, 0x7D, 0x07, 0x72, 0x02, 0xB0, 0x67, 0x72, 0x03, 0xD0, 0xC7, 0x20, 0x8B, 0x03,
  0x77, 0x30, 0xED, 0x01, 0x71, 0x0E, 0xB0, 0x27, 0x73, 0x0C, 0xD0, 0x67, 0x07, 0xC0, 0x67, 0x73,
  0x0E, 0xD0, 0xD4, 0x81, 0x12, 0x7D, 0x82, 0xE7, 0x21, 0x73, 0x82, 0x11, 0x4B, 0xF8, 0x3B, 0x42,
  0x0E, 0xFC, 0x0B, 0x72, 0xFF, 0x08, 0x0E, 0xFC, 0x0B, 0x72, 0xFF, 0x08, 0x0E, 0xFC, 0x0B, 0x72,
  0xFF, 0x08,
  // "B" (U+0042)
  0x02, 0xFF, 0x98, 0x4E, 0xDC, 0x96, 0x27, 0x10, 0x2F, 0xFF, 0x0C, 0x06, 0x68, 0x21, 0x9A, 0xDF,
  0xFE, 0x0C, 0x02, 0x71, 0x04, 0xE8, 0x76, 0x11, 0x11, 0x25, 0x9E, 0xD0, 0xE0, 0x27, 0x10, 0x9D,
  0x05, 0x71, 0x09, 0xD0, 0xD7, 0x10, 0x5D, 0x05, 0x72, 0x0B, 0xD0, 0x77, 0x04, 0xD0, 0x57, 0x20,
  0x3D, 0x0D, 0x70, 0x4D, 0x05, 0x73, 0x0D, 0xD0, 0x26, 0x04, 0xD0, 0x57, 0x30, 0xAD, 0x05, 0x60,
  0x4D, 0x05, 0x73, 0x08, 0xD0, 0x66, 0x04, 0xD0, 0x57, 0x30, 0x7D, 0x07, 0x60, 0x4D, 0x05, 0x73,
  0x08, 0xD0, 0x76, 0x04, 0xD0, 0x57, 0x30, 0x9D, 0x05, 0x60, 0x4D, 0x05, 0x73, 0x0B, 0xD0, 0x26,
  0x04, 0xD0, 0x57, 0x30, 0xEC, 0x0D, 0x70, 0x4D, 0x05, 0x72, 0x05, 0xD0, 0x67, 0x04, 0xD0, 0x57,
  0x20, 0xDC, 0x0B, 0x71, 0x04, 0xD0, 0x57, 0x01, 0x0B, 0xC0, 0xC0, 0x17, 0x10, 0x4D, 0x86, 0x61,
  0x11, 0x12, 0x59, 0xD0, 0xA7, 0x30, 0x4F, 0xFA, 0x0B, 0x04, 0x74, 0x04, 0xFF, 0x98, 0x1E, 0x72,
  0x74, 0x04, 0xFF, 0xC0, 0xB0, 0x37, 0x20, 0x4D, 0x05, 0x58, 0x21, 0x37, 0xDD, 0x07, 0x71, 0x04,
  0xD0, 0x57, 0x20, 0x7D, 0x08, 0x70, 0x4D, 0x05, 0x73, 0x09, 0xD0, 0x46, 0x04, 0xD0, 0x57, 0x30,
  0x10, 0xEC, 0x0D, 0x60, 0x4D, 0x05, 0x74, 0x09, 0xD0, 0x35, 0x04, 0xD0, 0x57, 0x40, 0x5D, 0x08,
  0x50, 0x4D, 0x05, 0x74, 0x02, 0xD0, 0xB5, 0x04, 0xD0, 0x57, 0x40, 0x1D, 0x0D, 0x50, 0x4D, 0x05,
  0x75, 0xD0, 0xE5, 0x04, 0xD0, 0x57, 0x5E, 0x50, 0x4D, 0x05, 0x75, 0xD0, 0xE5, 0x04, 0xD0, 0x57,
  0x40, 0x2D, 0x0D, 0x50, 0x4D, 0x05, 0x74, 0x04, 0xD0, 0xA5, 0x04, 0xD0, 0x57, 0x40, 0x8D, 0x06,
  0x50, 0x4D, 0x05, 0x74, 0x0D, 0xD0, 0x25, 0x06, 0xD0, 0x57, 0x30, 0x7D, 0x09, 0x60, 0x9D, 0x05,
  0x72, 0x07, 0xD0, 0xE0, 0x15, 0x05, 0xE0, 0x68, 0x01, 0x18, 0x22, 0x48, 0xDD, 0x0E, 0x03, 0x28,
  0x21, 0x9A, 0xDF, 0xFF, 0x0D, 0x03, 0x30, 0x2F, 0xFF, 0x90, 0xD0, 0x75, 0x02, 0xFF, 0xA8, 0x4E,
  0xDC, 0xA7, 0x37,
  // "C" (U+0043)
  0x77, 0x86, 0x35, 0x67, 0x66, 0x41, 0x77, 0x38, 0x11, 0x6C, 0xFA, 0x81, 0xC7, 0x17, 0x60, 0x70,
  0xEF, 0xE0, 0xE0, 0x57, 0x30, 0x20, 0xCD, 0x84, 0xEB, 0x99, 0xBE, 0xE0, 0x77, 0x10, 0x30, 0xEC,
  0x0C, 0x04, 0x60, 0x8E, 0x04, 0x60, 0x20, 0xEC, 0x09, 0x72, 0x07, 0xD0, 0xB6, 0x0D, 0xC0, 0xA7,
  0x40, 0xBD, 0x50, 0x8C, 0x0E, 0x01, 0x74, 0x04, 0xD0, 0x13, 0x02, 0xD0, 0x77, 0x60, 0xEB, 0x0E,
  0x40, 0x9D, 0x01, 0x76, 0x0B, 0xB0, 0x73, 0x01, 0xD0, 0xA7, 0x78, 0x29, 0xFE, 0x74, 0x06, 0xD0,
  0x57, 0x70, 0x30, 0x46, 0x0B, 0xD0, 0x17, 0x77, 0x01, 0xD0, 0xE7, 0x77, 0x10, 0x4D, 0x0A, 0x77,
  0x71, 0x07, 0xD0, 0x87, 0x77, 0x10, 0xAD, 0x06, 0x77, 0x71, 0x0C, 0xD0, 0x47, 0x77, 0x10, 0xED,
  0x03, 0x77, 0x71, 0xE0, 0x27, 0x77, 0x1E, 0x02, 0x77, 0x70, 0x1E, 0x01, 0x77, 0x70, 0x1E, 0x01,
  0x77, 0x70, 0x1E, 0x01, 0x77, 0x71, 0xE0, 0x27, 0x77, 0x1E, 0x02, 0x77, 0x71, 0x0E, 0xD0, 0x37,
  0x77, 0x10, 0xCD, 0x04, 0x77, 0x71, 0x0A, 0xD0, 0x67, 0x77, 0x10, 0x7D, 0x08, 0x77, 0x71, 0x04,
  0xD0, 0xB7, 0x77, 0x10, 0x1D, 0x0E, 0x77, 0x72, 0x0C, 0xD0, 0x27, 0x77, 0x10, 0x7D, 0x06, 0x77,
  0x71, 0x02, 0xD0, 0xC7, 0x77, 0x20, 0xAD, 0x03, 0x77, 0x71, 0x03, 0xD0, 0x97, 0x72, 0x04, 0x07,
  0x50, 0xAD, 0x03, 0x77, 0x81, 0x2E, 0xD5, 0x01, 0x0E, 0xC0, 0xD0, 0x17, 0x58, 0x22, 0xDF, 0xE6,
  0x04, 0xD0, 0xC0, 0x17, 0x30, 0x30, 0xEA, 0x0A, 0x70, 0x5D, 0x81, 0xE7, 0x16, 0x02, 0x08, 0xB0,
  0xE0, 0x27, 0x10, 0x40, 0xEE, 0x84, 0xCA, 0x99, 0xAD, 0xC0, 0xE0, 0x47, 0x30, 0x10, 0xBF, 0xF0,
  0xC0, 0x27, 0x68, 0x13, 0x9E, 0xF9, 0x81, 0xEA, 0x47, 0x74, 0x86, 0x25, 0x67, 0x76, 0x53, 0x71,
  // "D" (U+0044)
  0x02, 0xFF, 0xB8, 0x3E, 0xC9, 0x61, 0x74, 0x02, 0xFF, 0xF9, 0x0B, 0x03, 0x72, 0x82, 0x17, 0x8C,
  0xF9, 0x80, 0x0E, 0xFA, 0x0A, 0x01, 0x74, 0x03, 0x0E, 0xD0, 0x65, 0x82, 0x14, 0x9E, 0xD0, 0xE0,
  0x37, 0x40, 0x9D, 0x06, 0x72, 0x09, 0xD0, 0xE0, 0x37, 0x30, 0x5D, 0x06, 0x73, 0x05, 0xD0, 0xE0,
  0x27, 0x20, 0x4D, 0x06, 0x74, 0x05, 0xD0, 0xC7, 0x20, 0x4D, 0x06, 0x75, 0x09, 0xD0, 0x77, 0x10,
  0x4D, 0x06, 0x75, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x04, 0xD0, 0x67, 0x60, 0x8D, 0x07, 0x70, 0x4D,
  0x06, 0x76, 0x02, 0xD0, 0xE7, 0x04, 0xD0, 0x67, 0x70, 0xCD, 0x04, 0x60, 0x4D, 0x06, 0x77, 0x07,
  0xD0, 0x86, 0x04, 0xD0, 0x67, 0x70, 0x4D, 0x0C, 0x60, 0x4D, 0x06, 0x77, 0x01, 0xE6, 0x04, 0xD0,
  0x67, 0x71, 0x0E, 0xD0, 0x35, 0x04, 0xD0, 0x67, 0x71, 0x0C, 0xD0, 0x55, 0x04, 0xD0, 0x67, 0x71,
  0x0A, 0xD0, 0x75, 0x04, 0xD0, 0x67, 0x71, 0x09, 0xD0, 0x85, 0x04, 0xD0, 0x67, 0x71, 0x08, 0xD0,
  0x95, 0x04, 0xD0, 0x67, 0x71, 0x08, 0xD0, 0xA5, 0x04, 0xD0, 0x67, 0x71, 0x07, 0xD0, 0xA5, 0x04,
  0xD0, 0x67, 0x71, 0x08, 0xD0, 0xA5, 0x04, 0xD0, 0x67, 0x71, 0x08, 0xD0, 0x95, 0x04, 0xD0, 0x67,
  0x71, 0x09, 0xD0, 0x85, 0x04, 0xD0, 0x67, 0x71, 0x0A, 0xD0, 0x75, 0x04, 0xD0, 0x67, 0x71, 0x0C,
  0xD0, 0x55, 0x04, 0xD0, 0x67, 0x71, 0x0E, 0xD0, 0x35, 0x04, 0xD0, 0x67, 0x70, 0x1E, 0x60, 0x4D,
  0x06, 0x77, 0x04, 0xD0, 0xC6, 0x04, 0xD0, 0x67, 0x70, 0x8D, 0x09, 0x60, 0x4D, 0x06, 0x77, 0x0C,
  0xD0, 0x46, 0x04, 0xD0, 0x67, 0x60, 0x2D, 0x0E, 0x70, 0x4D, 0x06, 0x76, 0x09, 0xD0, 0x87, 0x04,
  0xD0, 0x67, 0x50, 0x1E, 0x01, 0x70, 0x4D, 0x06, 0x75, 0x0A, 0xD0, 0x87, 0x10, 0x4D, 0x06, 0x74,
  0x07, 0xD0, 0xD7, 0x20, 0x6D, 0x06, 0x73, 0x07, 0xD0, 0xE0, 0x37, 0x20, 0x9D, 0x06, 0x71, 0x02,
  0x0A, 0xE0, 0x47, 0x20, 0x4E, 0x07, 0x80, 0x11, 0x81, 0x36, 0xBE, 0x0E, 0x04, 0x68, 0x21, 0x89,
  0xCF, 0xFF, 0x0B, 0x02, 0x70, 0x2F, 0xFF, 0x90, 0xC0, 0x57, 0x20, 0x2F, 0xFA, 0x84, 0xED, 0xC9,
  0x62, 0x74,
  // "E" (U+0045)
  0x02, 0xFF, 0xFD, 0x02, 0x20, 0x2F, 0xFF, 0xD0, 0x22, 0x82, 0x17, 0x8B, 0xF9, 0x80, 0x4E, 0xF0,
  0x36, 0x03, 0x0E, 0xD0, 0x67, 0x20, 0x30, 0xCC, 0x03, 0x70, 0x9D, 0x06, 0x74, 0x0D, 0xB0, 0x47,
  0x05, 0xD0, 0x67, 0x40, 0x5B, 0x04, 0x70, 0x4D, 0x06, 0x75, 0xB0, 0x57, 0x04, 0xD0, 0x67, 0x50,
  0xCA, 0x05, 0x70, 0x4D, 0x06, 0x75, 0x0A, 0xA0, 0x57, 0x04, 0xD0, 0x67, 0x50, 0x8A, 0x06, 0x70,
  0x4D, 0x06, 0x75, 0x82, 0x36, 0x62, 0x70, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20,
  0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67,
  0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x78, 0x07, 0x17, 0x50, 0x4F, 0xFB, 0x0A, 0x74,
  0x04, 0xFF, 0xB0, 0xA7, 0x40, 0x4F, 0xFB, 0x0A, 0x74, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06,
  0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20,
  0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67,
  0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x78, 0x15, 0x77, 0x60, 0x4D, 0x06, 0x77,
  0x0D, 0xA0, 0x15, 0x04, 0xD0, 0x67, 0x7B, 0x60, 0x4D, 0x06, 0x76, 0x02, 0xB6, 0x04, 0xD0, 0x67,
  0x60, 0x6B, 0x60, 0x5D, 0x06, 0x76, 0x0D, 0xA0, 0xE6, 0x08, 0xD0, 0x67, 0x50, 0x7B, 0x0E, 0x50,
  0x20, 0xED, 0x06, 0x73, 0x02, 0x08, 0xC8, 0x4D, 0x01, 0x78, 0xBF, 0x98, 0x05, 0xEF, 0x81, 0xD0,
  0x2F, 0xFF, 0xE8, 0x1C, 0x02, 0xFF, 0xFE, 0x0C, 0x10,
  // "F" (U+0046)
  0x02, 0xFF, 0xFD, 0x00, 0x2F, 0xFF, 0xD8, 0x32, 0x17, 0x8B, 0xF9, 0x80, 0x4E, 0xF0, 0x34, 0x03,
  0x0E, 0xD0, 0x67, 0x20, 0x40, 0xCC, 0x03, 0x50, 0x8D, 0x06, 0x74, 0x0D, 0xB0, 0x45, 0x05, 0xD0,
  0x67, 0x40, 0x5B, 0x04, 0x50, 0x4D, 0x06, 0x75, 0xB0, 0x55, 0x04, 0xD0, 0x67, 0x50, 0xCA, 0x05,
  0x50, 0x4D, 0x06, 0x75, 0x0A, 0xA0, 0x55, 0x04, 0xD0, 0x67, 0x50, 0x8A, 0x06, 0x50, 0x4D, 0x06,
  0x75, 0x82, 0x24, 0x42, 0x50, 0x4D, 0x06, 0x77, 0x70, 0x4D, 0x06, 0x77, 0x70, 0x4D, 0x06, 0x77,
  0x70, 0x4D, 0x06, 0x77, 0x70, 0x4D, 0x06, 0x77, 0x70, 0x4D, 0x06, 0x77, 0x70, 0x4D, 0x06, 0x77,
  0x70, 0x4D, 0x06, 0x77, 0x70, 0x4D, 0x06, 0x77, 0x70, 0x4E, 0x80, 0x7E, 0x0A, 0x72, 0x04, 0xFF,
  0xB0, 0xB7, 0x20, 0x4F, 0xFB, 0x0B, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x04, 0xD0, 0x67, 0x77, 0x04,
  0xD0, 0x67, 0x77, 0x04, 0xD0, 0x67, 0x77, 0x04, 0xD0, 0x67, 0x77, 0x04, 0xD0, 0x67, 0x77, 0x04,
  0xD0, 0x67, 0x77, 0x04, 0xD0, 0x67, 0x77, 0x04, 0xD0, 0x67, 0x77, 0x04, 0xD0, 0x67, 0x77, 0x04,
  0xD0, 0x67, 0x77, 0x04, 0xD0, 0x67, 0x77, 0x04, 0xD0, 0x67, 0x77, 0x04, 0xD0, 0x77, 0x77, 0x06,
  0xD0, 0x97, 0x77, 0x0C, 0xD0, 0xE0, 0x17, 0x72, 0x82, 0x12, 0x5B, 0xF8, 0x3D, 0x73, 0x11, 0x74,
  0x02, 0xFF, 0xA0, 0x37, 0x30, 0x2F, 0xFA, 0x03, 0x73, 0x02, 0xFF, 0xA0, 0x37, 0x30,
  // "G" (U+0047)
  0x77, 0x18, 0x73, 0x56, 0x77, 0x65, 0x31, 0x77, 0x78, 0x11, 0x6B, 0xFB, 0x81, 0xD8, 0x27, 0x72,
  0x01, 0x08, 0xFF, 0xA0, 0x97, 0x70, 0x40, 0xEE, 0x84, 0xCA, 0x99, 0xBE, 0xE0, 0xD0, 0x17, 0x40,
  0x7D, 0x0C, 0x05, 0x70, 0x7E, 0x0B, 0x73, 0x08, 0xD0, 0x67, 0x30, 0x5E, 0x04, 0x71, 0x06, 0xD0,
  0x47, 0x50, 0x8D, 0x07, 0x70, 0x2D, 0x06, 0x76, 0x01, 0x0E, 0xC0, 0x87, 0x0C, 0xC0, 0xC7, 0x71,
  0x0A, 0xC0, 0x56, 0x05, 0xD0, 0x47, 0x71, 0x06, 0xB0, 0xC7, 0x0C, 0xC0, 0xD7, 0x72, 0x82, 0x4F,
  0xE9, 0x70, 0x4D, 0x08, 0x77, 0x30, 0x27, 0x20, 0x9D, 0x03, 0x77, 0x76, 0x0E, 0xC0, 0xE7, 0x77,
  0x60, 0x3D, 0x0C, 0x77, 0x76, 0x06, 0xD0, 0x97, 0x77, 0x60, 0x9D, 0x07, 0x77, 0x76, 0x0B, 0xD0,
  0x57, 0x77, 0x60, 0xDD, 0x04, 0x77, 0x76, 0xE0, 0x37, 0x77, 0x6E, 0x02, 0x77, 0x75, 0x01, 0xE0,
  0x27, 0x77, 0x50, 0x1E, 0x02, 0x77, 0x75, 0x01, 0xE0, 0x27, 0x68, 0x09, 0x11, 0x1E, 0x02, 0x75,
  0x0B, 0xFD, 0x0D, 0x1E, 0x03, 0x75, 0x0B, 0xFD, 0x81, 0xD0, 0xED, 0x04, 0x75, 0x0B, 0xFD, 0x81,
  0xD0, 0xCD, 0x05, 0x76, 0x81, 0x14, 0xBF, 0x08, 0x02, 0x20, 0xAD, 0x07, 0x77, 0x20, 0xDD, 0x0A,
  0x40, 0x7D, 0x09, 0x77, 0x20, 0x8D, 0x06, 0x40, 0x3D, 0x0C, 0x77, 0x20, 0x7D, 0x04, 0x5E, 0x77,
  0x20, 0x6D, 0x04, 0x50, 0xAD, 0x04, 0x77, 0x10, 0x6D, 0x04, 0x50, 0x5D, 0x09, 0x77, 0x10, 0x6D,
  0x04, 0x60, 0xEC, 0x0E, 0x77, 0x10, 0x6D, 0x04, 0x60, 0x7D, 0x05, 0x77, 0x06, 0xD0, 0x46, 0x01,
  0x0E, 0xC0, 0xD7, 0x70, 0x6D, 0x04, 0x70, 0x5D, 0x08, 0x76, 0x06, 0xD0, 0x47, 0x10, 0x9D, 0x06,
  0x75, 0x06, 0xD0, 0x47, 0x20, 0xBD, 0x08, 0x74, 0x06, 0xD0, 0x47, 0x30, 0xBD, 0x81, 0xD7, 0x17,
  0x10, 0x8D, 0x04, 0x74, 0x08, 0xF8, 0x5D, 0xB9, 0x99, 0xAC, 0xF0, 0x47, 0x50, 0x30, 0xBF, 0xFB,
  0x0B, 0x04, 0x77, 0x18, 0x13, 0x8D, 0xFB, 0x82, 0xEA, 0x61, 0x77, 0x68, 0x90, 0x13, 0x56, 0x77,
  0x65, 0x31, 0x73,
  // "H" (U+0048)
  0x02, 0xFF, 0x96, 0x01, 0xFF, 0x90, 0x2F, 0xF9, 0x60, 0x1F, 0xF9, 0x02, 0xFF, 0x96, 0x01, 0xFF,
  0x91, 0x82, 0x12, 0x5C, 0xF8, 0x2C, 0x52, 0x17, 0x82, 0x12, 0x6D, 0xF8, 0x2B, 0x42, 0x15, 0x0C,
  0xD0, 0xD7, 0x70, 0x1E, 0x0A, 0x72, 0x06, 0xD0, 0x97, 0x71, 0x0B, 0xD0, 0x47, 0x20, 0x4D, 0x07,
  0x77, 0x10, 0x9D, 0x02, 0x72, 0x04, 0xD0, 0x67, 0x71, 0x08, 0xD0, 0x27, 0x20, 0x4D, 0x06, 0x77,
  0x10, 0x8D, 0x02, 0x72, 0x04, 0xD0, 0x67, 0x71, 0x08, 0xD0, 0x27, 0x20, 0x4D, 0x06, 0x77, 0x10,
  0x8D, 0x02, 0x72, 0x04, 0xD0, 0x67, 0x71, 0x08, 0xD0, 0x27, 0x20, 0x4D, 0x06, 0x77, 0x10, 0x8D,
  0x02, 0x72, 0x04, 0xD0, 0x67, 0x71, 0x08, 0xD0, 0x27, 0x20, 0x4D, 0x06, 0x77, 0x10, 0x8D, 0x02,
  0x72, 0x04, 0xD0, 0x67, 0x71, 0x08, 0xD0, 0x27, 0x20, 0x4D, 0x06, 0x77, 0x10, 0x8D, 0x02, 0x72,
  0x04, 0xD0, 0x67, 0x71, 0x08, 0xD0, 0x27, 0x20, 0x4D, 0x07, 0x80, 0x93, 0x10, 0x9D, 0x02, 0x72,
  0x04, 0xFF, 0xFE, 0x02, 0x72, 0x04, 0xFF, 0xFE, 0x02, 0x72, 0x04, 0xFF, 0xFE, 0x02, 0x72, 0x04,
  0xD0, 0x67, 0x71, 0x08, 0xD0, 0x27, 0x20, 0x4D, 0x06, 0x77, 0x10, 0x8D, 0x02, 0x72, 0x04, 0xD0,
  0x67, 0x71, 0x08, 0xD0, 0x27, 0x20, 0x4D, 0x06, 0x77, 0x10, 0x8D, 0x02, 0x72, 0x04, 0xD0, 0x67,
  0x71, 0x08, 0xD0, 0x27, 0x20, 0x4D, 0x06, 0x77, 0x10, 0x8D, 0x02, 0x72, 0x04, 0xD0, 0x67, 0x71,
  0x08, 0xD0, 0x27, 0x20, 0x4D, 0x06, 0x77, 0x10, 0x8D, 0x02, 0x72, 0x04, 0xD0, 0x67, 0x71, 0x08,
  0xD0, 0x27, 0x20, 0x4D, 0x06, 0x77, 0x10, 0x8D, 0x02, 0x72, 0x04, 0xD0, 0x67, 0x71, 0x08, 0xD0,
  0x27, 0x20, 0x4D, 0x06, 0x77, 0x10, 0x8D, 0x02, 0x72, 0x04, 0xD0, 0x67, 0x71, 0x08, 0xD0, 0x27,
  0x20, 0x4D, 0x06, 0x77, 0x10, 0x8D, 0x02, 0x72, 0x05, 0xD0, 0x77, 0x71, 0x09, 0xD0, 0x27, 0x20,
  0x7D, 0x09, 0x77, 0x10, 0xBD, 0x04, 0x72, 0x0C, 0xD0, 0xE7, 0x70, 0x1E, 0x0A, 0x58, 0x21, 0x25,
  0xCF, 0x82, 0xC5, 0x21, 0x78, 0x21, 0x26, 0xDF, 0x83, 0xA4, 0x21, 0x2F, 0xF9, 0x60, 0x1F, 0xF9,
  0x02, 0xFF, 0x96, 0x01, 0xFF, 0x90, 0x2F, 0xF9, 0x60, 0x1F, 0xF9,
  // "I" (U+0049)
  0x02, 0xFF, 0x90, 0x40, 0x2F, 0xF9, 0x04, 0x02, 0xFF, 0x98, 0x44, 0x01, 0x25, 0xCF, 0x82, 0xD6,
  0x21, 0x60, 0xCD, 0x0E, 0x01, 0x72, 0x07, 0xD0, 0x97, 0x30, 0x5D, 0x07, 0x73, 0x04, 0xD0, 0x67,
  0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D,
  0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73,
  0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0,
  0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30,
  0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06,
  0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04,
  0xD0, 0x67, 0x30, 0x5D, 0x07, 0x73, 0x07, 0xD0, 0x97, 0x30, 0xCD, 0x0E, 0x68, 0x21, 0x25, 0xCF,
  0x84, 0xD5, 0x21, 0x02, 0xFF, 0x90, 0x40, 0x2F, 0xF9, 0x04, 0x02, 0xFF, 0x90, 0x40,
  // "J" (U+004A)
  0x30, 0xEF, 0xF0, 0x73, 0x0E, 0xFF, 0x07, 0x30, 0xEF, 0xF0, 0x73, 0x82, 0x12, 0x4B, 0xF8, 0x2E,
  0x73, 0x17, 0x10, 0xAE, 0x02, 0x74, 0x04, 0xD0, 0xC7, 0x50, 0x2D, 0x09, 0x75, 0x01, 0xD0, 0x97,
  0x50, 0x1D, 0x09, 0x75, 0x01, 0xD0, 0x97, 0x50, 0x1D, 0x09, 0x75, 0x01, 0xD0, 0x97, 0x50, 0x1D,
  0x09, 0x75, 0x01, 0xD0, 0x97, 0x50, 0x1D, 0x09, 0x75, 0x01, 0xD0, 0x97, 0x50, 0x1D, 0x09, 0x75,
  0x01, 0xD0, 0x97, 0x50, 0x1D, 0x09, 0x75, 0x01, 0xD0, 0x97, 0x50, 0x1D, 0x09, 0x75, 0x01, 0xD0,
  0x97, 0x50, 0x1D, 0x09, 0x75, 0x01, 0xD0, 0x97, 0x50, 0x1D, 0x09, 0x75, 0x01, 0xD0, 0x97, 0x50,
  0x1D, 0x09, 0x75, 0x01, 0xD0, 0x97, 0x50, 0x1D, 0x09, 0x75, 0x01, 0xD0, 0x97, 0x50, 0x1D, 0x09,
  0x75, 0x01, 0xD0, 0x97, 0x50, 0x1D, 0x09, 0x75, 0x01, 0xD0, 0x97, 0x50, 0x1D, 0x09, 0x75, 0x01,
  0xD0, 0x97, 0x50, 0x1D, 0x09, 0x75, 0x01, 0xD0, 0x97, 0x50, 0x1D, 0x09, 0x75, 0x01, 0xD0, 0x97,
  0x50, 0x1D, 0x09, 0x75, 0x01, 0xD0, 0x97, 0x50, 0x1D, 0x09, 0x75, 0x01, 0xD0, 0x97, 0x50, 0x2D,
  0x08, 0x75, 0x02, 0xD0, 0x77, 0x50, 0x4D, 0x06, 0x75, 0x06, 0xD0, 0x37, 0x50, 0x9D, 0x01, 0x75,
  0x0E, 0xC0, 0xC7, 0x50, 0x5D, 0x06, 0x75, 0x0D, 0xC0, 0xE7, 0x40, 0x10, 0xBD, 0x05, 0x71, 0x82,
  0x24, 0x8E, 0xD0, 0x97, 0x10, 0x7F, 0x90, 0x87, 0x20, 0x7E, 0x0C, 0x04, 0x73, 0x85, 0x7F, 0xED,
  0xB7, 0x37, 0x50,
  // "K" (U+004B)
  0x02, 0xFF, 0x96, 0x0E, 0xFB, 0x0B, 0x30, 0x2F, 0xF9, 0x60, 0xEF, 0xB0, 0xB3, 0x02, 0xFF, 0x96,
  0x0E, 0xFB, 0x0B, 0x48, 0x21, 0x25, 0xCF, 0x82, 0xD6, 0x21, 0x68, 0x11, 0x3B, 0xE8, 0x1B, 0x41,
  0x71, 0x0C, 0xD0, 0xE0, 0x17, 0x40, 0x4D, 0x06, 0x74, 0x06, 0xD0, 0x97, 0x50, 0x7C, 0x05, 0x75,
  0x04, 0xD0, 0x77, 0x50, 0xDB, 0x07, 0x76, 0x04, 0xD0, 0x67, 0x40, 0x8B, 0x09, 0x77, 0x04, 0xD0,
  0x67, 0x30, 0x3B, 0x0C, 0x77, 0x10, 0x4D, 0x06, 0x73, 0x0D, 0xA0, 0xE0, 0x27, 0x71, 0x04, 0xD0,
  0x67, 0x20, 0x9B, 0x05, 0x77, 0x20, 0x4D, 0x06, 0x71, 0x05, 0xB0, 0x87, 0x73, 0x04, 0xD0, 0x67,
  0x01, 0x0E, 0xA0, 0xC7, 0x74, 0x04, 0xD0, 0x67, 0x0B, 0xA0, 0xE0, 0x17, 0x74, 0x04, 0xD0, 0x66,
  0x07, 0xB0, 0x47, 0x75, 0x04, 0xD0, 0x65, 0x03, 0xB0, 0x87, 0x76, 0x04, 0xD0, 0x65, 0x0D, 0xA0,
  0xB7, 0x77, 0x04, 0xD0, 0x64, 0x09, 0xA0, 0xE0, 0x17, 0x77, 0x04, 0xD0, 0x63, 0x05, 0xB0, 0x87,
  0x77, 0x10, 0x4D, 0x06, 0x20, 0x10, 0xEB, 0x0E, 0x01, 0x77, 0x70, 0x4D, 0x06, 0x20, 0xBD, 0x0B,
  0x77, 0x70, 0x4D, 0x81, 0x60, 0x7F, 0x05, 0x77, 0x60, 0x4D, 0x06, 0x03, 0xA0, 0xDD, 0x0E, 0x01,
  0x77, 0x50, 0x4D, 0x84, 0x7D, 0xFC, 0x1C, 0xD0, 0xA7, 0x75, 0x04, 0xD8, 0x4E, 0xFE, 0x10, 0x3E,
  0x05, 0x77, 0x40, 0x4F, 0x03, 0x30, 0x9D, 0x0E, 0x01, 0x77, 0x30, 0x4E, 0x06, 0x40, 0x10, 0xED,
  0x09, 0x77, 0x30, 0x4D, 0x09, 0x60, 0x7E, 0x04, 0x77, 0x20, 0x4D, 0x06, 0x70, 0xCD, 0x0D, 0x77,
  0x20, 0x4D, 0x06, 0x70, 0x3E, 0x08, 0x77, 0x10, 0x4D, 0x06, 0x71, 0x0A, 0xE0, 0x37, 0x70, 0x4D,
  0x06, 0x71, 0x01, 0x0E, 0xD0, 0xD7, 0x70, 0x4D, 0x06, 0x72, 0x07, 0xE0, 0x87, 0x60, 0x4D, 0x06,
  0x73, 0x0D, 0xE0, 0x27, 0x50, 0x4D, 0x06, 0x73, 0x04, 0xE0, 0xC7, 0x50, 0x4D, 0x06, 0x74, 0x0A,
  0xE0, 0x77, 0x40, 0x4D, 0x07, 0x74, 0x01, 0x0E, 0xE0, 0x37, 0x30, 0x6D, 0x09, 0x75, 0x07, 0xE0,
  0xD0, 0x17, 0x20, 0xCD, 0x0E, 0x01, 0x75, 0x0D, 0xE0, 0xC0, 0x14, 0x82, 0x12, 0x5C, 0xF8, 0x2D,
  0x62, 0x17, 0x20, 0x3F, 0x83, 0xD6, 0x10, 0x2F, 0xF9, 0x73, 0x06, 0xFA, 0x01, 0x02, 0xFF, 0x97,
  0x40, 0x50, 0xEF, 0x01, 0x02, 0xFF, 0x97, 0x68, 0x26, 0xAD, 0xEB, 0x01,
  // "L" (U+004C)
  0x02, 0xFF, 0x90, 0x47, 0x60, 0x2F, 0xF9, 0x04, 0x76, 0x02, 0xFF, 0x90, 0x47, 0x78, 0x21, 0x25,
  0xCF, 0x82, 0xC5, 0x21, 0x77, 0x50, 0xDD, 0x0D, 0x77, 0x72, 0x07, 0xD0, 0x97, 0x77, 0x20, 0x5D,
  0x07, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77,
  0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0,
  0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72,
  0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06,
  0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20,
  0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67,
  0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x82, 0x5B,
  0xB1, 0x50, 0x4D, 0x06, 0x77, 0x09, 0xA0, 0x15, 0x04, 0xD0, 0x67, 0x70, 0xBA, 0x60, 0x4D, 0x06,
  0x77, 0x0D, 0xA6, 0x04, 0xD0, 0x67, 0x7B, 0x60, 0x4D, 0x06, 0x76, 0x02, 0xB6, 0x04, 0xD0, 0x67,
  0x60, 0x6A, 0x0E, 0x60, 0x5D, 0x06, 0x76, 0x0C, 0xA0, 0xE6, 0x09, 0xD0, 0x67, 0x50, 0x5B, 0x0D,
  0x50, 0x30, 0xED, 0x06, 0x73, 0x01, 0x07, 0xC8, 0x4D, 0x01, 0x78, 0xBF, 0x98, 0x05, 0xEF, 0x81,
  0xC0, 0x2F, 0xFF, 0xE8, 0x1C, 0x02, 0xFF, 0xFE, 0x0C, 0x10,
  // "M" (U+004D)
  0x02, 0xFD, 0x03, 0x77, 0x50, 0xDF, 0xC0, 0x40, 0x2F, 0xD0, 0x77, 0x74, 0x02, 0xFD, 0x04, 0x02,
  0xFD, 0x0C, 0x77, 0x40, 0x7F, 0xD8, 0x44, 0x01, 0x25, 0xCF, 0xA0, 0x17, 0x73, 0x0B, 0xF9, 0x82,
  0xD6, 0x21, 0x60, 0xCF, 0x90, 0x57, 0x72, 0x01, 0xF9, 0x0E, 0x01, 0x72, 0x06, 0xF9, 0x0A, 0x77,
  0x20, 0x5F, 0x90, 0xA7, 0x30, 0x4A, 0x0E, 0x0B, 0xC0, 0xE7, 0x72, 0x09, 0xA0, 0xB0, 0xEC, 0x08,
  0x73, 0x04, 0xA0, 0xE0, 0x6D, 0x03, 0x77, 0x10, 0xEA, 0x06, 0x0E, 0xC0, 0x87, 0x30, 0x4A, 0x0E,
  0x01, 0xD0, 0x87, 0x70, 0x3B, 0x01, 0x0E, 0xC0, 0x87, 0x30, 0x4A, 0x81, 0xE0, 0xCC, 0x0D, 0x77,
  0x07, 0xA8, 0x1C, 0x0E, 0xC0, 0x87, 0x30, 0x4A, 0x81, 0xE0, 0x7D, 0x02, 0x76, 0x0C, 0xA8, 0x18,
  0x0E, 0xC0, 0x87, 0x30, 0x4A, 0x81, 0xE0, 0x3D, 0x06, 0x75, 0x01, 0xB8, 0x13, 0x0E, 0xC0, 0x87,
  0x30, 0x4A, 0x0E, 0x20, 0xDC, 0x0B, 0x75, 0x06, 0xA0, 0xE2, 0x0E, 0xC0, 0x87, 0x30, 0x4A, 0x0E,
  0x20, 0x9D, 0x75, 0x0A, 0xA0, 0x92, 0x0E, 0xC0, 0x87, 0x30, 0x4A, 0x0E, 0x20, 0x4D, 0x04, 0x74,
  0x0E, 0xA0, 0x42, 0x0E, 0xC0, 0x87, 0x30, 0x4A, 0x0E, 0x30, 0xEC, 0x09, 0x73, 0x04, 0xB3, 0x0E,
  0xC0, 0x87, 0x30, 0x4A, 0x0E, 0x30, 0xAC, 0x0D, 0x73, 0x08, 0xA0, 0xA3, 0x0E, 0xC0, 0x87, 0x30,
  0x4A, 0x0E, 0x30, 0x5D, 0x03, 0x72, 0x0D, 0xA0, 0x63, 0x0E, 0xC0, 0x87, 0x30, 0x4A, 0x0E, 0x30,
  0x1D, 0x07, 0x71, 0x02, 0xB0, 0x13, 0x0E, 0xC0, 0x87, 0x30, 0x4A, 0x0E, 0x40, 0xBC, 0x0C, 0x71,
  0x06, 0xA0, 0xC4, 0x0E, 0xC0, 0x87, 0x30, 0x4A, 0x0E, 0x40, 0x6D, 0x01, 0x70, 0xBA, 0x07, 0x40,
  0xEC, 0x08, 0x73, 0x04, 0xA0, 0xE4, 0x01, 0xD0, 0x57, 0xB0, 0x34, 0x0E, 0xC0, 0x87, 0x30, 0x4A,
  0x0E, 0x50, 0xCC, 0x0A, 0x60, 0x4A, 0x0D, 0x50, 0xEC, 0x08, 0x73, 0x04, 0xA0, 0xE5, 0x07, 0xC0,
  0xE6, 0x09, 0xA0, 0x95, 0x0E, 0xC0, 0x87, 0x30, 0x4A, 0x0E, 0x50, 0x3D, 0x03, 0x50, 0xDA, 0x04,
  0x50, 0xEC, 0x08, 0x73, 0x04, 0xA0, 0xE6, 0x0D, 0xC0, 0x84, 0x03, 0xA0, 0xE6, 0x0E, 0xC0, 0x87,
  0x30, 0x4A, 0x0E, 0x60, 0x9C, 0x0D, 0x40, 0x7A, 0x0A, 0x60, 0xEC, 0x08, 0x73, 0x04, 0xA0, 0xE6,
  0x04, 0xD0, 0x23, 0x0C, 0xA0, 0x66, 0x0E, 0xC0, 0x87, 0x30, 0x4A, 0x0E, 0x70, 0xEC, 0x06, 0x20,
  0x1B, 0x01, 0x60, 0xEC, 0x08, 0x73, 0x04, 0xA0, 0xE7, 0x0A, 0xC0, 0xB2, 0x05, 0xA0, 0xC7, 0x0E,
  0xC0, 0x87, 0x30, 0x4A, 0x0E, 0x70, 0x5D, 0x20, 0xAA, 0x07, 0x70, 0xEC, 0x08, 0x73, 0x04, 0xA0,
  0xE7, 0x01, 0xD8, 0x14, 0x0E, 0xA0, 0x27, 0x0E, 0xC0, 0x87, 0x30, 0x4A, 0x0E, 0x71, 0x0B, 0xC0,
  0x90, 0x3A, 0x0D, 0x71, 0x0E, 0xC0, 0x87, 0x30, 0x4A, 0x0E, 0x71, 0x06, 0xC0, 0xD0, 0x8A, 0x09,
  0x71, 0x0E, 0xC0, 0x87, 0x30, 0x4A, 0x0E, 0x71, 0x01, 0xD0, 0xEA, 0x04, 0x71, 0x0E, 0xC0, 0x87,
  0x30, 0x4A, 0x0E, 0x72, 0x0C, 0xE0, 0xE7, 0x20, 0xEC, 0x08, 0x73, 0x04, 0xB7, 0x20, 0x7E, 0x0A,
  0x72, 0xD0, 0x87, 0x30, 0x6B, 0x01, 0x71, 0x03, 0xE0, 0x57, 0x10, 0x1D, 0x0A, 0x73, 0x0C, 0xB0,
  0x67, 0x20, 0xDD, 0x01, 0x71, 0x06, 0xD0, 0xE0, 0x15, 0x82, 0x12, 0x5C, 0xD8, 0x18, 0x31, 0x60,
  0x9C, 0x0B, 0x68, 0x21, 0x37, 0xEE, 0x84, 0xD6, 0x21, 0x02, 0xFD, 0x01, 0x50, 0x4C, 0x07, 0x50,
  0x3F, 0xF0, 0x40, 0x2F, 0xD0, 0x16, 0x0E, 0xB0, 0x25, 0x03, 0xFF, 0x04, 0x02, 0xFD, 0x01, 0x60,
  0xAA, 0x0D, 0x60, 0x3F, 0xF0, 0x40,
  // "N" (U+004E)
  0x02, 0xFB, 0x01, 0x75, 0x0E, 0xFD, 0x02, 0xFB, 0x09, 0x75, 0x0E, 0xFD, 0x02, 0xFC, 0x02, 0x74,
  0x0E, 0xFD, 0x18, 0x21, 0x25, 0xCF, 0x0A, 0x74, 0x82, 0x12, 0x4B, 0xD8, 0x2B, 0x42, 0x15, 0x0C,
  0xF0, 0x37, 0x70, 0xAB, 0x0B, 0x72, 0x06, 0xF0, 0xC7, 0x70, 0x4B, 0x05, 0x72, 0x04, 0xF9, 0x05,
  0x76, 0x02, 0xB0, 0x27, 0x20, 0x4F, 0x90, 0xD7, 0x60, 0x1B, 0x01, 0x72, 0x04, 0xB0, 0xED, 0x06,
  0x75, 0x01, 0xB0, 0x17, 0x20, 0x4A, 0x0E, 0x06, 0xD0, 0xD7, 0x50, 0x1B, 0x01, 0x72, 0x04, 0xA8,
  0x1E, 0x0D, 0xD0, 0x77, 0x40, 0x1B, 0x01, 0x72, 0x04, 0xA8, 0x1E, 0x04, 0xD0, 0xE0, 0x17, 0x30,
  0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE2, 0x0B, 0xD0, 0x87, 0x30, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE2,
  0x03, 0xE0, 0x17, 0x20, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE3, 0x09, 0xD0, 0x97, 0x20, 0x1B, 0x01,
  0x72, 0x04, 0xA0, 0xE3, 0x01, 0xE0, 0x27, 0x10, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE4, 0x08, 0xD0,
  0xB7, 0x10, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE5, 0x0E, 0xD0, 0x47, 0x01, 0xB0, 0x17, 0x20, 0x4A,
  0x0E, 0x50, 0x6D, 0x0C, 0x70, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE6, 0x0D, 0xD0, 0x56, 0x01, 0xB0,
  0x17, 0x20, 0x4A, 0x0E, 0x60, 0x4D, 0x0D, 0x60, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE7, 0x0B, 0xD0,
  0x65, 0x01, 0xB0, 0x17, 0x20, 0x4A, 0x0E, 0x70, 0x3D, 0x0E, 0x50, 0x1B, 0x01, 0x72, 0x04, 0xA0,
  0xE7, 0x10, 0xAD, 0x07, 0x40, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE7, 0x10, 0x1D, 0x0E, 0x01, 0x30,
  0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE7, 0x20, 0x8D, 0x09, 0x30, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE7,
  0x20, 0x10, 0xED, 0x02, 0x20, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE7, 0x30, 0x6D, 0x0A, 0x20, 0x1B,
  0x01, 0x72, 0x04, 0xA0, 0xE7, 0x40, 0xDD, 0x81, 0x30, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE7, 0x40,
  0x5D, 0x81, 0xB0, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE7, 0x50, 0xBD, 0x04, 0x01, 0xB0, 0x17, 0x20,
  0x4A, 0x0E, 0x75, 0x03, 0xD0, 0xC0, 0x2B, 0x01, 0x72, 0x04, 0xA0, 0xE7, 0x60, 0xAD, 0x07, 0xB0,
  0x17, 0x20, 0x4A, 0x0E, 0x76, 0x02, 0xD0, 0xEB, 0x01, 0x72, 0x04, 0xA0, 0xE7, 0x70, 0x8F, 0x90,
  0x17, 0x20, 0x4A, 0x0E, 0x77, 0x01, 0x0E, 0xF0, 0x17, 0x20, 0x5B, 0x77, 0x10, 0x6F, 0x01, 0x72,
  0x07, 0xB0, 0x17, 0x71, 0x0D, 0xE0, 0x17, 0x20, 0xCB, 0x07, 0x77, 0x10, 0x5E, 0x01, 0x58, 0x21,
  0x25, 0xCD, 0x82, 0x93, 0x11, 0x75, 0x0C, 0xD0, 0x14, 0x02, 0xFD, 0x0C, 0x75, 0x03, 0xD0, 0x14,
  0x02, 0xFD, 0x0C, 0x76, 0x0A, 0xC0, 0x14, 0x02, 0xFD, 0x0C, 0x76, 0x02, 0xC0, 0x14,
  // "O" (U+004F)
  0x76, 0x86, 0x14, 0x56, 0x76, 0x52, 0x77, 0x72, 0x81, 0x28, 0xDF, 0x98, 0x1E, 0xA3, 0x77, 0x40,
  0x10, 0x9F, 0xF0, 0xB0, 0x27, 0x71, 0x04, 0x0E, 0xD8, 0x4E, 0xB9, 0x9A, 0xCE, 0x06, 0x76, 0x05,
  0xD0, 0xD0, 0x56, 0x01, 0x08, 0xD0, 0x87, 0x40, 0x4D, 0x0A, 0x73, 0x03, 0x0E, 0xC0, 0x77, 0x20,
  0x20, 0xEC, 0x0B, 0x75, 0x03, 0xD0, 0x47, 0x10, 0xBC, 0x0E, 0x01, 0x76, 0x07, 0xC0, 0xD7, 0x04,
  0xD0, 0x77, 0x71, 0x0E, 0xC0, 0x76, 0x0B, 0xD0, 0x17, 0x71, 0x08, 0xC0, 0xE5, 0x03, 0xD0, 0xA7,
  0x72, 0x03, 0xD0, 0x64, 0x08, 0xD0, 0x57, 0x73, 0x0D, 0xC0, 0xC4, 0x0D, 0xD0, 0x17, 0x73, 0x0A,
  0xD0, 0x22, 0x02, 0xD0, 0xD7, 0x74, 0x06, 0xD0, 0x62, 0x05, 0xD0, 0xA7, 0x74, 0x03, 0xD0, 0xA2,
  0x08, 0xD0, 0x87, 0x74, 0x01, 0xD0, 0xD2, 0x0B, 0xD0, 0x67, 0x75, 0xE8, 0x11, 0x0C, 0xD0, 0x47,
  0x75, 0x0D, 0xD8, 0x12, 0x0E, 0xD0, 0x37, 0x75, 0x0C, 0xD0, 0x41, 0xE0, 0x27, 0x75, 0x0B, 0xD0,
  0x60, 0x1E, 0x01, 0x77, 0x50, 0xBD, 0x06, 0x01, 0xE0, 0x17, 0x75, 0x0A, 0xD0, 0x70, 0x1E, 0x01,
  0x77, 0x50, 0xAD, 0x07, 0x01, 0xE0, 0x17, 0x75, 0x0A, 0xD0, 0x71, 0xE0, 0x27, 0x75, 0x0B, 0xD0,
  0x61, 0xE0, 0x27, 0x75, 0x0B, 0xD8, 0x16, 0x0E, 0xD0, 0x37, 0x75, 0x0C, 0xD8, 0x14, 0x0C, 0xD0,
  0x47, 0x75, 0x0D, 0xD8, 0x12, 0x0A, 0xD0, 0x67, 0x75, 0xE2, 0x08, 0xD0, 0x87, 0x74, 0x01, 0xD0,
  0xD2, 0x05, 0xD0, 0xA7, 0x74, 0x03, 0xD0, 0xA2, 0x01, 0xD0, 0xD7, 0x74, 0x07, 0xD0, 0x63, 0x0C,
  0xD0, 0x17, 0x73, 0x0A, 0xD0, 0x13, 0x08, 0xD0, 0x57, 0x73, 0x0E, 0xC0, 0xC4, 0x02, 0xD0, 0xA7,
  0x72, 0x03, 0xD0, 0x65, 0x0B, 0xD0, 0x17, 0x71, 0x09, 0xC0, 0xE6, 0x04, 0xD0, 0x77, 0x71, 0x0E,
  0xC0, 0x77, 0x0A, 0xC0, 0xE0, 0x17, 0x60, 0x8C, 0x0D, 0x71, 0x01, 0x0E, 0xC0, 0xB7, 0x50, 0x3D,
  0x03, 0x72, 0x04, 0xD0, 0xA7, 0x30, 0x30, 0xEC, 0x06, 0x74, 0x05, 0xD0, 0xD0, 0x56, 0x02, 0x09,
  0xD0, 0x77, 0x60, 0x40, 0xED, 0x84, 0xEB, 0x99, 0xAD, 0xE0, 0x57, 0x71, 0x01, 0x0A, 0xFF, 0x0B,
  0x02, 0x77, 0x48, 0x12, 0x8D, 0xF9, 0x81, 0xE9, 0x37, 0x77, 0x28, 0x61, 0x46, 0x77, 0x65, 0x27,
  0x60,
  // "P" (U+0050)
  0x02, 0xFF, 0x98, 0x4E, 0xDC, 0x95, 0x17, 0x02, 0xFF, 0xF0, 0xA0, 0x35, 0x82, 0x17, 0x8C, 0xF8,
  0x3E, 0xDD, 0xDE, 0xF9, 0x06, 0x71, 0x03, 0x0E, 0xD0, 0x65, 0x81, 0x38, 0xED, 0x08, 0x71, 0x08,
  0xD0, 0x67, 0x01, 0x0D, 0xD0, 0x57, 0x05, 0xD0, 0x67, 0x10, 0x10, 0xEC, 0x0E, 0x70, 0x4D, 0x06,
  0x72, 0x07, 0xD0, 0x66, 0x04, 0xD0, 0x67, 0x20, 0x2D, 0x0D, 0x60, 0x4D, 0x06, 0x73, 0x0D, 0xD0,
  0x15, 0x04, 0xD0, 0x67, 0x30, 0xAD, 0x05, 0x50, 0x4D, 0x06, 0x73, 0x08, 0xD0, 0x65, 0x04, 0xD0,
  0x67, 0x30, 0x7D, 0x07, 0x50, 0x4D, 0x06, 0x73, 0x06, 0xD0, 0x85, 0x04, 0xD0, 0x67, 0x30, 0x7D,
  0x08, 0x50, 0x4D, 0x06, 0x73, 0x08, 0xD0, 0x75, 0x04, 0xD0, 0x67, 0x30, 0x9D, 0x04, 0x50, 0x4D,
  0x06, 0x73, 0x0B, 0xD0, 0x15, 0x04, 0xD0, 0x67, 0x30, 0xEC, 0x0C, 0x60, 0x4D, 0x06, 0x72, 0x04,
  0xD0, 0x76, 0x04, 0xD0, 0x67, 0x20, 0xBC, 0x0E, 0x01, 0x60, 0x4D, 0x06, 0x71, 0x06, 0xD0, 0x87,
  0x04, 0xD0, 0x67, 0x07, 0xD0, 0xC7, 0x10, 0x4D, 0x06, 0x38, 0x21, 0x37, 0xDD, 0x0C, 0x01, 0x71,
  0x04, 0xFF, 0xB0, 0xA0, 0x17, 0x20, 0x4F, 0xF9, 0x0C, 0x05, 0x74, 0x04, 0xFC, 0x82, 0xDB, 0x73,
  0x76, 0x04, 0xD0, 0x70, 0xF1, 0x77, 0x50, 0x4D, 0x06, 0x77, 0x71, 0x04, 0xD0, 0x67, 0x77, 0x10,
  0x4D, 0x06, 0x77, 0x71, 0x04, 0xD0, 0x67, 0x77, 0x10, 0x4D, 0x06, 0x77, 0x71, 0x04, 0xD0, 0x67,
  0x77, 0x10, 0x4D, 0x06, 0x77, 0x71, 0x04, 0xD0, 0x67, 0x77, 0x10, 0x4D, 0x06, 0x77, 0x71, 0x05,
  0xD0, 0x77, 0x77, 0x10, 0x7D, 0x09, 0x77, 0x71, 0x0C, 0xD0, 0xD7, 0x74, 0x82, 0x12, 0x5C, 0xF8,
  0x3D, 0x62, 0x11, 0x75, 0x02, 0xFF, 0xA0, 0x17, 0x40, 0x2F, 0xFA, 0x01, 0x74, 0x02, 0xFF, 0xA0,
  0x17, 0x40,
  // "Q" (U+0051)
  0x76, 0x86, 0x14, 0x56, 0x76, 0x52, 0x77, 0x72, 0x81, 0x28, 0xDF, 0x98, 0x1E, 0xA3, 0x77, 0x40,
  0x10, 0x9F, 0xF0, 0xB0, 0x27, 0x71, 0x04, 0x0E, 0xD8, 0x4E, 0xB9, 0x9A, 0xCE, 0x06, 0x76, 0x05,
  0xD0, 0xD0, 0x56, 0x01, 0x08, 0xD0, 0x87, 0x40, 0x4D, 0x09, 0x73, 0x03, 0x0E, 0xC0, 0x67, 0x20,
  0x20, 0xEC, 0x0A, 0x75, 0x03, 0xD0, 0x47, 0x10, 0xAC, 0x0E, 0x01, 0x76, 0x07, 0xC0, 0xD7, 0x04,
  0xD0, 0x67, 0x71, 0x0E, 0xC0, 0x76, 0x0B, 0xD0, 0x17, 0x71, 0x08, 0xC0, 0xE5, 0x02, 0xD0, 0xA7,
  0x72, 0x03, 0xD0, 0x64, 0x08, 0xD0, 0x57, 0x73, 0x0D, 0xC0, 0xC4, 0x0D, 0xD0, 0x17, 0x73, 0x0A,
  0xD0, 0x12, 0x01, 0xD0, 0xD7, 0x74, 0x06, 0xD0, 0x62, 0x05, 0xD0, 0xA7, 0x74, 0x03, 0xD0, 0xA2,
  0x08, 0xD0, 0x87, 0x74, 0x01, 0xD0, 0xD2, 0x0A, 0xD0, 0x67, 0x75, 0xE2, 0x0C, 0xD0, 0x47, 0x75,
  0x0D, 0xD8, 0x12, 0x0E, 0xD0, 0x37, 0x75, 0x0C, 0xD0, 0x41, 0xE0, 0x27, 0x75, 0x0B, 0xD0, 0x61,
  0xE0, 0x17, 0x75, 0x0B, 0xD0, 0x60, 0x1E, 0x01, 0x77, 0x50, 0xAD, 0x07, 0x01, 0xE0, 0x17, 0x75,
  0x0A, 0xD0, 0x70, 0x1E, 0x01, 0x77, 0x50, 0xAD, 0x07, 0x01, 0xE0, 0x27, 0x75, 0x0B, 0xD0, 0x61,
  0xE0, 0x27, 0x75, 0x0B, 0xD8, 0x15, 0x0E, 0xD0, 0x37, 0x75, 0x0C, 0xD8, 0x15, 0x0D, 0xD0, 0x47,
  0x75, 0x0D, 0xD8, 0x13, 0x0B, 0xD0, 0x67, 0x75, 0xE2, 0x08, 0xD0, 0x87, 0x74, 0x01, 0xD0, 0xD2,
  0x05, 0xD0, 0xA7, 0x74, 0x04, 0xD0, 0xB2, 0x02, 0xD0, 0xD7, 0x74, 0x07, 0xD0, 0x73, 0x0D, 0xD0,
  0x17, 0x73, 0x0A, 0xD0, 0x23, 0x09, 0xD0, 0x57, 0x73, 0x0E, 0xC0, 0xD4, 0x04, 0xD0, 0xA7, 0x72,
  0x03, 0xD0, 0x75, 0x0D, 0xD0, 0x17, 0x71, 0x09, 0xD0, 0x15, 0x06, 0xD0, 0x67, 0x70, 0x10, 0xEC,
  0x09, 0x70, 0xDC, 0x0E, 0x01, 0x76, 0x08, 0xD0, 0x27, 0x04, 0xD0, 0xA7, 0x50, 0x3D, 0x07, 0x72,
  0x08, 0xD0, 0x97, 0x30, 0x40, 0xEC, 0x0B, 0x74, 0x0A, 0xD0, 0xC0, 0x56, 0x02, 0x09, 0xD0, 0xC7,
  0x60, 0x9E, 0x84, 0xEB, 0x99, 0xAD, 0xE0, 0xB0, 0x17, 0x70, 0x50, 0xEF, 0xF9, 0x07, 0x77, 0x40,
  0x70, 0xDF, 0xB8, 0x1E, 0x81, 0x77, 0x78, 0x13, 0x6A, 0xD0, 0xE0, 0x37, 0x77, 0x50, 0x2D, 0x0E,
  0x77, 0x76, 0x01, 0xE0, 0x17, 0x77, 0x60, 0xED, 0x03, 0x77, 0x76, 0x0B, 0xD0, 0x77, 0x77, 0x60,
  0x7D, 0x0B, 0x77, 0x76, 0x02, 0xE0, 0x17, 0x77, 0x60, 0xBD, 0x08, 0x77, 0x76, 0x03, 0xE0, 0x37,
  0x77, 0x60, 0x8D, 0x0E, 0x03, 0x77, 0x76, 0x0A, 0xE8, 0x2B, 0x53, 0x17, 0x77, 0x30, 0x9F, 0xA0,
  0x47, 0x77, 0x30, 0x50, 0xDF, 0x04, 0x77, 0x75, 0x82, 0x38, 0xCE, 0xB0, 0x44,
  // "R" (U+0052)
  0x02, 0xFF, 0x98, 0x4E, 0xDC, 0x96, 0x27, 0x50, 0x2F, 0xFF, 0x0C, 0x06, 0x73, 0x82, 0x17, 0x9C,
  0xF0, 0xE8, 0x00, 0xDF, 0x90, 0xB0, 0x27, 0x50, 0x30, 0xED, 0x06, 0x58, 0x12, 0x7E, 0xD0, 0xD0,
  0x17, 0x50, 0x8D, 0x06, 0x71, 0x0B, 0xD0, 0xC7, 0x50, 0x5D, 0x06, 0x72, 0x0D, 0xD0, 0x57, 0x40,
  0x4D, 0x06, 0x72, 0x05, 0xD0, 0xC7, 0x40, 0x4D, 0x06, 0x73, 0x0E, 0xD0, 0x17, 0x30, 0x4D, 0x06,
  0x73, 0x0B, 0xD0, 0x57, 0x30, 0x4D, 0x06, 0x73, 0x08, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x07,
  0xD0, 0x77, 0x30, 0x4D, 0x06, 0x73, 0x06, 0xD0, 0x87, 0x30, 0x4D, 0x06, 0x73, 0x07, 0xD0, 0x87,
  0x30, 0x4D, 0x06, 0x73, 0x08, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x0A, 0xD0, 0x47, 0x30, 0x4D,
  0x06, 0x73, 0x0D, 0xD7, 0x40, 0x4D, 0x06, 0x72, 0x03, 0xD0, 0xA7, 0x40, 0x4D, 0x06, 0x72, 0x0A,
  0xD0, 0x27, 0x40, 0x4D, 0x06, 0x71, 0x04, 0xD0, 0x87, 0x50, 0x4D, 0x06, 0x70, 0x5D, 0x0A, 0x76,
  0x04, 0xD0, 0x63, 0x82, 0x12, 0x6C, 0xD0, 0x97, 0x70, 0x4F, 0xFA, 0x0D, 0x05, 0x77, 0x10, 0x4F,
  0xF9, 0x06, 0x77, 0x30, 0x4F, 0xF9, 0x07, 0x77, 0x30, 0x4D, 0x83, 0x71, 0x11, 0x2D, 0x0E, 0x01,
  0x77, 0x20, 0x4D, 0x06, 0x40, 0x9D, 0x09, 0x77, 0x20, 0x4D, 0x06, 0x40, 0x1E, 0x02, 0x77, 0x10,
  0x4D, 0x06, 0x50, 0x9D, 0x0A, 0x77, 0x10, 0x4D, 0x06, 0x50, 0x1E, 0x03, 0x77, 0x04, 0xD0, 0x66,
  0x09, 0xD0, 0xC7, 0x70, 0x4D, 0x06, 0x60, 0x1E, 0x05, 0x76, 0x04, 0xD0, 0x67, 0x09, 0xD0, 0xD7,
  0x60, 0x4D, 0x06, 0x70, 0x1E, 0x06, 0x75, 0x04, 0xD0, 0x67, 0x10, 0x9D, 0x0E, 0x75, 0x04, 0xD0,
  0x67, 0x10, 0x1E, 0x07, 0x74, 0x04, 0xD0, 0x67, 0x20, 0x9D, 0x0E, 0x01, 0x73, 0x04, 0xD0, 0x67,
  0x20, 0x1E, 0x0A, 0x73, 0x06, 0xD0, 0x87, 0x30, 0x9E, 0x05, 0x72, 0x0C, 0xD0, 0xD7, 0x30, 0x10,
  0xED, 0x0E, 0x03, 0x48, 0x21, 0x25, 0xCF, 0x82, 0xC5, 0x21, 0x70, 0x6F, 0x82, 0x72, 0x02, 0xFF,
  0x97, 0x10, 0xAF, 0x90, 0x50, 0x2F, 0xF9, 0x72, 0x07, 0xF0, 0x50, 0x2F, 0xF9, 0x73, 0x83, 0x17,
  0xBD, 0xEA, 0x05,
  // "S" (U+0053)
  0x72, 0x85, 0x25, 0x67, 0x65, 0x37, 0x78, 0x11, 0x7D, 0xF8, 0x1E, 0xA3, 0x73, 0x05, 0x0E, 0xFD,
  0x0A, 0x71, 0x08, 0xD8, 0x3C, 0x99, 0xBE, 0xD0, 0xC6, 0x07, 0xC0, 0xB0, 0x24, 0x01, 0x09, 0xD0,
  0x94, 0x03, 0xC0, 0xB7, 0x10, 0x9D, 0x01, 0x30, 0xBC, 0x01, 0x72, 0x0E, 0xC0, 0x62, 0x02, 0xC0,
  0xA7, 0x30, 0x7C, 0x07, 0x20, 0x6C, 0x06, 0x73, 0x02, 0xC0, 0x52, 0x09, 0xC0, 0x47, 0x4B, 0x0D,
  0x30, 0xAC, 0x03, 0x74, 0x82, 0xDE, 0x91, 0x30, 0xAC, 0x04, 0x77, 0x40, 0x9C, 0x06, 0x77, 0x40,
  0x8C, 0x0A, 0x77, 0x40, 0x5C, 0x0E, 0x01, 0x77, 0x30, 0x1D, 0x0A, 0x77, 0x40, 0xBD, 0x08, 0x77,
  0x30, 0x4E, 0x0A, 0x01, 0x77, 0x20, 0xAE, 0x0E, 0x05, 0x77, 0x10, 0x10, 0xCF, 0x0C, 0x04, 0x77,
  0x01, 0x0D, 0xF9, 0x0B, 0x03, 0x76, 0x01, 0x0B, 0xFA, 0x09, 0x01, 0x76, 0x07, 0xFA, 0x0E, 0x04,
  0x76, 0x02, 0x0A, 0xFA, 0x07, 0x77, 0x03, 0x0B, 0xF9, 0x09, 0x77, 0x10, 0x40, 0xDF, 0x07, 0x77,
  0x20, 0x8F, 0x03, 0x77, 0x20, 0x5E, 0x0A, 0x77, 0x30, 0x3E, 0x01, 0x77, 0x30, 0x7D, 0x05, 0x77,
  0x40, 0xEC, 0x08, 0x77, 0x40, 0x8C, 0x0A, 0x28, 0x19, 0xD7, 0x76, 0x06, 0xC8, 0x1B, 0x0C, 0xA0,
  0x87, 0x60, 0x4C, 0x0A, 0x04, 0xB0, 0xB7, 0x60, 0x4C, 0x09, 0x08, 0xB0, 0xE7, 0x60, 0x5C, 0x07,
  0x08, 0xC0, 0x47, 0x50, 0x8C, 0x03, 0x07, 0xC0, 0xB7, 0x50, 0xDB, 0x81, 0xE0, 0x3D, 0x04, 0x73,
  0x05, 0xC0, 0x72, 0x0D, 0xC0, 0xE0, 0x27, 0x10, 0x30, 0xEB, 0x0D, 0x30, 0x5D, 0x0E, 0x06, 0x60,
  0x70, 0xEB, 0x0E, 0x02, 0x40, 0x8E, 0x83, 0xEB, 0x99, 0xBD, 0x0E, 0x03, 0x60, 0x7F, 0xF0, 0xB0,
  0x17, 0x18, 0x12, 0x8D, 0xF9, 0x81, 0xEA, 0x37, 0x68, 0x61, 0x46, 0x77, 0x65, 0x27, 0x20,
  // "T" (U+0054)
  0x0C, 0xFF, 0xFF, 0x08, 0x0D, 0xFF, 0xFF, 0x09, 0x0D, 0xFF, 0xFF, 0x09, 0x0D, 0xB8, 0x1E, 0x62,
  0x80, 0x11, 0xD0, 0xA8, 0x01, 0x10, 0x30, 0x8C, 0x09, 0x0E, 0xB0, 0x27, 0xD0, 0xA7, 0x06, 0xB0,
  0xA0, 0xEA, 0x0A, 0x71, 0xD0, 0xA7, 0x10, 0xDA, 0x0A, 0x0E, 0xA0, 0x47, 0x1D, 0x0A, 0x71, 0x08,
  0xA0, 0xAB, 0x01, 0x71, 0xD0, 0xA7, 0x10, 0x5A, 0x0B, 0xA0, 0xE7, 0x2D, 0x0A, 0x71, 0x02, 0xA0,
  0xBA, 0x0C, 0x72, 0xD0, 0xA7, 0x2A, 0x82, 0xB7, 0x75, 0x72, 0xD0, 0xA7, 0x28, 0x16, 0x75, 0x75,
  0xD0, 0xA7, 0x77, 0x3D, 0x0A, 0x77, 0x73, 0xD0, 0xA7, 0x77, 0x3D, 0x0A, 0x77, 0x73, 0xD0, 0xA7,
  0x77, 0x3D, 0x0A, 0x77, 0x73, 0xD0, 0xA7, 0x77, 0x3D, 0x0A, 0x77, 0x73, 0xD0, 0xA7, 0x77, 0x3D,
  0x0A, 0x77, 0x73, 0xD0, 0xA7, 0x77, 0x3D, 0x0A, 0x77, 0x73, 0xD0, 0xA7, 0x77, 0x3D, 0x0A, 0x77,
  0x73, 0xD0, 0xA7, 0x77, 0x3D, 0x0A, 0x77, 0x73, 0xD0, 0xA7, 0x77, 0x3D, 0x0A, 0x77, 0x73, 0xD0,
  0xA7, 0x77, 0x3D, 0x0A, 0x77, 0x73, 0xD0, 0xA7, 0x77, 0x3D, 0x0A, 0x77, 0x73, 0xD0, 0xA7, 0x77,
  0x3D, 0x0A, 0x77, 0x73, 0xD0, 0xA7, 0x77, 0x3D, 0x0B, 0x77, 0x72, 0x02, 0xD0, 0xD7, 0x77, 0x20,
  0x9E, 0x04, 0x77, 0x48, 0x21, 0x25, 0xAF, 0x83, 0xE9, 0x32, 0x17, 0x60, 0x6F, 0xFA, 0x01, 0x75,
  0x06, 0xFF, 0xA0, 0x17, 0x50, 0x6F, 0xFA, 0x01, 0x60,
  // "U" (U+0055)
  0x03, 0xFF, 0x90, 0x26, 0x0B, 0xFD, 0x02, 0x03, 0xFF, 0x90, 0x26, 0x0B, 0xFD, 0x02, 0x03, 0xFF,
  0x90, 0x26, 0x0B, 0xFD, 0x84, 0x20, 0x13, 0x6D, 0xF8, 0x2D, 0x63, 0x17, 0x18, 0x12, 0x49, 0xD8,
  0x2D, 0x63, 0x16, 0x0D, 0xD0, 0xD7, 0x71, 0x07, 0xB0, 0xD7, 0x30, 0x8D, 0x08, 0x77, 0x10, 0x1B,
  0x08, 0x73, 0x06, 0xD0, 0x67, 0x72, 0xB0, 0x57, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73,
  0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05,
  0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0,
  0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57,
  0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72,
  0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E,
  0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0,
  0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47,
  0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30,
  0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D,
  0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05,
  0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x4D, 0x05, 0x77,
  0x20, 0xEA, 0x04, 0x73, 0x03, 0xD0, 0x67, 0x72, 0xB0, 0x27, 0x30, 0x2D, 0x08, 0x77, 0x10, 0x3B,
  0x01, 0x74, 0x0E, 0xC0, 0xB7, 0x71, 0x06, 0xA0, 0xD7, 0x50, 0xBC, 0x0E, 0x01, 0x77, 0x0C, 0xA0,
  0x97, 0x50, 0x6D, 0x07, 0x76, 0x03, 0xB0, 0x47, 0x60, 0xEC, 0x0E, 0x02, 0x75, 0x0D, 0xA0, 0xC7,
  0x70, 0x7D, 0x0D, 0x02, 0x73, 0x0B, 0xB0, 0x47, 0x71, 0x0B, 0xD8, 0x1E, 0x81, 0x60, 0x50, 0xDB,
  0x08, 0x77, 0x30, 0xAF, 0x84, 0xCA, 0x9A, 0xBE, 0xC0, 0x97, 0x75, 0x06, 0x0E, 0xFE, 0x0E, 0x06,
  0x77, 0x71, 0x06, 0x0C, 0xFA, 0x0C, 0x07, 0x77, 0x76, 0x86, 0x35, 0x67, 0x65, 0x41, 0x77,
  // "V" (U+0056)
  0xFF, 0x07, 0x70, 0xAF, 0xC0, 0xBF, 0xF0, 0x77, 0x0A, 0xFC, 0x0B, 0xFF, 0x07, 0x70, 0xAF, 0xC8,
  0x3B, 0x12, 0x7E, 0xE8, 0x2E, 0x62, 0x17, 0x28, 0x11, 0x27, 0xD8, 0x1E, 0x52, 0x40, 0x6E, 0x07,
  0x77, 0x10, 0x7C, 0x03, 0x70, 0xED, 0x04, 0x77, 0x10, 0x3B, 0x0A, 0x71, 0x09, 0xD0, 0x57, 0x71,
  0x04, 0xB0, 0x47, 0x10, 0x4D, 0x09, 0x77, 0x10, 0x7A, 0x0E, 0x73, 0xD0, 0xD7, 0x71, 0x0B, 0xA0,
  0x97, 0x30, 0xBD, 0x02, 0x77, 0xB0, 0x57, 0x30, 0x6D, 0x06, 0x76, 0x04, 0xB0, 0x17, 0x30, 0x2D,
  0x0A, 0x76, 0x09, 0xA0, 0xB7, 0x50, 0xDC, 0x0E, 0x76, 0x0D, 0xA0, 0x77, 0x50, 0x8D, 0x03, 0x74,
  0x02, 0xB0, 0x27, 0x50, 0x3D, 0x07, 0x74, 0x07, 0xA0, 0xD7, 0x70, 0xEC, 0x0C, 0x74, 0x0B, 0xA0,
  0x97, 0x70, 0xAD, 0x01, 0x73, 0xB0, 0x47, 0x70, 0x5D, 0x05, 0x72, 0x05, 0xA0, 0xE7, 0x71, 0x01,
  0xD0, 0x97, 0x20, 0x9A, 0x0A, 0x77, 0x20, 0xCC, 0x0D, 0x72, 0x0D, 0xA0, 0x67, 0x72, 0x07, 0xD0,
  0x27, 0x02, 0xB0, 0x17, 0x72, 0x03, 0xD0, 0x67, 0x07, 0xA0, 0xC7, 0x74, 0x0D, 0xC0, 0xB7, 0x0B,
  0xA0, 0x87, 0x74, 0x09, 0xC0, 0xE7, 0xB0, 0x37, 0x74, 0x04, 0xD0, 0x45, 0x05, 0xA0, 0xE7, 0x76,
  0xD0, 0x85, 0x09, 0xA0, 0x97, 0x76, 0x0B, 0xC0, 0xC5, 0x0E, 0xA0, 0x57, 0x76, 0x06, 0xD0, 0x13,
  0x03, 0xB0, 0x17, 0x76, 0x02, 0xD0, 0x53, 0x07, 0xA0, 0xB7, 0x77, 0x10, 0xDC, 0x09, 0x30, 0xBA,
  0x07, 0x77, 0x71, 0x08, 0xC0, 0xE2, 0x01, 0xB0, 0x27, 0x77, 0x10, 0x4D, 0x81, 0x20, 0x5A, 0x0D,
  0x77, 0x73, 0x0E, 0xC8, 0x16, 0x09, 0xA0, 0x97, 0x77, 0x30, 0xAC, 0x81, 0x90, 0xCA, 0x04, 0x77,
  0x73, 0x05, 0xC0, 0xD1, 0xA0, 0xE7, 0x77, 0x40, 0x1D, 0x05, 0xA0, 0xA7, 0x77, 0x50, 0xCC, 0x0C,
  0xA0, 0x67, 0x77, 0x50, 0x7F, 0x01, 0x77, 0x75, 0x03, 0xE0, 0xC7, 0x77, 0x70, 0xDD, 0x08, 0x77,
  0x77, 0x09, 0xD0, 0x37, 0x77, 0x70, 0x4C, 0x0E, 0x77, 0x77, 0x2C, 0x0A, 0x77, 0x10,
  // "W" (U+0057)
  0x09, 0xFF, 0x73, 0x02, 0xC0, 0x67, 0x20, 0x3F, 0xD0, 0x70, 0x9F, 0xF7, 0x30, 0x5C, 0x09, 0x72,
  0x03, 0xFD, 0x07, 0x09, 0xFF, 0x73, 0x09, 0xC0, 0xD7, 0x20, 0x3F, 0xD8, 0x37, 0x01, 0x4C, 0xF8,
  0x2B, 0x31, 0x17, 0x30, 0xDD, 0x01, 0x72, 0x82, 0x12, 0x4A, 0xD8, 0x1A, 0x31, 0x50, 0xDD, 0x0E,
  0x76, 0x01, 0xE0, 0x47, 0x60, 0xDB, 0x0B, 0x71, 0x08, 0xD0, 0xB7, 0x60, 0x5E, 0x08, 0x76, 0x0A,
  0xB0, 0x37, 0x10, 0x3D, 0x0D, 0x76, 0x08, 0xE0, 0xB7, 0x60, 0xBA, 0x0D, 0x73, 0xE7, 0x60, 0xCE,
  0x0E, 0x76, 0x0E, 0xA0, 0x97, 0x30, 0xBD, 0x03, 0x75, 0xF9, 0x02, 0x74, 0x01, 0xB0, 0x57, 0x30,
  0x8D, 0x07, 0x74, 0x04, 0xF9, 0x06, 0x74, 0x05, 0xB0, 0x17, 0x30, 0x4D, 0x0A, 0x74, 0x08, 0xA0,
  0x0C, 0xC0, 0x97, 0x40, 0x8A, 0x0D, 0x75, 0xD0, 0xE7, 0x40, 0xBA, 0x00, 0x9C, 0x0D, 0x74, 0x0C,
  0xA0, 0x97, 0x50, 0xCD, 0x02, 0x73, 0xB0, 0x05, 0xD0, 0x17, 0x3B, 0x06, 0x75, 0x08, 0xD0, 0x57,
  0x20, 0x3B, 0x01, 0x02, 0xD0, 0x47, 0x20, 0x4B, 0x02, 0x75, 0x04, 0xD0, 0x97, 0x20, 0x7A, 0x0D,
  0x20, 0xDC, 0x08, 0x72, 0x07, 0xA0, 0xE7, 0x60, 0x1D, 0x0C, 0x72, 0x0B, 0xA0, 0x92, 0x0A, 0xC0,
  0xB7, 0x20, 0xBA, 0x0A, 0x77, 0x0C, 0xD0, 0x17, 0x10, 0xEA, 0x05, 0x20, 0x6C, 0x0E, 0x72, 0x0E,
  0xA0, 0x67, 0x70, 0x9D, 0x04, 0x70, 0x3B, 0x01, 0x20, 0x3D, 0x02, 0x70, 0x3B, 0x03, 0x77, 0x05,
  0xD0, 0x77, 0x06, 0xA0, 0xD4, 0x0E, 0xC0, 0x67, 0x07, 0xA0, 0xE7, 0x71, 0x01, 0xD0, 0xB7, 0x0A,
  0xA0, 0x94, 0x0B, 0xC0, 0x97, 0x0A, 0xA0, 0xB7, 0x72, 0x0D, 0xC0, 0xE7, 0x0E, 0xA0, 0x64, 0x07,
  0xC0, 0xD7, 0x0E, 0xA0, 0x77, 0x72, 0x09, 0xD0, 0x25, 0x02, 0xB0, 0x24, 0x04, 0xD0, 0x15, 0x02,
  0xB0, 0x37, 0x72, 0x06, 0xD0, 0x65, 0x06, 0xA0, 0xE6, 0xD0, 0x45, 0x06, 0xB7, 0x73, 0x02, 0xD0,
  0x95, 0x09, 0xA0, 0xA6, 0x0C, 0xC0, 0x85, 0x09, 0xA0, 0xB7, 0x74, 0x0D, 0xC0, 0xD5, 0x0D, 0xA0,
  0x66, 0x08, 0xC0, 0xB5, 0x0D, 0xA0, 0x87, 0x74, 0x0A, 0xD0, 0x13, 0x01, 0xB0, 0x26, 0x05, 0xC0,
  0xE4, 0x01, 0xB0, 0x47, 0x74, 0x06, 0xD0, 0x43, 0x05, 0xA0, 0xE7, 0x01, 0xD0, 0x33, 0x05, 0xB7,
  0x75, 0x02, 0xD0, 0x83, 0x08, 0xA0, 0xA7, 0x10, 0xDC, 0x06, 0x30, 0x9A, 0x0C, 0x77, 0x60, 0xEC,
  0x0B, 0x30, 0xCA, 0x07, 0x71, 0x09, 0xC0, 0x93, 0x0C, 0xA0, 0x87, 0x76, 0x0A, 0xC0, 0xE3, 0xB0,
  0x37, 0x10, 0x6C, 0x0D, 0x3B, 0x04, 0x77, 0x60, 0x7D, 0x81, 0x20, 0x3A, 0x0E, 0x72, 0x02, 0xD8,
  0x11, 0x04, 0xB0, 0x17, 0x76, 0x03, 0xD8, 0x16, 0x06, 0xA0, 0xB7, 0x30, 0xEC, 0x81, 0x40, 0x7A,
  0x0D, 0x77, 0x71, 0x0E, 0xC8, 0x19, 0x0A, 0xA0, 0x77, 0x30, 0xBC, 0x81, 0x70, 0xAA, 0x09, 0x77,
  0x71, 0x0B, 0xC8, 0x1C, 0x0D, 0xA0, 0x37, 0x30, 0x7C, 0x81, 0xB0, 0xEA, 0x05, 0x77, 0x71, 0x07,
  0xD0, 0x1B, 0x74, 0x03, 0xC0, 0xE0, 0x1B, 0x01, 0x77, 0x71, 0x03, 0xD0, 0x6A, 0x0B, 0x75, 0xD0,
  0x5A, 0x0D, 0x77, 0x73, 0xD0, 0xBA, 0x08, 0x75, 0x0C, 0xC0, 0xBA, 0x09, 0x77, 0x73, 0x0B, 0xF0,
  0x47, 0x50, 0x8F, 0x06, 0x77, 0x73, 0x08, 0xF7, 0x60, 0x4F, 0x02, 0x77, 0x73, 0x04, 0xE0, 0xC7,
  0x60, 0x1E, 0x0E, 0x77, 0x75, 0xE0, 0x87, 0x70, 0xDD, 0x0A, 0x77, 0x75, 0x0C, 0xD0, 0x47, 0x70,
  0x9D, 0x06, 0x77, 0x75, 0x08, 0xD0, 0x17, 0x70, 0x5D, 0x03, 0x76,
  // "X" (U+0058)
  0x10, 0xCF, 0xE0, 0x85, 0x08, 0xFB, 0x0B, 0x20, 0xCF, 0xE0, 0x85, 0x08, 0xFB, 0x0B, 0x20, 0xCF,
  0xE0, 0x85, 0x08, 0xFB, 0x0B, 0x28, 0x21, 0x26, 0xEF, 0x81, 0xE5, 0x27, 0x81, 0x26, 0xED, 0x81,
  0x83, 0x15, 0x02, 0x0D, 0xE0, 0x87, 0x40, 0xAC, 0x03, 0x72, 0x04, 0xE0, 0x97, 0x40, 0xAB, 0x06,
  0x74, 0x0A, 0xD0, 0xD7, 0x40, 0xEA, 0x0B, 0x75, 0x02, 0xE0, 0x57, 0x20, 0x6B, 0x02, 0x76, 0x09,
  0xD0, 0xC7, 0x20, 0xDA, 0x08, 0x77, 0x01, 0x0E, 0xD0, 0x57, 0x06, 0xA0, 0xE0, 0x17, 0x71, 0x07,
  0xD0, 0xC7, 0x0E, 0xA0, 0x67, 0x73, 0x0E, 0xD0, 0x55, 0x07, 0xA0, 0xC7, 0x74, 0x06, 0xD0, 0xD4,
  0x01, 0x0E, 0xA0, 0x47, 0x75, 0x0D, 0xD0, 0x53, 0x08, 0xA0, 0xA7, 0x76, 0x05, 0xD0, 0xD2, 0x01,
  0xB0, 0x27, 0x77, 0x0C, 0xD8, 0x16, 0x09, 0xA0, 0x87, 0x77, 0x10, 0x4D, 0x0D, 0x03, 0xA0, 0xE0,
  0x17, 0x77, 0x20, 0xBD, 0x0E, 0xA0, 0x67, 0x77, 0x30, 0x3F, 0x0C, 0x77, 0x75, 0x0A, 0xE0, 0x47,
  0x77, 0x50, 0x2E, 0x02, 0x77, 0x76, 0x09, 0xD0, 0xA7, 0x77, 0x60, 0xCE, 0x03, 0x77, 0x74, 0x06,
  0xF0, 0xC7, 0x77, 0x30, 0x10, 0xEA, 0x0D, 0xD0, 0x57, 0x77, 0x20, 0x9A, 0x09, 0x04, 0xD0, 0xD7,
  0x77, 0x10, 0x3A, 0x82, 0xE1, 0x0B, 0xD0, 0x77, 0x77, 0x0C, 0xA0, 0x72, 0x03, 0xD0, 0xE0, 0x17,
  0x75, 0x07, 0xA0, 0xD4, 0x0A, 0xD0, 0x87, 0x74, 0x01, 0x0E, 0xA0, 0x54, 0x02, 0xE0, 0x27, 0x73,
  0x0A, 0xA0, 0xB6, 0x09, 0xD0, 0xA7, 0x72, 0x04, 0xB0, 0x36, 0x01, 0x0E, 0xD0, 0x37, 0x71, 0x0D,
  0xA0, 0x97, 0x10, 0x8D, 0x0C, 0x77, 0x07, 0xA0, 0xE0, 0x17, 0x10, 0x10, 0xED, 0x05, 0x75, 0x02,
  0x0E, 0xA0, 0x87, 0x30, 0x7D, 0x0D, 0x75, 0x0A, 0xB0, 0x17, 0x40, 0xDD, 0x07, 0x73, 0x05, 0xB0,
  0x97, 0x50, 0x6D, 0x0E, 0x01, 0x71, 0x01, 0x0E, 0xB0, 0x57, 0x50, 0x1E, 0x0A, 0x71, 0x0B, 0xC0,
  0x67, 0x50, 0x2F, 0x07, 0x48, 0x12, 0x5D, 0xD8, 0x2E, 0x62, 0x17, 0x81, 0x14, 0xCF, 0x98, 0x2A,
  0x31, 0x9F, 0xC0, 0xB6, 0x04, 0xFF, 0x09, 0xFC, 0x0B, 0x60, 0x4F, 0xF0, 0x9F, 0xC0, 0xB6, 0x04,
  0xFF,
  // "Y" (U+0059)
  0x03, 0xFF, 0x02, 0x50, 0xAF, 0xC0, 0xB0, 0x3F, 0xF0, 0x25, 0x0A, 0xFC, 0x0B, 0x03, 0xFF, 0x02,
  0x50, 0xAF, 0xC8, 0x3B, 0x01, 0x4C, 0xF8, 0x2D, 0x41, 0x17, 0x82, 0x12, 0x6E, 0xD8, 0x1B, 0x31,
  0x40, 0xDE, 0x05, 0x76, 0x06, 0xC0, 0xB7, 0x04, 0xE0, 0x57, 0x60, 0x2B, 0x0E, 0x01, 0x71, 0x0A,
  0xD0, 0x87, 0x60, 0x4B, 0x07, 0x72, 0x03, 0xD0, 0xE7, 0x60, 0x8A, 0x0E, 0x74, 0x0A, 0xD0, 0x67,
  0x50, 0xDA, 0x07, 0x74, 0x02, 0xD0, 0xD7, 0x40, 0x5A, 0x0E, 0x76, 0x0A, 0xD0, 0x57, 0x30, 0xDA,
  0x07, 0x76, 0x02, 0xD0, 0xD7, 0x20, 0x5A, 0x0E, 0x77, 0x10, 0xAD, 0x05, 0x71, 0x0D, 0xA0, 0x77,
  0x71, 0x02, 0xD0, 0xD7, 0x06, 0xA0, 0xE7, 0x73, 0x0A, 0xD0, 0x56, 0x0D, 0xA0, 0x77, 0x73, 0x02,
  0xD0, 0xC5, 0x06, 0xA0, 0xE7, 0x75, 0x0A, 0xD0, 0x44, 0x0D, 0xA0, 0x77, 0x75, 0x02, 0xD0, 0xB3,
  0x04, 0xA0, 0xE7, 0x77, 0x09, 0xD0, 0x22, 0x0B, 0xA0, 0x67, 0x77, 0x02, 0xD8, 0x19, 0x03, 0xA0,
  0xE7, 0x77, 0x20, 0x9C, 0x81, 0xE0, 0xAA, 0x06, 0x77, 0x72, 0x02, 0xD0, 0x7A, 0x0E, 0x77, 0x74,
  0x09, 0xF0, 0x67, 0x77, 0x40, 0x2E, 0x0D, 0x77, 0x76, 0x09, 0xD0, 0x67, 0x77, 0x60, 0x6D, 0x04,
  0x77, 0x76, 0x06, 0xD0, 0x47, 0x77, 0x60, 0x6D, 0x04, 0x77, 0x76, 0x06, 0xD0, 0x47, 0x77, 0x60,
  0x6D, 0x04, 0x77, 0x76, 0x06, 0xD0, 0x47, 0x77, 0x60, 0x6D, 0x04, 0x77, 0x76, 0x06, 0xD0, 0x47,
  0x77, 0x60, 0x6D, 0x04, 0x77, 0x76, 0x06, 0xD0, 0x47, 0x77, 0x60, 0x6D, 0x04, 0x77, 0x76, 0x07,
  0xD0, 0x47, 0x77, 0x60, 0x9D, 0x07, 0x77, 0x75, 0x01, 0x0E, 0xD0, 0xD7, 0x77, 0x28, 0x21, 0x37,
  0xEF, 0x82, 0xD6, 0x31, 0x77, 0x40, 0xCF, 0xF9, 0x0A, 0x77, 0x30, 0xCF, 0xF9, 0x0A, 0x77, 0x30,
  0xCF, 0xF9, 0x0A, 0x71,
  // "Z" (U+005A)
  0x20, 0xDF, 0xFF, 0xA0, 0xE3, 0x0E, 0xFF, 0xFA, 0x0E, 0x30, 0xEE, 0x80, 0x7E, 0xE0, 0xC3, 0x0E,
  0xB0, 0xC0, 0x37, 0x50, 0xED, 0x05, 0x3B, 0x0E, 0x01, 0x75, 0x07, 0xD0, 0xC4, 0xB0, 0x87, 0x50,
  0x10, 0xED, 0x04, 0x4B, 0x03, 0x75, 0x08, 0xD0, 0xC5, 0xB7, 0x50, 0x10, 0xED, 0x04, 0x40, 0x1A,
  0x0D, 0x75, 0x08, 0xD0, 0xB5, 0x01, 0xA0, 0xC7, 0x40, 0x1E, 0x03, 0x68, 0x16, 0x64, 0x74, 0x09,
  0xD0, 0xB7, 0x76, 0x02, 0xE0, 0x37, 0x76, 0x09, 0xD0, 0xA7, 0x76, 0x02, 0xE0, 0x27, 0x76, 0x0A,
  0xD0, 0xA7, 0x76, 0x02, 0xE0, 0x27, 0x76, 0x0A, 0xD0, 0x97, 0x76, 0x03, 0xE0, 0x27, 0x76, 0x0B,
  0xD0, 0x97, 0x76, 0x03, 0xE0, 0x17, 0x76, 0x0B, 0xD0, 0x87, 0x76, 0x04, 0xD0, 0xE0, 0x17, 0x76,
  0x0C, 0xD0, 0x87, 0x76, 0x04, 0xD0, 0xE0, 0x17, 0x76, 0x0C, 0xD0, 0x77, 0x76, 0x05, 0xD0, 0xE7,
  0x77, 0x0D, 0xD0, 0x77, 0x76, 0x05, 0xD0, 0xD7, 0x77, 0x0D, 0xD0, 0x67, 0x76, 0x06, 0xD0, 0xD7,
  0x77, 0x0D, 0xD0, 0x67, 0x76, 0x06, 0xD0, 0xD7, 0x77, 0x0E, 0xD0, 0x57, 0x68, 0x16, 0x64, 0x40,
  0x7D, 0x0C, 0x76, 0x02, 0xA0, 0xB4, 0x0E, 0xD0, 0x47, 0x60, 0x3A, 0x0A, 0x30, 0x7D, 0x0C, 0x77,
  0x05, 0xA0, 0xA2, 0x01, 0x0E, 0xD0, 0x47, 0x70, 0x8A, 0x0A, 0x20, 0x8D, 0x0B, 0x77, 0x10, 0xDA,
  0x82, 0xA0, 0x1E, 0xD0, 0x37, 0x70, 0x6B, 0x81, 0x90, 0x8D, 0x0B, 0x76, 0x81, 0x16, 0xEB, 0x09,
  0x01, 0xF8, 0x09, 0x0E, 0xF0, 0x90, 0x2F, 0xFF, 0xD0, 0x90, 0x2F, 0xFF, 0xD0, 0x80,
  // "[" (U+005B)
  0x0E, 0xFC, 0x0E, 0xFC, 0x0E, 0xFC, 0x0E, 0xD8, 0x5E, 0x83, 0x11, 0x1E, 0xD0, 0x45, 0x0E, 0xC0,
  0xD6, 0x0E, 0xC0, 0xA6, 0x0E, 0xC0, 0x96, 0x0E, 0xC0, 0x96, 0x0E, 0xC0, 0x96, 0x0E, 0xC0, 0x96,
  0x0E, 0xC0, 0x96, 0x0E, 0xC0, 0x96, 0x0E, 0xC0, 0x96, 0x0E, 0xC0, 0x96, 0x0E, 0xC0, 0x96, 0x0E,
  0xC0, 0x96, 0x0E, 0xC0, 0x96, 0x0E, 0xC0, 0x96, 0x0E, 0xC0, 0x96, 0x0E, 0xC0, 0x96, 0x0E, 0xC0,
  0x96, 0x0E, 0xC0, 0x96, 0x0E, 0xC0, 0x96, 0x0E, 0xC0, 0x96, 0x0E, 0xC0, 0x96, 0x0E, 0xC0, 0x96,
  0x0E, 0xC0, 0x96, 0x0E, 0xC0, 0x96, 0x0E, 0xC0, 0x96, 0x0E, 0xC0, 0x96, 0x0E, 0xC0, 0x96, 0x0E,
  0xC0, 0x96, 0x0E, 0xC0, 0x96, 0x0E, 0xC0, 0x96, 0x0E, 0xC0, 0x96, 0x0E, 0xC0, 0x96, 0x0E, 0xC0,
  0x96, 0x0E, 0xC0, 0x96, 0x0E, 0xC0, 0x96, 0x0E, 0xC0, 0x96, 0x0E, 0xC0, 0x96, 0x0E, 0xC0, 0x96,
  0x0E, 0xC0, 0x96, 0x0E, 0xC0, 0x96, 0x0E, 0xC0, 0x96, 0x0E, 0xC0, 0x96, 0x0E, 0xC0, 0xA6, 0x0E,
  0xC0, 0xD6, 0x0E, 0xD0, 0x45, 0x0E, 0xD8, 0x5E, 0x83, 0x11, 0x1E, 0xFC, 0x0E, 0xFC, 0x0E, 0xFC,
  // "\" (U+005C)
  0x0D, 0xA0, 0x37, 0x40, 0xAA, 0x07, 0x74, 0x07, 0xA0, 0xA7, 0x40, 0x3A, 0x0D, 0x75, 0xB0, 0x17,
  0x40, 0xCA, 0x05, 0x74, 0x08, 0xA0, 0x87, 0x40, 0x5A, 0x0B, 0x74, 0x02, 0xB7, 0x50, 0xEA, 0x03,
  0x74, 0x0A, 0xA0, 0x67, 0x40, 0x7A, 0x0A, 0x74, 0x03, 0xA0, 0xD7, 0x5B, 0x01, 0x74, 0x0C, 0xA0,
  0x47, 0x40, 0x9A, 0x08, 0x74, 0x05, 0xA0, 0xB7, 0x40, 0x2A, 0x0E, 0x75, 0x0E, 0xA0, 0x27, 0x40,
  0xBA, 0x06, 0x74, 0x07, 0xA0, 0x97, 0x40, 0x4A, 0x0D, 0x74, 0x01, 0xB0, 0x17, 0x40, 0xDA, 0x04,
  0x74, 0x09, 0xA0, 0x77, 0x40, 0x6A, 0x0B, 0x74, 0x02, 0xA0, 0xE7, 0x50, 0xEA, 0x02, 0x74, 0x0B,
  0xA0, 0x57, 0x40, 0x8A, 0x09, 0x74, 0x04, 0xA0, 0xC7, 0x40, 0x1B, 0x75, 0x0D, 0xA0, 0x47, 0x40,
  0x9A, 0x07, 0x74, 0x06, 0xA0, 0xA7, 0x40, 0x3A, 0x0E, 0x75, 0x0E, 0xA0, 0x27, 0x40, 0xBA, 0x05,
  0x74, 0x08, 0xA0, 0x97, 0x40, 0x5A, 0x0C, 0x74, 0x01, 0xB7, 0x50, 0xDA, 0x03, 0x74, 0x0A, 0xA0,
  0x77, 0x40, 0x6A, 0x0A, 0x74, 0x03, 0xA0, 0xD7, 0x5B, 0x01, 0x74, 0x0C, 0xA0, 0x57, 0x40, 0x8A,
  0x08, 0x74, 0x05, 0xA0, 0xC7, 0x40, 0x1B, 0x75, 0x0E, 0xA0, 0x37, 0x40, 0xAA, 0x06, 0x74, 0x07,
  0xA0, 0xA0,
  // "]" (U+005D)
  0x01, 0xFC, 0x0C, 0x01, 0xFC, 0x0C, 0x01, 0xFC, 0x85, 0xC0, 0x11, 0x14, 0x9E, 0x0C, 0x60, 0x5D,
  0x0C, 0x70, 0xEC, 0x0C, 0x70, 0xBC, 0x0C, 0x70, 0xBC, 0x0C, 0x70, 0xBC, 0x0C, 0x70, 0xBC, 0x0C,
  0x70, 0xBC, 0x0C, 0x70, 0xBC, 0x0C, 0x70, 0xBC, 0x0C, 0x70, 0xBC, 0x0C, 0x70, 0xBC, 0x0C, 0x70,
  0xBC, 0x0C, 0x70, 0xBC, 0x0C, 0x70, 0xBC, 0x0C, 0x70, 0xBC, 0x0C, 0x70, 0xBC, 0x0C, 0x70, 0xBC,
  0x0C, 0x70, 0xBC, 0x0C, 0x70, 0xBC, 0x0C, 0x70, 0xBC, 0x0C, 0x70, 0xBC, 0x0C, 0x70, 0xBC, 0x0C,
  0x70, 0xBC, 0x0C, 0x70, 0xBC, 0x0C, 0x70, 0xBC, 0x0C, 0x70, 0xBC, 0x0C, 0x70, 0xBC, 0x0C, 0x70,
  0xBC, 0x0C, 0x70, 0xBC, 0x0C, 0x70, 0xBC, 0x0C, 0x70, 0xBC, 0x0C, 0x70, 0xBC, 0x0C, 0x70, 0xBC,
  0x0C, 0x70, 0xBC, 0x0C, 0x70, 0xBC, 0x0C, 0x70, 0xBC, 0x0C, 0x70, 0xBC, 0x0C, 0x70, 0xBC, 0x0C,
  0x70, 0xBC, 0x0C, 0x70, 0xBC, 0x0C, 0x70, 0xBC, 0x0C, 0x70, 0xBC, 0x0C, 0x70, 0xBC, 0x0C, 0x70,
  0xBC, 0x0C, 0x70, 0xEC, 0x0C, 0x60, 0x5D, 0x85, 0xC0, 0x11, 0x13, 0x9E, 0x0C, 0x01, 0xFC, 0x0C,
  0x01, 0xFC, 0x0C, 0x01, 0xFC, 0x0C,
  // "^" (U+005E)
  0x73, 0x81, 0x3F, 0xE7, 0x77, 0x0A, 0xA0, 0x67, 0x75, 0x01, 0xB0, 0xC7, 0x75, 0x07, 0xC0, 0x37,
  0x74, 0x0D, 0xC0, 0x97, 0x73, 0x03, 0xD0, 0xE0, 0x17, 0x72, 0x0A, 0xA0, 0x90, 0xDA, 0x06, 0x77,
  0x10, 0x1B, 0x03, 0x07, 0xA0, 0xC7, 0x71, 0x06, 0xA8, 0x1C, 0x01, 0xB0, 0x37, 0x70, 0xDA, 0x06,
  0x20, 0xBA, 0x09, 0x76, 0x03, 0xB0, 0x12, 0x04, 0xB0, 0x17, 0x50, 0xAA, 0x0A, 0x40, 0xEA, 0x06,
  0x74, 0x01, 0xB0, 0x44, 0x08, 0xA0, 0xD7, 0x40, 0x6A, 0x0D, 0x50, 0x2B, 0x03, 0x73, 0x0D, 0xA0,
  0x86, 0x0B, 0xA0, 0xA7, 0x20, 0x3B, 0x02, 0x60, 0x5B, 0x01, 0x71, 0x0A, 0xA0, 0xB7, 0x10, 0xEA,
  0x07, 0x70, 0x1B, 0x05, 0x71, 0x09, 0xA0, 0xD7, 0x06, 0xA0, 0xE7, 0x20, 0x2B, 0x04, 0x60, 0xDA,
  0x09, 0x73, 0x0C, 0xA0, 0xA5, 0x03, 0xB0, 0x37, 0x30, 0x6B, 0x01, 0x40, 0xAA, 0x0C, 0x75, 0x0E,
  0xA0, 0x73, 0x01, 0xB0, 0x67, 0x50, 0x9A, 0x0D, 0x30, 0x6B, 0x01, 0x75, 0x03, 0xB0, 0x42, 0x0D,
  0xA0, 0xA7, 0x70, 0xDA, 0x81, 0xA0, 0x3B, 0x04, 0x77, 0x07, 0xB0, 0x10, 0xAA, 0x0D, 0x77, 0x10,
  0x1B, 0x07,
  // "_" (U+005F)
  0x18, 0x0A, 0x31, 0x10, 0x3F, 0xFF, 0xA0, 0xA0, 0x3F, 0xFF, 0xA0, 0xA0, 0x3F, 0xFF, 0xA0, 0xA0,
  // "`" (U+0060)
  0x04, 0x80, 0x17, 0x03, 0x50, 0x5D, 0x0B, 0x60, 0x9D, 0x03, 0x60, 0xCC, 0x0A, 0x60, 0x10, 0xDC,
  0x03, 0x60, 0x20, 0xDB, 0x0C, 0x70, 0x20, 0xDB, 0x05, 0x70, 0x20, 0xDA, 0x0E, 0x01, 0x70, 0x10,
  0xCA, 0x09, 0x72, 0x0A, 0xA0, 0x10,
  // "a" (U+0061)
  0x71, 0x86, 0x24, 0x67, 0x76, 0x41, 0x77, 0x18, 0x12, 0x9E, 0xF9, 0x0D, 0x06, 0x75, 0x08, 0xFE,
  0x0C, 0x02, 0x72, 0x08, 0xD8, 0x3E, 0xB9, 0x9C, 0xD0, 0xD7, 0x10, 0x1D, 0x0B, 0x01, 0x40, 0x40,
  0xEC, 0x08, 0x70, 0x4D, 0x01, 0x60, 0x7C, 0x0E, 0x70, 0x5C, 0x0B, 0x70, 0x1D, 0x04, 0x60, 0x1C,
  0x07, 0x71, 0x0D, 0xC0, 0x77, 0x06, 0xB0, 0x67, 0x10, 0xBC, 0x09, 0x71, 0x82, 0x16, 0x83, 0x71,
  0x0A, 0xC0, 0xA7, 0x76, 0x0A, 0xC0, 0xB7, 0x76, 0x09, 0xC0, 0xB7, 0x76, 0x09, 0xC0, 0xB7, 0x76,
  0x09, 0xC0, 0xB7, 0x38, 0x43, 0x7A, 0xDE, 0xEF, 0xA0, 0xB7, 0x10, 0x50, 0xDF, 0xF9, 0x0B, 0x70,
  0xAD, 0x86, 0xC7, 0x43, 0x22, 0x29, 0xC0, 0xB6, 0x0A, 0xD0, 0x57, 0x09, 0xC0, 0xB5, 0x04, 0xD0,
  0x67, 0x10, 0x9C, 0x0B, 0x50, 0xCC, 0x0C, 0x72, 0x09, 0xC0, 0xB4, 0x01, 0xD0, 0x77, 0x20, 0x9C,
  0x0B, 0x40, 0x4D, 0x03, 0x72, 0x09, 0xC0, 0xB4, 0x06, 0xD0, 0x17, 0x20, 0xAC, 0x0B, 0x40, 0x7D,
  0x01, 0x72, 0x0C, 0xC0, 0xB4, 0x06, 0xD0, 0x17, 0x2D, 0x0B, 0x40, 0x5D, 0x02, 0x71, 0x05, 0xD0,
  0xB4, 0x03, 0xD0, 0x57, 0x10, 0xCD, 0x0C, 0x5D, 0x09, 0x78, 0x16, 0xF7, 0xC0, 0xD5, 0x0B, 0xD0,
  0x25, 0x83, 0x5F, 0xA0, 0xEC, 0x02, 0x40, 0x4D, 0x89, 0x1E, 0x51, 0x24, 0xAF, 0xE1, 0x0C, 0xC8,
  0x1D, 0x41, 0x30, 0x9F, 0xC0, 0x42, 0x0A, 0xF0, 0x13, 0x0A, 0xFA, 0x06, 0x30, 0x8F, 0x01, 0x40,
  0x60, 0xED, 0x0D, 0x04, 0x40, 0x6F, 0x01, 0x68, 0x34, 0x67, 0x63, 0x77, 0x10,
  // "b" (U+0062)
  0x01, 0xFA, 0x0C, 0x77, 0x40, 0x1F, 0xA0, 0xC7, 0x74, 0x01, 0xFA, 0x0C, 0x77, 0x58, 0x21, 0x37,
  0xED, 0x0C, 0x77, 0x71, 0x02, 0xD0, 0xC7, 0x77, 0x20, 0xBC, 0x0C, 0x77, 0x72, 0x09, 0xC0, 0xC7,
  0x77, 0x20, 0x8C, 0x0C, 0x77, 0x72, 0x08, 0xC0, 0xC7, 0x77, 0x20, 0x8C, 0x0C, 0x77, 0x72, 0x08,
  0xC0, 0xC7, 0x77, 0x20, 0x8C, 0x0C, 0x77, 0x72, 0x08, 0xC0, 0xC7, 0x77, 0x20, 0x8C, 0x0C, 0x58,
  0x43, 0x67, 0x64, 0x17, 0x50, 0x8C, 0x0B, 0x30, 0x50, 0xDE, 0x0B, 0x03, 0x73, 0x08, 0xC0, 0xB2,
  0x09, 0xFB, 0x08, 0x72, 0x08, 0xC8, 0x1B, 0x07, 0xA8, 0x3D, 0xA9, 0xBE, 0xD0, 0x87, 0x10, 0x8C,
  0x83, 0xA3, 0xFE, 0x54, 0x01, 0x0A, 0xD0, 0x57, 0x08, 0xC8, 0x2A, 0xBE, 0x27, 0x0A, 0xC0, 0xD7,
  0x08, 0xC8, 0x1D, 0xF7, 0x71, 0x02, 0xD0, 0x66, 0x08, 0xE0, 0x17, 0x20, 0xAC, 0x0B, 0x60, 0x8D,
  0x0B, 0x73, 0x05, 0xD0, 0x15, 0x08, 0xD0, 0x77, 0x30, 0x2D, 0x04, 0x50, 0x8D, 0x04, 0x74, 0x0E,
  0xC0, 0x75, 0x08, 0xD0, 0x17, 0x40, 0xCC, 0x0A, 0x50, 0x8D, 0x75, 0x0A, 0xC0, 0xB5, 0x08, 0xC0,
  0xE7, 0x50, 0x9C, 0x0D, 0x50, 0x8C, 0x0D, 0x75, 0x08, 0xC0, 0xE5, 0x08, 0xC0, 0xD7, 0x50, 0x8C,
  0x0E, 0x50, 0x8C, 0x0C, 0x75, 0x07, 0xD5, 0x08, 0xC0, 0xC7, 0x50, 0x7D, 0x50, 0x8C, 0x0D, 0x75,
  0x08, 0xC0, 0xE5, 0x08, 0xC0, 0xD7, 0x50, 0x8C, 0x0E, 0x50, 0x8C, 0x0E, 0x75, 0x09, 0xC0, 0xD5,
  0x08, 0xD7, 0x50, 0xBC, 0x0B, 0x50, 0x8D, 0x02, 0x74, 0x0C, 0xC0, 0x95, 0x08, 0xD0, 0x47, 0x4D,
  0x07, 0x50, 0x8D, 0x07, 0x73, 0x02, 0xD0, 0x45, 0x08, 0xD0, 0xB7, 0x30, 0x6D, 0x60, 0x9E, 0x01,
  0x72, 0x0B, 0xC0, 0xA6, 0x0B, 0xE0, 0x87, 0x10, 0x2D, 0x05, 0x50, 0x2D, 0x0C, 0xA0, 0x37, 0x0B,
  0xC0, 0xD3, 0x82, 0x13, 0x7E, 0xD8, 0x32, 0xAF, 0xE5, 0x40, 0x10, 0xAD, 0x03, 0x20, 0x1F, 0x98,
  0x2E, 0x01, 0xDA, 0x83, 0xDA, 0x9B, 0xED, 0x06, 0x30, 0x1F, 0x90, 0xA2, 0x01, 0x0D, 0xFB, 0x06,
  0x40, 0x1F, 0x90, 0x73, 0x01, 0x09, 0xF0, 0xA0, 0x27, 0x77, 0x84, 0x46, 0x76, 0x41, 0x70,
  // "c" (U+0063)
  0x72, 0x85, 0x25, 0x67, 0x65, 0x27, 0x58, 0x11, 0x7D, 0xF8, 0x1E, 0x92, 0x71, 0x04, 0x0E, 0xFD,
  0x07, 0x60, 0x5D, 0x82, 0xEA, 0x9B, 0xE0, 0x74, 0x03, 0xD0, 0x84, 0x02, 0x0D, 0xD0, 0x13, 0x0D,
  0xC0, 0x86, 0x05, 0xD0, 0x52, 0x05, 0xC0, 0xD7, 0x10, 0xEC, 0x07, 0x20, 0xCC, 0x07, 0x71, 0x0A,
  0xC8, 0x16, 0x02, 0xD0, 0x17, 0x10, 0x8C, 0x81, 0x20, 0x6C, 0x0D, 0x72, 0x07, 0xA0, 0xE0, 0x52,
  0x0A, 0xC0, 0xA7, 0x28, 0x12, 0x53, 0x40, 0xDC, 0x08, 0x77, 0x20, 0xEC, 0x06, 0x77, 0x10, 0x1D,
  0x05, 0x77, 0x10, 0x2D, 0x04, 0x77, 0x10, 0x2D, 0x03, 0x77, 0x10, 0x3D, 0x03, 0x77, 0x10, 0x3D,
  0x03, 0x77, 0x10, 0x3D, 0x03, 0x77, 0x10, 0x2D, 0x04, 0x77, 0x10, 0x1D, 0x05, 0x77, 0x20, 0xEC,
  0x07, 0x77, 0x20, 0xDC, 0x09, 0x77, 0x20, 0x9C, 0x0B, 0x77, 0x20, 0x6D, 0x77, 0x20, 0x1D, 0x04,
  0x77, 0x20, 0xBC, 0x0A, 0x75, 0x0C, 0x02, 0x20, 0x4D, 0x03, 0x73, 0x81, 0x9F, 0x73, 0x0B, 0xC0,
  0xD0, 0x17, 0x10, 0x8A, 0x06, 0x30, 0x10, 0xEC, 0x0D, 0x04, 0x50, 0x20, 0xBB, 0x01, 0x40, 0x30,
  0xED, 0x83, 0xDA, 0x9A, 0xCC, 0x08, 0x60, 0x20, 0xCF, 0xD0, 0x87, 0x20, 0x50, 0xCF, 0x90, 0xA0,
  0x37, 0x58, 0x51, 0x46, 0x77, 0x64, 0x60,
  // "d" (U+0064)
  0x77, 0x09, 0xFA, 0x04, 0x77, 0x40, 0x9F, 0xA0, 0x47, 0x74, 0x09, 0xFA, 0x04, 0x77, 0x58, 0x12,
  0x5B, 0xE0, 0x47, 0x77, 0x10, 0x9D, 0x04, 0x77, 0x71, 0x03, 0xD0, 0x47, 0x77, 0x2D, 0x04, 0x77,
  0x72, 0xD0, 0x47, 0x77, 0x2D, 0x04, 0x77, 0x72, 0xD0, 0x47, 0x77, 0x2D, 0x04, 0x77, 0x72, 0xD0,
  0x47, 0x77, 0x2D, 0x04, 0x75, 0x84, 0x25, 0x67, 0x63, 0x5D, 0x04, 0x73, 0x05, 0x0C, 0xE0, 0xD0,
  0x53, 0xD0, 0x47, 0x20, 0xAF, 0xB0, 0x82, 0xD0, 0x47, 0x10, 0xBD, 0x83, 0xDA, 0x9B, 0xEA, 0x81,
  0x70, 0xEC, 0x04, 0x70, 0x9D, 0x07, 0x40, 0x10, 0x8A, 0x02, 0x0D, 0xC0, 0x46, 0x03, 0xD0, 0x77,
  0x82, 0x6F, 0xCD, 0xC0, 0x46, 0x0A, 0xC0, 0xD7, 0x20, 0xCE, 0x04, 0x50, 0x1D, 0x07, 0x72, 0x05,
  0xE0, 0x45, 0x05, 0xD0, 0x27, 0x30, 0xED, 0x04, 0x50, 0x9C, 0x0D, 0x74, 0x0B, 0xD0, 0x45, 0x0C,
  0xC0, 0xB7, 0x40, 0x8D, 0x04, 0x50, 0xEC, 0x08, 0x74, 0x05, 0xD0, 0x44, 0x01, 0xD0, 0x67, 0x40,
  0x3D, 0x04, 0x40, 0x2D, 0x05, 0x74, 0x02, 0xD0, 0x44, 0x03, 0xD0, 0x47, 0x40, 0x1D, 0x04, 0x40,
  0x4D, 0x04, 0x75, 0xD0, 0x44, 0x04, 0xD0, 0x37, 0x5D, 0x04, 0x40, 0x4D, 0x03, 0x75, 0xD0, 0x44,
  0x04, 0xD0, 0x37, 0x5D, 0x04, 0x40, 0x3D, 0x04, 0x74, 0x01, 0xD0, 0x44, 0x02, 0xD0, 0x57, 0x40,
  0x2D, 0x04, 0x40, 0x1D, 0x06, 0x74, 0x04, 0xD0, 0x45, 0x0E, 0xC0, 0x87, 0x40, 0x5D, 0x04, 0x50,
  0xCC, 0x0A, 0x74, 0x08, 0xD0, 0x45, 0x09, 0xC0, 0xD7, 0x40, 0xBD, 0x04, 0x50, 0x5D, 0x01, 0x72,
  0x01, 0xE0, 0x45, 0x01, 0xD0, 0x67, 0x20, 0x6E, 0x05, 0x60, 0xAC, 0x0C, 0x72, 0x81, 0xDF, 0xEC,
  0x07, 0x60, 0x3D, 0x07, 0x78, 0x28, 0xFB, 0xAC, 0x0D, 0x70, 0x9D, 0x07, 0x40, 0x10, 0x9A, 0x02,
  0x08, 0xD8, 0x2C, 0x52, 0x14, 0x0C, 0xD8, 0x3D, 0xA9, 0xBE, 0xA8, 0x16, 0x07, 0xF9, 0x0D, 0x40,
  0x10, 0xBF, 0xB0, 0x72, 0x05, 0xF9, 0x0D, 0x60, 0x60, 0xCE, 0x0C, 0x04, 0x30, 0x3F, 0x90, 0xD7,
  0x18, 0x42, 0x56, 0x76, 0x27, 0x71,
  // "e" (U+0065)
  0x72, 0x84, 0x25, 0x77, 0x64, 0x77, 0x20, 0x70, 0xDF, 0x0B, 0x03, 0x74, 0x03, 0x0D, 0xFC, 0x09,
  0x72, 0x03, 0x0E, 0xC8, 0x2E, 0xA9, 0xBD, 0x0B, 0x70, 0x10, 0xEC, 0x08, 0x40, 0x10, 0xCC, 0x09,
  0x60, 0xBC, 0x08, 0x60, 0x10, 0xEC, 0x03, 0x40, 0x4C, 0x0D, 0x71, 0x06, 0xC0, 0xC4, 0x0B, 0xC0,
  0x67, 0x10, 0x1D, 0x02, 0x20, 0x1D, 0x01, 0x72, 0x0C, 0xC0, 0x72, 0x05, 0xC0, 0xC7, 0x30, 0x8C,
  0x0B, 0x20, 0x9C, 0x09, 0x73, 0x06, 0xC0, 0xE2, 0x0C, 0xC0, 0x77, 0x30, 0x4D, 0x81, 0x10, 0xEC,
  0x05, 0x73, 0x03, 0xD0, 0x21, 0xD0, 0x58, 0x06, 0x10, 0x4D, 0x03, 0x02, 0xFF, 0xF9, 0x00, 0x3F,
  0xFF, 0x90, 0x40, 0x3F, 0xFF, 0x90, 0x40, 0x3D, 0x03, 0x77, 0x30, 0x2D, 0x04, 0x77, 0x30, 0x1D,
  0x05, 0x77, 0x4D, 0x06, 0x77, 0x40, 0xEC, 0x08, 0x77, 0x40, 0xBC, 0x0A, 0x77, 0x40, 0x8C, 0x0D,
  0x77, 0x40, 0x4D, 0x02, 0x77, 0x40, 0xEC, 0x07, 0x76, 0x01, 0x40, 0x9C, 0x0D, 0x75, 0x07, 0x0D,
  0x40, 0x2D, 0x07, 0x73, 0x03, 0xA0, 0x34, 0x08, 0xD0, 0x47, 0x10, 0x30, 0xEA, 0x01, 0x50, 0xCD,
  0x08, 0x01, 0x50, 0x70, 0xEA, 0x0A, 0x60, 0x10, 0xDE, 0x83, 0xB9, 0x9B, 0xEB, 0x0D, 0x01, 0x70,
  0x10, 0xBF, 0xD0, 0xB0, 0x17, 0x30, 0x40, 0xBF, 0x90, 0xC0, 0x57, 0x78, 0x61, 0x46, 0x77, 0x64,
  0x17,
  // "f" (U+0066)
  0x73, 0x89, 0x02, 0x7C, 0xDF, 0xEE, 0xB8, 0x27, 0x40, 0x9F, 0xB0, 0x57, 0x20, 0xBF, 0xD0, 0x37,
  0x0A, 0xC8, 0x3A, 0x31, 0x5E, 0xC0, 0x96, 0x04, 0xC0, 0xB4, 0x05, 0xC0, 0xB6, 0x0B, 0xC0, 0x45,
  0x0E, 0xB0, 0x95, 0x01, 0xC0, 0xE6, 0x0B, 0xB0, 0x25, 0x05, 0xC0, 0xC6, 0x82, 0x9F, 0xC3, 0x60,
  0x8C, 0x0A, 0x60, 0x17, 0x20, 0xAC, 0x08, 0x77, 0x20, 0xBC, 0x08, 0x77, 0x20, 0xCC, 0x08, 0x77,
  0x20, 0xCC, 0x08, 0x77, 0x20, 0xCC, 0x08, 0x77, 0x20, 0xCC, 0x08, 0x74, 0x07, 0xFF, 0xA0, 0xB4,
  0x07, 0xFF, 0xA0, 0xB4, 0x07, 0xFF, 0xA0, 0xB5, 0x80, 0x01, 0x0C, 0xC0, 0x88, 0x02, 0x17, 0x30,
  0xCC, 0x08, 0x77, 0x20, 0xCC, 0x08, 0x77, 0x20, 0xCC, 0x08, 0x77, 0x20, 0xCC, 0x08, 0x77, 0x20,
  0xCC, 0x08, 0x77, 0x20, 0xCC, 0x08, 0x77, 0x20, 0xCC, 0x08, 0x77, 0x20, 0xCC, 0x08, 0x77, 0x20,
  0xCC, 0x08, 0x77, 0x20, 0xCC, 0x08, 0x77, 0x20, 0xCC, 0x08, 0x77, 0x20, 0xCC, 0x08, 0x77, 0x20,
  0xCC, 0x08, 0x77, 0x20, 0xCC, 0x08, 0x77, 0x20, 0xCC, 0x08, 0x77, 0x20, 0xCC, 0x08, 0x77, 0x20,
  0xCC, 0x08, 0x77, 0x20, 0xCC, 0x08, 0x77, 0x20, 0xCC, 0x08, 0x77, 0x20, 0xCC, 0x08, 0x77, 0x20,
  0xCC, 0x08, 0x77, 0x20, 0xDC, 0x08, 0x77, 0x2D, 0x0A, 0x77, 0x10, 0x6E, 0x02, 0x74, 0x81, 0x24,
  0x9F, 0x83, 0xE7, 0x31, 0x16, 0x0A, 0xFF, 0x90, 0x95, 0x0A, 0xFF, 0x90, 0x95, 0x0A, 0xFF, 0x90,
  0x95,
  // "g" (U+0067)
  0x77, 0x78, 0x21, 0x55, 0x27, 0x48, 0x43, 0x57, 0x75, 0x25, 0x05, 0x0E, 0xB0, 0x57, 0x81, 0x2A,
  0xEE, 0x0D, 0x05, 0x20, 0x8D, 0x0E, 0x60, 0x6F, 0xC0, 0x90, 0x8F, 0x02, 0x40, 0x6D, 0x82, 0xC9,
  0x9C, 0xE8, 0x1D, 0x9C, 0xB4, 0x02, 0xC0, 0xE0, 0x44, 0x04, 0x0E, 0xB0, 0xB3, 0x81, 0xDF, 0x94,
  0x0A, 0xC0, 0x56, 0x05, 0xC0, 0x32, 0x06, 0x07, 0x40, 0x1C, 0x0D, 0x71, 0x0D, 0xB0, 0xB7, 0x10,
  0x5C, 0x08, 0x71, 0x09, 0xC0, 0x27, 0x09, 0xC0, 0x67, 0x10, 0x7C, 0x06, 0x70, 0xAC, 0x04, 0x71,
  0x05, 0xC0, 0x97, 0x0B, 0xC0, 0x37, 0x10, 0x4C, 0x0A, 0x70, 0xCC, 0x03, 0x71, 0x05, 0xC0, 0xB7,
  0x0B, 0xC0, 0x47, 0x10, 0x5C, 0x0A, 0x70, 0x8C, 0x06, 0x71, 0x07, 0xC0, 0x87, 0x05, 0xC0, 0x97,
  0x10, 0xAC, 0x04, 0x71, 0x0E, 0xB0, 0xE7, 0x10, 0xEB, 0x0E, 0x72, 0x07, 0xC0, 0x86, 0x08, 0xC0,
  0x87, 0x30, 0xCC, 0x0A, 0x03, 0x20, 0x30, 0x9C, 0x0D, 0x74, 0x01, 0x0D, 0xFD, 0x0E, 0x03, 0x76,
  0x09, 0xFB, 0x0C, 0x02, 0x77, 0x0A, 0xA0, 0xC0, 0xEB, 0x81, 0xD9, 0x47, 0x71, 0x0C, 0xA0, 0x47,
  0x77, 0x10, 0xAA, 0x08, 0x77, 0x71, 0x03, 0xB0, 0x27, 0x77, 0x10, 0x8B, 0x01, 0x77, 0x71, 0x09,
  0xB0, 0x47, 0x77, 0x10, 0x7B, 0x81, 0xE5, 0x17, 0x76, 0x03, 0xFE, 0x82, 0xEB, 0x71, 0x73, 0x09,
  0xFF, 0xA0, 0x77, 0x30, 0x9F, 0xFA, 0x09, 0x71, 0x81, 0x17, 0xEF, 0xFA, 0x05, 0x60, 0x7F, 0xFD,
  0x0D, 0x50, 0xAB, 0x81, 0xE7, 0x27, 0x81, 0x15, 0xCD, 0x02, 0x30, 0x9B, 0x0D, 0x01, 0x75, 0x0B,
  0xC0, 0x62, 0x03, 0xC0, 0x27, 0x60, 0x3C, 0x08, 0x20, 0x9B, 0x0B, 0x77, 0x1C, 0x0A, 0x20, 0xCB,
  0x08, 0x77, 0x10, 0xDB, 0x09, 0x20, 0xEB, 0x07, 0x77, 0x10, 0xEB, 0x08, 0x20, 0xEB, 0x07, 0x77,
  0x01, 0xC0, 0x62, 0x0D, 0xB0, 0xA7, 0x70, 0x5C, 0x01, 0x20, 0xBB, 0x0E, 0x77, 0x0C, 0xB0, 0xB3,
  0x06, 0xC0, 0x77, 0x50, 0x7C, 0x03, 0x40, 0xEC, 0x05, 0x72, 0x01, 0x09, 0xC0, 0x95, 0x05, 0xD8,
  0x7B, 0x52, 0x11, 0x23, 0x6A, 0xD0, 0xA7, 0x06, 0xFF, 0xB0, 0x87, 0x20, 0x30, 0xCF, 0xE0, 0xA0,
  0x37, 0x58, 0x32, 0x7A, 0xDE, 0xA8, 0x4E, 0xDB, 0x85, 0x17, 0x20,
  // "h" (U+0068)
  0x01, 0xFA, 0x0C, 0x77, 0x70, 0x1F, 0xA0, 0xC7, 0x77, 0x01, 0xFA, 0x0C, 0x77, 0x71, 0x82, 0x13,
  0x7E, 0xD0, 0xC7, 0x77, 0x40, 0x2D, 0x0C, 0x77, 0x75, 0x0B, 0xC0, 0xC7, 0x77, 0x50, 0x9C, 0x0C,
  0x77, 0x75, 0x08, 0xC0, 0xC7, 0x77, 0x50, 0x8C, 0x0C, 0x77, 0x75, 0x08, 0xC0, 0xC7, 0x77, 0x50,
  0x8C, 0x0C, 0x77, 0x75, 0x08, 0xC0, 0xC7, 0x77, 0x50, 0x8C, 0x0C, 0x77, 0x75, 0x08, 0xC0, 0xC5,
  0x84, 0x36, 0x76, 0x51, 0x77, 0x10, 0x8C, 0x0C, 0x30, 0x40, 0xDE, 0x0B, 0x03, 0x76, 0x08, 0xC0,
  0xB2, 0x07, 0xFB, 0x06, 0x75, 0x08, 0xC8, 0x1B, 0x05, 0xFD, 0x04, 0x74, 0x08, 0xC0, 0xA0, 0x2A,
  0x83, 0xE9, 0x89, 0xCE, 0x0D, 0x74, 0x08, 0xC8, 0x29, 0xAF, 0x85, 0x03, 0x0E, 0xD0, 0x57, 0x30,
  0x8C, 0x81, 0xCF, 0x87, 0x04, 0xD0, 0xA7, 0x30, 0x8D, 0x0E, 0x72, 0x0C, 0xC0, 0xE7, 0x30, 0x8D,
  0x08, 0x72, 0x07, 0xD0, 0x17, 0x20, 0x8D, 0x04, 0x72, 0x03, 0xD0, 0x37, 0x20, 0x8D, 0x01, 0x72,
  0x01, 0xD0, 0x47, 0x20, 0x8C, 0x0E, 0x74, 0xD0, 0x57, 0x20, 0x8C, 0x0D, 0x74, 0xD0, 0x57, 0x20,
  0x8C, 0x0C, 0x74, 0xD0, 0x57, 0x20, 0x8C, 0x0C, 0x74, 0xD0, 0x57, 0x20, 0x8C, 0x0C, 0x74, 0xD0,
  0x57, 0x20, 0x8C, 0x0C, 0x74, 0xD0, 0x57, 0x20, 0x8C, 0x0C, 0x74, 0xD0, 0x57, 0x20, 0x8C, 0x0C,
  0x74, 0xD0, 0x57, 0x20, 0x8C, 0x0C, 0x74, 0xD0, 0x57, 0x20, 0x8C, 0x0C, 0x74, 0xD0, 0x57, 0x20,
  0x8C, 0x0C, 0x74, 0xD0, 0x57, 0x20, 0x8C, 0x0C, 0x74, 0xD0, 0x57, 0x20, 0x8C, 0x0C, 0x74, 0xD0,
  0x57, 0x20, 0x8C, 0x0C, 0x74, 0xD0, 0x57, 0x20, 0x8C, 0x0C, 0x74, 0xD0, 0x57, 0x20, 0x9C, 0x0C,
  0x74, 0xD0, 0x67, 0x20, 0xBC, 0x0E, 0x74, 0xD0, 0x87, 0x10, 0x2E, 0x04, 0x73, 0xD0, 0xD5, 0x82,
  0x13, 0x7E, 0xE8, 0x2E, 0x83, 0x17, 0xE8, 0x3C, 0x52, 0x01, 0xFF, 0x7F, 0xA0, 0x50, 0x1F, 0xF7,
  0xFA, 0x05, 0x01, 0xFF, 0x7F, 0xA0, 0x50,
  // "i" (U+0069)
  0x58, 0x37, 0xDE, 0xB3, 0x72, 0x06, 0xD0, 0x17, 0x10, 0xAD, 0x06, 0x71, 0x0B, 0xD0, 0x77, 0x10,
  0xAD, 0x06, 0x71, 0x06, 0xD0, 0x17, 0x28, 0x37, 0xDE, 0xC3, 0x80, 0x9D, 0x20, 0x07, 0xFA, 0x03,
  0x40, 0x7F, 0xA0, 0x34, 0x07, 0xFA, 0x03, 0x58, 0x12, 0x4A, 0xE0, 0x37, 0x10, 0x9D, 0x03, 0x71,
  0x04, 0xD0, 0x37, 0x10, 0x2D, 0x03, 0x71, 0x01, 0xD0, 0x37, 0x10, 0x1D, 0x03, 0x71, 0x01, 0xD0,
  0x37, 0x10, 0x1D, 0x03, 0x71, 0x01, 0xD0, 0x37, 0x10, 0x1D, 0x03, 0x71, 0x01, 0xD0, 0x37, 0x10,
  0x1D, 0x03, 0x71, 0x01, 0xD0, 0x37, 0x10, 0x1D, 0x03, 0x71, 0x01, 0xD0, 0x37, 0x10, 0x1D, 0x03,
  0x71, 0x01, 0xD0, 0x37, 0x10, 0x1D, 0x03, 0x71, 0x01, 0xD0, 0x37, 0x10, 0x1D, 0x03, 0x71, 0x01,
  0xD0, 0x37, 0x10, 0x1D, 0x03, 0x71, 0x02, 0xD0, 0x47, 0x10, 0x4D, 0x06, 0x71, 0x09, 0xD0, 0xC4,
  0x82, 0x12, 0x4A, 0xF8, 0x3C, 0x52, 0x1D, 0xFE, 0x0E, 0x0D, 0xFE, 0x0E, 0x0D, 0xFE, 0x0E,
  // "j" (U+006A)
  0x78, 0x38, 0xDE, 0xB3, 0x70, 0x8C, 0x0E, 0x01, 0x60, 0xDD, 0x05, 0x60, 0xED, 0x06, 0x60, 0xDD,
  0x05, 0x60, 0x8C, 0x0E, 0x01, 0x78, 0x38, 0xDE, 0xB3, 0x80, 0x9B, 0x20, 0x08, 0xFA, 0x01, 0x20,
  0x8F, 0xA0, 0x12, 0x08, 0xFA, 0x01, 0x38, 0x12, 0x5B, 0xE0, 0x16, 0x0B, 0xD0, 0x16, 0x05, 0xD0,
  0x16, 0x03, 0xD0, 0x16, 0x02, 0xD0, 0x16, 0x02, 0xD0, 0x16, 0x02, 0xD0, 0x16, 0x02, 0xD0, 0x16,
  0x02, 0xD0, 0x16, 0x02, 0xD0, 0x16, 0x02, 0xD0, 0x16, 0x02, 0xD0, 0x16, 0x02, 0xD0, 0x16, 0x02,
  0xD0, 0x16, 0x02, 0xD0, 0x16, 0x02, 0xD0, 0x16, 0x02, 0xD0, 0x16, 0x02, 0xD0, 0x16, 0x02, 0xD0,
  0x16, 0x02, 0xD0, 0x16, 0x02, 0xD0, 0x16, 0x02, 0xD0, 0x16, 0x02, 0xD0, 0x16, 0x02, 0xD0, 0x16,
  0x02, 0xD0, 0x16, 0x02, 0xD0, 0x16, 0x02, 0xD0, 0x16, 0x02, 0xD0, 0x16, 0x02, 0xD0, 0x16, 0x03,
  0xD0, 0x16, 0x03, 0xD7, 0x03, 0xD7, 0x05, 0xC0, 0xE7, 0x06, 0xC0, 0xC7, 0x09, 0xC0, 0x97, 0x0C,
  0xC0, 0x66, 0x02, 0xD0, 0x16, 0x09, 0xC0, 0xB6, 0x05, 0xD0, 0x33, 0x81, 0x24, 0xBD, 0x09, 0x30,
  0x5F, 0x0A, 0x40, 0x5D, 0x0E, 0x07, 0x58, 0x45, 0xFE, 0xDA, 0x57,
  // "k" (U+006B)
  0x01, 0xFA, 0x0C, 0x77, 0x60, 0x1F, 0xA0, 0xC7, 0x76, 0x01, 0xFA, 0x0C, 0x77, 0x78, 0x21, 0x37,
  0xED, 0x0C, 0x77, 0x73, 0x02, 0xD0, 0xC7, 0x77, 0x40, 0xBC, 0x0C, 0x77, 0x74, 0x09, 0xC0, 0xC7,
  0x77, 0x40, 0x8C, 0x0C, 0x77, 0x74, 0x08, 0xC0, 0xC7, 0x77, 0x40, 0x8C, 0x0C, 0x77, 0x74, 0x08,
  0xC0, 0xC7, 0x77, 0x40, 0x8C, 0x0C, 0x77, 0x74, 0x08, 0xC0, 0xC7, 0x77, 0x40, 0x8C, 0x0C, 0x77,
  0x74, 0x08, 0xC0, 0xC6, 0x0C, 0xFB, 0x09, 0x70, 0x8C, 0x0C, 0x60, 0xCF, 0xB0, 0x97, 0x08, 0xC0,
  0xC6, 0x0C, 0xFB, 0x09, 0x70, 0x8C, 0x0C, 0x68, 0x11, 0x3B, 0xE8, 0x19, 0x31, 0x70, 0x8C, 0x0C,
  0x71, 0x04, 0xC0, 0xE0, 0x37, 0x30, 0x8C, 0x0C, 0x71, 0x07, 0xB0, 0xD0, 0x27, 0x40, 0x8C, 0x0C,
  0x71, 0x0D, 0xA0, 0xE0, 0x27, 0x50, 0x8C, 0x0C, 0x70, 0x6B, 0x03, 0x76, 0x08, 0xC0, 0xC6, 0x02,
  0x0E, 0xA0, 0x67, 0x70, 0x8C, 0x0C, 0x60, 0xCA, 0x09, 0x77, 0x10, 0x8C, 0x0C, 0x50, 0x9A, 0x0C,
  0x77, 0x20, 0x8C, 0x0C, 0x40, 0x6A, 0x0E, 0x02, 0x77, 0x20, 0x8C, 0x0B, 0x30, 0x3B, 0x04, 0x77,
  0x30, 0x8C, 0x0B, 0x20, 0x10, 0xDB, 0x07, 0x77, 0x30, 0x8C, 0x0B, 0x20, 0xBC, 0x0E, 0x01, 0x77,
  0x20, 0x8C, 0x81, 0xA0, 0x7E, 0x0A, 0x77, 0x20, 0x8C, 0x0A, 0x04, 0xA0, 0xBD, 0x03, 0x77, 0x10,
  0x8C, 0x83, 0xBE, 0xF5, 0x1D, 0x0C, 0x77, 0x10, 0x8E, 0x06, 0x20, 0x8D, 0x06, 0x77, 0x08, 0xD0,
  0x73, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x60, 0x8C, 0x0C, 0x50, 0x7D, 0x09, 0x76, 0x08, 0xC0, 0xC6,
  0x0E, 0xD0, 0x37, 0x50, 0x8C, 0x0C, 0x60, 0x7D, 0x0C, 0x75, 0x08, 0xC0, 0xC7, 0x0D, 0xD0, 0x57,
  0x40, 0x8C, 0x0C, 0x70, 0x6D, 0x0E, 0x01, 0x73, 0x09, 0xC0, 0xC7, 0x10, 0xDD, 0x09, 0x73, 0x0B,
  0xC0, 0xE7, 0x10, 0x5E, 0x05, 0x71, 0x02, 0xE0, 0x47, 0x10, 0xBE, 0x04, 0x48, 0x21, 0x37, 0xEE,
  0x82, 0xE8, 0x31, 0x50, 0x20, 0xEE, 0x82, 0x82, 0x01, 0xFF, 0x01, 0x50, 0x5F, 0x90, 0x70, 0x1F,
  0xF0, 0x16, 0x06, 0xF0, 0x70, 0x1F, 0xF0, 0x17, 0x83, 0x17, 0xBD, 0xEA, 0x07,
  // "l" (U+006C)
  0x04, 0xFA, 0x0C, 0x50, 0x4F, 0xA0, 0xC5, 0x04, 0xFA, 0x0C, 0x68, 0x21, 0x37, 0xED, 0x0C, 0x72,
  0x02, 0xD0, 0xC7, 0x30, 0xBC, 0x0C, 0x73, 0x09, 0xC0, 0xC7, 0x30, 0x8C, 0x0C, 0x73, 0x08, 0xC0,
  0xC7, 0x30, 0x8C, 0x0C, 0x73, 0x08, 0xC0, 0xC7, 0x30, 0x8C, 0x0C, 0x73, 0x08, 0xC0, 0xC7, 0x30,
  0x8C, 0x0C, 0x73, 0x08, 0xC0, 0xC7, 0x30, 0x8C, 0x0C, 0x73, 0x08, 0xC0, 0xC7, 0x30, 0x8C, 0x0C,
  0x73, 0x08, 0xC0, 0xC7, 0x30, 0x8C, 0x0C, 0x73, 0x08, 0xC0, 0xC7, 0x30, 0x8C, 0x0C, 0x73, 0x08,
  0xC0, 0xC7, 0x30, 0x8C, 0x0C, 0x73, 0x08, 0xC0, 0xC7, 0x30, 0x8C, 0x0C, 0x73, 0x08, 0xC0, 0xC7,
  0x30, 0x8C, 0x0C, 0x73, 0x08, 0xC0, 0xC7, 0x30, 0x8C, 0x0C, 0x73, 0x08, 0xC0, 0xC7, 0x30, 0x8C,
  0x0C, 0x73, 0x08, 0xC0, 0xC7, 0x30, 0x8C, 0x0C, 0x73, 0x08, 0xC0, 0xC7, 0x30, 0x8C, 0x0C, 0x73,
  0x08, 0xC0, 0xC7, 0x30, 0x8C, 0x0C, 0x73, 0x08, 0xC0, 0xC7, 0x30, 0x9C, 0x0D, 0x73, 0x0B, 0xD7,
  0x20, 0x2E, 0x06, 0x58, 0x21, 0x37, 0xEF, 0x83, 0x93, 0x10, 0x4F, 0xF0, 0x80, 0x4F, 0xF0, 0x80,
  0x4F, 0xF0, 0x80,
  // "m" (U+006D)
  0x77, 0x18, 0x41, 0x57, 0x75, 0x27, 0x38, 0x42, 0x57, 0x65, 0x17, 0x30, 0x2F, 0x90, 0x53, 0x02,
  0x0B, 0xE0, 0xB0, 0x26, 0x05, 0x0C, 0xE0, 0xB0, 0x37, 0x10, 0x2F, 0x90, 0x72, 0x04, 0x0E, 0xFA,
  0x04, 0x40, 0x8F, 0xB0, 0x57, 0x02, 0xF9, 0x82, 0x90, 0x2E, 0xFB, 0x0E, 0x02, 0x20, 0x7F, 0xD0,
  0x37, 0x81, 0x24, 0xAD, 0x81, 0xC0, 0xBA, 0x82, 0xB8, 0x8A, 0xE8, 0x1A, 0x02, 0xB8, 0x2A, 0x88,
  0xBE, 0x0D, 0x73, 0x09, 0xC8, 0x3E, 0x3F, 0xD2, 0x40, 0x20, 0xDD, 0x83, 0x29, 0xFC, 0x24, 0x03,
  0x0D, 0xD0, 0x47, 0x20, 0x4D, 0x81, 0xBF, 0x36, 0x02, 0xD8, 0x29, 0xFE, 0x16, 0x03, 0xD0, 0xA7,
  0x20, 0x2E, 0x08, 0x71, 0x0A, 0xE0, 0x67, 0x10, 0xCC, 0x0D, 0x72, 0x01, 0xE0, 0x27, 0x10, 0x5D,
  0x0E, 0x72, 0x07, 0xD7, 0x20, 0x1D, 0x0C, 0x72, 0x02, 0xD0, 0xB7, 0x20, 0x3D, 0x02, 0x71, 0x01,
  0xD0, 0x97, 0x3D, 0x08, 0x72, 0x01, 0xD0, 0x37, 0x10, 0x1D, 0x06, 0x73, 0xD0, 0x77, 0x3D, 0x04,
  0x71, 0x01, 0xD0, 0x57, 0x30, 0xEC, 0x06, 0x73, 0xD0, 0x47, 0x10, 0x1D, 0x04, 0x73, 0x0E, 0xC0,
  0x57, 0x3D, 0x04, 0x71, 0x01, 0xD0, 0x47, 0x30, 0xEC, 0x05, 0x73, 0xD0, 0x47, 0x10, 0x1D, 0x04,
  0x73, 0x0E, 0xC0, 0x57, 0x3D, 0x04, 0x71, 0x01, 0xD0, 0x47, 0x30, 0xEC, 0x05, 0x73, 0xD0, 0x47,
  0x10, 0x1D, 0x04, 0x73, 0x0E, 0xC0, 0x57, 0x3D, 0x04, 0x71, 0x01, 0xD0, 0x47, 0x30, 0xEC, 0x05,
  0x73, 0xD0, 0x47, 0x10, 0x1D, 0x04, 0x73, 0x0E, 0xC0, 0x57, 0x3D, 0x04, 0x71, 0x01, 0xD0, 0x47,
  0x30, 0xEC, 0x05, 0x73, 0xD0, 0x47, 0x10, 0x1D, 0x04, 0x73, 0x0E, 0xC0, 0x57, 0x3D, 0x04, 0x71,
  0x01, 0xD0, 0x47, 0x30, 0xEC, 0x05, 0x73, 0xD0, 0x47, 0x10, 0x1D, 0x04, 0x73, 0x0E, 0xC0, 0x57,
  0x3D, 0x04, 0x71, 0x01, 0xD0, 0x47, 0x30, 0xEC, 0x05, 0x73, 0xD0, 0x47, 0x10, 0x1D, 0x04, 0x73,
  0x0E, 0xC0, 0x57, 0x3D, 0x04, 0x71, 0x02, 0xD0, 0x47, 0x30, 0xEC, 0x06, 0x73, 0xD0, 0x57, 0x10,
  0x4D, 0x06, 0x73, 0x0E, 0xC0, 0x87, 0x3D, 0x07, 0x71, 0x09, 0xD0, 0xB7, 0x30, 0xEC, 0x0D, 0x73,
  0xD0, 0xC5, 0x81, 0x14, 0xAF, 0x81, 0xB5, 0x27, 0x0E, 0xD8, 0x1C, 0x52, 0x7E, 0x83, 0xC5, 0x20,
  0xAF, 0xE0, 0x76, 0x0E, 0xF9, 0x05, 0x6F, 0xA0, 0x50, 0xAF, 0xE0, 0x76, 0x0E, 0xF9, 0x05, 0x6F,
  0xA0, 0x50, 0xAF, 0xE0, 0x76, 0x0E, 0xF9, 0x05, 0x6F, 0xA0, 0x50,
  // "n" (U+006E)
  0x77, 0x18, 0x41, 0x57, 0x75, 0x37, 0x30, 0x5F, 0x90, 0x63, 0x02, 0x0A, 0xE0, 0xE0, 0x67, 0x10,
  0x5F, 0x90, 0x82, 0x04, 0x0E, 0xFA, 0x0B, 0x70, 0x5F, 0x98, 0x2A, 0x02, 0xEF, 0xC0, 0xA7, 0x81,
  0x24, 0xAD, 0x81, 0xC0, 0xBA, 0x83, 0xB8, 0x8A, 0xEE, 0x04, 0x72, 0x0A, 0xC8, 0x3E, 0x3F, 0xD3,
  0x50, 0xAD, 0x0B, 0x72, 0x04, 0xD8, 0x1C, 0xE2, 0x70, 0xCD, 0x01, 0x71, 0x02, 0xE0, 0x77, 0x10,
  0x5D, 0x05, 0x71, 0x01, 0xE0, 0x17, 0x2D, 0x08, 0x71, 0x01, 0xD0, 0xB7, 0x30, 0xCC, 0x0A, 0x71,
  0x01, 0xD0, 0x87, 0x30, 0xAC, 0x0A, 0x71, 0x01, 0xD0, 0x57, 0x30, 0x9C, 0x0B, 0x71, 0x01, 0xD0,
  0x47, 0x30, 0x8C, 0x0C, 0x71, 0x01, 0xD0, 0x37, 0x30, 0x8C, 0x0C, 0x71, 0x01, 0xD0, 0x37, 0x30,
  0x8C, 0x0C, 0x71, 0x01, 0xD0, 0x37, 0x30, 0x8C, 0x0C, 0x71, 0x01, 0xD0, 0x37, 0x30, 0x8C, 0x0C,
  0x71, 0x01, 0xD0, 0x37, 0x30, 0x8C, 0x0C, 0x71, 0x01, 0xD0, 0x37, 0x30, 0x8C, 0x0C, 0x71, 0x01,
  0xD0, 0x37, 0x30, 0x8C, 0x0C, 0x71, 0x01, 0xD0, 0x37, 0x30, 0x8C, 0x0C, 0x71, 0x01, 0xD0, 0x37,
  0x30, 0x8C, 0x0C, 0x71, 0x01, 0xD0, 0x37, 0x30, 0x8C, 0x0C, 0x71, 0x01, 0xD0, 0x37, 0x30, 0x8C,
  0x0C, 0x71, 0x01, 0xD0, 0x37, 0x30, 0x8C, 0x0C, 0x71, 0x01, 0xD0, 0x37, 0x30, 0x8C, 0x0C, 0x71,
  0x02, 0xD0, 0x37, 0x30, 0x8C, 0x0C, 0x71, 0x04, 0xD0, 0x57, 0x30, 0x8C, 0x0E, 0x71, 0x0A, 0xD0,
  0xA7, 0x30, 0x8D, 0x04, 0x48, 0x12, 0x4B, 0xF8, 0x1B, 0x42, 0x70, 0x8D, 0x83, 0xE7, 0x31, 0xAF,
  0xE0, 0x76, 0x08, 0xF9, 0x0C, 0x0A, 0xFE, 0x07, 0x60, 0x8F, 0x90, 0xC0, 0xAF, 0xE0, 0x76, 0x08,
  0xF9, 0x0C,
  // "o" (U+006F)
  0x72, 0x85, 0x14, 0x67, 0x76, 0x47, 0x73, 0x05, 0x0C, 0xF9, 0x0A, 0x03, 0x75, 0x02, 0x0C, 0xFD,
  0x09, 0x73, 0x03, 0x0E, 0xD8, 0x2B, 0x9A, 0xCD, 0x0C, 0x01, 0x70, 0x20, 0xEC, 0x0A, 0x01, 0x40,
  0x20, 0xBC, 0x0C, 0x70, 0xBC, 0x09, 0x71, 0x0B, 0xC0, 0x85, 0x04, 0xC0, 0xE0, 0x17, 0x10, 0x2D,
  0x01, 0x40, 0xBC, 0x08, 0x73, 0x0A, 0xC0, 0x83, 0x01, 0xD0, 0x27, 0x30, 0x4C, 0x0E, 0x30, 0x6C,
  0x0E, 0x75, 0xD0, 0x32, 0x09, 0xC0, 0xB7, 0x50, 0xDC, 0x07, 0x20, 0xCC, 0x08, 0x75, 0x0A, 0xC0,
  0xA2, 0x0E, 0xC0, 0x67, 0x50, 0x8C, 0x81, 0xD0, 0x1D, 0x05, 0x75, 0x07, 0xC8, 0x1E, 0x02, 0xD0,
  0x47, 0x50, 0x6D, 0x10, 0x3D, 0x04, 0x75, 0x06, 0xD0, 0x10, 0x3D, 0x03, 0x75, 0x05, 0xD0, 0x10,
  0x3D, 0x03, 0x75, 0x05, 0xD0, 0x10, 0x3D, 0x04, 0x75, 0x06, 0xD0, 0x10, 0x2D, 0x04, 0x75, 0x06,
  0xD1, 0x01, 0xD0, 0x57, 0x50, 0x7C, 0x0E, 0x20, 0xEC, 0x07, 0x75, 0x09, 0xC0, 0xD2, 0x0C, 0xC0,
  0x87, 0x50, 0xAC, 0x0A, 0x20, 0x9C, 0x0B, 0x75, 0x0D, 0xC0, 0x72, 0x05, 0xC0, 0xE7, 0x40, 0x1D,
  0x04, 0x20, 0x1D, 0x03, 0x73, 0x05, 0xC0, 0xE4, 0x0A, 0xC0, 0x97, 0x30, 0xAC, 0x09, 0x40, 0x3C,
  0x0E, 0x01, 0x71, 0x02, 0xD0, 0x25, 0x09, 0xC0, 0xA7, 0x10, 0xBC, 0x09, 0x70, 0xDC, 0x0B, 0x02,
  0x40, 0x20, 0xBC, 0x0D, 0x71, 0x01, 0x0D, 0xD8, 0x2C, 0x99, 0xCD, 0x0D, 0x02, 0x72, 0x01, 0x0B,
  0xFD, 0x0B, 0x01, 0x75, 0x04, 0x0B, 0xF9, 0x0B, 0x04, 0x77, 0x28, 0x51, 0x46, 0x77, 0x64, 0x73,
  // "p" (U+0070)
  0x77, 0x28, 0x44, 0x67, 0x64, 0x17, 0x04, 0xF9, 0x0E, 0x40, 0x70, 0xEE, 0x0A, 0x02, 0x50, 0x4F,
  0xA0, 0x12, 0x0B, 0xFB, 0x07, 0x40, 0x4F, 0xA8, 0x13, 0x0A, 0xA8, 0x2D, 0xA9, 0xBE, 0x07, 0x48,
  0x21, 0x37, 0xED, 0x83, 0x46, 0xFE, 0x44, 0x01, 0x0A, 0xD0, 0x46, 0x02, 0xD8, 0x27, 0xEE, 0x27,
  0x0B, 0xC0, 0xD7, 0x0B, 0xE0, 0x77, 0x10, 0x2D, 0x05, 0x60, 0x9E, 0x73, 0x0B, 0xC0, 0xB6, 0x09,
  0xD0, 0xB7, 0x30, 0x6D, 0x60, 0x9D, 0x07, 0x73, 0x02, 0xD0, 0x45, 0x09, 0xD0, 0x47, 0x4D, 0x07,
  0x50, 0x9D, 0x01, 0x74, 0x0D, 0xC0, 0x95, 0x09, 0xD7, 0x50, 0xBC, 0x0B, 0x50, 0x9C, 0x0E, 0x75,
  0x0A, 0xC0, 0xD5, 0x09, 0xC0, 0xD7, 0x50, 0x9C, 0x0E, 0x50, 0x9C, 0x0C, 0x75, 0x09, 0xC0, 0xE5,
  0x09, 0xC0, 0xC7, 0x50, 0x8D, 0x50, 0x9C, 0x0C, 0x75, 0x08, 0xD5, 0x09, 0xC0, 0xD7, 0x50, 0x9C,
  0x0E, 0x50, 0x9C, 0x0D, 0x75, 0x09, 0xC0, 0xE5, 0x09, 0xC0, 0xE7, 0x50, 0xAC, 0x0D, 0x50, 0x9D,
  0x75, 0x0C, 0xC0, 0xB5, 0x09, 0xD0, 0x27, 0x40, 0xDC, 0x09, 0x50, 0x9D, 0x04, 0x73, 0x01, 0xD0,
  0x75, 0x09, 0xD0, 0x77, 0x30, 0x3D, 0x04, 0x50, 0x9D, 0x0B, 0x73, 0x07, 0xD6, 0x09, 0xE0, 0x17,
  0x20, 0xCC, 0x0A, 0x60, 0x9E, 0x07, 0x71, 0x03, 0xD0, 0x56, 0x09, 0xC8, 0x2C, 0xFE, 0x27, 0x0C,
  0xC0, 0xD7, 0x09, 0xC8, 0x3A, 0x8F, 0xE5, 0x40, 0x10, 0xBD, 0x04, 0x70, 0x9C, 0x81, 0xB0, 0xCA,
  0x82, 0xDA, 0x9B, 0xE0, 0x67, 0x10, 0x9C, 0x82, 0xB0, 0x1C, 0xFB, 0x06, 0x72, 0x09, 0xC0, 0xB3,
  0x08, 0x0E, 0xD8, 0x1E, 0xA2, 0x73, 0x09, 0xC0, 0xC5, 0x83, 0x46, 0x76, 0x47, 0x60, 0x9C, 0x0C,
  0x77, 0x72, 0x09, 0xC0, 0xC7, 0x77, 0x20, 0x9C, 0x0C, 0x77, 0x72, 0x09, 0xC0, 0xC7, 0x77, 0x20,
  0x9C, 0x0C, 0x77, 0x72, 0x09, 0xC0, 0xC7, 0x77, 0x20, 0x9C, 0x0C, 0x77, 0x72, 0x0C, 0xC0, 0xE7,
  0x77, 0x10, 0x3E, 0x04, 0x77, 0x48, 0x21, 0x38, 0xEE, 0x82, 0xE8, 0x31, 0x77, 0x01, 0xFF, 0x09,
  0x76, 0x01, 0xFF, 0x09, 0x76, 0x01, 0xFF, 0x09, 0x76,
  // "q" (U+0071)
  0x71, 0x84, 0x14, 0x67, 0x63, 0x77, 0x70, 0x40, 0xBE, 0x0E, 0x06, 0x40, 0xCF, 0x0D, 0x50, 0x9F,
  0xB0, 0xA3, 0xF9, 0x0D, 0x40, 0xBD, 0x83, 0xDA, 0x9B, 0xEA, 0x81, 0xA0, 0x3F, 0x90, 0xD3, 0x08,
  0xD0, 0x64, 0x01, 0x08, 0xA0, 0x06, 0xD8, 0x2C, 0x62, 0x12, 0x02, 0xD0, 0x67, 0x82, 0x6F, 0xEB,
  0xC0, 0xD6, 0x0A, 0xC0, 0xC7, 0x20, 0xCE, 0x07, 0x6D, 0x06, 0x72, 0x05, 0xE0, 0x55, 0x05, 0xD0,
  0x17, 0x30, 0xED, 0x04, 0x50, 0x9C, 0x0D, 0x74, 0x0B, 0xD0, 0x45, 0x0C, 0xC0, 0xA7, 0x40, 0x8D,
  0x04, 0x50, 0xEC, 0x08, 0x74, 0x05, 0xD0, 0x44, 0x01, 0xD0, 0x67, 0x40, 0x3D, 0x04, 0x40, 0x2D,
  0x05, 0x74, 0x02, 0xD0, 0x44, 0x03, 0xD0, 0x47, 0x40, 0x1D, 0x04, 0x40, 0x4D, 0x04, 0x75, 0xD0,
  0x44, 0x04, 0xD0, 0x37, 0x5D, 0x04, 0x40, 0x4D, 0x03, 0x75, 0xD0, 0x44, 0x04, 0xD0, 0x37, 0x5D,
  0x04, 0x40, 0x3D, 0x04, 0x74, 0x01, 0xD0, 0x44, 0x02, 0xD0, 0x57, 0x40, 0x2D, 0x04, 0x40, 0x1D,
  0x06, 0x74, 0x03, 0xD0, 0x45, 0x0E, 0xC0, 0x87, 0x40, 0x5D, 0x04, 0x50, 0xCC, 0x0A, 0x74, 0x07,
  0xD0, 0x45, 0x09, 0xC0, 0xD7, 0x40, 0xBD, 0x04, 0x50, 0x5D, 0x01, 0x73, 0x0E, 0xD0, 0x45, 0x01,
  0xD0, 0x67, 0x20, 0x5E, 0x04, 0x60, 0xAC, 0x0C, 0x72, 0x0C, 0xE0, 0x46, 0x03, 0xD0, 0x77, 0x82,
  0x7F, 0xAD, 0xC0, 0x47, 0x09, 0xD0, 0x74, 0x84, 0x18, 0xFE, 0x1E, 0xC0, 0x47, 0x10, 0xCD, 0x83,
  0xDA, 0x9B, 0xEA, 0x81, 0x50, 0xEC, 0x04, 0x71, 0x01, 0x0B, 0xFB, 0x06, 0x2D, 0x04, 0x73, 0x06,
  0x0C, 0xE0, 0xC0, 0x43, 0xD0, 0x47, 0x58, 0x42, 0x56, 0x76, 0x25, 0xD0, 0x47, 0x77, 0x2D, 0x04,
  0x77, 0x72, 0xD0, 0x47, 0x77, 0x2D, 0x04, 0x77, 0x72, 0xD0, 0x47, 0x77, 0x2D, 0x04, 0x77, 0x72,
  0xD0, 0x47, 0x77, 0x2D, 0x04, 0x77, 0x71, 0x03, 0xD0, 0x77, 0x77, 0x10, 0x9D, 0x0C, 0x77, 0x48,
  0x21, 0x25, 0xAF, 0x82, 0xC6, 0x21, 0x76, 0x09, 0xFF, 0x0B, 0x76, 0x09, 0xFF, 0x0B, 0x76, 0x09,
  0xFF, 0x0B,
  // "r" (U+0072)
  0x77, 0x18, 0x33, 0x57, 0x64, 0x30, 0x5F, 0x90, 0x13, 0x02, 0x0C, 0xD8, 0x2D, 0x40, 0x5F, 0x90,
  0x32, 0x03, 0x0E, 0xF9, 0x02, 0x05, 0xF9, 0x05, 0x20, 0xDF, 0xA8, 0x39, 0x02, 0x5B, 0xD8, 0x67,
  0x08, 0xFE, 0x98, 0xDD, 0x0C, 0x40, 0xAC, 0x83, 0xA1, 0xEE, 0x23, 0x0D, 0xC0, 0xB4, 0x04, 0xC8,
  0x2C, 0x7F, 0x54, 0x07, 0xC0, 0x74, 0x02, 0xC8, 0x1E, 0xED, 0x50, 0x4B, 0x0D, 0x01, 0x40, 0x1E,
  0x07, 0x58, 0x33, 0xEC, 0x81, 0x50, 0x1E, 0x02, 0x77, 0x10, 0x1D, 0x0E, 0x77, 0x20, 0x1D, 0x0B,
  0x77, 0x20, 0x1D, 0x08, 0x77, 0x20, 0x1D, 0x07, 0x77, 0x20, 0x1D, 0x05, 0x77, 0x20, 0x1D, 0x04,
  0x77, 0x20, 0x1D, 0x04, 0x77, 0x20, 0x1D, 0x04, 0x77, 0x20, 0x1D, 0x04, 0x77, 0x20, 0x1D, 0x04,
  0x77, 0x20, 0x1D, 0x04, 0x77, 0x20, 0x1D, 0x04, 0x77, 0x20, 0x1D, 0x04, 0x77, 0x20, 0x1D, 0x04,
  0x77, 0x20, 0x1D, 0x04, 0x77, 0x20, 0x1D, 0x04, 0x77, 0x20, 0x2D, 0x04, 0x77, 0x20, 0x4D, 0x06,
  0x77, 0x20, 0xAD, 0x0B, 0x76, 0x81, 0x25, 0xBF, 0x82, 0xB5, 0x21, 0x71, 0x06, 0xFF, 0x09, 0x70,
  0x6F, 0xF0, 0x97, 0x06, 0xFF, 0x09, 0x70,
  // "s" (U+0073)
  0x78, 0x53, 0x56, 0x76, 0x41, 0x73, 0x81, 0x29, 0xEF, 0x0C, 0x04, 0x70, 0x60, 0xEF, 0xC0, 0x85,
  0x07, 0xC8, 0x3E, 0xB9, 0xAD, 0xD0, 0x53, 0x02, 0xC0, 0xA0, 0x14, 0x05, 0xC0, 0xD3, 0x0A, 0xB0,
  0xC7, 0x06, 0xC0, 0x22, 0x0E, 0xB0, 0x67, 0x10, 0xEB, 0x81, 0x20, 0x2C, 0x03, 0x71, 0x0A, 0xA0,
  0xE2, 0x03, 0xC0, 0x27, 0x10, 0x7A, 0x06, 0x20, 0x2C, 0x04, 0x71, 0x81, 0x59, 0x33, 0x01, 0xC0,
  0x97, 0x71, 0x0D, 0xC0, 0x47, 0x70, 0x8D, 0x06, 0x76, 0x01, 0x0E, 0xD0, 0xC0, 0x37, 0x50, 0x4F,
  0x0B, 0x03, 0x74, 0x04, 0x0E, 0xF0, 0xB0, 0x37, 0x30, 0x20, 0xCF, 0x90, 0x97, 0x40, 0x60, 0xEF,
  0x0D, 0x02, 0x74, 0x07, 0x0E, 0xE0, 0xE0, 0x27, 0x40, 0x10, 0x8E, 0x0D, 0x76, 0x02, 0x0C, 0xD0,
  0x67, 0x70, 0xBC, 0x0C, 0x77, 0x10, 0xEC, 0x28, 0x11, 0x86, 0x73, 0x08, 0xC8, 0x31, 0x2E, 0xFA,
  0x73, 0x05, 0xC0, 0x20, 0xAA, 0x0C, 0x73, 0x05, 0xC0, 0x10, 0xDB, 0x01, 0x72, 0x07, 0xC1, 0x0D,
  0xB0, 0x77, 0x20, 0xBB, 0x81, 0xB0, 0xBB, 0x0E, 0x01, 0x70, 0x4C, 0x81, 0x50, 0x7C, 0x0D, 0x03,
  0x50, 0x50, 0xEB, 0x0C, 0x30, 0xDD, 0x83, 0xC9, 0x9A, 0xEC, 0x0E, 0x02, 0x30, 0x20, 0xDF, 0xD0,
  0xC0, 0x26, 0x06, 0x0D, 0xF9, 0x0C, 0x05, 0x73, 0x86, 0x14, 0x67, 0x76, 0x41, 0x70,
  // "t" (U+0074)
  0x60, 0x9A, 0x03, 0x76, 0x0C, 0xA0, 0x37, 0x6B, 0x03, 0x75, 0x04, 0xB0, 0x37, 0x50, 0x9B, 0x03,
  0x74, 0x01, 0xC0, 0x37, 0x40, 0xBC, 0x03, 0x73, 0x0A, 0xD0, 0x37, 0x81, 0x26, 0xDF, 0xD0, 0xE1,
  0xFF, 0x90, 0xE1, 0xFF, 0x98, 0x4E, 0x01, 0x11, 0x2D, 0x04, 0x80, 0x21, 0x40, 0x1D, 0x03, 0x73,
  0x01, 0xD0, 0x37, 0x30, 0x1D, 0x03, 0x73, 0x01, 0xD0, 0x37, 0x30, 0x1D, 0x03, 0x73, 0x01, 0xD0,
  0x37, 0x30, 0x1D, 0x03, 0x73, 0x01, 0xD0, 0x37, 0x30, 0x1D, 0x03, 0x73, 0x01, 0xD0, 0x37, 0x30,
  0x1D, 0x03, 0x73, 0x01, 0xD0, 0x37, 0x30, 0x1D, 0x03, 0x73, 0x01, 0xD0, 0x37, 0x30, 0x1D, 0x03,
  0x73, 0x01, 0xD0, 0x37, 0x30, 0x1D, 0x03, 0x73, 0x01, 0xD0, 0x37, 0x30, 0x1D, 0x03, 0x73, 0x01,
  0xD0, 0x37, 0x4D, 0x03, 0x74, 0xD0, 0x57, 0x40, 0xCC, 0x08, 0x74, 0x0A, 0xC0, 0xD7, 0x40, 0x5D,
  0x08, 0x74, 0x0D, 0xD8, 0x4D, 0x99, 0xAD, 0x65, 0x04, 0x0E, 0xFA, 0x06, 0x60, 0x30, 0xBF, 0x0E,
  0x04, 0x71, 0x85, 0x25, 0x77, 0x65, 0x22,
  // "u" (U+0075)
  0x0D, 0xF9, 0x0A, 0x60, 0x2F, 0xA0, 0x44, 0x0D, 0xF9, 0x0A, 0x60, 0x2F, 0xA0, 0x44, 0x0D, 0xF9,
  0x0A, 0x60, 0x2F, 0xA0, 0x44, 0x82, 0x13, 0x7E, 0xD0, 0xA7, 0x81, 0x24, 0xAE, 0x04, 0x70, 0x3D,
  0x0A, 0x73, 0x09, 0xD0, 0x47, 0x10, 0xCC, 0x0A, 0x73, 0x03, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x73,
  0x01, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10,
  0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0,
  0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A,
  0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10,
  0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x73, 0x01,
  0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x73, 0x01, 0xD0, 0x47, 0x10, 0x9C, 0x0B, 0x73, 0x03, 0xD0, 0x47,
  0x10, 0x9C, 0x0C, 0x73, 0x05, 0xD0, 0x47, 0x10, 0x8C, 0x0E, 0x73, 0x08, 0xD0, 0x47, 0x10, 0x6D,
  0x01, 0x72, 0x0D, 0xD0, 0x47, 0x10, 0x3D, 0x05, 0x71, 0x04, 0xE0, 0x57, 0x2D, 0x0C, 0x71, 0x81,
  0xDF, 0xEC, 0x07, 0x72, 0x0A, 0xD0, 0x95, 0x83, 0x2C, 0xFB, 0x9C, 0x0C, 0x72, 0x04, 0xE8, 0x3E,
  0xA8, 0x8B, 0xB0, 0x20, 0x7D, 0x81, 0xC5, 0x27, 0x0A, 0xFD, 0x81, 0x70, 0x4F, 0x90, 0x97, 0x0B,
  0xFB, 0x08, 0x20, 0x2F, 0x90, 0x97, 0x10, 0x60, 0xEE, 0x0C, 0x04, 0x4F, 0x90, 0x97, 0x38, 0x43,
  0x57, 0x75, 0x27, 0x71,
  // "v" (U+0076)
  0x0A, 0xFD, 0x05, 0x50, 0xEF, 0xA0, 0xB0, 0xAF, 0xD0, 0x55, 0x0E, 0xFA, 0x0B, 0x0A, 0xFD, 0x05,
  0x50, 0xEF, 0xA8, 0x2B, 0x13, 0x9F, 0x81, 0xB3, 0x16, 0x81, 0x12, 0x8D, 0x08, 0x02, 0x40, 0x9E,
  0x01, 0x74, 0x09, 0xB0, 0x96, 0x01, 0xD0, 0xD7, 0x50, 0x7B, 0x02, 0x70, 0xAC, 0x0E, 0x75, 0x08,
  0xA0, 0xB7, 0x10, 0x5D, 0x01, 0x74, 0x0B, 0xA0, 0x67, 0x10, 0x1D, 0x05, 0x74, 0xB0, 0x17, 0x20,
  0xBC, 0x0A, 0x73, 0x04, 0xA0, 0xB7, 0x30, 0x6C, 0x0E, 0x73, 0x09, 0xA0, 0x67, 0x30, 0x1D, 0x04,
  0x72, 0x0E, 0xA0, 0x17, 0x40, 0xCC, 0x09, 0x71, 0x03, 0xA0, 0xC7, 0x50, 0x7C, 0x0E, 0x71, 0x08,
  0xA0, 0x77, 0x50, 0x2D, 0x03, 0x70, 0xDA, 0x02, 0x76, 0x0D, 0xC0, 0x86, 0x02, 0xA0, 0xC7, 0x70,
  0x8C, 0x0D, 0x60, 0x7A, 0x07, 0x77, 0x03, 0xD0, 0x25, 0x0C, 0xA0, 0x27, 0x71, 0x0D, 0xC0, 0x74,
  0x02, 0xA0, 0xC7, 0x72, 0x09, 0xC0, 0xC4, 0x07, 0xA0, 0x77, 0x72, 0x04, 0xD0, 0x13, 0x0B, 0xA0,
  0x27, 0x73, 0x0E, 0xC0, 0x62, 0x01, 0xA0, 0xD7, 0x74, 0x09, 0xC0, 0xA2, 0x06, 0xA0, 0x77, 0x74,
  0x05, 0xC0, 0xE2, 0x0A, 0xA0, 0x27, 0x75, 0xD0, 0x21, 0xA0, 0xD7, 0x76, 0x0A, 0xC0, 0x60, 0x4A,
  0x08, 0x77, 0x60, 0x5C, 0x0A, 0x09, 0xA0, 0x37, 0x76, 0x01, 0xC8, 0x2E, 0xDF, 0xD7, 0x77, 0x10,
  0xBE, 0x08, 0x77, 0x71, 0x06, 0xE0, 0x37, 0x77, 0x10, 0x1D, 0x0D, 0x77, 0x73, 0x0C, 0xC0, 0x87,
  0x50,
  // "w" (U+0077)
  0x0E, 0xFC, 0x0D, 0x71, 0x0B, 0xA0, 0xB7, 0x10, 0xCF, 0xB0, 0x10, 0xEF, 0xC0, 0xD7, 0x1C, 0x71,
  0x0C, 0xFB, 0x01, 0x0E, 0xFC, 0x0D, 0x70, 0x4C, 0x04, 0x70, 0xCF, 0xB8, 0x21, 0x14, 0xBF, 0x81,
  0x62, 0x17, 0x09, 0xC0, 0x87, 0x81, 0x13, 0x8D, 0x81, 0xA3, 0x14, 0x0C, 0xD0, 0x77, 0x30, 0xDC,
  0x0D, 0x73, 0x09, 0xB0, 0xB7, 0x05, 0xD0, 0x57, 0x20, 0x2E, 0x01, 0x72, 0x05, 0xB0, 0x47, 0x1D,
  0x06, 0x72, 0x07, 0xE0, 0x67, 0x20, 0x5A, 0x0E, 0x72, 0x0B, 0xC0, 0x97, 0x28, 0x1B, 0xFE, 0xC0,
  0xA7, 0x20, 0x7A, 0x09, 0x72, 0x07, 0xC0, 0xD7, 0x10, 0x1A, 0x09, 0x0D, 0xB0, 0xE7, 0x20, 0xAA,
  0x05, 0x72, 0x03, 0xD0, 0x17, 0x05, 0xA0, 0x40, 0x9C, 0x03, 0x71, 0x0E, 0xA0, 0x17, 0x30, 0xEC,
  0x05, 0x70, 0x9A, 0x10, 0x5C, 0x07, 0x70, 0x3A, 0x0C, 0x74, 0x0B, 0xC0, 0x87, 0x83, 0xEF, 0xB0,
  0x1C, 0x0C, 0x70, 0x7A, 0x08, 0x74, 0x07, 0xC0, 0xC6, 0x03, 0xA0, 0x62, 0x0C, 0xC0, 0x16, 0x0B,
  0xA0, 0x47, 0x40, 0x2D, 0x60, 0x7A, 0x02, 0x20, 0x8C, 0x05, 0x60, 0xEA, 0x76, 0x0E, 0xC0, 0x35,
  0x81, 0xCF, 0xD3, 0x03, 0xC0, 0x95, 0x03, 0xA0, 0xB7, 0x60, 0xAC, 0x07, 0x40, 0x1A, 0x08, 0x40,
  0xEB, 0x0E, 0x50, 0x7A, 0x07, 0x76, 0x06, 0xC0, 0xA4, 0x06, 0xA0, 0x44, 0x0A, 0xC0, 0x24, 0x0C,
  0xA0, 0x37, 0x60, 0x2C, 0x0E, 0x48, 0x1A, 0xFE, 0x50, 0x6C, 0x07, 0x4A, 0x0E, 0x77, 0x10, 0xDC,
  0x02, 0x38, 0x1E, 0xFA, 0x50, 0x1C, 0x0B, 0x30, 0x4A, 0x0A, 0x77, 0x10, 0x9C, 0x05, 0x20, 0x3A,
  0x06, 0x60, 0xDC, 0x30, 0x8A, 0x05, 0x77, 0x10, 0x5C, 0x08, 0x20, 0x8A, 0x01, 0x60, 0x8C, 0x04,
  0x20, 0xCA, 0x01, 0x77, 0x10, 0x1C, 0x0B, 0x28, 0x1C, 0xFD, 0x70, 0x4C, 0x08, 0x2A, 0x0D, 0x77,
  0x30, 0xDB, 0x0E, 0x2A, 0x08, 0x71, 0xC8, 0x1B, 0x04, 0xA0, 0x87, 0x73, 0x09, 0xC0, 0x20, 0x4A,
  0x04, 0x71, 0x0B, 0xC1, 0x07, 0xA0, 0x47, 0x73, 0x05, 0xC8, 0x25, 0x8F, 0xE7, 0x20, 0x7C, 0x03,
  0x0A, 0xA7, 0x74, 0x01, 0xC8, 0x28, 0xBF, 0xA7, 0x20, 0x2C, 0x82, 0x6D, 0xFB, 0x77, 0x50, 0xCB,
  0x82, 0xBE, 0xF6, 0x73, 0x0D, 0xB0, 0xAA, 0x07, 0x77, 0x50, 0x8E, 0x01, 0x73, 0x09, 0xE0, 0x37,
  0x75, 0x04, 0xD0, 0xC7, 0x40, 0x5D, 0x0E, 0x77, 0x7D, 0x08, 0x74, 0x01, 0xD0, 0xA7, 0x77, 0x0B,
  0xC0, 0x37, 0x50, 0xCC, 0x06, 0x77, 0x70, 0x7B, 0x0E, 0x76, 0x08, 0xC0, 0x27, 0x40,
  // "x" (U+0078)
  0x10, 0xBF, 0xD0, 0xA2, 0x0C, 0xFB, 0x07, 0x20, 0xBF, 0xD0, 0xA2, 0x0C, 0xFB, 0x07, 0x20, 0xBF,
  0xD0, 0xA2, 0x0C, 0xFB, 0x07, 0x38, 0x12, 0x7E, 0xF0, 0x70, 0x23, 0x81, 0x12, 0x8D, 0x81, 0xC5,
  0x26, 0x02, 0x0D, 0xD0, 0xC7, 0x10, 0xEB, 0x0A, 0x73, 0x02, 0x0E, 0xC0, 0xD7, 0x10, 0xEA, 0x0C,
  0x75, 0x06, 0xD0, 0x56, 0x04, 0xA0, 0xE0, 0x27, 0x60, 0xBC, 0x0E, 0x01, 0x50, 0xCA, 0x06, 0x77,
  0x02, 0x0E, 0xC0, 0x94, 0x05, 0xA0, 0xB7, 0x72, 0x06, 0xD0, 0x33, 0x0D, 0xA0, 0x27, 0x73, 0x0C,
  0xC0, 0xC2, 0x07, 0xA0, 0x77, 0x74, 0x02, 0xD8, 0x36, 0x1E, 0xFC, 0x77, 0x60, 0x7C, 0x0E, 0x0A,
  0xA0, 0x37, 0x77, 0x0C, 0xE0, 0x87, 0x77, 0x10, 0x3D, 0x0D, 0x77, 0x73, 0x08, 0xD0, 0x37, 0x77,
  0x20, 0xAD, 0x0C, 0x77, 0x71, 0x05, 0xF0, 0x87, 0x76, 0x83, 0x1E, 0xFC, 0x6D, 0x03, 0x77, 0x50,
  0xBA, 0x81, 0x30, 0xBC, 0x0C, 0x77, 0x40, 0x6A, 0x09, 0x20, 0x2D, 0x08, 0x77, 0x28, 0x21, 0xEF,
  0xD4, 0x07, 0xD0, 0x37, 0x71, 0x0B, 0xA0, 0x55, 0x0D, 0xC0, 0xC7, 0x70, 0x6A, 0x0B, 0x60, 0x3D,
  0x08, 0x75, 0x02, 0x0E, 0xA0, 0x27, 0x09, 0xD0, 0x37, 0x40, 0xCA, 0x0A, 0x72, 0x0E, 0xC0, 0xC7,
  0x30, 0x9B, 0x05, 0x72, 0x09, 0xD0, 0x97, 0x10, 0x7C, 0x06, 0x72, 0x09, 0xE0, 0x74, 0x81, 0x25,
  0xBD, 0x81, 0xE5, 0x24, 0x81, 0x12, 0x7F, 0x98, 0x2A, 0x31, 0xAF, 0xC0, 0x93, 0x0C, 0xFD, 0x0D,
  0x0A, 0xFC, 0x09, 0x30, 0xCF, 0xD0, 0xD0, 0xAF, 0xC0, 0x93, 0x0C, 0xFD, 0x0D,
  // "y" (U+0079)
  0x0C, 0xFC, 0x0D, 0x50, 0x8F, 0xB0, 0x10, 0xCF, 0xC0, 0xD5, 0x08, 0xFB, 0x01, 0x0C, 0xFC, 0x0D,
  0x50, 0x8F, 0xB8, 0x21, 0x13, 0xBF, 0x81, 0x82, 0x16, 0x81, 0x25, 0xDC, 0x81, 0xD5, 0x24, 0x0C,
  0xD0, 0xB7, 0x40, 0x4C, 0x03, 0x60, 0x5D, 0x09, 0x74, 0x02, 0xB0, 0xA7, 0x10, 0xEC, 0x0B, 0x74,
  0x03, 0xB0, 0x47, 0x10, 0x8C, 0x0E, 0x74, 0x06, 0xA0, 0xE7, 0x20, 0x3D, 0x04, 0x73, 0x0B, 0xA0,
  0x97, 0x30, 0xDC, 0x09, 0x73, 0xB0, 0x47, 0x30, 0x7C, 0x0E, 0x72, 0x04, 0xA0, 0xE7, 0x40, 0x1D,
  0x04, 0x71, 0x09, 0xA0, 0xA7, 0x50, 0xBC, 0x09, 0x71, 0x0D, 0xA0, 0x57, 0x50, 0x6C, 0x0E, 0x70,
  0x2B, 0x77, 0xD0, 0x56, 0x06, 0xA0, 0xB7, 0x70, 0xAC, 0x0A, 0x60, 0xBA, 0x06, 0x77, 0x04, 0xC0,
  0xE6, 0xB0, 0x17, 0x71, 0x0E, 0xC0, 0x54, 0x04, 0xA0, 0xB7, 0x72, 0x09, 0xC0, 0xA4, 0x09, 0xA0,
  0x67, 0x72, 0x03, 0xD4, 0x0D, 0xA0, 0x17, 0x73, 0x0D, 0xC0, 0x42, 0x02, 0xA0, 0xC7, 0x74, 0x07,
  0xC0, 0x92, 0x06, 0xA0, 0x77, 0x74, 0x02, 0xC0, 0xD2, 0x0B, 0xA0, 0x27, 0x75, 0x0B, 0xC0, 0x31,
  0xA0, 0xD7, 0x76, 0x06, 0xC0, 0x70, 0x4A, 0x08, 0x77, 0x60, 0x1C, 0x0B, 0x07, 0xA0, 0x37, 0x77,
  0x0A, 0xB8, 0x2E, 0xBF, 0xD7, 0x77, 0x10, 0x5E, 0x09, 0x77, 0x72, 0x0E, 0xD0, 0x47, 0x77, 0x20,
  0x9C, 0x0E, 0x77, 0x73, 0x03, 0xC0, 0x97, 0x77, 0x40, 0xDB, 0x04, 0x77, 0x74, 0x0D, 0xA0, 0xE7,
  0x77, 0x40, 0x3B, 0x0A, 0x77, 0x74, 0x08, 0xB0, 0x57, 0x77, 0x40, 0xEA, 0x0E, 0x77, 0x74, 0x06,
  0xB0, 0x97, 0x77, 0x40, 0xDB, 0x03, 0x77, 0x73, 0x07, 0xB0, 0xD7, 0x77, 0x30, 0x3C, 0x06, 0x77,
  0x72, 0x03, 0x0E, 0xB0, 0xD7, 0x77, 0x20, 0x7D, 0x04, 0x77, 0x48, 0x31, 0x25, 0x9E, 0xD0, 0x97,
  0x74, 0x02, 0xFA, 0x09, 0x77, 0x50, 0x2F, 0x0D, 0x05, 0x77, 0x60, 0x2A, 0x83, 0xED, 0xB8, 0x47,
  0x77,
  // "z" (U+007A)
  0x10, 0xBF, 0xFD, 0x81, 0x50, 0xCF, 0xFD, 0x81, 0x50, 0xDE, 0x80, 0x3E, 0xE8, 0x14, 0x0E, 0xA8,
  0x1E, 0x61, 0x70, 0x3D, 0x0B, 0x2B, 0x06, 0x72, 0x0C, 0xD0, 0x32, 0xA0, 0xE7, 0x20, 0x5D, 0x09,
  0x20, 0x1A, 0x09, 0x72, 0x0D, 0xC0, 0xE0, 0x12, 0x02, 0xA0, 0x57, 0x10, 0x7D, 0x07, 0x38, 0x11,
  0x55, 0x71, 0x01, 0x0E, 0xC0, 0xD7, 0x71, 0x09, 0xD0, 0x57, 0x70, 0x3D, 0x0B, 0x77, 0x10, 0xBD,
  0x03, 0x77, 0x05, 0xD0, 0x97, 0x71, 0x0D, 0xC0, 0xE0, 0x17, 0x70, 0x7D, 0x07, 0x77, 0x01, 0x0E,
  0xC0, 0xD7, 0x71, 0x09, 0xD0, 0x57, 0x70, 0x2D, 0x0B, 0x77, 0x10, 0xBD, 0x03, 0x77, 0x04, 0xD0,
  0x97, 0x71, 0x0D, 0xC0, 0xE0, 0x17, 0x70, 0x6D, 0x07, 0x77, 0x01, 0x0E, 0xC0, 0xD7, 0x28, 0x16,
  0x96, 0x30, 0x8D, 0x05, 0x72, 0x81, 0xCF, 0xA2, 0x02, 0xD0, 0xB7, 0x3A, 0x0A, 0x20, 0xAD, 0x03,
  0x72, 0x03, 0xA8, 0x19, 0x04, 0xD0, 0x97, 0x30, 0x8A, 0x81, 0x90, 0xCC, 0x0E, 0x01, 0x72, 0x01,
  0x0E, 0xA0, 0x80, 0x6D, 0x07, 0x72, 0x03, 0x0C, 0xB0, 0x80, 0xED, 0x80, 0x5E, 0xE0, 0x8F, 0xFF,
  0x07, 0xFF, 0xF0, 0x70,
  // "{" (U+007B)
  0x73, 0x82, 0x49, 0xDE, 0xB0, 0xA7, 0x20, 0xBF, 0x0A, 0x71, 0x0B, 0xF9, 0x0A, 0x70, 0x6D, 0x82,
  0xD5, 0x21, 0x71, 0x0D, 0xC0, 0xE0, 0x17, 0x30, 0x3D, 0x07, 0x74, 0x06, 0xD0, 0x37, 0x40, 0x8D,
  0x75, 0x09, 0xC0, 0xE7, 0x50, 0x9C, 0x0E, 0x75, 0x09, 0xC0, 0xE7, 0x50, 0x9C, 0x0E, 0x75, 0x09,
  0xC0, 0xE7, 0x50, 0x9C, 0x0E, 0x75, 0x09, 0xC0, 0xE7, 0x50, 0x9C, 0x0E, 0x75, 0x09, 0xC0, 0xE7,
  0x50, 0x9C, 0x0E, 0x75, 0x09, 0xC0, 0xE7, 0x50, 0x9C, 0x0E, 0x75, 0x0A, 0xC0, 0xD7, 0x50, 0xCC,
  0x0B, 0x74, 0x01, 0xD0, 0x77, 0x40, 0x9D, 0x01, 0x73, 0x08, 0xD0, 0x77, 0x82, 0x36, 0x9E, 0xD0,
  0x87, 0x10, 0x9D, 0x81, 0xD9, 0x37, 0x20, 0x9D, 0x81, 0xEA, 0x37, 0x28, 0x21, 0x59, 0xED, 0x09,
  0x75, 0x09, 0xD0, 0x77, 0x50, 0x9D, 0x01, 0x74, 0x01, 0xD0, 0x77, 0x50, 0xCC, 0x0B, 0x75, 0x0A,
  0xC0, 0xD7, 0x50, 0x9C, 0x0E, 0x75, 0x09, 0xC0, 0xE7, 0x50, 0x9C, 0x0E, 0x75, 0x09, 0xC0, 0xE7,
  0x50, 0x9C, 0x0E, 0x75, 0x09, 0xC0, 0xE7, 0x50, 0x9C, 0x0E, 0x75, 0x09, 0xC0, 0xE7, 0x50, 0x9C,
  0x0E, 0x75, 0x09, 0xC0, 0xE7, 0x50, 0x9C, 0x0E, 0x75, 0x08, 0xC0, 0xE7, 0x50, 0x8D, 0x75, 0x06,
  0xD0, 0x37, 0x40, 0x3D, 0x07, 0x75, 0x0D, 0xC0, 0xE0, 0x17, 0x40, 0x6D, 0x82, 0xD5, 0x21, 0x72,
  0x0B, 0xF9, 0x0A, 0x72, 0x0A, 0xF0, 0xA7, 0x38, 0x24, 0x9D, 0xEB, 0x0A,
  // "|" (U+007C)
  0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE,
  0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE,
  0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE,
  0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE,
  0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE,
  0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE,
  0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE,
  0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE,
  // "}" (U+007D)
  0x09, 0xB8, 0x2E, 0xDA, 0x47, 0x30, 0x9F, 0x0B, 0x01, 0x71, 0x09, 0xF9, 0x0C, 0x72, 0x82, 0x11,
  0x5D, 0xD0, 0x77, 0x40, 0x10, 0xDC, 0x0E, 0x75, 0x07, 0xD0, 0x37, 0x40, 0x2D, 0x06, 0x75, 0xD0,
  0x87, 0x50, 0xEC, 0x09, 0x75, 0x0E, 0xC0, 0x97, 0x50, 0xEC, 0x09, 0x75, 0x0E, 0xC0, 0x97, 0x50,
  0xEC, 0x09, 0x75, 0x0E, 0xC0, 0x97, 0x50, 0xEC, 0x09, 0x75, 0x0E, 0xC0, 0x97, 0x50, 0xEC, 0x09,
  0x75, 0x0E, 0xC0, 0x97, 0x50, 0xEC, 0x09, 0x75, 0x0D, 0xC0, 0x97, 0x50, 0xDC, 0x0A, 0x75, 0x0B,
  0xC0, 0xD7, 0x50, 0x7D, 0x01, 0x74, 0x01, 0x0E, 0xC0, 0x97, 0x50, 0x7D, 0x09, 0x75, 0x07, 0xD8,
  0x2E, 0x96, 0x37, 0x28, 0x12, 0x9D, 0xD0, 0xA7, 0x28, 0x13, 0xAE, 0xD0, 0xA7, 0x10, 0x8D, 0x82,
  0xE9, 0x52, 0x70, 0x7D, 0x09, 0x73, 0x01, 0xD0, 0xA7, 0x40, 0x7D, 0x01, 0x74, 0x0B, 0xC0, 0xC7,
  0x50, 0xDC, 0x0A, 0x75, 0x0D, 0xC0, 0x97, 0x50, 0xEC, 0x09, 0x75, 0x0E, 0xC0, 0x97, 0x50, 0xEC,
  0x09, 0x75, 0x0E, 0xC0, 0x97, 0x50, 0xEC, 0x09, 0x75, 0x0E, 0xC0, 0x97, 0x50, 0xEC, 0x09, 0x75,
  0x0E, 0xC0, 0x97, 0x50, 0xEC, 0x09, 0x75, 0x0E, 0xC0, 0x97, 0x50, 0xEC, 0x09, 0x75, 0xD0, 0x87,
  0x40, 0x2D, 0x06, 0x74, 0x07, 0xD0, 0x37, 0x30, 0x10, 0xDC, 0x0D, 0x71, 0x82, 0x11, 0x5C, 0xD0,
  0x77, 0x09, 0xF9, 0x0C, 0x71, 0x09, 0xF0, 0xB7, 0x20, 0x9C, 0x81, 0xDA, 0x47, 0x30,
  // "~" (U+007E)
  0x77, 0x70, 0x01, 0x48, 0x12, 0xAE, 0xA0, 0xB0, 0x47, 0x30, 0x9A, 0x0B, 0x20, 0x20, 0xEE, 0x08,
  0x72, 0x0B, 0xA0, 0x82, 0x0B, 0xF9, 0x0A, 0x71, 0x0D, 0xA8, 0x16, 0x05, 0xB8, 0x27, 0x02, 0xAB,
  0x0B, 0x60, 0x1B, 0x81, 0x30, 0xAA, 0x0A, 0x40, 0x8B, 0x0B, 0x50, 0x5A, 0x0E, 0x2B, 0x04, 0x50,
  0x8B, 0x0B, 0x40, 0xBA, 0x81, 0x90, 0x3B, 0x70, 0x9B, 0x82, 0xC4, 0x18, 0xB8, 0x14, 0x07, 0xA0,
  0xC7, 0x10, 0xAF, 0x90, 0xA2, 0x09, 0xA0, 0xA7, 0x20, 0x8E, 0x0D, 0x01, 0x20, 0xBA, 0x08, 0x73,
  0x85, 0x3A, 0xDF, 0xD9, 0x13,
  // "¡" (U+00A1)
  0x28, 0x15, 0x63, 0x20, 0x20, 0xEB, 0x81, 0x90, 0xAD, 0x03, 0x0E, 0xD0, 0x7E, 0x08, 0x0E, 0xD0,
  0x70, 0xAD, 0x81, 0x32, 0xEB, 0x09, 0x38, 0x15, 0x63, 0x77, 0x77, 0x30, 0x3A, 0x0B, 0x30, 0x4A,
  0x0C, 0x30, 0x5A, 0x0D, 0x30, 0x6A, 0x0E, 0x30, 0x7B, 0x30, 0x7B, 0x30, 0x8B, 0x01, 0x20, 0x9B,
  0x02, 0x20, 0xAB, 0x03, 0x20, 0xBB, 0x04, 0x20, 0xCB, 0x05, 0x20, 0xDB, 0x05, 0x20, 0xEB, 0x06,
  0x20, 0xEB, 0x07, 0x2C, 0x81, 0x80, 0x1C, 0x81, 0x90, 0x2C, 0x81, 0xA0, 0x2C, 0x81, 0xB0, 0x3C,
  0x81, 0xC0, 0x4C, 0x81, 0xC0, 0x5C, 0x81, 0xD0, 0x6C, 0x81, 0xE0, 0x7D, 0x10, 0x8D, 0x10, 0x8D,
  0x01, 0x09, 0xD0, 0x20, 0xAD, 0x03, 0x0B, 0xD0, 0x40, 0xCD, 0x05, 0x0D, 0xD0, 0x60, 0xED, 0x07,
  // "¢" (U+00A2)
  0x74, 0x05, 0xA0, 0x37, 0x75, 0x05, 0xA0, 0x37, 0x75, 0x05, 0xA0, 0x37, 0x75, 0x05, 0xA0, 0x37,
  0x73, 0x81, 0x26, 0xBA, 0x82, 0x96, 0x41, 0x75, 0x06, 0x0D, 0xFA, 0x0B, 0x04, 0x71, 0x02, 0x0C,
  0xFE, 0x0A, 0x60, 0x30, 0xEC, 0x0D, 0x0B, 0xA0, 0xB0, 0xED, 0x0A, 0x40, 0x10, 0xDC, 0x81, 0x90,
  0x5A, 0x81, 0x31, 0xCD, 0x03, 0x30, 0xAC, 0x09, 0x20, 0x5A, 0x81, 0x30, 0x2D, 0x08, 0x20, 0x3C,
  0x0E, 0x01, 0x20, 0x5A, 0x03, 0x20, 0xBC, 0x09, 0x20, 0xAC, 0x08, 0x30, 0x5A, 0x03, 0x20, 0x6C,
  0x07, 0x20, 0xEC, 0x03, 0x30, 0x5A, 0x03, 0x20, 0x4B, 0x82, 0xE1, 0x04, 0xC0, 0xE4, 0x05, 0xA0,
  0x32, 0x02, 0xA0, 0xB0, 0x32, 0x08, 0xC0, 0xC4, 0x05, 0xA0, 0x33, 0x01, 0x50, 0xBC, 0x09, 0x40,
  0x5A, 0x03, 0x72, 0x0D, 0xC0, 0x74, 0x05, 0xA0, 0x37, 0x2D, 0x06, 0x40, 0x5A, 0x03, 0x71, 0x01,
  0xD0, 0x54, 0x05, 0xA0, 0x37, 0x10, 0x1D, 0x05, 0x40, 0x5A, 0x03, 0x71, 0x02, 0xD0, 0x44, 0x05,
  0xA0, 0x37, 0x10, 0x2D, 0x04, 0x40, 0x5A, 0x03, 0x71, 0x01, 0xD0, 0x54, 0x05, 0xA0, 0x37, 0x10,
  0x1D, 0x05, 0x40, 0x5A, 0x03, 0x72, 0xD0, 0x64, 0x05, 0xA0, 0x37, 0x20, 0xEC, 0x08, 0x40, 0x5A,
  0x03, 0x72, 0x0C, 0xC0, 0xA4, 0x05, 0xA0, 0x37, 0x20, 0x9C, 0x0D, 0x40, 0x5A, 0x03, 0x72, 0x05,
  0xD0, 0x23, 0x05, 0xA0, 0x37, 0x20, 0x1D, 0x06, 0x30, 0x5A, 0x03, 0x60, 0x13, 0x0B, 0xC0, 0xD3,
  0x05, 0xA0, 0x35, 0x03, 0x0D, 0x30, 0x4D, 0x06, 0x20, 0x5A, 0x03, 0x48, 0x21, 0xDF, 0x33, 0x0B,
  0xD8, 0x13, 0x05, 0xA0, 0x33, 0x01, 0x0D, 0xA0, 0x33, 0x02, 0x0E, 0xD0, 0x70, 0x6A, 0x03, 0x20,
  0x60, 0xEA, 0x0E, 0x50, 0x4F, 0xA8, 0x1B, 0xBE, 0xC0, 0x76, 0x03, 0x0D, 0xFE, 0x09, 0x72, 0x07,
  0x0E, 0xFA, 0x0D, 0x06, 0x75, 0x81, 0x48, 0xCA, 0x82, 0xDB, 0x84, 0x77, 0x20, 0x5A, 0x03, 0x77,
  0x50, 0x5A, 0x03, 0x77, 0x50, 0x5A, 0x03, 0x77, 0x50, 0x5A, 0x03, 0x77, 0x50, 0x5A, 0x03, 0x71,
  // "£" (U+00A3)
  0x73, 0x86, 0x14, 0x67, 0x76, 0x41, 0x77, 0x20, 0x50, 0xCF, 0x90, 0xC0, 0x67, 0x50, 0x10, 0xCF,
  0xD0, 0xC0, 0x17, 0x20, 0x20, 0xEC, 0x83, 0xEA, 0x9A, 0xDD, 0x0C, 0x72, 0x0C, 0xC0, 0x85, 0x08,
  0xD0, 0x77, 0x07, 0xC0, 0x87, 0x0A, 0xC0, 0xC7, 0x0E, 0xB0, 0xE7, 0x10, 0x2D, 0x60, 0x4C, 0x09,
  0x72, 0x0C, 0xC6, 0x08, 0xC0, 0x57, 0x20, 0x9B, 0x0D, 0x60, 0xBC, 0x03, 0x72, 0x07, 0xB0, 0x56,
  0x0C, 0xC0, 0x27, 0x28, 0x26, 0xDB, 0x47, 0x0C, 0xC0, 0x27, 0x76, 0x0C, 0xC0, 0x37, 0x76, 0x0B,
  0xC0, 0x47, 0x76, 0x09, 0xC0, 0x67, 0x76, 0x06, 0xC0, 0x97, 0x76, 0x03, 0xC0, 0xC7, 0x77, 0x0E,
  0xC0, 0x17, 0x76, 0x0A, 0xC0, 0x47, 0x76, 0x06, 0xC0, 0x97, 0x73, 0x0F, 0x10, 0x3C, 0x0E, 0x80,
  0x41, 0x71, 0x0A, 0xFF, 0xB0, 0xB7, 0x0A, 0xFF, 0xB0, 0xB7, 0x0A, 0xFF, 0xB0, 0xB7, 0x60, 0xDB,
  0x0E, 0x77, 0x70, 0x9C, 0x03, 0x77, 0x60, 0x6C, 0x06, 0x77, 0x60, 0x2C, 0x09, 0x77, 0x7C, 0x0B,
  0x77, 0x70, 0xDB, 0x0C, 0x77, 0x70, 0xCB, 0x0B, 0x77, 0x70, 0xDB, 0x09, 0x77, 0x70, 0xEB, 0x05,
  0x77, 0x60, 0x2B, 0x0E, 0x77, 0x70, 0x6B, 0x06, 0x77, 0x70, 0xCA, 0x0B, 0x77, 0x70, 0x6A, 0x0D,
  0x01, 0x77, 0x10, 0x14, 0x89, 0x02, 0xEF, 0xD4, 0x8B, 0xB8, 0x47, 0x30, 0xA0, 0x33, 0x01, 0x0D,
  0xA0, 0xCF, 0x81, 0xA5, 0x14, 0x82, 0x2B, 0xF3, 0x20, 0x20, 0xCF, 0xF8, 0x2B, 0x88, 0xBB, 0x82,
  0x30, 0x4E, 0xFF, 0xF0, 0xC2, 0x0B, 0xB8, 0x4E, 0xA9, 0x9B, 0xEF, 0xD0, 0xE0, 0x22, 0x82, 0xBF,
  0xB4, 0x60, 0x50, 0xBF, 0xA0, 0xE0, 0x23, 0x09, 0x04, 0x73, 0x81, 0x28, 0xDD, 0x0C, 0x02, 0x77,
  0x58, 0x33, 0x67, 0x63, 0x50,
  // "¤" (U+00A4)
  0x20, 0x17, 0x73, 0x01, 0x38, 0x14, 0xF4, 0x77, 0x10, 0xB0, 0xC2, 0x83, 0x3E, 0xFE, 0x24, 0x83,
  0x46, 0x75, 0x24, 0x09, 0xA8, 0x1B, 0x05, 0xB8, 0x2D, 0x11, 0x9E, 0x82, 0xC4, 0x07, 0xB0, 0xD2,
  0x07, 0xB0, 0xC0, 0xDF, 0xA0, 0xAB, 0x0E, 0x02, 0x30, 0xAE, 0x82, 0xDA, 0x9B, 0xE0, 0xE0, 0x35,
  0x0B, 0xB0, 0xE0, 0x54, 0x01, 0x09, 0xC0, 0x46, 0x0A, 0xA0, 0xE0, 0x27, 0x07, 0xB0, 0x45, 0x03,
  0xB0, 0x47, 0x20, 0xAA, 0x0B, 0x50, 0x8A, 0x0B, 0x73, 0x02, 0xB0, 0x14, 0x0C, 0xA0, 0x57, 0x40,
  0xBA, 0x05, 0x4B, 0x75, 0x07, 0xA0, 0x83, 0x01, 0xA0, 0xE7, 0x50, 0x5A, 0x0A, 0x30, 0x1A, 0x0D,
  0x75, 0x05, 0xA0, 0xA3, 0x01, 0xB7, 0x50, 0x6A, 0x09, 0x40, 0xEA, 0x02, 0x74, 0x09, 0xA0, 0x74,
  0x0B, 0xA0, 0x77, 0x40, 0xDA, 0x04, 0x40, 0x7A, 0x0D, 0x73, 0x05, 0xA0, 0xE5, 0x01, 0xB0, 0x97,
  0x10, 0x10, 0xEA, 0x09, 0x60, 0x9B, 0x08, 0x60, 0x10, 0xDB, 0x01, 0x50, 0x20, 0xEC, 0x85, 0xB4,
  0x10, 0x27, 0xEC, 0x09, 0x40, 0x10, 0xDF, 0xFB, 0x07, 0x30, 0xCB, 0x08, 0x09, 0xF9, 0x81, 0xD5,
  0xDB, 0x81, 0x50, 0x7B, 0x0A, 0x28, 0x13, 0x9D, 0xB0, 0xB0, 0x62, 0x02, 0x0E, 0xA8, 0x4E, 0x10,
  0xCF, 0xC7, 0x70, 0x3A, 0x06, 0x28, 0x11, 0xB1, 0x77, 0x10, 0x60, 0x72,
  // "¥" (U+00A5)
  0x0B, 0xFC, 0x0E, 0x50, 0xAF, 0xA0, 0x40, 0xBF, 0xC0, 0xE5, 0x0A, 0xFA, 0x04, 0x0B, 0xFC, 0x0E,
  0x50, 0xAF, 0xA8, 0x24, 0x14, 0xCF, 0x81, 0x82, 0x15, 0x81, 0x12, 0x7D, 0x09, 0x02, 0x30, 0x10,
  0xDD, 0x0B, 0x74, 0x09, 0xB0, 0xA6, 0x06, 0xD0, 0x97, 0x40, 0x7B, 0x02, 0x70, 0xDC, 0x0C, 0x74,
  0x0A, 0xA0, 0xA7, 0x10, 0x7D, 0x02, 0x73, 0x0E, 0xA0, 0x37, 0x10, 0x1D, 0x07, 0x72, 0x04, 0xA0,
  0xC7, 0x30, 0x9C, 0x0D, 0x72, 0x0A, 0xA0, 0x57, 0x30, 0x2D, 0x04, 0x70, 0x1A, 0x0D, 0x75, 0x0B,
  0xC0, 0xA7, 0x07, 0xA0, 0x77, 0x50, 0x5D, 0x01, 0x68, 0x2D, 0xFE, 0x17, 0x60, 0xDC, 0x07, 0x50,
  0x4A, 0x09, 0x77, 0x07, 0xC0, 0xD5, 0x0A, 0xA0, 0x27, 0x70, 0x10, 0xEC, 0x04, 0x30, 0x1A, 0x0B,
  0x77, 0x20, 0x9C, 0x09, 0x30, 0x8A, 0x04, 0x77, 0x20, 0x2C, 0x0E, 0x38, 0x1E, 0xFD, 0x77, 0x40,
  0xBC, 0x81, 0x50, 0x6A, 0x06, 0x77, 0x40, 0x4C, 0x83, 0xA0, 0xCF, 0xE7, 0x76, 0x0D, 0xB0, 0xE0,
  0x3A, 0x08, 0x77, 0x60, 0x6C, 0x0C, 0xA0, 0x17, 0x70, 0x5F, 0xFD, 0x06, 0x71, 0x05, 0xFF, 0xD0,
  0x67, 0x10, 0x5F, 0xFD, 0x06, 0x72, 0x80, 0x21, 0x04, 0xD0, 0x48, 0x02, 0x17, 0x72, 0x03, 0xD0,
  0x37, 0x77, 0x10, 0x3D, 0x03, 0x77, 0x28, 0x02, 0x10, 0x4D, 0x04, 0x80, 0x21, 0x72, 0x05, 0xFF,
  0xD0, 0x67, 0x10, 0x5F, 0xFD, 0x06, 0x71, 0x05, 0xFF, 0xD0, 0x67, 0x71, 0x03, 0xD0, 0x37, 0x77,
  0x10, 0x3D, 0x03, 0x77, 0x71, 0x03, 0xD0, 0x37, 0x77, 0x10, 0x3D, 0x03, 0x77, 0x71, 0x04, 0xD0,
  0x47, 0x77, 0x10, 0x7D, 0x06, 0x77, 0x71, 0x0D, 0xD0, 0xC7, 0x74, 0x82, 0x12, 0x5C, 0xF8, 0x2C,
  0x52, 0x17, 0x60, 0x5F, 0xF9, 0x04, 0x75, 0x05, 0xFF, 0x90, 0x47, 0x50, 0x5F, 0xF9, 0x04, 0x60,
  // "¦" (U+00A6)
  0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE,
  0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE,
  0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE,
  0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE,
  0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE,
  0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE, 0x5F, 0xFE,
  // "§" (U+00A7)
  0x78, 0x73, 0x8C, 0xEF, 0xED, 0xA6, 0x75, 0x02, 0x0B, 0xFA, 0x0E, 0x05, 0x72, 0x03, 0x0E, 0xFD,
  0x06, 0x70, 0x20, 0xEB, 0x84, 0xC5, 0x21, 0x38, 0xD0, 0x36, 0x0B, 0xB0, 0x86, 0x05, 0xC0, 0xA5,
  0x03, 0xB0, 0xB7, 0x10, 0xAB, 0x0E, 0x50, 0x8B, 0x04, 0x71, 0x04, 0xB0, 0xE5, 0x0C, 0xB7, 0x30,
  0xEA, 0x0C, 0x50, 0xEA, 0x0E, 0x73, 0x0C, 0xA0, 0x55, 0xB0, 0xE7, 0x38, 0x19, 0xA4, 0x6C, 0x77,
  0x50, 0xEB, 0x04, 0x77, 0x40, 0xBB, 0x0A, 0x77, 0x40, 0x8C, 0x05, 0x77, 0x30, 0x2D, 0x06, 0x77,
  0x30, 0xBD, 0x09, 0x01, 0x77, 0x10, 0x4E, 0x0E, 0x05, 0x76, 0x01, 0x0D, 0xF9, 0x0C, 0x03, 0x74,
  0x0B, 0xA0, 0x70, 0xDF, 0x09, 0x01, 0x71, 0x05, 0xA8, 0x2C, 0x01, 0xAF, 0x0E, 0x04, 0x70, 0xBA,
  0x07, 0x30, 0x50, 0xEF, 0x08, 0x6B, 0x05, 0x40, 0x10, 0x9F, 0x0B, 0x40, 0x1B, 0x05, 0x60, 0x30,
  0xCE, 0x0C, 0x30, 0x1B, 0x07, 0x71, 0x06, 0x0E, 0xD0, 0x93, 0xB0, 0xC7, 0x20, 0x20, 0xDD, 0x03,
  0x20, 0xEB, 0x06, 0x72, 0x01, 0x0C, 0xC0, 0xA2, 0x09, 0xC0, 0x57, 0x20, 0x10, 0xDB, 0x0E, 0x20,
  0x3D, 0x07, 0x72, 0x05, 0xC0, 0x12, 0x0A, 0xD0, 0xB0, 0x17, 0x10, 0xEB, 0x02, 0x20, 0x10, 0xDD,
  0x0E, 0x06, 0x70, 0xBB, 0x01, 0x30, 0x10, 0xCE, 0x0C, 0x03, 0x50, 0xAB, 0x60, 0xAF, 0x07, 0x40,
  0xBA, 0x0B, 0x70, 0x6F, 0x0C, 0x01, 0x20, 0xDA, 0x06, 0x71, 0x02, 0x0B, 0xE8, 0x1E, 0x41, 0xA0,
  0xD7, 0x40, 0x50, 0xEE, 0x0B, 0xA0, 0x57, 0x50, 0x10, 0x9F, 0x0A, 0x77, 0x10, 0x40, 0xED, 0x06,
  0x77, 0x20, 0x10, 0xBC, 0x0D, 0x77, 0x40, 0xBC, 0x05, 0x77, 0x40, 0xCB, 0x09, 0x77, 0x40, 0x3B,
  0x0C, 0x60, 0x01, 0x74, 0x0D, 0xA0, 0xD4, 0x82, 0x1A, 0xF5, 0x74, 0x0A, 0xA0, 0xE4, 0x0A, 0xA0,
  0x67, 0x40, 0x8A, 0x0D, 0x4B, 0x09, 0x74, 0x09, 0xA0, 0xC3, 0x01, 0xB0, 0xD7, 0x40, 0xBA, 0x09,
  0x30, 0x1C, 0x05, 0x72, 0x01, 0xB0, 0x44, 0x0E, 0xB0, 0xC7, 0x20, 0x8A, 0x0E, 0x50, 0xAC, 0x0A,
  0x70, 0x5B, 0x07, 0x50, 0x3D, 0x85, 0xC5, 0x10, 0x14, 0xAB, 0x0C, 0x70, 0x7F, 0xE0, 0xD0, 0x17,
  0x10, 0x50, 0xEF, 0xB0, 0xA7, 0x58, 0x16, 0xAD, 0xC8, 0x1D, 0x93, 0x70,
  // "¨" (U+00A8)
  0x18, 0x28, 0xEE, 0x85, 0x85, 0x3C, 0xEC, 0x30, 0x5C, 0x07, 0x40, 0xEB, 0x81, 0xE0, 0x9C, 0x0B,
  0x30, 0x2D, 0x02, 0x09, 0xC0, 0xB3, 0x02, 0xD0, 0x20, 0x5C, 0x08, 0x40, 0xEB, 0x0E, 0x28, 0x28,
  0xEE, 0x95, 0x83, 0x4C, 0xEC, 0x31,
  // "©" (U+00A9)
  0x77, 0x89, 0x24, 0x8B, 0xDE, 0xFE, 0xDC, 0x96, 0x27, 0x77, 0x38, 0x12, 0x9E, 0xFD, 0x0B, 0x05,
  0x77, 0x60, 0x10, 0x9F, 0xFB, 0x0C, 0x03, 0x77, 0x30, 0x30, 0xDC, 0x89, 0x1D, 0x96, 0x32, 0x12,
  0x34, 0x8B, 0xD0, 0x87, 0x71, 0x05, 0xC0, 0xB0, 0x47, 0x40, 0x20, 0x8C, 0x0A, 0x76, 0x05, 0xB0,
  0xE0, 0x57, 0x71, 0x01, 0x0B, 0xB0, 0xA7, 0x40, 0x3B, 0x0C, 0x01, 0x77, 0x40, 0x8B, 0x09, 0x72,
  0x01, 0x0D, 0xA0, 0xC6, 0x89, 0x01, 0x5A, 0xCE, 0xFE, 0xDA, 0x55, 0x07, 0xB0, 0x57, 0x10, 0xAA,
  0x0D, 0x01, 0x50, 0x60, 0xEF, 0xA0, 0xD0, 0x34, 0x09, 0xA0, 0xE0, 0x16, 0x03, 0xB0, 0x35, 0x0B,
  0xB8, 0x5B, 0x63, 0x24, 0x8E, 0xA0, 0xE0, 0x24, 0x0C, 0xA0, 0x86, 0x0B, 0xA0, 0x85, 0x0A, 0xA0,
  0xE0, 0x36, 0x01, 0x0D, 0xA0, 0xC4, 0x03, 0xB0, 0x14, 0x02, 0xA0, 0xE0, 0x14, 0x06, 0xB0, 0x27,
  0x10, 0x4B, 0x03, 0x40, 0xAA, 0x08, 0x40, 0x9A, 0x08, 0x40, 0x10, 0xEA, 0x07, 0x73, 0x0D, 0xA0,
  0x54, 0x03, 0xA0, 0xD4, 0x0E, 0xA0, 0x24, 0x06, 0xA0, 0xE0, 0x17, 0x30, 0x9A, 0x02, 0x50, 0xDA,
  0x04, 0x20, 0x3A, 0x0C, 0x50, 0xCA, 0x0A, 0x74, 0x81, 0x7F, 0x86, 0x07, 0xA0, 0x82, 0x07, 0xA0,
  0x84, 0x01, 0xB0, 0x57, 0x40, 0x10, 0x27, 0x03, 0xA0, 0xC2, 0x0A, 0xA0, 0x44, 0x04, 0xB0, 0x27,
  0x77, 0x0E, 0xA2, 0x0C, 0xA0, 0x24, 0x07, 0xB7, 0x77, 0x10, 0xCA, 0x02, 0x1B, 0x50, 0x9A, 0x0D,
  0x77, 0x71, 0x0A, 0xA0, 0x40, 0x1A, 0x0D, 0x50, 0xAA, 0x0C, 0x77, 0x71, 0x08, 0xA0, 0x50, 0x1A,
  0x0C, 0x50, 0xBA, 0x0C, 0x77, 0x71, 0x07, 0xA0, 0x60, 0x2A, 0x0C, 0x50, 0xBA, 0x0C, 0x77, 0x71,
  0x07, 0xA0, 0x70, 0x2A, 0x0C, 0x50, 0xBA, 0x0C, 0x77, 0x71, 0x07, 0xA0, 0x70, 0x1A, 0x0C, 0x50,
  0xAA, 0x0D, 0x77, 0x71, 0x07, 0xA0, 0x60, 0x1A, 0x0D, 0x50, 0x9A, 0x0E, 0x77, 0x71, 0x08, 0xA0,
  0x51, 0xB5, 0x07, 0xB0, 0x17, 0x77, 0x0A, 0xA8, 0x14, 0x0C, 0xA0, 0x24, 0x04, 0xB0, 0x37, 0x77,
  0x0C, 0xA8, 0x12, 0x0A, 0xA0, 0x54, 0x01, 0xB0, 0x77, 0x77, 0x0E, 0xA2, 0x07, 0xA0, 0x95, 0x0B,
  0xA0, 0xC7, 0x76, 0x03, 0xA0, 0xC2, 0x03, 0xA0, 0xD5, 0x06, 0xB0, 0x27, 0x40, 0x50, 0x96, 0x07,
  0xA0, 0x83, 0x0E, 0xA0, 0x35, 0x0E, 0xA0, 0xA7, 0x48, 0x1D, 0xF1, 0x50, 0xDA, 0x04, 0x30, 0x8A,
  0x09, 0x50, 0x6B, 0x05, 0x72, 0x81, 0x8F, 0xE5, 0x03, 0xA0, 0xD4, 0x02, 0xB0, 0x15, 0x0B, 0xB0,
  0x57, 0x07, 0xA0, 0x85, 0x0A, 0xA0, 0x85, 0x0B, 0xA0, 0x96, 0x0C, 0xB8, 0x5A, 0x41, 0x01, 0x4B,
  0xA0, 0xC0, 0x14, 0x03, 0xB0, 0x15, 0x03, 0xB0, 0x46, 0x08, 0xFB, 0x0A, 0x01, 0x50, 0xCA, 0x08,
  0x70, 0xAA, 0x0E, 0x01, 0x68, 0x12, 0x8D, 0xC8, 0x1E, 0x93, 0x60, 0x8A, 0x0E, 0x01, 0x70, 0x10,
  0xDA, 0x0D, 0x01, 0x72, 0x00, 0x17, 0x20, 0x7B, 0x05, 0x72, 0x04, 0xB0, 0xC0, 0x27, 0x74, 0x07,
  0xB0, 0x97, 0x40, 0x5B, 0x0E, 0x05, 0x77, 0x10, 0x10, 0xBB, 0x0A, 0x76, 0x05, 0xC0, 0xC0, 0x47,
  0x48, 0x11, 0x8E, 0xB0, 0xA7, 0x71, 0x03, 0x0E, 0xC8, 0x91, 0xE9, 0x63, 0x21, 0x12, 0x47, 0xBD,
  0x07, 0x77, 0x30, 0x10, 0x9F, 0xFB, 0x0C, 0x03, 0x77, 0x68, 0x12, 0x9E, 0xFD, 0x0B, 0x05, 0x77,
  0x74, 0x89, 0x25, 0x8B, 0xDE, 0xFE, 0xDC, 0x96, 0x27, 0x60,
  // "ª" (U+00AA)
  0x48, 0x73, 0x9C, 0xEF, 0xED, 0xA5, 0x71, 0x0A, 0xC0, 0xD0, 0xEB, 0x0C, 0x01, 0x50, 0x8B, 0x0B,
  0x01, 0x20, 0x8B, 0x0A, 0x50, 0xCB, 0x03, 0x40, 0xEB, 0x02, 0x40, 0xAA, 0x0E, 0x50, 0xAB, 0x06,
  0x48, 0x21, 0x8C, 0xC5, 0x08, 0xB0, 0x87, 0x60, 0x8B, 0x09, 0x76, 0x08, 0xB0, 0x96, 0x82, 0x5A,
  0xCE, 0xF0, 0x94, 0x04, 0x0E, 0xC8, 0x2E, 0xDD, 0xEB, 0x09, 0x30, 0x3C, 0x0A, 0x02, 0x30, 0x8B,
  0x09, 0x30, 0xCB, 0x0B, 0x50, 0x8B, 0x09, 0x20, 0x1C, 0x05, 0x50, 0x8B, 0x09, 0x20, 0x3C, 0x02,
  0x50, 0x8B, 0x09, 0x20, 0x3C, 0x01, 0x50, 0xAB, 0x09, 0x20, 0x2C, 0x01, 0x50, 0xEB, 0x09, 0x30,
  0xEB, 0x05, 0x40, 0x7C, 0x0A, 0x30, 0x7B, 0x0D, 0x02, 0x28, 0x26, 0xF5, 0xDA, 0x0E, 0x02, 0x30,
  0xBC, 0x0F, 0xE8, 0x15, 0x08, 0xC0, 0xB3, 0x85, 0x6C, 0xEE, 0xC8, 0x12, 0x04, 0xC0, 0xD0,
  // "«" (U+00AB)
  0x70, 0x6A, 0x03, 0x40, 0x4A, 0x05, 0x60, 0x2A, 0x0B, 0x48, 0x21, 0xEF, 0xD7, 0x0D, 0xA0, 0x44,
  0x0B, 0xA0, 0x66, 0x09, 0xA0, 0xD4, 0x07, 0xA0, 0xE6, 0x05, 0xB0, 0x53, 0x03, 0xB0, 0x75, 0x02,
  0x0E, 0xA0, 0xD3, 0x01, 0x0D, 0xA0, 0xE0, 0x15, 0x0C, 0xB0, 0x73, 0x0B, 0xB0, 0x85, 0x08, 0xB0,
  0xE3, 0x07, 0xC0, 0x14, 0x04, 0xC0, 0x82, 0x03, 0xC0, 0x94, 0x01, 0x0E, 0xC0, 0x12, 0x0D, 0xC0,
  0x24, 0x0A, 0xC0, 0x92, 0x09, 0xC0, 0xB5, 0x0D, 0xC0, 0x32, 0x0C, 0xC0, 0x55, 0x0B, 0xC0, 0x82,
  0x0B, 0xC0, 0xA5, 0x02, 0x0E, 0xB8, 0x3E, 0x10, 0x1E, 0xC0, 0x25, 0x05, 0xC0, 0x72, 0x04, 0xC0,
  0x96, 0x09, 0xB0, 0xE3, 0x08, 0xB0, 0xE0, 0x16, 0x0D, 0xB0, 0x63, 0x0C, 0xB0, 0x86, 0x02, 0xB0,
  0xD3, 0x01, 0x0E, 0xA0, 0xE7, 0x06, 0xB0, 0x53, 0x04, 0xB0, 0x77, 0x0A, 0xA0, 0xC4, 0x08, 0xA0,
  0xD7, 0x10, 0xDA, 0x04, 0x40, 0xBA, 0x06, 0x70, 0x3A, 0x0B, 0x48, 0x21, 0xEF, 0xD7, 0x10, 0x6A,
  0x03, 0x40, 0x4A, 0x05,
  // "¬" (U+00AC)
  0x80, 0xA2, 0x1F, 0xFF, 0x0E, 0xFF, 0xF0, 0xEF, 0xFF, 0x0E, 0x77, 0x40, 0x8A, 0x0E, 0x77, 0x40,
  0x8A, 0x0E, 0x77, 0x40, 0x8A, 0x0E, 0x77, 0x40, 0x8A, 0x0E, 0x77, 0x40, 0x8A, 0x0E, 0x77, 0x40,
  0x8A, 0x0E, 0x77, 0x40, 0x8A, 0x0E, 0x77, 0x40, 0x8A, 0x0E, 0x77, 0x40, 0x8A, 0x0E, 0x77, 0x40,
  0x8A, 0x0E, 0x77, 0x40, 0x8A, 0x0E, 0x77, 0x40, 0x8A, 0x0E, 0x77, 0x40, 0x30, 0xF7,
  // "®" (U+00AE)
  0x77, 0x89, 0x24, 0x8B, 0xDE, 0xFE, 0xDC, 0x96, 0x27, 0x77, 0x38, 0x12, 0x9E, 0xFD, 0x0B, 0x05,
  0x77, 0x60, 0x10, 0x9F, 0xFB, 0x0C, 0x03, 0x77, 0x30, 0x30, 0xDC, 0x89, 0x1D, 0x96, 0x32, 0x12,
  0x34, 0x8B, 0xD0, 0x87, 0x71, 0x05, 0xC0, 0xB0, 0x47, 0x40, 0x20, 0x8C, 0x0A, 0x76, 0x05, 0xB0,
  0xE0, 0x57, 0x71, 0x01, 0x0B, 0xB0, 0xA7, 0x40, 0x3B, 0x0C, 0x01, 0x77, 0x40, 0x8B, 0x09, 0x72,
  0x01, 0x0D, 0xA0, 0xC7, 0x77, 0x07, 0xB0, 0x57, 0x10, 0xAA, 0x82, 0xD1, 0x01, 0x80, 0x52, 0x01,
  0x73, 0x09, 0xA0, 0xE0, 0x16, 0x03, 0xB0, 0x32, 0x0B, 0xFC, 0x81, 0xC8, 0x27, 0x0C, 0xA0, 0x86,
  0x0B, 0xA0, 0x83, 0x08, 0x0B, 0xFE, 0x08, 0x60, 0x3B, 0x01, 0x40, 0x2A, 0x0E, 0x01, 0x50, 0x10,
  0xEA, 0x0E, 0x38, 0x11, 0x5B, 0xB0, 0x96, 0x0A, 0xA0, 0x84, 0x09, 0xA0, 0x87, 0x0A, 0xA0, 0xE6,
  0x09, 0xB0, 0x35, 0x03, 0xA0, 0xD4, 0x0E, 0xA0, 0x27, 0x09, 0xA0, 0xE6, 0x01, 0xB0, 0x96, 0x0D,
  0xA0, 0x42, 0x03, 0xA0, 0xC7, 0x10, 0x9A, 0x0E, 0x70, 0xDA, 0x0C, 0x60, 0x7A, 0x08, 0x20, 0x7A,
  0x08, 0x71, 0x09, 0xA0, 0xE7, 0x0B, 0xA0, 0xE6, 0x03, 0xA0, 0xC2, 0x0A, 0xA0, 0x47, 0x10, 0x9A,
  0x0E, 0x70, 0xBA, 0x0D, 0x70, 0xEA, 0x20, 0xCA, 0x02, 0x71, 0x09, 0xA0, 0xE7, 0x0D, 0xA0, 0xB7,
  0x0C, 0xA0, 0x21, 0xB7, 0x20, 0x9A, 0x0E, 0x60, 0x1B, 0x07, 0x70, 0xAA, 0x04, 0x01, 0xA0, 0xD7,
  0x20, 0x9A, 0x0E, 0x60, 0x9A, 0x0E, 0x01, 0x70, 0x8A, 0x05, 0x01, 0xA0, 0xC7, 0x20, 0x9A, 0x0E,
  0x38, 0x11, 0x4B, 0xA0, 0xE0, 0x37, 0x10, 0x7A, 0x06, 0x02, 0xA0, 0xC7, 0x20, 0x9F, 0xB0, 0xB0,
  0x27, 0x20, 0x7A, 0x07, 0x02, 0xA0, 0xC7, 0x20, 0x9F, 0xA0, 0x77, 0x40, 0x7A, 0x07, 0x01, 0xA0,
  0xC7, 0x20, 0x9A, 0x83, 0xE2, 0x22, 0xDA, 0x0C, 0x74, 0x07, 0xA0, 0x60, 0x1A, 0x0D, 0x72, 0x09,
  0xA0, 0xE3, 0x06, 0xB0, 0x57, 0x30, 0x8A, 0x05, 0x1B, 0x72, 0x09, 0xA0, 0xE4, 0x0D, 0xA0, 0xD7,
  0x30, 0xAA, 0x81, 0x40, 0xCA, 0x02, 0x71, 0x09, 0xA0, 0xE4, 0x06, 0xB0, 0x57, 0x20, 0xCA, 0x81,
  0x20, 0xAA, 0x05, 0x71, 0x09, 0xA0, 0xE5, 0x0E, 0xA0, 0xD7, 0x20, 0xEA, 0x20, 0x7A, 0x09, 0x71,
  0x09, 0xA0, 0xE5, 0x07, 0xB0, 0x57, 0x03, 0xA0, 0xC2, 0x03, 0xA0, 0xD7, 0x10, 0x9A, 0x0E, 0x60,
  0xEA, 0x0D, 0x70, 0x7A, 0x08, 0x30, 0xEA, 0x03, 0x70, 0x9A, 0x0E, 0x60, 0x7B, 0x06, 0x60, 0xDA,
  0x04, 0x30, 0x8A, 0x09, 0x70, 0xBB, 0x60, 0x10, 0xEA, 0x0D, 0x50, 0x3A, 0x0D, 0x40, 0x2B, 0x01,
  0x40, 0x10, 0x5C, 0x08, 0x01, 0x50, 0x8B, 0x0A, 0x01, 0x30, 0xAA, 0x08, 0x50, 0xBA, 0x09, 0x30,
  0xBF, 0xA0, 0x23, 0x01, 0xD8, 0x1A, 0x03, 0xB0, 0x15, 0x03, 0xB0, 0x42, 0x0A, 0x80, 0x5D, 0x01,
  0x48, 0x68, 0xDD, 0xDD, 0x90, 0xCA, 0x08, 0x70, 0xAA, 0x0E, 0x01, 0x77, 0x71, 0x08, 0xA0, 0xE0,
  0x17, 0x01, 0x0D, 0xA0, 0xD0, 0x17, 0x76, 0x07, 0xB0, 0x57, 0x20, 0x4B, 0x0C, 0x02, 0x77, 0x40,
  0x7B, 0x09, 0x74, 0x05, 0xB0, 0xE0, 0x57, 0x71, 0x01, 0x0B, 0xB0, 0xA7, 0x60, 0x5C, 0x0C, 0x04,
  0x74, 0x81, 0x18, 0xEB, 0x0A, 0x77, 0x10, 0x30, 0xEC, 0x89, 0x1E, 0x96, 0x32, 0x11, 0x24, 0x7B,
  0xD0, 0x77, 0x73, 0x01, 0x09, 0xFF, 0xB0, 0xC0, 0x37, 0x76, 0x81, 0x29, 0xEF, 0xD0, 0xB0, 0x57,
  0x77, 0x48, 0x92, 0x58, 0xBD, 0xEF, 0xED, 0xC9, 0x62, 0x76,
  // "¯" (U+00AF)
  0x18, 0x0A, 0x31, 0x10, 0x3F, 0xFF, 0xA0, 0xA0, 0x3F, 0xFF, 0xA0, 0xA0, 0x3F, 0xFF, 0xA0, 0xA0,
  // "°" (U+00B0)
  0x48, 0x12, 0x9D, 0xA8, 0x1E, 0xB5, 0x70, 0x7F, 0x90, 0xB5, 0x06, 0xFB, 0x0C, 0x30, 0x2B, 0x84,
  0xC4, 0x10, 0x28, 0xB0, 0x82, 0x09, 0xA0, 0xB6, 0x05, 0xA8, 0x2E, 0x10, 0xEA, 0x02, 0x70, 0x9A,
  0x06, 0x03, 0xA0, 0xB7, 0x10, 0x3A, 0x0A, 0x05, 0xA0, 0x87, 0x2A, 0x0C, 0x07, 0xA0, 0x67, 0x28,
  0x2E, 0xFD, 0x7A, 0x06, 0x72, 0x82, 0xEF, 0xE5, 0xA0, 0x87, 0x2A, 0x0C, 0x03, 0xA0, 0xC7, 0x10,
  0x4A, 0x81, 0xA0, 0xEA, 0x03, 0x70, 0xAA, 0x81, 0x60, 0x9A, 0x0C, 0x60, 0x6A, 0x83, 0xE1, 0x02,
  0xEA, 0x84, 0xD5, 0x21, 0x39, 0xB0, 0x73, 0x06, 0xFB, 0x0B, 0x50, 0x60, 0xEF, 0x0A, 0x78, 0x61,
  0x8C, 0xEF, 0xDA, 0x44,
  // "±" (U+00B1)
  0x72, 0x0D, 0xA0, 0xA7, 0x74, 0x0D, 0xA0, 0xA7, 0x74, 0x0D, 0xA0, 0xA7, 0x74, 0x0D, 0xA0, 0xA7,
  0x74, 0x0D, 0xA0, 0xA7, 0x74, 0x0D, 0xA0, 0xA7, 0x74, 0x0D, 0xA0, 0xA7, 0x74, 0x0D, 0xA0, 0xA7,
  0x74, 0x0D, 0xA0, 0xA7, 0x74, 0x0D, 0xA0, 0xA7, 0x74, 0x0D, 0xA0, 0xA7, 0x28, 0x05, 0x10, 0xDA,
  0x0A, 0x80, 0x51, 0xFF, 0xF0, 0xEF, 0xFF, 0x0E, 0xFF, 0xF0, 0xE7, 0x20, 0xDA, 0x0A, 0x77, 0x40,
  0xDA, 0x0A, 0x77, 0x40, 0xDA, 0x0A, 0x77, 0x40, 0xDA, 0x0A, 0x77, 0x40, 0xDA, 0x0A, 0x77, 0x40,
  0xDA, 0x0A, 0x77, 0x40, 0xDA, 0x0A, 0x77, 0x40, 0xDA, 0x0A, 0x77, 0x40, 0xDA, 0x0A, 0x77, 0x40,
  0xDA, 0x0A, 0x77, 0x40, 0xDA, 0x0A, 0x80, 0x9E, 0x30, 0x80, 0xA2, 0x1F, 0xFF, 0x0E, 0xFF, 0xF0,
  0xEF, 0xFF, 0x0E,
  // "²" (U+00B2)
  0x58, 0x31, 0x34, 0x32, 0x72, 0x08, 0x0D, 0xD8, 0x1E, 0x92, 0x40, 0x20, 0xDF, 0xB0, 0x53, 0x0D,
  0xB8, 0x39, 0x20, 0x2B, 0xC8, 0x13, 0x05, 0xB0, 0xB5, 0x0E, 0xB8, 0x1B, 0x08, 0xB0, 0x45, 0x08,
  0xC0, 0x10, 0x6B, 0x01, 0x50, 0x5C, 0x81, 0x30, 0xAA, 0x60, 0x3C, 0x03, 0x20, 0x10, 0x36, 0x04,
  0xC0, 0x27, 0x30, 0x5C, 0x74, 0x08, 0xB0, 0xB7, 0x40, 0xDB, 0x04, 0x73, 0x04, 0xB0, 0xB7, 0x40,
  0xCA, 0x0D, 0x01, 0x73, 0x07, 0xA0, 0xE0, 0x37, 0x30, 0x3B, 0x03, 0x73, 0x83, 0x1D, 0xFE, 0x47,
  0x38, 0x31, 0xCF, 0xE3, 0x74, 0x82, 0xCF, 0xE3, 0x74, 0x82, 0xBF, 0xE3, 0x60, 0x60, 0x93, 0x82,
  0xAF, 0xE3, 0x70, 0xD0, 0xE2, 0x82, 0x9F, 0xE3, 0x78, 0x61, 0xFD, 0x08, 0xFE, 0x37, 0x83, 0x1A,
  0xFD, 0x7F, 0xF0, 0xDF, 0xF9, 0x0C, 0xFF, 0x90, 0xCF, 0xF9, 0x0C,
  // "³" (U+00B3)
  0x48, 0x73, 0x9C, 0xEF, 0xED, 0xA5, 0x71, 0x0A, 0xFA, 0x0D, 0x03, 0x50, 0xBB, 0x83, 0xB5, 0x47,
  0xEB, 0x0E, 0x02, 0x30, 0x5B, 0x0A, 0x40, 0x10, 0xEB, 0x0B, 0x30, 0x9B, 0x03, 0x50, 0x9C, 0x01,
  0x20, 0xAA, 0x0E, 0x60, 0x5C, 0x03, 0x20, 0x6A, 0x0C, 0x60, 0x4C, 0x03, 0x38, 0x16, 0xB9, 0x60,
  0x5C, 0x02, 0x75, 0x08, 0xB0, 0xD7, 0x60, 0xDB, 0x06, 0x75, 0x08, 0xB0, 0x97, 0x40, 0x30, 0xAB,
  0x07, 0x72, 0x0B, 0xD0, 0x90, 0x27, 0x30, 0xBD, 0x81, 0xD9, 0x37, 0x28, 0x33, 0x44, 0x6A, 0xC0,
  0xA0, 0x17, 0x50, 0x20, 0xDB, 0x0C, 0x01, 0x75, 0x03, 0xC0, 0x87, 0x60, 0xBB, 0x0D, 0x76, 0x08,
  0xC2, 0x81, 0x18, 0x57, 0x10, 0x8C, 0x83, 0x10, 0xCF, 0x97, 0x10, 0x9C, 0x10, 0x1A, 0x0C, 0x71,
  0x0B, 0xB8, 0x1C, 0x02, 0xB0, 0x36, 0x02, 0xC0, 0x72, 0x0E, 0xA0, 0xB5, 0x01, 0x0C, 0xB0, 0xE3,
  0x07, 0xB8, 0x4D, 0x74, 0x58, 0xEB, 0x0E, 0x03, 0x40, 0x8F, 0xB0, 0xA0, 0x26, 0x82, 0x28, 0xBE,
  0xA8, 0x2E, 0xB8, 0x25,
  // "´" (U+00B4)
  0x58, 0x02, 0x74, 0x04, 0xD0, 0xC4, 0x0B, 0xC0, 0xE0, 0x23, 0x04, 0xD0, 0x44, 0x0C, 0xC0, 0x64,
  0x05, 0xC0, 0x75, 0x0E, 0xB0, 0x75, 0x08, 0xB0, 0x65, 0x02, 0xB0, 0x56, 0x82, 0x8F, 0xE3, 0x70,
  // "µ" (U+00B5)
  0x1D, 0x04, 0x73, 0x0D, 0xC0, 0x75, 0xD0, 0x47, 0x30, 0xDC, 0x07, 0x5D, 0x04, 0x73, 0x0D, 0xC0,
  0x75, 0xD0, 0x47, 0x30, 0xDC, 0x07, 0x5D, 0x04, 0x73, 0x0D, 0xC0, 0x75, 0xD0, 0x47, 0x30, 0xDC,
  0x07, 0x5D, 0x04, 0x73, 0x0D, 0xC0, 0x75, 0xD0, 0x47, 0x30, 0xDC, 0x07, 0x5D, 0x04, 0x73, 0x0D,
  0xC0, 0x75, 0xD0, 0x47, 0x30, 0xDC, 0x07, 0x5D, 0x04, 0x73, 0x0D, 0xC0, 0x75, 0xD0, 0x47, 0x30,
  0xDC, 0x07, 0x5D, 0x04, 0x73, 0x0D, 0xC0, 0x75, 0xD0, 0x47, 0x30, 0xDC, 0x07, 0x5D, 0x04, 0x73,
  0x0D, 0xC0, 0x75, 0xD0, 0x47, 0x30, 0xDC, 0x07, 0x5D, 0x04, 0x73, 0x0D, 0xC0, 0x75, 0xD0, 0x47,
  0x30, 0xDC, 0x07, 0x5D, 0x04, 0x73, 0x0D, 0xC0, 0x75, 0xD0, 0x47, 0x30, 0xEC, 0x07, 0x5D, 0x04,
  0x73, 0x0E, 0xC0, 0x75, 0xD0, 0x57, 0x3D, 0x07, 0x40, 0x1D, 0x06, 0x72, 0x03, 0xD0, 0x74, 0x01,
  0xD0, 0x87, 0x20, 0x7D, 0x07, 0x40, 0x1D, 0x0B, 0x72, 0x0C, 0xD0, 0x74, 0x02, 0xE0, 0x17, 0x04,
  0xE0, 0x74, 0x02, 0xE0, 0x86, 0x82, 0x1D, 0xFA, 0xC0, 0x94, 0x03, 0xF0, 0x64, 0x83, 0x2C, 0xFB,
  0x2C, 0x0D, 0x40, 0x3A, 0x0D, 0xD8, 0x2C, 0x98, 0xAB, 0x81, 0x30, 0xCC, 0x07, 0x30, 0x4A, 0x09,
  0x0B, 0xFB, 0x07, 0x20, 0x4D, 0x82, 0xB7, 0x15, 0xA8, 0x1A, 0x1C, 0xF9, 0x0A, 0x40, 0x6E, 0x02,
  0x06, 0xA0, 0xA2, 0x09, 0xE0, 0x86, 0x81, 0x3A, 0xEB, 0x02, 0x07, 0xA0, 0xB3, 0x84, 0x15, 0x77,
  0x51, 0x77, 0x07, 0xA0, 0xC7, 0x77, 0x20, 0x8A, 0x0D, 0x77, 0x72, 0x08, 0xB7, 0x77, 0x20, 0x9B,
  0x02, 0x77, 0x71, 0x09, 0xB0, 0x57, 0x77, 0x10, 0x9B, 0x0A, 0x77, 0x71, 0x09, 0xC0, 0x17, 0x77,
  0x08, 0xC0, 0xC7, 0x77, 0x06, 0xD8, 0x1D, 0x61, 0x77, 0x40, 0x3F, 0x05, 0x77, 0x50, 0xDE, 0x02,
  0x77, 0x50, 0x4D, 0x09, 0x77, 0x78, 0x34, 0xCF, 0xE8, 0x77, 0x60,
  // "¶" (U+00B6)
  0x48, 0x24, 0xAD, 0xEF, 0xFD, 0x09, 0x20, 0x10, 0xBF, 0xFF, 0xA0, 0x92, 0x0B, 0xFF, 0xF9, 0x83,
  0xB9, 0x40, 0x6F, 0xD8, 0x4B, 0x11, 0x11, 0x8B, 0x0A, 0x01, 0x40, 0xDF, 0xD0, 0xB4, 0x08, 0xB0,
  0x14, 0x03, 0xFE, 0x0B, 0x40, 0x8A, 0x0C, 0x50, 0x8F, 0xE0, 0xB4, 0x08, 0xA0, 0xB5, 0x0A, 0xFE,
  0x0B, 0x40, 0x8A, 0x0B, 0x50, 0xDF, 0xE0, 0xB4, 0x08, 0xA0, 0xB5, 0x0D, 0xFE, 0x0B, 0x40, 0x8A,
  0x0B, 0x50, 0xEF, 0xE0, 0xB4, 0x08, 0xA0, 0xB5, 0x0E, 0xFE, 0x0B, 0x40, 0x8A, 0x0B, 0x50, 0xDF,
  0xE0, 0xB4, 0x08, 0xA0, 0xB5, 0x0C, 0xFE, 0x0B, 0x40, 0x8A, 0x0B, 0x50, 0x9F, 0xE0, 0xB4, 0x08,
  0xA0, 0xB5, 0x06, 0xFE, 0x0B, 0x40, 0x8A, 0x0B, 0x50, 0x3F, 0xE0, 0xB4, 0x08, 0xA0, 0xB6, 0x0E,
  0xFD, 0x0B, 0x40, 0x8A, 0x0B, 0x60, 0x7F, 0xD0, 0xB4, 0x08, 0xA0, 0xB7, 0x0D, 0xFC, 0x0B, 0x40,
  0x8A, 0x0B, 0x70, 0x30, 0xEF, 0xB0, 0xB4, 0x08, 0xA0, 0xB7, 0x10, 0x20, 0xCF, 0xA0, 0xB4, 0x08,
  0xA0, 0xB7, 0x38, 0x53, 0x68, 0x88, 0x8B, 0xA0, 0xB4, 0x08, 0xA0, 0xB7, 0x72, 0x06, 0xA0, 0xB4,
  0x08, 0xA0, 0xB7, 0x72, 0x06, 0xA0, 0xB4, 0x08, 0xA0, 0xB7, 0x72, 0x06, 0xA0, 0xB4, 0x08, 0xA0,
  0xB7, 0x72, 0x06, 0xA0, 0xB4, 0x08, 0xA0, 0xB7, 0x72, 0x06, 0xA0, 0xB4, 0x08, 0xA0, 0xB7, 0x72,
  0x06, 0xA0, 0xB4, 0x08, 0xA0, 0xB7, 0x72, 0x06, 0xA0, 0xB4, 0x08, 0xA0, 0xB7, 0x72, 0x06, 0xA0,
  0xB4, 0x08, 0xA0, 0xB7, 0x72, 0x06, 0xA0, 0xB4, 0x08, 0xA0, 0xB7, 0x72, 0x06, 0xA0, 0xB4, 0x08,
  0xA0, 0xB7, 0x72, 0x06, 0xA0, 0xB4, 0x08, 0xA0, 0xB7, 0x72, 0x06, 0xA0, 0xB4, 0x08, 0xA0, 0xB7,
  0x72, 0x06, 0xA0, 0xB4, 0x08, 0xA0, 0xB7, 0x72, 0x06, 0xA0, 0xB4, 0x08, 0xA0, 0xB7, 0x72, 0x06,
  0xA0, 0xB4, 0x08, 0xA0, 0xB7, 0x72, 0x06, 0xA0, 0xB4, 0x08, 0xA0, 0xB7, 0x72, 0x06, 0xA0, 0xB4,
  0x08, 0xA0, 0xB7, 0x72, 0x06, 0xA0, 0xB4, 0x08, 0xA0, 0xB7, 0x72, 0x06, 0xA0, 0xB4, 0x08, 0xA0,
  0xB7, 0x72, 0x06, 0xA0, 0xB4, 0x08, 0xA0, 0xB7, 0x72, 0x06, 0xA0, 0xB4, 0x08, 0xA0, 0xB7, 0x72,
  0x06, 0xA0, 0xB4, 0x08, 0xA0, 0xB7, 0x72, 0x06, 0xA0, 0xB4, 0x08, 0xA0, 0xB7, 0x72, 0x07, 0xA0,
  0xB4, 0x08, 0xA0, 0xB7, 0x72, 0x0A, 0xA0, 0xB4, 0x08, 0xA0, 0xE7, 0x71, 0x02, 0x0E, 0xA0, 0xB4,
  0x08, 0xB0, 0x57, 0x48, 0x21, 0x37, 0xEB, 0x0B, 0x40, 0x8C, 0x81, 0x94, 0x27, 0x04, 0xF0, 0xB4,
  0x08, 0xF0, 0x96, 0x04, 0xF0, 0xB4, 0x08, 0xF0, 0x96, 0x04, 0xF0, 0xB4, 0x08, 0xF0, 0x90,
  // "·" (U+00B7)
  0x18, 0x54, 0xCE, 0xC5, 0x03, 0xD0, 0x50, 0x8D, 0x0B, 0x0A, 0xD0, 0xD0, 0xAD, 0x0D, 0x08, 0xD0,
  0xB0, 0x3D, 0x85, 0x50, 0x4C, 0xEC, 0x51,
  // "¸" (U+00B8)
  0x38, 0x22, 0x77, 0x17, 0x81, 0x6F, 0xE7, 0x18, 0x1A, 0xFC, 0x71, 0x83, 0xDF, 0xEA, 0x55, 0x01,
  0xD0, 0xC0, 0x14, 0x05, 0x0A, 0xC0, 0xC6, 0x03, 0x0E, 0xB0, 0x56, 0x07, 0xB0, 0x96, 0x04, 0xB0,
  0xA6, 0x06, 0xB0, 0x96, 0x0A, 0xB0, 0x70, 0x34, 0x07, 0xC0, 0x2A, 0x0E, 0x0D, 0xD0, 0x91, 0xF9,
  0x09, 0x28, 0x68, 0xBE, 0xFE, 0xD9, 0x33,
  // "¹" (U+00B9)
  0x60, 0x10, 0xAA, 0x0B, 0x73, 0x02, 0x0D, 0xB0, 0xB7, 0x20, 0x40, 0xEC, 0x0B, 0x70, 0x10, 0x9E,
  0x0B, 0x50, 0x50, 0xAB, 0x0B, 0x0A, 0xB0, 0xB5, 0x0A, 0xB8, 0x1B, 0x0A, 0xB0, 0xB5, 0x82, 0x2D,
  0xE8, 0x20, 0xAB, 0x0B, 0x74, 0x0A, 0xB0, 0xB7, 0x40, 0xAB, 0x0B, 0x74, 0x0A, 0xB0, 0xB7, 0x40,
  0xAB, 0x0B, 0x74, 0x0A, 0xB0, 0xB7, 0x40, 0xAB, 0x0B, 0x74, 0x0A, 0xB0, 0xB7, 0x40, 0xAB, 0x0B,
  0x74, 0x0A, 0xB0, 0xB7, 0x40, 0xAB, 0x0B, 0x74, 0x0A, 0xB0, 0xB7, 0x40, 0xAB, 0x0B, 0x74, 0x0A,
  0xB0, 0xB7, 0x40, 0xAB, 0x0B, 0x74, 0x0A, 0xB0, 0xB7, 0x40, 0xCB, 0x0D, 0x68, 0x33, 0x44, 0x59,
  0xD8, 0x5A, 0x54, 0x41, 0x0B, 0xFE, 0x81, 0x70, 0xBF, 0xE0, 0x70,
  // "º" (U+00BA)
  0x48, 0x73, 0x9C, 0xEF, 0xEB, 0x71, 0x70, 0xAB, 0x0E, 0x0D, 0xB0, 0xE0, 0x55, 0x0C, 0xA0, 0xE0,
  0x52, 0x01, 0x09, 0xB0, 0x73, 0x08, 0xB0, 0x65, 0x0B, 0xB0, 0x32, 0x0E, 0xA0, 0xE6, 0x04, 0xB8,
  0x1B, 0x05, 0xB0, 0xA7, 0xC0, 0x10, 0x9B, 0x08, 0x70, 0xCB, 0x05, 0x0C, 0xB0, 0x67, 0x0B, 0xB0,
  0x80, 0xDB, 0x05, 0x70, 0x9B, 0x09, 0x0E, 0xB0, 0x47, 0x09, 0xB0, 0xA0, 0xEB, 0x04, 0x70, 0x9B,
  0x0A, 0x0D, 0xB0, 0x57, 0x09, 0xB0, 0x90, 0xCB, 0x06, 0x70, 0xBB, 0x08, 0x09, 0xB0, 0x87, 0x0C,
  0xB0, 0x05, 0xB0, 0xB7, 0xC8, 0x11, 0x0E, 0xA0, 0xE6, 0x04, 0xB0, 0xB2, 0x07, 0xB0, 0x65, 0x0B,
  0xB0, 0x33, 0x0B, 0xB0, 0x52, 0x01, 0x09, 0xB0, 0x75, 0x09, 0xB0, 0xE0, 0xDB, 0x0E, 0x06, 0x78,
  0x73, 0x9C, 0xEF, 0xEB, 0x71, 0x40,
  // "»" (U+00BB)
  0x05, 0xA0, 0x46, 0x81, 0xDF, 0xB7, 0x28, 0x2D, 0xFE, 0x15, 0x06, 0xA0, 0x77, 0x10, 0x6A, 0x0B,
  0x60, 0xEA, 0x03, 0x71, 0x0E, 0xA0, 0x75, 0x07, 0xA0, 0xD0, 0x17, 0x07, 0xB0, 0x34, 0x01, 0x0E,
  0xA0, 0xA7, 0x01, 0x0E, 0xA0, 0xD0, 0x14, 0x08, 0xB0, 0x67, 0x09, 0xB0, 0xB4, 0x01, 0xC0, 0x26,
  0x02, 0xC0, 0x74, 0x0A, 0xB0, 0xD7, 0x0A, 0xC0, 0x33, 0x02, 0xC0, 0x96, 0x03, 0xC0, 0xD4, 0x0B,
  0xC0, 0x56, 0x0B, 0xC0, 0x93, 0x04, 0xC0, 0xE0, 0x15, 0x05, 0xC0, 0xC4, 0x0D, 0xC0, 0x35, 0x0A,
  0xC0, 0xA3, 0x03, 0xD0, 0x24, 0x02, 0xC0, 0xE0, 0x13, 0x0A, 0xC0, 0x75, 0x09, 0xC0, 0x43, 0x02,
  0xC0, 0xB5, 0x01, 0xC0, 0x84, 0x09, 0xB0, 0xD0, 0x15, 0x08, 0xB0, 0xC4, 0x01, 0xC0, 0x46, 0x0E,
  0xA0, 0xE0, 0x14, 0x08, 0xB0, 0x76, 0x07, 0xB0, 0x45, 0x0E, 0xA0, 0xB7, 0x0E, 0xA0, 0x85, 0x07,
  0xA0, 0xE0, 0x16, 0x06, 0xA0, 0xC6, 0x0D, 0xA0, 0x47, 0x82, 0xDF, 0xE1, 0x50, 0x6A, 0x08, 0x70,
  0x5A, 0x04, 0x68, 0x1D, 0xFC, 0x71,
  // "¼" (U+00BC)
  0x60, 0x10, 0xAA, 0x0B, 0x77, 0x30, 0x4B, 0x01, 0x77, 0x02, 0x0D, 0xB0, 0xB7, 0x73, 0x0A, 0xA0,
  0xA7, 0x70, 0x40, 0xEC, 0x0B, 0x77, 0x20, 0x1B, 0x03, 0x75, 0x01, 0x09, 0xE0, 0xB7, 0x72, 0x08,
  0xA0, 0xC7, 0x40, 0x50, 0xAB, 0x0B, 0x0A, 0xB0, 0xB7, 0x72, 0x0E, 0xA0, 0x67, 0x40, 0xAB, 0x81,
  0xB0, 0xAB, 0x0B, 0x77, 0x10, 0x5A, 0x0E, 0x75, 0x82, 0x2D, 0xE8, 0x20, 0xAB, 0x0B, 0x77, 0x10,
  0xCA, 0x08, 0x77, 0x40, 0xAB, 0x0B, 0x77, 0x03, 0xB0, 0x27, 0x74, 0x0A, 0xB0, 0xB7, 0x70, 0x9A,
  0x0B, 0x77, 0x50, 0xAB, 0x0B, 0x76, 0x01, 0xB0, 0x47, 0x75, 0x0A, 0xB0, 0xB7, 0x60, 0x7A, 0x0D,
  0x77, 0x60, 0xAB, 0x0B, 0x76, 0x0D, 0xA0, 0x77, 0x76, 0x0A, 0xB0, 0xB7, 0x50, 0x4B, 0x01, 0x77,
  0x60, 0xAB, 0x0B, 0x75, 0x0B, 0xA0, 0x97, 0x77, 0x0A, 0xB0, 0xB7, 0x40, 0x2B, 0x03, 0x77, 0x70,
  0xAB, 0x0B, 0x74, 0x08, 0xA0, 0xC7, 0x77, 0x10, 0xAB, 0x0B, 0x74, 0x0E, 0xA0, 0x57, 0x77, 0x10,
  0xAB, 0x0B, 0x73, 0x06, 0xA0, 0xE7, 0x07, 0xB0, 0xA7, 0x40, 0xAB, 0x0B, 0x73, 0x0C, 0xA0, 0x86,
  0x02, 0xC0, 0xA7, 0x40, 0xAB, 0x0B, 0x72, 0x03, 0xB0, 0x16, 0x0A, 0xC0, 0xA7, 0x40, 0xAB, 0x0B,
  0x72, 0x0A, 0xA0, 0xA6, 0x04, 0xD0, 0xA7, 0x40, 0xAB, 0x0B, 0x71, 0x01, 0xB0, 0x46, 0x81, 0xDF,
  0xAB, 0x0A, 0x74, 0x0C, 0xB0, 0xD7, 0x10, 0x8A, 0x0D, 0x68, 0x27, 0xFD, 0x6B, 0x0A, 0x68, 0x33,
  0x44, 0x59, 0xD8, 0x3A, 0x54, 0x41, 0x30, 0xEA, 0x06, 0x50, 0x2A, 0x04, 0x07, 0xB0, 0xA6, 0x0B,
  0xFE, 0x07, 0x20, 0x5A, 0x0E, 0x68, 0x3A, 0xFB, 0x07, 0xB0, 0xA6, 0x0B, 0xFE, 0x07, 0x20, 0xCA,
  0x09, 0x50, 0x4A, 0x81, 0x20, 0x7B, 0x0A, 0x77, 0x71, 0x03, 0xB0, 0x25, 0x81, 0xDF, 0x82, 0x07,
  0xB0, 0xA7, 0x77, 0x10, 0x9A, 0x0B, 0x58, 0x17, 0xFE, 0x30, 0x7B, 0x0A, 0x77, 0x70, 0x10, 0xEA,
  0x05, 0x48, 0x21, 0xEF, 0x53, 0x07, 0xB0, 0xA7, 0x77, 0x07, 0xA0, 0xD5, 0x81, 0xAF, 0xC4, 0x07,
  0xB0, 0xA7, 0x77, 0x0D, 0xA0, 0x74, 0x04, 0xA0, 0x34, 0x07, 0xB0, 0xA7, 0x76, 0x04, 0xB0, 0x14,
  0x81, 0xDF, 0x95, 0x07, 0xB0, 0xA7, 0x76, 0x0B, 0xA0, 0x94, 0x07, 0xA0, 0x58, 0x01, 0x40, 0x9B,
  0x0C, 0x80, 0x04, 0x77, 0x10, 0x2B, 0x03, 0x40, 0xEF, 0xFB, 0x02, 0x77, 0x08, 0xA0, 0xC5, 0xFF,
  0xC0, 0x27, 0x70, 0xEA, 0x05, 0x77, 0x07, 0xB0, 0xA7, 0x74, 0x06, 0xA0, 0xE7, 0x71, 0x07, 0xB0,
  0xA7, 0x74, 0x0C, 0xA0, 0x87, 0x71, 0x07, 0xB0, 0xA7, 0x73, 0x03, 0xB0, 0x27, 0x71, 0x07, 0xB0,
  0xB7, 0x73, 0x0A, 0xA0, 0xA7, 0x72, 0x09, 0xB0, 0xC7, 0x72, 0x01, 0xB0, 0x47, 0x58, 0x21, 0x44,
  0x7D, 0x81, 0x94, 0x47, 0x60, 0x7A, 0x0D, 0x76, 0x05, 0xFC, 0x76, 0x0D, 0xA0, 0x67, 0x60, 0x5F,
  0xC2,
  // "½" (U+00BD)
  0x60, 0x10, 0xAA, 0x0B, 0x77, 0x20, 0x4B, 0x01, 0x77, 0x02, 0x0D, 0xB0, 0xB7, 0x72, 0x0A, 0xA0,
  0xA7, 0x70, 0x40, 0xEC, 0x0B, 0x77, 0x10, 0x1B, 0x03, 0x75, 0x01, 0x09, 0xE0, 0xB7, 0x71, 0x08,
  0xA0, 0xC7, 0x40, 0x50, 0xAB, 0x0B, 0x0A, 0xB0, 0xB7, 0x71, 0x0E, 0xA0, 0x67, 0x40, 0xAB, 0x81,
  0xB0, 0xAB, 0x0B, 0x77, 0x05, 0xA0, 0xE7, 0x58, 0x22, 0xDE, 0x82, 0x0A, 0xB0, 0xB7, 0x70, 0xCA,
  0x08, 0x77, 0x40, 0xAB, 0x0B, 0x76, 0x03, 0xB0, 0x27, 0x74, 0x0A, 0xB0, 0xB7, 0x60, 0x9A, 0x0B,
  0x77, 0x50, 0xAB, 0x0B, 0x75, 0x01, 0xB0, 0x47, 0x75, 0x0A, 0xB0, 0xB7, 0x50, 0x7A, 0x0D, 0x77,
  0x60, 0xAB, 0x0B, 0x75, 0x0D, 0xA0, 0x77, 0x76, 0x0A, 0xB0, 0xB7, 0x40, 0x4B, 0x01, 0x77, 0x60,
  0xAB, 0x0B, 0x74, 0x0B, 0xA0, 0x97, 0x77, 0x0A, 0xB0, 0xB7, 0x30, 0x2B, 0x03, 0x77, 0x70, 0xAB,
  0x0B, 0x73, 0x08, 0xA0, 0xC7, 0x77, 0x10, 0xAB, 0x0B, 0x73, 0x0E, 0xA0, 0x55, 0x83, 0x13, 0x43,
  0x27, 0x50, 0xAB, 0x0B, 0x72, 0x06, 0xA0, 0xE4, 0x08, 0x0D, 0xD8, 0x1E, 0x92, 0x72, 0x0A, 0xB0,
  0xB7, 0x20, 0xCA, 0x08, 0x20, 0x20, 0xDF, 0xB0, 0x57, 0x10, 0xAB, 0x0B, 0x71, 0x03, 0xB0, 0x12,
  0x0D, 0xB8, 0x39, 0x20, 0x2B, 0xC0, 0x37, 0x0A, 0xB0, 0xB7, 0x10, 0xAA, 0x0A, 0x20, 0x5B, 0x0B,
  0x50, 0xEB, 0x0B, 0x70, 0xAB, 0x0B, 0x70, 0x1B, 0x04, 0x20, 0x8B, 0x04, 0x50, 0x8C, 0x01, 0x60,
  0xCB, 0x0D, 0x70, 0x8A, 0x0D, 0x30, 0x6B, 0x01, 0x50, 0x5C, 0x85, 0x30, 0x34, 0x45, 0x9D, 0x83,
  0xA5, 0x44, 0x12, 0x0E, 0xA0, 0x64, 0x0A, 0xA6, 0x03, 0xC8, 0x13, 0x0B, 0xFE, 0x81, 0x70, 0x5A,
  0x0E, 0x60, 0x10, 0x36, 0x04, 0xC8, 0x12, 0x0B, 0xFE, 0x81, 0x70, 0xCA, 0x09, 0x77, 0x05, 0xC7,
  0x73, 0x03, 0xB0, 0x27, 0x70, 0x8B, 0x0B, 0x77, 0x30, 0x9A, 0x0B, 0x77, 0x10, 0xDB, 0x04, 0x77,
  0x20, 0x10, 0xEA, 0x05, 0x77, 0x04, 0xB0, 0xB7, 0x73, 0x07, 0xA0, 0xD7, 0x71, 0x0C, 0xA0, 0xD0,
  0x17, 0x73, 0x0D, 0xA0, 0x77, 0x70, 0x7A, 0x0E, 0x03, 0x77, 0x30, 0x4B, 0x01, 0x76, 0x03, 0xB0,
  0x37, 0x74, 0x0B, 0xA0, 0x97, 0x68, 0x31, 0xDF, 0xE4, 0x77, 0x40, 0x2B, 0x03, 0x75, 0x83, 0x1C,
  0xFE, 0x37, 0x75, 0x08, 0xA0, 0xC7, 0x68, 0x2C, 0xFE, 0x37, 0x76, 0x0E, 0xA0, 0x57, 0x58, 0x2B,
  0xFE, 0x36, 0x06, 0x09, 0x75, 0x06, 0xA0, 0xE7, 0x58, 0x2A, 0xFE, 0x37, 0x0D, 0x0E, 0x75, 0x0C,
  0xA0, 0x87, 0x48, 0x29, 0xFE, 0x37, 0x81, 0x1F, 0xD7, 0x40, 0x3B, 0x02, 0x73, 0x82, 0x8F, 0xE3,
  0x78, 0x21, 0xAF, 0xD7, 0x40, 0xAA, 0x0A, 0x73, 0x07, 0xFF, 0x0D, 0x73, 0x01, 0xB0, 0x47, 0x3F,
  0xF9, 0x0C, 0x73, 0x07, 0xA0, 0xD7, 0x4F, 0xF9, 0x0C, 0x73, 0x0D, 0xA0, 0x67, 0x4F, 0xF9, 0x0C,
  // "¾" (U+00BE)
  0x48, 0x73, 0x9C, 0xEF, 0xED, 0xA5, 0x77, 0x77, 0x30, 0xAF, 0xA0, 0xD0, 0x37, 0x60, 0x4B, 0x01,
  0x73, 0x0B, 0xB8, 0x3B, 0x54, 0x7E, 0xB0, 0xE0, 0x27, 0x50, 0xAA, 0x0A, 0x73, 0x05, 0xB0, 0xA4,
  0x01, 0x0E, 0xB0, 0xB7, 0x40, 0x1B, 0x03, 0x73, 0x09, 0xB0, 0x35, 0x09, 0xC0, 0x17, 0x30, 0x8A,
  0x0C, 0x74, 0x0A, 0xA0, 0xE6, 0x05, 0xC0, 0x37, 0x30, 0xEA, 0x06, 0x74, 0x06, 0xA0, 0xC6, 0x04,
  0xC0, 0x37, 0x20, 0x5A, 0x0E, 0x76, 0x81, 0x6B, 0x96, 0x05, 0xC0, 0x27, 0x20, 0xCA, 0x08, 0x77,
  0x71, 0x08, 0xB0, 0xD7, 0x20, 0x3B, 0x02, 0x77, 0x71, 0x0D, 0xB0, 0x67, 0x20, 0x9A, 0x0B, 0x77,
  0x71, 0x08, 0xB0, 0x97, 0x20, 0x1B, 0x04, 0x77, 0x60, 0x30, 0xAB, 0x07, 0x73, 0x07, 0xA0, 0xD7,
  0x74, 0x0B, 0xD0, 0x90, 0x27, 0x40, 0xDA, 0x07, 0x77, 0x40, 0xBD, 0x81, 0xD9, 0x37, 0x20, 0x4B,
  0x01, 0x77, 0x48, 0x33, 0x44, 0x6A, 0xC0, 0xA0, 0x17, 0x0B, 0xA0, 0x97, 0x77, 0x30, 0x20, 0xDB,
  0x0C, 0x01, 0x50, 0x2B, 0x03, 0x77, 0x74, 0x03, 0xC0, 0x85, 0x08, 0xA0, 0xC7, 0x77, 0x60, 0xBB,
  0x0D, 0x50, 0xEA, 0x05, 0x77, 0x76, 0x08, 0xC4, 0x06, 0xA0, 0xE6, 0x07, 0xB0, 0xA6, 0x81, 0x18,
  0x57, 0x10, 0x8C, 0x01, 0x30, 0xCA, 0x08, 0x50, 0x2C, 0x0A, 0x68, 0x1C, 0xF9, 0x71, 0x09, 0xC3,
  0x03, 0xB0, 0x15, 0x0A, 0xC0, 0xA5, 0x01, 0xA0, 0xC7, 0x10, 0xBB, 0x0C, 0x30, 0xAA, 0x0A, 0x50,
  0x4D, 0x0A, 0x50, 0x2B, 0x03, 0x60, 0x2C, 0x07, 0x20, 0x1B, 0x04, 0x58, 0x1D, 0xFA, 0xB0, 0xA6,
  0x0E, 0xA0, 0xB5, 0x01, 0x0C, 0xB0, 0xE3, 0x08, 0xA0, 0xD5, 0x82, 0x7F, 0xD6, 0xB0, 0xA6, 0x07,
  0xB8, 0x4D, 0x74, 0x58, 0xEB, 0x0E, 0x03, 0x30, 0xEA, 0x06, 0x40, 0x2A, 0x04, 0x07, 0xB0, 0xA7,
  0x08, 0xFB, 0x0A, 0x02, 0x30, 0x5A, 0x0E, 0x58, 0x3A, 0xFB, 0x07, 0xB0, 0xA7, 0x18, 0x22, 0x8B,
  0xEA, 0x82, 0xEB, 0x82, 0x50, 0xCA, 0x09, 0x40, 0x4A, 0x81, 0x20, 0x7B, 0x0A, 0x77, 0x71, 0x03,
  0xB0, 0x24, 0x81, 0xDF, 0x82, 0x07, 0xB0, 0xA7, 0x77, 0x10, 0x9A, 0x0B, 0x48, 0x17, 0xFE, 0x30,
  0x7B, 0x0A, 0x77, 0x70, 0x10, 0xEA, 0x05, 0x38, 0x21, 0xEF, 0x53, 0x07, 0xB0, 0xA7, 0x77, 0x07,
  0xA0, 0xD4, 0x81, 0xAF, 0xC4, 0x07, 0xB0, 0xA7, 0x77, 0x0D, 0xA0, 0x73, 0x04, 0xA0, 0x34, 0x07,
  0xB0, 0xA7, 0x76, 0x04, 0xB0, 0x13, 0x81, 0xDF, 0x95, 0x07, 0xB0, 0xA7, 0x76, 0x0B, 0xA0, 0x93,
  0x07, 0xA0, 0x58, 0x01, 0x40, 0x9B, 0x0C, 0x80, 0x04, 0x77, 0x10, 0x2B, 0x03, 0x30, 0xEF, 0xFB,
  0x02, 0x77, 0x08, 0xA0, 0xC4, 0xFF, 0xC0, 0x27, 0x70, 0xEA, 0x05, 0x76, 0x07, 0xB0, 0xA7, 0x74,
  0x06, 0xA0, 0xE7, 0x70, 0x7B, 0x0A, 0x77, 0x40, 0xCA, 0x08, 0x77, 0x07, 0xB0, 0xA7, 0x73, 0x03,
  0xB0, 0x27, 0x70, 0x7B, 0x0B, 0x77, 0x30, 0xAA, 0x0A, 0x77, 0x10, 0x9B, 0x0C, 0x77, 0x20, 0x1B,
  0x04, 0x74, 0x82, 0x14, 0x47, 0xD8, 0x19, 0x44, 0x76, 0x07, 0xA0, 0xD7, 0x50, 0x5F, 0xC7, 0x60,
  0xDA, 0x06, 0x75, 0x05, 0xFC, 0x20,
  // "¿" (U+00BF)
  0x74, 0x81, 0x57, 0x47, 0x73, 0x02, 0x0D, 0xB0, 0xA7, 0x72, 0x09, 0xD0, 0x47, 0x71, 0x0D, 0xD0,
  0x87, 0x71, 0x0E, 0xD0, 0x97, 0x71, 0x0D, 0xD0, 0x87, 0x71, 0x09, 0xD0, 0x47, 0x71, 0x02, 0x0D,
  0xB0, 0xA7, 0x74, 0x81, 0x57, 0x48, 0x09, 0xC7, 0x08, 0x16, 0x64, 0x77, 0x40, 0x2A, 0x0C, 0x77,
  0x40, 0x3A, 0x0C, 0x77, 0x40, 0x4A, 0x0D, 0x77, 0x40, 0x5A, 0x0E, 0x77, 0x40, 0x6B, 0x77, 0x40,
  0x7B, 0x77, 0x30, 0x40, 0xCB, 0x01, 0x77, 0x02, 0x0B, 0xD0, 0x17, 0x60, 0x60, 0xEC, 0x0B, 0x03,
  0x76, 0x09, 0xD0, 0x67, 0x70, 0xAC, 0x0E, 0x03, 0x77, 0x09, 0xD0, 0x37, 0x70, 0x4D, 0x06, 0x77,
  0x10, 0xDC, 0x0D, 0x77, 0x10, 0x3D, 0x06, 0x77, 0x10, 0x9D, 0x01, 0x77, 0x10, 0xCC, 0x0B, 0x77,
  0x2D, 0x08, 0x77, 0x10, 0x1D, 0x06, 0x77, 0x10, 0x2D, 0x06, 0x77, 0x10, 0x1D, 0x05, 0x73, 0x82,
  0xAD, 0x92, 0x2D, 0x07, 0x73, 0x0B, 0xB8, 0x14, 0x0D, 0xC0, 0x97, 0x30, 0xDB, 0x81, 0xC0, 0x9C,
  0x0D, 0x72, 0x01, 0xC8, 0x1E, 0x04, 0xD0, 0x47, 0x10, 0x7C, 0x0D, 0x20, 0xCC, 0x0C, 0x70, 0x10,
  0xEC, 0x09, 0x20, 0x30, 0xEC, 0x0B, 0x01, 0x40, 0x20, 0xCD, 0x02, 0x30, 0x4E, 0x82, 0xB9, 0x9C,
  0xE0, 0x65, 0x02, 0x0D, 0xFD, 0x0E, 0x06, 0x71, 0x05, 0x0C, 0xF9, 0x81, 0xE8, 0x17, 0x48, 0x61,
  0x46, 0x77, 0x65, 0x26,
  // "À" (U+00C0)
  0x73, 0x04, 0x80, 0x17, 0x03, 0x77, 0x77, 0x20, 0x5D, 0x0B, 0x77, 0x77, 0x30, 0x9D, 0x03, 0x77,
  0x77, 0x30, 0xCC, 0x0A, 0x77, 0x77, 0x30, 0x10, 0xDC, 0x03, 0x77, 0x77, 0x30, 0x20, 0xDB, 0x0C,
  0x77, 0x77, 0x40, 0x20, 0xDB, 0x05, 0x77, 0x77, 0x40, 0x20, 0xDA, 0x0E, 0x01, 0x77, 0x77, 0x40,
  0x10, 0xCA, 0x09, 0x77, 0x77, 0x60, 0xAA, 0x01, 0x80, 0xAD, 0x70, 0x0E, 0xB0, 0xD7, 0x77, 0x73,
  0x04, 0xD0, 0x27, 0x77, 0x72, 0x09, 0xD0, 0x77, 0x77, 0x72, 0x0E, 0xD0, 0xC7, 0x77, 0x71, 0x03,
  0xF0, 0x17, 0x77, 0x70, 0x8F, 0x06, 0x77, 0x77, 0x0D, 0xA0, 0xAC, 0x0B, 0x77, 0x76, 0x03, 0xA0,
  0xC0, 0x5D, 0x01, 0x77, 0x75, 0x08, 0xA0, 0x90, 0x1D, 0x05, 0x77, 0x75, 0x0D, 0xA8, 0x15, 0x0D,
  0xC0, 0xA7, 0x77, 0x40, 0x2B, 0x81, 0x10, 0x9C, 0x0E, 0x77, 0x74, 0x07, 0xA0, 0xC2, 0x04, 0xD0,
  0x47, 0x77, 0x30, 0xCA, 0x08, 0x3D, 0x09, 0x77, 0x72, 0x01, 0xB0, 0x33, 0x0B, 0xC0, 0xE7, 0x77,
  0x20, 0x6A, 0x0E, 0x40, 0x7D, 0x03, 0x77, 0x71, 0x0B, 0xA0, 0xA4, 0x02, 0xD0, 0x87, 0x77, 0x01,
  0xB0, 0x55, 0x0D, 0xC0, 0xD7, 0x77, 0x06, 0xB0, 0x15, 0x09, 0xD0, 0x27, 0x76, 0x0B, 0xA0, 0xB6,
  0x04, 0xD0, 0x77, 0x76, 0xB0, 0x77, 0xD0, 0xC7, 0x75, 0x05, 0xB0, 0x27, 0x0B, 0xD0, 0x17, 0x74,
  0x0A, 0xA0, 0xD7, 0x10, 0x6D, 0x06, 0x77, 0x40, 0xEA, 0x08, 0x71, 0x02, 0xD0, 0xB7, 0x73, 0x04,
  0xB0, 0x47, 0x20, 0xDD, 0x77, 0x30, 0x9A, 0x0E, 0x73, 0x08, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0xA7,
  0x30, 0x4D, 0x0A, 0x77, 0x10, 0x4F, 0xFE, 0x0E, 0x77, 0x10, 0x9F, 0xFF, 0x04, 0x77, 0x0D, 0xB8,
  0x09, 0x1E, 0xD0, 0x97, 0x60, 0x3B, 0x05, 0x75, 0x01, 0xD0, 0xE7, 0x60, 0x8A, 0x0E, 0x77, 0x0B,
  0xD0, 0x37, 0x50, 0xDA, 0x0A, 0x77, 0x06, 0xD0, 0x87, 0x40, 0x2B, 0x05, 0x77, 0x01, 0xD0, 0xD7,
  0x40, 0x7B, 0x01, 0x77, 0x10, 0xCD, 0x02, 0x73, 0x0C, 0xA0, 0xB7, 0x72, 0x07, 0xD0, 0x77, 0x20,
  0x2B, 0x06, 0x77, 0x20, 0x3D, 0x0C, 0x72, 0x08, 0xB0, 0x37, 0x73, 0x0E, 0xD0, 0x17, 0x10, 0xEB,
  0x02, 0x77, 0x30, 0xCD, 0x06, 0x70, 0x7C, 0x06, 0x77, 0x30, 0xED, 0x0D, 0x48, 0x11, 0x27, 0xD8,
  0x2E, 0x72, 0x17, 0x38, 0x21, 0x14, 0xBF, 0x83, 0xB4, 0x20, 0xEF, 0xC0, 0xB7, 0x2F, 0xF0, 0x80,
  0xEF, 0xC0, 0xB7, 0x2F, 0xF0, 0x80, 0xEF, 0xC0, 0xB7, 0x2F, 0xF0, 0x80,
  // "Á" (U+00C1)
  0x77, 0x68, 0x02, 0x77, 0x77, 0x72, 0x04, 0xD0, 0xC7, 0x77, 0x72, 0x0B, 0xC0, 0xE0, 0x27, 0x77,
  0x71, 0x04, 0xD0, 0x47, 0x77, 0x72, 0x0C, 0xC0, 0x67, 0x77, 0x72, 0x05, 0xC0, 0x77, 0x77, 0x73,
  0x0E, 0xB0, 0x77, 0x77, 0x73, 0x08, 0xB0, 0x67, 0x77, 0x73, 0x02, 0xB0, 0x57, 0x77, 0x74, 0x82,
  0x8F, 0xE3, 0x80, 0xAE, 0x20, 0x0E, 0xB0, 0xD7, 0x77, 0x73, 0x04, 0xD0, 0x27, 0x77, 0x72, 0x09,
  0xD0, 0x77, 0x77, 0x72, 0x0E, 0xD0, 0xC7, 0x77, 0x71, 0x03, 0xF0, 0x17, 0x77, 0x70, 0x8F, 0x06,
  0x77, 0x77, 0x0D, 0xA0, 0xAC, 0x0B, 0x77, 0x76, 0x03, 0xA0, 0xC0, 0x5D, 0x01, 0x77, 0x75, 0x08,
  0xA0, 0x90, 0x1D, 0x05, 0x77, 0x75, 0x0D, 0xA8, 0x15, 0x0D, 0xC0, 0xA7, 0x77, 0x40, 0x2B, 0x81,
  0x10, 0x9C, 0x0E, 0x77, 0x74, 0x07, 0xA0, 0xC2, 0x04, 0xD0, 0x47, 0x77, 0x30, 0xCA, 0x08, 0x3D,
  0x09, 0x77, 0x72, 0x01, 0xB0, 0x33, 0x0B, 0xC0, 0xE7, 0x77, 0x20, 0x6A, 0x0E, 0x40, 0x7D, 0x03,
  0x77, 0x71, 0x0B, 0xA0, 0xA4, 0x02, 0xD0, 0x87, 0x77, 0x01, 0xB0, 0x55, 0x0D, 0xC0, 0xD7, 0x77,
  0x06, 0xB0, 0x15, 0x09, 0xD0, 0x27, 0x76, 0x0B, 0xA0, 0xB6, 0x04, 0xD0, 0x77, 0x76, 0xB0, 0x77,
  0xD0, 0xC7, 0x75, 0x05, 0xB0, 0x27, 0x0B, 0xD0, 0x17, 0x74, 0x0A, 0xA0, 0xD7, 0x10, 0x6D, 0x06,
  0x77, 0x40, 0xEA, 0x08, 0x71, 0x02, 0xD0, 0xB7, 0x73, 0x04, 0xB0, 0x47, 0x20, 0xDD, 0x77, 0x30,
  0x9A, 0x0E, 0x73, 0x08, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0xA7, 0x30, 0x4D, 0x0A, 0x77, 0x10, 0x4F,
  0xFE, 0x0E, 0x77, 0x10, 0x9F, 0xFF, 0x04, 0x77, 0x0D, 0xB8, 0x09, 0x1E, 0xD0, 0x97, 0x60, 0x3B,
  0x05, 0x75, 0x01, 0xD0, 0xE7, 0x60, 0x8A, 0x0E, 0x77, 0x0B, 0xD0, 0x37, 0x50, 0xDA, 0x0A, 0x77,
  0x06, 0xD0, 0x87, 0x40, 0x2B, 0x05, 0x77, 0x01, 0xD0, 0xD7, 0x40, 0x7B, 0x01, 0x77, 0x10, 0xCD,
  0x02, 0x73, 0x0C, 0xA0, 0xB7, 0x72, 0x07, 0xD0, 0x77, 0x20, 0x2B, 0x06, 0x77, 0x20, 0x3D, 0x0C,
  0x72, 0x08, 0xB0, 0x37, 0x73, 0x0E, 0xD0, 0x17, 0x10, 0xEB, 0x02, 0x77, 0x30, 0xCD, 0x06, 0x70,
  0x7C, 0x06, 0x77, 0x30, 0xED, 0x0D, 0x48, 0x11, 0x27, 0xD8, 0x2E, 0x72, 0x17, 0x38, 0x21, 0x14,
  0xBF, 0x83, 0xB4, 0x20, 0xEF, 0xC0, 0xB7, 0x2F, 0xF0, 0x80, 0xEF, 0xC0, 0xB7, 0x2F, 0xF0, 0x80,
  0xEF, 0xC0, 0xB7, 0x2F, 0xF0, 0x80,
  // "Â" (U+00C2)
  0x77, 0x10, 0x38, 0x01, 0x77, 0x77, 0x73, 0x0C, 0xD0, 0x47, 0x77, 0x71, 0x05, 0xE0, 0xC7, 0x77,
  0x71, 0x0D, 0xF0, 0x57, 0x77, 0x60, 0x8B, 0x0C, 0x07, 0xB0, 0xD7, 0x77, 0x50, 0x2B, 0x82, 0xE2,
  0x09, 0xB0, 0x87, 0x77, 0x40, 0xBA, 0x0E, 0x03, 0x30, 0xBB, 0x02, 0x77, 0x72, 0x06, 0xA0, 0xE0,
  0x45, 0x0B, 0xA0, 0xC7, 0x77, 0x18, 0x32, 0xEF, 0xE4, 0x70, 0xBA, 0x08, 0x77, 0x78, 0x28, 0xFE,
  0x37, 0x20, 0xAA, 0x80, 0xAD, 0x30, 0x0E, 0xB0, 0xD7, 0x77, 0x73, 0x04, 0xD0, 0x27, 0x77, 0x72,
  0x09, 0xD0, 0x77, 0x77, 0x72, 0x0E, 0xD0, 0xC7, 0x77, 0x71, 0x03, 0xF0, 0x17, 0x77, 0x70, 0x8F,
  0x06, 0x77, 0x77, 0x0D, 0xA0, 0xAC, 0x0B, 0x77, 0x76, 0x03, 0xA0, 0xC0, 0x5D, 0x01, 0x77, 0x75,
  0x08, 0xA0, 0x90, 0x1D, 0x05, 0x77, 0x75, 0x0D, 0xA8, 0x15, 0x0D, 0xC0, 0xA7, 0x77, 0x40, 0x2B,
  0x81, 0x10, 0x9C, 0x0E, 0x77, 0x74, 0x07, 0xA0, 0xC2, 0x04, 0xD0, 0x47, 0x77, 0x30, 0xCA, 0x08,
  0x3D, 0x09, 0x77, 0x72, 0x01, 0xB0, 0x33, 0x0B, 0xC0, 0xE7, 0x77, 0x20, 0x6A, 0x0E, 0x40, 0x7D,
  0x03, 0x77, 0x71, 0x0B, 0xA0, 0xA4, 0x02, 0xD0, 0x87, 0x77, 0x01, 0xB0, 0x55, 0x0D, 0xC0, 0xD7,
  0x77, 0x06, 0xB0, 0x15, 0x09, 0xD0, 0x27, 0x76, 0x0B, 0xA0, 0xB6, 0x04, 0xD0, 0x77, 0x76, 0xB0,
  0x77, 0xD0, 0xC7, 0x75, 0x05, 0xB0, 0x27, 0x0B, 0xD0, 0x17, 0x74, 0x0A, 0xA0, 0xD7, 0x10, 0x6D,
  0x06, 0x77, 0x40, 0xEA, 0x08, 0x71, 0x02, 0xD0, 0xB7, 0x73, 0x04, 0xB0, 0x47, 0x20, 0xDD, 0x77,
  0x30, 0x9A, 0x0E, 0x73, 0x08, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0xA7, 0x30, 0x4D, 0x0A, 0x77, 0x10,
  0x4F, 0xFE, 0x0E, 0x77, 0x10, 0x9F, 0xFF, 0x04, 0x77, 0x0D, 0xB8, 0x09, 0x1E, 0xD0, 0x97, 0x60,
  0x3B, 0x05, 0x75, 0x01, 0xD0, 0xE7, 0x60, 0x8A, 0x0E, 0x77, 0x0B, 0xD0, 0x37, 0x50, 0xDA, 0x0A,
  0x77, 0x06, 0xD0, 0x87, 0x40, 0x2B, 0x05, 0x77, 0x01, 0xD0, 0xD7, 0x40, 0x7B, 0x01, 0x77, 0x10,
  0xCD, 0x02, 0x73, 0x0C, 0xA0, 0xB7, 0x72, 0x07, 0xD0, 0x77, 0x20, 0x2B, 0x06, 0x77, 0x20, 0x3D,
  0x0C, 0x72, 0x08, 0xB0, 0x37, 0x73, 0x0E, 0xD0, 0x17, 0x10, 0xEB, 0x02, 0x77, 0x30, 0xCD, 0x06,
  0x70, 0x7C, 0x06, 0x77, 0x30, 0xED, 0x0D, 0x48, 0x11, 0x27, 0xD8, 0x2E, 0x72, 0x17, 0x38, 0x21,
  0x14, 0xBF, 0x83, 0xB4, 0x20, 0xEF, 0xC0, 0xB7, 0x2F, 0xF0, 0x80, 0xEF, 0xC0, 0xB7, 0x2F, 0xF0,
  0x80, 0xEF, 0xC0, 0xB7, 0x2F, 0xF0, 0x80,
  // "Ã" (U+00C3)
  0x75, 0x84, 0x4B, 0xEE, 0xB5, 0x78, 0x12, 0x55, 0x77, 0x60, 0x5E, 0x0A, 0x01, 0x58, 0x19, 0xFE,
  0x77, 0x50, 0x2F, 0x90, 0xD0, 0x34, 0x81, 0xEF, 0xC7, 0x75, 0x0A, 0xFB, 0x82, 0x71, 0x19, 0xA0,
  0x87, 0x75, 0xA8, 0x3D, 0x30, 0x4D, 0xFB, 0x02, 0x77, 0x40, 0x4A, 0x05, 0x40, 0x9F, 0x90, 0xA7,
  0x75, 0x07, 0xA0, 0x15, 0x05, 0x0E, 0xD0, 0xD0, 0x17, 0x75, 0x81, 0x36, 0x57, 0x85, 0x19, 0xDF,
  0xD8, 0x18, 0x0A, 0xD3, 0x00, 0xEB, 0x0D, 0x77, 0x77, 0x30, 0x4D, 0x02, 0x77, 0x77, 0x20, 0x9D,
  0x07, 0x77, 0x77, 0x20, 0xED, 0x0C, 0x77, 0x77, 0x10, 0x3F, 0x01, 0x77, 0x77, 0x08, 0xF0, 0x67,
  0x77, 0x70, 0xDA, 0x0A, 0xC0, 0xB7, 0x77, 0x60, 0x3A, 0x0C, 0x05, 0xD0, 0x17, 0x77, 0x50, 0x8A,
  0x09, 0x01, 0xD0, 0x57, 0x77, 0x50, 0xDA, 0x81, 0x50, 0xDC, 0x0A, 0x77, 0x74, 0x02, 0xB8, 0x11,
  0x09, 0xC0, 0xE7, 0x77, 0x40, 0x7A, 0x0C, 0x20, 0x4D, 0x04, 0x77, 0x73, 0x0C, 0xA0, 0x83, 0xD0,
  0x97, 0x77, 0x20, 0x1B, 0x03, 0x30, 0xBC, 0x0E, 0x77, 0x72, 0x06, 0xA0, 0xE4, 0x07, 0xD0, 0x37,
  0x77, 0x10, 0xBA, 0x0A, 0x40, 0x2D, 0x08, 0x77, 0x70, 0x1B, 0x05, 0x50, 0xDC, 0x0D, 0x77, 0x70,
  0x6B, 0x01, 0x50, 0x9D, 0x02, 0x77, 0x60, 0xBA, 0x0B, 0x60, 0x4D, 0x07, 0x77, 0x6B, 0x07, 0x7D,
  0x0C, 0x77, 0x50, 0x5B, 0x02, 0x70, 0xBD, 0x01, 0x77, 0x40, 0xAA, 0x0D, 0x71, 0x06, 0xD0, 0x67,
  0x74, 0x0E, 0xA0, 0x87, 0x10, 0x2D, 0x0B, 0x77, 0x30, 0x4B, 0x04, 0x72, 0x0D, 0xD7, 0x73, 0x09,
  0xA0, 0xE7, 0x30, 0x8D, 0x05, 0x77, 0x20, 0xEA, 0x0A, 0x73, 0x04, 0xD0, 0xA7, 0x71, 0x04, 0xFF,
  0xE0, 0xE7, 0x71, 0x09, 0xFF, 0xF0, 0x47, 0x70, 0xDB, 0x80, 0x91, 0xED, 0x09, 0x76, 0x03, 0xB0,
  0x57, 0x50, 0x1D, 0x0E, 0x76, 0x08, 0xA0, 0xE7, 0x70, 0xBD, 0x03, 0x75, 0x0D, 0xA0, 0xA7, 0x70,
  0x6D, 0x08, 0x74, 0x02, 0xB0, 0x57, 0x70, 0x1D, 0x0D, 0x74, 0x07, 0xB0, 0x17, 0x71, 0x0C, 0xD0,
  0x27, 0x30, 0xCA, 0x0B, 0x77, 0x20, 0x7D, 0x07, 0x72, 0x02, 0xB0, 0x67, 0x72, 0x03, 0xD0, 0xC7,
  0x20, 0x8B, 0x03, 0x77, 0x30, 0xED, 0x01, 0x71, 0x0E, 0xB0, 0x27, 0x73, 0x0C, 0xD0, 0x67, 0x07,
  0xC0, 0x67, 0x73, 0x0E, 0xD0, 0xD4, 0x81, 0x12, 0x7D, 0x82, 0xE7, 0x21, 0x73, 0x82, 0x11, 0x4B,
  0xF8, 0x3B, 0x42, 0x0E, 0xFC, 0x0B, 0x72, 0xFF, 0x08, 0x0E, 0xFC, 0x0B, 0x72, 0xFF, 0x08, 0x0E,
  0xFC, 0x0B, 0x72, 0xFF, 0x08,
  // "Ä" (U+00C4)
  0x74, 0x82, 0x8E, 0xE8, 0x58, 0x33, 0xCE, 0xC3, 0x77, 0x71, 0x05, 0xC0, 0x74, 0x0E, 0xB0, 0xE7,
  0x77, 0x10, 0x9C, 0x0B, 0x30, 0x2D, 0x02, 0x77, 0x70, 0x9C, 0x0B, 0x30, 0x2D, 0x02, 0x77, 0x70,
  0x5C, 0x08, 0x40, 0xEB, 0x0E, 0x77, 0x72, 0x82, 0x8E, 0xE9, 0x58, 0x34, 0xCE, 0xC3, 0x80, 0xBE,
  0x60, 0x0E, 0xB0, 0xD7, 0x77, 0x73, 0x04, 0xD0, 0x27, 0x77, 0x72, 0x09, 0xD0, 0x77, 0x77, 0x72,
  0x0E, 0xD0, 0xC7, 0x77, 0x71, 0x03, 0xF0, 0x17, 0x77, 0x70, 0x8F, 0x06, 0x77, 0x77, 0x0D, 0xA0,
  0xAC, 0x0B, 0x77, 0x76, 0x03, 0xA0, 0xC0, 0x5D, 0x01, 0x77, 0x75, 0x08, 0xA0, 0x90, 0x1D, 0x05,
  0x77, 0x75, 0x0D, 0xA8, 0x15, 0x0D, 0xC0, 0xA7, 0x77, 0x40, 0x2B, 0x81, 0x10, 0x9C, 0x0E, 0x77,
  0x74, 0x07, 0xA0, 0xC2, 0x04, 0xD0, 0x47, 0x77, 0x30, 0xCA, 0x08, 0x3D, 0x09, 0x77, 0x72, 0x01,
  0xB0, 0x33, 0x0B, 0xC0, 0xE7, 0x77, 0x20, 0x6A, 0x0E, 0x40, 0x7D, 0x03, 0x77, 0x71, 0x0B, 0xA0,
  0xA4, 0x02, 0xD0, 0x87, 0x77, 0x01, 0xB0, 0x55, 0x0D, 0xC0, 0xD7, 0x77, 0x06, 0xB0, 0x15, 0x09,
  0xD0, 0x27, 0x76, 0x0B, 0xA0, 0xB6, 0x04, 0xD0, 0x77, 0x76, 0xB0, 0x77, 0xD0, 0xC7, 0x75, 0x05,
  0xB0, 0x27, 0x0B, 0xD0, 0x17, 0x74, 0x0A, 0xA0, 0xD7, 0x10, 0x6D, 0x06, 0x77, 0x40, 0xEA, 0x08,
  0x71, 0x02, 0xD0, 0xB7, 0x73, 0x04, 0xB0, 0x47, 0x20, 0xDD, 0x77, 0x30, 0x9A, 0x0E, 0x73, 0x08,
  0xD0, 0x57, 0x72, 0x0E, 0xA0, 0xA7, 0x30, 0x4D, 0x0A, 0x77, 0x10, 0x4F, 0xFE, 0x0E, 0x77, 0x10,
  0x9F, 0xFF, 0x04, 0x77, 0x0D, 0xB8, 0x09, 0x1E, 0xD0, 0x97, 0x60, 0x3B, 0x05, 0x75, 0x01, 0xD0,
  0xE7, 0x60, 0x8A, 0x0E, 0x77, 0x0B, 0xD0, 0x37, 0x50, 0xDA, 0x0A, 0x77, 0x06, 0xD0, 0x87, 0x40,
  0x2B, 0x05, 0x77, 0x01, 0xD0, 0xD7, 0x40, 0x7B, 0x01, 0x77, 0x10, 0xCD, 0x02, 0x73, 0x0C, 0xA0,
  0xB7, 0x72, 0x07, 0xD0, 0x77, 0x20, 0x2B, 0x06, 0x77, 0x20, 0x3D, 0x0C, 0x72, 0x08, 0xB0, 0x37,
  0x73, 0x0E, 0xD0, 0x17, 0x10, 0xEB, 0x02, 0x77, 0x30, 0xCD, 0x06, 0x70, 0x7C, 0x06, 0x77, 0x30,
  0xED, 0x0D, 0x48, 0x11, 0x27, 0xD8, 0x2E, 0x72, 0x17, 0x38, 0x21, 0x14, 0xBF, 0x83, 0xB4, 0x20,
  0xEF, 0xC0, 0xB7, 0x2F, 0xF0, 0x80, 0xEF, 0xC0, 0xB7, 0x2F, 0xF0, 0x80, 0xEF, 0xC0, 0xB7, 0x2F,
  0xF0, 0x80,
  // "Å" (U+00C5)
  0x77, 0x10, 0x50, 0xCA, 0x81, 0xEA, 0x37, 0x77, 0x71, 0x0A, 0xF0, 0x77, 0x77, 0x60, 0x9F, 0xA0,
  0x57, 0x77, 0x40, 0x2B, 0x83, 0x82, 0x03, 0xBA, 0x0D, 0x77, 0x74, 0x07, 0xA0, 0x75, 0x0B, 0xA0,
  0x37, 0x77, 0x30, 0xAA, 0x01, 0x50, 0x5A, 0x06, 0x77, 0x73, 0x0B, 0xA6, 0x02, 0xA0, 0x87, 0x77,
  0x30, 0xBA, 0x60, 0x3A, 0x07, 0x77, 0x73, 0x09, 0xA0, 0x15, 0x05, 0xA0, 0x67, 0x77, 0x30, 0x6A,
  0x07, 0x50, 0xBA, 0x03, 0x77, 0x73, 0x01, 0xB8, 0x38, 0x20, 0x3B, 0xA0, 0xD7, 0x77, 0x50, 0x8F,
  0xA0, 0x47, 0x77, 0x60, 0x9F, 0x06, 0x77, 0x77, 0x10, 0x9D, 0x08, 0x77, 0x77, 0x20, 0xDD, 0x0C,
  0x77, 0x77, 0x10, 0x2F, 0x01, 0x77, 0x77, 0x07, 0xA0, 0xEC, 0x06, 0x77, 0x77, 0x0C, 0xA0, 0x8C,
  0x0B, 0x77, 0x76, 0x02, 0xA0, 0xB0, 0x4D, 0x01, 0x77, 0x75, 0x07, 0xA8, 0x17, 0x0E, 0xC0, 0x57,
  0x77, 0x50, 0xCA, 0x81, 0x30, 0xBC, 0x0A, 0x77, 0x74, 0x01, 0xA0, 0xE2, 0x06, 0xC0, 0xE7, 0x77,
  0x40, 0x6A, 0x0A, 0x20, 0x2D, 0x04, 0x77, 0x73, 0x0B, 0xA0, 0x53, 0x0D, 0xC0, 0x97, 0x77, 0x20,
  0x1B, 0x01, 0x30, 0x9C, 0x0E, 0x77, 0x72, 0x06, 0xA0, 0xC4, 0x04, 0xD0, 0x37, 0x77, 0x10, 0xBA,
  0x08, 0x5D, 0x08, 0x77, 0x71, 0xB0, 0x35, 0x0B, 0xC0, 0xD7, 0x77, 0x05, 0xA0, 0xE6, 0x07, 0xD0,
  0x27, 0x76, 0x0A, 0xA0, 0xA6, 0x03, 0xD0, 0x77, 0x76, 0x0E, 0xA0, 0x57, 0x0E, 0xC0, 0xB7, 0x75,
  0x05, 0xB0, 0x17, 0x0A, 0xD0, 0x17, 0x74, 0x0A, 0xA0, 0xC7, 0x10, 0x5D, 0x06, 0x77, 0x40, 0xEA,
  0x08, 0x71, 0x01, 0xD0, 0xA7, 0x73, 0x04, 0xB0, 0x37, 0x20, 0xCD, 0x77, 0x30, 0x9A, 0x0E, 0x73,
  0x08, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0xA7, 0x30, 0x4D, 0x09, 0x77, 0x10, 0x3F, 0xFE, 0x0E, 0x77,
  0x10, 0x8F, 0xFF, 0x03, 0x77, 0x0D, 0xB8, 0x09, 0x1E, 0xD0, 0x87, 0x60, 0x3B, 0x05, 0x75, 0x01,
  0xD0, 0xD7, 0x60, 0x8A, 0x0E, 0x77, 0x0B, 0xD0, 0x27, 0x50, 0xDA, 0x0A, 0x77, 0x06, 0xD0, 0x77,
  0x40, 0x2B, 0x05, 0x77, 0x01, 0xD0, 0xC7, 0x40, 0x7B, 0x01, 0x77, 0x10, 0xCD, 0x01, 0x73, 0x0C,
  0xA0, 0xB7, 0x72, 0x07, 0xD0, 0x67, 0x20, 0x2B, 0x06, 0x77, 0x20, 0x2D, 0x0B, 0x72, 0x08, 0xB0,
  0x37, 0x73, 0x0E, 0xD0, 0x17, 0x10, 0xEB, 0x02, 0x77, 0x30, 0xCD, 0x06, 0x70, 0x7C, 0x06, 0x77,
  0x30, 0xED, 0x0D, 0x48, 0x11, 0x27, 0xD8, 0x2E, 0x72, 0x17, 0x38, 0x21, 0x13, 0xBF, 0x83, 0xC4,
  0x10, 0xEF, 0xC0, 0xB7, 0x2F, 0xF0, 0x80, 0xEF, 0xC0, 0xB7, 0x2F, 0xF0, 0x80, 0xEF, 0xC0, 0xB7,
  0x2F, 0xF0, 0x80,
  // "Æ" (U+00C6)
  0x77, 0x30, 0xEF, 0xFF, 0xF7, 0x75, 0x0E, 0xFF, 0xFF, 0x77, 0x58, 0x27, 0x89, 0xBF, 0xA8, 0x05,
  0xEF, 0x77, 0x71, 0x06, 0xA0, 0xB0, 0x6D, 0x03, 0x72, 0x04, 0x0D, 0xC0, 0x17, 0x77, 0x0D, 0xA0,
  0x50, 0x6D, 0x03, 0x73, 0x01, 0x0E, 0xB0, 0x17, 0x76, 0x04, 0xA8, 0x1D, 0x06, 0xD0, 0x37, 0x40,
  0x7B, 0x01, 0x77, 0x60, 0xBA, 0x81, 0x70, 0x6D, 0x03, 0x74, 0x01, 0xB0, 0x27, 0x75, 0x03, 0xB8,
  0x11, 0x06, 0xD0, 0x37, 0x50, 0xDA, 0x02, 0x77, 0x50, 0xAA, 0x09, 0x20, 0x6D, 0x03, 0x75, 0x0B,
  0xA0, 0x27, 0x74, 0x01, 0xB0, 0x32, 0x06, 0xD0, 0x37, 0x50, 0xAA, 0x03, 0x77, 0x40, 0x8A, 0x0C,
  0x30, 0x6D, 0x03, 0x75, 0x82, 0x36, 0x61, 0x77, 0x30, 0x10, 0xEA, 0x05, 0x30, 0x6D, 0x03, 0x77,
  0x77, 0x50, 0x7A, 0x0E, 0x40, 0x6D, 0x03, 0x77, 0x77, 0x50, 0xDA, 0x07, 0x40, 0x6D, 0x03, 0x77,
  0x77, 0x40, 0x5B, 0x01, 0x40, 0x6D, 0x03, 0x77, 0x77, 0x40, 0xCA, 0x0A, 0x50, 0x6D, 0x03, 0x77,
  0x77, 0x30, 0x4B, 0x03, 0x50, 0x6D, 0x03, 0x77, 0x77, 0x30, 0xBA, 0x0C, 0x60, 0x6D, 0x03, 0x77,
  0x77, 0x20, 0x2B, 0x05, 0x60, 0x6D, 0x04, 0x80, 0x71, 0x77, 0x50, 0x9A, 0x0E, 0x70, 0x6F, 0xFB,
  0x09, 0x77, 0x30, 0x1B, 0x08, 0x70, 0x6F, 0xFB, 0x09, 0x77, 0x30, 0x7B, 0x01, 0x70, 0x6F, 0xFB,
  0x09, 0x77, 0x30, 0xEA, 0x0A, 0x71, 0x06, 0xD0, 0x37, 0x77, 0x70, 0x6B, 0x04, 0x71, 0x06, 0xD0,
  0x37, 0x77, 0x70, 0xDA, 0x0D, 0x72, 0x06, 0xD0, 0x37, 0x77, 0x60, 0x4B, 0x06, 0x72, 0x06, 0xD0,
  0x37, 0x77, 0x60, 0xBF, 0xFD, 0x03, 0x77, 0x75, 0x03, 0xFF, 0xE0, 0x37, 0x77, 0x50, 0xAB, 0x80,
  0x7E, 0xE0, 0x37, 0x77, 0x40, 0x1B, 0x08, 0x74, 0x06, 0xD0, 0x37, 0x77, 0x40, 0x8B, 0x01, 0x74,
  0x06, 0xD0, 0x37, 0x77, 0x40, 0xEA, 0x0A, 0x75, 0x06, 0xD0, 0x37, 0x77, 0x30, 0x7B, 0x03, 0x75,
  0x06, 0xD0, 0x37, 0x78, 0x12, 0x33, 0x70, 0xDA, 0x0B, 0x76, 0x06, 0xD0, 0x37, 0x78, 0x1E, 0xFE,
  0x60, 0x5B, 0x04, 0x76, 0x06, 0xD0, 0x37, 0x60, 0x1A, 0x0E, 0x60, 0xCA, 0x0D, 0x77, 0x06, 0xD0,
  0x37, 0x60, 0x4A, 0x0D, 0x50, 0x4B, 0x08, 0x77, 0x07, 0xD0, 0x37, 0x60, 0x8A, 0x0D, 0x50, 0xDB,
  0x05, 0x77, 0x08, 0xD0, 0x37, 0x60, 0xDA, 0x0C, 0x40, 0x9C, 0x07, 0x77, 0x0D, 0xD0, 0x37, 0x50,
  0x8B, 0x83, 0xC0, 0x13, 0xAD, 0x82, 0xE6, 0x21, 0x78, 0x21, 0x26, 0xCE, 0x03, 0x73, 0x02, 0x09,
  0xC0, 0xB0, 0x1F, 0xD0, 0x75, 0x04, 0xFB, 0x80, 0x6E, 0xF0, 0xB0, 0x1F, 0xD0, 0x75, 0x04, 0xFF,
  0xFE, 0x0A, 0x01, 0xFD, 0x07, 0x50, 0x4F, 0xFF, 0xE0, 0x90,
  // "Ç" (U+00C7)
  0x77, 0x86, 0x35, 0x67, 0x66, 0x41, 0x77, 0x38, 0x11, 0x6C, 0xFA, 0x81, 0xC7, 0x17, 0x60, 0x70,
  0xEF, 0xE0, 0xE0, 0x57, 0x30, 0x20, 0xCD, 0x84, 0xEB, 0x99, 0xBE, 0xE0, 0x77, 0x10, 0x30, 0xEC,
  0x0C, 0x04, 0x60, 0x8E, 0x04, 0x60, 0x20, 0xEC, 0x09, 0x72, 0x07, 0xD0, 0xB6, 0x0D, 0xC0, 0xA7,
  0x40, 0xBD, 0x50, 0x8C, 0x0E, 0x01, 0x74, 0x04, 0xD0, 0x13, 0x02, 0xD0, 0x77, 0x60, 0xEB, 0x0E,
  0x40, 0x9D, 0x01, 0x76, 0x0B, 0xB0, 0x73, 0x01, 0xD0, 0xA7, 0x78, 0x29, 0xFE, 0x74, 0x06, 0xD0,
  0x57, 0x70, 0x30, 0x46, 0x0B, 0xD0, 0x17, 0x77, 0x01, 0xD0, 0xE7, 0x77, 0x10, 0x4D, 0x0A, 0x77,
  0x71, 0x07, 0xD0, 0x87, 0x77, 0x10, 0xAD, 0x06, 0x77, 0x71, 0x0C, 0xD0, 0x47, 0x77, 0x10, 0xED,
  0x03, 0x77, 0x71, 0xE0, 0x27, 0x77, 0x1E, 0x02, 0x77, 0x70, 0x1E, 0x01, 0x77, 0x70, 0x1E, 0x01,
  0x77, 0x70, 0x1E, 0x01, 0x77, 0x71, 0xE0, 0x27, 0x77, 0x1E, 0x02, 0x77, 0x71, 0x0E, 0xD0, 0x37,
  0x77, 0x10, 0xCD, 0x04, 0x77, 0x71, 0x0A, 0xD0, 0x67, 0x77, 0x10, 0x7D, 0x08, 0x77, 0x71, 0x04,
  0xD0, 0xB7, 0x77, 0x10, 0x1D, 0x0E, 0x77, 0x72, 0x0C, 0xD0, 0x27, 0x77, 0x10, 0x7D, 0x06, 0x77,
  0x71, 0x02, 0xD0, 0xC7, 0x77, 0x20, 0xAD, 0x03, 0x77, 0x71, 0x03, 0xD0, 0x97, 0x72, 0x04, 0x07,
  0x50, 0xAD, 0x03, 0x77, 0x81, 0x2E, 0xD5, 0x01, 0x0E, 0xC0, 0xD0, 0x17, 0x58, 0x22, 0xDF, 0xE6,
  0x04, 0xD0, 0xC0, 0x17, 0x30, 0x30, 0xEA, 0x0A, 0x70, 0x5D, 0x81, 0xE7, 0x16, 0x02, 0x08, 0xB0,
  0xE0, 0x27, 0x10, 0x40, 0xEE, 0x84, 0xCA, 0x99, 0xAD, 0xC0, 0xE0, 0x47, 0x30, 0x10, 0xBF, 0xF0,
  0xC0, 0x27, 0x68, 0x13, 0x9E, 0xF9, 0x81, 0xEA, 0x47, 0x74, 0x02, 0x05, 0xB8, 0x16, 0x53, 0x77,
  0x71, 0x01, 0xA0, 0x90, 0x17, 0x77, 0x30, 0x5C, 0x0C, 0x03, 0x77, 0x71, 0x07, 0xE0, 0x47, 0x77,
  0x20, 0x70, 0xEB, 0x0D, 0x77, 0x73, 0x05, 0xC0, 0x37, 0x77, 0x30, 0xEB, 0x06, 0x77, 0x73, 0x0C,
  0xB0, 0x67, 0x77, 0x30, 0xEB, 0x05, 0x77, 0x72, 0x05, 0xC0, 0x27, 0x73, 0x84, 0x35, 0x31, 0x27,
  0xC0, 0xC7, 0x74, 0x06, 0xFA, 0x03, 0x77, 0x40, 0x6F, 0x0E, 0x05, 0x77, 0x58, 0x72, 0x9C, 0xEF,
  0xEC, 0x81, 0x72,
  // "È" (U+00C8)
  0x70, 0x48, 0x01, 0x70, 0x37, 0x77, 0x20, 0x5D, 0x0B, 0x77, 0x73, 0x09, 0xD0, 0x37, 0x77, 0x30,
  0xCC, 0x0A, 0x77, 0x73, 0x01, 0x0D, 0xC0, 0x37, 0x77, 0x30, 0x20, 0xDB, 0x0C, 0x77, 0x74, 0x02,
  0x0D, 0xB0, 0x57, 0x77, 0x40, 0x20, 0xDA, 0x0E, 0x01, 0x77, 0x74, 0x01, 0x0C, 0xA0, 0x97, 0x77,
  0x60, 0xAA, 0x01, 0x80, 0x9F, 0x70, 0x02, 0xFF, 0xFD, 0x02, 0x20, 0x2F, 0xFF, 0xD0, 0x22, 0x82,
  0x17, 0x8B, 0xF9, 0x80, 0x4E, 0xF0, 0x36, 0x03, 0x0E, 0xD0, 0x67, 0x20, 0x30, 0xCC, 0x03, 0x70,
  0x9D, 0x06, 0x74, 0x0D, 0xB0, 0x47, 0x05, 0xD0, 0x67, 0x40, 0x5B, 0x04, 0x70, 0x4D, 0x06, 0x75,
  0xB0, 0x57, 0x04, 0xD0, 0x67, 0x50, 0xCA, 0x05, 0x70, 0x4D, 0x06, 0x75, 0x0A, 0xA0, 0x57, 0x04,
  0xD0, 0x67, 0x50, 0x8A, 0x06, 0x70, 0x4D, 0x06, 0x75, 0x82, 0x36, 0x62, 0x70, 0x4D, 0x06, 0x77,
  0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D,
  0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x78, 0x07,
  0x17, 0x50, 0x4F, 0xFB, 0x0A, 0x74, 0x04, 0xFF, 0xB0, 0xA7, 0x40, 0x4F, 0xFB, 0x0A, 0x74, 0x04,
  0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77,
  0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D,
  0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x78,
  0x15, 0x77, 0x60, 0x4D, 0x06, 0x77, 0x0D, 0xA0, 0x15, 0x04, 0xD0, 0x67, 0x7B, 0x60, 0x4D, 0x06,
  0x76, 0x02, 0xB6, 0x04, 0xD0, 0x67, 0x60, 0x6B, 0x60, 0x5D, 0x06, 0x76, 0x0D, 0xA0, 0xE6, 0x08,
  0xD0, 0x67, 0x50, 0x7B, 0x0E, 0x50, 0x20, 0xED, 0x06, 0x73, 0x02, 0x08, 0xC8, 0x4D, 0x01, 0x78,
  0xBF, 0x98, 0x05, 0xEF, 0x81, 0xD0, 0x2F, 0xFF, 0xE8, 0x1C, 0x02, 0xFF, 0xFE, 0x0C, 0x10,
  // "É" (U+00C9)
  0x77, 0x38, 0x02, 0x77, 0x77, 0x20, 0x4D, 0x0C, 0x77, 0x72, 0x0B, 0xC0, 0xE0, 0x27, 0x77, 0x10,
  0x4D, 0x04, 0x77, 0x72, 0x0C, 0xC0, 0x67, 0x77, 0x20, 0x5C, 0x07, 0x77, 0x73, 0x0E, 0xB0, 0x77,
  0x77, 0x30, 0x8B, 0x06, 0x77, 0x73, 0x02, 0xB0, 0x57, 0x77, 0x48, 0x28, 0xFE, 0x38, 0x0A, 0x82,
  0x00, 0x2F, 0xFF, 0xD0, 0x22, 0x02, 0xFF, 0xFD, 0x02, 0x28, 0x21, 0x78, 0xBF, 0x98, 0x04, 0xEF,
  0x03, 0x60, 0x30, 0xED, 0x06, 0x72, 0x03, 0x0C, 0xC0, 0x37, 0x09, 0xD0, 0x67, 0x40, 0xDB, 0x04,
  0x70, 0x5D, 0x06, 0x74, 0x05, 0xB0, 0x47, 0x04, 0xD0, 0x67, 0x5B, 0x05, 0x70, 0x4D, 0x06, 0x75,
  0x0C, 0xA0, 0x57, 0x04, 0xD0, 0x67, 0x50, 0xAA, 0x05, 0x70, 0x4D, 0x06, 0x75, 0x08, 0xA0, 0x67,
  0x04, 0xD0, 0x67, 0x58, 0x23, 0x66, 0x27, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72,
  0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06,
  0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x07, 0x80, 0x71, 0x75, 0x04, 0xFF, 0xB0, 0xA7,
  0x40, 0x4F, 0xFB, 0x0A, 0x74, 0x04, 0xFF, 0xB0, 0xA7, 0x40, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0,
  0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72,
  0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06,
  0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x81, 0x57, 0x76, 0x04, 0xD0, 0x67,
  0x70, 0xDA, 0x01, 0x50, 0x4D, 0x06, 0x77, 0xB6, 0x04, 0xD0, 0x67, 0x60, 0x2B, 0x60, 0x4D, 0x06,
  0x76, 0x06, 0xB6, 0x05, 0xD0, 0x67, 0x60, 0xDA, 0x0E, 0x60, 0x8D, 0x06, 0x75, 0x07, 0xB0, 0xE5,
  0x02, 0x0E, 0xD0, 0x67, 0x30, 0x20, 0x8C, 0x84, 0xD0, 0x17, 0x8B, 0xF9, 0x80, 0x5E, 0xF8, 0x1D,
  0x02, 0xFF, 0xFE, 0x81, 0xC0, 0x2F, 0xFF, 0xE0, 0xC1,
  // "Ê" (U+00CA)
  0x75, 0x03, 0x80, 0x17, 0x77, 0x73, 0x0C, 0xD0, 0x47, 0x77, 0x10, 0x5E, 0x0C, 0x77, 0x71, 0x0D,
  0xF0, 0x57, 0x76, 0x08, 0xB0, 0xC0, 0x7B, 0x0D, 0x77, 0x50, 0x2B, 0x82, 0xE2, 0x09, 0xB0, 0x87,
  0x74, 0x0B, 0xA0, 0xE0, 0x33, 0x0B, 0xB0, 0x27, 0x72, 0x06, 0xA0, 0xE0, 0x45, 0x0B, 0xA0, 0xC7,
  0x71, 0x83, 0x2E, 0xFE, 0x47, 0x0B, 0xA0, 0x87, 0x78, 0x28, 0xFE, 0x37, 0x20, 0xAA, 0x80, 0x9F,
  0x30, 0x02, 0xFF, 0xFD, 0x02, 0x20, 0x2F, 0xFF, 0xD0, 0x22, 0x82, 0x17, 0x8B, 0xF9, 0x80, 0x4E,
  0xF0, 0x36, 0x03, 0x0E, 0xD0, 0x67, 0x20, 0x30, 0xCC, 0x03, 0x70, 0x9D, 0x06, 0x74, 0x0D, 0xB0,
  0x47, 0x05, 0xD0, 0x67, 0x40, 0x5B, 0x04, 0x70, 0x4D, 0x06, 0x75, 0xB0, 0x57, 0x04, 0xD0, 0x67,
  0x50, 0xCA, 0x05, 0x70, 0x4D, 0x06, 0x75, 0x0A, 0xA0, 0x57, 0x04, 0xD0, 0x67, 0x50, 0x8A, 0x06,
  0x70, 0x4D, 0x06, 0x75, 0x82, 0x36, 0x62, 0x70, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77,
  0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0,
  0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x78, 0x07, 0x17, 0x50, 0x4F, 0xFB, 0x0A,
  0x74, 0x04, 0xFF, 0xB0, 0xA7, 0x40, 0x4F, 0xFB, 0x0A, 0x74, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D,
  0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77,
  0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0,
  0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x78, 0x15, 0x77, 0x60, 0x4D, 0x06,
  0x77, 0x0D, 0xA0, 0x15, 0x04, 0xD0, 0x67, 0x7B, 0x60, 0x4D, 0x06, 0x76, 0x02, 0xB6, 0x04, 0xD0,
  0x67, 0x60, 0x6B, 0x60, 0x5D, 0x06, 0x76, 0x0D, 0xA0, 0xE6, 0x08, 0xD0, 0x67, 0x50, 0x7B, 0x0E,
  0x50, 0x20, 0xED, 0x06, 0x73, 0x02, 0x08, 0xC8, 0x4D, 0x01, 0x78, 0xBF, 0x98, 0x05, 0xEF, 0x81,
  0xD0, 0x2F, 0xFF, 0xE8, 0x1C, 0x02, 0xFF, 0xFE, 0x0C, 0x10,
  // "Ë" (U+00CB)
  0x71, 0x82, 0x8E, 0xE8, 0x58, 0x33, 0xCE, 0xC3, 0x77, 0x10, 0x5C, 0x07, 0x40, 0xEB, 0x0E, 0x77,
  0x10, 0x9C, 0x0B, 0x30, 0x2D, 0x02, 0x77, 0x09, 0xC0, 0xB3, 0x02, 0xD0, 0x27, 0x70, 0x5C, 0x08,
  0x40, 0xEB, 0x0E, 0x77, 0x28, 0x28, 0xEE, 0x95, 0x83, 0x4C, 0xEC, 0x38, 0x0A, 0xF0, 0x00, 0x2F,
  0xFF, 0xD0, 0x22, 0x02, 0xFF, 0xFD, 0x02, 0x28, 0x21, 0x78, 0xBF, 0x98, 0x04, 0xEF, 0x03, 0x60,
  0x30, 0xED, 0x06, 0x72, 0x03, 0x0C, 0xC0, 0x37, 0x09, 0xD0, 0x67, 0x40, 0xDB, 0x04, 0x70, 0x5D,
  0x06, 0x74, 0x05, 0xB0, 0x47, 0x04, 0xD0, 0x67, 0x5B, 0x05, 0x70, 0x4D, 0x06, 0x75, 0x0C, 0xA0,
  0x57, 0x04, 0xD0, 0x67, 0x50, 0xAA, 0x05, 0x70, 0x4D, 0x06, 0x75, 0x08, 0xA0, 0x67, 0x04, 0xD0,
  0x67, 0x58, 0x23, 0x66, 0x27, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0,
  0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72,
  0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x07, 0x80, 0x71, 0x75, 0x04, 0xFF, 0xB0, 0xA7, 0x40, 0x4F,
  0xFB, 0x0A, 0x74, 0x04, 0xFF, 0xB0, 0xA7, 0x40, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77,
  0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0,
  0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72,
  0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x81, 0x57, 0x76, 0x04, 0xD0, 0x67, 0x70, 0xDA,
  0x01, 0x50, 0x4D, 0x06, 0x77, 0xB6, 0x04, 0xD0, 0x67, 0x60, 0x2B, 0x60, 0x4D, 0x06, 0x76, 0x06,
  0xB6, 0x05, 0xD0, 0x67, 0x60, 0xDA, 0x0E, 0x60, 0x8D, 0x06, 0x75, 0x07, 0xB0, 0xE5, 0x02, 0x0E,
  0xD0, 0x67, 0x30, 0x20, 0x8C, 0x84, 0xD0, 0x17, 0x8B, 0xF9, 0x80, 0x5E, 0xF8, 0x1D, 0x02, 0xFF,
  0xFE, 0x81, 0xC0, 0x2F, 0xFF, 0xE0, 0xC1,
  // "Ì" (U+00CC)
  0x04, 0x80, 0x17, 0x03, 0x73, 0x05, 0xD0, 0xB7, 0x40, 0x9D, 0x03, 0x74, 0x0C, 0xC0, 0xA7, 0x40,
  0x10, 0xDC, 0x03, 0x74, 0x02, 0x0D, 0xB0, 0xC7, 0x50, 0x20, 0xDB, 0x05, 0x75, 0x02, 0x0D, 0xA0,
  0xE0, 0x17, 0x50, 0x10, 0xCA, 0x09, 0x77, 0x0A, 0xA0, 0x18, 0x09, 0x85, 0x00, 0x2F, 0xF9, 0x04,
  0x02, 0xFF, 0x90, 0x40, 0x2F, 0xF9, 0x84, 0x40, 0x12, 0x5C, 0xF8, 0x2D, 0x62, 0x16, 0x0C, 0xD0,
  0xE0, 0x17, 0x20, 0x7D, 0x09, 0x73, 0x05, 0xD0, 0x77, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67,
  0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D,
  0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73,
  0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0,
  0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30,
  0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06,
  0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x05,
  0xD0, 0x77, 0x30, 0x7D, 0x09, 0x73, 0x0C, 0xD0, 0xE6, 0x82, 0x12, 0x5C, 0xF8, 0x4D, 0x52, 0x10,
  0x2F, 0xF9, 0x04, 0x02, 0xFF, 0x90, 0x40, 0x2F, 0xF9, 0x04,
  // "Í" (U+00CD)
  0x73, 0x80, 0x27, 0x73, 0x04, 0xD0, 0xC7, 0x30, 0xBC, 0x0E, 0x02, 0x72, 0x04, 0xD0, 0x47, 0x30,
  0xCC, 0x06, 0x73, 0x05, 0xC0, 0x77, 0x40, 0xEB, 0x07, 0x74, 0x08, 0xB0, 0x67, 0x40, 0x2B, 0x05,
  0x75, 0x82, 0x8F, 0xE3, 0x80, 0x99, 0x00, 0x02, 0xFF, 0x90, 0x40, 0x2F, 0xF9, 0x04, 0x02, 0xFF,
  0x98, 0x44, 0x01, 0x25, 0xCF, 0x82, 0xD6, 0x21, 0x60, 0xCD, 0x0E, 0x01, 0x72, 0x07, 0xD0, 0x97,
  0x30, 0x5D, 0x07, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D,
  0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73,
  0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0,
  0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30,
  0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06,
  0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04,
  0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x5D, 0x07, 0x73, 0x07, 0xD0, 0x97,
  0x30, 0xCD, 0x0E, 0x68, 0x21, 0x25, 0xCF, 0x84, 0xD5, 0x21, 0x02, 0xFF, 0x90, 0x40, 0x2F, 0xF9,
  0x04, 0x02, 0xFF, 0x90, 0x40,
  // "Î" (U+00CE)
  0x50, 0x38, 0x01, 0x77, 0x40, 0xCD, 0x04, 0x72, 0x05, 0xE0, 0xC7, 0x20, 0xDF, 0x05, 0x70, 0x8B,
  0x0C, 0x07, 0xB0, 0xD6, 0x02, 0xB8, 0x2E, 0x20, 0x9B, 0x08, 0x50, 0xBA, 0x0E, 0x03, 0x30, 0xBB,
  0x02, 0x30, 0x6A, 0x0E, 0x04, 0x50, 0xBA, 0x0C, 0x28, 0x32, 0xEF, 0xE4, 0x70, 0xBA, 0x84, 0x80,
  0x8F, 0xE3, 0x72, 0x0A, 0xA8, 0x09, 0x81, 0x00, 0x2F, 0xF9, 0x04, 0x02, 0xFF, 0x90, 0x40, 0x2F,
  0xF9, 0x84, 0x40, 0x12, 0x5C, 0xF8, 0x2D, 0x62, 0x16, 0x0C, 0xD0, 0xE0, 0x17, 0x20, 0x7D, 0x09,
  0x73, 0x05, 0xD0, 0x77, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04,
  0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67,
  0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D,
  0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73,
  0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0,
  0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30,
  0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x05, 0xD0, 0x77, 0x30, 0x7D, 0x09,
  0x73, 0x0C, 0xD0, 0xE6, 0x82, 0x12, 0x5C, 0xF8, 0x4D, 0x52, 0x10, 0x2F, 0xF9, 0x04, 0x02, 0xFF,
  0x90, 0x40, 0x2F, 0xF9, 0x04,
  // "Ï" (U+00CF)
  0x28, 0x28, 0xEE, 0x85, 0x83, 0x3C, 0xEC, 0x32, 0x05, 0xC0, 0x74, 0x0E, 0xB0, 0xE2, 0x09, 0xC0,
  0xB3, 0x02, 0xD8, 0x12, 0x09, 0xC0, 0xB3, 0x02, 0xD8, 0x12, 0x05, 0xC0, 0x84, 0x0E, 0xB0, 0xE3,
  0x82, 0x8E, 0xE9, 0x58, 0x34, 0xCE, 0xC3, 0x80, 0x9C, 0x30, 0x02, 0xFF, 0x90, 0x40, 0x2F, 0xF9,
  0x04, 0x02, 0xFF, 0x98, 0x44, 0x01, 0x25, 0xCF, 0x82, 0xD6, 0x21, 0x60, 0xCD, 0x0E, 0x01, 0x72,
  0x07, 0xD0, 0x97, 0x30, 0x5D, 0x07, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0,
  0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30,
  0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06,
  0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04,
  0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67,
  0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D,
  0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x5D, 0x07, 0x73,
  0x07, 0xD0, 0x97, 0x30, 0xCD, 0x0E, 0x68, 0x21, 0x25, 0xCF, 0x84, 0xD5, 0x21, 0x02, 0xFF, 0x90,
  0x40, 0x2F, 0xF9, 0x04, 0x02, 0xFF, 0x90, 0x40,
  // "Ð" (U+00D0)
  0x02, 0xFF, 0xB8, 0x3E, 0xC9, 0x61, 0x74, 0x02, 0xFF, 0xF9, 0x0B, 0x04, 0x72, 0x82, 0x17, 0x8B,
  0xF9, 0x80, 0x0E, 0xFA, 0x0B, 0x01, 0x74, 0x03, 0x0E, 0xD0, 0x65, 0x82, 0x14, 0x9E, 0xD0, 0xE0,
  0x37, 0x40, 0x8D, 0x06, 0x72, 0x09, 0xD0, 0xE0, 0x37, 0x30, 0x4D, 0x06, 0x73, 0x05, 0xD0, 0xE0,
  0x27, 0x20, 0x3D, 0x06, 0x74, 0x05, 0xD0, 0xC7, 0x20, 0x3D, 0x06, 0x75, 0x09, 0xD0, 0x77, 0x10,
  0x3D, 0x06, 0x75, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x03, 0xD0, 0x67, 0x60, 0x8D, 0x07, 0x70, 0x3D,
  0x06, 0x76, 0x02, 0xD0, 0xE7, 0x03, 0xD0, 0x67, 0x70, 0xCD, 0x04, 0x60, 0x3D, 0x06, 0x77, 0x07,
  0xD0, 0x96, 0x03, 0xD0, 0x67, 0x70, 0x4D, 0x0C, 0x60, 0x3D, 0x06, 0x77, 0x01, 0xE6, 0x03, 0xD0,
  0x67, 0x71, 0x0E, 0xD0, 0x35, 0x03, 0xD0, 0x67, 0x71, 0x0C, 0xD0, 0x55, 0x03, 0xD0, 0x67, 0x71,
  0x0A, 0xD8, 0x57, 0x01, 0x11, 0x14, 0xD0, 0x78, 0x03, 0x17, 0x10, 0x9D, 0x08, 0x1F, 0xFC, 0x0A,
  0x70, 0x8D, 0x09, 0x1F, 0xFC, 0x0A, 0x70, 0x8D, 0x0A, 0x1F, 0xFC, 0x0A, 0x70, 0x7D, 0x0A, 0x50,
  0x3D, 0x06, 0x77, 0x10, 0x8D, 0x0A, 0x50, 0x3D, 0x06, 0x77, 0x10, 0x8D, 0x09, 0x50, 0x3D, 0x06,
  0x77, 0x10, 0x9D, 0x08, 0x50, 0x3D, 0x06, 0x77, 0x10, 0xAD, 0x07, 0x50, 0x3D, 0x06, 0x77, 0x10,
  0xCD, 0x05, 0x50, 0x3D, 0x06, 0x77, 0x10, 0xED, 0x03, 0x50, 0x3D, 0x06, 0x77, 0x01, 0xE6, 0x03,
  0xD0, 0x67, 0x70, 0x4D, 0x0C, 0x60, 0x3D, 0x06, 0x77, 0x08, 0xD0, 0x96, 0x03, 0xD0, 0x67, 0x70,
  0xCD, 0x04, 0x60, 0x3D, 0x06, 0x76, 0x02, 0xD0, 0xE7, 0x03, 0xD0, 0x67, 0x60, 0x9D, 0x08, 0x70,
  0x3D, 0x06, 0x75, 0x01, 0xE0, 0x17, 0x03, 0xD0, 0x67, 0x50, 0xAD, 0x08, 0x71, 0x03, 0xD0, 0x67,
  0x40, 0x7D, 0x0D, 0x72, 0x05, 0xD0, 0x67, 0x30, 0x7D, 0x0E, 0x03, 0x72, 0x08, 0xD0, 0x67, 0x10,
  0x20, 0xAE, 0x04, 0x72, 0x04, 0x0E, 0xD0, 0x78, 0x01, 0x18, 0x13, 0x6A, 0xE0, 0xE0, 0x46, 0x82,
  0x18, 0x9C, 0xFF, 0xF0, 0xB0, 0x27, 0x02, 0xFF, 0xF9, 0x0C, 0x05, 0x72, 0x02, 0xFF, 0xA8, 0x4E,
  0xDC, 0x96, 0x27, 0x40,
  // "Ñ" (U+00D1)
  0x76, 0x84, 0x4B, 0xEE, 0xB5, 0x78, 0x12, 0x55, 0x77, 0x60, 0x5E, 0x0A, 0x01, 0x58, 0x19, 0xFE,
  0x77, 0x50, 0x2F, 0x90, 0xD0, 0x34, 0x81, 0xEF, 0xC7, 0x75, 0x0A, 0xFB, 0x82, 0x71, 0x19, 0xA0,
  0x87, 0x75, 0xA8, 0x3D, 0x30, 0x4D, 0xFB, 0x02, 0x77, 0x40, 0x4A, 0x05, 0x40, 0x9F, 0x90, 0xA7,
  0x75, 0x07, 0xA0, 0x15, 0x05, 0x0E, 0xD0, 0xD0, 0x17, 0x75, 0x81, 0x36, 0x57, 0x85, 0x19, 0xDF,
  0xD8, 0x18, 0x0A, 0xB2, 0x00, 0x2F, 0xB0, 0x17, 0x50, 0xEF, 0xD0, 0x2F, 0xB0, 0x97, 0x50, 0xEF,
  0xD0, 0x2F, 0xC0, 0x27, 0x40, 0xEF, 0xD1, 0x82, 0x12, 0x5C, 0xF0, 0xA7, 0x48, 0x21, 0x24, 0xBD,
  0x82, 0xB4, 0x21, 0x50, 0xCF, 0x03, 0x77, 0x0A, 0xB0, 0xB7, 0x20, 0x6F, 0x0C, 0x77, 0x04, 0xB0,
  0x57, 0x20, 0x4F, 0x90, 0x57, 0x60, 0x2B, 0x02, 0x72, 0x04, 0xF9, 0x0D, 0x76, 0x01, 0xB0, 0x17,
  0x20, 0x4B, 0x0E, 0xD0, 0x67, 0x50, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE0, 0x6D, 0x0D, 0x75, 0x01,
  0xB0, 0x17, 0x20, 0x4A, 0x81, 0xE0, 0xDD, 0x07, 0x74, 0x01, 0xB0, 0x17, 0x20, 0x4A, 0x81, 0xE0,
  0x4D, 0x0E, 0x01, 0x73, 0x01, 0xB0, 0x17, 0x20, 0x4A, 0x0E, 0x20, 0xBD, 0x08, 0x73, 0x01, 0xB0,
  0x17, 0x20, 0x4A, 0x0E, 0x20, 0x3E, 0x01, 0x72, 0x01, 0xB0, 0x17, 0x20, 0x4A, 0x0E, 0x30, 0x9D,
  0x09, 0x72, 0x01, 0xB0, 0x17, 0x20, 0x4A, 0x0E, 0x30, 0x1E, 0x02, 0x71, 0x01, 0xB0, 0x17, 0x20,
  0x4A, 0x0E, 0x40, 0x8D, 0x0B, 0x71, 0x01, 0xB0, 0x17, 0x20, 0x4A, 0x0E, 0x50, 0xED, 0x04, 0x70,
  0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE5, 0x06, 0xD0, 0xC7, 0x01, 0xB0, 0x17, 0x20, 0x4A, 0x0E, 0x60,
  0xDD, 0x05, 0x60, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE6, 0x04, 0xD0, 0xD6, 0x01, 0xB0, 0x17, 0x20,
  0x4A, 0x0E, 0x70, 0xBD, 0x06, 0x50, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE7, 0x03, 0xD0, 0xE5, 0x01,
  0xB0, 0x17, 0x20, 0x4A, 0x0E, 0x71, 0x0A, 0xD0, 0x74, 0x01, 0xB0, 0x17, 0x20, 0x4A, 0x0E, 0x71,
  0x01, 0xD0, 0xE0, 0x13, 0x01, 0xB0, 0x17, 0x20, 0x4A, 0x0E, 0x72, 0x08, 0xD0, 0x93, 0x01, 0xB0,
  0x17, 0x20, 0x4A, 0x0E, 0x72, 0x01, 0x0E, 0xD0, 0x22, 0x01, 0xB0, 0x17, 0x20, 0x4A, 0x0E, 0x73,
  0x06, 0xD0, 0xA2, 0x01, 0xB0, 0x17, 0x20, 0x4A, 0x0E, 0x74, 0x0D, 0xD8, 0x13, 0x01, 0xB0, 0x17,
  0x20, 0x4A, 0x0E, 0x74, 0x05, 0xD8, 0x1B, 0x01, 0xB0, 0x17, 0x20, 0x4A, 0x0E, 0x75, 0x0B, 0xD0,
  0x40, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE7, 0x50, 0x3D, 0x0C, 0x02, 0xB0, 0x17, 0x20, 0x4A, 0x0E,
  0x76, 0x0A, 0xD0, 0x7B, 0x01, 0x72, 0x04, 0xA0, 0xE7, 0x60, 0x2D, 0x0E, 0xB0, 0x17, 0x20, 0x4A,
  0x0E, 0x77, 0x08, 0xF9, 0x01, 0x72, 0x04, 0xA0, 0xE7, 0x70, 0x10, 0xEF, 0x01, 0x72, 0x05, 0xB7,
  0x71, 0x06, 0xF0, 0x17, 0x20, 0x7B, 0x01, 0x77, 0x10, 0xDE, 0x01, 0x72, 0x0C, 0xB0, 0x77, 0x71,
  0x05, 0xE0, 0x15, 0x82, 0x12, 0x5C, 0xD8, 0x29, 0x31, 0x17, 0x50, 0xCD, 0x01, 0x40, 0x2F, 0xD0,
  0xC7, 0x50, 0x3D, 0x01, 0x40, 0x2F, 0xD0, 0xC7, 0x60, 0xAC, 0x01, 0x40, 0x2F, 0xD0, 0xC7, 0x60,
  0x2C, 0x01, 0x40,
  // "Ò" (U+00D2)
  0x72, 0x04, 0x80, 0x17, 0x03, 0x77, 0x76, 0x05, 0xD0, 0xB7, 0x77, 0x70, 0x9D, 0x03, 0x77, 0x77,
  0x0C, 0xC0, 0xA7, 0x77, 0x70, 0x10, 0xDC, 0x03, 0x77, 0x77, 0x02, 0x0D, 0xB0, 0xC7, 0x77, 0x71,
  0x02, 0x0D, 0xB0, 0x57, 0x77, 0x71, 0x02, 0x0D, 0xA0, 0xE0, 0x17, 0x77, 0x71, 0x01, 0x0C, 0xA0,
  0x97, 0x77, 0x73, 0x0A, 0xA0, 0x18, 0x09, 0xF4, 0x08, 0x61, 0x45, 0x67, 0x65, 0x27, 0x77, 0x28,
  0x12, 0x8D, 0xF9, 0x81, 0xEA, 0x37, 0x74, 0x01, 0x09, 0xFF, 0x0B, 0x02, 0x77, 0x10, 0x40, 0xED,
  0x84, 0xEB, 0x99, 0xAC, 0xE0, 0x67, 0x60, 0x5D, 0x0D, 0x05, 0x60, 0x10, 0x8D, 0x08, 0x74, 0x04,
  0xD0, 0xA7, 0x30, 0x30, 0xEC, 0x07, 0x72, 0x02, 0x0E, 0xC0, 0xB7, 0x50, 0x3D, 0x04, 0x71, 0x0B,
  0xC0, 0xE0, 0x17, 0x60, 0x7C, 0x0D, 0x70, 0x4D, 0x07, 0x77, 0x10, 0xEC, 0x07, 0x60, 0xBD, 0x01,
  0x77, 0x10, 0x8C, 0x0E, 0x50, 0x3D, 0x0A, 0x77, 0x20, 0x3D, 0x06, 0x40, 0x8D, 0x05, 0x77, 0x30,
  0xDC, 0x0C, 0x40, 0xDD, 0x01, 0x77, 0x30, 0xAD, 0x02, 0x20, 0x2D, 0x0D, 0x77, 0x40, 0x6D, 0x06,
  0x20, 0x5D, 0x0A, 0x77, 0x40, 0x3D, 0x0A, 0x20, 0x8D, 0x08, 0x77, 0x40, 0x1D, 0x0D, 0x20, 0xBD,
  0x06, 0x77, 0x5E, 0x81, 0x10, 0xCD, 0x04, 0x77, 0x50, 0xDD, 0x81, 0x20, 0xED, 0x03, 0x77, 0x50,
  0xCD, 0x04, 0x1E, 0x02, 0x77, 0x50, 0xBD, 0x06, 0x01, 0xE0, 0x17, 0x75, 0x0B, 0xD0, 0x60, 0x1E,
  0x01, 0x77, 0x50, 0xAD, 0x07, 0x01, 0xE0, 0x17, 0x75, 0x0A, 0xD0, 0x70, 0x1E, 0x01, 0x77, 0x50,
  0xAD, 0x07, 0x1E, 0x02, 0x77, 0x50, 0xBD, 0x06, 0x1E, 0x02, 0x77, 0x50, 0xBD, 0x81, 0x60, 0xED,
  0x03, 0x77, 0x50, 0xCD, 0x81, 0x40, 0xCD, 0x04, 0x77, 0x50, 0xDD, 0x81, 0x20, 0xAD, 0x06, 0x77,
  0x5E, 0x20, 0x8D, 0x08, 0x77, 0x40, 0x1D, 0x0D, 0x20, 0x5D, 0x0A, 0x77, 0x40, 0x3D, 0x0A, 0x20,
  0x1D, 0x0D, 0x77, 0x40, 0x7D, 0x06, 0x30, 0xCD, 0x01, 0x77, 0x30, 0xAD, 0x01, 0x30, 0x8D, 0x05,
  0x77, 0x30, 0xEC, 0x0C, 0x40, 0x2D, 0x0A, 0x77, 0x20, 0x3D, 0x06, 0x50, 0xBD, 0x01, 0x77, 0x10,
  0x9C, 0x0E, 0x60, 0x4D, 0x07, 0x77, 0x10, 0xEC, 0x07, 0x70, 0xAC, 0x0E, 0x01, 0x76, 0x08, 0xC0,
  0xD7, 0x10, 0x10, 0xEC, 0x0B, 0x75, 0x03, 0xD0, 0x37, 0x20, 0x4D, 0x0A, 0x73, 0x03, 0x0E, 0xC0,
  0x67, 0x40, 0x5D, 0x0D, 0x05, 0x60, 0x20, 0x9D, 0x07, 0x76, 0x04, 0x0E, 0xD8, 0x4E, 0xB9, 0x9A,
  0xDE, 0x05, 0x77, 0x10, 0x10, 0xAF, 0xF0, 0xB0, 0x27, 0x74, 0x81, 0x28, 0xDF, 0x98, 0x1E, 0x93,
  0x77, 0x72, 0x86, 0x14, 0x67, 0x76, 0x52, 0x76,
  // "Ó" (U+00D3)
  0x77, 0x58, 0x02, 0x77, 0x77, 0x60, 0x4D, 0x0C, 0x77, 0x76, 0x0B, 0xC0, 0xE0, 0x27, 0x77, 0x50,
  0x4D, 0x04, 0x77, 0x76, 0x0C, 0xC0, 0x67, 0x77, 0x60, 0x5C, 0x07, 0x77, 0x77, 0x0E, 0xB0, 0x77,
  0x77, 0x70, 0x8B, 0x06, 0x77, 0x77, 0x02, 0xB0, 0x57, 0x77, 0x71, 0x82, 0x8F, 0xE3, 0x80, 0x9F,
  0x70, 0x86, 0x14, 0x56, 0x76, 0x52, 0x77, 0x72, 0x81, 0x28, 0xDF, 0x98, 0x1E, 0xA3, 0x77, 0x40,
  0x10, 0x9F, 0xF0, 0xB0, 0x27, 0x71, 0x04, 0x0E, 0xD8, 0x4E, 0xB9, 0x9A, 0xCE, 0x06, 0x76, 0x05,
  0xD0, 0xD0, 0x56, 0x01, 0x08, 0xD0, 0x87, 0x40, 0x4D, 0x0A, 0x73, 0x03, 0x0E, 0xC0, 0x77, 0x20,
  0x20, 0xEC, 0x0B, 0x75, 0x03, 0xD0, 0x47, 0x10, 0xBC, 0x0E, 0x01, 0x76, 0x07, 0xC0, 0xD7, 0x04,
  0xD0, 0x77, 0x71, 0x0E, 0xC0, 0x76, 0x0B, 0xD0, 0x17, 0x71, 0x08, 0xC0, 0xE5, 0x03, 0xD0, 0xA7,
  0x72, 0x03, 0xD0, 0x64, 0x08, 0xD0, 0x57, 0x73, 0x0D, 0xC0, 0xC4, 0x0D, 0xD0, 0x17, 0x73, 0x0A,
  0xD0, 0x22, 0x02, 0xD0, 0xD7, 0x74, 0x06, 0xD0, 0x62, 0x05, 0xD0, 0xA7, 0x74, 0x03, 0xD0, 0xA2,
  0x08, 0xD0, 0x87, 0x74, 0x01, 0xD0, 0xD2, 0x0B, 0xD0, 0x67, 0x75, 0xE8, 0x11, 0x0C, 0xD0, 0x47,
  0x75, 0x0D, 0xD8, 0x12, 0x0E, 0xD0, 0x37, 0x75, 0x0C, 0xD0, 0x41, 0xE0, 0x27, 0x75, 0x0B, 0xD0,
  0x60, 0x1E, 0x01, 0x77, 0x50, 0xBD, 0x06, 0x01, 0xE0, 0x17, 0x75, 0x0A, 0xD0, 0x70, 0x1E, 0x01,
  0x77, 0x50, 0xAD, 0x07, 0x01, 0xE0, 0x17, 0x75, 0x0A, 0xD0, 0x71, 0xE0, 0x27, 0x75, 0x0B, 0xD0,
  0x61, 0xE0, 0x27, 0x75, 0x0B, 0xD8, 0x16, 0x0E, 0xD0, 0x37, 0x75, 0x0C, 0xD8, 0x14, 0x0C, 0xD0,
  0x47, 0x75, 0x0D, 0xD8, 0x12, 0x0A, 0xD0, 0x67, 0x75, 0xE2, 0x08, 0xD0, 0x87, 0x74, 0x01, 0xD0,
  0xD2, 0x05, 0xD0, 0xA7, 0x74, 0x03, 0xD0, 0xA2, 0x01, 0xD0, 0xD7, 0x74, 0x07, 0xD0, 0x63, 0x0C,
  0xD0, 0x17, 0x73, 0x0A, 0xD0, 0x13, 0x08, 0xD0, 0x57, 0x73, 0x0E, 0xC0, 0xC4, 0x02, 0xD0, 0xA7,
  0x72, 0x03, 0xD0, 0x65, 0x0B, 0xD0, 0x17, 0x71, 0x09, 0xC0, 0xE6, 0x04, 0xD0, 0x77, 0x71, 0x0E,
  0xC0, 0x77, 0x0A, 0xC0, 0xE0, 0x17, 0x60, 0x8C, 0x0D, 0x71, 0x01, 0x0E, 0xC0, 0xB7, 0x50, 0x3D,
  0x03, 0x72, 0x04, 0xD0, 0xA7, 0x30, 0x30, 0xEC, 0x06, 0x74, 0x05, 0xD0, 0xD0, 0x56, 0x02, 0x09,
  0xD0, 0x77, 0x60, 0x40, 0xED, 0x84, 0xEB, 0x99, 0xAD, 0xE0, 0x57, 0x71, 0x01, 0x0A, 0xFF, 0x0B,
  0x02, 0x77, 0x48, 0x12, 0x8D, 0xF9, 0x81, 0xE9, 0x37, 0x77, 0x28, 0x61, 0x46, 0x77, 0x65, 0x27,
  0x60,
  // "Ô" (U+00D4)
  0x77, 0x03, 0x80, 0x17, 0x77, 0x77, 0x0C, 0xD0, 0x47, 0x77, 0x50, 0x5E, 0x0C, 0x77, 0x75, 0x0D,
  0xF0, 0x57, 0x77, 0x30, 0x8B, 0x0C, 0x07, 0xB0, 0xD7, 0x77, 0x20, 0x2B, 0x82, 0xE2, 0x09, 0xB0,
  0x87, 0x77, 0x10, 0xBA, 0x0E, 0x03, 0x30, 0xBB, 0x02, 0x77, 0x60, 0x6A, 0x0E, 0x04, 0x50, 0xBA,
  0x0C, 0x77, 0x58, 0x32, 0xEF, 0xE4, 0x70, 0xBA, 0x08, 0x77, 0x48, 0x28, 0xFE, 0x37, 0x20, 0xAA,
  0x80, 0x9F, 0x00, 0x86, 0x14, 0x56, 0x76, 0x52, 0x77, 0x72, 0x81, 0x28, 0xDF, 0x98, 0x1E, 0xA3,
  0x77, 0x40, 0x10, 0x9F, 0xF0, 0xB0, 0x27, 0x71, 0x04, 0x0E, 0xD8, 0x4E, 0xB9, 0x9A, 0xCE, 0x06,
  0x76, 0x05, 0xD0, 0xD0, 0x56, 0x01, 0x08, 0xD0, 0x87, 0x40, 0x4D, 0x0A, 0x73, 0x03, 0x0E, 0xC0,
  0x77, 0x20, 0x20, 0xEC, 0x0B, 0x75, 0x03, 0xD0, 0x47, 0x10, 0xBC, 0x0E, 0x01, 0x76, 0x07, 0xC0,
  0xD7, 0x04, 0xD0, 0x77, 0x71, 0x0E, 0xC0, 0x76, 0x0B, 0xD0, 0x17, 0x71, 0x08, 0xC0, 0xE5, 0x03,
  0xD0, 0xA7, 0x72, 0x03, 0xD0, 0x64, 0x08, 0xD0, 0x57, 0x73, 0x0D, 0xC0, 0xC4, 0x0D, 0xD0, 0x17,
  0x73, 0x0A, 0xD0, 0x22, 0x02, 0xD0, 0xD7, 0x74, 0x06, 0xD0, 0x62, 0x05, 0xD0, 0xA7, 0x74, 0x03,
  0xD0, 0xA2, 0x08, 0xD0, 0x87, 0x74, 0x01, 0xD0, 0xD2, 0x0B, 0xD0, 0x67, 0x75, 0xE8, 0x11, 0x0C,
  0xD0, 0x47, 0x75, 0x0D, 0xD8, 0x12, 0x0E, 0xD0, 0x37, 0x75, 0x0C, 0xD0, 0x41, 0xE0, 0x27, 0x75,
  0x0B, 0xD0, 0x60, 0x1E, 0x01, 0x77, 0x50, 0xBD, 0x06, 0x01, 0xE0, 0x17, 0x75, 0x0A, 0xD0, 0x70,
  0x1E, 0x01, 0x77, 0x50, 0xAD, 0x07, 0x01, 0xE0, 0x17, 0x75, 0x0A, 0xD0, 0x71, 0xE0, 0x27, 0x75,
  0x0B, 0xD0, 0x61, 0xE0, 0x27, 0x75, 0x0B, 0xD8, 0x16, 0x0E, 0xD0, 0x37, 0x75, 0x0C, 0xD8, 0x14,
  0x0C, 0xD0, 0x47, 0x75, 0x0D, 0xD8, 0x12, 0x0A, 0xD0, 0x67, 0x75, 0xE2, 0x08, 0xD0, 0x87, 0x74,
  0x01, 0xD0, 0xD2, 0x05, 0xD0, 0xA7, 0x74, 0x03, 0xD0, 0xA2, 0x01, 0xD0, 0xD7, 0x74, 0x07, 0xD0,
  0x63, 0x0C, 0xD0, 0x17, 0x73, 0x0A, 0xD0, 0x13, 0x08, 0xD0, 0x57, 0x73, 0x0E, 0xC0, 0xC4, 0x02,
  0xD0, 0xA7, 0x72, 0x03, 0xD0, 0x65, 0x0B, 0xD0, 0x17, 0x71, 0x09, 0xC0, 0xE6, 0x04, 0xD0, 0x77,
  0x71, 0x0E, 0xC0, 0x77, 0x0A, 0xC0, 0xE0, 0x17, 0x60, 0x8C, 0x0D, 0x71, 0x01, 0x0E, 0xC0, 0xB7,
  0x50, 0x3D, 0x03, 0x72, 0x04, 0xD0, 0xA7, 0x30, 0x30, 0xEC, 0x06, 0x74, 0x05, 0xD0, 0xD0, 0x56,
  0x02, 0x09, 0xD0, 0x77, 0x60, 0x40, 0xED, 0x84, 0xEB, 0x99, 0xAD, 0xE0, 0x57, 0x71, 0x01, 0x0A,
  0xFF, 0x0B, 0x02, 0x77, 0x48, 0x12, 0x8D, 0xF9, 0x81, 0xE9, 0x37, 0x77, 0x28, 0x61, 0x46, 0x77,
  0x65, 0x27, 0x60,
  // "Õ" (U+00D5)
  0x73, 0x84, 0x4B, 0xEE, 0xB5, 0x78, 0x12, 0x55, 0x77, 0x30, 0x5E, 0x0A, 0x01, 0x58, 0x19, 0xFE,
  0x77, 0x20, 0x2F, 0x90, 0xD0, 0x34, 0x81, 0xEF, 0xC7, 0x72, 0x0A, 0xFB, 0x82, 0x71, 0x19, 0xA0,
  0x87, 0x72, 0xA8, 0x3D, 0x30, 0x4D, 0xFB, 0x02, 0x77, 0x10, 0x4A, 0x05, 0x40, 0x9F, 0x90, 0xA7,
  0x72, 0x07, 0xA0, 0x15, 0x05, 0x0E, 0xD0, 0xD0, 0x17, 0x72, 0x81, 0x36, 0x57, 0x85, 0x19, 0xDF,
  0xD8, 0x18, 0x09, 0xF1, 0x08, 0x61, 0x45, 0x67, 0x65, 0x27, 0x77, 0x28, 0x12, 0x8D, 0xF9, 0x81,
  0xEA, 0x37, 0x74, 0x01, 0x09, 0xFF, 0x0B, 0x02, 0x77, 0x10, 0x40, 0xED, 0x84, 0xEB, 0x99, 0xAC,
  0xE0, 0x67, 0x60, 0x5D, 0x0D, 0x05, 0x60, 0x10, 0x8D, 0x08, 0x74, 0x04, 0xD0, 0xA7, 0x30, 0x30,
  0xEC, 0x07, 0x72, 0x02, 0x0E, 0xC0, 0xB7, 0x50, 0x3D, 0x04, 0x71, 0x0B, 0xC0, 0xE0, 0x17, 0x60,
  0x7C, 0x0D, 0x70, 0x4D, 0x07, 0x77, 0x10, 0xEC, 0x07, 0x60, 0xBD, 0x01, 0x77, 0x10, 0x8C, 0x0E,
  0x50, 0x3D, 0x0A, 0x77, 0x20, 0x3D, 0x06, 0x40, 0x8D, 0x05, 0x77, 0x30, 0xDC, 0x0C, 0x40, 0xDD,
  0x01, 0x77, 0x30, 0xAD, 0x02, 0x20, 0x2D, 0x0D, 0x77, 0x40, 0x6D, 0x06, 0x20, 0x5D, 0x0A, 0x77,
  0x40, 0x3D, 0x0A, 0x20, 0x8D, 0x08, 0x77, 0x40, 0x1D, 0x0D, 0x20, 0xBD, 0x06, 0x77, 0x5E, 0x81,
  0x10, 0xCD, 0x04, 0x77, 0x50, 0xDD, 0x81, 0x20, 0xED, 0x03, 0x77, 0x50, 0xCD, 0x04, 0x1E, 0x02,
  0x77, 0x50, 0xBD, 0x06, 0x01, 0xE0, 0x17, 0x75, 0x0B, 0xD0, 0x60, 0x1E, 0x01, 0x77, 0x50, 0xAD,
  0x07, 0x01, 0xE0, 0x17, 0x75, 0x0A, 0xD0, 0x70, 0x1E, 0x01, 0x77, 0x50, 0xAD, 0x07, 0x1E, 0x02,
  0x77, 0x50, 0xBD, 0x06, 0x1E, 0x02, 0x77, 0x50, 0xBD, 0x81, 0x60, 0xED, 0x03, 0x77, 0x50, 0xCD,
  0x81, 0x40, 0xCD, 0x04, 0x77, 0x50, 0xDD, 0x81, 0x20, 0xAD, 0x06, 0x77, 0x5E, 0x20, 0x8D, 0x08,
  0x77, 0x40, 0x1D, 0x0D, 0x20, 0x5D, 0x0A, 0x77, 0x40, 0x3D, 0x0A, 0x20, 0x1D, 0x0D, 0x77, 0x40,
  0x7D, 0x06, 0x30, 0xCD, 0x01, 0x77, 0x30, 0xAD, 0x01, 0x30, 0x8D, 0x05, 0x77, 0x30, 0xEC, 0x0C,
  0x40, 0x2D, 0x0A, 0x77, 0x20, 0x3D, 0x06, 0x50, 0xBD, 0x01, 0x77, 0x10, 0x9C, 0x0E, 0x60, 0x4D,
  0x07, 0x77, 0x10, 0xEC, 0x07, 0x70, 0xAC, 0x0E, 0x01, 0x76, 0x08, 0xC0, 0xD7, 0x10, 0x10, 0xEC,
  0x0B, 0x75, 0x03, 0xD0, 0x37, 0x20, 0x4D, 0x0A, 0x73, 0x03, 0x0E, 0xC0, 0x67, 0x40, 0x5D, 0x0D,
  0x05, 0x60, 0x20, 0x9D, 0x07, 0x76, 0x04, 0x0E, 0xD8, 0x4E, 0xB9, 0x9A, 0xDE, 0x05, 0x77, 0x10,
  0x10, 0xAF, 0xF0, 0xB0, 0x27, 0x74, 0x81, 0x28, 0xDF, 0x98, 0x1E, 0x93, 0x77, 0x72, 0x86, 0x14,
  0x67, 0x76, 0x52, 0x76,
  // "Ö" (U+00D6)
  0x73, 0x82, 0x8E, 0xE8, 0x58, 0x33, 0xCE, 0xC3, 0x77, 0x50, 0x5C, 0x07, 0x40, 0xEB, 0x0E, 0x77,
  0x50, 0x9C, 0x0B, 0x30, 0x2D, 0x02, 0x77, 0x40, 0x9C, 0x0B, 0x30, 0x2D, 0x02, 0x77, 0x40, 0x5C,
  0x08, 0x40, 0xEB, 0x0E, 0x77, 0x68, 0x28, 0xEE, 0x95, 0x83, 0x4C, 0xEC, 0x38, 0x0A, 0xF5, 0x08,
  0x61, 0x45, 0x67, 0x65, 0x27, 0x77, 0x28, 0x12, 0x8D, 0xF9, 0x81, 0xEA, 0x37, 0x74, 0x01, 0x09,
  0xFF, 0x0B, 0x02, 0x77, 0x10, 0x40, 0xED, 0x84, 0xEB, 0x99, 0xAC, 0xE0, 0x67, 0x60, 0x5D, 0x0D,
  0x05, 0x60, 0x10, 0x8D, 0x08, 0x74, 0x04, 0xD0, 0xA7, 0x30, 0x30, 0xEC, 0x07, 0x72, 0x02, 0x0E,
  0xC0, 0xB7, 0x50, 0x3D, 0x04, 0x71, 0x0B, 0xC0, 0xE0, 0x17, 0x60, 0x7C, 0x0D, 0x70, 0x4D, 0x07,
  0x77, 0x10, 0xEC, 0x07, 0x60, 0xBD, 0x01, 0x77, 0x10, 0x8C, 0x0E, 0x50, 0x3D, 0x0A, 0x77, 0x20,
  0x3D, 0x06, 0x40, 0x8D, 0x05, 0x77, 0x30, 0xDC, 0x0C, 0x40, 0xDD, 0x01, 0x77, 0x30, 0xAD, 0x02,
  0x20, 0x2D, 0x0D, 0x77, 0x40, 0x6D, 0x06, 0x20, 0x5D, 0x0A, 0x77, 0x40, 0x3D, 0x0A, 0x20, 0x8D,
  0x08, 0x77, 0x40, 0x1D, 0x0D, 0x20, 0xBD, 0x06, 0x77, 0x5E, 0x81, 0x10, 0xCD, 0x04, 0x77, 0x50,
  0xDD, 0x81, 0x20, 0xED, 0x03, 0x77, 0x50, 0xCD, 0x04, 0x1E, 0x02, 0x77, 0x50, 0xBD, 0x06, 0x01,
  0xE0, 0x17, 0x75, 0x0B, 0xD0, 0x60, 0x1E, 0x01, 0x77, 0x50, 0xAD, 0x07, 0x01, 0xE0, 0x17, 0x75,
  0x0A, 0xD0, 0x70, 0x1E, 0x01, 0x77, 0x50, 0xAD, 0x07, 0x1E, 0x02, 0x77, 0x50, 0xBD, 0x06, 0x1E,
  0x02, 0x77, 0x50, 0xBD, 0x81, 0x60, 0xED, 0x03, 0x77, 0x50, 0xCD, 0x81, 0x40, 0xCD, 0x04, 0x77,
  0x50, 0xDD, 0x81, 0x20, 0xAD, 0x06, 0x77, 0x5E, 0x20, 0x8D, 0x08, 0x77, 0x40, 0x1D, 0x0D, 0x20,
  0x5D, 0x0A, 0x77, 0x40, 0x3D, 0x0A, 0x20, 0x1D, 0x0D, 0x77, 0x40, 0x7D, 0x06, 0x30, 0xCD, 0x01,
  0x77, 0x30, 0xAD, 0x01, 0x30, 0x8D, 0x05, 0x77, 0x30, 0xEC, 0x0C, 0x40, 0x2D, 0x0A, 0x77, 0x20,
  0x3D, 0x06, 0x50, 0xBD, 0x01, 0x77, 0x10, 0x9C, 0x0E, 0x60, 0x4D, 0x07, 0x77, 0x10, 0xEC, 0x07,
  0x70, 0xAC, 0x0E, 0x01, 0x76, 0x08, 0xC0, 0xD7, 0x10, 0x10, 0xEC, 0x0B, 0x75, 0x03, 0xD0, 0x37,
  0x20, 0x4D, 0x0A, 0x73, 0x03, 0x0E, 0xC0, 0x67, 0x40, 0x5D, 0x0D, 0x05, 0x60, 0x20, 0x9D, 0x07,
  0x76, 0x04, 0x0E, 0xD8, 0x4E, 0xB9, 0x9A, 0xDE, 0x05, 0x77, 0x10, 0x10, 0xAF, 0xF0, 0xB0, 0x27,
  0x74, 0x81, 0x28, 0xDF, 0x98, 0x1E, 0x93, 0x77, 0x72, 0x86, 0x14, 0x67, 0x76, 0x52, 0x76,
  // "×" (U+00D7)
  0x20, 0x90, 0x27, 0x78, 0x71, 0xA1, 0x01, 0xCF, 0xD1, 0x76, 0x83, 0xBF, 0xD2, 0x9B, 0x0B, 0x75,
  0x09, 0xB8, 0x1A, 0x0C, 0xB0, 0xA7, 0x30, 0x7B, 0x83, 0xD1, 0x01, 0xDB, 0x07, 0x71, 0x05, 0xB0,
  0xE0, 0x23, 0x03, 0x0E, 0xB0, 0x56, 0x03, 0xC0, 0x45, 0x04, 0xC0, 0x34, 0x02, 0x0E, 0xB0, 0x67,
  0x07, 0xB0, 0xE0, 0x12, 0x01, 0x0D, 0xB0, 0x87, 0x20, 0x9B, 0x0C, 0x20, 0xBB, 0x0A, 0x74, 0x0B,
  0xB0, 0xB0, 0x9B, 0x0C, 0x75, 0x01, 0x0D, 0xE0, 0xE0, 0x17, 0x60, 0x20, 0xEC, 0x0E, 0x03, 0x77,
  0x10, 0x6C, 0x08, 0x77, 0x10, 0x10, 0xEC, 0x0E, 0x02, 0x77, 0x0C, 0xE0, 0xD0, 0x17, 0x50, 0xAB,
  0x0A, 0x09, 0xB0, 0xC7, 0x40, 0x8B, 0x0C, 0x20, 0xBB, 0x0A, 0x72, 0x06, 0xB0, 0xD0, 0x12, 0x01,
  0x0D, 0xB0, 0x87, 0x04, 0xB0, 0xE0, 0x34, 0x02, 0x0E, 0xB0, 0x55, 0x02, 0x0E, 0xB0, 0x46, 0x03,
  0xC0, 0x33, 0x01, 0x0D, 0xB0, 0x77, 0x10, 0x5B, 0x0E, 0x02, 0x20, 0xBB, 0x09, 0x73, 0x07, 0xB8,
  0x1D, 0x19, 0xB0, 0xB7, 0x50, 0x9B, 0x84, 0xA2, 0xDF, 0xD1, 0x76, 0x86, 0xBF, 0xD2, 0x01, 0xA2,
  0x77, 0x81, 0x1A, 0x11,
  // "Ø" (U+00D8)
  0x77, 0x75, 0x04, 0xA0, 0xC7, 0x77, 0x72, 0x0A, 0xA0, 0x67, 0x73, 0x86, 0x14, 0x56, 0x76, 0x52,
  0x40, 0x1A, 0x0E, 0x77, 0x18, 0x12, 0x8D, 0xF9, 0x83, 0xE9, 0x30, 0x8A, 0x09, 0x76, 0x01, 0x09,
  0xFF, 0x0B, 0x0E, 0xA0, 0x37, 0x50, 0x40, 0xED, 0x84, 0xEB, 0x99, 0xAD, 0xF0, 0xC7, 0x50, 0x5D,
  0x0D, 0x05, 0x60, 0x20, 0xAD, 0x08, 0x74, 0x04, 0xD0, 0xA7, 0x30, 0x5D, 0x04, 0x72, 0x02, 0x0E,
  0xC0, 0xB7, 0x50, 0xCC, 0x0E, 0x01, 0x71, 0x0A, 0xC0, 0xE0, 0x17, 0x40, 0x4E, 0x0B, 0x70, 0x4D,
  0x07, 0x75, 0x0B, 0xF0, 0x56, 0x0B, 0xD0, 0x17, 0x40, 0x3A, 0x0E, 0x0D, 0xC0, 0xD5, 0x02, 0xD0,
  0xA7, 0x50, 0xAA, 0x08, 0x06, 0xD0, 0x54, 0x08, 0xD0, 0x57, 0x40, 0x2B, 0x00, 0x1D, 0x0B, 0x40,
  0xDD, 0x01, 0x74, 0x09, 0xA0, 0x92, 0x0B, 0xD0, 0x12, 0x01, 0xD0, 0xD7, 0x40, 0x1B, 0x02, 0x20,
  0x8D, 0x05, 0x20, 0x5D, 0x0A, 0x74, 0x08, 0xA0, 0xA3, 0x05, 0xD0, 0x92, 0x08, 0xD0, 0x87, 0x40,
  0xEA, 0x03, 0x30, 0x2D, 0x0D, 0x20, 0xAD, 0x06, 0x73, 0x07, 0xA0, 0xB5, 0xE2, 0x0C, 0xD0, 0x47,
  0x30, 0xEA, 0x04, 0x50, 0xED, 0x81, 0x20, 0xED, 0x03, 0x72, 0x06, 0xA0, 0xC6, 0x0C, 0xD0, 0x41,
  0xE0, 0x27, 0x20, 0xDA, 0x04, 0x60, 0xBD, 0x06, 0x1E, 0x02, 0x71, 0x05, 0xA0, 0xD7, 0x0B, 0xD0,
  0x60, 0x1E, 0x01, 0x71, 0x0C, 0xA0, 0x57, 0x0A, 0xD0, 0x70, 0x1E, 0x01, 0x70, 0x4A, 0x0D, 0x71,
  0x0A, 0xD0, 0x70, 0x1E, 0x01, 0x70, 0xBA, 0x06, 0x71, 0x0A, 0xD0, 0x70, 0x1E, 0x01, 0x60, 0x3A,
  0x0E, 0x72, 0x0B, 0xD0, 0x61, 0xE0, 0x26, 0x0A, 0xA0, 0x77, 0x20, 0xBD, 0x81, 0x60, 0xED, 0x03,
  0x50, 0x2A, 0x0E, 0x01, 0x72, 0x0C, 0xD8, 0x14, 0x0C, 0xD0, 0x45, 0x09, 0xA0, 0x87, 0x30, 0xDD,
  0x81, 0x30, 0xAD, 0x06, 0x40, 0x1B, 0x01, 0x73, 0xE8, 0x11, 0x08, 0xD0, 0x74, 0x08, 0xA0, 0x97,
  0x30, 0x1D, 0x0D, 0x20, 0x5D, 0x09, 0x40, 0xEA, 0x02, 0x73, 0x03, 0xD0, 0xA2, 0x01, 0xD0, 0xC3,
  0x07, 0xA0, 0xA7, 0x40, 0x6D, 0x07, 0x30, 0xDD, 0x01, 0x20, 0xEA, 0x02, 0x74, 0x0A, 0xD0, 0x23,
  0x08, 0xD8, 0x15, 0x06, 0xA0, 0xA7, 0x50, 0xDC, 0x0C, 0x40, 0x2D, 0x81, 0xA0, 0xDA, 0x03, 0x74,
  0x03, 0xD0, 0x75, 0x0C, 0xD0, 0x7A, 0x0B, 0x75, 0x09, 0xC0, 0xE6, 0x04, 0xF9, 0x04, 0x75, 0x0E,
  0xC0, 0x87, 0x0B, 0xE0, 0xC7, 0x50, 0x7C, 0x0D, 0x71, 0x02, 0x0E, 0xD0, 0x57, 0x40, 0x3D, 0x04,
  0x72, 0x05, 0xD0, 0xB7, 0x30, 0x30, 0xEC, 0x06, 0x74, 0x06, 0xD0, 0xD0, 0x56, 0x02, 0x08, 0xD0,
  0x87, 0x50, 0x2F, 0x84, 0xEB, 0x99, 0xAD, 0xE0, 0x67, 0x60, 0x9A, 0x0C, 0xFF, 0x0B, 0x02, 0x76,
  0x01, 0xA8, 0x3E, 0x02, 0x8D, 0xF9, 0x81, 0xE9, 0x37, 0x71, 0x09, 0xA0, 0x74, 0x86, 0x14, 0x67,
  0x76, 0x52, 0x77, 0x38, 0x31, 0xEF, 0xE1, 0x77, 0x77, 0x18, 0x23, 0x77, 0x57, 0x77, 0x50,
  // "Ù" (U+00D9)
  0x74, 0x04, 0x80, 0x17, 0x03, 0x77, 0x77, 0x20, 0x5D, 0x0B, 0x77, 0x77, 0x30, 0x9D, 0x03, 0x77,
  0x77, 0x30, 0xCC, 0x0A, 0x77, 0x77, 0x30, 0x10, 0xDC, 0x03, 0x77, 0x77, 0x30, 0x20, 0xDB, 0x0C,
  0x77, 0x77, 0x40, 0x20, 0xDB, 0x05, 0x77, 0x77, 0x40, 0x20, 0xDA, 0x0E, 0x01, 0x77, 0x77, 0x40,
  0x10, 0xCA, 0x09, 0x77, 0x77, 0x60, 0xAA, 0x01, 0x80, 0xAB, 0x60, 0x03, 0xFF, 0x90, 0x26, 0x0B,
  0xFD, 0x02, 0x03, 0xFF, 0x90, 0x26, 0x0B, 0xFD, 0x02, 0x03, 0xFF, 0x90, 0x26, 0x0B, 0xFD, 0x84,
  0x20, 0x13, 0x6D, 0xF8, 0x2D, 0x63, 0x17, 0x18, 0x12, 0x49, 0xD8, 0x2D, 0x63, 0x16, 0x0D, 0xD0,
  0xD7, 0x71, 0x07, 0xB0, 0xD7, 0x30, 0x8D, 0x08, 0x77, 0x10, 0x1B, 0x08, 0x73, 0x06, 0xD0, 0x67,
  0x72, 0xB0, 0x57, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E,
  0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0,
  0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47,
  0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30,
  0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D,
  0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05,
  0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77,
  0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20,
  0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA,
  0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04,
  0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73,
  0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x4D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x03,
  0xD0, 0x67, 0x72, 0xB0, 0x27, 0x30, 0x2D, 0x08, 0x77, 0x10, 0x3B, 0x01, 0x74, 0x0E, 0xC0, 0xB7,
  0x71, 0x06, 0xA0, 0xD7, 0x50, 0xBC, 0x0E, 0x01, 0x77, 0x0C, 0xA0, 0x97, 0x50, 0x6D, 0x07, 0x76,
  0x03, 0xB0, 0x47, 0x60, 0xEC, 0x0E, 0x02, 0x75, 0x0D, 0xA0, 0xC7, 0x70, 0x7D, 0x0D, 0x02, 0x73,
  0x0B, 0xB0, 0x47, 0x71, 0x0B, 0xD8, 0x1E, 0x81, 0x60, 0x50, 0xDB, 0x08, 0x77, 0x30, 0xAF, 0x84,
  0xCA, 0x9A, 0xBE, 0xC0, 0x97, 0x75, 0x06, 0x0E, 0xFE, 0x0E, 0x06, 0x77, 0x71, 0x06, 0x0C, 0xFA,
  0x0C, 0x07, 0x77, 0x76, 0x86, 0x35, 0x67, 0x65, 0x41, 0x77,
  // "Ú" (U+00DA)
  0x77, 0x78, 0x02, 0x77, 0x77, 0x72, 0x04, 0xD0, 0xC7, 0x77, 0x72, 0x0B, 0xC0, 0xE0, 0x27, 0x77,
  0x71, 0x04, 0xD0, 0x47, 0x77, 0x72, 0x0C, 0xC0, 0x67, 0x77, 0x72, 0x05, 0xC0, 0x77, 0x77, 0x73,
  0x0E, 0xB0, 0x77, 0x77, 0x73, 0x08, 0xB0, 0x67, 0x77, 0x73, 0x02, 0xB0, 0x57, 0x77, 0x74, 0x82,
  0x8F, 0xE3, 0x80, 0xAC, 0x10, 0x03, 0xFF, 0x90, 0x26, 0x0B, 0xFD, 0x02, 0x03, 0xFF, 0x90, 0x26,
  0x0B, 0xFD, 0x02, 0x03, 0xFF, 0x90, 0x26, 0x0B, 0xFD, 0x84, 0x20, 0x13, 0x6D, 0xF8, 0x2D, 0x63,
  0x17, 0x18, 0x12, 0x49, 0xD8, 0x2D, 0x63, 0x16, 0x0D, 0xD0, 0xD7, 0x71, 0x07, 0xB0, 0xD7, 0x30,
  0x8D, 0x08, 0x77, 0x10, 0x1B, 0x08, 0x73, 0x06, 0xD0, 0x67, 0x72, 0xB0, 0x57, 0x30, 0x5D, 0x05,
  0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77,
  0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20,
  0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA,
  0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04,
  0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73,
  0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05,
  0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0,
  0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57,
  0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72,
  0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E,
  0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0,
  0x47, 0x30, 0x4D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x03, 0xD0, 0x67, 0x72, 0xB0, 0x27, 0x30,
  0x2D, 0x08, 0x77, 0x10, 0x3B, 0x01, 0x74, 0x0E, 0xC0, 0xB7, 0x71, 0x06, 0xA0, 0xD7, 0x50, 0xBC,
  0x0E, 0x01, 0x77, 0x0C, 0xA0, 0x97, 0x50, 0x6D, 0x07, 0x76, 0x03, 0xB0, 0x47, 0x60, 0xEC, 0x0E,
  0x02, 0x75, 0x0D, 0xA0, 0xC7, 0x70, 0x7D, 0x0D, 0x02, 0x73, 0x0B, 0xB0, 0x47, 0x71, 0x0B, 0xD8,
  0x1E, 0x81, 0x60, 0x50, 0xDB, 0x08, 0x77, 0x30, 0xAF, 0x84, 0xCA, 0x9A, 0xBE, 0xC0, 0x97, 0x75,
  0x06, 0x0E, 0xFE, 0x0E, 0x06, 0x77, 0x71, 0x06, 0x0C, 0xFA, 0x0C, 0x07, 0x77, 0x76, 0x86, 0x35,
  0x67, 0x65, 0x41, 0x77,
  // "Û" (U+00DB)
  0x77, 0x20, 0x38, 0x01, 0x77, 0x77, 0x73, 0x0C, 0xD0, 0x47, 0x77, 0x71, 0x05, 0xE0, 0xC7, 0x77,
  0x71, 0x0D, 0xF0, 0x57, 0x77, 0x60, 0x8B, 0x0C, 0x07, 0xB0, 0xD7, 0x77, 0x50, 0x2B, 0x82, 0xE2,
  0x09, 0xB0, 0x87, 0x77, 0x40, 0xBA, 0x0E, 0x03, 0x30, 0xBB, 0x02, 0x77, 0x72, 0x06, 0xA0, 0xE0,
  0x45, 0x0B, 0xA0, 0xC7, 0x77, 0x18, 0x32, 0xEF, 0xE4, 0x70, 0xBA, 0x08, 0x77, 0x78, 0x28, 0xFE,
  0x37, 0x20, 0xAA, 0x80, 0xAB, 0x20, 0x03, 0xFF, 0x90, 0x26, 0x0B, 0xFD, 0x02, 0x03, 0xFF, 0x90,
  0x26, 0x0B, 0xFD, 0x02, 0x03, 0xFF, 0x90, 0x26, 0x0B, 0xFD, 0x84, 0x20, 0x13, 0x6D, 0xF8, 0x2D,
  0x63, 0x17, 0x18, 0x12, 0x49, 0xD8, 0x2D, 0x63, 0x16, 0x0D, 0xD0, 0xD7, 0x71, 0x07, 0xB0, 0xD7,
  0x30, 0x8D, 0x08, 0x77, 0x10, 0x1B, 0x08, 0x73, 0x06, 0xD0, 0x67, 0x72, 0xB0, 0x57, 0x30, 0x5D,
  0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05,
  0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77,
  0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20,
  0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA,
  0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04,
  0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73,
  0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05,
  0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0,
  0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57,
  0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72,
  0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E,
  0xA0, 0x47, 0x30, 0x4D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x03, 0xD0, 0x67, 0x72, 0xB0, 0x27,
  0x30, 0x2D, 0x08, 0x77, 0x10, 0x3B, 0x01, 0x74, 0x0E, 0xC0, 0xB7, 0x71, 0x06, 0xA0, 0xD7, 0x50,
  0xBC, 0x0E, 0x01, 0x77, 0x0C, 0xA0, 0x97, 0x50, 0x6D, 0x07, 0x76, 0x03, 0xB0, 0x47, 0x60, 0xEC,
  0x0E, 0x02, 0x75, 0x0D, 0xA0, 0xC7, 0x70, 0x7D, 0x0D, 0x02, 0x73, 0x0B, 0xB0, 0x47, 0x71, 0x0B,
  0xD8, 0x1E, 0x81, 0x60, 0x50, 0xDB, 0x08, 0x77, 0x30, 0xAF, 0x84, 0xCA, 0x9A, 0xBE, 0xC0, 0x97,
  0x75, 0x06, 0x0E, 0xFE, 0x0E, 0x06, 0x77, 0x71, 0x06, 0x0C, 0xFA, 0x0C, 0x07, 0x77, 0x76, 0x86,
  0x35, 0x67, 0x65, 0x41, 0x77,
  // "Ü" (U+00DC)
  0x76, 0x82, 0x8E, 0xE8, 0x58, 0x33, 0xCE, 0xC3, 0x77, 0x71, 0x05, 0xC0, 0x74, 0x0E, 0xB0, 0xE7,
  0x77, 0x10, 0x9C, 0x0B, 0x30, 0x2D, 0x02, 0x77, 0x70, 0x9C, 0x0B, 0x30, 0x2D, 0x02, 0x77, 0x70,
  0x5C, 0x08, 0x40, 0xEB, 0x0E, 0x77, 0x72, 0x82, 0x8E, 0xE9, 0x58, 0x34, 0xCE, 0xC3, 0x80, 0xBC,
  0x40, 0x03, 0xFF, 0x90, 0x26, 0x0B, 0xFD, 0x02, 0x03, 0xFF, 0x90, 0x26, 0x0B, 0xFD, 0x02, 0x03,
  0xFF, 0x90, 0x26, 0x0B, 0xFD, 0x84, 0x20, 0x13, 0x6D, 0xF8, 0x2D, 0x63, 0x17, 0x18, 0x12, 0x49,
  0xD8, 0x2D, 0x63, 0x16, 0x0D, 0xD0, 0xD7, 0x71, 0x07, 0xB0, 0xD7, 0x30, 0x8D, 0x08, 0x77, 0x10,
  0x1B, 0x08, 0x73, 0x06, 0xD0, 0x67, 0x72, 0xB0, 0x57, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04,
  0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73,
  0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05,
  0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0,
  0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57,
  0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72,
  0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E,
  0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0,
  0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47,
  0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30,
  0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D,
  0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x4D, 0x05,
  0x77, 0x20, 0xEA, 0x04, 0x73, 0x03, 0xD0, 0x67, 0x72, 0xB0, 0x27, 0x30, 0x2D, 0x08, 0x77, 0x10,
  0x3B, 0x01, 0x74, 0x0E, 0xC0, 0xB7, 0x71, 0x06, 0xA0, 0xD7, 0x50, 0xBC, 0x0E, 0x01, 0x77, 0x0C,
  0xA0, 0x97, 0x50, 0x6D, 0x07, 0x76, 0x03, 0xB0, 0x47, 0x60, 0xEC, 0x0E, 0x02, 0x75, 0x0D, 0xA0,
  0xC7, 0x70, 0x7D, 0x0D, 0x02, 0x73, 0x0B, 0xB0, 0x47, 0x71, 0x0B, 0xD8, 0x1E, 0x81, 0x60, 0x50,
  0xDB, 0x08, 0x77, 0x30, 0xAF, 0x84, 0xCA, 0x9A, 0xBE, 0xC0, 0x97, 0x75, 0x06, 0x0E, 0xFE, 0x0E,
  0x06, 0x77, 0x71, 0x06, 0x0C, 0xFA, 0x0C, 0x07, 0x77, 0x76, 0x86, 0x35, 0x67, 0x65, 0x41, 0x77,
  // "Ý" (U+00DD)
  0x77, 0x68, 0x02, 0x77, 0x77, 0x60, 0x4D, 0x0C, 0x77, 0x76, 0x0B, 0xC0, 0xE0, 0x27, 0x77, 0x50,
  0x4D, 0x04, 0x77, 0x76, 0x0C, 0xC0, 0x67, 0x77, 0x60, 0x5C, 0x07, 0x77, 0x77, 0x0E, 0xB0, 0x77,
  0x77, 0x70, 0x8B, 0x06, 0x77, 0x77, 0x02, 0xB0, 0x57, 0x77, 0x71, 0x82, 0x8F, 0xE3, 0x80, 0xAA,
  0x30, 0x03, 0xFF, 0x02, 0x50, 0xAF, 0xC0, 0xB0, 0x3F, 0xF0, 0x25, 0x0A, 0xFC, 0x0B, 0x03, 0xFF,
  0x02, 0x50, 0xAF, 0xC8, 0x3B, 0x01, 0x4C, 0xF8, 0x2D, 0x41, 0x17, 0x82, 0x12, 0x6E, 0xD8, 0x1B,
  0x31, 0x40, 0xDE, 0x05, 0x76, 0x06, 0xC0, 0xB7, 0x04, 0xE0, 0x57, 0x60, 0x2B, 0x0E, 0x01, 0x71,
  0x0A, 0xD0, 0x87, 0x60, 0x4B, 0x07, 0x72, 0x03, 0xD0, 0xE7, 0x60, 0x8A, 0x0E, 0x74, 0x0A, 0xD0,
  0x67, 0x50, 0xDA, 0x07, 0x74, 0x02, 0xD0, 0xD7, 0x40, 0x5A, 0x0E, 0x76, 0x0A, 0xD0, 0x57, 0x30,
  0xDA, 0x07, 0x76, 0x02, 0xD0, 0xD7, 0x20, 0x5A, 0x0E, 0x77, 0x10, 0xAD, 0x05, 0x71, 0x0D, 0xA0,
  0x77, 0x71, 0x02, 0xD0, 0xD7, 0x06, 0xA0, 0xE7, 0x73, 0x0A, 0xD0, 0x56, 0x0D, 0xA0, 0x77, 0x73,
  0x02, 0xD0, 0xC5, 0x06, 0xA0, 0xE7, 0x75, 0x0A, 0xD0, 0x44, 0x0D, 0xA0, 0x77, 0x75, 0x02, 0xD0,
  0xB3, 0x04, 0xA0, 0xE7, 0x77, 0x09, 0xD0, 0x22, 0x0B, 0xA0, 0x67, 0x77, 0x02, 0xD8, 0x19, 0x03,
  0xA0, 0xE7, 0x77, 0x20, 0x9C, 0x81, 0xE0, 0xAA, 0x06, 0x77, 0x72, 0x02, 0xD0, 0x7A, 0x0E, 0x77,
  0x74, 0x09, 0xF0, 0x67, 0x77, 0x40, 0x2E, 0x0D, 0x77, 0x76, 0x09, 0xD0, 0x67, 0x77, 0x60, 0x6D,
  0x04, 0x77, 0x76, 0x06, 0xD0, 0x47, 0x77, 0x60, 0x6D, 0x04, 0x77, 0x76, 0x06, 0xD0, 0x47, 0x77,
  0x60, 0x6D, 0x04, 0x77, 0x76, 0x06, 0xD0, 0x47, 0x77, 0x60, 0x6D, 0x04, 0x77, 0x76, 0x06, 0xD0,
  0x47, 0x77, 0x60, 0x6D, 0x04, 0x77, 0x76, 0x06, 0xD0, 0x47, 0x77, 0x60, 0x6D, 0x04, 0x77, 0x76,
  0x07, 0xD0, 0x47, 0x77, 0x60, 0x9D, 0x07, 0x77, 0x75, 0x01, 0x0E, 0xD0, 0xD7, 0x77, 0x28, 0x21,
  0x37, 0xEF, 0x82, 0xD6, 0x31, 0x77, 0x40, 0xCF, 0xF9, 0x0A, 0x77, 0x30, 0xCF, 0xF9, 0x0A, 0x77,
  0x30, 0xCF, 0xF9, 0x0A, 0x71,
  // "Þ" (U+00DE)
  0x02, 0xFF, 0x90, 0xB7, 0x50, 0x2F, 0xF9, 0x0B, 0x75, 0x02, 0xFF, 0x90, 0xB7, 0x68, 0x21, 0x25,
  0xCF, 0x82, 0xD6, 0x31, 0x77, 0x40, 0xCD, 0x0E, 0x01, 0x77, 0x70, 0x7D, 0x09, 0x77, 0x71, 0x05,
  0xD0, 0x77, 0x77, 0x10, 0x4D, 0x06, 0x77, 0x71, 0x04, 0xD0, 0x67, 0x77, 0x10, 0x4F, 0xB8, 0x4E,
  0xDC, 0x96, 0x17, 0x50, 0x4F, 0xFA, 0x0A, 0x03, 0x73, 0x04, 0xFF, 0xC0, 0x77, 0x20, 0x4D, 0x86,
  0x71, 0x11, 0x23, 0x6B, 0xE0, 0x97, 0x10, 0x4D, 0x06, 0x70, 0x40, 0xED, 0x05, 0x70, 0x4D, 0x06,
  0x71, 0x04, 0xD0, 0xE7, 0x04, 0xD0, 0x67, 0x20, 0xAD, 0x06, 0x60, 0x4D, 0x06, 0x72, 0x04, 0xD0,
  0xB6, 0x04, 0xD0, 0x67, 0x20, 0x1D, 0x0E, 0x60, 0x4D, 0x06, 0x73, 0x0D, 0xD0, 0x25, 0x04, 0xD0,
  0x67, 0x30, 0xCD, 0x03, 0x50, 0x4D, 0x06, 0x73, 0x0B, 0xD0, 0x45, 0x04, 0xD0, 0x67, 0x30, 0xBD,
  0x04, 0x50, 0x4D, 0x06, 0x73, 0x0C, 0xD0, 0x45, 0x04, 0xD0, 0x67, 0x30, 0xDD, 0x02, 0x50, 0x4D,
  0x06, 0x73, 0x0E, 0xC0, 0xE6, 0x04, 0xD0, 0x67, 0x20, 0x2D, 0x0A, 0x60, 0x4D, 0x06, 0x72, 0x06,
  0xD0, 0x56, 0x04, 0xD0, 0x67, 0x20, 0xCC, 0x0E, 0x70, 0x4D, 0x06, 0x71, 0x06, 0xD0, 0x67, 0x04,
  0xD0, 0x67, 0x07, 0xD0, 0xB7, 0x10, 0x4D, 0x86, 0x71, 0x11, 0x24, 0x8D, 0xD0, 0xB7, 0x20, 0x4F,
  0xFB, 0x09, 0x73, 0x04, 0xFF, 0x90, 0xB0, 0x37, 0x40, 0x4F, 0xA8, 0x4E, 0xEC, 0x96, 0x17, 0x60,
  0x4D, 0x06, 0x77, 0x71, 0x04, 0xD0, 0x67, 0x77, 0x10, 0x5D, 0x06, 0x77, 0x71, 0x07, 0xD0, 0x87,
  0x77, 0x10, 0xCD, 0x0D, 0x77, 0x48, 0x21, 0x25, 0xCF, 0x82, 0xD6, 0x21, 0x76, 0x02, 0xFF, 0x90,
  0xB7, 0x50, 0x2F, 0xF9, 0x0B, 0x75, 0x02, 0xFF, 0x90, 0xB7, 0x50,
  // "ß" (U+00DF)
  0x74, 0x89, 0x03, 0x8B, 0xDE, 0xFE, 0xDA, 0x67, 0x75, 0x04, 0x0C, 0xFB, 0x0E, 0x07, 0x77, 0x20,
  0x9F, 0xF0, 0xB7, 0x70, 0x9D, 0x85, 0xB5, 0x21, 0x37, 0xDC, 0x0A, 0x75, 0x05, 0xD0, 0x76, 0x01,
  0x0B, 0xC0, 0x57, 0x40, 0xDC, 0x0A, 0x71, 0x01, 0x0E, 0xB0, 0xD7, 0x30, 0x4D, 0x01, 0x72, 0x08,
  0xC0, 0x47, 0x20, 0x9C, 0x0B, 0x73, 0x02, 0xC0, 0xA7, 0x20, 0xCC, 0x07, 0x74, 0x0D, 0xB0, 0xE7,
  0x2D, 0x05, 0x74, 0x0A, 0xC0, 0x27, 0x1D, 0x04, 0x74, 0x08, 0xC0, 0x47, 0x01, 0xD0, 0x37, 0x40,
  0x7C, 0x07, 0x70, 0x1D, 0x03, 0x74, 0x06, 0xC0, 0x97, 0x01, 0xD0, 0x37, 0x40, 0x5C, 0x0A, 0x30,
  0x7F, 0xA0, 0x37, 0x82, 0x38, 0xCE, 0xD0, 0xB3, 0x07, 0xFA, 0x03, 0x50, 0x10, 0xBF, 0xA0, 0xC3,
  0x07, 0xFA, 0x03, 0x40, 0x10, 0xDF, 0xB0, 0xD4, 0x0F, 0x10, 0x3D, 0x03, 0x40, 0xAD, 0x81, 0x94,
  0x28, 0x00, 0x17, 0x01, 0xD0, 0x33, 0x02, 0xC0, 0xE0, 0x27, 0x70, 0x1D, 0x03, 0x30, 0x7C, 0x06,
  0x77, 0x10, 0x1D, 0x03, 0x30, 0xAC, 0x77, 0x20, 0x1D, 0x03, 0x30, 0xCB, 0x0D, 0x77, 0x20, 0x1D,
  0x03, 0x30, 0xCB, 0x0E, 0x77, 0x20, 0x1D, 0x03, 0x30, 0xBC, 0x01, 0x77, 0x10, 0x1D, 0x03, 0x30,
  0x8C, 0x09, 0x77, 0x10, 0x1D, 0x03, 0x30, 0x3D, 0x07, 0x77, 0x01, 0xD0, 0x34, 0x0B, 0xD0, 0x97,
  0x60, 0x1D, 0x03, 0x40, 0x20, 0xED, 0x0D, 0x05, 0x74, 0x01, 0xD0, 0x35, 0x02, 0x0D, 0xE0, 0xB0,
  0x27, 0x20, 0x1D, 0x03, 0x60, 0x10, 0xBE, 0x0E, 0x05, 0x71, 0x01, 0xD0, 0x37, 0x10, 0x60, 0xEE,
  0x06, 0x70, 0x1D, 0x03, 0x72, 0x01, 0x09, 0xE0, 0x56, 0x01, 0xD0, 0x37, 0x40, 0x40, 0xEC, 0x0E,
  0x01, 0x50, 0x1D, 0x03, 0x75, 0x02, 0x0E, 0xC0, 0x95, 0x01, 0xD0, 0x37, 0x60, 0x5C, 0x0E, 0x50,
  0x1D, 0x03, 0x50, 0x17, 0x10, 0xCC, 0x03, 0x40, 0x1D, 0x03, 0x38, 0x17, 0xE7, 0x71, 0x08, 0xC0,
  0x54, 0x01, 0xD0, 0x32, 0x04, 0xA0, 0x97, 0x10, 0x6C, 0x06, 0x40, 0x1D, 0x03, 0x20, 0x8A, 0x0B,
  0x71, 0x06, 0xC0, 0x54, 0x02, 0xD0, 0x32, 0x09, 0xB7, 0x10, 0x7C, 0x04, 0x40, 0x4D, 0x03, 0x20,
  0x9B, 0x06, 0x70, 0xBC, 0x01, 0x40, 0x9D, 0x03, 0x20, 0x6B, 0x0D, 0x60, 0x2C, 0x84, 0xB0, 0x11,
  0x39, 0xE0, 0x32, 0x01, 0xC0, 0xB0, 0x13, 0x01, 0x0C, 0xC0, 0x41, 0xFB, 0x03, 0x30, 0x7D, 0x81,
  0xB9, 0xAD, 0x09, 0x2F, 0xB0, 0x34, 0x08, 0xFC, 0x09, 0x3F, 0xB0, 0x35, 0x03, 0x0B, 0xF0, 0xC0,
  0x57, 0x77, 0x18, 0x51, 0x46, 0x76, 0x51, 0x60,
  // "à" (U+00E0)
  0x40, 0x48, 0x01, 0x70, 0x37, 0x75, 0x05, 0xD0, 0xB7, 0x76, 0x09, 0xD0, 0x37, 0x76, 0x0C, 0xC0,
  0xA7, 0x76, 0x01, 0x0D, 0xC0, 0x37, 0x76, 0x02, 0x0D, 0xB0, 0xC7, 0x77, 0x02, 0x0D, 0xB0, 0x57,
  0x77, 0x02, 0x0D, 0xA0, 0xE0, 0x17, 0x77, 0x01, 0x0C, 0xA0, 0x97, 0x77, 0x20, 0xAA, 0x01, 0x80,
  0x9E, 0x60, 0x86, 0x24, 0x67, 0x76, 0x41, 0x77, 0x18, 0x12, 0x9E, 0xF9, 0x0D, 0x06, 0x75, 0x08,
  0xFE, 0x0C, 0x02, 0x72, 0x08, 0xD8, 0x3E, 0xB9, 0x9C, 0xD0, 0xD7, 0x10, 0x1D, 0x0B, 0x01, 0x40,
  0x40, 0xEC, 0x08, 0x70, 0x4D, 0x01, 0x60, 0x7C, 0x0E, 0x70, 0x5C, 0x0B, 0x70, 0x1D, 0x04, 0x60,
  0x1C, 0x07, 0x71, 0x0D, 0xC0, 0x77, 0x06, 0xB0, 0x67, 0x10, 0xBC, 0x09, 0x71, 0x82, 0x16, 0x83,
  0x71, 0x0A, 0xC0, 0xA7, 0x76, 0x0A, 0xC0, 0xB7, 0x76, 0x09, 0xC0, 0xB7, 0x76, 0x09, 0xC0, 0xB7,
  0x76, 0x09, 0xC0, 0xB7, 0x38, 0x43, 0x7A, 0xDE, 0xEF, 0xA0, 0xB7, 0x10, 0x50, 0xDF, 0xF9, 0x0B,
  0x70, 0xAD, 0x86, 0xC7, 0x43, 0x22, 0x29, 0xC0, 0xB6, 0x0A, 0xD0, 0x57, 0x09, 0xC0, 0xB5, 0x04,
  0xD0, 0x67, 0x10, 0x9C, 0x0B, 0x50, 0xCC, 0x0C, 0x72, 0x09, 0xC0, 0xB4, 0x01, 0xD0, 0x77, 0x20,
  0x9C, 0x0B, 0x40, 0x4D, 0x03, 0x72, 0x09, 0xC0, 0xB4, 0x06, 0xD0, 0x17, 0x20, 0xAC, 0x0B, 0x40,
  0x7D, 0x01, 0x72, 0x0C, 0xC0, 0xB4, 0x06, 0xD0, 0x17, 0x2D, 0x0B, 0x40, 0x5D, 0x02, 0x71, 0x05,
  0xD0, 0xB4, 0x03, 0xD0, 0x57, 0x10, 0xCD, 0x0C, 0x5D, 0x09, 0x78, 0x16, 0xF7, 0xC0, 0xD5, 0x0B,
  0xD0, 0x25, 0x83, 0x5F, 0xA0, 0xEC, 0x02, 0x40, 0x4D, 0x89, 0x1E, 0x51, 0x24, 0xAF, 0xE1, 0x0C,
  0xC8, 0x1D, 0x41, 0x30, 0x9F, 0xC0, 0x42, 0x0A, 0xF0, 0x13, 0x0A, 0xFA, 0x06, 0x30, 0x8F, 0x01,
  0x40, 0x60, 0xED, 0x0D, 0x04, 0x40, 0x6F, 0x01, 0x68, 0x34, 0x67, 0x63, 0x77, 0x10,
  // "á" (U+00E1)
  0x77, 0x80, 0x27, 0x77, 0x50, 0x4D, 0x0C, 0x77, 0x50, 0xBC, 0x0E, 0x02, 0x77, 0x40, 0x4D, 0x04,
  0x77, 0x50, 0xCC, 0x06, 0x77, 0x50, 0x5C, 0x07, 0x77, 0x60, 0xEB, 0x07, 0x77, 0x60, 0x8B, 0x06,
  0x77, 0x60, 0x2B, 0x05, 0x77, 0x78, 0x28, 0xFE, 0x38, 0x09, 0xF1, 0x08, 0x62, 0x46, 0x77, 0x64,
  0x17, 0x71, 0x81, 0x29, 0xEF, 0x90, 0xD0, 0x67, 0x50, 0x8F, 0xE0, 0xC0, 0x27, 0x20, 0x8D, 0x83,
  0xEB, 0x99, 0xCD, 0x0D, 0x71, 0x01, 0xD0, 0xB0, 0x14, 0x04, 0x0E, 0xC0, 0x87, 0x04, 0xD0, 0x16,
  0x07, 0xC0, 0xE7, 0x05, 0xC0, 0xB7, 0x01, 0xD0, 0x46, 0x01, 0xC0, 0x77, 0x10, 0xDC, 0x07, 0x70,
  0x6B, 0x06, 0x71, 0x0B, 0xC0, 0x97, 0x18, 0x21, 0x68, 0x37, 0x10, 0xAC, 0x0A, 0x77, 0x60, 0xAC,
  0x0B, 0x77, 0x60, 0x9C, 0x0B, 0x77, 0x60, 0x9C, 0x0B, 0x77, 0x60, 0x9C, 0x0B, 0x73, 0x84, 0x37,
  0xAD, 0xEE, 0xFA, 0x0B, 0x71, 0x05, 0x0D, 0xFF, 0x90, 0xB7, 0x0A, 0xD8, 0x6C, 0x74, 0x32, 0x22,
  0x9C, 0x0B, 0x60, 0xAD, 0x05, 0x70, 0x9C, 0x0B, 0x50, 0x4D, 0x06, 0x71, 0x09, 0xC0, 0xB5, 0x0C,
  0xC0, 0xC7, 0x20, 0x9C, 0x0B, 0x40, 0x1D, 0x07, 0x72, 0x09, 0xC0, 0xB4, 0x04, 0xD0, 0x37, 0x20,
  0x9C, 0x0B, 0x40, 0x6D, 0x01, 0x72, 0x0A, 0xC0, 0xB4, 0x07, 0xD0, 0x17, 0x20, 0xCC, 0x0B, 0x40,
  0x6D, 0x01, 0x72, 0xD0, 0xB4, 0x05, 0xD0, 0x27, 0x10, 0x5D, 0x0B, 0x40, 0x3D, 0x05, 0x71, 0x0C,
  0xD0, 0xC5, 0xD0, 0x97, 0x81, 0x6F, 0x7C, 0x0D, 0x50, 0xBD, 0x02, 0x58, 0x35, 0xFA, 0x0E, 0xC0,
  0x24, 0x04, 0xD8, 0x91, 0xE5, 0x12, 0x4A, 0xFE, 0x10, 0xCC, 0x81, 0xD4, 0x13, 0x09, 0xFC, 0x04,
  0x20, 0xAF, 0x01, 0x30, 0xAF, 0xA0, 0x63, 0x08, 0xF0, 0x14, 0x06, 0x0E, 0xD0, 0xD0, 0x44, 0x06,
  0xF0, 0x16, 0x83, 0x46, 0x76, 0x37, 0x71,
  // "â" (U+00E2)
  0x72, 0x03, 0x80, 0x17, 0x77, 0x60, 0xCD, 0x04, 0x77, 0x40, 0x5E, 0x0C, 0x77, 0x40, 0xDF, 0x05,
  0x77, 0x20, 0x8B, 0x0C, 0x07, 0xB0, 0xD7, 0x71, 0x02, 0xB8, 0x2E, 0x20, 0x9B, 0x08, 0x77, 0x0B,
  0xA0, 0xE0, 0x33, 0x0B, 0xB0, 0x27, 0x50, 0x6A, 0x0E, 0x04, 0x50, 0xBA, 0x0C, 0x74, 0x83, 0x2E,
  0xFE, 0x47, 0x0B, 0xA0, 0x87, 0x38, 0x28, 0xFE, 0x37, 0x20, 0xAA, 0x80, 0x9E, 0x20, 0x86, 0x24,
  0x67, 0x76, 0x41, 0x77, 0x18, 0x12, 0x9E, 0xF9, 0x0D, 0x06, 0x75, 0x08, 0xFE, 0x0C, 0x02, 0x72,
  0x08, 0xD8, 0x3E, 0xB9, 0x9C, 0xD0, 0xD7, 0x10, 0x1D, 0x0B, 0x01, 0x40, 0x40, 0xEC, 0x08, 0x70,
  0x4D, 0x01, 0x60, 0x7C, 0x0E, 0x70, 0x5C, 0x0B, 0x70, 0x1D, 0x04, 0x60, 0x1C, 0x07, 0x71, 0x0D,
  0xC0, 0x77, 0x06, 0xB0, 0x67, 0x10, 0xBC, 0x09, 0x71, 0x82, 0x16, 0x83, 0x71, 0x0A, 0xC0, 0xA7,
  0x76, 0x0A, 0xC0, 0xB7, 0x76, 0x09, 0xC0, 0xB7, 0x76, 0x09, 0xC0, 0xB7, 0x76, 0x09, 0xC0, 0xB7,
  0x38, 0x43, 0x7A, 0xDE, 0xEF, 0xA0, 0xB7, 0x10, 0x50, 0xDF, 0xF9, 0x0B, 0x70, 0xAD, 0x86, 0xC7,
  0x43, 0x22, 0x29, 0xC0, 0xB6, 0x0A, 0xD0, 0x57, 0x09, 0xC0, 0xB5, 0x04, 0xD0, 0x67, 0x10, 0x9C,
  0x0B, 0x50, 0xCC, 0x0C, 0x72, 0x09, 0xC0, 0xB4, 0x01, 0xD0, 0x77, 0x20, 0x9C, 0x0B, 0x40, 0x4D,
  0x03, 0x72, 0x09, 0xC0, 0xB4, 0x06, 0xD0, 0x17, 0x20, 0xAC, 0x0B, 0x40, 0x7D, 0x01, 0x72, 0x0C,
  0xC0, 0xB4, 0x06, 0xD0, 0x17, 0x2D, 0x0B, 0x40, 0x5D, 0x02, 0x71, 0x05, 0xD0, 0xB4, 0x03, 0xD0,
  0x57, 0x10, 0xCD, 0x0C, 0x5D, 0x09, 0x78, 0x16, 0xF7, 0xC0, 0xD5, 0x0B, 0xD0, 0x25, 0x83, 0x5F,
  0xA0, 0xEC, 0x02, 0x40, 0x4D, 0x89, 0x1E, 0x51, 0x24, 0xAF, 0xE1, 0x0C, 0xC8, 0x1D, 0x41, 0x30,
  0x9F, 0xC0, 0x42, 0x0A, 0xF0, 0x13, 0x0A, 0xFA, 0x06, 0x30, 0x8F, 0x01, 0x40, 0x60, 0xED, 0x0D,
  0x04, 0x40, 0x6F, 0x01, 0x68, 0x34, 0x67, 0x63, 0x77, 0x10,
  // "ã" (U+00E3)
  0x68, 0x44, 0xBE, 0xEB, 0x57, 0x81, 0x25, 0x57, 0x20, 0x5E, 0x0A, 0x01, 0x58, 0x19, 0xFE, 0x71,
  0x02, 0xF9, 0x0D, 0x03, 0x48, 0x1E, 0xFC, 0x71, 0x0A, 0xFB, 0x82, 0x71, 0x19, 0xA0, 0x87, 0x1A,
  0x83, 0xD3, 0x04, 0xDF, 0xB0, 0x27, 0x04, 0xA0, 0x54, 0x09, 0xF9, 0x0A, 0x71, 0x07, 0xA0, 0x15,
  0x05, 0x0E, 0xD0, 0xD0, 0x17, 0x18, 0x13, 0x65, 0x78, 0x51, 0x9D, 0xFD, 0x81, 0x80, 0x9E, 0x20,
  0x86, 0x24, 0x67, 0x76, 0x41, 0x77, 0x18, 0x12, 0x9E, 0xF9, 0x0D, 0x06, 0x75, 0x08, 0xFE, 0x0C,
  0x02, 0x72, 0x08, 0xD8, 0x3E, 0xB9, 0x9C, 0xD0, 0xD7, 0x10, 0x1D, 0x0B, 0x01, 0x40, 0x40, 0xEC,
  0x08, 0x70, 0x4D, 0x01, 0x60, 0x7C, 0x0E, 0x70, 0x5C, 0x0B, 0x70, 0x1D, 0x04, 0x60, 0x1C, 0x07,
  0x71, 0x0D, 0xC0, 0x77, 0x06, 0xB0, 0x67, 0x10, 0xBC, 0x09, 0x71, 0x82, 0x16, 0x83, 0x71, 0x0A,
  0xC0, 0xA7, 0x76, 0x0A, 0xC0, 0xB7, 0x76, 0x09, 0xC0, 0xB7, 0x76, 0x09, 0xC0, 0xB7, 0x76, 0x09,
  0xC0, 0xB7, 0x38, 0x43, 0x7A, 0xDE, 0xEF, 0xA0, 0xB7, 0x10, 0x50, 0xDF, 0xF9, 0x0B, 0x70, 0xAD,
  0x86, 0xC7, 0x43, 0x22, 0x29, 0xC0, 0xB6, 0x0A, 0xD0, 0x57, 0x09, 0xC0, 0xB5, 0x04, 0xD0, 0x67,
  0x10, 0x9C, 0x0B, 0x50, 0xCC, 0x0C, 0x72, 0x09, 0xC0, 0xB4, 0x01, 0xD0, 0x77, 0x20, 0x9C, 0x0B,
  0x40, 0x4D, 0x03, 0x72, 0x09, 0xC0, 0xB4, 0x06, 0xD0, 0x17, 0x20, 0xAC, 0x0B, 0x40, 0x7D, 0x01,
  0x72, 0x0C, 0xC0, 0xB4, 0x06, 0xD0, 0x17, 0x2D, 0x0B, 0x40, 0x5D, 0x02, 0x71, 0x05, 0xD0, 0xB4,
  0x03, 0xD0, 0x57, 0x10, 0xCD, 0x0C, 0x5D, 0x09, 0x78, 0x16, 0xF7, 0xC0, 0xD5, 0x0B, 0xD0, 0x25,
  0x83, 0x5F, 0xA0, 0xEC, 0x02, 0x40, 0x4D, 0x89, 0x1E, 0x51, 0x24, 0xAF, 0xE1, 0x0C, 0xC8, 0x1D,
  0x41, 0x30, 0x9F, 0xC0, 0x42, 0x0A, 0xF0, 0x13, 0x0A, 0xFA, 0x06, 0x30, 0x8F, 0x01, 0x40, 0x60,
  0xED, 0x0D, 0x04, 0x40, 0x6F, 0x01, 0x68, 0x34, 0x67, 0x63, 0x77, 0x10,
  // "ä" (U+00E4)
  0x58, 0x28, 0xEE, 0x85, 0x83, 0x3C, 0xEC, 0x37, 0x40, 0x5C, 0x07, 0x40, 0xEB, 0x0E, 0x74, 0x09,
  0xC0, 0xB3, 0x02, 0xD0, 0x27, 0x30, 0x9C, 0x0B, 0x30, 0x2D, 0x02, 0x73, 0x05, 0xC0, 0x84, 0x0E,
  0xB0, 0xE7, 0x58, 0x28, 0xEE, 0x95, 0x83, 0x4C, 0xEC, 0x38, 0x0A, 0xC7, 0x08, 0x62, 0x46, 0x77,
  0x64, 0x17, 0x71, 0x81, 0x29, 0xEF, 0x90, 0xD0, 0x67, 0x50, 0x8F, 0xE0, 0xC0, 0x27, 0x20, 0x8D,
  0x83, 0xEB, 0x99, 0xCD, 0x0D, 0x71, 0x01, 0xD0, 0xB0, 0x14, 0x04, 0x0E, 0xC0, 0x87, 0x04, 0xD0,
  0x16, 0x07, 0xC0, 0xE7, 0x05, 0xC0, 0xB7, 0x01, 0xD0, 0x46, 0x01, 0xC0, 0x77, 0x10, 0xDC, 0x07,
  0x70, 0x6B, 0x06, 0x71, 0x0B, 0xC0, 0x97, 0x18, 0x21, 0x68, 0x37, 0x10, 0xAC, 0x0A, 0x77, 0x60,
  0xAC, 0x0B, 0x77, 0x60, 0x9C, 0x0B, 0x77, 0x60, 0x9C, 0x0B, 0x77, 0x60, 0x9C, 0x0B, 0x73, 0x84,
  0x37, 0xAD, 0xEE, 0xFA, 0x0B, 0x71, 0x05, 0x0D, 0xFF, 0x90, 0xB7, 0x0A, 0xD8, 0x6C, 0x74, 0x32,
  0x22, 0x9C, 0x0B, 0x60, 0xAD, 0x05, 0x70, 0x9C, 0x0B, 0x50, 0x4D, 0x06, 0x71, 0x09, 0xC0, 0xB5,
  0x0C, 0xC0, 0xC7, 0x20, 0x9C, 0x0B, 0x40, 0x1D, 0x07, 0x72, 0x09, 0xC0, 0xB4, 0x04, 0xD0, 0x37,
  0x20, 0x9C, 0x0B, 0x40, 0x6D, 0x01, 0x72, 0x0A, 0xC0, 0xB4, 0x07, 0xD0, 0x17, 0x20, 0xCC, 0x0B,
  0x40, 0x6D, 0x01, 0x72, 0xD0, 0xB4, 0x05, 0xD0, 0x27, 0x10, 0x5D, 0x0B, 0x40, 0x3D, 0x05, 0x71,
  0x0C, 0xD0, 0xC5, 0xD0, 0x97, 0x81, 0x6F, 0x7C, 0x0D, 0x50, 0xBD, 0x02, 0x58, 0x35, 0xFA, 0x0E,
  0xC0, 0x24, 0x04, 0xD8, 0x91, 0xE5, 0x12, 0x4A, 0xFE, 0x10, 0xCC, 0x81, 0xD4, 0x13, 0x09, 0xFC,
  0x04, 0x20, 0xAF, 0x01, 0x30, 0xAF, 0xA0, 0x63, 0x08, 0xF0, 0x14, 0x06, 0x0E, 0xD0, 0xD0, 0x44,
  0x06, 0xF0, 0x16, 0x83, 0x46, 0x76, 0x37, 0x71,
  // "å" (U+00E5)
  0x72, 0x05, 0x0B, 0xB0, 0xB0, 0x57, 0x74, 0x0A, 0xF0, 0xA7, 0x72, 0x08, 0xFA, 0x08, 0x77, 0x01,
  0xB8, 0x38, 0x20, 0x28, 0xB0, 0x17, 0x60, 0x6A, 0x07, 0x50, 0x7A, 0x06, 0x76, 0x09, 0xA0, 0x25,
  0x01, 0xA0, 0x87, 0x60, 0x9A, 0x01, 0x6A, 0x09, 0x76, 0x09, 0xA0, 0x25, 0x01, 0xA0, 0x87, 0x60,
  0x6A, 0x08, 0x50, 0x8A, 0x06, 0x76, 0x01, 0xB8, 0x39, 0x31, 0x39, 0xB0, 0x17, 0x70, 0x8F, 0xA0,
  0x77, 0x72, 0x09, 0xF0, 0x97, 0x74, 0x85, 0x4A, 0xEF, 0xEA, 0x48, 0x09, 0xB4, 0x08, 0x62, 0x46,
  0x77, 0x64, 0x17, 0x71, 0x81, 0x29, 0xEF, 0x90, 0xD0, 0x67, 0x50, 0x8F, 0xE0, 0xC0, 0x27, 0x20,
  0x8D, 0x83, 0xEB, 0x99, 0xCD, 0x0D, 0x71, 0x01, 0xD0, 0xB0, 0x14, 0x04, 0x0E, 0xC0, 0x87, 0x04,
  0xD0, 0x16, 0x07, 0xC0, 0xE7, 0x05, 0xC0, 0xB7, 0x01, 0xD0, 0x46, 0x01, 0xC0, 0x77, 0x10, 0xDC,
  0x07, 0x70, 0x6B, 0x06, 0x71, 0x0B, 0xC0, 0x97, 0x18, 0x21, 0x68, 0x37, 0x10, 0xAC, 0x0A, 0x77,
  0x60, 0xAC, 0x0B, 0x77, 0x60, 0x9C, 0x0B, 0x77, 0x60, 0x9C, 0x0B, 0x77, 0x60, 0x9C, 0x0B, 0x73,
  0x84, 0x37, 0xAD, 0xEE, 0xFA, 0x0B, 0x71, 0x05, 0x0D, 0xFF, 0x90, 0xB7, 0x0A, 0xD8, 0x6C, 0x74,
  0x32, 0x22, 0x9C, 0x0B, 0x60, 0xAD, 0x05, 0x70, 0x9C, 0x0B, 0x50, 0x4D, 0x06, 0x71, 0x09, 0xC0,
  0xB5, 0x0C, 0xC0, 0xC7, 0x20, 0x9C, 0x0B, 0x40, 0x1D, 0x07, 0x72, 0x09, 0xC0, 0xB4, 0x04, 0xD0,
  0x37, 0x20, 0x9C, 0x0B, 0x40, 0x6D, 0x01, 0x72, 0x0A, 0xC0, 0xB4, 0x07, 0xD0, 0x17, 0x20, 0xCC,
  0x0B, 0x40, 0x6D, 0x01, 0x72, 0xD0, 0xB4, 0x05, 0xD0, 0x27, 0x10, 0x5D, 0x0B, 0x40, 0x3D, 0x05,
  0x71, 0x0C, 0xD0, 0xC5, 0xD0, 0x97, 0x81, 0x6F, 0x7C, 0x0D, 0x50, 0xBD, 0x02, 0x58, 0x35, 0xFA,
  0x0E, 0xC0, 0x24, 0x04, 0xD8, 0x91, 0xE5, 0x12, 0x4A, 0xFE, 0x10, 0xCC, 0x81, 0xD4, 0x13, 0x09,
  0xFC, 0x04, 0x20, 0xAF, 0x01, 0x30, 0xAF, 0xA0, 0x63, 0x08, 0xF0, 0x14, 0x06, 0x0E, 0xD0, 0xD0,
  0x44, 0x06, 0xF0, 0x16, 0x83, 0x46, 0x76, 0x37, 0x71,
  // "æ" (U+00E6)
  0x71, 0x85, 0x25, 0x67, 0x76, 0x37, 0x38, 0x42, 0x57, 0x75, 0x37, 0x68, 0x12, 0x9E, 0xF8, 0x1E,
  0x81, 0x50, 0x50, 0xDE, 0x81, 0xE9, 0x17, 0x20, 0x7F, 0xD0, 0xE0, 0x32, 0x01, 0x0A, 0xFB, 0x0E,
  0x05, 0x70, 0x8D, 0x83, 0xEB, 0x9A, 0xCC, 0x82, 0xE2, 0x0C, 0xC8, 0x2C, 0x9A, 0xDD, 0x05, 0x50,
  0x1D, 0x0B, 0x01, 0x40, 0x40, 0xEB, 0x0C, 0x0A, 0xB0, 0xD0, 0x34, 0x05, 0xD0, 0x24, 0x04, 0xD0,
  0x16, 0x07, 0xF0, 0xE0, 0x16, 0x06, 0xC0, 0xC4, 0x05, 0xC0, 0xB7, 0x01, 0xF0, 0x67, 0x10, 0xDC,
  0x05, 0x30, 0x2C, 0x07, 0x71, 0x0D, 0xD0, 0xE7, 0x20, 0x7C, 0x0A, 0x40, 0x7B, 0x06, 0x71, 0x0B,
  0xD0, 0x97, 0x20, 0x3D, 0x01, 0x48, 0x23, 0x8A, 0x37, 0x10, 0xAD, 0x05, 0x73, 0xD0, 0x47, 0x72,
  0x0A, 0xD0, 0x37, 0x30, 0xDC, 0x07, 0x77, 0x20, 0x9D, 0x74, 0x0B, 0xC0, 0x97, 0x72, 0x09, 0xD7,
  0x40, 0xBC, 0x0A, 0x77, 0x20, 0x9C, 0x0E, 0x80, 0x71, 0x0A, 0xC0, 0xB6, 0x84, 0x37, 0xAD, 0xEE,
  0xFF, 0xFD, 0x0C, 0x40, 0x50, 0xDF, 0xFF, 0xFC, 0x0C, 0x30, 0xAD, 0x86, 0xC7, 0x43, 0x22, 0x29,
  0xFF, 0xF0, 0xC2, 0x0A, 0xD0, 0x67, 0x09, 0xC0, 0xC7, 0x74, 0x04, 0xD0, 0x67, 0x10, 0x9C, 0x0C,
  0x77, 0x40, 0xCC, 0x0D, 0x72, 0x09, 0xC0, 0xD7, 0x73, 0x01, 0xD0, 0x77, 0x20, 0x9C, 0x0E, 0x77,
  0x30, 0x4D, 0x04, 0x72, 0x09, 0xD0, 0x17, 0x72, 0x06, 0xD0, 0x27, 0x20, 0xAD, 0x03, 0x77, 0x20,
  0x7D, 0x01, 0x72, 0x0B, 0xD0, 0x67, 0x72, 0x06, 0xD0, 0x17, 0x20, 0xED, 0x0A, 0x77, 0x20, 0x5D,
  0x01, 0x71, 0x03, 0xE0, 0xE0, 0x17, 0x50, 0x12, 0x03, 0xD0, 0x37, 0x10, 0x9A, 0x0D, 0xC0, 0x77,
  0x50, 0xD0, 0x62, 0xD0, 0x77, 0x02, 0xA0, 0xA0, 0x4C, 0x0E, 0x01, 0x73, 0x81, 0x8F, 0xB2, 0x0A,
  0xC0, 0xD6, 0x01, 0x0C, 0xA8, 0x12, 0x0B, 0xC0, 0xC0, 0x17, 0x10, 0x8A, 0x09, 0x20, 0x4D, 0x09,
  0x40, 0x30, 0xDA, 0x06, 0x20, 0x20, 0xEC, 0x0D, 0x04, 0x50, 0x20, 0xBB, 0x03, 0x30, 0x9D, 0x82,
  0xD9, 0x9C, 0xB0, 0x84, 0x04, 0xE8, 0x3D, 0xA9, 0xAD, 0xC0, 0x85, 0x0A, 0xFB, 0x07, 0x60, 0x30,
  0xDF, 0xD0, 0x77, 0x06, 0x0D, 0xE0, 0xB0, 0x37, 0x20, 0x70, 0xDF, 0x81, 0xE9, 0x27, 0x38, 0x43,
  0x67, 0x75, 0x17, 0x68, 0x52, 0x56, 0x77, 0x53, 0x70,
  // "ç" (U+00E7)
  0x72, 0x85, 0x25, 0x67, 0x65, 0x27, 0x58, 0x11, 0x7D, 0xF8, 0x1E, 0x92, 0x71, 0x04, 0x0E, 0xFD,
  0x07, 0x60, 0x5D, 0x82, 0xEA, 0x9B, 0xE0, 0x74, 0x03, 0xD0, 0x84, 0x02, 0x0D, 0xD0, 0x13, 0x0D,
  0xC0, 0x86, 0x05, 0xD0, 0x52, 0x05, 0xC0, 0xD7, 0x10, 0xEC, 0x07, 0x20, 0xCC, 0x07, 0x71, 0x0A,
  0xC8, 0x16, 0x02, 0xD0, 0x17, 0x10, 0x8C, 0x81, 0x20, 0x6C, 0x0D, 0x72, 0x07, 0xA0, 0xE0, 0x52,
  0x0A, 0xC0, 0xA7, 0x28, 0x12, 0x53, 0x40, 0xDC, 0x08, 0x77, 0x20, 0xEC, 0x06, 0x77, 0x10, 0x1D,
  0x05, 0x77, 0x10, 0x2D, 0x04, 0x77, 0x10, 0x2D, 0x03, 0x77, 0x10, 0x3D, 0x03, 0x77, 0x10, 0x3D,
  0x03, 0x77, 0x10, 0x3D, 0x03, 0x77, 0x10, 0x2D, 0x04, 0x77, 0x10, 0x1D, 0x05, 0x77, 0x20, 0xEC,
  0x07, 0x77, 0x20, 0xDC, 0x09, 0x77, 0x20, 0x9C, 0x0B, 0x77, 0x20, 0x6D, 0x77, 0x20, 0x1D, 0x04,
  0x77, 0x20, 0xBC, 0x0A, 0x75, 0x0C, 0x02, 0x20, 0x4D, 0x03, 0x73, 0x81, 0x9F, 0x73, 0x0B, 0xC0,
  0xD0, 0x17, 0x10, 0x8A, 0x06, 0x30, 0x10, 0xEC, 0x0D, 0x04, 0x50, 0x20, 0xBB, 0x01, 0x40, 0x30,
  0xED, 0x83, 0xDA, 0x9A, 0xCC, 0x08, 0x60, 0x20, 0xCF, 0xD0, 0x87, 0x20, 0x50, 0xCF, 0x90, 0xA0,
  0x37, 0x50, 0x10, 0xBA, 0x81, 0x76, 0x47, 0x72, 0x81, 0xAF, 0xC7, 0x75, 0x83, 0xDF, 0xEA, 0x57,
  0x72, 0x01, 0xD0, 0xC0, 0x17, 0x71, 0x05, 0x0A, 0xC0, 0xC7, 0x73, 0x03, 0x0E, 0xB0, 0x57, 0x73,
  0x07, 0xB0, 0x97, 0x73, 0x04, 0xB0, 0xA7, 0x73, 0x06, 0xB0, 0x97, 0x73, 0x0A, 0xB0, 0x77, 0x40,
  0x34, 0x07, 0xC0, 0x27, 0x4A, 0x0E, 0x0D, 0xD0, 0x97, 0x5F, 0x90, 0x97, 0x68, 0x68, 0xBE, 0xFE,
  0xD9, 0x37,
  // "è" (U+00E8)
  0x50, 0x48, 0x01, 0x70, 0x37, 0x73, 0x05, 0xD0, 0xB7, 0x74, 0x09, 0xD0, 0x37, 0x74, 0x0C, 0xC0,
  0xA7, 0x74, 0x01, 0x0D, 0xC0, 0x37, 0x74, 0x02, 0x0D, 0xB0, 0xC7, 0x75, 0x02, 0x0D, 0xB0, 0x57,
  0x75, 0x02, 0x0D, 0xA0, 0xE0, 0x17, 0x75, 0x01, 0x0C, 0xA0, 0x97, 0x77, 0x0A, 0xA0, 0x18, 0x09,
  0xD4, 0x08, 0x42, 0x57, 0x76, 0x47, 0x72, 0x07, 0x0D, 0xF0, 0xB0, 0x37, 0x40, 0x30, 0xDF, 0xC0,
  0x97, 0x20, 0x30, 0xEC, 0x82, 0xEA, 0x9B, 0xD0, 0xB7, 0x01, 0x0E, 0xC0, 0x84, 0x01, 0x0C, 0xC0,
  0x96, 0x0B, 0xC0, 0x86, 0x01, 0x0E, 0xC0, 0x34, 0x04, 0xC0, 0xD7, 0x10, 0x6C, 0x0C, 0x40, 0xBC,
  0x06, 0x71, 0x01, 0xD0, 0x22, 0x01, 0xD0, 0x17, 0x20, 0xCC, 0x07, 0x20, 0x5C, 0x0C, 0x73, 0x08,
  0xC0, 0xB2, 0x09, 0xC0, 0x97, 0x30, 0x6C, 0x0E, 0x20, 0xCC, 0x07, 0x73, 0x04, 0xD8, 0x11, 0x0E,
  0xC0, 0x57, 0x30, 0x3D, 0x02, 0x1D, 0x05, 0x80, 0x61, 0x04, 0xD0, 0x30, 0x2F, 0xFF, 0x90, 0x03,
  0xFF, 0xF9, 0x04, 0x03, 0xFF, 0xF9, 0x04, 0x03, 0xD0, 0x37, 0x73, 0x02, 0xD0, 0x47, 0x73, 0x01,
  0xD0, 0x57, 0x74, 0xD0, 0x67, 0x74, 0x0E, 0xC0, 0x87, 0x74, 0x0B, 0xC0, 0xA7, 0x74, 0x08, 0xC0,
  0xD7, 0x74, 0x04, 0xD0, 0x27, 0x74, 0x0E, 0xC0, 0x77, 0x60, 0x14, 0x09, 0xC0, 0xD7, 0x50, 0x70,
  0xD4, 0x02, 0xD0, 0x77, 0x30, 0x3A, 0x03, 0x40, 0x8D, 0x04, 0x71, 0x03, 0x0E, 0xA0, 0x15, 0x0C,
  0xD0, 0x80, 0x15, 0x07, 0x0E, 0xA0, 0xA6, 0x01, 0x0D, 0xE8, 0x3B, 0x99, 0xBE, 0xB0, 0xD0, 0x17,
  0x01, 0x0B, 0xFD, 0x0B, 0x01, 0x73, 0x04, 0x0B, 0xF9, 0x0C, 0x05, 0x77, 0x86, 0x14, 0x67, 0x76,
  0x41, 0x70,
  // "é" (U+00E9)
  0x77, 0x80, 0x27, 0x77, 0x30, 0x4D, 0x0C, 0x77, 0x30, 0xBC, 0x0E, 0x02, 0x77, 0x20, 0x4D, 0x04,
  0x77, 0x30, 0xCC, 0x06, 0x77, 0x30, 0x5C, 0x07, 0x77, 0x40, 0xEB, 0x07, 0x77, 0x40, 0x8B, 0x06,
  0x77, 0x40, 0x2B, 0x05, 0x77, 0x58, 0x28, 0xFE, 0x38, 0x09, 0xE0, 0x08, 0x42, 0x57, 0x76, 0x47,
  0x72, 0x07, 0x0D, 0xF0, 0xB0, 0x37, 0x40, 0x30, 0xDF, 0xC0, 0x97, 0x20, 0x30, 0xEC, 0x82, 0xEA,
  0x9B, 0xD0, 0xB7, 0x01, 0x0E, 0xC0, 0x84, 0x01, 0x0C, 0xC0, 0x96, 0x0B, 0xC0, 0x86, 0x01, 0x0E,
  0xC0, 0x34, 0x04, 0xC0, 0xD7, 0x10, 0x6C, 0x0C, 0x40, 0xBC, 0x06, 0x71, 0x01, 0xD0, 0x22, 0x01,
  0xD0, 0x17, 0x20, 0xCC, 0x07, 0x20, 0x5C, 0x0C, 0x73, 0x08, 0xC0, 0xB2, 0x09, 0xC0, 0x97, 0x30,
  0x6C, 0x0E, 0x20, 0xCC, 0x07, 0x73, 0x04, 0xD8, 0x11, 0x0E, 0xC0, 0x57, 0x30, 0x3D, 0x02, 0x1D,
  0x05, 0x80, 0x61, 0x04, 0xD0, 0x30, 0x2F, 0xFF, 0x90, 0x03, 0xFF, 0xF9, 0x04, 0x03, 0xFF, 0xF9,
  0x04, 0x03, 0xD0, 0x37, 0x73, 0x02, 0xD0, 0x47, 0x73, 0x01, 0xD0, 0x57, 0x74, 0xD0, 0x67, 0x74,
  0x0E, 0xC0, 0x87, 0x74, 0x0B, 0xC0, 0xA7, 0x74, 0x08, 0xC0, 0xD7, 0x74, 0x04, 0xD0, 0x27, 0x74,
  0x0E, 0xC0, 0x77, 0x60, 0x14, 0x09, 0xC0, 0xD7, 0x50, 0x70, 0xD4, 0x02, 0xD0, 0x77, 0x30, 0x3A,
  0x03, 0x40, 0x8D, 0x04, 0x71, 0x03, 0x0E, 0xA0, 0x15, 0x0C, 0xD0, 0x80, 0x15, 0x07, 0x0E, 0xA0,
  0xA6, 0x01, 0x0D, 0xE8, 0x3B, 0x99, 0xBE, 0xB0, 0xD0, 0x17, 0x01, 0x0B, 0xFD, 0x0B, 0x01, 0x73,
  0x04, 0x0B, 0xF9, 0x0C, 0x05, 0x77, 0x86, 0x14, 0x67, 0x76, 0x41, 0x70,
  // "ê" (U+00EA)
  0x72, 0x03, 0x80, 0x17, 0x77, 0x40, 0xCD, 0x04, 0x77, 0x20, 0x5E, 0x0C, 0x77, 0x20, 0xDF, 0x05,
  0x77, 0x08, 0xB0, 0xC0, 0x7B, 0x0D, 0x76, 0x02, 0xB8, 0x2E, 0x20, 0x9B, 0x08, 0x75, 0x0B, 0xA0,
  0xE0, 0x33, 0x0B, 0xB0, 0x27, 0x30, 0x6A, 0x0E, 0x04, 0x50, 0xBA, 0x0C, 0x72, 0x83, 0x2E, 0xFE,
  0x47, 0x0B, 0xA0, 0x87, 0x18, 0x28, 0xFE, 0x37, 0x20, 0xAA, 0x80, 0x9D, 0x10, 0x84, 0x25, 0x77,
  0x64, 0x77, 0x20, 0x70, 0xDF, 0x0B, 0x03, 0x74, 0x03, 0x0D, 0xFC, 0x09, 0x72, 0x03, 0x0E, 0xC8,
  0x2E, 0xA9, 0xBD, 0x0B, 0x70, 0x10, 0xEC, 0x08, 0x40, 0x10, 0xCC, 0x09, 0x60, 0xBC, 0x08, 0x60,
  0x10, 0xEC, 0x03, 0x40, 0x4C, 0x0D, 0x71, 0x06, 0xC0, 0xC4, 0x0B, 0xC0, 0x67, 0x10, 0x1D, 0x02,
  0x20, 0x1D, 0x01, 0x72, 0x0C, 0xC0, 0x72, 0x05, 0xC0, 0xC7, 0x30, 0x8C, 0x0B, 0x20, 0x9C, 0x09,
  0x73, 0x06, 0xC0, 0xE2, 0x0C, 0xC0, 0x77, 0x30, 0x4D, 0x81, 0x10, 0xEC, 0x05, 0x73, 0x03, 0xD0,
  0x21, 0xD0, 0x58, 0x06, 0x10, 0x4D, 0x03, 0x02, 0xFF, 0xF9, 0x00, 0x3F, 0xFF, 0x90, 0x40, 0x3F,
  0xFF, 0x90, 0x40, 0x3D, 0x03, 0x77, 0x30, 0x2D, 0x04, 0x77, 0x30, 0x1D, 0x05, 0x77, 0x4D, 0x06,
  0x77, 0x40, 0xEC, 0x08, 0x77, 0x40, 0xBC, 0x0A, 0x77, 0x40, 0x8C, 0x0D, 0x77, 0x40, 0x4D, 0x02,
  0x77, 0x40, 0xEC, 0x07, 0x76, 0x01, 0x40, 0x9C, 0x0D, 0x75, 0x07, 0x0D, 0x40, 0x2D, 0x07, 0x73,
  0x03, 0xA0, 0x34, 0x08, 0xD0, 0x47, 0x10, 0x30, 0xEA, 0x01, 0x50, 0xCD, 0x08, 0x01, 0x50, 0x70,
  0xEA, 0x0A, 0x60, 0x10, 0xDE, 0x83, 0xB9, 0x9B, 0xEB, 0x0D, 0x01, 0x70, 0x10, 0xBF, 0xD0, 0xB0,
  0x17, 0x30, 0x40, 0xBF, 0x90, 0xC0, 0x57, 0x78, 0x61, 0x46, 0x77, 0x64, 0x17,
  // "ë" (U+00EB)
  0x58, 0x28, 0xEE, 0x85, 0x83, 0x3C, 0xEC, 0x37, 0x20, 0x5C, 0x07, 0x40, 0xEB, 0x0E, 0x72, 0x09,
  0xC0, 0xB3, 0x02, 0xD0, 0x27, 0x10, 0x9C, 0x0B, 0x30, 0x2D, 0x02, 0x71, 0x05, 0xC0, 0x84, 0x0E,
  0xB0, 0xE7, 0x38, 0x28, 0xEE, 0x95, 0x83, 0x4C, 0xEC, 0x38, 0x0A, 0xB2, 0x08, 0x42, 0x57, 0x76,
  0x47, 0x72, 0x07, 0x0D, 0xF0, 0xB0, 0x37, 0x40, 0x30, 0xDF, 0xC0, 0x97, 0x20, 0x30, 0xEC, 0x82,
  0xEA, 0x9B, 0xD0, 0xB7, 0x01, 0x0E, 0xC0, 0x84, 0x01, 0x0C, 0xC0, 0x96, 0x0B, 0xC0, 0x86, 0x01,
  0x0E, 0xC0, 0x34, 0x04, 0xC0, 0xD7, 0x10, 0x6C, 0x0C, 0x40, 0xBC, 0x06, 0x71, 0x01, 0xD0, 0x22,
  0x01, 0xD0, 0x17, 0x20, 0xCC, 0x07, 0x20, 0x5C, 0x0C, 0x73, 0x08, 0xC0, 0xB2, 0x09, 0xC0, 0x97,
  0x30, 0x6C, 0x0E, 0x20, 0xCC, 0x07, 0x73, 0x04, 0xD8, 0x11, 0x0E, 0xC0, 0x57, 0x30, 0x3D, 0x02,
  0x1D, 0x05, 0x80, 0x61, 0x04, 0xD0, 0x30, 0x2F, 0xFF, 0x90, 0x03, 0xFF, 0xF9, 0x04, 0x03, 0xFF,
  0xF9, 0x04, 0x03, 0xD0, 0x37, 0x73, 0x02, 0xD0, 0x47, 0x73, 0x01, 0xD0, 0x57, 0x74, 0xD0, 0x67,
  0x74, 0x0E, 0xC0, 0x87, 0x74, 0x0B, 0xC0, 0xA7, 0x74, 0x08, 0xC0, 0xD7, 0x74, 0x04, 0xD0, 0x27,
  0x74, 0x0E, 0xC0, 0x77, 0x60, 0x14, 0x09, 0xC0, 0xD7, 0x50, 0x70, 0xD4, 0x02, 0xD0, 0x77, 0x30,
  0x3A, 0x03, 0x40, 0x8D, 0x04, 0x71, 0x03, 0x0E, 0xA0, 0x15, 0x0C, 0xD0, 0x80, 0x15, 0x07, 0x0E,
  0xA0, 0xA6, 0x01, 0x0D, 0xE8, 0x3B, 0x99, 0xBE, 0xB0, 0xD0, 0x17, 0x01, 0x0B, 0xFD, 0x0B, 0x01,
  0x73, 0x04, 0x0B, 0xF9, 0x0C, 0x05, 0x77, 0x86, 0x14, 0x67, 0x76, 0x41, 0x70,
  // "ì" (U+00EC)
  0x04, 0x80, 0x17, 0x03, 0x72, 0x05, 0xD0, 0xB7, 0x30, 0x9D, 0x03, 0x73, 0x0C, 0xC0, 0xA7, 0x30,
  0x10, 0xDC, 0x03, 0x73, 0x02, 0x0D, 0xB0, 0xC7, 0x40, 0x20, 0xDB, 0x05, 0x74, 0x02, 0x0D, 0xA0,
  0xE0, 0x17, 0x40, 0x10, 0xCA, 0x09, 0x76, 0x0A, 0xA0, 0x18, 0x09, 0xA1, 0x00, 0x7F, 0xA0, 0x35,
  0x07, 0xFA, 0x03, 0x50, 0x7F, 0xA0, 0x36, 0x81, 0x24, 0xAE, 0x03, 0x72, 0x09, 0xD0, 0x37, 0x20,
  0x4D, 0x03, 0x72, 0x02, 0xD0, 0x37, 0x20, 0x1D, 0x03, 0x72, 0x01, 0xD0, 0x37, 0x20, 0x1D, 0x03,
  0x72, 0x01, 0xD0, 0x37, 0x20, 0x1D, 0x03, 0x72, 0x01, 0xD0, 0x37, 0x20, 0x1D, 0x03, 0x72, 0x01,
  0xD0, 0x37, 0x20, 0x1D, 0x03, 0x72, 0x01, 0xD0, 0x37, 0x20, 0x1D, 0x03, 0x72, 0x01, 0xD0, 0x37,
  0x20, 0x1D, 0x03, 0x72, 0x01, 0xD0, 0x37, 0x20, 0x1D, 0x03, 0x72, 0x01, 0xD0, 0x37, 0x20, 0x1D,
  0x03, 0x72, 0x01, 0xD0, 0x37, 0x20, 0x2D, 0x04, 0x72, 0x04, 0xD0, 0x67, 0x20, 0x9D, 0x0C, 0x58,
  0x21, 0x24, 0xAF, 0x84, 0xC5, 0x21, 0x0D, 0xFE, 0x81, 0xE0, 0xDF, 0xE8, 0x1E, 0x0D, 0xFE, 0x0E,
  // "í" (U+00ED)
  0x72, 0x80, 0x27, 0x71, 0x04, 0xD0, 0xC7, 0x10, 0xBC, 0x0E, 0x02, 0x70, 0x4D, 0x04, 0x71, 0x0C,
  0xC0, 0x67, 0x10, 0x5C, 0x07, 0x72, 0x0E, 0xB0, 0x77, 0x20, 0x8B, 0x06, 0x72, 0x02, 0xB0, 0x57,
  0x38, 0x28, 0xFE, 0x38, 0x09, 0x96, 0x00, 0x7F, 0xA0, 0x34, 0x07, 0xFA, 0x03, 0x40, 0x7F, 0xA0,
  0x35, 0x81, 0x24, 0xAE, 0x03, 0x71, 0x09, 0xD0, 0x37, 0x10, 0x4D, 0x03, 0x71, 0x02, 0xD0, 0x37,
  0x10, 0x1D, 0x03, 0x71, 0x01, 0xD0, 0x37, 0x10, 0x1D, 0x03, 0x71, 0x01, 0xD0, 0x37, 0x10, 0x1D,
  0x03, 0x71, 0x01, 0xD0, 0x37, 0x10, 0x1D, 0x03, 0x71, 0x01, 0xD0, 0x37, 0x10, 0x1D, 0x03, 0x71,
  0x01, 0xD0, 0x37, 0x10, 0x1D, 0x03, 0x71, 0x01, 0xD0, 0x37, 0x10, 0x1D, 0x03, 0x71, 0x01, 0xD0,
  0x37, 0x10, 0x1D, 0x03, 0x71, 0x01, 0xD0, 0x37, 0x10, 0x1D, 0x03, 0x71, 0x01, 0xD0, 0x37, 0x10,
  0x2D, 0x04, 0x71, 0x04, 0xD0, 0x67, 0x10, 0x9D, 0x0C, 0x48, 0x21, 0x24, 0xAF, 0x83, 0xC5, 0x21,
  0xDF, 0xE0, 0xE0, 0xDF, 0xE0, 0xE0, 0xDF, 0xE0, 0xE0,
  // "î" (U+00EE)
  0x50, 0x38, 0x01, 0x77, 0x30, 0xCD, 0x04, 0x71, 0x05, 0xE0, 0xC7, 0x10, 0xDF, 0x05, 0x60, 0x8B,
  0x0C, 0x07, 0xB0, 0xD5, 0x02, 0xB8, 0x2E, 0x20, 0x9B, 0x08, 0x40, 0xBA, 0x0E, 0x03, 0x30, 0xBB,
  0x02, 0x20, 0x6A, 0x0E, 0x04, 0x50, 0xBA, 0x85, 0xC0, 0x2E, 0xFE, 0x47, 0x0B, 0xA8, 0x38, 0x8F,
  0xE3, 0x72, 0x0A, 0xA8, 0x09, 0x95, 0x00, 0x7F, 0xA0, 0x35, 0x07, 0xFA, 0x03, 0x50, 0x7F, 0xA0,
  0x36, 0x81, 0x24, 0xAE, 0x03, 0x72, 0x09, 0xD0, 0x37, 0x20, 0x4D, 0x03, 0x72, 0x02, 0xD0, 0x37,
  0x20, 0x1D, 0x03, 0x72, 0x01, 0xD0, 0x37, 0x20, 0x1D, 0x03, 0x72, 0x01, 0xD0, 0x37, 0x20, 0x1D,
  0x03, 0x72, 0x01, 0xD0, 0x37, 0x20, 0x1D, 0x03, 0x72, 0x01, 0xD0, 0x37, 0x20, 0x1D, 0x03, 0x72,
  0x01, 0xD0, 0x37, 0x20, 0x1D, 0x03, 0x72, 0x01, 0xD0, 0x37, 0x20, 0x1D, 0x03, 0x72, 0x01, 0xD0,
  0x37, 0x20, 0x1D, 0x03, 0x72, 0x01, 0xD0, 0x37, 0x20, 0x1D, 0x03, 0x72, 0x01, 0xD0, 0x37, 0x20,
  0x2D, 0x04, 0x72, 0x04, 0xD0, 0x67, 0x20, 0x9D, 0x0C, 0x58, 0x21, 0x24, 0xAF, 0x84, 0xC5, 0x21,
  0x0D, 0xFE, 0x81, 0xE0, 0xDF, 0xE8, 0x1E, 0x0D, 0xFE, 0x0E,
  // "ï" (U+00EF)
  0x18, 0x28, 0xEE, 0x85, 0x85, 0x3C, 0xEC, 0x30, 0x5C, 0x07, 0x40, 0xEB, 0x81, 0xE0, 0x9C, 0x0B,
  0x30, 0x2D, 0x02, 0x09, 0xC0, 0xB3, 0x02, 0xD0, 0x20, 0x5C, 0x08, 0x40, 0xEB, 0x0E, 0x28, 0x28,
  0xEE, 0x95, 0x83, 0x4C, 0xEC, 0x38, 0x09, 0xD6, 0x00, 0x7F, 0xA0, 0x35, 0x07, 0xFA, 0x03, 0x50,
  0x7F, 0xA0, 0x36, 0x81, 0x24, 0xAE, 0x03, 0x72, 0x09, 0xD0, 0x37, 0x20, 0x4D, 0x03, 0x72, 0x02,
  0xD0, 0x37, 0x20, 0x1D, 0x03, 0x72, 0x01, 0xD0, 0x37, 0x20, 0x1D, 0x03, 0x72, 0x01, 0xD0, 0x37,
  0x20, 0x1D, 0x03, 0x72, 0x01, 0xD0, 0x37, 0x20, 0x1D, 0x03, 0x72, 0x01, 0xD0, 0x37, 0x20, 0x1D,
  0x03, 0x72, 0x01, 0xD0, 0x37, 0x20, 0x1D, 0x03, 0x72, 0x01, 0xD0, 0x37, 0x20, 0x1D, 0x03, 0x72,
  0x01, 0xD0, 0x37, 0x20, 0x1D, 0x03, 0x72, 0x01, 0xD0, 0x37, 0x20, 0x1D, 0x03, 0x72, 0x01, 0xD0,
  0x37, 0x20, 0x2D, 0x04, 0x72, 0x04, 0xD0, 0x67, 0x20, 0x9D, 0x0C, 0x58, 0x21, 0x24, 0xAF, 0x84,
  0xC5, 0x21, 0x0D, 0xFE, 0x81, 0xE0, 0xDF, 0xE8, 0x1E, 0x0D, 0xFE, 0x0E,
  // "ð" (U+00F0)
  0x50, 0x10, 0x27, 0x60, 0x01, 0x72, 0x82, 0x4F, 0xC6, 0x73, 0x81, 0x4E, 0x47, 0x20, 0x4B, 0x0E,
  0x07, 0x70, 0x9A, 0x04, 0x72, 0x03, 0xD0, 0xD0, 0x53, 0x03, 0x0D, 0xB0, 0x47, 0x30, 0x10, 0x9D,
  0x81, 0xB2, 0x7B, 0x0E, 0x06, 0x76, 0x02, 0x0B, 0xF9, 0x0C, 0x02, 0x77, 0x20, 0x7E, 0x08, 0x77,
  0x40, 0x50, 0xED, 0x07, 0x77, 0x30, 0x9F, 0x90, 0x57, 0x70, 0x30, 0xDB, 0x81, 0xB3, 0xEC, 0x03,
  0x76, 0x0D, 0xA0, 0xE0, 0x62, 0x03, 0xC0, 0xD7, 0x68, 0x2D, 0xFB, 0x14, 0x06, 0xC0, 0x87, 0x50,
  0xC0, 0x67, 0x0C, 0xC0, 0x17, 0x40, 0x17, 0x10, 0x3C, 0x0A, 0x77, 0x70, 0xBC, 0x01, 0x77, 0x60,
  0x3C, 0x08, 0x74, 0x89, 0x15, 0xAC, 0xEF, 0xEB, 0x71, 0x0D, 0xB0, 0xE7, 0x20, 0x70, 0xEF, 0xA0,
  0x80, 0x9C, 0x04, 0x60, 0x10, 0xCF, 0xD0, 0xEC, 0x09, 0x60, 0xCC, 0x85, 0xE8, 0x32, 0x24, 0x9F,
  0x0E, 0x50, 0xAC, 0x0D, 0x02, 0x60, 0x30, 0xEE, 0x02, 0x30, 0x3D, 0x03, 0x71, 0x04, 0xE0, 0x53,
  0x0B, 0xC0, 0x97, 0x30, 0xBD, 0x08, 0x20, 0x1D, 0x03, 0x73, 0x05, 0xD0, 0xA2, 0x06, 0xC0, 0xE7,
  0x40, 0x1D, 0x0C, 0x20, 0x9C, 0x0B, 0x75, 0x0D, 0xC0, 0xE2, 0x0C, 0xC0, 0x87, 0x50, 0xAD, 0x2D,
  0x06, 0x75, 0x08, 0xD1, 0x01, 0xD0, 0x57, 0x50, 0x7D, 0x01, 0x02, 0xD0, 0x47, 0x50, 0x6D, 0x01,
  0x03, 0xD0, 0x37, 0x50, 0x5D, 0x01, 0x03, 0xD0, 0x37, 0x50, 0x5D, 0x01, 0x03, 0xD0, 0x37, 0x50,
  0x5D, 0x10, 0x2D, 0x04, 0x75, 0x06, 0xC8, 0x1E, 0x01, 0xD0, 0x47, 0x50, 0x6C, 0x0D, 0x2D, 0x06,
  0x75, 0x08, 0xC0, 0xB2, 0x0C, 0xC0, 0x87, 0x50, 0xAC, 0x08, 0x20, 0x9C, 0x0A, 0x75, 0x0C, 0xC0,
  0x52, 0x06, 0xC0, 0xE7, 0x5D, 0x01, 0x20, 0x1D, 0x02, 0x73, 0x04, 0xC0, 0xB4, 0x0B, 0xC0, 0x87,
  0x30, 0x9C, 0x06, 0x40, 0x4C, 0x0E, 0x01, 0x71, 0x02, 0xC0, 0xE6, 0x0A, 0xC0, 0xA7, 0x10, 0xBC,
  0x05, 0x60, 0x10, 0xEC, 0x0B, 0x02, 0x40, 0x20, 0xBC, 0x0A, 0x71, 0x03, 0x0E, 0xD8, 0x2B, 0x99,
  0xCD, 0x0B, 0x73, 0x02, 0x0C, 0xFD, 0x09, 0x76, 0x05, 0x0C, 0xF9, 0x0A, 0x03, 0x77, 0x28, 0x51,
  0x46, 0x77, 0x63, 0x73,
  // "ñ" (U+00F1)
  0x72, 0x84, 0x4B, 0xEE, 0xB5, 0x78, 0x12, 0x55, 0x77, 0x05, 0xE0, 0xA0, 0x15, 0x81, 0x9F, 0xE7,
  0x60, 0x2F, 0x90, 0xD0, 0x34, 0x81, 0xEF, 0xC7, 0x60, 0xAF, 0xB8, 0x27, 0x11, 0x9A, 0x08, 0x76,
  0xA8, 0x3D, 0x30, 0x4D, 0xFB, 0x02, 0x75, 0x04, 0xA0, 0x54, 0x09, 0xF9, 0x0A, 0x76, 0x07, 0xA0,
  0x15, 0x05, 0x0E, 0xD0, 0xD0, 0x17, 0x68, 0x13, 0x65, 0x78, 0x51, 0x9D, 0xFD, 0x81, 0x80, 0xA9,
  0x70, 0x84, 0x15, 0x77, 0x53, 0x73, 0x05, 0xF9, 0x06, 0x30, 0x20, 0xAE, 0x0E, 0x06, 0x71, 0x05,
  0xF9, 0x08, 0x20, 0x40, 0xEF, 0xA0, 0xB7, 0x05, 0xF9, 0x82, 0xA0, 0x2E, 0xFC, 0x0A, 0x78, 0x12,
  0x4A, 0xD8, 0x1C, 0x0B, 0xA8, 0x3B, 0x88, 0xAE, 0xE0, 0x47, 0x20, 0xAC, 0x83, 0xE3, 0xFD, 0x35,
  0x0A, 0xD0, 0xB7, 0x20, 0x4D, 0x81, 0xCE, 0x27, 0x0C, 0xD0, 0x17, 0x10, 0x2E, 0x07, 0x71, 0x05,
  0xD0, 0x57, 0x10, 0x1E, 0x01, 0x72, 0xD0, 0x87, 0x10, 0x1D, 0x0B, 0x73, 0x0C, 0xC0, 0xA7, 0x10,
  0x1D, 0x08, 0x73, 0x0A, 0xC0, 0xA7, 0x10, 0x1D, 0x05, 0x73, 0x09, 0xC0, 0xB7, 0x10, 0x1D, 0x04,
  0x73, 0x08, 0xC0, 0xC7, 0x10, 0x1D, 0x03, 0x73, 0x08, 0xC0, 0xC7, 0x10, 0x1D, 0x03, 0x73, 0x08,
  0xC0, 0xC7, 0x10, 0x1D, 0x03, 0x73, 0x08, 0xC0, 0xC7, 0x10, 0x1D, 0x03, 0x73, 0x08, 0xC0, 0xC7,
  0x10, 0x1D, 0x03, 0x73, 0x08, 0xC0, 0xC7, 0x10, 0x1D, 0x03, 0x73, 0x08, 0xC0, 0xC7, 0x10, 0x1D,
  0x03, 0x73, 0x08, 0xC0, 0xC7, 0x10, 0x1D, 0x03, 0x73, 0x08, 0xC0, 0xC7, 0x10, 0x1D, 0x03, 0x73,
  0x08, 0xC0, 0xC7, 0x10, 0x1D, 0x03, 0x73, 0x08, 0xC0, 0xC7, 0x10, 0x1D, 0x03, 0x73, 0x08, 0xC0,
  0xC7, 0x10, 0x1D, 0x03, 0x73, 0x08, 0xC0, 0xC7, 0x10, 0x1D, 0x03, 0x73, 0x08, 0xC0, 0xC7, 0x10,
  0x2D, 0x03, 0x73, 0x08, 0xC0, 0xC7, 0x10, 0x4D, 0x05, 0x73, 0x08, 0xC0, 0xE7, 0x10, 0xAD, 0x0A,
  0x73, 0x08, 0xD0, 0x44, 0x81, 0x24, 0xBF, 0x81, 0xB4, 0x27, 0x08, 0xD8, 0x3E, 0x73, 0x1A, 0xFE,
  0x07, 0x60, 0x8F, 0x90, 0xC0, 0xAF, 0xE0, 0x76, 0x08, 0xF9, 0x0C, 0x0A, 0xFE, 0x07, 0x60, 0x8F,
  0x90, 0xC0,
  // "ò" (U+00F2)
  0x50, 0x48, 0x01, 0x70, 0x37, 0x75, 0x05, 0xD0, 0xB7, 0x76, 0x09, 0xD0, 0x37, 0x76, 0x0C, 0xC0,
  0xA7, 0x76, 0x01, 0x0D, 0xC0, 0x37, 0x76, 0x02, 0x0D, 0xB0, 0xC7, 0x77, 0x02, 0x0D, 0xB0, 0x57,
  0x77, 0x02, 0x0D, 0xA0, 0xE0, 0x17, 0x77, 0x01, 0x0C, 0xA0, 0x97, 0x77, 0x20, 0xAA, 0x01, 0x80,
  0x9E, 0x60, 0x85, 0x14, 0x67, 0x76, 0x47, 0x73, 0x05, 0x0C, 0xF9, 0x0A, 0x03, 0x75, 0x02, 0x0C,
  0xFD, 0x09, 0x73, 0x03, 0x0E, 0xD8, 0x2B, 0x9A, 0xCD, 0x0C, 0x01, 0x70, 0x20, 0xEC, 0x0A, 0x01,
  0x40, 0x20, 0xBC, 0x0C, 0x70, 0xBC, 0x09, 0x71, 0x0B, 0xC0, 0x85, 0x04, 0xC0, 0xE0, 0x17, 0x10,
  0x2D, 0x01, 0x40, 0xBC, 0x08, 0x73, 0x0A, 0xC0, 0x83, 0x01, 0xD0, 0x27, 0x30, 0x4C, 0x0E, 0x30,
  0x6C, 0x0E, 0x75, 0xD0, 0x32, 0x09, 0xC0, 0xB7, 0x50, 0xDC, 0x07, 0x20, 0xCC, 0x08, 0x75, 0x0A,
  0xC0, 0xA2, 0x0E, 0xC0, 0x67, 0x50, 0x8C, 0x81, 0xD0, 0x1D, 0x05, 0x75, 0x07, 0xC8, 0x1E, 0x02,
  0xD0, 0x47, 0x50, 0x6D, 0x10, 0x3D, 0x04, 0x75, 0x06, 0xD0, 0x10, 0x3D, 0x03, 0x75, 0x05, 0xD0,
  0x10, 0x3D, 0x03, 0x75, 0x05, 0xD0, 0x10, 0x3D, 0x04, 0x75, 0x06, 0xD0, 0x10, 0x2D, 0x04, 0x75,
  0x06, 0xD1, 0x01, 0xD0, 0x57, 0x50, 0x7C, 0x0E, 0x20, 0xEC, 0x07, 0x75, 0x09, 0xC0, 0xD2, 0x0C,
  0xC0, 0x87, 0x50, 0xAC, 0x0A, 0x20, 0x9C, 0x0B, 0x75, 0x0D, 0xC0, 0x72, 0x05, 0xC0, 0xE7, 0x40,
  0x1D, 0x04, 0x20, 0x1D, 0x03, 0x73, 0x05, 0xC0, 0xE4, 0x0A, 0xC0, 0x97, 0x30, 0xAC, 0x09, 0x40,
  0x3C, 0x0E, 0x01, 0x71, 0x02, 0xD0, 0x25, 0x09, 0xC0, 0xA7, 0x10, 0xBC, 0x09, 0x70, 0xDC, 0x0B,
  0x02, 0x40, 0x20, 0xBC, 0x0D, 0x71, 0x01, 0x0D, 0xD8, 0x2C, 0x99, 0xCD, 0x0D, 0x02, 0x72, 0x01,
  0x0B, 0xFD, 0x0B, 0x01, 0x75, 0x04, 0x0B, 0xF9, 0x0B, 0x04, 0x77, 0x28, 0x51, 0x46, 0x77, 0x64,
  0x73,
  // "ó" (U+00F3)
  0x77, 0x18, 0x02, 0x77, 0x75, 0x04, 0xD0, 0xC7, 0x75, 0x0B, 0xC0, 0xE0, 0x27, 0x74, 0x04, 0xD0,
  0x47, 0x75, 0x0C, 0xC0, 0x67, 0x75, 0x05, 0xC0, 0x77, 0x76, 0x0E, 0xB0, 0x77, 0x76, 0x08, 0xB0,
  0x67, 0x76, 0x02, 0xB0, 0x57, 0x77, 0x82, 0x8F, 0xE3, 0x80, 0x9F, 0x10, 0x85, 0x14, 0x67, 0x76,
  0x47, 0x73, 0x05, 0x0C, 0xF9, 0x0A, 0x03, 0x75, 0x02, 0x0C, 0xFD, 0x09, 0x73, 0x03, 0x0E, 0xD8,
  0x2B, 0x9A, 0xCD, 0x0C, 0x01, 0x70, 0x20, 0xEC, 0x0A, 0x01, 0x40, 0x20, 0xBC, 0x0C, 0x70, 0xBC,
  0x09, 0x71, 0x0B, 0xC0, 0x85, 0x04, 0xC0, 0xE0, 0x17, 0x10, 0x2D, 0x01, 0x40, 0xBC, 0x08, 0x73,
  0x0A, 0xC0, 0x83, 0x01, 0xD0, 0x27, 0x30, 0x4C, 0x0E, 0x30, 0x6C, 0x0E, 0x75, 0xD0, 0x32, 0x09,
  0xC0, 0xB7, 0x50, 0xDC, 0x07, 0x20, 0xCC, 0x08, 0x75, 0x0A, 0xC0, 0xA2, 0x0E, 0xC0, 0x67, 0x50,
  0x8C, 0x81, 0xD0, 0x1D, 0x05, 0x75, 0x07, 0xC8, 0x1E, 0x02, 0xD0, 0x47, 0x50, 0x6D, 0x10, 0x3D,
  0x04, 0x75, 0x06, 0xD0, 0x10, 0x3D, 0x03, 0x75, 0x05, 0xD0, 0x10, 0x3D, 0x03, 0x75, 0x05, 0xD0,
  0x10, 0x3D, 0x04, 0x75, 0x06, 0xD0, 0x10, 0x2D, 0x04, 0x75, 0x06, 0xD1, 0x01, 0xD0, 0x57, 0x50,
  0x7C, 0x0E, 0x20, 0xEC, 0x07, 0x75, 0x09, 0xC0, 0xD2, 0x0C, 0xC0, 0x87, 0x50, 0xAC, 0x0A, 0x20,
  0x9C, 0x0B, 0x75, 0x0D, 0xC0, 0x72, 0x05, 0xC0, 0xE7, 0x40, 0x1D, 0x04, 0x20, 0x1D, 0x03, 0x73,
  0x05, 0xC0, 0xE4, 0x0A, 0xC0, 0x97, 0x30, 0xAC, 0x09, 0x40, 0x3C, 0x0E, 0x01, 0x71, 0x02, 0xD0,
  0x25, 0x09, 0xC0, 0xA7, 0x10, 0xBC, 0x09, 0x70, 0xDC, 0x0B, 0x02, 0x40, 0x20, 0xBC, 0x0D, 0x71,
  0x01, 0x0D, 0xD8, 0x2C, 0x99, 0xCD, 0x0D, 0x02, 0x72, 0x01, 0x0B, 0xFD, 0x0B, 0x01, 0x75, 0x04,
  0x0B, 0xF9, 0x0B, 0x04, 0x77, 0x28, 0x51, 0x46, 0x77, 0x64, 0x73,
  // "ô" (U+00F4)
  0x73, 0x03, 0x80, 0x17, 0x77, 0x60, 0xCD, 0x04, 0x77, 0x40, 0x5E, 0x0C, 0x77, 0x40, 0xDF, 0x05,
  0x77, 0x20, 0x8B, 0x0C, 0x07, 0xB0, 0xD7, 0x71, 0x02, 0xB8, 0x2E, 0x20, 0x9B, 0x08, 0x77, 0x0B,
  0xA0, 0xE0, 0x33, 0x0B, 0xB0, 0x27, 0x50, 0x6A, 0x0E, 0x04, 0x50, 0xBA, 0x0C, 0x74, 0x83, 0x2E,
  0xFE, 0x47, 0x0B, 0xA0, 0x87, 0x38, 0x28, 0xFE, 0x37, 0x20, 0xAA, 0x80, 0x9E, 0x20, 0x85, 0x14,
  0x67, 0x76, 0x47, 0x73, 0x05, 0x0C, 0xF9, 0x0A, 0x03, 0x75, 0x02, 0x0C, 0xFD, 0x09, 0x73, 0x03,
  0x0E, 0xD8, 0x2B, 0x9A, 0xCD, 0x0C, 0x01, 0x70, 0x20, 0xEC, 0x0A, 0x01, 0x40, 0x20, 0xBC, 0x0C,
  0x70, 0xBC, 0x09, 0x71, 0x0B, 0xC0, 0x85, 0x04, 0xC0, 0xE0, 0x17, 0x10, 0x2D, 0x01, 0x40, 0xBC,
  0x08, 0x73, 0x0A, 0xC0, 0x83, 0x01, 0xD0, 0x27, 0x30, 0x4C, 0x0E, 0x30, 0x6C, 0x0E, 0x75, 0xD0,
  0x32, 0x09, 0xC0, 0xB7, 0x50, 0xDC, 0x07, 0x20, 0xCC, 0x08, 0x75, 0x0A, 0xC0, 0xA2, 0x0E, 0xC0,
  0x67, 0x50, 0x8C, 0x81, 0xD0, 0x1D, 0x05, 0x75, 0x07, 0xC8, 0x1E, 0x02, 0xD0, 0x47, 0x50, 0x6D,
  0x10, 0x3D, 0x04, 0x75, 0x06, 0xD0, 0x10, 0x3D, 0x03, 0x75, 0x05, 0xD0, 0x10, 0x3D, 0x03, 0x75,
  0x05, 0xD0, 0x10, 0x3D, 0x04, 0x75, 0x06, 0xD0, 0x10, 0x2D, 0x04, 0x75, 0x06, 0xD1, 0x01, 0xD0,
  0x57, 0x50, 0x7C, 0x0E, 0x20, 0xEC, 0x07, 0x75, 0x09, 0xC0, 0xD2, 0x0C, 0xC0, 0x87, 0x50, 0xAC,
  0x0A, 0x20, 0x9C, 0x0B, 0x75, 0x0D, 0xC0, 0x72, 0x05, 0xC0, 0xE7, 0x40, 0x1D, 0x04, 0x20, 0x1D,
  0x03, 0x73, 0x05, 0xC0, 0xE4, 0x0A, 0xC0, 0x97, 0x30, 0xAC, 0x09, 0x40, 0x3C, 0x0E, 0x01, 0x71,
  0x02, 0xD0, 0x25, 0x09, 0xC0, 0xA7, 0x10, 0xBC, 0x09, 0x70, 0xDC, 0x0B, 0x02, 0x40, 0x20, 0xBC,
  0x0D, 0x71, 0x01, 0x0D, 0xD8, 0x2C, 0x99, 0xCD, 0x0D, 0x02, 0x72, 0x01, 0x0B, 0xFD, 0x0B, 0x01,
  0x75, 0x04, 0x0B, 0xF9, 0x0B, 0x04, 0x77, 0x28, 0x51, 0x46, 0x77, 0x64, 0x73,
  // "õ" (U+00F5)
  0x68, 0x44, 0xBE, 0xEB, 0x57, 0x81, 0x25, 0x57, 0x20, 0x5E, 0x0A, 0x01, 0x58, 0x19, 0xFE, 0x71,
  0x02, 0xF9, 0x0D, 0x03, 0x48, 0x1E, 0xFC, 0x71, 0x0A, 0xFB, 0x82, 0x71, 0x19, 0xA0, 0x87, 0x1A,
  0x83, 0xD3, 0x04, 0xDF, 0xB0, 0x27, 0x04, 0xA0, 0x54, 0x09, 0xF9, 0x0A, 0x71, 0x07, 0xA0, 0x15,
  0x05, 0x0E, 0xD0, 0xD0, 0x17, 0x18, 0x13, 0x65, 0x78, 0x51, 0x9D, 0xFD, 0x81, 0x80, 0x9E, 0x30,
  0x85, 0x14, 0x67, 0x76, 0x47, 0x73, 0x05, 0x0C, 0xF9, 0x0A, 0x03, 0x75, 0x02, 0x0C, 0xFD, 0x09,
  0x73, 0x03, 0x0E, 0xD8, 0x2B, 0x9A, 0xCD, 0x0C, 0x01, 0x70, 0x20, 0xEC, 0x0A, 0x01, 0x40, 0x20,
  0xBC, 0x0C, 0x70, 0xBC, 0x09, 0x71, 0x0B, 0xC0, 0x85, 0x04, 0xC0, 0xE0, 0x17, 0x10, 0x2D, 0x01,
  0x40, 0xBC, 0x08, 0x73, 0x0A, 0xC0, 0x83, 0x01, 0xD0, 0x27, 0x30, 0x4C, 0x0E, 0x30, 0x6C, 0x0E,
  0x75, 0xD0, 0x32, 0x09, 0xC0, 0xB7, 0x50, 0xDC, 0x07, 0x20, 0xCC, 0x08, 0x75, 0x0A, 0xC0, 0xA2,
  0x0E, 0xC0, 0x67, 0x50, 0x8C, 0x81, 0xD0, 0x1D, 0x05, 0x75, 0x07, 0xC8, 0x1E, 0x02, 0xD0, 0x47,
  0x50, 0x6D, 0x10, 0x3D, 0x04, 0x75, 0x06, 0xD0, 0x10, 0x3D, 0x03, 0x75, 0x05, 0xD0, 0x10, 0x3D,
  0x03, 0x75, 0x05, 0xD0, 0x10, 0x3D, 0x04, 0x75, 0x06, 0xD0, 0x10, 0x2D, 0x04, 0x75, 0x06, 0xD1,
  0x01, 0xD0, 0x57, 0x50, 0x7C, 0x0E, 0x20, 0xEC, 0x07, 0x75, 0x09, 0xC0, 0xD2, 0x0C, 0xC0, 0x87,
  0x50, 0xAC, 0x0A, 0x20, 0x9C, 0x0B, 0x75, 0x0D, 0xC0, 0x72, 0x05, 0xC0, 0xE7, 0x40, 0x1D, 0x04,
  0x20, 0x1D, 0x03, 0x73, 0x05, 0xC0, 0xE4, 0x0A, 0xC0, 0x97, 0x30, 0xAC, 0x09, 0x40, 0x3C, 0x0E,
  0x01, 0x71, 0x02, 0xD0, 0x25, 0x09, 0xC0, 0xA7, 0x10, 0xBC, 0x09, 0x70, 0xDC, 0x0B, 0x02, 0x40,
  0x20, 0xBC, 0x0D, 0x71, 0x01, 0x0D, 0xD8, 0x2C, 0x99, 0xCD, 0x0D, 0x02, 0x72, 0x01, 0x0B, 0xFD,
  0x0B, 0x01, 0x75, 0x04, 0x0B, 0xF9, 0x0B, 0x04, 0x77, 0x28, 0x51, 0x46, 0x77, 0x64, 0x73,
  // "ö" (U+00F6)
  0x68, 0x28, 0xEE, 0x85, 0x83, 0x3C, 0xEC, 0x37, 0x40, 0x5C, 0x07, 0x40, 0xEB, 0x0E, 0x74, 0x09,
  0xC0, 0xB3, 0x02, 0xD0, 0x27, 0x30, 0x9C, 0x0B, 0x30, 0x2D, 0x02, 0x73, 0x05, 0xC0, 0x84, 0x0E,
  0xB0, 0xE7, 0x58, 0x28, 0xEE, 0x95, 0x83, 0x4C, 0xEC, 0x38, 0x0A, 0xC7, 0x08, 0x51, 0x46, 0x77,
  0x64, 0x77, 0x30, 0x50, 0xCF, 0x90, 0xA0, 0x37, 0x50, 0x20, 0xCF, 0xD0, 0x97, 0x30, 0x30, 0xED,
  0x82, 0xB9, 0xAC, 0xD0, 0xC0, 0x17, 0x02, 0x0E, 0xC0, 0xA0, 0x14, 0x02, 0x0B, 0xC0, 0xC7, 0x0B,
  0xC0, 0x97, 0x10, 0xBC, 0x08, 0x50, 0x4C, 0x0E, 0x01, 0x71, 0x02, 0xD0, 0x14, 0x0B, 0xC0, 0x87,
  0x30, 0xAC, 0x08, 0x30, 0x1D, 0x02, 0x73, 0x04, 0xC0, 0xE3, 0x06, 0xC0, 0xE7, 0x5D, 0x03, 0x20,
  0x9C, 0x0B, 0x75, 0x0D, 0xC0, 0x72, 0x0C, 0xC0, 0x87, 0x50, 0xAC, 0x0A, 0x20, 0xEC, 0x06, 0x75,
  0x08, 0xC8, 0x1D, 0x01, 0xD0, 0x57, 0x50, 0x7C, 0x81, 0xE0, 0x2D, 0x04, 0x75, 0x06, 0xD1, 0x03,
  0xD0, 0x47, 0x50, 0x6D, 0x01, 0x03, 0xD0, 0x37, 0x50, 0x5D, 0x01, 0x03, 0xD0, 0x37, 0x50, 0x5D,
  0x01, 0x03, 0xD0, 0x47, 0x50, 0x6D, 0x01, 0x02, 0xD0, 0x47, 0x50, 0x6D, 0x10, 0x1D, 0x05, 0x75,
  0x07, 0xC0, 0xE2, 0x0E, 0xC0, 0x77, 0x50, 0x9C, 0x0D, 0x20, 0xCC, 0x08, 0x75, 0x0A, 0xC0, 0xA2,
  0x09, 0xC0, 0xB7, 0x50, 0xDC, 0x07, 0x20, 0x5C, 0x0E, 0x74, 0x01, 0xD0, 0x42, 0x01, 0xD0, 0x37,
  0x30, 0x5C, 0x0E, 0x40, 0xAC, 0x09, 0x73, 0x0A, 0xC0, 0x94, 0x03, 0xC0, 0xE0, 0x17, 0x10, 0x2D,
  0x02, 0x50, 0x9C, 0x0A, 0x71, 0x0B, 0xC0, 0x97, 0x0D, 0xC0, 0xB0, 0x24, 0x02, 0x0B, 0xC0, 0xD7,
  0x10, 0x10, 0xDD, 0x82, 0xC9, 0x9C, 0xD0, 0xD0, 0x27, 0x20, 0x10, 0xBF, 0xD0, 0xB0, 0x17, 0x50,
  0x40, 0xBF, 0x90, 0xB0, 0x47, 0x72, 0x85, 0x14, 0x67, 0x76, 0x47, 0x30,
  // "÷" (U+00F7)
  0x72, 0x82, 0x8E, 0xE8, 0x77, 0x30, 0x7C, 0x06, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x20, 0xBC, 0x0B,
  0x77, 0x20, 0xAC, 0x0A, 0x77, 0x20, 0x6C, 0x05, 0x77, 0x38, 0x28, 0xEE, 0x78, 0x0A, 0x91, 0x08,
  0x0A, 0x21, 0xFF, 0xF0, 0xEF, 0xFF, 0x0E, 0xFF, 0xF0, 0xE8, 0x0A, 0x91, 0x08, 0x28, 0xEE, 0x87,
  0x73, 0x07, 0xC0, 0x67, 0x72, 0x0B, 0xC0, 0xA7, 0x72, 0x0B, 0xC0, 0xB7, 0x72, 0x0A, 0xC0, 0xA7,
  0x72, 0x06, 0xC0, 0x57, 0x73, 0x82, 0x8E, 0xE7, 0x72,
  // "ø" (U+00F8)
  0x77, 0x70, 0xEA, 0x02, 0x77, 0x70, 0x5A, 0x0A, 0x74, 0x85, 0x14, 0x67, 0x76, 0x34, 0x0C, 0xA0,
  0x47, 0x20, 0x50, 0xBF, 0x82, 0xE9, 0x23, 0xA0, 0xC7, 0x10, 0x20, 0xCF, 0xD0, 0xDA, 0x06, 0x70,
  0x30, 0xED, 0x82, 0xB9, 0x9C, 0xE0, 0xE7, 0x02, 0x0E, 0xC0, 0xA0, 0x14, 0x02, 0x0B, 0xC0, 0xA7,
  0x0B, 0xC0, 0x97, 0x10, 0xCC, 0x03, 0x50, 0x4C, 0x0E, 0x01, 0x71, 0x0E, 0xC0, 0xD5, 0x0B, 0xC0,
  0x87, 0x10, 0x7E, 0x05, 0x30, 0x1D, 0x02, 0x71, 0x0E, 0xE0, 0xC3, 0x06, 0xC0, 0xE7, 0x10, 0x7A,
  0x07, 0xD0, 0x12, 0x09, 0xC0, 0xB7, 0x18, 0x3E, 0xFD, 0x0D, 0xC0, 0x62, 0x0C, 0xC0, 0x87, 0x07,
  0xA8, 0x16, 0x0B, 0xC0, 0x92, 0x0E, 0xC0, 0x66, 0x82, 0x1E, 0xFD, 0x20, 0x9C, 0x81, 0xC0, 0x1D,
  0x05, 0x60, 0x7A, 0x05, 0x20, 0x7C, 0x81, 0xE0, 0x2D, 0x04, 0x58, 0x21, 0xEF, 0xD3, 0x06, 0xD1,
  0x03, 0xD0, 0x45, 0x08, 0xA0, 0x53, 0x05, 0xD0, 0x10, 0x3D, 0x03, 0x48, 0x21, 0xEF, 0xC4, 0x05,
  0xD0, 0x10, 0x3D, 0x03, 0x40, 0x8A, 0x04, 0x40, 0x5D, 0x01, 0x03, 0xD0, 0x33, 0x82, 0x1E, 0xFC,
  0x50, 0x6D, 0x01, 0x02, 0xD0, 0x43, 0x08, 0xA0, 0x45, 0x06, 0xD1, 0x01, 0xD0, 0x52, 0x82, 0x1E,
  0xFB, 0x60, 0x7D, 0x20, 0xEC, 0x06, 0x20, 0x8A, 0x03, 0x60, 0x8C, 0x0D, 0x20, 0xCC, 0x81, 0x80,
  0x1A, 0x0B, 0x70, 0xAC, 0x0B, 0x20, 0x9C, 0x81, 0xA0, 0x9A, 0x03, 0x70, 0xDC, 0x08, 0x20, 0x5C,
  0x0D, 0x01, 0xA0, 0xA7, 0x1D, 0x04, 0x20, 0x1D, 0x0B, 0xA0, 0x37, 0x04, 0xC0, 0xE4, 0x0A, 0xE0,
  0xA7, 0x10, 0xAC, 0x09, 0x40, 0x3E, 0x02, 0x70, 0x2D, 0x03, 0x50, 0xAC, 0x0C, 0x71, 0x0B, 0xC0,
  0x96, 0x01, 0x0D, 0xC0, 0xA0, 0x14, 0x02, 0x0B, 0xC0, 0xD0, 0x17, 0x09, 0xE8, 0x2B, 0x99, 0xCD,
  0x0D, 0x01, 0x70, 0x2A, 0x0E, 0xFD, 0x0A, 0x01, 0x71, 0x09, 0xA8, 0x16, 0x3A, 0xF8, 0x1E, 0xA4,
  0x72, 0x02, 0xA0, 0xD4, 0x84, 0x46, 0x76, 0x53, 0x75, 0x0A, 0xA0, 0x67, 0x77, 0x10, 0xF7, 0x77,
  0x70,
  // "ù" (U+00F9)
  0x60, 0x48, 0x01, 0x70, 0x37, 0x77, 0x30, 0x5D, 0x0B, 0x77, 0x74, 0x09, 0xD0, 0x37, 0x77, 0x40,
  0xCC, 0x0A, 0x77, 0x74, 0x01, 0x0D, 0xC0, 0x37, 0x77, 0x40, 0x20, 0xDB, 0x0C, 0x77, 0x75, 0x02,
  0x0D, 0xB0, 0x57, 0x77, 0x50, 0x20, 0xDA, 0x0E, 0x01, 0x77, 0x75, 0x01, 0x0C, 0xA0, 0x97, 0x77,
  0x70, 0xAA, 0x01, 0x80, 0xAC, 0x40, 0x0D, 0xF9, 0x0A, 0x60, 0x2F, 0xA0, 0x44, 0x0D, 0xF9, 0x0A,
  0x60, 0x2F, 0xA0, 0x44, 0x0D, 0xF9, 0x0A, 0x60, 0x2F, 0xA0, 0x44, 0x82, 0x13, 0x7E, 0xD0, 0xA7,
  0x81, 0x24, 0xAE, 0x04, 0x70, 0x3D, 0x0A, 0x73, 0x09, 0xD0, 0x47, 0x10, 0xCC, 0x0A, 0x73, 0x03,
  0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x73, 0x01, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10,
  0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0,
  0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A,
  0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10,
  0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0,
  0x47, 0x10, 0xAC, 0x0A, 0x73, 0x01, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x73, 0x01, 0xD0, 0x47, 0x10,
  0x9C, 0x0B, 0x73, 0x03, 0xD0, 0x47, 0x10, 0x9C, 0x0C, 0x73, 0x05, 0xD0, 0x47, 0x10, 0x8C, 0x0E,
  0x73, 0x08, 0xD0, 0x47, 0x10, 0x6D, 0x01, 0x72, 0x0D, 0xD0, 0x47, 0x10, 0x3D, 0x05, 0x71, 0x04,
  0xE0, 0x57, 0x2D, 0x0C, 0x71, 0x81, 0xDF, 0xEC, 0x07, 0x72, 0x0A, 0xD0, 0x95, 0x83, 0x2C, 0xFB,
  0x9C, 0x0C, 0x72, 0x04, 0xE8, 0x3E, 0xA8, 0x8B, 0xB0, 0x20, 0x7D, 0x81, 0xC5, 0x27, 0x0A, 0xFD,
  0x81, 0x70, 0x4F, 0x90, 0x97, 0x0B, 0xFB, 0x08, 0x20, 0x2F, 0x90, 0x97, 0x10, 0x60, 0xEE, 0x0C,
  0x04, 0x4F, 0x90, 0x97, 0x38, 0x43, 0x57, 0x75, 0x27, 0x71,
  // "ú" (U+00FA)
  0x77, 0x38, 0x02, 0x77, 0x77, 0x30, 0x4D, 0x0C, 0x77, 0x73, 0x0B, 0xC0, 0xE0, 0x27, 0x77, 0x20,
  0x4D, 0x04, 0x77, 0x73, 0x0C, 0xC0, 0x67, 0x77, 0x30, 0x5C, 0x07, 0x77, 0x74, 0x0E, 0xB0, 0x77,
  0x77, 0x40, 0x8B, 0x06, 0x77, 0x74, 0x02, 0xB0, 0x57, 0x77, 0x58, 0x28, 0xFE, 0x38, 0x0A, 0xC6,
  0x00, 0xDF, 0x90, 0xA6, 0x02, 0xFA, 0x04, 0x40, 0xDF, 0x90, 0xA6, 0x02, 0xFA, 0x04, 0x40, 0xDF,
  0x90, 0xA6, 0x02, 0xFA, 0x04, 0x48, 0x21, 0x37, 0xED, 0x0A, 0x78, 0x12, 0x4A, 0xE0, 0x47, 0x03,
  0xD0, 0xA7, 0x30, 0x9D, 0x04, 0x71, 0x0C, 0xC0, 0xA7, 0x30, 0x3D, 0x04, 0x71, 0x0A, 0xC0, 0xA7,
  0x30, 0x1D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x4D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x4D, 0x04, 0x71,
  0x0A, 0xC0, 0xA7, 0x4D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x4D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x4D,
  0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x4D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x4D, 0x04, 0x71, 0x0A, 0xC0,
  0xA7, 0x4D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x4D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x4D, 0x04, 0x71,
  0x0A, 0xC0, 0xA7, 0x4D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x4D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x30,
  0x1D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x30, 0x1D, 0x04, 0x71, 0x09, 0xC0, 0xB7, 0x30, 0x3D, 0x04,
  0x71, 0x09, 0xC0, 0xC7, 0x30, 0x5D, 0x04, 0x71, 0x08, 0xC0, 0xE7, 0x30, 0x8D, 0x04, 0x71, 0x06,
  0xD0, 0x17, 0x20, 0xDD, 0x04, 0x71, 0x03, 0xD0, 0x57, 0x10, 0x4E, 0x05, 0x72, 0xD0, 0xC7, 0x18,
  0x1D, 0xFE, 0xC0, 0x77, 0x20, 0xAD, 0x09, 0x58, 0x32, 0xCF, 0xB9, 0xC0, 0xC7, 0x20, 0x4E, 0x83,
  0xEA, 0x88, 0xBB, 0x02, 0x07, 0xD8, 0x1C, 0x52, 0x70, 0xAF, 0xD8, 0x17, 0x04, 0xF9, 0x09, 0x70,
  0xBF, 0xB0, 0x82, 0x02, 0xF9, 0x09, 0x71, 0x06, 0x0E, 0xE0, 0xC0, 0x44, 0xF9, 0x09, 0x73, 0x84,
  0x35, 0x77, 0x52, 0x77, 0x10,
  // "û" (U+00FB)
  0x75, 0x03, 0x80, 0x17, 0x77, 0x74, 0x0C, 0xD0, 0x47, 0x77, 0x20, 0x5E, 0x0C, 0x77, 0x72, 0x0D,
  0xF0, 0x57, 0x77, 0x08, 0xB0, 0xC0, 0x7B, 0x0D, 0x77, 0x60, 0x2B, 0x82, 0xE2, 0x09, 0xB0, 0x87,
  0x75, 0x0B, 0xA0, 0xE0, 0x33, 0x0B, 0xB0, 0x27, 0x73, 0x06, 0xA0, 0xE0, 0x45, 0x0B, 0xA0, 0xC7,
  0x72, 0x83, 0x2E, 0xFE, 0x47, 0x0B, 0xA0, 0x87, 0x71, 0x82, 0x8F, 0xE3, 0x72, 0x0A, 0xA8, 0x0A,
  0xB7, 0x00, 0xDF, 0x90, 0xA6, 0x02, 0xFA, 0x04, 0x40, 0xDF, 0x90, 0xA6, 0x02, 0xFA, 0x04, 0x40,
  0xDF, 0x90, 0xA6, 0x02, 0xFA, 0x04, 0x48, 0x21, 0x37, 0xED, 0x0A, 0x78, 0x12, 0x4A, 0xE0, 0x47,
  0x03, 0xD0, 0xA7, 0x30, 0x9D, 0x04, 0x71, 0x0C, 0xC0, 0xA7, 0x30, 0x3D, 0x04, 0x71, 0x0A, 0xC0,
  0xA7, 0x30, 0x1D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x4D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x4D, 0x04,
  0x71, 0x0A, 0xC0, 0xA7, 0x4D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x4D, 0x04, 0x71, 0x0A, 0xC0, 0xA7,
  0x4D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x4D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x4D, 0x04, 0x71, 0x0A,
  0xC0, 0xA7, 0x4D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x4D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x4D, 0x04,
  0x71, 0x0A, 0xC0, 0xA7, 0x4D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x4D, 0x04, 0x71, 0x0A, 0xC0, 0xA7,
  0x30, 0x1D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x30, 0x1D, 0x04, 0x71, 0x09, 0xC0, 0xB7, 0x30, 0x3D,
  0x04, 0x71, 0x09, 0xC0, 0xC7, 0x30, 0x5D, 0x04, 0x71, 0x08, 0xC0, 0xE7, 0x30, 0x8D, 0x04, 0x71,
  0x06, 0xD0, 0x17, 0x20, 0xDD, 0x04, 0x71, 0x03, 0xD0, 0x57, 0x10, 0x4E, 0x05, 0x72, 0xD0, 0xC7,
  0x18, 0x1D, 0xFE, 0xC0, 0x77, 0x20, 0xAD, 0x09, 0x58, 0x32, 0xCF, 0xB9, 0xC0, 0xC7, 0x20, 0x4E,
  0x83, 0xEA, 0x88, 0xBB, 0x02, 0x07, 0xD8, 0x1C, 0x52, 0x70, 0xAF, 0xD8, 0x17, 0x04, 0xF9, 0x09,
  0x70, 0xBF, 0xB0, 0x82, 0x02, 0xF9, 0x09, 0x71, 0x06, 0x0E, 0xE0, 0xC0, 0x44, 0xF9, 0x09, 0x73,
  0x84, 0x35, 0x77, 0x52, 0x77, 0x10,
  // "ü" (U+00FC)
  0x72, 0x82, 0x8E, 0xE8, 0x58, 0x33, 0xCE, 0xC3, 0x77, 0x20, 0x5C, 0x07, 0x40, 0xEB, 0x0E, 0x77,
  0x20, 0x9C, 0x0B, 0x30, 0x2D, 0x02, 0x77, 0x10, 0x9C, 0x0B, 0x30, 0x2D, 0x02, 0x77, 0x10, 0x5C,
  0x08, 0x40, 0xEB, 0x0E, 0x77, 0x38, 0x28, 0xEE, 0x95, 0x83, 0x4C, 0xEC, 0x38, 0x0B, 0xB5, 0x00,
  0xDF, 0x90, 0xA6, 0x02, 0xFA, 0x04, 0x40, 0xDF, 0x90, 0xA6, 0x02, 0xFA, 0x04, 0x40, 0xDF, 0x90,
  0xA6, 0x02, 0xFA, 0x04, 0x48, 0x21, 0x37, 0xED, 0x0A, 0x78, 0x12, 0x4A, 0xE0, 0x47, 0x03, 0xD0,
  0xA7, 0x30, 0x9D, 0x04, 0x71, 0x0C, 0xC0, 0xA7, 0x30, 0x3D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x30,
  0x1D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x4D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x4D, 0x04, 0x71, 0x0A,
  0xC0, 0xA7, 0x4D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x4D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x4D, 0x04,
  0x71, 0x0A, 0xC0, 0xA7, 0x4D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x4D, 0x04, 0x71, 0x0A, 0xC0, 0xA7,
  0x4D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x4D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x4D, 0x04, 0x71, 0x0A,
  0xC0, 0xA7, 0x4D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x4D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x30, 0x1D,
  0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x30, 0x1D, 0x04, 0x71, 0x09, 0xC0, 0xB7, 0x30, 0x3D, 0x04, 0x71,
  0x09, 0xC0, 0xC7, 0x30, 0x5D, 0x04, 0x71, 0x08, 0xC0, 0xE7, 0x30, 0x8D, 0x04, 0x71, 0x06, 0xD0,
  0x17, 0x20, 0xDD, 0x04, 0x71, 0x03, 0xD0, 0x57, 0x10, 0x4E, 0x05, 0x72, 0xD0, 0xC7, 0x18, 0x1D,
  0xFE, 0xC0, 0x77, 0x20, 0xAD, 0x09, 0x58, 0x32, 0xCF, 0xB9, 0xC0, 0xC7, 0x20, 0x4E, 0x83, 0xEA,
  0x88, 0xBB, 0x02, 0x07, 0xD8, 0x1C, 0x52, 0x70, 0xAF, 0xD8, 0x17, 0x04, 0xF9, 0x09, 0x70, 0xBF,
  0xB0, 0x82, 0x02, 0xF9, 0x09, 0x71, 0x06, 0x0E, 0xE0, 0xC0, 0x44, 0xF9, 0x09, 0x73, 0x84, 0x35,
  0x77, 0x52, 0x77, 0x10,
  // "ý" (U+00FD)
  0x77, 0x38, 0x02, 0x77, 0x77, 0x20, 0x4D, 0x0C, 0x77, 0x72, 0x0B, 0xC0, 0xE0, 0x27, 0x77, 0x10,
  0x4D, 0x04, 0x77, 0x72, 0x0C, 0xC0, 0x67, 0x77, 0x20, 0x5C, 0x07, 0x77, 0x73, 0x0E, 0xB0, 0x77,
  0x77, 0x30, 0x8B, 0x06, 0x77, 0x73, 0x02, 0xB0, 0x57, 0x77, 0x48, 0x28, 0xFE, 0x38, 0x0A, 0xC0,
  0x00, 0xCF, 0xC0, 0xD5, 0x08, 0xFB, 0x01, 0x0C, 0xFC, 0x0D, 0x50, 0x8F, 0xB0, 0x10, 0xCF, 0xC0,
  0xD5, 0x08, 0xFB, 0x82, 0x11, 0x3B, 0xF8, 0x18, 0x21, 0x68, 0x12, 0x5D, 0xC8, 0x1D, 0x52, 0x40,
  0xCD, 0x0B, 0x74, 0x04, 0xC0, 0x36, 0x05, 0xD0, 0x97, 0x40, 0x2B, 0x0A, 0x71, 0x0E, 0xC0, 0xB7,
  0x40, 0x3B, 0x04, 0x71, 0x08, 0xC0, 0xE7, 0x40, 0x6A, 0x0E, 0x72, 0x03, 0xD0, 0x47, 0x30, 0xBA,
  0x09, 0x73, 0x0D, 0xC0, 0x97, 0x3B, 0x04, 0x73, 0x07, 0xC0, 0xE7, 0x20, 0x4A, 0x0E, 0x74, 0x01,
  0xD0, 0x47, 0x10, 0x9A, 0x0A, 0x75, 0x0B, 0xC0, 0x97, 0x10, 0xDA, 0x05, 0x75, 0x06, 0xC0, 0xE7,
  0x02, 0xB7, 0x7D, 0x05, 0x60, 0x6A, 0x0B, 0x77, 0x0A, 0xC0, 0xA6, 0x0B, 0xA0, 0x67, 0x70, 0x4C,
  0x0E, 0x6B, 0x01, 0x77, 0x10, 0xEC, 0x05, 0x40, 0x4A, 0x0B, 0x77, 0x20, 0x9C, 0x0A, 0x40, 0x9A,
  0x06, 0x77, 0x20, 0x3D, 0x40, 0xDA, 0x01, 0x77, 0x30, 0xDC, 0x04, 0x20, 0x2A, 0x0C, 0x77, 0x40,
  0x7C, 0x09, 0x20, 0x6A, 0x07, 0x77, 0x40, 0x2C, 0x0D, 0x20, 0xBA, 0x02, 0x77, 0x50, 0xBC, 0x03,
  0x1A, 0x0D, 0x77, 0x60, 0x6C, 0x07, 0x04, 0xA0, 0x87, 0x76, 0x01, 0xC0, 0xB0, 0x7A, 0x03, 0x77,
  0x70, 0xAB, 0x82, 0xEB, 0xFD, 0x77, 0x71, 0x05, 0xE0, 0x97, 0x77, 0x20, 0xED, 0x04, 0x77, 0x72,
  0x09, 0xC0, 0xE7, 0x77, 0x30, 0x3C, 0x09, 0x77, 0x74, 0x0D, 0xB0, 0x47, 0x77, 0x40, 0xDA, 0x0E,
  0x77, 0x74, 0x03, 0xB0, 0xA7, 0x77, 0x40, 0x8B, 0x05, 0x77, 0x74, 0x0E, 0xA0, 0xE7, 0x77, 0x40,
  0x6B, 0x09, 0x77, 0x74, 0x0D, 0xB0, 0x37, 0x77, 0x30, 0x7B, 0x0D, 0x77, 0x73, 0x03, 0xC0, 0x67,
  0x77, 0x20, 0x30, 0xEB, 0x0D, 0x77, 0x72, 0x07, 0xD0, 0x47, 0x74, 0x83, 0x12, 0x59, 0xED, 0x09,
  0x77, 0x40, 0x2F, 0xA0, 0x97, 0x75, 0x02, 0xF0, 0xD0, 0x57, 0x76, 0x02, 0xA8, 0x3E, 0xDB, 0x84,
  0x77, 0x70,
  // "þ" (U+00FE)
  0x10, 0xEF, 0x90, 0xC7, 0x75, 0x0E, 0xF9, 0x0C, 0x77, 0x50, 0xEF, 0x90, 0xC7, 0x75, 0x82, 0x13,
  0x7E, 0xD0, 0xC7, 0x77, 0x10, 0x2D, 0x0C, 0x77, 0x72, 0x0B, 0xC0, 0xC7, 0x77, 0x20, 0x9C, 0x0C,
  0x77, 0x72, 0x09, 0xC0, 0xC7, 0x77, 0x20, 0x9C, 0x0C, 0x77, 0x72, 0x09, 0xC0, 0xC7, 0x77, 0x20,
  0x9C, 0x0C, 0x77, 0x72, 0x09, 0xC0, 0xC7, 0x77, 0x20, 0x9C, 0x0C, 0x77, 0x72, 0x09, 0xC0, 0xC5,
  0x84, 0x36, 0x76, 0x41, 0x75, 0x09, 0xC0, 0xB3, 0x06, 0x0D, 0xE0, 0xA0, 0x27, 0x30, 0x9C, 0x0B,
  0x20, 0x9F, 0xB0, 0x77, 0x20, 0x9C, 0x81, 0xA0, 0x8A, 0x82, 0xDA, 0x9B, 0xE0, 0x77, 0x10, 0x9C,
  0x83, 0xA3, 0xFE, 0x54, 0x01, 0x0A, 0xD0, 0x47, 0x09, 0xC8, 0x29, 0xCE, 0x27, 0x0B, 0xC0, 0xD7,
  0x09, 0xC8, 0x1C, 0xF7, 0x71, 0x02, 0xD0, 0x56, 0x09, 0xE0, 0x17, 0x20, 0xAC, 0x0B, 0x60, 0x9D,
  0x0B, 0x73, 0x05, 0xD6, 0x09, 0xD0, 0x77, 0x30, 0x2D, 0x04, 0x50, 0x9D, 0x04, 0x74, 0x0E, 0xC0,
  0x75, 0x09, 0xD0, 0x17, 0x40, 0xCC, 0x09, 0x50, 0x9D, 0x75, 0x0A, 0xC0, 0xB5, 0x09, 0xC0, 0xE7,
  0x50, 0x9C, 0x0D, 0x50, 0x9C, 0x0D, 0x75, 0x08, 0xC0, 0xE5, 0x09, 0xC0, 0xC7, 0x50, 0x8C, 0x0E,
  0x50, 0x9C, 0x0C, 0x75, 0x07, 0xD5, 0x09, 0xC0, 0xC7, 0x50, 0x7D, 0x50, 0x9C, 0x0D, 0x75, 0x08,
  0xC0, 0xE5, 0x09, 0xC0, 0xD7, 0x50, 0x8C, 0x0E, 0x50, 0x9C, 0x0E, 0x75, 0x09, 0xC0, 0xD5, 0x09,
  0xD7, 0x50, 0xBC, 0x0B, 0x50, 0x9D, 0x02, 0x74, 0x0D, 0xC0, 0x95, 0x09, 0xD0, 0x57, 0x4D, 0x07,
  0x50, 0x9D, 0x07, 0x73, 0x03, 0xD0, 0x45, 0x09, 0xD0, 0xB7, 0x30, 0x7D, 0x60, 0x9E, 0x01, 0x72,
  0x0C, 0xC0, 0xA6, 0x09, 0xE0, 0x87, 0x10, 0x3D, 0x05, 0x60, 0x9C, 0x82, 0xBE, 0xF3, 0x70, 0xCC,
  0x0D, 0x70, 0x9C, 0x83, 0xA7, 0xFE, 0x54, 0x01, 0x0B, 0xD0, 0x47, 0x09, 0xC8, 0x1A, 0x0C, 0xA8,
  0x2D, 0xA9, 0xBE, 0x06, 0x71, 0x09, 0xC8, 0x2B, 0x01, 0xCF, 0xB0, 0x67, 0x20, 0x9C, 0x0B, 0x30,
  0x80, 0xEE, 0x0A, 0x02, 0x73, 0x09, 0xC0, 0xB5, 0x84, 0x46, 0x76, 0x41, 0x75, 0x09, 0xC0, 0xC7,
  0x77, 0x20, 0x9C, 0x0C, 0x77, 0x72, 0x09, 0xC0, 0xC7, 0x77, 0x20, 0x9C, 0x0C, 0x77, 0x72, 0x09,
  0xC0, 0xC7, 0x77, 0x20, 0x9C, 0x0C, 0x77, 0x72, 0x0A, 0xC0, 0xC7, 0x77, 0x20, 0xCC, 0x0E, 0x77,
  0x71, 0x03, 0xE0, 0x47, 0x74, 0x82, 0x13, 0x7E, 0xE8, 0x2E, 0x73, 0x17, 0x70, 0x1F, 0xF0, 0x77,
  0x60, 0x1F, 0xF0, 0x77, 0x60, 0x1F, 0xF0, 0x77, 0x60,
  // "ÿ" (U+00FF)
  0x72, 0x82, 0x8E, 0xE8, 0x58, 0x33, 0xCE, 0xC3, 0x77, 0x10, 0x5C, 0x07, 0x40, 0xEB, 0x0E, 0x77,
  0x10, 0x9C, 0x0B, 0x30, 0x2D, 0x02, 0x77, 0x09, 0xC0, 0xB3, 0x02, 0xD0, 0x27, 0x70, 0x5C, 0x08,
  0x40, 0xEB, 0x0E, 0x77, 0x28, 0x28, 0xEE, 0x95, 0x83, 0x4C, 0xEC, 0x38, 0x0B, 0xA5, 0x00, 0xCF,
  0xC0, 0xD5, 0x08, 0xFB, 0x01, 0x0C, 0xFC, 0x0D, 0x50, 0x8F, 0xB0, 0x10, 0xCF, 0xC0, 0xD5, 0x08,
  0xFB, 0x82, 0x11, 0x3B, 0xF8, 0x18, 0x21, 0x68, 0x12, 0x5D, 0xC8, 0x1D, 0x52, 0x40, 0xCD, 0x0B,
  0x74, 0x04, 0xC0, 0x36, 0x05, 0xD0, 0x97, 0x40, 0x2B, 0x0A, 0x71, 0x0E, 0xC0, 0xB7, 0x40, 0x3B,
  0x04, 0x71, 0x08, 0xC0, 0xE7, 0x40, 0x6A, 0x0E, 0x72, 0x03, 0xD0, 0x47, 0x30, 0xBA, 0x09, 0x73,
  0x0D, 0xC0, 0x97, 0x3B, 0x04, 0x73, 0x07, 0xC0, 0xE7, 0x20, 0x4A, 0x0E, 0x74, 0x01, 0xD0, 0x47,
  0x10, 0x9A, 0x0A, 0x75, 0x0B, 0xC0, 0x97, 0x10, 0xDA, 0x05, 0x75, 0x06, 0xC0, 0xE7, 0x02, 0xB7,
  0x7D, 0x05, 0x60, 0x6A, 0x0B, 0x77, 0x0A, 0xC0, 0xA6, 0x0B, 0xA0, 0x67, 0x70, 0x4C, 0x0E, 0x6B,
  0x01, 0x77, 0x10, 0xEC, 0x05, 0x40, 0x4A, 0x0B, 0x77, 0x20, 0x9C, 0x0A, 0x40, 0x9A, 0x06, 0x77,
  0x20, 0x3D, 0x40, 0xDA, 0x01, 0x77, 0x30, 0xDC, 0x04, 0x20, 0x2A, 0x0C, 0x77, 0x40, 0x7C, 0x09,
  0x20, 0x6A, 0x07, 0x77, 0x40, 0x2C, 0x0D, 0x20, 0xBA, 0x02, 0x77, 0x50, 0xBC, 0x03, 0x1A, 0x0D,
  0x77, 0x60, 0x6C, 0x07, 0x04, 0xA0, 0x87, 0x76, 0x01, 0xC0, 0xB0, 0x7A, 0x03, 0x77, 0x70, 0xAB,
  0x82, 0xEB, 0xFD, 0x77, 0x71, 0x05, 0xE0, 0x97, 0x77, 0x20, 0xED, 0x04, 0x77, 0x72, 0x09, 0xC0,
  0xE7, 0x77, 0x30, 0x3C, 0x09, 0x77, 0x74, 0x0D, 0xB0, 0x47, 0x77, 0x40, 0xDA, 0x0E, 0x77, 0x74,
  0x03, 0xB0, 0xA7, 0x77, 0x40, 0x8B, 0x05, 0x77, 0x74, 0x0E, 0xA0, 0xE7, 0x77, 0x40, 0x6B, 0x09,
  0x77, 0x74, 0x0D, 0xB0, 0x37, 0x77, 0x30, 0x7B, 0x0D, 0x77, 0x73, 0x03, 0xC0, 0x67, 0x77, 0x20,
  0x30, 0xEB, 0x0D, 0x77, 0x72, 0x07, 0xD0, 0x47, 0x74, 0x83, 0x12, 0x59, 0xED, 0x09, 0x77, 0x40,
  0x2F, 0xA0, 0x97, 0x75, 0x02, 0xF0, 0xD0, 0x57, 0x76, 0x02, 0xA8, 0x3E, 0xDB, 0x84, 0x77, 0x70,
  // "Ā" (U+0100)
  0x74, 0x80, 0x92, 0x17, 0x77, 0x10, 0x9F, 0xF0, 0x37, 0x77, 0x09, 0xFF, 0x03, 0x77, 0x70, 0x9F,
  0xF0, 0x38, 0x0A, 0xD3, 0x00, 0xEB, 0x0D, 0x77, 0x77, 0x30, 0x4D, 0x02, 0x77, 0x77, 0x20, 0x9D,
  0x07, 0x77, 0x77, 0x20, 0xED, 0x0C, 0x77, 0x77, 0x10, 0x3F, 0x01, 0x77, 0x77, 0x08, 0xF0, 0x67,
  0x77, 0x70, 0xDA, 0x0A, 0xC0, 0xB7, 0x77, 0x60, 0x3A, 0x0C, 0x05, 0xD0, 0x17, 0x77, 0x50, 0x8A,
  0x09, 0x01, 0xD0, 0x57, 0x77, 0x50, 0xDA, 0x81, 0x50, 0xDC, 0x0A, 0x77, 0x74, 0x02, 0xB8, 0x11,
  0x09, 0xC0, 0xE7, 0x77, 0x40, 0x7A, 0x0C, 0x20, 0x4D, 0x04, 0x77, 0x73, 0x0C, 0xA0, 0x83, 0xD0,
  0x97, 0x77, 0x20, 0x1B, 0x03, 0x30, 0xBC, 0x0E, 0x77, 0x72, 0x06, 0xA0, 0xE4, 0x07, 0xD0, 0x37,
  0x77, 0x10, 0xBA, 0x0A, 0x40, 0x2D, 0x08, 0x77, 0x70, 0x1B, 0x05, 0x50, 0xDC, 0x0D, 0x77, 0x70,
  0x6B, 0x01, 0x50, 0x9D, 0x02, 0x77, 0x60, 0xBA, 0x0B, 0x60, 0x4D, 0x07, 0x77, 0x6B, 0x07, 0x7D,
  0x0C, 0x77, 0x50, 0x5B, 0x02, 0x70, 0xBD, 0x01, 0x77, 0x40, 0xAA, 0x0D, 0x71, 0x06, 0xD0, 0x67,
  0x74, 0x0E, 0xA0, 0x87, 0x10, 0x2D, 0x0B, 0x77, 0x30, 0x4B, 0x04, 0x72, 0x0D, 0xD7, 0x73, 0x09,
  0xA0, 0xE7, 0x30, 0x8D, 0x05, 0x77, 0x20, 0xEA, 0x0A, 0x73, 0x04, 0xD0, 0xA7, 0x71, 0x04, 0xFF,
  0xE0, 0xE7, 0x71, 0x09, 0xFF, 0xF0, 0x47, 0x70, 0xDB, 0x80, 0x91, 0xED, 0x09, 0x76, 0x03, 0xB0,
  0x57, 0x50, 0x1D, 0x0E, 0x76, 0x08, 0xA0, 0xE7, 0x70, 0xBD, 0x03, 0x75, 0x0D, 0xA0, 0xA7, 0x70,
  0x6D, 0x08, 0x74, 0x02, 0xB0, 0x57, 0x70, 0x1D, 0x0D, 0x74, 0x07, 0xB0, 0x17, 0x71, 0x0C, 0xD0,
  0x27, 0x30, 0xCA, 0x0B, 0x77, 0x20, 0x7D, 0x07, 0x72, 0x02, 0xB0, 0x67, 0x72, 0x03, 0xD0, 0xC7,
  0x20, 0x8B, 0x03, 0x77, 0x30, 0xED, 0x01, 0x71, 0x0E, 0xB0, 0x27, 0x73, 0x0C, 0xD0, 0x67, 0x07,
  0xC0, 0x67, 0x73, 0x0E, 0xD0, 0xD4, 0x81, 0x12, 0x7D, 0x82, 0xE7, 0x21, 0x73, 0x82, 0x11, 0x4B,
  0xF8, 0x3B, 0x42, 0x0E, 0xFC, 0x0B, 0x72, 0xFF, 0x08, 0x0E, 0xFC, 0x0B, 0x72, 0xFF, 0x08, 0x0E,
  0xFC, 0x0B, 0x72, 0xFF, 0x08,
  // "ā" (U+0101)
  0x68, 0x09, 0x21, 0x74, 0x09, 0xFF, 0x03, 0x73, 0x09, 0xFF, 0x03, 0x73, 0x09, 0xFF, 0x03, 0x80,
  0x9E, 0x10, 0x86, 0x24, 0x67, 0x76, 0x41, 0x77, 0x18, 0x12, 0x9E, 0xF9, 0x0D, 0x06, 0x75, 0x08,
  0xFE, 0x0C, 0x02, 0x72, 0x08, 0xD8, 0x3E, 0xB9, 0x9C, 0xD0, 0xD7, 0x10, 0x1D, 0x0B, 0x01, 0x40,
  0x40, 0xEC, 0x08, 0x70, 0x4D, 0x01, 0x60, 0x7C, 0x0E, 0x70, 0x5C, 0x0B, 0x70, 0x1D, 0x04, 0x60,
  0x1C, 0x07, 0x71, 0x0D, 0xC0, 0x77, 0x06, 0xB0, 0x67, 0x10, 0xBC, 0x09, 0x71, 0x82, 0x16, 0x83,
  0x71, 0x0A, 0xC0, 0xA7, 0x76, 0x0A, 0xC0, 0xB7, 0x76, 0x09, 0xC0, 0xB7, 0x76, 0x09, 0xC0, 0xB7,
  0x76, 0x09, 0xC0, 0xB7, 0x38, 0x43, 0x7A, 0xDE, 0xEF, 0xA0, 0xB7, 0x10, 0x50, 0xDF, 0xF9, 0x0B,
  0x70, 0xAD, 0x86, 0xC7, 0x43, 0x22, 0x29, 0xC0, 0xB6, 0x0A, 0xD0, 0x57, 0x09, 0xC0, 0xB5, 0x04,
  0xD0, 0x67, 0x10, 0x9C, 0x0B, 0x50, 0xCC, 0x0C, 0x72, 0x09, 0xC0, 0xB4, 0x01, 0xD0, 0x77, 0x20,
  0x9C, 0x0B, 0x40, 0x4D, 0x03, 0x72, 0x09, 0xC0, 0xB4, 0x06, 0xD0, 0x17, 0x20, 0xAC, 0x0B, 0x40,
  0x7D, 0x01, 0x72, 0x0C, 0xC0, 0xB4, 0x06, 0xD0, 0x17, 0x2D, 0x0B, 0x40, 0x5D, 0x02, 0x71, 0x05,
  0xD0, 0xB4, 0x03, 0xD0, 0x57, 0x10, 0xCD, 0x0C, 0x5D, 0x09, 0x78, 0x16, 0xF7, 0xC0, 0xD5, 0x0B,
  0xD0, 0x25, 0x83, 0x5F, 0xA0, 0xEC, 0x02, 0x40, 0x4D, 0x89, 0x1E, 0x51, 0x24, 0xAF, 0xE1, 0x0C,
  0xC8, 0x1D, 0x41, 0x30, 0x9F, 0xC0, 0x42, 0x0A, 0xF0, 0x13, 0x0A, 0xFA, 0x06, 0x30, 0x8F, 0x01,
  0x40, 0x60, 0xED, 0x0D, 0x04, 0x40, 0x6F, 0x01, 0x68, 0x34, 0x67, 0x63, 0x77, 0x10,
  // "Ă" (U+0102)
  0x73, 0x08, 0xA0, 0x17, 0x10, 0x8A, 0x77, 0x71, 0x07, 0xA0, 0x67, 0x18, 0x1D, 0xFE, 0x77, 0x71,
  0x03, 0xA0, 0xE0, 0x26, 0x08, 0xA0, 0xB7, 0x77, 0x20, 0xEA, 0x85, 0xE7, 0x20, 0x14, 0xBB, 0x06,
  0x77, 0x72, 0x07, 0xFC, 0x0E, 0x77, 0x74, 0x0C, 0xFB, 0x05, 0x77, 0x74, 0x01, 0x0C, 0xF9, 0x06,
  0x77, 0x77, 0x86, 0x5A, 0xDF, 0xEC, 0x82, 0x80, 0xAD, 0x70, 0x0E, 0xB0, 0xD7, 0x77, 0x73, 0x04,
  0xD0, 0x27, 0x77, 0x72, 0x09, 0xD0, 0x77, 0x77, 0x72, 0x0E, 0xD0, 0xC7, 0x77, 0x71, 0x03, 0xF0,
  0x17, 0x77, 0x70, 0x8F, 0x06, 0x77, 0x77, 0x0D, 0xA0, 0xAC, 0x0B, 0x77, 0x76, 0x03, 0xA0, 0xC0,
  0x5D, 0x01, 0x77, 0x75, 0x08, 0xA0, 0x90, 0x1D, 0x05, 0x77, 0x75, 0x0D, 0xA8, 0x15, 0x0D, 0xC0,
  0xA7, 0x77, 0x40, 0x2B, 0x81, 0x10, 0x9C, 0x0E, 0x77, 0x74, 0x07, 0xA0, 0xC2, 0x04, 0xD0, 0x47,
  0x77, 0x30, 0xCA, 0x08, 0x3D, 0x09, 0x77, 0x72, 0x01, 0xB0, 0x33, 0x0B, 0xC0, 0xE7, 0x77, 0x20,
  0x6A, 0x0E, 0x40, 0x7D, 0x03, 0x77, 0x71, 0x0B, 0xA0, 0xA4, 0x02, 0xD0, 0x87, 0x77, 0x01, 0xB0,
  0x55, 0x0D, 0xC0, 0xD7, 0x77, 0x06, 0xB0, 0x15, 0x09, 0xD0, 0x27, 0x76, 0x0B, 0xA0, 0xB6, 0x04,
  0xD0, 0x77, 0x76, 0xB0, 0x77, 0xD0, 0xC7, 0x75, 0x05, 0xB0, 0x27, 0x0B, 0xD0, 0x17, 0x74, 0x0A,
  0xA0, 0xD7, 0x10, 0x6D, 0x06, 0x77, 0x40, 0xEA, 0x08, 0x71, 0x02, 0xD0, 0xB7, 0x73, 0x04, 0xB0,
  0x47, 0x20, 0xDD, 0x77, 0x30, 0x9A, 0x0E, 0x73, 0x08, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0xA7, 0x30,
  0x4D, 0x0A, 0x77, 0x10, 0x4F, 0xFE, 0x0E, 0x77, 0x10, 0x9F, 0xFF, 0x04, 0x77, 0x0D, 0xB8, 0x09,
  0x1E, 0xD0, 0x97, 0x60, 0x3B, 0x05, 0x75, 0x01, 0xD0, 0xE7, 0x60, 0x8A, 0x0E, 0x77, 0x0B, 0xD0,
  0x37, 0x50, 0xDA, 0x0A, 0x77, 0x06, 0xD0, 0x87, 0x40, 0x2B, 0x05, 0x77, 0x01, 0xD0, 0xD7, 0x40,
  0x7B, 0x01, 0x77, 0x10, 0xCD, 0x02, 0x73, 0x0C, 0xA0, 0xB7, 0x72, 0x07, 0xD0, 0x77, 0x20, 0x2B,
  0x06, 0x77, 0x20, 0x3D, 0x0C, 0x72, 0x08, 0xB0, 0x37, 0x73, 0x0E, 0xD0, 0x17, 0x10, 0xEB, 0x02,
  0x77, 0x30, 0xCD, 0x06, 0x70, 0x7C, 0x06, 0x77, 0x30, 0xED, 0x0D, 0x48, 0x11, 0x27, 0xD8, 0x2E,
  0x72, 0x17, 0x38, 0x21, 0x14, 0xBF, 0x83, 0xB4, 0x20, 0xEF, 0xC0, 0xB7, 0x2F, 0xF0, 0x80, 0xEF,
  0xC0, 0xB7, 0x2F, 0xF0, 0x80, 0xEF, 0xC0, 0xB7, 0x2F, 0xF0, 0x80,
  // "ă" (U+0103)
  0x40, 0x8A, 0x01, 0x71, 0x08, 0xA7, 0x40, 0x7A, 0x06, 0x71, 0x81, 0xDF, 0xE7, 0x40, 0x3A, 0x0E,
  0x02, 0x60, 0x8A, 0x0B, 0x75, 0x0E, 0xA8, 0x5E, 0x72, 0x01, 0x4B, 0xB0, 0x67, 0x50, 0x7F, 0xC0,
  0xE7, 0x70, 0xCF, 0xB0, 0x57, 0x70, 0x10, 0xCF, 0x90, 0x67, 0x73, 0x86, 0x5A, 0xDF, 0xEC, 0x82,
  0x80, 0x9E, 0x60, 0x86, 0x24, 0x67, 0x76, 0x41, 0x77, 0x18, 0x12, 0x9E, 0xF9, 0x0D, 0x06, 0x75,
  0x08, 0xFE, 0x0C, 0x02, 0x72, 0x08, 0xD8, 0x3E, 0xB9, 0x9C, 0xD0, 0xD7, 0x10, 0x1D, 0x0B, 0x01,
  0x40, 0x40, 0xEC, 0x08, 0x70, 0x4D, 0x01, 0x60, 0x7C, 0x0E, 0x70, 0x5C, 0x0B, 0x70, 0x1D, 0x04,
  0x60, 0x1C, 0x07, 0x71, 0x0D, 0xC0, 0x77, 0x06, 0xB0, 0x67, 0x10, 0xBC, 0x09, 0x71, 0x82, 0x16,
  0x83, 0x71, 0x0A, 0xC0, 0xA7, 0x76, 0x0A, 0xC0, 0xB7, 0x76, 0x09, 0xC0, 0xB7, 0x76, 0x09, 0xC0,
  0xB7, 0x76, 0x09, 0xC0, 0xB7, 0x38, 0x43, 0x7A, 0xDE, 0xEF, 0xA0, 0xB7, 0x10, 0x50, 0xDF, 0xF9,
  0x0B, 0x70, 0xAD, 0x86, 0xC7, 0x43, 0x22, 0x29, 0xC0, 0xB6, 0x0A, 0xD0, 0x57, 0x09, 0xC0, 0xB5,
  0x04, 0xD0, 0x67, 0x10, 0x9C, 0x0B, 0x50, 0xCC, 0x0C, 0x72, 0x09, 0xC0, 0xB4, 0x01, 0xD0, 0x77,
  0x20, 0x9C, 0x0B, 0x40, 0x4D, 0x03, 0x72, 0x09, 0xC0, 0xB4, 0x06, 0xD0, 0x17, 0x20, 0xAC, 0x0B,
  0x40, 0x7D, 0x01, 0x72, 0x0C, 0xC0, 0xB4, 0x06, 0xD0, 0x17, 0x2D, 0x0B, 0x40, 0x5D, 0x02, 0x71,
  0x05, 0xD0, 0xB4, 0x03, 0xD0, 0x57, 0x10, 0xCD, 0x0C, 0x5D, 0x09, 0x78, 0x16, 0xF7, 0xC0, 0xD5,
  0x0B, 0xD0, 0x25, 0x83, 0x5F, 0xA0, 0xEC, 0x02, 0x40, 0x4D, 0x89, 0x1E, 0x51, 0x24, 0xAF, 0xE1,
  0x0C, 0xC8, 0x1D, 0x41, 0x30, 0x9F, 0xC0, 0x42, 0x0A, 0xF0, 0x13, 0x0A, 0xFA, 0x06, 0x30, 0x8F,
  0x01, 0x40, 0x60, 0xED, 0x0D, 0x04, 0x40, 0x6F, 0x01, 0x68, 0x34, 0x67, 0x63, 0x77, 0x10,
  // "Ą" (U+0104)
  0x77, 0x20, 0xEB, 0x0D, 0x77, 0x77, 0x30, 0x4D, 0x02, 0x77, 0x77, 0x20, 0x9D, 0x07, 0x77, 0x77,
  0x20, 0xED, 0x0C, 0x77, 0x77, 0x10, 0x3F, 0x01, 0x77, 0x77, 0x08, 0xF0, 0x67, 0x77, 0x70, 0xDA,
  0x0A, 0xC0, 0xB7, 0x77, 0x60, 0x3A, 0x0C, 0x05, 0xD0, 0x17, 0x77, 0x50, 0x8A, 0x09, 0x01, 0xD0,
  0x57, 0x77, 0x50, 0xDA, 0x81, 0x50, 0xDC, 0x0A, 0x77, 0x74, 0x02, 0xB8, 0x11, 0x09, 0xC0, 0xE7,
  0x77, 0x40, 0x7A, 0x0C, 0x20, 0x4D, 0x04, 0x77, 0x73, 0x0C, 0xA0, 0x83, 0xD0, 0x97, 0x77, 0x20,
  0x1B, 0x03, 0x30, 0xBC, 0x0E, 0x77, 0x72, 0x06, 0xA0, 0xE4, 0x07, 0xD0, 0x37, 0x77, 0x10, 0xBA,
  0x0A, 0x40, 0x2D, 0x08, 0x77, 0x70, 0x1B, 0x05, 0x50, 0xDC, 0x0D, 0x77, 0x70, 0x6B, 0x01, 0x50,
  0x9D, 0x02, 0x77, 0x60, 0xBA, 0x0B, 0x60, 0x4D, 0x07, 0x77, 0x6B, 0x07, 0x7D, 0x0C, 0x77, 0x50,
  0x5B, 0x02, 0x70, 0xBD, 0x01, 0x77, 0x40, 0xAA, 0x0D, 0x71, 0x06, 0xD0, 0x67, 0x74, 0x0E, 0xA0,
  0x87, 0x10, 0x2D, 0x0B, 0x77, 0x30, 0x4B, 0x04, 0x72, 0x0D, 0xD7, 0x73, 0x09, 0xA0, 0xE7, 0x30,
  0x8D, 0x05, 0x77, 0x20, 0xEA, 0x0A, 0x73, 0x04, 0xD0, 0xA7, 0x71, 0x04, 0xFF, 0xE0, 0xE7, 0x71,
  0x09, 0xFF, 0xF0, 0x47, 0x70, 0xDB, 0x80, 0x91, 0xED, 0x09, 0x76, 0x03, 0xB0, 0x57, 0x50, 0x1D,
  0x0E, 0x76, 0x08, 0xA0, 0xE7, 0x70, 0xBD, 0x03, 0x75, 0x0D, 0xA0, 0xA7, 0x70, 0x6D, 0x08, 0x74,
  0x02, 0xB0, 0x57, 0x70, 0x1D, 0x0D, 0x74, 0x07, 0xB0, 0x17, 0x71, 0x0C, 0xD0, 0x27, 0x30, 0xCA,
  0x0B, 0x77, 0x20, 0x7D, 0x07, 0x72, 0x02, 0xB0, 0x67, 0x72, 0x03, 0xD0, 0xC7, 0x20, 0x8B, 0x03,
  0x77, 0x30, 0xED, 0x01, 0x71, 0x0E, 0xB0, 0x27, 0x73, 0x0C, 0xD0, 0x67, 0x07, 0xC0, 0x67, 0x73,
  0x0E, 0xD0, 0xD4, 0x81, 0x12, 0x7D, 0x82, 0xE7, 0x21, 0x73, 0x82, 0x11, 0x4B, 0xF8, 0x3B, 0x42,
  0x0E, 0xFC, 0x0B, 0x72, 0xFF, 0x08, 0x0E, 0xFC, 0x0B, 0x72, 0xFF, 0x08, 0x0E, 0xFC, 0x0B, 0x72,
  0xFF, 0x08, 0x77, 0x77, 0x84, 0x18, 0xEF, 0xA2, 0x77, 0x77, 0x20, 0x30, 0xDA, 0x07, 0x77, 0x77,
  0x30, 0x20, 0xEA, 0x08, 0x77, 0x77, 0x40, 0xDA, 0x0C, 0x77, 0x77, 0x40, 0x6B, 0x06, 0x77, 0x77,
  0x40, 0xCB, 0x02, 0x77, 0x77, 0x4C, 0x77, 0x77, 0x40, 0x1C, 0x77, 0x77, 0x40, 0x1C, 0x02, 0x77,
  0x77, 0x40, 0xEB, 0x08, 0x77, 0x77, 0x40, 0xAC, 0x84, 0x93, 0x13, 0x66, 0x77, 0x75, 0x03, 0xFA,
  0x09, 0x77, 0x76, 0x05, 0x0E, 0xF0, 0x97, 0x77, 0x78, 0x71, 0x7C, 0xEF, 0xEC, 0x93, 0x10,
  // "ą" (U+0105)
  0x71, 0x86, 0x24, 0x67, 0x76, 0x41, 0x77, 0x18, 0x12, 0x9E, 0xF9, 0x0D, 0x06, 0x75, 0x08, 0xFE,
  0x0C, 0x02, 0x72, 0x08, 0xD8, 0x3E, 0xB9, 0x9C, 0xD0, 0xD7, 0x10, 0x1D, 0x0B, 0x01, 0x40, 0x40,
  0xEC, 0x08, 0x70, 0x4D, 0x01, 0x60, 0x7C, 0x0E, 0x70, 0x5C, 0x0B, 0x70, 0x1D, 0x04, 0x60, 0x1C,
  0x07, 0x71, 0x0D, 0xC0, 0x77, 0x06, 0xB0, 0x67, 0x10, 0xBC, 0x09, 0x71, 0x82, 0x16, 0x83, 0x71,
  0x0A, 0xC0, 0xA7, 0x76, 0x0A, 0xC0, 0xB7, 0x76, 0x09, 0xC0, 0xB7, 0x76, 0x09, 0xC0, 0xB7, 0x76,
  0x09, 0xC0, 0xB7, 0x38, 0x43, 0x7A, 0xDE, 0xEF, 0xA0, 0xB7, 0x10, 0x50, 0xDF, 0xF9, 0x0B, 0x70,
  0xAD, 0x86, 0xC7, 0x43, 0x22, 0x29, 0xC0, 0xB6, 0x0A, 0xD0, 0x57, 0x09, 0xC0, 0xB5, 0x04, 0xD0,
  0x67, 0x10, 0x9C, 0x0B, 0x50, 0xCC, 0x0C, 0x72, 0x09, 0xC0, 0xB4, 0x01, 0xD0, 0x77, 0x20, 0x9C,
  0x0B, 0x40, 0x4D, 0x03, 0x72, 0x09, 0xC0, 0xB4, 0x06, 0xD0, 0x17, 0x20, 0xAC, 0x0B, 0x40, 0x7D,
  0x01, 0x72, 0x0C, 0xC0, 0xB4, 0x06, 0xD0, 0x17, 0x2D, 0x0B, 0x40, 0x5D, 0x02, 0x71, 0x05, 0xD0,
  0xB4, 0x03, 0xD0, 0x57, 0x10, 0xCD, 0x0C, 0x5D, 0x09, 0x78, 0x16, 0xF7, 0xC0, 0xD5, 0x0B, 0xD0,
  0x25, 0x83, 0x5F, 0xA0, 0xEC, 0x02, 0x40, 0x4D, 0x89, 0x1E, 0x51, 0x24, 0xAF, 0xE1, 0x0C, 0xC8,
  0x1D, 0x41, 0x30, 0x9F, 0xC0, 0x42, 0x0A, 0xF0, 0x13, 0x0A, 0xFA, 0x06, 0x30, 0x8F, 0x01, 0x40,
  0x60, 0xED, 0x0D, 0x04, 0x40, 0x6F, 0x01, 0x68, 0x34, 0x67, 0x63, 0x48, 0x41, 0x8E, 0xFA, 0x27,
  0x75, 0x03, 0x0D, 0xA0, 0x77, 0x76, 0x02, 0x0E, 0xA0, 0x87, 0x77, 0x0D, 0xA0, 0xC7, 0x77, 0x06,
  0xB0, 0x67, 0x77, 0x0C, 0xB0, 0x27, 0x77, 0xC7, 0x77, 0x01, 0xC7, 0x77, 0x01, 0xC0, 0x27, 0x77,
  0x0E, 0xB0, 0x87, 0x77, 0x0A, 0xC8, 0x49, 0x31, 0x36, 0x67, 0x71, 0x03, 0xFA, 0x09, 0x77, 0x20,
  0x50, 0xEF, 0x09, 0x77, 0x38, 0x71, 0x7C, 0xEF, 0xEC, 0x93, 0x30,
  // "Ć" (U+0106)
  0x77, 0x58, 0x02, 0x77, 0x77, 0x10, 0x4D, 0x0C, 0x77, 0x71, 0x0B, 0xC0, 0xE0, 0x27, 0x77, 0x04,
  0xD0, 0x47, 0x77, 0x10, 0xCC, 0x06, 0x77, 0x71, 0x05, 0xC0, 0x77, 0x77, 0x20, 0xEB, 0x07, 0x77,
  0x72, 0x08, 0xB0, 0x67, 0x77, 0x20, 0x2B, 0x05, 0x77, 0x73, 0x82, 0x8F, 0xE3, 0x80, 0x9D, 0x40,
  0x86, 0x35, 0x67, 0x66, 0x41, 0x77, 0x38, 0x11, 0x6C, 0xFA, 0x81, 0xC7, 0x17, 0x60, 0x70, 0xEF,
  0xE0, 0xE0, 0x57, 0x30, 0x20, 0xCD, 0x84, 0xEB, 0x99, 0xBE, 0xE0, 0x77, 0x10, 0x30, 0xEC, 0x0C,
  0x04, 0x60, 0x8E, 0x04, 0x60, 0x20, 0xEC, 0x09, 0x72, 0x07, 0xD0, 0xB6, 0x0D, 0xC0, 0xA7, 0x40,
  0xBD, 0x50, 0x8C, 0x0E, 0x01, 0x74, 0x04, 0xD0, 0x13, 0x02, 0xD0, 0x77, 0x60, 0xEB, 0x0E, 0x40,
  0x9D, 0x01, 0x76, 0x0B, 0xB0, 0x73, 0x01, 0xD0, 0xA7, 0x78, 0x29, 0xFE, 0x74, 0x06, 0xD0, 0x57,
  0x70, 0x30, 0x46, 0x0B, 0xD0, 0x17, 0x77, 0x01, 0xD0, 0xE7, 0x77, 0x10, 0x4D, 0x0A, 0x77, 0x71,
  0x07, 0xD0, 0x87, 0x77, 0x10, 0xAD, 0x06, 0x77, 0x71, 0x0C, 0xD0, 0x47, 0x77, 0x10, 0xED, 0x03,
  0x77, 0x71, 0xE0, 0x27, 0x77, 0x1E, 0x02, 0x77, 0x70, 0x1E, 0x01, 0x77, 0x70, 0x1E, 0x01, 0x77,
  0x70, 0x1E, 0x01, 0x77, 0x71, 0xE0, 0x27, 0x77, 0x1E, 0x02, 0x77, 0x71, 0x0E, 0xD0, 0x37, 0x77,
  0x10, 0xCD, 0x04, 0x77, 0x71, 0x0A, 0xD0, 0x67, 0x77, 0x10, 0x7D, 0x08, 0x77, 0x71, 0x04, 0xD0,
  0xB7, 0x77, 0x10, 0x1D, 0x0E, 0x77, 0x72, 0x0C, 0xD0, 0x27, 0x77, 0x10, 0x7D, 0x06, 0x77, 0x71,
  0x02, 0xD0, 0xC7, 0x77, 0x20, 0xAD, 0x03, 0x77, 0x71, 0x03, 0xD0, 0x97, 0x72, 0x04, 0x07, 0x50,
  0xAD, 0x03, 0x77, 0x81, 0x2E, 0xD5, 0x01, 0x0E, 0xC0, 0xD0, 0x17, 0x58, 0x22, 0xDF, 0xE6, 0x04,
  0xD0, 0xC0, 0x17, 0x30, 0x30, 0xEA, 0x0A, 0x70, 0x5D, 0x81, 0xE7, 0x16, 0x02, 0x08, 0xB0, 0xE0,
  0x27, 0x10, 0x40, 0xEE, 0x84, 0xCA, 0x99, 0xAD, 0xC0, 0xE0, 0x47, 0x30, 0x10, 0xBF, 0xF0, 0xC0,
  0x27, 0x68, 0x13, 0x9E, 0xF9, 0x81, 0xEA, 0x47, 0x74, 0x86, 0x25, 0x67, 0x76, 0x53, 0x71,
  // "ć" (U+0107)
  0x77, 0x80, 0x27, 0x77, 0x10, 0x4D, 0x0C, 0x77, 0x10, 0xBC, 0x0E, 0x02, 0x77, 0x04, 0xD0, 0x47,
  0x71, 0x0C, 0xC0, 0x67, 0x71, 0x05, 0xC0, 0x77, 0x72, 0x0E, 0xB0, 0x77, 0x72, 0x08, 0xB0, 0x67,
  0x72, 0x02, 0xB0, 0x57, 0x73, 0x82, 0x8F, 0xE3, 0x80, 0x9C, 0x60, 0x85, 0x25, 0x67, 0x65, 0x27,
  0x58, 0x11, 0x7D, 0xF8, 0x1E, 0x92, 0x71, 0x04, 0x0E, 0xFD, 0x07, 0x60, 0x5D, 0x82, 0xEA, 0x9B,
  0xE0, 0x74, 0x03, 0xD0, 0x84, 0x02, 0x0D, 0xD0, 0x13, 0x0D, 0xC0, 0x86, 0x05, 0xD0, 0x52, 0x05,
  0xC0, 0xD7, 0x10, 0xEC, 0x07, 0x20, 0xCC, 0x07, 0x71, 0x0A, 0xC8, 0x16, 0x02, 0xD0, 0x17, 0x10,
  0x8C, 0x81, 0x20, 0x6C, 0x0D, 0x72, 0x07, 0xA0, 0xE0, 0x52, 0x0A, 0xC0, 0xA7, 0x28, 0x12, 0x53,
  0x40, 0xDC, 0x08, 0x77, 0x20, 0xEC, 0x06, 0x77, 0x10, 0x1D, 0x05, 0x77, 0x10, 0x2D, 0x04, 0x77,
  0x10, 0x2D, 0x03, 0x77, 0x10, 0x3D, 0x03, 0x77, 0x10, 0x3D, 0x03, 0x77, 0x10, 0x3D, 0x03, 0x77,
  0x10, 0x2D, 0x04, 0x77, 0x10, 0x1D, 0x05, 0x77, 0x20, 0xEC, 0x07, 0x77, 0x20, 0xDC, 0x09, 0x77,
  0x20, 0x9C, 0x0B, 0x77, 0x20, 0x6D, 0x77, 0x20, 0x1D, 0x04, 0x77, 0x20, 0xBC, 0x0A, 0x75, 0x0C,
  0x02, 0x20, 0x4D, 0x03, 0x73, 0x81, 0x9F, 0x73, 0x0B, 0xC0, 0xD0, 0x17, 0x10, 0x8A, 0x06, 0x30,
  0x10, 0xEC, 0x0D, 0x04, 0x50, 0x20, 0xBB, 0x01, 0x40, 0x30, 0xED, 0x83, 0xDA, 0x9A, 0xCC, 0x08,
  0x60, 0x20, 0xCF, 0xD0, 0x87, 0x20, 0x50, 0xCF, 0x90, 0xA0, 0x37, 0x58, 0x51, 0x46, 0x77, 0x64,
  0x60,
  // "Ĉ" (U+0108)
  0x77, 0x03, 0x80, 0x17, 0x77, 0x72, 0x0C, 0xD0, 0x47, 0x77, 0x05, 0xE0, 0xC7, 0x77, 0x0D, 0xF0,
  0x57, 0x75, 0x08, 0xB0, 0xC0, 0x7B, 0x0D, 0x77, 0x40, 0x2B, 0x82, 0xE2, 0x09, 0xB0, 0x87, 0x73,
  0x0B, 0xA0, 0xE0, 0x33, 0x0B, 0xB0, 0x27, 0x71, 0x06, 0xA0, 0xE0, 0x45, 0x0B, 0xA0, 0xC7, 0x78,
  0x32, 0xEF, 0xE4, 0x70, 0xBA, 0x08, 0x76, 0x82, 0x8F, 0xE3, 0x72, 0x0A, 0xA8, 0x09, 0xC5, 0x08,
  0x63, 0x56, 0x76, 0x64, 0x17, 0x73, 0x81, 0x16, 0xCF, 0xA8, 0x1C, 0x71, 0x76, 0x07, 0x0E, 0xFE,
  0x0E, 0x05, 0x73, 0x02, 0x0C, 0xD8, 0x4E, 0xB9, 0x9B, 0xEE, 0x07, 0x71, 0x03, 0x0E, 0xC0, 0xC0,
  0x46, 0x08, 0xE0, 0x46, 0x02, 0x0E, 0xC0, 0x97, 0x20, 0x7D, 0x0B, 0x60, 0xDC, 0x0A, 0x74, 0x0B,
  0xD5, 0x08, 0xC0, 0xE0, 0x17, 0x40, 0x4D, 0x01, 0x30, 0x2D, 0x07, 0x76, 0x0E, 0xB0, 0xE4, 0x09,
  0xD0, 0x17, 0x60, 0xBB, 0x07, 0x30, 0x1D, 0x0A, 0x77, 0x82, 0x9F, 0xE7, 0x40, 0x6D, 0x05, 0x77,
  0x03, 0x04, 0x60, 0xBD, 0x01, 0x77, 0x70, 0x1D, 0x0E, 0x77, 0x71, 0x04, 0xD0, 0xA7, 0x77, 0x10,
  0x7D, 0x08, 0x77, 0x71, 0x0A, 0xD0, 0x67, 0x77, 0x10, 0xCD, 0x04, 0x77, 0x71, 0x0E, 0xD0, 0x37,
  0x77, 0x1E, 0x02, 0x77, 0x71, 0xE0, 0x27, 0x77, 0x01, 0xE0, 0x17, 0x77, 0x01, 0xE0, 0x17, 0x77,
  0x01, 0xE0, 0x17, 0x77, 0x1E, 0x02, 0x77, 0x71, 0xE0, 0x27, 0x77, 0x10, 0xED, 0x03, 0x77, 0x71,
  0x0C, 0xD0, 0x47, 0x77, 0x10, 0xAD, 0x06, 0x77, 0x71, 0x07, 0xD0, 0x87, 0x77, 0x10, 0x4D, 0x0B,
  0x77, 0x71, 0x01, 0xD0, 0xE7, 0x77, 0x20, 0xCD, 0x02, 0x77, 0x71, 0x07, 0xD0, 0x67, 0x77, 0x10,
  0x2D, 0x0C, 0x77, 0x72, 0x0A, 0xD0, 0x37, 0x77, 0x10, 0x3D, 0x09, 0x77, 0x20, 0x40, 0x75, 0x0A,
  0xD0, 0x37, 0x78, 0x12, 0xED, 0x50, 0x10, 0xEC, 0x0D, 0x01, 0x75, 0x82, 0x2D, 0xFE, 0x60, 0x4D,
  0x0C, 0x01, 0x73, 0x03, 0x0E, 0xA0, 0xA7, 0x05, 0xD8, 0x1E, 0x71, 0x60, 0x20, 0x8B, 0x0E, 0x02,
  0x71, 0x04, 0x0E, 0xE8, 0x4C, 0xA9, 0x9A, 0xDC, 0x0E, 0x04, 0x73, 0x01, 0x0B, 0xFF, 0x0C, 0x02,
  0x76, 0x81, 0x39, 0xEF, 0x98, 0x1E, 0xA4, 0x77, 0x48, 0x62, 0x56, 0x77, 0x65, 0x37, 0x10,
  // "ĉ" (U+0109)
  0x72, 0x03, 0x80, 0x17, 0x77, 0x20, 0xCD, 0x04, 0x77, 0x05, 0xE0, 0xC7, 0x70, 0xDF, 0x05, 0x75,
  0x08, 0xB0, 0xC0, 0x7B, 0x0D, 0x74, 0x02, 0xB8, 0x2E, 0x20, 0x9B, 0x08, 0x73, 0x0B, 0xA0, 0xE0,
  0x33, 0x0B, 0xB0, 0x27, 0x10, 0x6A, 0x0E, 0x04, 0x50, 0xBA, 0x0C, 0x78, 0x32, 0xEF, 0xE4, 0x70,
  0xBA, 0x08, 0x68, 0x28, 0xFE, 0x37, 0x20, 0xAA, 0x80, 0x9B, 0x70, 0x85, 0x25, 0x67, 0x65, 0x27,
  0x58, 0x11, 0x7D, 0xF8, 0x1E, 0x92, 0x71, 0x04, 0x0E, 0xFD, 0x07, 0x60, 0x5D, 0x82, 0xEA, 0x9B,
  0xE0, 0x74, 0x03, 0xD0, 0x84, 0x02, 0x0D, 0xD0, 0x13, 0x0D, 0xC0, 0x86, 0x05, 0xD0, 0x52, 0x05,
  0xC0, 0xD7, 0x10, 0xEC, 0x07, 0x20, 0xCC, 0x07, 0x71, 0x0A, 0xC8, 0x16, 0x02, 0xD0, 0x17, 0x10,
  0x8C, 0x81, 0x20, 0x6C, 0x0D, 0x72, 0x07, 0xA0, 0xE0, 0x52, 0x0A, 0xC0, 0xA7, 0x28, 0x12, 0x53,
  0x40, 0xDC, 0x08, 0x77, 0x20, 0xEC, 0x06, 0x77, 0x10, 0x1D, 0x05, 0x77, 0x10, 0x2D, 0x04, 0x77,
  0x10, 0x2D, 0x03, 0x77, 0x10, 0x3D, 0x03, 0x77, 0x10, 0x3D, 0x03, 0x77, 0x10, 0x3D, 0x03, 0x77,
  0x10, 0x2D, 0x04, 0x77, 0x10, 0x1D, 0x05, 0x77, 0x20, 0xEC, 0x07, 0x77, 0x20, 0xDC, 0x09, 0x77,
  0x20, 0x9C, 0x0B, 0x77, 0x20, 0x6D, 0x77, 0x20, 0x1D, 0x04, 0x77, 0x20, 0xBC, 0x0A, 0x75, 0x0C,
  0x02, 0x20, 0x4D, 0x03, 0x73, 0x81, 0x9F, 0x73, 0x0B, 0xC0, 0xD0, 0x17, 0x10, 0x8A, 0x06, 0x30,
  0x10, 0xEC, 0x0D, 0x04, 0x50, 0x20, 0xBB, 0x01, 0x40, 0x30, 0xED, 0x83, 0xDA, 0x9A, 0xCC, 0x08,
  0x60, 0x20, 0xCF, 0xD0, 0x87, 0x20, 0x50, 0xCF, 0x90, 0xA0, 0x37, 0x58, 0x51, 0x46, 0x77, 0x64,
  0x60,
  // "Ċ" (U+010A)
  0x77, 0x18, 0x34, 0xCE, 0xD5, 0x77, 0x72, 0x03, 0xD0, 0x57, 0x77, 0x10, 0x7D, 0x0A, 0x77, 0x71,
  0x09, 0xD0, 0xB7, 0x77, 0x10, 0x7D, 0x0A, 0x77, 0x71, 0x03, 0xD0, 0x57, 0x77, 0x28, 0x34, 0xCE,
  0xD5, 0x80, 0xAC, 0x40, 0x86, 0x35, 0x67, 0x66, 0x41, 0x77, 0x38, 0x11, 0x6C, 0xFA, 0x81, 0xC7,
  0x17, 0x60, 0x70, 0xEF, 0xE0, 0xE0, 0x57, 0x30, 0x20, 0xCD, 0x84, 0xEB, 0x99, 0xBE, 0xE0, 0x77,
  0x10, 0x30, 0xEC, 0x0C, 0x04, 0x60, 0x8E, 0x04, 0x60, 0x20, 0xEC, 0x09, 0x72, 0x07, 0xD0, 0xB6,
  0x0D, 0xC0, 0xA7, 0x40, 0xBD, 0x50, 0x8C, 0x0E, 0x01, 0x74, 0x04, 0xD0, 0x13, 0x02, 0xD0, 0x77,
  0x60, 0xEB, 0x0E, 0x40, 0x9D, 0x01, 0x76, 0x0B, 0xB0, 0x73, 0x01, 0xD0, 0xA7, 0x78, 0x29, 0xFE,
  0x74, 0x06, 0xD0, 0x57, 0x70, 0x30, 0x46, 0x0B, 0xD0, 0x17, 0x77, 0x01, 0xD0, 0xE7, 0x77, 0x10,
  0x4D, 0x0A, 0x77, 0x71, 0x07, 0xD0, 0x87, 0x77, 0x10, 0xAD, 0x06, 0x77, 0x71, 0x0C, 0xD0, 0x47,
  0x77, 0x10, 0xED, 0x03, 0x77, 0x71, 0xE0, 0x27, 0x77, 0x1E, 0x02, 0x77, 0x70, 0x1E, 0x01, 0x77,
  0x70, 0x1E, 0x01, 0x77, 0x70, 0x1E, 0x01, 0x77, 0x71, 0xE0, 0x27, 0x77, 0x1E, 0x02, 0x77, 0x71,
  0x0E, 0xD0, 0x37, 0x77, 0x10, 0xCD, 0x04, 0x77, 0x71, 0x0A, 0xD0, 0x67, 0x77, 0x10, 0x7D, 0x08,
  0x77, 0x71, 0x04, 0xD0, 0xB7, 0x77, 0x10, 0x1D, 0x0E, 0x77, 0x72, 0x0C, 0xD0, 0x27, 0x77, 0x10,
  0x7D, 0x06, 0x77, 0x71, 0x02, 0xD0, 0xC7, 0x77, 0x20, 0xAD, 0x03, 0x77, 0x71, 0x03, 0xD0, 0x97,
  0x72, 0x04, 0x07, 0x50, 0xAD, 0x03, 0x77, 0x81, 0x2E, 0xD5, 0x01, 0x0E, 0xC0, 0xD0, 0x17, 0x58,
  0x22, 0xDF, 0xE6, 0x04, 0xD0, 0xC0, 0x17, 0x30, 0x30, 0xEA, 0x0A, 0x70, 0x5D, 0x81, 0xE7, 0x16,
  0x02, 0x08, 0xB0, 0xE0, 0x27, 0x10, 0x40, 0xEE, 0x84, 0xCA, 0x99, 0xAD, 0xC0, 0xE0, 0x47, 0x30,
  0x10, 0xBF, 0xF0, 0xC0, 0x27, 0x68, 0x13, 0x9E, 0xF9, 0x81, 0xEA, 0x47, 0x74, 0x86, 0x25, 0x67,
  0x76, 0x53, 0x71,
  // "ċ" (U+010B)
  0x73, 0x83, 0x4C, 0xED, 0x57, 0x72, 0x03, 0xD0, 0x57, 0x71, 0x07, 0xD0, 0xA7, 0x71, 0x09, 0xD0,
  0xB7, 0x71, 0x07, 0xD0, 0xA7, 0x71, 0x03, 0xD0, 0x57, 0x72, 0x83, 0x4C, 0xED, 0x58, 0x0A, 0xA0,
  0x08, 0x52, 0x56, 0x76, 0x52, 0x75, 0x81, 0x17, 0xDF, 0x81, 0xE9, 0x27, 0x10, 0x40, 0xEF, 0xD0,
  0x76, 0x05, 0xD8, 0x2E, 0xA9, 0xBE, 0x07, 0x40, 0x3D, 0x08, 0x40, 0x20, 0xDD, 0x01, 0x30, 0xDC,
  0x08, 0x60, 0x5D, 0x05, 0x20, 0x5C, 0x0D, 0x71, 0x0E, 0xC0, 0x72, 0x0C, 0xC0, 0x77, 0x10, 0xAC,
  0x81, 0x60, 0x2D, 0x01, 0x71, 0x08, 0xC8, 0x12, 0x06, 0xC0, 0xD7, 0x20, 0x7A, 0x0E, 0x05, 0x20,
  0xAC, 0x0A, 0x72, 0x81, 0x25, 0x34, 0x0D, 0xC0, 0x87, 0x72, 0x0E, 0xC0, 0x67, 0x71, 0x01, 0xD0,
  0x57, 0x71, 0x02, 0xD0, 0x47, 0x71, 0x02, 0xD0, 0x37, 0x71, 0x03, 0xD0, 0x37, 0x71, 0x03, 0xD0,
  0x37, 0x71, 0x03, 0xD0, 0x37, 0x71, 0x02, 0xD0, 0x47, 0x71, 0x01, 0xD0, 0x57, 0x72, 0x0E, 0xC0,
  0x77, 0x72, 0x0D, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0xB7, 0x72, 0x06, 0xD7, 0x72, 0x01, 0xD0, 0x47,
  0x72, 0x0B, 0xC0, 0xA7, 0x50, 0xC0, 0x22, 0x04, 0xD0, 0x37, 0x38, 0x19, 0xF7, 0x30, 0xBC, 0x0D,
  0x01, 0x71, 0x08, 0xA0, 0x63, 0x01, 0x0E, 0xC0, 0xD0, 0x45, 0x02, 0x0B, 0xB0, 0x14, 0x03, 0x0E,
  0xD8, 0x3D, 0xA9, 0xAC, 0xC0, 0x86, 0x02, 0x0C, 0xFD, 0x08, 0x72, 0x05, 0x0C, 0xF9, 0x0A, 0x03,
  0x75, 0x85, 0x14, 0x67, 0x76, 0x46,
  // "Č" (U+010C)
  0x71, 0x81, 0x47, 0x77, 0x38, 0x13, 0x77, 0x76, 0x07, 0xA0, 0xA7, 0x18, 0x24, 0xEF, 0xD7, 0x70,
  0xCA, 0x0A, 0x60, 0x40, 0xEA, 0x04, 0x77, 0x02, 0xB0, 0xA4, 0x03, 0x0E, 0xA0, 0x87, 0x72, 0x07,
  0xB0, 0x82, 0x02, 0x0E, 0xA0, 0xD7, 0x74, 0x0D, 0xB8, 0x16, 0x1D, 0xB0, 0x47, 0x74, 0x03, 0xC0,
  0xCB, 0x0A, 0x77, 0x60, 0x9F, 0x01, 0x77, 0x60, 0x1E, 0x08, 0x77, 0x71, 0x09, 0xD0, 0x18, 0x09,
  0xD2, 0x08, 0x63, 0x56, 0x76, 0x64, 0x17, 0x73, 0x81, 0x16, 0xCF, 0xA8, 0x1C, 0x71, 0x76, 0x07,
  0x0E, 0xFE, 0x0E, 0x05, 0x73, 0x02, 0x0C, 0xD8, 0x4E, 0xB9, 0x9B, 0xEE, 0x07, 0x71, 0x03, 0x0E,
  0xC0, 0xC0, 0x46, 0x08, 0xE0, 0x46, 0x02, 0x0E, 0xC0, 0x97, 0x20, 0x7D, 0x0B, 0x60, 0xDC, 0x0A,
  0x74, 0x0B, 0xD5, 0x08, 0xC0, 0xE0, 0x17, 0x40, 0x4D, 0x01, 0x30, 0x2D, 0x07, 0x76, 0x0E, 0xB0,
  0xE4, 0x09, 0xD0, 0x17, 0x60, 0xBB, 0x07, 0x30, 0x1D, 0x0A, 0x77, 0x82, 0x9F, 0xE7, 0x40, 0x6D,
  0x05, 0x77, 0x03, 0x04, 0x60, 0xBD, 0x01, 0x77, 0x70, 0x1D, 0x0E, 0x77, 0x71, 0x04, 0xD0, 0xA7,
  0x77, 0x10, 0x7D, 0x08, 0x77, 0x71, 0x0A, 0xD0, 0x67, 0x77, 0x10, 0xCD, 0x04, 0x77, 0x71, 0x0E,
  0xD0, 0x37, 0x77, 0x1E, 0x02, 0x77, 0x71, 0xE0, 0x27, 0x77, 0x01, 0xE0, 0x17, 0x77, 0x01, 0xE0,
  0x17, 0x77, 0x01, 0xE0, 0x17, 0x77, 0x1E, 0x02, 0x77, 0x71, 0xE0, 0x27, 0x77, 0x10, 0xED, 0x03,
  0x77, 0x71, 0x0C, 0xD0, 0x47, 0x77, 0x10, 0xAD, 0x06, 0x77, 0x71, 0x07, 0xD0, 0x87, 0x77, 0x10,
  0x4D, 0x0B, 0x77, 0x71, 0x01, 0xD0, 0xE7, 0x77, 0x20, 0xCD, 0x02, 0x77, 0x71, 0x07, 0xD0, 0x67,
  0x77, 0x10, 0x2D, 0x0C, 0x77, 0x72, 0x0A, 0xD0, 0x37, 0x77, 0x10, 0x3D, 0x09, 0x77, 0x20, 0x40,
  0x75, 0x0A, 0xD0, 0x37, 0x78, 0x12, 0xED, 0x50, 0x10, 0xEC, 0x0D, 0x01, 0x75, 0x82, 0x2D, 0xFE,
  0x60, 0x4D, 0x0C, 0x01, 0x73, 0x03, 0x0E, 0xA0, 0xA7, 0x05, 0xD8, 0x1E, 0x71, 0x60, 0x20, 0x8B,
  0x0E, 0x02, 0x71, 0x04, 0x0E, 0xE8, 0x4C, 0xA9, 0x9A, 0xDC, 0x0E, 0x04, 0x73, 0x01, 0x0B, 0xFF,
  0x0C, 0x02, 0x76, 0x81, 0x39, 0xEF, 0x98, 0x1E, 0xA4, 0x77, 0x48, 0x62, 0x56, 0x77, 0x65, 0x37,
  0x10,
  // "č" (U+010D)
  0x48, 0x14, 0x77, 0x73, 0x81, 0x37, 0x76, 0x07, 0xA0, 0xA7, 0x18, 0x24, 0xEF, 0xD7, 0x0C, 0xA0,
  0xA6, 0x04, 0x0E, 0xA0, 0x47, 0x02, 0xB0, 0xA4, 0x03, 0x0E, 0xA0, 0x87, 0x20, 0x7B, 0x08, 0x20,
  0x20, 0xEA, 0x0D, 0x74, 0x0D, 0xB8, 0x16, 0x1D, 0xB0, 0x47, 0x40, 0x3C, 0x0C, 0xB0, 0xA7, 0x60,
  0x9F, 0x01, 0x76, 0x01, 0xE0, 0x87, 0x71, 0x09, 0xD0, 0x18, 0x09, 0xC3, 0x08, 0x52, 0x56, 0x76,
  0x52, 0x75, 0x81, 0x17, 0xDF, 0x81, 0xE9, 0x27, 0x10, 0x40, 0xEF, 0xD0, 0x76, 0x05, 0xD8, 0x2E,
  0xA9, 0xBE, 0x07, 0x40, 0x3D, 0x08, 0x40, 0x20, 0xDD, 0x01, 0x30, 0xDC, 0x08, 0x60, 0x5D, 0x05,
  0x20, 0x5C, 0x0D, 0x71, 0x0E, 0xC0, 0x72, 0x0C, 0xC0, 0x77, 0x10, 0xAC, 0x81, 0x60, 0x2D, 0x01,
  0x71, 0x08, 0xC8, 0x12, 0x06, 0xC0, 0xD7, 0x20, 0x7A, 0x0E, 0x05, 0x20, 0xAC, 0x0A, 0x72, 0x81,
  0x25, 0x34, 0x0D, 0xC0, 0x87, 0x72, 0x0E, 0xC0, 0x67, 0x71, 0x01, 0xD0, 0x57, 0x71, 0x02, 0xD0,
  0x47, 0x71, 0x02, 0xD0, 0x37, 0x71, 0x03, 0xD0, 0x37, 0x71, 0x03, 0xD0, 0x37, 0x71, 0x03, 0xD0,
  0x37, 0x71, 0x02, 0xD0, 0x47, 0x71, 0x01, 0xD0, 0x57, 0x72, 0x0E, 0xC0, 0x77, 0x72, 0x0D, 0xC0,
  0x97, 0x72, 0x09, 0xC0, 0xB7, 0x72, 0x06, 0xD7, 0x72, 0x01, 0xD0, 0x47, 0x72, 0x0B, 0xC0, 0xA7,
  0x50, 0xC0, 0x22, 0x04, 0xD0, 0x37, 0x38, 0x19, 0xF7, 0x30, 0xBC, 0x0D, 0x01, 0x71, 0x08, 0xA0,
  0x63, 0x01, 0x0E, 0xC0, 0xD0, 0x45, 0x02, 0x0B, 0xB0, 0x14, 0x03, 0x0E, 0xD8, 0x3D, 0xA9, 0xAC,
  0xC0, 0x86, 0x02, 0x0C, 0xFD, 0x08, 0x72, 0x05, 0x0C, 0xF9, 0x0A, 0x03, 0x75, 0x85, 0x14, 0x67,
  0x76, 0x46,
  // "Ď" (U+010E)
  0x71, 0x81, 0x47, 0x77, 0x38, 0x13, 0x77, 0x77, 0x40, 0x7A, 0x0A, 0x71, 0x82, 0x4E, 0xFD, 0x77,
  0x50, 0xCA, 0x0A, 0x60, 0x40, 0xEA, 0x04, 0x77, 0x50, 0x2B, 0x0A, 0x40, 0x30, 0xEA, 0x08, 0x77,
  0x70, 0x7B, 0x08, 0x20, 0x20, 0xEA, 0x0D, 0x77, 0x72, 0x0D, 0xB8, 0x16, 0x1D, 0xB0, 0x47, 0x77,
  0x20, 0x3C, 0x0C, 0xB0, 0xA7, 0x77, 0x40, 0x9F, 0x01, 0x77, 0x74, 0x01, 0xE0, 0x87, 0x77, 0x60,
  0x9D, 0x01, 0x80, 0xAA, 0x20, 0x02, 0xFF, 0xB8, 0x3E, 0xC9, 0x61, 0x74, 0x02, 0xFF, 0xF9, 0x0B,
  0x03, 0x72, 0x82, 0x17, 0x8C, 0xF9, 0x80, 0x0E, 0xFA, 0x0A, 0x01, 0x74, 0x03, 0x0E, 0xD0, 0x65,
  0x82, 0x14, 0x9E, 0xD0, 0xE0, 0x37, 0x40, 0x9D, 0x06, 0x72, 0x09, 0xD0, 0xE0, 0x37, 0x30, 0x5D,
  0x06, 0x73, 0x05, 0xD0, 0xE0, 0x27, 0x20, 0x4D, 0x06, 0x74, 0x05, 0xD0, 0xC7, 0x20, 0x4D, 0x06,
  0x75, 0x09, 0xD0, 0x77, 0x10, 0x4D, 0x06, 0x75, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x04, 0xD0, 0x67,
  0x60, 0x8D, 0x07, 0x70, 0x4D, 0x06, 0x76, 0x02, 0xD0, 0xE7, 0x04, 0xD0, 0x67, 0x70, 0xCD, 0x04,
  0x60, 0x4D, 0x06, 0x77, 0x07, 0xD0, 0x86, 0x04, 0xD0, 0x67, 0x70, 0x4D, 0x0C, 0x60, 0x4D, 0x06,
  0x77, 0x01, 0xE6, 0x04, 0xD0, 0x67, 0x71, 0x0E, 0xD0, 0x35, 0x04, 0xD0, 0x67, 0x71, 0x0C, 0xD0,
  0x55, 0x04, 0xD0, 0x67, 0x71, 0x0A, 0xD0, 0x75, 0x04, 0xD0, 0x67, 0x71, 0x09, 0xD0, 0x85, 0x04,
  0xD0, 0x67, 0x71, 0x08, 0xD0, 0x95, 0x04, 0xD0, 0x67, 0x71, 0x08, 0xD0, 0xA5, 0x04, 0xD0, 0x67,
  0x71, 0x07, 0xD0, 0xA5, 0x04, 0xD0, 0x67, 0x71, 0x08, 0xD0, 0xA5, 0x04, 0xD0, 0x67, 0x71, 0x08,
  0xD0, 0x95, 0x04, 0xD0, 0x67, 0x71, 0x09, 0xD0, 0x85, 0x04, 0xD0, 0x67, 0x71, 0x0A, 0xD0, 0x75,
  0x04, 0xD0, 0x67, 0x71, 0x0C, 0xD0, 0x55, 0x04, 0xD0, 0x67, 0x71, 0x0E, 0xD0, 0x35, 0x04, 0xD0,
  0x67, 0x70, 0x1E, 0x60, 0x4D, 0x06, 0x77, 0x04, 0xD0, 0xC6, 0x04, 0xD0, 0x67, 0x70, 0x8D, 0x09,
  0x60, 0x4D, 0x06, 0x77, 0x0C, 0xD0, 0x46, 0x04, 0xD0, 0x67, 0x60, 0x2D, 0x0E, 0x70, 0x4D, 0x06,
  0x76, 0x09, 0xD0, 0x87, 0x04, 0xD0, 0x67, 0x50, 0x1E, 0x01, 0x70, 0x4D, 0x06, 0x75, 0x0A, 0xD0,
  0x87, 0x10, 0x4D, 0x06, 0x74, 0x07, 0xD0, 0xD7, 0x20, 0x6D, 0x06, 0x73, 0x07, 0xD0, 0xE0, 0x37,
  0x20, 0x9D, 0x06, 0x71, 0x02, 0x0A, 0xE0, 0x47, 0x20, 0x4E, 0x07, 0x80, 0x11, 0x81, 0x36, 0xBE,
  0x0E, 0x04, 0x68, 0x21, 0x89, 0xCF, 0xFF, 0x0B, 0x02, 0x70, 0x2F, 0xFF, 0x90, 0xC0, 0x57, 0x20,
  0x2F, 0xFA, 0x84, 0xED, 0xC9, 0x62, 0x74,
  // "ď" (U+010F)
  0x77, 0x09, 0xFA, 0x04, 0x30, 0x4C, 0x06, 0x77, 0x09, 0xFA, 0x04, 0x30, 0x7C, 0x02, 0x77, 0x09,
  0xFA, 0x04, 0x30, 0xAB, 0x0B, 0x77, 0x28, 0x12, 0x5B, 0xE0, 0x43, 0x0C, 0xB0, 0x57, 0x75, 0x09,
  0xD0, 0x43, 0xB0, 0xD7, 0x76, 0x03, 0xD0, 0x42, 0x02, 0xB0, 0x57, 0x77, 0xD0, 0x42, 0x05, 0xA0,
  0xD7, 0x77, 0x1D, 0x04, 0x20, 0x8A, 0x06, 0x77, 0x71, 0xD0, 0x42, 0x81, 0xBF, 0xD7, 0x77, 0x2D,
  0x04, 0x28, 0x1D, 0xF5, 0x77, 0x72, 0xD0, 0x47, 0x77, 0x7D, 0x04, 0x77, 0x77, 0xD0, 0x47, 0x73,
  0x84, 0x25, 0x67, 0x63, 0x5D, 0x04, 0x77, 0x10, 0x50, 0xCE, 0x0D, 0x05, 0x3D, 0x04, 0x77, 0x0A,
  0xFB, 0x08, 0x2D, 0x04, 0x76, 0x0B, 0xD8, 0x3D, 0xA9, 0xBE, 0xA8, 0x17, 0x0E, 0xC0, 0x47, 0x50,
  0x9D, 0x07, 0x40, 0x10, 0x8A, 0x02, 0x0D, 0xC0, 0x47, 0x40, 0x3D, 0x07, 0x78, 0x26, 0xFC, 0xDC,
  0x04, 0x74, 0x0A, 0xC0, 0xD7, 0x20, 0xCE, 0x04, 0x73, 0x01, 0xD0, 0x77, 0x20, 0x5E, 0x04, 0x73,
  0x05, 0xD0, 0x27, 0x30, 0xED, 0x04, 0x73, 0x09, 0xC0, 0xD7, 0x40, 0xBD, 0x04, 0x73, 0x0C, 0xC0,
  0xB7, 0x40, 0x8D, 0x04, 0x73, 0x0E, 0xC0, 0x87, 0x40, 0x5D, 0x04, 0x72, 0x01, 0xD0, 0x67, 0x40,
  0x3D, 0x04, 0x72, 0x02, 0xD0, 0x57, 0x40, 0x2D, 0x04, 0x72, 0x03, 0xD0, 0x47, 0x40, 0x1D, 0x04,
  0x72, 0x04, 0xD0, 0x47, 0x5D, 0x04, 0x72, 0x04, 0xD0, 0x37, 0x5D, 0x04, 0x72, 0x04, 0xD0, 0x37,
  0x5D, 0x04, 0x72, 0x04, 0xD0, 0x37, 0x5D, 0x04, 0x72, 0x03, 0xD0, 0x47, 0x40, 0x1D, 0x04, 0x72,
  0x02, 0xD0, 0x57, 0x40, 0x2D, 0x04, 0x72, 0x01, 0xD0, 0x67, 0x40, 0x4D, 0x04, 0x73, 0x0E, 0xC0,
  0x87, 0x40, 0x5D, 0x04, 0x73, 0x0C, 0xC0, 0xA7, 0x40, 0x8D, 0x04, 0x73, 0x09, 0xC0, 0xD7, 0x40,
  0xBD, 0x04, 0x73, 0x05, 0xD0, 0x17, 0x20, 0x1E, 0x04, 0x73, 0x01, 0xD0, 0x67, 0x20, 0x6E, 0x05,
  0x74, 0x0A, 0xC0, 0xC7, 0x28, 0x1D, 0xFE, 0xC0, 0x77, 0x40, 0x3D, 0x07, 0x78, 0x28, 0xFB, 0xAC,
  0x0D, 0x75, 0x09, 0xD0, 0x74, 0x01, 0x09, 0xA0, 0x20, 0x8D, 0x82, 0xC5, 0x21, 0x72, 0x0C, 0xD8,
  0x3D, 0xA9, 0xBE, 0xA8, 0x16, 0x07, 0xF9, 0x0D, 0x72, 0x01, 0x0B, 0xFB, 0x07, 0x20, 0x5F, 0x90,
  0xD7, 0x40, 0x60, 0xCE, 0x0C, 0x04, 0x30, 0x3F, 0x90, 0xD7, 0x68, 0x42, 0x56, 0x76, 0x27, 0x76,
  // "Đ" (U+0110)
  0x02, 0xFF, 0xB8, 0x3E, 0xC9, 0x61, 0x74, 0x02, 0xFF, 0xF9, 0x0B, 0x04, 0x72, 0x82, 0x17, 0x8B,
  0xF9, 0x80, 0x0E, 0xFA, 0x0B, 0x01, 0x74, 0x03, 0x0E, 0xD0, 0x65, 0x82, 0x14, 0x9E, 0xD0, 0xE0,
  0x37, 0x40, 0x8D, 0x06, 0x72, 0x09, 0xD0, 0xE0, 0x37, 0x30, 0x4D, 0x06, 0x73, 0x05, 0xD0, 0xE0,
  0x27, 0x20, 0x3D, 0x06, 0x74, 0x05, 0xD0, 0xC7, 0x20, 0x3D, 0x06, 0x75, 0x09, 0xD0, 0x77, 0x10,
  0x3D, 0x06, 0x75, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x03, 0xD0, 0x67, 0x60, 0x8D, 0x07, 0x70, 0x3D,
  0x06, 0x76, 0x02, 0xD0, 0xE7, 0x03, 0xD0, 0x67, 0x70, 0xCD, 0x04, 0x60, 0x3D, 0x06, 0x77, 0x07,
  0xD0, 0x96, 0x03, 0xD0, 0x67, 0x70, 0x4D, 0x0C, 0x60, 0x3D, 0x06, 0x77, 0x01, 0xE6, 0x03, 0xD0,
  0x67, 0x71, 0x0E, 0xD0, 0x35, 0x03, 0xD0, 0x67, 0x71, 0x0C, 0xD0, 0x55, 0x03, 0xD0, 0x67, 0x71,
  0x0A, 0xD8, 0x57, 0x01, 0x11, 0x14, 0xD0, 0x78, 0x03, 0x17, 0x10, 0x9D, 0x08, 0x1F, 0xFC, 0x0A,
  0x70, 0x8D, 0x09, 0x1F, 0xFC, 0x0A, 0x70, 0x8D, 0x0A, 0x1F, 0xFC, 0x0A, 0x70, 0x7D, 0x0A, 0x50,
  0x3D, 0x06, 0x77, 0x10, 0x8D, 0x0A, 0x50, 0x3D, 0x06, 0x77, 0x10, 0x8D, 0x09, 0x50, 0x3D, 0x06,
  0x77, 0x10, 0x9D, 0x08, 0x50, 0x3D, 0x06, 0x77, 0x10, 0xAD, 0x07, 0x50, 0x3D, 0x06, 0x77, 0x10,
  0xCD, 0x05, 0x50, 0x3D, 0x06, 0x77, 0x10, 0xED, 0x03, 0x50, 0x3D, 0x06, 0x77, 0x01, 0xE6, 0x03,
  0xD0, 0x67, 0x70, 0x4D, 0x0C, 0x60, 0x3D, 0x06, 0x77, 0x08, 0xD0, 0x96, 0x03, 0xD0, 0x67, 0x70,
  0xCD, 0x04, 0x60, 0x3D, 0x06, 0x76, 0x02, 0xD0, 0xE7, 0x03, 0xD0, 0x67, 0x60, 0x9D, 0x08, 0x70,
  0x3D, 0x06, 0x75, 0x01, 0xE0, 0x17, 0x03, 0xD0, 0x67, 0x50, 0xAD, 0x08, 0x71, 0x03, 0xD0, 0x67,
  0x40, 0x7D, 0x0D, 0x72, 0x05, 0xD0, 0x67, 0x30, 0x7D, 0x0E, 0x03, 0x72, 0x08, 0xD0, 0x67, 0x10,
  0x20, 0xAE, 0x04, 0x72, 0x04, 0x0E, 0xD0, 0x78, 0x01, 0x18, 0x13, 0x6A, 0xE0, 0xE0, 0x46, 0x82,
  0x18, 0x9C, 0xFF, 0xF0, 0xB0, 0x27, 0x02, 0xFF, 0xF9, 0x0C, 0x05, 0x72, 0x02, 0xFF, 0xA8, 0x4E,
  0xDC, 0x96, 0x27, 0x40,
  // "đ" (U+0111)
  0x77, 0x09, 0xFA, 0x04, 0x77, 0x40, 0x9F, 0xA0, 0x47, 0x74, 0x09, 0xFA, 0x04, 0x77, 0x58, 0x12,
  0x49, 0xE0, 0x47, 0x77, 0x10, 0x7D, 0x04, 0x77, 0x71, 0x01, 0xD0, 0x47, 0x77, 0x2D, 0x04, 0x77,
  0x09, 0xFF, 0xB0, 0xD7, 0x30, 0x9F, 0xFB, 0x0D, 0x73, 0x09, 0xFF, 0xB0, 0xD7, 0x48, 0x04, 0x1D,
  0x05, 0x80, 0x01, 0x77, 0x5D, 0x04, 0x77, 0x72, 0xD0, 0x47, 0x77, 0x2D, 0x04, 0x74, 0x86, 0x49,
  0xCE, 0xFE, 0xB6, 0x4D, 0x04, 0x72, 0x03, 0x0D, 0xF9, 0x0D, 0x02, 0x20, 0xEC, 0x04, 0x71, 0x05,
  0xFC, 0x82, 0xE2, 0x0E, 0xC0, 0x47, 0x03, 0xD8, 0x91, 0xD6, 0x21, 0x38, 0xEF, 0xD0, 0xDC, 0x04,
  0x70, 0xDC, 0x0C, 0x01, 0x58, 0x31, 0xDF, 0x8D, 0xC0, 0x46, 0x07, 0xD0, 0x27, 0x02, 0xF0, 0x46,
  0x0D, 0xC0, 0x97, 0x20, 0x8E, 0x04, 0x50, 0x3D, 0x04, 0x72, 0x02, 0xE0, 0x45, 0x07, 0xC0, 0xE7,
  0x40, 0xDD, 0x04, 0x50, 0xBC, 0x0C, 0x74, 0x09, 0xD0, 0x45, 0x0D, 0xC0, 0x97, 0x40, 0x6D, 0x04,
  0x5D, 0x07, 0x74, 0x04, 0xD0, 0x44, 0x02, 0xD0, 0x57, 0x40, 0x3D, 0x04, 0x40, 0x3D, 0x04, 0x74,
  0x01, 0xD0, 0x44, 0x04, 0xD0, 0x47, 0x40, 0x1D, 0x04, 0x40, 0x4D, 0x03, 0x75, 0xD0, 0x44, 0x04,
  0xD0, 0x37, 0x5D, 0x04, 0x40, 0x4D, 0x03, 0x75, 0xD0, 0x44, 0x03, 0xD0, 0x47, 0x40, 0x1D, 0x04,
  0x40, 0x2D, 0x04, 0x74, 0x01, 0xD0, 0x44, 0x01, 0xD0, 0x67, 0x40, 0x3D, 0x04, 0x5D, 0x07, 0x74,
  0x05, 0xD0, 0x45, 0x0C, 0xC0, 0xA7, 0x40, 0x7D, 0x04, 0x50, 0x9C, 0x0D, 0x74, 0x0A, 0xD0, 0x45,
  0x06, 0xD0, 0x17, 0x30, 0xED, 0x04, 0x50, 0x1D, 0x06, 0x72, 0x04, 0xE0, 0x56, 0x0B, 0xC0, 0xC7,
  0x28, 0x1B, 0xFE, 0xC0, 0x76, 0x03, 0xD0, 0x67, 0x82, 0x6F, 0xAA, 0xC0, 0xC7, 0x09, 0xD0, 0x75,
  0x83, 0x7F, 0xE2, 0x8D, 0x82, 0xC5, 0x21, 0x40, 0xCD, 0x83, 0xDA, 0x9B, 0xEA, 0x81, 0x50, 0x7F,
  0x90, 0xD4, 0x01, 0x0B, 0xFB, 0x07, 0x20, 0x5F, 0x90, 0xD6, 0x05, 0x0C, 0xE0, 0xC0, 0x43, 0x03,
  0xF9, 0x0D, 0x71, 0x84, 0x25, 0x67, 0x63, 0x77, 0x10,
  // "Ē" (U+0112)
  0x72, 0x80, 0x92, 0x17, 0x71, 0x09, 0xFF, 0x03, 0x77, 0x09, 0xFF, 0x03, 0x77, 0x09, 0xFF, 0x03,
  0x80, 0x9F, 0x20, 0x02, 0xFF, 0xFD, 0x02, 0x20, 0x2F, 0xFF, 0xD0, 0x22, 0x82, 0x17, 0x8B, 0xF9,
  0x80, 0x4E, 0xF0, 0x36, 0x03, 0x0E, 0xD0, 0x67, 0x20, 0x30, 0xCC, 0x03, 0x70, 0x9D, 0x06, 0x74,
  0x0D, 0xB0, 0x47, 0x05, 0xD0, 0x67, 0x40, 0x5B, 0x04, 0x70, 0x4D, 0x06, 0x75, 0xB0, 0x57, 0x04,
  0xD0, 0x67, 0x50, 0xCA, 0x05, 0x70, 0x4D, 0x06, 0x75, 0x0A, 0xA0, 0x57, 0x04, 0xD0, 0x67, 0x50,
  0x8A, 0x06, 0x70, 0x4D, 0x06, 0x75, 0x82, 0x36, 0x62, 0x70, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0,
  0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72,
  0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x78, 0x07, 0x17, 0x50, 0x4F,
  0xFB, 0x0A, 0x74, 0x04, 0xFF, 0xB0, 0xA7, 0x40, 0x4F, 0xFB, 0x0A, 0x74, 0x04, 0xD0, 0x67, 0x77,
  0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0,
  0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72,
  0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x78, 0x15, 0x77, 0x60,
  0x4D, 0x06, 0x77, 0x0D, 0xA0, 0x15, 0x04, 0xD0, 0x67, 0x7B, 0x60, 0x4D, 0x06, 0x76, 0x02, 0xB6,
  0x04, 0xD0, 0x67, 0x60, 0x6B, 0x60, 0x5D, 0x06, 0x76, 0x0D, 0xA0, 0xE6, 0x08, 0xD0, 0x67, 0x50,
  0x7B, 0x0E, 0x50, 0x20, 0xED, 0x06, 0x73, 0x02, 0x08, 0xC8, 0x4D, 0x01, 0x78, 0xBF, 0x98, 0x05,
  0xEF, 0x81, 0xD0, 0x2F, 0xFF, 0xE8, 0x1C, 0x02, 0xFF, 0xFE, 0x0C, 0x10,
  // "ē" (U+0113)
  0x68, 0x09, 0x21, 0x72, 0x09, 0xFF, 0x03, 0x71, 0x09, 0xFF, 0x03, 0x71, 0x09, 0xFF, 0x03, 0x80,
  0x9D, 0x00, 0x84, 0x25, 0x77, 0x64, 0x77, 0x20, 0x70, 0xDF, 0x0B, 0x03, 0x74, 0x03, 0x0D, 0xFC,
  0x09, 0x72, 0x03, 0x0E, 0xC8, 0x2E, 0xA9, 0xBD, 0x0B, 0x70, 0x10, 0xEC, 0x08, 0x40, 0x10, 0xCC,
  0x09, 0x60, 0xBC, 0x08, 0x60, 0x10, 0xEC, 0x03, 0x40, 0x4C, 0x0D, 0x71, 0x06, 0xC0, 0xC4, 0x0B,
  0xC0, 0x67, 0x10, 0x1D, 0x02, 0x20, 0x1D, 0x01, 0x72, 0x0C, 0xC0, 0x72, 0x05, 0xC0, 0xC7, 0x30,
  0x8C, 0x0B, 0x20, 0x9C, 0x09, 0x73, 0x06, 0xC0, 0xE2, 0x0C, 0xC0, 0x77, 0x30, 0x4D, 0x81, 0x10,
  0xEC, 0x05, 0x73, 0x03, 0xD0, 0x21, 0xD0, 0x58, 0x06, 0x10, 0x4D, 0x03, 0x02, 0xFF, 0xF9, 0x00,
  0x3F, 0xFF, 0x90, 0x40, 0x3F, 0xFF, 0x90, 0x40, 0x3D, 0x03, 0x77, 0x30, 0x2D, 0x04, 0x77, 0x30,
  0x1D, 0x05, 0x77, 0x4D, 0x06, 0x77, 0x40, 0xEC, 0x08, 0x77, 0x40, 0xBC, 0x0A, 0x77, 0x40, 0x8C,
  0x0D, 0x77, 0x40, 0x4D, 0x02, 0x77, 0x40, 0xEC, 0x07, 0x76, 0x01, 0x40, 0x9C, 0x0D, 0x75, 0x07,
  0x0D, 0x40, 0x2D, 0x07, 0x73, 0x03, 0xA0, 0x34, 0x08, 0xD0, 0x47, 0x10, 0x30, 0xEA, 0x01, 0x50,
  0xCD, 0x08, 0x01, 0x50, 0x70, 0xEA, 0x0A, 0x60, 0x10, 0xDE, 0x83, 0xB9, 0x9B, 0xEB, 0x0D, 0x01,
  0x70, 0x10, 0xBF, 0xD0, 0xB0, 0x17, 0x30, 0x40, 0xBF, 0x90, 0xC0, 0x57, 0x78, 0x61, 0x46, 0x77,
  0x64, 0x17,
  // "Ĕ" (U+0114)
  0x70, 0x8A, 0x01, 0x71, 0x08, 0xA7, 0x71, 0x07, 0xA0, 0x67, 0x18, 0x1D, 0xFE, 0x77, 0x10, 0x3A,
  0x0E, 0x02, 0x60, 0x8A, 0x0B, 0x77, 0x20, 0xEA, 0x85, 0xE7, 0x20, 0x14, 0xBB, 0x06, 0x77, 0x20,
  0x7F, 0xC0, 0xE7, 0x74, 0x0C, 0xFB, 0x05, 0x77, 0x40, 0x10, 0xCF, 0x90, 0x67, 0x77, 0x86, 0x5A,
  0xDF, 0xEC, 0x82, 0x80, 0x9F, 0x70, 0x02, 0xFF, 0xFD, 0x02, 0x20, 0x2F, 0xFF, 0xD0, 0x22, 0x82,
  0x17, 0x8B, 0xF9, 0x80, 0x4E, 0xF0, 0x36, 0x03, 0x0E, 0xD0, 0x67, 0x20, 0x30, 0xCC, 0x03, 0x70,
  0x9D, 0x06, 0x74, 0x0D, 0xB0, 0x47, 0x05, 0xD0, 0x67, 0x40, 0x5B, 0x04, 0x70, 0x4D, 0x06, 0x75,
  0xB0, 0x57, 0x04, 0xD0, 0x67, 0x50, 0xCA, 0x05, 0x70, 0x4D, 0x06, 0x75, 0x0A, 0xA0, 0x57, 0x04,
  0xD0, 0x67, 0x50, 0x8A, 0x06, 0x70, 0x4D, 0x06, 0x75, 0x82, 0x36, 0x62, 0x70, 0x4D, 0x06, 0x77,
  0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D,
  0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x78, 0x07,
  0x17, 0x50, 0x4F, 0xFB, 0x0A, 0x74, 0x04, 0xFF, 0xB0, 0xA7, 0x40, 0x4F, 0xFB, 0x0A, 0x74, 0x04,
  0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77,
  0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D,
  0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x78,
  0x15, 0x77, 0x60, 0x4D, 0x06, 0x77, 0x0D, 0xA0, 0x15, 0x04, 0xD0, 0x67, 0x7B, 0x60, 0x4D, 0x06,
  0x76, 0x02, 0xB6, 0x04, 0xD0, 0x67, 0x60, 0x6B, 0x60, 0x5D, 0x06, 0x76, 0x0D, 0xA0, 0xE6, 0x08,
  0xD0, 0x67, 0x50, 0x7B, 0x0E, 0x50, 0x20, 0xED, 0x06, 0x73, 0x02, 0x08, 0xC8, 0x4D, 0x01, 0x78,
  0xBF, 0x98, 0x05, 0xEF, 0x81, 0xD0, 0x2F, 0xFF, 0xE8, 0x1C, 0x02, 0xFF, 0xFE, 0x0C, 0x10,
  // "ĕ" (U+0115)
  0x50, 0x8A, 0x01, 0x71, 0x08, 0xA7, 0x20, 0x7A, 0x06, 0x71, 0x81, 0xDF, 0xE7, 0x20, 0x3A, 0x0E,
  0x02, 0x60, 0x8A, 0x0B, 0x73, 0x0E, 0xA8, 0x5E, 0x72, 0x01, 0x4B, 0xB0, 0x67, 0x30, 0x7F, 0xC0,
  0xE7, 0x50, 0xCF, 0xB0, 0x57, 0x50, 0x10, 0xCF, 0x90, 0x67, 0x71, 0x86, 0x5A, 0xDF, 0xEC, 0x82,
  0x80, 0x9D, 0x40, 0x84, 0x25, 0x77, 0x64, 0x77, 0x20, 0x70, 0xDF, 0x0B, 0x03, 0x74, 0x03, 0x0D,
  0xFC, 0x09, 0x72, 0x03, 0x0E, 0xC8, 0x2E, 0xA9, 0xBD, 0x0B, 0x70, 0x10, 0xEC, 0x08, 0x40, 0x10,
  0xCC, 0x09, 0x60, 0xBC, 0x08, 0x60, 0x10, 0xEC, 0x03, 0x40, 0x4C, 0x0D, 0x71, 0x06, 0xC0, 0xC4,
  0x0B, 0xC0, 0x67, 0x10, 0x1D, 0x02, 0x20, 0x1D, 0x01, 0x72, 0x0C, 0xC0, 0x72, 0x05, 0xC0, 0xC7,
  0x30, 0x8C, 0x0B, 0x20, 0x9C, 0x09, 0x73, 0x06, 0xC0, 0xE2, 0x0C, 0xC0, 0x77, 0x30, 0x4D, 0x81,
  0x10, 0xEC, 0x05, 0x73, 0x03, 0xD0, 0x21, 0xD0, 0x58, 0x06, 0x10, 0x4D, 0x03, 0x02, 0xFF, 0xF9,
  0x00, 0x3F, 0xFF, 0x90, 0x40, 0x3F, 0xFF, 0x90, 0x40, 0x3D, 0x03, 0x77, 0x30, 0x2D, 0x04, 0x77,
  0x30, 0x1D, 0x05, 0x77, 0x4D, 0x06, 0x77, 0x40, 0xEC, 0x08, 0x77, 0x40, 0xBC, 0x0A, 0x77, 0x40,
  0x8C, 0x0D, 0x77, 0x40, 0x4D, 0x02, 0x77, 0x40, 0xEC, 0x07, 0x76, 0x01, 0x40, 0x9C, 0x0D, 0x75,
  0x07, 0x0D, 0x40, 0x2D, 0x07, 0x73, 0x03, 0xA0, 0x34, 0x08, 0xD0, 0x47, 0x10, 0x30, 0xEA, 0x01,
  0x50, 0xCD, 0x08, 0x01, 0x50, 0x70, 0xEA, 0x0A, 0x60, 0x10, 0xDE, 0x83, 0xB9, 0x9B, 0xEB, 0x0D,
  0x01, 0x70, 0x10, 0xBF, 0xD0, 0xB0, 0x17, 0x30, 0x40, 0xBF, 0x90, 0xC0, 0x57, 0x78, 0x61, 0x46,
  0x77, 0x64, 0x17,
  // "Ė" (U+0116)
  0x76, 0x83, 0x4C, 0xED, 0x57, 0x77, 0x30, 0x3D, 0x05, 0x77, 0x72, 0x07, 0xD0, 0xA7, 0x77, 0x20,
  0x9D, 0x0B, 0x77, 0x72, 0x07, 0xD0, 0xA7, 0x77, 0x20, 0x3D, 0x05, 0x77, 0x73, 0x83, 0x4C, 0xED,
  0x58, 0x0A, 0xB6, 0x00, 0x2F, 0xFF, 0xD0, 0x22, 0x02, 0xFF, 0xFD, 0x02, 0x28, 0x21, 0x78, 0xBF,
  0x98, 0x04, 0xEF, 0x03, 0x60, 0x30, 0xED, 0x06, 0x72, 0x03, 0x0C, 0xC0, 0x37, 0x09, 0xD0, 0x67,
  0x40, 0xDB, 0x04, 0x70, 0x5D, 0x06, 0x74, 0x05, 0xB0, 0x47, 0x04, 0xD0, 0x67, 0x5B, 0x05, 0x70,
  0x4D, 0x06, 0x75, 0x0C, 0xA0, 0x57, 0x04, 0xD0, 0x67, 0x50, 0xAA, 0x05, 0x70, 0x4D, 0x06, 0x75,
  0x08, 0xA0, 0x67, 0x04, 0xD0, 0x67, 0x58, 0x23, 0x66, 0x27, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D,
  0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77,
  0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x07, 0x80, 0x71, 0x75, 0x04,
  0xFF, 0xB0, 0xA7, 0x40, 0x4F, 0xFB, 0x0A, 0x74, 0x04, 0xFF, 0xB0, 0xA7, 0x40, 0x4D, 0x06, 0x77,
  0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D,
  0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77,
  0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x81, 0x57, 0x76,
  0x04, 0xD0, 0x67, 0x70, 0xDA, 0x01, 0x50, 0x4D, 0x06, 0x77, 0xB6, 0x04, 0xD0, 0x67, 0x60, 0x2B,
  0x60, 0x4D, 0x06, 0x76, 0x06, 0xB6, 0x05, 0xD0, 0x67, 0x60, 0xDA, 0x0E, 0x60, 0x8D, 0x06, 0x75,
  0x07, 0xB0, 0xE5, 0x02, 0x0E, 0xD0, 0x67, 0x30, 0x20, 0x8C, 0x84, 0xD0, 0x17, 0x8B, 0xF9, 0x80,
  0x5E, 0xF8, 0x1D, 0x02, 0xFF, 0xFE, 0x81, 0xC0, 0x2F, 0xFF, 0xE0, 0xC1,
  // "ė" (U+0117)
  0x73, 0x83, 0x4C, 0xED, 0x57, 0x74, 0x03, 0xD0, 0x57, 0x73, 0x07, 0xD0, 0xA7, 0x73, 0x09, 0xD0,
  0xB7, 0x73, 0x07, 0xD0, 0xA7, 0x73, 0x03, 0xD0, 0x57, 0x74, 0x83, 0x4C, 0xED, 0x58, 0x0A, 0xB6,
  0x08, 0x42, 0x57, 0x76, 0x47, 0x72, 0x07, 0x0D, 0xF0, 0xB0, 0x37, 0x40, 0x30, 0xDF, 0xC0, 0x97,
  0x20, 0x30, 0xEC, 0x82, 0xEA, 0x9B, 0xD0, 0xB7, 0x01, 0x0E, 0xC0, 0x84, 0x01, 0x0C, 0xC0, 0x96,
  0x0B, 0xC0, 0x86, 0x01, 0x0E, 0xC0, 0x34, 0x04, 0xC0, 0xD7, 0x10, 0x6C, 0x0C, 0x40, 0xBC, 0x06,
  0x71, 0x01, 0xD0, 0x22, 0x01, 0xD0, 0x17, 0x20, 0xCC, 0x07, 0x20, 0x5C, 0x0C, 0x73, 0x08, 0xC0,
  0xB2, 0x09, 0xC0, 0x97, 0x30, 0x6C, 0x0E, 0x20, 0xCC, 0x07, 0x73, 0x04, 0xD8, 0x11, 0x0E, 0xC0,
  0x57, 0x30, 0x3D, 0x02, 0x1D, 0x05, 0x80, 0x61, 0x04, 0xD0, 0x30, 0x2F, 0xFF, 0x90, 0x03, 0xFF,
  0xF9, 0x04, 0x03, 0xFF, 0xF9, 0x04, 0x03, 0xD0, 0x37, 0x73, 0x02, 0xD0, 0x47, 0x73, 0x01, 0xD0,
  0x57, 0x74, 0xD0, 0x67, 0x74, 0x0E, 0xC0, 0x87, 0x74, 0x0B, 0xC0, 0xA7, 0x74, 0x08, 0xC0, 0xD7,
  0x74, 0x04, 0xD0, 0x27, 0x74, 0x0E, 0xC0, 0x77, 0x60, 0x14, 0x09, 0xC0, 0xD7, 0x50, 0x70, 0xD4,
  0x02, 0xD0, 0x77, 0x30, 0x3A, 0x03, 0x40, 0x8D, 0x04, 0x71, 0x03, 0x0E, 0xA0, 0x15, 0x0C, 0xD0,
  0x80, 0x15, 0x07, 0x0E, 0xA0, 0xA6, 0x01, 0x0D, 0xE8, 0x3B, 0x99, 0xBE, 0xB0, 0xD0, 0x17, 0x01,
  0x0B, 0xFD, 0x0B, 0x01, 0x73, 0x04, 0x0B, 0xF9, 0x0C, 0x05, 0x77, 0x86, 0x14, 0x67, 0x76, 0x41,
  0x70,
  // "Ę" (U+0118)
  0x02, 0xFF, 0xFD, 0x02, 0x20, 0x2F, 0xFF, 0xD0, 0x22, 0x82, 0x17, 0x8B, 0xF9, 0x80, 0x4E, 0xF0,
  0x36, 0x03, 0x0E, 0xD0, 0x67, 0x20, 0x30, 0xCC, 0x03, 0x70, 0x9D, 0x06, 0x74, 0x0D, 0xB0, 0x47,
  0x05, 0xD0, 0x67, 0x40, 0x5B, 0x04, 0x70, 0x4D, 0x06, 0x75, 0xB0, 0x57, 0x04, 0xD0, 0x67, 0x50,
  0xCA, 0x05, 0x70, 0x4D, 0x06, 0x75, 0x0A, 0xA0, 0x57, 0x04, 0xD0, 0x67, 0x50, 0x8A, 0x06, 0x70,
  0x4D, 0x06, 0x75, 0x82, 0x36, 0x62, 0x70, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20,
  0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67,
  0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x78, 0x07, 0x17, 0x50, 0x4F, 0xFB, 0x0A, 0x74,
  0x04, 0xFF, 0xB0, 0xA7, 0x40, 0x4F, 0xFB, 0x0A, 0x74, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06,
  0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20,
  0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67,
  0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x78, 0x15, 0x77, 0x60, 0x4D, 0x06, 0x77,
  0x0D, 0xA0, 0x15, 0x04, 0xD0, 0x67, 0x7B, 0x60, 0x4D, 0x06, 0x76, 0x02, 0xB6, 0x04, 0xD0, 0x67,
  0x60, 0x6B, 0x60, 0x5D, 0x06, 0x76, 0x0D, 0xA0, 0xE6, 0x08, 0xD0, 0x67, 0x50, 0x7B, 0x0E, 0x50,
  0x20, 0xED, 0x06, 0x73, 0x02, 0x08, 0xC8, 0x4D, 0x01, 0x78, 0xBF, 0x98, 0x05, 0xEF, 0x81, 0xD0,
  0x2F, 0xFF, 0xE8, 0x1C, 0x02, 0xFF, 0xFE, 0x0C, 0x77, 0x70, 0x9A, 0x0B, 0x01, 0x77, 0x72, 0x01,
  0x0C, 0xA0, 0xA7, 0x77, 0x40, 0xCA, 0x0C, 0x77, 0x74, 0x07, 0xB0, 0x57, 0x77, 0x40, 0xEB, 0x77,
  0x74, 0x04, 0xB0, 0xD7, 0x77, 0x40, 0x6B, 0x0C, 0x77, 0x74, 0x07, 0xB0, 0xE7, 0x77, 0x40, 0x6C,
  0x05, 0x77, 0x73, 0x04, 0xC8, 0x5E, 0x72, 0x01, 0x33, 0x77, 0x50, 0xEF, 0xA0, 0x97, 0x75, 0x06,
  0xFA, 0x09, 0x77, 0x60, 0x7F, 0x90, 0x87, 0x77, 0x86, 0x28, 0xCE, 0xFE, 0xB6, 0x30,
  // "ę" (U+0119)
  0x72, 0x84, 0x25, 0x77, 0x64, 0x77, 0x20, 0x70, 0xDF, 0x0B, 0x03, 0x74, 0x03, 0x0D, 0xFC, 0x09,
  0x72, 0x03, 0x0E, 0xC8, 0x2E, 0xA9, 0xBD, 0x0A, 0x70, 0x10, 0xEC, 0x08, 0x40, 0x10, 0xCC, 0x09,
  0x60, 0xBC, 0x08, 0x60, 0x10, 0xEC, 0x03, 0x40, 0x4C, 0x0D, 0x71, 0x07, 0xC0, 0xB4, 0x0B, 0xC0,
  0x67, 0x10, 0x1D, 0x02, 0x20, 0x1D, 0x01, 0x72, 0x0C, 0xC0, 0x72, 0x05, 0xC0, 0xC7, 0x30, 0x9C,
  0x0B, 0x20, 0x9C, 0x09, 0x73, 0x06, 0xC0, 0xE2, 0x0C, 0xC0, 0x77, 0x30, 0x4D, 0x81, 0x10, 0xEC,
  0x06, 0x73, 0x04, 0xD0, 0x21, 0xD0, 0x47, 0x30, 0x3D, 0x03, 0x02, 0xFF, 0xF9, 0x00, 0x3F, 0xFF,
  0x90, 0x40, 0x3F, 0xFF, 0x90, 0x40, 0x3D, 0x04, 0x80, 0x94, 0x11, 0x02, 0xD0, 0x47, 0x73, 0x01,
  0xD0, 0x57, 0x74, 0xD0, 0x67, 0x74, 0x0E, 0xC0, 0x87, 0x74, 0x0B, 0xC0, 0xA7, 0x74, 0x08, 0xC0,
  0xD7, 0x74, 0x04, 0xD0, 0x27, 0x74, 0x0E, 0xC0, 0x77, 0x60, 0x14, 0x09, 0xC0, 0xD7, 0x50, 0x70,
  0xD4, 0x02, 0xD0, 0x77, 0x30, 0x3A, 0x03, 0x40, 0x8D, 0x04, 0x71, 0x03, 0x0E, 0xA0, 0x15, 0x0C,
  0xD0, 0x70, 0x15, 0x07, 0x0E, 0xA0, 0xB6, 0x01, 0x0D, 0xE8, 0x3B, 0x99, 0xBE, 0xB0, 0xE0, 0x27,
  0x01, 0x0B, 0xFD, 0x0D, 0x02, 0x73, 0x04, 0x0B, 0xFA, 0x07, 0x77, 0x83, 0x14, 0x67, 0x8B, 0x05,
  0x77, 0x40, 0x10, 0xCA, 0x05, 0x77, 0x50, 0xBA, 0x0A, 0x77, 0x50, 0x7B, 0x01, 0x77, 0x50, 0xEA,
  0x0B, 0x77, 0x50, 0x5B, 0x08, 0x77, 0x50, 0x8B, 0x06, 0x77, 0x50, 0x9B, 0x06, 0x77, 0x50, 0x9B,
  0x08, 0x77, 0x50, 0x6B, 0x0D, 0x77, 0x50, 0x2C, 0x84, 0xC4, 0x12, 0x48, 0x77, 0x0A, 0xFA, 0x77,
  0x10, 0xBF, 0x97, 0x72, 0x86, 0x4A, 0xDE, 0xFD, 0xA6, 0x30,
  // "Ě" (U+011A)
  0x78, 0x14, 0x77, 0x73, 0x81, 0x37, 0x77, 0x70, 0x7A, 0x0A, 0x71, 0x82, 0x4E, 0xFD, 0x77, 0x10,
  0xCA, 0x0A, 0x60, 0x40, 0xEA, 0x04, 0x77, 0x10, 0x2B, 0x0A, 0x40, 0x30, 0xEA, 0x08, 0x77, 0x30,
  0x7B, 0x08, 0x20, 0x20, 0xEA, 0x0D, 0x77, 0x50, 0xDB, 0x81, 0x61, 0xDB, 0x04, 0x77, 0x50, 0x3C,
  0x0C, 0xB0, 0xA7, 0x77, 0x09, 0xF0, 0x17, 0x77, 0x01, 0xE0, 0x87, 0x77, 0x20, 0x9D, 0x01, 0x80,
  0x9F, 0x70, 0x02, 0xFF, 0xFD, 0x02, 0x20, 0x2F, 0xFF, 0xD0, 0x22, 0x82, 0x17, 0x8B, 0xF9, 0x80,
  0x4E, 0xF0, 0x36, 0x03, 0x0E, 0xD0, 0x67, 0x20, 0x30, 0xCC, 0x03, 0x70, 0x9D, 0x06, 0x74, 0x0D,
  0xB0, 0x47, 0x05, 0xD0, 0x67, 0x40, 0x5B, 0x04, 0x70, 0x4D, 0x06, 0x75, 0xB0, 0x57, 0x04, 0xD0,
  0x67, 0x50, 0xCA, 0x05, 0x70, 0x4D, 0x06, 0x75, 0x0A, 0xA0, 0x57, 0x04, 0xD0, 0x67, 0x50, 0x8A,
  0x06, 0x70, 0x4D, 0x06, 0x75, 0x82, 0x36, 0x62, 0x70, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67,
  0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04,
  0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x78, 0x07, 0x17, 0x50, 0x4F, 0xFB,
  0x0A, 0x74, 0x04, 0xFF, 0xB0, 0xA7, 0x40, 0x4F, 0xFB, 0x0A, 0x74, 0x04, 0xD0, 0x67, 0x77, 0x20,
  0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67,
  0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04,
  0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x78, 0x15, 0x77, 0x60, 0x4D,
  0x06, 0x77, 0x0D, 0xA0, 0x15, 0x04, 0xD0, 0x67, 0x7B, 0x60, 0x4D, 0x06, 0x76, 0x02, 0xB6, 0x04,
  0xD0, 0x67, 0x60, 0x6B, 0x60, 0x5D, 0x06, 0x76, 0x0D, 0xA0, 0xE6, 0x08, 0xD0, 0x67, 0x50, 0x7B,
  0x0E, 0x50, 0x20, 0xED, 0x06, 0x73, 0x02, 0x08, 0xC8, 0x4D, 0x01, 0x78, 0xBF, 0x98, 0x05, 0xEF,
  0x81, 0xD0, 0x2F, 0xFF, 0xE8, 0x1C, 0x02, 0xFF, 0xFE, 0x0C, 0x10,
  // "ě" (U+011B)
  0x48, 0x14, 0x77, 0x73, 0x81, 0x37, 0x77, 0x10, 0x7A, 0x0A, 0x71, 0x82, 0x4E, 0xFD, 0x72, 0x0C,
  0xA0, 0xA6, 0x04, 0x0E, 0xA0, 0x47, 0x20, 0x2B, 0x0A, 0x40, 0x30, 0xEA, 0x08, 0x74, 0x07, 0xB0,
  0x82, 0x02, 0x0E, 0xA0, 0xD7, 0x60, 0xDB, 0x81, 0x61, 0xDB, 0x04, 0x76, 0x03, 0xC0, 0xCB, 0x0A,
  0x77, 0x10, 0x9F, 0x01, 0x77, 0x10, 0x1E, 0x08, 0x77, 0x30, 0x9D, 0x01, 0x80, 0x9D, 0x50, 0x84,
  0x25, 0x77, 0x64, 0x77, 0x20, 0x70, 0xDF, 0x0B, 0x03, 0x74, 0x03, 0x0D, 0xFC, 0x09, 0x72, 0x03,
  0x0E, 0xC8, 0x2E, 0xA9, 0xBD, 0x0B, 0x70, 0x10, 0xEC, 0x08, 0x40, 0x10, 0xCC, 0x09, 0x60, 0xBC,
  0x08, 0x60, 0x10, 0xEC, 0x03, 0x40, 0x4C, 0x0D, 0x71, 0x06, 0xC0, 0xC4, 0x0B, 0xC0, 0x67, 0x10,
  0x1D, 0x02, 0x20, 0x1D, 0x01, 0x72, 0x0C, 0xC0, 0x72, 0x05, 0xC0, 0xC7, 0x30, 0x8C, 0x0B, 0x20,
  0x9C, 0x09, 0x73, 0x06, 0xC0, 0xE2, 0x0C, 0xC0, 0x77, 0x30, 0x4D, 0x81, 0x10, 0xEC, 0x05, 0x73,
  0x03, 0xD0, 0x21, 0xD0, 0x58, 0x06, 0x10, 0x4D, 0x03, 0x02, 0xFF, 0xF9, 0x00, 0x3F, 0xFF, 0x90,
  0x40, 0x3F, 0xFF, 0x90, 0x40, 0x3D, 0x03, 0x77, 0x30, 0x2D, 0x04, 0x77, 0x30, 0x1D, 0x05, 0x77,
  0x4D, 0x06, 0x77, 0x40, 0xEC, 0x08, 0x77, 0x40, 0xBC, 0x0A, 0x77, 0x40, 0x8C, 0x0D, 0x77, 0x40,
  0x4D, 0x02, 0x77, 0x40, 0xEC, 0x07, 0x76, 0x01, 0x40, 0x9C, 0x0D, 0x75, 0x07, 0x0D, 0x40, 0x2D,
  0x07, 0x73, 0x03, 0xA0, 0x34, 0x08, 0xD0, 0x47, 0x10, 0x30, 0xEA, 0x01, 0x50, 0xCD, 0x08, 0x01,
  0x50, 0x70, 0xEA, 0x0A, 0x60, 0x10, 0xDE, 0x83, 0xB9, 0x9B, 0xEB, 0x0D, 0x01, 0x70, 0x10, 0xBF,
  0xD0, 0xB0, 0x17, 0x30, 0x40, 0xBF, 0x90, 0xC0, 0x57, 0x78, 0x61, 0x46, 0x77, 0x64, 0x17,
  // "Ĝ" (U+011C)
  0x77, 0x10, 0x38, 0x01, 0x77, 0x77, 0x70, 0xCD, 0x04, 0x77, 0x75, 0x05, 0xE0, 0xC7, 0x77, 0x50,
  0xDF, 0x05, 0x77, 0x73, 0x08, 0xB0, 0xC0, 0x7B, 0x0D, 0x77, 0x72, 0x02, 0xB8, 0x2E, 0x20, 0x9B,
  0x08, 0x77, 0x71, 0x0B, 0xA0, 0xE0, 0x33, 0x0B, 0xB0, 0x27, 0x76, 0x06, 0xA0, 0xE0, 0x45, 0x0B,
  0xA0, 0xC7, 0x75, 0x83, 0x2E, 0xFE, 0x47, 0x0B, 0xA0, 0x87, 0x74, 0x82, 0x8F, 0xE3, 0x72, 0x0A,
  0xA8, 0x09, 0xF1, 0x08, 0x73, 0x56, 0x77, 0x65, 0x31, 0x77, 0x78, 0x11, 0x6B, 0xFB, 0x81, 0xD8,
  0x27, 0x72, 0x01, 0x08, 0xFF, 0xA0, 0x97, 0x70, 0x40, 0xEE, 0x84, 0xCA, 0x99, 0xBE, 0xE0, 0xD0,
  0x17, 0x40, 0x7D, 0x0C, 0x05, 0x70, 0x7E, 0x0B, 0x73, 0x08, 0xD0, 0x67, 0x30, 0x5E, 0x04, 0x71,
  0x06, 0xD0, 0x47, 0x50, 0x8D, 0x07, 0x70, 0x2D, 0x06, 0x76, 0x01, 0x0E, 0xC0, 0x87, 0x0C, 0xC0,
  0xC7, 0x71, 0x0A, 0xC0, 0x56, 0x05, 0xD0, 0x47, 0x71, 0x06, 0xB0, 0xC7, 0x0C, 0xC0, 0xD7, 0x72,
  0x82, 0x4F, 0xE9, 0x70, 0x4D, 0x08, 0x77, 0x30, 0x27, 0x20, 0x9D, 0x03, 0x77, 0x76, 0x0E, 0xC0,
  0xE7, 0x77, 0x60, 0x3D, 0x0C, 0x77, 0x76, 0x06, 0xD0, 0x97, 0x77, 0x60, 0x9D, 0x07, 0x77, 0x76,
  0x0B, 0xD0, 0x57, 0x77, 0x60, 0xDD, 0x04, 0x77, 0x76, 0xE0, 0x37, 0x77, 0x6E, 0x02, 0x77, 0x75,
  0x01, 0xE0, 0x27, 0x77, 0x50, 0x1E, 0x02, 0x77, 0x75, 0x01, 0xE0, 0x27, 0x68, 0x09, 0x11, 0x1E,
  0x02, 0x75, 0x0B, 0xFD, 0x0D, 0x1E, 0x03, 0x75, 0x0B, 0xFD, 0x81, 0xD0, 0xED, 0x04, 0x75, 0x0B,
  0xFD, 0x81, 0xD0, 0xCD, 0x05, 0x76, 0x81, 0x14, 0xBF, 0x08, 0x02, 0x20, 0xAD, 0x07, 0x77, 0x20,
  0xDD, 0x0A, 0x40, 0x7D, 0x09, 0x77, 0x20, 0x8D, 0x06, 0x40, 0x3D, 0x0C, 0x77, 0x20, 0x7D, 0x04,
  0x5E, 0x77, 0x20, 0x6D, 0x04, 0x50, 0xAD, 0x04, 0x77, 0x10, 0x6D, 0x04, 0x50, 0x5D, 0x09, 0x77,
  0x10, 0x6D, 0x04, 0x60, 0xEC, 0x0E, 0x77, 0x10, 0x6D, 0x04, 0x60, 0x7D, 0x05, 0x77, 0x06, 0xD0,
  0x46, 0x01, 0x0E, 0xC0, 0xD7, 0x70, 0x6D, 0x04, 0x70, 0x5D, 0x08, 0x76, 0x06, 0xD0, 0x47, 0x10,
  0x9D, 0x06, 0x75, 0x06, 0xD0, 0x47, 0x20, 0xBD, 0x08, 0x74, 0x06, 0xD0, 0x47, 0x30, 0xBD, 0x81,
  0xD7, 0x17, 0x10, 0x8D, 0x04, 0x74, 0x08, 0xF8, 0x5D, 0xB9, 0x99, 0xAC, 0xF0, 0x47, 0x50, 0x30,
  0xBF, 0xFB, 0x0B, 0x04, 0x77, 0x18, 0x13, 0x8D, 0xFB, 0x82, 0xEA, 0x61, 0x77, 0x68, 0x90, 0x13,
  0x56, 0x77, 0x65, 0x31, 0x73,
  // "ĝ" (U+011D)
  0x72, 0x03, 0x80, 0x17, 0x77, 0x70, 0xCD, 0x04, 0x77, 0x50, 0x5E, 0x0C, 0x77, 0x50, 0xDF, 0x05,
  0x77, 0x30, 0x8B, 0x0C, 0x07, 0xB0, 0xD7, 0x72, 0x02, 0xB8, 0x2E, 0x20, 0x9B, 0x08, 0x77, 0x10,
  0xBA, 0x0E, 0x03, 0x30, 0xBB, 0x02, 0x76, 0x06, 0xA0, 0xE0, 0x45, 0x0B, 0xA0, 0xC7, 0x58, 0x32,
  0xEF, 0xE4, 0x70, 0xBA, 0x08, 0x74, 0x82, 0x8F, 0xE3, 0x72, 0x0A, 0xA8, 0x09, 0xD1, 0x08, 0x21,
  0x55, 0x27, 0x48, 0x43, 0x57, 0x75, 0x25, 0x05, 0x0E, 0xB0, 0x57, 0x81, 0x2A, 0xEE, 0x0D, 0x05,
  0x20, 0x8D, 0x0E, 0x60, 0x6F, 0xC0, 0x90, 0x8F, 0x02, 0x40, 0x6D, 0x82, 0xC9, 0x9C, 0xE8, 0x1D,
  0x9C, 0xB4, 0x02, 0xC0, 0xE0, 0x44, 0x04, 0x0E, 0xB0, 0xB3, 0x81, 0xDF, 0x94, 0x0A, 0xC0, 0x56,
  0x05, 0xC0, 0x32, 0x06, 0x07, 0x40, 0x1C, 0x0D, 0x71, 0x0D, 0xB0, 0xB7, 0x10, 0x5C, 0x08, 0x71,
  0x09, 0xC0, 0x27, 0x09, 0xC0, 0x67, 0x10, 0x7C, 0x06, 0x70, 0xAC, 0x04, 0x71, 0x05, 0xC0, 0x97,
  0x0B, 0xC0, 0x37, 0x10, 0x4C, 0x0A, 0x70, 0xCC, 0x03, 0x71, 0x05, 0xC0, 0xB7, 0x0B, 0xC0, 0x47,
  0x10, 0x5C, 0x0A, 0x70, 0x8C, 0x06, 0x71, 0x07, 0xC0, 0x87, 0x05, 0xC0, 0x97, 0x10, 0xAC, 0x04,
  0x71, 0x0E, 0xB0, 0xE7, 0x10, 0xEB, 0x0E, 0x72, 0x07, 0xC0, 0x86, 0x08, 0xC0, 0x87, 0x30, 0xCC,
  0x0A, 0x03, 0x20, 0x30, 0x9C, 0x0D, 0x74, 0x01, 0x0D, 0xFD, 0x0E, 0x03, 0x76, 0x09, 0xFB, 0x0C,
  0x02, 0x77, 0x0A, 0xA0, 0xC0, 0xEB, 0x81, 0xD9, 0x47, 0x71, 0x0C, 0xA0, 0x47, 0x77, 0x10, 0xAA,
  0x08, 0x77, 0x71, 0x03, 0xB0, 0x27, 0x77, 0x10, 0x8B, 0x01, 0x77, 0x71, 0x09, 0xB0, 0x47, 0x77,
  0x10, 0x7B, 0x81, 0xE5, 0x17, 0x76, 0x03, 0xFE, 0x82, 0xEB, 0x71, 0x73, 0x09, 0xFF, 0xA0, 0x77,
  0x30, 0x9F, 0xFA, 0x09, 0x71, 0x81, 0x17, 0xEF, 0xFA, 0x05, 0x60, 0x7F, 0xFD, 0x0D, 0x50, 0xAB,
  0x81, 0xE7, 0x27, 0x81, 0x15, 0xCD, 0x02, 0x30, 0x9B, 0x0D, 0x01, 0x75, 0x0B, 0xC0, 0x62, 0x03,
  0xC0, 0x27, 0x60, 0x3C, 0x08, 0x20, 0x9B, 0x0B, 0x77, 0x1C, 0x0A, 0x20, 0xCB, 0x08, 0x77, 0x10,
  0xDB, 0x09, 0x20, 0xEB, 0x07, 0x77, 0x10, 0xEB, 0x08, 0x20, 0xEB, 0x07, 0x77, 0x01, 0xC0, 0x62,
  0x0D, 0xB0, 0xA7, 0x70, 0x5C, 0x01, 0x20, 0xBB, 0x0E, 0x77, 0x0C, 0xB0, 0xB3, 0x06, 0xC0, 0x77,
  0x50, 0x7C, 0x03, 0x40, 0xEC, 0x05, 0x72, 0x01, 0x09, 0xC0, 0x95, 0x05, 0xD8, 0x7B, 0x52, 0x11,
  0x23, 0x6A, 0xD0, 0xA7, 0x06, 0xFF, 0xB0, 0x87, 0x20, 0x30, 0xCF, 0xE0, 0xA0, 0x37, 0x58, 0x32,
  0x7A, 0xDE, 0xA8, 0x4E, 0xDB, 0x85, 0x17, 0x20,
  // "Ğ" (U+011E)
  0x74, 0x08, 0xA0, 0x17, 0x10, 0x8A, 0x77, 0x50, 0x7A, 0x06, 0x71, 0x81, 0xDF, 0xE7, 0x75, 0x03,
  0xA0, 0xE0, 0x26, 0x08, 0xA0, 0xB7, 0x76, 0x0E, 0xA8, 0x5E, 0x72, 0x01, 0x4B, 0xB0, 0x67, 0x76,
  0x07, 0xFC, 0x0E, 0x77, 0x71, 0x0C, 0xFB, 0x05, 0x77, 0x71, 0x01, 0x0C, 0xF9, 0x06, 0x77, 0x74,
  0x86, 0x5A, 0xDF, 0xEC, 0x82, 0x80, 0x9F, 0x40, 0x87, 0x35, 0x67, 0x76, 0x53, 0x17, 0x77, 0x81,
  0x16, 0xBF, 0xB8, 0x1D, 0x82, 0x77, 0x20, 0x10, 0x8F, 0xFA, 0x09, 0x77, 0x04, 0x0E, 0xE8, 0x4C,
  0xA9, 0x9B, 0xEE, 0x0D, 0x01, 0x74, 0x07, 0xD0, 0xC0, 0x57, 0x07, 0xE0, 0xB7, 0x30, 0x8D, 0x06,
  0x73, 0x05, 0xE0, 0x47, 0x10, 0x6D, 0x04, 0x75, 0x08, 0xD0, 0x77, 0x02, 0xD0, 0x67, 0x60, 0x10,
  0xEC, 0x08, 0x70, 0xCC, 0x0C, 0x77, 0x10, 0xAC, 0x05, 0x60, 0x5D, 0x04, 0x77, 0x10, 0x6B, 0x0C,
  0x70, 0xCC, 0x0D, 0x77, 0x28, 0x24, 0xFE, 0x97, 0x04, 0xD0, 0x87, 0x73, 0x02, 0x72, 0x09, 0xD0,
  0x37, 0x77, 0x60, 0xEC, 0x0E, 0x77, 0x76, 0x03, 0xD0, 0xC7, 0x77, 0x60, 0x6D, 0x09, 0x77, 0x76,
  0x09, 0xD0, 0x77, 0x77, 0x60, 0xBD, 0x05, 0x77, 0x76, 0x0D, 0xD0, 0x47, 0x77, 0x6E, 0x03, 0x77,
  0x76, 0xE0, 0x27, 0x77, 0x50, 0x1E, 0x02, 0x77, 0x75, 0x01, 0xE0, 0x27, 0x77, 0x50, 0x1E, 0x02,
  0x76, 0x80, 0x91, 0x11, 0xE0, 0x27, 0x50, 0xBF, 0xD0, 0xD1, 0xE0, 0x37, 0x50, 0xBF, 0xD8, 0x1D,
  0x0E, 0xD0, 0x47, 0x50, 0xBF, 0xD8, 0x1D, 0x0C, 0xD0, 0x57, 0x68, 0x11, 0x4B, 0xF0, 0x80, 0x22,
  0x0A, 0xD0, 0x77, 0x72, 0x0D, 0xD0, 0xA4, 0x07, 0xD0, 0x97, 0x72, 0x08, 0xD0, 0x64, 0x03, 0xD0,
  0xC7, 0x72, 0x07, 0xD0, 0x45, 0xE7, 0x72, 0x06, 0xD0, 0x45, 0x0A, 0xD0, 0x47, 0x71, 0x06, 0xD0,
  0x45, 0x05, 0xD0, 0x97, 0x71, 0x06, 0xD0, 0x46, 0x0E, 0xC0, 0xE7, 0x71, 0x06, 0xD0, 0x46, 0x07,
  0xD0, 0x57, 0x70, 0x6D, 0x04, 0x60, 0x10, 0xEC, 0x0D, 0x77, 0x06, 0xD0, 0x47, 0x05, 0xD0, 0x87,
  0x60, 0x6D, 0x04, 0x71, 0x09, 0xD0, 0x67, 0x50, 0x6D, 0x04, 0x72, 0x0B, 0xD0, 0x87, 0x40, 0x6D,
  0x04, 0x73, 0x0B, 0xD8, 0x1D, 0x71, 0x71, 0x08, 0xD0, 0x47, 0x40, 0x8F, 0x85, 0xDB, 0x99, 0x9A,
  0xCF, 0x04, 0x75, 0x03, 0x0B, 0xFF, 0xB0, 0xB0, 0x47, 0x71, 0x81, 0x38, 0xDF, 0xB8, 0x2E, 0xA6,
  0x17, 0x76, 0x89, 0x01, 0x35, 0x67, 0x76, 0x53, 0x17, 0x30,
  // "ğ" (U+011F)
  0x40, 0x8A, 0x01, 0x71, 0x08, 0xA7, 0x50, 0x7A, 0x06, 0x71, 0x81, 0xDF, 0xE7, 0x50, 0x3A, 0x0E,
  0x02, 0x60, 0x8A, 0x0B, 0x76, 0x0E, 0xA8, 0x5E, 0x72, 0x01, 0x4B, 0xB0, 0x67, 0x60, 0x7F, 0xC0,
  0xE7, 0x71, 0x0C, 0xFB, 0x05, 0x77, 0x10, 0x10, 0xCF, 0x90, 0x67, 0x74, 0x86, 0x5A, 0xDF, 0xEC,
  0x82, 0x80, 0x9D, 0x50, 0x82, 0x15, 0x52, 0x74, 0x84, 0x35, 0x77, 0x52, 0x50, 0x50, 0xEB, 0x05,
  0x78, 0x12, 0xAE, 0xE0, 0xD0, 0x52, 0x08, 0xD0, 0xE6, 0x06, 0xFC, 0x09, 0x08, 0xF0, 0x24, 0x06,
  0xD8, 0x2C, 0x99, 0xCE, 0x81, 0xD9, 0xCB, 0x40, 0x2C, 0x0E, 0x04, 0x40, 0x40, 0xEB, 0x0B, 0x38,
  0x1D, 0xF9, 0x40, 0xAC, 0x05, 0x60, 0x5C, 0x03, 0x20, 0x60, 0x74, 0x01, 0xC0, 0xD7, 0x10, 0xDB,
  0x0B, 0x71, 0x05, 0xC0, 0x87, 0x10, 0x9C, 0x02, 0x70, 0x9C, 0x06, 0x71, 0x07, 0xC0, 0x67, 0x0A,
  0xC0, 0x47, 0x10, 0x5C, 0x09, 0x70, 0xBC, 0x03, 0x71, 0x04, 0xC0, 0xA7, 0x0C, 0xC0, 0x37, 0x10,
  0x5C, 0x0B, 0x70, 0xBC, 0x04, 0x71, 0x05, 0xC0, 0xA7, 0x08, 0xC0, 0x67, 0x10, 0x7C, 0x08, 0x70,
  0x5C, 0x09, 0x71, 0x0A, 0xC0, 0x47, 0x10, 0xEB, 0x0E, 0x71, 0x0E, 0xB0, 0xE7, 0x20, 0x7C, 0x08,
  0x60, 0x8C, 0x08, 0x73, 0x0C, 0xC0, 0xA0, 0x32, 0x03, 0x09, 0xC0, 0xD7, 0x40, 0x10, 0xDF, 0xD0,
  0xE0, 0x37, 0x60, 0x9F, 0xB0, 0xC0, 0x27, 0x70, 0xAA, 0x0C, 0x0E, 0xB8, 0x1D, 0x94, 0x77, 0x10,
  0xCA, 0x04, 0x77, 0x71, 0x0A, 0xA0, 0x87, 0x77, 0x10, 0x3B, 0x02, 0x77, 0x71, 0x08, 0xB0, 0x17,
  0x77, 0x10, 0x9B, 0x04, 0x77, 0x71, 0x07, 0xB8, 0x1E, 0x51, 0x77, 0x60, 0x3F, 0xE8, 0x2E, 0xB7,
  0x17, 0x30, 0x9F, 0xFA, 0x07, 0x73, 0x09, 0xFF, 0xA0, 0x97, 0x18, 0x11, 0x7E, 0xFF, 0xA0, 0x56,
  0x07, 0xFF, 0xD0, 0xD5, 0x0A, 0xB8, 0x1E, 0x72, 0x78, 0x11, 0x5C, 0xD0, 0x23, 0x09, 0xB0, 0xD0,
  0x17, 0x50, 0xBC, 0x06, 0x20, 0x3C, 0x02, 0x76, 0x03, 0xC0, 0x82, 0x09, 0xB0, 0xB7, 0x71, 0xC0,
  0xA2, 0x0C, 0xB0, 0x87, 0x71, 0x0D, 0xB0, 0x92, 0x0E, 0xB0, 0x77, 0x71, 0x0E, 0xB0, 0x82, 0x0E,
  0xB0, 0x77, 0x70, 0x1C, 0x06, 0x20, 0xDB, 0x0A, 0x77, 0x05, 0xC0, 0x12, 0x0B, 0xB0, 0xE7, 0x70,
  0xCB, 0x0B, 0x30, 0x6C, 0x07, 0x75, 0x07, 0xC0, 0x34, 0x0E, 0xC0, 0x57, 0x20, 0x10, 0x9C, 0x09,
  0x50, 0x5D, 0x87, 0xB5, 0x21, 0x12, 0x36, 0xAD, 0x0A, 0x70, 0x6F, 0xFB, 0x08, 0x72, 0x03, 0x0C,
  0xFE, 0x0A, 0x03, 0x75, 0x83, 0x27, 0xAD, 0xEA, 0x84, 0xED, 0xB8, 0x51, 0x72,
  // "Ġ" (U+0120)
  0x77, 0x28, 0x34, 0xCE, 0xD5, 0x77, 0x77, 0x03, 0xD0, 0x57, 0x77, 0x60, 0x7D, 0x0A, 0x77, 0x76,
  0x09, 0xD0, 0xB7, 0x77, 0x60, 0x7D, 0x0A, 0x77, 0x76, 0x03, 0xD0, 0x57, 0x77, 0x78, 0x34, 0xCE,
  0xD5, 0x80, 0xB8, 0x20, 0x87, 0x35, 0x67, 0x76, 0x53, 0x17, 0x77, 0x81, 0x16, 0xBF, 0xB8, 0x1D,
  0x82, 0x77, 0x20, 0x10, 0x8F, 0xFA, 0x09, 0x77, 0x04, 0x0E, 0xE8, 0x4C, 0xA9, 0x9B, 0xEE, 0x0D,
  0x01, 0x74, 0x07, 0xD0, 0xC0, 0x57, 0x07, 0xE0, 0xB7, 0x30, 0x8D, 0x06, 0x73, 0x05, 0xE0, 0x47,
  0x10, 0x6D, 0x04, 0x75, 0x08, 0xD0, 0x77, 0x02, 0xD0, 0x67, 0x60, 0x10, 0xEC, 0x08, 0x70, 0xCC,
  0x0C, 0x77, 0x10, 0xAC, 0x05, 0x60, 0x5D, 0x04, 0x77, 0x10, 0x6B, 0x0C, 0x70, 0xCC, 0x0D, 0x77,
  0x28, 0x24, 0xFE, 0x97, 0x04, 0xD0, 0x87, 0x73, 0x02, 0x72, 0x09, 0xD0, 0x37, 0x77, 0x60, 0xEC,
  0x0E, 0x77, 0x76, 0x03, 0xD0, 0xC7, 0x77, 0x60, 0x6D, 0x09, 0x77, 0x76, 0x09, 0xD0, 0x77, 0x77,
  0x60, 0xBD, 0x05, 0x77, 0x76, 0x0D, 0xD0, 0x47, 0x77, 0x6E, 0x03, 0x77, 0x76, 0xE0, 0x27, 0x77,
  0x50, 0x1E, 0x02, 0x77, 0x75, 0x01, 0xE0, 0x27, 0x77, 0x50, 0x1E, 0x02, 0x76, 0x80, 0x91, 0x11,
  0xE0, 0x27, 0x50, 0xBF, 0xD0, 0xD1, 0xE0, 0x37, 0x50, 0xBF, 0xD8, 0x1D, 0x0E, 0xD0, 0x47, 0x50,
  0xBF, 0xD8, 0x1D, 0x0C, 0xD0, 0x57, 0x68, 0x11, 0x4B, 0xF0, 0x80, 0x22, 0x0A, 0xD0, 0x77, 0x72,
  0x0D, 0xD0, 0xA4, 0x07, 0xD0, 0x97, 0x72, 0x08, 0xD0, 0x64, 0x03, 0xD0, 0xC7, 0x72, 0x07, 0xD0,
  0x45, 0xE7, 0x72, 0x06, 0xD0, 0x45, 0x0A, 0xD0, 0x47, 0x71, 0x06, 0xD0, 0x45, 0x05, 0xD0, 0x97,
  0x71, 0x06, 0xD0, 0x46, 0x0E, 0xC0, 0xE7, 0x71, 0x06, 0xD0, 0x46, 0x07, 0xD0, 0x57, 0x70, 0x6D,
  0x04, 0x60, 0x10, 0xEC, 0x0D, 0x77, 0x06, 0xD0, 0x47, 0x05, 0xD0, 0x87, 0x60, 0x6D, 0x04, 0x71,
  0x09, 0xD0, 0x67, 0x50, 0x6D, 0x04, 0x72, 0x0B, 0xD0, 0x87, 0x40, 0x6D, 0x04, 0x73, 0x0B, 0xD8,
  0x1D, 0x71, 0x71, 0x08, 0xD0, 0x47, 0x40, 0x8F, 0x85, 0xDB, 0x99, 0x9A, 0xCF, 0x04, 0x75, 0x03,
  0x0B, 0xFF, 0xB0, 0xB0, 0x47, 0x71, 0x81, 0x38, 0xDF, 0xB8, 0x2E, 0xA6, 0x17, 0x76, 0x89, 0x01,
  0x35, 0x67, 0x76, 0x53, 0x17, 0x30,
  // "ġ" (U+0121)
  0x73, 0x83, 0x4C, 0xED, 0x57, 0x77, 0x03, 0xD0, 0x57, 0x76, 0x07, 0xD0, 0xA7, 0x76, 0x09, 0xD0,
  0xB7, 0x76, 0x07, 0xD0, 0xA7, 0x76, 0x03, 0xD0, 0x57, 0x77, 0x83, 0x4C, 0xED, 0x58, 0x0A, 0xC4,
  0x08, 0x21, 0x55, 0x27, 0x48, 0x43, 0x57, 0x75, 0x25, 0x05, 0x0E, 0xB0, 0x57, 0x81, 0x2A, 0xEE,
  0x0D, 0x05, 0x20, 0x8D, 0x0E, 0x60, 0x6F, 0xC0, 0x90, 0x8F, 0x02, 0x40, 0x6D, 0x82, 0xC9, 0x9C,
  0xE8, 0x1D, 0x9C, 0xB4, 0x02, 0xC0, 0xE0, 0x44, 0x04, 0x0E, 0xB0, 0xB3, 0x81, 0xDF, 0x94, 0x0A,
  0xC0, 0x56, 0x05, 0xC0, 0x32, 0x06, 0x07, 0x40, 0x1C, 0x0D, 0x71, 0x0D, 0xB0, 0xB7, 0x10, 0x5C,
  0x08, 0x71, 0x09, 0xC0, 0x27, 0x09, 0xC0, 0x67, 0x10, 0x7C, 0x06, 0x70, 0xAC, 0x04, 0x71, 0x05,
  0xC0, 0x97, 0x0B, 0xC0, 0x37, 0x10, 0x4C, 0x0A, 0x70, 0xCC, 0x03, 0x71, 0x05, 0xC0, 0xB7, 0x0B,
  0xC0, 0x47, 0x10, 0x5C, 0x0A, 0x70, 0x8C, 0x06, 0x71, 0x07, 0xC0, 0x87, 0x05, 0xC0, 0x97, 0x10,
  0xAC, 0x04, 0x71, 0x0E, 0xB0, 0xE7, 0x10, 0xEB, 0x0E, 0x72, 0x07, 0xC0, 0x86, 0x08, 0xC0, 0x87,
  0x30, 0xCC, 0x0A, 0x03, 0x20, 0x30, 0x9C, 0x0D, 0x74, 0x01, 0x0D, 0xFD, 0x0E, 0x03, 0x76, 0x09,
  0xFB, 0x0C, 0x02, 0x77, 0x0A, 0xA0, 0xC0, 0xEB, 0x81, 0xD9, 0x47, 0x71, 0x0C, 0xA0, 0x47, 0x77,
  0x10, 0xAA, 0x08, 0x77, 0x71, 0x03, 0xB0, 0x27, 0x77, 0x10, 0x8B, 0x01, 0x77, 0x71, 0x09, 0xB0,
  0x47, 0x77, 0x10, 0x7B, 0x81, 0xE5, 0x17, 0x76, 0x03, 0xFE, 0x82, 0xEB, 0x71, 0x73, 0x09, 0xFF,
  0xA0, 0x77, 0x30, 0x9F, 0xFA, 0x09, 0x71, 0x81, 0x17, 0xEF, 0xFA, 0x05, 0x60, 0x7F, 0xFD, 0x0D,
  0x50, 0xAB, 0x81, 0xE7, 0x27, 0x81, 0x15, 0xCD, 0x02, 0x30, 0x9B, 0x0D, 0x01, 0x75, 0x0B, 0xC0,
  0x62, 0x03, 0xC0, 0x27, 0x60, 0x3C, 0x08, 0x20, 0x9B, 0x0B, 0x77, 0x1C, 0x0A, 0x20, 0xCB, 0x08,
  0x77, 0x10, 0xDB, 0x09, 0x20, 0xEB, 0x07, 0x77, 0x10, 0xEB, 0x08, 0x20, 0xEB, 0x07, 0x77, 0x01,
  0xC0, 0x62, 0x0D, 0xB0, 0xA7, 0x70, 0x5C, 0x01, 0x20, 0xBB, 0x0E, 0x77, 0x0C, 0xB0, 0xB3, 0x06,
  0xC0, 0x77, 0x50, 0x7C, 0x03, 0x40, 0xEC, 0x05, 0x72, 0x01, 0x09, 0xC0, 0x95, 0x05, 0xD8, 0x7B,
  0x52, 0x11, 0x23, 0x6A, 0xD0, 0xA7, 0x06, 0xFF, 0xB0, 0x87, 0x20, 0x30, 0xCF, 0xE0, 0xA0, 0x37,
  0x58, 0x32, 0x7A, 0xDE, 0xA8, 0x4E, 0xDB, 0x85, 0x17, 0x20,
  // "Ģ" (U+0122)
  0x77, 0x18, 0x73, 0x56, 0x77, 0x65, 0x31, 0x77, 0x78, 0x11, 0x6B, 0xFB, 0x81, 0xD8, 0x27, 0x72,
  0x01, 0x08, 0xFF, 0xA0, 0x97, 0x70, 0x40, 0xEE, 0x84, 0xCA, 0x99, 0xBE, 0xE0, 0xD0, 0x17, 0x40,
  0x7D, 0x0C, 0x05, 0x70, 0x7E, 0x0B, 0x73, 0x08, 0xD0, 0x67, 0x30, 0x5E, 0x04, 0x71, 0x06, 0xD0,
  0x47, 0x50, 0x8D, 0x07, 0x70, 0x2D, 0x06, 0x76, 0x01, 0x0E, 0xC0, 0x87, 0x0C, 0xC0, 0xC7, 0x71,
  0x0A, 0xC0, 0x56, 0x05, 0xD0, 0x47, 0x71, 0x06, 0xB0, 0xC7, 0x0C, 0xC0, 0xD7, 0x72, 0x82, 0x4F,
  0xE9, 0x70, 0x4D, 0x08, 0x77, 0x30, 0x27, 0x20, 0x9D, 0x03, 0x77, 0x76, 0x0E, 0xC0, 0xE7, 0x77,
  0x60, 0x3D, 0x0C, 0x77, 0x76, 0x06, 0xD0, 0x97, 0x77, 0x60, 0x9D, 0x07, 0x77, 0x76, 0x0B, 0xD0,
  0x57, 0x77, 0x60, 0xDD, 0x04, 0x77, 0x76, 0xE0, 0x37, 0x77, 0x6E, 0x02, 0x77, 0x75, 0x01, 0xE0,
  0x27, 0x77, 0x50, 0x1E, 0x02, 0x77, 0x75, 0x01, 0xE0, 0x27, 0x68, 0x09, 0x11, 0x1E, 0x02, 0x75,
  0x0B, 0xFD, 0x0D, 0x1E, 0x03, 0x75, 0x0B, 0xFD, 0x81, 0xD0, 0xED, 0x04, 0x75, 0x0B, 0xFD, 0x81,
  0xD0, 0xCD, 0x05, 0x76, 0x81, 0x14, 0xBF, 0x08, 0x02, 0x20, 0xAD, 0x07, 0x77, 0x20, 0xDD, 0x0A,
  0x40, 0x7D, 0x09, 0x77, 0x20, 0x8D, 0x06, 0x40, 0x3D, 0x0C, 0x77, 0x20, 0x7D, 0x04, 0x5E, 0x77,
  0x20, 0x6D, 0x04, 0x50, 0xAD, 0x04, 0x77, 0x10, 0x6D, 0x04, 0x50, 0x5D, 0x09, 0x77, 0x10, 0x6D,
  0x04, 0x60, 0xEC, 0x0E, 0x77, 0x10, 0x6D, 0x04, 0x60, 0x7D, 0x05, 0x77, 0x06, 0xD0, 0x46, 0x01,
  0x0E, 0xC0, 0xD7, 0x70, 0x6D, 0x04, 0x70, 0x5D, 0x08, 0x76, 0x06, 0xD0, 0x47, 0x10, 0x9D, 0x06,
  0x75, 0x06, 0xD0, 0x47, 0x20, 0xBD, 0x08, 0x74, 0x06, 0xD0, 0x47, 0x30, 0xBD, 0x81, 0xD7, 0x17,
  0x10, 0x8D, 0x04, 0x74, 0x08, 0xF8, 0x5D, 0xB9, 0x99, 0xAC, 0xF0, 0x47, 0x50, 0x30, 0xBF, 0xFB,
  0x0B, 0x04, 0x77, 0x18, 0x13, 0x8D, 0xFB, 0x82, 0xEA, 0x61, 0x77, 0x68, 0x90, 0x13, 0x56, 0x77,
  0x65, 0x31, 0x80, 0x9B, 0x20, 0x0B, 0xC0, 0x37, 0x77, 0x70, 0xEB, 0x0D, 0x77, 0x77, 0x01, 0xC0,
  0x77, 0x77, 0x70, 0x3C, 0x01, 0x77, 0x77, 0x05, 0xB0, 0x97, 0x77, 0x71, 0x08, 0xB0, 0x27, 0x77,
  0x71, 0x0B, 0xA0, 0xA7, 0x77, 0x72, 0x0E, 0xA0, 0x37, 0x77, 0x71, 0x02, 0xA0, 0xA7, 0x77, 0x72,
  0x04, 0xA0, 0x27, 0x72,
  // "ģ" (U+0123)
  0x76, 0x03, 0xA0, 0x77, 0x77, 0x20, 0xBA, 0x05, 0x77, 0x71, 0x03, 0xB0, 0x27, 0x77, 0x10, 0xBA,
  0x0E, 0x77, 0x71, 0x03, 0xB0, 0xB7, 0x77, 0x10, 0xAB, 0x08, 0x77, 0x70, 0x2C, 0x06, 0x77, 0x70,
  0x8C, 0x03, 0x77, 0x70, 0xEC, 0x01, 0x77, 0x60, 0x3C, 0x0E, 0x80, 0x9A, 0x30, 0x82, 0x15, 0x52,
  0x74, 0x84, 0x35, 0x77, 0x52, 0x50, 0x50, 0xEB, 0x05, 0x78, 0x12, 0xAE, 0xE0, 0xD0, 0x52, 0x08,
  0xD0, 0xE6, 0x06, 0xFC, 0x09, 0x08, 0xF0, 0x24, 0x06, 0xD8, 0x2C, 0x99, 0xCE, 0x81, 0xD9, 0xCB,
  0x40, 0x2C, 0x0E, 0x04, 0x40, 0x40, 0xEB, 0x0B, 0x38, 0x1D, 0xF9, 0x40, 0xAC, 0x05, 0x60, 0x5C,
  0x03, 0x20, 0x60, 0x74, 0x01, 0xC0, 0xD7, 0x10, 0xDB, 0x0B, 0x71, 0x05, 0xC0, 0x87, 0x10, 0x9C,
  0x02, 0x70, 0x9C, 0x06, 0x71, 0x07, 0xC0, 0x67, 0x0A, 0xC0, 0x47, 0x10, 0x5C, 0x09, 0x70, 0xBC,
  0x03, 0x71, 0x04, 0xC0, 0xA7, 0x0C, 0xC0, 0x37, 0x10, 0x5C, 0x0B, 0x70, 0xBC, 0x04, 0x71, 0x05,
  0xC0, 0xA7, 0x08, 0xC0, 0x67, 0x10, 0x7C, 0x08, 0x70, 0x5C, 0x09, 0x71, 0x0A, 0xC0, 0x47, 0x10,
  0xEB, 0x0E, 0x71, 0x0E, 0xB0, 0xE7, 0x20, 0x7C, 0x08, 0x60, 0x8C, 0x08, 0x73, 0x0C, 0xC0, 0xA0,
  0x32, 0x03, 0x09, 0xC0, 0xD7, 0x40, 0x10, 0xDF, 0xD0, 0xE0, 0x37, 0x60, 0x9F, 0xB0, 0xC0, 0x27,
  0x70, 0xAA, 0x0C, 0x0E, 0xB8, 0x1D, 0x94, 0x77, 0x10, 0xCA, 0x04, 0x77, 0x71, 0x0A, 0xA0, 0x87,
  0x77, 0x10, 0x3B, 0x02, 0x77, 0x71, 0x08, 0xB0, 0x17, 0x77, 0x10, 0x9B, 0x04, 0x77, 0x71, 0x07,
  0xB8, 0x1E, 0x51, 0x77, 0x60, 0x3F, 0xE8, 0x2E, 0xB7, 0x17, 0x30, 0x9F, 0xFA, 0x07, 0x73, 0x09,
  0xFF, 0xA0, 0x97, 0x18, 0x11, 0x7E, 0xFF, 0xA0, 0x56, 0x07, 0xFF, 0xD0, 0xD5, 0x0A, 0xB8, 0x1E,
  0x72, 0x78, 0x11, 0x5C, 0xD0, 0x23, 0x09, 0xB0, 0xD0, 0x17, 0x50, 0xBC, 0x06, 0x20, 0x3C, 0x02,
  0x76, 0x03, 0xC0, 0x82, 0x09, 0xB0, 0xB7, 0x71, 0xC0, 0xA2, 0x0C, 0xB0, 0x87, 0x71, 0x0D, 0xB0,
  0x92, 0x0E, 0xB0, 0x77, 0x71, 0x0E, 0xB0, 0x82, 0x0E, 0xB0, 0x77, 0x70, 0x1C, 0x06, 0x20, 0xDB,
  0x0A, 0x77, 0x05, 0xC0, 0x12, 0x0B, 0xB0, 0xE7, 0x70, 0xCB, 0x0B, 0x30, 0x6C, 0x07, 0x75, 0x07,
  0xC0, 0x34, 0x0E, 0xC0, 0x57, 0x20, 0x10, 0x9C, 0x09, 0x50, 0x5D, 0x87, 0xB5, 0x21, 0x12, 0x36,
  0xAD, 0x0A, 0x70, 0x6F, 0xFB, 0x08, 0x72, 0x03, 0x0C, 0xFE, 0x0A, 0x03, 0x75, 0x83, 0x27, 0xAD,
  0xEA, 0x84, 0xED, 0xB8, 0x51, 0x72,
  // "Ĥ" (U+0124)
  0x77, 0x20, 0x38, 0x01, 0x77, 0x77, 0x74, 0x0C, 0xD0, 0x47, 0x77, 0x72, 0x05, 0xE0, 0xC7, 0x77,
  0x72, 0x0D, 0xF0, 0x57, 0x77, 0x70, 0x8B, 0x0C, 0x07, 0xB0, 0xD7, 0x77, 0x60, 0x2B, 0x82, 0xE2,
  0x09, 0xB0, 0x87, 0x77, 0x50, 0xBA, 0x0E, 0x03, 0x30, 0xBB, 0x02, 0x77, 0x73, 0x06, 0xA0, 0xE0,
  0x45, 0x0B, 0xA0, 0xC7, 0x77, 0x28, 0x32, 0xEF, 0xE4, 0x70, 0xBA, 0x08, 0x77, 0x71, 0x82, 0x8F,
  0xE3, 0x72, 0x0A, 0xA8, 0x0A, 0xB7, 0x00, 0x2F, 0xF9, 0x60, 0x1F, 0xF9, 0x02, 0xFF, 0x96, 0x01,
  0xFF, 0x90, 0x2F, 0xF9, 0x60, 0x1F, 0xF9, 0x18, 0x21, 0x25, 0xCF, 0x82, 0xC5, 0x21, 0x78, 0x21,
  0x26, 0xDF, 0x82, 0xB4, 0x21, 0x50, 0xCD, 0x0D, 0x77, 0x01, 0xE0, 0xA7, 0x20, 0x6D, 0x09, 0x77,
  0x10, 0xBD, 0x04, 0x72, 0x04, 0xD0, 0x77, 0x71, 0x09, 0xD0, 0x27, 0x20, 0x4D, 0x06, 0x77, 0x10,
  0x8D, 0x02, 0x72, 0x04, 0xD0, 0x67, 0x71, 0x08, 0xD0, 0x27, 0x20, 0x4D, 0x06, 0x77, 0x10, 0x8D,
  0x02, 0x72, 0x04, 0xD0, 0x67, 0x71, 0x08, 0xD0, 0x27, 0x20, 0x4D, 0x06, 0x77, 0x10, 0x8D, 0x02,
  0x72, 0x04, 0xD0, 0x67, 0x71, 0x08, 0xD0, 0x27, 0x20, 0x4D, 0x06, 0x77, 0x10, 0x8D, 0x02, 0x72,
  0x04, 0xD0, 0x67, 0x71, 0x08, 0xD0, 0x27, 0x20, 0x4D, 0x06, 0x77, 0x10, 0x8D, 0x02, 0x72, 0x04,
  0xD0, 0x67, 0x71, 0x08, 0xD0, 0x27, 0x20, 0x4D, 0x06, 0x77, 0x10, 0x8D, 0x02, 0x72, 0x04, 0xD0,
  0x78, 0x09, 0x31, 0x09, 0xD0, 0x27, 0x20, 0x4F, 0xFF, 0xE0, 0x27, 0x20, 0x4F, 0xFF, 0xE0, 0x27,
  0x20, 0x4F, 0xFF, 0xE0, 0x27, 0x20, 0x4D, 0x06, 0x77, 0x10, 0x8D, 0x02, 0x72, 0x04, 0xD0, 0x67,
  0x71, 0x08, 0xD0, 0x27, 0x20, 0x4D, 0x06, 0x77, 0x10, 0x8D, 0x02, 0x72, 0x04, 0xD0, 0x67, 0x71,
  0x08, 0xD0, 0x27, 0x20, 0x4D, 0x06, 0x77, 0x10, 0x8D, 0x02, 0x72, 0x04, 0xD0, 0x67, 0x71, 0x08,
  0xD0, 0x27, 0x20, 0x4D, 0x06, 0x77, 0x10, 0x8D, 0x02, 0x72, 0x04, 0xD0, 0x67, 0x71, 0x08, 0xD0,
  0x27, 0x20, 0x4D, 0x06, 0x77, 0x10, 0x8D, 0x02, 0x72, 0x04, 0xD0, 0x67, 0x71, 0x08, 0xD0, 0x27,
  0x20, 0x4D, 0x06, 0x77, 0x10, 0x8D, 0x02, 0x72, 0x04, 0xD0, 0x67, 0x71, 0x08, 0xD0, 0x27, 0x20,
  0x4D, 0x06, 0x77, 0x10, 0x8D, 0x02, 0x72, 0x04, 0xD0, 0x67, 0x71, 0x08, 0xD0, 0x27, 0x20, 0x5D,
  0x07, 0x77, 0x10, 0x9D, 0x02, 0x72, 0x07, 0xD0, 0x97, 0x71, 0x0B, 0xD0, 0x47, 0x20, 0xCD, 0x0E,
  0x77, 0x01, 0xE0, 0xA5, 0x82, 0x12, 0x5C, 0xF8, 0x2C, 0x52, 0x17, 0x82, 0x12, 0x6D, 0xF8, 0x3A,
  0x42, 0x12, 0xFF, 0x96, 0x01, 0xFF, 0x90, 0x2F, 0xF9, 0x60, 0x1F, 0xF9, 0x02, 0xFF, 0x96, 0x01,
  0xFF, 0x90,
  // "ĥ" (U+0125)
  0x74, 0x03, 0x80, 0x17, 0x77, 0x75, 0x0C, 0xD0, 0x47, 0x77, 0x30, 0x5E, 0x0C, 0x77, 0x73, 0x0D,
  0xF0, 0x57, 0x77, 0x10, 0x8B, 0x0C, 0x07, 0xB0, 0xD7, 0x77, 0x02, 0xB8, 0x2E, 0x20, 0x9B, 0x08,
  0x77, 0x60, 0xBA, 0x0E, 0x03, 0x30, 0xBB, 0x02, 0x77, 0x40, 0x6A, 0x0E, 0x04, 0x50, 0xBA, 0x0C,
  0x77, 0x38, 0x32, 0xEF, 0xE4, 0x70, 0xBA, 0x08, 0x77, 0x28, 0x28, 0xFE, 0x37, 0x20, 0xAA, 0x80,
  0x9C, 0x60, 0x01, 0xFA, 0x0C, 0x77, 0x70, 0x1F, 0xA0, 0xC7, 0x77, 0x01, 0xFA, 0x0C, 0x77, 0x71,
  0x82, 0x13, 0x7E, 0xD0, 0xC7, 0x77, 0x40, 0x2D, 0x0C, 0x77, 0x75, 0x0B, 0xC0, 0xC7, 0x77, 0x50,
  0x9C, 0x0C, 0x77, 0x75, 0x08, 0xC0, 0xC7, 0x77, 0x50, 0x8C, 0x0C, 0x77, 0x75, 0x08, 0xC0, 0xC7,
  0x77, 0x50, 0x8C, 0x0C, 0x77, 0x75, 0x08, 0xC0, 0xC7, 0x77, 0x50, 0x8C, 0x0C, 0x77, 0x75, 0x08,
  0xC0, 0xC5, 0x84, 0x36, 0x76, 0x51, 0x77, 0x10, 0x8C, 0x0C, 0x30, 0x40, 0xDE, 0x0B, 0x03, 0x76,
  0x08, 0xC0, 0xB2, 0x07, 0xFB, 0x06, 0x75, 0x08, 0xC8, 0x1B, 0x05, 0xFD, 0x04, 0x74, 0x08, 0xC0,
  0xA0, 0x2A, 0x83, 0xE9, 0x89, 0xCE, 0x0D, 0x74, 0x08, 0xC8, 0x29, 0xAF, 0x85, 0x03, 0x0E, 0xD0,
  0x57, 0x30, 0x8C, 0x81, 0xCF, 0x87, 0x04, 0xD0, 0xA7, 0x30, 0x8D, 0x0E, 0x72, 0x0C, 0xC0, 0xE7,
  0x30, 0x8D, 0x08, 0x72, 0x07, 0xD0, 0x17, 0x20, 0x8D, 0x04, 0x72, 0x03, 0xD0, 0x37, 0x20, 0x8D,
  0x01, 0x72, 0x01, 0xD0, 0x47, 0x20, 0x8C, 0x0E, 0x74, 0xD0, 0x57, 0x20, 0x8C, 0x0D, 0x74, 0xD0,
  0x57, 0x20, 0x8C, 0x0C, 0x74, 0xD0, 0x57, 0x20, 0x8C, 0x0C, 0x74, 0xD0, 0x57, 0x20, 0x8C, 0x0C,
  0x74, 0xD0, 0x57, 0x20, 0x8C, 0x0C, 0x74, 0xD0, 0x57, 0x20, 0x8C, 0x0C, 0x74, 0xD0, 0x57, 0x20,
  0x8C, 0x0C, 0x74, 0xD0, 0x57, 0x20, 0x8C, 0x0C, 0x74, 0xD0, 0x57, 0x20, 0x8C, 0x0C, 0x74, 0xD0,
  0x57, 0x20, 0x8C, 0x0C, 0x74, 0xD0, 0x57, 0x20, 0x8C, 0x0C, 0x74, 0xD0, 0x57, 0x20, 0x8C, 0x0C,
  0x74, 0xD0, 0x57, 0x20, 0x8C, 0x0C, 0x74, 0xD0, 0x57, 0x20, 0x8C, 0x0C, 0x74, 0xD0, 0x57, 0x20,
  0x9C, 0x0C, 0x74, 0xD0, 0x67, 0x20, 0xBC, 0x0E, 0x74, 0xD0, 0x87, 0x10, 0x2E, 0x04, 0x73, 0xD0,
  0xD5, 0x82, 0x13, 0x7E, 0xE8, 0x2E, 0x83, 0x17, 0xE8, 0x3C, 0x52, 0x01, 0xFF, 0x7F, 0xA0, 0x50,
  0x1F, 0xF7, 0xFA, 0x05, 0x01, 0xFF, 0x7F, 0xA0, 0x50,
  // "Ħ" (U+0126)
  0x02, 0xFF, 0x96, 0x01, 0xFF, 0x91, 0x02, 0xFF, 0x96, 0x01, 0xFF, 0x91, 0x02, 0xFF, 0x96, 0x01,
  0xFF, 0x92, 0x82, 0x12, 0x5B, 0xF8, 0x2C, 0x52, 0x17, 0x82, 0x12, 0x6D, 0xF8, 0x2A, 0x42, 0x16,
  0x0B, 0xD0, 0xD7, 0x70, 0x10, 0xED, 0x09, 0x73, 0x06, 0xD0, 0x87, 0x71, 0x0A, 0xD0, 0x47, 0x30,
  0x4D, 0x06, 0x77, 0x10, 0x9D, 0x02, 0x73, 0x04, 0xD0, 0x67, 0x71, 0x08, 0xD0, 0x27, 0x30, 0x4D,
  0x06, 0x77, 0x10, 0x8D, 0x02, 0x68, 0x00, 0x10, 0x5D, 0x07, 0x80, 0x93, 0x10, 0x9D, 0x85, 0x31,
  0x11, 0x10, 0x38, 0x0C, 0x1F, 0x01, 0x03, 0x80, 0xC1, 0xF0, 0x10, 0x38, 0x0C, 0x1F, 0x01, 0x50,
  0x4D, 0x06, 0x77, 0x10, 0x8D, 0x02, 0x73, 0x04, 0xD0, 0x67, 0x71, 0x08, 0xD0, 0x27, 0x30, 0x4D,
  0x06, 0x77, 0x10, 0x8D, 0x02, 0x73, 0x04, 0xD0, 0x67, 0x71, 0x08, 0xD0, 0x27, 0x30, 0x4D, 0x06,
  0x77, 0x10, 0x8D, 0x02, 0x73, 0x04, 0xD0, 0x78, 0x09, 0x31, 0x09, 0xD0, 0x27, 0x30, 0x4F, 0xFF,
  0xE0, 0x27, 0x30, 0x4F, 0xFF, 0xE0, 0x27, 0x30, 0x4F, 0xFF, 0xE0, 0x27, 0x30, 0x4D, 0x06, 0x77,
  0x10, 0x8D, 0x02, 0x73, 0x04, 0xD0, 0x67, 0x71, 0x08, 0xD0, 0x27, 0x30, 0x4D, 0x06, 0x77, 0x10,
  0x8D, 0x02, 0x73, 0x04, 0xD0, 0x67, 0x71, 0x08, 0xD0, 0x27, 0x30, 0x4D, 0x06, 0x77, 0x10, 0x8D,
  0x02, 0x73, 0x04, 0xD0, 0x67, 0x71, 0x08, 0xD0, 0x27, 0x30, 0x4D, 0x06, 0x77, 0x10, 0x8D, 0x02,
  0x73, 0x04, 0xD0, 0x67, 0x71, 0x08, 0xD0, 0x27, 0x30, 0x4D, 0x06, 0x77, 0x10, 0x8D, 0x02, 0x73,
  0x04, 0xD0, 0x67, 0x71, 0x08, 0xD0, 0x27, 0x30, 0x4D, 0x06, 0x77, 0x10, 0x8D, 0x02, 0x73, 0x04,
  0xD0, 0x67, 0x71, 0x08, 0xD0, 0x27, 0x30, 0x4D, 0x06, 0x77, 0x10, 0x8D, 0x02, 0x73, 0x04, 0xD0,
  0x67, 0x71, 0x08, 0xD0, 0x27, 0x30, 0x5D, 0x07, 0x77, 0x10, 0x9D, 0x02, 0x73, 0x07, 0xD0, 0x97,
  0x71, 0x0B, 0xD0, 0x47, 0x30, 0xCD, 0x0E, 0x77, 0x01, 0xE0, 0xA6, 0x82, 0x12, 0x5C, 0xF8, 0x2C,
  0x52, 0x17, 0x82, 0x12, 0x6D, 0xF8, 0x4A, 0x42, 0x10, 0x2F, 0xF9, 0x60, 0x1F, 0xF9, 0x10, 0x2F,
  0xF9, 0x60, 0x1F, 0xF9, 0x10, 0x2F, 0xF9, 0x60, 0x1F, 0xF9, 0x10,
  // "ħ" (U+0127)
  0x01, 0xFA, 0x0C, 0x77, 0x70, 0x1F, 0xA0, 0xC7, 0x77, 0x01, 0xFA, 0x0C, 0x77, 0x71, 0x82, 0x12,
  0x6C, 0xD0, 0xC7, 0x77, 0x50, 0xEC, 0x0C, 0x77, 0x75, 0x09, 0xC0, 0xC7, 0x77, 0x50, 0x8C, 0x0C,
  0x77, 0x70, 0x2F, 0xFC, 0x05, 0x75, 0x02, 0xFF, 0xC0, 0x57, 0x50, 0x2F, 0xFC, 0x05, 0x76, 0x80,
  0x01, 0x09, 0xC0, 0xC8, 0x04, 0x17, 0x74, 0x08, 0xC0, 0xC7, 0x77, 0x50, 0x8C, 0x0C, 0x77, 0x75,
  0x08, 0xC0, 0xC7, 0x77, 0x50, 0x8C, 0x0C, 0x48, 0x66, 0xBE, 0xFE, 0xC8, 0x37, 0x70, 0x8C, 0x0C,
  0x20, 0x20, 0xDF, 0x90, 0x97, 0x60, 0x8C, 0x82, 0xB0, 0x2E, 0xFB, 0x0B, 0x75, 0x08, 0xC8, 0x1B,
  0x0D, 0xFD, 0x08, 0x74, 0x08, 0xC8, 0x90, 0xB8, 0xFE, 0x72, 0x01, 0x4B, 0xE0, 0x27, 0x30, 0x8C,
  0x82, 0xDF, 0xD1, 0x60, 0xAD, 0x07, 0x73, 0x08, 0xE0, 0x47, 0x01, 0x0E, 0xC0, 0xC7, 0x30, 0x8D,
  0x0C, 0x72, 0x09, 0xD7, 0x30, 0x8D, 0x06, 0x72, 0x05, 0xD0, 0x27, 0x20, 0x8D, 0x02, 0x72, 0x02,
  0xD0, 0x37, 0x20, 0x8D, 0x73, 0x01, 0xD0, 0x47, 0x20, 0x8C, 0x0D, 0x74, 0xD0, 0x57, 0x20, 0x8C,
  0x0D, 0x74, 0xD0, 0x57, 0x20, 0x8C, 0x0C, 0x74, 0xD0, 0x57, 0x20, 0x8C, 0x0C, 0x74, 0xD0, 0x57,
  0x20, 0x8C, 0x0C, 0x74, 0xD0, 0x57, 0x20, 0x8C, 0x0C, 0x74, 0xD0, 0x57, 0x20, 0x8C, 0x0C, 0x74,
  0xD0, 0x57, 0x20, 0x8C, 0x0C, 0x74, 0xD0, 0x57, 0x20, 0x8C, 0x0C, 0x74, 0xD0, 0x57, 0x20, 0x8C,
  0x0C, 0x74, 0xD0, 0x57, 0x20, 0x8C, 0x0C, 0x74, 0xD0, 0x57, 0x20, 0x8C, 0x0C, 0x74, 0xD0, 0x57,
  0x20, 0x8C, 0x0C, 0x74, 0xD0, 0x57, 0x20, 0x8C, 0x0C, 0x74, 0xD0, 0x57, 0x20, 0x9C, 0x0C, 0x74,
  0xD0, 0x67, 0x20, 0xBC, 0x0E, 0x74, 0xD0, 0x87, 0x10, 0x2E, 0x05, 0x73, 0xD0, 0xD5, 0x82, 0x13,
  0x7E, 0xE8, 0x2E, 0x83, 0x17, 0xE8, 0x3C, 0x52, 0x01, 0xFF, 0x01, 0x6F, 0xA0, 0x50, 0x1F, 0xF0,
  0x16, 0xFA, 0x05, 0x01, 0xFF, 0x01, 0x6F, 0xA0, 0x50,
  // "Ĩ" (U+0128)
  0x38, 0x44, 0xBE, 0xEB, 0x57, 0x81, 0x25, 0x52, 0x05, 0xE0, 0xA0, 0x15, 0x83, 0x9F, 0xE0, 0x2F,
  0x90, 0xD0, 0x34, 0x83, 0xEF, 0xC0, 0xAF, 0xB8, 0x27, 0x11, 0x9A, 0x08, 0x1A, 0x83, 0xD3, 0x04,
  0xDF, 0xB0, 0x20, 0x4A, 0x05, 0x40, 0x9F, 0x98, 0x1A, 0x07, 0xA0, 0x15, 0x05, 0x0E, 0xD8, 0x4D,
  0x10, 0x36, 0x57, 0x85, 0x19, 0xDF, 0xD8, 0x18, 0x09, 0x93, 0x00, 0x2F, 0xF9, 0x04, 0x20, 0x2F,
  0xF9, 0x04, 0x20, 0x2F, 0xF9, 0x04, 0x38, 0x21, 0x25, 0xCF, 0x82, 0xD6, 0x21, 0x71, 0x0C, 0xD0,
  0xE0, 0x17, 0x40, 0x7D, 0x09, 0x75, 0x05, 0xD0, 0x77, 0x50, 0x4D, 0x06, 0x75, 0x04, 0xD0, 0x67,
  0x50, 0x4D, 0x06, 0x75, 0x04, 0xD0, 0x67, 0x50, 0x4D, 0x06, 0x75, 0x04, 0xD0, 0x67, 0x50, 0x4D,
  0x06, 0x75, 0x04, 0xD0, 0x67, 0x50, 0x4D, 0x06, 0x75, 0x04, 0xD0, 0x67, 0x50, 0x4D, 0x06, 0x75,
  0x04, 0xD0, 0x67, 0x50, 0x4D, 0x06, 0x75, 0x04, 0xD0, 0x67, 0x50, 0x4D, 0x06, 0x75, 0x04, 0xD0,
  0x67, 0x50, 0x4D, 0x06, 0x75, 0x04, 0xD0, 0x67, 0x50, 0x4D, 0x06, 0x75, 0x04, 0xD0, 0x67, 0x50,
  0x4D, 0x06, 0x75, 0x04, 0xD0, 0x67, 0x50, 0x4D, 0x06, 0x75, 0x04, 0xD0, 0x67, 0x50, 0x4D, 0x06,
  0x75, 0x04, 0xD0, 0x67, 0x50, 0x4D, 0x06, 0x75, 0x04, 0xD0, 0x67, 0x50, 0x4D, 0x06, 0x75, 0x05,
  0xD0, 0x77, 0x50, 0x7D, 0x09, 0x75, 0x0C, 0xD0, 0xE7, 0x18, 0x21, 0x25, 0xCF, 0x82, 0xD5, 0x21,
  0x30, 0x2F, 0xF9, 0x04, 0x20, 0x2F, 0xF9, 0x04, 0x20, 0x2F, 0xF9, 0x04, 0x10,
  // "ĩ" (U+0129)
  0x38, 0x44, 0xBE, 0xEB, 0x57, 0x81, 0x25, 0x52, 0x05, 0xE0, 0xA0, 0x15, 0x83, 0x9F, 0xE0, 0x2F,
  0x90, 0xD0, 0x34, 0x83, 0xEF, 0xC0, 0xAF, 0xB8, 0x27, 0x11, 0x9A, 0x08, 0x1A, 0x83, 0xD3, 0x04,
  0xDF, 0xB0, 0x20, 0x4A, 0x05, 0x40, 0x9F, 0x98, 0x1A, 0x07, 0xA0, 0x15, 0x05, 0x0E, 0xD8, 0x4D,
  0x10, 0x36, 0x57, 0x85, 0x19, 0xDF, 0xD8, 0x18, 0x09, 0xC0, 0x00, 0x7F, 0xA0, 0x37, 0x10, 0x7F,
  0xA0, 0x37, 0x10, 0x7F, 0xA0, 0x37, 0x28, 0x12, 0x4A, 0xE0, 0x37, 0x50, 0x9D, 0x03, 0x75, 0x04,
  0xD0, 0x37, 0x50, 0x2D, 0x03, 0x75, 0x01, 0xD0, 0x37, 0x50, 0x1D, 0x03, 0x75, 0x01, 0xD0, 0x37,
  0x50, 0x1D, 0x03, 0x75, 0x01, 0xD0, 0x37, 0x50, 0x1D, 0x03, 0x75, 0x01, 0xD0, 0x37, 0x50, 0x1D,
  0x03, 0x75, 0x01, 0xD0, 0x37, 0x50, 0x1D, 0x03, 0x75, 0x01, 0xD0, 0x37, 0x50, 0x1D, 0x03, 0x75,
  0x01, 0xD0, 0x37, 0x50, 0x1D, 0x03, 0x75, 0x01, 0xD0, 0x37, 0x50, 0x1D, 0x03, 0x75, 0x01, 0xD0,
  0x37, 0x50, 0x1D, 0x03, 0x75, 0x02, 0xD0, 0x47, 0x50, 0x4D, 0x06, 0x75, 0x09, 0xD0, 0xC7, 0x18,
  0x21, 0x24, 0xAF, 0x82, 0xC5, 0x21, 0x40, 0xDF, 0xE0, 0xE4, 0x0D, 0xFE, 0x0E, 0x40, 0xDF, 0xE0,
  0xE1,
  // "Ī" (U+012A)
  0x28, 0x09, 0x21, 0x20, 0x9F, 0xF8, 0x13, 0x09, 0xFF, 0x81, 0x30, 0x9F, 0xF0, 0x38, 0x09, 0x80,
  0x00, 0x2F, 0xF9, 0x04, 0x02, 0xFF, 0x90, 0x40, 0x2F, 0xF9, 0x84, 0x40, 0x12, 0x5C, 0xF8, 0x2D,
  0x62, 0x16, 0x0C, 0xD0, 0xE0, 0x17, 0x20, 0x7D, 0x09, 0x73, 0x05, 0xD0, 0x77, 0x30, 0x4D, 0x06,
  0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04,
  0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67,
  0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D,
  0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73,
  0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0,
  0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30,
  0x4D, 0x06, 0x73, 0x05, 0xD0, 0x77, 0x30, 0x7D, 0x09, 0x73, 0x0C, 0xD0, 0xE6, 0x82, 0x12, 0x5C,
  0xF8, 0x4D, 0x52, 0x10, 0x2F, 0xF9, 0x04, 0x02, 0xFF, 0x90, 0x40, 0x2F, 0xF9, 0x04,
  // "ī" (U+012B)
  0x18, 0x09, 0x21, 0x10, 0x9F, 0xF0, 0x30, 0x9F, 0xF0, 0x30, 0x9F, 0xF0, 0x38, 0x09, 0x95, 0x00,
  0x7F, 0xA0, 0x35, 0x07, 0xFA, 0x03, 0x50, 0x7F, 0xA0, 0x36, 0x81, 0x24, 0xAE, 0x03, 0x72, 0x09,
  0xD0, 0x37, 0x20, 0x4D, 0x03, 0x72, 0x02, 0xD0, 0x37, 0x20, 0x1D, 0x03, 0x72, 0x01, 0xD0, 0x37,
  0x20, 0x1D, 0x03, 0x72, 0x01, 0xD0, 0x37, 0x20, 0x1D, 0x03, 0x72, 0x01, 0xD0, 0x37, 0x20, 0x1D,
  0x03, 0x72, 0x01, 0xD0, 0x37, 0x20, 0x1D, 0x03, 0x72, 0x01, 0xD0, 0x37, 0x20, 0x1D, 0x03, 0x72,
  0x01, 0xD0, 0x37, 0x20, 0x1D, 0x03, 0x72, 0x01, 0xD0, 0x37, 0x20, 0x1D, 0x03, 0x72, 0x01, 0xD0,
  0x37, 0x20, 0x1D, 0x03, 0x72, 0x01, 0xD0, 0x37, 0x20, 0x2D, 0x04, 0x72, 0x04, 0xD0, 0x67, 0x20,
  0x9D, 0x0C, 0x58, 0x21, 0x24, 0xAF, 0x84, 0xC5, 0x21, 0x0D, 0xFE, 0x81, 0xE0, 0xDF, 0xE8, 0x1E,
  0x0D, 0xFE, 0x0E,
  // "Ĭ" (U+012C)
  0x10, 0x8A, 0x01, 0x71, 0x08, 0xA2, 0x07, 0xA0, 0x67, 0x18, 0x1D, 0xFE, 0x20, 0x3A, 0x0E, 0x02,
  0x60, 0x8A, 0x0B, 0x30, 0xEA, 0x85, 0xE7, 0x20, 0x14, 0xBB, 0x06, 0x30, 0x7F, 0xC0, 0xE5, 0x0C,
  0xFB, 0x05, 0x50, 0x10, 0xCF, 0x90, 0x67, 0x18, 0x65, 0xAD, 0xFE, 0xC8, 0x28, 0x09, 0x84, 0x00,
  0x2F, 0xF9, 0x04, 0x02, 0xFF, 0x90, 0x40, 0x2F, 0xF9, 0x84, 0x40, 0x12, 0x5C, 0xF8, 0x2D, 0x62,
  0x16, 0x0C, 0xD0, 0xE0, 0x17, 0x20, 0x7D, 0x09, 0x73, 0x05, 0xD0, 0x77, 0x30, 0x4D, 0x06, 0x73,
  0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0,
  0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30,
  0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06,
  0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04,
  0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67,
  0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D,
  0x06, 0x73, 0x05, 0xD0, 0x77, 0x30, 0x7D, 0x09, 0x73, 0x0C, 0xD0, 0xE6, 0x82, 0x12, 0x5C, 0xF8,
  0x4D, 0x52, 0x10, 0x2F, 0xF9, 0x04, 0x02, 0xFF, 0x90, 0x40, 0x2F, 0xF9, 0x04,
  // "ĭ" (U+012D)
  0x08, 0xA0, 0x17, 0x10, 0x8A, 0x10, 0x7A, 0x06, 0x71, 0x83, 0xDF, 0xE0, 0x3A, 0x0E, 0x02, 0x60,
  0x8A, 0x0B, 0x20, 0xEA, 0x85, 0xE7, 0x20, 0x14, 0xBB, 0x06, 0x20, 0x7F, 0xC0, 0xE4, 0x0C, 0xFB,
  0x05, 0x40, 0x10, 0xCF, 0x90, 0x67, 0x86, 0x5A, 0xDF, 0xEC, 0x82, 0x80, 0x9A, 0x10, 0x07, 0xFA,
  0x03, 0x50, 0x7F, 0xA0, 0x35, 0x07, 0xFA, 0x03, 0x68, 0x12, 0x4A, 0xE0, 0x37, 0x20, 0x9D, 0x03,
  0x72, 0x04, 0xD0, 0x37, 0x20, 0x2D, 0x03, 0x72, 0x01, 0xD0, 0x37, 0x20, 0x1D, 0x03, 0x72, 0x01,
  0xD0, 0x37, 0x20, 0x1D, 0x03, 0x72, 0x01, 0xD0, 0x37, 0x20, 0x1D, 0x03, 0x72, 0x01, 0xD0, 0x37,
  0x20, 0x1D, 0x03, 0x72, 0x01, 0xD0, 0x37, 0x20, 0x1D, 0x03, 0x72, 0x01, 0xD0, 0x37, 0x20, 0x1D,
  0x03, 0x72, 0x01, 0xD0, 0x37, 0x20, 0x1D, 0x03, 0x72, 0x01, 0xD0, 0x37, 0x20, 0x1D, 0x03, 0x72,
  0x01, 0xD0, 0x37, 0x20, 0x1D, 0x03, 0x72, 0x02, 0xD0, 0x47, 0x20, 0x4D, 0x06, 0x72, 0x09, 0xD0,
  0xC5, 0x82, 0x12, 0x4A, 0xF8, 0x4C, 0x52, 0x10, 0xDF, 0xE8, 0x1E, 0x0D, 0xFE, 0x81, 0xE0, 0xDF,
  0xE0, 0xE0,
  // "Į" (U+012E)
  0x02, 0xFF, 0x90, 0x40, 0x2F, 0xF9, 0x04, 0x02, 0xFF, 0x98, 0x44, 0x01, 0x25, 0xCF, 0x82, 0xD6,
  0x21, 0x60, 0xCD, 0x0E, 0x01, 0x72, 0x07, 0xD0, 0x97, 0x30, 0x5D, 0x07, 0x73, 0x04, 0xD0, 0x67,
  0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D,
  0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73,
  0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0,
  0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30,
  0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06,
  0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04,
  0xD0, 0x67, 0x30, 0x5D, 0x07, 0x73, 0x07, 0xD0, 0x97, 0x30, 0xCD, 0x0E, 0x68, 0x21, 0x25, 0xCF,
  0x84, 0xD5, 0x21, 0x02, 0xFF, 0x90, 0x40, 0x2F, 0xF9, 0x04, 0x02, 0xFF, 0x90, 0x47, 0x09, 0xA0,
  0xB0, 0x17, 0x30, 0x10, 0xCA, 0x0A, 0x75, 0x0C, 0xA0, 0xC7, 0x50, 0x7B, 0x05, 0x75, 0x0E, 0xB7,
  0x50, 0x4B, 0x0D, 0x75, 0x06, 0xB0, 0xC7, 0x50, 0x7B, 0x0E, 0x75, 0x06, 0xC0, 0x57, 0x40, 0x4C,
  0x85, 0xE7, 0x20, 0x13, 0x36, 0x0E, 0xFA, 0x09, 0x60, 0x6F, 0xA0, 0x97, 0x07, 0xF9, 0x08, 0x71,
  0x86, 0x28, 0xCE, 0xFE, 0xB6, 0x30,
  // "į" (U+012F)
  0x58, 0x37, 0xDE, 0xB3, 0x72, 0x06, 0xD0, 0x17, 0x10, 0xAD, 0x06, 0x71, 0x0B, 0xD0, 0x77, 0x10,
  0xAD, 0x06, 0x71, 0x06, 0xD0, 0x17, 0x28, 0x37, 0xDE, 0xC3, 0x80, 0x9D, 0x20, 0x07, 0xFA, 0x03,
  0x40, 0x7F, 0xA0, 0x34, 0x07, 0xFA, 0x03, 0x58, 0x12, 0x4A, 0xE0, 0x37, 0x10, 0x9D, 0x03, 0x71,
  0x04, 0xD0, 0x37, 0x10, 0x2D, 0x03, 0x71, 0x01, 0xD0, 0x37, 0x10, 0x1D, 0x03, 0x71, 0x01, 0xD0,
  0x37, 0x10, 0x1D, 0x03, 0x71, 0x01, 0xD0, 0x37, 0x10, 0x1D, 0x03, 0x71, 0x01, 0xD0, 0x37, 0x10,
  0x1D, 0x03, 0x71, 0x01, 0xD0, 0x37, 0x10, 0x1D, 0x03, 0x71, 0x01, 0xD0, 0x37, 0x10, 0x1D, 0x03,
  0x71, 0x01, 0xD0, 0x37, 0x10, 0x1D, 0x03, 0x71, 0x01, 0xD0, 0x37, 0x10, 0x1D, 0x03, 0x71, 0x01,
  0xD0, 0x37, 0x10, 0x1D, 0x03, 0x71, 0x02, 0xD0, 0x47, 0x10, 0x4D, 0x06, 0x71, 0x09, 0xD0, 0xC4,
  0x82, 0x12, 0x4A, 0xF8, 0x3C, 0x52, 0x1D, 0xFE, 0x0E, 0x0D, 0xFE, 0x0E, 0x0D, 0xFE, 0x0E, 0x60,
  0x9A, 0x0B, 0x01, 0x71, 0x01, 0x0C, 0xA0, 0xA7, 0x30, 0xCA, 0x0C, 0x73, 0x07, 0xB0, 0x57, 0x30,
  0xEB, 0x73, 0x04, 0xB0, 0xD7, 0x30, 0x6B, 0x0C, 0x73, 0x07, 0xB0, 0xE7, 0x30, 0x6C, 0x05, 0x72,
  0x04, 0xC8, 0x5E, 0x72, 0x01, 0x33, 0x40, 0xEF, 0xA0, 0x94, 0x06, 0xFA, 0x09, 0x50, 0x7F, 0x90,
  0x86, 0x86, 0x28, 0xCE, 0xFE, 0xB6, 0x20,
  // "İ" (U+0130)
  0x68, 0x34, 0xCE, 0xD5, 0x74, 0x03, 0xD0, 0x57, 0x30, 0x7D, 0x0A, 0x73, 0x09, 0xD0, 0xB7, 0x30,
  0x7D, 0x0A, 0x73, 0x03, 0xD0, 0x57, 0x48, 0x34, 0xCE, 0xD5, 0x80, 0x9D, 0x00, 0x02, 0xFF, 0x90,
  0x40, 0x2F, 0xF9, 0x04, 0x02, 0xFF, 0x98, 0x44, 0x01, 0x25, 0xCF, 0x82, 0xD6, 0x21, 0x60, 0xCD,
  0x0E, 0x01, 0x72, 0x07, 0xD0, 0x97, 0x30, 0x5D, 0x07, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06,
  0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04,
  0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67,
  0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D,
  0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73,
  0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0,
  0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30,
  0x5D, 0x07, 0x73, 0x07, 0xD0, 0x97, 0x30, 0xCD, 0x0E, 0x68, 0x21, 0x25, 0xCF, 0x84, 0xD5, 0x21,
  0x02, 0xFF, 0x90, 0x40, 0x2F, 0xF9, 0x04, 0x02, 0xFF, 0x90, 0x40,
  // "ı" (U+0131)
  0x07, 0xFA, 0x03, 0x40, 0x7F, 0xA0, 0x34, 0x07, 0xFA, 0x03, 0x58, 0x12, 0x4A, 0xE0, 0x37, 0x10,
  0x9D, 0x03, 0x71, 0x04, 0xD0, 0x37, 0x10, 0x2D, 0x03, 0x71, 0x01, 0xD0, 0x37, 0x10, 0x1D, 0x03,
  0x71, 0x01, 0xD0, 0x37, 0x10, 0x1D, 0x03, 0x71, 0x01, 0xD0, 0x37, 0x10, 0x1D, 0x03, 0x71, 0x01,
  0xD0, 0x37, 0x10, 0x1D, 0x03, 0x71, 0x01, 0xD0, 0x37, 0x10, 0x1D, 0x03, 0x71, 0x01, 0xD0, 0x37,
  0x10, 0x1D, 0x03, 0x71, 0x01, 0xD0, 0x37, 0x10, 0x1D, 0x03, 0x71, 0x01, 0xD0, 0x37, 0x10, 0x1D,
  0x03, 0x71, 0x01, 0xD0, 0x37, 0x10, 0x1D, 0x03, 0x71, 0x02, 0xD0, 0x47, 0x10, 0x4D, 0x06, 0x71,
  0x09, 0xD0, 0xC4, 0x82, 0x12, 0x4A, 0xF8, 0x3C, 0x52, 0x1D, 0xFE, 0x0E, 0x0D, 0xFE, 0x0E, 0x0D,
  0xFE, 0x0E,
  // "Ĳ" (U+0132)
  0x02, 0xFF, 0x90, 0x43, 0x0E, 0xFF, 0x07, 0x02, 0xFF, 0x90, 0x43, 0x0E, 0xFF, 0x07, 0x02, 0xFF,
  0x90, 0x43, 0x0E, 0xFF, 0x84, 0x70, 0x12, 0x5C, 0xF8, 0x2D, 0x62, 0x14, 0x82, 0x12, 0x4B, 0xF8,
  0x2E, 0x73, 0x16, 0x0C, 0xD0, 0xE0, 0x17, 0x40, 0xAE, 0x02, 0x72, 0x07, 0xD0, 0x97, 0x50, 0x4D,
  0x0C, 0x73, 0x05, 0xD0, 0x77, 0x50, 0x2D, 0x09, 0x73, 0x04, 0xD0, 0x67, 0x50, 0x1D, 0x09, 0x73,
  0x04, 0xD0, 0x67, 0x50, 0x1D, 0x09, 0x73, 0x04, 0xD0, 0x67, 0x50, 0x1D, 0x09, 0x73, 0x04, 0xD0,
  0x67, 0x50, 0x1D, 0x09, 0x73, 0x04, 0xD0, 0x67, 0x50, 0x1D, 0x09, 0x73, 0x04, 0xD0, 0x67, 0x50,
  0x1D, 0x09, 0x73, 0x04, 0xD0, 0x67, 0x50, 0x1D, 0x09, 0x73, 0x04, 0xD0, 0x67, 0x50, 0x1D, 0x09,
  0x73, 0x04, 0xD0, 0x67, 0x50, 0x1D, 0x09, 0x73, 0x04, 0xD0, 0x67, 0x50, 0x1D, 0x09, 0x73, 0x04,
  0xD0, 0x67, 0x50, 0x1D, 0x09, 0x73, 0x04, 0xD0, 0x67, 0x50, 0x1D, 0x09, 0x73, 0x04, 0xD0, 0x67,
  0x50, 0x1D, 0x09, 0x73, 0x04, 0xD0, 0x67, 0x50, 0x1D, 0x09, 0x73, 0x04, 0xD0, 0x67, 0x50, 0x1D,
  0x09, 0x73, 0x04, 0xD0, 0x67, 0x50, 0x1D, 0x09, 0x73, 0x04, 0xD0, 0x67, 0x50, 0x1D, 0x09, 0x73,
  0x04, 0xD0, 0x67, 0x50, 0x1D, 0x09, 0x73, 0x04, 0xD0, 0x67, 0x50, 0x1D, 0x09, 0x73, 0x04, 0xD0,
  0x67, 0x50, 0x1D, 0x09, 0x73, 0x04, 0xD0, 0x67, 0x50, 0x1D, 0x09, 0x73, 0x04, 0xD0, 0x67, 0x50,
  0x1D, 0x09, 0x73, 0x04, 0xD0, 0x67, 0x50, 0x1D, 0x09, 0x73, 0x04, 0xD0, 0x67, 0x50, 0x1D, 0x09,
  0x73, 0x04, 0xD0, 0x67, 0x50, 0x1D, 0x09, 0x73, 0x04, 0xD0, 0x67, 0x50, 0x1D, 0x09, 0x73, 0x04,
  0xD0, 0x67, 0x50, 0x1D, 0x09, 0x73, 0x04, 0xD0, 0x67, 0x50, 0x1D, 0x09, 0x73, 0x04, 0xD0, 0x67,
  0x50, 0x1D, 0x09, 0x73, 0x05, 0xD0, 0x77, 0x50, 0x1D, 0x09, 0x73, 0x07, 0xD0, 0x97, 0x50, 0x1D,
  0x09, 0x73, 0x0C, 0xD0, 0xE7, 0x50, 0x1D, 0x09, 0x68, 0x21, 0x25, 0xCF, 0x82, 0xD5, 0x21, 0x71,
  0x01, 0xD0, 0x95, 0x02, 0xFF, 0x90, 0x47, 0x01, 0xD0, 0x95, 0x02, 0xFF, 0x90, 0x47, 0x01, 0xD0,
  0x95, 0x02, 0xFF, 0x90, 0x47, 0x01, 0xD0, 0x97, 0x77, 0x71, 0x01, 0xD0, 0x97, 0x77, 0x71, 0x02,
  0xD0, 0x87, 0x77, 0x71, 0x02, 0xD0, 0x77, 0x77, 0x71, 0x04, 0xD0, 0x67, 0x77, 0x71, 0x06, 0xD0,
  0x37, 0x77, 0x71, 0x09, 0xD0, 0x17, 0x77, 0x71, 0x0E, 0xC0, 0xC7, 0x77, 0x71, 0x05, 0xD0, 0x67,
  0x77, 0x71, 0x0D, 0xC0, 0xE7, 0x77, 0x70, 0x10, 0xBD, 0x05, 0x77, 0x74, 0x82, 0x24, 0x8E, 0xD0,
  0x97, 0x77, 0x40, 0x7F, 0x90, 0x87, 0x77, 0x50, 0x7E, 0x0C, 0x04, 0x77, 0x76, 0x85, 0x7F, 0xED,
  0xB7, 0x37, 0x50,
  // "ĳ" (U+0133)
  0x58, 0x37, 0xDE, 0xB3, 0x75, 0x83, 0x8D, 0xEB, 0x35, 0x06, 0xD0, 0x17, 0x30, 0x8C, 0x0E, 0x01,
  0x40, 0xAD, 0x06, 0x73, 0x0D, 0xD0, 0x54, 0x0B, 0xD0, 0x77, 0x30, 0xED, 0x06, 0x40, 0xAD, 0x06,
  0x73, 0x0D, 0xD0, 0x54, 0x06, 0xD0, 0x17, 0x30, 0x8C, 0x0E, 0x01, 0x58, 0x37, 0xDE, 0xC3, 0x75,
  0x83, 0x8D, 0xEB, 0x38, 0x0B, 0x81, 0x00, 0x7F, 0xA0, 0x36, 0x08, 0xFA, 0x01, 0x07, 0xFA, 0x03,
  0x60, 0x8F, 0xA0, 0x10, 0x7F, 0xA0, 0x36, 0x08, 0xFA, 0x83, 0x10, 0x24, 0xAE, 0x03, 0x78, 0x12,
  0x5B, 0xE0, 0x14, 0x09, 0xD0, 0x37, 0x30, 0xBD, 0x01, 0x40, 0x4D, 0x03, 0x73, 0x05, 0xD0, 0x14,
  0x02, 0xD0, 0x37, 0x30, 0x3D, 0x01, 0x40, 0x1D, 0x03, 0x73, 0x02, 0xD0, 0x14, 0x01, 0xD0, 0x37,
  0x30, 0x2D, 0x01, 0x40, 0x1D, 0x03, 0x73, 0x02, 0xD0, 0x14, 0x01, 0xD0, 0x37, 0x30, 0x2D, 0x01,
  0x40, 0x1D, 0x03, 0x73, 0x02, 0xD0, 0x14, 0x01, 0xD0, 0x37, 0x30, 0x2D, 0x01, 0x40, 0x1D, 0x03,
  0x73, 0x02, 0xD0, 0x14, 0x01, 0xD0, 0x37, 0x30, 0x2D, 0x01, 0x40, 0x1D, 0x03, 0x73, 0x02, 0xD0,
  0x14, 0x01, 0xD0, 0x37, 0x30, 0x2D, 0x01, 0x40, 0x1D, 0x03, 0x73, 0x02, 0xD0, 0x14, 0x01, 0xD0,
  0x37, 0x30, 0x2D, 0x01, 0x40, 0x1D, 0x03, 0x73, 0x02, 0xD0, 0x14, 0x01, 0xD0, 0x37, 0x30, 0x2D,
  0x01, 0x40, 0x1D, 0x03, 0x73, 0x02, 0xD0, 0x14, 0x01, 0xD0, 0x37, 0x30, 0x2D, 0x01, 0x40, 0x1D,
  0x03, 0x73, 0x02, 0xD0, 0x14, 0x01, 0xD0, 0x37, 0x30, 0x2D, 0x01, 0x40, 0x2D, 0x04, 0x73, 0x02,
  0xD0, 0x14, 0x04, 0xD0, 0x67, 0x30, 0x2D, 0x01, 0x40, 0x9D, 0x0C, 0x73, 0x02, 0xD8, 0x31, 0x12,
  0x4A, 0xF8, 0x2C, 0x52, 0x16, 0x02, 0xD0, 0x10, 0xDF, 0xE0, 0xE6, 0x02, 0xD0, 0x10, 0xDF, 0xE0,
  0xE6, 0x02, 0xD0, 0x10, 0xDF, 0xE0, 0xE6, 0x02, 0xD0, 0x17, 0x77, 0x03, 0xD0, 0x17, 0x77, 0x03,
  0xD7, 0x77, 0x10, 0x3D, 0x77, 0x71, 0x05, 0xC0, 0xE7, 0x77, 0x10, 0x6C, 0x0C, 0x77, 0x71, 0x09,
  0xC0, 0x97, 0x77, 0x10, 0xCC, 0x06, 0x77, 0x70, 0x2D, 0x01, 0x77, 0x70, 0x9C, 0x0B, 0x77, 0x70,
  0x5D, 0x03, 0x77, 0x48, 0x12, 0x4B, 0xD0, 0x97, 0x74, 0x05, 0xF0, 0xA7, 0x75, 0x05, 0xD0, 0xE0,
  0x77, 0x76, 0x84, 0x5F, 0xED, 0xA5, 0x70,
  // "Ĵ" (U+0134)
  0x70, 0x38, 0x01, 0x77, 0x60, 0xCD, 0x04, 0x74, 0x05, 0xE0, 0xC7, 0x40, 0xDF, 0x05, 0x72, 0x08,
  0xB0, 0xC0, 0x7B, 0x0D, 0x71, 0x02, 0xB8, 0x2E, 0x20, 0x9B, 0x08, 0x70, 0xBA, 0x0E, 0x03, 0x30,
  0xBB, 0x02, 0x50, 0x6A, 0x0E, 0x04, 0x50, 0xBA, 0x0C, 0x48, 0x32, 0xEF, 0xE4, 0x70, 0xBA, 0x08,
  0x38, 0x28, 0xFE, 0x37, 0x20, 0xAA, 0x80, 0x99, 0x40, 0x0E, 0xFF, 0x07, 0x30, 0xEF, 0xF0, 0x73,
  0x0E, 0xFF, 0x07, 0x38, 0x21, 0x24, 0xBF, 0x82, 0xE7, 0x31, 0x71, 0x0A, 0xE0, 0x27, 0x40, 0x4D,
  0x0C, 0x75, 0x02, 0xD0, 0x97, 0x50, 0x1D, 0x09, 0x75, 0x01, 0xD0, 0x97, 0x50, 0x1D, 0x09, 0x75,
  0x01, 0xD0, 0x97, 0x50, 0x1D, 0x09, 0x75, 0x01, 0xD0, 0x97, 0x50, 0x1D, 0x09, 0x75, 0x01, 0xD0,
  0x97, 0x50, 0x1D, 0x09, 0x75, 0x01, 0xD0, 0x97, 0x50, 0x1D, 0x09, 0x75, 0x01, 0xD0, 0x97, 0x50,
  0x1D, 0x09, 0x75, 0x01, 0xD0, 0x97, 0x50, 0x1D, 0x09, 0x75, 0x01, 0xD0, 0x97, 0x50, 0x1D, 0x09,
  0x75, 0x01, 0xD0, 0x97, 0x50, 0x1D, 0x09, 0x75, 0x01, 0xD0, 0x97, 0x50, 0x1D, 0x09, 0x75, 0x01,
  0xD0, 0x97, 0x50, 0x1D, 0x09, 0x75, 0x01, 0xD0, 0x97, 0x50, 0x1D, 0x09, 0x75, 0x01, 0xD0, 0x97,
  0x50, 0x1D, 0x09, 0x75, 0x01, 0xD0, 0x97, 0x50, 0x1D, 0x09, 0x75, 0x01, 0xD0, 0x97, 0x50, 0x1D,
  0x09, 0x75, 0x01, 0xD0, 0x97, 0x50, 0x1D, 0x09, 0x75, 0x01, 0xD0, 0x97, 0x50, 0x1D, 0x09, 0x75,
  0x01, 0xD0, 0x97, 0x50, 0x1D, 0x09, 0x75, 0x02, 0xD0, 0x87, 0x50, 0x2D, 0x07, 0x75, 0x04, 0xD0,
  0x67, 0x50, 0x6D, 0x03, 0x75, 0x09, 0xD0, 0x17, 0x50, 0xEC, 0x0C, 0x75, 0x05, 0xD0, 0x67, 0x50,
  0xDC, 0x0E, 0x74, 0x01, 0x0B, 0xD0, 0x57, 0x18, 0x22, 0x48, 0xED, 0x09, 0x71, 0x07, 0xF9, 0x08,
  0x72, 0x07, 0xE0, 0xC0, 0x47, 0x38, 0x57, 0xFE, 0xDB, 0x73, 0x75,
  // "ĵ" (U+0135)
  0x50, 0x38, 0x01, 0x77, 0x30, 0xCD, 0x04, 0x71, 0x05, 0xE0, 0xC7, 0x10, 0xDF, 0x05, 0x60, 0x8B,
  0x0C, 0x07, 0xB0, 0xD5, 0x02, 0xB8, 0x2E, 0x20, 0x9B, 0x08, 0x40, 0xBA, 0x0E, 0x03, 0x30, 0xBB,
  0x02, 0x20, 0x6A, 0x0E, 0x04, 0x50, 0xBA, 0x85, 0xC0, 0x2E, 0xFE, 0x47, 0x0B, 0xA8, 0x38, 0x8F,
  0xE3, 0x72, 0x0A, 0xA8, 0x09, 0x96, 0x00, 0x8F, 0xA0, 0x15, 0x08, 0xFA, 0x01, 0x50, 0x8F, 0xA0,
  0x16, 0x81, 0x24, 0xBE, 0x01, 0x72, 0x0B, 0xD0, 0x17, 0x20, 0x5D, 0x01, 0x72, 0x03, 0xD0, 0x17,
  0x20, 0x2D, 0x01, 0x72, 0x02, 0xD0, 0x17, 0x20, 0x2D, 0x01, 0x72, 0x02, 0xD0, 0x17, 0x20, 0x2D,
  0x01, 0x72, 0x02, 0xD0, 0x17, 0x20, 0x2D, 0x01, 0x72, 0x02, 0xD0, 0x17, 0x20, 0x2D, 0x01, 0x72,
  0x02, 0xD0, 0x17, 0x20, 0x2D, 0x01, 0x72, 0x02, 0xD0, 0x17, 0x20, 0x2D, 0x01, 0x72, 0x02, 0xD0,
  0x17, 0x20, 0x2D, 0x01, 0x72, 0x02, 0xD0, 0x17, 0x20, 0x2D, 0x01, 0x72, 0x02, 0xD0, 0x17, 0x20,
  0x2D, 0x01, 0x72, 0x02, 0xD0, 0x17, 0x20, 0x2D, 0x01, 0x72, 0x02, 0xD0, 0x17, 0x20, 0x2D, 0x01,
  0x72, 0x02, 0xD0, 0x17, 0x20, 0x2D, 0x01, 0x72, 0x03, 0xD0, 0x17, 0x20, 0x3D, 0x73, 0x03, 0xD7,
  0x30, 0x5C, 0x0E, 0x73, 0x06, 0xC0, 0xC7, 0x30, 0x9C, 0x09, 0x73, 0x0C, 0xC0, 0x67, 0x20, 0x2D,
  0x01, 0x72, 0x09, 0xC0, 0xB7, 0x20, 0x5D, 0x03, 0x68, 0x12, 0x4B, 0xD0, 0x96, 0x05, 0xF0, 0xA7,
  0x05, 0xD0, 0xE0, 0x77, 0x18, 0x45, 0xFE, 0xDA, 0x57, 0x30,
  // "Ķ" (U+0136)
  0x02, 0xFF, 0x96, 0x0E, 0xFB, 0x0B, 0x30, 0x2F, 0xF9, 0x60, 0xEF, 0xB0, 0xB3, 0x02, 0xFF, 0x96,
  0x0E, 0xFB, 0x0B, 0x48, 0x21, 0x25, 0xCF, 0x82, 0xD6, 0x21, 0x68, 0x11, 0x3B, 0xE8, 0x1B, 0x41,
  0x71, 0x0C, 0xD0, 0xE0, 0x17, 0x40, 0x4D, 0x06, 0x74, 0x06, 0xD0, 0x97, 0x50, 0x7C, 0x05, 0x75,
  0x04, 0xD0, 0x77, 0x50, 0xDB, 0x07, 0x76, 0x04, 0xD0, 0x67, 0x40, 0x8B, 0x09, 0x77, 0x04, 0xD0,
  0x67, 0x30, 0x3B, 0x0C, 0x77, 0x10, 0x4D, 0x06, 0x73, 0x0D, 0xA0, 0xE0, 0x27, 0x71, 0x04, 0xD0,
  0x67, 0x20, 0x9B, 0x05, 0x77, 0x20, 0x4D, 0x06, 0x71, 0x05, 0xB0, 0x87, 0x73, 0x04, 0xD0, 0x67,
  0x01, 0x0E, 0xA0, 0xC7, 0x74, 0x04, 0xD0, 0x67, 0x0B, 0xA0, 0xE0, 0x17, 0x74, 0x04, 0xD0, 0x66,
  0x07, 0xB0, 0x47, 0x75, 0x04, 0xD0, 0x65, 0x03, 0xB0, 0x87, 0x76, 0x04, 0xD0, 0x65, 0x0D, 0xA0,
  0xB7, 0x77, 0x04, 0xD0, 0x64, 0x09, 0xA0, 0xE0, 0x17, 0x77, 0x04, 0xD0, 0x63, 0x05, 0xB0, 0x87,
  0x77, 0x10, 0x4D, 0x06, 0x20, 0x10, 0xEB, 0x0E, 0x01, 0x77, 0x70, 0x4D, 0x06, 0x20, 0xBD, 0x0B,
  0x77, 0x70, 0x4D, 0x81, 0x60, 0x7F, 0x05, 0x77, 0x60, 0x4D, 0x06, 0x03, 0xA0, 0xDD, 0x0E, 0x01,
  0x77, 0x50, 0x4D, 0x84, 0x7D, 0xFC, 0x1C, 0xD0, 0xA7, 0x75, 0x04, 0xD8, 0x4E, 0xFE, 0x10, 0x3E,
  0x05, 0x77, 0x40, 0x4F, 0x03, 0x30, 0x9D, 0x0E, 0x01, 0x77, 0x30, 0x4E, 0x06, 0x40, 0x10, 0xED,
  0x09, 0x77, 0x30, 0x4D, 0x09, 0x60, 0x7E, 0x04, 0x77, 0x20, 0x4D, 0x06, 0x70, 0xCD, 0x0D, 0x77,
  0x20, 0x4D, 0x06, 0x70, 0x3E, 0x08, 0x77, 0x10, 0x4D, 0x06, 0x71, 0x0A, 0xE0, 0x37, 0x70, 0x4D,
  0x06, 0x71, 0x01, 0x0E, 0xD0, 0xD7, 0x70, 0x4D, 0x06, 0x72, 0x07, 0xE0, 0x87, 0x60, 0x4D, 0x06,
  0x73, 0x0D, 0xE0, 0x27, 0x50, 0x4D, 0x06, 0x73, 0x04, 0xE0, 0xC7, 0x50, 0x4D, 0x06, 0x74, 0x0A,
  0xE0, 0x77, 0x40, 0x4D, 0x07, 0x74, 0x01, 0x0E, 0xE0, 0x37, 0x30, 0x6D, 0x09, 0x75, 0x07, 0xE0,
  0xD0, 0x17, 0x20, 0xCD, 0x0E, 0x01, 0x75, 0x0D, 0xE0, 0xC0, 0x14, 0x82, 0x12, 0x5C, 0xF8, 0x2D,
  0x62, 0x17, 0x20, 0x3F, 0x83, 0xD6, 0x10, 0x2F, 0xF9, 0x73, 0x06, 0xFA, 0x01, 0x02, 0xFF, 0x97,
  0x40, 0x50, 0xEF, 0x01, 0x02, 0xFF, 0x97, 0x68, 0x26, 0xAD, 0xEB, 0x01, 0x80, 0x9F, 0x30, 0x0B,
  0xC0, 0x37, 0x77, 0x73, 0x0E, 0xB0, 0xD7, 0x77, 0x73, 0x01, 0xC0, 0x77, 0x77, 0x73, 0x03, 0xC0,
  0x17, 0x77, 0x73, 0x05, 0xB0, 0x97, 0x77, 0x74, 0x08, 0xB0, 0x27, 0x77, 0x74, 0x0B, 0xA0, 0xA7,
  0x77, 0x75, 0x0E, 0xA0, 0x37, 0x77, 0x74, 0x02, 0xA0, 0xA7, 0x77, 0x75, 0x04, 0xA0, 0x27, 0x75,
  // "ķ" (U+0137)
  0x01, 0xFA, 0x0C, 0x77, 0x60, 0x1F, 0xA0, 0xC7, 0x76, 0x01, 0xFA, 0x0C, 0x77, 0x78, 0x21, 0x37,
  0xED, 0x0C, 0x77, 0x73, 0x02, 0xD0, 0xC7, 0x77, 0x40, 0xBC, 0x0C, 0x77, 0x74, 0x09, 0xC0, 0xC7,
  0x77, 0x40, 0x8C, 0x0C, 0x77, 0x74, 0x08, 0xC0, 0xC7, 0x77, 0x40, 0x8C, 0x0C, 0x77, 0x74, 0x08,
  0xC0, 0xC7, 0x77, 0x40, 0x8C, 0x0C, 0x77, 0x74, 0x08, 0xC0, 0xC7, 0x77, 0x40, 0x8C, 0x0C, 0x77,
  0x74, 0x08, 0xC0, 0xC6, 0x0C, 0xFB, 0x09, 0x70, 0x8C, 0x0C, 0x60, 0xCF, 0xB0, 0x97, 0x08, 0xC0,
  0xC6, 0x0C, 0xFB, 0x09, 0x70, 0x8C, 0x0C, 0x68, 0x11, 0x3B, 0xE8, 0x19, 0x31, 0x70, 0x8C, 0x0C,
  0x71, 0x04, 0xC0, 0xE0, 0x37, 0x30, 0x8C, 0x0C, 0x71, 0x07, 0xB0, 0xD0, 0x27, 0x40, 0x8C, 0x0C,
  0x71, 0x0D, 0xA0, 0xE0, 0x27, 0x50, 0x8C, 0x0C, 0x70, 0x6B, 0x03, 0x76, 0x08, 0xC0, 0xC6, 0x02,
  0x0E, 0xA0, 0x67, 0x70, 0x8C, 0x0C, 0x60, 0xCA, 0x09, 0x77, 0x10, 0x8C, 0x0C, 0x50, 0x9A, 0x0C,
  0x77, 0x20, 0x8C, 0x0C, 0x40, 0x6A, 0x0E, 0x02, 0x77, 0x20, 0x8C, 0x0B, 0x30, 0x3B, 0x04, 0x77,
  0x30, 0x8C, 0x0B, 0x20, 0x10, 0xDB, 0x07, 0x77, 0x30, 0x8C, 0x0B, 0x20, 0xBC, 0x0E, 0x01, 0x77,
  0x20, 0x8C, 0x81, 0xA0, 0x7E, 0x0A, 0x77, 0x20, 0x8C, 0x0A, 0x04, 0xA0, 0xBD, 0x03, 0x77, 0x10,
  0x8C, 0x83, 0xBE, 0xF5, 0x1D, 0x0C, 0x77, 0x10, 0x8E, 0x06, 0x20, 0x8D, 0x06, 0x77, 0x08, 0xD0,
  0x73, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x60, 0x8C, 0x0C, 0x50, 0x7D, 0x09, 0x76, 0x08, 0xC0, 0xC6,
  0x0E, 0xD0, 0x37, 0x50, 0x8C, 0x0C, 0x60, 0x7D, 0x0C, 0x75, 0x08, 0xC0, 0xC7, 0x0D, 0xD0, 0x57,
  0x40, 0x8C, 0x0C, 0x70, 0x6D, 0x0E, 0x01, 0x73, 0x09, 0xC0, 0xC7, 0x10, 0xDD, 0x09, 0x73, 0x0B,
  0xC0, 0xE7, 0x10, 0x5E, 0x05, 0x71, 0x02, 0xE0, 0x47, 0x10, 0xBE, 0x04, 0x48, 0x21, 0x37, 0xEE,
  0x82, 0xE8, 0x31, 0x50, 0x20, 0xEE, 0x82, 0x82, 0x01, 0xFF, 0x01, 0x50, 0x5F, 0x90, 0x70, 0x1F,
  0xF0, 0x16, 0x06, 0xF0, 0x70, 0x1F, 0xF0, 0x17, 0x83, 0x17, 0xBD, 0xEA, 0x07, 0x80, 0x9C, 0x70,
  0x0B, 0xC0, 0x37, 0x77, 0x40, 0xEB, 0x0D, 0x77, 0x74, 0x01, 0xC0, 0x77, 0x77, 0x40, 0x3C, 0x01,
  0x77, 0x74, 0x05, 0xB0, 0x97, 0x77, 0x50, 0x8B, 0x02, 0x77, 0x75, 0x0B, 0xA0, 0xA7, 0x77, 0x60,
  0xEA, 0x03, 0x77, 0x75, 0x02, 0xA0, 0xA7, 0x77, 0x60, 0x4A, 0x02, 0x77, 0x10,
  // "ĸ" (U+0138)
  0x01, 0xFA, 0x0C, 0x60, 0xCF, 0xB0, 0x92, 0x01, 0xFA, 0x0C, 0x60, 0xCF, 0xB0, 0x92, 0x01, 0xFA,
  0x0C, 0x60, 0xCF, 0xB0, 0x93, 0x82, 0x13, 0x7E, 0xD0, 0xC6, 0x81, 0x13, 0xBE, 0x81, 0x93, 0x16,
  0x02, 0xD0, 0xC7, 0x10, 0x4C, 0x0E, 0x03, 0x73, 0x0B, 0xC0, 0xC7, 0x10, 0x7B, 0x0D, 0x02, 0x74,
  0x09, 0xC0, 0xC7, 0x10, 0xDA, 0x0E, 0x02, 0x75, 0x08, 0xC0, 0xC7, 0x06, 0xB0, 0x37, 0x60, 0x8C,
  0x0C, 0x60, 0x20, 0xEA, 0x06, 0x77, 0x08, 0xC0, 0xC6, 0x0C, 0xA0, 0x97, 0x71, 0x08, 0xC0, 0xC5,
  0x09, 0xA0, 0xB7, 0x72, 0x08, 0xC0, 0xC4, 0x06, 0xA0, 0xD0, 0x17, 0x72, 0x08, 0xC0, 0xB3, 0x03,
  0xB0, 0x37, 0x73, 0x08, 0xC0, 0xB2, 0x01, 0x0D, 0xB0, 0x37, 0x73, 0x08, 0xC0, 0xB2, 0x0B, 0xC0,
  0xC7, 0x73, 0x08, 0xC8, 0x1A, 0x07, 0xE0, 0x77, 0x72, 0x08, 0xC0, 0xA0, 0x4A, 0x0D, 0xC0, 0xE0,
  0x17, 0x71, 0x08, 0xC8, 0x3B, 0xEF, 0x45, 0xD0, 0xA7, 0x71, 0x08, 0xE0, 0x62, 0x0C, 0xD0, 0x47,
  0x70, 0x8D, 0x07, 0x30, 0x4D, 0x0D, 0x77, 0x08, 0xC0, 0xC5, 0x0B, 0xD0, 0x77, 0x60, 0x8C, 0x0C,
  0x50, 0x3D, 0x0E, 0x01, 0x75, 0x08, 0xC0, 0xC6, 0x0A, 0xD0, 0xA7, 0x50, 0x8C, 0x0C, 0x60, 0x2E,
  0x04, 0x74, 0x08, 0xC0, 0xC7, 0x09, 0xD0, 0xD7, 0x40, 0x9C, 0x0C, 0x70, 0x10, 0xED, 0x08, 0x73,
  0x0B, 0xC0, 0xE7, 0x10, 0x7E, 0x04, 0x71, 0x02, 0xE0, 0x47, 0x10, 0xDD, 0x0E, 0x03, 0x48, 0x21,
  0x37, 0xEE, 0x82, 0xE8, 0x31, 0x50, 0x4F, 0x82, 0x82, 0x01, 0xFF, 0x01, 0x50, 0x8F, 0x90, 0x70,
  0x1F, 0xF0, 0x16, 0x07, 0xF0, 0x70, 0x1F, 0xF0, 0x17, 0x83, 0x27, 0xBD, 0xEA, 0x07,
  // "Ĺ" (U+0139)
  0x74, 0x80, 0x27, 0x77, 0x72, 0x04, 0xD0, 0xC7, 0x77, 0x20, 0xBC, 0x0E, 0x02, 0x77, 0x71, 0x04,
  0xD0, 0x47, 0x77, 0x20, 0xCC, 0x06, 0x77, 0x72, 0x05, 0xC0, 0x77, 0x77, 0x30, 0xEB, 0x07, 0x77,
  0x73, 0x08, 0xB0, 0x67, 0x77, 0x30, 0x2B, 0x05, 0x77, 0x74, 0x82, 0x8F, 0xE3, 0x80, 0xA9, 0x00,
  0x02, 0xFF, 0x90, 0x47, 0x60, 0x2F, 0xF9, 0x04, 0x76, 0x02, 0xFF, 0x90, 0x47, 0x78, 0x21, 0x25,
  0xCF, 0x82, 0xC5, 0x21, 0x77, 0x50, 0xDD, 0x0D, 0x77, 0x72, 0x07, 0xD0, 0x97, 0x77, 0x20, 0x5D,
  0x07, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77,
  0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0,
  0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72,
  0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06,
  0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20,
  0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67,
  0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x82, 0x5B,
  0xB1, 0x50, 0x4D, 0x06, 0x77, 0x09, 0xA0, 0x15, 0x04, 0xD0, 0x67, 0x70, 0xBA, 0x60, 0x4D, 0x06,
  0x77, 0x0D, 0xA6, 0x04, 0xD0, 0x67, 0x7B, 0x60, 0x4D, 0x06, 0x76, 0x02, 0xB6, 0x04, 0xD0, 0x67,
  0x60, 0x6A, 0x0E, 0x60, 0x5D, 0x06, 0x76, 0x0C, 0xA0, 0xE6, 0x09, 0xD0, 0x67, 0x50, 0x5B, 0x0D,
  0x50, 0x30, 0xED, 0x06, 0x73, 0x01, 0x07, 0xC8, 0x4D, 0x01, 0x78, 0xBF, 0x98, 0x05, 0xEF, 0x81,
  0xC0, 0x2F, 0xFF, 0xE8, 0x1C, 0x02, 0xFF, 0xFE, 0x0C, 0x10,
  // "ĺ" (U+013A)
  0x73, 0x80, 0x27, 0x72, 0x04, 0xD0, 0xC7, 0x20, 0xBC, 0x0E, 0x02, 0x71, 0x04, 0xD0, 0x47, 0x20,
  0xCC, 0x06, 0x72, 0x05, 0xC0, 0x77, 0x30, 0xEB, 0x07, 0x73, 0x08, 0xB0, 0x67, 0x30, 0x2B, 0x05,
  0x74, 0x82, 0x8F, 0xE3, 0x80, 0xE3, 0x00, 0x4F, 0xA0, 0xC5, 0x04, 0xFA, 0x0C, 0x50, 0x4F, 0xA0,
  0xC6, 0x82, 0x13, 0x7E, 0xD0, 0xC7, 0x20, 0x2D, 0x0C, 0x73, 0x0B, 0xC0, 0xC7, 0x30, 0x9C, 0x0C,
  0x73, 0x08, 0xC0, 0xC7, 0x30, 0x8C, 0x0C, 0x73, 0x08, 0xC0, 0xC7, 0x30, 0x8C, 0x0C, 0x73, 0x08,
  0xC0, 0xC7, 0x30, 0x8C, 0x0C, 0x73, 0x08, 0xC0, 0xC7, 0x30, 0x8C, 0x0C, 0x73, 0x08, 0xC0, 0xC7,
  0x30, 0x8C, 0x0C, 0x73, 0x08, 0xC0, 0xC7, 0x30, 0x8C, 0x0C, 0x73, 0x08, 0xC0, 0xC7, 0x30, 0x8C,
  0x0C, 0x73, 0x08, 0xC0, 0xC7, 0x30, 0x8C, 0x0C, 0x73, 0x08, 0xC0, 0xC7, 0x30, 0x8C, 0x0C, 0x73,
  0x08, 0xC0, 0xC7, 0x30, 0x8C, 0x0C, 0x73, 0x08, 0xC0, 0xC7, 0x30, 0x8C, 0x0C, 0x73, 0x08, 0xC0,
  0xC7, 0x30, 0x8C, 0x0C, 0x73, 0x08, 0xC0, 0xC7, 0x30, 0x8C, 0x0C, 0x73, 0x08, 0xC0, 0xC7, 0x30,
  0x8C, 0x0C, 0x73, 0x08, 0xC0, 0xC7, 0x30, 0x8C, 0x0C, 0x73, 0x08, 0xC0, 0xC7, 0x30, 0x8C, 0x0C,
  0x73, 0x09, 0xC0, 0xD7, 0x30, 0xBD, 0x72, 0x02, 0xE0, 0x65, 0x82, 0x13, 0x7E, 0xF8, 0x39, 0x31,
  0x04, 0xFF, 0x08, 0x04, 0xFF, 0x08, 0x04, 0xFF, 0x08,
  // "Ļ" (U+013B)
  0x02, 0xFF, 0x90, 0x47, 0x60, 0x2F, 0xF9, 0x04, 0x76, 0x02, 0xFF, 0x90, 0x47, 0x78, 0x21, 0x25,
  0xCF, 0x82, 0xC5, 0x21, 0x77, 0x50, 0xDD, 0x0D, 0x77, 0x72, 0x07, 0xD0, 0x97, 0x77, 0x20, 0x5D,
  0x07, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77,
  0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0,
  0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72,
  0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06,
  0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20,
  0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67,
  0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x82, 0x5B,
  0xB1, 0x50, 0x4D, 0x06, 0x77, 0x09, 0xA0, 0x15, 0x04, 0xD0, 0x67, 0x70, 0xBA, 0x60, 0x4D, 0x06,
  0x77, 0x0D, 0xA6, 0x04, 0xD0, 0x67, 0x7B, 0x60, 0x4D, 0x06, 0x76, 0x02, 0xB6, 0x04, 0xD0, 0x67,
  0x60, 0x6A, 0x0E, 0x60, 0x5D, 0x06, 0x76, 0x0C, 0xA0, 0xE6, 0x09, 0xD0, 0x67, 0x50, 0x5B, 0x0D,
  0x50, 0x30, 0xED, 0x06, 0x73, 0x01, 0x07, 0xC8, 0x4D, 0x01, 0x78, 0xBF, 0x98, 0x05, 0xEF, 0x81,
  0xC0, 0x2F, 0xFF, 0xE8, 0x1C, 0x02, 0xFF, 0xFE, 0x0C, 0x80, 0x9C, 0x40, 0x0B, 0xC0, 0x37, 0x77,
  0x30, 0xEB, 0x0D, 0x77, 0x73, 0x01, 0xC0, 0x77, 0x77, 0x30, 0x3C, 0x01, 0x77, 0x73, 0x05, 0xB0,
  0x97, 0x77, 0x40, 0x8B, 0x02, 0x77, 0x74, 0x0B, 0xA0, 0xA7, 0x77, 0x50, 0xEA, 0x03, 0x77, 0x74,
  0x02, 0xA0, 0xA7, 0x77, 0x50, 0x4A, 0x02, 0x77, 0x10,
  // "ļ" (U+013C)
  0x04, 0xFA, 0x0C, 0x50, 0x4F, 0xA0, 0xC5, 0x04, 0xFA, 0x0C, 0x68, 0x21, 0x37, 0xED, 0x0C, 0x72,
  0x02, 0xD0, 0xC7, 0x30, 0xBC, 0x0C, 0x73, 0x09, 0xC0, 0xC7, 0x30, 0x8C, 0x0C, 0x73, 0x08, 0xC0,
  0xC7, 0x30, 0x8C, 0x0C, 0x73, 0x08, 0xC0, 0xC7, 0x30, 0x8C, 0x0C, 0x73, 0x08, 0xC0, 0xC7, 0x30,
  0x8C, 0x0C, 0x73, 0x08, 0xC0, 0xC7, 0x30, 0x8C, 0x0C, 0x73, 0x08, 0xC0, 0xC7, 0x30, 0x8C, 0x0C,
  0x73, 0x08, 0xC0, 0xC7, 0x30, 0x8C, 0x0C, 0x73, 0x08, 0xC0, 0xC7, 0x30, 0x8C, 0x0C, 0x73, 0x08,
  0xC0, 0xC7, 0x30, 0x8C, 0x0C, 0x73, 0x08, 0xC0, 0xC7, 0x30, 0x8C, 0x0C, 0x73, 0x08, 0xC0, 0xC7,
  0x30, 0x8C, 0x0C, 0x73, 0x08, 0xC0, 0xC7, 0x30, 0x8C, 0x0C, 0x73, 0x08, 0xC0, 0xC7, 0x30, 0x8C,
  0x0C, 0x73, 0x08, 0xC0, 0xC7, 0x30, 0x8C, 0x0C, 0x73, 0x08, 0xC0, 0xC7, 0x30, 0x8C, 0x0C, 0x73,
  0x08, 0xC0, 0xC7, 0x30, 0x8C, 0x0C, 0x73, 0x08, 0xC0, 0xC7, 0x30, 0x9C, 0x0D, 0x73, 0x0B, 0xD7,
  0x20, 0x2E, 0x06, 0x58, 0x21, 0x37, 0xEF, 0x83, 0x93, 0x10, 0x4F, 0xF0, 0x80, 0x4F, 0xF0, 0x80,
  0x4F, 0xF0, 0x88, 0x0E, 0x20, 0x0B, 0xC0, 0x37, 0x30, 0xEB, 0x0D, 0x73, 0x01, 0xC0, 0x77, 0x30,
  0x3C, 0x01, 0x73, 0x05, 0xB0, 0x97, 0x40, 0x8B, 0x02, 0x74, 0x0B, 0xA0, 0xA7, 0x50, 0xEA, 0x03,
  0x74, 0x02, 0xA0, 0xA7, 0x50, 0x4A, 0x02, 0x71,
  // "Ľ" (U+013D)
  0x02, 0xFF, 0x90, 0x45, 0x08, 0xC0, 0x32, 0x02, 0xFF, 0x90, 0x45, 0x0B, 0xB0, 0xD3, 0x02, 0xFF,
  0x90, 0x45, 0x0D, 0xB0, 0x74, 0x82, 0x12, 0x5C, 0xF8, 0x2C, 0x52, 0x15, 0x01, 0xC0, 0x17, 0x10,
  0xDD, 0x0D, 0x72, 0x03, 0xB0, 0x97, 0x20, 0x7D, 0x09, 0x72, 0x06, 0xB0, 0x27, 0x20, 0x5D, 0x07,
  0x72, 0x09, 0xA0, 0x97, 0x30, 0x4D, 0x06, 0x72, 0x0C, 0xA0, 0x27, 0x30, 0x4D, 0x06, 0x72, 0xA0,
  0x97, 0x40, 0x4D, 0x06, 0x71, 0x02, 0xA0, 0x17, 0x40, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67,
  0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04,
  0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77,
  0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D,
  0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77,
  0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0,
  0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x82, 0x6C, 0xC1, 0x50, 0x4D, 0x06, 0x77, 0x09, 0xA0, 0x15,
  0x04, 0xD0, 0x67, 0x70, 0xBA, 0x60, 0x4D, 0x06, 0x77, 0x0D, 0xA6, 0x04, 0xD0, 0x67, 0x7B, 0x60,
  0x4D, 0x06, 0x76, 0x02, 0xB6, 0x04, 0xD0, 0x67, 0x60, 0x6A, 0x0E, 0x60, 0x5D, 0x06, 0x76, 0x0C,
  0xA0, 0xE6, 0x09, 0xD0, 0x67, 0x50, 0x5B, 0x0D, 0x50, 0x30, 0xED, 0x06, 0x73, 0x01, 0x07, 0xC8,
  0x4D, 0x01, 0x78, 0xBF, 0x98, 0x05, 0xEF, 0x81, 0xC0, 0x2F, 0xFF, 0xE8, 0x1C, 0x02, 0xFF, 0xFE,
  0x0C, 0x10,
  // "ľ" (U+013E)
  0x04, 0xFA, 0x0C, 0x40, 0xDB, 0x0E, 0x04, 0xFA, 0x0C, 0x4C, 0x09, 0x04, 0xFA, 0x0C, 0x30, 0x2C,
  0x84, 0x30, 0x13, 0x7E, 0xD0, 0xC3, 0x05, 0xB0, 0xC5, 0x02, 0xD0, 0xC3, 0x07, 0xB0, 0x56, 0x0B,
  0xC0, 0xC3, 0x0A, 0xA0, 0xD7, 0x09, 0xC0, 0xC3, 0x0D, 0xA0, 0x67, 0x08, 0xC0, 0xC2, 0x01, 0xA0,
  0xD7, 0x10, 0x8C, 0x0C, 0x20, 0x4A, 0x06, 0x71, 0x08, 0xC0, 0xC2, 0x81, 0x6F, 0xD7, 0x20, 0x8C,
  0x0C, 0x77, 0x08, 0xC0, 0xC7, 0x70, 0x8C, 0x0C, 0x77, 0x08, 0xC0, 0xC7, 0x70, 0x8C, 0x0C, 0x77,
  0x08, 0xC0, 0xC7, 0x70, 0x8C, 0x0C, 0x77, 0x08, 0xC0, 0xC7, 0x70, 0x8C, 0x0C, 0x77, 0x08, 0xC0,
  0xC7, 0x70, 0x8C, 0x0C, 0x77, 0x08, 0xC0, 0xC7, 0x70, 0x8C, 0x0C, 0x77, 0x08, 0xC0, 0xC7, 0x70,
  0x8C, 0x0C, 0x77, 0x08, 0xC0, 0xC7, 0x70, 0x8C, 0x0C, 0x77, 0x08, 0xC0, 0xC7, 0x70, 0x8C, 0x0C,
  0x77, 0x08, 0xC0, 0xC7, 0x70, 0x8C, 0x0C, 0x77, 0x08, 0xC0, 0xC7, 0x70, 0x8C, 0x0C, 0x77, 0x08,
  0xC0, 0xC7, 0x70, 0x8C, 0x0C, 0x77, 0x08, 0xC0, 0xC7, 0x70, 0x8C, 0x0C, 0x77, 0x08, 0xC0, 0xC7,
  0x70, 0x8C, 0x0C, 0x77, 0x09, 0xC0, 0xD7, 0x70, 0xBD, 0x76, 0x02, 0xE0, 0x67, 0x28, 0x21, 0x37,
  0xEF, 0x81, 0x93, 0x15, 0x04, 0xFF, 0x08, 0x40, 0x4F, 0xF0, 0x84, 0x04, 0xFF, 0x08, 0x40,
  // "Ŀ" (U+013F)
  0x02, 0xFF, 0x90, 0x47, 0x60, 0x2F, 0xF9, 0x04, 0x76, 0x02, 0xFF, 0x90, 0x47, 0x78, 0x21, 0x25,
  0xCF, 0x82, 0xC5, 0x21, 0x77, 0x50, 0xDD, 0x0D, 0x77, 0x72, 0x07, 0xD0, 0x97, 0x77, 0x20, 0x5D,
  0x07, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77,
  0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0,
  0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x73, 0x83,
  0x4C, 0xED, 0x57, 0x10, 0x4D, 0x06, 0x72, 0x03, 0xD0, 0x57, 0x04, 0xD0, 0x67, 0x20, 0x7D, 0x0A,
  0x70, 0x4D, 0x06, 0x72, 0x09, 0xD0, 0xB7, 0x04, 0xD0, 0x67, 0x20, 0x7D, 0x0A, 0x70, 0x4D, 0x06,
  0x72, 0x03, 0xD0, 0x57, 0x04, 0xD0, 0x67, 0x38, 0x34, 0xCE, 0xD5, 0x71, 0x04, 0xD0, 0x67, 0x77,
  0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0,
  0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x72, 0x04, 0xD0, 0x67, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x82,
  0x5B, 0xB1, 0x50, 0x4D, 0x06, 0x77, 0x09, 0xA0, 0x15, 0x04, 0xD0, 0x67, 0x70, 0xBA, 0x60, 0x4D,
  0x06, 0x77, 0x0D, 0xA6, 0x04, 0xD0, 0x67, 0x7B, 0x60, 0x4D, 0x06, 0x76, 0x02, 0xB6, 0x04, 0xD0,
  0x67, 0x60, 0x6A, 0x0E, 0x60, 0x5D, 0x06, 0x76, 0x0C, 0xA0, 0xE6, 0x09, 0xD0, 0x67, 0x50, 0x5B,
  0x0D, 0x50, 0x30, 0xED, 0x06, 0x73, 0x01, 0x07, 0xC8, 0x4D, 0x01, 0x78, 0xBF, 0x98, 0x05, 0xEF,
  0x81, 0xC0, 0x2F, 0xFF, 0xE8, 0x1C, 0x02, 0xFF, 0xFE, 0x0C, 0x10,
  // "ŀ" (U+0140)
  0x04, 0xFA, 0x0C, 0x73, 0x04, 0xFA, 0x0C, 0x73, 0x04, 0xFA, 0x0C, 0x74, 0x82, 0x13, 0x7E, 0xD0,
  0xC7, 0x70, 0x2D, 0x0C, 0x77, 0x10, 0xBC, 0x0C, 0x77, 0x10, 0x9C, 0x0C, 0x77, 0x10, 0x8C, 0x0C,
  0x77, 0x10, 0x8C, 0x0C, 0x77, 0x10, 0x8C, 0x0C, 0x77, 0x10, 0x8C, 0x0C, 0x77, 0x10, 0x8C, 0x0C,
  0x77, 0x10, 0x8C, 0x0C, 0x77, 0x10, 0x8C, 0x0C, 0x77, 0x10, 0x8C, 0x0C, 0x77, 0x10, 0x8C, 0x0C,
  0x77, 0x10, 0x8C, 0x0C, 0x77, 0x10, 0x8C, 0x0C, 0x77, 0x10, 0x8C, 0x0C, 0x77, 0x10, 0x8C, 0x0C,
  0x77, 0x10, 0x8C, 0x0C, 0x77, 0x10, 0x8C, 0x0C, 0x77, 0x10, 0x8C, 0x0C, 0x48, 0x34, 0xCE, 0xD5,
  0x60, 0x8C, 0x0C, 0x30, 0x3D, 0x05, 0x50, 0x8C, 0x0C, 0x30, 0x7D, 0x0A, 0x50, 0x8C, 0x0C, 0x30,
  0x9D, 0x0B, 0x50, 0x8C, 0x0C, 0x30, 0x7D, 0x0A, 0x50, 0x8C, 0x0C, 0x30, 0x3D, 0x05, 0x50, 0x8C,
  0x0C, 0x48, 0x34, 0xCE, 0xD5, 0x60, 0x8C, 0x0C, 0x77, 0x10, 0x8C, 0x0C, 0x77, 0x10, 0x8C, 0x0C,
  0x77, 0x10, 0x8C, 0x0C, 0x77, 0x10, 0x8C, 0x0C, 0x77, 0x10, 0x8C, 0x0C, 0x77, 0x10, 0x8C, 0x0C,
  0x77, 0x10, 0x8C, 0x0C, 0x77, 0x10, 0x8C, 0x0C, 0x77, 0x10, 0x8C, 0x0C, 0x77, 0x10, 0x9C, 0x0D,
  0x77, 0x10, 0xBD, 0x77, 0x02, 0xE0, 0x67, 0x38, 0x21, 0x37, 0xEF, 0x81, 0x93, 0x16, 0x04, 0xFF,
  0x08, 0x50, 0x4F, 0xF0, 0x85, 0x04, 0xFF, 0x08, 0x50,
  // "Ł" (U+0141)
  0x02, 0xFF, 0x90, 0x47, 0x60, 0x2F, 0xF9, 0x04, 0x76, 0x02, 0xFF, 0x90, 0x47, 0x78, 0x21, 0x25,
  0xCF, 0x82, 0xC5, 0x21, 0x77, 0x50, 0xCD, 0x0D, 0x77, 0x72, 0x06, 0xD0, 0x97, 0x77, 0x20, 0x4D,
  0x07, 0x77, 0x72, 0x03, 0xD0, 0x67, 0x77, 0x20, 0x3D, 0x06, 0x77, 0x72, 0x03, 0xD0, 0x67, 0x77,
  0x20, 0x3D, 0x06, 0x77, 0x72, 0x03, 0xD0, 0x67, 0x77, 0x20, 0x3D, 0x06, 0x77, 0x72, 0x03, 0xD0,
  0x67, 0x77, 0x20, 0x3D, 0x06, 0x60, 0x20, 0x37, 0x71, 0x03, 0xD0, 0x65, 0x81, 0x7F, 0x57, 0x71,
  0x03, 0xD0, 0x63, 0x02, 0x0C, 0xA0, 0x57, 0x71, 0x03, 0xD0, 0x62, 0x07, 0xB0, 0xE0, 0x37, 0x71,
  0x03, 0xD8, 0x16, 0x2C, 0xB0, 0xB0, 0x17, 0x72, 0x03, 0xD0, 0xB0, 0xEA, 0x0E, 0x06, 0x77, 0x40,
  0x3F, 0x90, 0xB0, 0x17, 0x75, 0x03, 0xE0, 0xE0, 0x67, 0x77, 0x03, 0xD0, 0xB0, 0x17, 0x77, 0x03,
  0x0D, 0xD0, 0x67, 0x77, 0x08, 0xF0, 0x67, 0x75, 0x03, 0x0D, 0xF9, 0x06, 0x77, 0x5B, 0x0C, 0x06,
  0xD0, 0x67, 0x75, 0xA8, 0x18, 0x03, 0xD0, 0x67, 0x75, 0x0C, 0x03, 0x20, 0x3D, 0x06, 0x77, 0x72,
  0x03, 0xD0, 0x67, 0x77, 0x20, 0x3D, 0x06, 0x77, 0x82, 0x5B, 0xB1, 0x50, 0x3D, 0x06, 0x77, 0x09,
  0xA0, 0x15, 0x03, 0xD0, 0x67, 0x70, 0xBA, 0x60, 0x3D, 0x06, 0x77, 0x0D, 0xA6, 0x03, 0xD0, 0x67,
  0x7B, 0x60, 0x3D, 0x06, 0x76, 0x02, 0xB6, 0x03, 0xD0, 0x67, 0x60, 0x6A, 0x0E, 0x60, 0x4D, 0x06,
  0x76, 0x0C, 0xA0, 0xE6, 0x08, 0xD0, 0x67, 0x50, 0x5B, 0x0D, 0x50, 0x30, 0xED, 0x06, 0x73, 0x01,
  0x07, 0xC8, 0x4D, 0x01, 0x78, 0xBF, 0x98, 0x05, 0xEF, 0x81, 0xC0, 0x2F, 0xFF, 0xE8, 0x1C, 0x02,
  0xFF, 0xFE, 0x0C, 0x10,
  // "ł" (U+0142)
  0x07, 0xFA, 0x09, 0x50, 0x7F, 0xA0, 0x95, 0x07, 0xFA, 0x09, 0x68, 0x11, 0x49, 0xE0, 0x97, 0x20,
  0x5D, 0x09, 0x73, 0x0E, 0xC0, 0x97, 0x30, 0xCC, 0x09, 0x73, 0x0B, 0xC0, 0x97, 0x30, 0xBC, 0x09,
  0x73, 0x0B, 0xC0, 0x97, 0x30, 0xBC, 0x09, 0x73, 0x0B, 0xC0, 0x97, 0x30, 0xBC, 0x09, 0x73, 0x0B,
  0xC0, 0x97, 0x30, 0xBC, 0x09, 0x73, 0x0B, 0xC0, 0x97, 0x30, 0xBC, 0x09, 0x73, 0x0B, 0xC0, 0x97,
  0x30, 0xBC, 0x09, 0x73, 0x0B, 0xC0, 0x93, 0x00, 0x45, 0x0B, 0xC0, 0x92, 0x81, 0x9F, 0x55, 0x0B,
  0xC8, 0x19, 0x4D, 0xA0, 0x55, 0x0B, 0xC0, 0xDB, 0x0A, 0x01, 0x50, 0xBE, 0x0E, 0x05, 0x70, 0xBD,
  0x0B, 0x01, 0x70, 0x10, 0xDC, 0x0A, 0x71, 0x04, 0x0D, 0xD0, 0x97, 0x09, 0xF0, 0x95, 0x01, 0x0D,
  0xA0, 0x0D, 0xC0, 0x95, 0x03, 0xA8, 0x19, 0x1B, 0xC0, 0x95, 0x81, 0x3E, 0x42, 0x0B, 0xC0, 0x95,
  0x00, 0x13, 0x0B, 0xC0, 0x97, 0x30, 0xBC, 0x09, 0x73, 0x0B, 0xC0, 0x97, 0x30, 0xBC, 0x09, 0x73,
  0x0B, 0xC0, 0x97, 0x30, 0xBC, 0x09, 0x73, 0x0B, 0xC0, 0x97, 0x30, 0xBC, 0x09, 0x73, 0x0C, 0xC0,
  0x97, 0x30, 0xEC, 0x0C, 0x72, 0x05, 0xE0, 0x25, 0x81, 0x13, 0x8F, 0x84, 0xE7, 0x31, 0x07, 0xFF,
  0x04, 0x07, 0xFF, 0x04, 0x07, 0xFF, 0x04,
  // "Ń" (U+0143)
  0x77, 0x78, 0x02, 0x77, 0x77, 0x72, 0x04, 0xD0, 0xC7, 0x77, 0x72, 0x0B, 0xC0, 0xE0, 0x27, 0x77,
  0x71, 0x04, 0xD0, 0x47, 0x77, 0x72, 0x0C, 0xC0, 0x67, 0x77, 0x72, 0x05, 0xC0, 0x77, 0x77, 0x73,
  0x0E, 0xB0, 0x77, 0x77, 0x73, 0x08, 0xB0, 0x67, 0x77, 0x73, 0x02, 0xB0, 0x57, 0x77, 0x74, 0x82,
  0x8F, 0xE3, 0x80, 0xAC, 0x10, 0x02, 0xFB, 0x01, 0x75, 0x0E, 0xFD, 0x02, 0xFB, 0x09, 0x75, 0x0E,
  0xFD, 0x02, 0xFC, 0x02, 0x74, 0x0E, 0xFD, 0x18, 0x21, 0x25, 0xCF, 0x0A, 0x74, 0x82, 0x12, 0x4B,
  0xD8, 0x2B, 0x42, 0x15, 0x0C, 0xF0, 0x37, 0x70, 0xAB, 0x0B, 0x72, 0x06, 0xF0, 0xC7, 0x70, 0x4B,
  0x05, 0x72, 0x04, 0xF9, 0x05, 0x76, 0x02, 0xB0, 0x27, 0x20, 0x4F, 0x90, 0xD7, 0x60, 0x1B, 0x01,
  0x72, 0x04, 0xB0, 0xED, 0x06, 0x75, 0x01, 0xB0, 0x17, 0x20, 0x4A, 0x0E, 0x06, 0xD0, 0xD7, 0x50,
  0x1B, 0x01, 0x72, 0x04, 0xA8, 0x1E, 0x0D, 0xD0, 0x77, 0x40, 0x1B, 0x01, 0x72, 0x04, 0xA8, 0x1E,
  0x04, 0xD0, 0xE0, 0x17, 0x30, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE2, 0x0B, 0xD0, 0x87, 0x30, 0x1B,
  0x01, 0x72, 0x04, 0xA0, 0xE2, 0x03, 0xE0, 0x17, 0x20, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE3, 0x09,
  0xD0, 0x97, 0x20, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE3, 0x01, 0xE0, 0x27, 0x10, 0x1B, 0x01, 0x72,
  0x04, 0xA0, 0xE4, 0x08, 0xD0, 0xB7, 0x10, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE5, 0x0E, 0xD0, 0x47,
  0x01, 0xB0, 0x17, 0x20, 0x4A, 0x0E, 0x50, 0x6D, 0x0C, 0x70, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE6,
  0x0D, 0xD0, 0x56, 0x01, 0xB0, 0x17, 0x20, 0x4A, 0x0E, 0x60, 0x4D, 0x0D, 0x60, 0x1B, 0x01, 0x72,
  0x04, 0xA0, 0xE7, 0x0B, 0xD0, 0x65, 0x01, 0xB0, 0x17, 0x20, 0x4A, 0x0E, 0x70, 0x3D, 0x0E, 0x50,
  0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE7, 0x10, 0xAD, 0x07, 0x40, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE7,
  0x10, 0x1D, 0x0E, 0x01, 0x30, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE7, 0x20, 0x8D, 0x09, 0x30, 0x1B,
  0x01, 0x72, 0x04, 0xA0, 0xE7, 0x20, 0x10, 0xED, 0x02, 0x20, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE7,
  0x30, 0x6D, 0x0A, 0x20, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE7, 0x40, 0xDD, 0x81, 0x30, 0x1B, 0x01,
  0x72, 0x04, 0xA0, 0xE7, 0x40, 0x5D, 0x81, 0xB0, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE7, 0x50, 0xBD,
  0x04, 0x01, 0xB0, 0x17, 0x20, 0x4A, 0x0E, 0x75, 0x03, 0xD0, 0xC0, 0x2B, 0x01, 0x72, 0x04, 0xA0,
  0xE7, 0x60, 0xAD, 0x07, 0xB0, 0x17, 0x20, 0x4A, 0x0E, 0x76, 0x02, 0xD0, 0xEB, 0x01, 0x72, 0x04,
  0xA0, 0xE7, 0x70, 0x8F, 0x90, 0x17, 0x20, 0x4A, 0x0E, 0x77, 0x01, 0x0E, 0xF0, 0x17, 0x20, 0x5B,
  0x77, 0x10, 0x6F, 0x01, 0x72, 0x07, 0xB0, 0x17, 0x71, 0x0D, 0xE0, 0x17, 0x20, 0xCB, 0x07, 0x77,
  0x10, 0x5E, 0x01, 0x58, 0x21, 0x25, 0xCD, 0x82, 0x93, 0x11, 0x75, 0x0C, 0xD0, 0x14, 0x02, 0xFD,
  0x0C, 0x75, 0x03, 0xD0, 0x14, 0x02, 0xFD, 0x0C, 0x76, 0x0A, 0xC0, 0x14, 0x02, 0xFD, 0x0C, 0x76,
  0x02, 0xC0, 0x14,
  // "ń" (U+0144)
  0x77, 0x48, 0x02, 0x77, 0x77, 0x30, 0x4D, 0x0C, 0x77, 0x73, 0x0B, 0xC0, 0xE0, 0x27, 0x77, 0x20,
  0x4D, 0x04, 0x77, 0x73, 0x0C, 0xC0, 0x67, 0x77, 0x30, 0x5C, 0x07, 0x77, 0x74, 0x0E, 0xB0, 0x77,
  0x77, 0x40, 0x8B, 0x06, 0x77, 0x74, 0x02, 0xB0, 0x57, 0x77, 0x58, 0x28, 0xFE, 0x38, 0x0A, 0xA5,
  0x08, 0x41, 0x57, 0x75, 0x37, 0x30, 0x5F, 0x90, 0x63, 0x02, 0x0A, 0xE0, 0xE0, 0x67, 0x10, 0x5F,
  0x90, 0x82, 0x04, 0x0E, 0xFA, 0x0B, 0x70, 0x5F, 0x98, 0x2A, 0x02, 0xEF, 0xC0, 0xA7, 0x81, 0x24,
  0xAD, 0x81, 0xC0, 0xBA, 0x83, 0xB8, 0x8A, 0xEE, 0x04, 0x72, 0x0A, 0xC8, 0x3E, 0x3F, 0xD3, 0x50,
  0xAD, 0x0B, 0x72, 0x04, 0xD8, 0x1C, 0xE2, 0x70, 0xCD, 0x01, 0x71, 0x02, 0xE0, 0x77, 0x10, 0x5D,
  0x05, 0x71, 0x01, 0xE0, 0x17, 0x2D, 0x08, 0x71, 0x01, 0xD0, 0xB7, 0x30, 0xCC, 0x0A, 0x71, 0x01,
  0xD0, 0x87, 0x30, 0xAC, 0x0A, 0x71, 0x01, 0xD0, 0x57, 0x30, 0x9C, 0x0B, 0x71, 0x01, 0xD0, 0x47,
  0x30, 0x8C, 0x0C, 0x71, 0x01, 0xD0, 0x37, 0x30, 0x8C, 0x0C, 0x71, 0x01, 0xD0, 0x37, 0x30, 0x8C,
  0x0C, 0x71, 0x01, 0xD0, 0x37, 0x30, 0x8C, 0x0C, 0x71, 0x01, 0xD0, 0x37, 0x30, 0x8C, 0x0C, 0x71,
  0x01, 0xD0, 0x37, 0x30, 0x8C, 0x0C, 0x71, 0x01, 0xD0, 0x37, 0x30, 0x8C, 0x0C, 0x71, 0x01, 0xD0,
  0x37, 0x30, 0x8C, 0x0C, 0x71, 0x01, 0xD0, 0x37, 0x30, 0x8C, 0x0C, 0x71, 0x01, 0xD0, 0x37, 0x30,
  0x8C, 0x0C, 0x71, 0x01, 0xD0, 0x37, 0x30, 0x8C, 0x0C, 0x71, 0x01, 0xD0, 0x37, 0x30, 0x8C, 0x0C,
  0x71, 0x01, 0xD0, 0x37, 0x30, 0x8C, 0x0C, 0x71, 0x01, 0xD0, 0x37, 0x30, 0x8C, 0x0C, 0x71, 0x02,
  0xD0, 0x37, 0x30, 0x8C, 0x0C, 0x71, 0x04, 0xD0, 0x57, 0x30, 0x8C, 0x0E, 0x71, 0x0A, 0xD0, 0xA7,
  0x30, 0x8D, 0x04, 0x48, 0x12, 0x4B, 0xF8, 0x1B, 0x42, 0x70, 0x8D, 0x83, 0xE7, 0x31, 0xAF, 0xE0,
  0x76, 0x08, 0xF9, 0x0C, 0x0A, 0xFE, 0x07, 0x60, 0x8F, 0x90, 0xC0, 0xAF, 0xE0, 0x76, 0x08, 0xF9,
  0x0C,
  // "Ņ" (U+0145)
  0x02, 0xFB, 0x01, 0x75, 0x0E, 0xFD, 0x02, 0xFB, 0x09, 0x75, 0x0E, 0xFD, 0x02, 0xFC, 0x02, 0x74,
  0x0E, 0xFD, 0x18, 0x21, 0x25, 0xCF, 0x0A, 0x74, 0x82, 0x12, 0x4B, 0xD8, 0x2B, 0x42, 0x15, 0x0C,
  0xF0, 0x37, 0x70, 0xAB, 0x0B, 0x72, 0x06, 0xF0, 0xC7, 0x70, 0x4B, 0x05, 0x72, 0x04, 0xF9, 0x05,
  0x76, 0x02, 0xB0, 0x27, 0x20, 0x4F, 0x90, 0xD7, 0x60, 0x1B, 0x01, 0x72, 0x04, 0xB0, 0xED, 0x06,
  0x75, 0x01, 0xB0, 0x17, 0x20, 0x4A, 0x0E, 0x06, 0xD0, 0xD7, 0x50, 0x1B, 0x01, 0x72, 0x04, 0xA8,
  0x1E, 0x0D, 0xD0, 0x77, 0x40, 0x1B, 0x01, 0x72, 0x04, 0xA8, 0x1E, 0x04, 0xD0, 0xE0, 0x17, 0x30,
  0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE2, 0x0B, 0xD0, 0x87, 0x30, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE2,
  0x03, 0xE0, 0x17, 0x20, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE3, 0x09, 0xD0, 0x97, 0x20, 0x1B, 0x01,
  0x72, 0x04, 0xA0, 0xE3, 0x01, 0xE0, 0x27, 0x10, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE4, 0x08, 0xD0,
  0xB7, 0x10, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE5, 0x0E, 0xD0, 0x47, 0x01, 0xB0, 0x17, 0x20, 0x4A,
  0x0E, 0x50, 0x6D, 0x0C, 0x70, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE6, 0x0D, 0xD0, 0x56, 0x01, 0xB0,
  0x17, 0x20, 0x4A, 0x0E, 0x60, 0x4D, 0x0D, 0x60, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE7, 0x0B, 0xD0,
  0x65, 0x01, 0xB0, 0x17, 0x20, 0x4A, 0x0E, 0x70, 0x3D, 0x0E, 0x50, 0x1B, 0x01, 0x72, 0x04, 0xA0,
  0xE7, 0x10, 0xAD, 0x07, 0x40, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE7, 0x10, 0x1D, 0x0E, 0x01, 0x30,
  0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE7, 0x20, 0x8D, 0x09, 0x30, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE7,
  0x20, 0x10, 0xED, 0x02, 0x20, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE7, 0x30, 0x6D, 0x0A, 0x20, 0x1B,
  0x01, 0x72, 0x04, 0xA0, 0xE7, 0x40, 0xDD, 0x81, 0x30, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE7, 0x40,
  0x5D, 0x81, 0xB0, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE7, 0x50, 0xBD, 0x04, 0x01, 0xB0, 0x17, 0x20,
  0x4A, 0x0E, 0x75, 0x03, 0xD0, 0xC0, 0x2B, 0x01, 0x72, 0x04, 0xA0, 0xE7, 0x60, 0xAD, 0x07, 0xB0,
  0x17, 0x20, 0x4A, 0x0E, 0x76, 0x02, 0xD0, 0xEB, 0x01, 0x72, 0x04, 0xA0, 0xE7, 0x70, 0x8F, 0x90,
  0x17, 0x20, 0x4A, 0x0E, 0x77, 0x01, 0x0E, 0xF0, 0x17, 0x20, 0x5B, 0x77, 0x10, 0x6F, 0x01, 0x72,
  0x07, 0xB0, 0x17, 0x71, 0x0D, 0xE0, 0x17, 0x20, 0xCB, 0x07, 0x77, 0x10, 0x5E, 0x01, 0x58, 0x21,
  0x25, 0xCD, 0x82, 0x93, 0x11, 0x75, 0x0C, 0xD0, 0x14, 0x02, 0xFD, 0x0C, 0x75, 0x03, 0xD0, 0x14,
  0x02, 0xFD, 0x0C, 0x76, 0x0A, 0xC0, 0x14, 0x02, 0xFD, 0x0C, 0x76, 0x02, 0xC0, 0x18, 0x0A, 0x80,
  0x00, 0xBC, 0x03, 0x77, 0x77, 0x30, 0xEB, 0x0D, 0x77, 0x77, 0x30, 0x1C, 0x07, 0x77, 0x77, 0x30,
  0x3C, 0x01, 0x77, 0x77, 0x30, 0x5B, 0x09, 0x77, 0x77, 0x40, 0x8B, 0x02, 0x77, 0x77, 0x40, 0xBA,
  0x0A, 0x77, 0x77, 0x50, 0xEA, 0x03, 0x77, 0x77, 0x40, 0x2A, 0x0A, 0x77, 0x77, 0x50, 0x4A, 0x02,
  0x77, 0x40,
  // "ņ" (U+0146)
  0x77, 0x18, 0x41, 0x57, 0x75, 0x37, 0x30, 0x5F, 0x90, 0x63, 0x02, 0x0A, 0xE0, 0xE0, 0x67, 0x10,
  0x5F, 0x90, 0x82, 0x04, 0x0E, 0xFA, 0x0B, 0x70, 0x5F, 0x98, 0x2A, 0x02, 0xEF, 0xC0, 0xA7, 0x81,
  0x24, 0xAD, 0x81, 0xC0, 0xBA, 0x83, 0xB8, 0x8A, 0xEE, 0x04, 0x72, 0x0A, 0xC8, 0x3E, 0x3F, 0xD3,
  0x50, 0xAD, 0x0B, 0x72, 0x04, 0xD8, 0x1C, 0xE2, 0x70, 0xCD, 0x01, 0x71, 0x02, 0xE0, 0x77, 0x10,
  0x5D, 0x05, 0x71, 0x01, 0xE0, 0x17, 0x2D, 0x08, 0x71, 0x01, 0xD0, 0xB7, 0x30, 0xCC, 0x0A, 0x71,
  0x01, 0xD0, 0x87, 0x30, 0xAC, 0x0A, 0x71, 0x01, 0xD0, 0x57, 0x30, 0x9C, 0x0B, 0x71, 0x01, 0xD0,
  0x47, 0x30, 0x8C, 0x0C, 0x71, 0x01, 0xD0, 0x37, 0x30, 0x8C, 0x0C, 0x71, 0x01, 0xD0, 0x37, 0x30,
  0x8C, 0x0C, 0x71, 0x01, 0xD0, 0x37, 0x30, 0x8C, 0x0C, 0x71, 0x01, 0xD0, 0x37, 0x30, 0x8C, 0x0C,
  0x71, 0x01, 0xD0, 0x37, 0x30, 0x8C, 0x0C, 0x71, 0x01, 0xD0, 0x37, 0x30, 0x8C, 0x0C, 0x71, 0x01,
  0xD0, 0x37, 0x30, 0x8C, 0x0C, 0x71, 0x01, 0xD0, 0x37, 0x30, 0x8C, 0x0C, 0x71, 0x01, 0xD0, 0x37,
  0x30, 0x8C, 0x0C, 0x71, 0x01, 0xD0, 0x37, 0x30, 0x8C, 0x0C, 0x71, 0x01, 0xD0, 0x37, 0x30, 0x8C,
  0x0C, 0x71, 0x01, 0xD0, 0x37, 0x30, 0x8C, 0x0C, 0x71, 0x01, 0xD0, 0x37, 0x30, 0x8C, 0x0C, 0x71,
  0x02, 0xD0, 0x37, 0x30, 0x8C, 0x0C, 0x71, 0x04, 0xD0, 0x57, 0x30, 0x8C, 0x0E, 0x71, 0x0A, 0xD0,
  0xA7, 0x30, 0x8D, 0x04, 0x48, 0x12, 0x4B, 0xF8, 0x1B, 0x42, 0x70, 0x8D, 0x83, 0xE7, 0x31, 0xAF,
  0xE0, 0x76, 0x08, 0xF9, 0x0C, 0x0A, 0xFE, 0x07, 0x60, 0x8F, 0x90, 0xC0, 0xAF, 0xE0, 0x76, 0x08,
  0xF9, 0x0C, 0x80, 0x9C, 0x70, 0x0B, 0xC0, 0x37, 0x77, 0x40, 0xEB, 0x0D, 0x77, 0x74, 0x01, 0xC0,
  0x77, 0x77, 0x40, 0x3C, 0x01, 0x77, 0x74, 0x05, 0xB0, 0x97, 0x77, 0x50, 0x8B, 0x02, 0x77, 0x75,
  0x0B, 0xA0, 0xA7, 0x77, 0x60, 0xEA, 0x03, 0x77, 0x75, 0x02, 0xA0, 0xA7, 0x77, 0x60, 0x4A, 0x02,
  0x77, 0x10,
  // "Ň" (U+0147)
  0x74, 0x81, 0x47, 0x77, 0x38, 0x13, 0x77, 0x77, 0x70, 0x7A, 0x0A, 0x71, 0x82, 0x4E, 0xFD, 0x77,
  0x71, 0x0C, 0xA0, 0xA6, 0x04, 0x0E, 0xA0, 0x47, 0x77, 0x10, 0x2B, 0x0A, 0x40, 0x30, 0xEA, 0x08,
  0x77, 0x73, 0x07, 0xB0, 0x82, 0x02, 0x0E, 0xA0, 0xD7, 0x77, 0x50, 0xDB, 0x81, 0x61, 0xDB, 0x04,
  0x77, 0x75, 0x03, 0xC0, 0xCB, 0x0A, 0x77, 0x77, 0x09, 0xF0, 0x17, 0x77, 0x70, 0x1E, 0x08, 0x77,
  0x77, 0x20, 0x9D, 0x01, 0x80, 0xAB, 0x60, 0x02, 0xFB, 0x01, 0x75, 0x0E, 0xFD, 0x02, 0xFB, 0x09,
  0x75, 0x0E, 0xFD, 0x02, 0xFC, 0x02, 0x74, 0x0E, 0xFD, 0x18, 0x21, 0x25, 0xCF, 0x0A, 0x74, 0x82,
  0x12, 0x4B, 0xD8, 0x2B, 0x42, 0x15, 0x0C, 0xF0, 0x37, 0x70, 0xAB, 0x0B, 0x72, 0x06, 0xF0, 0xC7,
  0x70, 0x4B, 0x05, 0x72, 0x04, 0xF9, 0x05, 0x76, 0x02, 0xB0, 0x27, 0x20, 0x4F, 0x90, 0xD7, 0x60,
  0x1B, 0x01, 0x72, 0x04, 0xB0, 0xED, 0x06, 0x75, 0x01, 0xB0, 0x17, 0x20, 0x4A, 0x0E, 0x06, 0xD0,
  0xD7, 0x50, 0x1B, 0x01, 0x72, 0x04, 0xA8, 0x1E, 0x0D, 0xD0, 0x77, 0x40, 0x1B, 0x01, 0x72, 0x04,
  0xA8, 0x1E, 0x04, 0xD0, 0xE0, 0x17, 0x30, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE2, 0x0B, 0xD0, 0x87,
  0x30, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE2, 0x03, 0xE0, 0x17, 0x20, 0x1B, 0x01, 0x72, 0x04, 0xA0,
  0xE3, 0x09, 0xD0, 0x97, 0x20, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE3, 0x01, 0xE0, 0x27, 0x10, 0x1B,
  0x01, 0x72, 0x04, 0xA0, 0xE4, 0x08, 0xD0, 0xB7, 0x10, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE5, 0x0E,
  0xD0, 0x47, 0x01, 0xB0, 0x17, 0x20, 0x4A, 0x0E, 0x50, 0x6D, 0x0C, 0x70, 0x1B, 0x01, 0x72, 0x04,
  0xA0, 0xE6, 0x0D, 0xD0, 0x56, 0x01, 0xB0, 0x17, 0x20, 0x4A, 0x0E, 0x60, 0x4D, 0x0D, 0x60, 0x1B,
  0x01, 0x72, 0x04, 0xA0, 0xE7, 0x0B, 0xD0, 0x65, 0x01, 0xB0, 0x17, 0x20, 0x4A, 0x0E, 0x70, 0x3D,
  0x0E, 0x50, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE7, 0x10, 0xAD, 0x07, 0x40, 0x1B, 0x01, 0x72, 0x04,
  0xA0, 0xE7, 0x10, 0x1D, 0x0E, 0x01, 0x30, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE7, 0x20, 0x8D, 0x09,
  0x30, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE7, 0x20, 0x10, 0xED, 0x02, 0x20, 0x1B, 0x01, 0x72, 0x04,
  0xA0, 0xE7, 0x30, 0x6D, 0x0A, 0x20, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE7, 0x40, 0xDD, 0x81, 0x30,
  0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE7, 0x40, 0x5D, 0x81, 0xB0, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE7,
  0x50, 0xBD, 0x04, 0x01, 0xB0, 0x17, 0x20, 0x4A, 0x0E, 0x75, 0x03, 0xD0, 0xC0, 0x2B, 0x01, 0x72,
  0x04, 0xA0, 0xE7, 0x60, 0xAD, 0x07, 0xB0, 0x17, 0x20, 0x4A, 0x0E, 0x76, 0x02, 0xD0, 0xEB, 0x01,
  0x72, 0x04, 0xA0, 0xE7, 0x70, 0x8F, 0x90, 0x17, 0x20, 0x4A, 0x0E, 0x77, 0x01, 0x0E, 0xF0, 0x17,
  0x20, 0x5B, 0x77, 0x10, 0x6F, 0x01, 0x72, 0x07, 0xB0, 0x17, 0x71, 0x0D, 0xE0, 0x17, 0x20, 0xCB,
  0x07, 0x77, 0x10, 0x5E, 0x01, 0x58, 0x21, 0x25, 0xCD, 0x82, 0x93, 0x11, 0x75, 0x0C, 0xD0, 0x14,
  0x02, 0xFD, 0x0C, 0x75, 0x03, 0xD0, 0x14, 0x02, 0xFD, 0x0C, 0x76, 0x0A, 0xC0, 0x14, 0x02, 0xFD,
  0x0C, 0x76, 0x02, 0xC0, 0x14,
  // "ň" (U+0148)
  0x71, 0x81, 0x47, 0x77, 0x38, 0x13, 0x77, 0x77, 0x10, 0x7A, 0x0A, 0x71, 0x82, 0x4E, 0xFD, 0x77,
  0x20, 0xCA, 0x0A, 0x60, 0x40, 0xEA, 0x04, 0x77, 0x20, 0x2B, 0x0A, 0x40, 0x30, 0xEA, 0x08, 0x77,
  0x40, 0x7B, 0x08, 0x20, 0x20, 0xEA, 0x0D, 0x77, 0x60, 0xDB, 0x81, 0x61, 0xDB, 0x04, 0x77, 0x60,
  0x3C, 0x0C, 0xB0, 0xA7, 0x77, 0x10, 0x9F, 0x01, 0x77, 0x71, 0x01, 0xE0, 0x87, 0x77, 0x30, 0x9D,
  0x01, 0x80, 0xAA, 0x20, 0x84, 0x15, 0x77, 0x53, 0x73, 0x05, 0xF9, 0x06, 0x30, 0x20, 0xAE, 0x0E,
  0x06, 0x71, 0x05, 0xF9, 0x08, 0x20, 0x40, 0xEF, 0xA0, 0xB7, 0x05, 0xF9, 0x82, 0xA0, 0x2E, 0xFC,
  0x0A, 0x78, 0x12, 0x4A, 0xD8, 0x1C, 0x0B, 0xA8, 0x3B, 0x88, 0xAE, 0xE0, 0x47, 0x20, 0xAC, 0x83,
  0xE3, 0xFD, 0x35, 0x0A, 0xD0, 0xB7, 0x20, 0x4D, 0x81, 0xCE, 0x27, 0x0C, 0xD0, 0x17, 0x10, 0x2E,
  0x07, 0x71, 0x05, 0xD0, 0x57, 0x10, 0x1E, 0x01, 0x72, 0xD0, 0x87, 0x10, 0x1D, 0x0B, 0x73, 0x0C,
  0xC0, 0xA7, 0x10, 0x1D, 0x08, 0x73, 0x0A, 0xC0, 0xA7, 0x10, 0x1D, 0x05, 0x73, 0x09, 0xC0, 0xB7,
  0x10, 0x1D, 0x04, 0x73, 0x08, 0xC0, 0xC7, 0x10, 0x1D, 0x03, 0x73, 0x08, 0xC0, 0xC7, 0x10, 0x1D,
  0x03, 0x73, 0x08, 0xC0, 0xC7, 0x10, 0x1D, 0x03, 0x73, 0x08, 0xC0, 0xC7, 0x10, 0x1D, 0x03, 0x73,
  0x08, 0xC0, 0xC7, 0x10, 0x1D, 0x03, 0x73, 0x08, 0xC0, 0xC7, 0x10, 0x1D, 0x03, 0x73, 0x08, 0xC0,
  0xC7, 0x10, 0x1D, 0x03, 0x73, 0x08, 0xC0, 0xC7, 0x10, 0x1D, 0x03, 0x73, 0x08, 0xC0, 0xC7, 0x10,
  0x1D, 0x03, 0x73, 0x08, 0xC0, 0xC7, 0x10, 0x1D, 0x03, 0x73, 0x08, 0xC0, 0xC7, 0x10, 0x1D, 0x03,
  0x73, 0x08, 0xC0, 0xC7, 0x10, 0x1D, 0x03, 0x73, 0x08, 0xC0, 0xC7, 0x10, 0x1D, 0x03, 0x73, 0x08,
  0xC0, 0xC7, 0x10, 0x2D, 0x03, 0x73, 0x08, 0xC0, 0xC7, 0x10, 0x4D, 0x05, 0x73, 0x08, 0xC0, 0xE7,
  0x10, 0xAD, 0x0A, 0x73, 0x08, 0xD0, 0x44, 0x81, 0x24, 0xBF, 0x81, 0xB4, 0x27, 0x08, 0xD8, 0x3E,
  0x73, 0x1A, 0xFE, 0x07, 0x60, 0x8F, 0x90, 0xC0, 0xAF, 0xE0, 0x76, 0x08, 0xF9, 0x0C, 0x0A, 0xFE,
  0x07, 0x60, 0x8F, 0x90, 0xC0,
  // "ŉ" (U+0149)
  0x38, 0x38, 0xDE, 0xB2, 0x77, 0x77, 0x60, 0xAC, 0x0E, 0x02, 0x77, 0x77, 0x40, 0x1E, 0x0B, 0x77,
  0x77, 0x40, 0x3F, 0x77, 0x77, 0x40, 0x1F, 0x02, 0x77, 0x77, 0x40, 0xAE, 0x02, 0x77, 0x77, 0x50,
  0x9D, 0x01, 0x77, 0x77, 0x60, 0x5C, 0x80, 0xC0, 0x00, 0x9A, 0x0C, 0x80, 0xC0, 0x00, 0x8A, 0x07,
  0x80, 0xC0, 0x00, 0xBA, 0x01, 0x77, 0x18, 0x41, 0x57, 0x75, 0x37, 0x70, 0x3A, 0x81, 0x90, 0x5F,
  0x90, 0x63, 0x02, 0x0A, 0xE0, 0xE0, 0x67, 0x48, 0x52, 0xDF, 0xE1, 0x05, 0xF9, 0x08, 0x20, 0x40,
  0xEF, 0xA0, 0xB7, 0x20, 0x50, 0xEA, 0x04, 0x20, 0x5F, 0x98, 0x2A, 0x02, 0xEF, 0xC0, 0xA6, 0x02,
  0x0D, 0xA0, 0xE0, 0x44, 0x81, 0x24, 0xAD, 0x81, 0xC0, 0xBA, 0x83, 0xB8, 0x8A, 0xEE, 0x04, 0x50,
  0x4A, 0x0A, 0x01, 0x71, 0x0A, 0xC8, 0x3E, 0x3F, 0xD3, 0x50, 0xAD, 0x0B, 0x58, 0x14, 0xA3, 0x73,
  0x04, 0xD8, 0x1C, 0xE2, 0x70, 0xCD, 0x01, 0x77, 0x30, 0x2E, 0x07, 0x71, 0x05, 0xD0, 0x57, 0x73,
  0x01, 0xE0, 0x17, 0x2D, 0x08, 0x77, 0x30, 0x1D, 0x0B, 0x73, 0x0C, 0xC0, 0xA7, 0x73, 0x01, 0xD0,
  0x87, 0x30, 0xAC, 0x0A, 0x77, 0x30, 0x1D, 0x05, 0x73, 0x09, 0xC0, 0xB7, 0x73, 0x01, 0xD0, 0x47,
  0x30, 0x8C, 0x0C, 0x77, 0x30, 0x1D, 0x03, 0x73, 0x08, 0xC0, 0xC7, 0x73, 0x01, 0xD0, 0x37, 0x30,
  0x8C, 0x0C, 0x77, 0x30, 0x1D, 0x03, 0x73, 0x08, 0xC0, 0xC7, 0x73, 0x01, 0xD0, 0x37, 0x30, 0x8C,
  0x0C, 0x77, 0x30, 0x1D, 0x03, 0x73, 0x08, 0xC0, 0xC7, 0x73, 0x01, 0xD0, 0x37, 0x30, 0x8C, 0x0C,
  0x77, 0x30, 0x1D, 0x03, 0x73, 0x08, 0xC0, 0xC7, 0x73, 0x01, 0xD0, 0x37, 0x30, 0x8C, 0x0C, 0x77,
  0x30, 0x1D, 0x03, 0x73, 0x08, 0xC0, 0xC7, 0x73, 0x01, 0xD0, 0x37, 0x30, 0x8C, 0x0C, 0x77, 0x30,
  0x1D, 0x03, 0x73, 0x08, 0xC0, 0xC7, 0x73, 0x01, 0xD0, 0x37, 0x30, 0x8C, 0x0C, 0x77, 0x30, 0x1D,
  0x03, 0x73, 0x08, 0xC0, 0xC7, 0x73, 0x02, 0xD0, 0x37, 0x30, 0x8C, 0x0C, 0x77, 0x30, 0x4D, 0x05,
  0x73, 0x08, 0xC0, 0xE7, 0x73, 0x0A, 0xD0, 0xA7, 0x30, 0x8D, 0x04, 0x76, 0x81, 0x24, 0xBF, 0x81,
  0xB4, 0x27, 0x08, 0xD8, 0x2E, 0x73, 0x17, 0x20, 0xAF, 0xE0, 0x76, 0x08, 0xF9, 0x0C, 0x72, 0x0A,
  0xFE, 0x07, 0x60, 0x8F, 0x90, 0xC7, 0x20, 0xAF, 0xE0, 0x76, 0x08, 0xF9, 0x0C,
  // "Ŋ" (U+014A)
  0x02, 0xFA, 0x0C, 0x76, 0x0E, 0xFD, 0x02, 0xFB, 0x05, 0x75, 0x0E, 0xFD, 0x02, 0xFB, 0x0D, 0x75,
  0x0E, 0xFD, 0x18, 0x21, 0x25, 0xCF, 0x07, 0x74, 0x82, 0x12, 0x4B, 0xD8, 0x2B, 0x42, 0x15, 0x0C,
  0xE0, 0xE0, 0x17, 0x70, 0xAB, 0x0A, 0x72, 0x06, 0xF0, 0x87, 0x70, 0x4B, 0x04, 0x72, 0x04, 0xF9,
  0x02, 0x76, 0x02, 0xB0, 0x27, 0x20, 0x4F, 0x90, 0xA7, 0x60, 0x1B, 0x01, 0x72, 0x04, 0xB0, 0xED,
  0x03, 0x75, 0x01, 0xB0, 0x17, 0x20, 0x4A, 0x0E, 0x05, 0xD0, 0xB7, 0x50, 0x1B, 0x01, 0x72, 0x04,
  0xA8, 0x1E, 0x0C, 0xD0, 0x57, 0x40, 0x1B, 0x01, 0x72, 0x04, 0xA8, 0x1E, 0x03, 0xD0, 0xD7, 0x40,
  0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE2, 0x09, 0xD0, 0x67, 0x30, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE2,
  0x01, 0x0E, 0xC0, 0xE7, 0x30, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE3, 0x07, 0xD0, 0x87, 0x20, 0x1B,
  0x01, 0x72, 0x04, 0xA0, 0xE4, 0x0D, 0xD0, 0x17, 0x10, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE4, 0x05,
  0xD0, 0xA7, 0x10, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE5, 0x0B, 0xD0, 0x37, 0x01, 0xB0, 0x17, 0x20,
  0x4A, 0x0E, 0x50, 0x2D, 0x0B, 0x70, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE6, 0x09, 0xD0, 0x46, 0x01,
  0xB0, 0x17, 0x20, 0x4A, 0x0E, 0x60, 0x10, 0xEC, 0x0D, 0x60, 0x1B, 0x01, 0x72, 0x04, 0xA0, 0xE7,
  0x06, 0xD0, 0x65, 0x01, 0xB0, 0x17, 0x20, 0x4A, 0x0E, 0x71, 0x0C, 0xC0, 0xE5, 0x01, 0xB0, 0x17,
  0x20, 0x4A, 0x0E, 0x71, 0x04, 0xD0, 0x84, 0x01, 0xB0, 0x17, 0x20, 0x4A, 0x0E, 0x72, 0x0A, 0xC0,
  0xE0, 0x13, 0x01, 0xB0, 0x17, 0x20, 0x4A, 0x0E, 0x72, 0x02, 0xD0, 0x93, 0x01, 0xB0, 0x17, 0x20,
  0x4A, 0x0E, 0x73, 0x08, 0xD0, 0x22, 0x01, 0xB0, 0x17, 0x20, 0x4A, 0x0E, 0x74, 0x0D, 0xC0, 0xB2,
  0x01, 0xB0, 0x17, 0x20, 0x4A, 0x0E, 0x74, 0x05, 0xD8, 0x14, 0x01, 0xB0, 0x17, 0x20, 0x4A, 0x0E,
  0x75, 0x0C, 0xC8, 0x1C, 0x01, 0xB0, 0x17, 0x20, 0x4A, 0x0E, 0x75, 0x03, 0xD0, 0x60, 0x1B, 0x01,
  0x72, 0x04, 0xA0, 0xE7, 0x60, 0x9C, 0x0E, 0x02, 0xB0, 0x17, 0x20, 0x4A, 0x0E, 0x76, 0x01, 0x0E,
  0xC0, 0x9B, 0x01, 0x72, 0x04, 0xA0, 0xE7, 0x70, 0x7F, 0x90, 0x17, 0x20, 0x4A, 0x0E, 0x77, 0x10,
  0xDF, 0x01, 0x72, 0x04, 0xA0, 0xE7, 0x71, 0x04, 0xF0, 0x17, 0x20, 0x5B, 0x77, 0x20, 0xBE, 0x01,
  0x72, 0x07, 0xB0, 0x17, 0x71, 0x02, 0xE0, 0x17, 0x20, 0xCB, 0x07, 0x77, 0x20, 0x8D, 0x01, 0x58,
  0x21, 0x25, 0xCD, 0x82, 0x93, 0x11, 0x75, 0x01, 0x0E, 0xC0, 0x14, 0x02, 0xFD, 0x0C, 0x76, 0x06,
  0xC0, 0x14, 0x02, 0xFD, 0x0C, 0x77, 0x0C, 0xB0, 0x14, 0x02, 0xFD, 0x0C, 0x77, 0x04, 0xB0, 0x17,
  0x77, 0x74, 0x02, 0xB0, 0x17, 0x77, 0x74, 0x02, 0xB0, 0x17, 0x77, 0x74, 0x03, 0xB0, 0x17, 0x77,
  0x74, 0x03, 0xB7, 0x77, 0x75, 0x05, 0xA0, 0xE7, 0x77, 0x75, 0x07, 0xA0, 0xC7, 0x77, 0x75, 0x0B,
  0xA0, 0xA7, 0x77, 0x75, 0x0E, 0xA0, 0x77, 0x77, 0x74, 0x07, 0xB0, 0x37, 0x77, 0x73, 0x04, 0xB0,
  0xD7, 0x77, 0x71, 0x81, 0x13, 0x8C, 0x06, 0x77, 0x77, 0x04, 0xE0, 0xB7, 0x77, 0x71, 0x04, 0xD0,
  0xB0, 0x17, 0x77, 0x71, 0x04, 0xA8, 0x1D, 0xA4, 0x72,
  // "ŋ" (U+014B)
  0x77, 0x18, 0x41, 0x57, 0x75, 0x36, 0x05, 0xF9, 0x06, 0x30, 0x20, 0xAE, 0x0D, 0x06, 0x40, 0x5F,
  0x90, 0x82, 0x03, 0x0E, 0xFA, 0x0A, 0x30, 0x5F, 0x98, 0x2A, 0x01, 0xEF, 0xC0, 0xA3, 0x81, 0x24,
  0xBD, 0x81, 0xC0, 0xAA, 0x83, 0xC8, 0x8A, 0xEE, 0x04, 0x50, 0xAC, 0x83, 0xE3, 0xFD, 0x35, 0x09,
  0xD0, 0xB5, 0x04, 0xD8, 0x1B, 0xF3, 0x70, 0xCD, 0x01, 0x40, 0x2E, 0x07, 0x71, 0x04, 0xD0, 0x54,
  0x01, 0xE0, 0x17, 0x20, 0xEC, 0x07, 0x40, 0x1D, 0x0C, 0x73, 0x0B, 0xC0, 0x94, 0x01, 0xD0, 0x97,
  0x30, 0x9C, 0x0A, 0x40, 0x1D, 0x06, 0x73, 0x08, 0xC0, 0xB4, 0x01, 0xD0, 0x57, 0x30, 0x7C, 0x0C,
  0x40, 0x1D, 0x04, 0x73, 0x07, 0xC0, 0xC4, 0x01, 0xD0, 0x47, 0x30, 0x7C, 0x0C, 0x40, 0x1D, 0x04,
  0x73, 0x07, 0xC0, 0xC4, 0x01, 0xD0, 0x47, 0x30, 0x7C, 0x0C, 0x40, 0x1D, 0x04, 0x73, 0x07, 0xC0,
  0xC4, 0x01, 0xD0, 0x47, 0x30, 0x7C, 0x0C, 0x40, 0x1D, 0x04, 0x73, 0x07, 0xC0, 0xC4, 0x01, 0xD0,
  0x47, 0x30, 0x7C, 0x0C, 0x40, 0x1D, 0x04, 0x73, 0x07, 0xC0, 0xC4, 0x01, 0xD0, 0x47, 0x30, 0x7C,
  0x0C, 0x40, 0x1D, 0x04, 0x73, 0x07, 0xC0, 0xC4, 0x01, 0xD0, 0x47, 0x30, 0x7C, 0x0C, 0x40, 0x1D,
  0x04, 0x73, 0x07, 0xC0, 0xC4, 0x02, 0xD0, 0x47, 0x30, 0x7C, 0x0C, 0x40, 0x4D, 0x06, 0x73, 0x07,
  0xC0, 0xC4, 0x0A, 0xD0, 0xB7, 0x30, 0x7C, 0x83, 0xC0, 0x24, 0xBF, 0x81, 0xB5, 0x27, 0x07, 0xC0,
  0xC0, 0xAF, 0xE0, 0x76, 0x07, 0xC0, 0xC0, 0xAF, 0xE0, 0x76, 0x07, 0xC0, 0xC0, 0xAF, 0xE0, 0x76,
  0x07, 0xC0, 0xC7, 0x77, 0x07, 0xC0, 0xB7, 0x77, 0x08, 0xC0, 0xB7, 0x77, 0x08, 0xC0, 0xA7, 0x77,
  0x09, 0xC0, 0x97, 0x77, 0x0B, 0xC0, 0x77, 0x77, 0x0D, 0xC0, 0x57, 0x76, 0x01, 0xD0, 0x27, 0x76,
  0x05, 0xC0, 0xD7, 0x77, 0x0C, 0xC0, 0x77, 0x76, 0x06, 0xC0, 0xE0, 0x17, 0x73, 0x81, 0x13, 0xAD,
  0x06, 0x77, 0x40, 0xEE, 0x09, 0x77, 0x50, 0xEC, 0x0E, 0x06, 0x77, 0x68, 0x4E, 0xFD, 0xA6, 0x15,
  // "Ō" (U+014C)
  0x73, 0x80, 0x92, 0x17, 0x75, 0x09, 0xFF, 0x03, 0x77, 0x40, 0x9F, 0xF0, 0x37, 0x74, 0x09, 0xFF,
  0x03, 0x80, 0x9F, 0x00, 0x86, 0x14, 0x56, 0x76, 0x52, 0x77, 0x72, 0x81, 0x28, 0xDF, 0x98, 0x1E,
  0xA3, 0x77, 0x40, 0x10, 0x9F, 0xF0, 0xB0, 0x27, 0x71, 0x04, 0x0E, 0xD8, 0x4E, 0xB9, 0x9A, 0xCE,
  0x06, 0x76, 0x05, 0xD0, 0xD0, 0x56, 0x01, 0x08, 0xD0, 0x87, 0x40, 0x4D, 0x0A, 0x73, 0x03, 0x0E,
  0xC0, 0x77, 0x20, 0x20, 0xEC, 0x0B, 0x75, 0x03, 0xD0, 0x47, 0x10, 0xBC, 0x0E, 0x01, 0x76, 0x07,
  0xC0, 0xD7, 0x04, 0xD0, 0x77, 0x71, 0x0E, 0xC0, 0x76, 0x0B, 0xD0, 0x17, 0x71, 0x08, 0xC0, 0xE5,
  0x03, 0xD0, 0xA7, 0x72, 0x03, 0xD0, 0x64, 0x08, 0xD0, 0x57, 0x73, 0x0D, 0xC0, 0xC4, 0x0D, 0xD0,
  0x17, 0x73, 0x0A, 0xD0, 0x22, 0x02, 0xD0, 0xD7, 0x74, 0x06, 0xD0, 0x62, 0x05, 0xD0, 0xA7, 0x74,
  0x03, 0xD0, 0xA2, 0x08, 0xD0, 0x87, 0x74, 0x01, 0xD0, 0xD2, 0x0B, 0xD0, 0x67, 0x75, 0xE8, 0x11,
  0x0C, 0xD0, 0x47, 0x75, 0x0D, 0xD8, 0x12, 0x0E, 0xD0, 0x37, 0x75, 0x0C, 0xD0, 0x41, 0xE0, 0x27,
  0x75, 0x0B, 0xD0, 0x60, 0x1E, 0x01, 0x77, 0x50, 0xBD, 0x06, 0x01, 0xE0, 0x17, 0x75, 0x0A, 0xD0,
  0x70, 0x1E, 0x01, 0x77, 0x50, 0xAD, 0x07, 0x01, 0xE0, 0x17, 0x75, 0x0A, 0xD0, 0x71, 0xE0, 0x27,
  0x75, 0x0B, 0xD0, 0x61, 0xE0, 0x27, 0x75, 0x0B, 0xD8, 0x16, 0x0E, 0xD0, 0x37, 0x75, 0x0C, 0xD8,
  0x14, 0x0C, 0xD0, 0x47, 0x75, 0x0D, 0xD8, 0x12, 0x0A, 0xD0, 0x67, 0x75, 0xE2, 0x08, 0xD0, 0x87,
  0x74, 0x01, 0xD0, 0xD2, 0x05, 0xD0, 0xA7, 0x74, 0x03, 0xD0, 0xA2, 0x01, 0xD0, 0xD7, 0x74, 0x07,
  0xD0, 0x63, 0x0C, 0xD0, 0x17, 0x73, 0x0A, 0xD0, 0x13, 0x08, 0xD0, 0x57, 0x73, 0x0E, 0xC0, 0xC4,
  0x02, 0xD0, 0xA7, 0x72, 0x03, 0xD0, 0x65, 0x0B, 0xD0, 0x17, 0x71, 0x09, 0xC0, 0xE6, 0x04, 0xD0,
  0x77, 0x71, 0x0E, 0xC0, 0x77, 0x0A, 0xC0, 0xE0, 0x17, 0x60, 0x8C, 0x0D, 0x71, 0x01, 0x0E, 0xC0,
  0xB7, 0x50, 0x3D, 0x03, 0x72, 0x04, 0xD0, 0xA7, 0x30, 0x30, 0xEC, 0x06, 0x74, 0x05, 0xD0, 0xD0,
  0x56, 0x02, 0x09, 0xD0, 0x77, 0x60, 0x40, 0xED, 0x84, 0xEB, 0x99, 0xAD, 0xE0, 0x57, 0x71, 0x01,
  0x0A, 0xFF, 0x0B, 0x02, 0x77, 0x48, 0x12, 0x8D, 0xF9, 0x81, 0xE9, 0x37, 0x77, 0x28, 0x61, 0x46,
  0x77, 0x65, 0x27, 0x60,
  // "ō" (U+014D)
  0x68, 0x09, 0x21, 0x74, 0x09, 0xFF, 0x03, 0x73, 0x09, 0xFF, 0x03, 0x73, 0x09, 0xFF, 0x03, 0x80,
  0x9E, 0x20, 0x85, 0x14, 0x67, 0x76, 0x47, 0x73, 0x05, 0x0C, 0xF9, 0x0A, 0x03, 0x75, 0x02, 0x0C,
  0xFD, 0x09, 0x73, 0x03, 0x0E, 0xD8, 0x2B, 0x9A, 0xCD, 0x0C, 0x01, 0x70, 0x20, 0xEC, 0x0A, 0x01,
  0x40, 0x20, 0xBC, 0x0C, 0x70, 0xBC, 0x09, 0x71, 0x0B, 0xC0, 0x85, 0x04, 0xC0, 0xE0, 0x17, 0x10,
  0x2D, 0x01, 0x40, 0xBC, 0x08, 0x73, 0x0A, 0xC0, 0x83, 0x01, 0xD0, 0x27, 0x30, 0x4C, 0x0E, 0x30,
  0x6C, 0x0E, 0x75, 0xD0, 0x32, 0x09, 0xC0, 0xB7, 0x50, 0xDC, 0x07, 0x20, 0xCC, 0x08, 0x75, 0x0A,
  0xC0, 0xA2, 0x0E, 0xC0, 0x67, 0x50, 0x8C, 0x81, 0xD0, 0x1D, 0x05, 0x75, 0x07, 0xC8, 0x1E, 0x02,
  0xD0, 0x47, 0x50, 0x6D, 0x10, 0x3D, 0x04, 0x75, 0x06, 0xD0, 0x10, 0x3D, 0x03, 0x75, 0x05, 0xD0,
  0x10, 0x3D, 0x03, 0x75, 0x05, 0xD0, 0x10, 0x3D, 0x04, 0x75, 0x06, 0xD0, 0x10, 0x2D, 0x04, 0x75,
  0x06, 0xD1, 0x01, 0xD0, 0x57, 0x50, 0x7C, 0x0E, 0x20, 0xEC, 0x07, 0x75, 0x09, 0xC0, 0xD2, 0x0C,
  0xC0, 0x87, 0x50, 0xAC, 0x0A, 0x20, 0x9C, 0x0B, 0x75, 0x0D, 0xC0, 0x72, 0x05, 0xC0, 0xE7, 0x40,
  0x1D, 0x04, 0x20, 0x1D, 0x03, 0x73, 0x05, 0xC0, 0xE4, 0x0A, 0xC0, 0x97, 0x30, 0xAC, 0x09, 0x40,
  0x3C, 0x0E, 0x01, 0x71, 0x02, 0xD0, 0x25, 0x09, 0xC0, 0xA7, 0x10, 0xBC, 0x09, 0x70, 0xDC, 0x0B,
  0x02, 0x40, 0x20, 0xBC, 0x0D, 0x71, 0x01, 0x0D, 0xD8, 0x2C, 0x99, 0xCD, 0x0D, 0x02, 0x72, 0x01,
  0x0B, 0xFD, 0x0B, 0x01, 0x75, 0x04, 0x0B, 0xF9, 0x0B, 0x04, 0x77, 0x28, 0x51, 0x46, 0x77, 0x64,
  0x73,
  // "Ŏ" (U+014E)
  0x72, 0x08, 0xA0, 0x17, 0x10, 0x8A, 0x77, 0x50, 0x7A, 0x06, 0x71, 0x81, 0xDF, 0xE7, 0x75, 0x03,
  0xA0, 0xE0, 0x26, 0x08, 0xA0, 0xB7, 0x76, 0x0E, 0xA8, 0x5E, 0x72, 0x01, 0x4B, 0xB0, 0x67, 0x76,
  0x07, 0xFC, 0x0E, 0x77, 0x71, 0x0C, 0xFB, 0x05, 0x77, 0x71, 0x01, 0x0C, 0xF9, 0x06, 0x77, 0x74,
  0x86, 0x5A, 0xDF, 0xEC, 0x82, 0x80, 0x9F, 0x40, 0x86, 0x14, 0x56, 0x76, 0x52, 0x77, 0x72, 0x81,
  0x28, 0xDF, 0x98, 0x1E, 0xA3, 0x77, 0x40, 0x10, 0x9F, 0xF0, 0xB0, 0x27, 0x71, 0x04, 0x0E, 0xD8,
  0x4E, 0xB9, 0x9A, 0xCE, 0x06, 0x76, 0x05, 0xD0, 0xD0, 0x56, 0x01, 0x08, 0xD0, 0x87, 0x40, 0x4D,
  0x0A, 0x73, 0x03, 0x0E, 0xC0, 0x77, 0x20, 0x20, 0xEC, 0x0B, 0x75, 0x03, 0xD0, 0x47, 0x10, 0xBC,
  0x0E, 0x01, 0x76, 0x07, 0xC0, 0xD7, 0x04, 0xD0, 0x77, 0x71, 0x0E, 0xC0, 0x76, 0x0B, 0xD0, 0x17,
  0x71, 0x08, 0xC0, 0xE5, 0x03, 0xD0, 0xA7, 0x72, 0x03, 0xD0, 0x64, 0x08, 0xD0, 0x57, 0x73, 0x0D,
  0xC0, 0xC4, 0x0D, 0xD0, 0x17, 0x73, 0x0A, 0xD0, 0x22, 0x02, 0xD0, 0xD7, 0x74, 0x06, 0xD0, 0x62,
  0x05, 0xD0, 0xA7, 0x74, 0x03, 0xD0, 0xA2, 0x08, 0xD0, 0x87, 0x74, 0x01, 0xD0, 0xD2, 0x0B, 0xD0,
  0x67, 0x75, 0xE8, 0x11, 0x0C, 0xD0, 0x47, 0x75, 0x0D, 0xD8, 0x12, 0x0E, 0xD0, 0x37, 0x75, 0x0C,
  0xD0, 0x41, 0xE0, 0x27, 0x75, 0x0B, 0xD0, 0x60, 0x1E, 0x01, 0x77, 0x50, 0xBD, 0x06, 0x01, 0xE0,
  0x17, 0x75, 0x0A, 0xD0, 0x70, 0x1E, 0x01, 0x77, 0x50, 0xAD, 0x07, 0x01, 0xE0, 0x17, 0x75, 0x0A,
  0xD0, 0x71, 0xE0, 0x27, 0x75, 0x0B, 0xD0, 0x61, 0xE0, 0x27, 0x75, 0x0B, 0xD8, 0x16, 0x0E, 0xD0,
  0x37, 0x75, 0x0C, 0xD8, 0x14, 0x0C, 0xD0, 0x47, 0x75, 0x0D, 0xD8, 0x12, 0x0A, 0xD0, 0x67, 0x75,
  0xE2, 0x08, 0xD0, 0x87, 0x74, 0x01, 0xD0, 0xD2, 0x05, 0xD0, 0xA7, 0x74, 0x03, 0xD0, 0xA2, 0x01,
  0xD0, 0xD7, 0x74, 0x07, 0xD0, 0x63, 0x0C, 0xD0, 0x17, 0x73, 0x0A, 0xD0, 0x13, 0x08, 0xD0, 0x57,
  0x73, 0x0E, 0xC0, 0xC4, 0x02, 0xD0, 0xA7, 0x72, 0x03, 0xD0, 0x65, 0x0B, 0xD0, 0x17, 0x71, 0x09,
  0xC0, 0xE6, 0x04, 0xD0, 0x77, 0x71, 0x0E, 0xC0, 0x77, 0x0A, 0xC0, 0xE0, 0x17, 0x60, 0x8C, 0x0D,
  0x71, 0x01, 0x0E, 0xC0, 0xB7, 0x50, 0x3D, 0x03, 0x72, 0x04, 0xD0, 0xA7, 0x30, 0x30, 0xEC, 0x06,
  0x74, 0x05, 0xD0, 0xD0, 0x56, 0x02, 0x09, 0xD0, 0x77, 0x60, 0x40, 0xED, 0x84, 0xEB, 0x99, 0xAD,
  0xE0, 0x57, 0x71, 0x01, 0x0A, 0xFF, 0x0B, 0x02, 0x77, 0x48, 0x12, 0x8D, 0xF9, 0x81, 0xE9, 0x37,
  0x77, 0x28, 0x61, 0x46, 0x77, 0x65, 0x27, 0x60,
  // "ŏ" (U+014F)
  0x50, 0x8A, 0x01, 0x71, 0x08, 0xA7, 0x40, 0x7A, 0x06, 0x71, 0x81, 0xDF, 0xE7, 0x40, 0x3A, 0x0E,
  0x02, 0x60, 0x8A, 0x0B, 0x75, 0x0E, 0xA8, 0x5E, 0x72, 0x01, 0x4B, 0xB0, 0x67, 0x50, 0x7F, 0xC0,
  0xE7, 0x70, 0xCF, 0xB0, 0x57, 0x70, 0x10, 0xCF, 0x90, 0x67, 0x73, 0x86, 0x5A, 0xDF, 0xEC, 0x82,
  0x80, 0x9E, 0x60, 0x85, 0x14, 0x67, 0x76, 0x47, 0x73, 0x05, 0x0C, 0xF9, 0x0A, 0x03, 0x75, 0x02,
  0x0C, 0xFD, 0x09, 0x73, 0x03, 0x0E, 0xD8, 0x2B, 0x9A, 0xCD, 0x0C, 0x01, 0x70, 0x20, 0xEC, 0x0A,
  0x01, 0x40, 0x20, 0xBC, 0x0C, 0x70, 0xBC, 0x09, 0x71, 0x0B, 0xC0, 0x85, 0x04, 0xC0, 0xE0, 0x17,
  0x10, 0x2D, 0x01, 0x40, 0xBC, 0x08, 0x73, 0x0A, 0xC0, 0x83, 0x01, 0xD0, 0x27, 0x30, 0x4C, 0x0E,
  0x30, 0x6C, 0x0E, 0x75, 0xD0, 0x32, 0x09, 0xC0, 0xB7, 0x50, 0xDC, 0x07, 0x20, 0xCC, 0x08, 0x75,
  0x0A, 0xC0, 0xA2, 0x0E, 0xC0, 0x67, 0x50, 0x8C, 0x81, 0xD0, 0x1D, 0x05, 0x75, 0x07, 0xC8, 0x1E,
  0x02, 0xD0, 0x47, 0x50, 0x6D, 0x10, 0x3D, 0x04, 0x75, 0x06, 0xD0, 0x10, 0x3D, 0x03, 0x75, 0x05,
  0xD0, 0x10, 0x3D, 0x03, 0x75, 0x05, 0xD0, 0x10, 0x3D, 0x04, 0x75, 0x06, 0xD0, 0x10, 0x2D, 0x04,
  0x75, 0x06, 0xD1, 0x01, 0xD0, 0x57, 0x50, 0x7C, 0x0E, 0x20, 0xEC, 0x07, 0x75, 0x09, 0xC0, 0xD2,
  0x0C, 0xC0, 0x87, 0x50, 0xAC, 0x0A, 0x20, 0x9C, 0x0B, 0x75, 0x0D, 0xC0, 0x72, 0x05, 0xC0, 0xE7,
  0x40, 0x1D, 0x04, 0x20, 0x1D, 0x03, 0x73, 0x05, 0xC0, 0xE4, 0x0A, 0xC0, 0x97, 0x30, 0xAC, 0x09,
  0x40, 0x3C, 0x0E, 0x01, 0x71, 0x02, 0xD0, 0x25, 0x09, 0xC0, 0xA7, 0x10, 0xBC, 0x09, 0x70, 0xDC,
  0x0B, 0x02, 0x40, 0x20, 0xBC, 0x0D, 0x71, 0x01, 0x0D, 0xD8, 0x2C, 0x99, 0xCD, 0x0D, 0x02, 0x72,
  0x01, 0x0B, 0xFD, 0x0B, 0x01, 0x75, 0x04, 0x0B, 0xF9, 0x0B, 0x04, 0x77, 0x28, 0x51, 0x46, 0x77,
  0x64, 0x73,
  // "Ő" (U+0150)
  0x76, 0x08, 0xC0, 0xD3, 0x03, 0xD0, 0x37, 0x74, 0x0E, 0xC0, 0x63, 0x09, 0xC0, 0xB7, 0x74, 0x05,
  0xC0, 0xB3, 0x01, 0x0E, 0xB0, 0xE0, 0x17, 0x74, 0x0C, 0xB0, 0xE0, 0x13, 0x07, 0xC0, 0x57, 0x74,
  0x04, 0xC0, 0x44, 0x0E, 0xB0, 0x97, 0x75, 0x0C, 0xB0, 0x74, 0x07, 0xB0, 0xC7, 0x75, 0x04, 0xB0,
  0xB5, 0x0E, 0xA0, 0xE0, 0x17, 0x75, 0x0B, 0xA0, 0xD0, 0x14, 0x07, 0xB0, 0x37, 0x75, 0x04, 0xA0,
  0xE0, 0x25, 0x0E, 0xA0, 0x67, 0x76, 0x82, 0x9F, 0xE3, 0x50, 0x4A, 0x07, 0x80, 0x9F, 0x30, 0x86,
  0x14, 0x56, 0x76, 0x52, 0x77, 0x72, 0x81, 0x28, 0xDF, 0x98, 0x1E, 0xA3, 0x77, 0x40, 0x10, 0x9F,
  0xF0, 0xB0, 0x27, 0x71, 0x04, 0x0E, 0xD8, 0x4E, 0xB9, 0x9A, 0xCE, 0x06, 0x76, 0x05, 0xD0, 0xD0,
  0x56, 0x01, 0x08, 0xD0, 0x87, 0x40, 0x4D, 0x0A, 0x73, 0x03, 0x0E, 0xC0, 0x77, 0x20, 0x20, 0xEC,
  0x0B, 0x75, 0x03, 0xD0, 0x47, 0x10, 0xBC, 0x0E, 0x01, 0x76, 0x07, 0xC0, 0xD7, 0x04, 0xD0, 0x77,
  0x71, 0x0E, 0xC0, 0x76, 0x0B, 0xD0, 0x17, 0x71, 0x08, 0xC0, 0xE5, 0x03, 0xD0, 0xA7, 0x72, 0x03,
  0xD0, 0x64, 0x08, 0xD0, 0x57, 0x73, 0x0D, 0xC0, 0xC4, 0x0D, 0xD0, 0x17, 0x73, 0x0A, 0xD0, 0x22,
  0x02, 0xD0, 0xD7, 0x74, 0x06, 0xD0, 0x62, 0x05, 0xD0, 0xA7, 0x74, 0x03, 0xD0, 0xA2, 0x08, 0xD0,
  0x87, 0x74, 0x01, 0xD0, 0xD2, 0x0B, 0xD0, 0x67, 0x75, 0xE8, 0x11, 0x0C, 0xD0, 0x47, 0x75, 0x0D,
  0xD8, 0x12, 0x0E, 0xD0, 0x37, 0x75, 0x0C, 0xD0, 0x41, 0xE0, 0x27, 0x75, 0x0B, 0xD0, 0x60, 0x1E,
  0x01, 0x77, 0x50, 0xBD, 0x06, 0x01, 0xE0, 0x17, 0x75, 0x0A, 0xD0, 0x70, 0x1E, 0x01, 0x77, 0x50,
  0xAD, 0x07, 0x01, 0xE0, 0x17, 0x75, 0x0A, 0xD0, 0x71, 0xE0, 0x27, 0x75, 0x0B, 0xD0, 0x61, 0xE0,
  0x27, 0x75, 0x0B, 0xD8, 0x16, 0x0E, 0xD0, 0x37, 0x75, 0x0C, 0xD8, 0x14, 0x0C, 0xD0, 0x47, 0x75,
  0x0D, 0xD8, 0x12, 0x0A, 0xD0, 0x67, 0x75, 0xE2, 0x08, 0xD0, 0x87, 0x74, 0x01, 0xD0, 0xD2, 0x05,
  0xD0, 0xA7, 0x74, 0x03, 0xD0, 0xA2, 0x01, 0xD0, 0xD7, 0x74, 0x07, 0xD0, 0x63, 0x0C, 0xD0, 0x17,
  0x73, 0x0A, 0xD0, 0x13, 0x08, 0xD0, 0x57, 0x73, 0x0E, 0xC0, 0xC4, 0x02, 0xD0, 0xA7, 0x72, 0x03,
  0xD0, 0x65, 0x0B, 0xD0, 0x17, 0x71, 0x09, 0xC0, 0xE6, 0x04, 0xD0, 0x77, 0x71, 0x0E, 0xC0, 0x77,
  0x0A, 0xC0, 0xE0, 0x17, 0x60, 0x8C, 0x0D, 0x71, 0x01, 0x0E, 0xC0, 0xB7, 0x50, 0x3D, 0x03, 0x72,
  0x04, 0xD0, 0xA7, 0x30, 0x30, 0xEC, 0x06, 0x74, 0x05, 0xD0, 0xD0, 0x56, 0x02, 0x09, 0xD0, 0x77,
  0x60, 0x40, 0xED, 0x84, 0xEB, 0x99, 0xAD, 0xE0, 0x57, 0x71, 0x01, 0x0A, 0xFF, 0x0B, 0x02, 0x77,
  0x48, 0x12, 0x8D, 0xF9, 0x81, 0xE9, 0x37, 0x77, 0x28, 0x61, 0x46, 0x77, 0x65, 0x27, 0x60,
  // "ő" (U+0151)
  0x72, 0x08, 0xC0, 0xD3, 0x03, 0xD0, 0x37, 0x30, 0xEC, 0x06, 0x30, 0x9C, 0x0B, 0x73, 0x05, 0xC0,
  0xB3, 0x01, 0x0E, 0xB0, 0xE0, 0x17, 0x30, 0xCB, 0x0E, 0x01, 0x30, 0x7C, 0x05, 0x73, 0x04, 0xC0,
  0x44, 0x0E, 0xB0, 0x97, 0x40, 0xCB, 0x07, 0x40, 0x7B, 0x0C, 0x74, 0x04, 0xB0, 0xB5, 0x0E, 0xA0,
  0xE0, 0x17, 0x40, 0xBA, 0x0D, 0x01, 0x40, 0x7B, 0x03, 0x74, 0x04, 0xA0, 0xE0, 0x25, 0x0E, 0xA0,
  0x67, 0x58, 0x29, 0xFE, 0x35, 0x04, 0xA0, 0x78, 0x09, 0xE5, 0x08, 0x51, 0x46, 0x77, 0x64, 0x77,
  0x30, 0x50, 0xCF, 0x90, 0xA0, 0x37, 0x50, 0x20, 0xCF, 0xD0, 0x97, 0x30, 0x30, 0xED, 0x82, 0xB9,
  0xAC, 0xD0, 0xC0, 0x17, 0x02, 0x0E, 0xC0, 0xA0, 0x14, 0x02, 0x0B, 0xC0, 0xC7, 0x0B, 0xC0, 0x97,
  0x10, 0xBC, 0x08, 0x50, 0x4C, 0x0E, 0x01, 0x71, 0x02, 0xD0, 0x14, 0x0B, 0xC0, 0x87, 0x30, 0xAC,
  0x08, 0x30, 0x1D, 0x02, 0x73, 0x04, 0xC0, 0xE3, 0x06, 0xC0, 0xE7, 0x5D, 0x03, 0x20, 0x9C, 0x0B,
  0x75, 0x0D, 0xC0, 0x72, 0x0C, 0xC0, 0x87, 0x50, 0xAC, 0x0A, 0x20, 0xEC, 0x06, 0x75, 0x08, 0xC8,
  0x1D, 0x01, 0xD0, 0x57, 0x50, 0x7C, 0x81, 0xE0, 0x2D, 0x04, 0x75, 0x06, 0xD1, 0x03, 0xD0, 0x47,
  0x50, 0x6D, 0x01, 0x03, 0xD0, 0x37, 0x50, 0x5D, 0x01, 0x03, 0xD0, 0x37, 0x50, 0x5D, 0x01, 0x03,
  0xD0, 0x47, 0x50, 0x6D, 0x01, 0x02, 0xD0, 0x47, 0x50, 0x6D, 0x10, 0x1D, 0x05, 0x75, 0x07, 0xC0,
  0xE2, 0x0E, 0xC0, 0x77, 0x50, 0x9C, 0x0D, 0x20, 0xCC, 0x08, 0x75, 0x0A, 0xC0, 0xA2, 0x09, 0xC0,
  0xB7, 0x50, 0xDC, 0x07, 0x20, 0x5C, 0x0E, 0x74, 0x01, 0xD0, 0x42, 0x01, 0xD0, 0x37, 0x30, 0x5C,
  0x0E, 0x40, 0xAC, 0x09, 0x73, 0x0A, 0xC0, 0x94, 0x03, 0xC0, 0xE0, 0x17, 0x10, 0x2D, 0x02, 0x50,
  0x9C, 0x0A, 0x71, 0x0B, 0xC0, 0x97, 0x0D, 0xC0, 0xB0, 0x24, 0x02, 0x0B, 0xC0, 0xD7, 0x10, 0x10,
  0xDD, 0x82, 0xC9, 0x9C, 0xD0, 0xD0, 0x27, 0x20, 0x10, 0xBF, 0xD0, 0xB0, 0x17, 0x50, 0x40, 0xBF,
  0x90, 0xB0, 0x47, 0x72, 0x85, 0x14, 0x67, 0x76, 0x47, 0x30,
  // "Œ" (U+0152)
  0x76, 0x87, 0x14, 0x56, 0x76, 0x54, 0x27, 0x77, 0x76, 0x81, 0x28, 0xDF, 0xFF, 0xFA, 0x09, 0x73,
  0x01, 0x09, 0xFF, 0xFF, 0xD0, 0x97, 0x20, 0x40, 0xED, 0x85, 0xEB, 0x99, 0x9B, 0xDF, 0x80, 0x4E,
  0xF0, 0xA7, 0x10, 0x5D, 0x0D, 0x05, 0x70, 0x20, 0xDC, 0x0C, 0x72, 0x01, 0x07, 0xC0, 0xA7, 0x04,
  0xD0, 0xA7, 0x30, 0xCC, 0x0C, 0x74, 0x06, 0xB0, 0xB6, 0x02, 0x0E, 0xC0, 0xB7, 0x40, 0xCC, 0x0C,
  0x75, 0x0D, 0xA0, 0xB6, 0x0B, 0xC0, 0xE0, 0x17, 0x40, 0xCC, 0x0C, 0x75, 0x07, 0xA0, 0xC5, 0x04,
  0xD0, 0x77, 0x50, 0xCC, 0x0C, 0x75, 0x04, 0xA0, 0xC5, 0x0B, 0xD0, 0x17, 0x50, 0xCC, 0x0C, 0x75,
  0x02, 0xA0, 0xD4, 0x03, 0xD0, 0xA7, 0x60, 0xCC, 0x0C, 0x75, 0x01, 0xA0, 0xD4, 0x08, 0xD0, 0x57,
  0x60, 0xCC, 0x0C, 0x76, 0x81, 0x66, 0x54, 0x0D, 0xD0, 0x17, 0x60, 0xCC, 0x0C, 0x77, 0x50, 0x2D,
  0x0D, 0x77, 0x0C, 0xC0, 0xC7, 0x75, 0x05, 0xD0, 0xA7, 0x70, 0xCC, 0x0C, 0x77, 0x50, 0x8D, 0x08,
  0x77, 0x0C, 0xC0, 0xC7, 0x75, 0x0B, 0xD0, 0x67, 0x70, 0xCC, 0x0C, 0x77, 0x50, 0xCD, 0x04, 0x77,
  0x0C, 0xC0, 0xC7, 0x75, 0x0E, 0xD0, 0x37, 0x70, 0xCC, 0x0C, 0x77, 0x5E, 0x02, 0x77, 0x0C, 0xC0,
  0xC8, 0x09, 0x01, 0x60, 0x1E, 0x01, 0x77, 0x0C, 0xFF, 0xB0, 0x25, 0x01, 0xE0, 0x17, 0x70, 0xCF,
  0xFB, 0x02, 0x50, 0x1E, 0x01, 0x77, 0x0C, 0xFF, 0xB0, 0x25, 0x01, 0xE0, 0x17, 0x70, 0xCC, 0x0C,
  0x77, 0x5E, 0x02, 0x77, 0x0C, 0xC0, 0xC7, 0x75, 0xE0, 0x27, 0x70, 0xCC, 0x0C, 0x77, 0x50, 0xED,
  0x03, 0x77, 0x0C, 0xC0, 0xC7, 0x75, 0x0C, 0xD0, 0x47, 0x70, 0xCC, 0x0C, 0x77, 0x50, 0xAD, 0x06,
  0x77, 0x0C, 0xC0, 0xC7, 0x75, 0x08, 0xD0, 0x87, 0x70, 0xCC, 0x0C, 0x77, 0x50, 0x5D, 0x0A, 0x77,
  0x0C, 0xC0, 0xC7, 0x75, 0x01, 0xD0, 0xD7, 0x70, 0xCC, 0x0C, 0x77, 0x60, 0xCD, 0x01, 0x76, 0x0C,
  0xC0, 0xC7, 0x76, 0x08, 0xD0, 0x57, 0x60, 0xCC, 0x0C, 0x77, 0x82, 0x17, 0x74, 0x20, 0x2D, 0x0A,
  0x76, 0x0C, 0xC0, 0xC7, 0x70, 0x5A, 0x08, 0x30, 0xBD, 0x01, 0x75, 0x0C, 0xC0, 0xC7, 0x70, 0x8A,
  0x08, 0x30, 0x4D, 0x07, 0x75, 0x0C, 0xC0, 0xC7, 0x70, 0xAA, 0x07, 0x40, 0xAC, 0x0E, 0x01, 0x74,
  0x0C, 0xC0, 0xC7, 0x70, 0xEA, 0x07, 0x40, 0x10, 0xEC, 0x0B, 0x74, 0x0C, 0xC0, 0xC7, 0x60, 0x5B,
  0x06, 0x50, 0x4D, 0x0A, 0x73, 0x0C, 0xC0, 0xC7, 0x50, 0x10, 0xDB, 0x06, 0x60, 0x5D, 0x0D, 0x05,
  0x70, 0x20, 0xDC, 0x0C, 0x74, 0x04, 0x0D, 0xC0, 0x57, 0x04, 0x0E, 0xD8, 0x5E, 0xB9, 0x9A, 0xBD,
  0xF8, 0x05, 0xEF, 0x90, 0x57, 0x10, 0x10, 0xAF, 0xFF, 0xFF, 0x05, 0x73, 0x81, 0x28, 0xDF, 0xFF,
  0xFC, 0x04, 0x76, 0x87, 0x14, 0x67, 0x76, 0x54, 0x27, 0x77, 0x30,
  // "œ" (U+0153)
  0x72, 0x85, 0x14, 0x67, 0x76, 0x37, 0x58, 0x42, 0x57, 0x75, 0x47, 0x72, 0x05, 0x0C, 0xF8, 0x1E,
  0x92, 0x70, 0x60, 0xDF, 0x0A, 0x03, 0x74, 0x02, 0x0C, 0xFD, 0x07, 0x40, 0x10, 0xBF, 0xC0, 0x87,
  0x20, 0x30, 0xED, 0x82, 0xB9, 0xAC, 0xD0, 0x82, 0x01, 0x0D, 0xC8, 0x2E, 0xA9, 0xBD, 0x0A, 0x70,
  0x20, 0xEC, 0x0A, 0x01, 0x40, 0x20, 0xBC, 0x81, 0x60, 0xBC, 0x07, 0x40, 0x20, 0xDC, 0x08, 0x60,
  0xBC, 0x09, 0x71, 0x0B, 0xB0, 0xE0, 0x7C, 0x07, 0x60, 0x10, 0xEC, 0x03, 0x40, 0x4C, 0x0E, 0x01,
  0x71, 0x02, 0xF9, 0x0D, 0x71, 0x08, 0xC0, 0xB4, 0x0B, 0xC0, 0x87, 0x30, 0xAF, 0x06, 0x71, 0x02,
  0xD0, 0x12, 0x01, 0xD0, 0x27, 0x30, 0x5F, 0x01, 0x72, 0x0D, 0xC0, 0x72, 0x06, 0xC0, 0xE7, 0x40,
  0x1E, 0x0C, 0x73, 0x0A, 0xC0, 0xA2, 0x09, 0xC0, 0xB7, 0x50, 0xDD, 0x09, 0x73, 0x07, 0xC0, 0xD2,
  0x0C, 0xC0, 0x87, 0x50, 0xBD, 0x06, 0x73, 0x05, 0xD2, 0x0E, 0xC0, 0x67, 0x50, 0x9D, 0x05, 0x73,
  0x04, 0xD0, 0x01, 0xD0, 0x57, 0x50, 0x7D, 0x05, 0x80, 0x61, 0x04, 0xD0, 0x02, 0xD0, 0x47, 0x50,
  0x6F, 0xFF, 0x90, 0x03, 0xD0, 0x47, 0x50, 0x6F, 0xFF, 0x90, 0x03, 0xD0, 0x37, 0x50, 0x5F, 0xFF,
  0x90, 0x03, 0xD0, 0x37, 0x50, 0x5D, 0x02, 0x77, 0x30, 0x3D, 0x04, 0x75, 0x06, 0xD0, 0x27, 0x73,
  0x02, 0xD0, 0x47, 0x50, 0x6D, 0x03, 0x77, 0x30, 0x1D, 0x05, 0x75, 0x07, 0xD0, 0x47, 0x74, 0x0E,
  0xC0, 0x77, 0x50, 0x9D, 0x07, 0x77, 0x40, 0xCC, 0x08, 0x75, 0x0B, 0xD0, 0x97, 0x74, 0x09, 0xC0,
  0xB7, 0x50, 0xED, 0x0C, 0x77, 0x40, 0x5C, 0x0E, 0x74, 0x01, 0xF0, 0x17, 0x73, 0x01, 0xD0, 0x37,
  0x30, 0x5F, 0x06, 0x77, 0x40, 0xAC, 0x09, 0x73, 0x0A, 0xF0, 0xD7, 0x50, 0x80, 0xC4, 0x03, 0xC0,
  0xE0, 0x17, 0x10, 0x2F, 0xA0, 0x67, 0x30, 0x3A, 0x01, 0x40, 0x9C, 0x0A, 0x71, 0x0B, 0xC0, 0xAD,
  0x03, 0x71, 0x82, 0x3E, 0xFE, 0x60, 0xDC, 0x0B, 0x02, 0x40, 0x20, 0xBC, 0x81, 0xA0, 0xAD, 0x07,
  0x50, 0x10, 0x7B, 0x08, 0x60, 0x10, 0xDD, 0x82, 0xC9, 0x9C, 0xD0, 0xC3, 0x0C, 0xD8, 0x3E, 0xB9,
  0x9B, 0xC0, 0xC7, 0x10, 0x10, 0xBF, 0xD0, 0x95, 0x0A, 0xFD, 0x0B, 0x01, 0x73, 0x04, 0x0B, 0xF9,
  0x0A, 0x03, 0x70, 0x40, 0xBF, 0x90, 0xB0, 0x57, 0x78, 0x51, 0x46, 0x77, 0x63, 0x75, 0x86, 0x14,
  0x67, 0x76, 0x41, 0x70,
  // "Ŕ" (U+0154)
  0x77, 0x38, 0x02, 0x77, 0x77, 0x60, 0x4D, 0x0C, 0x77, 0x76, 0x0B, 0xC0, 0xE0, 0x27, 0x77, 0x50,
  0x4D, 0x04, 0x77, 0x76, 0x0C, 0xC0, 0x67, 0x77, 0x60, 0x5C, 0x07, 0x77, 0x77, 0x0E, 0xB0, 0x77,
  0x77, 0x70, 0x8B, 0x06, 0x77, 0x77, 0x02, 0xB0, 0x57, 0x77, 0x71, 0x82, 0x8F, 0xE3, 0x80, 0xAA,
  0x60, 0x02, 0xFF, 0x98, 0x4E, 0xDC, 0x96, 0x27, 0x50, 0x2F, 0xFF, 0x0C, 0x06, 0x73, 0x82, 0x17,
  0x9C, 0xF0, 0xE8, 0x00, 0xDF, 0x90, 0xB0, 0x27, 0x50, 0x30, 0xED, 0x06, 0x58, 0x12, 0x7E, 0xD0,
  0xD0, 0x17, 0x50, 0x8D, 0x06, 0x71, 0x0B, 0xD0, 0xC7, 0x50, 0x5D, 0x06, 0x72, 0x0D, 0xD0, 0x57,
  0x40, 0x4D, 0x06, 0x72, 0x05, 0xD0, 0xC7, 0x40, 0x4D, 0x06, 0x73, 0x0E, 0xD0, 0x17, 0x30, 0x4D,
  0x06, 0x73, 0x0B, 0xD0, 0x57, 0x30, 0x4D, 0x06, 0x73, 0x08, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73,
  0x07, 0xD0, 0x77, 0x30, 0x4D, 0x06, 0x73, 0x06, 0xD0, 0x87, 0x30, 0x4D, 0x06, 0x73, 0x07, 0xD0,
  0x87, 0x30, 0x4D, 0x06, 0x73, 0x08, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x0A, 0xD0, 0x47, 0x30,
  0x4D, 0x06, 0x73, 0x0D, 0xD7, 0x40, 0x4D, 0x06, 0x72, 0x03, 0xD0, 0xA7, 0x40, 0x4D, 0x06, 0x72,
  0x0A, 0xD0, 0x27, 0x40, 0x4D, 0x06, 0x71, 0x04, 0xD0, 0x87, 0x50, 0x4D, 0x06, 0x70, 0x5D, 0x0A,
  0x76, 0x04, 0xD0, 0x63, 0x82, 0x12, 0x6C, 0xD0, 0x97, 0x70, 0x4F, 0xFA, 0x0D, 0x05, 0x77, 0x10,
  0x4F, 0xF9, 0x06, 0x77, 0x30, 0x4F, 0xF9, 0x07, 0x77, 0x30, 0x4D, 0x83, 0x71, 0x11, 0x2D, 0x0E,
  0x01, 0x77, 0x20, 0x4D, 0x06, 0x40, 0x9D, 0x09, 0x77, 0x20, 0x4D, 0x06, 0x40, 0x1E, 0x02, 0x77,
  0x10, 0x4D, 0x06, 0x50, 0x9D, 0x0A, 0x77, 0x10, 0x4D, 0x06, 0x50, 0x1E, 0x03, 0x77, 0x04, 0xD0,
  0x66, 0x09, 0xD0, 0xC7, 0x70, 0x4D, 0x06, 0x60, 0x1E, 0x05, 0x76, 0x04, 0xD0, 0x67, 0x09, 0xD0,
  0xD7, 0x60, 0x4D, 0x06, 0x70, 0x1E, 0x06, 0x75, 0x04, 0xD0, 0x67, 0x10, 0x9D, 0x0E, 0x75, 0x04,
  0xD0, 0x67, 0x10, 0x1E, 0x07, 0x74, 0x04, 0xD0, 0x67, 0x20, 0x9D, 0x0E, 0x01, 0x73, 0x04, 0xD0,
  0x67, 0x20, 0x1E, 0x0A, 0x73, 0x06, 0xD0, 0x87, 0x30, 0x9E, 0x05, 0x72, 0x0C, 0xD0, 0xD7, 0x30,
  0x10, 0xED, 0x0E, 0x03, 0x48, 0x21, 0x25, 0xCF, 0x82, 0xC5, 0x21, 0x70, 0x6F, 0x82, 0x72, 0x02,
  0xFF, 0x97, 0x10, 0xAF, 0x90, 0x50, 0x2F, 0xF9, 0x72, 0x07, 0xF0, 0x50, 0x2F, 0xF9, 0x73, 0x83,
  0x17, 0xBD, 0xEA, 0x05,
  // "ŕ" (U+0155)
  0x76, 0x80, 0x27, 0x77, 0x20, 0x4D, 0x0C, 0x77, 0x20, 0xBC, 0x0E, 0x02, 0x77, 0x10, 0x4D, 0x04,
  0x77, 0x20, 0xCC, 0x06, 0x77, 0x20, 0x5C, 0x07, 0x77, 0x30, 0xEB, 0x07, 0x77, 0x30, 0x8B, 0x06,
  0x77, 0x30, 0x2B, 0x05, 0x77, 0x48, 0x28, 0xFE, 0x38, 0x09, 0xE2, 0x08, 0x33, 0x57, 0x64, 0x30,
  0x5F, 0x90, 0x13, 0x02, 0x0C, 0xD8, 0x2D, 0x40, 0x5F, 0x90, 0x32, 0x03, 0x0E, 0xF9, 0x02, 0x05,
  0xF9, 0x05, 0x20, 0xDF, 0xA8, 0x39, 0x02, 0x5B, 0xD8, 0x67, 0x08, 0xFE, 0x98, 0xDD, 0x0C, 0x40,
  0xAC, 0x83, 0xA1, 0xEE, 0x23, 0x0D, 0xC0, 0xB4, 0x04, 0xC8, 0x2C, 0x7F, 0x54, 0x07, 0xC0, 0x74,
  0x02, 0xC8, 0x1E, 0xED, 0x50, 0x4B, 0x0D, 0x01, 0x40, 0x1E, 0x07, 0x58, 0x33, 0xEC, 0x81, 0x50,
  0x1E, 0x02, 0x77, 0x10, 0x1D, 0x0E, 0x77, 0x20, 0x1D, 0x0B, 0x77, 0x20, 0x1D, 0x08, 0x77, 0x20,
  0x1D, 0x07, 0x77, 0x20, 0x1D, 0x05, 0x77, 0x20, 0x1D, 0x04, 0x77, 0x20, 0x1D, 0x04, 0x77, 0x20,
  0x1D, 0x04, 0x77, 0x20, 0x1D, 0x04, 0x77, 0x20, 0x1D, 0x04, 0x77, 0x20, 0x1D, 0x04, 0x77, 0x20,
  0x1D, 0x04, 0x77, 0x20, 0x1D, 0x04, 0x77, 0x20, 0x1D, 0x04, 0x77, 0x20, 0x1D, 0x04, 0x77, 0x20,
  0x1D, 0x04, 0x77, 0x20, 0x2D, 0x04, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x20, 0xAD, 0x0B, 0x76, 0x81,
  0x25, 0xBF, 0x82, 0xB5, 0x21, 0x71, 0x06, 0xFF, 0x09, 0x70, 0x6F, 0xF0, 0x97, 0x06, 0xFF, 0x09,
  0x70,
  // "Ŗ" (U+0156)
  0x02, 0xFF, 0x98, 0x4E, 0xDC, 0x96, 0x27, 0x50, 0x2F, 0xFF, 0x0C, 0x06, 0x73, 0x82, 0x17, 0x9C,
  0xF0, 0xE8, 0x00, 0xDF, 0x90, 0xB0, 0x27, 0x50, 0x30, 0xED, 0x06, 0x58, 0x12, 0x7E, 0xD0, 0xD0,
  0x17, 0x50, 0x8D, 0x06, 0x71, 0x0B, 0xD0, 0xC7, 0x50, 0x5D, 0x06, 0x72, 0x0D, 0xD0, 0x57, 0x40,
  0x4D, 0x06, 0x72, 0x05, 0xD0, 0xC7, 0x40, 0x4D, 0x06, 0x73, 0x0E, 0xD0, 0x17, 0x30, 0x4D, 0x06,
  0x73, 0x0B, 0xD0, 0x57, 0x30, 0x4D, 0x06, 0x73, 0x08, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x07,
  0xD0, 0x77, 0x30, 0x4D, 0x06, 0x73, 0x06, 0xD0, 0x87, 0x30, 0x4D, 0x06, 0x73, 0x07, 0xD0, 0x87,
  0x30, 0x4D, 0x06, 0x73, 0x08, 0xD0, 0x67, 0x30, 0x4D, 0x06, 0x73, 0x0A, 0xD0, 0x47, 0x30, 0x4D,
  0x06, 0x73, 0x0D, 0xD7, 0x40, 0x4D, 0x06, 0x72, 0x03, 0xD0, 0xA7, 0x40, 0x4D, 0x06, 0x72, 0x0A,
  0xD0, 0x27, 0x40, 0x4D, 0x06, 0x71, 0x04, 0xD0, 0x87, 0x50, 0x4D, 0x06, 0x70, 0x5D, 0x0A, 0x76,
  0x04, 0xD0, 0x63, 0x82, 0x12, 0x6C, 0xD0, 0x97, 0x70, 0x4F, 0xFA, 0x0D, 0x05, 0x77, 0x10, 0x4F,
  0xF9, 0x06, 0x77, 0x30, 0x4F, 0xF9, 0x07, 0x77, 0x30, 0x4D, 0x83, 0x71, 0x11, 0x2D, 0x0E, 0x01,
  0x77, 0x20, 0x4D, 0x06, 0x40, 0x9D, 0x09, 0x77, 0x20, 0x4D, 0x06, 0x40, 0x1E, 0x02, 0x77, 0x10,
  0x4D, 0x06, 0x50, 0x9D, 0x0A, 0x77, 0x10, 0x4D, 0x06, 0x50, 0x1E, 0x03, 0x77, 0x04, 0xD0, 0x66,
  0x09, 0xD0, 0xC7, 0x70, 0x4D, 0x06, 0x60, 0x1E, 0x05, 0x76, 0x04, 0xD0, 0x67, 0x09, 0xD0, 0xD7,
  0x60, 0x4D, 0x06, 0x70, 0x1E, 0x06, 0x75, 0x04, 0xD0, 0x67, 0x10, 0x9D, 0x0E, 0x75, 0x04, 0xD0,
  0x67, 0x10, 0x1E, 0x07, 0x74, 0x04, 0xD0, 0x67, 0x20, 0x9D, 0x0E, 0x01, 0x73, 0x04, 0xD0, 0x67,
  0x20, 0x1E, 0x0A, 0x73, 0x06, 0xD0, 0x87, 0x30, 0x9E, 0x05, 0x72, 0x0C, 0xD0, 0xD7, 0x30, 0x10,
  0xED, 0x0E, 0x03, 0x48, 0x21, 0x25, 0xCF, 0x82, 0xC5, 0x21, 0x70, 0x6F, 0x82, 0x72, 0x02, 0xFF,
  0x97, 0x10, 0xAF, 0x90, 0x50, 0x2F, 0xF9, 0x72, 0x07, 0xF0, 0x50, 0x2F, 0xF9, 0x73, 0x83, 0x17,
  0xBD, 0xEA, 0x05, 0x80, 0x9E, 0x00, 0x0B, 0xC0, 0x37, 0x77, 0x70, 0xEB, 0x0D, 0x77, 0x77, 0x01,
  0xC0, 0x77, 0x77, 0x70, 0x3C, 0x01, 0x77, 0x77, 0x05, 0xB0, 0x97, 0x77, 0x71, 0x08, 0xB0, 0x27,
  0x77, 0x71, 0x0B, 0xA0, 0xA7, 0x77, 0x72, 0x0E, 0xA0, 0x37, 0x77, 0x71, 0x02, 0xA0, 0xA7, 0x77,
  0x72, 0x04, 0xA0, 0x27, 0x74,
  // "ŗ" (U+0157)
  0x77, 0x18, 0x33, 0x57, 0x64, 0x30, 0x5F, 0x90, 0x13, 0x02, 0x0C, 0xD8, 0x2D, 0x40, 0x5F, 0x90,
  0x32, 0x03, 0x0E, 0xF9, 0x02, 0x05, 0xF9, 0x05, 0x20, 0xDF, 0xA8, 0x39, 0x02, 0x5B, 0xD8, 0x67,
  0x08, 0xFE, 0x98, 0xDD, 0x0C, 0x40, 0xAC, 0x83, 0xA1, 0xEE, 0x23, 0x0D, 0xC0, 0xB4, 0x04, 0xC8,
  0x2C, 0x7F, 0x54, 0x07, 0xC0, 0x74, 0x02, 0xC8, 0x1E, 0xED, 0x50, 0x4B, 0x0D, 0x01, 0x40, 0x1E,
  0x07, 0x58, 0x33, 0xEC, 0x81, 0x50, 0x1E, 0x02, 0x77, 0x10, 0x1D, 0x0E, 0x77, 0x20, 0x1D, 0x0B,
  0x77, 0x20, 0x1D, 0x08, 0x77, 0x20, 0x1D, 0x07, 0x77, 0x20, 0x1D, 0x05, 0x77, 0x20, 0x1D, 0x04,
  0x77, 0x20, 0x1D, 0x04, 0x77, 0x20, 0x1D, 0x04, 0x77, 0x20, 0x1D, 0x04, 0x77, 0x20, 0x1D, 0x04,
  0x77, 0x20, 0x1D, 0x04, 0x77, 0x20, 0x1D, 0x04, 0x77, 0x20, 0x1D, 0x04, 0x77, 0x20, 0x1D, 0x04,
  0x77, 0x20, 0x1D, 0x04, 0x77, 0x20, 0x1D, 0x04, 0x77, 0x20, 0x2D, 0x04, 0x77, 0x20, 0x4D, 0x06,
  0x77, 0x20, 0xAD, 0x0B, 0x76, 0x81, 0x25, 0xBF, 0x82, 0xB5, 0x21, 0x71, 0x06, 0xFF, 0x09, 0x70,
  0x6F, 0xF0, 0x97, 0x06, 0xFF, 0x09, 0x80, 0x99, 0x50, 0x0B, 0xC0, 0x37, 0x73, 0x0E, 0xB0, 0xD7,
  0x73, 0x01, 0xC0, 0x77, 0x73, 0x03, 0xC0, 0x17, 0x73, 0x05, 0xB0, 0x97, 0x74, 0x08, 0xB0, 0x27,
  0x74, 0x0B, 0xA0, 0xA7, 0x75, 0x0E, 0xA0, 0x37, 0x74, 0x02, 0xA0, 0xA7, 0x75, 0x04, 0xA0, 0x27,
  0x72,
  // "Ř" (U+0158)
  0x78, 0x14, 0x77, 0x73, 0x81, 0x37, 0x77, 0x74, 0x07, 0xA0, 0xA7, 0x18, 0x24, 0xEF, 0xD7, 0x75,
  0x0C, 0xA0, 0xA6, 0x04, 0x0E, 0xA0, 0x47, 0x75, 0x02, 0xB0, 0xA4, 0x03, 0x0E, 0xA0, 0x87, 0x77,
  0x07, 0xB0, 0x82, 0x02, 0x0E, 0xA0, 0xD7, 0x77, 0x20, 0xDB, 0x81, 0x61, 0xDB, 0x04, 0x77, 0x72,
  0x03, 0xC0, 0xCB, 0x0A, 0x77, 0x74, 0x09, 0xF0, 0x17, 0x77, 0x40, 0x1E, 0x08, 0x77, 0x76, 0x09,
  0xD0, 0x18, 0x0A, 0xA3, 0x00, 0x2F, 0xF9, 0x84, 0xED, 0xC9, 0x62, 0x75, 0x02, 0xFF, 0xF0, 0xC0,
  0x67, 0x38, 0x21, 0x79, 0xCF, 0x0E, 0x80, 0x0D, 0xF9, 0x0B, 0x02, 0x75, 0x03, 0x0E, 0xD0, 0x65,
  0x81, 0x27, 0xED, 0x0D, 0x01, 0x75, 0x08, 0xD0, 0x67, 0x10, 0xBD, 0x0C, 0x75, 0x05, 0xD0, 0x67,
  0x20, 0xDD, 0x05, 0x74, 0x04, 0xD0, 0x67, 0x20, 0x5D, 0x0C, 0x74, 0x04, 0xD0, 0x67, 0x30, 0xED,
  0x01, 0x73, 0x04, 0xD0, 0x67, 0x30, 0xBD, 0x05, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x8D, 0x06, 0x73,
  0x04, 0xD0, 0x67, 0x30, 0x7D, 0x07, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x6D, 0x08, 0x73, 0x04, 0xD0,
  0x67, 0x30, 0x7D, 0x08, 0x73, 0x04, 0xD0, 0x67, 0x30, 0x8D, 0x06, 0x73, 0x04, 0xD0, 0x67, 0x30,
  0xAD, 0x04, 0x73, 0x04, 0xD0, 0x67, 0x30, 0xDD, 0x74, 0x04, 0xD0, 0x67, 0x20, 0x3D, 0x0A, 0x74,
  0x04, 0xD0, 0x67, 0x20, 0xAD, 0x02, 0x74, 0x04, 0xD0, 0x67, 0x10, 0x4D, 0x08, 0x75, 0x04, 0xD0,
  0x67, 0x05, 0xD0, 0xA7, 0x60, 0x4D, 0x06, 0x38, 0x21, 0x26, 0xCD, 0x09, 0x77, 0x04, 0xFF, 0xA0,
  0xD0, 0x57, 0x71, 0x04, 0xFF, 0x90, 0x67, 0x73, 0x04, 0xFF, 0x90, 0x77, 0x73, 0x04, 0xD8, 0x37,
  0x11, 0x12, 0xD0, 0xE0, 0x17, 0x72, 0x04, 0xD0, 0x64, 0x09, 0xD0, 0x97, 0x72, 0x04, 0xD0, 0x64,
  0x01, 0xE0, 0x27, 0x71, 0x04, 0xD0, 0x65, 0x09, 0xD0, 0xA7, 0x71, 0x04, 0xD0, 0x65, 0x01, 0xE0,
  0x37, 0x70, 0x4D, 0x06, 0x60, 0x9D, 0x0C, 0x77, 0x04, 0xD0, 0x66, 0x01, 0xE0, 0x57, 0x60, 0x4D,
  0x06, 0x70, 0x9D, 0x0D, 0x76, 0x04, 0xD0, 0x67, 0x01, 0xE0, 0x67, 0x50, 0x4D, 0x06, 0x71, 0x09,
  0xD0, 0xE7, 0x50, 0x4D, 0x06, 0x71, 0x01, 0xE0, 0x77, 0x40, 0x4D, 0x06, 0x72, 0x09, 0xD0, 0xE0,
  0x17, 0x30, 0x4D, 0x06, 0x72, 0x01, 0xE0, 0xA7, 0x30, 0x6D, 0x08, 0x73, 0x09, 0xE0, 0x57, 0x20,
  0xCD, 0x0D, 0x73, 0x01, 0x0E, 0xD0, 0xE0, 0x34, 0x82, 0x12, 0x5C, 0xF8, 0x2C, 0x52, 0x17, 0x06,
  0xF8, 0x27, 0x20, 0x2F, 0xF9, 0x71, 0x0A, 0xF9, 0x05, 0x02, 0xFF, 0x97, 0x20, 0x7F, 0x05, 0x02,
  0xFF, 0x97, 0x38, 0x31, 0x7B, 0xDE, 0xA0, 0x50,
  // "ř" (U+0159)
  0x38, 0x14, 0x77, 0x73, 0x81, 0x37, 0x77, 0x07, 0xA0, 0xA7, 0x18, 0x24, 0xEF, 0xD7, 0x10, 0xCA,
  0x0A, 0x60, 0x40, 0xEA, 0x04, 0x71, 0x02, 0xB0, 0xA4, 0x03, 0x0E, 0xA0, 0x87, 0x30, 0x7B, 0x08,
  0x20, 0x20, 0xEA, 0x0D, 0x75, 0x0D, 0xB8, 0x16, 0x1D, 0xB0, 0x47, 0x50, 0x3C, 0x0C, 0xB0, 0xA7,
  0x70, 0x9F, 0x01, 0x77, 0x01, 0xE0, 0x87, 0x72, 0x09, 0xD0, 0x18, 0x09, 0xD7, 0x08, 0x33, 0x57,
  0x64, 0x30, 0x5F, 0x90, 0x13, 0x02, 0x0C, 0xD8, 0x2D, 0x40, 0x5F, 0x90, 0x32, 0x03, 0x0E, 0xF9,
  0x02, 0x05, 0xF9, 0x05, 0x20, 0xDF, 0xA8, 0x39, 0x02, 0x5B, 0xD8, 0x67, 0x08, 0xFE, 0x98, 0xDD,
  0x0C, 0x40, 0xAC, 0x83, 0xA1, 0xEE, 0x23, 0x0D, 0xC0, 0xB4, 0x04, 0xC8, 0x2C, 0x7F, 0x54, 0x07,
  0xC0, 0x74, 0x02, 0xC8, 0x1E, 0xED, 0x50, 0x4B, 0x0D, 0x01, 0x40, 0x1E, 0x07, 0x58, 0x33, 0xEC,
  0x81, 0x50, 0x1E, 0x02, 0x77, 0x10, 0x1D, 0x0E, 0x77, 0x20, 0x1D, 0x0B, 0x77, 0x20, 0x1D, 0x08,
  0x77, 0x20, 0x1D, 0x07, 0x77, 0x20, 0x1D, 0x05, 0x77, 0x20, 0x1D, 0x04, 0x77, 0x20, 0x1D, 0x04,
  0x77, 0x20, 0x1D, 0x04, 0x77, 0x20, 0x1D, 0x04, 0x77, 0x20, 0x1D, 0x04, 0x77, 0x20, 0x1D, 0x04,
  0x77, 0x20, 0x1D, 0x04, 0x77, 0x20, 0x1D, 0x04, 0x77, 0x20, 0x1D, 0x04, 0x77, 0x20, 0x1D, 0x04,
  0x77, 0x20, 0x1D, 0x04, 0x77, 0x20, 0x2D, 0x04, 0x77, 0x20, 0x4D, 0x06, 0x77, 0x20, 0xAD, 0x0B,
  0x76, 0x81, 0x25, 0xBF, 0x82, 0xB5, 0x21, 0x71, 0x06, 0xFF, 0x09, 0x70, 0x6F, 0xF0, 0x97, 0x06,
  0xFF, 0x09, 0x70,
  // "Ś" (U+015A)
  0x77, 0x80, 0x27, 0x77, 0x30, 0x4D, 0x0C, 0x77, 0x30, 0xBC, 0x0E, 0x02, 0x77, 0x20, 0x4D, 0x04,
  0x77, 0x30, 0xCC, 0x06, 0x77, 0x30, 0x5C, 0x07, 0x77, 0x40, 0xEB, 0x07, 0x77, 0x40, 0x8B, 0x06,
  0x77, 0x40, 0x2B, 0x05, 0x77, 0x58, 0x28, 0xFE, 0x38, 0x09, 0xB0, 0x08, 0x52, 0x56, 0x76, 0x53,
  0x77, 0x81, 0x17, 0xDF, 0x81, 0xEA, 0x37, 0x30, 0x50, 0xEF, 0xD0, 0xA7, 0x10, 0x8D, 0x83, 0xC9,
  0x9B, 0xED, 0x0C, 0x60, 0x7C, 0x0B, 0x02, 0x40, 0x10, 0x9D, 0x09, 0x40, 0x3C, 0x0B, 0x71, 0x09,
  0xD0, 0x13, 0x0B, 0xC0, 0x17, 0x20, 0xEC, 0x06, 0x20, 0x2C, 0x0A, 0x73, 0x07, 0xC0, 0x72, 0x06,
  0xC0, 0x67, 0x30, 0x2C, 0x05, 0x20, 0x9C, 0x04, 0x74, 0xB0, 0xD3, 0x0A, 0xC0, 0x37, 0x48, 0x2D,
  0xE9, 0x13, 0x0A, 0xC0, 0x47, 0x74, 0x09, 0xC0, 0x67, 0x74, 0x08, 0xC0, 0xA7, 0x74, 0x05, 0xC0,
  0xE0, 0x17, 0x73, 0x01, 0xD0, 0xA7, 0x74, 0x0B, 0xD0, 0x87, 0x73, 0x04, 0xE0, 0xA0, 0x17, 0x72,
  0x0A, 0xE0, 0xE0, 0x57, 0x71, 0x01, 0x0C, 0xF0, 0xC0, 0x47, 0x70, 0x10, 0xDF, 0x90, 0xB0, 0x37,
  0x60, 0x10, 0xBF, 0xA0, 0x90, 0x17, 0x60, 0x7F, 0xA0, 0xE0, 0x47, 0x60, 0x20, 0xAF, 0xA0, 0x77,
  0x70, 0x30, 0xBF, 0x90, 0x97, 0x71, 0x04, 0x0D, 0xF0, 0x77, 0x72, 0x08, 0xF0, 0x37, 0x72, 0x05,
  0xE0, 0xA7, 0x73, 0x03, 0xE0, 0x17, 0x73, 0x07, 0xD0, 0x57, 0x74, 0x0E, 0xC0, 0x87, 0x74, 0x08,
  0xC0, 0xA2, 0x81, 0x9D, 0x77, 0x60, 0x6C, 0x81, 0xB0, 0xCA, 0x08, 0x76, 0x04, 0xC0, 0xA0, 0x4B,
  0x0B, 0x76, 0x04, 0xC0, 0x90, 0x8B, 0x0E, 0x76, 0x05, 0xC0, 0x70, 0x8C, 0x04, 0x75, 0x08, 0xC0,
  0x30, 0x7C, 0x0B, 0x75, 0x0D, 0xB8, 0x1E, 0x03, 0xD0, 0x47, 0x30, 0x5C, 0x07, 0x20, 0xDC, 0x0E,
  0x02, 0x71, 0x03, 0x0E, 0xB0, 0xD3, 0x05, 0xD0, 0xE0, 0x66, 0x07, 0x0E, 0xB0, 0xE0, 0x24, 0x08,
  0xE8, 0x3E, 0xB9, 0x9B, 0xD0, 0xE0, 0x36, 0x07, 0xFF, 0x0B, 0x01, 0x71, 0x81, 0x28, 0xDF, 0x98,
  0x1E, 0xA3, 0x76, 0x86, 0x14, 0x67, 0x76, 0x52, 0x72,
  // "ś" (U+015B)
  0x75, 0x80, 0x27, 0x76, 0x04, 0xD0, 0xC7, 0x60, 0xBC, 0x0E, 0x02, 0x75, 0x04, 0xD0, 0x47, 0x60,
  0xCC, 0x06, 0x76, 0x05, 0xC0, 0x77, 0x70, 0xEB, 0x07, 0x77, 0x08, 0xB0, 0x67, 0x70, 0x2B, 0x05,
  0x77, 0x18, 0x28, 0xFE, 0x38, 0x09, 0xB4, 0x08, 0x53, 0x56, 0x76, 0x41, 0x73, 0x81, 0x29, 0xEF,
  0x0C, 0x04, 0x70, 0x60, 0xEF, 0xC0, 0x85, 0x07, 0xC8, 0x3E, 0xB9, 0xAD, 0xD0, 0x53, 0x02, 0xC0,
  0xA0, 0x14, 0x05, 0xC0, 0xD3, 0x0A, 0xB0, 0xC7, 0x06, 0xC0, 0x22, 0x0E, 0xB0, 0x67, 0x10, 0xEB,
  0x81, 0x20, 0x2C, 0x03, 0x71, 0x0A, 0xA0, 0xE2, 0x03, 0xC0, 0x27, 0x10, 0x7A, 0x06, 0x20, 0x2C,
  0x04, 0x71, 0x81, 0x59, 0x33, 0x01, 0xC0, 0x97, 0x71, 0x0D, 0xC0, 0x47, 0x70, 0x8D, 0x06, 0x76,
  0x01, 0x0E, 0xD0, 0xC0, 0x37, 0x50, 0x4F, 0x0B, 0x03, 0x74, 0x04, 0x0E, 0xF0, 0xB0, 0x37, 0x30,
  0x20, 0xCF, 0x90, 0x97, 0x40, 0x60, 0xEF, 0x0D, 0x02, 0x74, 0x07, 0x0E, 0xE0, 0xE0, 0x27, 0x40,
  0x10, 0x8E, 0x0D, 0x76, 0x02, 0x0C, 0xD0, 0x67, 0x70, 0xBC, 0x0C, 0x77, 0x10, 0xEC, 0x28, 0x11,
  0x86, 0x73, 0x08, 0xC8, 0x31, 0x2E, 0xFA, 0x73, 0x05, 0xC0, 0x20, 0xAA, 0x0C, 0x73, 0x05, 0xC0,
  0x10, 0xDB, 0x01, 0x72, 0x07, 0xC1, 0x0D, 0xB0, 0x77, 0x20, 0xBB, 0x81, 0xB0, 0xBB, 0x0E, 0x01,
  0x70, 0x4C, 0x81, 0x50, 0x7C, 0x0D, 0x03, 0x50, 0x50, 0xEB, 0x0C, 0x30, 0xDD, 0x83, 0xC9, 0x9A,
  0xEC, 0x0E, 0x02, 0x30, 0x20, 0xDF, 0xD0, 0xC0, 0x26, 0x06, 0x0D, 0xF9, 0x0C, 0x05, 0x73, 0x86,
  0x14, 0x67, 0x76, 0x41, 0x70,
  // "Ŝ" (U+015C)
  0x72, 0x03, 0x80, 0x17, 0x77, 0x40, 0xCD, 0x04, 0x77, 0x20, 0x5E, 0x0C, 0x77, 0x20, 0xDF, 0x05,
  0x77, 0x08, 0xB0, 0xC0, 0x7B, 0x0D, 0x76, 0x02, 0xB8, 0x2E, 0x20, 0x9B, 0x08, 0x75, 0x0B, 0xA0,
  0xE0, 0x33, 0x0B, 0xB0, 0x27, 0x30, 0x6A, 0x0E, 0x04, 0x50, 0xBA, 0x0C, 0x72, 0x83, 0x2E, 0xFE,
  0x47, 0x0B, 0xA0, 0x87, 0x18, 0x28, 0xFE, 0x37, 0x20, 0xAA, 0x80, 0x9A, 0x10, 0x85, 0x25, 0x67,
  0x65, 0x37, 0x78, 0x11, 0x7D, 0xF8, 0x1E, 0xA3, 0x73, 0x05, 0x0E, 0xFD, 0x0A, 0x71, 0x08, 0xD8,
  0x3C, 0x99, 0xBE, 0xD0, 0xC6, 0x07, 0xC0, 0xB0, 0x24, 0x01, 0x09, 0xD0, 0x94, 0x03, 0xC0, 0xB7,
  0x10, 0x9D, 0x01, 0x30, 0xBC, 0x01, 0x72, 0x0E, 0xC0, 0x62, 0x02, 0xC0, 0xA7, 0x30, 0x7C, 0x07,
  0x20, 0x6C, 0x06, 0x73, 0x02, 0xC0, 0x52, 0x09, 0xC0, 0x47, 0x4B, 0x0D, 0x30, 0xAC, 0x03, 0x74,
  0x82, 0xDE, 0x91, 0x30, 0xAC, 0x04, 0x77, 0x40, 0x9C, 0x06, 0x77, 0x40, 0x8C, 0x0A, 0x77, 0x40,
  0x5C, 0x0E, 0x01, 0x77, 0x30, 0x1D, 0x0A, 0x77, 0x40, 0xBD, 0x08, 0x77, 0x30, 0x4E, 0x0A, 0x01,
  0x77, 0x20, 0xAE, 0x0E, 0x05, 0x77, 0x10, 0x10, 0xCF, 0x0C, 0x04, 0x77, 0x01, 0x0D, 0xF9, 0x0B,
  0x03, 0x76, 0x01, 0x0B, 0xFA, 0x09, 0x01, 0x76, 0x07, 0xFA, 0x0E, 0x04, 0x76, 0x02, 0x0A, 0xFA,
  0x07, 0x77, 0x03, 0x0B, 0xF9, 0x09, 0x77, 0x10, 0x40, 0xDF, 0x07, 0x77, 0x20, 0x8F, 0x03, 0x77,
  0x20, 0x5E, 0x0A, 0x77, 0x30, 0x3E, 0x01, 0x77, 0x30, 0x7D, 0x05, 0x77, 0x40, 0xEC, 0x08, 0x77,
  0x40, 0x8C, 0x0A, 0x28, 0x19, 0xD7, 0x76, 0x06, 0xC8, 0x1B, 0x0C, 0xA0, 0x87, 0x60, 0x4C, 0x0A,
  0x04, 0xB0, 0xB7, 0x60, 0x4C, 0x09, 0x08, 0xB0, 0xE7, 0x60, 0x5C, 0x07, 0x08, 0xC0, 0x47, 0x50,
  0x8C, 0x03, 0x07, 0xC0, 0xB7, 0x50, 0xDB, 0x81, 0xE0, 0x3D, 0x04, 0x73, 0x05, 0xC0, 0x72, 0x0D,
  0xC0, 0xE0, 0x27, 0x10, 0x30, 0xEB, 0x0D, 0x30, 0x5D, 0x0E, 0x06, 0x60, 0x70, 0xEB, 0x0E, 0x02,
  0x40, 0x8E, 0x83, 0xEB, 0x99, 0xBD, 0x0E, 0x03, 0x60, 0x7F, 0xF0, 0xB0, 0x17, 0x18, 0x12, 0x8D,
  0xF9, 0x81, 0xEA, 0x37, 0x68, 0x61, 0x46, 0x77, 0x65, 0x27, 0x20,
  // "ŝ" (U+015D)
  0x70, 0x38, 0x01, 0x77, 0x70, 0xCD, 0x04, 0x75, 0x05, 0xE0, 0xC7, 0x50, 0xDF, 0x05, 0x73, 0x08,
  0xB0, 0xC0, 0x7B, 0x0D, 0x72, 0x02, 0xB8, 0x2E, 0x20, 0x9B, 0x08, 0x71, 0x0B, 0xA0, 0xE0, 0x33,
  0x0B, 0xB0, 0x26, 0x06, 0xA0, 0xE0, 0x45, 0x0B, 0xA0, 0xC5, 0x83, 0x2E, 0xFE, 0x47, 0x0B, 0xA0,
  0x84, 0x82, 0x8F, 0xE3, 0x72, 0x0A, 0xA8, 0x09, 0xA5, 0x08, 0x53, 0x56, 0x76, 0x41, 0x73, 0x81,
  0x29, 0xEF, 0x0C, 0x04, 0x70, 0x60, 0xEF, 0xC0, 0x85, 0x07, 0xC8, 0x3E, 0xB9, 0xAD, 0xD0, 0x53,
  0x02, 0xC0, 0xA0, 0x14, 0x05, 0xC0, 0xD3, 0x0A, 0xB0, 0xC7, 0x06, 0xC0, 0x22, 0x0E, 0xB0, 0x67,
  0x10, 0xEB, 0x81, 0x20, 0x2C, 0x03, 0x71, 0x0A, 0xA0, 0xE2, 0x03, 0xC0, 0x27, 0x10, 0x7A, 0x06,
  0x20, 0x2C, 0x04, 0x71, 0x81, 0x59, 0x33, 0x01, 0xC0, 0x97, 0x71, 0x0D, 0xC0, 0x47, 0x70, 0x8D,
  0x06, 0x76, 0x01, 0x0E, 0xD0, 0xC0, 0x37, 0x50, 0x4F, 0x0B, 0x03, 0x74, 0x04, 0x0E, 0xF0, 0xB0,
  0x37, 0x30, 0x20, 0xCF, 0x90, 0x97, 0x40, 0x60, 0xEF, 0x0D, 0x02, 0x74, 0x07, 0x0E, 0xE0, 0xE0,
  0x27, 0x40, 0x10, 0x8E, 0x0D, 0x76, 0x02, 0x0C, 0xD0, 0x67, 0x70, 0xBC, 0x0C, 0x77, 0x10, 0xEC,
  0x28, 0x11, 0x86, 0x73, 0x08, 0xC8, 0x31, 0x2E, 0xFA, 0x73, 0x05, 0xC0, 0x20, 0xAA, 0x0C, 0x73,
  0x05, 0xC0, 0x10, 0xDB, 0x01, 0x72, 0x07, 0xC1, 0x0D, 0xB0, 0x77, 0x20, 0xBB, 0x81, 0xB0, 0xBB,
  0x0E, 0x01, 0x70, 0x4C, 0x81, 0x50, 0x7C, 0x0D, 0x03, 0x50, 0x50, 0xEB, 0x0C, 0x30, 0xDD, 0x83,
  0xC9, 0x9A, 0xEC, 0x0E, 0x02, 0x30, 0x20, 0xDF, 0xD0, 0xC0, 0x26, 0x06, 0x0D, 0xF9, 0x0C, 0x05,
  0x73, 0x86, 0x14, 0x67, 0x76, 0x41, 0x70,
  // "Ş" (U+015E)
  0x72, 0x85, 0x25, 0x67, 0x65, 0x37, 0x78, 0x11, 0x7D, 0xF8, 0x1E, 0xA3, 0x73, 0x05, 0x0E, 0xFD,
  0x0A, 0x71, 0x08, 0xD8, 0x3C, 0x99, 0xBE, 0xD0, 0xC6, 0x07, 0xC0, 0xB0, 0x24, 0x01, 0x09, 0xD0,
  0x94, 0x03, 0xC0, 0xB7, 0x10, 0x9D, 0x01, 0x30, 0xBC, 0x01, 0x72, 0x0E, 0xC0, 0x62, 0x02, 0xC0,
  0xA7, 0x30, 0x7C, 0x07, 0x20, 0x6C, 0x06, 0x73, 0x02, 0xC0, 0x52, 0x09, 0xC0, 0x47, 0x4B, 0x0D,
  0x30, 0xAC, 0x03, 0x74, 0x82, 0xDE, 0x91, 0x30, 0xAC, 0x04, 0x77, 0x40, 0x9C, 0x06, 0x77, 0x40,
  0x8C, 0x0A, 0x77, 0x40, 0x5C, 0x0E, 0x01, 0x77, 0x30, 0x1D, 0x0A, 0x77, 0x40, 0xBD, 0x08, 0x77,
  0x30, 0x4E, 0x0A, 0x01, 0x77, 0x20, 0xAE, 0x0E, 0x05, 0x77, 0x10, 0x10, 0xCF, 0x0C, 0x04, 0x77,
  0x01, 0x0D, 0xF9, 0x0B, 0x03, 0x76, 0x01, 0x0B, 0xFA, 0x09, 0x01, 0x76, 0x07, 0xFA, 0x0E, 0x04,
  0x76, 0x02, 0x0A, 0xFA, 0x07, 0x77, 0x03, 0x0B, 0xF9, 0x09, 0x77, 0x10, 0x40, 0xDF, 0x07, 0x77,
  0x20, 0x8F, 0x03, 0x77, 0x20, 0x5E, 0x0A, 0x77, 0x30, 0x3E, 0x01, 0x77, 0x30, 0x7D, 0x05, 0x77,
  0x40, 0xEC, 0x08, 0x77, 0x40, 0x8C, 0x0A, 0x28, 0x19, 0xD7, 0x76, 0x06, 0xC8, 0x1B, 0x0C, 0xA0,
  0x87, 0x60, 0x4C, 0x0A, 0x04, 0xB0, 0xB7, 0x60, 0x4C, 0x09, 0x08, 0xB0, 0xE7, 0x60, 0x5C, 0x07,
  0x08, 0xC0, 0x47, 0x50, 0x8C, 0x03, 0x07, 0xC0, 0xB7, 0x50, 0xDB, 0x81, 0xE0, 0x3D, 0x04, 0x73,
  0x05, 0xC0, 0x72, 0x0D, 0xC0, 0xE0, 0x27, 0x10, 0x30, 0xEB, 0x0D, 0x30, 0x5D, 0x0E, 0x06, 0x60,
  0x70, 0xEB, 0x0E, 0x02, 0x40, 0x8E, 0x83, 0xEB, 0x99, 0xBD, 0x0E, 0x03, 0x60, 0x7F, 0xF0, 0xB0,
  0x17, 0x18, 0x12, 0x8D, 0xF9, 0x81, 0xEA, 0x37, 0x68, 0x21, 0x46, 0xDA, 0x05, 0x02, 0x77, 0x58,
  0x1A, 0xFC, 0x77, 0x78, 0x3D, 0xFE, 0xA5, 0x77, 0x40, 0x1D, 0x0C, 0x01, 0x77, 0x30, 0x50, 0xAC,
  0x0C, 0x77, 0x50, 0x30, 0xEB, 0x05, 0x77, 0x50, 0x7B, 0x09, 0x77, 0x50, 0x4B, 0x0A, 0x77, 0x50,
  0x6B, 0x09, 0x77, 0x50, 0xAB, 0x07, 0x76, 0x03, 0x40, 0x7C, 0x02, 0x76, 0xA0, 0xE0, 0xDD, 0x09,
  0x77, 0xF9, 0x09, 0x77, 0x18, 0x68, 0xBE, 0xFE, 0xD9, 0x37, 0x20,
  // "ş" (U+015F)
  0x78, 0x53, 0x56, 0x76, 0x41, 0x73, 0x81, 0x29, 0xEF, 0x0C, 0x04, 0x70, 0x60, 0xEF, 0xC0, 0x85,
  0x07, 0xC8, 0x3E, 0xB9, 0xAD, 0xD0, 0x53, 0x02, 0xC0, 0xA0, 0x14, 0x05, 0xC0, 0xD3, 0x0A, 0xB0,
  0xC7, 0x06, 0xC0, 0x22, 0x0E, 0xB0, 0x67, 0x10, 0xEB, 0x81, 0x20, 0x2C, 0x03, 0x71, 0x0A, 0xA0,
  0xE2, 0x03, 0xC0, 0x27, 0x10, 0x7A, 0x06, 0x20, 0x2C, 0x04, 0x71, 0x81, 0x59, 0x33, 0x01, 0xC0,
  0x97, 0x71, 0x0D, 0xC0, 0x47, 0x70, 0x8D, 0x06, 0x76, 0x01, 0x0E, 0xD0, 0xC0, 0x37, 0x50, 0x4F,
  0x0B, 0x03, 0x74, 0x04, 0x0E, 0xF0, 0xB0, 0x37, 0x30, 0x20, 0xCF, 0x90, 0x97, 0x40, 0x60, 0xEF,
  0x0D, 0x02, 0x74, 0x07, 0x0E, 0xE0, 0xE0, 0x27, 0x40, 0x10, 0x8E, 0x0D, 0x76, 0x02, 0x0C, 0xD0,
  0x67, 0x70, 0xBC, 0x0C, 0x77, 0x10, 0xEC, 0x28, 0x11, 0x86, 0x73, 0x08, 0xC8, 0x31, 0x2E, 0xFA,
  0x73, 0x05, 0xC0, 0x20, 0xAA, 0x0C, 0x73, 0x05, 0xC0, 0x10, 0xDB, 0x01, 0x72, 0x07, 0xC1, 0x0D,
  0xB0, 0x77, 0x20, 0xBB, 0x81, 0xB0, 0xBB, 0x0E, 0x01, 0x70, 0x4C, 0x81, 0x50, 0x7C, 0x0D, 0x03,
  0x50, 0x50, 0xEB, 0x0C, 0x30, 0xDD, 0x83, 0xC9, 0x9A, 0xEC, 0x0E, 0x02, 0x30, 0x20, 0xDF, 0xD0,
  0xC0, 0x26, 0x06, 0x0D, 0xF9, 0x0C, 0x05, 0x73, 0x81, 0x14, 0xDA, 0x81, 0x64, 0x17, 0x78, 0x1A,
  0xFC, 0x77, 0x38, 0x3D, 0xFE, 0xA5, 0x77, 0x01, 0xD0, 0xC0, 0x17, 0x60, 0x50, 0xAC, 0x0C, 0x77,
  0x10, 0x30, 0xEB, 0x05, 0x77, 0x10, 0x7B, 0x09, 0x77, 0x10, 0x4B, 0x0A, 0x77, 0x10, 0x6B, 0x09,
  0x77, 0x10, 0xAB, 0x07, 0x72, 0x03, 0x40, 0x7C, 0x02, 0x72, 0xA0, 0xE0, 0xDD, 0x09, 0x73, 0xF9,
  0x09, 0x74, 0x86, 0x8B, 0xEF, 0xED, 0x93, 0x71,
  // "Š" (U+0160)
  0x48, 0x14, 0x77, 0x73, 0x81, 0x37, 0x77, 0x10, 0x7A, 0x0A, 0x71, 0x82, 0x4E, 0xFD, 0x72, 0x0C,
  0xA0, 0xA6, 0x04, 0x0E, 0xA0, 0x47, 0x20, 0x2B, 0x0A, 0x40, 0x30, 0xEA, 0x08, 0x74, 0x07, 0xB0,
  0x82, 0x02, 0x0E, 0xA0, 0xD7, 0x60, 0xDB, 0x81, 0x61, 0xDB, 0x04, 0x76, 0x03, 0xC0, 0xCB, 0x0A,
  0x77, 0x10, 0x9F, 0x01, 0x77, 0x10, 0x1E, 0x08, 0x77, 0x30, 0x9D, 0x01, 0x80, 0x9A, 0x50, 0x85,
  0x25, 0x67, 0x65, 0x37, 0x78, 0x11, 0x7D, 0xF8, 0x1E, 0xA3, 0x73, 0x05, 0x0E, 0xFD, 0x0A, 0x71,
  0x08, 0xD8, 0x3C, 0x99, 0xBE, 0xD0, 0xC6, 0x07, 0xC0, 0xB0, 0x24, 0x01, 0x09, 0xD0, 0x94, 0x03,
  0xC0, 0xB7, 0x10, 0x9D, 0x01, 0x30, 0xBC, 0x01, 0x72, 0x0E, 0xC0, 0x62, 0x02, 0xC0, 0xA7, 0x30,
  0x7C, 0x07, 0x20, 0x6C, 0x06, 0x73, 0x02, 0xC0, 0x52, 0x09, 0xC0, 0x47, 0x4B, 0x0D, 0x30, 0xAC,
  0x03, 0x74, 0x82, 0xDE, 0x91, 0x30, 0xAC, 0x04, 0x77, 0x40, 0x9C, 0x06, 0x77, 0x40, 0x8C, 0x0A,
  0x77, 0x40, 0x5C, 0x0E, 0x01, 0x77, 0x30, 0x1D, 0x0A, 0x77, 0x40, 0xBD, 0x08, 0x77, 0x30, 0x4E,
  0x0A, 0x01, 0x77, 0x20, 0xAE, 0x0E, 0x05, 0x77, 0x10, 0x10, 0xCF, 0x0C, 0x04, 0x77, 0x01, 0x0D,
  0xF9, 0x0B, 0x03, 0x76, 0x01, 0x0B, 0xFA, 0x09, 0x01, 0x76, 0x07, 0xFA, 0x0E, 0x04, 0x76, 0x02,
  0x0A, 0xFA, 0x07, 0x77, 0x03, 0x0B, 0xF9, 0x09, 0x77, 0x10, 0x40, 0xDF, 0x07, 0x77, 0x20, 0x8F,
  0x03, 0x77, 0x20, 0x5E, 0x0A, 0x77, 0x30, 0x3E, 0x01, 0x77, 0x30, 0x7D, 0x05, 0x77, 0x40, 0xEC,
  0x08, 0x77, 0x40, 0x8C, 0x0A, 0x28, 0x19, 0xD7, 0x76, 0x06, 0xC8, 0x1B, 0x0C, 0xA0, 0x87, 0x60,
  0x4C, 0x0A, 0x04, 0xB0, 0xB7, 0x60, 0x4C, 0x09, 0x08, 0xB0, 0xE7, 0x60, 0x5C, 0x07, 0x08, 0xC0,
  0x47, 0x50, 0x8C, 0x03, 0x07, 0xC0, 0xB7, 0x50, 0xDB, 0x81, 0xE0, 0x3D, 0x04, 0x73, 0x05, 0xC0,
  0x72, 0x0D, 0xC0, 0xE0, 0x27, 0x10, 0x30, 0xEB, 0x0D, 0x30, 0x5D, 0x0E, 0x06, 0x60, 0x70, 0xEB,
  0x0E, 0x02, 0x40, 0x8E, 0x83, 0xEB, 0x99, 0xBD, 0x0E, 0x03, 0x60, 0x7F, 0xF0, 0xB0, 0x17, 0x18,
  0x12, 0x8D, 0xF9, 0x81, 0xEA, 0x37, 0x68, 0x61, 0x46, 0x77, 0x65, 0x27, 0x20,
  // "š" (U+0161)
  0x28, 0x14, 0x77, 0x73, 0x81, 0x37, 0x74, 0x07, 0xA0, 0xA7, 0x18, 0x24, 0xEF, 0xD5, 0x0C, 0xA0,
  0xA6, 0x04, 0x0E, 0xA0, 0x45, 0x02, 0xB0, 0xA4, 0x03, 0x0E, 0xA0, 0x87, 0x07, 0xB0, 0x82, 0x02,
  0x0E, 0xA0, 0xD7, 0x20, 0xDB, 0x81, 0x61, 0xDB, 0x04, 0x72, 0x03, 0xC0, 0xCB, 0x0A, 0x74, 0x09,
  0xF0, 0x17, 0x40, 0x1E, 0x08, 0x76, 0x09, 0xD0, 0x18, 0x09, 0xB1, 0x08, 0x53, 0x56, 0x76, 0x41,
  0x73, 0x81, 0x29, 0xEF, 0x0C, 0x04, 0x70, 0x60, 0xEF, 0xC0, 0x85, 0x07, 0xC8, 0x3E, 0xB9, 0xAD,
  0xD0, 0x53, 0x02, 0xC0, 0xA0, 0x14, 0x05, 0xC0, 0xD3, 0x0A, 0xB0, 0xC7, 0x06, 0xC0, 0x22, 0x0E,
  0xB0, 0x67, 0x10, 0xEB, 0x81, 0x20, 0x2C, 0x03, 0x71, 0x0A, 0xA0, 0xE2, 0x03, 0xC0, 0x27, 0x10,
  0x7A, 0x06, 0x20, 0x2C, 0x04, 0x71, 0x81, 0x59, 0x33, 0x01, 0xC0, 0x97, 0x71, 0x0D, 0xC0, 0x47,
  0x70, 0x8D, 0x06, 0x76, 0x01, 0x0E, 0xD0, 0xC0, 0x37, 0x50, 0x4F, 0x0B, 0x03, 0x74, 0x04, 0x0E,
  0xF0, 0xB0, 0x37, 0x30, 0x20, 0xCF, 0x90, 0x97, 0x40, 0x60, 0xEF, 0x0D, 0x02, 0x74, 0x07, 0x0E,
  0xE0, 0xE0, 0x27, 0x40, 0x10, 0x8E, 0x0D, 0x76, 0x02, 0x0C, 0xD0, 0x67, 0x70, 0xBC, 0x0C, 0x77,
  0x10, 0xEC, 0x28, 0x11, 0x86, 0x73, 0x08, 0xC8, 0x31, 0x2E, 0xFA, 0x73, 0x05, 0xC0, 0x20, 0xAA,
  0x0C, 0x73, 0x05, 0xC0, 0x10, 0xDB, 0x01, 0x72, 0x07, 0xC1, 0x0D, 0xB0, 0x77, 0x20, 0xBB, 0x81,
  0xB0, 0xBB, 0x0E, 0x01, 0x70, 0x4C, 0x81, 0x50, 0x7C, 0x0D, 0x03, 0x50, 0x50, 0xEB, 0x0C, 0x30,
  0xDD, 0x83, 0xC9, 0x9A, 0xEC, 0x0E, 0x02, 0x30, 0x20, 0xDF, 0xD0, 0xC0, 0x26, 0x06, 0x0D, 0xF9,
  0x0C, 0x05, 0x73, 0x86, 0x14, 0x67, 0x76, 0x41, 0x70,
  // "Ţ" (U+0162)
  0x0C, 0xFF, 0xFF, 0x08, 0x0D, 0xFF, 0xFF, 0x09, 0x0D, 0xFF, 0xFF, 0x09, 0x0D, 0xB8, 0x1E, 0x62,
  0x80, 0x11, 0xD0, 0xA8, 0x01, 0x10, 0x30, 0x8C, 0x09, 0x0E, 0xB0, 0x27, 0xD0, 0xA7, 0x06, 0xB0,
  0xA0, 0xEA, 0x0A, 0x71, 0xD0, 0xA7, 0x10, 0xDA, 0x0A, 0x0E, 0xA0, 0x47, 0x1D, 0x0A, 0x71, 0x08,
  0xA0, 0xAB, 0x01, 0x71, 0xD0, 0xA7, 0x10, 0x5A, 0x0B, 0xA0, 0xE7, 0x2D, 0x0A, 0x71, 0x02, 0xA0,
  0xBA, 0x0C, 0x72, 0xD0, 0xA7, 0x2A, 0x82, 0xB7, 0x75, 0x72, 0xD0, 0xA7, 0x28, 0x16, 0x75, 0x75,
  0xD0, 0xA7, 0x77, 0x3D, 0x0A, 0x77, 0x73, 0xD0, 0xA7, 0x77, 0x3D, 0x0A, 0x77, 0x73, 0xD0, 0xA7,
  0x77, 0x3D, 0x0A, 0x77, 0x73, 0xD0, 0xA7, 0x77, 0x3D, 0x0A, 0x77, 0x73, 0xD0, 0xA7, 0x77, 0x3D,
  0x0A, 0x77, 0x73, 0xD0, 0xA7, 0x77, 0x3D, 0x0A, 0x77, 0x73, 0xD0, 0xA7, 0x77, 0x3D, 0x0A, 0x77,
  0x73, 0xD0, 0xA7, 0x77, 0x3D, 0x0A, 0x77, 0x73, 0xD0, 0xA7, 0x77, 0x3D, 0x0A, 0x77, 0x73, 0xD0,
  0xA7, 0x77, 0x3D, 0x0A, 0x77, 0x73, 0xD0, 0xA7, 0x77, 0x3D, 0x0A, 0x77, 0x73, 0xD0, 0xA7, 0x77,
  0x3D, 0x0A, 0x77, 0x73, 0xD0, 0xA7, 0x77, 0x3D, 0x0B, 0x77, 0x72, 0x02, 0xD0, 0xD7, 0x77, 0x20,
  0x9E, 0x04, 0x77, 0x48, 0x21, 0x25, 0xAF, 0x83, 0xE9, 0x32, 0x17, 0x60, 0x6F, 0xFA, 0x01, 0x75,
  0x06, 0xFF, 0xA0, 0x17, 0x50, 0x6F, 0xFA, 0x01, 0x77, 0x58, 0x1D, 0xF9, 0x77, 0x75, 0x01, 0xA0,
  0x90, 0x17, 0x77, 0x40, 0x5C, 0x0C, 0x03, 0x77, 0x72, 0x07, 0xE0, 0x47, 0x77, 0x30, 0x70, 0xEB,
  0x0D, 0x77, 0x74, 0x05, 0xC0, 0x37, 0x77, 0x40, 0xEB, 0x06, 0x77, 0x74, 0x0C, 0xB0, 0x67, 0x77,
  0x40, 0xEB, 0x05, 0x77, 0x73, 0x05, 0xC0, 0x27, 0x74, 0x84, 0x35, 0x31, 0x27, 0xC0, 0xC7, 0x75,
  0x06, 0xFA, 0x03, 0x77, 0x50, 0x6F, 0x0E, 0x05, 0x77, 0x68, 0x72, 0x9C, 0xEF, 0xEC, 0x81, 0x75,
  // "ţ" (U+0163)
  0x60, 0x9A, 0x03, 0x76, 0x0C, 0xA0, 0x37, 0x6B, 0x03, 0x75, 0x04, 0xB0, 0x37, 0x50, 0x9B, 0x03,
  0x74, 0x01, 0xC0, 0x37, 0x40, 0xBC, 0x03, 0x73, 0x0A, 0xD0, 0x37, 0x81, 0x26, 0xDF, 0xD0, 0xE1,
  0xFF, 0x90, 0xE1, 0xFF, 0x98, 0x4E, 0x01, 0x11, 0x2D, 0x04, 0x80, 0x21, 0x40, 0x1D, 0x03, 0x73,
  0x01, 0xD0, 0x37, 0x30, 0x1D, 0x03, 0x73, 0x01, 0xD0, 0x37, 0x30, 0x1D, 0x03, 0x73, 0x01, 0xD0,
  0x37, 0x30, 0x1D, 0x03, 0x73, 0x01, 0xD0, 0x37, 0x30, 0x1D, 0x03, 0x73, 0x01, 0xD0, 0x37, 0x30,
  0x1D, 0x03, 0x73, 0x01, 0xD0, 0x37, 0x30, 0x1D, 0x03, 0x73, 0x01, 0xD0, 0x37, 0x30, 0x1D, 0x03,
  0x73, 0x01, 0xD0, 0x37, 0x30, 0x1D, 0x03, 0x73, 0x01, 0xD0, 0x37, 0x30, 0x1D, 0x03, 0x73, 0x01,
  0xD0, 0x37, 0x4D, 0x03, 0x74, 0xD0, 0x57, 0x40, 0xCC, 0x08, 0x74, 0x0A, 0xC0, 0xD7, 0x40, 0x5D,
  0x08, 0x74, 0x0D, 0xD8, 0x4D, 0x99, 0xAD, 0x65, 0x04, 0x0E, 0xFA, 0x06, 0x60, 0x30, 0xBF, 0x0E,
  0x04, 0x71, 0xB8, 0x27, 0x65, 0x27, 0x20, 0x1A, 0x09, 0x01, 0x75, 0x05, 0xC0, 0xC0, 0x37, 0x30,
  0x7E, 0x04, 0x74, 0x07, 0x0E, 0xB0, 0xD7, 0x50, 0x5C, 0x03, 0x75, 0x0E, 0xB0, 0x67, 0x50, 0xCB,
  0x06, 0x75, 0x0E, 0xB0, 0x57, 0x40, 0x5C, 0x02, 0x58, 0x43, 0x53, 0x12, 0x7C, 0x0C, 0x60, 0x6F,
  0xA0, 0x36, 0x06, 0xF0, 0xE0, 0x57, 0x87, 0x29, 0xCE, 0xFE, 0xC8, 0x14,
  // "Ť" (U+0164)
  0x78, 0x14, 0x77, 0x73, 0x81, 0x37, 0x77, 0x70, 0x7A, 0x0A, 0x71, 0x82, 0x4E, 0xFD, 0x77, 0x10,
  0xCA, 0x0A, 0x60, 0x40, 0xEA, 0x04, 0x77, 0x10, 0x2B, 0x0A, 0x40, 0x30, 0xEA, 0x08, 0x77, 0x30,
  0x7B, 0x08, 0x20, 0x20, 0xEA, 0x0D, 0x77, 0x50, 0xDB, 0x81, 0x61, 0xDB, 0x04, 0x77, 0x50, 0x3C,
  0x0C, 0xB0, 0xA7, 0x77, 0x09, 0xF0, 0x17, 0x77, 0x01, 0xE0, 0x87, 0x77, 0x20, 0x9D, 0x01, 0x80,
  0x9F, 0x70, 0x0C, 0xFF, 0xFF, 0x08, 0x0D, 0xFF, 0xFF, 0x09, 0x0D, 0xFF, 0xFF, 0x09, 0x0D, 0xB8,
  0x1E, 0x62, 0x80, 0x11, 0xD0, 0xA8, 0x01, 0x10, 0x30, 0x8C, 0x09, 0x0E, 0xB0, 0x27, 0xD0, 0xA7,
  0x06, 0xB0, 0xA0, 0xEA, 0x0A, 0x71, 0xD0, 0xA7, 0x10, 0xDA, 0x0A, 0x0E, 0xA0, 0x47, 0x1D, 0x0A,
  0x71, 0x08, 0xA0, 0xAB, 0x01, 0x71, 0xD0, 0xA7, 0x10, 0x5A, 0x0B, 0xA0, 0xE7, 0x2D, 0x0A, 0x71,
  0x02, 0xA0, 0xBA, 0x0C, 0x72, 0xD0, 0xA7, 0x2A, 0x82, 0xB7, 0x75, 0x72, 0xD0, 0xA7, 0x28, 0x16,
  0x75, 0x75, 0xD0, 0xA7, 0x77, 0x3D, 0x0A, 0x77, 0x73, 0xD0, 0xA7, 0x77, 0x3D, 0x0A, 0x77, 0x73,
  0xD0, 0xA7, 0x77, 0x3D, 0x0A, 0x77, 0x73, 0xD0, 0xA7, 0x77, 0x3D, 0x0A, 0x77, 0x73, 0xD0, 0xA7,
  0x77, 0x3D, 0x0A, 0x77, 0x73, 0xD0, 0xA7, 0x77, 0x3D, 0x0A, 0x77, 0x73, 0xD0, 0xA7, 0x77, 0x3D,
  0x0A, 0x77, 0x73, 0xD0, 0xA7, 0x77, 0x3D, 0x0A, 0x77, 0x73, 0xD0, 0xA7, 0x77, 0x3D, 0x0A, 0x77,
  0x73, 0xD0, 0xA7, 0x77, 0x3D, 0x0A, 0x77, 0x73, 0xD0, 0xA7, 0x77, 0x3D, 0x0A, 0x77, 0x73, 0xD0,
  0xA7, 0x77, 0x3D, 0x0A, 0x77, 0x73, 0xD0, 0xA7, 0x77, 0x3D, 0x0B, 0x77, 0x72, 0x02, 0xD0, 0xD7,
  0x77, 0x20, 0x9E, 0x04, 0x77, 0x48, 0x21, 0x25, 0xAF, 0x83, 0xE9, 0x32, 0x17, 0x60, 0x6F, 0xFA,
  0x01, 0x75, 0x06, 0xFF, 0xA0, 0x17, 0x50, 0x6F, 0xFA, 0x01, 0x60,
  // "ť" (U+0165)
  0x77, 0x0B, 0xC7, 0x70, 0xDB, 0x0B, 0x77, 0xC0, 0x57, 0x60, 0x3B, 0x0E, 0x77, 0x05, 0xB0, 0x77,
  0x70, 0x8A, 0x0E, 0x71, 0x82, 0x6A, 0xA2, 0x30, 0xBA, 0x08, 0x71, 0x0B, 0xA0, 0x33, 0x82, 0xEF,
  0xE1, 0x71, 0x0E, 0xA0, 0x32, 0x02, 0xA0, 0x87, 0x10, 0x3B, 0x03, 0x28, 0x14, 0xFE, 0x72, 0x08,
  0xB0, 0x37, 0x60, 0x10, 0xEB, 0x03, 0x76, 0x0A, 0xC0, 0x37, 0x50, 0x9D, 0x03, 0x72, 0x81, 0x16,
  0xDF, 0xD0, 0xE3, 0xFF, 0x90, 0xE3, 0xFF, 0x90, 0xE3, 0x0F, 0x10, 0x2D, 0x04, 0x80, 0x21, 0x60,
  0x1D, 0x03, 0x75, 0x01, 0xD0, 0x37, 0x50, 0x1D, 0x03, 0x75, 0x01, 0xD0, 0x37, 0x50, 0x1D, 0x03,
  0x75, 0x01, 0xD0, 0x37, 0x50, 0x1D, 0x03, 0x75, 0x01, 0xD0, 0x37, 0x50, 0x1D, 0x03, 0x75, 0x01,
  0xD0, 0x37, 0x50, 0x1D, 0x03, 0x75, 0x01, 0xD0, 0x37, 0x50, 0x1D, 0x03, 0x75, 0x01, 0xD0, 0x37,
  0x50, 0x1D, 0x03, 0x75, 0x01, 0xD0, 0x37, 0x50, 0x1D, 0x03, 0x75, 0x01, 0xD0, 0x37, 0x50, 0x1D,
  0x03, 0x75, 0x01, 0xD0, 0x37, 0x6D, 0x03, 0x76, 0xD0, 0x57, 0x60, 0xCC, 0x08, 0x76, 0x0A, 0xC0,
  0xD7, 0x60, 0x5D, 0x08, 0x76, 0x0D, 0xD8, 0x4D, 0x99, 0xAD, 0x67, 0x04, 0x0E, 0xFA, 0x06, 0x71,
  0x03, 0x0B, 0xF0, 0xE0, 0x47, 0x38, 0x52, 0x57, 0x76, 0x52, 0x40,
  // "Ŧ" (U+0166)
  0x0C, 0xFF, 0xFF, 0x08, 0x0D, 0xFF, 0xFF, 0x09, 0x0D, 0xFF, 0xFF, 0x09, 0x0D, 0xB8, 0x1E, 0x62,
  0x80, 0x11, 0xD0, 0xA8, 0x01, 0x10, 0x30, 0x8C, 0x09, 0x0E, 0xB0, 0x27, 0xD0, 0xA7, 0x06, 0xB0,
  0xA0, 0xEA, 0x0A, 0x71, 0xD0, 0xA7, 0x10, 0xDA, 0x0A, 0x0E, 0xA0, 0x47, 0x1D, 0x0A, 0x71, 0x08,
  0xA0, 0xAB, 0x01, 0x71, 0xD0, 0xA7, 0x10, 0x5A, 0x0B, 0xA0, 0xE7, 0x2D, 0x0A, 0x71, 0x02, 0xA0,
  0xBA, 0x0C, 0x72, 0xD0, 0xA7, 0x2A, 0x82, 0xB7, 0x75, 0x72, 0xD0, 0xA7, 0x28, 0x16, 0x75, 0x75,
  0xD0, 0xA7, 0x77, 0x3D, 0x0A, 0x77, 0x73, 0xD0, 0xA7, 0x77, 0x3D, 0x0A, 0x77, 0x73, 0xD0, 0xA7,
  0x77, 0x3D, 0x0A, 0x77, 0x73, 0xD0, 0xA7, 0x77, 0x3D, 0x0A, 0x77, 0x73, 0xD0, 0xA7, 0x72, 0x0C,
  0xFF, 0xE0, 0x67, 0x10, 0xCF, 0xFE, 0x06, 0x71, 0x0C, 0xFF, 0xE0, 0x67, 0x28, 0x03, 0x1D, 0x0A,
  0x80, 0x31, 0x77, 0x3D, 0x0A, 0x77, 0x73, 0xD0, 0xA7, 0x77, 0x3D, 0x0A, 0x77, 0x73, 0xD0, 0xA7,
  0x77, 0x3D, 0x0A, 0x77, 0x73, 0xD0, 0xA7, 0x77, 0x3D, 0x0A, 0x77, 0x73, 0xD0, 0xA7, 0x77, 0x3D,
  0x0A, 0x77, 0x73, 0xD0, 0xA7, 0x77, 0x3D, 0x0A, 0x77, 0x73, 0xD0, 0xA7, 0x77, 0x3D, 0x0A, 0x77,
  0x72, 0x02, 0xD0, 0xD7, 0x77, 0x20, 0x7E, 0x03, 0x77, 0x48, 0x21, 0x14, 0x9F, 0x83, 0xE7, 0x31,
  0x17, 0x60, 0x4F, 0xF9, 0x0E, 0x76, 0x04, 0xFF, 0x90, 0xE7, 0x60, 0x4F, 0xF9, 0x0E, 0x70,
  // "ŧ" (U+0167)
  0x60, 0x9A, 0x03, 0x76, 0x0C, 0xA0, 0x37, 0x6B, 0x03, 0x75, 0x04, 0xB0, 0x37, 0x50, 0x9B, 0x03,
  0x74, 0x01, 0xC0, 0x37, 0x40, 0xBC, 0x03, 0x73, 0x0A, 0xD0, 0x37, 0x81, 0x26, 0xDF, 0xD0, 0xE1,
  0xFF, 0x90, 0xE1, 0xFF, 0x98, 0x4E, 0x01, 0x11, 0x2D, 0x04, 0x80, 0x21, 0x40, 0x1D, 0x03, 0x73,
  0x01, 0xD0, 0x37, 0x30, 0x1D, 0x03, 0x73, 0x01, 0xD0, 0x37, 0x30, 0x1D, 0x03, 0x73, 0x01, 0xD0,
  0x37, 0x30, 0x1D, 0x03, 0x73, 0x01, 0xD0, 0x37, 0x09, 0xFF, 0x20, 0x9F, 0xF2, 0x09, 0xFF, 0x38,
  0x11, 0x12, 0xD0, 0x48, 0x01, 0x15, 0x01, 0xD0, 0x37, 0x30, 0x1D, 0x03, 0x73, 0x01, 0xD0, 0x37,
  0x30, 0x1D, 0x03, 0x73, 0x01, 0xD0, 0x37, 0x30, 0x1D, 0x03, 0x73, 0x01, 0xD0, 0x37, 0x30, 0x1D,
  0x03, 0x74, 0xD0, 0x37, 0x4D, 0x04, 0x74, 0x0D, 0xC0, 0x77, 0x40, 0xAC, 0x0C, 0x74, 0x05, 0xD0,
  0x87, 0x40, 0xDD, 0x84, 0xD9, 0x9A, 0xD6, 0x50, 0x4F, 0xB0, 0x66, 0x03, 0x0C, 0xF0, 0xE0, 0x47,
  0x18, 0x52, 0x57, 0x76, 0x52, 0x20,
  // "Ũ" (U+0168)
  0x76, 0x84, 0x4B, 0xEE, 0xB5, 0x78, 0x12, 0x55, 0x77, 0x60, 0x5E, 0x0A, 0x01, 0x58, 0x19, 0xFE,
  0x77, 0x50, 0x2F, 0x90, 0xD0, 0x34, 0x81, 0xEF, 0xC7, 0x75, 0x0A, 0xFB, 0x82, 0x71, 0x19, 0xA0,
  0x87, 0x75, 0xA8, 0x3D, 0x30, 0x4D, 0xFB, 0x02, 0x77, 0x40, 0x4A, 0x05, 0x40, 0x9F, 0x90, 0xA7,
  0x75, 0x07, 0xA0, 0x15, 0x05, 0x0E, 0xD0, 0xD0, 0x17, 0x75, 0x81, 0x36, 0x57, 0x85, 0x19, 0xDF,
  0xD8, 0x18, 0x0A, 0xB2, 0x00, 0x3F, 0xF9, 0x02, 0x60, 0xBF, 0xD0, 0x20, 0x3F, 0xF9, 0x02, 0x60,
  0xBF, 0xD0, 0x20, 0x3F, 0xF9, 0x02, 0x60, 0xBF, 0xD8, 0x42, 0x01, 0x36, 0xDF, 0x82, 0xD6, 0x31,
  0x71, 0x81, 0x24, 0x9D, 0x82, 0xD6, 0x31, 0x60, 0xDD, 0x0D, 0x77, 0x10, 0x7B, 0x0D, 0x73, 0x08,
  0xD0, 0x87, 0x71, 0x01, 0xB0, 0x87, 0x30, 0x6D, 0x06, 0x77, 0x2B, 0x05, 0x73, 0x05, 0xD0, 0x57,
  0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72,
  0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E,
  0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0,
  0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47,
  0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30,
  0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D,
  0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05,
  0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77,
  0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20,
  0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA,
  0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04,
  0x73, 0x04, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x3D, 0x06, 0x77, 0x2B, 0x02, 0x73, 0x02,
  0xD0, 0x87, 0x71, 0x03, 0xB0, 0x17, 0x40, 0xEC, 0x0B, 0x77, 0x10, 0x6A, 0x0D, 0x75, 0x0B, 0xC0,
  0xE0, 0x17, 0x70, 0xCA, 0x09, 0x75, 0x06, 0xD0, 0x77, 0x60, 0x3B, 0x04, 0x76, 0x0E, 0xC0, 0xE0,
  0x27, 0x50, 0xDA, 0x0C, 0x77, 0x07, 0xD0, 0xD0, 0x27, 0x30, 0xBB, 0x04, 0x77, 0x10, 0xBD, 0x81,
  0xE8, 0x16, 0x05, 0x0D, 0xB0, 0x87, 0x73, 0x0A, 0xF8, 0x4C, 0xA9, 0xAB, 0xEC, 0x09, 0x77, 0x50,
  0x60, 0xEF, 0xE0, 0xE0, 0x67, 0x77, 0x10, 0x60, 0xCF, 0xA0, 0xC0, 0x77, 0x77, 0x68, 0x63, 0x56,
  0x76, 0x54, 0x17, 0x70,
  // "ũ" (U+0169)
  0x71, 0x84, 0x4B, 0xEE, 0xB5, 0x78, 0x12, 0x55, 0x77, 0x05, 0xE0, 0xA0, 0x15, 0x81, 0x9F, 0xE7,
  0x60, 0x2F, 0x90, 0xD0, 0x34, 0x81, 0xEF, 0xC7, 0x60, 0xAF, 0xB8, 0x27, 0x11, 0x9A, 0x08, 0x76,
  0xA8, 0x3D, 0x30, 0x4D, 0xFB, 0x02, 0x75, 0x04, 0xA0, 0x54, 0x09, 0xF9, 0x0A, 0x76, 0x07, 0xA0,
  0x15, 0x05, 0x0E, 0xD0, 0xD0, 0x17, 0x68, 0x13, 0x65, 0x78, 0x51, 0x9D, 0xFD, 0x81, 0x80, 0xAC,
  0x00, 0x0D, 0xF9, 0x0A, 0x60, 0x2F, 0xA0, 0x44, 0x0D, 0xF9, 0x0A, 0x60, 0x2F, 0xA0, 0x44, 0x0D,
  0xF9, 0x0A, 0x60, 0x2F, 0xA0, 0x44, 0x82, 0x13, 0x7E, 0xD0, 0xA7, 0x81, 0x24, 0xAE, 0x04, 0x70,
  0x3D, 0x0A, 0x73, 0x09, 0xD0, 0x47, 0x10, 0xCC, 0x0A, 0x73, 0x03, 0xD0, 0x47, 0x10, 0xAC, 0x0A,
  0x73, 0x01, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47,
  0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74,
  0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC,
  0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47,
  0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x73,
  0x01, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x73, 0x01, 0xD0, 0x47, 0x10, 0x9C, 0x0B, 0x73, 0x03, 0xD0,
  0x47, 0x10, 0x9C, 0x0C, 0x73, 0x05, 0xD0, 0x47, 0x10, 0x8C, 0x0E, 0x73, 0x08, 0xD0, 0x47, 0x10,
  0x6D, 0x01, 0x72, 0x0D, 0xD0, 0x47, 0x10, 0x3D, 0x05, 0x71, 0x04, 0xE0, 0x57, 0x2D, 0x0C, 0x71,
  0x81, 0xDF, 0xEC, 0x07, 0x72, 0x0A, 0xD0, 0x95, 0x83, 0x2C, 0xFB, 0x9C, 0x0C, 0x72, 0x04, 0xE8,
  0x3E, 0xA8, 0x8B, 0xB0, 0x20, 0x7D, 0x81, 0xC5, 0x27, 0x0A, 0xFD, 0x81, 0x70, 0x4F, 0x90, 0x97,
  0x0B, 0xFB, 0x08, 0x20, 0x2F, 0x90, 0x97, 0x10, 0x60, 0xEE, 0x0C, 0x04, 0x4F, 0x90, 0x97, 0x38,
  0x43, 0x57, 0x75, 0x27, 0x71,
  // "Ū" (U+016A)
  0x76, 0x80, 0x92, 0x17, 0x77, 0x10, 0x9F, 0xF0, 0x37, 0x77, 0x09, 0xFF, 0x03, 0x77, 0x70, 0x9F,
  0xF0, 0x38, 0x0A, 0xB1, 0x00, 0x3F, 0xF9, 0x02, 0x60, 0xBF, 0xD0, 0x20, 0x3F, 0xF9, 0x02, 0x60,
  0xBF, 0xD0, 0x20, 0x3F, 0xF9, 0x02, 0x60, 0xBF, 0xD8, 0x42, 0x01, 0x36, 0xDF, 0x82, 0xD6, 0x31,
  0x71, 0x81, 0x24, 0x9D, 0x82, 0xD6, 0x31, 0x60, 0xDD, 0x0D, 0x77, 0x10, 0x7B, 0x0D, 0x73, 0x08,
  0xD0, 0x87, 0x71, 0x01, 0xB0, 0x87, 0x30, 0x6D, 0x06, 0x77, 0x2B, 0x05, 0x73, 0x05, 0xD0, 0x57,
  0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72,
  0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E,
  0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0,
  0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47,
  0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30,
  0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D,
  0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05,
  0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77,
  0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20,
  0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA,
  0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04,
  0x73, 0x04, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x3D, 0x06, 0x77, 0x2B, 0x02, 0x73, 0x02,
  0xD0, 0x87, 0x71, 0x03, 0xB0, 0x17, 0x40, 0xEC, 0x0B, 0x77, 0x10, 0x6A, 0x0D, 0x75, 0x0B, 0xC0,
  0xE0, 0x17, 0x70, 0xCA, 0x09, 0x75, 0x06, 0xD0, 0x77, 0x60, 0x3B, 0x04, 0x76, 0x0E, 0xC0, 0xE0,
  0x27, 0x50, 0xDA, 0x0C, 0x77, 0x07, 0xD0, 0xD0, 0x27, 0x30, 0xBB, 0x04, 0x77, 0x10, 0xBD, 0x81,
  0xE8, 0x16, 0x05, 0x0D, 0xB0, 0x87, 0x73, 0x0A, 0xF8, 0x4C, 0xA9, 0xAB, 0xEC, 0x09, 0x77, 0x50,
  0x60, 0xEF, 0xE0, 0xE0, 0x67, 0x77, 0x10, 0x60, 0xCF, 0xA0, 0xC0, 0x77, 0x77, 0x68, 0x63, 0x56,
  0x76, 0x54, 0x17, 0x70,
  // "ū" (U+016B)
  0x71, 0x80, 0x92, 0x17, 0x72, 0x09, 0xFF, 0x03, 0x77, 0x10, 0x9F, 0xF0, 0x37, 0x71, 0x09, 0xFF,
  0x03, 0x80, 0xAB, 0x70, 0x0D, 0xF9, 0x0A, 0x60, 0x2F, 0xA0, 0x44, 0x0D, 0xF9, 0x0A, 0x60, 0x2F,
  0xA0, 0x44, 0x0D, 0xF9, 0x0A, 0x60, 0x2F, 0xA0, 0x44, 0x82, 0x13, 0x7E, 0xD0, 0xA7, 0x81, 0x24,
  0xAE, 0x04, 0x70, 0x3D, 0x0A, 0x73, 0x09, 0xD0, 0x47, 0x10, 0xCC, 0x0A, 0x73, 0x03, 0xD0, 0x47,
  0x10, 0xAC, 0x0A, 0x73, 0x01, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A,
  0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10,
  0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0,
  0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A,
  0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10,
  0xAC, 0x0A, 0x73, 0x01, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x73, 0x01, 0xD0, 0x47, 0x10, 0x9C, 0x0B,
  0x73, 0x03, 0xD0, 0x47, 0x10, 0x9C, 0x0C, 0x73, 0x05, 0xD0, 0x47, 0x10, 0x8C, 0x0E, 0x73, 0x08,
  0xD0, 0x47, 0x10, 0x6D, 0x01, 0x72, 0x0D, 0xD0, 0x47, 0x10, 0x3D, 0x05, 0x71, 0x04, 0xE0, 0x57,
  0x2D, 0x0C, 0x71, 0x81, 0xDF, 0xEC, 0x07, 0x72, 0x0A, 0xD0, 0x95, 0x83, 0x2C, 0xFB, 0x9C, 0x0C,
  0x72, 0x04, 0xE8, 0x3E, 0xA8, 0x8B, 0xB0, 0x20, 0x7D, 0x81, 0xC5, 0x27, 0x0A, 0xFD, 0x81, 0x70,
  0x4F, 0x90, 0x97, 0x0B, 0xFB, 0x08, 0x20, 0x2F, 0x90, 0x97, 0x10, 0x60, 0xEE, 0x0C, 0x04, 0x4F,
  0x90, 0x97, 0x38, 0x43, 0x57, 0x75, 0x27, 0x71,
  // "Ŭ" (U+016C)
  0x74, 0x08, 0xA0, 0x17, 0x10, 0x8A, 0x77, 0x71, 0x07, 0xA0, 0x67, 0x18, 0x1D, 0xFE, 0x77, 0x71,
  0x03, 0xA0, 0xE0, 0x26, 0x08, 0xA0, 0xB7, 0x77, 0x20, 0xEA, 0x85, 0xE7, 0x20, 0x14, 0xBB, 0x06,
  0x77, 0x72, 0x07, 0xFC, 0x0E, 0x77, 0x74, 0x0C, 0xFB, 0x05, 0x77, 0x74, 0x01, 0x0C, 0xF9, 0x06,
  0x77, 0x77, 0x86, 0x5A, 0xDF, 0xEC, 0x82, 0x80, 0xAB, 0x60, 0x03, 0xFF, 0x90, 0x26, 0x0B, 0xFD,
  0x02, 0x03, 0xFF, 0x90, 0x26, 0x0B, 0xFD, 0x02, 0x03, 0xFF, 0x90, 0x26, 0x0B, 0xFD, 0x84, 0x20,
  0x13, 0x6D, 0xF8, 0x2D, 0x63, 0x17, 0x18, 0x12, 0x49, 0xD8, 0x2D, 0x63, 0x16, 0x0D, 0xD0, 0xD7,
  0x71, 0x07, 0xB0, 0xD7, 0x30, 0x8D, 0x08, 0x77, 0x10, 0x1B, 0x08, 0x73, 0x06, 0xD0, 0x67, 0x72,
  0xB0, 0x57, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0,
  0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47,
  0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30,
  0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D,
  0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05,
  0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77,
  0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20,
  0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA,
  0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04,
  0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73,
  0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05,
  0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x4D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x03, 0xD0,
  0x67, 0x72, 0xB0, 0x27, 0x30, 0x2D, 0x08, 0x77, 0x10, 0x3B, 0x01, 0x74, 0x0E, 0xC0, 0xB7, 0x71,
  0x06, 0xA0, 0xD7, 0x50, 0xBC, 0x0E, 0x01, 0x77, 0x0C, 0xA0, 0x97, 0x50, 0x6D, 0x07, 0x76, 0x03,
  0xB0, 0x47, 0x60, 0xEC, 0x0E, 0x02, 0x75, 0x0D, 0xA0, 0xC7, 0x70, 0x7D, 0x0D, 0x02, 0x73, 0x0B,
  0xB0, 0x47, 0x71, 0x0B, 0xD8, 0x1E, 0x81, 0x60, 0x50, 0xDB, 0x08, 0x77, 0x30, 0xAF, 0x84, 0xCA,
  0x9A, 0xBE, 0xC0, 0x97, 0x75, 0x06, 0x0E, 0xFE, 0x0E, 0x06, 0x77, 0x71, 0x06, 0x0C, 0xFA, 0x0C,
  0x07, 0x77, 0x76, 0x86, 0x35, 0x67, 0x65, 0x41, 0x77,
  // "ŭ" (U+016D)
  0x70, 0x8A, 0x01, 0x71, 0x08, 0xA7, 0x72, 0x07, 0xA0, 0x67, 0x18, 0x1D, 0xFE, 0x77, 0x20, 0x3A,
  0x0E, 0x02, 0x60, 0x8A, 0x0B, 0x77, 0x30, 0xEA, 0x85, 0xE7, 0x20, 0x14, 0xBB, 0x06, 0x77, 0x30,
  0x7F, 0xC0, 0xE7, 0x75, 0x0C, 0xFB, 0x05, 0x77, 0x50, 0x10, 0xCF, 0x90, 0x67, 0x77, 0x18, 0x65,
  0xAD, 0xFE, 0xC8, 0x28, 0x0A, 0xC3, 0x00, 0xDF, 0x90, 0xA6, 0x02, 0xFA, 0x04, 0x40, 0xDF, 0x90,
  0xA6, 0x02, 0xFA, 0x04, 0x40, 0xDF, 0x90, 0xA6, 0x02, 0xFA, 0x04, 0x48, 0x21, 0x37, 0xED, 0x0A,
  0x78, 0x12, 0x4A, 0xE0, 0x47, 0x03, 0xD0, 0xA7, 0x30, 0x9D, 0x04, 0x71, 0x0C, 0xC0, 0xA7, 0x30,
  0x3D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x30, 0x1D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x4D, 0x04, 0x71,
  0x0A, 0xC0, 0xA7, 0x4D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x4D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x4D,
  0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x4D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x4D, 0x04, 0x71, 0x0A, 0xC0,
  0xA7, 0x4D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x4D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x4D, 0x04, 0x71,
  0x0A, 0xC0, 0xA7, 0x4D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x4D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x4D,
  0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x30, 0x1D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x30, 0x1D, 0x04, 0x71,
  0x09, 0xC0, 0xB7, 0x30, 0x3D, 0x04, 0x71, 0x09, 0xC0, 0xC7, 0x30, 0x5D, 0x04, 0x71, 0x08, 0xC0,
  0xE7, 0x30, 0x8D, 0x04, 0x71, 0x06, 0xD0, 0x17, 0x20, 0xDD, 0x04, 0x71, 0x03, 0xD0, 0x57, 0x10,
  0x4E, 0x05, 0x72, 0xD0, 0xC7, 0x18, 0x1D, 0xFE, 0xC0, 0x77, 0x20, 0xAD, 0x09, 0x58, 0x32, 0xCF,
  0xB9, 0xC0, 0xC7, 0x20, 0x4E, 0x83, 0xEA, 0x88, 0xBB, 0x02, 0x07, 0xD8, 0x1C, 0x52, 0x70, 0xAF,
  0xD8, 0x17, 0x04, 0xF9, 0x09, 0x70, 0xBF, 0xB0, 0x82, 0x02, 0xF9, 0x09, 0x71, 0x06, 0x0E, 0xE0,
  0xC0, 0x44, 0xF9, 0x09, 0x73, 0x84, 0x35, 0x77, 0x52, 0x77, 0x10,
  // "Ů" (U+016E)
  0x77, 0x20, 0x50, 0xBB, 0x0B, 0x05, 0x77, 0x77, 0x10, 0xAF, 0x0A, 0x77, 0x76, 0x08, 0xFA, 0x08,
  0x77, 0x74, 0x01, 0xB8, 0x38, 0x20, 0x28, 0xB0, 0x17, 0x77, 0x30, 0x6A, 0x07, 0x50, 0x7A, 0x06,
  0x77, 0x73, 0x09, 0xA0, 0x25, 0x01, 0xA0, 0x87, 0x77, 0x30, 0x9A, 0x01, 0x6A, 0x09, 0x77, 0x73,
  0x09, 0xA0, 0x25, 0x01, 0xA0, 0x87, 0x77, 0x30, 0x6A, 0x08, 0x50, 0x8A, 0x06, 0x77, 0x73, 0x01,
  0xB8, 0x39, 0x31, 0x39, 0xB0, 0x17, 0x77, 0x40, 0x8F, 0xA0, 0x77, 0x77, 0x60, 0x9F, 0x09, 0x77,
  0x77, 0x18, 0x54, 0xAE, 0xFE, 0xA4, 0x80, 0x9F, 0x10, 0x03, 0xFF, 0x90, 0x26, 0x0B, 0xFD, 0x02,
  0x03, 0xFF, 0x90, 0x26, 0x0B, 0xFD, 0x02, 0x03, 0xFF, 0x90, 0x26, 0x0B, 0xFD, 0x84, 0x20, 0x13,
  0x6D, 0xF8, 0x2D, 0x63, 0x17, 0x18, 0x12, 0x49, 0xD8, 0x2D, 0x63, 0x16, 0x0D, 0xD0, 0xD7, 0x71,
  0x07, 0xB0, 0xD7, 0x30, 0x8D, 0x08, 0x77, 0x10, 0x1B, 0x08, 0x73, 0x06, 0xD0, 0x67, 0x72, 0xB0,
  0x57, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47,
  0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30,
  0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D,
  0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05,
  0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77,
  0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20,
  0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA,
  0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04,
  0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73,
  0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05,
  0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0,
  0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x4D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x03, 0xD0, 0x67,
  0x72, 0xB0, 0x27, 0x30, 0x2D, 0x08, 0x77, 0x10, 0x3B, 0x01, 0x74, 0x0E, 0xC0, 0xB7, 0x71, 0x06,
  0xA0, 0xD7, 0x50, 0xBC, 0x0E, 0x01, 0x77, 0x0C, 0xA0, 0x97, 0x50, 0x6D, 0x07, 0x76, 0x03, 0xB0,
  0x47, 0x60, 0xEC, 0x0E, 0x02, 0x75, 0x0D, 0xA0, 0xC7, 0x70, 0x7D, 0x0D, 0x02, 0x73, 0x0B, 0xB0,
  0x47, 0x71, 0x0B, 0xD8, 0x1E, 0x81, 0x60, 0x50, 0xDB, 0x08, 0x77, 0x30, 0xAF, 0x84, 0xCA, 0x9A,
  0xBE, 0xC0, 0x97, 0x75, 0x06, 0x0E, 0xFE, 0x0E, 0x06, 0x77, 0x71, 0x06, 0x0C, 0xFA, 0x0C, 0x07,
  0x77, 0x76, 0x86, 0x35, 0x67, 0x65, 0x41, 0x77,
  // "ů" (U+016F)
  0x74, 0x05, 0x0B, 0xB0, 0xB0, 0x57, 0x77, 0x20, 0xAF, 0x0A, 0x77, 0x70, 0x8F, 0xA0, 0x87, 0x75,
  0x01, 0xB8, 0x38, 0x20, 0x28, 0xB0, 0x17, 0x74, 0x06, 0xA0, 0x75, 0x07, 0xA0, 0x67, 0x74, 0x09,
  0xA0, 0x25, 0x01, 0xA0, 0x87, 0x74, 0x09, 0xA0, 0x16, 0xA0, 0x97, 0x74, 0x09, 0xA0, 0x25, 0x01,
  0xA0, 0x87, 0x74, 0x06, 0xA0, 0x85, 0x08, 0xA0, 0x67, 0x74, 0x01, 0xB8, 0x39, 0x31, 0x39, 0xB0,
  0x17, 0x75, 0x08, 0xFA, 0x07, 0x77, 0x70, 0x9F, 0x09, 0x77, 0x72, 0x85, 0x4A, 0xEF, 0xEA, 0x48,
  0x0A, 0x85, 0x00, 0xDF, 0x90, 0xA6, 0x02, 0xFA, 0x04, 0x40, 0xDF, 0x90, 0xA6, 0x02, 0xFA, 0x04,
  0x40, 0xDF, 0x90, 0xA6, 0x02, 0xFA, 0x04, 0x48, 0x21, 0x37, 0xED, 0x0A, 0x78, 0x12, 0x4A, 0xE0,
  0x47, 0x03, 0xD0, 0xA7, 0x30, 0x9D, 0x04, 0x71, 0x0C, 0xC0, 0xA7, 0x30, 0x3D, 0x04, 0x71, 0x0A,
  0xC0, 0xA7, 0x30, 0x1D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x4D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x4D,
  0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x4D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x4D, 0x04, 0x71, 0x0A, 0xC0,
  0xA7, 0x4D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x4D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x4D, 0x04, 0x71,
  0x0A, 0xC0, 0xA7, 0x4D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x4D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x4D,
  0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x4D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x4D, 0x04, 0x71, 0x0A, 0xC0,
  0xA7, 0x30, 0x1D, 0x04, 0x71, 0x0A, 0xC0, 0xA7, 0x30, 0x1D, 0x04, 0x71, 0x09, 0xC0, 0xB7, 0x30,
  0x3D, 0x04, 0x71, 0x09, 0xC0, 0xC7, 0x30, 0x5D, 0x04, 0x71, 0x08, 0xC0, 0xE7, 0x30, 0x8D, 0x04,
  0x71, 0x06, 0xD0, 0x17, 0x20, 0xDD, 0x04, 0x71, 0x03, 0xD0, 0x57, 0x10, 0x4E, 0x05, 0x72, 0xD0,
  0xC7, 0x18, 0x1D, 0xFE, 0xC0, 0x77, 0x20, 0xAD, 0x09, 0x58, 0x32, 0xCF, 0xB9, 0xC0, 0xC7, 0x20,
  0x4E, 0x83, 0xEA, 0x88, 0xBB, 0x02, 0x07, 0xD8, 0x1C, 0x52, 0x70, 0xAF, 0xD8, 0x17, 0x04, 0xF9,
  0x09, 0x70, 0xBF, 0xB0, 0x82, 0x02, 0xF9, 0x09, 0x71, 0x06, 0x0E, 0xE0, 0xC0, 0x44, 0xF9, 0x09,
  0x73, 0x84, 0x35, 0x77, 0x52, 0x77, 0x10,
  // "Ű" (U+0170)
  0x77, 0x10, 0x8C, 0x0D, 0x30, 0x3D, 0x03, 0x77, 0x70, 0xEC, 0x06, 0x30, 0x9C, 0x0B, 0x77, 0x70,
  0x5C, 0x0B, 0x30, 0x10, 0xEB, 0x0E, 0x01, 0x77, 0x70, 0xCB, 0x0E, 0x01, 0x30, 0x7C, 0x05, 0x77,
  0x70, 0x4C, 0x04, 0x40, 0xEB, 0x09, 0x77, 0x71, 0x0C, 0xB0, 0x74, 0x07, 0xB0, 0xC7, 0x77, 0x10,
  0x4B, 0x0B, 0x50, 0xEA, 0x0E, 0x01, 0x77, 0x71, 0x0B, 0xA0, 0xD0, 0x14, 0x07, 0xB0, 0x37, 0x77,
  0x10, 0x4A, 0x0E, 0x02, 0x50, 0xEA, 0x06, 0x77, 0x72, 0x82, 0x9F, 0xE3, 0x50, 0x4A, 0x07, 0x80,
  0xAB, 0x50, 0x03, 0xFF, 0x90, 0x26, 0x0B, 0xFD, 0x02, 0x03, 0xFF, 0x90, 0x26, 0x0B, 0xFD, 0x02,
  0x03, 0xFF, 0x90, 0x26, 0x0B, 0xFD, 0x84, 0x20, 0x13, 0x6D, 0xF8, 0x2D, 0x63, 0x17, 0x18, 0x12,
  0x49, 0xD8, 0x2D, 0x63, 0x16, 0x0D, 0xD0, 0xD7, 0x71, 0x07, 0xB0, 0xD7, 0x30, 0x8D, 0x08, 0x77,
  0x10, 0x1B, 0x08, 0x73, 0x06, 0xD0, 0x67, 0x72, 0xB0, 0x57, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA,
  0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04,
  0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73,
  0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05,
  0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0,
  0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57,
  0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72,
  0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E,
  0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0,
  0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47,
  0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30,
  0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x4D,
  0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x03, 0xD0, 0x67, 0x72, 0xB0, 0x27, 0x30, 0x2D, 0x08, 0x77,
  0x10, 0x3B, 0x01, 0x74, 0x0E, 0xC0, 0xB7, 0x71, 0x06, 0xA0, 0xD7, 0x50, 0xBC, 0x0E, 0x01, 0x77,
  0x0C, 0xA0, 0x97, 0x50, 0x6D, 0x07, 0x76, 0x03, 0xB0, 0x47, 0x60, 0xEC, 0x0E, 0x02, 0x75, 0x0D,
  0xA0, 0xC7, 0x70, 0x7D, 0x0D, 0x02, 0x73, 0x0B, 0xB0, 0x47, 0x71, 0x0B, 0xD8, 0x1E, 0x81, 0x60,
  0x50, 0xDB, 0x08, 0x77, 0x30, 0xAF, 0x84, 0xCA, 0x9A, 0xBE, 0xC0, 0x97, 0x75, 0x06, 0x0E, 0xFE,
  0x0E, 0x06, 0x77, 0x71, 0x06, 0x0C, 0xFA, 0x0C, 0x07, 0x77, 0x76, 0x86, 0x35, 0x67, 0x65, 0x41,
  0x77,
  // "ű" (U+0171)
  0x74, 0x08, 0xC0, 0xD3, 0x03, 0xD0, 0x37, 0x71, 0x0E, 0xC0, 0x63, 0x09, 0xC0, 0xB7, 0x71, 0x05,
  0xC0, 0xB3, 0x01, 0x0E, 0xB0, 0xE0, 0x17, 0x71, 0x0C, 0xB0, 0xE0, 0x13, 0x07, 0xC0, 0x57, 0x71,
  0x04, 0xC0, 0x44, 0x0E, 0xB0, 0x97, 0x72, 0x0C, 0xB0, 0x74, 0x07, 0xB0, 0xC7, 0x72, 0x04, 0xB0,
  0xB5, 0x0E, 0xA0, 0xE0, 0x17, 0x72, 0x0B, 0xA0, 0xD0, 0x14, 0x07, 0xB0, 0x37, 0x72, 0x04, 0xA0,
  0xE0, 0x25, 0x0E, 0xA0, 0x67, 0x73, 0x82, 0x9F, 0xE3, 0x50, 0x4A, 0x07, 0x80, 0xAC, 0x20, 0x0D,
  0xF9, 0x0A, 0x60, 0x2F, 0xA0, 0x44, 0x0D, 0xF9, 0x0A, 0x60, 0x2F, 0xA0, 0x44, 0x0D, 0xF9, 0x0A,
  0x60, 0x2F, 0xA0, 0x44, 0x82, 0x13, 0x7E, 0xD0, 0xA7, 0x81, 0x24, 0xAE, 0x04, 0x70, 0x3D, 0x0A,
  0x73, 0x09, 0xD0, 0x47, 0x10, 0xCC, 0x0A, 0x73, 0x03, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x73, 0x01,
  0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC,
  0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47,
  0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74,
  0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC,
  0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x73, 0x01, 0xD0,
  0x47, 0x10, 0xAC, 0x0A, 0x73, 0x01, 0xD0, 0x47, 0x10, 0x9C, 0x0B, 0x73, 0x03, 0xD0, 0x47, 0x10,
  0x9C, 0x0C, 0x73, 0x05, 0xD0, 0x47, 0x10, 0x8C, 0x0E, 0x73, 0x08, 0xD0, 0x47, 0x10, 0x6D, 0x01,
  0x72, 0x0D, 0xD0, 0x47, 0x10, 0x3D, 0x05, 0x71, 0x04, 0xE0, 0x57, 0x2D, 0x0C, 0x71, 0x81, 0xDF,
  0xEC, 0x07, 0x72, 0x0A, 0xD0, 0x95, 0x83, 0x2C, 0xFB, 0x9C, 0x0C, 0x72, 0x04, 0xE8, 0x3E, 0xA8,
  0x8B, 0xB0, 0x20, 0x7D, 0x81, 0xC5, 0x27, 0x0A, 0xFD, 0x81, 0x70, 0x4F, 0x90, 0x97, 0x0B, 0xFB,
  0x08, 0x20, 0x2F, 0x90, 0x97, 0x10, 0x60, 0xEE, 0x0C, 0x04, 0x4F, 0x90, 0x97, 0x38, 0x43, 0x57,
  0x75, 0x27, 0x71,
  // "Ų" (U+0172)
  0x03, 0xFF, 0x90, 0x26, 0x0B, 0xFD, 0x02, 0x03, 0xFF, 0x90, 0x26, 0x0B, 0xFD, 0x02, 0x03, 0xFF,
  0x90, 0x26, 0x0B, 0xFD, 0x84, 0x20, 0x13, 0x6D, 0xF8, 0x2D, 0x63, 0x17, 0x18, 0x12, 0x49, 0xD8,
  0x2D, 0x63, 0x16, 0x0D, 0xD0, 0xD7, 0x71, 0x07, 0xB0, 0xD7, 0x30, 0x8D, 0x08, 0x77, 0x10, 0x1B,
  0x08, 0x73, 0x06, 0xD0, 0x67, 0x72, 0xB0, 0x57, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73,
  0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05,
  0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0,
  0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57,
  0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72,
  0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E,
  0xA0, 0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0,
  0x47, 0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47,
  0x30, 0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30,
  0x5D, 0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D,
  0x05, 0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x5D, 0x05,
  0x77, 0x20, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x57, 0x72, 0x0E, 0xA0, 0x47, 0x30, 0x4D, 0x05, 0x77,
  0x20, 0xEA, 0x04, 0x73, 0x03, 0xD0, 0x67, 0x72, 0xB0, 0x27, 0x30, 0x2D, 0x08, 0x77, 0x10, 0x3B,
  0x01, 0x74, 0x0E, 0xC0, 0xB7, 0x71, 0x06, 0xA0, 0xD7, 0x50, 0xBC, 0x0E, 0x01, 0x77, 0x0C, 0xA0,
  0x97, 0x50, 0x6D, 0x07, 0x76, 0x03, 0xB0, 0x47, 0x60, 0xEC, 0x0E, 0x02, 0x75, 0x0D, 0xA0, 0xC7,
  0x70, 0x7D, 0x0D, 0x02, 0x73, 0x0B, 0xB0, 0x47, 0x71, 0x0B, 0xD8, 0x1E, 0x81, 0x60, 0x50, 0xDB,
  0x08, 0x77, 0x30, 0xAF, 0x84, 0xCA, 0x9A, 0xBE, 0xC0, 0x97, 0x75, 0x06, 0x0E, 0xFE, 0x0E, 0x06,
  0x77, 0x71, 0x06, 0x0C, 0xFA, 0x0D, 0x07, 0x77, 0x76, 0x81, 0x35, 0x7C, 0x02, 0x77, 0x77, 0x20,
  0x10, 0xCA, 0x0A, 0x77, 0x77, 0x40, 0xCA, 0x0C, 0x77, 0x77, 0x40, 0x7B, 0x05, 0x77, 0x77, 0x40,
  0xEB, 0x77, 0x77, 0x40, 0x4B, 0x0D, 0x77, 0x77, 0x40, 0x6B, 0x0C, 0x77, 0x77, 0x40, 0x7B, 0x0E,
  0x77, 0x77, 0x40, 0x6C, 0x05, 0x77, 0x77, 0x30, 0x4C, 0x85, 0xE7, 0x20, 0x13, 0x37, 0x77, 0x50,
  0xEF, 0xA0, 0x97, 0x77, 0x50, 0x6F, 0xA0, 0x97, 0x77, 0x60, 0x7F, 0x90, 0x87, 0x77, 0x78, 0x62,
  0x8C, 0xEF, 0xEB, 0x67, 0x50,
  // "ų" (U+0173)
  0x0D, 0xF9, 0x0A, 0x60, 0x2F, 0xA0, 0x44, 0x0D, 0xF9, 0x0A, 0x60, 0x2F, 0xA0, 0x44, 0x0D, 0xF9,
  0x0A, 0x60, 0x2F, 0xA0, 0x44, 0x82, 0x13, 0x7E, 0xD0, 0xA7, 0x81, 0x24, 0xAE, 0x04, 0x70, 0x3D,
  0x0A, 0x73, 0x09, 0xD0, 0x47, 0x10, 0xCC, 0x0A, 0x73, 0x03, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x73,
  0x01, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10,
  0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0,
  0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A,
  0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10,
  0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x74, 0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x73, 0x01,
  0xD0, 0x47, 0x10, 0xAC, 0x0A, 0x73, 0x01, 0xD0, 0x47, 0x10, 0x9C, 0x0B, 0x73, 0x03, 0xD0, 0x47,
  0x10, 0x9C, 0x0C, 0x73, 0x05, 0xD0, 0x47, 0x10, 0x8C, 0x0E, 0x73, 0x08, 0xD0, 0x47, 0x10, 0x6D,
  0x01, 0x72, 0x0D, 0xD0, 0x47, 0x10, 0x3D, 0x05, 0x71, 0x04, 0xE0, 0x57, 0x2D, 0x0C, 0x71, 0x81,
  0xDF, 0xEC, 0x07, 0x72, 0x0A, 0xD0, 0x95, 0x83, 0x2C, 0xFB, 0x9C, 0x0C, 0x72, 0x04, 0xE8, 0x3E,
  0xA8, 0x8B, 0xB0, 0x20, 0x7D, 0x81, 0xC5, 0x27, 0x0A, 0xFD, 0x81, 0x70, 0x4F, 0x90, 0x97, 0x0B,
  0xFB, 0x08, 0x20, 0x2F, 0x90, 0x97, 0x10, 0x60, 0xEE, 0x0C, 0x04, 0x4F, 0x90, 0x97, 0x38, 0x43,
  0x57, 0x75, 0x24, 0x84, 0x18, 0xEF, 0xA2, 0x77, 0x73, 0x03, 0x0D, 0xA0, 0x77, 0x77, 0x40, 0x20,
  0xEA, 0x08, 0x77, 0x75, 0x0D, 0xA0, 0xC7, 0x77, 0x50, 0x6B, 0x06, 0x77, 0x75, 0x0C, 0xB0, 0x27,
  0x77, 0x5C, 0x77, 0x75, 0x01, 0xC7, 0x77, 0x50, 0x1C, 0x02, 0x77, 0x75, 0x0E, 0xB0, 0x87, 0x77,
  0x50, 0xAC, 0x84, 0x93, 0x13, 0x66, 0x77, 0x60, 0x3F, 0xA0, 0x97, 0x77, 0x05, 0x0E, 0xF0, 0x97,
  0x77, 0x18, 0x71, 0x7C, 0xEF, 0xEC, 0x93, 0x30,
  // "Ŵ" (U+0174)
  0x77, 0x74, 0x03, 0x80, 0x17, 0x80, 0xD4, 0x00, 0xCD, 0x04, 0x80, 0xD2, 0x00, 0x5E, 0x0C, 0x80,
  0xD2, 0x00, 0xDF, 0x05, 0x80, 0xD0, 0x00, 0x8B, 0x0C, 0x07, 0xB0, 0xD8, 0x0C, 0x70, 0x02, 0xB8,
  0x2E, 0x20, 0x9B, 0x08, 0x80, 0xC6, 0x00, 0xBA, 0x0E, 0x03, 0x30, 0xBB, 0x02, 0x80, 0xC4, 0x00,
  0x6A, 0x0E, 0x04, 0x50, 0xBA, 0x0C, 0x80, 0xC3, 0x08, 0x32, 0xEF, 0xE4, 0x70, 0xBA, 0x08, 0x80,
  0xC2, 0x08, 0x28, 0xFE, 0x37, 0x20, 0xAA, 0x80, 0xBC, 0x60, 0x09, 0xFF, 0x73, 0x02, 0xC0, 0x67,
  0x20, 0x3F, 0xD0, 0x70, 0x9F, 0xF7, 0x30, 0x5C, 0x09, 0x72, 0x03, 0xFD, 0x07, 0x09, 0xFF, 0x73,
  0x09, 0xC0, 0xD7, 0x20, 0x3F, 0xD8, 0x37, 0x01, 0x4C, 0xF8, 0x2B, 0x31, 0x17, 0x30, 0xDD, 0x01,
  0x72, 0x82, 0x12, 0x4A, 0xD8, 0x1A, 0x31, 0x50, 0xDD, 0x0E, 0x76, 0x01, 0xE0, 0x47, 0x60, 0xDB,
  0x0B, 0x71, 0x08, 0xD0, 0xB7, 0x60, 0x5E, 0x08, 0x76, 0x0A, 0xB0, 0x37, 0x10, 0x3D, 0x0D, 0x76,
  0x08, 0xE0, 0xB7, 0x60, 0xBA, 0x0D, 0x73, 0xE7, 0x60, 0xCE, 0x0E, 0x76, 0x0E, 0xA0, 0x97, 0x30,
  0xBD, 0x03, 0x75, 0xF9, 0x02, 0x74, 0x01, 0xB0, 0x57, 0x30, 0x8D, 0x07, 0x74, 0x04, 0xF9, 0x06,
  0x74, 0x05, 0xB0, 0x17, 0x30, 0x4D, 0x0A, 0x74, 0x08, 0xA0, 0x0C, 0xC0, 0x97, 0x40, 0x8A, 0x0D,
  0x75, 0xD0, 0xE7, 0x40, 0xBA, 0x00, 0x9C, 0x0D, 0x74, 0x0C, 0xA0, 0x97, 0x50, 0xCD, 0x02, 0x73,
  0xB0, 0x05, 0xD0, 0x17, 0x3B, 0x06, 0x75, 0x08, 0xD0, 0x57, 0x20, 0x3B, 0x01, 0x02, 0xD0, 0x47,
  0x20, 0x4B, 0x02, 0x75, 0x04, 0xD0, 0x97, 0x20, 0x7A, 0x0D, 0x20, 0xDC, 0x08, 0x72, 0x07, 0xA0,
  0xE7, 0x60, 0x1D, 0x0C, 0x72, 0x0B, 0xA0, 0x92, 0x0A, 0xC0, 0xB7, 0x20, 0xBA, 0x0A, 0x77, 0x0C,
  0xD0, 0x17, 0x10, 0xEA, 0x05, 0x20, 0x6C, 0x0E, 0x72, 0x0E, 0xA0, 0x67, 0x70, 0x9D, 0x04, 0x70,
  0x3B, 0x01, 0x20, 0x3D, 0x02, 0x70, 0x3B, 0x03, 0x77, 0x05, 0xD0, 0x77, 0x06, 0xA0, 0xD4, 0x0E,
  0xC0, 0x67, 0x07, 0xA0, 0xE7, 0x71, 0x01, 0xD0, 0xB7, 0x0A, 0xA0, 0x94, 0x0B, 0xC0, 0x97, 0x0A,
  0xA0, 0xB7, 0x72, 0x0D, 0xC0, 0xE7, 0x0E, 0xA0, 0x64, 0x07, 0xC0, 0xD7, 0x0E, 0xA0, 0x77, 0x72,
  0x09, 0xD0, 0x25, 0x02, 0xB0, 0x24, 0x04, 0xD0, 0x15, 0x02, 0xB0, 0x37, 0x72, 0x06, 0xD0, 0x65,
  0x06, 0xA0, 0xE6, 0xD0, 0x45, 0x06, 0xB7, 0x73, 0x02, 0xD0, 0x95, 0x09, 0xA0, 0xA6, 0x0C, 0xC0,
  0x85, 0x09, 0xA0, 0xB7, 0x74, 0x0D, 0xC0, 0xD5, 0x0D, 0xA0, 0x66, 0x08, 0xC0, 0xB5, 0x0D, 0xA0,
  0x87, 0x74, 0x0A, 0xD0, 0x13, 0x01, 0xB0, 0x26, 0x05, 0xC0, 0xE4, 0x01, 0xB0, 0x47, 0x74, 0x06,
  0xD0, 0x43, 0x05, 0xA0, 0xE7, 0x01, 0xD0, 0x33, 0x05, 0xB7, 0x75, 0x02, 0xD0, 0x83, 0x08, 0xA0,
  0xA7, 0x10, 0xDC, 0x06, 0x30, 0x9A, 0x0C, 0x77, 0x60, 0xEC, 0x0B, 0x30, 0xCA, 0x07, 0x71, 0x09,
  0xC0, 0x93, 0x0C, 0xA0, 0x87, 0x76, 0x0A, 0xC0, 0xE3, 0xB0, 0x37, 0x10, 0x6C, 0x0D, 0x3B, 0x04,
  0x77, 0x60, 0x7D, 0x81, 0x20, 0x3A, 0x0E, 0x72, 0x02, 0xD8, 0x11, 0x04, 0xB0, 0x17, 0x76, 0x03,
  0xD8, 0x16, 0x06, 0xA0, 0xB7, 0x30, 0xEC, 0x81, 0x40, 0x7A, 0x0D, 0x77, 0x71, 0x0E, 0xC8, 0x19,
  0x0A, 0xA0, 0x77, 0x30, 0xBC, 0x81, 0x70, 0xAA, 0x09, 0x77, 0x71, 0x0B, 0xC8, 0x1C, 0x0D, 0xA0,
  0x37, 0x30, 0x7C, 0x81, 0xB0, 0xEA, 0x05, 0x77, 0x71, 0x07, 0xD0, 0x1B, 0x74, 0x03, 0xC0, 0xE0,
  0x1B, 0x01, 0x77, 0x71, 0x03, 0xD0, 0x6A, 0x0B, 0x75, 0xD0, 0x5A, 0x0D, 0x77, 0x73, 0xD0, 0xBA,
  0x08, 0x75, 0x0C, 0xC0, 0xBA, 0x09, 0x77, 0x73, 0x0B, 0xF0, 0x47, 0x50, 0x8F, 0x06, 0x77, 0x73,
  0x08, 0xF7, 0x60, 0x4F, 0x02, 0x77, 0x73, 0x04, 0xE0, 0xC7, 0x60, 0x1E, 0x0E, 0x77, 0x75, 0xE0,
  0x87, 0x70, 0xDD, 0x0A, 0x77, 0x75, 0x0C, 0xD0, 0x47, 0x70, 0x9D, 0x06, 0x77, 0x75, 0x08, 0xD0,
  0x17, 0x70, 0x5D, 0x03, 0x76,
  // "ŵ" (U+0175)
  0x77, 0x60, 0x38, 0x01, 0x78, 0x0C, 0x30, 0x0C, 0xD0, 0x48, 0x0C, 0x10, 0x05, 0xE0, 0xC8, 0x0C,
  0x10, 0x0D, 0xF0, 0x57, 0x77, 0x77, 0x08, 0xB0, 0xC0, 0x7B, 0x0D, 0x77, 0x77, 0x60, 0x2B, 0x82,
  0xE2, 0x09, 0xB0, 0x87, 0x77, 0x75, 0x0B, 0xA0, 0xE0, 0x33, 0x0B, 0xB0, 0x27, 0x77, 0x73, 0x06,
  0xA0, 0xE0, 0x45, 0x0B, 0xA0, 0xC7, 0x77, 0x72, 0x83, 0x2E, 0xFE, 0x47, 0x0B, 0xA0, 0x87, 0x77,
  0x71, 0x82, 0x8F, 0xE3, 0x72, 0x0A, 0xA8, 0x0B, 0xD3, 0x00, 0xEF, 0xC0, 0xD7, 0x10, 0xBA, 0x0B,
  0x71, 0x0C, 0xFB, 0x01, 0x0E, 0xFC, 0x0D, 0x71, 0xC7, 0x10, 0xCF, 0xB0, 0x10, 0xEF, 0xC0, 0xD7,
  0x04, 0xC0, 0x47, 0x0C, 0xFB, 0x82, 0x11, 0x4B, 0xF8, 0x16, 0x21, 0x70, 0x9C, 0x08, 0x78, 0x11,
  0x38, 0xD8, 0x1A, 0x31, 0x40, 0xCD, 0x07, 0x73, 0x0D, 0xC0, 0xD7, 0x30, 0x9B, 0x0B, 0x70, 0x5D,
  0x05, 0x72, 0x02, 0xE0, 0x17, 0x20, 0x5B, 0x04, 0x71, 0xD0, 0x67, 0x20, 0x7E, 0x06, 0x72, 0x05,
  0xA0, 0xE7, 0x20, 0xBC, 0x09, 0x72, 0x81, 0xBF, 0xEC, 0x0A, 0x72, 0x07, 0xA0, 0x97, 0x20, 0x7C,
  0x0D, 0x71, 0x01, 0xA0, 0x90, 0xDB, 0x0E, 0x72, 0x0A, 0xA0, 0x57, 0x20, 0x3D, 0x01, 0x70, 0x5A,
  0x04, 0x09, 0xC0, 0x37, 0x10, 0xEA, 0x01, 0x73, 0x0E, 0xC0, 0x57, 0x09, 0xA1, 0x05, 0xC0, 0x77,
  0x03, 0xA0, 0xC7, 0x40, 0xBC, 0x08, 0x78, 0x3E, 0xFB, 0x01, 0xC0, 0xC7, 0x07, 0xA0, 0x87, 0x40,
  0x7C, 0x0C, 0x60, 0x3A, 0x06, 0x20, 0xCC, 0x01, 0x60, 0xBA, 0x04, 0x74, 0x02, 0xD6, 0x07, 0xA0,
  0x22, 0x08, 0xC0, 0x56, 0x0E, 0xA7, 0x60, 0xEC, 0x03, 0x58, 0x1C, 0xFD, 0x30, 0x3C, 0x09, 0x50,
  0x3A, 0x0B, 0x76, 0x0A, 0xC0, 0x74, 0x01, 0xA0, 0x84, 0x0E, 0xB0, 0xE5, 0x07, 0xA0, 0x77, 0x60,
  0x6C, 0x0A, 0x40, 0x6A, 0x04, 0x40, 0xAC, 0x02, 0x40, 0xCA, 0x03, 0x76, 0x02, 0xC0, 0xE4, 0x81,
  0xAF, 0xE5, 0x06, 0xC0, 0x74, 0xA0, 0xE7, 0x71, 0x0D, 0xC0, 0x23, 0x81, 0xEF, 0xA5, 0x01, 0xC0,
  0xB3, 0x04, 0xA0, 0xA7, 0x71, 0x09, 0xC0, 0x52, 0x03, 0xA0, 0x66, 0x0D, 0xC3, 0x08, 0xA0, 0x57,
  0x71, 0x05, 0xC0, 0x82, 0x08, 0xA0, 0x16, 0x08, 0xC0, 0x42, 0x0C, 0xA0, 0x17, 0x71, 0x01, 0xC0,
  0xB2, 0x81, 0xCF, 0xD7, 0x04, 0xC0, 0x82, 0xA0, 0xD7, 0x73, 0x0D, 0xB0, 0xE2, 0xA0, 0x87, 0x1C,
  0x81, 0xB0, 0x4A, 0x08, 0x77, 0x30, 0x9C, 0x02, 0x04, 0xA0, 0x47, 0x10, 0xBC, 0x10, 0x7A, 0x04,
  0x77, 0x30, 0x5C, 0x82, 0x58, 0xFE, 0x72, 0x07, 0xC0, 0x30, 0xAA, 0x77, 0x40, 0x1C, 0x82, 0x8B,
  0xFA, 0x72, 0x02, 0xC8, 0x26, 0xDF, 0xB7, 0x75, 0x0C, 0xB8, 0x2B, 0xEF, 0x67, 0x30, 0xDB, 0x0A,
  0xA0, 0x77, 0x75, 0x08, 0xE0, 0x17, 0x30, 0x9E, 0x03, 0x77, 0x50, 0x4D, 0x0C, 0x74, 0x05, 0xD0,
  0xE7, 0x77, 0xD0, 0x87, 0x40, 0x1D, 0x0A, 0x77, 0x70, 0xBC, 0x03, 0x75, 0x0C, 0xC0, 0x67, 0x77,
  0x07, 0xB0, 0xE7, 0x60, 0x8C, 0x02, 0x74,
  // "Ŷ" (U+0176)
  0x77, 0x03, 0x80, 0x17, 0x77, 0x77, 0x0C, 0xD0, 0x47, 0x77, 0x50, 0x5E, 0x0C, 0x77, 0x75, 0x0D,
  0xF0, 0x57, 0x77, 0x30, 0x8B, 0x0C, 0x07, 0xB0, 0xD7, 0x77, 0x20, 0x2B, 0x82, 0xE2, 0x09, 0xB0,
  0x87, 0x77, 0x10, 0xBA, 0x0E, 0x03, 0x30, 0xBB, 0x02, 0x77, 0x60, 0x6A, 0x0E, 0x04, 0x50, 0xBA,
  0x0C, 0x77, 0x58, 0x32, 0xEF, 0xE4, 0x70, 0xBA, 0x08, 0x77, 0x48, 0x28, 0xFE, 0x37, 0x20, 0xAA,
  0x80, 0xA9, 0x50, 0x03, 0xFF, 0x02, 0x50, 0xAF, 0xC0, 0xB0, 0x3F, 0xF0, 0x25, 0x0A, 0xFC, 0x0B,
  0x03, 0xFF, 0x02, 0x50, 0xAF, 0xC8, 0x3B, 0x01, 0x4C, 0xF8, 0x2D, 0x41, 0x17, 0x82, 0x12, 0x6E,
  0xD8, 0x1B, 0x31, 0x40, 0xDE, 0x05, 0x76, 0x06, 0xC0, 0xB7, 0x04, 0xE0, 0x57, 0x60, 0x2B, 0x0E,
  0x01, 0x71, 0x0A, 0xD0, 0x87, 0x60, 0x4B, 0x07, 0x72, 0x03, 0xD0, 0xE7, 0x60, 0x8A, 0x0E, 0x74,
  0x0A, 0xD0, 0x67, 0x50, 0xDA, 0x07, 0x74, 0x02, 0xD0, 0xD7, 0x40, 0x5A, 0x0E, 0x76, 0x0A, 0xD0,
  0x57, 0x30, 0xDA, 0x07, 0x76, 0x02, 0xD0, 0xD7, 0x20, 0x5A, 0x0E, 0x77, 0x10, 0xAD, 0x05, 0x71,
  0x0D, 0xA0, 0x77, 0x71, 0x02, 0xD0, 0xD7, 0x06, 0xA0, 0xE7, 0x73, 0x0A, 0xD0, 0x56, 0x0D, 0xA0,
  0x77, 0x73, 0x02, 0xD0, 0xC5, 0x06, 0xA0, 0xE7, 0x75, 0x0A, 0xD0, 0x44, 0x0D, 0xA0, 0x77, 0x75,
  0x02, 0xD0, 0xB3, 0x04, 0xA0, 0xE7, 0x77, 0x09, 0xD0, 0x22, 0x0B, 0xA0, 0x67, 0x77, 0x02, 0xD8,
  0x19, 0x03, 0xA0, 0xE7, 0x77, 0x20, 0x9C, 0x81, 0xE0, 0xAA, 0x06, 0x77, 0x72, 0x02, 0xD0, 0x7A,
  0x0E, 0x77, 0x74, 0x09, 0xF0, 0x67, 0x77, 0x40, 0x2E, 0x0D, 0x77, 0x76, 0x09, 0xD0, 0x67, 0x77,
  0x60, 0x6D, 0x04, 0x77, 0x76, 0x06, 0xD0, 0x47, 0x77, 0x60, 0x6D, 0x04, 0x77, 0x76, 0x06, 0xD0,
  0x47, 0x77, 0x60, 0x6D, 0x04, 0x77, 0x76, 0x06, 0xD0, 0x47, 0x77, 0x60, 0x6D, 0x04, 0x77, 0x76,
  0x06, 0xD0, 0x47, 0x77, 0x60, 0x6D, 0x04, 0x77, 0x76, 0x06, 0xD0, 0x47, 0x77, 0x60, 0x6D, 0x04,
  0x77, 0x76, 0x07, 0xD0, 0x47, 0x77, 0x60, 0x9D, 0x07, 0x77, 0x75, 0x01, 0x0E, 0xD0, 0xD7, 0x77,
  0x28, 0x21, 0x37, 0xEF, 0x82, 0xD6, 0x31, 0x77, 0x40, 0xCF, 0xF9, 0x0A, 0x77, 0x30, 0xCF, 0xF9,
  0x0A, 0x77, 0x30, 0xCF, 0xF9, 0x0A, 0x71,
  // "ŷ" (U+0177)
  0x75, 0x03, 0x80, 0x17, 0x77, 0x73, 0x0C, 0xD0, 0x47, 0x77, 0x10, 0x5E, 0x0C, 0x77, 0x71, 0x0D,
  0xF0, 0x57, 0x76, 0x08, 0xB0, 0xC0, 0x7B, 0x0D, 0x77, 0x50, 0x2B, 0x82, 0xE2, 0x09, 0xB0, 0x87,
  0x74, 0x0B, 0xA0, 0xE0, 0x33, 0x0B, 0xB0, 0x27, 0x72, 0x06, 0xA0, 0xE0, 0x45, 0x0B, 0xA0, 0xC7,
  0x71, 0x83, 0x2E, 0xFE, 0x47, 0x0B, 0xA0, 0x87, 0x78, 0x28, 0xFE, 0x37, 0x20, 0xAA, 0x80, 0xAB,
  0x10, 0x0C, 0xFC, 0x0D, 0x50, 0x8F, 0xB0, 0x10, 0xCF, 0xC0, 0xD5, 0x08, 0xFB, 0x01, 0x0C, 0xFC,
  0x0D, 0x50, 0x8F, 0xB8, 0x21, 0x13, 0xBF, 0x81, 0x82, 0x16, 0x81, 0x25, 0xDC, 0x81, 0xD5, 0x24,
  0x0C, 0xD0, 0xB7, 0x40, 0x4C, 0x03, 0x60, 0x5D, 0x09, 0x74, 0x02, 0xB0, 0xA7, 0x10, 0xEC, 0x0B,
  0x74, 0x03, 0xB0, 0x47, 0x10, 0x8C, 0x0E, 0x74, 0x06, 0xA0, 0xE7, 0x20, 0x3D, 0x04, 0x73, 0x0B,
  0xA0, 0x97, 0x30, 0xDC, 0x09, 0x73, 0xB0, 0x47, 0x30, 0x7C, 0x0E, 0x72, 0x04, 0xA0, 0xE7, 0x40,
  0x1D, 0x04, 0x71, 0x09, 0xA0, 0xA7, 0x50, 0xBC, 0x09, 0x71, 0x0D, 0xA0, 0x57, 0x50, 0x6C, 0x0E,
  0x70, 0x2B, 0x77, 0xD0, 0x56, 0x06, 0xA0, 0xB7, 0x70, 0xAC, 0x0A, 0x60, 0xBA, 0x06, 0x77, 0x04,
  0xC0, 0xE6, 0xB0, 0x17, 0x71, 0x0E, 0xC0, 0x54, 0x04, 0xA0, 0xB7, 0x72, 0x09, 0xC0, 0xA4, 0x09,
  0xA0, 0x67, 0x72, 0x03, 0xD4, 0x0D, 0xA0, 0x17, 0x73, 0x0D, 0xC0, 0x42, 0x02, 0xA0, 0xC7, 0x74,
  0x07, 0xC0, 0x92, 0x06, 0xA0, 0x77, 0x74, 0x02, 0xC0, 0xD2, 0x0B, 0xA0, 0x27, 0x75, 0x0B, 0xC0,
  0x31, 0xA0, 0xD7, 0x76, 0x06, 0xC0, 0x70, 0x4A, 0x08, 0x77, 0x60, 0x1C, 0x0B, 0x07, 0xA0, 0x37,
  0x77, 0x0A, 0xB8, 0x2E, 0xBF, 0xD7, 0x77, 0x10, 0x5E, 0x09, 0x77, 0x72, 0x0E, 0xD0, 0x47, 0x77,
  0x20, 0x9C, 0x0E, 0x77, 0x73, 0x03, 0xC0, 0x97, 0x77, 0x40, 0xDB, 0x04, 0x77, 0x74, 0x0D, 0xA0,
  0xE7, 0x77, 0x40, 0x3B, 0x0A, 0x77, 0x74, 0x08, 0xB0, 0x57, 0x77, 0x40, 0xEA, 0x0E, 0x77, 0x74,
  0x06, 0xB0, 0x97, 0x77, 0x40, 0xDB, 0x03, 0x77, 0x73, 0x07, 0xB0, 0xD7, 0x77, 0x30, 0x3C, 0x06,
  0x77, 0x72, 0x03, 0x0E, 0xB0, 0xD7, 0x77, 0x20, 0x7D, 0x04, 0x77, 0x48, 0x31, 0x25, 0x9E, 0xD0,
  0x97, 0x74, 0x02, 0xFA, 0x09, 0x77, 0x50, 0x2F, 0x0D, 0x05, 0x77, 0x60, 0x2A, 0x83, 0xED, 0xB8,
  0x47, 0x77,
  // "Ÿ" (U+0178)
  0x74, 0x82, 0x8E, 0xE8, 0x58, 0x33, 0xCE, 0xC3, 0x77, 0x50, 0x5C, 0x07, 0x40, 0xEB, 0x0E, 0x77,
  0x50, 0x9C, 0x0B, 0x30, 0x2D, 0x02, 0x77, 0x40, 0x9C, 0x0B, 0x30, 0x2D, 0x02, 0x77, 0x40, 0x5C,
  0x08, 0x40, 0xEB, 0x0E, 0x77, 0x68, 0x28, 0xEE, 0x95, 0x83, 0x4C, 0xEC, 0x38, 0x0B, 0xA1, 0x00,
  0x3F, 0xF0, 0x25, 0x0A, 0xFC, 0x0B, 0x03, 0xFF, 0x02, 0x50, 0xAF, 0xC0, 0xB0, 0x3F, 0xF0, 0x25,
  0x0A, 0xFC, 0x83, 0xB0, 0x14, 0xCF, 0x82, 0xD4, 0x11, 0x78, 0x21, 0x26, 0xED, 0x81, 0xB3, 0x14,
  0x0D, 0xE0, 0x57, 0x60, 0x6C, 0x0B, 0x70, 0x4E, 0x05, 0x76, 0x02, 0xB0, 0xE0, 0x17, 0x10, 0xAD,
  0x08, 0x76, 0x04, 0xB0, 0x77, 0x20, 0x3D, 0x0E, 0x76, 0x08, 0xA0, 0xE7, 0x40, 0xAD, 0x06, 0x75,
  0x0D, 0xA0, 0x77, 0x40, 0x2D, 0x0D, 0x74, 0x05, 0xA0, 0xE7, 0x60, 0xAD, 0x05, 0x73, 0x0D, 0xA0,
  0x77, 0x60, 0x2D, 0x0D, 0x72, 0x05, 0xA0, 0xE7, 0x71, 0x0A, 0xD0, 0x57, 0x10, 0xDA, 0x07, 0x77,
  0x10, 0x2D, 0x0D, 0x70, 0x6A, 0x0E, 0x77, 0x30, 0xAD, 0x05, 0x60, 0xDA, 0x07, 0x77, 0x30, 0x2D,
  0x0C, 0x50, 0x6A, 0x0E, 0x77, 0x50, 0xAD, 0x04, 0x40, 0xDA, 0x07, 0x77, 0x50, 0x2D, 0x0B, 0x30,
  0x4A, 0x0E, 0x77, 0x70, 0x9D, 0x02, 0x20, 0xBA, 0x06, 0x77, 0x70, 0x2D, 0x81, 0x90, 0x3A, 0x0E,
  0x77, 0x72, 0x09, 0xC8, 0x1E, 0x0A, 0xA0, 0x67, 0x77, 0x20, 0x2D, 0x07, 0xA0, 0xE7, 0x77, 0x40,
  0x9F, 0x06, 0x77, 0x74, 0x02, 0xE0, 0xD7, 0x77, 0x60, 0x9D, 0x06, 0x77, 0x76, 0x06, 0xD0, 0x47,
  0x77, 0x60, 0x6D, 0x04, 0x77, 0x76, 0x06, 0xD0, 0x47, 0x77, 0x60, 0x6D, 0x04, 0x77, 0x76, 0x06,
  0xD0, 0x47, 0x77, 0x60, 0x6D, 0x04, 0x77, 0x76, 0x06, 0xD0, 0x47, 0x77, 0x60, 0x6D, 0x04, 0x77,
  0x76, 0x06, 0xD0, 0x47, 0x77, 0x60, 0x6D, 0x04, 0x77, 0x76, 0x06, 0xD0, 0x47, 0x77, 0x60, 0x7D,
  0x04, 0x77, 0x76, 0x09, 0xD0, 0x77, 0x77, 0x50, 0x10, 0xED, 0x0D, 0x77, 0x72, 0x82, 0x13, 0x7E,
  0xF8, 0x2D, 0x63, 0x17, 0x74, 0x0C, 0xFF, 0x90, 0xA7, 0x73, 0x0C, 0xFF, 0x90, 0xA7, 0x73, 0x0C,
  0xFF, 0x90, 0xA7, 0x10,
  // "Ź" (U+0179)
  0x77, 0x28, 0x02, 0x77, 0x77, 0x04, 0xD0, 0xC7, 0x77, 0x0B, 0xC0, 0xE0, 0x27, 0x76, 0x04, 0xD0,
  0x47, 0x77, 0x0C, 0xC0, 0x67, 0x77, 0x05, 0xC0, 0x77, 0x77, 0x10, 0xEB, 0x07, 0x77, 0x71, 0x08,
  0xB0, 0x67, 0x77, 0x10, 0x2B, 0x05, 0x77, 0x72, 0x82, 0x8F, 0xE3, 0x80, 0x9F, 0x30, 0x0D, 0xFF,
  0xFA, 0x0E, 0x30, 0xEF, 0xFF, 0xA0, 0xE3, 0x0E, 0xE8, 0x07, 0xEE, 0x0C, 0x30, 0xEB, 0x0C, 0x03,
  0x75, 0x0E, 0xD0, 0x53, 0xB0, 0xE0, 0x17, 0x50, 0x7D, 0x0C, 0x4B, 0x08, 0x75, 0x01, 0x0E, 0xD0,
  0x44, 0xB0, 0x37, 0x50, 0x8D, 0x0C, 0x5B, 0x75, 0x01, 0x0E, 0xD0, 0x44, 0x01, 0xA0, 0xD7, 0x50,
  0x8D, 0x0B, 0x50, 0x1A, 0x0C, 0x74, 0x01, 0xE0, 0x36, 0x81, 0x66, 0x47, 0x40, 0x9D, 0x0B, 0x77,
  0x60, 0x2E, 0x03, 0x77, 0x60, 0x9D, 0x0A, 0x77, 0x60, 0x2E, 0x02, 0x77, 0x60, 0xAD, 0x0A, 0x77,
  0x60, 0x2E, 0x02, 0x77, 0x60, 0xAD, 0x09, 0x77, 0x60, 0x3E, 0x02, 0x77, 0x60, 0xBD, 0x09, 0x77,
  0x60, 0x3E, 0x01, 0x77, 0x60, 0xBD, 0x08, 0x77, 0x60, 0x4D, 0x0E, 0x01, 0x77, 0x60, 0xCD, 0x08,
  0x77, 0x60, 0x4D, 0x0E, 0x01, 0x77, 0x60, 0xCD, 0x07, 0x77, 0x60, 0x5D, 0x0E, 0x77, 0x70, 0xDD,
  0x07, 0x77, 0x60, 0x5D, 0x0D, 0x77, 0x70, 0xDD, 0x06, 0x77, 0x60, 0x6D, 0x0D, 0x77, 0x70, 0xDD,
  0x06, 0x77, 0x60, 0x6D, 0x0D, 0x77, 0x70, 0xED, 0x05, 0x76, 0x81, 0x66, 0x44, 0x07, 0xD0, 0xC7,
  0x60, 0x2A, 0x0B, 0x40, 0xED, 0x04, 0x76, 0x03, 0xA0, 0xA3, 0x07, 0xD0, 0xC7, 0x70, 0x5A, 0x0A,
  0x20, 0x10, 0xED, 0x04, 0x77, 0x08, 0xA0, 0xA2, 0x08, 0xD0, 0xB7, 0x71, 0x0D, 0xA8, 0x2A, 0x01,
  0xED, 0x03, 0x77, 0x06, 0xB8, 0x19, 0x08, 0xD0, 0xB7, 0x68, 0x11, 0x6E, 0xB0, 0x90, 0x1F, 0x80,
  0x90, 0xEF, 0x09, 0x02, 0xFF, 0xFD, 0x09, 0x02, 0xFF, 0xFD, 0x08,
  // "ź" (U+017A)
  0x76, 0x80, 0x27, 0x77, 0x10, 0x4D, 0x0C, 0x77, 0x10, 0xBC, 0x0E, 0x02, 0x77, 0x04, 0xD0, 0x47,
  0x71, 0x0C, 0xC0, 0x67, 0x71, 0x05, 0xC0, 0x77, 0x72, 0x0E, 0xB0, 0x77, 0x72, 0x08, 0xB0, 0x67,
  0x72, 0x02, 0xB0, 0x57, 0x73, 0x82, 0x8F, 0xE3, 0x80, 0x9E, 0x50, 0x0B, 0xFF, 0xD8, 0x15, 0x0C,
  0xFF, 0xD8, 0x15, 0x0D, 0xE8, 0x03, 0xEE, 0x81, 0x40, 0xEA, 0x81, 0xE6, 0x17, 0x03, 0xD0, 0xB2,
  0xB0, 0x67, 0x20, 0xCD, 0x03, 0x2A, 0x0E, 0x72, 0x05, 0xD0, 0x92, 0x01, 0xA0, 0x97, 0x20, 0xDC,
  0x0E, 0x01, 0x20, 0x2A, 0x05, 0x71, 0x07, 0xD0, 0x73, 0x81, 0x15, 0x57, 0x10, 0x10, 0xEC, 0x0D,
  0x77, 0x10, 0x9D, 0x05, 0x77, 0x03, 0xD0, 0xB7, 0x71, 0x0B, 0xD0, 0x37, 0x70, 0x5D, 0x09, 0x77,
  0x10, 0xDC, 0x0E, 0x01, 0x77, 0x07, 0xD0, 0x77, 0x70, 0x10, 0xEC, 0x0D, 0x77, 0x10, 0x9D, 0x05,
  0x77, 0x02, 0xD0, 0xB7, 0x71, 0x0B, 0xD0, 0x37, 0x70, 0x4D, 0x09, 0x77, 0x10, 0xDC, 0x0E, 0x01,
  0x77, 0x06, 0xD0, 0x77, 0x70, 0x10, 0xEC, 0x0D, 0x72, 0x81, 0x69, 0x63, 0x08, 0xD0, 0x57, 0x28,
  0x1C, 0xFA, 0x20, 0x2D, 0x0B, 0x73, 0xA0, 0xA2, 0x0A, 0xD0, 0x37, 0x20, 0x3A, 0x81, 0x90, 0x4D,
  0x09, 0x73, 0x08, 0xA8, 0x19, 0x0C, 0xC0, 0xE0, 0x17, 0x20, 0x10, 0xEA, 0x08, 0x06, 0xD0, 0x77,
  0x20, 0x30, 0xCB, 0x08, 0x0E, 0xD8, 0x05, 0xEE, 0x08, 0xFF, 0xF0, 0x7F, 0xFF, 0x07,
  // "Ż" (U+017B)
  0x76, 0x83, 0x4C, 0xED, 0x57, 0x77, 0x10, 0x3D, 0x05, 0x77, 0x70, 0x7D, 0x0A, 0x77, 0x70, 0x9D,
  0x0B, 0x77, 0x70, 0x7D, 0x0A, 0x77, 0x70, 0x3D, 0x05, 0x77, 0x71, 0x83, 0x4C, 0xED, 0x58, 0x0A,
  0xE0, 0x00, 0xDF, 0xFF, 0xA0, 0xE3, 0x0E, 0xFF, 0xFA, 0x0E, 0x30, 0xEE, 0x80, 0x7E, 0xE0, 0xC3,
  0x0E, 0xB0, 0xC0, 0x37, 0x50, 0xED, 0x05, 0x3B, 0x0E, 0x01, 0x75, 0x07, 0xD0, 0xC4, 0xB0, 0x87,
  0x50, 0x10, 0xED, 0x04, 0x4B, 0x03, 0x75, 0x08, 0xD0, 0xC5, 0xB7, 0x50, 0x10, 0xED, 0x04, 0x40,
  0x1A, 0x0D, 0x75, 0x08, 0xD0, 0xB5, 0x01, 0xA0, 0xC7, 0x40, 0x1E, 0x03, 0x68, 0x16, 0x64, 0x74,
  0x09, 0xD0, 0xB7, 0x76, 0x02, 0xE0, 0x37, 0x76, 0x09, 0xD0, 0xA7, 0x76, 0x02, 0xE0, 0x27, 0x76,
  0x0A, 0xD0, 0xA7, 0x76, 0x02, 0xE0, 0x27, 0x76, 0x0A, 0xD0, 0x97, 0x76, 0x03, 0xE0, 0x27, 0x76,
  0x0B, 0xD0, 0x97, 0x76, 0x03, 0xE0, 0x17, 0x76, 0x0B, 0xD0, 0x87, 0x76, 0x04, 0xD0, 0xE0, 0x17,
  0x76, 0x0C, 0xD0, 0x87, 0x76, 0x04, 0xD0, 0xE0, 0x17, 0x76, 0x0C, 0xD0, 0x77, 0x76, 0x05, 0xD0,
  0xE7, 0x77, 0x0D, 0xD0, 0x77, 0x76, 0x05, 0xD0, 0xD7, 0x77, 0x0D, 0xD0, 0x67, 0x76, 0x06, 0xD0,
  0xD7, 0x77, 0x0D, 0xD0, 0x67, 0x76, 0x06, 0xD0, 0xD7, 0x77, 0x0E, 0xD0, 0x57, 0x68, 0x16, 0x64,
  0x40, 0x7D, 0x0C, 0x76, 0x02, 0xA0, 0xB4, 0x0E, 0xD0, 0x47, 0x60, 0x3A, 0x0A, 0x30, 0x7D, 0x0C,
  0x77, 0x05, 0xA0, 0xA2, 0x01, 0x0E, 0xD0, 0x47, 0x70, 0x8A, 0x0A, 0x20, 0x8D, 0x0B, 0x77, 0x10,
  0xDA, 0x82, 0xA0, 0x1E, 0xD0, 0x37, 0x70, 0x6B, 0x81, 0x90, 0x8D, 0x0B, 0x76, 0x81, 0x16, 0xEB,
  0x09, 0x01, 0xF8, 0x09, 0x0E, 0xF0, 0x90, 0x2F, 0xFF, 0xD0, 0x90, 0x2F, 0xFF, 0xD0, 0x80,
  // "ż" (U+017C)
  0x72, 0x83, 0x4C, 0xED, 0x57, 0x72, 0x03, 0xD0, 0x57, 0x71, 0x07, 0xD0, 0xA7, 0x71, 0x09, 0xD0,
  0xB7, 0x71, 0x07, 0xD0, 0xA7, 0x71, 0x03, 0xD0, 0x57, 0x72, 0x83, 0x4C, 0xED, 0x58, 0x0A, 0xB7,
  0x00, 0xBF, 0xFD, 0x81, 0x50, 0xCF, 0xFD, 0x81, 0x50, 0xDE, 0x80, 0x3E, 0xE8, 0x14, 0x0E, 0xA8,
  0x1E, 0x61, 0x70, 0x3D, 0x0B, 0x2B, 0x06, 0x72, 0x0C, 0xD0, 0x32, 0xA0, 0xE7, 0x20, 0x5D, 0x09,
  0x20, 0x1A, 0x09, 0x72, 0x0D, 0xC0, 0xE0, 0x12, 0x02, 0xA0, 0x57, 0x10, 0x7D, 0x07, 0x38, 0x11,
  0x55, 0x71, 0x01, 0x0E, 0xC0, 0xD7, 0x71, 0x09, 0xD0, 0x57, 0x70, 0x3D, 0x0B, 0x77, 0x10, 0xBD,
  0x03, 0x77, 0x05, 0xD0, 0x97, 0x71, 0x0D, 0xC0, 0xE0, 0x17, 0x70, 0x7D, 0x07, 0x77, 0x01, 0x0E,
  0xC0, 0xD7, 0x71, 0x09, 0xD0, 0x57, 0x70, 0x2D, 0x0B, 0x77, 0x10, 0xBD, 0x03, 0x77, 0x04, 0xD0,
  0x97, 0x71, 0x0D, 0xC0, 0xE0, 0x17, 0x70, 0x6D, 0x07, 0x77, 0x01, 0x0E, 0xC0, 0xD7, 0x28, 0x16,
  0x96, 0x30, 0x8D, 0x05, 0x72, 0x81, 0xCF, 0xA2, 0x02, 0xD0, 0xB7, 0x3A, 0x0A, 0x20, 0xAD, 0x03,
  0x72, 0x03, 0xA8, 0x19, 0x04, 0xD0, 0x97, 0x30, 0x8A, 0x81, 0x90, 0xCC, 0x0E, 0x01, 0x72, 0x01,
  0x0E, 0xA0, 0x80, 0x6D, 0x07, 0x72, 0x03, 0x0C, 0xB0, 0x80, 0xED, 0x80, 0x5E, 0xE0, 0x8F, 0xFF,
  0x07, 0xFF, 0xF0, 0x70,
  // "Ž" (U+017D)
  0x78, 0x14, 0x77, 0x73, 0x81, 0x37, 0x77, 0x50, 0x7A, 0x0A, 0x71, 0x82, 0x4E, 0xFD, 0x76, 0x0C,
  0xA0, 0xA6, 0x04, 0x0E, 0xA0, 0x47, 0x60, 0x2B, 0x0A, 0x40, 0x30, 0xEA, 0x08, 0x77, 0x10, 0x7B,
  0x08, 0x20, 0x20, 0xEA, 0x0D, 0x77, 0x30, 0xDB, 0x81, 0x61, 0xDB, 0x04, 0x77, 0x30, 0x3C, 0x0C,
  0xB0, 0xA7, 0x75, 0x09, 0xF0, 0x17, 0x75, 0x01, 0xE0, 0x87, 0x77, 0x09, 0xD0, 0x18, 0x09, 0xE7,
  0x00, 0xDF, 0xFF, 0xA0, 0xE3, 0x0E, 0xFF, 0xFA, 0x0E, 0x30, 0xEE, 0x80, 0x7E, 0xE0, 0xC3, 0x0E,
  0xB0, 0xC0, 0x37, 0x50, 0xED, 0x05, 0x3B, 0x0E, 0x01, 0x75, 0x07, 0xD0, 0xC4, 0xB0, 0x87, 0x50,
  0x10, 0xED, 0x04, 0x4B, 0x03, 0x75, 0x08, 0xD0, 0xC5, 0xB7, 0x50, 0x10, 0xED, 0x04, 0x40, 0x1A,
  0x0D, 0x75, 0x08, 0xD0, 0xB5, 0x01, 0xA0, 0xC7, 0x40, 0x1E, 0x03, 0x68, 0x16, 0x64, 0x74, 0x09,
  0xD0, 0xB7, 0x76, 0x02, 0xE0, 0x37, 0x76, 0x09, 0xD0, 0xA7, 0x76, 0x02, 0xE0, 0x27, 0x76, 0x0A,
  0xD0, 0xA7, 0x76, 0x02, 0xE0, 0x27, 0x76, 0x0A, 0xD0, 0x97, 0x76, 0x03, 0xE0, 0x27, 0x76, 0x0B,
  0xD0, 0x97, 0x76, 0x03, 0xE0, 0x17, 0x76, 0x0B, 0xD0, 0x87, 0x76, 0x04, 0xD0, 0xE0, 0x17, 0x76,
  0x0C, 0xD0, 0x87, 0x76, 0x04, 0xD0, 0xE0, 0x17, 0x76, 0x0C, 0xD0, 0x77, 0x76, 0x05, 0xD0, 0xE7,
  0x77, 0x0D, 0xD0, 0x77, 0x76, 0x05, 0xD0, 0xD7, 0x77, 0x0D, 0xD0, 0x67, 0x76, 0x06, 0xD0, 0xD7,
  0x77, 0x0D, 0xD0, 0x67, 0x76, 0x06, 0xD0, 0xD7, 0x77, 0x0E, 0xD0, 0x57, 0x68, 0x16, 0x64, 0x40,
  0x7D, 0x0C, 0x76, 0x02, 0xA0, 0xB4, 0x0E, 0xD0, 0x47, 0x60, 0x3A, 0x0A, 0x30, 0x7D, 0x0C, 0x77,
  0x05, 0xA0, 0xA2, 0x01, 0x0E, 0xD0, 0x47, 0x70, 0x8A, 0x0A, 0x20, 0x8D, 0x0B, 0x77, 0x10, 0xDA,
  0x82, 0xA0, 0x1E, 0xD0, 0x37, 0x70, 0x6B, 0x81, 0x90, 0x8D, 0x0B, 0x76, 0x81, 0x16, 0xEB, 0x09,
  0x01, 0xF8, 0x09, 0x0E, 0xF0, 0x90, 0x2F, 0xFF, 0xD0, 0x90, 0x2F, 0xFF, 0xD0, 0x80,
  // "ž" (U+017E)
  0x48, 0x14, 0x77, 0x73, 0x81, 0x37, 0x76, 0x07, 0xA0, 0xA7, 0x18, 0x24, 0xEF, 0xD7, 0x0C, 0xA0,
  0xA6, 0x04, 0x0E, 0xA0, 0x47, 0x02, 0xB0, 0xA4, 0x03, 0x0E, 0xA0, 0x87, 0x20, 0x7B, 0x08, 0x20,
  0x20, 0xEA, 0x0D, 0x74, 0x0D, 0xB8, 0x16, 0x1D, 0xB0, 0x47, 0x40, 0x3C, 0x0C, 0xB0, 0xA7, 0x60,
  0x9F, 0x01, 0x76, 0x01, 0xE0, 0x87, 0x71, 0x09, 0xD0, 0x18, 0x09, 0xE1, 0x00, 0xBF, 0xFD, 0x81,
  0x50, 0xCF, 0xFD, 0x81, 0x50, 0xDE, 0x80, 0x3E, 0xE8, 0x14, 0x0E, 0xA8, 0x1E, 0x61, 0x70, 0x3D,
  0x0B, 0x2B, 0x06, 0x72, 0x0C, 0xD0, 0x32, 0xA0, 0xE7, 0x20, 0x5D, 0x09, 0x20, 0x1A, 0x09, 0x72,
  0x0D, 0xC0, 0xE0, 0x12, 0x02, 0xA0, 0x57, 0x10, 0x7D, 0x07, 0x38, 0x11, 0x55, 0x71, 0x01, 0x0E,
  0xC0, 0xD7, 0x71, 0x09, 0xD0, 0x57, 0x70, 0x3D, 0x0B, 0x77, 0x10, 0xBD, 0x03, 0x77, 0x05, 0xD0,
  0x97, 0x71, 0x0D, 0xC0, 0xE0, 0x17, 0x70, 0x7D, 0x07, 0x77, 0x01, 0x0E, 0xC0, 0xD7, 0x71, 0x09,
  0xD0, 0x57, 0x70, 0x2D, 0x0B, 0x77, 0x10, 0xBD, 0x03, 0x77, 0x04, 0xD0, 0x97, 0x71, 0x0D, 0xC0,
  0xE0, 0x17, 0x70, 0x6D, 0x07, 0x77, 0x01, 0x0E, 0xC0, 0xD7, 0x28, 0x16, 0x96, 0x30, 0x8D, 0x05,
  0x72, 0x81, 0xCF, 0xA2, 0x02, 0xD0, 0xB7, 0x3A, 0x0A, 0x20, 0xAD, 0x03, 0x72, 0x03, 0xA8, 0x19,
  0x04, 0xD0, 0x97, 0x30, 0x8A, 0x81, 0x90, 0xCC, 0x0E, 0x01, 0x72, 0x01, 0x0E, 0xA0, 0x80, 0x6D,
  0x07, 0x72, 0x03, 0x0C, 0xB0, 0x80, 0xED, 0x80, 0x5E, 0xE0, 0x8F, 0xFF, 0x07, 0xFF, 0xF0, 0x70,
  // "ſ" (U+017F)
  0x73, 0x89, 0x01, 0x6B, 0xDE, 0xFE, 0xC9, 0x47, 0x50, 0x70, 0xEF, 0xA0, 0xB7, 0x30, 0x9F, 0xD0,
  0x97, 0x10, 0x7C, 0x83, 0xC4, 0x13, 0x9D, 0x01, 0x60, 0x2C, 0x0E, 0x01, 0x40, 0xCC, 0x02, 0x60,
  0x9C, 0x07, 0x50, 0x6C, 0x70, 0xEC, 0x03, 0x50, 0x2B, 0x07, 0x60, 0x2D, 0x68, 0x21, 0xC9, 0x37,
  0x05, 0xC0, 0xE7, 0x73, 0x07, 0xC0, 0xC7, 0x73, 0x08, 0xC0, 0xC7, 0x73, 0x08, 0xC0, 0xC7, 0x73,
  0x08, 0xC0, 0xC7, 0x73, 0x08, 0xC0, 0xC7, 0x73, 0x08, 0xC0, 0xC7, 0x73, 0x08, 0xC0, 0xC7, 0x73,
  0x08, 0xC0, 0xC7, 0x73, 0x08, 0xC0, 0xC7, 0x73, 0x08, 0xC0, 0xC7, 0x73, 0x08, 0xC0, 0xC7, 0x73,
  0x08, 0xC0, 0xC7, 0x73, 0x08, 0xC0, 0xC7, 0x73, 0x08, 0xC0, 0xC7, 0x73, 0x08, 0xC0, 0xC7, 0x73,
  0x08, 0xC0, 0xC7, 0x73, 0x08, 0xC0, 0xC7, 0x73, 0x08, 0xC0, 0xC7, 0x73, 0x08, 0xC0, 0xC7, 0x73,
  0x08, 0xC0, 0xC7, 0x73, 0x08, 0xC0, 0xC7, 0x73, 0x08, 0xC0, 0xC7, 0x73, 0x08, 0xC0, 0xC7, 0x73,
  0x08, 0xC0, 0xC7, 0x73, 0x08, 0xC0, 0xC7, 0x73, 0x08, 0xC0, 0xC7, 0x73, 0x08, 0xC0, 0xC7, 0x73,
  0x08, 0xC0, 0xC7, 0x73, 0x08, 0xC0, 0xC7, 0x73, 0x08, 0xC0, 0xC7, 0x73, 0x08, 0xC0, 0xC7, 0x73,
  0x09, 0xC0, 0xD7, 0x73, 0x0B, 0xD7, 0x72, 0x02, 0xE0, 0x67, 0x58, 0x21, 0x37, 0xEF, 0x09, 0x03,
  0x0F, 0x16, 0x06, 0xFF, 0x90, 0xE6, 0x06, 0xFF, 0x90, 0xE6, 0x06, 0xFF, 0x90, 0xE6,
  // "Ω" (U+03A9)
  0x76, 0x87, 0x14, 0x66, 0x77, 0x64, 0x17, 0x77, 0x28, 0x14, 0x9E, 0xFA, 0x81, 0xE9, 0x37, 0x74,
  0x05, 0x0D, 0xFF, 0x90, 0xB0, 0x37, 0x70, 0x10, 0xAE, 0x85, 0xEB, 0xA9, 0xAB, 0xEE, 0x08, 0x75,
  0x01, 0x0C, 0xD0, 0xB0, 0x47, 0x04, 0x0A, 0xD0, 0xB7, 0x40, 0xDD, 0x06, 0x74, 0x05, 0x0E, 0xC0,
  0xB7, 0x20, 0xAD, 0x06, 0x76, 0x05, 0xD0, 0x87, 0x04, 0xD0, 0xA7, 0x71, 0x09, 0xD0, 0x36, 0x0D,
  0xD0, 0x37, 0x71, 0x02, 0xD0, 0xB5, 0x04, 0xD0, 0xB7, 0x73, 0x0A, 0xD0, 0x34, 0x0A, 0xD0, 0x67,
  0x73, 0x05, 0xD0, 0x94, 0x0E, 0xD0, 0x27, 0x73, 0x01, 0xD0, 0xE3, 0x03, 0xD0, 0xE7, 0x75, 0x0D,
  0xD0, 0x32, 0x06, 0xD0, 0xC7, 0x75, 0x0B, 0xD0, 0x62, 0x08, 0xD0, 0xA7, 0x75, 0x09, 0xD0, 0x82,
  0x0A, 0xD0, 0x97, 0x75, 0x08, 0xD0, 0xA2, 0x0B, 0xD0, 0x87, 0x75, 0x07, 0xD0, 0xB2, 0x0C, 0xD0,
  0x77, 0x75, 0x06, 0xD0, 0xC2, 0x0C, 0xD0, 0x77, 0x75, 0x07, 0xD0, 0xC2, 0x0B, 0xD0, 0x87, 0x75,
  0x07, 0xD0, 0xB2, 0x0A, 0xD0, 0x97, 0x75, 0x08, 0xD0, 0xA2, 0x08, 0xD0, 0xA7, 0x75, 0x09, 0xD0,
  0x82, 0x05, 0xD0, 0xC7, 0x75, 0x0B, 0xD0, 0x52, 0x02, 0xD0, 0xE7, 0x75, 0x0E, 0xD0, 0x23, 0x0D,
  0xD0, 0x37, 0x73, 0x02, 0xD0, 0xD4, 0x08, 0xD0, 0x77, 0x73, 0x06, 0xD0, 0x84, 0x02, 0xD0, 0xD7,
  0x73, 0x0C, 0xD0, 0x25, 0x09, 0xD0, 0x47, 0x71, 0x03, 0xD0, 0x96, 0x01, 0x0E, 0xC0, 0xD7, 0x71,
  0x0C, 0xC0, 0xE0, 0x17, 0x04, 0xD0, 0xA7, 0x60, 0x9D, 0x04, 0x72, 0x06, 0xD0, 0xB0, 0x27, 0x20,
  0x20, 0xBD, 0x06, 0x74, 0x05, 0x0E, 0xD8, 0x1A, 0x61, 0x38, 0x11, 0x5A, 0xD0, 0xE0, 0x57, 0x60,
  0x20, 0xBE, 0x0A, 0x30, 0x9E, 0x0B, 0x02, 0x77, 0x28, 0x13, 0xAE, 0xB0, 0xA3, 0x09, 0xB8, 0x1E,
  0xA3, 0x72, 0x81, 0x9B, 0x87, 0x20, 0x5A, 0x0A, 0x30, 0xAA, 0x04, 0x72, 0x84, 0x8B, 0xAC, 0xFD,
  0x73, 0xA0, 0xB3, 0x0A, 0xA7, 0x38, 0x2D, 0xFD, 0xBA, 0x01, 0x72, 0xA0, 0xB3, 0x81, 0xBF, 0xE7,
  0x3A, 0x0C, 0x0B, 0xA0, 0x57, 0x28, 0x1E, 0xFC, 0x38, 0x1B, 0xFE, 0x72, 0x05, 0xA0, 0xC0, 0xAA,
  0x0C, 0x72, 0x81, 0xDF, 0xC3, 0x81, 0xCF, 0xE7, 0x20, 0xCA, 0x0B, 0x0A, 0xB8, 0x1B, 0x41, 0x68,
  0x1D, 0xFC, 0x38, 0x1C, 0xFD, 0x68, 0x11, 0x4B, 0xB0, 0xB0, 0x9F, 0xF0, 0xD3, 0x0D, 0xFF, 0x0A,
  0x09, 0xFF, 0x0D, 0x30, 0xDF, 0xF0, 0x90, 0x8F, 0xF0, 0xD3, 0x0D, 0xFF, 0x09, 0x07, 0xFF, 0x0E,
  0x30, 0xEF, 0xF0, 0x80,
  // "μ" (U+03BC)
  0x1D, 0x04, 0x73, 0x0D, 0xC0, 0x75, 0xD0, 0x47, 0x30, 0xDC, 0x07, 0x5D, 0x04, 0x73, 0x0D, 0xC0,
  0x75, 0xD0, 0x47, 0x30, 0xDC, 0x07, 0x5D, 0x04, 0x73, 0x0D, 0xC0, 0x75, 0xD0, 0x47, 0x30, 0xDC,
  0x07, 0x5D, 0x04, 0x73, 0x0D, 0xC0, 0x75, 0xD0, 0x47, 0x30, 0xDC, 0x07, 0x5D, 0x04, 0x73, 0x0D,
  0xC0, 0x75, 0xD0, 0x47, 0x30, 0xDC, 0x07, 0x5D, 0x04, 0x73, 0x0D, 0xC0, 0x75, 0xD0, 0x47, 0x30,
  0xDC, 0x07, 0x5D, 0x04, 0x73, 0x0D, 0xC0, 0x75, 0xD0, 0x47, 0x30, 0xDC, 0x07, 0x5D, 0x04, 0x73,
  0x0D, 0xC0, 0x75, 0xD0, 0x47, 0x30, 0xDC, 0x07, 0x5D, 0x04, 0x73, 0x0D, 0xC0, 0x75, 0xD0, 0x47,
  0x30, 0xDC, 0x07, 0x5D, 0x04, 0x73, 0x0D, 0xC0, 0x75, 0xD0, 0x47, 0x30, 0xEC, 0x07, 0x5D, 0x04,
  0x73, 0x0E, 0xC0, 0x75, 0xD0, 0x57, 0x3D, 0x07, 0x40, 0x1D, 0x06, 0x72, 0x03, 0xD0, 0x74, 0x01,
  0xD0, 0x87, 0x20, 0x7D, 0x07, 0x40, 0x1D, 0x0B, 0x72, 0x0C, 0xD0, 0x74, 0x02, 0xE0, 0x17, 0x04,
  0xE0, 0x74, 0x02, 0xE0, 0x86, 0x82, 0x1D, 0xFA, 0xC0, 0x94, 0x03, 0xF0, 0x64, 0x83, 0x2C, 0xFB,
  0x2C, 0x0D, 0x40, 0x3A, 0x0D, 0xD8, 0x2C, 0x98, 0xAB, 0x81, 0x30, 0xCC, 0x07, 0x30, 0x4A, 0x09,
  0x0B, 0xFB, 0x07, 0x20, 0x4D, 0x82, 0xB7, 0x15, 0xA8, 0x1A, 0x1C, 0xF9, 0x0A, 0x40, 0x6E, 0x02,
  0x06, 0xA0, 0xA2, 0x09, 0xE0, 0x86, 0x81, 0x3A, 0xEB, 0x02, 0x07, 0xA0, 0xB3, 0x84, 0x15, 0x77,
  0x51, 0x77, 0x07, 0xA0, 0xC7, 0x77, 0x20, 0x8A, 0x0D, 0x77, 0x72, 0x08, 0xB7, 0x77, 0x20, 0x9B,
  0x02, 0x77, 0x71, 0x09, 0xB0, 0x57, 0x77, 0x10, 0x9B, 0x0A, 0x77, 0x71, 0x09, 0xC0, 0x17, 0x77,
  0x08, 0xC0, 0xC7, 0x77, 0x06, 0xD8, 0x1D, 0x61, 0x77, 0x40, 0x3F, 0x05, 0x77, 0x50, 0xDE, 0x02,
  0x77, 0x50, 0x4D, 0x09, 0x77, 0x78, 0x34, 0xCF, 0xE8, 0x77, 0x60,
  // "π" (U+03C0)
  0x48, 0x17, 0xCE, 0xFF, 0xF9, 0x0C, 0x20, 0x10, 0xDF, 0xFF, 0xC0, 0xC2, 0x0B, 0xFF, 0xFD, 0x81,
  0xC0, 0x4F, 0xFF, 0xE8, 0x1C, 0x0B, 0xFF, 0xFE, 0x81, 0xC0, 0xEA, 0x07, 0x01, 0x20, 0x7A, 0x07,
  0x71, 0x03, 0xA0, 0xC6, 0x02, 0xA0, 0x94, 0x09, 0xA0, 0x67, 0x10, 0x5A, 0x0C, 0x60, 0x4A, 0x03,
  0x40, 0xAA, 0x05, 0x71, 0x07, 0xA0, 0xB6, 0x05, 0xA5, 0x0B, 0xA0, 0x57, 0x10, 0x8A, 0x0A, 0x77,
  0x0D, 0xA0, 0x47, 0x10, 0xAA, 0x09, 0x77, 0x0E, 0xA0, 0x37, 0x10, 0xBA, 0x09, 0x77, 0xB0, 0x27,
  0x10, 0xCA, 0x08, 0x76, 0x01, 0xB0, 0x27, 0x10, 0xEA, 0x07, 0x76, 0x03, 0xB0, 0x17, 0x1B, 0x07,
  0x76, 0x04, 0xB7, 0x10, 0x1B, 0x06, 0x76, 0x05, 0xB7, 0x10, 0x2B, 0x06, 0x76, 0x07, 0xA0, 0xE7,
  0x10, 0x3B, 0x05, 0x76, 0x08, 0xA0, 0xE7, 0x10, 0x4B, 0x05, 0x76, 0x0A, 0xA0, 0xD7, 0x10, 0x5B,
  0x04, 0x76, 0x0B, 0xA0, 0xC7, 0x10, 0x6B, 0x04, 0x76, 0x0C, 0xA0, 0xC7, 0x10, 0x7B, 0x03, 0x76,
  0x0E, 0xA0, 0xB7, 0x10, 0x8B, 0x03, 0x76, 0xB0, 0xA7, 0x10, 0x9B, 0x03, 0x75, 0x02, 0xB0, 0x97,
  0x10, 0x9B, 0x03, 0x75, 0x05, 0xB0, 0x87, 0x10, 0x9B, 0x02, 0x75, 0x08, 0xB0, 0x67, 0x10, 0xAB,
  0x03, 0x75, 0x0C, 0xB0, 0x47, 0x10, 0x9B, 0x04, 0x74, 0x03, 0xC0, 0x17, 0x10, 0x8B, 0x06, 0x74,
  0x0C, 0xB0, 0xC7, 0x20, 0x6B, 0x0C, 0x71, 0x81, 0x14, 0xCC, 0x06, 0x72, 0x02, 0xC8, 0x3A, 0x22,
  0x54, 0x30, 0xDD, 0x0D, 0x74, 0x0B, 0xF0, 0x73, 0x0D, 0xC0, 0xE0, 0x37, 0x40, 0x20, 0xDE, 0x07,
  0x38, 0x4D, 0xFE, 0xD8, 0x17, 0x68, 0x51, 0x9D, 0xFE, 0xB6, 0x20,
  // "–" (U+2013)
  0x18, 0x0B, 0x21, 0x10, 0x3F, 0xFF, 0xFA, 0x00, 0x3F, 0xFF, 0xFA, 0x00, 0x3F, 0xFF, 0xFA, 0x03,
  // "—" (U+2014)
  0x18, 0x0F, 0x01, 0x10, 0x38, 0x0F, 0x0F, 0x00, 0x38, 0x0F, 0x0F, 0x00, 0x38, 0x0F, 0x0F, 0x03,
  // "€" (U+20AC)
  0x77, 0x85, 0x25, 0x67, 0x65, 0x27, 0x74, 0x06, 0x0C, 0xF0, 0xD0, 0x87, 0x70, 0x30, 0xDF, 0xC0,
  0xE0, 0x37, 0x40, 0x5D, 0x82, 0xD9, 0x9C, 0xE0, 0x27, 0x20, 0x4C, 0x0E, 0x05, 0x40, 0x5D, 0x0B,
  0x71, 0x01, 0x0E, 0xC0, 0x36, 0x08, 0xD0, 0x17, 0x09, 0xC0, 0x77, 0x01, 0xD0, 0x36, 0x02, 0xC0,
  0xE7, 0x20, 0xCC, 0x01, 0x60, 0x8C, 0x08, 0x72, 0x0A, 0xB0, 0x97, 0x0E, 0xC0, 0x37, 0x28, 0x28,
  0xEB, 0x67, 0x03, 0xC0, 0xE7, 0x77, 0x08, 0xC0, 0xB7, 0x77, 0x0B, 0xC0, 0x87, 0x77, 0x0E, 0xC0,
  0x57, 0x76, 0x01, 0xD0, 0x37, 0x76, 0x03, 0xD0, 0x17, 0x76, 0x05, 0xD7, 0x74, 0x0F, 0x10, 0x7C,
  0x0E, 0x80, 0x61, 0x70, 0x1F, 0xFD, 0x05, 0x60, 0x1F, 0xFD, 0x05, 0x60, 0x1F, 0xFD, 0x05, 0x73,
  0x09, 0xC0, 0xC7, 0x77, 0x09, 0xC0, 0xC7, 0x77, 0x09, 0xC0, 0xC7, 0x74, 0x0F, 0x10, 0x9C, 0x0C,
  0x80, 0x41, 0x72, 0x01, 0xFF, 0xB0, 0x47, 0x10, 0x1F, 0xFB, 0x04, 0x71, 0x01, 0xFF, 0xB0, 0x47,
  0x50, 0x5D, 0x77, 0x70, 0x3D, 0x02, 0x77, 0x60, 0x1D, 0x04, 0x77, 0x70, 0xEC, 0x06, 0x77, 0x70,
  0xAC, 0x09, 0x77, 0x70, 0x7C, 0x0C, 0x77, 0x70, 0x2D, 0x01, 0x77, 0x70, 0xDC, 0x06, 0x77, 0x70,
  0x7C, 0x0C, 0x77, 0x70, 0x10, 0xEC, 0x04, 0x77, 0x70, 0x7C, 0x0D, 0x01, 0x73, 0x07, 0x09, 0x72,
  0x0D, 0xC0, 0xB7, 0x28, 0x16, 0xFE, 0x72, 0x02, 0x0E, 0xC0, 0xD0, 0x45, 0x01, 0x09, 0xA0, 0xC7,
  0x30, 0x30, 0xED, 0x83, 0xDA, 0x99, 0xCC, 0x05, 0x74, 0x02, 0x0C, 0xFD, 0x06, 0x77, 0x05, 0x0B,
  0xF8, 0x1E, 0xA2, 0x77, 0x38, 0x51, 0x46, 0x77, 0x54, 0x60,
  // "₿" (U+20BF)
  0x70, 0x6A, 0x03, 0x28, 0x1D, 0xFC, 0x77, 0x20, 0x6A, 0x03, 0x28, 0x1D, 0xFC, 0x77, 0x20, 0x6A,
  0x03, 0x28, 0x1D, 0xFC, 0x77, 0x20, 0x6A, 0x03, 0x28, 0x1D, 0xFC, 0x72, 0x0E, 0xFF, 0x81, 0xE6,
  0x17, 0x0E, 0xFF, 0xB0, 0x90, 0x15, 0x0E, 0xFF, 0xC0, 0xE0, 0x34, 0x81, 0x12, 0x8D, 0x85, 0xE1,
  0x11, 0x24, 0xAD, 0x0E, 0x02, 0x60, 0xDC, 0x0E, 0x60, 0x5D, 0x0B, 0x60, 0xBC, 0x0E, 0x70, 0x9D,
  0x03, 0x50, 0xAC, 0x0E, 0x70, 0x3D, 0x08, 0x50, 0xAC, 0x0E, 0x71, 0x0E, 0xC0, 0xC5, 0x0A, 0xC0,
  0xE7, 0x10, 0xCC, 0x0E, 0x50, 0xAC, 0x0E, 0x71, 0x0B, 0xD5, 0x0A, 0xC0, 0xE7, 0x10, 0xAD, 0x01,
  0x40, 0xAC, 0x0E, 0x71, 0x0B, 0xD5, 0x0A, 0xC0, 0xE7, 0x10, 0xBC, 0x0E, 0x50, 0xAC, 0x0E, 0x71,
  0x0D, 0xC0, 0xB5, 0x0A, 0xC0, 0xE7, 0x1D, 0x08, 0x50, 0xAC, 0x0E, 0x70, 0x5D, 0x02, 0x50, 0xAC,
  0x0E, 0x70, 0xBC, 0x09, 0x60, 0xAC, 0x0E, 0x60, 0x7C, 0x0C, 0x70, 0xAC, 0x85, 0xE1, 0x11, 0x25,
  0xBC, 0x0B, 0x01, 0x70, 0xAF, 0xE0, 0xD0, 0x67, 0x20, 0xAF, 0xE0, 0x90, 0x37, 0x20, 0xAF, 0xF9,
  0x0C, 0x02, 0x70, 0xAC, 0x0E, 0x48, 0x11, 0x4A, 0xC0, 0xE0, 0x46, 0x0A, 0xC0, 0xE7, 0x07, 0xC0,
  0xE0, 0x25, 0x0A, 0xC0, 0xE7, 0x10, 0xBC, 0x0C, 0x50, 0xAC, 0x0E, 0x71, 0x05, 0xD0, 0x44, 0x0A,
  0xC0, 0xE7, 0x2D, 0x09, 0x40, 0xAC, 0x0E, 0x72, 0x0C, 0xC0, 0xD4, 0x0A, 0xC0, 0xE7, 0x20, 0xAD,
  0x01, 0x30, 0xAC, 0x0E, 0x72, 0x09, 0xD0, 0x23, 0x0A, 0xC0, 0xE7, 0x20, 0x8D, 0x03, 0x30, 0xAC,
  0x0E, 0x72, 0x08, 0xD0, 0x43, 0x0A, 0xC0, 0xE7, 0x20, 0x9D, 0x03, 0x30, 0xAC, 0x0E, 0x72, 0x0A,
  0xD0, 0x23, 0x0A, 0xC0, 0xE7, 0x20, 0xCD, 0x40, 0xAC, 0x0E, 0x72, 0x0E, 0xC0, 0xC4, 0x0A, 0xC0,
  0xE7, 0x10, 0x3D, 0x07, 0x40, 0xBC, 0x0E, 0x71, 0x0A, 0xD0, 0x24, 0x0E, 0xC0, 0xE7, 0x06, 0xD0,
  0x92, 0x81, 0x12, 0x9D, 0x86, 0xE1, 0x11, 0x12, 0x5B, 0xD0, 0xC3, 0x0E, 0xFF, 0xD0, 0xC0, 0x13,
  0x0E, 0xFF, 0xB0, 0xE0, 0x75, 0x0E, 0xFF, 0x81, 0xE8, 0x47, 0x70, 0x6A, 0x03, 0x28, 0x1D, 0xFC,
  0x77, 0x20, 0x6A, 0x03, 0x28, 0x1D, 0xFC, 0x77, 0x20, 0x6A, 0x03, 0x28, 0x1D, 0xFC, 0x77, 0x20,
  0x6A, 0x03, 0x28, 0x1D, 0xFC, 0x77, 0x20, 0x6A, 0x03, 0x28, 0x1D, 0xFC, 0x72,
  // "‘" (U+2018)
  0x78, 0x12, 0x95, 0x50, 0x10, 0x9A, 0x06, 0x40, 0x30, 0xEA, 0x0D, 0x03, 0x38, 0x33, 0xEF, 0xE6,
  0x48, 0x31, 0xDF, 0xE3, 0x50, 0x8A, 0x04, 0x58, 0x21, 0xEF, 0xD6, 0x06, 0xA0, 0x96, 0x0A, 0xA0,
  0xA6, 0x0E, 0xB0, 0x55, 0xD0, 0xA3, 0x01, 0xE0, 0xB2, 0x01, 0xF0, 0x22, 0x0E, 0xE0, 0x42, 0x0A,
  0xE0, 0x22, 0x01, 0x0E, 0xC0, 0xB4, 0x84, 0x2A, 0xEE, 0x91, 0x20,
  // "’" (U+2019)
  0x38, 0x38, 0xDE, 0xB2, 0x40, 0xAC, 0x0E, 0x02, 0x20, 0x1E, 0x0B, 0x20, 0x3F, 0x20, 0x1F, 0x02,
  0x20, 0xAE, 0x02, 0x30, 0x9D, 0x01, 0x40, 0x5C, 0x60, 0x9A, 0x0C, 0x60, 0x8A, 0x07, 0x60, 0xBA,
  0x01, 0x50, 0x3A, 0x09, 0x58, 0x32, 0xDF, 0xE1, 0x40, 0x50, 0xEA, 0x04, 0x30, 0x20, 0xDA, 0x0E,
  0x04, 0x40, 0x4A, 0x0A, 0x01, 0x58, 0x14, 0xA3, 0x70,
  // "‚" (U+201A)
  0x38, 0x38, 0xDE, 0xB2, 0x40, 0xAC, 0x0E, 0x02, 0x20, 0x1E, 0x0B, 0x20, 0x3F, 0x20, 0x1F, 0x02,
  0x20, 0x9E, 0x02, 0x30, 0x8D, 0x01, 0x40, 0x4C, 0x60, 0x9A, 0x0C, 0x60, 0x8A, 0x07, 0x60, 0xCA,
  0x01, 0x50, 0x3A, 0x09, 0x58, 0x32, 0xEF, 0xE1, 0x40, 0x60, 0xEA, 0x04, 0x30, 0x20, 0xDA, 0x0E,
  0x04, 0x40, 0x4A, 0x0A, 0x01, 0x58, 0x14, 0x93, 0x70,
  // "‛" (U+201B)
  0x28, 0x42, 0xAE, 0xE9, 0x13, 0x01, 0x0E, 0xC0, 0xB3, 0x0A, 0xE0, 0x22, 0x0E, 0xE8, 0x14, 0x01,
  0xF8, 0x12, 0x01, 0xE0, 0xB3, 0xD0, 0xA0, 0x13, 0x0E, 0xB0, 0x55, 0x0A, 0xA0, 0xA6, 0x06, 0xA0,
  0x96, 0x82, 0x1E, 0xFD, 0x70, 0x8A, 0x04, 0x68, 0x31, 0xDF, 0xE2, 0x68, 0x33, 0xEF, 0xE6, 0x60,
  0x30, 0xEA, 0x0D, 0x03, 0x50, 0x10, 0x9A, 0x06, 0x78, 0x13, 0x95,
  // "“" (U+201C)
  0x70, 0x50, 0xB7, 0x05, 0x0B, 0x60, 0x30, 0xCA, 0x01, 0x40, 0x30, 0xCA, 0x01, 0x40, 0x7B, 0x0B,
  0x40, 0x7B, 0x0B, 0x40, 0x7A, 0x0D, 0x03, 0x40, 0x7A, 0x0D, 0x03, 0x40, 0x4A, 0x0B, 0x50, 0x4A,
  0x0B, 0x68, 0x2D, 0xFE, 0x15, 0x82, 0xDF, 0xE1, 0x50, 0x5A, 0x08, 0x50, 0x5A, 0x08, 0x60, 0xBA,
  0x04, 0x50, 0xBA, 0x04, 0x6B, 0x05, 0x5B, 0x05, 0x50, 0x3B, 0x0D, 0x02, 0x30, 0x3B, 0x0D, 0x02,
  0x40, 0x5D, 0x06, 0x20, 0x5D, 0x07, 0x30, 0x6E, 0x81, 0x60, 0x6E, 0x07, 0x20, 0x6E, 0x81, 0xD0,
  0x6E, 0x0E, 0x20, 0x4E, 0x81, 0xE0, 0x4F, 0x30, 0xED, 0x0C, 0x20, 0xED, 0x0D, 0x30, 0x5D, 0x06,
  0x20, 0x5D, 0x07, 0x48, 0x34, 0xCF, 0xD6, 0x48, 0x34, 0xCF, 0xD6, 0x30,
  // "”" (U+201D)
  0x28, 0x32, 0xBE, 0xE9, 0x48, 0x32, 0xBE, 0xE8, 0x30, 0x10, 0xEC, 0x0C, 0x20, 0x10, 0xEC, 0x0B,
  0x20, 0x6E, 0x81, 0x60, 0x6E, 0x81, 0x50, 0x8E, 0x81, 0xB0, 0x8E, 0x81, 0xA0, 0x7E, 0x81, 0xD0,
  0x7E, 0x82, 0xC0, 0x1E, 0xD8, 0x2D, 0x01, 0xED, 0x0C, 0x20, 0x20, 0xCC, 0x0C, 0x20, 0x20, 0xDC,
  0x0B, 0x40, 0x9B, 0x0A, 0x40, 0x9B, 0x09, 0x50, 0xEA, 0x07, 0x50, 0xEA, 0x06, 0x50, 0xEA, 0x03,
  0x50, 0xEA, 0x02, 0x40, 0x1A, 0x0C, 0x50, 0x1A, 0x0B, 0x50, 0x8A, 0x05, 0x50, 0x8A, 0x04, 0x40,
  0x5A, 0x0B, 0x50, 0x5A, 0x0A, 0x30, 0x10, 0x9A, 0x0D, 0x01, 0x40, 0x8A, 0x0D, 0x30, 0x60, 0xEA,
  0x0C, 0x01, 0x30, 0x60, 0xEA, 0x0C, 0x01, 0x30, 0xAA, 0x07, 0x58, 0x2A, 0xFE, 0x75, 0x81, 0x87,
  0x16, 0x81, 0x87, 0x16,
  // "„" (U+201E)
  0x28, 0x32, 0xBE, 0xE9, 0x48, 0x32, 0xBE, 0xE8, 0x30, 0x10, 0xEC, 0x0C, 0x20, 0x10, 0xEC, 0x0B,
  0x20, 0x6E, 0x81, 0x60, 0x6E, 0x81, 0x50, 0x8E, 0x81, 0xB0, 0x8E, 0x81, 0xA0, 0x6E, 0x81, 0xD0,
  0x6E, 0x82, 0xC0, 0x1D, 0xD8, 0x2D, 0x01, 0xDD, 0x0C, 0x20, 0x10, 0xCC, 0x0C, 0x20, 0x10, 0xCC,
  0x0B, 0x40, 0x9B, 0x0A, 0x40, 0x9B, 0x09, 0x50, 0xEA, 0x07, 0x50, 0xEA, 0x06, 0x50, 0xEA, 0x03,
  0x50, 0xEA, 0x02, 0x40, 0x1A, 0x0C, 0x50, 0x1A, 0x0B, 0x50, 0x9A, 0x05, 0x50, 0x9A, 0x04, 0x40,
  0x6A, 0x0B, 0x50, 0x6A, 0x0A, 0x30, 0x10, 0x9A, 0x0D, 0x01, 0x30, 0x10, 0x9A, 0x0D, 0x30, 0x60,
  0xEA, 0x0C, 0x01, 0x30, 0x60, 0xEA, 0x0C, 0x01, 0x38, 0x2A, 0xFE, 0x75, 0x82, 0xAF, 0xE7, 0x58,
  0x18, 0x71, 0x68, 0x18, 0x71, 0x60,
  // "‟" (U+201F)
  0x28, 0x42, 0xAE, 0xE9, 0x15, 0x83, 0x8D, 0xEB, 0x33, 0x01, 0x0E, 0xC0, 0xB4, 0x0A, 0xC0, 0xE0,
  0x12, 0x0A, 0xE0, 0x22, 0x04, 0xE0, 0x72, 0x0E, 0xE0, 0x42, 0x09, 0xE8, 0x19, 0x01, 0xF0, 0x22,
  0x0B, 0xE8, 0x17, 0x01, 0xE0, 0xB3, 0x0C, 0xD0, 0xE0, 0x22, 0xD0, 0xA0, 0x13, 0x0B, 0xC0, 0xD0,
  0x33, 0x0E, 0xB0, 0x55, 0x09, 0xB0, 0x95, 0x0A, 0xA0, 0xA6, 0x05, 0xB6, 0x06, 0xA0, 0x96, 0x01,
  0xA0, 0xE6, 0x82, 0x1E, 0xFD, 0x70, 0xBA, 0x02, 0x60, 0x8A, 0x04, 0x60, 0x3A, 0x09, 0x68, 0x31,
  0xDF, 0xE2, 0x60, 0xAA, 0x07, 0x68, 0x33, 0xEF, 0xE6, 0x60, 0xCA, 0x0A, 0x01, 0x50, 0x30, 0xEA,
  0x0D, 0x03, 0x40, 0x10, 0xBA, 0x0E, 0x07, 0x50, 0x10, 0x9A, 0x06, 0x68, 0x27, 0xEF, 0xC7, 0x81,
  0x39, 0x57, 0x81, 0x17, 0xA0,
  // "†" (U+2020)
  0x71, 0x0D, 0xC0, 0x27, 0x71, 0x0C, 0xC0, 0x17, 0x71, 0x0A, 0xC7, 0x72, 0x09, 0xB0, 0xD7, 0x72,
  0x07, 0xB0, 0xB7, 0x72, 0x06, 0xB0, 0xA7, 0x72, 0x04, 0xB0, 0x87, 0x72, 0x03, 0xB0, 0x77, 0x72,
  0x01, 0xB0, 0x57, 0x73, 0xB0, 0x47, 0x73, 0x0E, 0xA0, 0x27, 0x73, 0x0C, 0xA0, 0x17, 0x73, 0x81,
  0xBF, 0xE7, 0x28, 0x21, 0x64, 0x15, 0x81, 0x9F, 0xD6, 0x82, 0x36, 0x32, 0xB8, 0x93, 0xEB, 0x85,
  0x39, 0xFC, 0x25, 0x8A, 0xDB, 0x06, 0x02, 0xFF, 0xD0, 0x60, 0x2F, 0x83, 0xDD, 0xFE, 0xDF, 0x06,
  0x02, 0xA8, 0x7D, 0xA7, 0x41, 0x0B, 0xFE, 0x28, 0x23, 0x69, 0xCA, 0x81, 0x60, 0x37, 0xB0, 0x46,
  0x03, 0x02, 0x71, 0x04, 0xB0, 0x87, 0x72, 0x09, 0xB0, 0xD7, 0x72, 0x0D, 0xC0, 0x27, 0x70, 0x2D,
  0x07, 0x77, 0x05, 0xD0, 0xA7, 0x70, 0x3D, 0x08, 0x77, 0x1D, 0x05, 0x77, 0x10, 0xEC, 0x03, 0x77,
  0x10, 0xCC, 0x01, 0x77, 0x10, 0xAC, 0x77, 0x20, 0x9B, 0x0D, 0x77, 0x20, 0x7B, 0x0B, 0x77, 0x20,
  0x6B, 0x0A, 0x77, 0x20, 0x4B, 0x08, 0x77, 0x20, 0x3B, 0x07, 0x77, 0x20, 0x2B, 0x06, 0x77, 0x20,
  0x1B, 0x05, 0x77, 0x3B, 0x04, 0x77, 0x30, 0xEA, 0x03, 0x77, 0x30, 0xDA, 0x01, 0x77, 0x30, 0xCA,
  0x01, 0x77, 0x30, 0xCA, 0x77, 0x48, 0x1B, 0xFE, 0x77, 0x48, 0x1A, 0xFE, 0x77, 0x48, 0x1A, 0xFD,
  0x77, 0x48, 0x19, 0xFD, 0x77, 0x48, 0x19, 0xFC, 0x77, 0x48, 0x18, 0xFC, 0x77, 0x48, 0x18, 0xFB,
  0x77, 0x48, 0x18, 0xFB, 0x77, 0x48, 0x18, 0xFB, 0x77, 0x48, 0x18, 0xFB, 0x77, 0x48, 0x17, 0xFB,
  0x77, 0x48, 0x13, 0x75, 0x72,
  // "‡" (U+2021)
  0x71, 0x0D, 0xC0, 0x27, 0x71, 0x0B, 0xC7, 0x72, 0x09, 0xB0, 0xE7, 0x72, 0x08, 0xB0, 0xC7, 0x72,
  0x06, 0xB0, 0xA7, 0x72, 0x04, 0xB0, 0x87, 0x72, 0x02, 0xB0, 0x67, 0x73, 0xB0, 0x47, 0x73, 0x0E,
  0xA0, 0x27, 0x73, 0x0C, 0xA7, 0x28, 0x21, 0x63, 0x15, 0x81, 0xAF, 0xE6, 0x82, 0x35, 0x32, 0xB8,
  0x93, 0xDB, 0x85, 0x29, 0xFC, 0x24, 0x7A, 0xDB, 0x06, 0x02, 0xFF, 0xD0, 0x60, 0x2F, 0x83, 0xEE,
  0xFE, 0xEF, 0x06, 0x02, 0xA8, 0x95, 0xEB, 0x85, 0x20, 0xAF, 0xE0, 0x14, 0x7A, 0xDA, 0x82, 0x60,
  0x52, 0x60, 0xEA, 0x03, 0x58, 0x11, 0x42, 0x71, 0x04, 0xB0, 0x87, 0x72, 0x08, 0xB0, 0xD7, 0x72,
  0x0C, 0xC0, 0x27, 0x70, 0x1D, 0x07, 0x77, 0x04, 0xD0, 0xA7, 0x71, 0x09, 0xB0, 0xD0, 0x17, 0x71,
  0x01, 0x0E, 0xA0, 0x57, 0x73, 0x0B, 0xA7, 0x74, 0x81, 0x7F, 0xC7, 0x74, 0x81, 0x5F, 0xA7, 0x74,
  0x81, 0x4F, 0x87, 0x74, 0x81, 0x5F, 0x97, 0x74, 0x81, 0x7F, 0xB7, 0x74, 0x81, 0xBF, 0xE7, 0x73,
  0x01, 0x0E, 0xA0, 0x47, 0x72, 0x08, 0xB0, 0xC7, 0x71, 0x03, 0xD0, 0x87, 0x70, 0x2D, 0x07, 0x77,
  0x10, 0xDC, 0x02, 0x77, 0x10, 0x9B, 0x0D, 0x77, 0x20, 0x5B, 0x09, 0x72, 0x01, 0x7B, 0x04, 0x78,
  0x61, 0x2F, 0xEB, 0x85, 0x22, 0x81, 0xBF, 0xE2, 0x86, 0x14, 0x7A, 0xDF, 0x62, 0xE8, 0x5E, 0xBD,
  0xFE, 0xBE, 0xE0, 0x60, 0x2F, 0xFD, 0x06, 0x02, 0xC8, 0x91, 0xEB, 0x85, 0xAF, 0xC5, 0x8A, 0xDC,
  0x84, 0x61, 0x97, 0x41, 0x48, 0x1A, 0xFD, 0x58, 0x23, 0x69, 0x47, 0x20, 0xCA, 0x77, 0x40, 0xEA,
  0x02, 0x77, 0x3B, 0x04, 0x77, 0x20, 0x2B, 0x06, 0x77, 0x20, 0x4B, 0x08, 0x77, 0x20, 0x6B, 0x0A,
  0x77, 0x20, 0x8B, 0x0C, 0x77, 0x20, 0xAB, 0x0E, 0x77, 0x20, 0xCC, 0x01, 0x77, 0x18, 0x46, 0x77,
  0x77, 0x17,
  // "•" (U+2022)
  0x48, 0x56, 0xBE, 0xFD, 0xB5, 0x60, 0x20, 0xDF, 0x0C, 0x01, 0x30, 0x10, 0xDF, 0xA0, 0xC3, 0x08,
  0xFC, 0x06, 0x20, 0xEF, 0xC8, 0x1C, 0x02, 0xFE, 0x10, 0x4F, 0xE0, 0x30, 0x5F, 0xE0, 0x40, 0x6F,
  0xE0, 0x40, 0x5F, 0xE0, 0x04, 0xFE, 0x00, 0x2F, 0xE2, 0x0E, 0xFC, 0x0C, 0x20, 0x8F, 0xC0, 0x52,
  0x01, 0x0D, 0xFA, 0x0B, 0x40, 0x20, 0xDF, 0x0C, 0x01, 0x68, 0x56, 0xBE, 0xFD, 0xA5, 0x40,
  // "…" (U+2026)
  0x28, 0x15, 0x74, 0x73, 0x81, 0x47, 0x57, 0x38, 0x22, 0x66, 0x22, 0x03, 0x0D, 0xB0, 0xB7, 0x10,
  0xBB, 0x0E, 0x03, 0x70, 0x6C, 0x81, 0x70, 0xBD, 0x06, 0x60, 0x6D, 0x0C, 0x60, 0x1E, 0x02, 0xE0,
  0x96, 0x09, 0xE6, 0x04, 0xE0, 0x6E, 0x0A, 0x60, 0xAE, 0x01, 0x50, 0x5E, 0x07, 0xE0, 0x96, 0x09,
  0xE6, 0x04, 0xE0, 0x60, 0xBD, 0x06, 0x60, 0x5D, 0x0B, 0x60, 0x1E, 0x81, 0x22, 0xDB, 0x0B, 0x71,
  0x0B, 0xB0, 0xE0, 0x37, 0x06, 0xC0, 0x73, 0x81, 0x57, 0x47, 0x38, 0x14, 0x75, 0x73, 0x82, 0x26,
  0x62, 0x20,
  // "‰" (U+2030)
  0x68, 0x33, 0x57, 0x64, 0x80, 0xE4, 0x00, 0x50, 0xDD, 0x0E, 0x08, 0x77, 0x10, 0xDA, 0x07, 0x77,
  0x77, 0x60, 0x8F, 0xA0, 0xC0, 0x17, 0x50, 0x5B, 0x01, 0x77, 0x77, 0x50, 0x5C, 0x81, 0xE9, 0xBC,
  0x0B, 0x75, 0x0B, 0xA0, 0xA7, 0x77, 0x76, 0x0E, 0xB0, 0xC0, 0x12, 0x05, 0xC0, 0x67, 0x30, 0x2B,
  0x03, 0x77, 0x77, 0x50, 0x6C, 0x03, 0x40, 0xAB, 0x0D, 0x73, 0x09, 0xA0, 0xC7, 0x77, 0x76, 0x0C,
  0xB0, 0xD5, 0x05, 0xC0, 0x37, 0x10, 0x10, 0xEA, 0x06, 0x77, 0x77, 0x50, 0x1C, 0x09, 0x50, 0x1C,
  0x08, 0x71, 0x07, 0xA0, 0xE7, 0x77, 0x76, 0x04, 0xC0, 0x66, 0x0E, 0xB0, 0xC7, 0x10, 0xDA, 0x08,
  0x77, 0x77, 0x60, 0x7C, 0x04, 0x60, 0xCB, 0x0E, 0x70, 0x4B, 0x02, 0x77, 0x77, 0x60, 0x9C, 0x03,
  0x60, 0xAC, 0x01, 0x60, 0xBA, 0x0B, 0x77, 0x77, 0x70, 0xAC, 0x02, 0x60, 0x9C, 0x03, 0x50, 0x2B,
  0x04, 0x77, 0x77, 0x70, 0xBC, 0x01, 0x60, 0x9C, 0x03, 0x50, 0x9A, 0x0D, 0x80, 0xC0, 0x00, 0xBC,
  0x01, 0x60, 0x8C, 0x04, 0x50, 0xEA, 0x07, 0x80, 0xC0, 0x00, 0xBC, 0x01, 0x60, 0x8C, 0x04, 0x40,
  0x6A, 0x0E, 0x01, 0x80, 0xC0, 0x00, 0xAC, 0x01, 0x60, 0x9C, 0x03, 0x40, 0xDA, 0x09, 0x80, 0xC1,
  0x00, 0xAC, 0x02, 0x60, 0x9C, 0x02, 0x30, 0x4B, 0x02, 0x80, 0xC1, 0x00, 0x8C, 0x03, 0x60, 0xAC,
  0x40, 0xAA, 0x0B, 0x48, 0x12, 0x9D, 0xA8, 0x1E, 0xB5, 0x75, 0x82, 0x17, 0xCE, 0xA8, 0x1C, 0x71,
  0x50, 0x5C, 0x04, 0x60, 0xBB, 0x0D, 0x30, 0x2B, 0x05, 0x30, 0x7F, 0x90, 0xB0, 0x17, 0x20, 0x30,
  0xEF, 0x0E, 0x03, 0x40, 0x2C, 0x06, 0x60, 0xDB, 0x0A, 0x30, 0x8A, 0x0D, 0x30, 0x7F, 0xB0, 0xC7,
  0x10, 0x2F, 0xB0, 0xE0, 0x24, 0x0D, 0xB0, 0x86, 0xC0, 0x53, 0x0E, 0xA0, 0x72, 0x02, 0xC8, 0x2B,
  0x21, 0x6C, 0x08, 0x70, 0xDB, 0x83, 0xE4, 0x03, 0xDB, 0x0C, 0x40, 0x9B, 0x0B, 0x50, 0x3B, 0x0E,
  0x01, 0x20, 0x6B, 0x01, 0x20, 0xAB, 0x0D, 0x40, 0x7C, 0x01, 0x50, 0x5C, 0x04, 0x30, 0x3C, 0x05,
  0x30, 0x2C, 0x01, 0x40, 0x8B, 0x08, 0x30, 0xCA, 0x0A, 0x20, 0x1C, 0x07, 0x40, 0x1C, 0x07, 0x50,
  0xBB, 0x0C, 0x50, 0xBB, 0x0C, 0x40, 0x9B, 0x08, 0x30, 0x10, 0xEA, 0x0E, 0x01, 0x20, 0x3B, 0x03,
  0x20, 0x6C, 0x03, 0x50, 0xCB, 0x0C, 0x40, 0x1C, 0x07, 0x50, 0x7C, 0x01, 0x40, 0xDB, 0x82, 0x83,
  0x4C, 0xB0, 0x43, 0x0A, 0xA0, 0xC3, 0x0A, 0xC6, 0x09, 0xC0, 0x13, 0x05, 0xC0, 0x45, 0x03, 0xC0,
  0x64, 0x01, 0x0C, 0xF0, 0xE0, 0x43, 0x01, 0xB0, 0x63, 0x0D, 0xB0, 0xD6, 0x06, 0xC0, 0x53, 0x08,
  0xC0, 0x15, 0x01, 0xC0, 0x96, 0x86, 0x5A, 0xDF, 0xEC, 0x71, 0x40, 0x8A, 0x0E, 0x4C, 0x0B, 0x60,
  0x5C, 0x07, 0x30, 0xAC, 0x7C, 0x0B, 0x77, 0x40, 0xEA, 0x08, 0x30, 0x2C, 0x09, 0x60, 0x3C, 0x09,
  0x30, 0xCB, 0x0E, 0x70, 0xEB, 0x0E, 0x77, 0x30, 0x5B, 0x02, 0x30, 0x3C, 0x08, 0x60, 0x2C, 0x0A,
  0x30, 0xDB, 0x0D, 0x70, 0xDC, 0x77, 0x30, 0xCA, 0x0A, 0x40, 0x3C, 0x08, 0x60, 0x2C, 0x0B, 0x30,
  0xEB, 0x0C, 0x70, 0xCC, 0x77, 0x20, 0x3B, 0x04, 0x40, 0x4C, 0x07, 0x60, 0x2C, 0x0C, 0x30, 0xEB,
  0x0C, 0x70, 0xCC, 0x01, 0x77, 0x10, 0x9A, 0x0D, 0x50, 0x4C, 0x07, 0x60, 0x2C, 0x0B, 0x30, 0xEB,
  0x0C, 0x70, 0xCC, 0x77, 0x10, 0x1B, 0x06, 0x50, 0x3C, 0x08, 0x60, 0x2C, 0x0B, 0x30, 0xDB, 0x0C,
  0x70, 0xCC, 0x77, 0x10, 0x7A, 0x0E, 0x60, 0x2C, 0x08, 0x60, 0x2C, 0x0A, 0x30, 0xCB, 0x0C, 0x70,
  0xCB, 0x0E, 0x77, 0x10, 0xDA, 0x09, 0x7C, 0x09, 0x60, 0x3C, 0x08, 0x30, 0xBB, 0x0D, 0x70, 0xDB,
  0x0C, 0x77, 0x05, 0xB0, 0x27, 0x0E, 0xB0, 0xA6, 0x04, 0xC0, 0x53, 0x08, 0xC7, 0x0E, 0xB0, 0xA7,
  0x70, 0xBA, 0x0B, 0x71, 0x0B, 0xB0, 0xC6, 0x06, 0xC0, 0x33, 0x06, 0xC0, 0x15, 0x01, 0xC0, 0x77,
  0x60, 0x2B, 0x05, 0x71, 0x07, 0xB0, 0xE6, 0x08, 0xB0, 0xE4, 0x02, 0xC0, 0x35, 0x03, 0xC0, 0x27,
  0x60, 0x9A, 0x0D, 0x72, 0x03, 0xC0, 0x25, 0x0B, 0xB0, 0x95, 0x0D, 0xB0, 0x65, 0x06, 0xB0, 0xD7,
  0x60, 0x10, 0xEA, 0x07, 0x73, 0x0C, 0xB0, 0x65, 0x0E, 0xB0, 0x35, 0x07, 0xB0, 0xA5, 0x0A, 0xB0,
  0x77, 0x60, 0x7B, 0x01, 0x73, 0x05, 0xB0, 0xC4, 0x05, 0xB0, 0xB6, 0x01, 0x0E, 0xB0, 0x13, 0x01,
  0x0E, 0xA0, 0xE0, 0x17, 0x60, 0xDA, 0x0A, 0x75, 0x0B, 0xB0, 0x72, 0x01, 0x0D, 0xA0, 0xE0, 0x27,
  0x06, 0xB0, 0xB3, 0x0A, 0xB0, 0x57, 0x60, 0x4B, 0x03, 0x75, 0x01, 0x0C, 0xB8, 0x1C, 0xBE, 0xA0,
  0xE0, 0x47, 0x20, 0x9B, 0x81, 0xDA, 0xDB, 0x08, 0x77, 0x0B, 0xA0, 0xC7, 0x71, 0x09, 0x0E, 0xD0,
  0xB0, 0x27, 0x40, 0x60, 0xDD, 0x0D, 0x05, 0x80, 0xC0, 0x08, 0x34, 0x67, 0x52, 0x77, 0x18, 0x33,
  0x67, 0x53, 0x70,
  // "‹" (U+2039)
  0x70, 0x2A, 0x0A, 0x70, 0xDA, 0x03, 0x60, 0x9A, 0x0C, 0x60, 0x5B, 0x05, 0x50, 0x20, 0xEA, 0x0D,
  0x60, 0xCB, 0x06, 0x50, 0x8B, 0x0E, 0x50, 0x4C, 0x08, 0x40, 0x10, 0xEC, 0x01, 0x40, 0xBC, 0x09,
  0x40, 0x7D, 0x02, 0x40, 0x9C, 0x0C, 0x50, 0x8D, 0x02, 0x50, 0xDC, 0x09, 0x50, 0x2C, 0x0E, 0x01,
  0x50, 0x6C, 0x07, 0x60, 0xAB, 0x0E, 0x70, 0xDB, 0x06, 0x60, 0x2B, 0x0D, 0x70, 0x6B, 0x05, 0x70,
  0xAA, 0x0C, 0x71, 0x0D, 0xA0, 0x37, 0x02, 0xA0, 0xA0,
  // "›" (U+203A)
  0x06, 0xA0, 0x87, 0x10, 0xEA, 0x04, 0x70, 0x8A, 0x0E, 0x01, 0x60, 0x1B, 0x0B, 0x70, 0x9B, 0x07,
  0x60, 0x2C, 0x03, 0x60, 0xBB, 0x0D, 0x60, 0x4C, 0x0A, 0x60, 0xCC, 0x06, 0x50, 0x5C, 0x0E, 0x02,
  0x50, 0xDC, 0x0C, 0x50, 0x8D, 0x50, 0xDC, 0x0D, 0x40, 0x4D, 0x03, 0x40, 0xBC, 0x07, 0x40, 0x3C,
  0x0B, 0x50, 0xAB, 0x0E, 0x01, 0x40, 0x2C, 0x04, 0x50, 0x9B, 0x08, 0x50, 0x10, 0xEA, 0x0B, 0x60,
  0x7A, 0x0E, 0x01, 0x60, 0xEA, 0x04, 0x60, 0x6A, 0x08, 0x70,
  // "⁄" (U+2044)
  0x77, 0x30, 0x4B, 0x01, 0x77, 0x30, 0xAA, 0x0A, 0x77, 0x30, 0x1B, 0x03, 0x77, 0x30, 0x8A, 0x0C,
  0x77, 0x40, 0xEA, 0x06, 0x77, 0x30, 0x5A, 0x0E, 0x77, 0x40, 0xCA, 0x08, 0x77, 0x30, 0x3B, 0x02,
  0x77, 0x30, 0x9A, 0x0B, 0x77, 0x30, 0x1B, 0x04, 0x77, 0x30, 0x7A, 0x0D, 0x77, 0x40, 0xDA, 0x07,
  0x77, 0x30, 0x4B, 0x01, 0x77, 0x30, 0xBA, 0x09, 0x77, 0x30, 0x2B, 0x03, 0x77, 0x30, 0x8A, 0x0C,
  0x77, 0x40, 0xEA, 0x05, 0x77, 0x30, 0x6A, 0x0E, 0x77, 0x40, 0xCA, 0x08, 0x77, 0x30, 0x3B, 0x01,
  0x77, 0x30, 0xAA, 0x0A, 0x77, 0x30, 0x1B, 0x04, 0x77, 0x30, 0x8A, 0x0D, 0x77, 0x40, 0xEA, 0x06,
  0x77, 0x30, 0x5A, 0x0E, 0x77, 0x40, 0xCA, 0x09, 0x77, 0x30, 0x3B, 0x02, 0x77, 0x30, 0x9A, 0x0B,
  0x77, 0x30, 0x10, 0xEA, 0x05, 0x77, 0x30, 0x7A, 0x0D, 0x77, 0x40, 0xDA, 0x07, 0x77, 0x30, 0x4B,
  0x01, 0x77, 0x30, 0xBA, 0x09, 0x77, 0x30, 0x2B, 0x03, 0x77, 0x30, 0x8A, 0x0C, 0x77, 0x40, 0xEA,
  0x05, 0x77, 0x30, 0x6A, 0x0E, 0x77, 0x40, 0xCA, 0x08, 0x77, 0x30, 0x3B, 0x02, 0x77, 0x30, 0xAA,
  0x0A, 0x77, 0x30, 0x1B, 0x04, 0x77, 0x30, 0x7A, 0x0D, 0x77, 0x40, 0xDA, 0x06, 0x77, 0x40,
  // "™" (U+2122)
  0x09, 0x80, 0x92, 0xE0, 0x40, 0x28, 0x01, 0xE0, 0xC7, 0x30, 0x18, 0x01, 0xE0, 0xC0, 0xBF, 0xF8,
  0x25, 0x2C, 0xEC, 0x02, 0x72, 0x06, 0xC8, 0x4D, 0xAB, 0xF9, 0x12, 0x0C, 0xA0, 0x42, 0x82, 0x2D,
  0xF6, 0x20, 0x10, 0xEB, 0x08, 0x72, 0x0B, 0xB0, 0xA2, 0x0B, 0x94, 0x0C, 0xA0, 0x43, 0x81, 0x6F,
  0x63, 0x0B, 0xB0, 0xD7, 0x10, 0x1C, 0x06, 0x20, 0x0C, 0x40, 0xCA, 0x04, 0x38, 0x12, 0xF7, 0x38,
  0x1B, 0xFE, 0xA0, 0x27, 0x81, 0x6F, 0xEA, 0x06, 0x20, 0x70, 0x64, 0x0C, 0xA0, 0x44, 0x09, 0x04,
  0x38, 0x1B, 0xE9, 0xA0, 0x87, 0x81, 0xBD, 0xBA, 0x06, 0x71, 0x0C, 0xA0, 0x47, 0x28, 0x1B, 0xE4,
  0xA0, 0xD6, 0x82, 0x1F, 0x7B, 0xA0, 0x67, 0x10, 0xCA, 0x04, 0x72, 0x82, 0xBE, 0x0E, 0xA0, 0x35,
  0x82, 0x7F, 0x2B, 0xA0, 0x67, 0x10, 0xCA, 0x04, 0x72, 0x82, 0xBE, 0x08, 0xA0, 0x85, 0x82, 0xCC,
  0x0B, 0xA0, 0x67, 0x10, 0xCA, 0x04, 0x72, 0x82, 0xBE, 0x03, 0xA0, 0xD4, 0x83, 0x2F, 0x70, 0xBA,
  0x06, 0x71, 0x0C, 0xA0, 0x47, 0x20, 0xB0, 0xE2, 0x0D, 0xA0, 0x33, 0x83, 0x7F, 0x20, 0xBA, 0x06,
  0x71, 0x0C, 0xA0, 0x47, 0x20, 0xB0, 0xE2, 0x08, 0xA0, 0x83, 0x00, 0xC2, 0x0B, 0xA0, 0x67, 0x10,
  0xCA, 0x04, 0x72, 0x0B, 0x0E, 0x20, 0x3A, 0x0D, 0x28, 0x12, 0xF6, 0x20, 0xBA, 0x06, 0x71, 0x0C,
  0xA0, 0x47, 0x20, 0xB0, 0xE3, 0x0D, 0xA8, 0x33, 0x07, 0xF1, 0x20, 0xBA, 0x06, 0x71, 0x0C, 0xA0,
  0x47, 0x20, 0xB0, 0xE3, 0x08, 0xA8, 0x28, 0x0D, 0xB3, 0x0B, 0xA0, 0x67, 0x10, 0xCA, 0x04, 0x72,
  0x0B, 0x0E, 0x30, 0x2A, 0x82, 0xD3, 0xF6, 0x30, 0xBA, 0x06, 0x71, 0x0C, 0xA0, 0x47, 0x20, 0xB0,
  0xE4, 0x0C, 0xA8, 0x1B, 0xF1, 0x30, 0xBA, 0x06, 0x71, 0x0C, 0xA0, 0x57, 0x20, 0xB9, 0x40, 0x7B,
  0x0B, 0x40, 0xBA, 0x06, 0x71, 0x0E, 0xA0, 0x87, 0x28, 0x1D, 0xF2, 0x30, 0x2B, 0x05, 0x40, 0xDA,
  0x09, 0x58, 0x15, 0xAD, 0xC8, 0x1B, 0x91, 0x38, 0x11, 0xAD, 0xA0, 0xE0, 0xA3, 0x0C, 0xA3, 0x07,
  0x0D, 0xC0, 0xB0, 0x83, 0x08, 0xF9, 0x02, 0x30, 0x2E, 0x38, 0x17, 0xFA, 0x30, 0xAE, 0x0D,
  // "⅒" (U+2152)
  0x60, 0x10, 0xAA, 0x0B, 0x77, 0x20, 0x4B, 0x01, 0x77, 0x77, 0x20, 0x20, 0xDB, 0x0B, 0x77, 0x20,
  0xAA, 0x0A, 0x77, 0x77, 0x20, 0x40, 0xEC, 0x0B, 0x77, 0x10, 0x1B, 0x03, 0x77, 0x77, 0x01, 0x09,
  0xE0, 0xB7, 0x71, 0x08, 0xA0, 0xC7, 0x77, 0x60, 0x50, 0xAB, 0x0B, 0x0A, 0xB0, 0xB7, 0x71, 0x0E,
  0xA0, 0x67, 0x77, 0x60, 0xAB, 0x81, 0xB0, 0xAB, 0x0B, 0x77, 0x05, 0xA0, 0xE7, 0x77, 0x78, 0x22,
  0xDE, 0x82, 0x0A, 0xB0, 0xB7, 0x70, 0xCA, 0x08, 0x77, 0x77, 0x60, 0xAB, 0x0B, 0x76, 0x03, 0xB0,
  0x27, 0x77, 0x76, 0x0A, 0xB0, 0xB7, 0x60, 0x9A, 0x0B, 0x77, 0x77, 0x70, 0xAB, 0x0B, 0x75, 0x01,
  0xB0, 0x47, 0x77, 0x77, 0x0A, 0xB0, 0xB7, 0x50, 0x7A, 0x0D, 0x80, 0xC0, 0x00, 0xAB, 0x0B, 0x75,
  0x0D, 0xA0, 0x78, 0x0C, 0x00, 0x0A, 0xB0, 0xB7, 0x40, 0x4B, 0x01, 0x80, 0xC0, 0x00, 0xAB, 0x0B,
  0x74, 0x0B, 0xA0, 0x98, 0x0C, 0x10, 0x0A, 0xB0, 0xB7, 0x30, 0x2B, 0x03, 0x80, 0xC1, 0x00, 0xAB,
  0x0B, 0x73, 0x08, 0xA0, 0xC8, 0x0C, 0x20, 0x0A, 0xB0, 0xB7, 0x30, 0xEA, 0x05, 0x77, 0x58, 0x62,
  0x8C, 0xEE, 0xDA, 0x47, 0x40, 0xAB, 0x0B, 0x72, 0x06, 0xA0, 0xE6, 0x01, 0x0A, 0xA0, 0xB7, 0x10,
  0x7F, 0x90, 0xA7, 0x30, 0xAB, 0x0B, 0x72, 0x0C, 0xA0, 0x85, 0x02, 0x0D, 0xB0, 0xB7, 0x07, 0xB8,
  0x2D, 0x65, 0x9B, 0x0B, 0x72, 0x0A, 0xB0, 0xB7, 0x10, 0x3B, 0x01, 0x40, 0x40, 0xEC, 0x0B, 0x60,
  0x3B, 0x0E, 0x01, 0x30, 0x8B, 0x07, 0x71, 0x0A, 0xB0, 0xB7, 0x10, 0xAA, 0x0A, 0x30, 0x10, 0x9E,
  0x0B, 0x60, 0xAB, 0x06, 0x50, 0xEA, 0x0E, 0x71, 0x0A, 0xB0, 0xB7, 0x01, 0xB8, 0x24, 0x05, 0xAB,
  0x0B, 0x0A, 0xB0, 0xB5, 0x01, 0xC0, 0x15, 0x0A, 0xB0, 0x67, 0x0C, 0xB0, 0xD7, 0x08, 0xA0, 0xD2,
  0x0A, 0xB8, 0x1B, 0x0A, 0xB0, 0xB5, 0x06, 0xB0, 0xD6, 0x06, 0xB0, 0xA2, 0x83, 0x34, 0x45, 0x9D,
  0x83, 0xA5, 0x44, 0x12, 0x0E, 0xA0, 0x62, 0x82, 0x2D, 0xE8, 0x20, 0xAB, 0x0B, 0x50, 0xAB, 0x0A,
  0x60, 0x4B, 0x0E, 0x20, 0xBF, 0xE8, 0x17, 0x05, 0xA0, 0xE7, 0x20, 0xAB, 0x0B, 0x50, 0xDB, 0x08,
  0x60, 0x2C, 0x81, 0x20, 0xBF, 0xE8, 0x17, 0x0C, 0xA0, 0x97, 0x20, 0xAB, 0x0B, 0x5C, 0x06, 0x7C,
  0x04, 0x77, 0x20, 0x3B, 0x02, 0x72, 0x0A, 0xB0, 0xB4, 0x02, 0xC0, 0x57, 0xC0, 0x77, 0x72, 0x09,
  0xA0, 0xB7, 0x30, 0xAB, 0x0B, 0x40, 0x2C, 0x05, 0x70, 0xEB, 0x07, 0x77, 0x10, 0x10, 0xEA, 0x05,
  0x73, 0x0A, 0xB0, 0xB4, 0x03, 0xC0, 0x47, 0x0E, 0xB0, 0x87, 0x71, 0x07, 0xA0, 0xD7, 0x40, 0xAB,
  0x0B, 0x40, 0x3C, 0x04, 0x70, 0xEB, 0x09, 0x77, 0x10, 0xDA, 0x07, 0x74, 0x0A, 0xB0, 0xB4, 0x03,
  0xC0, 0x47, 0x0E, 0xB0, 0x87, 0x70, 0x4B, 0x01, 0x74, 0x0A, 0xB0, 0xB4, 0x02, 0xC0, 0x57, 0x0E,
  0xB0, 0x77, 0x70, 0xBA, 0x09, 0x75, 0x0A, 0xB0, 0xB4, 0x01, 0xC0, 0x67, 0xC0, 0x67, 0x60, 0x2B,
  0x03, 0x75, 0x0A, 0xB0, 0xB5, 0xC0, 0x76, 0x01, 0xC0, 0x47, 0x60, 0x8A, 0x0C, 0x76, 0x0A, 0xB0,
  0xB5, 0x0C, 0xB0, 0x86, 0x02, 0xC0, 0x27, 0x60, 0xEA, 0x05, 0x76, 0x0A, 0xB0, 0xB5, 0x09, 0xB0,
  0xA6, 0x04, 0xB0, 0xE7, 0x60, 0x6A, 0x0E, 0x77, 0x0A, 0xB0, 0xB5, 0x05, 0xB0, 0xD6, 0x07, 0xB0,
  0xA7, 0x60, 0xCA, 0x08, 0x77, 0x0A, 0xB0, 0xB5, 0x01, 0xC0, 0x15, 0x0A, 0xB0, 0x57, 0x50, 0x3B,
  0x02, 0x77, 0x0A, 0xB0, 0xB6, 0x09, 0xB0, 0x75, 0x0E, 0xA0, 0xD7, 0x60, 0xAA, 0x0A, 0x77, 0x10,
  0xCB, 0x0D, 0x60, 0x2B, 0x0E, 0x01, 0x30, 0x8B, 0x06, 0x75, 0x01, 0xB0, 0x47, 0x38, 0x33, 0x44,
  0x59, 0xD8, 0x3A, 0x54, 0x41, 0x20, 0x7B, 0x82, 0xD6, 0x59, 0xB0, 0xB7, 0x60, 0x7A, 0x0D, 0x74,
  0x0B, 0xFE, 0x07, 0x30, 0x6F, 0x90, 0xA7, 0x70, 0xDA, 0x06, 0x74, 0x0B, 0xFE, 0x07, 0x48, 0x62,
  0x8C, 0xEF, 0xDA, 0x45,
  // "ﬁ" (U+FB01)
  0x75, 0x83, 0x38, 0xBD, 0xEA, 0x83, 0xED, 0xB8, 0x47, 0x75, 0x04, 0x0C, 0xFD, 0x0D, 0x05, 0x77,
  0x20, 0x9F, 0xFA, 0x08, 0x77, 0x0A, 0xD8, 0x59, 0x42, 0x13, 0x6D, 0xE0, 0x47, 0x50, 0x8C, 0x0E,
  0x03, 0x60, 0x10, 0xCD, 0x0A, 0x74, 0x02, 0xD0, 0x67, 0x10, 0x10, 0xEC, 0x0B, 0x74, 0x09, 0xC0,
  0xC7, 0x30, 0x9C, 0x09, 0x74, 0x0E, 0xC0, 0x67, 0x30, 0x4C, 0x02, 0x73, 0x04, 0xD0, 0x17, 0x30,
  0x2A, 0x0C, 0x03, 0x74, 0x08, 0xC0, 0xD7, 0x50, 0x30, 0x17, 0x60, 0xAC, 0x0B, 0x77, 0x76, 0x0B,
  0xC0, 0x97, 0x77, 0x60, 0xCC, 0x08, 0x77, 0x76, 0x0C, 0xC0, 0x87, 0x77, 0x60, 0xCC, 0x08, 0x77,
  0x71, 0x07, 0xFF, 0xFE, 0x05, 0x40, 0x7F, 0xFF, 0xE0, 0x54, 0x07, 0xFF, 0xFE, 0x05, 0x58, 0x00,
  0x10, 0xCC, 0x08, 0x80, 0x71, 0x02, 0xD0, 0x57, 0x20, 0xCC, 0x08, 0x74, 0x01, 0xD0, 0x57, 0x20,
  0xCC, 0x08, 0x74, 0x01, 0xD0, 0x57, 0x20, 0xCC, 0x08, 0x74, 0x01, 0xD0, 0x57, 0x20, 0xCC, 0x08,
  0x74, 0x01, 0xD0, 0x57, 0x20, 0xCC, 0x08, 0x74, 0x01, 0xD0, 0x57, 0x20, 0xCC, 0x08, 0x74, 0x01,
  0xD0, 0x57, 0x20, 0xCC, 0x08, 0x74, 0x01, 0xD0, 0x57, 0x20, 0xCC, 0x08, 0x74, 0x01, 0xD0, 0x57,
  0x20, 0xCC, 0x08, 0x74, 0x01, 0xD0, 0x57, 0x20, 0xCC, 0x08, 0x74, 0x01, 0xD0, 0x57, 0x20, 0xCC,
  0x08, 0x74, 0x01, 0xD0, 0x57, 0x20, 0xCC, 0x08, 0x74, 0x01, 0xD0, 0x57, 0x20, 0xCC, 0x08, 0x74,
  0x01, 0xD0, 0x57, 0x20, 0xCC, 0x08, 0x74, 0x01, 0xD0, 0x57, 0x20, 0xCC, 0x08, 0x74, 0x01, 0xD0,
  0x57, 0x20, 0xCC, 0x08, 0x74, 0x01, 0xD0, 0x57, 0x20, 0xCC, 0x08, 0x74, 0x01, 0xD0, 0x57, 0x20,
  0xCC, 0x08, 0x74, 0x01, 0xD0, 0x57, 0x20, 0xCC, 0x08, 0x74, 0x01, 0xD0, 0x57, 0x20, 0xCC, 0x08,
  0x74, 0x01, 0xD0, 0x57, 0x20, 0xCC, 0x08, 0x74, 0x01, 0xD0, 0x57, 0x20, 0xDC, 0x08, 0x74, 0x01,
  0xD0, 0x67, 0x2D, 0x0A, 0x74, 0x03, 0xD0, 0x87, 0x10, 0x6E, 0x02, 0x73, 0x08, 0xD0, 0xD5, 0x81,
  0x24, 0x9F, 0x82, 0xE7, 0x31, 0x48, 0x11, 0x39, 0xF8, 0x3C, 0x52, 0x1A, 0xFF, 0x07, 0x20, 0x4F,
  0xF0, 0xAF, 0xF0, 0x72, 0x04, 0xFF, 0x0A, 0xFF, 0x07, 0x20, 0x4F, 0xF0,
  // "ﬂ" (U+FB02)
  0x75, 0x89, 0x03, 0x7B, 0xDE, 0xFE, 0xC8, 0x47, 0x77, 0x05, 0x0D, 0xFF, 0xA0, 0x47, 0x60, 0xAF,
  0xFC, 0x04, 0x75, 0x0B, 0xD8, 0x59, 0x42, 0x12, 0x6C, 0xF0, 0x47, 0x40, 0x7C, 0x0E, 0x03, 0x70,
  0x9E, 0x04, 0x73, 0x02, 0xD0, 0x67, 0x20, 0xDD, 0x04, 0x73, 0x09, 0xC0, 0xB7, 0x30, 0x7D, 0x04,
  0x73, 0x0E, 0xC0, 0x67, 0x30, 0x4D, 0x04, 0x72, 0x04, 0xD0, 0x17, 0x30, 0x2D, 0x04, 0x72, 0x07,
  0xC0, 0xD7, 0x40, 0x1D, 0x04, 0x72, 0x0A, 0xC0, 0xA7, 0x40, 0x1D, 0x04, 0x72, 0x0B, 0xC0, 0x97,
  0x40, 0x1D, 0x04, 0x72, 0x0C, 0xC0, 0x87, 0x40, 0x1D, 0x04, 0x72, 0x0C, 0xC0, 0x87, 0x40, 0x1D,
  0x04, 0x72, 0x0C, 0xC0, 0x87, 0x40, 0x1D, 0x04, 0x40, 0x7F, 0xFA, 0x0E, 0x40, 0x1D, 0x04, 0x40,
  0x7F, 0xFA, 0x0E, 0x40, 0x1D, 0x04, 0x40, 0x7F, 0xFA, 0x0E, 0x40, 0x1D, 0x04, 0x58, 0x00, 0x10,
  0xCC, 0x08, 0x80, 0x31, 0x40, 0x1D, 0x04, 0x72, 0x0C, 0xC0, 0x87, 0x40, 0x1D, 0x04, 0x72, 0x0C,
  0xC0, 0x87, 0x40, 0x1D, 0x04, 0x72, 0x0C, 0xC0, 0x87, 0x40, 0x1D, 0x04, 0x72, 0x0C, 0xC0, 0x87,
  0x40, 0x1D, 0x04, 0x72, 0x0C, 0xC0, 0x87, 0x40, 0x1D, 0x04, 0x72, 0x0C, 0xC0, 0x87, 0x40, 0x1D,
  0x04, 0x72, 0x0C, 0xC0, 0x87, 0x40, 0x1D, 0x04, 0x72, 0x0C, 0xC0, 0x87, 0x40, 0x1D, 0x04, 0x72,
  0x0C, 0xC0, 0x87, 0x40, 0x1D, 0x04, 0x72, 0x0C, 0xC0, 0x87, 0x40, 0x1D, 0x04, 0x72, 0x0C, 0xC0,
  0x87, 0x40, 0x1D, 0x04, 0x72, 0x0C, 0xC0, 0x87, 0x40, 0x1D, 0x04, 0x72, 0x0C, 0xC0, 0x87, 0x40,
  0x1D, 0x04, 0x72, 0x0C, 0xC0, 0x87, 0x40, 0x1D, 0x04, 0x72, 0x0C, 0xC0, 0x87, 0x40, 0x1D, 0x04,
  0x72, 0x0C, 0xC0, 0x87, 0x40, 0x1D, 0x04, 0x72, 0x0C, 0xC0, 0x87, 0x40, 0x1D, 0x04, 0x72, 0x0C,
  0xC0, 0x87, 0x40, 0x1D, 0x04, 0x72, 0x0C, 0xC0, 0x87, 0x40, 0x1D, 0x04, 0x72, 0x0C, 0xC0, 0x87,
  0x40, 0x1D, 0x04, 0x72, 0x0C, 0xC0, 0x87, 0x40, 0x2D, 0x04, 0x72, 0x0D, 0xC0, 0x87, 0x40, 0x2D,
  0x05, 0x72, 0xD0, 0xA7, 0x40, 0x5D, 0x07, 0x71, 0x06, 0xE0, 0x27, 0x30, 0xBD, 0x0D, 0x58, 0x12,
  0x49, 0xF8, 0x2E, 0x73, 0x14, 0x81, 0x25, 0xBF, 0x83, 0xC5, 0x21, 0xAF, 0xF0, 0x82, 0x06, 0xFF,
  0x0A, 0xFF, 0x08, 0x20, 0x6F, 0xF0, 0xAF, 0xF0, 0x82, 0x06, 0xFF,
};

const Font& font_NotoSerif_Condensed_60() {
  static SmoothFont font(font_NotoSerif_Condensed_60_data);
  return font;
}

}  // namespace roo_display
