#include "18.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSerif-Condensed (Noto Serif Condensed)
// Generated on Wed Nov 19 19:11:48 CET 2025
static const uint8_t font_NotoSerif_Condensed_18_data[] PROGMEM = {
  
  // Header
  0x01, 0x02, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x08, 0xC2,
  0xFD, 0xFC, 0x13, 0x12, 0x0E, 0xFC, 0x05, 0x01, 0x14, 0x06, 0x05, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x41, 0x01, 0x03, 0x0D, 0x05, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x41, 0x0A, 0x05, 0x0D, 0x07, 0x00, 0x14, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x08, 0x0D, 0x09, 0x00, 0x1E, // "#" (U+0023)
  0x00, 0x24, 0x00, 0xFF, 0x07, 0x0E, 0x09, 0x00, 0x56, // "$" (U+0024)
  0x00, 0x25, 0x00, 0x01, 0x0D, 0x0D, 0x0E, 0x00, 0x91, // "%" (U+0025)
  0x00, 0x26, 0x00, 0x01, 0x0B, 0x0D, 0x0C, 0x00, 0xE9, // "&" (U+0026)
  0x00, 0x27, 0x41, 0x0A, 0x02, 0x0D, 0x04, 0x01, 0x34, // "'" (U+0027)
  0x00, 0x28, 0x40, 0xFE, 0x04, 0x0E, 0x05, 0x01, 0x38, // "(" (U+0028)
  0x00, 0x29, 0x40, 0xFE, 0x04, 0x0E, 0x05, 0x01, 0x63, // ")" (U+0029)
  0x00, 0x2A, 0x40, 0x08, 0x06, 0x0E, 0x07, 0x01, 0x8E, // "*" (U+002A)
  0x00, 0x2B, 0x00, 0x04, 0x07, 0x0B, 0x08, 0x01, 0xA7, // "+" (U+002B)
  0x00, 0x2C, 0x40, 0xFE, 0x02, 0x02, 0x04, 0x01, 0xBF, // "," (U+002C)
  0x00, 0x2D, 0x40, 0x05, 0x04, 0x05, 0x05, 0x01, 0xC7, // "-" (U+002D)
  0x00, 0x2E, 0x41, 0x01, 0x02, 0x02, 0x04, 0x01, 0xCA, // "." (U+002E)
  0x00, 0x2F, 0x00, 0xFF, 0x04, 0x0E, 0x04, 0x01, 0xCC, // "/" (U+002F)
  0x00, 0x30, 0x40, 0x01, 0x07, 0x0D, 0x09, 0x01, 0xF1, // "0" (U+0030)
  0x00, 0x31, 0x01, 0x01, 0x07, 0x0D, 0x09, 0x02, 0x25, // "1" (U+0031)
  0x00, 0x32, 0x00, 0x01, 0x07, 0x0D, 0x09, 0x02, 0x50, // "2" (U+0032)
  0x00, 0x33, 0x00, 0x01, 0x07, 0x0D, 0x09, 0x02, 0x80, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x01, 0x08, 0x0D, 0x09, 0x02, 0xB3, // "4" (U+0034)
  0x00, 0x35, 0x00, 0x01, 0x07, 0x0D, 0x09, 0x02, 0xE6, // "5" (U+0035)
  0x00, 0x36, 0x40, 0x01, 0x07, 0x0D, 0x09, 0x03, 0x16, // "6" (U+0036)
  0x00, 0x37, 0x00, 0x01, 0x07, 0x0D, 0x09, 0x03, 0x4A, // "7" (U+0037)
  0x00, 0x38, 0x40, 0x01, 0x07, 0x0D, 0x09, 0x03, 0x73, // "8" (U+0038)
  0x00, 0x39, 0x40, 0x01, 0x07, 0x0D, 0x09, 0x03, 0xA7, // "9" (U+0039)
  0x00, 0x3A, 0x01, 0x01, 0x03, 0x0A, 0x04, 0x03, 0xDB, // ":" (U+003A)
  0x00, 0x3B, 0x00, 0xFE, 0x03, 0x0A, 0x04, 0x03, 0xE5, // ";" (U+003B)
  0x00, 0x3C, 0x00, 0x03, 0x07, 0x0B, 0x08, 0x03, 0xF9, // "<" (U+003C)
  0x00, 0x3D, 0x00, 0x05, 0x07, 0x09, 0x08, 0x04, 0x15, // "=" (U+003D)
  0x00, 0x3E, 0x00, 0x03, 0x07, 0x0B, 0x08, 0x04, 0x1F, // ">" (U+003E)
  0x00, 0x3F, 0x00, 0x01, 0x06, 0x0D, 0x08, 0x04, 0x3B, // "?" (U+003F)
  0x00, 0x40, 0x01, 0xFE, 0x0D, 0x0D, 0x0E, 0x04, 0x5F, // "@" (U+0040)
  0x00, 0x41, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x04, 0xC3, // "A" (U+0041)
  0x00, 0x42, 0x00, 0x01, 0x09, 0x0D, 0x0A, 0x04, 0xFF, // "B" (U+0042)
  0x00, 0x43, 0x00, 0x01, 0x08, 0x0D, 0x0A, 0x05, 0x3E, // "C" (U+0043)
  0x00, 0x44, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x05, 0x70, // "D" (U+0044)
  0x00, 0x45, 0x00, 0x01, 0x08, 0x0D, 0x0A, 0x05, 0xB2, // "E" (U+0045)
  0x00, 0x46, 0x00, 0x01, 0x08, 0x0D, 0x09, 0x05, 0xE1, // "F" (U+0046)
  0x00, 0x47, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x06, 0x0A, // "G" (U+0047)
  0x00, 0x48, 0x00, 0x01, 0x0B, 0x0D, 0x0C, 0x06, 0x48, // "H" (U+0048)
  0x00, 0x49, 0x00, 0x01, 0x05, 0x0D, 0x06, 0x06, 0x8C, // "I" (U+0049)
  0x00, 0x4A, 0xFF, 0xFD, 0x05, 0x0D, 0x06, 0x06, 0xA9, // "J" (U+004A)
  0x00, 0x4B, 0x00, 0x01, 0x0B, 0x0D, 0x0B, 0x06, 0xD7, // "K" (U+004B)
  0x00, 0x4C, 0x00, 0x01, 0x08, 0x0D, 0x0A, 0x07, 0x17, // "L" (U+004C)
  0x00, 0x4D, 0x00, 0x01, 0x0D, 0x0D, 0x0E, 0x07, 0x3E, // "M" (U+004D)
  0x00, 0x4E, 0x00, 0x01, 0x0B, 0x0D, 0x0C, 0x07, 0x96, // "N" (U+004E)
  0x00, 0x4F, 0x00, 0x01, 0x0A, 0x0D, 0x0C, 0x07, 0xD9, // "O" (U+004F)
  0x00, 0x50, 0x00, 0x01, 0x08, 0x0D, 0x09, 0x08, 0x19, // "P" (U+0050)
  0x00, 0x51, 0x00, 0xFD, 0x0A, 0x0D, 0x0C, 0x08, 0x4B, // "Q" (U+0051)
  0x00, 0x52, 0x00, 0x01, 0x0A, 0x0D, 0x0A, 0x08, 0x98, // "R" (U+0052)
  0x00, 0x53, 0x00, 0x01, 0x07, 0x0D, 0x08, 0x08, 0xD8, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x09, 0x0D, 0x0A, 0x09, 0x0A, // "T" (U+0054)
  0x00, 0x55, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x09, 0x3C, // "U" (U+0055)
  0x00, 0x56, 0x00, 0x01, 0x0A, 0x0D, 0x0A, 0x09, 0x82, // "V" (U+0056)
  0x00, 0x57, 0x00, 0x01, 0x0F, 0x0D, 0x10, 0x09, 0xBC, // "W" (U+0057)
  0x00, 0x58, 0x00, 0x01, 0x0A, 0x0D, 0x0A, 0x0A, 0x1D, // "X" (U+0058)
  0x00, 0x59, 0xFF, 0x01, 0x09, 0x0D, 0x0A, 0x0A, 0x59, // "Y" (U+0059)
  0x00, 0x5A, 0x00, 0x01, 0x08, 0x0D, 0x09, 0x0A, 0x8E, // "Z" (U+005A)
  0x00, 0x5B, 0x41, 0xFE, 0x05, 0x0E, 0x06, 0x0A, 0xC0, // "[" (U+005B)
  0x00, 0x5C, 0x00, 0xFF, 0x04, 0x0E, 0x04, 0x0A, 0xEB, // "\" (U+005C)
  0x00, 0x5D, 0x40, 0xFE, 0x04, 0x0E, 0x06, 0x0B, 0x0F, // "]" (U+005D)
  0x00, 0x5E, 0x00, 0x06, 0x07, 0x0D, 0x08, 0x0B, 0x3A, // "^" (U+005E)
  0x00, 0x5F, 0xFF, 0xFE, 0x07, 0xFE, 0x07, 0x0B, 0x58, // "_" (U+005F)
  0x00, 0x60, 0x40, 0x0C, 0x03, 0x0E, 0x05, 0x0B, 0x5C, // "`" (U+0060)
  0x00, 0x61, 0x40, 0x01, 0x08, 0x0A, 0x09, 0x0B, 0x62, // "a" (U+0061)
  0x00, 0x62, 0x00, 0x01, 0x08, 0x0E, 0x0A, 0x0B, 0x8F, // "b" (U+0062)
  0x00, 0x63, 0x00, 0x01, 0x06, 0x0A, 0x08, 0x0B, 0xCB, // "c" (U+0063)
  0x00, 0x64, 0x00, 0x01, 0x09, 0x0E, 0x0A, 0x0B, 0xEC, // "d" (U+0064)
  0x00, 0x65, 0x40, 0x01, 0x07, 0x0A, 0x08, 0x0C, 0x2C, // "e" (U+0065)
  0x00, 0x66, 0x00, 0x01, 0x06, 0x0E, 0x06, 0x0C, 0x54, // "f" (U+0066)
  0x00, 0x67, 0x40, 0xFD, 0x07, 0x0A, 0x08, 0x0C, 0x83, // "g" (U+0067)
  0x00, 0x68, 0x00, 0x01, 0x09, 0x0E, 0x0A, 0x0C, 0xBB, // "h" (U+0068)
  0x00, 0x69, 0x40, 0x01, 0x04, 0x0E, 0x05, 0x0D, 0x00, // "i" (U+0069)
  0x00, 0x6A, 0xBF, 0xFD, 0x03, 0x0E, 0x05, 0x0D, 0x23, // "j" (U+006A)
  0x00, 0x6B, 0x00, 0x01, 0x09, 0x0E, 0x09, 0x0D, 0x50, // "k" (U+006B)
  0x00, 0x6C, 0x40, 0x01, 0x04, 0x0E, 0x05, 0x0D, 0x8C, // "l" (U+006C)
  0x00, 0x6D, 0x40, 0x01, 0x0E, 0x0A, 0x0F, 0x0D, 0xAF, // "m" (U+006D)
  0x00, 0x6E, 0x40, 0x01, 0x09, 0x0A, 0x0A, 0x0D, 0xFA, // "n" (U+006E)
  0x00, 0x6F, 0x40, 0x01, 0x08, 0x0A, 0x09, 0x0E, 0x2C, // "o" (U+006F)
  0x00, 0x70, 0x00, 0xFD, 0x08, 0x0A, 0x0A, 0x0E, 0x59, // "p" (U+0070)
  0x00, 0x71, 0x00, 0xFD, 0x09, 0x0A, 0x0A, 0x0E, 0x96, // "q" (U+0071)
  0x00, 0x72, 0x00, 0x01, 0x07, 0x0A, 0x07, 0x0E, 0xD7, // "r" (U+0072)
  0x00, 0x73, 0x40, 0x01, 0x06, 0x0A, 0x07, 0x0E, 0xFA, // "s" (U+0073)
  0x00, 0x74, 0x40, 0x01, 0x05, 0x0C, 0x06, 0x0F, 0x1D, // "t" (U+0074)
  0x00, 0x75, 0x40, 0x01, 0x09, 0x0A, 0x0A, 0x0F, 0x41, // "u" (U+0075)
  0x00, 0x76, 0x00, 0x01, 0x08, 0x0A, 0x09, 0x0F, 0x73, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x01, 0x0D, 0x0A, 0x0D, 0x0F, 0x9E, // "w" (U+0077)
  0x00, 0x78, 0x00, 0x01, 0x08, 0x0A, 0x09, 0x0F, 0xE1, // "x" (U+0078)
  0x00, 0x79, 0x00, 0xFD, 0x08, 0x0A, 0x09, 0x10, 0x0C, // "y" (U+0079)
  0x00, 0x7A, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x10, 0x43, // "z" (U+007A)
  0x00, 0x7B, 0x40, 0xFE, 0x05, 0x0E, 0x07, 0x10, 0x69, // "{" (U+007B)
  0x00, 0x7C, 0x43, 0xFD, 0x04, 0x0E, 0x09, 0x10, 0x9C, // "|" (U+007C)
  0x00, 0x7D, 0x00, 0xFE, 0x05, 0x0E, 0x07, 0x10, 0xAE, // "}" (U+007D)
  0x00, 0x7E, 0x40, 0x06, 0x07, 0x08, 0x08, 0x10, 0xDF, // "~" (U+007E)
  0x00, 0xA1, 0x41, 0xFE, 0x03, 0x0A, 0x05, 0x10, 0xEB, // "¡" (U+00A1)
  0x00, 0xA2, 0x41, 0x01, 0x07, 0x0D, 0x09, 0x10, 0xFF, // "¢" (U+00A2)
  0x00, 0xA3, 0x00, 0x01, 0x08, 0x0D, 0x09, 0x11, 0x2D, // "£" (U+00A3)
  0x00, 0xA4, 0x41, 0x03, 0x07, 0x0B, 0x09, 0x11, 0x5F, // "¤" (U+00A4)
  0x00, 0xA5, 0x00, 0x01, 0x08, 0x0D, 0x09, 0x11, 0x7F, // "¥" (U+00A5)
  0x00, 0xA6, 0x43, 0xFD, 0x04, 0x0E, 0x09, 0x11, 0xB4, // "¦" (U+00A6)
  0x00, 0xA7, 0x41, 0xFF, 0x07, 0x0E, 0x08, 0x11, 0xC6, // "§" (U+00A7)
  0x00, 0xA8, 0x42, 0x0D, 0x06, 0x0E, 0x09, 0x11, 0xFE, // "¨" (U+00A8)
  0x00, 0xA9, 0x00, 0x01, 0x0C, 0x0E, 0x0D, 0x12, 0x03, // "©" (U+00A9)
  0x00, 0xAA, 0x40, 0x08, 0x05, 0x0D, 0x06, 0x12, 0x58, // "ª" (U+00AA)
  0x00, 0xAB, 0x41, 0x02, 0x06, 0x08, 0x08, 0x12, 0x6A, // "«" (U+00AB)
  0x00, 0xAC, 0x00, 0x03, 0x07, 0x07, 0x08, 0x12, 0x7F, // "¬" (U+00AC)
  0x00, 0xAE, 0x40, 0x01, 0x0C, 0x0E, 0x0D, 0x12, 0x8D, // "®" (U+00AE)
  0x00, 0xAF, 0xFF, 0x0F, 0x07, 0x0F, 0x07, 0x12, 0xE8, // "¯" (U+00AF)
  0x00, 0xB0, 0x40, 0x09, 0x05, 0x0E, 0x06, 0x12, 0xEC, // "°" (U+00B0)
  0x00, 0xB1, 0x00, 0x01, 0x07, 0x0B, 0x08, 0x12, 0xFE, // "±" (U+00B1)
  0x00, 0xB2, 0x40, 0x07, 0x05, 0x0F, 0x06, 0x13, 0x1B, // "²" (U+00B2)
  0x00, 0xB3, 0x40, 0x08, 0x05, 0x0F, 0x06, 0x13, 0x36, // "³" (U+00B3)
  0x00, 0xB4, 0x40, 0x0C, 0x03, 0x0E, 0x05, 0x13, 0x4E, // "´" (U+00B4)
  0x00, 0xB5, 0x41, 0xFD, 0x08, 0x0A, 0x0A, 0x13, 0x54, // "µ" (U+00B5)
  0x00, 0xB6, 0x00, 0xFF, 0x08, 0x0E, 0x0A, 0x13, 0x8C, // "¶" (U+00B6)
  0x00, 0xB7, 0x41, 0x06, 0x02, 0x07, 0x04, 0x13, 0xCD, // "·" (U+00B7)
  0x00, 0xB8, 0x40, 0xFD, 0x03, 0x01, 0x05, 0x13, 0xCF, // "¸" (U+00B8)
  0x00, 0xB9, 0x00, 0x08, 0x05, 0x10, 0x06, 0x13, 0xD9, // "¹" (U+00B9)
  0x00, 0xBA, 0x40, 0x08, 0x05, 0x0D, 0x06, 0x13, 0xF1, // "º" (U+00BA)
  0x00, 0xBB, 0x41, 0x02, 0x06, 0x08, 0x08, 0x14, 0x03, // "»" (U+00BB)
  0x00, 0xBC, 0xFF, 0x01, 0x0C, 0x0E, 0x0D, 0x14, 0x18, // "¼" (U+00BC)
  0x00, 0xBD, 0x00, 0x00, 0x0C, 0x0E, 0x0D, 0x14, 0x68, // "½" (U+00BD)
  0x00, 0xBE, 0x00, 0x01, 0x0C, 0x0D, 0x0D, 0x14, 0xB9, // "¾" (U+00BE)
  0x00, 0xBF, 0x01, 0xFE, 0x07, 0x0A, 0x08, 0x15, 0x0A, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x0A, 0x11, 0x0B, 0x15, 0x30, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x0A, 0x11, 0x0B, 0x15, 0x77, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x01, 0x0A, 0x11, 0x0B, 0x15, 0xBE, // "Â" (U+00C2)
  0x00, 0xC3, 0x00, 0x01, 0x0A, 0x10, 0x0B, 0x16, 0x06, // "Ã" (U+00C3)
  0x00, 0xC4, 0x00, 0x01, 0x0A, 0x11, 0x0B, 0x16, 0x4C, // "Ä" (U+00C4)
  0x00, 0xC5, 0x00, 0x01, 0x0A, 0x10, 0x0B, 0x16, 0x92, // "Å" (U+00C5)
  0x00, 0xC6, 0x00, 0x01, 0x0E, 0x0D, 0x0F, 0x16, 0xD9, // "Æ" (U+00C6)
  0x00, 0xC7, 0x00, 0xFD, 0x08, 0x0D, 0x0A, 0x17, 0x29, // "Ç" (U+00C7)
  0x00, 0xC8, 0x00, 0x01, 0x08, 0x11, 0x0A, 0x17, 0x67, // "È" (U+00C8)
  0x00, 0xC9, 0x00, 0x01, 0x08, 0x11, 0x0A, 0x17, 0x9F, // "É" (U+00C9)
  0x00, 0xCA, 0x00, 0x01, 0x08, 0x11, 0x0A, 0x17, 0xD7, // "Ê" (U+00CA)
  0x00, 0xCB, 0x00, 0x01, 0x08, 0x11, 0x0A, 0x18, 0x12, // "Ë" (U+00CB)
  0x00, 0xCC, 0x00, 0x01, 0x05, 0x11, 0x06, 0x18, 0x4A, // "Ì" (U+00CC)
  0x00, 0xCD, 0x00, 0x01, 0x05, 0x11, 0x06, 0x18, 0x70, // "Í" (U+00CD)
  0x00, 0xCE, 0x00, 0x01, 0x05, 0x11, 0x06, 0x18, 0x97, // "Î" (U+00CE)
  0x00, 0xCF, 0x00, 0x01, 0x05, 0x11, 0x06, 0x18, 0xBF, // "Ï" (U+00CF)
  0x00, 0xD0, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x18, 0xE4, // "Ð" (U+00D0)
  0x00, 0xD1, 0x00, 0x01, 0x0B, 0x10, 0x0C, 0x19, 0x27, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x00, 0x01, 0x0A, 0x11, 0x0C, 0x19, 0x74, // "Ò" (U+00D2)
  0x00, 0xD3, 0x00, 0x01, 0x0A, 0x11, 0x0C, 0x19, 0xBE, // "Ó" (U+00D3)
  0x00, 0xD4, 0x00, 0x01, 0x0A, 0x11, 0x0C, 0x1A, 0x08, // "Ô" (U+00D4)
  0x00, 0xD5, 0x00, 0x01, 0x0A, 0x10, 0x0C, 0x1A, 0x54, // "Õ" (U+00D5)
  0x00, 0xD6, 0x00, 0x01, 0x0A, 0x11, 0x0C, 0x1A, 0x9E, // "Ö" (U+00D6)
  0x00, 0xD7, 0x41, 0x03, 0x07, 0x0A, 0x08, 0x1A, 0xE7, // "×" (U+00D7)
  0x00, 0xD8, 0x00, 0x00, 0x0A, 0x0E, 0x0C, 0x1B, 0x03, // "Ø" (U+00D8)
  0x00, 0xD9, 0x00, 0x01, 0x0A, 0x11, 0x0B, 0x1B, 0x53, // "Ù" (U+00D9)
  0x00, 0xDA, 0x00, 0x01, 0x0A, 0x11, 0x0B, 0x1B, 0xA4, // "Ú" (U+00DA)
  0x00, 0xDB, 0x00, 0x01, 0x0A, 0x11, 0x0B, 0x1B, 0xF5, // "Û" (U+00DB)
  0x00, 0xDC, 0x00, 0x01, 0x0A, 0x11, 0x0B, 0x1C, 0x47, // "Ü" (U+00DC)
  0x00, 0xDD, 0xFF, 0x01, 0x09, 0x11, 0x0A, 0x1C, 0x97, // "Ý" (U+00DD)
  0x00, 0xDE, 0x00, 0x01, 0x08, 0x0D, 0x09, 0x1C, 0xD6, // "Þ" (U+00DE)
  0x00, 0xDF, 0x40, 0x01, 0x09, 0x0E, 0x0A, 0x1D, 0x07, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x1D, 0x4D, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x1D, 0x87, // "á" (U+00E1)
  0x00, 0xE2, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x1D, 0xC1, // "â" (U+00E2)
  0x00, 0xE3, 0x00, 0x01, 0x08, 0x0D, 0x09, 0x1D, 0xFD, // "ã" (U+00E3)
  0x00, 0xE4, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x1E, 0x37, // "ä" (U+00E4)
  0x00, 0xE5, 0x00, 0x01, 0x08, 0x0F, 0x09, 0x1E, 0x71, // "å" (U+00E5)
  0x00, 0xE6, 0x40, 0x01, 0x0C, 0x0A, 0x0D, 0x1E, 0xB0, // "æ" (U+00E6)
  0x00, 0xE7, 0x00, 0xFD, 0x06, 0x0A, 0x08, 0x1E, 0xF1, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x1F, 0x1D, // "è" (U+00E8)
  0x00, 0xE9, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x1F, 0x4E, // "é" (U+00E9)
  0x00, 0xEA, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x1F, 0x7F, // "ê" (U+00EA)
  0x00, 0xEB, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x1F, 0xB2, // "ë" (U+00EB)
  0x00, 0xEC, 0x40, 0x01, 0x04, 0x0E, 0x05, 0x1F, 0xE3, // "ì" (U+00EC)
  0x00, 0xED, 0x40, 0x01, 0x04, 0x0E, 0x05, 0x20, 0x06, // "í" (U+00ED)
  0x00, 0xEE, 0xFF, 0x01, 0x04, 0x0E, 0x05, 0x20, 0x29, // "î" (U+00EE)
  0x00, 0xEF, 0x40, 0x01, 0x04, 0x0E, 0x05, 0x20, 0x52, // "ï" (U+00EF)
  0x00, 0xF0, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x20, 0x75, // "ð" (U+00F0)
  0x00, 0xF1, 0x40, 0x01, 0x09, 0x0D, 0x0A, 0x20, 0xB1, // "ñ" (U+00F1)
  0x00, 0xF2, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x20, 0xF2, // "ò" (U+00F2)
  0x00, 0xF3, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x21, 0x29, // "ó" (U+00F3)
  0x00, 0xF4, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x21, 0x5F, // "ô" (U+00F4)
  0x00, 0xF5, 0x00, 0x01, 0x08, 0x0D, 0x09, 0x21, 0x98, // "õ" (U+00F5)
  0x00, 0xF6, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x21, 0xCF, // "ö" (U+00F6)
  0x00, 0xF7, 0x00, 0x03, 0x07, 0x0B, 0x08, 0x22, 0x06, // "÷" (U+00F7)
  0x00, 0xF8, 0x40, 0x00, 0x08, 0x0B, 0x09, 0x22, 0x17, // "ø" (U+00F8)
  0x00, 0xF9, 0x00, 0x01, 0x09, 0x0E, 0x0A, 0x22, 0x4D, // "ù" (U+00F9)
  0x00, 0xFA, 0x00, 0x01, 0x09, 0x0E, 0x0A, 0x22, 0x92, // "ú" (U+00FA)
  0x00, 0xFB, 0x40, 0x01, 0x09, 0x0E, 0x0A, 0x22, 0xD6, // "û" (U+00FB)
  0x00, 0xFC, 0x00, 0x01, 0x09, 0x0E, 0x0A, 0x23, 0x1C, // "ü" (U+00FC)
  0x00, 0xFD, 0x00, 0xFD, 0x08, 0x0E, 0x09, 0x23, 0x61, // "ý" (U+00FD)
  0x00, 0xFE, 0x00, 0xFD, 0x08, 0x0E, 0x0A, 0x23, 0xA1, // "þ" (U+00FE)
  0x00, 0xFF, 0x00, 0xFD, 0x08, 0x0E, 0x09, 0x23, 0xE9, // "ÿ" (U+00FF)
  0x01, 0x00, 0x00, 0x01, 0x0A, 0x0F, 0x0B, 0x24, 0x29, // "Ā" (U+0100)
  0x01, 0x01, 0x40, 0x01, 0x08, 0x0C, 0x09, 0x24, 0x6B, // "ā" (U+0101)
  0x01, 0x02, 0x00, 0x01, 0x0A, 0x11, 0x0B, 0x24, 0xA1, // "Ă" (U+0102)
  0x01, 0x03, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x24, 0xEA, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0xFD, 0x0A, 0x0D, 0x0B, 0x25, 0x27, // "Ą" (U+0104)
  0x01, 0x05, 0x00, 0xFD, 0x08, 0x0A, 0x09, 0x25, 0x70, // "ą" (U+0105)
  0x01, 0x06, 0x00, 0x01, 0x08, 0x11, 0x0A, 0x25, 0xAD, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x01, 0x06, 0x0E, 0x08, 0x25, 0xE8, // "ć" (U+0107)
  0x01, 0x08, 0x00, 0x01, 0x08, 0x11, 0x0A, 0x26, 0x12, // "Ĉ" (U+0108)
  0x01, 0x09, 0x00, 0x01, 0x06, 0x0E, 0x08, 0x26, 0x4F, // "ĉ" (U+0109)
  0x01, 0x0A, 0x00, 0x01, 0x08, 0x12, 0x0A, 0x26, 0x7C, // "Ċ" (U+010A)
  0x01, 0x0B, 0x00, 0x01, 0x06, 0x0F, 0x08, 0x26, 0xB7, // "ċ" (U+010B)
  0x01, 0x0C, 0x00, 0x01, 0x08, 0x11, 0x0A, 0x26, 0xE1, // "Č" (U+010C)
  0x01, 0x0D, 0x00, 0x01, 0x06, 0x0E, 0x08, 0x27, 0x1E, // "č" (U+010D)
  0x01, 0x0E, 0x00, 0x01, 0x0A, 0x11, 0x0B, 0x27, 0x4B, // "Ď" (U+010E)
  0x01, 0x0F, 0x00, 0x01, 0x0A, 0x0E, 0x0A, 0x27, 0x9A, // "ď" (U+010F)
  0x01, 0x10, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x27, 0xDE, // "Đ" (U+0110)
  0x01, 0x11, 0x00, 0x01, 0x09, 0x0E, 0x0A, 0x28, 0x21, // "đ" (U+0111)
  0x01, 0x12, 0x00, 0x01, 0x08, 0x0F, 0x0A, 0x28, 0x63, // "Ē" (U+0112)
  0x01, 0x13, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x28, 0x97, // "ē" (U+0113)
  0x01, 0x14, 0x00, 0x01, 0x08, 0x11, 0x0A, 0x28, 0xC4, // "Ĕ" (U+0114)
  0x01, 0x15, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x28, 0xFF, // "ĕ" (U+0115)
  0x01, 0x16, 0x00, 0x01, 0x08, 0x12, 0x0A, 0x29, 0x33, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x01, 0x07, 0x0F, 0x08, 0x29, 0x6B, // "ė" (U+0117)
  0x01, 0x18, 0x00, 0xFC, 0x08, 0x0D, 0x0A, 0x29, 0x9B, // "Ę" (U+0118)
  0x01, 0x19, 0x00, 0xFD, 0x07, 0x0A, 0x08, 0x29, 0xD7, // "ę" (U+0119)
  0x01, 0x1A, 0x00, 0x01, 0x08, 0x11, 0x0A, 0x2A, 0x0A, // "Ě" (U+011A)
  0x01, 0x1B, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x2A, 0x45, // "ě" (U+011B)
  0x01, 0x1C, 0x00, 0x01, 0x0A, 0x11, 0x0B, 0x2A, 0x78, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x00, 0xFD, 0x07, 0x0E, 0x08, 0x2A, 0xC2, // "ĝ" (U+011D)
  0x01, 0x1E, 0x00, 0x01, 0x0A, 0x11, 0x0B, 0x2B, 0x05, // "Ğ" (U+011E)
  0x01, 0x1F, 0x00, 0xFD, 0x07, 0x0E, 0x08, 0x2B, 0x50, // "ğ" (U+011F)
  0x01, 0x20, 0x00, 0x01, 0x0A, 0x12, 0x0B, 0x2B, 0x94, // "Ġ" (U+0120)
  0x01, 0x21, 0x00, 0xFD, 0x07, 0x0F, 0x08, 0x2B, 0xDC, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0xFD, 0x0A, 0x0D, 0x0B, 0x2C, 0x1C, // "Ģ" (U+0122)
  0x01, 0x23, 0x00, 0xFD, 0x07, 0x0E, 0x08, 0x2C, 0x63, // "ģ" (U+0123)
  0x01, 0x24, 0x00, 0x01, 0x0B, 0x11, 0x0C, 0x2C, 0xA2, // "Ĥ" (U+0124)
  0x01, 0x25, 0x00, 0x01, 0x09, 0x11, 0x0A, 0x2C, 0xF3, // "ĥ" (U+0125)
  0x01, 0x26, 0x00, 0x01, 0x0B, 0x0D, 0x0C, 0x2D, 0x44, // "Ħ" (U+0126)
  0x01, 0x27, 0x40, 0x01, 0x09, 0x0E, 0x0A, 0x2D, 0x89, // "ħ" (U+0127)
  0x01, 0x28, 0xFF, 0x01, 0x05, 0x10, 0x06, 0x2D, 0xCF, // "Ĩ" (U+0128)
  0x01, 0x29, 0xFF, 0x01, 0x05, 0x0D, 0x05, 0x2D, 0xF6, // "ĩ" (U+0129)
  0x01, 0x2A, 0x00, 0x01, 0x05, 0x0F, 0x06, 0x2E, 0x1D, // "Ī" (U+012A)
  0x01, 0x2B, 0xFF, 0x01, 0x04, 0x0C, 0x05, 0x2E, 0x3F, // "ī" (U+012B)
  0x01, 0x2C, 0x00, 0x01, 0x05, 0x11, 0x06, 0x2E, 0x61, // "Ĭ" (U+012C)
  0x01, 0x2D, 0xFF, 0x01, 0x04, 0x0E, 0x05, 0x2E, 0x89, // "ĭ" (U+012D)
  0x01, 0x2E, 0x00, 0xFC, 0x05, 0x0D, 0x06, 0x2E, 0xB2, // "Į" (U+012E)
  0x01, 0x2F, 0x40, 0xFC, 0x04, 0x0E, 0x05, 0x2E, 0xDC, // "į" (U+012F)
  0x01, 0x30, 0x00, 0x01, 0x05, 0x12, 0x06, 0x2F, 0x0C, // "İ" (U+0130)
  0x01, 0x31, 0x40, 0x01, 0x04, 0x0A, 0x05, 0x2F, 0x32, // "ı" (U+0131)
  0x01, 0x32, 0x00, 0xFD, 0x0B, 0x0D, 0x0B, 0x2F, 0x4B, // "Ĳ" (U+0132)
  0x01, 0x33, 0x00, 0xFD, 0x08, 0x0E, 0x0A, 0x2F, 0x97, // "ĳ" (U+0133)
  0x01, 0x34, 0xFF, 0xFD, 0x05, 0x11, 0x06, 0x2F, 0xE6, // "Ĵ" (U+0134)
  0x01, 0x35, 0xBF, 0xFD, 0x04, 0x0E, 0x05, 0x30, 0x20, // "ĵ" (U+0135)
  0x01, 0x36, 0x00, 0xFD, 0x0B, 0x0D, 0x0B, 0x30, 0x56, // "Ķ" (U+0136)
  0x01, 0x37, 0x00, 0xFD, 0x09, 0x0E, 0x09, 0x30, 0x9F, // "ķ" (U+0137)
  0x01, 0x38, 0x00, 0x01, 0x09, 0x0A, 0x09, 0x30, 0xE4, // "ĸ" (U+0138)
  0x01, 0x39, 0x00, 0x01, 0x08, 0x11, 0x0A, 0x31, 0x15, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x40, 0x01, 0x04, 0x11, 0x05, 0x31, 0x45, // "ĺ" (U+013A)
  0x01, 0x3B, 0x00, 0xFD, 0x08, 0x0D, 0x0A, 0x31, 0x70, // "Ļ" (U+013B)
  0x01, 0x3C, 0x40, 0xFD, 0x04, 0x0E, 0x05, 0x31, 0x9E, // "ļ" (U+013C)
  0x01, 0x3D, 0x00, 0x01, 0x08, 0x0D, 0x0A, 0x31, 0xCB, // "Ľ" (U+013D)
  0x01, 0x3E, 0x40, 0x01, 0x05, 0x0E, 0x05, 0x31, 0xF7, // "ľ" (U+013E)
  0x01, 0x3F, 0x00, 0x01, 0x08, 0x0D, 0x0A, 0x32, 0x21, // "Ŀ" (U+013F)
  0x01, 0x40, 0x00, 0x01, 0x06, 0x0E, 0x05, 0x32, 0x4F, // "ŀ" (U+0140)
  0x01, 0x41, 0x00, 0x01, 0x08, 0x0D, 0x0A, 0x32, 0x7C, // "Ł" (U+0141)
  0x01, 0x42, 0x40, 0x01, 0x04, 0x0E, 0x05, 0x32, 0xAA, // "ł" (U+0142)
  0x01, 0x43, 0x00, 0x01, 0x0B, 0x11, 0x0C, 0x32, 0xCD, // "Ń" (U+0143)
  0x01, 0x44, 0x00, 0x01, 0x09, 0x0E, 0x0A, 0x33, 0x1B, // "ń" (U+0144)
  0x01, 0x45, 0x00, 0xFD, 0x0B, 0x0D, 0x0C, 0x33, 0x5E, // "Ņ" (U+0145)
  0x01, 0x46, 0x00, 0xFD, 0x09, 0x0A, 0x0A, 0x33, 0xA9, // "ņ" (U+0146)
  0x01, 0x47, 0x00, 0x01, 0x0B, 0x11, 0x0C, 0x33, 0xEB, // "Ň" (U+0147)
  0x01, 0x48, 0x40, 0x01, 0x09, 0x0E, 0x0A, 0x34, 0x3B, // "ň" (U+0148)
  0x01, 0x49, 0x00, 0x01, 0x0B, 0x0D, 0x0C, 0x34, 0x81, // "ŉ" (U+0149)
  0x01, 0x4A, 0x00, 0xFD, 0x0B, 0x0D, 0x0C, 0x34, 0xC7, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x40, 0xFD, 0x08, 0x0A, 0x0A, 0x35, 0x14, // "ŋ" (U+014B)
  0x01, 0x4C, 0x00, 0x01, 0x0A, 0x0F, 0x0C, 0x35, 0x53, // "Ō" (U+014C)
  0x01, 0x4D, 0x00, 0x01, 0x08, 0x0C, 0x09, 0x35, 0x98, // "ō" (U+014D)
  0x01, 0x4E, 0x00, 0x01, 0x0A, 0x11, 0x0C, 0x35, 0xCA, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x36, 0x16, // "ŏ" (U+014F)
  0x01, 0x50, 0x00, 0x01, 0x0A, 0x11, 0x0C, 0x36, 0x4F, // "Ő" (U+0150)
  0x01, 0x51, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x36, 0x9C, // "ő" (U+0151)
  0x01, 0x52, 0x00, 0x01, 0x0E, 0x0D, 0x0F, 0x36, 0xD6, // "Œ" (U+0152)
  0x01, 0x53, 0x40, 0x01, 0x0D, 0x0A, 0x0E, 0x37, 0x2A, // "œ" (U+0153)
  0x01, 0x54, 0x00, 0x01, 0x0A, 0x11, 0x0A, 0x37, 0x70, // "Ŕ" (U+0154)
  0x01, 0x55, 0x00, 0x01, 0x07, 0x0E, 0x07, 0x37, 0xBB, // "ŕ" (U+0155)
  0x01, 0x56, 0x00, 0xFD, 0x0A, 0x0D, 0x0A, 0x37, 0xE8, // "Ŗ" (U+0156)
  0x01, 0x57, 0x00, 0xFD, 0x07, 0x0A, 0x07, 0x38, 0x31, // "ŗ" (U+0157)
  0x01, 0x58, 0x00, 0x01, 0x0A, 0x11, 0x0A, 0x38, 0x5B, // "Ř" (U+0158)
  0x01, 0x59, 0x00, 0x01, 0x07, 0x0E, 0x07, 0x38, 0xA8, // "ř" (U+0159)
  0x01, 0x5A, 0x00, 0x01, 0x07, 0x11, 0x08, 0x38, 0xD7, // "Ś" (U+015A)
  0x01, 0x5B, 0x00, 0x01, 0x06, 0x0E, 0x07, 0x39, 0x12, // "ś" (U+015B)
  0x01, 0x5C, 0x00, 0x01, 0x07, 0x11, 0x08, 0x39, 0x3E, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x00, 0x01, 0x06, 0x0E, 0x07, 0x39, 0x7C, // "ŝ" (U+015D)
  0x01, 0x5E, 0x00, 0xFD, 0x07, 0x0D, 0x08, 0x39, 0xAB, // "Ş" (U+015E)
  0x01, 0x5F, 0x00, 0xFD, 0x06, 0x0A, 0x07, 0x39, 0xE8, // "ş" (U+015F)
  0x01, 0x60, 0x00, 0x01, 0x07, 0x11, 0x08, 0x3A, 0x16, // "Š" (U+0160)
  0x01, 0x61, 0x00, 0x01, 0x06, 0x0E, 0x07, 0x3A, 0x54, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFD, 0x09, 0x0D, 0x0A, 0x3A, 0x82, // "Ţ" (U+0162)
  0x01, 0x63, 0x40, 0xFD, 0x05, 0x0C, 0x06, 0x3A, 0xC1, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x09, 0x11, 0x0A, 0x3A, 0xF1, // "Ť" (U+0164)
  0x01, 0x65, 0x40, 0x01, 0x05, 0x0E, 0x06, 0x3B, 0x2F, // "ť" (U+0165)
  0x01, 0x66, 0x00, 0x01, 0x09, 0x0D, 0x0A, 0x3B, 0x59, // "Ŧ" (U+0166)
  0x01, 0x67, 0x40, 0x01, 0x05, 0x0C, 0x06, 0x3B, 0x8E, // "ŧ" (U+0167)
  0x01, 0x68, 0x00, 0x01, 0x0A, 0x10, 0x0B, 0x3B, 0xB2, // "Ũ" (U+0168)
  0x01, 0x69, 0x40, 0x01, 0x09, 0x0D, 0x0A, 0x3C, 0x02, // "ũ" (U+0169)
  0x01, 0x6A, 0x00, 0x01, 0x0A, 0x0F, 0x0B, 0x3C, 0x43, // "Ū" (U+016A)
  0x01, 0x6B, 0x40, 0x01, 0x09, 0x0C, 0x0A, 0x3C, 0x8E, // "ū" (U+016B)
  0x01, 0x6C, 0x00, 0x01, 0x0A, 0x11, 0x0B, 0x3C, 0xCA, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x40, 0x01, 0x09, 0x0E, 0x0A, 0x3D, 0x1C, // "ŭ" (U+016D)
  0x01, 0x6E, 0x00, 0x01, 0x0A, 0x12, 0x0B, 0x3D, 0x62, // "Ů" (U+016E)
  0x01, 0x6F, 0x00, 0x01, 0x09, 0x0F, 0x0A, 0x3D, 0xB7, // "ů" (U+016F)
  0x01, 0x70, 0x00, 0x01, 0x0A, 0x11, 0x0B, 0x3E, 0x01, // "Ű" (U+0170)
  0x01, 0x71, 0x40, 0x01, 0x09, 0x0E, 0x0A, 0x3E, 0x54, // "ű" (U+0171)
  0x01, 0x72, 0x00, 0xFC, 0x0A, 0x0D, 0x0B, 0x3E, 0x9A, // "Ų" (U+0172)
  0x01, 0x73, 0x40, 0xFD, 0x09, 0x0A, 0x0A, 0x3E, 0xEF, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x0F, 0x11, 0x10, 0x3F, 0x35, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x0D, 0x0E, 0x0D, 0x3F, 0xA4, // "ŵ" (U+0175)
  0x01, 0x76, 0xFF, 0x01, 0x09, 0x11, 0x0A, 0x3F, 0xF4, // "Ŷ" (U+0176)
  0x01, 0x77, 0x00, 0xFD, 0x08, 0x0E, 0x09, 0x40, 0x35, // "ŷ" (U+0177)
  0x01, 0x78, 0xFF, 0x01, 0x09, 0x11, 0x0A, 0x40, 0x78, // "Ÿ" (U+0178)
  0x01, 0x79, 0x00, 0x01, 0x08, 0x11, 0x09, 0x40, 0xB7, // "Ź" (U+0179)
  0x01, 0x7A, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x40, 0xF3, // "ź" (U+017A)
  0x01, 0x7B, 0x00, 0x01, 0x08, 0x12, 0x09, 0x41, 0x22, // "Ż" (U+017B)
  0x01, 0x7C, 0x00, 0x01, 0x07, 0x0F, 0x08, 0x41, 0x5D, // "ż" (U+017C)
  0x01, 0x7D, 0x00, 0x01, 0x08, 0x11, 0x09, 0x41, 0x8C, // "Ž" (U+017D)
  0x01, 0x7E, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x41, 0xCA, // "ž" (U+017E)
  0x01, 0x7F, 0x00, 0x01, 0x06, 0x0E, 0x06, 0x41, 0xFC, // "ſ" (U+017F)
  0x03, 0xA9, 0x00, 0x01, 0x0A, 0x0D, 0x0C, 0x42, 0x2A, // "Ω" (U+03A9)
  0x03, 0xBC, 0x41, 0xFD, 0x08, 0x0A, 0x0A, 0x42, 0x6D, // "μ" (U+03BC)
  0x03, 0xC0, 0x40, 0x01, 0x09, 0x0A, 0x0A, 0x42, 0xA5, // "π" (U+03C0)
  0x20, 0x13, 0xFF, 0x05, 0x09, 0x05, 0x09, 0x42, 0xD7, // "–" (U+2013)
  0x20, 0x14, 0xFF, 0x05, 0x12, 0x05, 0x12, 0x42, 0xDB, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x01, 0x08, 0x0D, 0x09, 0x42, 0xE0, // "€" (U+20AC)
  0x20, 0xBF, 0x40, 0xFF, 0x07, 0x0E, 0x09, 0x43, 0x12, // "₿" (U+20BF)
  0x20, 0x18, 0x40, 0x09, 0x03, 0x0D, 0x04, 0x43, 0x52, // "‘" (U+2018)
  0x20, 0x19, 0x40, 0x09, 0x02, 0x0D, 0x04, 0x43, 0x5C, // "’" (U+2019)
  0x20, 0x1A, 0x40, 0xFE, 0x02, 0x02, 0x04, 0x43, 0x64, // "‚" (U+201A)
  0x20, 0x1B, 0x40, 0x09, 0x03, 0x0D, 0x04, 0x43, 0x6C, // "‛" (U+201B)
  0x20, 0x1C, 0x41, 0x09, 0x06, 0x0D, 0x07, 0x43, 0x76, // "“" (U+201C)
  0x20, 0x1D, 0x40, 0x09, 0x05, 0x0D, 0x07, 0x43, 0x85, // "”" (U+201D)
  0x20, 0x1E, 0x40, 0xFE, 0x05, 0x02, 0x07, 0x43, 0x94, // "„" (U+201E)
  0x20, 0x1F, 0x40, 0x09, 0x06, 0x0D, 0x07, 0x43, 0xA3, // "‟" (U+201F)
  0x20, 0x20, 0x00, 0xFF, 0x06, 0x0E, 0x07, 0x43, 0xB5, // "†" (U+2020)
  0x20, 0x21, 0x00, 0xFF, 0x06, 0x0E, 0x07, 0x43, 0xDC, // "‡" (U+2021)
  0x20, 0x22, 0x40, 0x05, 0x04, 0x09, 0x06, 0x44, 0x0D, // "•" (U+2022)
  0x20, 0x26, 0x01, 0x01, 0x0B, 0x03, 0x0D, 0x44, 0x1A, // "…" (U+2026)
  0x20, 0x30, 0x00, 0x01, 0x13, 0x0D, 0x14, 0x44, 0x29, // "‰" (U+2030)
  0x20, 0x39, 0x41, 0x02, 0x03, 0x08, 0x05, 0x44, 0x9F, // "‹" (U+2039)
  0x20, 0x3A, 0x41, 0x02, 0x04, 0x08, 0x05, 0x44, 0xAA, // "›" (U+203A)
  0x20, 0x44, 0xFD, 0x01, 0x03, 0x0D, 0x01, 0x44, 0xB8, // "⁄" (U+2044)
  0x21, 0x22, 0x40, 0x07, 0x0C, 0x0D, 0x0D, 0x44, 0xD9, // "™" (U+2122)
  0x21, 0x52, 0x00, 0x01, 0x11, 0x0E, 0x12, 0x45, 0x07, // "⅒" (U+2152)
  0xFB, 0x01, 0x00, 0x01, 0x0A, 0x0E, 0x0A, 0x45, 0x73, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0x00, 0x01, 0x0A, 0x0E, 0x0A, 0x45, 0xB9, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x01, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0x67, 0x01, // "g (U+0022 U+0067)
  0x00, 0x22, 0x00, 0xC0, 0x01, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x01, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x01, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x01, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x01, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x01, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xC6, 0x02, // "Æ (U+0022 U+00C6)
  0x00, 0x22, 0x01, 0x00, 0x01, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x02, 0x01, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x04, 0x01, // "Ą (U+0022 U+0104)
  0x00, 0x26, 0x00, 0x3F, 0x01, // &? (U+0026 U+003F)
  0x00, 0x26, 0x00, 0x54, 0x01, // &T (U+0026 U+0054)
  0x00, 0x26, 0x00, 0x56, 0x01, // &V (U+0026 U+0056)
  0x00, 0x26, 0x00, 0x57, 0x01, // &W (U+0026 U+0057)
  0x00, 0x26, 0x00, 0x59, 0x01, // &Y (U+0026 U+0059)
  0x00, 0x26, 0x00, 0xDD, 0x01, // &Ý (U+0026 U+00DD)
  0x00, 0x26, 0x01, 0x62, 0x01, // &Ţ (U+0026 U+0162)
  0x00, 0x26, 0x01, 0x64, 0x01, // &Ť (U+0026 U+0164)
  0x00, 0x26, 0x01, 0x66, 0x01, // &Ŧ (U+0026 U+0166)
  0x00, 0x26, 0x01, 0x74, 0x01, // &Ŵ (U+0026 U+0174)
  0x00, 0x26, 0x01, 0x76, 0x01, // &Ŷ (U+0026 U+0176)
  0x00, 0x26, 0x01, 0x78, 0x01, // &Ÿ (U+0026 U+0178)
  0x00, 0x27, 0x00, 0x41, 0x01, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0x67, 0x01, // 'g (U+0027 U+0067)
  0x00, 0x27, 0x00, 0xC0, 0x01, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x01, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x01, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x01, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x01, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x01, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xC6, 0x02, // 'Æ (U+0027 U+00C6)
  0x00, 0x27, 0x01, 0x00, 0x01, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x02, 0x01, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x04, 0x01, // 'Ą (U+0027 U+0104)
  0x00, 0x2A, 0x00, 0x2C, 0x02, // *, (U+002A U+002C)
  0x00, 0x2A, 0x00, 0x2E, 0x02, // *. (U+002A U+002E)
  0x00, 0x2A, 0x00, 0x41, 0x01, // *A (U+002A U+0041)
  0x00, 0x2A, 0x00, 0xC0, 0x01, // *À (U+002A U+00C0)
  0x00, 0x2A, 0x00, 0xC1, 0x01, // *Á (U+002A U+00C1)
  0x00, 0x2A, 0x00, 0xC2, 0x01, // *Â (U+002A U+00C2)
  0x00, 0x2A, 0x00, 0xC3, 0x01, // *Ã (U+002A U+00C3)
  0x00, 0x2A, 0x00, 0xC4, 0x01, // *Ä (U+002A U+00C4)
  0x00, 0x2A, 0x00, 0xC5, 0x01, // *Å (U+002A U+00C5)
  0x00, 0x2A, 0x00, 0xC6, 0x01, // *Æ (U+002A U+00C6)
  0x00, 0x2A, 0x01, 0x00, 0x01, // *Ā (U+002A U+0100)
  0x00, 0x2A, 0x01, 0x02, 0x01, // *Ă (U+002A U+0102)
  0x00, 0x2A, 0x01, 0x04, 0x01, // *Ą (U+002A U+0104)
  0x00, 0x2A, 0x20, 0x1A, 0x02, // *‚ (U+002A U+201A)
  0x00, 0x2A, 0x20, 0x1E, 0x02, // *„ (U+002A U+201E)
  0x00, 0x2A, 0x20, 0x26, 0x02, // *… (U+002A U+2026)
  0x00, 0x2C, 0x00, 0x3F, 0x01, // ,? (U+002C U+003F)
  0x00, 0x2C, 0x00, 0x54, 0x01, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x56, 0x02, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x01, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x01, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0x76, 0x01, // ,v (U+002C U+0076)
  0x00, 0x2C, 0x00, 0x77, 0x01, // ,w (U+002C U+0077)
  0x00, 0x2C, 0x00, 0x79, 0x01, // ,y (U+002C U+0079)
  0x00, 0x2C, 0x00, 0xDD, 0x01, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x00, 0xFD, 0x01, // ,ý (U+002C U+00FD)
  0x00, 0x2C, 0x00, 0xFF, 0x01, // ,ÿ (U+002C U+00FF)
  0x00, 0x2C, 0x01, 0x62, 0x01, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x01, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x01, // ,Ŧ (U+002C U+0166)
  0x00, 0x2C, 0x01, 0x74, 0x01, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x75, 0x01, // ,ŵ (U+002C U+0175)
  0x00, 0x2C, 0x01, 0x76, 0x01, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x77, 0x01, // ,ŷ (U+002C U+0177)
  0x00, 0x2C, 0x01, 0x78, 0x01, // ,Ÿ (U+002C U+0178)
  0x00, 0x2E, 0x00, 0x3F, 0x01, // .? (U+002E U+003F)
  0x00, 0x2E, 0x00, 0x54, 0x01, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x56, 0x02, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x01, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x01, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0x76, 0x01, // .v (U+002E U+0076)
  0x00, 0x2E, 0x00, 0x77, 0x01, // .w (U+002E U+0077)
  0x00, 0x2E, 0x00, 0x79, 0x01, // .y (U+002E U+0079)
  0x00, 0x2E, 0x00, 0xDD, 0x01, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x00, 0xFD, 0x01, // .ý (U+002E U+00FD)
  0x00, 0x2E, 0x00, 0xFF, 0x01, // .ÿ (U+002E U+00FF)
  0x00, 0x2E, 0x01, 0x62, 0x01, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x01, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x01, // .Ŧ (U+002E U+0166)
  0x00, 0x2E, 0x01, 0x74, 0x01, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x75, 0x01, // .ŵ (U+002E U+0175)
  0x00, 0x2E, 0x01, 0x76, 0x01, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x77, 0x01, // .ŷ (U+002E U+0177)
  0x00, 0x2E, 0x01, 0x78, 0x01, // .Ÿ (U+002E U+0178)
  0x00, 0x40, 0x00, 0x41, 0x01, // @A (U+0040 U+0041)
  0x00, 0x40, 0x00, 0xC0, 0x01, // @À (U+0040 U+00C0)
  0x00, 0x40, 0x00, 0xC1, 0x01, // @Á (U+0040 U+00C1)
  0x00, 0x40, 0x00, 0xC2, 0x01, // @Â (U+0040 U+00C2)
  0x00, 0x40, 0x00, 0xC3, 0x01, // @Ã (U+0040 U+00C3)
  0x00, 0x40, 0x00, 0xC4, 0x01, // @Ä (U+0040 U+00C4)
  0x00, 0x40, 0x00, 0xC5, 0x01, // @Å (U+0040 U+00C5)
  0x00, 0x40, 0x01, 0x00, 0x01, // @Ā (U+0040 U+0100)
  0x00, 0x40, 0x01, 0x02, 0x01, // @Ă (U+0040 U+0102)
  0x00, 0x40, 0x01, 0x04, 0x01, // @Ą (U+0040 U+0104)
  0x00, 0x41, 0x00, 0x22, 0x01, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x01, // A' (U+0041 U+0027)
  0x00, 0x41, 0x00, 0x2A, 0x01, // A* (U+0041 U+002A)
  0x00, 0x41, 0x00, 0x3F, 0x01, // A? (U+0041 U+003F)
  0x00, 0x41, 0x00, 0x54, 0x01, // AT (U+0041 U+0054)
  0x00, 0x41, 0x00, 0x56, 0x01, // AV (U+0041 U+0056)
  0x00, 0x41, 0x00, 0x57, 0x01, // AW (U+0041 U+0057)
  0x00, 0x41, 0x00, 0x59, 0x01, // AY (U+0041 U+0059)
  0x00, 0x41, 0x00, 0x76, 0x01, // Av (U+0041 U+0076)
  0x00, 0x41, 0x00, 0x77, 0x01, // Aw (U+0041 U+0077)
  0x00, 0x41, 0x00, 0x79, 0x01, // Ay (U+0041 U+0079)
  0x00, 0x41, 0x00, 0xDD, 0x01, // AÝ (U+0041 U+00DD)
  0x00, 0x41, 0x00, 0xFD, 0x01, // Aý (U+0041 U+00FD)
  0x00, 0x41, 0x00, 0xFF, 0x01, // Aÿ (U+0041 U+00FF)
  0x00, 0x41, 0x01, 0x62, 0x01, // AŢ (U+0041 U+0162)
  0x00, 0x41, 0x01, 0x64, 0x01, // AŤ (U+0041 U+0164)
  0x00, 0x41, 0x01, 0x66, 0x01, // AŦ (U+0041 U+0166)
  0x00, 0x41, 0x01, 0x74, 0x01, // AŴ (U+0041 U+0174)
  0x00, 0x41, 0x01, 0x75, 0x01, // Aŵ (U+0041 U+0175)
  0x00, 0x41, 0x01, 0x76, 0x01, // AŶ (U+0041 U+0176)
  0x00, 0x41, 0x01, 0x77, 0x01, // Aŷ (U+0041 U+0177)
  0x00, 0x41, 0x01, 0x78, 0x01, // AŸ (U+0041 U+0178)
  0x00, 0x41, 0x20, 0x18, 0x01, // A‘ (U+0041 U+2018)
  0x00, 0x41, 0x20, 0x19, 0x01, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1C, 0x01, // A“ (U+0041 U+201C)
  0x00, 0x41, 0x20, 0x1D, 0x01, // A” (U+0041 U+201D)
  0x00, 0x41, 0x21, 0x22, 0x01, // A™ (U+0041 U+2122)
  0x00, 0x42, 0x00, 0x56, 0x01, // BV (U+0042 U+0056)
  0x00, 0x42, 0x00, 0x59, 0x01, // BY (U+0042 U+0059)
  0x00, 0x42, 0x00, 0xC6, 0x01, // BÆ (U+0042 U+00C6)
  0x00, 0x42, 0x00, 0xDD, 0x01, // BÝ (U+0042 U+00DD)
  0x00, 0x42, 0x01, 0x76, 0x01, // BŶ (U+0042 U+0176)
  0x00, 0x42, 0x01, 0x78, 0x01, // BŸ (U+0042 U+0178)
  0x00, 0x44, 0x00, 0x59, 0x01, // DY (U+0044 U+0059)
  0x00, 0x44, 0x00, 0xC6, 0x01, // DÆ (U+0044 U+00C6)
  0x00, 0x44, 0x00, 0xDD, 0x01, // DÝ (U+0044 U+00DD)
  0x00, 0x44, 0x01, 0x76, 0x01, // DŶ (U+0044 U+0176)
  0x00, 0x44, 0x01, 0x78, 0x01, // DŸ (U+0044 U+0178)
  0x00, 0x46, 0x00, 0x2C, 0x02, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x02, // F. (U+0046 U+002E)
  0x00, 0x46, 0x00, 0x40, 0x01, // F@ (U+0046 U+0040)
  0x00, 0x46, 0x00, 0x41, 0x01, // FA (U+0046 U+0041)
  0x00, 0x46, 0x00, 0x61, 0x01, // Fa (U+0046 U+0061)
  0x00, 0x46, 0x00, 0x63, 0x01, // Fc (U+0046 U+0063)
  0x00, 0x46, 0x00, 0x64, 0x01, // Fd (U+0046 U+0064)
  0x00, 0x46, 0x00, 0x65, 0x01, // Fe (U+0046 U+0065)
  0x00, 0x46, 0x00, 0x67, 0x01, // Fg (U+0046 U+0067)
  0x00, 0x46, 0x00, 0x6F, 0x01, // Fo (U+0046 U+006F)
  0x00, 0x46, 0x00, 0x71, 0x01, // Fq (U+0046 U+0071)
  0x00, 0x46, 0x00, 0xC0, 0x01, // FÀ (U+0046 U+00C0)
  0x00, 0x46, 0x00, 0xC1, 0x01, // FÁ (U+0046 U+00C1)
  0x00, 0x46, 0x00, 0xC2, 0x01, // FÂ (U+0046 U+00C2)
  0x00, 0x46, 0x00, 0xC3, 0x01, // FÃ (U+0046 U+00C3)
  0x00, 0x46, 0x00, 0xC4, 0x01, // FÄ (U+0046 U+00C4)
  0x00, 0x46, 0x00, 0xC5, 0x01, // FÅ (U+0046 U+00C5)
  0x00, 0x46, 0x00, 0xC6, 0x02, // FÆ (U+0046 U+00C6)
  0x00, 0x46, 0x00, 0xE0, 0x01, // Fà (U+0046 U+00E0)
  0x00, 0x46, 0x00, 0xE1, 0x01, // Fá (U+0046 U+00E1)
  0x00, 0x46, 0x00, 0xE2, 0x01, // Fâ (U+0046 U+00E2)
  0x00, 0x46, 0x00, 0xE3, 0x01, // Fã (U+0046 U+00E3)
  0x00, 0x46, 0x00, 0xE4, 0x01, // Fä (U+0046 U+00E4)
  0x00, 0x46, 0x00, 0xE5, 0x01, // Få (U+0046 U+00E5)
  0x00, 0x46, 0x00, 0xE6, 0x01, // Fæ (U+0046 U+00E6)
  0x00, 0x46, 0x00, 0xE7, 0x01, // Fç (U+0046 U+00E7)
  0x00, 0x46, 0x00, 0xE8, 0x01, // Fè (U+0046 U+00E8)
  0x00, 0x46, 0x00, 0xE9, 0x01, // Fé (U+0046 U+00E9)
  0x00, 0x46, 0x00, 0xEA, 0x01, // Fê (U+0046 U+00EA)
  0x00, 0x46, 0x00, 0xEB, 0x01, // Fë (U+0046 U+00EB)
  0x00, 0x46, 0x00, 0xF0, 0x01, // Fð (U+0046 U+00F0)
  0x00, 0x46, 0x00, 0xF2, 0x01, // Fò (U+0046 U+00F2)
  0x00, 0x46, 0x00, 0xF3, 0x01, // Fó (U+0046 U+00F3)
  0x00, 0x46, 0x00, 0xF4, 0x01, // Fô (U+0046 U+00F4)
  0x00, 0x46, 0x00, 0xF5, 0x01, // Fõ (U+0046 U+00F5)
  0x00, 0x46, 0x00, 0xF6, 0x01, // Fö (U+0046 U+00F6)
  0x00, 0x46, 0x00, 0xF8, 0x01, // Fø (U+0046 U+00F8)
  0x00, 0x46, 0x01, 0x00, 0x01, // FĀ (U+0046 U+0100)
  0x00, 0x46, 0x01, 0x01, 0x01, // Fā (U+0046 U+0101)
  0x00, 0x46, 0x01, 0x02, 0x01, // FĂ (U+0046 U+0102)
  0x00, 0x46, 0x01, 0x03, 0x01, // Fă (U+0046 U+0103)
  0x00, 0x46, 0x01, 0x04, 0x01, // FĄ (U+0046 U+0104)
  0x00, 0x46, 0x01, 0x05, 0x01, // Fą (U+0046 U+0105)
  0x00, 0x46, 0x01, 0x07, 0x01, // Fć (U+0046 U+0107)
  0x00, 0x46, 0x01, 0x09, 0x01, // Fĉ (U+0046 U+0109)
  0x00, 0x46, 0x01, 0x0B, 0x01, // Fċ (U+0046 U+010B)
  0x00, 0x46, 0x01, 0x0D, 0x01, // Fč (U+0046 U+010D)
  0x00, 0x46, 0x01, 0x0F, 0x01, // Fď (U+0046 U+010F)
  0x00, 0x46, 0x01, 0x11, 0x01, // Fđ (U+0046 U+0111)
  0x00, 0x46, 0x01, 0x13, 0x01, // Fē (U+0046 U+0113)
  0x00, 0x46, 0x01, 0x15, 0x01, // Fĕ (U+0046 U+0115)
  0x00, 0x46, 0x01, 0x17, 0x01, // Fė (U+0046 U+0117)
  0x00, 0x46, 0x01, 0x19, 0x01, // Fę (U+0046 U+0119)
  0x00, 0x46, 0x01, 0x1B, 0x01, // Fě (U+0046 U+011B)
  0x00, 0x46, 0x01, 0x1D, 0x01, // Fĝ (U+0046 U+011D)
  0x00, 0x46, 0x01, 0x1F, 0x01, // Fğ (U+0046 U+011F)
  0x00, 0x46, 0x01, 0x21, 0x01, // Fġ (U+0046 U+0121)
  0x00, 0x46, 0x01, 0x23, 0x01, // Fģ (U+0046 U+0123)
  0x00, 0x46, 0x01, 0x4D, 0x01, // Fō (U+0046 U+014D)
  0x00, 0x46, 0x01, 0x4F, 0x01, // Fŏ (U+0046 U+014F)
  0x00, 0x46, 0x01, 0x51, 0x01, // Fő (U+0046 U+0151)
  0x00, 0x46, 0x01, 0x53, 0x01, // Fœ (U+0046 U+0153)
  0x00, 0x46, 0x20, 0x1A, 0x02, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x02, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x02, // F… (U+0046 U+2026)
  0x00, 0x4B, 0x00, 0x77, 0x01, // Kw (U+004B U+0077)
  0x00, 0x4B, 0x00, 0x79, 0x01, // Ky (U+004B U+0079)
  0x00, 0x4B, 0x00, 0xFD, 0x01, // Ký (U+004B U+00FD)
  0x00, 0x4B, 0x00, 0xFF, 0x01, // Kÿ (U+004B U+00FF)
  0x00, 0x4B, 0x01, 0x75, 0x01, // Kŵ (U+004B U+0175)
  0x00, 0x4B, 0x01, 0x77, 0x01, // Kŷ (U+004B U+0177)
  0x00, 0x4C, 0x00, 0x22, 0x01, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x01, // L' (U+004C U+0027)
  0x00, 0x4C, 0x00, 0x2A, 0x01, // L* (U+004C U+002A)
  0x00, 0x4C, 0x00, 0x3F, 0x01, // L? (U+004C U+003F)
  0x00, 0x4C, 0x00, 0x54, 0x01, // LT (U+004C U+0054)
  0x00, 0x4C, 0x00, 0x56, 0x01, // LV (U+004C U+0056)
  0x00, 0x4C, 0x00, 0x57, 0x01, // LW (U+004C U+0057)
  0x00, 0x4C, 0x00, 0x59, 0x01, // LY (U+004C U+0059)
  0x00, 0x4C, 0x00, 0x79, 0x01, // Ly (U+004C U+0079)
  0x00, 0x4C, 0x00, 0xDD, 0x01, // LÝ (U+004C U+00DD)
  0x00, 0x4C, 0x00, 0xFD, 0x01, // Lý (U+004C U+00FD)
  0x00, 0x4C, 0x00, 0xFF, 0x01, // Lÿ (U+004C U+00FF)
  0x00, 0x4C, 0x01, 0x62, 0x01, // LŢ (U+004C U+0162)
  0x00, 0x4C, 0x01, 0x64, 0x01, // LŤ (U+004C U+0164)
  0x00, 0x4C, 0x01, 0x66, 0x01, // LŦ (U+004C U+0166)
  0x00, 0x4C, 0x01, 0x74, 0x01, // LŴ (U+004C U+0174)
  0x00, 0x4C, 0x01, 0x76, 0x01, // LŶ (U+004C U+0176)
  0x00, 0x4C, 0x01, 0x77, 0x01, // Lŷ (U+004C U+0177)
  0x00, 0x4C, 0x01, 0x78, 0x01, // LŸ (U+004C U+0178)
  0x00, 0x4C, 0x20, 0x18, 0x01, // L‘ (U+004C U+2018)
  0x00, 0x4C, 0x20, 0x19, 0x01, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1C, 0x01, // L“ (U+004C U+201C)
  0x00, 0x4C, 0x20, 0x1D, 0x01, // L” (U+004C U+201D)
  0x00, 0x4C, 0x21, 0x22, 0x01, // L™ (U+004C U+2122)
  0x00, 0x4F, 0x00, 0x59, 0x01, // OY (U+004F U+0059)
  0x00, 0x4F, 0x00, 0xC6, 0x01, // OÆ (U+004F U+00C6)
  0x00, 0x4F, 0x00, 0xDD, 0x01, // OÝ (U+004F U+00DD)
  0x00, 0x4F, 0x01, 0x76, 0x01, // OŶ (U+004F U+0176)
  0x00, 0x4F, 0x01, 0x78, 0x01, // OŸ (U+004F U+0178)
  0x00, 0x50, 0x00, 0x2C, 0x02, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x02, // P. (U+0050 U+002E)
  0x00, 0x50, 0x00, 0x41, 0x01, // PA (U+0050 U+0041)
  0x00, 0x50, 0x00, 0xC0, 0x01, // PÀ (U+0050 U+00C0)
  0x00, 0x50, 0x00, 0xC1, 0x01, // PÁ (U+0050 U+00C1)
  0x00, 0x50, 0x00, 0xC2, 0x01, // PÂ (U+0050 U+00C2)
  0x00, 0x50, 0x00, 0xC3, 0x01, // PÃ (U+0050 U+00C3)
  0x00, 0x50, 0x00, 0xC4, 0x01, // PÄ (U+0050 U+00C4)
  0x00, 0x50, 0x00, 0xC5, 0x01, // PÅ (U+0050 U+00C5)
  0x00, 0x50, 0x00, 0xC6, 0x01, // PÆ (U+0050 U+00C6)
  0x00, 0x50, 0x01, 0x00, 0x01, // PĀ (U+0050 U+0100)
  0x00, 0x50, 0x01, 0x02, 0x01, // PĂ (U+0050 U+0102)
  0x00, 0x50, 0x01, 0x04, 0x01, // PĄ (U+0050 U+0104)
  0x00, 0x50, 0x20, 0x1A, 0x02, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x02, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x02, // P… (U+0050 U+2026)
  0x00, 0x51, 0x00, 0x59, 0x01, // QY (U+0051 U+0059)
  0x00, 0x51, 0x00, 0xC6, 0x01, // QÆ (U+0051 U+00C6)
  0x00, 0x51, 0x00, 0xDD, 0x01, // QÝ (U+0051 U+00DD)
  0x00, 0x51, 0x01, 0x76, 0x01, // QŶ (U+0051 U+0176)
  0x00, 0x51, 0x01, 0x78, 0x01, // QŸ (U+0051 U+0178)
  0x00, 0x54, 0x00, 0x2C, 0x01, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2E, 0x01, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0x40, 0x01, // T@ (U+0054 U+0040)
  0x00, 0x54, 0x00, 0x41, 0x01, // TA (U+0054 U+0041)
  0x00, 0x54, 0x00, 0x61, 0x01, // Ta (U+0054 U+0061)
  0x00, 0x54, 0x00, 0x63, 0x01, // Tc (U+0054 U+0063)
  0x00, 0x54, 0x00, 0x64, 0x01, // Td (U+0054 U+0064)
  0x00, 0x54, 0x00, 0x65, 0x01, // Te (U+0054 U+0065)
  0x00, 0x54, 0x00, 0x67, 0x01, // Tg (U+0054 U+0067)
  0x00, 0x54, 0x00, 0x6F, 0x01, // To (U+0054 U+006F)
  0x00, 0x54, 0x00, 0x71, 0x01, // Tq (U+0054 U+0071)
  0x00, 0x54, 0x00, 0xC0, 0x01, // TÀ (U+0054 U+00C0)
  0x00, 0x54, 0x00, 0xC1, 0x01, // TÁ (U+0054 U+00C1)
  0x00, 0x54, 0x00, 0xC2, 0x01, // TÂ (U+0054 U+00C2)
  0x00, 0x54, 0x00, 0xC3, 0x01, // TÃ (U+0054 U+00C3)
  0x00, 0x54, 0x00, 0xC4, 0x01, // TÄ (U+0054 U+00C4)
  0x00, 0x54, 0x00, 0xC5, 0x01, // TÅ (U+0054 U+00C5)
  0x00, 0x54, 0x00, 0xC6, 0x01, // TÆ (U+0054 U+00C6)
  0x00, 0x54, 0x00, 0xE0, 0x01, // Tà (U+0054 U+00E0)
  0x00, 0x54, 0x00, 0xE1, 0x01, // Tá (U+0054 U+00E1)
  0x00, 0x54, 0x00, 0xE2, 0x01, // Tâ (U+0054 U+00E2)
  0x00, 0x54, 0x00, 0xE3, 0x01, // Tã (U+0054 U+00E3)
  0x00, 0x54, 0x00, 0xE4, 0x01, // Tä (U+0054 U+00E4)
  0x00, 0x54, 0x00, 0xE5, 0x01, // Tå (U+0054 U+00E5)
  0x00, 0x54, 0x00, 0xE6, 0x01, // Tæ (U+0054 U+00E6)
  0x00, 0x54, 0x00, 0xE7, 0x01, // Tç (U+0054 U+00E7)
  0x00, 0x54, 0x00, 0xE8, 0x01, // Tè (U+0054 U+00E8)
  0x00, 0x54, 0x00, 0xE9, 0x01, // Té (U+0054 U+00E9)
  0x00, 0x54, 0x00, 0xEA, 0x01, // Tê (U+0054 U+00EA)
  0x00, 0x54, 0x00, 0xEB, 0x01, // Të (U+0054 U+00EB)
  0x00, 0x54, 0x00, 0xF0, 0x01, // Tð (U+0054 U+00F0)
  0x00, 0x54, 0x00, 0xF2, 0x01, // Tò (U+0054 U+00F2)
  0x00, 0x54, 0x00, 0xF3, 0x01, // Tó (U+0054 U+00F3)
  0x00, 0x54, 0x00, 0xF4, 0x01, // Tô (U+0054 U+00F4)
  0x00, 0x54, 0x00, 0xF5, 0x01, // Tõ (U+0054 U+00F5)
  0x00, 0x54, 0x00, 0xF6, 0x01, // Tö (U+0054 U+00F6)
  0x00, 0x54, 0x00, 0xF8, 0x01, // Tø (U+0054 U+00F8)
  0x00, 0x54, 0x01, 0x00, 0x01, // TĀ (U+0054 U+0100)
  0x00, 0x54, 0x01, 0x01, 0x01, // Tā (U+0054 U+0101)
  0x00, 0x54, 0x01, 0x02, 0x01, // TĂ (U+0054 U+0102)
  0x00, 0x54, 0x01, 0x03, 0x01, // Tă (U+0054 U+0103)
  0x00, 0x54, 0x01, 0x04, 0x01, // TĄ (U+0054 U+0104)
  0x00, 0x54, 0x01, 0x05, 0x01, // Tą (U+0054 U+0105)
  0x00, 0x54, 0x01, 0x07, 0x01, // Tć (U+0054 U+0107)
  0x00, 0x54, 0x01, 0x09, 0x01, // Tĉ (U+0054 U+0109)
  0x00, 0x54, 0x01, 0x0B, 0x01, // Tċ (U+0054 U+010B)
  0x00, 0x54, 0x01, 0x0D, 0x01, // Tč (U+0054 U+010D)
  0x00, 0x54, 0x01, 0x0F, 0x01, // Tď (U+0054 U+010F)
  0x00, 0x54, 0x01, 0x11, 0x01, // Tđ (U+0054 U+0111)
  0x00, 0x54, 0x01, 0x13, 0x01, // Tē (U+0054 U+0113)
  0x00, 0x54, 0x01, 0x15, 0x01, // Tĕ (U+0054 U+0115)
  0x00, 0x54, 0x01, 0x17, 0x01, // Tė (U+0054 U+0117)
  0x00, 0x54, 0x01, 0x19, 0x01, // Tę (U+0054 U+0119)
  0x00, 0x54, 0x01, 0x1B, 0x01, // Tě (U+0054 U+011B)
  0x00, 0x54, 0x01, 0x1D, 0x01, // Tĝ (U+0054 U+011D)
  0x00, 0x54, 0x01, 0x1F, 0x01, // Tğ (U+0054 U+011F)
  0x00, 0x54, 0x01, 0x21, 0x01, // Tġ (U+0054 U+0121)
  0x00, 0x54, 0x01, 0x23, 0x01, // Tģ (U+0054 U+0123)
  0x00, 0x54, 0x01, 0x4D, 0x01, // Tō (U+0054 U+014D)
  0x00, 0x54, 0x01, 0x4F, 0x01, // Tŏ (U+0054 U+014F)
  0x00, 0x54, 0x01, 0x51, 0x01, // Tő (U+0054 U+0151)
  0x00, 0x54, 0x01, 0x53, 0x01, // Tœ (U+0054 U+0153)
  0x00, 0x54, 0x20, 0x1A, 0x01, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x01, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x01, // T… (U+0054 U+2026)
  0x00, 0x55, 0x00, 0xC6, 0x01, // UÆ (U+0055 U+00C6)
  0x00, 0x56, 0x00, 0x26, 0x01, // V& (U+0056 U+0026)
  0x00, 0x56, 0x00, 0x2C, 0x02, // V, (U+0056 U+002C)
  0x00, 0x56, 0x00, 0x2E, 0x02, // V. (U+0056 U+002E)
  0x00, 0x56, 0x00, 0x40, 0x01, // V@ (U+0056 U+0040)
  0x00, 0x56, 0x00, 0x41, 0x01, // VA (U+0056 U+0041)
  0x00, 0x56, 0x00, 0x61, 0x01, // Va (U+0056 U+0061)
  0x00, 0x56, 0x00, 0x63, 0x01, // Vc (U+0056 U+0063)
  0x00, 0x56, 0x00, 0x64, 0x01, // Vd (U+0056 U+0064)
  0x00, 0x56, 0x00, 0x65, 0x01, // Ve (U+0056 U+0065)
  0x00, 0x56, 0x00, 0x67, 0x01, // Vg (U+0056 U+0067)
  0x00, 0x56, 0x00, 0x6F, 0x01, // Vo (U+0056 U+006F)
  0x00, 0x56, 0x00, 0x71, 0x01, // Vq (U+0056 U+0071)
  0x00, 0x56, 0x00, 0x73, 0x01, // Vs (U+0056 U+0073)
  0x00, 0x56, 0x00, 0xC0, 0x01, // VÀ (U+0056 U+00C0)
  0x00, 0x56, 0x00, 0xC1, 0x01, // VÁ (U+0056 U+00C1)
  0x00, 0x56, 0x00, 0xC2, 0x01, // VÂ (U+0056 U+00C2)
  0x00, 0x56, 0x00, 0xC3, 0x01, // VÃ (U+0056 U+00C3)
  0x00, 0x56, 0x00, 0xC4, 0x01, // VÄ (U+0056 U+00C4)
  0x00, 0x56, 0x00, 0xC5, 0x01, // VÅ (U+0056 U+00C5)
  0x00, 0x56, 0x00, 0xC6, 0x02, // VÆ (U+0056 U+00C6)
  0x00, 0x56, 0x00, 0xE0, 0x01, // Và (U+0056 U+00E0)
  0x00, 0x56, 0x00, 0xE1, 0x01, // Vá (U+0056 U+00E1)
  0x00, 0x56, 0x00, 0xE2, 0x01, // Vâ (U+0056 U+00E2)
  0x00, 0x56, 0x00, 0xE3, 0x01, // Vã (U+0056 U+00E3)
  0x00, 0x56, 0x00, 0xE4, 0x01, // Vä (U+0056 U+00E4)
  0x00, 0x56, 0x00, 0xE5, 0x01, // Vå (U+0056 U+00E5)
  0x00, 0x56, 0x00, 0xE6, 0x01, // Væ (U+0056 U+00E6)
  0x00, 0x56, 0x00, 0xE7, 0x01, // Vç (U+0056 U+00E7)
  0x00, 0x56, 0x00, 0xE8, 0x01, // Vè (U+0056 U+00E8)
  0x00, 0x56, 0x00, 0xE9, 0x01, // Vé (U+0056 U+00E9)
  0x00, 0x56, 0x00, 0xEA, 0x01, // Vê (U+0056 U+00EA)
  0x00, 0x56, 0x00, 0xEB, 0x01, // Vë (U+0056 U+00EB)
  0x00, 0x56, 0x00, 0xF0, 0x01, // Vð (U+0056 U+00F0)
  0x00, 0x56, 0x00, 0xF2, 0x01, // Vò (U+0056 U+00F2)
  0x00, 0x56, 0x00, 0xF3, 0x01, // Vó (U+0056 U+00F3)
  0x00, 0x56, 0x00, 0xF4, 0x01, // Vô (U+0056 U+00F4)
  0x00, 0x56, 0x00, 0xF5, 0x01, // Võ (U+0056 U+00F5)
  0x00, 0x56, 0x00, 0xF6, 0x01, // Vö (U+0056 U+00F6)
  0x00, 0x56, 0x00, 0xF8, 0x01, // Vø (U+0056 U+00F8)
  0x00, 0x56, 0x01, 0x00, 0x01, // VĀ (U+0056 U+0100)
  0x00, 0x56, 0x01, 0x01, 0x01, // Vā (U+0056 U+0101)
  0x00, 0x56, 0x01, 0x02, 0x01, // VĂ (U+0056 U+0102)
  0x00, 0x56, 0x01, 0x03, 0x01, // Vă (U+0056 U+0103)
  0x00, 0x56, 0x01, 0x04, 0x01, // VĄ (U+0056 U+0104)
  0x00, 0x56, 0x01, 0x05, 0x01, // Vą (U+0056 U+0105)
  0x00, 0x56, 0x01, 0x07, 0x01, // Vć (U+0056 U+0107)
  0x00, 0x56, 0x01, 0x09, 0x01, // Vĉ (U+0056 U+0109)
  0x00, 0x56, 0x01, 0x0B, 0x01, // Vċ (U+0056 U+010B)
  0x00, 0x56, 0x01, 0x0D, 0x01, // Vč (U+0056 U+010D)
  0x00, 0x56, 0x01, 0x0F, 0x01, // Vď (U+0056 U+010F)
  0x00, 0x56, 0x01, 0x11, 0x01, // Vđ (U+0056 U+0111)
  0x00, 0x56, 0x01, 0x13, 0x01, // Vē (U+0056 U+0113)
  0x00, 0x56, 0x01, 0x15, 0x01, // Vĕ (U+0056 U+0115)
  0x00, 0x56, 0x01, 0x17, 0x01, // Vė (U+0056 U+0117)
  0x00, 0x56, 0x01, 0x19, 0x01, // Vę (U+0056 U+0119)
  0x00, 0x56, 0x01, 0x1B, 0x01, // Vě (U+0056 U+011B)
  0x00, 0x56, 0x01, 0x1D, 0x01, // Vĝ (U+0056 U+011D)
  0x00, 0x56, 0x01, 0x1F, 0x01, // Vğ (U+0056 U+011F)
  0x00, 0x56, 0x01, 0x21, 0x01, // Vġ (U+0056 U+0121)
  0x00, 0x56, 0x01, 0x23, 0x01, // Vģ (U+0056 U+0123)
  0x00, 0x56, 0x01, 0x4D, 0x01, // Vō (U+0056 U+014D)
  0x00, 0x56, 0x01, 0x4F, 0x01, // Vŏ (U+0056 U+014F)
  0x00, 0x56, 0x01, 0x51, 0x01, // Vő (U+0056 U+0151)
  0x00, 0x56, 0x01, 0x53, 0x01, // Vœ (U+0056 U+0153)
  0x00, 0x56, 0x01, 0x5B, 0x01, // Vś (U+0056 U+015B)
  0x00, 0x56, 0x01, 0x5D, 0x01, // Vŝ (U+0056 U+015D)
  0x00, 0x56, 0x01, 0x5F, 0x01, // Vş (U+0056 U+015F)
  0x00, 0x56, 0x01, 0x61, 0x01, // Vš (U+0056 U+0161)
  0x00, 0x56, 0x20, 0x1A, 0x02, // V‚ (U+0056 U+201A)
  0x00, 0x56, 0x20, 0x1E, 0x02, // V„ (U+0056 U+201E)
  0x00, 0x56, 0x20, 0x26, 0x02, // V… (U+0056 U+2026)
  0x00, 0x57, 0x00, 0x2C, 0x01, // W, (U+0057 U+002C)
  0x00, 0x57, 0x00, 0x2E, 0x01, // W. (U+0057 U+002E)
  0x00, 0x57, 0x00, 0x40, 0x01, // W@ (U+0057 U+0040)
  0x00, 0x57, 0x00, 0x41, 0x01, // WA (U+0057 U+0041)
  0x00, 0x57, 0x00, 0x61, 0x01, // Wa (U+0057 U+0061)
  0x00, 0x57, 0x00, 0x63, 0x01, // Wc (U+0057 U+0063)
  0x00, 0x57, 0x00, 0x64, 0x01, // Wd (U+0057 U+0064)
  0x00, 0x57, 0x00, 0x65, 0x01, // We (U+0057 U+0065)
  0x00, 0x57, 0x00, 0x67, 0x01, // Wg (U+0057 U+0067)
  0x00, 0x57, 0x00, 0x6F, 0x01, // Wo (U+0057 U+006F)
  0x00, 0x57, 0x00, 0x71, 0x01, // Wq (U+0057 U+0071)
  0x00, 0x57, 0x00, 0x73, 0x01, // Ws (U+0057 U+0073)
  0x00, 0x57, 0x00, 0x7A, 0x01, // Wz (U+0057 U+007A)
  0x00, 0x57, 0x00, 0xC0, 0x01, // WÀ (U+0057 U+00C0)
  0x00, 0x57, 0x00, 0xC1, 0x01, // WÁ (U+0057 U+00C1)
  0x00, 0x57, 0x00, 0xC2, 0x01, // WÂ (U+0057 U+00C2)
  0x00, 0x57, 0x00, 0xC3, 0x01, // WÃ (U+0057 U+00C3)
  0x00, 0x57, 0x00, 0xC4, 0x01, // WÄ (U+0057 U+00C4)
  0x00, 0x57, 0x00, 0xC5, 0x01, // WÅ (U+0057 U+00C5)
  0x00, 0x57, 0x00, 0xC6, 0x02, // WÆ (U+0057 U+00C6)
  0x00, 0x57, 0x00, 0xE0, 0x01, // Wà (U+0057 U+00E0)
  0x00, 0x57, 0x00, 0xE1, 0x01, // Wá (U+0057 U+00E1)
  0x00, 0x57, 0x00, 0xE2, 0x01, // Wâ (U+0057 U+00E2)
  0x00, 0x57, 0x00, 0xE3, 0x01, // Wã (U+0057 U+00E3)
  0x00, 0x57, 0x00, 0xE4, 0x01, // Wä (U+0057 U+00E4)
  0x00, 0x57, 0x00, 0xE5, 0x01, // Wå (U+0057 U+00E5)
  0x00, 0x57, 0x00, 0xE6, 0x01, // Wæ (U+0057 U+00E6)
  0x00, 0x57, 0x00, 0xE7, 0x01, // Wç (U+0057 U+00E7)
  0x00, 0x57, 0x00, 0xE8, 0x01, // Wè (U+0057 U+00E8)
  0x00, 0x57, 0x00, 0xE9, 0x01, // Wé (U+0057 U+00E9)
  0x00, 0x57, 0x00, 0xEA, 0x01, // Wê (U+0057 U+00EA)
  0x00, 0x57, 0x00, 0xEB, 0x01, // Wë (U+0057 U+00EB)
  0x00, 0x57, 0x00, 0xF0, 0x01, // Wð (U+0057 U+00F0)
  0x00, 0x57, 0x00, 0xF2, 0x01, // Wò (U+0057 U+00F2)
  0x00, 0x57, 0x00, 0xF3, 0x01, // Wó (U+0057 U+00F3)
  0x00, 0x57, 0x00, 0xF4, 0x01, // Wô (U+0057 U+00F4)
  0x00, 0x57, 0x00, 0xF5, 0x01, // Wõ (U+0057 U+00F5)
  0x00, 0x57, 0x00, 0xF6, 0x01, // Wö (U+0057 U+00F6)
  0x00, 0x57, 0x00, 0xF8, 0x01, // Wø (U+0057 U+00F8)
  0x00, 0x57, 0x01, 0x00, 0x01, // WĀ (U+0057 U+0100)
  0x00, 0x57, 0x01, 0x01, 0x01, // Wā (U+0057 U+0101)
  0x00, 0x57, 0x01, 0x02, 0x01, // WĂ (U+0057 U+0102)
  0x00, 0x57, 0x01, 0x03, 0x01, // Wă (U+0057 U+0103)
  0x00, 0x57, 0x01, 0x04, 0x01, // WĄ (U+0057 U+0104)
  0x00, 0x57, 0x01, 0x05, 0x01, // Wą (U+0057 U+0105)
  0x00, 0x57, 0x01, 0x07, 0x01, // Wć (U+0057 U+0107)
  0x00, 0x57, 0x01, 0x09, 0x01, // Wĉ (U+0057 U+0109)
  0x00, 0x57, 0x01, 0x0B, 0x01, // Wċ (U+0057 U+010B)
  0x00, 0x57, 0x01, 0x0D, 0x01, // Wč (U+0057 U+010D)
  0x00, 0x57, 0x01, 0x0F, 0x01, // Wď (U+0057 U+010F)
  0x00, 0x57, 0x01, 0x11, 0x01, // Wđ (U+0057 U+0111)
  0x00, 0x57, 0x01, 0x13, 0x01, // Wē (U+0057 U+0113)
  0x00, 0x57, 0x01, 0x15, 0x01, // Wĕ (U+0057 U+0115)
  0x00, 0x57, 0x01, 0x17, 0x01, // Wė (U+0057 U+0117)
  0x00, 0x57, 0x01, 0x19, 0x01, // Wę (U+0057 U+0119)
  0x00, 0x57, 0x01, 0x1B, 0x01, // Wě (U+0057 U+011B)
  0x00, 0x57, 0x01, 0x1D, 0x01, // Wĝ (U+0057 U+011D)
  0x00, 0x57, 0x01, 0x1F, 0x01, // Wğ (U+0057 U+011F)
  0x00, 0x57, 0x01, 0x21, 0x01, // Wġ (U+0057 U+0121)
  0x00, 0x57, 0x01, 0x23, 0x01, // Wģ (U+0057 U+0123)
  0x00, 0x57, 0x01, 0x4D, 0x01, // Wō (U+0057 U+014D)
  0x00, 0x57, 0x01, 0x4F, 0x01, // Wŏ (U+0057 U+014F)
  0x00, 0x57, 0x01, 0x51, 0x01, // Wő (U+0057 U+0151)
  0x00, 0x57, 0x01, 0x53, 0x01, // Wœ (U+0057 U+0153)
  0x00, 0x57, 0x01, 0x5B, 0x01, // Wś (U+0057 U+015B)
  0x00, 0x57, 0x01, 0x5D, 0x01, // Wŝ (U+0057 U+015D)
  0x00, 0x57, 0x01, 0x5F, 0x01, // Wş (U+0057 U+015F)
  0x00, 0x57, 0x01, 0x61, 0x01, // Wš (U+0057 U+0161)
  0x00, 0x57, 0x01, 0x7A, 0x01, // Wź (U+0057 U+017A)
  0x00, 0x57, 0x01, 0x7C, 0x01, // Wż (U+0057 U+017C)
  0x00, 0x57, 0x01, 0x7E, 0x01, // Wž (U+0057 U+017E)
  0x00, 0x57, 0x20, 0x1A, 0x01, // W‚ (U+0057 U+201A)
  0x00, 0x57, 0x20, 0x1E, 0x01, // W„ (U+0057 U+201E)
  0x00, 0x57, 0x20, 0x26, 0x01, // W… (U+0057 U+2026)
  0x00, 0x58, 0x00, 0x77, 0x01, // Xw (U+0058 U+0077)
  0x00, 0x58, 0x00, 0x79, 0x01, // Xy (U+0058 U+0079)
  0x00, 0x58, 0x00, 0xFD, 0x01, // Xý (U+0058 U+00FD)
  0x00, 0x58, 0x00, 0xFF, 0x01, // Xÿ (U+0058 U+00FF)
  0x00, 0x58, 0x01, 0x75, 0x01, // Xŵ (U+0058 U+0175)
  0x00, 0x58, 0x01, 0x77, 0x01, // Xŷ (U+0058 U+0177)
  0x00, 0x59, 0x00, 0x2C, 0x01, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x01, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x00, 0x40, 0x01, // Y@ (U+0059 U+0040)
  0x00, 0x59, 0x00, 0x41, 0x01, // YA (U+0059 U+0041)
  0x00, 0x59, 0x00, 0x43, 0x01, // YC (U+0059 U+0043)
  0x00, 0x59, 0x00, 0x47, 0x01, // YG (U+0059 U+0047)
  0x00, 0x59, 0x00, 0x4F, 0x01, // YO (U+0059 U+004F)
  0x00, 0x59, 0x00, 0x51, 0x01, // YQ (U+0059 U+0051)
  0x00, 0x59, 0x00, 0x61, 0x01, // Ya (U+0059 U+0061)
  0x00, 0x59, 0x00, 0x63, 0x01, // Yc (U+0059 U+0063)
  0x00, 0x59, 0x00, 0x64, 0x01, // Yd (U+0059 U+0064)
  0x00, 0x59, 0x00, 0x65, 0x01, // Ye (U+0059 U+0065)
  0x00, 0x59, 0x00, 0x67, 0x01, // Yg (U+0059 U+0067)
  0x00, 0x59, 0x00, 0x6F, 0x01, // Yo (U+0059 U+006F)
  0x00, 0x59, 0x00, 0x71, 0x01, // Yq (U+0059 U+0071)
  0x00, 0x59, 0x00, 0x73, 0x01, // Ys (U+0059 U+0073)
  0x00, 0x59, 0x00, 0xC0, 0x01, // YÀ (U+0059 U+00C0)
  0x00, 0x59, 0x00, 0xC1, 0x01, // YÁ (U+0059 U+00C1)
  0x00, 0x59, 0x00, 0xC2, 0x01, // YÂ (U+0059 U+00C2)
  0x00, 0x59, 0x00, 0xC3, 0x01, // YÃ (U+0059 U+00C3)
  0x00, 0x59, 0x00, 0xC4, 0x01, // YÄ (U+0059 U+00C4)
  0x00, 0x59, 0x00, 0xC5, 0x01, // YÅ (U+0059 U+00C5)
  0x00, 0x59, 0x00, 0xC6, 0x01, // YÆ (U+0059 U+00C6)
  0x00, 0x59, 0x00, 0xC7, 0x01, // YÇ (U+0059 U+00C7)
  0x00, 0x59, 0x00, 0xD2, 0x01, // YÒ (U+0059 U+00D2)
  0x00, 0x59, 0x00, 0xD3, 0x01, // YÓ (U+0059 U+00D3)
  0x00, 0x59, 0x00, 0xD4, 0x01, // YÔ (U+0059 U+00D4)
  0x00, 0x59, 0x00, 0xD5, 0x01, // YÕ (U+0059 U+00D5)
  0x00, 0x59, 0x00, 0xD6, 0x01, // YÖ (U+0059 U+00D6)
  0x00, 0x59, 0x00, 0xD8, 0x01, // YØ (U+0059 U+00D8)
  0x00, 0x59, 0x00, 0xE0, 0x01, // Yà (U+0059 U+00E0)
  0x00, 0x59, 0x00, 0xE1, 0x01, // Yá (U+0059 U+00E1)
  0x00, 0x59, 0x00, 0xE2, 0x01, // Yâ (U+0059 U+00E2)
  0x00, 0x59, 0x00, 0xE3, 0x01, // Yã (U+0059 U+00E3)
  0x00, 0x59, 0x00, 0xE4, 0x01, // Yä (U+0059 U+00E4)
  0x00, 0x59, 0x00, 0xE5, 0x01, // Yå (U+0059 U+00E5)
  0x00, 0x59, 0x00, 0xE6, 0x01, // Yæ (U+0059 U+00E6)
  0x00, 0x59, 0x00, 0xE7, 0x01, // Yç (U+0059 U+00E7)
  0x00, 0x59, 0x00, 0xE8, 0x01, // Yè (U+0059 U+00E8)
  0x00, 0x59, 0x00, 0xE9, 0x01, // Yé (U+0059 U+00E9)
  0x00, 0x59, 0x00, 0xEA, 0x01, // Yê (U+0059 U+00EA)
  0x00, 0x59, 0x00, 0xEB, 0x01, // Yë (U+0059 U+00EB)
  0x00, 0x59, 0x00, 0xF0, 0x01, // Yð (U+0059 U+00F0)
  0x00, 0x59, 0x00, 0xF2, 0x01, // Yò (U+0059 U+00F2)
  0x00, 0x59, 0x00, 0xF3, 0x01, // Yó (U+0059 U+00F3)
  0x00, 0x59, 0x00, 0xF4, 0x01, // Yô (U+0059 U+00F4)
  0x00, 0x59, 0x00, 0xF5, 0x01, // Yõ (U+0059 U+00F5)
  0x00, 0x59, 0x00, 0xF6, 0x01, // Yö (U+0059 U+00F6)
  0x00, 0x59, 0x00, 0xF8, 0x01, // Yø (U+0059 U+00F8)
  0x00, 0x59, 0x01, 0x00, 0x01, // YĀ (U+0059 U+0100)
  0x00, 0x59, 0x01, 0x01, 0x01, // Yā (U+0059 U+0101)
  0x00, 0x59, 0x01, 0x02, 0x01, // YĂ (U+0059 U+0102)
  0x00, 0x59, 0x01, 0x03, 0x01, // Yă (U+0059 U+0103)
  0x00, 0x59, 0x01, 0x04, 0x01, // YĄ (U+0059 U+0104)
  0x00, 0x59, 0x01, 0x05, 0x01, // Yą (U+0059 U+0105)
  0x00, 0x59, 0x01, 0x06, 0x01, // YĆ (U+0059 U+0106)
  0x00, 0x59, 0x01, 0x07, 0x01, // Yć (U+0059 U+0107)
  0x00, 0x59, 0x01, 0x08, 0x01, // YĈ (U+0059 U+0108)
  0x00, 0x59, 0x01, 0x09, 0x01, // Yĉ (U+0059 U+0109)
  0x00, 0x59, 0x01, 0x0A, 0x01, // YĊ (U+0059 U+010A)
  0x00, 0x59, 0x01, 0x0B, 0x01, // Yċ (U+0059 U+010B)
  0x00, 0x59, 0x01, 0x0C, 0x01, // YČ (U+0059 U+010C)
  0x00, 0x59, 0x01, 0x0D, 0x01, // Yč (U+0059 U+010D)
  0x00, 0x59, 0x01, 0x0F, 0x01, // Yď (U+0059 U+010F)
  0x00, 0x59, 0x01, 0x11, 0x01, // Yđ (U+0059 U+0111)
  0x00, 0x59, 0x01, 0x13, 0x01, // Yē (U+0059 U+0113)
  0x00, 0x59, 0x01, 0x15, 0x01, // Yĕ (U+0059 U+0115)
  0x00, 0x59, 0x01, 0x17, 0x01, // Yė (U+0059 U+0117)
  0x00, 0x59, 0x01, 0x19, 0x01, // Yę (U+0059 U+0119)
  0x00, 0x59, 0x01, 0x1B, 0x01, // Yě (U+0059 U+011B)
  0x00, 0x59, 0x01, 0x1C, 0x01, // YĜ (U+0059 U+011C)
  0x00, 0x59, 0x01, 0x1D, 0x01, // Yĝ (U+0059 U+011D)
  0x00, 0x59, 0x01, 0x1E, 0x01, // YĞ (U+0059 U+011E)
  0x00, 0x59, 0x01, 0x1F, 0x01, // Yğ (U+0059 U+011F)
  0x00, 0x59, 0x01, 0x20, 0x01, // YĠ (U+0059 U+0120)
  0x00, 0x59, 0x01, 0x21, 0x01, // Yġ (U+0059 U+0121)
  0x00, 0x59, 0x01, 0x22, 0x01, // YĢ (U+0059 U+0122)
  0x00, 0x59, 0x01, 0x23, 0x01, // Yģ (U+0059 U+0123)
  0x00, 0x59, 0x01, 0x4C, 0x01, // YŌ (U+0059 U+014C)
  0x00, 0x59, 0x01, 0x4D, 0x01, // Yō (U+0059 U+014D)
  0x00, 0x59, 0x01, 0x4E, 0x01, // YŎ (U+0059 U+014E)
  0x00, 0x59, 0x01, 0x4F, 0x01, // Yŏ (U+0059 U+014F)
  0x00, 0x59, 0x01, 0x50, 0x01, // YŐ (U+0059 U+0150)
  0x00, 0x59, 0x01, 0x51, 0x01, // Yő (U+0059 U+0151)
  0x00, 0x59, 0x01, 0x52, 0x01, // YŒ (U+0059 U+0152)
  0x00, 0x59, 0x01, 0x53, 0x01, // Yœ (U+0059 U+0153)
  0x00, 0x59, 0x01, 0x5B, 0x01, // Yś (U+0059 U+015B)
  0x00, 0x59, 0x01, 0x5D, 0x01, // Yŝ (U+0059 U+015D)
  0x00, 0x59, 0x01, 0x5F, 0x01, // Yş (U+0059 U+015F)
  0x00, 0x59, 0x01, 0x61, 0x01, // Yš (U+0059 U+0161)
  0x00, 0x59, 0x20, 0x1A, 0x01, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x01, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x01, // Y… (U+0059 U+2026)
  0x00, 0x61, 0x00, 0x22, 0x01, // a" (U+0061 U+0022)
  0x00, 0x61, 0x00, 0x27, 0x01, // a' (U+0061 U+0027)
  0x00, 0x61, 0x00, 0x56, 0x01, // aV (U+0061 U+0056)
  0x00, 0x61, 0x00, 0x57, 0x01, // aW (U+0061 U+0057)
  0x00, 0x61, 0x00, 0x59, 0x01, // aY (U+0061 U+0059)
  0x00, 0x61, 0x00, 0xDD, 0x01, // aÝ (U+0061 U+00DD)
  0x00, 0x61, 0x01, 0x74, 0x01, // aŴ (U+0061 U+0174)
  0x00, 0x61, 0x01, 0x76, 0x01, // aŶ (U+0061 U+0176)
  0x00, 0x61, 0x01, 0x78, 0x01, // aŸ (U+0061 U+0178)
  0x00, 0x62, 0x00, 0x56, 0x01, // bV (U+0062 U+0056)
  0x00, 0x62, 0x00, 0x57, 0x01, // bW (U+0062 U+0057)
  0x00, 0x62, 0x00, 0x59, 0x01, // bY (U+0062 U+0059)
  0x00, 0x62, 0x00, 0xDD, 0x01, // bÝ (U+0062 U+00DD)
  0x00, 0x62, 0x01, 0x74, 0x01, // bŴ (U+0062 U+0174)
  0x00, 0x62, 0x01, 0x76, 0x01, // bŶ (U+0062 U+0176)
  0x00, 0x62, 0x01, 0x78, 0x01, // bŸ (U+0062 U+0178)
  0x00, 0x65, 0x00, 0x56, 0x01, // eV (U+0065 U+0056)
  0x00, 0x65, 0x00, 0x57, 0x01, // eW (U+0065 U+0057)
  0x00, 0x65, 0x00, 0x59, 0x01, // eY (U+0065 U+0059)
  0x00, 0x65, 0x00, 0xDD, 0x01, // eÝ (U+0065 U+00DD)
  0x00, 0x65, 0x01, 0x74, 0x01, // eŴ (U+0065 U+0174)
  0x00, 0x65, 0x01, 0x76, 0x01, // eŶ (U+0065 U+0176)
  0x00, 0x65, 0x01, 0x78, 0x01, // eŸ (U+0065 U+0178)
  0x00, 0x68, 0x00, 0x22, 0x01, // h" (U+0068 U+0022)
  0x00, 0x68, 0x00, 0x27, 0x01, // h' (U+0068 U+0027)
  0x00, 0x68, 0x00, 0x56, 0x01, // hV (U+0068 U+0056)
  0x00, 0x68, 0x00, 0x57, 0x01, // hW (U+0068 U+0057)
  0x00, 0x68, 0x00, 0x59, 0x01, // hY (U+0068 U+0059)
  0x00, 0x68, 0x00, 0xDD, 0x01, // hÝ (U+0068 U+00DD)
  0x00, 0x68, 0x01, 0x74, 0x01, // hŴ (U+0068 U+0174)
  0x00, 0x68, 0x01, 0x76, 0x01, // hŶ (U+0068 U+0176)
  0x00, 0x68, 0x01, 0x78, 0x01, // hŸ (U+0068 U+0178)
  0x00, 0x6D, 0x00, 0x22, 0x01, // m" (U+006D U+0022)
  0x00, 0x6D, 0x00, 0x27, 0x01, // m' (U+006D U+0027)
  0x00, 0x6D, 0x00, 0x56, 0x01, // mV (U+006D U+0056)
  0x00, 0x6D, 0x00, 0x57, 0x01, // mW (U+006D U+0057)
  0x00, 0x6D, 0x00, 0x59, 0x01, // mY (U+006D U+0059)
  0x00, 0x6D, 0x00, 0xDD, 0x01, // mÝ (U+006D U+00DD)
  0x00, 0x6D, 0x01, 0x74, 0x01, // mŴ (U+006D U+0174)
  0x00, 0x6D, 0x01, 0x76, 0x01, // mŶ (U+006D U+0176)
  0x00, 0x6D, 0x01, 0x78, 0x01, // mŸ (U+006D U+0178)
  0x00, 0x6E, 0x00, 0x22, 0x01, // n" (U+006E U+0022)
  0x00, 0x6E, 0x00, 0x27, 0x01, // n' (U+006E U+0027)
  0x00, 0x6E, 0x00, 0x56, 0x01, // nV (U+006E U+0056)
  0x00, 0x6E, 0x00, 0x57, 0x01, // nW (U+006E U+0057)
  0x00, 0x6E, 0x00, 0x59, 0x01, // nY (U+006E U+0059)
  0x00, 0x6E, 0x00, 0xDD, 0x01, // nÝ (U+006E U+00DD)
  0x00, 0x6E, 0x01, 0x74, 0x01, // nŴ (U+006E U+0174)
  0x00, 0x6E, 0x01, 0x76, 0x01, // nŶ (U+006E U+0176)
  0x00, 0x6E, 0x01, 0x78, 0x01, // nŸ (U+006E U+0178)
  0x00, 0x6F, 0x00, 0x56, 0x01, // oV (U+006F U+0056)
  0x00, 0x6F, 0x00, 0x57, 0x01, // oW (U+006F U+0057)
  0x00, 0x6F, 0x00, 0x59, 0x01, // oY (U+006F U+0059)
  0x00, 0x6F, 0x00, 0xDD, 0x01, // oÝ (U+006F U+00DD)
  0x00, 0x6F, 0x01, 0x74, 0x01, // oŴ (U+006F U+0174)
  0x00, 0x6F, 0x01, 0x76, 0x01, // oŶ (U+006F U+0176)
  0x00, 0x6F, 0x01, 0x78, 0x01, // oŸ (U+006F U+0178)
  0x00, 0x70, 0x00, 0x56, 0x01, // pV (U+0070 U+0056)
  0x00, 0x70, 0x00, 0x57, 0x01, // pW (U+0070 U+0057)
  0x00, 0x70, 0x00, 0x59, 0x01, // pY (U+0070 U+0059)
  0x00, 0x70, 0x00, 0xDD, 0x01, // pÝ (U+0070 U+00DD)
  0x00, 0x70, 0x01, 0x74, 0x01, // pŴ (U+0070 U+0174)
  0x00, 0x70, 0x01, 0x76, 0x01, // pŶ (U+0070 U+0176)
  0x00, 0x70, 0x01, 0x78, 0x01, // pŸ (U+0070 U+0178)
  0x00, 0x72, 0x00, 0x2C, 0x02, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x02, // r. (U+0072 U+002E)
  0x00, 0x72, 0x20, 0x1A, 0x02, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x02, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x02, // r… (U+0072 U+2026)
  0x00, 0x73, 0x00, 0x59, 0x01, // sY (U+0073 U+0059)
  0x00, 0x73, 0x00, 0xDD, 0x01, // sÝ (U+0073 U+00DD)
  0x00, 0x73, 0x01, 0x76, 0x01, // sŶ (U+0073 U+0176)
  0x00, 0x73, 0x01, 0x78, 0x01, // sŸ (U+0073 U+0178)
  0x00, 0x76, 0x00, 0x2C, 0x01, // v, (U+0076 U+002C)
  0x00, 0x76, 0x00, 0x2E, 0x01, // v. (U+0076 U+002E)
  0x00, 0x76, 0x00, 0x41, 0x01, // vA (U+0076 U+0041)
  0x00, 0x76, 0x00, 0xC0, 0x01, // vÀ (U+0076 U+00C0)
  0x00, 0x76, 0x00, 0xC1, 0x01, // vÁ (U+0076 U+00C1)
  0x00, 0x76, 0x00, 0xC2, 0x01, // vÂ (U+0076 U+00C2)
  0x00, 0x76, 0x00, 0xC3, 0x01, // vÃ (U+0076 U+00C3)
  0x00, 0x76, 0x00, 0xC4, 0x01, // vÄ (U+0076 U+00C4)
  0x00, 0x76, 0x00, 0xC5, 0x01, // vÅ (U+0076 U+00C5)
  0x00, 0x76, 0x01, 0x00, 0x01, // vĀ (U+0076 U+0100)
  0x00, 0x76, 0x01, 0x02, 0x01, // vĂ (U+0076 U+0102)
  0x00, 0x76, 0x01, 0x04, 0x01, // vĄ (U+0076 U+0104)
  0x00, 0x76, 0x20, 0x1A, 0x01, // v‚ (U+0076 U+201A)
  0x00, 0x76, 0x20, 0x1E, 0x01, // v„ (U+0076 U+201E)
  0x00, 0x76, 0x20, 0x26, 0x01, // v… (U+0076 U+2026)
  0x00, 0x77, 0x00, 0x2C, 0x01, // w, (U+0077 U+002C)
  0x00, 0x77, 0x00, 0x2E, 0x01, // w. (U+0077 U+002E)
  0x00, 0x77, 0x00, 0x41, 0x01, // wA (U+0077 U+0041)
  0x00, 0x77, 0x00, 0xC0, 0x01, // wÀ (U+0077 U+00C0)
  0x00, 0x77, 0x00, 0xC1, 0x01, // wÁ (U+0077 U+00C1)
  0x00, 0x77, 0x00, 0xC2, 0x01, // wÂ (U+0077 U+00C2)
  0x00, 0x77, 0x00, 0xC3, 0x01, // wÃ (U+0077 U+00C3)
  0x00, 0x77, 0x00, 0xC4, 0x01, // wÄ (U+0077 U+00C4)
  0x00, 0x77, 0x00, 0xC5, 0x01, // wÅ (U+0077 U+00C5)
  0x00, 0x77, 0x01, 0x00, 0x01, // wĀ (U+0077 U+0100)
  0x00, 0x77, 0x01, 0x02, 0x01, // wĂ (U+0077 U+0102)
  0x00, 0x77, 0x01, 0x04, 0x01, // wĄ (U+0077 U+0104)
  0x00, 0x77, 0x20, 0x1A, 0x01, // w‚ (U+0077 U+201A)
  0x00, 0x77, 0x20, 0x1E, 0x01, // w„ (U+0077 U+201E)
  0x00, 0x77, 0x20, 0x26, 0x01, // w… (U+0077 U+2026)
  0x00, 0x79, 0x00, 0x2C, 0x01, // y, (U+0079 U+002C)
  0x00, 0x79, 0x00, 0x2E, 0x01, // y. (U+0079 U+002E)
  0x00, 0x79, 0x00, 0x41, 0x01, // yA (U+0079 U+0041)
  0x00, 0x79, 0x00, 0xC0, 0x01, // yÀ (U+0079 U+00C0)
  0x00, 0x79, 0x00, 0xC1, 0x01, // yÁ (U+0079 U+00C1)
  0x00, 0x79, 0x00, 0xC2, 0x01, // yÂ (U+0079 U+00C2)
  0x00, 0x79, 0x00, 0xC3, 0x01, // yÃ (U+0079 U+00C3)
  0x00, 0x79, 0x00, 0xC4, 0x01, // yÄ (U+0079 U+00C4)
  0x00, 0x79, 0x00, 0xC5, 0x01, // yÅ (U+0079 U+00C5)
  0x00, 0x79, 0x01, 0x00, 0x01, // yĀ (U+0079 U+0100)
  0x00, 0x79, 0x01, 0x02, 0x01, // yĂ (U+0079 U+0102)
  0x00, 0x79, 0x01, 0x04, 0x01, // yĄ (U+0079 U+0104)
  0x00, 0x79, 0x20, 0x1A, 0x01, // y‚ (U+0079 U+201A)
  0x00, 0x79, 0x20, 0x1E, 0x01, // y„ (U+0079 U+201E)
  0x00, 0x79, 0x20, 0x26, 0x01, // y… (U+0079 U+2026)
  0x00, 0xA1, 0x00, 0x56, 0x01, // ¡V (U+00A1 U+0056)
  0x00, 0xA1, 0x00, 0x59, 0x01, // ¡Y (U+00A1 U+0059)
  0x00, 0xA1, 0x00, 0xDD, 0x01, // ¡Ý (U+00A1 U+00DD)
  0x00, 0xA1, 0x01, 0x76, 0x01, // ¡Ŷ (U+00A1 U+0176)
  0x00, 0xA1, 0x01, 0x78, 0x01, // ¡Ÿ (U+00A1 U+0178)
  0x00, 0xBF, 0x00, 0x56, 0x01, // ¿V (U+00BF U+0056)
  0x00, 0xBF, 0x00, 0x57, 0x01, // ¿W (U+00BF U+0057)
  0x00, 0xBF, 0x00, 0x59, 0x01, // ¿Y (U+00BF U+0059)
  0x00, 0xBF, 0x00, 0xDD, 0x01, // ¿Ý (U+00BF U+00DD)
  0x00, 0xBF, 0x01, 0x74, 0x01, // ¿Ŵ (U+00BF U+0174)
  0x00, 0xBF, 0x01, 0x76, 0x01, // ¿Ŷ (U+00BF U+0176)
  0x00, 0xBF, 0x01, 0x78, 0x01, // ¿Ÿ (U+00BF U+0178)
  0x00, 0xC0, 0x00, 0x22, 0x01, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x01, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x00, 0x2A, 0x01, // À* (U+00C0 U+002A)
  0x00, 0xC0, 0x00, 0x3F, 0x01, // À? (U+00C0 U+003F)
  0x00, 0xC0, 0x00, 0x54, 0x01, // ÀT (U+00C0 U+0054)
  0x00, 0xC0, 0x00, 0x56, 0x01, // ÀV (U+00C0 U+0056)
  0x00, 0xC0, 0x00, 0x57, 0x01, // ÀW (U+00C0 U+0057)
  0x00, 0xC0, 0x00, 0x59, 0x01, // ÀY (U+00C0 U+0059)
  0x00, 0xC0, 0x00, 0x76, 0x01, // Àv (U+00C0 U+0076)
  0x00, 0xC0, 0x00, 0x77, 0x01, // Àw (U+00C0 U+0077)
  0x00, 0xC0, 0x00, 0x79, 0x01, // Ày (U+00C0 U+0079)
  0x00, 0xC0, 0x00, 0xDD, 0x01, // ÀÝ (U+00C0 U+00DD)
  0x00, 0xC0, 0x00, 0xFD, 0x01, // Àý (U+00C0 U+00FD)
  0x00, 0xC0, 0x00, 0xFF, 0x01, // Àÿ (U+00C0 U+00FF)
  0x00, 0xC0, 0x01, 0x62, 0x01, // ÀŢ (U+00C0 U+0162)
  0x00, 0xC0, 0x01, 0x64, 0x01, // ÀŤ (U+00C0 U+0164)
  0x00, 0xC0, 0x01, 0x66, 0x01, // ÀŦ (U+00C0 U+0166)
  0x00, 0xC0, 0x01, 0x74, 0x01, // ÀŴ (U+00C0 U+0174)
  0x00, 0xC0, 0x01, 0x75, 0x01, // Àŵ (U+00C0 U+0175)
  0x00, 0xC0, 0x01, 0x76, 0x01, // ÀŶ (U+00C0 U+0176)
  0x00, 0xC0, 0x01, 0x77, 0x01, // Àŷ (U+00C0 U+0177)
  0x00, 0xC0, 0x01, 0x78, 0x01, // ÀŸ (U+00C0 U+0178)
  0x00, 0xC0, 0x20, 0x18, 0x01, // À‘ (U+00C0 U+2018)
  0x00, 0xC0, 0x20, 0x19, 0x01, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1C, 0x01, // À“ (U+00C0 U+201C)
  0x00, 0xC0, 0x20, 0x1D, 0x01, // À” (U+00C0 U+201D)
  0x00, 0xC0, 0x21, 0x22, 0x01, // À™ (U+00C0 U+2122)
  0x00, 0xC1, 0x00, 0x22, 0x01, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x01, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x00, 0x2A, 0x01, // Á* (U+00C1 U+002A)
  0x00, 0xC1, 0x00, 0x3F, 0x01, // Á? (U+00C1 U+003F)
  0x00, 0xC1, 0x00, 0x54, 0x01, // ÁT (U+00C1 U+0054)
  0x00, 0xC1, 0x00, 0x56, 0x01, // ÁV (U+00C1 U+0056)
  0x00, 0xC1, 0x00, 0x57, 0x01, // ÁW (U+00C1 U+0057)
  0x00, 0xC1, 0x00, 0x59, 0x01, // ÁY (U+00C1 U+0059)
  0x00, 0xC1, 0x00, 0x76, 0x01, // Áv (U+00C1 U+0076)
  0x00, 0xC1, 0x00, 0x77, 0x01, // Áw (U+00C1 U+0077)
  0x00, 0xC1, 0x00, 0x79, 0x01, // Áy (U+00C1 U+0079)
  0x00, 0xC1, 0x00, 0xDD, 0x01, // ÁÝ (U+00C1 U+00DD)
  0x00, 0xC1, 0x00, 0xFD, 0x01, // Áý (U+00C1 U+00FD)
  0x00, 0xC1, 0x00, 0xFF, 0x01, // Áÿ (U+00C1 U+00FF)
  0x00, 0xC1, 0x01, 0x62, 0x01, // ÁŢ (U+00C1 U+0162)
  0x00, 0xC1, 0x01, 0x64, 0x01, // ÁŤ (U+00C1 U+0164)
  0x00, 0xC1, 0x01, 0x66, 0x01, // ÁŦ (U+00C1 U+0166)
  0x00, 0xC1, 0x01, 0x74, 0x01, // ÁŴ (U+00C1 U+0174)
  0x00, 0xC1, 0x01, 0x75, 0x01, // Áŵ (U+00C1 U+0175)
  0x00, 0xC1, 0x01, 0x76, 0x01, // ÁŶ (U+00C1 U+0176)
  0x00, 0xC1, 0x01, 0x77, 0x01, // Áŷ (U+00C1 U+0177)
  0x00, 0xC1, 0x01, 0x78, 0x01, // ÁŸ (U+00C1 U+0178)
  0x00, 0xC1, 0x20, 0x18, 0x01, // Á‘ (U+00C1 U+2018)
  0x00, 0xC1, 0x20, 0x19, 0x01, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1C, 0x01, // Á“ (U+00C1 U+201C)
  0x00, 0xC1, 0x20, 0x1D, 0x01, // Á” (U+00C1 U+201D)
  0x00, 0xC1, 0x21, 0x22, 0x01, // Á™ (U+00C1 U+2122)
  0x00, 0xC2, 0x00, 0x22, 0x01, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x01, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x00, 0x2A, 0x01, // Â* (U+00C2 U+002A)
  0x00, 0xC2, 0x00, 0x3F, 0x01, // Â? (U+00C2 U+003F)
  0x00, 0xC2, 0x00, 0x54, 0x01, // ÂT (U+00C2 U+0054)
  0x00, 0xC2, 0x00, 0x56, 0x01, // ÂV (U+00C2 U+0056)
  0x00, 0xC2, 0x00, 0x57, 0x01, // ÂW (U+00C2 U+0057)
  0x00, 0xC2, 0x00, 0x59, 0x01, // ÂY (U+00C2 U+0059)
  0x00, 0xC2, 0x00, 0x76, 0x01, // Âv (U+00C2 U+0076)
  0x00, 0xC2, 0x00, 0x77, 0x01, // Âw (U+00C2 U+0077)
  0x00, 0xC2, 0x00, 0x79, 0x01, // Ây (U+00C2 U+0079)
  0x00, 0xC2, 0x00, 0xDD, 0x01, // ÂÝ (U+00C2 U+00DD)
  0x00, 0xC2, 0x00, 0xFD, 0x01, // Âý (U+00C2 U+00FD)
  0x00, 0xC2, 0x00, 0xFF, 0x01, // Âÿ (U+00C2 U+00FF)
  0x00, 0xC2, 0x01, 0x62, 0x01, // ÂŢ (U+00C2 U+0162)
  0x00, 0xC2, 0x01, 0x64, 0x01, // ÂŤ (U+00C2 U+0164)
  0x00, 0xC2, 0x01, 0x66, 0x01, // ÂŦ (U+00C2 U+0166)
  0x00, 0xC2, 0x01, 0x74, 0x01, // ÂŴ (U+00C2 U+0174)
  0x00, 0xC2, 0x01, 0x75, 0x01, // Âŵ (U+00C2 U+0175)
  0x00, 0xC2, 0x01, 0x76, 0x01, // ÂŶ (U+00C2 U+0176)
  0x00, 0xC2, 0x01, 0x77, 0x01, // Âŷ (U+00C2 U+0177)
  0x00, 0xC2, 0x01, 0x78, 0x01, // ÂŸ (U+00C2 U+0178)
  0x00, 0xC2, 0x20, 0x18, 0x01, // Â‘ (U+00C2 U+2018)
  0x00, 0xC2, 0x20, 0x19, 0x01, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1C, 0x01, // Â“ (U+00C2 U+201C)
  0x00, 0xC2, 0x20, 0x1D, 0x01, // Â” (U+00C2 U+201D)
  0x00, 0xC2, 0x21, 0x22, 0x01, // Â™ (U+00C2 U+2122)
  0x00, 0xC3, 0x00, 0x22, 0x01, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x01, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x00, 0x2A, 0x01, // Ã* (U+00C3 U+002A)
  0x00, 0xC3, 0x00, 0x3F, 0x01, // Ã? (U+00C3 U+003F)
  0x00, 0xC3, 0x00, 0x54, 0x01, // ÃT (U+00C3 U+0054)
  0x00, 0xC3, 0x00, 0x56, 0x01, // ÃV (U+00C3 U+0056)
  0x00, 0xC3, 0x00, 0x57, 0x01, // ÃW (U+00C3 U+0057)
  0x00, 0xC3, 0x00, 0x59, 0x01, // ÃY (U+00C3 U+0059)
  0x00, 0xC3, 0x00, 0x76, 0x01, // Ãv (U+00C3 U+0076)
  0x00, 0xC3, 0x00, 0x77, 0x01, // Ãw (U+00C3 U+0077)
  0x00, 0xC3, 0x00, 0x79, 0x01, // Ãy (U+00C3 U+0079)
  0x00, 0xC3, 0x00, 0xDD, 0x01, // ÃÝ (U+00C3 U+00DD)
  0x00, 0xC3, 0x00, 0xFD, 0x01, // Ãý (U+00C3 U+00FD)
  0x00, 0xC3, 0x00, 0xFF, 0x01, // Ãÿ (U+00C3 U+00FF)
  0x00, 0xC3, 0x01, 0x62, 0x01, // ÃŢ (U+00C3 U+0162)
  0x00, 0xC3, 0x01, 0x64, 0x01, // ÃŤ (U+00C3 U+0164)
  0x00, 0xC3, 0x01, 0x66, 0x01, // ÃŦ (U+00C3 U+0166)
  0x00, 0xC3, 0x01, 0x74, 0x01, // ÃŴ (U+00C3 U+0174)
  0x00, 0xC3, 0x01, 0x75, 0x01, // Ãŵ (U+00C3 U+0175)
  0x00, 0xC3, 0x01, 0x76, 0x01, // ÃŶ (U+00C3 U+0176)
  0x00, 0xC3, 0x01, 0x77, 0x01, // Ãŷ (U+00C3 U+0177)
  0x00, 0xC3, 0x01, 0x78, 0x01, // ÃŸ (U+00C3 U+0178)
  0x00, 0xC3, 0x20, 0x18, 0x01, // Ã‘ (U+00C3 U+2018)
  0x00, 0xC3, 0x20, 0x19, 0x01, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1C, 0x01, // Ã“ (U+00C3 U+201C)
  0x00, 0xC3, 0x20, 0x1D, 0x01, // Ã” (U+00C3 U+201D)
  0x00, 0xC3, 0x21, 0x22, 0x01, // Ã™ (U+00C3 U+2122)
  0x00, 0xC4, 0x00, 0x22, 0x01, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x01, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x00, 0x2A, 0x01, // Ä* (U+00C4 U+002A)
  0x00, 0xC4, 0x00, 0x3F, 0x01, // Ä? (U+00C4 U+003F)
  0x00, 0xC4, 0x00, 0x54, 0x01, // ÄT (U+00C4 U+0054)
  0x00, 0xC4, 0x00, 0x56, 0x01, // ÄV (U+00C4 U+0056)
  0x00, 0xC4, 0x00, 0x57, 0x01, // ÄW (U+00C4 U+0057)
  0x00, 0xC4, 0x00, 0x59, 0x01, // ÄY (U+00C4 U+0059)
  0x00, 0xC4, 0x00, 0x76, 0x01, // Äv (U+00C4 U+0076)
  0x00, 0xC4, 0x00, 0x77, 0x01, // Äw (U+00C4 U+0077)
  0x00, 0xC4, 0x00, 0x79, 0x01, // Äy (U+00C4 U+0079)
  0x00, 0xC4, 0x00, 0xDD, 0x01, // ÄÝ (U+00C4 U+00DD)
  0x00, 0xC4, 0x00, 0xFD, 0x01, // Äý (U+00C4 U+00FD)
  0x00, 0xC4, 0x00, 0xFF, 0x01, // Äÿ (U+00C4 U+00FF)
  0x00, 0xC4, 0x01, 0x62, 0x01, // ÄŢ (U+00C4 U+0162)
  0x00, 0xC4, 0x01, 0x64, 0x01, // ÄŤ (U+00C4 U+0164)
  0x00, 0xC4, 0x01, 0x66, 0x01, // ÄŦ (U+00C4 U+0166)
  0x00, 0xC4, 0x01, 0x74, 0x01, // ÄŴ (U+00C4 U+0174)
  0x00, 0xC4, 0x01, 0x75, 0x01, // Äŵ (U+00C4 U+0175)
  0x00, 0xC4, 0x01, 0x76, 0x01, // ÄŶ (U+00C4 U+0176)
  0x00, 0xC4, 0x01, 0x77, 0x01, // Äŷ (U+00C4 U+0177)
  0x00, 0xC4, 0x01, 0x78, 0x01, // ÄŸ (U+00C4 U+0178)
  0x00, 0xC4, 0x20, 0x18, 0x01, // Ä‘ (U+00C4 U+2018)
  0x00, 0xC4, 0x20, 0x19, 0x01, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1C, 0x01, // Ä“ (U+00C4 U+201C)
  0x00, 0xC4, 0x20, 0x1D, 0x01, // Ä” (U+00C4 U+201D)
  0x00, 0xC4, 0x21, 0x22, 0x01, // Ä™ (U+00C4 U+2122)
  0x00, 0xC5, 0x00, 0x22, 0x01, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x01, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x00, 0x2A, 0x01, // Å* (U+00C5 U+002A)
  0x00, 0xC5, 0x00, 0x3F, 0x01, // Å? (U+00C5 U+003F)
  0x00, 0xC5, 0x00, 0x54, 0x01, // ÅT (U+00C5 U+0054)
  0x00, 0xC5, 0x00, 0x56, 0x01, // ÅV (U+00C5 U+0056)
  0x00, 0xC5, 0x00, 0x57, 0x01, // ÅW (U+00C5 U+0057)
  0x00, 0xC5, 0x00, 0x59, 0x01, // ÅY (U+00C5 U+0059)
  0x00, 0xC5, 0x00, 0x76, 0x01, // Åv (U+00C5 U+0076)
  0x00, 0xC5, 0x00, 0x77, 0x01, // Åw (U+00C5 U+0077)
  0x00, 0xC5, 0x00, 0x79, 0x01, // Åy (U+00C5 U+0079)
  0x00, 0xC5, 0x00, 0xDD, 0x01, // ÅÝ (U+00C5 U+00DD)
  0x00, 0xC5, 0x00, 0xFD, 0x01, // Åý (U+00C5 U+00FD)
  0x00, 0xC5, 0x00, 0xFF, 0x01, // Åÿ (U+00C5 U+00FF)
  0x00, 0xC5, 0x01, 0x62, 0x01, // ÅŢ (U+00C5 U+0162)
  0x00, 0xC5, 0x01, 0x64, 0x01, // ÅŤ (U+00C5 U+0164)
  0x00, 0xC5, 0x01, 0x66, 0x01, // ÅŦ (U+00C5 U+0166)
  0x00, 0xC5, 0x01, 0x74, 0x01, // ÅŴ (U+00C5 U+0174)
  0x00, 0xC5, 0x01, 0x75, 0x01, // Åŵ (U+00C5 U+0175)
  0x00, 0xC5, 0x01, 0x76, 0x01, // ÅŶ (U+00C5 U+0176)
  0x00, 0xC5, 0x01, 0x77, 0x01, // Åŷ (U+00C5 U+0177)
  0x00, 0xC5, 0x01, 0x78, 0x01, // ÅŸ (U+00C5 U+0178)
  0x00, 0xC5, 0x20, 0x18, 0x01, // Å‘ (U+00C5 U+2018)
  0x00, 0xC5, 0x20, 0x19, 0x01, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1C, 0x01, // Å“ (U+00C5 U+201C)
  0x00, 0xC5, 0x20, 0x1D, 0x01, // Å” (U+00C5 U+201D)
  0x00, 0xC5, 0x21, 0x22, 0x01, // Å™ (U+00C5 U+2122)
  0x00, 0xD0, 0x00, 0x59, 0x01, // ÐY (U+00D0 U+0059)
  0x00, 0xD0, 0x00, 0xC6, 0x01, // ÐÆ (U+00D0 U+00C6)
  0x00, 0xD0, 0x00, 0xDD, 0x01, // ÐÝ (U+00D0 U+00DD)
  0x00, 0xD0, 0x01, 0x76, 0x01, // ÐŶ (U+00D0 U+0176)
  0x00, 0xD0, 0x01, 0x78, 0x01, // ÐŸ (U+00D0 U+0178)
  0x00, 0xD2, 0x00, 0x59, 0x01, // ÒY (U+00D2 U+0059)
  0x00, 0xD2, 0x00, 0xC6, 0x01, // ÒÆ (U+00D2 U+00C6)
  0x00, 0xD2, 0x00, 0xDD, 0x01, // ÒÝ (U+00D2 U+00DD)
  0x00, 0xD2, 0x01, 0x76, 0x01, // ÒŶ (U+00D2 U+0176)
  0x00, 0xD2, 0x01, 0x78, 0x01, // ÒŸ (U+00D2 U+0178)
  0x00, 0xD3, 0x00, 0x59, 0x01, // ÓY (U+00D3 U+0059)
  0x00, 0xD3, 0x00, 0xC6, 0x01, // ÓÆ (U+00D3 U+00C6)
  0x00, 0xD3, 0x00, 0xDD, 0x01, // ÓÝ (U+00D3 U+00DD)
  0x00, 0xD3, 0x01, 0x76, 0x01, // ÓŶ (U+00D3 U+0176)
  0x00, 0xD3, 0x01, 0x78, 0x01, // ÓŸ (U+00D3 U+0178)
  0x00, 0xD4, 0x00, 0x59, 0x01, // ÔY (U+00D4 U+0059)
  0x00, 0xD4, 0x00, 0xC6, 0x01, // ÔÆ (U+00D4 U+00C6)
  0x00, 0xD4, 0x00, 0xDD, 0x01, // ÔÝ (U+00D4 U+00DD)
  0x00, 0xD4, 0x01, 0x76, 0x01, // ÔŶ (U+00D4 U+0176)
  0x00, 0xD4, 0x01, 0x78, 0x01, // ÔŸ (U+00D4 U+0178)
  0x00, 0xD5, 0x00, 0x59, 0x01, // ÕY (U+00D5 U+0059)
  0x00, 0xD5, 0x00, 0xC6, 0x01, // ÕÆ (U+00D5 U+00C6)
  0x00, 0xD5, 0x00, 0xDD, 0x01, // ÕÝ (U+00D5 U+00DD)
  0x00, 0xD5, 0x01, 0x76, 0x01, // ÕŶ (U+00D5 U+0176)
  0x00, 0xD5, 0x01, 0x78, 0x01, // ÕŸ (U+00D5 U+0178)
  0x00, 0xD6, 0x00, 0x59, 0x01, // ÖY (U+00D6 U+0059)
  0x00, 0xD6, 0x00, 0xC6, 0x01, // ÖÆ (U+00D6 U+00C6)
  0x00, 0xD6, 0x00, 0xDD, 0x01, // ÖÝ (U+00D6 U+00DD)
  0x00, 0xD6, 0x01, 0x76, 0x01, // ÖŶ (U+00D6 U+0176)
  0x00, 0xD6, 0x01, 0x78, 0x01, // ÖŸ (U+00D6 U+0178)
  0x00, 0xD8, 0x00, 0x59, 0x01, // ØY (U+00D8 U+0059)
  0x00, 0xD8, 0x00, 0xC6, 0x01, // ØÆ (U+00D8 U+00C6)
  0x00, 0xD8, 0x00, 0xDD, 0x01, // ØÝ (U+00D8 U+00DD)
  0x00, 0xD8, 0x01, 0x76, 0x01, // ØŶ (U+00D8 U+0176)
  0x00, 0xD8, 0x01, 0x78, 0x01, // ØŸ (U+00D8 U+0178)
  0x00, 0xD9, 0x00, 0xC6, 0x01, // ÙÆ (U+00D9 U+00C6)
  0x00, 0xDA, 0x00, 0xC6, 0x01, // ÚÆ (U+00DA U+00C6)
  0x00, 0xDB, 0x00, 0xC6, 0x01, // ÛÆ (U+00DB U+00C6)
  0x00, 0xDC, 0x00, 0xC6, 0x01, // ÜÆ (U+00DC U+00C6)
  0x00, 0xDD, 0x00, 0x2C, 0x01, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x01, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x00, 0x40, 0x01, // Ý@ (U+00DD U+0040)
  0x00, 0xDD, 0x00, 0x41, 0x01, // ÝA (U+00DD U+0041)
  0x00, 0xDD, 0x00, 0x43, 0x01, // ÝC (U+00DD U+0043)
  0x00, 0xDD, 0x00, 0x47, 0x01, // ÝG (U+00DD U+0047)
  0x00, 0xDD, 0x00, 0x4F, 0x01, // ÝO (U+00DD U+004F)
  0x00, 0xDD, 0x00, 0x51, 0x01, // ÝQ (U+00DD U+0051)
  0x00, 0xDD, 0x00, 0x61, 0x01, // Ýa (U+00DD U+0061)
  0x00, 0xDD, 0x00, 0x63, 0x01, // Ýc (U+00DD U+0063)
  0x00, 0xDD, 0x00, 0x64, 0x01, // Ýd (U+00DD U+0064)
  0x00, 0xDD, 0x00, 0x65, 0x01, // Ýe (U+00DD U+0065)
  0x00, 0xDD, 0x00, 0x67, 0x01, // Ýg (U+00DD U+0067)
  0x00, 0xDD, 0x00, 0x6F, 0x01, // Ýo (U+00DD U+006F)
  0x00, 0xDD, 0x00, 0x71, 0x01, // Ýq (U+00DD U+0071)
  0x00, 0xDD, 0x00, 0x73, 0x01, // Ýs (U+00DD U+0073)
  0x00, 0xDD, 0x00, 0xC0, 0x01, // ÝÀ (U+00DD U+00C0)
  0x00, 0xDD, 0x00, 0xC1, 0x01, // ÝÁ (U+00DD U+00C1)
  0x00, 0xDD, 0x00, 0xC2, 0x01, // ÝÂ (U+00DD U+00C2)
  0x00, 0xDD, 0x00, 0xC3, 0x01, // ÝÃ (U+00DD U+00C3)
  0x00, 0xDD, 0x00, 0xC4, 0x01, // ÝÄ (U+00DD U+00C4)
  0x00, 0xDD, 0x00, 0xC5, 0x01, // ÝÅ (U+00DD U+00C5)
  0x00, 0xDD, 0x00, 0xC6, 0x01, // ÝÆ (U+00DD U+00C6)
  0x00, 0xDD, 0x00, 0xC7, 0x01, // ÝÇ (U+00DD U+00C7)
  0x00, 0xDD, 0x00, 0xD2, 0x01, // ÝÒ (U+00DD U+00D2)
  0x00, 0xDD, 0x00, 0xD3, 0x01, // ÝÓ (U+00DD U+00D3)
  0x00, 0xDD, 0x00, 0xD4, 0x01, // ÝÔ (U+00DD U+00D4)
  0x00, 0xDD, 0x00, 0xD5, 0x01, // ÝÕ (U+00DD U+00D5)
  0x00, 0xDD, 0x00, 0xD6, 0x01, // ÝÖ (U+00DD U+00D6)
  0x00, 0xDD, 0x00, 0xD8, 0x01, // ÝØ (U+00DD U+00D8)
  0x00, 0xDD, 0x00, 0xE0, 0x01, // Ýà (U+00DD U+00E0)
  0x00, 0xDD, 0x00, 0xE1, 0x01, // Ýá (U+00DD U+00E1)
  0x00, 0xDD, 0x00, 0xE2, 0x01, // Ýâ (U+00DD U+00E2)
  0x00, 0xDD, 0x00, 0xE3, 0x01, // Ýã (U+00DD U+00E3)
  0x00, 0xDD, 0x00, 0xE4, 0x01, // Ýä (U+00DD U+00E4)
  0x00, 0xDD, 0x00, 0xE5, 0x01, // Ýå (U+00DD U+00E5)
  0x00, 0xDD, 0x00, 0xE6, 0x01, // Ýæ (U+00DD U+00E6)
  0x00, 0xDD, 0x00, 0xE7, 0x01, // Ýç (U+00DD U+00E7)
  0x00, 0xDD, 0x00, 0xE8, 0x01, // Ýè (U+00DD U+00E8)
  0x00, 0xDD, 0x00, 0xE9, 0x01, // Ýé (U+00DD U+00E9)
  0x00, 0xDD, 0x00, 0xEA, 0x01, // Ýê (U+00DD U+00EA)
  0x00, 0xDD, 0x00, 0xEB, 0x01, // Ýë (U+00DD U+00EB)
  0x00, 0xDD, 0x00, 0xF0, 0x01, // Ýð (U+00DD U+00F0)
  0x00, 0xDD, 0x00, 0xF2, 0x01, // Ýò (U+00DD U+00F2)
  0x00, 0xDD, 0x00, 0xF3, 0x01, // Ýó (U+00DD U+00F3)
  0x00, 0xDD, 0x00, 0xF4, 0x01, // Ýô (U+00DD U+00F4)
  0x00, 0xDD, 0x00, 0xF5, 0x01, // Ýõ (U+00DD U+00F5)
  0x00, 0xDD, 0x00, 0xF6, 0x01, // Ýö (U+00DD U+00F6)
  0x00, 0xDD, 0x00, 0xF8, 0x01, // Ýø (U+00DD U+00F8)
  0x00, 0xDD, 0x01, 0x00, 0x01, // ÝĀ (U+00DD U+0100)
  0x00, 0xDD, 0x01, 0x01, 0x01, // Ýā (U+00DD U+0101)
  0x00, 0xDD, 0x01, 0x02, 0x01, // ÝĂ (U+00DD U+0102)
  0x00, 0xDD, 0x01, 0x03, 0x01, // Ýă (U+00DD U+0103)
  0x00, 0xDD, 0x01, 0x04, 0x01, // ÝĄ (U+00DD U+0104)
  0x00, 0xDD, 0x01, 0x05, 0x01, // Ýą (U+00DD U+0105)
  0x00, 0xDD, 0x01, 0x06, 0x01, // ÝĆ (U+00DD U+0106)
  0x00, 0xDD, 0x01, 0x07, 0x01, // Ýć (U+00DD U+0107)
  0x00, 0xDD, 0x01, 0x08, 0x01, // ÝĈ (U+00DD U+0108)
  0x00, 0xDD, 0x01, 0x09, 0x01, // Ýĉ (U+00DD U+0109)
  0x00, 0xDD, 0x01, 0x0A, 0x01, // ÝĊ (U+00DD U+010A)
  0x00, 0xDD, 0x01, 0x0B, 0x01, // Ýċ (U+00DD U+010B)
  0x00, 0xDD, 0x01, 0x0C, 0x01, // ÝČ (U+00DD U+010C)
  0x00, 0xDD, 0x01, 0x0D, 0x01, // Ýč (U+00DD U+010D)
  0x00, 0xDD, 0x01, 0x0F, 0x01, // Ýď (U+00DD U+010F)
  0x00, 0xDD, 0x01, 0x11, 0x01, // Ýđ (U+00DD U+0111)
  0x00, 0xDD, 0x01, 0x13, 0x01, // Ýē (U+00DD U+0113)
  0x00, 0xDD, 0x01, 0x15, 0x01, // Ýĕ (U+00DD U+0115)
  0x00, 0xDD, 0x01, 0x17, 0x01, // Ýė (U+00DD U+0117)
  0x00, 0xDD, 0x01, 0x19, 0x01, // Ýę (U+00DD U+0119)
  0x00, 0xDD, 0x01, 0x1B, 0x01, // Ýě (U+00DD U+011B)
  0x00, 0xDD, 0x01, 0x1C, 0x01, // ÝĜ (U+00DD U+011C)
  0x00, 0xDD, 0x01, 0x1D, 0x01, // Ýĝ (U+00DD U+011D)
  0x00, 0xDD, 0x01, 0x1E, 0x01, // ÝĞ (U+00DD U+011E)
  0x00, 0xDD, 0x01, 0x1F, 0x01, // Ýğ (U+00DD U+011F)
  0x00, 0xDD, 0x01, 0x20, 0x01, // ÝĠ (U+00DD U+0120)
  0x00, 0xDD, 0x01, 0x21, 0x01, // Ýġ (U+00DD U+0121)
  0x00, 0xDD, 0x01, 0x22, 0x01, // ÝĢ (U+00DD U+0122)
  0x00, 0xDD, 0x01, 0x23, 0x01, // Ýģ (U+00DD U+0123)
  0x00, 0xDD, 0x01, 0x4C, 0x01, // ÝŌ (U+00DD U+014C)
  0x00, 0xDD, 0x01, 0x4D, 0x01, // Ýō (U+00DD U+014D)
  0x00, 0xDD, 0x01, 0x4E, 0x01, // ÝŎ (U+00DD U+014E)
  0x00, 0xDD, 0x01, 0x4F, 0x01, // Ýŏ (U+00DD U+014F)
  0x00, 0xDD, 0x01, 0x50, 0x01, // ÝŐ (U+00DD U+0150)
  0x00, 0xDD, 0x01, 0x51, 0x01, // Ýő (U+00DD U+0151)
  0x00, 0xDD, 0x01, 0x52, 0x01, // ÝŒ (U+00DD U+0152)
  0x00, 0xDD, 0x01, 0x53, 0x01, // Ýœ (U+00DD U+0153)
  0x00, 0xDD, 0x01, 0x5B, 0x01, // Ýś (U+00DD U+015B)
  0x00, 0xDD, 0x01, 0x5D, 0x01, // Ýŝ (U+00DD U+015D)
  0x00, 0xDD, 0x01, 0x5F, 0x01, // Ýş (U+00DD U+015F)
  0x00, 0xDD, 0x01, 0x61, 0x01, // Ýš (U+00DD U+0161)
  0x00, 0xDD, 0x20, 0x1A, 0x01, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x01, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x01, // Ý… (U+00DD U+2026)
  0x00, 0xDE, 0x00, 0x59, 0x01, // ÞY (U+00DE U+0059)
  0x00, 0xDE, 0x00, 0xC6, 0x01, // ÞÆ (U+00DE U+00C6)
  0x00, 0xDE, 0x00, 0xDD, 0x01, // ÞÝ (U+00DE U+00DD)
  0x00, 0xDE, 0x01, 0x76, 0x01, // ÞŶ (U+00DE U+0176)
  0x00, 0xDE, 0x01, 0x78, 0x01, // ÞŸ (U+00DE U+0178)
  0x00, 0xDF, 0x00, 0x56, 0x01, // ßV (U+00DF U+0056)
  0x00, 0xDF, 0x00, 0x57, 0x01, // ßW (U+00DF U+0057)
  0x00, 0xDF, 0x00, 0x59, 0x01, // ßY (U+00DF U+0059)
  0x00, 0xDF, 0x00, 0xDD, 0x01, // ßÝ (U+00DF U+00DD)
  0x00, 0xDF, 0x01, 0x74, 0x01, // ßŴ (U+00DF U+0174)
  0x00, 0xDF, 0x01, 0x76, 0x01, // ßŶ (U+00DF U+0176)
  0x00, 0xDF, 0x01, 0x78, 0x01, // ßŸ (U+00DF U+0178)
  0x00, 0xE0, 0x00, 0x22, 0x01, // à" (U+00E0 U+0022)
  0x00, 0xE0, 0x00, 0x27, 0x01, // à' (U+00E0 U+0027)
  0x00, 0xE0, 0x00, 0x56, 0x01, // àV (U+00E0 U+0056)
  0x00, 0xE0, 0x00, 0x57, 0x01, // àW (U+00E0 U+0057)
  0x00, 0xE0, 0x00, 0x59, 0x01, // àY (U+00E0 U+0059)
  0x00, 0xE0, 0x00, 0xDD, 0x01, // àÝ (U+00E0 U+00DD)
  0x00, 0xE0, 0x01, 0x74, 0x01, // àŴ (U+00E0 U+0174)
  0x00, 0xE0, 0x01, 0x76, 0x01, // àŶ (U+00E0 U+0176)
  0x00, 0xE0, 0x01, 0x78, 0x01, // àŸ (U+00E0 U+0178)
  0x00, 0xE1, 0x00, 0x22, 0x01, // á" (U+00E1 U+0022)
  0x00, 0xE1, 0x00, 0x27, 0x01, // á' (U+00E1 U+0027)
  0x00, 0xE1, 0x00, 0x56, 0x01, // áV (U+00E1 U+0056)
  0x00, 0xE1, 0x00, 0x57, 0x01, // áW (U+00E1 U+0057)
  0x00, 0xE1, 0x00, 0x59, 0x01, // áY (U+00E1 U+0059)
  0x00, 0xE1, 0x00, 0xDD, 0x01, // áÝ (U+00E1 U+00DD)
  0x00, 0xE1, 0x01, 0x74, 0x01, // áŴ (U+00E1 U+0174)
  0x00, 0xE1, 0x01, 0x76, 0x01, // áŶ (U+00E1 U+0176)
  0x00, 0xE1, 0x01, 0x78, 0x01, // áŸ (U+00E1 U+0178)
  0x00, 0xE2, 0x00, 0x22, 0x01, // â" (U+00E2 U+0022)
  0x00, 0xE2, 0x00, 0x27, 0x01, // â' (U+00E2 U+0027)
  0x00, 0xE2, 0x00, 0x56, 0x01, // âV (U+00E2 U+0056)
  0x00, 0xE2, 0x00, 0x57, 0x01, // âW (U+00E2 U+0057)
  0x00, 0xE2, 0x00, 0x59, 0x01, // âY (U+00E2 U+0059)
  0x00, 0xE2, 0x00, 0xDD, 0x01, // âÝ (U+00E2 U+00DD)
  0x00, 0xE2, 0x01, 0x74, 0x01, // âŴ (U+00E2 U+0174)
  0x00, 0xE2, 0x01, 0x76, 0x01, // âŶ (U+00E2 U+0176)
  0x00, 0xE2, 0x01, 0x78, 0x01, // âŸ (U+00E2 U+0178)
  0x00, 0xE3, 0x00, 0x22, 0x01, // ã" (U+00E3 U+0022)
  0x00, 0xE3, 0x00, 0x27, 0x01, // ã' (U+00E3 U+0027)
  0x00, 0xE3, 0x00, 0x56, 0x01, // ãV (U+00E3 U+0056)
  0x00, 0xE3, 0x00, 0x57, 0x01, // ãW (U+00E3 U+0057)
  0x00, 0xE3, 0x00, 0x59, 0x01, // ãY (U+00E3 U+0059)
  0x00, 0xE3, 0x00, 0xDD, 0x01, // ãÝ (U+00E3 U+00DD)
  0x00, 0xE3, 0x01, 0x74, 0x01, // ãŴ (U+00E3 U+0174)
  0x00, 0xE3, 0x01, 0x76, 0x01, // ãŶ (U+00E3 U+0176)
  0x00, 0xE3, 0x01, 0x78, 0x01, // ãŸ (U+00E3 U+0178)
  0x00, 0xE4, 0x00, 0x22, 0x01, // ä" (U+00E4 U+0022)
  0x00, 0xE4, 0x00, 0x27, 0x01, // ä' (U+00E4 U+0027)
  0x00, 0xE4, 0x00, 0x56, 0x01, // äV (U+00E4 U+0056)
  0x00, 0xE4, 0x00, 0x57, 0x01, // äW (U+00E4 U+0057)
  0x00, 0xE4, 0x00, 0x59, 0x01, // äY (U+00E4 U+0059)
  0x00, 0xE4, 0x00, 0xDD, 0x01, // äÝ (U+00E4 U+00DD)
  0x00, 0xE4, 0x01, 0x74, 0x01, // äŴ (U+00E4 U+0174)
  0x00, 0xE4, 0x01, 0x76, 0x01, // äŶ (U+00E4 U+0176)
  0x00, 0xE4, 0x01, 0x78, 0x01, // äŸ (U+00E4 U+0178)
  0x00, 0xE5, 0x00, 0x22, 0x01, // å" (U+00E5 U+0022)
  0x00, 0xE5, 0x00, 0x27, 0x01, // å' (U+00E5 U+0027)
  0x00, 0xE5, 0x00, 0x56, 0x01, // åV (U+00E5 U+0056)
  0x00, 0xE5, 0x00, 0x57, 0x01, // åW (U+00E5 U+0057)
  0x00, 0xE5, 0x00, 0x59, 0x01, // åY (U+00E5 U+0059)
  0x00, 0xE5, 0x00, 0xDD, 0x01, // åÝ (U+00E5 U+00DD)
  0x00, 0xE5, 0x01, 0x74, 0x01, // åŴ (U+00E5 U+0174)
  0x00, 0xE5, 0x01, 0x76, 0x01, // åŶ (U+00E5 U+0176)
  0x00, 0xE5, 0x01, 0x78, 0x01, // åŸ (U+00E5 U+0178)
  0x00, 0xE6, 0x00, 0x56, 0x01, // æV (U+00E6 U+0056)
  0x00, 0xE6, 0x00, 0x57, 0x01, // æW (U+00E6 U+0057)
  0x00, 0xE6, 0x00, 0x59, 0x01, // æY (U+00E6 U+0059)
  0x00, 0xE6, 0x00, 0xDD, 0x01, // æÝ (U+00E6 U+00DD)
  0x00, 0xE6, 0x01, 0x74, 0x01, // æŴ (U+00E6 U+0174)
  0x00, 0xE6, 0x01, 0x76, 0x01, // æŶ (U+00E6 U+0176)
  0x00, 0xE6, 0x01, 0x78, 0x01, // æŸ (U+00E6 U+0178)
  0x00, 0xE8, 0x00, 0x56, 0x01, // èV (U+00E8 U+0056)
  0x00, 0xE8, 0x00, 0x57, 0x01, // èW (U+00E8 U+0057)
  0x00, 0xE8, 0x00, 0x59, 0x01, // èY (U+00E8 U+0059)
  0x00, 0xE8, 0x00, 0xDD, 0x01, // èÝ (U+00E8 U+00DD)
  0x00, 0xE8, 0x01, 0x74, 0x01, // èŴ (U+00E8 U+0174)
  0x00, 0xE8, 0x01, 0x76, 0x01, // èŶ (U+00E8 U+0176)
  0x00, 0xE8, 0x01, 0x78, 0x01, // èŸ (U+00E8 U+0178)
  0x00, 0xE9, 0x00, 0x56, 0x01, // éV (U+00E9 U+0056)
  0x00, 0xE9, 0x00, 0x57, 0x01, // éW (U+00E9 U+0057)
  0x00, 0xE9, 0x00, 0x59, 0x01, // éY (U+00E9 U+0059)
  0x00, 0xE9, 0x00, 0xDD, 0x01, // éÝ (U+00E9 U+00DD)
  0x00, 0xE9, 0x01, 0x74, 0x01, // éŴ (U+00E9 U+0174)
  0x00, 0xE9, 0x01, 0x76, 0x01, // éŶ (U+00E9 U+0176)
  0x00, 0xE9, 0x01, 0x78, 0x01, // éŸ (U+00E9 U+0178)
  0x00, 0xEA, 0x00, 0x56, 0x01, // êV (U+00EA U+0056)
  0x00, 0xEA, 0x00, 0x57, 0x01, // êW (U+00EA U+0057)
  0x00, 0xEA, 0x00, 0x59, 0x01, // êY (U+00EA U+0059)
  0x00, 0xEA, 0x00, 0xDD, 0x01, // êÝ (U+00EA U+00DD)
  0x00, 0xEA, 0x01, 0x74, 0x01, // êŴ (U+00EA U+0174)
  0x00, 0xEA, 0x01, 0x76, 0x01, // êŶ (U+00EA U+0176)
  0x00, 0xEA, 0x01, 0x78, 0x01, // êŸ (U+00EA U+0178)
  0x00, 0xEB, 0x00, 0x56, 0x01, // ëV (U+00EB U+0056)
  0x00, 0xEB, 0x00, 0x57, 0x01, // ëW (U+00EB U+0057)
  0x00, 0xEB, 0x00, 0x59, 0x01, // ëY (U+00EB U+0059)
  0x00, 0xEB, 0x00, 0xDD, 0x01, // ëÝ (U+00EB U+00DD)
  0x00, 0xEB, 0x01, 0x74, 0x01, // ëŴ (U+00EB U+0174)
  0x00, 0xEB, 0x01, 0x76, 0x01, // ëŶ (U+00EB U+0176)
  0x00, 0xEB, 0x01, 0x78, 0x01, // ëŸ (U+00EB U+0178)
  0x00, 0xF0, 0x00, 0x56, 0x01, // ðV (U+00F0 U+0056)
  0x00, 0xF0, 0x00, 0x57, 0x01, // ðW (U+00F0 U+0057)
  0x00, 0xF0, 0x00, 0x59, 0x01, // ðY (U+00F0 U+0059)
  0x00, 0xF0, 0x00, 0xDD, 0x01, // ðÝ (U+00F0 U+00DD)
  0x00, 0xF0, 0x01, 0x74, 0x01, // ðŴ (U+00F0 U+0174)
  0x00, 0xF0, 0x01, 0x76, 0x01, // ðŶ (U+00F0 U+0176)
  0x00, 0xF0, 0x01, 0x78, 0x01, // ðŸ (U+00F0 U+0178)
  0x00, 0xF1, 0x00, 0x22, 0x01, // ñ" (U+00F1 U+0022)
  0x00, 0xF1, 0x00, 0x27, 0x01, // ñ' (U+00F1 U+0027)
  0x00, 0xF1, 0x00, 0x56, 0x01, // ñV (U+00F1 U+0056)
  0x00, 0xF1, 0x00, 0x57, 0x01, // ñW (U+00F1 U+0057)
  0x00, 0xF1, 0x00, 0x59, 0x01, // ñY (U+00F1 U+0059)
  0x00, 0xF1, 0x00, 0xDD, 0x01, // ñÝ (U+00F1 U+00DD)
  0x00, 0xF1, 0x01, 0x74, 0x01, // ñŴ (U+00F1 U+0174)
  0x00, 0xF1, 0x01, 0x76, 0x01, // ñŶ (U+00F1 U+0176)
  0x00, 0xF1, 0x01, 0x78, 0x01, // ñŸ (U+00F1 U+0178)
  0x00, 0xF2, 0x00, 0x56, 0x01, // òV (U+00F2 U+0056)
  0x00, 0xF2, 0x00, 0x57, 0x01, // òW (U+00F2 U+0057)
  0x00, 0xF2, 0x00, 0x59, 0x01, // òY (U+00F2 U+0059)
  0x00, 0xF2, 0x00, 0xDD, 0x01, // òÝ (U+00F2 U+00DD)
  0x00, 0xF2, 0x01, 0x74, 0x01, // òŴ (U+00F2 U+0174)
  0x00, 0xF2, 0x01, 0x76, 0x01, // òŶ (U+00F2 U+0176)
  0x00, 0xF2, 0x01, 0x78, 0x01, // òŸ (U+00F2 U+0178)
  0x00, 0xF3, 0x00, 0x56, 0x01, // óV (U+00F3 U+0056)
  0x00, 0xF3, 0x00, 0x57, 0x01, // óW (U+00F3 U+0057)
  0x00, 0xF3, 0x00, 0x59, 0x01, // óY (U+00F3 U+0059)
  0x00, 0xF3, 0x00, 0xDD, 0x01, // óÝ (U+00F3 U+00DD)
  0x00, 0xF3, 0x01, 0x74, 0x01, // óŴ (U+00F3 U+0174)
  0x00, 0xF3, 0x01, 0x76, 0x01, // óŶ (U+00F3 U+0176)
  0x00, 0xF3, 0x01, 0x78, 0x01, // óŸ (U+00F3 U+0178)
  0x00, 0xF4, 0x00, 0x56, 0x01, // ôV (U+00F4 U+0056)
  0x00, 0xF4, 0x00, 0x57, 0x01, // ôW (U+00F4 U+0057)
  0x00, 0xF4, 0x00, 0x59, 0x01, // ôY (U+00F4 U+0059)
  0x00, 0xF4, 0x00, 0xDD, 0x01, // ôÝ (U+00F4 U+00DD)
  0x00, 0xF4, 0x01, 0x74, 0x01, // ôŴ (U+00F4 U+0174)
  0x00, 0xF4, 0x01, 0x76, 0x01, // ôŶ (U+00F4 U+0176)
  0x00, 0xF4, 0x01, 0x78, 0x01, // ôŸ (U+00F4 U+0178)
  0x00, 0xF5, 0x00, 0x56, 0x01, // õV (U+00F5 U+0056)
  0x00, 0xF5, 0x00, 0x57, 0x01, // õW (U+00F5 U+0057)
  0x00, 0xF5, 0x00, 0x59, 0x01, // õY (U+00F5 U+0059)
  0x00, 0xF5, 0x00, 0xDD, 0x01, // õÝ (U+00F5 U+00DD)
  0x00, 0xF5, 0x01, 0x74, 0x01, // õŴ (U+00F5 U+0174)
  0x00, 0xF5, 0x01, 0x76, 0x01, // õŶ (U+00F5 U+0176)
  0x00, 0xF5, 0x01, 0x78, 0x01, // õŸ (U+00F5 U+0178)
  0x00, 0xF6, 0x00, 0x56, 0x01, // öV (U+00F6 U+0056)
  0x00, 0xF6, 0x00, 0x57, 0x01, // öW (U+00F6 U+0057)
  0x00, 0xF6, 0x00, 0x59, 0x01, // öY (U+00F6 U+0059)
  0x00, 0xF6, 0x00, 0xDD, 0x01, // öÝ (U+00F6 U+00DD)
  0x00, 0xF6, 0x01, 0x74, 0x01, // öŴ (U+00F6 U+0174)
  0x00, 0xF6, 0x01, 0x76, 0x01, // öŶ (U+00F6 U+0176)
  0x00, 0xF6, 0x01, 0x78, 0x01, // öŸ (U+00F6 U+0178)
  0x00, 0xF8, 0x00, 0x56, 0x01, // øV (U+00F8 U+0056)
  0x00, 0xF8, 0x00, 0x57, 0x01, // øW (U+00F8 U+0057)
  0x00, 0xF8, 0x00, 0x59, 0x01, // øY (U+00F8 U+0059)
  0x00, 0xF8, 0x00, 0xDD, 0x01, // øÝ (U+00F8 U+00DD)
  0x00, 0xF8, 0x01, 0x74, 0x01, // øŴ (U+00F8 U+0174)
  0x00, 0xF8, 0x01, 0x76, 0x01, // øŶ (U+00F8 U+0176)
  0x00, 0xF8, 0x01, 0x78, 0x01, // øŸ (U+00F8 U+0178)
  0x00, 0xFD, 0x00, 0x2C, 0x01, // ý, (U+00FD U+002C)
  0x00, 0xFD, 0x00, 0x2E, 0x01, // ý. (U+00FD U+002E)
  0x00, 0xFD, 0x00, 0x41, 0x01, // ýA (U+00FD U+0041)
  0x00, 0xFD, 0x00, 0xC0, 0x01, // ýÀ (U+00FD U+00C0)
  0x00, 0xFD, 0x00, 0xC1, 0x01, // ýÁ (U+00FD U+00C1)
  0x00, 0xFD, 0x00, 0xC2, 0x01, // ýÂ (U+00FD U+00C2)
  0x00, 0xFD, 0x00, 0xC3, 0x01, // ýÃ (U+00FD U+00C3)
  0x00, 0xFD, 0x00, 0xC4, 0x01, // ýÄ (U+00FD U+00C4)
  0x00, 0xFD, 0x00, 0xC5, 0x01, // ýÅ (U+00FD U+00C5)
  0x00, 0xFD, 0x01, 0x00, 0x01, // ýĀ (U+00FD U+0100)
  0x00, 0xFD, 0x01, 0x02, 0x01, // ýĂ (U+00FD U+0102)
  0x00, 0xFD, 0x01, 0x04, 0x01, // ýĄ (U+00FD U+0104)
  0x00, 0xFD, 0x20, 0x1A, 0x01, // ý‚ (U+00FD U+201A)
  0x00, 0xFD, 0x20, 0x1E, 0x01, // ý„ (U+00FD U+201E)
  0x00, 0xFD, 0x20, 0x26, 0x01, // ý… (U+00FD U+2026)
  0x00, 0xFE, 0x00, 0x56, 0x01, // þV (U+00FE U+0056)
  0x00, 0xFE, 0x00, 0x57, 0x01, // þW (U+00FE U+0057)
  0x00, 0xFE, 0x00, 0x59, 0x01, // þY (U+00FE U+0059)
  0x00, 0xFE, 0x00, 0xDD, 0x01, // þÝ (U+00FE U+00DD)
  0x00, 0xFE, 0x01, 0x74, 0x01, // þŴ (U+00FE U+0174)
  0x00, 0xFE, 0x01, 0x76, 0x01, // þŶ (U+00FE U+0176)
  0x00, 0xFE, 0x01, 0x78, 0x01, // þŸ (U+00FE U+0178)
  0x00, 0xFF, 0x00, 0x2C, 0x01, // ÿ, (U+00FF U+002C)
  0x00, 0xFF, 0x00, 0x2E, 0x01, // ÿ. (U+00FF U+002E)
  0x00, 0xFF, 0x00, 0x41, 0x01, // ÿA (U+00FF U+0041)
  0x00, 0xFF, 0x00, 0xC0, 0x01, // ÿÀ (U+00FF U+00C0)
  0x00, 0xFF, 0x00, 0xC1, 0x01, // ÿÁ (U+00FF U+00C1)
  0x00, 0xFF, 0x00, 0xC2, 0x01, // ÿÂ (U+00FF U+00C2)
  0x00, 0xFF, 0x00, 0xC3, 0x01, // ÿÃ (U+00FF U+00C3)
  0x00, 0xFF, 0x00, 0xC4, 0x01, // ÿÄ (U+00FF U+00C4)
  0x00, 0xFF, 0x00, 0xC5, 0x01, // ÿÅ (U+00FF U+00C5)
  0x00, 0xFF, 0x01, 0x00, 0x01, // ÿĀ (U+00FF U+0100)
  0x00, 0xFF, 0x01, 0x02, 0x01, // ÿĂ (U+00FF U+0102)
  0x00, 0xFF, 0x01, 0x04, 0x01, // ÿĄ (U+00FF U+0104)
  0x00, 0xFF, 0x20, 0x1A, 0x01, // ÿ‚ (U+00FF U+201A)
  0x00, 0xFF, 0x20, 0x1E, 0x01, // ÿ„ (U+00FF U+201E)
  0x00, 0xFF, 0x20, 0x26, 0x01, // ÿ… (U+00FF U+2026)
  0x01, 0x00, 0x00, 0x22, 0x01, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x01, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x00, 0x2A, 0x01, // Ā* (U+0100 U+002A)
  0x01, 0x00, 0x00, 0x3F, 0x01, // Ā? (U+0100 U+003F)
  0x01, 0x00, 0x00, 0x54, 0x01, // ĀT (U+0100 U+0054)
  0x01, 0x00, 0x00, 0x56, 0x01, // ĀV (U+0100 U+0056)
  0x01, 0x00, 0x00, 0x57, 0x01, // ĀW (U+0100 U+0057)
  0x01, 0x00, 0x00, 0x59, 0x01, // ĀY (U+0100 U+0059)
  0x01, 0x00, 0x00, 0x76, 0x01, // Āv (U+0100 U+0076)
  0x01, 0x00, 0x00, 0x77, 0x01, // Āw (U+0100 U+0077)
  0x01, 0x00, 0x00, 0x79, 0x01, // Āy (U+0100 U+0079)
  0x01, 0x00, 0x00, 0xDD, 0x01, // ĀÝ (U+0100 U+00DD)
  0x01, 0x00, 0x00, 0xFD, 0x01, // Āý (U+0100 U+00FD)
  0x01, 0x00, 0x00, 0xFF, 0x01, // Āÿ (U+0100 U+00FF)
  0x01, 0x00, 0x01, 0x62, 0x01, // ĀŢ (U+0100 U+0162)
  0x01, 0x00, 0x01, 0x64, 0x01, // ĀŤ (U+0100 U+0164)
  0x01, 0x00, 0x01, 0x66, 0x01, // ĀŦ (U+0100 U+0166)
  0x01, 0x00, 0x01, 0x74, 0x01, // ĀŴ (U+0100 U+0174)
  0x01, 0x00, 0x01, 0x75, 0x01, // Āŵ (U+0100 U+0175)
  0x01, 0x00, 0x01, 0x76, 0x01, // ĀŶ (U+0100 U+0176)
  0x01, 0x00, 0x01, 0x77, 0x01, // Āŷ (U+0100 U+0177)
  0x01, 0x00, 0x01, 0x78, 0x01, // ĀŸ (U+0100 U+0178)
  0x01, 0x00, 0x20, 0x18, 0x01, // Ā‘ (U+0100 U+2018)
  0x01, 0x00, 0x20, 0x19, 0x01, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1C, 0x01, // Ā“ (U+0100 U+201C)
  0x01, 0x00, 0x20, 0x1D, 0x01, // Ā” (U+0100 U+201D)
  0x01, 0x00, 0x21, 0x22, 0x01, // Ā™ (U+0100 U+2122)
  0x01, 0x01, 0x00, 0x56, 0x01, // āV (U+0101 U+0056)
  0x01, 0x01, 0x00, 0x57, 0x01, // āW (U+0101 U+0057)
  0x01, 0x01, 0x00, 0x59, 0x01, // āY (U+0101 U+0059)
  0x01, 0x01, 0x00, 0xDD, 0x01, // āÝ (U+0101 U+00DD)
  0x01, 0x01, 0x01, 0x74, 0x01, // āŴ (U+0101 U+0174)
  0x01, 0x01, 0x01, 0x76, 0x01, // āŶ (U+0101 U+0176)
  0x01, 0x01, 0x01, 0x78, 0x01, // āŸ (U+0101 U+0178)
  0x01, 0x02, 0x00, 0x22, 0x01, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x01, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x00, 0x2A, 0x01, // Ă* (U+0102 U+002A)
  0x01, 0x02, 0x00, 0x3F, 0x01, // Ă? (U+0102 U+003F)
  0x01, 0x02, 0x00, 0x54, 0x01, // ĂT (U+0102 U+0054)
  0x01, 0x02, 0x00, 0x56, 0x01, // ĂV (U+0102 U+0056)
  0x01, 0x02, 0x00, 0x57, 0x01, // ĂW (U+0102 U+0057)
  0x01, 0x02, 0x00, 0x59, 0x01, // ĂY (U+0102 U+0059)
  0x01, 0x02, 0x00, 0x76, 0x01, // Ăv (U+0102 U+0076)
  0x01, 0x02, 0x00, 0x77, 0x01, // Ăw (U+0102 U+0077)
  0x01, 0x02, 0x00, 0x79, 0x01, // Ăy (U+0102 U+0079)
  0x01, 0x02, 0x00, 0xDD, 0x01, // ĂÝ (U+0102 U+00DD)
  0x01, 0x02, 0x00, 0xFD, 0x01, // Ăý (U+0102 U+00FD)
  0x01, 0x02, 0x00, 0xFF, 0x01, // Ăÿ (U+0102 U+00FF)
  0x01, 0x02, 0x01, 0x62, 0x01, // ĂŢ (U+0102 U+0162)
  0x01, 0x02, 0x01, 0x64, 0x01, // ĂŤ (U+0102 U+0164)
  0x01, 0x02, 0x01, 0x66, 0x01, // ĂŦ (U+0102 U+0166)
  0x01, 0x02, 0x01, 0x74, 0x01, // ĂŴ (U+0102 U+0174)
  0x01, 0x02, 0x01, 0x75, 0x01, // Ăŵ (U+0102 U+0175)
  0x01, 0x02, 0x01, 0x76, 0x01, // ĂŶ (U+0102 U+0176)
  0x01, 0x02, 0x01, 0x77, 0x01, // Ăŷ (U+0102 U+0177)
  0x01, 0x02, 0x01, 0x78, 0x01, // ĂŸ (U+0102 U+0178)
  0x01, 0x02, 0x20, 0x18, 0x01, // Ă‘ (U+0102 U+2018)
  0x01, 0x02, 0x20, 0x19, 0x01, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1C, 0x01, // Ă“ (U+0102 U+201C)
  0x01, 0x02, 0x20, 0x1D, 0x01, // Ă” (U+0102 U+201D)
  0x01, 0x02, 0x21, 0x22, 0x01, // Ă™ (U+0102 U+2122)
  0x01, 0x04, 0x00, 0x22, 0x01, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x01, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x00, 0x2A, 0x01, // Ą* (U+0104 U+002A)
  0x01, 0x04, 0x00, 0x3F, 0x01, // Ą? (U+0104 U+003F)
  0x01, 0x04, 0x00, 0x54, 0x01, // ĄT (U+0104 U+0054)
  0x01, 0x04, 0x00, 0x56, 0x01, // ĄV (U+0104 U+0056)
  0x01, 0x04, 0x00, 0x57, 0x01, // ĄW (U+0104 U+0057)
  0x01, 0x04, 0x00, 0x59, 0x01, // ĄY (U+0104 U+0059)
  0x01, 0x04, 0x00, 0x76, 0x01, // Ąv (U+0104 U+0076)
  0x01, 0x04, 0x00, 0x77, 0x01, // Ąw (U+0104 U+0077)
  0x01, 0x04, 0x00, 0x79, 0x01, // Ąy (U+0104 U+0079)
  0x01, 0x04, 0x00, 0xDD, 0x01, // ĄÝ (U+0104 U+00DD)
  0x01, 0x04, 0x00, 0xFD, 0x01, // Ąý (U+0104 U+00FD)
  0x01, 0x04, 0x00, 0xFF, 0x01, // Ąÿ (U+0104 U+00FF)
  0x01, 0x04, 0x01, 0x62, 0x01, // ĄŢ (U+0104 U+0162)
  0x01, 0x04, 0x01, 0x64, 0x01, // ĄŤ (U+0104 U+0164)
  0x01, 0x04, 0x01, 0x66, 0x01, // ĄŦ (U+0104 U+0166)
  0x01, 0x04, 0x01, 0x74, 0x01, // ĄŴ (U+0104 U+0174)
  0x01, 0x04, 0x01, 0x75, 0x01, // Ąŵ (U+0104 U+0175)
  0x01, 0x04, 0x01, 0x76, 0x01, // ĄŶ (U+0104 U+0176)
  0x01, 0x04, 0x01, 0x77, 0x01, // Ąŷ (U+0104 U+0177)
  0x01, 0x04, 0x01, 0x78, 0x01, // ĄŸ (U+0104 U+0178)
  0x01, 0x04, 0x20, 0x18, 0x01, // Ą‘ (U+0104 U+2018)
  0x01, 0x04, 0x20, 0x19, 0x01, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1C, 0x01, // Ą“ (U+0104 U+201C)
  0x01, 0x04, 0x20, 0x1D, 0x01, // Ą” (U+0104 U+201D)
  0x01, 0x04, 0x21, 0x22, 0x01, // Ą™ (U+0104 U+2122)
  0x01, 0x05, 0x00, 0x56, 0x01, // ąV (U+0105 U+0056)
  0x01, 0x05, 0x00, 0x57, 0x01, // ąW (U+0105 U+0057)
  0x01, 0x05, 0x00, 0x59, 0x01, // ąY (U+0105 U+0059)
  0x01, 0x05, 0x00, 0xDD, 0x01, // ąÝ (U+0105 U+00DD)
  0x01, 0x05, 0x01, 0x74, 0x01, // ąŴ (U+0105 U+0174)
  0x01, 0x05, 0x01, 0x76, 0x01, // ąŶ (U+0105 U+0176)
  0x01, 0x05, 0x01, 0x78, 0x01, // ąŸ (U+0105 U+0178)
  0x01, 0x0E, 0x00, 0x59, 0x01, // ĎY (U+010E U+0059)
  0x01, 0x0E, 0x00, 0xC6, 0x01, // ĎÆ (U+010E U+00C6)
  0x01, 0x0E, 0x00, 0xDD, 0x01, // ĎÝ (U+010E U+00DD)
  0x01, 0x0E, 0x01, 0x76, 0x01, // ĎŶ (U+010E U+0176)
  0x01, 0x0E, 0x01, 0x78, 0x01, // ĎŸ (U+010E U+0178)
  0x01, 0x10, 0x00, 0x59, 0x01, // ĐY (U+0110 U+0059)
  0x01, 0x10, 0x00, 0xC6, 0x01, // ĐÆ (U+0110 U+00C6)
  0x01, 0x10, 0x00, 0xDD, 0x01, // ĐÝ (U+0110 U+00DD)
  0x01, 0x10, 0x01, 0x76, 0x01, // ĐŶ (U+0110 U+0176)
  0x01, 0x10, 0x01, 0x78, 0x01, // ĐŸ (U+0110 U+0178)
  0x01, 0x13, 0x00, 0x56, 0x01, // ēV (U+0113 U+0056)
  0x01, 0x13, 0x00, 0x57, 0x01, // ēW (U+0113 U+0057)
  0x01, 0x13, 0x00, 0x59, 0x01, // ēY (U+0113 U+0059)
  0x01, 0x13, 0x00, 0xDD, 0x01, // ēÝ (U+0113 U+00DD)
  0x01, 0x13, 0x01, 0x74, 0x01, // ēŴ (U+0113 U+0174)
  0x01, 0x13, 0x01, 0x76, 0x01, // ēŶ (U+0113 U+0176)
  0x01, 0x13, 0x01, 0x78, 0x01, // ēŸ (U+0113 U+0178)
  0x01, 0x15, 0x00, 0x56, 0x01, // ĕV (U+0115 U+0056)
  0x01, 0x15, 0x00, 0x57, 0x01, // ĕW (U+0115 U+0057)
  0x01, 0x15, 0x00, 0x59, 0x01, // ĕY (U+0115 U+0059)
  0x01, 0x15, 0x00, 0xDD, 0x01, // ĕÝ (U+0115 U+00DD)
  0x01, 0x15, 0x01, 0x74, 0x01, // ĕŴ (U+0115 U+0174)
  0x01, 0x15, 0x01, 0x76, 0x01, // ĕŶ (U+0115 U+0176)
  0x01, 0x15, 0x01, 0x78, 0x01, // ĕŸ (U+0115 U+0178)
  0x01, 0x17, 0x00, 0x56, 0x01, // ėV (U+0117 U+0056)
  0x01, 0x17, 0x00, 0x57, 0x01, // ėW (U+0117 U+0057)
  0x01, 0x17, 0x00, 0x59, 0x01, // ėY (U+0117 U+0059)
  0x01, 0x17, 0x00, 0xDD, 0x01, // ėÝ (U+0117 U+00DD)
  0x01, 0x17, 0x01, 0x74, 0x01, // ėŴ (U+0117 U+0174)
  0x01, 0x17, 0x01, 0x76, 0x01, // ėŶ (U+0117 U+0176)
  0x01, 0x17, 0x01, 0x78, 0x01, // ėŸ (U+0117 U+0178)
  0x01, 0x19, 0x00, 0x56, 0x01, // ęV (U+0119 U+0056)
  0x01, 0x19, 0x00, 0x57, 0x01, // ęW (U+0119 U+0057)
  0x01, 0x19, 0x00, 0x59, 0x01, // ęY (U+0119 U+0059)
  0x01, 0x19, 0x00, 0xDD, 0x01, // ęÝ (U+0119 U+00DD)
  0x01, 0x19, 0x01, 0x74, 0x01, // ęŴ (U+0119 U+0174)
  0x01, 0x19, 0x01, 0x76, 0x01, // ęŶ (U+0119 U+0176)
  0x01, 0x19, 0x01, 0x78, 0x01, // ęŸ (U+0119 U+0178)
  0x01, 0x1B, 0x00, 0x56, 0x01, // ěV (U+011B U+0056)
  0x01, 0x1B, 0x00, 0x57, 0x01, // ěW (U+011B U+0057)
  0x01, 0x1B, 0x00, 0x59, 0x01, // ěY (U+011B U+0059)
  0x01, 0x1B, 0x00, 0xDD, 0x01, // ěÝ (U+011B U+00DD)
  0x01, 0x1B, 0x01, 0x74, 0x01, // ěŴ (U+011B U+0174)
  0x01, 0x1B, 0x01, 0x76, 0x01, // ěŶ (U+011B U+0176)
  0x01, 0x1B, 0x01, 0x78, 0x01, // ěŸ (U+011B U+0178)
  0x01, 0x25, 0x00, 0x22, 0x01, // ĥ" (U+0125 U+0022)
  0x01, 0x25, 0x00, 0x27, 0x01, // ĥ' (U+0125 U+0027)
  0x01, 0x25, 0x00, 0x56, 0x01, // ĥV (U+0125 U+0056)
  0x01, 0x25, 0x00, 0x57, 0x01, // ĥW (U+0125 U+0057)
  0x01, 0x25, 0x00, 0x59, 0x01, // ĥY (U+0125 U+0059)
  0x01, 0x25, 0x00, 0xDD, 0x01, // ĥÝ (U+0125 U+00DD)
  0x01, 0x25, 0x01, 0x74, 0x01, // ĥŴ (U+0125 U+0174)
  0x01, 0x25, 0x01, 0x76, 0x01, // ĥŶ (U+0125 U+0176)
  0x01, 0x25, 0x01, 0x78, 0x01, // ĥŸ (U+0125 U+0178)
  0x01, 0x27, 0x00, 0x22, 0x01, // ħ" (U+0127 U+0022)
  0x01, 0x27, 0x00, 0x27, 0x01, // ħ' (U+0127 U+0027)
  0x01, 0x27, 0x00, 0x56, 0x01, // ħV (U+0127 U+0056)
  0x01, 0x27, 0x00, 0x57, 0x01, // ħW (U+0127 U+0057)
  0x01, 0x27, 0x00, 0x59, 0x01, // ħY (U+0127 U+0059)
  0x01, 0x27, 0x00, 0xDD, 0x01, // ħÝ (U+0127 U+00DD)
  0x01, 0x27, 0x01, 0x74, 0x01, // ħŴ (U+0127 U+0174)
  0x01, 0x27, 0x01, 0x76, 0x01, // ħŶ (U+0127 U+0176)
  0x01, 0x27, 0x01, 0x78, 0x01, // ħŸ (U+0127 U+0178)
  0x01, 0x36, 0x00, 0x77, 0x01, // Ķw (U+0136 U+0077)
  0x01, 0x36, 0x00, 0x79, 0x01, // Ķy (U+0136 U+0079)
  0x01, 0x36, 0x00, 0xFD, 0x01, // Ķý (U+0136 U+00FD)
  0x01, 0x36, 0x00, 0xFF, 0x01, // Ķÿ (U+0136 U+00FF)
  0x01, 0x36, 0x01, 0x75, 0x01, // Ķŵ (U+0136 U+0175)
  0x01, 0x36, 0x01, 0x77, 0x01, // Ķŷ (U+0136 U+0177)
  0x01, 0x39, 0x00, 0x22, 0x01, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x01, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x00, 0x2A, 0x01, // Ĺ* (U+0139 U+002A)
  0x01, 0x39, 0x00, 0x3F, 0x01, // Ĺ? (U+0139 U+003F)
  0x01, 0x39, 0x00, 0x54, 0x01, // ĹT (U+0139 U+0054)
  0x01, 0x39, 0x00, 0x56, 0x01, // ĹV (U+0139 U+0056)
  0x01, 0x39, 0x00, 0x57, 0x01, // ĹW (U+0139 U+0057)
  0x01, 0x39, 0x00, 0x59, 0x01, // ĹY (U+0139 U+0059)
  0x01, 0x39, 0x00, 0x79, 0x01, // Ĺy (U+0139 U+0079)
  0x01, 0x39, 0x00, 0xDD, 0x01, // ĹÝ (U+0139 U+00DD)
  0x01, 0x39, 0x00, 0xFD, 0x01, // Ĺý (U+0139 U+00FD)
  0x01, 0x39, 0x00, 0xFF, 0x01, // Ĺÿ (U+0139 U+00FF)
  0x01, 0x39, 0x01, 0x62, 0x01, // ĹŢ (U+0139 U+0162)
  0x01, 0x39, 0x01, 0x64, 0x01, // ĹŤ (U+0139 U+0164)
  0x01, 0x39, 0x01, 0x66, 0x01, // ĹŦ (U+0139 U+0166)
  0x01, 0x39, 0x01, 0x74, 0x01, // ĹŴ (U+0139 U+0174)
  0x01, 0x39, 0x01, 0x76, 0x01, // ĹŶ (U+0139 U+0176)
  0x01, 0x39, 0x01, 0x77, 0x01, // Ĺŷ (U+0139 U+0177)
  0x01, 0x39, 0x01, 0x78, 0x01, // ĹŸ (U+0139 U+0178)
  0x01, 0x39, 0x20, 0x18, 0x01, // Ĺ‘ (U+0139 U+2018)
  0x01, 0x39, 0x20, 0x19, 0x01, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1C, 0x01, // Ĺ“ (U+0139 U+201C)
  0x01, 0x39, 0x20, 0x1D, 0x01, // Ĺ” (U+0139 U+201D)
  0x01, 0x39, 0x21, 0x22, 0x01, // Ĺ™ (U+0139 U+2122)
  0x01, 0x3B, 0x00, 0x22, 0x01, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x01, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x00, 0x2A, 0x01, // Ļ* (U+013B U+002A)
  0x01, 0x3B, 0x00, 0x3F, 0x01, // Ļ? (U+013B U+003F)
  0x01, 0x3B, 0x00, 0x54, 0x01, // ĻT (U+013B U+0054)
  0x01, 0x3B, 0x00, 0x56, 0x01, // ĻV (U+013B U+0056)
  0x01, 0x3B, 0x00, 0x57, 0x01, // ĻW (U+013B U+0057)
  0x01, 0x3B, 0x00, 0x59, 0x01, // ĻY (U+013B U+0059)
  0x01, 0x3B, 0x00, 0x79, 0x01, // Ļy (U+013B U+0079)
  0x01, 0x3B, 0x00, 0xDD, 0x01, // ĻÝ (U+013B U+00DD)
  0x01, 0x3B, 0x00, 0xFD, 0x01, // Ļý (U+013B U+00FD)
  0x01, 0x3B, 0x00, 0xFF, 0x01, // Ļÿ (U+013B U+00FF)
  0x01, 0x3B, 0x01, 0x62, 0x01, // ĻŢ (U+013B U+0162)
  0x01, 0x3B, 0x01, 0x64, 0x01, // ĻŤ (U+013B U+0164)
  0x01, 0x3B, 0x01, 0x66, 0x01, // ĻŦ (U+013B U+0166)
  0x01, 0x3B, 0x01, 0x74, 0x01, // ĻŴ (U+013B U+0174)
  0x01, 0x3B, 0x01, 0x76, 0x01, // ĻŶ (U+013B U+0176)
  0x01, 0x3B, 0x01, 0x77, 0x01, // Ļŷ (U+013B U+0177)
  0x01, 0x3B, 0x01, 0x78, 0x01, // ĻŸ (U+013B U+0178)
  0x01, 0x3B, 0x20, 0x18, 0x01, // Ļ‘ (U+013B U+2018)
  0x01, 0x3B, 0x20, 0x19, 0x01, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1C, 0x01, // Ļ“ (U+013B U+201C)
  0x01, 0x3B, 0x20, 0x1D, 0x01, // Ļ” (U+013B U+201D)
  0x01, 0x3B, 0x21, 0x22, 0x01, // Ļ™ (U+013B U+2122)
  0x01, 0x41, 0x00, 0x22, 0x01, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x01, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x00, 0x2A, 0x01, // Ł* (U+0141 U+002A)
  0x01, 0x41, 0x00, 0x3F, 0x01, // Ł? (U+0141 U+003F)
  0x01, 0x41, 0x00, 0x54, 0x01, // ŁT (U+0141 U+0054)
  0x01, 0x41, 0x00, 0x56, 0x01, // ŁV (U+0141 U+0056)
  0x01, 0x41, 0x00, 0x57, 0x01, // ŁW (U+0141 U+0057)
  0x01, 0x41, 0x00, 0x59, 0x01, // ŁY (U+0141 U+0059)
  0x01, 0x41, 0x00, 0x79, 0x01, // Ły (U+0141 U+0079)
  0x01, 0x41, 0x00, 0xDD, 0x01, // ŁÝ (U+0141 U+00DD)
  0x01, 0x41, 0x00, 0xFD, 0x01, // Łý (U+0141 U+00FD)
  0x01, 0x41, 0x00, 0xFF, 0x01, // Łÿ (U+0141 U+00FF)
  0x01, 0x41, 0x01, 0x62, 0x01, // ŁŢ (U+0141 U+0162)
  0x01, 0x41, 0x01, 0x64, 0x01, // ŁŤ (U+0141 U+0164)
  0x01, 0x41, 0x01, 0x66, 0x01, // ŁŦ (U+0141 U+0166)
  0x01, 0x41, 0x01, 0x74, 0x01, // ŁŴ (U+0141 U+0174)
  0x01, 0x41, 0x01, 0x76, 0x01, // ŁŶ (U+0141 U+0176)
  0x01, 0x41, 0x01, 0x77, 0x01, // Łŷ (U+0141 U+0177)
  0x01, 0x41, 0x01, 0x78, 0x01, // ŁŸ (U+0141 U+0178)
  0x01, 0x41, 0x20, 0x18, 0x01, // Ł‘ (U+0141 U+2018)
  0x01, 0x41, 0x20, 0x19, 0x01, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1C, 0x01, // Ł“ (U+0141 U+201C)
  0x01, 0x41, 0x20, 0x1D, 0x01, // Ł” (U+0141 U+201D)
  0x01, 0x41, 0x21, 0x22, 0x01, // Ł™ (U+0141 U+2122)
  0x01, 0x44, 0x00, 0x22, 0x01, // ń" (U+0144 U+0022)
  0x01, 0x44, 0x00, 0x27, 0x01, // ń' (U+0144 U+0027)
  0x01, 0x44, 0x00, 0x56, 0x01, // ńV (U+0144 U+0056)
  0x01, 0x44, 0x00, 0x57, 0x01, // ńW (U+0144 U+0057)
  0x01, 0x44, 0x00, 0x59, 0x01, // ńY (U+0144 U+0059)
  0x01, 0x44, 0x00, 0xDD, 0x01, // ńÝ (U+0144 U+00DD)
  0x01, 0x44, 0x01, 0x74, 0x01, // ńŴ (U+0144 U+0174)
  0x01, 0x44, 0x01, 0x76, 0x01, // ńŶ (U+0144 U+0176)
  0x01, 0x44, 0x01, 0x78, 0x01, // ńŸ (U+0144 U+0178)
  0x01, 0x46, 0x00, 0x22, 0x01, // ņ" (U+0146 U+0022)
  0x01, 0x46, 0x00, 0x27, 0x01, // ņ' (U+0146 U+0027)
  0x01, 0x46, 0x00, 0x56, 0x01, // ņV (U+0146 U+0056)
  0x01, 0x46, 0x00, 0x57, 0x01, // ņW (U+0146 U+0057)
  0x01, 0x46, 0x00, 0x59, 0x01, // ņY (U+0146 U+0059)
  0x01, 0x46, 0x00, 0xDD, 0x01, // ņÝ (U+0146 U+00DD)
  0x01, 0x46, 0x01, 0x74, 0x01, // ņŴ (U+0146 U+0174)
  0x01, 0x46, 0x01, 0x76, 0x01, // ņŶ (U+0146 U+0176)
  0x01, 0x46, 0x01, 0x78, 0x01, // ņŸ (U+0146 U+0178)
  0x01, 0x48, 0x00, 0x22, 0x01, // ň" (U+0148 U+0022)
  0x01, 0x48, 0x00, 0x27, 0x01, // ň' (U+0148 U+0027)
  0x01, 0x48, 0x00, 0x56, 0x01, // ňV (U+0148 U+0056)
  0x01, 0x48, 0x00, 0x57, 0x01, // ňW (U+0148 U+0057)
  0x01, 0x48, 0x00, 0x59, 0x01, // ňY (U+0148 U+0059)
  0x01, 0x48, 0x00, 0xDD, 0x01, // ňÝ (U+0148 U+00DD)
  0x01, 0x48, 0x01, 0x74, 0x01, // ňŴ (U+0148 U+0174)
  0x01, 0x48, 0x01, 0x76, 0x01, // ňŶ (U+0148 U+0176)
  0x01, 0x48, 0x01, 0x78, 0x01, // ňŸ (U+0148 U+0178)
  0x01, 0x49, 0x00, 0x22, 0x01, // ŉ" (U+0149 U+0022)
  0x01, 0x49, 0x00, 0x27, 0x01, // ŉ' (U+0149 U+0027)
  0x01, 0x49, 0x00, 0x56, 0x01, // ŉV (U+0149 U+0056)
  0x01, 0x49, 0x00, 0x57, 0x01, // ŉW (U+0149 U+0057)
  0x01, 0x49, 0x00, 0x59, 0x01, // ŉY (U+0149 U+0059)
  0x01, 0x49, 0x00, 0xDD, 0x01, // ŉÝ (U+0149 U+00DD)
  0x01, 0x49, 0x01, 0x74, 0x01, // ŉŴ (U+0149 U+0174)
  0x01, 0x49, 0x01, 0x76, 0x01, // ŉŶ (U+0149 U+0176)
  0x01, 0x49, 0x01, 0x78, 0x01, // ŉŸ (U+0149 U+0178)
  0x01, 0x4B, 0x00, 0x22, 0x01, // ŋ" (U+014B U+0022)
  0x01, 0x4B, 0x00, 0x27, 0x01, // ŋ' (U+014B U+0027)
  0x01, 0x4B, 0x00, 0x56, 0x01, // ŋV (U+014B U+0056)
  0x01, 0x4B, 0x00, 0x57, 0x01, // ŋW (U+014B U+0057)
  0x01, 0x4B, 0x00, 0x59, 0x01, // ŋY (U+014B U+0059)
  0x01, 0x4B, 0x00, 0xDD, 0x01, // ŋÝ (U+014B U+00DD)
  0x01, 0x4B, 0x01, 0x74, 0x01, // ŋŴ (U+014B U+0174)
  0x01, 0x4B, 0x01, 0x76, 0x01, // ŋŶ (U+014B U+0176)
  0x01, 0x4B, 0x01, 0x78, 0x01, // ŋŸ (U+014B U+0178)
  0x01, 0x4C, 0x00, 0x59, 0x01, // ŌY (U+014C U+0059)
  0x01, 0x4C, 0x00, 0xC6, 0x01, // ŌÆ (U+014C U+00C6)
  0x01, 0x4C, 0x00, 0xDD, 0x01, // ŌÝ (U+014C U+00DD)
  0x01, 0x4C, 0x01, 0x76, 0x01, // ŌŶ (U+014C U+0176)
  0x01, 0x4C, 0x01, 0x78, 0x01, // ŌŸ (U+014C U+0178)
  0x01, 0x4D, 0x00, 0x56, 0x01, // ōV (U+014D U+0056)
  0x01, 0x4D, 0x00, 0x57, 0x01, // ōW (U+014D U+0057)
  0x01, 0x4D, 0x00, 0x59, 0x01, // ōY (U+014D U+0059)
  0x01, 0x4D, 0x00, 0xDD, 0x01, // ōÝ (U+014D U+00DD)
  0x01, 0x4D, 0x01, 0x74, 0x01, // ōŴ (U+014D U+0174)
  0x01, 0x4D, 0x01, 0x76, 0x01, // ōŶ (U+014D U+0176)
  0x01, 0x4D, 0x01, 0x78, 0x01, // ōŸ (U+014D U+0178)
  0x01, 0x4E, 0x00, 0x59, 0x01, // ŎY (U+014E U+0059)
  0x01, 0x4E, 0x00, 0xC6, 0x01, // ŎÆ (U+014E U+00C6)
  0x01, 0x4E, 0x00, 0xDD, 0x01, // ŎÝ (U+014E U+00DD)
  0x01, 0x4E, 0x01, 0x76, 0x01, // ŎŶ (U+014E U+0176)
  0x01, 0x4E, 0x01, 0x78, 0x01, // ŎŸ (U+014E U+0178)
  0x01, 0x4F, 0x00, 0x56, 0x01, // ŏV (U+014F U+0056)
  0x01, 0x4F, 0x00, 0x57, 0x01, // ŏW (U+014F U+0057)
  0x01, 0x4F, 0x00, 0x59, 0x01, // ŏY (U+014F U+0059)
  0x01, 0x4F, 0x00, 0xDD, 0x01, // ŏÝ (U+014F U+00DD)
  0x01, 0x4F, 0x01, 0x74, 0x01, // ŏŴ (U+014F U+0174)
  0x01, 0x4F, 0x01, 0x76, 0x01, // ŏŶ (U+014F U+0176)
  0x01, 0x4F, 0x01, 0x78, 0x01, // ŏŸ (U+014F U+0178)
  0x01, 0x50, 0x00, 0x59, 0x01, // ŐY (U+0150 U+0059)
  0x01, 0x50, 0x00, 0xC6, 0x01, // ŐÆ (U+0150 U+00C6)
  0x01, 0x50, 0x00, 0xDD, 0x01, // ŐÝ (U+0150 U+00DD)
  0x01, 0x50, 0x01, 0x76, 0x01, // ŐŶ (U+0150 U+0176)
  0x01, 0x50, 0x01, 0x78, 0x01, // ŐŸ (U+0150 U+0178)
  0x01, 0x51, 0x00, 0x56, 0x01, // őV (U+0151 U+0056)
  0x01, 0x51, 0x00, 0x57, 0x01, // őW (U+0151 U+0057)
  0x01, 0x51, 0x00, 0x59, 0x01, // őY (U+0151 U+0059)
  0x01, 0x51, 0x00, 0xDD, 0x01, // őÝ (U+0151 U+00DD)
  0x01, 0x51, 0x01, 0x74, 0x01, // őŴ (U+0151 U+0174)
  0x01, 0x51, 0x01, 0x76, 0x01, // őŶ (U+0151 U+0176)
  0x01, 0x51, 0x01, 0x78, 0x01, // őŸ (U+0151 U+0178)
  0x01, 0x53, 0x00, 0x56, 0x01, // œV (U+0153 U+0056)
  0x01, 0x53, 0x00, 0x57, 0x01, // œW (U+0153 U+0057)
  0x01, 0x53, 0x00, 0x59, 0x01, // œY (U+0153 U+0059)
  0x01, 0x53, 0x00, 0xDD, 0x01, // œÝ (U+0153 U+00DD)
  0x01, 0x53, 0x01, 0x74, 0x01, // œŴ (U+0153 U+0174)
  0x01, 0x53, 0x01, 0x76, 0x01, // œŶ (U+0153 U+0176)
  0x01, 0x53, 0x01, 0x78, 0x01, // œŸ (U+0153 U+0178)
  0x01, 0x55, 0x00, 0x2C, 0x02, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x02, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x20, 0x1A, 0x02, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x02, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x02, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x02, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x02, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x20, 0x1A, 0x02, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x02, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x02, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x02, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x02, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x20, 0x1A, 0x02, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x02, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x02, // ř… (U+0159 U+2026)
  0x01, 0x5B, 0x00, 0x59, 0x01, // śY (U+015B U+0059)
  0x01, 0x5B, 0x00, 0xDD, 0x01, // śÝ (U+015B U+00DD)
  0x01, 0x5B, 0x01, 0x76, 0x01, // śŶ (U+015B U+0176)
  0x01, 0x5B, 0x01, 0x78, 0x01, // śŸ (U+015B U+0178)
  0x01, 0x5D, 0x00, 0x59, 0x01, // ŝY (U+015D U+0059)
  0x01, 0x5D, 0x00, 0xDD, 0x01, // ŝÝ (U+015D U+00DD)
  0x01, 0x5D, 0x01, 0x76, 0x01, // ŝŶ (U+015D U+0176)
  0x01, 0x5D, 0x01, 0x78, 0x01, // ŝŸ (U+015D U+0178)
  0x01, 0x5F, 0x00, 0x59, 0x01, // şY (U+015F U+0059)
  0x01, 0x5F, 0x00, 0xDD, 0x01, // şÝ (U+015F U+00DD)
  0x01, 0x5F, 0x01, 0x76, 0x01, // şŶ (U+015F U+0176)
  0x01, 0x5F, 0x01, 0x78, 0x01, // şŸ (U+015F U+0178)
  0x01, 0x61, 0x00, 0x59, 0x01, // šY (U+0161 U+0059)
  0x01, 0x61, 0x00, 0xDD, 0x01, // šÝ (U+0161 U+00DD)
  0x01, 0x61, 0x01, 0x76, 0x01, // šŶ (U+0161 U+0176)
  0x01, 0x61, 0x01, 0x78, 0x01, // šŸ (U+0161 U+0178)
  0x01, 0x62, 0x00, 0x2C, 0x01, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2E, 0x01, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0x40, 0x01, // Ţ@ (U+0162 U+0040)
  0x01, 0x62, 0x00, 0x41, 0x01, // ŢA (U+0162 U+0041)
  0x01, 0x62, 0x00, 0x61, 0x01, // Ţa (U+0162 U+0061)
  0x01, 0x62, 0x00, 0x63, 0x01, // Ţc (U+0162 U+0063)
  0x01, 0x62, 0x00, 0x64, 0x01, // Ţd (U+0162 U+0064)
  0x01, 0x62, 0x00, 0x65, 0x01, // Ţe (U+0162 U+0065)
  0x01, 0x62, 0x00, 0x67, 0x01, // Ţg (U+0162 U+0067)
  0x01, 0x62, 0x00, 0x6F, 0x01, // Ţo (U+0162 U+006F)
  0x01, 0x62, 0x00, 0x71, 0x01, // Ţq (U+0162 U+0071)
  0x01, 0x62, 0x00, 0xC0, 0x01, // ŢÀ (U+0162 U+00C0)
  0x01, 0x62, 0x00, 0xC1, 0x01, // ŢÁ (U+0162 U+00C1)
  0x01, 0x62, 0x00, 0xC2, 0x01, // ŢÂ (U+0162 U+00C2)
  0x01, 0x62, 0x00, 0xC3, 0x01, // ŢÃ (U+0162 U+00C3)
  0x01, 0x62, 0x00, 0xC4, 0x01, // ŢÄ (U+0162 U+00C4)
  0x01, 0x62, 0x00, 0xC5, 0x01, // ŢÅ (U+0162 U+00C5)
  0x01, 0x62, 0x00, 0xC6, 0x01, // ŢÆ (U+0162 U+00C6)
  0x01, 0x62, 0x00, 0xE0, 0x01, // Ţà (U+0162 U+00E0)
  0x01, 0x62, 0x00, 0xE1, 0x01, // Ţá (U+0162 U+00E1)
  0x01, 0x62, 0x00, 0xE2, 0x01, // Ţâ (U+0162 U+00E2)
  0x01, 0x62, 0x00, 0xE3, 0x01, // Ţã (U+0162 U+00E3)
  0x01, 0x62, 0x00, 0xE4, 0x01, // Ţä (U+0162 U+00E4)
  0x01, 0x62, 0x00, 0xE5, 0x01, // Ţå (U+0162 U+00E5)
  0x01, 0x62, 0x00, 0xE6, 0x01, // Ţæ (U+0162 U+00E6)
  0x01, 0x62, 0x00, 0xE7, 0x01, // Ţç (U+0162 U+00E7)
  0x01, 0x62, 0x00, 0xE8, 0x01, // Ţè (U+0162 U+00E8)
  0x01, 0x62, 0x00, 0xE9, 0x01, // Ţé (U+0162 U+00E9)
  0x01, 0x62, 0x00, 0xEA, 0x01, // Ţê (U+0162 U+00EA)
  0x01, 0x62, 0x00, 0xEB, 0x01, // Ţë (U+0162 U+00EB)
  0x01, 0x62, 0x00, 0xF0, 0x01, // Ţð (U+0162 U+00F0)
  0x01, 0x62, 0x00, 0xF2, 0x01, // Ţò (U+0162 U+00F2)
  0x01, 0x62, 0x00, 0xF3, 0x01, // Ţó (U+0162 U+00F3)
  0x01, 0x62, 0x00, 0xF4, 0x01, // Ţô (U+0162 U+00F4)
  0x01, 0x62, 0x00, 0xF5, 0x01, // Ţõ (U+0162 U+00F5)
  0x01, 0x62, 0x00, 0xF6, 0x01, // Ţö (U+0162 U+00F6)
  0x01, 0x62, 0x00, 0xF8, 0x01, // Ţø (U+0162 U+00F8)
  0x01, 0x62, 0x01, 0x00, 0x01, // ŢĀ (U+0162 U+0100)
  0x01, 0x62, 0x01, 0x01, 0x01, // Ţā (U+0162 U+0101)
  0x01, 0x62, 0x01, 0x02, 0x01, // ŢĂ (U+0162 U+0102)
  0x01, 0x62, 0x01, 0x03, 0x01, // Ţă (U+0162 U+0103)
  0x01, 0x62, 0x01, 0x04, 0x01, // ŢĄ (U+0162 U+0104)
  0x01, 0x62, 0x01, 0x05, 0x01, // Ţą (U+0162 U+0105)
  0x01, 0x62, 0x01, 0x07, 0x01, // Ţć (U+0162 U+0107)
  0x01, 0x62, 0x01, 0x09, 0x01, // Ţĉ (U+0162 U+0109)
  0x01, 0x62, 0x01, 0x0B, 0x01, // Ţċ (U+0162 U+010B)
  0x01, 0x62, 0x01, 0x0D, 0x01, // Ţč (U+0162 U+010D)
  0x01, 0x62, 0x01, 0x0F, 0x01, // Ţď (U+0162 U+010F)
  0x01, 0x62, 0x01, 0x11, 0x01, // Ţđ (U+0162 U+0111)
  0x01, 0x62, 0x01, 0x13, 0x01, // Ţē (U+0162 U+0113)
  0x01, 0x62, 0x01, 0x15, 0x01, // Ţĕ (U+0162 U+0115)
  0x01, 0x62, 0x01, 0x17, 0x01, // Ţė (U+0162 U+0117)
  0x01, 0x62, 0x01, 0x19, 0x01, // Ţę (U+0162 U+0119)
  0x01, 0x62, 0x01, 0x1B, 0x01, // Ţě (U+0162 U+011B)
  0x01, 0x62, 0x01, 0x1D, 0x01, // Ţĝ (U+0162 U+011D)
  0x01, 0x62, 0x01, 0x1F, 0x01, // Ţğ (U+0162 U+011F)
  0x01, 0x62, 0x01, 0x21, 0x01, // Ţġ (U+0162 U+0121)
  0x01, 0x62, 0x01, 0x23, 0x01, // Ţģ (U+0162 U+0123)
  0x01, 0x62, 0x01, 0x4D, 0x01, // Ţō (U+0162 U+014D)
  0x01, 0x62, 0x01, 0x4F, 0x01, // Ţŏ (U+0162 U+014F)
  0x01, 0x62, 0x01, 0x51, 0x01, // Ţő (U+0162 U+0151)
  0x01, 0x62, 0x01, 0x53, 0x01, // Ţœ (U+0162 U+0153)
  0x01, 0x62, 0x20, 0x1A, 0x01, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x01, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x01, // Ţ… (U+0162 U+2026)
  0x01, 0x64, 0x00, 0x2C, 0x01, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2E, 0x01, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0x40, 0x01, // Ť@ (U+0164 U+0040)
  0x01, 0x64, 0x00, 0x41, 0x01, // ŤA (U+0164 U+0041)
  0x01, 0x64, 0x00, 0x61, 0x01, // Ťa (U+0164 U+0061)
  0x01, 0x64, 0x00, 0x63, 0x01, // Ťc (U+0164 U+0063)
  0x01, 0x64, 0x00, 0x64, 0x01, // Ťd (U+0164 U+0064)
  0x01, 0x64, 0x00, 0x65, 0x01, // Ťe (U+0164 U+0065)
  0x01, 0x64, 0x00, 0x67, 0x01, // Ťg (U+0164 U+0067)
  0x01, 0x64, 0x00, 0x6F, 0x01, // Ťo (U+0164 U+006F)
  0x01, 0x64, 0x00, 0x71, 0x01, // Ťq (U+0164 U+0071)
  0x01, 0x64, 0x00, 0xC0, 0x01, // ŤÀ (U+0164 U+00C0)
  0x01, 0x64, 0x00, 0xC1, 0x01, // ŤÁ (U+0164 U+00C1)
  0x01, 0x64, 0x00, 0xC2, 0x01, // ŤÂ (U+0164 U+00C2)
  0x01, 0x64, 0x00, 0xC3, 0x01, // ŤÃ (U+0164 U+00C3)
  0x01, 0x64, 0x00, 0xC4, 0x01, // ŤÄ (U+0164 U+00C4)
  0x01, 0x64, 0x00, 0xC5, 0x01, // ŤÅ (U+0164 U+00C5)
  0x01, 0x64, 0x00, 0xC6, 0x01, // ŤÆ (U+0164 U+00C6)
  0x01, 0x64, 0x00, 0xE0, 0x01, // Ťà (U+0164 U+00E0)
  0x01, 0x64, 0x00, 0xE1, 0x01, // Ťá (U+0164 U+00E1)
  0x01, 0x64, 0x00, 0xE2, 0x01, // Ťâ (U+0164 U+00E2)
  0x01, 0x64, 0x00, 0xE3, 0x01, // Ťã (U+0164 U+00E3)
  0x01, 0x64, 0x00, 0xE4, 0x01, // Ťä (U+0164 U+00E4)
  0x01, 0x64, 0x00, 0xE5, 0x01, // Ťå (U+0164 U+00E5)
  0x01, 0x64, 0x00, 0xE6, 0x01, // Ťæ (U+0164 U+00E6)
  0x01, 0x64, 0x00, 0xE7, 0x01, // Ťç (U+0164 U+00E7)
  0x01, 0x64, 0x00, 0xE8, 0x01, // Ťè (U+0164 U+00E8)
  0x01, 0x64, 0x00, 0xE9, 0x01, // Ťé (U+0164 U+00E9)
  0x01, 0x64, 0x00, 0xEA, 0x01, // Ťê (U+0164 U+00EA)
  0x01, 0x64, 0x00, 0xEB, 0x01, // Ťë (U+0164 U+00EB)
  0x01, 0x64, 0x00, 0xF0, 0x01, // Ťð (U+0164 U+00F0)
  0x01, 0x64, 0x00, 0xF2, 0x01, // Ťò (U+0164 U+00F2)
  0x01, 0x64, 0x00, 0xF3, 0x01, // Ťó (U+0164 U+00F3)
  0x01, 0x64, 0x00, 0xF4, 0x01, // Ťô (U+0164 U+00F4)
  0x01, 0x64, 0x00, 0xF5, 0x01, // Ťõ (U+0164 U+00F5)
  0x01, 0x64, 0x00, 0xF6, 0x01, // Ťö (U+0164 U+00F6)
  0x01, 0x64, 0x00, 0xF8, 0x01, // Ťø (U+0164 U+00F8)
  0x01, 0x64, 0x01, 0x00, 0x01, // ŤĀ (U+0164 U+0100)
  0x01, 0x64, 0x01, 0x01, 0x01, // Ťā (U+0164 U+0101)
  0x01, 0x64, 0x01, 0x02, 0x01, // ŤĂ (U+0164 U+0102)
  0x01, 0x64, 0x01, 0x03, 0x01, // Ťă (U+0164 U+0103)
  0x01, 0x64, 0x01, 0x04, 0x01, // ŤĄ (U+0164 U+0104)
  0x01, 0x64, 0x01, 0x05, 0x01, // Ťą (U+0164 U+0105)
  0x01, 0x64, 0x01, 0x07, 0x01, // Ťć (U+0164 U+0107)
  0x01, 0x64, 0x01, 0x09, 0x01, // Ťĉ (U+0164 U+0109)
  0x01, 0x64, 0x01, 0x0B, 0x01, // Ťċ (U+0164 U+010B)
  0x01, 0x64, 0x01, 0x0D, 0x01, // Ťč (U+0164 U+010D)
  0x01, 0x64, 0x01, 0x0F, 0x01, // Ťď (U+0164 U+010F)
  0x01, 0x64, 0x01, 0x11, 0x01, // Ťđ (U+0164 U+0111)
  0x01, 0x64, 0x01, 0x13, 0x01, // Ťē (U+0164 U+0113)
  0x01, 0x64, 0x01, 0x15, 0x01, // Ťĕ (U+0164 U+0115)
  0x01, 0x64, 0x01, 0x17, 0x01, // Ťė (U+0164 U+0117)
  0x01, 0x64, 0x01, 0x19, 0x01, // Ťę (U+0164 U+0119)
  0x01, 0x64, 0x01, 0x1B, 0x01, // Ťě (U+0164 U+011B)
  0x01, 0x64, 0x01, 0x1D, 0x01, // Ťĝ (U+0164 U+011D)
  0x01, 0x64, 0x01, 0x1F, 0x01, // Ťğ (U+0164 U+011F)
  0x01, 0x64, 0x01, 0x21, 0x01, // Ťġ (U+0164 U+0121)
  0x01, 0x64, 0x01, 0x23, 0x01, // Ťģ (U+0164 U+0123)
  0x01, 0x64, 0x01, 0x4D, 0x01, // Ťō (U+0164 U+014D)
  0x01, 0x64, 0x01, 0x4F, 0x01, // Ťŏ (U+0164 U+014F)
  0x01, 0x64, 0x01, 0x51, 0x01, // Ťő (U+0164 U+0151)
  0x01, 0x64, 0x01, 0x53, 0x01, // Ťœ (U+0164 U+0153)
  0x01, 0x64, 0x20, 0x1A, 0x01, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x01, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x01, // Ť… (U+0164 U+2026)
  0x01, 0x66, 0x00, 0x2C, 0x01, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2E, 0x01, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0x40, 0x01, // Ŧ@ (U+0166 U+0040)
  0x01, 0x66, 0x00, 0x41, 0x01, // ŦA (U+0166 U+0041)
  0x01, 0x66, 0x00, 0x61, 0x01, // Ŧa (U+0166 U+0061)
  0x01, 0x66, 0x00, 0x63, 0x01, // Ŧc (U+0166 U+0063)
  0x01, 0x66, 0x00, 0x64, 0x01, // Ŧd (U+0166 U+0064)
  0x01, 0x66, 0x00, 0x65, 0x01, // Ŧe (U+0166 U+0065)
  0x01, 0x66, 0x00, 0x67, 0x01, // Ŧg (U+0166 U+0067)
  0x01, 0x66, 0x00, 0x6F, 0x01, // Ŧo (U+0166 U+006F)
  0x01, 0x66, 0x00, 0x71, 0x01, // Ŧq (U+0166 U+0071)
  0x01, 0x66, 0x00, 0xC0, 0x01, // ŦÀ (U+0166 U+00C0)
  0x01, 0x66, 0x00, 0xC1, 0x01, // ŦÁ (U+0166 U+00C1)
  0x01, 0x66, 0x00, 0xC2, 0x01, // ŦÂ (U+0166 U+00C2)
  0x01, 0x66, 0x00, 0xC3, 0x01, // ŦÃ (U+0166 U+00C3)
  0x01, 0x66, 0x00, 0xC4, 0x01, // ŦÄ (U+0166 U+00C4)
  0x01, 0x66, 0x00, 0xC5, 0x01, // ŦÅ (U+0166 U+00C5)
  0x01, 0x66, 0x00, 0xC6, 0x01, // ŦÆ (U+0166 U+00C6)
  0x01, 0x66, 0x00, 0xE0, 0x01, // Ŧà (U+0166 U+00E0)
  0x01, 0x66, 0x00, 0xE1, 0x01, // Ŧá (U+0166 U+00E1)
  0x01, 0x66, 0x00, 0xE2, 0x01, // Ŧâ (U+0166 U+00E2)
  0x01, 0x66, 0x00, 0xE3, 0x01, // Ŧã (U+0166 U+00E3)
  0x01, 0x66, 0x00, 0xE4, 0x01, // Ŧä (U+0166 U+00E4)
  0x01, 0x66, 0x00, 0xE5, 0x01, // Ŧå (U+0166 U+00E5)
  0x01, 0x66, 0x00, 0xE6, 0x01, // Ŧæ (U+0166 U+00E6)
  0x01, 0x66, 0x00, 0xE7, 0x01, // Ŧç (U+0166 U+00E7)
  0x01, 0x66, 0x00, 0xE8, 0x01, // Ŧè (U+0166 U+00E8)
  0x01, 0x66, 0x00, 0xE9, 0x01, // Ŧé (U+0166 U+00E9)
  0x01, 0x66, 0x00, 0xEA, 0x01, // Ŧê (U+0166 U+00EA)
  0x01, 0x66, 0x00, 0xEB, 0x01, // Ŧë (U+0166 U+00EB)
  0x01, 0x66, 0x00, 0xF0, 0x01, // Ŧð (U+0166 U+00F0)
  0x01, 0x66, 0x00, 0xF2, 0x01, // Ŧò (U+0166 U+00F2)
  0x01, 0x66, 0x00, 0xF3, 0x01, // Ŧó (U+0166 U+00F3)
  0x01, 0x66, 0x00, 0xF4, 0x01, // Ŧô (U+0166 U+00F4)
  0x01, 0x66, 0x00, 0xF5, 0x01, // Ŧõ (U+0166 U+00F5)
  0x01, 0x66, 0x00, 0xF6, 0x01, // Ŧö (U+0166 U+00F6)
  0x01, 0x66, 0x00, 0xF8, 0x01, // Ŧø (U+0166 U+00F8)
  0x01, 0x66, 0x01, 0x00, 0x01, // ŦĀ (U+0166 U+0100)
  0x01, 0x66, 0x01, 0x01, 0x01, // Ŧā (U+0166 U+0101)
  0x01, 0x66, 0x01, 0x02, 0x01, // ŦĂ (U+0166 U+0102)
  0x01, 0x66, 0x01, 0x03, 0x01, // Ŧă (U+0166 U+0103)
  0x01, 0x66, 0x01, 0x04, 0x01, // ŦĄ (U+0166 U+0104)
  0x01, 0x66, 0x01, 0x05, 0x01, // Ŧą (U+0166 U+0105)
  0x01, 0x66, 0x01, 0x07, 0x01, // Ŧć (U+0166 U+0107)
  0x01, 0x66, 0x01, 0x09, 0x01, // Ŧĉ (U+0166 U+0109)
  0x01, 0x66, 0x01, 0x0B, 0x01, // Ŧċ (U+0166 U+010B)
  0x01, 0x66, 0x01, 0x0D, 0x01, // Ŧč (U+0166 U+010D)
  0x01, 0x66, 0x01, 0x0F, 0x01, // Ŧď (U+0166 U+010F)
  0x01, 0x66, 0x01, 0x11, 0x01, // Ŧđ (U+0166 U+0111)
  0x01, 0x66, 0x01, 0x13, 0x01, // Ŧē (U+0166 U+0113)
  0x01, 0x66, 0x01, 0x15, 0x01, // Ŧĕ (U+0166 U+0115)
  0x01, 0x66, 0x01, 0x17, 0x01, // Ŧė (U+0166 U+0117)
  0x01, 0x66, 0x01, 0x19, 0x01, // Ŧę (U+0166 U+0119)
  0x01, 0x66, 0x01, 0x1B, 0x01, // Ŧě (U+0166 U+011B)
  0x01, 0x66, 0x01, 0x1D, 0x01, // Ŧĝ (U+0166 U+011D)
  0x01, 0x66, 0x01, 0x1F, 0x01, // Ŧğ (U+0166 U+011F)
  0x01, 0x66, 0x01, 0x21, 0x01, // Ŧġ (U+0166 U+0121)
  0x01, 0x66, 0x01, 0x23, 0x01, // Ŧģ (U+0166 U+0123)
  0x01, 0x66, 0x01, 0x4D, 0x01, // Ŧō (U+0166 U+014D)
  0x01, 0x66, 0x01, 0x4F, 0x01, // Ŧŏ (U+0166 U+014F)
  0x01, 0x66, 0x01, 0x51, 0x01, // Ŧő (U+0166 U+0151)
  0x01, 0x66, 0x01, 0x53, 0x01, // Ŧœ (U+0166 U+0153)
  0x01, 0x66, 0x20, 0x1A, 0x01, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x01, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x01, // Ŧ… (U+0166 U+2026)
  0x01, 0x68, 0x00, 0xC6, 0x01, // ŨÆ (U+0168 U+00C6)
  0x01, 0x6A, 0x00, 0xC6, 0x01, // ŪÆ (U+016A U+00C6)
  0x01, 0x6C, 0x00, 0xC6, 0x01, // ŬÆ (U+016C U+00C6)
  0x01, 0x6E, 0x00, 0xC6, 0x01, // ŮÆ (U+016E U+00C6)
  0x01, 0x70, 0x00, 0xC6, 0x01, // ŰÆ (U+0170 U+00C6)
  0x01, 0x72, 0x00, 0xC6, 0x01, // ŲÆ (U+0172 U+00C6)
  0x01, 0x74, 0x00, 0x2C, 0x01, // Ŵ, (U+0174 U+002C)
  0x01, 0x74, 0x00, 0x2E, 0x01, // Ŵ. (U+0174 U+002E)
  0x01, 0x74, 0x00, 0x40, 0x01, // Ŵ@ (U+0174 U+0040)
  0x01, 0x74, 0x00, 0x41, 0x01, // ŴA (U+0174 U+0041)
  0x01, 0x74, 0x00, 0x61, 0x01, // Ŵa (U+0174 U+0061)
  0x01, 0x74, 0x00, 0x63, 0x01, // Ŵc (U+0174 U+0063)
  0x01, 0x74, 0x00, 0x64, 0x01, // Ŵd (U+0174 U+0064)
  0x01, 0x74, 0x00, 0x65, 0x01, // Ŵe (U+0174 U+0065)
  0x01, 0x74, 0x00, 0x67, 0x01, // Ŵg (U+0174 U+0067)
  0x01, 0x74, 0x00, 0x6F, 0x01, // Ŵo (U+0174 U+006F)
  0x01, 0x74, 0x00, 0x71, 0x01, // Ŵq (U+0174 U+0071)
  0x01, 0x74, 0x00, 0x73, 0x01, // Ŵs (U+0174 U+0073)
  0x01, 0x74, 0x00, 0x7A, 0x01, // Ŵz (U+0174 U+007A)
  0x01, 0x74, 0x00, 0xC0, 0x01, // ŴÀ (U+0174 U+00C0)
  0x01, 0x74, 0x00, 0xC1, 0x01, // ŴÁ (U+0174 U+00C1)
  0x01, 0x74, 0x00, 0xC2, 0x01, // ŴÂ (U+0174 U+00C2)
  0x01, 0x74, 0x00, 0xC3, 0x01, // ŴÃ (U+0174 U+00C3)
  0x01, 0x74, 0x00, 0xC4, 0x01, // ŴÄ (U+0174 U+00C4)
  0x01, 0x74, 0x00, 0xC5, 0x01, // ŴÅ (U+0174 U+00C5)
  0x01, 0x74, 0x00, 0xC6, 0x02, // ŴÆ (U+0174 U+00C6)
  0x01, 0x74, 0x00, 0xE0, 0x01, // Ŵà (U+0174 U+00E0)
  0x01, 0x74, 0x00, 0xE1, 0x01, // Ŵá (U+0174 U+00E1)
  0x01, 0x74, 0x00, 0xE2, 0x01, // Ŵâ (U+0174 U+00E2)
  0x01, 0x74, 0x00, 0xE3, 0x01, // Ŵã (U+0174 U+00E3)
  0x01, 0x74, 0x00, 0xE4, 0x01, // Ŵä (U+0174 U+00E4)
  0x01, 0x74, 0x00, 0xE5, 0x01, // Ŵå (U+0174 U+00E5)
  0x01, 0x74, 0x00, 0xE6, 0x01, // Ŵæ (U+0174 U+00E6)
  0x01, 0x74, 0x00, 0xE7, 0x01, // Ŵç (U+0174 U+00E7)
  0x01, 0x74, 0x00, 0xE8, 0x01, // Ŵè (U+0174 U+00E8)
  0x01, 0x74, 0x00, 0xE9, 0x01, // Ŵé (U+0174 U+00E9)
  0x01, 0x74, 0x00, 0xEA, 0x01, // Ŵê (U+0174 U+00EA)
  0x01, 0x74, 0x00, 0xEB, 0x01, // Ŵë (U+0174 U+00EB)
  0x01, 0x74, 0x00, 0xF0, 0x01, // Ŵð (U+0174 U+00F0)
  0x01, 0x74, 0x00, 0xF2, 0x01, // Ŵò (U+0174 U+00F2)
  0x01, 0x74, 0x00, 0xF3, 0x01, // Ŵó (U+0174 U+00F3)
  0x01, 0x74, 0x00, 0xF4, 0x01, // Ŵô (U+0174 U+00F4)
  0x01, 0x74, 0x00, 0xF5, 0x01, // Ŵõ (U+0174 U+00F5)
  0x01, 0x74, 0x00, 0xF6, 0x01, // Ŵö (U+0174 U+00F6)
  0x01, 0x74, 0x00, 0xF8, 0x01, // Ŵø (U+0174 U+00F8)
  0x01, 0x74, 0x01, 0x00, 0x01, // ŴĀ (U+0174 U+0100)
  0x01, 0x74, 0x01, 0x01, 0x01, // Ŵā (U+0174 U+0101)
  0x01, 0x74, 0x01, 0x02, 0x01, // ŴĂ (U+0174 U+0102)
  0x01, 0x74, 0x01, 0x03, 0x01, // Ŵă (U+0174 U+0103)
  0x01, 0x74, 0x01, 0x04, 0x01, // ŴĄ (U+0174 U+0104)
  0x01, 0x74, 0x01, 0x05, 0x01, // Ŵą (U+0174 U+0105)
  0x01, 0x74, 0x01, 0x07, 0x01, // Ŵć (U+0174 U+0107)
  0x01, 0x74, 0x01, 0x09, 0x01, // Ŵĉ (U+0174 U+0109)
  0x01, 0x74, 0x01, 0x0B, 0x01, // Ŵċ (U+0174 U+010B)
  0x01, 0x74, 0x01, 0x0D, 0x01, // Ŵč (U+0174 U+010D)
  0x01, 0x74, 0x01, 0x0F, 0x01, // Ŵď (U+0174 U+010F)
  0x01, 0x74, 0x01, 0x11, 0x01, // Ŵđ (U+0174 U+0111)
  0x01, 0x74, 0x01, 0x13, 0x01, // Ŵē (U+0174 U+0113)
  0x01, 0x74, 0x01, 0x15, 0x01, // Ŵĕ (U+0174 U+0115)
  0x01, 0x74, 0x01, 0x17, 0x01, // Ŵė (U+0174 U+0117)
  0x01, 0x74, 0x01, 0x19, 0x01, // Ŵę (U+0174 U+0119)
  0x01, 0x74, 0x01, 0x1B, 0x01, // Ŵě (U+0174 U+011B)
  0x01, 0x74, 0x01, 0x1D, 0x01, // Ŵĝ (U+0174 U+011D)
  0x01, 0x74, 0x01, 0x1F, 0x01, // Ŵğ (U+0174 U+011F)
  0x01, 0x74, 0x01, 0x21, 0x01, // Ŵġ (U+0174 U+0121)
  0x01, 0x74, 0x01, 0x23, 0x01, // Ŵģ (U+0174 U+0123)
  0x01, 0x74, 0x01, 0x4D, 0x01, // Ŵō (U+0174 U+014D)
  0x01, 0x74, 0x01, 0x4F, 0x01, // Ŵŏ (U+0174 U+014F)
  0x01, 0x74, 0x01, 0x51, 0x01, // Ŵő (U+0174 U+0151)
  0x01, 0x74, 0x01, 0x53, 0x01, // Ŵœ (U+0174 U+0153)
  0x01, 0x74, 0x01, 0x5B, 0x01, // Ŵś (U+0174 U+015B)
  0x01, 0x74, 0x01, 0x5D, 0x01, // Ŵŝ (U+0174 U+015D)
  0x01, 0x74, 0x01, 0x5F, 0x01, // Ŵş (U+0174 U+015F)
  0x01, 0x74, 0x01, 0x61, 0x01, // Ŵš (U+0174 U+0161)
  0x01, 0x74, 0x01, 0x7A, 0x01, // Ŵź (U+0174 U+017A)
  0x01, 0x74, 0x01, 0x7C, 0x01, // Ŵż (U+0174 U+017C)
  0x01, 0x74, 0x01, 0x7E, 0x01, // Ŵž (U+0174 U+017E)
  0x01, 0x74, 0x20, 0x1A, 0x01, // Ŵ‚ (U+0174 U+201A)
  0x01, 0x74, 0x20, 0x1E, 0x01, // Ŵ„ (U+0174 U+201E)
  0x01, 0x74, 0x20, 0x26, 0x01, // Ŵ… (U+0174 U+2026)
  0x01, 0x75, 0x00, 0x2C, 0x01, // ŵ, (U+0175 U+002C)
  0x01, 0x75, 0x00, 0x2E, 0x01, // ŵ. (U+0175 U+002E)
  0x01, 0x75, 0x00, 0x41, 0x01, // ŵA (U+0175 U+0041)
  0x01, 0x75, 0x00, 0xC0, 0x01, // ŵÀ (U+0175 U+00C0)
  0x01, 0x75, 0x00, 0xC1, 0x01, // ŵÁ (U+0175 U+00C1)
  0x01, 0x75, 0x00, 0xC2, 0x01, // ŵÂ (U+0175 U+00C2)
  0x01, 0x75, 0x00, 0xC3, 0x01, // ŵÃ (U+0175 U+00C3)
  0x01, 0x75, 0x00, 0xC4, 0x01, // ŵÄ (U+0175 U+00C4)
  0x01, 0x75, 0x00, 0xC5, 0x01, // ŵÅ (U+0175 U+00C5)
  0x01, 0x75, 0x01, 0x00, 0x01, // ŵĀ (U+0175 U+0100)
  0x01, 0x75, 0x01, 0x02, 0x01, // ŵĂ (U+0175 U+0102)
  0x01, 0x75, 0x01, 0x04, 0x01, // ŵĄ (U+0175 U+0104)
  0x01, 0x75, 0x20, 0x1A, 0x01, // ŵ‚ (U+0175 U+201A)
  0x01, 0x75, 0x20, 0x1E, 0x01, // ŵ„ (U+0175 U+201E)
  0x01, 0x75, 0x20, 0x26, 0x01, // ŵ… (U+0175 U+2026)
  0x01, 0x76, 0x00, 0x2C, 0x01, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x01, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x00, 0x40, 0x01, // Ŷ@ (U+0176 U+0040)
  0x01, 0x76, 0x00, 0x41, 0x01, // ŶA (U+0176 U+0041)
  0x01, 0x76, 0x00, 0x43, 0x01, // ŶC (U+0176 U+0043)
  0x01, 0x76, 0x00, 0x47, 0x01, // ŶG (U+0176 U+0047)
  0x01, 0x76, 0x00, 0x4F, 0x01, // ŶO (U+0176 U+004F)
  0x01, 0x76, 0x00, 0x51, 0x01, // ŶQ (U+0176 U+0051)
  0x01, 0x76, 0x00, 0x61, 0x01, // Ŷa (U+0176 U+0061)
  0x01, 0x76, 0x00, 0x63, 0x01, // Ŷc (U+0176 U+0063)
  0x01, 0x76, 0x00, 0x64, 0x01, // Ŷd (U+0176 U+0064)
  0x01, 0x76, 0x00, 0x65, 0x01, // Ŷe (U+0176 U+0065)
  0x01, 0x76, 0x00, 0x67, 0x01, // Ŷg (U+0176 U+0067)
  0x01, 0x76, 0x00, 0x6F, 0x01, // Ŷo (U+0176 U+006F)
  0x01, 0x76, 0x00, 0x71, 0x01, // Ŷq (U+0176 U+0071)
  0x01, 0x76, 0x00, 0x73, 0x01, // Ŷs (U+0176 U+0073)
  0x01, 0x76, 0x00, 0xC0, 0x01, // ŶÀ (U+0176 U+00C0)
  0x01, 0x76, 0x00, 0xC1, 0x01, // ŶÁ (U+0176 U+00C1)
  0x01, 0x76, 0x00, 0xC2, 0x01, // ŶÂ (U+0176 U+00C2)
  0x01, 0x76, 0x00, 0xC3, 0x01, // ŶÃ (U+0176 U+00C3)
  0x01, 0x76, 0x00, 0xC4, 0x01, // ŶÄ (U+0176 U+00C4)
  0x01, 0x76, 0x00, 0xC5, 0x01, // ŶÅ (U+0176 U+00C5)
  0x01, 0x76, 0x00, 0xC6, 0x01, // ŶÆ (U+0176 U+00C6)
  0x01, 0x76, 0x00, 0xC7, 0x01, // ŶÇ (U+0176 U+00C7)
  0x01, 0x76, 0x00, 0xD2, 0x01, // ŶÒ (U+0176 U+00D2)
  0x01, 0x76, 0x00, 0xD3, 0x01, // ŶÓ (U+0176 U+00D3)
  0x01, 0x76, 0x00, 0xD4, 0x01, // ŶÔ (U+0176 U+00D4)
  0x01, 0x76, 0x00, 0xD5, 0x01, // ŶÕ (U+0176 U+00D5)
  0x01, 0x76, 0x00, 0xD6, 0x01, // ŶÖ (U+0176 U+00D6)
  0x01, 0x76, 0x00, 0xD8, 0x01, // ŶØ (U+0176 U+00D8)
  0x01, 0x76, 0x00, 0xE0, 0x01, // Ŷà (U+0176 U+00E0)
  0x01, 0x76, 0x00, 0xE1, 0x01, // Ŷá (U+0176 U+00E1)
  0x01, 0x76, 0x00, 0xE2, 0x01, // Ŷâ (U+0176 U+00E2)
  0x01, 0x76, 0x00, 0xE3, 0x01, // Ŷã (U+0176 U+00E3)
  0x01, 0x76, 0x00, 0xE4, 0x01, // Ŷä (U+0176 U+00E4)
  0x01, 0x76, 0x00, 0xE5, 0x01, // Ŷå (U+0176 U+00E5)
  0x01, 0x76, 0x00, 0xE6, 0x01, // Ŷæ (U+0176 U+00E6)
  0x01, 0x76, 0x00, 0xE7, 0x01, // Ŷç (U+0176 U+00E7)
  0x01, 0x76, 0x00, 0xE8, 0x01, // Ŷè (U+0176 U+00E8)
  0x01, 0x76, 0x00, 0xE9, 0x01, // Ŷé (U+0176 U+00E9)
  0x01, 0x76, 0x00, 0xEA, 0x01, // Ŷê (U+0176 U+00EA)
  0x01, 0x76, 0x00, 0xEB, 0x01, // Ŷë (U+0176 U+00EB)
  0x01, 0x76, 0x00, 0xF0, 0x01, // Ŷð (U+0176 U+00F0)
  0x01, 0x76, 0x00, 0xF2, 0x01, // Ŷò (U+0176 U+00F2)
  0x01, 0x76, 0x00, 0xF3, 0x01, // Ŷó (U+0176 U+00F3)
  0x01, 0x76, 0x00, 0xF4, 0x01, // Ŷô (U+0176 U+00F4)
  0x01, 0x76, 0x00, 0xF5, 0x01, // Ŷõ (U+0176 U+00F5)
  0x01, 0x76, 0x00, 0xF6, 0x01, // Ŷö (U+0176 U+00F6)
  0x01, 0x76, 0x00, 0xF8, 0x01, // Ŷø (U+0176 U+00F8)
  0x01, 0x76, 0x01, 0x00, 0x01, // ŶĀ (U+0176 U+0100)
  0x01, 0x76, 0x01, 0x01, 0x01, // Ŷā (U+0176 U+0101)
  0x01, 0x76, 0x01, 0x02, 0x01, // ŶĂ (U+0176 U+0102)
  0x01, 0x76, 0x01, 0x03, 0x01, // Ŷă (U+0176 U+0103)
  0x01, 0x76, 0x01, 0x04, 0x01, // ŶĄ (U+0176 U+0104)
  0x01, 0x76, 0x01, 0x05, 0x01, // Ŷą (U+0176 U+0105)
  0x01, 0x76, 0x01, 0x06, 0x01, // ŶĆ (U+0176 U+0106)
  0x01, 0x76, 0x01, 0x07, 0x01, // Ŷć (U+0176 U+0107)
  0x01, 0x76, 0x01, 0x08, 0x01, // ŶĈ (U+0176 U+0108)
  0x01, 0x76, 0x01, 0x09, 0x01, // Ŷĉ (U+0176 U+0109)
  0x01, 0x76, 0x01, 0x0A, 0x01, // ŶĊ (U+0176 U+010A)
  0x01, 0x76, 0x01, 0x0B, 0x01, // Ŷċ (U+0176 U+010B)
  0x01, 0x76, 0x01, 0x0C, 0x01, // ŶČ (U+0176 U+010C)
  0x01, 0x76, 0x01, 0x0D, 0x01, // Ŷč (U+0176 U+010D)
  0x01, 0x76, 0x01, 0x0F, 0x01, // Ŷď (U+0176 U+010F)
  0x01, 0x76, 0x01, 0x11, 0x01, // Ŷđ (U+0176 U+0111)
  0x01, 0x76, 0x01, 0x13, 0x01, // Ŷē (U+0176 U+0113)
  0x01, 0x76, 0x01, 0x15, 0x01, // Ŷĕ (U+0176 U+0115)
  0x01, 0x76, 0x01, 0x17, 0x01, // Ŷė (U+0176 U+0117)
  0x01, 0x76, 0x01, 0x19, 0x01, // Ŷę (U+0176 U+0119)
  0x01, 0x76, 0x01, 0x1B, 0x01, // Ŷě (U+0176 U+011B)
  0x01, 0x76, 0x01, 0x1C, 0x01, // ŶĜ (U+0176 U+011C)
  0x01, 0x76, 0x01, 0x1D, 0x01, // Ŷĝ (U+0176 U+011D)
  0x01, 0x76, 0x01, 0x1E, 0x01, // ŶĞ (U+0176 U+011E)
  0x01, 0x76, 0x01, 0x1F, 0x01, // Ŷğ (U+0176 U+011F)
  0x01, 0x76, 0x01, 0x20, 0x01, // ŶĠ (U+0176 U+0120)
  0x01, 0x76, 0x01, 0x21, 0x01, // Ŷġ (U+0176 U+0121)
  0x01, 0x76, 0x01, 0x22, 0x01, // ŶĢ (U+0176 U+0122)
  0x01, 0x76, 0x01, 0x23, 0x01, // Ŷģ (U+0176 U+0123)
  0x01, 0x76, 0x01, 0x4C, 0x01, // ŶŌ (U+0176 U+014C)
  0x01, 0x76, 0x01, 0x4D, 0x01, // Ŷō (U+0176 U+014D)
  0x01, 0x76, 0x01, 0x4E, 0x01, // ŶŎ (U+0176 U+014E)
  0x01, 0x76, 0x01, 0x4F, 0x01, // Ŷŏ (U+0176 U+014F)
  0x01, 0x76, 0x01, 0x50, 0x01, // ŶŐ (U+0176 U+0150)
  0x01, 0x76, 0x01, 0x51, 0x01, // Ŷő (U+0176 U+0151)
  0x01, 0x76, 0x01, 0x52, 0x01, // ŶŒ (U+0176 U+0152)
  0x01, 0x76, 0x01, 0x53, 0x01, // Ŷœ (U+0176 U+0153)
  0x01, 0x76, 0x01, 0x5B, 0x01, // Ŷś (U+0176 U+015B)
  0x01, 0x76, 0x01, 0x5D, 0x01, // Ŷŝ (U+0176 U+015D)
  0x01, 0x76, 0x01, 0x5F, 0x01, // Ŷş (U+0176 U+015F)
  0x01, 0x76, 0x01, 0x61, 0x01, // Ŷš (U+0176 U+0161)
  0x01, 0x76, 0x20, 0x1A, 0x01, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x01, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x01, // Ŷ… (U+0176 U+2026)
  0x01, 0x77, 0x00, 0x2C, 0x01, // ŷ, (U+0177 U+002C)
  0x01, 0x77, 0x00, 0x2E, 0x01, // ŷ. (U+0177 U+002E)
  0x01, 0x77, 0x00, 0x41, 0x01, // ŷA (U+0177 U+0041)
  0x01, 0x77, 0x00, 0xC0, 0x01, // ŷÀ (U+0177 U+00C0)
  0x01, 0x77, 0x00, 0xC1, 0x01, // ŷÁ (U+0177 U+00C1)
  0x01, 0x77, 0x00, 0xC2, 0x01, // ŷÂ (U+0177 U+00C2)
  0x01, 0x77, 0x00, 0xC3, 0x01, // ŷÃ (U+0177 U+00C3)
  0x01, 0x77, 0x00, 0xC4, 0x01, // ŷÄ (U+0177 U+00C4)
  0x01, 0x77, 0x00, 0xC5, 0x01, // ŷÅ (U+0177 U+00C5)
  0x01, 0x77, 0x01, 0x00, 0x01, // ŷĀ (U+0177 U+0100)
  0x01, 0x77, 0x01, 0x02, 0x01, // ŷĂ (U+0177 U+0102)
  0x01, 0x77, 0x01, 0x04, 0x01, // ŷĄ (U+0177 U+0104)
  0x01, 0x77, 0x20, 0x1A, 0x01, // ŷ‚ (U+0177 U+201A)
  0x01, 0x77, 0x20, 0x1E, 0x01, // ŷ„ (U+0177 U+201E)
  0x01, 0x77, 0x20, 0x26, 0x01, // ŷ… (U+0177 U+2026)
  0x01, 0x78, 0x00, 0x2C, 0x01, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x01, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x00, 0x40, 0x01, // Ÿ@ (U+0178 U+0040)
  0x01, 0x78, 0x00, 0x41, 0x01, // ŸA (U+0178 U+0041)
  0x01, 0x78, 0x00, 0x43, 0x01, // ŸC (U+0178 U+0043)
  0x01, 0x78, 0x00, 0x47, 0x01, // ŸG (U+0178 U+0047)
  0x01, 0x78, 0x00, 0x4F, 0x01, // ŸO (U+0178 U+004F)
  0x01, 0x78, 0x00, 0x51, 0x01, // ŸQ (U+0178 U+0051)
  0x01, 0x78, 0x00, 0x61, 0x01, // Ÿa (U+0178 U+0061)
  0x01, 0x78, 0x00, 0x63, 0x01, // Ÿc (U+0178 U+0063)
  0x01, 0x78, 0x00, 0x64, 0x01, // Ÿd (U+0178 U+0064)
  0x01, 0x78, 0x00, 0x65, 0x01, // Ÿe (U+0178 U+0065)
  0x01, 0x78, 0x00, 0x67, 0x01, // Ÿg (U+0178 U+0067)
  0x01, 0x78, 0x00, 0x6F, 0x01, // Ÿo (U+0178 U+006F)
  0x01, 0x78, 0x00, 0x71, 0x01, // Ÿq (U+0178 U+0071)
  0x01, 0x78, 0x00, 0x73, 0x01, // Ÿs (U+0178 U+0073)
  0x01, 0x78, 0x00, 0xC0, 0x01, // ŸÀ (U+0178 U+00C0)
  0x01, 0x78, 0x00, 0xC1, 0x01, // ŸÁ (U+0178 U+00C1)
  0x01, 0x78, 0x00, 0xC2, 0x01, // ŸÂ (U+0178 U+00C2)
  0x01, 0x78, 0x00, 0xC3, 0x01, // ŸÃ (U+0178 U+00C3)
  0x01, 0x78, 0x00, 0xC4, 0x01, // ŸÄ (U+0178 U+00C4)
  0x01, 0x78, 0x00, 0xC5, 0x01, // ŸÅ (U+0178 U+00C5)
  0x01, 0x78, 0x00, 0xC6, 0x01, // ŸÆ (U+0178 U+00C6)
  0x01, 0x78, 0x00, 0xC7, 0x01, // ŸÇ (U+0178 U+00C7)
  0x01, 0x78, 0x00, 0xD2, 0x01, // ŸÒ (U+0178 U+00D2)
  0x01, 0x78, 0x00, 0xD3, 0x01, // ŸÓ (U+0178 U+00D3)
  0x01, 0x78, 0x00, 0xD4, 0x01, // ŸÔ (U+0178 U+00D4)
  0x01, 0x78, 0x00, 0xD5, 0x01, // ŸÕ (U+0178 U+00D5)
  0x01, 0x78, 0x00, 0xD6, 0x01, // ŸÖ (U+0178 U+00D6)
  0x01, 0x78, 0x00, 0xD8, 0x01, // ŸØ (U+0178 U+00D8)
  0x01, 0x78, 0x00, 0xE0, 0x01, // Ÿà (U+0178 U+00E0)
  0x01, 0x78, 0x00, 0xE1, 0x01, // Ÿá (U+0178 U+00E1)
  0x01, 0x78, 0x00, 0xE2, 0x01, // Ÿâ (U+0178 U+00E2)
  0x01, 0x78, 0x00, 0xE3, 0x01, // Ÿã (U+0178 U+00E3)
  0x01, 0x78, 0x00, 0xE4, 0x01, // Ÿä (U+0178 U+00E4)
  0x01, 0x78, 0x00, 0xE5, 0x01, // Ÿå (U+0178 U+00E5)
  0x01, 0x78, 0x00, 0xE6, 0x01, // Ÿæ (U+0178 U+00E6)
  0x01, 0x78, 0x00, 0xE7, 0x01, // Ÿç (U+0178 U+00E7)
  0x01, 0x78, 0x00, 0xE8, 0x01, // Ÿè (U+0178 U+00E8)
  0x01, 0x78, 0x00, 0xE9, 0x01, // Ÿé (U+0178 U+00E9)
  0x01, 0x78, 0x00, 0xEA, 0x01, // Ÿê (U+0178 U+00EA)
  0x01, 0x78, 0x00, 0xEB, 0x01, // Ÿë (U+0178 U+00EB)
  0x01, 0x78, 0x00, 0xF0, 0x01, // Ÿð (U+0178 U+00F0)
  0x01, 0x78, 0x00, 0xF2, 0x01, // Ÿò (U+0178 U+00F2)
  0x01, 0x78, 0x00, 0xF3, 0x01, // Ÿó (U+0178 U+00F3)
  0x01, 0x78, 0x00, 0xF4, 0x01, // Ÿô (U+0178 U+00F4)
  0x01, 0x78, 0x00, 0xF5, 0x01, // Ÿõ (U+0178 U+00F5)
  0x01, 0x78, 0x00, 0xF6, 0x01, // Ÿö (U+0178 U+00F6)
  0x01, 0x78, 0x00, 0xF8, 0x01, // Ÿø (U+0178 U+00F8)
  0x01, 0x78, 0x01, 0x00, 0x01, // ŸĀ (U+0178 U+0100)
  0x01, 0x78, 0x01, 0x01, 0x01, // Ÿā (U+0178 U+0101)
  0x01, 0x78, 0x01, 0x02, 0x01, // ŸĂ (U+0178 U+0102)
  0x01, 0x78, 0x01, 0x03, 0x01, // Ÿă (U+0178 U+0103)
  0x01, 0x78, 0x01, 0x04, 0x01, // ŸĄ (U+0178 U+0104)
  0x01, 0x78, 0x01, 0x05, 0x01, // Ÿą (U+0178 U+0105)
  0x01, 0x78, 0x01, 0x06, 0x01, // ŸĆ (U+0178 U+0106)
  0x01, 0x78, 0x01, 0x07, 0x01, // Ÿć (U+0178 U+0107)
  0x01, 0x78, 0x01, 0x08, 0x01, // ŸĈ (U+0178 U+0108)
  0x01, 0x78, 0x01, 0x09, 0x01, // Ÿĉ (U+0178 U+0109)
  0x01, 0x78, 0x01, 0x0A, 0x01, // ŸĊ (U+0178 U+010A)
  0x01, 0x78, 0x01, 0x0B, 0x01, // Ÿċ (U+0178 U+010B)
  0x01, 0x78, 0x01, 0x0C, 0x01, // ŸČ (U+0178 U+010C)
  0x01, 0x78, 0x01, 0x0D, 0x01, // Ÿč (U+0178 U+010D)
  0x01, 0x78, 0x01, 0x0F, 0x01, // Ÿď (U+0178 U+010F)
  0x01, 0x78, 0x01, 0x11, 0x01, // Ÿđ (U+0178 U+0111)
  0x01, 0x78, 0x01, 0x13, 0x01, // Ÿē (U+0178 U+0113)
  0x01, 0x78, 0x01, 0x15, 0x01, // Ÿĕ (U+0178 U+0115)
  0x01, 0x78, 0x01, 0x17, 0x01, // Ÿė (U+0178 U+0117)
  0x01, 0x78, 0x01, 0x19, 0x01, // Ÿę (U+0178 U+0119)
  0x01, 0x78, 0x01, 0x1B, 0x01, // Ÿě (U+0178 U+011B)
  0x01, 0x78, 0x01, 0x1C, 0x01, // ŸĜ (U+0178 U+011C)
  0x01, 0x78, 0x01, 0x1D, 0x01, // Ÿĝ (U+0178 U+011D)
  0x01, 0x78, 0x01, 0x1E, 0x01, // ŸĞ (U+0178 U+011E)
  0x01, 0x78, 0x01, 0x1F, 0x01, // Ÿğ (U+0178 U+011F)
  0x01, 0x78, 0x01, 0x20, 0x01, // ŸĠ (U+0178 U+0120)
  0x01, 0x78, 0x01, 0x21, 0x01, // Ÿġ (U+0178 U+0121)
  0x01, 0x78, 0x01, 0x22, 0x01, // ŸĢ (U+0178 U+0122)
  0x01, 0x78, 0x01, 0x23, 0x01, // Ÿģ (U+0178 U+0123)
  0x01, 0x78, 0x01, 0x4C, 0x01, // ŸŌ (U+0178 U+014C)
  0x01, 0x78, 0x01, 0x4D, 0x01, // Ÿō (U+0178 U+014D)
  0x01, 0x78, 0x01, 0x4E, 0x01, // ŸŎ (U+0178 U+014E)
  0x01, 0x78, 0x01, 0x4F, 0x01, // Ÿŏ (U+0178 U+014F)
  0x01, 0x78, 0x01, 0x50, 0x01, // ŸŐ (U+0178 U+0150)
  0x01, 0x78, 0x01, 0x51, 0x01, // Ÿő (U+0178 U+0151)
  0x01, 0x78, 0x01, 0x52, 0x01, // ŸŒ (U+0178 U+0152)
  0x01, 0x78, 0x01, 0x53, 0x01, // Ÿœ (U+0178 U+0153)
  0x01, 0x78, 0x01, 0x5B, 0x01, // Ÿś (U+0178 U+015B)
  0x01, 0x78, 0x01, 0x5D, 0x01, // Ÿŝ (U+0178 U+015D)
  0x01, 0x78, 0x01, 0x5F, 0x01, // Ÿş (U+0178 U+015F)
  0x01, 0x78, 0x01, 0x61, 0x01, // Ÿš (U+0178 U+0161)
  0x01, 0x78, 0x20, 0x1A, 0x01, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x01, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x01, // Ÿ… (U+0178 U+2026)
  0x20, 0x18, 0x00, 0x41, 0x01, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0xC0, 0x01, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x01, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x01, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x01, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x01, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x01, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xC6, 0x02, // ‘Æ (U+2018 U+00C6)
  0x20, 0x18, 0x01, 0x00, 0x01, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x02, 0x01, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x04, 0x01, // ‘Ą (U+2018 U+0104)
  0x20, 0x19, 0x00, 0x41, 0x02, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0x61, 0x01, // ’a (U+2019 U+0061)
  0x20, 0x19, 0x00, 0x63, 0x01, // ’c (U+2019 U+0063)
  0x20, 0x19, 0x00, 0x64, 0x01, // ’d (U+2019 U+0064)
  0x20, 0x19, 0x00, 0x65, 0x01, // ’e (U+2019 U+0065)
  0x20, 0x19, 0x00, 0x67, 0x01, // ’g (U+2019 U+0067)
  0x20, 0x19, 0x00, 0x6F, 0x01, // ’o (U+2019 U+006F)
  0x20, 0x19, 0x00, 0x71, 0x01, // ’q (U+2019 U+0071)
  0x20, 0x19, 0x00, 0x73, 0x01, // ’s (U+2019 U+0073)
  0x20, 0x19, 0x00, 0xC0, 0x02, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x02, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x02, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x02, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x02, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x02, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xC6, 0x02, // ’Æ (U+2019 U+00C6)
  0x20, 0x19, 0x00, 0xE0, 0x01, // ’à (U+2019 U+00E0)
  0x20, 0x19, 0x00, 0xE1, 0x01, // ’á (U+2019 U+00E1)
  0x20, 0x19, 0x00, 0xE2, 0x01, // ’â (U+2019 U+00E2)
  0x20, 0x19, 0x00, 0xE3, 0x01, // ’ã (U+2019 U+00E3)
  0x20, 0x19, 0x00, 0xE4, 0x01, // ’ä (U+2019 U+00E4)
  0x20, 0x19, 0x00, 0xE5, 0x01, // ’å (U+2019 U+00E5)
  0x20, 0x19, 0x00, 0xE6, 0x01, // ’æ (U+2019 U+00E6)
  0x20, 0x19, 0x00, 0xE7, 0x01, // ’ç (U+2019 U+00E7)
  0x20, 0x19, 0x00, 0xE8, 0x01, // ’è (U+2019 U+00E8)
  0x20, 0x19, 0x00, 0xE9, 0x01, // ’é (U+2019 U+00E9)
  0x20, 0x19, 0x00, 0xEA, 0x01, // ’ê (U+2019 U+00EA)
  0x20, 0x19, 0x00, 0xEB, 0x01, // ’ë (U+2019 U+00EB)
  0x20, 0x19, 0x00, 0xF0, 0x01, // ’ð (U+2019 U+00F0)
  0x20, 0x19, 0x00, 0xF2, 0x01, // ’ò (U+2019 U+00F2)
  0x20, 0x19, 0x00, 0xF3, 0x01, // ’ó (U+2019 U+00F3)
  0x20, 0x19, 0x00, 0xF4, 0x01, // ’ô (U+2019 U+00F4)
  0x20, 0x19, 0x00, 0xF5, 0x01, // ’õ (U+2019 U+00F5)
  0x20, 0x19, 0x00, 0xF6, 0x01, // ’ö (U+2019 U+00F6)
  0x20, 0x19, 0x00, 0xF8, 0x01, // ’ø (U+2019 U+00F8)
  0x20, 0x19, 0x01, 0x00, 0x02, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x01, 0x01, // ’ā (U+2019 U+0101)
  0x20, 0x19, 0x01, 0x02, 0x02, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x03, 0x01, // ’ă (U+2019 U+0103)
  0x20, 0x19, 0x01, 0x04, 0x02, // ’Ą (U+2019 U+0104)
  0x20, 0x19, 0x01, 0x05, 0x01, // ’ą (U+2019 U+0105)
  0x20, 0x19, 0x01, 0x07, 0x01, // ’ć (U+2019 U+0107)
  0x20, 0x19, 0x01, 0x09, 0x01, // ’ĉ (U+2019 U+0109)
  0x20, 0x19, 0x01, 0x0B, 0x01, // ’ċ (U+2019 U+010B)
  0x20, 0x19, 0x01, 0x0D, 0x01, // ’č (U+2019 U+010D)
  0x20, 0x19, 0x01, 0x0F, 0x01, // ’ď (U+2019 U+010F)
  0x20, 0x19, 0x01, 0x11, 0x01, // ’đ (U+2019 U+0111)
  0x20, 0x19, 0x01, 0x13, 0x01, // ’ē (U+2019 U+0113)
  0x20, 0x19, 0x01, 0x15, 0x01, // ’ĕ (U+2019 U+0115)
  0x20, 0x19, 0x01, 0x17, 0x01, // ’ė (U+2019 U+0117)
  0x20, 0x19, 0x01, 0x19, 0x01, // ’ę (U+2019 U+0119)
  0x20, 0x19, 0x01, 0x1B, 0x01, // ’ě (U+2019 U+011B)
  0x20, 0x19, 0x01, 0x1D, 0x01, // ’ĝ (U+2019 U+011D)
  0x20, 0x19, 0x01, 0x1F, 0x01, // ’ğ (U+2019 U+011F)
  0x20, 0x19, 0x01, 0x21, 0x01, // ’ġ (U+2019 U+0121)
  0x20, 0x19, 0x01, 0x23, 0x01, // ’ģ (U+2019 U+0123)
  0x20, 0x19, 0x01, 0x4D, 0x01, // ’ō (U+2019 U+014D)
  0x20, 0x19, 0x01, 0x4F, 0x01, // ’ŏ (U+2019 U+014F)
  0x20, 0x19, 0x01, 0x51, 0x01, // ’ő (U+2019 U+0151)
  0x20, 0x19, 0x01, 0x53, 0x01, // ’œ (U+2019 U+0153)
  0x20, 0x19, 0x01, 0x5B, 0x01, // ’ś (U+2019 U+015B)
  0x20, 0x19, 0x01, 0x5D, 0x01, // ’ŝ (U+2019 U+015D)
  0x20, 0x19, 0x01, 0x5F, 0x01, // ’ş (U+2019 U+015F)
  0x20, 0x19, 0x01, 0x61, 0x01, // ’š (U+2019 U+0161)
  0x20, 0x1A, 0x00, 0x3F, 0x01, // ‚? (U+201A U+003F)
  0x20, 0x1A, 0x00, 0x54, 0x01, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x56, 0x02, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x01, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x01, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0x76, 0x01, // ‚v (U+201A U+0076)
  0x20, 0x1A, 0x00, 0x77, 0x01, // ‚w (U+201A U+0077)
  0x20, 0x1A, 0x00, 0x79, 0x01, // ‚y (U+201A U+0079)
  0x20, 0x1A, 0x00, 0xDD, 0x01, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x00, 0xFD, 0x01, // ‚ý (U+201A U+00FD)
  0x20, 0x1A, 0x00, 0xFF, 0x01, // ‚ÿ (U+201A U+00FF)
  0x20, 0x1A, 0x01, 0x62, 0x01, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x01, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x01, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1A, 0x01, 0x74, 0x01, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x75, 0x01, // ‚ŵ (U+201A U+0175)
  0x20, 0x1A, 0x01, 0x76, 0x01, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x77, 0x01, // ‚ŷ (U+201A U+0177)
  0x20, 0x1A, 0x01, 0x78, 0x01, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x01, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0xC0, 0x01, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x01, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x01, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x01, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x01, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x01, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xC6, 0x02, // “Æ (U+201C U+00C6)
  0x20, 0x1C, 0x01, 0x00, 0x01, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x02, 0x01, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x04, 0x01, // “Ą (U+201C U+0104)
  0x20, 0x1D, 0x00, 0x41, 0x02, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0x61, 0x01, // ”a (U+201D U+0061)
  0x20, 0x1D, 0x00, 0x63, 0x01, // ”c (U+201D U+0063)
  0x20, 0x1D, 0x00, 0x64, 0x01, // ”d (U+201D U+0064)
  0x20, 0x1D, 0x00, 0x65, 0x01, // ”e (U+201D U+0065)
  0x20, 0x1D, 0x00, 0x67, 0x01, // ”g (U+201D U+0067)
  0x20, 0x1D, 0x00, 0x6F, 0x01, // ”o (U+201D U+006F)
  0x20, 0x1D, 0x00, 0x71, 0x01, // ”q (U+201D U+0071)
  0x20, 0x1D, 0x00, 0x73, 0x01, // ”s (U+201D U+0073)
  0x20, 0x1D, 0x00, 0xC0, 0x02, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x02, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x02, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x02, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x02, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x02, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xC6, 0x02, // ”Æ (U+201D U+00C6)
  0x20, 0x1D, 0x00, 0xE0, 0x01, // ”à (U+201D U+00E0)
  0x20, 0x1D, 0x00, 0xE1, 0x01, // ”á (U+201D U+00E1)
  0x20, 0x1D, 0x00, 0xE2, 0x01, // ”â (U+201D U+00E2)
  0x20, 0x1D, 0x00, 0xE3, 0x01, // ”ã (U+201D U+00E3)
  0x20, 0x1D, 0x00, 0xE4, 0x01, // ”ä (U+201D U+00E4)
  0x20, 0x1D, 0x00, 0xE5, 0x01, // ”å (U+201D U+00E5)
  0x20, 0x1D, 0x00, 0xE6, 0x01, // ”æ (U+201D U+00E6)
  0x20, 0x1D, 0x00, 0xE7, 0x01, // ”ç (U+201D U+00E7)
  0x20, 0x1D, 0x00, 0xE8, 0x01, // ”è (U+201D U+00E8)
  0x20, 0x1D, 0x00, 0xE9, 0x01, // ”é (U+201D U+00E9)
  0x20, 0x1D, 0x00, 0xEA, 0x01, // ”ê (U+201D U+00EA)
  0x20, 0x1D, 0x00, 0xEB, 0x01, // ”ë (U+201D U+00EB)
  0x20, 0x1D, 0x00, 0xF0, 0x01, // ”ð (U+201D U+00F0)
  0x20, 0x1D, 0x00, 0xF2, 0x01, // ”ò (U+201D U+00F2)
  0x20, 0x1D, 0x00, 0xF3, 0x01, // ”ó (U+201D U+00F3)
  0x20, 0x1D, 0x00, 0xF4, 0x01, // ”ô (U+201D U+00F4)
  0x20, 0x1D, 0x00, 0xF5, 0x01, // ”õ (U+201D U+00F5)
  0x20, 0x1D, 0x00, 0xF6, 0x01, // ”ö (U+201D U+00F6)
  0x20, 0x1D, 0x00, 0xF8, 0x01, // ”ø (U+201D U+00F8)
  0x20, 0x1D, 0x01, 0x00, 0x02, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x01, 0x01, // ”ā (U+201D U+0101)
  0x20, 0x1D, 0x01, 0x02, 0x02, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x03, 0x01, // ”ă (U+201D U+0103)
  0x20, 0x1D, 0x01, 0x04, 0x02, // ”Ą (U+201D U+0104)
  0x20, 0x1D, 0x01, 0x05, 0x01, // ”ą (U+201D U+0105)
  0x20, 0x1D, 0x01, 0x07, 0x01, // ”ć (U+201D U+0107)
  0x20, 0x1D, 0x01, 0x09, 0x01, // ”ĉ (U+201D U+0109)
  0x20, 0x1D, 0x01, 0x0B, 0x01, // ”ċ (U+201D U+010B)
  0x20, 0x1D, 0x01, 0x0D, 0x01, // ”č (U+201D U+010D)
  0x20, 0x1D, 0x01, 0x0F, 0x01, // ”ď (U+201D U+010F)
  0x20, 0x1D, 0x01, 0x11, 0x01, // ”đ (U+201D U+0111)
  0x20, 0x1D, 0x01, 0x13, 0x01, // ”ē (U+201D U+0113)
  0x20, 0x1D, 0x01, 0x15, 0x01, // ”ĕ (U+201D U+0115)
  0x20, 0x1D, 0x01, 0x17, 0x01, // ”ė (U+201D U+0117)
  0x20, 0x1D, 0x01, 0x19, 0x01, // ”ę (U+201D U+0119)
  0x20, 0x1D, 0x01, 0x1B, 0x01, // ”ě (U+201D U+011B)
  0x20, 0x1D, 0x01, 0x1D, 0x01, // ”ĝ (U+201D U+011D)
  0x20, 0x1D, 0x01, 0x1F, 0x01, // ”ğ (U+201D U+011F)
  0x20, 0x1D, 0x01, 0x21, 0x01, // ”ġ (U+201D U+0121)
  0x20, 0x1D, 0x01, 0x23, 0x01, // ”ģ (U+201D U+0123)
  0x20, 0x1D, 0x01, 0x4D, 0x01, // ”ō (U+201D U+014D)
  0x20, 0x1D, 0x01, 0x4F, 0x01, // ”ŏ (U+201D U+014F)
  0x20, 0x1D, 0x01, 0x51, 0x01, // ”ő (U+201D U+0151)
  0x20, 0x1D, 0x01, 0x53, 0x01, // ”œ (U+201D U+0153)
  0x20, 0x1D, 0x01, 0x5B, 0x01, // ”ś (U+201D U+015B)
  0x20, 0x1D, 0x01, 0x5D, 0x01, // ”ŝ (U+201D U+015D)
  0x20, 0x1D, 0x01, 0x5F, 0x01, // ”ş (U+201D U+015F)
  0x20, 0x1D, 0x01, 0x61, 0x01, // ”š (U+201D U+0161)
  0x20, 0x1E, 0x00, 0x3F, 0x01, // „? (U+201E U+003F)
  0x20, 0x1E, 0x00, 0x54, 0x01, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x56, 0x02, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x01, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x01, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0x76, 0x01, // „v (U+201E U+0076)
  0x20, 0x1E, 0x00, 0x77, 0x01, // „w (U+201E U+0077)
  0x20, 0x1E, 0x00, 0x79, 0x01, // „y (U+201E U+0079)
  0x20, 0x1E, 0x00, 0xDD, 0x01, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x00, 0xFD, 0x01, // „ý (U+201E U+00FD)
  0x20, 0x1E, 0x00, 0xFF, 0x01, // „ÿ (U+201E U+00FF)
  0x20, 0x1E, 0x01, 0x62, 0x01, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x01, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x01, // „Ŧ (U+201E U+0166)
  0x20, 0x1E, 0x01, 0x74, 0x01, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x75, 0x01, // „ŵ (U+201E U+0175)
  0x20, 0x1E, 0x01, 0x76, 0x01, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x77, 0x01, // „ŷ (U+201E U+0177)
  0x20, 0x1E, 0x01, 0x78, 0x01, // „Ÿ (U+201E U+0178)
  0x20, 0x26, 0x00, 0x3F, 0x01, // …? (U+2026 U+003F)
  0x20, 0x26, 0x00, 0x54, 0x01, // …T (U+2026 U+0054)
  0x20, 0x26, 0x00, 0x56, 0x02, // …V (U+2026 U+0056)
  0x20, 0x26, 0x00, 0x57, 0x01, // …W (U+2026 U+0057)
  0x20, 0x26, 0x00, 0x59, 0x01, // …Y (U+2026 U+0059)
  0x20, 0x26, 0x00, 0x76, 0x01, // …v (U+2026 U+0076)
  0x20, 0x26, 0x00, 0x77, 0x01, // …w (U+2026 U+0077)
  0x20, 0x26, 0x00, 0x79, 0x01, // …y (U+2026 U+0079)
  0x20, 0x26, 0x00, 0xDD, 0x01, // …Ý (U+2026 U+00DD)
  0x20, 0x26, 0x00, 0xFD, 0x01, // …ý (U+2026 U+00FD)
  0x20, 0x26, 0x00, 0xFF, 0x01, // …ÿ (U+2026 U+00FF)
  0x20, 0x26, 0x01, 0x62, 0x01, // …Ţ (U+2026 U+0162)
  0x20, 0x26, 0x01, 0x64, 0x01, // …Ť (U+2026 U+0164)
  0x20, 0x26, 0x01, 0x66, 0x01, // …Ŧ (U+2026 U+0166)
  0x20, 0x26, 0x01, 0x74, 0x01, // …Ŵ (U+2026 U+0174)
  0x20, 0x26, 0x01, 0x75, 0x01, // …ŵ (U+2026 U+0175)
  0x20, 0x26, 0x01, 0x76, 0x01, // …Ŷ (U+2026 U+0176)
  0x20, 0x26, 0x01, 0x77, 0x01, // …ŷ (U+2026 U+0177)
  0x20, 0x26, 0x01, 0x78, 0x01, // …Ÿ (U+2026 U+0178)
  
  // Glyph data
  // "!" (U+0021)
  0x4F, 0x84, 0xF7, 0x3F, 0x62, 0xF5, 0x1F, 0x40, 0xF4, 0x0F, 0x30, 0xE2, 0x0D, 0x10, 0x00, 0x01,
  0x03, 0xF7, 0x3E, 0x60,
  // """ (U+0022)
  0xF9, 0x1F, 0x8D, 0x70, 0xE6, 0xB5, 0x0C, 0x49, 0x30, 0xA2,
  // "#" (U+0023)
  0x38, 0x3B, 0x40, 0x95, 0x48, 0x3E, 0x10, 0xD2, 0x38, 0x32, 0xD0, 0x1E, 0x20, 0x20, 0xEA, 0x83,
  0xEE, 0xFE, 0x52, 0x83, 0x87, 0x07, 0x84, 0x83, 0xB4, 0x09, 0x54, 0x83, 0xD2, 0x0C, 0x34, 0x0E,
  0x20, 0xE3, 0x86, 0xBE, 0xFE, 0xEF, 0xEB, 0x28, 0x36, 0x90, 0x5A, 0x48, 0x39, 0x60, 0x77, 0x48,
  0x3B, 0x40, 0xA5, 0x48, 0x3E, 0x10, 0xD2, 0x30,
  // "$" (U+0024)
  0x30, 0x10, 0xA5, 0x83, 0x17, 0xD7, 0x12, 0x84, 0x2D, 0x7B, 0xAD, 0x28, 0x94, 0x9B, 0x1A, 0x2F,
  0x30, 0xAA, 0x1A, 0x07, 0x28, 0x28, 0xE3, 0xA4, 0x82, 0x1D, 0xFC, 0x58, 0x31, 0xAF, 0xD3, 0x48,
  0xC2, 0x1C, 0xCE, 0x10, 0x30, 0x1A, 0x1F, 0x61, 0xF2, 0x1A, 0x0D, 0x70, 0xE8, 0x1A, 0x1F, 0x40,
  0x5E, 0xAD, 0xD7, 0x38, 0x21, 0x4B, 0x15, 0x01, 0x0A, 0x70, 0x53,
  // "%" (U+0025)
  0x18, 0x24, 0xDE, 0x93, 0x01, 0x0D, 0x58, 0x3D, 0x71, 0xE4, 0x20, 0x80, 0x74, 0x84, 0x2F, 0x10,
  0xA9, 0x20, 0xD0, 0x14, 0x04, 0x92, 0x83, 0x9B, 0x05, 0xA5, 0x04, 0x92, 0x83, 0x9B, 0x0C, 0x35,
  0x89, 0x32, 0xF2, 0x0A, 0x93, 0xC1, 0xAE, 0xB1, 0x28, 0x92, 0xD7, 0x1E, 0x49, 0x68, 0xC0, 0xAA,
  0x28, 0x92, 0x3D, 0xE8, 0x1E, 0x0C, 0x70, 0x5E, 0x68, 0x77, 0x80, 0xE5, 0x04, 0xF1, 0x58, 0x7D,
  0x20, 0xE5, 0x04, 0xF1, 0x40, 0x50, 0xB2, 0x83, 0xC7, 0x05, 0xE5, 0x0B, 0x04, 0x28, 0x38, 0xC0,
  0xAA, 0x40, 0x20, 0xD3, 0x83, 0x1B, 0xEC, 0x11,
  // "&" (U+0026)
  0x28, 0x32, 0xBE, 0xE8, 0x78, 0x4D, 0xB0, 0x2F, 0x56, 0x90, 0x62, 0x0C, 0x08, 0x60, 0xE0, 0x82,
  0x0D, 0x05, 0x68, 0x38, 0xD0, 0x69, 0x78, 0x23, 0xFD, 0x52, 0x81, 0xDF, 0xD2, 0x83, 0x5F, 0x8F,
  0xB2, 0x0E, 0x08, 0x28, 0x90, 0x1E, 0x80, 0x5F, 0x80, 0xF1, 0x28, 0x15, 0xF4, 0x28, 0x29, 0xF7,
  0xD3, 0x81, 0x5F, 0x33, 0x81, 0xCF, 0x83, 0x81, 0x3F, 0x63, 0x82, 0x3F, 0xD1, 0x38, 0x90, 0xBD,
  0x30, 0x2C, 0x7F, 0xB1, 0x28, 0x61, 0x9E, 0xEC, 0x40, 0x7A, 0x05,
  // "'" (U+0027)
  0xF9, 0xD7, 0xB5, 0x93,
  // "(" (U+0028)
  0x00, 0x00, 0x50, 0x01, 0xB8, 0x00, 0xBB, 0x00, 0x4F, 0x40, 0x0A, 0xE0, 0x00, 0xDC, 0x00, 0x0F,
  0xB0, 0x01, 0xFA, 0x00, 0x1F, 0x90, 0x01, 0xFA, 0x00, 0x0F, 0xB0, 0x00, 0xCD, 0x00, 0x08, 0xF1,
  0x00, 0x2F, 0x60, 0x00, 0x6E, 0x10, 0x00, 0x6C, 0x00, 0x00, 0x10,
  // ")" (U+0029)
  0x41, 0x00, 0x02, 0xD4, 0x00, 0x04, 0xF3, 0x00, 0x0C, 0xB0, 0x00, 0x8F, 0x10, 0x05, 0xF5, 0x00,
  0x4F, 0x70, 0x03, 0xF8, 0x00, 0x2F, 0x80, 0x03, 0xF8, 0x00, 0x4F, 0x60, 0x06, 0xF4, 0x00, 0x9E,
  0x00, 0x0E, 0x80, 0x08, 0xD0, 0x06, 0xB1, 0x00, 0x10, 0x00, 0x00,
  // "*" (U+002A)
  0x00, 0x0E, 0x40, 0x00, 0x60, 0xB2, 0x23, 0x2E, 0xAA, 0x6E, 0x80, 0x08, 0xFD, 0x20, 0x2D, 0xBB,
  0x7E, 0x70, 0x70, 0xB2, 0x34, 0x00, 0x0D, 0x40, 0x00,
  // "+" (U+002B)
  0x30, 0x50, 0xA6, 0x05, 0x0A, 0x60, 0x50, 0xA6, 0x05, 0x0A, 0x38, 0x61, 0xEE, 0xEF, 0xEE, 0x73,
  0x05, 0x0A, 0x60, 0x50, 0xA6, 0x05, 0x0A, 0x30,
  // "," (U+002C)
  0x0D, 0x90, 0xEF, 0x03, 0xD0, 0x67, 0x48, 0x00,
  // "-" (U+002D)
  0x8E, 0xEE, 0x50,
  // "." (U+002E)
  0xED, 0xCB,
  // "/" (U+002F)
  0x30, 0x90, 0x43, 0x0C, 0x01, 0x30, 0xD3, 0x03, 0x0A, 0x30, 0x70, 0x63, 0x0A, 0x03, 0x30, 0xD3,
  0x02, 0x0C, 0x30, 0x50, 0x83, 0x08, 0x05, 0x30, 0xC0, 0x23, 0x0E, 0x30, 0x30, 0xB3, 0x00, 0x73,
  0x0A, 0x04, 0x30, 0xD0, 0x13,
  // "0" (U+0030)
  0x00, 0x6D, 0xEB, 0x20, 0x05, 0xF4, 0x0A, 0xD0, 0x0C, 0xB0, 0x02, 0xF5, 0x1F, 0x80, 0x00, 0xE9,
  0x3F, 0x70, 0x00, 0xDC, 0x4F, 0x60, 0x00, 0xCD, 0x4F, 0x50, 0x00, 0xBE, 0x4F, 0x60, 0x00, 0xCD,
  0x3F, 0x70, 0x00, 0xDC, 0x0F, 0x80, 0x00, 0xF9, 0x0C, 0xC0, 0x03, 0xF5, 0x05, 0xF4, 0x0A, 0xD0,
  0x00, 0x6D, 0xEB, 0x20,
  // "1" (U+0031)
  0x28, 0x15, 0xE5, 0x38, 0x28, 0xDF, 0x52, 0x83, 0xDC, 0x5F, 0x52, 0x83, 0x10, 0x4F, 0x54, 0x81,
  0x4F, 0x54, 0x81, 0x4F, 0x54, 0x81, 0x4F, 0x54, 0x81, 0x4F, 0x54, 0x81, 0x4F, 0x54, 0x81, 0x4F,
  0x54, 0x81, 0x4F, 0x54, 0x81, 0x7F, 0x82, 0x07, 0x0E, 0xC0, 0x40,
  // "2" (U+0032)
  0x18, 0x42, 0xAE, 0xEA, 0x22, 0x84, 0xCD, 0x11, 0xCD, 0x29, 0x07, 0x28, 0x47, 0xF3, 0x04, 0x32,
  0x81, 0x6F, 0x45, 0x81, 0x8F, 0x15, 0x0C, 0x0A, 0x58, 0x15, 0xE1, 0x48, 0x11, 0xD4, 0x50, 0xA0,
  0x85, 0x07, 0x0B, 0x38, 0x21, 0x03, 0xD3, 0x89, 0x13, 0xA1, 0xE9, 0x66, 0x6C, 0xA3, 0xE0, 0x90,
  // "3" (U+0033)
  0x18, 0x41, 0xAE, 0xEB, 0x22, 0x89, 0x0A, 0xE1, 0x0C, 0xE1, 0x0E, 0x82, 0x84, 0x6F, 0x40, 0x43,
  0x28, 0x15, 0xF4, 0x58, 0x18, 0xE1, 0x48, 0x14, 0xE5, 0x30, 0x2A, 0x09, 0x01, 0x58, 0x22, 0xBE,
  0x25, 0x81, 0x2F, 0x96, 0x98, 0x1B, 0x1D, 0x38, 0xA0, 0x1F, 0x91, 0xF8, 0x01, 0xAE, 0x20, 0x5C,
  0xEE, 0xA3, 0x10,
  // "4" (U+0034)
  0x48, 0x15, 0xF8, 0x68, 0x1C, 0xF8, 0x58, 0x27, 0x6F, 0x84, 0x83, 0x1C, 0x1F, 0x84, 0x83, 0x95,
  0x0F, 0x83, 0x84, 0x2C, 0x01, 0xF8, 0x38, 0x4B, 0x30, 0x1F, 0x82, 0x04, 0x0A, 0x28, 0x11, 0xF8,
  0x20, 0xA8, 0x00, 0xEA, 0x0E, 0x05, 0x48, 0x11, 0xF8, 0x68, 0x11, 0xF8, 0x68, 0x14, 0xFB, 0x50,
  0xBB, 0x0E, 0x10,
  // "5" (U+0035)
  0x10, 0x49, 0x0F, 0xE9, 0x20, 0x50, 0x63, 0x0D, 0x20, 0x60, 0x53, 0x03, 0x20, 0x70, 0x46, 0x09,
  0x03, 0x68, 0x4A, 0xCE, 0xD9, 0x12, 0x84, 0x42, 0x03, 0xEC, 0x68, 0x16, 0xF4, 0x58, 0x13, 0xF7,
  0x58, 0x33, 0xF6, 0x0B, 0x38, 0x90, 0x6F, 0x31, 0xF6, 0x02, 0xDA, 0x28, 0x35, 0xDE, 0xE8, 0x20,
  // "6" (U+0036)
  0x00, 0x1A, 0xEE, 0x90, 0x00, 0xCA, 0x02, 0xF6, 0x06, 0xF1, 0x00, 0xA4, 0x0B, 0xC0, 0x00, 0x00,
  0x0E, 0xA0, 0x00, 0x00, 0x0F, 0xA9, 0xEC, 0x50, 0x1F, 0xE3, 0x07, 0xF4, 0x0F, 0x90, 0x00, 0xEA,
  0x0F, 0x90, 0x00, 0xDC, 0x0C, 0xB0, 0x00, 0xDC, 0x08, 0xE0, 0x00, 0xE8, 0x01, 0xE8, 0x07, 0xF2,
  0x00, 0x3C, 0xEC, 0x40,
  // "7" (U+0037)
  0x89, 0x01, 0xFE, 0xEE, 0xEF, 0xB2, 0xC4, 0x82, 0xE7, 0x28, 0x38, 0x14, 0xF2, 0x50, 0x90, 0xD6,
  0x0E, 0x08, 0x58, 0x14, 0xF3, 0x50, 0x90, 0xE6, 0x0D, 0x09, 0x58, 0x13, 0xF4, 0x50, 0x80, 0xE6,
  0x0D, 0x0A, 0x58, 0x12, 0xF5, 0x58, 0x17, 0xF1, 0x30,
  // "8" (U+0038)
  0x00, 0x8D, 0xEC, 0x30, 0x08, 0xE3, 0x09, 0xE1, 0x0D, 0xA0, 0x01, 0xF5, 0x0E, 0xA0, 0x00, 0xF6,
  0x0A, 0xE1, 0x03, 0xF2, 0x02, 0xED, 0x5C, 0x50, 0x00, 0x5F, 0xFC, 0x20, 0x06, 0xE2, 0x4E, 0xE2,
  0x1F, 0x70, 0x02, 0xEA, 0x4F, 0x40, 0x00, 0xAD, 0x3F, 0x50, 0x00, 0xBB, 0x0C, 0xC1, 0x05, 0xF5,
  0x01, 0xAE, 0xEC, 0x50,
  // "9" (U+0039)
  0x00, 0x8E, 0xE9, 0x00, 0x08, 0xE2, 0x1C, 0xA0, 0x0E, 0x90, 0x05, 0xF2, 0x3F, 0x70, 0x01, 0xF7,
  0x3F, 0x60, 0x00, 0xF9, 0x1F, 0x80, 0x00, 0xEA, 0x0B, 0xE2, 0x08, 0xFA, 0x01, 0x9E, 0xD5, 0xF9,
  0x00, 0x00, 0x01, 0xF7, 0x00, 0x00, 0x03, 0xF4, 0x01, 0x00, 0x08, 0xD0, 0x0B, 0x50, 0x3E, 0x50,
  0x04, 0xDE, 0xC5, 0x00,
  // ":" (U+003A)
  0x84, 0x9D, 0x0A, 0xF1, 0x77, 0x48, 0x3A, 0xF1, 0x9D, 0x10,
  // ";" (U+003B)
  0x10, 0x90, 0xD2, 0x81, 0xAF, 0x17, 0x77, 0x00, 0x22, 0x85, 0xDF, 0x10, 0x7F, 0x22, 0x0D, 0x28,
  0x38, 0x60, 0x24, 0x20,
  // "<" (U+003C)
  0x60, 0x40, 0x54, 0x82, 0x19, 0xD3, 0x38, 0x15, 0xE8, 0x38, 0x22, 0xBC, 0x33, 0x81, 0x1F, 0xB6,
  0x82, 0x3D, 0xA1, 0x68, 0x17, 0xE6, 0x68, 0x22, 0xBC, 0x26, 0x05, 0x06,
  // "=" (U+003D)
  0x01, 0x80, 0x2E, 0x07, 0x77, 0x73, 0x01, 0x80, 0x2E, 0x07,
  // ">" (U+003E)
  0x01, 0x07, 0x78, 0x1A, 0xD4, 0x68, 0x24, 0xD9, 0x16, 0x81, 0x9E, 0x56, 0x81, 0x5F, 0x64, 0x81,
  0x7E, 0x73, 0x82, 0x3C, 0xB2, 0x38, 0x18, 0xE5, 0x48, 0x11, 0x91, 0x50,
  // "?" (U+003F)
  0x18, 0x96, 0x6D, 0xED, 0x70, 0x3F, 0x70, 0x4F, 0x73, 0xF1, 0x20, 0x0C, 0x50, 0xB0, 0xE5, 0x0E,
  0x0B, 0x48, 0x17, 0xF4, 0x38, 0x18, 0xE5, 0x49, 0x01, 0x50, 0xE6, 0x03, 0x60, 0x15, 0x81, 0x5F,
  0x54, 0x81, 0x4E, 0x42,
  // "@" (U+0040)
  0x48, 0x45, 0xBE, 0xEC, 0x65, 0x82, 0x1B, 0xB4, 0x28, 0x13, 0xBA, 0x40, 0xC0, 0x96, 0x0A, 0x07,
  0x20, 0x70, 0xB2, 0x85, 0x9E, 0xC8, 0x41, 0xD2, 0x8A, 0x2E, 0x20, 0xBB, 0x04, 0xF2, 0x0B, 0x26,
  0xB0, 0x4F, 0x10, 0x49, 0x28, 0x59, 0x4A, 0x70, 0xAC, 0x20, 0x60, 0xD2, 0x85, 0x94, 0xD4, 0x0D,
  0x82, 0x08, 0x0A, 0x28, 0x5A, 0x3E, 0x30, 0xF6, 0x20, 0xB0, 0x82, 0x85, 0xD0, 0xE2, 0x0D, 0x72,
  0x8B, 0x4E, 0x70, 0x2B, 0x0D, 0x30, 0x9B, 0x07, 0x8B, 0x0B, 0x30, 0xB6, 0x01, 0xBE, 0x60, 0xBD,
  0x62, 0x06, 0x0B, 0x75, 0x0D, 0x05, 0x60, 0x34, 0x82, 0x3E, 0x82, 0x28, 0x13, 0xA9, 0x58, 0x51,
  0x8C, 0xED, 0xA3, 0x40,
  // "A" (U+0041)
  0x48, 0x14, 0xF5, 0x71, 0x81, 0x9F, 0xA7, 0x18, 0x1D, 0xAE, 0x78, 0x33, 0xB6, 0xF4, 0x68, 0x38,
  0x71, 0xF9, 0x68, 0x3D, 0x20, 0xDE, 0x50, 0x30, 0xD2, 0x81, 0x8F, 0x34, 0x08, 0x09, 0x28, 0x14,
  0xF8, 0x48, 0x5D, 0xEE, 0xEE, 0xFD, 0x30, 0x20, 0xE4, 0x81, 0xAF, 0x22, 0x07, 0x09, 0x48, 0x15,
  0xF7, 0x20, 0xD0, 0x84, 0x83, 0x3F, 0xC0, 0xEA, 0x0C, 0x20, 0x5B, 0x0E,
  // "B" (U+0042)
  0x06, 0xB8, 0x2E, 0xEC, 0x53, 0x81, 0x2F, 0xA2, 0x81, 0x9F, 0x63, 0x90, 0xA3, 0x90, 0xB3, 0x90,
  0xA3, 0x90, 0xC3, 0x90, 0xA2, 0x81, 0x1F, 0xA3, 0x98, 0x4A, 0x01, 0x9E, 0x23, 0xA0, 0xEA, 0x05,
  0x49, 0x0A, 0x28, 0x14, 0xF9, 0x39, 0x0A, 0x38, 0x1A, 0xF1, 0x29, 0x0A, 0x38, 0x18, 0xF4, 0x29,
  0x0A, 0x38, 0x59, 0xF2, 0x02, 0xFA, 0x28, 0x33, 0xEB, 0x06, 0xB8, 0x3E, 0xED, 0x81, 0x10,
  // "C" (U+0043)
  0x38, 0x46, 0xCE, 0xEA, 0x22, 0x89, 0x19, 0xE4, 0x02, 0xED, 0x04, 0xF6, 0x38, 0x47, 0xD0, 0xAF,
  0x13, 0x01, 0x20, 0xE0, 0xD6, 0x81, 0x1F, 0xB6, 0x81, 0x1F, 0xB6, 0x81, 0x1F, 0xB7, 0x0E, 0x0D,
  0x78, 0x1B, 0xF1, 0x68, 0x14, 0xF7, 0x40, 0x32, 0x81, 0xAE, 0x52, 0x05, 0x0C, 0x38, 0x47, 0xDE,
  0xEA, 0x20,
  // "D" (U+0044)
  0x06, 0xB8, 0x2E, 0xED, 0x84, 0x81, 0x2F, 0xB2, 0x81, 0x5E, 0xC4, 0x90, 0xB3, 0x81, 0x4F, 0x83,
  0x90, 0xB4, 0x0D, 0x0E, 0x39, 0x0B, 0x48, 0x19, 0xF3, 0x29, 0x0B, 0x48, 0x17, 0xF5, 0x29, 0x0B,
  0x48, 0x17, 0xF6, 0x29, 0x0B, 0x48, 0x17, 0xF5, 0x29, 0x0B, 0x48, 0x19, 0xF3, 0x29, 0x0B, 0x40,
  0xD0, 0xE3, 0x90, 0xB3, 0x81, 0x4F, 0x82, 0x81, 0x3F, 0xB2, 0x81, 0x4E, 0xC2, 0x06, 0xB8, 0x2E,
  0xED, 0x83,
  // "E" (U+0045)
  0x89, 0x35, 0xEF, 0xEB, 0xBC, 0xF7, 0x01, 0xFB, 0x30, 0xA0, 0x72, 0x90, 0xB3, 0x06, 0x07, 0x29,
  0x0B, 0x30, 0x10, 0x22, 0x90, 0xB7, 0x90, 0xB7, 0xA0, 0xFE, 0x05, 0x39, 0x0B, 0x79, 0x0B, 0x79,
  0x0B, 0x79, 0x0B, 0x48, 0x3D, 0x01, 0xFB, 0x38, 0x91, 0x3F, 0x5E, 0xFE, 0xBB, 0xBE, 0xE0,
  // "F" (U+0046)
  0x06, 0xB0, 0x0E, 0xA8, 0x37, 0x02, 0xFB, 0x30, 0xB0, 0x72, 0x90, 0xB3, 0x06, 0x07, 0x29, 0x0B,
  0x30, 0x01, 0x29, 0x0B, 0x79, 0x0B, 0x7A, 0x0F, 0xE0, 0x63, 0x90, 0xB7, 0x90, 0xB7, 0x90, 0xB7,
  0x90, 0xB6, 0x82, 0x2F, 0xD1, 0x40, 0x6C, 0x06, 0x30,
  // "G" (U+0047)
  0x38, 0x43, 0xAD, 0xED, 0x84, 0x81, 0x6F, 0x62, 0x81, 0x5F, 0x92, 0x81, 0x2F, 0x74, 0x0C, 0x09,
  0x28, 0x19, 0xF1, 0x40, 0x13, 0x0E, 0x0D, 0x72, 0x90, 0xC7, 0x18, 0x11, 0xFB, 0x71, 0x81, 0x1F,
  0xC3, 0x04, 0xB8, 0x2B, 0x0E, 0xD4, 0x81, 0x3F, 0xC2, 0x81, 0xAF, 0x14, 0x90, 0xA2, 0x81, 0x3F,
  0x84, 0x90, 0xA3, 0x81, 0x7F, 0x72, 0x81, 0x1F, 0xA4, 0x85, 0x4B, 0xEE, 0xDA, 0x31,
  // "H" (U+0048)
  0x06, 0xC8, 0x11, 0x0C, 0xB8, 0x4A, 0x02, 0xFD, 0x13, 0x81, 0xAF, 0x63, 0x90, 0xB4, 0x81, 0x7F,
  0x33, 0x90, 0xB4, 0x81, 0x7F, 0x33, 0x90, 0xB4, 0x81, 0x7F, 0x33, 0x90, 0xB4, 0x81, 0x7F, 0x33,
  0xA8, 0x00, 0xEA, 0x03, 0x39, 0x0B, 0x48, 0x17, 0xF3, 0x39, 0x0B, 0x48, 0x17, 0xF3, 0x39, 0x0B,
  0x48, 0x17, 0xF3, 0x39, 0x0B, 0x48, 0x17, 0xF3, 0x28, 0x12, 0xFD, 0x48, 0x39, 0xF6, 0x06, 0xC8,
  0x11, 0x0C, 0xB0, 0xA0,
  // "I" (U+0049)
  0x06, 0xC8, 0x32, 0x03, 0xFD, 0x49, 0x0B, 0x49, 0x0B, 0x49, 0x0B, 0x49, 0x0B, 0x49, 0x0B, 0x49,
  0x0B, 0x49, 0x0B, 0x49, 0x0B, 0x49, 0x0B, 0x38, 0x12, 0xFD, 0x20, 0x6C, 0x02,
  // "J" (U+004A)
  0x10, 0x5C, 0x03, 0x28, 0x22, 0xFE, 0x14, 0x0E, 0x0C, 0x50, 0xE0, 0xC5, 0x0E, 0x0C, 0x50, 0xE0,
  0xC5, 0x0E, 0x0C, 0x50, 0xE0, 0xC5, 0x0E, 0x0C, 0x50, 0xE0, 0xC5, 0x0E, 0x0C, 0x50, 0xE0, 0xC5,
  0x0E, 0x0C, 0x59, 0x0B, 0x48, 0x12, 0xF9, 0x48, 0x1A, 0xF2, 0x28, 0x22, 0xEC, 0x43,
  // "K" (U+004B)
  0x06, 0xC0, 0x11, 0xB0, 0x62, 0x81, 0x2F, 0xD3, 0x81, 0x5F, 0x54, 0x90, 0xB3, 0x0C, 0x06, 0x59,
  0x0B, 0x20, 0x80, 0x96, 0x98, 0x2B, 0x03, 0xC7, 0x98, 0x2B, 0x1D, 0x47, 0x98, 0x2B, 0xAF, 0xB7,
  0x98, 0x3E, 0x69, 0xF5, 0x69, 0x84, 0xB0, 0x1E, 0xE1, 0x59, 0x0B, 0x28, 0x16, 0xFA, 0x59, 0x0B,
  0x38, 0x1C, 0xF4, 0x38, 0x12, 0xFD, 0x38, 0x43, 0xFE, 0x20, 0x6C, 0x01, 0x28, 0x26, 0xDF, 0x10,
  // "L" (U+004C)
  0x05, 0x0E, 0xA0, 0xD0, 0x24, 0x81, 0x1F, 0xC7, 0x90, 0xB7, 0x90, 0xB7, 0x90, 0xB7, 0x90, 0xB7,
  0x90, 0xB7, 0x90, 0xB7, 0x90, 0xB7, 0x90, 0xB4, 0x0B, 0x29, 0x0B, 0x48, 0x3E, 0x01, 0xFB, 0x38,
  0x91, 0x3E, 0x5E, 0xFE, 0xBB, 0xBE, 0xE0,
  // "M" (U+004D)
  0x06, 0xB0, 0x55, 0x0D, 0xA8, 0x1D, 0x02, 0xA0, 0xA4, 0x02, 0xA0, 0x93, 0x90, 0xB0, 0xE4, 0x82,
  0x7B, 0xF7, 0x39, 0x81, 0x7F, 0x33, 0x82, 0xB6, 0xF7, 0x39, 0x81, 0x2F, 0x83, 0x82, 0xE3, 0xF7,
  0x39, 0x10, 0xD0, 0xC2, 0x83, 0x5A, 0x2F, 0x73, 0x91, 0x87, 0x8F, 0x10, 0x95, 0x2F, 0x73, 0x91,
  0x87, 0x3F, 0x60, 0xD1, 0x2F, 0x73, 0x92, 0x86, 0xEA, 0x3B, 0x02, 0xF7, 0x39, 0x28, 0x69, 0xE8,
  0x70, 0x2F, 0x73, 0x92, 0x86, 0x5F, 0xE2, 0x02, 0xF7, 0x28, 0x12, 0xF2, 0x29, 0x0D, 0x28, 0x35,
  0xF9, 0x06, 0xB8, 0x43, 0x0B, 0x80, 0x6B, 0x0D,
  // "N" (U+004E)
  0x06, 0xA0, 0xC3, 0x06, 0xB8, 0x15, 0x02, 0xA0, 0x53, 0x81, 0x3F, 0x23, 0x90, 0xE0, 0xD4, 0x0E,
  0x49, 0x81, 0x7F, 0x63, 0x0E, 0x49, 0x10, 0xD0, 0xE3, 0x0E, 0x49, 0x18, 0x15, 0xF7, 0x20, 0xE4,
  0x92, 0x83, 0xCE, 0x10, 0xE4, 0x92, 0x83, 0x4F, 0x80, 0xE4, 0x93, 0x82, 0xBF, 0x2E, 0x49, 0x38,
  0x22, 0xFA, 0xE4, 0x94, 0x81, 0x9F, 0xE3, 0x81, 0x3F, 0x23, 0x81, 0x1E, 0xE2, 0x06, 0xB0, 0x63,
  0x08, 0x0E, 0x20,
  // "O" (U+004F)
  0x38, 0x46, 0xCE, 0xDA, 0x24, 0x81, 0xAE, 0x42, 0x81, 0x9E, 0x22, 0x81, 0x4F, 0x64, 0x0D, 0x0B,
  0x20, 0xB9, 0x58, 0x48, 0xF3, 0x0E, 0xD5, 0x84, 0x5F, 0x71, 0xFB, 0x58, 0x43, 0xF8, 0x1F, 0xB5,
  0x84, 0x3F, 0x91, 0xFB, 0x58, 0x43, 0xF8, 0x0E, 0xD5, 0x83, 0x5F, 0x70, 0xB9, 0x58, 0x58, 0xF3,
  0x04, 0xF6, 0x40, 0xD0, 0xB3, 0x81, 0x9E, 0x42, 0x81, 0x9E, 0x24, 0x84, 0x6C, 0xED, 0x92, 0x20,
  // "P" (U+0050)
  0x06, 0xB8, 0x2E, 0xEC, 0x42, 0x86, 0x3F, 0xB0, 0x1A, 0xF3, 0x29, 0x0B, 0x28, 0x11, 0xFA, 0x29,
  0x0B, 0x30, 0xE0, 0xC2, 0x90, 0xB3, 0x90, 0xC2, 0x90, 0xB2, 0x81, 0x2F, 0x92, 0x98, 0x4B, 0x02,
  0xBE, 0x12, 0xA8, 0x2E, 0xD9, 0x23, 0x90, 0xB7, 0x90, 0xB7, 0x90, 0xB6, 0x81, 0x3F, 0xD5, 0x06,
  0xC0, 0x63,
  // "Q" (U+0051)
  0x38, 0x46, 0xCE, 0xDA, 0x24, 0x81, 0xAE, 0x42, 0x81, 0x9E, 0x22, 0x81, 0x4F, 0x64, 0x0D, 0x0B,
  0x20, 0xB9, 0x58, 0x48, 0xF3, 0x0E, 0xD5, 0x84, 0x5F, 0x71, 0xFB, 0x58, 0x43, 0xF8, 0x1F, 0xB5,
  0x84, 0x3F, 0x91, 0xFB, 0x58, 0x43, 0xF8, 0x0E, 0xD5, 0x83, 0x5F, 0x60, 0xB9, 0x58, 0x58, 0xF2,
  0x05, 0xF5, 0x40, 0xD0, 0xC3, 0x81, 0xAE, 0x32, 0x81, 0x9E, 0x34, 0x84, 0x7D, 0xEF, 0xB3, 0x70,
  0x0E, 0x72, 0x81, 0xAF, 0x27, 0x18, 0x23, 0xFB, 0x17, 0x18, 0x24, 0xCF, 0x51,
  // "R" (U+0052)
  0x06, 0xB8, 0x2E, 0xEC, 0x64, 0x81, 0x3F, 0xB2, 0x81, 0x9F, 0x64, 0x90, 0xB3, 0x90, 0xB4, 0x90,
  0xB3, 0x0E, 0x0D, 0x49, 0x0B, 0x28, 0x11, 0xFA, 0x49, 0x84, 0xB0, 0x1A, 0xE2, 0x4A, 0x82, 0xEF,
  0xC1, 0x59, 0x83, 0xB0, 0xBF, 0x15, 0x98, 0x3B, 0x04, 0xF9, 0x59, 0x0B, 0x28, 0x1C, 0xF2, 0x49,
  0x0B, 0x28, 0x15, 0xFA, 0x38, 0x12, 0xFD, 0x38, 0x3C, 0xF4, 0x06, 0xC8, 0x41, 0x02, 0xBF, 0x40,
  // "S" (U+0053)
  0x28, 0x37, 0xDE, 0xD5, 0x28, 0x90, 0x8D, 0x20, 0x8F, 0x30, 0xE8, 0x28, 0x41, 0xF3, 0x0E, 0x83,
  0x01, 0x28, 0x1B, 0xD1, 0x58, 0x23, 0xFE, 0x55, 0x83, 0x3C, 0xFC, 0x25, 0x82, 0x6E, 0xE1, 0x58,
  0x33, 0xF8, 0x08, 0x48, 0x3C, 0xA3, 0xF2, 0x38, 0x97, 0xD9, 0x1E, 0xB1, 0x06, 0xF2, 0x03, 0xBE,
  0xEB, 0x31,
  // "T" (U+0054)
  0x82, 0xAF, 0xEE, 0xA0, 0xEA, 0x89, 0x72, 0xA8, 0x01, 0xF9, 0x01, 0xE3, 0xA3, 0x01, 0xF9, 0x28,
  0x1A, 0x31, 0x28, 0x11, 0xF9, 0x20, 0x14, 0x81, 0x1F, 0x97, 0x81, 0x1F, 0x97, 0x81, 0x1F, 0x97,
  0x81, 0x1F, 0x97, 0x81, 0x1F, 0x97, 0x81, 0x1F, 0x97, 0x81, 0x1F, 0x97, 0x81, 0x4F, 0xC6, 0x0A,
  0xC0, 0x32,
  // "U" (U+0055)
  0x0B, 0xB0, 0xC2, 0xB8, 0x3D, 0x07, 0xF9, 0x40, 0xB0, 0x92, 0x81, 0x4F, 0x64, 0x09, 0x06, 0x28,
  0x14, 0xF6, 0x40, 0x90, 0x62, 0x81, 0x4F, 0x64, 0x09, 0x06, 0x28, 0x14, 0xF6, 0x40, 0x90, 0x62,
  0x81, 0x4F, 0x64, 0x09, 0x06, 0x28, 0x14, 0xF6, 0x40, 0x90, 0x62, 0x81, 0x4F, 0x64, 0x09, 0x06,
  0x28, 0x14, 0xF6, 0x40, 0x90, 0x52, 0x81, 0x2F, 0x94, 0x0C, 0x02, 0x38, 0x1B, 0xF5, 0x20, 0x80,
  0xB5, 0x84, 0x7D, 0xEE, 0x91, 0x20,
  // "V" (U+0056)
  0xC8, 0x15, 0x04, 0xB8, 0x36, 0x0D, 0xF3, 0x38, 0x11, 0xF5, 0x28, 0x18, 0xF3, 0x30, 0x10, 0xE3,
  0x81, 0x3F, 0x73, 0x06, 0x09, 0x40, 0xE0, 0xC3, 0x0A, 0x05, 0x48, 0x1A, 0xF1, 0x20, 0xE5, 0x84,
  0x5F, 0x50, 0x3B, 0x58, 0x41, 0xF9, 0x08, 0x76, 0x83, 0xCD, 0x0C, 0x26, 0x82, 0x7F, 0x3D, 0x78,
  0x23, 0xFA, 0x87, 0x18, 0x1D, 0xF4, 0x71, 0x09, 0x0E, 0x50,
  // "W" (U+0057)
  0x0D, 0xB0, 0x72, 0x81, 0x5F, 0x32, 0x0B, 0xB1, 0x81, 0xBF, 0x53, 0x81, 0x8F, 0x63, 0x07, 0x0D,
  0x28, 0x17, 0xF5, 0x38, 0x1C, 0xF9, 0x30, 0x08, 0x28, 0x13, 0xF8, 0x38, 0x1E, 0xCD, 0x30, 0xB0,
  0x43, 0x0E, 0x0C, 0x28, 0x34, 0xB8, 0xF1, 0x20, 0xE4, 0x0B, 0x92, 0x86, 0x77, 0x4F, 0x40, 0x3C,
  0x48, 0x92, 0x7F, 0x30, 0xB3, 0x1F, 0x80, 0x78, 0x48, 0x33, 0xF7, 0x0E, 0x28, 0x3D, 0xB0, 0xA5,
  0x59, 0x81, 0xA3, 0xB2, 0x83, 0x9E, 0x0E, 0x15, 0x82, 0xCD, 0x68, 0x28, 0x26, 0xF5, 0xD6, 0x82,
  0x8F, 0xB4, 0x28, 0x22, 0xFB, 0x96, 0x04, 0xA4, 0x81, 0xEF, 0x56, 0x81, 0x1F, 0xC4, 0x81, 0xAF,
  0x23,
  // "X" (U+0058)
  0x09, 0xB8, 0x19, 0x08, 0xA0, 0xC2, 0x81, 0x6F, 0xC3, 0x0B, 0x0A, 0x48, 0x5C, 0xF2, 0x01, 0xD1,
  0x48, 0x44, 0xF9, 0x08, 0x66, 0x82, 0xBF, 0x4C, 0x70, 0x3A, 0x04, 0x71, 0x81, 0xBF, 0x37, 0x82,
  0x3C, 0xFB, 0x78, 0x3C, 0x38, 0xF4, 0x58, 0x45, 0xA0, 0x1E, 0xD4, 0x81, 0x1E, 0x22, 0x81, 0x7F,
  0x63, 0x0A, 0x0D, 0x38, 0x43, 0xFE, 0x20, 0xDA, 0x81, 0xC0, 0x1C, 0x02,
  // "Y" (U+0059)
  0x01, 0xC8, 0x13, 0x0D, 0xA8, 0x4C, 0x01, 0xEF, 0x23, 0x0A, 0x0C, 0x38, 0x17, 0xF6, 0x30, 0xB0,
  0x44, 0x0E, 0x0D, 0x20, 0x30, 0xC5, 0x84, 0x6F, 0x50, 0xB4, 0x68, 0x2D, 0xC3, 0xB7, 0x82, 0x6F,
  0xC4, 0x71, 0x0E, 0x0D, 0x72, 0x0E, 0x0C, 0x72, 0x0E, 0x0C, 0x72, 0x0E, 0x0C, 0x71, 0x82, 0x2F,
  0xE1, 0x60, 0x7C, 0x05, 0x20,
  // "Z" (U+005A)
  0x01, 0xA0, 0xFD, 0x84, 0xEF, 0x51, 0xF1, 0x38, 0x3D, 0xE0, 0x1C, 0x38, 0x16, 0xF7, 0x20, 0x13,
  0x00, 0xE6, 0x81, 0x7F, 0x66, 0x0E, 0x0D, 0x68, 0x17, 0xF6, 0x60, 0xE0, 0xD6, 0x81, 0x7F, 0x65,
  0x81, 0x1E, 0xD4, 0x83, 0x10, 0x8F, 0x53, 0x83, 0x49, 0x1E, 0xD4, 0x89, 0x19, 0x96, 0xFE, 0xDD,
  0xDE, 0xF8,
  // "[" (U+005B)
  0x7F, 0xFE, 0x17, 0xF6, 0x00, 0x7F, 0x30, 0x07, 0xF2, 0x00, 0x7F, 0x20, 0x07, 0xF2, 0x00, 0x7F,
  0x20, 0x07, 0xF2, 0x00, 0x7F, 0x20, 0x07, 0xF2, 0x00, 0x7F, 0x20, 0x07, 0xF2, 0x00, 0x7F, 0x20,
  0x07, 0xF2, 0x00, 0x7F, 0x30, 0x07, 0xF6, 0x00, 0x7F, 0xFE, 0x10,
  // "\" (U+005C)
  0x0D, 0x40, 0xA0, 0x43, 0x00, 0x73, 0x03, 0x0A, 0x40, 0xD4, 0x0C, 0x02, 0x30, 0x90, 0x53, 0x05,
  0x08, 0x30, 0x20, 0xC4, 0x0E, 0x40, 0xB0, 0x33, 0x07, 0x06, 0x30, 0x40, 0xA3, 0x01, 0x0D, 0x40,
  0xD0, 0x13, 0x09, 0x04,
  // "]" (U+005D)
  0x6F, 0xFF, 0x20, 0x0B, 0xF2, 0x00, 0x8F, 0x20, 0x08, 0xF2, 0x00, 0x8F, 0x20, 0x08, 0xF2, 0x00,
  0x8F, 0x20, 0x08, 0xF2, 0x00, 0x8F, 0x20, 0x08, 0xF2, 0x00, 0x8F, 0x20, 0x08, 0xF2, 0x00, 0x8F,
  0x20, 0x08, 0xF2, 0x00, 0x8F, 0x20, 0x0B, 0xF2, 0x6E, 0xFF, 0x20,
  // "^" (U+005E)
  0x30, 0x40, 0xA6, 0x81, 0xBE, 0x14, 0x82, 0x2C, 0x87, 0x48, 0x28, 0x72, 0xD4, 0x83, 0xD1, 0x0B,
  0x42, 0x05, 0x0A, 0x20, 0x50, 0xA2, 0x0B, 0x04, 0x38, 0x2E, 0x12, 0xD4, 0x08, 0x07,
  // "_" (U+005F)
  0x01, 0x80, 0x3E, 0x01,
  // "`" (U+0060)
  0x1E, 0xB0, 0x04, 0xF3, 0x00, 0x4B,
  // "a" (U+0061)
  0x01, 0xAE, 0xEB, 0x30, 0x00, 0x8F, 0x20, 0xCD, 0x00, 0x03, 0x80, 0x08, 0xF1, 0x00, 0x00, 0x00,
  0x7F, 0x10, 0x02, 0xAD, 0xEF, 0xF1, 0x00, 0xDD, 0x30, 0x7F, 0x10, 0x2F, 0x70, 0x07, 0xF1, 0x02,
  0xF6, 0x00, 0xAF, 0x10, 0x0E, 0xB0, 0x4A, 0xF4, 0x00, 0x4D, 0xD7, 0x2F, 0xF1,
  // "b" (U+0062)
  0x0B, 0xA0, 0x36, 0x81, 0x8F, 0x36, 0x81, 0x5F, 0x36, 0x81, 0x5F, 0x36, 0x85, 0x5F, 0x4A, 0xED,
  0x42, 0x89, 0x25, 0xFA, 0x20, 0xAE, 0x10, 0x5F, 0x82, 0x85, 0x3F, 0x60, 0x5F, 0x53, 0x98, 0x39,
  0x05, 0xF4, 0x38, 0x4E, 0xA0, 0x5F, 0x43, 0x98, 0x3A, 0x05, 0xF5, 0x39, 0x83, 0x90, 0x5F, 0x82,
  0x8A, 0x23, 0xF6, 0x08, 0xFA, 0x20, 0xAE, 0x1B, 0xFE, 0x1B, 0xEC, 0x31,
  // "c" (U+0063)
  0x28, 0x95, 0x7D, 0xEC, 0x40, 0x6F, 0x40, 0xBE, 0x0D, 0xB2, 0x83, 0x7C, 0x0F, 0x84, 0x81, 0x2F,
  0x74, 0x81, 0x2F, 0x75, 0x90, 0x85, 0x00, 0xC3, 0x86, 0x10, 0x5F, 0x60, 0x2C, 0x28, 0x36, 0xDE,
  0xD5,
  // "d" (U+0064)
  0x40, 0x1A, 0x0D, 0x78, 0x11, 0xDD, 0x71, 0x0A, 0x0D, 0x71, 0x0A, 0x0D, 0x48, 0x49, 0xED, 0x5A,
  0xD3, 0x85, 0x8F, 0x30, 0x7D, 0xD3, 0x0E, 0x0B, 0x39, 0x0D, 0x28, 0x11, 0xF8, 0x30, 0xC0, 0xD2,
  0x81, 0x2F, 0x73, 0x0B, 0x0D, 0x28, 0x12, 0xF7, 0x30, 0xB0, 0xD2, 0x81, 0x1F, 0x83, 0x0C, 0x0D,
  0x30, 0xE0, 0xB3, 0x90, 0xD3, 0x86, 0x8F, 0x40, 0x8B, 0xF1, 0x38, 0x39, 0xED, 0x57, 0xA0, 0x30,
  // "e" (U+0065)
  0x00, 0x6D, 0xEB, 0x20, 0x05, 0xF4, 0x0A, 0xD0, 0x0C, 0xB0, 0x03, 0xF5, 0x0F, 0x80, 0x01, 0xF7,
  0x2F, 0xFE, 0xEE, 0xF8, 0x2F, 0x70, 0x00, 0x00, 0x0F, 0x90, 0x00, 0x00, 0x0C, 0xC0, 0x00, 0x10,
  0x05, 0xF7, 0x01, 0xC2, 0x00, 0x6D, 0xED, 0x50,
  // "f" (U+0066)
  0x28, 0x32, 0xBE, 0xE6, 0x28, 0x3C, 0xB0, 0xAB, 0x29, 0x81, 0x70, 0x12, 0x81, 0x2F, 0x73, 0x07,
  0x0E, 0xA0, 0xE0, 0x82, 0x81, 0x2F, 0x74, 0x81, 0x2F, 0x74, 0x81, 0x2F, 0x74, 0x81, 0x2F, 0x74,
  0x81, 0x2F, 0x74, 0x81, 0x2F, 0x74, 0x81, 0x2F, 0x74, 0x81, 0x5F, 0xA3, 0x09, 0xC0, 0x41,
  // "g" (U+0067)
  0x01, 0xAE, 0xD7, 0xBD, 0x0A, 0xC0, 0x2E, 0x56, 0x0E, 0x80, 0x0B, 0xB0, 0x0F, 0x70, 0x0B, 0xB0,
  0x0A, 0xC1, 0x2E, 0x70, 0x01, 0xDE, 0xD8, 0x00, 0x04, 0xA0, 0x00, 0x00, 0x0A, 0x70, 0x00, 0x00,
  0x08, 0x90, 0x00, 0x00, 0x02, 0xEE, 0xED, 0xA1, 0x3D, 0x30, 0x01, 0xD8, 0x9A, 0x00, 0x00, 0xBA,
  0x7E, 0x20, 0x05, 0xF5, 0x08, 0xDE, 0xEB, 0x50,
  // "h" (U+0068)
  0x0B, 0xA0, 0x37, 0x81, 0x8F, 0x37, 0x81, 0x5F, 0x37, 0x81, 0x5F, 0x37, 0x85, 0x5F, 0x4B, 0xEC,
  0x33, 0x85, 0x5F, 0xB1, 0x1D, 0xC3, 0x81, 0x5F, 0x62, 0x81, 0x7F, 0x12, 0x81, 0x5F, 0x42, 0x81,
  0x6F, 0x22, 0x81, 0x5F, 0x32, 0x81, 0x6F, 0x32, 0x81, 0x5F, 0x32, 0x81, 0x6F, 0x32, 0x81, 0x5F,
  0x32, 0x81, 0x6F, 0x32, 0x81, 0x5F, 0x32, 0x81, 0x6F, 0x32, 0x81, 0x8F, 0x62, 0x83, 0x6F, 0x60,
  0xBB, 0x81, 0x70, 0x6A, 0x06,
  // "i" (U+0069)
  0x04, 0xE4, 0x00, 0x5F, 0x50, 0x00, 0x10, 0x00, 0x00, 0x00, 0x8F, 0xF5, 0x00, 0x6F, 0x50, 0x03,
  0xF5, 0x00, 0x3F, 0x50, 0x03, 0xF5, 0x00, 0x3F, 0x50, 0x03, 0xF5, 0x00, 0x3F, 0x50, 0x06, 0xF8,
  0x09, 0xFF, 0xFB,
  // "j" (U+006A)
  0x00, 0x4E, 0x30, 0x05, 0xF5, 0x00, 0x01, 0x00, 0x00, 0x00, 0x08, 0xFF, 0x50, 0x07, 0xF5, 0x00,
  0x3F, 0x50, 0x03, 0xF5, 0x00, 0x3F, 0x50, 0x03, 0xF5, 0x00, 0x3F, 0x50, 0x03, 0xF5, 0x00, 0x3F,
  0x50, 0x03, 0xF5, 0x00, 0x4F, 0x40, 0x06, 0xF2, 0x01, 0xCC, 0x01, 0xEB, 0x20,
  // "k" (U+006B)
  0x0B, 0xA0, 0x37, 0x81, 0x8F, 0x37, 0x81, 0x5F, 0x37, 0x81, 0x5F, 0x37, 0x83, 0x5F, 0x30, 0xCA,
  0x09, 0x28, 0x55, 0xF3, 0x02, 0xF7, 0x38, 0x45, 0xF3, 0x09, 0x84, 0x83, 0x5F, 0x35, 0xB5, 0x83,
  0x5F, 0x5E, 0xB5, 0x84, 0x5F, 0xC9, 0xF4, 0x48, 0x45, 0xF4, 0x1E, 0xC4, 0x85, 0x5F, 0x30, 0x7F,
  0x63, 0x81, 0x8F, 0x62, 0x83, 0xEE, 0x20, 0xBB, 0x84, 0x80, 0x3D, 0xF2,
  // "l" (U+006C)
  0xBF, 0xF3, 0x00, 0x8F, 0x30, 0x05, 0xF3, 0x00, 0x5F, 0x30, 0x05, 0xF3, 0x00, 0x5F, 0x30, 0x05,
  0xF3, 0x00, 0x5F, 0x30, 0x05, 0xF3, 0x00, 0x5F, 0x30, 0x05, 0xF3, 0x00, 0x5F, 0x30, 0x08, 0xF7,
  0x0B, 0xFF, 0xF9,
  // "m" (U+006D)
  0x6F, 0xF3, 0xAE, 0xD4, 0x3C, 0xEB, 0x10, 0x00, 0x6F, 0xC2, 0x0C, 0xDA, 0x02, 0xE9, 0x00, 0x03,
  0xF8, 0x00, 0x7F, 0x50, 0x0B, 0xD0, 0x00, 0x3F, 0x60, 0x05, 0xF3, 0x00, 0x9F, 0x00, 0x03, 0xF6,
  0x00, 0x5F, 0x30, 0x09, 0xF0, 0x00, 0x3F, 0x60, 0x05, 0xF3, 0x00, 0x9F, 0x00, 0x03, 0xF6, 0x00,
  0x5F, 0x30, 0x09, 0xF0, 0x00, 0x3F, 0x60, 0x05, 0xF3, 0x00, 0x9F, 0x00, 0x06, 0xF8, 0x00, 0x5F,
  0x60, 0x09, 0xF3, 0x09, 0xFF, 0xF9, 0x05, 0xFF, 0x60, 0x9F, 0xF3,
  // "n" (U+006E)
  0x7F, 0xF3, 0xAE, 0xD4, 0x00, 0x06, 0xFC, 0x20, 0xBE, 0x00, 0x03, 0xF8, 0x00, 0x5F, 0x30, 0x03,
  0xF6, 0x00, 0x4F, 0x40, 0x03, 0xF5, 0x00, 0x4F, 0x50, 0x03, 0xF5, 0x00, 0x4F, 0x50, 0x03, 0xF5,
  0x00, 0x4F, 0x50, 0x03, 0xF5, 0x00, 0x4F, 0x50, 0x06, 0xF8, 0x00, 0x4F, 0x70, 0x9F, 0xFF, 0x90,
  0x4F, 0xF8,
  // "o" (U+006F)
  0x00, 0x6D, 0xED, 0x50, 0x00, 0x6F, 0x40, 0x4F, 0x40, 0x0D, 0xB0, 0x00, 0xCC, 0x01, 0xF8, 0x00,
  0x09, 0xF0, 0x2F, 0x70, 0x00, 0x8F, 0x12, 0xF7, 0x00, 0x08, 0xF1, 0x0F, 0x80, 0x00, 0x9F, 0x00,
  0xCC, 0x00, 0x0C, 0xC0, 0x05, 0xF4, 0x04, 0xF5, 0x00, 0x06, 0xDE, 0xD6, 0x00,
  // "p" (U+0070)
  0x0B, 0xA8, 0x31, 0xBE, 0xC3, 0x28, 0x92, 0x8F, 0xA1, 0x0A, 0xE1, 0x05, 0xF8, 0x28, 0x53, 0xF6,
  0x05, 0xF5, 0x39, 0x83, 0x90, 0x5F, 0x43, 0x98, 0x3A, 0x05, 0xF4, 0x39, 0x83, 0xA0, 0x5F, 0x52,
  0x85, 0x1F, 0x90, 0x5F, 0x82, 0x8A, 0x24, 0xF6, 0x05, 0xFC, 0x10, 0xAE, 0x10, 0x5F, 0x4B, 0xEC,
  0x32, 0x81, 0x5F, 0x36, 0x81, 0x5F, 0x36, 0x81, 0x9F, 0x65, 0x0B, 0xB0, 0xA4,
  // "q" (U+0071)
  0x28, 0x39, 0xED, 0x66, 0xA8, 0x90, 0x30, 0x8F, 0x30, 0x7C, 0xF2, 0x20, 0xE0, 0xB3, 0x90, 0xD2,
  0x81, 0x1F, 0x83, 0x0C, 0x0D, 0x28, 0x12, 0xF7, 0x30, 0xB0, 0xD2, 0x81, 0x2F, 0x73, 0x0B, 0x0D,
  0x28, 0x11, 0xF8, 0x30, 0xC0, 0xD3, 0x0E, 0x0B, 0x30, 0xE0, 0xD3, 0x85, 0x8F, 0x40, 0x8D, 0xD4,
  0x84, 0x9E, 0xD5, 0xAD, 0x71, 0x0A, 0x0D, 0x71, 0x0A, 0x0D, 0x71, 0x81, 0xDF, 0x15, 0x05, 0xC0,
  0x30,
  // "r" (U+0072)
  0x07, 0xA8, 0x21, 0x9E, 0xB2, 0x89, 0x46, 0xFA, 0x27, 0xF1, 0x03, 0xFA, 0x02, 0x22, 0x81, 0x3F,
  0x75, 0x81, 0x3F, 0x65, 0x81, 0x3F, 0x65, 0x81, 0x3F, 0x65, 0x81, 0x3F, 0x65, 0x81, 0x6F, 0x84,
  0x08, 0xB0, 0xE3,
  // "s" (U+0073)
  0x03, 0xCE, 0xD5, 0x00, 0xE6, 0x06, 0xF0, 0x1F, 0x20, 0x09, 0x00, 0xEA, 0x00, 0x00, 0x05, 0xEE,
  0x60, 0x00, 0x01, 0x9F, 0xA0, 0x00, 0x00, 0x5F, 0x33, 0xB0, 0x00, 0xF4, 0x4F, 0x30, 0x6E, 0x10,
  0x8E, 0xEC, 0x40,
  // "t" (U+0074)
  0x00, 0xD1, 0x00, 0x05, 0xF1, 0x00, 0x8E, 0xFE, 0xE1, 0x08, 0xF1, 0x00, 0x08, 0xF1, 0x00, 0x08,
  0xF1, 0x00, 0x08, 0xF1, 0x00, 0x08, 0xF1, 0x00, 0x08, 0xF1, 0x00, 0x07, 0xF1, 0x00, 0x05, 0xF5,
  0x00, 0x00, 0xAE, 0xD2,
  // "u" (U+0075)
  0xAF, 0xF3, 0x0A, 0xFF, 0x20, 0x09, 0xF3, 0x00, 0x9F, 0x20, 0x06, 0xF3, 0x00, 0x6F, 0x20, 0x06,
  0xF3, 0x00, 0x6F, 0x20, 0x06, 0xF3, 0x00, 0x6F, 0x20, 0x06, 0xF3, 0x00, 0x6F, 0x20, 0x05, 0xF3,
  0x00, 0x6F, 0x20, 0x04, 0xF4, 0x00, 0x9F, 0x20, 0x01, 0xFA, 0x03, 0xCF, 0x60, 0x00, 0x5D, 0xEA,
  0x3F, 0xF7,
  // "v" (U+0076)
  0x0D, 0xB1, 0x04, 0xA8, 0x3D, 0x1D, 0xF1, 0x20, 0x50, 0xD2, 0x81, 0x8F, 0x12, 0x05, 0x08, 0x28,
  0x13, 0xF5, 0x20, 0xA0, 0x33, 0x0E, 0x0A, 0x20, 0xD4, 0x83, 0xAE, 0x04, 0x94, 0x83, 0x5F, 0x38,
  0x44, 0x82, 0x1F, 0x7C, 0x68, 0x1B, 0xDA, 0x68, 0x17, 0xF5, 0x30,
  // "w" (U+0077)
  0xB0, 0xD2, 0x0B, 0x07, 0x2B, 0x82, 0x31, 0xED, 0x30, 0xE0, 0xC2, 0x81, 0x2F, 0x32, 0x0A, 0x0E,
  0x20, 0x40, 0xD9, 0x20, 0x10, 0xD3, 0x89, 0x16, 0xF2, 0x08, 0x5F, 0x40, 0x59, 0x38, 0x91, 0x2F,
  0x50, 0xB0, 0xD9, 0x08, 0x54, 0x89, 0x0E, 0x91, 0xA0, 0x9D, 0x0C, 0x14, 0x87, 0xAC, 0x56, 0x05,
  0xF2, 0xC5, 0x87, 0x6F, 0x91, 0x01, 0xF9, 0x85, 0x81, 0x2F, 0xC3, 0x81, 0xCE, 0x46, 0x0E, 0x09,
  0x30, 0x89, 0x40,
  // "x" (U+0078)
  0x09, 0xB0, 0x60, 0xCA, 0x83, 0x80, 0x7F, 0x92, 0x90, 0x53, 0x83, 0xBE, 0x15, 0x94, 0x83, 0x2E,
  0x9C, 0x15, 0x81, 0x7F, 0x76, 0x81, 0x8D, 0xD5, 0x83, 0x3B, 0x3F, 0x74, 0x84, 0xC2, 0x09, 0xF2,
  0x20, 0x90, 0xD2, 0x83, 0x4F, 0xC1, 0xDA, 0x0B, 0x02, 0xB0, 0xE0,
  // "y" (U+0079)
  0x0E, 0xA8, 0x1D, 0x06, 0xA8, 0x2B, 0x1E, 0xE3, 0x08, 0x0C, 0x28, 0x19, 0xF1, 0x20, 0x90, 0x62,
  0x81, 0x3F, 0x62, 0x0D, 0x01, 0x38, 0x3D, 0xB0, 0x2C, 0x48, 0x38, 0xF1, 0x67, 0x48, 0x32, 0xF5,
  0xB2, 0x58, 0x1C, 0xAC, 0x68, 0x16, 0xF8, 0x68, 0x11, 0xF3, 0x60, 0x40, 0xD7, 0x0B, 0x08, 0x58,
  0x21, 0x9E, 0x14, 0x82, 0x6E, 0xC3, 0x50,
  // "z" (U+007A)
  0x19, 0x81, 0xED, 0xDA, 0x10, 0x10, 0xD2, 0x84, 0x3F, 0x90, 0x15, 0x28, 0x1B, 0xE1, 0x48, 0x14,
  0xF7, 0x50, 0xC0, 0xE5, 0x81, 0x5F, 0x65, 0x00, 0xD5, 0x81, 0x7F, 0x52, 0x83, 0xA1, 0x0E, 0xC3,
  0x86, 0xE1, 0x5F, 0xED, 0xDE, 0x91,
  // "{" (U+007B)
  0x00, 0x08, 0xED, 0x00, 0x4F, 0x70, 0x00, 0x7F, 0x30, 0x00, 0x7F, 0x20, 0x00, 0x7F, 0x20, 0x00,
  0x7F, 0x20, 0x00, 0x8F, 0x20, 0x01, 0xDD, 0x00, 0x3F, 0xD2, 0x00, 0x02, 0xDC, 0x00, 0x00, 0x8F,
  0x10, 0x00, 0x7F, 0x20, 0x00, 0x7F, 0x20, 0x00, 0x7F, 0x20, 0x00, 0x7F, 0x30, 0x00, 0x3F, 0x80,
  0x00, 0x08, 0xED,
  // "|" (U+007C)
  0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B,
  0x3B, 0x3B,
  // "}" (U+007D)
  0x82, 0x4F, 0xD4, 0x40, 0x0D, 0x40, 0x99, 0x48, 0x18, 0xF1, 0x38, 0x18, 0xF1, 0x38, 0x18, 0xF1,
  0x38, 0x18, 0xF2, 0x38, 0x13, 0xF8, 0x48, 0x17, 0xFD, 0x28, 0x13, 0xF9, 0x38, 0x17, 0xF2, 0x38,
  0x18, 0xF1, 0x38, 0x18, 0xF1, 0x38, 0x18, 0xF1, 0x30, 0x99, 0x38, 0x11, 0xDD, 0x28, 0x24, 0xEC,
  0x32,
  // "~" (U+007E)
  0x06, 0xEA, 0x00, 0x59, 0x1D, 0x17, 0xC1, 0x96, 0x3A, 0x00, 0x6D, 0xB0,
  // "¡" (U+00A1)
  0x6E, 0x37, 0xF3, 0x01, 0x00, 0x00, 0x1D, 0x02, 0xE0, 0x3F, 0x04, 0xF0, 0x5F, 0x15, 0xF2, 0x6F,
  0x37, 0xF3, 0x8F, 0x40,
  // "¢" (U+00A2)
  0x00, 0x09, 0x20, 0x00, 0x06, 0xDA, 0x50, 0x0B, 0xCB, 0x9F, 0x75, 0xF2, 0x92, 0xD9, 0xAE, 0x09,
  0x22, 0x0C, 0xC0, 0x92, 0x00, 0xCC, 0x09, 0x20, 0x0C, 0xD0, 0x92, 0x00, 0x9F, 0x09, 0x20, 0x04,
  0xF7, 0x92, 0x27, 0x08, 0xFE, 0xBE, 0x30, 0x02, 0xB7, 0x10, 0x00, 0x09, 0x20, 0x00,
  // "£" (U+00A3)
  0x28, 0x33, 0xBE, 0xE9, 0x38, 0x51, 0xE8, 0x04, 0xF6, 0x28, 0x15, 0xF1, 0x20, 0xD0, 0x52, 0x81,
  0x6F, 0x16, 0x81, 0x4F, 0x36, 0x81, 0x1F, 0x75, 0x04, 0x0E, 0xA8, 0x1E, 0xE3, 0x40, 0x70, 0xE7,
  0x81, 0x4F, 0x16, 0x04, 0x97, 0x08, 0x0A, 0x68, 0x96, 0x3E, 0x98, 0x30, 0x42, 0x0A, 0x77, 0xBE,
  0xE9, 0x10,
  // "¤" (U+00A4)
  0x40, 0x00, 0x03, 0x1B, 0xAC, 0xE9, 0xD4, 0x2E, 0x30, 0x9B, 0x06, 0x80, 0x00, 0xD0, 0x86, 0x00,
  0x0D, 0x16, 0x80, 0x00, 0xE0, 0x2F, 0x30, 0x9B, 0x0B, 0xAC, 0xE9, 0xD4, 0x40, 0x00, 0x02, 0x10,
  // "¥" (U+00A5)
  0x0E, 0xA8, 0x1D, 0x07, 0xA8, 0x27, 0x1E, 0xE3, 0x00, 0xA2, 0x81, 0x9F, 0x12, 0x0B, 0x03, 0x28,
  0x42, 0xF7, 0x01, 0xC4, 0x83, 0xCC, 0x07, 0x64, 0x82, 0x5F, 0x2C, 0x68, 0x1E, 0xA8, 0x40, 0x80,
  0xEA, 0x81, 0xEE, 0x44, 0x81, 0x7F, 0x24, 0x08, 0x0E, 0xA8, 0x1E, 0xE4, 0x48, 0x17, 0xF2, 0x68,
  0x19, 0xF5, 0x5C, 0x0A, 0x20,
  // "¦" (U+00A6)
  0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x00, 0x00, 0x00, 0x00, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B,
  0x3B, 0x3B,
  // "§" (U+00A7)
  0x05, 0xDE, 0xC3, 0x02, 0xE2, 0x0A, 0xC0, 0x6A, 0x00, 0x39, 0x06, 0xD0, 0x00, 0x00, 0x2F, 0x90,
  0x00, 0x05, 0xBE, 0xD4, 0x00, 0xB3, 0x2B, 0xF8, 0x0B, 0x70, 0x06, 0xF4, 0x6F, 0x80, 0x0B, 0x80,
  0x7F, 0xD3, 0xA6, 0x00, 0x2C, 0xFC, 0x00, 0x00, 0x09, 0xE0, 0x03, 0x00, 0x0F, 0x27, 0xA0, 0x00,
  0xE1, 0x6F, 0x30, 0x6B, 0x00, 0x8D, 0xEA, 0x10,
  // "¨" (U+00A8)
  0x99, 0x0B, 0x79, 0xA0, 0xC7,
  // "©" (U+00A9)
  0x38, 0x51, 0x8C, 0xEC, 0x81, 0x58, 0x72, 0xD7, 0x10, 0x17, 0xD2, 0x40, 0xD0, 0x35, 0x03, 0x0D,
  0x38, 0x91, 0x78, 0x02, 0xBE, 0xD5, 0x08, 0x72, 0x89, 0x1C, 0x10, 0xD6, 0x03, 0xE0, 0x1C, 0x28,
  0x2D, 0x05, 0xB3, 0x06, 0x28, 0x5D, 0x01, 0xC0, 0x87, 0x68, 0x5C, 0x11, 0xC0, 0x96, 0x68, 0x5C,
  0x10, 0xD0, 0x88, 0x60, 0xD2, 0x82, 0xC2, 0x5C, 0x38, 0x22, 0x01, 0xC2, 0x89, 0x17, 0x80, 0xD7,
  0x02, 0xC0, 0x77, 0x38, 0x7D, 0x32, 0xBE, 0xC4, 0x3D, 0x48, 0x72, 0xD7, 0x10, 0x16, 0xD2, 0x58,
  0x51, 0x8C, 0xEC, 0x81, 0x30,
  // "ª" (U+00AA)
  0x0A, 0xAB, 0x60, 0x09, 0x14, 0xE0, 0x06, 0x99, 0xF0, 0x5E, 0x03, 0xF0, 0x6D, 0x06, 0xF0, 0x1C,
  0x95, 0xE7,
  // "«" (U+00AB)
  0x00, 0xB1, 0x58, 0x07, 0xA1, 0xE1, 0x3F, 0x3B, 0x90, 0xBD, 0x4F, 0x40, 0x4F, 0x3C, 0x90, 0x08,
  0xA2, 0xE1, 0x00, 0xB1, 0x58,
  // "¬" (U+00AC)
  0x01, 0x80, 0x2E, 0x07, 0x60, 0x80, 0x76, 0x08, 0x07, 0x60, 0x80, 0x76, 0x08, 0x07,
  // "®" (U+00AE)
  0x00, 0x01, 0x8C, 0xEC, 0x81, 0x00, 0x00, 0x02, 0xD7, 0x10, 0x17, 0xD2, 0x00, 0x00, 0xD3, 0x00,
  0x00, 0x03, 0xD0, 0x00, 0x78, 0x3B, 0xB9, 0x91, 0x08, 0x70, 0x0C, 0x10, 0x6A, 0x05, 0xB0, 0x1C,
  0x00, 0xD0, 0x06, 0xA0, 0x2E, 0x00, 0xD0, 0x1C, 0x00, 0x6A, 0x07, 0xB0, 0x0C, 0x11, 0xC0, 0x06,
  0xFF, 0xD1, 0x00, 0xC1, 0x0D, 0x00, 0x6A, 0x1E, 0x20, 0x0D, 0x00, 0xC2, 0x06, 0xA0, 0x7B, 0x01,
  0xC0, 0x07, 0x82, 0xBB, 0x50, 0xB8, 0x77, 0x00, 0x0D, 0x30, 0x00, 0x00, 0x3D, 0x00, 0x00, 0x2D,
  0x71, 0x01, 0x6D, 0x20, 0x00, 0x00, 0x18, 0xCE, 0xC8, 0x10, 0x00,
  // "¯" (U+00AF)
  0x01, 0x80, 0x3E, 0x01,
  // "°" (U+00B0)
  0x04, 0xDD, 0x50, 0x0D, 0x21, 0xD1, 0x2A, 0x00, 0x84, 0x2A, 0x00, 0x84, 0x0D, 0x21, 0xC1, 0x04,
  0xDD, 0x50,
  // "±" (U+00B1)
  0x30, 0x50, 0xA6, 0x05, 0x0A, 0x60, 0x50, 0xA6, 0x05, 0x0A, 0x38, 0x61, 0xEE, 0xEF, 0xEE, 0x73,
  0x05, 0x0A, 0x60, 0x50, 0xA6, 0x05, 0x0A, 0x77, 0x50, 0x18, 0x02, 0xE0, 0x70,
  // "²" (U+00B2)
  0x07, 0xBC, 0x50, 0x3E, 0x06, 0xF1, 0x05, 0x03, 0xF1, 0x00, 0x06, 0xC0, 0x00, 0x0C, 0x30, 0x00,
  0xA3, 0x00, 0x09, 0x40, 0x35, 0x5F, 0xEE, 0xF5, 0x01, 0x11, 0x10,
  // "³" (U+00B3)
  0x08, 0xBC, 0x60, 0x3D, 0x05, 0xF1, 0x01, 0x06, 0xD0, 0x01, 0xCE, 0x30, 0x00, 0x04, 0xF3, 0x12,
  0x00, 0xF6, 0x69, 0x03, 0xF2, 0x09, 0xBB, 0x40,
  // "´" (U+00B4)
  0x01, 0xFA, 0x08, 0xC0, 0x2C, 0x10,
  // "µ" (U+00B5)
  0x7F, 0x10, 0x0A, 0xE0, 0x7F, 0x10, 0x0A, 0xE0, 0x7F, 0x10, 0x0A, 0xE0, 0x7F, 0x10, 0x0A, 0xE0,
  0x7F, 0x10, 0x0A, 0xE0, 0x7F, 0x10, 0x0A, 0xE0, 0x8F, 0x10, 0x0A, 0xE0, 0x8F, 0x30, 0x0D, 0xE0,
  0x9F, 0x90, 0x6B, 0xF1, 0x98, 0xDE, 0x71, 0xCD, 0xA5, 0x00, 0x00, 0x00, 0xA7, 0x00, 0x00, 0x00,
  0x9E, 0x30, 0x00, 0x00, 0x4E, 0x70, 0x00, 0x00,
  // "¶" (U+00B6)
  0x10, 0x60, 0xDA, 0x0E, 0xA0, 0xD0, 0x1C, 0x18, 0x28, 0x90, 0x4C, 0x18, 0x28, 0x60, 0x5C, 0x18,
  0x28, 0x60, 0x3C, 0x10, 0x80, 0x62, 0x0E, 0xB1, 0x08, 0x06, 0x28, 0x54, 0xCD, 0xF0, 0x86, 0x58,
  0x2E, 0x08, 0x65, 0x82, 0xE0, 0x86, 0x58, 0x2E, 0x08, 0x65, 0x82, 0xE0, 0x86, 0x58, 0x2E, 0x08,
  0x65, 0x82, 0xE0, 0x86, 0x58, 0x2E, 0x08, 0x64, 0x83, 0x3F, 0x08, 0x93, 0x05, 0xA1, 0x81, 0x8F,
  0xD0,
  // "·" (U+00B7)
  0xED, 0xCB,
  // "¸" (U+00B8)
  0x00, 0x60, 0x02, 0xD5, 0x00, 0x5F, 0x00, 0x3F, 0x1D, 0xD6,
  // "¹" (U+00B9)
  0x30, 0x14, 0x0A, 0x0C, 0x20, 0x20, 0xFC, 0x38, 0x13, 0x7C, 0x40, 0x70, 0xC4, 0x07, 0x0C, 0x40,
  0x70, 0xC4, 0x08, 0x0D, 0x38, 0x3B, 0xDD, 0xC2,
  // "º" (U+00BA)
  0x06, 0xBB, 0x80, 0x2F, 0x10, 0xD5, 0x5E, 0x00, 0xB8, 0x5E, 0x00, 0xB8, 0x2F, 0x10, 0xD5, 0x06,
  0xBB, 0x80,
  // "»" (U+00BB)
  0xB2, 0x0C, 0x10, 0x4C, 0x07, 0xA0, 0x0D, 0x90, 0xE6, 0x07, 0xF1, 0xAE, 0x0C, 0x90, 0xE7, 0x4D,
  0x06, 0xB0, 0xB2, 0x0C, 0x10,
  // "¼" (U+00BC)
  0x30, 0x17, 0x50, 0xA0, 0xC5, 0x08, 0x07, 0x30, 0x20, 0xFC, 0x50, 0xD0, 0x14, 0x81, 0x37, 0xC4,
  0x05, 0x09, 0x60, 0x70, 0xC4, 0x0C, 0x03, 0x60, 0x70, 0xC3, 0x02, 0x0C, 0x20, 0x14, 0x07, 0x0C,
  0x38, 0x49, 0x60, 0x2F, 0x63, 0x08, 0x0D, 0x20, 0x10, 0xD2, 0x81, 0x9D, 0x62, 0x89, 0x2B, 0xDD,
  0xC2, 0x68, 0x02, 0x8D, 0x67, 0x85, 0xD2, 0x0A, 0x1D, 0x66, 0x86, 0x4B, 0x03, 0x70, 0xD6, 0x68,
  0x7A, 0x40, 0x9C, 0xBE, 0xD8, 0x40, 0x10, 0xD5, 0x0D, 0x06, 0x50, 0x80, 0x74, 0x82, 0xBD, 0xD4,
  // "½" (U+00BD)
  0x30, 0x17, 0x40, 0xA0, 0xC4, 0x08, 0x07, 0x30, 0x20, 0xFC, 0x40, 0xD0, 0x14, 0x81, 0x37, 0xC3,
  0x05, 0x09, 0x60, 0x70, 0xC3, 0x0C, 0x03, 0x60, 0x70, 0xC2, 0x02, 0x0C, 0x70, 0x70, 0xC2, 0x84,
  0x96, 0x7B, 0xC5, 0x38, 0xA6, 0x8D, 0x01, 0xD3, 0xE0, 0x6F, 0x10, 0xBD, 0xDC, 0x98, 0x05, 0x03,
  0xF1, 0x50, 0xD0, 0x23, 0x06, 0x0C, 0x50, 0x40, 0xB4, 0x0C, 0x03, 0x50, 0xA0, 0x43, 0x0A, 0x03,
  0x50, 0x10, 0xD3, 0x83, 0x94, 0x03, 0x53, 0x08, 0x07, 0x28, 0x45, 0xFE, 0xEF, 0x57, 0x18, 0x00,
  0x11,
  // "¾" (U+00BE)
  0x18, 0x28, 0xBC, 0x63, 0x08, 0x07, 0x38, 0x43, 0xD0, 0x5F, 0x12, 0x0D, 0x01, 0x48, 0x21, 0x06,
  0xD2, 0x05, 0x09, 0x58, 0x21, 0xCE, 0x32, 0x0C, 0x03, 0x78, 0x34, 0xF3, 0x2C, 0x20, 0x12, 0x01,
  0x02, 0x29, 0x89, 0x56, 0x96, 0x02, 0xF6, 0x06, 0x90, 0x3F, 0x3D, 0x28, 0x19, 0xD6, 0x28, 0x91,
  0x9B, 0xB4, 0x68, 0x02, 0x8D, 0x66, 0x85, 0xD2, 0x0A, 0x1D, 0x65, 0x86, 0x4B, 0x03, 0x70, 0xD6,
  0x58, 0x7A, 0x40, 0x9C, 0xBE, 0xD8, 0x30, 0x10, 0xD5, 0x0D, 0x06, 0x40, 0x80, 0x74, 0x82, 0xBD,
  0xD4,
  // "¿" (U+00BF)
  0x28, 0x14, 0xE4, 0x48, 0x15, 0xF5, 0x50, 0x16, 0x03, 0x60, 0xE5, 0x01, 0x94, 0x81, 0x5E, 0x83,
  0x81, 0x4F, 0x74, 0x0B, 0x0E, 0x50, 0xE0, 0xB3, 0x82, 0x10, 0xDC, 0x28, 0x96, 0x1F, 0x37, 0xF4,
  0x07, 0xF3, 0x07, 0xDE, 0xD6, 0x10,
  // "À" (U+00C0)
  0x28, 0x11, 0xEB, 0x72, 0x81, 0x4F, 0x37, 0x20, 0x40, 0xB7, 0x76, 0x81, 0x4F, 0x57, 0x18, 0x19,
  0xFA, 0x71, 0x81, 0xDA, 0xE7, 0x83, 0x3B, 0x6F, 0x46, 0x83, 0x87, 0x1F, 0x96, 0x83, 0xD2, 0x0D,
  0xE5, 0x03, 0x0D, 0x28, 0x18, 0xF3, 0x40, 0x80, 0x92, 0x81, 0x4F, 0x84, 0x85, 0xDE, 0xEE, 0xEF,
  0xD3, 0x02, 0x0E, 0x48, 0x1A, 0xF2, 0x20, 0x70, 0x94, 0x81, 0x5F, 0x72, 0x0D, 0x08, 0x48, 0x33,
  0xFC, 0x0E, 0xA0, 0xC2, 0x05, 0xB0, 0xE0,
  // "Á" (U+00C1)
  0x58, 0x11, 0xFA, 0x71, 0x08, 0x0C, 0x71, 0x81, 0x2C, 0x17, 0x75, 0x81, 0x4F, 0x57, 0x18, 0x19,
  0xFA, 0x71, 0x81, 0xDA, 0xE7, 0x83, 0x3B, 0x6F, 0x46, 0x83, 0x87, 0x1F, 0x96, 0x83, 0xD2, 0x0D,
  0xE5, 0x03, 0x0D, 0x28, 0x18, 0xF3, 0x40, 0x80, 0x92, 0x81, 0x4F, 0x84, 0x85, 0xDE, 0xEE, 0xEF,
  0xD3, 0x02, 0x0E, 0x48, 0x1A, 0xF2, 0x20, 0x70, 0x94, 0x81, 0x5F, 0x72, 0x0D, 0x08, 0x48, 0x33,
  0xFC, 0x0E, 0xA0, 0xC2, 0x05, 0xB0, 0xE0,
  // "Â" (U+00C2)
  0x48, 0x1E, 0xF1, 0x78, 0x27, 0xB9, 0x96, 0x84, 0x1C, 0x10, 0xB3, 0x77, 0x48, 0x14, 0xF5, 0x71,
  0x81, 0x9F, 0xA7, 0x18, 0x1D, 0xAE, 0x78, 0x33, 0xB6, 0xF4, 0x68, 0x38, 0x71, 0xF9, 0x68, 0x3D,
  0x20, 0xDE, 0x50, 0x30, 0xD2, 0x81, 0x8F, 0x34, 0x08, 0x09, 0x28, 0x14, 0xF8, 0x48, 0x5D, 0xEE,
  0xEE, 0xFD, 0x30, 0x20, 0xE4, 0x81, 0xAF, 0x22, 0x07, 0x09, 0x48, 0x15, 0xF7, 0x20, 0xD0, 0x84,
  0x83, 0x3F, 0xC0, 0xEA, 0x0C, 0x20, 0x5B, 0x0E,
  // "Ã" (U+00C3)
  0x38, 0x49, 0xE9, 0x17, 0x24, 0x84, 0x27, 0x19, 0xEA, 0x77, 0x48, 0x14, 0xF5, 0x71, 0x81, 0x9F,
  0xA7, 0x18, 0x1D, 0xAE, 0x78, 0x33, 0xB6, 0xF4, 0x68, 0x38, 0x71, 0xF9, 0x68, 0x3D, 0x20, 0xDE,
  0x50, 0x30, 0xD2, 0x81, 0x8F, 0x34, 0x08, 0x09, 0x28, 0x14, 0xF8, 0x48, 0x5D, 0xEE, 0xEE, 0xFD,
  0x30, 0x20, 0xE4, 0x81, 0xAF, 0x22, 0x07, 0x09, 0x48, 0x15, 0xF7, 0x20, 0xD0, 0x84, 0x83, 0x3F,
  0xC0, 0xEA, 0x0C, 0x20, 0x5B, 0x0E,
  // "Ä" (U+00C4)
  0x38, 0x39, 0x90, 0xB7, 0x68, 0x39, 0xA0, 0xC7, 0x77, 0x77, 0x18, 0x14, 0xF5, 0x71, 0x81, 0x9F,
  0xA7, 0x18, 0x1D, 0xAE, 0x78, 0x33, 0xB6, 0xF4, 0x68, 0x38, 0x71, 0xF9, 0x68, 0x3D, 0x20, 0xDE,
  0x50, 0x30, 0xD2, 0x81, 0x8F, 0x34, 0x08, 0x09, 0x28, 0x14, 0xF8, 0x48, 0x5D, 0xEE, 0xEE, 0xFD,
  0x30, 0x20, 0xE4, 0x81, 0xAF, 0x22, 0x07, 0x09, 0x48, 0x15, 0xF7, 0x20, 0xD0, 0x84, 0x83, 0x3F,
  0xC0, 0xEA, 0x0C, 0x20, 0x5B, 0x0E,
  // "Å" (U+00C5)
  0x48, 0x19, 0xE9, 0x78, 0x33, 0xA0, 0x94, 0x68, 0x33, 0xA1, 0xA3, 0x78, 0x1A, 0xFA, 0x71, 0x81,
  0x9F, 0xA7, 0x18, 0x1D, 0xAE, 0x78, 0x33, 0xB5, 0xF4, 0x68, 0x38, 0x71, 0xF9, 0x68, 0x3D, 0x20,
  0xCD, 0x50, 0x30, 0xD2, 0x81, 0x8F, 0x34, 0x08, 0x09, 0x28, 0x14, 0xF7, 0x48, 0x5D, 0xEE, 0xEE,
  0xFC, 0x30, 0x20, 0xE4, 0x81, 0xAF, 0x22, 0x07, 0x09, 0x48, 0x15, 0xF6, 0x20, 0xD0, 0x84, 0x83,
  0x3F, 0xC0, 0xEA, 0x0C, 0x20, 0x5B, 0x0E,
  // "Æ" (U+00C6)
  0x40, 0x20, 0xDB, 0x00, 0xEA, 0x07, 0x68, 0x24, 0xAE, 0xB3, 0x0B, 0x08, 0x68, 0x2B, 0x3E, 0xB3,
  0x05, 0x08, 0x58, 0x33, 0xC0, 0xEB, 0x30, 0x10, 0x25, 0x83, 0x96, 0x0E, 0xB7, 0x20, 0x10, 0xE2,
  0x0E, 0x0B, 0x72, 0x07, 0x09, 0x28, 0x4E, 0xFE, 0xEE, 0x65, 0x0E, 0x02, 0x20, 0xE0, 0xB7, 0x18,
  0x56, 0xFE, 0xEE, 0xFB, 0x71, 0x0C, 0x04, 0x30, 0xE0, 0xB7, 0x04, 0x0D, 0x40, 0xE0, 0xB4, 0x83,
  0xC1, 0x0B, 0x84, 0x90, 0xB3, 0x89, 0x62, 0xF0, 0xCF, 0xE8, 0x04, 0xDF, 0xEB, 0xBB, 0xE9, 0x10,
  // "Ç" (U+00C7)
  0x38, 0x46, 0xCE, 0xEA, 0x22, 0x89, 0x19, 0xE4, 0x02, 0xED, 0x04, 0xF6, 0x38, 0x47, 0xD0, 0xAF,
  0x13, 0x01, 0x20, 0xE0, 0xD6, 0x81, 0x1F, 0xB6, 0x81, 0x1F, 0xB6, 0x81, 0x1F, 0xB7, 0x0E, 0x0D,
  0x78, 0x1B, 0xF1, 0x68, 0x14, 0xF7, 0x40, 0x32, 0x81, 0xAE, 0x52, 0x05, 0x0C, 0x30, 0x70, 0xDA,
  0x0A, 0x02, 0x58, 0x1A, 0xA1, 0x70, 0xC0, 0x87, 0x0C, 0x08, 0x58, 0x28, 0xEC, 0x11,
  // "È" (U+00C8)
  0x28, 0x11, 0xEB, 0x78, 0x14, 0xF3, 0x70, 0x40, 0xB7, 0x58, 0x93, 0x5E, 0xFE, 0xBB, 0xCF, 0x70,
  0x1F, 0xB3, 0x0A, 0x07, 0x29, 0x0B, 0x30, 0x60, 0x72, 0x90, 0xB3, 0x01, 0x02, 0x29, 0x0B, 0x79,
  0x0B, 0x7A, 0x0F, 0xE0, 0x53, 0x90, 0xB7, 0x90, 0xB7, 0x90, 0xB7, 0x90, 0xB4, 0x83, 0xD0, 0x1F,
  0xB3, 0x89, 0x13, 0xF5, 0xEF, 0xEB, 0xBB, 0xEE,
  // "É" (U+00C9)
  0x48, 0x11, 0xFA, 0x60, 0x80, 0xC6, 0x81, 0x2C, 0x17, 0x58, 0x93, 0x5E, 0xFE, 0xBB, 0xCF, 0x70,
  0x1F, 0xB3, 0x0A, 0x07, 0x29, 0x0B, 0x30, 0x60, 0x72, 0x90, 0xB3, 0x01, 0x02, 0x29, 0x0B, 0x79,
  0x0B, 0x7A, 0x0F, 0xE0, 0x53, 0x90, 0xB7, 0x90, 0xB7, 0x90, 0xB7, 0x90, 0xB4, 0x83, 0xD0, 0x1F,
  0xB3, 0x89, 0x13, 0xF5, 0xEF, 0xEB, 0xBB, 0xEE,
  // "Ê" (U+00CA)
  0x48, 0x1E, 0xF1, 0x58, 0x27, 0xB9, 0x94, 0x84, 0x1C, 0x10, 0xB3, 0x73, 0x89, 0x35, 0xEF, 0xEB,
  0xBC, 0xF7, 0x01, 0xFB, 0x30, 0xA0, 0x72, 0x90, 0xB3, 0x06, 0x07, 0x29, 0x0B, 0x30, 0x10, 0x22,
  0x90, 0xB7, 0x90, 0xB7, 0xA0, 0xFE, 0x05, 0x39, 0x0B, 0x79, 0x0B, 0x79, 0x0B, 0x79, 0x0B, 0x48,
  0x3D, 0x01, 0xFB, 0x38, 0x91, 0x3F, 0x5E, 0xFE, 0xBB, 0xBE, 0xE0,
  // "Ë" (U+00CB)
  0x28, 0x39, 0x90, 0xB7, 0x48, 0x39, 0xA0, 0xC7, 0x77, 0x68, 0x93, 0x5E, 0xFE, 0xBB, 0xCF, 0x70,
  0x1F, 0xB3, 0x0A, 0x07, 0x29, 0x0B, 0x30, 0x60, 0x72, 0x90, 0xB3, 0x01, 0x02, 0x29, 0x0B, 0x79,
  0x0B, 0x7A, 0x0F, 0xE0, 0x53, 0x90, 0xB7, 0x90, 0xB7, 0x90, 0xB7, 0x90, 0xB4, 0x83, 0xD0, 0x1F,
  0xB3, 0x89, 0x13, 0xF5, 0xEF, 0xEB, 0xBB, 0xEE,
  // "Ì" (U+00CC)
  0x81, 0x1E, 0xB4, 0x81, 0x4F, 0x34, 0x04, 0x0B, 0x71, 0x06, 0xC8, 0x32, 0x03, 0xFD, 0x49, 0x0B,
  0x49, 0x0B, 0x49, 0x0B, 0x49, 0x0B, 0x49, 0x0B, 0x49, 0x0B, 0x49, 0x0B, 0x49, 0x0B, 0x49, 0x0B,
  0x38, 0x12, 0xFD, 0x20, 0x6C, 0x02,
  // "Í" (U+00CD)
  0x28, 0x11, 0xFA, 0x30, 0x80, 0xC3, 0x81, 0x2C, 0x17, 0x10, 0x6C, 0x83, 0x20, 0x3F, 0xD4, 0x90,
  0xB4, 0x90, 0xB4, 0x90, 0xB4, 0x90, 0xB4, 0x90, 0xB4, 0x90, 0xB4, 0x90, 0xB4, 0x90, 0xB4, 0x90,
  0xB3, 0x81, 0x2F, 0xD2, 0x06, 0xC0, 0x20,
  // "Î" (U+00CE)
  0x28, 0x1E, 0xF1, 0x28, 0x91, 0x7B, 0x99, 0x01, 0xC1, 0x0B, 0x36, 0x06, 0xC8, 0x32, 0x03, 0xFD,
  0x49, 0x0B, 0x49, 0x0B, 0x49, 0x0B, 0x49, 0x0B, 0x49, 0x0B, 0x49, 0x0B, 0x49, 0x0B, 0x49, 0x0B,
  0x49, 0x0B, 0x38, 0x12, 0xFD, 0x20, 0x6C, 0x02,
  // "Ï" (U+00CF)
  0x89, 0x19, 0x90, 0xB7, 0x09, 0xA0, 0xC7, 0x76, 0x06, 0xC8, 0x32, 0x03, 0xFD, 0x49, 0x0B, 0x49,
  0x0B, 0x49, 0x0B, 0x49, 0x0B, 0x49, 0x0B, 0x49, 0x0B, 0x49, 0x0B, 0x49, 0x0B, 0x49, 0x0B, 0x38,
  0x12, 0xFD, 0x20, 0x6C, 0x02,
  // "Ð" (U+00D0)
  0x06, 0xB8, 0x2E, 0xED, 0x84, 0x81, 0x3F, 0xB2, 0x81, 0x5E, 0xC4, 0x90, 0xB3, 0x81, 0x4F, 0x83,
  0x90, 0xB4, 0x0D, 0x0E, 0x39, 0x0B, 0x48, 0x19, 0xF3, 0x29, 0x0B, 0x48, 0x37, 0xF5, 0x5E, 0xA8,
  0x5E, 0xE2, 0x07, 0xF6, 0x29, 0x0B, 0x48, 0x17, 0xF5, 0x29, 0x0B, 0x48, 0x19, 0xF3, 0x29, 0x0B,
  0x40, 0xD0, 0xE3, 0x90, 0xB3, 0x81, 0x4F, 0x82, 0x81, 0x2F, 0xB2, 0x81, 0x4E, 0xC2, 0x06, 0xB8,
  0x2E, 0xED, 0x83,
  // "Ñ" (U+00D1)
  0x48, 0x49, 0xE9, 0x17, 0x25, 0x84, 0x27, 0x19, 0xEA, 0x77, 0x10, 0x6A, 0x0C, 0x30, 0x6B, 0x81,
  0x50, 0x2A, 0x05, 0x38, 0x13, 0xF2, 0x39, 0x0E, 0x0D, 0x40, 0xE4, 0x98, 0x17, 0xF6, 0x30, 0xE4,
  0x91, 0x0D, 0x0E, 0x30, 0xE4, 0x91, 0x81, 0x5F, 0x72, 0x0E, 0x49, 0x28, 0x3C, 0xE1, 0x0E, 0x49,
  0x28, 0x34, 0xF8, 0x0E, 0x49, 0x38, 0x2B, 0xF2, 0xE4, 0x93, 0x82, 0x2F, 0xAE, 0x49, 0x48, 0x19,
  0xFE, 0x38, 0x13, 0xF2, 0x38, 0x11, 0xEE, 0x20, 0x6B, 0x06, 0x30, 0x80, 0xE2,
  // "Ò" (U+00D2)
  0x38, 0x11, 0xEB, 0x72, 0x81, 0x4F, 0x37, 0x20, 0x40, 0xB7, 0x74, 0x84, 0x6C, 0xED, 0xA2, 0x48,
  0x1A, 0xE4, 0x28, 0x19, 0xE2, 0x28, 0x14, 0xF6, 0x40, 0xD0, 0xB2, 0x0B, 0x95, 0x84, 0x8F, 0x30,
  0xED, 0x58, 0x45, 0xF7, 0x1F, 0xB5, 0x84, 0x3F, 0x81, 0xFB, 0x58, 0x43, 0xF9, 0x1F, 0xB5, 0x84,
  0x3F, 0x80, 0xED, 0x58, 0x35, 0xF7, 0x0B, 0x95, 0x85, 0x8F, 0x30, 0x4F, 0x64, 0x0D, 0x0B, 0x38,
  0x19, 0xE4, 0x28, 0x19, 0xE2, 0x48, 0x46, 0xCE, 0xD9, 0x22,
  // "Ó" (U+00D3)
  0x58, 0x11, 0xFA, 0x71, 0x08, 0x0C, 0x71, 0x81, 0x2C, 0x17, 0x74, 0x84, 0x6C, 0xED, 0xA2, 0x48,
  0x1A, 0xE4, 0x28, 0x19, 0xE2, 0x28, 0x14, 0xF6, 0x40, 0xD0, 0xB2, 0x0B, 0x95, 0x84, 0x8F, 0x30,
  0xED, 0x58, 0x45, 0xF7, 0x1F, 0xB5, 0x84, 0x3F, 0x81, 0xFB, 0x58, 0x43, 0xF9, 0x1F, 0xB5, 0x84,
  0x3F, 0x80, 0xED, 0x58, 0x35, 0xF7, 0x0B, 0x95, 0x85, 0x8F, 0x30, 0x4F, 0x64, 0x0D, 0x0B, 0x38,
  0x19, 0xE4, 0x28, 0x19, 0xE2, 0x48, 0x46, 0xCE, 0xD9, 0x22,
  // "Ô" (U+00D4)
  0x58, 0x1E, 0xF1, 0x78, 0x27, 0xB9, 0x96, 0x84, 0x1C, 0x10, 0xB3, 0x77, 0x28, 0x46, 0xCE, 0xDA,
  0x24, 0x81, 0xAE, 0x42, 0x81, 0x9E, 0x22, 0x81, 0x4F, 0x64, 0x0D, 0x0B, 0x20, 0xB9, 0x58, 0x48,
  0xF3, 0x0E, 0xD5, 0x84, 0x5F, 0x71, 0xFB, 0x58, 0x43, 0xF8, 0x1F, 0xB5, 0x84, 0x3F, 0x91, 0xFB,
  0x58, 0x43, 0xF8, 0x0E, 0xD5, 0x83, 0x5F, 0x70, 0xB9, 0x58, 0x58, 0xF3, 0x04, 0xF6, 0x40, 0xD0,
  0xB3, 0x81, 0x9E, 0x42, 0x81, 0x9E, 0x24, 0x84, 0x6C, 0xED, 0x92, 0x20,
  // "Õ" (U+00D5)
  0x38, 0x49, 0xE9, 0x17, 0x24, 0x84, 0x27, 0x19, 0xEA, 0x77, 0x38, 0x46, 0xCE, 0xDA, 0x24, 0x81,
  0xAE, 0x42, 0x81, 0x9E, 0x22, 0x81, 0x4F, 0x64, 0x0D, 0x0B, 0x20, 0xB9, 0x58, 0x48, 0xF3, 0x0E,
  0xD5, 0x84, 0x5F, 0x71, 0xFB, 0x58, 0x43, 0xF8, 0x1F, 0xB5, 0x84, 0x3F, 0x91, 0xFB, 0x58, 0x43,
  0xF8, 0x0E, 0xD5, 0x83, 0x5F, 0x70, 0xB9, 0x58, 0x58, 0xF3, 0x04, 0xF6, 0x40, 0xD0, 0xB3, 0x81,
  0x9E, 0x42, 0x81, 0x9E, 0x24, 0x84, 0x6C, 0xED, 0x92, 0x20,
  // "Ö" (U+00D6)
  0x38, 0x39, 0x90, 0xB7, 0x68, 0x39, 0xA0, 0xC7, 0x77, 0x77, 0x84, 0x6C, 0xED, 0xA2, 0x48, 0x1A,
  0xE4, 0x28, 0x19, 0xE2, 0x28, 0x14, 0xF6, 0x40, 0xD0, 0xB2, 0x0B, 0x95, 0x84, 0x8F, 0x30, 0xED,
  0x58, 0x45, 0xF7, 0x1F, 0xB5, 0x84, 0x3F, 0x81, 0xFB, 0x58, 0x43, 0xF9, 0x1F, 0xB5, 0x84, 0x3F,
  0x80, 0xED, 0x58, 0x35, 0xF7, 0x0B, 0x95, 0x85, 0x8F, 0x30, 0x4F, 0x64, 0x0D, 0x0B, 0x38, 0x19,
  0xE4, 0x28, 0x19, 0xE2, 0x48, 0x46, 0xCE, 0xD9, 0x22,
  // "×" (U+00D7)
  0xC4, 0x00, 0x0C, 0x33, 0xE3, 0x0A, 0x90, 0x05, 0xD9, 0xB0, 0x00, 0x0A, 0xF1, 0x00, 0x04, 0xEA,
  0xA0, 0x02, 0xE3, 0x0B, 0x80, 0xC5, 0x00, 0x1D, 0x31, 0x00, 0x00, 0x10,
  // "Ø" (U+00D8)
  0x71, 0x07, 0x06, 0x48, 0x56, 0xCE, 0xD9, 0xD1, 0x38, 0x6A, 0xE4, 0x01, 0xAE, 0x12, 0x81, 0x4F,
  0x63, 0x81, 0xCE, 0xB2, 0x0B, 0x93, 0x86, 0x3B, 0x8F, 0x20, 0xED, 0x38, 0x6B, 0x35, 0xF6, 0x1F,
  0xB2, 0x87, 0x3B, 0x03, 0xF9, 0x1F, 0xB2, 0x89, 0x2A, 0x40, 0x3F, 0x91, 0xFC, 0x02, 0xC2, 0x87,
  0x3F, 0x90, 0xED, 0x09, 0x42, 0x86, 0x5F, 0x70, 0xBF, 0x2C, 0x38, 0x68, 0xF3, 0x04, 0xFD, 0x53,
  0x0D, 0x0C, 0x38, 0x19, 0xF4, 0x28, 0x19, 0xE2, 0x38, 0x59, 0xAC, 0xED, 0xA2, 0x40, 0x67, 0x10,
  // "Ù" (U+00D9)
  0x38, 0x11, 0xEB, 0x72, 0x81, 0x4F, 0x37, 0x20, 0x40, 0xB7, 0x71, 0x0B, 0xB0, 0xC2, 0xB8, 0x3D,
  0x07, 0xF9, 0x40, 0xB0, 0x92, 0x81, 0x4F, 0x64, 0x09, 0x06, 0x28, 0x14, 0xF6, 0x40, 0x90, 0x62,
  0x81, 0x4F, 0x64, 0x09, 0x06, 0x28, 0x14, 0xF6, 0x40, 0x90, 0x62, 0x81, 0x4F, 0x64, 0x09, 0x06,
  0x28, 0x14, 0xF6, 0x40, 0x90, 0x62, 0x81, 0x4F, 0x64, 0x09, 0x06, 0x28, 0x14, 0xF6, 0x40, 0x90,
  0x52, 0x81, 0x2F, 0x94, 0x0C, 0x02, 0x38, 0x1B, 0xF5, 0x20, 0x80, 0xB5, 0x84, 0x7D, 0xEE, 0x91,
  0x20,
  // "Ú" (U+00DA)
  0x58, 0x11, 0xFA, 0x71, 0x08, 0x0C, 0x71, 0x81, 0x2C, 0x17, 0x71, 0x0B, 0xB0, 0xC2, 0xB8, 0x3D,
  0x07, 0xF9, 0x40, 0xB0, 0x92, 0x81, 0x4F, 0x64, 0x09, 0x06, 0x28, 0x14, 0xF6, 0x40, 0x90, 0x62,
  0x81, 0x4F, 0x64, 0x09, 0x06, 0x28, 0x14, 0xF6, 0x40, 0x90, 0x62, 0x81, 0x4F, 0x64, 0x09, 0x06,
  0x28, 0x14, 0xF6, 0x40, 0x90, 0x62, 0x81, 0x4F, 0x64, 0x09, 0x06, 0x28, 0x14, 0xF6, 0x40, 0x90,
  0x52, 0x81, 0x2F, 0x94, 0x0C, 0x02, 0x38, 0x1B, 0xF5, 0x20, 0x80, 0xB5, 0x84, 0x7D, 0xEE, 0x91,
  0x20,
  // "Û" (U+00DB)
  0x58, 0x1E, 0xF1, 0x78, 0x27, 0xB9, 0x96, 0x84, 0x1C, 0x10, 0xB3, 0x76, 0x0B, 0xB0, 0xC2, 0xB8,
  0x3D, 0x07, 0xF9, 0x40, 0xB0, 0x92, 0x81, 0x4F, 0x64, 0x09, 0x06, 0x28, 0x14, 0xF6, 0x40, 0x90,
  0x62, 0x81, 0x4F, 0x64, 0x09, 0x06, 0x28, 0x14, 0xF6, 0x40, 0x90, 0x62, 0x81, 0x4F, 0x64, 0x09,
  0x06, 0x28, 0x14, 0xF6, 0x40, 0x90, 0x62, 0x81, 0x4F, 0x64, 0x09, 0x06, 0x28, 0x14, 0xF6, 0x40,
  0x90, 0x52, 0x81, 0x2F, 0x94, 0x0C, 0x02, 0x38, 0x1B, 0xF5, 0x20, 0x80, 0xB5, 0x84, 0x7D, 0xEE,
  0x91, 0x20,
  // "Ü" (U+00DC)
  0x38, 0x39, 0x90, 0xB7, 0x68, 0x39, 0xA0, 0xC7, 0x77, 0x74, 0x0B, 0xB0, 0xC2, 0xB8, 0x3D, 0x07,
  0xF9, 0x40, 0xB0, 0x92, 0x81, 0x4F, 0x64, 0x09, 0x06, 0x28, 0x14, 0xF6, 0x40, 0x90, 0x62, 0x81,
  0x4F, 0x64, 0x09, 0x06, 0x28, 0x14, 0xF6, 0x40, 0x90, 0x62, 0x81, 0x4F, 0x64, 0x09, 0x06, 0x28,
  0x14, 0xF6, 0x40, 0x90, 0x62, 0x81, 0x4F, 0x64, 0x09, 0x06, 0x28, 0x14, 0xF6, 0x40, 0x90, 0x52,
  0x81, 0x2F, 0x94, 0x0C, 0x02, 0x38, 0x1B, 0xF5, 0x20, 0x80, 0xB5, 0x84, 0x7D, 0xEE, 0x91, 0x20,
  // "Ý" (U+00DD)
  0x68, 0x11, 0xFA, 0x71, 0x08, 0x0C, 0x71, 0x81, 0x2C, 0x17, 0x70, 0x1C, 0x81, 0x30, 0xDA, 0x84,
  0xC0, 0x1E, 0xF2, 0x30, 0xA0, 0xC3, 0x81, 0x7F, 0x63, 0x0B, 0x04, 0x40, 0xE0, 0xD2, 0x03, 0x0C,
  0x58, 0x46, 0xF5, 0x0B, 0x46, 0x82, 0xDC, 0x3B, 0x78, 0x26, 0xFC, 0x47, 0x10, 0xE0, 0xD7, 0x20,
  0xE0, 0xC7, 0x20, 0xE0, 0xC7, 0x20, 0xE0, 0xC7, 0x18, 0x22, 0xFE, 0x16, 0x07, 0xC0, 0x52,
  // "Þ" (U+00DE)
  0x06, 0xC0, 0x44, 0x81, 0x3F, 0xD7, 0x90, 0xB7, 0xA8, 0x2E, 0xEC, 0x53, 0x90, 0xB2, 0x81, 0xAF,
  0x42, 0x90, 0xB2, 0x81, 0x2F, 0xA2, 0x90, 0xB3, 0x90, 0xB2, 0x90, 0xB2, 0x81, 0x2F, 0x92, 0x98,
  0x4B, 0x01, 0xBE, 0x22, 0xA8, 0x2E, 0xDA, 0x23, 0x90, 0xB6, 0x82, 0x2F, 0xD1, 0x40, 0x6C, 0x04,
  0x30,
  // "ß" (U+00DF)
  0x00, 0x1A, 0xEE, 0xB3, 0x00, 0x00, 0xCD, 0x20, 0x9E, 0x00, 0x02, 0xF7, 0x00, 0x1F, 0x50, 0x03,
  0xF5, 0x00, 0x0E, 0x80, 0x7E, 0xF5, 0x07, 0xEE, 0x90, 0x03, 0xF5, 0x3F, 0x50, 0x00, 0x03, 0xF5,
  0x6F, 0x00, 0x00, 0x03, 0xF5, 0x3F, 0x70, 0x00, 0x03, 0xF5, 0x08, 0xFA, 0x10, 0x03, 0xF5, 0x00,
  0x4E, 0xC0, 0x03, 0xF5, 0x00, 0x03, 0xF4, 0x03, 0xF5, 0x95, 0x00, 0xF6, 0x06, 0xF5, 0x8B, 0x05,
  0xF2, 0xAF, 0xF5, 0x1B, 0xED, 0x60,
  // "à" (U+00E0)
  0x18, 0x11, 0xEB, 0x78, 0x14, 0xF3, 0x70, 0x40, 0xB7, 0x78, 0x41, 0xAE, 0xEB, 0x33, 0x84, 0x8F,
  0x20, 0xCD, 0x30, 0x30, 0x82, 0x81, 0x8F, 0x16, 0x81, 0x7F, 0x12, 0x82, 0x2A, 0xDE, 0xA0, 0x12,
  0x89, 0x1D, 0xD3, 0x07, 0xF1, 0x02, 0xF7, 0x28, 0x57, 0xF1, 0x02, 0xF6, 0x28, 0x1A, 0xF1, 0x28,
  0x5E, 0xB0, 0x4A, 0xF4, 0x28, 0x34, 0xDD, 0x72, 0xA0, 0x10,
  // "á" (U+00E1)
  0x48, 0x11, 0xFA, 0x60, 0x80, 0xC6, 0x81, 0x2C, 0x17, 0x68, 0x41, 0xAE, 0xEB, 0x33, 0x84, 0x8F,
  0x20, 0xCD, 0x30, 0x30, 0x82, 0x81, 0x8F, 0x16, 0x81, 0x7F, 0x12, 0x82, 0x2A, 0xDE, 0xA0, 0x12,
  0x89, 0x1D, 0xD3, 0x07, 0xF1, 0x02, 0xF7, 0x28, 0x57, 0xF1, 0x02, 0xF6, 0x28, 0x1A, 0xF1, 0x28,
  0x5E, 0xB0, 0x4A, 0xF4, 0x28, 0x34, 0xDD, 0x72, 0xA0, 0x10,
  // "â" (U+00E2)
  0x38, 0x1E, 0xF1, 0x58, 0x27, 0xB9, 0x94, 0x84, 0x1C, 0x10, 0xB3, 0x75, 0x84, 0x1A, 0xEE, 0xB3,
  0x38, 0x48, 0xF2, 0x0C, 0xD3, 0x03, 0x08, 0x28, 0x18, 0xF1, 0x68, 0x17, 0xF1, 0x28, 0x22, 0xAD,
  0xEA, 0x01, 0x28, 0x91, 0xDD, 0x30, 0x7F, 0x10, 0x2F, 0x72, 0x85, 0x7F, 0x10, 0x2F, 0x62, 0x81,
  0xAF, 0x12, 0x85, 0xEB, 0x04, 0xAF, 0x42, 0x83, 0x4D, 0xD7, 0x2A, 0x01,
  // "ã" (U+00E3)
  0x28, 0x49, 0xE9, 0x17, 0x22, 0x84, 0x27, 0x19, 0xEA, 0x75, 0x84, 0x1A, 0xEE, 0xB3, 0x38, 0x48,
  0xF2, 0x0C, 0xD3, 0x03, 0x08, 0x28, 0x18, 0xF1, 0x68, 0x17, 0xF1, 0x28, 0x22, 0xAD, 0xEA, 0x01,
  0x28, 0x91, 0xDD, 0x30, 0x7F, 0x10, 0x2F, 0x72, 0x85, 0x7F, 0x10, 0x2F, 0x62, 0x81, 0xAF, 0x12,
  0x85, 0xEB, 0x04, 0xAF, 0x42, 0x83, 0x4D, 0xD7, 0x2A, 0x01,
  // "ä" (U+00E4)
  0x28, 0x39, 0x90, 0xB7, 0x48, 0x39, 0xA0, 0xC7, 0x77, 0x78, 0x41, 0xAE, 0xEB, 0x33, 0x84, 0x8F,
  0x20, 0xCD, 0x30, 0x30, 0x82, 0x81, 0x8F, 0x16, 0x81, 0x7F, 0x12, 0x82, 0x2A, 0xDE, 0xA0, 0x12,
  0x89, 0x1D, 0xD3, 0x07, 0xF1, 0x02, 0xF7, 0x28, 0x57, 0xF1, 0x02, 0xF6, 0x28, 0x1A, 0xF1, 0x28,
  0x5E, 0xB0, 0x4A, 0xF4, 0x28, 0x34, 0xDD, 0x72, 0xA0, 0x10,
  // "å" (U+00E5)
  0x38, 0x19, 0xEA, 0x58, 0x33, 0xA0, 0x94, 0x48, 0x33, 0xA0, 0x94, 0x58, 0x19, 0xEA, 0x76, 0x84,
  0x1A, 0xEE, 0xB3, 0x38, 0x48, 0xF2, 0x0C, 0xD3, 0x03, 0x08, 0x28, 0x18, 0xF1, 0x68, 0x17, 0xF1,
  0x28, 0x22, 0xAD, 0xEA, 0x01, 0x28, 0x91, 0xDD, 0x30, 0x7F, 0x10, 0x2F, 0x72, 0x85, 0x7F, 0x10,
  0x2F, 0x62, 0x81, 0xAF, 0x12, 0x85, 0xEB, 0x04, 0xAF, 0x42, 0x83, 0x4D, 0xD7, 0x2A, 0x01,
  // "æ" (U+00E6)
  0x01, 0xAE, 0xEA, 0x18, 0xEE, 0x90, 0x00, 0x8F, 0x20, 0xCE, 0xC1, 0x1E, 0x80, 0x03, 0x80, 0x08,
  0xF5, 0x00, 0x8F, 0x00, 0x00, 0x00, 0x7F, 0x30, 0x06, 0xF2, 0x02, 0xAD, 0xEF, 0xFE, 0xEE, 0xEF,
  0x30, 0xDD, 0x30, 0x7F, 0x20, 0x00, 0x00, 0x2F, 0x70, 0x07, 0xF3, 0x00, 0x00, 0x02, 0xF6, 0x00,
  0xAF, 0x70, 0x00, 0x20, 0x0E, 0xB0, 0x4A, 0x8E, 0x30, 0x3C, 0x00, 0x4D, 0xE9, 0x00, 0x8E, 0xEB,
  0x20,
  // "ç" (U+00E7)
  0x28, 0x95, 0x7D, 0xEC, 0x40, 0x6F, 0x40, 0xBE, 0x0D, 0xB2, 0x83, 0x7C, 0x0F, 0x84, 0x81, 0x2F,
  0x74, 0x81, 0x2F, 0x75, 0x90, 0x85, 0x00, 0xC3, 0x86, 0x10, 0x5F, 0x60, 0x2C, 0x28, 0x36, 0xDF,
  0xD5, 0x38, 0x12, 0xD5, 0x50, 0x59, 0x50, 0x39, 0x38, 0x21, 0xDD, 0x61,
  // "è" (U+00E8)
  0x18, 0x11, 0xEB, 0x68, 0x14, 0xF3, 0x60, 0x40, 0xB7, 0x68, 0x36, 0xDE, 0xB2, 0x28, 0x45, 0xF4,
  0x0A, 0xD2, 0x0C, 0x0B, 0x28, 0x43, 0xF5, 0x0F, 0x82, 0x82, 0x1F, 0x72, 0xA0, 0xFE, 0x98, 0x28,
  0x2F, 0x76, 0x90, 0x96, 0x00, 0xC3, 0x01, 0x28, 0x55, 0xF7, 0x01, 0xC2, 0x28, 0x36, 0xDE, 0xD5,
  0x10,
  // "é" (U+00E9)
  0x48, 0x11, 0xFA, 0x50, 0x80, 0xC5, 0x81, 0x2C, 0x17, 0x58, 0x36, 0xDE, 0xB2, 0x28, 0x45, 0xF4,
  0x0A, 0xD2, 0x0C, 0x0B, 0x28, 0x43, 0xF5, 0x0F, 0x82, 0x82, 0x1F, 0x72, 0xA0, 0xFE, 0x98, 0x28,
  0x2F, 0x76, 0x90, 0x96, 0x00, 0xC3, 0x01, 0x28, 0x55, 0xF7, 0x01, 0xC2, 0x28, 0x36, 0xDE, 0xD5,
  0x10,
  // "ê" (U+00EA)
  0x38, 0x1E, 0xF1, 0x48, 0x27, 0xB9, 0x93, 0x84, 0x1C, 0x10, 0xB3, 0x74, 0x83, 0x6D, 0xEB, 0x22,
  0x84, 0x5F, 0x40, 0xAD, 0x20, 0xC0, 0xB2, 0x84, 0x3F, 0x50, 0xF8, 0x28, 0x21, 0xF7, 0x2A, 0x0F,
  0xE9, 0x82, 0x82, 0xF7, 0x69, 0x09, 0x60, 0x0C, 0x30, 0x12, 0x85, 0x5F, 0x70, 0x1C, 0x22, 0x83,
  0x6D, 0xED, 0x51,
  // "ë" (U+00EB)
  0x28, 0x39, 0x90, 0xB7, 0x38, 0x39, 0xA0, 0xC7, 0x77, 0x58, 0x36, 0xDE, 0xB2, 0x28, 0x45, 0xF4,
  0x0A, 0xD2, 0x0C, 0x0B, 0x28, 0x43, 0xF5, 0x0F, 0x82, 0x82, 0x1F, 0x72, 0xA0, 0xFE, 0x98, 0x28,
  0x2F, 0x76, 0x90, 0x96, 0x00, 0xC3, 0x01, 0x28, 0x55, 0xF7, 0x01, 0xC2, 0x28, 0x36, 0xDE, 0xD5,
  0x10,
  // "ì" (U+00EC)
  0x1E, 0xB0, 0x00, 0x4F, 0x30, 0x00, 0x4B, 0x00, 0x00, 0x00, 0x8F, 0xF5, 0x00, 0x6F, 0x50, 0x03,
  0xF5, 0x00, 0x3F, 0x50, 0x03, 0xF5, 0x00, 0x3F, 0x50, 0x03, 0xF5, 0x00, 0x3F, 0x50, 0x06, 0xF8,
  0x09, 0xFF, 0xFB,
  // "í" (U+00ED)
  0x00, 0x1F, 0xA0, 0x08, 0xC0, 0x02, 0xC1, 0x00, 0x00, 0x00, 0x8F, 0xF5, 0x00, 0x6F, 0x50, 0x03,
  0xF5, 0x00, 0x3F, 0x50, 0x03, 0xF5, 0x00, 0x3F, 0x50, 0x03, 0xF5, 0x00, 0x3F, 0x50, 0x06, 0xF8,
  0x09, 0xFF, 0xFB,
  // "î" (U+00EE)
  0x28, 0x1E, 0xF1, 0x28, 0x91, 0x7B, 0x99, 0x01, 0xC1, 0x0B, 0x37, 0x08, 0xA0, 0x53, 0x81, 0x6F,
  0x53, 0x81, 0x3F, 0x53, 0x81, 0x3F, 0x53, 0x81, 0x3F, 0x53, 0x81, 0x3F, 0x53, 0x81, 0x3F, 0x53,
  0x81, 0x3F, 0x53, 0x81, 0x6F, 0x82, 0x09, 0xB0, 0xB0,
  // "ï" (U+00EF)
  0x99, 0x0B, 0x79, 0xA0, 0xC7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8F, 0xF5, 0x00, 0x6F, 0x50, 0x03,
  0xF5, 0x00, 0x3F, 0x50, 0x03, 0xF5, 0x00, 0x3F, 0x50, 0x03, 0xF5, 0x00, 0x3F, 0x50, 0x06, 0xF8,
  0x09, 0xFF, 0xFB,
  // "ð" (U+00F0)
  0x20, 0x50, 0x22, 0x04, 0x48, 0x35, 0xD8, 0x9A, 0x58, 0x16, 0xFE, 0x58, 0x33, 0xB2, 0xDA, 0x78,
  0x14, 0xF3, 0x38, 0x47, 0xDE, 0xAE, 0x92, 0x85, 0x7F, 0x40, 0x5F, 0xD2, 0x0E, 0x0B, 0x38, 0x4B,
  0xF0, 0x1F, 0x83, 0x84, 0x8F, 0x12, 0xF7, 0x38, 0x48, 0xF1, 0x0F, 0x83, 0x09, 0x92, 0x0D, 0x0B,
  0x30, 0xB0, 0xC2, 0x85, 0x6F, 0x40, 0x5F, 0x43, 0x83, 0x7D, 0xED, 0x52,
  // "ñ" (U+00F1)
  0x00, 0x9E, 0x91, 0x72, 0x00, 0x02, 0x71, 0x9E, 0xA0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F,
  0xF3, 0xAE, 0xD4, 0x00, 0x06, 0xFC, 0x20, 0xBE, 0x00, 0x03, 0xF8, 0x00, 0x5F, 0x30, 0x03, 0xF6,
  0x00, 0x4F, 0x40, 0x03, 0xF5, 0x00, 0x4F, 0x50, 0x03, 0xF5, 0x00, 0x4F, 0x50, 0x03, 0xF5, 0x00,
  0x4F, 0x50, 0x03, 0xF5, 0x00, 0x4F, 0x50, 0x06, 0xF8, 0x00, 0x4F, 0x70, 0x9F, 0xFF, 0x90, 0x4F,
  0xF8,
  // "ò" (U+00F2)
  0x18, 0x11, 0xEB, 0x78, 0x14, 0xF3, 0x70, 0x40, 0xB7, 0x71, 0x83, 0x6D, 0xED, 0x53, 0x85, 0x6F,
  0x40, 0x4F, 0x42, 0x0D, 0x0B, 0x38, 0x4C, 0xC0, 0x1F, 0x83, 0x84, 0x9F, 0x02, 0xF7, 0x38, 0x48,
  0xF1, 0x2F, 0x73, 0x84, 0x8F, 0x10, 0xF8, 0x30, 0x99, 0x20, 0x0C, 0x30, 0x0C, 0x28, 0x55, 0xF4,
  0x04, 0xF5, 0x38, 0x36, 0xDE, 0xD6, 0x20,
  // "ó" (U+00F3)
  0x48, 0x11, 0xFA, 0x60, 0x80, 0xC6, 0x81, 0x2C, 0x17, 0x78, 0x36, 0xDE, 0xD5, 0x38, 0x56, 0xF4,
  0x04, 0xF4, 0x20, 0xD0, 0xB3, 0x84, 0xCC, 0x01, 0xF8, 0x38, 0x49, 0xF0, 0x2F, 0x73, 0x84, 0x8F,
  0x12, 0xF7, 0x38, 0x48, 0xF1, 0x0F, 0x83, 0x09, 0x92, 0x00, 0xC3, 0x00, 0xC2, 0x85, 0x5F, 0x40,
  0x4F, 0x53, 0x83, 0x6D, 0xED, 0x62,
  // "ô" (U+00F4)
  0x38, 0x1E, 0xF1, 0x58, 0x27, 0xB9, 0x94, 0x84, 0x1C, 0x10, 0xB3, 0x76, 0x83, 0x6D, 0xED, 0x53,
  0x85, 0x6F, 0x40, 0x4F, 0x42, 0x0D, 0x0B, 0x38, 0x4C, 0xC0, 0x1F, 0x83, 0x84, 0x9F, 0x02, 0xF7,
  0x38, 0x48, 0xF1, 0x2F, 0x73, 0x84, 0x8F, 0x10, 0xF8, 0x30, 0x99, 0x20, 0x0C, 0x30, 0x0C, 0x28,
  0x55, 0xF4, 0x04, 0xF5, 0x38, 0x36, 0xDE, 0xD6, 0x20,
  // "õ" (U+00F5)
  0x28, 0x49, 0xE9, 0x17, 0x22, 0x84, 0x27, 0x19, 0xEA, 0x76, 0x83, 0x6D, 0xED, 0x53, 0x85, 0x6F,
  0x40, 0x4F, 0x42, 0x0D, 0x0B, 0x38, 0x4C, 0xC0, 0x1F, 0x83, 0x84, 0x9F, 0x02, 0xF7, 0x38, 0x48,
  0xF1, 0x2F, 0x73, 0x84, 0x8F, 0x10, 0xF8, 0x30, 0x99, 0x20, 0x0C, 0x30, 0x0C, 0x28, 0x55, 0xF4,
  0x04, 0xF5, 0x38, 0x36, 0xDE, 0xD6, 0x20,
  // "ö" (U+00F6)
  0x28, 0x39, 0x90, 0xB7, 0x48, 0x39, 0xA0, 0xC7, 0x77, 0x71, 0x83, 0x6D, 0xED, 0x53, 0x85, 0x6F,
  0x40, 0x4F, 0x42, 0x0D, 0x0B, 0x38, 0x4C, 0xC0, 0x1F, 0x83, 0x84, 0x9F, 0x02, 0xF7, 0x38, 0x48,
  0xF1, 0x2F, 0x73, 0x84, 0x8F, 0x10, 0xF8, 0x30, 0x99, 0x20, 0x0C, 0x30, 0x0C, 0x28, 0x55, 0xF4,
  0x04, 0xF5, 0x38, 0x36, 0xDE, 0xD6, 0x20,
  // "÷" (U+00F7)
  0x30, 0x70, 0xC6, 0x07, 0x0C, 0x77, 0x50, 0x18, 0x02, 0xE0, 0x77, 0x75, 0x07, 0x0C, 0x60, 0x70,
  0xC3,
  // "ø" (U+00F8)
  0x00, 0x00, 0x00, 0x16, 0x00, 0x06, 0xDE, 0xCB, 0x60, 0x06, 0xF4, 0x06, 0xF4, 0x00, 0xDB, 0x00,
  0x9E, 0xB0, 0x1F, 0x80, 0x2B, 0x9F, 0x02, 0xF7, 0x09, 0x38, 0xF1, 0x2F, 0x72, 0xA0, 0x8F, 0x10,
  0xF8, 0x93, 0x09, 0xF0, 0x0C, 0xDA, 0x00, 0xCC, 0x00, 0x4F, 0x60, 0x4F, 0x50, 0x05, 0xBC, 0xED,
  0x60, 0x00, 0x51, 0x00, 0x00, 0x00,
  // "ù" (U+00F9)
  0x28, 0x11, 0xEB, 0x71, 0x81, 0x4F, 0x37, 0x10, 0x40, 0xB7, 0x70, 0xAA, 0x81, 0x30, 0xAA, 0x02,
  0x28, 0x19, 0xF3, 0x28, 0x19, 0xF2, 0x28, 0x16, 0xF3, 0x28, 0x16, 0xF2, 0x28, 0x16, 0xF3, 0x28,
  0x16, 0xF2, 0x28, 0x16, 0xF3, 0x28, 0x16, 0xF2, 0x28, 0x16, 0xF3, 0x28, 0x16, 0xF2, 0x28, 0x15,
  0xF3, 0x28, 0x16, 0xF2, 0x28, 0x14, 0xF4, 0x28, 0x19, 0xF2, 0x28, 0x61, 0xFA, 0x03, 0xCF, 0x63,
  0x83, 0x5D, 0xEA, 0x3A, 0x07,
  // "ú" (U+00FA)
  0x48, 0x11, 0xFA, 0x70, 0x80, 0xC7, 0x81, 0x2C, 0x17, 0x70, 0xAA, 0x81, 0x30, 0xAA, 0x02, 0x28,
  0x19, 0xF3, 0x28, 0x19, 0xF2, 0x28, 0x16, 0xF3, 0x28, 0x16, 0xF2, 0x28, 0x16, 0xF3, 0x28, 0x16,
  0xF2, 0x28, 0x16, 0xF3, 0x28, 0x16, 0xF2, 0x28, 0x16, 0xF3, 0x28, 0x16, 0xF2, 0x28, 0x15, 0xF3,
  0x28, 0x16, 0xF2, 0x28, 0x14, 0xF4, 0x28, 0x19, 0xF2, 0x28, 0x61, 0xFA, 0x03, 0xCF, 0x63, 0x83,
  0x5D, 0xEA, 0x3A, 0x07,
  // "û" (U+00FB)
  0x00, 0x00, 0xEF, 0x10, 0x00, 0x00, 0x07, 0xB9, 0x90, 0x00, 0x00, 0x1C, 0x10, 0xB3, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xAF, 0xF3, 0x0A, 0xFF, 0x20, 0x09, 0xF3, 0x00, 0x9F, 0x20, 0x06, 0xF3,
  0x00, 0x6F, 0x20, 0x06, 0xF3, 0x00, 0x6F, 0x20, 0x06, 0xF3, 0x00, 0x6F, 0x20, 0x06, 0xF3, 0x00,
  0x6F, 0x20, 0x05, 0xF3, 0x00, 0x6F, 0x20, 0x04, 0xF4, 0x00, 0x9F, 0x20, 0x01, 0xFA, 0x03, 0xCF,
  0x60, 0x00, 0x5D, 0xEA, 0x3F, 0xF7,
  // "ü" (U+00FC)
  0x28, 0x39, 0x90, 0xB7, 0x58, 0x39, 0xA0, 0xC7, 0x77, 0x72, 0x0A, 0xA8, 0x13, 0x0A, 0xA0, 0x22,
  0x81, 0x9F, 0x32, 0x81, 0x9F, 0x22, 0x81, 0x6F, 0x32, 0x81, 0x6F, 0x22, 0x81, 0x6F, 0x32, 0x81,
  0x6F, 0x22, 0x81, 0x6F, 0x32, 0x81, 0x6F, 0x22, 0x81, 0x6F, 0x32, 0x81, 0x6F, 0x22, 0x81, 0x5F,
  0x32, 0x81, 0x6F, 0x22, 0x81, 0x4F, 0x42, 0x81, 0x9F, 0x22, 0x86, 0x1F, 0xA0, 0x3C, 0xF6, 0x38,
  0x35, 0xDE, 0xA3, 0xA0, 0x70,
  // "ý" (U+00FD)
  0x48, 0x11, 0xFA, 0x60, 0x80, 0xC6, 0x81, 0x2C, 0x17, 0x50, 0xEA, 0x81, 0xD0, 0x6A, 0x82, 0xB1,
  0xEE, 0x30, 0x80, 0xC2, 0x81, 0x9F, 0x12, 0x09, 0x06, 0x28, 0x13, 0xF6, 0x20, 0xD0, 0x13, 0x83,
  0xDB, 0x02, 0xC4, 0x83, 0x8F, 0x16, 0x74, 0x83, 0x2F, 0x5B, 0x25, 0x81, 0xCA, 0xC6, 0x81, 0x6F,
  0x86, 0x81, 0x1F, 0x36, 0x04, 0x0D, 0x70, 0xB0, 0x85, 0x82, 0x19, 0xE1, 0x48, 0x26, 0xEC, 0x35,
  // "þ" (U+00FE)
  0x0A, 0xA0, 0x36, 0x81, 0x8F, 0x36, 0x81, 0x5F, 0x36, 0x81, 0x5F, 0x36, 0x85, 0x5F, 0x4A, 0xEC,
  0x32, 0x89, 0x25, 0xFA, 0x20, 0xAE, 0x10, 0x5F, 0x82, 0x85, 0x3F, 0x60, 0x5F, 0x53, 0x98, 0x39,
  0x05, 0xF4, 0x38, 0x4E, 0xA0, 0x5F, 0x43, 0x98, 0x3A, 0x05, 0xF5, 0x39, 0x83, 0x90, 0x5F, 0x82,
  0x8A, 0x23, 0xF6, 0x05, 0xFC, 0x20, 0xAE, 0x10, 0x5F, 0x4B, 0xEC, 0x32, 0x81, 0x5F, 0x36, 0x81,
  0x5F, 0x36, 0x81, 0x8F, 0x65, 0x0B, 0xB0, 0x94,
  // "ÿ" (U+00FF)
  0x28, 0x39, 0x90, 0xB7, 0x48, 0x39, 0xA0, 0xC7, 0x77, 0x60, 0xEA, 0x81, 0xD0, 0x6A, 0x82, 0xB1,
  0xEE, 0x30, 0x80, 0xC2, 0x81, 0x9F, 0x12, 0x09, 0x06, 0x28, 0x13, 0xF6, 0x20, 0xD0, 0x13, 0x83,
  0xDB, 0x02, 0xC4, 0x83, 0x8F, 0x16, 0x74, 0x83, 0x2F, 0x5B, 0x25, 0x81, 0xCA, 0xC6, 0x81, 0x6F,
  0x86, 0x81, 0x1F, 0x36, 0x04, 0x0D, 0x70, 0xB0, 0x85, 0x82, 0x19, 0xE1, 0x48, 0x26, 0xEC, 0x35,
  // "Ā" (U+0100)
  0x38, 0x44, 0xEE, 0xEE, 0x27, 0x73, 0x81, 0x4F, 0x57, 0x18, 0x19, 0xFA, 0x71, 0x81, 0xDA, 0xE7,
  0x83, 0x3B, 0x6F, 0x46, 0x83, 0x87, 0x1F, 0x96, 0x83, 0xD2, 0x0D, 0xE5, 0x03, 0x0D, 0x28, 0x18,
  0xF3, 0x40, 0x80, 0x92, 0x81, 0x4F, 0x84, 0x85, 0xDE, 0xEE, 0xEF, 0xD3, 0x02, 0x0E, 0x48, 0x1A,
  0xF2, 0x20, 0x70, 0x94, 0x81, 0x5F, 0x72, 0x0D, 0x08, 0x48, 0x33, 0xFC, 0x0E, 0xA0, 0xC2, 0x05,
  0xB0, 0xE0,
  // "ā" (U+0101)
  0x04, 0xEE, 0xEE, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xAE, 0xEB, 0x30, 0x00, 0x8F, 0x20,
  0xCD, 0x00, 0x03, 0x80, 0x08, 0xF1, 0x00, 0x00, 0x00, 0x7F, 0x10, 0x02, 0xAD, 0xEF, 0xF1, 0x00,
  0xDD, 0x30, 0x7F, 0x10, 0x2F, 0x70, 0x07, 0xF1, 0x02, 0xF6, 0x00, 0xAF, 0x10, 0x0E, 0xB0, 0x4A,
  0xF4, 0x00, 0x4D, 0xD7, 0x2F, 0xF1,
  // "Ă" (U+0102)
  0x30, 0x10, 0x42, 0x05, 0x68, 0x31, 0xC1, 0x2D, 0x78, 0x26, 0xDD, 0x47, 0x74, 0x81, 0x4F, 0x57,
  0x18, 0x19, 0xFA, 0x71, 0x81, 0xDA, 0xE7, 0x83, 0x3B, 0x6F, 0x46, 0x83, 0x87, 0x1F, 0x96, 0x83,
  0xD2, 0x0D, 0xE5, 0x03, 0x0D, 0x28, 0x18, 0xF3, 0x40, 0x80, 0x92, 0x81, 0x4F, 0x84, 0x85, 0xDE,
  0xEE, 0xEF, 0xD3, 0x02, 0x0E, 0x48, 0x1A, 0xF2, 0x20, 0x70, 0x94, 0x81, 0x5F, 0x72, 0x0D, 0x08,
  0x48, 0x33, 0xFC, 0x0E, 0xA0, 0xC2, 0x05, 0xB0, 0xE0,
  // "ă" (U+0103)
  0x10, 0x10, 0x42, 0x05, 0x48, 0x31, 0xC1, 0x2D, 0x58, 0x26, 0xDD, 0x47, 0x68, 0x41, 0xAE, 0xEB,
  0x33, 0x84, 0x8F, 0x20, 0xCD, 0x30, 0x30, 0x82, 0x81, 0x8F, 0x16, 0x81, 0x7F, 0x12, 0x82, 0x2A,
  0xDE, 0xA0, 0x12, 0x89, 0x1D, 0xD3, 0x07, 0xF1, 0x02, 0xF7, 0x28, 0x57, 0xF1, 0x02, 0xF6, 0x28,
  0x1A, 0xF1, 0x28, 0x5E, 0xB0, 0x4A, 0xF4, 0x28, 0x34, 0xDD, 0x72, 0xA0, 0x10,
  // "Ą" (U+0104)
  0x48, 0x14, 0xF5, 0x71, 0x81, 0x9F, 0xA7, 0x18, 0x1D, 0xAE, 0x78, 0x33, 0xB6, 0xF4, 0x68, 0x38,
  0x71, 0xF9, 0x68, 0x3D, 0x20, 0xDE, 0x50, 0x30, 0xD2, 0x81, 0x8F, 0x34, 0x08, 0x09, 0x28, 0x14,
  0xF8, 0x48, 0x5D, 0xEE, 0xEE, 0xFD, 0x30, 0x20, 0xE4, 0x81, 0xAF, 0x22, 0x07, 0x09, 0x48, 0x15,
  0xF7, 0x20, 0xD0, 0x84, 0x83, 0x3F, 0xC0, 0xEA, 0x0C, 0x20, 0x5C, 0x71, 0x0C, 0x04, 0x71, 0x04,
  0x0E, 0x72, 0x82, 0x4F, 0x11, 0x71, 0x81, 0x9E, 0xB0,
  // "ą" (U+0105)
  0x18, 0x41, 0xAE, 0xEB, 0x33, 0x84, 0x8F, 0x20, 0xCD, 0x30, 0x30, 0x82, 0x81, 0x8F, 0x16, 0x81,
  0x7F, 0x12, 0x82, 0x2A, 0xDE, 0xA0, 0x12, 0x89, 0x1D, 0xD3, 0x07, 0xF1, 0x02, 0xF7, 0x28, 0x57,
  0xF1, 0x02, 0xF6, 0x28, 0x1A, 0xF1, 0x28, 0x5E, 0xB0, 0x4A, 0xF4, 0x28, 0x34, 0xDD, 0x73, 0xA0,
  0x15, 0x0C, 0x04, 0x60, 0x40, 0xE7, 0x82, 0x4F, 0x11, 0x68, 0x19, 0xEB, 0x10,
  // "Ć" (U+0106)
  0x58, 0x11, 0xFA, 0x60, 0x80, 0xC6, 0x81, 0x2C, 0x17, 0x78, 0x46, 0xCE, 0xEA, 0x22, 0x89, 0x19,
  0xE4, 0x02, 0xED, 0x04, 0xF6, 0x38, 0x47, 0xD0, 0xAF, 0x13, 0x01, 0x20, 0xE0, 0xD6, 0x81, 0x1F,
  0xB6, 0x81, 0x1F, 0xB6, 0x81, 0x1F, 0xB7, 0x0E, 0x0D, 0x78, 0x1B, 0xF1, 0x68, 0x14, 0xF7, 0x40,
  0x32, 0x81, 0xAE, 0x52, 0x05, 0x0C, 0x38, 0x47, 0xDE, 0xEA, 0x20,
  // "ć" (U+0107)
  0x48, 0x11, 0xFA, 0x40, 0x80, 0xC4, 0x81, 0x2C, 0x17, 0x38, 0x95, 0x7D, 0xEC, 0x40, 0x6F, 0x40,
  0xBE, 0x0D, 0xB2, 0x83, 0x7C, 0x0F, 0x84, 0x81, 0x2F, 0x74, 0x81, 0x2F, 0x75, 0x90, 0x85, 0x00,
  0xC3, 0x86, 0x10, 0x5F, 0x60, 0x2C, 0x28, 0x36, 0xDE, 0xD5,
  // "Ĉ" (U+0108)
  0x58, 0x1E, 0xF1, 0x58, 0x27, 0xB9, 0x94, 0x84, 0x1C, 0x10, 0xB3, 0x75, 0x84, 0x6C, 0xEE, 0xA2,
  0x28, 0x91, 0x9E, 0x40, 0x2E, 0xD0, 0x4F, 0x63, 0x84, 0x7D, 0x0A, 0xF1, 0x30, 0x12, 0x0E, 0x0D,
  0x68, 0x11, 0xFB, 0x68, 0x11, 0xFB, 0x68, 0x11, 0xFB, 0x70, 0xE0, 0xD7, 0x81, 0xBF, 0x16, 0x81,
  0x4F, 0x74, 0x03, 0x28, 0x1A, 0xE5, 0x20, 0x50, 0xC3, 0x84, 0x7D, 0xEE, 0xA2,
  // "ĉ" (U+0109)
  0x38, 0x1E, 0xF1, 0x38, 0x27, 0xB9, 0x92, 0x84, 0x1C, 0x10, 0xB3, 0x72, 0x89, 0x57, 0xDE, 0xC4,
  0x06, 0xF4, 0x0B, 0xE0, 0xDB, 0x28, 0x37, 0xC0, 0xF8, 0x48, 0x12, 0xF7, 0x48, 0x12, 0xF7, 0x59,
  0x08, 0x50, 0x0C, 0x38, 0x61, 0x05, 0xF6, 0x02, 0xC2, 0x83, 0x6D, 0xED, 0x50,
  // "Ċ" (U+010A)
  0x50, 0x17, 0x81, 0x2F, 0x76, 0x81, 0x2E, 0x67, 0x77, 0x28, 0x46, 0xCE, 0xEA, 0x22, 0x89, 0x19,
  0xE4, 0x02, 0xED, 0x04, 0xF6, 0x38, 0x47, 0xD0, 0xAF, 0x13, 0x01, 0x20, 0xE0, 0xD6, 0x81, 0x1F,
  0xB6, 0x81, 0x1F, 0xB6, 0x81, 0x1F, 0xB7, 0x0E, 0x0D, 0x78, 0x1B, 0xF1, 0x68, 0x14, 0xF7, 0x40,
  0x32, 0x81, 0xAE, 0x52, 0x05, 0x0C, 0x38, 0x47, 0xDE, 0xEA, 0x20,
  // "ċ" (U+010B)
  0x40, 0x15, 0x81, 0x2F, 0x74, 0x81, 0x2E, 0x67, 0x73, 0x89, 0x57, 0xDE, 0xC4, 0x06, 0xF4, 0x0B,
  0xE0, 0xDB, 0x28, 0x37, 0xC0, 0xF8, 0x48, 0x12, 0xF7, 0x48, 0x12, 0xF7, 0x59, 0x08, 0x50, 0x0C,
  0x38, 0x61, 0x05, 0xF6, 0x02, 0xC2, 0x83, 0x6D, 0xED, 0x50,
  // "Č" (U+010C)
  0x38, 0x42, 0xC1, 0x0B, 0x34, 0x82, 0x7B, 0x9A, 0x68, 0x1E, 0xF1, 0x76, 0x84, 0x6C, 0xEE, 0xA2,
  0x28, 0x91, 0x9E, 0x40, 0x2E, 0xD0, 0x4F, 0x63, 0x84, 0x7D, 0x0A, 0xF1, 0x30, 0x12, 0x0E, 0x0D,
  0x68, 0x11, 0xFB, 0x68, 0x11, 0xFB, 0x68, 0x11, 0xFB, 0x70, 0xE0, 0xD7, 0x81, 0xBF, 0x16, 0x81,
  0x4F, 0x74, 0x03, 0x28, 0x1A, 0xE5, 0x20, 0x50, 0xC3, 0x84, 0x7D, 0xEE, 0xA2,
  // "č" (U+010D)
  0x18, 0x42, 0xC1, 0x0B, 0x32, 0x82, 0x7B, 0x9A, 0x48, 0x1E, 0xF1, 0x73, 0x89, 0x57, 0xDE, 0xC4,
  0x06, 0xF4, 0x0B, 0xE0, 0xDB, 0x28, 0x37, 0xC0, 0xF8, 0x48, 0x12, 0xF7, 0x48, 0x12, 0xF7, 0x59,
  0x08, 0x50, 0x0C, 0x38, 0x61, 0x05, 0xF6, 0x02, 0xC2, 0x83, 0x6D, 0xED, 0x50,
  // "Ď" (U+010E)
  0x28, 0x42, 0xC1, 0x0B, 0x36, 0x82, 0x7B, 0x9A, 0x71, 0x81, 0xEF, 0x17, 0x71, 0x06, 0xB8, 0x2E,
  0xED, 0x84, 0x81, 0x2F, 0xB2, 0x81, 0x5E, 0xC4, 0x90, 0xB3, 0x81, 0x4F, 0x83, 0x90, 0xB4, 0x0D,
  0x0E, 0x39, 0x0B, 0x48, 0x19, 0xF3, 0x29, 0x0B, 0x48, 0x17, 0xF5, 0x29, 0x0B, 0x48, 0x17, 0xF6,
  0x29, 0x0B, 0x48, 0x17, 0xF5, 0x29, 0x0B, 0x48, 0x19, 0xF3, 0x29, 0x0B, 0x40, 0xD0, 0xE3, 0x90,
  0xB3, 0x81, 0x4F, 0x82, 0x81, 0x3F, 0xB2, 0x81, 0x4E, 0xC2, 0x06, 0xB8, 0x2E, 0xED, 0x83,
  // "ď" (U+010F)
  0x40, 0x1A, 0x82, 0xD0, 0xD7, 0x58, 0x41, 0xDD, 0x0E, 0x16, 0x82, 0xAD, 0x38, 0x70, 0xA0, 0xD5,
  0x84, 0x9E, 0xD5, 0xAD, 0x48, 0x58, 0xF3, 0x07, 0xDD, 0x40, 0xE0, 0xB3, 0x90, 0xD3, 0x81, 0x1F,
  0x83, 0x0C, 0x0D, 0x38, 0x12, 0xF7, 0x30, 0xB0, 0xD3, 0x81, 0x2F, 0x73, 0x0B, 0x0D, 0x38, 0x11,
  0xF8, 0x30, 0xC0, 0xD4, 0x0E, 0x0B, 0x39, 0x0D, 0x48, 0x68, 0xF4, 0x08, 0xBF, 0x14, 0x83, 0x9E,
  0xD5, 0x7A, 0x03, 0x10,
  // "Đ" (U+0110)
  0x06, 0xB8, 0x2E, 0xED, 0x84, 0x81, 0x3F, 0xB2, 0x81, 0x5E, 0xC4, 0x90, 0xB3, 0x81, 0x4F, 0x83,
  0x90, 0xB4, 0x0D, 0x0E, 0x39, 0x0B, 0x48, 0x19, 0xF3, 0x29, 0x0B, 0x48, 0x37, 0xF5, 0x5E, 0xA8,
  0x5E, 0xE2, 0x07, 0xF6, 0x29, 0x0B, 0x48, 0x17, 0xF5, 0x29, 0x0B, 0x48, 0x19, 0xF3, 0x29, 0x0B,
  0x40, 0xD0, 0xE3, 0x90, 0xB3, 0x81, 0x4F, 0x82, 0x81, 0x2F, 0xB2, 0x81, 0x4E, 0xC2, 0x06, 0xB8,
  0x2E, 0xED, 0x83,
  // "đ" (U+0111)
  0x40, 0x1A, 0x0D, 0x71, 0x0C, 0x0D, 0x58, 0x14, 0xEE, 0xA0, 0xE0, 0x36, 0x0A, 0x0D, 0x48, 0x49,
  0xED, 0x6A, 0xD3, 0x85, 0x7F, 0x30, 0x8D, 0xD3, 0x0D, 0x0B, 0x39, 0x0D, 0x28, 0x11, 0xF8, 0x30,
  0xC0, 0xD2, 0x81, 0x2F, 0x73, 0x0B, 0x0D, 0x28, 0x12, 0xF7, 0x30, 0xB0, 0xD2, 0x81, 0x1F, 0x83,
  0x0C, 0x0D, 0x30, 0xE0, 0xB3, 0x90, 0xD3, 0x86, 0x8F, 0x40, 0x7B, 0xF1, 0x38, 0x39, 0xED, 0x57,
  0xA0, 0x30,
  // "Ē" (U+0112)
  0x28, 0x44, 0xEE, 0xEE, 0x27, 0x38, 0x93, 0x5E, 0xFE, 0xBB, 0xCF, 0x70, 0x1F, 0xB3, 0x0A, 0x07,
  0x29, 0x0B, 0x30, 0x60, 0x72, 0x90, 0xB3, 0x01, 0x02, 0x29, 0x0B, 0x79, 0x0B, 0x7A, 0x0F, 0xE0,
  0x53, 0x90, 0xB7, 0x90, 0xB7, 0x90, 0xB7, 0x90, 0xB4, 0x83, 0xD0, 0x1F, 0xB3, 0x89, 0x13, 0xF5,
  0xEF, 0xEB, 0xBB, 0xEE,
  // "ē" (U+0113)
  0x18, 0x44, 0xEE, 0xEE, 0x27, 0x48, 0x36, 0xDE, 0xB2, 0x28, 0x45, 0xF4, 0x0A, 0xD2, 0x0C, 0x0B,
  0x28, 0x43, 0xF5, 0x0F, 0x82, 0x82, 0x1F, 0x72, 0xA0, 0xFE, 0x98, 0x28, 0x2F, 0x76, 0x90, 0x96,
  0x00, 0xC3, 0x01, 0x28, 0x55, 0xF7, 0x01, 0xC2, 0x28, 0x36, 0xDE, 0xD5, 0x10,
  // "Ĕ" (U+0114)
  0x20, 0x10, 0x42, 0x05, 0x48, 0x31, 0xC1, 0x2D, 0x58, 0x26, 0xDD, 0x47, 0x48, 0x93, 0x5E, 0xFE,
  0xBB, 0xCF, 0x70, 0x1F, 0xB3, 0x0A, 0x07, 0x29, 0x0B, 0x30, 0x60, 0x72, 0x90, 0xB3, 0x01, 0x02,
  0x29, 0x0B, 0x79, 0x0B, 0x7A, 0x0F, 0xE0, 0x53, 0x90, 0xB7, 0x90, 0xB7, 0x90, 0xB7, 0x90, 0xB4,
  0x83, 0xD0, 0x1F, 0xB3, 0x89, 0x13, 0xF5, 0xEF, 0xEB, 0xBB, 0xEE,
  // "ĕ" (U+0115)
  0x10, 0x10, 0x42, 0x05, 0x38, 0x31, 0xC1, 0x2D, 0x48, 0x26, 0xDD, 0x47, 0x58, 0x36, 0xDE, 0xB2,
  0x28, 0x45, 0xF4, 0x0A, 0xD2, 0x0C, 0x0B, 0x28, 0x43, 0xF5, 0x0F, 0x82, 0x82, 0x1F, 0x72, 0xA0,
  0xFE, 0x98, 0x28, 0x2F, 0x76, 0x90, 0x96, 0x00, 0xC3, 0x01, 0x28, 0x55, 0xF7, 0x01, 0xC2, 0x28,
  0x36, 0xDE, 0xD5, 0x10,
  // "Ė" (U+0116)
  0x40, 0x17, 0x81, 0x2F, 0x76, 0x81, 0x2E, 0x67, 0x77, 0x89, 0x35, 0xEF, 0xEB, 0xBC, 0xF7, 0x01,
  0xFB, 0x30, 0xA0, 0x72, 0x90, 0xB3, 0x06, 0x07, 0x29, 0x0B, 0x30, 0x10, 0x22, 0x90, 0xB7, 0x90,
  0xB7, 0xA0, 0xFE, 0x05, 0x39, 0x0B, 0x79, 0x0B, 0x79, 0x0B, 0x79, 0x0B, 0x48, 0x3D, 0x01, 0xFB,
  0x38, 0x91, 0x3F, 0x5E, 0xFE, 0xBB, 0xBE, 0xE0,
  // "ė" (U+0117)
  0x40, 0x16, 0x81, 0x2F, 0x75, 0x81, 0x2E, 0x67, 0x76, 0x83, 0x6D, 0xEB, 0x22, 0x84, 0x5F, 0x40,
  0xAD, 0x20, 0xC0, 0xB2, 0x84, 0x3F, 0x50, 0xF8, 0x28, 0x21, 0xF7, 0x2A, 0x0F, 0xE9, 0x82, 0x82,
  0xF7, 0x69, 0x09, 0x60, 0x0C, 0x30, 0x12, 0x85, 0x5F, 0x70, 0x1C, 0x22, 0x83, 0x6D, 0xED, 0x51,
  // "Ę" (U+0118)
  0x89, 0x35, 0xEF, 0xEB, 0xBC, 0xF7, 0x01, 0xFB, 0x30, 0xA0, 0x72, 0x90, 0xB3, 0x06, 0x07, 0x29,
  0x0B, 0x30, 0x10, 0x22, 0x90, 0xB7, 0x90, 0xB7, 0xA0, 0xFE, 0x05, 0x39, 0x0B, 0x79, 0x0B, 0x79,
  0x0B, 0x79, 0x0B, 0x48, 0x3D, 0x01, 0xFB, 0x38, 0x91, 0x3F, 0x5E, 0xFE, 0xBB, 0xDF, 0xE5, 0x81,
  0x1D, 0x16, 0x08, 0x0A, 0x70, 0x90, 0xC7, 0x82, 0x3E, 0xFA, 0x70, 0x11,
  // "ę" (U+0119)
  0x28, 0x36, 0xDE, 0xB2, 0x28, 0x45, 0xF4, 0x0A, 0xD2, 0x0C, 0x0B, 0x28, 0x43, 0xF5, 0x0F, 0x82,
  0x82, 0x1F, 0x72, 0xA0, 0xFE, 0x98, 0x28, 0x2F, 0x76, 0x90, 0x96, 0x00, 0xC3, 0x01, 0x28, 0x55,
  0xF7, 0x01, 0xC2, 0x20, 0x60, 0xDA, 0x05, 0x50, 0x90, 0x55, 0x02, 0x0E, 0x68, 0x13, 0xF1, 0x68,
  0x1A, 0xEC, 0x10,
  // "Ě" (U+011A)
  0x28, 0x42, 0xC1, 0x0B, 0x34, 0x82, 0x7B, 0x9A, 0x68, 0x1E, 0xF1, 0x74, 0x89, 0x35, 0xEF, 0xEB,
  0xBC, 0xF7, 0x01, 0xFB, 0x30, 0xA0, 0x72, 0x90, 0xB3, 0x06, 0x07, 0x29, 0x0B, 0x30, 0x10, 0x22,
  0x90, 0xB7, 0x90, 0xB7, 0xA0, 0xFE, 0x05, 0x39, 0x0B, 0x79, 0x0B, 0x79, 0x0B, 0x79, 0x0B, 0x48,
  0x3D, 0x01, 0xFB, 0x38, 0x91, 0x3F, 0x5E, 0xFE, 0xBB, 0xBE, 0xE0,
  // "ě" (U+011B)
  0x18, 0x42, 0xC1, 0x0B, 0x33, 0x82, 0x7B, 0x9A, 0x58, 0x1E, 0xF1, 0x75, 0x83, 0x6D, 0xEB, 0x22,
  0x84, 0x5F, 0x40, 0xAD, 0x20, 0xC0, 0xB2, 0x84, 0x3F, 0x50, 0xF8, 0x28, 0x21, 0xF7, 0x2A, 0x0F,
  0xE9, 0x82, 0x82, 0xF7, 0x69, 0x09, 0x60, 0x0C, 0x30, 0x12, 0x85, 0x5F, 0x70, 0x1C, 0x22, 0x83,
  0x6D, 0xED, 0x51,
  // "Ĝ" (U+011C)
  0x58, 0x1E, 0xF1, 0x78, 0x27, 0xB9, 0x96, 0x84, 0x1C, 0x10, 0xB3, 0x77, 0x28, 0x43, 0xAD, 0xED,
  0x84, 0x81, 0x6F, 0x62, 0x81, 0x5F, 0x92, 0x81, 0x2F, 0x74, 0x0C, 0x09, 0x28, 0x19, 0xF1, 0x40,
  0x13, 0x0E, 0x0D, 0x72, 0x90, 0xC7, 0x18, 0x11, 0xFB, 0x71, 0x81, 0x1F, 0xC3, 0x04, 0xB8, 0x2B,
  0x0E, 0xD4, 0x81, 0x3F, 0xC2, 0x81, 0xAF, 0x14, 0x90, 0xA2, 0x81, 0x3F, 0x84, 0x90, 0xA3, 0x81,
  0x7F, 0x72, 0x81, 0x1F, 0xA4, 0x85, 0x4B, 0xEE, 0xDA, 0x31,
  // "ĝ" (U+011D)
  0x38, 0x1E, 0xF1, 0x48, 0x27, 0xB9, 0x93, 0x84, 0x1C, 0x10, 0xB3, 0x73, 0x8A, 0x01, 0xAE, 0xD7,
  0xBD, 0x0A, 0xC0, 0x2E, 0x56, 0x0E, 0x82, 0x00, 0xB2, 0x90, 0x72, 0x00, 0xB2, 0x84, 0xAC, 0x12,
  0xE7, 0x28, 0x31, 0xDE, 0xD8, 0x30, 0x40, 0xA6, 0x0A, 0x07, 0x60, 0x80, 0x96, 0x89, 0x02, 0xEE,
  0xED, 0xA1, 0x3D, 0x32, 0x83, 0x1D, 0x89, 0xA4, 0x83, 0xBA, 0x7E, 0x22, 0x89, 0x05, 0xF5, 0x08,
  0xDE, 0xEB, 0x51,
  // "Ğ" (U+011E)
  0x30, 0x10, 0x42, 0x05, 0x68, 0x31, 0xC1, 0x2D, 0x78, 0x26, 0xDD, 0x47, 0x73, 0x84, 0x3A, 0xDE,
  0xD8, 0x48, 0x16, 0xF6, 0x28, 0x15, 0xF9, 0x28, 0x12, 0xF7, 0x40, 0xC0, 0x92, 0x81, 0x9F, 0x14,
  0x01, 0x30, 0xE0, 0xD7, 0x29, 0x0C, 0x71, 0x81, 0x1F, 0xB7, 0x18, 0x11, 0xFC, 0x30, 0x4B, 0x82,
  0xB0, 0xED, 0x48, 0x13, 0xFC, 0x28, 0x1A, 0xF1, 0x49, 0x0A, 0x28, 0x13, 0xF8, 0x49, 0x0A, 0x38,
  0x17, 0xF7, 0x28, 0x11, 0xFA, 0x48, 0x54, 0xBE, 0xED, 0xA3, 0x10,
  // "ğ" (U+011F)
  0x10, 0x10, 0x42, 0x05, 0x38, 0x31, 0xC1, 0x2D, 0x48, 0x26, 0xDD, 0x47, 0x48, 0xA0, 0x1A, 0xED,
  0x7B, 0xD0, 0xAC, 0x02, 0xE5, 0x60, 0xE8, 0x20, 0x0B, 0x29, 0x07, 0x20, 0x0B, 0x28, 0x4A, 0xC1,
  0x2E, 0x72, 0x83, 0x1D, 0xED, 0x83, 0x04, 0x0A, 0x60, 0xA0, 0x76, 0x08, 0x09, 0x68, 0x90, 0x2E,
  0xEE, 0xDA, 0x13, 0xD3, 0x28, 0x31, 0xD8, 0x9A, 0x48, 0x3B, 0xA7, 0xE2, 0x28, 0x90, 0x5F, 0x50,
  0x8D, 0xEE, 0xB5, 0x10,
  // "Ġ" (U+0120)
  0x60, 0x17, 0x28, 0x12, 0xF7, 0x71, 0x81, 0x2E, 0x67, 0x77, 0x78, 0x43, 0xAD, 0xED, 0x84, 0x81,
  0x6F, 0x62, 0x81, 0x5F, 0x92, 0x81, 0x2F, 0x74, 0x0C, 0x09, 0x28, 0x19, 0xF1, 0x40, 0x13, 0x0E,
  0x0D, 0x72, 0x90, 0xC7, 0x18, 0x11, 0xFB, 0x71, 0x81, 0x1F, 0xC3, 0x04, 0xB8, 0x2B, 0x0E, 0xD4,
  0x81, 0x3F, 0xC2, 0x81, 0xAF, 0x14, 0x90, 0xA2, 0x81, 0x3F, 0x84, 0x90, 0xA3, 0x81, 0x7F, 0x72,
  0x81, 0x1F, 0xA4, 0x85, 0x4B, 0xEE, 0xDA, 0x31,
  // "ġ" (U+0121)
  0x30, 0x16, 0x81, 0x2F, 0x75, 0x81, 0x2E, 0x67, 0x76, 0x8A, 0x01, 0xAE, 0xD7, 0xBD, 0x0A, 0xC0,
  0x2E, 0x56, 0x0E, 0x82, 0x00, 0xB2, 0x90, 0x72, 0x00, 0xB2, 0x84, 0xAC, 0x12, 0xE7, 0x28, 0x31,
  0xDE, 0xD8, 0x30, 0x40, 0xA6, 0x0A, 0x07, 0x60, 0x80, 0x96, 0x89, 0x02, 0xEE, 0xED, 0xA1, 0x3D,
  0x32, 0x83, 0x1D, 0x89, 0xA4, 0x83, 0xBA, 0x7E, 0x22, 0x89, 0x05, 0xF5, 0x08, 0xDE, 0xEB, 0x51,
  // "Ģ" (U+0122)
  0x38, 0x43, 0xAD, 0xED, 0x84, 0x81, 0x6F, 0x62, 0x81, 0x5F, 0x92, 0x81, 0x2F, 0x74, 0x0C, 0x09,
  0x28, 0x19, 0xF1, 0x40, 0x13, 0x0E, 0x0D, 0x72, 0x90, 0xC7, 0x18, 0x11, 0xFB, 0x71, 0x81, 0x1F,
  0xC3, 0x04, 0xB8, 0x2B, 0x0E, 0xD4, 0x81, 0x3F, 0xC2, 0x81, 0xAF, 0x14, 0x90, 0xA2, 0x81, 0x3F,
  0x84, 0x90, 0xA3, 0x81, 0x7F, 0x72, 0x81, 0x1F, 0xA4, 0x85, 0x4B, 0xEE, 0xDA, 0x37, 0x73, 0x08,
  0x0C, 0x72, 0x0B, 0x06, 0x72, 0x0C, 0x50,
  // "ģ" (U+0123)
  0x40, 0xB0, 0x25, 0x04, 0x96, 0x09, 0x0B, 0x75, 0x8A, 0x01, 0xAE, 0xD7, 0xBD, 0x0A, 0xC0, 0x2E,
  0x56, 0x0E, 0x82, 0x00, 0xB2, 0x90, 0x72, 0x00, 0xB2, 0x84, 0xAC, 0x12, 0xE7, 0x28, 0x31, 0xDE,
  0xD8, 0x30, 0x40, 0xA6, 0x0A, 0x07, 0x60, 0x80, 0x96, 0x89, 0x02, 0xEE, 0xED, 0xA1, 0x3D, 0x32,
  0x83, 0x1D, 0x89, 0xA4, 0x83, 0xBA, 0x7E, 0x22, 0x89, 0x05, 0xF5, 0x08, 0xDE, 0xEB, 0x51,
  // "Ĥ" (U+0124)
  0x58, 0x1E, 0xF1, 0x71, 0x82, 0x7B, 0x99, 0x78, 0x41, 0xC1, 0x0B, 0x37, 0x71, 0x06, 0xC8, 0x11,
  0x0C, 0xB8, 0x4A, 0x02, 0xFD, 0x13, 0x81, 0xAF, 0x63, 0x90, 0xB4, 0x81, 0x7F, 0x33, 0x90, 0xB4,
  0x81, 0x7F, 0x33, 0x90, 0xB4, 0x81, 0x7F, 0x33, 0x90, 0xB4, 0x81, 0x7F, 0x33, 0xA8, 0x00, 0xEA,
  0x03, 0x39, 0x0B, 0x48, 0x17, 0xF3, 0x39, 0x0B, 0x48, 0x17, 0xF3, 0x39, 0x0B, 0x48, 0x17, 0xF3,
  0x39, 0x0B, 0x48, 0x17, 0xF3, 0x28, 0x12, 0xFD, 0x48, 0x39, 0xF6, 0x06, 0xC8, 0x11, 0x0C, 0xB0,
  0xA0,
  // "ĥ" (U+0125)
  0x38, 0x1E, 0xF1, 0x68, 0x27, 0xB9, 0x95, 0x84, 0x1C, 0x10, 0xB3, 0x30, 0xBA, 0x03, 0x78, 0x18,
  0xF3, 0x78, 0x15, 0xF3, 0x78, 0x15, 0xF3, 0x78, 0x55, 0xF4, 0xBE, 0xC3, 0x38, 0x55, 0xFB, 0x11,
  0xDC, 0x38, 0x15, 0xF6, 0x28, 0x17, 0xF1, 0x28, 0x15, 0xF4, 0x28, 0x16, 0xF2, 0x28, 0x15, 0xF3,
  0x28, 0x16, 0xF3, 0x28, 0x15, 0xF3, 0x28, 0x16, 0xF3, 0x28, 0x15, 0xF3, 0x28, 0x16, 0xF3, 0x28,
  0x15, 0xF3, 0x28, 0x16, 0xF3, 0x28, 0x18, 0xF6, 0x28, 0x36, 0xF6, 0x0B, 0xB8, 0x17, 0x06, 0xA0,
  0x60,
  // "Ħ" (U+0126)
  0x06, 0xC8, 0x11, 0x0C, 0xB8, 0x3A, 0x02, 0xFD, 0x48, 0x19, 0xF6, 0x39, 0x0B, 0x48, 0x47, 0xF3,
  0x06, 0xEA, 0x80, 0x0E, 0xA0, 0xE0, 0xA2, 0x90, 0xB4, 0x81, 0x7F, 0x33, 0x90, 0xB4, 0x81, 0x7F,
  0x33, 0xA8, 0x00, 0xEA, 0x03, 0x39, 0x0B, 0x48, 0x17, 0xF3, 0x39, 0x0B, 0x48, 0x17, 0xF3, 0x39,
  0x0B, 0x48, 0x17, 0xF3, 0x39, 0x0B, 0x48, 0x17, 0xF3, 0x28, 0x12, 0xFD, 0x48, 0x39, 0xF6, 0x06,
  0xC8, 0x11, 0x0C, 0xB0, 0xA0,
  // "ħ" (U+0127)
  0xBF, 0xF3, 0x00, 0x00, 0x00, 0x07, 0xF3, 0x00, 0x00, 0x00, 0xAE, 0xFE, 0xEB, 0x00, 0x00, 0x05,
  0xF3, 0x00, 0x00, 0x00, 0x05, 0xF4, 0xAE, 0xC2, 0x00, 0x05, 0xFA, 0x11, 0xDD, 0x00, 0x05, 0xF6,
  0x00, 0x7F, 0x10, 0x05, 0xF4, 0x00, 0x6F, 0x30, 0x05, 0xF3, 0x00, 0x6F, 0x30, 0x05, 0xF3, 0x00,
  0x6F, 0x30, 0x05, 0xF3, 0x00, 0x6F, 0x30, 0x05, 0xF3, 0x00, 0x6F, 0x30, 0x08, 0xF6, 0x00, 0x6F,
  0x60, 0xBF, 0xFF, 0x70, 0x6F, 0xF6,
  // "Ĩ" (U+0128)
  0x18, 0x92, 0x9E, 0x91, 0x72, 0x27, 0x19, 0xEA, 0x72, 0x06, 0xC0, 0x22, 0x81, 0x3F, 0xD5, 0x90,
  0xB5, 0x90, 0xB5, 0x90, 0xB5, 0x90, 0xB5, 0x90, 0xB5, 0x90, 0xB5, 0x90, 0xB5, 0x90, 0xB5, 0x90,
  0xB4, 0x81, 0x2F, 0xD3, 0x06, 0xC0, 0x20,
  // "ĩ" (U+0129)
  0x18, 0x92, 0x9E, 0x91, 0x72, 0x27, 0x19, 0xEA, 0x72, 0x08, 0xA0, 0x54, 0x81, 0x6F, 0x54, 0x81,
  0x3F, 0x54, 0x81, 0x3F, 0x54, 0x81, 0x3F, 0x54, 0x81, 0x3F, 0x54, 0x81, 0x3F, 0x54, 0x81, 0x3F,
  0x54, 0x81, 0x6F, 0x83, 0x09, 0xB0, 0xB1,
  // "Ī" (U+012A)
  0x84, 0x4E, 0xEE, 0xE2, 0x60, 0x6C, 0x83, 0x20, 0x3F, 0xD4, 0x90, 0xB4, 0x90, 0xB4, 0x90, 0xB4,
  0x90, 0xB4, 0x90, 0xB4, 0x90, 0xB4, 0x90, 0xB4, 0x90, 0xB4, 0x90, 0xB3, 0x81, 0x2F, 0xD2, 0x06,
  0xC0, 0x20,
  // "ī" (U+012B)
  0x84, 0x4E, 0xEE, 0xE2, 0x70, 0x8A, 0x05, 0x38, 0x16, 0xF5, 0x38, 0x13, 0xF5, 0x38, 0x13, 0xF5,
  0x38, 0x13, 0xF5, 0x38, 0x13, 0xF5, 0x38, 0x13, 0xF5, 0x38, 0x13, 0xF5, 0x38, 0x16, 0xF8, 0x20,
  0x9B, 0x0B,
  // "Ĭ" (U+012C)
  0x01, 0x04, 0x28, 0x55, 0x01, 0xC1, 0x2D, 0x28, 0x26, 0xDD, 0x47, 0x06, 0xC8, 0x32, 0x03, 0xFD,
  0x49, 0x0B, 0x49, 0x0B, 0x49, 0x0B, 0x49, 0x0B, 0x49, 0x0B, 0x49, 0x0B, 0x49, 0x0B, 0x49, 0x0B,
  0x49, 0x0B, 0x38, 0x12, 0xFD, 0x20, 0x6C, 0x02,
  // "ĭ" (U+012D)
  0x01, 0x04, 0x28, 0x55, 0x01, 0xC1, 0x2D, 0x28, 0x26, 0xDD, 0x47, 0x10, 0x8A, 0x05, 0x38, 0x16,
  0xF5, 0x38, 0x13, 0xF5, 0x38, 0x13, 0xF5, 0x38, 0x13, 0xF5, 0x38, 0x13, 0xF5, 0x38, 0x13, 0xF5,
  0x38, 0x13, 0xF5, 0x38, 0x16, 0xF8, 0x20, 0x9B, 0x0B,
  // "Į" (U+012E)
  0x06, 0xC8, 0x32, 0x03, 0xFD, 0x49, 0x0B, 0x49, 0x0B, 0x49, 0x0B, 0x49, 0x0B, 0x49, 0x0B, 0x49,
  0x0B, 0x49, 0x0B, 0x49, 0x0B, 0x49, 0x0B, 0x38, 0x12, 0xFD, 0x20, 0x6C, 0x83, 0x20, 0x1D, 0x13,
  0x08, 0x0A, 0x40, 0x90, 0xC4, 0x82, 0x3E, 0xFA, 0x40, 0x12,
  // "į" (U+012F)
  0x04, 0xE4, 0x00, 0x5F, 0x50, 0x00, 0x10, 0x00, 0x00, 0x00, 0x8F, 0xF5, 0x00, 0x6F, 0x50, 0x03,
  0xF5, 0x00, 0x3F, 0x50, 0x03, 0xF5, 0x00, 0x3F, 0x50, 0x03, 0xF5, 0x00, 0x3F, 0x50, 0x06, 0xF8,
  0x09, 0xFF, 0xFB, 0x01, 0xD1, 0x00, 0x8A, 0x00, 0x09, 0xC0, 0x00, 0x3E, 0xFA, 0x00, 0x01, 0x00,
  // "İ" (U+0130)
  0x20, 0x14, 0x81, 0x2F, 0x73, 0x81, 0x2E, 0x67, 0x70, 0x6C, 0x83, 0x20, 0x3F, 0xD4, 0x90, 0xB4,
  0x90, 0xB4, 0x90, 0xB4, 0x90, 0xB4, 0x90, 0xB4, 0x90, 0xB4, 0x90, 0xB4, 0x90, 0xB4, 0x90, 0xB3,
  0x81, 0x2F, 0xD2, 0x06, 0xC0, 0x20,
  // "ı" (U+0131)
  0x8F, 0xF5, 0x00, 0x6F, 0x50, 0x03, 0xF5, 0x00, 0x3F, 0x50, 0x03, 0xF5, 0x00, 0x3F, 0x50, 0x03,
  0xF5, 0x00, 0x3F, 0x50, 0x06, 0xF8, 0x09, 0xFF, 0xFB,
  // "Ĳ" (U+0132)
  0x06, 0xC0, 0x20, 0x5C, 0x83, 0x30, 0x3F, 0xD3, 0x82, 0x2F, 0xE1, 0x39, 0x0B, 0x40, 0xE0, 0xC4,
  0x90, 0xB4, 0x0E, 0x0C, 0x49, 0x0B, 0x40, 0xE0, 0xC4, 0x90, 0xB4, 0x0E, 0x0C, 0x49, 0x0B, 0x40,
  0xE0, 0xC4, 0x90, 0xB4, 0x0E, 0x0C, 0x49, 0x0B, 0x40, 0xE0, 0xC4, 0x90, 0xB4, 0x0E, 0x0C, 0x49,
  0x0B, 0x40, 0xE0, 0xC3, 0x81, 0x2F, 0xD4, 0x0E, 0x0C, 0x20, 0x6C, 0x02, 0x20, 0xE0, 0xC7, 0x39,
  0x0B, 0x72, 0x81, 0x2F, 0x97, 0x28, 0x1A, 0xF2, 0x78, 0x22, 0xEC, 0x43,
  // "ĳ" (U+0133)
  0x18, 0x14, 0xE4, 0x28, 0x54, 0xE3, 0x05, 0xF5, 0x28, 0x15, 0xF5, 0x20, 0x14, 0x01, 0x73, 0x08,
  0xA8, 0x15, 0x08, 0xA8, 0x35, 0x06, 0xF5, 0x28, 0x57, 0xF5, 0x03, 0xF5, 0x28, 0x53, 0xF5, 0x03,
  0xF5, 0x28, 0x53, 0xF5, 0x03, 0xF5, 0x28, 0x53, 0xF5, 0x03, 0xF5, 0x28, 0x53, 0xF5, 0x03, 0xF5,
  0x28, 0x53, 0xF5, 0x03, 0xF5, 0x28, 0x53, 0xF5, 0x06, 0xF8, 0x28, 0x23, 0xF5, 0x9B, 0x83, 0xB0,
  0x3F, 0x56, 0x81, 0x4F, 0x46, 0x81, 0x6F, 0x25, 0x81, 0x1C, 0xC5, 0x82, 0x1E, 0xB2, 0x10,
  // "Ĵ" (U+0134)
  0x38, 0x1E, 0xF1, 0x38, 0x27, 0xB9, 0x92, 0x84, 0x1C, 0x10, 0xB3, 0x71, 0x05, 0xC0, 0x32, 0x82,
  0x2F, 0xE1, 0x40, 0xE0, 0xC5, 0x0E, 0x0C, 0x50, 0xE0, 0xC5, 0x0E, 0x0C, 0x50, 0xE0, 0xC5, 0x0E,
  0x0C, 0x50, 0xE0, 0xC5, 0x0E, 0x0C, 0x50, 0xE0, 0xC5, 0x0E, 0x0C, 0x50, 0xE0, 0xC5, 0x90, 0xB4,
  0x81, 0x2F, 0x94, 0x81, 0xAF, 0x22, 0x82, 0x2E, 0xC4, 0x30,
  // "ĵ" (U+0135)
  0x00, 0xEF, 0x10, 0x07, 0xB9, 0x90, 0x1C, 0x10, 0xB3, 0x00, 0x00, 0x00, 0x08, 0xFF, 0x50, 0x00,
  0x6F, 0x50, 0x00, 0x3F, 0x50, 0x00, 0x3F, 0x50, 0x00, 0x3F, 0x50, 0x00, 0x3F, 0x50, 0x00, 0x3F,
  0x50, 0x00, 0x3F, 0x50, 0x00, 0x3F, 0x50, 0x00, 0x3F, 0x50, 0x00, 0x4F, 0x40, 0x00, 0x6F, 0x20,
  0x01, 0xCC, 0x00, 0x1E, 0xB2, 0x00,
  // "Ķ" (U+0136)
  0x06, 0xC0, 0x11, 0xB0, 0x62, 0x81, 0x2F, 0xD3, 0x81, 0x5F, 0x54, 0x90, 0xB3, 0x0C, 0x06, 0x59,
  0x0B, 0x20, 0x80, 0x96, 0x98, 0x2B, 0x03, 0xC7, 0x98, 0x2B, 0x1D, 0x47, 0x98, 0x2B, 0xAF, 0xB7,
  0x98, 0x3E, 0x69, 0xF5, 0x69, 0x84, 0xB0, 0x1E, 0xE1, 0x59, 0x0B, 0x28, 0x16, 0xFA, 0x59, 0x0B,
  0x38, 0x1C, 0xF4, 0x38, 0x12, 0xFD, 0x38, 0x43, 0xFE, 0x20, 0x6C, 0x01, 0x28, 0x26, 0xDF, 0x17,
  0x73, 0x08, 0x0C, 0x73, 0x0B, 0x06, 0x73, 0x0C, 0x60,
  // "ķ" (U+0137)
  0x0B, 0xA0, 0x37, 0x81, 0x8F, 0x37, 0x81, 0x5F, 0x37, 0x81, 0x5F, 0x37, 0x83, 0x5F, 0x30, 0xCA,
  0x09, 0x28, 0x55, 0xF3, 0x02, 0xF7, 0x38, 0x45, 0xF3, 0x09, 0x84, 0x83, 0x5F, 0x35, 0xB5, 0x83,
  0x5F, 0x5E, 0xB5, 0x84, 0x5F, 0xC9, 0xF4, 0x48, 0x45, 0xF4, 0x1E, 0xC4, 0x85, 0x5F, 0x30, 0x7F,
  0x63, 0x81, 0x8F, 0x62, 0x83, 0xEE, 0x20, 0xBB, 0x84, 0x80, 0x3D, 0xF2, 0x77, 0x08, 0x0C, 0x71,
  0x0B, 0x06, 0x71, 0x0C, 0x50,
  // "ĸ" (U+0138)
  0x0B, 0xA8, 0x13, 0x0C, 0xA0, 0x92, 0x85, 0x8F, 0x30, 0x2F, 0x73, 0x84, 0x5F, 0x30, 0x98, 0x48,
  0x35, 0xF3, 0x5B, 0x58, 0x35, 0xF5, 0xE9, 0x58, 0x45, 0xFC, 0xAF, 0x34, 0x84, 0x5F, 0x41, 0xFC,
  0x48, 0x55, 0xF3, 0x08, 0xF5, 0x38, 0x90, 0x8F, 0x60, 0x1E, 0xE2, 0x0B, 0xB8, 0x48, 0x04, 0xDF,
  0x20,
  // "Ĺ" (U+0139)
  0x38, 0x11, 0xFA, 0x60, 0x80, 0xC6, 0x81, 0x2C, 0x17, 0x60, 0x50, 0xEA, 0x0D, 0x02, 0x48, 0x11,
  0xFC, 0x79, 0x0B, 0x79, 0x0B, 0x79, 0x0B, 0x79, 0x0B, 0x79, 0x0B, 0x79, 0x0B, 0x79, 0x0B, 0x79,
  0x0B, 0x40, 0xB2, 0x90, 0xB4, 0x83, 0xE0, 0x1F, 0xB3, 0x89, 0x13, 0xE5, 0xEF, 0xEB, 0xBB, 0xEE,
  // "ĺ" (U+013A)
  0x00, 0x1F, 0xA0, 0x08, 0xC0, 0x02, 0xC1, 0x0B, 0xFF, 0x30, 0x08, 0xF3, 0x00, 0x5F, 0x30, 0x05,
  0xF3, 0x00, 0x5F, 0x30, 0x05, 0xF3, 0x00, 0x5F, 0x30, 0x05, 0xF3, 0x00, 0x5F, 0x30, 0x05, 0xF3,
  0x00, 0x5F, 0x30, 0x05, 0xF3, 0x00, 0x8F, 0x70, 0xBF, 0xFF, 0x90,
  // "Ļ" (U+013B)
  0x05, 0x0E, 0xA0, 0xD0, 0x24, 0x81, 0x1F, 0xC7, 0x90, 0xB7, 0x90, 0xB7, 0x90, 0xB7, 0x90, 0xB7,
  0x90, 0xB7, 0x90, 0xB7, 0x90, 0xB7, 0x90, 0xB4, 0x0B, 0x29, 0x0B, 0x48, 0x3E, 0x01, 0xFB, 0x38,
  0x91, 0x3E, 0x5E, 0xFE, 0xBB, 0xBE, 0xE7, 0x60, 0x80, 0xC7, 0x0B, 0x06, 0x70, 0xC4,
  // "ļ" (U+013C)
  0xBF, 0xF3, 0x00, 0x8F, 0x30, 0x05, 0xF3, 0x00, 0x5F, 0x30, 0x05, 0xF3, 0x00, 0x5F, 0x30, 0x05,
  0xF3, 0x00, 0x5F, 0x30, 0x05, 0xF3, 0x00, 0x5F, 0x30, 0x05, 0xF3, 0x00, 0x5F, 0x30, 0x08, 0xF7,
  0x0B, 0xFF, 0xF9, 0x00, 0x00, 0x00, 0x8C, 0x00, 0x0B, 0x60, 0x00, 0xC0, 0x00,
  // "Ľ" (U+013D)
  0x05, 0x0E, 0xA8, 0x7D, 0x20, 0xF4, 0x01, 0xFC, 0x20, 0x30, 0xD3, 0x90, 0xB2, 0x00, 0x53, 0x90,
  0xB7, 0x90, 0xB7, 0x90, 0xB7, 0x90, 0xB7, 0x90, 0xB7, 0x90, 0xB7, 0x90, 0xB4, 0x0B, 0x29, 0x0B,
  0x48, 0x3E, 0x01, 0xFB, 0x38, 0x91, 0x3E, 0x5E, 0xFE, 0xBB, 0xBE, 0xE0,
  // "ľ" (U+013E)
  0xBF, 0xF3, 0x7D, 0x08, 0xF3, 0xA6, 0x05, 0xF3, 0xB0, 0x05, 0xF3, 0x00, 0x05, 0xF3, 0x00, 0x05,
  0xF3, 0x00, 0x05, 0xF3, 0x00, 0x05, 0xF3, 0x00, 0x05, 0xF3, 0x00, 0x05, 0xF3, 0x00, 0x05, 0xF3,
  0x00, 0x05, 0xF3, 0x00, 0x08, 0xF7, 0x00, 0xBF, 0xFF, 0x90,
  // "Ŀ" (U+013F)
  0x05, 0x0E, 0xA0, 0xD0, 0x24, 0x81, 0x1F, 0xC7, 0x90, 0xB7, 0x90, 0xB7, 0x90, 0xB3, 0x01, 0x39,
  0x0B, 0x28, 0x12, 0xF7, 0x29, 0x0B, 0x28, 0x12, 0xE6, 0x29, 0x0B, 0x79, 0x0B, 0x79, 0x0B, 0x40,
  0xB2, 0x90, 0xB4, 0x83, 0xE0, 0x1F, 0xB3, 0x89, 0x13, 0xE5, 0xEF, 0xEB, 0xBB, 0xEE,
  // "ŀ" (U+0140)
  0x0B, 0xA0, 0x34, 0x81, 0x8F, 0x34, 0x81, 0x5F, 0x34, 0x81, 0x5F, 0x34, 0x81, 0x5F, 0x34, 0x81,
  0x5F, 0x34, 0x83, 0x5F, 0x30, 0x12, 0x89, 0x75, 0xF3, 0x2F, 0x70, 0x5F, 0x32, 0xE6, 0x05, 0xF3,
  0x48, 0x15, 0xF3, 0x48, 0x15, 0xF3, 0x48, 0x18, 0xF7, 0x30, 0xBB, 0x09, 0x20,
  // "Ł" (U+0141)
  0x05, 0x0E, 0xA0, 0xD0, 0x24, 0x81, 0x1F, 0xC7, 0x90, 0xB7, 0x90, 0xB7, 0x98, 0x2B, 0x06, 0x14,
  0x98, 0x1C, 0xB8, 0x59, 0x0E, 0x03, 0x48, 0x21, 0xBF, 0xB5, 0x82, 0x32, 0xFB, 0x79, 0x0B, 0x40,
  0xB2, 0x90, 0xB4, 0x83, 0xE0, 0x1F, 0xB3, 0x89, 0x13, 0xE5, 0xEF, 0xEB, 0xBB, 0xEE,
  // "ł" (U+0142)
  0x8F, 0xF7, 0x00, 0x5F, 0x70, 0x01, 0xF7, 0x00, 0x1F, 0x70, 0x01, 0xF7, 0x00, 0x1F, 0x70, 0x01,
  0xFA, 0xB0, 0x2F, 0xB1, 0x3C, 0xF7, 0x03, 0x2F, 0x70, 0x01, 0xF7, 0x00, 0x2F, 0x70, 0x05, 0xFA,
  0x08, 0xFF, 0xFD,
  // "Ń" (U+0143)
  0x68, 0x11, 0xFA, 0x72, 0x08, 0x0C, 0x72, 0x81, 0x2C, 0x17, 0x72, 0x06, 0xA0, 0xC3, 0x06, 0xB8,
  0x15, 0x02, 0xA0, 0x53, 0x81, 0x3F, 0x23, 0x90, 0xE0, 0xD4, 0x0E, 0x49, 0x81, 0x7F, 0x63, 0x0E,
  0x49, 0x10, 0xD0, 0xE3, 0x0E, 0x49, 0x18, 0x15, 0xF7, 0x20, 0xE4, 0x92, 0x83, 0xCE, 0x10, 0xE4,
  0x92, 0x83, 0x4F, 0x80, 0xE4, 0x93, 0x82, 0xBF, 0x2E, 0x49, 0x38, 0x22, 0xFA, 0xE4, 0x94, 0x81,
  0x9F, 0xE3, 0x81, 0x3F, 0x23, 0x81, 0x1E, 0xE2, 0x06, 0xB0, 0x63, 0x08, 0x0E, 0x20,
  // "ń" (U+0144)
  0x48, 0x11, 0xFA, 0x70, 0x80, 0xC7, 0x81, 0x2C, 0x17, 0x70, 0x7A, 0x83, 0x3A, 0xED, 0x43, 0x85,
  0x6F, 0xC2, 0x0B, 0xE3, 0x81, 0x3F, 0x82, 0x81, 0x5F, 0x32, 0x81, 0x3F, 0x62, 0x81, 0x4F, 0x42,
  0x81, 0x3F, 0x52, 0x81, 0x4F, 0x52, 0x81, 0x3F, 0x52, 0x81, 0x4F, 0x52, 0x81, 0x3F, 0x52, 0x81,
  0x4F, 0x52, 0x81, 0x3F, 0x52, 0x81, 0x4F, 0x52, 0x81, 0x6F, 0x82, 0x83, 0x4F, 0x70, 0x9B, 0x81,
  0x90, 0x4A, 0x08,
  // "Ņ" (U+0145)
  0x06, 0xA0, 0xC3, 0x06, 0xB8, 0x15, 0x02, 0xA0, 0x53, 0x81, 0x3F, 0x23, 0x90, 0xE0, 0xD4, 0x0E,
  0x49, 0x81, 0x7F, 0x63, 0x0E, 0x49, 0x10, 0xD0, 0xE3, 0x0E, 0x49, 0x18, 0x15, 0xF7, 0x20, 0xE4,
  0x92, 0x83, 0xCE, 0x10, 0xE4, 0x92, 0x83, 0x4F, 0x80, 0xE4, 0x93, 0x82, 0xBF, 0x2E, 0x49, 0x38,
  0x22, 0xFA, 0xE4, 0x94, 0x81, 0x9F, 0xE3, 0x81, 0x3F, 0x23, 0x81, 0x1E, 0xE2, 0x06, 0xB0, 0x63,
  0x08, 0x0E, 0x77, 0x50, 0x80, 0xC7, 0x30, 0xB0, 0x67, 0x30, 0xC6,
  // "ņ" (U+0146)
  0x07, 0xA8, 0x33, 0xAE, 0xD4, 0x38, 0x56, 0xFC, 0x20, 0xBE, 0x38, 0x13, 0xF8, 0x28, 0x15, 0xF3,
  0x28, 0x13, 0xF6, 0x28, 0x14, 0xF4, 0x28, 0x13, 0xF5, 0x28, 0x14, 0xF5, 0x28, 0x13, 0xF5, 0x28,
  0x14, 0xF5, 0x28, 0x13, 0xF5, 0x28, 0x14, 0xF5, 0x28, 0x13, 0xF5, 0x28, 0x14, 0xF5, 0x28, 0x16,
  0xF8, 0x28, 0x34, 0xF7, 0x09, 0xB8, 0x19, 0x04, 0xA0, 0x87, 0x70, 0x80, 0xC7, 0x10, 0xB0, 0x67,
  0x10, 0xC5,
  // "Ň" (U+0147)
  0x38, 0x42, 0xC1, 0x0B, 0x37, 0x82, 0x7B, 0x9A, 0x72, 0x81, 0xEF, 0x17, 0x72, 0x06, 0xA0, 0xC3,
  0x06, 0xB8, 0x15, 0x02, 0xA0, 0x53, 0x81, 0x3F, 0x23, 0x90, 0xE0, 0xD4, 0x0E, 0x49, 0x81, 0x7F,
  0x63, 0x0E, 0x49, 0x10, 0xD0, 0xE3, 0x0E, 0x49, 0x18, 0x15, 0xF7, 0x20, 0xE4, 0x92, 0x83, 0xCE,
  0x10, 0xE4, 0x92, 0x83, 0x4F, 0x80, 0xE4, 0x93, 0x82, 0xBF, 0x2E, 0x49, 0x38, 0x22, 0xFA, 0xE4,
  0x94, 0x81, 0x9F, 0xE3, 0x81, 0x3F, 0x23, 0x81, 0x1E, 0xE2, 0x06, 0xB0, 0x63, 0x08, 0x0E, 0x20,
  // "ň" (U+0148)
  0x00, 0x2C, 0x10, 0xB3, 0x00, 0x00, 0x07, 0xB9, 0xA0, 0x00, 0x00, 0x00, 0xEF, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x7F, 0xF3, 0xAE, 0xD4, 0x00, 0x06, 0xFC, 0x20, 0xBE, 0x00, 0x03, 0xF8,
  0x00, 0x5F, 0x30, 0x03, 0xF6, 0x00, 0x4F, 0x40, 0x03, 0xF5, 0x00, 0x4F, 0x50, 0x03, 0xF5, 0x00,
  0x4F, 0x50, 0x03, 0xF5, 0x00, 0x4F, 0x50, 0x03, 0xF5, 0x00, 0x4F, 0x50, 0x06, 0xF8, 0x00, 0x4F,
  0x70, 0x9F, 0xFF, 0x90, 0x4F, 0xF8,
  // "ŉ" (U+0149)
  0x10, 0xD0, 0xA7, 0x20, 0x10, 0xE9, 0x73, 0x03, 0x0E, 0x73, 0x05, 0xB8, 0x33, 0xAE, 0xD4, 0x28,
  0x90, 0x59, 0x06, 0xFC, 0x20, 0xBE, 0x58, 0x13, 0xF8, 0x28, 0x15, 0xF3, 0x48, 0x13, 0xF6, 0x28,
  0x14, 0xF4, 0x48, 0x13, 0xF5, 0x28, 0x14, 0xF5, 0x48, 0x13, 0xF5, 0x28, 0x14, 0xF5, 0x48, 0x13,
  0xF5, 0x28, 0x14, 0xF5, 0x48, 0x13, 0xF5, 0x28, 0x14, 0xF5, 0x48, 0x16, 0xF8, 0x28, 0x14, 0xF7,
  0x30, 0x9B, 0x81, 0x90, 0x4A, 0x08,
  // "Ŋ" (U+014A)
  0x06, 0xA0, 0xB3, 0x06, 0xB8, 0x15, 0x02, 0xA0, 0x43, 0x81, 0x3F, 0x23, 0x90, 0xE0, 0xC4, 0x0E,
  0x49, 0x81, 0x6F, 0x53, 0x0E, 0x49, 0x10, 0x0D, 0x30, 0xE4, 0x91, 0x81, 0x4F, 0x72, 0x0E, 0x49,
  0x28, 0x3B, 0xE1, 0x0E, 0x49, 0x28, 0x32, 0xF9, 0x0E, 0x49, 0x38, 0x28, 0xF2, 0xE4, 0x93, 0x82,
  0x1E, 0xBE, 0x49, 0x48, 0x16, 0xFE, 0x38, 0x13, 0xF2, 0x40, 0xC0, 0xE2, 0x06, 0xB0, 0x63, 0x04,
  0x0E, 0x74, 0x0E, 0x73, 0x02, 0x0C, 0x73, 0x00, 0x97, 0x28, 0x1D, 0xC1, 0x20,
  // "ŋ" (U+014B)
  0x7F, 0xF3, 0xAE, 0xD4, 0x00, 0x6F, 0xC2, 0x0B, 0xE0, 0x03, 0xF8, 0x00, 0x5F, 0x30, 0x3F, 0x60,
  0x03, 0xF5, 0x03, 0xF6, 0x00, 0x3F, 0x50, 0x3F, 0x60, 0x03, 0xF5, 0x03, 0xF6, 0x00, 0x3F, 0x50,
  0x3F, 0x60, 0x03, 0xF5, 0x06, 0xF8, 0x00, 0x3F, 0x59, 0xFF, 0xF9, 0x03, 0xF5, 0x00, 0x00, 0x00,
  0x4F, 0x40, 0x00, 0x00, 0x06, 0xF2, 0x00, 0x00, 0x00, 0xBC, 0x00, 0x00, 0x00, 0xCC, 0x20,
  // "Ō" (U+014C)
  0x38, 0x44, 0xEE, 0xEE, 0x27, 0x72, 0x84, 0x6C, 0xED, 0xA2, 0x48, 0x1A, 0xE4, 0x28, 0x19, 0xE2,
  0x28, 0x14, 0xF6, 0x40, 0xD0, 0xB2, 0x0B, 0x95, 0x84, 0x8F, 0x30, 0xED, 0x58, 0x45, 0xF7, 0x1F,
  0xB5, 0x84, 0x3F, 0x81, 0xFB, 0x58, 0x43, 0xF9, 0x1F, 0xB5, 0x84, 0x3F, 0x80, 0xED, 0x58, 0x35,
  0xF7, 0x0B, 0x95, 0x85, 0x8F, 0x30, 0x4F, 0x64, 0x0D, 0x0B, 0x38, 0x19, 0xE4, 0x28, 0x19, 0xE2,
  0x48, 0x46, 0xCE, 0xD9, 0x22,
  // "ō" (U+014D)
  0x28, 0x44, 0xEE, 0xEE, 0x27, 0x58, 0x36, 0xDE, 0xD5, 0x38, 0x56, 0xF4, 0x04, 0xF4, 0x20, 0xD0,
  0xB3, 0x84, 0xCC, 0x01, 0xF8, 0x38, 0x49, 0xF0, 0x2F, 0x73, 0x84, 0x8F, 0x12, 0xF7, 0x38, 0x48,
  0xF1, 0x0F, 0x83, 0x09, 0x92, 0x00, 0xC3, 0x00, 0xC2, 0x85, 0x5F, 0x40, 0x4F, 0x53, 0x83, 0x6D,
  0xED, 0x62,
  // "Ŏ" (U+014E)
  0x30, 0x10, 0x42, 0x05, 0x68, 0x31, 0xC1, 0x2D, 0x78, 0x26, 0xDD, 0x47, 0x73, 0x84, 0x6C, 0xED,
  0xA2, 0x48, 0x1A, 0xE4, 0x28, 0x19, 0xE2, 0x28, 0x14, 0xF6, 0x40, 0xD0, 0xB2, 0x0B, 0x95, 0x84,
  0x8F, 0x30, 0xED, 0x58, 0x45, 0xF7, 0x1F, 0xB5, 0x84, 0x3F, 0x81, 0xFB, 0x58, 0x43, 0xF9, 0x1F,
  0xB5, 0x84, 0x3F, 0x80, 0xED, 0x58, 0x35, 0xF7, 0x0B, 0x95, 0x85, 0x8F, 0x30, 0x4F, 0x64, 0x0D,
  0x0B, 0x38, 0x19, 0xE4, 0x28, 0x19, 0xE2, 0x48, 0x46, 0xCE, 0xD9, 0x22,
  // "ŏ" (U+014F)
  0x20, 0x10, 0x42, 0x05, 0x48, 0x31, 0xC1, 0x2D, 0x58, 0x26, 0xDD, 0x47, 0x68, 0x36, 0xDE, 0xD5,
  0x38, 0x56, 0xF4, 0x04, 0xF4, 0x20, 0xD0, 0xB3, 0x84, 0xCC, 0x01, 0xF8, 0x38, 0x49, 0xF0, 0x2F,
  0x73, 0x84, 0x8F, 0x12, 0xF7, 0x38, 0x48, 0xF1, 0x0F, 0x83, 0x09, 0x92, 0x00, 0xC3, 0x00, 0xC2,
  0x85, 0x5F, 0x40, 0x4F, 0x53, 0x83, 0x6D, 0xED, 0x62,
  // "Ő" (U+0150)
  0x48, 0x42, 0xE5, 0x5E, 0x25, 0x83, 0xAA, 0x0D, 0x75, 0x83, 0x2C, 0x05, 0xA7, 0x73, 0x84, 0x6C,
  0xED, 0xA2, 0x48, 0x1A, 0xE4, 0x28, 0x19, 0xE2, 0x28, 0x14, 0xF6, 0x40, 0xD0, 0xB2, 0x0B, 0x95,
  0x84, 0x8F, 0x30, 0xED, 0x58, 0x45, 0xF7, 0x1F, 0xB5, 0x84, 0x3F, 0x81, 0xFB, 0x58, 0x43, 0xF9,
  0x1F, 0xB5, 0x84, 0x3F, 0x80, 0xED, 0x58, 0x35, 0xF7, 0x0B, 0x95, 0x85, 0x8F, 0x30, 0x4F, 0x64,
  0x0D, 0x0B, 0x38, 0x19, 0xE4, 0x28, 0x19, 0xE2, 0x48, 0x46, 0xCE, 0xD9, 0x22,
  // "ő" (U+0151)
  0x28, 0x42, 0xE5, 0x5E, 0x23, 0x83, 0xAA, 0x0D, 0x73, 0x83, 0x2C, 0x05, 0xA7, 0x78, 0x36, 0xDE,
  0xD5, 0x38, 0x56, 0xF4, 0x04, 0xF4, 0x20, 0xD0, 0xB3, 0x84, 0xCC, 0x01, 0xF8, 0x38, 0x49, 0xF0,
  0x2F, 0x73, 0x84, 0x8F, 0x12, 0xF7, 0x38, 0x48, 0xF1, 0x0F, 0x83, 0x09, 0x92, 0x00, 0xC3, 0x00,
  0xC2, 0x85, 0x5F, 0x40, 0x4F, 0x53, 0x83, 0x6D, 0xED, 0x62,
  // "Œ" (U+0152)
  0x38, 0x16, 0xCE, 0xF0, 0xA3, 0x85, 0xAE, 0x61, 0x1C, 0xE2, 0x81, 0x18, 0xB2, 0x81, 0x4F, 0x73,
  0x0B, 0x0E, 0x30, 0x20, 0xA2, 0x81, 0xBF, 0x13, 0x0B, 0x0E, 0x70, 0xE0, 0xD4, 0x0B, 0x0E, 0x68,
  0x11, 0xFB, 0x48, 0x4B, 0xFD, 0xDD, 0x82, 0x81, 0x1F, 0xB4, 0x0B, 0x0E, 0x68, 0x11, 0xFB, 0x40,
  0xB0, 0xE7, 0x0E, 0x0D, 0x40, 0xB0, 0xE7, 0x0B, 0x94, 0x0B, 0x0E, 0x48, 0x44, 0x10, 0x4F, 0x53,
  0x0B, 0x0E, 0x40, 0xB0, 0x32, 0x81, 0x9E, 0x32, 0x0B, 0x0E, 0x38, 0x11, 0xE3, 0x38, 0x26, 0xCD,
  0xEA, 0x0F, 0xDA, 0x03,
  // "œ" (U+0153)
  0x00, 0x6D, 0xEC, 0x50, 0x9E, 0xE9, 0x00, 0x06, 0xF4, 0x05, 0xFB, 0xD1, 0x1E, 0x90, 0x0D, 0xB0,
  0x00, 0xCF, 0x60, 0x08, 0xF0, 0x1F, 0x80, 0x00, 0x9F, 0x30, 0x06, 0xF2, 0x2F, 0x70, 0x00, 0x8F,
  0xEE, 0xEE, 0xF3, 0x2F, 0x70, 0x00, 0x8F, 0x20, 0x00, 0x00, 0x0F, 0x80, 0x00, 0x9F, 0x40, 0x00,
  0x00, 0x0C, 0xC0, 0x00, 0xCF, 0x70, 0x00, 0x10, 0x05, 0xF4, 0x05, 0xFB, 0xE3, 0x03, 0xB0, 0x00,
  0x6D, 0xED, 0x50, 0x8E, 0xEB, 0x20,
  // "Ŕ" (U+0154)
  0x48, 0x11, 0xFA, 0x71, 0x08, 0x0C, 0x71, 0x81, 0x2C, 0x17, 0x72, 0x06, 0xB8, 0x2E, 0xEC, 0x64,
  0x81, 0x3F, 0xB2, 0x81, 0x9F, 0x64, 0x90, 0xB3, 0x90, 0xB4, 0x90, 0xB3, 0x0E, 0x0D, 0x49, 0x0B,
  0x28, 0x11, 0xFA, 0x49, 0x84, 0xB0, 0x1A, 0xE2, 0x4A, 0x82, 0xEF, 0xC1, 0x59, 0x83, 0xB0, 0xBF,
  0x15, 0x98, 0x3B, 0x04, 0xF9, 0x59, 0x0B, 0x28, 0x1C, 0xF2, 0x49, 0x0B, 0x28, 0x15, 0xFA, 0x38,
  0x12, 0xFD, 0x38, 0x3C, 0xF4, 0x06, 0xC8, 0x41, 0x02, 0xBF, 0x40,
  // "ŕ" (U+0155)
  0x38, 0x11, 0xFA, 0x50, 0x80, 0xC5, 0x81, 0x2C, 0x17, 0x40, 0x7A, 0x82, 0x19, 0xEB, 0x28, 0x94,
  0x6F, 0xA2, 0x7F, 0x10, 0x3F, 0xA0, 0x22, 0x28, 0x13, 0xF7, 0x58, 0x13, 0xF6, 0x58, 0x13, 0xF6,
  0x58, 0x13, 0xF6, 0x58, 0x13, 0xF6, 0x58, 0x16, 0xF8, 0x40, 0x8B, 0x0E, 0x30,
  // "Ŗ" (U+0156)
  0x06, 0xB8, 0x2E, 0xEC, 0x64, 0x81, 0x3F, 0xB2, 0x81, 0x9F, 0x64, 0x90, 0xB3, 0x90, 0xB4, 0x90,
  0xB3, 0x0E, 0x0D, 0x49, 0x0B, 0x28, 0x11, 0xFA, 0x49, 0x84, 0xB0, 0x1A, 0xE2, 0x4A, 0x82, 0xEF,
  0xC1, 0x59, 0x83, 0xB0, 0xBF, 0x15, 0x98, 0x3B, 0x04, 0xF9, 0x59, 0x0B, 0x28, 0x1C, 0xF2, 0x49,
  0x0B, 0x28, 0x15, 0xFA, 0x38, 0x12, 0xFD, 0x38, 0x3C, 0xF4, 0x06, 0xC8, 0x41, 0x02, 0xBF, 0x47,
  0x71, 0x08, 0x0C, 0x72, 0x0B, 0x06, 0x72, 0x0C, 0x60,
  // "ŗ" (U+0157)
  0x07, 0xA8, 0x21, 0x9E, 0xB2, 0x89, 0x46, 0xFA, 0x27, 0xF1, 0x03, 0xFA, 0x02, 0x22, 0x81, 0x3F,
  0x75, 0x81, 0x3F, 0x65, 0x81, 0x3F, 0x65, 0x81, 0x3F, 0x65, 0x81, 0x3F, 0x65, 0x81, 0x6F, 0x84,
  0x08, 0xB0, 0xE7, 0x50, 0x80, 0xC6, 0x0B, 0x06, 0x60, 0xC6,
  // "Ř" (U+0158)
  0x28, 0x42, 0xC1, 0x0B, 0x36, 0x82, 0x7B, 0x9A, 0x71, 0x81, 0xEF, 0x17, 0x71, 0x06, 0xB8, 0x2E,
  0xEC, 0x64, 0x81, 0x3F, 0xB2, 0x81, 0x9F, 0x64, 0x90, 0xB3, 0x90, 0xB4, 0x90, 0xB3, 0x0E, 0x0D,
  0x49, 0x0B, 0x28, 0x11, 0xFA, 0x49, 0x84, 0xB0, 0x1A, 0xE2, 0x4A, 0x82, 0xEF, 0xC1, 0x59, 0x83,
  0xB0, 0xBF, 0x15, 0x98, 0x3B, 0x04, 0xF9, 0x59, 0x0B, 0x28, 0x1C, 0xF2, 0x49, 0x0B, 0x28, 0x15,
  0xFA, 0x38, 0x12, 0xFD, 0x38, 0x3C, 0xF4, 0x06, 0xC8, 0x41, 0x02, 0xBF, 0x40,
  // "ř" (U+0159)
  0x18, 0x42, 0xC1, 0x0B, 0x33, 0x82, 0x7B, 0x9A, 0x58, 0x1E, 0xF1, 0x73, 0x07, 0xA8, 0x21, 0x9E,
  0xB2, 0x89, 0x46, 0xFA, 0x27, 0xF1, 0x03, 0xFA, 0x02, 0x22, 0x81, 0x3F, 0x75, 0x81, 0x3F, 0x65,
  0x81, 0x3F, 0x65, 0x81, 0x3F, 0x65, 0x81, 0x3F, 0x65, 0x81, 0x6F, 0x84, 0x08, 0xB0, 0xE3,
  // "Ś" (U+015A)
  0x48, 0x11, 0xFA, 0x50, 0x80, 0xC5, 0x81, 0x2C, 0x17, 0x58, 0x37, 0xDE, 0xD5, 0x28, 0x90, 0x8D,
  0x20, 0x8F, 0x30, 0xE8, 0x28, 0x41, 0xF3, 0x0E, 0x83, 0x01, 0x28, 0x1B, 0xD1, 0x58, 0x23, 0xFE,
  0x55, 0x83, 0x3C, 0xFC, 0x25, 0x82, 0x6E, 0xE1, 0x58, 0x33, 0xF8, 0x08, 0x48, 0x3C, 0xA3, 0xF2,
  0x38, 0x97, 0xD9, 0x1E, 0xB1, 0x06, 0xF2, 0x03, 0xBE, 0xEB, 0x31,
  // "ś" (U+015B)
  0x38, 0x11, 0xFA, 0x40, 0x80, 0xC4, 0x81, 0x2C, 0x17, 0x38, 0x33, 0xCE, 0xD5, 0x28, 0x7E, 0x60,
  0x6F, 0x01, 0xF2, 0x20, 0x92, 0x0E, 0x0A, 0x58, 0x25, 0xEE, 0x64, 0x82, 0x19, 0xFA, 0x58, 0x35,
  0xF3, 0x3B, 0x39, 0x89, 0x44, 0x4F, 0x30, 0x6E, 0x10, 0x8E, 0xEC, 0x41,
  // "Ŝ" (U+015C)
  0x38, 0x1E, 0xF1, 0x48, 0x27, 0xB9, 0x93, 0x84, 0x1C, 0x10, 0xB3, 0x74, 0x83, 0x7D, 0xED, 0x52,
  0x89, 0x08, 0xD2, 0x08, 0xF3, 0x0E, 0x82, 0x84, 0x1F, 0x30, 0xE8, 0x30, 0x12, 0x81, 0xBD, 0x15,
  0x82, 0x3F, 0xE5, 0x58, 0x33, 0xCF, 0xC2, 0x58, 0x26, 0xEE, 0x15, 0x83, 0x3F, 0x80, 0x84, 0x83,
  0xCA, 0x3F, 0x23, 0x89, 0x7D, 0x91, 0xEB, 0x10, 0x6F, 0x20, 0x3B, 0xEE, 0xB3, 0x10,
  // "ŝ" (U+015D)
  0x38, 0x1E, 0xF1, 0x38, 0x27, 0xB9, 0x92, 0x84, 0x1C, 0x10, 0xB3, 0x71, 0x83, 0x3C, 0xED, 0x52,
  0x87, 0xE6, 0x06, 0xF0, 0x1F, 0x22, 0x09, 0x20, 0xE0, 0xA5, 0x82, 0x5E, 0xE6, 0x48, 0x21, 0x9F,
  0xA5, 0x83, 0x5F, 0x33, 0xB3, 0x98, 0x94, 0x44, 0xF3, 0x06, 0xE1, 0x08, 0xEE, 0xC4, 0x10,
  // "Ş" (U+015E)
  0x28, 0x37, 0xDE, 0xD5, 0x28, 0x90, 0x8D, 0x20, 0x8F, 0x30, 0xE8, 0x28, 0x41, 0xF3, 0x0E, 0x83,
  0x01, 0x28, 0x1B, 0xD1, 0x58, 0x23, 0xFE, 0x55, 0x83, 0x3C, 0xFC, 0x25, 0x82, 0x6E, 0xE1, 0x58,
  0x33, 0xF8, 0x08, 0x48, 0x3C, 0xA3, 0xF2, 0x38, 0x97, 0xD9, 0x1E, 0xB1, 0x06, 0xF2, 0x03, 0xBE,
  0xFB, 0x34, 0x81, 0x2D, 0x56, 0x05, 0x96, 0x03, 0x94, 0x82, 0x1D, 0xD6, 0x20,
  // "ş" (U+015F)
  0x18, 0x33, 0xCE, 0xD5, 0x28, 0x7E, 0x60, 0x6F, 0x01, 0xF2, 0x20, 0x92, 0x0E, 0x0A, 0x58, 0x25,
  0xEE, 0x64, 0x82, 0x19, 0xFA, 0x58, 0x35, 0xF3, 0x3B, 0x39, 0x89, 0x44, 0x4F, 0x30, 0x6E, 0x10,
  0x8E, 0xFC, 0x43, 0x81, 0x2D, 0x55, 0x05, 0x95, 0x03, 0x93, 0x82, 0x1D, 0xD6, 0x20,
  // "Š" (U+0160)
  0x18, 0x42, 0xC1, 0x0B, 0x33, 0x82, 0x7B, 0x9A, 0x58, 0x1E, 0xF1, 0x75, 0x83, 0x7D, 0xED, 0x52,
  0x89, 0x08, 0xD2, 0x08, 0xF3, 0x0E, 0x82, 0x84, 0x1F, 0x30, 0xE8, 0x30, 0x12, 0x81, 0xBD, 0x15,
  0x82, 0x3F, 0xE5, 0x58, 0x33, 0xCF, 0xC2, 0x58, 0x26, 0xEE, 0x15, 0x83, 0x3F, 0x80, 0x84, 0x83,
  0xCA, 0x3F, 0x23, 0x89, 0x7D, 0x91, 0xEB, 0x10, 0x6F, 0x20, 0x3B, 0xEE, 0xB3, 0x10,
  // "š" (U+0161)
  0x84, 0x2C, 0x10, 0xB3, 0x28, 0x27, 0xB9, 0xA4, 0x81, 0xEF, 0x17, 0x38, 0x33, 0xCE, 0xD5, 0x28,
  0x7E, 0x60, 0x6F, 0x01, 0xF2, 0x20, 0x92, 0x0E, 0x0A, 0x58, 0x25, 0xEE, 0x64, 0x82, 0x19, 0xFA,
  0x58, 0x35, 0xF3, 0x3B, 0x39, 0x89, 0x44, 0x4F, 0x30, 0x6E, 0x10, 0x8E, 0xEC, 0x41,
  // "Ţ" (U+0162)
  0x82, 0xAF, 0xEE, 0xA0, 0xEA, 0x89, 0x72, 0xA8, 0x01, 0xF9, 0x01, 0xE3, 0xA3, 0x01, 0xF9, 0x28,
  0x1A, 0x31, 0x28, 0x11, 0xF9, 0x20, 0x14, 0x81, 0x1F, 0x97, 0x81, 0x1F, 0x97, 0x81, 0x1F, 0x97,
  0x81, 0x1F, 0x97, 0x81, 0x1F, 0x97, 0x81, 0x1F, 0x97, 0x81, 0x1F, 0x97, 0x81, 0x4F, 0xC6, 0x0A,
  0xC0, 0x36, 0x81, 0xAA, 0x17, 0x10, 0xC0, 0x87, 0x10, 0xC0, 0x86, 0x82, 0x8E, 0xC1, 0x30,
  // "ţ" (U+0163)
  0x00, 0xD1, 0x00, 0x05, 0xF1, 0x00, 0x8E, 0xFE, 0xE1, 0x08, 0xF1, 0x00, 0x08, 0xF1, 0x00, 0x08,
  0xF1, 0x00, 0x08, 0xF1, 0x00, 0x08, 0xF1, 0x00, 0x08, 0xF1, 0x00, 0x07, 0xF1, 0x00, 0x05, 0xF5,
  0x00, 0x00, 0xEF, 0xD2, 0x00, 0xAA, 0x10, 0x00, 0x0C, 0x80, 0x00, 0x0C, 0x80, 0x08, 0xEC, 0x10,
  // "Ť" (U+0164)
  0x28, 0x42, 0xC1, 0x0B, 0x35, 0x82, 0x7B, 0x9A, 0x78, 0x1E, 0xF1, 0x76, 0x82, 0xAF, 0xEE, 0xA0,
  0xEA, 0x89, 0x72, 0xA8, 0x01, 0xF9, 0x01, 0xE3, 0xA3, 0x01, 0xF9, 0x28, 0x1A, 0x31, 0x28, 0x11,
  0xF9, 0x20, 0x14, 0x81, 0x1F, 0x97, 0x81, 0x1F, 0x97, 0x81, 0x1F, 0x97, 0x81, 0x1F, 0x97, 0x81,
  0x1F, 0x97, 0x81, 0x1F, 0x97, 0x81, 0x1F, 0x97, 0x81, 0x4F, 0xC6, 0x0A, 0xC0, 0x32,
  // "ť" (U+0165)
  0x00, 0x00, 0x7D, 0x00, 0x10, 0xA7, 0x00, 0xE1, 0xA0, 0x06, 0xF1, 0x00, 0x8F, 0xFE, 0xE1, 0x08,
  0xF1, 0x00, 0x08, 0xF1, 0x00, 0x08, 0xF1, 0x00, 0x08, 0xF1, 0x00, 0x08, 0xF1, 0x00, 0x08, 0xF1,
  0x00, 0x07, 0xF1, 0x00, 0x05, 0xF5, 0x00, 0x00, 0xAE, 0xD2,
  // "Ŧ" (U+0166)
  0x82, 0xAF, 0xEE, 0xA0, 0xEA, 0x89, 0x72, 0xA8, 0x01, 0xF9, 0x01, 0xE3, 0xA3, 0x01, 0xF9, 0x28,
  0x1A, 0x31, 0x28, 0x11, 0xF9, 0x20, 0x14, 0x81, 0x1F, 0x97, 0x81, 0x1F, 0x95, 0x81, 0x6E, 0xEA,
  0x0E, 0x0D, 0x58, 0x11, 0xF9, 0x78, 0x11, 0xF9, 0x78, 0x11, 0xF9, 0x78, 0x11, 0xF9, 0x78, 0x14,
  0xFB, 0x60, 0xAC, 0x02, 0x20,
  // "ŧ" (U+0167)
  0x00, 0xD1, 0x00, 0x05, 0xF1, 0x00, 0x8E, 0xFE, 0xE1, 0x08, 0xF1, 0x00, 0x08, 0xF1, 0x00, 0x08,
  0xF1, 0x00, 0x8F, 0xFE, 0xB0, 0x08, 0xF1, 0x00, 0x08, 0xF1, 0x00, 0x07, 0xF1, 0x00, 0x05, 0xF4,
  0x00, 0x00, 0xBE, 0xD2,
  // "Ũ" (U+0168)
  0x38, 0x49, 0xE9, 0x17, 0x24, 0x84, 0x27, 0x19, 0xEA, 0x77, 0x0B, 0xB0, 0xC2, 0xB8, 0x3D, 0x07,
  0xF9, 0x40, 0xB0, 0x92, 0x81, 0x4F, 0x64, 0x09, 0x06, 0x28, 0x14, 0xF6, 0x40, 0x90, 0x62, 0x81,
  0x4F, 0x64, 0x09, 0x06, 0x28, 0x14, 0xF6, 0x40, 0x90, 0x62, 0x81, 0x4F, 0x64, 0x09, 0x06, 0x28,
  0x14, 0xF6, 0x40, 0x90, 0x62, 0x81, 0x4F, 0x64, 0x09, 0x06, 0x28, 0x14, 0xF6, 0x40, 0x90, 0x52,
  0x81, 0x2F, 0x94, 0x0C, 0x02, 0x38, 0x1B, 0xF5, 0x20, 0x80, 0xB5, 0x84, 0x7D, 0xEE, 0x91, 0x20,
  // "ũ" (U+0169)
  0x00, 0x9E, 0x91, 0x72, 0x00, 0x02, 0x71, 0x9E, 0xA0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xAF,
  0xF3, 0x0A, 0xFF, 0x20, 0x09, 0xF3, 0x00, 0x9F, 0x20, 0x06, 0xF3, 0x00, 0x6F, 0x20, 0x06, 0xF3,
  0x00, 0x6F, 0x20, 0x06, 0xF3, 0x00, 0x6F, 0x20, 0x06, 0xF3, 0x00, 0x6F, 0x20, 0x05, 0xF3, 0x00,
  0x6F, 0x20, 0x04, 0xF4, 0x00, 0x9F, 0x20, 0x01, 0xFA, 0x03, 0xCF, 0x60, 0x00, 0x5D, 0xEA, 0x3F,
  0xF7,
  // "Ū" (U+016A)
  0x38, 0x44, 0xEE, 0xEE, 0x27, 0x60, 0xBB, 0x0C, 0x2B, 0x83, 0xD0, 0x7F, 0x94, 0x0B, 0x09, 0x28,
  0x14, 0xF6, 0x40, 0x90, 0x62, 0x81, 0x4F, 0x64, 0x09, 0x06, 0x28, 0x14, 0xF6, 0x40, 0x90, 0x62,
  0x81, 0x4F, 0x64, 0x09, 0x06, 0x28, 0x14, 0xF6, 0x40, 0x90, 0x62, 0x81, 0x4F, 0x64, 0x09, 0x06,
  0x28, 0x14, 0xF6, 0x40, 0x90, 0x62, 0x81, 0x4F, 0x64, 0x09, 0x05, 0x28, 0x12, 0xF9, 0x40, 0xC0,
  0x23, 0x81, 0xBF, 0x52, 0x08, 0x0B, 0x58, 0x47, 0xDE, 0xE9, 0x12,
  // "ū" (U+016B)
  0x00, 0x4E, 0xEE, 0xE2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xAF, 0xF3, 0x0A, 0xFF, 0x20, 0x09,
  0xF3, 0x00, 0x9F, 0x20, 0x06, 0xF3, 0x00, 0x6F, 0x20, 0x06, 0xF3, 0x00, 0x6F, 0x20, 0x06, 0xF3,
  0x00, 0x6F, 0x20, 0x06, 0xF3, 0x00, 0x6F, 0x20, 0x05, 0xF3, 0x00, 0x6F, 0x20, 0x04, 0xF4, 0x00,
  0x9F, 0x20, 0x01, 0xFA, 0x03, 0xCF, 0x60, 0x00, 0x5D, 0xEA, 0x3F, 0xF7,
  // "Ŭ" (U+016C)
  0x30, 0x10, 0x42, 0x05, 0x68, 0x31, 0xC1, 0x2D, 0x78, 0x26, 0xDD, 0x47, 0x70, 0xBB, 0x0C, 0x2B,
  0x83, 0xD0, 0x7F, 0x94, 0x0B, 0x09, 0x28, 0x14, 0xF6, 0x40, 0x90, 0x62, 0x81, 0x4F, 0x64, 0x09,
  0x06, 0x28, 0x14, 0xF6, 0x40, 0x90, 0x62, 0x81, 0x4F, 0x64, 0x09, 0x06, 0x28, 0x14, 0xF6, 0x40,
  0x90, 0x62, 0x81, 0x4F, 0x64, 0x09, 0x06, 0x28, 0x14, 0xF6, 0x40, 0x90, 0x62, 0x81, 0x4F, 0x64,
  0x09, 0x05, 0x28, 0x12, 0xF9, 0x40, 0xC0, 0x23, 0x81, 0xBF, 0x52, 0x08, 0x0B, 0x58, 0x47, 0xDE,
  0xE9, 0x12,
  // "ŭ" (U+016D)
  0x00, 0x14, 0x00, 0x50, 0x00, 0x00, 0x1C, 0x12, 0xD0, 0x00, 0x00, 0x06, 0xDD, 0x40, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xAF, 0xF3, 0x0A, 0xFF, 0x20, 0x09, 0xF3, 0x00, 0x9F, 0x20, 0x06, 0xF3,
  0x00, 0x6F, 0x20, 0x06, 0xF3, 0x00, 0x6F, 0x20, 0x06, 0xF3, 0x00, 0x6F, 0x20, 0x06, 0xF3, 0x00,
  0x6F, 0x20, 0x05, 0xF3, 0x00, 0x6F, 0x20, 0x04, 0xF4, 0x00, 0x9F, 0x20, 0x01, 0xFA, 0x03, 0xCF,
  0x60, 0x00, 0x5D, 0xEA, 0x3F, 0xF7,
  // "Ů" (U+016E)
  0x48, 0x19, 0xEA, 0x78, 0x33, 0xA0, 0x94, 0x68, 0x33, 0xA0, 0x94, 0x78, 0x19, 0xEA, 0x77, 0x10,
  0xBB, 0x0C, 0x2B, 0x83, 0xD0, 0x7F, 0x94, 0x0B, 0x09, 0x28, 0x14, 0xF6, 0x40, 0x90, 0x62, 0x81,
  0x4F, 0x64, 0x09, 0x06, 0x28, 0x14, 0xF6, 0x40, 0x90, 0x62, 0x81, 0x4F, 0x64, 0x09, 0x06, 0x28,
  0x14, 0xF6, 0x40, 0x90, 0x62, 0x81, 0x4F, 0x64, 0x09, 0x06, 0x28, 0x14, 0xF6, 0x40, 0x90, 0x62,
  0x81, 0x4F, 0x64, 0x09, 0x05, 0x28, 0x12, 0xF9, 0x40, 0xC0, 0x23, 0x81, 0xBF, 0x52, 0x08, 0x0B,
  0x58, 0x47, 0xDE, 0xE9, 0x12,
  // "ů" (U+016F)
  0x38, 0x19, 0xEA, 0x68, 0x33, 0xA0, 0x94, 0x58, 0x33, 0xA0, 0x94, 0x68, 0x19, 0xEA, 0x77, 0x0A,
  0xA8, 0x13, 0x0A, 0xA0, 0x22, 0x81, 0x9F, 0x32, 0x81, 0x9F, 0x22, 0x81, 0x6F, 0x32, 0x81, 0x6F,
  0x22, 0x81, 0x6F, 0x32, 0x81, 0x6F, 0x22, 0x81, 0x6F, 0x32, 0x81, 0x6F, 0x22, 0x81, 0x6F, 0x32,
  0x81, 0x6F, 0x22, 0x81, 0x5F, 0x32, 0x81, 0x6F, 0x22, 0x81, 0x4F, 0x42, 0x81, 0x9F, 0x22, 0x86,
  0x1F, 0xA0, 0x3C, 0xF6, 0x38, 0x35, 0xDE, 0xA3, 0xA0, 0x70,
  // "Ű" (U+0170)
  0x48, 0x42, 0xE5, 0x5E, 0x25, 0x83, 0xAA, 0x0D, 0x75, 0x83, 0x2C, 0x05, 0xA7, 0x70, 0xBB, 0x0C,
  0x2B, 0x83, 0xD0, 0x7F, 0x94, 0x0B, 0x09, 0x28, 0x14, 0xF6, 0x40, 0x90, 0x62, 0x81, 0x4F, 0x64,
  0x09, 0x06, 0x28, 0x14, 0xF6, 0x40, 0x90, 0x62, 0x81, 0x4F, 0x64, 0x09, 0x06, 0x28, 0x14, 0xF6,
  0x40, 0x90, 0x62, 0x81, 0x4F, 0x64, 0x09, 0x06, 0x28, 0x14, 0xF6, 0x40, 0x90, 0x62, 0x81, 0x4F,
  0x64, 0x09, 0x05, 0x28, 0x12, 0xF9, 0x40, 0xC0, 0x23, 0x81, 0xBF, 0x52, 0x08, 0x0B, 0x58, 0x47,
  0xDE, 0xE9, 0x12,
  // "ű" (U+0171)
  0x00, 0x02, 0xE5, 0x5E, 0x20, 0x00, 0x0A, 0xA0, 0xD7, 0x00, 0x00, 0x2C, 0x05, 0xA0, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xAF, 0xF3, 0x0A, 0xFF, 0x20, 0x09, 0xF3, 0x00, 0x9F, 0x20, 0x06, 0xF3,
  0x00, 0x6F, 0x20, 0x06, 0xF3, 0x00, 0x6F, 0x20, 0x06, 0xF3, 0x00, 0x6F, 0x20, 0x06, 0xF3, 0x00,
  0x6F, 0x20, 0x05, 0xF3, 0x00, 0x6F, 0x20, 0x04, 0xF4, 0x00, 0x9F, 0x20, 0x01, 0xFA, 0x03, 0xCF,
  0x60, 0x00, 0x5D, 0xEA, 0x3F, 0xF7,
  // "Ų" (U+0172)
  0x0B, 0xB0, 0xC2, 0xB8, 0x3D, 0x07, 0xF9, 0x40, 0xB0, 0x92, 0x81, 0x4F, 0x64, 0x09, 0x06, 0x28,
  0x14, 0xF6, 0x40, 0x90, 0x62, 0x81, 0x4F, 0x64, 0x09, 0x06, 0x28, 0x14, 0xF6, 0x40, 0x90, 0x62,
  0x81, 0x4F, 0x64, 0x09, 0x06, 0x28, 0x14, 0xF6, 0x40, 0x90, 0x62, 0x81, 0x4F, 0x64, 0x09, 0x06,
  0x28, 0x14, 0xF6, 0x40, 0x90, 0x52, 0x81, 0x2F, 0x94, 0x0C, 0x02, 0x38, 0x1B, 0xF5, 0x20, 0x80,
  0xB5, 0x07, 0x0D, 0xA0, 0x90, 0x16, 0x81, 0x1D, 0x17, 0x10, 0x80, 0xA7, 0x20, 0x90, 0xC7, 0x28,
  0x23, 0xEF, 0xA7, 0x20, 0x14,
  // "ų" (U+0173)
  0xAF, 0xF3, 0x0A, 0xFF, 0x20, 0x09, 0xF3, 0x00, 0x9F, 0x20, 0x06, 0xF3, 0x00, 0x6F, 0x20, 0x06,
  0xF3, 0x00, 0x6F, 0x20, 0x06, 0xF3, 0x00, 0x6F, 0x20, 0x06, 0xF3, 0x00, 0x6F, 0x20, 0x05, 0xF3,
  0x00, 0x6F, 0x20, 0x04, 0xF4, 0x00, 0x9F, 0x20, 0x01, 0xFA, 0x03, 0xCF, 0x60, 0x00, 0x5D, 0xEA,
  0x4F, 0xF7, 0x00, 0x00, 0x00, 0xC4, 0x00, 0x00, 0x00, 0x04, 0xE0, 0x00, 0x00, 0x00, 0x04, 0xF1,
  0x10, 0x00, 0x00, 0x00, 0x9E, 0xB0,
  // "Ŵ" (U+0174)
  0x78, 0x1E, 0xF1, 0x75, 0x82, 0x7B, 0x99, 0x74, 0x84, 0x1C, 0x10, 0xB3, 0x77, 0x70, 0xDB, 0x07,
  0x28, 0x15, 0xF3, 0x20, 0xBB, 0x18, 0x1B, 0xF5, 0x38, 0x18, 0xF6, 0x30, 0x70, 0xD2, 0x81, 0x7F,
  0x53, 0x81, 0xCF, 0x93, 0x00, 0x82, 0x81, 0x3F, 0x83, 0x81, 0xEC, 0xD3, 0x0B, 0x04, 0x30, 0xE0,
  0xC2, 0x83, 0x4B, 0x8F, 0x12, 0x0E, 0x40, 0xB9, 0x28, 0x67, 0x74, 0xF4, 0x03, 0xC4, 0x89, 0x27,
  0xF3, 0x0B, 0x31, 0xF8, 0x07, 0x84, 0x83, 0x3F, 0x70, 0xE2, 0x83, 0xDB, 0x0A, 0x55, 0x98, 0x1A,
  0x3B, 0x28, 0x39, 0xE0, 0xE1, 0x58, 0x2C, 0xD6, 0x82, 0x82, 0x6F, 0x5D, 0x68, 0x28, 0xFB, 0x42,
  0x82, 0x2F, 0xB9, 0x60, 0x4A, 0x48, 0x1E, 0xF5, 0x68, 0x11, 0xFC, 0x48, 0x1A, 0xF2, 0x30,
  // "ŵ" (U+0175)
  0x68, 0x1E, 0xF1, 0x73, 0x82, 0x7B, 0x99, 0x72, 0x84, 0x1C, 0x10, 0xB3, 0x77, 0x4B, 0x0D, 0x20,
  0xB0, 0x72, 0xB8, 0x23, 0x1E, 0xD3, 0x0E, 0x0C, 0x28, 0x12, 0xF3, 0x20, 0xA0, 0xE2, 0x04, 0x0D,
  0x92, 0x01, 0x0D, 0x38, 0x91, 0x6F, 0x20, 0x85, 0xF4, 0x05, 0x93, 0x89, 0x12, 0xF5, 0x0B, 0x0D,
  0x90, 0x85, 0x48, 0x90, 0xE9, 0x1A, 0x09, 0xD0, 0xC1, 0x48, 0x7A, 0xC5, 0x60, 0x5F, 0x2C, 0x58,
  0x76, 0xF9, 0x10, 0x1F, 0x98, 0x58, 0x12, 0xFC, 0x38, 0x1C, 0xE4, 0x60, 0xE0, 0x93, 0x08, 0x94,
  // "Ŷ" (U+0176)
  0x58, 0x1E, 0xF1, 0x78, 0x27, 0xB9, 0x96, 0x84, 0x1C, 0x10, 0xB3, 0x76, 0x01, 0xC8, 0x13, 0x0D,
  0xA8, 0x4C, 0x01, 0xEF, 0x23, 0x0A, 0x0C, 0x38, 0x17, 0xF6, 0x30, 0xB0, 0x44, 0x0E, 0x0D, 0x20,
  0x30, 0xC5, 0x84, 0x6F, 0x50, 0xB4, 0x68, 0x2D, 0xC3, 0xB7, 0x82, 0x6F, 0xC4, 0x71, 0x0E, 0x0D,
  0x72, 0x0E, 0x0C, 0x72, 0x0E, 0x0C, 0x72, 0x0E, 0x0C, 0x71, 0x82, 0x2F, 0xE1, 0x60, 0x7C, 0x05,
  0x20,
  // "ŷ" (U+0177)
  0x38, 0x1E, 0xF1, 0x58, 0x27, 0xB9, 0x94, 0x84, 0x1C, 0x10, 0xB3, 0x74, 0x0E, 0xA8, 0x1D, 0x06,
  0xA8, 0x2B, 0x1E, 0xE3, 0x08, 0x0C, 0x28, 0x19, 0xF1, 0x20, 0x90, 0x62, 0x81, 0x3F, 0x62, 0x0D,
  0x01, 0x38, 0x3D, 0xB0, 0x2C, 0x48, 0x38, 0xF1, 0x67, 0x48, 0x32, 0xF5, 0xB2, 0x58, 0x1C, 0xAC,
  0x68, 0x16, 0xF8, 0x68, 0x11, 0xF3, 0x60, 0x40, 0xD7, 0x0B, 0x08, 0x58, 0x21, 0x9E, 0x14, 0x82,
  0x6E, 0xC3, 0x50,
  // "Ÿ" (U+0178)
  0x48, 0x39, 0x90, 0xB7, 0x68, 0x39, 0xA0, 0xC7, 0x77, 0x73, 0x01, 0xC8, 0x13, 0x0D, 0xA8, 0x4C,
  0x01, 0xEF, 0x23, 0x0A, 0x0C, 0x38, 0x17, 0xF6, 0x30, 0xB0, 0x44, 0x0E, 0x0D, 0x20, 0x30, 0xC5,
  0x84, 0x6F, 0x50, 0xB4, 0x68, 0x2D, 0xC3, 0xB7, 0x82, 0x6F, 0xC4, 0x71, 0x0E, 0x0D, 0x72, 0x0E,
  0x0C, 0x72, 0x0E, 0x0C, 0x72, 0x0E, 0x0C, 0x71, 0x82, 0x2F, 0xE1, 0x60, 0x7C, 0x05, 0x20,
  // "Ź" (U+0179)
  0x48, 0x11, 0xFA, 0x60, 0x80, 0xC6, 0x81, 0x2C, 0x17, 0x50, 0x1A, 0x0F, 0xD8, 0x4E, 0xF5, 0x1F,
  0x13, 0x83, 0xDE, 0x01, 0xC3, 0x81, 0x6F, 0x72, 0x01, 0x30, 0x0E, 0x68, 0x17, 0xF6, 0x60, 0xE0,
  0xD6, 0x81, 0x7F, 0x66, 0x0E, 0x0D, 0x68, 0x17, 0xF6, 0x58, 0x11, 0xED, 0x48, 0x31, 0x08, 0xF5,
  0x38, 0x34, 0x91, 0xED, 0x48, 0x91, 0x99, 0x6F, 0xED, 0xDD, 0xEF, 0x80,
  // "ź" (U+017A)
  0x38, 0x11, 0xFA, 0x50, 0x80, 0xC5, 0x81, 0x2C, 0x17, 0x59, 0x81, 0xED, 0xDA, 0x10, 0x10, 0xD2,
  0x84, 0x3F, 0x90, 0x15, 0x28, 0x1B, 0xE1, 0x48, 0x14, 0xF7, 0x50, 0xC0, 0xE5, 0x81, 0x5F, 0x65,
  0x00, 0xD5, 0x81, 0x7F, 0x52, 0x83, 0xA1, 0x0E, 0xC3, 0x86, 0xE1, 0x5F, 0xED, 0xDE, 0x91,
  // "Ż" (U+017B)
  0x40, 0x17, 0x81, 0x2F, 0x76, 0x81, 0x2E, 0x67, 0x77, 0x01, 0xA0, 0xFD, 0x84, 0xEF, 0x51, 0xF1,
  0x38, 0x3D, 0xE0, 0x1C, 0x38, 0x16, 0xF7, 0x20, 0x13, 0x00, 0xE6, 0x81, 0x7F, 0x66, 0x0E, 0x0D,
  0x68, 0x17, 0xF6, 0x60, 0xE0, 0xD6, 0x81, 0x7F, 0x65, 0x81, 0x1E, 0xD4, 0x83, 0x10, 0x8F, 0x53,
  0x83, 0x49, 0x1E, 0xD4, 0x89, 0x19, 0x96, 0xFE, 0xDD, 0xDE, 0xF8,
  // "ż" (U+017C)
  0x30, 0x16, 0x81, 0x2F, 0x75, 0x81, 0x2E, 0x67, 0x76, 0x98, 0x1E, 0xDD, 0xA1, 0x01, 0x0D, 0x28,
  0x43, 0xF9, 0x01, 0x52, 0x81, 0xBE, 0x14, 0x81, 0x4F, 0x75, 0x0C, 0x0E, 0x58, 0x15, 0xF6, 0x50,
  0x0D, 0x58, 0x17, 0xF5, 0x28, 0x3A, 0x10, 0xEC, 0x38, 0x6E, 0x15, 0xFE, 0xDD, 0xE9, 0x10,
  // "Ž" (U+017D)
  0x28, 0x42, 0xC1, 0x0B, 0x34, 0x82, 0x7B, 0x9A, 0x68, 0x1E, 0xF1, 0x74, 0x01, 0xA0, 0xFD, 0x84,
  0xEF, 0x51, 0xF1, 0x38, 0x3D, 0xE0, 0x1C, 0x38, 0x16, 0xF7, 0x20, 0x13, 0x00, 0xE6, 0x81, 0x7F,
  0x66, 0x0E, 0x0D, 0x68, 0x17, 0xF6, 0x60, 0xE0, 0xD6, 0x81, 0x7F, 0x65, 0x81, 0x1E, 0xD4, 0x83,
  0x10, 0x8F, 0x53, 0x83, 0x49, 0x1E, 0xD4, 0x89, 0x19, 0x96, 0xFE, 0xDD, 0xDE, 0xF8,
  // "ž" (U+017E)
  0x18, 0x42, 0xC1, 0x0B, 0x33, 0x82, 0x7B, 0x9A, 0x58, 0x1E, 0xF1, 0x74, 0x98, 0x1E, 0xDD, 0xA1,
  0x01, 0x0D, 0x28, 0x43, 0xF9, 0x01, 0x52, 0x81, 0xBE, 0x14, 0x81, 0x4F, 0x75, 0x0C, 0x0E, 0x58,
  0x15, 0xF6, 0x50, 0x0D, 0x58, 0x17, 0xF5, 0x28, 0x3A, 0x10, 0xEC, 0x38, 0x6E, 0x15, 0xFE, 0xDD,
  0xE9, 0x10,
  // "ſ" (U+017F)
  0x28, 0x33, 0xCE, 0xD4, 0x28, 0x91, 0xE9, 0x0C, 0x80, 0x4F, 0x40, 0x32, 0x81, 0x5F, 0x34, 0x81,
  0x5F, 0x34, 0x81, 0x5F, 0x34, 0x81, 0x5F, 0x34, 0x81, 0x5F, 0x34, 0x81, 0x5F, 0x34, 0x81, 0x5F,
  0x34, 0x81, 0x5F, 0x34, 0x81, 0x5F, 0x34, 0x81, 0x8F, 0x73, 0x0C, 0xB0, 0xE0, 0x11,
  // "Ω" (U+03A9)
  0x38, 0x47, 0xCE, 0xEB, 0x44, 0x81, 0xCD, 0x32, 0x81, 0x5F, 0x72, 0x81, 0x7F, 0x54, 0x83, 0x9F,
  0x20, 0xD9, 0x58, 0x44, 0xF8, 0x0F, 0xE5, 0x84, 0x2F, 0xA0, 0xFD, 0x58, 0x42, 0xFA, 0x0D, 0xE5,
  0x85, 0x3F, 0x90, 0x8F, 0x34, 0x85, 0x7F, 0x40, 0x1D, 0xC3, 0x81, 0x2E, 0xA3, 0x85, 0x1A, 0xE3,
  0x7D, 0x72, 0x05, 0x07, 0x28, 0x27, 0x59, 0x22, 0x89, 0x3C, 0x4D, 0x65, 0x95, 0xA6, 0x57, 0xF4,
  0xC0, 0x50, 0xAC,
  // "μ" (U+03BC)
  0x7F, 0x10, 0x0A, 0xE0, 0x7F, 0x10, 0x0A, 0xE0, 0x7F, 0x10, 0x0A, 0xE0, 0x7F, 0x10, 0x0A, 0xE0,
  0x7F, 0x10, 0x0A, 0xE0, 0x7F, 0x10, 0x0A, 0xE0, 0x8F, 0x10, 0x0A, 0xE0, 0x8F, 0x30, 0x0D, 0xE0,
  0x9F, 0x90, 0x6B, 0xF1, 0x98, 0xDE, 0x71, 0xCD, 0xA5, 0x00, 0x00, 0x00, 0xA7, 0x00, 0x00, 0x00,
  0x9E, 0x30, 0x00, 0x00, 0x4E, 0x70, 0x00, 0x00,
  // "π" (U+03C0)
  0x0B, 0xEF, 0xEE, 0xFF, 0xE3, 0x66, 0x2B, 0x00, 0x76, 0x00, 0x10, 0x4A, 0x00, 0x96, 0x00, 0x00,
  0x59, 0x00, 0xA5, 0x00, 0x00, 0x69, 0x00, 0xB4, 0x00, 0x00, 0x78, 0x00, 0xC4, 0x00, 0x00, 0x97,
  0x00, 0xD4, 0x00, 0x00, 0xB6, 0x00, 0xD4, 0x00, 0x02, 0xF3, 0x00, 0xC7, 0x00, 0x0F, 0x90, 0x00,
  0x5E, 0xA0,
  // "–" (U+2013)
  0x01, 0x80, 0x5E, 0x01,
  // "—" (U+2014)
  0x01, 0x80, 0x96, 0xE0, 0x10,
  // "€" (U+20AC)
  0x38, 0x35, 0xCE, 0xD6, 0x38, 0x54, 0xF5, 0x09, 0xF1, 0x20, 0xC0, 0xB2, 0x03, 0x09, 0x28, 0x11,
  0xF7, 0x68, 0x14, 0xF5, 0x58, 0x56, 0xEF, 0xEE, 0xE5, 0x38, 0x15, 0xF3, 0x58, 0x46, 0xEF, 0xEE,
  0xB4, 0x81, 0x3F, 0x56, 0x81, 0x1F, 0x87, 0x0B, 0x0C, 0x78, 0x13, 0xF7, 0x20, 0xA4, 0x83, 0x4C,
  0xED, 0x71,
  // "₿" (U+20BF)
  0x00, 0x1A, 0x75, 0x00, 0x5F, 0xFE, 0xFC, 0x40, 0x07, 0xF4, 0x0A, 0xF2, 0x06, 0xF4, 0x04, 0xF6,
  0x06, 0xF4, 0x03, 0xF7, 0x06, 0xF4, 0x04, 0xF5, 0x06, 0xF4, 0x1B, 0xC0, 0x06, 0xFE, 0xFE, 0x40,
  0x06, 0xF4, 0x07, 0xF4, 0x06, 0xF4, 0x00, 0xEB, 0x06, 0xF4, 0x00, 0xDD, 0x06, 0xF4, 0x00, 0xEC,
  0x07, 0xF4, 0x06, 0xF6, 0x5F, 0xFE, 0xFD, 0x70, 0x00, 0x1A, 0x75, 0x00, 0x00, 0x05, 0x32, 0x00,
  // "‘" (U+2018)
  0x00, 0x94, 0x09, 0x40, 0x0F, 0x20, 0x1F, 0xE0, 0x0B, 0xD0,
  // "’" (U+2019)
  0x0D, 0xA1, 0xEF, 0x03, 0xE0, 0x58, 0x59, 0x00,
  // "‚" (U+201A)
  0x0D, 0xA1, 0xEF, 0x03, 0xE0, 0x58, 0x59, 0x00,
  // "‛" (U+201B)
  0x0B, 0xD0, 0x1F, 0xE0, 0x0F, 0x20, 0x09, 0x30, 0x00, 0x94,
  // "“" (U+201C)
  0x08, 0x71, 0xA3, 0x67, 0x0A, 0x20, 0xC5, 0x1E, 0x10, 0xEF, 0x5F, 0xD0, 0x8E, 0x2C, 0xC0,
  // "”" (U+201D)
  0x0B, 0xD2, 0xE8, 0x0C, 0xF6, 0xFE, 0x01, 0xE2, 0x5C, 0x02, 0xB0, 0x66, 0x3A, 0x16, 0x80,
  // "„" (U+201E)
  0x0B, 0xD2, 0xE8, 0x0C, 0xF6, 0xFE, 0x01, 0xE2, 0x4C, 0x02, 0xB0, 0x66, 0x3A, 0x16, 0x80,
  // "‟" (U+201F)
  0x0B, 0xD0, 0xAD, 0x11, 0xFE, 0x0F, 0xE1, 0x0F, 0x20, 0xE3, 0x00, 0x93, 0x08, 0x50, 0x00, 0x94,
  0x09, 0x50,
  // "†" (U+2020)
  0x28, 0x13, 0xF3, 0x48, 0x12, 0xF1, 0x59, 0x60, 0xD3, 0x89, 0x46, 0xDA, 0xDA, 0xD6, 0x34, 0x2E,
  0x25, 0x32, 0x81, 0x4F, 0x34, 0x81, 0x5F, 0x54, 0x81, 0x3F, 0x34, 0x81, 0x1F, 0x15, 0x96, 0x0E,
  0x60, 0xC6, 0x0B, 0x60, 0xA6, 0x0A, 0x30,
  // "‡" (U+2021)
  0x28, 0x13, 0xF3, 0x48, 0x11, 0xF1, 0x50, 0xE3, 0x89, 0x46, 0xC9, 0xD9, 0xC5, 0x36, 0x3E, 0x36,
  0x32, 0x81, 0x3F, 0x34, 0x81, 0x2F, 0x25, 0x0A, 0x60, 0xA5, 0x81, 0x2F, 0x24, 0x81, 0x3F, 0x32,
  0x89, 0x43, 0x52, 0xD2, 0x53, 0x6C, 0xAD, 0xAD, 0x63, 0x0D, 0x58, 0x11, 0xF1, 0x48, 0x13, 0xF3,
  0x20,
  // "•" (U+2022)
  0x07, 0xED, 0x31, 0xFF, 0xFB, 0x2F, 0xFF, 0xD1, 0xFF, 0xFB, 0x07, 0xED, 0x30,
  // "…" (U+2026)
  0x50, 0x15, 0x8A, 0x41, 0xFA, 0x01, 0xFB, 0x01, 0xFB, 0x1D, 0x90, 0x1D, 0x90, 0x1D, 0x90,
  // "‰" (U+2030)
  0x18, 0x24, 0xDE, 0x93, 0x01, 0x0D, 0x74, 0x83, 0xD8, 0x1E, 0x42, 0x08, 0x07, 0x73, 0x84, 0x2F,
  0x30, 0xB9, 0x20, 0xD0, 0x17, 0x38, 0x74, 0xF2, 0x0A, 0xB0, 0x5A, 0x74, 0x87, 0x4F, 0x20, 0xAB,
  0x0C, 0x37, 0x48, 0x93, 0x2F, 0x30, 0xB9, 0x3C, 0x1A, 0xEB, 0x12, 0x82, 0xAE, 0xC2, 0x28, 0xA0,
  0xD8, 0x2F, 0x49, 0x68, 0xD1, 0xBA, 0x06, 0xE1, 0xAB, 0x28, 0xA1, 0x3D, 0xE8, 0x1E, 0x0C, 0x80,
  0x6E, 0x0B, 0xA0, 0x5F, 0x15, 0x89, 0x57, 0x80, 0xE7, 0x05, 0xF1, 0xD8, 0x04, 0xF2, 0x58, 0x95,
  0xD2, 0x0E, 0x70, 0x5F, 0x1D, 0x80, 0x4F, 0x24, 0x05, 0x0B, 0x28, 0x90, 0xC8, 0x06, 0xE0, 0xBA,
  0x05, 0x95, 0x0B, 0x04, 0x28, 0x91, 0x8D, 0x0B, 0xA0, 0x6E, 0x19, 0xB4, 0x02, 0x0D, 0x38, 0x31,
  0xBE, 0xC1, 0x28, 0x2A, 0xEC, 0x21,
  // "‹" (U+2039)
  0x01, 0xC0, 0xB7, 0x6F, 0x1E, 0xB0, 0x7E, 0x10, 0xB7, 0x01, 0xC0,
  // "›" (U+203A)
  0xB3, 0x00, 0x5D, 0x00, 0x0D, 0x90, 0x08, 0xF2, 0x0D, 0xA0, 0x4D, 0x10, 0xB3, 0x00,
  // "⁄" (U+2044)
  0x50, 0x80, 0x75, 0x0D, 0x01, 0x40, 0x50, 0x95, 0x0C, 0x03, 0x40, 0x20, 0xC5, 0x09, 0x06, 0x40,
  0x10, 0xD5, 0x06, 0x08, 0x50, 0xD0, 0x24, 0x04, 0x0B, 0x50, 0xA0, 0x44, 0x01, 0x0D, 0x50, 0x80,
  0x75,
  // "™" (U+2122)
  0x79, 0xB9, 0xA5, 0xC2, 0x00, 0x7A, 0x26, 0x0D, 0x16, 0x0D, 0x80, 0x0D, 0x80, 0x00, 0xD1, 0x00,
  0x9C, 0x03, 0xA8, 0x00, 0x0D, 0x10, 0x08, 0xB2, 0x76, 0x80, 0x00, 0xD1, 0x00, 0x86, 0x77, 0x68,
  0x00, 0x0D, 0x10, 0x08, 0x1E, 0x46, 0x80, 0x05, 0xB8, 0x05, 0xA1, 0x80, 0xAA, 0x20,
  // "⅒" (U+2152)
  0x30, 0x17, 0x72, 0x0A, 0x0C, 0x40, 0x80, 0x77, 0x10, 0x20, 0xFC, 0x40, 0xD0, 0x17, 0x28, 0x13,
  0x7C, 0x30, 0x50, 0x97, 0x40, 0x70, 0xC3, 0x0C, 0x03, 0x74, 0x07, 0x0C, 0x20, 0x20, 0xC2, 0x01,
  0x72, 0x07, 0x0C, 0x28, 0x39, 0x60, 0xAC, 0x28, 0x24, 0xCC, 0x53, 0x84, 0x8D, 0x01, 0xD3, 0x0F,
  0xC2, 0x8A, 0x0E, 0x42, 0xF1, 0x0B, 0xDD, 0xC9, 0x80, 0x37, 0xC0, 0x59, 0x20, 0xD0, 0x65, 0x0D,
  0x02, 0x28, 0x37, 0xC0, 0x6E, 0x20, 0xC0, 0x84, 0x04, 0x0B, 0x38, 0x37, 0xC0, 0x6E, 0x20, 0xC0,
  0x84, 0x0A, 0x04, 0x38, 0x27, 0xC0, 0x59, 0x20, 0xD0, 0x63, 0x01, 0x0D, 0x40, 0x80, 0xD2, 0x83,
  0xE4, 0x2F, 0x13, 0x08, 0x07, 0x38, 0x7B, 0xDD, 0xC2, 0x4C, 0xC5, 0x10,
  // "ﬁ" (U+FB01)
  0x38, 0x48, 0xDE, 0xEB, 0x24, 0x85, 0x9E, 0x30, 0x4F, 0x84, 0x90, 0x93, 0x06, 0x01, 0x38, 0x12,
  0xF7, 0x70, 0x70, 0xEA, 0x0F, 0xE9, 0x0C, 0x38, 0x12, 0xF7, 0x30, 0x0C, 0x38, 0x12, 0xF7, 0x30,
  0x0C, 0x38, 0x12, 0xF7, 0x30, 0x0C, 0x38, 0x12, 0xF7, 0x30, 0x0C, 0x38, 0x12, 0xF7, 0x30, 0x0C,
  0x38, 0x12, 0xF7, 0x30, 0x0C, 0x38, 0x12, 0xF7, 0x30, 0x0C, 0x38, 0x15, 0xFA, 0x28, 0x41, 0xEE,
  0x10, 0x9B, 0x0E, 0x01, 0xC0, 0x20,
  // "ﬂ" (U+FB02)
  0x38, 0x18, 0xDE, 0xA0, 0xC4, 0x85, 0x9F, 0x30, 0x4F, 0xC4, 0x90, 0x93, 0x0D, 0x0C, 0x38, 0x11,
  0xF7, 0x30, 0xD0, 0xC2, 0x07, 0x0E, 0xA8, 0x3E, 0x90, 0xDC, 0x38, 0x12, 0xF7, 0x30, 0xD0, 0xC3,
  0x81, 0x2F, 0x73, 0x0D, 0x0C, 0x38, 0x12, 0xF7, 0x30, 0xD0, 0xC3, 0x81, 0x2F, 0x73, 0x0D, 0x0C,
  0x38, 0x12, 0xF7, 0x30, 0xD0, 0xC3, 0x81, 0x2F, 0x73, 0x0D, 0x0C, 0x38, 0x12, 0xF7, 0x30, 0xD0,
  0xC3, 0x81, 0x5F, 0xA2, 0x84, 0x1E, 0xE1, 0x09, 0xB0, 0xE0, 0x1C, 0x02,
};

const Font& font_NotoSerif_Condensed_18() {
  static SmoothFont font(font_NotoSerif_Condensed_18_data);
  return font;
}

}  // namespace roo_display
