#include "8.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSerif-BoldItalic (Noto Serif Bold Italic)
// Generated on Wed Nov 19 19:11:44 CET 2025
static const uint8_t font_NotoSerif_BoldItalic_8_data[] PROGMEM = {
  
  // Header
  0x01, 0x02, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x02, 0xF2,
  0xFE, 0xFF, 0x0A, 0x0A, 0x07, 0xFE, 0x03, 0x01, 0x0A, 0x03, 0x03, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x40, 0x01, 0x02, 0x07, 0x03, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x41, 0x05, 0x04, 0x07, 0x04, 0x00, 0x0B, // """ (U+0022)
  0x00, 0x23, 0x40, 0x01, 0x04, 0x07, 0x04, 0x00, 0x11, // "#" (U+0023)
  0x00, 0x24, 0x40, 0x00, 0x04, 0x07, 0x04, 0x00, 0x23, // "$" (U+0024)
  0x00, 0x25, 0x40, 0x01, 0x06, 0x07, 0x07, 0x00, 0x37, // "%" (U+0025)
  0x00, 0x26, 0x40, 0x01, 0x06, 0x07, 0x06, 0x00, 0x50, // "&" (U+0026)
  0x00, 0x27, 0x41, 0x05, 0x02, 0x07, 0x02, 0x00, 0x69, // "'" (U+0027)
  0x00, 0x28, 0x40, 0x00, 0x03, 0x06, 0x03, 0x00, 0x6C, // "(" (U+0028)
  0x00, 0x29, 0xBF, 0x00, 0x02, 0x06, 0x03, 0x00, 0x7A, // ")" (U+0029)
  0x00, 0x2A, 0x41, 0x04, 0x04, 0x07, 0x05, 0x00, 0x88, // "*" (U+002A)
  0x00, 0x2B, 0x40, 0x02, 0x03, 0x05, 0x04, 0x00, 0x90, // "+" (U+002B)
  0x00, 0x2C, 0x40, 0xFF, 0x01, 0x01, 0x02, 0x00, 0x98, // "," (U+002C)
  0x00, 0x2D, 0x40, 0x03, 0x02, 0x03, 0x02, 0x00, 0x9B, // "-" (U+002D)
  0x00, 0x2E, 0x40, 0x01, 0x01, 0x01, 0x02, 0x00, 0x9D, // "." (U+002E)
  0x00, 0x2F, 0xBF, 0x00, 0x02, 0x07, 0x02, 0x00, 0x9E, // "/" (U+002F)
  0x00, 0x30, 0x40, 0x01, 0x04, 0x07, 0x04, 0x00, 0xAE, // "0" (U+0030)
  0x00, 0x31, 0x40, 0x01, 0x03, 0x07, 0x04, 0x00, 0xC0, // "1" (U+0031)
  0x00, 0x32, 0x40, 0x01, 0x04, 0x07, 0x04, 0x00, 0xCE, // "2" (U+0032)
  0x00, 0x33, 0x40, 0x01, 0x04, 0x07, 0x04, 0x00, 0xE0, // "3" (U+0033)
  0x00, 0x34, 0x40, 0x01, 0x04, 0x07, 0x04, 0x00, 0xF2, // "4" (U+0034)
  0x00, 0x35, 0x40, 0x01, 0x04, 0x07, 0x04, 0x01, 0x04, // "5" (U+0035)
  0x00, 0x36, 0x40, 0x01, 0x04, 0x07, 0x04, 0x01, 0x16, // "6" (U+0036)
  0x00, 0x37, 0x40, 0x01, 0x04, 0x07, 0x04, 0x01, 0x28, // "7" (U+0037)
  0x00, 0x38, 0x40, 0x01, 0x04, 0x07, 0x04, 0x01, 0x3A, // "8" (U+0038)
  0x00, 0x39, 0x40, 0x01, 0x04, 0x07, 0x04, 0x01, 0x4C, // "9" (U+0039)
  0x00, 0x3A, 0x00, 0x01, 0x02, 0x05, 0x03, 0x01, 0x5E, // ":" (U+003A)
  0x00, 0x3B, 0x40, 0x00, 0x02, 0x05, 0x03, 0x01, 0x65, // ";" (U+003B)
  0x00, 0x3C, 0x40, 0x02, 0x03, 0x05, 0x04, 0x01, 0x6E, // "<" (U+003C)
  0x00, 0x3D, 0x40, 0x03, 0x03, 0x05, 0x04, 0x01, 0x76, // "=" (U+003D)
  0x00, 0x3E, 0x40, 0x02, 0x03, 0x05, 0x04, 0x01, 0x7C, // ">" (U+003E)
  0x00, 0x3F, 0x40, 0x01, 0x04, 0x07, 0x04, 0x01, 0x84, // "?" (U+003F)
  0x00, 0x40, 0x40, 0xFF, 0x06, 0x07, 0x07, 0x01, 0x96, // "@" (U+0040)
  0x00, 0x41, 0xFF, 0x01, 0x05, 0x07, 0x06, 0x01, 0xB6, // "A" (U+0041)
  0x00, 0x42, 0xBF, 0x01, 0x05, 0x07, 0x05, 0x01, 0xCE, // "B" (U+0042)
  0x00, 0x43, 0x40, 0x01, 0x05, 0x07, 0x05, 0x01, 0xE7, // "C" (U+0043)
  0x00, 0x44, 0xBF, 0x01, 0x05, 0x07, 0x06, 0x01, 0xFC, // "D" (U+0044)
  0x00, 0x45, 0xBF, 0x01, 0x05, 0x07, 0x05, 0x02, 0x15, // "E" (U+0045)
  0x00, 0x46, 0xFF, 0x01, 0x05, 0x07, 0x05, 0x02, 0x2E, // "F" (U+0046)
  0x00, 0x47, 0x40, 0x01, 0x05, 0x07, 0x06, 0x02, 0x44, // "G" (U+0047)
  0x00, 0x48, 0xBF, 0x01, 0x06, 0x07, 0x07, 0x02, 0x59, // "H" (U+0048)
  0x00, 0x49, 0xBF, 0x01, 0x03, 0x07, 0x03, 0x02, 0x75, // "I" (U+0049)
  0x00, 0x4A, 0xFE, 0xFF, 0x03, 0x07, 0x03, 0x02, 0x87, // "J" (U+004A)
  0x00, 0x4B, 0xBF, 0x01, 0x06, 0x07, 0x06, 0x02, 0x9E, // "K" (U+004B)
  0x00, 0x4C, 0xBF, 0x01, 0x04, 0x07, 0x05, 0x02, 0xBA, // "L" (U+004C)
  0x00, 0x4D, 0xBF, 0x01, 0x08, 0x07, 0x08, 0x02, 0xCF, // "M" (U+004D)
  0x00, 0x4E, 0xBF, 0x01, 0x06, 0x07, 0x06, 0x02, 0xF2, // "N" (U+004E)
  0x00, 0x4F, 0x40, 0x01, 0x06, 0x07, 0x06, 0x03, 0x0E, // "O" (U+004F)
  0x00, 0x50, 0xBF, 0x01, 0x05, 0x07, 0x05, 0x03, 0x27, // "P" (U+0050)
  0x00, 0x51, 0x40, 0xFF, 0x06, 0x07, 0x06, 0x03, 0x40, // "Q" (U+0051)
  0x00, 0x52, 0xBF, 0x01, 0x05, 0x07, 0x06, 0x03, 0x60, // "R" (U+0052)
  0x00, 0x53, 0x40, 0x01, 0x04, 0x07, 0x05, 0x03, 0x79, // "S" (U+0053)
  0x00, 0x54, 0x40, 0x01, 0x05, 0x07, 0x05, 0x03, 0x8B, // "T" (U+0054)
  0x00, 0x55, 0x40, 0x01, 0x06, 0x07, 0x06, 0x03, 0xA0, // "U" (U+0055)
  0x00, 0x56, 0x00, 0x01, 0x06, 0x07, 0x06, 0x03, 0xB9, // "V" (U+0056)
  0x00, 0x57, 0x40, 0x01, 0x09, 0x07, 0x09, 0x03, 0xD1, // "W" (U+0057)
  0x00, 0x58, 0xFF, 0x01, 0x06, 0x07, 0x06, 0x03, 0xF4, // "X" (U+0058)
  0x00, 0x59, 0x00, 0x01, 0x06, 0x07, 0x06, 0x04, 0x0F, // "Y" (U+0059)
  0x00, 0x5A, 0x40, 0x01, 0x05, 0x07, 0x05, 0x04, 0x27, // "Z" (U+005A)
  0x00, 0x5B, 0x40, 0xFF, 0x03, 0x07, 0x03, 0x04, 0x3C, // "[" (U+005B)
  0x00, 0x5C, 0x40, 0x00, 0x01, 0x07, 0x02, 0x04, 0x4E, // "\" (U+005C)
  0x00, 0x5D, 0xBF, 0xFF, 0x03, 0x07, 0x03, 0x04, 0x56, // "]" (U+005D)
  0x00, 0x5E, 0x40, 0x03, 0x03, 0x06, 0x04, 0x04, 0x6D, // "^" (U+005E)
  0x00, 0x5F, 0xBF, 0x00, 0x02, 0x00, 0x04, 0x04, 0x75, // "_" (U+005F)
  0x00, 0x60, 0x41, 0x07, 0x02, 0x08, 0x03, 0x04, 0x77, // "`" (U+0060)
  0x00, 0x61, 0x40, 0x01, 0x04, 0x05, 0x05, 0x04, 0x79, // "a" (U+0061)
  0x00, 0x62, 0x40, 0x01, 0x04, 0x07, 0x05, 0x04, 0x86, // "b" (U+0062)
  0x00, 0x63, 0x40, 0x01, 0x04, 0x05, 0x04, 0x04, 0x98, // "c" (U+0063)
  0x00, 0x64, 0x40, 0x01, 0x05, 0x07, 0x05, 0x04, 0xA5, // "d" (U+0064)
  0x00, 0x65, 0x40, 0x01, 0x04, 0x05, 0x04, 0x04, 0xBA, // "e" (U+0065)
  0x00, 0x66, 0xFF, 0xFF, 0x04, 0x07, 0x03, 0x04, 0xC7, // "f" (U+0066)
  0x00, 0x67, 0xBF, 0xFF, 0x04, 0x06, 0x05, 0x04, 0xE0, // "g" (U+0067)
  0x00, 0x68, 0x40, 0x01, 0x04, 0x07, 0x05, 0x04, 0xF8, // "h" (U+0068)
  0x00, 0x69, 0x40, 0x01, 0x02, 0x07, 0x03, 0x05, 0x0A, // "i" (U+0069)
  0x00, 0x6A, 0xBF, 0xFF, 0x02, 0x07, 0x03, 0x05, 0x15, // "j" (U+006A)
  0x00, 0x6B, 0x40, 0x01, 0x04, 0x07, 0x05, 0x05, 0x27, // "k" (U+006B)
  0x00, 0x6C, 0x40, 0x01, 0x02, 0x07, 0x03, 0x05, 0x39, // "l" (U+006C)
  0x00, 0x6D, 0x40, 0x01, 0x07, 0x05, 0x08, 0x05, 0x44, // "m" (U+006D)
  0x00, 0x6E, 0x40, 0x01, 0x05, 0x05, 0x05, 0x05, 0x58, // "n" (U+006E)
  0x00, 0x6F, 0x40, 0x01, 0x04, 0x05, 0x05, 0x05, 0x67, // "o" (U+006F)
  0x00, 0x70, 0xBF, 0xFF, 0x04, 0x05, 0x05, 0x05, 0x74, // "p" (U+0070)
  0x00, 0x71, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x05, 0x89, // "q" (U+0071)
  0x00, 0x72, 0x40, 0x01, 0x04, 0x05, 0x04, 0x05, 0x9B, // "r" (U+0072)
  0x00, 0x73, 0x40, 0x01, 0x03, 0x05, 0x04, 0x05, 0xA8, // "s" (U+0073)
  0x00, 0x74, 0x40, 0x01, 0x03, 0x06, 0x03, 0x05, 0xB2, // "t" (U+0074)
  0x00, 0x75, 0x40, 0x01, 0x05, 0x05, 0x05, 0x05, 0xBE, // "u" (U+0075)
  0x00, 0x76, 0x40, 0x01, 0x04, 0x05, 0x05, 0x05, 0xCD, // "v" (U+0076)
  0x00, 0x77, 0x40, 0x01, 0x06, 0x05, 0x07, 0x05, 0xDA, // "w" (U+0077)
  0x00, 0x78, 0xBF, 0x01, 0x04, 0x05, 0x05, 0x05, 0xEC, // "x" (U+0078)
  0x00, 0x79, 0xFE, 0xFF, 0x04, 0x05, 0x05, 0x05, 0xFB, // "y" (U+0079)
  0x00, 0x7A, 0x40, 0x01, 0x04, 0x05, 0x04, 0x06, 0x13, // "z" (U+007A)
  0x00, 0x7B, 0x40, 0xFF, 0x04, 0x07, 0x04, 0x06, 0x20, // "{" (U+007B)
  0x00, 0x7C, 0x41, 0xFF, 0x02, 0x07, 0x04, 0x06, 0x37, // "|" (U+007C)
  0x00, 0x7D, 0xBF, 0xFF, 0x03, 0x07, 0x04, 0x06, 0x40, // "}" (U+007D)
  0x00, 0x7E, 0x40, 0x03, 0x03, 0x04, 0x04, 0x06, 0x57, // "~" (U+007E)
  0x00, 0xA1, 0x40, 0xFF, 0x02, 0x05, 0x03, 0x06, 0x5B, // "¡" (U+00A1)
  0x00, 0xA2, 0x40, 0x01, 0x04, 0x07, 0x04, 0x06, 0x66, // "¢" (U+00A2)
  0x00, 0xA3, 0x40, 0x01, 0x04, 0x07, 0x04, 0x06, 0x78, // "£" (U+00A3)
  0x00, 0xA4, 0x40, 0x02, 0x03, 0x06, 0x04, 0x06, 0x8A, // "¤" (U+00A4)
  0x00, 0xA5, 0x40, 0x01, 0x05, 0x07, 0x04, 0x06, 0x94, // "¥" (U+00A5)
  0x00, 0xA6, 0x41, 0xFF, 0x02, 0x07, 0x04, 0x06, 0xA9, // "¦" (U+00A6)
  0x00, 0xA7, 0x40, 0x00, 0x04, 0x07, 0x04, 0x06, 0xB2, // "§" (U+00A7)
  0x00, 0xA8, 0x41, 0x06, 0x04, 0x07, 0x05, 0x06, 0xC6, // "¨" (U+00A8)
  0x00, 0xA9, 0x40, 0x01, 0x06, 0x07, 0x07, 0x06, 0xCA, // "©" (U+00A9)
  0x00, 0xAA, 0x40, 0x04, 0x03, 0x06, 0x03, 0x06, 0xE3, // "ª" (U+00AA)
  0x00, 0xAB, 0x40, 0x02, 0x03, 0x05, 0x04, 0x06, 0xE9, // "«" (U+00AB)
  0x00, 0xAC, 0x40, 0x02, 0x03, 0x04, 0x04, 0x06, 0xF1, // "¬" (U+00AC)
  0x00, 0xAE, 0x40, 0x01, 0x06, 0x07, 0x07, 0x06, 0xF7, // "®" (U+00AE)
  0x00, 0xAF, 0x40, 0x08, 0x04, 0x08, 0x04, 0x07, 0x10, // "¯" (U+00AF)
  0x00, 0xB0, 0x41, 0x05, 0x03, 0x07, 0x03, 0x07, 0x13, // "°" (U+00B0)
  0x00, 0xB1, 0x40, 0x01, 0x03, 0x05, 0x04, 0x07, 0x18, // "±" (U+00B1)
  0x00, 0xB2, 0x40, 0x04, 0x03, 0x07, 0x03, 0x07, 0x22, // "²" (U+00B2)
  0x00, 0xB3, 0x40, 0x04, 0x03, 0x07, 0x03, 0x07, 0x2A, // "³" (U+00B3)
  0x00, 0xB4, 0x41, 0x07, 0x02, 0x08, 0x03, 0x07, 0x32, // "´" (U+00B4)
  0x00, 0xB5, 0x40, 0xFF, 0x05, 0x05, 0x05, 0x07, 0x34, // "µ" (U+00B5)
  0x00, 0xB6, 0x40, 0x00, 0x04, 0x07, 0x05, 0x07, 0x49, // "¶" (U+00B6)
  0x00, 0xB7, 0x40, 0x03, 0x01, 0x04, 0x02, 0x07, 0x5D, // "·" (U+00B7)
  0x00, 0xB8, 0x40, 0xFF, 0x02, 0x01, 0x03, 0x07, 0x5F, // "¸" (U+00B8)
  0x00, 0xB9, 0x40, 0x04, 0x02, 0x07, 0x03, 0x07, 0x64, // "¹" (U+00B9)
  0x00, 0xBA, 0x40, 0x04, 0x03, 0x06, 0x03, 0x07, 0x6A, // "º" (U+00BA)
  0x00, 0xBB, 0x40, 0x02, 0x03, 0x05, 0x04, 0x07, 0x70, // "»" (U+00BB)
  0x00, 0xBC, 0x40, 0x01, 0x06, 0x07, 0x07, 0x07, 0x78, // "¼" (U+00BC)
  0x00, 0xBD, 0x40, 0x01, 0x06, 0x07, 0x07, 0x07, 0x91, // "½" (U+00BD)
  0x00, 0xBE, 0x40, 0x01, 0x06, 0x07, 0x07, 0x07, 0xAA, // "¾" (U+00BE)
  0x00, 0xBF, 0x40, 0xFF, 0x03, 0x05, 0x04, 0x07, 0xC3, // "¿" (U+00BF)
  0x00, 0xC0, 0xFF, 0x01, 0x05, 0x09, 0x06, 0x07, 0xD1, // "À" (U+00C0)
  0x00, 0xC1, 0xFF, 0x01, 0x05, 0x09, 0x06, 0x07, 0xEE, // "Á" (U+00C1)
  0x00, 0xC2, 0xFF, 0x01, 0x05, 0x09, 0x06, 0x08, 0x0B, // "Â" (U+00C2)
  0x00, 0xC3, 0xFF, 0x01, 0x05, 0x08, 0x06, 0x08, 0x29, // "Ã" (U+00C3)
  0x00, 0xC4, 0xBF, 0x01, 0x05, 0x08, 0x06, 0x08, 0x44, // "Ä" (U+00C4)
  0x00, 0xC5, 0xFF, 0x01, 0x05, 0x09, 0x06, 0x08, 0x60, // "Å" (U+00C5)
  0x00, 0xC6, 0xFF, 0x01, 0x08, 0x07, 0x08, 0x08, 0x7C, // "Æ" (U+00C6)
  0x00, 0xC7, 0x40, 0xFF, 0x05, 0x07, 0x05, 0x08, 0x9B, // "Ç" (U+00C7)
  0x00, 0xC8, 0xFF, 0x01, 0x05, 0x09, 0x05, 0x08, 0xB6, // "È" (U+00C8)
  0x00, 0xC9, 0xFF, 0x01, 0x05, 0x09, 0x05, 0x08, 0xD4, // "É" (U+00C9)
  0x00, 0xCA, 0xFF, 0x01, 0x05, 0x09, 0x05, 0x08, 0xF2, // "Ê" (U+00CA)
  0x00, 0xCB, 0xBF, 0x01, 0x05, 0x08, 0x05, 0x09, 0x11, // "Ë" (U+00CB)
  0x00, 0xCC, 0xBF, 0x01, 0x03, 0x09, 0x03, 0x09, 0x2D, // "Ì" (U+00CC)
  0x00, 0xCD, 0xBF, 0x01, 0x03, 0x09, 0x03, 0x09, 0x44, // "Í" (U+00CD)
  0x00, 0xCE, 0xBF, 0x01, 0x03, 0x09, 0x03, 0x09, 0x5B, // "Î" (U+00CE)
  0x00, 0xCF, 0xFF, 0x01, 0x04, 0x08, 0x03, 0x09, 0x72, // "Ï" (U+00CF)
  0x00, 0xD0, 0xBF, 0x01, 0x05, 0x07, 0x06, 0x09, 0x88, // "Ð" (U+00D0)
  0x00, 0xD1, 0xBF, 0x01, 0x06, 0x08, 0x06, 0x09, 0xA1, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x40, 0x01, 0x06, 0x09, 0x06, 0x09, 0xC1, // "Ò" (U+00D2)
  0x00, 0xD3, 0x40, 0x01, 0x06, 0x09, 0x06, 0x09, 0xE1, // "Ó" (U+00D3)
  0x00, 0xD4, 0x40, 0x01, 0x06, 0x09, 0x06, 0x0A, 0x01, // "Ô" (U+00D4)
  0x00, 0xD5, 0x40, 0x01, 0x06, 0x08, 0x06, 0x0A, 0x21, // "Õ" (U+00D5)
  0x00, 0xD6, 0x40, 0x01, 0x06, 0x08, 0x06, 0x0A, 0x3D, // "Ö" (U+00D6)
  0x00, 0xD7, 0x40, 0x02, 0x03, 0x05, 0x04, 0x0A, 0x59, // "×" (U+00D7)
  0x00, 0xD8, 0x40, 0x01, 0x06, 0x07, 0x06, 0x0A, 0x61, // "Ø" (U+00D8)
  0x00, 0xD9, 0x40, 0x01, 0x06, 0x09, 0x06, 0x0A, 0x7A, // "Ù" (U+00D9)
  0x00, 0xDA, 0x40, 0x01, 0x06, 0x09, 0x06, 0x0A, 0x9A, // "Ú" (U+00DA)
  0x00, 0xDB, 0x40, 0x01, 0x06, 0x09, 0x06, 0x0A, 0xBA, // "Û" (U+00DB)
  0x00, 0xDC, 0x40, 0x01, 0x06, 0x08, 0x06, 0x0A, 0xDA, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x01, 0x06, 0x09, 0x06, 0x0A, 0xF6, // "Ý" (U+00DD)
  0x00, 0xDE, 0xBF, 0x01, 0x05, 0x07, 0x05, 0x0B, 0x14, // "Þ" (U+00DE)
  0x00, 0xDF, 0xFE, 0xFF, 0x05, 0x07, 0x06, 0x0B, 0x2D, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0B, 0x4F, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0B, 0x62, // "á" (U+00E1)
  0x00, 0xE2, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0B, 0x75, // "â" (U+00E2)
  0x00, 0xE3, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0B, 0x89, // "ã" (U+00E3)
  0x00, 0xE4, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0B, 0x9B, // "ä" (U+00E4)
  0x00, 0xE5, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0B, 0xAD, // "å" (U+00E5)
  0x00, 0xE6, 0x40, 0x01, 0x06, 0x05, 0x07, 0x0B, 0xC1, // "æ" (U+00E6)
  0x00, 0xE7, 0x40, 0xFF, 0x04, 0x05, 0x04, 0x0B, 0xD3, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x01, 0x04, 0x08, 0x04, 0x0B, 0xE5, // "è" (U+00E8)
  0x00, 0xE9, 0x00, 0x01, 0x04, 0x08, 0x04, 0x0B, 0xF8, // "é" (U+00E9)
  0x00, 0xEA, 0x40, 0x01, 0x04, 0x08, 0x04, 0x0C, 0x0B, // "ê" (U+00EA)
  0x00, 0xEB, 0x40, 0x01, 0x04, 0x07, 0x04, 0x0C, 0x1F, // "ë" (U+00EB)
  0x00, 0xEC, 0x40, 0x01, 0x02, 0x08, 0x03, 0x0C, 0x31, // "ì" (U+00EC)
  0x00, 0xED, 0x40, 0x01, 0x02, 0x08, 0x03, 0x0C, 0x3D, // "í" (U+00ED)
  0x00, 0xEE, 0x40, 0x01, 0x02, 0x08, 0x03, 0x0C, 0x49, // "î" (U+00EE)
  0x00, 0xEF, 0x40, 0x01, 0x03, 0x07, 0x03, 0x0C, 0x55, // "ï" (U+00EF)
  0x00, 0xF0, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0C, 0x63, // "ð" (U+00F0)
  0x00, 0xF1, 0x40, 0x01, 0x05, 0x07, 0x05, 0x0C, 0x77, // "ñ" (U+00F1)
  0x00, 0xF2, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0C, 0x8C, // "ò" (U+00F2)
  0x00, 0xF3, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0C, 0x9F, // "ó" (U+00F3)
  0x00, 0xF4, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0C, 0xB2, // "ô" (U+00F4)
  0x00, 0xF5, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0C, 0xC6, // "õ" (U+00F5)
  0x00, 0xF6, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0C, 0xD8, // "ö" (U+00F6)
  0x00, 0xF7, 0x00, 0x02, 0x03, 0x06, 0x04, 0x0C, 0xEA, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x00, 0x04, 0x06, 0x05, 0x0C, 0xF3, // "ø" (U+00F8)
  0x00, 0xF9, 0x00, 0x01, 0x05, 0x08, 0x05, 0x0D, 0x03, // "ù" (U+00F9)
  0x00, 0xFA, 0x00, 0x01, 0x05, 0x08, 0x05, 0x0D, 0x1A, // "ú" (U+00FA)
  0x00, 0xFB, 0x40, 0x01, 0x05, 0x08, 0x05, 0x0D, 0x31, // "û" (U+00FB)
  0x00, 0xFC, 0x40, 0x01, 0x05, 0x07, 0x05, 0x0D, 0x49, // "ü" (U+00FC)
  0x00, 0xFD, 0xFE, 0xFF, 0x04, 0x08, 0x05, 0x0D, 0x5E, // "ý" (U+00FD)
  0x00, 0xFE, 0xBF, 0xFF, 0x04, 0x07, 0x05, 0x0D, 0x7B, // "þ" (U+00FE)
  0x00, 0xFF, 0xFE, 0xFF, 0x04, 0x07, 0x05, 0x0D, 0x96, // "ÿ" (U+00FF)
  0x01, 0x00, 0xBF, 0x01, 0x05, 0x07, 0x06, 0x0D, 0xB3, // "Ā" (U+0100)
  0x01, 0x01, 0x40, 0x01, 0x04, 0x06, 0x05, 0x0D, 0xCC, // "ā" (U+0101)
  0x01, 0x02, 0xFF, 0x01, 0x05, 0x08, 0x06, 0x0D, 0xDB, // "Ă" (U+0102)
  0x01, 0x03, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0D, 0xF6, // "ă" (U+0103)
  0x01, 0x04, 0xFF, 0xFF, 0x05, 0x07, 0x06, 0x0E, 0x08, // "Ą" (U+0104)
  0x01, 0x05, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x0E, 0x26, // "ą" (U+0105)
  0x01, 0x06, 0x40, 0x01, 0x05, 0x09, 0x05, 0x0E, 0x38, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x01, 0x04, 0x08, 0x04, 0x0E, 0x53, // "ć" (U+0107)
  0x01, 0x08, 0x40, 0x01, 0x05, 0x09, 0x05, 0x0E, 0x66, // "Ĉ" (U+0108)
  0x01, 0x09, 0x40, 0x01, 0x04, 0x08, 0x04, 0x0E, 0x81, // "ĉ" (U+0109)
  0x01, 0x0A, 0x40, 0x01, 0x05, 0x08, 0x05, 0x0E, 0x95, // "Ċ" (U+010A)
  0x01, 0x0B, 0x40, 0x01, 0x04, 0x07, 0x04, 0x0E, 0xAD, // "ċ" (U+010B)
  0x01, 0x0C, 0x40, 0x01, 0x05, 0x09, 0x05, 0x0E, 0xBF, // "Č" (U+010C)
  0x01, 0x0D, 0x40, 0x01, 0x04, 0x08, 0x04, 0x0E, 0xDA, // "č" (U+010D)
  0x01, 0x0E, 0xBF, 0x01, 0x05, 0x09, 0x06, 0x0E, 0xEE, // "Ď" (U+010E)
  0x01, 0x0F, 0x40, 0x01, 0x06, 0x07, 0x05, 0x0F, 0x0E, // "ď" (U+010F)
  0x01, 0x10, 0xBF, 0x01, 0x05, 0x07, 0x06, 0x0F, 0x27, // "Đ" (U+0110)
  0x01, 0x11, 0x40, 0x01, 0x05, 0x07, 0x05, 0x0F, 0x40, // "đ" (U+0111)
  0x01, 0x12, 0xFF, 0x01, 0x05, 0x07, 0x05, 0x0F, 0x55, // "Ē" (U+0112)
  0x01, 0x13, 0x40, 0x01, 0x04, 0x06, 0x04, 0x0F, 0x6D, // "ē" (U+0113)
  0x01, 0x14, 0xBF, 0x01, 0x05, 0x08, 0x05, 0x0F, 0x7C, // "Ĕ" (U+0114)
  0x01, 0x15, 0x40, 0x01, 0x04, 0x07, 0x04, 0x0F, 0x98, // "ĕ" (U+0115)
  0x01, 0x16, 0xFF, 0x01, 0x05, 0x08, 0x05, 0x0F, 0xAA, // "Ė" (U+0116)
  0x01, 0x17, 0x40, 0x01, 0x04, 0x07, 0x04, 0x0F, 0xC5, // "ė" (U+0117)
  0x01, 0x18, 0xFF, 0xFF, 0x05, 0x07, 0x05, 0x0F, 0xD7, // "Ę" (U+0118)
  0x01, 0x19, 0x40, 0xFF, 0x04, 0x05, 0x04, 0x0F, 0xF5, // "ę" (U+0119)
  0x01, 0x1A, 0xFF, 0x01, 0x05, 0x09, 0x05, 0x10, 0x07, // "Ě" (U+011A)
  0x01, 0x1B, 0x40, 0x01, 0x04, 0x08, 0x04, 0x10, 0x26, // "ě" (U+011B)
  0x01, 0x1C, 0x40, 0x01, 0x05, 0x09, 0x06, 0x10, 0x3A, // "Ĝ" (U+011C)
  0x01, 0x1D, 0xBF, 0xFF, 0x04, 0x08, 0x05, 0x10, 0x55, // "ĝ" (U+011D)
  0x01, 0x1E, 0x40, 0x01, 0x05, 0x08, 0x06, 0x10, 0x73, // "Ğ" (U+011E)
  0x01, 0x1F, 0xBF, 0xFF, 0x04, 0x07, 0x05, 0x10, 0x8B, // "ğ" (U+011F)
  0x01, 0x20, 0x40, 0x01, 0x05, 0x08, 0x06, 0x10, 0xA6, // "Ġ" (U+0120)
  0x01, 0x21, 0xBF, 0xFF, 0x04, 0x07, 0x05, 0x10, 0xBE, // "ġ" (U+0121)
  0x01, 0x22, 0x40, 0xFF, 0x05, 0x07, 0x06, 0x10, 0xD9, // "Ģ" (U+0122)
  0x01, 0x23, 0xBF, 0xFF, 0x04, 0x07, 0x05, 0x10, 0xF4, // "ģ" (U+0123)
  0x01, 0x24, 0xBF, 0x01, 0x06, 0x09, 0x07, 0x11, 0x0F, // "Ĥ" (U+0124)
  0x01, 0x25, 0x40, 0x01, 0x04, 0x0A, 0x05, 0x11, 0x33, // "ĥ" (U+0125)
  0x01, 0x26, 0xBF, 0x01, 0x06, 0x07, 0x07, 0x11, 0x4C, // "Ħ" (U+0126)
  0x01, 0x27, 0x40, 0x01, 0x04, 0x07, 0x05, 0x11, 0x68, // "ħ" (U+0127)
  0x01, 0x28, 0xBF, 0x01, 0x03, 0x08, 0x03, 0x11, 0x7A, // "Ĩ" (U+0128)
  0x01, 0x29, 0x40, 0x01, 0x02, 0x07, 0x03, 0x11, 0x8E, // "ĩ" (U+0129)
  0x01, 0x2A, 0xBF, 0x01, 0x03, 0x07, 0x03, 0x11, 0x99, // "Ī" (U+012A)
  0x01, 0x2B, 0x40, 0x01, 0x03, 0x06, 0x03, 0x11, 0xAB, // "ī" (U+012B)
  0x01, 0x2C, 0xBF, 0x01, 0x03, 0x08, 0x03, 0x11, 0xB7, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x40, 0x01, 0x03, 0x07, 0x03, 0x11, 0xCB, // "ĭ" (U+012D)
  0x01, 0x2E, 0xBF, 0xFF, 0x03, 0x07, 0x03, 0x11, 0xD9, // "Į" (U+012E)
  0x01, 0x2F, 0x40, 0xFF, 0x02, 0x07, 0x03, 0x11, 0xF0, // "į" (U+012F)
  0x01, 0x30, 0xBF, 0x01, 0x03, 0x08, 0x03, 0x11, 0xFE, // "İ" (U+0130)
  0x01, 0x31, 0x40, 0x01, 0x02, 0x05, 0x03, 0x12, 0x12, // "ı" (U+0131)
  0x01, 0x32, 0xFF, 0xFF, 0x06, 0x07, 0x06, 0x12, 0x1A, // "Ĳ" (U+0132)
  0x01, 0x33, 0x00, 0xFF, 0x05, 0x07, 0x06, 0x12, 0x3D, // "ĳ" (U+0133)
  0x01, 0x34, 0xFE, 0xFF, 0x03, 0x09, 0x03, 0x12, 0x57, // "Ĵ" (U+0134)
  0x01, 0x35, 0xBF, 0xFF, 0x02, 0x08, 0x03, 0x12, 0x74, // "ĵ" (U+0135)
  0x01, 0x36, 0xFF, 0xFF, 0x06, 0x07, 0x06, 0x12, 0x88, // "Ķ" (U+0136)
  0x01, 0x37, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x12, 0xA9, // "ķ" (U+0137)
  0x01, 0x38, 0x40, 0x01, 0x04, 0x05, 0x05, 0x12, 0xC0, // "ĸ" (U+0138)
  0x01, 0x39, 0xFF, 0x01, 0x04, 0x09, 0x05, 0x12, 0xCD, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x40, 0x01, 0x03, 0x0A, 0x03, 0x12, 0xE7, // "ĺ" (U+013A)
  0x01, 0x3B, 0xFF, 0xFF, 0x04, 0x07, 0x05, 0x12, 0xFB, // "Ļ" (U+013B)
  0x01, 0x3C, 0xBF, 0xFF, 0x02, 0x07, 0x03, 0x13, 0x14, // "ļ" (U+013C)
  0x01, 0x3D, 0xBF, 0x01, 0x05, 0x07, 0x05, 0x13, 0x26, // "Ľ" (U+013D)
  0x01, 0x3E, 0x40, 0x01, 0x04, 0x07, 0x03, 0x13, 0x3F, // "ľ" (U+013E)
  0x01, 0x3F, 0xFF, 0x01, 0x05, 0x07, 0x05, 0x13, 0x51, // "Ŀ" (U+013F)
  0x01, 0x40, 0x40, 0x01, 0x03, 0x07, 0x04, 0x13, 0x69, // "ŀ" (U+0140)
  0x01, 0x41, 0xBF, 0x01, 0x04, 0x07, 0x05, 0x13, 0x77, // "Ł" (U+0141)
  0x01, 0x42, 0x40, 0x01, 0x02, 0x07, 0x03, 0x13, 0x8C, // "ł" (U+0142)
  0x01, 0x43, 0xBF, 0x01, 0x06, 0x09, 0x06, 0x13, 0x97, // "Ń" (U+0143)
  0x01, 0x44, 0x00, 0x01, 0x05, 0x08, 0x05, 0x13, 0xBB, // "ń" (U+0144)
  0x01, 0x45, 0xFF, 0xFF, 0x06, 0x07, 0x06, 0x13, 0xD2, // "Ņ" (U+0145)
  0x01, 0x46, 0x40, 0xFF, 0x05, 0x05, 0x05, 0x13, 0xF5, // "ņ" (U+0146)
  0x01, 0x47, 0xBF, 0x01, 0x06, 0x09, 0x06, 0x14, 0x0A, // "Ň" (U+0147)
  0x01, 0x48, 0x40, 0x01, 0x05, 0x08, 0x05, 0x14, 0x2E, // "ň" (U+0148)
  0x01, 0x49, 0x00, 0x01, 0x07, 0x07, 0x07, 0x14, 0x46, // "ŉ" (U+0149)
  0x01, 0x4A, 0xFF, 0xFF, 0x06, 0x07, 0x06, 0x14, 0x60, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x14, 0x83, // "ŋ" (U+014B)
  0x01, 0x4C, 0x40, 0x01, 0x06, 0x07, 0x06, 0x14, 0x95, // "Ō" (U+014C)
  0x01, 0x4D, 0x40, 0x01, 0x04, 0x06, 0x05, 0x14, 0xAE, // "ō" (U+014D)
  0x01, 0x4E, 0x40, 0x01, 0x06, 0x08, 0x06, 0x14, 0xBD, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x40, 0x01, 0x04, 0x07, 0x05, 0x14, 0xD9, // "ŏ" (U+014F)
  0x01, 0x50, 0x40, 0x01, 0x06, 0x08, 0x06, 0x14, 0xEB, // "Ő" (U+0150)
  0x01, 0x51, 0x40, 0x01, 0x04, 0x07, 0x05, 0x15, 0x07, // "ő" (U+0151)
  0x01, 0x52, 0x40, 0x01, 0x08, 0x07, 0x08, 0x15, 0x19, // "Œ" (U+0152)
  0x01, 0x53, 0x40, 0x01, 0x07, 0x05, 0x07, 0x15, 0x39, // "œ" (U+0153)
  0x01, 0x54, 0xBF, 0x01, 0x05, 0x09, 0x06, 0x15, 0x4D, // "Ŕ" (U+0154)
  0x01, 0x55, 0x00, 0x01, 0x04, 0x08, 0x04, 0x15, 0x6D, // "ŕ" (U+0155)
  0x01, 0x56, 0xBF, 0xFF, 0x05, 0x07, 0x06, 0x15, 0x7F, // "Ŗ" (U+0156)
  0x01, 0x57, 0xFF, 0xFF, 0x04, 0x05, 0x04, 0x15, 0x9F, // "ŗ" (U+0157)
  0x01, 0x58, 0xBF, 0x01, 0x05, 0x09, 0x06, 0x15, 0xB1, // "Ř" (U+0158)
  0x01, 0x59, 0x00, 0x01, 0x04, 0x08, 0x04, 0x15, 0xD1, // "ř" (U+0159)
  0x01, 0x5A, 0x40, 0x01, 0x04, 0x09, 0x05, 0x15, 0xE4, // "Ś" (U+015A)
  0x01, 0x5B, 0x40, 0x01, 0x03, 0x08, 0x04, 0x15, 0xFB, // "ś" (U+015B)
  0x01, 0x5C, 0x40, 0x01, 0x04, 0x09, 0x05, 0x16, 0x0B, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x40, 0x01, 0x03, 0x08, 0x04, 0x16, 0x22, // "ŝ" (U+015D)
  0x01, 0x5E, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x16, 0x32, // "Ş" (U+015E)
  0x01, 0x5F, 0x40, 0xFF, 0x03, 0x05, 0x04, 0x16, 0x49, // "ş" (U+015F)
  0x01, 0x60, 0x40, 0x01, 0x04, 0x09, 0x05, 0x16, 0x57, // "Š" (U+0160)
  0x01, 0x61, 0x40, 0x01, 0x03, 0x08, 0x04, 0x16, 0x6E, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFF, 0x05, 0x07, 0x05, 0x16, 0x7E, // "Ţ" (U+0162)
  0x01, 0x63, 0x40, 0xFF, 0x03, 0x06, 0x03, 0x16, 0x98, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x05, 0x09, 0x05, 0x16, 0xA8, // "Ť" (U+0164)
  0x01, 0x65, 0x40, 0x01, 0x04, 0x07, 0x03, 0x16, 0xC2, // "ť" (U+0165)
  0x01, 0x66, 0x40, 0x01, 0x05, 0x07, 0x05, 0x16, 0xD4, // "Ŧ" (U+0166)
  0x01, 0x67, 0x40, 0x01, 0x03, 0x06, 0x03, 0x16, 0xE9, // "ŧ" (U+0167)
  0x01, 0x68, 0x40, 0x01, 0x06, 0x08, 0x06, 0x16, 0xF5, // "Ũ" (U+0168)
  0x01, 0x69, 0x40, 0x01, 0x05, 0x07, 0x05, 0x17, 0x11, // "ũ" (U+0169)
  0x01, 0x6A, 0x40, 0x01, 0x06, 0x07, 0x06, 0x17, 0x26, // "Ū" (U+016A)
  0x01, 0x6B, 0x40, 0x01, 0x05, 0x06, 0x05, 0x17, 0x3F, // "ū" (U+016B)
  0x01, 0x6C, 0x40, 0x01, 0x06, 0x08, 0x06, 0x17, 0x51, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x40, 0x01, 0x05, 0x07, 0x05, 0x17, 0x6D, // "ŭ" (U+016D)
  0x01, 0x6E, 0x40, 0x01, 0x06, 0x09, 0x06, 0x17, 0x82, // "Ů" (U+016E)
  0x01, 0x6F, 0x40, 0x01, 0x05, 0x08, 0x05, 0x17, 0xA2, // "ů" (U+016F)
  0x01, 0x70, 0x40, 0x01, 0x06, 0x08, 0x06, 0x17, 0xBA, // "Ű" (U+0170)
  0x01, 0x71, 0x40, 0x01, 0x05, 0x07, 0x05, 0x17, 0xD6, // "ű" (U+0171)
  0x01, 0x72, 0x40, 0xFF, 0x06, 0x07, 0x06, 0x17, 0xEB, // "Ų" (U+0172)
  0x01, 0x73, 0x40, 0xFF, 0x05, 0x05, 0x05, 0x18, 0x0B, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x09, 0x09, 0x09, 0x18, 0x20, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x06, 0x08, 0x07, 0x18, 0x4B, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x01, 0x06, 0x09, 0x06, 0x18, 0x66, // "Ŷ" (U+0176)
  0x01, 0x77, 0xFE, 0xFF, 0x04, 0x08, 0x05, 0x18, 0x85, // "ŷ" (U+0177)
  0x01, 0x78, 0x40, 0x01, 0x06, 0x08, 0x06, 0x18, 0xA3, // "Ÿ" (U+0178)
  0x01, 0x79, 0x40, 0x01, 0x05, 0x09, 0x05, 0x18, 0xBF, // "Ź" (U+0179)
  0x01, 0x7A, 0x40, 0x01, 0x04, 0x08, 0x04, 0x18, 0xDA, // "ź" (U+017A)
  0x01, 0x7B, 0x40, 0x01, 0x05, 0x08, 0x05, 0x18, 0xEE, // "Ż" (U+017B)
  0x01, 0x7C, 0x40, 0x01, 0x04, 0x07, 0x04, 0x19, 0x06, // "ż" (U+017C)
  0x01, 0x7D, 0x40, 0x01, 0x05, 0x09, 0x05, 0x19, 0x18, // "Ž" (U+017D)
  0x01, 0x7E, 0x40, 0x01, 0x04, 0x08, 0x04, 0x19, 0x33, // "ž" (U+017E)
  0x01, 0x7F, 0xFF, 0xFF, 0x04, 0x07, 0x03, 0x19, 0x47, // "ſ" (U+017F)
  0x03, 0xA9, 0x40, 0x01, 0x06, 0x07, 0x06, 0x19, 0x60, // "Ω" (U+03A9)
  0x03, 0xBC, 0x40, 0xFF, 0x05, 0x05, 0x05, 0x19, 0x79, // "μ" (U+03BC)
  0x03, 0xC0, 0x40, 0x01, 0x05, 0x05, 0x05, 0x19, 0x8E, // "π" (U+03C0)
  0x20, 0x13, 0x40, 0x03, 0x03, 0x03, 0x04, 0x19, 0x9D, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x03, 0x07, 0x03, 0x08, 0x19, 0x9F, // "—" (U+2014)
  0x20, 0xAC, 0x40, 0x01, 0x04, 0x07, 0x04, 0x19, 0xA1, // "€" (U+20AC)
  0x20, 0xBF, 0xBF, 0x00, 0x04, 0x08, 0x04, 0x19, 0xB3, // "₿" (U+20BF)
  0x20, 0x18, 0x41, 0x05, 0x02, 0x07, 0x02, 0x19, 0xCE, // "‘" (U+2018)
  0x20, 0x19, 0x40, 0x05, 0x02, 0x07, 0x02, 0x19, 0xD1, // "’" (U+2019)
  0x20, 0x1A, 0x40, 0xFF, 0x01, 0x01, 0x02, 0x19, 0xD6, // "‚" (U+201A)
  0x20, 0x1B, 0x41, 0x05, 0x02, 0x07, 0x02, 0x19, 0xD9, // "‛" (U+201B)
  0x20, 0x1C, 0x41, 0x05, 0x04, 0x07, 0x04, 0x19, 0xDC, // "“" (U+201C)
  0x20, 0x1D, 0x40, 0x05, 0x03, 0x07, 0x04, 0x19, 0xE2, // "”" (U+201D)
  0x20, 0x1E, 0x40, 0xFF, 0x03, 0x01, 0x04, 0x19, 0xE8, // "„" (U+201E)
  0x20, 0x1F, 0x41, 0x05, 0x04, 0x07, 0x04, 0x19, 0xEE, // "‟" (U+201F)
  0x20, 0x20, 0x40, 0x00, 0x03, 0x07, 0x04, 0x19, 0xF4, // "†" (U+2020)
  0x20, 0x21, 0x40, 0x00, 0x04, 0x07, 0x04, 0x1A, 0x04, // "‡" (U+2021)
  0x20, 0x22, 0x40, 0x03, 0x02, 0x05, 0x03, 0x1A, 0x18, // "•" (U+2022)
  0x20, 0x26, 0x40, 0x01, 0x06, 0x02, 0x07, 0x1A, 0x1D, // "…" (U+2026)
  0x20, 0x30, 0x00, 0x01, 0x0A, 0x07, 0x0A, 0x1A, 0x24, // "‰" (U+2030)
  0x20, 0x39, 0x40, 0x02, 0x02, 0x05, 0x03, 0x1A, 0x4A, // "‹" (U+2039)
  0x20, 0x3A, 0x40, 0x02, 0x02, 0x05, 0x03, 0x1A, 0x50, // "›" (U+203A)
  0x20, 0x44, 0xFE, 0x01, 0x02, 0x07, 0x01, 0x1A, 0x56, // "⁄" (U+2044)
  0x21, 0x22, 0x40, 0x04, 0x06, 0x06, 0x07, 0x1A, 0x66, // "™" (U+2122)
  0x21, 0x52, 0x00, 0x01, 0x09, 0x07, 0x0A, 0x1A, 0x71, // "⅒" (U+2152)
  0xFB, 0x01, 0xBF, 0xFF, 0x05, 0x07, 0x05, 0x1A, 0x92, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0xBF, 0xFF, 0x05, 0x07, 0x06, 0x1A, 0xB2, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x01, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0xC0, 0x01, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x01, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x01, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x01, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x01, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x01, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xC6, 0x01, // "Æ (U+0022 U+00C6)
  0x00, 0x22, 0x01, 0x00, 0x01, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x02, 0x01, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x04, 0x01, // "Ą (U+0022 U+0104)
  0x00, 0x27, 0x00, 0x41, 0x01, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0xC0, 0x01, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x01, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x01, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x01, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x01, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x01, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xC6, 0x01, // 'Æ (U+0027 U+00C6)
  0x00, 0x27, 0x01, 0x00, 0x01, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x02, 0x01, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x04, 0x01, // 'Ą (U+0027 U+0104)
  0x00, 0x2A, 0x00, 0x2C, 0x01, // *, (U+002A U+002C)
  0x00, 0x2A, 0x00, 0x2E, 0x01, // *. (U+002A U+002E)
  0x00, 0x2A, 0x00, 0xC6, 0x01, // *Æ (U+002A U+00C6)
  0x00, 0x2A, 0x20, 0x1A, 0x01, // *‚ (U+002A U+201A)
  0x00, 0x2A, 0x20, 0x1E, 0x01, // *„ (U+002A U+201E)
  0x00, 0x2A, 0x20, 0x26, 0x01, // *… (U+002A U+2026)
  0x00, 0x2C, 0x00, 0x54, 0x01, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x56, 0x01, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x01, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x01, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0xDD, 0x01, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x01, 0x74, 0x01, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x76, 0x01, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x78, 0x01, // ,Ÿ (U+002C U+0178)
  0x00, 0x2E, 0x00, 0x54, 0x01, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x56, 0x01, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x01, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x01, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0xDD, 0x01, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x01, 0x74, 0x01, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x76, 0x01, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x78, 0x01, // .Ÿ (U+002E U+0178)
  0x00, 0x41, 0x00, 0x22, 0x01, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x01, // A' (U+0041 U+0027)
  0x00, 0x41, 0x00, 0x2A, 0x01, // A* (U+0041 U+002A)
  0x00, 0x41, 0x00, 0x56, 0x01, // AV (U+0041 U+0056)
  0x00, 0x41, 0x00, 0x57, 0x01, // AW (U+0041 U+0057)
  0x00, 0x41, 0x00, 0x59, 0x01, // AY (U+0041 U+0059)
  0x00, 0x41, 0x00, 0xDD, 0x01, // AÝ (U+0041 U+00DD)
  0x00, 0x41, 0x01, 0x74, 0x01, // AŴ (U+0041 U+0174)
  0x00, 0x41, 0x01, 0x76, 0x01, // AŶ (U+0041 U+0176)
  0x00, 0x41, 0x01, 0x78, 0x01, // AŸ (U+0041 U+0178)
  0x00, 0x41, 0x20, 0x18, 0x01, // A‘ (U+0041 U+2018)
  0x00, 0x41, 0x20, 0x19, 0x01, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1C, 0x01, // A“ (U+0041 U+201C)
  0x00, 0x41, 0x20, 0x1D, 0x01, // A” (U+0041 U+201D)
  0x00, 0x41, 0x21, 0x22, 0x01, // A™ (U+0041 U+2122)
  0x00, 0x46, 0x00, 0x2C, 0x01, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x01, // F. (U+0046 U+002E)
  0x00, 0x46, 0x00, 0x41, 0x01, // FA (U+0046 U+0041)
  0x00, 0x46, 0x00, 0xC0, 0x01, // FÀ (U+0046 U+00C0)
  0x00, 0x46, 0x00, 0xC1, 0x01, // FÁ (U+0046 U+00C1)
  0x00, 0x46, 0x00, 0xC2, 0x01, // FÂ (U+0046 U+00C2)
  0x00, 0x46, 0x00, 0xC3, 0x01, // FÃ (U+0046 U+00C3)
  0x00, 0x46, 0x00, 0xC4, 0x01, // FÄ (U+0046 U+00C4)
  0x00, 0x46, 0x00, 0xC5, 0x01, // FÅ (U+0046 U+00C5)
  0x00, 0x46, 0x00, 0xC6, 0x01, // FÆ (U+0046 U+00C6)
  0x00, 0x46, 0x01, 0x00, 0x01, // FĀ (U+0046 U+0100)
  0x00, 0x46, 0x01, 0x02, 0x01, // FĂ (U+0046 U+0102)
  0x00, 0x46, 0x01, 0x04, 0x01, // FĄ (U+0046 U+0104)
  0x00, 0x46, 0x20, 0x1A, 0x01, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x01, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x01, // F… (U+0046 U+2026)
  0x00, 0x4C, 0x00, 0x2A, 0x01, // L* (U+004C U+002A)
  0x00, 0x4C, 0x00, 0x54, 0x01, // LT (U+004C U+0054)
  0x00, 0x4C, 0x00, 0x56, 0x01, // LV (U+004C U+0056)
  0x00, 0x4C, 0x20, 0x18, 0x01, // L‘ (U+004C U+2018)
  0x00, 0x4C, 0x20, 0x19, 0x01, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1C, 0x01, // L“ (U+004C U+201C)
  0x00, 0x4C, 0x20, 0x1D, 0x01, // L” (U+004C U+201D)
  0x00, 0x4C, 0x21, 0x22, 0x01, // L™ (U+004C U+2122)
  0x00, 0x50, 0x00, 0x2C, 0x01, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x01, // P. (U+0050 U+002E)
  0x00, 0x50, 0x00, 0xC6, 0x01, // PÆ (U+0050 U+00C6)
  0x00, 0x50, 0x20, 0x1A, 0x01, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x01, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x01, // P… (U+0050 U+2026)
  0x00, 0x54, 0x00, 0x2C, 0x01, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2E, 0x01, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0xC6, 0x01, // TÆ (U+0054 U+00C6)
  0x00, 0x54, 0x20, 0x1A, 0x01, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x01, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x01, // T… (U+0054 U+2026)
  0x00, 0x56, 0x00, 0x2C, 0x01, // V, (U+0056 U+002C)
  0x00, 0x56, 0x00, 0x2E, 0x01, // V. (U+0056 U+002E)
  0x00, 0x56, 0x00, 0x41, 0x01, // VA (U+0056 U+0041)
  0x00, 0x56, 0x00, 0xC0, 0x01, // VÀ (U+0056 U+00C0)
  0x00, 0x56, 0x00, 0xC1, 0x01, // VÁ (U+0056 U+00C1)
  0x00, 0x56, 0x00, 0xC2, 0x01, // VÂ (U+0056 U+00C2)
  0x00, 0x56, 0x00, 0xC3, 0x01, // VÃ (U+0056 U+00C3)
  0x00, 0x56, 0x00, 0xC4, 0x01, // VÄ (U+0056 U+00C4)
  0x00, 0x56, 0x00, 0xC5, 0x01, // VÅ (U+0056 U+00C5)
  0x00, 0x56, 0x00, 0xC6, 0x01, // VÆ (U+0056 U+00C6)
  0x00, 0x56, 0x01, 0x00, 0x01, // VĀ (U+0056 U+0100)
  0x00, 0x56, 0x01, 0x02, 0x01, // VĂ (U+0056 U+0102)
  0x00, 0x56, 0x01, 0x04, 0x01, // VĄ (U+0056 U+0104)
  0x00, 0x56, 0x20, 0x1A, 0x01, // V‚ (U+0056 U+201A)
  0x00, 0x56, 0x20, 0x1E, 0x01, // V„ (U+0056 U+201E)
  0x00, 0x56, 0x20, 0x26, 0x01, // V… (U+0056 U+2026)
  0x00, 0x57, 0x00, 0x2C, 0x01, // W, (U+0057 U+002C)
  0x00, 0x57, 0x00, 0x2E, 0x01, // W. (U+0057 U+002E)
  0x00, 0x57, 0x00, 0xC6, 0x01, // WÆ (U+0057 U+00C6)
  0x00, 0x57, 0x20, 0x1A, 0x01, // W‚ (U+0057 U+201A)
  0x00, 0x57, 0x20, 0x1E, 0x01, // W„ (U+0057 U+201E)
  0x00, 0x57, 0x20, 0x26, 0x01, // W… (U+0057 U+2026)
  0x00, 0x59, 0x00, 0x2C, 0x01, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x01, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x00, 0x41, 0x01, // YA (U+0059 U+0041)
  0x00, 0x59, 0x00, 0x63, 0x01, // Yc (U+0059 U+0063)
  0x00, 0x59, 0x00, 0x64, 0x01, // Yd (U+0059 U+0064)
  0x00, 0x59, 0x00, 0x65, 0x01, // Ye (U+0059 U+0065)
  0x00, 0x59, 0x00, 0x67, 0x01, // Yg (U+0059 U+0067)
  0x00, 0x59, 0x00, 0x6F, 0x01, // Yo (U+0059 U+006F)
  0x00, 0x59, 0x00, 0x71, 0x01, // Yq (U+0059 U+0071)
  0x00, 0x59, 0x00, 0xC0, 0x01, // YÀ (U+0059 U+00C0)
  0x00, 0x59, 0x00, 0xC1, 0x01, // YÁ (U+0059 U+00C1)
  0x00, 0x59, 0x00, 0xC2, 0x01, // YÂ (U+0059 U+00C2)
  0x00, 0x59, 0x00, 0xC3, 0x01, // YÃ (U+0059 U+00C3)
  0x00, 0x59, 0x00, 0xC4, 0x01, // YÄ (U+0059 U+00C4)
  0x00, 0x59, 0x00, 0xC5, 0x01, // YÅ (U+0059 U+00C5)
  0x00, 0x59, 0x00, 0xC6, 0x01, // YÆ (U+0059 U+00C6)
  0x00, 0x59, 0x00, 0xE7, 0x01, // Yç (U+0059 U+00E7)
  0x00, 0x59, 0x00, 0xE8, 0x01, // Yè (U+0059 U+00E8)
  0x00, 0x59, 0x00, 0xE9, 0x01, // Yé (U+0059 U+00E9)
  0x00, 0x59, 0x00, 0xEA, 0x01, // Yê (U+0059 U+00EA)
  0x00, 0x59, 0x00, 0xEB, 0x01, // Yë (U+0059 U+00EB)
  0x00, 0x59, 0x00, 0xF0, 0x01, // Yð (U+0059 U+00F0)
  0x00, 0x59, 0x00, 0xF2, 0x01, // Yò (U+0059 U+00F2)
  0x00, 0x59, 0x00, 0xF3, 0x01, // Yó (U+0059 U+00F3)
  0x00, 0x59, 0x00, 0xF4, 0x01, // Yô (U+0059 U+00F4)
  0x00, 0x59, 0x00, 0xF5, 0x01, // Yõ (U+0059 U+00F5)
  0x00, 0x59, 0x00, 0xF6, 0x01, // Yö (U+0059 U+00F6)
  0x00, 0x59, 0x00, 0xF8, 0x01, // Yø (U+0059 U+00F8)
  0x00, 0x59, 0x01, 0x00, 0x01, // YĀ (U+0059 U+0100)
  0x00, 0x59, 0x01, 0x02, 0x01, // YĂ (U+0059 U+0102)
  0x00, 0x59, 0x01, 0x04, 0x01, // YĄ (U+0059 U+0104)
  0x00, 0x59, 0x01, 0x07, 0x01, // Yć (U+0059 U+0107)
  0x00, 0x59, 0x01, 0x09, 0x01, // Yĉ (U+0059 U+0109)
  0x00, 0x59, 0x01, 0x0B, 0x01, // Yċ (U+0059 U+010B)
  0x00, 0x59, 0x01, 0x0D, 0x01, // Yč (U+0059 U+010D)
  0x00, 0x59, 0x01, 0x0F, 0x01, // Yď (U+0059 U+010F)
  0x00, 0x59, 0x01, 0x11, 0x01, // Yđ (U+0059 U+0111)
  0x00, 0x59, 0x01, 0x13, 0x01, // Yē (U+0059 U+0113)
  0x00, 0x59, 0x01, 0x15, 0x01, // Yĕ (U+0059 U+0115)
  0x00, 0x59, 0x01, 0x17, 0x01, // Yė (U+0059 U+0117)
  0x00, 0x59, 0x01, 0x19, 0x01, // Yę (U+0059 U+0119)
  0x00, 0x59, 0x01, 0x1B, 0x01, // Yě (U+0059 U+011B)
  0x00, 0x59, 0x01, 0x1D, 0x01, // Yĝ (U+0059 U+011D)
  0x00, 0x59, 0x01, 0x1F, 0x01, // Yğ (U+0059 U+011F)
  0x00, 0x59, 0x01, 0x21, 0x01, // Yġ (U+0059 U+0121)
  0x00, 0x59, 0x01, 0x23, 0x01, // Yģ (U+0059 U+0123)
  0x00, 0x59, 0x01, 0x4D, 0x01, // Yō (U+0059 U+014D)
  0x00, 0x59, 0x01, 0x4F, 0x01, // Yŏ (U+0059 U+014F)
  0x00, 0x59, 0x01, 0x51, 0x01, // Yő (U+0059 U+0151)
  0x00, 0x59, 0x01, 0x53, 0x01, // Yœ (U+0059 U+0153)
  0x00, 0x59, 0x20, 0x1A, 0x01, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x01, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x01, // Y… (U+0059 U+2026)
  0x00, 0x62, 0x00, 0x59, 0x01, // bY (U+0062 U+0059)
  0x00, 0x62, 0x00, 0xDD, 0x01, // bÝ (U+0062 U+00DD)
  0x00, 0x62, 0x01, 0x76, 0x01, // bŶ (U+0062 U+0176)
  0x00, 0x62, 0x01, 0x78, 0x01, // bŸ (U+0062 U+0178)
  0x00, 0x63, 0x00, 0x59, 0x01, // cY (U+0063 U+0059)
  0x00, 0x63, 0x00, 0xDD, 0x01, // cÝ (U+0063 U+00DD)
  0x00, 0x63, 0x01, 0x76, 0x01, // cŶ (U+0063 U+0176)
  0x00, 0x63, 0x01, 0x78, 0x01, // cŸ (U+0063 U+0178)
  0x00, 0x65, 0x00, 0x59, 0x01, // eY (U+0065 U+0059)
  0x00, 0x65, 0x00, 0xDD, 0x01, // eÝ (U+0065 U+00DD)
  0x00, 0x65, 0x01, 0x76, 0x01, // eŶ (U+0065 U+0176)
  0x00, 0x65, 0x01, 0x78, 0x01, // eŸ (U+0065 U+0178)
  0x00, 0x6F, 0x00, 0x59, 0x01, // oY (U+006F U+0059)
  0x00, 0x6F, 0x00, 0xDD, 0x01, // oÝ (U+006F U+00DD)
  0x00, 0x6F, 0x01, 0x76, 0x01, // oŶ (U+006F U+0176)
  0x00, 0x6F, 0x01, 0x78, 0x01, // oŸ (U+006F U+0178)
  0x00, 0x70, 0x00, 0x59, 0x01, // pY (U+0070 U+0059)
  0x00, 0x70, 0x00, 0xDD, 0x01, // pÝ (U+0070 U+00DD)
  0x00, 0x70, 0x01, 0x76, 0x01, // pŶ (U+0070 U+0176)
  0x00, 0x70, 0x01, 0x78, 0x01, // pŸ (U+0070 U+0178)
  0x00, 0x72, 0x00, 0x2C, 0x02, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x02, // r. (U+0072 U+002E)
  0x00, 0x72, 0x20, 0x1A, 0x02, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x02, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x02, // r… (U+0072 U+2026)
  0x00, 0x76, 0x00, 0x2E, 0x01, // v. (U+0076 U+002E)
  0x00, 0x76, 0x20, 0x1A, 0x01, // v‚ (U+0076 U+201A)
  0x00, 0x76, 0x20, 0x1E, 0x01, // v„ (U+0076 U+201E)
  0x00, 0x76, 0x20, 0x26, 0x01, // v… (U+0076 U+2026)
  0x00, 0x77, 0x00, 0x2C, 0x01, // w, (U+0077 U+002C)
  0x00, 0x77, 0x00, 0x2E, 0x01, // w. (U+0077 U+002E)
  0x00, 0x77, 0x20, 0x1A, 0x01, // w‚ (U+0077 U+201A)
  0x00, 0x77, 0x20, 0x1E, 0x01, // w„ (U+0077 U+201E)
  0x00, 0x77, 0x20, 0x26, 0x01, // w… (U+0077 U+2026)
  0x00, 0x79, 0x00, 0x2C, 0x01, // y, (U+0079 U+002C)
  0x00, 0x79, 0x00, 0x2E, 0x01, // y. (U+0079 U+002E)
  0x00, 0x79, 0x20, 0x1A, 0x01, // y‚ (U+0079 U+201A)
  0x00, 0x79, 0x20, 0x1E, 0x01, // y„ (U+0079 U+201E)
  0x00, 0x79, 0x20, 0x26, 0x01, // y… (U+0079 U+2026)
  0x00, 0xC0, 0x00, 0x22, 0x01, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x01, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x00, 0x2A, 0x01, // À* (U+00C0 U+002A)
  0x00, 0xC0, 0x00, 0x56, 0x01, // ÀV (U+00C0 U+0056)
  0x00, 0xC0, 0x00, 0x57, 0x01, // ÀW (U+00C0 U+0057)
  0x00, 0xC0, 0x00, 0x59, 0x01, // ÀY (U+00C0 U+0059)
  0x00, 0xC0, 0x00, 0xDD, 0x01, // ÀÝ (U+00C0 U+00DD)
  0x00, 0xC0, 0x01, 0x74, 0x01, // ÀŴ (U+00C0 U+0174)
  0x00, 0xC0, 0x01, 0x76, 0x01, // ÀŶ (U+00C0 U+0176)
  0x00, 0xC0, 0x01, 0x78, 0x01, // ÀŸ (U+00C0 U+0178)
  0x00, 0xC0, 0x20, 0x18, 0x01, // À‘ (U+00C0 U+2018)
  0x00, 0xC0, 0x20, 0x19, 0x01, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1C, 0x01, // À“ (U+00C0 U+201C)
  0x00, 0xC0, 0x20, 0x1D, 0x01, // À” (U+00C0 U+201D)
  0x00, 0xC0, 0x21, 0x22, 0x01, // À™ (U+00C0 U+2122)
  0x00, 0xC1, 0x00, 0x22, 0x01, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x01, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x00, 0x2A, 0x01, // Á* (U+00C1 U+002A)
  0x00, 0xC1, 0x00, 0x56, 0x01, // ÁV (U+00C1 U+0056)
  0x00, 0xC1, 0x00, 0x57, 0x01, // ÁW (U+00C1 U+0057)
  0x00, 0xC1, 0x00, 0x59, 0x01, // ÁY (U+00C1 U+0059)
  0x00, 0xC1, 0x00, 0xDD, 0x01, // ÁÝ (U+00C1 U+00DD)
  0x00, 0xC1, 0x01, 0x74, 0x01, // ÁŴ (U+00C1 U+0174)
  0x00, 0xC1, 0x01, 0x76, 0x01, // ÁŶ (U+00C1 U+0176)
  0x00, 0xC1, 0x01, 0x78, 0x01, // ÁŸ (U+00C1 U+0178)
  0x00, 0xC1, 0x20, 0x18, 0x01, // Á‘ (U+00C1 U+2018)
  0x00, 0xC1, 0x20, 0x19, 0x01, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1C, 0x01, // Á“ (U+00C1 U+201C)
  0x00, 0xC1, 0x20, 0x1D, 0x01, // Á” (U+00C1 U+201D)
  0x00, 0xC1, 0x21, 0x22, 0x01, // Á™ (U+00C1 U+2122)
  0x00, 0xC2, 0x00, 0x22, 0x01, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x01, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x00, 0x2A, 0x01, // Â* (U+00C2 U+002A)
  0x00, 0xC2, 0x00, 0x56, 0x01, // ÂV (U+00C2 U+0056)
  0x00, 0xC2, 0x00, 0x57, 0x01, // ÂW (U+00C2 U+0057)
  0x00, 0xC2, 0x00, 0x59, 0x01, // ÂY (U+00C2 U+0059)
  0x00, 0xC2, 0x00, 0xDD, 0x01, // ÂÝ (U+00C2 U+00DD)
  0x00, 0xC2, 0x01, 0x74, 0x01, // ÂŴ (U+00C2 U+0174)
  0x00, 0xC2, 0x01, 0x76, 0x01, // ÂŶ (U+00C2 U+0176)
  0x00, 0xC2, 0x01, 0x78, 0x01, // ÂŸ (U+00C2 U+0178)
  0x00, 0xC2, 0x20, 0x18, 0x01, // Â‘ (U+00C2 U+2018)
  0x00, 0xC2, 0x20, 0x19, 0x01, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1C, 0x01, // Â“ (U+00C2 U+201C)
  0x00, 0xC2, 0x20, 0x1D, 0x01, // Â” (U+00C2 U+201D)
  0x00, 0xC2, 0x21, 0x22, 0x01, // Â™ (U+00C2 U+2122)
  0x00, 0xC3, 0x00, 0x22, 0x01, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x01, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x00, 0x2A, 0x01, // Ã* (U+00C3 U+002A)
  0x00, 0xC3, 0x00, 0x56, 0x01, // ÃV (U+00C3 U+0056)
  0x00, 0xC3, 0x00, 0x57, 0x01, // ÃW (U+00C3 U+0057)
  0x00, 0xC3, 0x00, 0x59, 0x01, // ÃY (U+00C3 U+0059)
  0x00, 0xC3, 0x00, 0xDD, 0x01, // ÃÝ (U+00C3 U+00DD)
  0x00, 0xC3, 0x01, 0x74, 0x01, // ÃŴ (U+00C3 U+0174)
  0x00, 0xC3, 0x01, 0x76, 0x01, // ÃŶ (U+00C3 U+0176)
  0x00, 0xC3, 0x01, 0x78, 0x01, // ÃŸ (U+00C3 U+0178)
  0x00, 0xC3, 0x20, 0x18, 0x01, // Ã‘ (U+00C3 U+2018)
  0x00, 0xC3, 0x20, 0x19, 0x01, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1C, 0x01, // Ã“ (U+00C3 U+201C)
  0x00, 0xC3, 0x20, 0x1D, 0x01, // Ã” (U+00C3 U+201D)
  0x00, 0xC3, 0x21, 0x22, 0x01, // Ã™ (U+00C3 U+2122)
  0x00, 0xC4, 0x00, 0x22, 0x01, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x01, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x00, 0x2A, 0x01, // Ä* (U+00C4 U+002A)
  0x00, 0xC4, 0x00, 0x56, 0x01, // ÄV (U+00C4 U+0056)
  0x00, 0xC4, 0x00, 0x57, 0x01, // ÄW (U+00C4 U+0057)
  0x00, 0xC4, 0x00, 0x59, 0x01, // ÄY (U+00C4 U+0059)
  0x00, 0xC4, 0x00, 0xDD, 0x01, // ÄÝ (U+00C4 U+00DD)
  0x00, 0xC4, 0x01, 0x74, 0x01, // ÄŴ (U+00C4 U+0174)
  0x00, 0xC4, 0x01, 0x76, 0x01, // ÄŶ (U+00C4 U+0176)
  0x00, 0xC4, 0x01, 0x78, 0x01, // ÄŸ (U+00C4 U+0178)
  0x00, 0xC4, 0x20, 0x18, 0x01, // Ä‘ (U+00C4 U+2018)
  0x00, 0xC4, 0x20, 0x19, 0x01, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1C, 0x01, // Ä“ (U+00C4 U+201C)
  0x00, 0xC4, 0x20, 0x1D, 0x01, // Ä” (U+00C4 U+201D)
  0x00, 0xC4, 0x21, 0x22, 0x01, // Ä™ (U+00C4 U+2122)
  0x00, 0xC5, 0x00, 0x22, 0x01, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x01, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x00, 0x2A, 0x01, // Å* (U+00C5 U+002A)
  0x00, 0xC5, 0x00, 0x56, 0x01, // ÅV (U+00C5 U+0056)
  0x00, 0xC5, 0x00, 0x57, 0x01, // ÅW (U+00C5 U+0057)
  0x00, 0xC5, 0x00, 0x59, 0x01, // ÅY (U+00C5 U+0059)
  0x00, 0xC5, 0x00, 0xDD, 0x01, // ÅÝ (U+00C5 U+00DD)
  0x00, 0xC5, 0x01, 0x74, 0x01, // ÅŴ (U+00C5 U+0174)
  0x00, 0xC5, 0x01, 0x76, 0x01, // ÅŶ (U+00C5 U+0176)
  0x00, 0xC5, 0x01, 0x78, 0x01, // ÅŸ (U+00C5 U+0178)
  0x00, 0xC5, 0x20, 0x18, 0x01, // Å‘ (U+00C5 U+2018)
  0x00, 0xC5, 0x20, 0x19, 0x01, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1C, 0x01, // Å“ (U+00C5 U+201C)
  0x00, 0xC5, 0x20, 0x1D, 0x01, // Å” (U+00C5 U+201D)
  0x00, 0xC5, 0x21, 0x22, 0x01, // Å™ (U+00C5 U+2122)
  0x00, 0xDD, 0x00, 0x2C, 0x01, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x01, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x00, 0x41, 0x01, // ÝA (U+00DD U+0041)
  0x00, 0xDD, 0x00, 0x63, 0x01, // Ýc (U+00DD U+0063)
  0x00, 0xDD, 0x00, 0x64, 0x01, // Ýd (U+00DD U+0064)
  0x00, 0xDD, 0x00, 0x65, 0x01, // Ýe (U+00DD U+0065)
  0x00, 0xDD, 0x00, 0x67, 0x01, // Ýg (U+00DD U+0067)
  0x00, 0xDD, 0x00, 0x6F, 0x01, // Ýo (U+00DD U+006F)
  0x00, 0xDD, 0x00, 0x71, 0x01, // Ýq (U+00DD U+0071)
  0x00, 0xDD, 0x00, 0xC0, 0x01, // ÝÀ (U+00DD U+00C0)
  0x00, 0xDD, 0x00, 0xC1, 0x01, // ÝÁ (U+00DD U+00C1)
  0x00, 0xDD, 0x00, 0xC2, 0x01, // ÝÂ (U+00DD U+00C2)
  0x00, 0xDD, 0x00, 0xC3, 0x01, // ÝÃ (U+00DD U+00C3)
  0x00, 0xDD, 0x00, 0xC4, 0x01, // ÝÄ (U+00DD U+00C4)
  0x00, 0xDD, 0x00, 0xC5, 0x01, // ÝÅ (U+00DD U+00C5)
  0x00, 0xDD, 0x00, 0xC6, 0x01, // ÝÆ (U+00DD U+00C6)
  0x00, 0xDD, 0x00, 0xE7, 0x01, // Ýç (U+00DD U+00E7)
  0x00, 0xDD, 0x00, 0xE8, 0x01, // Ýè (U+00DD U+00E8)
  0x00, 0xDD, 0x00, 0xE9, 0x01, // Ýé (U+00DD U+00E9)
  0x00, 0xDD, 0x00, 0xEA, 0x01, // Ýê (U+00DD U+00EA)
  0x00, 0xDD, 0x00, 0xEB, 0x01, // Ýë (U+00DD U+00EB)
  0x00, 0xDD, 0x00, 0xF0, 0x01, // Ýð (U+00DD U+00F0)
  0x00, 0xDD, 0x00, 0xF2, 0x01, // Ýò (U+00DD U+00F2)
  0x00, 0xDD, 0x00, 0xF3, 0x01, // Ýó (U+00DD U+00F3)
  0x00, 0xDD, 0x00, 0xF4, 0x01, // Ýô (U+00DD U+00F4)
  0x00, 0xDD, 0x00, 0xF5, 0x01, // Ýõ (U+00DD U+00F5)
  0x00, 0xDD, 0x00, 0xF6, 0x01, // Ýö (U+00DD U+00F6)
  0x00, 0xDD, 0x00, 0xF8, 0x01, // Ýø (U+00DD U+00F8)
  0x00, 0xDD, 0x01, 0x00, 0x01, // ÝĀ (U+00DD U+0100)
  0x00, 0xDD, 0x01, 0x02, 0x01, // ÝĂ (U+00DD U+0102)
  0x00, 0xDD, 0x01, 0x04, 0x01, // ÝĄ (U+00DD U+0104)
  0x00, 0xDD, 0x01, 0x07, 0x01, // Ýć (U+00DD U+0107)
  0x00, 0xDD, 0x01, 0x09, 0x01, // Ýĉ (U+00DD U+0109)
  0x00, 0xDD, 0x01, 0x0B, 0x01, // Ýċ (U+00DD U+010B)
  0x00, 0xDD, 0x01, 0x0D, 0x01, // Ýč (U+00DD U+010D)
  0x00, 0xDD, 0x01, 0x0F, 0x01, // Ýď (U+00DD U+010F)
  0x00, 0xDD, 0x01, 0x11, 0x01, // Ýđ (U+00DD U+0111)
  0x00, 0xDD, 0x01, 0x13, 0x01, // Ýē (U+00DD U+0113)
  0x00, 0xDD, 0x01, 0x15, 0x01, // Ýĕ (U+00DD U+0115)
  0x00, 0xDD, 0x01, 0x17, 0x01, // Ýė (U+00DD U+0117)
  0x00, 0xDD, 0x01, 0x19, 0x01, // Ýę (U+00DD U+0119)
  0x00, 0xDD, 0x01, 0x1B, 0x01, // Ýě (U+00DD U+011B)
  0x00, 0xDD, 0x01, 0x1D, 0x01, // Ýĝ (U+00DD U+011D)
  0x00, 0xDD, 0x01, 0x1F, 0x01, // Ýğ (U+00DD U+011F)
  0x00, 0xDD, 0x01, 0x21, 0x01, // Ýġ (U+00DD U+0121)
  0x00, 0xDD, 0x01, 0x23, 0x01, // Ýģ (U+00DD U+0123)
  0x00, 0xDD, 0x01, 0x4D, 0x01, // Ýō (U+00DD U+014D)
  0x00, 0xDD, 0x01, 0x4F, 0x01, // Ýŏ (U+00DD U+014F)
  0x00, 0xDD, 0x01, 0x51, 0x01, // Ýő (U+00DD U+0151)
  0x00, 0xDD, 0x01, 0x53, 0x01, // Ýœ (U+00DD U+0153)
  0x00, 0xDD, 0x20, 0x1A, 0x01, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x01, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x01, // Ý… (U+00DD U+2026)
  0x00, 0xE6, 0x00, 0x59, 0x01, // æY (U+00E6 U+0059)
  0x00, 0xE6, 0x00, 0xDD, 0x01, // æÝ (U+00E6 U+00DD)
  0x00, 0xE6, 0x01, 0x76, 0x01, // æŶ (U+00E6 U+0176)
  0x00, 0xE6, 0x01, 0x78, 0x01, // æŸ (U+00E6 U+0178)
  0x00, 0xE7, 0x00, 0x59, 0x01, // çY (U+00E7 U+0059)
  0x00, 0xE7, 0x00, 0xDD, 0x01, // çÝ (U+00E7 U+00DD)
  0x00, 0xE7, 0x01, 0x76, 0x01, // çŶ (U+00E7 U+0176)
  0x00, 0xE7, 0x01, 0x78, 0x01, // çŸ (U+00E7 U+0178)
  0x00, 0xE8, 0x00, 0x59, 0x01, // èY (U+00E8 U+0059)
  0x00, 0xE8, 0x00, 0xDD, 0x01, // èÝ (U+00E8 U+00DD)
  0x00, 0xE8, 0x01, 0x76, 0x01, // èŶ (U+00E8 U+0176)
  0x00, 0xE8, 0x01, 0x78, 0x01, // èŸ (U+00E8 U+0178)
  0x00, 0xE9, 0x00, 0x59, 0x01, // éY (U+00E9 U+0059)
  0x00, 0xE9, 0x00, 0xDD, 0x01, // éÝ (U+00E9 U+00DD)
  0x00, 0xE9, 0x01, 0x76, 0x01, // éŶ (U+00E9 U+0176)
  0x00, 0xE9, 0x01, 0x78, 0x01, // éŸ (U+00E9 U+0178)
  0x00, 0xEA, 0x00, 0x59, 0x01, // êY (U+00EA U+0059)
  0x00, 0xEA, 0x00, 0xDD, 0x01, // êÝ (U+00EA U+00DD)
  0x00, 0xEA, 0x01, 0x76, 0x01, // êŶ (U+00EA U+0176)
  0x00, 0xEA, 0x01, 0x78, 0x01, // êŸ (U+00EA U+0178)
  0x00, 0xEB, 0x00, 0x59, 0x01, // ëY (U+00EB U+0059)
  0x00, 0xEB, 0x00, 0xDD, 0x01, // ëÝ (U+00EB U+00DD)
  0x00, 0xEB, 0x01, 0x76, 0x01, // ëŶ (U+00EB U+0176)
  0x00, 0xEB, 0x01, 0x78, 0x01, // ëŸ (U+00EB U+0178)
  0x00, 0xF0, 0x00, 0x59, 0x01, // ðY (U+00F0 U+0059)
  0x00, 0xF0, 0x00, 0xDD, 0x01, // ðÝ (U+00F0 U+00DD)
  0x00, 0xF0, 0x01, 0x76, 0x01, // ðŶ (U+00F0 U+0176)
  0x00, 0xF0, 0x01, 0x78, 0x01, // ðŸ (U+00F0 U+0178)
  0x00, 0xF2, 0x00, 0x59, 0x01, // òY (U+00F2 U+0059)
  0x00, 0xF2, 0x00, 0xDD, 0x01, // òÝ (U+00F2 U+00DD)
  0x00, 0xF2, 0x01, 0x76, 0x01, // òŶ (U+00F2 U+0176)
  0x00, 0xF2, 0x01, 0x78, 0x01, // òŸ (U+00F2 U+0178)
  0x00, 0xF3, 0x00, 0x59, 0x01, // óY (U+00F3 U+0059)
  0x00, 0xF3, 0x00, 0xDD, 0x01, // óÝ (U+00F3 U+00DD)
  0x00, 0xF3, 0x01, 0x76, 0x01, // óŶ (U+00F3 U+0176)
  0x00, 0xF3, 0x01, 0x78, 0x01, // óŸ (U+00F3 U+0178)
  0x00, 0xF4, 0x00, 0x59, 0x01, // ôY (U+00F4 U+0059)
  0x00, 0xF4, 0x00, 0xDD, 0x01, // ôÝ (U+00F4 U+00DD)
  0x00, 0xF4, 0x01, 0x76, 0x01, // ôŶ (U+00F4 U+0176)
  0x00, 0xF4, 0x01, 0x78, 0x01, // ôŸ (U+00F4 U+0178)
  0x00, 0xF5, 0x00, 0x59, 0x01, // õY (U+00F5 U+0059)
  0x00, 0xF5, 0x00, 0xDD, 0x01, // õÝ (U+00F5 U+00DD)
  0x00, 0xF5, 0x01, 0x76, 0x01, // õŶ (U+00F5 U+0176)
  0x00, 0xF5, 0x01, 0x78, 0x01, // õŸ (U+00F5 U+0178)
  0x00, 0xF6, 0x00, 0x59, 0x01, // öY (U+00F6 U+0059)
  0x00, 0xF6, 0x00, 0xDD, 0x01, // öÝ (U+00F6 U+00DD)
  0x00, 0xF6, 0x01, 0x76, 0x01, // öŶ (U+00F6 U+0176)
  0x00, 0xF6, 0x01, 0x78, 0x01, // öŸ (U+00F6 U+0178)
  0x00, 0xF8, 0x00, 0x59, 0x01, // øY (U+00F8 U+0059)
  0x00, 0xF8, 0x00, 0xDD, 0x01, // øÝ (U+00F8 U+00DD)
  0x00, 0xF8, 0x01, 0x76, 0x01, // øŶ (U+00F8 U+0176)
  0x00, 0xF8, 0x01, 0x78, 0x01, // øŸ (U+00F8 U+0178)
  0x00, 0xFD, 0x00, 0x2C, 0x01, // ý, (U+00FD U+002C)
  0x00, 0xFD, 0x00, 0x2E, 0x01, // ý. (U+00FD U+002E)
  0x00, 0xFD, 0x20, 0x1A, 0x01, // ý‚ (U+00FD U+201A)
  0x00, 0xFD, 0x20, 0x1E, 0x01, // ý„ (U+00FD U+201E)
  0x00, 0xFD, 0x20, 0x26, 0x01, // ý… (U+00FD U+2026)
  0x00, 0xFE, 0x00, 0x59, 0x01, // þY (U+00FE U+0059)
  0x00, 0xFE, 0x00, 0xDD, 0x01, // þÝ (U+00FE U+00DD)
  0x00, 0xFE, 0x01, 0x76, 0x01, // þŶ (U+00FE U+0176)
  0x00, 0xFE, 0x01, 0x78, 0x01, // þŸ (U+00FE U+0178)
  0x00, 0xFF, 0x00, 0x2C, 0x01, // ÿ, (U+00FF U+002C)
  0x00, 0xFF, 0x00, 0x2E, 0x01, // ÿ. (U+00FF U+002E)
  0x00, 0xFF, 0x20, 0x1A, 0x01, // ÿ‚ (U+00FF U+201A)
  0x00, 0xFF, 0x20, 0x1E, 0x01, // ÿ„ (U+00FF U+201E)
  0x00, 0xFF, 0x20, 0x26, 0x01, // ÿ… (U+00FF U+2026)
  0x01, 0x00, 0x00, 0x22, 0x01, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x01, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x00, 0x2A, 0x01, // Ā* (U+0100 U+002A)
  0x01, 0x00, 0x00, 0x56, 0x01, // ĀV (U+0100 U+0056)
  0x01, 0x00, 0x00, 0x57, 0x01, // ĀW (U+0100 U+0057)
  0x01, 0x00, 0x00, 0x59, 0x01, // ĀY (U+0100 U+0059)
  0x01, 0x00, 0x00, 0xDD, 0x01, // ĀÝ (U+0100 U+00DD)
  0x01, 0x00, 0x01, 0x74, 0x01, // ĀŴ (U+0100 U+0174)
  0x01, 0x00, 0x01, 0x76, 0x01, // ĀŶ (U+0100 U+0176)
  0x01, 0x00, 0x01, 0x78, 0x01, // ĀŸ (U+0100 U+0178)
  0x01, 0x00, 0x20, 0x18, 0x01, // Ā‘ (U+0100 U+2018)
  0x01, 0x00, 0x20, 0x19, 0x01, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1C, 0x01, // Ā“ (U+0100 U+201C)
  0x01, 0x00, 0x20, 0x1D, 0x01, // Ā” (U+0100 U+201D)
  0x01, 0x00, 0x21, 0x22, 0x01, // Ā™ (U+0100 U+2122)
  0x01, 0x02, 0x00, 0x22, 0x01, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x01, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x00, 0x2A, 0x01, // Ă* (U+0102 U+002A)
  0x01, 0x02, 0x00, 0x56, 0x01, // ĂV (U+0102 U+0056)
  0x01, 0x02, 0x00, 0x57, 0x01, // ĂW (U+0102 U+0057)
  0x01, 0x02, 0x00, 0x59, 0x01, // ĂY (U+0102 U+0059)
  0x01, 0x02, 0x00, 0xDD, 0x01, // ĂÝ (U+0102 U+00DD)
  0x01, 0x02, 0x01, 0x74, 0x01, // ĂŴ (U+0102 U+0174)
  0x01, 0x02, 0x01, 0x76, 0x01, // ĂŶ (U+0102 U+0176)
  0x01, 0x02, 0x01, 0x78, 0x01, // ĂŸ (U+0102 U+0178)
  0x01, 0x02, 0x20, 0x18, 0x01, // Ă‘ (U+0102 U+2018)
  0x01, 0x02, 0x20, 0x19, 0x01, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1C, 0x01, // Ă“ (U+0102 U+201C)
  0x01, 0x02, 0x20, 0x1D, 0x01, // Ă” (U+0102 U+201D)
  0x01, 0x02, 0x21, 0x22, 0x01, // Ă™ (U+0102 U+2122)
  0x01, 0x04, 0x00, 0x22, 0x01, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x01, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x00, 0x2A, 0x01, // Ą* (U+0104 U+002A)
  0x01, 0x04, 0x00, 0x56, 0x01, // ĄV (U+0104 U+0056)
  0x01, 0x04, 0x00, 0x57, 0x01, // ĄW (U+0104 U+0057)
  0x01, 0x04, 0x00, 0x59, 0x01, // ĄY (U+0104 U+0059)
  0x01, 0x04, 0x00, 0xDD, 0x01, // ĄÝ (U+0104 U+00DD)
  0x01, 0x04, 0x01, 0x74, 0x01, // ĄŴ (U+0104 U+0174)
  0x01, 0x04, 0x01, 0x76, 0x01, // ĄŶ (U+0104 U+0176)
  0x01, 0x04, 0x01, 0x78, 0x01, // ĄŸ (U+0104 U+0178)
  0x01, 0x04, 0x20, 0x18, 0x01, // Ą‘ (U+0104 U+2018)
  0x01, 0x04, 0x20, 0x19, 0x01, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1C, 0x01, // Ą“ (U+0104 U+201C)
  0x01, 0x04, 0x20, 0x1D, 0x01, // Ą” (U+0104 U+201D)
  0x01, 0x04, 0x21, 0x22, 0x01, // Ą™ (U+0104 U+2122)
  0x01, 0x07, 0x00, 0x59, 0x01, // ćY (U+0107 U+0059)
  0x01, 0x07, 0x00, 0xDD, 0x01, // ćÝ (U+0107 U+00DD)
  0x01, 0x07, 0x01, 0x76, 0x01, // ćŶ (U+0107 U+0176)
  0x01, 0x07, 0x01, 0x78, 0x01, // ćŸ (U+0107 U+0178)
  0x01, 0x09, 0x00, 0x59, 0x01, // ĉY (U+0109 U+0059)
  0x01, 0x09, 0x00, 0xDD, 0x01, // ĉÝ (U+0109 U+00DD)
  0x01, 0x09, 0x01, 0x76, 0x01, // ĉŶ (U+0109 U+0176)
  0x01, 0x09, 0x01, 0x78, 0x01, // ĉŸ (U+0109 U+0178)
  0x01, 0x0B, 0x00, 0x59, 0x01, // ċY (U+010B U+0059)
  0x01, 0x0B, 0x00, 0xDD, 0x01, // ċÝ (U+010B U+00DD)
  0x01, 0x0B, 0x01, 0x76, 0x01, // ċŶ (U+010B U+0176)
  0x01, 0x0B, 0x01, 0x78, 0x01, // ċŸ (U+010B U+0178)
  0x01, 0x0D, 0x00, 0x59, 0x01, // čY (U+010D U+0059)
  0x01, 0x0D, 0x00, 0xDD, 0x01, // čÝ (U+010D U+00DD)
  0x01, 0x0D, 0x01, 0x76, 0x01, // čŶ (U+010D U+0176)
  0x01, 0x0D, 0x01, 0x78, 0x01, // čŸ (U+010D U+0178)
  0x01, 0x13, 0x00, 0x59, 0x01, // ēY (U+0113 U+0059)
  0x01, 0x13, 0x00, 0xDD, 0x01, // ēÝ (U+0113 U+00DD)
  0x01, 0x13, 0x01, 0x76, 0x01, // ēŶ (U+0113 U+0176)
  0x01, 0x13, 0x01, 0x78, 0x01, // ēŸ (U+0113 U+0178)
  0x01, 0x15, 0x00, 0x59, 0x01, // ĕY (U+0115 U+0059)
  0x01, 0x15, 0x00, 0xDD, 0x01, // ĕÝ (U+0115 U+00DD)
  0x01, 0x15, 0x01, 0x76, 0x01, // ĕŶ (U+0115 U+0176)
  0x01, 0x15, 0x01, 0x78, 0x01, // ĕŸ (U+0115 U+0178)
  0x01, 0x17, 0x00, 0x59, 0x01, // ėY (U+0117 U+0059)
  0x01, 0x17, 0x00, 0xDD, 0x01, // ėÝ (U+0117 U+00DD)
  0x01, 0x17, 0x01, 0x76, 0x01, // ėŶ (U+0117 U+0176)
  0x01, 0x17, 0x01, 0x78, 0x01, // ėŸ (U+0117 U+0178)
  0x01, 0x19, 0x00, 0x59, 0x01, // ęY (U+0119 U+0059)
  0x01, 0x19, 0x00, 0xDD, 0x01, // ęÝ (U+0119 U+00DD)
  0x01, 0x19, 0x01, 0x76, 0x01, // ęŶ (U+0119 U+0176)
  0x01, 0x19, 0x01, 0x78, 0x01, // ęŸ (U+0119 U+0178)
  0x01, 0x1B, 0x00, 0x59, 0x01, // ěY (U+011B U+0059)
  0x01, 0x1B, 0x00, 0xDD, 0x01, // ěÝ (U+011B U+00DD)
  0x01, 0x1B, 0x01, 0x76, 0x01, // ěŶ (U+011B U+0176)
  0x01, 0x1B, 0x01, 0x78, 0x01, // ěŸ (U+011B U+0178)
  0x01, 0x39, 0x00, 0x2A, 0x01, // Ĺ* (U+0139 U+002A)
  0x01, 0x39, 0x00, 0x54, 0x01, // ĹT (U+0139 U+0054)
  0x01, 0x39, 0x00, 0x56, 0x01, // ĹV (U+0139 U+0056)
  0x01, 0x39, 0x20, 0x18, 0x01, // Ĺ‘ (U+0139 U+2018)
  0x01, 0x39, 0x20, 0x19, 0x01, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1C, 0x01, // Ĺ“ (U+0139 U+201C)
  0x01, 0x39, 0x20, 0x1D, 0x01, // Ĺ” (U+0139 U+201D)
  0x01, 0x39, 0x21, 0x22, 0x01, // Ĺ™ (U+0139 U+2122)
  0x01, 0x3B, 0x00, 0x2A, 0x01, // Ļ* (U+013B U+002A)
  0x01, 0x3B, 0x00, 0x54, 0x01, // ĻT (U+013B U+0054)
  0x01, 0x3B, 0x00, 0x56, 0x01, // ĻV (U+013B U+0056)
  0x01, 0x3B, 0x20, 0x18, 0x01, // Ļ‘ (U+013B U+2018)
  0x01, 0x3B, 0x20, 0x19, 0x01, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1C, 0x01, // Ļ“ (U+013B U+201C)
  0x01, 0x3B, 0x20, 0x1D, 0x01, // Ļ” (U+013B U+201D)
  0x01, 0x3B, 0x21, 0x22, 0x01, // Ļ™ (U+013B U+2122)
  0x01, 0x41, 0x00, 0x2A, 0x01, // Ł* (U+0141 U+002A)
  0x01, 0x41, 0x00, 0x54, 0x01, // ŁT (U+0141 U+0054)
  0x01, 0x41, 0x00, 0x56, 0x01, // ŁV (U+0141 U+0056)
  0x01, 0x41, 0x20, 0x18, 0x01, // Ł‘ (U+0141 U+2018)
  0x01, 0x41, 0x20, 0x19, 0x01, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1C, 0x01, // Ł“ (U+0141 U+201C)
  0x01, 0x41, 0x20, 0x1D, 0x01, // Ł” (U+0141 U+201D)
  0x01, 0x41, 0x21, 0x22, 0x01, // Ł™ (U+0141 U+2122)
  0x01, 0x4D, 0x00, 0x59, 0x01, // ōY (U+014D U+0059)
  0x01, 0x4D, 0x00, 0xDD, 0x01, // ōÝ (U+014D U+00DD)
  0x01, 0x4D, 0x01, 0x76, 0x01, // ōŶ (U+014D U+0176)
  0x01, 0x4D, 0x01, 0x78, 0x01, // ōŸ (U+014D U+0178)
  0x01, 0x4F, 0x00, 0x59, 0x01, // ŏY (U+014F U+0059)
  0x01, 0x4F, 0x00, 0xDD, 0x01, // ŏÝ (U+014F U+00DD)
  0x01, 0x4F, 0x01, 0x76, 0x01, // ŏŶ (U+014F U+0176)
  0x01, 0x4F, 0x01, 0x78, 0x01, // ŏŸ (U+014F U+0178)
  0x01, 0x51, 0x00, 0x59, 0x01, // őY (U+0151 U+0059)
  0x01, 0x51, 0x00, 0xDD, 0x01, // őÝ (U+0151 U+00DD)
  0x01, 0x51, 0x01, 0x76, 0x01, // őŶ (U+0151 U+0176)
  0x01, 0x51, 0x01, 0x78, 0x01, // őŸ (U+0151 U+0178)
  0x01, 0x53, 0x00, 0x59, 0x01, // œY (U+0153 U+0059)
  0x01, 0x53, 0x00, 0xDD, 0x01, // œÝ (U+0153 U+00DD)
  0x01, 0x53, 0x01, 0x76, 0x01, // œŶ (U+0153 U+0176)
  0x01, 0x53, 0x01, 0x78, 0x01, // œŸ (U+0153 U+0178)
  0x01, 0x55, 0x00, 0x2C, 0x02, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x02, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x20, 0x1A, 0x02, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x02, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x02, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x02, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x02, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x20, 0x1A, 0x02, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x02, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x02, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x02, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x02, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x20, 0x1A, 0x02, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x02, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x02, // ř… (U+0159 U+2026)
  0x01, 0x62, 0x00, 0x2C, 0x01, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2E, 0x01, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0xC6, 0x01, // ŢÆ (U+0162 U+00C6)
  0x01, 0x62, 0x20, 0x1A, 0x01, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x01, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x01, // Ţ… (U+0162 U+2026)
  0x01, 0x64, 0x00, 0x2C, 0x01, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2E, 0x01, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0xC6, 0x01, // ŤÆ (U+0164 U+00C6)
  0x01, 0x64, 0x20, 0x1A, 0x01, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x01, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x01, // Ť… (U+0164 U+2026)
  0x01, 0x66, 0x00, 0x2C, 0x01, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2E, 0x01, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0xC6, 0x01, // ŦÆ (U+0166 U+00C6)
  0x01, 0x66, 0x20, 0x1A, 0x01, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x01, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x01, // Ŧ… (U+0166 U+2026)
  0x01, 0x74, 0x00, 0x2C, 0x01, // Ŵ, (U+0174 U+002C)
  0x01, 0x74, 0x00, 0x2E, 0x01, // Ŵ. (U+0174 U+002E)
  0x01, 0x74, 0x00, 0xC6, 0x01, // ŴÆ (U+0174 U+00C6)
  0x01, 0x74, 0x20, 0x1A, 0x01, // Ŵ‚ (U+0174 U+201A)
  0x01, 0x74, 0x20, 0x1E, 0x01, // Ŵ„ (U+0174 U+201E)
  0x01, 0x74, 0x20, 0x26, 0x01, // Ŵ… (U+0174 U+2026)
  0x01, 0x75, 0x00, 0x2C, 0x01, // ŵ, (U+0175 U+002C)
  0x01, 0x75, 0x00, 0x2E, 0x01, // ŵ. (U+0175 U+002E)
  0x01, 0x75, 0x20, 0x1A, 0x01, // ŵ‚ (U+0175 U+201A)
  0x01, 0x75, 0x20, 0x1E, 0x01, // ŵ„ (U+0175 U+201E)
  0x01, 0x75, 0x20, 0x26, 0x01, // ŵ… (U+0175 U+2026)
  0x01, 0x76, 0x00, 0x2C, 0x01, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x01, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x00, 0x41, 0x01, // ŶA (U+0176 U+0041)
  0x01, 0x76, 0x00, 0x63, 0x01, // Ŷc (U+0176 U+0063)
  0x01, 0x76, 0x00, 0x64, 0x01, // Ŷd (U+0176 U+0064)
  0x01, 0x76, 0x00, 0x65, 0x01, // Ŷe (U+0176 U+0065)
  0x01, 0x76, 0x00, 0x67, 0x01, // Ŷg (U+0176 U+0067)
  0x01, 0x76, 0x00, 0x6F, 0x01, // Ŷo (U+0176 U+006F)
  0x01, 0x76, 0x00, 0x71, 0x01, // Ŷq (U+0176 U+0071)
  0x01, 0x76, 0x00, 0xC0, 0x01, // ŶÀ (U+0176 U+00C0)
  0x01, 0x76, 0x00, 0xC1, 0x01, // ŶÁ (U+0176 U+00C1)
  0x01, 0x76, 0x00, 0xC2, 0x01, // ŶÂ (U+0176 U+00C2)
  0x01, 0x76, 0x00, 0xC3, 0x01, // ŶÃ (U+0176 U+00C3)
  0x01, 0x76, 0x00, 0xC4, 0x01, // ŶÄ (U+0176 U+00C4)
  0x01, 0x76, 0x00, 0xC5, 0x01, // ŶÅ (U+0176 U+00C5)
  0x01, 0x76, 0x00, 0xC6, 0x01, // ŶÆ (U+0176 U+00C6)
  0x01, 0x76, 0x00, 0xE7, 0x01, // Ŷç (U+0176 U+00E7)
  0x01, 0x76, 0x00, 0xE8, 0x01, // Ŷè (U+0176 U+00E8)
  0x01, 0x76, 0x00, 0xE9, 0x01, // Ŷé (U+0176 U+00E9)
  0x01, 0x76, 0x00, 0xEA, 0x01, // Ŷê (U+0176 U+00EA)
  0x01, 0x76, 0x00, 0xEB, 0x01, // Ŷë (U+0176 U+00EB)
  0x01, 0x76, 0x00, 0xF0, 0x01, // Ŷð (U+0176 U+00F0)
  0x01, 0x76, 0x00, 0xF2, 0x01, // Ŷò (U+0176 U+00F2)
  0x01, 0x76, 0x00, 0xF3, 0x01, // Ŷó (U+0176 U+00F3)
  0x01, 0x76, 0x00, 0xF4, 0x01, // Ŷô (U+0176 U+00F4)
  0x01, 0x76, 0x00, 0xF5, 0x01, // Ŷõ (U+0176 U+00F5)
  0x01, 0x76, 0x00, 0xF6, 0x01, // Ŷö (U+0176 U+00F6)
  0x01, 0x76, 0x00, 0xF8, 0x01, // Ŷø (U+0176 U+00F8)
  0x01, 0x76, 0x01, 0x00, 0x01, // ŶĀ (U+0176 U+0100)
  0x01, 0x76, 0x01, 0x02, 0x01, // ŶĂ (U+0176 U+0102)
  0x01, 0x76, 0x01, 0x04, 0x01, // ŶĄ (U+0176 U+0104)
  0x01, 0x76, 0x01, 0x07, 0x01, // Ŷć (U+0176 U+0107)
  0x01, 0x76, 0x01, 0x09, 0x01, // Ŷĉ (U+0176 U+0109)
  0x01, 0x76, 0x01, 0x0B, 0x01, // Ŷċ (U+0176 U+010B)
  0x01, 0x76, 0x01, 0x0D, 0x01, // Ŷč (U+0176 U+010D)
  0x01, 0x76, 0x01, 0x0F, 0x01, // Ŷď (U+0176 U+010F)
  0x01, 0x76, 0x01, 0x11, 0x01, // Ŷđ (U+0176 U+0111)
  0x01, 0x76, 0x01, 0x13, 0x01, // Ŷē (U+0176 U+0113)
  0x01, 0x76, 0x01, 0x15, 0x01, // Ŷĕ (U+0176 U+0115)
  0x01, 0x76, 0x01, 0x17, 0x01, // Ŷė (U+0176 U+0117)
  0x01, 0x76, 0x01, 0x19, 0x01, // Ŷę (U+0176 U+0119)
  0x01, 0x76, 0x01, 0x1B, 0x01, // Ŷě (U+0176 U+011B)
  0x01, 0x76, 0x01, 0x1D, 0x01, // Ŷĝ (U+0176 U+011D)
  0x01, 0x76, 0x01, 0x1F, 0x01, // Ŷğ (U+0176 U+011F)
  0x01, 0x76, 0x01, 0x21, 0x01, // Ŷġ (U+0176 U+0121)
  0x01, 0x76, 0x01, 0x23, 0x01, // Ŷģ (U+0176 U+0123)
  0x01, 0x76, 0x01, 0x4D, 0x01, // Ŷō (U+0176 U+014D)
  0x01, 0x76, 0x01, 0x4F, 0x01, // Ŷŏ (U+0176 U+014F)
  0x01, 0x76, 0x01, 0x51, 0x01, // Ŷő (U+0176 U+0151)
  0x01, 0x76, 0x01, 0x53, 0x01, // Ŷœ (U+0176 U+0153)
  0x01, 0x76, 0x20, 0x1A, 0x01, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x01, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x01, // Ŷ… (U+0176 U+2026)
  0x01, 0x77, 0x00, 0x2C, 0x01, // ŷ, (U+0177 U+002C)
  0x01, 0x77, 0x00, 0x2E, 0x01, // ŷ. (U+0177 U+002E)
  0x01, 0x77, 0x20, 0x1A, 0x01, // ŷ‚ (U+0177 U+201A)
  0x01, 0x77, 0x20, 0x1E, 0x01, // ŷ„ (U+0177 U+201E)
  0x01, 0x77, 0x20, 0x26, 0x01, // ŷ… (U+0177 U+2026)
  0x01, 0x78, 0x00, 0x2C, 0x01, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x01, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x00, 0x41, 0x01, // ŸA (U+0178 U+0041)
  0x01, 0x78, 0x00, 0x63, 0x01, // Ÿc (U+0178 U+0063)
  0x01, 0x78, 0x00, 0x64, 0x01, // Ÿd (U+0178 U+0064)
  0x01, 0x78, 0x00, 0x65, 0x01, // Ÿe (U+0178 U+0065)
  0x01, 0x78, 0x00, 0x67, 0x01, // Ÿg (U+0178 U+0067)
  0x01, 0x78, 0x00, 0x6F, 0x01, // Ÿo (U+0178 U+006F)
  0x01, 0x78, 0x00, 0x71, 0x01, // Ÿq (U+0178 U+0071)
  0x01, 0x78, 0x00, 0xC0, 0x01, // ŸÀ (U+0178 U+00C0)
  0x01, 0x78, 0x00, 0xC1, 0x01, // ŸÁ (U+0178 U+00C1)
  0x01, 0x78, 0x00, 0xC2, 0x01, // ŸÂ (U+0178 U+00C2)
  0x01, 0x78, 0x00, 0xC3, 0x01, // ŸÃ (U+0178 U+00C3)
  0x01, 0x78, 0x00, 0xC4, 0x01, // ŸÄ (U+0178 U+00C4)
  0x01, 0x78, 0x00, 0xC5, 0x01, // ŸÅ (U+0178 U+00C5)
  0x01, 0x78, 0x00, 0xC6, 0x01, // ŸÆ (U+0178 U+00C6)
  0x01, 0x78, 0x00, 0xE7, 0x01, // Ÿç (U+0178 U+00E7)
  0x01, 0x78, 0x00, 0xE8, 0x01, // Ÿè (U+0178 U+00E8)
  0x01, 0x78, 0x00, 0xE9, 0x01, // Ÿé (U+0178 U+00E9)
  0x01, 0x78, 0x00, 0xEA, 0x01, // Ÿê (U+0178 U+00EA)
  0x01, 0x78, 0x00, 0xEB, 0x01, // Ÿë (U+0178 U+00EB)
  0x01, 0x78, 0x00, 0xF0, 0x01, // Ÿð (U+0178 U+00F0)
  0x01, 0x78, 0x00, 0xF2, 0x01, // Ÿò (U+0178 U+00F2)
  0x01, 0x78, 0x00, 0xF3, 0x01, // Ÿó (U+0178 U+00F3)
  0x01, 0x78, 0x00, 0xF4, 0x01, // Ÿô (U+0178 U+00F4)
  0x01, 0x78, 0x00, 0xF5, 0x01, // Ÿõ (U+0178 U+00F5)
  0x01, 0x78, 0x00, 0xF6, 0x01, // Ÿö (U+0178 U+00F6)
  0x01, 0x78, 0x00, 0xF8, 0x01, // Ÿø (U+0178 U+00F8)
  0x01, 0x78, 0x01, 0x00, 0x01, // ŸĀ (U+0178 U+0100)
  0x01, 0x78, 0x01, 0x02, 0x01, // ŸĂ (U+0178 U+0102)
  0x01, 0x78, 0x01, 0x04, 0x01, // ŸĄ (U+0178 U+0104)
  0x01, 0x78, 0x01, 0x07, 0x01, // Ÿć (U+0178 U+0107)
  0x01, 0x78, 0x01, 0x09, 0x01, // Ÿĉ (U+0178 U+0109)
  0x01, 0x78, 0x01, 0x0B, 0x01, // Ÿċ (U+0178 U+010B)
  0x01, 0x78, 0x01, 0x0D, 0x01, // Ÿč (U+0178 U+010D)
  0x01, 0x78, 0x01, 0x0F, 0x01, // Ÿď (U+0178 U+010F)
  0x01, 0x78, 0x01, 0x11, 0x01, // Ÿđ (U+0178 U+0111)
  0x01, 0x78, 0x01, 0x13, 0x01, // Ÿē (U+0178 U+0113)
  0x01, 0x78, 0x01, 0x15, 0x01, // Ÿĕ (U+0178 U+0115)
  0x01, 0x78, 0x01, 0x17, 0x01, // Ÿė (U+0178 U+0117)
  0x01, 0x78, 0x01, 0x19, 0x01, // Ÿę (U+0178 U+0119)
  0x01, 0x78, 0x01, 0x1B, 0x01, // Ÿě (U+0178 U+011B)
  0x01, 0x78, 0x01, 0x1D, 0x01, // Ÿĝ (U+0178 U+011D)
  0x01, 0x78, 0x01, 0x1F, 0x01, // Ÿğ (U+0178 U+011F)
  0x01, 0x78, 0x01, 0x21, 0x01, // Ÿġ (U+0178 U+0121)
  0x01, 0x78, 0x01, 0x23, 0x01, // Ÿģ (U+0178 U+0123)
  0x01, 0x78, 0x01, 0x4D, 0x01, // Ÿō (U+0178 U+014D)
  0x01, 0x78, 0x01, 0x4F, 0x01, // Ÿŏ (U+0178 U+014F)
  0x01, 0x78, 0x01, 0x51, 0x01, // Ÿő (U+0178 U+0151)
  0x01, 0x78, 0x01, 0x53, 0x01, // Ÿœ (U+0178 U+0153)
  0x01, 0x78, 0x20, 0x1A, 0x01, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x01, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x01, // Ÿ… (U+0178 U+2026)
  0x20, 0x18, 0x00, 0x41, 0x01, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0xC0, 0x01, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x01, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x01, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x01, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x01, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x01, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xC6, 0x01, // ‘Æ (U+2018 U+00C6)
  0x20, 0x18, 0x01, 0x00, 0x01, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x02, 0x01, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x04, 0x01, // ‘Ą (U+2018 U+0104)
  0x20, 0x19, 0x00, 0x41, 0x01, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0xC0, 0x01, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x01, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x01, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x01, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x01, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x01, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xC6, 0x01, // ’Æ (U+2019 U+00C6)
  0x20, 0x19, 0x01, 0x00, 0x01, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x02, 0x01, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x04, 0x01, // ’Ą (U+2019 U+0104)
  0x20, 0x1A, 0x00, 0x54, 0x01, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x56, 0x01, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x01, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x01, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0xDD, 0x01, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x01, 0x74, 0x01, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x76, 0x01, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x78, 0x01, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x01, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0xC0, 0x01, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x01, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x01, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x01, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x01, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x01, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xC6, 0x01, // “Æ (U+201C U+00C6)
  0x20, 0x1C, 0x01, 0x00, 0x01, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x02, 0x01, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x04, 0x01, // “Ą (U+201C U+0104)
  0x20, 0x1D, 0x00, 0x41, 0x01, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0xC0, 0x01, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x01, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x01, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x01, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x01, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x01, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xC6, 0x01, // ”Æ (U+201D U+00C6)
  0x20, 0x1D, 0x01, 0x00, 0x01, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x02, 0x01, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x04, 0x01, // ”Ą (U+201D U+0104)
  0x20, 0x1E, 0x00, 0x54, 0x01, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x56, 0x01, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x01, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x01, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0xDD, 0x01, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x01, 0x74, 0x01, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x76, 0x01, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x78, 0x01, // „Ÿ (U+201E U+0178)
  
  // Glyph data
  // "!" (U+0021)
  0x05, 0xD0, 0x78, 0x09, 0x30, 0x90, 0x00, 0x00, 0x10, 0x4C, 0x00,
  // """ (U+0022)
  0x97, 0xD3, 0xA2, 0xD0, 0x80, 0x80,
  // "#" (U+0023)
  0x00, 0x87, 0x10, 0x17, 0x80, 0x3D, 0xCD, 0x50, 0x83, 0x50, 0x8D, 0xDB, 0x01, 0x78, 0x00, 0x53,
  0x80, 0x00,
  // "$" (U+0024)
  0x00, 0x56, 0x00, 0xBC, 0xC5, 0x0F, 0x83, 0x10, 0x9E, 0x40, 0x20, 0xCE, 0x0B, 0x66, 0xE0, 0x2A,
  0x93, 0x00, 0x30, 0x00,
  // "%" (U+0025)
  0x07, 0xD3, 0x08, 0x01, 0xB4, 0x86, 0x20, 0x58, 0x58, 0x80, 0x06, 0x7A, 0xB5, 0xB7, 0x1B, 0xA7,
  0xC1, 0xC0, 0x09, 0x1C, 0x2A, 0x04, 0x50, 0xCB, 0x20,
  // "&" (U+0026)
  0x00, 0xBC, 0x70, 0x00, 0x4C, 0x2C, 0x00, 0x04, 0xEC, 0x70, 0x00, 0x5F, 0x84, 0xD3, 0x6C, 0x6E,
  0xA2, 0x0A, 0x80, 0x9D, 0x00, 0x3D, 0xB7, 0xDC, 0x00,
  // "'" (U+0027)
  0xA6, 0xB2, 0x80,
  // "(" (U+0028)
  0x00, 0xA5, 0x0A, 0x70, 0x3E, 0x00, 0x8B, 0x00, 0x99, 0x00, 0x7A, 0x00, 0x0A, 0x20,
  // ")" (U+0029)
  0x00, 0xA3, 0x00, 0x5C, 0x00, 0x4E, 0x00, 0x6D, 0x00, 0xA8, 0x03, 0xD1, 0x2A, 0x20,
  // "*" (U+002A)
  0x22, 0x60, 0x5B, 0x96, 0x8A, 0xA3, 0x07, 0x11,
  // "+" (U+002B)
  0x01, 0x80, 0x01, 0x80, 0x5B, 0xDB, 0x01, 0x80,
  // "," (U+002C)
  0x87, 0x57, 0x60,
  // "-" (U+002D)
  0x9B, 0x20,
  // "." (U+002E)
  0x97,
  // "/" (U+002F)
  0x00, 0x09, 0x00, 0x18, 0x00, 0x72, 0x00, 0x90, 0x05, 0x40, 0x09, 0x00, 0x36, 0x00, 0x80, 0x00,
  // "0" (U+0030)
  0x04, 0xCB, 0x10, 0xE1, 0x96, 0x5B, 0x09, 0x79, 0x80, 0xA5, 0xA6, 0x0D, 0x29, 0x63, 0xB0, 0x2C,
  0xC2, 0x00,
  // "1" (U+0031)
  0x01, 0xAA, 0x0C, 0xB8, 0x00, 0xD5, 0x00, 0xF2, 0x02, 0xF0, 0x05, 0xC0, 0x4C, 0xD4,
  // "2" (U+0032)
  0x08, 0xCD, 0x20, 0xF0, 0xC6, 0x03, 0x0D, 0x20, 0x07, 0x50, 0x06, 0x50, 0x06, 0x50, 0x80, 0xFF,
  0xFC, 0x00,
  // "3" (U+0033)
  0x08, 0xCD, 0x21, 0xE0, 0xC6, 0x00, 0x2E, 0x20, 0x7F, 0x60, 0x00, 0x4F, 0x0B, 0x05, 0xE0, 0x9C,
  0xC4, 0x00,
  // "4" (U+0034)
  0x00, 0x2F, 0x30, 0x09, 0xF1, 0x05, 0x8E, 0x00, 0x96, 0xB0, 0x72, 0x89, 0x0A, 0x9D, 0xC2, 0x0B,
  0xFB, 0x00,
  // "5" (U+0035)
  0x08, 0xBC, 0x70, 0x70, 0x12, 0x07, 0x00, 0x02, 0xCC, 0x60, 0x00, 0x4F, 0x07, 0x04, 0xD0, 0x9C,
  0xC3, 0x00,
  // "6" (U+0036)
  0x01, 0xBD, 0x60, 0xC5, 0x47, 0x3E, 0x00, 0x07, 0xDB, 0x90, 0x89, 0x0F, 0x27, 0x81, 0xF0, 0x1C,
  0xC5, 0x00,
  // "7" (U+0037)
  0x0D, 0xBD, 0xC1, 0x30, 0xB5, 0x00, 0x4C, 0x00, 0x0B, 0x50, 0x04, 0xC0, 0x00, 0xC4, 0x00, 0x4C,
  0x00, 0x00,
  // "8" (U+0038)
  0x07, 0xCD, 0x20, 0xF1, 0x87, 0x0E, 0x7C, 0x20, 0x9E, 0x70, 0x97, 0x3F, 0x1C, 0x40, 0xF1, 0x5C,
  0xC6, 0x00,
  // "9" (U+0039)
  0x05, 0xCC, 0x11, 0xE1, 0xA6, 0x4D, 0x09, 0x64, 0xD0, 0xD3, 0x0B, 0x9E, 0x03, 0x05, 0x80, 0x89,
  0x90, 0x00,
  // ":" (U+003A)
  0x18, 0x2C, 0x40, 0x17, 0x07, 0x08, 0x10,
  // ";" (U+003B)
  0x0C, 0x40, 0x10, 0x00, 0x06, 0x60, 0x58, 0x07, 0x10,
  // "<" (U+003C)
  0x00, 0x18, 0x18, 0x70, 0x3A, 0x30, 0x00, 0x68,
  // "=" (U+003D)
  0x5B, 0xBB, 0x00, 0x00, 0x5B, 0xBB,
  // ">" (U+003E)
  0x45, 0x00, 0x04, 0x94, 0x00, 0x78, 0x48, 0x10,
  // "?" (U+003F)
  0x0A, 0xCC, 0x11, 0xE0, 0xE5, 0x01, 0x0E, 0x30, 0x1A, 0x60, 0x06, 0x50, 0x00, 0x10, 0x00, 0x0C,
  0x30, 0x00,
  // "@" (U+0040)
  0x00, 0x7C, 0xB9, 0x00, 0x96, 0x00, 0x48, 0x2B, 0x2C, 0xB5, 0xA7, 0x5B, 0x49, 0x39, 0x93, 0xE0,
  0xB1, 0x98, 0x3E, 0x1E, 0x29, 0x66, 0x7B, 0x4B, 0x20, 0xC3, 0x00, 0x40, 0x01, 0x9B, 0xB3, 0x00,
  // "A" (U+0041)
  0x40, 0xE0, 0x64, 0x81, 0x7C, 0x84, 0x81, 0xA8, 0xA3, 0x82, 0x64, 0x7C, 0x38, 0x2C, 0x8B, 0xE2,
  0x89, 0x36, 0x50, 0x3F, 0x14, 0xE9, 0x0D, 0xF8,
  // "B" (U+0042)
  0x00, 0xDF, 0xCC, 0x10, 0x07, 0xC0, 0xF5, 0x00, 0xA9, 0x2F, 0x20, 0x0D, 0xDE, 0x70, 0x00, 0xF4,
  0x6E, 0x00, 0x3F, 0x16, 0xE0, 0x1D, 0xFB, 0xD4, 0x00,
  // "C" (U+0043)
  0x00, 0x8C, 0xE4, 0x08, 0xA0, 0x97, 0x1F, 0x30, 0x00, 0x5E, 0x00, 0x00, 0x7D, 0x00, 0x00, 0x4E,
  0x10, 0x30, 0x08, 0xDA, 0x50,
  // "D" (U+0044)
  0x00, 0xDF, 0xCC, 0x20, 0x07, 0xC0, 0x9C, 0x00, 0xA9, 0x05, 0xE0, 0x0D, 0x60, 0x6D, 0x00, 0xF3,
  0x0A, 0xA0, 0x3F, 0x03, 0xE3, 0x1D, 0xFC, 0xD4, 0x00,
  // "E" (U+0045)
  0x00, 0xBE, 0x7C, 0x40, 0x07, 0xB0, 0x51, 0x00, 0xA9, 0x00, 0x00, 0x0D, 0xDB, 0x30, 0x00, 0xF4,
  0x00, 0x00, 0x2F, 0x10, 0x60, 0x1A, 0xF7, 0x98, 0x00,
  // "F" (U+0046)
  0x28, 0x3D, 0xFB, 0xE5, 0x28, 0x37, 0xB0, 0x63, 0x20, 0xA0, 0x85, 0x82, 0xDD, 0xB3, 0x39, 0x03,
  0x40, 0x39, 0x48, 0x21, 0xDF, 0x73,
  // "G" (U+0047)
  0x00, 0x7B, 0xD8, 0x08, 0xB0, 0x4E, 0x1F, 0x30, 0x02, 0x6E, 0x00, 0x00, 0x7D, 0x07, 0xDC, 0x4E,
  0x01, 0xF3, 0x08, 0xCC, 0xC0,
  // "H" (U+0048)
  0x00, 0xDF, 0x98, 0xFD, 0x00, 0x7C, 0x01, 0xF2, 0x00, 0xA9, 0x04, 0xE0, 0x00, 0xDD, 0xBD, 0xB0,
  0x00, 0xF4, 0x0A, 0x90, 0x03, 0xF0, 0x0D, 0x60, 0x1D, 0xF7, 0xAF, 0xC0,
  // "I" (U+0049)
  0x00, 0xDF, 0x90, 0x07, 0xC0, 0x00, 0xA9, 0x00, 0x0D, 0x60, 0x00, 0xF3, 0x00, 0x3F, 0x00, 0x1D,
  0xF7, 0x00,
  // "J" (U+004A)
  0x38, 0x1D, 0xF9, 0x30, 0x70, 0xC4, 0x0A, 0x09, 0x40, 0xD0, 0x64, 0x90, 0x33, 0x03, 0x94, 0x06,
  0x0D, 0x40, 0xB0, 0x92, 0x81, 0x2B, 0xA3,
  // "K" (U+004B)
  0x00, 0xDF, 0x9A, 0xF5, 0x00, 0x7C, 0x09, 0x30, 0x00, 0xA9, 0x82, 0x00, 0x00, 0xDD, 0xF1, 0x00,
  0x00, 0xF4, 0xE6, 0x00, 0x03, 0xF0, 0xAC, 0x00, 0x1D, 0xF7, 0x3E, 0x60,
  // "L" (U+004C)
  0x00, 0xBF, 0x50, 0x00, 0x7B, 0x00, 0x00, 0xA9, 0x00, 0x00, 0xD6, 0x00, 0x00, 0xF4, 0x01, 0x02,
  0xF1, 0x08, 0x1A, 0xF7, 0x89,
  // "M" (U+004D)
  0x00, 0xDF, 0x40, 0x5F, 0xD1, 0x00, 0x7D, 0x60, 0xBF, 0x30, 0x00, 0x9A, 0x83, 0xAF, 0x00, 0x00,
  0x98, 0xA9, 0x6D, 0x00, 0x00, 0x86, 0xD8, 0x8A, 0x00, 0x03, 0x65, 0xF1, 0xB7, 0x00, 0x1D, 0xB3,
  0x98, 0xFD, 0x00,
  // "N" (U+004E)
  0x00, 0xDE, 0x01, 0xEB, 0x00, 0x7E, 0x60, 0x90, 0x00, 0x98, 0xC0, 0x90, 0x00, 0x92, 0xF3, 0x90,
  0x00, 0x80, 0xBB, 0x70, 0x03, 0x60, 0x5F, 0x40, 0x1D, 0xB0, 0x0E, 0x10,
  // "O" (U+004F)
  0x00, 0x8C, 0xD4, 0x00, 0x9A, 0x05, 0xE0, 0x1F, 0x20, 0x3F, 0x16, 0xE0, 0x04, 0xF0, 0x7C, 0x00,
  0x8B, 0x04, 0xE0, 0x1E, 0x30, 0x09, 0xDC, 0x40, 0x00,
  // "P" (U+0050)
  0x00, 0xDF, 0xD9, 0x00, 0x07, 0xC1, 0xF3, 0x00, 0xAA, 0x0F, 0x40, 0x0D, 0x74, 0xF1, 0x00, 0xFD,
  0xC4, 0x00, 0x3F, 0x10, 0x00, 0x1D, 0xF9, 0x00, 0x00,
  // "Q" (U+0051)
  0x00, 0x8C, 0xD4, 0x00, 0x9A, 0x05, 0xE0, 0x2F, 0x20, 0x3F, 0x16, 0xE0, 0x04, 0xF0, 0x7C, 0x00,
  0x8A, 0x04, 0xE0, 0x1D, 0x30, 0x07, 0xCB, 0x40, 0x00, 0x0C, 0x80, 0x00, 0x00, 0x4D, 0x40, 0x00,
  // "R" (U+0052)
  0x00, 0xDF, 0xCC, 0x20, 0x07, 0xC0, 0xE6, 0x00, 0xA8, 0x1F, 0x30, 0x0D, 0xDF, 0x50, 0x00, 0xF3,
  0xE5, 0x00, 0x3F, 0x0A, 0xA0, 0x1D, 0xF9, 0x3E, 0x40,
  // "S" (U+0053)
  0x05, 0x9C, 0x60, 0xE1, 0x47, 0x0F, 0x90, 0x00, 0x7F, 0xB0, 0x10, 0x5F, 0x3C, 0x40, 0xD2, 0x6B,
  0x87, 0x00,
  // "T" (U+0054)
  0x2E, 0xDF, 0xCC, 0x53, 0x7C, 0x08, 0x00, 0xA9, 0x00, 0x00, 0xD6, 0x00, 0x00, 0xF3, 0x00, 0x03,
  0xF0, 0x00, 0x1D, 0xF7, 0x00,
  // "U" (U+0055)
  0x1E, 0xF7, 0x6F, 0x70, 0x8A, 0x00, 0x90, 0x0B, 0x70, 0x17, 0x00, 0xE4, 0x04, 0x40, 0x1F, 0x20,
  0x71, 0x02, 0xF1, 0x0A, 0x00, 0x0A, 0xDB, 0x30, 0x00,
  // "V" (U+0056)
  0x89, 0x33, 0xFE, 0x49, 0xE3, 0x0A, 0x90, 0x45, 0x28, 0x28, 0xA0, 0x93, 0x82, 0x7C, 0x36, 0x38,
  0x15, 0xD9, 0x48, 0x13, 0xE7, 0x40, 0x10, 0xE4,
  // "W" (U+0057)
  0x3F, 0xE4, 0x39, 0x0A, 0xE3, 0x0A, 0x90, 0x9B, 0x05, 0x50, 0x09, 0x91, 0xDD, 0x0A, 0x00, 0x08,
  0xA6, 0x7F, 0x28, 0x00, 0x07, 0xBA, 0x1F, 0x92, 0x00, 0x05, 0xE5, 0x0F, 0xA0, 0x00, 0x04, 0xE0,
  0x0D, 0x50, 0x00,
  // "X" (U+0058)
  0x28, 0x4D, 0xF7, 0x7F, 0x32, 0x83, 0x3F, 0x26, 0x34, 0x81, 0xDB, 0x55, 0x09, 0x0E, 0x58, 0x24,
  0x7F, 0x43, 0x83, 0x37, 0x0B, 0xA2, 0x85, 0x3E, 0xA2, 0xEF, 0x51,
  // "Y" (U+0059)
  0x89, 0x33, 0xFE, 0x3A, 0xE3, 0x0A, 0xA0, 0x64, 0x28, 0x25, 0xD0, 0x83, 0x82, 0x1F, 0x91, 0x40,
  0xD0, 0x74, 0x81, 0x1F, 0x34, 0x81, 0xDF, 0xB3,
  // "Z" (U+005A)
  0x0A, 0x99, 0xF7, 0x09, 0x09, 0xD0, 0x00, 0x4F, 0x30, 0x00, 0xD8, 0x00, 0x09, 0xD0, 0x00, 0x4F,
  0x30, 0x90, 0xDD, 0x8A, 0xA0,
  // "[" (U+005B)
  0x06, 0xFA, 0x08, 0xA0, 0x0B, 0x70, 0x0E, 0x40, 0x1F, 0x10, 0x3E, 0x00, 0x6B, 0x00, 0x99, 0x00,
  0xAD, 0x50,
  // "\" (U+005C)
  0x16, 0x07, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
  // "]" (U+005D)
  0x00, 0xCF, 0x30, 0x02, 0xF0, 0x00, 0x5D, 0x00, 0x07, 0xA0, 0x00, 0xA8, 0x00, 0x0D, 0x50, 0x00,
  0xF2, 0x00, 0x4F, 0x00, 0x4D, 0xB0, 0x00,
  // "^" (U+005E)
  0x02, 0x90, 0x08, 0x91, 0x08, 0x27, 0x62, 0x09,
  // "_" (U+005F)
  0x58, 0x88,
  // "`" (U+0060)
  0x53, 0x2A,
  // "a" (U+0061)
  0x06, 0xCB, 0xA3, 0xE1, 0xA8, 0x8A, 0x0D, 0x5A, 0x83, 0xF2, 0x5D, 0x6D, 0x90,
  // "b" (U+0062)
  0x3E, 0x90, 0x00, 0xC6, 0x00, 0x0E, 0x9D, 0x42, 0xF3, 0x89, 0x5D, 0x0A, 0x78, 0x91, 0xE2, 0xAB,
  0xC5, 0x00,
  // "c" (U+0063)
  0x06, 0xCD, 0x13, 0xD0, 0xB1, 0x99, 0x00, 0x09, 0x90, 0x10, 0x2D, 0xB5, 0x00,
  // "d" (U+0064)
  0x00, 0x0A, 0xF1, 0x00, 0x04, 0xE0, 0x06, 0xCD, 0xB0, 0x3E, 0x1A, 0x80, 0x8A, 0x0D, 0x50, 0xA8,
  0x3F, 0x20, 0x5D, 0x6D, 0x90,
  // "e" (U+0065)
  0x05, 0xCD, 0x13, 0xD2, 0xF1, 0x9E, 0xB4, 0x09, 0x90, 0x10, 0x2C, 0xB5, 0x00,
  // "f" (U+0066)
  0x28, 0x21, 0xCD, 0x42, 0x87, 0x89, 0x42, 0x03, 0xED, 0x53, 0x0E, 0x03, 0x30, 0x29, 0x40, 0x50,
  0xD4, 0x09, 0x0A, 0x40, 0xD0, 0x53, 0x0C, 0x09, 0x40,
  // "g" (U+0067)
  0x00, 0x00, 0x2B, 0x00, 0x9C, 0xE5, 0x03, 0xC2, 0xF0, 0x01, 0xDB, 0x50, 0x07, 0x93, 0x00, 0x08,
  0xCE, 0xA0, 0x59, 0x04, 0xB0, 0x2C, 0xBB, 0x20,
  // "h" (U+0068)
  0x3E, 0x90, 0x00, 0xC6, 0x00, 0x0E, 0x8D, 0x62, 0xF4, 0xA8, 0x5D, 0x0C, 0x58, 0xA0, 0xF3, 0xB7,
  0x0C, 0xA0,
  // "i" (U+0069)
  0x09, 0x70, 0x00, 0x6F, 0x50, 0xF2, 0x3E, 0x06, 0xC0, 0x4D, 0x50,
  // "j" (U+006A)
  0x00, 0x97, 0x00, 0x00, 0x06, 0xF5, 0x00, 0xF2, 0x03, 0xE0, 0x07, 0xB0, 0x0A, 0x80, 0x0E, 0x50,
  0xCA, 0x00,
  // "k" (U+006B)
  0x3E, 0x90, 0x00, 0xC6, 0x00, 0x0E, 0x3E, 0xD2, 0xF3, 0x90, 0x5E, 0xE4, 0x08, 0xA9, 0xB0, 0xB7,
  0x2D, 0x60,
  // "l" (U+006C)
  0x3E, 0x90, 0xC6, 0x0E, 0x32, 0xF0, 0x5D, 0x08, 0xA0, 0x6D, 0x30,
  // "m" (U+006D)
  0x6F, 0x8E, 0x7A, 0xD0, 0x0F, 0x79, 0xD3, 0xF1, 0x3F, 0x0B, 0x74, 0xD0, 0x6C, 0x0E, 0x47, 0xB0,
  0x99, 0x1F, 0x25, 0xD4,
  // "n" (U+006E)
  0x6F, 0x8D, 0x80, 0x0F, 0x68, 0xA0, 0x3F, 0x0B, 0x70, 0x6C, 0x0D, 0x50, 0x99, 0x0A, 0xB1,
  // "o" (U+006F)
  0x06, 0xCC, 0x24, 0xE0, 0x98, 0x9A, 0x0A, 0x79, 0x91, 0xE3, 0x3D, 0xC6, 0x00,
  // "p" (U+0070)
  0x08, 0xF7, 0xD5, 0x02, 0xF3, 0x99, 0x05, 0xD0, 0xA8, 0x08, 0x91, 0xE2, 0x0B, 0xDC, 0x60, 0x0E,
  0x30, 0x00, 0x2F, 0xA0, 0x00,
  // "q" (U+0071)
  0x06, 0xCB, 0xA3, 0xE1, 0xA8, 0x8A, 0x0D, 0x5A, 0x83, 0xF2, 0x5D, 0x7E, 0x00, 0x04, 0xB0, 0x00,
  0x7E, 0x40,
  // "r" (U+0072)
  0x6F, 0x8D, 0x40, 0xF6, 0x41, 0x3F, 0x00, 0x06, 0xC0, 0x00, 0x99, 0x00, 0x00,
  // "s" (U+0073)
  0x1B, 0x99, 0x5D, 0x24, 0x0B, 0xE3, 0x70, 0xA8, 0x89, 0xB2,
  // "t" (U+0074)
  0x06, 0x80, 0x5F, 0xC4, 0x0F, 0x20, 0x3E, 0x00, 0x6C, 0x00, 0x4D, 0x70,
  // "u" (U+0075)
  0x6F, 0x54, 0xD0, 0x0F, 0x27, 0xA0, 0x3E, 0x0B, 0x70, 0x6C, 0x2F, 0x50, 0x4E, 0x6B, 0xB1,
  // "v" (U+0076)
  0xBD, 0x09, 0x53, 0xF0, 0x55, 0x0F, 0x19, 0x00, 0xD7, 0x60, 0x0B, 0xA0, 0x00,
  // "w" (U+0077)
  0x8F, 0x08, 0xA3, 0xA1, 0xF0, 0xCB, 0x0A, 0x1F, 0x48, 0xB3, 0x51, 0xF8, 0x4C, 0x80, 0x0F, 0x44,
  0xE2, 0x00,
  // "x" (U+0078)
  0x04, 0xF5, 0x6A, 0x00, 0x9B, 0x90, 0x00, 0x4F, 0x10, 0x01, 0x9C, 0x70, 0x1D, 0x27, 0xF3,
  // "y" (U+0079)
  0x28, 0x3D, 0xB0, 0xA4, 0x28, 0x34, 0xF0, 0x64, 0x39, 0x03, 0x08, 0x48, 0x1B, 0x95, 0x40, 0x70,
  0xB4, 0x81, 0x1B, 0x22, 0x82, 0x3B, 0xB3, 0x30,
  // "z" (U+007A)
  0x4C, 0xBF, 0x13, 0x1C, 0x70, 0x08, 0xC0, 0x03, 0xE2, 0x50, 0xDD, 0x9B, 0x00,
  // "{" (U+007B)
  0x00, 0xBD, 0x10, 0x3F, 0x10, 0x05, 0xD0, 0x00, 0x9A, 0x00, 0x8E, 0x10, 0x00, 0xE4, 0x00, 0x0F,
  0x20, 0x03, 0xF0, 0x00, 0x1C, 0x80, 0x00,
  // "|" (U+007C)
  0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
  // "}" (U+007D)
  0x00, 0xDB, 0x00, 0x04, 0xE0, 0x00, 0x6B, 0x00, 0x08, 0xA0, 0x00, 0x4F, 0x40, 0x0E, 0x50, 0x02,
  0xF1, 0x00, 0x6E, 0x00, 0x4C, 0x60, 0x00,
  // "~" (U+007E)
  0x3B, 0x47, 0x71, 0x99,
  // "¡" (U+00A1)
  0x0A, 0x60, 0x20, 0x09, 0x01, 0xB0, 0x5A, 0x0A, 0x80, 0x11, 0x00,
  // "¢" (U+00A2)
  0x00, 0x17, 0x00, 0x5E, 0xD4, 0x1F, 0x7A, 0x65, 0xD7, 0x00, 0x6D, 0x72, 0x01, 0xDD, 0x80, 0x01,
  0x60, 0x00,
  // "£" (U+00A3)
  0x02, 0xBD, 0x50, 0xB5, 0x67, 0x0C, 0x30, 0x06, 0xEC, 0x70, 0x0A, 0x50, 0x01, 0xB1, 0x00, 0x9B,
  0xDA, 0x20,
  // "¤" (U+00A4)
  0x00, 0x01, 0x2C, 0xBB, 0x08, 0x09, 0x08, 0x09, 0x2B, 0xBA,
  // "¥" (U+00A5)
  0x3F, 0xC7, 0xE1, 0x0B, 0x54, 0x50, 0x09, 0x78, 0x00, 0x06, 0xC5, 0x00, 0x4C, 0xFB, 0x00, 0x6D,
  0xE9, 0x00, 0x7E, 0xD3, 0x00,
  // "¦" (U+00A6)
  0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18,
  // "§" (U+00A7)
  0x04, 0xBD, 0x10, 0xB1, 0x73, 0x0B, 0xA1, 0x03, 0x77, 0xD0, 0x1D, 0x7A, 0x00, 0x1B, 0x60, 0xB1,
  0x65, 0x05, 0xC9, 0x00,
  // "¨" (U+00A8)
  0x74, 0xA1, 0x00, 0x10,
  // "©" (U+00A9)
  0x02, 0x87, 0x70, 0x01, 0x96, 0x86, 0x90, 0x63, 0x90, 0x35, 0x28, 0x37, 0x00, 0x34, 0x63, 0x90,
  0x15, 0x21, 0x96, 0x85, 0x90, 0x01, 0x87, 0x70, 0x00,
  // "ª" (U+00AA)
  0x09, 0x87, 0x49, 0x85, 0x3A, 0x96,
  // "«" (U+00AB)
  0x01, 0x34, 0x1B, 0x69, 0x69, 0xC3, 0x0A, 0x46,
  // "¬" (U+00AC)
  0x5B, 0xBC, 0x00, 0x09, 0x00, 0x03,
  // "®" (U+00AE)
  0x02, 0x87, 0x70, 0x01, 0x99, 0x65, 0x90, 0x61, 0x90, 0xA5, 0x28, 0x09, 0x93, 0x34, 0x61, 0x94,
  0x65, 0x21, 0x99, 0x29, 0x90, 0x01, 0x87, 0x70, 0x00,
  // "¯" (U+00AF)
  0x18, 0x88, 0x40,
  // "°" (U+00B0)
  0x7A, 0x1A, 0x36, 0x79, 0x10,
  // "±" (U+00B1)
  0x01, 0x80, 0x5B, 0xDB, 0x01, 0x80, 0x01, 0x80, 0x5B, 0xBB,
  // "²" (U+00B2)
  0x06, 0x72, 0x03, 0x84, 0x05, 0x41, 0x5A, 0xA1,
  // "³" (U+00B3)
  0x06, 0x83, 0x03, 0xB1, 0x31, 0x93, 0x27, 0x60,
  // "´" (U+00B4)
  0x27, 0xA3,
  // "µ" (U+00B5)
  0x0D, 0x54, 0xE0, 0x0F, 0x27, 0xB0, 0x3F, 0x0A, 0x80, 0x6D, 0x0E, 0x50, 0x9C, 0x9B, 0xB1, 0xB0,
  0x00, 0x00, 0xD3, 0x00, 0x00,
  // "¶" (U+00B6)
  0x2E, 0xFD, 0xB7, 0xFD, 0x72, 0x5F, 0xD7, 0x10, 0x5A, 0x71, 0x00, 0x97, 0x10, 0x09, 0x71, 0x00,
  0x97, 0x20, 0x5B, 0x6B,
  // "·" (U+00B7)
  0x2D, 0x01,
  // "¸" (U+00B8)
  0x05, 0x00, 0xC1, 0x68, 0x00,
  // "¹" (U+00B9)
  0x04, 0xA0, 0x2A, 0x04, 0x71, 0x87,
  // "º" (U+00BA)
  0x09, 0x95, 0x58, 0x57, 0x3A, 0x91,
  // "»" (U+00BB)
  0x04, 0x31, 0x0C, 0x59, 0x0C, 0x6C, 0x75, 0x91,
  // "¼" (U+00BC)
  0x00, 0x00, 0x05, 0x40, 0x4A, 0x00, 0x90, 0x02, 0xA0, 0x72, 0x00, 0x47, 0x18, 0x92, 0x18, 0x79,
  0x7C, 0x00, 0x03, 0xA7, 0xD2, 0x00, 0xA0, 0x59, 0x00,
  // "½" (U+00BD)
  0x00, 0x00, 0x54, 0x00, 0x4A, 0x09, 0x00, 0x02, 0xA7, 0x20, 0x00, 0x49, 0x86, 0x72, 0x18, 0xF1,
  0x38, 0x40, 0x36, 0x05, 0x41, 0x0A, 0x05, 0xAA, 0x10,
  // "¾" (U+00BE)
  0x00, 0x00, 0x05, 0x40, 0x68, 0x30, 0x90, 0x03, 0xB1, 0x72, 0x03, 0x19, 0x58, 0x92, 0x27, 0x69,
  0x7C, 0x00, 0x03, 0xA7, 0xD2, 0x00, 0xA0, 0x59, 0x00,
  // "¿" (U+00BF)
  0x00, 0xC4, 0x00, 0x10, 0x00, 0xB0, 0x3C, 0x50, 0xC6, 0x10, 0xE5, 0x87, 0x59, 0x91,
  // "À" (U+00C0)
  0x30, 0x50, 0x35, 0x02, 0x0A, 0x60, 0xE0, 0x64, 0x81, 0x7C, 0x84, 0x81, 0xA8, 0xA3, 0x82, 0x64,
  0x7C, 0x38, 0x2C, 0x8B, 0xE2, 0x89, 0x36, 0x50, 0x3F, 0x14, 0xE9, 0x0D, 0xF8,
  // "Á" (U+00C1)
  0x40, 0x20, 0x75, 0x0A, 0x03, 0x50, 0xE0, 0x64, 0x81, 0x7C, 0x84, 0x81, 0xA8, 0xA3, 0x82, 0x64,
  0x7C, 0x38, 0x2C, 0x8B, 0xE2, 0x89, 0x36, 0x50, 0x3F, 0x14, 0xE9, 0x0D, 0xF8,
  // "Â" (U+00C2)
  0x48, 0x11, 0x71, 0x48, 0x19, 0x68, 0x40, 0xE0, 0x64, 0x81, 0x7C, 0x84, 0x81, 0xA8, 0xA3, 0x82,
  0x64, 0x7C, 0x38, 0x2C, 0x8B, 0xE2, 0x89, 0x36, 0x50, 0x3F, 0x14, 0xE9, 0x0D, 0xF8,
  // "Ã" (U+00C3)
  0x38, 0x17, 0x97, 0x40, 0x6A, 0x48, 0x17, 0xC8, 0x48, 0x1A, 0x8A, 0x38, 0x26, 0x47, 0xC3, 0x82,
  0xC8, 0xBE, 0x28, 0x93, 0x65, 0x03, 0xF1, 0x4E, 0x90, 0xDF, 0x80,
  // "Ä" (U+00C4)
  0x00, 0x07, 0x4A, 0x10, 0x00, 0x1E, 0x80, 0x00, 0x07, 0xC8, 0x00, 0x00, 0xA8, 0xA0, 0x00, 0x64,
  0x7C, 0x00, 0x0C, 0x8B, 0xE0, 0x06, 0x50, 0x3F, 0x14, 0xE9, 0x0D, 0xF8,
  // "Å" (U+00C5)
  0x40, 0x06, 0x50, 0x07, 0x59, 0x0D, 0x48, 0x17, 0xC8, 0x48, 0x1A, 0x8A, 0x38, 0x26, 0x47, 0xC3,
  0x82, 0xC8, 0xBE, 0x28, 0x93, 0x65, 0x03, 0xF1, 0x4E, 0x90, 0xDF, 0x80,
  // "Æ" (U+00C6)
  0x48, 0x48, 0xEE, 0xBF, 0x14, 0x83, 0x8B, 0x80, 0x84, 0x82, 0x43, 0xD5, 0x68, 0x37, 0x1F, 0xCB,
  0x48, 0x18, 0xCC, 0x95, 0x8A, 0x02, 0x70, 0x6D, 0x01, 0x50, 0x2D, 0x72, 0xCD, 0x7B, 0x41,
  // "Ç" (U+00C7)
  0x00, 0x8C, 0xE4, 0x08, 0xA0, 0x97, 0x1F, 0x30, 0x00, 0x5E, 0x00, 0x00, 0x7D, 0x00, 0x00, 0x4E,
  0x10, 0x30, 0x08, 0xFA, 0x50, 0x00, 0xC1, 0x00, 0x06, 0x80, 0x00,
  // "È" (U+00C8)
  0x30, 0x50, 0x35, 0x02, 0x0A, 0x48, 0x3B, 0xE7, 0xC4, 0x28, 0x37, 0xB0, 0x51, 0x20, 0xA0, 0x95,
  0x82, 0xDD, 0xB3, 0x39, 0x04, 0x48, 0x92, 0x2F, 0x10, 0x60, 0x1A, 0xF7, 0x98, 0x10,
  // "É" (U+00C9)
  0x40, 0x20, 0x75, 0x0A, 0x03, 0x38, 0x3B, 0xE7, 0xC4, 0x28, 0x37, 0xB0, 0x51, 0x20, 0xA0, 0x95,
  0x82, 0xDD, 0xB3, 0x39, 0x04, 0x48, 0x92, 0x2F, 0x10, 0x60, 0x1A, 0xF7, 0x98, 0x10,
  // "Ê" (U+00CA)
  0x38, 0x11, 0x71, 0x48, 0x19, 0x68, 0x38, 0x3B, 0xE7, 0xC4, 0x28, 0x37, 0xB0, 0x51, 0x20, 0xA0,
  0x95, 0x82, 0xDD, 0xB3, 0x39, 0x04, 0x48, 0x92, 0x2F, 0x10, 0x60, 0x1A, 0xF7, 0x98, 0x10,
  // "Ë" (U+00CB)
  0x00, 0x07, 0x4A, 0x10, 0x0B, 0xF7, 0xD4, 0x00, 0x7B, 0x05, 0x10, 0x0A, 0x90, 0x00, 0x00, 0xDD,
  0xB3, 0x00, 0x0F, 0x40, 0x00, 0x02, 0xF1, 0x06, 0x01, 0xAF, 0x79, 0x80,
  // "Ì" (U+00CC)
  0x00, 0x53, 0x00, 0x02, 0xA0, 0x00, 0xDF, 0x90, 0x07, 0xC0, 0x00, 0xA9, 0x00, 0x0D, 0x60, 0x00,
  0xF3, 0x00, 0x3F, 0x00, 0x1D, 0xF7, 0x00,
  // "Í" (U+00CD)
  0x00, 0x02, 0x70, 0x00, 0xA3, 0x00, 0xDF, 0x90, 0x07, 0xC0, 0x00, 0xA9, 0x00, 0x0D, 0x60, 0x00,
  0xF3, 0x00, 0x3F, 0x00, 0x1D, 0xF7, 0x00,
  // "Î" (U+00CE)
  0x00, 0x17, 0x10, 0x09, 0x68, 0x00, 0xDF, 0x90, 0x07, 0xC0, 0x00, 0xA9, 0x00, 0x0D, 0x60, 0x00,
  0xF3, 0x00, 0x3F, 0x00, 0x1D, 0xF7, 0x00,
  // "Ï" (U+00CF)
  0x28, 0x27, 0x4A, 0x12, 0x81, 0xEF, 0xA3, 0x07, 0x0C, 0x40, 0xA0, 0x94, 0x0D, 0x06, 0x49, 0x03,
  0x30, 0x39, 0x38, 0x21, 0xDF, 0x72,
  // "Ð" (U+00D0)
  0x00, 0xDF, 0xCC, 0x20, 0x07, 0xC0, 0x9C, 0x00, 0xA9, 0x05, 0xE0, 0x5E, 0xD5, 0x6D, 0x00, 0xF4,
  0x0A, 0xA0, 0x3F, 0x13, 0xE3, 0x1D, 0xFC, 0xD4, 0x00,
  // "Ñ" (U+00D1)
  0x00, 0x00, 0x79, 0x70, 0x00, 0xDE, 0x68, 0xFB, 0x00, 0x7E, 0x60, 0x90, 0x00, 0x98, 0xC0, 0x90,
  0x00, 0x92, 0xF3, 0x90, 0x00, 0x80, 0xBB, 0x70, 0x03, 0x60, 0x5F, 0x40, 0x1D, 0xB0, 0x0E, 0x10,
  // "Ò" (U+00D2)
  0x00, 0x53, 0x00, 0x00, 0x02, 0xA0, 0x00, 0x00, 0x8C, 0xD4, 0x00, 0x9A, 0x05, 0xE0, 0x1F, 0x20,
  0x3F, 0x16, 0xE0, 0x04, 0xF0, 0x7C, 0x00, 0x8B, 0x04, 0xE0, 0x1E, 0x30, 0x09, 0xDC, 0x40, 0x00,
  // "Ó" (U+00D3)
  0x00, 0x00, 0x27, 0x00, 0x00, 0x0A, 0x30, 0x00, 0x8C, 0xD4, 0x00, 0x9A, 0x05, 0xE0, 0x1F, 0x20,
  0x3F, 0x16, 0xE0, 0x04, 0xF0, 0x7C, 0x00, 0x8B, 0x04, 0xE0, 0x1E, 0x30, 0x09, 0xDC, 0x40, 0x00,
  // "Ô" (U+00D4)
  0x00, 0x01, 0x71, 0x00, 0x00, 0x96, 0x80, 0x00, 0x8C, 0xD4, 0x00, 0x9A, 0x05, 0xE0, 0x1F, 0x20,
  0x3F, 0x16, 0xE0, 0x04, 0xF0, 0x7C, 0x00, 0x8B, 0x04, 0xE0, 0x1E, 0x30, 0x09, 0xDC, 0x40, 0x00,
  // "Õ" (U+00D5)
  0x00, 0x79, 0x70, 0x00, 0x0E, 0xFF, 0x40, 0x09, 0xA0, 0x5E, 0x01, 0xF2, 0x03, 0xF1, 0x6E, 0x00,
  0x4F, 0x07, 0xC0, 0x08, 0xB0, 0x4E, 0x01, 0xE3, 0x00, 0x9D, 0xC4, 0x00,
  // "Ö" (U+00D6)
  0x00, 0x74, 0xA1, 0x00, 0x09, 0xCE, 0x40, 0x09, 0xA0, 0x5E, 0x01, 0xF2, 0x03, 0xF1, 0x6E, 0x00,
  0x4F, 0x07, 0xC0, 0x08, 0xB0, 0x4E, 0x01, 0xE3, 0x00, 0x9D, 0xC4, 0x00,
  // "×" (U+00D7)
  0x11, 0x03, 0x09, 0x84, 0x08, 0xA1, 0x14, 0x05,
  // "Ø" (U+00D8)
  0x00, 0x8C, 0xC9, 0x00, 0x9A, 0x09, 0xD0, 0x1F, 0x23, 0x7F, 0x16, 0xE0, 0x74, 0xF0, 0x7C, 0x71,
  0x8B, 0x03, 0xF5, 0x1E, 0x30, 0x1B, 0xCC, 0x40, 0x00,
  // "Ù" (U+00D9)
  0x00, 0x05, 0x30, 0x00, 0x00, 0x2A, 0x00, 0x1E, 0xF7, 0x6F, 0x70, 0x8A, 0x00, 0x90, 0x0B, 0x70,
  0x17, 0x00, 0xE4, 0x04, 0x40, 0x1F, 0x20, 0x71, 0x02, 0xF1, 0x0A, 0x00, 0x0A, 0xDB, 0x30, 0x00,
  // "Ú" (U+00DA)
  0x00, 0x00, 0x27, 0x00, 0x00, 0x0A, 0x30, 0x1E, 0xF7, 0x6F, 0x70, 0x8A, 0x00, 0x90, 0x0B, 0x70,
  0x17, 0x00, 0xE4, 0x04, 0x40, 0x1F, 0x20, 0x71, 0x02, 0xF1, 0x0A, 0x00, 0x0A, 0xDB, 0x30, 0x00,
  // "Û" (U+00DB)
  0x00, 0x01, 0x71, 0x00, 0x00, 0x96, 0x80, 0x1E, 0xF7, 0x6F, 0x70, 0x8A, 0x00, 0x90, 0x0B, 0x70,
  0x17, 0x00, 0xE4, 0x04, 0x40, 0x1F, 0x20, 0x71, 0x02, 0xF1, 0x0A, 0x00, 0x0A, 0xDB, 0x30, 0x00,
  // "Ü" (U+00DC)
  0x00, 0x74, 0xA1, 0x01, 0xEF, 0x87, 0xF7, 0x08, 0xA0, 0x09, 0x00, 0xB7, 0x01, 0x70, 0x0E, 0x40,
  0x44, 0x01, 0xF2, 0x07, 0x10, 0x2F, 0x10, 0xA0, 0x00, 0xAD, 0xB3, 0x00,
  // "Ý" (U+00DD)
  0x30, 0x20, 0x75, 0x0A, 0x03, 0x28, 0x93, 0x3F, 0xE3, 0xAE, 0x30, 0xAA, 0x06, 0x42, 0x82, 0x5D,
  0x08, 0x38, 0x21, 0xF9, 0x14, 0x0D, 0x07, 0x48, 0x11, 0xF3, 0x48, 0x1D, 0xFB, 0x30,
  // "Þ" (U+00DE)
  0x00, 0xDF, 0x80, 0x00, 0x07, 0xEC, 0x50, 0x00, 0xA9, 0x5E, 0x00, 0x0D, 0x63, 0xF1, 0x00, 0xF4,
  0x8C, 0x00, 0x3F, 0xCB, 0x20, 0x1D, 0xF7, 0x00, 0x00,
  // "ß" (U+00DF)
  0x38, 0x21, 0xBC, 0xB4, 0x83, 0xAA, 0x0D, 0x32, 0x84, 0x5F, 0x7C, 0x81, 0x28, 0x21, 0xF7, 0xD4,
  0x83, 0x4E, 0x0A, 0xC3, 0x84, 0x7C, 0xA0, 0xF1, 0x28, 0x3A, 0x99, 0xC9, 0x30, 0xE0, 0x44, 0x81,
  0x1C, 0x95,
  // "à" (U+00E0)
  0x20, 0x50, 0x33, 0x02, 0x0A, 0x78, 0xA6, 0x6C, 0xBA, 0x3E, 0x1A, 0x88, 0xA0, 0xD5, 0xA8, 0x3F,
  0x25, 0xD6, 0xD9,
  // "á" (U+00E1)
  0x30, 0x20, 0x73, 0x0A, 0x03, 0x68, 0xA6, 0x6C, 0xBA, 0x3E, 0x1A, 0x88, 0xA0, 0xD5, 0xA8, 0x3F,
  0x25, 0xD6, 0xD9,
  // "â" (U+00E2)
  0x00, 0x17, 0x10, 0x09, 0x68, 0x00, 0x00, 0x00, 0x6C, 0xBA, 0x3E, 0x1A, 0x88, 0xA0, 0xD5, 0xA8,
  0x3F, 0x25, 0xD6, 0xD9,
  // "ã" (U+00E3)
  0x00, 0x79, 0x70, 0x06, 0x78, 0x06, 0xCB, 0xA3, 0xE1, 0xA8, 0x8A, 0x0D, 0x5A, 0x83, 0xF2, 0x5D,
  0x6D, 0x90,
  // "ä" (U+00E4)
  0x07, 0x4A, 0x10, 0x00, 0x10, 0x06, 0xCB, 0xA3, 0xE1, 0xA8, 0x8A, 0x0D, 0x5A, 0x83, 0xF2, 0x5D,
  0x6D, 0x90,
  // "å" (U+00E5)
  0x00, 0x66, 0x00, 0x07, 0x70, 0x00, 0x66, 0x00, 0x6C, 0xBA, 0x3E, 0x1A, 0x88, 0xA0, 0xD5, 0xA8,
  0x3F, 0x25, 0xD6, 0xD9,
  // "æ" (U+00E6)
  0x06, 0xCA, 0x7C, 0xB3, 0xE1, 0x79, 0x5D, 0x8A, 0x0D, 0xDA, 0x2A, 0x83, 0xE5, 0x01, 0x5D, 0x66,
  0xDB, 0x20,
  // "ç" (U+00E7)
  0x06, 0xCD, 0x13, 0xD0, 0xB1, 0x99, 0x00, 0x09, 0x90, 0x10, 0x2F, 0xB5, 0x00, 0xC1, 0x00, 0x68,
  0x00, 0x00,
  // "è" (U+00E8)
  0x20, 0x50, 0x33, 0x02, 0x0A, 0x78, 0xA5, 0x5C, 0xD1, 0x3D, 0x2F, 0x19, 0xEB, 0x40, 0x99, 0x01,
  0x02, 0xCB, 0x51,
  // "é" (U+00E9)
  0x30, 0x20, 0x73, 0x0A, 0x03, 0x68, 0xA5, 0x5C, 0xD1, 0x3D, 0x2F, 0x19, 0xEB, 0x40, 0x99, 0x01,
  0x02, 0xCB, 0x51,
  // "ê" (U+00EA)
  0x00, 0x17, 0x10, 0x09, 0x68, 0x00, 0x00, 0x00, 0x5C, 0xD1, 0x3D, 0x2F, 0x19, 0xEB, 0x40, 0x99,
  0x01, 0x02, 0xCB, 0x50,
  // "ë" (U+00EB)
  0x07, 0x4A, 0x10, 0x00, 0x10, 0x05, 0xCD, 0x13, 0xD2, 0xF1, 0x9E, 0xB4, 0x09, 0x90, 0x10, 0x2C,
  0xB5, 0x00,
  // "ì" (U+00EC)
  0x53, 0x02, 0xA0, 0x00, 0x06, 0xF5, 0x0F, 0x23, 0xE0, 0x6C, 0x04, 0xD5,
  // "í" (U+00ED)
  0x02, 0x70, 0xA3, 0x00, 0x06, 0xF5, 0x0F, 0x23, 0xE0, 0x6C, 0x04, 0xD5,
  // "î" (U+00EE)
  0x17, 0x19, 0x68, 0x00, 0x06, 0xF5, 0x0F, 0x23, 0xE0, 0x6C, 0x04, 0xD5,
  // "ï" (U+00EF)
  0x74, 0xA1, 0x00, 0x10, 0x6F, 0x50, 0x0F, 0x20, 0x3E, 0x00, 0x6C, 0x00, 0x4D, 0x50,
  // "ð" (U+00F0)
  0x01, 0x10, 0x00, 0x1C, 0xA1, 0x02, 0x4C, 0x10, 0x8C, 0xE6, 0x4D, 0x0A, 0x89, 0x90, 0xA7, 0x99,
  0x0E, 0x23, 0xDC, 0x60,
  // "ñ" (U+00F1)
  0x00, 0x79, 0x70, 0x00, 0x67, 0x80, 0x6F, 0x8D, 0x80, 0x0F, 0x68, 0xA0, 0x3F, 0x0B, 0x70, 0x6C,
  0x0D, 0x50, 0x99, 0x0A, 0xB1,
  // "ò" (U+00F2)
  0x20, 0x50, 0x33, 0x02, 0x0A, 0x78, 0xA5, 0x6C, 0xC2, 0x4E, 0x09, 0x89, 0xA0, 0xA7, 0x99, 0x1E,
  0x33, 0xDC, 0x61,
  // "ó" (U+00F3)
  0x30, 0x20, 0x73, 0x0A, 0x03, 0x68, 0xA5, 0x6C, 0xC2, 0x4E, 0x09, 0x89, 0xA0, 0xA7, 0x99, 0x1E,
  0x33, 0xDC, 0x61,
  // "ô" (U+00F4)
  0x00, 0x17, 0x10, 0x09, 0x68, 0x00, 0x00, 0x00, 0x6C, 0xC2, 0x4E, 0x09, 0x89, 0xA0, 0xA7, 0x99,
  0x1E, 0x33, 0xDC, 0x60,
  // "õ" (U+00F5)
  0x00, 0x79, 0x70, 0x06, 0x78, 0x06, 0xCC, 0x24, 0xE0, 0x98, 0x9A, 0x0A, 0x79, 0x91, 0xE3, 0x3D,
  0xC6, 0x00,
  // "ö" (U+00F6)
  0x07, 0x4A, 0x10, 0x00, 0x10, 0x06, 0xCC, 0x24, 0xE0, 0x98, 0x9A, 0x0A, 0x79, 0x91, 0xE3, 0x3D,
  0xC6, 0x00,
  // "÷" (U+00F7)
  0x10, 0x10, 0x65, 0x05, 0x0F, 0xB5, 0x01, 0x06, 0x10,
  // "ø" (U+00F8)
  0x48, 0xB1, 0x40, 0x6C, 0xD4, 0x4E, 0x2E, 0x89, 0xA8, 0xB8, 0x9D, 0x2E, 0x36, 0xDC, 0x60, 0x44,
  // "ù" (U+00F9)
  0x20, 0x50, 0x34, 0x02, 0x0A, 0x71, 0x83, 0x6F, 0x54, 0xD2, 0x98, 0xA4, 0x27, 0xA0, 0x3E, 0x0B,
  0x70, 0x6C, 0x2F, 0x50, 0x4E, 0x6B, 0xB1,
  // "ú" (U+00FA)
  0x30, 0x20, 0x74, 0x0A, 0x03, 0x78, 0x36, 0xF5, 0x4D, 0x29, 0x8A, 0x42, 0x7A, 0x03, 0xE0, 0xB7,
  0x06, 0xC2, 0xF5, 0x04, 0xE6, 0xBB, 0x10,
  // "û" (U+00FB)
  0x00, 0x17, 0x10, 0x00, 0x96, 0x80, 0x00, 0x00, 0x00, 0x6F, 0x54, 0xD0, 0x0F, 0x27, 0xA0, 0x3E,
  0x0B, 0x70, 0x6C, 0x2F, 0x50, 0x4E, 0x6B, 0xB1,
  // "ü" (U+00FC)
  0x00, 0x74, 0xA1, 0x00, 0x00, 0x10, 0x6F, 0x54, 0xD0, 0x0F, 0x27, 0xA0, 0x3E, 0x0B, 0x70, 0x6C,
  0x2F, 0x50, 0x4E, 0x6B, 0xB1,
  // "ý" (U+00FD)
  0x40, 0x20, 0x75, 0x0A, 0x03, 0x73, 0x83, 0xDB, 0x0A, 0x42, 0x83, 0x4F, 0x06, 0x43, 0x90, 0x30,
  0x84, 0x81, 0xB9, 0x54, 0x07, 0x0B, 0x48, 0x11, 0xB2, 0x28, 0x23, 0xBB, 0x33,
  // "þ" (U+00FE)
  0x03, 0xE9, 0x00, 0x00, 0xC6, 0x00, 0x00, 0xE9, 0xD5, 0x02, 0xF3, 0x99, 0x05, 0xD0, 0xA8, 0x08,
  0x91, 0xE2, 0x0B, 0xDC, 0x60, 0x0E, 0x30, 0x00, 0x2F, 0xA0, 0x00,
  // "ÿ" (U+00FF)
  0x38, 0x27, 0x4A, 0x15, 0x01, 0x38, 0x3D, 0xB0, 0xA4, 0x28, 0x34, 0xF0, 0x64, 0x39, 0x03, 0x08,
  0x48, 0x1B, 0x95, 0x40, 0x70, 0xB4, 0x81, 0x1B, 0x22, 0x82, 0x3B, 0xB3, 0x30,
  // "Ā" (U+0100)
  0x00, 0x01, 0xFF, 0x30, 0x00, 0x7C, 0x80, 0x00, 0x0A, 0x8A, 0x00, 0x06, 0x47, 0xC0, 0x00, 0xC8,
  0xBE, 0x00, 0x65, 0x03, 0xF1, 0x4E, 0x90, 0xDF, 0x80,
  // "ā" (U+0101)
  0x00, 0xBB, 0x30, 0x6C, 0xBA, 0x3E, 0x1A, 0x88, 0xA0, 0xD5, 0xA8, 0x3F, 0x25, 0xD6, 0xD9,
  // "Ă" (U+0102)
  0x48, 0x15, 0x05, 0x4A, 0x02, 0x38, 0x17, 0xC8, 0x48, 0x1A, 0x8A, 0x38, 0x26, 0x47, 0xC3, 0x82,
  0xC8, 0xBE, 0x28, 0x93, 0x65, 0x03, 0xF1, 0x4E, 0x90, 0xDF, 0x80,
  // "ă" (U+0103)
  0x00, 0x50, 0x50, 0x06, 0xB2, 0x06, 0xCB, 0xA3, 0xE1, 0xA8, 0x8A, 0x0D, 0x5A, 0x83, 0xF2, 0x5D,
  0x6D, 0x90,
  // "Ą" (U+0104)
  0x40, 0xE0, 0x64, 0x81, 0x7C, 0x84, 0x81, 0xA8, 0xA3, 0x82, 0x64, 0x7C, 0x38, 0x2C, 0x8B, 0xE2,
  0x89, 0x36, 0x50, 0x3F, 0x14, 0xE9, 0x0D, 0xF8, 0x30, 0x20, 0x95, 0x81, 0x2A, 0x31,
  // "ą" (U+0105)
  0x06, 0xCB, 0xA3, 0xE1, 0xA8, 0x8A, 0x0D, 0x5A, 0x83, 0xF2, 0x5D, 0x6E, 0xA0, 0x02, 0x90, 0x00,
  0x2A, 0x30,
  // "Ć" (U+0106)
  0x00, 0x00, 0x27, 0x00, 0x00, 0xA3, 0x00, 0x8C, 0xE4, 0x08, 0xA0, 0x97, 0x1F, 0x30, 0x00, 0x5E,
  0x00, 0x00, 0x7D, 0x00, 0x00, 0x4E, 0x10, 0x30, 0x08, 0xDA, 0x50,
  // "ć" (U+0107)
  0x30, 0x20, 0x73, 0x0A, 0x03, 0x68, 0x91, 0x6C, 0xD1, 0x3D, 0x0B, 0x19, 0x93, 0x87, 0x99, 0x01,
  0x02, 0xDB, 0x51,
  // "Ĉ" (U+0108)
  0x00, 0x01, 0x71, 0x00, 0x09, 0x68, 0x00, 0x8C, 0xE4, 0x08, 0xA0, 0x97, 0x1F, 0x30, 0x00, 0x5E,
  0x00, 0x00, 0x7D, 0x00, 0x00, 0x4E, 0x10, 0x30, 0x08, 0xDA, 0x50,
  // "ĉ" (U+0109)
  0x00, 0x17, 0x10, 0x09, 0x68, 0x00, 0x00, 0x00, 0x6C, 0xD1, 0x3D, 0x0B, 0x19, 0x90, 0x00, 0x99,
  0x01, 0x02, 0xDB, 0x50,
  // "Ċ" (U+010A)
  0x00, 0x0B, 0x40, 0x00, 0x8D, 0xE4, 0x08, 0xA0, 0x97, 0x1F, 0x30, 0x00, 0x5E, 0x00, 0x00, 0x7D,
  0x00, 0x00, 0x4E, 0x10, 0x30, 0x08, 0xDA, 0x50,
  // "ċ" (U+010B)
  0x00, 0xB4, 0x00, 0x01, 0x00, 0x06, 0xCD, 0x13, 0xD0, 0xB1, 0x99, 0x00, 0x09, 0x90, 0x10, 0x2D,
  0xB5, 0x00,
  // "Č" (U+010C)
  0x00, 0x05, 0x05, 0x00, 0x07, 0xD3, 0x00, 0x8C, 0xE4, 0x08, 0xA0, 0x97, 0x1F, 0x30, 0x00, 0x5E,
  0x00, 0x00, 0x7D, 0x00, 0x00, 0x4E, 0x10, 0x30, 0x08, 0xDA, 0x50,
  // "č" (U+010D)
  0x00, 0x50, 0x50, 0x07, 0xD3, 0x00, 0x00, 0x00, 0x6C, 0xD1, 0x3D, 0x0B, 0x19, 0x90, 0x00, 0x99,
  0x01, 0x02, 0xDB, 0x50,
  // "Ď" (U+010E)
  0x00, 0x05, 0x05, 0x00, 0x00, 0x7D, 0x30, 0x00, 0xDF, 0xCC, 0x20, 0x07, 0xC0, 0x9C, 0x00, 0xA9,
  0x05, 0xE0, 0x0D, 0x60, 0x6D, 0x00, 0xF3, 0x0A, 0xA0, 0x3F, 0x03, 0xE3, 0x1D, 0xFC, 0xD4, 0x00,
  // "ď" (U+010F)
  0x00, 0x0A, 0xF5, 0x90, 0x00, 0x4E, 0x40, 0x06, 0xCD, 0xB0, 0x03, 0xE1, 0xA8, 0x00, 0x8A, 0x0D,
  0x50, 0x0A, 0x83, 0xF2, 0x00, 0x5D, 0x6D, 0x90, 0x00,
  // "Đ" (U+0110)
  0x00, 0xDF, 0xCC, 0x20, 0x07, 0xC0, 0x9C, 0x00, 0xA9, 0x05, 0xE0, 0x5E, 0xD5, 0x6D, 0x00, 0xF4,
  0x0A, 0xA0, 0x3F, 0x13, 0xE3, 0x1D, 0xFC, 0xD4, 0x00,
  // "đ" (U+0111)
  0x00, 0x0A, 0xF1, 0x00, 0x6C, 0xF7, 0x07, 0xCD, 0xB0, 0x3E, 0x1A, 0x80, 0x89, 0x0D, 0x50, 0xA8,
  0x4F, 0x20, 0x5D, 0x6D, 0x90,
  // "Ē" (U+0112)
  0x20, 0xBB, 0x04, 0x28, 0x37, 0xB0, 0x51, 0x20, 0xA0, 0x95, 0x82, 0xDD, 0xB3, 0x39, 0x04, 0x48,
  0x92, 0x2F, 0x10, 0x60, 0x1A, 0xF7, 0x98, 0x10,
  // "ē" (U+0113)
  0x00, 0xBB, 0x30, 0x5C, 0xD1, 0x3D, 0x2F, 0x19, 0xEB, 0x40, 0x99, 0x01, 0x02, 0xCB, 0x50,
  // "Ĕ" (U+0114)
  0x00, 0x05, 0x05, 0x00, 0x0B, 0xFF, 0xE4, 0x00, 0x7B, 0x05, 0x10, 0x0A, 0x90, 0x00, 0x00, 0xDD,
  0xB3, 0x00, 0x0F, 0x40, 0x00, 0x02, 0xF1, 0x06, 0x01, 0xAF, 0x79, 0x80,
  // "ĕ" (U+0115)
  0x00, 0x50, 0x50, 0x06, 0xB2, 0x05, 0xCD, 0x13, 0xD2, 0xF1, 0x9E, 0xB4, 0x09, 0x90, 0x10, 0x2C,
  0xB5, 0x00,
  // "Ė" (U+0116)
  0x40, 0xB0, 0x43, 0x83, 0xBE, 0x8C, 0x42, 0x83, 0x7B, 0x05, 0x12, 0x0A, 0x09, 0x58, 0x2D, 0xDB,
  0x33, 0x90, 0x44, 0x89, 0x22, 0xF1, 0x06, 0x01, 0xAF, 0x79, 0x81,
  // "ė" (U+0117)
  0x00, 0xB4, 0x00, 0x01, 0x00, 0x05, 0xCD, 0x13, 0xD2, 0xF1, 0x9E, 0xB4, 0x09, 0x90, 0x10, 0x2C,
  0xB5, 0x00,
  // "Ę" (U+0118)
  0x28, 0x3B, 0xE7, 0xC4, 0x28, 0x37, 0xB0, 0x51, 0x20, 0xA0, 0x95, 0x82, 0xDD, 0xB3, 0x39, 0x04,
  0x48, 0x92, 0x2F, 0x10, 0x60, 0x1A, 0xF7, 0xA8, 0x40, 0x20, 0x95, 0x81, 0x2A, 0x31,
  // "ę" (U+0119)
  0x05, 0xCD, 0x13, 0xD2, 0xF1, 0x9E, 0xB4, 0x09, 0x90, 0x10, 0x2C, 0xC6, 0x00, 0x29, 0x00, 0x02,
  0xA3, 0x00,
  // "Ě" (U+011A)
  0x38, 0x15, 0x05, 0x48, 0x17, 0xD3, 0x38, 0x3B, 0xE7, 0xC4, 0x28, 0x37, 0xB0, 0x51, 0x20, 0xA0,
  0x95, 0x82, 0xDD, 0xB3, 0x39, 0x04, 0x48, 0x92, 0x2F, 0x10, 0x60, 0x1A, 0xF7, 0x98, 0x10,
  // "ě" (U+011B)
  0x00, 0x50, 0x50, 0x07, 0xD3, 0x00, 0x00, 0x00, 0x5C, 0xD1, 0x3D, 0x2F, 0x19, 0xEB, 0x40, 0x99,
  0x01, 0x02, 0xCB, 0x50,
  // "Ĝ" (U+011C)
  0x00, 0x01, 0x71, 0x00, 0x09, 0x68, 0x00, 0x7B, 0xD8, 0x08, 0xB0, 0x4E, 0x1F, 0x30, 0x02, 0x6E,
  0x00, 0x00, 0x7D, 0x07, 0xDC, 0x4E, 0x01, 0xF3, 0x08, 0xCC, 0xC0,
  // "ĝ" (U+011D)
  0x00, 0x17, 0x10, 0x00, 0x96, 0x80, 0x00, 0x00, 0x2B, 0x00, 0x9C, 0xE5, 0x03, 0xC2, 0xF0, 0x01,
  0xDB, 0x50, 0x07, 0x93, 0x00, 0x08, 0xCE, 0xA0, 0x59, 0x04, 0xB0, 0x2C, 0xBB, 0x20,
  // "Ğ" (U+011E)
  0x00, 0x05, 0x05, 0x00, 0x7F, 0xFA, 0x08, 0xB0, 0x4E, 0x1F, 0x30, 0x02, 0x6E, 0x00, 0x00, 0x7D,
  0x07, 0xDC, 0x4E, 0x01, 0xF3, 0x08, 0xCC, 0xC0,
  // "ğ" (U+011F)
  0x00, 0x50, 0x50, 0x00, 0x6B, 0x4B, 0x00, 0x9C, 0xE5, 0x03, 0xC2, 0xF0, 0x01, 0xDB, 0x50, 0x07,
  0x93, 0x00, 0x08, 0xCE, 0xA0, 0x59, 0x04, 0xB0, 0x2C, 0xBB, 0x20,
  // "Ġ" (U+0120)
  0x00, 0x0B, 0x40, 0x00, 0x7D, 0xD8, 0x08, 0xB0, 0x4E, 0x1F, 0x30, 0x02, 0x6E, 0x00, 0x00, 0x7D,
  0x07, 0xDC, 0x4E, 0x01, 0xF3, 0x08, 0xCC, 0xC0,
  // "ġ" (U+0121)
  0x00, 0x0B, 0x40, 0x00, 0x01, 0x2B, 0x00, 0x9C, 0xE5, 0x03, 0xC2, 0xF0, 0x01, 0xDB, 0x50, 0x07,
  0x93, 0x00, 0x08, 0xCE, 0xA0, 0x59, 0x04, 0xB0, 0x2C, 0xBB, 0x20,
  // "Ģ" (U+0122)
  0x00, 0x7B, 0xD8, 0x08, 0xB0, 0x4E, 0x1F, 0x30, 0x02, 0x6E, 0x00, 0x00, 0x7D, 0x07, 0xDC, 0x4E,
  0x01, 0xF3, 0x08, 0xCC, 0xC0, 0x00, 0x70, 0x00, 0x04, 0x60, 0x00,
  // "ģ" (U+0123)
  0x00, 0x03, 0x70, 0x00, 0x00, 0x2B, 0x00, 0x9C, 0xE5, 0x03, 0xC2, 0xF0, 0x01, 0xDB, 0x50, 0x07,
  0x93, 0x00, 0x08, 0xCE, 0xA0, 0x59, 0x04, 0xB0, 0x2C, 0xBB, 0x20,
  // "Ĥ" (U+0124)
  0x00, 0x00, 0x17, 0x10, 0x00, 0x00, 0x96, 0x80, 0x00, 0xDF, 0x98, 0xFD, 0x00, 0x7C, 0x01, 0xF2,
  0x00, 0xA9, 0x04, 0xE0, 0x00, 0xDD, 0xBD, 0xB0, 0x00, 0xF4, 0x0A, 0x90, 0x03, 0xF0, 0x0D, 0x60,
  0x1D, 0xF7, 0xAF, 0xC0,
  // "ĥ" (U+0125)
  0x00, 0x17, 0x10, 0x09, 0x68, 0x00, 0x00, 0x03, 0xE9, 0x00, 0x0C, 0x60, 0x00, 0xE8, 0xD6, 0x2F,
  0x4A, 0x85, 0xD0, 0xC5, 0x8A, 0x0F, 0x3B, 0x70, 0xCA,
  // "Ħ" (U+0126)
  0x00, 0xDF, 0x98, 0xFD, 0x00, 0x6C, 0x01, 0xF2, 0x04, 0xED, 0xBC, 0xFA, 0x00, 0xBD, 0xBD, 0xD0,
  0x00, 0xE4, 0x0A, 0x90, 0x03, 0xF0, 0x0D, 0x60, 0x1D, 0xF7, 0xAF, 0xC0,
  // "ħ" (U+0127)
  0x3E, 0x90, 0x05, 0xED, 0x70, 0x0E, 0x9E, 0x52, 0xF4, 0xB8, 0x5D, 0x0D, 0x58, 0xA0, 0xF3, 0xB7,
  0x0C, 0xA0,
  // "Ĩ" (U+0128)
  0x00, 0x79, 0x70, 0x0F, 0xFF, 0x00, 0x7C, 0x00, 0x0A, 0x90, 0x00, 0xD6, 0x00, 0x0F, 0x30, 0x03,
  0xF0, 0x01, 0xDF, 0x70,
  // "ĩ" (U+0129)
  0x79, 0x76, 0x78, 0x6F, 0x50, 0xF2, 0x3E, 0x06, 0xC0, 0x4D, 0x50,
  // "Ī" (U+012A)
  0x00, 0xFF, 0xC0, 0x07, 0xC0, 0x00, 0xA9, 0x00, 0x0D, 0x60, 0x00, 0xF3, 0x00, 0x3F, 0x00, 0x1D,
  0xF7, 0x00,
  // "ī" (U+012B)
  0x0B, 0xB3, 0x6F, 0x50, 0x0F, 0x20, 0x3E, 0x00, 0x6C, 0x00, 0x4D, 0x50,
  // "Ĭ" (U+012C)
  0x00, 0x50, 0x50, 0x0F, 0xFB, 0x00, 0x7C, 0x00, 0x0A, 0x90, 0x00, 0xD6, 0x00, 0x0F, 0x30, 0x03,
  0xF0, 0x01, 0xDF, 0x70,
  // "ĭ" (U+012D)
  0x05, 0x05, 0x06, 0xB2, 0x6F, 0x50, 0x0F, 0x20, 0x3E, 0x00, 0x6C, 0x00, 0x4D, 0x50,
  // "Į" (U+012E)
  0x00, 0xDF, 0x90, 0x07, 0xC0, 0x00, 0xA9, 0x00, 0x0D, 0x60, 0x00, 0xF3, 0x00, 0x3F, 0x00, 0x1E,
  0xF7, 0x02, 0x90, 0x00, 0x2A, 0x30, 0x00,
  // "į" (U+012F)
  0x09, 0x70, 0x00, 0x6F, 0x50, 0xF2, 0x3E, 0x06, 0xC0, 0x4E, 0x52, 0x90, 0x2A, 0x30,
  // "İ" (U+0130)
  0x00, 0x0B, 0x40, 0x0D, 0xF9, 0x00, 0x7C, 0x00, 0x0A, 0x90, 0x00, 0xD6, 0x00, 0x0F, 0x30, 0x03,
  0xF0, 0x01, 0xDF, 0x70,
  // "ı" (U+0131)
  0x6F, 0x50, 0xF2, 0x3E, 0x06, 0xC0, 0x4D, 0x50,
  // "Ĳ" (U+0132)
  0x28, 0x4D, 0xF9, 0xDF, 0x92, 0x83, 0x7C, 0x07, 0xC3, 0x83, 0xA9, 0x0A, 0x93, 0x83, 0xD6, 0x0D,
  0x63, 0x98, 0x23, 0x0F, 0x32, 0x82, 0x3F, 0x03, 0x92, 0x84, 0x1D, 0xF7, 0x6D, 0x60, 0xB0, 0x94,
  0x81, 0x2B, 0xA3,
  // "ĳ" (U+0133)
  0x18, 0x39, 0x70, 0x97, 0x68, 0xB3, 0x6F, 0x56, 0xF5, 0x0F, 0x20, 0xF2, 0x3E, 0x03, 0xE0, 0x6C,
  0x07, 0xB0, 0x4D, 0x5A, 0x84, 0x0E, 0x05, 0x30, 0xC0, 0xA2,
  // "Ĵ" (U+0134)
  0x38, 0x11, 0x71, 0x38, 0x19, 0x68, 0x38, 0x1D, 0xF9, 0x30, 0x70, 0xC4, 0x0A, 0x09, 0x40, 0xD0,
  0x64, 0x90, 0x33, 0x03, 0x94, 0x06, 0x0D, 0x40, 0xB0, 0x92, 0x81, 0x2B, 0xA3,
  // "ĵ" (U+0135)
  0x01, 0x71, 0x09, 0x68, 0x00, 0x00, 0x06, 0xF5, 0x00, 0xF2, 0x03, 0xE0, 0x07, 0xB0, 0x0A, 0x80,
  0x0E, 0x50, 0xCA, 0x00,
  // "Ķ" (U+0136)
  0x28, 0x4D, 0xF9, 0xAF, 0x52, 0x83, 0x7C, 0x09, 0x33, 0x82, 0xA9, 0x82, 0x48, 0x2D, 0xDF, 0x14,
  0x98, 0x14, 0xE6, 0x38, 0x33, 0xF0, 0xAC, 0x28, 0x51, 0xDF, 0x73, 0xE6, 0x40, 0x76, 0x04, 0x06,
  0x40,
  // "ķ" (U+0137)
  0x3E, 0x90, 0x00, 0xC6, 0x00, 0x0E, 0x3E, 0xD2, 0xF3, 0x90, 0x5E, 0xE4, 0x08, 0xA9, 0xB0, 0xB7,
  0x2D, 0x60, 0x70, 0x00, 0x46, 0x00, 0x00,
  // "ĸ" (U+0138)
  0x8F, 0x3E, 0xD2, 0xF3, 0x90, 0x5E, 0xE4, 0x08, 0xA9, 0xB0, 0xB7, 0x2D, 0x60,
  // "Ĺ" (U+0139)
  0x30, 0x20, 0x74, 0x0A, 0x03, 0x38, 0x1B, 0xF5, 0x30, 0x70, 0xB4, 0x0A, 0x09, 0x40, 0xD0, 0x64,
  0x98, 0x95, 0x40, 0x10, 0x2F, 0x10, 0x81, 0xAF, 0x78, 0x90,
  // "ĺ" (U+013A)
  0x00, 0x27, 0x00, 0xA3, 0x00, 0x00, 0x3E, 0x90, 0x0C, 0x60, 0x0E, 0x30, 0x2F, 0x00, 0x5D, 0x00,
  0x8A, 0x00, 0x6D, 0x30,
  // "Ļ" (U+013B)
  0x28, 0x1B, 0xF5, 0x30, 0x70, 0xB4, 0x0A, 0x09, 0x40, 0xD0, 0x64, 0x98, 0x95, 0x40, 0x10, 0x2F,
  0x10, 0x81, 0xAF, 0x78, 0x93, 0x07, 0x40, 0x40, 0x62,
  // "ļ" (U+013C)
  0x03, 0xE9, 0x00, 0xC6, 0x00, 0xE3, 0x02, 0xF0, 0x05, 0xD0, 0x08, 0xA0, 0x06, 0xD3, 0x07, 0x00,
  0x46, 0x00,
  // "Ľ" (U+013D)
  0x00, 0xBF, 0x5B, 0x20, 0x07, 0xB0, 0x40, 0x00, 0xA9, 0x00, 0x00, 0x0D, 0x60, 0x00, 0x00, 0xF4,
  0x01, 0x00, 0x2F, 0x10, 0x80, 0x1A, 0xF7, 0x89, 0x00,
  // "ľ" (U+013E)
  0x3E, 0x9B, 0x20, 0xC7, 0x50, 0x0E, 0x30, 0x02, 0xF0, 0x00, 0x5D, 0x00, 0x08, 0xA0, 0x00, 0x6D,
  0x30, 0x00,
  // "Ŀ" (U+013F)
  0x28, 0x1B, 0xF5, 0x40, 0x70, 0xB5, 0x0A, 0x09, 0x58, 0x3D, 0x60, 0xB4, 0x29, 0x81, 0x40, 0x22,
  0x89, 0x22, 0xF1, 0x08, 0x01, 0xAF, 0x78, 0x91,
  // "ŀ" (U+0140)
  0x3E, 0x90, 0x0C, 0x60, 0x0E, 0x30, 0x2F, 0xC4, 0x5D, 0x10, 0x8A, 0x00, 0x6D, 0x30,
  // "Ł" (U+0141)
  0x00, 0xBF, 0x50, 0x00, 0x7B, 0x00, 0x00, 0xAC, 0x70, 0x01, 0xD8, 0x00, 0x05, 0xF4, 0x01, 0x02,
  0xF1, 0x08, 0x1A, 0xF7, 0x89,
  // "ł" (U+0142)
  0x3E, 0x90, 0xC6, 0x0E, 0x42, 0xF7, 0xBD, 0x08, 0xA0, 0x6D, 0x30,
  // "Ń" (U+0143)
  0x00, 0x00, 0x02, 0x70, 0x00, 0x00, 0x0A, 0x30, 0x00, 0xDE, 0x01, 0xEB, 0x00, 0x7E, 0x60, 0x90,
  0x00, 0x98, 0xC0, 0x90, 0x00, 0x92, 0xF3, 0x90, 0x00, 0x80, 0xBB, 0x70, 0x03, 0x60, 0x5F, 0x40,
  0x1D, 0xB0, 0x0E, 0x10,
  // "ń" (U+0144)
  0x30, 0x20, 0x74, 0x0A, 0x03, 0x78, 0x36, 0xF8, 0xD8, 0x29, 0x8A, 0x46, 0x8A, 0x03, 0xF0, 0xB7,
  0x06, 0xC0, 0xD5, 0x09, 0x90, 0xAB, 0x10,
  // "Ņ" (U+0145)
  0x28, 0x4D, 0xE0, 0x1E, 0xB2, 0x83, 0x7E, 0x60, 0x93, 0x83, 0x98, 0xC0, 0x93, 0x83, 0x92, 0xF3,
  0x93, 0x83, 0x80, 0xBB, 0x72, 0x89, 0x03, 0x60, 0x5F, 0x40, 0x1D, 0xB2, 0x0E, 0x01, 0x40, 0x76,
  0x04, 0x06, 0x40,
  // "ņ" (U+0146)
  0x6F, 0x8D, 0x80, 0x0F, 0x68, 0xA0, 0x3F, 0x0B, 0x70, 0x6C, 0x0D, 0x50, 0x99, 0x0A, 0xB1, 0x00,
  0x70, 0x00, 0x04, 0x60, 0x00,
  // "Ň" (U+0147)
  0x00, 0x00, 0x50, 0x50, 0x00, 0x00, 0x7D, 0x30, 0x00, 0xDE, 0x01, 0xEB, 0x00, 0x7E, 0x60, 0x90,
  0x00, 0x98, 0xC0, 0x90, 0x00, 0x92, 0xF3, 0x90, 0x00, 0x80, 0xBB, 0x70, 0x03, 0x60, 0x5F, 0x40,
  0x1D, 0xB0, 0x0E, 0x10,
  // "ň" (U+0148)
  0x00, 0x50, 0x50, 0x00, 0x7D, 0x30, 0x00, 0x00, 0x00, 0x6F, 0x8D, 0x80, 0x0F, 0x68, 0xA0, 0x3F,
  0x0B, 0x70, 0x6C, 0x0D, 0x50, 0x99, 0x0A, 0xB1,
  // "ŉ" (U+0149)
  0x10, 0xB0, 0x46, 0x07, 0x04, 0x58, 0x51, 0x66, 0xF8, 0xD8, 0x49, 0x81, 0x68, 0xA3, 0x83, 0x3F,
  0x0B, 0x73, 0x83, 0x6C, 0x0D, 0x53, 0x84, 0x99, 0x0A, 0xB1,
  // "Ŋ" (U+014A)
  0x28, 0x4D, 0xE0, 0x1E, 0xB2, 0x83, 0x7E, 0x60, 0x93, 0x83, 0x98, 0xC0, 0x93, 0x83, 0x92, 0xF3,
  0x93, 0x83, 0x80, 0xBB, 0x62, 0x89, 0x03, 0x60, 0x5F, 0x30, 0x1D, 0xB2, 0x0E, 0x01, 0x60, 0xB5,
  0x81, 0x6C, 0x32,
  // "ŋ" (U+014B)
  0x6F, 0x8D, 0x80, 0xF6, 0x8A, 0x3F, 0x0B, 0x76, 0xC0, 0xE4, 0x99, 0x1F, 0x10, 0x06, 0xD0, 0x05,
  0xD5, 0x00,
  // "Ō" (U+014C)
  0x00, 0x9F, 0xF7, 0x00, 0x9A, 0x05, 0xE0, 0x1F, 0x20, 0x3F, 0x16, 0xE0, 0x04, 0xF0, 0x7C, 0x00,
  0x8B, 0x04, 0xE0, 0x1E, 0x30, 0x09, 0xDC, 0x40, 0x00,
  // "ō" (U+014D)
  0x00, 0xBB, 0x30, 0x6C, 0xC2, 0x4E, 0x09, 0x89, 0xA0, 0xA7, 0x99, 0x1E, 0x33, 0xDC, 0x60,
  // "Ŏ" (U+014E)
  0x00, 0x05, 0x05, 0x00, 0x08, 0xFF, 0x60, 0x09, 0xA0, 0x5E, 0x01, 0xF2, 0x03, 0xF1, 0x6E, 0x00,
  0x4F, 0x07, 0xC0, 0x08, 0xB0, 0x4E, 0x01, 0xE3, 0x00, 0x9D, 0xC4, 0x00,
  // "ŏ" (U+014F)
  0x00, 0x50, 0x50, 0x06, 0xB2, 0x06, 0xCC, 0x24, 0xE0, 0x98, 0x9A, 0x0A, 0x79, 0x91, 0xE3, 0x3D,
  0xC6, 0x00,
  // "Ő" (U+0150)
  0x00, 0x08, 0x7A, 0x00, 0x08, 0xDE, 0x40, 0x09, 0xA0, 0x5E, 0x01, 0xF2, 0x03, 0xF1, 0x6E, 0x00,
  0x4F, 0x07, 0xC0, 0x08, 0xB0, 0x4E, 0x01, 0xE3, 0x00, 0x9D, 0xC4, 0x00,
  // "ő" (U+0151)
  0x00, 0x87, 0xA0, 0x01, 0x10, 0x06, 0xCC, 0x24, 0xE0, 0x98, 0x9A, 0x0A, 0x79, 0x91, 0xE3, 0x3D,
  0xC6, 0x00,
  // "Œ" (U+0152)
  0x00, 0x8A, 0xDE, 0x9E, 0x20, 0x99, 0x0A, 0x90, 0x70, 0x1F, 0x20, 0xC7, 0x00, 0x06, 0xE0, 0x0F,
  0xCB, 0x10, 0x7C, 0x02, 0xF2, 0x00, 0x04, 0xE0, 0x5E, 0x01, 0x60, 0x09, 0xBC, 0xE9, 0xC5, 0x00,
  // "œ" (U+0153)
  0x06, 0xCC, 0x6B, 0xD0, 0x3E, 0x09, 0xC2, 0xF1, 0x9A, 0x0A, 0xDB, 0x30, 0x99, 0x1E, 0x80, 0x10,
  0x3D, 0xC7, 0xCB, 0x40,
  // "Ŕ" (U+0154)
  0x00, 0x00, 0x27, 0x00, 0x00, 0x0A, 0x30, 0x00, 0xDF, 0xCC, 0x20, 0x07, 0xC0, 0xE6, 0x00, 0xA8,
  0x1F, 0x30, 0x0D, 0xDF, 0x50, 0x00, 0xF3, 0xE5, 0x00, 0x3F, 0x0A, 0xA0, 0x1D, 0xF9, 0x3E, 0x40,
  // "ŕ" (U+0155)
  0x20, 0x20, 0x73, 0x0A, 0x03, 0x68, 0x91, 0x6F, 0x8D, 0x40, 0xF6, 0x41, 0x39, 0x30, 0x60, 0xC3,
  0x00, 0x93,
  // "Ŗ" (U+0156)
  0x00, 0xDF, 0xCC, 0x20, 0x07, 0xC0, 0xE6, 0x00, 0xA8, 0x1F, 0x30, 0x0D, 0xDF, 0x50, 0x00, 0xF3,
  0xE5, 0x00, 0x3F, 0x0A, 0xA0, 0x1D, 0xF9, 0x3E, 0x40, 0x00, 0x70, 0x00, 0x00, 0x46, 0x00, 0x00,
  // "ŗ" (U+0157)
  0x18, 0x36, 0xF8, 0xD4, 0x29, 0x83, 0x64, 0x10, 0x39, 0x40, 0x60, 0xC4, 0x00, 0x94, 0x07, 0x40,
  0x40, 0x64,
  // "Ř" (U+0158)
  0x00, 0x05, 0x05, 0x00, 0x00, 0x7D, 0x30, 0x00, 0xDF, 0xCC, 0x20, 0x07, 0xC0, 0xE6, 0x00, 0xA8,
  0x1F, 0x30, 0x0D, 0xDF, 0x50, 0x00, 0xF3, 0xE5, 0x00, 0x3F, 0x0A, 0xA0, 0x1D, 0xF9, 0x3E, 0x40,
  // "ř" (U+0159)
  0x18, 0x15, 0x05, 0x28, 0x17, 0xD3, 0x68, 0x91, 0x6F, 0x8D, 0x40, 0xF6, 0x41, 0x39, 0x30, 0x60,
  0xC3, 0x00, 0x93,
  // "Ś" (U+015A)
  0x00, 0x02, 0x70, 0x00, 0xA3, 0x05, 0x9C, 0x60, 0xE1, 0x47, 0x0F, 0x90, 0x00, 0x7F, 0xB0, 0x10,
  0x5F, 0x3C, 0x40, 0xD2, 0x6B, 0x87, 0x00,
  // "ś" (U+015B)
  0x00, 0x27, 0x00, 0xA3, 0x00, 0x00, 0x1B, 0x99, 0x5D, 0x24, 0x0B, 0xE3, 0x70, 0xA8, 0x89, 0xB2,
  // "Ŝ" (U+015C)
  0x00, 0x17, 0x10, 0x09, 0x68, 0x05, 0x9C, 0x60, 0xE1, 0x47, 0x0F, 0x90, 0x00, 0x7F, 0xB0, 0x10,
  0x5F, 0x3C, 0x40, 0xD2, 0x6B, 0x87, 0x00,
  // "ŝ" (U+015D)
  0x01, 0x71, 0x09, 0x68, 0x00, 0x00, 0x1B, 0x99, 0x5D, 0x24, 0x0B, 0xE3, 0x70, 0xA8, 0x89, 0xB2,
  // "Ş" (U+015E)
  0x05, 0x9C, 0x60, 0xE1, 0x47, 0x0F, 0x90, 0x00, 0x7F, 0xB0, 0x10, 0x5F, 0x3C, 0x40, 0xD2, 0x6B,
  0xE7, 0x00, 0x0C, 0x10, 0x06, 0x80, 0x00,
  // "ş" (U+015F)
  0x1B, 0x99, 0x5D, 0x24, 0x0B, 0xE3, 0x70, 0xA8, 0x8F, 0xB2, 0x0C, 0x10, 0x68, 0x00,
  // "Š" (U+0160)
  0x00, 0x50, 0x50, 0x07, 0xD3, 0x05, 0x9C, 0x60, 0xE1, 0x47, 0x0F, 0x90, 0x00, 0x7F, 0xB0, 0x10,
  0x5F, 0x3C, 0x40, 0xD2, 0x6B, 0x87, 0x00,
  // "š" (U+0161)
  0x05, 0x05, 0x07, 0xD3, 0x00, 0x00, 0x1B, 0x99, 0x5D, 0x24, 0x0B, 0xE3, 0x70, 0xA8, 0x89, 0xB2,
  // "Ţ" (U+0162)
  0x89, 0x22, 0xED, 0xFC, 0xC5, 0x37, 0xC0, 0x82, 0x0A, 0x09, 0x40, 0xD0, 0x64, 0x90, 0x33, 0x03,
  0x93, 0x82, 0x1D, 0xF7, 0x40, 0xC0, 0x13, 0x06, 0x08, 0x30,
  // "ţ" (U+0163)
  0x06, 0x80, 0x5F, 0xC4, 0x0F, 0x20, 0x3E, 0x00, 0x6C, 0x00, 0x4F, 0x70, 0x0C, 0x10, 0x68, 0x00,
  // "Ť" (U+0164)
  0x28, 0x15, 0x05, 0x38, 0x96, 0x7D, 0x30, 0x2E, 0xDF, 0xCC, 0x53, 0x7C, 0x08, 0x20, 0xA0, 0x94,
  0x0D, 0x06, 0x49, 0x03, 0x30, 0x39, 0x38, 0x21, 0xDF, 0x72,
  // "ť" (U+0165)
  0x00, 0x0B, 0x20, 0x68, 0x30, 0x5F, 0xC4, 0x00, 0xF2, 0x00, 0x3E, 0x00, 0x06, 0xC0, 0x00, 0x4D,
  0x70, 0x00,
  // "Ŧ" (U+0166)
  0x2E, 0xDF, 0xCC, 0x53, 0x7C, 0x08, 0x00, 0xA9, 0x00, 0x0B, 0xED, 0x60, 0x00, 0xF4, 0x00, 0x03,
  0xF1, 0x00, 0x1D, 0xF7, 0x00,
  // "ŧ" (U+0167)
  0x06, 0x80, 0x5F, 0xC4, 0x0F, 0x30, 0x9F, 0xB0, 0x5D, 0x00, 0x4E, 0x70,
  // "Ũ" (U+0168)
  0x00, 0x07, 0x97, 0x01, 0xEF, 0xDD, 0xF7, 0x08, 0xA0, 0x09, 0x00, 0xB7, 0x01, 0x70, 0x0E, 0x40,
  0x44, 0x01, 0xF2, 0x07, 0x10, 0x2F, 0x10, 0xA0, 0x00, 0xAD, 0xB3, 0x00,
  // "ũ" (U+0169)
  0x00, 0x79, 0x70, 0x00, 0x67, 0x80, 0x6F, 0x54, 0xD0, 0x0F, 0x27, 0xA0, 0x3E, 0x0B, 0x70, 0x6C,
  0x2F, 0x50, 0x4E, 0x6B, 0xB1,
  // "Ū" (U+016A)
  0x1E, 0xFF, 0xFF, 0x70, 0x8A, 0x00, 0x90, 0x0B, 0x70, 0x17, 0x00, 0xE4, 0x04, 0x40, 0x1F, 0x20,
  0x71, 0x02, 0xF1, 0x0A, 0x00, 0x0A, 0xDB, 0x30, 0x00,
  // "ū" (U+016B)
  0x00, 0xBB, 0x30, 0x6F, 0x54, 0xD0, 0x0F, 0x27, 0xA0, 0x3E, 0x0B, 0x70, 0x6C, 0x2F, 0x50, 0x4E,
  0x6B, 0xB1,
  // "Ŭ" (U+016C)
  0x00, 0x05, 0x05, 0x01, 0xEF, 0xDF, 0xF7, 0x08, 0xA0, 0x09, 0x00, 0xB7, 0x01, 0x70, 0x0E, 0x40,
  0x44, 0x01, 0xF2, 0x07, 0x10, 0x2F, 0x10, 0xA0, 0x00, 0xAD, 0xB3, 0x00,
  // "ŭ" (U+016D)
  0x00, 0x50, 0x50, 0x00, 0x6B, 0x20, 0x6F, 0x54, 0xD0, 0x0F, 0x27, 0xA0, 0x3E, 0x0B, 0x70, 0x6C,
  0x2F, 0x50, 0x4E, 0x6B, 0xB1,
  // "Ů" (U+016E)
  0x00, 0x06, 0x60, 0x00, 0x00, 0x77, 0x00, 0x1E, 0xFE, 0xDF, 0x70, 0x8A, 0x00, 0x90, 0x0B, 0x70,
  0x17, 0x00, 0xE4, 0x04, 0x40, 0x1F, 0x20, 0x71, 0x02, 0xF1, 0x0A, 0x00, 0x0A, 0xDB, 0x30, 0x00,
  // "ů" (U+016F)
  0x00, 0x66, 0x00, 0x00, 0x77, 0x00, 0x00, 0x66, 0x00, 0x6F, 0x54, 0xD0, 0x0F, 0x27, 0xA0, 0x3E,
  0x0B, 0x70, 0x6C, 0x2F, 0x50, 0x4E, 0x6B, 0xB1,
  // "Ű" (U+0170)
  0x00, 0x08, 0x7A, 0x01, 0xEF, 0x97, 0xF7, 0x08, 0xA0, 0x09, 0x00, 0xB7, 0x01, 0x70, 0x0E, 0x40,
  0x44, 0x01, 0xF2, 0x07, 0x10, 0x2F, 0x10, 0xA0, 0x00, 0xAD, 0xB3, 0x00,
  // "ű" (U+0171)
  0x00, 0x87, 0xA0, 0x00, 0x11, 0x00, 0x6F, 0x54, 0xD0, 0x0F, 0x27, 0xA0, 0x3E, 0x0B, 0x70, 0x6C,
  0x2F, 0x50, 0x4E, 0x6B, 0xB1,
  // "Ų" (U+0172)
  0x1E, 0xF7, 0x6F, 0x70, 0x8A, 0x00, 0x90, 0x0B, 0x70, 0x17, 0x00, 0xE4, 0x04, 0x40, 0x1F, 0x20,
  0x71, 0x02, 0xF1, 0x0A, 0x00, 0x0A, 0xEC, 0x30, 0x00, 0x29, 0x00, 0x00, 0x02, 0xA3, 0x00, 0x00,
  // "ų" (U+0173)
  0x6F, 0x54, 0xD0, 0x0F, 0x27, 0xA0, 0x3E, 0x0B, 0x70, 0x6C, 0x2F, 0x50, 0x4E, 0x6C, 0xC1, 0x00,
  0x29, 0x00, 0x00, 0x2A, 0x30,
  // "Ŵ" (U+0174)
  0x48, 0x11, 0x71, 0x78, 0x19, 0x68, 0x38, 0xA1, 0x3F, 0xE4, 0x39, 0x0A, 0xE3, 0x0A, 0x90, 0x9B,
  0x05, 0x52, 0x85, 0x99, 0x1D, 0xD0, 0xA3, 0x85, 0x8A, 0x67, 0xF2, 0x83, 0x85, 0x7B, 0xA1, 0xF9,
  0x23, 0x84, 0x5E, 0x50, 0xFA, 0x40, 0x40, 0xE2, 0x0D, 0x05, 0x30,
  // "ŵ" (U+0175)
  0x38, 0x11, 0x71, 0x48, 0x19, 0x68, 0x71, 0x8B, 0x18, 0xF0, 0x8A, 0x3A, 0x1F, 0x0C, 0xB0, 0xA1,
  0xF4, 0x8B, 0x35, 0x1F, 0x84, 0xC8, 0x29, 0x82, 0x44, 0xE2, 0x10,
  // "Ŷ" (U+0176)
  0x28, 0x11, 0x71, 0x48, 0x19, 0x68, 0x28, 0x93, 0x3F, 0xE3, 0xAE, 0x30, 0xAA, 0x06, 0x42, 0x82,
  0x5D, 0x08, 0x38, 0x21, 0xF9, 0x14, 0x0D, 0x07, 0x48, 0x11, 0xF3, 0x48, 0x1D, 0xFB, 0x30,
  // "ŷ" (U+0177)
  0x38, 0x11, 0x71, 0x48, 0x19, 0x68, 0x73, 0x83, 0xDB, 0x0A, 0x42, 0x83, 0x4F, 0x06, 0x43, 0x90,
  0x30, 0x84, 0x81, 0xB9, 0x54, 0x07, 0x0B, 0x48, 0x11, 0xB2, 0x28, 0x23, 0xBB, 0x33,
  // "Ÿ" (U+0178)
  0x00, 0x74, 0xA1, 0x03, 0xFF, 0x4B, 0xE3, 0x0A, 0xA0, 0x64, 0x00, 0x5D, 0x08, 0x00, 0x01, 0xF9,
  0x10, 0x00, 0x0D, 0x70, 0x00, 0x01, 0xF3, 0x00, 0x00, 0xDF, 0xB0, 0x00,
  // "Ź" (U+0179)
  0x00, 0x02, 0x70, 0x00, 0x0A, 0x30, 0x0A, 0x99, 0xF7, 0x09, 0x09, 0xD0, 0x00, 0x4F, 0x30, 0x00,
  0xD8, 0x00, 0x09, 0xD0, 0x00, 0x4F, 0x30, 0x90, 0xDD, 0x8A, 0xA0,
  // "ź" (U+017A)
  0x00, 0x27, 0x00, 0x0A, 0x30, 0x00, 0x00, 0x04, 0xCB, 0xF1, 0x31, 0xC7, 0x00, 0x8C, 0x00, 0x3E,
  0x25, 0x0D, 0xD9, 0xB0,
  // "Ż" (U+017B)
  0x00, 0x0B, 0x40, 0x0A, 0x9A, 0xF7, 0x09, 0x09, 0xD0, 0x00, 0x4F, 0x30, 0x00, 0xD8, 0x00, 0x09,
  0xD0, 0x00, 0x4F, 0x30, 0x90, 0xDD, 0x8A, 0xA0,
  // "ż" (U+017C)
  0x00, 0xB4, 0x00, 0x01, 0x00, 0x4C, 0xBF, 0x13, 0x1C, 0x70, 0x08, 0xC0, 0x03, 0xE2, 0x50, 0xDD,
  0x9B, 0x00,
  // "Ž" (U+017D)
  0x00, 0x50, 0x50, 0x00, 0x7D, 0x30, 0x0A, 0x99, 0xF7, 0x09, 0x09, 0xD0, 0x00, 0x4F, 0x30, 0x00,
  0xD8, 0x00, 0x09, 0xD0, 0x00, 0x4F, 0x30, 0x90, 0xDD, 0x8A, 0xA0,
  // "ž" (U+017E)
  0x05, 0x05, 0x00, 0x7D, 0x30, 0x00, 0x00, 0x04, 0xCB, 0xF1, 0x31, 0xC7, 0x00, 0x8C, 0x00, 0x3E,
  0x25, 0x0D, 0xD9, 0xB0,
  // "ſ" (U+017F)
  0x28, 0x22, 0xCD, 0x42, 0x82, 0x8A, 0x42, 0x20, 0xC0, 0x74, 0x90, 0x43, 0x81, 0x3F, 0x13, 0x06,
  0x0D, 0x40, 0x90, 0xA4, 0x0D, 0x05, 0x30, 0xC0, 0x94,
  // "Ω" (U+03A9)
  0x01, 0xAB, 0xD7, 0x00, 0xB9, 0x03, 0xF2, 0x2F, 0x30, 0x1F, 0x32, 0xF2, 0x04, 0xE0, 0x0B, 0x82,
  0xC5, 0x06, 0x08, 0x71, 0x70, 0xEE, 0x8C, 0xFB, 0x00,
  // "μ" (U+03BC)
  0x0D, 0x54, 0xE0, 0x0F, 0x27, 0xB0, 0x3F, 0x0A, 0x80, 0x6D, 0x0E, 0x50, 0x9C, 0x9B, 0xB1, 0xB0,
  0x00, 0x00, 0xD3, 0x00, 0x00,
  // "π" (U+03C0)
  0x3C, 0xCC, 0xC2, 0x26, 0x27, 0x20, 0x0A, 0x0A, 0x00, 0x0B, 0x0C, 0x00, 0xB6, 0x0B, 0x70,
  // "–" (U+2013)
  0xBB, 0xBB,
  // "—" (U+2014)
  0x80, 0x4B,
  // "€" (U+20AC)
  0x00, 0x9D, 0x80, 0x79, 0x3C, 0x0D, 0x30, 0x17, 0xFB, 0x60, 0xAF, 0xB0, 0x04, 0xD0, 0x10, 0x0B,
  0xC8, 0x00,
  // "₿" (U+20BF)
  0x00, 0x05, 0x50, 0x02, 0xED, 0xD1, 0x00, 0xB5, 0xA6, 0x00, 0xD3, 0xC4, 0x01, 0xFD, 0xA0, 0x04,
  0xD0, 0xF1, 0x07, 0xA1, 0xF1, 0x3E, 0xDD, 0x70, 0x00, 0x55, 0x00,
  // "‘" (U+2018)
  0x34, 0xC0, 0xD1,
  // "’" (U+2019)
  0x0B, 0x40, 0x74, 0x16, 0x00,
  // "‚" (U+201A)
  0x86, 0x56, 0x60,
  // "‛" (U+201B)
  0xB5, 0xB0, 0x51,
  // "“" (U+201C)
  0x34, 0x52, 0xC4, 0x80, 0xD5, 0xB0,
  // "”" (U+201D)
  0x0B, 0x6D, 0x07, 0x4C, 0x16, 0x43,
  // "„" (U+201E)
  0x77, 0xC3, 0x47, 0x92, 0x73, 0x40,
  // "‟" (U+201F)
  0xB5, 0xB5, 0xB0, 0xB0, 0x51, 0x51,
  // "†" (U+2020)
  0x00, 0xB2, 0x01, 0x81, 0x3B, 0xCC, 0x05, 0xA0, 0x07, 0x60, 0x08, 0x10, 0x08, 0x00, 0x06, 0x00,
  // "‡" (U+2021)
  0x00, 0xA1, 0x01, 0x9B, 0x91, 0x14, 0xA3, 0x00, 0x37, 0x00, 0x05, 0x40, 0x02, 0x94, 0x10, 0xBC,
  0xA2, 0x00, 0xB0, 0x00,
  // "•" (U+2022)
  0x1D, 0xA5, 0xFE, 0x2C, 0x70,
  // "…" (U+2026)
  0x00, 0x01, 0x00, 0x07, 0x71, 0xD0, 0x95,
  // "‰" (U+2030)
  0x18, 0x37, 0xD3, 0x08, 0x58, 0x41, 0xB4, 0x86, 0x25, 0x83, 0x58, 0x58, 0x86, 0x8A, 0x46, 0x7A,
  0xB5, 0xB7, 0x1A, 0xA0, 0x1B, 0xA7, 0xC1, 0xC9, 0x4B, 0x12, 0x86, 0x91, 0xC2, 0xAC, 0x1C, 0x28,
  0x74, 0x50, 0xCB, 0x28, 0xC5, 0x10,
  // "‹" (U+2039)
  0x01, 0x31, 0xB1, 0x69, 0x00, 0xA0,
  // "›" (U+203A)
  0x04, 0x00, 0xC1, 0x0C, 0x27, 0x40,
  // "⁄" (U+2044)
  0x30, 0x50, 0x43, 0x09, 0x30, 0x70, 0x22, 0x01, 0x08, 0x30, 0x90, 0x12, 0x03, 0x06, 0x30, 0xA4,
  // "™" (U+2122)
  0x1E, 0xEC, 0x72, 0xD0, 0x44, 0x5B, 0x88, 0x09, 0xA8, 0x99, 0xD0,
  // "⅒" (U+2152)
  0x50, 0x50, 0x44, 0x04, 0x0A, 0x20, 0x95, 0x83, 0x2A, 0x07, 0x25, 0x8A, 0x14, 0x71, 0xDA, 0x03,
  0x63, 0x18, 0x79, 0x3A, 0x0B, 0x38, 0x28, 0x63, 0x64, 0x72, 0x97, 0x42, 0x85, 0xA1, 0x87, 0x07,
  0x51,
  // "ﬁ" (U+FB01)
  0x00, 0x0B, 0xCD, 0x10, 0x07, 0xA0, 0xA1, 0x03, 0xED, 0xCE, 0x00, 0x0E, 0x36, 0xC0, 0x02, 0xF0,
  0x99, 0x00, 0x5D, 0x0B, 0x60, 0x09, 0xA0, 0x9C, 0x10, 0xD5, 0x00, 0x00, 0xC9, 0x00, 0x00, 0x00,
  // "ﬂ" (U+FB02)
  0x00, 0x0B, 0xCC, 0x60, 0x07, 0xA0, 0xF3, 0x03, 0xED, 0x6F, 0x10, 0x0E, 0x35, 0xD0, 0x02, 0xF0,
  0x8A, 0x00, 0x5D, 0x0A, 0x80, 0x09, 0xA0, 0x8C, 0x20, 0xD5, 0x00, 0x00, 0xC9, 0x00, 0x00, 0x00,
};

const Font& font_NotoSerif_BoldItalic_8() {
  static SmoothFont font(font_NotoSerif_BoldItalic_8_data);
  return font;
}

}  // namespace roo_display
