#include "18.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSerif-BoldItalic (Noto Serif Bold Italic)
// Generated on Wed Nov 19 19:11:44 CET 2025
static const uint8_t font_NotoSerif_BoldItalic_18_data[] PROGMEM = {
  
  // Header
  0x01, 0x02, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x09, 0x13,
  0xFB, 0xFC, 0x16, 0x12, 0x0E, 0xFC, 0x05, 0x01, 0x17, 0x06, 0x06, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x01, 0x01, 0x06, 0x0D, 0x07, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x42, 0x09, 0x09, 0x0D, 0x09, 0x00, 0x25, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x0A, 0x0D, 0x0A, 0x00, 0x39, // "#" (U+0023)
  0x00, 0x24, 0x00, 0xFF, 0x09, 0x0E, 0x0A, 0x00, 0x72, // "$" (U+0024)
  0x00, 0x25, 0x41, 0x01, 0x0F, 0x0D, 0x10, 0x00, 0xB8, // "%" (U+0025)
  0x00, 0x26, 0x00, 0x01, 0x0E, 0x0D, 0x0E, 0x01, 0x1A, // "&" (U+0026)
  0x00, 0x27, 0x42, 0x09, 0x05, 0x0D, 0x05, 0x01, 0x70, // "'" (U+0027)
  0x00, 0x28, 0x00, 0xFE, 0x08, 0x0E, 0x07, 0x01, 0x7A, // "(" (U+0028)
  0x00, 0x29, 0xFF, 0xFE, 0x06, 0x0E, 0x07, 0x01, 0xAD, // ")" (U+0029)
  0x00, 0x2A, 0x02, 0x07, 0x0A, 0x0E, 0x0B, 0x01, 0xE0, // "*" (U+002A)
  0x00, 0x2B, 0x01, 0x04, 0x08, 0x0B, 0x0A, 0x02, 0x03, // "+" (U+002B)
  0x00, 0x2C, 0xBF, 0xFE, 0x03, 0x03, 0x05, 0x02, 0x1A, // "," (U+002C)
  0x00, 0x2D, 0x40, 0x05, 0x05, 0x06, 0x06, 0x02, 0x29, // "-" (U+002D)
  0x00, 0x2E, 0x40, 0x01, 0x03, 0x03, 0x05, 0x02, 0x2F, // "." (U+002E)
  0x00, 0x2F, 0xFE, 0xFF, 0x06, 0x0E, 0x05, 0x02, 0x35, // "/" (U+002F)
  0x00, 0x30, 0x00, 0x01, 0x0A, 0x0D, 0x0A, 0x02, 0x61, // "0" (U+0030)
  0x00, 0x31, 0x00, 0x01, 0x08, 0x0D, 0x0A, 0x02, 0xA7, // "1" (U+0031)
  0x00, 0x32, 0xFF, 0x01, 0x09, 0x0D, 0x0A, 0x02, 0xD3, // "2" (U+0032)
  0x00, 0x33, 0x00, 0x01, 0x09, 0x0D, 0x0A, 0x03, 0x0C, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x01, 0x09, 0x0D, 0x0A, 0x03, 0x48, // "4" (U+0034)
  0x00, 0x35, 0x00, 0x01, 0x0A, 0x0D, 0x0A, 0x03, 0x81, // "5" (U+0035)
  0x00, 0x36, 0x41, 0x01, 0x0A, 0x0D, 0x0A, 0x03, 0xBA, // "6" (U+0036)
  0x00, 0x37, 0x01, 0x01, 0x0A, 0x0D, 0x0A, 0x03, 0xFB, // "7" (U+0037)
  0x00, 0x38, 0x00, 0x01, 0x0A, 0x0D, 0x0A, 0x04, 0x28, // "8" (U+0038)
  0x00, 0x39, 0x00, 0x01, 0x09, 0x0D, 0x0A, 0x04, 0x6F, // "9" (U+0039)
  0x00, 0x3A, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x04, 0xAD, // ":" (U+003A)
  0x00, 0x3B, 0xFF, 0xFE, 0x05, 0x0A, 0x06, 0x04, 0xC2, // ";" (U+003B)
  0x00, 0x3C, 0x01, 0x03, 0x08, 0x0B, 0x0A, 0x04, 0xE0, // "<" (U+003C)
  0x00, 0x3D, 0x01, 0x04, 0x08, 0x09, 0x0A, 0x04, 0xFF, // "=" (U+003D)
  0x00, 0x3E, 0x01, 0x03, 0x08, 0x0B, 0x0A, 0x05, 0x0C, // ">" (U+003E)
  0x00, 0x3F, 0x01, 0x01, 0x09, 0x0D, 0x0A, 0x05, 0x2B, // "?" (U+003F)
  0x00, 0x40, 0x00, 0xFD, 0x0F, 0x0D, 0x11, 0x05, 0x5A, // "@" (U+0040)
  0x00, 0x41, 0xFF, 0x01, 0x0C, 0x0D, 0x0E, 0x05, 0xD6, // "A" (U+0041)
  0x00, 0x42, 0xFF, 0x01, 0x0B, 0x0D, 0x0C, 0x06, 0x1A, // "B" (U+0042)
  0x00, 0x43, 0x01, 0x01, 0x0C, 0x0D, 0x0C, 0x06, 0x63, // "C" (U+0043)
  0x00, 0x44, 0xFF, 0x01, 0x0D, 0x0D, 0x0E, 0x06, 0xA0, // "D" (U+0044)
  0x00, 0x45, 0xFF, 0x01, 0x0B, 0x0D, 0x0B, 0x06, 0xEF, // "E" (U+0045)
  0x00, 0x46, 0xFF, 0x01, 0x0C, 0x0D, 0x0B, 0x07, 0x2A, // "F" (U+0046)
  0x00, 0x47, 0x01, 0x01, 0x0D, 0x0D, 0x0E, 0x07, 0x61, // "G" (U+0047)
  0x00, 0x48, 0xFF, 0x01, 0x0F, 0x0D, 0x0F, 0x07, 0xAA, // "H" (U+0048)
  0x00, 0x49, 0xFF, 0x01, 0x08, 0x0D, 0x07, 0x07, 0xFD, // "I" (U+0049)
  0x00, 0x4A, 0xFD, 0xFD, 0x08, 0x0D, 0x07, 0x08, 0x27, // "J" (U+004A)
  0x00, 0x4B, 0xFF, 0x01, 0x0E, 0x0D, 0x0D, 0x08, 0x64, // "K" (U+004B)
  0x00, 0x4C, 0xFF, 0x01, 0x0A, 0x0D, 0x0C, 0x08, 0xB6, // "L" (U+004C)
  0x00, 0x4D, 0xFF, 0x01, 0x12, 0x0D, 0x11, 0x08, 0xE8, // "M" (U+004D)
  0x00, 0x4E, 0xFF, 0x01, 0x0F, 0x0D, 0x0E, 0x09, 0x56, // "N" (U+004E)
  0x00, 0x4F, 0x01, 0x01, 0x0D, 0x0D, 0x0E, 0x09, 0xAE, // "O" (U+004F)
  0x00, 0x50, 0xFF, 0x01, 0x0B, 0x0D, 0x0C, 0x09, 0xF9, // "P" (U+0050)
  0x00, 0x51, 0x01, 0xFD, 0x0D, 0x0D, 0x0E, 0x0A, 0x3A, // "Q" (U+0051)
  0x00, 0x52, 0xFF, 0x01, 0x0C, 0x0D, 0x0D, 0x0A, 0x94, // "R" (U+0052)
  0x00, 0x53, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x0A, 0xE1, // "S" (U+0053)
  0x00, 0x54, 0x01, 0x01, 0x0D, 0x0D, 0x0C, 0x0B, 0x20, // "T" (U+0054)
  0x00, 0x55, 0x01, 0x01, 0x0E, 0x0D, 0x0D, 0x0B, 0x56, // "U" (U+0055)
  0x00, 0x56, 0x01, 0x01, 0x0E, 0x0D, 0x0D, 0x0B, 0x9F, // "V" (U+0056)
  0x00, 0x57, 0x01, 0x01, 0x14, 0x0D, 0x13, 0x0B, 0xE2, // "W" (U+0057)
  0x00, 0x58, 0xFF, 0x01, 0x0E, 0x0D, 0x0D, 0x0C, 0x51, // "X" (U+0058)
  0x00, 0x59, 0x01, 0x01, 0x0E, 0x0D, 0x0C, 0x0C, 0x9E, // "Y" (U+0059)
  0x00, 0x5A, 0x00, 0x01, 0x0C, 0x0D, 0x0C, 0x0C, 0xDE, // "Z" (U+005A)
  0x00, 0x5B, 0x00, 0xFE, 0x08, 0x0E, 0x07, 0x0D, 0x1F, // "[" (U+005B)
  0x00, 0x5C, 0x42, 0xFF, 0x04, 0x0E, 0x05, 0x0D, 0x55, // "\" (U+005C)
  0x00, 0x5D, 0xFF, 0xFE, 0x07, 0x0E, 0x07, 0x0D, 0x6D, // "]" (U+005D)
  0x00, 0x5E, 0x01, 0x06, 0x08, 0x0E, 0x0A, 0x0D, 0xA0, // "^" (U+005E)
  0x00, 0x5F, 0xFE, 0xFE, 0x06, 0xFF, 0x08, 0x0D, 0xC1, // "_" (U+005F)
  0x00, 0x60, 0x42, 0x0C, 0x06, 0x0E, 0x06, 0x0D, 0xC8, // "`" (U+0060)
  0x00, 0x61, 0x40, 0x01, 0x0B, 0x0A, 0x0C, 0x0D, 0xD0, // "a" (U+0061)
  0x00, 0x62, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x0E, 0x0C, // "b" (U+0062)
  0x00, 0x63, 0x00, 0x01, 0x09, 0x0A, 0x0A, 0x0E, 0x52, // "c" (U+0063)
  0x00, 0x64, 0x00, 0x01, 0x0B, 0x0E, 0x0C, 0x0E, 0x80, // "d" (U+0064)
  0x00, 0x65, 0x40, 0x01, 0x09, 0x0A, 0x0A, 0x0E, 0xCC, // "e" (U+0065)
  0x00, 0x66, 0xFD, 0xFD, 0x0A, 0x0E, 0x07, 0x0E, 0xFE, // "f" (U+0066)
  0x00, 0x67, 0xFF, 0xFD, 0x0B, 0x0B, 0x0A, 0x0F, 0x46, // "g" (U+0067)
  0x00, 0x68, 0x00, 0x01, 0x0B, 0x0E, 0x0C, 0x0F, 0x96, // "h" (U+0068)
  0x00, 0x69, 0x41, 0x01, 0x05, 0x0E, 0x06, 0x0F, 0xDE, // "i" (U+0069)
  0x00, 0x6A, 0xFD, 0xFD, 0x05, 0x0E, 0x06, 0x10, 0x01, // "j" (U+006A)
  0x00, 0x6B, 0x00, 0x01, 0x0B, 0x0E, 0x0B, 0x10, 0x38, // "k" (U+006B)
  0x00, 0x6C, 0x41, 0x01, 0x05, 0x0E, 0x06, 0x10, 0x7F, // "l" (U+006C)
  0x00, 0x6D, 0x40, 0x01, 0x10, 0x0A, 0x11, 0x10, 0xA2, // "m" (U+006D)
  0x00, 0x6E, 0x40, 0x01, 0x0B, 0x0A, 0x0C, 0x10, 0xF7, // "n" (U+006E)
  0x00, 0x6F, 0x40, 0x01, 0x0A, 0x0A, 0x0B, 0x11, 0x33, // "o" (U+006F)
  0x00, 0x70, 0xFF, 0xFD, 0x0A, 0x0A, 0x0B, 0x11, 0x6A, // "p" (U+0070)
  0x00, 0x71, 0x00, 0xFD, 0x0A, 0x0A, 0x0B, 0x11, 0xB3, // "q" (U+0071)
  0x00, 0x72, 0x00, 0x01, 0x09, 0x0A, 0x0A, 0x11, 0xFA, // "r" (U+0072)
  0x00, 0x73, 0x40, 0x01, 0x08, 0x0A, 0x09, 0x12, 0x20, // "s" (U+0073)
  0x00, 0x74, 0x01, 0x01, 0x07, 0x0C, 0x08, 0x12, 0x4D, // "t" (U+0074)
  0x00, 0x75, 0x41, 0x01, 0x0B, 0x0A, 0x0C, 0x12, 0x73, // "u" (U+0075)
  0x00, 0x76, 0x00, 0x00, 0x09, 0x0A, 0x0B, 0x12, 0xAA, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x00, 0x0F, 0x0A, 0x10, 0x12, 0xDE, // "w" (U+0077)
  0x00, 0x78, 0xFF, 0x01, 0x0A, 0x0A, 0x0B, 0x13, 0x30, // "x" (U+0078)
  0x00, 0x79, 0xFD, 0xFD, 0x09, 0x0A, 0x0B, 0x13, 0x64, // "y" (U+0079)
  0x00, 0x7A, 0x00, 0x01, 0x09, 0x0A, 0x0A, 0x13, 0xA9, // "z" (U+007A)
  0x00, 0x7B, 0x00, 0xFE, 0x09, 0x0E, 0x08, 0x13, 0xD3, // "{" (U+007B)
  0x00, 0x7C, 0x44, 0xFD, 0x05, 0x0E, 0x0A, 0x14, 0x0A, // "|" (U+007C)
  0x00, 0x7D, 0xFF, 0xFE, 0x07, 0x0E, 0x08, 0x14, 0x1C, // "}" (U+007D)
  0x00, 0x7E, 0x40, 0x05, 0x09, 0x08, 0x0A, 0x14, 0x57, // "~" (U+007E)
  0x00, 0xA1, 0x00, 0xFE, 0x05, 0x0A, 0x07, 0x14, 0x6B, // "¡" (U+00A1)
  0x00, 0xA2, 0x01, 0x01, 0x0A, 0x0D, 0x0A, 0x14, 0x90, // "¢" (U+00A2)
  0x00, 0xA3, 0x00, 0x01, 0x0A, 0x0D, 0x0A, 0x14, 0xC8, // "£" (U+00A3)
  0x00, 0xA4, 0x41, 0x03, 0x08, 0x0B, 0x0A, 0x14, 0xFE, // "¤" (U+00A4)
  0x00, 0xA5, 0x00, 0x01, 0x0B, 0x0D, 0x0A, 0x15, 0x22, // "¥" (U+00A5)
  0x00, 0xA6, 0x44, 0xFD, 0x05, 0x0E, 0x0A, 0x15, 0x60, // "¦" (U+00A6)
  0x00, 0xA7, 0x00, 0xFE, 0x09, 0x0E, 0x0A, 0x15, 0x72, // "§" (U+00A7)
  0x00, 0xA8, 0x43, 0x0C, 0x09, 0x0E, 0x0A, 0x15, 0xC1, // "¨" (U+00A8)
  0x00, 0xA9, 0x01, 0x00, 0x0E, 0x0D, 0x0F, 0x15, 0xCC, // "©" (U+00A9)
  0x00, 0xAA, 0x41, 0x08, 0x08, 0x0D, 0x08, 0x16, 0x26, // "ª" (U+00AA)
  0x00, 0xAB, 0x41, 0x02, 0x09, 0x09, 0x0A, 0x16, 0x3E, // "«" (U+00AB)
  0x00, 0xAC, 0x01, 0x03, 0x08, 0x07, 0x0A, 0x16, 0x62, // "¬" (U+00AC)
  0x00, 0xAE, 0x41, 0x00, 0x0E, 0x0D, 0x0F, 0x16, 0x71, // "®" (U+00AE)
  0x00, 0xAF, 0x02, 0x0E, 0x0A, 0x0F, 0x08, 0x16, 0xD3, // "¯" (U+00AF)
  0x00, 0xB0, 0x42, 0x08, 0x07, 0x0D, 0x07, 0x16, 0xD8, // "°" (U+00B0)
  0x00, 0xB1, 0x01, 0x01, 0x08, 0x0B, 0x0A, 0x16, 0xEA, // "±" (U+00B1)
  0x00, 0xB2, 0x01, 0x07, 0x07, 0x0F, 0x07, 0x17, 0x06, // "²" (U+00B2)
  0x00, 0xB3, 0x41, 0x08, 0x07, 0x0F, 0x07, 0x17, 0x24, // "³" (U+00B3)
  0x00, 0xB4, 0x42, 0x0C, 0x06, 0x0E, 0x06, 0x17, 0x40, // "´" (U+00B4)
  0x00, 0xB5, 0x00, 0xFD, 0x0B, 0x0A, 0x0C, 0x17, 0x48, // "µ" (U+00B5)
  0x00, 0xB6, 0x01, 0xFE, 0x0A, 0x0E, 0x0B, 0x17, 0x91, // "¶" (U+00B6)
  0x00, 0xB7, 0x41, 0x06, 0x04, 0x08, 0x05, 0x17, 0xDB, // "·" (U+00B7)
  0x00, 0xB8, 0x40, 0xFC, 0x04, 0x01, 0x06, 0x17, 0xE1, // "¸" (U+00B8)
  0x00, 0xB9, 0x41, 0x08, 0x06, 0x10, 0x07, 0x17, 0xF0, // "¹" (U+00B9)
  0x00, 0xBA, 0x41, 0x08, 0x07, 0x0D, 0x07, 0x18, 0x0B, // "º" (U+00BA)
  0x00, 0xBB, 0x40, 0x02, 0x08, 0x09, 0x0A, 0x18, 0x20, // "»" (U+00BB)
  0x00, 0xBC, 0x01, 0x01, 0x0F, 0x0E, 0x10, 0x18, 0x44, // "¼" (U+00BC)
  0x00, 0xBD, 0x01, 0x00, 0x0F, 0x0E, 0x10, 0x18, 0xA2, // "½" (U+00BD)
  0x00, 0xBE, 0x01, 0x01, 0x0F, 0x0D, 0x10, 0x18, 0xFF, // "¾" (U+00BE)
  0x00, 0xBF, 0x00, 0xFD, 0x07, 0x0A, 0x0A, 0x19, 0x5D, // "¿" (U+00BF)
  0x00, 0xC0, 0xFF, 0x01, 0x0C, 0x11, 0x0E, 0x19, 0x8E, // "À" (U+00C0)
  0x00, 0xC1, 0xFF, 0x01, 0x0C, 0x11, 0x0E, 0x19, 0xDD, // "Á" (U+00C1)
  0x00, 0xC2, 0xFF, 0x01, 0x0C, 0x11, 0x0E, 0x1A, 0x2C, // "Â" (U+00C2)
  0x00, 0xC3, 0xFF, 0x01, 0x0C, 0x11, 0x0E, 0x1A, 0x7E, // "Ã" (U+00C3)
  0x00, 0xC4, 0xFF, 0x01, 0x0C, 0x11, 0x0E, 0x1A, 0xD0, // "Ä" (U+00C4)
  0x00, 0xC5, 0xFF, 0x01, 0x0C, 0x10, 0x0E, 0x1B, 0x24, // "Å" (U+00C5)
  0x00, 0xC6, 0xFF, 0x01, 0x12, 0x0D, 0x12, 0x1B, 0x75, // "Æ" (U+00C6)
  0x00, 0xC7, 0x01, 0xFC, 0x0C, 0x0D, 0x0C, 0x1B, 0xCF, // "Ç" (U+00C7)
  0x00, 0xC8, 0xFF, 0x01, 0x0B, 0x11, 0x0B, 0x1C, 0x1E, // "È" (U+00C8)
  0x00, 0xC9, 0xFF, 0x01, 0x0B, 0x11, 0x0B, 0x1C, 0x64, // "É" (U+00C9)
  0x00, 0xCA, 0xFF, 0x01, 0x0B, 0x11, 0x0B, 0x1C, 0xAA, // "Ê" (U+00CA)
  0x00, 0xCB, 0xFF, 0x01, 0x0B, 0x11, 0x0B, 0x1C, 0xF3, // "Ë" (U+00CB)
  0x00, 0xCC, 0xFF, 0x01, 0x08, 0x11, 0x07, 0x1D, 0x3E, // "Ì" (U+00CC)
  0x00, 0xCD, 0xFF, 0x01, 0x08, 0x11, 0x07, 0x1D, 0x73, // "Í" (U+00CD)
  0x00, 0xCE, 0xFF, 0x01, 0x08, 0x11, 0x07, 0x1D, 0xA7, // "Î" (U+00CE)
  0x00, 0xCF, 0xFF, 0x01, 0x08, 0x11, 0x07, 0x1D, 0xDE, // "Ï" (U+00CF)
  0x00, 0xD0, 0xFF, 0x01, 0x0D, 0x0D, 0x0E, 0x1E, 0x18, // "Ð" (U+00D0)
  0x00, 0xD1, 0xFF, 0x01, 0x0F, 0x11, 0x0E, 0x1E, 0x69, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x01, 0x01, 0x0D, 0x11, 0x0E, 0x1E, 0xD2, // "Ò" (U+00D2)
  0x00, 0xD3, 0x01, 0x01, 0x0D, 0x11, 0x0E, 0x1F, 0x28, // "Ó" (U+00D3)
  0x00, 0xD4, 0x01, 0x01, 0x0D, 0x11, 0x0E, 0x1F, 0x7E, // "Ô" (U+00D4)
  0x00, 0xD5, 0x01, 0x01, 0x0D, 0x11, 0x0E, 0x1F, 0xD6, // "Õ" (U+00D5)
  0x00, 0xD6, 0x01, 0x01, 0x0D, 0x11, 0x0E, 0x20, 0x2F, // "Ö" (U+00D6)
  0x00, 0xD7, 0x41, 0x04, 0x08, 0x0A, 0x0A, 0x20, 0x8A, // "×" (U+00D7)
  0x00, 0xD8, 0x01, 0x00, 0x0D, 0x0E, 0x0E, 0x20, 0xA6, // "Ø" (U+00D8)
  0x00, 0xD9, 0x01, 0x01, 0x0E, 0x11, 0x0D, 0x21, 0x05, // "Ù" (U+00D9)
  0x00, 0xDA, 0x01, 0x01, 0x0E, 0x11, 0x0D, 0x21, 0x59, // "Ú" (U+00DA)
  0x00, 0xDB, 0x01, 0x01, 0x0E, 0x11, 0x0D, 0x21, 0xAD, // "Û" (U+00DB)
  0x00, 0xDC, 0x01, 0x01, 0x0E, 0x11, 0x0D, 0x22, 0x04, // "Ü" (U+00DC)
  0x00, 0xDD, 0x01, 0x01, 0x0E, 0x11, 0x0C, 0x22, 0x5D, // "Ý" (U+00DD)
  0x00, 0xDE, 0xFF, 0x01, 0x0B, 0x0D, 0x0B, 0x22, 0xA9, // "Þ" (U+00DE)
  0x00, 0xDF, 0xFD, 0xFD, 0x0B, 0x0E, 0x0D, 0x22, 0xEB, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x01, 0x0B, 0x0E, 0x0C, 0x23, 0x56, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x0B, 0x0E, 0x0C, 0x23, 0xA0, // "á" (U+00E1)
  0x00, 0xE2, 0x00, 0x01, 0x0B, 0x0E, 0x0C, 0x23, 0xE9, // "â" (U+00E2)
  0x00, 0xE3, 0x00, 0x01, 0x0B, 0x0E, 0x0C, 0x24, 0x34, // "ã" (U+00E3)
  0x00, 0xE4, 0x00, 0x01, 0x0B, 0x0E, 0x0C, 0x24, 0x81, // "ä" (U+00E4)
  0x00, 0xE5, 0x00, 0x01, 0x0B, 0x0F, 0x0C, 0x24, 0xCF, // "å" (U+00E5)
  0x00, 0xE6, 0x40, 0x01, 0x0F, 0x0A, 0x10, 0x25, 0x1F, // "æ" (U+00E6)
  0x00, 0xE7, 0x00, 0xFC, 0x09, 0x0A, 0x0A, 0x25, 0x6F, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x01, 0x09, 0x0E, 0x0A, 0x25, 0xAD, // "è" (U+00E8)
  0x00, 0xE9, 0x00, 0x01, 0x09, 0x0E, 0x0A, 0x25, 0xEA, // "é" (U+00E9)
  0x00, 0xEA, 0x00, 0x01, 0x09, 0x0E, 0x0A, 0x26, 0x26, // "ê" (U+00EA)
  0x00, 0xEB, 0x00, 0x01, 0x09, 0x0E, 0x0A, 0x26, 0x65, // "ë" (U+00EB)
  0x00, 0xEC, 0x00, 0x01, 0x05, 0x0E, 0x06, 0x26, 0xA7, // "ì" (U+00EC)
  0x00, 0xED, 0x01, 0x01, 0x07, 0x0E, 0x06, 0x26, 0xCE, // "í" (U+00ED)
  0x00, 0xEE, 0x01, 0x01, 0x07, 0x0E, 0x06, 0x26, 0xF7, // "î" (U+00EE)
  0x00, 0xEF, 0x01, 0x01, 0x07, 0x0E, 0x06, 0x27, 0x22, // "ï" (U+00EF)
  0x00, 0xF0, 0x00, 0x01, 0x0A, 0x0F, 0x0B, 0x27, 0x4E, // "ð" (U+00F0)
  0x00, 0xF1, 0x00, 0x01, 0x0B, 0x0E, 0x0C, 0x27, 0x9B, // "ñ" (U+00F1)
  0x00, 0xF2, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x27, 0xE5, // "ò" (U+00F2)
  0x00, 0xF3, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x28, 0x28, // "ó" (U+00F3)
  0x00, 0xF4, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x28, 0x69, // "ô" (U+00F4)
  0x00, 0xF5, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x28, 0xAD, // "õ" (U+00F5)
  0x00, 0xF6, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x28, 0xF3, // "ö" (U+00F6)
  0x00, 0xF7, 0x01, 0x03, 0x08, 0x0B, 0x0A, 0x29, 0x3A, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x00, 0x0A, 0x0B, 0x0B, 0x29, 0x4C, // "ø" (U+00F8)
  0x00, 0xF9, 0x01, 0x01, 0x0B, 0x0E, 0x0C, 0x29, 0x8D, // "ù" (U+00F9)
  0x00, 0xFA, 0x01, 0x01, 0x0B, 0x0E, 0x0C, 0x29, 0xD4, // "ú" (U+00FA)
  0x00, 0xFB, 0x01, 0x01, 0x0B, 0x0E, 0x0C, 0x2A, 0x19, // "û" (U+00FB)
  0x00, 0xFC, 0x01, 0x01, 0x0B, 0x0E, 0x0C, 0x2A, 0x61, // "ü" (U+00FC)
  0x00, 0xFD, 0xFD, 0xFD, 0x09, 0x0E, 0x0B, 0x2A, 0xAC, // "ý" (U+00FD)
  0x00, 0xFE, 0xFF, 0xFD, 0x0A, 0x0E, 0x0B, 0x2A, 0xFC, // "þ" (U+00FE)
  0x00, 0xFF, 0xFD, 0xFD, 0x09, 0x0E, 0x0B, 0x2B, 0x52, // "ÿ" (U+00FF)
  0x01, 0x00, 0xFF, 0x01, 0x0C, 0x0F, 0x0E, 0x2B, 0xA7, // "Ā" (U+0100)
  0x01, 0x01, 0x00, 0x01, 0x0B, 0x0C, 0x0C, 0x2B, 0xF1, // "ā" (U+0101)
  0x01, 0x02, 0xFF, 0x01, 0x0C, 0x12, 0x0E, 0x2C, 0x35, // "Ă" (U+0102)
  0x01, 0x03, 0x00, 0x01, 0x0B, 0x0F, 0x0C, 0x2C, 0x8B, // "ă" (U+0103)
  0x01, 0x04, 0xFF, 0xFC, 0x0C, 0x0D, 0x0E, 0x2C, 0xDB, // "Ą" (U+0104)
  0x01, 0x05, 0x00, 0xFC, 0x0B, 0x0A, 0x0C, 0x2D, 0x31, // "ą" (U+0105)
  0x01, 0x06, 0x01, 0x01, 0x0C, 0x11, 0x0C, 0x2D, 0x81, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x01, 0x0A, 0x0E, 0x0A, 0x2D, 0xCA, // "ć" (U+0107)
  0x01, 0x08, 0x01, 0x01, 0x0C, 0x11, 0x0C, 0x2E, 0x03, // "Ĉ" (U+0108)
  0x01, 0x09, 0x00, 0x01, 0x0A, 0x0E, 0x0A, 0x2E, 0x4D, // "ĉ" (U+0109)
  0x01, 0x0A, 0x01, 0x01, 0x0C, 0x11, 0x0C, 0x2E, 0x89, // "Ċ" (U+010A)
  0x01, 0x0B, 0x00, 0x01, 0x09, 0x0E, 0x0A, 0x2E, 0xD2, // "ċ" (U+010B)
  0x01, 0x0C, 0x01, 0x01, 0x0C, 0x11, 0x0C, 0x2F, 0x0B, // "Č" (U+010C)
  0x01, 0x0D, 0x00, 0x01, 0x09, 0x0E, 0x0A, 0x2F, 0x55, // "č" (U+010D)
  0x01, 0x0E, 0xFF, 0x01, 0x0D, 0x11, 0x0E, 0x2F, 0x90, // "Ď" (U+010E)
  0x01, 0x0F, 0x00, 0x01, 0x0F, 0x0E, 0x0C, 0x2F, 0xED, // "ď" (U+010F)
  0x01, 0x10, 0xFF, 0x01, 0x0D, 0x0D, 0x0E, 0x30, 0x41, // "Đ" (U+0110)
  0x01, 0x11, 0x00, 0x01, 0x0C, 0x0E, 0x0C, 0x30, 0x92, // "đ" (U+0111)
  0x01, 0x12, 0xFF, 0x01, 0x0B, 0x0F, 0x0B, 0x30, 0xE2, // "Ē" (U+0112)
  0x01, 0x13, 0x00, 0x01, 0x09, 0x0C, 0x0A, 0x31, 0x22, // "ē" (U+0113)
  0x01, 0x14, 0xFF, 0x01, 0x0B, 0x12, 0x0B, 0x31, 0x5A, // "Ĕ" (U+0114)
  0x01, 0x15, 0x00, 0x01, 0x09, 0x0F, 0x0A, 0x31, 0xA7, // "ĕ" (U+0115)
  0x01, 0x16, 0xFF, 0x01, 0x0B, 0x11, 0x0B, 0x31, 0xEA, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x01, 0x09, 0x0E, 0x0A, 0x32, 0x31, // "ė" (U+0117)
  0x01, 0x18, 0xFF, 0xFC, 0x0B, 0x0D, 0x0B, 0x32, 0x6E, // "Ę" (U+0118)
  0x01, 0x19, 0x00, 0xFC, 0x09, 0x0A, 0x0A, 0x32, 0xBB, // "ę" (U+0119)
  0x01, 0x1A, 0xFF, 0x01, 0x0B, 0x11, 0x0B, 0x32, 0xFC, // "Ě" (U+011A)
  0x01, 0x1B, 0x00, 0x01, 0x09, 0x0E, 0x0A, 0x33, 0x44, // "ě" (U+011B)
  0x01, 0x1C, 0x01, 0x01, 0x0D, 0x11, 0x0E, 0x33, 0x83, // "Ĝ" (U+011C)
  0x01, 0x1D, 0xFF, 0xFD, 0x0B, 0x0E, 0x0A, 0x33, 0xD9, // "ĝ" (U+011D)
  0x01, 0x1E, 0x01, 0x01, 0x0D, 0x12, 0x0E, 0x34, 0x36, // "Ğ" (U+011E)
  0x01, 0x1F, 0xFF, 0xFD, 0x0B, 0x0F, 0x0A, 0x34, 0x91, // "ğ" (U+011F)
  0x01, 0x20, 0x01, 0x01, 0x0D, 0x11, 0x0E, 0x34, 0xF2, // "Ġ" (U+0120)
  0x01, 0x21, 0xFF, 0xFD, 0x0B, 0x0E, 0x0A, 0x35, 0x47, // "ġ" (U+0121)
  0x01, 0x22, 0x01, 0xFD, 0x0D, 0x0D, 0x0E, 0x35, 0xA2, // "Ģ" (U+0122)
  0x01, 0x23, 0xFF, 0xFD, 0x0B, 0x0E, 0x0A, 0x35, 0xF6, // "ģ" (U+0123)
  0x01, 0x24, 0xFF, 0x01, 0x0F, 0x11, 0x0F, 0x36, 0x50, // "Ĥ" (U+0124)
  0x01, 0x25, 0x00, 0x01, 0x0B, 0x11, 0x0C, 0x36, 0xB2, // "ĥ" (U+0125)
  0x01, 0x26, 0xFF, 0x01, 0x0F, 0x0D, 0x0F, 0x37, 0x06, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x0B, 0x0E, 0x0C, 0x37, 0x57, // "ħ" (U+0127)
  0x01, 0x28, 0xFF, 0x01, 0x08, 0x11, 0x07, 0x37, 0xA2, // "Ĩ" (U+0128)
  0x01, 0x29, 0x00, 0x01, 0x06, 0x0E, 0x06, 0x37, 0xDA, // "ĩ" (U+0129)
  0x01, 0x2A, 0xFF, 0x01, 0x08, 0x0F, 0x07, 0x38, 0x06, // "Ī" (U+012A)
  0x01, 0x2B, 0x01, 0x01, 0x06, 0x0C, 0x06, 0x38, 0x36, // "ī" (U+012B)
  0x01, 0x2C, 0xFF, 0x01, 0x08, 0x12, 0x07, 0x38, 0x59, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x01, 0x01, 0x07, 0x0F, 0x06, 0x38, 0x94, // "ĭ" (U+012D)
  0x01, 0x2E, 0xFF, 0xFC, 0x08, 0x0D, 0x07, 0x38, 0xC2, // "Į" (U+012E)
  0x01, 0x2F, 0x00, 0xFC, 0x05, 0x0E, 0x06, 0x38, 0xFC, // "į" (U+012F)
  0x01, 0x30, 0xFF, 0x01, 0x08, 0x11, 0x07, 0x39, 0x32, // "İ" (U+0130)
  0x01, 0x31, 0x41, 0x01, 0x05, 0x0A, 0x06, 0x39, 0x67, // "ı" (U+0131)
  0x01, 0x32, 0xFF, 0xFD, 0x0F, 0x0D, 0x0E, 0x39, 0x80, // "Ĳ" (U+0132)
  0x01, 0x33, 0x01, 0xFD, 0x0B, 0x0E, 0x0C, 0x39, 0xE0, // "ĳ" (U+0133)
  0x01, 0x34, 0xFD, 0xFD, 0x08, 0x11, 0x07, 0x3A, 0x3A, // "Ĵ" (U+0134)
  0x01, 0x35, 0xFD, 0xFD, 0x06, 0x0E, 0x06, 0x3A, 0x84, // "ĵ" (U+0135)
  0x01, 0x36, 0xFF, 0xFD, 0x0E, 0x0D, 0x0D, 0x3A, 0xBE, // "Ķ" (U+0136)
  0x01, 0x37, 0x00, 0xFD, 0x0B, 0x0E, 0x0B, 0x3B, 0x1C, // "ķ" (U+0137)
  0x01, 0x38, 0x00, 0x01, 0x0B, 0x0A, 0x0B, 0x3B, 0x6E, // "ĸ" (U+0138)
  0x01, 0x39, 0xFF, 0x01, 0x0A, 0x11, 0x0C, 0x3B, 0xA7, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x01, 0x01, 0x08, 0x11, 0x06, 0x3B, 0xE4, // "ĺ" (U+013A)
  0x01, 0x3B, 0xFF, 0xFD, 0x0A, 0x0D, 0x0C, 0x3C, 0x17, // "Ļ" (U+013B)
  0x01, 0x3C, 0xFF, 0xFD, 0x05, 0x0E, 0x06, 0x3C, 0x55, // "ļ" (U+013C)
  0x01, 0x3D, 0xFF, 0x01, 0x0B, 0x0D, 0x0C, 0x3C, 0x89, // "Ľ" (U+013D)
  0x01, 0x3E, 0x01, 0x01, 0x09, 0x0E, 0x06, 0x3C, 0xC2, // "ľ" (U+013E)
  0x01, 0x3F, 0xFF, 0x01, 0x0B, 0x0D, 0x0C, 0x3C, 0xF2, // "Ŀ" (U+013F)
  0x01, 0x40, 0x01, 0x01, 0x08, 0x0E, 0x08, 0x3D, 0x2E, // "ŀ" (U+0140)
  0x01, 0x41, 0xFF, 0x01, 0x0A, 0x0D, 0x0C, 0x3D, 0x5D, // "Ł" (U+0141)
  0x01, 0x42, 0x00, 0x01, 0x06, 0x0E, 0x06, 0x3D, 0x93, // "ł" (U+0142)
  0x01, 0x43, 0xFF, 0x01, 0x0F, 0x11, 0x0E, 0x3D, 0xC2, // "Ń" (U+0143)
  0x01, 0x44, 0x00, 0x01, 0x0B, 0x0E, 0x0C, 0x3E, 0x26, // "ń" (U+0144)
  0x01, 0x45, 0xFF, 0xFD, 0x0F, 0x0D, 0x0E, 0x3E, 0x6D, // "Ņ" (U+0145)
  0x01, 0x46, 0x00, 0xFD, 0x0B, 0x0A, 0x0C, 0x3E, 0xD1, // "ņ" (U+0146)
  0x01, 0x47, 0xFF, 0x01, 0x0F, 0x11, 0x0E, 0x3F, 0x18, // "Ň" (U+0147)
  0x01, 0x48, 0x00, 0x01, 0x0B, 0x0E, 0x0C, 0x3F, 0x7F, // "ň" (U+0148)
  0x01, 0x49, 0x00, 0x01, 0x0F, 0x0D, 0x10, 0x3F, 0xC8, // "ŉ" (U+0149)
  0x01, 0x4A, 0xFF, 0xFD, 0x0F, 0x0D, 0x0E, 0x40, 0x16, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x00, 0xFD, 0x0A, 0x0A, 0x0C, 0x40, 0x80, // "ŋ" (U+014B)
  0x01, 0x4C, 0x01, 0x01, 0x0D, 0x0F, 0x0E, 0x40, 0xC9, // "Ō" (U+014C)
  0x01, 0x4D, 0x00, 0x01, 0x0A, 0x0C, 0x0B, 0x41, 0x19, // "ō" (U+014D)
  0x01, 0x4E, 0x01, 0x01, 0x0D, 0x12, 0x0E, 0x41, 0x56, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x00, 0x01, 0x0A, 0x0F, 0x0B, 0x41, 0xB3, // "ŏ" (U+014F)
  0x01, 0x50, 0x01, 0x01, 0x0D, 0x11, 0x0E, 0x41, 0xFB, // "Ő" (U+0150)
  0x01, 0x51, 0x00, 0x01, 0x0B, 0x0E, 0x0B, 0x42, 0x55, // "ő" (U+0151)
  0x01, 0x52, 0x01, 0x01, 0x12, 0x0D, 0x12, 0x42, 0x9D, // "Œ" (U+0152)
  0x01, 0x53, 0x00, 0x01, 0x10, 0x0A, 0x10, 0x42, 0xFA, // "œ" (U+0153)
  0x01, 0x54, 0xFF, 0x01, 0x0C, 0x11, 0x0D, 0x43, 0x4E, // "Ŕ" (U+0154)
  0x01, 0x55, 0x00, 0x01, 0x09, 0x0E, 0x0A, 0x43, 0xA7, // "ŕ" (U+0155)
  0x01, 0x56, 0xFF, 0xFD, 0x0C, 0x0D, 0x0D, 0x43, 0xD7, // "Ŗ" (U+0156)
  0x01, 0x57, 0xFF, 0xFD, 0x09, 0x0A, 0x0A, 0x44, 0x2F, // "ŗ" (U+0157)
  0x01, 0x58, 0xFF, 0x01, 0x0C, 0x11, 0x0D, 0x44, 0x61, // "Ř" (U+0158)
  0x01, 0x59, 0x00, 0x01, 0x09, 0x0E, 0x0A, 0x44, 0xBC, // "ř" (U+0159)
  0x01, 0x5A, 0x00, 0x01, 0x0A, 0x11, 0x0B, 0x44, 0xEF, // "Ś" (U+015A)
  0x01, 0x5B, 0x00, 0x01, 0x09, 0x0E, 0x09, 0x45, 0x38, // "ś" (U+015B)
  0x01, 0x5C, 0x00, 0x01, 0x0A, 0x11, 0x0B, 0x45, 0x74, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x45, 0xBF, // "ŝ" (U+015D)
  0x01, 0x5E, 0x00, 0xFC, 0x0A, 0x0D, 0x0B, 0x45, 0xFC, // "Ş" (U+015E)
  0x01, 0x5F, 0x00, 0xFC, 0x08, 0x0A, 0x09, 0x46, 0x4B, // "ş" (U+015F)
  0x01, 0x60, 0x00, 0x01, 0x0A, 0x11, 0x0B, 0x46, 0x8C, // "Š" (U+0160)
  0x01, 0x61, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x46, 0xD8, // "š" (U+0161)
  0x01, 0x62, 0x01, 0xFC, 0x0D, 0x0D, 0x0C, 0x47, 0x15, // "Ţ" (U+0162)
  0x01, 0x63, 0x00, 0xFC, 0x07, 0x0C, 0x08, 0x47, 0x5E, // "ţ" (U+0163)
  0x01, 0x64, 0x01, 0x01, 0x0D, 0x11, 0x0C, 0x47, 0x95, // "Ť" (U+0164)
  0x01, 0x65, 0x01, 0x01, 0x09, 0x0E, 0x08, 0x47, 0xD9, // "ť" (U+0165)
  0x01, 0x66, 0x01, 0x01, 0x0D, 0x0D, 0x0C, 0x48, 0x09, // "Ŧ" (U+0166)
  0x01, 0x67, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x48, 0x42, // "ŧ" (U+0167)
  0x01, 0x68, 0x01, 0x01, 0x0E, 0x11, 0x0D, 0x48, 0x6C, // "Ũ" (U+0168)
  0x01, 0x69, 0x01, 0x01, 0x0B, 0x0E, 0x0C, 0x48, 0xC3, // "ũ" (U+0169)
  0x01, 0x6A, 0x01, 0x01, 0x0E, 0x0F, 0x0D, 0x49, 0x0D, // "Ū" (U+016A)
  0x01, 0x6B, 0x01, 0x01, 0x0B, 0x0C, 0x0C, 0x49, 0x5C, // "ū" (U+016B)
  0x01, 0x6C, 0x01, 0x01, 0x0E, 0x12, 0x0D, 0x49, 0x9D, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x01, 0x01, 0x0B, 0x0F, 0x0C, 0x49, 0xF8, // "ŭ" (U+016D)
  0x01, 0x6E, 0x01, 0x01, 0x0E, 0x12, 0x0D, 0x4A, 0x45, // "Ů" (U+016E)
  0x01, 0x6F, 0x01, 0x01, 0x0B, 0x0F, 0x0C, 0x4A, 0xA1, // "ů" (U+016F)
  0x01, 0x70, 0x01, 0x01, 0x0E, 0x11, 0x0D, 0x4A, 0xEE, // "Ű" (U+0170)
  0x01, 0x71, 0x01, 0x01, 0x0C, 0x0E, 0x0C, 0x4B, 0x46, // "ű" (U+0171)
  0x01, 0x72, 0x01, 0xFC, 0x0E, 0x0D, 0x0D, 0x4B, 0x92, // "Ų" (U+0172)
  0x01, 0x73, 0x01, 0xFC, 0x0B, 0x0A, 0x0C, 0x4B, 0xED, // "ų" (U+0173)
  0x01, 0x74, 0x01, 0x01, 0x14, 0x11, 0x13, 0x4C, 0x39, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x00, 0x0F, 0x0E, 0x10, 0x4C, 0xB8, // "ŵ" (U+0175)
  0x01, 0x76, 0x01, 0x01, 0x0E, 0x11, 0x0C, 0x4D, 0x19, // "Ŷ" (U+0176)
  0x01, 0x77, 0xFD, 0xFD, 0x09, 0x0E, 0x0B, 0x4D, 0x68, // "ŷ" (U+0177)
  0x01, 0x78, 0x01, 0x01, 0x0E, 0x11, 0x0C, 0x4D, 0xBB, // "Ÿ" (U+0178)
  0x01, 0x79, 0x00, 0x01, 0x0C, 0x11, 0x0C, 0x4E, 0x0C, // "Ź" (U+0179)
  0x01, 0x7A, 0x00, 0x01, 0x09, 0x0E, 0x0A, 0x4E, 0x59, // "ź" (U+017A)
  0x01, 0x7B, 0x00, 0x01, 0x0C, 0x11, 0x0C, 0x4E, 0x8D, // "Ż" (U+017B)
  0x01, 0x7C, 0x00, 0x01, 0x09, 0x0E, 0x0A, 0x4E, 0xDA, // "ż" (U+017C)
  0x01, 0x7D, 0x00, 0x01, 0x0C, 0x11, 0x0C, 0x4F, 0x0F, // "Ž" (U+017D)
  0x01, 0x7E, 0x00, 0x01, 0x09, 0x0E, 0x0A, 0x4F, 0x5E, // "ž" (U+017E)
  0x01, 0x7F, 0xFD, 0xFD, 0x0A, 0x0E, 0x07, 0x4F, 0x95, // "ſ" (U+017F)
  0x03, 0xA9, 0x00, 0x01, 0x0E, 0x0D, 0x0F, 0x4F, 0xDB, // "Ω" (U+03A9)
  0x03, 0xBC, 0x00, 0xFD, 0x0B, 0x0A, 0x0C, 0x50, 0x33, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x01, 0x0B, 0x0A, 0x0C, 0x50, 0x7C, // "π" (U+03C0)
  0x20, 0x13, 0xFF, 0x05, 0x09, 0x06, 0x09, 0x50, 0xB3, // "–" (U+2013)
  0x20, 0x14, 0xFF, 0x05, 0x12, 0x06, 0x12, 0x50, 0xB9, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x01, 0x0A, 0x0D, 0x0A, 0x50, 0xC0, // "€" (U+20AC)
  0x20, 0xBF, 0xFF, 0xFF, 0x09, 0x0F, 0x0A, 0x50, 0xFA, // "₿" (U+20BF)
  0x20, 0x18, 0x42, 0x09, 0x05, 0x0E, 0x05, 0x51, 0x4A, // "‘" (U+2018)
  0x20, 0x19, 0x41, 0x08, 0x05, 0x0D, 0x05, 0x51, 0x56, // "’" (U+2019)
  0x20, 0x1A, 0xBF, 0xFE, 0x03, 0x03, 0x05, 0x51, 0x65, // "‚" (U+201A)
  0x20, 0x1B, 0x42, 0x08, 0x05, 0x0D, 0x05, 0x51, 0x74, // "‛" (U+201B)
  0x20, 0x1C, 0x42, 0x09, 0x09, 0x0E, 0x09, 0x51, 0x80, // "“" (U+201C)
  0x20, 0x1D, 0x41, 0x08, 0x09, 0x0D, 0x09, 0x51, 0x98, // "”" (U+201D)
  0x20, 0x1E, 0xBF, 0xFE, 0x07, 0x03, 0x09, 0x51, 0xB3, // "„" (U+201E)
  0x20, 0x1F, 0x42, 0x08, 0x09, 0x0D, 0x09, 0x51, 0xCE, // "‟" (U+201F)
  0x20, 0x20, 0x01, 0xFF, 0x09, 0x0E, 0x09, 0x51, 0xE6, // "†" (U+2020)
  0x20, 0x21, 0xFF, 0xFF, 0x09, 0x0E, 0x09, 0x52, 0x16, // "‡" (U+2021)
  0x20, 0x22, 0x01, 0x05, 0x06, 0x0A, 0x07, 0x52, 0x4E, // "•" (U+2022)
  0x20, 0x26, 0x40, 0x01, 0x0E, 0x03, 0x10, 0x52, 0x5F, // "…" (U+2026)
  0x20, 0x30, 0x01, 0x01, 0x16, 0x0D, 0x17, 0x52, 0x76, // "‰" (U+2030)
  0x20, 0x39, 0x41, 0x02, 0x05, 0x09, 0x06, 0x52, 0xFB, // "‹" (U+2039)
  0x20, 0x3A, 0x00, 0x02, 0x05, 0x09, 0x06, 0x53, 0x0F, // "›" (U+203A)
  0x20, 0x44, 0xFB, 0x01, 0x05, 0x0D, 0x01, 0x53, 0x26, // "⁄" (U+2044)
  0x21, 0x22, 0x42, 0x07, 0x0F, 0x0D, 0x0F, 0x53, 0x51, // "™" (U+2122)
  0x21, 0x52, 0x01, 0x01, 0x15, 0x0E, 0x16, 0x53, 0x82, // "⅒" (U+2152)
  0xFB, 0x01, 0xFD, 0xFD, 0x0B, 0x0E, 0x0C, 0x53, 0xFE, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0xFD, 0xFD, 0x0C, 0x0E, 0x0D, 0x54, 0x61, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x01, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0x67, 0x01, // "g (U+0022 U+0067)
  0x00, 0x22, 0x00, 0xC0, 0x01, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x01, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x01, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x01, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x01, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x01, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xC6, 0x02, // "Æ (U+0022 U+00C6)
  0x00, 0x22, 0x01, 0x00, 0x01, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x02, 0x01, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x04, 0x01, // "Ą (U+0022 U+0104)
  0x00, 0x26, 0x00, 0x54, 0x01, // &T (U+0026 U+0054)
  0x00, 0x26, 0x00, 0x56, 0x01, // &V (U+0026 U+0056)
  0x00, 0x26, 0x00, 0x57, 0x01, // &W (U+0026 U+0057)
  0x00, 0x26, 0x00, 0x59, 0x01, // &Y (U+0026 U+0059)
  0x00, 0x26, 0x00, 0xDD, 0x01, // &Ý (U+0026 U+00DD)
  0x00, 0x26, 0x01, 0x74, 0x01, // &Ŵ (U+0026 U+0174)
  0x00, 0x26, 0x01, 0x76, 0x01, // &Ŷ (U+0026 U+0176)
  0x00, 0x26, 0x01, 0x78, 0x01, // &Ÿ (U+0026 U+0178)
  0x00, 0x27, 0x00, 0x41, 0x01, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0x67, 0x01, // 'g (U+0027 U+0067)
  0x00, 0x27, 0x00, 0xC0, 0x01, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x01, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x01, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x01, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x01, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x01, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xC6, 0x02, // 'Æ (U+0027 U+00C6)
  0x00, 0x27, 0x01, 0x00, 0x01, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x02, 0x01, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x04, 0x01, // 'Ą (U+0027 U+0104)
  0x00, 0x2A, 0x00, 0x2C, 0x02, // *, (U+002A U+002C)
  0x00, 0x2A, 0x00, 0x2E, 0x02, // *. (U+002A U+002E)
  0x00, 0x2A, 0x00, 0x41, 0x01, // *A (U+002A U+0041)
  0x00, 0x2A, 0x00, 0xC0, 0x01, // *À (U+002A U+00C0)
  0x00, 0x2A, 0x00, 0xC1, 0x01, // *Á (U+002A U+00C1)
  0x00, 0x2A, 0x00, 0xC2, 0x01, // *Â (U+002A U+00C2)
  0x00, 0x2A, 0x00, 0xC3, 0x01, // *Ã (U+002A U+00C3)
  0x00, 0x2A, 0x00, 0xC4, 0x01, // *Ä (U+002A U+00C4)
  0x00, 0x2A, 0x00, 0xC5, 0x01, // *Å (U+002A U+00C5)
  0x00, 0x2A, 0x00, 0xC6, 0x01, // *Æ (U+002A U+00C6)
  0x00, 0x2A, 0x01, 0x00, 0x01, // *Ā (U+002A U+0100)
  0x00, 0x2A, 0x01, 0x02, 0x01, // *Ă (U+002A U+0102)
  0x00, 0x2A, 0x01, 0x04, 0x01, // *Ą (U+002A U+0104)
  0x00, 0x2A, 0x20, 0x1A, 0x02, // *‚ (U+002A U+201A)
  0x00, 0x2A, 0x20, 0x1E, 0x02, // *„ (U+002A U+201E)
  0x00, 0x2A, 0x20, 0x26, 0x02, // *… (U+002A U+2026)
  0x00, 0x2C, 0x00, 0x54, 0x01, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x56, 0x02, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x01, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x01, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0x76, 0x01, // ,v (U+002C U+0076)
  0x00, 0x2C, 0x00, 0xDD, 0x01, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x01, 0x74, 0x01, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x76, 0x01, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x78, 0x01, // ,Ÿ (U+002C U+0178)
  0x00, 0x2E, 0x00, 0x54, 0x01, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x56, 0x02, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x01, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x01, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0x76, 0x01, // .v (U+002E U+0076)
  0x00, 0x2E, 0x00, 0xDD, 0x01, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x01, 0x74, 0x01, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x76, 0x01, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x78, 0x01, // .Ÿ (U+002E U+0178)
  0x00, 0x41, 0x00, 0x22, 0x01, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x01, // A' (U+0041 U+0027)
  0x00, 0x41, 0x00, 0x2A, 0x01, // A* (U+0041 U+002A)
  0x00, 0x41, 0x00, 0x54, 0x01, // AT (U+0041 U+0054)
  0x00, 0x41, 0x00, 0x56, 0x01, // AV (U+0041 U+0056)
  0x00, 0x41, 0x00, 0x57, 0x01, // AW (U+0041 U+0057)
  0x00, 0x41, 0x00, 0x59, 0x01, // AY (U+0041 U+0059)
  0x00, 0x41, 0x00, 0x76, 0x01, // Av (U+0041 U+0076)
  0x00, 0x41, 0x00, 0x77, 0x01, // Aw (U+0041 U+0077)
  0x00, 0x41, 0x00, 0x79, 0x01, // Ay (U+0041 U+0079)
  0x00, 0x41, 0x00, 0xA9, 0x01, // A© (U+0041 U+00A9)
  0x00, 0x41, 0x00, 0xAE, 0x01, // A® (U+0041 U+00AE)
  0x00, 0x41, 0x00, 0xDD, 0x01, // AÝ (U+0041 U+00DD)
  0x00, 0x41, 0x00, 0xFD, 0x01, // Aý (U+0041 U+00FD)
  0x00, 0x41, 0x00, 0xFF, 0x01, // Aÿ (U+0041 U+00FF)
  0x00, 0x41, 0x01, 0x49, 0x01, // Aŉ (U+0041 U+0149)
  0x00, 0x41, 0x01, 0x74, 0x01, // AŴ (U+0041 U+0174)
  0x00, 0x41, 0x01, 0x75, 0x01, // Aŵ (U+0041 U+0175)
  0x00, 0x41, 0x01, 0x76, 0x01, // AŶ (U+0041 U+0176)
  0x00, 0x41, 0x01, 0x77, 0x01, // Aŷ (U+0041 U+0177)
  0x00, 0x41, 0x01, 0x78, 0x01, // AŸ (U+0041 U+0178)
  0x00, 0x41, 0x20, 0x18, 0x02, // A‘ (U+0041 U+2018)
  0x00, 0x41, 0x20, 0x19, 0x01, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1C, 0x02, // A“ (U+0041 U+201C)
  0x00, 0x41, 0x20, 0x1D, 0x01, // A” (U+0041 U+201D)
  0x00, 0x41, 0x21, 0x22, 0x01, // A™ (U+0041 U+2122)
  0x00, 0x42, 0x00, 0x56, 0x01, // BV (U+0042 U+0056)
  0x00, 0x42, 0x00, 0x57, 0x01, // BW (U+0042 U+0057)
  0x00, 0x42, 0x00, 0x59, 0x01, // BY (U+0042 U+0059)
  0x00, 0x42, 0x00, 0xC6, 0x01, // BÆ (U+0042 U+00C6)
  0x00, 0x42, 0x00, 0xDD, 0x01, // BÝ (U+0042 U+00DD)
  0x00, 0x42, 0x01, 0x74, 0x01, // BŴ (U+0042 U+0174)
  0x00, 0x42, 0x01, 0x76, 0x01, // BŶ (U+0042 U+0176)
  0x00, 0x42, 0x01, 0x78, 0x01, // BŸ (U+0042 U+0178)
  0x00, 0x44, 0x00, 0x22, 0x01, // D" (U+0044 U+0022)
  0x00, 0x44, 0x00, 0x27, 0x01, // D' (U+0044 U+0027)
  0x00, 0x44, 0x00, 0x59, 0x01, // DY (U+0044 U+0059)
  0x00, 0x44, 0x00, 0xC6, 0x01, // DÆ (U+0044 U+00C6)
  0x00, 0x44, 0x00, 0xDD, 0x01, // DÝ (U+0044 U+00DD)
  0x00, 0x44, 0x01, 0x76, 0x01, // DŶ (U+0044 U+0176)
  0x00, 0x44, 0x01, 0x78, 0x01, // DŸ (U+0044 U+0178)
  0x00, 0x46, 0x00, 0x26, 0x01, // F& (U+0046 U+0026)
  0x00, 0x46, 0x00, 0x2C, 0x01, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x01, // F. (U+0046 U+002E)
  0x00, 0x46, 0x00, 0x41, 0x01, // FA (U+0046 U+0041)
  0x00, 0x46, 0x00, 0x61, 0x01, // Fa (U+0046 U+0061)
  0x00, 0x46, 0x00, 0x63, 0x01, // Fc (U+0046 U+0063)
  0x00, 0x46, 0x00, 0x64, 0x01, // Fd (U+0046 U+0064)
  0x00, 0x46, 0x00, 0x65, 0x01, // Fe (U+0046 U+0065)
  0x00, 0x46, 0x00, 0x67, 0x01, // Fg (U+0046 U+0067)
  0x00, 0x46, 0x00, 0x6F, 0x01, // Fo (U+0046 U+006F)
  0x00, 0x46, 0x00, 0x71, 0x01, // Fq (U+0046 U+0071)
  0x00, 0x46, 0x00, 0xC0, 0x01, // FÀ (U+0046 U+00C0)
  0x00, 0x46, 0x00, 0xC1, 0x01, // FÁ (U+0046 U+00C1)
  0x00, 0x46, 0x00, 0xC2, 0x01, // FÂ (U+0046 U+00C2)
  0x00, 0x46, 0x00, 0xC3, 0x01, // FÃ (U+0046 U+00C3)
  0x00, 0x46, 0x00, 0xC4, 0x01, // FÄ (U+0046 U+00C4)
  0x00, 0x46, 0x00, 0xC5, 0x01, // FÅ (U+0046 U+00C5)
  0x00, 0x46, 0x00, 0xC6, 0x02, // FÆ (U+0046 U+00C6)
  0x00, 0x46, 0x00, 0xE0, 0x01, // Fà (U+0046 U+00E0)
  0x00, 0x46, 0x00, 0xE1, 0x01, // Fá (U+0046 U+00E1)
  0x00, 0x46, 0x00, 0xE2, 0x01, // Fâ (U+0046 U+00E2)
  0x00, 0x46, 0x00, 0xE3, 0x01, // Fã (U+0046 U+00E3)
  0x00, 0x46, 0x00, 0xE4, 0x01, // Fä (U+0046 U+00E4)
  0x00, 0x46, 0x00, 0xE5, 0x01, // Få (U+0046 U+00E5)
  0x00, 0x46, 0x00, 0xE6, 0x01, // Fæ (U+0046 U+00E6)
  0x00, 0x46, 0x00, 0xE7, 0x01, // Fç (U+0046 U+00E7)
  0x00, 0x46, 0x00, 0xE8, 0x01, // Fè (U+0046 U+00E8)
  0x00, 0x46, 0x00, 0xE9, 0x01, // Fé (U+0046 U+00E9)
  0x00, 0x46, 0x00, 0xEA, 0x01, // Fê (U+0046 U+00EA)
  0x00, 0x46, 0x00, 0xEB, 0x01, // Fë (U+0046 U+00EB)
  0x00, 0x46, 0x00, 0xF0, 0x01, // Fð (U+0046 U+00F0)
  0x00, 0x46, 0x00, 0xF2, 0x01, // Fò (U+0046 U+00F2)
  0x00, 0x46, 0x00, 0xF3, 0x01, // Fó (U+0046 U+00F3)
  0x00, 0x46, 0x00, 0xF4, 0x01, // Fô (U+0046 U+00F4)
  0x00, 0x46, 0x00, 0xF5, 0x01, // Fõ (U+0046 U+00F5)
  0x00, 0x46, 0x00, 0xF6, 0x01, // Fö (U+0046 U+00F6)
  0x00, 0x46, 0x00, 0xF8, 0x01, // Fø (U+0046 U+00F8)
  0x00, 0x46, 0x01, 0x00, 0x01, // FĀ (U+0046 U+0100)
  0x00, 0x46, 0x01, 0x01, 0x01, // Fā (U+0046 U+0101)
  0x00, 0x46, 0x01, 0x02, 0x01, // FĂ (U+0046 U+0102)
  0x00, 0x46, 0x01, 0x03, 0x01, // Fă (U+0046 U+0103)
  0x00, 0x46, 0x01, 0x04, 0x01, // FĄ (U+0046 U+0104)
  0x00, 0x46, 0x01, 0x05, 0x01, // Fą (U+0046 U+0105)
  0x00, 0x46, 0x01, 0x07, 0x01, // Fć (U+0046 U+0107)
  0x00, 0x46, 0x01, 0x09, 0x01, // Fĉ (U+0046 U+0109)
  0x00, 0x46, 0x01, 0x0B, 0x01, // Fċ (U+0046 U+010B)
  0x00, 0x46, 0x01, 0x0D, 0x01, // Fč (U+0046 U+010D)
  0x00, 0x46, 0x01, 0x0F, 0x01, // Fď (U+0046 U+010F)
  0x00, 0x46, 0x01, 0x11, 0x01, // Fđ (U+0046 U+0111)
  0x00, 0x46, 0x01, 0x13, 0x01, // Fē (U+0046 U+0113)
  0x00, 0x46, 0x01, 0x15, 0x01, // Fĕ (U+0046 U+0115)
  0x00, 0x46, 0x01, 0x17, 0x01, // Fė (U+0046 U+0117)
  0x00, 0x46, 0x01, 0x19, 0x01, // Fę (U+0046 U+0119)
  0x00, 0x46, 0x01, 0x1B, 0x01, // Fě (U+0046 U+011B)
  0x00, 0x46, 0x01, 0x1D, 0x01, // Fĝ (U+0046 U+011D)
  0x00, 0x46, 0x01, 0x1F, 0x01, // Fğ (U+0046 U+011F)
  0x00, 0x46, 0x01, 0x21, 0x01, // Fġ (U+0046 U+0121)
  0x00, 0x46, 0x01, 0x23, 0x01, // Fģ (U+0046 U+0123)
  0x00, 0x46, 0x01, 0x4D, 0x01, // Fō (U+0046 U+014D)
  0x00, 0x46, 0x01, 0x4F, 0x01, // Fŏ (U+0046 U+014F)
  0x00, 0x46, 0x01, 0x51, 0x01, // Fő (U+0046 U+0151)
  0x00, 0x46, 0x01, 0x53, 0x01, // Fœ (U+0046 U+0153)
  0x00, 0x46, 0x20, 0x1A, 0x01, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x01, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x01, // F… (U+0046 U+2026)
  0x00, 0x4B, 0x00, 0x77, 0x01, // Kw (U+004B U+0077)
  0x00, 0x4B, 0x00, 0x79, 0x01, // Ky (U+004B U+0079)
  0x00, 0x4B, 0x00, 0xFD, 0x01, // Ký (U+004B U+00FD)
  0x00, 0x4B, 0x00, 0xFF, 0x01, // Kÿ (U+004B U+00FF)
  0x00, 0x4B, 0x01, 0x75, 0x01, // Kŵ (U+004B U+0175)
  0x00, 0x4B, 0x01, 0x77, 0x01, // Kŷ (U+004B U+0177)
  0x00, 0x4C, 0x00, 0x22, 0x01, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x01, // L' (U+004C U+0027)
  0x00, 0x4C, 0x00, 0x2A, 0x01, // L* (U+004C U+002A)
  0x00, 0x4C, 0x00, 0x54, 0x01, // LT (U+004C U+0054)
  0x00, 0x4C, 0x00, 0x56, 0x01, // LV (U+004C U+0056)
  0x00, 0x4C, 0x00, 0x57, 0x01, // LW (U+004C U+0057)
  0x00, 0x4C, 0x00, 0x59, 0x01, // LY (U+004C U+0059)
  0x00, 0x4C, 0x00, 0x76, 0x01, // Lv (U+004C U+0076)
  0x00, 0x4C, 0x00, 0xDD, 0x01, // LÝ (U+004C U+00DD)
  0x00, 0x4C, 0x01, 0x74, 0x01, // LŴ (U+004C U+0174)
  0x00, 0x4C, 0x01, 0x76, 0x01, // LŶ (U+004C U+0176)
  0x00, 0x4C, 0x01, 0x78, 0x01, // LŸ (U+004C U+0178)
  0x00, 0x4C, 0x20, 0x18, 0x02, // L‘ (U+004C U+2018)
  0x00, 0x4C, 0x20, 0x19, 0x01, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1C, 0x02, // L“ (U+004C U+201C)
  0x00, 0x4C, 0x20, 0x1D, 0x01, // L” (U+004C U+201D)
  0x00, 0x4C, 0x21, 0x22, 0x01, // L™ (U+004C U+2122)
  0x00, 0x4F, 0x00, 0x22, 0x01, // O" (U+004F U+0022)
  0x00, 0x4F, 0x00, 0x27, 0x01, // O' (U+004F U+0027)
  0x00, 0x4F, 0x00, 0x59, 0x01, // OY (U+004F U+0059)
  0x00, 0x4F, 0x00, 0xC6, 0x01, // OÆ (U+004F U+00C6)
  0x00, 0x4F, 0x00, 0xDD, 0x01, // OÝ (U+004F U+00DD)
  0x00, 0x4F, 0x01, 0x76, 0x01, // OŶ (U+004F U+0176)
  0x00, 0x4F, 0x01, 0x78, 0x01, // OŸ (U+004F U+0178)
  0x00, 0x50, 0x00, 0x2C, 0x02, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x02, // P. (U+0050 U+002E)
  0x00, 0x50, 0x00, 0x41, 0x01, // PA (U+0050 U+0041)
  0x00, 0x50, 0x00, 0xC0, 0x01, // PÀ (U+0050 U+00C0)
  0x00, 0x50, 0x00, 0xC1, 0x01, // PÁ (U+0050 U+00C1)
  0x00, 0x50, 0x00, 0xC2, 0x01, // PÂ (U+0050 U+00C2)
  0x00, 0x50, 0x00, 0xC3, 0x01, // PÃ (U+0050 U+00C3)
  0x00, 0x50, 0x00, 0xC4, 0x01, // PÄ (U+0050 U+00C4)
  0x00, 0x50, 0x00, 0xC5, 0x01, // PÅ (U+0050 U+00C5)
  0x00, 0x50, 0x00, 0xC6, 0x01, // PÆ (U+0050 U+00C6)
  0x00, 0x50, 0x01, 0x00, 0x01, // PĀ (U+0050 U+0100)
  0x00, 0x50, 0x01, 0x02, 0x01, // PĂ (U+0050 U+0102)
  0x00, 0x50, 0x01, 0x04, 0x01, // PĄ (U+0050 U+0104)
  0x00, 0x50, 0x20, 0x1A, 0x02, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x02, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x02, // P… (U+0050 U+2026)
  0x00, 0x51, 0x00, 0x22, 0x01, // Q" (U+0051 U+0022)
  0x00, 0x51, 0x00, 0x27, 0x01, // Q' (U+0051 U+0027)
  0x00, 0x51, 0x00, 0x59, 0x01, // QY (U+0051 U+0059)
  0x00, 0x51, 0x00, 0xC6, 0x01, // QÆ (U+0051 U+00C6)
  0x00, 0x51, 0x00, 0xDD, 0x01, // QÝ (U+0051 U+00DD)
  0x00, 0x51, 0x01, 0x76, 0x01, // QŶ (U+0051 U+0176)
  0x00, 0x51, 0x01, 0x78, 0x01, // QŸ (U+0051 U+0178)
  0x00, 0x52, 0x00, 0x56, 0x01, // RV (U+0052 U+0056)
  0x00, 0x52, 0x00, 0x57, 0x01, // RW (U+0052 U+0057)
  0x00, 0x52, 0x00, 0x59, 0x01, // RY (U+0052 U+0059)
  0x00, 0x52, 0x00, 0xDD, 0x01, // RÝ (U+0052 U+00DD)
  0x00, 0x52, 0x01, 0x74, 0x01, // RŴ (U+0052 U+0174)
  0x00, 0x52, 0x01, 0x76, 0x01, // RŶ (U+0052 U+0176)
  0x00, 0x52, 0x01, 0x78, 0x01, // RŸ (U+0052 U+0178)
  0x00, 0x54, 0x00, 0x2C, 0x02, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2E, 0x02, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0x41, 0x01, // TA (U+0054 U+0041)
  0x00, 0x54, 0x00, 0x61, 0x01, // Ta (U+0054 U+0061)
  0x00, 0x54, 0x00, 0x63, 0x01, // Tc (U+0054 U+0063)
  0x00, 0x54, 0x00, 0x64, 0x01, // Td (U+0054 U+0064)
  0x00, 0x54, 0x00, 0x65, 0x01, // Te (U+0054 U+0065)
  0x00, 0x54, 0x00, 0x67, 0x01, // Tg (U+0054 U+0067)
  0x00, 0x54, 0x00, 0x6F, 0x01, // To (U+0054 U+006F)
  0x00, 0x54, 0x00, 0x71, 0x01, // Tq (U+0054 U+0071)
  0x00, 0x54, 0x00, 0xC0, 0x01, // TÀ (U+0054 U+00C0)
  0x00, 0x54, 0x00, 0xC1, 0x01, // TÁ (U+0054 U+00C1)
  0x00, 0x54, 0x00, 0xC2, 0x01, // TÂ (U+0054 U+00C2)
  0x00, 0x54, 0x00, 0xC3, 0x01, // TÃ (U+0054 U+00C3)
  0x00, 0x54, 0x00, 0xC4, 0x01, // TÄ (U+0054 U+00C4)
  0x00, 0x54, 0x00, 0xC5, 0x01, // TÅ (U+0054 U+00C5)
  0x00, 0x54, 0x00, 0xC6, 0x01, // TÆ (U+0054 U+00C6)
  0x00, 0x54, 0x00, 0xE0, 0x01, // Tà (U+0054 U+00E0)
  0x00, 0x54, 0x00, 0xE1, 0x01, // Tá (U+0054 U+00E1)
  0x00, 0x54, 0x00, 0xE2, 0x01, // Tâ (U+0054 U+00E2)
  0x00, 0x54, 0x00, 0xE3, 0x01, // Tã (U+0054 U+00E3)
  0x00, 0x54, 0x00, 0xE4, 0x01, // Tä (U+0054 U+00E4)
  0x00, 0x54, 0x00, 0xE5, 0x01, // Tå (U+0054 U+00E5)
  0x00, 0x54, 0x00, 0xE6, 0x01, // Tæ (U+0054 U+00E6)
  0x00, 0x54, 0x00, 0xE7, 0x01, // Tç (U+0054 U+00E7)
  0x00, 0x54, 0x00, 0xE8, 0x01, // Tè (U+0054 U+00E8)
  0x00, 0x54, 0x00, 0xE9, 0x01, // Té (U+0054 U+00E9)
  0x00, 0x54, 0x00, 0xEA, 0x01, // Tê (U+0054 U+00EA)
  0x00, 0x54, 0x00, 0xEB, 0x01, // Të (U+0054 U+00EB)
  0x00, 0x54, 0x00, 0xF0, 0x01, // Tð (U+0054 U+00F0)
  0x00, 0x54, 0x00, 0xF2, 0x01, // Tò (U+0054 U+00F2)
  0x00, 0x54, 0x00, 0xF3, 0x01, // Tó (U+0054 U+00F3)
  0x00, 0x54, 0x00, 0xF4, 0x01, // Tô (U+0054 U+00F4)
  0x00, 0x54, 0x00, 0xF5, 0x01, // Tõ (U+0054 U+00F5)
  0x00, 0x54, 0x00, 0xF6, 0x01, // Tö (U+0054 U+00F6)
  0x00, 0x54, 0x00, 0xF8, 0x01, // Tø (U+0054 U+00F8)
  0x00, 0x54, 0x01, 0x00, 0x01, // TĀ (U+0054 U+0100)
  0x00, 0x54, 0x01, 0x01, 0x01, // Tā (U+0054 U+0101)
  0x00, 0x54, 0x01, 0x02, 0x01, // TĂ (U+0054 U+0102)
  0x00, 0x54, 0x01, 0x03, 0x01, // Tă (U+0054 U+0103)
  0x00, 0x54, 0x01, 0x04, 0x01, // TĄ (U+0054 U+0104)
  0x00, 0x54, 0x01, 0x05, 0x01, // Tą (U+0054 U+0105)
  0x00, 0x54, 0x01, 0x07, 0x01, // Tć (U+0054 U+0107)
  0x00, 0x54, 0x01, 0x09, 0x01, // Tĉ (U+0054 U+0109)
  0x00, 0x54, 0x01, 0x0B, 0x01, // Tċ (U+0054 U+010B)
  0x00, 0x54, 0x01, 0x0D, 0x01, // Tč (U+0054 U+010D)
  0x00, 0x54, 0x01, 0x0F, 0x01, // Tď (U+0054 U+010F)
  0x00, 0x54, 0x01, 0x11, 0x01, // Tđ (U+0054 U+0111)
  0x00, 0x54, 0x01, 0x13, 0x01, // Tē (U+0054 U+0113)
  0x00, 0x54, 0x01, 0x15, 0x01, // Tĕ (U+0054 U+0115)
  0x00, 0x54, 0x01, 0x17, 0x01, // Tė (U+0054 U+0117)
  0x00, 0x54, 0x01, 0x19, 0x01, // Tę (U+0054 U+0119)
  0x00, 0x54, 0x01, 0x1B, 0x01, // Tě (U+0054 U+011B)
  0x00, 0x54, 0x01, 0x1D, 0x01, // Tĝ (U+0054 U+011D)
  0x00, 0x54, 0x01, 0x1F, 0x01, // Tğ (U+0054 U+011F)
  0x00, 0x54, 0x01, 0x21, 0x01, // Tġ (U+0054 U+0121)
  0x00, 0x54, 0x01, 0x23, 0x01, // Tģ (U+0054 U+0123)
  0x00, 0x54, 0x01, 0x4D, 0x01, // Tō (U+0054 U+014D)
  0x00, 0x54, 0x01, 0x4F, 0x01, // Tŏ (U+0054 U+014F)
  0x00, 0x54, 0x01, 0x51, 0x01, // Tő (U+0054 U+0151)
  0x00, 0x54, 0x01, 0x53, 0x01, // Tœ (U+0054 U+0153)
  0x00, 0x54, 0x20, 0x1A, 0x02, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x02, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x02, // T… (U+0054 U+2026)
  0x00, 0x56, 0x00, 0x26, 0x01, // V& (U+0056 U+0026)
  0x00, 0x56, 0x00, 0x2C, 0x02, // V, (U+0056 U+002C)
  0x00, 0x56, 0x00, 0x2E, 0x02, // V. (U+0056 U+002E)
  0x00, 0x56, 0x00, 0x41, 0x01, // VA (U+0056 U+0041)
  0x00, 0x56, 0x00, 0x61, 0x01, // Va (U+0056 U+0061)
  0x00, 0x56, 0x00, 0x63, 0x01, // Vc (U+0056 U+0063)
  0x00, 0x56, 0x00, 0x64, 0x01, // Vd (U+0056 U+0064)
  0x00, 0x56, 0x00, 0x65, 0x01, // Ve (U+0056 U+0065)
  0x00, 0x56, 0x00, 0x67, 0x01, // Vg (U+0056 U+0067)
  0x00, 0x56, 0x00, 0x6F, 0x01, // Vo (U+0056 U+006F)
  0x00, 0x56, 0x00, 0x71, 0x01, // Vq (U+0056 U+0071)
  0x00, 0x56, 0x00, 0x73, 0x01, // Vs (U+0056 U+0073)
  0x00, 0x56, 0x00, 0xC0, 0x01, // VÀ (U+0056 U+00C0)
  0x00, 0x56, 0x00, 0xC1, 0x01, // VÁ (U+0056 U+00C1)
  0x00, 0x56, 0x00, 0xC2, 0x01, // VÂ (U+0056 U+00C2)
  0x00, 0x56, 0x00, 0xC3, 0x01, // VÃ (U+0056 U+00C3)
  0x00, 0x56, 0x00, 0xC4, 0x01, // VÄ (U+0056 U+00C4)
  0x00, 0x56, 0x00, 0xC5, 0x01, // VÅ (U+0056 U+00C5)
  0x00, 0x56, 0x00, 0xC6, 0x02, // VÆ (U+0056 U+00C6)
  0x00, 0x56, 0x00, 0xE0, 0x01, // Và (U+0056 U+00E0)
  0x00, 0x56, 0x00, 0xE1, 0x01, // Vá (U+0056 U+00E1)
  0x00, 0x56, 0x00, 0xE2, 0x01, // Vâ (U+0056 U+00E2)
  0x00, 0x56, 0x00, 0xE3, 0x01, // Vã (U+0056 U+00E3)
  0x00, 0x56, 0x00, 0xE4, 0x01, // Vä (U+0056 U+00E4)
  0x00, 0x56, 0x00, 0xE5, 0x01, // Vå (U+0056 U+00E5)
  0x00, 0x56, 0x00, 0xE6, 0x01, // Væ (U+0056 U+00E6)
  0x00, 0x56, 0x00, 0xE7, 0x01, // Vç (U+0056 U+00E7)
  0x00, 0x56, 0x00, 0xE8, 0x01, // Vè (U+0056 U+00E8)
  0x00, 0x56, 0x00, 0xE9, 0x01, // Vé (U+0056 U+00E9)
  0x00, 0x56, 0x00, 0xEA, 0x01, // Vê (U+0056 U+00EA)
  0x00, 0x56, 0x00, 0xEB, 0x01, // Vë (U+0056 U+00EB)
  0x00, 0x56, 0x00, 0xF0, 0x01, // Vð (U+0056 U+00F0)
  0x00, 0x56, 0x00, 0xF2, 0x01, // Vò (U+0056 U+00F2)
  0x00, 0x56, 0x00, 0xF3, 0x01, // Vó (U+0056 U+00F3)
  0x00, 0x56, 0x00, 0xF4, 0x01, // Vô (U+0056 U+00F4)
  0x00, 0x56, 0x00, 0xF5, 0x01, // Võ (U+0056 U+00F5)
  0x00, 0x56, 0x00, 0xF6, 0x01, // Vö (U+0056 U+00F6)
  0x00, 0x56, 0x00, 0xF8, 0x01, // Vø (U+0056 U+00F8)
  0x00, 0x56, 0x01, 0x00, 0x01, // VĀ (U+0056 U+0100)
  0x00, 0x56, 0x01, 0x01, 0x01, // Vā (U+0056 U+0101)
  0x00, 0x56, 0x01, 0x02, 0x01, // VĂ (U+0056 U+0102)
  0x00, 0x56, 0x01, 0x03, 0x01, // Vă (U+0056 U+0103)
  0x00, 0x56, 0x01, 0x04, 0x01, // VĄ (U+0056 U+0104)
  0x00, 0x56, 0x01, 0x05, 0x01, // Vą (U+0056 U+0105)
  0x00, 0x56, 0x01, 0x07, 0x01, // Vć (U+0056 U+0107)
  0x00, 0x56, 0x01, 0x09, 0x01, // Vĉ (U+0056 U+0109)
  0x00, 0x56, 0x01, 0x0B, 0x01, // Vċ (U+0056 U+010B)
  0x00, 0x56, 0x01, 0x0D, 0x01, // Vč (U+0056 U+010D)
  0x00, 0x56, 0x01, 0x0F, 0x01, // Vď (U+0056 U+010F)
  0x00, 0x56, 0x01, 0x11, 0x01, // Vđ (U+0056 U+0111)
  0x00, 0x56, 0x01, 0x13, 0x01, // Vē (U+0056 U+0113)
  0x00, 0x56, 0x01, 0x15, 0x01, // Vĕ (U+0056 U+0115)
  0x00, 0x56, 0x01, 0x17, 0x01, // Vė (U+0056 U+0117)
  0x00, 0x56, 0x01, 0x19, 0x01, // Vę (U+0056 U+0119)
  0x00, 0x56, 0x01, 0x1B, 0x01, // Vě (U+0056 U+011B)
  0x00, 0x56, 0x01, 0x1D, 0x01, // Vĝ (U+0056 U+011D)
  0x00, 0x56, 0x01, 0x1F, 0x01, // Vğ (U+0056 U+011F)
  0x00, 0x56, 0x01, 0x21, 0x01, // Vġ (U+0056 U+0121)
  0x00, 0x56, 0x01, 0x23, 0x01, // Vģ (U+0056 U+0123)
  0x00, 0x56, 0x01, 0x4D, 0x01, // Vō (U+0056 U+014D)
  0x00, 0x56, 0x01, 0x4F, 0x01, // Vŏ (U+0056 U+014F)
  0x00, 0x56, 0x01, 0x51, 0x01, // Vő (U+0056 U+0151)
  0x00, 0x56, 0x01, 0x53, 0x01, // Vœ (U+0056 U+0153)
  0x00, 0x56, 0x01, 0x5B, 0x01, // Vś (U+0056 U+015B)
  0x00, 0x56, 0x01, 0x5D, 0x01, // Vŝ (U+0056 U+015D)
  0x00, 0x56, 0x01, 0x5F, 0x01, // Vş (U+0056 U+015F)
  0x00, 0x56, 0x01, 0x61, 0x01, // Vš (U+0056 U+0161)
  0x00, 0x56, 0x20, 0x1A, 0x02, // V‚ (U+0056 U+201A)
  0x00, 0x56, 0x20, 0x1E, 0x02, // V„ (U+0056 U+201E)
  0x00, 0x56, 0x20, 0x26, 0x02, // V… (U+0056 U+2026)
  0x00, 0x57, 0x00, 0x26, 0x01, // W& (U+0057 U+0026)
  0x00, 0x57, 0x00, 0x2C, 0x02, // W, (U+0057 U+002C)
  0x00, 0x57, 0x00, 0x2E, 0x02, // W. (U+0057 U+002E)
  0x00, 0x57, 0x00, 0x41, 0x01, // WA (U+0057 U+0041)
  0x00, 0x57, 0x00, 0x61, 0x01, // Wa (U+0057 U+0061)
  0x00, 0x57, 0x00, 0x63, 0x01, // Wc (U+0057 U+0063)
  0x00, 0x57, 0x00, 0x64, 0x01, // Wd (U+0057 U+0064)
  0x00, 0x57, 0x00, 0x65, 0x01, // We (U+0057 U+0065)
  0x00, 0x57, 0x00, 0x67, 0x01, // Wg (U+0057 U+0067)
  0x00, 0x57, 0x00, 0x6F, 0x01, // Wo (U+0057 U+006F)
  0x00, 0x57, 0x00, 0x71, 0x01, // Wq (U+0057 U+0071)
  0x00, 0x57, 0x00, 0x73, 0x01, // Ws (U+0057 U+0073)
  0x00, 0x57, 0x00, 0xC0, 0x01, // WÀ (U+0057 U+00C0)
  0x00, 0x57, 0x00, 0xC1, 0x01, // WÁ (U+0057 U+00C1)
  0x00, 0x57, 0x00, 0xC2, 0x01, // WÂ (U+0057 U+00C2)
  0x00, 0x57, 0x00, 0xC3, 0x01, // WÃ (U+0057 U+00C3)
  0x00, 0x57, 0x00, 0xC4, 0x01, // WÄ (U+0057 U+00C4)
  0x00, 0x57, 0x00, 0xC5, 0x01, // WÅ (U+0057 U+00C5)
  0x00, 0x57, 0x00, 0xC6, 0x02, // WÆ (U+0057 U+00C6)
  0x00, 0x57, 0x00, 0xE0, 0x01, // Wà (U+0057 U+00E0)
  0x00, 0x57, 0x00, 0xE1, 0x01, // Wá (U+0057 U+00E1)
  0x00, 0x57, 0x00, 0xE2, 0x01, // Wâ (U+0057 U+00E2)
  0x00, 0x57, 0x00, 0xE3, 0x01, // Wã (U+0057 U+00E3)
  0x00, 0x57, 0x00, 0xE4, 0x01, // Wä (U+0057 U+00E4)
  0x00, 0x57, 0x00, 0xE5, 0x01, // Wå (U+0057 U+00E5)
  0x00, 0x57, 0x00, 0xE6, 0x01, // Wæ (U+0057 U+00E6)
  0x00, 0x57, 0x00, 0xE7, 0x01, // Wç (U+0057 U+00E7)
  0x00, 0x57, 0x00, 0xE8, 0x01, // Wè (U+0057 U+00E8)
  0x00, 0x57, 0x00, 0xE9, 0x01, // Wé (U+0057 U+00E9)
  0x00, 0x57, 0x00, 0xEA, 0x01, // Wê (U+0057 U+00EA)
  0x00, 0x57, 0x00, 0xEB, 0x01, // Wë (U+0057 U+00EB)
  0x00, 0x57, 0x00, 0xF0, 0x01, // Wð (U+0057 U+00F0)
  0x00, 0x57, 0x00, 0xF2, 0x01, // Wò (U+0057 U+00F2)
  0x00, 0x57, 0x00, 0xF3, 0x01, // Wó (U+0057 U+00F3)
  0x00, 0x57, 0x00, 0xF4, 0x01, // Wô (U+0057 U+00F4)
  0x00, 0x57, 0x00, 0xF5, 0x01, // Wõ (U+0057 U+00F5)
  0x00, 0x57, 0x00, 0xF6, 0x01, // Wö (U+0057 U+00F6)
  0x00, 0x57, 0x00, 0xF8, 0x01, // Wø (U+0057 U+00F8)
  0x00, 0x57, 0x01, 0x00, 0x01, // WĀ (U+0057 U+0100)
  0x00, 0x57, 0x01, 0x01, 0x01, // Wā (U+0057 U+0101)
  0x00, 0x57, 0x01, 0x02, 0x01, // WĂ (U+0057 U+0102)
  0x00, 0x57, 0x01, 0x03, 0x01, // Wă (U+0057 U+0103)
  0x00, 0x57, 0x01, 0x04, 0x01, // WĄ (U+0057 U+0104)
  0x00, 0x57, 0x01, 0x05, 0x01, // Wą (U+0057 U+0105)
  0x00, 0x57, 0x01, 0x07, 0x01, // Wć (U+0057 U+0107)
  0x00, 0x57, 0x01, 0x09, 0x01, // Wĉ (U+0057 U+0109)
  0x00, 0x57, 0x01, 0x0B, 0x01, // Wċ (U+0057 U+010B)
  0x00, 0x57, 0x01, 0x0D, 0x01, // Wč (U+0057 U+010D)
  0x00, 0x57, 0x01, 0x0F, 0x01, // Wď (U+0057 U+010F)
  0x00, 0x57, 0x01, 0x11, 0x01, // Wđ (U+0057 U+0111)
  0x00, 0x57, 0x01, 0x13, 0x01, // Wē (U+0057 U+0113)
  0x00, 0x57, 0x01, 0x15, 0x01, // Wĕ (U+0057 U+0115)
  0x00, 0x57, 0x01, 0x17, 0x01, // Wė (U+0057 U+0117)
  0x00, 0x57, 0x01, 0x19, 0x01, // Wę (U+0057 U+0119)
  0x00, 0x57, 0x01, 0x1B, 0x01, // Wě (U+0057 U+011B)
  0x00, 0x57, 0x01, 0x1D, 0x01, // Wĝ (U+0057 U+011D)
  0x00, 0x57, 0x01, 0x1F, 0x01, // Wğ (U+0057 U+011F)
  0x00, 0x57, 0x01, 0x21, 0x01, // Wġ (U+0057 U+0121)
  0x00, 0x57, 0x01, 0x23, 0x01, // Wģ (U+0057 U+0123)
  0x00, 0x57, 0x01, 0x4D, 0x01, // Wō (U+0057 U+014D)
  0x00, 0x57, 0x01, 0x4F, 0x01, // Wŏ (U+0057 U+014F)
  0x00, 0x57, 0x01, 0x51, 0x01, // Wő (U+0057 U+0151)
  0x00, 0x57, 0x01, 0x53, 0x01, // Wœ (U+0057 U+0153)
  0x00, 0x57, 0x01, 0x5B, 0x01, // Wś (U+0057 U+015B)
  0x00, 0x57, 0x01, 0x5D, 0x01, // Wŝ (U+0057 U+015D)
  0x00, 0x57, 0x01, 0x5F, 0x01, // Wş (U+0057 U+015F)
  0x00, 0x57, 0x01, 0x61, 0x01, // Wš (U+0057 U+0161)
  0x00, 0x57, 0x20, 0x1A, 0x02, // W‚ (U+0057 U+201A)
  0x00, 0x57, 0x20, 0x1E, 0x02, // W„ (U+0057 U+201E)
  0x00, 0x57, 0x20, 0x26, 0x02, // W… (U+0057 U+2026)
  0x00, 0x58, 0x00, 0x77, 0x01, // Xw (U+0058 U+0077)
  0x00, 0x58, 0x00, 0x79, 0x01, // Xy (U+0058 U+0079)
  0x00, 0x58, 0x00, 0xA9, 0x01, // X© (U+0058 U+00A9)
  0x00, 0x58, 0x00, 0xAE, 0x01, // X® (U+0058 U+00AE)
  0x00, 0x58, 0x00, 0xFD, 0x01, // Xý (U+0058 U+00FD)
  0x00, 0x58, 0x00, 0xFF, 0x01, // Xÿ (U+0058 U+00FF)
  0x00, 0x58, 0x01, 0x75, 0x01, // Xŵ (U+0058 U+0175)
  0x00, 0x58, 0x01, 0x77, 0x01, // Xŷ (U+0058 U+0177)
  0x00, 0x59, 0x00, 0x26, 0x01, // Y& (U+0059 U+0026)
  0x00, 0x59, 0x00, 0x2C, 0x01, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x01, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x00, 0x41, 0x01, // YA (U+0059 U+0041)
  0x00, 0x59, 0x00, 0x43, 0x01, // YC (U+0059 U+0043)
  0x00, 0x59, 0x00, 0x47, 0x01, // YG (U+0059 U+0047)
  0x00, 0x59, 0x00, 0x4F, 0x01, // YO (U+0059 U+004F)
  0x00, 0x59, 0x00, 0x51, 0x01, // YQ (U+0059 U+0051)
  0x00, 0x59, 0x00, 0x61, 0x01, // Ya (U+0059 U+0061)
  0x00, 0x59, 0x00, 0x63, 0x01, // Yc (U+0059 U+0063)
  0x00, 0x59, 0x00, 0x64, 0x01, // Yd (U+0059 U+0064)
  0x00, 0x59, 0x00, 0x65, 0x01, // Ye (U+0059 U+0065)
  0x00, 0x59, 0x00, 0x67, 0x01, // Yg (U+0059 U+0067)
  0x00, 0x59, 0x00, 0x6F, 0x01, // Yo (U+0059 U+006F)
  0x00, 0x59, 0x00, 0x71, 0x01, // Yq (U+0059 U+0071)
  0x00, 0x59, 0x00, 0x73, 0x01, // Ys (U+0059 U+0073)
  0x00, 0x59, 0x00, 0xC0, 0x01, // YÀ (U+0059 U+00C0)
  0x00, 0x59, 0x00, 0xC1, 0x01, // YÁ (U+0059 U+00C1)
  0x00, 0x59, 0x00, 0xC2, 0x01, // YÂ (U+0059 U+00C2)
  0x00, 0x59, 0x00, 0xC3, 0x01, // YÃ (U+0059 U+00C3)
  0x00, 0x59, 0x00, 0xC4, 0x01, // YÄ (U+0059 U+00C4)
  0x00, 0x59, 0x00, 0xC5, 0x01, // YÅ (U+0059 U+00C5)
  0x00, 0x59, 0x00, 0xC6, 0x02, // YÆ (U+0059 U+00C6)
  0x00, 0x59, 0x00, 0xC7, 0x01, // YÇ (U+0059 U+00C7)
  0x00, 0x59, 0x00, 0xD2, 0x01, // YÒ (U+0059 U+00D2)
  0x00, 0x59, 0x00, 0xD3, 0x01, // YÓ (U+0059 U+00D3)
  0x00, 0x59, 0x00, 0xD4, 0x01, // YÔ (U+0059 U+00D4)
  0x00, 0x59, 0x00, 0xD5, 0x01, // YÕ (U+0059 U+00D5)
  0x00, 0x59, 0x00, 0xD6, 0x01, // YÖ (U+0059 U+00D6)
  0x00, 0x59, 0x00, 0xD8, 0x01, // YØ (U+0059 U+00D8)
  0x00, 0x59, 0x00, 0xE0, 0x01, // Yà (U+0059 U+00E0)
  0x00, 0x59, 0x00, 0xE1, 0x01, // Yá (U+0059 U+00E1)
  0x00, 0x59, 0x00, 0xE2, 0x01, // Yâ (U+0059 U+00E2)
  0x00, 0x59, 0x00, 0xE3, 0x01, // Yã (U+0059 U+00E3)
  0x00, 0x59, 0x00, 0xE4, 0x01, // Yä (U+0059 U+00E4)
  0x00, 0x59, 0x00, 0xE5, 0x01, // Yå (U+0059 U+00E5)
  0x00, 0x59, 0x00, 0xE6, 0x01, // Yæ (U+0059 U+00E6)
  0x00, 0x59, 0x00, 0xE7, 0x01, // Yç (U+0059 U+00E7)
  0x00, 0x59, 0x00, 0xE8, 0x01, // Yè (U+0059 U+00E8)
  0x00, 0x59, 0x00, 0xE9, 0x01, // Yé (U+0059 U+00E9)
  0x00, 0x59, 0x00, 0xEA, 0x01, // Yê (U+0059 U+00EA)
  0x00, 0x59, 0x00, 0xEB, 0x01, // Yë (U+0059 U+00EB)
  0x00, 0x59, 0x00, 0xF0, 0x01, // Yð (U+0059 U+00F0)
  0x00, 0x59, 0x00, 0xF2, 0x01, // Yò (U+0059 U+00F2)
  0x00, 0x59, 0x00, 0xF3, 0x01, // Yó (U+0059 U+00F3)
  0x00, 0x59, 0x00, 0xF4, 0x01, // Yô (U+0059 U+00F4)
  0x00, 0x59, 0x00, 0xF5, 0x01, // Yõ (U+0059 U+00F5)
  0x00, 0x59, 0x00, 0xF6, 0x01, // Yö (U+0059 U+00F6)
  0x00, 0x59, 0x00, 0xF8, 0x01, // Yø (U+0059 U+00F8)
  0x00, 0x59, 0x01, 0x00, 0x01, // YĀ (U+0059 U+0100)
  0x00, 0x59, 0x01, 0x01, 0x01, // Yā (U+0059 U+0101)
  0x00, 0x59, 0x01, 0x02, 0x01, // YĂ (U+0059 U+0102)
  0x00, 0x59, 0x01, 0x03, 0x01, // Yă (U+0059 U+0103)
  0x00, 0x59, 0x01, 0x04, 0x01, // YĄ (U+0059 U+0104)
  0x00, 0x59, 0x01, 0x05, 0x01, // Yą (U+0059 U+0105)
  0x00, 0x59, 0x01, 0x06, 0x01, // YĆ (U+0059 U+0106)
  0x00, 0x59, 0x01, 0x07, 0x01, // Yć (U+0059 U+0107)
  0x00, 0x59, 0x01, 0x08, 0x01, // YĈ (U+0059 U+0108)
  0x00, 0x59, 0x01, 0x09, 0x01, // Yĉ (U+0059 U+0109)
  0x00, 0x59, 0x01, 0x0A, 0x01, // YĊ (U+0059 U+010A)
  0x00, 0x59, 0x01, 0x0B, 0x01, // Yċ (U+0059 U+010B)
  0x00, 0x59, 0x01, 0x0C, 0x01, // YČ (U+0059 U+010C)
  0x00, 0x59, 0x01, 0x0D, 0x01, // Yč (U+0059 U+010D)
  0x00, 0x59, 0x01, 0x0F, 0x01, // Yď (U+0059 U+010F)
  0x00, 0x59, 0x01, 0x11, 0x01, // Yđ (U+0059 U+0111)
  0x00, 0x59, 0x01, 0x13, 0x01, // Yē (U+0059 U+0113)
  0x00, 0x59, 0x01, 0x15, 0x01, // Yĕ (U+0059 U+0115)
  0x00, 0x59, 0x01, 0x17, 0x01, // Yė (U+0059 U+0117)
  0x00, 0x59, 0x01, 0x19, 0x01, // Yę (U+0059 U+0119)
  0x00, 0x59, 0x01, 0x1B, 0x01, // Yě (U+0059 U+011B)
  0x00, 0x59, 0x01, 0x1C, 0x01, // YĜ (U+0059 U+011C)
  0x00, 0x59, 0x01, 0x1D, 0x01, // Yĝ (U+0059 U+011D)
  0x00, 0x59, 0x01, 0x1E, 0x01, // YĞ (U+0059 U+011E)
  0x00, 0x59, 0x01, 0x1F, 0x01, // Yğ (U+0059 U+011F)
  0x00, 0x59, 0x01, 0x20, 0x01, // YĠ (U+0059 U+0120)
  0x00, 0x59, 0x01, 0x21, 0x01, // Yġ (U+0059 U+0121)
  0x00, 0x59, 0x01, 0x22, 0x01, // YĢ (U+0059 U+0122)
  0x00, 0x59, 0x01, 0x23, 0x01, // Yģ (U+0059 U+0123)
  0x00, 0x59, 0x01, 0x4C, 0x01, // YŌ (U+0059 U+014C)
  0x00, 0x59, 0x01, 0x4D, 0x01, // Yō (U+0059 U+014D)
  0x00, 0x59, 0x01, 0x4E, 0x01, // YŎ (U+0059 U+014E)
  0x00, 0x59, 0x01, 0x4F, 0x01, // Yŏ (U+0059 U+014F)
  0x00, 0x59, 0x01, 0x50, 0x01, // YŐ (U+0059 U+0150)
  0x00, 0x59, 0x01, 0x51, 0x01, // Yő (U+0059 U+0151)
  0x00, 0x59, 0x01, 0x52, 0x01, // YŒ (U+0059 U+0152)
  0x00, 0x59, 0x01, 0x53, 0x01, // Yœ (U+0059 U+0153)
  0x00, 0x59, 0x01, 0x5B, 0x01, // Yś (U+0059 U+015B)
  0x00, 0x59, 0x01, 0x5D, 0x01, // Yŝ (U+0059 U+015D)
  0x00, 0x59, 0x01, 0x5F, 0x01, // Yş (U+0059 U+015F)
  0x00, 0x59, 0x01, 0x61, 0x01, // Yš (U+0059 U+0161)
  0x00, 0x59, 0x20, 0x1A, 0x01, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x01, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x01, // Y… (U+0059 U+2026)
  0x00, 0x61, 0x00, 0x22, 0x01, // a" (U+0061 U+0022)
  0x00, 0x61, 0x00, 0x27, 0x01, // a' (U+0061 U+0027)
  0x00, 0x61, 0x00, 0x56, 0x01, // aV (U+0061 U+0056)
  0x00, 0x61, 0x00, 0x57, 0x01, // aW (U+0061 U+0057)
  0x00, 0x61, 0x00, 0x59, 0x01, // aY (U+0061 U+0059)
  0x00, 0x61, 0x00, 0xDD, 0x01, // aÝ (U+0061 U+00DD)
  0x00, 0x61, 0x01, 0x74, 0x01, // aŴ (U+0061 U+0174)
  0x00, 0x61, 0x01, 0x76, 0x01, // aŶ (U+0061 U+0176)
  0x00, 0x61, 0x01, 0x78, 0x01, // aŸ (U+0061 U+0178)
  0x00, 0x61, 0x20, 0x18, 0x01, // a‘ (U+0061 U+2018)
  0x00, 0x61, 0x20, 0x1C, 0x01, // a“ (U+0061 U+201C)
  0x00, 0x62, 0x00, 0x54, 0x01, // bT (U+0062 U+0054)
  0x00, 0x62, 0x00, 0x56, 0x01, // bV (U+0062 U+0056)
  0x00, 0x62, 0x00, 0x57, 0x01, // bW (U+0062 U+0057)
  0x00, 0x62, 0x00, 0x59, 0x01, // bY (U+0062 U+0059)
  0x00, 0x62, 0x00, 0xDD, 0x01, // bÝ (U+0062 U+00DD)
  0x00, 0x62, 0x01, 0x74, 0x01, // bŴ (U+0062 U+0174)
  0x00, 0x62, 0x01, 0x76, 0x01, // bŶ (U+0062 U+0176)
  0x00, 0x62, 0x01, 0x78, 0x01, // bŸ (U+0062 U+0178)
  0x00, 0x63, 0x00, 0x56, 0x01, // cV (U+0063 U+0056)
  0x00, 0x63, 0x00, 0x57, 0x01, // cW (U+0063 U+0057)
  0x00, 0x63, 0x00, 0x59, 0x01, // cY (U+0063 U+0059)
  0x00, 0x63, 0x00, 0xDD, 0x01, // cÝ (U+0063 U+00DD)
  0x00, 0x63, 0x01, 0x74, 0x01, // cŴ (U+0063 U+0174)
  0x00, 0x63, 0x01, 0x76, 0x01, // cŶ (U+0063 U+0176)
  0x00, 0x63, 0x01, 0x78, 0x01, // cŸ (U+0063 U+0178)
  0x00, 0x65, 0x00, 0x56, 0x01, // eV (U+0065 U+0056)
  0x00, 0x65, 0x00, 0x57, 0x01, // eW (U+0065 U+0057)
  0x00, 0x65, 0x00, 0x59, 0x01, // eY (U+0065 U+0059)
  0x00, 0x65, 0x00, 0xDD, 0x01, // eÝ (U+0065 U+00DD)
  0x00, 0x65, 0x01, 0x74, 0x01, // eŴ (U+0065 U+0174)
  0x00, 0x65, 0x01, 0x76, 0x01, // eŶ (U+0065 U+0176)
  0x00, 0x65, 0x01, 0x78, 0x01, // eŸ (U+0065 U+0178)
  0x00, 0x68, 0x00, 0x22, 0x01, // h" (U+0068 U+0022)
  0x00, 0x68, 0x00, 0x27, 0x01, // h' (U+0068 U+0027)
  0x00, 0x68, 0x00, 0x56, 0x01, // hV (U+0068 U+0056)
  0x00, 0x68, 0x00, 0x57, 0x01, // hW (U+0068 U+0057)
  0x00, 0x68, 0x00, 0x59, 0x01, // hY (U+0068 U+0059)
  0x00, 0x68, 0x00, 0xDD, 0x01, // hÝ (U+0068 U+00DD)
  0x00, 0x68, 0x01, 0x74, 0x01, // hŴ (U+0068 U+0174)
  0x00, 0x68, 0x01, 0x76, 0x01, // hŶ (U+0068 U+0176)
  0x00, 0x68, 0x01, 0x78, 0x01, // hŸ (U+0068 U+0178)
  0x00, 0x68, 0x20, 0x18, 0x01, // h‘ (U+0068 U+2018)
  0x00, 0x68, 0x20, 0x1C, 0x01, // h“ (U+0068 U+201C)
  0x00, 0x6D, 0x00, 0x22, 0x01, // m" (U+006D U+0022)
  0x00, 0x6D, 0x00, 0x27, 0x01, // m' (U+006D U+0027)
  0x00, 0x6D, 0x00, 0x56, 0x01, // mV (U+006D U+0056)
  0x00, 0x6D, 0x00, 0x57, 0x01, // mW (U+006D U+0057)
  0x00, 0x6D, 0x00, 0x59, 0x01, // mY (U+006D U+0059)
  0x00, 0x6D, 0x00, 0xDD, 0x01, // mÝ (U+006D U+00DD)
  0x00, 0x6D, 0x01, 0x74, 0x01, // mŴ (U+006D U+0174)
  0x00, 0x6D, 0x01, 0x76, 0x01, // mŶ (U+006D U+0176)
  0x00, 0x6D, 0x01, 0x78, 0x01, // mŸ (U+006D U+0178)
  0x00, 0x6D, 0x20, 0x18, 0x01, // m‘ (U+006D U+2018)
  0x00, 0x6D, 0x20, 0x1C, 0x01, // m“ (U+006D U+201C)
  0x00, 0x6E, 0x00, 0x22, 0x01, // n" (U+006E U+0022)
  0x00, 0x6E, 0x00, 0x27, 0x01, // n' (U+006E U+0027)
  0x00, 0x6E, 0x00, 0x56, 0x01, // nV (U+006E U+0056)
  0x00, 0x6E, 0x00, 0x57, 0x01, // nW (U+006E U+0057)
  0x00, 0x6E, 0x00, 0x59, 0x01, // nY (U+006E U+0059)
  0x00, 0x6E, 0x00, 0xDD, 0x01, // nÝ (U+006E U+00DD)
  0x00, 0x6E, 0x01, 0x74, 0x01, // nŴ (U+006E U+0174)
  0x00, 0x6E, 0x01, 0x76, 0x01, // nŶ (U+006E U+0176)
  0x00, 0x6E, 0x01, 0x78, 0x01, // nŸ (U+006E U+0178)
  0x00, 0x6E, 0x20, 0x18, 0x01, // n‘ (U+006E U+2018)
  0x00, 0x6E, 0x20, 0x1C, 0x01, // n“ (U+006E U+201C)
  0x00, 0x6F, 0x00, 0x54, 0x01, // oT (U+006F U+0054)
  0x00, 0x6F, 0x00, 0x56, 0x01, // oV (U+006F U+0056)
  0x00, 0x6F, 0x00, 0x57, 0x01, // oW (U+006F U+0057)
  0x00, 0x6F, 0x00, 0x59, 0x01, // oY (U+006F U+0059)
  0x00, 0x6F, 0x00, 0xDD, 0x01, // oÝ (U+006F U+00DD)
  0x00, 0x6F, 0x01, 0x74, 0x01, // oŴ (U+006F U+0174)
  0x00, 0x6F, 0x01, 0x76, 0x01, // oŶ (U+006F U+0176)
  0x00, 0x6F, 0x01, 0x78, 0x01, // oŸ (U+006F U+0178)
  0x00, 0x70, 0x00, 0x54, 0x01, // pT (U+0070 U+0054)
  0x00, 0x70, 0x00, 0x56, 0x01, // pV (U+0070 U+0056)
  0x00, 0x70, 0x00, 0x57, 0x01, // pW (U+0070 U+0057)
  0x00, 0x70, 0x00, 0x59, 0x01, // pY (U+0070 U+0059)
  0x00, 0x70, 0x00, 0xDD, 0x01, // pÝ (U+0070 U+00DD)
  0x00, 0x70, 0x01, 0x74, 0x01, // pŴ (U+0070 U+0174)
  0x00, 0x70, 0x01, 0x76, 0x01, // pŶ (U+0070 U+0176)
  0x00, 0x70, 0x01, 0x78, 0x01, // pŸ (U+0070 U+0178)
  0x00, 0x71, 0x00, 0x57, 0x01, // qW (U+0071 U+0057)
  0x00, 0x71, 0x01, 0x74, 0x01, // qŴ (U+0071 U+0174)
  0x00, 0x72, 0x00, 0x2C, 0x04, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x04, // r. (U+0072 U+002E)
  0x00, 0x72, 0x00, 0x56, 0x01, // rV (U+0072 U+0056)
  0x00, 0x72, 0x00, 0x57, 0x01, // rW (U+0072 U+0057)
  0x00, 0x72, 0x00, 0x58, 0x01, // rX (U+0072 U+0058)
  0x00, 0x72, 0x00, 0x59, 0x01, // rY (U+0072 U+0059)
  0x00, 0x72, 0x00, 0xDD, 0x01, // rÝ (U+0072 U+00DD)
  0x00, 0x72, 0x01, 0x74, 0x01, // rŴ (U+0072 U+0174)
  0x00, 0x72, 0x01, 0x76, 0x01, // rŶ (U+0072 U+0176)
  0x00, 0x72, 0x01, 0x78, 0x01, // rŸ (U+0072 U+0178)
  0x00, 0x72, 0x20, 0x1A, 0x04, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x04, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x04, // r… (U+0072 U+2026)
  0x00, 0x73, 0x00, 0x56, 0x01, // sV (U+0073 U+0056)
  0x00, 0x73, 0x00, 0x57, 0x01, // sW (U+0073 U+0057)
  0x00, 0x73, 0x00, 0x59, 0x01, // sY (U+0073 U+0059)
  0x00, 0x73, 0x00, 0xDD, 0x01, // sÝ (U+0073 U+00DD)
  0x00, 0x73, 0x01, 0x74, 0x01, // sŴ (U+0073 U+0174)
  0x00, 0x73, 0x01, 0x76, 0x01, // sŶ (U+0073 U+0176)
  0x00, 0x73, 0x01, 0x78, 0x01, // sŸ (U+0073 U+0178)
  0x00, 0x76, 0x00, 0x2C, 0x01, // v, (U+0076 U+002C)
  0x00, 0x76, 0x00, 0x2E, 0x01, // v. (U+0076 U+002E)
  0x00, 0x76, 0x00, 0x56, 0x01, // vV (U+0076 U+0056)
  0x00, 0x76, 0x00, 0x59, 0x01, // vY (U+0076 U+0059)
  0x00, 0x76, 0x00, 0xDD, 0x01, // vÝ (U+0076 U+00DD)
  0x00, 0x76, 0x01, 0x76, 0x01, // vŶ (U+0076 U+0176)
  0x00, 0x76, 0x01, 0x78, 0x01, // vŸ (U+0076 U+0178)
  0x00, 0x76, 0x20, 0x1A, 0x01, // v‚ (U+0076 U+201A)
  0x00, 0x76, 0x20, 0x1E, 0x01, // v„ (U+0076 U+201E)
  0x00, 0x76, 0x20, 0x26, 0x01, // v… (U+0076 U+2026)
  0x00, 0x77, 0x00, 0x2C, 0x01, // w, (U+0077 U+002C)
  0x00, 0x77, 0x00, 0x2E, 0x01, // w. (U+0077 U+002E)
  0x00, 0x77, 0x00, 0x59, 0x01, // wY (U+0077 U+0059)
  0x00, 0x77, 0x00, 0xDD, 0x01, // wÝ (U+0077 U+00DD)
  0x00, 0x77, 0x01, 0x76, 0x01, // wŶ (U+0077 U+0176)
  0x00, 0x77, 0x01, 0x78, 0x01, // wŸ (U+0077 U+0178)
  0x00, 0x77, 0x20, 0x1A, 0x01, // w‚ (U+0077 U+201A)
  0x00, 0x77, 0x20, 0x1E, 0x01, // w„ (U+0077 U+201E)
  0x00, 0x77, 0x20, 0x26, 0x01, // w… (U+0077 U+2026)
  0x00, 0x79, 0x00, 0x2C, 0x02, // y, (U+0079 U+002C)
  0x00, 0x79, 0x00, 0x2E, 0x02, // y. (U+0079 U+002E)
  0x00, 0x79, 0x20, 0x1A, 0x02, // y‚ (U+0079 U+201A)
  0x00, 0x79, 0x20, 0x1E, 0x02, // y„ (U+0079 U+201E)
  0x00, 0x79, 0x20, 0x26, 0x02, // y… (U+0079 U+2026)
  0x00, 0x7A, 0x00, 0x56, 0x01, // zV (U+007A U+0056)
  0x00, 0x7A, 0x00, 0x57, 0x01, // zW (U+007A U+0057)
  0x00, 0x7A, 0x00, 0x59, 0x01, // zY (U+007A U+0059)
  0x00, 0x7A, 0x00, 0xDD, 0x01, // zÝ (U+007A U+00DD)
  0x00, 0x7A, 0x01, 0x74, 0x01, // zŴ (U+007A U+0174)
  0x00, 0x7A, 0x01, 0x76, 0x01, // zŶ (U+007A U+0176)
  0x00, 0x7A, 0x01, 0x78, 0x01, // zŸ (U+007A U+0178)
  0x00, 0xA1, 0x00, 0x56, 0x01, // ¡V (U+00A1 U+0056)
  0x00, 0xA1, 0x00, 0x59, 0x01, // ¡Y (U+00A1 U+0059)
  0x00, 0xA1, 0x00, 0xDD, 0x01, // ¡Ý (U+00A1 U+00DD)
  0x00, 0xA1, 0x01, 0x76, 0x01, // ¡Ŷ (U+00A1 U+0176)
  0x00, 0xA1, 0x01, 0x78, 0x01, // ¡Ÿ (U+00A1 U+0178)
  0x00, 0xBF, 0x00, 0x54, 0x01, // ¿T (U+00BF U+0054)
  0x00, 0xBF, 0x00, 0x56, 0x01, // ¿V (U+00BF U+0056)
  0x00, 0xBF, 0x00, 0x57, 0x01, // ¿W (U+00BF U+0057)
  0x00, 0xBF, 0x00, 0x59, 0x01, // ¿Y (U+00BF U+0059)
  0x00, 0xBF, 0x00, 0xDD, 0x01, // ¿Ý (U+00BF U+00DD)
  0x00, 0xBF, 0x01, 0x74, 0x01, // ¿Ŵ (U+00BF U+0174)
  0x00, 0xBF, 0x01, 0x76, 0x01, // ¿Ŷ (U+00BF U+0176)
  0x00, 0xBF, 0x01, 0x78, 0x01, // ¿Ÿ (U+00BF U+0178)
  0x00, 0xC0, 0x00, 0x22, 0x01, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x01, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x00, 0x2A, 0x01, // À* (U+00C0 U+002A)
  0x00, 0xC0, 0x00, 0x54, 0x01, // ÀT (U+00C0 U+0054)
  0x00, 0xC0, 0x00, 0x56, 0x01, // ÀV (U+00C0 U+0056)
  0x00, 0xC0, 0x00, 0x57, 0x01, // ÀW (U+00C0 U+0057)
  0x00, 0xC0, 0x00, 0x59, 0x01, // ÀY (U+00C0 U+0059)
  0x00, 0xC0, 0x00, 0x76, 0x01, // Àv (U+00C0 U+0076)
  0x00, 0xC0, 0x00, 0x77, 0x01, // Àw (U+00C0 U+0077)
  0x00, 0xC0, 0x00, 0x79, 0x01, // Ày (U+00C0 U+0079)
  0x00, 0xC0, 0x00, 0xA9, 0x01, // À© (U+00C0 U+00A9)
  0x00, 0xC0, 0x00, 0xAE, 0x01, // À® (U+00C0 U+00AE)
  0x00, 0xC0, 0x00, 0xDD, 0x01, // ÀÝ (U+00C0 U+00DD)
  0x00, 0xC0, 0x00, 0xFD, 0x01, // Àý (U+00C0 U+00FD)
  0x00, 0xC0, 0x00, 0xFF, 0x01, // Àÿ (U+00C0 U+00FF)
  0x00, 0xC0, 0x01, 0x49, 0x01, // Àŉ (U+00C0 U+0149)
  0x00, 0xC0, 0x01, 0x74, 0x01, // ÀŴ (U+00C0 U+0174)
  0x00, 0xC0, 0x01, 0x75, 0x01, // Àŵ (U+00C0 U+0175)
  0x00, 0xC0, 0x01, 0x76, 0x01, // ÀŶ (U+00C0 U+0176)
  0x00, 0xC0, 0x01, 0x77, 0x01, // Àŷ (U+00C0 U+0177)
  0x00, 0xC0, 0x01, 0x78, 0x01, // ÀŸ (U+00C0 U+0178)
  0x00, 0xC0, 0x20, 0x18, 0x02, // À‘ (U+00C0 U+2018)
  0x00, 0xC0, 0x20, 0x19, 0x01, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1C, 0x02, // À“ (U+00C0 U+201C)
  0x00, 0xC0, 0x20, 0x1D, 0x01, // À” (U+00C0 U+201D)
  0x00, 0xC0, 0x21, 0x22, 0x01, // À™ (U+00C0 U+2122)
  0x00, 0xC1, 0x00, 0x22, 0x01, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x01, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x00, 0x2A, 0x01, // Á* (U+00C1 U+002A)
  0x00, 0xC1, 0x00, 0x54, 0x01, // ÁT (U+00C1 U+0054)
  0x00, 0xC1, 0x00, 0x56, 0x01, // ÁV (U+00C1 U+0056)
  0x00, 0xC1, 0x00, 0x57, 0x01, // ÁW (U+00C1 U+0057)
  0x00, 0xC1, 0x00, 0x59, 0x01, // ÁY (U+00C1 U+0059)
  0x00, 0xC1, 0x00, 0x76, 0x01, // Áv (U+00C1 U+0076)
  0x00, 0xC1, 0x00, 0x77, 0x01, // Áw (U+00C1 U+0077)
  0x00, 0xC1, 0x00, 0x79, 0x01, // Áy (U+00C1 U+0079)
  0x00, 0xC1, 0x00, 0xA9, 0x01, // Á© (U+00C1 U+00A9)
  0x00, 0xC1, 0x00, 0xAE, 0x01, // Á® (U+00C1 U+00AE)
  0x00, 0xC1, 0x00, 0xDD, 0x01, // ÁÝ (U+00C1 U+00DD)
  0x00, 0xC1, 0x00, 0xFD, 0x01, // Áý (U+00C1 U+00FD)
  0x00, 0xC1, 0x00, 0xFF, 0x01, // Áÿ (U+00C1 U+00FF)
  0x00, 0xC1, 0x01, 0x49, 0x01, // Áŉ (U+00C1 U+0149)
  0x00, 0xC1, 0x01, 0x74, 0x01, // ÁŴ (U+00C1 U+0174)
  0x00, 0xC1, 0x01, 0x75, 0x01, // Áŵ (U+00C1 U+0175)
  0x00, 0xC1, 0x01, 0x76, 0x01, // ÁŶ (U+00C1 U+0176)
  0x00, 0xC1, 0x01, 0x77, 0x01, // Áŷ (U+00C1 U+0177)
  0x00, 0xC1, 0x01, 0x78, 0x01, // ÁŸ (U+00C1 U+0178)
  0x00, 0xC1, 0x20, 0x18, 0x02, // Á‘ (U+00C1 U+2018)
  0x00, 0xC1, 0x20, 0x19, 0x01, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1C, 0x02, // Á“ (U+00C1 U+201C)
  0x00, 0xC1, 0x20, 0x1D, 0x01, // Á” (U+00C1 U+201D)
  0x00, 0xC1, 0x21, 0x22, 0x01, // Á™ (U+00C1 U+2122)
  0x00, 0xC2, 0x00, 0x22, 0x01, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x01, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x00, 0x2A, 0x01, // Â* (U+00C2 U+002A)
  0x00, 0xC2, 0x00, 0x54, 0x01, // ÂT (U+00C2 U+0054)
  0x00, 0xC2, 0x00, 0x56, 0x01, // ÂV (U+00C2 U+0056)
  0x00, 0xC2, 0x00, 0x57, 0x01, // ÂW (U+00C2 U+0057)
  0x00, 0xC2, 0x00, 0x59, 0x01, // ÂY (U+00C2 U+0059)
  0x00, 0xC2, 0x00, 0x76, 0x01, // Âv (U+00C2 U+0076)
  0x00, 0xC2, 0x00, 0x77, 0x01, // Âw (U+00C2 U+0077)
  0x00, 0xC2, 0x00, 0x79, 0x01, // Ây (U+00C2 U+0079)
  0x00, 0xC2, 0x00, 0xA9, 0x01, // Â© (U+00C2 U+00A9)
  0x00, 0xC2, 0x00, 0xAE, 0x01, // Â® (U+00C2 U+00AE)
  0x00, 0xC2, 0x00, 0xDD, 0x01, // ÂÝ (U+00C2 U+00DD)
  0x00, 0xC2, 0x00, 0xFD, 0x01, // Âý (U+00C2 U+00FD)
  0x00, 0xC2, 0x00, 0xFF, 0x01, // Âÿ (U+00C2 U+00FF)
  0x00, 0xC2, 0x01, 0x49, 0x01, // Âŉ (U+00C2 U+0149)
  0x00, 0xC2, 0x01, 0x74, 0x01, // ÂŴ (U+00C2 U+0174)
  0x00, 0xC2, 0x01, 0x75, 0x01, // Âŵ (U+00C2 U+0175)
  0x00, 0xC2, 0x01, 0x76, 0x01, // ÂŶ (U+00C2 U+0176)
  0x00, 0xC2, 0x01, 0x77, 0x01, // Âŷ (U+00C2 U+0177)
  0x00, 0xC2, 0x01, 0x78, 0x01, // ÂŸ (U+00C2 U+0178)
  0x00, 0xC2, 0x20, 0x18, 0x02, // Â‘ (U+00C2 U+2018)
  0x00, 0xC2, 0x20, 0x19, 0x01, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1C, 0x02, // Â“ (U+00C2 U+201C)
  0x00, 0xC2, 0x20, 0x1D, 0x01, // Â” (U+00C2 U+201D)
  0x00, 0xC2, 0x21, 0x22, 0x01, // Â™ (U+00C2 U+2122)
  0x00, 0xC3, 0x00, 0x22, 0x01, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x01, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x00, 0x2A, 0x01, // Ã* (U+00C3 U+002A)
  0x00, 0xC3, 0x00, 0x54, 0x01, // ÃT (U+00C3 U+0054)
  0x00, 0xC3, 0x00, 0x56, 0x01, // ÃV (U+00C3 U+0056)
  0x00, 0xC3, 0x00, 0x57, 0x01, // ÃW (U+00C3 U+0057)
  0x00, 0xC3, 0x00, 0x59, 0x01, // ÃY (U+00C3 U+0059)
  0x00, 0xC3, 0x00, 0x76, 0x01, // Ãv (U+00C3 U+0076)
  0x00, 0xC3, 0x00, 0x77, 0x01, // Ãw (U+00C3 U+0077)
  0x00, 0xC3, 0x00, 0x79, 0x01, // Ãy (U+00C3 U+0079)
  0x00, 0xC3, 0x00, 0xA9, 0x01, // Ã© (U+00C3 U+00A9)
  0x00, 0xC3, 0x00, 0xAE, 0x01, // Ã® (U+00C3 U+00AE)
  0x00, 0xC3, 0x00, 0xDD, 0x01, // ÃÝ (U+00C3 U+00DD)
  0x00, 0xC3, 0x00, 0xFD, 0x01, // Ãý (U+00C3 U+00FD)
  0x00, 0xC3, 0x00, 0xFF, 0x01, // Ãÿ (U+00C3 U+00FF)
  0x00, 0xC3, 0x01, 0x49, 0x01, // Ãŉ (U+00C3 U+0149)
  0x00, 0xC3, 0x01, 0x74, 0x01, // ÃŴ (U+00C3 U+0174)
  0x00, 0xC3, 0x01, 0x75, 0x01, // Ãŵ (U+00C3 U+0175)
  0x00, 0xC3, 0x01, 0x76, 0x01, // ÃŶ (U+00C3 U+0176)
  0x00, 0xC3, 0x01, 0x77, 0x01, // Ãŷ (U+00C3 U+0177)
  0x00, 0xC3, 0x01, 0x78, 0x01, // ÃŸ (U+00C3 U+0178)
  0x00, 0xC3, 0x20, 0x18, 0x02, // Ã‘ (U+00C3 U+2018)
  0x00, 0xC3, 0x20, 0x19, 0x01, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1C, 0x02, // Ã“ (U+00C3 U+201C)
  0x00, 0xC3, 0x20, 0x1D, 0x01, // Ã” (U+00C3 U+201D)
  0x00, 0xC3, 0x21, 0x22, 0x01, // Ã™ (U+00C3 U+2122)
  0x00, 0xC4, 0x00, 0x22, 0x01, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x01, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x00, 0x2A, 0x01, // Ä* (U+00C4 U+002A)
  0x00, 0xC4, 0x00, 0x54, 0x01, // ÄT (U+00C4 U+0054)
  0x00, 0xC4, 0x00, 0x56, 0x01, // ÄV (U+00C4 U+0056)
  0x00, 0xC4, 0x00, 0x57, 0x01, // ÄW (U+00C4 U+0057)
  0x00, 0xC4, 0x00, 0x59, 0x01, // ÄY (U+00C4 U+0059)
  0x00, 0xC4, 0x00, 0x76, 0x01, // Äv (U+00C4 U+0076)
  0x00, 0xC4, 0x00, 0x77, 0x01, // Äw (U+00C4 U+0077)
  0x00, 0xC4, 0x00, 0x79, 0x01, // Äy (U+00C4 U+0079)
  0x00, 0xC4, 0x00, 0xA9, 0x01, // Ä© (U+00C4 U+00A9)
  0x00, 0xC4, 0x00, 0xAE, 0x01, // Ä® (U+00C4 U+00AE)
  0x00, 0xC4, 0x00, 0xDD, 0x01, // ÄÝ (U+00C4 U+00DD)
  0x00, 0xC4, 0x00, 0xFD, 0x01, // Äý (U+00C4 U+00FD)
  0x00, 0xC4, 0x00, 0xFF, 0x01, // Äÿ (U+00C4 U+00FF)
  0x00, 0xC4, 0x01, 0x49, 0x01, // Äŉ (U+00C4 U+0149)
  0x00, 0xC4, 0x01, 0x74, 0x01, // ÄŴ (U+00C4 U+0174)
  0x00, 0xC4, 0x01, 0x75, 0x01, // Äŵ (U+00C4 U+0175)
  0x00, 0xC4, 0x01, 0x76, 0x01, // ÄŶ (U+00C4 U+0176)
  0x00, 0xC4, 0x01, 0x77, 0x01, // Äŷ (U+00C4 U+0177)
  0x00, 0xC4, 0x01, 0x78, 0x01, // ÄŸ (U+00C4 U+0178)
  0x00, 0xC4, 0x20, 0x18, 0x02, // Ä‘ (U+00C4 U+2018)
  0x00, 0xC4, 0x20, 0x19, 0x01, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1C, 0x02, // Ä“ (U+00C4 U+201C)
  0x00, 0xC4, 0x20, 0x1D, 0x01, // Ä” (U+00C4 U+201D)
  0x00, 0xC4, 0x21, 0x22, 0x01, // Ä™ (U+00C4 U+2122)
  0x00, 0xC5, 0x00, 0x22, 0x01, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x01, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x00, 0x2A, 0x01, // Å* (U+00C5 U+002A)
  0x00, 0xC5, 0x00, 0x54, 0x01, // ÅT (U+00C5 U+0054)
  0x00, 0xC5, 0x00, 0x56, 0x01, // ÅV (U+00C5 U+0056)
  0x00, 0xC5, 0x00, 0x57, 0x01, // ÅW (U+00C5 U+0057)
  0x00, 0xC5, 0x00, 0x59, 0x01, // ÅY (U+00C5 U+0059)
  0x00, 0xC5, 0x00, 0x76, 0x01, // Åv (U+00C5 U+0076)
  0x00, 0xC5, 0x00, 0x77, 0x01, // Åw (U+00C5 U+0077)
  0x00, 0xC5, 0x00, 0x79, 0x01, // Åy (U+00C5 U+0079)
  0x00, 0xC5, 0x00, 0xA9, 0x01, // Å© (U+00C5 U+00A9)
  0x00, 0xC5, 0x00, 0xAE, 0x01, // Å® (U+00C5 U+00AE)
  0x00, 0xC5, 0x00, 0xDD, 0x01, // ÅÝ (U+00C5 U+00DD)
  0x00, 0xC5, 0x00, 0xFD, 0x01, // Åý (U+00C5 U+00FD)
  0x00, 0xC5, 0x00, 0xFF, 0x01, // Åÿ (U+00C5 U+00FF)
  0x00, 0xC5, 0x01, 0x49, 0x01, // Åŉ (U+00C5 U+0149)
  0x00, 0xC5, 0x01, 0x74, 0x01, // ÅŴ (U+00C5 U+0174)
  0x00, 0xC5, 0x01, 0x75, 0x01, // Åŵ (U+00C5 U+0175)
  0x00, 0xC5, 0x01, 0x76, 0x01, // ÅŶ (U+00C5 U+0176)
  0x00, 0xC5, 0x01, 0x77, 0x01, // Åŷ (U+00C5 U+0177)
  0x00, 0xC5, 0x01, 0x78, 0x01, // ÅŸ (U+00C5 U+0178)
  0x00, 0xC5, 0x20, 0x18, 0x02, // Å‘ (U+00C5 U+2018)
  0x00, 0xC5, 0x20, 0x19, 0x01, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1C, 0x02, // Å“ (U+00C5 U+201C)
  0x00, 0xC5, 0x20, 0x1D, 0x01, // Å” (U+00C5 U+201D)
  0x00, 0xC5, 0x21, 0x22, 0x01, // Å™ (U+00C5 U+2122)
  0x00, 0xD0, 0x00, 0x22, 0x01, // Ð" (U+00D0 U+0022)
  0x00, 0xD0, 0x00, 0x27, 0x01, // Ð' (U+00D0 U+0027)
  0x00, 0xD0, 0x00, 0x59, 0x01, // ÐY (U+00D0 U+0059)
  0x00, 0xD0, 0x00, 0xC6, 0x01, // ÐÆ (U+00D0 U+00C6)
  0x00, 0xD0, 0x00, 0xDD, 0x01, // ÐÝ (U+00D0 U+00DD)
  0x00, 0xD0, 0x01, 0x76, 0x01, // ÐŶ (U+00D0 U+0176)
  0x00, 0xD0, 0x01, 0x78, 0x01, // ÐŸ (U+00D0 U+0178)
  0x00, 0xD2, 0x00, 0x22, 0x01, // Ò" (U+00D2 U+0022)
  0x00, 0xD2, 0x00, 0x27, 0x01, // Ò' (U+00D2 U+0027)
  0x00, 0xD2, 0x00, 0x59, 0x01, // ÒY (U+00D2 U+0059)
  0x00, 0xD2, 0x00, 0xC6, 0x01, // ÒÆ (U+00D2 U+00C6)
  0x00, 0xD2, 0x00, 0xDD, 0x01, // ÒÝ (U+00D2 U+00DD)
  0x00, 0xD2, 0x01, 0x76, 0x01, // ÒŶ (U+00D2 U+0176)
  0x00, 0xD2, 0x01, 0x78, 0x01, // ÒŸ (U+00D2 U+0178)
  0x00, 0xD3, 0x00, 0x22, 0x01, // Ó" (U+00D3 U+0022)
  0x00, 0xD3, 0x00, 0x27, 0x01, // Ó' (U+00D3 U+0027)
  0x00, 0xD3, 0x00, 0x59, 0x01, // ÓY (U+00D3 U+0059)
  0x00, 0xD3, 0x00, 0xC6, 0x01, // ÓÆ (U+00D3 U+00C6)
  0x00, 0xD3, 0x00, 0xDD, 0x01, // ÓÝ (U+00D3 U+00DD)
  0x00, 0xD3, 0x01, 0x76, 0x01, // ÓŶ (U+00D3 U+0176)
  0x00, 0xD3, 0x01, 0x78, 0x01, // ÓŸ (U+00D3 U+0178)
  0x00, 0xD4, 0x00, 0x22, 0x01, // Ô" (U+00D4 U+0022)
  0x00, 0xD4, 0x00, 0x27, 0x01, // Ô' (U+00D4 U+0027)
  0x00, 0xD4, 0x00, 0x59, 0x01, // ÔY (U+00D4 U+0059)
  0x00, 0xD4, 0x00, 0xC6, 0x01, // ÔÆ (U+00D4 U+00C6)
  0x00, 0xD4, 0x00, 0xDD, 0x01, // ÔÝ (U+00D4 U+00DD)
  0x00, 0xD4, 0x01, 0x76, 0x01, // ÔŶ (U+00D4 U+0176)
  0x00, 0xD4, 0x01, 0x78, 0x01, // ÔŸ (U+00D4 U+0178)
  0x00, 0xD5, 0x00, 0x22, 0x01, // Õ" (U+00D5 U+0022)
  0x00, 0xD5, 0x00, 0x27, 0x01, // Õ' (U+00D5 U+0027)
  0x00, 0xD5, 0x00, 0x59, 0x01, // ÕY (U+00D5 U+0059)
  0x00, 0xD5, 0x00, 0xC6, 0x01, // ÕÆ (U+00D5 U+00C6)
  0x00, 0xD5, 0x00, 0xDD, 0x01, // ÕÝ (U+00D5 U+00DD)
  0x00, 0xD5, 0x01, 0x76, 0x01, // ÕŶ (U+00D5 U+0176)
  0x00, 0xD5, 0x01, 0x78, 0x01, // ÕŸ (U+00D5 U+0178)
  0x00, 0xD6, 0x00, 0x22, 0x01, // Ö" (U+00D6 U+0022)
  0x00, 0xD6, 0x00, 0x27, 0x01, // Ö' (U+00D6 U+0027)
  0x00, 0xD6, 0x00, 0x59, 0x01, // ÖY (U+00D6 U+0059)
  0x00, 0xD6, 0x00, 0xC6, 0x01, // ÖÆ (U+00D6 U+00C6)
  0x00, 0xD6, 0x00, 0xDD, 0x01, // ÖÝ (U+00D6 U+00DD)
  0x00, 0xD6, 0x01, 0x76, 0x01, // ÖŶ (U+00D6 U+0176)
  0x00, 0xD6, 0x01, 0x78, 0x01, // ÖŸ (U+00D6 U+0178)
  0x00, 0xD8, 0x00, 0x22, 0x01, // Ø" (U+00D8 U+0022)
  0x00, 0xD8, 0x00, 0x27, 0x01, // Ø' (U+00D8 U+0027)
  0x00, 0xD8, 0x00, 0x59, 0x01, // ØY (U+00D8 U+0059)
  0x00, 0xD8, 0x00, 0xC6, 0x01, // ØÆ (U+00D8 U+00C6)
  0x00, 0xD8, 0x00, 0xDD, 0x01, // ØÝ (U+00D8 U+00DD)
  0x00, 0xD8, 0x01, 0x76, 0x01, // ØŶ (U+00D8 U+0176)
  0x00, 0xD8, 0x01, 0x78, 0x01, // ØŸ (U+00D8 U+0178)
  0x00, 0xDD, 0x00, 0x26, 0x01, // Ý& (U+00DD U+0026)
  0x00, 0xDD, 0x00, 0x2C, 0x01, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x01, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x00, 0x41, 0x01, // ÝA (U+00DD U+0041)
  0x00, 0xDD, 0x00, 0x43, 0x01, // ÝC (U+00DD U+0043)
  0x00, 0xDD, 0x00, 0x47, 0x01, // ÝG (U+00DD U+0047)
  0x00, 0xDD, 0x00, 0x4F, 0x01, // ÝO (U+00DD U+004F)
  0x00, 0xDD, 0x00, 0x51, 0x01, // ÝQ (U+00DD U+0051)
  0x00, 0xDD, 0x00, 0x61, 0x01, // Ýa (U+00DD U+0061)
  0x00, 0xDD, 0x00, 0x63, 0x01, // Ýc (U+00DD U+0063)
  0x00, 0xDD, 0x00, 0x64, 0x01, // Ýd (U+00DD U+0064)
  0x00, 0xDD, 0x00, 0x65, 0x01, // Ýe (U+00DD U+0065)
  0x00, 0xDD, 0x00, 0x67, 0x01, // Ýg (U+00DD U+0067)
  0x00, 0xDD, 0x00, 0x6F, 0x01, // Ýo (U+00DD U+006F)
  0x00, 0xDD, 0x00, 0x71, 0x01, // Ýq (U+00DD U+0071)
  0x00, 0xDD, 0x00, 0x73, 0x01, // Ýs (U+00DD U+0073)
  0x00, 0xDD, 0x00, 0xC0, 0x01, // ÝÀ (U+00DD U+00C0)
  0x00, 0xDD, 0x00, 0xC1, 0x01, // ÝÁ (U+00DD U+00C1)
  0x00, 0xDD, 0x00, 0xC2, 0x01, // ÝÂ (U+00DD U+00C2)
  0x00, 0xDD, 0x00, 0xC3, 0x01, // ÝÃ (U+00DD U+00C3)
  0x00, 0xDD, 0x00, 0xC4, 0x01, // ÝÄ (U+00DD U+00C4)
  0x00, 0xDD, 0x00, 0xC5, 0x01, // ÝÅ (U+00DD U+00C5)
  0x00, 0xDD, 0x00, 0xC6, 0x02, // ÝÆ (U+00DD U+00C6)
  0x00, 0xDD, 0x00, 0xC7, 0x01, // ÝÇ (U+00DD U+00C7)
  0x00, 0xDD, 0x00, 0xD2, 0x01, // ÝÒ (U+00DD U+00D2)
  0x00, 0xDD, 0x00, 0xD3, 0x01, // ÝÓ (U+00DD U+00D3)
  0x00, 0xDD, 0x00, 0xD4, 0x01, // ÝÔ (U+00DD U+00D4)
  0x00, 0xDD, 0x00, 0xD5, 0x01, // ÝÕ (U+00DD U+00D5)
  0x00, 0xDD, 0x00, 0xD6, 0x01, // ÝÖ (U+00DD U+00D6)
  0x00, 0xDD, 0x00, 0xD8, 0x01, // ÝØ (U+00DD U+00D8)
  0x00, 0xDD, 0x00, 0xE0, 0x01, // Ýà (U+00DD U+00E0)
  0x00, 0xDD, 0x00, 0xE1, 0x01, // Ýá (U+00DD U+00E1)
  0x00, 0xDD, 0x00, 0xE2, 0x01, // Ýâ (U+00DD U+00E2)
  0x00, 0xDD, 0x00, 0xE3, 0x01, // Ýã (U+00DD U+00E3)
  0x00, 0xDD, 0x00, 0xE4, 0x01, // Ýä (U+00DD U+00E4)
  0x00, 0xDD, 0x00, 0xE5, 0x01, // Ýå (U+00DD U+00E5)
  0x00, 0xDD, 0x00, 0xE6, 0x01, // Ýæ (U+00DD U+00E6)
  0x00, 0xDD, 0x00, 0xE7, 0x01, // Ýç (U+00DD U+00E7)
  0x00, 0xDD, 0x00, 0xE8, 0x01, // Ýè (U+00DD U+00E8)
  0x00, 0xDD, 0x00, 0xE9, 0x01, // Ýé (U+00DD U+00E9)
  0x00, 0xDD, 0x00, 0xEA, 0x01, // Ýê (U+00DD U+00EA)
  0x00, 0xDD, 0x00, 0xEB, 0x01, // Ýë (U+00DD U+00EB)
  0x00, 0xDD, 0x00, 0xF0, 0x01, // Ýð (U+00DD U+00F0)
  0x00, 0xDD, 0x00, 0xF2, 0x01, // Ýò (U+00DD U+00F2)
  0x00, 0xDD, 0x00, 0xF3, 0x01, // Ýó (U+00DD U+00F3)
  0x00, 0xDD, 0x00, 0xF4, 0x01, // Ýô (U+00DD U+00F4)
  0x00, 0xDD, 0x00, 0xF5, 0x01, // Ýõ (U+00DD U+00F5)
  0x00, 0xDD, 0x00, 0xF6, 0x01, // Ýö (U+00DD U+00F6)
  0x00, 0xDD, 0x00, 0xF8, 0x01, // Ýø (U+00DD U+00F8)
  0x00, 0xDD, 0x01, 0x00, 0x01, // ÝĀ (U+00DD U+0100)
  0x00, 0xDD, 0x01, 0x01, 0x01, // Ýā (U+00DD U+0101)
  0x00, 0xDD, 0x01, 0x02, 0x01, // ÝĂ (U+00DD U+0102)
  0x00, 0xDD, 0x01, 0x03, 0x01, // Ýă (U+00DD U+0103)
  0x00, 0xDD, 0x01, 0x04, 0x01, // ÝĄ (U+00DD U+0104)
  0x00, 0xDD, 0x01, 0x05, 0x01, // Ýą (U+00DD U+0105)
  0x00, 0xDD, 0x01, 0x06, 0x01, // ÝĆ (U+00DD U+0106)
  0x00, 0xDD, 0x01, 0x07, 0x01, // Ýć (U+00DD U+0107)
  0x00, 0xDD, 0x01, 0x08, 0x01, // ÝĈ (U+00DD U+0108)
  0x00, 0xDD, 0x01, 0x09, 0x01, // Ýĉ (U+00DD U+0109)
  0x00, 0xDD, 0x01, 0x0A, 0x01, // ÝĊ (U+00DD U+010A)
  0x00, 0xDD, 0x01, 0x0B, 0x01, // Ýċ (U+00DD U+010B)
  0x00, 0xDD, 0x01, 0x0C, 0x01, // ÝČ (U+00DD U+010C)
  0x00, 0xDD, 0x01, 0x0D, 0x01, // Ýč (U+00DD U+010D)
  0x00, 0xDD, 0x01, 0x0F, 0x01, // Ýď (U+00DD U+010F)
  0x00, 0xDD, 0x01, 0x11, 0x01, // Ýđ (U+00DD U+0111)
  0x00, 0xDD, 0x01, 0x13, 0x01, // Ýē (U+00DD U+0113)
  0x00, 0xDD, 0x01, 0x15, 0x01, // Ýĕ (U+00DD U+0115)
  0x00, 0xDD, 0x01, 0x17, 0x01, // Ýė (U+00DD U+0117)
  0x00, 0xDD, 0x01, 0x19, 0x01, // Ýę (U+00DD U+0119)
  0x00, 0xDD, 0x01, 0x1B, 0x01, // Ýě (U+00DD U+011B)
  0x00, 0xDD, 0x01, 0x1C, 0x01, // ÝĜ (U+00DD U+011C)
  0x00, 0xDD, 0x01, 0x1D, 0x01, // Ýĝ (U+00DD U+011D)
  0x00, 0xDD, 0x01, 0x1E, 0x01, // ÝĞ (U+00DD U+011E)
  0x00, 0xDD, 0x01, 0x1F, 0x01, // Ýğ (U+00DD U+011F)
  0x00, 0xDD, 0x01, 0x20, 0x01, // ÝĠ (U+00DD U+0120)
  0x00, 0xDD, 0x01, 0x21, 0x01, // Ýġ (U+00DD U+0121)
  0x00, 0xDD, 0x01, 0x22, 0x01, // ÝĢ (U+00DD U+0122)
  0x00, 0xDD, 0x01, 0x23, 0x01, // Ýģ (U+00DD U+0123)
  0x00, 0xDD, 0x01, 0x4C, 0x01, // ÝŌ (U+00DD U+014C)
  0x00, 0xDD, 0x01, 0x4D, 0x01, // Ýō (U+00DD U+014D)
  0x00, 0xDD, 0x01, 0x4E, 0x01, // ÝŎ (U+00DD U+014E)
  0x00, 0xDD, 0x01, 0x4F, 0x01, // Ýŏ (U+00DD U+014F)
  0x00, 0xDD, 0x01, 0x50, 0x01, // ÝŐ (U+00DD U+0150)
  0x00, 0xDD, 0x01, 0x51, 0x01, // Ýő (U+00DD U+0151)
  0x00, 0xDD, 0x01, 0x52, 0x01, // ÝŒ (U+00DD U+0152)
  0x00, 0xDD, 0x01, 0x53, 0x01, // Ýœ (U+00DD U+0153)
  0x00, 0xDD, 0x01, 0x5B, 0x01, // Ýś (U+00DD U+015B)
  0x00, 0xDD, 0x01, 0x5D, 0x01, // Ýŝ (U+00DD U+015D)
  0x00, 0xDD, 0x01, 0x5F, 0x01, // Ýş (U+00DD U+015F)
  0x00, 0xDD, 0x01, 0x61, 0x01, // Ýš (U+00DD U+0161)
  0x00, 0xDD, 0x20, 0x1A, 0x01, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x01, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x01, // Ý… (U+00DD U+2026)
  0x00, 0xDE, 0x00, 0x22, 0x01, // Þ" (U+00DE U+0022)
  0x00, 0xDE, 0x00, 0x27, 0x01, // Þ' (U+00DE U+0027)
  0x00, 0xDE, 0x00, 0x59, 0x01, // ÞY (U+00DE U+0059)
  0x00, 0xDE, 0x00, 0xC6, 0x01, // ÞÆ (U+00DE U+00C6)
  0x00, 0xDE, 0x00, 0xDD, 0x01, // ÞÝ (U+00DE U+00DD)
  0x00, 0xDE, 0x01, 0x76, 0x01, // ÞŶ (U+00DE U+0176)
  0x00, 0xDE, 0x01, 0x78, 0x01, // ÞŸ (U+00DE U+0178)
  0x00, 0xDF, 0x00, 0x56, 0x01, // ßV (U+00DF U+0056)
  0x00, 0xDF, 0x00, 0x57, 0x01, // ßW (U+00DF U+0057)
  0x00, 0xDF, 0x00, 0x59, 0x01, // ßY (U+00DF U+0059)
  0x00, 0xDF, 0x00, 0xDD, 0x01, // ßÝ (U+00DF U+00DD)
  0x00, 0xDF, 0x01, 0x74, 0x01, // ßŴ (U+00DF U+0174)
  0x00, 0xDF, 0x01, 0x76, 0x01, // ßŶ (U+00DF U+0176)
  0x00, 0xDF, 0x01, 0x78, 0x01, // ßŸ (U+00DF U+0178)
  0x00, 0xE0, 0x00, 0x22, 0x01, // à" (U+00E0 U+0022)
  0x00, 0xE0, 0x00, 0x27, 0x01, // à' (U+00E0 U+0027)
  0x00, 0xE0, 0x00, 0x56, 0x01, // àV (U+00E0 U+0056)
  0x00, 0xE0, 0x00, 0x57, 0x01, // àW (U+00E0 U+0057)
  0x00, 0xE0, 0x00, 0x59, 0x01, // àY (U+00E0 U+0059)
  0x00, 0xE0, 0x00, 0xDD, 0x01, // àÝ (U+00E0 U+00DD)
  0x00, 0xE0, 0x01, 0x74, 0x01, // àŴ (U+00E0 U+0174)
  0x00, 0xE0, 0x01, 0x76, 0x01, // àŶ (U+00E0 U+0176)
  0x00, 0xE0, 0x01, 0x78, 0x01, // àŸ (U+00E0 U+0178)
  0x00, 0xE0, 0x20, 0x18, 0x01, // à‘ (U+00E0 U+2018)
  0x00, 0xE0, 0x20, 0x1C, 0x01, // à“ (U+00E0 U+201C)
  0x00, 0xE1, 0x00, 0x22, 0x01, // á" (U+00E1 U+0022)
  0x00, 0xE1, 0x00, 0x27, 0x01, // á' (U+00E1 U+0027)
  0x00, 0xE1, 0x00, 0x56, 0x01, // áV (U+00E1 U+0056)
  0x00, 0xE1, 0x00, 0x57, 0x01, // áW (U+00E1 U+0057)
  0x00, 0xE1, 0x00, 0x59, 0x01, // áY (U+00E1 U+0059)
  0x00, 0xE1, 0x00, 0xDD, 0x01, // áÝ (U+00E1 U+00DD)
  0x00, 0xE1, 0x01, 0x74, 0x01, // áŴ (U+00E1 U+0174)
  0x00, 0xE1, 0x01, 0x76, 0x01, // áŶ (U+00E1 U+0176)
  0x00, 0xE1, 0x01, 0x78, 0x01, // áŸ (U+00E1 U+0178)
  0x00, 0xE1, 0x20, 0x18, 0x01, // á‘ (U+00E1 U+2018)
  0x00, 0xE1, 0x20, 0x1C, 0x01, // á“ (U+00E1 U+201C)
  0x00, 0xE2, 0x00, 0x22, 0x01, // â" (U+00E2 U+0022)
  0x00, 0xE2, 0x00, 0x27, 0x01, // â' (U+00E2 U+0027)
  0x00, 0xE2, 0x00, 0x56, 0x01, // âV (U+00E2 U+0056)
  0x00, 0xE2, 0x00, 0x57, 0x01, // âW (U+00E2 U+0057)
  0x00, 0xE2, 0x00, 0x59, 0x01, // âY (U+00E2 U+0059)
  0x00, 0xE2, 0x00, 0xDD, 0x01, // âÝ (U+00E2 U+00DD)
  0x00, 0xE2, 0x01, 0x74, 0x01, // âŴ (U+00E2 U+0174)
  0x00, 0xE2, 0x01, 0x76, 0x01, // âŶ (U+00E2 U+0176)
  0x00, 0xE2, 0x01, 0x78, 0x01, // âŸ (U+00E2 U+0178)
  0x00, 0xE2, 0x20, 0x18, 0x01, // â‘ (U+00E2 U+2018)
  0x00, 0xE2, 0x20, 0x1C, 0x01, // â“ (U+00E2 U+201C)
  0x00, 0xE3, 0x00, 0x22, 0x01, // ã" (U+00E3 U+0022)
  0x00, 0xE3, 0x00, 0x27, 0x01, // ã' (U+00E3 U+0027)
  0x00, 0xE3, 0x00, 0x56, 0x01, // ãV (U+00E3 U+0056)
  0x00, 0xE3, 0x00, 0x57, 0x01, // ãW (U+00E3 U+0057)
  0x00, 0xE3, 0x00, 0x59, 0x01, // ãY (U+00E3 U+0059)
  0x00, 0xE3, 0x00, 0xDD, 0x01, // ãÝ (U+00E3 U+00DD)
  0x00, 0xE3, 0x01, 0x74, 0x01, // ãŴ (U+00E3 U+0174)
  0x00, 0xE3, 0x01, 0x76, 0x01, // ãŶ (U+00E3 U+0176)
  0x00, 0xE3, 0x01, 0x78, 0x01, // ãŸ (U+00E3 U+0178)
  0x00, 0xE3, 0x20, 0x18, 0x01, // ã‘ (U+00E3 U+2018)
  0x00, 0xE3, 0x20, 0x1C, 0x01, // ã“ (U+00E3 U+201C)
  0x00, 0xE4, 0x00, 0x22, 0x01, // ä" (U+00E4 U+0022)
  0x00, 0xE4, 0x00, 0x27, 0x01, // ä' (U+00E4 U+0027)
  0x00, 0xE4, 0x00, 0x56, 0x01, // äV (U+00E4 U+0056)
  0x00, 0xE4, 0x00, 0x57, 0x01, // äW (U+00E4 U+0057)
  0x00, 0xE4, 0x00, 0x59, 0x01, // äY (U+00E4 U+0059)
  0x00, 0xE4, 0x00, 0xDD, 0x01, // äÝ (U+00E4 U+00DD)
  0x00, 0xE4, 0x01, 0x74, 0x01, // äŴ (U+00E4 U+0174)
  0x00, 0xE4, 0x01, 0x76, 0x01, // äŶ (U+00E4 U+0176)
  0x00, 0xE4, 0x01, 0x78, 0x01, // äŸ (U+00E4 U+0178)
  0x00, 0xE4, 0x20, 0x18, 0x01, // ä‘ (U+00E4 U+2018)
  0x00, 0xE4, 0x20, 0x1C, 0x01, // ä“ (U+00E4 U+201C)
  0x00, 0xE5, 0x00, 0x22, 0x01, // å" (U+00E5 U+0022)
  0x00, 0xE5, 0x00, 0x27, 0x01, // å' (U+00E5 U+0027)
  0x00, 0xE5, 0x00, 0x56, 0x01, // åV (U+00E5 U+0056)
  0x00, 0xE5, 0x00, 0x57, 0x01, // åW (U+00E5 U+0057)
  0x00, 0xE5, 0x00, 0x59, 0x01, // åY (U+00E5 U+0059)
  0x00, 0xE5, 0x00, 0xDD, 0x01, // åÝ (U+00E5 U+00DD)
  0x00, 0xE5, 0x01, 0x74, 0x01, // åŴ (U+00E5 U+0174)
  0x00, 0xE5, 0x01, 0x76, 0x01, // åŶ (U+00E5 U+0176)
  0x00, 0xE5, 0x01, 0x78, 0x01, // åŸ (U+00E5 U+0178)
  0x00, 0xE5, 0x20, 0x18, 0x01, // å‘ (U+00E5 U+2018)
  0x00, 0xE5, 0x20, 0x1C, 0x01, // å“ (U+00E5 U+201C)
  0x00, 0xE6, 0x00, 0x56, 0x01, // æV (U+00E6 U+0056)
  0x00, 0xE6, 0x00, 0x57, 0x01, // æW (U+00E6 U+0057)
  0x00, 0xE6, 0x00, 0x59, 0x01, // æY (U+00E6 U+0059)
  0x00, 0xE6, 0x00, 0xDD, 0x01, // æÝ (U+00E6 U+00DD)
  0x00, 0xE6, 0x01, 0x74, 0x01, // æŴ (U+00E6 U+0174)
  0x00, 0xE6, 0x01, 0x76, 0x01, // æŶ (U+00E6 U+0176)
  0x00, 0xE6, 0x01, 0x78, 0x01, // æŸ (U+00E6 U+0178)
  0x00, 0xE7, 0x00, 0x56, 0x01, // çV (U+00E7 U+0056)
  0x00, 0xE7, 0x00, 0x57, 0x01, // çW (U+00E7 U+0057)
  0x00, 0xE7, 0x00, 0x59, 0x01, // çY (U+00E7 U+0059)
  0x00, 0xE7, 0x00, 0xDD, 0x01, // çÝ (U+00E7 U+00DD)
  0x00, 0xE7, 0x01, 0x74, 0x01, // çŴ (U+00E7 U+0174)
  0x00, 0xE7, 0x01, 0x76, 0x01, // çŶ (U+00E7 U+0176)
  0x00, 0xE7, 0x01, 0x78, 0x01, // çŸ (U+00E7 U+0178)
  0x00, 0xE8, 0x00, 0x56, 0x01, // èV (U+00E8 U+0056)
  0x00, 0xE8, 0x00, 0x57, 0x01, // èW (U+00E8 U+0057)
  0x00, 0xE8, 0x00, 0x59, 0x01, // èY (U+00E8 U+0059)
  0x00, 0xE8, 0x00, 0xDD, 0x01, // èÝ (U+00E8 U+00DD)
  0x00, 0xE8, 0x01, 0x74, 0x01, // èŴ (U+00E8 U+0174)
  0x00, 0xE8, 0x01, 0x76, 0x01, // èŶ (U+00E8 U+0176)
  0x00, 0xE8, 0x01, 0x78, 0x01, // èŸ (U+00E8 U+0178)
  0x00, 0xE9, 0x00, 0x56, 0x01, // éV (U+00E9 U+0056)
  0x00, 0xE9, 0x00, 0x57, 0x01, // éW (U+00E9 U+0057)
  0x00, 0xE9, 0x00, 0x59, 0x01, // éY (U+00E9 U+0059)
  0x00, 0xE9, 0x00, 0xDD, 0x01, // éÝ (U+00E9 U+00DD)
  0x00, 0xE9, 0x01, 0x74, 0x01, // éŴ (U+00E9 U+0174)
  0x00, 0xE9, 0x01, 0x76, 0x01, // éŶ (U+00E9 U+0176)
  0x00, 0xE9, 0x01, 0x78, 0x01, // éŸ (U+00E9 U+0178)
  0x00, 0xEA, 0x00, 0x56, 0x01, // êV (U+00EA U+0056)
  0x00, 0xEA, 0x00, 0x57, 0x01, // êW (U+00EA U+0057)
  0x00, 0xEA, 0x00, 0x59, 0x01, // êY (U+00EA U+0059)
  0x00, 0xEA, 0x00, 0xDD, 0x01, // êÝ (U+00EA U+00DD)
  0x00, 0xEA, 0x01, 0x74, 0x01, // êŴ (U+00EA U+0174)
  0x00, 0xEA, 0x01, 0x76, 0x01, // êŶ (U+00EA U+0176)
  0x00, 0xEA, 0x01, 0x78, 0x01, // êŸ (U+00EA U+0178)
  0x00, 0xEB, 0x00, 0x56, 0x01, // ëV (U+00EB U+0056)
  0x00, 0xEB, 0x00, 0x57, 0x01, // ëW (U+00EB U+0057)
  0x00, 0xEB, 0x00, 0x59, 0x01, // ëY (U+00EB U+0059)
  0x00, 0xEB, 0x00, 0xDD, 0x01, // ëÝ (U+00EB U+00DD)
  0x00, 0xEB, 0x01, 0x74, 0x01, // ëŴ (U+00EB U+0174)
  0x00, 0xEB, 0x01, 0x76, 0x01, // ëŶ (U+00EB U+0176)
  0x00, 0xEB, 0x01, 0x78, 0x01, // ëŸ (U+00EB U+0178)
  0x00, 0xF0, 0x00, 0x54, 0x01, // ðT (U+00F0 U+0054)
  0x00, 0xF0, 0x00, 0x56, 0x01, // ðV (U+00F0 U+0056)
  0x00, 0xF0, 0x00, 0x57, 0x01, // ðW (U+00F0 U+0057)
  0x00, 0xF0, 0x00, 0x59, 0x01, // ðY (U+00F0 U+0059)
  0x00, 0xF0, 0x00, 0xDD, 0x01, // ðÝ (U+00F0 U+00DD)
  0x00, 0xF0, 0x01, 0x74, 0x01, // ðŴ (U+00F0 U+0174)
  0x00, 0xF0, 0x01, 0x76, 0x01, // ðŶ (U+00F0 U+0176)
  0x00, 0xF0, 0x01, 0x78, 0x01, // ðŸ (U+00F0 U+0178)
  0x00, 0xF1, 0x00, 0x22, 0x01, // ñ" (U+00F1 U+0022)
  0x00, 0xF1, 0x00, 0x27, 0x01, // ñ' (U+00F1 U+0027)
  0x00, 0xF1, 0x00, 0x56, 0x01, // ñV (U+00F1 U+0056)
  0x00, 0xF1, 0x00, 0x57, 0x01, // ñW (U+00F1 U+0057)
  0x00, 0xF1, 0x00, 0x59, 0x01, // ñY (U+00F1 U+0059)
  0x00, 0xF1, 0x00, 0xDD, 0x01, // ñÝ (U+00F1 U+00DD)
  0x00, 0xF1, 0x01, 0x74, 0x01, // ñŴ (U+00F1 U+0174)
  0x00, 0xF1, 0x01, 0x76, 0x01, // ñŶ (U+00F1 U+0176)
  0x00, 0xF1, 0x01, 0x78, 0x01, // ñŸ (U+00F1 U+0178)
  0x00, 0xF1, 0x20, 0x18, 0x01, // ñ‘ (U+00F1 U+2018)
  0x00, 0xF1, 0x20, 0x1C, 0x01, // ñ“ (U+00F1 U+201C)
  0x00, 0xF2, 0x00, 0x54, 0x01, // òT (U+00F2 U+0054)
  0x00, 0xF2, 0x00, 0x56, 0x01, // òV (U+00F2 U+0056)
  0x00, 0xF2, 0x00, 0x57, 0x01, // òW (U+00F2 U+0057)
  0x00, 0xF2, 0x00, 0x59, 0x01, // òY (U+00F2 U+0059)
  0x00, 0xF2, 0x00, 0xDD, 0x01, // òÝ (U+00F2 U+00DD)
  0x00, 0xF2, 0x01, 0x74, 0x01, // òŴ (U+00F2 U+0174)
  0x00, 0xF2, 0x01, 0x76, 0x01, // òŶ (U+00F2 U+0176)
  0x00, 0xF2, 0x01, 0x78, 0x01, // òŸ (U+00F2 U+0178)
  0x00, 0xF3, 0x00, 0x54, 0x01, // óT (U+00F3 U+0054)
  0x00, 0xF3, 0x00, 0x56, 0x01, // óV (U+00F3 U+0056)
  0x00, 0xF3, 0x00, 0x57, 0x01, // óW (U+00F3 U+0057)
  0x00, 0xF3, 0x00, 0x59, 0x01, // óY (U+00F3 U+0059)
  0x00, 0xF3, 0x00, 0xDD, 0x01, // óÝ (U+00F3 U+00DD)
  0x00, 0xF3, 0x01, 0x74, 0x01, // óŴ (U+00F3 U+0174)
  0x00, 0xF3, 0x01, 0x76, 0x01, // óŶ (U+00F3 U+0176)
  0x00, 0xF3, 0x01, 0x78, 0x01, // óŸ (U+00F3 U+0178)
  0x00, 0xF4, 0x00, 0x54, 0x01, // ôT (U+00F4 U+0054)
  0x00, 0xF4, 0x00, 0x56, 0x01, // ôV (U+00F4 U+0056)
  0x00, 0xF4, 0x00, 0x57, 0x01, // ôW (U+00F4 U+0057)
  0x00, 0xF4, 0x00, 0x59, 0x01, // ôY (U+00F4 U+0059)
  0x00, 0xF4, 0x00, 0xDD, 0x01, // ôÝ (U+00F4 U+00DD)
  0x00, 0xF4, 0x01, 0x74, 0x01, // ôŴ (U+00F4 U+0174)
  0x00, 0xF4, 0x01, 0x76, 0x01, // ôŶ (U+00F4 U+0176)
  0x00, 0xF4, 0x01, 0x78, 0x01, // ôŸ (U+00F4 U+0178)
  0x00, 0xF5, 0x00, 0x54, 0x01, // õT (U+00F5 U+0054)
  0x00, 0xF5, 0x00, 0x56, 0x01, // õV (U+00F5 U+0056)
  0x00, 0xF5, 0x00, 0x57, 0x01, // õW (U+00F5 U+0057)
  0x00, 0xF5, 0x00, 0x59, 0x01, // õY (U+00F5 U+0059)
  0x00, 0xF5, 0x00, 0xDD, 0x01, // õÝ (U+00F5 U+00DD)
  0x00, 0xF5, 0x01, 0x74, 0x01, // õŴ (U+00F5 U+0174)
  0x00, 0xF5, 0x01, 0x76, 0x01, // õŶ (U+00F5 U+0176)
  0x00, 0xF5, 0x01, 0x78, 0x01, // õŸ (U+00F5 U+0178)
  0x00, 0xF6, 0x00, 0x54, 0x01, // öT (U+00F6 U+0054)
  0x00, 0xF6, 0x00, 0x56, 0x01, // öV (U+00F6 U+0056)
  0x00, 0xF6, 0x00, 0x57, 0x01, // öW (U+00F6 U+0057)
  0x00, 0xF6, 0x00, 0x59, 0x01, // öY (U+00F6 U+0059)
  0x00, 0xF6, 0x00, 0xDD, 0x01, // öÝ (U+00F6 U+00DD)
  0x00, 0xF6, 0x01, 0x74, 0x01, // öŴ (U+00F6 U+0174)
  0x00, 0xF6, 0x01, 0x76, 0x01, // öŶ (U+00F6 U+0176)
  0x00, 0xF6, 0x01, 0x78, 0x01, // öŸ (U+00F6 U+0178)
  0x00, 0xF8, 0x00, 0x54, 0x01, // øT (U+00F8 U+0054)
  0x00, 0xF8, 0x00, 0x56, 0x01, // øV (U+00F8 U+0056)
  0x00, 0xF8, 0x00, 0x57, 0x01, // øW (U+00F8 U+0057)
  0x00, 0xF8, 0x00, 0x59, 0x01, // øY (U+00F8 U+0059)
  0x00, 0xF8, 0x00, 0xDD, 0x01, // øÝ (U+00F8 U+00DD)
  0x00, 0xF8, 0x01, 0x74, 0x01, // øŴ (U+00F8 U+0174)
  0x00, 0xF8, 0x01, 0x76, 0x01, // øŶ (U+00F8 U+0176)
  0x00, 0xF8, 0x01, 0x78, 0x01, // øŸ (U+00F8 U+0178)
  0x00, 0xF9, 0x00, 0x22, 0x01, // ù" (U+00F9 U+0022)
  0x00, 0xF9, 0x00, 0x27, 0x01, // ù' (U+00F9 U+0027)
  0x00, 0xF9, 0x00, 0x56, 0x01, // ùV (U+00F9 U+0056)
  0x00, 0xF9, 0x00, 0x57, 0x01, // ùW (U+00F9 U+0057)
  0x00, 0xF9, 0x00, 0x59, 0x01, // ùY (U+00F9 U+0059)
  0x00, 0xF9, 0x00, 0xDD, 0x01, // ùÝ (U+00F9 U+00DD)
  0x00, 0xF9, 0x01, 0x74, 0x01, // ùŴ (U+00F9 U+0174)
  0x00, 0xF9, 0x01, 0x76, 0x01, // ùŶ (U+00F9 U+0176)
  0x00, 0xF9, 0x01, 0x78, 0x01, // ùŸ (U+00F9 U+0178)
  0x00, 0xF9, 0x20, 0x18, 0x01, // ù‘ (U+00F9 U+2018)
  0x00, 0xF9, 0x20, 0x1C, 0x01, // ù“ (U+00F9 U+201C)
  0x00, 0xFA, 0x00, 0x22, 0x01, // ú" (U+00FA U+0022)
  0x00, 0xFA, 0x00, 0x27, 0x01, // ú' (U+00FA U+0027)
  0x00, 0xFA, 0x00, 0x56, 0x01, // úV (U+00FA U+0056)
  0x00, 0xFA, 0x00, 0x57, 0x01, // úW (U+00FA U+0057)
  0x00, 0xFA, 0x00, 0x59, 0x01, // úY (U+00FA U+0059)
  0x00, 0xFA, 0x00, 0xDD, 0x01, // úÝ (U+00FA U+00DD)
  0x00, 0xFA, 0x01, 0x74, 0x01, // úŴ (U+00FA U+0174)
  0x00, 0xFA, 0x01, 0x76, 0x01, // úŶ (U+00FA U+0176)
  0x00, 0xFA, 0x01, 0x78, 0x01, // úŸ (U+00FA U+0178)
  0x00, 0xFA, 0x20, 0x18, 0x01, // ú‘ (U+00FA U+2018)
  0x00, 0xFA, 0x20, 0x1C, 0x01, // ú“ (U+00FA U+201C)
  0x00, 0xFB, 0x00, 0x22, 0x01, // û" (U+00FB U+0022)
  0x00, 0xFB, 0x00, 0x27, 0x01, // û' (U+00FB U+0027)
  0x00, 0xFB, 0x00, 0x56, 0x01, // ûV (U+00FB U+0056)
  0x00, 0xFB, 0x00, 0x57, 0x01, // ûW (U+00FB U+0057)
  0x00, 0xFB, 0x00, 0x59, 0x01, // ûY (U+00FB U+0059)
  0x00, 0xFB, 0x00, 0xDD, 0x01, // ûÝ (U+00FB U+00DD)
  0x00, 0xFB, 0x01, 0x74, 0x01, // ûŴ (U+00FB U+0174)
  0x00, 0xFB, 0x01, 0x76, 0x01, // ûŶ (U+00FB U+0176)
  0x00, 0xFB, 0x01, 0x78, 0x01, // ûŸ (U+00FB U+0178)
  0x00, 0xFB, 0x20, 0x18, 0x01, // û‘ (U+00FB U+2018)
  0x00, 0xFB, 0x20, 0x1C, 0x01, // û“ (U+00FB U+201C)
  0x00, 0xFC, 0x00, 0x22, 0x01, // ü" (U+00FC U+0022)
  0x00, 0xFC, 0x00, 0x27, 0x01, // ü' (U+00FC U+0027)
  0x00, 0xFC, 0x00, 0x56, 0x01, // üV (U+00FC U+0056)
  0x00, 0xFC, 0x00, 0x57, 0x01, // üW (U+00FC U+0057)
  0x00, 0xFC, 0x00, 0x59, 0x01, // üY (U+00FC U+0059)
  0x00, 0xFC, 0x00, 0xDD, 0x01, // üÝ (U+00FC U+00DD)
  0x00, 0xFC, 0x01, 0x74, 0x01, // üŴ (U+00FC U+0174)
  0x00, 0xFC, 0x01, 0x76, 0x01, // üŶ (U+00FC U+0176)
  0x00, 0xFC, 0x01, 0x78, 0x01, // üŸ (U+00FC U+0178)
  0x00, 0xFC, 0x20, 0x18, 0x01, // ü‘ (U+00FC U+2018)
  0x00, 0xFC, 0x20, 0x1C, 0x01, // ü“ (U+00FC U+201C)
  0x00, 0xFD, 0x00, 0x2C, 0x02, // ý, (U+00FD U+002C)
  0x00, 0xFD, 0x00, 0x2E, 0x02, // ý. (U+00FD U+002E)
  0x00, 0xFD, 0x20, 0x1A, 0x02, // ý‚ (U+00FD U+201A)
  0x00, 0xFD, 0x20, 0x1E, 0x02, // ý„ (U+00FD U+201E)
  0x00, 0xFD, 0x20, 0x26, 0x02, // ý… (U+00FD U+2026)
  0x00, 0xFE, 0x00, 0x54, 0x01, // þT (U+00FE U+0054)
  0x00, 0xFE, 0x00, 0x56, 0x01, // þV (U+00FE U+0056)
  0x00, 0xFE, 0x00, 0x57, 0x01, // þW (U+00FE U+0057)
  0x00, 0xFE, 0x00, 0x59, 0x01, // þY (U+00FE U+0059)
  0x00, 0xFE, 0x00, 0xDD, 0x01, // þÝ (U+00FE U+00DD)
  0x00, 0xFE, 0x01, 0x74, 0x01, // þŴ (U+00FE U+0174)
  0x00, 0xFE, 0x01, 0x76, 0x01, // þŶ (U+00FE U+0176)
  0x00, 0xFE, 0x01, 0x78, 0x01, // þŸ (U+00FE U+0178)
  0x00, 0xFF, 0x00, 0x2C, 0x02, // ÿ, (U+00FF U+002C)
  0x00, 0xFF, 0x00, 0x2E, 0x02, // ÿ. (U+00FF U+002E)
  0x00, 0xFF, 0x20, 0x1A, 0x02, // ÿ‚ (U+00FF U+201A)
  0x00, 0xFF, 0x20, 0x1E, 0x02, // ÿ„ (U+00FF U+201E)
  0x00, 0xFF, 0x20, 0x26, 0x02, // ÿ… (U+00FF U+2026)
  0x01, 0x00, 0x00, 0x22, 0x01, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x01, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x00, 0x2A, 0x01, // Ā* (U+0100 U+002A)
  0x01, 0x00, 0x00, 0x54, 0x01, // ĀT (U+0100 U+0054)
  0x01, 0x00, 0x00, 0x56, 0x01, // ĀV (U+0100 U+0056)
  0x01, 0x00, 0x00, 0x57, 0x01, // ĀW (U+0100 U+0057)
  0x01, 0x00, 0x00, 0x59, 0x01, // ĀY (U+0100 U+0059)
  0x01, 0x00, 0x00, 0x76, 0x01, // Āv (U+0100 U+0076)
  0x01, 0x00, 0x00, 0x77, 0x01, // Āw (U+0100 U+0077)
  0x01, 0x00, 0x00, 0x79, 0x01, // Āy (U+0100 U+0079)
  0x01, 0x00, 0x00, 0xA9, 0x01, // Ā© (U+0100 U+00A9)
  0x01, 0x00, 0x00, 0xAE, 0x01, // Ā® (U+0100 U+00AE)
  0x01, 0x00, 0x00, 0xDD, 0x01, // ĀÝ (U+0100 U+00DD)
  0x01, 0x00, 0x00, 0xFD, 0x01, // Āý (U+0100 U+00FD)
  0x01, 0x00, 0x00, 0xFF, 0x01, // Āÿ (U+0100 U+00FF)
  0x01, 0x00, 0x01, 0x49, 0x01, // Āŉ (U+0100 U+0149)
  0x01, 0x00, 0x01, 0x74, 0x01, // ĀŴ (U+0100 U+0174)
  0x01, 0x00, 0x01, 0x75, 0x01, // Āŵ (U+0100 U+0175)
  0x01, 0x00, 0x01, 0x76, 0x01, // ĀŶ (U+0100 U+0176)
  0x01, 0x00, 0x01, 0x77, 0x01, // Āŷ (U+0100 U+0177)
  0x01, 0x00, 0x01, 0x78, 0x01, // ĀŸ (U+0100 U+0178)
  0x01, 0x00, 0x20, 0x18, 0x02, // Ā‘ (U+0100 U+2018)
  0x01, 0x00, 0x20, 0x19, 0x01, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1C, 0x02, // Ā“ (U+0100 U+201C)
  0x01, 0x00, 0x20, 0x1D, 0x01, // Ā” (U+0100 U+201D)
  0x01, 0x00, 0x21, 0x22, 0x01, // Ā™ (U+0100 U+2122)
  0x01, 0x01, 0x00, 0x22, 0x01, // ā" (U+0101 U+0022)
  0x01, 0x01, 0x00, 0x27, 0x01, // ā' (U+0101 U+0027)
  0x01, 0x01, 0x00, 0x56, 0x01, // āV (U+0101 U+0056)
  0x01, 0x01, 0x00, 0x57, 0x01, // āW (U+0101 U+0057)
  0x01, 0x01, 0x00, 0x59, 0x01, // āY (U+0101 U+0059)
  0x01, 0x01, 0x00, 0xDD, 0x01, // āÝ (U+0101 U+00DD)
  0x01, 0x01, 0x01, 0x74, 0x01, // āŴ (U+0101 U+0174)
  0x01, 0x01, 0x01, 0x76, 0x01, // āŶ (U+0101 U+0176)
  0x01, 0x01, 0x01, 0x78, 0x01, // āŸ (U+0101 U+0178)
  0x01, 0x01, 0x20, 0x18, 0x01, // ā‘ (U+0101 U+2018)
  0x01, 0x01, 0x20, 0x1C, 0x01, // ā“ (U+0101 U+201C)
  0x01, 0x02, 0x00, 0x22, 0x01, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x01, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x00, 0x2A, 0x01, // Ă* (U+0102 U+002A)
  0x01, 0x02, 0x00, 0x54, 0x01, // ĂT (U+0102 U+0054)
  0x01, 0x02, 0x00, 0x56, 0x01, // ĂV (U+0102 U+0056)
  0x01, 0x02, 0x00, 0x57, 0x01, // ĂW (U+0102 U+0057)
  0x01, 0x02, 0x00, 0x59, 0x01, // ĂY (U+0102 U+0059)
  0x01, 0x02, 0x00, 0x76, 0x01, // Ăv (U+0102 U+0076)
  0x01, 0x02, 0x00, 0x77, 0x01, // Ăw (U+0102 U+0077)
  0x01, 0x02, 0x00, 0x79, 0x01, // Ăy (U+0102 U+0079)
  0x01, 0x02, 0x00, 0xA9, 0x01, // Ă© (U+0102 U+00A9)
  0x01, 0x02, 0x00, 0xAE, 0x01, // Ă® (U+0102 U+00AE)
  0x01, 0x02, 0x00, 0xDD, 0x01, // ĂÝ (U+0102 U+00DD)
  0x01, 0x02, 0x00, 0xFD, 0x01, // Ăý (U+0102 U+00FD)
  0x01, 0x02, 0x00, 0xFF, 0x01, // Ăÿ (U+0102 U+00FF)
  0x01, 0x02, 0x01, 0x49, 0x01, // Ăŉ (U+0102 U+0149)
  0x01, 0x02, 0x01, 0x74, 0x01, // ĂŴ (U+0102 U+0174)
  0x01, 0x02, 0x01, 0x75, 0x01, // Ăŵ (U+0102 U+0175)
  0x01, 0x02, 0x01, 0x76, 0x01, // ĂŶ (U+0102 U+0176)
  0x01, 0x02, 0x01, 0x77, 0x01, // Ăŷ (U+0102 U+0177)
  0x01, 0x02, 0x01, 0x78, 0x01, // ĂŸ (U+0102 U+0178)
  0x01, 0x02, 0x20, 0x18, 0x02, // Ă‘ (U+0102 U+2018)
  0x01, 0x02, 0x20, 0x19, 0x01, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1C, 0x02, // Ă“ (U+0102 U+201C)
  0x01, 0x02, 0x20, 0x1D, 0x01, // Ă” (U+0102 U+201D)
  0x01, 0x02, 0x21, 0x22, 0x01, // Ă™ (U+0102 U+2122)
  0x01, 0x03, 0x00, 0x22, 0x01, // ă" (U+0103 U+0022)
  0x01, 0x03, 0x00, 0x27, 0x01, // ă' (U+0103 U+0027)
  0x01, 0x03, 0x00, 0x56, 0x01, // ăV (U+0103 U+0056)
  0x01, 0x03, 0x00, 0x57, 0x01, // ăW (U+0103 U+0057)
  0x01, 0x03, 0x00, 0x59, 0x01, // ăY (U+0103 U+0059)
  0x01, 0x03, 0x00, 0xDD, 0x01, // ăÝ (U+0103 U+00DD)
  0x01, 0x03, 0x01, 0x74, 0x01, // ăŴ (U+0103 U+0174)
  0x01, 0x03, 0x01, 0x76, 0x01, // ăŶ (U+0103 U+0176)
  0x01, 0x03, 0x01, 0x78, 0x01, // ăŸ (U+0103 U+0178)
  0x01, 0x03, 0x20, 0x18, 0x01, // ă‘ (U+0103 U+2018)
  0x01, 0x03, 0x20, 0x1C, 0x01, // ă“ (U+0103 U+201C)
  0x01, 0x04, 0x00, 0x22, 0x01, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x01, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x00, 0x2A, 0x01, // Ą* (U+0104 U+002A)
  0x01, 0x04, 0x00, 0x54, 0x01, // ĄT (U+0104 U+0054)
  0x01, 0x04, 0x00, 0x56, 0x01, // ĄV (U+0104 U+0056)
  0x01, 0x04, 0x00, 0x57, 0x01, // ĄW (U+0104 U+0057)
  0x01, 0x04, 0x00, 0x59, 0x01, // ĄY (U+0104 U+0059)
  0x01, 0x04, 0x00, 0x76, 0x01, // Ąv (U+0104 U+0076)
  0x01, 0x04, 0x00, 0x77, 0x01, // Ąw (U+0104 U+0077)
  0x01, 0x04, 0x00, 0x79, 0x01, // Ąy (U+0104 U+0079)
  0x01, 0x04, 0x00, 0xA9, 0x01, // Ą© (U+0104 U+00A9)
  0x01, 0x04, 0x00, 0xAE, 0x01, // Ą® (U+0104 U+00AE)
  0x01, 0x04, 0x00, 0xDD, 0x01, // ĄÝ (U+0104 U+00DD)
  0x01, 0x04, 0x00, 0xFD, 0x01, // Ąý (U+0104 U+00FD)
  0x01, 0x04, 0x00, 0xFF, 0x01, // Ąÿ (U+0104 U+00FF)
  0x01, 0x04, 0x01, 0x49, 0x01, // Ąŉ (U+0104 U+0149)
  0x01, 0x04, 0x01, 0x74, 0x01, // ĄŴ (U+0104 U+0174)
  0x01, 0x04, 0x01, 0x75, 0x01, // Ąŵ (U+0104 U+0175)
  0x01, 0x04, 0x01, 0x76, 0x01, // ĄŶ (U+0104 U+0176)
  0x01, 0x04, 0x01, 0x77, 0x01, // Ąŷ (U+0104 U+0177)
  0x01, 0x04, 0x01, 0x78, 0x01, // ĄŸ (U+0104 U+0178)
  0x01, 0x04, 0x20, 0x18, 0x02, // Ą‘ (U+0104 U+2018)
  0x01, 0x04, 0x20, 0x19, 0x01, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1C, 0x02, // Ą“ (U+0104 U+201C)
  0x01, 0x04, 0x20, 0x1D, 0x01, // Ą” (U+0104 U+201D)
  0x01, 0x04, 0x21, 0x22, 0x01, // Ą™ (U+0104 U+2122)
  0x01, 0x05, 0x00, 0x22, 0x01, // ą" (U+0105 U+0022)
  0x01, 0x05, 0x00, 0x27, 0x01, // ą' (U+0105 U+0027)
  0x01, 0x05, 0x00, 0x56, 0x01, // ąV (U+0105 U+0056)
  0x01, 0x05, 0x00, 0x57, 0x01, // ąW (U+0105 U+0057)
  0x01, 0x05, 0x00, 0x59, 0x01, // ąY (U+0105 U+0059)
  0x01, 0x05, 0x00, 0xDD, 0x01, // ąÝ (U+0105 U+00DD)
  0x01, 0x05, 0x01, 0x74, 0x01, // ąŴ (U+0105 U+0174)
  0x01, 0x05, 0x01, 0x76, 0x01, // ąŶ (U+0105 U+0176)
  0x01, 0x05, 0x01, 0x78, 0x01, // ąŸ (U+0105 U+0178)
  0x01, 0x05, 0x20, 0x18, 0x01, // ą‘ (U+0105 U+2018)
  0x01, 0x05, 0x20, 0x1C, 0x01, // ą“ (U+0105 U+201C)
  0x01, 0x07, 0x00, 0x56, 0x01, // ćV (U+0107 U+0056)
  0x01, 0x07, 0x00, 0x57, 0x01, // ćW (U+0107 U+0057)
  0x01, 0x07, 0x00, 0x59, 0x01, // ćY (U+0107 U+0059)
  0x01, 0x07, 0x00, 0xDD, 0x01, // ćÝ (U+0107 U+00DD)
  0x01, 0x07, 0x01, 0x74, 0x01, // ćŴ (U+0107 U+0174)
  0x01, 0x07, 0x01, 0x76, 0x01, // ćŶ (U+0107 U+0176)
  0x01, 0x07, 0x01, 0x78, 0x01, // ćŸ (U+0107 U+0178)
  0x01, 0x09, 0x00, 0x56, 0x01, // ĉV (U+0109 U+0056)
  0x01, 0x09, 0x00, 0x57, 0x01, // ĉW (U+0109 U+0057)
  0x01, 0x09, 0x00, 0x59, 0x01, // ĉY (U+0109 U+0059)
  0x01, 0x09, 0x00, 0xDD, 0x01, // ĉÝ (U+0109 U+00DD)
  0x01, 0x09, 0x01, 0x74, 0x01, // ĉŴ (U+0109 U+0174)
  0x01, 0x09, 0x01, 0x76, 0x01, // ĉŶ (U+0109 U+0176)
  0x01, 0x09, 0x01, 0x78, 0x01, // ĉŸ (U+0109 U+0178)
  0x01, 0x0B, 0x00, 0x56, 0x01, // ċV (U+010B U+0056)
  0x01, 0x0B, 0x00, 0x57, 0x01, // ċW (U+010B U+0057)
  0x01, 0x0B, 0x00, 0x59, 0x01, // ċY (U+010B U+0059)
  0x01, 0x0B, 0x00, 0xDD, 0x01, // ċÝ (U+010B U+00DD)
  0x01, 0x0B, 0x01, 0x74, 0x01, // ċŴ (U+010B U+0174)
  0x01, 0x0B, 0x01, 0x76, 0x01, // ċŶ (U+010B U+0176)
  0x01, 0x0B, 0x01, 0x78, 0x01, // ċŸ (U+010B U+0178)
  0x01, 0x0D, 0x00, 0x56, 0x01, // čV (U+010D U+0056)
  0x01, 0x0D, 0x00, 0x57, 0x01, // čW (U+010D U+0057)
  0x01, 0x0D, 0x00, 0x59, 0x01, // čY (U+010D U+0059)
  0x01, 0x0D, 0x00, 0xDD, 0x01, // čÝ (U+010D U+00DD)
  0x01, 0x0D, 0x01, 0x74, 0x01, // čŴ (U+010D U+0174)
  0x01, 0x0D, 0x01, 0x76, 0x01, // čŶ (U+010D U+0176)
  0x01, 0x0D, 0x01, 0x78, 0x01, // čŸ (U+010D U+0178)
  0x01, 0x0E, 0x00, 0x22, 0x01, // Ď" (U+010E U+0022)
  0x01, 0x0E, 0x00, 0x27, 0x01, // Ď' (U+010E U+0027)
  0x01, 0x0E, 0x00, 0x59, 0x01, // ĎY (U+010E U+0059)
  0x01, 0x0E, 0x00, 0xC6, 0x01, // ĎÆ (U+010E U+00C6)
  0x01, 0x0E, 0x00, 0xDD, 0x01, // ĎÝ (U+010E U+00DD)
  0x01, 0x0E, 0x01, 0x76, 0x01, // ĎŶ (U+010E U+0176)
  0x01, 0x0E, 0x01, 0x78, 0x01, // ĎŸ (U+010E U+0178)
  0x01, 0x10, 0x00, 0x22, 0x01, // Đ" (U+0110 U+0022)
  0x01, 0x10, 0x00, 0x27, 0x01, // Đ' (U+0110 U+0027)
  0x01, 0x10, 0x00, 0x59, 0x01, // ĐY (U+0110 U+0059)
  0x01, 0x10, 0x00, 0xC6, 0x01, // ĐÆ (U+0110 U+00C6)
  0x01, 0x10, 0x00, 0xDD, 0x01, // ĐÝ (U+0110 U+00DD)
  0x01, 0x10, 0x01, 0x76, 0x01, // ĐŶ (U+0110 U+0176)
  0x01, 0x10, 0x01, 0x78, 0x01, // ĐŸ (U+0110 U+0178)
  0x01, 0x13, 0x00, 0x56, 0x01, // ēV (U+0113 U+0056)
  0x01, 0x13, 0x00, 0x57, 0x01, // ēW (U+0113 U+0057)
  0x01, 0x13, 0x00, 0x59, 0x01, // ēY (U+0113 U+0059)
  0x01, 0x13, 0x00, 0xDD, 0x01, // ēÝ (U+0113 U+00DD)
  0x01, 0x13, 0x01, 0x74, 0x01, // ēŴ (U+0113 U+0174)
  0x01, 0x13, 0x01, 0x76, 0x01, // ēŶ (U+0113 U+0176)
  0x01, 0x13, 0x01, 0x78, 0x01, // ēŸ (U+0113 U+0178)
  0x01, 0x15, 0x00, 0x56, 0x01, // ĕV (U+0115 U+0056)
  0x01, 0x15, 0x00, 0x57, 0x01, // ĕW (U+0115 U+0057)
  0x01, 0x15, 0x00, 0x59, 0x01, // ĕY (U+0115 U+0059)
  0x01, 0x15, 0x00, 0xDD, 0x01, // ĕÝ (U+0115 U+00DD)
  0x01, 0x15, 0x01, 0x74, 0x01, // ĕŴ (U+0115 U+0174)
  0x01, 0x15, 0x01, 0x76, 0x01, // ĕŶ (U+0115 U+0176)
  0x01, 0x15, 0x01, 0x78, 0x01, // ĕŸ (U+0115 U+0178)
  0x01, 0x17, 0x00, 0x56, 0x01, // ėV (U+0117 U+0056)
  0x01, 0x17, 0x00, 0x57, 0x01, // ėW (U+0117 U+0057)
  0x01, 0x17, 0x00, 0x59, 0x01, // ėY (U+0117 U+0059)
  0x01, 0x17, 0x00, 0xDD, 0x01, // ėÝ (U+0117 U+00DD)
  0x01, 0x17, 0x01, 0x74, 0x01, // ėŴ (U+0117 U+0174)
  0x01, 0x17, 0x01, 0x76, 0x01, // ėŶ (U+0117 U+0176)
  0x01, 0x17, 0x01, 0x78, 0x01, // ėŸ (U+0117 U+0178)
  0x01, 0x19, 0x00, 0x56, 0x01, // ęV (U+0119 U+0056)
  0x01, 0x19, 0x00, 0x57, 0x01, // ęW (U+0119 U+0057)
  0x01, 0x19, 0x00, 0x59, 0x01, // ęY (U+0119 U+0059)
  0x01, 0x19, 0x00, 0xDD, 0x01, // ęÝ (U+0119 U+00DD)
  0x01, 0x19, 0x01, 0x74, 0x01, // ęŴ (U+0119 U+0174)
  0x01, 0x19, 0x01, 0x76, 0x01, // ęŶ (U+0119 U+0176)
  0x01, 0x19, 0x01, 0x78, 0x01, // ęŸ (U+0119 U+0178)
  0x01, 0x1B, 0x00, 0x56, 0x01, // ěV (U+011B U+0056)
  0x01, 0x1B, 0x00, 0x57, 0x01, // ěW (U+011B U+0057)
  0x01, 0x1B, 0x00, 0x59, 0x01, // ěY (U+011B U+0059)
  0x01, 0x1B, 0x00, 0xDD, 0x01, // ěÝ (U+011B U+00DD)
  0x01, 0x1B, 0x01, 0x74, 0x01, // ěŴ (U+011B U+0174)
  0x01, 0x1B, 0x01, 0x76, 0x01, // ěŶ (U+011B U+0176)
  0x01, 0x1B, 0x01, 0x78, 0x01, // ěŸ (U+011B U+0178)
  0x01, 0x25, 0x00, 0x22, 0x01, // ĥ" (U+0125 U+0022)
  0x01, 0x25, 0x00, 0x27, 0x01, // ĥ' (U+0125 U+0027)
  0x01, 0x25, 0x00, 0x56, 0x01, // ĥV (U+0125 U+0056)
  0x01, 0x25, 0x00, 0x57, 0x01, // ĥW (U+0125 U+0057)
  0x01, 0x25, 0x00, 0x59, 0x01, // ĥY (U+0125 U+0059)
  0x01, 0x25, 0x00, 0xDD, 0x01, // ĥÝ (U+0125 U+00DD)
  0x01, 0x25, 0x01, 0x74, 0x01, // ĥŴ (U+0125 U+0174)
  0x01, 0x25, 0x01, 0x76, 0x01, // ĥŶ (U+0125 U+0176)
  0x01, 0x25, 0x01, 0x78, 0x01, // ĥŸ (U+0125 U+0178)
  0x01, 0x25, 0x20, 0x18, 0x01, // ĥ‘ (U+0125 U+2018)
  0x01, 0x25, 0x20, 0x1C, 0x01, // ĥ“ (U+0125 U+201C)
  0x01, 0x27, 0x00, 0x22, 0x01, // ħ" (U+0127 U+0022)
  0x01, 0x27, 0x00, 0x27, 0x01, // ħ' (U+0127 U+0027)
  0x01, 0x27, 0x00, 0x56, 0x01, // ħV (U+0127 U+0056)
  0x01, 0x27, 0x00, 0x57, 0x01, // ħW (U+0127 U+0057)
  0x01, 0x27, 0x00, 0x59, 0x01, // ħY (U+0127 U+0059)
  0x01, 0x27, 0x00, 0xDD, 0x01, // ħÝ (U+0127 U+00DD)
  0x01, 0x27, 0x01, 0x74, 0x01, // ħŴ (U+0127 U+0174)
  0x01, 0x27, 0x01, 0x76, 0x01, // ħŶ (U+0127 U+0176)
  0x01, 0x27, 0x01, 0x78, 0x01, // ħŸ (U+0127 U+0178)
  0x01, 0x27, 0x20, 0x18, 0x01, // ħ‘ (U+0127 U+2018)
  0x01, 0x27, 0x20, 0x1C, 0x01, // ħ“ (U+0127 U+201C)
  0x01, 0x36, 0x00, 0x77, 0x01, // Ķw (U+0136 U+0077)
  0x01, 0x36, 0x00, 0x79, 0x01, // Ķy (U+0136 U+0079)
  0x01, 0x36, 0x00, 0xFD, 0x01, // Ķý (U+0136 U+00FD)
  0x01, 0x36, 0x00, 0xFF, 0x01, // Ķÿ (U+0136 U+00FF)
  0x01, 0x36, 0x01, 0x75, 0x01, // Ķŵ (U+0136 U+0175)
  0x01, 0x36, 0x01, 0x77, 0x01, // Ķŷ (U+0136 U+0177)
  0x01, 0x39, 0x00, 0x22, 0x01, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x01, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x00, 0x2A, 0x01, // Ĺ* (U+0139 U+002A)
  0x01, 0x39, 0x00, 0x54, 0x01, // ĹT (U+0139 U+0054)
  0x01, 0x39, 0x00, 0x56, 0x01, // ĹV (U+0139 U+0056)
  0x01, 0x39, 0x00, 0x57, 0x01, // ĹW (U+0139 U+0057)
  0x01, 0x39, 0x00, 0x59, 0x01, // ĹY (U+0139 U+0059)
  0x01, 0x39, 0x00, 0x76, 0x01, // Ĺv (U+0139 U+0076)
  0x01, 0x39, 0x00, 0xDD, 0x01, // ĹÝ (U+0139 U+00DD)
  0x01, 0x39, 0x01, 0x74, 0x01, // ĹŴ (U+0139 U+0174)
  0x01, 0x39, 0x01, 0x76, 0x01, // ĹŶ (U+0139 U+0176)
  0x01, 0x39, 0x01, 0x78, 0x01, // ĹŸ (U+0139 U+0178)
  0x01, 0x39, 0x20, 0x18, 0x02, // Ĺ‘ (U+0139 U+2018)
  0x01, 0x39, 0x20, 0x19, 0x01, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1C, 0x02, // Ĺ“ (U+0139 U+201C)
  0x01, 0x39, 0x20, 0x1D, 0x01, // Ĺ” (U+0139 U+201D)
  0x01, 0x39, 0x21, 0x22, 0x01, // Ĺ™ (U+0139 U+2122)
  0x01, 0x3B, 0x00, 0x22, 0x01, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x01, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x00, 0x2A, 0x01, // Ļ* (U+013B U+002A)
  0x01, 0x3B, 0x00, 0x54, 0x01, // ĻT (U+013B U+0054)
  0x01, 0x3B, 0x00, 0x56, 0x01, // ĻV (U+013B U+0056)
  0x01, 0x3B, 0x00, 0x57, 0x01, // ĻW (U+013B U+0057)
  0x01, 0x3B, 0x00, 0x59, 0x01, // ĻY (U+013B U+0059)
  0x01, 0x3B, 0x00, 0x76, 0x01, // Ļv (U+013B U+0076)
  0x01, 0x3B, 0x00, 0xDD, 0x01, // ĻÝ (U+013B U+00DD)
  0x01, 0x3B, 0x01, 0x74, 0x01, // ĻŴ (U+013B U+0174)
  0x01, 0x3B, 0x01, 0x76, 0x01, // ĻŶ (U+013B U+0176)
  0x01, 0x3B, 0x01, 0x78, 0x01, // ĻŸ (U+013B U+0178)
  0x01, 0x3B, 0x20, 0x18, 0x02, // Ļ‘ (U+013B U+2018)
  0x01, 0x3B, 0x20, 0x19, 0x01, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1C, 0x02, // Ļ“ (U+013B U+201C)
  0x01, 0x3B, 0x20, 0x1D, 0x01, // Ļ” (U+013B U+201D)
  0x01, 0x3B, 0x21, 0x22, 0x01, // Ļ™ (U+013B U+2122)
  0x01, 0x3D, 0x00, 0x2A, 0x01, // Ľ* (U+013D U+002A)
  0x01, 0x3D, 0x00, 0x54, 0x01, // ĽT (U+013D U+0054)
  0x01, 0x3D, 0x00, 0x56, 0x01, // ĽV (U+013D U+0056)
  0x01, 0x3D, 0x20, 0x19, 0x01, // Ľ’ (U+013D U+2019)
  0x01, 0x3D, 0x20, 0x1D, 0x01, // Ľ” (U+013D U+201D)
  0x01, 0x3D, 0x21, 0x22, 0x01, // Ľ™ (U+013D U+2122)
  0x01, 0x41, 0x00, 0x22, 0x01, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x01, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x00, 0x2A, 0x01, // Ł* (U+0141 U+002A)
  0x01, 0x41, 0x00, 0x54, 0x01, // ŁT (U+0141 U+0054)
  0x01, 0x41, 0x00, 0x56, 0x01, // ŁV (U+0141 U+0056)
  0x01, 0x41, 0x00, 0x57, 0x01, // ŁW (U+0141 U+0057)
  0x01, 0x41, 0x00, 0x59, 0x01, // ŁY (U+0141 U+0059)
  0x01, 0x41, 0x00, 0x76, 0x01, // Łv (U+0141 U+0076)
  0x01, 0x41, 0x00, 0xDD, 0x01, // ŁÝ (U+0141 U+00DD)
  0x01, 0x41, 0x01, 0x74, 0x01, // ŁŴ (U+0141 U+0174)
  0x01, 0x41, 0x01, 0x76, 0x01, // ŁŶ (U+0141 U+0176)
  0x01, 0x41, 0x01, 0x78, 0x01, // ŁŸ (U+0141 U+0178)
  0x01, 0x41, 0x20, 0x18, 0x02, // Ł‘ (U+0141 U+2018)
  0x01, 0x41, 0x20, 0x19, 0x01, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1C, 0x02, // Ł“ (U+0141 U+201C)
  0x01, 0x41, 0x20, 0x1D, 0x01, // Ł” (U+0141 U+201D)
  0x01, 0x41, 0x21, 0x22, 0x01, // Ł™ (U+0141 U+2122)
  0x01, 0x44, 0x00, 0x22, 0x01, // ń" (U+0144 U+0022)
  0x01, 0x44, 0x00, 0x27, 0x01, // ń' (U+0144 U+0027)
  0x01, 0x44, 0x00, 0x56, 0x01, // ńV (U+0144 U+0056)
  0x01, 0x44, 0x00, 0x57, 0x01, // ńW (U+0144 U+0057)
  0x01, 0x44, 0x00, 0x59, 0x01, // ńY (U+0144 U+0059)
  0x01, 0x44, 0x00, 0xDD, 0x01, // ńÝ (U+0144 U+00DD)
  0x01, 0x44, 0x01, 0x74, 0x01, // ńŴ (U+0144 U+0174)
  0x01, 0x44, 0x01, 0x76, 0x01, // ńŶ (U+0144 U+0176)
  0x01, 0x44, 0x01, 0x78, 0x01, // ńŸ (U+0144 U+0178)
  0x01, 0x44, 0x20, 0x18, 0x01, // ń‘ (U+0144 U+2018)
  0x01, 0x44, 0x20, 0x1C, 0x01, // ń“ (U+0144 U+201C)
  0x01, 0x46, 0x00, 0x22, 0x01, // ņ" (U+0146 U+0022)
  0x01, 0x46, 0x00, 0x27, 0x01, // ņ' (U+0146 U+0027)
  0x01, 0x46, 0x00, 0x56, 0x01, // ņV (U+0146 U+0056)
  0x01, 0x46, 0x00, 0x57, 0x01, // ņW (U+0146 U+0057)
  0x01, 0x46, 0x00, 0x59, 0x01, // ņY (U+0146 U+0059)
  0x01, 0x46, 0x00, 0xDD, 0x01, // ņÝ (U+0146 U+00DD)
  0x01, 0x46, 0x01, 0x74, 0x01, // ņŴ (U+0146 U+0174)
  0x01, 0x46, 0x01, 0x76, 0x01, // ņŶ (U+0146 U+0176)
  0x01, 0x46, 0x01, 0x78, 0x01, // ņŸ (U+0146 U+0178)
  0x01, 0x46, 0x20, 0x18, 0x01, // ņ‘ (U+0146 U+2018)
  0x01, 0x46, 0x20, 0x1C, 0x01, // ņ“ (U+0146 U+201C)
  0x01, 0x48, 0x00, 0x22, 0x01, // ň" (U+0148 U+0022)
  0x01, 0x48, 0x00, 0x27, 0x01, // ň' (U+0148 U+0027)
  0x01, 0x48, 0x00, 0x56, 0x01, // ňV (U+0148 U+0056)
  0x01, 0x48, 0x00, 0x57, 0x01, // ňW (U+0148 U+0057)
  0x01, 0x48, 0x00, 0x59, 0x01, // ňY (U+0148 U+0059)
  0x01, 0x48, 0x00, 0xDD, 0x01, // ňÝ (U+0148 U+00DD)
  0x01, 0x48, 0x01, 0x74, 0x01, // ňŴ (U+0148 U+0174)
  0x01, 0x48, 0x01, 0x76, 0x01, // ňŶ (U+0148 U+0176)
  0x01, 0x48, 0x01, 0x78, 0x01, // ňŸ (U+0148 U+0178)
  0x01, 0x48, 0x20, 0x18, 0x01, // ň‘ (U+0148 U+2018)
  0x01, 0x48, 0x20, 0x1C, 0x01, // ň“ (U+0148 U+201C)
  0x01, 0x49, 0x00, 0x22, 0x01, // ŉ" (U+0149 U+0022)
  0x01, 0x49, 0x00, 0x27, 0x01, // ŉ' (U+0149 U+0027)
  0x01, 0x49, 0x00, 0x56, 0x01, // ŉV (U+0149 U+0056)
  0x01, 0x49, 0x00, 0x57, 0x01, // ŉW (U+0149 U+0057)
  0x01, 0x49, 0x00, 0x59, 0x01, // ŉY (U+0149 U+0059)
  0x01, 0x49, 0x00, 0xDD, 0x01, // ŉÝ (U+0149 U+00DD)
  0x01, 0x49, 0x01, 0x74, 0x01, // ŉŴ (U+0149 U+0174)
  0x01, 0x49, 0x01, 0x76, 0x01, // ŉŶ (U+0149 U+0176)
  0x01, 0x49, 0x01, 0x78, 0x01, // ŉŸ (U+0149 U+0178)
  0x01, 0x49, 0x20, 0x18, 0x01, // ŉ‘ (U+0149 U+2018)
  0x01, 0x49, 0x20, 0x1C, 0x01, // ŉ“ (U+0149 U+201C)
  0x01, 0x4B, 0x00, 0x22, 0x01, // ŋ" (U+014B U+0022)
  0x01, 0x4B, 0x00, 0x27, 0x01, // ŋ' (U+014B U+0027)
  0x01, 0x4B, 0x00, 0x56, 0x01, // ŋV (U+014B U+0056)
  0x01, 0x4B, 0x00, 0x57, 0x01, // ŋW (U+014B U+0057)
  0x01, 0x4B, 0x00, 0x59, 0x01, // ŋY (U+014B U+0059)
  0x01, 0x4B, 0x00, 0xDD, 0x01, // ŋÝ (U+014B U+00DD)
  0x01, 0x4B, 0x01, 0x74, 0x01, // ŋŴ (U+014B U+0174)
  0x01, 0x4B, 0x01, 0x76, 0x01, // ŋŶ (U+014B U+0176)
  0x01, 0x4B, 0x01, 0x78, 0x01, // ŋŸ (U+014B U+0178)
  0x01, 0x4B, 0x20, 0x18, 0x01, // ŋ‘ (U+014B U+2018)
  0x01, 0x4B, 0x20, 0x1C, 0x01, // ŋ“ (U+014B U+201C)
  0x01, 0x4C, 0x00, 0x22, 0x01, // Ō" (U+014C U+0022)
  0x01, 0x4C, 0x00, 0x27, 0x01, // Ō' (U+014C U+0027)
  0x01, 0x4C, 0x00, 0x59, 0x01, // ŌY (U+014C U+0059)
  0x01, 0x4C, 0x00, 0xC6, 0x01, // ŌÆ (U+014C U+00C6)
  0x01, 0x4C, 0x00, 0xDD, 0x01, // ŌÝ (U+014C U+00DD)
  0x01, 0x4C, 0x01, 0x76, 0x01, // ŌŶ (U+014C U+0176)
  0x01, 0x4C, 0x01, 0x78, 0x01, // ŌŸ (U+014C U+0178)
  0x01, 0x4D, 0x00, 0x54, 0x01, // ōT (U+014D U+0054)
  0x01, 0x4D, 0x00, 0x56, 0x01, // ōV (U+014D U+0056)
  0x01, 0x4D, 0x00, 0x57, 0x01, // ōW (U+014D U+0057)
  0x01, 0x4D, 0x00, 0x59, 0x01, // ōY (U+014D U+0059)
  0x01, 0x4D, 0x00, 0xDD, 0x01, // ōÝ (U+014D U+00DD)
  0x01, 0x4D, 0x01, 0x74, 0x01, // ōŴ (U+014D U+0174)
  0x01, 0x4D, 0x01, 0x76, 0x01, // ōŶ (U+014D U+0176)
  0x01, 0x4D, 0x01, 0x78, 0x01, // ōŸ (U+014D U+0178)
  0x01, 0x4E, 0x00, 0x22, 0x01, // Ŏ" (U+014E U+0022)
  0x01, 0x4E, 0x00, 0x27, 0x01, // Ŏ' (U+014E U+0027)
  0x01, 0x4E, 0x00, 0x59, 0x01, // ŎY (U+014E U+0059)
  0x01, 0x4E, 0x00, 0xC6, 0x01, // ŎÆ (U+014E U+00C6)
  0x01, 0x4E, 0x00, 0xDD, 0x01, // ŎÝ (U+014E U+00DD)
  0x01, 0x4E, 0x01, 0x76, 0x01, // ŎŶ (U+014E U+0176)
  0x01, 0x4E, 0x01, 0x78, 0x01, // ŎŸ (U+014E U+0178)
  0x01, 0x4F, 0x00, 0x54, 0x01, // ŏT (U+014F U+0054)
  0x01, 0x4F, 0x00, 0x56, 0x01, // ŏV (U+014F U+0056)
  0x01, 0x4F, 0x00, 0x57, 0x01, // ŏW (U+014F U+0057)
  0x01, 0x4F, 0x00, 0x59, 0x01, // ŏY (U+014F U+0059)
  0x01, 0x4F, 0x00, 0xDD, 0x01, // ŏÝ (U+014F U+00DD)
  0x01, 0x4F, 0x01, 0x74, 0x01, // ŏŴ (U+014F U+0174)
  0x01, 0x4F, 0x01, 0x76, 0x01, // ŏŶ (U+014F U+0176)
  0x01, 0x4F, 0x01, 0x78, 0x01, // ŏŸ (U+014F U+0178)
  0x01, 0x50, 0x00, 0x22, 0x01, // Ő" (U+0150 U+0022)
  0x01, 0x50, 0x00, 0x27, 0x01, // Ő' (U+0150 U+0027)
  0x01, 0x50, 0x00, 0x59, 0x01, // ŐY (U+0150 U+0059)
  0x01, 0x50, 0x00, 0xC6, 0x01, // ŐÆ (U+0150 U+00C6)
  0x01, 0x50, 0x00, 0xDD, 0x01, // ŐÝ (U+0150 U+00DD)
  0x01, 0x50, 0x01, 0x76, 0x01, // ŐŶ (U+0150 U+0176)
  0x01, 0x50, 0x01, 0x78, 0x01, // ŐŸ (U+0150 U+0178)
  0x01, 0x51, 0x00, 0x54, 0x01, // őT (U+0151 U+0054)
  0x01, 0x51, 0x00, 0x56, 0x01, // őV (U+0151 U+0056)
  0x01, 0x51, 0x00, 0x57, 0x01, // őW (U+0151 U+0057)
  0x01, 0x51, 0x00, 0x59, 0x01, // őY (U+0151 U+0059)
  0x01, 0x51, 0x00, 0xDD, 0x01, // őÝ (U+0151 U+00DD)
  0x01, 0x51, 0x01, 0x74, 0x01, // őŴ (U+0151 U+0174)
  0x01, 0x51, 0x01, 0x76, 0x01, // őŶ (U+0151 U+0176)
  0x01, 0x51, 0x01, 0x78, 0x01, // őŸ (U+0151 U+0178)
  0x01, 0x53, 0x00, 0x56, 0x01, // œV (U+0153 U+0056)
  0x01, 0x53, 0x00, 0x57, 0x01, // œW (U+0153 U+0057)
  0x01, 0x53, 0x00, 0x59, 0x01, // œY (U+0153 U+0059)
  0x01, 0x53, 0x00, 0xDD, 0x01, // œÝ (U+0153 U+00DD)
  0x01, 0x53, 0x01, 0x74, 0x01, // œŴ (U+0153 U+0174)
  0x01, 0x53, 0x01, 0x76, 0x01, // œŶ (U+0153 U+0176)
  0x01, 0x53, 0x01, 0x78, 0x01, // œŸ (U+0153 U+0178)
  0x01, 0x54, 0x00, 0x56, 0x01, // ŔV (U+0154 U+0056)
  0x01, 0x54, 0x00, 0x57, 0x01, // ŔW (U+0154 U+0057)
  0x01, 0x54, 0x00, 0x59, 0x01, // ŔY (U+0154 U+0059)
  0x01, 0x54, 0x00, 0xDD, 0x01, // ŔÝ (U+0154 U+00DD)
  0x01, 0x54, 0x01, 0x74, 0x01, // ŔŴ (U+0154 U+0174)
  0x01, 0x54, 0x01, 0x76, 0x01, // ŔŶ (U+0154 U+0176)
  0x01, 0x54, 0x01, 0x78, 0x01, // ŔŸ (U+0154 U+0178)
  0x01, 0x55, 0x00, 0x2C, 0x04, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x04, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x00, 0x56, 0x01, // ŕV (U+0155 U+0056)
  0x01, 0x55, 0x00, 0x57, 0x01, // ŕW (U+0155 U+0057)
  0x01, 0x55, 0x00, 0x58, 0x01, // ŕX (U+0155 U+0058)
  0x01, 0x55, 0x00, 0x59, 0x01, // ŕY (U+0155 U+0059)
  0x01, 0x55, 0x00, 0xDD, 0x01, // ŕÝ (U+0155 U+00DD)
  0x01, 0x55, 0x01, 0x74, 0x01, // ŕŴ (U+0155 U+0174)
  0x01, 0x55, 0x01, 0x76, 0x01, // ŕŶ (U+0155 U+0176)
  0x01, 0x55, 0x01, 0x78, 0x01, // ŕŸ (U+0155 U+0178)
  0x01, 0x55, 0x20, 0x1A, 0x04, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x04, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x04, // ŕ… (U+0155 U+2026)
  0x01, 0x56, 0x00, 0x56, 0x01, // ŖV (U+0156 U+0056)
  0x01, 0x56, 0x00, 0x57, 0x01, // ŖW (U+0156 U+0057)
  0x01, 0x56, 0x00, 0x59, 0x01, // ŖY (U+0156 U+0059)
  0x01, 0x56, 0x00, 0xDD, 0x01, // ŖÝ (U+0156 U+00DD)
  0x01, 0x56, 0x01, 0x74, 0x01, // ŖŴ (U+0156 U+0174)
  0x01, 0x56, 0x01, 0x76, 0x01, // ŖŶ (U+0156 U+0176)
  0x01, 0x56, 0x01, 0x78, 0x01, // ŖŸ (U+0156 U+0178)
  0x01, 0x57, 0x00, 0x2C, 0x04, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x04, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x00, 0x56, 0x01, // ŗV (U+0157 U+0056)
  0x01, 0x57, 0x00, 0x57, 0x01, // ŗW (U+0157 U+0057)
  0x01, 0x57, 0x00, 0x58, 0x01, // ŗX (U+0157 U+0058)
  0x01, 0x57, 0x00, 0x59, 0x01, // ŗY (U+0157 U+0059)
  0x01, 0x57, 0x00, 0xDD, 0x01, // ŗÝ (U+0157 U+00DD)
  0x01, 0x57, 0x01, 0x74, 0x01, // ŗŴ (U+0157 U+0174)
  0x01, 0x57, 0x01, 0x76, 0x01, // ŗŶ (U+0157 U+0176)
  0x01, 0x57, 0x01, 0x78, 0x01, // ŗŸ (U+0157 U+0178)
  0x01, 0x57, 0x20, 0x1A, 0x04, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x04, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x04, // ŗ… (U+0157 U+2026)
  0x01, 0x58, 0x00, 0x56, 0x01, // ŘV (U+0158 U+0056)
  0x01, 0x58, 0x00, 0x57, 0x01, // ŘW (U+0158 U+0057)
  0x01, 0x58, 0x00, 0x59, 0x01, // ŘY (U+0158 U+0059)
  0x01, 0x58, 0x00, 0xDD, 0x01, // ŘÝ (U+0158 U+00DD)
  0x01, 0x58, 0x01, 0x74, 0x01, // ŘŴ (U+0158 U+0174)
  0x01, 0x58, 0x01, 0x76, 0x01, // ŘŶ (U+0158 U+0176)
  0x01, 0x58, 0x01, 0x78, 0x01, // ŘŸ (U+0158 U+0178)
  0x01, 0x59, 0x00, 0x2C, 0x04, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x04, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x00, 0x56, 0x01, // řV (U+0159 U+0056)
  0x01, 0x59, 0x00, 0x57, 0x01, // řW (U+0159 U+0057)
  0x01, 0x59, 0x00, 0x58, 0x01, // řX (U+0159 U+0058)
  0x01, 0x59, 0x00, 0x59, 0x01, // řY (U+0159 U+0059)
  0x01, 0x59, 0x00, 0xDD, 0x01, // řÝ (U+0159 U+00DD)
  0x01, 0x59, 0x01, 0x74, 0x01, // řŴ (U+0159 U+0174)
  0x01, 0x59, 0x01, 0x76, 0x01, // řŶ (U+0159 U+0176)
  0x01, 0x59, 0x01, 0x78, 0x01, // řŸ (U+0159 U+0178)
  0x01, 0x59, 0x20, 0x1A, 0x04, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x04, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x04, // ř… (U+0159 U+2026)
  0x01, 0x5B, 0x00, 0x56, 0x01, // śV (U+015B U+0056)
  0x01, 0x5B, 0x00, 0x57, 0x01, // śW (U+015B U+0057)
  0x01, 0x5B, 0x00, 0x59, 0x01, // śY (U+015B U+0059)
  0x01, 0x5B, 0x00, 0xDD, 0x01, // śÝ (U+015B U+00DD)
  0x01, 0x5B, 0x01, 0x74, 0x01, // śŴ (U+015B U+0174)
  0x01, 0x5B, 0x01, 0x76, 0x01, // śŶ (U+015B U+0176)
  0x01, 0x5B, 0x01, 0x78, 0x01, // śŸ (U+015B U+0178)
  0x01, 0x5D, 0x00, 0x56, 0x01, // ŝV (U+015D U+0056)
  0x01, 0x5D, 0x00, 0x57, 0x01, // ŝW (U+015D U+0057)
  0x01, 0x5D, 0x00, 0x59, 0x01, // ŝY (U+015D U+0059)
  0x01, 0x5D, 0x00, 0xDD, 0x01, // ŝÝ (U+015D U+00DD)
  0x01, 0x5D, 0x01, 0x74, 0x01, // ŝŴ (U+015D U+0174)
  0x01, 0x5D, 0x01, 0x76, 0x01, // ŝŶ (U+015D U+0176)
  0x01, 0x5D, 0x01, 0x78, 0x01, // ŝŸ (U+015D U+0178)
  0x01, 0x5F, 0x00, 0x56, 0x01, // şV (U+015F U+0056)
  0x01, 0x5F, 0x00, 0x57, 0x01, // şW (U+015F U+0057)
  0x01, 0x5F, 0x00, 0x59, 0x01, // şY (U+015F U+0059)
  0x01, 0x5F, 0x00, 0xDD, 0x01, // şÝ (U+015F U+00DD)
  0x01, 0x5F, 0x01, 0x74, 0x01, // şŴ (U+015F U+0174)
  0x01, 0x5F, 0x01, 0x76, 0x01, // şŶ (U+015F U+0176)
  0x01, 0x5F, 0x01, 0x78, 0x01, // şŸ (U+015F U+0178)
  0x01, 0x61, 0x00, 0x56, 0x01, // šV (U+0161 U+0056)
  0x01, 0x61, 0x00, 0x57, 0x01, // šW (U+0161 U+0057)
  0x01, 0x61, 0x00, 0x59, 0x01, // šY (U+0161 U+0059)
  0x01, 0x61, 0x00, 0xDD, 0x01, // šÝ (U+0161 U+00DD)
  0x01, 0x61, 0x01, 0x74, 0x01, // šŴ (U+0161 U+0174)
  0x01, 0x61, 0x01, 0x76, 0x01, // šŶ (U+0161 U+0176)
  0x01, 0x61, 0x01, 0x78, 0x01, // šŸ (U+0161 U+0178)
  0x01, 0x62, 0x00, 0x2C, 0x02, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2E, 0x02, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0x41, 0x01, // ŢA (U+0162 U+0041)
  0x01, 0x62, 0x00, 0x61, 0x01, // Ţa (U+0162 U+0061)
  0x01, 0x62, 0x00, 0x63, 0x01, // Ţc (U+0162 U+0063)
  0x01, 0x62, 0x00, 0x64, 0x01, // Ţd (U+0162 U+0064)
  0x01, 0x62, 0x00, 0x65, 0x01, // Ţe (U+0162 U+0065)
  0x01, 0x62, 0x00, 0x67, 0x01, // Ţg (U+0162 U+0067)
  0x01, 0x62, 0x00, 0x6F, 0x01, // Ţo (U+0162 U+006F)
  0x01, 0x62, 0x00, 0x71, 0x01, // Ţq (U+0162 U+0071)
  0x01, 0x62, 0x00, 0xC0, 0x01, // ŢÀ (U+0162 U+00C0)
  0x01, 0x62, 0x00, 0xC1, 0x01, // ŢÁ (U+0162 U+00C1)
  0x01, 0x62, 0x00, 0xC2, 0x01, // ŢÂ (U+0162 U+00C2)
  0x01, 0x62, 0x00, 0xC3, 0x01, // ŢÃ (U+0162 U+00C3)
  0x01, 0x62, 0x00, 0xC4, 0x01, // ŢÄ (U+0162 U+00C4)
  0x01, 0x62, 0x00, 0xC5, 0x01, // ŢÅ (U+0162 U+00C5)
  0x01, 0x62, 0x00, 0xC6, 0x01, // ŢÆ (U+0162 U+00C6)
  0x01, 0x62, 0x00, 0xE0, 0x01, // Ţà (U+0162 U+00E0)
  0x01, 0x62, 0x00, 0xE1, 0x01, // Ţá (U+0162 U+00E1)
  0x01, 0x62, 0x00, 0xE2, 0x01, // Ţâ (U+0162 U+00E2)
  0x01, 0x62, 0x00, 0xE3, 0x01, // Ţã (U+0162 U+00E3)
  0x01, 0x62, 0x00, 0xE4, 0x01, // Ţä (U+0162 U+00E4)
  0x01, 0x62, 0x00, 0xE5, 0x01, // Ţå (U+0162 U+00E5)
  0x01, 0x62, 0x00, 0xE6, 0x01, // Ţæ (U+0162 U+00E6)
  0x01, 0x62, 0x00, 0xE7, 0x01, // Ţç (U+0162 U+00E7)
  0x01, 0x62, 0x00, 0xE8, 0x01, // Ţè (U+0162 U+00E8)
  0x01, 0x62, 0x00, 0xE9, 0x01, // Ţé (U+0162 U+00E9)
  0x01, 0x62, 0x00, 0xEA, 0x01, // Ţê (U+0162 U+00EA)
  0x01, 0x62, 0x00, 0xEB, 0x01, // Ţë (U+0162 U+00EB)
  0x01, 0x62, 0x00, 0xF0, 0x01, // Ţð (U+0162 U+00F0)
  0x01, 0x62, 0x00, 0xF2, 0x01, // Ţò (U+0162 U+00F2)
  0x01, 0x62, 0x00, 0xF3, 0x01, // Ţó (U+0162 U+00F3)
  0x01, 0x62, 0x00, 0xF4, 0x01, // Ţô (U+0162 U+00F4)
  0x01, 0x62, 0x00, 0xF5, 0x01, // Ţõ (U+0162 U+00F5)
  0x01, 0x62, 0x00, 0xF6, 0x01, // Ţö (U+0162 U+00F6)
  0x01, 0x62, 0x00, 0xF8, 0x01, // Ţø (U+0162 U+00F8)
  0x01, 0x62, 0x01, 0x00, 0x01, // ŢĀ (U+0162 U+0100)
  0x01, 0x62, 0x01, 0x01, 0x01, // Ţā (U+0162 U+0101)
  0x01, 0x62, 0x01, 0x02, 0x01, // ŢĂ (U+0162 U+0102)
  0x01, 0x62, 0x01, 0x03, 0x01, // Ţă (U+0162 U+0103)
  0x01, 0x62, 0x01, 0x04, 0x01, // ŢĄ (U+0162 U+0104)
  0x01, 0x62, 0x01, 0x05, 0x01, // Ţą (U+0162 U+0105)
  0x01, 0x62, 0x01, 0x07, 0x01, // Ţć (U+0162 U+0107)
  0x01, 0x62, 0x01, 0x09, 0x01, // Ţĉ (U+0162 U+0109)
  0x01, 0x62, 0x01, 0x0B, 0x01, // Ţċ (U+0162 U+010B)
  0x01, 0x62, 0x01, 0x0D, 0x01, // Ţč (U+0162 U+010D)
  0x01, 0x62, 0x01, 0x0F, 0x01, // Ţď (U+0162 U+010F)
  0x01, 0x62, 0x01, 0x11, 0x01, // Ţđ (U+0162 U+0111)
  0x01, 0x62, 0x01, 0x13, 0x01, // Ţē (U+0162 U+0113)
  0x01, 0x62, 0x01, 0x15, 0x01, // Ţĕ (U+0162 U+0115)
  0x01, 0x62, 0x01, 0x17, 0x01, // Ţė (U+0162 U+0117)
  0x01, 0x62, 0x01, 0x19, 0x01, // Ţę (U+0162 U+0119)
  0x01, 0x62, 0x01, 0x1B, 0x01, // Ţě (U+0162 U+011B)
  0x01, 0x62, 0x01, 0x1D, 0x01, // Ţĝ (U+0162 U+011D)
  0x01, 0x62, 0x01, 0x1F, 0x01, // Ţğ (U+0162 U+011F)
  0x01, 0x62, 0x01, 0x21, 0x01, // Ţġ (U+0162 U+0121)
  0x01, 0x62, 0x01, 0x23, 0x01, // Ţģ (U+0162 U+0123)
  0x01, 0x62, 0x01, 0x4D, 0x01, // Ţō (U+0162 U+014D)
  0x01, 0x62, 0x01, 0x4F, 0x01, // Ţŏ (U+0162 U+014F)
  0x01, 0x62, 0x01, 0x51, 0x01, // Ţő (U+0162 U+0151)
  0x01, 0x62, 0x01, 0x53, 0x01, // Ţœ (U+0162 U+0153)
  0x01, 0x62, 0x20, 0x1A, 0x02, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x02, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x02, // Ţ… (U+0162 U+2026)
  0x01, 0x64, 0x00, 0x2C, 0x02, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2E, 0x02, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0x41, 0x01, // ŤA (U+0164 U+0041)
  0x01, 0x64, 0x00, 0x61, 0x01, // Ťa (U+0164 U+0061)
  0x01, 0x64, 0x00, 0x63, 0x01, // Ťc (U+0164 U+0063)
  0x01, 0x64, 0x00, 0x64, 0x01, // Ťd (U+0164 U+0064)
  0x01, 0x64, 0x00, 0x65, 0x01, // Ťe (U+0164 U+0065)
  0x01, 0x64, 0x00, 0x67, 0x01, // Ťg (U+0164 U+0067)
  0x01, 0x64, 0x00, 0x6F, 0x01, // Ťo (U+0164 U+006F)
  0x01, 0x64, 0x00, 0x71, 0x01, // Ťq (U+0164 U+0071)
  0x01, 0x64, 0x00, 0xC0, 0x01, // ŤÀ (U+0164 U+00C0)
  0x01, 0x64, 0x00, 0xC1, 0x01, // ŤÁ (U+0164 U+00C1)
  0x01, 0x64, 0x00, 0xC2, 0x01, // ŤÂ (U+0164 U+00C2)
  0x01, 0x64, 0x00, 0xC3, 0x01, // ŤÃ (U+0164 U+00C3)
  0x01, 0x64, 0x00, 0xC4, 0x01, // ŤÄ (U+0164 U+00C4)
  0x01, 0x64, 0x00, 0xC5, 0x01, // ŤÅ (U+0164 U+00C5)
  0x01, 0x64, 0x00, 0xC6, 0x01, // ŤÆ (U+0164 U+00C6)
  0x01, 0x64, 0x00, 0xE0, 0x01, // Ťà (U+0164 U+00E0)
  0x01, 0x64, 0x00, 0xE1, 0x01, // Ťá (U+0164 U+00E1)
  0x01, 0x64, 0x00, 0xE2, 0x01, // Ťâ (U+0164 U+00E2)
  0x01, 0x64, 0x00, 0xE3, 0x01, // Ťã (U+0164 U+00E3)
  0x01, 0x64, 0x00, 0xE4, 0x01, // Ťä (U+0164 U+00E4)
  0x01, 0x64, 0x00, 0xE5, 0x01, // Ťå (U+0164 U+00E5)
  0x01, 0x64, 0x00, 0xE6, 0x01, // Ťæ (U+0164 U+00E6)
  0x01, 0x64, 0x00, 0xE7, 0x01, // Ťç (U+0164 U+00E7)
  0x01, 0x64, 0x00, 0xE8, 0x01, // Ťè (U+0164 U+00E8)
  0x01, 0x64, 0x00, 0xE9, 0x01, // Ťé (U+0164 U+00E9)
  0x01, 0x64, 0x00, 0xEA, 0x01, // Ťê (U+0164 U+00EA)
  0x01, 0x64, 0x00, 0xEB, 0x01, // Ťë (U+0164 U+00EB)
  0x01, 0x64, 0x00, 0xF0, 0x01, // Ťð (U+0164 U+00F0)
  0x01, 0x64, 0x00, 0xF2, 0x01, // Ťò (U+0164 U+00F2)
  0x01, 0x64, 0x00, 0xF3, 0x01, // Ťó (U+0164 U+00F3)
  0x01, 0x64, 0x00, 0xF4, 0x01, // Ťô (U+0164 U+00F4)
  0x01, 0x64, 0x00, 0xF5, 0x01, // Ťõ (U+0164 U+00F5)
  0x01, 0x64, 0x00, 0xF6, 0x01, // Ťö (U+0164 U+00F6)
  0x01, 0x64, 0x00, 0xF8, 0x01, // Ťø (U+0164 U+00F8)
  0x01, 0x64, 0x01, 0x00, 0x01, // ŤĀ (U+0164 U+0100)
  0x01, 0x64, 0x01, 0x01, 0x01, // Ťā (U+0164 U+0101)
  0x01, 0x64, 0x01, 0x02, 0x01, // ŤĂ (U+0164 U+0102)
  0x01, 0x64, 0x01, 0x03, 0x01, // Ťă (U+0164 U+0103)
  0x01, 0x64, 0x01, 0x04, 0x01, // ŤĄ (U+0164 U+0104)
  0x01, 0x64, 0x01, 0x05, 0x01, // Ťą (U+0164 U+0105)
  0x01, 0x64, 0x01, 0x07, 0x01, // Ťć (U+0164 U+0107)
  0x01, 0x64, 0x01, 0x09, 0x01, // Ťĉ (U+0164 U+0109)
  0x01, 0x64, 0x01, 0x0B, 0x01, // Ťċ (U+0164 U+010B)
  0x01, 0x64, 0x01, 0x0D, 0x01, // Ťč (U+0164 U+010D)
  0x01, 0x64, 0x01, 0x0F, 0x01, // Ťď (U+0164 U+010F)
  0x01, 0x64, 0x01, 0x11, 0x01, // Ťđ (U+0164 U+0111)
  0x01, 0x64, 0x01, 0x13, 0x01, // Ťē (U+0164 U+0113)
  0x01, 0x64, 0x01, 0x15, 0x01, // Ťĕ (U+0164 U+0115)
  0x01, 0x64, 0x01, 0x17, 0x01, // Ťė (U+0164 U+0117)
  0x01, 0x64, 0x01, 0x19, 0x01, // Ťę (U+0164 U+0119)
  0x01, 0x64, 0x01, 0x1B, 0x01, // Ťě (U+0164 U+011B)
  0x01, 0x64, 0x01, 0x1D, 0x01, // Ťĝ (U+0164 U+011D)
  0x01, 0x64, 0x01, 0x1F, 0x01, // Ťğ (U+0164 U+011F)
  0x01, 0x64, 0x01, 0x21, 0x01, // Ťġ (U+0164 U+0121)
  0x01, 0x64, 0x01, 0x23, 0x01, // Ťģ (U+0164 U+0123)
  0x01, 0x64, 0x01, 0x4D, 0x01, // Ťō (U+0164 U+014D)
  0x01, 0x64, 0x01, 0x4F, 0x01, // Ťŏ (U+0164 U+014F)
  0x01, 0x64, 0x01, 0x51, 0x01, // Ťő (U+0164 U+0151)
  0x01, 0x64, 0x01, 0x53, 0x01, // Ťœ (U+0164 U+0153)
  0x01, 0x64, 0x20, 0x1A, 0x02, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x02, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x02, // Ť… (U+0164 U+2026)
  0x01, 0x66, 0x00, 0x2C, 0x02, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2E, 0x02, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0x41, 0x01, // ŦA (U+0166 U+0041)
  0x01, 0x66, 0x00, 0x61, 0x01, // Ŧa (U+0166 U+0061)
  0x01, 0x66, 0x00, 0x63, 0x01, // Ŧc (U+0166 U+0063)
  0x01, 0x66, 0x00, 0x64, 0x01, // Ŧd (U+0166 U+0064)
  0x01, 0x66, 0x00, 0x65, 0x01, // Ŧe (U+0166 U+0065)
  0x01, 0x66, 0x00, 0x67, 0x01, // Ŧg (U+0166 U+0067)
  0x01, 0x66, 0x00, 0x6F, 0x01, // Ŧo (U+0166 U+006F)
  0x01, 0x66, 0x00, 0x71, 0x01, // Ŧq (U+0166 U+0071)
  0x01, 0x66, 0x00, 0xC0, 0x01, // ŦÀ (U+0166 U+00C0)
  0x01, 0x66, 0x00, 0xC1, 0x01, // ŦÁ (U+0166 U+00C1)
  0x01, 0x66, 0x00, 0xC2, 0x01, // ŦÂ (U+0166 U+00C2)
  0x01, 0x66, 0x00, 0xC3, 0x01, // ŦÃ (U+0166 U+00C3)
  0x01, 0x66, 0x00, 0xC4, 0x01, // ŦÄ (U+0166 U+00C4)
  0x01, 0x66, 0x00, 0xC5, 0x01, // ŦÅ (U+0166 U+00C5)
  0x01, 0x66, 0x00, 0xC6, 0x01, // ŦÆ (U+0166 U+00C6)
  0x01, 0x66, 0x00, 0xE0, 0x01, // Ŧà (U+0166 U+00E0)
  0x01, 0x66, 0x00, 0xE1, 0x01, // Ŧá (U+0166 U+00E1)
  0x01, 0x66, 0x00, 0xE2, 0x01, // Ŧâ (U+0166 U+00E2)
  0x01, 0x66, 0x00, 0xE3, 0x01, // Ŧã (U+0166 U+00E3)
  0x01, 0x66, 0x00, 0xE4, 0x01, // Ŧä (U+0166 U+00E4)
  0x01, 0x66, 0x00, 0xE5, 0x01, // Ŧå (U+0166 U+00E5)
  0x01, 0x66, 0x00, 0xE6, 0x01, // Ŧæ (U+0166 U+00E6)
  0x01, 0x66, 0x00, 0xE7, 0x01, // Ŧç (U+0166 U+00E7)
  0x01, 0x66, 0x00, 0xE8, 0x01, // Ŧè (U+0166 U+00E8)
  0x01, 0x66, 0x00, 0xE9, 0x01, // Ŧé (U+0166 U+00E9)
  0x01, 0x66, 0x00, 0xEA, 0x01, // Ŧê (U+0166 U+00EA)
  0x01, 0x66, 0x00, 0xEB, 0x01, // Ŧë (U+0166 U+00EB)
  0x01, 0x66, 0x00, 0xF0, 0x01, // Ŧð (U+0166 U+00F0)
  0x01, 0x66, 0x00, 0xF2, 0x01, // Ŧò (U+0166 U+00F2)
  0x01, 0x66, 0x00, 0xF3, 0x01, // Ŧó (U+0166 U+00F3)
  0x01, 0x66, 0x00, 0xF4, 0x01, // Ŧô (U+0166 U+00F4)
  0x01, 0x66, 0x00, 0xF5, 0x01, // Ŧõ (U+0166 U+00F5)
  0x01, 0x66, 0x00, 0xF6, 0x01, // Ŧö (U+0166 U+00F6)
  0x01, 0x66, 0x00, 0xF8, 0x01, // Ŧø (U+0166 U+00F8)
  0x01, 0x66, 0x01, 0x00, 0x01, // ŦĀ (U+0166 U+0100)
  0x01, 0x66, 0x01, 0x01, 0x01, // Ŧā (U+0166 U+0101)
  0x01, 0x66, 0x01, 0x02, 0x01, // ŦĂ (U+0166 U+0102)
  0x01, 0x66, 0x01, 0x03, 0x01, // Ŧă (U+0166 U+0103)
  0x01, 0x66, 0x01, 0x04, 0x01, // ŦĄ (U+0166 U+0104)
  0x01, 0x66, 0x01, 0x05, 0x01, // Ŧą (U+0166 U+0105)
  0x01, 0x66, 0x01, 0x07, 0x01, // Ŧć (U+0166 U+0107)
  0x01, 0x66, 0x01, 0x09, 0x01, // Ŧĉ (U+0166 U+0109)
  0x01, 0x66, 0x01, 0x0B, 0x01, // Ŧċ (U+0166 U+010B)
  0x01, 0x66, 0x01, 0x0D, 0x01, // Ŧč (U+0166 U+010D)
  0x01, 0x66, 0x01, 0x0F, 0x01, // Ŧď (U+0166 U+010F)
  0x01, 0x66, 0x01, 0x11, 0x01, // Ŧđ (U+0166 U+0111)
  0x01, 0x66, 0x01, 0x13, 0x01, // Ŧē (U+0166 U+0113)
  0x01, 0x66, 0x01, 0x15, 0x01, // Ŧĕ (U+0166 U+0115)
  0x01, 0x66, 0x01, 0x17, 0x01, // Ŧė (U+0166 U+0117)
  0x01, 0x66, 0x01, 0x19, 0x01, // Ŧę (U+0166 U+0119)
  0x01, 0x66, 0x01, 0x1B, 0x01, // Ŧě (U+0166 U+011B)
  0x01, 0x66, 0x01, 0x1D, 0x01, // Ŧĝ (U+0166 U+011D)
  0x01, 0x66, 0x01, 0x1F, 0x01, // Ŧğ (U+0166 U+011F)
  0x01, 0x66, 0x01, 0x21, 0x01, // Ŧġ (U+0166 U+0121)
  0x01, 0x66, 0x01, 0x23, 0x01, // Ŧģ (U+0166 U+0123)
  0x01, 0x66, 0x01, 0x4D, 0x01, // Ŧō (U+0166 U+014D)
  0x01, 0x66, 0x01, 0x4F, 0x01, // Ŧŏ (U+0166 U+014F)
  0x01, 0x66, 0x01, 0x51, 0x01, // Ŧő (U+0166 U+0151)
  0x01, 0x66, 0x01, 0x53, 0x01, // Ŧœ (U+0166 U+0153)
  0x01, 0x66, 0x20, 0x1A, 0x02, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x02, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x02, // Ŧ… (U+0166 U+2026)
  0x01, 0x69, 0x00, 0x22, 0x01, // ũ" (U+0169 U+0022)
  0x01, 0x69, 0x00, 0x27, 0x01, // ũ' (U+0169 U+0027)
  0x01, 0x69, 0x00, 0x56, 0x01, // ũV (U+0169 U+0056)
  0x01, 0x69, 0x00, 0x57, 0x01, // ũW (U+0169 U+0057)
  0x01, 0x69, 0x00, 0x59, 0x01, // ũY (U+0169 U+0059)
  0x01, 0x69, 0x00, 0xDD, 0x01, // ũÝ (U+0169 U+00DD)
  0x01, 0x69, 0x01, 0x74, 0x01, // ũŴ (U+0169 U+0174)
  0x01, 0x69, 0x01, 0x76, 0x01, // ũŶ (U+0169 U+0176)
  0x01, 0x69, 0x01, 0x78, 0x01, // ũŸ (U+0169 U+0178)
  0x01, 0x69, 0x20, 0x18, 0x01, // ũ‘ (U+0169 U+2018)
  0x01, 0x69, 0x20, 0x1C, 0x01, // ũ“ (U+0169 U+201C)
  0x01, 0x6B, 0x00, 0x22, 0x01, // ū" (U+016B U+0022)
  0x01, 0x6B, 0x00, 0x27, 0x01, // ū' (U+016B U+0027)
  0x01, 0x6B, 0x00, 0x56, 0x01, // ūV (U+016B U+0056)
  0x01, 0x6B, 0x00, 0x57, 0x01, // ūW (U+016B U+0057)
  0x01, 0x6B, 0x00, 0x59, 0x01, // ūY (U+016B U+0059)
  0x01, 0x6B, 0x00, 0xDD, 0x01, // ūÝ (U+016B U+00DD)
  0x01, 0x6B, 0x01, 0x74, 0x01, // ūŴ (U+016B U+0174)
  0x01, 0x6B, 0x01, 0x76, 0x01, // ūŶ (U+016B U+0176)
  0x01, 0x6B, 0x01, 0x78, 0x01, // ūŸ (U+016B U+0178)
  0x01, 0x6B, 0x20, 0x18, 0x01, // ū‘ (U+016B U+2018)
  0x01, 0x6B, 0x20, 0x1C, 0x01, // ū“ (U+016B U+201C)
  0x01, 0x6D, 0x00, 0x22, 0x01, // ŭ" (U+016D U+0022)
  0x01, 0x6D, 0x00, 0x27, 0x01, // ŭ' (U+016D U+0027)
  0x01, 0x6D, 0x00, 0x56, 0x01, // ŭV (U+016D U+0056)
  0x01, 0x6D, 0x00, 0x57, 0x01, // ŭW (U+016D U+0057)
  0x01, 0x6D, 0x00, 0x59, 0x01, // ŭY (U+016D U+0059)
  0x01, 0x6D, 0x00, 0xDD, 0x01, // ŭÝ (U+016D U+00DD)
  0x01, 0x6D, 0x01, 0x74, 0x01, // ŭŴ (U+016D U+0174)
  0x01, 0x6D, 0x01, 0x76, 0x01, // ŭŶ (U+016D U+0176)
  0x01, 0x6D, 0x01, 0x78, 0x01, // ŭŸ (U+016D U+0178)
  0x01, 0x6D, 0x20, 0x18, 0x01, // ŭ‘ (U+016D U+2018)
  0x01, 0x6D, 0x20, 0x1C, 0x01, // ŭ“ (U+016D U+201C)
  0x01, 0x6F, 0x00, 0x22, 0x01, // ů" (U+016F U+0022)
  0x01, 0x6F, 0x00, 0x27, 0x01, // ů' (U+016F U+0027)
  0x01, 0x6F, 0x00, 0x56, 0x01, // ůV (U+016F U+0056)
  0x01, 0x6F, 0x00, 0x57, 0x01, // ůW (U+016F U+0057)
  0x01, 0x6F, 0x00, 0x59, 0x01, // ůY (U+016F U+0059)
  0x01, 0x6F, 0x00, 0xDD, 0x01, // ůÝ (U+016F U+00DD)
  0x01, 0x6F, 0x01, 0x74, 0x01, // ůŴ (U+016F U+0174)
  0x01, 0x6F, 0x01, 0x76, 0x01, // ůŶ (U+016F U+0176)
  0x01, 0x6F, 0x01, 0x78, 0x01, // ůŸ (U+016F U+0178)
  0x01, 0x6F, 0x20, 0x18, 0x01, // ů‘ (U+016F U+2018)
  0x01, 0x6F, 0x20, 0x1C, 0x01, // ů“ (U+016F U+201C)
  0x01, 0x71, 0x00, 0x22, 0x01, // ű" (U+0171 U+0022)
  0x01, 0x71, 0x00, 0x27, 0x01, // ű' (U+0171 U+0027)
  0x01, 0x71, 0x00, 0x56, 0x01, // űV (U+0171 U+0056)
  0x01, 0x71, 0x00, 0x57, 0x01, // űW (U+0171 U+0057)
  0x01, 0x71, 0x00, 0x59, 0x01, // űY (U+0171 U+0059)
  0x01, 0x71, 0x00, 0xDD, 0x01, // űÝ (U+0171 U+00DD)
  0x01, 0x71, 0x01, 0x74, 0x01, // űŴ (U+0171 U+0174)
  0x01, 0x71, 0x01, 0x76, 0x01, // űŶ (U+0171 U+0176)
  0x01, 0x71, 0x01, 0x78, 0x01, // űŸ (U+0171 U+0178)
  0x01, 0x71, 0x20, 0x18, 0x01, // ű‘ (U+0171 U+2018)
  0x01, 0x71, 0x20, 0x1C, 0x01, // ű“ (U+0171 U+201C)
  0x01, 0x73, 0x00, 0x22, 0x01, // ų" (U+0173 U+0022)
  0x01, 0x73, 0x00, 0x27, 0x01, // ų' (U+0173 U+0027)
  0x01, 0x73, 0x00, 0x56, 0x01, // ųV (U+0173 U+0056)
  0x01, 0x73, 0x00, 0x57, 0x01, // ųW (U+0173 U+0057)
  0x01, 0x73, 0x00, 0x59, 0x01, // ųY (U+0173 U+0059)
  0x01, 0x73, 0x00, 0xDD, 0x01, // ųÝ (U+0173 U+00DD)
  0x01, 0x73, 0x01, 0x74, 0x01, // ųŴ (U+0173 U+0174)
  0x01, 0x73, 0x01, 0x76, 0x01, // ųŶ (U+0173 U+0176)
  0x01, 0x73, 0x01, 0x78, 0x01, // ųŸ (U+0173 U+0178)
  0x01, 0x73, 0x20, 0x18, 0x01, // ų‘ (U+0173 U+2018)
  0x01, 0x73, 0x20, 0x1C, 0x01, // ų“ (U+0173 U+201C)
  0x01, 0x74, 0x00, 0x26, 0x01, // Ŵ& (U+0174 U+0026)
  0x01, 0x74, 0x00, 0x2C, 0x02, // Ŵ, (U+0174 U+002C)
  0x01, 0x74, 0x00, 0x2E, 0x02, // Ŵ. (U+0174 U+002E)
  0x01, 0x74, 0x00, 0x41, 0x01, // ŴA (U+0174 U+0041)
  0x01, 0x74, 0x00, 0x61, 0x01, // Ŵa (U+0174 U+0061)
  0x01, 0x74, 0x00, 0x63, 0x01, // Ŵc (U+0174 U+0063)
  0x01, 0x74, 0x00, 0x64, 0x01, // Ŵd (U+0174 U+0064)
  0x01, 0x74, 0x00, 0x65, 0x01, // Ŵe (U+0174 U+0065)
  0x01, 0x74, 0x00, 0x67, 0x01, // Ŵg (U+0174 U+0067)
  0x01, 0x74, 0x00, 0x6F, 0x01, // Ŵo (U+0174 U+006F)
  0x01, 0x74, 0x00, 0x71, 0x01, // Ŵq (U+0174 U+0071)
  0x01, 0x74, 0x00, 0x73, 0x01, // Ŵs (U+0174 U+0073)
  0x01, 0x74, 0x00, 0xC0, 0x01, // ŴÀ (U+0174 U+00C0)
  0x01, 0x74, 0x00, 0xC1, 0x01, // ŴÁ (U+0174 U+00C1)
  0x01, 0x74, 0x00, 0xC2, 0x01, // ŴÂ (U+0174 U+00C2)
  0x01, 0x74, 0x00, 0xC3, 0x01, // ŴÃ (U+0174 U+00C3)
  0x01, 0x74, 0x00, 0xC4, 0x01, // ŴÄ (U+0174 U+00C4)
  0x01, 0x74, 0x00, 0xC5, 0x01, // ŴÅ (U+0174 U+00C5)
  0x01, 0x74, 0x00, 0xC6, 0x02, // ŴÆ (U+0174 U+00C6)
  0x01, 0x74, 0x00, 0xE0, 0x01, // Ŵà (U+0174 U+00E0)
  0x01, 0x74, 0x00, 0xE1, 0x01, // Ŵá (U+0174 U+00E1)
  0x01, 0x74, 0x00, 0xE2, 0x01, // Ŵâ (U+0174 U+00E2)
  0x01, 0x74, 0x00, 0xE3, 0x01, // Ŵã (U+0174 U+00E3)
  0x01, 0x74, 0x00, 0xE4, 0x01, // Ŵä (U+0174 U+00E4)
  0x01, 0x74, 0x00, 0xE5, 0x01, // Ŵå (U+0174 U+00E5)
  0x01, 0x74, 0x00, 0xE6, 0x01, // Ŵæ (U+0174 U+00E6)
  0x01, 0x74, 0x00, 0xE7, 0x01, // Ŵç (U+0174 U+00E7)
  0x01, 0x74, 0x00, 0xE8, 0x01, // Ŵè (U+0174 U+00E8)
  0x01, 0x74, 0x00, 0xE9, 0x01, // Ŵé (U+0174 U+00E9)
  0x01, 0x74, 0x00, 0xEA, 0x01, // Ŵê (U+0174 U+00EA)
  0x01, 0x74, 0x00, 0xEB, 0x01, // Ŵë (U+0174 U+00EB)
  0x01, 0x74, 0x00, 0xF0, 0x01, // Ŵð (U+0174 U+00F0)
  0x01, 0x74, 0x00, 0xF2, 0x01, // Ŵò (U+0174 U+00F2)
  0x01, 0x74, 0x00, 0xF3, 0x01, // Ŵó (U+0174 U+00F3)
  0x01, 0x74, 0x00, 0xF4, 0x01, // Ŵô (U+0174 U+00F4)
  0x01, 0x74, 0x00, 0xF5, 0x01, // Ŵõ (U+0174 U+00F5)
  0x01, 0x74, 0x00, 0xF6, 0x01, // Ŵö (U+0174 U+00F6)
  0x01, 0x74, 0x00, 0xF8, 0x01, // Ŵø (U+0174 U+00F8)
  0x01, 0x74, 0x01, 0x00, 0x01, // ŴĀ (U+0174 U+0100)
  0x01, 0x74, 0x01, 0x01, 0x01, // Ŵā (U+0174 U+0101)
  0x01, 0x74, 0x01, 0x02, 0x01, // ŴĂ (U+0174 U+0102)
  0x01, 0x74, 0x01, 0x03, 0x01, // Ŵă (U+0174 U+0103)
  0x01, 0x74, 0x01, 0x04, 0x01, // ŴĄ (U+0174 U+0104)
  0x01, 0x74, 0x01, 0x05, 0x01, // Ŵą (U+0174 U+0105)
  0x01, 0x74, 0x01, 0x07, 0x01, // Ŵć (U+0174 U+0107)
  0x01, 0x74, 0x01, 0x09, 0x01, // Ŵĉ (U+0174 U+0109)
  0x01, 0x74, 0x01, 0x0B, 0x01, // Ŵċ (U+0174 U+010B)
  0x01, 0x74, 0x01, 0x0D, 0x01, // Ŵč (U+0174 U+010D)
  0x01, 0x74, 0x01, 0x0F, 0x01, // Ŵď (U+0174 U+010F)
  0x01, 0x74, 0x01, 0x11, 0x01, // Ŵđ (U+0174 U+0111)
  0x01, 0x74, 0x01, 0x13, 0x01, // Ŵē (U+0174 U+0113)
  0x01, 0x74, 0x01, 0x15, 0x01, // Ŵĕ (U+0174 U+0115)
  0x01, 0x74, 0x01, 0x17, 0x01, // Ŵė (U+0174 U+0117)
  0x01, 0x74, 0x01, 0x19, 0x01, // Ŵę (U+0174 U+0119)
  0x01, 0x74, 0x01, 0x1B, 0x01, // Ŵě (U+0174 U+011B)
  0x01, 0x74, 0x01, 0x1D, 0x01, // Ŵĝ (U+0174 U+011D)
  0x01, 0x74, 0x01, 0x1F, 0x01, // Ŵğ (U+0174 U+011F)
  0x01, 0x74, 0x01, 0x21, 0x01, // Ŵġ (U+0174 U+0121)
  0x01, 0x74, 0x01, 0x23, 0x01, // Ŵģ (U+0174 U+0123)
  0x01, 0x74, 0x01, 0x4D, 0x01, // Ŵō (U+0174 U+014D)
  0x01, 0x74, 0x01, 0x4F, 0x01, // Ŵŏ (U+0174 U+014F)
  0x01, 0x74, 0x01, 0x51, 0x01, // Ŵő (U+0174 U+0151)
  0x01, 0x74, 0x01, 0x53, 0x01, // Ŵœ (U+0174 U+0153)
  0x01, 0x74, 0x01, 0x5B, 0x01, // Ŵś (U+0174 U+015B)
  0x01, 0x74, 0x01, 0x5D, 0x01, // Ŵŝ (U+0174 U+015D)
  0x01, 0x74, 0x01, 0x5F, 0x01, // Ŵş (U+0174 U+015F)
  0x01, 0x74, 0x01, 0x61, 0x01, // Ŵš (U+0174 U+0161)
  0x01, 0x74, 0x20, 0x1A, 0x02, // Ŵ‚ (U+0174 U+201A)
  0x01, 0x74, 0x20, 0x1E, 0x02, // Ŵ„ (U+0174 U+201E)
  0x01, 0x74, 0x20, 0x26, 0x02, // Ŵ… (U+0174 U+2026)
  0x01, 0x75, 0x00, 0x2C, 0x01, // ŵ, (U+0175 U+002C)
  0x01, 0x75, 0x00, 0x2E, 0x01, // ŵ. (U+0175 U+002E)
  0x01, 0x75, 0x00, 0x59, 0x01, // ŵY (U+0175 U+0059)
  0x01, 0x75, 0x00, 0xDD, 0x01, // ŵÝ (U+0175 U+00DD)
  0x01, 0x75, 0x01, 0x76, 0x01, // ŵŶ (U+0175 U+0176)
  0x01, 0x75, 0x01, 0x78, 0x01, // ŵŸ (U+0175 U+0178)
  0x01, 0x75, 0x20, 0x1A, 0x01, // ŵ‚ (U+0175 U+201A)
  0x01, 0x75, 0x20, 0x1E, 0x01, // ŵ„ (U+0175 U+201E)
  0x01, 0x75, 0x20, 0x26, 0x01, // ŵ… (U+0175 U+2026)
  0x01, 0x76, 0x00, 0x26, 0x01, // Ŷ& (U+0176 U+0026)
  0x01, 0x76, 0x00, 0x2C, 0x01, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x01, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x00, 0x41, 0x01, // ŶA (U+0176 U+0041)
  0x01, 0x76, 0x00, 0x43, 0x01, // ŶC (U+0176 U+0043)
  0x01, 0x76, 0x00, 0x47, 0x01, // ŶG (U+0176 U+0047)
  0x01, 0x76, 0x00, 0x4F, 0x01, // ŶO (U+0176 U+004F)
  0x01, 0x76, 0x00, 0x51, 0x01, // ŶQ (U+0176 U+0051)
  0x01, 0x76, 0x00, 0x61, 0x01, // Ŷa (U+0176 U+0061)
  0x01, 0x76, 0x00, 0x63, 0x01, // Ŷc (U+0176 U+0063)
  0x01, 0x76, 0x00, 0x64, 0x01, // Ŷd (U+0176 U+0064)
  0x01, 0x76, 0x00, 0x65, 0x01, // Ŷe (U+0176 U+0065)
  0x01, 0x76, 0x00, 0x67, 0x01, // Ŷg (U+0176 U+0067)
  0x01, 0x76, 0x00, 0x6F, 0x01, // Ŷo (U+0176 U+006F)
  0x01, 0x76, 0x00, 0x71, 0x01, // Ŷq (U+0176 U+0071)
  0x01, 0x76, 0x00, 0x73, 0x01, // Ŷs (U+0176 U+0073)
  0x01, 0x76, 0x00, 0xC0, 0x01, // ŶÀ (U+0176 U+00C0)
  0x01, 0x76, 0x00, 0xC1, 0x01, // ŶÁ (U+0176 U+00C1)
  0x01, 0x76, 0x00, 0xC2, 0x01, // ŶÂ (U+0176 U+00C2)
  0x01, 0x76, 0x00, 0xC3, 0x01, // ŶÃ (U+0176 U+00C3)
  0x01, 0x76, 0x00, 0xC4, 0x01, // ŶÄ (U+0176 U+00C4)
  0x01, 0x76, 0x00, 0xC5, 0x01, // ŶÅ (U+0176 U+00C5)
  0x01, 0x76, 0x00, 0xC6, 0x02, // ŶÆ (U+0176 U+00C6)
  0x01, 0x76, 0x00, 0xC7, 0x01, // ŶÇ (U+0176 U+00C7)
  0x01, 0x76, 0x00, 0xD2, 0x01, // ŶÒ (U+0176 U+00D2)
  0x01, 0x76, 0x00, 0xD3, 0x01, // ŶÓ (U+0176 U+00D3)
  0x01, 0x76, 0x00, 0xD4, 0x01, // ŶÔ (U+0176 U+00D4)
  0x01, 0x76, 0x00, 0xD5, 0x01, // ŶÕ (U+0176 U+00D5)
  0x01, 0x76, 0x00, 0xD6, 0x01, // ŶÖ (U+0176 U+00D6)
  0x01, 0x76, 0x00, 0xD8, 0x01, // ŶØ (U+0176 U+00D8)
  0x01, 0x76, 0x00, 0xE0, 0x01, // Ŷà (U+0176 U+00E0)
  0x01, 0x76, 0x00, 0xE1, 0x01, // Ŷá (U+0176 U+00E1)
  0x01, 0x76, 0x00, 0xE2, 0x01, // Ŷâ (U+0176 U+00E2)
  0x01, 0x76, 0x00, 0xE3, 0x01, // Ŷã (U+0176 U+00E3)
  0x01, 0x76, 0x00, 0xE4, 0x01, // Ŷä (U+0176 U+00E4)
  0x01, 0x76, 0x00, 0xE5, 0x01, // Ŷå (U+0176 U+00E5)
  0x01, 0x76, 0x00, 0xE6, 0x01, // Ŷæ (U+0176 U+00E6)
  0x01, 0x76, 0x00, 0xE7, 0x01, // Ŷç (U+0176 U+00E7)
  0x01, 0x76, 0x00, 0xE8, 0x01, // Ŷè (U+0176 U+00E8)
  0x01, 0x76, 0x00, 0xE9, 0x01, // Ŷé (U+0176 U+00E9)
  0x01, 0x76, 0x00, 0xEA, 0x01, // Ŷê (U+0176 U+00EA)
  0x01, 0x76, 0x00, 0xEB, 0x01, // Ŷë (U+0176 U+00EB)
  0x01, 0x76, 0x00, 0xF0, 0x01, // Ŷð (U+0176 U+00F0)
  0x01, 0x76, 0x00, 0xF2, 0x01, // Ŷò (U+0176 U+00F2)
  0x01, 0x76, 0x00, 0xF3, 0x01, // Ŷó (U+0176 U+00F3)
  0x01, 0x76, 0x00, 0xF4, 0x01, // Ŷô (U+0176 U+00F4)
  0x01, 0x76, 0x00, 0xF5, 0x01, // Ŷõ (U+0176 U+00F5)
  0x01, 0x76, 0x00, 0xF6, 0x01, // Ŷö (U+0176 U+00F6)
  0x01, 0x76, 0x00, 0xF8, 0x01, // Ŷø (U+0176 U+00F8)
  0x01, 0x76, 0x01, 0x00, 0x01, // ŶĀ (U+0176 U+0100)
  0x01, 0x76, 0x01, 0x01, 0x01, // Ŷā (U+0176 U+0101)
  0x01, 0x76, 0x01, 0x02, 0x01, // ŶĂ (U+0176 U+0102)
  0x01, 0x76, 0x01, 0x03, 0x01, // Ŷă (U+0176 U+0103)
  0x01, 0x76, 0x01, 0x04, 0x01, // ŶĄ (U+0176 U+0104)
  0x01, 0x76, 0x01, 0x05, 0x01, // Ŷą (U+0176 U+0105)
  0x01, 0x76, 0x01, 0x06, 0x01, // ŶĆ (U+0176 U+0106)
  0x01, 0x76, 0x01, 0x07, 0x01, // Ŷć (U+0176 U+0107)
  0x01, 0x76, 0x01, 0x08, 0x01, // ŶĈ (U+0176 U+0108)
  0x01, 0x76, 0x01, 0x09, 0x01, // Ŷĉ (U+0176 U+0109)
  0x01, 0x76, 0x01, 0x0A, 0x01, // ŶĊ (U+0176 U+010A)
  0x01, 0x76, 0x01, 0x0B, 0x01, // Ŷċ (U+0176 U+010B)
  0x01, 0x76, 0x01, 0x0C, 0x01, // ŶČ (U+0176 U+010C)
  0x01, 0x76, 0x01, 0x0D, 0x01, // Ŷč (U+0176 U+010D)
  0x01, 0x76, 0x01, 0x0F, 0x01, // Ŷď (U+0176 U+010F)
  0x01, 0x76, 0x01, 0x11, 0x01, // Ŷđ (U+0176 U+0111)
  0x01, 0x76, 0x01, 0x13, 0x01, // Ŷē (U+0176 U+0113)
  0x01, 0x76, 0x01, 0x15, 0x01, // Ŷĕ (U+0176 U+0115)
  0x01, 0x76, 0x01, 0x17, 0x01, // Ŷė (U+0176 U+0117)
  0x01, 0x76, 0x01, 0x19, 0x01, // Ŷę (U+0176 U+0119)
  0x01, 0x76, 0x01, 0x1B, 0x01, // Ŷě (U+0176 U+011B)
  0x01, 0x76, 0x01, 0x1C, 0x01, // ŶĜ (U+0176 U+011C)
  0x01, 0x76, 0x01, 0x1D, 0x01, // Ŷĝ (U+0176 U+011D)
  0x01, 0x76, 0x01, 0x1E, 0x01, // ŶĞ (U+0176 U+011E)
  0x01, 0x76, 0x01, 0x1F, 0x01, // Ŷğ (U+0176 U+011F)
  0x01, 0x76, 0x01, 0x20, 0x01, // ŶĠ (U+0176 U+0120)
  0x01, 0x76, 0x01, 0x21, 0x01, // Ŷġ (U+0176 U+0121)
  0x01, 0x76, 0x01, 0x22, 0x01, // ŶĢ (U+0176 U+0122)
  0x01, 0x76, 0x01, 0x23, 0x01, // Ŷģ (U+0176 U+0123)
  0x01, 0x76, 0x01, 0x4C, 0x01, // ŶŌ (U+0176 U+014C)
  0x01, 0x76, 0x01, 0x4D, 0x01, // Ŷō (U+0176 U+014D)
  0x01, 0x76, 0x01, 0x4E, 0x01, // ŶŎ (U+0176 U+014E)
  0x01, 0x76, 0x01, 0x4F, 0x01, // Ŷŏ (U+0176 U+014F)
  0x01, 0x76, 0x01, 0x50, 0x01, // ŶŐ (U+0176 U+0150)
  0x01, 0x76, 0x01, 0x51, 0x01, // Ŷő (U+0176 U+0151)
  0x01, 0x76, 0x01, 0x52, 0x01, // ŶŒ (U+0176 U+0152)
  0x01, 0x76, 0x01, 0x53, 0x01, // Ŷœ (U+0176 U+0153)
  0x01, 0x76, 0x01, 0x5B, 0x01, // Ŷś (U+0176 U+015B)
  0x01, 0x76, 0x01, 0x5D, 0x01, // Ŷŝ (U+0176 U+015D)
  0x01, 0x76, 0x01, 0x5F, 0x01, // Ŷş (U+0176 U+015F)
  0x01, 0x76, 0x01, 0x61, 0x01, // Ŷš (U+0176 U+0161)
  0x01, 0x76, 0x20, 0x1A, 0x01, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x01, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x01, // Ŷ… (U+0176 U+2026)
  0x01, 0x77, 0x00, 0x2C, 0x02, // ŷ, (U+0177 U+002C)
  0x01, 0x77, 0x00, 0x2E, 0x02, // ŷ. (U+0177 U+002E)
  0x01, 0x77, 0x20, 0x1A, 0x02, // ŷ‚ (U+0177 U+201A)
  0x01, 0x77, 0x20, 0x1E, 0x02, // ŷ„ (U+0177 U+201E)
  0x01, 0x77, 0x20, 0x26, 0x02, // ŷ… (U+0177 U+2026)
  0x01, 0x78, 0x00, 0x26, 0x01, // Ÿ& (U+0178 U+0026)
  0x01, 0x78, 0x00, 0x2C, 0x01, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x01, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x00, 0x41, 0x01, // ŸA (U+0178 U+0041)
  0x01, 0x78, 0x00, 0x43, 0x01, // ŸC (U+0178 U+0043)
  0x01, 0x78, 0x00, 0x47, 0x01, // ŸG (U+0178 U+0047)
  0x01, 0x78, 0x00, 0x4F, 0x01, // ŸO (U+0178 U+004F)
  0x01, 0x78, 0x00, 0x51, 0x01, // ŸQ (U+0178 U+0051)
  0x01, 0x78, 0x00, 0x61, 0x01, // Ÿa (U+0178 U+0061)
  0x01, 0x78, 0x00, 0x63, 0x01, // Ÿc (U+0178 U+0063)
  0x01, 0x78, 0x00, 0x64, 0x01, // Ÿd (U+0178 U+0064)
  0x01, 0x78, 0x00, 0x65, 0x01, // Ÿe (U+0178 U+0065)
  0x01, 0x78, 0x00, 0x67, 0x01, // Ÿg (U+0178 U+0067)
  0x01, 0x78, 0x00, 0x6F, 0x01, // Ÿo (U+0178 U+006F)
  0x01, 0x78, 0x00, 0x71, 0x01, // Ÿq (U+0178 U+0071)
  0x01, 0x78, 0x00, 0x73, 0x01, // Ÿs (U+0178 U+0073)
  0x01, 0x78, 0x00, 0xC0, 0x01, // ŸÀ (U+0178 U+00C0)
  0x01, 0x78, 0x00, 0xC1, 0x01, // ŸÁ (U+0178 U+00C1)
  0x01, 0x78, 0x00, 0xC2, 0x01, // ŸÂ (U+0178 U+00C2)
  0x01, 0x78, 0x00, 0xC3, 0x01, // ŸÃ (U+0178 U+00C3)
  0x01, 0x78, 0x00, 0xC4, 0x01, // ŸÄ (U+0178 U+00C4)
  0x01, 0x78, 0x00, 0xC5, 0x01, // ŸÅ (U+0178 U+00C5)
  0x01, 0x78, 0x00, 0xC6, 0x02, // ŸÆ (U+0178 U+00C6)
  0x01, 0x78, 0x00, 0xC7, 0x01, // ŸÇ (U+0178 U+00C7)
  0x01, 0x78, 0x00, 0xD2, 0x01, // ŸÒ (U+0178 U+00D2)
  0x01, 0x78, 0x00, 0xD3, 0x01, // ŸÓ (U+0178 U+00D3)
  0x01, 0x78, 0x00, 0xD4, 0x01, // ŸÔ (U+0178 U+00D4)
  0x01, 0x78, 0x00, 0xD5, 0x01, // ŸÕ (U+0178 U+00D5)
  0x01, 0x78, 0x00, 0xD6, 0x01, // ŸÖ (U+0178 U+00D6)
  0x01, 0x78, 0x00, 0xD8, 0x01, // ŸØ (U+0178 U+00D8)
  0x01, 0x78, 0x00, 0xE0, 0x01, // Ÿà (U+0178 U+00E0)
  0x01, 0x78, 0x00, 0xE1, 0x01, // Ÿá (U+0178 U+00E1)
  0x01, 0x78, 0x00, 0xE2, 0x01, // Ÿâ (U+0178 U+00E2)
  0x01, 0x78, 0x00, 0xE3, 0x01, // Ÿã (U+0178 U+00E3)
  0x01, 0x78, 0x00, 0xE4, 0x01, // Ÿä (U+0178 U+00E4)
  0x01, 0x78, 0x00, 0xE5, 0x01, // Ÿå (U+0178 U+00E5)
  0x01, 0x78, 0x00, 0xE6, 0x01, // Ÿæ (U+0178 U+00E6)
  0x01, 0x78, 0x00, 0xE7, 0x01, // Ÿç (U+0178 U+00E7)
  0x01, 0x78, 0x00, 0xE8, 0x01, // Ÿè (U+0178 U+00E8)
  0x01, 0x78, 0x00, 0xE9, 0x01, // Ÿé (U+0178 U+00E9)
  0x01, 0x78, 0x00, 0xEA, 0x01, // Ÿê (U+0178 U+00EA)
  0x01, 0x78, 0x00, 0xEB, 0x01, // Ÿë (U+0178 U+00EB)
  0x01, 0x78, 0x00, 0xF0, 0x01, // Ÿð (U+0178 U+00F0)
  0x01, 0x78, 0x00, 0xF2, 0x01, // Ÿò (U+0178 U+00F2)
  0x01, 0x78, 0x00, 0xF3, 0x01, // Ÿó (U+0178 U+00F3)
  0x01, 0x78, 0x00, 0xF4, 0x01, // Ÿô (U+0178 U+00F4)
  0x01, 0x78, 0x00, 0xF5, 0x01, // Ÿõ (U+0178 U+00F5)
  0x01, 0x78, 0x00, 0xF6, 0x01, // Ÿö (U+0178 U+00F6)
  0x01, 0x78, 0x00, 0xF8, 0x01, // Ÿø (U+0178 U+00F8)
  0x01, 0x78, 0x01, 0x00, 0x01, // ŸĀ (U+0178 U+0100)
  0x01, 0x78, 0x01, 0x01, 0x01, // Ÿā (U+0178 U+0101)
  0x01, 0x78, 0x01, 0x02, 0x01, // ŸĂ (U+0178 U+0102)
  0x01, 0x78, 0x01, 0x03, 0x01, // Ÿă (U+0178 U+0103)
  0x01, 0x78, 0x01, 0x04, 0x01, // ŸĄ (U+0178 U+0104)
  0x01, 0x78, 0x01, 0x05, 0x01, // Ÿą (U+0178 U+0105)
  0x01, 0x78, 0x01, 0x06, 0x01, // ŸĆ (U+0178 U+0106)
  0x01, 0x78, 0x01, 0x07, 0x01, // Ÿć (U+0178 U+0107)
  0x01, 0x78, 0x01, 0x08, 0x01, // ŸĈ (U+0178 U+0108)
  0x01, 0x78, 0x01, 0x09, 0x01, // Ÿĉ (U+0178 U+0109)
  0x01, 0x78, 0x01, 0x0A, 0x01, // ŸĊ (U+0178 U+010A)
  0x01, 0x78, 0x01, 0x0B, 0x01, // Ÿċ (U+0178 U+010B)
  0x01, 0x78, 0x01, 0x0C, 0x01, // ŸČ (U+0178 U+010C)
  0x01, 0x78, 0x01, 0x0D, 0x01, // Ÿč (U+0178 U+010D)
  0x01, 0x78, 0x01, 0x0F, 0x01, // Ÿď (U+0178 U+010F)
  0x01, 0x78, 0x01, 0x11, 0x01, // Ÿđ (U+0178 U+0111)
  0x01, 0x78, 0x01, 0x13, 0x01, // Ÿē (U+0178 U+0113)
  0x01, 0x78, 0x01, 0x15, 0x01, // Ÿĕ (U+0178 U+0115)
  0x01, 0x78, 0x01, 0x17, 0x01, // Ÿė (U+0178 U+0117)
  0x01, 0x78, 0x01, 0x19, 0x01, // Ÿę (U+0178 U+0119)
  0x01, 0x78, 0x01, 0x1B, 0x01, // Ÿě (U+0178 U+011B)
  0x01, 0x78, 0x01, 0x1C, 0x01, // ŸĜ (U+0178 U+011C)
  0x01, 0x78, 0x01, 0x1D, 0x01, // Ÿĝ (U+0178 U+011D)
  0x01, 0x78, 0x01, 0x1E, 0x01, // ŸĞ (U+0178 U+011E)
  0x01, 0x78, 0x01, 0x1F, 0x01, // Ÿğ (U+0178 U+011F)
  0x01, 0x78, 0x01, 0x20, 0x01, // ŸĠ (U+0178 U+0120)
  0x01, 0x78, 0x01, 0x21, 0x01, // Ÿġ (U+0178 U+0121)
  0x01, 0x78, 0x01, 0x22, 0x01, // ŸĢ (U+0178 U+0122)
  0x01, 0x78, 0x01, 0x23, 0x01, // Ÿģ (U+0178 U+0123)
  0x01, 0x78, 0x01, 0x4C, 0x01, // ŸŌ (U+0178 U+014C)
  0x01, 0x78, 0x01, 0x4D, 0x01, // Ÿō (U+0178 U+014D)
  0x01, 0x78, 0x01, 0x4E, 0x01, // ŸŎ (U+0178 U+014E)
  0x01, 0x78, 0x01, 0x4F, 0x01, // Ÿŏ (U+0178 U+014F)
  0x01, 0x78, 0x01, 0x50, 0x01, // ŸŐ (U+0178 U+0150)
  0x01, 0x78, 0x01, 0x51, 0x01, // Ÿő (U+0178 U+0151)
  0x01, 0x78, 0x01, 0x52, 0x01, // ŸŒ (U+0178 U+0152)
  0x01, 0x78, 0x01, 0x53, 0x01, // Ÿœ (U+0178 U+0153)
  0x01, 0x78, 0x01, 0x5B, 0x01, // Ÿś (U+0178 U+015B)
  0x01, 0x78, 0x01, 0x5D, 0x01, // Ÿŝ (U+0178 U+015D)
  0x01, 0x78, 0x01, 0x5F, 0x01, // Ÿş (U+0178 U+015F)
  0x01, 0x78, 0x01, 0x61, 0x01, // Ÿš (U+0178 U+0161)
  0x01, 0x78, 0x20, 0x1A, 0x01, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x01, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x01, // Ÿ… (U+0178 U+2026)
  0x01, 0x7A, 0x00, 0x56, 0x01, // źV (U+017A U+0056)
  0x01, 0x7A, 0x00, 0x57, 0x01, // źW (U+017A U+0057)
  0x01, 0x7A, 0x00, 0x59, 0x01, // źY (U+017A U+0059)
  0x01, 0x7A, 0x00, 0xDD, 0x01, // źÝ (U+017A U+00DD)
  0x01, 0x7A, 0x01, 0x74, 0x01, // źŴ (U+017A U+0174)
  0x01, 0x7A, 0x01, 0x76, 0x01, // źŶ (U+017A U+0176)
  0x01, 0x7A, 0x01, 0x78, 0x01, // źŸ (U+017A U+0178)
  0x01, 0x7C, 0x00, 0x56, 0x01, // żV (U+017C U+0056)
  0x01, 0x7C, 0x00, 0x57, 0x01, // żW (U+017C U+0057)
  0x01, 0x7C, 0x00, 0x59, 0x01, // żY (U+017C U+0059)
  0x01, 0x7C, 0x00, 0xDD, 0x01, // żÝ (U+017C U+00DD)
  0x01, 0x7C, 0x01, 0x74, 0x01, // żŴ (U+017C U+0174)
  0x01, 0x7C, 0x01, 0x76, 0x01, // żŶ (U+017C U+0176)
  0x01, 0x7C, 0x01, 0x78, 0x01, // żŸ (U+017C U+0178)
  0x01, 0x7E, 0x00, 0x56, 0x01, // žV (U+017E U+0056)
  0x01, 0x7E, 0x00, 0x57, 0x01, // žW (U+017E U+0057)
  0x01, 0x7E, 0x00, 0x59, 0x01, // žY (U+017E U+0059)
  0x01, 0x7E, 0x00, 0xDD, 0x01, // žÝ (U+017E U+00DD)
  0x01, 0x7E, 0x01, 0x74, 0x01, // žŴ (U+017E U+0174)
  0x01, 0x7E, 0x01, 0x76, 0x01, // žŶ (U+017E U+0176)
  0x01, 0x7E, 0x01, 0x78, 0x01, // žŸ (U+017E U+0178)
  0x20, 0x18, 0x00, 0x41, 0x01, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0xC0, 0x01, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x01, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x01, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x01, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x01, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x01, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xC6, 0x03, // ‘Æ (U+2018 U+00C6)
  0x20, 0x18, 0x01, 0x00, 0x01, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x02, 0x01, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x04, 0x01, // ‘Ą (U+2018 U+0104)
  0x20, 0x19, 0x00, 0x41, 0x02, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0x73, 0x01, // ’s (U+2019 U+0073)
  0x20, 0x19, 0x00, 0xC0, 0x02, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x02, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x02, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x02, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x02, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x02, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xC6, 0x03, // ’Æ (U+2019 U+00C6)
  0x20, 0x19, 0x01, 0x00, 0x02, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x02, 0x02, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x04, 0x02, // ’Ą (U+2019 U+0104)
  0x20, 0x19, 0x01, 0x5B, 0x01, // ’ś (U+2019 U+015B)
  0x20, 0x19, 0x01, 0x5D, 0x01, // ’ŝ (U+2019 U+015D)
  0x20, 0x19, 0x01, 0x5F, 0x01, // ’ş (U+2019 U+015F)
  0x20, 0x19, 0x01, 0x61, 0x01, // ’š (U+2019 U+0161)
  0x20, 0x1A, 0x00, 0x54, 0x01, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x56, 0x02, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x01, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x01, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0x76, 0x01, // ‚v (U+201A U+0076)
  0x20, 0x1A, 0x00, 0xDD, 0x01, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x01, 0x74, 0x01, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x76, 0x01, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x78, 0x01, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x01, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0xC0, 0x01, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x01, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x01, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x01, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x01, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x01, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xC6, 0x03, // “Æ (U+201C U+00C6)
  0x20, 0x1C, 0x01, 0x00, 0x01, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x02, 0x01, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x04, 0x01, // “Ą (U+201C U+0104)
  0x20, 0x1D, 0x00, 0x41, 0x02, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0x73, 0x01, // ”s (U+201D U+0073)
  0x20, 0x1D, 0x00, 0xC0, 0x02, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x02, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x02, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x02, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x02, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x02, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xC6, 0x03, // ”Æ (U+201D U+00C6)
  0x20, 0x1D, 0x01, 0x00, 0x02, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x02, 0x02, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x04, 0x02, // ”Ą (U+201D U+0104)
  0x20, 0x1D, 0x01, 0x5B, 0x01, // ”ś (U+201D U+015B)
  0x20, 0x1D, 0x01, 0x5D, 0x01, // ”ŝ (U+201D U+015D)
  0x20, 0x1D, 0x01, 0x5F, 0x01, // ”ş (U+201D U+015F)
  0x20, 0x1D, 0x01, 0x61, 0x01, // ”š (U+201D U+0161)
  0x20, 0x1E, 0x00, 0x54, 0x01, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x56, 0x02, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x01, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x01, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0x76, 0x01, // „v (U+201E U+0076)
  0x20, 0x1E, 0x00, 0xDD, 0x01, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x01, 0x74, 0x01, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x76, 0x01, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x78, 0x01, // „Ÿ (U+201E U+0178)
  
  // Glyph data
  // "!" (U+0021)
  0x20, 0x4A, 0x0B, 0x20, 0x6A, 0x06, 0x20, 0x8A, 0x01, 0x28, 0x1A, 0xFB, 0x38, 0x1B, 0xF6, 0x38,
  0x1D, 0xF1, 0x39, 0x0B, 0x38, 0x12, 0xF5, 0x38, 0x13, 0xF1, 0x71, 0x82, 0x2C, 0xC1, 0x20, 0x8A,
  0x05, 0x28, 0x24, 0xEC, 0x12,
  // """ (U+0022)
  0x0D, 0xFB, 0x0E, 0xFA, 0x0E, 0xF5, 0x0F, 0xF4, 0x0F, 0xE0, 0x1F, 0xD0, 0x2F, 0x80, 0x3F, 0x70,
  0x3F, 0x20, 0x4F, 0x10,
  // "#" (U+0023)
  0x48, 0x42, 0xF2, 0x0E, 0x45, 0x83, 0x7C, 0x05, 0xE6, 0x83, 0xC7, 0x0A, 0x93, 0x05, 0xF9, 0x89,
  0x11, 0x01, 0x39, 0xD3, 0x7F, 0x33, 0x48, 0x3A, 0x90, 0x8B, 0x68, 0x3E, 0x40, 0xC7, 0x58, 0x43,
  0xF1, 0x1F, 0x33, 0x06, 0xF9, 0x28, 0x71, 0x3D, 0x93, 0xBB, 0x33, 0x38, 0x41, 0xF3, 0x0D, 0x55,
  0x84, 0x5E, 0x02, 0xF1, 0x58, 0x39, 0xA0, 0x7C, 0x50,
  // "$" (U+0024)
  0x60, 0x90, 0x56, 0x83, 0x58, 0xEA, 0x53, 0x86, 0x2D, 0xF9, 0xED, 0xFB, 0x28, 0x6A, 0xF8, 0x4B,
  0x4F, 0xE2, 0x86, 0xDF, 0x87, 0x81, 0xA4, 0x20, 0xBA, 0x0D, 0x04, 0x50, 0x4B, 0x0B, 0x02, 0x50,
  0x30, 0xDA, 0x0E, 0x03, 0x50, 0x50, 0xDA, 0x87, 0xC0, 0x2C, 0x70, 0x87, 0x7A, 0x18, 0x91, 0x7F,
  0xA0, 0xB3, 0x4F, 0xE0, 0x5A, 0x84, 0x6E, 0x1B, 0xF6, 0x20, 0x8C, 0x0C, 0x05, 0x50, 0x70, 0xA7,
  0x10, 0x80, 0x67, 0x10, 0x50, 0x25,
  // "%" (U+0025)
  0x00, 0x5D, 0xEC, 0x20, 0x00, 0x3E, 0x20, 0x00, 0x6F, 0xA5, 0xFC, 0x00, 0x0D, 0x70, 0x00, 0x0E,
  0xE1, 0x0D, 0xF0, 0x08, 0xC0, 0x00, 0x05, 0xF9, 0x00, 0xEE, 0x04, 0xE2, 0x00, 0x00, 0x8F, 0x50,
  0x2F, 0xB0, 0xD6, 0x00, 0x00, 0x0A, 0xF3, 0x07, 0xF6, 0x9B, 0x2B, 0xFE, 0x80, 0x8F, 0x73, 0xEC,
  0x5E, 0x3D, 0xE5, 0xAF, 0x41, 0xCF, 0xFB, 0x3E, 0x58, 0xF6, 0x05, 0xF7, 0x00, 0x21, 0x0A, 0xA0,
  0xEF, 0x00, 0x7F, 0x60, 0x00, 0x05, 0xE1, 0x1F, 0xC0, 0x0B, 0xF3, 0x00, 0x01, 0xE5, 0x03, 0xFB,
  0x02, 0xFC, 0x00, 0x00, 0xBA, 0x00, 0x0E, 0xE4, 0xCF, 0x30, 0x00, 0x6D, 0x10, 0x00, 0x4D, 0xEB,
  0x30, 0x00,
  // "&" (U+0026)
  0x48, 0x51, 0x9D, 0xFE, 0xA1, 0x71, 0x85, 0xDF, 0xC4, 0xAF, 0xB7, 0x04, 0xA8, 0x33, 0x02, 0xFD,
  0x70, 0x3A, 0x83, 0x30, 0x4F, 0x87, 0x18, 0x4E, 0xF7, 0x3D, 0x87, 0x10, 0x10, 0xBA, 0x82, 0xB1,
  0x07, 0xB0, 0x22, 0x89, 0x28, 0xEF, 0xEF, 0xE2, 0x0A, 0xF9, 0x42, 0x83, 0xBF, 0xE3, 0x2A, 0x82,
  0xC1, 0xEA, 0x30, 0x3A, 0x07, 0x20, 0x6A, 0x81, 0xCF, 0x23, 0x05, 0xA0, 0x43, 0x09, 0xA0, 0x94,
  0x03, 0xA0, 0x73, 0x01, 0xB0, 0x34, 0x86, 0xBF, 0xE7, 0x46, 0xEB, 0xA8, 0x1E, 0x61, 0x38, 0x68,
  0xDF, 0xEB, 0x50, 0x8B, 0x04, 0x10,
  // "'" (U+0027)
  0x0F, 0xF9, 0x1F, 0xF3, 0x2F, 0xD0, 0x3F, 0x70, 0x3F, 0x10,
  // "(" (U+0028)
  0x68, 0x13, 0x92, 0x48, 0x21, 0xAF, 0xA4, 0x82, 0x2D, 0xF8, 0x58, 0x1C, 0xFC, 0x50, 0x8A, 0x03,
  0x40, 0x2A, 0x0B, 0x50, 0x7A, 0x06, 0x50, 0xCA, 0x01, 0x5A, 0x0D, 0x50, 0x2A, 0x0A, 0x50, 0x3A,
  0x09, 0x50, 0x2A, 0x08, 0x68, 0x1E, 0xF9, 0x68, 0x19, 0xFD, 0x68, 0x21, 0xDF, 0x56, 0x81, 0x2C,
  0xE7, 0x10, 0x44,
  // ")" (U+0029)
  0x30, 0x50, 0x86, 0x82, 0x4F, 0xD1, 0x58, 0x19, 0xFC, 0x50, 0x3A, 0x04, 0x40, 0x1A, 0x09, 0x5A,
  0x0B, 0x40, 0x1A, 0x0B, 0x40, 0x4A, 0x09, 0x40, 0x7A, 0x06, 0x40, 0xAA, 0x03, 0x4A, 0x0D, 0x40,
  0x5A, 0x06, 0x48, 0x1D, 0xFC, 0x48, 0x28, 0xFE, 0x23, 0x82, 0x7F, 0xD2, 0x38, 0x28, 0xF9, 0x14,
  0x04, 0x01, 0x60,
  // "*" (U+002A)
  0x28, 0x32, 0x09, 0xC2, 0x38, 0x39, 0xE2, 0x9D, 0x48, 0x92, 0x6D, 0xDB, 0x77, 0xD4, 0x27, 0x8E,
  0xC0, 0x70, 0x2A, 0x83, 0xAE, 0xE8, 0x12, 0x86, 0x71, 0x6D, 0x4F, 0xE1, 0x38, 0x3C, 0xD0, 0x56,
  0x40, 0x40, 0x64,
  // "+" (U+002B)
  0x30, 0x90, 0xA6, 0x09, 0x0A, 0x60, 0x90, 0xA3, 0x0C, 0xE8, 0x4D, 0x23, 0x3B, 0xB0, 0xF3, 0x30,
  0x90, 0xA6, 0x09, 0x0A, 0x60, 0x90, 0xA3,
  // "," (U+002C)
  0x00, 0xCE, 0x30, 0x2F, 0xF9, 0x00, 0x8F, 0x70, 0x06, 0xE1, 0x09, 0xD3, 0x01, 0x40, 0x00,
  // "-" (U+002D)
  0x7E, 0xEE, 0xE2, 0xBF, 0xFF, 0xE0,
  // "." (U+002E)
  0x0B, 0xD4, 0x5F, 0xF9, 0x2D, 0xE3,
  // "/" (U+002F)
  0x70, 0x60, 0xE7, 0x0D, 0x07, 0x68, 0x16, 0xE1, 0x60, 0xD0, 0x86, 0x81, 0x5F, 0x16, 0x0C, 0x08,
  0x68, 0x14, 0xF1, 0x60, 0xC0, 0x96, 0x81, 0x4F, 0x26, 0x0B, 0x0A, 0x68, 0x13, 0xF2, 0x60, 0xB0,
  0xA6, 0x81, 0x2F, 0x36, 0x0A, 0x0B, 0x68, 0x12, 0xF3, 0x60, 0x90, 0xB7,
  // "0" (U+0030)
  0x48, 0x37, 0xDF, 0xD6, 0x58, 0x5B, 0xFA, 0x4C, 0xF7, 0x38, 0x18, 0xFC, 0x28, 0x15, 0xFE, 0x20,
  0x2A, 0x04, 0x20, 0x3A, 0x83, 0x10, 0x8F, 0xE3, 0x04, 0xA8, 0x31, 0x0D, 0xFA, 0x30, 0x5A, 0x10,
  0x1A, 0x07, 0x38, 0x38, 0xFD, 0x03, 0xA0, 0x43, 0x83, 0xBF, 0x90, 0x4A, 0x03, 0x20, 0x1A, 0x81,
  0x50, 0x4A, 0x02, 0x28, 0x15, 0xFD, 0x20, 0x1A, 0x04, 0x28, 0x1D, 0xF5, 0x38, 0x59, 0xFC, 0x4A,
  0xF9, 0x58, 0x37, 0xDF, 0xC6, 0x40,
  // "1" (U+0031)
  0x58, 0x25, 0xEF, 0x63, 0x03, 0x0B, 0xB0, 0x32, 0x82, 0xCF, 0xBA, 0xA3, 0x84, 0x77, 0x0D, 0xFC,
  0x50, 0x1A, 0x08, 0x50, 0x5A, 0x05, 0x50, 0x8A, 0x02, 0x58, 0x1B, 0xFE, 0x68, 0x1E, 0xFB, 0x50,
  0x2A, 0x07, 0x50, 0x5A, 0x04, 0x40, 0x10, 0xBA, 0x03, 0x20, 0x2F, 0x03,
  // "2" (U+0032)
  0x48, 0x55, 0xBE, 0xFD, 0x91, 0x30, 0x8A, 0x07, 0x05, 0xA0, 0xC3, 0x81, 0xDF, 0x82, 0x0A, 0xA3,
  0x81, 0x9F, 0x42, 0x81, 0xBF, 0xD4, 0x02, 0x38, 0x1E, 0xF4, 0x78, 0x18, 0xF7, 0x78, 0x16, 0xF6,
  0x78, 0x17, 0xE4, 0x78, 0x1A, 0xD2, 0x68, 0x11, 0xCA, 0x30, 0x10, 0xB2, 0x81, 0x2D, 0x73, 0x81,
  0x1A, 0xD2, 0x0E, 0xF8, 0x19, 0x02, 0xF9, 0x05, 0x10,
  // "3" (U+0033)
  0x38, 0x56, 0xBE, 0xFD, 0x92, 0x28, 0x6A, 0xFE, 0x55, 0xEF, 0xD2, 0x81, 0xEF, 0x52, 0x0B, 0xA2,
  0x01, 0x04, 0x28, 0x21, 0xEF, 0xB4, 0x84, 0x15, 0xDF, 0xC1, 0x30, 0xDA, 0x0E, 0x06, 0x58, 0x13,
  0x5B, 0xA0, 0x67, 0x0D, 0xA7, 0x0A, 0xA8, 0x11, 0x6D, 0x40, 0xBA, 0x18, 0x1E, 0xF4, 0x20, 0x1A,
  0x8A, 0x1A, 0x0B, 0xFD, 0x55, 0xDF, 0xD1, 0x01, 0x9D, 0xFE, 0xB7, 0x30,
  // "4" (U+0034)
  0x60, 0x4A, 0x08, 0x50, 0x20, 0xEA, 0x05, 0x48, 0x11, 0xDA, 0xA0, 0x14, 0x83, 0xC7, 0xBF, 0xD4,
  0x84, 0xA9, 0x0E, 0xFA, 0x38, 0x28, 0xB0, 0x3A, 0x06, 0x28, 0x35, 0xD1, 0x06, 0xA8, 0x33, 0x03,
  0xE2, 0x20, 0xAA, 0x20, 0xCF, 0x98, 0x49, 0x33, 0x33, 0x4A, 0x81, 0x93, 0x14, 0x04, 0xA0, 0x54,
  0x81, 0x24, 0xCA, 0x09, 0x03, 0x30, 0x9D, 0x0B, 0x10,
  // "5" (U+0035)
  0x30, 0xAE, 0x02, 0x30, 0xEE, 0x30, 0x40, 0xE4, 0x06, 0x0D, 0x30, 0x80, 0xA4, 0x01, 0x03, 0x30,
  0xD0, 0x57, 0x18, 0x52, 0xFD, 0xFE, 0xC6, 0x48, 0x31, 0x84, 0x49, 0xA0, 0x87, 0x18, 0x1C, 0xFE,
  0x71, 0x09, 0xA2, 0x01, 0x06, 0x48, 0x1B, 0xFE, 0x28, 0x1B, 0xF1, 0x20, 0x1A, 0x08, 0x28, 0x6A,
  0xFB, 0x45, 0xDF, 0xB3, 0x85, 0x1A, 0xEF, 0xEB, 0x54,
  // "6" (U+0036)
  0x00, 0x01, 0x8D, 0xFD, 0x90, 0x00, 0x3E, 0xE6, 0x5F, 0xF7, 0x02, 0xEF, 0x30, 0x0B, 0xF5, 0x0B,
  0xFA, 0x00, 0x03, 0x20, 0x3F, 0xF4, 0x00, 0x00, 0x00, 0x9F, 0xE6, 0xDF, 0xD4, 0x00, 0xDF, 0xF8,
  0x4A, 0xFF, 0x20, 0xFF, 0x80, 0x02, 0xFF, 0x60, 0xFF, 0x60, 0x00, 0xFF, 0x70, 0xFF, 0x60, 0x02,
  0xFF, 0x40, 0xCF, 0x80, 0x07, 0xFE, 0x00, 0x4F, 0xE5, 0x6F, 0xF4, 0x00, 0x04, 0xCF, 0xEA, 0x30,
  0x00,
  // "7" (U+0037)
  0x10, 0x9F, 0x91, 0x0C, 0xF8, 0x29, 0x0F, 0x63, 0x84, 0x2F, 0xE1, 0x2C, 0x48, 0x1C, 0xF5, 0x68,
  0x17, 0xFB, 0x68, 0x22, 0xEF, 0x26, 0x81, 0xBF, 0x76, 0x81, 0x6F, 0xC6, 0x82, 0x1E, 0xF3, 0x68,
  0x1A, 0xF9, 0x68, 0x25, 0xFE, 0x15, 0x82, 0x1E, 0xF5, 0x68, 0x19, 0xFB, 0x70,
  // "8" (U+0038)
  0x38, 0x54, 0xAE, 0xFD, 0x91, 0x30, 0x5A, 0x83, 0x94, 0xAF, 0xC3, 0x81, 0xCF, 0xB2, 0x02, 0xA0,
  0x22, 0x81, 0xEF, 0x82, 0x02, 0xA0, 0x12, 0x81, 0xBF, 0xC2, 0x81, 0x7F, 0x73, 0x85, 0x2E, 0xFA,
  0x7D, 0x55, 0x09, 0xB0, 0xA4, 0x83, 0x6E, 0xD4, 0x7A, 0x0B, 0x28, 0x25, 0xFE, 0x12, 0x06, 0xA8,
  0x33, 0x0A, 0xFB, 0x30, 0x2A, 0x83, 0x40, 0xAF, 0xC3, 0x04, 0xA8, 0x12, 0x03, 0xA8, 0x48, 0x46,
  0xEF, 0x83, 0x85, 0x3A, 0xEF, 0xEB, 0x53,
  // "9" (U+0039)
  0x38, 0x41, 0x8D, 0xED, 0x63, 0x86, 0x2E, 0xF8, 0x5E, 0xF6, 0x28, 0x1D, 0xFA, 0x28, 0x37, 0xFD,
  0x04, 0xA0, 0x32, 0x05, 0xA1, 0x07, 0xA3, 0x83, 0x6F, 0xE0, 0x8A, 0x38, 0x3A, 0xFC, 0x04, 0xA8,
  0x17, 0x17, 0xA0, 0x92, 0x08, 0xB0, 0x8A, 0x05, 0x38, 0x41, 0x20, 0x5F, 0xE7, 0x84, 0xCF, 0x70,
  0x3D, 0x38, 0x15, 0xFC, 0x28, 0x66, 0xF8, 0x26, 0xED, 0x13, 0x83, 0x9E, 0xED, 0x74,
  // ":" (U+003A)
  0x28, 0x23, 0xDD, 0x22, 0x09, 0xA0, 0x52, 0x82, 0x4D, 0xB1, 0x77, 0x74, 0x81, 0x9D, 0x62, 0x02,
  0xA0, 0xB3, 0x81, 0xCE, 0x52,
  // ";" (U+003B)
  0x38, 0x23, 0xDD, 0x23, 0x09, 0xA0, 0x53, 0x82, 0x4D, 0xC1, 0x77, 0x77, 0x28, 0x1C, 0xF5, 0x30,
  0x1A, 0x0B, 0x48, 0x16, 0xF9, 0x48, 0x15, 0xF2, 0x38, 0x19, 0xD4, 0x30, 0x10, 0x45,
  // "<" (U+003C)
  0x60, 0x30, 0xA4, 0x82, 0x2B, 0xF9, 0x28, 0x91, 0x19, 0xFB, 0x20, 0x18, 0xFC, 0x43, 0x81, 0xCF,
  0x85, 0x83, 0x2A, 0xFA, 0x25, 0x83, 0x3B, 0xF9, 0x15, 0x82, 0x4C, 0xE7, 0x60, 0x50, 0xB0,
  // "=" (U+003D)
  0x0D, 0xE0, 0xE0, 0x28, 0x03, 0x37, 0x72, 0x0D, 0xE0, 0xE0, 0x28, 0x03, 0x30,
  // ">" (U+003E)
  0x0A, 0x04, 0x68, 0x28, 0xFB, 0x35, 0x83, 0x2A, 0xFA, 0x25, 0x83, 0x3C, 0xF8, 0x15, 0x81, 0x7F,
  0xD3, 0x89, 0x11, 0x9F, 0xA2, 0x01, 0x8F, 0xC3, 0x28, 0x26, 0xED, 0x54, 0x0B, 0x06, 0x60,
  // "?" (U+003F)
  0x18, 0x51, 0x8D, 0xFE, 0xC6, 0x28, 0x3D, 0xFD, 0x59, 0xA0, 0x70, 0x2A, 0x05, 0x2A, 0x83, 0xC0,
  0x6B, 0x12, 0xA0, 0xB5, 0x05, 0xA0, 0x54, 0x82, 0x5E, 0xF8, 0x38, 0x33, 0xCF, 0xB3, 0x48, 0x16,
  0xF4, 0x60, 0x50, 0xA7, 0x71, 0x82, 0x3D, 0xB1, 0x50, 0xAA, 0x03, 0x58, 0x16, 0xEB, 0x50,
  // "@" (U+0040)
  0x58, 0x61, 0x7C, 0xEF, 0xDA, 0x57, 0x89, 0x07, 0xFE, 0x85, 0x46, 0xAF, 0xA5, 0x81, 0xAF, 0x96,
  0x81, 0x4F, 0x93, 0x8A, 0x68, 0xF7, 0x01, 0x9E, 0xE8, 0xA2, 0x6F, 0x30, 0x2F, 0xB0, 0x2E, 0xF7,
  0x5A, 0x28, 0x90, 0xE8, 0x09, 0xF3, 0x0B, 0xF7, 0x29, 0x0D, 0x28, 0x5C, 0xA0, 0xED, 0x03, 0xA8,
  0x31, 0x03, 0xFB, 0x28, 0x7B, 0xA1, 0xFA, 0x07, 0xFC, 0x28, 0x15, 0xF8, 0x28, 0x7C, 0x92, 0xF8,
  0x09, 0xFA, 0x28, 0x18, 0xF6, 0x28, 0x7E, 0x62, 0xF8, 0x08, 0xFA, 0x28, 0xA4, 0xCF, 0x50, 0x4F,
  0x11, 0xFA, 0x03, 0xFD, 0x14, 0xAF, 0x81, 0xC8, 0x20, 0xC0, 0xE2, 0x84, 0x7E, 0xFB, 0x07, 0xA0,
  0x93, 0x81, 0x6F, 0x63, 0x01, 0x73, 0x81, 0xCF, 0x47, 0x10, 0x24, 0x89, 0x21, 0xBF, 0xA4, 0x10,
  0x14, 0x8D, 0x56, 0x05, 0x0C, 0xC8, 0x1D, 0x81, 0x73, 0x81, 0x23, 0x16,
  // "A" (U+0041)
  0x71, 0x81, 0xDF, 0xE7, 0x30, 0x7B, 0x01, 0x71, 0x81, 0x1E, 0xBA, 0x03, 0x71, 0x81, 0xAD, 0x5A,
  0x05, 0x78, 0x23, 0xF5, 0x3A, 0x07, 0x78, 0x2C, 0xC0, 0x2A, 0x0A, 0x68, 0x16, 0xF4, 0x2A, 0x0C,
  0x58, 0x11, 0xEB, 0x38, 0x1E, 0xFE, 0x50, 0x9F, 0x90, 0x13, 0x86, 0x3F, 0x92, 0x22, 0x2B, 0xA0,
  0x33, 0x0C, 0x0D, 0x50, 0x8A, 0x85, 0x60, 0x29, 0xFC, 0x43, 0x04, 0x0B, 0xA8, 0x1C, 0x3C, 0xB0,
  0xD2, 0x04, 0xD0, 0xA0,
  // "B" (U+0042)
  0x30, 0xCE, 0x0D, 0x07, 0x40, 0x40, 0xAA, 0x81, 0x94, 0xAA, 0x0A, 0x40, 0x7A, 0x81, 0x40, 0x1B,
  0x40, 0xBA, 0x01, 0x2B, 0x48, 0x1E, 0xFD, 0x20, 0x2A, 0x0B, 0x30, 0x2A, 0x85, 0xB0, 0x2C, 0xFD,
  0x23, 0x06, 0xE0, 0xA5, 0x09, 0xA8, 0x16, 0x37, 0xA0, 0xB4, 0x0D, 0xA0, 0x12, 0x0B, 0xA0, 0x32,
  0x01, 0xA0, 0xC3, 0x0B, 0xA0, 0x42, 0x04, 0xA0, 0x92, 0x01, 0x0E, 0xA8, 0x21, 0x05, 0xCA, 0x82,
  0x84, 0x5C, 0xA8, 0x17, 0x05, 0xF8, 0x1D, 0xA4, 0x20,
  // "C" (U+0043)
  0x48, 0x52, 0x8C, 0xEE, 0xD7, 0x48, 0x47, 0xFE, 0x74, 0xAA, 0x07, 0x28, 0x29, 0xFE, 0x32, 0x01,
  0xA8, 0x18, 0x06, 0xA0, 0x74, 0x0B, 0x08, 0x28, 0x1E, 0xFE, 0x71, 0x05, 0xA0, 0x97, 0x10, 0xAA,
  0x05, 0x71, 0x0C, 0xA0, 0x37, 0x10, 0xCA, 0x02, 0x71, 0x0B, 0xA0, 0x47, 0x10, 0x5A, 0x0A, 0x40,
  0x10, 0x73, 0x09, 0xA8, 0x4A, 0x54, 0x7D, 0x64, 0x85, 0x5B, 0xEF, 0xEB, 0x53,
  // "D" (U+0044)
  0x30, 0xCE, 0x81, 0xD9, 0x25, 0x03, 0x0A, 0xA8, 0x59, 0x47, 0xEF, 0xE4, 0x50, 0x7A, 0x04, 0x20,
  0x2A, 0x0E, 0x50, 0xBA, 0x01, 0x30, 0xAA, 0x05, 0x48, 0x1E, 0xFD, 0x40, 0x8A, 0x07, 0x30, 0x2A,
  0x0A, 0x40, 0x9A, 0x07, 0x30, 0x6A, 0x06, 0x40, 0xAA, 0x05, 0x30, 0x9A, 0x03, 0x40, 0xDA, 0x02,
  0x30, 0xDA, 0x40, 0x3A, 0x0C, 0x30, 0x1A, 0x0C, 0x40, 0xBA, 0x04, 0x30, 0x4A, 0x09, 0x30, 0x9A,
  0x09, 0x28, 0x11, 0x5C, 0xA8, 0x28, 0x47, 0xDA, 0x08, 0x30, 0x5E, 0x82, 0xED, 0x82, 0x40,
  // "E" (U+0045)
  0x30, 0xCF, 0x90, 0xE4, 0x07, 0xA0, 0x72, 0x81, 0x1E, 0xC4, 0x08, 0xA0, 0x43, 0x0C, 0x09, 0x40,
  0xBA, 0x01, 0x30, 0x70, 0x44, 0x81, 0xEF, 0xD7, 0x20, 0x2A, 0x0B, 0x72, 0x06, 0xE0, 0x95, 0x09,
  0xA8, 0x36, 0x33, 0x31, 0x50, 0xCA, 0x01, 0x72, 0xA0, 0xD4, 0x00, 0x13, 0x03, 0xA0, 0x94, 0x0C,
  0x08, 0x30, 0x9A, 0x06, 0x38, 0x37, 0xF4, 0x04, 0xFB, 0x01, 0x10,
  // "F" (U+0046)
  0x30, 0xCF, 0xA0, 0x13, 0x03, 0x0A, 0xA8, 0x49, 0x33, 0x5E, 0xE5, 0x07, 0xA0, 0x43, 0x0A, 0x0B,
  0x50, 0xBA, 0x01, 0x30, 0x50, 0x45, 0x81, 0xEF, 0xD7, 0x30, 0x2A, 0x0A, 0x73, 0x06, 0xE0, 0xA6,
  0x09, 0xA8, 0x36, 0x33, 0x32, 0x60, 0xDA, 0x73, 0x01, 0xA0, 0xC7, 0x30, 0x4A, 0x08, 0x72, 0x05,
  0x0C, 0xA0, 0xA0, 0x47, 0x05, 0xD0, 0xD7,
  // "G" (U+0047)
  0x48, 0x61, 0x7B, 0xEF, 0xEB, 0x54, 0x85, 0x7E, 0xF9, 0x45, 0xDA, 0x06, 0x20, 0x9A, 0x04, 0x30,
  0x3A, 0x81, 0x40, 0x6A, 0x07, 0x50, 0x50, 0x12, 0x81, 0xEF, 0xD7, 0x20, 0x6A, 0x08, 0x72, 0x0A,
  0xA0, 0x42, 0x04, 0xD0, 0xA0, 0xCA, 0x02, 0x20, 0x10, 0x5B, 0x81, 0x72, 0xCA, 0x01, 0x4A, 0x0D,
  0x20, 0xBA, 0x03, 0x30, 0x3A, 0x09, 0x20, 0x5A, 0x08, 0x30, 0x6A, 0x07, 0x30, 0xAA, 0x82, 0x94,
  0x5B, 0xA0, 0x44, 0x86, 0x5B, 0xEF, 0xEC, 0x94, 0x30,
  // "H" (U+0048)
  0x30, 0xCD, 0x06, 0x04, 0xD0, 0xE3, 0x03, 0x09, 0xA8, 0x4C, 0x51, 0x15, 0xEA, 0x08, 0x03, 0x40,
  0x7A, 0x05, 0x48, 0x1E, 0xFD, 0x60, 0xBA, 0x01, 0x30, 0x2A, 0x09, 0x68, 0x1E, 0xFE, 0x40, 0x5A,
  0x06, 0x50, 0x2A, 0x0B, 0x40, 0x9A, 0x03, 0x50, 0x6F, 0xA0, 0xE6, 0x09, 0xA0, 0x68, 0x00, 0x3A,
  0x0B, 0x60, 0xDA, 0x01, 0x30, 0x3A, 0x08, 0x50, 0x1A, 0x0C, 0x40, 0x7A, 0x05, 0x50, 0x4A, 0x09,
  0x40, 0xBA, 0x01, 0x40, 0x50, 0xCA, 0x83, 0xA3, 0x03, 0x6B, 0x05, 0x01, 0x20, 0x5D, 0x81, 0xD0,
  0xCD, 0x05, 0x20,
  // "I" (U+0049)
  0x30, 0xCD, 0x06, 0x30, 0x30, 0xAA, 0x81, 0xC5, 0x14, 0x07, 0xA0, 0x56, 0x0B, 0xA0, 0x16, 0x81,
  0xEF, 0xD6, 0x02, 0xA0, 0xA6, 0x05, 0xA0, 0x66, 0x09, 0xA0, 0x36, 0x0C, 0xA7, 0xA0, 0xC6, 0x04,
  0xA0, 0x85, 0x05, 0x0C, 0xA0, 0xA0, 0x43, 0x05, 0xD0, 0xD3,
  // "J" (U+004A)
  0x50, 0xCD, 0x06, 0x50, 0x30, 0xAA, 0x81, 0xC5, 0x16, 0x07, 0xA0, 0x57, 0x10, 0xBA, 0x01, 0x71,
  0x81, 0xEF, 0xD7, 0x10, 0x2A, 0x0A, 0x71, 0x06, 0xA0, 0x67, 0x10, 0x9A, 0x03, 0x71, 0x0D, 0xA7,
  0x10, 0x1A, 0x0C, 0x71, 0x04, 0xA0, 0x87, 0x10, 0x8A, 0x05, 0x71, 0x0B, 0xA0, 0x27, 0x1A, 0x0D,
  0x71, 0x07, 0xA0, 0x65, 0x81, 0x34, 0x7A, 0x09, 0x68, 0x3A, 0xFE, 0xA4, 0x70,
  // "K" (U+004B)
  0x30, 0xCD, 0x06, 0x05, 0xC0, 0x73, 0x03, 0x0A, 0xA8, 0x7C, 0x51, 0x1D, 0xFD, 0x61, 0x40, 0x7A,
  0x05, 0x28, 0x12, 0xEA, 0x70, 0xBA, 0x83, 0x10, 0x3D, 0x87, 0x18, 0x5E, 0xFD, 0x04, 0xE6, 0x71,
  0x02, 0xA8, 0x2A, 0x7F, 0xB7, 0x20, 0x6A, 0x0E, 0xB0, 0x27, 0x10, 0x9A, 0x08, 0x09, 0xA0, 0x87,
  0x10, 0xDA, 0x10, 0x3A, 0x0E, 0x70, 0x1A, 0x0C, 0x20, 0xCA, 0x07, 0x60, 0x4A, 0x08, 0x20, 0x6A,
  0x0D, 0x50, 0x50, 0xCA, 0x0A, 0x04, 0x20, 0xEA, 0x09, 0x01, 0x20, 0x5D, 0x0D, 0x28, 0x33, 0xCE,
  0xF5, 0x20,
  // "L" (U+004C)
  0x30, 0xCD, 0x05, 0x60, 0x7A, 0x0A, 0x01, 0x70, 0x8A, 0x04, 0x71, 0x0B, 0xA0, 0x17, 0x18, 0x1E,
  0xFD, 0x71, 0x02, 0xA0, 0xA7, 0x10, 0x6A, 0x07, 0x71, 0x09, 0xA0, 0x37, 0x10, 0xCA, 0x50, 0x13,
  0xA0, 0xC4, 0x03, 0x0E, 0x20, 0x3A, 0x09, 0x40, 0x90, 0xB2, 0x09, 0xA0, 0x63, 0x82, 0x4F, 0x74,
  0xFB, 0x04,
  // "M" (U+004D)
  0x30, 0xCC, 0x05, 0x40, 0x10, 0xEC, 0x05, 0x30, 0x30, 0xAB, 0x08, 0x40, 0x9B, 0x81, 0xC5, 0x14,
  0x07, 0x0D, 0xA0, 0xA3, 0x81, 0x2F, 0xDA, 0x04, 0x68, 0x3B, 0x9D, 0xFC, 0x38, 0x1A, 0xCB, 0xA7,
  0x83, 0xE6, 0xBF, 0xE2, 0x84, 0x3F, 0x4E, 0xFC, 0x68, 0x22, 0xF3, 0x9A, 0x83, 0x10, 0xBB, 0x2A,
  0x09, 0x68, 0x26, 0xE0, 0x7A, 0x83, 0x34, 0xF3, 0x5A, 0x06, 0x68, 0x29, 0xB0, 0x5A, 0x83, 0x5C,
  0xA0, 0x9A, 0x02, 0x68, 0x2D, 0x80, 0x3A, 0x85, 0xCF, 0x20, 0xCF, 0xE6, 0x81, 0x1F, 0x42, 0xB0,
  0x82, 0xA0, 0xB6, 0x81, 0x4F, 0x12, 0x84, 0xEF, 0xE1, 0x04, 0xA0, 0x75, 0x89, 0x25, 0xCF, 0x51,
  0x0C, 0xF7, 0x05, 0xCA, 0x0A, 0x03, 0x30, 0x5C, 0x84, 0x30, 0xAD, 0x05, 0xD0, 0xC3,
  // "N" (U+004E)
  0x30, 0xCB, 0x08, 0x40, 0xEB, 0x08, 0x30, 0x30, 0xAA, 0x0E, 0x48, 0x34, 0xDE, 0x61, 0x40, 0x7B,
  0x07, 0x40, 0xD0, 0x86, 0x83, 0xBA, 0xEF, 0xE3, 0x81, 0x1F, 0x46, 0x81, 0xE6, 0x8A, 0x06, 0x28,
  0x14, 0xF1, 0x58, 0x52, 0xF2, 0x1E, 0xFD, 0x20, 0x70, 0xD6, 0x06, 0x0E, 0x20, 0x8A, 0x82, 0x50,
  0xBA, 0x60, 0x90, 0xB2, 0x01, 0xA8, 0x2D, 0x0E, 0x66, 0x0D, 0x08, 0x30, 0x8A, 0x81, 0x7F, 0x35,
  0x81, 0x1F, 0x43, 0x01, 0xC6, 0x81, 0x4F, 0x14, 0x09, 0xA0, 0xC5, 0x83, 0x5C, 0xF5, 0x13, 0x02,
  0xA0, 0x94, 0x05, 0xC0, 0x34, 0x81, 0x9F, 0x54,
  // "O" (U+004F)
  0x48, 0x53, 0x9D, 0xFE, 0xB5, 0x58, 0x48, 0xFE, 0x64, 0x8A, 0x08, 0x38, 0x2A, 0xFE, 0x13, 0x09,
  0xA8, 0x13, 0x06, 0xA0, 0x54, 0x04, 0xA8, 0x39, 0x0E, 0xFD, 0x50, 0x2A, 0x0B, 0x06, 0xA0, 0x85,
  0x03, 0xA0, 0xB0, 0xAA, 0x04, 0x50, 0x5A, 0x08, 0x0C, 0xA0, 0x25, 0x09, 0xA0, 0x40, 0xCA, 0x01,
  0x58, 0x3E, 0xFD, 0x0A, 0xA0, 0x24, 0x06, 0xA8, 0x14, 0x04, 0xA0, 0x73, 0x82, 0x2E, 0xF8, 0x30,
  0x9A, 0x84, 0x84, 0x7E, 0xF8, 0x58, 0x55, 0xBE, 0xFD, 0x92, 0x40,
  // "P" (U+0050)
  0x30, 0xCD, 0x81, 0xDA, 0x34, 0x03, 0x0A, 0xA8, 0x1A, 0x5C, 0xA0, 0x54, 0x07, 0xA8, 0x15, 0x02,
  0xA0, 0xD4, 0x0B, 0xA0, 0x12, 0x0E, 0xA4, 0x81, 0xEF, 0xE3, 0xA0, 0xE3, 0x02, 0xA0, 0xA2, 0x04,
  0xA0, 0xA3, 0x06, 0xA8, 0x57, 0x14, 0xDF, 0xE2, 0x30, 0x9E, 0x0A, 0x02, 0x40, 0xDA, 0x81, 0x43,
  0x26, 0x01, 0xA0, 0xC7, 0x20, 0x4A, 0x09, 0x71, 0x05, 0x0C, 0xA8, 0x1A, 0x41, 0x50, 0x5E, 0x03,
  0x50,
  // "Q" (U+0051)
  0x48, 0x53, 0x9D, 0xFE, 0xB4, 0x58, 0x49, 0xFE, 0x64, 0x9A, 0x08, 0x38, 0x2A, 0xFE, 0x13, 0x09,
  0xA8, 0x13, 0x06, 0xA0, 0x54, 0x04, 0xA8, 0x38, 0x1E, 0xFD, 0x50, 0x3A, 0x0A, 0x06, 0xA0, 0x85,
  0x04, 0xA0, 0x0A, 0xA0, 0x45, 0x05, 0xA0, 0x80, 0xDA, 0x02, 0x50, 0x9A, 0x04, 0x0D, 0xA0, 0x15,
  0x83, 0xEF, 0xD0, 0xBA, 0x02, 0x40, 0x6A, 0x81, 0x40, 0x5A, 0x07, 0x38, 0x21, 0xEF, 0x83, 0x87,
  0x9F, 0xE6, 0x35, 0xDF, 0x85, 0x05, 0x0B, 0xB0, 0x90, 0x37, 0x01, 0xA0, 0xD7, 0x30, 0xDA, 0x01,
  0x72, 0x06, 0xA0, 0x90, 0x17, 0x28, 0x36, 0xCF, 0xE3, 0x30,
  // "R" (U+0052)
  0x30, 0xCE, 0x81, 0xD9, 0x24, 0x03, 0x0A, 0xA8, 0x19, 0x47, 0xA0, 0xD5, 0x07, 0xA0, 0x42, 0x0C,
  0xA0, 0x44, 0x0B, 0xA0, 0x12, 0x0B, 0xA0, 0x44, 0x81, 0xEF, 0xC3, 0x81, 0xEF, 0xE4, 0x02, 0xA8,
  0x59, 0x03, 0xBF, 0xE4, 0x40, 0x6E, 0x08, 0x01, 0x50, 0x9A, 0x05, 0x08, 0xA0, 0x76, 0x83, 0xDF,
  0xE0, 0x1A, 0x0D, 0x50, 0x1A, 0x0B, 0x20, 0xCA, 0x03, 0x40, 0x4A, 0x08, 0x20, 0x7A, 0x0A, 0x30,
  0x50, 0xCA, 0x82, 0xA4, 0x11, 0xB8, 0x16, 0x05, 0xE8, 0x33, 0x04, 0xBE, 0x91,
  // "S" (U+0053)
  0x38, 0x51, 0x9D, 0xFE, 0xC7, 0x38, 0x42, 0xEF, 0x72, 0x7A, 0x08, 0x28, 0x1B, 0xFA, 0x38, 0x1C,
  0xF8, 0x28, 0x1D, 0xFB, 0x30, 0x05, 0x30, 0xCA, 0x06, 0x70, 0x6B, 0x0C, 0x03, 0x60, 0x8C, 0x07,
  0x60, 0x40, 0xDB, 0x03, 0x20, 0x10, 0x23, 0x09, 0xA8, 0x38, 0x05, 0xFA, 0x4A, 0x83, 0x90, 0xBF,
  0xE4, 0x83, 0xEF, 0x50, 0x5A, 0x84, 0xA3, 0x2A, 0xFB, 0x38, 0x54, 0xBE, 0xFE, 0xC6, 0x30,
  // "T" (U+0054)
  0x01, 0xFC, 0x84, 0x24, 0xF9, 0x44, 0xA8, 0x6C, 0x34, 0xBF, 0x08, 0xC2, 0x04, 0xA0, 0x92, 0x83,
  0x7C, 0x06, 0x42, 0x07, 0xA0, 0x52, 0x05, 0x06, 0x50, 0xAA, 0x02, 0x72, 0x81, 0xEF, 0xE7, 0x20,
  0x2A, 0x0B, 0x72, 0x05, 0xA0, 0x77, 0x20, 0x8A, 0x04, 0x72, 0x0C, 0xA7, 0x3A, 0x0C, 0x71, 0x04,
  0x09, 0xA0, 0xD0, 0x47, 0xE0, 0x25,
  // "U" (U+0055)
  0x1E, 0x81, 0x30, 0xDB, 0x82, 0xD0, 0x4C, 0xA0, 0xA0, 0x42, 0x83, 0x4B, 0xF7, 0x32, 0x0B, 0xA0,
  0x14, 0x08, 0x0C, 0x48, 0x1E, 0xFD, 0x50, 0xC0, 0x83, 0x02, 0xA0, 0xA5, 0x90, 0x53, 0x05, 0xA0,
  0x64, 0x81, 0x3F, 0x13, 0x09, 0xA0, 0x34, 0x06, 0x0E, 0x40, 0xCA, 0x50, 0x0A, 0x4A, 0x0B, 0x50,
  0xD0, 0x73, 0x02, 0xA0, 0x94, 0x81, 0x3F, 0x23, 0x02, 0xA0, 0xA4, 0x09, 0x0C, 0x50, 0xBA, 0x84,
  0x84, 0x5A, 0xE2, 0x68, 0x57, 0xCE, 0xFD, 0x91, 0x50,
  // "V" (U+0056)
  0x05, 0xD8, 0x19, 0x06, 0xC8, 0x14, 0x18, 0xA8, 0x7E, 0x51, 0x01, 0x5F, 0xD4, 0x3A, 0x0C, 0x48,
  0x15, 0xF2, 0x48, 0x1E, 0xFE, 0x40, 0xD0, 0x95, 0x0C, 0xA0, 0x12, 0x81, 0x6E, 0x15, 0x09, 0xA8,
  0x32, 0x01, 0xE7, 0x60, 0x7A, 0x82, 0x40, 0x8D, 0x70, 0x5A, 0x82, 0x62, 0xF5, 0x70, 0x3A, 0x81,
  0x7A, 0xB7, 0x10, 0x1A, 0x81, 0xAF, 0x37, 0x20, 0xEA, 0x09, 0x73, 0x82, 0xCF, 0xE1, 0x73, 0x81,
  0xAF, 0x77, 0x10,
  // "W" (U+0057)
  0x05, 0xD0, 0x82, 0x81, 0x1E, 0x93, 0x0B, 0xB8, 0x1E, 0x17, 0xA8, 0x1E, 0x51, 0x28, 0x17, 0xFC,
  0x38, 0x33, 0xAF, 0x93, 0x2A, 0x0C, 0x38, 0x21, 0xEF, 0xE4, 0x0A, 0x0D, 0x48, 0x1E, 0xFD, 0x30,
  0x8B, 0x01, 0x28, 0x12, 0xF5, 0x48, 0x1D, 0xFE, 0x28, 0x11, 0xEE, 0xA0, 0x32, 0x09, 0x0D, 0x50,
  0xCA, 0x28, 0x18, 0xE6, 0xA8, 0x35, 0x01, 0xF6, 0x50, 0xAA, 0x83, 0x11, 0xE7, 0x3A, 0x82, 0x70,
  0x8D, 0x60, 0x9A, 0x83, 0x28, 0xE0, 0x1A, 0x82, 0x90, 0xE6, 0x60, 0x7A, 0x81, 0x4E, 0x72, 0x83,
  0xEF, 0xB6, 0xE7, 0x06, 0xA0, 0xB0, 0xD3, 0x83, 0xCF, 0xDD, 0x77, 0x05, 0xB0, 0x63, 0x09, 0xA0,
  0xE7, 0x10, 0x3A, 0x0D, 0x40, 0x7A, 0x07, 0x71, 0x02, 0xA0, 0x54, 0x82, 0x5F, 0xE1, 0x60,
  // "X" (U+0058)
  0x30, 0xBD, 0x81, 0x30, 0xEB, 0x04, 0x30, 0x30, 0xBA, 0x0E, 0x04, 0x28, 0x27, 0xFD, 0x55, 0x02,
  0xB0, 0x12, 0x81, 0x8D, 0x17, 0x0A, 0xA8, 0x37, 0x07, 0xD1, 0x71, 0x03, 0xA8, 0x2D, 0x7D, 0x17,
  0x30, 0xCA, 0x0D, 0x01, 0x74, 0x06, 0xA0, 0xC7, 0x48, 0x13, 0xEE, 0xA0, 0x47, 0x28, 0x23, 0xE4,
  0x6A, 0x0B, 0x71, 0x81, 0x4E, 0x42, 0x0E, 0xA0, 0x26, 0x81, 0x4E, 0x53, 0x08, 0xA0, 0x94, 0x02,
  0x07, 0xA0, 0x42, 0x02, 0x0A, 0xB0, 0x63, 0x0A, 0xB0, 0xD2, 0x0C, 0xD0, 0x22,
  // "Y" (U+0059)
  0x04, 0xD8, 0x18, 0x08, 0xC8, 0x12, 0x18, 0xA8, 0x7E, 0x41, 0x02, 0x8F, 0xD5, 0x30, 0xEA, 0x48,
  0x17, 0xE2, 0x40, 0xAA, 0x03, 0x28, 0x12, 0xE5, 0x50, 0x5A, 0x07, 0x20, 0xC0, 0x86, 0x01, 0xA8,
  0x2C, 0x09, 0xC7, 0x10, 0xBA, 0x81, 0x4E, 0x27, 0x10, 0x6A, 0x0E, 0x04, 0x72, 0x03, 0xA0, 0xA7,
  0x30, 0x6A, 0x06, 0x73, 0x0A, 0xA0, 0x37, 0x18, 0x13, 0x6E, 0xA0, 0x60, 0x37, 0x0E, 0xD0, 0xB6,
  // "Z" (U+005A)
  0x3F, 0xA0, 0x92, 0x85, 0x3F, 0x92, 0x11, 0x6A, 0x0E, 0x01, 0x20, 0x70, 0xD3, 0x02, 0x0E, 0xA0,
  0x33, 0x00, 0x72, 0x01, 0x0D, 0xA0, 0x67, 0x10, 0xBA, 0x09, 0x71, 0x08, 0xA0, 0xC7, 0x10, 0x5A,
  0x0D, 0x01, 0x70, 0x30, 0xEA, 0x03, 0x70, 0x10, 0xDA, 0x05, 0x71, 0x0B, 0xA0, 0x83, 0x81, 0x2B,
  0x12, 0x09, 0xA0, 0xB4, 0x08, 0x0D, 0x20, 0x6A, 0x86, 0xE2, 0x11, 0x26, 0xFA, 0x20, 0xEF, 0xA0,
  0x62,
  // "[" (U+005B)
  0x30, 0x5C, 0x0A, 0x30, 0x8A, 0x81, 0xA4, 0x23, 0x0B, 0xA0, 0x15, 0x81, 0xEF, 0xC5, 0x02, 0xA0,
  0x95, 0x05, 0xA0, 0x55, 0x09, 0xA0, 0x25, 0x81, 0xCF, 0xE6, 0xA0, 0xB5, 0x03, 0xA0, 0x75, 0x06,
  0xA0, 0x45, 0x09, 0xA0, 0x15, 0x81, 0xDF, 0xD6, 0xA0, 0x95, 0x04, 0xA0, 0xA0, 0x14, 0x07, 0xC0,
  0x73, 0x84, 0x23, 0x33, 0x31, 0x30,
  // "\" (U+005C)
  0xF3, 0x0F, 0x40, 0xE5, 0x0D, 0x60, 0xC7, 0x0B, 0x80, 0xA9, 0x09, 0xA0, 0x8B, 0x07, 0xC0, 0x6D,
  0x05, 0xD0, 0x4E, 0x03, 0xF0, 0x2F, 0x11, 0xF2,
  // "]" (U+005D)
  0x30, 0xAC, 0x04, 0x38, 0x12, 0x5E, 0xA0, 0x15, 0x81, 0xCF, 0xD6, 0xA0, 0xA5, 0x03, 0xA0, 0x75,
  0x07, 0xA0, 0x45, 0x0A, 0xA6, 0x81, 0xDF, 0xD5, 0x01, 0xA0, 0x95, 0x05, 0xA0, 0x65, 0x08, 0xA0,
  0x35, 0x0B, 0xA6, 0x81, 0xEF, 0xC5, 0x03, 0xA0, 0x94, 0x02, 0x0A, 0xA0, 0x53, 0x0D, 0xC0, 0x23,
  0x80, 0x13, 0x40,
  // "^" (U+005E)
  0x30, 0x30, 0x46, 0x0C, 0x0D, 0x50, 0x4A, 0x04, 0x48, 0x2B, 0x99, 0xB3, 0x84, 0x2F, 0x22, 0xF3,
  0x20, 0x90, 0xB2, 0x84, 0xBA, 0x01, 0xF4, 0x28, 0x34, 0xF1, 0x7D, 0x48, 0x2D, 0x8E, 0x74, 0x06,
  0x0E,
  // "_" (U+005F)
  0x07, 0xF0, 0xE0, 0x28, 0x03, 0x30, 0x20,
  // "`" (U+0060)
  0x2E, 0xF7, 0x00, 0x4F, 0xD0, 0x00, 0x3D, 0x70,
  // "a" (U+0061)
  0x00, 0x01, 0x9D, 0xEC, 0x8B, 0xB0, 0x00, 0x2E, 0xFA, 0x49, 0xFF, 0x70, 0x00, 0xDF, 0xB0, 0x05,
  0xFF, 0x40, 0x07, 0xFF, 0x30, 0x09, 0xFF, 0x10, 0x0D, 0xFD, 0x00, 0x0C, 0xFD, 0x00, 0x1F, 0xF9,
  0x00, 0x1F, 0xFA, 0x00, 0x3F, 0xF7, 0x00, 0x6F, 0xF7, 0x00, 0x3F, 0xF7, 0x01, 0xCF, 0xF5, 0x00,
  0x0D, 0xFD, 0x4B, 0x5F, 0xF9, 0x61, 0x03, 0xDF, 0xC2, 0x0B, 0xFD, 0x70,
  // "b" (U+0062)
  0x10, 0x5B, 0x0E, 0x60, 0x10, 0x6A, 0x0B, 0x70, 0x2A, 0x08, 0x70, 0x6A, 0x04, 0x70, 0x9A, 0x83,
  0x2A, 0xED, 0x53, 0x84, 0xCF, 0xBB, 0x5B, 0xA0, 0x22, 0xA8, 0x2E, 0x30, 0x4A, 0x81, 0x60, 0x3A,
  0x0A, 0x20, 0x4A, 0x81, 0x70, 0x7A, 0x04, 0x20, 0x6A, 0x81, 0x50, 0xAA, 0x30, 0x9A, 0x83, 0x10,
  0xDF, 0xC3, 0x83, 0xEF, 0xA0, 0x1A, 0x09, 0x28, 0x48, 0xFE, 0x20, 0x4A, 0x84, 0xB4, 0x8F, 0xE4,
  0x28, 0x68, 0xD7, 0xCE, 0xE9, 0x23,
  // "c" (U+0063)
  0x38, 0x41, 0x8D, 0xFD, 0x83, 0x83, 0x3E, 0xF6, 0x7A, 0x84, 0x50, 0x1E, 0xF7, 0x28, 0x3D, 0xF5,
  0x09, 0xA0, 0x12, 0x05, 0x04, 0x28, 0x1E, 0xFB, 0x60, 0x3A, 0x08, 0x60, 0x3A, 0x07, 0x60, 0x1A,
  0x0A, 0x30, 0x30, 0x12, 0x09, 0xA8, 0x38, 0x47, 0xE1, 0x38, 0x47, 0xCF, 0xEB, 0x42,
  // "d" (U+0064)
  0x70, 0xBB, 0x09, 0x70, 0x30, 0xAA, 0x05, 0x71, 0x08, 0xA0, 0x27, 0x18, 0x1B, 0xFE, 0x48, 0x61,
  0x9E, 0xEB, 0xEF, 0xB3, 0x84, 0x3E, 0xFA, 0x49, 0xA0, 0x83, 0x81, 0xDF, 0xB2, 0x05, 0xA0, 0x52,
  0x07, 0xA0, 0x32, 0x09, 0xA0, 0x12, 0x81, 0xDF, 0xD3, 0x81, 0xCF, 0xE2, 0x01, 0xA0, 0x92, 0x01,
  0xA0, 0xB2, 0x03, 0xA0, 0x72, 0x06, 0xA0, 0x72, 0x03, 0xA8, 0x27, 0x01, 0xCA, 0x05, 0x38, 0x4D,
  0xFD, 0x4B, 0x6A, 0x89, 0x49, 0x61, 0x03, 0xDE, 0xC3, 0x0B, 0xFD, 0x71,
  // "e" (U+0065)
  0x00, 0x00, 0x7D, 0xEE, 0x80, 0x00, 0x2D, 0xF7, 0x7F, 0xF5, 0x01, 0xDF, 0x80, 0x1F, 0xF7, 0x08,
  0xFF, 0x10, 0x5F, 0xF3, 0x0E, 0xFC, 0x16, 0xEF, 0x80, 0x3F, 0xFF, 0xFF, 0xC5, 0x00, 0x3F, 0xF9,
  0x21, 0x00, 0x00, 0x1F, 0xF9, 0x00, 0x01, 0x10, 0x09, 0xFF, 0x74, 0x6D, 0x20, 0x00, 0x6C, 0xFE,
  0xB4, 0x00,
  // "f" (U+0066)
  0x78, 0x42, 0xAD, 0xFD, 0x67, 0x83, 0x1E, 0xF9, 0x6A, 0x01, 0x60, 0x9A, 0x20, 0xB0, 0x67, 0x81,
  0xEF, 0xB7, 0x20, 0x80, 0xDC, 0x0C, 0x70, 0x30, 0x9A, 0x81, 0x73, 0x27, 0x10, 0xAA, 0x01, 0x73,
  0x81, 0xDF, 0xD7, 0x30, 0x1A, 0x0A, 0x73, 0x04, 0xA0, 0x77, 0x30, 0x7A, 0x03, 0x73, 0x0B, 0xA7,
  0x48, 0x1E, 0xFC, 0x73, 0x02, 0xA0, 0x97, 0x30, 0x6A, 0x04, 0x73, 0x81, 0xBF, 0xD7, 0x18, 0x41,
  0x48, 0xFE, 0x37, 0x18, 0x36, 0xFD, 0xA2, 0x72,
  // "g" (U+0067)
  0x72, 0x82, 0x3D, 0xE1, 0x48, 0x74, 0xBE, 0xFE, 0xE5, 0xE1, 0x38, 0x77, 0xFD, 0x59, 0xFC, 0x01,
  0x30, 0x1A, 0x81, 0x30, 0x4A, 0x01, 0x48, 0x15, 0xFE, 0x28, 0x18, 0xFE, 0x58, 0x63, 0xFE, 0x24,
  0xEF, 0x66, 0x09, 0xB0, 0xE0, 0x66, 0x83, 0x4D, 0x63, 0x27, 0x18, 0x3E, 0xE5, 0x32, 0x71, 0x0D,
  0xC0, 0xE0, 0x95, 0x83, 0x3A, 0xED, 0xEB, 0x07, 0x38, 0x17, 0xF9, 0x38, 0x22, 0xDF, 0x93, 0xA0,
  0x24, 0x81, 0xCF, 0x63, 0x87, 0xCF, 0xB5, 0x45, 0xBF, 0xB4, 0x81, 0x19, 0xDA, 0x81, 0xDB, 0x55,
  // "h" (U+0068)
  0x10, 0x5B, 0x0E, 0x70, 0x10, 0x6A, 0x0B, 0x71, 0x03, 0xA0, 0x87, 0x10, 0x6A, 0x04, 0x71, 0x09,
  0xA8, 0x32, 0x9E, 0xF9, 0x48, 0x4C, 0xFD, 0xB5, 0xBA, 0x04, 0x3B, 0x81, 0x50, 0x7A, 0x05, 0x20,
  0x3A, 0x0B, 0x20, 0x9A, 0x03, 0x20, 0x7A, 0x05, 0x20, 0xCA, 0x30, 0xAA, 0x3A, 0x0C, 0x38, 0x1D,
  0xFC, 0x20, 0x3A, 0x08, 0x20, 0x1A, 0x09, 0x20, 0x5A, 0x06, 0x20, 0x4A, 0x06, 0x20, 0x4A, 0x82,
  0xA5, 0x38, 0xA0, 0x23, 0x82, 0xAE, 0xE8, 0x10,
  // "i" (U+0069)
  0x00, 0xAE, 0x80, 0x2F, 0xFD, 0x00, 0xAC, 0x40, 0x00, 0x00, 0xDF, 0xFF, 0x54, 0xDF, 0xF2, 0x0C,
  0xFE, 0x00, 0xFF, 0xB0, 0x3F, 0xF8, 0x06, 0xFF, 0x50, 0x9F, 0xF2, 0x0B, 0xFF, 0x00, 0xBF, 0xF5,
  0x73, 0xDF, 0xC4,
  // "j" (U+006A)
  0x68, 0x1A, 0xE8, 0x50, 0x2A, 0x0D, 0x68, 0x1A, 0xC4, 0x76, 0x0D, 0xB0, 0x54, 0x04, 0x0D, 0xA0,
  0x25, 0x81, 0xCF, 0xE6, 0xA0, 0xA5, 0x03, 0xA0, 0x75, 0x06, 0xA0, 0x45, 0x0A, 0xA0, 0x15, 0x81,
  0xDF, 0xD5, 0x01, 0xA0, 0x95, 0x05, 0xA0, 0x65, 0x08, 0xA0, 0x25, 0x81, 0xDF, 0xC3, 0x81, 0x14,
  0x9A, 0x04, 0x38, 0x35, 0xEF, 0xC4, 0x40,
  // "k" (U+006B)
  0x10, 0x5B, 0x0E, 0x70, 0x10, 0x6A, 0x0B, 0x71, 0x03, 0xA0, 0x87, 0x10, 0x6A, 0x05, 0x71, 0x09,
  0xA0, 0x10, 0x2C, 0x05, 0x28, 0x90, 0xCF, 0xD0, 0x1A, 0xFD, 0x61, 0x2A, 0x83, 0xA0, 0x2E, 0xA4,
  0x03, 0xA8, 0x26, 0x3E, 0x85, 0x07, 0xA0, 0x8A, 0x02, 0x50, 0xAA, 0x0D, 0xA0, 0xA5, 0x83, 0xDF,
  0xD0, 0xCA, 0x02, 0x30, 0x1A, 0x81, 0x90, 0x6A, 0x0A, 0x30, 0x4A, 0x06, 0x20, 0xEA, 0x08, 0x20,
  0x8A, 0x02, 0x28, 0x33, 0xBE, 0xF1, 0x10,
  // "l" (U+006C)
  0x5F, 0xFF, 0xE1, 0x6F, 0xFB, 0x03, 0xFF, 0x80, 0x6F, 0xF5, 0x09, 0xFF, 0x10, 0xDF, 0xD0, 0x0F,
  0xFA, 0x04, 0xFF, 0x70, 0x7F, 0xF4, 0x0A, 0xFF, 0x00, 0xDF, 0xD0, 0x0F, 0xFA, 0x00, 0xFF, 0xD5,
  0x57, 0xEE, 0xB2,
  // "m" (U+006D)
  0x0D, 0xFF, 0xF4, 0x5C, 0xEB, 0x01, 0x9E, 0xE5, 0x00, 0x4D, 0xFF, 0x7C, 0xCF, 0xF6, 0xBA, 0xFF,
  0xE0, 0x00, 0xCF, 0xFB, 0x05, 0xFF, 0xE4, 0x0D, 0xFE, 0x00, 0x0E, 0xFF, 0x20, 0x7F, 0xF9, 0x00,
  0xEF, 0xC0, 0x02, 0xFF, 0xA0, 0x09, 0xFF, 0x20, 0x1F, 0xF9, 0x00, 0x6F, 0xF5, 0x00, 0xDF, 0xD0,
  0x05, 0xFF, 0x60, 0x09, 0xFF, 0x20, 0x0F, 0xFA, 0x00, 0x8F, 0xF2, 0x00, 0xCF, 0xE0, 0x03, 0xFF,
  0x70, 0x0A, 0xFF, 0x00, 0x0F, 0xFA, 0x00, 0x6F, 0xF5, 0x00, 0xAF, 0xF9, 0x93, 0xFF, 0x70, 0x08,
  0xFF, 0x40, 0x03, 0xCF, 0xC4,
  // "n" (U+006E)
  0x0D, 0xFF, 0xF2, 0x7D, 0xFC, 0x10, 0x04, 0xDF, 0xF9, 0x78, 0xFF, 0x80, 0x00, 0xCF, 0xF9, 0x03,
  0xFF, 0x90, 0x00, 0xEF, 0xE1, 0x05, 0xFF, 0x70, 0x02, 0xFF, 0x90, 0x08, 0xFF, 0x40, 0x06, 0xFF,
  0x40, 0x0B, 0xFF, 0x10, 0x09, 0xFF, 0x10, 0x0E, 0xFD, 0x00, 0x0C, 0xFD, 0x00, 0x0F, 0xFB, 0x00,
  0x0F, 0xFA, 0x00, 0x0F, 0xFD, 0x55, 0x3F, 0xF7, 0x00, 0x06, 0xEE, 0xB2,
  // "o" (U+006F)
  0x00, 0x02, 0x9D, 0xFD, 0x81, 0x00, 0x04, 0xEF, 0x84, 0xDF, 0xB0, 0x02, 0xEF, 0x80, 0x06, 0xFF,
  0x30, 0xAF, 0xF1, 0x00, 0x5F, 0xF5, 0x0F, 0xFC, 0x00, 0x07, 0xFF, 0x53, 0xFF, 0x90, 0x00, 0xAF,
  0xF1, 0x4F, 0xF7, 0x00, 0x0E, 0xFB, 0x01, 0xFF, 0x80, 0x07, 0xFF, 0x30, 0x0A, 0xFE, 0x56, 0xFF,
  0x50, 0x00, 0x07, 0xDF, 0xDA, 0x30, 0x00,
  // "p" (U+0070)
  0x10, 0x2B, 0x84, 0xA1, 0xAE, 0xD5, 0x30, 0x5A, 0x82, 0x8B, 0x5B, 0xA0, 0x23, 0xA8, 0x2D, 0x30,
  0x4A, 0x06, 0x20, 0x4A, 0x09, 0x20, 0x4A, 0x07, 0x20, 0x7A, 0x04, 0x20, 0x5A, 0x05, 0x20, 0xAA,
  0x30, 0x9A, 0x01, 0x28, 0x1E, 0xFC, 0x38, 0x1E, 0xFA, 0x20, 0x2A, 0x09, 0x28, 0x27, 0xFE, 0x22,
  0x05, 0xA8, 0x1B, 0x47, 0xA0, 0x53, 0x08, 0xA8, 0x3B, 0xEE, 0xB3, 0x48, 0x1C, 0xFD, 0x72, 0xA0,
  0xA7, 0x10, 0x3A, 0x0B, 0x04, 0x70, 0x6C, 0x01, 0x60,
  // "q" (U+0071)
  0x38, 0x61, 0x9E, 0xEC, 0x7B, 0xB2, 0x84, 0x2E, 0xFA, 0x49, 0xA0, 0x82, 0x81, 0xCF, 0xA2, 0x05,
  0xA8, 0x14, 0x07, 0xA0, 0x32, 0x09, 0xA8, 0x31, 0x0D, 0xFC, 0x38, 0x3C, 0xFD, 0x01, 0xA0, 0x92,
  0x01, 0xA8, 0x1A, 0x03, 0xA0, 0x72, 0x07, 0xA8, 0x16, 0x02, 0xA8, 0x28, 0x01, 0xCA, 0x03, 0x28,
  0x4D, 0xFD, 0x4C, 0x7A, 0x38, 0x63, 0xCF, 0xC3, 0x8F, 0xC7, 0x18, 0x1C, 0xF8, 0x71, 0xA0, 0x57,
  0x03, 0xA0, 0x80, 0x36, 0x06, 0xB0, 0xC1,
  // "r" (U+0072)
  0x10, 0xDB, 0x89, 0x01, 0x8E, 0xE9, 0x04, 0xDF, 0xE0, 0xF8, 0xA2, 0x86, 0xBF, 0xE9, 0x02, 0xF8,
  0x20, 0xEA, 0x02, 0x20, 0x12, 0x02, 0xA0, 0xB6, 0x05, 0xA0, 0x66, 0x09, 0xA0, 0x26, 0x81, 0xCF,
  0xE7, 0xA0, 0xA6, 0x03, 0xA0, 0x76,
  // "s" (U+0073)
  0x00, 0x3A, 0xDF, 0xEA, 0x10, 0x3F, 0xF7, 0x4D, 0xFA, 0x08, 0xFD, 0x00, 0x6F, 0x70, 0x7F, 0xF7,
  0x01, 0x10, 0x01, 0xDF, 0xFE, 0x70, 0x00, 0x01, 0x9F, 0xFF, 0x90, 0x04, 0x10, 0x2C, 0xFF, 0x08,
  0xF6, 0x00, 0x5F, 0xF0, 0x8F, 0xD3, 0x2B, 0xF9, 0x00, 0x8D, 0xFE, 0xC6, 0x00,
  // "t" (U+0074)
  0x30, 0x80, 0xC3, 0x82, 0x3B, 0xF9, 0x20, 0xCD, 0x81, 0x83, 0xBA, 0x85, 0x53, 0x10, 0xCF, 0xE4,
  0xA0, 0xB3, 0x03, 0xA0, 0x83, 0x06, 0xA0, 0x53, 0x09, 0xA0, 0x23, 0x0B, 0xA4, 0x0A, 0xA8, 0x90,
  0x66, 0x50, 0x2B, 0xFD, 0x91, 0x10,
  // "u" (U+0075)
  0xDF, 0xFF, 0x60, 0x09, 0xFF, 0x14, 0xDF, 0xF2, 0x00, 0xCF, 0xD0, 0x0C, 0xFE, 0x00, 0x0F, 0xFA,
  0x00, 0xEF, 0xB0, 0x04, 0xFF, 0x70, 0x2F, 0xF8, 0x00, 0x8F, 0xF3, 0x06, 0xFF, 0x40, 0x0D, 0xFF,
  0x00, 0x9F, 0xF2, 0x05, 0xFF, 0xD0, 0x0B, 0xFF, 0x11, 0xBF, 0xFB, 0x00, 0xBF, 0xFC, 0xD2, 0xFF,
  0xE8, 0x74, 0xDF, 0xB2, 0x07, 0xEE, 0xA1,
  // "v" (U+0076)
  0x09, 0xB0, 0x12, 0x83, 0x6E, 0x83, 0xAA, 0x03, 0x28, 0x3A, 0xFE, 0x03, 0xA0, 0x63, 0x82, 0xCD,
  0x01, 0xA0, 0x83, 0x0C, 0x09, 0x28, 0x1E, 0xFA, 0x28, 0x11, 0xF3, 0x28, 0x1B, 0xFD, 0x20, 0x80,
  0xB3, 0x85, 0x9F, 0xE0, 0x3E, 0x23, 0x07, 0xA8, 0x12, 0xD7, 0x40, 0x4A, 0x0D, 0x0A, 0x50, 0x2A,
  0x0C, 0x70, 0x20, 0x15,
  // "w" (U+0077)
  0x02, 0xB0, 0x63, 0x81, 0xEF, 0x72, 0x83, 0xCD, 0x11, 0x8A, 0x07, 0x20, 0x5A, 0x84, 0x80, 0x1D,
  0xF4, 0x2A, 0x08, 0x20, 0xCA, 0x09, 0x28, 0x16, 0xF3, 0x28, 0x7E, 0xF8, 0x02, 0xEB, 0xFA, 0x20,
  0x70, 0xE3, 0x87, 0xEF, 0x90, 0x98, 0xAF, 0xA2, 0x0C, 0x08, 0x38, 0x93, 0xEF, 0x91, 0xE1, 0xAF,
  0xB0, 0x4E, 0x13, 0x89, 0x2D, 0xF9, 0x88, 0x09, 0xFC, 0x0D, 0x54, 0x89, 0x1D, 0xFC, 0xE1, 0x09,
  0xFC, 0xA9, 0x50, 0xDA, 0x07, 0x20, 0x9A, 0x0C, 0x68, 0x1C, 0xFC, 0x38, 0x29, 0xFD, 0x17, 0x50,
  0x01, 0x60,
  // "x" (U+0078)
  0x20, 0x7B, 0x02, 0x28, 0x19, 0xFD, 0x20, 0x20, 0x9A, 0x84, 0x70, 0x4F, 0x93, 0x48, 0x4E, 0xFC,
  0x1E, 0x86, 0x07, 0xA0, 0xC0, 0xA7, 0x01, 0xA0, 0xD7, 0x10, 0x20, 0xEA, 0x01, 0x68, 0x11, 0xD9,
  0xA0, 0x85, 0x86, 0x1D, 0xA0, 0xDF, 0xE1, 0x38, 0x15, 0xDD, 0x20, 0x8A, 0x82, 0xA2, 0x04, 0xA0,
  0x32, 0x02, 0xB0, 0x81,
  // "y" (U+0079)
  0x30, 0xDA, 0x0D, 0x38, 0x17, 0xE8, 0x30, 0x50, 0xDA, 0x01, 0x28, 0x1A, 0xFE, 0x40, 0x7A, 0x05,
  0x30, 0xD0, 0xC4, 0x03, 0xA0, 0x93, 0x0E, 0x08, 0x58, 0x1E, 0xFD, 0x28, 0x14, 0xF1, 0x50, 0xAA,
  0x82, 0x10, 0xC8, 0x60, 0x5A, 0x81, 0x46, 0xD7, 0x01, 0xA8, 0x19, 0xE4, 0x71, 0x0C, 0xA0, 0x97,
  0x28, 0x17, 0xFC, 0x73, 0x81, 0xBE, 0x27, 0x18, 0x21, 0xBF, 0x45, 0x0F, 0x48, 0x28, 0xEE, 0x46,
  0x84, 0xCF, 0xEC, 0x81, 0x70,
  // "z" (U+007A)
  0x10, 0x4F, 0x85, 0x70, 0x8E, 0x53, 0x5A, 0x83, 0xD1, 0x0C, 0x62, 0x0B, 0xA0, 0x35, 0x08, 0xA0,
  0x65, 0x04, 0xA0, 0xA5, 0x82, 0x2E, 0xFD, 0x68, 0x2C, 0xFE, 0x22, 0x05, 0x20, 0x9A, 0x05, 0x28,
  0x25, 0xD0, 0x5A, 0x86, 0xB3, 0x35, 0xE9, 0x0D, 0xF0, 0x61,
  // "{" (U+007B)
  0x50, 0x70, 0xDA, 0x04, 0x40, 0x7A, 0x0A, 0x04, 0x50, 0xDA, 0x60, 0x1A, 0x0B, 0x60, 0x4A, 0x08,
  0x60, 0x7A, 0x05, 0x60, 0xBA, 0x01, 0x40, 0x10, 0x6A, 0x08, 0x40, 0x2A, 0x0E, 0x04, 0x58, 0x41,
  0x5D, 0xFE, 0x16, 0x08, 0xA0, 0x36, 0x0B, 0xA7, 0x81, 0xEF, 0xC6, 0x02, 0xA0, 0x86, 0x03, 0xA0,
  0xA7, 0x0B, 0xB0, 0x16, 0x81, 0x23, 0x34,
  // "|" (U+007C)
  0x9A, 0x9A, 0x9A, 0x9A, 0x9A, 0x9A, 0x9A, 0x9A, 0x9A, 0x9A, 0x9A, 0x9A, 0x9A, 0x9A, 0x9A, 0x9A,
  0x9A, 0x9A,
  // "}" (U+007D)
  0x38, 0x3A, 0xFE, 0xB1, 0x40, 0x30, 0x8A, 0x08, 0x50, 0x1A, 0x0A, 0x50, 0x4A, 0x07, 0x50, 0x7A,
  0x04, 0x50, 0xAA, 0x01, 0x58, 0x1D, 0xFE, 0x60, 0xBA, 0x05, 0x01, 0x40, 0x10, 0xBA, 0x09, 0x38,
  0x43, 0xDF, 0xC5, 0x13, 0x0B, 0xA0, 0x25, 0x81, 0xEF, 0xD5, 0x03, 0xA0, 0x95, 0x07, 0xA0, 0x64,
  0x02, 0x0D, 0xA0, 0x13, 0x0D, 0xA0, 0xE0, 0x54, 0x81, 0x33, 0x26,
  // "~" (U+007E)
  0x04, 0xDF, 0x90, 0x02, 0xF2, 0x0D, 0xA5, 0xDC, 0x27, 0xE0, 0x1F, 0x30, 0x1B, 0xFF, 0x70, 0x03,
  0x00, 0x00, 0x11, 0x00,
  // "¡" (U+00A1)
  0x38, 0x1B, 0xE6, 0x20, 0x3A, 0x0A, 0x28, 0x21, 0xCD, 0x47, 0x20, 0x80, 0x33, 0x81, 0x1F, 0x33,
  0x81, 0x7F, 0x13, 0x0C, 0x93, 0x81, 0x2F, 0xD3, 0x81, 0x8F, 0xB3, 0x81, 0xDF, 0x92, 0x04, 0xA0,
  0x82, 0x82, 0x9E, 0xE5, 0x20,
  // "¢" (U+00A2)
  0x50, 0x29, 0x78, 0x15, 0xAD, 0x58, 0x53, 0xDD, 0xCF, 0xE9, 0x28, 0x43, 0xEF, 0x3C, 0xAA, 0x89,
  0x24, 0x0D, 0xFA, 0x0F, 0x2D, 0xB0, 0x5A, 0x81, 0x43, 0xE4, 0x09, 0xA8, 0x11, 0x6B, 0x40, 0xBA,
  0x10, 0xA0, 0x74, 0x0B, 0xA8, 0x31, 0xD4, 0x02, 0x20, 0x6A, 0x83, 0xBF, 0x25, 0xE3, 0x09, 0xC0,
  0xE0, 0x54, 0x82, 0x2A, 0xA2, 0x70, 0xA0, 0x65,
  // "£" (U+00A3)
  0x48, 0x45, 0xBE, 0xFD, 0x74, 0x83, 0xAF, 0xC5, 0x7A, 0x05, 0x20, 0x3A, 0x03, 0x28, 0x1D, 0xE2,
  0x20, 0x5A, 0x30, 0x24, 0x04, 0xA0, 0x26, 0xF0, 0x43, 0x00, 0x3A, 0x81, 0x73, 0x36, 0xA0, 0x47,
  0x82, 0x1F, 0xE1, 0x78, 0x18, 0xF4, 0x78, 0x91, 0x5F, 0xA9, 0x62, 0x03, 0x40, 0x8F, 0x98, 0x91,
  0x70, 0x96, 0x34, 0x7C, 0xEC, 0x42,
  // "¤" (U+00A4)
  0x04, 0x00, 0x00, 0x04, 0x3F, 0x9D, 0xEB, 0xCD, 0x09, 0xF7, 0x4B, 0xF3, 0x0C, 0x70, 0x00, 0xD6,
  0x0F, 0x30, 0x00, 0xA8, 0x0D, 0x60, 0x00, 0xC7, 0x09, 0xE3, 0x18, 0xF3, 0x3F, 0xCF, 0xFE, 0xDC,
  0x06, 0x01, 0x20, 0x15,
  // "¥" (U+00A5)
  0x10, 0x5C, 0x08, 0x04, 0xB8, 0x27, 0x01, 0x9A, 0x85, 0x71, 0x19, 0xFA, 0x12, 0x03, 0xA0, 0x42,
  0x09, 0x0C, 0x58, 0x5E, 0xF7, 0x03, 0xE2, 0x58, 0x4B, 0xFA, 0x0B, 0x76, 0x83, 0x7F, 0xD5, 0xC7,
  0x04, 0xA0, 0xD0, 0x35, 0x09, 0xF0, 0x13, 0x81, 0x33, 0x7A, 0x81, 0x73, 0x33, 0x01, 0xF0, 0x94,
  0x86, 0x33, 0xDF, 0xE3, 0x31, 0x40, 0x40, 0x7A, 0x81, 0xD4, 0x14, 0x02, 0xE0, 0x44,
  // "¦" (U+00A6)
  0x9A, 0x9A, 0x9A, 0x9A, 0x9A, 0x9A, 0x9A, 0x00, 0x00, 0x00, 0x00, 0x9A, 0x9A, 0x9A, 0x9A, 0x9A,
  0x9A, 0x9A,
  // "§" (U+00A7)
  0x48, 0x37, 0xDF, 0xD9, 0x48, 0x59, 0xF8, 0x4C, 0xF8, 0x28, 0x12, 0xFB, 0x28, 0x13, 0xFA, 0x28,
  0x14, 0xFB, 0x30, 0x70, 0x12, 0x02, 0xA0, 0x66, 0x03, 0xB0, 0xC0, 0x33, 0x82, 0x3F, 0x48, 0xB0,
  0x62, 0x84, 0x7F, 0x20, 0x19, 0xA8, 0x41, 0x06, 0xFC, 0x32, 0x81, 0xBF, 0x22, 0x0C, 0xA8, 0x2A,
  0x1B, 0xB4, 0x07, 0x0E, 0xA0, 0xC6, 0x82, 0x1B, 0xFA, 0x30, 0x70, 0x13, 0x90, 0xC2, 0x81, 0x8F,
  0x43, 0x0E, 0x0A, 0x28, 0x67, 0xFD, 0x21, 0x9F, 0x33, 0x09, 0xB0, 0xD0, 0x46, 0x00, 0x25,
  // "¨" (U+00A8)
  0x6B, 0x20, 0x6C, 0x2D, 0xF5, 0x0D, 0xF6, 0x9E, 0x20, 0x9E, 0x20,
  // "©" (U+00A9)
  0x38, 0x55, 0xBE, 0xFE, 0xB6, 0x58, 0x91, 0x1A, 0xE9, 0x53, 0x48, 0xEC, 0x23, 0x83, 0xBC, 0x24,
  0xCA, 0x82, 0xA1, 0xAD, 0x28, 0xA1, 0x5E, 0x13, 0xFB, 0x46, 0xF6, 0x0C, 0x80, 0xB9, 0x0B, 0xE3,
  0x89, 0x17, 0x20, 0x5D, 0x0D, 0x50, 0xFA, 0x68, 0x61, 0xF1, 0xF3, 0x1F, 0x97, 0x98, 0x42, 0xE4,
  0x0F, 0xA6, 0x86, 0x1F, 0x1B, 0x70, 0xCD, 0x68, 0x96, 0x4E, 0x06, 0xD0, 0x5F, 0x91, 0x18, 0x70,
  0xB9, 0x28, 0x2C, 0xA0, 0x8B, 0x83, 0xC1, 0x8E, 0x12, 0x89, 0x12, 0xDD, 0x63, 0x34, 0x5B, 0xE3,
  0x50, 0x80, 0xDB, 0x81, 0xE9, 0x17, 0x18, 0x11, 0x21, 0x60,
  // "ª" (U+00AA)
  0x00, 0x7D, 0xCC, 0xE0, 0x0A, 0xF4, 0x0F, 0xC0, 0x4F, 0xB0, 0x3F, 0x90, 0x8F, 0x80, 0x8F, 0x60,
  0x8F, 0x71, 0xBF, 0x40, 0x2D, 0xD6, 0x4E, 0xB4,
  // "«" (U+00AB)
  0x00, 0x04, 0x50, 0x07, 0x30, 0x06, 0xF4, 0x0B, 0xD0, 0x07, 0xF8, 0x1C, 0xF3, 0x07, 0xFD, 0x1D,
  0xF8, 0x00, 0xDF, 0x73, 0xFF, 0x10, 0x06, 0xFA, 0x0C, 0xF5, 0x00, 0x0C, 0xE0, 0x2F, 0x90, 0x00,
  0x2F, 0x40, 0x8D, 0x00,
  // "¬" (U+00AC)
  0x0C, 0xE0, 0xD0, 0x28, 0x01, 0x30, 0x80, 0xD6, 0x06, 0x0D, 0x60, 0x60, 0xD6, 0x04, 0x09,
  // "®" (U+00AE)
  0x00, 0x05, 0xBE, 0xFE, 0xB6, 0x00, 0x00, 0x01, 0xAF, 0x95, 0x44, 0x8E, 0xC2, 0x00, 0x0B, 0xCF,
  0xFF, 0xFE, 0x81, 0xAD, 0x00, 0x5E, 0x13, 0xDB, 0x37, 0xF6, 0x0C, 0x80, 0xB9, 0x00, 0xAA, 0x00,
  0xD9, 0x05, 0xD0, 0xD5, 0x00, 0xAB, 0x04, 0xF6, 0x01, 0xF1, 0xF3, 0x00, 0xAF, 0xFF, 0x70, 0x00,
  0xF2, 0xE4, 0x00, 0xAB, 0x6F, 0x50, 0x01, 0xF1, 0xB7, 0x00, 0xAA, 0x0C, 0xD0, 0x04, 0xE0, 0x6D,
  0x00, 0xCC, 0x04, 0xF9, 0x0B, 0x90, 0x0C, 0xAD, 0xFF, 0xC0, 0xCF, 0xFE, 0x10, 0x02, 0xDF, 0x95,
  0x31, 0x6F, 0xF3, 0x00, 0x00, 0x08, 0xDF, 0xFF, 0xE9, 0x10, 0x00, 0x00, 0x00, 0x01, 0x21, 0x00,
  0x00, 0x00,
  // "¯" (U+00AF)
  0xF9, 0x05, 0x80, 0x43, 0x10,
  // "°" (U+00B0)
  0x09, 0xEE, 0x90, 0x7E, 0x55, 0xE8, 0xB9, 0x00, 0x8C, 0x9D, 0x22, 0xCA, 0x1C, 0xFF, 0xC1, 0x00,
  0x22, 0x00,
  // "±" (U+00B1)
  0x30, 0x90, 0xA6, 0x09, 0x0A, 0x60, 0x90, 0xA6, 0x09, 0x0A, 0x30, 0xCE, 0x84, 0xD2, 0x33, 0xBB,
  0x0F, 0x33, 0x09, 0x0A, 0x60, 0x90, 0xA7, 0x48, 0x04, 0x30, 0xCE, 0x0D,
  // "²" (U+00B2)
  0x28, 0xA1, 0x6B, 0xCA, 0x20, 0x5F, 0x53, 0xFB, 0x02, 0xB0, 0x3F, 0x94, 0x81, 0xAE, 0x23, 0x81,
  0x8D, 0x22, 0x89, 0x41, 0xBA, 0x01, 0x13, 0xD8, 0x12, 0xB3, 0xCD, 0x18, 0x02, 0x41,
  // "³" (U+00B3)
  0x00, 0x7C, 0xCB, 0x40, 0x4F, 0x51, 0xFD, 0x00, 0x10, 0x6F, 0x70, 0x06, 0xDE, 0x50, 0x00, 0x00,
  0xBF, 0x34, 0x60, 0x07, 0xF6, 0xBD, 0x00, 0xBE, 0x12, 0xAC, 0xC9, 0x20,
  // "´" (U+00B4)
  0x02, 0xFF, 0xA0, 0xCF, 0x70, 0xAC, 0x30, 0x00,
  // "µ" (U+00B5)
  0x20, 0x4A, 0x06, 0x20, 0x8A, 0x02, 0x20, 0x8A, 0x03, 0x28, 0x1C, 0xFE, 0x30, 0xBA, 0x3A, 0x0B,
  0x38, 0x1E, 0xFC, 0x20, 0x3A, 0x08, 0x20, 0x2A, 0x09, 0x20, 0x6A, 0x05, 0x20, 0x5A, 0x05, 0x20,
  0xAA, 0x01, 0x20, 0x9A, 0x03, 0x28, 0x1E, 0xFE, 0x30, 0xCA, 0x81, 0x30, 0x6A, 0x0C, 0x28, 0x61,
  0xFE, 0xFC, 0x9B, 0xCA, 0x89, 0x69, 0x85, 0xF3, 0xDE, 0xA0, 0x5E, 0xEB, 0x2A, 0xD7, 0x30, 0xD0,
  0xE7, 0x3A, 0x0B, 0x01, 0x71, 0x81, 0xBE, 0x97, 0x20,
  // "¶" (U+00B6)
  0x10, 0x90, 0xEF, 0x07, 0xC8, 0x49, 0x4F, 0xB4, 0xBC, 0x84, 0x70, 0xF4, 0x0C, 0xC8, 0x47, 0x0F,
  0x40, 0xAC, 0x84, 0x70, 0xF4, 0x06, 0xC8, 0x27, 0x0F, 0x42, 0x09, 0x0E, 0xA8, 0x27, 0x0F, 0x45,
  0x83, 0xC7, 0x0F, 0x45, 0x83, 0xC7, 0x0F, 0x45, 0x83, 0xC7, 0x0F, 0x45, 0x83, 0xC7, 0x0F, 0x45,
  0x83, 0xC7, 0x0F, 0x45, 0x83, 0xC7, 0x0F, 0x45, 0x83, 0xC7, 0x0F, 0x44, 0x85, 0x3E, 0x70, 0xF9,
  0x12, 0x08, 0xA0, 0x71, 0xB2, 0x82, 0x13, 0x31, 0x10, 0xF3,
  // "·" (U+00B7)
  0x1C, 0xD3, 0x6F, 0xF7, 0x3E, 0xD2,
  // "¸" (U+00B8)
  0x00, 0x13, 0x00, 0x0A, 0xB2, 0x00, 0x5E, 0xD0, 0x13, 0xED, 0x6F, 0xFD, 0x30, 0x22, 0x00,
  // "¹" (U+00B9)
  0x00, 0x00, 0x11, 0x00, 0x08, 0xF8, 0x04, 0xDB, 0xF5, 0x01, 0x2A, 0xF1, 0x00, 0x0D, 0xE0, 0x00,
  0x1F, 0xB0, 0x00, 0x4F, 0x70, 0x00, 0x8F, 0x50, 0x5C, 0xDD, 0xD8,
  // "º" (U+00BA)
  0x00, 0x8D, 0xCC, 0x30, 0xBF, 0x20, 0xFE, 0x6F, 0x90, 0x0F, 0xF9, 0xF6, 0x03, 0xFC, 0x8F, 0x60,
  0xAF, 0x30, 0x9D, 0xCB, 0x30,
  // "»" (U+00BB)
  0x00, 0x72, 0x03, 0x70, 0x00, 0x0C, 0xC0, 0x2F, 0x60, 0x00, 0x8F, 0x60, 0xDE, 0x10, 0x03, 0xFE,
  0x19, 0xF9, 0x00, 0x3F, 0xF2, 0x9F, 0xB0, 0x0C, 0xF6, 0x3F, 0xD2, 0x08, 0xF5, 0x0D, 0xC1, 0x04,
  0xE4, 0x09, 0xB1, 0x00,
  // "¼" (U+00BC)
  0x40, 0x01, 0x75, 0x81, 0x8F, 0x84, 0x81, 0x1E, 0x83, 0x83, 0x4D, 0xBF, 0x54, 0x0A, 0x0C, 0x48,
  0x31, 0x2A, 0xF1, 0x38, 0x16, 0xE2, 0x60, 0xD0, 0xE3, 0x81, 0x2E, 0x66, 0x81, 0x1F, 0xB3, 0x0C,
  0x0B, 0x30, 0x13, 0x81, 0x4F, 0x72, 0x81, 0x7E, 0x12, 0x81, 0xAF, 0x42, 0x85, 0x8F, 0x50, 0x3F,
  0x52, 0x09, 0xA8, 0x71, 0x5C, 0xDD, 0xD9, 0xD9, 0x28, 0x27, 0xAD, 0xE6, 0x09, 0x0D, 0x28, 0x35,
  0xC1, 0xFB, 0x58, 0x90, 0x4F, 0x30, 0x3D, 0x13, 0xF8, 0x48, 0x11, 0xE8, 0x28, 0x1C, 0xEE, 0xB0,
  0xA3, 0x0B, 0x0C, 0x68, 0x1A, 0xF2, 0x38, 0x16, 0xE2, 0x48, 0x31, 0xCD, 0xDC, 0x10,
  // "½" (U+00BD)
  0x40, 0x01, 0x75, 0x81, 0x8F, 0x84, 0x81, 0x1E, 0x83, 0x83, 0x4D, 0xBF, 0x54, 0x0A, 0x0C, 0x48,
  0x31, 0x2A, 0xF1, 0x38, 0x16, 0xE2, 0x60, 0xD0, 0xE3, 0x81, 0x2E, 0x66, 0x81, 0x1F, 0xB3, 0x0C,
  0x0B, 0x78, 0x14, 0xF7, 0x28, 0x67, 0xE1, 0x6B, 0xCA, 0x22, 0x8B, 0x28, 0xF5, 0x03, 0xF5, 0x5F,
  0x53, 0xFB, 0x5C, 0xDD, 0xD9, 0xD9, 0x02, 0xB0, 0x3F, 0x95, 0x09, 0x0D, 0x58, 0x1A, 0xE2, 0x48,
  0x14, 0xF3, 0x48, 0x18, 0xD2, 0x48, 0x11, 0xE8, 0x38, 0x41, 0xBA, 0x01, 0x13, 0x0B, 0x0C, 0x38,
  0x53, 0xD8, 0x12, 0xB3, 0x28, 0x16, 0xE2, 0x30, 0xCD, 0x72, 0x80, 0x24, 0x10,
  // "¾" (U+00BE)
  0x28, 0x37, 0xCC, 0xB4, 0x38, 0x11, 0xE8, 0x38, 0x44, 0xF5, 0x1F, 0xD3, 0x0A, 0x0C, 0x58, 0x31,
  0x06, 0xF7, 0x28, 0x16, 0xE2, 0x58, 0x26, 0xDE, 0x52, 0x81, 0x2E, 0x67, 0x18, 0x4B, 0xF3, 0x0C,
  0xB3, 0x82, 0x10, 0x46, 0x28, 0x47, 0xF6, 0x7E, 0x12, 0x83, 0xAF, 0x4B, 0xD2, 0x83, 0xBE, 0x5F,
  0x52, 0x09, 0xA8, 0x71, 0x2A, 0xCC, 0x93, 0xD9, 0x28, 0x27, 0xAD, 0xE6, 0x09, 0x0D, 0x28, 0x35,
  0xC1, 0xFB, 0x58, 0x90, 0x4F, 0x30, 0x3D, 0x13, 0xF8, 0x48, 0x11, 0xE8, 0x28, 0x1C, 0xEE, 0xB0,
  0xA3, 0x0B, 0x0C, 0x68, 0x1A, 0xF2, 0x38, 0x16, 0xE2, 0x48, 0x31, 0xCD, 0xDC, 0x10,
  // "¿" (U+00BF)
  0x48, 0x21, 0xCE, 0x44, 0x05, 0xA0, 0x94, 0x82, 0x1C, 0xD2, 0x76, 0x0B, 0x03, 0x58, 0x15, 0xF5,
  0x38, 0x33, 0xBF, 0xD3, 0x28, 0x28, 0xFE, 0x63, 0x07, 0xA0, 0x54, 0x81, 0xDF, 0xE2, 0x84, 0x18,
  0x3E, 0xFD, 0x28, 0x25, 0xFE, 0xAA, 0x86, 0x41, 0xCF, 0xD1, 0x9E, 0xA8, 0x1E, 0xA1, 0x30, 0x01,
  0x30,
  // "À" (U+00C0)
  0x68, 0x22, 0xEF, 0x77, 0x48, 0x14, 0xFD, 0x75, 0x81, 0x3D, 0x77, 0x77, 0x48, 0x1D, 0xFE, 0x73,
  0x07, 0xB0, 0x17, 0x18, 0x11, 0xEB, 0xA0, 0x37, 0x18, 0x1A, 0xD5, 0xA0, 0x57, 0x82, 0x3F, 0x53,
  0xA0, 0x77, 0x82, 0xCC, 0x02, 0xA0, 0xA6, 0x81, 0x6F, 0x42, 0xA0, 0xC5, 0x81, 0x1E, 0xB3, 0x81,
  0xEF, 0xE5, 0x09, 0xF9, 0x01, 0x38, 0x63, 0xF9, 0x22, 0x22, 0xBA, 0x03, 0x30, 0xC0, 0xD5, 0x08,
  0xA8, 0x56, 0x02, 0x9F, 0xC4, 0x30, 0x40, 0xBA, 0x81, 0xC3, 0xCB, 0x0D, 0x20, 0x4D, 0x0A,
  // "Á" (U+00C1)
  0x73, 0x02, 0xA0, 0xA7, 0x38, 0x1C, 0xF7, 0x73, 0x81, 0xAC, 0x37, 0x77, 0x38, 0x1D, 0xFE, 0x73,
  0x07, 0xB0, 0x17, 0x18, 0x11, 0xEB, 0xA0, 0x37, 0x18, 0x1A, 0xD5, 0xA0, 0x57, 0x82, 0x3F, 0x53,
  0xA0, 0x77, 0x82, 0xCC, 0x02, 0xA0, 0xA6, 0x81, 0x6F, 0x42, 0xA0, 0xC5, 0x81, 0x1E, 0xB3, 0x81,
  0xEF, 0xE5, 0x09, 0xF9, 0x01, 0x38, 0x63, 0xF9, 0x22, 0x22, 0xBA, 0x03, 0x30, 0xC0, 0xD5, 0x08,
  0xA8, 0x56, 0x02, 0x9F, 0xC4, 0x30, 0x40, 0xBA, 0x81, 0xC3, 0xCB, 0x0D, 0x20, 0x4D, 0x0A,
  // "Â" (U+00C2)
  0x71, 0x0C, 0xA0, 0x47, 0x28, 0x3A, 0xF8, 0xEB, 0x71, 0x85, 0xAD, 0x30, 0x3E, 0x47, 0x77, 0x28,
  0x1D, 0xFE, 0x73, 0x07, 0xB0, 0x17, 0x18, 0x11, 0xEB, 0xA0, 0x37, 0x18, 0x1A, 0xD5, 0xA0, 0x57,
  0x82, 0x3F, 0x53, 0xA0, 0x77, 0x82, 0xCC, 0x02, 0xA0, 0xA6, 0x81, 0x6F, 0x42, 0xA0, 0xC5, 0x81,
  0x1E, 0xB3, 0x81, 0xEF, 0xE5, 0x09, 0xF9, 0x01, 0x38, 0x63, 0xF9, 0x22, 0x22, 0xBA, 0x03, 0x30,
  0xC0, 0xD5, 0x08, 0xA8, 0x56, 0x02, 0x9F, 0xC4, 0x30, 0x40, 0xBA, 0x81, 0xC3, 0xCB, 0x0D, 0x20,
  0x4D, 0x0A,
  // "Ã" (U+00C3)
  0x78, 0x4B, 0xFB, 0x42, 0xE7, 0x82, 0x99, 0x5C, 0xA0, 0x57, 0x03, 0x30, 0x20, 0x17, 0x77, 0x38,
  0x1D, 0xFE, 0x73, 0x07, 0xB0, 0x17, 0x18, 0x11, 0xEB, 0xA0, 0x37, 0x18, 0x1A, 0xD5, 0xA0, 0x57,
  0x82, 0x3F, 0x53, 0xA0, 0x77, 0x82, 0xCC, 0x02, 0xA0, 0xA6, 0x81, 0x6F, 0x42, 0xA0, 0xC5, 0x81,
  0x1E, 0xB3, 0x81, 0xEF, 0xE5, 0x09, 0xF9, 0x01, 0x38, 0x63, 0xF9, 0x22, 0x22, 0xBA, 0x03, 0x30,
  0xC0, 0xD5, 0x08, 0xA8, 0x56, 0x02, 0x9F, 0xC4, 0x30, 0x40, 0xBA, 0x81, 0xC3, 0xCB, 0x0D, 0x20,
  0x4D, 0x0A,
  // "Ä" (U+00C4)
  0x78, 0x56, 0xB2, 0x06, 0xC2, 0x78, 0x5D, 0xF5, 0x0D, 0xF6, 0x78, 0x59, 0xE2, 0x09, 0xE2, 0x77,
  0x71, 0x81, 0xDF, 0xE7, 0x30, 0x7B, 0x01, 0x71, 0x81, 0x1E, 0xBA, 0x03, 0x71, 0x81, 0xAD, 0x5A,
  0x05, 0x78, 0x23, 0xF5, 0x3A, 0x07, 0x78, 0x2C, 0xC0, 0x2A, 0x0A, 0x68, 0x16, 0xF4, 0x2A, 0x0C,
  0x58, 0x11, 0xEB, 0x38, 0x1E, 0xFE, 0x50, 0x9F, 0x90, 0x13, 0x86, 0x3F, 0x92, 0x22, 0x2B, 0xA0,
  0x33, 0x0C, 0x0D, 0x50, 0x8A, 0x85, 0x60, 0x29, 0xFC, 0x43, 0x04, 0x0B, 0xA8, 0x1C, 0x3C, 0xB0,
  0xD2, 0x04, 0xD0, 0xA0,
  // "Å" (U+00C5)
  0x71, 0x82, 0xBF, 0xC2, 0x72, 0x83, 0x7C, 0x4A, 0x97, 0x28, 0x37, 0xA1, 0x8A, 0x72, 0x02, 0xB0,
  0x37, 0x20, 0x7B, 0x01, 0x71, 0x81, 0x1E, 0xBA, 0x03, 0x71, 0x81, 0xAD, 0x5A, 0x05, 0x78, 0x23,
  0xF5, 0x3A, 0x07, 0x78, 0x2C, 0xC0, 0x2A, 0x0A, 0x68, 0x16, 0xF4, 0x2A, 0x0C, 0x58, 0x11, 0xEB,
  0x38, 0x1E, 0xFE, 0x50, 0x9F, 0x90, 0x13, 0x86, 0x3F, 0x92, 0x22, 0x2B, 0xA0, 0x33, 0x0C, 0x0D,
  0x50, 0x8A, 0x85, 0x60, 0x29, 0xFC, 0x43, 0x04, 0x0B, 0xA8, 0x1C, 0x3C, 0xB0, 0xD2, 0x04, 0xD0,
  0xA0,
  // "Æ" (U+00C6)
  0x71, 0x07, 0xFB, 0x03, 0x71, 0x81, 0x1C, 0xAA, 0x83, 0xC3, 0x34, 0xD9, 0x72, 0x81, 0x6C, 0x4A,
  0x08, 0x30, 0x80, 0xD7, 0x18, 0x23, 0xE3, 0x7A, 0x05, 0x30, 0x50, 0x77, 0x18, 0x2D, 0x70, 0xAA,
  0x02, 0x75, 0x0A, 0x0C, 0x28, 0x1D, 0xFE, 0x75, 0x83, 0x6E, 0x20, 0x1E, 0x0D, 0x78, 0x13, 0xF6,
  0x20, 0x5A, 0x83, 0x93, 0x33, 0x27, 0x0D, 0xF0, 0x57, 0x38, 0x5A, 0xE4, 0x33, 0x3C, 0xA0, 0x14,
  0x01, 0x48, 0x16, 0xF3, 0x48, 0x1E, 0xFD, 0x40, 0x80, 0xC3, 0x81, 0x5F, 0xC4, 0x05, 0xA0, 0xA3,
  0x81, 0x4E, 0x82, 0x0A, 0xB8, 0x1C, 0x01, 0xFB, 0x04, 0x20,
  // "Ç" (U+00C7)
  0x48, 0x52, 0x8C, 0xEE, 0xD7, 0x48, 0x47, 0xFE, 0x74, 0xAA, 0x07, 0x28, 0x29, 0xFE, 0x32, 0x01,
  0xA8, 0x18, 0x06, 0xA0, 0x74, 0x0B, 0x08, 0x28, 0x1E, 0xFE, 0x71, 0x05, 0xA0, 0x97, 0x10, 0xAA,
  0x05, 0x71, 0x0C, 0xA0, 0x37, 0x10, 0xCA, 0x02, 0x71, 0x0B, 0xA0, 0x47, 0x10, 0x5A, 0x0A, 0x40,
  0x10, 0x73, 0x09, 0xA8, 0x4A, 0x54, 0x7D, 0x64, 0x05, 0x0B, 0xA8, 0x1E, 0xB5, 0x78, 0x1A, 0xB2,
  0x72, 0x81, 0x5E, 0xD7, 0x18, 0x21, 0x3E, 0xD7, 0x06, 0xA0, 0xD0, 0x37, 0x10, 0x02, 0x70,
  // "È" (U+00C8)
  0x58, 0x22, 0xEF, 0x77, 0x38, 0x14, 0xFD, 0x74, 0x81, 0x3D, 0x77, 0x75, 0x0C, 0xF9, 0x0E, 0x40,
  0x7A, 0x07, 0x28, 0x11, 0xEC, 0x40, 0x8A, 0x04, 0x30, 0xC0, 0x94, 0x0B, 0xA0, 0x13, 0x07, 0x04,
  0x48, 0x1E, 0xFD, 0x72, 0x02, 0xA0, 0xB7, 0x20, 0x6E, 0x09, 0x50, 0x9A, 0x83, 0x63, 0x33, 0x15,
  0x0C, 0xA0, 0x17, 0x2A, 0x0D, 0x40, 0x01, 0x30, 0x3A, 0x09, 0x40, 0xC0, 0x83, 0x09, 0xA0, 0x63,
  0x83, 0x7F, 0x40, 0x4F, 0xB0, 0x11,
  // "É" (U+00C9)
  0x72, 0x02, 0xA0, 0xA7, 0x28, 0x1C, 0xF7, 0x72, 0x81, 0xAC, 0x37, 0x74, 0x0C, 0xF9, 0x0E, 0x40,
  0x7A, 0x07, 0x28, 0x11, 0xEC, 0x40, 0x8A, 0x04, 0x30, 0xC0, 0x94, 0x0B, 0xA0, 0x13, 0x07, 0x04,
  0x48, 0x1E, 0xFD, 0x72, 0x02, 0xA0, 0xB7, 0x20, 0x6E, 0x09, 0x50, 0x9A, 0x83, 0x63, 0x33, 0x15,
  0x0C, 0xA0, 0x17, 0x2A, 0x0D, 0x40, 0x01, 0x30, 0x3A, 0x09, 0x40, 0xC0, 0x83, 0x09, 0xA0, 0x63,
  0x83, 0x7F, 0x40, 0x4F, 0xB0, 0x11,
  // "Ê" (U+00CA)
  0x71, 0x0C, 0xA0, 0x47, 0x18, 0x3A, 0xF8, 0xEB, 0x78, 0x5A, 0xD3, 0x03, 0xE4, 0x77, 0x20, 0xCF,
  0x90, 0xE4, 0x07, 0xA0, 0x72, 0x81, 0x1E, 0xC4, 0x08, 0xA0, 0x43, 0x0C, 0x09, 0x40, 0xBA, 0x01,
  0x30, 0x70, 0x44, 0x81, 0xEF, 0xD7, 0x20, 0x2A, 0x0B, 0x72, 0x06, 0xE0, 0x95, 0x09, 0xA8, 0x36,
  0x33, 0x31, 0x50, 0xCA, 0x01, 0x72, 0xA0, 0xD4, 0x00, 0x13, 0x03, 0xA0, 0x94, 0x0C, 0x08, 0x30,
  0x9A, 0x06, 0x38, 0x37, 0xF4, 0x04, 0xFB, 0x01, 0x10,
  // "Ë" (U+00CB)
  0x68, 0x56, 0xB2, 0x06, 0xC2, 0x68, 0x5D, 0xF5, 0x0D, 0xF6, 0x68, 0x59, 0xE2, 0x09, 0xE2, 0x77,
  0x20, 0xCF, 0x90, 0xE4, 0x07, 0xA0, 0x72, 0x81, 0x1E, 0xC4, 0x08, 0xA0, 0x43, 0x0C, 0x09, 0x40,
  0xBA, 0x01, 0x30, 0x70, 0x44, 0x81, 0xEF, 0xD7, 0x20, 0x2A, 0x0B, 0x72, 0x06, 0xE0, 0x95, 0x09,
  0xA8, 0x36, 0x33, 0x31, 0x50, 0xCA, 0x01, 0x72, 0xA0, 0xD4, 0x00, 0x13, 0x03, 0xA0, 0x94, 0x0C,
  0x08, 0x30, 0x9A, 0x06, 0x38, 0x37, 0xF4, 0x04, 0xFB, 0x01, 0x10,
  // "Ì" (U+00CC)
  0x38, 0x22, 0xEF, 0x77, 0x81, 0x4F, 0xD7, 0x18, 0x13, 0xD7, 0x77, 0x10, 0xCD, 0x06, 0x30, 0x30,
  0xAA, 0x81, 0xC5, 0x14, 0x07, 0xA0, 0x56, 0x0B, 0xA0, 0x16, 0x81, 0xEF, 0xD6, 0x02, 0xA0, 0xA6,
  0x05, 0xA0, 0x66, 0x09, 0xA0, 0x36, 0x0C, 0xA7, 0xA0, 0xC6, 0x04, 0xA0, 0x85, 0x05, 0x0C, 0xA0,
  0xA0, 0x43, 0x05, 0xD0, 0xD3,
  // "Í" (U+00CD)
  0x60, 0x2A, 0x0A, 0x68, 0x1C, 0xF7, 0x68, 0x1A, 0xC3, 0x77, 0x10, 0xCD, 0x06, 0x30, 0x30, 0xAA,
  0x81, 0xC5, 0x14, 0x07, 0xA0, 0x56, 0x0B, 0xA0, 0x16, 0x81, 0xEF, 0xD6, 0x02, 0xA0, 0xA6, 0x05,
  0xA0, 0x66, 0x09, 0xA0, 0x36, 0x0C, 0xA7, 0xA0, 0xC6, 0x04, 0xA0, 0x85, 0x05, 0x0C, 0xA0, 0xA0,
  0x43, 0x05, 0xD0, 0xD3,
  // "Î" (U+00CE)
  0x50, 0xCA, 0x04, 0x58, 0x3A, 0xF8, 0xEB, 0x48, 0x5A, 0xD3, 0x03, 0xE4, 0x76, 0x0C, 0xD0, 0x63,
  0x03, 0x0A, 0xA8, 0x1C, 0x51, 0x40, 0x7A, 0x05, 0x60, 0xBA, 0x01, 0x68, 0x1E, 0xFD, 0x60, 0x2A,
  0x0A, 0x60, 0x5A, 0x06, 0x60, 0x9A, 0x03, 0x60, 0xCA, 0x7A, 0x0C, 0x60, 0x4A, 0x08, 0x50, 0x50,
  0xCA, 0x0A, 0x04, 0x30, 0x5D, 0x0D, 0x30,
  // "Ï" (U+00CF)
  0x38, 0x56, 0xB2, 0x06, 0xC2, 0x38, 0x5D, 0xF5, 0x0D, 0xF6, 0x38, 0x59, 0xE2, 0x09, 0xE2, 0x76,
  0x0C, 0xD0, 0x63, 0x03, 0x0A, 0xA8, 0x1C, 0x51, 0x40, 0x7A, 0x05, 0x60, 0xBA, 0x01, 0x68, 0x1E,
  0xFD, 0x60, 0x2A, 0x0A, 0x60, 0x5A, 0x06, 0x60, 0x9A, 0x03, 0x60, 0xCA, 0x7A, 0x0C, 0x60, 0x4A,
  0x08, 0x50, 0x50, 0xCA, 0x0A, 0x04, 0x30, 0x5D, 0x0D, 0x30,
  // "Ð" (U+00D0)
  0x30, 0xCE, 0x81, 0xD9, 0x25, 0x03, 0x0A, 0xA8, 0x59, 0x47, 0xEF, 0xE4, 0x50, 0x7A, 0x04, 0x20,
  0x2A, 0x0E, 0x50, 0xAA, 0x01, 0x30, 0xAA, 0x05, 0x48, 0x1E, 0xFE, 0x40, 0x8A, 0x07, 0x30, 0x2A,
  0x0B, 0x40, 0x9A, 0x07, 0x20, 0xCD, 0x0C, 0x20, 0xAA, 0x05, 0x20, 0x30, 0x9A, 0x81, 0x63, 0x22,
  0x0D, 0xA0, 0x23, 0x0B, 0xA0, 0x13, 0x03, 0xA0, 0xC4, 0xA0, 0xD4, 0x0B, 0xA0, 0x43, 0x03, 0xA0,
  0x93, 0x09, 0xA0, 0x92, 0x81, 0x15, 0xBA, 0x82, 0x84, 0x7D, 0xA0, 0x83, 0x05, 0xE8, 0x2E, 0xD8,
  0x24,
  // "Ñ" (U+00D1)
  0x71, 0x84, 0xBF, 0xB4, 0x2E, 0x73, 0x82, 0x99, 0x5C, 0xA0, 0x57, 0x30, 0x33, 0x02, 0x01, 0x77,
  0x73, 0x0C, 0xB0, 0x84, 0x0E, 0xB0, 0x83, 0x03, 0x0A, 0xA0, 0xE4, 0x83, 0x4D, 0xE6, 0x14, 0x07,
  0xB0, 0x74, 0x0D, 0x08, 0x68, 0x3B, 0xAE, 0xFE, 0x38, 0x11, 0xF4, 0x68, 0x1E, 0x68, 0xA0, 0x62,
  0x81, 0x4F, 0x15, 0x85, 0x2F, 0x21, 0xEF, 0xD2, 0x07, 0x0D, 0x60, 0x60, 0xE2, 0x08, 0xA8, 0x25,
  0x0B, 0xA6, 0x09, 0x0B, 0x20, 0x1A, 0x82, 0xD0, 0xE6, 0x60, 0xD0, 0x83, 0x08, 0xA8, 0x17, 0xF3,
  0x58, 0x11, 0xF4, 0x30, 0x1C, 0x68, 0x14, 0xF1, 0x40, 0x9A, 0x0C, 0x58, 0x35, 0xCF, 0x51, 0x30,
  0x2A, 0x09, 0x40, 0x5C, 0x03, 0x48, 0x19, 0xF5, 0x40,
  // "Ò" (U+00D2)
  0x48, 0x22, 0xEF, 0x77, 0x38, 0x14, 0xFD, 0x74, 0x81, 0x3D, 0x77, 0x77, 0x85, 0x39, 0xDF, 0xEB,
  0x55, 0x84, 0x8F, 0xE6, 0x48, 0xA0, 0x83, 0x82, 0xAF, 0xE1, 0x30, 0x9A, 0x81, 0x30, 0x6A, 0x05,
  0x40, 0x4A, 0x83, 0x90, 0xEF, 0xD5, 0x02, 0xA0, 0xB0, 0x6A, 0x08, 0x50, 0x3A, 0x0B, 0x0A, 0xA0,
  0x45, 0x05, 0xA0, 0x80, 0xCA, 0x02, 0x50, 0x9A, 0x04, 0x0C, 0xA0, 0x15, 0x83, 0xEF, 0xD0, 0xAA,
  0x02, 0x40, 0x6A, 0x81, 0x40, 0x4A, 0x07, 0x38, 0x22, 0xEF, 0x83, 0x09, 0xA8, 0x48, 0x47, 0xEF,
  0x85, 0x85, 0x5B, 0xEF, 0xD9, 0x24,
  // "Ó" (U+00D3)
  0x71, 0x02, 0xA0, 0xA7, 0x28, 0x1C, 0xF7, 0x72, 0x81, 0xAC, 0x37, 0x76, 0x85, 0x39, 0xDF, 0xEB,
  0x55, 0x84, 0x8F, 0xE6, 0x48, 0xA0, 0x83, 0x82, 0xAF, 0xE1, 0x30, 0x9A, 0x81, 0x30, 0x6A, 0x05,
  0x40, 0x4A, 0x83, 0x90, 0xEF, 0xD5, 0x02, 0xA0, 0xB0, 0x6A, 0x08, 0x50, 0x3A, 0x0B, 0x0A, 0xA0,
  0x45, 0x05, 0xA0, 0x80, 0xCA, 0x02, 0x50, 0x9A, 0x04, 0x0C, 0xA0, 0x15, 0x83, 0xEF, 0xD0, 0xAA,
  0x02, 0x40, 0x6A, 0x81, 0x40, 0x4A, 0x07, 0x38, 0x22, 0xEF, 0x83, 0x09, 0xA8, 0x48, 0x47, 0xEF,
  0x85, 0x85, 0x5B, 0xEF, 0xD9, 0x24,
  // "Ô" (U+00D4)
  0x70, 0xCA, 0x04, 0x71, 0x83, 0xAF, 0x8E, 0xB7, 0x85, 0xAD, 0x30, 0x3E, 0x47, 0x74, 0x85, 0x39,
  0xDF, 0xEB, 0x55, 0x84, 0x8F, 0xE6, 0x48, 0xA0, 0x83, 0x82, 0xAF, 0xE1, 0x30, 0x9A, 0x81, 0x30,
  0x6A, 0x05, 0x40, 0x4A, 0x83, 0x90, 0xEF, 0xD5, 0x02, 0xA0, 0xB0, 0x6A, 0x08, 0x50, 0x3A, 0x0B,
  0x0A, 0xA0, 0x45, 0x05, 0xA0, 0x80, 0xCA, 0x02, 0x50, 0x9A, 0x04, 0x0C, 0xA0, 0x15, 0x83, 0xEF,
  0xD0, 0xAA, 0x02, 0x40, 0x6A, 0x81, 0x40, 0x4A, 0x07, 0x38, 0x22, 0xEF, 0x83, 0x09, 0xA8, 0x48,
  0x47, 0xEF, 0x85, 0x85, 0x5B, 0xEF, 0xD9, 0x24,
  // "Õ" (U+00D5)
  0x58, 0x4B, 0xFB, 0x42, 0xE6, 0x82, 0x99, 0x5C, 0xA0, 0x56, 0x03, 0x30, 0x20, 0x17, 0x76, 0x85,
  0x39, 0xDF, 0xEB, 0x55, 0x84, 0x8F, 0xE6, 0x48, 0xA0, 0x83, 0x82, 0xAF, 0xE1, 0x30, 0x9A, 0x81,
  0x30, 0x6A, 0x05, 0x40, 0x4A, 0x83, 0x90, 0xEF, 0xD5, 0x02, 0xA0, 0xB0, 0x6A, 0x08, 0x50, 0x3A,
  0x0B, 0x0A, 0xA0, 0x45, 0x05, 0xA0, 0x80, 0xCA, 0x02, 0x50, 0x9A, 0x04, 0x0C, 0xA0, 0x15, 0x83,
  0xEF, 0xD0, 0xAA, 0x02, 0x40, 0x6A, 0x81, 0x40, 0x4A, 0x07, 0x38, 0x22, 0xEF, 0x83, 0x09, 0xA8,
  0x48, 0x47, 0xEF, 0x85, 0x85, 0x5B, 0xEF, 0xD9, 0x24,
  // "Ö" (U+00D6)
  0x58, 0x56, 0xB2, 0x06, 0xC2, 0x68, 0x5D, 0xF5, 0x0D, 0xF6, 0x68, 0x59, 0xE2, 0x09, 0xE2, 0x77,
  0x48, 0x53, 0x9D, 0xFE, 0xB5, 0x58, 0x48, 0xFE, 0x64, 0x8A, 0x08, 0x38, 0x2A, 0xFE, 0x13, 0x09,
  0xA8, 0x13, 0x06, 0xA0, 0x54, 0x04, 0xA8, 0x39, 0x0E, 0xFD, 0x50, 0x2A, 0x0B, 0x06, 0xA0, 0x85,
  0x03, 0xA0, 0xB0, 0xAA, 0x04, 0x50, 0x5A, 0x08, 0x0C, 0xA0, 0x25, 0x09, 0xA0, 0x40, 0xCA, 0x01,
  0x58, 0x3E, 0xFD, 0x0A, 0xA0, 0x24, 0x06, 0xA8, 0x14, 0x04, 0xA0, 0x73, 0x82, 0x2E, 0xF8, 0x30,
  0x9A, 0x84, 0x84, 0x7E, 0xF8, 0x58, 0x55, 0xBE, 0xFD, 0x92, 0x40,
  // "×" (U+00D7)
  0x3B, 0x10, 0x00, 0xB3, 0x1D, 0xC1, 0x0C, 0xD1, 0x01, 0xDC, 0xCD, 0x10, 0x00, 0x2F, 0xF2, 0x00,
  0x00, 0xCD, 0xDC, 0x10, 0x0C, 0xD1, 0x1D, 0xC1, 0x3D, 0x10, 0x01, 0xC4,
  // "Ø" (U+00D8)
  0x73, 0x81, 0x1E, 0x34, 0x86, 0x39, 0xDF, 0xEB, 0xAA, 0x48, 0x49, 0xFE, 0x64, 0x9A, 0x08, 0x38,
  0x2A, 0xFE, 0x12, 0x01, 0x0E, 0xA8, 0x13, 0x06, 0xA0, 0x53, 0x00, 0xBA, 0x83, 0x81, 0xEF, 0xD3,
  0x81, 0x7B, 0x2A, 0x0B, 0x06, 0xA0, 0x82, 0x82, 0x4D, 0x13, 0xA0, 0xB0, 0xAA, 0x85, 0x40, 0x2E,
  0x30, 0x5A, 0x08, 0x0C, 0xA8, 0x22, 0x0C, 0x62, 0x09, 0xA0, 0x40, 0xCA, 0x81, 0x1A, 0x93, 0x83,
  0xEF, 0xD0, 0xAA, 0x09, 0x0C, 0x30, 0x6A, 0x81, 0x50, 0x4A, 0x0E, 0x01, 0x28, 0x22, 0xEF, 0x93,
  0x09, 0xA8, 0x48, 0x47, 0xEF, 0x84, 0x86, 0xBA, 0xBE, 0xFD, 0x92, 0x40, 0x20, 0x67, 0x40,
  // "Ù" (U+00D9)
  0x48, 0x22, 0xEF, 0x77, 0x48, 0x14, 0xFD, 0x75, 0x81, 0x3D, 0x77, 0x76, 0xE8, 0x13, 0x0D, 0xB8,
  0x2D, 0x04, 0xCA, 0x0A, 0x04, 0x28, 0x34, 0xBF, 0x73, 0x20, 0xBA, 0x01, 0x40, 0x80, 0xC4, 0x81,
  0xEF, 0xD5, 0x0C, 0x08, 0x30, 0x2A, 0x0A, 0x59, 0x05, 0x30, 0x5A, 0x06, 0x48, 0x13, 0xF1, 0x30,
  0x9A, 0x03, 0x40, 0x60, 0xE4, 0x0C, 0xA5, 0x00, 0xA4, 0xA0, 0xB5, 0x0D, 0x07, 0x30, 0x2A, 0x09,
  0x48, 0x13, 0xF2, 0x30, 0x2A, 0x0A, 0x40, 0x90, 0xC5, 0x0B, 0xA8, 0x48, 0x45, 0xAE, 0x26, 0x85,
  0x7C, 0xEF, 0xD9, 0x15,
  // "Ú" (U+00DA)
  0x71, 0x02, 0xA0, 0xA7, 0x38, 0x1C, 0xF7, 0x73, 0x81, 0xAC, 0x37, 0x75, 0xE8, 0x13, 0x0D, 0xB8,
  0x2D, 0x04, 0xCA, 0x0A, 0x04, 0x28, 0x34, 0xBF, 0x73, 0x20, 0xBA, 0x01, 0x40, 0x80, 0xC4, 0x81,
  0xEF, 0xD5, 0x0C, 0x08, 0x30, 0x2A, 0x0A, 0x59, 0x05, 0x30, 0x5A, 0x06, 0x48, 0x13, 0xF1, 0x30,
  0x9A, 0x03, 0x40, 0x60, 0xE4, 0x0C, 0xA5, 0x00, 0xA4, 0xA0, 0xB5, 0x0D, 0x07, 0x30, 0x2A, 0x09,
  0x48, 0x13, 0xF2, 0x30, 0x2A, 0x0A, 0x40, 0x90, 0xC5, 0x0B, 0xA8, 0x48, 0x45, 0xAE, 0x26, 0x85,
  0x7C, 0xEF, 0xD9, 0x15,
  // "Û" (U+00DB)
  0x70, 0xCA, 0x04, 0x72, 0x83, 0xAF, 0x8E, 0xB7, 0x18, 0x5A, 0xD3, 0x03, 0xE4, 0x77, 0x3E, 0x81,
  0x30, 0xDB, 0x82, 0xD0, 0x4C, 0xA0, 0xA0, 0x42, 0x83, 0x4B, 0xF7, 0x32, 0x0B, 0xA0, 0x14, 0x08,
  0x0C, 0x48, 0x1E, 0xFD, 0x50, 0xC0, 0x83, 0x02, 0xA0, 0xA5, 0x90, 0x53, 0x05, 0xA0, 0x64, 0x81,
  0x3F, 0x13, 0x09, 0xA0, 0x34, 0x06, 0x0E, 0x40, 0xCA, 0x50, 0x0A, 0x4A, 0x0B, 0x50, 0xD0, 0x73,
  0x02, 0xA0, 0x94, 0x81, 0x3F, 0x23, 0x02, 0xA0, 0xA4, 0x09, 0x0C, 0x50, 0xBA, 0x84, 0x84, 0x5A,
  0xE2, 0x68, 0x57, 0xCE, 0xFD, 0x91, 0x50,
  // "Ü" (U+00DC)
  0x58, 0x56, 0xB2, 0x06, 0xC2, 0x78, 0x5D, 0xF5, 0x0D, 0xF6, 0x78, 0x59, 0xE2, 0x09, 0xE2, 0x77,
  0x3E, 0x81, 0x30, 0xDB, 0x82, 0xD0, 0x4C, 0xA0, 0xA0, 0x42, 0x83, 0x4B, 0xF7, 0x32, 0x0B, 0xA0,
  0x14, 0x08, 0x0C, 0x48, 0x1E, 0xFD, 0x50, 0xC0, 0x83, 0x02, 0xA0, 0xA5, 0x90, 0x53, 0x05, 0xA0,
  0x64, 0x81, 0x3F, 0x13, 0x09, 0xA0, 0x34, 0x06, 0x0E, 0x40, 0xCA, 0x50, 0x0A, 0x4A, 0x0B, 0x50,
  0xD0, 0x73, 0x02, 0xA0, 0x94, 0x81, 0x3F, 0x23, 0x02, 0xA0, 0xA4, 0x09, 0x0C, 0x50, 0xBA, 0x84,
  0x84, 0x5A, 0xE2, 0x68, 0x57, 0xCE, 0xFD, 0x91, 0x50,
  // "Ý" (U+00DD)
  0x70, 0x2A, 0x0A, 0x73, 0x81, 0xCF, 0x77, 0x38, 0x1A, 0xC3, 0x77, 0x50, 0x4D, 0x81, 0x80, 0x8C,
  0x81, 0x21, 0x8A, 0x87, 0xE4, 0x10, 0x28, 0xFD, 0x53, 0x0E, 0xA4, 0x81, 0x7E, 0x24, 0x0A, 0xA0,
  0x32, 0x81, 0x2E, 0x55, 0x05, 0xA0, 0x72, 0x0C, 0x08, 0x60, 0x1A, 0x82, 0xC0, 0x9C, 0x71, 0x0B,
  0xA8, 0x14, 0xE2, 0x71, 0x06, 0xA0, 0xE0, 0x47, 0x20, 0x3A, 0x0A, 0x73, 0x06, 0xA0, 0x67, 0x30,
  0xAA, 0x03, 0x71, 0x81, 0x36, 0xEA, 0x06, 0x03, 0x70, 0xED, 0x0B, 0x60,
  // "Þ" (U+00DE)
  0x30, 0xCD, 0x06, 0x60, 0x30, 0xAA, 0x81, 0xB4, 0x17, 0x07, 0xB8, 0x1E, 0xC7, 0x60, 0xBA, 0x03,
  0x08, 0xA0, 0xC5, 0x81, 0xEF, 0xC2, 0x0A, 0xA0, 0x43, 0x02, 0xA0, 0x92, 0x07, 0xA0, 0x73, 0x06,
  0xA0, 0x52, 0x08, 0xA0, 0x53, 0x09, 0xA0, 0x22, 0x0C, 0xA0, 0x13, 0x84, 0xDF, 0xE0, 0x29, 0xA0,
  0x83, 0x01, 0xE0, 0xD0, 0x64, 0x04, 0xA8, 0x29, 0x32, 0x15, 0x05, 0x0C, 0xA0, 0xA0, 0x46, 0x05,
  0xD0, 0xD6,
  // "ß" (U+00DF)
  0x78, 0x51, 0x8D, 0xFE, 0xC6, 0x78, 0x42, 0xEF, 0xB5, 0x6A, 0x07, 0x68, 0x2B, 0xFE, 0x12, 0x81,
  0xAF, 0xC5, 0x02, 0xA0, 0xA3, 0x81, 0xBF, 0xC4, 0x0D, 0xB8, 0x56, 0x19, 0xEE, 0xD8, 0x40, 0x30,
  0xBA, 0x82, 0x3B, 0xFC, 0x71, 0x81, 0xCF, 0xE1, 0xA0, 0x87, 0x1A, 0x84, 0xB0, 0xEF, 0xE4, 0x60,
  0x3A, 0x81, 0x80, 0x6B, 0x08, 0x50, 0x7A, 0x04, 0x20, 0x40, 0xEA, 0x05, 0x40, 0xAA, 0x83, 0x13,
  0x30, 0x2A, 0x09, 0x48, 0x4D, 0xFD, 0x2F, 0xA2, 0x81, 0xEF, 0x83, 0x01, 0xA0, 0xA0, 0x2A, 0x83,
  0x45, 0xFE, 0x23, 0x05, 0xA8, 0x66, 0x06, 0xDF, 0xEA, 0x24, 0x09, 0xA0, 0x27, 0x48, 0x1E, 0xFB,
  0x72, 0x84, 0x14, 0xBF, 0xE2, 0x72, 0x83, 0x7F, 0xD9, 0x17, 0x30,
  // "à" (U+00E0)
  0x38, 0x22, 0xEF, 0x77, 0x28, 0x14, 0xFD, 0x73, 0x81, 0x3D, 0x77, 0x75, 0x86, 0x19, 0xDE, 0xC8,
  0xBB, 0x38, 0x42, 0xEF, 0xA4, 0x9A, 0x07, 0x38, 0x1D, 0xFB, 0x20, 0x5A, 0x04, 0x20, 0x7A, 0x03,
  0x20, 0x9A, 0x01, 0x28, 0x1D, 0xFD, 0x38, 0x1C, 0xFD, 0x20, 0x1A, 0x09, 0x20, 0x1A, 0x0A, 0x20,
  0x3A, 0x07, 0x20, 0x6A, 0x07, 0x20, 0x3A, 0x82, 0x70, 0x1C, 0xA0, 0x53, 0x84, 0xDF, 0xD4, 0xB5,
  0xA8, 0x94, 0x96, 0x10, 0x3D, 0xFC, 0x20, 0xBF, 0xD7, 0x10,
  // "á" (U+00E1)
  0x70, 0x2A, 0x0A, 0x71, 0x81, 0xCF, 0x77, 0x18, 0x1A, 0xC3, 0x77, 0x48, 0x61, 0x9D, 0xEC, 0x8B,
  0xB3, 0x84, 0x2E, 0xFA, 0x49, 0xA0, 0x73, 0x81, 0xDF, 0xB2, 0x05, 0xA0, 0x42, 0x07, 0xA0, 0x32,
  0x09, 0xA0, 0x12, 0x81, 0xDF, 0xD3, 0x81, 0xCF, 0xD2, 0x01, 0xA0, 0x92, 0x01, 0xA0, 0xA2, 0x03,
  0xA0, 0x72, 0x06, 0xA0, 0x72, 0x03, 0xA8, 0x27, 0x01, 0xCA, 0x05, 0x38, 0x4D, 0xFD, 0x4B, 0x5A,
  0x89, 0x49, 0x61, 0x03, 0xDF, 0xC2, 0x0B, 0xFD, 0x71,
  // "â" (U+00E2)
  0x50, 0xCA, 0x04, 0x78, 0x3A, 0xF8, 0xEB, 0x68, 0x5A, 0xD3, 0x03, 0xE4, 0x77, 0x38, 0x61, 0x9D,
  0xEC, 0x8B, 0xB3, 0x84, 0x2E, 0xFA, 0x49, 0xA0, 0x73, 0x81, 0xDF, 0xB2, 0x05, 0xA0, 0x42, 0x07,
  0xA0, 0x32, 0x09, 0xA0, 0x12, 0x81, 0xDF, 0xD3, 0x81, 0xCF, 0xD2, 0x01, 0xA0, 0x92, 0x01, 0xA0,
  0xA2, 0x03, 0xA0, 0x72, 0x06, 0xA0, 0x72, 0x03, 0xA8, 0x27, 0x01, 0xCA, 0x05, 0x38, 0x4D, 0xFD,
  0x4B, 0x5A, 0x89, 0x49, 0x61, 0x03, 0xDF, 0xC2, 0x0B, 0xFD, 0x71,
  // "ã" (U+00E3)
  0x48, 0x4B, 0xFB, 0x42, 0xE5, 0x82, 0x99, 0x5C, 0xA0, 0x55, 0x03, 0x30, 0x20, 0x17, 0x74, 0x86,
  0x19, 0xDE, 0xC8, 0xBB, 0x38, 0x42, 0xEF, 0xA4, 0x9A, 0x07, 0x38, 0x1D, 0xFB, 0x20, 0x5A, 0x04,
  0x20, 0x7A, 0x03, 0x20, 0x9A, 0x01, 0x28, 0x1D, 0xFD, 0x38, 0x1C, 0xFD, 0x20, 0x1A, 0x09, 0x20,
  0x1A, 0x0A, 0x20, 0x3A, 0x07, 0x20, 0x6A, 0x07, 0x20, 0x3A, 0x82, 0x70, 0x1C, 0xA0, 0x53, 0x84,
  0xDF, 0xD4, 0xB5, 0xA8, 0x94, 0x96, 0x10, 0x3D, 0xFC, 0x20, 0xBF, 0xD7, 0x10,
  // "ä" (U+00E4)
  0x38, 0x56, 0xB2, 0x06, 0xC2, 0x58, 0x5D, 0xF5, 0x0D, 0xF6, 0x58, 0x59, 0xE2, 0x09, 0xE2, 0x77,
  0x38, 0x61, 0x9D, 0xEC, 0x8B, 0xB3, 0x84, 0x2E, 0xFA, 0x49, 0xA0, 0x73, 0x81, 0xDF, 0xB2, 0x05,
  0xA0, 0x42, 0x07, 0xA0, 0x32, 0x09, 0xA0, 0x12, 0x81, 0xDF, 0xD3, 0x81, 0xCF, 0xD2, 0x01, 0xA0,
  0x92, 0x01, 0xA0, 0xA2, 0x03, 0xA0, 0x72, 0x06, 0xA0, 0x72, 0x03, 0xA8, 0x27, 0x01, 0xCA, 0x05,
  0x38, 0x4D, 0xFD, 0x4B, 0x5A, 0x89, 0x49, 0x61, 0x03, 0xDF, 0xC2, 0x0B, 0xFD, 0x71,
  // "å" (U+00E5)
  0x58, 0x2B, 0xFC, 0x27, 0x83, 0x7C, 0x4A, 0x97, 0x83, 0x7A, 0x18, 0xA7, 0x83, 0x1D, 0xFE, 0x37,
  0x20, 0x27, 0x18, 0x61, 0x9D, 0xEC, 0x8B, 0xB3, 0x84, 0x2E, 0xFA, 0x49, 0xA0, 0x73, 0x81, 0xDF,
  0xB2, 0x05, 0xA0, 0x42, 0x07, 0xA0, 0x32, 0x09, 0xA0, 0x12, 0x81, 0xDF, 0xD3, 0x81, 0xCF, 0xD2,
  0x01, 0xA0, 0x92, 0x01, 0xA0, 0xA2, 0x03, 0xA0, 0x72, 0x06, 0xA0, 0x72, 0x03, 0xA8, 0x27, 0x01,
  0xCA, 0x05, 0x38, 0x4D, 0xFD, 0x4B, 0x5A, 0x89, 0x49, 0x61, 0x03, 0xDF, 0xC2, 0x0B, 0xFD, 0x71,
  // "æ" (U+00E6)
  0x00, 0x01, 0x9D, 0xFC, 0x50, 0x6C, 0xEE, 0xA1, 0x00, 0x2E, 0xFA, 0x48, 0xFD, 0xF9, 0x5F, 0xF8,
  0x00, 0xDF, 0xB0, 0x00, 0xDF, 0xB0, 0x0D, 0xFA, 0x07, 0xFF, 0x30, 0x05, 0xFF, 0x40, 0x2F, 0xF6,
  0x0D, 0xFD, 0x00, 0x0B, 0xFE, 0x15, 0xDF, 0xB0, 0x1F, 0xF9, 0x00, 0x0F, 0xFF, 0xFF, 0xD7, 0x00,
  0x3F, 0xF7, 0x00, 0x6F, 0xFB, 0x31, 0x00, 0x00, 0x3F, 0xF7, 0x01, 0xCF, 0xFC, 0x00, 0x00, 0x20,
  0x0D, 0xFD, 0x4B, 0x38, 0xFF, 0x84, 0x6D, 0x50, 0x03, 0xDE, 0xC4, 0x00, 0x7C, 0xEF, 0xC6, 0x00,
  // "ç" (U+00E7)
  0x38, 0x41, 0x8D, 0xFD, 0x83, 0x83, 0x3E, 0xF6, 0x7A, 0x84, 0x50, 0x1E, 0xF7, 0x28, 0x3D, 0xF5,
  0x09, 0xA0, 0x12, 0x05, 0x04, 0x28, 0x1E, 0xFB, 0x60, 0x3A, 0x08, 0x60, 0x3A, 0x07, 0x60, 0x1A,
  0x0A, 0x30, 0x30, 0x12, 0x09, 0xA8, 0x38, 0x47, 0xE1, 0x38, 0x47, 0xEF, 0xEB, 0x45, 0x81, 0xAB,
  0x27, 0x81, 0x5E, 0xD6, 0x82, 0x13, 0xED, 0x50, 0x6A, 0x0D, 0x03, 0x60, 0x02, 0x60,
  // "è" (U+00E8)
  0x38, 0x22, 0xEF, 0x77, 0x81, 0x4F, 0xD7, 0x18, 0x13, 0xD7, 0x77, 0x28, 0x37, 0xDE, 0xE8, 0x38,
  0x32, 0xDF, 0x77, 0xA8, 0x65, 0x01, 0xDF, 0x80, 0x1A, 0x81, 0x70, 0x8A, 0x81, 0x10, 0x5A, 0x89,
  0x23, 0x0E, 0xFC, 0x16, 0xEF, 0x80, 0x3D, 0x0C, 0x05, 0x20, 0x3A, 0x81, 0x92, 0x14, 0x01, 0xA0,
  0x93, 0x00, 0x12, 0x09, 0xA8, 0x37, 0x46, 0xD2, 0x38, 0x46, 0xCF, 0xEB, 0x42,
  // "é" (U+00E9)
  0x60, 0x2A, 0x0A, 0x68, 0x1C, 0xF7, 0x68, 0x1A, 0xC3, 0x77, 0x28, 0x37, 0xDE, 0xE8, 0x38, 0x32,
  0xDF, 0x77, 0xA8, 0x65, 0x01, 0xDF, 0x80, 0x1A, 0x81, 0x70, 0x8A, 0x81, 0x10, 0x5A, 0x89, 0x23,
  0x0E, 0xFC, 0x16, 0xEF, 0x80, 0x3D, 0x0C, 0x05, 0x20, 0x3A, 0x81, 0x92, 0x14, 0x01, 0xA0, 0x93,
  0x00, 0x12, 0x09, 0xA8, 0x37, 0x46, 0xD2, 0x38, 0x46, 0xCF, 0xEB, 0x42,
  // "ê" (U+00EA)
  0x50, 0xCA, 0x04, 0x58, 0x3A, 0xF8, 0xEB, 0x48, 0x5A, 0xD3, 0x03, 0xE4, 0x77, 0x83, 0x7D, 0xEE,
  0x83, 0x83, 0x2D, 0xF7, 0x7A, 0x86, 0x50, 0x1D, 0xF8, 0x01, 0xA8, 0x17, 0x08, 0xA8, 0x11, 0x05,
  0xA8, 0x92, 0x30, 0xEF, 0xC1, 0x6E, 0xF8, 0x03, 0xD0, 0xC0, 0x52, 0x03, 0xA8, 0x19, 0x21, 0x40,
  0x1A, 0x09, 0x30, 0x01, 0x20, 0x9A, 0x83, 0x74, 0x6D, 0x23, 0x84, 0x6C, 0xFE, 0xB4, 0x20,
  // "ë" (U+00EB)
  0x38, 0x56, 0xB2, 0x06, 0xC2, 0x38, 0x5D, 0xF5, 0x0D, 0xF6, 0x38, 0x59, 0xE2, 0x09, 0xE2, 0x77,
  0x83, 0x7D, 0xEE, 0x83, 0x83, 0x2D, 0xF7, 0x7A, 0x86, 0x50, 0x1D, 0xF8, 0x01, 0xA8, 0x17, 0x08,
  0xA8, 0x11, 0x05, 0xA8, 0x92, 0x30, 0xEF, 0xC1, 0x6E, 0xF8, 0x03, 0xD0, 0xC0, 0x52, 0x03, 0xA8,
  0x19, 0x21, 0x40, 0x1A, 0x09, 0x30, 0x01, 0x20, 0x9A, 0x83, 0x74, 0x6D, 0x23, 0x84, 0x6C, 0xFE,
  0xB4, 0x20,
  // "ì" (U+00EC)
  0x82, 0x2E, 0xF7, 0x38, 0x14, 0xFD, 0x48, 0x13, 0xD7, 0x71, 0x0D, 0xB8, 0x25, 0x04, 0xDA, 0x02,
  0x28, 0x1C, 0xFE, 0x3A, 0x0B, 0x20, 0x3A, 0x08, 0x20, 0x6A, 0x05, 0x20, 0x9A, 0x02, 0x20, 0xBA,
  0x30, 0xBA, 0x86, 0x57, 0x03, 0xDF, 0xC4,
  // "í" (U+00ED)
  0x30, 0x2A, 0x0A, 0x38, 0x1C, 0xF7, 0x38, 0x1A, 0xC3, 0x72, 0x0D, 0xB0, 0x52, 0x04, 0x0D, 0xA0,
  0x23, 0x81, 0xCF, 0xE4, 0xA0, 0xB3, 0x03, 0xA0, 0x83, 0x06, 0xA0, 0x53, 0x09, 0xA0, 0x23, 0x0B,
  0xA4, 0x0B, 0xA0, 0x50, 0x72, 0x83, 0x3D, 0xFC, 0x42,
  // "î" (U+00EE)
  0x20, 0xCA, 0x04, 0x28, 0x93, 0xAF, 0x8E, 0xB0, 0xAD, 0x30, 0x3E, 0x47, 0x0D, 0xB0, 0x52, 0x04,
  0x0D, 0xA0, 0x23, 0x81, 0xCF, 0xE4, 0xA0, 0xB3, 0x03, 0xA0, 0x83, 0x06, 0xA0, 0x53, 0x09, 0xA0,
  0x23, 0x0B, 0xA4, 0x0B, 0xA0, 0x50, 0x72, 0x83, 0x3D, 0xFC, 0x42,
  // "ï" (U+00EF)
  0x8A, 0x36, 0xB2, 0x06, 0xC2, 0xDF, 0x50, 0xDF, 0x69, 0xE2, 0x09, 0xE2, 0x70, 0xDB, 0x05, 0x20,
  0x40, 0xDA, 0x02, 0x38, 0x1C, 0xFE, 0x4A, 0x0B, 0x30, 0x3A, 0x08, 0x30, 0x6A, 0x05, 0x30, 0x9A,
  0x02, 0x30, 0xBA, 0x40, 0xBA, 0x05, 0x07, 0x28, 0x33, 0xDF, 0xC4, 0x20,
  // "ð" (U+00F0)
  0x40, 0x70, 0x23, 0x04, 0x48, 0x51, 0xCF, 0xA7, 0xE7, 0x50, 0x10, 0xCA, 0x05, 0x58, 0x41, 0xE9,
  0x5F, 0xD5, 0x00, 0x12, 0x81, 0xAF, 0x74, 0x85, 0x3B, 0xEE, 0xCF, 0xD3, 0x84, 0x6F, 0xE6, 0x5E,
  0xA8, 0x12, 0x03, 0xA0, 0x52, 0x08, 0xA8, 0x34, 0x0B, 0xFE, 0x30, 0x6A, 0x05, 0x01, 0xA0, 0xA3,
  0x07, 0xA0, 0x03, 0xA0, 0x83, 0x09, 0xA1, 0x03, 0xA0, 0x73, 0x83, 0xEF, 0xB0, 0x1A, 0x09, 0x20,
  0x5A, 0x03, 0x28, 0x69, 0xFE, 0x56, 0xEF, 0x54, 0x84, 0x7D, 0xFD, 0xA3, 0x30,
  // "ñ" (U+00F1)
  0x48, 0x4B, 0xFB, 0x42, 0xE5, 0x82, 0x99, 0x5C, 0xA0, 0x55, 0x03, 0x30, 0x20, 0x17, 0x72, 0x0D,
  0xB8, 0x42, 0x7D, 0xFC, 0x12, 0x04, 0x0D, 0xA8, 0x19, 0x78, 0xA0, 0x83, 0x0C, 0xA8, 0x19, 0x03,
  0xA0, 0x93, 0x84, 0xEF, 0xE1, 0x05, 0xA0, 0x72, 0x02, 0xA0, 0x92, 0x08, 0xA0, 0x42, 0x06, 0xA0,
  0x42, 0x0B, 0xA0, 0x12, 0x09, 0xA0, 0x12, 0x81, 0xEF, 0xD3, 0x81, 0xCF, 0xD3, 0xA0, 0xB3, 0xA0,
  0xA3, 0xA8, 0x2D, 0x55, 0x3A, 0x07, 0x38, 0x36, 0xEE, 0xB2,
  // "ò" (U+00F2)
  0x38, 0x22, 0xEF, 0x77, 0x18, 0x14, 0xFD, 0x72, 0x81, 0x3D, 0x77, 0x73, 0x85, 0x29, 0xDF, 0xD8,
  0x13, 0x86, 0x4E, 0xF8, 0x4D, 0xFB, 0x28, 0x22, 0xEF, 0x82, 0x06, 0xA8, 0x13, 0x0A, 0xA0, 0x12,
  0x05, 0xA0, 0x51, 0xA0, 0xC3, 0x07, 0xA0, 0x50, 0x3A, 0x09, 0x30, 0xAA, 0x01, 0x04, 0xA0, 0x73,
  0x83, 0xEF, 0xB0, 0x1A, 0x08, 0x20, 0x7A, 0x03, 0x28, 0x3A, 0xFE, 0x56, 0xA0, 0x54, 0x84, 0x7D,
  0xFD, 0xA3, 0x30,
  // "ó" (U+00F3)
  0x70, 0x2A, 0x0A, 0x78, 0x1C, 0xF7, 0x78, 0x1A, 0xC3, 0x77, 0x28, 0x52, 0x9D, 0xFD, 0x81, 0x38,
  0x64, 0xEF, 0x84, 0xDF, 0xB2, 0x82, 0x2E, 0xF8, 0x20, 0x6A, 0x81, 0x30, 0xAA, 0x01, 0x20, 0x5A,
  0x05, 0x1A, 0x0C, 0x30, 0x7A, 0x05, 0x03, 0xA0, 0x93, 0x0A, 0xA0, 0x10, 0x4A, 0x07, 0x38, 0x3E,
  0xFB, 0x01, 0xA0, 0x82, 0x07, 0xA0, 0x32, 0x83, 0xAF, 0xE5, 0x6A, 0x05, 0x48, 0x47, 0xDF, 0xDA,
  0x33,
  // "ô" (U+00F4)
  0x60, 0xCA, 0x04, 0x68, 0x3A, 0xF8, 0xEB, 0x58, 0x5A, 0xD3, 0x03, 0xE4, 0x77, 0x85, 0x29, 0xDF,
  0xD8, 0x13, 0x86, 0x4E, 0xF8, 0x4D, 0xFB, 0x28, 0x22, 0xEF, 0x82, 0x06, 0xA8, 0x13, 0x0A, 0xA0,
  0x12, 0x05, 0xA0, 0x51, 0xA0, 0xC3, 0x07, 0xA0, 0x50, 0x3A, 0x09, 0x30, 0xAA, 0x01, 0x04, 0xA0,
  0x73, 0x83, 0xEF, 0xB0, 0x1A, 0x08, 0x20, 0x7A, 0x03, 0x28, 0x3A, 0xFE, 0x56, 0xA0, 0x54, 0x84,
  0x7D, 0xFD, 0xA3, 0x30,
  // "õ" (U+00F5)
  0x48, 0x4B, 0xFB, 0x42, 0xE4, 0x82, 0x99, 0x5C, 0xA0, 0x54, 0x03, 0x30, 0x20, 0x17, 0x72, 0x85,
  0x29, 0xDF, 0xD8, 0x13, 0x86, 0x4E, 0xF8, 0x4D, 0xFB, 0x28, 0x22, 0xEF, 0x82, 0x06, 0xA8, 0x13,
  0x0A, 0xA0, 0x12, 0x05, 0xA0, 0x51, 0xA0, 0xC3, 0x07, 0xA0, 0x50, 0x3A, 0x09, 0x30, 0xAA, 0x01,
  0x04, 0xA0, 0x73, 0x83, 0xEF, 0xB0, 0x1A, 0x08, 0x20, 0x7A, 0x03, 0x28, 0x3A, 0xFE, 0x56, 0xA0,
  0x54, 0x84, 0x7D, 0xFD, 0xA3, 0x30,
  // "ö" (U+00F6)
  0x48, 0x56, 0xB2, 0x06, 0xC2, 0x48, 0x5D, 0xF5, 0x0D, 0xF6, 0x48, 0x59, 0xE2, 0x09, 0xE2, 0x77,
  0x85, 0x29, 0xDF, 0xD8, 0x13, 0x86, 0x4E, 0xF8, 0x4D, 0xFB, 0x28, 0x22, 0xEF, 0x82, 0x06, 0xA8,
  0x13, 0x0A, 0xA0, 0x12, 0x05, 0xA0, 0x51, 0xA0, 0xC3, 0x07, 0xA0, 0x50, 0x3A, 0x09, 0x30, 0xAA,
  0x01, 0x04, 0xA0, 0x73, 0x83, 0xEF, 0xB0, 0x1A, 0x08, 0x20, 0x7A, 0x03, 0x28, 0x3A, 0xFE, 0x56,
  0xA0, 0x54, 0x84, 0x7D, 0xFD, 0xA3, 0x30,
  // "÷" (U+00F7)
  0x30, 0xD0, 0xE6, 0x0B, 0x0C, 0x77, 0x50, 0xCE, 0x0D, 0x02, 0x80, 0x33, 0x74, 0x0D, 0x0E, 0x60,
  0xB0, 0xC3,
  // "ø" (U+00F8)
  0x71, 0x81, 0x1E, 0x53, 0x85, 0x29, 0xDF, 0xDC, 0xA3, 0x86, 0x4E, 0xF8, 0x5D, 0xFA, 0x28, 0x52,
  0xEF, 0x80, 0x2E, 0xA8, 0x13, 0x09, 0xA8, 0x21, 0x1D, 0xCA, 0x05, 0x1A, 0x83, 0xC0, 0xB9, 0x7A,
  0x05, 0x03, 0xA8, 0x39, 0x8C, 0x0A, 0xA0, 0x20, 0x3A, 0x87, 0xCD, 0x10, 0xEF, 0xB0, 0x1B, 0x81,
  0x30, 0x6A, 0x03, 0x28, 0x3A, 0xFE, 0x56, 0xA0, 0x63, 0x85, 0xCB, 0xDF, 0xDA, 0x33, 0x04, 0x06,
  0x72,
  // "ù" (U+00F9)
  0x28, 0x22, 0xEF, 0x77, 0x18, 0x14, 0xFD, 0x72, 0x81, 0x3D, 0x77, 0x71, 0x0D, 0xB0, 0x62, 0x09,
  0xA8, 0x11, 0x4D, 0xA0, 0x22, 0x81, 0xCF, 0xD2, 0x81, 0xCF, 0xE3, 0xA0, 0xA2, 0x81, 0xEF, 0xB2,
  0x04, 0xA8, 0x17, 0x02, 0xA0, 0x82, 0x08, 0xA8, 0x13, 0x06, 0xA0, 0x42, 0x0D, 0xA2, 0x09, 0xA8,
  0x12, 0x05, 0xA0, 0xD2, 0x0B, 0xA8, 0x11, 0x1B, 0xA0, 0xB2, 0x0B, 0xA8, 0x1C, 0xD2, 0xA8, 0x94,
  0xE8, 0x74, 0xDF, 0xB2, 0x07, 0xEE, 0xA1,
  // "ú" (U+00FA)
  0x60, 0x2A, 0x0A, 0x78, 0x1C, 0xF7, 0x78, 0x1A, 0xC3, 0x77, 0x0D, 0xB0, 0x62, 0x09, 0xA8, 0x11,
  0x4D, 0xA0, 0x22, 0x81, 0xCF, 0xD2, 0x81, 0xCF, 0xE3, 0xA0, 0xA2, 0x81, 0xEF, 0xB2, 0x04, 0xA8,
  0x17, 0x02, 0xA0, 0x82, 0x08, 0xA8, 0x13, 0x06, 0xA0, 0x42, 0x0D, 0xA2, 0x09, 0xA8, 0x12, 0x05,
  0xA0, 0xD2, 0x0B, 0xA8, 0x11, 0x1B, 0xA0, 0xB2, 0x0B, 0xA8, 0x1C, 0xD2, 0xA8, 0x94, 0xE8, 0x74,
  0xDF, 0xB2, 0x07, 0xEE, 0xA1,
  // "û" (U+00FB)
  0x50, 0xCA, 0x04, 0x68, 0x3A, 0xF8, 0xEB, 0x58, 0x5A, 0xD3, 0x03, 0xE4, 0x75, 0x0D, 0xB0, 0x62,
  0x09, 0xA8, 0x11, 0x4D, 0xA0, 0x22, 0x81, 0xCF, 0xD2, 0x81, 0xCF, 0xE3, 0xA0, 0xA2, 0x81, 0xEF,
  0xB2, 0x04, 0xA8, 0x17, 0x02, 0xA0, 0x82, 0x08, 0xA8, 0x13, 0x06, 0xA0, 0x42, 0x0D, 0xA2, 0x09,
  0xA8, 0x12, 0x05, 0xA0, 0xD2, 0x0B, 0xA8, 0x11, 0x1B, 0xA0, 0xB2, 0x0B, 0xA8, 0x1C, 0xD2, 0xA8,
  0x94, 0xE8, 0x74, 0xDF, 0xB2, 0x07, 0xEE, 0xA1,
  // "ü" (U+00FC)
  0x38, 0x56, 0xB2, 0x06, 0xC2, 0x48, 0x5D, 0xF5, 0x0D, 0xF6, 0x48, 0x59, 0xE2, 0x09, 0xE2, 0x75,
  0x0D, 0xB0, 0x62, 0x09, 0xA8, 0x11, 0x4D, 0xA0, 0x22, 0x81, 0xCF, 0xD2, 0x81, 0xCF, 0xE3, 0xA0,
  0xA2, 0x81, 0xEF, 0xB2, 0x04, 0xA8, 0x17, 0x02, 0xA0, 0x82, 0x08, 0xA8, 0x13, 0x06, 0xA0, 0x42,
  0x0D, 0xA2, 0x09, 0xA8, 0x12, 0x05, 0xA0, 0xD2, 0x0B, 0xA8, 0x11, 0x1B, 0xA0, 0xB2, 0x0B, 0xA8,
  0x1C, 0xD2, 0xA8, 0x94, 0xE8, 0x74, 0xDF, 0xB2, 0x07, 0xEE, 0xA1,
  // "ý" (U+00FD)
  0x71, 0x02, 0xA0, 0xA7, 0x28, 0x1C, 0xF7, 0x72, 0x81, 0xAC, 0x37, 0x75, 0x0D, 0xA0, 0xD3, 0x81,
  0x7E, 0x83, 0x05, 0x0D, 0xA0, 0x12, 0x81, 0xAF, 0xE4, 0x07, 0xA0, 0x53, 0x0D, 0x0C, 0x40, 0x3A,
  0x09, 0x30, 0xE0, 0x85, 0x81, 0xEF, 0xD2, 0x81, 0x4F, 0x15, 0x0A, 0xA8, 0x21, 0x0C, 0x86, 0x05,
  0xA8, 0x14, 0x6D, 0x70, 0x1A, 0x81, 0x9E, 0x47, 0x10, 0xCA, 0x09, 0x72, 0x81, 0x7F, 0xC7, 0x38,
  0x1B, 0xE2, 0x71, 0x82, 0x1B, 0xF4, 0x50, 0xF4, 0x82, 0x8E, 0xE4, 0x68, 0x4C, 0xFE, 0xC8, 0x17,
  // "þ" (U+00FE)
  0x20, 0x5B, 0x0E, 0x70, 0x10, 0x6A, 0x0B, 0x71, 0x02, 0xA0, 0x87, 0x10, 0x6A, 0x04, 0x71, 0x09,
  0xA8, 0x32, 0xAE, 0xD5, 0x48, 0x4C, 0xFB, 0xB5, 0xBA, 0x02, 0x3A, 0x82, 0xD3, 0x04, 0xA0, 0x62,
  0x04, 0xA0, 0x92, 0x04, 0xA0, 0x72, 0x07, 0xA0, 0x42, 0x05, 0xA0, 0x52, 0x0A, 0xA3, 0x09, 0xA0,
  0x12, 0x81, 0xEF, 0xC3, 0x81, 0xEF, 0xA2, 0x02, 0xA0, 0x92, 0x82, 0x7F, 0xE2, 0x20, 0x5A, 0x81,
  0xB4, 0x7A, 0x05, 0x30, 0x8A, 0x83, 0xBE, 0xEB, 0x34, 0x81, 0xCF, 0xD7, 0x2A, 0x0A, 0x71, 0x03,
  0xA0, 0xB0, 0x47, 0x06, 0xC0, 0x16,
  // "ÿ" (U+00FF)
  0x58, 0x56, 0xB2, 0x06, 0xC2, 0x68, 0x5D, 0xF5, 0x0D, 0xF6, 0x68, 0x59, 0xE2, 0x09, 0xE2, 0x77,
  0x30, 0xDA, 0x0D, 0x38, 0x17, 0xE8, 0x30, 0x50, 0xDA, 0x01, 0x28, 0x1A, 0xFE, 0x40, 0x7A, 0x05,
  0x30, 0xD0, 0xC4, 0x03, 0xA0, 0x93, 0x0E, 0x08, 0x58, 0x1E, 0xFD, 0x28, 0x14, 0xF1, 0x50, 0xAA,
  0x82, 0x10, 0xC8, 0x60, 0x5A, 0x81, 0x46, 0xD7, 0x01, 0xA8, 0x19, 0xE4, 0x71, 0x0C, 0xA0, 0x97,
  0x28, 0x17, 0xFC, 0x73, 0x81, 0xBE, 0x27, 0x18, 0x21, 0xBF, 0x45, 0x0F, 0x48, 0x28, 0xEE, 0x46,
  0x84, 0xCF, 0xEC, 0x81, 0x70,
  // "Ā" (U+0100)
  0x70, 0xCC, 0x06, 0x71, 0x80, 0x13, 0x73, 0x81, 0xDF, 0xE7, 0x30, 0x7B, 0x01, 0x71, 0x81, 0x1E,
  0xBA, 0x03, 0x71, 0x81, 0xAD, 0x5A, 0x05, 0x78, 0x23, 0xF5, 0x3A, 0x07, 0x78, 0x2C, 0xC0, 0x2A,
  0x0A, 0x68, 0x16, 0xF4, 0x2A, 0x0C, 0x58, 0x11, 0xEB, 0x38, 0x1E, 0xFE, 0x50, 0x9F, 0x90, 0x13,
  0x86, 0x3F, 0x92, 0x22, 0x2B, 0xA0, 0x33, 0x0C, 0x0D, 0x50, 0x8A, 0x85, 0x60, 0x29, 0xFC, 0x43,
  0x04, 0x0B, 0xA8, 0x1C, 0x3C, 0xB0, 0xD2, 0x04, 0xD0, 0xA0,
  // "ā" (U+0101)
  0x40, 0xCC, 0x06, 0x68, 0x01, 0x36, 0x86, 0x19, 0xDE, 0xC8, 0xBB, 0x38, 0x42, 0xEF, 0xA4, 0x9A,
  0x07, 0x38, 0x1D, 0xFB, 0x20, 0x5A, 0x04, 0x20, 0x7A, 0x03, 0x20, 0x9A, 0x01, 0x28, 0x1D, 0xFD,
  0x38, 0x1C, 0xFD, 0x20, 0x1A, 0x09, 0x20, 0x1A, 0x0A, 0x20, 0x3A, 0x07, 0x20, 0x6A, 0x07, 0x20,
  0x3A, 0x82, 0x70, 0x1C, 0xA0, 0x53, 0x84, 0xDF, 0xD4, 0xB5, 0xA8, 0x94, 0x96, 0x10, 0x3D, 0xFC,
  0x20, 0xBF, 0xD7, 0x10,
  // "Ă" (U+0102)
  0x70, 0x30, 0xA3, 0x0B, 0x01, 0x78, 0x41, 0xF5, 0x18, 0xB7, 0x20, 0x7A, 0x0C, 0x01, 0x73, 0x01,
  0x02, 0x77, 0x74, 0x81, 0xDF, 0xE7, 0x30, 0x7B, 0x01, 0x71, 0x81, 0x1E, 0xBA, 0x03, 0x71, 0x81,
  0xAD, 0x5A, 0x05, 0x78, 0x23, 0xF5, 0x3A, 0x07, 0x78, 0x2C, 0xC0, 0x2A, 0x0A, 0x68, 0x16, 0xF4,
  0x2A, 0x0C, 0x58, 0x11, 0xEB, 0x38, 0x1E, 0xFE, 0x50, 0x9F, 0x90, 0x13, 0x86, 0x3F, 0x92, 0x22,
  0x2B, 0xA0, 0x33, 0x0C, 0x0D, 0x50, 0x8A, 0x85, 0x60, 0x29, 0xFC, 0x43, 0x04, 0x0B, 0xA8, 0x1C,
  0x3C, 0xB0, 0xD2, 0x04, 0xD0, 0xA0,
  // "ă" (U+0103)
  0x40, 0x30, 0xA3, 0x0B, 0x01, 0x58, 0x41, 0xF5, 0x18, 0xB7, 0x07, 0xA0, 0xC0, 0x17, 0x10, 0x10,
  0x27, 0x75, 0x86, 0x19, 0xDE, 0xC8, 0xBB, 0x38, 0x42, 0xEF, 0xA4, 0x9A, 0x07, 0x38, 0x1D, 0xFB,
  0x20, 0x5A, 0x04, 0x20, 0x7A, 0x03, 0x20, 0x9A, 0x01, 0x28, 0x1D, 0xFD, 0x38, 0x1C, 0xFD, 0x20,
  0x1A, 0x09, 0x20, 0x1A, 0x0A, 0x20, 0x3A, 0x07, 0x20, 0x6A, 0x07, 0x20, 0x3A, 0x82, 0x70, 0x1C,
  0xA0, 0x53, 0x84, 0xDF, 0xD4, 0xB5, 0xA8, 0x94, 0x96, 0x10, 0x3D, 0xFC, 0x20, 0xBF, 0xD7, 0x10,
  // "Ą" (U+0104)
  0x71, 0x81, 0xDF, 0xE7, 0x30, 0x7B, 0x01, 0x71, 0x81, 0x1E, 0xBA, 0x03, 0x71, 0x81, 0xAD, 0x5A,
  0x05, 0x78, 0x23, 0xF5, 0x3A, 0x07, 0x78, 0x2C, 0xC0, 0x2A, 0x0A, 0x68, 0x16, 0xF4, 0x2A, 0x0C,
  0x58, 0x11, 0xEB, 0x38, 0x1E, 0xFE, 0x50, 0x9F, 0x90, 0x13, 0x86, 0x3F, 0x92, 0x22, 0x2B, 0xA0,
  0x33, 0x0C, 0x0D, 0x50, 0x8A, 0x85, 0x60, 0x29, 0xFC, 0x43, 0x04, 0x0B, 0xA8, 0x1C, 0x3C, 0xB0,
  0xD2, 0x04, 0xD0, 0xA7, 0x28, 0x1A, 0xC1, 0x73, 0x81, 0x9F, 0x37, 0x48, 0x2B, 0xF5, 0x17, 0x30,
  0x5B, 0x02, 0x73, 0x81, 0x13, 0x12,
  // "ą" (U+0105)
  0x38, 0x61, 0x9D, 0xEC, 0x8B, 0xB3, 0x84, 0x2E, 0xFA, 0x49, 0xA0, 0x73, 0x81, 0xDF, 0xB2, 0x05,
  0xA0, 0x42, 0x07, 0xA0, 0x32, 0x09, 0xA0, 0x12, 0x81, 0xDF, 0xD3, 0x81, 0xCF, 0xD2, 0x01, 0xA0,
  0x92, 0x01, 0xA0, 0xA2, 0x03, 0xA0, 0x72, 0x06, 0xA0, 0x72, 0x03, 0xA8, 0x27, 0x01, 0xCA, 0x05,
  0x38, 0x4D, 0xFD, 0x4B, 0x5A, 0x89, 0x49, 0x61, 0x03, 0xDF, 0xC2, 0x0D, 0xFD, 0x77, 0x81, 0xAC,
  0x17, 0x18, 0x19, 0xF3, 0x72, 0x82, 0xBF, 0x51, 0x71, 0x05, 0xB0, 0x27, 0x18, 0x11, 0x31, 0x30,
  // "Ć" (U+0106)
  0x71, 0x02, 0xA0, 0xA7, 0x18, 0x1C, 0xF7, 0x71, 0x81, 0xAC, 0x37, 0x74, 0x85, 0x28, 0xCE, 0xED,
  0x74, 0x84, 0x7F, 0xE7, 0x4A, 0xA0, 0x72, 0x82, 0x9F, 0xE3, 0x20, 0x1A, 0x81, 0x80, 0x6A, 0x07,
  0x40, 0xB0, 0x82, 0x81, 0xEF, 0xE7, 0x10, 0x5A, 0x09, 0x71, 0x0A, 0xA0, 0x57, 0x10, 0xCA, 0x03,
  0x71, 0x0C, 0xA0, 0x27, 0x10, 0xBA, 0x04, 0x71, 0x05, 0xA0, 0xA4, 0x01, 0x07, 0x30, 0x9A, 0x84,
  0xA5, 0x47, 0xD6, 0x48, 0x55, 0xBE, 0xFE, 0xB5, 0x30,
  // "ć" (U+0107)
  0x70, 0x2A, 0x0A, 0x78, 0x1C, 0xF7, 0x78, 0x1A, 0xC3, 0x77, 0x28, 0x41, 0x8D, 0xFD, 0x84, 0x83,
  0x3E, 0xF6, 0x7A, 0x05, 0x28, 0x21, 0xEF, 0x72, 0x81, 0xDF, 0x52, 0x09, 0xA0, 0x12, 0x05, 0x04,
  0x38, 0x1E, 0xFB, 0x70, 0x3A, 0x08, 0x70, 0x3A, 0x07, 0x70, 0x1A, 0x0A, 0x30, 0x30, 0x13, 0x09,
  0xA8, 0x38, 0x47, 0xE1, 0x48, 0x47, 0xCF, 0xEB, 0x43,
  // "Ĉ" (U+0108)
  0x70, 0xCA, 0x04, 0x78, 0x3A, 0xF8, 0xEB, 0x68, 0x5A, 0xD3, 0x03, 0xE4, 0x77, 0x28, 0x52, 0x8C,
  0xEE, 0xD7, 0x48, 0x47, 0xFE, 0x74, 0xAA, 0x07, 0x28, 0x29, 0xFE, 0x32, 0x01, 0xA8, 0x18, 0x06,
  0xA0, 0x74, 0x0B, 0x08, 0x28, 0x1E, 0xFE, 0x71, 0x05, 0xA0, 0x97, 0x10, 0xAA, 0x05, 0x71, 0x0C,
  0xA0, 0x37, 0x10, 0xCA, 0x02, 0x71, 0x0B, 0xA0, 0x47, 0x10, 0x5A, 0x0A, 0x40, 0x10, 0x73, 0x09,
  0xA8, 0x4A, 0x54, 0x7D, 0x64, 0x85, 0x5B, 0xEF, 0xEB, 0x53,
  // "ĉ" (U+0109)
  0x60, 0xCA, 0x04, 0x68, 0x3A, 0xF8, 0xEB, 0x58, 0x5A, 0xD3, 0x03, 0xE4, 0x77, 0x84, 0x18, 0xDF,
  0xD8, 0x48, 0x33, 0xEF, 0x67, 0xA0, 0x52, 0x82, 0x1E, 0xF7, 0x28, 0x1D, 0xF5, 0x20, 0x9A, 0x01,
  0x20, 0x50, 0x43, 0x81, 0xEF, 0xB7, 0x03, 0xA0, 0x87, 0x03, 0xA0, 0x77, 0x01, 0xA0, 0xA3, 0x03,
  0x01, 0x30, 0x9A, 0x83, 0x84, 0x7E, 0x14, 0x84, 0x7C, 0xFE, 0xB4, 0x30,
  // "Ċ" (U+010A)
  0x68, 0x22, 0xBB, 0x27, 0x10, 0x8A, 0x06, 0x71, 0x82, 0x5E, 0xC1, 0x77, 0x48, 0x52, 0x8C, 0xEE,
  0xD7, 0x48, 0x47, 0xFE, 0x74, 0xAA, 0x07, 0x28, 0x29, 0xFE, 0x32, 0x01, 0xA8, 0x18, 0x06, 0xA0,
  0x74, 0x0B, 0x08, 0x28, 0x1E, 0xFE, 0x71, 0x05, 0xA0, 0x97, 0x10, 0xAA, 0x05, 0x71, 0x0C, 0xA0,
  0x37, 0x10, 0xCA, 0x02, 0x71, 0x0B, 0xA0, 0x47, 0x10, 0x5A, 0x0A, 0x40, 0x10, 0x73, 0x09, 0xA8,
  0x4A, 0x54, 0x7D, 0x64, 0x85, 0x5B, 0xEF, 0xEB, 0x53,
  // "ċ" (U+010B)
  0x58, 0x22, 0xBB, 0x26, 0x08, 0xA0, 0x66, 0x82, 0x5E, 0xC1, 0x77, 0x84, 0x18, 0xDF, 0xD8, 0x38,
  0x33, 0xEF, 0x67, 0xA8, 0x45, 0x01, 0xEF, 0x72, 0x83, 0xDF, 0x50, 0x9A, 0x01, 0x20, 0x50, 0x42,
  0x81, 0xEF, 0xB6, 0x03, 0xA0, 0x86, 0x03, 0xA0, 0x76, 0x01, 0xA0, 0xA3, 0x03, 0x01, 0x20, 0x9A,
  0x83, 0x84, 0x7E, 0x13, 0x84, 0x7C, 0xFE, 0xB4, 0x20,
  // "Č" (U+010C)
  0x58, 0x54, 0xF4, 0x03, 0xDA, 0x68, 0x3B, 0xE8, 0xFB, 0x70, 0x3A, 0x0C, 0x77, 0x48, 0x52, 0x8C,
  0xEE, 0xD7, 0x48, 0x47, 0xFE, 0x74, 0xAA, 0x07, 0x28, 0x29, 0xFE, 0x32, 0x01, 0xA8, 0x18, 0x06,
  0xA0, 0x74, 0x0B, 0x08, 0x28, 0x1E, 0xFE, 0x71, 0x05, 0xA0, 0x97, 0x10, 0xAA, 0x05, 0x71, 0x0C,
  0xA0, 0x37, 0x10, 0xCA, 0x02, 0x71, 0x0B, 0xA0, 0x47, 0x10, 0x5A, 0x0A, 0x40, 0x10, 0x73, 0x09,
  0xA8, 0x4A, 0x54, 0x7D, 0x64, 0x85, 0x5B, 0xEF, 0xEB, 0x53,
  // "č" (U+010D)
  0x38, 0x54, 0xF4, 0x03, 0xDA, 0x48, 0x3B, 0xE8, 0xFB, 0x50, 0x3A, 0x0C, 0x77, 0x18, 0x41, 0x8D,
  0xFD, 0x83, 0x83, 0x3E, 0xF6, 0x7A, 0x84, 0x50, 0x1E, 0xF7, 0x28, 0x3D, 0xF5, 0x09, 0xA0, 0x12,
  0x05, 0x04, 0x28, 0x1E, 0xFB, 0x60, 0x3A, 0x08, 0x60, 0x3A, 0x07, 0x60, 0x1A, 0x0A, 0x30, 0x30,
  0x12, 0x09, 0xA8, 0x38, 0x47, 0xE1, 0x38, 0x47, 0xCF, 0xEB, 0x42,
  // "Ď" (U+010E)
  0x68, 0x54, 0xF4, 0x03, 0xDA, 0x72, 0x83, 0xBE, 0x8F, 0xB7, 0x30, 0x3A, 0x0C, 0x77, 0x71, 0x0C,
  0xE8, 0x1D, 0x92, 0x50, 0x30, 0xAA, 0x85, 0x94, 0x7E, 0xFE, 0x45, 0x07, 0xA0, 0x42, 0x02, 0xA0,
  0xE5, 0x0B, 0xA0, 0x13, 0x0A, 0xA0, 0x54, 0x81, 0xEF, 0xD4, 0x08, 0xA0, 0x73, 0x02, 0xA0, 0xA4,
  0x09, 0xA0, 0x73, 0x06, 0xA0, 0x64, 0x0A, 0xA0, 0x53, 0x09, 0xA0, 0x34, 0x0D, 0xA0, 0x23, 0x0D,
  0xA4, 0x03, 0xA0, 0xC3, 0x01, 0xA0, 0xC4, 0x0B, 0xA0, 0x43, 0x04, 0xA0, 0x93, 0x09, 0xA0, 0x92,
  0x81, 0x15, 0xCA, 0x82, 0x84, 0x7D, 0xA0, 0x83, 0x05, 0xE8, 0x2E, 0xD8, 0x24,
  // "ď" (U+010F)
  0x70, 0xBB, 0x83, 0x90, 0xEF, 0x37, 0x03, 0x0A, 0xA8, 0x25, 0x5F, 0x77, 0x20, 0x8A, 0x81, 0x2B,
  0x97, 0x38, 0x1B, 0xFE, 0x71, 0x86, 0x19, 0xEE, 0xBE, 0xFB, 0x78, 0x43, 0xEF, 0xA4, 0x9A, 0x08,
  0x78, 0x1D, 0xFB, 0x20, 0x5A, 0x05, 0x60, 0x7A, 0x03, 0x20, 0x9A, 0x01, 0x68, 0x1D, 0xFD, 0x38,
  0x1C, 0xFE, 0x60, 0x1A, 0x09, 0x20, 0x1A, 0x0B, 0x60, 0x3A, 0x07, 0x20, 0x6A, 0x07, 0x60, 0x3A,
  0x82, 0x70, 0x1C, 0xA0, 0x57, 0x84, 0xDF, 0xD4, 0xB6, 0xA8, 0x19, 0x61, 0x58, 0x90, 0x3D, 0xEC,
  0x30, 0xBF, 0xD7, 0x50,
  // "Đ" (U+0110)
  0x30, 0xCE, 0x81, 0xD9, 0x25, 0x03, 0x0A, 0xA8, 0x59, 0x47, 0xEF, 0xE4, 0x50, 0x7A, 0x04, 0x20,
  0x2A, 0x0E, 0x50, 0xAA, 0x01, 0x30, 0xAA, 0x05, 0x48, 0x1E, 0xFE, 0x40, 0x8A, 0x07, 0x30, 0x2A,
  0x0B, 0x40, 0x9A, 0x07, 0x20, 0xCD, 0x0C, 0x20, 0xAA, 0x05, 0x20, 0x30, 0x9A, 0x81, 0x63, 0x22,
  0x0D, 0xA0, 0x23, 0x0B, 0xA0, 0x13, 0x03, 0xA0, 0xC4, 0xA0, 0xD4, 0x0B, 0xA0, 0x43, 0x03, 0xA0,
  0x93, 0x09, 0xA0, 0x92, 0x81, 0x15, 0xBA, 0x82, 0x84, 0x7D, 0xA0, 0x83, 0x05, 0xE8, 0x2E, 0xD8,
  0x24,
  // "đ" (U+0111)
  0x70, 0xBB, 0x08, 0x71, 0x03, 0x0A, 0xA0, 0x46, 0x06, 0xE0, 0xA5, 0x86, 0x13, 0x3E, 0xFE, 0x31,
  0x38, 0x32, 0xAE, 0xEB, 0xA0, 0xA4, 0x84, 0x4E, 0xF9, 0x4B, 0xA0, 0x73, 0x82, 0x1E, 0xFA, 0x20,
  0x7A, 0x04, 0x30, 0x9A, 0x02, 0x20, 0xAA, 0x01, 0x38, 0x1E, 0xFC, 0x38, 0x1D, 0xFD, 0x30, 0x3A,
  0x08, 0x20, 0x2A, 0x0A, 0x30, 0x4A, 0x07, 0x20, 0x8A, 0x07, 0x30, 0x3A, 0x82, 0x70, 0x1C, 0xA0,
  0x54, 0x84, 0xDF, 0xD5, 0xB6, 0xA8, 0x19, 0x61, 0x28, 0x90, 0x3D, 0xEB, 0x30, 0xBF, 0xD7, 0x20,
  // "Ē" (U+0112)
  0x60, 0xCC, 0x06, 0x78, 0x01, 0x35, 0x0C, 0xF9, 0x0E, 0x40, 0x7A, 0x07, 0x28, 0x11, 0xEC, 0x40,
  0x8A, 0x04, 0x30, 0xC0, 0x94, 0x0B, 0xA0, 0x13, 0x07, 0x04, 0x48, 0x1E, 0xFD, 0x72, 0x02, 0xA0,
  0xB7, 0x20, 0x6E, 0x09, 0x50, 0x9A, 0x83, 0x63, 0x33, 0x15, 0x0C, 0xA0, 0x17, 0x2A, 0x0D, 0x40,
  0x01, 0x30, 0x3A, 0x09, 0x40, 0xC0, 0x83, 0x09, 0xA0, 0x63, 0x83, 0x7F, 0x40, 0x4F, 0xB0, 0x11,
  // "ē" (U+0113)
  0x40, 0xCC, 0x06, 0x48, 0x01, 0x35, 0x83, 0x7D, 0xEE, 0x83, 0x83, 0x2D, 0xF7, 0x7A, 0x86, 0x50,
  0x1D, 0xF8, 0x01, 0xA8, 0x17, 0x08, 0xA8, 0x11, 0x05, 0xA8, 0x92, 0x30, 0xEF, 0xC1, 0x6E, 0xF8,
  0x03, 0xD0, 0xC0, 0x52, 0x03, 0xA8, 0x19, 0x21, 0x40, 0x1A, 0x09, 0x30, 0x01, 0x20, 0x9A, 0x83,
  0x74, 0x6D, 0x23, 0x84, 0x6C, 0xFE, 0xB4, 0x20,
  // "Ĕ" (U+0114)
  0x50, 0x30, 0xA3, 0x0B, 0x01, 0x68, 0x41, 0xF5, 0x18, 0xB7, 0x10, 0x7A, 0x0C, 0x01, 0x72, 0x01,
  0x02, 0x77, 0x60, 0xCF, 0x90, 0xE4, 0x07, 0xA0, 0x72, 0x81, 0x1E, 0xC4, 0x08, 0xA0, 0x43, 0x0C,
  0x09, 0x40, 0xBA, 0x01, 0x30, 0x70, 0x44, 0x81, 0xEF, 0xD7, 0x20, 0x2A, 0x0B, 0x72, 0x06, 0xE0,
  0x95, 0x09, 0xA8, 0x36, 0x33, 0x31, 0x50, 0xCA, 0x01, 0x72, 0xA0, 0xD4, 0x00, 0x13, 0x03, 0xA0,
  0x94, 0x0C, 0x08, 0x30, 0x9A, 0x06, 0x38, 0x37, 0xF4, 0x04, 0xFB, 0x01, 0x10,
  // "ĕ" (U+0115)
  0x30, 0x30, 0xA3, 0x0B, 0x01, 0x38, 0x41, 0xF5, 0x18, 0xB5, 0x07, 0xA0, 0xC0, 0x16, 0x01, 0x02,
  0x77, 0x38, 0x37, 0xDE, 0xE8, 0x38, 0x32, 0xDF, 0x77, 0xA8, 0x65, 0x01, 0xDF, 0x80, 0x1A, 0x81,
  0x70, 0x8A, 0x81, 0x10, 0x5A, 0x89, 0x23, 0x0E, 0xFC, 0x16, 0xEF, 0x80, 0x3D, 0x0C, 0x05, 0x20,
  0x3A, 0x81, 0x92, 0x14, 0x01, 0xA0, 0x93, 0x00, 0x12, 0x09, 0xA8, 0x37, 0x46, 0xD2, 0x38, 0x46,
  0xCF, 0xEB, 0x42,
  // "Ė" (U+0116)
  0x78, 0x22, 0xBB, 0x27, 0x20, 0x8A, 0x06, 0x72, 0x82, 0x5E, 0xC1, 0x77, 0x40, 0xCF, 0x90, 0xE4,
  0x07, 0xA0, 0x72, 0x81, 0x1E, 0xC4, 0x08, 0xA0, 0x43, 0x0C, 0x09, 0x40, 0xBA, 0x01, 0x30, 0x70,
  0x44, 0x81, 0xEF, 0xD7, 0x20, 0x2A, 0x0B, 0x72, 0x06, 0xE0, 0x95, 0x09, 0xA8, 0x36, 0x33, 0x31,
  0x50, 0xCA, 0x01, 0x72, 0xA0, 0xD4, 0x00, 0x13, 0x03, 0xA0, 0x94, 0x0C, 0x08, 0x30, 0x9A, 0x06,
  0x38, 0x37, 0xF4, 0x04, 0xFB, 0x01, 0x10,
  // "ė" (U+0117)
  0x58, 0x22, 0xBB, 0x26, 0x08, 0xA0, 0x66, 0x82, 0x5E, 0xC1, 0x77, 0x18, 0x37, 0xDE, 0xE8, 0x38,
  0x32, 0xDF, 0x77, 0xA8, 0x65, 0x01, 0xDF, 0x80, 0x1A, 0x81, 0x70, 0x8A, 0x81, 0x10, 0x5A, 0x89,
  0x23, 0x0E, 0xFC, 0x16, 0xEF, 0x80, 0x3D, 0x0C, 0x05, 0x20, 0x3A, 0x81, 0x92, 0x14, 0x01, 0xA0,
  0x93, 0x00, 0x12, 0x09, 0xA8, 0x37, 0x46, 0xD2, 0x38, 0x46, 0xCF, 0xEB, 0x42,
  // "Ę" (U+0118)
  0x30, 0xCF, 0x90, 0xE4, 0x07, 0xA0, 0x72, 0x81, 0x1E, 0xC4, 0x08, 0xA0, 0x43, 0x0C, 0x09, 0x40,
  0xBA, 0x01, 0x30, 0x70, 0x44, 0x81, 0xEF, 0xD7, 0x20, 0x2A, 0x0B, 0x72, 0x06, 0xE0, 0x95, 0x09,
  0xA8, 0x36, 0x33, 0x31, 0x50, 0xCA, 0x01, 0x72, 0xA0, 0xD4, 0x00, 0x13, 0x03, 0xA0, 0x94, 0x0C,
  0x08, 0x30, 0x9A, 0x06, 0x38, 0x37, 0xF4, 0x04, 0xFB, 0x01, 0x71, 0x81, 0xAC, 0x17, 0x28, 0x19,
  0xF3, 0x73, 0x82, 0xBF, 0x51, 0x72, 0x05, 0xB0, 0x27, 0x28, 0x11, 0x31, 0x30,
  // "ę" (U+0119)
  0x48, 0x37, 0xDE, 0xE8, 0x38, 0x32, 0xDF, 0x77, 0xA8, 0x65, 0x01, 0xDF, 0x80, 0x1A, 0x81, 0x70,
  0x8A, 0x81, 0x10, 0x5A, 0x89, 0x23, 0x0E, 0xFC, 0x16, 0xEF, 0x80, 0x3D, 0x0C, 0x05, 0x20, 0x3A,
  0x81, 0x92, 0x14, 0x01, 0xA0, 0x93, 0x00, 0x12, 0x09, 0xA8, 0x37, 0x46, 0xD2, 0x30, 0x60, 0xCB,
  0x04, 0x68, 0x1A, 0xC1, 0x68, 0x19, 0xF3, 0x78, 0x2B, 0xF5, 0x16, 0x05, 0xB0, 0x26, 0x81, 0x13,
  0x13,
  // "Ě" (U+011A)
  0x58, 0x54, 0xF4, 0x03, 0xDA, 0x78, 0x3B, 0xE8, 0xFB, 0x71, 0x03, 0xA0, 0xC7, 0x75, 0x0C, 0xF9,
  0x0E, 0x40, 0x7A, 0x07, 0x28, 0x11, 0xEC, 0x40, 0x8A, 0x04, 0x30, 0xC0, 0x94, 0x0B, 0xA0, 0x13,
  0x07, 0x04, 0x48, 0x1E, 0xFD, 0x72, 0x02, 0xA0, 0xB7, 0x20, 0x6E, 0x09, 0x50, 0x9A, 0x83, 0x63,
  0x33, 0x15, 0x0C, 0xA0, 0x17, 0x2A, 0x0D, 0x40, 0x01, 0x30, 0x3A, 0x09, 0x40, 0xC0, 0x83, 0x09,
  0xA0, 0x63, 0x83, 0x7F, 0x40, 0x4F, 0xB0, 0x11,
  // "ě" (U+011B)
  0x38, 0x54, 0xF4, 0x03, 0xDA, 0x48, 0x3B, 0xE8, 0xFB, 0x50, 0x3A, 0x0C, 0x77, 0x28, 0x37, 0xDE,
  0xE8, 0x38, 0x32, 0xDF, 0x77, 0xA8, 0x65, 0x01, 0xDF, 0x80, 0x1A, 0x81, 0x70, 0x8A, 0x81, 0x10,
  0x5A, 0x89, 0x23, 0x0E, 0xFC, 0x16, 0xEF, 0x80, 0x3D, 0x0C, 0x05, 0x20, 0x3A, 0x81, 0x92, 0x14,
  0x01, 0xA0, 0x93, 0x00, 0x12, 0x09, 0xA8, 0x37, 0x46, 0xD2, 0x38, 0x46, 0xCF, 0xEB, 0x42,
  // "Ĝ" (U+011C)
  0x70, 0xCA, 0x04, 0x71, 0x83, 0xAF, 0x8E, 0xB7, 0x85, 0xAD, 0x30, 0x3E, 0x47, 0x74, 0x86, 0x17,
  0xBE, 0xFE, 0xB5, 0x48, 0x57, 0xEF, 0x94, 0x5D, 0xA0, 0x62, 0x09, 0xA0, 0x43, 0x03, 0xA8, 0x14,
  0x06, 0xA0, 0x75, 0x05, 0x01, 0x28, 0x1E, 0xFD, 0x72, 0x06, 0xA0, 0x87, 0x20, 0xAA, 0x04, 0x20,
  0x4D, 0x0A, 0x0C, 0xA0, 0x22, 0x01, 0x05, 0xB8, 0x17, 0x2C, 0xA0, 0x14, 0xA0, 0xD2, 0x0B, 0xA0,
  0x33, 0x03, 0xA0, 0x92, 0x05, 0xA0, 0x83, 0x06, 0xA0, 0x73, 0x0A, 0xA8, 0x29, 0x45, 0xBA, 0x04,
  0x48, 0x65, 0xBE, 0xFE, 0xC9, 0x43,
  // "ĝ" (U+011D)
  0x60, 0xCA, 0x04, 0x71, 0x83, 0xAF, 0x8E, 0xB7, 0x85, 0xAD, 0x30, 0x3E, 0x47, 0x48, 0x23, 0xDE,
  0x14, 0x87, 0x4B, 0xEF, 0xEE, 0x5E, 0x13, 0x87, 0x7F, 0xD5, 0x9F, 0xC0, 0x13, 0x01, 0xA8, 0x13,
  0x04, 0xA0, 0x14, 0x81, 0x5F, 0xE2, 0x81, 0x8F, 0xE5, 0x86, 0x3F, 0xE2, 0x4E, 0xF6, 0x60, 0x9B,
  0x0E, 0x06, 0x68, 0x34, 0xD6, 0x32, 0x71, 0x83, 0xEE, 0x53, 0x27, 0x10, 0xDC, 0x0E, 0x09, 0x58,
  0x33, 0xAE, 0xDE, 0xB0, 0x73, 0x81, 0x7F, 0x93, 0x82, 0x2D, 0xF9, 0x3A, 0x02, 0x48, 0x1C, 0xF6,
  0x38, 0x7C, 0xFB, 0x54, 0x5B, 0xFB, 0x48, 0x11, 0x9D, 0xA8, 0x1D, 0xB5, 0x50,
  // "Ğ" (U+011E)
  0x50, 0x30, 0xA3, 0x0B, 0x01, 0x68, 0x41, 0xF5, 0x18, 0xB7, 0x10, 0x7A, 0x0C, 0x01, 0x72, 0x01,
  0x02, 0x77, 0x78, 0x61, 0x7B, 0xEF, 0xEB, 0x54, 0x85, 0x7E, 0xF9, 0x45, 0xDA, 0x06, 0x20, 0x9A,
  0x04, 0x30, 0x3A, 0x81, 0x40, 0x6A, 0x07, 0x50, 0x50, 0x12, 0x81, 0xEF, 0xD7, 0x20, 0x6A, 0x08,
  0x72, 0x0A, 0xA0, 0x42, 0x04, 0xD0, 0xA0, 0xCA, 0x02, 0x20, 0x10, 0x5B, 0x81, 0x72, 0xCA, 0x01,
  0x4A, 0x0D, 0x20, 0xBA, 0x03, 0x30, 0x3A, 0x09, 0x20, 0x5A, 0x08, 0x30, 0x6A, 0x07, 0x30, 0xAA,
  0x82, 0x94, 0x5B, 0xA0, 0x44, 0x86, 0x5B, 0xEF, 0xEC, 0x94, 0x30,
  // "ğ" (U+011F)
  0x40, 0x30, 0xA3, 0x0B, 0x01, 0x68, 0x41, 0xF5, 0x18, 0xB7, 0x10, 0x7A, 0x0C, 0x01, 0x72, 0x01,
  0x02, 0x77, 0x82, 0x3D, 0xE1, 0x48, 0x74, 0xBE, 0xFE, 0xE5, 0xE1, 0x38, 0x77, 0xFD, 0x59, 0xFC,
  0x01, 0x30, 0x1A, 0x81, 0x30, 0x4A, 0x01, 0x48, 0x15, 0xFE, 0x28, 0x18, 0xFE, 0x58, 0x63, 0xFE,
  0x24, 0xEF, 0x66, 0x09, 0xB0, 0xE0, 0x66, 0x83, 0x4D, 0x63, 0x27, 0x18, 0x3E, 0xE5, 0x32, 0x71,
  0x0D, 0xC0, 0xE0, 0x95, 0x83, 0x3A, 0xED, 0xEB, 0x07, 0x38, 0x17, 0xF9, 0x38, 0x22, 0xDF, 0x93,
  0xA0, 0x24, 0x81, 0xCF, 0x63, 0x87, 0xCF, 0xB5, 0x45, 0xBF, 0xB4, 0x81, 0x19, 0xDA, 0x81, 0xDB,
  0x55,
  // "Ġ" (U+0120)
  0x68, 0x22, 0xBB, 0x27, 0x20, 0x8A, 0x06, 0x72, 0x82, 0x5E, 0xC1, 0x77, 0x68, 0x61, 0x7B, 0xEF,
  0xEB, 0x54, 0x85, 0x7E, 0xF9, 0x45, 0xDA, 0x06, 0x20, 0x9A, 0x04, 0x30, 0x3A, 0x81, 0x40, 0x6A,
  0x07, 0x50, 0x50, 0x12, 0x81, 0xEF, 0xD7, 0x20, 0x6A, 0x08, 0x72, 0x0A, 0xA0, 0x42, 0x04, 0xD0,
  0xA0, 0xCA, 0x02, 0x20, 0x10, 0x5B, 0x81, 0x72, 0xCA, 0x01, 0x4A, 0x0D, 0x20, 0xBA, 0x03, 0x30,
  0x3A, 0x09, 0x20, 0x5A, 0x08, 0x30, 0x6A, 0x07, 0x30, 0xAA, 0x82, 0x94, 0x5B, 0xA0, 0x44, 0x86,
  0x5B, 0xEF, 0xEC, 0x94, 0x30,
  // "ġ" (U+0121)
  0x68, 0x22, 0xBB, 0x27, 0x20, 0x8A, 0x06, 0x72, 0x82, 0x5E, 0xC1, 0x75, 0x82, 0x3D, 0xE1, 0x48,
  0x74, 0xBE, 0xFE, 0xE5, 0xE1, 0x38, 0x77, 0xFD, 0x59, 0xFC, 0x01, 0x30, 0x1A, 0x81, 0x30, 0x4A,
  0x01, 0x48, 0x15, 0xFE, 0x28, 0x18, 0xFE, 0x58, 0x63, 0xFE, 0x24, 0xEF, 0x66, 0x09, 0xB0, 0xE0,
  0x66, 0x83, 0x4D, 0x63, 0x27, 0x18, 0x3E, 0xE5, 0x32, 0x71, 0x0D, 0xC0, 0xE0, 0x95, 0x83, 0x3A,
  0xED, 0xEB, 0x07, 0x38, 0x17, 0xF9, 0x38, 0x22, 0xDF, 0x93, 0xA0, 0x24, 0x81, 0xCF, 0x63, 0x87,
  0xCF, 0xB5, 0x45, 0xBF, 0xB4, 0x81, 0x19, 0xDA, 0x81, 0xDB, 0x55,
  // "Ģ" (U+0122)
  0x48, 0x61, 0x7B, 0xEF, 0xEB, 0x54, 0x85, 0x7E, 0xF9, 0x45, 0xDA, 0x06, 0x20, 0x9A, 0x04, 0x30,
  0x3A, 0x81, 0x40, 0x6A, 0x07, 0x50, 0x50, 0x12, 0x81, 0xEF, 0xD7, 0x20, 0x6A, 0x08, 0x72, 0x0A,
  0xA0, 0x42, 0x04, 0xD0, 0xA0, 0xCA, 0x02, 0x20, 0x10, 0x5B, 0x81, 0x72, 0xCA, 0x01, 0x4A, 0x0D,
  0x20, 0xBA, 0x03, 0x30, 0x3A, 0x09, 0x20, 0x5A, 0x08, 0x30, 0x6A, 0x07, 0x30, 0xAA, 0x82, 0x94,
  0x5B, 0xA0, 0x44, 0x86, 0x5B, 0xEF, 0xEC, 0x94, 0x77, 0x58, 0x15, 0xFC, 0x73, 0x81, 0xBE, 0x27,
  0x28, 0x12, 0xE3, 0x71,
  // "ģ" (U+0123)
  0x78, 0x11, 0xD6, 0x72, 0x81, 0x1D, 0xE7, 0x38, 0x15, 0x85, 0x76, 0x82, 0x3D, 0xE1, 0x48, 0x74,
  0xBE, 0xFE, 0xE5, 0xE1, 0x38, 0x77, 0xFD, 0x59, 0xFC, 0x01, 0x30, 0x1A, 0x81, 0x30, 0x4A, 0x01,
  0x48, 0x15, 0xFE, 0x28, 0x18, 0xFE, 0x58, 0x63, 0xFE, 0x24, 0xEF, 0x66, 0x09, 0xB0, 0xE0, 0x66,
  0x83, 0x4D, 0x63, 0x27, 0x18, 0x3E, 0xE5, 0x32, 0x71, 0x0D, 0xC0, 0xE0, 0x95, 0x83, 0x3A, 0xED,
  0xEB, 0x07, 0x38, 0x17, 0xF9, 0x38, 0x22, 0xDF, 0x93, 0xA0, 0x24, 0x81, 0xCF, 0x63, 0x87, 0xCF,
  0xB5, 0x45, 0xBF, 0xB4, 0x81, 0x19, 0xDA, 0x81, 0xDB, 0x55,
  // "Ĥ" (U+0124)
  0x72, 0x0C, 0xA0, 0x47, 0x58, 0x3A, 0xF8, 0xEB, 0x74, 0x85, 0xAD, 0x30, 0x3E, 0x47, 0x77, 0x20,
  0xCD, 0x06, 0x04, 0xD0, 0xE3, 0x03, 0x09, 0xA8, 0x4C, 0x51, 0x15, 0xEA, 0x08, 0x03, 0x40, 0x7A,
  0x05, 0x48, 0x1E, 0xFD, 0x60, 0xBA, 0x01, 0x30, 0x2A, 0x09, 0x68, 0x1E, 0xFE, 0x40, 0x5A, 0x06,
  0x50, 0x2A, 0x0B, 0x40, 0x9A, 0x03, 0x50, 0x6F, 0xA0, 0xE6, 0x09, 0xA0, 0x68, 0x00, 0x3A, 0x0B,
  0x60, 0xDA, 0x01, 0x30, 0x3A, 0x08, 0x50, 0x1A, 0x0C, 0x40, 0x7A, 0x05, 0x50, 0x4A, 0x09, 0x40,
  0xBA, 0x01, 0x40, 0x50, 0xCA, 0x83, 0xA3, 0x03, 0x6B, 0x05, 0x01, 0x20, 0x5D, 0x81, 0xD0, 0xCD,
  0x05, 0x20,
  // "ĥ" (U+0125)
  0x60, 0xCA, 0x04, 0x78, 0x3A, 0xF8, 0xEB, 0x68, 0x5A, 0xD3, 0x03, 0xE4, 0x20, 0x5B, 0x0E, 0x70,
  0x10, 0x6A, 0x0B, 0x71, 0x03, 0xA0, 0x87, 0x10, 0x6A, 0x04, 0x71, 0x09, 0xA8, 0x32, 0x9E, 0xF9,
  0x48, 0x4C, 0xFD, 0xB5, 0xBA, 0x04, 0x3B, 0x81, 0x50, 0x7A, 0x05, 0x20, 0x3A, 0x0B, 0x20, 0x9A,
  0x03, 0x20, 0x7A, 0x05, 0x20, 0xCA, 0x30, 0xAA, 0x3A, 0x0C, 0x38, 0x1D, 0xFC, 0x20, 0x3A, 0x08,
  0x20, 0x1A, 0x09, 0x20, 0x5A, 0x06, 0x20, 0x4A, 0x06, 0x20, 0x4A, 0x82, 0xA5, 0x38, 0xA0, 0x23,
  0x82, 0xAE, 0xE8, 0x10,
  // "Ħ" (U+0126)
  0x30, 0xCD, 0x06, 0x04, 0xD0, 0xE3, 0x03, 0x09, 0xA8, 0x4C, 0x51, 0x14, 0xEA, 0x08, 0x03, 0x40,
  0x8A, 0x04, 0x4A, 0x0D, 0x40, 0x9F, 0xE0, 0x72, 0x89, 0x02, 0x3E, 0xFE, 0x33, 0x33, 0x8A, 0x81,
  0x83, 0x13, 0x02, 0xA0, 0xB4, 0x09, 0xA0, 0x35, 0x05, 0xFB, 0x60, 0x9A, 0x06, 0x80, 0x03, 0xA0,
  0xC6, 0x0C, 0xA0, 0x13, 0x03, 0xA0, 0x86, 0xA0, 0xC4, 0x07, 0xA0, 0x55, 0x04, 0xA0, 0x94, 0x0B,
  0xA0, 0x14, 0x05, 0x0C, 0xA8, 0x3A, 0x30, 0x36, 0xB0, 0x50, 0x12, 0x05, 0xD8, 0x1D, 0x0C, 0xD0,
  0x52,
  // "ħ" (U+0127)
  0x10, 0x5B, 0x0E, 0x70, 0x20, 0x7A, 0x0A, 0x70, 0xCE, 0x04, 0x40, 0x30, 0x9A, 0x81, 0x63, 0x36,
  0x0A, 0xA8, 0x32, 0x9E, 0xE9, 0x48, 0x4D, 0xFC, 0xB5, 0xCA, 0x02, 0x20, 0x1B, 0x81, 0x30, 0x9A,
  0x03, 0x20, 0x4A, 0x0B, 0x20, 0xAA, 0x02, 0x20, 0x7A, 0x04, 0x28, 0x1D, 0xFE, 0x30, 0xBA, 0x3A,
  0x0B, 0x38, 0x1E, 0xFC, 0x20, 0x3A, 0x08, 0x20, 0x1A, 0x09, 0x20, 0x5A, 0x06, 0x20, 0x5A, 0x05,
  0x20, 0x4A, 0x82, 0xA6, 0x38, 0xA0, 0x23, 0x82, 0x9E, 0xE8, 0x10,
  // "Ĩ" (U+0128)
  0x48, 0x4B, 0xFB, 0x42, 0xE3, 0x82, 0x99, 0x5C, 0xA0, 0x53, 0x03, 0x30, 0x20, 0x17, 0x70, 0xCD,
  0x06, 0x30, 0x30, 0xAA, 0x81, 0xC5, 0x14, 0x07, 0xA0, 0x56, 0x0B, 0xA0, 0x16, 0x81, 0xEF, 0xD6,
  0x02, 0xA0, 0xA6, 0x05, 0xA0, 0x66, 0x09, 0xA0, 0x36, 0x0C, 0xA7, 0xA0, 0xC6, 0x04, 0xA0, 0x85,
  0x05, 0x0C, 0xA0, 0xA0, 0x43, 0x05, 0xD0, 0xD3,
  // "ĩ" (U+0129)
  0x18, 0x90, 0xBF, 0xB4, 0x2E, 0x99, 0x5C, 0xA0, 0x50, 0x33, 0x02, 0x01, 0x72, 0x0D, 0xB0, 0x52,
  0x04, 0x0D, 0xA0, 0x23, 0x81, 0xCF, 0xE4, 0xA0, 0xB3, 0x03, 0xA0, 0x83, 0x06, 0xA0, 0x53, 0x09,
  0xA0, 0x23, 0x0B, 0xA4, 0x0B, 0xA0, 0x50, 0x72, 0x83, 0x3D, 0xFC, 0x41,
  // "Ī" (U+012A)
  0x40, 0xCC, 0x06, 0x48, 0x01, 0x34, 0x0C, 0xD0, 0x63, 0x03, 0x0A, 0xA8, 0x1C, 0x51, 0x40, 0x7A,
  0x05, 0x60, 0xBA, 0x01, 0x68, 0x1E, 0xFD, 0x60, 0x2A, 0x0A, 0x60, 0x5A, 0x06, 0x60, 0x9A, 0x03,
  0x60, 0xCA, 0x7A, 0x0C, 0x60, 0x4A, 0x08, 0x50, 0x50, 0xCA, 0x0A, 0x04, 0x30, 0x5D, 0x0D, 0x30,
  // "ī" (U+012B)
  0x0C, 0xC0, 0x68, 0x01, 0x31, 0x0D, 0xB8, 0x25, 0x04, 0xDA, 0x02, 0x28, 0x1C, 0xFE, 0x3A, 0x0B,
  0x20, 0x3A, 0x08, 0x20, 0x6A, 0x05, 0x20, 0x9A, 0x02, 0x20, 0xBA, 0x30, 0xBA, 0x86, 0x57, 0x03,
  0xDF, 0xC4, 0x10,
  // "Ĭ" (U+012C)
  0x30, 0x30, 0xA3, 0x0B, 0x01, 0x38, 0x41, 0xF5, 0x18, 0xB5, 0x07, 0xA0, 0xC0, 0x16, 0x01, 0x02,
  0x77, 0x20, 0xCD, 0x06, 0x30, 0x30, 0xAA, 0x81, 0xC5, 0x14, 0x07, 0xA0, 0x56, 0x0B, 0xA0, 0x16,
  0x81, 0xEF, 0xD6, 0x02, 0xA0, 0xA6, 0x05, 0xA0, 0x66, 0x09, 0xA0, 0x36, 0x0C, 0xA7, 0xA0, 0xC6,
  0x04, 0xA0, 0x85, 0x05, 0x0C, 0xA0, 0xA0, 0x43, 0x05, 0xD0, 0xD3,
  // "ĭ" (U+012D)
  0x03, 0x0A, 0x38, 0x6B, 0x11, 0xF5, 0x18, 0xB2, 0x07, 0xA0, 0xC0, 0x13, 0x01, 0x02, 0x73, 0x0D,
  0xB0, 0x52, 0x04, 0x0D, 0xA0, 0x23, 0x81, 0xCF, 0xE4, 0xA0, 0xB3, 0x03, 0xA0, 0x83, 0x06, 0xA0,
  0x53, 0x09, 0xA0, 0x23, 0x0B, 0xA4, 0x0B, 0xA0, 0x50, 0x72, 0x83, 0x3D, 0xFC, 0x42,
  // "Į" (U+012E)
  0x30, 0xCD, 0x06, 0x30, 0x30, 0xAA, 0x81, 0xC5, 0x14, 0x07, 0xA0, 0x56, 0x0B, 0xA0, 0x16, 0x81,
  0xEF, 0xD6, 0x02, 0xA0, 0xA6, 0x05, 0xA0, 0x66, 0x09, 0xA0, 0x36, 0x0C, 0xA7, 0xA0, 0xC6, 0x04,
  0xA0, 0x85, 0x05, 0x0C, 0xA0, 0xA0, 0x43, 0x05, 0xD0, 0xD5, 0x81, 0xAC, 0x16, 0x81, 0x9F, 0x37,
  0x82, 0xBF, 0x51, 0x60, 0x5B, 0x02, 0x68, 0x11, 0x31, 0x50,
  // "į" (U+012F)
  0x38, 0x1A, 0xE8, 0x20, 0x2A, 0x0D, 0x38, 0x1A, 0xC4, 0x70, 0xDB, 0x82, 0x50, 0x4D, 0xA0, 0x22,
  0x81, 0xCF, 0xE3, 0xA0, 0xB2, 0x03, 0xA0, 0x82, 0x06, 0xA0, 0x52, 0x09, 0xA0, 0x22, 0x0B, 0xA3,
  0x0B, 0xA8, 0x25, 0x70, 0x3A, 0x84, 0xC4, 0x0A, 0xC1, 0x28, 0x19, 0xF3, 0x38, 0x2B, 0xF5, 0x12,
  0x05, 0xB0, 0x22, 0x81, 0x13, 0x12,
  // "İ" (U+0130)
  0x58, 0x22, 0xBB, 0x26, 0x08, 0xA0, 0x66, 0x82, 0x5E, 0xC1, 0x77, 0x0C, 0xD0, 0x63, 0x03, 0x0A,
  0xA8, 0x1C, 0x51, 0x40, 0x7A, 0x05, 0x60, 0xBA, 0x01, 0x68, 0x1E, 0xFD, 0x60, 0x2A, 0x0A, 0x60,
  0x5A, 0x06, 0x60, 0x9A, 0x03, 0x60, 0xCA, 0x7A, 0x0C, 0x60, 0x4A, 0x08, 0x50, 0x50, 0xCA, 0x0A,
  0x04, 0x30, 0x5D, 0x0D, 0x30,
  // "ı" (U+0131)
  0xDF, 0xFF, 0x54, 0xDF, 0xF2, 0x0C, 0xFE, 0x00, 0xFF, 0xB0, 0x3F, 0xF8, 0x06, 0xFF, 0x50, 0x9F,
  0xF2, 0x0B, 0xFF, 0x00, 0xBF, 0xF5, 0x73, 0xDF, 0xC4,
  // "Ĳ" (U+0132)
  0x30, 0xCD, 0x06, 0x0C, 0xD0, 0x63, 0x03, 0x0A, 0xA8, 0x3C, 0x51, 0x3A, 0xA8, 0x1C, 0x51, 0x40,
  0x7A, 0x05, 0x30, 0x7A, 0x05, 0x60, 0xBA, 0x01, 0x30, 0xBA, 0x01, 0x68, 0x1E, 0xFD, 0x48, 0x1E,
  0xFD, 0x60, 0x2A, 0x0A, 0x30, 0x2A, 0x0A, 0x60, 0x5A, 0x06, 0x30, 0x6A, 0x06, 0x60, 0x9A, 0x03,
  0x30, 0x9A, 0x03, 0x60, 0xCA, 0x40, 0xDA, 0x7A, 0x0C, 0x30, 0x1A, 0x0C, 0x60, 0x4A, 0x08, 0x30,
  0x4A, 0x08, 0x50, 0x50, 0xCA, 0x0A, 0x04, 0x20, 0x8A, 0x05, 0x40, 0x5D, 0x0D, 0x20, 0xBA, 0x02,
  0x76, 0xA0, 0xD7, 0x60, 0x7A, 0x06, 0x73, 0x81, 0x34, 0x7A, 0x09, 0x74, 0x83, 0xAF, 0xEA, 0x47,
  // "ĳ" (U+0133)
  0x28, 0x1A, 0xE8, 0x38, 0x3A, 0xE8, 0x02, 0xA0, 0xD2, 0x02, 0xA0, 0xD2, 0x81, 0xAC, 0x43, 0x81,
  0xAC, 0x47, 0x40, 0xDB, 0x81, 0x50, 0xDB, 0x81, 0x54, 0xDA, 0x82, 0x20, 0x4D, 0xA8, 0x32, 0x0C,
  0xFE, 0x38, 0x1C, 0xFE, 0x2A, 0x0B, 0x3A, 0x81, 0xA0, 0x3A, 0x08, 0x20, 0x3A, 0x81, 0x70, 0x6A,
  0x05, 0x20, 0x6A, 0x81, 0x40, 0x9A, 0x02, 0x20, 0xAA, 0x81, 0x10, 0xBA, 0x38, 0x1D, 0xFD, 0x20,
  0xBA, 0x81, 0x57, 0x1A, 0x09, 0x28, 0x43, 0xDF, 0xC4, 0x5A, 0x06, 0x70, 0x8A, 0x02, 0x78, 0x1D,
  0xFC, 0x58, 0x11, 0x49, 0xA0, 0x45, 0x83, 0x5E, 0xFC, 0x44,
  // "Ĵ" (U+0134)
  0x70, 0xCA, 0x04, 0x78, 0x3A, 0xF8, 0xEB, 0x68, 0x5A, 0xD3, 0x03, 0xE4, 0x77, 0x30, 0xCD, 0x06,
  0x50, 0x30, 0xAA, 0x81, 0xC5, 0x16, 0x07, 0xA0, 0x57, 0x10, 0xBA, 0x01, 0x71, 0x81, 0xEF, 0xD7,
  0x10, 0x2A, 0x0A, 0x71, 0x06, 0xA0, 0x67, 0x10, 0x9A, 0x03, 0x71, 0x0D, 0xA7, 0x10, 0x1A, 0x0C,
  0x71, 0x04, 0xA0, 0x87, 0x10, 0x8A, 0x05, 0x71, 0x0B, 0xA0, 0x27, 0x1A, 0x0D, 0x71, 0x07, 0xA0,
  0x65, 0x81, 0x34, 0x7A, 0x09, 0x68, 0x3A, 0xFE, 0xA4, 0x70,
  // "ĵ" (U+0135)
  0x50, 0xCA, 0x04, 0x58, 0x3A, 0xF8, 0xEB, 0x48, 0x5A, 0xD3, 0x03, 0xE4, 0x77, 0x0D, 0xB0, 0x55,
  0x04, 0x0D, 0xA0, 0x26, 0x81, 0xCF, 0xE7, 0xA0, 0xA6, 0x03, 0xA0, 0x76, 0x06, 0xA0, 0x46, 0x0A,
  0xA0, 0x16, 0x81, 0xDF, 0xD6, 0x01, 0xA0, 0x96, 0x05, 0xA0, 0x66, 0x08, 0xA0, 0x26, 0x81, 0xDF,
  0xC4, 0x81, 0x14, 0x9A, 0x04, 0x48, 0x35, 0xEF, 0xC4, 0x50,
  // "Ķ" (U+0136)
  0x30, 0xCD, 0x06, 0x05, 0xC0, 0x73, 0x03, 0x0A, 0xA8, 0x7C, 0x51, 0x1D, 0xFD, 0x61, 0x40, 0x7A,
  0x05, 0x28, 0x12, 0xEA, 0x70, 0xBA, 0x83, 0x10, 0x3D, 0x87, 0x18, 0x5E, 0xFD, 0x04, 0xE6, 0x71,
  0x02, 0xA8, 0x2A, 0x7F, 0xB7, 0x20, 0x6A, 0x0E, 0xB0, 0x27, 0x10, 0x9A, 0x08, 0x09, 0xA0, 0x87,
  0x10, 0xDA, 0x10, 0x3A, 0x0E, 0x70, 0x1A, 0x0C, 0x20, 0xCA, 0x07, 0x60, 0x4A, 0x08, 0x20, 0x6A,
  0x0D, 0x50, 0x50, 0xCA, 0x0A, 0x04, 0x20, 0xEA, 0x09, 0x01, 0x20, 0x5D, 0x0D, 0x28, 0x33, 0xCE,
  0xF5, 0x77, 0x72, 0x81, 0x5F, 0xC7, 0x68, 0x1B, 0xE2, 0x75, 0x81, 0x2E, 0x37, 0x20,
  // "ķ" (U+0137)
  0x10, 0x5B, 0x0E, 0x70, 0x10, 0x6A, 0x0B, 0x71, 0x03, 0xA0, 0x87, 0x10, 0x6A, 0x05, 0x71, 0x09,
  0xA0, 0x10, 0x2C, 0x05, 0x28, 0x90, 0xCF, 0xD0, 0x1A, 0xFD, 0x61, 0x2A, 0x83, 0xA0, 0x2E, 0xA4,
  0x03, 0xA8, 0x26, 0x3E, 0x85, 0x07, 0xA0, 0x8A, 0x02, 0x50, 0xAA, 0x0D, 0xA0, 0xA5, 0x83, 0xDF,
  0xD0, 0xCA, 0x02, 0x30, 0x1A, 0x81, 0x90, 0x6A, 0x0A, 0x30, 0x4A, 0x06, 0x20, 0xEA, 0x08, 0x20,
  0x8A, 0x02, 0x28, 0x33, 0xBE, 0xF1, 0x77, 0x18, 0x15, 0xFC, 0x72, 0x81, 0xBE, 0x27, 0x18, 0x12,
  0xE3, 0x71,
  // "ĸ" (U+0138)
  0x03, 0xC0, 0x10, 0x2C, 0x81, 0x51, 0x5A, 0x89, 0x0D, 0x01, 0xAF, 0xD6, 0x10, 0x1A, 0x83, 0xA0,
  0x2E, 0x94, 0x04, 0xA8, 0x26, 0x4E, 0x75, 0x07, 0xA0, 0x9A, 0x03, 0x50, 0xAA, 0x0D, 0xA0, 0xA5,
  0x83, 0xDF, 0xC0, 0xCA, 0x02, 0x30, 0x1A, 0x81, 0x90, 0x6A, 0x0A, 0x30, 0x4A, 0x06, 0x20, 0xEA,
  0x08, 0x20, 0x8A, 0x02, 0x28, 0x33, 0xBE, 0xF1, 0x10,
  // "Ĺ" (U+0139)
  0x70, 0x2A, 0x0A, 0x71, 0x81, 0xCF, 0x77, 0x18, 0x1A, 0xC3, 0x77, 0x40, 0xCD, 0x05, 0x60, 0x7A,
  0x0A, 0x01, 0x70, 0x8A, 0x04, 0x71, 0x0B, 0xA0, 0x17, 0x18, 0x1E, 0xFD, 0x71, 0x02, 0xA0, 0xA7,
  0x10, 0x6A, 0x07, 0x71, 0x09, 0xA0, 0x37, 0x10, 0xCA, 0x50, 0x13, 0xA0, 0xC4, 0x03, 0x0E, 0x20,
  0x3A, 0x09, 0x40, 0x90, 0xB2, 0x09, 0xA0, 0x63, 0x82, 0x4F, 0x74, 0xFB, 0x04,
  // "ĺ" (U+013A)
  0x40, 0x2A, 0x0A, 0x48, 0x1C, 0xF7, 0x48, 0x1A, 0xC3, 0x20, 0x5B, 0x0E, 0x30, 0x10, 0x6A, 0x0B,
  0x40, 0x3A, 0x08, 0x40, 0x6A, 0x05, 0x40, 0x9A, 0x01, 0x48, 0x1D, 0xFD, 0x5A, 0x0A, 0x40, 0x4A,
  0x07, 0x40, 0x7A, 0x04, 0x40, 0xAA, 0x58, 0x1D, 0xFD, 0x5A, 0x0A, 0x5A, 0x81, 0xD5, 0x53, 0x83,
  0x7E, 0xEB, 0x23,
  // "Ļ" (U+013B)
  0x30, 0xCD, 0x05, 0x60, 0x7A, 0x0A, 0x01, 0x70, 0x8A, 0x04, 0x71, 0x0B, 0xA0, 0x17, 0x18, 0x1E,
  0xFD, 0x71, 0x02, 0xA0, 0xA7, 0x10, 0x6A, 0x07, 0x71, 0x09, 0xA0, 0x37, 0x10, 0xCA, 0x50, 0x13,
  0xA0, 0xC4, 0x03, 0x0E, 0x20, 0x3A, 0x09, 0x40, 0x90, 0xB2, 0x09, 0xA0, 0x63, 0x82, 0x4F, 0x74,
  0xFB, 0x04, 0x77, 0x28, 0x15, 0xFC, 0x72, 0x81, 0xBE, 0x27, 0x18, 0x12, 0xE3, 0x60,
  // "ļ" (U+013C)
  0x20, 0x5B, 0x0E, 0x20, 0x10, 0x6A, 0x0B, 0x30, 0x3A, 0x08, 0x30, 0x6A, 0x05, 0x30, 0x9A, 0x01,
  0x38, 0x1D, 0xFD, 0x4A, 0x0A, 0x30, 0x4A, 0x07, 0x30, 0x7A, 0x04, 0x30, 0xAA, 0x48, 0x1D, 0xFD,
  0x4A, 0x0A, 0x4A, 0x81, 0xD5, 0x52, 0x83, 0x7E, 0xEB, 0x27, 0x18, 0x15, 0xFC, 0x48, 0x1B, 0xE2,
  0x38, 0x12, 0xE3, 0x40,
  // "Ľ" (U+013D)
  0x30, 0xCD, 0x82, 0x55, 0xFC, 0x40, 0x7A, 0x84, 0xA1, 0x0B, 0xE1, 0x40, 0x8A, 0x83, 0x40, 0x2D,
  0x25, 0x0B, 0xA0, 0x17, 0x28, 0x1E, 0xFD, 0x72, 0x02, 0xA0, 0xA7, 0x20, 0x6A, 0x07, 0x72, 0x09,
  0xA0, 0x37, 0x20, 0xCA, 0x50, 0x14, 0xA0, 0xC4, 0x03, 0x0E, 0x30, 0x3A, 0x09, 0x40, 0x90, 0xB3,
  0x09, 0xA0, 0x63, 0x83, 0x4F, 0x70, 0x4F, 0xB0, 0x41,
  // "ľ" (U+013E)
  0x05, 0xB8, 0x5E, 0x09, 0xF9, 0x16, 0xA8, 0x2B, 0x0E, 0xD2, 0x03, 0xA8, 0x28, 0x5E, 0x22, 0x06,
  0xA8, 0x15, 0x11, 0x30, 0x9A, 0x01, 0x58, 0x1D, 0xFD, 0x6A, 0x0A, 0x50, 0x4A, 0x07, 0x50, 0x7A,
  0x04, 0x50, 0xAA, 0x68, 0x1D, 0xFD, 0x6A, 0x0A, 0x6A, 0x81, 0xD5, 0x54, 0x83, 0x7E, 0xEB, 0x24,
  // "Ŀ" (U+013F)
  0x30, 0xCD, 0x05, 0x70, 0x7A, 0x0A, 0x01, 0x71, 0x08, 0xA0, 0x47, 0x20, 0xBA, 0x01, 0x72, 0x81,
  0xEF, 0xD7, 0x20, 0x2A, 0x0A, 0x28, 0x22, 0xBB, 0x23, 0x06, 0xA0, 0x72, 0x08, 0xA0, 0x63, 0x09,
  0xA0, 0x32, 0x82, 0x5E, 0xC1, 0x30, 0xCA, 0x50, 0x14, 0xA0, 0xC4, 0x03, 0x0E, 0x30, 0x3A, 0x09,
  0x40, 0x90, 0xB3, 0x09, 0xA0, 0x63, 0x83, 0x4F, 0x70, 0x4F, 0xB0, 0x41,
  // "ŀ" (U+0140)
  0x05, 0xB0, 0xE3, 0x01, 0x06, 0xA0, 0xB4, 0x03, 0xA0, 0x84, 0x06, 0xA0, 0x54, 0x09, 0xA0, 0x14,
  0x81, 0xDF, 0xD5, 0xA8, 0x4A, 0x2B, 0xB2, 0x4A, 0x07, 0x08, 0xA0, 0x60, 0x7A, 0x84, 0x45, 0xEC,
  0x1A, 0xA5, 0x81, 0xDF, 0xD5, 0xA0, 0xA5, 0xA8, 0x1D, 0x55, 0x38, 0x37, 0xEE, 0xB2, 0x30,
  // "Ł" (U+0141)
  0x30, 0xCD, 0x05, 0x60, 0x7A, 0x0A, 0x01, 0x70, 0x8A, 0x04, 0x71, 0x0B, 0xA8, 0x11, 0x03, 0x68,
  0x4E, 0xFD, 0x5D, 0x75, 0x02, 0xB0, 0xD0, 0x56, 0x07, 0xA0, 0x96, 0x01, 0x0C, 0xB0, 0x36, 0x81,
  0x35, 0xCA, 0x50, 0x13, 0xA0, 0xC4, 0x03, 0x0E, 0x20, 0x3A, 0x09, 0x40, 0x90, 0xB2, 0x09, 0xA0,
  0x63, 0x82, 0x4F, 0x74, 0xFB, 0x04,
  // "ł" (U+0142)
  0x10, 0x5B, 0x0E, 0x20, 0x10, 0x6A, 0x0B, 0x30, 0x3A, 0x08, 0x30, 0x6A, 0x05, 0x30, 0x9A, 0x02,
  0x38, 0x3C, 0xFE, 0x11, 0x2A, 0x83, 0xEE, 0x20, 0x3A, 0x83, 0xB2, 0x06, 0xEA, 0x04, 0x20, 0xA0,
  0xCA, 0x01, 0x38, 0x1D, 0xFD, 0x4A, 0x0B, 0x4A, 0x81, 0xD5, 0x52, 0x83, 0x7E, 0xEB, 0x21,
  // "Ń" (U+0143)
  0x73, 0x02, 0xA0, 0xA7, 0x68, 0x1C, 0xF7, 0x76, 0x81, 0xAC, 0x37, 0x77, 0x40, 0xCB, 0x08, 0x40,
  0xEB, 0x08, 0x30, 0x30, 0xAA, 0x0E, 0x48, 0x34, 0xDE, 0x61, 0x40, 0x7B, 0x07, 0x40, 0xD0, 0x86,
  0x83, 0xBA, 0xEF, 0xE3, 0x81, 0x1F, 0x46, 0x81, 0xE6, 0x8A, 0x06, 0x28, 0x14, 0xF1, 0x58, 0x52,
  0xF2, 0x1E, 0xFD, 0x20, 0x70, 0xD6, 0x06, 0x0E, 0x20, 0x8A, 0x82, 0x50, 0xBA, 0x60, 0x90, 0xB2,
  0x01, 0xA8, 0x2D, 0x0E, 0x66, 0x0D, 0x08, 0x30, 0x8A, 0x81, 0x7F, 0x35, 0x81, 0x1F, 0x43, 0x01,
  0xC6, 0x81, 0x4F, 0x14, 0x09, 0xA0, 0xC5, 0x83, 0x5C, 0xF5, 0x13, 0x02, 0xA0, 0x94, 0x05, 0xC0,
  0x34, 0x81, 0x9F, 0x54,
  // "ń" (U+0144)
  0x70, 0x2A, 0x0A, 0x71, 0x81, 0xCF, 0x77, 0x18, 0x1A, 0xC3, 0x77, 0x20, 0xDB, 0x84, 0x27, 0xDF,
  0xC1, 0x20, 0x40, 0xDA, 0x81, 0x97, 0x8A, 0x08, 0x30, 0xCA, 0x81, 0x90, 0x3A, 0x09, 0x38, 0x4E,
  0xFE, 0x10, 0x5A, 0x07, 0x20, 0x2A, 0x09, 0x20, 0x8A, 0x04, 0x20, 0x6A, 0x04, 0x20, 0xBA, 0x01,
  0x20, 0x9A, 0x01, 0x28, 0x1E, 0xFD, 0x38, 0x1C, 0xFD, 0x3A, 0x0B, 0x3A, 0x0A, 0x3A, 0x82, 0xD5,
  0x53, 0xA0, 0x73, 0x83, 0x6E, 0xEB, 0x20,
  // "Ņ" (U+0145)
  0x30, 0xCB, 0x08, 0x40, 0xEB, 0x08, 0x30, 0x30, 0xAA, 0x0E, 0x48, 0x34, 0xDE, 0x61, 0x40, 0x7B,
  0x07, 0x40, 0xD0, 0x86, 0x83, 0xBA, 0xEF, 0xE3, 0x81, 0x1F, 0x46, 0x81, 0xE6, 0x8A, 0x06, 0x28,
  0x14, 0xF1, 0x58, 0x52, 0xF2, 0x1E, 0xFD, 0x20, 0x70, 0xD6, 0x06, 0x0E, 0x20, 0x8A, 0x82, 0x50,
  0xBA, 0x60, 0x90, 0xB2, 0x01, 0xA8, 0x2D, 0x0E, 0x66, 0x0D, 0x08, 0x30, 0x8A, 0x81, 0x7F, 0x35,
  0x81, 0x1F, 0x43, 0x01, 0xC6, 0x81, 0x4F, 0x14, 0x09, 0xA0, 0xC5, 0x83, 0x5C, 0xF5, 0x13, 0x02,
  0xA0, 0x94, 0x05, 0xC0, 0x34, 0x81, 0x9F, 0x57, 0x77, 0x58, 0x15, 0xFC, 0x77, 0x81, 0xBE, 0x27,
  0x68, 0x12, 0xE3, 0x73,
  // "ņ" (U+0146)
  0x10, 0xDB, 0x84, 0x27, 0xDF, 0xC1, 0x20, 0x40, 0xDA, 0x81, 0x97, 0x8A, 0x08, 0x30, 0xCA, 0x81,
  0x90, 0x3A, 0x09, 0x38, 0x4E, 0xFE, 0x10, 0x5A, 0x07, 0x20, 0x2A, 0x09, 0x20, 0x8A, 0x04, 0x20,
  0x6A, 0x04, 0x20, 0xBA, 0x01, 0x20, 0x9A, 0x01, 0x28, 0x1E, 0xFD, 0x38, 0x1C, 0xFD, 0x3A, 0x0B,
  0x3A, 0x0A, 0x3A, 0x82, 0xD5, 0x53, 0xA0, 0x73, 0x83, 0x6E, 0xEB, 0x27, 0x71, 0x81, 0x5F, 0xC7,
  0x28, 0x1B, 0xE2, 0x71, 0x81, 0x2E, 0x37,
  // "Ň" (U+0147)
  0x78, 0x54, 0xF4, 0x03, 0xDA, 0x74, 0x83, 0xBE, 0x8F, 0xB7, 0x50, 0x3A, 0x0C, 0x77, 0x74, 0x0C,
  0xB0, 0x84, 0x0E, 0xB0, 0x83, 0x03, 0x0A, 0xA0, 0xE4, 0x83, 0x4D, 0xE6, 0x14, 0x07, 0xB0, 0x74,
  0x0D, 0x08, 0x68, 0x3B, 0xAE, 0xFE, 0x38, 0x11, 0xF4, 0x68, 0x1E, 0x68, 0xA0, 0x62, 0x81, 0x4F,
  0x15, 0x85, 0x2F, 0x21, 0xEF, 0xD2, 0x07, 0x0D, 0x60, 0x60, 0xE2, 0x08, 0xA8, 0x25, 0x0B, 0xA6,
  0x09, 0x0B, 0x20, 0x1A, 0x82, 0xD0, 0xE6, 0x60, 0xD0, 0x83, 0x08, 0xA8, 0x17, 0xF3, 0x58, 0x11,
  0xF4, 0x30, 0x1C, 0x68, 0x14, 0xF1, 0x40, 0x9A, 0x0C, 0x58, 0x35, 0xCF, 0x51, 0x30, 0x2A, 0x09,
  0x40, 0x5C, 0x03, 0x48, 0x19, 0xF5, 0x40,
  // "ň" (U+0148)
  0x48, 0x54, 0xF4, 0x03, 0xDA, 0x68, 0x3B, 0xE8, 0xFB, 0x70, 0x3A, 0x0C, 0x77, 0x20, 0xDB, 0x84,
  0x27, 0xDF, 0xC1, 0x20, 0x40, 0xDA, 0x81, 0x97, 0x8A, 0x08, 0x30, 0xCA, 0x81, 0x90, 0x3A, 0x09,
  0x38, 0x4E, 0xFE, 0x10, 0x5A, 0x07, 0x20, 0x2A, 0x09, 0x20, 0x8A, 0x04, 0x20, 0x6A, 0x04, 0x20,
  0xBA, 0x01, 0x20, 0x9A, 0x01, 0x28, 0x1E, 0xFD, 0x38, 0x1C, 0xFD, 0x3A, 0x0B, 0x3A, 0x0A, 0x3A,
  0x82, 0xD5, 0x53, 0xA0, 0x73, 0x83, 0x6E, 0xEB, 0x20,
  // "ŉ" (U+0149)
  0x18, 0x22, 0xDD, 0x27, 0x50, 0x4A, 0x07, 0x76, 0x81, 0xAF, 0x57, 0x68, 0x28, 0xD0, 0xDB, 0x89,
  0x42, 0x7D, 0xFC, 0x10, 0x1A, 0xC2, 0x04, 0xDA, 0x81, 0x97, 0x8A, 0x82, 0x80, 0x24, 0x40, 0xCA,
  0x81, 0x90, 0x3A, 0x09, 0x78, 0x4E, 0xFE, 0x10, 0x5A, 0x07, 0x60, 0x2A, 0x09, 0x20, 0x8A, 0x04,
  0x60, 0x6A, 0x04, 0x20, 0xBA, 0x01, 0x60, 0x9A, 0x01, 0x28, 0x1E, 0xFD, 0x78, 0x1C, 0xFD, 0x3A,
  0x0B, 0x7A, 0x0A, 0x3A, 0x81, 0xD5, 0x54, 0x03, 0xA0, 0x73, 0x83, 0x6E, 0xEB, 0x20,
  // "Ŋ" (U+014A)
  0x30, 0xCB, 0x08, 0x40, 0xEB, 0x08, 0x30, 0x30, 0xAA, 0x0E, 0x48, 0x34, 0xDE, 0x61, 0x40, 0x7B,
  0x07, 0x40, 0xD0, 0x76, 0x83, 0xBA, 0xEF, 0xE3, 0x81, 0x1F, 0x46, 0x81, 0xE6, 0x8A, 0x06, 0x28,
  0x14, 0xF1, 0x58, 0x52, 0xF2, 0x1E, 0xFD, 0x20, 0x70, 0xD6, 0x06, 0x0E, 0x20, 0x8A, 0x82, 0x50,
  0xB9, 0x60, 0x90, 0xB2, 0x01, 0xA8, 0x2D, 0x0E, 0x66, 0x0D, 0x08, 0x30, 0x8A, 0x81, 0x7F, 0x35,
  0x81, 0x1F, 0x43, 0x01, 0xB0, 0xE6, 0x81, 0x4F, 0x14, 0x09, 0xA0, 0xB5, 0x83, 0x5C, 0xF5, 0x13,
  0x02, 0xA0, 0x84, 0x05, 0xC0, 0x34, 0x81, 0x9F, 0x57, 0x78, 0x18, 0xF1, 0x76, 0x81, 0x1E, 0xA7,
  0x48, 0x42, 0x46, 0xDE, 0x27, 0x48, 0x36, 0xED, 0xA2, 0x60,
  // "ŋ" (U+014B)
  0x10, 0xDB, 0x87, 0x26, 0xDF, 0xC1, 0x04, 0xDA, 0x81, 0x97, 0x8A, 0x08, 0x20, 0xCA, 0x81, 0x90,
  0x3A, 0x09, 0x28, 0x4E, 0xFE, 0x10, 0x5A, 0x81, 0x60, 0x2A, 0x09, 0x20, 0x8A, 0x81, 0x30, 0x6A,
  0x04, 0x20, 0xBA, 0x20, 0x9A, 0x01, 0x28, 0x1E, 0xFC, 0x28, 0x1C, 0xFD, 0x20, 0x2A, 0x09, 0x2A,
  0x0A, 0x20, 0x6A, 0x81, 0x50, 0x3A, 0x07, 0x20, 0x9A, 0x02, 0x78, 0x1D, 0xFE, 0x70, 0x3A, 0x08,
  0x58, 0x42, 0x4C, 0xFD, 0x15, 0x83, 0x9F, 0xEA, 0x23,
  // "Ō" (U+014C)
  0x50, 0xCC, 0x06, 0x78, 0x01, 0x37, 0x85, 0x39, 0xDF, 0xEB, 0x55, 0x84, 0x8F, 0xE6, 0x48, 0xA0,
  0x83, 0x82, 0xAF, 0xE1, 0x30, 0x9A, 0x81, 0x30, 0x6A, 0x05, 0x40, 0x4A, 0x83, 0x90, 0xEF, 0xD5,
  0x02, 0xA0, 0xB0, 0x6A, 0x08, 0x50, 0x3A, 0x0B, 0x0A, 0xA0, 0x45, 0x05, 0xA0, 0x80, 0xCA, 0x02,
  0x50, 0x9A, 0x04, 0x0C, 0xA0, 0x15, 0x83, 0xEF, 0xD0, 0xAA, 0x02, 0x40, 0x6A, 0x81, 0x40, 0x4A,
  0x07, 0x38, 0x22, 0xEF, 0x83, 0x09, 0xA8, 0x48, 0x47, 0xEF, 0x85, 0x85, 0x5B, 0xEF, 0xD9, 0x24,
  // "ō" (U+014D)
  0x40, 0xCC, 0x06, 0x58, 0x01, 0x35, 0x85, 0x29, 0xDF, 0xD8, 0x13, 0x86, 0x4E, 0xF8, 0x4D, 0xFB,
  0x28, 0x22, 0xEF, 0x82, 0x06, 0xA8, 0x13, 0x0A, 0xA0, 0x12, 0x05, 0xA0, 0x51, 0xA0, 0xC3, 0x07,
  0xA0, 0x50, 0x3A, 0x09, 0x30, 0xAA, 0x01, 0x04, 0xA0, 0x73, 0x83, 0xEF, 0xB0, 0x1A, 0x08, 0x20,
  0x7A, 0x03, 0x28, 0x3A, 0xFE, 0x56, 0xA0, 0x54, 0x84, 0x7D, 0xFD, 0xA3, 0x30,
  // "Ŏ" (U+014E)
  0x50, 0x30, 0xA3, 0x0B, 0x01, 0x68, 0x41, 0xF5, 0x18, 0xB7, 0x10, 0x7A, 0x0C, 0x01, 0x72, 0x01,
  0x02, 0x77, 0x78, 0x53, 0x9D, 0xFE, 0xB5, 0x58, 0x48, 0xFE, 0x64, 0x8A, 0x08, 0x38, 0x2A, 0xFE,
  0x13, 0x09, 0xA8, 0x13, 0x06, 0xA0, 0x54, 0x04, 0xA8, 0x39, 0x0E, 0xFD, 0x50, 0x2A, 0x0B, 0x06,
  0xA0, 0x85, 0x03, 0xA0, 0xB0, 0xAA, 0x04, 0x50, 0x5A, 0x08, 0x0C, 0xA0, 0x25, 0x09, 0xA0, 0x40,
  0xCA, 0x01, 0x58, 0x3E, 0xFD, 0x0A, 0xA0, 0x24, 0x06, 0xA8, 0x14, 0x04, 0xA0, 0x73, 0x82, 0x2E,
  0xF8, 0x30, 0x9A, 0x84, 0x84, 0x7E, 0xF8, 0x58, 0x55, 0xBE, 0xFD, 0x92, 0x40,
  // "ŏ" (U+014F)
  0x40, 0x30, 0xA3, 0x0B, 0x01, 0x48, 0x41, 0xF5, 0x18, 0xB6, 0x07, 0xA0, 0xC0, 0x17, 0x01, 0x02,
  0x77, 0x38, 0x52, 0x9D, 0xFD, 0x81, 0x38, 0x64, 0xEF, 0x84, 0xDF, 0xB2, 0x82, 0x2E, 0xF8, 0x20,
  0x6A, 0x81, 0x30, 0xAA, 0x01, 0x20, 0x5A, 0x05, 0x1A, 0x0C, 0x30, 0x7A, 0x05, 0x03, 0xA0, 0x93,
  0x0A, 0xA0, 0x10, 0x4A, 0x07, 0x38, 0x3E, 0xFB, 0x01, 0xA0, 0x82, 0x07, 0xA0, 0x32, 0x83, 0xAF,
  0xE5, 0x6A, 0x05, 0x48, 0x47, 0xDF, 0xDA, 0x33,
  // "Ő" (U+0150)
  0x68, 0x54, 0xEC, 0x1C, 0xE5, 0x58, 0x51, 0xDD, 0x28, 0xF6, 0x68, 0x4B, 0xB1, 0x4E, 0x47, 0x75,
  0x85, 0x39, 0xDF, 0xEB, 0x55, 0x84, 0x8F, 0xE6, 0x48, 0xA0, 0x83, 0x82, 0xAF, 0xE1, 0x30, 0x9A,
  0x81, 0x30, 0x6A, 0x05, 0x40, 0x4A, 0x83, 0x90, 0xEF, 0xD5, 0x02, 0xA0, 0xB0, 0x6A, 0x08, 0x50,
  0x3A, 0x0B, 0x0A, 0xA0, 0x45, 0x05, 0xA0, 0x80, 0xCA, 0x02, 0x50, 0x9A, 0x04, 0x0C, 0xA0, 0x15,
  0x83, 0xEF, 0xD0, 0xAA, 0x02, 0x40, 0x6A, 0x81, 0x40, 0x4A, 0x07, 0x38, 0x22, 0xEF, 0x83, 0x09,
  0xA8, 0x48, 0x47, 0xEF, 0x85, 0x85, 0x5B, 0xEF, 0xD9, 0x24,
  // "ő" (U+0151)
  0x58, 0x54, 0xEC, 0x1C, 0xE5, 0x48, 0x51, 0xDD, 0x28, 0xF6, 0x58, 0x4B, 0xB1, 0x4E, 0x47, 0x73,
  0x85, 0x29, 0xDF, 0xD8, 0x14, 0x86, 0x4E, 0xF8, 0x4D, 0xFB, 0x38, 0x22, 0xEF, 0x82, 0x06, 0xA0,
  0x32, 0x0A, 0xA0, 0x12, 0x05, 0xA0, 0x52, 0xA0, 0xC3, 0x07, 0xA8, 0x15, 0x03, 0xA0, 0x93, 0x0A,
  0xA8, 0x11, 0x04, 0xA0, 0x73, 0x81, 0xEF, 0xB2, 0x01, 0xA0, 0x82, 0x07, 0xA0, 0x33, 0x83, 0xAF,
  0xE5, 0x6A, 0x05, 0x58, 0x47, 0xDF, 0xDA, 0x34,
  // "Œ" (U+0152)
  0x48, 0x13, 0x9D, 0xFB, 0x06, 0x38, 0x48, 0xFE, 0x75, 0x6A, 0x85, 0xE4, 0x44, 0xBF, 0x32, 0x82,
  0xAF, 0xE2, 0x20, 0x1A, 0x0A, 0x30, 0x59, 0x20, 0x6A, 0x05, 0x30, 0x5A, 0x06, 0x40, 0x12, 0x81,
  0xEF, 0xD4, 0x08, 0xA0, 0x36, 0x06, 0xA0, 0x84, 0x0B, 0xE3, 0x0A, 0xA0, 0x44, 0x81, 0xEF, 0xC8,
  0x00, 0x33, 0x0C, 0xA0, 0x23, 0x03, 0xA0, 0x87, 0x0C, 0xA0, 0x13, 0x06, 0xA0, 0x57, 0x0A, 0xA0,
  0x23, 0x09, 0xA0, 0x23, 0x83, 0x2B, 0x10, 0x4A, 0x08, 0x30, 0xDA, 0x40, 0x80, 0xE3, 0x09, 0xA8,
  0x19, 0x57, 0xA8, 0x5D, 0x44, 0x48, 0xFA, 0x48, 0x15, 0xBE, 0xFB, 0x07, 0x20,
  // "œ" (U+0153)
  0x38, 0x93, 0x19, 0xDF, 0xD8, 0x01, 0x9D, 0xFC, 0x43, 0x89, 0x44, 0xEF, 0x84, 0xDF, 0xAE, 0xC4,
  0xBF, 0xE2, 0x82, 0x1E, 0xF9, 0x20, 0x6B, 0x81, 0x20, 0x7A, 0x81, 0x10, 0x9A, 0x02, 0x20, 0x5A,
  0x0A, 0x28, 0x1C, 0xFC, 0x2A, 0x0C, 0x30, 0x7A, 0x86, 0x63, 0xAF, 0xE2, 0x03, 0xA0, 0x93, 0x0A,
  0xC8, 0x1E, 0x91, 0x20, 0x4A, 0x07, 0x30, 0xEA, 0x04, 0x02, 0x50, 0x1A, 0x08, 0x20, 0x6B, 0x02,
  0x30, 0x23, 0x83, 0xAF, 0xE5, 0x6A, 0x85, 0xEF, 0xC5, 0x49, 0xB4, 0x89, 0x37, 0xDF, 0xEA, 0x31,
  0xAE, 0xFD, 0x91, 0x20,
  // "Ŕ" (U+0154)
  0x72, 0x02, 0xA0, 0xA7, 0x38, 0x1C, 0xF7, 0x73, 0x81, 0xAC, 0x37, 0x76, 0x0C, 0xE8, 0x1D, 0x92,
  0x40, 0x30, 0xAA, 0x81, 0x94, 0x7A, 0x0D, 0x50, 0x7A, 0x04, 0x20, 0xCA, 0x04, 0x40, 0xBA, 0x01,
  0x20, 0xBA, 0x04, 0x48, 0x1E, 0xFC, 0x38, 0x1E, 0xFE, 0x40, 0x2A, 0x85, 0x90, 0x3B, 0xFE, 0x44,
  0x06, 0xE0, 0x80, 0x15, 0x09, 0xA0, 0x50, 0x8A, 0x07, 0x68, 0x3D, 0xFE, 0x01, 0xA0, 0xD5, 0x01,
  0xA0, 0xB2, 0x0C, 0xA0, 0x34, 0x04, 0xA0, 0x82, 0x07, 0xA0, 0xA3, 0x05, 0x0C, 0xA8, 0x2A, 0x41,
  0x1B, 0x81, 0x60, 0x5E, 0x83, 0x30, 0x4B, 0xE9, 0x10,
  // "ŕ" (U+0155)
  0x60, 0x2A, 0x0A, 0x68, 0x1C, 0xF7, 0x68, 0x1A, 0xC3, 0x76, 0x0D, 0xB8, 0x90, 0x18, 0xEE, 0x90,
  0x4D, 0xFE, 0x0F, 0x8A, 0x28, 0x6B, 0xFE, 0x90, 0x2F, 0x82, 0x0E, 0xA0, 0x22, 0x01, 0x20, 0x2A,
  0x0B, 0x60, 0x5A, 0x06, 0x60, 0x9A, 0x02, 0x68, 0x1C, 0xFE, 0x7A, 0x0A, 0x60, 0x3A, 0x07, 0x60,
  // "Ŗ" (U+0156)
  0x30, 0xCE, 0x81, 0xD9, 0x24, 0x03, 0x0A, 0xA8, 0x19, 0x47, 0xA0, 0xD5, 0x07, 0xA0, 0x42, 0x0C,
  0xA0, 0x44, 0x0B, 0xA0, 0x12, 0x0B, 0xA0, 0x44, 0x81, 0xEF, 0xC3, 0x81, 0xEF, 0xE4, 0x02, 0xA8,
  0x59, 0x03, 0xBF, 0xE4, 0x40, 0x6E, 0x08, 0x01, 0x50, 0x9A, 0x05, 0x08, 0xA0, 0x76, 0x83, 0xDF,
  0xE0, 0x1A, 0x0D, 0x50, 0x1A, 0x0B, 0x20, 0xCA, 0x03, 0x40, 0x4A, 0x08, 0x20, 0x7A, 0x0A, 0x30,
  0x50, 0xCA, 0x82, 0xA4, 0x11, 0xB8, 0x16, 0x05, 0xE8, 0x33, 0x04, 0xBE, 0x97, 0x76, 0x81, 0x5F,
  0xC7, 0x48, 0x1B, 0xE2, 0x73, 0x81, 0x2E, 0x37,
  // "ŗ" (U+0157)
  0x20, 0xDB, 0x83, 0x18, 0xEE, 0x92, 0x82, 0x4D, 0xFE, 0x0F, 0x8A, 0x38, 0x6B, 0xFE, 0x90, 0x2F,
  0x83, 0x0E, 0xA0, 0x22, 0x01, 0x30, 0x2A, 0x0B, 0x70, 0x5A, 0x06, 0x70, 0x9A, 0x02, 0x78, 0x1C,
  0xFE, 0x71, 0xA0, 0xA7, 0x03, 0xA0, 0x77, 0x74, 0x81, 0x5F, 0xC7, 0x18, 0x1B, 0xE2, 0x78, 0x12,
  0xE3, 0x71,
  // "Ř" (U+0158)
  0x58, 0x54, 0xF4, 0x03, 0xDA, 0x71, 0x83, 0xBE, 0x8F, 0xB7, 0x20, 0x3A, 0x0C, 0x77, 0x70, 0xCE,
  0x81, 0xD9, 0x24, 0x03, 0x0A, 0xA8, 0x19, 0x47, 0xA0, 0xD5, 0x07, 0xA0, 0x42, 0x0C, 0xA0, 0x44,
  0x0B, 0xA0, 0x12, 0x0B, 0xA0, 0x44, 0x81, 0xEF, 0xC3, 0x81, 0xEF, 0xE4, 0x02, 0xA8, 0x59, 0x03,
  0xBF, 0xE4, 0x40, 0x6E, 0x08, 0x01, 0x50, 0x9A, 0x05, 0x08, 0xA0, 0x76, 0x83, 0xDF, 0xE0, 0x1A,
  0x0D, 0x50, 0x1A, 0x0B, 0x20, 0xCA, 0x03, 0x40, 0x4A, 0x08, 0x20, 0x7A, 0x0A, 0x30, 0x50, 0xCA,
  0x82, 0xA4, 0x11, 0xB8, 0x16, 0x05, 0xE8, 0x33, 0x04, 0xBE, 0x91,
  // "ř" (U+0159)
  0x28, 0x54, 0xF4, 0x03, 0xDA, 0x48, 0x3B, 0xE8, 0xFB, 0x50, 0x3A, 0x0C, 0x77, 0x0D, 0xB8, 0x90,
  0x18, 0xEE, 0x90, 0x4D, 0xFE, 0x0F, 0x8A, 0x28, 0x6B, 0xFE, 0x90, 0x2F, 0x82, 0x0E, 0xA0, 0x22,
  0x01, 0x20, 0x2A, 0x0B, 0x60, 0x5A, 0x06, 0x60, 0x9A, 0x02, 0x68, 0x1C, 0xFE, 0x7A, 0x0A, 0x60,
  0x3A, 0x07, 0x60,
  // "Ś" (U+015A)
  0x70, 0x2A, 0x0A, 0x78, 0x1C, 0xF7, 0x78, 0x1A, 0xC3, 0x77, 0x28, 0x51, 0x9D, 0xFE, 0xC7, 0x38,
  0x42, 0xEF, 0x72, 0x7A, 0x08, 0x28, 0x1B, 0xFA, 0x38, 0x1C, 0xF8, 0x28, 0x1D, 0xFB, 0x30, 0x05,
  0x30, 0xCA, 0x06, 0x70, 0x6B, 0x0C, 0x03, 0x60, 0x8C, 0x07, 0x60, 0x40, 0xDB, 0x03, 0x20, 0x10,
  0x23, 0x09, 0xA8, 0x38, 0x05, 0xFA, 0x4A, 0x83, 0x90, 0xBF, 0xE4, 0x83, 0xEF, 0x50, 0x5A, 0x84,
  0xA3, 0x2A, 0xFB, 0x38, 0x54, 0xBE, 0xFE, 0xC6, 0x30,
  // "ś" (U+015B)
  0x60, 0x2A, 0x0A, 0x68, 0x1C, 0xF7, 0x68, 0x1A, 0xC3, 0x77, 0x85, 0x3A, 0xDF, 0xEA, 0x12, 0x03,
  0xA8, 0x37, 0x4D, 0xFA, 0x28, 0x18, 0xFD, 0x28, 0x16, 0xF7, 0x20, 0x7A, 0x82, 0x70, 0x11, 0x30,
  0x10, 0xDA, 0x0E, 0x07, 0x50, 0x10, 0x9B, 0x09, 0x38, 0x34, 0x10, 0x2C, 0xA2, 0x81, 0x8F, 0x62,
  0x05, 0xA2, 0x86, 0x8F, 0xD3, 0x2B, 0xF9, 0x38, 0x48, 0xDF, 0xEC, 0x63,
  // "Ŝ" (U+015C)
  0x60, 0xCA, 0x04, 0x68, 0x3A, 0xF8, 0xEB, 0x58, 0x5A, 0xD3, 0x03, 0xE4, 0x77, 0x85, 0x19, 0xDF,
  0xEC, 0x73, 0x84, 0x2E, 0xF7, 0x27, 0xA0, 0x82, 0x81, 0xBF, 0xA3, 0x81, 0xCF, 0x82, 0x81, 0xDF,
  0xB3, 0x00, 0x53, 0x0C, 0xA0, 0x67, 0x06, 0xB0, 0xC0, 0x36, 0x08, 0xC0, 0x76, 0x04, 0x0D, 0xB0,
  0x32, 0x01, 0x02, 0x30, 0x9A, 0x83, 0x80, 0x5F, 0xA4, 0xA8, 0x39, 0x0B, 0xFE, 0x48, 0x3E, 0xF5,
  0x05, 0xA8, 0x4A, 0x32, 0xAF, 0xB3, 0x85, 0x4B, 0xEF, 0xEC, 0x63,
  // "ŝ" (U+015D)
  0x40, 0xCA, 0x04, 0x48, 0x3A, 0xF8, 0xEB, 0x38, 0x5A, 0xD3, 0x03, 0xE4, 0x74, 0x87, 0x3A, 0xDF,
  0xEA, 0x10, 0x3A, 0x87, 0x74, 0xDF, 0xA0, 0x8F, 0xD2, 0x83, 0x6F, 0x70, 0x7A, 0x82, 0x70, 0x11,
  0x20, 0x10, 0xDA, 0x0E, 0x07, 0x40, 0x10, 0x9B, 0x09, 0x28, 0x34, 0x10, 0x2C, 0xA1, 0x81, 0x8F,
  0x62, 0x05, 0xA1, 0x86, 0x8F, 0xD3, 0x2B, 0xF9, 0x28, 0x48, 0xDF, 0xEC, 0x62,
  // "Ş" (U+015E)
  0x38, 0x51, 0x9D, 0xFE, 0xC7, 0x38, 0x42, 0xEF, 0x72, 0x7A, 0x08, 0x28, 0x1B, 0xFA, 0x38, 0x1C,
  0xF8, 0x28, 0x1D, 0xFB, 0x30, 0x05, 0x30, 0xCA, 0x06, 0x70, 0x6B, 0x0C, 0x03, 0x60, 0x8C, 0x07,
  0x60, 0x40, 0xDB, 0x03, 0x20, 0x10, 0x23, 0x09, 0xA8, 0x38, 0x05, 0xFA, 0x4A, 0x83, 0x90, 0xBF,
  0xE4, 0x83, 0xEF, 0x50, 0x5A, 0x84, 0xA3, 0x2A, 0xFB, 0x38, 0x14, 0xBE, 0xA0, 0xC0, 0x67, 0x81,
  0xAB, 0x27, 0x18, 0x15, 0xED, 0x78, 0x21, 0x3E, 0xD6, 0x06, 0xA0, 0xD0, 0x37, 0x00, 0x26,
  // "ş" (U+015F)
  0x28, 0x73, 0xAD, 0xFE, 0xA1, 0x03, 0xA8, 0x77, 0x4D, 0xFA, 0x08, 0xFD, 0x28, 0x36, 0xF7, 0x07,
  0xA8, 0x27, 0x01, 0x12, 0x01, 0x0D, 0xA0, 0xE0, 0x74, 0x01, 0x09, 0xB0, 0x92, 0x83, 0x41, 0x02,
  0xCA, 0x18, 0x18, 0xF6, 0x20, 0x5A, 0x18, 0x68, 0xFD, 0x32, 0xBF, 0x92, 0x08, 0x0D, 0xA0, 0xC0,
  0x65, 0x81, 0xAB, 0x26, 0x81, 0x5E, 0xD5, 0x82, 0x13, 0xED, 0x40, 0x6A, 0x0D, 0x03, 0x50, 0x02,
  0x50,
  // "Š" (U+0160)
  0x48, 0x54, 0xF4, 0x03, 0xDA, 0x58, 0x3B, 0xE8, 0xFB, 0x60, 0x3A, 0x0C, 0x77, 0x28, 0x51, 0x9D,
  0xFE, 0xC7, 0x38, 0x42, 0xEF, 0x72, 0x7A, 0x08, 0x28, 0x1B, 0xFA, 0x38, 0x1C, 0xF8, 0x28, 0x1D,
  0xFB, 0x30, 0x05, 0x30, 0xCA, 0x06, 0x70, 0x6B, 0x0C, 0x03, 0x60, 0x8C, 0x07, 0x60, 0x40, 0xDB,
  0x03, 0x20, 0x10, 0x23, 0x09, 0xA8, 0x38, 0x05, 0xFA, 0x4A, 0x83, 0x90, 0xBF, 0xE4, 0x83, 0xEF,
  0x50, 0x5A, 0x84, 0xA3, 0x2A, 0xFB, 0x38, 0x54, 0xBE, 0xFE, 0xC6, 0x30,
  // "š" (U+0161)
  0x28, 0x54, 0xF4, 0x03, 0xDA, 0x38, 0x3B, 0xE8, 0xFB, 0x40, 0x3A, 0x0C, 0x76, 0x87, 0x3A, 0xDF,
  0xEA, 0x10, 0x3A, 0x87, 0x74, 0xDF, 0xA0, 0x8F, 0xD2, 0x83, 0x6F, 0x70, 0x7A, 0x82, 0x70, 0x11,
  0x20, 0x10, 0xDA, 0x0E, 0x07, 0x40, 0x10, 0x9B, 0x09, 0x28, 0x34, 0x10, 0x2C, 0xA1, 0x81, 0x8F,
  0x62, 0x05, 0xA1, 0x86, 0x8F, 0xD3, 0x2B, 0xF9, 0x28, 0x48, 0xDF, 0xEC, 0x62,
  // "Ţ" (U+0162)
  0x01, 0xFC, 0x84, 0x24, 0xF9, 0x44, 0xA8, 0x6C, 0x34, 0xBF, 0x08, 0xC2, 0x04, 0xA0, 0x92, 0x83,
  0x7C, 0x06, 0x42, 0x07, 0xA0, 0x52, 0x05, 0x06, 0x50, 0xAA, 0x02, 0x72, 0x81, 0xEF, 0xE7, 0x20,
  0x2A, 0x0B, 0x72, 0x05, 0xA0, 0x77, 0x20, 0x8A, 0x04, 0x72, 0x0C, 0xA7, 0x3A, 0x0C, 0x71, 0x04,
  0x09, 0xA0, 0xD0, 0x47, 0xE0, 0x27, 0x18, 0x1A, 0xB2, 0x73, 0x81, 0x5E, 0xD7, 0x28, 0x21, 0x3E,
  0xD7, 0x10, 0x6A, 0x0D, 0x03, 0x72, 0x00, 0x27, 0x20,
  // "ţ" (U+0163)
  0x40, 0x80, 0xC4, 0x82, 0x3B, 0xF9, 0x30, 0xCD, 0x82, 0x80, 0x3B, 0xA8, 0x15, 0x31, 0x28, 0x1C,
  0xFE, 0x5A, 0x0B, 0x40, 0x3A, 0x08, 0x40, 0x6A, 0x05, 0x40, 0x9A, 0x02, 0x40, 0xBA, 0x50, 0xAA,
  0x81, 0x66, 0x52, 0x84, 0x2D, 0xFD, 0x91, 0x38, 0x1A, 0xB2, 0x58, 0x15, 0xED, 0x48, 0x21, 0x3E,
  0xD3, 0x06, 0xA0, 0xD0, 0x34, 0x00, 0x25,
  // "Ť" (U+0164)
  0x38, 0x54, 0xF4, 0x03, 0xDA, 0x78, 0x3B, 0xE8, 0xFB, 0x71, 0x03, 0xA0, 0xC7, 0x74, 0x01, 0xFC,
  0x84, 0x24, 0xF9, 0x44, 0xA8, 0x6C, 0x34, 0xBF, 0x08, 0xC2, 0x04, 0xA0, 0x92, 0x83, 0x7C, 0x06,
  0x42, 0x07, 0xA0, 0x52, 0x05, 0x06, 0x50, 0xAA, 0x02, 0x72, 0x81, 0xEF, 0xE7, 0x20, 0x2A, 0x0B,
  0x72, 0x05, 0xA0, 0x77, 0x20, 0x8A, 0x04, 0x72, 0x0C, 0xA7, 0x3A, 0x0C, 0x71, 0x04, 0x09, 0xA0,
  0xD0, 0x47, 0xE0, 0x25,
  // "ť" (U+0165)
  0x68, 0x19, 0xF9, 0x48, 0x22, 0x0E, 0xB4, 0x82, 0xAC, 0x5B, 0x38, 0x24, 0xCF, 0x94, 0x0C, 0xD0,
  0x82, 0x03, 0x0B, 0xA8, 0x15, 0x31, 0x38, 0x1C, 0xFE, 0x6A, 0x0B, 0x50, 0x3A, 0x08, 0x50, 0x6A,
  0x05, 0x50, 0x9A, 0x02, 0x50, 0xBA, 0x60, 0xAA, 0x81, 0x66, 0x53, 0x84, 0x2B, 0xFD, 0x91, 0x30,
  // "Ŧ" (U+0166)
  0x01, 0xFC, 0x84, 0x24, 0xF9, 0x44, 0xA8, 0x6C, 0x34, 0xBF, 0x08, 0xC2, 0x04, 0xA0, 0x92, 0x83,
  0x7C, 0x06, 0x42, 0x07, 0xA0, 0x52, 0x04, 0x05, 0x50, 0xBA, 0x02, 0x72, 0x81, 0xEF, 0xE7, 0x0B,
  0xF0, 0x44, 0x81, 0x23, 0x7A, 0x81, 0x93, 0x37, 0x08, 0xA0, 0x47, 0x20, 0xBA, 0x01, 0x72, 0xA0,
  0xD7, 0x10, 0x40, 0x9A, 0x0D, 0x04, 0x7E, 0x02, 0x50,
  // "ŧ" (U+0167)
  0x40, 0x80, 0xC4, 0x82, 0x3B, 0xF9, 0x30, 0xCD, 0x82, 0x80, 0x3A, 0xA8, 0x15, 0x31, 0x20, 0xCA,
  0x58, 0x1E, 0xFC, 0x30, 0x5D, 0x82, 0x90, 0x17, 0xA8, 0x18, 0x31, 0x20, 0x8A, 0x02, 0x40, 0xBA,
  0x50, 0xBA, 0x81, 0x65, 0x42, 0x84, 0x2C, 0xFD, 0x91, 0x10,
  // "Ũ" (U+0168)
  0x68, 0x4B, 0xFB, 0x42, 0xE7, 0x82, 0x99, 0x5C, 0xA0, 0x57, 0x03, 0x30, 0x20, 0x17, 0x74, 0xE8,
  0x13, 0x0D, 0xB8, 0x2D, 0x04, 0xCA, 0x0A, 0x04, 0x28, 0x34, 0xBF, 0x73, 0x20, 0xBA, 0x01, 0x40,
  0x80, 0xC4, 0x81, 0xEF, 0xD5, 0x0C, 0x08, 0x30, 0x2A, 0x0A, 0x59, 0x05, 0x30, 0x5A, 0x06, 0x48,
  0x13, 0xF1, 0x30, 0x9A, 0x03, 0x40, 0x60, 0xE4, 0x0C, 0xA5, 0x00, 0xA4, 0xA0, 0xB5, 0x0D, 0x07,
  0x30, 0x2A, 0x09, 0x48, 0x13, 0xF2, 0x30, 0x2A, 0x0A, 0x40, 0x90, 0xC5, 0x0B, 0xA8, 0x48, 0x45,
  0xAE, 0x26, 0x85, 0x7C, 0xEF, 0xD9, 0x15,
  // "ũ" (U+0169)
  0x48, 0x4B, 0xFB, 0x42, 0xE4, 0x82, 0x99, 0x5C, 0xA0, 0x54, 0x03, 0x30, 0x20, 0x17, 0x60, 0xDB,
  0x06, 0x20, 0x9A, 0x81, 0x14, 0xDA, 0x02, 0x28, 0x1C, 0xFD, 0x28, 0x1C, 0xFE, 0x3A, 0x0A, 0x28,
  0x1E, 0xFB, 0x20, 0x4A, 0x81, 0x70, 0x2A, 0x08, 0x20, 0x8A, 0x81, 0x30, 0x6A, 0x04, 0x20, 0xDA,
  0x20, 0x9A, 0x81, 0x20, 0x5A, 0x0D, 0x20, 0xBA, 0x81, 0x11, 0xBA, 0x0B, 0x20, 0xBA, 0x81, 0xCD,
  0x2A, 0x89, 0x4E, 0x87, 0x4D, 0xFB, 0x20, 0x7E, 0xEA, 0x10,
  // "Ū" (U+016A)
  0x50, 0xCC, 0x06, 0x71, 0x80, 0x13, 0x5E, 0x81, 0x30, 0xDB, 0x82, 0xD0, 0x4C, 0xA0, 0xA0, 0x42,
  0x83, 0x4B, 0xF7, 0x32, 0x0B, 0xA0, 0x14, 0x08, 0x0C, 0x48, 0x1E, 0xFD, 0x50, 0xC0, 0x83, 0x02,
  0xA0, 0xA5, 0x90, 0x53, 0x05, 0xA0, 0x64, 0x81, 0x3F, 0x13, 0x09, 0xA0, 0x34, 0x06, 0x0E, 0x40,
  0xCA, 0x50, 0x0A, 0x4A, 0x0B, 0x50, 0xD0, 0x73, 0x02, 0xA0, 0x94, 0x81, 0x3F, 0x23, 0x02, 0xA0,
  0xA4, 0x09, 0x0C, 0x50, 0xBA, 0x84, 0x84, 0x5A, 0xE2, 0x68, 0x57, 0xCE, 0xFD, 0x91, 0x50,
  // "ū" (U+016B)
  0x40, 0xCC, 0x06, 0x58, 0x01, 0x32, 0x0D, 0xB0, 0x62, 0x09, 0xA8, 0x11, 0x4D, 0xA0, 0x22, 0x81,
  0xCF, 0xD2, 0x81, 0xCF, 0xE3, 0xA0, 0xA2, 0x81, 0xEF, 0xB2, 0x04, 0xA8, 0x17, 0x02, 0xA0, 0x82,
  0x08, 0xA8, 0x13, 0x06, 0xA0, 0x42, 0x0D, 0xA2, 0x09, 0xA8, 0x12, 0x05, 0xA0, 0xD2, 0x0B, 0xA8,
  0x11, 0x1B, 0xA0, 0xB2, 0x0B, 0xA8, 0x1C, 0xD2, 0xA8, 0x94, 0xE8, 0x74, 0xDF, 0xB2, 0x07, 0xEE,
  0xA1,
  // "Ŭ" (U+016C)
  0x50, 0x30, 0xA3, 0x0B, 0x01, 0x78, 0x41, 0xF5, 0x18, 0xB7, 0x20, 0x7A, 0x0C, 0x01, 0x73, 0x01,
  0x02, 0x77, 0x6E, 0x81, 0x30, 0xDB, 0x82, 0xD0, 0x4C, 0xA0, 0xA0, 0x42, 0x83, 0x4B, 0xF7, 0x32,
  0x0B, 0xA0, 0x14, 0x08, 0x0C, 0x48, 0x1E, 0xFD, 0x50, 0xC0, 0x83, 0x02, 0xA0, 0xA5, 0x90, 0x53,
  0x05, 0xA0, 0x64, 0x81, 0x3F, 0x13, 0x09, 0xA0, 0x34, 0x06, 0x0E, 0x40, 0xCA, 0x50, 0x0A, 0x4A,
  0x0B, 0x50, 0xD0, 0x73, 0x02, 0xA0, 0x94, 0x81, 0x3F, 0x23, 0x02, 0xA0, 0xA4, 0x09, 0x0C, 0x50,
  0xBA, 0x84, 0x84, 0x5A, 0xE2, 0x68, 0x57, 0xCE, 0xFD, 0x91, 0x50,
  // "ŭ" (U+016D)
  0x30, 0x30, 0xA3, 0x0B, 0x01, 0x48, 0x41, 0xF5, 0x18, 0xB6, 0x07, 0xA0, 0xC0, 0x17, 0x01, 0x02,
  0x77, 0x10, 0xDB, 0x06, 0x20, 0x9A, 0x81, 0x14, 0xDA, 0x02, 0x28, 0x1C, 0xFD, 0x28, 0x1C, 0xFE,
  0x3A, 0x0A, 0x28, 0x1E, 0xFB, 0x20, 0x4A, 0x81, 0x70, 0x2A, 0x08, 0x20, 0x8A, 0x81, 0x30, 0x6A,
  0x04, 0x20, 0xDA, 0x20, 0x9A, 0x81, 0x20, 0x5A, 0x0D, 0x20, 0xBA, 0x81, 0x11, 0xBA, 0x0B, 0x20,
  0xBA, 0x81, 0xCD, 0x2A, 0x89, 0x4E, 0x87, 0x4D, 0xFB, 0x20, 0x7E, 0xEA, 0x10,
  // "Ů" (U+016E)
  0x68, 0x2B, 0xFC, 0x27, 0x28, 0x37, 0xC4, 0xA9, 0x72, 0x83, 0x7A, 0x18, 0xA7, 0x28, 0x31, 0xDF,
  0xE3, 0x74, 0x02, 0x7E, 0x81, 0x30, 0xDB, 0x82, 0xD0, 0x4C, 0xA0, 0xA0, 0x42, 0x83, 0x4B, 0xF7,
  0x32, 0x0B, 0xA0, 0x14, 0x08, 0x0C, 0x48, 0x1E, 0xFD, 0x50, 0xC0, 0x83, 0x02, 0xA0, 0xA5, 0x90,
  0x53, 0x05, 0xA0, 0x64, 0x81, 0x3F, 0x13, 0x09, 0xA0, 0x34, 0x06, 0x0E, 0x40, 0xCA, 0x50, 0x0A,
  0x4A, 0x0B, 0x50, 0xD0, 0x73, 0x02, 0xA0, 0x94, 0x81, 0x3F, 0x23, 0x02, 0xA0, 0xA4, 0x09, 0x0C,
  0x50, 0xBA, 0x84, 0x84, 0x5A, 0xE2, 0x68, 0x57, 0xCE, 0xFD, 0x91, 0x50,
  // "ů" (U+016F)
  0x48, 0x2B, 0xFC, 0x26, 0x83, 0x7C, 0x4A, 0x96, 0x83, 0x7A, 0x18, 0xA6, 0x83, 0x1D, 0xFE, 0x37,
  0x10, 0x25, 0x0D, 0xB0, 0x62, 0x09, 0xA8, 0x11, 0x4D, 0xA0, 0x22, 0x81, 0xCF, 0xD2, 0x81, 0xCF,
  0xE3, 0xA0, 0xA2, 0x81, 0xEF, 0xB2, 0x04, 0xA8, 0x17, 0x02, 0xA0, 0x82, 0x08, 0xA8, 0x13, 0x06,
  0xA0, 0x42, 0x0D, 0xA2, 0x09, 0xA8, 0x12, 0x05, 0xA0, 0xD2, 0x0B, 0xA8, 0x11, 0x1B, 0xA0, 0xB2,
  0x0B, 0xA8, 0x1C, 0xD2, 0xA8, 0x94, 0xE8, 0x74, 0xDF, 0xB2, 0x07, 0xEE, 0xA1,
  // "Ű" (U+0170)
  0x68, 0x54, 0xEC, 0x1C, 0xE5, 0x68, 0x51, 0xDD, 0x28, 0xF6, 0x78, 0x4B, 0xB1, 0x4E, 0x47, 0x74,
  0xE8, 0x13, 0x0D, 0xB8, 0x2D, 0x04, 0xCA, 0x0A, 0x04, 0x28, 0x34, 0xBF, 0x73, 0x20, 0xBA, 0x01,
  0x40, 0x80, 0xC4, 0x81, 0xEF, 0xD5, 0x0C, 0x08, 0x30, 0x2A, 0x0A, 0x59, 0x05, 0x30, 0x5A, 0x06,
  0x48, 0x13, 0xF1, 0x30, 0x9A, 0x03, 0x40, 0x60, 0xE4, 0x0C, 0xA5, 0x00, 0xA4, 0xA0, 0xB5, 0x0D,
  0x07, 0x30, 0x2A, 0x09, 0x48, 0x13, 0xF2, 0x30, 0x2A, 0x0A, 0x40, 0x90, 0xC5, 0x0B, 0xA8, 0x48,
  0x45, 0xAE, 0x26, 0x85, 0x7C, 0xEF, 0xD9, 0x15,
  // "ű" (U+0171)
  0x58, 0x54, 0xEC, 0x1C, 0xE5, 0x48, 0x51, 0xDD, 0x28, 0xF6, 0x58, 0x4B, 0xB1, 0x4E, 0x47, 0x70,
  0xDB, 0x06, 0x20, 0x9A, 0x82, 0x10, 0x4D, 0xA0, 0x22, 0x81, 0xCF, 0xD3, 0x81, 0xCF, 0xE3, 0xA0,
  0xA3, 0x81, 0xEF, 0xB2, 0x04, 0xA0, 0x72, 0x02, 0xA0, 0x82, 0x08, 0xA0, 0x32, 0x06, 0xA0, 0x42,
  0x0D, 0xA3, 0x09, 0xA8, 0x12, 0x05, 0xA0, 0xD3, 0x0B, 0xA8, 0x11, 0x1B, 0xA0, 0xB3, 0x0B, 0xA8,
  0x1C, 0xD2, 0xA8, 0x95, 0xE8, 0x70, 0x4D, 0xFB, 0x20, 0x7E, 0xEA, 0x11,
  // "Ų" (U+0172)
  0x1E, 0x81, 0x30, 0xDB, 0x82, 0xD0, 0x4C, 0xA0, 0xA0, 0x42, 0x83, 0x4B, 0xF7, 0x32, 0x0B, 0xA0,
  0x14, 0x08, 0x0C, 0x48, 0x1E, 0xFD, 0x50, 0xC0, 0x83, 0x02, 0xA0, 0xA5, 0x90, 0x53, 0x05, 0xA0,
  0x64, 0x81, 0x3F, 0x13, 0x09, 0xA0, 0x34, 0x06, 0x0E, 0x40, 0xCA, 0x50, 0x0A, 0x4A, 0x0B, 0x50,
  0xD0, 0x73, 0x02, 0xA0, 0x94, 0x81, 0x3F, 0x23, 0x02, 0xA0, 0xA4, 0x09, 0x0C, 0x50, 0xBA, 0x84,
  0x84, 0x5A, 0xE2, 0x68, 0x17, 0xCE, 0xA0, 0x90, 0x17, 0x28, 0x1A, 0xC1, 0x73, 0x81, 0x9F, 0x37,
  0x48, 0x2B, 0xF5, 0x17, 0x30, 0x5B, 0x02, 0x73, 0x81, 0x13, 0x17,
  // "ų" (U+0173)
  0x0D, 0xB0, 0x62, 0x09, 0xA8, 0x11, 0x4D, 0xA0, 0x22, 0x81, 0xCF, 0xD2, 0x81, 0xCF, 0xE3, 0xA0,
  0xA2, 0x81, 0xEF, 0xB2, 0x04, 0xA8, 0x17, 0x02, 0xA0, 0x82, 0x08, 0xA8, 0x13, 0x06, 0xA0, 0x42,
  0x0D, 0xA2, 0x09, 0xA8, 0x12, 0x05, 0xA0, 0xD2, 0x0B, 0xA8, 0x11, 0x1B, 0xA0, 0xB2, 0x0B, 0xA8,
  0x1C, 0xD2, 0xA8, 0x90, 0xE8, 0x74, 0xDF, 0xB2, 0x07, 0xA0, 0xA0, 0x16, 0x81, 0xAC, 0x17, 0x81,
  0x9F, 0x37, 0x18, 0x2B, 0xF5, 0x17, 0x05, 0xB0, 0x27, 0x81, 0x13, 0x12,
  // "Ŵ" (U+0174)
  0x73, 0x0C, 0xA0, 0x47, 0x71, 0x83, 0xAF, 0x8E, 0xB7, 0x78, 0x5A, 0xD3, 0x03, 0xE4, 0x77, 0x74,
  0x05, 0xD0, 0x82, 0x81, 0x1E, 0x93, 0x0B, 0xB8, 0x1E, 0x17, 0xA8, 0x1E, 0x51, 0x28, 0x17, 0xFC,
  0x38, 0x33, 0xAF, 0x93, 0x2A, 0x0C, 0x38, 0x21, 0xEF, 0xE4, 0x0A, 0x0D, 0x48, 0x1E, 0xFD, 0x30,
  0x8B, 0x01, 0x28, 0x12, 0xF5, 0x48, 0x1D, 0xFE, 0x28, 0x11, 0xEE, 0xA0, 0x32, 0x09, 0x0D, 0x50,
  0xCA, 0x28, 0x18, 0xE6, 0xA8, 0x35, 0x01, 0xF6, 0x50, 0xAA, 0x83, 0x11, 0xE7, 0x3A, 0x82, 0x70,
  0x8D, 0x60, 0x9A, 0x83, 0x28, 0xE0, 0x1A, 0x82, 0x90, 0xE6, 0x60, 0x7A, 0x81, 0x4E, 0x72, 0x83,
  0xEF, 0xB6, 0xE7, 0x06, 0xA0, 0xB0, 0xD3, 0x83, 0xCF, 0xDD, 0x77, 0x05, 0xB0, 0x63, 0x09, 0xA0,
  0xE7, 0x10, 0x3A, 0x0D, 0x40, 0x7A, 0x07, 0x71, 0x02, 0xA0, 0x54, 0x82, 0x5F, 0xE1, 0x60,
  // "ŵ" (U+0175)
  0x71, 0x0C, 0xA0, 0x47, 0x48, 0x3A, 0xF8, 0xEB, 0x73, 0x85, 0xAD, 0x30, 0x3E, 0x47, 0x75, 0x02,
  0xB0, 0x63, 0x81, 0xEF, 0x72, 0x83, 0xCD, 0x11, 0x8A, 0x07, 0x20, 0x5A, 0x84, 0x80, 0x1D, 0xF4,
  0x2A, 0x08, 0x20, 0xCA, 0x09, 0x28, 0x16, 0xF3, 0x28, 0x7E, 0xF8, 0x02, 0xEB, 0xFA, 0x20, 0x70,
  0xE3, 0x87, 0xEF, 0x90, 0x98, 0xAF, 0xA2, 0x0C, 0x08, 0x38, 0x93, 0xEF, 0x91, 0xE1, 0xAF, 0xB0,
  0x4E, 0x13, 0x89, 0x2D, 0xF9, 0x88, 0x09, 0xFC, 0x0D, 0x54, 0x89, 0x1D, 0xFC, 0xE1, 0x09, 0xFC,
  0xA9, 0x50, 0xDA, 0x07, 0x20, 0x9A, 0x0C, 0x68, 0x1C, 0xFC, 0x38, 0x29, 0xFD, 0x17, 0x50, 0x01,
  0x60,
  // "Ŷ" (U+0176)
  0x60, 0xCA, 0x04, 0x72, 0x83, 0xAF, 0x8E, 0xB7, 0x18, 0x5A, 0xD3, 0x03, 0xE4, 0x77, 0x30, 0x4D,
  0x81, 0x80, 0x8C, 0x81, 0x21, 0x8A, 0x87, 0xE4, 0x10, 0x28, 0xFD, 0x53, 0x0E, 0xA4, 0x81, 0x7E,
  0x24, 0x0A, 0xA0, 0x32, 0x81, 0x2E, 0x55, 0x05, 0xA0, 0x72, 0x0C, 0x08, 0x60, 0x1A, 0x82, 0xC0,
  0x9C, 0x71, 0x0B, 0xA8, 0x14, 0xE2, 0x71, 0x06, 0xA0, 0xE0, 0x47, 0x20, 0x3A, 0x0A, 0x73, 0x06,
  0xA0, 0x67, 0x30, 0xAA, 0x03, 0x71, 0x81, 0x36, 0xEA, 0x06, 0x03, 0x70, 0xED, 0x0B, 0x60,
  // "ŷ" (U+0177)
  0x71, 0x0C, 0xA0, 0x47, 0x18, 0x3A, 0xF8, 0xEB, 0x78, 0x5A, 0xD3, 0x03, 0xE4, 0x77, 0x20, 0xDA,
  0x0D, 0x38, 0x17, 0xE8, 0x30, 0x50, 0xDA, 0x01, 0x28, 0x1A, 0xFE, 0x40, 0x7A, 0x05, 0x30, 0xD0,
  0xC4, 0x03, 0xA0, 0x93, 0x0E, 0x08, 0x58, 0x1E, 0xFD, 0x28, 0x14, 0xF1, 0x50, 0xAA, 0x82, 0x10,
  0xC8, 0x60, 0x5A, 0x81, 0x46, 0xD7, 0x01, 0xA8, 0x19, 0xE4, 0x71, 0x0C, 0xA0, 0x97, 0x28, 0x17,
  0xFC, 0x73, 0x81, 0xBE, 0x27, 0x18, 0x21, 0xBF, 0x45, 0x0F, 0x48, 0x28, 0xEE, 0x46, 0x84, 0xCF,
  0xEC, 0x81, 0x70,
  // "Ÿ" (U+0178)
  0x58, 0x56, 0xB2, 0x06, 0xC2, 0x78, 0x5D, 0xF5, 0x0D, 0xF6, 0x78, 0x59, 0xE2, 0x09, 0xE2, 0x77,
  0x20, 0x4D, 0x81, 0x80, 0x8C, 0x81, 0x21, 0x8A, 0x87, 0xE4, 0x10, 0x28, 0xFD, 0x53, 0x0E, 0xA4,
  0x81, 0x7E, 0x24, 0x0A, 0xA0, 0x32, 0x81, 0x2E, 0x55, 0x05, 0xA0, 0x72, 0x0C, 0x08, 0x60, 0x1A,
  0x82, 0xC0, 0x9C, 0x71, 0x0B, 0xA8, 0x14, 0xE2, 0x71, 0x06, 0xA0, 0xE0, 0x47, 0x20, 0x3A, 0x0A,
  0x73, 0x06, 0xA0, 0x67, 0x30, 0xAA, 0x03, 0x71, 0x81, 0x36, 0xEA, 0x06, 0x03, 0x70, 0xED, 0x0B,
  0x60,
  // "Ź" (U+0179)
  0x71, 0x02, 0xA0, 0xA7, 0x28, 0x1C, 0xF7, 0x72, 0x81, 0xAC, 0x37, 0x75, 0xFA, 0x09, 0x28, 0x53,
  0xF9, 0x21, 0x16, 0xA0, 0xE0, 0x12, 0x07, 0x0D, 0x30, 0x20, 0xEA, 0x03, 0x30, 0x07, 0x20, 0x10,
  0xDA, 0x06, 0x71, 0x0B, 0xA0, 0x97, 0x10, 0x8A, 0x0C, 0x71, 0x05, 0xA0, 0xD0, 0x17, 0x03, 0x0E,
  0xA0, 0x37, 0x01, 0x0D, 0xA0, 0x57, 0x10, 0xBA, 0x08, 0x38, 0x12, 0xB1, 0x20, 0x9A, 0x0B, 0x40,
  0x80, 0xD2, 0x06, 0xA8, 0x6E, 0x21, 0x12, 0x6F, 0xA2, 0x0E, 0xFA, 0x06, 0x20,
  // "ź" (U+017A)
  0x60, 0x2A, 0x0A, 0x68, 0x1C, 0xF7, 0x68, 0x1A, 0xC3, 0x76, 0x04, 0xF8, 0x57, 0x08, 0xE5, 0x35,
  0xA8, 0x3D, 0x10, 0xC6, 0x20, 0xBA, 0x03, 0x50, 0x8A, 0x06, 0x50, 0x4A, 0x0A, 0x58, 0x22, 0xEF,
  0xD6, 0x82, 0xCF, 0xE2, 0x20, 0x52, 0x09, 0xA0, 0x52, 0x82, 0x5D, 0x05, 0xA8, 0x6B, 0x33, 0x5E,
  0x90, 0xDF, 0x06, 0x10,
  // "Ż" (U+017B)
  0x68, 0x22, 0xBB, 0x27, 0x20, 0x8A, 0x06, 0x72, 0x82, 0x5E, 0xC1, 0x77, 0x5F, 0xA0, 0x92, 0x85,
  0x3F, 0x92, 0x11, 0x6A, 0x0E, 0x01, 0x20, 0x70, 0xD3, 0x02, 0x0E, 0xA0, 0x33, 0x00, 0x72, 0x01,
  0x0D, 0xA0, 0x67, 0x10, 0xBA, 0x09, 0x71, 0x08, 0xA0, 0xC7, 0x10, 0x5A, 0x0D, 0x01, 0x70, 0x30,
  0xEA, 0x03, 0x70, 0x10, 0xDA, 0x05, 0x71, 0x0B, 0xA0, 0x83, 0x81, 0x2B, 0x12, 0x09, 0xA0, 0xB4,
  0x08, 0x0D, 0x20, 0x6A, 0x86, 0xE2, 0x11, 0x26, 0xFA, 0x20, 0xEF, 0xA0, 0x62,
  // "ż" (U+017C)
  0x48, 0x22, 0xBB, 0x26, 0x08, 0xA0, 0x66, 0x82, 0x5E, 0xC1, 0x76, 0x04, 0xF8, 0x57, 0x08, 0xE5,
  0x35, 0xA8, 0x3D, 0x10, 0xC6, 0x20, 0xBA, 0x03, 0x50, 0x8A, 0x06, 0x50, 0x4A, 0x0A, 0x58, 0x22,
  0xEF, 0xD6, 0x82, 0xCF, 0xE2, 0x20, 0x52, 0x09, 0xA0, 0x52, 0x82, 0x5D, 0x05, 0xA8, 0x6B, 0x33,
  0x5E, 0x90, 0xDF, 0x06, 0x10,
  // "Ž" (U+017D)
  0x58, 0x54, 0xF4, 0x03, 0xDA, 0x78, 0x3B, 0xE8, 0xFB, 0x71, 0x03, 0xA0, 0xC7, 0x75, 0xFA, 0x09,
  0x28, 0x53, 0xF9, 0x21, 0x16, 0xA0, 0xE0, 0x12, 0x07, 0x0D, 0x30, 0x20, 0xEA, 0x03, 0x30, 0x07,
  0x20, 0x10, 0xDA, 0x06, 0x71, 0x0B, 0xA0, 0x97, 0x10, 0x8A, 0x0C, 0x71, 0x05, 0xA0, 0xD0, 0x17,
  0x03, 0x0E, 0xA0, 0x37, 0x01, 0x0D, 0xA0, 0x57, 0x10, 0xBA, 0x08, 0x38, 0x12, 0xB1, 0x20, 0x9A,
  0x0B, 0x40, 0x80, 0xD2, 0x06, 0xA8, 0x6E, 0x21, 0x12, 0x6F, 0xA2, 0x0E, 0xFA, 0x06, 0x20,
  // "ž" (U+017E)
  0x38, 0x54, 0xF4, 0x03, 0xDA, 0x48, 0x3B, 0xE8, 0xFB, 0x50, 0x3A, 0x0C, 0x76, 0x04, 0xF8, 0x57,
  0x08, 0xE5, 0x35, 0xA8, 0x3D, 0x10, 0xC6, 0x20, 0xBA, 0x03, 0x50, 0x8A, 0x06, 0x50, 0x4A, 0x0A,
  0x58, 0x22, 0xEF, 0xD6, 0x82, 0xCF, 0xE2, 0x20, 0x52, 0x09, 0xA0, 0x52, 0x82, 0x5D, 0x05, 0xA8,
  0x6B, 0x33, 0x5E, 0x90, 0xDF, 0x06, 0x10,
  // "ſ" (U+017F)
  0x78, 0x42, 0xAD, 0xFD, 0x67, 0x83, 0x2E, 0xFA, 0x6A, 0x01, 0x60, 0x9A, 0x82, 0x10, 0xD9, 0x78,
  0x1E, 0xFC, 0x73, 0x02, 0xA0, 0x97, 0x30, 0x6A, 0x05, 0x73, 0x09, 0xA0, 0x27, 0x38, 0x1C, 0xFE,
  0x74, 0xA0, 0xB7, 0x30, 0x4A, 0x07, 0x73, 0x07, 0xA0, 0x47, 0x30, 0xBA, 0x01, 0x73, 0x81, 0xEF,
  0xD7, 0x30, 0x2A, 0x09, 0x73, 0x06, 0xA0, 0x57, 0x38, 0x1B, 0xFD, 0x71, 0x84, 0x14, 0x8F, 0xE3,
  0x71, 0x83, 0x6F, 0xDA, 0x27, 0x20,
  // "Ω" (U+03A9)
  0x58, 0x16, 0xBD, 0xA8, 0x1D, 0x92, 0x58, 0x91, 0x3D, 0xFD, 0x64, 0x6E, 0xFE, 0x33, 0x82, 0x2E,
  0xFD, 0x40, 0x3A, 0x0D, 0x30, 0xAA, 0x05, 0x50, 0xEA, 0x81, 0x10, 0x1B, 0x60, 0xEA, 0x81, 0x10,
  0x3A, 0x0D, 0x50, 0x1A, 0x0D, 0x20, 0x1A, 0x0C, 0x50, 0x6A, 0x07, 0x30, 0xBA, 0x01, 0x38, 0x21,
  0xEF, 0xC4, 0x89, 0x02, 0xCF, 0xC2, 0x06, 0xDF, 0x93, 0x06, 0x03, 0x28, 0x93, 0x5E, 0x43, 0xE6,
  0x10, 0x63, 0x0A, 0x93, 0x98, 0x11, 0x79, 0x28, 0x33, 0xE3, 0x0C, 0xA8, 0x3E, 0xED, 0x0B, 0x0F,
  0xEA, 0x20, 0xDC, 0x81, 0xA0, 0xEC, 0x0C, 0x20,
  // "μ" (U+03BC)
  0x20, 0x4A, 0x06, 0x20, 0x8A, 0x02, 0x20, 0x8A, 0x03, 0x28, 0x1C, 0xFE, 0x30, 0xBA, 0x3A, 0x0B,
  0x38, 0x1E, 0xFC, 0x20, 0x3A, 0x08, 0x20, 0x2A, 0x09, 0x20, 0x6A, 0x05, 0x20, 0x5A, 0x05, 0x20,
  0xAA, 0x01, 0x20, 0x9A, 0x03, 0x28, 0x1E, 0xFE, 0x30, 0xCA, 0x81, 0x30, 0x6A, 0x0C, 0x28, 0x61,
  0xFE, 0xFC, 0x9B, 0xCA, 0x89, 0x69, 0x85, 0xF3, 0xDE, 0xA0, 0x5E, 0xEB, 0x2A, 0xD7, 0x30, 0xD0,
  0xE7, 0x3A, 0x0B, 0x01, 0x71, 0x81, 0xBE, 0x97, 0x20,
  // "π" (U+03C0)
  0x20, 0x70, 0xDF, 0x81, 0xD0, 0x7F, 0xA8, 0xA0, 0x90, 0xD8, 0x5F, 0x32, 0x2C, 0x92, 0x10, 0x50,
  0x7D, 0x28, 0x11, 0xF5, 0x50, 0xB0, 0xA2, 0x81, 0x5F, 0x34, 0x81, 0x1F, 0x72, 0x81, 0x8F, 0x14,
  0x81, 0x6F, 0x32, 0x0C, 0x0E, 0x50, 0xC0, 0xE3, 0x0E, 0x0D, 0x38, 0x25, 0xBF, 0x93, 0xA8, 0x58,
  0x50, 0x9E, 0xB1, 0x38, 0x28, 0xED, 0x51,
  // "–" (U+2013)
  0x01, 0xFA, 0x02, 0x18, 0x05, 0x31,
  // "—" (U+2014)
  0x01, 0xFF, 0xC0, 0x21, 0x80, 0x96, 0x31,
  // "€" (U+20AC)
  0x58, 0x46, 0xCE, 0xEB, 0x24, 0x85, 0xBF, 0x94, 0xDF, 0xD3, 0x81, 0xAF, 0xB2, 0x81, 0x8F, 0xD2,
  0x03, 0xA0, 0x32, 0x81, 0x49, 0x22, 0x81, 0xBF, 0xD7, 0xE0, 0xE4, 0x07, 0xA8, 0x27, 0x33, 0x23,
  0x07, 0xD0, 0xC4, 0x02, 0x0A, 0xA8, 0x14, 0x32, 0x50, 0x8A, 0x01, 0x70, 0x5A, 0x05, 0x30, 0x54,
  0x85, 0xCF, 0xE6, 0x49, 0xC4, 0x85, 0x18, 0xDF, 0xE9, 0x12,
  // "₿" (U+20BF)
  0x68, 0x23, 0x42, 0x47, 0x82, 0x96, 0x87, 0x30, 0x2E, 0x0A, 0x40, 0x5A, 0x83, 0xA5, 0xEF, 0xA4,
  0xA8, 0x16, 0x08, 0xA3, 0x04, 0xA8, 0x13, 0x06, 0xA3, 0x07, 0xA2, 0x81, 0x9F, 0xC3, 0x86, 0xBF,
  0xC1, 0x5F, 0xE3, 0x30, 0xEC, 0x0D, 0x02, 0x30, 0x2A, 0x83, 0x84, 0xBF, 0xC3, 0x05, 0xA8, 0x12,
  0x02, 0xA0, 0x42, 0x81, 0x9F, 0xE2, 0x02, 0xA0, 0x42, 0x81, 0xCF, 0xA2, 0x06, 0xA8, 0x11, 0x27,
  0xA8, 0x69, 0x47, 0xEF, 0x70, 0xAE, 0x0B, 0x05, 0x58, 0x28, 0x67, 0x87, 0x82, 0x52, 0x42, 0x40,
  // "‘" (U+2018)
  0x00, 0x15, 0x07, 0xD6, 0x5F, 0x10, 0xCF, 0x40, 0xEF, 0xD0, 0x7E, 0x90,
  // "’" (U+2019)
  0x02, 0xDD, 0x20, 0x4F, 0xF7, 0x00, 0xAF, 0x50, 0x08, 0xD0, 0x1A, 0xC2, 0x02, 0x40, 0x00,
  // "‚" (U+201A)
  0x01, 0xCD, 0x30, 0x3F, 0xF9, 0x00, 0x9F, 0x70, 0x06, 0xE1, 0x19, 0xD3, 0x02, 0x40, 0x00,
  // "‛" (U+201B)
  0x1B, 0xE4, 0x8F, 0xF6, 0xAF, 0x70, 0x8C, 0x00, 0x1D, 0x90, 0x01, 0x60,
  // "“" (U+201C)
  0x00, 0x15, 0x00, 0x24, 0x07, 0xD6, 0x09, 0xC4, 0x5F, 0x10, 0x9D, 0x00, 0xCF, 0x40, 0xFE, 0x10,
  0xEF, 0xD2, 0xFF, 0x90, 0x7E, 0x90, 0xAE, 0x50,
  // "”" (U+201D)
  0x02, 0xDD, 0x25, 0xEB, 0x00, 0x4F, 0xF7, 0x8F, 0xF3, 0x00, 0xAF, 0x51, 0xDF, 0x10, 0x08, 0xD0,
  0x0C, 0xA0, 0x1A, 0xC2, 0x3B, 0xA1, 0x02, 0x40, 0x04, 0x30, 0x00,
  // "„" (U+201E)
  0x00, 0xBE, 0x42, 0xDD, 0x20, 0x1F, 0xFB, 0x5F, 0xF7, 0x00, 0x7F, 0x90, 0xBF, 0x50, 0x04, 0xF3,
  0x08, 0xD0, 0x08, 0xD4, 0x1A, 0xC2, 0x01, 0x50, 0x02, 0x40, 0x00,
  // "‟" (U+201F)
  0x1B, 0xE4, 0x1B, 0xE4, 0x8F, 0xF6, 0x8F, 0xF6, 0xAF, 0x70, 0xAF, 0x70, 0x8C, 0x00, 0x8C, 0x00,
  0x1D, 0x90, 0x1D, 0x90, 0x01, 0x60, 0x01, 0x60,
  // "†" (U+2020)
  0x48, 0x1D, 0xF3, 0x60, 0x0D, 0x70, 0xE0, 0x73, 0x89, 0x01, 0x52, 0x0F, 0x22, 0x41, 0x5F, 0x18,
  0x65, 0x85, 0xAC, 0x57, 0x83, 0x81, 0x1E, 0xE6, 0x81, 0x8F, 0xE6, 0x81, 0x8F, 0x96, 0x81, 0x9F,
  0x36, 0x0A, 0x0D, 0x70, 0xC0, 0x97, 0x0E, 0x04, 0x60, 0x19, 0x70, 0x40, 0xC7, 0x06, 0x08, 0x60,
  // "‡" (U+2021)
  0x68, 0x1D, 0xF2, 0x71, 0x0D, 0x0B, 0x68, 0x66, 0x42, 0xD6, 0x35, 0x22, 0x02, 0xF0, 0x32, 0x86,
  0x27, 0x47, 0xE3, 0x58, 0x68, 0x1D, 0xF2, 0x78, 0x21, 0xEC, 0x17, 0x10, 0xB0, 0x27, 0x20, 0xD7,
  0x28, 0x19, 0xF3, 0x71, 0xA0, 0x25, 0x86, 0x65, 0x2C, 0x93, 0x53, 0x3F, 0x05, 0x28, 0x71, 0x75,
  0x5F, 0x35, 0x71, 0x50, 0x89, 0x72, 0x0E, 0x96,
  // "•" (U+2022)
  0x18, 0x45, 0xDE, 0x90, 0x2C, 0x06, 0x07, 0xC0, 0x90, 0x8C, 0x09, 0x05, 0xC8, 0x44, 0x09, 0xEE,
  0x71,
  // "…" (U+2026)
  0x08, 0xC4, 0x00, 0x3C, 0x90, 0x00, 0x9C, 0x31, 0xFF, 0x90, 0x09, 0xFF, 0x10, 0x1F, 0xF8, 0x0C,
  0xE4, 0x00, 0x5E, 0xA0, 0x00, 0xCE, 0x30,
  // "‰" (U+2030)
  0x28, 0x35, 0xDE, 0xC2, 0x38, 0x13, 0xE2, 0x73, 0x84, 0x6F, 0xA5, 0xFC, 0x30, 0xD0, 0x77, 0x48,
  0x3E, 0xE1, 0x0D, 0x92, 0x08, 0x0C, 0x74, 0x81, 0x5F, 0x92, 0x84, 0xEE, 0x04, 0xE2, 0x74, 0x89,
  0x08, 0xF5, 0x02, 0xFB, 0x0D, 0x67, 0x58, 0x94, 0xAF, 0x30, 0x7F, 0x69, 0xB2, 0xBF, 0xE8, 0x38,
  0xB3, 0x8E, 0xFB, 0x18, 0xF7, 0x3E, 0xC5, 0xE3, 0xDE, 0x5A, 0xF4, 0x0A, 0xF8, 0x6F, 0x91, 0xCA,
  0x8A, 0x0B, 0x3E, 0x58, 0xF6, 0x05, 0xF7, 0x3F, 0xB0, 0x1F, 0xC2, 0x85, 0x21, 0x0A, 0xA0, 0xE9,
  0x28, 0x90, 0x7F, 0x69, 0xF5, 0x02, 0xFA, 0x48, 0x45, 0xE1, 0x1F, 0xC2, 0x89, 0x0B, 0xF3, 0xCF,
  0x10, 0x6F, 0x83, 0x89, 0x31, 0xE5, 0x03, 0xFB, 0x02, 0xFC, 0x0D, 0x92, 0x81, 0xCF, 0x23, 0x0B,
  0x0A, 0x38, 0x93, 0xEE, 0x4C, 0xF3, 0x0A, 0xF7, 0x8F, 0x83, 0x81, 0x6D, 0x13, 0x83, 0x4D, 0xEB,
  0x32, 0x83, 0x1B, 0xED, 0x62,
  // "‹" (U+2039)
  0x00, 0x04, 0x50, 0x06, 0xF4, 0x07, 0xF8, 0x07, 0xFD, 0x00, 0xCF, 0x70, 0x05, 0xFA, 0x00, 0x0B,
  0xE0, 0x00, 0x2F, 0x40,
  // "›" (U+203A)
  0x20, 0x70, 0x24, 0x00, 0xC4, 0x81, 0x8F, 0x53, 0x81, 0x3F, 0xE3, 0x03, 0xA0, 0x12, 0x81, 0xCF,
  0x62, 0x81, 0x8F, 0x52, 0x81, 0x4E, 0x43,
  // "⁄" (U+2044)
  0x71, 0x81, 0x1E, 0x87, 0x10, 0xA0, 0xC7, 0x18, 0x16, 0xE2, 0x78, 0x12, 0xE6, 0x71, 0x0C, 0x0B,
  0x71, 0x81, 0x7E, 0x17, 0x81, 0x3F, 0x57, 0x10, 0xD0, 0x97, 0x10, 0x90, 0xD7, 0x18, 0x14, 0xF3,
  0x78, 0x11, 0xE8, 0x71, 0x0B, 0x0C, 0x71, 0x81, 0x6E, 0x27, 0x10,
  // "™" (U+2122)
  0xB9, 0xC9, 0xB6, 0xBA, 0x00, 0x05, 0xC5, 0x70, 0xF2, 0x43, 0x8E, 0x20, 0x0B, 0xC0, 0x00, 0xF2,
  0x00, 0x89, 0x80, 0x39, 0xC0, 0x00, 0xF2, 0x00, 0x83, 0xD0, 0x84, 0xC0, 0x00, 0xF2, 0x00, 0x80,
  0xB5, 0x83, 0xC0, 0x00, 0xF2, 0x00, 0x80, 0x5E, 0x34, 0xD0, 0x07, 0xB9, 0x03, 0xA7, 0x09, 0x09,
  0xB5,
  // "⅒" (U+2152)
  0x40, 0x01, 0x77, 0x48, 0x18, 0xF8, 0x48, 0x11, 0xE8, 0x72, 0x83, 0x4D, 0xBF, 0x54, 0x0A, 0x0C,
  0x73, 0x83, 0x12, 0xAF, 0x13, 0x81, 0x6E, 0x27, 0x50, 0xD0, 0xE3, 0x81, 0x2E, 0x67, 0x58, 0x11,
  0xFB, 0x30, 0xC0, 0xB2, 0x00, 0x17, 0x28, 0x14, 0xF7, 0x28, 0x57, 0xE1, 0x08, 0xF8, 0x28, 0x31,
  0x9C, 0xB3, 0x28, 0xC5, 0x8F, 0x50, 0x3F, 0x54, 0xDB, 0xF5, 0x01, 0xDB, 0x0B, 0xD5, 0xCD, 0xDD,
  0x9D, 0x90, 0x12, 0xAF, 0x10, 0x8F, 0x30, 0xB9, 0x50, 0x90, 0xD4, 0x0D, 0x0E, 0x20, 0xE0, 0xD2,
  0x0D, 0x0E, 0x48, 0x14, 0xF3, 0x38, 0x91, 0x1F, 0xB0, 0x1F, 0xA0, 0x1F, 0xB3, 0x81, 0x1E, 0x84,
  0x89, 0x14, 0xF7, 0x02, 0xF8, 0x06, 0xF5, 0x30, 0xB0, 0xC5, 0x81, 0x8F, 0x52, 0x83, 0xE9, 0x0D,
  0xB3, 0x81, 0x6E, 0x23, 0x89, 0x15, 0xCD, 0xDD, 0x80, 0x4C, 0xB8, 0x20,
  // "ﬁ" (U+FB01)
  0x71, 0x85, 0x6C, 0xEF, 0xEA, 0x37, 0x83, 0xBF, 0xC5, 0x8A, 0x0D, 0x60, 0x7A, 0x84, 0x10, 0x1E,
  0xC5, 0x68, 0x1E, 0xFB, 0x73, 0x08, 0x0D, 0xF9, 0x04, 0x40, 0x30, 0x9A, 0x82, 0x73, 0x3B, 0xA0,
  0x15, 0x0A, 0xA0, 0x12, 0x81, 0xDF, 0xD6, 0x81, 0xDF, 0xD2, 0x01, 0xA0, 0xA5, 0x01, 0xA0, 0xA2,
  0x04, 0xA0, 0x75, 0x04, 0xA0, 0x72, 0x07, 0xA0, 0x45, 0x07, 0xA0, 0x32, 0x0A, 0xA0, 0x15, 0x0B,
  0xA3, 0x81, 0xCF, 0xE6, 0x81, 0xEF, 0xC3, 0x0C, 0xA0, 0x50, 0x63, 0x02, 0xA0, 0x93, 0x83, 0x4D,
  0xFC, 0x43, 0x06, 0xA0, 0x47, 0x48, 0x1B, 0xFD, 0x72, 0x84, 0x14, 0x8F, 0xE3, 0x72, 0x83, 0x6F,
  0xDA, 0x27, 0x30,
  // "ﬂ" (U+FB02)
  0x71, 0x86, 0x7C, 0xEE, 0xB8, 0xD5, 0x78, 0x3C, 0xFC, 0x58, 0xB0, 0x26, 0x07, 0xA0, 0x12, 0x81,
  0xEF, 0xE7, 0x81, 0xEF, 0xB3, 0xA0, 0xB5, 0x08, 0x0D, 0xC0, 0x90, 0x3A, 0x08, 0x50, 0x30, 0x9A,
  0x82, 0x73, 0x17, 0xA0, 0x46, 0x0A, 0xA0, 0x12, 0x0A, 0xA0, 0x16, 0x81, 0xDF, 0xD3, 0x81, 0xDF,
  0xD6, 0x01, 0xA0, 0xA2, 0x01, 0xA0, 0xA6, 0x04, 0xA0, 0x72, 0x04, 0xA0, 0x76, 0x07, 0xA0, 0x32,
  0x07, 0xA0, 0x36, 0x0B, 0xA3, 0x09, 0xA0, 0x16, 0x81, 0xEF, 0xC3, 0x09, 0xA0, 0x60, 0x74, 0x02,
  0xA0, 0x93, 0x83, 0x2C, 0xFD, 0x64, 0x06, 0xA0, 0x47, 0x58, 0x1B, 0xFD, 0x73, 0x84, 0x14, 0x8F,
  0xE3, 0x73, 0x83, 0x6F, 0xDA, 0x27, 0x40,
};

const Font& font_NotoSerif_BoldItalic_18() {
  static SmoothFont font(font_NotoSerif_BoldItalic_18_data);
  return font;
}

}  // namespace roo_display
