#include "8.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSerif-Bold (Noto Serif Bold)
// Generated on Wed Nov 19 19:11:38 CET 2025
static const uint8_t font_NotoSerif_Bold_8_data[] PROGMEM = {
  
  // Header
  0x01, 0x02, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x03, 0x03,
  0xFE, 0xFE, 0x0A, 0x0A, 0x07, 0xFE, 0x04, 0x01, 0x0A, 0x03, 0x03, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x40, 0x01, 0x02, 0x07, 0x03, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x40, 0x05, 0x03, 0x07, 0x04, 0x00, 0x0B, // """ (U+0022)
  0x00, 0x23, 0x40, 0x01, 0x04, 0x07, 0x04, 0x00, 0x11, // "#" (U+0023)
  0x00, 0x24, 0x40, 0x00, 0x03, 0x07, 0x04, 0x00, 0x23, // "$" (U+0024)
  0x00, 0x25, 0x40, 0x01, 0x06, 0x07, 0x07, 0x00, 0x33, // "%" (U+0025)
  0x00, 0x26, 0x40, 0x01, 0x06, 0x07, 0x06, 0x00, 0x4C, // "&" (U+0026)
  0x00, 0x27, 0x40, 0x05, 0x01, 0x07, 0x02, 0x00, 0x65, // "'" (U+0027)
  0x00, 0x28, 0x40, 0x00, 0x02, 0x06, 0x03, 0x00, 0x68, // "(" (U+0028)
  0x00, 0x29, 0x40, 0x00, 0x02, 0x06, 0x03, 0x00, 0x73, // ")" (U+0029)
  0x00, 0x2A, 0x40, 0x04, 0x03, 0x07, 0x04, 0x00, 0x7E, // "*" (U+002A)
  0x00, 0x2B, 0x40, 0x02, 0x03, 0x05, 0x04, 0x00, 0x86, // "+" (U+002B)
  0x00, 0x2C, 0x40, 0xFF, 0x01, 0x01, 0x02, 0x00, 0x8E, // "," (U+002C)
  0x00, 0x2D, 0x40, 0x03, 0x02, 0x03, 0x02, 0x00, 0x91, // "-" (U+002D)
  0x00, 0x2E, 0x40, 0x01, 0x01, 0x02, 0x02, 0x00, 0x93, // "." (U+002E)
  0x00, 0x2F, 0x40, 0x00, 0x02, 0x07, 0x02, 0x00, 0x95, // "/" (U+002F)
  0x00, 0x30, 0x40, 0x01, 0x04, 0x07, 0x04, 0x00, 0xA1, // "0" (U+0030)
  0x00, 0x31, 0x40, 0x01, 0x03, 0x07, 0x04, 0x00, 0xB3, // "1" (U+0031)
  0x00, 0x32, 0x40, 0x01, 0x04, 0x07, 0x04, 0x00, 0xC1, // "2" (U+0032)
  0x00, 0x33, 0x40, 0x01, 0x03, 0x07, 0x04, 0x00, 0xD3, // "3" (U+0033)
  0x00, 0x34, 0x40, 0x01, 0x04, 0x07, 0x04, 0x00, 0xE1, // "4" (U+0034)
  0x00, 0x35, 0x40, 0x01, 0x03, 0x07, 0x04, 0x00, 0xF3, // "5" (U+0035)
  0x00, 0x36, 0x40, 0x01, 0x04, 0x07, 0x04, 0x01, 0x01, // "6" (U+0036)
  0x00, 0x37, 0x40, 0x01, 0x04, 0x07, 0x04, 0x01, 0x13, // "7" (U+0037)
  0x00, 0x38, 0x40, 0x01, 0x04, 0x07, 0x04, 0x01, 0x25, // "8" (U+0038)
  0x00, 0x39, 0x40, 0x01, 0x04, 0x07, 0x04, 0x01, 0x37, // "9" (U+0039)
  0x00, 0x3A, 0x40, 0x01, 0x01, 0x05, 0x02, 0x01, 0x49, // ":" (U+003A)
  0x00, 0x3B, 0x40, 0x00, 0x01, 0x05, 0x02, 0x01, 0x4E, // ";" (U+003B)
  0x00, 0x3C, 0x40, 0x02, 0x03, 0x05, 0x04, 0x01, 0x54, // "<" (U+003C)
  0x00, 0x3D, 0x40, 0x03, 0x03, 0x05, 0x04, 0x01, 0x5C, // "=" (U+003D)
  0x00, 0x3E, 0x40, 0x02, 0x03, 0x05, 0x04, 0x01, 0x62, // ">" (U+003E)
  0x00, 0x3F, 0x40, 0x01, 0x03, 0x07, 0x04, 0x01, 0x6A, // "?" (U+003F)
  0x00, 0x40, 0x40, 0x00, 0x06, 0x07, 0x07, 0x01, 0x78, // "@" (U+0040)
  0x00, 0x41, 0x40, 0x01, 0x05, 0x07, 0x06, 0x01, 0x94, // "A" (U+0041)
  0x00, 0x42, 0x40, 0x01, 0x04, 0x07, 0x05, 0x01, 0xA9, // "B" (U+0042)
  0x00, 0x43, 0x40, 0x01, 0x04, 0x07, 0x05, 0x01, 0xBB, // "C" (U+0043)
  0x00, 0x44, 0x40, 0x01, 0x05, 0x07, 0x06, 0x01, 0xCD, // "D" (U+0044)
  0x00, 0x45, 0x40, 0x01, 0x04, 0x07, 0x05, 0x01, 0xE2, // "E" (U+0045)
  0x00, 0x46, 0x40, 0x01, 0x04, 0x07, 0x05, 0x01, 0xF4, // "F" (U+0046)
  0x00, 0x47, 0x40, 0x01, 0x05, 0x07, 0x06, 0x02, 0x06, // "G" (U+0047)
  0x00, 0x48, 0x40, 0x01, 0x06, 0x07, 0x07, 0x02, 0x1B, // "H" (U+0048)
  0x00, 0x49, 0x40, 0x01, 0x02, 0x07, 0x03, 0x02, 0x34, // "I" (U+0049)
  0x00, 0x4A, 0xBF, 0xFF, 0x02, 0x07, 0x03, 0x02, 0x3F, // "J" (U+004A)
  0x00, 0x4B, 0x40, 0x01, 0x05, 0x07, 0x06, 0x02, 0x51, // "K" (U+004B)
  0x00, 0x4C, 0x40, 0x01, 0x04, 0x07, 0x05, 0x02, 0x66, // "L" (U+004C)
  0x00, 0x4D, 0x40, 0x01, 0x07, 0x07, 0x08, 0x02, 0x78, // "M" (U+004D)
  0x00, 0x4E, 0x40, 0x01, 0x06, 0x07, 0x06, 0x02, 0x94, // "N" (U+004E)
  0x00, 0x4F, 0x40, 0x01, 0x05, 0x07, 0x06, 0x02, 0xAD, // "O" (U+004F)
  0x00, 0x50, 0x40, 0x01, 0x04, 0x07, 0x05, 0x02, 0xC2, // "P" (U+0050)
  0x00, 0x51, 0x40, 0xFF, 0x05, 0x07, 0x06, 0x02, 0xD4, // "Q" (U+0051)
  0x00, 0x52, 0x40, 0x01, 0x05, 0x07, 0x06, 0x02, 0xEF, // "R" (U+0052)
  0x00, 0x53, 0x40, 0x01, 0x04, 0x07, 0x05, 0x03, 0x04, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x05, 0x07, 0x05, 0x03, 0x16, // "T" (U+0054)
  0x00, 0x55, 0x40, 0x01, 0x05, 0x07, 0x06, 0x03, 0x29, // "U" (U+0055)
  0x00, 0x56, 0x40, 0x01, 0x05, 0x07, 0x06, 0x03, 0x3E, // "V" (U+0056)
  0x00, 0x57, 0x40, 0x01, 0x08, 0x07, 0x09, 0x03, 0x53, // "W" (U+0057)
  0x00, 0x58, 0x40, 0x01, 0x05, 0x07, 0x06, 0x03, 0x73, // "X" (U+0058)
  0x00, 0x59, 0x40, 0x01, 0x05, 0x07, 0x06, 0x03, 0x88, // "Y" (U+0059)
  0x00, 0x5A, 0x40, 0x01, 0x04, 0x07, 0x05, 0x03, 0x9D, // "Z" (U+005A)
  0x00, 0x5B, 0x40, 0x00, 0x02, 0x07, 0x03, 0x03, 0xAF, // "[" (U+005B)
  0x00, 0x5C, 0x40, 0x00, 0x02, 0x07, 0x02, 0x03, 0xBB, // "\" (U+005C)
  0x00, 0x5D, 0x40, 0x00, 0x02, 0x07, 0x03, 0x03, 0xC7, // "]" (U+005D)
  0x00, 0x5E, 0x40, 0x03, 0x03, 0x06, 0x04, 0x03, 0xD3, // "^" (U+005E)
  0x00, 0x5F, 0x40, 0x00, 0x03, 0x00, 0x04, 0x03, 0xDB, // "_" (U+005F)
  0x00, 0x60, 0x40, 0x07, 0x02, 0x08, 0x03, 0x03, 0xDD, // "`" (U+0060)
  0x00, 0x61, 0x40, 0x01, 0x04, 0x05, 0x05, 0x03, 0xE0, // "a" (U+0061)
  0x00, 0x62, 0x40, 0x01, 0x04, 0x07, 0x05, 0x03, 0xED, // "b" (U+0062)
  0x00, 0x63, 0x40, 0x01, 0x03, 0x05, 0x04, 0x03, 0xFF, // "c" (U+0063)
  0x00, 0x64, 0x40, 0x01, 0x04, 0x07, 0x05, 0x04, 0x09, // "d" (U+0064)
  0x00, 0x65, 0x40, 0x01, 0x04, 0x05, 0x05, 0x04, 0x1B, // "e" (U+0065)
  0x00, 0x66, 0x40, 0x01, 0x03, 0x07, 0x03, 0x04, 0x28, // "f" (U+0066)
  0x00, 0x67, 0x40, 0xFF, 0x04, 0x05, 0x04, 0x04, 0x36, // "g" (U+0067)
  0x00, 0x68, 0x40, 0x01, 0x04, 0x07, 0x05, 0x04, 0x48, // "h" (U+0068)
  0x00, 0x69, 0x40, 0x01, 0x02, 0x07, 0x03, 0x04, 0x5A, // "i" (U+0069)
  0x00, 0x6A, 0xBF, 0xFF, 0x01, 0x07, 0x03, 0x04, 0x65, // "j" (U+006A)
  0x00, 0x6B, 0x40, 0x01, 0x04, 0x07, 0x05, 0x04, 0x73, // "k" (U+006B)
  0x00, 0x6C, 0x40, 0x01, 0x02, 0x07, 0x03, 0x04, 0x85, // "l" (U+006C)
  0x00, 0x6D, 0x40, 0x01, 0x07, 0x05, 0x08, 0x04, 0x90, // "m" (U+006D)
  0x00, 0x6E, 0x40, 0x01, 0x04, 0x05, 0x05, 0x04, 0xA4, // "n" (U+006E)
  0x00, 0x6F, 0x40, 0x01, 0x04, 0x05, 0x05, 0x04, 0xB1, // "o" (U+006F)
  0x00, 0x70, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x04, 0xBE, // "p" (U+0070)
  0x00, 0x71, 0x40, 0xFF, 0x05, 0x05, 0x05, 0x04, 0xD0, // "q" (U+0071)
  0x00, 0x72, 0x40, 0x01, 0x03, 0x05, 0x04, 0x04, 0xE5, // "r" (U+0072)
  0x00, 0x73, 0x40, 0x01, 0x03, 0x05, 0x04, 0x04, 0xEF, // "s" (U+0073)
  0x00, 0x74, 0x40, 0x01, 0x02, 0x06, 0x03, 0x04, 0xF9, // "t" (U+0074)
  0x00, 0x75, 0x40, 0x01, 0x05, 0x05, 0x05, 0x05, 0x02, // "u" (U+0075)
  0x00, 0x76, 0x40, 0x01, 0x04, 0x05, 0x05, 0x05, 0x11, // "v" (U+0076)
  0x00, 0x77, 0x40, 0x01, 0x06, 0x05, 0x07, 0x05, 0x1E, // "w" (U+0077)
  0x00, 0x78, 0x40, 0x01, 0x04, 0x05, 0x05, 0x05, 0x30, // "x" (U+0078)
  0x00, 0x79, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x05, 0x3D, // "y" (U+0079)
  0x00, 0x7A, 0x40, 0x01, 0x03, 0x05, 0x04, 0x05, 0x4F, // "z" (U+007A)
  0x00, 0x7B, 0x40, 0x00, 0x03, 0x07, 0x04, 0x05, 0x59, // "{" (U+007B)
  0x00, 0x7C, 0x41, 0xFF, 0x02, 0x07, 0x04, 0x05, 0x69, // "|" (U+007C)
  0x00, 0x7D, 0x40, 0x00, 0x03, 0x07, 0x04, 0x05, 0x72, // "}" (U+007D)
  0x00, 0x7E, 0x40, 0x03, 0x03, 0x04, 0x04, 0x05, 0x82, // "~" (U+007E)
  0x00, 0xA1, 0x40, 0xFE, 0x02, 0x04, 0x03, 0x05, 0x86, // "¡" (U+00A1)
  0x00, 0xA2, 0x40, 0x01, 0x03, 0x07, 0x04, 0x05, 0x91, // "¢" (U+00A2)
  0x00, 0xA3, 0x40, 0x01, 0x04, 0x07, 0x04, 0x05, 0x9F, // "£" (U+00A3)
  0x00, 0xA4, 0x40, 0x02, 0x03, 0x06, 0x04, 0x05, 0xB1, // "¤" (U+00A4)
  0x00, 0xA5, 0x40, 0x01, 0x04, 0x07, 0x04, 0x05, 0xBB, // "¥" (U+00A5)
  0x00, 0xA6, 0x41, 0xFF, 0x02, 0x07, 0x04, 0x05, 0xCD, // "¦" (U+00A6)
  0x00, 0xA7, 0x40, 0x00, 0x03, 0x07, 0x04, 0x05, 0xD6, // "§" (U+00A7)
  0x00, 0xA8, 0x41, 0x07, 0x03, 0x07, 0x05, 0x05, 0xE6, // "¨" (U+00A8)
  0x00, 0xA9, 0x40, 0x01, 0x06, 0x07, 0x07, 0x05, 0xE8, // "©" (U+00A9)
  0x00, 0xAA, 0x40, 0x04, 0x03, 0x06, 0x03, 0x06, 0x01, // "ª" (U+00AA)
  0x00, 0xAB, 0x40, 0x02, 0x03, 0x05, 0x04, 0x06, 0x07, // "«" (U+00AB)
  0x00, 0xAC, 0x40, 0x02, 0x03, 0x04, 0x04, 0x06, 0x0F, // "¬" (U+00AC)
  0x00, 0xAE, 0x40, 0x01, 0x06, 0x07, 0x07, 0x06, 0x15, // "®" (U+00AE)
  0x00, 0xAF, 0x40, 0x08, 0x03, 0x08, 0x04, 0x06, 0x2E, // "¯" (U+00AF)
  0x00, 0xB0, 0x40, 0x05, 0x02, 0x07, 0x03, 0x06, 0x30, // "°" (U+00B0)
  0x00, 0xB1, 0x40, 0x01, 0x03, 0x05, 0x04, 0x06, 0x35, // "±" (U+00B1)
  0x00, 0xB2, 0x40, 0x04, 0x02, 0x07, 0x03, 0x06, 0x3F, // "²" (U+00B2)
  0x00, 0xB3, 0x40, 0x04, 0x02, 0x07, 0x03, 0x06, 0x45, // "³" (U+00B3)
  0x00, 0xB4, 0x40, 0x07, 0x02, 0x08, 0x03, 0x06, 0x4B, // "´" (U+00B4)
  0x00, 0xB5, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x06, 0x4E, // "µ" (U+00B5)
  0x00, 0xB6, 0x40, 0x00, 0x04, 0x07, 0x05, 0x06, 0x60, // "¶" (U+00B6)
  0x00, 0xB7, 0x40, 0x03, 0x01, 0x04, 0x02, 0x06, 0x74, // "·" (U+00B7)
  0x00, 0xB8, 0x40, 0xFF, 0x02, 0x01, 0x03, 0x06, 0x76, // "¸" (U+00B8)
  0x00, 0xB9, 0x40, 0x04, 0x02, 0x07, 0x03, 0x06, 0x7B, // "¹" (U+00B9)
  0x00, 0xBA, 0x40, 0x04, 0x03, 0x06, 0x04, 0x06, 0x81, // "º" (U+00BA)
  0x00, 0xBB, 0x40, 0x02, 0x03, 0x05, 0x04, 0x06, 0x87, // "»" (U+00BB)
  0x00, 0xBC, 0x40, 0x01, 0x06, 0x07, 0x07, 0x06, 0x8F, // "¼" (U+00BC)
  0x00, 0xBD, 0x40, 0x01, 0x06, 0x07, 0x07, 0x06, 0xA8, // "½" (U+00BD)
  0x00, 0xBE, 0x40, 0x01, 0x06, 0x07, 0x07, 0x06, 0xC1, // "¾" (U+00BE)
  0x00, 0xBF, 0x40, 0xFE, 0x03, 0x04, 0x04, 0x06, 0xDA, // "¿" (U+00BF)
  0x00, 0xC0, 0x40, 0x01, 0x05, 0x09, 0x06, 0x06, 0xE8, // "À" (U+00C0)
  0x00, 0xC1, 0x40, 0x01, 0x05, 0x09, 0x06, 0x07, 0x03, // "Á" (U+00C1)
  0x00, 0xC2, 0x40, 0x01, 0x05, 0x09, 0x06, 0x07, 0x1E, // "Â" (U+00C2)
  0x00, 0xC3, 0x40, 0x01, 0x05, 0x08, 0x06, 0x07, 0x39, // "Ã" (U+00C3)
  0x00, 0xC4, 0x40, 0x01, 0x05, 0x08, 0x06, 0x07, 0x51, // "Ä" (U+00C4)
  0x00, 0xC5, 0x40, 0x01, 0x05, 0x08, 0x06, 0x07, 0x69, // "Å" (U+00C5)
  0x00, 0xC6, 0x40, 0x01, 0x07, 0x07, 0x08, 0x07, 0x81, // "Æ" (U+00C6)
  0x00, 0xC7, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x07, 0x9D, // "Ç" (U+00C7)
  0x00, 0xC8, 0x40, 0x01, 0x04, 0x09, 0x05, 0x07, 0xB4, // "È" (U+00C8)
  0x00, 0xC9, 0x40, 0x01, 0x04, 0x09, 0x05, 0x07, 0xCB, // "É" (U+00C9)
  0x00, 0xCA, 0x40, 0x01, 0x04, 0x09, 0x05, 0x07, 0xE2, // "Ê" (U+00CA)
  0x00, 0xCB, 0x40, 0x01, 0x04, 0x08, 0x05, 0x07, 0xF9, // "Ë" (U+00CB)
  0x00, 0xCC, 0x40, 0x01, 0x02, 0x09, 0x03, 0x08, 0x0D, // "Ì" (U+00CC)
  0x00, 0xCD, 0x40, 0x01, 0x03, 0x09, 0x03, 0x08, 0x1B, // "Í" (U+00CD)
  0x00, 0xCE, 0x40, 0x01, 0x02, 0x09, 0x03, 0x08, 0x2D, // "Î" (U+00CE)
  0x00, 0xCF, 0x40, 0x01, 0x02, 0x08, 0x03, 0x08, 0x3B, // "Ï" (U+00CF)
  0x00, 0xD0, 0x40, 0x01, 0x05, 0x07, 0x06, 0x08, 0x47, // "Ð" (U+00D0)
  0x00, 0xD1, 0x40, 0x01, 0x06, 0x08, 0x06, 0x08, 0x5C, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x40, 0x01, 0x05, 0x09, 0x06, 0x08, 0x78, // "Ò" (U+00D2)
  0x00, 0xD3, 0x40, 0x01, 0x05, 0x09, 0x06, 0x08, 0x93, // "Ó" (U+00D3)
  0x00, 0xD4, 0x40, 0x01, 0x05, 0x09, 0x06, 0x08, 0xAE, // "Ô" (U+00D4)
  0x00, 0xD5, 0x40, 0x01, 0x05, 0x08, 0x06, 0x08, 0xC9, // "Õ" (U+00D5)
  0x00, 0xD6, 0x40, 0x01, 0x05, 0x08, 0x06, 0x08, 0xE1, // "Ö" (U+00D6)
  0x00, 0xD7, 0x40, 0x02, 0x03, 0x05, 0x04, 0x08, 0xF9, // "×" (U+00D7)
  0x00, 0xD8, 0x40, 0x00, 0x05, 0x07, 0x06, 0x09, 0x01, // "Ø" (U+00D8)
  0x00, 0xD9, 0x40, 0x01, 0x05, 0x09, 0x06, 0x09, 0x19, // "Ù" (U+00D9)
  0x00, 0xDA, 0x40, 0x01, 0x05, 0x09, 0x06, 0x09, 0x34, // "Ú" (U+00DA)
  0x00, 0xDB, 0x40, 0x01, 0x05, 0x09, 0x06, 0x09, 0x4F, // "Û" (U+00DB)
  0x00, 0xDC, 0x40, 0x01, 0x05, 0x08, 0x06, 0x09, 0x6A, // "Ü" (U+00DC)
  0x00, 0xDD, 0x40, 0x01, 0x05, 0x09, 0x06, 0x09, 0x82, // "Ý" (U+00DD)
  0x00, 0xDE, 0x40, 0x01, 0x04, 0x07, 0x05, 0x09, 0x9D, // "Þ" (U+00DE)
  0x00, 0xDF, 0x40, 0x01, 0x05, 0x07, 0x06, 0x09, 0xAF, // "ß" (U+00DF)
  0x00, 0xE0, 0x40, 0x01, 0x04, 0x08, 0x05, 0x09, 0xC4, // "à" (U+00E0)
  0x00, 0xE1, 0x40, 0x01, 0x04, 0x08, 0x05, 0x09, 0xD8, // "á" (U+00E1)
  0x00, 0xE2, 0x40, 0x01, 0x04, 0x08, 0x05, 0x09, 0xEC, // "â" (U+00E2)
  0x00, 0xE3, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x00, // "ã" (U+00E3)
  0x00, 0xE4, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x12, // "ä" (U+00E4)
  0x00, 0xE5, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x24, // "å" (U+00E5)
  0x00, 0xE6, 0x40, 0x01, 0x06, 0x05, 0x07, 0x0A, 0x36, // "æ" (U+00E6)
  0x00, 0xE7, 0x40, 0xFF, 0x03, 0x05, 0x04, 0x0A, 0x48, // "ç" (U+00E7)
  0x00, 0xE8, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0A, 0x56, // "è" (U+00E8)
  0x00, 0xE9, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0A, 0x6A, // "é" (U+00E9)
  0x00, 0xEA, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0A, 0x7E, // "ê" (U+00EA)
  0x00, 0xEB, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x92, // "ë" (U+00EB)
  0x00, 0xEC, 0x40, 0x01, 0x02, 0x08, 0x03, 0x0A, 0xA4, // "ì" (U+00EC)
  0x00, 0xED, 0x40, 0x01, 0x02, 0x08, 0x03, 0x0A, 0xB0, // "í" (U+00ED)
  0x00, 0xEE, 0x40, 0x01, 0x02, 0x08, 0x03, 0x0A, 0xBC, // "î" (U+00EE)
  0x00, 0xEF, 0x40, 0x01, 0x02, 0x07, 0x03, 0x0A, 0xC8, // "ï" (U+00EF)
  0x00, 0xF0, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0A, 0xD3, // "ð" (U+00F0)
  0x00, 0xF1, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0A, 0xE7, // "ñ" (U+00F1)
  0x00, 0xF2, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0A, 0xF9, // "ò" (U+00F2)
  0x00, 0xF3, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0B, 0x0D, // "ó" (U+00F3)
  0x00, 0xF4, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0B, 0x21, // "ô" (U+00F4)
  0x00, 0xF5, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0B, 0x35, // "õ" (U+00F5)
  0x00, 0xF6, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0B, 0x47, // "ö" (U+00F6)
  0x00, 0xF7, 0x40, 0x02, 0x03, 0x05, 0x04, 0x0B, 0x59, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x00, 0x04, 0x06, 0x05, 0x0B, 0x61, // "ø" (U+00F8)
  0x00, 0xF9, 0x00, 0x01, 0x05, 0x08, 0x05, 0x0B, 0x72, // "ù" (U+00F9)
  0x00, 0xFA, 0x00, 0x01, 0x05, 0x08, 0x05, 0x0B, 0x89, // "ú" (U+00FA)
  0x00, 0xFB, 0x40, 0x01, 0x05, 0x08, 0x05, 0x0B, 0xA0, // "û" (U+00FB)
  0x00, 0xFC, 0x40, 0x01, 0x05, 0x07, 0x05, 0x0B, 0xB8, // "ü" (U+00FC)
  0x00, 0xFD, 0x40, 0xFF, 0x04, 0x08, 0x05, 0x0B, 0xCD, // "ý" (U+00FD)
  0x00, 0xFE, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x0B, 0xE6, // "þ" (U+00FE)
  0x00, 0xFF, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x0B, 0xFD, // "ÿ" (U+00FF)
  0x01, 0x00, 0x40, 0x01, 0x05, 0x07, 0x06, 0x0C, 0x14, // "Ā" (U+0100)
  0x01, 0x01, 0x40, 0x01, 0x04, 0x06, 0x05, 0x0C, 0x29, // "ā" (U+0101)
  0x01, 0x02, 0x40, 0x01, 0x05, 0x08, 0x06, 0x0C, 0x38, // "Ă" (U+0102)
  0x01, 0x03, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0C, 0x50, // "ă" (U+0103)
  0x01, 0x04, 0x40, 0xFF, 0x05, 0x07, 0x06, 0x0C, 0x62, // "Ą" (U+0104)
  0x01, 0x05, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x0C, 0x7D, // "ą" (U+0105)
  0x01, 0x06, 0x40, 0x01, 0x04, 0x09, 0x05, 0x0C, 0x8F, // "Ć" (U+0106)
  0x01, 0x07, 0x40, 0x01, 0x03, 0x08, 0x04, 0x0C, 0xA6, // "ć" (U+0107)
  0x01, 0x08, 0x40, 0x01, 0x04, 0x09, 0x05, 0x0C, 0xB6, // "Ĉ" (U+0108)
  0x01, 0x09, 0x40, 0x01, 0x03, 0x08, 0x04, 0x0C, 0xCD, // "ĉ" (U+0109)
  0x01, 0x0A, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0C, 0xDD, // "Ċ" (U+010A)
  0x01, 0x0B, 0x40, 0x01, 0x03, 0x07, 0x04, 0x0C, 0xF1, // "ċ" (U+010B)
  0x01, 0x0C, 0x40, 0x01, 0x04, 0x09, 0x05, 0x0C, 0xFF, // "Č" (U+010C)
  0x01, 0x0D, 0x40, 0x01, 0x03, 0x08, 0x04, 0x0D, 0x16, // "č" (U+010D)
  0x01, 0x0E, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0D, 0x26, // "Ď" (U+010E)
  0x01, 0x0F, 0x40, 0x01, 0x05, 0x07, 0x05, 0x0D, 0x41, // "ď" (U+010F)
  0x01, 0x10, 0x40, 0x01, 0x05, 0x07, 0x06, 0x0D, 0x56, // "Đ" (U+0110)
  0x01, 0x11, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0D, 0x6B, // "đ" (U+0111)
  0x01, 0x12, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0D, 0x7D, // "Ē" (U+0112)
  0x01, 0x13, 0x40, 0x01, 0x04, 0x06, 0x05, 0x0D, 0x8F, // "ē" (U+0113)
  0x01, 0x14, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0D, 0x9E, // "Ĕ" (U+0114)
  0x01, 0x15, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0D, 0xB2, // "ĕ" (U+0115)
  0x01, 0x16, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0D, 0xC4, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0D, 0xD8, // "ė" (U+0117)
  0x01, 0x18, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x0D, 0xE9, // "Ę" (U+0118)
  0x01, 0x19, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x0E, 0x00, // "ę" (U+0119)
  0x01, 0x1A, 0x40, 0x01, 0x04, 0x09, 0x05, 0x0E, 0x12, // "Ě" (U+011A)
  0x01, 0x1B, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0E, 0x29, // "ě" (U+011B)
  0x01, 0x1C, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0E, 0x3D, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x40, 0xFF, 0x04, 0x08, 0x04, 0x0E, 0x58, // "ĝ" (U+011D)
  0x01, 0x1E, 0x40, 0x01, 0x05, 0x08, 0x06, 0x0E, 0x71, // "Ğ" (U+011E)
  0x01, 0x1F, 0x40, 0xFF, 0x04, 0x07, 0x04, 0x0E, 0x89, // "ğ" (U+011F)
  0x01, 0x20, 0x40, 0x01, 0x05, 0x08, 0x06, 0x0E, 0xA0, // "Ġ" (U+0120)
  0x01, 0x21, 0x40, 0xFF, 0x04, 0x07, 0x04, 0x0E, 0xB8, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0xFE, 0x05, 0x07, 0x06, 0x0E, 0xCF, // "Ģ" (U+0122)
  0x01, 0x23, 0x40, 0xFF, 0x04, 0x07, 0x04, 0x0E, 0xEA, // "ģ" (U+0123)
  0x01, 0x24, 0x40, 0x01, 0x06, 0x09, 0x07, 0x0F, 0x01, // "Ĥ" (U+0124)
  0x01, 0x25, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x0F, 0x21, // "ĥ" (U+0125)
  0x01, 0x26, 0x40, 0x01, 0x06, 0x07, 0x07, 0x0F, 0x39, // "Ħ" (U+0126)
  0x01, 0x27, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0F, 0x52, // "ħ" (U+0127)
  0x01, 0x28, 0x40, 0x01, 0x03, 0x08, 0x03, 0x0F, 0x64, // "Ĩ" (U+0128)
  0x01, 0x29, 0xBF, 0x01, 0x02, 0x07, 0x03, 0x0F, 0x74, // "ĩ" (U+0129)
  0x01, 0x2A, 0x40, 0x01, 0x02, 0x07, 0x03, 0x0F, 0x82, // "Ī" (U+012A)
  0x01, 0x2B, 0x40, 0x01, 0x02, 0x06, 0x03, 0x0F, 0x8D, // "ī" (U+012B)
  0x01, 0x2C, 0x40, 0x01, 0x02, 0x08, 0x03, 0x0F, 0x96, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x40, 0x01, 0x02, 0x07, 0x03, 0x0F, 0xA2, // "ĭ" (U+012D)
  0x01, 0x2E, 0x40, 0xFF, 0x02, 0x07, 0x03, 0x0F, 0xAD, // "Į" (U+012E)
  0x01, 0x2F, 0x40, 0xFF, 0x02, 0x07, 0x03, 0x0F, 0xBB, // "į" (U+012F)
  0x01, 0x30, 0x40, 0x01, 0x02, 0x08, 0x03, 0x0F, 0xC9, // "İ" (U+0130)
  0x01, 0x31, 0x40, 0x01, 0x02, 0x05, 0x03, 0x0F, 0xD5, // "ı" (U+0131)
  0x01, 0x32, 0x40, 0xFF, 0x05, 0x07, 0x06, 0x0F, 0xDD, // "Ĳ" (U+0132)
  0x01, 0x33, 0x40, 0xFF, 0x04, 0x07, 0x06, 0x0F, 0xF8, // "ĳ" (U+0133)
  0x01, 0x34, 0xBF, 0xFF, 0x02, 0x09, 0x03, 0x10, 0x0F, // "Ĵ" (U+0134)
  0x01, 0x35, 0x40, 0xFF, 0x02, 0x08, 0x03, 0x10, 0x25, // "ĵ" (U+0135)
  0x01, 0x36, 0x00, 0xFE, 0x05, 0x07, 0x06, 0x10, 0x34, // "Ķ" (U+0136)
  0x01, 0x37, 0x00, 0xFE, 0x04, 0x07, 0x05, 0x10, 0x51, // "ķ" (U+0137)
  0x01, 0x38, 0x40, 0x01, 0x04, 0x05, 0x05, 0x10, 0x69, // "ĸ" (U+0138)
  0x01, 0x39, 0x40, 0x01, 0x04, 0x09, 0x05, 0x10, 0x76, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x40, 0x01, 0x03, 0x0A, 0x03, 0x10, 0x8D, // "ĺ" (U+013A)
  0x01, 0x3B, 0x00, 0xFE, 0x04, 0x07, 0x05, 0x10, 0xA1, // "Ļ" (U+013B)
  0x01, 0x3C, 0x40, 0xFE, 0x02, 0x07, 0x03, 0x10, 0xB7, // "ļ" (U+013C)
  0x01, 0x3D, 0x40, 0x01, 0x04, 0x07, 0x05, 0x10, 0xC6, // "Ľ" (U+013D)
  0x01, 0x3E, 0x40, 0x01, 0x03, 0x07, 0x03, 0x10, 0xD8, // "ľ" (U+013E)
  0x01, 0x3F, 0x40, 0x01, 0x04, 0x07, 0x05, 0x10, 0xE6, // "Ŀ" (U+013F)
  0x01, 0x40, 0x40, 0x01, 0x03, 0x07, 0x04, 0x10, 0xF8, // "ŀ" (U+0140)
  0x01, 0x41, 0x40, 0x01, 0x04, 0x07, 0x05, 0x11, 0x06, // "Ł" (U+0141)
  0x01, 0x42, 0x40, 0x01, 0x02, 0x07, 0x03, 0x11, 0x18, // "ł" (U+0142)
  0x01, 0x43, 0x40, 0x01, 0x06, 0x09, 0x06, 0x11, 0x23, // "Ń" (U+0143)
  0x01, 0x44, 0x40, 0x01, 0x04, 0x08, 0x05, 0x11, 0x43, // "ń" (U+0144)
  0x01, 0x45, 0x00, 0xFE, 0x06, 0x07, 0x06, 0x11, 0x57, // "Ņ" (U+0145)
  0x01, 0x46, 0x00, 0xFE, 0x04, 0x05, 0x05, 0x11, 0x78, // "ņ" (U+0146)
  0x01, 0x47, 0x40, 0x01, 0x06, 0x09, 0x06, 0x11, 0x8B, // "Ň" (U+0147)
  0x01, 0x48, 0x40, 0x01, 0x04, 0x08, 0x05, 0x11, 0xAB, // "ň" (U+0148)
  0x01, 0x49, 0x40, 0x01, 0x06, 0x07, 0x07, 0x11, 0xBF, // "ŉ" (U+0149)
  0x01, 0x4A, 0x40, 0xFF, 0x06, 0x07, 0x06, 0x11, 0xD8, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x11, 0xF8, // "ŋ" (U+014B)
  0x01, 0x4C, 0x40, 0x01, 0x05, 0x07, 0x06, 0x12, 0x0A, // "Ō" (U+014C)
  0x01, 0x4D, 0x40, 0x01, 0x04, 0x06, 0x05, 0x12, 0x1F, // "ō" (U+014D)
  0x01, 0x4E, 0x40, 0x01, 0x05, 0x08, 0x06, 0x12, 0x2E, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x40, 0x01, 0x04, 0x07, 0x05, 0x12, 0x46, // "ŏ" (U+014F)
  0x01, 0x50, 0x40, 0x01, 0x05, 0x08, 0x06, 0x12, 0x58, // "Ő" (U+0150)
  0x01, 0x51, 0x40, 0x01, 0x04, 0x07, 0x05, 0x12, 0x70, // "ő" (U+0151)
  0x01, 0x52, 0x40, 0x01, 0x07, 0x07, 0x08, 0x12, 0x82, // "Œ" (U+0152)
  0x01, 0x53, 0x40, 0x01, 0x07, 0x05, 0x07, 0x12, 0x9E, // "œ" (U+0153)
  0x01, 0x54, 0x40, 0x01, 0x05, 0x09, 0x06, 0x12, 0xB2, // "Ŕ" (U+0154)
  0x01, 0x55, 0x40, 0x01, 0x03, 0x08, 0x04, 0x12, 0xCD, // "ŕ" (U+0155)
  0x01, 0x56, 0x40, 0xFE, 0x05, 0x07, 0x06, 0x12, 0xDD, // "Ŗ" (U+0156)
  0x01, 0x57, 0x40, 0xFE, 0x03, 0x05, 0x04, 0x12, 0xFB, // "ŗ" (U+0157)
  0x01, 0x58, 0x40, 0x01, 0x05, 0x09, 0x06, 0x13, 0x0B, // "Ř" (U+0158)
  0x01, 0x59, 0x40, 0x01, 0x03, 0x08, 0x04, 0x13, 0x26, // "ř" (U+0159)
  0x01, 0x5A, 0x40, 0x01, 0x04, 0x09, 0x05, 0x13, 0x36, // "Ś" (U+015A)
  0x01, 0x5B, 0x40, 0x01, 0x03, 0x08, 0x04, 0x13, 0x4D, // "ś" (U+015B)
  0x01, 0x5C, 0x40, 0x01, 0x04, 0x09, 0x05, 0x13, 0x5D, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x40, 0x01, 0x03, 0x08, 0x04, 0x13, 0x74, // "ŝ" (U+015D)
  0x01, 0x5E, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x13, 0x84, // "Ş" (U+015E)
  0x01, 0x5F, 0x40, 0xFF, 0x03, 0x05, 0x04, 0x13, 0x9B, // "ş" (U+015F)
  0x01, 0x60, 0x40, 0x01, 0x04, 0x09, 0x05, 0x13, 0xA9, // "Š" (U+0160)
  0x01, 0x61, 0x40, 0x01, 0x03, 0x08, 0x04, 0x13, 0xC0, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFF, 0x05, 0x07, 0x05, 0x13, 0xD0, // "Ţ" (U+0162)
  0x01, 0x63, 0x40, 0xFF, 0x02, 0x06, 0x03, 0x13, 0xE7, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x05, 0x09, 0x05, 0x13, 0xF3, // "Ť" (U+0164)
  0x01, 0x65, 0x40, 0x01, 0x03, 0x07, 0x03, 0x14, 0x0D, // "ť" (U+0165)
  0x01, 0x66, 0x40, 0x01, 0x05, 0x07, 0x05, 0x14, 0x1B, // "Ŧ" (U+0166)
  0x01, 0x67, 0x40, 0x01, 0x02, 0x06, 0x03, 0x14, 0x30, // "ŧ" (U+0167)
  0x01, 0x68, 0x40, 0x01, 0x05, 0x08, 0x06, 0x14, 0x39, // "Ũ" (U+0168)
  0x01, 0x69, 0x40, 0x01, 0x05, 0x07, 0x05, 0x14, 0x51, // "ũ" (U+0169)
  0x01, 0x6A, 0x40, 0x01, 0x05, 0x07, 0x06, 0x14, 0x66, // "Ū" (U+016A)
  0x01, 0x6B, 0x40, 0x01, 0x05, 0x06, 0x05, 0x14, 0x7B, // "ū" (U+016B)
  0x01, 0x6C, 0x40, 0x01, 0x05, 0x08, 0x06, 0x14, 0x8D, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x40, 0x01, 0x05, 0x07, 0x05, 0x14, 0xA5, // "ŭ" (U+016D)
  0x01, 0x6E, 0x40, 0x01, 0x05, 0x08, 0x06, 0x14, 0xBA, // "Ů" (U+016E)
  0x01, 0x6F, 0x40, 0x01, 0x05, 0x07, 0x05, 0x14, 0xD2, // "ů" (U+016F)
  0x01, 0x70, 0x40, 0x01, 0x05, 0x08, 0x06, 0x14, 0xE7, // "Ű" (U+0170)
  0x01, 0x71, 0x40, 0x01, 0x05, 0x07, 0x05, 0x14, 0xFF, // "ű" (U+0171)
  0x01, 0x72, 0x40, 0xFF, 0x05, 0x07, 0x06, 0x15, 0x14, // "Ų" (U+0172)
  0x01, 0x73, 0x40, 0xFF, 0x05, 0x05, 0x05, 0x15, 0x2F, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x08, 0x09, 0x09, 0x15, 0x44, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x06, 0x08, 0x07, 0x15, 0x6C, // "ŵ" (U+0175)
  0x01, 0x76, 0x40, 0x01, 0x05, 0x09, 0x06, 0x15, 0x87, // "Ŷ" (U+0176)
  0x01, 0x77, 0x40, 0xFF, 0x04, 0x08, 0x05, 0x15, 0xA2, // "ŷ" (U+0177)
  0x01, 0x78, 0x40, 0x01, 0x05, 0x08, 0x06, 0x15, 0xBB, // "Ÿ" (U+0178)
  0x01, 0x79, 0x40, 0x01, 0x04, 0x09, 0x05, 0x15, 0xD3, // "Ź" (U+0179)
  0x01, 0x7A, 0x40, 0x01, 0x03, 0x08, 0x04, 0x15, 0xEA, // "ź" (U+017A)
  0x01, 0x7B, 0x40, 0x01, 0x04, 0x08, 0x05, 0x15, 0xFA, // "Ż" (U+017B)
  0x01, 0x7C, 0x40, 0x01, 0x03, 0x07, 0x04, 0x16, 0x0E, // "ż" (U+017C)
  0x01, 0x7D, 0x40, 0x01, 0x04, 0x09, 0x05, 0x16, 0x1C, // "Ž" (U+017D)
  0x01, 0x7E, 0x40, 0x01, 0x03, 0x08, 0x04, 0x16, 0x33, // "ž" (U+017E)
  0x01, 0x7F, 0x40, 0x01, 0x03, 0x07, 0x03, 0x16, 0x43, // "ſ" (U+017F)
  0x03, 0xA9, 0x40, 0x01, 0x06, 0x07, 0x06, 0x16, 0x51, // "Ω" (U+03A9)
  0x03, 0xBC, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x16, 0x6A, // "μ" (U+03BC)
  0x03, 0xC0, 0x40, 0x01, 0x05, 0x05, 0x05, 0x16, 0x7C, // "π" (U+03C0)
  0x20, 0x13, 0x40, 0x03, 0x03, 0x03, 0x04, 0x16, 0x8B, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x03, 0x07, 0x03, 0x08, 0x16, 0x8D, // "—" (U+2014)
  0x20, 0xAC, 0x40, 0x01, 0x04, 0x07, 0x04, 0x16, 0x8F, // "€" (U+20AC)
  0x20, 0xBF, 0x40, 0x00, 0x04, 0x07, 0x04, 0x16, 0xA1, // "₿" (U+20BF)
  0x20, 0x18, 0x40, 0x05, 0x01, 0x07, 0x02, 0x16, 0xB5, // "‘" (U+2018)
  0x20, 0x19, 0x40, 0x05, 0x01, 0x07, 0x02, 0x16, 0xB8, // "’" (U+2019)
  0x20, 0x1A, 0x40, 0xFF, 0x01, 0x01, 0x02, 0x16, 0xBB, // "‚" (U+201A)
  0x20, 0x1B, 0x40, 0x05, 0x01, 0x07, 0x02, 0x16, 0xBE, // "‛" (U+201B)
  0x20, 0x1C, 0x40, 0x05, 0x03, 0x07, 0x04, 0x16, 0xC1, // "“" (U+201C)
  0x20, 0x1D, 0x40, 0x05, 0x03, 0x07, 0x04, 0x16, 0xC7, // "”" (U+201D)
  0x20, 0x1E, 0x40, 0xFF, 0x03, 0x01, 0x04, 0x16, 0xCD, // "„" (U+201E)
  0x20, 0x1F, 0x40, 0x05, 0x03, 0x07, 0x04, 0x16, 0xD3, // "‟" (U+201F)
  0x20, 0x20, 0x40, 0x00, 0x03, 0x07, 0x04, 0x16, 0xD9, // "†" (U+2020)
  0x20, 0x21, 0x40, 0x00, 0x03, 0x07, 0x04, 0x16, 0xE9, // "‡" (U+2021)
  0x20, 0x22, 0x40, 0x03, 0x02, 0x05, 0x03, 0x16, 0xF9, // "•" (U+2022)
  0x20, 0x26, 0x40, 0x01, 0x06, 0x02, 0x07, 0x16, 0xFE, // "…" (U+2026)
  0x20, 0x30, 0x00, 0x01, 0x0A, 0x07, 0x0A, 0x17, 0x05, // "‰" (U+2030)
  0x20, 0x39, 0x40, 0x02, 0x02, 0x05, 0x03, 0x17, 0x2A, // "‹" (U+2039)
  0x20, 0x3A, 0x40, 0x02, 0x02, 0x05, 0x03, 0x17, 0x30, // "›" (U+203A)
  0x20, 0x44, 0xBE, 0x01, 0x01, 0x07, 0x01, 0x17, 0x36, // "⁄" (U+2044)
  0x21, 0x22, 0x40, 0x04, 0x06, 0x06, 0x07, 0x17, 0x44, // "™" (U+2122)
  0x21, 0x52, 0x00, 0x01, 0x08, 0x07, 0x09, 0x17, 0x4F, // "⅒" (U+2152)
  0xFB, 0x01, 0x40, 0x01, 0x05, 0x07, 0x06, 0x17, 0x6C, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0x40, 0x01, 0x05, 0x07, 0x06, 0x17, 0x81, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x01, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0xC0, 0x01, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x01, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x01, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x01, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x01, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x01, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xC6, 0x01, // "Æ (U+0022 U+00C6)
  0x00, 0x22, 0x01, 0x00, 0x01, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x02, 0x01, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x04, 0x01, // "Ą (U+0022 U+0104)
  0x00, 0x27, 0x00, 0x41, 0x01, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0xC0, 0x01, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x01, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x01, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x01, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x01, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x01, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xC6, 0x01, // 'Æ (U+0027 U+00C6)
  0x00, 0x27, 0x01, 0x00, 0x01, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x02, 0x01, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x04, 0x01, // 'Ą (U+0027 U+0104)
  0x00, 0x2A, 0x00, 0x2C, 0x01, // *, (U+002A U+002C)
  0x00, 0x2A, 0x00, 0x2E, 0x01, // *. (U+002A U+002E)
  0x00, 0x2A, 0x00, 0xC6, 0x01, // *Æ (U+002A U+00C6)
  0x00, 0x2A, 0x20, 0x1A, 0x01, // *‚ (U+002A U+201A)
  0x00, 0x2A, 0x20, 0x1E, 0x01, // *„ (U+002A U+201E)
  0x00, 0x2A, 0x20, 0x26, 0x01, // *… (U+002A U+2026)
  0x00, 0x2C, 0x00, 0x3F, 0x01, // ,? (U+002C U+003F)
  0x00, 0x2C, 0x00, 0x54, 0x01, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x56, 0x01, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x01, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x01, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0x76, 0x01, // ,v (U+002C U+0076)
  0x00, 0x2C, 0x00, 0xDD, 0x01, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x01, 0x62, 0x01, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x01, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x01, // ,Ŧ (U+002C U+0166)
  0x00, 0x2C, 0x01, 0x74, 0x01, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x76, 0x01, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x78, 0x01, // ,Ÿ (U+002C U+0178)
  0x00, 0x2E, 0x00, 0x3F, 0x01, // .? (U+002E U+003F)
  0x00, 0x2E, 0x00, 0x54, 0x01, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x56, 0x01, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x01, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x01, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0x76, 0x01, // .v (U+002E U+0076)
  0x00, 0x2E, 0x00, 0xDD, 0x01, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x01, 0x62, 0x01, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x01, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x01, // .Ŧ (U+002E U+0166)
  0x00, 0x2E, 0x01, 0x74, 0x01, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x76, 0x01, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x78, 0x01, // .Ÿ (U+002E U+0178)
  0x00, 0x41, 0x00, 0x22, 0x01, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x01, // A' (U+0041 U+0027)
  0x00, 0x41, 0x00, 0x2A, 0x01, // A* (U+0041 U+002A)
  0x00, 0x41, 0x00, 0x56, 0x01, // AV (U+0041 U+0056)
  0x00, 0x41, 0x00, 0x57, 0x01, // AW (U+0041 U+0057)
  0x00, 0x41, 0x00, 0x59, 0x01, // AY (U+0041 U+0059)
  0x00, 0x41, 0x00, 0xDD, 0x01, // AÝ (U+0041 U+00DD)
  0x00, 0x41, 0x01, 0x74, 0x01, // AŴ (U+0041 U+0174)
  0x00, 0x41, 0x01, 0x76, 0x01, // AŶ (U+0041 U+0176)
  0x00, 0x41, 0x01, 0x78, 0x01, // AŸ (U+0041 U+0178)
  0x00, 0x41, 0x20, 0x18, 0x01, // A‘ (U+0041 U+2018)
  0x00, 0x41, 0x20, 0x19, 0x01, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1C, 0x01, // A“ (U+0041 U+201C)
  0x00, 0x41, 0x20, 0x1D, 0x01, // A” (U+0041 U+201D)
  0x00, 0x41, 0x21, 0x22, 0x01, // A™ (U+0041 U+2122)
  0x00, 0x46, 0x00, 0x2C, 0x01, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x01, // F. (U+0046 U+002E)
  0x00, 0x46, 0x00, 0x41, 0x01, // FA (U+0046 U+0041)
  0x00, 0x46, 0x00, 0xC0, 0x01, // FÀ (U+0046 U+00C0)
  0x00, 0x46, 0x00, 0xC1, 0x01, // FÁ (U+0046 U+00C1)
  0x00, 0x46, 0x00, 0xC2, 0x01, // FÂ (U+0046 U+00C2)
  0x00, 0x46, 0x00, 0xC3, 0x01, // FÃ (U+0046 U+00C3)
  0x00, 0x46, 0x00, 0xC4, 0x01, // FÄ (U+0046 U+00C4)
  0x00, 0x46, 0x00, 0xC5, 0x01, // FÅ (U+0046 U+00C5)
  0x00, 0x46, 0x00, 0xC6, 0x01, // FÆ (U+0046 U+00C6)
  0x00, 0x46, 0x01, 0x00, 0x01, // FĀ (U+0046 U+0100)
  0x00, 0x46, 0x01, 0x02, 0x01, // FĂ (U+0046 U+0102)
  0x00, 0x46, 0x01, 0x04, 0x01, // FĄ (U+0046 U+0104)
  0x00, 0x46, 0x20, 0x1A, 0x01, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x01, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x01, // F… (U+0046 U+2026)
  0x00, 0x4C, 0x00, 0x2A, 0x01, // L* (U+004C U+002A)
  0x00, 0x4C, 0x00, 0x3F, 0x01, // L? (U+004C U+003F)
  0x00, 0x4C, 0x00, 0x54, 0x01, // LT (U+004C U+0054)
  0x00, 0x4C, 0x01, 0x62, 0x01, // LŢ (U+004C U+0162)
  0x00, 0x4C, 0x01, 0x64, 0x01, // LŤ (U+004C U+0164)
  0x00, 0x4C, 0x01, 0x66, 0x01, // LŦ (U+004C U+0166)
  0x00, 0x4C, 0x20, 0x18, 0x01, // L‘ (U+004C U+2018)
  0x00, 0x4C, 0x20, 0x19, 0x01, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1C, 0x01, // L“ (U+004C U+201C)
  0x00, 0x4C, 0x20, 0x1D, 0x01, // L” (U+004C U+201D)
  0x00, 0x4C, 0x21, 0x22, 0x01, // L™ (U+004C U+2122)
  0x00, 0x50, 0x00, 0x2C, 0x01, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x01, // P. (U+0050 U+002E)
  0x00, 0x50, 0x00, 0xC6, 0x01, // PÆ (U+0050 U+00C6)
  0x00, 0x50, 0x20, 0x1A, 0x01, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x01, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x01, // P… (U+0050 U+2026)
  0x00, 0x54, 0x00, 0x2C, 0x01, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2E, 0x01, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0xC6, 0x01, // TÆ (U+0054 U+00C6)
  0x00, 0x54, 0x20, 0x1A, 0x01, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x01, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x01, // T… (U+0054 U+2026)
  0x00, 0x56, 0x00, 0x2C, 0x01, // V, (U+0056 U+002C)
  0x00, 0x56, 0x00, 0x2E, 0x01, // V. (U+0056 U+002E)
  0x00, 0x56, 0x00, 0x41, 0x01, // VA (U+0056 U+0041)
  0x00, 0x56, 0x00, 0xC0, 0x01, // VÀ (U+0056 U+00C0)
  0x00, 0x56, 0x00, 0xC1, 0x01, // VÁ (U+0056 U+00C1)
  0x00, 0x56, 0x00, 0xC2, 0x01, // VÂ (U+0056 U+00C2)
  0x00, 0x56, 0x00, 0xC3, 0x01, // VÃ (U+0056 U+00C3)
  0x00, 0x56, 0x00, 0xC4, 0x01, // VÄ (U+0056 U+00C4)
  0x00, 0x56, 0x00, 0xC5, 0x01, // VÅ (U+0056 U+00C5)
  0x00, 0x56, 0x00, 0xC6, 0x01, // VÆ (U+0056 U+00C6)
  0x00, 0x56, 0x01, 0x00, 0x01, // VĀ (U+0056 U+0100)
  0x00, 0x56, 0x01, 0x02, 0x01, // VĂ (U+0056 U+0102)
  0x00, 0x56, 0x01, 0x04, 0x01, // VĄ (U+0056 U+0104)
  0x00, 0x56, 0x20, 0x1A, 0x01, // V‚ (U+0056 U+201A)
  0x00, 0x56, 0x20, 0x1E, 0x01, // V„ (U+0056 U+201E)
  0x00, 0x56, 0x20, 0x26, 0x01, // V… (U+0056 U+2026)
  0x00, 0x57, 0x00, 0x2C, 0x01, // W, (U+0057 U+002C)
  0x00, 0x57, 0x00, 0x2E, 0x01, // W. (U+0057 U+002E)
  0x00, 0x57, 0x00, 0x41, 0x01, // WA (U+0057 U+0041)
  0x00, 0x57, 0x00, 0x61, 0x01, // Wa (U+0057 U+0061)
  0x00, 0x57, 0x00, 0xC0, 0x01, // WÀ (U+0057 U+00C0)
  0x00, 0x57, 0x00, 0xC1, 0x01, // WÁ (U+0057 U+00C1)
  0x00, 0x57, 0x00, 0xC2, 0x01, // WÂ (U+0057 U+00C2)
  0x00, 0x57, 0x00, 0xC3, 0x01, // WÃ (U+0057 U+00C3)
  0x00, 0x57, 0x00, 0xC4, 0x01, // WÄ (U+0057 U+00C4)
  0x00, 0x57, 0x00, 0xC5, 0x01, // WÅ (U+0057 U+00C5)
  0x00, 0x57, 0x00, 0xC6, 0x01, // WÆ (U+0057 U+00C6)
  0x00, 0x57, 0x00, 0xE0, 0x01, // Wà (U+0057 U+00E0)
  0x00, 0x57, 0x00, 0xE1, 0x01, // Wá (U+0057 U+00E1)
  0x00, 0x57, 0x00, 0xE2, 0x01, // Wâ (U+0057 U+00E2)
  0x00, 0x57, 0x00, 0xE3, 0x01, // Wã (U+0057 U+00E3)
  0x00, 0x57, 0x00, 0xE4, 0x01, // Wä (U+0057 U+00E4)
  0x00, 0x57, 0x00, 0xE5, 0x01, // Wå (U+0057 U+00E5)
  0x00, 0x57, 0x00, 0xE6, 0x01, // Wæ (U+0057 U+00E6)
  0x00, 0x57, 0x01, 0x00, 0x01, // WĀ (U+0057 U+0100)
  0x00, 0x57, 0x01, 0x01, 0x01, // Wā (U+0057 U+0101)
  0x00, 0x57, 0x01, 0x02, 0x01, // WĂ (U+0057 U+0102)
  0x00, 0x57, 0x01, 0x03, 0x01, // Wă (U+0057 U+0103)
  0x00, 0x57, 0x01, 0x04, 0x01, // WĄ (U+0057 U+0104)
  0x00, 0x57, 0x01, 0x05, 0x01, // Wą (U+0057 U+0105)
  0x00, 0x57, 0x20, 0x1A, 0x01, // W‚ (U+0057 U+201A)
  0x00, 0x57, 0x20, 0x1E, 0x01, // W„ (U+0057 U+201E)
  0x00, 0x57, 0x20, 0x26, 0x01, // W… (U+0057 U+2026)
  0x00, 0x59, 0x00, 0x2C, 0x01, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x01, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x00, 0x41, 0x01, // YA (U+0059 U+0041)
  0x00, 0x59, 0x00, 0x63, 0x01, // Yc (U+0059 U+0063)
  0x00, 0x59, 0x00, 0x64, 0x01, // Yd (U+0059 U+0064)
  0x00, 0x59, 0x00, 0x65, 0x01, // Ye (U+0059 U+0065)
  0x00, 0x59, 0x00, 0x67, 0x01, // Yg (U+0059 U+0067)
  0x00, 0x59, 0x00, 0x6F, 0x01, // Yo (U+0059 U+006F)
  0x00, 0x59, 0x00, 0x71, 0x01, // Yq (U+0059 U+0071)
  0x00, 0x59, 0x00, 0xC0, 0x01, // YÀ (U+0059 U+00C0)
  0x00, 0x59, 0x00, 0xC1, 0x01, // YÁ (U+0059 U+00C1)
  0x00, 0x59, 0x00, 0xC2, 0x01, // YÂ (U+0059 U+00C2)
  0x00, 0x59, 0x00, 0xC3, 0x01, // YÃ (U+0059 U+00C3)
  0x00, 0x59, 0x00, 0xC4, 0x01, // YÄ (U+0059 U+00C4)
  0x00, 0x59, 0x00, 0xC5, 0x01, // YÅ (U+0059 U+00C5)
  0x00, 0x59, 0x00, 0xC6, 0x01, // YÆ (U+0059 U+00C6)
  0x00, 0x59, 0x00, 0xE7, 0x01, // Yç (U+0059 U+00E7)
  0x00, 0x59, 0x00, 0xE8, 0x01, // Yè (U+0059 U+00E8)
  0x00, 0x59, 0x00, 0xE9, 0x01, // Yé (U+0059 U+00E9)
  0x00, 0x59, 0x00, 0xEA, 0x01, // Yê (U+0059 U+00EA)
  0x00, 0x59, 0x00, 0xEB, 0x01, // Yë (U+0059 U+00EB)
  0x00, 0x59, 0x00, 0xF0, 0x01, // Yð (U+0059 U+00F0)
  0x00, 0x59, 0x00, 0xF2, 0x01, // Yò (U+0059 U+00F2)
  0x00, 0x59, 0x00, 0xF3, 0x01, // Yó (U+0059 U+00F3)
  0x00, 0x59, 0x00, 0xF4, 0x01, // Yô (U+0059 U+00F4)
  0x00, 0x59, 0x00, 0xF5, 0x01, // Yõ (U+0059 U+00F5)
  0x00, 0x59, 0x00, 0xF6, 0x01, // Yö (U+0059 U+00F6)
  0x00, 0x59, 0x00, 0xF8, 0x01, // Yø (U+0059 U+00F8)
  0x00, 0x59, 0x01, 0x00, 0x01, // YĀ (U+0059 U+0100)
  0x00, 0x59, 0x01, 0x02, 0x01, // YĂ (U+0059 U+0102)
  0x00, 0x59, 0x01, 0x04, 0x01, // YĄ (U+0059 U+0104)
  0x00, 0x59, 0x01, 0x07, 0x01, // Yć (U+0059 U+0107)
  0x00, 0x59, 0x01, 0x09, 0x01, // Yĉ (U+0059 U+0109)
  0x00, 0x59, 0x01, 0x0B, 0x01, // Yċ (U+0059 U+010B)
  0x00, 0x59, 0x01, 0x0D, 0x01, // Yč (U+0059 U+010D)
  0x00, 0x59, 0x01, 0x0F, 0x01, // Yď (U+0059 U+010F)
  0x00, 0x59, 0x01, 0x11, 0x01, // Yđ (U+0059 U+0111)
  0x00, 0x59, 0x01, 0x13, 0x01, // Yē (U+0059 U+0113)
  0x00, 0x59, 0x01, 0x15, 0x01, // Yĕ (U+0059 U+0115)
  0x00, 0x59, 0x01, 0x17, 0x01, // Yė (U+0059 U+0117)
  0x00, 0x59, 0x01, 0x19, 0x01, // Yę (U+0059 U+0119)
  0x00, 0x59, 0x01, 0x1B, 0x01, // Yě (U+0059 U+011B)
  0x00, 0x59, 0x01, 0x1D, 0x01, // Yĝ (U+0059 U+011D)
  0x00, 0x59, 0x01, 0x1F, 0x01, // Yğ (U+0059 U+011F)
  0x00, 0x59, 0x01, 0x21, 0x01, // Yġ (U+0059 U+0121)
  0x00, 0x59, 0x01, 0x23, 0x01, // Yģ (U+0059 U+0123)
  0x00, 0x59, 0x01, 0x4D, 0x01, // Yō (U+0059 U+014D)
  0x00, 0x59, 0x01, 0x4F, 0x01, // Yŏ (U+0059 U+014F)
  0x00, 0x59, 0x01, 0x51, 0x01, // Yő (U+0059 U+0151)
  0x00, 0x59, 0x01, 0x53, 0x01, // Yœ (U+0059 U+0153)
  0x00, 0x59, 0x20, 0x1A, 0x01, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x01, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x01, // Y… (U+0059 U+2026)
  0x00, 0x62, 0x00, 0x59, 0x01, // bY (U+0062 U+0059)
  0x00, 0x62, 0x00, 0xDD, 0x01, // bÝ (U+0062 U+00DD)
  0x00, 0x62, 0x01, 0x76, 0x01, // bŶ (U+0062 U+0176)
  0x00, 0x62, 0x01, 0x78, 0x01, // bŸ (U+0062 U+0178)
  0x00, 0x6F, 0x00, 0x59, 0x01, // oY (U+006F U+0059)
  0x00, 0x6F, 0x00, 0xDD, 0x01, // oÝ (U+006F U+00DD)
  0x00, 0x6F, 0x01, 0x76, 0x01, // oŶ (U+006F U+0176)
  0x00, 0x6F, 0x01, 0x78, 0x01, // oŸ (U+006F U+0178)
  0x00, 0x70, 0x00, 0x59, 0x01, // pY (U+0070 U+0059)
  0x00, 0x70, 0x00, 0xDD, 0x01, // pÝ (U+0070 U+00DD)
  0x00, 0x70, 0x01, 0x76, 0x01, // pŶ (U+0070 U+0176)
  0x00, 0x70, 0x01, 0x78, 0x01, // pŸ (U+0070 U+0178)
  0x00, 0x72, 0x00, 0x2C, 0x01, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x01, // r. (U+0072 U+002E)
  0x00, 0x72, 0x20, 0x1A, 0x01, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x01, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x01, // r… (U+0072 U+2026)
  0x00, 0x76, 0x00, 0x2E, 0x01, // v. (U+0076 U+002E)
  0x00, 0x76, 0x20, 0x1A, 0x01, // v‚ (U+0076 U+201A)
  0x00, 0x76, 0x20, 0x1E, 0x01, // v„ (U+0076 U+201E)
  0x00, 0x76, 0x20, 0x26, 0x01, // v… (U+0076 U+2026)
  0x00, 0x77, 0x00, 0x2C, 0x01, // w, (U+0077 U+002C)
  0x00, 0x77, 0x00, 0x2E, 0x01, // w. (U+0077 U+002E)
  0x00, 0x77, 0x20, 0x1A, 0x01, // w‚ (U+0077 U+201A)
  0x00, 0x77, 0x20, 0x1E, 0x01, // w„ (U+0077 U+201E)
  0x00, 0x77, 0x20, 0x26, 0x01, // w… (U+0077 U+2026)
  0x00, 0x79, 0x00, 0x2C, 0x01, // y, (U+0079 U+002C)
  0x00, 0x79, 0x00, 0x2E, 0x01, // y. (U+0079 U+002E)
  0x00, 0x79, 0x20, 0x1A, 0x01, // y‚ (U+0079 U+201A)
  0x00, 0x79, 0x20, 0x1E, 0x01, // y„ (U+0079 U+201E)
  0x00, 0x79, 0x20, 0x26, 0x01, // y… (U+0079 U+2026)
  0x00, 0xC0, 0x00, 0x22, 0x01, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x01, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x00, 0x2A, 0x01, // À* (U+00C0 U+002A)
  0x00, 0xC0, 0x00, 0x56, 0x01, // ÀV (U+00C0 U+0056)
  0x00, 0xC0, 0x00, 0x57, 0x01, // ÀW (U+00C0 U+0057)
  0x00, 0xC0, 0x00, 0x59, 0x01, // ÀY (U+00C0 U+0059)
  0x00, 0xC0, 0x00, 0xDD, 0x01, // ÀÝ (U+00C0 U+00DD)
  0x00, 0xC0, 0x01, 0x74, 0x01, // ÀŴ (U+00C0 U+0174)
  0x00, 0xC0, 0x01, 0x76, 0x01, // ÀŶ (U+00C0 U+0176)
  0x00, 0xC0, 0x01, 0x78, 0x01, // ÀŸ (U+00C0 U+0178)
  0x00, 0xC0, 0x20, 0x18, 0x01, // À‘ (U+00C0 U+2018)
  0x00, 0xC0, 0x20, 0x19, 0x01, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1C, 0x01, // À“ (U+00C0 U+201C)
  0x00, 0xC0, 0x20, 0x1D, 0x01, // À” (U+00C0 U+201D)
  0x00, 0xC0, 0x21, 0x22, 0x01, // À™ (U+00C0 U+2122)
  0x00, 0xC1, 0x00, 0x22, 0x01, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x01, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x00, 0x2A, 0x01, // Á* (U+00C1 U+002A)
  0x00, 0xC1, 0x00, 0x56, 0x01, // ÁV (U+00C1 U+0056)
  0x00, 0xC1, 0x00, 0x57, 0x01, // ÁW (U+00C1 U+0057)
  0x00, 0xC1, 0x00, 0x59, 0x01, // ÁY (U+00C1 U+0059)
  0x00, 0xC1, 0x00, 0xDD, 0x01, // ÁÝ (U+00C1 U+00DD)
  0x00, 0xC1, 0x01, 0x74, 0x01, // ÁŴ (U+00C1 U+0174)
  0x00, 0xC1, 0x01, 0x76, 0x01, // ÁŶ (U+00C1 U+0176)
  0x00, 0xC1, 0x01, 0x78, 0x01, // ÁŸ (U+00C1 U+0178)
  0x00, 0xC1, 0x20, 0x18, 0x01, // Á‘ (U+00C1 U+2018)
  0x00, 0xC1, 0x20, 0x19, 0x01, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1C, 0x01, // Á“ (U+00C1 U+201C)
  0x00, 0xC1, 0x20, 0x1D, 0x01, // Á” (U+00C1 U+201D)
  0x00, 0xC1, 0x21, 0x22, 0x01, // Á™ (U+00C1 U+2122)
  0x00, 0xC2, 0x00, 0x22, 0x01, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x01, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x00, 0x2A, 0x01, // Â* (U+00C2 U+002A)
  0x00, 0xC2, 0x00, 0x56, 0x01, // ÂV (U+00C2 U+0056)
  0x00, 0xC2, 0x00, 0x57, 0x01, // ÂW (U+00C2 U+0057)
  0x00, 0xC2, 0x00, 0x59, 0x01, // ÂY (U+00C2 U+0059)
  0x00, 0xC2, 0x00, 0xDD, 0x01, // ÂÝ (U+00C2 U+00DD)
  0x00, 0xC2, 0x01, 0x74, 0x01, // ÂŴ (U+00C2 U+0174)
  0x00, 0xC2, 0x01, 0x76, 0x01, // ÂŶ (U+00C2 U+0176)
  0x00, 0xC2, 0x01, 0x78, 0x01, // ÂŸ (U+00C2 U+0178)
  0x00, 0xC2, 0x20, 0x18, 0x01, // Â‘ (U+00C2 U+2018)
  0x00, 0xC2, 0x20, 0x19, 0x01, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1C, 0x01, // Â“ (U+00C2 U+201C)
  0x00, 0xC2, 0x20, 0x1D, 0x01, // Â” (U+00C2 U+201D)
  0x00, 0xC2, 0x21, 0x22, 0x01, // Â™ (U+00C2 U+2122)
  0x00, 0xC3, 0x00, 0x22, 0x01, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x01, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x00, 0x2A, 0x01, // Ã* (U+00C3 U+002A)
  0x00, 0xC3, 0x00, 0x56, 0x01, // ÃV (U+00C3 U+0056)
  0x00, 0xC3, 0x00, 0x57, 0x01, // ÃW (U+00C3 U+0057)
  0x00, 0xC3, 0x00, 0x59, 0x01, // ÃY (U+00C3 U+0059)
  0x00, 0xC3, 0x00, 0xDD, 0x01, // ÃÝ (U+00C3 U+00DD)
  0x00, 0xC3, 0x01, 0x74, 0x01, // ÃŴ (U+00C3 U+0174)
  0x00, 0xC3, 0x01, 0x76, 0x01, // ÃŶ (U+00C3 U+0176)
  0x00, 0xC3, 0x01, 0x78, 0x01, // ÃŸ (U+00C3 U+0178)
  0x00, 0xC3, 0x20, 0x18, 0x01, // Ã‘ (U+00C3 U+2018)
  0x00, 0xC3, 0x20, 0x19, 0x01, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1C, 0x01, // Ã“ (U+00C3 U+201C)
  0x00, 0xC3, 0x20, 0x1D, 0x01, // Ã” (U+00C3 U+201D)
  0x00, 0xC3, 0x21, 0x22, 0x01, // Ã™ (U+00C3 U+2122)
  0x00, 0xC4, 0x00, 0x22, 0x01, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x01, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x00, 0x2A, 0x01, // Ä* (U+00C4 U+002A)
  0x00, 0xC4, 0x00, 0x56, 0x01, // ÄV (U+00C4 U+0056)
  0x00, 0xC4, 0x00, 0x57, 0x01, // ÄW (U+00C4 U+0057)
  0x00, 0xC4, 0x00, 0x59, 0x01, // ÄY (U+00C4 U+0059)
  0x00, 0xC4, 0x00, 0xDD, 0x01, // ÄÝ (U+00C4 U+00DD)
  0x00, 0xC4, 0x01, 0x74, 0x01, // ÄŴ (U+00C4 U+0174)
  0x00, 0xC4, 0x01, 0x76, 0x01, // ÄŶ (U+00C4 U+0176)
  0x00, 0xC4, 0x01, 0x78, 0x01, // ÄŸ (U+00C4 U+0178)
  0x00, 0xC4, 0x20, 0x18, 0x01, // Ä‘ (U+00C4 U+2018)
  0x00, 0xC4, 0x20, 0x19, 0x01, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1C, 0x01, // Ä“ (U+00C4 U+201C)
  0x00, 0xC4, 0x20, 0x1D, 0x01, // Ä” (U+00C4 U+201D)
  0x00, 0xC4, 0x21, 0x22, 0x01, // Ä™ (U+00C4 U+2122)
  0x00, 0xC5, 0x00, 0x22, 0x01, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x01, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x00, 0x2A, 0x01, // Å* (U+00C5 U+002A)
  0x00, 0xC5, 0x00, 0x56, 0x01, // ÅV (U+00C5 U+0056)
  0x00, 0xC5, 0x00, 0x57, 0x01, // ÅW (U+00C5 U+0057)
  0x00, 0xC5, 0x00, 0x59, 0x01, // ÅY (U+00C5 U+0059)
  0x00, 0xC5, 0x00, 0xDD, 0x01, // ÅÝ (U+00C5 U+00DD)
  0x00, 0xC5, 0x01, 0x74, 0x01, // ÅŴ (U+00C5 U+0174)
  0x00, 0xC5, 0x01, 0x76, 0x01, // ÅŶ (U+00C5 U+0176)
  0x00, 0xC5, 0x01, 0x78, 0x01, // ÅŸ (U+00C5 U+0178)
  0x00, 0xC5, 0x20, 0x18, 0x01, // Å‘ (U+00C5 U+2018)
  0x00, 0xC5, 0x20, 0x19, 0x01, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1C, 0x01, // Å“ (U+00C5 U+201C)
  0x00, 0xC5, 0x20, 0x1D, 0x01, // Å” (U+00C5 U+201D)
  0x00, 0xC5, 0x21, 0x22, 0x01, // Å™ (U+00C5 U+2122)
  0x00, 0xDD, 0x00, 0x2C, 0x01, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x01, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x00, 0x41, 0x01, // ÝA (U+00DD U+0041)
  0x00, 0xDD, 0x00, 0x63, 0x01, // Ýc (U+00DD U+0063)
  0x00, 0xDD, 0x00, 0x64, 0x01, // Ýd (U+00DD U+0064)
  0x00, 0xDD, 0x00, 0x65, 0x01, // Ýe (U+00DD U+0065)
  0x00, 0xDD, 0x00, 0x67, 0x01, // Ýg (U+00DD U+0067)
  0x00, 0xDD, 0x00, 0x6F, 0x01, // Ýo (U+00DD U+006F)
  0x00, 0xDD, 0x00, 0x71, 0x01, // Ýq (U+00DD U+0071)
  0x00, 0xDD, 0x00, 0xC0, 0x01, // ÝÀ (U+00DD U+00C0)
  0x00, 0xDD, 0x00, 0xC1, 0x01, // ÝÁ (U+00DD U+00C1)
  0x00, 0xDD, 0x00, 0xC2, 0x01, // ÝÂ (U+00DD U+00C2)
  0x00, 0xDD, 0x00, 0xC3, 0x01, // ÝÃ (U+00DD U+00C3)
  0x00, 0xDD, 0x00, 0xC4, 0x01, // ÝÄ (U+00DD U+00C4)
  0x00, 0xDD, 0x00, 0xC5, 0x01, // ÝÅ (U+00DD U+00C5)
  0x00, 0xDD, 0x00, 0xC6, 0x01, // ÝÆ (U+00DD U+00C6)
  0x00, 0xDD, 0x00, 0xE7, 0x01, // Ýç (U+00DD U+00E7)
  0x00, 0xDD, 0x00, 0xE8, 0x01, // Ýè (U+00DD U+00E8)
  0x00, 0xDD, 0x00, 0xE9, 0x01, // Ýé (U+00DD U+00E9)
  0x00, 0xDD, 0x00, 0xEA, 0x01, // Ýê (U+00DD U+00EA)
  0x00, 0xDD, 0x00, 0xEB, 0x01, // Ýë (U+00DD U+00EB)
  0x00, 0xDD, 0x00, 0xF0, 0x01, // Ýð (U+00DD U+00F0)
  0x00, 0xDD, 0x00, 0xF2, 0x01, // Ýò (U+00DD U+00F2)
  0x00, 0xDD, 0x00, 0xF3, 0x01, // Ýó (U+00DD U+00F3)
  0x00, 0xDD, 0x00, 0xF4, 0x01, // Ýô (U+00DD U+00F4)
  0x00, 0xDD, 0x00, 0xF5, 0x01, // Ýõ (U+00DD U+00F5)
  0x00, 0xDD, 0x00, 0xF6, 0x01, // Ýö (U+00DD U+00F6)
  0x00, 0xDD, 0x00, 0xF8, 0x01, // Ýø (U+00DD U+00F8)
  0x00, 0xDD, 0x01, 0x00, 0x01, // ÝĀ (U+00DD U+0100)
  0x00, 0xDD, 0x01, 0x02, 0x01, // ÝĂ (U+00DD U+0102)
  0x00, 0xDD, 0x01, 0x04, 0x01, // ÝĄ (U+00DD U+0104)
  0x00, 0xDD, 0x01, 0x07, 0x01, // Ýć (U+00DD U+0107)
  0x00, 0xDD, 0x01, 0x09, 0x01, // Ýĉ (U+00DD U+0109)
  0x00, 0xDD, 0x01, 0x0B, 0x01, // Ýċ (U+00DD U+010B)
  0x00, 0xDD, 0x01, 0x0D, 0x01, // Ýč (U+00DD U+010D)
  0x00, 0xDD, 0x01, 0x0F, 0x01, // Ýď (U+00DD U+010F)
  0x00, 0xDD, 0x01, 0x11, 0x01, // Ýđ (U+00DD U+0111)
  0x00, 0xDD, 0x01, 0x13, 0x01, // Ýē (U+00DD U+0113)
  0x00, 0xDD, 0x01, 0x15, 0x01, // Ýĕ (U+00DD U+0115)
  0x00, 0xDD, 0x01, 0x17, 0x01, // Ýė (U+00DD U+0117)
  0x00, 0xDD, 0x01, 0x19, 0x01, // Ýę (U+00DD U+0119)
  0x00, 0xDD, 0x01, 0x1B, 0x01, // Ýě (U+00DD U+011B)
  0x00, 0xDD, 0x01, 0x1D, 0x01, // Ýĝ (U+00DD U+011D)
  0x00, 0xDD, 0x01, 0x1F, 0x01, // Ýğ (U+00DD U+011F)
  0x00, 0xDD, 0x01, 0x21, 0x01, // Ýġ (U+00DD U+0121)
  0x00, 0xDD, 0x01, 0x23, 0x01, // Ýģ (U+00DD U+0123)
  0x00, 0xDD, 0x01, 0x4D, 0x01, // Ýō (U+00DD U+014D)
  0x00, 0xDD, 0x01, 0x4F, 0x01, // Ýŏ (U+00DD U+014F)
  0x00, 0xDD, 0x01, 0x51, 0x01, // Ýő (U+00DD U+0151)
  0x00, 0xDD, 0x01, 0x53, 0x01, // Ýœ (U+00DD U+0153)
  0x00, 0xDD, 0x20, 0x1A, 0x01, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x01, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x01, // Ý… (U+00DD U+2026)
  0x00, 0xDF, 0x00, 0x59, 0x01, // ßY (U+00DF U+0059)
  0x00, 0xDF, 0x00, 0xDD, 0x01, // ßÝ (U+00DF U+00DD)
  0x00, 0xDF, 0x01, 0x76, 0x01, // ßŶ (U+00DF U+0176)
  0x00, 0xDF, 0x01, 0x78, 0x01, // ßŸ (U+00DF U+0178)
  0x00, 0xF0, 0x00, 0x59, 0x01, // ðY (U+00F0 U+0059)
  0x00, 0xF0, 0x00, 0xDD, 0x01, // ðÝ (U+00F0 U+00DD)
  0x00, 0xF0, 0x01, 0x76, 0x01, // ðŶ (U+00F0 U+0176)
  0x00, 0xF0, 0x01, 0x78, 0x01, // ðŸ (U+00F0 U+0178)
  0x00, 0xF2, 0x00, 0x59, 0x01, // òY (U+00F2 U+0059)
  0x00, 0xF2, 0x00, 0xDD, 0x01, // òÝ (U+00F2 U+00DD)
  0x00, 0xF2, 0x01, 0x76, 0x01, // òŶ (U+00F2 U+0176)
  0x00, 0xF2, 0x01, 0x78, 0x01, // òŸ (U+00F2 U+0178)
  0x00, 0xF3, 0x00, 0x59, 0x01, // óY (U+00F3 U+0059)
  0x00, 0xF3, 0x00, 0xDD, 0x01, // óÝ (U+00F3 U+00DD)
  0x00, 0xF3, 0x01, 0x76, 0x01, // óŶ (U+00F3 U+0176)
  0x00, 0xF3, 0x01, 0x78, 0x01, // óŸ (U+00F3 U+0178)
  0x00, 0xF4, 0x00, 0x59, 0x01, // ôY (U+00F4 U+0059)
  0x00, 0xF4, 0x00, 0xDD, 0x01, // ôÝ (U+00F4 U+00DD)
  0x00, 0xF4, 0x01, 0x76, 0x01, // ôŶ (U+00F4 U+0176)
  0x00, 0xF4, 0x01, 0x78, 0x01, // ôŸ (U+00F4 U+0178)
  0x00, 0xF5, 0x00, 0x59, 0x01, // õY (U+00F5 U+0059)
  0x00, 0xF5, 0x00, 0xDD, 0x01, // õÝ (U+00F5 U+00DD)
  0x00, 0xF5, 0x01, 0x76, 0x01, // õŶ (U+00F5 U+0176)
  0x00, 0xF5, 0x01, 0x78, 0x01, // õŸ (U+00F5 U+0178)
  0x00, 0xF6, 0x00, 0x59, 0x01, // öY (U+00F6 U+0059)
  0x00, 0xF6, 0x00, 0xDD, 0x01, // öÝ (U+00F6 U+00DD)
  0x00, 0xF6, 0x01, 0x76, 0x01, // öŶ (U+00F6 U+0176)
  0x00, 0xF6, 0x01, 0x78, 0x01, // öŸ (U+00F6 U+0178)
  0x00, 0xF8, 0x00, 0x59, 0x01, // øY (U+00F8 U+0059)
  0x00, 0xF8, 0x00, 0xDD, 0x01, // øÝ (U+00F8 U+00DD)
  0x00, 0xF8, 0x01, 0x76, 0x01, // øŶ (U+00F8 U+0176)
  0x00, 0xF8, 0x01, 0x78, 0x01, // øŸ (U+00F8 U+0178)
  0x00, 0xFD, 0x00, 0x2C, 0x01, // ý, (U+00FD U+002C)
  0x00, 0xFD, 0x00, 0x2E, 0x01, // ý. (U+00FD U+002E)
  0x00, 0xFD, 0x20, 0x1A, 0x01, // ý‚ (U+00FD U+201A)
  0x00, 0xFD, 0x20, 0x1E, 0x01, // ý„ (U+00FD U+201E)
  0x00, 0xFD, 0x20, 0x26, 0x01, // ý… (U+00FD U+2026)
  0x00, 0xFE, 0x00, 0x59, 0x01, // þY (U+00FE U+0059)
  0x00, 0xFE, 0x00, 0xDD, 0x01, // þÝ (U+00FE U+00DD)
  0x00, 0xFE, 0x01, 0x76, 0x01, // þŶ (U+00FE U+0176)
  0x00, 0xFE, 0x01, 0x78, 0x01, // þŸ (U+00FE U+0178)
  0x00, 0xFF, 0x00, 0x2C, 0x01, // ÿ, (U+00FF U+002C)
  0x00, 0xFF, 0x00, 0x2E, 0x01, // ÿ. (U+00FF U+002E)
  0x00, 0xFF, 0x20, 0x1A, 0x01, // ÿ‚ (U+00FF U+201A)
  0x00, 0xFF, 0x20, 0x1E, 0x01, // ÿ„ (U+00FF U+201E)
  0x00, 0xFF, 0x20, 0x26, 0x01, // ÿ… (U+00FF U+2026)
  0x01, 0x00, 0x00, 0x22, 0x01, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x01, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x00, 0x2A, 0x01, // Ā* (U+0100 U+002A)
  0x01, 0x00, 0x00, 0x56, 0x01, // ĀV (U+0100 U+0056)
  0x01, 0x00, 0x00, 0x57, 0x01, // ĀW (U+0100 U+0057)
  0x01, 0x00, 0x00, 0x59, 0x01, // ĀY (U+0100 U+0059)
  0x01, 0x00, 0x00, 0xDD, 0x01, // ĀÝ (U+0100 U+00DD)
  0x01, 0x00, 0x01, 0x74, 0x01, // ĀŴ (U+0100 U+0174)
  0x01, 0x00, 0x01, 0x76, 0x01, // ĀŶ (U+0100 U+0176)
  0x01, 0x00, 0x01, 0x78, 0x01, // ĀŸ (U+0100 U+0178)
  0x01, 0x00, 0x20, 0x18, 0x01, // Ā‘ (U+0100 U+2018)
  0x01, 0x00, 0x20, 0x19, 0x01, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1C, 0x01, // Ā“ (U+0100 U+201C)
  0x01, 0x00, 0x20, 0x1D, 0x01, // Ā” (U+0100 U+201D)
  0x01, 0x00, 0x21, 0x22, 0x01, // Ā™ (U+0100 U+2122)
  0x01, 0x02, 0x00, 0x22, 0x01, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x01, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x00, 0x2A, 0x01, // Ă* (U+0102 U+002A)
  0x01, 0x02, 0x00, 0x56, 0x01, // ĂV (U+0102 U+0056)
  0x01, 0x02, 0x00, 0x57, 0x01, // ĂW (U+0102 U+0057)
  0x01, 0x02, 0x00, 0x59, 0x01, // ĂY (U+0102 U+0059)
  0x01, 0x02, 0x00, 0xDD, 0x01, // ĂÝ (U+0102 U+00DD)
  0x01, 0x02, 0x01, 0x74, 0x01, // ĂŴ (U+0102 U+0174)
  0x01, 0x02, 0x01, 0x76, 0x01, // ĂŶ (U+0102 U+0176)
  0x01, 0x02, 0x01, 0x78, 0x01, // ĂŸ (U+0102 U+0178)
  0x01, 0x02, 0x20, 0x18, 0x01, // Ă‘ (U+0102 U+2018)
  0x01, 0x02, 0x20, 0x19, 0x01, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1C, 0x01, // Ă“ (U+0102 U+201C)
  0x01, 0x02, 0x20, 0x1D, 0x01, // Ă” (U+0102 U+201D)
  0x01, 0x02, 0x21, 0x22, 0x01, // Ă™ (U+0102 U+2122)
  0x01, 0x04, 0x00, 0x22, 0x01, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x01, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x00, 0x2A, 0x01, // Ą* (U+0104 U+002A)
  0x01, 0x04, 0x00, 0x56, 0x01, // ĄV (U+0104 U+0056)
  0x01, 0x04, 0x00, 0x57, 0x01, // ĄW (U+0104 U+0057)
  0x01, 0x04, 0x00, 0x59, 0x01, // ĄY (U+0104 U+0059)
  0x01, 0x04, 0x00, 0xDD, 0x01, // ĄÝ (U+0104 U+00DD)
  0x01, 0x04, 0x01, 0x74, 0x01, // ĄŴ (U+0104 U+0174)
  0x01, 0x04, 0x01, 0x76, 0x01, // ĄŶ (U+0104 U+0176)
  0x01, 0x04, 0x01, 0x78, 0x01, // ĄŸ (U+0104 U+0178)
  0x01, 0x04, 0x20, 0x18, 0x01, // Ą‘ (U+0104 U+2018)
  0x01, 0x04, 0x20, 0x19, 0x01, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1C, 0x01, // Ą“ (U+0104 U+201C)
  0x01, 0x04, 0x20, 0x1D, 0x01, // Ą” (U+0104 U+201D)
  0x01, 0x04, 0x21, 0x22, 0x01, // Ą™ (U+0104 U+2122)
  0x01, 0x39, 0x00, 0x2A, 0x01, // Ĺ* (U+0139 U+002A)
  0x01, 0x39, 0x00, 0x3F, 0x01, // Ĺ? (U+0139 U+003F)
  0x01, 0x39, 0x00, 0x54, 0x01, // ĹT (U+0139 U+0054)
  0x01, 0x39, 0x01, 0x62, 0x01, // ĹŢ (U+0139 U+0162)
  0x01, 0x39, 0x01, 0x64, 0x01, // ĹŤ (U+0139 U+0164)
  0x01, 0x39, 0x01, 0x66, 0x01, // ĹŦ (U+0139 U+0166)
  0x01, 0x39, 0x20, 0x18, 0x01, // Ĺ‘ (U+0139 U+2018)
  0x01, 0x39, 0x20, 0x19, 0x01, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1C, 0x01, // Ĺ“ (U+0139 U+201C)
  0x01, 0x39, 0x20, 0x1D, 0x01, // Ĺ” (U+0139 U+201D)
  0x01, 0x39, 0x21, 0x22, 0x01, // Ĺ™ (U+0139 U+2122)
  0x01, 0x3B, 0x00, 0x2A, 0x01, // Ļ* (U+013B U+002A)
  0x01, 0x3B, 0x00, 0x3F, 0x01, // Ļ? (U+013B U+003F)
  0x01, 0x3B, 0x00, 0x54, 0x01, // ĻT (U+013B U+0054)
  0x01, 0x3B, 0x01, 0x62, 0x01, // ĻŢ (U+013B U+0162)
  0x01, 0x3B, 0x01, 0x64, 0x01, // ĻŤ (U+013B U+0164)
  0x01, 0x3B, 0x01, 0x66, 0x01, // ĻŦ (U+013B U+0166)
  0x01, 0x3B, 0x20, 0x18, 0x01, // Ļ‘ (U+013B U+2018)
  0x01, 0x3B, 0x20, 0x19, 0x01, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1C, 0x01, // Ļ“ (U+013B U+201C)
  0x01, 0x3B, 0x20, 0x1D, 0x01, // Ļ” (U+013B U+201D)
  0x01, 0x3B, 0x21, 0x22, 0x01, // Ļ™ (U+013B U+2122)
  0x01, 0x41, 0x00, 0x2A, 0x01, // Ł* (U+0141 U+002A)
  0x01, 0x41, 0x00, 0x3F, 0x01, // Ł? (U+0141 U+003F)
  0x01, 0x41, 0x00, 0x54, 0x01, // ŁT (U+0141 U+0054)
  0x01, 0x41, 0x01, 0x62, 0x01, // ŁŢ (U+0141 U+0162)
  0x01, 0x41, 0x01, 0x64, 0x01, // ŁŤ (U+0141 U+0164)
  0x01, 0x41, 0x01, 0x66, 0x01, // ŁŦ (U+0141 U+0166)
  0x01, 0x41, 0x20, 0x18, 0x01, // Ł‘ (U+0141 U+2018)
  0x01, 0x41, 0x20, 0x19, 0x01, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1C, 0x01, // Ł“ (U+0141 U+201C)
  0x01, 0x41, 0x20, 0x1D, 0x01, // Ł” (U+0141 U+201D)
  0x01, 0x41, 0x21, 0x22, 0x01, // Ł™ (U+0141 U+2122)
  0x01, 0x4D, 0x00, 0x59, 0x01, // ōY (U+014D U+0059)
  0x01, 0x4D, 0x00, 0xDD, 0x01, // ōÝ (U+014D U+00DD)
  0x01, 0x4D, 0x01, 0x76, 0x01, // ōŶ (U+014D U+0176)
  0x01, 0x4D, 0x01, 0x78, 0x01, // ōŸ (U+014D U+0178)
  0x01, 0x4F, 0x00, 0x59, 0x01, // ŏY (U+014F U+0059)
  0x01, 0x4F, 0x00, 0xDD, 0x01, // ŏÝ (U+014F U+00DD)
  0x01, 0x4F, 0x01, 0x76, 0x01, // ŏŶ (U+014F U+0176)
  0x01, 0x4F, 0x01, 0x78, 0x01, // ŏŸ (U+014F U+0178)
  0x01, 0x51, 0x00, 0x59, 0x01, // őY (U+0151 U+0059)
  0x01, 0x51, 0x00, 0xDD, 0x01, // őÝ (U+0151 U+00DD)
  0x01, 0x51, 0x01, 0x76, 0x01, // őŶ (U+0151 U+0176)
  0x01, 0x51, 0x01, 0x78, 0x01, // őŸ (U+0151 U+0178)
  0x01, 0x55, 0x00, 0x2C, 0x01, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x01, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x20, 0x1A, 0x01, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x01, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x01, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x01, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x01, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x20, 0x1A, 0x01, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x01, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x01, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x01, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x01, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x20, 0x1A, 0x01, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x01, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x01, // ř… (U+0159 U+2026)
  0x01, 0x62, 0x00, 0x2C, 0x01, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2E, 0x01, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0xC6, 0x01, // ŢÆ (U+0162 U+00C6)
  0x01, 0x62, 0x20, 0x1A, 0x01, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x01, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x01, // Ţ… (U+0162 U+2026)
  0x01, 0x64, 0x00, 0x2C, 0x01, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2E, 0x01, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0xC6, 0x01, // ŤÆ (U+0164 U+00C6)
  0x01, 0x64, 0x20, 0x1A, 0x01, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x01, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x01, // Ť… (U+0164 U+2026)
  0x01, 0x66, 0x00, 0x2C, 0x01, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2E, 0x01, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0xC6, 0x01, // ŦÆ (U+0166 U+00C6)
  0x01, 0x66, 0x20, 0x1A, 0x01, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x01, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x01, // Ŧ… (U+0166 U+2026)
  0x01, 0x74, 0x00, 0x2C, 0x01, // Ŵ, (U+0174 U+002C)
  0x01, 0x74, 0x00, 0x2E, 0x01, // Ŵ. (U+0174 U+002E)
  0x01, 0x74, 0x00, 0x41, 0x01, // ŴA (U+0174 U+0041)
  0x01, 0x74, 0x00, 0x61, 0x01, // Ŵa (U+0174 U+0061)
  0x01, 0x74, 0x00, 0xC0, 0x01, // ŴÀ (U+0174 U+00C0)
  0x01, 0x74, 0x00, 0xC1, 0x01, // ŴÁ (U+0174 U+00C1)
  0x01, 0x74, 0x00, 0xC2, 0x01, // ŴÂ (U+0174 U+00C2)
  0x01, 0x74, 0x00, 0xC3, 0x01, // ŴÃ (U+0174 U+00C3)
  0x01, 0x74, 0x00, 0xC4, 0x01, // ŴÄ (U+0174 U+00C4)
  0x01, 0x74, 0x00, 0xC5, 0x01, // ŴÅ (U+0174 U+00C5)
  0x01, 0x74, 0x00, 0xC6, 0x01, // ŴÆ (U+0174 U+00C6)
  0x01, 0x74, 0x00, 0xE0, 0x01, // Ŵà (U+0174 U+00E0)
  0x01, 0x74, 0x00, 0xE1, 0x01, // Ŵá (U+0174 U+00E1)
  0x01, 0x74, 0x00, 0xE2, 0x01, // Ŵâ (U+0174 U+00E2)
  0x01, 0x74, 0x00, 0xE3, 0x01, // Ŵã (U+0174 U+00E3)
  0x01, 0x74, 0x00, 0xE4, 0x01, // Ŵä (U+0174 U+00E4)
  0x01, 0x74, 0x00, 0xE5, 0x01, // Ŵå (U+0174 U+00E5)
  0x01, 0x74, 0x00, 0xE6, 0x01, // Ŵæ (U+0174 U+00E6)
  0x01, 0x74, 0x01, 0x00, 0x01, // ŴĀ (U+0174 U+0100)
  0x01, 0x74, 0x01, 0x01, 0x01, // Ŵā (U+0174 U+0101)
  0x01, 0x74, 0x01, 0x02, 0x01, // ŴĂ (U+0174 U+0102)
  0x01, 0x74, 0x01, 0x03, 0x01, // Ŵă (U+0174 U+0103)
  0x01, 0x74, 0x01, 0x04, 0x01, // ŴĄ (U+0174 U+0104)
  0x01, 0x74, 0x01, 0x05, 0x01, // Ŵą (U+0174 U+0105)
  0x01, 0x74, 0x20, 0x1A, 0x01, // Ŵ‚ (U+0174 U+201A)
  0x01, 0x74, 0x20, 0x1E, 0x01, // Ŵ„ (U+0174 U+201E)
  0x01, 0x74, 0x20, 0x26, 0x01, // Ŵ… (U+0174 U+2026)
  0x01, 0x75, 0x00, 0x2C, 0x01, // ŵ, (U+0175 U+002C)
  0x01, 0x75, 0x00, 0x2E, 0x01, // ŵ. (U+0175 U+002E)
  0x01, 0x75, 0x20, 0x1A, 0x01, // ŵ‚ (U+0175 U+201A)
  0x01, 0x75, 0x20, 0x1E, 0x01, // ŵ„ (U+0175 U+201E)
  0x01, 0x75, 0x20, 0x26, 0x01, // ŵ… (U+0175 U+2026)
  0x01, 0x76, 0x00, 0x2C, 0x01, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x01, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x00, 0x41, 0x01, // ŶA (U+0176 U+0041)
  0x01, 0x76, 0x00, 0x63, 0x01, // Ŷc (U+0176 U+0063)
  0x01, 0x76, 0x00, 0x64, 0x01, // Ŷd (U+0176 U+0064)
  0x01, 0x76, 0x00, 0x65, 0x01, // Ŷe (U+0176 U+0065)
  0x01, 0x76, 0x00, 0x67, 0x01, // Ŷg (U+0176 U+0067)
  0x01, 0x76, 0x00, 0x6F, 0x01, // Ŷo (U+0176 U+006F)
  0x01, 0x76, 0x00, 0x71, 0x01, // Ŷq (U+0176 U+0071)
  0x01, 0x76, 0x00, 0xC0, 0x01, // ŶÀ (U+0176 U+00C0)
  0x01, 0x76, 0x00, 0xC1, 0x01, // ŶÁ (U+0176 U+00C1)
  0x01, 0x76, 0x00, 0xC2, 0x01, // ŶÂ (U+0176 U+00C2)
  0x01, 0x76, 0x00, 0xC3, 0x01, // ŶÃ (U+0176 U+00C3)
  0x01, 0x76, 0x00, 0xC4, 0x01, // ŶÄ (U+0176 U+00C4)
  0x01, 0x76, 0x00, 0xC5, 0x01, // ŶÅ (U+0176 U+00C5)
  0x01, 0x76, 0x00, 0xC6, 0x01, // ŶÆ (U+0176 U+00C6)
  0x01, 0x76, 0x00, 0xE7, 0x01, // Ŷç (U+0176 U+00E7)
  0x01, 0x76, 0x00, 0xE8, 0x01, // Ŷè (U+0176 U+00E8)
  0x01, 0x76, 0x00, 0xE9, 0x01, // Ŷé (U+0176 U+00E9)
  0x01, 0x76, 0x00, 0xEA, 0x01, // Ŷê (U+0176 U+00EA)
  0x01, 0x76, 0x00, 0xEB, 0x01, // Ŷë (U+0176 U+00EB)
  0x01, 0x76, 0x00, 0xF0, 0x01, // Ŷð (U+0176 U+00F0)
  0x01, 0x76, 0x00, 0xF2, 0x01, // Ŷò (U+0176 U+00F2)
  0x01, 0x76, 0x00, 0xF3, 0x01, // Ŷó (U+0176 U+00F3)
  0x01, 0x76, 0x00, 0xF4, 0x01, // Ŷô (U+0176 U+00F4)
  0x01, 0x76, 0x00, 0xF5, 0x01, // Ŷõ (U+0176 U+00F5)
  0x01, 0x76, 0x00, 0xF6, 0x01, // Ŷö (U+0176 U+00F6)
  0x01, 0x76, 0x00, 0xF8, 0x01, // Ŷø (U+0176 U+00F8)
  0x01, 0x76, 0x01, 0x00, 0x01, // ŶĀ (U+0176 U+0100)
  0x01, 0x76, 0x01, 0x02, 0x01, // ŶĂ (U+0176 U+0102)
  0x01, 0x76, 0x01, 0x04, 0x01, // ŶĄ (U+0176 U+0104)
  0x01, 0x76, 0x01, 0x07, 0x01, // Ŷć (U+0176 U+0107)
  0x01, 0x76, 0x01, 0x09, 0x01, // Ŷĉ (U+0176 U+0109)
  0x01, 0x76, 0x01, 0x0B, 0x01, // Ŷċ (U+0176 U+010B)
  0x01, 0x76, 0x01, 0x0D, 0x01, // Ŷč (U+0176 U+010D)
  0x01, 0x76, 0x01, 0x0F, 0x01, // Ŷď (U+0176 U+010F)
  0x01, 0x76, 0x01, 0x11, 0x01, // Ŷđ (U+0176 U+0111)
  0x01, 0x76, 0x01, 0x13, 0x01, // Ŷē (U+0176 U+0113)
  0x01, 0x76, 0x01, 0x15, 0x01, // Ŷĕ (U+0176 U+0115)
  0x01, 0x76, 0x01, 0x17, 0x01, // Ŷė (U+0176 U+0117)
  0x01, 0x76, 0x01, 0x19, 0x01, // Ŷę (U+0176 U+0119)
  0x01, 0x76, 0x01, 0x1B, 0x01, // Ŷě (U+0176 U+011B)
  0x01, 0x76, 0x01, 0x1D, 0x01, // Ŷĝ (U+0176 U+011D)
  0x01, 0x76, 0x01, 0x1F, 0x01, // Ŷğ (U+0176 U+011F)
  0x01, 0x76, 0x01, 0x21, 0x01, // Ŷġ (U+0176 U+0121)
  0x01, 0x76, 0x01, 0x23, 0x01, // Ŷģ (U+0176 U+0123)
  0x01, 0x76, 0x01, 0x4D, 0x01, // Ŷō (U+0176 U+014D)
  0x01, 0x76, 0x01, 0x4F, 0x01, // Ŷŏ (U+0176 U+014F)
  0x01, 0x76, 0x01, 0x51, 0x01, // Ŷő (U+0176 U+0151)
  0x01, 0x76, 0x01, 0x53, 0x01, // Ŷœ (U+0176 U+0153)
  0x01, 0x76, 0x20, 0x1A, 0x01, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x01, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x01, // Ŷ… (U+0176 U+2026)
  0x01, 0x77, 0x00, 0x2C, 0x01, // ŷ, (U+0177 U+002C)
  0x01, 0x77, 0x00, 0x2E, 0x01, // ŷ. (U+0177 U+002E)
  0x01, 0x77, 0x20, 0x1A, 0x01, // ŷ‚ (U+0177 U+201A)
  0x01, 0x77, 0x20, 0x1E, 0x01, // ŷ„ (U+0177 U+201E)
  0x01, 0x77, 0x20, 0x26, 0x01, // ŷ… (U+0177 U+2026)
  0x01, 0x78, 0x00, 0x2C, 0x01, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x01, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x00, 0x41, 0x01, // ŸA (U+0178 U+0041)
  0x01, 0x78, 0x00, 0x63, 0x01, // Ÿc (U+0178 U+0063)
  0x01, 0x78, 0x00, 0x64, 0x01, // Ÿd (U+0178 U+0064)
  0x01, 0x78, 0x00, 0x65, 0x01, // Ÿe (U+0178 U+0065)
  0x01, 0x78, 0x00, 0x67, 0x01, // Ÿg (U+0178 U+0067)
  0x01, 0x78, 0x00, 0x6F, 0x01, // Ÿo (U+0178 U+006F)
  0x01, 0x78, 0x00, 0x71, 0x01, // Ÿq (U+0178 U+0071)
  0x01, 0x78, 0x00, 0xC0, 0x01, // ŸÀ (U+0178 U+00C0)
  0x01, 0x78, 0x00, 0xC1, 0x01, // ŸÁ (U+0178 U+00C1)
  0x01, 0x78, 0x00, 0xC2, 0x01, // ŸÂ (U+0178 U+00C2)
  0x01, 0x78, 0x00, 0xC3, 0x01, // ŸÃ (U+0178 U+00C3)
  0x01, 0x78, 0x00, 0xC4, 0x01, // ŸÄ (U+0178 U+00C4)
  0x01, 0x78, 0x00, 0xC5, 0x01, // ŸÅ (U+0178 U+00C5)
  0x01, 0x78, 0x00, 0xC6, 0x01, // ŸÆ (U+0178 U+00C6)
  0x01, 0x78, 0x00, 0xE7, 0x01, // Ÿç (U+0178 U+00E7)
  0x01, 0x78, 0x00, 0xE8, 0x01, // Ÿè (U+0178 U+00E8)
  0x01, 0x78, 0x00, 0xE9, 0x01, // Ÿé (U+0178 U+00E9)
  0x01, 0x78, 0x00, 0xEA, 0x01, // Ÿê (U+0178 U+00EA)
  0x01, 0x78, 0x00, 0xEB, 0x01, // Ÿë (U+0178 U+00EB)
  0x01, 0x78, 0x00, 0xF0, 0x01, // Ÿð (U+0178 U+00F0)
  0x01, 0x78, 0x00, 0xF2, 0x01, // Ÿò (U+0178 U+00F2)
  0x01, 0x78, 0x00, 0xF3, 0x01, // Ÿó (U+0178 U+00F3)
  0x01, 0x78, 0x00, 0xF4, 0x01, // Ÿô (U+0178 U+00F4)
  0x01, 0x78, 0x00, 0xF5, 0x01, // Ÿõ (U+0178 U+00F5)
  0x01, 0x78, 0x00, 0xF6, 0x01, // Ÿö (U+0178 U+00F6)
  0x01, 0x78, 0x00, 0xF8, 0x01, // Ÿø (U+0178 U+00F8)
  0x01, 0x78, 0x01, 0x00, 0x01, // ŸĀ (U+0178 U+0100)
  0x01, 0x78, 0x01, 0x02, 0x01, // ŸĂ (U+0178 U+0102)
  0x01, 0x78, 0x01, 0x04, 0x01, // ŸĄ (U+0178 U+0104)
  0x01, 0x78, 0x01, 0x07, 0x01, // Ÿć (U+0178 U+0107)
  0x01, 0x78, 0x01, 0x09, 0x01, // Ÿĉ (U+0178 U+0109)
  0x01, 0x78, 0x01, 0x0B, 0x01, // Ÿċ (U+0178 U+010B)
  0x01, 0x78, 0x01, 0x0D, 0x01, // Ÿč (U+0178 U+010D)
  0x01, 0x78, 0x01, 0x0F, 0x01, // Ÿď (U+0178 U+010F)
  0x01, 0x78, 0x01, 0x11, 0x01, // Ÿđ (U+0178 U+0111)
  0x01, 0x78, 0x01, 0x13, 0x01, // Ÿē (U+0178 U+0113)
  0x01, 0x78, 0x01, 0x15, 0x01, // Ÿĕ (U+0178 U+0115)
  0x01, 0x78, 0x01, 0x17, 0x01, // Ÿė (U+0178 U+0117)
  0x01, 0x78, 0x01, 0x19, 0x01, // Ÿę (U+0178 U+0119)
  0x01, 0x78, 0x01, 0x1B, 0x01, // Ÿě (U+0178 U+011B)
  0x01, 0x78, 0x01, 0x1D, 0x01, // Ÿĝ (U+0178 U+011D)
  0x01, 0x78, 0x01, 0x1F, 0x01, // Ÿğ (U+0178 U+011F)
  0x01, 0x78, 0x01, 0x21, 0x01, // Ÿġ (U+0178 U+0121)
  0x01, 0x78, 0x01, 0x23, 0x01, // Ÿģ (U+0178 U+0123)
  0x01, 0x78, 0x01, 0x4D, 0x01, // Ÿō (U+0178 U+014D)
  0x01, 0x78, 0x01, 0x4F, 0x01, // Ÿŏ (U+0178 U+014F)
  0x01, 0x78, 0x01, 0x51, 0x01, // Ÿő (U+0178 U+0151)
  0x01, 0x78, 0x01, 0x53, 0x01, // Ÿœ (U+0178 U+0153)
  0x01, 0x78, 0x20, 0x1A, 0x01, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x01, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x01, // Ÿ… (U+0178 U+2026)
  0x20, 0x18, 0x00, 0x41, 0x01, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0xC0, 0x01, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x01, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x01, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x01, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x01, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x01, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xC6, 0x01, // ‘Æ (U+2018 U+00C6)
  0x20, 0x18, 0x01, 0x00, 0x01, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x02, 0x01, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x04, 0x01, // ‘Ą (U+2018 U+0104)
  0x20, 0x19, 0x00, 0x41, 0x01, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0xC0, 0x01, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x01, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x01, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x01, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x01, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x01, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x01, 0x00, 0x01, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x02, 0x01, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x04, 0x01, // ’Ą (U+2019 U+0104)
  0x20, 0x1A, 0x00, 0x3F, 0x01, // ‚? (U+201A U+003F)
  0x20, 0x1A, 0x00, 0x54, 0x01, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x56, 0x01, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x01, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x01, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0x76, 0x01, // ‚v (U+201A U+0076)
  0x20, 0x1A, 0x00, 0xDD, 0x01, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x01, 0x62, 0x01, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x01, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x01, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1A, 0x01, 0x74, 0x01, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x76, 0x01, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x78, 0x01, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x01, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0xC0, 0x01, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x01, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x01, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x01, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x01, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x01, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xC6, 0x01, // “Æ (U+201C U+00C6)
  0x20, 0x1C, 0x01, 0x00, 0x01, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x02, 0x01, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x04, 0x01, // “Ą (U+201C U+0104)
  0x20, 0x1D, 0x00, 0x41, 0x01, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0xC0, 0x01, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x01, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x01, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x01, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x01, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x01, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x01, 0x00, 0x01, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x02, 0x01, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x04, 0x01, // ”Ą (U+201D U+0104)
  0x20, 0x1E, 0x00, 0x3F, 0x01, // „? (U+201E U+003F)
  0x20, 0x1E, 0x00, 0x54, 0x01, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x56, 0x01, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x01, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x01, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0x76, 0x01, // „v (U+201E U+0076)
  0x20, 0x1E, 0x00, 0xDD, 0x01, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x01, 0x62, 0x01, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x01, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x01, // „Ŧ (U+201E U+0166)
  0x20, 0x1E, 0x01, 0x74, 0x01, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x76, 0x01, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x78, 0x01, // „Ÿ (U+201E U+0178)
  0x20, 0x26, 0x00, 0x3F, 0x01, // …? (U+2026 U+003F)
  0x20, 0x26, 0x00, 0x54, 0x01, // …T (U+2026 U+0054)
  0x20, 0x26, 0x00, 0x56, 0x01, // …V (U+2026 U+0056)
  0x20, 0x26, 0x00, 0x57, 0x01, // …W (U+2026 U+0057)
  0x20, 0x26, 0x00, 0x59, 0x01, // …Y (U+2026 U+0059)
  0x20, 0x26, 0x00, 0x76, 0x01, // …v (U+2026 U+0076)
  0x20, 0x26, 0x00, 0xDD, 0x01, // …Ý (U+2026 U+00DD)
  0x20, 0x26, 0x01, 0x62, 0x01, // …Ţ (U+2026 U+0162)
  0x20, 0x26, 0x01, 0x64, 0x01, // …Ť (U+2026 U+0164)
  0x20, 0x26, 0x01, 0x66, 0x01, // …Ŧ (U+2026 U+0166)
  0x20, 0x26, 0x01, 0x74, 0x01, // …Ŵ (U+2026 U+0174)
  0x20, 0x26, 0x01, 0x76, 0x01, // …Ŷ (U+2026 U+0176)
  0x20, 0x26, 0x01, 0x78, 0x01, // …Ÿ (U+2026 U+0178)
  
  // Glyph data
  // "!" (U+0021)
  0x1F, 0x20, 0xF1, 0x0E, 0x00, 0xB0, 0x03, 0x00, 0x50, 0x0E, 0x10,
  // """ (U+0022)
  0x6B, 0xA7, 0x38, 0x74, 0x13, 0x31,
  // "#" (U+0023)
  0x04, 0x49, 0x00, 0x62, 0x80, 0x5D, 0xBB, 0x20, 0x85, 0x30, 0x7D, 0xCA, 0x01, 0x78, 0x00, 0x35,
  0x80, 0x00,
  // "$" (U+0024)
  0x05, 0xB3, 0x49, 0x9A, 0x5D, 0x80, 0x08, 0xF8, 0x31, 0x9F, 0x78, 0x9B, 0x04, 0x90, 0x00, 0x30,
  // "%" (U+0025)
  0x39, 0x80, 0x71, 0x09, 0x3C, 0x19, 0x00, 0xB2, 0xC6, 0x40, 0x08, 0x4C, 0x94, 0x84, 0x18, 0x77,
  0xC1, 0xD0, 0x07, 0x2D, 0x0D, 0x00, 0x90, 0x77, 0x70,
  // "&" (U+0026)
  0x06, 0xAB, 0x00, 0x00, 0xC5, 0xC3, 0x00, 0x0A, 0xEE, 0x10, 0x00, 0x8F, 0x58, 0xA0, 0x6B, 0x6D,
  0xC1, 0x08, 0x90, 0x8E, 0x00, 0x2C, 0x88, 0xAC, 0x20,
  // "'" (U+0027)
  0x6B, 0x38, 0x13,
  // "(" (U+0028)
  0x04, 0x91, 0xE1, 0x6C, 0x08, 0xB0, 0x6C, 0x01, 0xE1, 0x03, 0x90,
  // ")" (U+0029)
  0x76, 0x00, 0xD4, 0x09, 0x90, 0x8B, 0x09, 0x90, 0xD3, 0x75, 0x00,
  // "*" (U+002A)
  0x25, 0x62, 0x5C, 0xC5, 0x79, 0x97, 0x03, 0x30,
  // "+" (U+002B)
  0x00, 0x70, 0x01, 0x80, 0x4A, 0xC9, 0x01, 0x80,
  // "," (U+002C)
  0x69, 0x1A, 0x42,
  // "-" (U+002D)
  0xBE, 0x40,
  // "." (U+002E)
  0x13, 0x5A,
  // "/" (U+002F)
  0x05, 0x20, 0x80, 0x08, 0x00, 0x80, 0x35, 0x07, 0x10, 0x80, 0x08, 0x00,
  // "0" (U+0030)
  0x1B, 0xB5, 0x07, 0xA2, 0xE0, 0xA8, 0x1F, 0x2B, 0x80, 0xF2, 0xA8, 0x1F, 0x27, 0xA2, 0xE0, 0x1B,
  0xA5, 0x00,
  // "1" (U+0031)
  0x06, 0xF0, 0x79, 0xF0, 0x02, 0xF0, 0x02, 0xF0, 0x02, 0xF0, 0x02, 0xF0, 0x19, 0xF8,
  // "2" (U+0032)
  0x4B, 0xB6, 0x09, 0x65, 0xD0, 0x01, 0x6A, 0x00, 0x0B, 0x20, 0x07, 0x50, 0x04, 0x70, 0x71, 0xBF,
  0xFF, 0x10,
  // "3" (U+0033)
  0x5C, 0xC6, 0x96, 0x5D, 0x00, 0x79, 0x08, 0xD3, 0x00, 0x4E, 0x60, 0x3F, 0x6A, 0xC6,
  // "4" (U+0034)
  0x00, 0xD7, 0x00, 0x4D, 0x70, 0x08, 0xA7, 0x02, 0x6A, 0x70, 0x70, 0xA7, 0x09, 0x9D, 0xC2, 0x04,
  0xDC, 0x10,
  // "5" (U+0035)
  0x4F, 0xFB, 0x53, 0x05, 0x62, 0x00, 0x69, 0xA4, 0x00, 0x4E, 0x50, 0x3E, 0x6A, 0xC5,
  // "6" (U+0036)
  0x07, 0xAB, 0x03, 0xC0, 0x90, 0x78, 0x00, 0x09, 0xC9, 0x70, 0x98, 0x0F, 0x16, 0xA0, 0xF1, 0x0A,
  0xA8, 0x00,
  // "7" (U+0037)
  0x9F, 0xFF, 0x27, 0x01, 0xC0, 0x00, 0x67, 0x00, 0x0B, 0x20, 0x01, 0xD0, 0x00, 0x77, 0x00, 0x0C,
  0x20, 0x00,
  // "8" (U+0038)
  0x2B, 0x97, 0x07, 0x91, 0xE0, 0x5F, 0xBA, 0x00, 0xCF, 0x50, 0x88, 0x4F, 0x1A, 0x60, 0xE2, 0x3A,
  0x88, 0x00,
  // "9" (U+0039)
  0x1C, 0xB4, 0x08, 0x83, 0xD0, 0xA7, 0x1F, 0x09, 0x81, 0xF1, 0x1A, 0x8F, 0x01, 0x03, 0xA0, 0x49,
  0xA2, 0x00,
  // ":" (U+003A)
  0x5B, 0x13, 0x00, 0x14, 0x5B,
  // ";" (U+003B)
  0x5B, 0x14, 0x00, 0x25, 0x3C, 0x36,
  // "<" (U+003C)
  0x00, 0x18, 0x18, 0x70, 0x3A, 0x30, 0x00, 0x68,
  // "=" (U+003D)
  0x59, 0x99, 0x00, 0x00, 0x59, 0x99,
  // ">" (U+003E)
  0x45, 0x00, 0x04, 0x94, 0x00, 0x78, 0x48, 0x10,
  // "?" (U+003F)
  0x6C, 0xA5, 0x55, 0x5D, 0x00, 0x7C, 0x03, 0xC2, 0x04, 0x40, 0x03, 0x20, 0x09, 0x70,
  // "@" (U+0040)
  0x00, 0x87, 0x79, 0x10, 0xA3, 0x00, 0x19, 0x38, 0x39, 0x95, 0x98, 0x4C, 0x29, 0x39, 0x83, 0xE0,
  0xC2, 0x95, 0x56, 0x84, 0x92, 0x0A, 0x10, 0x03, 0x00, 0x06, 0x66, 0x30,
  // "A" (U+0041)
  0x00, 0xAB, 0x00, 0x00, 0xBF, 0x00, 0x03, 0x6E, 0x40, 0x08, 0x1A, 0x90, 0x0B, 0x9B, 0xD0, 0x28,
  0x01, 0xF2, 0xAB, 0x04, 0xFB,
  // "B" (U+0042)
  0x6F, 0x9B, 0x40, 0xF3, 0x8C, 0x0F, 0x39, 0xB0, 0xFA, 0xE3, 0x0F, 0x35, 0xE0, 0xF3, 0x4F, 0x6F,
  0x9A, 0x70,
  // "C" (U+0043)
  0x05, 0xBB, 0x92, 0xF1, 0x0B, 0x7D, 0x00, 0x08, 0xC0, 0x00, 0x7D, 0x00, 0x02, 0xF2, 0x03, 0x05,
  0xCB, 0x80,
  // "D" (U+0044)
  0x6F, 0x9A, 0x70, 0x0F, 0x30, 0xE4, 0x0F, 0x30, 0xB9, 0x0F, 0x30, 0xAA, 0x0F, 0x30, 0xB8, 0x0F,
  0x31, 0xF3, 0x6F, 0x9B, 0x60,
  // "E" (U+0045)
  0x6F, 0x98, 0xA0, 0xF3, 0x06, 0x0F, 0x30, 0x00, 0xF9, 0x81, 0x0F, 0x30, 0x00, 0xF3, 0x06, 0x6F,
  0x97, 0xC0,
  // "F" (U+0046)
  0x6F, 0x98, 0xA0, 0xF3, 0x06, 0x0F, 0x30, 0x00, 0xFA, 0x81, 0x0F, 0x30, 0x00, 0xF3, 0x00, 0x6F,
  0x91, 0x00,
  // "G" (U+0047)
  0x04, 0xB9, 0xC1, 0x2F, 0x20, 0xB4, 0x7D, 0x00, 0x00, 0x8C, 0x00, 0x00, 0x7D, 0x04, 0xB8, 0x2F,
  0x20, 0xE5, 0x05, 0xB9, 0xC3,
  // "H" (U+0048)
  0x6F, 0x93, 0xDC, 0x20, 0xF3, 0x0A, 0x90, 0x0F, 0x30, 0xA9, 0x00, 0xFA, 0x8D, 0x90, 0x0F, 0x30,
  0xA9, 0x00, 0xF3, 0x0A, 0x90, 0x6F, 0x93, 0xDC, 0x20,
  // "I" (U+0049)
  0x6F, 0x90, 0xF3, 0x0F, 0x30, 0xF3, 0x0F, 0x30, 0xF3, 0x6F, 0x90,
  // "J" (U+004A)
  0x07, 0xFA, 0x00, 0xF3, 0x00, 0xF3, 0x00, 0xF3, 0x00, 0xF3, 0x00, 0xF3, 0x00, 0xF3, 0x01, 0xF1,
  0x1B, 0x70,
  // "K" (U+004B)
  0x6F, 0x94, 0xF6, 0x0F, 0x35, 0x60, 0x0F, 0x59, 0x00, 0x0F, 0xEC, 0x00, 0x0F, 0x5F, 0x40, 0x0F,
  0x39, 0xC0, 0x6F, 0x91, 0xD9,
  // "L" (U+004C)
  0x6F, 0x90, 0x00, 0xF3, 0x00, 0x0F, 0x30, 0x00, 0xF3, 0x00, 0x0F, 0x30, 0x10, 0xF3, 0x08, 0x6F,
  0x97, 0xD0,
  // "M" (U+004D)
  0x6F, 0xA0, 0x0F, 0xD2, 0x0D, 0xE0, 0x4D, 0x90, 0x09, 0xF3, 0x79, 0x90, 0x08, 0xB7, 0x89, 0x90,
  0x08, 0x6D, 0x79, 0x90, 0x08, 0x2F, 0x39, 0x90, 0x6C, 0x1C, 0x1C, 0xD2,
  // "N" (U+004E)
  0x6F, 0x40, 0x8B, 0x10, 0xED, 0x02, 0x60, 0x09, 0xD6, 0x26, 0x00, 0x85, 0xE3, 0x60, 0x08, 0x0B,
  0xB6, 0x00, 0x80, 0x2F, 0x60, 0x6C, 0x20, 0x96, 0x00,
  // "O" (U+004F)
  0x06, 0xB9, 0x90, 0x2F, 0x10, 0xC6, 0x7D, 0x00, 0x8B, 0x8C, 0x00, 0x7D, 0x7D, 0x00, 0x8B, 0x2F,
  0x10, 0xC6, 0x06, 0xB9, 0x90,
  // "P" (U+0050)
  0x6F, 0x9B, 0x30, 0xF3, 0x8B, 0x0F, 0x37, 0xC0, 0xF3, 0xA8, 0x0F, 0x98, 0x00, 0xF3, 0x00, 0x6F,
  0x91, 0x00,
  // "Q" (U+0051)
  0x06, 0xBA, 0x90, 0x2F, 0x10, 0xC7, 0x7D, 0x00, 0x8B, 0x8C, 0x00, 0x7C, 0x6D, 0x00, 0x8B, 0x1E,
  0x20, 0xC6, 0x04, 0xBC, 0x70, 0x00, 0x4F, 0x00, 0x00, 0x08, 0xB1,
  // "R" (U+0052)
  0x6F, 0x9B, 0x60, 0x0F, 0x36, 0xE0, 0x0F, 0x37, 0xC0, 0x0F, 0xAE, 0x20, 0x0F, 0x3D, 0x50, 0x0F,
  0x37, 0xC0, 0x6F, 0x91, 0xD7,
  // "S" (U+0053)
  0x19, 0xAA, 0x07, 0x70, 0xB0, 0x7E, 0x40, 0x01, 0xBF, 0xA0, 0x00, 0x6F, 0x3A, 0x30, 0xC2, 0x5B,
  0x87, 0x00,
  // "T" (U+0054)
  0x89, 0x2C, 0x9F, 0xAD, 0x16, 0x0F, 0x35, 0x12, 0x90, 0x34, 0x90, 0x34, 0x90, 0x34, 0x90, 0x33,
  0x81, 0x6F, 0x92,
  // "U" (U+0055)
  0x8F, 0x81, 0xC7, 0x1F, 0x20, 0x71, 0x1F, 0x20, 0x71, 0x1F, 0x20, 0x71, 0x1F, 0x20, 0x71, 0x0F,
  0x30, 0x80, 0x06, 0xC9, 0x60,
  // "V" (U+0056)
  0xBF, 0x53, 0xD4, 0x2F, 0x10, 0x90, 0x0D, 0x52, 0x70, 0x09, 0x96, 0x20, 0x04, 0xD9, 0x00, 0x00,
  0xF8, 0x00, 0x00, 0xB5, 0x00,
  // "W" (U+0057)
  0xBF, 0x60, 0xC0, 0x4E, 0x43, 0xF1, 0x1F, 0x40, 0xA0, 0x0E, 0x55, 0xE8, 0x27, 0x00, 0xB8, 0x96,
  0xD5, 0x40, 0x07, 0xC9, 0x1F, 0x91, 0x00, 0x3F, 0x70, 0xCC, 0x00, 0x00, 0xE3, 0x08, 0x90, 0x00,
  // "X" (U+0058)
  0x7F, 0xA2, 0xE5, 0x0A, 0xA2, 0x80, 0x02, 0xFB, 0x00, 0x00, 0xCB, 0x00, 0x03, 0x8F, 0x30, 0x0A,
  0x09, 0xB0, 0xAC, 0x09, 0xF7,
  // "Y" (U+0059)
  0xBF, 0x64, 0xE4, 0x2F, 0x30, 0x90, 0x0A, 0x95, 0x40, 0x04, 0xE9, 0x00, 0x00, 0xD7, 0x00, 0x00,
  0xD6, 0x00, 0x05, 0xEB, 0x10,
  // "Z" (U+005A)
  0x7B, 0x8D, 0xB7, 0x12, 0xF4, 0x00, 0x9B, 0x00, 0x2F, 0x40, 0x09, 0xB0, 0x02, 0xF4, 0x09, 0x9E,
  0x89, 0xE0,
  // "[" (U+005B)
  0x3F, 0x83, 0xF0, 0x3F, 0x03, 0xF0, 0x3F, 0x03, 0xF0, 0x3F, 0x02, 0xB8,
  // "\" (U+005C)
  0x80, 0x08, 0x00, 0x71, 0x03, 0x50, 0x08, 0x00, 0x80, 0x08, 0x00, 0x52,
  // "]" (U+005D)
  0x5E, 0x80, 0xA8, 0x0A, 0x80, 0xA8, 0x0A, 0x80, 0xA8, 0x0B, 0x85, 0xB5,
  // "^" (U+005E)
  0x02, 0x90, 0x08, 0x81, 0x08, 0x27, 0x62, 0x09,
  // "_" (U+005F)
  0x88, 0x86,
  // "`" (U+0060)
  0x45, 0x00, 0xB2,
  // "a" (U+0061)
  0x1C, 0xA9, 0x01, 0x63, 0xF0, 0x2A, 0x9F, 0x09, 0xA3, 0xF0, 0x5D, 0x6F, 0x50,
  // "b" (U+0062)
  0x9F, 0x00, 0x03, 0xF0, 0x00, 0x3F, 0x7D, 0x43, 0xF1, 0x8A, 0x3F, 0x06, 0xC3, 0xF1, 0x8A, 0x9C,
  0x8D, 0x30,
  // "c" (U+0063)
  0x1B, 0xA9, 0x7A, 0x17, 0x99, 0x00, 0x7B, 0x01, 0x1B, 0xA8,
  // "d" (U+0064)
  0x00, 0x4E, 0x60, 0x00, 0xC6, 0x2D, 0x9D, 0x67, 0xA0, 0xE6, 0x99, 0x0D, 0x67, 0xA0, 0xE6, 0x2D,
  0x9B, 0xC0,
  // "e" (U+0065)
  0x1B, 0xA8, 0x07, 0xB0, 0xF1, 0x9D, 0x9C, 0x27, 0xB0, 0x10, 0x1B, 0xAA, 0x00,
  // "f" (U+0066)
  0x09, 0xAA, 0x1F, 0x21, 0x8F, 0xA2, 0x1F, 0x10, 0x1F, 0x10, 0x1F, 0x10, 0x8F, 0x90,
  // "g" (U+0067)
  0x3C, 0xBA, 0x48, 0x87, 0xA0, 0x2C, 0xA3, 0x06, 0x72, 0x00, 0x4F, 0xFE, 0x0E, 0x10, 0xD2, 0x9A,
  0x88, 0x00,
  // "h" (U+0068)
  0x9F, 0x00, 0x03, 0xF0, 0x00, 0x3F, 0x9E, 0x33, 0xF1, 0xA8, 0x3F, 0x09, 0x82, 0xF0, 0x98, 0x8F,
  0x59, 0xC0,
  // "i" (U+0069)
  0x3D, 0x00, 0x30, 0x9F, 0x03, 0xF0, 0x3F, 0x03, 0xF0, 0x8F, 0x60,
  // "j" (U+006A)
  0x02, 0xD0, 0x03, 0x09, 0xF0, 0x3F, 0x03, 0xF0, 0x3F, 0x03, 0xF0, 0x4E, 0x1B, 0x60,
  // "k" (U+006B)
  0x8F, 0x00, 0x03, 0xF0, 0x00, 0x3F, 0x1E, 0x73, 0xF6, 0x70, 0x3F, 0xF7, 0x03, 0xF5, 0xE1, 0x8F,
  0x6A, 0xC0,
  // "l" (U+006C)
  0x9F, 0x03, 0xF0, 0x3F, 0x03, 0xF0, 0x3F, 0x03, 0xF0, 0x8F, 0x60,
  // "m" (U+006D)
  0x8E, 0x9E, 0x7C, 0xB0, 0x3F, 0x1A, 0xA2, 0xF1, 0x3F, 0x09, 0x81, 0xF1, 0x3F, 0x09, 0x81, 0xF1,
  0x8F, 0x59, 0xC2, 0xF6,
  // "n" (U+006E)
  0x8E, 0x9E, 0x33, 0xF1, 0xA8, 0x3F, 0x09, 0x83, 0xF0, 0x98, 0x8F, 0x59, 0xC0,
  // "o" (U+006F)
  0x1B, 0x9A, 0x07, 0xA0, 0xC5, 0x99, 0x0B, 0x77, 0xA0, 0xC5, 0x1B, 0x9A, 0x00,
  // "p" (U+0070)
  0x8D, 0x8D, 0x33, 0xF1, 0x8A, 0x3F, 0x07, 0xB3, 0xF1, 0x8A, 0x3F, 0x8D, 0x33, 0xF0, 0x00, 0x9F,
  0x60, 0x00,
  // "q" (U+0071)
  0x2C, 0x9B, 0xC0, 0x7A, 0x0E, 0x60, 0x99, 0x0D, 0x60, 0x7A, 0x0E, 0x60, 0x2D, 0x9D, 0x60, 0x00,
  0x0C, 0x60, 0x00, 0x4F, 0xB1,
  // "r" (U+0072)
  0x8E, 0xAD, 0x3F, 0x27, 0x3F, 0x00, 0x3F, 0x00, 0x8F, 0x70,
  // "s" (U+0073)
  0x49, 0xB3, 0xA8, 0x31, 0x3D, 0xD3, 0x71, 0x98, 0x79, 0xA3,
  // "t" (U+0074)
  0x1D, 0x09, 0xF9, 0x3F, 0x03, 0xF0, 0x3F, 0x01, 0xDA,
  // "u" (U+0075)
  0x9F, 0x2E, 0x80, 0x3F, 0x0A, 0x80, 0x3F, 0x0A, 0x80, 0x3F, 0x0B, 0x80, 0x0C, 0xBB, 0xC1,
  // "v" (U+0076)
  0xBE, 0x3A, 0x92, 0xF0, 0x71, 0x0D, 0x59, 0x00, 0x8B, 0x70, 0x03, 0xF2, 0x00,
  // "w" (U+0077)
  0xCE, 0x2B, 0x1B, 0x94, 0xD0, 0xF5, 0x71, 0x0F, 0x6A, 0xA8, 0x00, 0xCC, 0x2D, 0x70, 0x08, 0x90,
  0xD4, 0x00,
  // "x" (U+0078)
  0x7F, 0x8B, 0x90, 0x9A, 0x80, 0x02, 0xF6, 0x00, 0x85, 0xE1, 0x9C, 0x4F, 0xC0,
  // "y" (U+0079)
  0xCE, 0x3D, 0x63, 0xE0, 0x90, 0x0D, 0x57, 0x00, 0x8D, 0x30, 0x02, 0xD0, 0x00, 0x48, 0x00, 0x7B,
  0x10, 0x00,
  // "z" (U+007A)
  0x99, 0xDC, 0x31, 0xE3, 0x09, 0xA0, 0x3E, 0x15, 0xBD, 0x9D,
  // "{" (U+007B)
  0x07, 0xB2, 0x0C, 0x60, 0x0C, 0x60, 0x0D, 0x50, 0x8D, 0x10, 0x0D, 0x60, 0x0C, 0x60, 0x05, 0x92,
  // "|" (U+007C)
  0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
  // "}" (U+007D)
  0x6D, 0x10, 0x0D, 0x50, 0x0D, 0x50, 0x0C, 0x60, 0x06, 0xE2, 0x0D, 0x60, 0x0D, 0x50, 0x69, 0x10,
  // "~" (U+007E)
  0x3B, 0x47, 0x71, 0x99,
  // "¡" (U+00A1)
  0x1E, 0x00, 0x50, 0x03, 0x00, 0xB0, 0x0E, 0x01, 0xF0, 0x2F, 0x10,
  // "¢" (U+00A2)
  0x00, 0x70, 0x07, 0xD8, 0x5C, 0x8D, 0x8A, 0x70, 0x6D, 0x82, 0x09, 0xD9, 0x00, 0x70,
  // "£" (U+00A3)
  0x0A, 0xAA, 0x04, 0xC0, 0xC0, 0x3D, 0x00, 0x07, 0xF9, 0x30, 0x0B, 0x30, 0x00, 0xC2, 0x01, 0x8A,
  0xDD, 0x10,
  // "¤" (U+00A4)
  0x00, 0x01, 0x3C, 0xA9, 0x25, 0x08, 0x17, 0x08, 0x3A, 0x98,
  // "¥" (U+00A5)
  0xBE, 0x4D, 0x34, 0xE0, 0x80, 0x0E, 0x46, 0x00, 0xAC, 0x20, 0x3B, 0xE8, 0x03, 0xAE, 0x80, 0x1A,
  0xE5, 0x00,
  // "¦" (U+00A6)
  0x18, 0x18, 0x18, 0x04, 0x00, 0x04, 0x18, 0x18, 0x18,
  // "§" (U+00A7)
  0x09, 0x96, 0x39, 0x15, 0x2F, 0x91, 0x66, 0x7C, 0x1D, 0xAC, 0x00, 0x8A, 0x38, 0x0A, 0x08, 0x83,
  // "¨" (U+00A8)
  0x82, 0x50,
  // "©" (U+00A9)
  0x02, 0x87, 0x70, 0x01, 0x95, 0x76, 0x90, 0x63, 0x90, 0x35, 0x28, 0x37, 0x00, 0x34, 0x63, 0xA0,
  0x15, 0x21, 0x96, 0x85, 0x90, 0x01, 0x87, 0x70, 0x00,
  // "ª" (U+00AA)
  0x49, 0xA0, 0x47, 0xD0, 0x87, 0xD1,
  // "«" (U+00AB)
  0x05, 0x16, 0x2B, 0x86, 0x5A, 0xB4, 0x09, 0x39,
  // "¬" (U+00AC)
  0x49, 0x9B, 0x00, 0x09, 0x00, 0x02,
  // "®" (U+00AE)
  0x02, 0x87, 0x70, 0x01, 0x99, 0x55, 0x90, 0x61, 0x90, 0x95, 0x28, 0x09, 0x93, 0x34, 0x61, 0x94,
  0x65, 0x21, 0x99, 0x29, 0x90, 0x01, 0x87, 0x70, 0x00,
  // "¯" (U+00AF)
  0x88, 0x86,
  // "°" (U+00B0)
  0x3A, 0x59, 0x0A, 0x3A, 0x50,
  // "±" (U+00B1)
  0x01, 0x80, 0x4A, 0xC9, 0x01, 0x80, 0x00, 0x70, 0x49, 0x99,
  // "²" (U+00B2)
  0x47, 0x43, 0x39, 0x17, 0x28, 0x99,
  // "³" (U+00B3)
  0x47, 0x52, 0x96, 0x30, 0xC5, 0x73,
  // "´" (U+00B4)
  0x07, 0x16, 0x70,
  // "µ" (U+00B5)
  0x3E, 0x0A, 0x83, 0xE0, 0xA8, 0x3E, 0x0A, 0x84, 0xF0, 0xC8, 0x4D, 0xA8, 0xC5, 0x60, 0x00, 0x3D,
  0x00, 0x00,
  // "¶" (U+00B6)
  0x5F, 0xCC, 0x5A, 0xFA, 0x90, 0x7F, 0xA9, 0x00, 0x49, 0x90, 0x00, 0x99, 0x00, 0x09, 0x90, 0x00,
  0x99, 0x00, 0x57, 0x75,
  // "·" (U+00B7)
  0x6B, 0x12,
  // "¸" (U+00B8)
  0x18, 0x00, 0x92, 0x59, 0x00,
  // "¹" (U+00B9)
  0x3A, 0x00, 0xB1, 0x0B, 0x12, 0x94,
  // "º" (U+00BA)
  0x58, 0xA0, 0xA3, 0xB2, 0x59, 0xB0,
  // "»" (U+00BB)
  0x33, 0x60, 0x0C, 0x68, 0x0C, 0x6B, 0x47, 0x92,
  // "¼" (U+00BC)
  0x00, 0x00, 0x90, 0x03, 0xA0, 0x35, 0x00, 0x0B, 0x19, 0x00, 0x00, 0xB2, 0x80, 0x75, 0x29, 0xC2,
  0x38, 0x60, 0x09, 0x07, 0x9A, 0x04, 0x50, 0x07, 0x70,
  // "½" (U+00BD)
  0x00, 0x00, 0x90, 0x03, 0xA0, 0x35, 0x00, 0x0B, 0x19, 0x00, 0x00, 0xB2, 0x84, 0x74, 0x29, 0xC2,
  0x33, 0x90, 0x09, 0x01, 0x72, 0x04, 0x50, 0x89, 0x90,
  // "¾" (U+00BE)
  0x00, 0x00, 0x90, 0x04, 0x75, 0x35, 0x00, 0x29, 0x69, 0x00, 0x03, 0x0D, 0x80, 0x75, 0x57, 0xB2,
  0x38, 0x60, 0x09, 0x07, 0x9A, 0x04, 0x50, 0x07, 0x70,
  // "¿" (U+00BF)
  0x07, 0x80, 0x02, 0x30, 0x04, 0x40, 0x2C, 0x30, 0xC7, 0x00, 0xD5, 0x55, 0x5A, 0xC6,
  // "À" (U+00C0)
  0x04, 0x50, 0x00, 0x00, 0xB2, 0x00, 0x00, 0xAB, 0x00, 0x00, 0xBF, 0x00, 0x03, 0x6E, 0x40, 0x08,
  0x1A, 0x90, 0x0B, 0x9B, 0xD0, 0x28, 0x01, 0xF2, 0xAB, 0x04, 0xFB,
  // "Á" (U+00C1)
  0x00, 0x07, 0x10, 0x00, 0x67, 0x00, 0x00, 0xAB, 0x00, 0x00, 0xBF, 0x00, 0x03, 0x6E, 0x40, 0x08,
  0x1A, 0x90, 0x0B, 0x9B, 0xD0, 0x28, 0x01, 0xF2, 0xAB, 0x04, 0xFB,
  // "Â" (U+00C2)
  0x00, 0x73, 0x00, 0x06, 0x7A, 0x00, 0x00, 0xAB, 0x00, 0x00, 0xBF, 0x00, 0x03, 0x6E, 0x40, 0x08,
  0x1A, 0x90, 0x0B, 0x9B, 0xD0, 0x28, 0x01, 0xF2, 0xAB, 0x04, 0xFB,
  // "Ã" (U+00C3)
  0x03, 0xB5, 0x50, 0x07, 0xCF, 0x10, 0x00, 0xBF, 0x00, 0x03, 0x6E, 0x40, 0x08, 0x1A, 0x90, 0x0B,
  0x9B, 0xD0, 0x28, 0x01, 0xF2, 0xAB, 0x04, 0xFB,
  // "Ä" (U+00C4)
  0x00, 0x82, 0x50, 0x00, 0xAB, 0x00, 0x00, 0xBF, 0x00, 0x03, 0x6E, 0x40, 0x08, 0x1A, 0x90, 0x0B,
  0x9B, 0xD0, 0x28, 0x01, 0xF2, 0xAB, 0x04, 0xFB,
  // "Å" (U+00C5)
  0x00, 0x77, 0x00, 0x00, 0xBC, 0x00, 0x00, 0xBF, 0x00, 0x03, 0x6E, 0x40, 0x08, 0x1A, 0x90, 0x0B,
  0x9B, 0xD0, 0x28, 0x01, 0xF2, 0xAB, 0x04, 0xFB,
  // "Æ" (U+00C6)
  0x00, 0x4E, 0xF8, 0xB6, 0x00, 0x58, 0xE0, 0x24, 0x00, 0x94, 0xE0, 0x00, 0x03, 0x64, 0xF8, 0x70,
  0x09, 0x9A, 0xE0, 0x00, 0x18, 0x04, 0xE0, 0x06, 0xBB, 0x0A, 0xF7, 0x89,
  // "Ç" (U+00C7)
  0x05, 0xBB, 0x92, 0xF1, 0x0B, 0x7D, 0x00, 0x08, 0xC0, 0x00, 0x7D, 0x00, 0x02, 0xF2, 0x03, 0x05,
  0xFF, 0x80, 0x00, 0xC0, 0x00, 0x86, 0x00,
  // "È" (U+00C8)
  0x04, 0x50, 0x00, 0x0B, 0x20, 0x6F, 0x98, 0xA0, 0xF3, 0x06, 0x0F, 0x30, 0x00, 0xF9, 0x81, 0x0F,
  0x30, 0x00, 0xF3, 0x06, 0x6F, 0x97, 0xC0,
  // "É" (U+00C9)
  0x00, 0x07, 0x10, 0x06, 0x70, 0x6F, 0x98, 0xA0, 0xF3, 0x06, 0x0F, 0x30, 0x00, 0xF9, 0x81, 0x0F,
  0x30, 0x00, 0xF3, 0x06, 0x6F, 0x97, 0xC0,
  // "Ê" (U+00CA)
  0x00, 0x73, 0x00, 0x67, 0xA0, 0x6F, 0x98, 0xA0, 0xF3, 0x06, 0x0F, 0x30, 0x00, 0xF9, 0x81, 0x0F,
  0x30, 0x00, 0xF3, 0x06, 0x6F, 0x97, 0xC0,
  // "Ë" (U+00CB)
  0x08, 0x25, 0x06, 0xF9, 0x8A, 0x0F, 0x30, 0x60, 0xF3, 0x00, 0x0F, 0x98, 0x10, 0xF3, 0x00, 0x0F,
  0x30, 0x66, 0xF9, 0x7C,
  // "Ì" (U+00CC)
  0x45, 0x00, 0xB2, 0x6F, 0x90, 0xF3, 0x0F, 0x30, 0xF3, 0x0F, 0x30, 0xF3, 0x6F, 0x90,
  // "Í" (U+00CD)
  0x00, 0x71, 0x06, 0x70, 0x6F, 0x90, 0x0F, 0x30, 0x0F, 0x30, 0x0F, 0x30, 0x0F, 0x30, 0x0F, 0x30,
  0x6F, 0x90,
  // "Î" (U+00CE)
  0x07, 0x36, 0x7A, 0x6F, 0x90, 0xF3, 0x0F, 0x30, 0xF3, 0x0F, 0x30, 0xF3, 0x6F, 0x90,
  // "Ï" (U+00CF)
  0x82, 0x56, 0xF9, 0x0F, 0x30, 0xF3, 0x0F, 0x30, 0xF3, 0x0F, 0x36, 0xF9,
  // "Ð" (U+00D0)
  0x6F, 0x9A, 0x70, 0x0F, 0x30, 0xE4, 0x0F, 0x30, 0xB9, 0x6F, 0xA1, 0xAA, 0x0F, 0x30, 0xB8, 0x0F,
  0x31, 0xF3, 0x6F, 0x9B, 0x60,
  // "Ñ" (U+00D1)
  0x03, 0xB5, 0x50, 0x06, 0xF7, 0xBA, 0xB1, 0x0E, 0xD0, 0x26, 0x00, 0x9D, 0x62, 0x60, 0x08, 0x5E,
  0x36, 0x00, 0x80, 0xBB, 0x60, 0x08, 0x02, 0xF6, 0x06, 0xC2, 0x09, 0x60,
  // "Ò" (U+00D2)
  0x04, 0x50, 0x00, 0x00, 0xB2, 0x00, 0x06, 0xB9, 0x90, 0x2F, 0x10, 0xC6, 0x7D, 0x00, 0x8B, 0x8C,
  0x00, 0x7D, 0x7D, 0x00, 0x8B, 0x2F, 0x10, 0xC6, 0x06, 0xB9, 0x90,
  // "Ó" (U+00D3)
  0x00, 0x07, 0x10, 0x00, 0x67, 0x00, 0x06, 0xB9, 0x90, 0x2F, 0x10, 0xC6, 0x7D, 0x00, 0x8B, 0x8C,
  0x00, 0x7D, 0x7D, 0x00, 0x8B, 0x2F, 0x10, 0xC6, 0x06, 0xB9, 0x90,
  // "Ô" (U+00D4)
  0x00, 0x73, 0x00, 0x06, 0x7A, 0x00, 0x06, 0xB9, 0x90, 0x2F, 0x10, 0xC6, 0x7D, 0x00, 0x8B, 0x8C,
  0x00, 0x7D, 0x7D, 0x00, 0x8B, 0x2F, 0x10, 0xC6, 0x06, 0xB9, 0x90,
  // "Õ" (U+00D5)
  0x03, 0xB5, 0x50, 0x0D, 0xDF, 0xA0, 0x2F, 0x10, 0xC6, 0x7D, 0x00, 0x8B, 0x8C, 0x00, 0x7D, 0x7D,
  0x00, 0x8B, 0x2F, 0x10, 0xC6, 0x06, 0xB9, 0x90,
  // "Ö" (U+00D6)
  0x00, 0x82, 0x50, 0x06, 0xB9, 0x90, 0x2F, 0x10, 0xC6, 0x7D, 0x00, 0x8B, 0x8C, 0x00, 0x7D, 0x7D,
  0x00, 0x8B, 0x2F, 0x10, 0xC6, 0x06, 0xB9, 0x90,
  // "×" (U+00D7)
  0x11, 0x03, 0x09, 0x84, 0x08, 0xA1, 0x14, 0x05,
  // "Ø" (U+00D8)
  0x05, 0xA9, 0xD0, 0x2F, 0x14, 0xE7, 0x7D, 0x08, 0x8B, 0x8C, 0x26, 0x7D, 0x7D, 0x80, 0x8B, 0x3F,
  0x70, 0xB6, 0x0A, 0xA9, 0x90, 0x04, 0x00, 0x00,
  // "Ù" (U+00D9)
  0x04, 0x50, 0x00, 0x00, 0xB2, 0x00, 0x8F, 0x81, 0xC7, 0x1F, 0x20, 0x71, 0x1F, 0x20, 0x71, 0x1F,
  0x20, 0x71, 0x1F, 0x20, 0x71, 0x0F, 0x30, 0x80, 0x06, 0xC9, 0x60,
  // "Ú" (U+00DA)
  0x00, 0x07, 0x10, 0x00, 0x67, 0x00, 0x8F, 0x81, 0xC7, 0x1F, 0x20, 0x71, 0x1F, 0x20, 0x71, 0x1F,
  0x20, 0x71, 0x1F, 0x20, 0x71, 0x0F, 0x30, 0x80, 0x06, 0xC9, 0x60,
  // "Û" (U+00DB)
  0x00, 0x73, 0x00, 0x06, 0x7A, 0x00, 0x8F, 0x81, 0xC7, 0x1F, 0x20, 0x71, 0x1F, 0x20, 0x71, 0x1F,
  0x20, 0x71, 0x1F, 0x20, 0x71, 0x0F, 0x30, 0x80, 0x06, 0xC9, 0x60,
  // "Ü" (U+00DC)
  0x00, 0x82, 0x50, 0x8F, 0x81, 0xC7, 0x1F, 0x20, 0x71, 0x1F, 0x20, 0x71, 0x1F, 0x20, 0x71, 0x1F,
  0x20, 0x71, 0x0F, 0x30, 0x80, 0x06, 0xC9, 0x60,
  // "Ý" (U+00DD)
  0x00, 0x07, 0x10, 0x00, 0x67, 0x00, 0xBF, 0x64, 0xE4, 0x2F, 0x30, 0x90, 0x0A, 0x95, 0x40, 0x04,
  0xE9, 0x00, 0x00, 0xD7, 0x00, 0x00, 0xD6, 0x00, 0x05, 0xEB, 0x10,
  // "Þ" (U+00DE)
  0x6F, 0x90, 0x00, 0xF9, 0x81, 0x0F, 0x39, 0xA0, 0xF3, 0x7C, 0x0F, 0x39, 0x90, 0xF9, 0x80, 0x6F,
  0x90, 0x00,
  // "ß" (U+00DF)
  0x08, 0x9A, 0x40, 0x2F, 0x04, 0xB0, 0xAF, 0x4C, 0x70, 0x3F, 0x7B, 0x00, 0x3F, 0x1C, 0xD0, 0x3F,
  0x60, 0xD4, 0x9F, 0x79, 0xB1,
  // "à" (U+00E0)
  0x04, 0x50, 0x00, 0x0B, 0x20, 0x00, 0x00, 0x01, 0xCA, 0x90, 0x16, 0x3F, 0x02, 0xA9, 0xF0, 0x9A,
  0x3F, 0x05, 0xD6, 0xF5,
  // "á" (U+00E1)
  0x00, 0x07, 0x10, 0x06, 0x70, 0x00, 0x00, 0x01, 0xCA, 0x90, 0x16, 0x3F, 0x02, 0xA9, 0xF0, 0x9A,
  0x3F, 0x05, 0xD6, 0xF5,
  // "â" (U+00E2)
  0x00, 0x73, 0x00, 0x67, 0xA0, 0x00, 0x00, 0x01, 0xCA, 0x90, 0x16, 0x3F, 0x02, 0xA9, 0xF0, 0x9A,
  0x3F, 0x05, 0xD6, 0xF5,
  // "ã" (U+00E3)
  0x03, 0xB5, 0x50, 0x72, 0xB1, 0x1C, 0xA9, 0x01, 0x63, 0xF0, 0x2A, 0x9F, 0x09, 0xA3, 0xF0, 0x5D,
  0x6F, 0x50,
  // "ä" (U+00E4)
  0x08, 0x25, 0x00, 0x00, 0x00, 0x1C, 0xA9, 0x01, 0x63, 0xF0, 0x2A, 0x9F, 0x09, 0xA3, 0xF0, 0x5D,
  0x6F, 0x50,
  // "å" (U+00E5)
  0x04, 0x71, 0x00, 0x47, 0x10, 0x1C, 0xA9, 0x01, 0x63, 0xF0, 0x2A, 0x9F, 0x09, 0xA3, 0xF0, 0x5D,
  0x6F, 0x50,
  // "æ" (U+00E6)
  0x1C, 0xAA, 0xAB, 0x11, 0x63, 0xF2, 0x98, 0x2A, 0xAF, 0x8A, 0x79, 0xA3, 0xF2, 0x01, 0x5D, 0x87,
  0xBA, 0x30,
  // "ç" (U+00E7)
  0x1B, 0xA9, 0x7A, 0x17, 0x99, 0x00, 0x7B, 0x01, 0x1D, 0xF8, 0x00, 0x92, 0x05, 0x90,
  // "è" (U+00E8)
  0x04, 0x50, 0x00, 0x0B, 0x20, 0x00, 0x00, 0x01, 0xBA, 0x80, 0x7B, 0x0F, 0x19, 0xD9, 0xC2, 0x7B,
  0x01, 0x01, 0xBA, 0xA0,
  // "é" (U+00E9)
  0x00, 0x07, 0x10, 0x06, 0x70, 0x00, 0x00, 0x01, 0xBA, 0x80, 0x7B, 0x0F, 0x19, 0xD9, 0xC2, 0x7B,
  0x01, 0x01, 0xBA, 0xA0,
  // "ê" (U+00EA)
  0x00, 0x73, 0x00, 0x67, 0xA0, 0x00, 0x00, 0x01, 0xBA, 0x80, 0x7B, 0x0F, 0x19, 0xD9, 0xC2, 0x7B,
  0x01, 0x01, 0xBA, 0xA0,
  // "ë" (U+00EB)
  0x08, 0x25, 0x00, 0x00, 0x00, 0x1B, 0xA8, 0x07, 0xB0, 0xF1, 0x9D, 0x9C, 0x27, 0xB0, 0x10, 0x1B,
  0xAA, 0x00,
  // "ì" (U+00EC)
  0x45, 0x00, 0xB2, 0x00, 0x09, 0xF0, 0x3F, 0x03, 0xF0, 0x3F, 0x08, 0xF6,
  // "í" (U+00ED)
  0x07, 0x16, 0x70, 0x00, 0x09, 0xF0, 0x3F, 0x03, 0xF0, 0x3F, 0x08, 0xF6,
  // "î" (U+00EE)
  0x07, 0x36, 0x7A, 0x00, 0x09, 0xF0, 0x3F, 0x03, 0xF0, 0x3F, 0x08, 0xF6,
  // "ï" (U+00EF)
  0x82, 0x50, 0x00, 0x9F, 0x03, 0xF0, 0x3F, 0x03, 0xF0, 0x8F, 0x60,
  // "ð" (U+00F0)
  0x01, 0x00, 0x00, 0x7C, 0x70, 0x05, 0x5B, 0x01, 0xB8, 0xF3, 0x7A, 0x0C, 0x79, 0x90, 0xB7, 0x7A,
  0x0C, 0x51, 0xB9, 0xA0,
  // "ñ" (U+00F1)
  0x03, 0xB5, 0x50, 0x72, 0xB1, 0x8E, 0x9E, 0x33, 0xF1, 0xA8, 0x3F, 0x09, 0x83, 0xF0, 0x98, 0x8F,
  0x59, 0xC0,
  // "ò" (U+00F2)
  0x04, 0x50, 0x00, 0x0B, 0x20, 0x00, 0x00, 0x01, 0xB9, 0xA0, 0x7A, 0x0C, 0x59, 0x90, 0xB7, 0x7A,
  0x0C, 0x51, 0xB9, 0xA0,
  // "ó" (U+00F3)
  0x00, 0x07, 0x10, 0x06, 0x70, 0x00, 0x00, 0x01, 0xB9, 0xA0, 0x7A, 0x0C, 0x59, 0x90, 0xB7, 0x7A,
  0x0C, 0x51, 0xB9, 0xA0,
  // "ô" (U+00F4)
  0x00, 0x73, 0x00, 0x67, 0xA0, 0x00, 0x00, 0x01, 0xB9, 0xA0, 0x7A, 0x0C, 0x59, 0x90, 0xB7, 0x7A,
  0x0C, 0x51, 0xB9, 0xA0,
  // "õ" (U+00F5)
  0x03, 0xB5, 0x50, 0x72, 0xB1, 0x1B, 0x9A, 0x07, 0xA0, 0xC5, 0x99, 0x0B, 0x77, 0xA0, 0xC5, 0x1B,
  0x9A, 0x00,
  // "ö" (U+00F6)
  0x08, 0x25, 0x00, 0x00, 0x00, 0x1B, 0x9A, 0x07, 0xA0, 0xC5, 0x99, 0x0B, 0x77, 0xA0, 0xC5, 0x1B,
  0x9A, 0x00,
  // "÷" (U+00F7)
  0x01, 0x80, 0x49, 0xA9, 0x00, 0x00, 0x01, 0x80,
  // "ø" (U+00F8)
  0x38, 0xB3, 0x21, 0x1B, 0x8D, 0x07, 0xA4, 0xE5, 0x99, 0x8B, 0x77, 0xE3, 0xC5, 0x1E, 0x9A, 0x01,
  0x23,
  // "ù" (U+00F9)
  0x10, 0x40, 0x55, 0x0B, 0x02, 0x71, 0x8A, 0x59, 0xF2, 0xE8, 0x03, 0xF0, 0xA8, 0x03, 0xF0, 0xA8,
  0x03, 0xF0, 0xB8, 0x28, 0x3C, 0xBB, 0xC1,
  // "ú" (U+00FA)
  0x30, 0x70, 0x13, 0x06, 0x07, 0x71, 0x8A, 0x59, 0xF2, 0xE8, 0x03, 0xF0, 0xA8, 0x03, 0xF0, 0xA8,
  0x03, 0xF0, 0xB8, 0x28, 0x3C, 0xBB, 0xC1,
  // "û" (U+00FB)
  0x00, 0x73, 0x00, 0x06, 0x7A, 0x00, 0x00, 0x00, 0x00, 0x9F, 0x2E, 0x80, 0x3F, 0x0A, 0x80, 0x3F,
  0x0A, 0x80, 0x3F, 0x0B, 0x80, 0x0C, 0xBB, 0xC1,
  // "ü" (U+00FC)
  0x08, 0x25, 0x00, 0x00, 0x00, 0x00, 0x9F, 0x2E, 0x80, 0x3F, 0x0A, 0x80, 0x3F, 0x0A, 0x80, 0x3F,
  0x0B, 0x80, 0x0C, 0xBB, 0xC1,
  // "ý" (U+00FD)
  0x00, 0x71, 0x00, 0x67, 0x00, 0x00, 0x00, 0x0C, 0xE3, 0xD6, 0x3E, 0x09, 0x00, 0xD5, 0x70, 0x08,
  0xD3, 0x00, 0x2D, 0x00, 0x04, 0x80, 0x07, 0xB1, 0x00,
  // "þ" (U+00FE)
  0x8F, 0x00, 0x03, 0xF0, 0x00, 0x3E, 0x8D, 0x33, 0xF1, 0x8A, 0x3F, 0x07, 0xB3, 0xF1, 0x8A, 0x3F,
  0x8D, 0x33, 0xF0, 0x00, 0x9F, 0x60, 0x00,
  // "ÿ" (U+00FF)
  0x08, 0x25, 0x00, 0x00, 0x00, 0xCE, 0x3D, 0x63, 0xE0, 0x90, 0x0D, 0x57, 0x00, 0x8D, 0x30, 0x02,
  0xD0, 0x00, 0x48, 0x00, 0x7B, 0x10, 0x00,
  // "Ā" (U+0100)
  0x00, 0xFF, 0x70, 0x00, 0xBF, 0x00, 0x03, 0x6E, 0x40, 0x08, 0x1A, 0x90, 0x0B, 0x9B, 0xD0, 0x28,
  0x01, 0xF2, 0xAB, 0x04, 0xFB,
  // "ā" (U+0101)
  0x08, 0xB7, 0x01, 0xCA, 0x90, 0x16, 0x3F, 0x02, 0xA9, 0xF0, 0x9A, 0x3F, 0x05, 0xD6, 0xF5,
  // "Ă" (U+0102)
  0x05, 0x05, 0x00, 0x03, 0xFF, 0x00, 0x00, 0xBF, 0x00, 0x03, 0x6E, 0x40, 0x08, 0x1A, 0x90, 0x0B,
  0x9B, 0xD0, 0x28, 0x01, 0xF2, 0xAB, 0x04, 0xFB,
  // "ă" (U+0103)
  0x05, 0x05, 0x00, 0x3B, 0x50, 0x1C, 0xA9, 0x01, 0x63, 0xF0, 0x2A, 0x9F, 0x09, 0xA3, 0xF0, 0x5D,
  0x6F, 0x50,
  // "Ą" (U+0104)
  0x00, 0xAB, 0x00, 0x00, 0xBF, 0x00, 0x03, 0x6E, 0x40, 0x08, 0x1A, 0x90, 0x0B, 0x9B, 0xD0, 0x28,
  0x01, 0xF2, 0xAB, 0x04, 0xFC, 0x00, 0x00, 0x92, 0x00, 0x00, 0x7A,
  // "ą" (U+0105)
  0x1C, 0xA9, 0x01, 0x63, 0xF0, 0x2A, 0x9F, 0x09, 0xA3, 0xF0, 0x5D, 0x7F, 0x50, 0x09, 0x20, 0x00,
  0x7A, 0x00,
  // "Ć" (U+0106)
  0x00, 0x07, 0x10, 0x06, 0x70, 0x05, 0xBB, 0x92, 0xF1, 0x0B, 0x7D, 0x00, 0x08, 0xC0, 0x00, 0x7D,
  0x00, 0x02, 0xF2, 0x03, 0x05, 0xCB, 0x80,
  // "ć" (U+0107)
  0x00, 0x71, 0x06, 0x70, 0x00, 0x00, 0x1B, 0xA9, 0x7A, 0x17, 0x99, 0x00, 0x7B, 0x01, 0x1B, 0xA8,
  // "Ĉ" (U+0108)
  0x00, 0x73, 0x00, 0x67, 0xA0, 0x05, 0xBB, 0x92, 0xF1, 0x0B, 0x7D, 0x00, 0x08, 0xC0, 0x00, 0x7D,
  0x00, 0x02, 0xF2, 0x03, 0x05, 0xCB, 0x80,
  // "ĉ" (U+0109)
  0x00, 0x73, 0x06, 0x7A, 0x00, 0x00, 0x1B, 0xA9, 0x7A, 0x17, 0x99, 0x00, 0x7B, 0x01, 0x1B, 0xA8,
  // "Ċ" (U+010A)
  0x00, 0x88, 0x00, 0x5B, 0xC9, 0x2F, 0x10, 0xB7, 0xD0, 0x00, 0x8C, 0x00, 0x07, 0xD0, 0x00, 0x2F,
  0x20, 0x30, 0x5C, 0xB8,
  // "ċ" (U+010B)
  0x08, 0x80, 0x00, 0x00, 0x1B, 0xA9, 0x7A, 0x17, 0x99, 0x00, 0x7B, 0x01, 0x1B, 0xA8,
  // "Č" (U+010C)
  0x04, 0x14, 0x00, 0x1D, 0x80, 0x05, 0xBB, 0x92, 0xF1, 0x0B, 0x7D, 0x00, 0x08, 0xC0, 0x00, 0x7D,
  0x00, 0x02, 0xF2, 0x03, 0x05, 0xCB, 0x80,
  // "č" (U+010D)
  0x04, 0x14, 0x01, 0xD8, 0x00, 0x00, 0x1B, 0xA9, 0x7A, 0x17, 0x99, 0x00, 0x7B, 0x01, 0x1B, 0xA8,
  // "Ď" (U+010E)
  0x04, 0x14, 0x00, 0x01, 0xD8, 0x00, 0x6F, 0x9A, 0x70, 0x0F, 0x30, 0xE4, 0x0F, 0x30, 0xB9, 0x0F,
  0x30, 0xAA, 0x0F, 0x30, 0xB8, 0x0F, 0x31, 0xF3, 0x6F, 0x9B, 0x60,
  // "ď" (U+010F)
  0x00, 0x4E, 0x6C, 0x00, 0x0C, 0x73, 0x2D, 0x9D, 0x60, 0x7A, 0x0E, 0x60, 0x99, 0x0D, 0x60, 0x7A,
  0x0E, 0x60, 0x2D, 0x9B, 0xC0,
  // "Đ" (U+0110)
  0x6F, 0x9A, 0x70, 0x0F, 0x30, 0xE4, 0x0F, 0x30, 0xB9, 0x6F, 0xA1, 0xAA, 0x0F, 0x30, 0xB8, 0x0F,
  0x31, 0xF3, 0x6F, 0x9B, 0x60,
  // "đ" (U+0111)
  0x00, 0x4E, 0x60, 0x07, 0xEA, 0x2D, 0x9D, 0x67, 0xA0, 0xE6, 0x99, 0x0D, 0x67, 0xA0, 0xE6, 0x2D,
  0x9B, 0xC0,
  // "Ē" (U+0112)
  0x6F, 0xFF, 0xA0, 0xF3, 0x06, 0x0F, 0x30, 0x00, 0xF9, 0x81, 0x0F, 0x30, 0x00, 0xF3, 0x06, 0x6F,
  0x97, 0xC0,
  // "ē" (U+0113)
  0x08, 0xB7, 0x01, 0xBA, 0x80, 0x7B, 0x0F, 0x19, 0xD9, 0xC2, 0x7B, 0x01, 0x01, 0xBA, 0xA0,
  // "Ĕ" (U+0114)
  0x05, 0x05, 0x06, 0xFF, 0xDA, 0x0F, 0x30, 0x60, 0xF3, 0x00, 0x0F, 0x98, 0x10, 0xF3, 0x00, 0x0F,
  0x30, 0x66, 0xF9, 0x7C,
  // "ĕ" (U+0115)
  0x05, 0x05, 0x00, 0x3B, 0x50, 0x1B, 0xA8, 0x07, 0xB0, 0xF1, 0x9D, 0x9C, 0x27, 0xB0, 0x10, 0x1B,
  0xAA, 0x00,
  // "Ė" (U+0116)
  0x00, 0x88, 0x06, 0xF9, 0x8A, 0x0F, 0x30, 0x60, 0xF3, 0x00, 0x0F, 0x98, 0x10, 0xF3, 0x00, 0x0F,
  0x30, 0x66, 0xF9, 0x7C,
  // "ė" (U+0117)
  0x10, 0x08, 0x78, 0xA6, 0x1B, 0xA8, 0x07, 0xB0, 0xF1, 0x9D, 0x9C, 0x27, 0xB0, 0x10, 0x1B, 0xAA,
  0x10,
  // "Ę" (U+0118)
  0x6F, 0x98, 0xA0, 0xF3, 0x06, 0x0F, 0x30, 0x00, 0xF9, 0x81, 0x0F, 0x30, 0x00, 0xF3, 0x06, 0x6F,
  0x97, 0xE0, 0x00, 0xB0, 0x00, 0x09, 0x90,
  // "ę" (U+0119)
  0x1B, 0xA8, 0x07, 0xB0, 0xF1, 0x9D, 0x9C, 0x27, 0xB0, 0x10, 0x1B, 0xBA, 0x00, 0x0A, 0x00, 0x01,
  0xC6, 0x00,
  // "Ě" (U+011A)
  0x04, 0x14, 0x00, 0x1D, 0x80, 0x6F, 0x98, 0xA0, 0xF3, 0x06, 0x0F, 0x30, 0x00, 0xF9, 0x81, 0x0F,
  0x30, 0x00, 0xF3, 0x06, 0x6F, 0x97, 0xC0,
  // "ě" (U+011B)
  0x04, 0x14, 0x00, 0x1D, 0x80, 0x00, 0x00, 0x01, 0xBA, 0x80, 0x7B, 0x0F, 0x19, 0xD9, 0xC2, 0x7B,
  0x01, 0x01, 0xBA, 0xA0,
  // "Ĝ" (U+011C)
  0x00, 0x07, 0x30, 0x00, 0x67, 0xA0, 0x04, 0xB9, 0xC1, 0x2F, 0x20, 0xB4, 0x7D, 0x00, 0x00, 0x8C,
  0x00, 0x00, 0x7D, 0x04, 0xB8, 0x2F, 0x20, 0xE5, 0x05, 0xB9, 0xC3,
  // "ĝ" (U+011D)
  0x07, 0x30, 0x06, 0x7A, 0x00, 0x00, 0x00, 0x03, 0xCB, 0xA4, 0x88, 0x7A, 0x02, 0xCA, 0x30, 0x67,
  0x20, 0x04, 0xFF, 0xE0, 0xE1, 0x0D, 0x29, 0xA8, 0x80,
  // "Ğ" (U+011E)
  0x00, 0x50, 0x50, 0x04, 0xEF, 0xF1, 0x2F, 0x20, 0xB4, 0x7D, 0x00, 0x00, 0x8C, 0x00, 0x00, 0x7D,
  0x04, 0xB8, 0x2F, 0x20, 0xE5, 0x05, 0xB9, 0xC3,
  // "ğ" (U+011F)
  0x50, 0x50, 0x03, 0xB5, 0x00, 0x3C, 0xBA, 0x48, 0x87, 0xA0, 0x2C, 0xA3, 0x06, 0x72, 0x00, 0x4F,
  0xFE, 0x0E, 0x10, 0xD2, 0x9A, 0x88, 0x00,
  // "Ġ" (U+0120)
  0x00, 0x88, 0x00, 0x04, 0xCA, 0xC1, 0x2F, 0x20, 0xB4, 0x7D, 0x00, 0x00, 0x8C, 0x00, 0x00, 0x7D,
  0x04, 0xB8, 0x2F, 0x20, 0xE5, 0x05, 0xB9, 0xC3,
  // "ġ" (U+0121)
  0x08, 0x80, 0x00, 0x00, 0x00, 0x3C, 0xBA, 0x48, 0x87, 0xA0, 0x2C, 0xA3, 0x06, 0x72, 0x00, 0x4F,
  0xFE, 0x0E, 0x10, 0xD2, 0x9A, 0x88, 0x00,
  // "Ģ" (U+0122)
  0x18, 0x93, 0x4B, 0x9C, 0x12, 0xF2, 0x0B, 0x47, 0xD4, 0x08, 0x0C, 0x48, 0xA0, 0x7D, 0x04, 0xB8,
  0x2F, 0x20, 0xE5, 0x05, 0xB9, 0xC3, 0x71, 0x06, 0x05, 0x40, 0x13,
  // "ģ" (U+0123)
  0x00, 0xA0, 0x00, 0x24, 0x00, 0x3C, 0xBA, 0x48, 0x87, 0xA0, 0x2C, 0xA3, 0x06, 0x72, 0x00, 0x4F,
  0xFE, 0x0E, 0x10, 0xD2, 0x9A, 0x88, 0x00,
  // "Ĥ" (U+0124)
  0x00, 0x07, 0x30, 0x00, 0x06, 0x7A, 0x00, 0x6F, 0x93, 0xDC, 0x20, 0xF3, 0x0A, 0x90, 0x0F, 0x30,
  0xA9, 0x00, 0xFA, 0x8D, 0x90, 0x0F, 0x30, 0xA9, 0x00, 0xF3, 0x0A, 0x90, 0x6F, 0x93, 0xDC, 0x20,
  // "ĥ" (U+0125)
  0x20, 0x70, 0x32, 0x81, 0x67, 0xA6, 0x09, 0x93, 0x03, 0x93, 0x8A, 0x73, 0xF9, 0xE3, 0x3F, 0x1A,
  0x83, 0xF0, 0x98, 0x2F, 0x09, 0x88, 0xF5, 0x9C,
  // "Ħ" (U+0126)
  0x6F, 0xA3, 0xDD, 0x20, 0xF3, 0x0A, 0x90, 0x6F, 0x97, 0xCC, 0x20, 0xFA, 0x8D, 0x90, 0x0F, 0x30,
  0xA9, 0x00, 0xF3, 0x0A, 0x90, 0x6F, 0x93, 0xDC, 0x20,
  // "ħ" (U+0127)
  0x9F, 0x00, 0x08, 0xF7, 0x10, 0x3F, 0xAE, 0x33, 0xF2, 0xB8, 0x3F, 0x09, 0x83, 0xF0, 0x98, 0x8F,
  0x59, 0xC0,
  // "Ĩ" (U+0128)
  0x3B, 0x55, 0xDF, 0xF1, 0x0F, 0x30, 0x0F, 0x30, 0x0F, 0x30, 0x0F, 0x30, 0x0F, 0x30, 0x6F, 0x90,
  // "ĩ" (U+0129)
  0x3B, 0x55, 0x72, 0xB1, 0x09, 0xF0, 0x03, 0xF0, 0x03, 0xF0, 0x03, 0xF0, 0x08, 0xF6,
  // "Ī" (U+012A)
  0xEF, 0xF0, 0xF3, 0x0F, 0x30, 0xF3, 0x0F, 0x30, 0xF3, 0x6F, 0x90,
  // "ī" (U+012B)
  0x8B, 0x79, 0xF0, 0x3F, 0x03, 0xF0, 0x3F, 0x08, 0xF6,
  // "Ĭ" (U+012C)
  0x50, 0x5A, 0xFF, 0x0F, 0x30, 0xF3, 0x0F, 0x30, 0xF3, 0x0F, 0x36, 0xF9,
  // "ĭ" (U+012D)
  0x50, 0x53, 0xB5, 0x9F, 0x03, 0xF0, 0x3F, 0x03, 0xF0, 0x8F, 0x60,
  // "Į" (U+012E)
  0x6F, 0x90, 0xF3, 0x0F, 0x30, 0xF3, 0x0F, 0x30, 0xF3, 0x6F, 0xB0, 0xB0, 0x09, 0x90,
  // "į" (U+012F)
  0x3D, 0x00, 0x30, 0x9F, 0x03, 0xF0, 0x3F, 0x03, 0xF0, 0x8F, 0x70, 0xB0, 0x09, 0x90,
  // "İ" (U+0130)
  0x08, 0x86, 0xFA, 0x0F, 0x30, 0xF3, 0x0F, 0x30, 0xF3, 0x0F, 0x36, 0xF9,
  // "ı" (U+0131)
  0x9F, 0x03, 0xF0, 0x3F, 0x03, 0xF0, 0x8F, 0x60,
  // "Ĳ" (U+0132)
  0x6F, 0x97, 0xFA, 0x0F, 0x30, 0xF3, 0x0F, 0x30, 0xF3, 0x0F, 0x30, 0xF3, 0x0F, 0x30, 0xF3, 0x0F,
  0x30, 0xF3, 0x6F, 0x90, 0xF3, 0x00, 0x01, 0xF1, 0x00, 0x1B, 0x70,
  // "ĳ" (U+0133)
  0x3D, 0x02, 0xD0, 0x30, 0x03, 0x9F, 0x09, 0xF3, 0xF0, 0x3F, 0x3F, 0x03, 0xF3, 0xF0, 0x3F, 0x8F,
  0x63, 0xF0, 0x00, 0x4E, 0x00, 0x1B, 0x60,
  // "Ĵ" (U+0134)
  0x00, 0x73, 0x06, 0x7A, 0x07, 0xFA, 0x00, 0xF3, 0x00, 0xF3, 0x00, 0xF3, 0x00, 0xF3, 0x00, 0xF3,
  0x00, 0xF3, 0x01, 0xF1, 0x1B, 0x70,
  // "ĵ" (U+0135)
  0x07, 0x36, 0x7A, 0x00, 0x09, 0xF0, 0x3F, 0x03, 0xF0, 0x3F, 0x03, 0xF0, 0x4E, 0x0B, 0x70,
  // "Ķ" (U+0136)
  0x89, 0x16, 0xF9, 0x4F, 0x60, 0xF3, 0x56, 0x29, 0x05, 0x09, 0x39, 0x0E, 0x0C, 0x39, 0x81, 0x5F,
  0x42, 0x98, 0x90, 0x39, 0xC0, 0x6F, 0x91, 0xD9, 0x71, 0x06, 0x05, 0x40, 0x13,
  // "ķ" (U+0137)
  0x08, 0x93, 0x03, 0x93, 0x89, 0x13, 0xF1, 0xE7, 0x3F, 0x67, 0x03, 0xA8, 0x92, 0x70, 0x3F, 0x5E,
  0x18, 0xF6, 0xAC, 0x70, 0x60, 0x53, 0x01, 0x20,
  // "ĸ" (U+0138)
  0x8F, 0x1E, 0x73, 0xF6, 0x70, 0x3F, 0xF7, 0x03, 0xF5, 0xE1, 0x8F, 0x6A, 0xC0,
  // "Ĺ" (U+0139)
  0x00, 0x71, 0x00, 0x67, 0x00, 0x6F, 0x90, 0x00, 0xF3, 0x00, 0x0F, 0x30, 0x00, 0xF3, 0x00, 0x0F,
  0x30, 0x10, 0xF3, 0x08, 0x6F, 0x97, 0xD0,
  // "ĺ" (U+013A)
  0x00, 0x71, 0x06, 0x70, 0x00, 0x00, 0x9F, 0x00, 0x3F, 0x00, 0x3F, 0x00, 0x3F, 0x00, 0x3F, 0x00,
  0x3F, 0x00, 0x8F, 0x60,
  // "Ļ" (U+013B)
  0x81, 0x6F, 0x93, 0x90, 0x33, 0x90, 0x33, 0x90, 0x33, 0x98, 0x93, 0x30, 0x10, 0xF3, 0x08, 0x6F,
  0x97, 0xD7, 0x06, 0x05, 0x30, 0x12,
  // "ļ" (U+013C)
  0x9F, 0x03, 0xF0, 0x3F, 0x03, 0xF0, 0x3F, 0x03, 0xF0, 0x8F, 0x60, 0x00, 0x65, 0x01, 0x00,
  // "Ľ" (U+013D)
  0x6F, 0x92, 0xA0, 0xF3, 0x21, 0x0F, 0x30, 0x00, 0xF3, 0x00, 0x0F, 0x30, 0x10, 0xF3, 0x08, 0x6F,
  0x97, 0xD0,
  // "ľ" (U+013E)
  0x9F, 0x57, 0x3F, 0x30, 0x3F, 0x00, 0x3F, 0x00, 0x3F, 0x00, 0x3F, 0x00, 0x8F, 0x60,
  // "Ŀ" (U+013F)
  0x6F, 0x90, 0x00, 0xF3, 0x00, 0x0F, 0x30, 0x00, 0xF3, 0x88, 0x0F, 0x30, 0x10, 0xF3, 0x08, 0x6F,
  0x97, 0xD0,
  // "ŀ" (U+0140)
  0x9F, 0x00, 0x3F, 0x00, 0x3F, 0x00, 0x3F, 0x88, 0x3F, 0x10, 0x3F, 0x00, 0x8F, 0x60,
  // "Ł" (U+0141)
  0x6F, 0x90, 0x00, 0xF3, 0x00, 0x0F, 0xA3, 0x02, 0xF5, 0x00, 0x6F, 0x30, 0x10, 0xF3, 0x08, 0x6F,
  0x97, 0xD0,
  // "ł" (U+0142)
  0x9F, 0x03, 0xF0, 0x3F, 0x13, 0xF5, 0x8F, 0x03, 0xF0, 0x8F, 0x60,
  // "Ń" (U+0143)
  0x00, 0x07, 0x10, 0x00, 0x06, 0x70, 0x00, 0x6F, 0x40, 0x8B, 0x10, 0xED, 0x02, 0x60, 0x09, 0xD6,
  0x26, 0x00, 0x85, 0xE3, 0x60, 0x08, 0x0B, 0xB6, 0x00, 0x80, 0x2F, 0x60, 0x6C, 0x20, 0x96, 0x00,
  // "ń" (U+0144)
  0x00, 0x07, 0x10, 0x06, 0x70, 0x00, 0x00, 0x08, 0xE9, 0xE3, 0x3F, 0x1A, 0x83, 0xF0, 0x98, 0x3F,
  0x09, 0x88, 0xF5, 0x9C,
  // "Ņ" (U+0145)
  0x89, 0x36, 0xF4, 0x08, 0xB1, 0x0E, 0xD0, 0x26, 0x28, 0x39, 0xD6, 0x26, 0x28, 0x38, 0x5E, 0x36,
  0x28, 0x38, 0x0B, 0xB6, 0x28, 0x92, 0x80, 0x2F, 0x60, 0x6C, 0x20, 0x96, 0x73, 0x06, 0x05, 0x50,
  0x14,
  // "ņ" (U+0146)
  0x8A, 0x78, 0xE9, 0xE3, 0x3F, 0x1A, 0x83, 0xF0, 0x98, 0x3F, 0x09, 0x88, 0xF5, 0x9C, 0x70, 0x60,
  0x53, 0x01, 0x20,
  // "Ň" (U+0147)
  0x00, 0x41, 0x40, 0x00, 0x01, 0xD8, 0x00, 0x6F, 0x40, 0x8B, 0x10, 0xED, 0x02, 0x60, 0x09, 0xD6,
  0x26, 0x00, 0x85, 0xE3, 0x60, 0x08, 0x0B, 0xB6, 0x00, 0x80, 0x2F, 0x60, 0x6C, 0x20, 0x96, 0x00,
  // "ň" (U+0148)
  0x04, 0x14, 0x00, 0x1D, 0x80, 0x00, 0x00, 0x08, 0xE9, 0xE3, 0x3F, 0x1A, 0x83, 0xF0, 0x98, 0x3F,
  0x09, 0x88, 0xF5, 0x9C,
  // "ŉ" (U+0149)
  0x69, 0x00, 0x00, 0x01, 0xA0, 0x00, 0x00, 0x52, 0x8E, 0x9E, 0x30, 0x03, 0xF1, 0xA8, 0x00, 0x3F,
  0x09, 0x80, 0x03, 0xF0, 0x98, 0x00, 0x8F, 0x59, 0xC0,
  // "Ŋ" (U+014A)
  0x7F, 0x40, 0x9B, 0x10, 0xED, 0x02, 0x60, 0x09, 0xD7, 0x26, 0x00, 0x84, 0xE4, 0x60, 0x08, 0x0A,
  0xD6, 0x00, 0x80, 0x1E, 0x60, 0x6C, 0x20, 0x76, 0x00, 0x00, 0x03, 0x50, 0x00, 0x01, 0xA1, 0x00,
  // "ŋ" (U+014B)
  0x8E, 0x9E, 0x33, 0xF1, 0xA8, 0x3F, 0x09, 0x83, 0xF0, 0x98, 0x8F, 0x59, 0x80, 0x00, 0xA7, 0x00,
  0x4C, 0x20,
  // "Ō" (U+014C)
  0x06, 0xFF, 0xF0, 0x2F, 0x10, 0xC6, 0x7D, 0x00, 0x8B, 0x8C, 0x00, 0x7D, 0x7D, 0x00, 0x8B, 0x2F,
  0x10, 0xC6, 0x06, 0xB9, 0x90,
  // "ō" (U+014D)
  0x08, 0xB7, 0x01, 0xB9, 0xA0, 0x7A, 0x0C, 0x59, 0x90, 0xB7, 0x7A, 0x0C, 0x51, 0xB9, 0xA0,
  // "Ŏ" (U+014E)
  0x00, 0x50, 0x50, 0x06, 0xEF, 0xE0, 0x2F, 0x10, 0xC6, 0x7D, 0x00, 0x8B, 0x8C, 0x00, 0x7D, 0x7D,
  0x00, 0x8B, 0x2F, 0x10, 0xC6, 0x06, 0xB9, 0x90,
  // "ŏ" (U+014F)
  0x05, 0x05, 0x00, 0x3B, 0x50, 0x1B, 0x9A, 0x07, 0xA0, 0xC5, 0x99, 0x0B, 0x77, 0xA0, 0xC5, 0x1B,
  0x9A, 0x00,
  // "Ő" (U+0150)
  0x00, 0x49, 0xA3, 0x06, 0xCA, 0xA0, 0x2F, 0x10, 0xC6, 0x7D, 0x00, 0x8B, 0x8C, 0x00, 0x7D, 0x7D,
  0x00, 0x8B, 0x2F, 0x10, 0xC6, 0x06, 0xB9, 0x90,
  // "ő" (U+0151)
  0x04, 0x9A, 0x30, 0x10, 0x10, 0x1B, 0x9A, 0x07, 0xA0, 0xC5, 0x99, 0x0B, 0x77, 0xA0, 0xC5, 0x1B,
  0x9A, 0x00,
  // "Œ" (U+0152)
  0x06, 0xBB, 0xFA, 0xA9, 0x2F, 0x11, 0xF2, 0x06, 0x7D, 0x01, 0xF2, 0x00, 0x8C, 0x01, 0xF9, 0x80,
  0x7D, 0x01, 0xF2, 0x00, 0x2F, 0x11, 0xF2, 0x06, 0x06, 0xBB, 0xFA, 0x9C,
  // "œ" (U+0153)
  0x1B, 0x99, 0xBA, 0x70, 0x7A, 0x0C, 0x92, 0xF0, 0x99, 0x0B, 0xC8, 0xB1, 0x7A, 0x0C, 0x90, 0x10,
  0x1B, 0x9A, 0xBA, 0x90,
  // "Ŕ" (U+0154)
  0x00, 0x07, 0x10, 0x00, 0x67, 0x00, 0x6F, 0x9B, 0x60, 0x0F, 0x36, 0xE0, 0x0F, 0x37, 0xC0, 0x0F,
  0xAE, 0x20, 0x0F, 0x3D, 0x50, 0x0F, 0x37, 0xC0, 0x6F, 0x91, 0xD7,
  // "ŕ" (U+0155)
  0x00, 0x71, 0x06, 0x70, 0x00, 0x00, 0x8E, 0xAD, 0x3F, 0x27, 0x3F, 0x00, 0x3F, 0x00, 0x8F, 0x70,
  // "Ŗ" (U+0156)
  0x6F, 0x9B, 0x60, 0x0F, 0x36, 0xE0, 0x0F, 0x37, 0xC0, 0x0F, 0xAE, 0x20, 0x0F, 0x3D, 0x50, 0x0F,
  0x37, 0xC0, 0x6F, 0x91, 0xD7, 0x00, 0x00, 0x00, 0x00, 0x65, 0x00, 0x00, 0x10, 0x00,
  // "ŗ" (U+0157)
  0x8E, 0xAD, 0x3F, 0x27, 0x3F, 0x00, 0x3F, 0x00, 0x8F, 0x70, 0x00, 0x00, 0x65, 0x00, 0x10, 0x00,
  // "Ř" (U+0158)
  0x04, 0x14, 0x00, 0x01, 0xD8, 0x00, 0x6F, 0x9B, 0x60, 0x0F, 0x36, 0xE0, 0x0F, 0x37, 0xC0, 0x0F,
  0xAE, 0x20, 0x0F, 0x3D, 0x50, 0x0F, 0x37, 0xC0, 0x6F, 0x91, 0xD7,
  // "ř" (U+0159)
  0x41, 0x40, 0x1D, 0x80, 0x00, 0x00, 0x8E, 0xAD, 0x3F, 0x27, 0x3F, 0x00, 0x3F, 0x00, 0x8F, 0x70,
  // "Ś" (U+015A)
  0x00, 0x07, 0x10, 0x06, 0x70, 0x19, 0xAA, 0x07, 0x70, 0xB0, 0x7E, 0x40, 0x01, 0xBF, 0xA0, 0x00,
  0x6F, 0x3A, 0x30, 0xC2, 0x5B, 0x87, 0x00,
  // "ś" (U+015B)
  0x00, 0x71, 0x06, 0x70, 0x00, 0x00, 0x49, 0xB3, 0xA8, 0x31, 0x3D, 0xD3, 0x71, 0x98, 0x79, 0xA3,
  // "Ŝ" (U+015C)
  0x00, 0x73, 0x00, 0x67, 0xA0, 0x19, 0xAA, 0x07, 0x70, 0xB0, 0x7E, 0x40, 0x01, 0xBF, 0xA0, 0x00,
  0x6F, 0x3A, 0x30, 0xC2, 0x5B, 0x87, 0x00,
  // "ŝ" (U+015D)
  0x07, 0x30, 0x67, 0xA0, 0x00, 0x00, 0x49, 0xB3, 0xA8, 0x31, 0x3D, 0xD3, 0x71, 0x98, 0x79, 0xA3,
  // "Ş" (U+015E)
  0x19, 0xAA, 0x07, 0x70, 0xB0, 0x7E, 0x40, 0x01, 0xBF, 0xA0, 0x00, 0x6F, 0x3A, 0x30, 0xC2, 0x5D,
  0xF7, 0x00, 0x09, 0x20, 0x05, 0x90, 0x00,
  // "ş" (U+015F)
  0x49, 0xB3, 0xA8, 0x31, 0x3D, 0xD3, 0x71, 0x98, 0x7B, 0xF3, 0x00, 0x92, 0x05, 0x90,
  // "Š" (U+0160)
  0x04, 0x14, 0x00, 0x1D, 0x80, 0x19, 0xAA, 0x07, 0x70, 0xB0, 0x7E, 0x40, 0x01, 0xBF, 0xA0, 0x00,
  0x6F, 0x3A, 0x30, 0xC2, 0x5B, 0x87, 0x00,
  // "š" (U+0161)
  0x41, 0x40, 0x1D, 0x80, 0x00, 0x00, 0x49, 0xB3, 0xA8, 0x31, 0x3D, 0xD3, 0x71, 0x98, 0x79, 0xA3,
  // "Ţ" (U+0162)
  0x89, 0x2C, 0x9F, 0xAD, 0x16, 0x0F, 0x35, 0x12, 0x90, 0x34, 0x90, 0x34, 0x90, 0x34, 0x90, 0x33,
  0x81, 0x6F, 0xE5, 0x0C, 0x40, 0x80, 0x62,
  // "ţ" (U+0163)
  0x1D, 0x09, 0xF9, 0x3F, 0x03, 0xF0, 0x3F, 0x01, 0xFF, 0x00, 0xC0, 0x86,
  // "Ť" (U+0164)
  0x18, 0x14, 0x14, 0x38, 0x11, 0xD8, 0x28, 0x92, 0xC9, 0xFA, 0xD1, 0x60, 0xF3, 0x51, 0x29, 0x03,
  0x49, 0x03, 0x49, 0x03, 0x49, 0x03, 0x38, 0x16, 0xF9, 0x20,
  // "ť" (U+0165)
  0x01, 0x57, 0x1D, 0x30, 0x9F, 0x90, 0x3F, 0x00, 0x3F, 0x00, 0x3F, 0x00, 0x1D, 0xA0,
  // "Ŧ" (U+0166)
  0xC9, 0xFA, 0xD1, 0x60, 0xF3, 0x51, 0x00, 0xF3, 0x00, 0x17, 0xF9, 0x20, 0x00, 0xF3, 0x00, 0x00,
  0xF3, 0x00, 0x06, 0xF9, 0x00,
  // "ŧ" (U+0167)
  0x1D, 0x09, 0xF9, 0x3F, 0x07, 0xF6, 0x3F, 0x01, 0xDA,
  // "Ũ" (U+0168)
  0x03, 0xB5, 0x50, 0x8F, 0xBD, 0xD7, 0x1F, 0x20, 0x71, 0x1F, 0x20, 0x71, 0x1F, 0x20, 0x71, 0x1F,
  0x20, 0x71, 0x0F, 0x30, 0x80, 0x06, 0xC9, 0x60,
  // "ũ" (U+0169)
  0x03, 0xB5, 0x50, 0x07, 0x2B, 0x10, 0x9F, 0x2E, 0x80, 0x3F, 0x0A, 0x80, 0x3F, 0x0A, 0x80, 0x3F,
  0x0B, 0x80, 0x0C, 0xBB, 0xC1,
  // "Ū" (U+016A)
  0x8F, 0xFD, 0xF7, 0x1F, 0x20, 0x71, 0x1F, 0x20, 0x71, 0x1F, 0x20, 0x71, 0x1F, 0x20, 0x71, 0x0F,
  0x30, 0x80, 0x06, 0xC9, 0x60,
  // "ū" (U+016B)
  0x08, 0xB7, 0x00, 0x9F, 0x2E, 0x80, 0x3F, 0x0A, 0x80, 0x3F, 0x0A, 0x80, 0x3F, 0x0B, 0x80, 0x0C,
  0xBB, 0xC1,
  // "Ŭ" (U+016C)
  0x00, 0x50, 0x50, 0x8F, 0xCD, 0xF7, 0x1F, 0x20, 0x71, 0x1F, 0x20, 0x71, 0x1F, 0x20, 0x71, 0x1F,
  0x20, 0x71, 0x0F, 0x30, 0x80, 0x06, 0xC9, 0x60,
  // "ŭ" (U+016D)
  0x05, 0x05, 0x00, 0x03, 0xB5, 0x00, 0x9F, 0x2E, 0x80, 0x3F, 0x0A, 0x80, 0x3F, 0x0A, 0x80, 0x3F,
  0x0B, 0x80, 0x0C, 0xBB, 0xC1,
  // "Ů" (U+016E)
  0x00, 0x47, 0x10, 0x8F, 0xD9, 0xD7, 0x1F, 0x20, 0x71, 0x1F, 0x20, 0x71, 0x1F, 0x20, 0x71, 0x1F,
  0x20, 0x71, 0x0F, 0x30, 0x80, 0x06, 0xC9, 0x60,
  // "ů" (U+016F)
  0x04, 0x71, 0x00, 0x04, 0x71, 0x00, 0x9F, 0x2E, 0x80, 0x3F, 0x0A, 0x80, 0x3F, 0x0A, 0x80, 0x3F,
  0x0B, 0x80, 0x0C, 0xBB, 0xC1,
  // "Ű" (U+0170)
  0x00, 0x49, 0xA3, 0x8F, 0xA2, 0xD7, 0x1F, 0x20, 0x71, 0x1F, 0x20, 0x71, 0x1F, 0x20, 0x71, 0x1F,
  0x20, 0x71, 0x0F, 0x30, 0x80, 0x06, 0xC9, 0x60,
  // "ű" (U+0171)
  0x04, 0x9A, 0x30, 0x01, 0x01, 0x00, 0x9F, 0x2E, 0x80, 0x3F, 0x0A, 0x80, 0x3F, 0x0A, 0x80, 0x3F,
  0x0B, 0x80, 0x0C, 0xBB, 0xC1,
  // "Ų" (U+0172)
  0x8F, 0x81, 0xC7, 0x1F, 0x20, 0x71, 0x1F, 0x20, 0x71, 0x1F, 0x20, 0x71, 0x1F, 0x20, 0x71, 0x0F,
  0x30, 0x80, 0x06, 0xCA, 0x60, 0x00, 0xB0, 0x00, 0x00, 0x99, 0x00,
  // "ų" (U+0173)
  0x9F, 0x2E, 0x80, 0x3F, 0x0A, 0x80, 0x3F, 0x0A, 0x80, 0x3F, 0x0B, 0x80, 0x0C, 0xBD, 0xC1, 0x00,
  0x92, 0x00, 0x00, 0x7A, 0x00,
  // "Ŵ" (U+0174)
  0x40, 0x70, 0x36, 0x81, 0x67, 0xA3, 0x89, 0x7B, 0xF6, 0x0C, 0x04, 0xE4, 0x3F, 0x11, 0xF4, 0x0A,
  0x28, 0x5E, 0x55, 0xE8, 0x27, 0x28, 0x5B, 0x89, 0x6D, 0x54, 0x28, 0x57, 0xC9, 0x1F, 0x91, 0x28,
  0x43, 0xF7, 0x0C, 0xC4, 0x83, 0xE3, 0x08, 0x92,
  // "ŵ" (U+0175)
  0x30, 0x70, 0x34, 0x81, 0x67, 0xA7, 0x28, 0xA2, 0xCE, 0x2B, 0x1B, 0x94, 0xD0, 0xF5, 0x71, 0x0F,
  0x6A, 0xA8, 0x28, 0x3C, 0xC2, 0xD7, 0x28, 0x38, 0x90, 0xD4, 0x10,
  // "Ŷ" (U+0176)
  0x00, 0x73, 0x00, 0x06, 0x7A, 0x00, 0xBF, 0x64, 0xE4, 0x2F, 0x30, 0x90, 0x0A, 0x95, 0x40, 0x04,
  0xE9, 0x00, 0x00, 0xD7, 0x00, 0x00, 0xD6, 0x00, 0x05, 0xEB, 0x10,
  // "ŷ" (U+0177)
  0x00, 0x73, 0x00, 0x67, 0xA0, 0x00, 0x00, 0x0C, 0xE3, 0xD6, 0x3E, 0x09, 0x00, 0xD5, 0x70, 0x08,
  0xD3, 0x00, 0x2D, 0x00, 0x04, 0x80, 0x07, 0xB1, 0x00,
  // "Ÿ" (U+0178)
  0x00, 0x82, 0x50, 0xBF, 0x64, 0xE4, 0x2F, 0x30, 0x90, 0x0A, 0x95, 0x40, 0x04, 0xE9, 0x00, 0x00,
  0xD7, 0x00, 0x00, 0xD6, 0x00, 0x05, 0xEB, 0x10,
  // "Ź" (U+0179)
  0x00, 0x07, 0x10, 0x06, 0x70, 0x7B, 0x8D, 0xB7, 0x12, 0xF4, 0x00, 0x9B, 0x00, 0x2F, 0x40, 0x09,
  0xB0, 0x02, 0xF4, 0x09, 0x9E, 0x89, 0xE0,
  // "ź" (U+017A)
  0x00, 0x71, 0x06, 0x70, 0x00, 0x00, 0x99, 0xDC, 0x31, 0xE3, 0x09, 0xA0, 0x3E, 0x15, 0xBD, 0x9D,
  // "Ż" (U+017B)
  0x00, 0x88, 0x07, 0xB9, 0xEB, 0x71, 0x2F, 0x40, 0x09, 0xB0, 0x02, 0xF4, 0x00, 0x9B, 0x00, 0x2F,
  0x40, 0x99, 0xE8, 0x9E,
  // "ż" (U+017C)
  0x08, 0x80, 0x00, 0x00, 0x99, 0xDC, 0x31, 0xE3, 0x09, 0xA0, 0x3E, 0x15, 0xBD, 0x9D,
  // "Ž" (U+017D)
  0x04, 0x14, 0x00, 0x1D, 0x80, 0x7B, 0x8D, 0xB7, 0x12, 0xF4, 0x00, 0x9B, 0x00, 0x2F, 0x40, 0x09,
  0xB0, 0x02, 0xF4, 0x09, 0x9E, 0x89, 0xE0,
  // "ž" (U+017E)
  0x41, 0x40, 0x1D, 0x80, 0x00, 0x00, 0x99, 0xDC, 0x31, 0xE3, 0x09, 0xA0, 0x3E, 0x15, 0xBD, 0x9D,
  // "ſ" (U+017F)
  0x0A, 0xA8, 0x2F, 0x11, 0x3F, 0x00, 0x3F, 0x00, 0x3F, 0x00, 0x3F, 0x00, 0x9F, 0x80,
  // "Ω" (U+03A9)
  0x06, 0xB9, 0xB1, 0x03, 0xF1, 0x09, 0xA0, 0x6E, 0x00, 0x7E, 0x05, 0xE0, 0x08, 0xC0, 0x0C, 0x72,
  0xD4, 0x06, 0x08, 0x71, 0x61, 0x9F, 0xE8, 0xEF, 0x10,
  // "μ" (U+03BC)
  0x3E, 0x0A, 0x83, 0xE0, 0xA8, 0x3E, 0x0A, 0x84, 0xF0, 0xC8, 0x4D, 0xA8, 0xC5, 0x60, 0x00, 0x3D,
  0x00, 0x00,
  // "π" (U+03C0)
  0x5E, 0xFF, 0xF1, 0x68, 0x4A, 0x30, 0x08, 0x1A, 0x00, 0x0B, 0x0B, 0x00, 0x5B, 0x08, 0x80,
  // "–" (U+2013)
  0xAA, 0xAA,
  // "—" (U+2014)
  0x80, 0x4A,
  // "€" (U+20AC)
  0x05, 0xBC, 0x10, 0xE1, 0xB4, 0x3D, 0x02, 0x09, 0xE8, 0x20, 0x9E, 0x80, 0x02, 0xE0, 0x00, 0x07,
  0xBA, 0x10,
  // "₿" (U+20BF)
  0x8E, 0xA7, 0x04, 0xD2, 0xF0, 0x4D, 0x3E, 0x04, 0xEB, 0x70, 0x4D, 0x0F, 0x14, 0xD0, 0xF2, 0x8E,
  0x9A, 0x00, 0x44, 0x00,
  // "‘" (U+2018)
  0x06, 0x65, 0x5A,
  // "’" (U+2019)
  0x69, 0x1A, 0x52,
  // "‚" (U+201A)
  0x69, 0x1A, 0x42,
  // "‛" (U+201B)
  0x5A, 0x65, 0x06,
  // "“" (U+201C)
  0x06, 0x24, 0x65, 0xB1, 0x5A, 0xA5,
  // "”" (U+201D)
  0x69, 0xB4, 0x1A, 0x65, 0x52, 0x60,
  // "„" (U+201E)
  0x69, 0xB4, 0x1A, 0x65, 0x42, 0x60,
  // "‟" (U+201F)
  0x5A, 0xA5, 0x65, 0xB1, 0x06, 0x24,
  // "†" (U+2020)
  0x07, 0x50, 0x15, 0x31, 0x9C, 0xB7, 0x08, 0x60, 0x08, 0x50, 0x06, 0x30, 0x05, 0x20, 0x04, 0x20,
  // "‡" (U+2021)
  0x07, 0x50, 0x7A, 0x95, 0x38, 0x62, 0x06, 0x30, 0x06, 0x30, 0x17, 0x51, 0x8B, 0xB6, 0x07, 0x40,
  // "•" (U+2022)
  0x4E, 0x67, 0xFA, 0x3C, 0x50,
  // "…" (U+2026)
  0x14, 0x04, 0x02, 0x35, 0xB0, 0xD2, 0x79,
  // "‰" (U+2030)
  0x84, 0x39, 0x80, 0x71, 0x58, 0x39, 0x3C, 0x19, 0x68, 0x3B, 0x2C, 0x64, 0x68, 0xA4, 0x84, 0xC9,
  0x48, 0x41, 0x86, 0x01, 0x87, 0x7C, 0x1D, 0x94, 0xB1, 0x28, 0x77, 0x2D, 0x0D, 0x93, 0xB2, 0x28,
  0x69, 0x07, 0x77, 0x38, 0x91,
  // "‹" (U+2039)
  0x05, 0x12, 0xB0, 0x5A, 0x00, 0x91,
  // "›" (U+203A)
  0x33, 0x00, 0xC1, 0x0C, 0x24, 0x70,
  // "⁄" (U+2044)
  0x00, 0x09, 0x00, 0x35, 0x00, 0x90, 0x01, 0x80, 0x07, 0x20, 0x09, 0x00, 0x45, 0x00,
  // "™" (U+2122)
  0xAE, 0xBC, 0x0B, 0x41, 0x71, 0xB9, 0xC0, 0x3E, 0x4A, 0xAC, 0x40,
  // "⅒" (U+2152)
  0x40, 0x94, 0x83, 0x3A, 0x03, 0x55, 0x81, 0xB1, 0x96, 0x89, 0x7B, 0x28, 0x3A, 0x37, 0x42, 0x9C,
  0x20, 0xBB, 0x2C, 0x20, 0x92, 0x89, 0x3B, 0xA2, 0xC0, 0x45, 0x02, 0x97, 0x74,
  // "ﬁ" (U+FB01)
  0x07, 0x9C, 0x90, 0x0F, 0x13, 0x40, 0x8F, 0xAB, 0xE0, 0x1F, 0x14, 0xE0, 0x1F, 0x14, 0xE0, 0x1F,
  0x14, 0xE0, 0x8F, 0x89, 0xF5,
  // "ﬂ" (U+FB02)
  0x07, 0x9C, 0xE0, 0x0F, 0x14, 0xE0, 0x8F, 0xA5, 0xE0, 0x1F, 0x14, 0xE0, 0x1F, 0x14, 0xE0, 0x1F,
  0x14, 0xE0, 0x8F, 0x79, 0xF5,
};

const Font& font_NotoSerif_Bold_8() {
  static SmoothFont font(font_NotoSerif_Bold_8_data);
  return font;
}

}  // namespace roo_display
