#include "18.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSerif-Bold (Noto Serif Bold)
// Generated on Wed Nov 19 19:11:38 CET 2025
static const uint8_t font_NotoSerif_Bold_18_data[] PROGMEM = {
  
  // Header
  0x01, 0x02, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x08, 0x52,
  0xFC, 0xFC, 0x16, 0x12, 0x0E, 0xFC, 0x05, 0x01, 0x18, 0x06, 0x06, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x41, 0x01, 0x04, 0x0D, 0x07, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x41, 0x09, 0x07, 0x0D, 0x09, 0x00, 0x1A, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x09, 0x0D, 0x0A, 0x00, 0x2C, // "#" (U+0023)
  0x00, 0x24, 0x00, 0xFF, 0x09, 0x0E, 0x0A, 0x00, 0x65, // "$" (U+0024)
  0x00, 0x25, 0x00, 0x01, 0x0F, 0x0D, 0x10, 0x00, 0xA9, // "%" (U+0025)
  0x00, 0x26, 0x00, 0x01, 0x0E, 0x0D, 0x0E, 0x01, 0x0E, // "&" (U+0026)
  0x00, 0x27, 0x41, 0x09, 0x03, 0x0D, 0x05, 0x01, 0x62, // "'" (U+0027)
  0x00, 0x28, 0x01, 0xFE, 0x06, 0x0E, 0x07, 0x01, 0x6A, // "(" (U+0028)
  0x00, 0x29, 0x00, 0xFE, 0x06, 0x0E, 0x07, 0x01, 0x99, // ")" (U+0029)
  0x00, 0x2A, 0x00, 0x08, 0x08, 0x0E, 0x09, 0x01, 0xCA, // "*" (U+002A)
  0x00, 0x2B, 0x01, 0x04, 0x08, 0x0B, 0x0A, 0x01, 0xE9, // "+" (U+002B)
  0x00, 0x2C, 0x40, 0xFE, 0x03, 0x03, 0x05, 0x02, 0x00, // "," (U+002C)
  0x00, 0x2D, 0x40, 0x05, 0x05, 0x06, 0x06, 0x02, 0x0C, // "-" (U+002D)
  0x00, 0x2E, 0x41, 0x01, 0x04, 0x03, 0x05, 0x02, 0x12, // "." (U+002E)
  0x00, 0x2F, 0x00, 0xFF, 0x05, 0x0E, 0x05, 0x02, 0x18, // "/" (U+002F)
  0x00, 0x30, 0x40, 0x01, 0x09, 0x0D, 0x0A, 0x02, 0x43, // "0" (U+0030)
  0x00, 0x31, 0x00, 0x01, 0x09, 0x0D, 0x0A, 0x02, 0x84, // "1" (U+0031)
  0x00, 0x32, 0x00, 0x01, 0x09, 0x0D, 0x0A, 0x02, 0xB3, // "2" (U+0032)
  0x00, 0x33, 0x00, 0x01, 0x09, 0x0D, 0x0A, 0x02, 0xE8, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x01, 0x09, 0x0D, 0x0A, 0x03, 0x24, // "4" (U+0034)
  0x00, 0x35, 0x00, 0x01, 0x09, 0x0D, 0x0A, 0x03, 0x5C, // "5" (U+0035)
  0x00, 0x36, 0x40, 0x01, 0x09, 0x0D, 0x0A, 0x03, 0x93, // "6" (U+0036)
  0x00, 0x37, 0x00, 0x01, 0x09, 0x0D, 0x0A, 0x03, 0xD4, // "7" (U+0037)
  0x00, 0x38, 0x40, 0x01, 0x09, 0x0D, 0x0A, 0x03, 0xFF, // "8" (U+0038)
  0x00, 0x39, 0x40, 0x01, 0x09, 0x0D, 0x0A, 0x04, 0x40, // "9" (U+0039)
  0x00, 0x3A, 0x01, 0x01, 0x04, 0x0A, 0x05, 0x04, 0x81, // ":" (U+003A)
  0x00, 0x3B, 0x01, 0xFE, 0x04, 0x0A, 0x05, 0x04, 0x91, // ";" (U+003B)
  0x00, 0x3C, 0x01, 0x03, 0x08, 0x0B, 0x0A, 0x04, 0xA8, // "<" (U+003C)
  0x00, 0x3D, 0x01, 0x04, 0x08, 0x09, 0x0A, 0x04, 0xC7, // "=" (U+003D)
  0x00, 0x3E, 0x01, 0x03, 0x08, 0x0B, 0x0A, 0x04, 0xD2, // ">" (U+003E)
  0x00, 0x3F, 0x00, 0x01, 0x08, 0x0D, 0x0A, 0x04, 0xF1, // "?" (U+003F)
  0x00, 0x40, 0x01, 0xFE, 0x0F, 0x0D, 0x11, 0x05, 0x1F, // "@" (U+0040)
  0x00, 0x41, 0x00, 0x01, 0x0D, 0x0D, 0x0E, 0x05, 0x8E, // "A" (U+0041)
  0x00, 0x42, 0x00, 0x01, 0x0B, 0x0D, 0x0C, 0x05, 0xD1, // "B" (U+0042)
  0x00, 0x43, 0x01, 0x01, 0x0B, 0x0D, 0x0C, 0x06, 0x16, // "C" (U+0043)
  0x00, 0x44, 0x00, 0x01, 0x0C, 0x0D, 0x0E, 0x06, 0x4E, // "D" (U+0044)
  0x00, 0x45, 0x00, 0x01, 0x0B, 0x0D, 0x0C, 0x06, 0x93, // "E" (U+0045)
  0x00, 0x46, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x06, 0xC7, // "F" (U+0046)
  0x00, 0x47, 0x01, 0x01, 0x0D, 0x0D, 0x0E, 0x06, 0xF6, // "G" (U+0047)
  0x00, 0x48, 0x00, 0x01, 0x0E, 0x0D, 0x0F, 0x07, 0x3A, // "H" (U+0048)
  0x00, 0x49, 0x00, 0x01, 0x06, 0x0D, 0x07, 0x07, 0x82, // "I" (U+0049)
  0x00, 0x4A, 0xFF, 0xFD, 0x06, 0x0D, 0x07, 0x07, 0xA3, // "J" (U+004A)
  0x00, 0x4B, 0x00, 0x01, 0x0D, 0x0D, 0x0D, 0x07, 0xD9, // "K" (U+004B)
  0x00, 0x4C, 0x00, 0x01, 0x0B, 0x0D, 0x0C, 0x08, 0x23, // "L" (U+004C)
  0x00, 0x4D, 0x00, 0x01, 0x10, 0x0D, 0x11, 0x08, 0x4D, // "M" (U+004D)
  0x00, 0x4E, 0x00, 0x01, 0x0D, 0x0D, 0x0E, 0x08, 0xB7, // "N" (U+004E)
  0x00, 0x4F, 0x01, 0x01, 0x0D, 0x0D, 0x0E, 0x09, 0x10, // "O" (U+004F)
  0x00, 0x50, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x09, 0x59, // "P" (U+0050)
  0x00, 0x51, 0x01, 0xFD, 0x0D, 0x0D, 0x0E, 0x09, 0x94, // "Q" (U+0051)
  0x00, 0x52, 0x00, 0x01, 0x0C, 0x0D, 0x0D, 0x09, 0xEE, // "R" (U+0052)
  0x00, 0x53, 0x00, 0x01, 0x09, 0x0D, 0x0B, 0x0A, 0x35, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x0B, 0x0D, 0x0C, 0x0A, 0x75, // "T" (U+0054)
  0x00, 0x55, 0x00, 0x01, 0x0D, 0x0D, 0x0D, 0x0A, 0xAC, // "U" (U+0055)
  0x00, 0x56, 0x00, 0x01, 0x0C, 0x0D, 0x0D, 0x0A, 0xEF, // "V" (U+0056)
  0x00, 0x57, 0x00, 0x01, 0x13, 0x0D, 0x13, 0x0B, 0x2F, // "W" (U+0057)
  0x00, 0x58, 0x00, 0x01, 0x0C, 0x0D, 0x0D, 0x0B, 0x9C, // "X" (U+0058)
  0x00, 0x59, 0x00, 0x01, 0x0C, 0x0D, 0x0C, 0x0B, 0xE2, // "Y" (U+0059)
  0x00, 0x5A, 0x00, 0x01, 0x0B, 0x0D, 0x0C, 0x0C, 0x1F, // "Z" (U+005A)
  0x00, 0x5B, 0x41, 0xFE, 0x06, 0x0E, 0x07, 0x0C, 0x5B, // "[" (U+005B)
  0x00, 0x5C, 0x00, 0xFF, 0x05, 0x0E, 0x05, 0x0C, 0x8E, // "\" (U+005C)
  0x00, 0x5D, 0x40, 0xFE, 0x05, 0x0E, 0x07, 0x0C, 0xB8, // "]" (U+005D)
  0x00, 0x5E, 0x01, 0x06, 0x08, 0x0E, 0x0A, 0x0C, 0xEB, // "^" (U+005E)
  0x00, 0x5F, 0xFF, 0xFE, 0x08, 0xFF, 0x08, 0x0D, 0x0C, // "_" (U+005F)
  0x00, 0x60, 0x40, 0x0C, 0x05, 0x0E, 0x06, 0x0D, 0x12, // "`" (U+0060)
  0x00, 0x61, 0x00, 0x01, 0x0A, 0x0A, 0x0B, 0x0D, 0x1B, // "a" (U+0061)
  0x00, 0x62, 0x00, 0x01, 0x0A, 0x0E, 0x0C, 0x0D, 0x4D, // "b" (U+0062)
  0x00, 0x63, 0x00, 0x01, 0x08, 0x0A, 0x09, 0x0D, 0x92, // "c" (U+0063)
  0x00, 0x64, 0x00, 0x01, 0x0B, 0x0E, 0x0C, 0x0D, 0xBC, // "d" (U+0064)
  0x00, 0x65, 0x00, 0x01, 0x09, 0x0A, 0x0A, 0x0E, 0x04, // "e" (U+0065)
  0x00, 0x66, 0x00, 0x01, 0x08, 0x0E, 0x07, 0x0E, 0x33, // "f" (U+0066)
  0x00, 0x67, 0x00, 0xFD, 0x09, 0x0B, 0x0A, 0x0E, 0x60, // "g" (U+0067)
  0x00, 0x68, 0x00, 0x01, 0x0B, 0x0E, 0x0C, 0x0E, 0xA6, // "h" (U+0068)
  0x00, 0x69, 0x00, 0x01, 0x05, 0x0E, 0x06, 0x0E, 0xEF, // "i" (U+0069)
  0x00, 0x6A, 0xFF, 0xFD, 0x04, 0x0E, 0x06, 0x0F, 0x17, // "j" (U+006A)
  0x00, 0x6B, 0x00, 0x01, 0x0B, 0x0E, 0x0B, 0x0F, 0x4C, // "k" (U+006B)
  0x00, 0x6C, 0x40, 0x01, 0x05, 0x0E, 0x06, 0x0F, 0x94, // "l" (U+006C)
  0x00, 0x6D, 0x00, 0x01, 0x11, 0x0A, 0x12, 0x0F, 0xBE, // "m" (U+006D)
  0x00, 0x6E, 0x40, 0x01, 0x0B, 0x0A, 0x0C, 0x10, 0x14, // "n" (U+006E)
  0x00, 0x6F, 0x00, 0x01, 0x0A, 0x0A, 0x0B, 0x10, 0x50, // "o" (U+006F)
  0x00, 0x70, 0x00, 0xFD, 0x0A, 0x0A, 0x0C, 0x10, 0x86, // "p" (U+0070)
  0x00, 0x71, 0x00, 0xFD, 0x0B, 0x0A, 0x0C, 0x10, 0xCE, // "q" (U+0071)
  0x00, 0x72, 0x00, 0x01, 0x09, 0x0A, 0x09, 0x11, 0x17, // "r" (U+0072)
  0x00, 0x73, 0x40, 0x01, 0x07, 0x0A, 0x09, 0x11, 0x3F, // "s" (U+0073)
  0x00, 0x74, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x11, 0x67, // "t" (U+0074)
  0x00, 0x75, 0x40, 0x01, 0x0B, 0x0A, 0x0C, 0x11, 0x8F, // "u" (U+0075)
  0x00, 0x76, 0x00, 0x01, 0x0A, 0x0A, 0x0B, 0x11, 0xCB, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x01, 0x0F, 0x0A, 0x0F, 0x11, 0xF7, // "w" (U+0077)
  0x00, 0x78, 0x00, 0x01, 0x0B, 0x0A, 0x0C, 0x12, 0x40, // "x" (U+0078)
  0x00, 0x79, 0x00, 0xFD, 0x0A, 0x0A, 0x0A, 0x12, 0x70, // "y" (U+0079)
  0x00, 0x7A, 0x00, 0x01, 0x08, 0x0A, 0x0A, 0x12, 0xAD, // "z" (U+007A)
  0x00, 0x7B, 0x00, 0xFE, 0x07, 0x0E, 0x08, 0x12, 0xD3, // "{" (U+007B)
  0x00, 0x7C, 0x44, 0xFD, 0x05, 0x0E, 0x0A, 0x13, 0x0D, // "|" (U+007C)
  0x00, 0x7D, 0x00, 0xFE, 0x07, 0x0E, 0x08, 0x13, 0x1F, // "}" (U+007D)
  0x00, 0x7E, 0x40, 0x05, 0x09, 0x08, 0x0A, 0x13, 0x59, // "~" (U+007E)
  0x00, 0xA1, 0x42, 0xFE, 0x05, 0x0A, 0x07, 0x13, 0x6D, // "¡" (U+00A1)
  0x00, 0xA2, 0x01, 0x01, 0x09, 0x0D, 0x0A, 0x13, 0x87, // "¢" (U+00A2)
  0x00, 0xA3, 0x00, 0x01, 0x09, 0x0D, 0x0A, 0x13, 0xBC, // "£" (U+00A3)
  0x00, 0xA4, 0x41, 0x04, 0x08, 0x0B, 0x0A, 0x13, 0xF3, // "¤" (U+00A4)
  0x00, 0xA5, 0x00, 0x01, 0x09, 0x0D, 0x0A, 0x14, 0x13, // "¥" (U+00A5)
  0x00, 0xA6, 0x44, 0xFD, 0x05, 0x0E, 0x0A, 0x14, 0x4E, // "¦" (U+00A6)
  0x00, 0xA7, 0x41, 0xFE, 0x09, 0x0E, 0x0A, 0x14, 0x60, // "§" (U+00A7)
  0x00, 0xA8, 0x42, 0x0C, 0x07, 0x0E, 0x0A, 0x14, 0xAD, // "¨" (U+00A8)
  0x00, 0xA9, 0x01, 0x00, 0x0E, 0x0D, 0x0F, 0x14, 0xB6, // "©" (U+00A9)
  0x00, 0xAA, 0x40, 0x08, 0x07, 0x0D, 0x08, 0x15, 0x0E, // "ª" (U+00AA)
  0x00, 0xAB, 0x41, 0x02, 0x08, 0x08, 0x0A, 0x15, 0x26, // "«" (U+00AB)
  0x00, 0xAC, 0x01, 0x03, 0x08, 0x07, 0x0A, 0x15, 0x42, // "¬" (U+00AC)
  0x00, 0xAE, 0x01, 0x00, 0x0E, 0x0D, 0x0F, 0x15, 0x4F, // "®" (U+00AE)
  0x00, 0xAF, 0xFF, 0x0E, 0x08, 0x0F, 0x08, 0x15, 0xB0, // "¯" (U+00AF)
  0x00, 0xB0, 0x40, 0x08, 0x06, 0x0D, 0x07, 0x15, 0xB6, // "°" (U+00B0)
  0x00, 0xB1, 0x01, 0x01, 0x08, 0x0B, 0x0A, 0x15, 0xCB, // "±" (U+00B1)
  0x00, 0xB2, 0x40, 0x07, 0x06, 0x0F, 0x07, 0x15, 0xE9, // "²" (U+00B2)
  0x00, 0xB3, 0x40, 0x08, 0x06, 0x0F, 0x07, 0x16, 0x09, // "³" (U+00B3)
  0x00, 0xB4, 0x40, 0x0C, 0x05, 0x0E, 0x06, 0x16, 0x25, // "´" (U+00B4)
  0x00, 0xB5, 0x01, 0xFD, 0x0B, 0x0A, 0x0C, 0x16, 0x2E, // "µ" (U+00B5)
  0x00, 0xB6, 0x00, 0xFE, 0x0A, 0x0E, 0x0B, 0x16, 0x78, // "¶" (U+00B6)
  0x00, 0xB7, 0x41, 0x06, 0x04, 0x08, 0x05, 0x16, 0xC4, // "·" (U+00B7)
  0x00, 0xB8, 0x40, 0xFC, 0x04, 0x00, 0x06, 0x16, 0xCA, // "¸" (U+00B8)
  0x00, 0xB9, 0x41, 0x08, 0x06, 0x10, 0x07, 0x16, 0xD7, // "¹" (U+00B9)
  0x00, 0xBA, 0x40, 0x08, 0x07, 0x0D, 0x08, 0x16, 0xF2, // "º" (U+00BA)
  0x00, 0xBB, 0x41, 0x02, 0x08, 0x08, 0x0A, 0x17, 0x0A, // "»" (U+00BB)
  0x00, 0xBC, 0x00, 0x01, 0x0E, 0x0E, 0x0F, 0x17, 0x26, // "¼" (U+00BC)
  0x00, 0xBD, 0x00, 0x00, 0x0E, 0x0E, 0x0F, 0x17, 0x82, // "½" (U+00BD)
  0x00, 0xBE, 0x00, 0x01, 0x0E, 0x0D, 0x0F, 0x17, 0xE0, // "¾" (U+00BE)
  0x00, 0xBF, 0x01, 0xFE, 0x09, 0x0A, 0x0A, 0x18, 0x3C, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x0D, 0x11, 0x0E, 0x18, 0x6A, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x0D, 0x11, 0x0E, 0x18, 0xBA, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x01, 0x0D, 0x11, 0x0E, 0x19, 0x0A, // "Â" (U+00C2)
  0x00, 0xC3, 0x00, 0x01, 0x0D, 0x11, 0x0E, 0x19, 0x5C, // "Ã" (U+00C3)
  0x00, 0xC4, 0x00, 0x01, 0x0D, 0x11, 0x0E, 0x19, 0xAE, // "Ä" (U+00C4)
  0x00, 0xC5, 0x00, 0x01, 0x0D, 0x10, 0x0E, 0x19, 0xFE, // "Å" (U+00C5)
  0x00, 0xC6, 0x00, 0x01, 0x11, 0x0D, 0x12, 0x1A, 0x4E, // "Æ" (U+00C6)
  0x00, 0xC7, 0x01, 0xFC, 0x0B, 0x0D, 0x0C, 0x1A, 0xA5, // "Ç" (U+00C7)
  0x00, 0xC8, 0x00, 0x01, 0x0B, 0x11, 0x0C, 0x1A, 0xEC, // "È" (U+00C8)
  0x00, 0xC9, 0x00, 0x01, 0x0B, 0x11, 0x0C, 0x1B, 0x2C, // "É" (U+00C9)
  0x00, 0xCA, 0x00, 0x01, 0x0B, 0x11, 0x0C, 0x1B, 0x6B, // "Ê" (U+00CA)
  0x00, 0xCB, 0x00, 0x01, 0x0B, 0x11, 0x0C, 0x1B, 0xAD, // "Ë" (U+00CB)
  0x00, 0xCC, 0x00, 0x01, 0x06, 0x11, 0x07, 0x1B, 0xED, // "Ì" (U+00CC)
  0x00, 0xCD, 0x00, 0x01, 0x07, 0x11, 0x07, 0x1C, 0x18, // "Í" (U+00CD)
  0x00, 0xCE, 0x00, 0x01, 0x06, 0x11, 0x07, 0x1C, 0x45, // "Î" (U+00CE)
  0x00, 0xCF, 0x00, 0x01, 0x06, 0x11, 0x07, 0x1C, 0x72, // "Ï" (U+00CF)
  0x00, 0xD0, 0x00, 0x01, 0x0C, 0x0D, 0x0E, 0x1C, 0x9E, // "Ð" (U+00D0)
  0x00, 0xD1, 0x00, 0x01, 0x0D, 0x11, 0x0E, 0x1C, 0xE6, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x01, 0x01, 0x0D, 0x11, 0x0E, 0x1D, 0x4E, // "Ò" (U+00D2)
  0x00, 0xD3, 0x01, 0x01, 0x0D, 0x11, 0x0E, 0x1D, 0xA3, // "Ó" (U+00D3)
  0x00, 0xD4, 0x01, 0x01, 0x0D, 0x11, 0x0E, 0x1D, 0xF8, // "Ô" (U+00D4)
  0x00, 0xD5, 0x01, 0x01, 0x0D, 0x11, 0x0E, 0x1E, 0x50, // "Õ" (U+00D5)
  0x00, 0xD6, 0x01, 0x01, 0x0D, 0x11, 0x0E, 0x1E, 0xA8, // "Ö" (U+00D6)
  0x00, 0xD7, 0x41, 0x04, 0x08, 0x0A, 0x0A, 0x1E, 0xFD, // "×" (U+00D7)
  0x00, 0xD8, 0x01, 0x00, 0x0D, 0x0E, 0x0E, 0x1F, 0x19, // "Ø" (U+00D8)
  0x00, 0xD9, 0x00, 0x01, 0x0D, 0x11, 0x0D, 0x1F, 0x76, // "Ù" (U+00D9)
  0x00, 0xDA, 0x00, 0x01, 0x0D, 0x11, 0x0D, 0x1F, 0xC6, // "Ú" (U+00DA)
  0x00, 0xDB, 0x00, 0x01, 0x0D, 0x11, 0x0D, 0x20, 0x16, // "Û" (U+00DB)
  0x00, 0xDC, 0x00, 0x01, 0x0D, 0x11, 0x0D, 0x20, 0x68, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x01, 0x0C, 0x11, 0x0C, 0x20, 0xB8, // "Ý" (U+00DD)
  0x00, 0xDE, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x21, 0x02, // "Þ" (U+00DE)
  0x00, 0xDF, 0x40, 0x01, 0x0B, 0x0E, 0x0D, 0x21, 0x41, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x21, 0x95, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x21, 0xD3, // "á" (U+00E1)
  0x00, 0xE2, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x22, 0x10, // "â" (U+00E2)
  0x00, 0xE3, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x22, 0x50, // "ã" (U+00E3)
  0x00, 0xE4, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x22, 0x91, // "ä" (U+00E4)
  0x00, 0xE5, 0x00, 0x01, 0x0A, 0x0F, 0x0B, 0x22, 0xCF, // "å" (U+00E5)
  0x00, 0xE6, 0x00, 0x01, 0x0E, 0x0A, 0x10, 0x23, 0x13, // "æ" (U+00E6)
  0x00, 0xE7, 0x00, 0xFC, 0x08, 0x0A, 0x09, 0x23, 0x5D, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x01, 0x09, 0x0E, 0x0A, 0x23, 0x97, // "è" (U+00E8)
  0x00, 0xE9, 0x00, 0x01, 0x09, 0x0E, 0x0A, 0x23, 0xD1, // "é" (U+00E9)
  0x00, 0xEA, 0x00, 0x01, 0x09, 0x0E, 0x0A, 0x24, 0x0B, // "ê" (U+00EA)
  0x00, 0xEB, 0x00, 0x01, 0x09, 0x0E, 0x0A, 0x24, 0x48, // "ë" (U+00EB)
  0x00, 0xEC, 0xFF, 0x01, 0x05, 0x0E, 0x06, 0x24, 0x83, // "ì" (U+00EC)
  0x00, 0xED, 0x00, 0x01, 0x06, 0x0E, 0x06, 0x24, 0xAD, // "í" (U+00ED)
  0x00, 0xEE, 0xFF, 0x01, 0x05, 0x0E, 0x06, 0x24, 0xD8, // "î" (U+00EE)
  0x00, 0xEF, 0x00, 0x01, 0x05, 0x0E, 0x06, 0x25, 0x04, // "ï" (U+00EF)
  0x00, 0xF0, 0x00, 0x01, 0x0A, 0x0F, 0x0B, 0x25, 0x2C, // "ð" (U+00F0)
  0x00, 0xF1, 0x00, 0x01, 0x0B, 0x0E, 0x0C, 0x25, 0x78, // "ñ" (U+00F1)
  0x00, 0xF2, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x25, 0xC4, // "ò" (U+00F2)
  0x00, 0xF3, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x26, 0x06, // "ó" (U+00F3)
  0x00, 0xF4, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x26, 0x47, // "ô" (U+00F4)
  0x00, 0xF5, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x26, 0x8B, // "õ" (U+00F5)
  0x00, 0xF6, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x26, 0xD0, // "ö" (U+00F6)
  0x00, 0xF7, 0x01, 0x03, 0x08, 0x0B, 0x0A, 0x27, 0x12, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x00, 0x0A, 0x0B, 0x0B, 0x27, 0x23, // "ø" (U+00F8)
  0x00, 0xF9, 0x00, 0x01, 0x0B, 0x0E, 0x0C, 0x27, 0x64, // "ù" (U+00F9)
  0x00, 0xFA, 0x00, 0x01, 0x0B, 0x0E, 0x0C, 0x27, 0xAE, // "ú" (U+00FA)
  0x00, 0xFB, 0x00, 0x01, 0x0B, 0x0E, 0x0C, 0x27, 0xF7, // "û" (U+00FB)
  0x00, 0xFC, 0x00, 0x01, 0x0B, 0x0E, 0x0C, 0x28, 0x43, // "ü" (U+00FC)
  0x00, 0xFD, 0x00, 0xFD, 0x0A, 0x0E, 0x0A, 0x28, 0x8D, // "ý" (U+00FD)
  0x00, 0xFE, 0x00, 0xFD, 0x0A, 0x0E, 0x0C, 0x28, 0xD5, // "þ" (U+00FE)
  0x00, 0xFF, 0x00, 0xFD, 0x0A, 0x0E, 0x0A, 0x29, 0x2A, // "ÿ" (U+00FF)
  0x01, 0x00, 0x00, 0x01, 0x0D, 0x0F, 0x0E, 0x29, 0x73, // "Ā" (U+0100)
  0x01, 0x01, 0x00, 0x01, 0x0A, 0x0C, 0x0B, 0x29, 0xBD, // "ā" (U+0101)
  0x01, 0x02, 0x00, 0x01, 0x0D, 0x11, 0x0E, 0x29, 0xF5, // "Ă" (U+0102)
  0x01, 0x03, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x2A, 0x49, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0xFC, 0x0D, 0x0D, 0x0E, 0x2A, 0x8B, // "Ą" (U+0104)
  0x01, 0x05, 0x00, 0xFC, 0x0A, 0x0A, 0x0B, 0x2A, 0xE1, // "ą" (U+0105)
  0x01, 0x06, 0x01, 0x01, 0x0B, 0x11, 0x0C, 0x2B, 0x25, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x2B, 0x68, // "ć" (U+0107)
  0x01, 0x08, 0x01, 0x01, 0x0B, 0x11, 0x0C, 0x2B, 0x9D, // "Ĉ" (U+0108)
  0x01, 0x09, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x2B, 0xE3, // "ĉ" (U+0109)
  0x01, 0x0A, 0x01, 0x01, 0x0B, 0x11, 0x0C, 0x2C, 0x1B, // "Ċ" (U+010A)
  0x01, 0x0B, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x2C, 0x5D, // "ċ" (U+010B)
  0x01, 0x0C, 0x01, 0x01, 0x0B, 0x11, 0x0C, 0x2C, 0x91, // "Č" (U+010C)
  0x01, 0x0D, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x2C, 0xD7, // "č" (U+010D)
  0x01, 0x0E, 0x00, 0x01, 0x0C, 0x11, 0x0E, 0x2D, 0x0F, // "Ď" (U+010E)
  0x01, 0x0F, 0x00, 0x01, 0x0D, 0x0E, 0x0C, 0x2D, 0x63, // "ď" (U+010F)
  0x01, 0x10, 0x00, 0x01, 0x0C, 0x0D, 0x0E, 0x2D, 0xB2, // "Đ" (U+0110)
  0x01, 0x11, 0x00, 0x01, 0x0B, 0x0E, 0x0C, 0x2D, 0xFA, // "đ" (U+0111)
  0x01, 0x12, 0x00, 0x01, 0x0B, 0x0F, 0x0C, 0x2E, 0x45, // "Ē" (U+0112)
  0x01, 0x13, 0x00, 0x01, 0x09, 0x0C, 0x0A, 0x2E, 0x7F, // "ē" (U+0113)
  0x01, 0x14, 0x00, 0x01, 0x0B, 0x11, 0x0C, 0x2E, 0xB4, // "Ĕ" (U+0114)
  0x01, 0x15, 0x00, 0x01, 0x09, 0x0E, 0x0A, 0x2E, 0xF8, // "ĕ" (U+0115)
  0x01, 0x16, 0x00, 0x01, 0x0B, 0x11, 0x0C, 0x2F, 0x36, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x01, 0x09, 0x0E, 0x0A, 0x2F, 0x75, // "ė" (U+0117)
  0x01, 0x18, 0x00, 0xFC, 0x0B, 0x0D, 0x0C, 0x2F, 0xAE, // "Ę" (U+0118)
  0x01, 0x19, 0x00, 0xFD, 0x09, 0x0A, 0x0A, 0x2F, 0xF3, // "ę" (U+0119)
  0x01, 0x1A, 0x00, 0x01, 0x0B, 0x11, 0x0C, 0x30, 0x30, // "Ě" (U+011A)
  0x01, 0x1B, 0x00, 0x01, 0x09, 0x0E, 0x0A, 0x30, 0x72, // "ě" (U+011B)
  0x01, 0x1C, 0x01, 0x01, 0x0D, 0x11, 0x0E, 0x30, 0xAF, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x00, 0xFD, 0x09, 0x0E, 0x0A, 0x31, 0x02, // "ĝ" (U+011D)
  0x01, 0x1E, 0x01, 0x01, 0x0D, 0x11, 0x0E, 0x31, 0x56, // "Ğ" (U+011E)
  0x01, 0x1F, 0x00, 0xFD, 0x09, 0x0E, 0x0A, 0x31, 0xAA, // "ğ" (U+011F)
  0x01, 0x20, 0x01, 0x01, 0x0D, 0x11, 0x0E, 0x31, 0xFF, // "Ġ" (U+0120)
  0x01, 0x21, 0x00, 0xFD, 0x09, 0x0E, 0x0A, 0x32, 0x4E, // "ġ" (U+0121)
  0x01, 0x22, 0x01, 0xFD, 0x0D, 0x0D, 0x0E, 0x32, 0x9E, // "Ģ" (U+0122)
  0x01, 0x23, 0x00, 0xFD, 0x09, 0x0E, 0x0A, 0x32, 0xEC, // "ģ" (U+0123)
  0x01, 0x24, 0x00, 0x01, 0x0E, 0x11, 0x0F, 0x33, 0x3C, // "Ĥ" (U+0124)
  0x01, 0x25, 0x00, 0x01, 0x0B, 0x11, 0x0C, 0x33, 0x94, // "ĥ" (U+0125)
  0x01, 0x26, 0x00, 0x01, 0x0E, 0x0D, 0x0F, 0x33, 0xEB, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x0B, 0x0E, 0x0C, 0x34, 0x35, // "ħ" (U+0127)
  0x01, 0x28, 0xFF, 0x01, 0x06, 0x11, 0x07, 0x34, 0x80, // "Ĩ" (U+0128)
  0x01, 0x29, 0xFF, 0x01, 0x06, 0x0E, 0x06, 0x34, 0xAF, // "ĩ" (U+0129)
  0x01, 0x2A, 0x00, 0x01, 0x06, 0x0F, 0x07, 0x34, 0xDC, // "Ī" (U+012A)
  0x01, 0x2B, 0x00, 0x01, 0x05, 0x0C, 0x06, 0x35, 0x02, // "ī" (U+012B)
  0x01, 0x2C, 0x00, 0x01, 0x06, 0x11, 0x07, 0x35, 0x25, // "Ĭ" (U+012C)
  0x01, 0x2D, 0xFF, 0x01, 0x05, 0x0E, 0x06, 0x35, 0x53, // "ĭ" (U+012D)
  0x01, 0x2E, 0x00, 0xFC, 0x06, 0x0D, 0x07, 0x35, 0x80, // "Į" (U+012E)
  0x01, 0x2F, 0x00, 0xFC, 0x05, 0x0E, 0x06, 0x35, 0xB0, // "į" (U+012F)
  0x01, 0x30, 0x00, 0x01, 0x06, 0x11, 0x07, 0x35, 0xE8, // "İ" (U+0130)
  0x01, 0x31, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x36, 0x13, // "ı" (U+0131)
  0x01, 0x32, 0x00, 0xFD, 0x0D, 0x0D, 0x0E, 0x36, 0x31, // "Ĳ" (U+0132)
  0x01, 0x33, 0x00, 0xFD, 0x0A, 0x0E, 0x0D, 0x36, 0x88, // "ĳ" (U+0133)
  0x01, 0x34, 0xFF, 0xFD, 0x06, 0x11, 0x07, 0x36, 0xE5, // "Ĵ" (U+0134)
  0x01, 0x35, 0xFF, 0xFD, 0x05, 0x0E, 0x06, 0x37, 0x28, // "ĵ" (U+0135)
  0x01, 0x36, 0x00, 0xFD, 0x0D, 0x0D, 0x0D, 0x37, 0x61, // "Ķ" (U+0136)
  0x01, 0x37, 0x00, 0xFD, 0x0B, 0x0E, 0x0B, 0x37, 0xB6, // "ķ" (U+0137)
  0x01, 0x38, 0x00, 0x01, 0x0B, 0x0A, 0x0B, 0x38, 0x08, // "ĸ" (U+0138)
  0x01, 0x39, 0x00, 0x01, 0x0B, 0x11, 0x0C, 0x38, 0x42, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x00, 0x01, 0x06, 0x11, 0x06, 0x38, 0x77, // "ĺ" (U+013A)
  0x01, 0x3B, 0x00, 0xFD, 0x0B, 0x0D, 0x0C, 0x38, 0xAD, // "Ļ" (U+013B)
  0x01, 0x3C, 0x00, 0xFD, 0x05, 0x0E, 0x06, 0x38, 0xE1, // "ļ" (U+013C)
  0x01, 0x3D, 0x00, 0x01, 0x0B, 0x0D, 0x0C, 0x39, 0x14, // "Ľ" (U+013D)
  0x01, 0x3E, 0x00, 0x01, 0x08, 0x0E, 0x06, 0x39, 0x45, // "ľ" (U+013E)
  0x01, 0x3F, 0x00, 0x01, 0x0B, 0x0D, 0x0C, 0x39, 0x76, // "Ŀ" (U+013F)
  0x01, 0x40, 0x00, 0x01, 0x08, 0x0E, 0x08, 0x39, 0xA7, // "ŀ" (U+0140)
  0x01, 0x41, 0x00, 0x01, 0x0B, 0x0D, 0x0C, 0x39, 0xDA, // "Ł" (U+0141)
  0x01, 0x42, 0x40, 0x01, 0x05, 0x0E, 0x06, 0x3A, 0x0B, // "ł" (U+0142)
  0x01, 0x43, 0x00, 0x01, 0x0D, 0x11, 0x0E, 0x3A, 0x35, // "Ń" (U+0143)
  0x01, 0x44, 0x00, 0x01, 0x0B, 0x0E, 0x0C, 0x3A, 0x9B, // "ń" (U+0144)
  0x01, 0x45, 0x00, 0xFD, 0x0D, 0x0D, 0x0E, 0x3A, 0xE4, // "Ņ" (U+0145)
  0x01, 0x46, 0x00, 0xFD, 0x0B, 0x0A, 0x0C, 0x3B, 0x47, // "ņ" (U+0146)
  0x01, 0x47, 0x00, 0x01, 0x0D, 0x11, 0x0E, 0x3B, 0x8F, // "Ň" (U+0147)
  0x01, 0x48, 0x00, 0x01, 0x0B, 0x0E, 0x0C, 0x3B, 0xF8, // "ň" (U+0148)
  0x01, 0x49, 0xFF, 0x01, 0x0E, 0x0D, 0x0F, 0x3C, 0x44, // "ŉ" (U+0149)
  0x01, 0x4A, 0x00, 0xFD, 0x0D, 0x0D, 0x0E, 0x3C, 0x94, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x00, 0xFD, 0x0A, 0x0A, 0x0C, 0x3C, 0xFB, // "ŋ" (U+014B)
  0x01, 0x4C, 0x01, 0x01, 0x0D, 0x0F, 0x0E, 0x3D, 0x43, // "Ō" (U+014C)
  0x01, 0x4D, 0x00, 0x01, 0x0A, 0x0C, 0x0B, 0x3D, 0x92, // "ō" (U+014D)
  0x01, 0x4E, 0x01, 0x01, 0x0D, 0x11, 0x0E, 0x3D, 0xCE, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x3E, 0x27, // "ŏ" (U+014F)
  0x01, 0x50, 0x01, 0x01, 0x0D, 0x11, 0x0E, 0x3E, 0x6D, // "Ő" (U+0150)
  0x01, 0x51, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x3E, 0xC6, // "ő" (U+0151)
  0x01, 0x52, 0x01, 0x01, 0x11, 0x0D, 0x12, 0x3F, 0x0C, // "Œ" (U+0152)
  0x01, 0x53, 0x00, 0x01, 0x10, 0x0A, 0x11, 0x3F, 0x65, // "œ" (U+0153)
  0x01, 0x54, 0x00, 0x01, 0x0C, 0x11, 0x0D, 0x3F, 0xB5, // "Ŕ" (U+0154)
  0x01, 0x55, 0x00, 0x01, 0x09, 0x0E, 0x09, 0x40, 0x08, // "ŕ" (U+0155)
  0x01, 0x56, 0x00, 0xFD, 0x0C, 0x0D, 0x0D, 0x40, 0x3B, // "Ŗ" (U+0156)
  0x01, 0x57, 0x00, 0xFD, 0x09, 0x0A, 0x09, 0x40, 0x8C, // "ŗ" (U+0157)
  0x01, 0x58, 0x00, 0x01, 0x0C, 0x11, 0x0D, 0x40, 0xBD, // "Ř" (U+0158)
  0x01, 0x59, 0x00, 0x01, 0x09, 0x0E, 0x09, 0x41, 0x13, // "ř" (U+0159)
  0x01, 0x5A, 0x00, 0x01, 0x09, 0x11, 0x0B, 0x41, 0x49, // "Ś" (U+015A)
  0x01, 0x5B, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x41, 0x94, // "ś" (U+015B)
  0x01, 0x5C, 0x00, 0x01, 0x09, 0x11, 0x0B, 0x41, 0xCE, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x40, 0x01, 0x07, 0x0E, 0x09, 0x42, 0x1B, // "ŝ" (U+015D)
  0x01, 0x5E, 0x00, 0xFC, 0x09, 0x0D, 0x0B, 0x42, 0x53, // "Ş" (U+015E)
  0x01, 0x5F, 0x00, 0xFC, 0x07, 0x0A, 0x09, 0x42, 0xA2, // "ş" (U+015F)
  0x01, 0x60, 0x00, 0x01, 0x09, 0x11, 0x0B, 0x42, 0xDC, // "Š" (U+0160)
  0x01, 0x61, 0x40, 0x01, 0x07, 0x0E, 0x09, 0x43, 0x2A, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFC, 0x0B, 0x0D, 0x0C, 0x43, 0x62, // "Ţ" (U+0162)
  0x01, 0x63, 0x00, 0xFC, 0x06, 0x0C, 0x07, 0x43, 0xA9, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x0B, 0x11, 0x0C, 0x43, 0xDF, // "Ť" (U+0164)
  0x01, 0x65, 0x00, 0x01, 0x08, 0x0E, 0x07, 0x44, 0x24, // "ť" (U+0165)
  0x01, 0x66, 0x00, 0x01, 0x0B, 0x0D, 0x0C, 0x44, 0x56, // "Ŧ" (U+0166)
  0x01, 0x67, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x44, 0x8E, // "ŧ" (U+0167)
  0x01, 0x68, 0x00, 0x01, 0x0D, 0x11, 0x0D, 0x44, 0xB7, // "Ũ" (U+0168)
  0x01, 0x69, 0x00, 0x01, 0x0B, 0x0E, 0x0C, 0x45, 0x09, // "ũ" (U+0169)
  0x01, 0x6A, 0x00, 0x01, 0x0D, 0x0F, 0x0D, 0x45, 0x56, // "Ū" (U+016A)
  0x01, 0x6B, 0x00, 0x01, 0x0B, 0x0C, 0x0C, 0x45, 0xA0, // "ū" (U+016B)
  0x01, 0x6C, 0x00, 0x01, 0x0D, 0x11, 0x0D, 0x45, 0xE4, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x00, 0x01, 0x0B, 0x0E, 0x0C, 0x46, 0x38, // "ŭ" (U+016D)
  0x01, 0x6E, 0x00, 0x01, 0x0D, 0x12, 0x0D, 0x46, 0x86, // "Ů" (U+016E)
  0x01, 0x6F, 0x00, 0x01, 0x0B, 0x0F, 0x0C, 0x46, 0xDD, // "ů" (U+016F)
  0x01, 0x70, 0x00, 0x01, 0x0D, 0x11, 0x0D, 0x47, 0x2D, // "Ű" (U+0170)
  0x01, 0x71, 0x00, 0x01, 0x0B, 0x0E, 0x0C, 0x47, 0x80, // "ű" (U+0171)
  0x01, 0x72, 0x00, 0xFC, 0x0D, 0x0D, 0x0E, 0x47, 0xCE, // "Ų" (U+0172)
  0x01, 0x73, 0x00, 0xFC, 0x0B, 0x0A, 0x0C, 0x48, 0x23, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x13, 0x11, 0x13, 0x48, 0x73, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x0F, 0x0E, 0x0F, 0x48, 0xF1, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x01, 0x0C, 0x11, 0x0C, 0x49, 0x4A, // "Ŷ" (U+0176)
  0x01, 0x77, 0x00, 0xFD, 0x0A, 0x0E, 0x0A, 0x49, 0x96, // "ŷ" (U+0177)
  0x01, 0x78, 0x00, 0x01, 0x0C, 0x11, 0x0C, 0x49, 0xE1, // "Ÿ" (U+0178)
  0x01, 0x79, 0x00, 0x01, 0x0B, 0x11, 0x0C, 0x4A, 0x2B, // "Ź" (U+0179)
  0x01, 0x7A, 0x00, 0x01, 0x08, 0x0E, 0x0A, 0x4A, 0x72, // "ź" (U+017A)
  0x01, 0x7B, 0x00, 0x01, 0x0B, 0x11, 0x0C, 0x4A, 0xA3, // "Ż" (U+017B)
  0x01, 0x7C, 0x00, 0x01, 0x08, 0x0E, 0x0A, 0x4A, 0xEA, // "ż" (U+017C)
  0x01, 0x7D, 0x00, 0x01, 0x0B, 0x11, 0x0C, 0x4B, 0x1A, // "Ž" (U+017D)
  0x01, 0x7E, 0x00, 0x01, 0x08, 0x0E, 0x0A, 0x4B, 0x64, // "ž" (U+017E)
  0x01, 0x7F, 0x00, 0x01, 0x08, 0x0E, 0x07, 0x4B, 0x98, // "ſ" (U+017F)
  0x03, 0xA9, 0x00, 0x01, 0x0D, 0x0D, 0x0F, 0x4B, 0xCA, // "Ω" (U+03A9)
  0x03, 0xBC, 0x01, 0xFD, 0x0B, 0x0A, 0x0C, 0x4C, 0x1F, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x01, 0x0B, 0x0A, 0x0C, 0x4C, 0x69, // "π" (U+03C0)
  0x20, 0x13, 0xFF, 0x04, 0x09, 0x05, 0x09, 0x4C, 0x9E, // "–" (U+2013)
  0x20, 0x14, 0xFF, 0x04, 0x12, 0x05, 0x12, 0x4C, 0xA4, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x01, 0x09, 0x0D, 0x0A, 0x4C, 0xAB, // "€" (U+20AC)
  0x20, 0xBF, 0x00, 0xFF, 0x09, 0x0E, 0x0A, 0x4C, 0xE7, // "₿" (U+20BF)
  0x20, 0x18, 0x41, 0x08, 0x04, 0x0D, 0x05, 0x4D, 0x35, // "‘" (U+2018)
  0x20, 0x19, 0x40, 0x08, 0x03, 0x0D, 0x05, 0x4D, 0x41, // "’" (U+2019)
  0x20, 0x1A, 0x40, 0xFE, 0x03, 0x03, 0x05, 0x4D, 0x4D, // "‚" (U+201A)
  0x20, 0x1B, 0x41, 0x08, 0x04, 0x0D, 0x05, 0x4D, 0x59, // "‛" (U+201B)
  0x20, 0x1C, 0x41, 0x08, 0x07, 0x0D, 0x09, 0x4D, 0x65, // "“" (U+201C)
  0x20, 0x1D, 0x40, 0x08, 0x07, 0x0D, 0x09, 0x4D, 0x7A, // "”" (U+201D)
  0x20, 0x1E, 0x40, 0xFE, 0x07, 0x03, 0x09, 0x4D, 0x92, // "„" (U+201E)
  0x20, 0x1F, 0x41, 0x08, 0x07, 0x0D, 0x09, 0x4D, 0xAA, // "‟" (U+201F)
  0x20, 0x20, 0x00, 0xFF, 0x07, 0x0E, 0x09, 0x4D, 0xBF, // "†" (U+2020)
  0x20, 0x21, 0x00, 0xFF, 0x07, 0x0E, 0x09, 0x4D, 0xF0, // "‡" (U+2021)
  0x20, 0x22, 0x41, 0x05, 0x06, 0x0A, 0x07, 0x4E, 0x25, // "•" (U+2022)
  0x20, 0x26, 0x41, 0x01, 0x0F, 0x03, 0x10, 0x4E, 0x37, // "…" (U+2026)
  0x20, 0x30, 0x00, 0x01, 0x16, 0x0D, 0x18, 0x4E, 0x4E, // "‰" (U+2030)
  0x20, 0x39, 0x41, 0x02, 0x04, 0x08, 0x06, 0x4E, 0xD4, // "‹" (U+2039)
  0x20, 0x3A, 0x41, 0x02, 0x05, 0x08, 0x06, 0x4E, 0xE2, // "›" (U+203A)
  0x20, 0x44, 0xFC, 0x01, 0x04, 0x0D, 0x01, 0x4E, 0xF4, // "⁄" (U+2044)
  0x21, 0x22, 0x40, 0x07, 0x0E, 0x0D, 0x0F, 0x4F, 0x19, // "™" (U+2122)
  0x21, 0x52, 0x01, 0x01, 0x14, 0x0E, 0x15, 0x4F, 0x4E, // "⅒" (U+2152)
  0xFB, 0x01, 0x00, 0x01, 0x0C, 0x0E, 0x0D, 0x4F, 0xC5, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0x00, 0x01, 0x0C, 0x0E, 0x0D, 0x50, 0x10, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x01, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0x67, 0x01, // "g (U+0022 U+0067)
  0x00, 0x22, 0x00, 0xC0, 0x01, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x01, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x01, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x01, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x01, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x01, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xC6, 0x02, // "Æ (U+0022 U+00C6)
  0x00, 0x22, 0x01, 0x00, 0x01, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x02, 0x01, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x04, 0x01, // "Ą (U+0022 U+0104)
  0x00, 0x26, 0x00, 0x3F, 0x01, // &? (U+0026 U+003F)
  0x00, 0x26, 0x00, 0x54, 0x01, // &T (U+0026 U+0054)
  0x00, 0x26, 0x00, 0x56, 0x01, // &V (U+0026 U+0056)
  0x00, 0x26, 0x00, 0x57, 0x01, // &W (U+0026 U+0057)
  0x00, 0x26, 0x00, 0x59, 0x01, // &Y (U+0026 U+0059)
  0x00, 0x26, 0x00, 0xDD, 0x01, // &Ý (U+0026 U+00DD)
  0x00, 0x26, 0x01, 0x62, 0x01, // &Ţ (U+0026 U+0162)
  0x00, 0x26, 0x01, 0x64, 0x01, // &Ť (U+0026 U+0164)
  0x00, 0x26, 0x01, 0x66, 0x01, // &Ŧ (U+0026 U+0166)
  0x00, 0x26, 0x01, 0x74, 0x01, // &Ŵ (U+0026 U+0174)
  0x00, 0x26, 0x01, 0x76, 0x01, // &Ŷ (U+0026 U+0176)
  0x00, 0x26, 0x01, 0x78, 0x01, // &Ÿ (U+0026 U+0178)
  0x00, 0x27, 0x00, 0x41, 0x01, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0x67, 0x01, // 'g (U+0027 U+0067)
  0x00, 0x27, 0x00, 0xC0, 0x01, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x01, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x01, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x01, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x01, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x01, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xC6, 0x02, // 'Æ (U+0027 U+00C6)
  0x00, 0x27, 0x01, 0x00, 0x01, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x02, 0x01, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x04, 0x01, // 'Ą (U+0027 U+0104)
  0x00, 0x2A, 0x00, 0x2C, 0x02, // *, (U+002A U+002C)
  0x00, 0x2A, 0x00, 0x2E, 0x02, // *. (U+002A U+002E)
  0x00, 0x2A, 0x00, 0x41, 0x01, // *A (U+002A U+0041)
  0x00, 0x2A, 0x00, 0xC0, 0x01, // *À (U+002A U+00C0)
  0x00, 0x2A, 0x00, 0xC1, 0x01, // *Á (U+002A U+00C1)
  0x00, 0x2A, 0x00, 0xC2, 0x01, // *Â (U+002A U+00C2)
  0x00, 0x2A, 0x00, 0xC3, 0x01, // *Ã (U+002A U+00C3)
  0x00, 0x2A, 0x00, 0xC4, 0x01, // *Ä (U+002A U+00C4)
  0x00, 0x2A, 0x00, 0xC5, 0x01, // *Å (U+002A U+00C5)
  0x00, 0x2A, 0x00, 0xC6, 0x01, // *Æ (U+002A U+00C6)
  0x00, 0x2A, 0x01, 0x00, 0x01, // *Ā (U+002A U+0100)
  0x00, 0x2A, 0x01, 0x02, 0x01, // *Ă (U+002A U+0102)
  0x00, 0x2A, 0x01, 0x04, 0x01, // *Ą (U+002A U+0104)
  0x00, 0x2A, 0x20, 0x1A, 0x02, // *‚ (U+002A U+201A)
  0x00, 0x2A, 0x20, 0x1E, 0x02, // *„ (U+002A U+201E)
  0x00, 0x2A, 0x20, 0x26, 0x02, // *… (U+002A U+2026)
  0x00, 0x2C, 0x00, 0x3F, 0x02, // ,? (U+002C U+003F)
  0x00, 0x2C, 0x00, 0x54, 0x02, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x56, 0x02, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x02, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x01, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0x76, 0x01, // ,v (U+002C U+0076)
  0x00, 0x2C, 0x00, 0x77, 0x01, // ,w (U+002C U+0077)
  0x00, 0x2C, 0x00, 0x79, 0x01, // ,y (U+002C U+0079)
  0x00, 0x2C, 0x00, 0xDD, 0x01, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x00, 0xFD, 0x01, // ,ý (U+002C U+00FD)
  0x00, 0x2C, 0x00, 0xFF, 0x01, // ,ÿ (U+002C U+00FF)
  0x00, 0x2C, 0x01, 0x62, 0x02, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x02, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x02, // ,Ŧ (U+002C U+0166)
  0x00, 0x2C, 0x01, 0x74, 0x02, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x75, 0x01, // ,ŵ (U+002C U+0175)
  0x00, 0x2C, 0x01, 0x76, 0x01, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x77, 0x01, // ,ŷ (U+002C U+0177)
  0x00, 0x2C, 0x01, 0x78, 0x01, // ,Ÿ (U+002C U+0178)
  0x00, 0x2E, 0x00, 0x3F, 0x02, // .? (U+002E U+003F)
  0x00, 0x2E, 0x00, 0x54, 0x02, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x56, 0x02, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x02, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x01, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0x76, 0x01, // .v (U+002E U+0076)
  0x00, 0x2E, 0x00, 0x77, 0x01, // .w (U+002E U+0077)
  0x00, 0x2E, 0x00, 0x79, 0x01, // .y (U+002E U+0079)
  0x00, 0x2E, 0x00, 0xDD, 0x01, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x00, 0xFD, 0x01, // .ý (U+002E U+00FD)
  0x00, 0x2E, 0x00, 0xFF, 0x01, // .ÿ (U+002E U+00FF)
  0x00, 0x2E, 0x01, 0x62, 0x02, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x02, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x02, // .Ŧ (U+002E U+0166)
  0x00, 0x2E, 0x01, 0x74, 0x02, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x75, 0x01, // .ŵ (U+002E U+0175)
  0x00, 0x2E, 0x01, 0x76, 0x01, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x77, 0x01, // .ŷ (U+002E U+0177)
  0x00, 0x2E, 0x01, 0x78, 0x01, // .Ÿ (U+002E U+0178)
  0x00, 0x40, 0x00, 0x41, 0x01, // @A (U+0040 U+0041)
  0x00, 0x40, 0x00, 0xC0, 0x01, // @À (U+0040 U+00C0)
  0x00, 0x40, 0x00, 0xC1, 0x01, // @Á (U+0040 U+00C1)
  0x00, 0x40, 0x00, 0xC2, 0x01, // @Â (U+0040 U+00C2)
  0x00, 0x40, 0x00, 0xC3, 0x01, // @Ã (U+0040 U+00C3)
  0x00, 0x40, 0x00, 0xC4, 0x01, // @Ä (U+0040 U+00C4)
  0x00, 0x40, 0x00, 0xC5, 0x01, // @Å (U+0040 U+00C5)
  0x00, 0x40, 0x01, 0x00, 0x01, // @Ā (U+0040 U+0100)
  0x00, 0x40, 0x01, 0x02, 0x01, // @Ă (U+0040 U+0102)
  0x00, 0x40, 0x01, 0x04, 0x01, // @Ą (U+0040 U+0104)
  0x00, 0x41, 0x00, 0x22, 0x01, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x01, // A' (U+0041 U+0027)
  0x00, 0x41, 0x00, 0x2A, 0x01, // A* (U+0041 U+002A)
  0x00, 0x41, 0x00, 0x3F, 0x01, // A? (U+0041 U+003F)
  0x00, 0x41, 0x00, 0x54, 0x01, // AT (U+0041 U+0054)
  0x00, 0x41, 0x00, 0x56, 0x01, // AV (U+0041 U+0056)
  0x00, 0x41, 0x00, 0x57, 0x01, // AW (U+0041 U+0057)
  0x00, 0x41, 0x00, 0x59, 0x01, // AY (U+0041 U+0059)
  0x00, 0x41, 0x00, 0x76, 0x01, // Av (U+0041 U+0076)
  0x00, 0x41, 0x00, 0x77, 0x01, // Aw (U+0041 U+0077)
  0x00, 0x41, 0x00, 0x79, 0x01, // Ay (U+0041 U+0079)
  0x00, 0x41, 0x00, 0xDD, 0x01, // AÝ (U+0041 U+00DD)
  0x00, 0x41, 0x00, 0xFD, 0x01, // Aý (U+0041 U+00FD)
  0x00, 0x41, 0x00, 0xFF, 0x01, // Aÿ (U+0041 U+00FF)
  0x00, 0x41, 0x01, 0x62, 0x01, // AŢ (U+0041 U+0162)
  0x00, 0x41, 0x01, 0x64, 0x01, // AŤ (U+0041 U+0164)
  0x00, 0x41, 0x01, 0x66, 0x01, // AŦ (U+0041 U+0166)
  0x00, 0x41, 0x01, 0x74, 0x01, // AŴ (U+0041 U+0174)
  0x00, 0x41, 0x01, 0x75, 0x01, // Aŵ (U+0041 U+0175)
  0x00, 0x41, 0x01, 0x76, 0x01, // AŶ (U+0041 U+0176)
  0x00, 0x41, 0x01, 0x77, 0x01, // Aŷ (U+0041 U+0177)
  0x00, 0x41, 0x01, 0x78, 0x01, // AŸ (U+0041 U+0178)
  0x00, 0x41, 0x20, 0x18, 0x01, // A‘ (U+0041 U+2018)
  0x00, 0x41, 0x20, 0x19, 0x01, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1C, 0x01, // A“ (U+0041 U+201C)
  0x00, 0x41, 0x20, 0x1D, 0x01, // A” (U+0041 U+201D)
  0x00, 0x41, 0x21, 0x22, 0x01, // A™ (U+0041 U+2122)
  0x00, 0x42, 0x00, 0x56, 0x01, // BV (U+0042 U+0056)
  0x00, 0x42, 0x00, 0x57, 0x01, // BW (U+0042 U+0057)
  0x00, 0x42, 0x00, 0x59, 0x01, // BY (U+0042 U+0059)
  0x00, 0x42, 0x00, 0xC6, 0x01, // BÆ (U+0042 U+00C6)
  0x00, 0x42, 0x00, 0xDD, 0x01, // BÝ (U+0042 U+00DD)
  0x00, 0x42, 0x01, 0x74, 0x01, // BŴ (U+0042 U+0174)
  0x00, 0x42, 0x01, 0x76, 0x01, // BŶ (U+0042 U+0176)
  0x00, 0x42, 0x01, 0x78, 0x01, // BŸ (U+0042 U+0178)
  0x00, 0x44, 0x00, 0x59, 0x01, // DY (U+0044 U+0059)
  0x00, 0x44, 0x00, 0xC6, 0x01, // DÆ (U+0044 U+00C6)
  0x00, 0x44, 0x00, 0xDD, 0x01, // DÝ (U+0044 U+00DD)
  0x00, 0x44, 0x01, 0x76, 0x01, // DŶ (U+0044 U+0176)
  0x00, 0x44, 0x01, 0x78, 0x01, // DŸ (U+0044 U+0178)
  0x00, 0x46, 0x00, 0x2C, 0x02, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x02, // F. (U+0046 U+002E)
  0x00, 0x46, 0x00, 0x40, 0x01, // F@ (U+0046 U+0040)
  0x00, 0x46, 0x00, 0x41, 0x01, // FA (U+0046 U+0041)
  0x00, 0x46, 0x00, 0x61, 0x01, // Fa (U+0046 U+0061)
  0x00, 0x46, 0x00, 0x63, 0x01, // Fc (U+0046 U+0063)
  0x00, 0x46, 0x00, 0x64, 0x01, // Fd (U+0046 U+0064)
  0x00, 0x46, 0x00, 0x65, 0x01, // Fe (U+0046 U+0065)
  0x00, 0x46, 0x00, 0x67, 0x01, // Fg (U+0046 U+0067)
  0x00, 0x46, 0x00, 0x6F, 0x01, // Fo (U+0046 U+006F)
  0x00, 0x46, 0x00, 0x71, 0x01, // Fq (U+0046 U+0071)
  0x00, 0x46, 0x00, 0xC0, 0x01, // FÀ (U+0046 U+00C0)
  0x00, 0x46, 0x00, 0xC1, 0x01, // FÁ (U+0046 U+00C1)
  0x00, 0x46, 0x00, 0xC2, 0x01, // FÂ (U+0046 U+00C2)
  0x00, 0x46, 0x00, 0xC3, 0x01, // FÃ (U+0046 U+00C3)
  0x00, 0x46, 0x00, 0xC4, 0x01, // FÄ (U+0046 U+00C4)
  0x00, 0x46, 0x00, 0xC5, 0x01, // FÅ (U+0046 U+00C5)
  0x00, 0x46, 0x00, 0xC6, 0x02, // FÆ (U+0046 U+00C6)
  0x00, 0x46, 0x00, 0xE0, 0x01, // Fà (U+0046 U+00E0)
  0x00, 0x46, 0x00, 0xE1, 0x01, // Fá (U+0046 U+00E1)
  0x00, 0x46, 0x00, 0xE2, 0x01, // Fâ (U+0046 U+00E2)
  0x00, 0x46, 0x00, 0xE3, 0x01, // Fã (U+0046 U+00E3)
  0x00, 0x46, 0x00, 0xE4, 0x01, // Fä (U+0046 U+00E4)
  0x00, 0x46, 0x00, 0xE5, 0x01, // Få (U+0046 U+00E5)
  0x00, 0x46, 0x00, 0xE6, 0x01, // Fæ (U+0046 U+00E6)
  0x00, 0x46, 0x00, 0xE7, 0x01, // Fç (U+0046 U+00E7)
  0x00, 0x46, 0x00, 0xE8, 0x01, // Fè (U+0046 U+00E8)
  0x00, 0x46, 0x00, 0xE9, 0x01, // Fé (U+0046 U+00E9)
  0x00, 0x46, 0x00, 0xEA, 0x01, // Fê (U+0046 U+00EA)
  0x00, 0x46, 0x00, 0xEB, 0x01, // Fë (U+0046 U+00EB)
  0x00, 0x46, 0x00, 0xF0, 0x01, // Fð (U+0046 U+00F0)
  0x00, 0x46, 0x00, 0xF2, 0x01, // Fò (U+0046 U+00F2)
  0x00, 0x46, 0x00, 0xF3, 0x01, // Fó (U+0046 U+00F3)
  0x00, 0x46, 0x00, 0xF4, 0x01, // Fô (U+0046 U+00F4)
  0x00, 0x46, 0x00, 0xF5, 0x01, // Fõ (U+0046 U+00F5)
  0x00, 0x46, 0x00, 0xF6, 0x01, // Fö (U+0046 U+00F6)
  0x00, 0x46, 0x00, 0xF8, 0x01, // Fø (U+0046 U+00F8)
  0x00, 0x46, 0x01, 0x00, 0x01, // FĀ (U+0046 U+0100)
  0x00, 0x46, 0x01, 0x01, 0x01, // Fā (U+0046 U+0101)
  0x00, 0x46, 0x01, 0x02, 0x01, // FĂ (U+0046 U+0102)
  0x00, 0x46, 0x01, 0x03, 0x01, // Fă (U+0046 U+0103)
  0x00, 0x46, 0x01, 0x04, 0x01, // FĄ (U+0046 U+0104)
  0x00, 0x46, 0x01, 0x05, 0x01, // Fą (U+0046 U+0105)
  0x00, 0x46, 0x01, 0x07, 0x01, // Fć (U+0046 U+0107)
  0x00, 0x46, 0x01, 0x09, 0x01, // Fĉ (U+0046 U+0109)
  0x00, 0x46, 0x01, 0x0B, 0x01, // Fċ (U+0046 U+010B)
  0x00, 0x46, 0x01, 0x0D, 0x01, // Fč (U+0046 U+010D)
  0x00, 0x46, 0x01, 0x0F, 0x01, // Fď (U+0046 U+010F)
  0x00, 0x46, 0x01, 0x11, 0x01, // Fđ (U+0046 U+0111)
  0x00, 0x46, 0x01, 0x13, 0x01, // Fē (U+0046 U+0113)
  0x00, 0x46, 0x01, 0x15, 0x01, // Fĕ (U+0046 U+0115)
  0x00, 0x46, 0x01, 0x17, 0x01, // Fė (U+0046 U+0117)
  0x00, 0x46, 0x01, 0x19, 0x01, // Fę (U+0046 U+0119)
  0x00, 0x46, 0x01, 0x1B, 0x01, // Fě (U+0046 U+011B)
  0x00, 0x46, 0x01, 0x1D, 0x01, // Fĝ (U+0046 U+011D)
  0x00, 0x46, 0x01, 0x1F, 0x01, // Fğ (U+0046 U+011F)
  0x00, 0x46, 0x01, 0x21, 0x01, // Fġ (U+0046 U+0121)
  0x00, 0x46, 0x01, 0x23, 0x01, // Fģ (U+0046 U+0123)
  0x00, 0x46, 0x01, 0x4D, 0x01, // Fō (U+0046 U+014D)
  0x00, 0x46, 0x01, 0x4F, 0x01, // Fŏ (U+0046 U+014F)
  0x00, 0x46, 0x01, 0x51, 0x01, // Fő (U+0046 U+0151)
  0x00, 0x46, 0x01, 0x53, 0x01, // Fœ (U+0046 U+0153)
  0x00, 0x46, 0x20, 0x1A, 0x02, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x02, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x02, // F… (U+0046 U+2026)
  0x00, 0x4B, 0x00, 0x77, 0x01, // Kw (U+004B U+0077)
  0x00, 0x4B, 0x00, 0x79, 0x01, // Ky (U+004B U+0079)
  0x00, 0x4B, 0x00, 0xFD, 0x01, // Ký (U+004B U+00FD)
  0x00, 0x4B, 0x00, 0xFF, 0x01, // Kÿ (U+004B U+00FF)
  0x00, 0x4B, 0x01, 0x75, 0x01, // Kŵ (U+004B U+0175)
  0x00, 0x4B, 0x01, 0x77, 0x01, // Kŷ (U+004B U+0177)
  0x00, 0x4C, 0x00, 0x22, 0x01, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x01, // L' (U+004C U+0027)
  0x00, 0x4C, 0x00, 0x2A, 0x01, // L* (U+004C U+002A)
  0x00, 0x4C, 0x00, 0x3F, 0x01, // L? (U+004C U+003F)
  0x00, 0x4C, 0x00, 0x54, 0x01, // LT (U+004C U+0054)
  0x00, 0x4C, 0x00, 0x56, 0x01, // LV (U+004C U+0056)
  0x00, 0x4C, 0x00, 0x57, 0x01, // LW (U+004C U+0057)
  0x00, 0x4C, 0x00, 0x59, 0x01, // LY (U+004C U+0059)
  0x00, 0x4C, 0x00, 0x79, 0x01, // Ly (U+004C U+0079)
  0x00, 0x4C, 0x00, 0xDD, 0x01, // LÝ (U+004C U+00DD)
  0x00, 0x4C, 0x00, 0xFD, 0x01, // Lý (U+004C U+00FD)
  0x00, 0x4C, 0x00, 0xFF, 0x01, // Lÿ (U+004C U+00FF)
  0x00, 0x4C, 0x01, 0x62, 0x01, // LŢ (U+004C U+0162)
  0x00, 0x4C, 0x01, 0x64, 0x01, // LŤ (U+004C U+0164)
  0x00, 0x4C, 0x01, 0x66, 0x01, // LŦ (U+004C U+0166)
  0x00, 0x4C, 0x01, 0x74, 0x01, // LŴ (U+004C U+0174)
  0x00, 0x4C, 0x01, 0x76, 0x01, // LŶ (U+004C U+0176)
  0x00, 0x4C, 0x01, 0x77, 0x01, // Lŷ (U+004C U+0177)
  0x00, 0x4C, 0x01, 0x78, 0x01, // LŸ (U+004C U+0178)
  0x00, 0x4C, 0x20, 0x18, 0x01, // L‘ (U+004C U+2018)
  0x00, 0x4C, 0x20, 0x19, 0x01, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1C, 0x01, // L“ (U+004C U+201C)
  0x00, 0x4C, 0x20, 0x1D, 0x01, // L” (U+004C U+201D)
  0x00, 0x4C, 0x21, 0x22, 0x01, // L™ (U+004C U+2122)
  0x00, 0x4F, 0x00, 0x59, 0x01, // OY (U+004F U+0059)
  0x00, 0x4F, 0x00, 0xC6, 0x01, // OÆ (U+004F U+00C6)
  0x00, 0x4F, 0x00, 0xDD, 0x01, // OÝ (U+004F U+00DD)
  0x00, 0x4F, 0x01, 0x76, 0x01, // OŶ (U+004F U+0176)
  0x00, 0x4F, 0x01, 0x78, 0x01, // OŸ (U+004F U+0178)
  0x00, 0x50, 0x00, 0x2C, 0x02, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x02, // P. (U+0050 U+002E)
  0x00, 0x50, 0x00, 0x41, 0x01, // PA (U+0050 U+0041)
  0x00, 0x50, 0x00, 0xC0, 0x01, // PÀ (U+0050 U+00C0)
  0x00, 0x50, 0x00, 0xC1, 0x01, // PÁ (U+0050 U+00C1)
  0x00, 0x50, 0x00, 0xC2, 0x01, // PÂ (U+0050 U+00C2)
  0x00, 0x50, 0x00, 0xC3, 0x01, // PÃ (U+0050 U+00C3)
  0x00, 0x50, 0x00, 0xC4, 0x01, // PÄ (U+0050 U+00C4)
  0x00, 0x50, 0x00, 0xC5, 0x01, // PÅ (U+0050 U+00C5)
  0x00, 0x50, 0x00, 0xC6, 0x01, // PÆ (U+0050 U+00C6)
  0x00, 0x50, 0x01, 0x00, 0x01, // PĀ (U+0050 U+0100)
  0x00, 0x50, 0x01, 0x02, 0x01, // PĂ (U+0050 U+0102)
  0x00, 0x50, 0x01, 0x04, 0x01, // PĄ (U+0050 U+0104)
  0x00, 0x50, 0x20, 0x1A, 0x02, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x02, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x02, // P… (U+0050 U+2026)
  0x00, 0x51, 0x00, 0x59, 0x01, // QY (U+0051 U+0059)
  0x00, 0x51, 0x00, 0xC6, 0x01, // QÆ (U+0051 U+00C6)
  0x00, 0x51, 0x00, 0xDD, 0x01, // QÝ (U+0051 U+00DD)
  0x00, 0x51, 0x01, 0x76, 0x01, // QŶ (U+0051 U+0176)
  0x00, 0x51, 0x01, 0x78, 0x01, // QŸ (U+0051 U+0178)
  0x00, 0x52, 0x00, 0x56, 0x01, // RV (U+0052 U+0056)
  0x00, 0x52, 0x00, 0x57, 0x01, // RW (U+0052 U+0057)
  0x00, 0x52, 0x00, 0x59, 0x01, // RY (U+0052 U+0059)
  0x00, 0x52, 0x00, 0xDD, 0x01, // RÝ (U+0052 U+00DD)
  0x00, 0x52, 0x01, 0x74, 0x01, // RŴ (U+0052 U+0174)
  0x00, 0x52, 0x01, 0x76, 0x01, // RŶ (U+0052 U+0176)
  0x00, 0x52, 0x01, 0x78, 0x01, // RŸ (U+0052 U+0178)
  0x00, 0x54, 0x00, 0x2C, 0x02, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2E, 0x02, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0x40, 0x01, // T@ (U+0054 U+0040)
  0x00, 0x54, 0x00, 0x41, 0x01, // TA (U+0054 U+0041)
  0x00, 0x54, 0x00, 0x61, 0x01, // Ta (U+0054 U+0061)
  0x00, 0x54, 0x00, 0x63, 0x01, // Tc (U+0054 U+0063)
  0x00, 0x54, 0x00, 0x64, 0x01, // Td (U+0054 U+0064)
  0x00, 0x54, 0x00, 0x65, 0x01, // Te (U+0054 U+0065)
  0x00, 0x54, 0x00, 0x67, 0x01, // Tg (U+0054 U+0067)
  0x00, 0x54, 0x00, 0x6F, 0x01, // To (U+0054 U+006F)
  0x00, 0x54, 0x00, 0x71, 0x01, // Tq (U+0054 U+0071)
  0x00, 0x54, 0x00, 0xC0, 0x01, // TÀ (U+0054 U+00C0)
  0x00, 0x54, 0x00, 0xC1, 0x01, // TÁ (U+0054 U+00C1)
  0x00, 0x54, 0x00, 0xC2, 0x01, // TÂ (U+0054 U+00C2)
  0x00, 0x54, 0x00, 0xC3, 0x01, // TÃ (U+0054 U+00C3)
  0x00, 0x54, 0x00, 0xC4, 0x01, // TÄ (U+0054 U+00C4)
  0x00, 0x54, 0x00, 0xC5, 0x01, // TÅ (U+0054 U+00C5)
  0x00, 0x54, 0x00, 0xC6, 0x01, // TÆ (U+0054 U+00C6)
  0x00, 0x54, 0x00, 0xE0, 0x01, // Tà (U+0054 U+00E0)
  0x00, 0x54, 0x00, 0xE1, 0x01, // Tá (U+0054 U+00E1)
  0x00, 0x54, 0x00, 0xE2, 0x01, // Tâ (U+0054 U+00E2)
  0x00, 0x54, 0x00, 0xE3, 0x01, // Tã (U+0054 U+00E3)
  0x00, 0x54, 0x00, 0xE4, 0x01, // Tä (U+0054 U+00E4)
  0x00, 0x54, 0x00, 0xE5, 0x01, // Tå (U+0054 U+00E5)
  0x00, 0x54, 0x00, 0xE6, 0x01, // Tæ (U+0054 U+00E6)
  0x00, 0x54, 0x00, 0xE7, 0x01, // Tç (U+0054 U+00E7)
  0x00, 0x54, 0x00, 0xE8, 0x01, // Tè (U+0054 U+00E8)
  0x00, 0x54, 0x00, 0xE9, 0x01, // Té (U+0054 U+00E9)
  0x00, 0x54, 0x00, 0xEA, 0x01, // Tê (U+0054 U+00EA)
  0x00, 0x54, 0x00, 0xEB, 0x01, // Të (U+0054 U+00EB)
  0x00, 0x54, 0x00, 0xF0, 0x01, // Tð (U+0054 U+00F0)
  0x00, 0x54, 0x00, 0xF2, 0x01, // Tò (U+0054 U+00F2)
  0x00, 0x54, 0x00, 0xF3, 0x01, // Tó (U+0054 U+00F3)
  0x00, 0x54, 0x00, 0xF4, 0x01, // Tô (U+0054 U+00F4)
  0x00, 0x54, 0x00, 0xF5, 0x01, // Tõ (U+0054 U+00F5)
  0x00, 0x54, 0x00, 0xF6, 0x01, // Tö (U+0054 U+00F6)
  0x00, 0x54, 0x00, 0xF8, 0x01, // Tø (U+0054 U+00F8)
  0x00, 0x54, 0x01, 0x00, 0x01, // TĀ (U+0054 U+0100)
  0x00, 0x54, 0x01, 0x01, 0x01, // Tā (U+0054 U+0101)
  0x00, 0x54, 0x01, 0x02, 0x01, // TĂ (U+0054 U+0102)
  0x00, 0x54, 0x01, 0x03, 0x01, // Tă (U+0054 U+0103)
  0x00, 0x54, 0x01, 0x04, 0x01, // TĄ (U+0054 U+0104)
  0x00, 0x54, 0x01, 0x05, 0x01, // Tą (U+0054 U+0105)
  0x00, 0x54, 0x01, 0x07, 0x01, // Tć (U+0054 U+0107)
  0x00, 0x54, 0x01, 0x09, 0x01, // Tĉ (U+0054 U+0109)
  0x00, 0x54, 0x01, 0x0B, 0x01, // Tċ (U+0054 U+010B)
  0x00, 0x54, 0x01, 0x0D, 0x01, // Tč (U+0054 U+010D)
  0x00, 0x54, 0x01, 0x0F, 0x01, // Tď (U+0054 U+010F)
  0x00, 0x54, 0x01, 0x11, 0x01, // Tđ (U+0054 U+0111)
  0x00, 0x54, 0x01, 0x13, 0x01, // Tē (U+0054 U+0113)
  0x00, 0x54, 0x01, 0x15, 0x01, // Tĕ (U+0054 U+0115)
  0x00, 0x54, 0x01, 0x17, 0x01, // Tė (U+0054 U+0117)
  0x00, 0x54, 0x01, 0x19, 0x01, // Tę (U+0054 U+0119)
  0x00, 0x54, 0x01, 0x1B, 0x01, // Tě (U+0054 U+011B)
  0x00, 0x54, 0x01, 0x1D, 0x01, // Tĝ (U+0054 U+011D)
  0x00, 0x54, 0x01, 0x1F, 0x01, // Tğ (U+0054 U+011F)
  0x00, 0x54, 0x01, 0x21, 0x01, // Tġ (U+0054 U+0121)
  0x00, 0x54, 0x01, 0x23, 0x01, // Tģ (U+0054 U+0123)
  0x00, 0x54, 0x01, 0x4D, 0x01, // Tō (U+0054 U+014D)
  0x00, 0x54, 0x01, 0x4F, 0x01, // Tŏ (U+0054 U+014F)
  0x00, 0x54, 0x01, 0x51, 0x01, // Tő (U+0054 U+0151)
  0x00, 0x54, 0x01, 0x53, 0x01, // Tœ (U+0054 U+0153)
  0x00, 0x54, 0x20, 0x1A, 0x02, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x02, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x02, // T… (U+0054 U+2026)
  0x00, 0x55, 0x00, 0xC6, 0x01, // UÆ (U+0055 U+00C6)
  0x00, 0x56, 0x00, 0x26, 0x01, // V& (U+0056 U+0026)
  0x00, 0x56, 0x00, 0x2C, 0x02, // V, (U+0056 U+002C)
  0x00, 0x56, 0x00, 0x2E, 0x02, // V. (U+0056 U+002E)
  0x00, 0x56, 0x00, 0x40, 0x01, // V@ (U+0056 U+0040)
  0x00, 0x56, 0x00, 0x41, 0x01, // VA (U+0056 U+0041)
  0x00, 0x56, 0x00, 0x61, 0x01, // Va (U+0056 U+0061)
  0x00, 0x56, 0x00, 0x63, 0x01, // Vc (U+0056 U+0063)
  0x00, 0x56, 0x00, 0x64, 0x01, // Vd (U+0056 U+0064)
  0x00, 0x56, 0x00, 0x65, 0x01, // Ve (U+0056 U+0065)
  0x00, 0x56, 0x00, 0x67, 0x01, // Vg (U+0056 U+0067)
  0x00, 0x56, 0x00, 0x6F, 0x01, // Vo (U+0056 U+006F)
  0x00, 0x56, 0x00, 0x71, 0x01, // Vq (U+0056 U+0071)
  0x00, 0x56, 0x00, 0x73, 0x01, // Vs (U+0056 U+0073)
  0x00, 0x56, 0x00, 0xC0, 0x01, // VÀ (U+0056 U+00C0)
  0x00, 0x56, 0x00, 0xC1, 0x01, // VÁ (U+0056 U+00C1)
  0x00, 0x56, 0x00, 0xC2, 0x01, // VÂ (U+0056 U+00C2)
  0x00, 0x56, 0x00, 0xC3, 0x01, // VÃ (U+0056 U+00C3)
  0x00, 0x56, 0x00, 0xC4, 0x01, // VÄ (U+0056 U+00C4)
  0x00, 0x56, 0x00, 0xC5, 0x01, // VÅ (U+0056 U+00C5)
  0x00, 0x56, 0x00, 0xC6, 0x02, // VÆ (U+0056 U+00C6)
  0x00, 0x56, 0x00, 0xE0, 0x01, // Và (U+0056 U+00E0)
  0x00, 0x56, 0x00, 0xE1, 0x01, // Vá (U+0056 U+00E1)
  0x00, 0x56, 0x00, 0xE2, 0x01, // Vâ (U+0056 U+00E2)
  0x00, 0x56, 0x00, 0xE3, 0x01, // Vã (U+0056 U+00E3)
  0x00, 0x56, 0x00, 0xE4, 0x01, // Vä (U+0056 U+00E4)
  0x00, 0x56, 0x00, 0xE5, 0x01, // Vå (U+0056 U+00E5)
  0x00, 0x56, 0x00, 0xE6, 0x01, // Væ (U+0056 U+00E6)
  0x00, 0x56, 0x00, 0xE7, 0x01, // Vç (U+0056 U+00E7)
  0x00, 0x56, 0x00, 0xE8, 0x01, // Vè (U+0056 U+00E8)
  0x00, 0x56, 0x00, 0xE9, 0x01, // Vé (U+0056 U+00E9)
  0x00, 0x56, 0x00, 0xEA, 0x01, // Vê (U+0056 U+00EA)
  0x00, 0x56, 0x00, 0xEB, 0x01, // Vë (U+0056 U+00EB)
  0x00, 0x56, 0x00, 0xF0, 0x01, // Vð (U+0056 U+00F0)
  0x00, 0x56, 0x00, 0xF2, 0x01, // Vò (U+0056 U+00F2)
  0x00, 0x56, 0x00, 0xF3, 0x01, // Vó (U+0056 U+00F3)
  0x00, 0x56, 0x00, 0xF4, 0x01, // Vô (U+0056 U+00F4)
  0x00, 0x56, 0x00, 0xF5, 0x01, // Võ (U+0056 U+00F5)
  0x00, 0x56, 0x00, 0xF6, 0x01, // Vö (U+0056 U+00F6)
  0x00, 0x56, 0x00, 0xF8, 0x01, // Vø (U+0056 U+00F8)
  0x00, 0x56, 0x01, 0x00, 0x01, // VĀ (U+0056 U+0100)
  0x00, 0x56, 0x01, 0x01, 0x01, // Vā (U+0056 U+0101)
  0x00, 0x56, 0x01, 0x02, 0x01, // VĂ (U+0056 U+0102)
  0x00, 0x56, 0x01, 0x03, 0x01, // Vă (U+0056 U+0103)
  0x00, 0x56, 0x01, 0x04, 0x01, // VĄ (U+0056 U+0104)
  0x00, 0x56, 0x01, 0x05, 0x01, // Vą (U+0056 U+0105)
  0x00, 0x56, 0x01, 0x07, 0x01, // Vć (U+0056 U+0107)
  0x00, 0x56, 0x01, 0x09, 0x01, // Vĉ (U+0056 U+0109)
  0x00, 0x56, 0x01, 0x0B, 0x01, // Vċ (U+0056 U+010B)
  0x00, 0x56, 0x01, 0x0D, 0x01, // Vč (U+0056 U+010D)
  0x00, 0x56, 0x01, 0x0F, 0x01, // Vď (U+0056 U+010F)
  0x00, 0x56, 0x01, 0x11, 0x01, // Vđ (U+0056 U+0111)
  0x00, 0x56, 0x01, 0x13, 0x01, // Vē (U+0056 U+0113)
  0x00, 0x56, 0x01, 0x15, 0x01, // Vĕ (U+0056 U+0115)
  0x00, 0x56, 0x01, 0x17, 0x01, // Vė (U+0056 U+0117)
  0x00, 0x56, 0x01, 0x19, 0x01, // Vę (U+0056 U+0119)
  0x00, 0x56, 0x01, 0x1B, 0x01, // Vě (U+0056 U+011B)
  0x00, 0x56, 0x01, 0x1D, 0x01, // Vĝ (U+0056 U+011D)
  0x00, 0x56, 0x01, 0x1F, 0x01, // Vğ (U+0056 U+011F)
  0x00, 0x56, 0x01, 0x21, 0x01, // Vġ (U+0056 U+0121)
  0x00, 0x56, 0x01, 0x23, 0x01, // Vģ (U+0056 U+0123)
  0x00, 0x56, 0x01, 0x4D, 0x01, // Vō (U+0056 U+014D)
  0x00, 0x56, 0x01, 0x4F, 0x01, // Vŏ (U+0056 U+014F)
  0x00, 0x56, 0x01, 0x51, 0x01, // Vő (U+0056 U+0151)
  0x00, 0x56, 0x01, 0x53, 0x01, // Vœ (U+0056 U+0153)
  0x00, 0x56, 0x01, 0x5B, 0x01, // Vś (U+0056 U+015B)
  0x00, 0x56, 0x01, 0x5D, 0x01, // Vŝ (U+0056 U+015D)
  0x00, 0x56, 0x01, 0x5F, 0x01, // Vş (U+0056 U+015F)
  0x00, 0x56, 0x01, 0x61, 0x01, // Vš (U+0056 U+0161)
  0x00, 0x56, 0x20, 0x1A, 0x02, // V‚ (U+0056 U+201A)
  0x00, 0x56, 0x20, 0x1E, 0x02, // V„ (U+0056 U+201E)
  0x00, 0x56, 0x20, 0x26, 0x02, // V… (U+0056 U+2026)
  0x00, 0x57, 0x00, 0x2C, 0x02, // W, (U+0057 U+002C)
  0x00, 0x57, 0x00, 0x2E, 0x02, // W. (U+0057 U+002E)
  0x00, 0x57, 0x00, 0x40, 0x01, // W@ (U+0057 U+0040)
  0x00, 0x57, 0x00, 0x41, 0x01, // WA (U+0057 U+0041)
  0x00, 0x57, 0x00, 0x61, 0x01, // Wa (U+0057 U+0061)
  0x00, 0x57, 0x00, 0x63, 0x01, // Wc (U+0057 U+0063)
  0x00, 0x57, 0x00, 0x64, 0x01, // Wd (U+0057 U+0064)
  0x00, 0x57, 0x00, 0x65, 0x01, // We (U+0057 U+0065)
  0x00, 0x57, 0x00, 0x67, 0x01, // Wg (U+0057 U+0067)
  0x00, 0x57, 0x00, 0x6F, 0x01, // Wo (U+0057 U+006F)
  0x00, 0x57, 0x00, 0x71, 0x01, // Wq (U+0057 U+0071)
  0x00, 0x57, 0x00, 0x73, 0x01, // Ws (U+0057 U+0073)
  0x00, 0x57, 0x00, 0x7A, 0x01, // Wz (U+0057 U+007A)
  0x00, 0x57, 0x00, 0xC0, 0x01, // WÀ (U+0057 U+00C0)
  0x00, 0x57, 0x00, 0xC1, 0x01, // WÁ (U+0057 U+00C1)
  0x00, 0x57, 0x00, 0xC2, 0x01, // WÂ (U+0057 U+00C2)
  0x00, 0x57, 0x00, 0xC3, 0x01, // WÃ (U+0057 U+00C3)
  0x00, 0x57, 0x00, 0xC4, 0x01, // WÄ (U+0057 U+00C4)
  0x00, 0x57, 0x00, 0xC5, 0x01, // WÅ (U+0057 U+00C5)
  0x00, 0x57, 0x00, 0xC6, 0x02, // WÆ (U+0057 U+00C6)
  0x00, 0x57, 0x00, 0xE0, 0x01, // Wà (U+0057 U+00E0)
  0x00, 0x57, 0x00, 0xE1, 0x01, // Wá (U+0057 U+00E1)
  0x00, 0x57, 0x00, 0xE2, 0x01, // Wâ (U+0057 U+00E2)
  0x00, 0x57, 0x00, 0xE3, 0x01, // Wã (U+0057 U+00E3)
  0x00, 0x57, 0x00, 0xE4, 0x01, // Wä (U+0057 U+00E4)
  0x00, 0x57, 0x00, 0xE5, 0x01, // Wå (U+0057 U+00E5)
  0x00, 0x57, 0x00, 0xE6, 0x01, // Wæ (U+0057 U+00E6)
  0x00, 0x57, 0x00, 0xE7, 0x01, // Wç (U+0057 U+00E7)
  0x00, 0x57, 0x00, 0xE8, 0x01, // Wè (U+0057 U+00E8)
  0x00, 0x57, 0x00, 0xE9, 0x01, // Wé (U+0057 U+00E9)
  0x00, 0x57, 0x00, 0xEA, 0x01, // Wê (U+0057 U+00EA)
  0x00, 0x57, 0x00, 0xEB, 0x01, // Wë (U+0057 U+00EB)
  0x00, 0x57, 0x00, 0xF0, 0x01, // Wð (U+0057 U+00F0)
  0x00, 0x57, 0x00, 0xF2, 0x01, // Wò (U+0057 U+00F2)
  0x00, 0x57, 0x00, 0xF3, 0x01, // Wó (U+0057 U+00F3)
  0x00, 0x57, 0x00, 0xF4, 0x01, // Wô (U+0057 U+00F4)
  0x00, 0x57, 0x00, 0xF5, 0x01, // Wõ (U+0057 U+00F5)
  0x00, 0x57, 0x00, 0xF6, 0x01, // Wö (U+0057 U+00F6)
  0x00, 0x57, 0x00, 0xF8, 0x01, // Wø (U+0057 U+00F8)
  0x00, 0x57, 0x01, 0x00, 0x01, // WĀ (U+0057 U+0100)
  0x00, 0x57, 0x01, 0x01, 0x01, // Wā (U+0057 U+0101)
  0x00, 0x57, 0x01, 0x02, 0x01, // WĂ (U+0057 U+0102)
  0x00, 0x57, 0x01, 0x03, 0x01, // Wă (U+0057 U+0103)
  0x00, 0x57, 0x01, 0x04, 0x01, // WĄ (U+0057 U+0104)
  0x00, 0x57, 0x01, 0x05, 0x01, // Wą (U+0057 U+0105)
  0x00, 0x57, 0x01, 0x07, 0x01, // Wć (U+0057 U+0107)
  0x00, 0x57, 0x01, 0x09, 0x01, // Wĉ (U+0057 U+0109)
  0x00, 0x57, 0x01, 0x0B, 0x01, // Wċ (U+0057 U+010B)
  0x00, 0x57, 0x01, 0x0D, 0x01, // Wč (U+0057 U+010D)
  0x00, 0x57, 0x01, 0x0F, 0x01, // Wď (U+0057 U+010F)
  0x00, 0x57, 0x01, 0x11, 0x01, // Wđ (U+0057 U+0111)
  0x00, 0x57, 0x01, 0x13, 0x01, // Wē (U+0057 U+0113)
  0x00, 0x57, 0x01, 0x15, 0x01, // Wĕ (U+0057 U+0115)
  0x00, 0x57, 0x01, 0x17, 0x01, // Wė (U+0057 U+0117)
  0x00, 0x57, 0x01, 0x19, 0x01, // Wę (U+0057 U+0119)
  0x00, 0x57, 0x01, 0x1B, 0x01, // Wě (U+0057 U+011B)
  0x00, 0x57, 0x01, 0x1D, 0x01, // Wĝ (U+0057 U+011D)
  0x00, 0x57, 0x01, 0x1F, 0x01, // Wğ (U+0057 U+011F)
  0x00, 0x57, 0x01, 0x21, 0x01, // Wġ (U+0057 U+0121)
  0x00, 0x57, 0x01, 0x23, 0x01, // Wģ (U+0057 U+0123)
  0x00, 0x57, 0x01, 0x4D, 0x01, // Wō (U+0057 U+014D)
  0x00, 0x57, 0x01, 0x4F, 0x01, // Wŏ (U+0057 U+014F)
  0x00, 0x57, 0x01, 0x51, 0x01, // Wő (U+0057 U+0151)
  0x00, 0x57, 0x01, 0x53, 0x01, // Wœ (U+0057 U+0153)
  0x00, 0x57, 0x01, 0x5B, 0x01, // Wś (U+0057 U+015B)
  0x00, 0x57, 0x01, 0x5D, 0x01, // Wŝ (U+0057 U+015D)
  0x00, 0x57, 0x01, 0x5F, 0x01, // Wş (U+0057 U+015F)
  0x00, 0x57, 0x01, 0x61, 0x01, // Wš (U+0057 U+0161)
  0x00, 0x57, 0x01, 0x7A, 0x01, // Wź (U+0057 U+017A)
  0x00, 0x57, 0x01, 0x7C, 0x01, // Wż (U+0057 U+017C)
  0x00, 0x57, 0x01, 0x7E, 0x01, // Wž (U+0057 U+017E)
  0x00, 0x57, 0x20, 0x1A, 0x02, // W‚ (U+0057 U+201A)
  0x00, 0x57, 0x20, 0x1E, 0x02, // W„ (U+0057 U+201E)
  0x00, 0x57, 0x20, 0x26, 0x02, // W… (U+0057 U+2026)
  0x00, 0x58, 0x00, 0x77, 0x01, // Xw (U+0058 U+0077)
  0x00, 0x58, 0x00, 0x79, 0x01, // Xy (U+0058 U+0079)
  0x00, 0x58, 0x00, 0xFD, 0x01, // Xý (U+0058 U+00FD)
  0x00, 0x58, 0x00, 0xFF, 0x01, // Xÿ (U+0058 U+00FF)
  0x00, 0x58, 0x01, 0x75, 0x01, // Xŵ (U+0058 U+0175)
  0x00, 0x58, 0x01, 0x77, 0x01, // Xŷ (U+0058 U+0177)
  0x00, 0x59, 0x00, 0x2C, 0x01, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x01, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x00, 0x40, 0x01, // Y@ (U+0059 U+0040)
  0x00, 0x59, 0x00, 0x41, 0x01, // YA (U+0059 U+0041)
  0x00, 0x59, 0x00, 0x43, 0x01, // YC (U+0059 U+0043)
  0x00, 0x59, 0x00, 0x47, 0x01, // YG (U+0059 U+0047)
  0x00, 0x59, 0x00, 0x4F, 0x01, // YO (U+0059 U+004F)
  0x00, 0x59, 0x00, 0x51, 0x01, // YQ (U+0059 U+0051)
  0x00, 0x59, 0x00, 0x61, 0x01, // Ya (U+0059 U+0061)
  0x00, 0x59, 0x00, 0x63, 0x01, // Yc (U+0059 U+0063)
  0x00, 0x59, 0x00, 0x64, 0x01, // Yd (U+0059 U+0064)
  0x00, 0x59, 0x00, 0x65, 0x01, // Ye (U+0059 U+0065)
  0x00, 0x59, 0x00, 0x67, 0x01, // Yg (U+0059 U+0067)
  0x00, 0x59, 0x00, 0x6F, 0x01, // Yo (U+0059 U+006F)
  0x00, 0x59, 0x00, 0x71, 0x01, // Yq (U+0059 U+0071)
  0x00, 0x59, 0x00, 0x73, 0x01, // Ys (U+0059 U+0073)
  0x00, 0x59, 0x00, 0xC0, 0x01, // YÀ (U+0059 U+00C0)
  0x00, 0x59, 0x00, 0xC1, 0x01, // YÁ (U+0059 U+00C1)
  0x00, 0x59, 0x00, 0xC2, 0x01, // YÂ (U+0059 U+00C2)
  0x00, 0x59, 0x00, 0xC3, 0x01, // YÃ (U+0059 U+00C3)
  0x00, 0x59, 0x00, 0xC4, 0x01, // YÄ (U+0059 U+00C4)
  0x00, 0x59, 0x00, 0xC5, 0x01, // YÅ (U+0059 U+00C5)
  0x00, 0x59, 0x00, 0xC6, 0x02, // YÆ (U+0059 U+00C6)
  0x00, 0x59, 0x00, 0xC7, 0x01, // YÇ (U+0059 U+00C7)
  0x00, 0x59, 0x00, 0xD2, 0x01, // YÒ (U+0059 U+00D2)
  0x00, 0x59, 0x00, 0xD3, 0x01, // YÓ (U+0059 U+00D3)
  0x00, 0x59, 0x00, 0xD4, 0x01, // YÔ (U+0059 U+00D4)
  0x00, 0x59, 0x00, 0xD5, 0x01, // YÕ (U+0059 U+00D5)
  0x00, 0x59, 0x00, 0xD6, 0x01, // YÖ (U+0059 U+00D6)
  0x00, 0x59, 0x00, 0xD8, 0x01, // YØ (U+0059 U+00D8)
  0x00, 0x59, 0x00, 0xE0, 0x01, // Yà (U+0059 U+00E0)
  0x00, 0x59, 0x00, 0xE1, 0x01, // Yá (U+0059 U+00E1)
  0x00, 0x59, 0x00, 0xE2, 0x01, // Yâ (U+0059 U+00E2)
  0x00, 0x59, 0x00, 0xE3, 0x01, // Yã (U+0059 U+00E3)
  0x00, 0x59, 0x00, 0xE4, 0x01, // Yä (U+0059 U+00E4)
  0x00, 0x59, 0x00, 0xE5, 0x01, // Yå (U+0059 U+00E5)
  0x00, 0x59, 0x00, 0xE6, 0x01, // Yæ (U+0059 U+00E6)
  0x00, 0x59, 0x00, 0xE7, 0x01, // Yç (U+0059 U+00E7)
  0x00, 0x59, 0x00, 0xE8, 0x01, // Yè (U+0059 U+00E8)
  0x00, 0x59, 0x00, 0xE9, 0x01, // Yé (U+0059 U+00E9)
  0x00, 0x59, 0x00, 0xEA, 0x01, // Yê (U+0059 U+00EA)
  0x00, 0x59, 0x00, 0xEB, 0x01, // Yë (U+0059 U+00EB)
  0x00, 0x59, 0x00, 0xF0, 0x01, // Yð (U+0059 U+00F0)
  0x00, 0x59, 0x00, 0xF2, 0x01, // Yò (U+0059 U+00F2)
  0x00, 0x59, 0x00, 0xF3, 0x01, // Yó (U+0059 U+00F3)
  0x00, 0x59, 0x00, 0xF4, 0x01, // Yô (U+0059 U+00F4)
  0x00, 0x59, 0x00, 0xF5, 0x01, // Yõ (U+0059 U+00F5)
  0x00, 0x59, 0x00, 0xF6, 0x01, // Yö (U+0059 U+00F6)
  0x00, 0x59, 0x00, 0xF8, 0x01, // Yø (U+0059 U+00F8)
  0x00, 0x59, 0x01, 0x00, 0x01, // YĀ (U+0059 U+0100)
  0x00, 0x59, 0x01, 0x01, 0x01, // Yā (U+0059 U+0101)
  0x00, 0x59, 0x01, 0x02, 0x01, // YĂ (U+0059 U+0102)
  0x00, 0x59, 0x01, 0x03, 0x01, // Yă (U+0059 U+0103)
  0x00, 0x59, 0x01, 0x04, 0x01, // YĄ (U+0059 U+0104)
  0x00, 0x59, 0x01, 0x05, 0x01, // Yą (U+0059 U+0105)
  0x00, 0x59, 0x01, 0x06, 0x01, // YĆ (U+0059 U+0106)
  0x00, 0x59, 0x01, 0x07, 0x01, // Yć (U+0059 U+0107)
  0x00, 0x59, 0x01, 0x08, 0x01, // YĈ (U+0059 U+0108)
  0x00, 0x59, 0x01, 0x09, 0x01, // Yĉ (U+0059 U+0109)
  0x00, 0x59, 0x01, 0x0A, 0x01, // YĊ (U+0059 U+010A)
  0x00, 0x59, 0x01, 0x0B, 0x01, // Yċ (U+0059 U+010B)
  0x00, 0x59, 0x01, 0x0C, 0x01, // YČ (U+0059 U+010C)
  0x00, 0x59, 0x01, 0x0D, 0x01, // Yč (U+0059 U+010D)
  0x00, 0x59, 0x01, 0x0F, 0x01, // Yď (U+0059 U+010F)
  0x00, 0x59, 0x01, 0x11, 0x01, // Yđ (U+0059 U+0111)
  0x00, 0x59, 0x01, 0x13, 0x01, // Yē (U+0059 U+0113)
  0x00, 0x59, 0x01, 0x15, 0x01, // Yĕ (U+0059 U+0115)
  0x00, 0x59, 0x01, 0x17, 0x01, // Yė (U+0059 U+0117)
  0x00, 0x59, 0x01, 0x19, 0x01, // Yę (U+0059 U+0119)
  0x00, 0x59, 0x01, 0x1B, 0x01, // Yě (U+0059 U+011B)
  0x00, 0x59, 0x01, 0x1C, 0x01, // YĜ (U+0059 U+011C)
  0x00, 0x59, 0x01, 0x1D, 0x01, // Yĝ (U+0059 U+011D)
  0x00, 0x59, 0x01, 0x1E, 0x01, // YĞ (U+0059 U+011E)
  0x00, 0x59, 0x01, 0x1F, 0x01, // Yğ (U+0059 U+011F)
  0x00, 0x59, 0x01, 0x20, 0x01, // YĠ (U+0059 U+0120)
  0x00, 0x59, 0x01, 0x21, 0x01, // Yġ (U+0059 U+0121)
  0x00, 0x59, 0x01, 0x22, 0x01, // YĢ (U+0059 U+0122)
  0x00, 0x59, 0x01, 0x23, 0x01, // Yģ (U+0059 U+0123)
  0x00, 0x59, 0x01, 0x4C, 0x01, // YŌ (U+0059 U+014C)
  0x00, 0x59, 0x01, 0x4D, 0x01, // Yō (U+0059 U+014D)
  0x00, 0x59, 0x01, 0x4E, 0x01, // YŎ (U+0059 U+014E)
  0x00, 0x59, 0x01, 0x4F, 0x01, // Yŏ (U+0059 U+014F)
  0x00, 0x59, 0x01, 0x50, 0x01, // YŐ (U+0059 U+0150)
  0x00, 0x59, 0x01, 0x51, 0x01, // Yő (U+0059 U+0151)
  0x00, 0x59, 0x01, 0x52, 0x01, // YŒ (U+0059 U+0152)
  0x00, 0x59, 0x01, 0x53, 0x01, // Yœ (U+0059 U+0153)
  0x00, 0x59, 0x01, 0x5B, 0x01, // Yś (U+0059 U+015B)
  0x00, 0x59, 0x01, 0x5D, 0x01, // Yŝ (U+0059 U+015D)
  0x00, 0x59, 0x01, 0x5F, 0x01, // Yş (U+0059 U+015F)
  0x00, 0x59, 0x01, 0x61, 0x01, // Yš (U+0059 U+0161)
  0x00, 0x59, 0x20, 0x1A, 0x01, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x01, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x01, // Y… (U+0059 U+2026)
  0x00, 0x61, 0x00, 0x22, 0x01, // a" (U+0061 U+0022)
  0x00, 0x61, 0x00, 0x27, 0x01, // a' (U+0061 U+0027)
  0x00, 0x62, 0x00, 0x56, 0x01, // bV (U+0062 U+0056)
  0x00, 0x62, 0x00, 0x57, 0x01, // bW (U+0062 U+0057)
  0x00, 0x62, 0x00, 0x59, 0x01, // bY (U+0062 U+0059)
  0x00, 0x62, 0x00, 0xDD, 0x01, // bÝ (U+0062 U+00DD)
  0x00, 0x62, 0x01, 0x74, 0x01, // bŴ (U+0062 U+0174)
  0x00, 0x62, 0x01, 0x76, 0x01, // bŶ (U+0062 U+0176)
  0x00, 0x62, 0x01, 0x78, 0x01, // bŸ (U+0062 U+0178)
  0x00, 0x65, 0x00, 0x56, 0x01, // eV (U+0065 U+0056)
  0x00, 0x65, 0x00, 0x57, 0x01, // eW (U+0065 U+0057)
  0x00, 0x65, 0x00, 0x59, 0x01, // eY (U+0065 U+0059)
  0x00, 0x65, 0x00, 0xDD, 0x01, // eÝ (U+0065 U+00DD)
  0x00, 0x65, 0x01, 0x74, 0x01, // eŴ (U+0065 U+0174)
  0x00, 0x65, 0x01, 0x76, 0x01, // eŶ (U+0065 U+0176)
  0x00, 0x65, 0x01, 0x78, 0x01, // eŸ (U+0065 U+0178)
  0x00, 0x68, 0x00, 0x22, 0x01, // h" (U+0068 U+0022)
  0x00, 0x68, 0x00, 0x27, 0x01, // h' (U+0068 U+0027)
  0x00, 0x6D, 0x00, 0x22, 0x01, // m" (U+006D U+0022)
  0x00, 0x6D, 0x00, 0x27, 0x01, // m' (U+006D U+0027)
  0x00, 0x6E, 0x00, 0x22, 0x01, // n" (U+006E U+0022)
  0x00, 0x6E, 0x00, 0x27, 0x01, // n' (U+006E U+0027)
  0x00, 0x6F, 0x00, 0x56, 0x01, // oV (U+006F U+0056)
  0x00, 0x6F, 0x00, 0x57, 0x01, // oW (U+006F U+0057)
  0x00, 0x6F, 0x00, 0x59, 0x01, // oY (U+006F U+0059)
  0x00, 0x6F, 0x00, 0xDD, 0x01, // oÝ (U+006F U+00DD)
  0x00, 0x6F, 0x01, 0x74, 0x01, // oŴ (U+006F U+0174)
  0x00, 0x6F, 0x01, 0x76, 0x01, // oŶ (U+006F U+0176)
  0x00, 0x6F, 0x01, 0x78, 0x01, // oŸ (U+006F U+0178)
  0x00, 0x70, 0x00, 0x56, 0x01, // pV (U+0070 U+0056)
  0x00, 0x70, 0x00, 0x57, 0x01, // pW (U+0070 U+0057)
  0x00, 0x70, 0x00, 0x59, 0x01, // pY (U+0070 U+0059)
  0x00, 0x70, 0x00, 0xDD, 0x01, // pÝ (U+0070 U+00DD)
  0x00, 0x70, 0x01, 0x74, 0x01, // pŴ (U+0070 U+0174)
  0x00, 0x70, 0x01, 0x76, 0x01, // pŶ (U+0070 U+0176)
  0x00, 0x70, 0x01, 0x78, 0x01, // pŸ (U+0070 U+0178)
  0x00, 0x72, 0x00, 0x2C, 0x02, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x02, // r. (U+0072 U+002E)
  0x00, 0x72, 0x20, 0x1A, 0x02, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x02, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x02, // r… (U+0072 U+2026)
  0x00, 0x73, 0x00, 0x59, 0x01, // sY (U+0073 U+0059)
  0x00, 0x73, 0x00, 0xDD, 0x01, // sÝ (U+0073 U+00DD)
  0x00, 0x73, 0x01, 0x76, 0x01, // sŶ (U+0073 U+0176)
  0x00, 0x73, 0x01, 0x78, 0x01, // sŸ (U+0073 U+0178)
  0x00, 0x76, 0x00, 0x2C, 0x01, // v, (U+0076 U+002C)
  0x00, 0x76, 0x00, 0x2E, 0x01, // v. (U+0076 U+002E)
  0x00, 0x76, 0x00, 0x41, 0x01, // vA (U+0076 U+0041)
  0x00, 0x76, 0x00, 0xC0, 0x01, // vÀ (U+0076 U+00C0)
  0x00, 0x76, 0x00, 0xC1, 0x01, // vÁ (U+0076 U+00C1)
  0x00, 0x76, 0x00, 0xC2, 0x01, // vÂ (U+0076 U+00C2)
  0x00, 0x76, 0x00, 0xC3, 0x01, // vÃ (U+0076 U+00C3)
  0x00, 0x76, 0x00, 0xC4, 0x01, // vÄ (U+0076 U+00C4)
  0x00, 0x76, 0x00, 0xC5, 0x01, // vÅ (U+0076 U+00C5)
  0x00, 0x76, 0x01, 0x00, 0x01, // vĀ (U+0076 U+0100)
  0x00, 0x76, 0x01, 0x02, 0x01, // vĂ (U+0076 U+0102)
  0x00, 0x76, 0x01, 0x04, 0x01, // vĄ (U+0076 U+0104)
  0x00, 0x76, 0x20, 0x1A, 0x01, // v‚ (U+0076 U+201A)
  0x00, 0x76, 0x20, 0x1E, 0x01, // v„ (U+0076 U+201E)
  0x00, 0x76, 0x20, 0x26, 0x01, // v… (U+0076 U+2026)
  0x00, 0x77, 0x00, 0x2C, 0x01, // w, (U+0077 U+002C)
  0x00, 0x77, 0x00, 0x2E, 0x01, // w. (U+0077 U+002E)
  0x00, 0x77, 0x00, 0x41, 0x01, // wA (U+0077 U+0041)
  0x00, 0x77, 0x00, 0xC0, 0x01, // wÀ (U+0077 U+00C0)
  0x00, 0x77, 0x00, 0xC1, 0x01, // wÁ (U+0077 U+00C1)
  0x00, 0x77, 0x00, 0xC2, 0x01, // wÂ (U+0077 U+00C2)
  0x00, 0x77, 0x00, 0xC3, 0x01, // wÃ (U+0077 U+00C3)
  0x00, 0x77, 0x00, 0xC4, 0x01, // wÄ (U+0077 U+00C4)
  0x00, 0x77, 0x00, 0xC5, 0x01, // wÅ (U+0077 U+00C5)
  0x00, 0x77, 0x01, 0x00, 0x01, // wĀ (U+0077 U+0100)
  0x00, 0x77, 0x01, 0x02, 0x01, // wĂ (U+0077 U+0102)
  0x00, 0x77, 0x01, 0x04, 0x01, // wĄ (U+0077 U+0104)
  0x00, 0x77, 0x20, 0x1A, 0x01, // w‚ (U+0077 U+201A)
  0x00, 0x77, 0x20, 0x1E, 0x01, // w„ (U+0077 U+201E)
  0x00, 0x77, 0x20, 0x26, 0x01, // w… (U+0077 U+2026)
  0x00, 0x79, 0x00, 0x2C, 0x02, // y, (U+0079 U+002C)
  0x00, 0x79, 0x00, 0x2E, 0x02, // y. (U+0079 U+002E)
  0x00, 0x79, 0x00, 0x41, 0x01, // yA (U+0079 U+0041)
  0x00, 0x79, 0x00, 0xC0, 0x01, // yÀ (U+0079 U+00C0)
  0x00, 0x79, 0x00, 0xC1, 0x01, // yÁ (U+0079 U+00C1)
  0x00, 0x79, 0x00, 0xC2, 0x01, // yÂ (U+0079 U+00C2)
  0x00, 0x79, 0x00, 0xC3, 0x01, // yÃ (U+0079 U+00C3)
  0x00, 0x79, 0x00, 0xC4, 0x01, // yÄ (U+0079 U+00C4)
  0x00, 0x79, 0x00, 0xC5, 0x01, // yÅ (U+0079 U+00C5)
  0x00, 0x79, 0x01, 0x00, 0x01, // yĀ (U+0079 U+0100)
  0x00, 0x79, 0x01, 0x02, 0x01, // yĂ (U+0079 U+0102)
  0x00, 0x79, 0x01, 0x04, 0x01, // yĄ (U+0079 U+0104)
  0x00, 0x79, 0x20, 0x1A, 0x02, // y‚ (U+0079 U+201A)
  0x00, 0x79, 0x20, 0x1E, 0x02, // y„ (U+0079 U+201E)
  0x00, 0x79, 0x20, 0x26, 0x02, // y… (U+0079 U+2026)
  0x00, 0xA1, 0x00, 0x56, 0x01, // ¡V (U+00A1 U+0056)
  0x00, 0xA1, 0x00, 0x59, 0x01, // ¡Y (U+00A1 U+0059)
  0x00, 0xA1, 0x00, 0xDD, 0x01, // ¡Ý (U+00A1 U+00DD)
  0x00, 0xA1, 0x01, 0x76, 0x01, // ¡Ŷ (U+00A1 U+0176)
  0x00, 0xA1, 0x01, 0x78, 0x01, // ¡Ÿ (U+00A1 U+0178)
  0x00, 0xBF, 0x00, 0x56, 0x01, // ¿V (U+00BF U+0056)
  0x00, 0xBF, 0x00, 0x57, 0x01, // ¿W (U+00BF U+0057)
  0x00, 0xBF, 0x00, 0x59, 0x01, // ¿Y (U+00BF U+0059)
  0x00, 0xBF, 0x00, 0xDD, 0x01, // ¿Ý (U+00BF U+00DD)
  0x00, 0xBF, 0x01, 0x74, 0x01, // ¿Ŵ (U+00BF U+0174)
  0x00, 0xBF, 0x01, 0x76, 0x01, // ¿Ŷ (U+00BF U+0176)
  0x00, 0xBF, 0x01, 0x78, 0x01, // ¿Ÿ (U+00BF U+0178)
  0x00, 0xC0, 0x00, 0x22, 0x01, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x01, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x00, 0x2A, 0x01, // À* (U+00C0 U+002A)
  0x00, 0xC0, 0x00, 0x3F, 0x01, // À? (U+00C0 U+003F)
  0x00, 0xC0, 0x00, 0x54, 0x01, // ÀT (U+00C0 U+0054)
  0x00, 0xC0, 0x00, 0x56, 0x01, // ÀV (U+00C0 U+0056)
  0x00, 0xC0, 0x00, 0x57, 0x01, // ÀW (U+00C0 U+0057)
  0x00, 0xC0, 0x00, 0x59, 0x01, // ÀY (U+00C0 U+0059)
  0x00, 0xC0, 0x00, 0x76, 0x01, // Àv (U+00C0 U+0076)
  0x00, 0xC0, 0x00, 0x77, 0x01, // Àw (U+00C0 U+0077)
  0x00, 0xC0, 0x00, 0x79, 0x01, // Ày (U+00C0 U+0079)
  0x00, 0xC0, 0x00, 0xDD, 0x01, // ÀÝ (U+00C0 U+00DD)
  0x00, 0xC0, 0x00, 0xFD, 0x01, // Àý (U+00C0 U+00FD)
  0x00, 0xC0, 0x00, 0xFF, 0x01, // Àÿ (U+00C0 U+00FF)
  0x00, 0xC0, 0x01, 0x62, 0x01, // ÀŢ (U+00C0 U+0162)
  0x00, 0xC0, 0x01, 0x64, 0x01, // ÀŤ (U+00C0 U+0164)
  0x00, 0xC0, 0x01, 0x66, 0x01, // ÀŦ (U+00C0 U+0166)
  0x00, 0xC0, 0x01, 0x74, 0x01, // ÀŴ (U+00C0 U+0174)
  0x00, 0xC0, 0x01, 0x75, 0x01, // Àŵ (U+00C0 U+0175)
  0x00, 0xC0, 0x01, 0x76, 0x01, // ÀŶ (U+00C0 U+0176)
  0x00, 0xC0, 0x01, 0x77, 0x01, // Àŷ (U+00C0 U+0177)
  0x00, 0xC0, 0x01, 0x78, 0x01, // ÀŸ (U+00C0 U+0178)
  0x00, 0xC0, 0x20, 0x18, 0x01, // À‘ (U+00C0 U+2018)
  0x00, 0xC0, 0x20, 0x19, 0x01, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1C, 0x01, // À“ (U+00C0 U+201C)
  0x00, 0xC0, 0x20, 0x1D, 0x01, // À” (U+00C0 U+201D)
  0x00, 0xC0, 0x21, 0x22, 0x01, // À™ (U+00C0 U+2122)
  0x00, 0xC1, 0x00, 0x22, 0x01, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x01, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x00, 0x2A, 0x01, // Á* (U+00C1 U+002A)
  0x00, 0xC1, 0x00, 0x3F, 0x01, // Á? (U+00C1 U+003F)
  0x00, 0xC1, 0x00, 0x54, 0x01, // ÁT (U+00C1 U+0054)
  0x00, 0xC1, 0x00, 0x56, 0x01, // ÁV (U+00C1 U+0056)
  0x00, 0xC1, 0x00, 0x57, 0x01, // ÁW (U+00C1 U+0057)
  0x00, 0xC1, 0x00, 0x59, 0x01, // ÁY (U+00C1 U+0059)
  0x00, 0xC1, 0x00, 0x76, 0x01, // Áv (U+00C1 U+0076)
  0x00, 0xC1, 0x00, 0x77, 0x01, // Áw (U+00C1 U+0077)
  0x00, 0xC1, 0x00, 0x79, 0x01, // Áy (U+00C1 U+0079)
  0x00, 0xC1, 0x00, 0xDD, 0x01, // ÁÝ (U+00C1 U+00DD)
  0x00, 0xC1, 0x00, 0xFD, 0x01, // Áý (U+00C1 U+00FD)
  0x00, 0xC1, 0x00, 0xFF, 0x01, // Áÿ (U+00C1 U+00FF)
  0x00, 0xC1, 0x01, 0x62, 0x01, // ÁŢ (U+00C1 U+0162)
  0x00, 0xC1, 0x01, 0x64, 0x01, // ÁŤ (U+00C1 U+0164)
  0x00, 0xC1, 0x01, 0x66, 0x01, // ÁŦ (U+00C1 U+0166)
  0x00, 0xC1, 0x01, 0x74, 0x01, // ÁŴ (U+00C1 U+0174)
  0x00, 0xC1, 0x01, 0x75, 0x01, // Áŵ (U+00C1 U+0175)
  0x00, 0xC1, 0x01, 0x76, 0x01, // ÁŶ (U+00C1 U+0176)
  0x00, 0xC1, 0x01, 0x77, 0x01, // Áŷ (U+00C1 U+0177)
  0x00, 0xC1, 0x01, 0x78, 0x01, // ÁŸ (U+00C1 U+0178)
  0x00, 0xC1, 0x20, 0x18, 0x01, // Á‘ (U+00C1 U+2018)
  0x00, 0xC1, 0x20, 0x19, 0x01, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1C, 0x01, // Á“ (U+00C1 U+201C)
  0x00, 0xC1, 0x20, 0x1D, 0x01, // Á” (U+00C1 U+201D)
  0x00, 0xC1, 0x21, 0x22, 0x01, // Á™ (U+00C1 U+2122)
  0x00, 0xC2, 0x00, 0x22, 0x01, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x01, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x00, 0x2A, 0x01, // Â* (U+00C2 U+002A)
  0x00, 0xC2, 0x00, 0x3F, 0x01, // Â? (U+00C2 U+003F)
  0x00, 0xC2, 0x00, 0x54, 0x01, // ÂT (U+00C2 U+0054)
  0x00, 0xC2, 0x00, 0x56, 0x01, // ÂV (U+00C2 U+0056)
  0x00, 0xC2, 0x00, 0x57, 0x01, // ÂW (U+00C2 U+0057)
  0x00, 0xC2, 0x00, 0x59, 0x01, // ÂY (U+00C2 U+0059)
  0x00, 0xC2, 0x00, 0x76, 0x01, // Âv (U+00C2 U+0076)
  0x00, 0xC2, 0x00, 0x77, 0x01, // Âw (U+00C2 U+0077)
  0x00, 0xC2, 0x00, 0x79, 0x01, // Ây (U+00C2 U+0079)
  0x00, 0xC2, 0x00, 0xDD, 0x01, // ÂÝ (U+00C2 U+00DD)
  0x00, 0xC2, 0x00, 0xFD, 0x01, // Âý (U+00C2 U+00FD)
  0x00, 0xC2, 0x00, 0xFF, 0x01, // Âÿ (U+00C2 U+00FF)
  0x00, 0xC2, 0x01, 0x62, 0x01, // ÂŢ (U+00C2 U+0162)
  0x00, 0xC2, 0x01, 0x64, 0x01, // ÂŤ (U+00C2 U+0164)
  0x00, 0xC2, 0x01, 0x66, 0x01, // ÂŦ (U+00C2 U+0166)
  0x00, 0xC2, 0x01, 0x74, 0x01, // ÂŴ (U+00C2 U+0174)
  0x00, 0xC2, 0x01, 0x75, 0x01, // Âŵ (U+00C2 U+0175)
  0x00, 0xC2, 0x01, 0x76, 0x01, // ÂŶ (U+00C2 U+0176)
  0x00, 0xC2, 0x01, 0x77, 0x01, // Âŷ (U+00C2 U+0177)
  0x00, 0xC2, 0x01, 0x78, 0x01, // ÂŸ (U+00C2 U+0178)
  0x00, 0xC2, 0x20, 0x18, 0x01, // Â‘ (U+00C2 U+2018)
  0x00, 0xC2, 0x20, 0x19, 0x01, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1C, 0x01, // Â“ (U+00C2 U+201C)
  0x00, 0xC2, 0x20, 0x1D, 0x01, // Â” (U+00C2 U+201D)
  0x00, 0xC2, 0x21, 0x22, 0x01, // Â™ (U+00C2 U+2122)
  0x00, 0xC3, 0x00, 0x22, 0x01, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x01, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x00, 0x2A, 0x01, // Ã* (U+00C3 U+002A)
  0x00, 0xC3, 0x00, 0x3F, 0x01, // Ã? (U+00C3 U+003F)
  0x00, 0xC3, 0x00, 0x54, 0x01, // ÃT (U+00C3 U+0054)
  0x00, 0xC3, 0x00, 0x56, 0x01, // ÃV (U+00C3 U+0056)
  0x00, 0xC3, 0x00, 0x57, 0x01, // ÃW (U+00C3 U+0057)
  0x00, 0xC3, 0x00, 0x59, 0x01, // ÃY (U+00C3 U+0059)
  0x00, 0xC3, 0x00, 0x76, 0x01, // Ãv (U+00C3 U+0076)
  0x00, 0xC3, 0x00, 0x77, 0x01, // Ãw (U+00C3 U+0077)
  0x00, 0xC3, 0x00, 0x79, 0x01, // Ãy (U+00C3 U+0079)
  0x00, 0xC3, 0x00, 0xDD, 0x01, // ÃÝ (U+00C3 U+00DD)
  0x00, 0xC3, 0x00, 0xFD, 0x01, // Ãý (U+00C3 U+00FD)
  0x00, 0xC3, 0x00, 0xFF, 0x01, // Ãÿ (U+00C3 U+00FF)
  0x00, 0xC3, 0x01, 0x62, 0x01, // ÃŢ (U+00C3 U+0162)
  0x00, 0xC3, 0x01, 0x64, 0x01, // ÃŤ (U+00C3 U+0164)
  0x00, 0xC3, 0x01, 0x66, 0x01, // ÃŦ (U+00C3 U+0166)
  0x00, 0xC3, 0x01, 0x74, 0x01, // ÃŴ (U+00C3 U+0174)
  0x00, 0xC3, 0x01, 0x75, 0x01, // Ãŵ (U+00C3 U+0175)
  0x00, 0xC3, 0x01, 0x76, 0x01, // ÃŶ (U+00C3 U+0176)
  0x00, 0xC3, 0x01, 0x77, 0x01, // Ãŷ (U+00C3 U+0177)
  0x00, 0xC3, 0x01, 0x78, 0x01, // ÃŸ (U+00C3 U+0178)
  0x00, 0xC3, 0x20, 0x18, 0x01, // Ã‘ (U+00C3 U+2018)
  0x00, 0xC3, 0x20, 0x19, 0x01, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1C, 0x01, // Ã“ (U+00C3 U+201C)
  0x00, 0xC3, 0x20, 0x1D, 0x01, // Ã” (U+00C3 U+201D)
  0x00, 0xC3, 0x21, 0x22, 0x01, // Ã™ (U+00C3 U+2122)
  0x00, 0xC4, 0x00, 0x22, 0x01, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x01, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x00, 0x2A, 0x01, // Ä* (U+00C4 U+002A)
  0x00, 0xC4, 0x00, 0x3F, 0x01, // Ä? (U+00C4 U+003F)
  0x00, 0xC4, 0x00, 0x54, 0x01, // ÄT (U+00C4 U+0054)
  0x00, 0xC4, 0x00, 0x56, 0x01, // ÄV (U+00C4 U+0056)
  0x00, 0xC4, 0x00, 0x57, 0x01, // ÄW (U+00C4 U+0057)
  0x00, 0xC4, 0x00, 0x59, 0x01, // ÄY (U+00C4 U+0059)
  0x00, 0xC4, 0x00, 0x76, 0x01, // Äv (U+00C4 U+0076)
  0x00, 0xC4, 0x00, 0x77, 0x01, // Äw (U+00C4 U+0077)
  0x00, 0xC4, 0x00, 0x79, 0x01, // Äy (U+00C4 U+0079)
  0x00, 0xC4, 0x00, 0xDD, 0x01, // ÄÝ (U+00C4 U+00DD)
  0x00, 0xC4, 0x00, 0xFD, 0x01, // Äý (U+00C4 U+00FD)
  0x00, 0xC4, 0x00, 0xFF, 0x01, // Äÿ (U+00C4 U+00FF)
  0x00, 0xC4, 0x01, 0x62, 0x01, // ÄŢ (U+00C4 U+0162)
  0x00, 0xC4, 0x01, 0x64, 0x01, // ÄŤ (U+00C4 U+0164)
  0x00, 0xC4, 0x01, 0x66, 0x01, // ÄŦ (U+00C4 U+0166)
  0x00, 0xC4, 0x01, 0x74, 0x01, // ÄŴ (U+00C4 U+0174)
  0x00, 0xC4, 0x01, 0x75, 0x01, // Äŵ (U+00C4 U+0175)
  0x00, 0xC4, 0x01, 0x76, 0x01, // ÄŶ (U+00C4 U+0176)
  0x00, 0xC4, 0x01, 0x77, 0x01, // Äŷ (U+00C4 U+0177)
  0x00, 0xC4, 0x01, 0x78, 0x01, // ÄŸ (U+00C4 U+0178)
  0x00, 0xC4, 0x20, 0x18, 0x01, // Ä‘ (U+00C4 U+2018)
  0x00, 0xC4, 0x20, 0x19, 0x01, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1C, 0x01, // Ä“ (U+00C4 U+201C)
  0x00, 0xC4, 0x20, 0x1D, 0x01, // Ä” (U+00C4 U+201D)
  0x00, 0xC4, 0x21, 0x22, 0x01, // Ä™ (U+00C4 U+2122)
  0x00, 0xC5, 0x00, 0x22, 0x01, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x01, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x00, 0x2A, 0x01, // Å* (U+00C5 U+002A)
  0x00, 0xC5, 0x00, 0x3F, 0x01, // Å? (U+00C5 U+003F)
  0x00, 0xC5, 0x00, 0x54, 0x01, // ÅT (U+00C5 U+0054)
  0x00, 0xC5, 0x00, 0x56, 0x01, // ÅV (U+00C5 U+0056)
  0x00, 0xC5, 0x00, 0x57, 0x01, // ÅW (U+00C5 U+0057)
  0x00, 0xC5, 0x00, 0x59, 0x01, // ÅY (U+00C5 U+0059)
  0x00, 0xC5, 0x00, 0x76, 0x01, // Åv (U+00C5 U+0076)
  0x00, 0xC5, 0x00, 0x77, 0x01, // Åw (U+00C5 U+0077)
  0x00, 0xC5, 0x00, 0x79, 0x01, // Åy (U+00C5 U+0079)
  0x00, 0xC5, 0x00, 0xDD, 0x01, // ÅÝ (U+00C5 U+00DD)
  0x00, 0xC5, 0x00, 0xFD, 0x01, // Åý (U+00C5 U+00FD)
  0x00, 0xC5, 0x00, 0xFF, 0x01, // Åÿ (U+00C5 U+00FF)
  0x00, 0xC5, 0x01, 0x62, 0x01, // ÅŢ (U+00C5 U+0162)
  0x00, 0xC5, 0x01, 0x64, 0x01, // ÅŤ (U+00C5 U+0164)
  0x00, 0xC5, 0x01, 0x66, 0x01, // ÅŦ (U+00C5 U+0166)
  0x00, 0xC5, 0x01, 0x74, 0x01, // ÅŴ (U+00C5 U+0174)
  0x00, 0xC5, 0x01, 0x75, 0x01, // Åŵ (U+00C5 U+0175)
  0x00, 0xC5, 0x01, 0x76, 0x01, // ÅŶ (U+00C5 U+0176)
  0x00, 0xC5, 0x01, 0x77, 0x01, // Åŷ (U+00C5 U+0177)
  0x00, 0xC5, 0x01, 0x78, 0x01, // ÅŸ (U+00C5 U+0178)
  0x00, 0xC5, 0x20, 0x18, 0x01, // Å‘ (U+00C5 U+2018)
  0x00, 0xC5, 0x20, 0x19, 0x01, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1C, 0x01, // Å“ (U+00C5 U+201C)
  0x00, 0xC5, 0x20, 0x1D, 0x01, // Å” (U+00C5 U+201D)
  0x00, 0xC5, 0x21, 0x22, 0x01, // Å™ (U+00C5 U+2122)
  0x00, 0xD0, 0x00, 0x59, 0x01, // ÐY (U+00D0 U+0059)
  0x00, 0xD0, 0x00, 0xC6, 0x01, // ÐÆ (U+00D0 U+00C6)
  0x00, 0xD0, 0x00, 0xDD, 0x01, // ÐÝ (U+00D0 U+00DD)
  0x00, 0xD0, 0x01, 0x76, 0x01, // ÐŶ (U+00D0 U+0176)
  0x00, 0xD0, 0x01, 0x78, 0x01, // ÐŸ (U+00D0 U+0178)
  0x00, 0xD2, 0x00, 0x59, 0x01, // ÒY (U+00D2 U+0059)
  0x00, 0xD2, 0x00, 0xC6, 0x01, // ÒÆ (U+00D2 U+00C6)
  0x00, 0xD2, 0x00, 0xDD, 0x01, // ÒÝ (U+00D2 U+00DD)
  0x00, 0xD2, 0x01, 0x76, 0x01, // ÒŶ (U+00D2 U+0176)
  0x00, 0xD2, 0x01, 0x78, 0x01, // ÒŸ (U+00D2 U+0178)
  0x00, 0xD3, 0x00, 0x59, 0x01, // ÓY (U+00D3 U+0059)
  0x00, 0xD3, 0x00, 0xC6, 0x01, // ÓÆ (U+00D3 U+00C6)
  0x00, 0xD3, 0x00, 0xDD, 0x01, // ÓÝ (U+00D3 U+00DD)
  0x00, 0xD3, 0x01, 0x76, 0x01, // ÓŶ (U+00D3 U+0176)
  0x00, 0xD3, 0x01, 0x78, 0x01, // ÓŸ (U+00D3 U+0178)
  0x00, 0xD4, 0x00, 0x59, 0x01, // ÔY (U+00D4 U+0059)
  0x00, 0xD4, 0x00, 0xC6, 0x01, // ÔÆ (U+00D4 U+00C6)
  0x00, 0xD4, 0x00, 0xDD, 0x01, // ÔÝ (U+00D4 U+00DD)
  0x00, 0xD4, 0x01, 0x76, 0x01, // ÔŶ (U+00D4 U+0176)
  0x00, 0xD4, 0x01, 0x78, 0x01, // ÔŸ (U+00D4 U+0178)
  0x00, 0xD5, 0x00, 0x59, 0x01, // ÕY (U+00D5 U+0059)
  0x00, 0xD5, 0x00, 0xC6, 0x01, // ÕÆ (U+00D5 U+00C6)
  0x00, 0xD5, 0x00, 0xDD, 0x01, // ÕÝ (U+00D5 U+00DD)
  0x00, 0xD5, 0x01, 0x76, 0x01, // ÕŶ (U+00D5 U+0176)
  0x00, 0xD5, 0x01, 0x78, 0x01, // ÕŸ (U+00D5 U+0178)
  0x00, 0xD6, 0x00, 0x59, 0x01, // ÖY (U+00D6 U+0059)
  0x00, 0xD6, 0x00, 0xC6, 0x01, // ÖÆ (U+00D6 U+00C6)
  0x00, 0xD6, 0x00, 0xDD, 0x01, // ÖÝ (U+00D6 U+00DD)
  0x00, 0xD6, 0x01, 0x76, 0x01, // ÖŶ (U+00D6 U+0176)
  0x00, 0xD6, 0x01, 0x78, 0x01, // ÖŸ (U+00D6 U+0178)
  0x00, 0xD8, 0x00, 0x59, 0x01, // ØY (U+00D8 U+0059)
  0x00, 0xD8, 0x00, 0xC6, 0x01, // ØÆ (U+00D8 U+00C6)
  0x00, 0xD8, 0x00, 0xDD, 0x01, // ØÝ (U+00D8 U+00DD)
  0x00, 0xD8, 0x01, 0x76, 0x01, // ØŶ (U+00D8 U+0176)
  0x00, 0xD8, 0x01, 0x78, 0x01, // ØŸ (U+00D8 U+0178)
  0x00, 0xD9, 0x00, 0xC6, 0x01, // ÙÆ (U+00D9 U+00C6)
  0x00, 0xDA, 0x00, 0xC6, 0x01, // ÚÆ (U+00DA U+00C6)
  0x00, 0xDB, 0x00, 0xC6, 0x01, // ÛÆ (U+00DB U+00C6)
  0x00, 0xDC, 0x00, 0xC6, 0x01, // ÜÆ (U+00DC U+00C6)
  0x00, 0xDD, 0x00, 0x2C, 0x01, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x01, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x00, 0x40, 0x01, // Ý@ (U+00DD U+0040)
  0x00, 0xDD, 0x00, 0x41, 0x01, // ÝA (U+00DD U+0041)
  0x00, 0xDD, 0x00, 0x43, 0x01, // ÝC (U+00DD U+0043)
  0x00, 0xDD, 0x00, 0x47, 0x01, // ÝG (U+00DD U+0047)
  0x00, 0xDD, 0x00, 0x4F, 0x01, // ÝO (U+00DD U+004F)
  0x00, 0xDD, 0x00, 0x51, 0x01, // ÝQ (U+00DD U+0051)
  0x00, 0xDD, 0x00, 0x61, 0x01, // Ýa (U+00DD U+0061)
  0x00, 0xDD, 0x00, 0x63, 0x01, // Ýc (U+00DD U+0063)
  0x00, 0xDD, 0x00, 0x64, 0x01, // Ýd (U+00DD U+0064)
  0x00, 0xDD, 0x00, 0x65, 0x01, // Ýe (U+00DD U+0065)
  0x00, 0xDD, 0x00, 0x67, 0x01, // Ýg (U+00DD U+0067)
  0x00, 0xDD, 0x00, 0x6F, 0x01, // Ýo (U+00DD U+006F)
  0x00, 0xDD, 0x00, 0x71, 0x01, // Ýq (U+00DD U+0071)
  0x00, 0xDD, 0x00, 0x73, 0x01, // Ýs (U+00DD U+0073)
  0x00, 0xDD, 0x00, 0xC0, 0x01, // ÝÀ (U+00DD U+00C0)
  0x00, 0xDD, 0x00, 0xC1, 0x01, // ÝÁ (U+00DD U+00C1)
  0x00, 0xDD, 0x00, 0xC2, 0x01, // ÝÂ (U+00DD U+00C2)
  0x00, 0xDD, 0x00, 0xC3, 0x01, // ÝÃ (U+00DD U+00C3)
  0x00, 0xDD, 0x00, 0xC4, 0x01, // ÝÄ (U+00DD U+00C4)
  0x00, 0xDD, 0x00, 0xC5, 0x01, // ÝÅ (U+00DD U+00C5)
  0x00, 0xDD, 0x00, 0xC6, 0x02, // ÝÆ (U+00DD U+00C6)
  0x00, 0xDD, 0x00, 0xC7, 0x01, // ÝÇ (U+00DD U+00C7)
  0x00, 0xDD, 0x00, 0xD2, 0x01, // ÝÒ (U+00DD U+00D2)
  0x00, 0xDD, 0x00, 0xD3, 0x01, // ÝÓ (U+00DD U+00D3)
  0x00, 0xDD, 0x00, 0xD4, 0x01, // ÝÔ (U+00DD U+00D4)
  0x00, 0xDD, 0x00, 0xD5, 0x01, // ÝÕ (U+00DD U+00D5)
  0x00, 0xDD, 0x00, 0xD6, 0x01, // ÝÖ (U+00DD U+00D6)
  0x00, 0xDD, 0x00, 0xD8, 0x01, // ÝØ (U+00DD U+00D8)
  0x00, 0xDD, 0x00, 0xE0, 0x01, // Ýà (U+00DD U+00E0)
  0x00, 0xDD, 0x00, 0xE1, 0x01, // Ýá (U+00DD U+00E1)
  0x00, 0xDD, 0x00, 0xE2, 0x01, // Ýâ (U+00DD U+00E2)
  0x00, 0xDD, 0x00, 0xE3, 0x01, // Ýã (U+00DD U+00E3)
  0x00, 0xDD, 0x00, 0xE4, 0x01, // Ýä (U+00DD U+00E4)
  0x00, 0xDD, 0x00, 0xE5, 0x01, // Ýå (U+00DD U+00E5)
  0x00, 0xDD, 0x00, 0xE6, 0x01, // Ýæ (U+00DD U+00E6)
  0x00, 0xDD, 0x00, 0xE7, 0x01, // Ýç (U+00DD U+00E7)
  0x00, 0xDD, 0x00, 0xE8, 0x01, // Ýè (U+00DD U+00E8)
  0x00, 0xDD, 0x00, 0xE9, 0x01, // Ýé (U+00DD U+00E9)
  0x00, 0xDD, 0x00, 0xEA, 0x01, // Ýê (U+00DD U+00EA)
  0x00, 0xDD, 0x00, 0xEB, 0x01, // Ýë (U+00DD U+00EB)
  0x00, 0xDD, 0x00, 0xF0, 0x01, // Ýð (U+00DD U+00F0)
  0x00, 0xDD, 0x00, 0xF2, 0x01, // Ýò (U+00DD U+00F2)
  0x00, 0xDD, 0x00, 0xF3, 0x01, // Ýó (U+00DD U+00F3)
  0x00, 0xDD, 0x00, 0xF4, 0x01, // Ýô (U+00DD U+00F4)
  0x00, 0xDD, 0x00, 0xF5, 0x01, // Ýõ (U+00DD U+00F5)
  0x00, 0xDD, 0x00, 0xF6, 0x01, // Ýö (U+00DD U+00F6)
  0x00, 0xDD, 0x00, 0xF8, 0x01, // Ýø (U+00DD U+00F8)
  0x00, 0xDD, 0x01, 0x00, 0x01, // ÝĀ (U+00DD U+0100)
  0x00, 0xDD, 0x01, 0x01, 0x01, // Ýā (U+00DD U+0101)
  0x00, 0xDD, 0x01, 0x02, 0x01, // ÝĂ (U+00DD U+0102)
  0x00, 0xDD, 0x01, 0x03, 0x01, // Ýă (U+00DD U+0103)
  0x00, 0xDD, 0x01, 0x04, 0x01, // ÝĄ (U+00DD U+0104)
  0x00, 0xDD, 0x01, 0x05, 0x01, // Ýą (U+00DD U+0105)
  0x00, 0xDD, 0x01, 0x06, 0x01, // ÝĆ (U+00DD U+0106)
  0x00, 0xDD, 0x01, 0x07, 0x01, // Ýć (U+00DD U+0107)
  0x00, 0xDD, 0x01, 0x08, 0x01, // ÝĈ (U+00DD U+0108)
  0x00, 0xDD, 0x01, 0x09, 0x01, // Ýĉ (U+00DD U+0109)
  0x00, 0xDD, 0x01, 0x0A, 0x01, // ÝĊ (U+00DD U+010A)
  0x00, 0xDD, 0x01, 0x0B, 0x01, // Ýċ (U+00DD U+010B)
  0x00, 0xDD, 0x01, 0x0C, 0x01, // ÝČ (U+00DD U+010C)
  0x00, 0xDD, 0x01, 0x0D, 0x01, // Ýč (U+00DD U+010D)
  0x00, 0xDD, 0x01, 0x0F, 0x01, // Ýď (U+00DD U+010F)
  0x00, 0xDD, 0x01, 0x11, 0x01, // Ýđ (U+00DD U+0111)
  0x00, 0xDD, 0x01, 0x13, 0x01, // Ýē (U+00DD U+0113)
  0x00, 0xDD, 0x01, 0x15, 0x01, // Ýĕ (U+00DD U+0115)
  0x00, 0xDD, 0x01, 0x17, 0x01, // Ýė (U+00DD U+0117)
  0x00, 0xDD, 0x01, 0x19, 0x01, // Ýę (U+00DD U+0119)
  0x00, 0xDD, 0x01, 0x1B, 0x01, // Ýě (U+00DD U+011B)
  0x00, 0xDD, 0x01, 0x1C, 0x01, // ÝĜ (U+00DD U+011C)
  0x00, 0xDD, 0x01, 0x1D, 0x01, // Ýĝ (U+00DD U+011D)
  0x00, 0xDD, 0x01, 0x1E, 0x01, // ÝĞ (U+00DD U+011E)
  0x00, 0xDD, 0x01, 0x1F, 0x01, // Ýğ (U+00DD U+011F)
  0x00, 0xDD, 0x01, 0x20, 0x01, // ÝĠ (U+00DD U+0120)
  0x00, 0xDD, 0x01, 0x21, 0x01, // Ýġ (U+00DD U+0121)
  0x00, 0xDD, 0x01, 0x22, 0x01, // ÝĢ (U+00DD U+0122)
  0x00, 0xDD, 0x01, 0x23, 0x01, // Ýģ (U+00DD U+0123)
  0x00, 0xDD, 0x01, 0x4C, 0x01, // ÝŌ (U+00DD U+014C)
  0x00, 0xDD, 0x01, 0x4D, 0x01, // Ýō (U+00DD U+014D)
  0x00, 0xDD, 0x01, 0x4E, 0x01, // ÝŎ (U+00DD U+014E)
  0x00, 0xDD, 0x01, 0x4F, 0x01, // Ýŏ (U+00DD U+014F)
  0x00, 0xDD, 0x01, 0x50, 0x01, // ÝŐ (U+00DD U+0150)
  0x00, 0xDD, 0x01, 0x51, 0x01, // Ýő (U+00DD U+0151)
  0x00, 0xDD, 0x01, 0x52, 0x01, // ÝŒ (U+00DD U+0152)
  0x00, 0xDD, 0x01, 0x53, 0x01, // Ýœ (U+00DD U+0153)
  0x00, 0xDD, 0x01, 0x5B, 0x01, // Ýś (U+00DD U+015B)
  0x00, 0xDD, 0x01, 0x5D, 0x01, // Ýŝ (U+00DD U+015D)
  0x00, 0xDD, 0x01, 0x5F, 0x01, // Ýş (U+00DD U+015F)
  0x00, 0xDD, 0x01, 0x61, 0x01, // Ýš (U+00DD U+0161)
  0x00, 0xDD, 0x20, 0x1A, 0x01, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x01, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x01, // Ý… (U+00DD U+2026)
  0x00, 0xDE, 0x00, 0x59, 0x01, // ÞY (U+00DE U+0059)
  0x00, 0xDE, 0x00, 0xC6, 0x01, // ÞÆ (U+00DE U+00C6)
  0x00, 0xDE, 0x00, 0xDD, 0x01, // ÞÝ (U+00DE U+00DD)
  0x00, 0xDE, 0x01, 0x76, 0x01, // ÞŶ (U+00DE U+0176)
  0x00, 0xDE, 0x01, 0x78, 0x01, // ÞŸ (U+00DE U+0178)
  0x00, 0xDF, 0x00, 0x56, 0x01, // ßV (U+00DF U+0056)
  0x00, 0xDF, 0x00, 0x57, 0x01, // ßW (U+00DF U+0057)
  0x00, 0xDF, 0x00, 0x59, 0x01, // ßY (U+00DF U+0059)
  0x00, 0xDF, 0x00, 0xDD, 0x01, // ßÝ (U+00DF U+00DD)
  0x00, 0xDF, 0x01, 0x74, 0x01, // ßŴ (U+00DF U+0174)
  0x00, 0xDF, 0x01, 0x76, 0x01, // ßŶ (U+00DF U+0176)
  0x00, 0xDF, 0x01, 0x78, 0x01, // ßŸ (U+00DF U+0178)
  0x00, 0xE0, 0x00, 0x22, 0x01, // à" (U+00E0 U+0022)
  0x00, 0xE0, 0x00, 0x27, 0x01, // à' (U+00E0 U+0027)
  0x00, 0xE1, 0x00, 0x22, 0x01, // á" (U+00E1 U+0022)
  0x00, 0xE1, 0x00, 0x27, 0x01, // á' (U+00E1 U+0027)
  0x00, 0xE2, 0x00, 0x22, 0x01, // â" (U+00E2 U+0022)
  0x00, 0xE2, 0x00, 0x27, 0x01, // â' (U+00E2 U+0027)
  0x00, 0xE3, 0x00, 0x22, 0x01, // ã" (U+00E3 U+0022)
  0x00, 0xE3, 0x00, 0x27, 0x01, // ã' (U+00E3 U+0027)
  0x00, 0xE4, 0x00, 0x22, 0x01, // ä" (U+00E4 U+0022)
  0x00, 0xE4, 0x00, 0x27, 0x01, // ä' (U+00E4 U+0027)
  0x00, 0xE5, 0x00, 0x22, 0x01, // å" (U+00E5 U+0022)
  0x00, 0xE5, 0x00, 0x27, 0x01, // å' (U+00E5 U+0027)
  0x00, 0xE6, 0x00, 0x56, 0x01, // æV (U+00E6 U+0056)
  0x00, 0xE6, 0x00, 0x57, 0x01, // æW (U+00E6 U+0057)
  0x00, 0xE6, 0x00, 0x59, 0x01, // æY (U+00E6 U+0059)
  0x00, 0xE6, 0x00, 0xDD, 0x01, // æÝ (U+00E6 U+00DD)
  0x00, 0xE6, 0x01, 0x74, 0x01, // æŴ (U+00E6 U+0174)
  0x00, 0xE6, 0x01, 0x76, 0x01, // æŶ (U+00E6 U+0176)
  0x00, 0xE6, 0x01, 0x78, 0x01, // æŸ (U+00E6 U+0178)
  0x00, 0xE8, 0x00, 0x56, 0x01, // èV (U+00E8 U+0056)
  0x00, 0xE8, 0x00, 0x57, 0x01, // èW (U+00E8 U+0057)
  0x00, 0xE8, 0x00, 0x59, 0x01, // èY (U+00E8 U+0059)
  0x00, 0xE8, 0x00, 0xDD, 0x01, // èÝ (U+00E8 U+00DD)
  0x00, 0xE8, 0x01, 0x74, 0x01, // èŴ (U+00E8 U+0174)
  0x00, 0xE8, 0x01, 0x76, 0x01, // èŶ (U+00E8 U+0176)
  0x00, 0xE8, 0x01, 0x78, 0x01, // èŸ (U+00E8 U+0178)
  0x00, 0xE9, 0x00, 0x56, 0x01, // éV (U+00E9 U+0056)
  0x00, 0xE9, 0x00, 0x57, 0x01, // éW (U+00E9 U+0057)
  0x00, 0xE9, 0x00, 0x59, 0x01, // éY (U+00E9 U+0059)
  0x00, 0xE9, 0x00, 0xDD, 0x01, // éÝ (U+00E9 U+00DD)
  0x00, 0xE9, 0x01, 0x74, 0x01, // éŴ (U+00E9 U+0174)
  0x00, 0xE9, 0x01, 0x76, 0x01, // éŶ (U+00E9 U+0176)
  0x00, 0xE9, 0x01, 0x78, 0x01, // éŸ (U+00E9 U+0178)
  0x00, 0xEA, 0x00, 0x56, 0x01, // êV (U+00EA U+0056)
  0x00, 0xEA, 0x00, 0x57, 0x01, // êW (U+00EA U+0057)
  0x00, 0xEA, 0x00, 0x59, 0x01, // êY (U+00EA U+0059)
  0x00, 0xEA, 0x00, 0xDD, 0x01, // êÝ (U+00EA U+00DD)
  0x00, 0xEA, 0x01, 0x74, 0x01, // êŴ (U+00EA U+0174)
  0x00, 0xEA, 0x01, 0x76, 0x01, // êŶ (U+00EA U+0176)
  0x00, 0xEA, 0x01, 0x78, 0x01, // êŸ (U+00EA U+0178)
  0x00, 0xEB, 0x00, 0x56, 0x01, // ëV (U+00EB U+0056)
  0x00, 0xEB, 0x00, 0x57, 0x01, // ëW (U+00EB U+0057)
  0x00, 0xEB, 0x00, 0x59, 0x01, // ëY (U+00EB U+0059)
  0x00, 0xEB, 0x00, 0xDD, 0x01, // ëÝ (U+00EB U+00DD)
  0x00, 0xEB, 0x01, 0x74, 0x01, // ëŴ (U+00EB U+0174)
  0x00, 0xEB, 0x01, 0x76, 0x01, // ëŶ (U+00EB U+0176)
  0x00, 0xEB, 0x01, 0x78, 0x01, // ëŸ (U+00EB U+0178)
  0x00, 0xF0, 0x00, 0x56, 0x01, // ðV (U+00F0 U+0056)
  0x00, 0xF0, 0x00, 0x57, 0x01, // ðW (U+00F0 U+0057)
  0x00, 0xF0, 0x00, 0x59, 0x01, // ðY (U+00F0 U+0059)
  0x00, 0xF0, 0x00, 0xDD, 0x01, // ðÝ (U+00F0 U+00DD)
  0x00, 0xF0, 0x01, 0x74, 0x01, // ðŴ (U+00F0 U+0174)
  0x00, 0xF0, 0x01, 0x76, 0x01, // ðŶ (U+00F0 U+0176)
  0x00, 0xF0, 0x01, 0x78, 0x01, // ðŸ (U+00F0 U+0178)
  0x00, 0xF1, 0x00, 0x22, 0x01, // ñ" (U+00F1 U+0022)
  0x00, 0xF1, 0x00, 0x27, 0x01, // ñ' (U+00F1 U+0027)
  0x00, 0xF2, 0x00, 0x56, 0x01, // òV (U+00F2 U+0056)
  0x00, 0xF2, 0x00, 0x57, 0x01, // òW (U+00F2 U+0057)
  0x00, 0xF2, 0x00, 0x59, 0x01, // òY (U+00F2 U+0059)
  0x00, 0xF2, 0x00, 0xDD, 0x01, // òÝ (U+00F2 U+00DD)
  0x00, 0xF2, 0x01, 0x74, 0x01, // òŴ (U+00F2 U+0174)
  0x00, 0xF2, 0x01, 0x76, 0x01, // òŶ (U+00F2 U+0176)
  0x00, 0xF2, 0x01, 0x78, 0x01, // òŸ (U+00F2 U+0178)
  0x00, 0xF3, 0x00, 0x56, 0x01, // óV (U+00F3 U+0056)
  0x00, 0xF3, 0x00, 0x57, 0x01, // óW (U+00F3 U+0057)
  0x00, 0xF3, 0x00, 0x59, 0x01, // óY (U+00F3 U+0059)
  0x00, 0xF3, 0x00, 0xDD, 0x01, // óÝ (U+00F3 U+00DD)
  0x00, 0xF3, 0x01, 0x74, 0x01, // óŴ (U+00F3 U+0174)
  0x00, 0xF3, 0x01, 0x76, 0x01, // óŶ (U+00F3 U+0176)
  0x00, 0xF3, 0x01, 0x78, 0x01, // óŸ (U+00F3 U+0178)
  0x00, 0xF4, 0x00, 0x56, 0x01, // ôV (U+00F4 U+0056)
  0x00, 0xF4, 0x00, 0x57, 0x01, // ôW (U+00F4 U+0057)
  0x00, 0xF4, 0x00, 0x59, 0x01, // ôY (U+00F4 U+0059)
  0x00, 0xF4, 0x00, 0xDD, 0x01, // ôÝ (U+00F4 U+00DD)
  0x00, 0xF4, 0x01, 0x74, 0x01, // ôŴ (U+00F4 U+0174)
  0x00, 0xF4, 0x01, 0x76, 0x01, // ôŶ (U+00F4 U+0176)
  0x00, 0xF4, 0x01, 0x78, 0x01, // ôŸ (U+00F4 U+0178)
  0x00, 0xF5, 0x00, 0x56, 0x01, // õV (U+00F5 U+0056)
  0x00, 0xF5, 0x00, 0x57, 0x01, // õW (U+00F5 U+0057)
  0x00, 0xF5, 0x00, 0x59, 0x01, // õY (U+00F5 U+0059)
  0x00, 0xF5, 0x00, 0xDD, 0x01, // õÝ (U+00F5 U+00DD)
  0x00, 0xF5, 0x01, 0x74, 0x01, // õŴ (U+00F5 U+0174)
  0x00, 0xF5, 0x01, 0x76, 0x01, // õŶ (U+00F5 U+0176)
  0x00, 0xF5, 0x01, 0x78, 0x01, // õŸ (U+00F5 U+0178)
  0x00, 0xF6, 0x00, 0x56, 0x01, // öV (U+00F6 U+0056)
  0x00, 0xF6, 0x00, 0x57, 0x01, // öW (U+00F6 U+0057)
  0x00, 0xF6, 0x00, 0x59, 0x01, // öY (U+00F6 U+0059)
  0x00, 0xF6, 0x00, 0xDD, 0x01, // öÝ (U+00F6 U+00DD)
  0x00, 0xF6, 0x01, 0x74, 0x01, // öŴ (U+00F6 U+0174)
  0x00, 0xF6, 0x01, 0x76, 0x01, // öŶ (U+00F6 U+0176)
  0x00, 0xF6, 0x01, 0x78, 0x01, // öŸ (U+00F6 U+0178)
  0x00, 0xF8, 0x00, 0x56, 0x01, // øV (U+00F8 U+0056)
  0x00, 0xF8, 0x00, 0x57, 0x01, // øW (U+00F8 U+0057)
  0x00, 0xF8, 0x00, 0x59, 0x01, // øY (U+00F8 U+0059)
  0x00, 0xF8, 0x00, 0xDD, 0x01, // øÝ (U+00F8 U+00DD)
  0x00, 0xF8, 0x01, 0x74, 0x01, // øŴ (U+00F8 U+0174)
  0x00, 0xF8, 0x01, 0x76, 0x01, // øŶ (U+00F8 U+0176)
  0x00, 0xF8, 0x01, 0x78, 0x01, // øŸ (U+00F8 U+0178)
  0x00, 0xFD, 0x00, 0x2C, 0x02, // ý, (U+00FD U+002C)
  0x00, 0xFD, 0x00, 0x2E, 0x02, // ý. (U+00FD U+002E)
  0x00, 0xFD, 0x00, 0x41, 0x01, // ýA (U+00FD U+0041)
  0x00, 0xFD, 0x00, 0xC0, 0x01, // ýÀ (U+00FD U+00C0)
  0x00, 0xFD, 0x00, 0xC1, 0x01, // ýÁ (U+00FD U+00C1)
  0x00, 0xFD, 0x00, 0xC2, 0x01, // ýÂ (U+00FD U+00C2)
  0x00, 0xFD, 0x00, 0xC3, 0x01, // ýÃ (U+00FD U+00C3)
  0x00, 0xFD, 0x00, 0xC4, 0x01, // ýÄ (U+00FD U+00C4)
  0x00, 0xFD, 0x00, 0xC5, 0x01, // ýÅ (U+00FD U+00C5)
  0x00, 0xFD, 0x01, 0x00, 0x01, // ýĀ (U+00FD U+0100)
  0x00, 0xFD, 0x01, 0x02, 0x01, // ýĂ (U+00FD U+0102)
  0x00, 0xFD, 0x01, 0x04, 0x01, // ýĄ (U+00FD U+0104)
  0x00, 0xFD, 0x20, 0x1A, 0x02, // ý‚ (U+00FD U+201A)
  0x00, 0xFD, 0x20, 0x1E, 0x02, // ý„ (U+00FD U+201E)
  0x00, 0xFD, 0x20, 0x26, 0x02, // ý… (U+00FD U+2026)
  0x00, 0xFE, 0x00, 0x56, 0x01, // þV (U+00FE U+0056)
  0x00, 0xFE, 0x00, 0x57, 0x01, // þW (U+00FE U+0057)
  0x00, 0xFE, 0x00, 0x59, 0x01, // þY (U+00FE U+0059)
  0x00, 0xFE, 0x00, 0xDD, 0x01, // þÝ (U+00FE U+00DD)
  0x00, 0xFE, 0x01, 0x74, 0x01, // þŴ (U+00FE U+0174)
  0x00, 0xFE, 0x01, 0x76, 0x01, // þŶ (U+00FE U+0176)
  0x00, 0xFE, 0x01, 0x78, 0x01, // þŸ (U+00FE U+0178)
  0x00, 0xFF, 0x00, 0x2C, 0x02, // ÿ, (U+00FF U+002C)
  0x00, 0xFF, 0x00, 0x2E, 0x02, // ÿ. (U+00FF U+002E)
  0x00, 0xFF, 0x00, 0x41, 0x01, // ÿA (U+00FF U+0041)
  0x00, 0xFF, 0x00, 0xC0, 0x01, // ÿÀ (U+00FF U+00C0)
  0x00, 0xFF, 0x00, 0xC1, 0x01, // ÿÁ (U+00FF U+00C1)
  0x00, 0xFF, 0x00, 0xC2, 0x01, // ÿÂ (U+00FF U+00C2)
  0x00, 0xFF, 0x00, 0xC3, 0x01, // ÿÃ (U+00FF U+00C3)
  0x00, 0xFF, 0x00, 0xC4, 0x01, // ÿÄ (U+00FF U+00C4)
  0x00, 0xFF, 0x00, 0xC5, 0x01, // ÿÅ (U+00FF U+00C5)
  0x00, 0xFF, 0x01, 0x00, 0x01, // ÿĀ (U+00FF U+0100)
  0x00, 0xFF, 0x01, 0x02, 0x01, // ÿĂ (U+00FF U+0102)
  0x00, 0xFF, 0x01, 0x04, 0x01, // ÿĄ (U+00FF U+0104)
  0x00, 0xFF, 0x20, 0x1A, 0x02, // ÿ‚ (U+00FF U+201A)
  0x00, 0xFF, 0x20, 0x1E, 0x02, // ÿ„ (U+00FF U+201E)
  0x00, 0xFF, 0x20, 0x26, 0x02, // ÿ… (U+00FF U+2026)
  0x01, 0x00, 0x00, 0x22, 0x01, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x01, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x00, 0x2A, 0x01, // Ā* (U+0100 U+002A)
  0x01, 0x00, 0x00, 0x3F, 0x01, // Ā? (U+0100 U+003F)
  0x01, 0x00, 0x00, 0x54, 0x01, // ĀT (U+0100 U+0054)
  0x01, 0x00, 0x00, 0x56, 0x01, // ĀV (U+0100 U+0056)
  0x01, 0x00, 0x00, 0x57, 0x01, // ĀW (U+0100 U+0057)
  0x01, 0x00, 0x00, 0x59, 0x01, // ĀY (U+0100 U+0059)
  0x01, 0x00, 0x00, 0x76, 0x01, // Āv (U+0100 U+0076)
  0x01, 0x00, 0x00, 0x77, 0x01, // Āw (U+0100 U+0077)
  0x01, 0x00, 0x00, 0x79, 0x01, // Āy (U+0100 U+0079)
  0x01, 0x00, 0x00, 0xDD, 0x01, // ĀÝ (U+0100 U+00DD)
  0x01, 0x00, 0x00, 0xFD, 0x01, // Āý (U+0100 U+00FD)
  0x01, 0x00, 0x00, 0xFF, 0x01, // Āÿ (U+0100 U+00FF)
  0x01, 0x00, 0x01, 0x62, 0x01, // ĀŢ (U+0100 U+0162)
  0x01, 0x00, 0x01, 0x64, 0x01, // ĀŤ (U+0100 U+0164)
  0x01, 0x00, 0x01, 0x66, 0x01, // ĀŦ (U+0100 U+0166)
  0x01, 0x00, 0x01, 0x74, 0x01, // ĀŴ (U+0100 U+0174)
  0x01, 0x00, 0x01, 0x75, 0x01, // Āŵ (U+0100 U+0175)
  0x01, 0x00, 0x01, 0x76, 0x01, // ĀŶ (U+0100 U+0176)
  0x01, 0x00, 0x01, 0x77, 0x01, // Āŷ (U+0100 U+0177)
  0x01, 0x00, 0x01, 0x78, 0x01, // ĀŸ (U+0100 U+0178)
  0x01, 0x00, 0x20, 0x18, 0x01, // Ā‘ (U+0100 U+2018)
  0x01, 0x00, 0x20, 0x19, 0x01, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1C, 0x01, // Ā“ (U+0100 U+201C)
  0x01, 0x00, 0x20, 0x1D, 0x01, // Ā” (U+0100 U+201D)
  0x01, 0x00, 0x21, 0x22, 0x01, // Ā™ (U+0100 U+2122)
  0x01, 0x02, 0x00, 0x22, 0x01, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x01, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x00, 0x2A, 0x01, // Ă* (U+0102 U+002A)
  0x01, 0x02, 0x00, 0x3F, 0x01, // Ă? (U+0102 U+003F)
  0x01, 0x02, 0x00, 0x54, 0x01, // ĂT (U+0102 U+0054)
  0x01, 0x02, 0x00, 0x56, 0x01, // ĂV (U+0102 U+0056)
  0x01, 0x02, 0x00, 0x57, 0x01, // ĂW (U+0102 U+0057)
  0x01, 0x02, 0x00, 0x59, 0x01, // ĂY (U+0102 U+0059)
  0x01, 0x02, 0x00, 0x76, 0x01, // Ăv (U+0102 U+0076)
  0x01, 0x02, 0x00, 0x77, 0x01, // Ăw (U+0102 U+0077)
  0x01, 0x02, 0x00, 0x79, 0x01, // Ăy (U+0102 U+0079)
  0x01, 0x02, 0x00, 0xDD, 0x01, // ĂÝ (U+0102 U+00DD)
  0x01, 0x02, 0x00, 0xFD, 0x01, // Ăý (U+0102 U+00FD)
  0x01, 0x02, 0x00, 0xFF, 0x01, // Ăÿ (U+0102 U+00FF)
  0x01, 0x02, 0x01, 0x62, 0x01, // ĂŢ (U+0102 U+0162)
  0x01, 0x02, 0x01, 0x64, 0x01, // ĂŤ (U+0102 U+0164)
  0x01, 0x02, 0x01, 0x66, 0x01, // ĂŦ (U+0102 U+0166)
  0x01, 0x02, 0x01, 0x74, 0x01, // ĂŴ (U+0102 U+0174)
  0x01, 0x02, 0x01, 0x75, 0x01, // Ăŵ (U+0102 U+0175)
  0x01, 0x02, 0x01, 0x76, 0x01, // ĂŶ (U+0102 U+0176)
  0x01, 0x02, 0x01, 0x77, 0x01, // Ăŷ (U+0102 U+0177)
  0x01, 0x02, 0x01, 0x78, 0x01, // ĂŸ (U+0102 U+0178)
  0x01, 0x02, 0x20, 0x18, 0x01, // Ă‘ (U+0102 U+2018)
  0x01, 0x02, 0x20, 0x19, 0x01, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1C, 0x01, // Ă“ (U+0102 U+201C)
  0x01, 0x02, 0x20, 0x1D, 0x01, // Ă” (U+0102 U+201D)
  0x01, 0x02, 0x21, 0x22, 0x01, // Ă™ (U+0102 U+2122)
  0x01, 0x04, 0x00, 0x22, 0x01, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x01, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x00, 0x2A, 0x01, // Ą* (U+0104 U+002A)
  0x01, 0x04, 0x00, 0x3F, 0x01, // Ą? (U+0104 U+003F)
  0x01, 0x04, 0x00, 0x54, 0x01, // ĄT (U+0104 U+0054)
  0x01, 0x04, 0x00, 0x56, 0x01, // ĄV (U+0104 U+0056)
  0x01, 0x04, 0x00, 0x57, 0x01, // ĄW (U+0104 U+0057)
  0x01, 0x04, 0x00, 0x59, 0x01, // ĄY (U+0104 U+0059)
  0x01, 0x04, 0x00, 0x76, 0x01, // Ąv (U+0104 U+0076)
  0x01, 0x04, 0x00, 0x77, 0x01, // Ąw (U+0104 U+0077)
  0x01, 0x04, 0x00, 0x79, 0x01, // Ąy (U+0104 U+0079)
  0x01, 0x04, 0x00, 0xDD, 0x01, // ĄÝ (U+0104 U+00DD)
  0x01, 0x04, 0x00, 0xFD, 0x01, // Ąý (U+0104 U+00FD)
  0x01, 0x04, 0x00, 0xFF, 0x01, // Ąÿ (U+0104 U+00FF)
  0x01, 0x04, 0x01, 0x62, 0x01, // ĄŢ (U+0104 U+0162)
  0x01, 0x04, 0x01, 0x64, 0x01, // ĄŤ (U+0104 U+0164)
  0x01, 0x04, 0x01, 0x66, 0x01, // ĄŦ (U+0104 U+0166)
  0x01, 0x04, 0x01, 0x74, 0x01, // ĄŴ (U+0104 U+0174)
  0x01, 0x04, 0x01, 0x75, 0x01, // Ąŵ (U+0104 U+0175)
  0x01, 0x04, 0x01, 0x76, 0x01, // ĄŶ (U+0104 U+0176)
  0x01, 0x04, 0x01, 0x77, 0x01, // Ąŷ (U+0104 U+0177)
  0x01, 0x04, 0x01, 0x78, 0x01, // ĄŸ (U+0104 U+0178)
  0x01, 0x04, 0x20, 0x18, 0x01, // Ą‘ (U+0104 U+2018)
  0x01, 0x04, 0x20, 0x19, 0x01, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1C, 0x01, // Ą“ (U+0104 U+201C)
  0x01, 0x04, 0x20, 0x1D, 0x01, // Ą” (U+0104 U+201D)
  0x01, 0x04, 0x21, 0x22, 0x01, // Ą™ (U+0104 U+2122)
  0x01, 0x0E, 0x00, 0x59, 0x01, // ĎY (U+010E U+0059)
  0x01, 0x0E, 0x00, 0xC6, 0x01, // ĎÆ (U+010E U+00C6)
  0x01, 0x0E, 0x00, 0xDD, 0x01, // ĎÝ (U+010E U+00DD)
  0x01, 0x0E, 0x01, 0x76, 0x01, // ĎŶ (U+010E U+0176)
  0x01, 0x0E, 0x01, 0x78, 0x01, // ĎŸ (U+010E U+0178)
  0x01, 0x10, 0x00, 0x59, 0x01, // ĐY (U+0110 U+0059)
  0x01, 0x10, 0x00, 0xC6, 0x01, // ĐÆ (U+0110 U+00C6)
  0x01, 0x10, 0x00, 0xDD, 0x01, // ĐÝ (U+0110 U+00DD)
  0x01, 0x10, 0x01, 0x76, 0x01, // ĐŶ (U+0110 U+0176)
  0x01, 0x10, 0x01, 0x78, 0x01, // ĐŸ (U+0110 U+0178)
  0x01, 0x13, 0x00, 0x56, 0x01, // ēV (U+0113 U+0056)
  0x01, 0x13, 0x00, 0x57, 0x01, // ēW (U+0113 U+0057)
  0x01, 0x13, 0x00, 0x59, 0x01, // ēY (U+0113 U+0059)
  0x01, 0x13, 0x00, 0xDD, 0x01, // ēÝ (U+0113 U+00DD)
  0x01, 0x13, 0x01, 0x74, 0x01, // ēŴ (U+0113 U+0174)
  0x01, 0x13, 0x01, 0x76, 0x01, // ēŶ (U+0113 U+0176)
  0x01, 0x13, 0x01, 0x78, 0x01, // ēŸ (U+0113 U+0178)
  0x01, 0x15, 0x00, 0x56, 0x01, // ĕV (U+0115 U+0056)
  0x01, 0x15, 0x00, 0x57, 0x01, // ĕW (U+0115 U+0057)
  0x01, 0x15, 0x00, 0x59, 0x01, // ĕY (U+0115 U+0059)
  0x01, 0x15, 0x00, 0xDD, 0x01, // ĕÝ (U+0115 U+00DD)
  0x01, 0x15, 0x01, 0x74, 0x01, // ĕŴ (U+0115 U+0174)
  0x01, 0x15, 0x01, 0x76, 0x01, // ĕŶ (U+0115 U+0176)
  0x01, 0x15, 0x01, 0x78, 0x01, // ĕŸ (U+0115 U+0178)
  0x01, 0x17, 0x00, 0x56, 0x01, // ėV (U+0117 U+0056)
  0x01, 0x17, 0x00, 0x57, 0x01, // ėW (U+0117 U+0057)
  0x01, 0x17, 0x00, 0x59, 0x01, // ėY (U+0117 U+0059)
  0x01, 0x17, 0x00, 0xDD, 0x01, // ėÝ (U+0117 U+00DD)
  0x01, 0x17, 0x01, 0x74, 0x01, // ėŴ (U+0117 U+0174)
  0x01, 0x17, 0x01, 0x76, 0x01, // ėŶ (U+0117 U+0176)
  0x01, 0x17, 0x01, 0x78, 0x01, // ėŸ (U+0117 U+0178)
  0x01, 0x19, 0x00, 0x56, 0x01, // ęV (U+0119 U+0056)
  0x01, 0x19, 0x00, 0x57, 0x01, // ęW (U+0119 U+0057)
  0x01, 0x19, 0x00, 0x59, 0x01, // ęY (U+0119 U+0059)
  0x01, 0x19, 0x00, 0xDD, 0x01, // ęÝ (U+0119 U+00DD)
  0x01, 0x19, 0x01, 0x74, 0x01, // ęŴ (U+0119 U+0174)
  0x01, 0x19, 0x01, 0x76, 0x01, // ęŶ (U+0119 U+0176)
  0x01, 0x19, 0x01, 0x78, 0x01, // ęŸ (U+0119 U+0178)
  0x01, 0x1B, 0x00, 0x56, 0x01, // ěV (U+011B U+0056)
  0x01, 0x1B, 0x00, 0x57, 0x01, // ěW (U+011B U+0057)
  0x01, 0x1B, 0x00, 0x59, 0x01, // ěY (U+011B U+0059)
  0x01, 0x1B, 0x00, 0xDD, 0x01, // ěÝ (U+011B U+00DD)
  0x01, 0x1B, 0x01, 0x74, 0x01, // ěŴ (U+011B U+0174)
  0x01, 0x1B, 0x01, 0x76, 0x01, // ěŶ (U+011B U+0176)
  0x01, 0x1B, 0x01, 0x78, 0x01, // ěŸ (U+011B U+0178)
  0x01, 0x25, 0x00, 0x22, 0x01, // ĥ" (U+0125 U+0022)
  0x01, 0x25, 0x00, 0x27, 0x01, // ĥ' (U+0125 U+0027)
  0x01, 0x27, 0x00, 0x22, 0x01, // ħ" (U+0127 U+0022)
  0x01, 0x27, 0x00, 0x27, 0x01, // ħ' (U+0127 U+0027)
  0x01, 0x36, 0x00, 0x77, 0x01, // Ķw (U+0136 U+0077)
  0x01, 0x36, 0x00, 0x79, 0x01, // Ķy (U+0136 U+0079)
  0x01, 0x36, 0x00, 0xFD, 0x01, // Ķý (U+0136 U+00FD)
  0x01, 0x36, 0x00, 0xFF, 0x01, // Ķÿ (U+0136 U+00FF)
  0x01, 0x36, 0x01, 0x75, 0x01, // Ķŵ (U+0136 U+0175)
  0x01, 0x36, 0x01, 0x77, 0x01, // Ķŷ (U+0136 U+0177)
  0x01, 0x39, 0x00, 0x22, 0x01, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x01, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x00, 0x2A, 0x01, // Ĺ* (U+0139 U+002A)
  0x01, 0x39, 0x00, 0x3F, 0x01, // Ĺ? (U+0139 U+003F)
  0x01, 0x39, 0x00, 0x54, 0x01, // ĹT (U+0139 U+0054)
  0x01, 0x39, 0x00, 0x56, 0x01, // ĹV (U+0139 U+0056)
  0x01, 0x39, 0x00, 0x57, 0x01, // ĹW (U+0139 U+0057)
  0x01, 0x39, 0x00, 0x59, 0x01, // ĹY (U+0139 U+0059)
  0x01, 0x39, 0x00, 0x79, 0x01, // Ĺy (U+0139 U+0079)
  0x01, 0x39, 0x00, 0xDD, 0x01, // ĹÝ (U+0139 U+00DD)
  0x01, 0x39, 0x00, 0xFD, 0x01, // Ĺý (U+0139 U+00FD)
  0x01, 0x39, 0x00, 0xFF, 0x01, // Ĺÿ (U+0139 U+00FF)
  0x01, 0x39, 0x01, 0x62, 0x01, // ĹŢ (U+0139 U+0162)
  0x01, 0x39, 0x01, 0x64, 0x01, // ĹŤ (U+0139 U+0164)
  0x01, 0x39, 0x01, 0x66, 0x01, // ĹŦ (U+0139 U+0166)
  0x01, 0x39, 0x01, 0x74, 0x01, // ĹŴ (U+0139 U+0174)
  0x01, 0x39, 0x01, 0x76, 0x01, // ĹŶ (U+0139 U+0176)
  0x01, 0x39, 0x01, 0x77, 0x01, // Ĺŷ (U+0139 U+0177)
  0x01, 0x39, 0x01, 0x78, 0x01, // ĹŸ (U+0139 U+0178)
  0x01, 0x39, 0x20, 0x18, 0x01, // Ĺ‘ (U+0139 U+2018)
  0x01, 0x39, 0x20, 0x19, 0x01, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1C, 0x01, // Ĺ“ (U+0139 U+201C)
  0x01, 0x39, 0x20, 0x1D, 0x01, // Ĺ” (U+0139 U+201D)
  0x01, 0x39, 0x21, 0x22, 0x01, // Ĺ™ (U+0139 U+2122)
  0x01, 0x3B, 0x00, 0x22, 0x01, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x01, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x00, 0x2A, 0x01, // Ļ* (U+013B U+002A)
  0x01, 0x3B, 0x00, 0x3F, 0x01, // Ļ? (U+013B U+003F)
  0x01, 0x3B, 0x00, 0x54, 0x01, // ĻT (U+013B U+0054)
  0x01, 0x3B, 0x00, 0x56, 0x01, // ĻV (U+013B U+0056)
  0x01, 0x3B, 0x00, 0x57, 0x01, // ĻW (U+013B U+0057)
  0x01, 0x3B, 0x00, 0x59, 0x01, // ĻY (U+013B U+0059)
  0x01, 0x3B, 0x00, 0x79, 0x01, // Ļy (U+013B U+0079)
  0x01, 0x3B, 0x00, 0xDD, 0x01, // ĻÝ (U+013B U+00DD)
  0x01, 0x3B, 0x00, 0xFD, 0x01, // Ļý (U+013B U+00FD)
  0x01, 0x3B, 0x00, 0xFF, 0x01, // Ļÿ (U+013B U+00FF)
  0x01, 0x3B, 0x01, 0x62, 0x01, // ĻŢ (U+013B U+0162)
  0x01, 0x3B, 0x01, 0x64, 0x01, // ĻŤ (U+013B U+0164)
  0x01, 0x3B, 0x01, 0x66, 0x01, // ĻŦ (U+013B U+0166)
  0x01, 0x3B, 0x01, 0x74, 0x01, // ĻŴ (U+013B U+0174)
  0x01, 0x3B, 0x01, 0x76, 0x01, // ĻŶ (U+013B U+0176)
  0x01, 0x3B, 0x01, 0x77, 0x01, // Ļŷ (U+013B U+0177)
  0x01, 0x3B, 0x01, 0x78, 0x01, // ĻŸ (U+013B U+0178)
  0x01, 0x3B, 0x20, 0x18, 0x01, // Ļ‘ (U+013B U+2018)
  0x01, 0x3B, 0x20, 0x19, 0x01, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1C, 0x01, // Ļ“ (U+013B U+201C)
  0x01, 0x3B, 0x20, 0x1D, 0x01, // Ļ” (U+013B U+201D)
  0x01, 0x3B, 0x21, 0x22, 0x01, // Ļ™ (U+013B U+2122)
  0x01, 0x41, 0x00, 0x22, 0x01, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x01, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x00, 0x2A, 0x01, // Ł* (U+0141 U+002A)
  0x01, 0x41, 0x00, 0x3F, 0x01, // Ł? (U+0141 U+003F)
  0x01, 0x41, 0x00, 0x54, 0x01, // ŁT (U+0141 U+0054)
  0x01, 0x41, 0x00, 0x56, 0x01, // ŁV (U+0141 U+0056)
  0x01, 0x41, 0x00, 0x57, 0x01, // ŁW (U+0141 U+0057)
  0x01, 0x41, 0x00, 0x59, 0x01, // ŁY (U+0141 U+0059)
  0x01, 0x41, 0x00, 0x79, 0x01, // Ły (U+0141 U+0079)
  0x01, 0x41, 0x00, 0xDD, 0x01, // ŁÝ (U+0141 U+00DD)
  0x01, 0x41, 0x00, 0xFD, 0x01, // Łý (U+0141 U+00FD)
  0x01, 0x41, 0x00, 0xFF, 0x01, // Łÿ (U+0141 U+00FF)
  0x01, 0x41, 0x01, 0x62, 0x01, // ŁŢ (U+0141 U+0162)
  0x01, 0x41, 0x01, 0x64, 0x01, // ŁŤ (U+0141 U+0164)
  0x01, 0x41, 0x01, 0x66, 0x01, // ŁŦ (U+0141 U+0166)
  0x01, 0x41, 0x01, 0x74, 0x01, // ŁŴ (U+0141 U+0174)
  0x01, 0x41, 0x01, 0x76, 0x01, // ŁŶ (U+0141 U+0176)
  0x01, 0x41, 0x01, 0x77, 0x01, // Łŷ (U+0141 U+0177)
  0x01, 0x41, 0x01, 0x78, 0x01, // ŁŸ (U+0141 U+0178)
  0x01, 0x41, 0x20, 0x18, 0x01, // Ł‘ (U+0141 U+2018)
  0x01, 0x41, 0x20, 0x19, 0x01, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1C, 0x01, // Ł“ (U+0141 U+201C)
  0x01, 0x41, 0x20, 0x1D, 0x01, // Ł” (U+0141 U+201D)
  0x01, 0x41, 0x21, 0x22, 0x01, // Ł™ (U+0141 U+2122)
  0x01, 0x44, 0x00, 0x22, 0x01, // ń" (U+0144 U+0022)
  0x01, 0x44, 0x00, 0x27, 0x01, // ń' (U+0144 U+0027)
  0x01, 0x46, 0x00, 0x22, 0x01, // ņ" (U+0146 U+0022)
  0x01, 0x46, 0x00, 0x27, 0x01, // ņ' (U+0146 U+0027)
  0x01, 0x48, 0x00, 0x22, 0x01, // ň" (U+0148 U+0022)
  0x01, 0x48, 0x00, 0x27, 0x01, // ň' (U+0148 U+0027)
  0x01, 0x49, 0x00, 0x22, 0x01, // ŉ" (U+0149 U+0022)
  0x01, 0x49, 0x00, 0x27, 0x01, // ŉ' (U+0149 U+0027)
  0x01, 0x4B, 0x00, 0x22, 0x01, // ŋ" (U+014B U+0022)
  0x01, 0x4B, 0x00, 0x27, 0x01, // ŋ' (U+014B U+0027)
  0x01, 0x4C, 0x00, 0x59, 0x01, // ŌY (U+014C U+0059)
  0x01, 0x4C, 0x00, 0xC6, 0x01, // ŌÆ (U+014C U+00C6)
  0x01, 0x4C, 0x00, 0xDD, 0x01, // ŌÝ (U+014C U+00DD)
  0x01, 0x4C, 0x01, 0x76, 0x01, // ŌŶ (U+014C U+0176)
  0x01, 0x4C, 0x01, 0x78, 0x01, // ŌŸ (U+014C U+0178)
  0x01, 0x4D, 0x00, 0x56, 0x01, // ōV (U+014D U+0056)
  0x01, 0x4D, 0x00, 0x57, 0x01, // ōW (U+014D U+0057)
  0x01, 0x4D, 0x00, 0x59, 0x01, // ōY (U+014D U+0059)
  0x01, 0x4D, 0x00, 0xDD, 0x01, // ōÝ (U+014D U+00DD)
  0x01, 0x4D, 0x01, 0x74, 0x01, // ōŴ (U+014D U+0174)
  0x01, 0x4D, 0x01, 0x76, 0x01, // ōŶ (U+014D U+0176)
  0x01, 0x4D, 0x01, 0x78, 0x01, // ōŸ (U+014D U+0178)
  0x01, 0x4E, 0x00, 0x59, 0x01, // ŎY (U+014E U+0059)
  0x01, 0x4E, 0x00, 0xC6, 0x01, // ŎÆ (U+014E U+00C6)
  0x01, 0x4E, 0x00, 0xDD, 0x01, // ŎÝ (U+014E U+00DD)
  0x01, 0x4E, 0x01, 0x76, 0x01, // ŎŶ (U+014E U+0176)
  0x01, 0x4E, 0x01, 0x78, 0x01, // ŎŸ (U+014E U+0178)
  0x01, 0x4F, 0x00, 0x56, 0x01, // ŏV (U+014F U+0056)
  0x01, 0x4F, 0x00, 0x57, 0x01, // ŏW (U+014F U+0057)
  0x01, 0x4F, 0x00, 0x59, 0x01, // ŏY (U+014F U+0059)
  0x01, 0x4F, 0x00, 0xDD, 0x01, // ŏÝ (U+014F U+00DD)
  0x01, 0x4F, 0x01, 0x74, 0x01, // ŏŴ (U+014F U+0174)
  0x01, 0x4F, 0x01, 0x76, 0x01, // ŏŶ (U+014F U+0176)
  0x01, 0x4F, 0x01, 0x78, 0x01, // ŏŸ (U+014F U+0178)
  0x01, 0x50, 0x00, 0x59, 0x01, // ŐY (U+0150 U+0059)
  0x01, 0x50, 0x00, 0xC6, 0x01, // ŐÆ (U+0150 U+00C6)
  0x01, 0x50, 0x00, 0xDD, 0x01, // ŐÝ (U+0150 U+00DD)
  0x01, 0x50, 0x01, 0x76, 0x01, // ŐŶ (U+0150 U+0176)
  0x01, 0x50, 0x01, 0x78, 0x01, // ŐŸ (U+0150 U+0178)
  0x01, 0x51, 0x00, 0x56, 0x01, // őV (U+0151 U+0056)
  0x01, 0x51, 0x00, 0x57, 0x01, // őW (U+0151 U+0057)
  0x01, 0x51, 0x00, 0x59, 0x01, // őY (U+0151 U+0059)
  0x01, 0x51, 0x00, 0xDD, 0x01, // őÝ (U+0151 U+00DD)
  0x01, 0x51, 0x01, 0x74, 0x01, // őŴ (U+0151 U+0174)
  0x01, 0x51, 0x01, 0x76, 0x01, // őŶ (U+0151 U+0176)
  0x01, 0x51, 0x01, 0x78, 0x01, // őŸ (U+0151 U+0178)
  0x01, 0x53, 0x00, 0x56, 0x01, // œV (U+0153 U+0056)
  0x01, 0x53, 0x00, 0x57, 0x01, // œW (U+0153 U+0057)
  0x01, 0x53, 0x00, 0x59, 0x01, // œY (U+0153 U+0059)
  0x01, 0x53, 0x00, 0xDD, 0x01, // œÝ (U+0153 U+00DD)
  0x01, 0x53, 0x01, 0x74, 0x01, // œŴ (U+0153 U+0174)
  0x01, 0x53, 0x01, 0x76, 0x01, // œŶ (U+0153 U+0176)
  0x01, 0x53, 0x01, 0x78, 0x01, // œŸ (U+0153 U+0178)
  0x01, 0x54, 0x00, 0x56, 0x01, // ŔV (U+0154 U+0056)
  0x01, 0x54, 0x00, 0x57, 0x01, // ŔW (U+0154 U+0057)
  0x01, 0x54, 0x00, 0x59, 0x01, // ŔY (U+0154 U+0059)
  0x01, 0x54, 0x00, 0xDD, 0x01, // ŔÝ (U+0154 U+00DD)
  0x01, 0x54, 0x01, 0x74, 0x01, // ŔŴ (U+0154 U+0174)
  0x01, 0x54, 0x01, 0x76, 0x01, // ŔŶ (U+0154 U+0176)
  0x01, 0x54, 0x01, 0x78, 0x01, // ŔŸ (U+0154 U+0178)
  0x01, 0x55, 0x00, 0x2C, 0x02, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x02, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x20, 0x1A, 0x02, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x02, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x02, // ŕ… (U+0155 U+2026)
  0x01, 0x56, 0x00, 0x56, 0x01, // ŖV (U+0156 U+0056)
  0x01, 0x56, 0x00, 0x57, 0x01, // ŖW (U+0156 U+0057)
  0x01, 0x56, 0x00, 0x59, 0x01, // ŖY (U+0156 U+0059)
  0x01, 0x56, 0x00, 0xDD, 0x01, // ŖÝ (U+0156 U+00DD)
  0x01, 0x56, 0x01, 0x74, 0x01, // ŖŴ (U+0156 U+0174)
  0x01, 0x56, 0x01, 0x76, 0x01, // ŖŶ (U+0156 U+0176)
  0x01, 0x56, 0x01, 0x78, 0x01, // ŖŸ (U+0156 U+0178)
  0x01, 0x57, 0x00, 0x2C, 0x02, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x02, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x20, 0x1A, 0x02, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x02, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x02, // ŗ… (U+0157 U+2026)
  0x01, 0x58, 0x00, 0x56, 0x01, // ŘV (U+0158 U+0056)
  0x01, 0x58, 0x00, 0x57, 0x01, // ŘW (U+0158 U+0057)
  0x01, 0x58, 0x00, 0x59, 0x01, // ŘY (U+0158 U+0059)
  0x01, 0x58, 0x00, 0xDD, 0x01, // ŘÝ (U+0158 U+00DD)
  0x01, 0x58, 0x01, 0x74, 0x01, // ŘŴ (U+0158 U+0174)
  0x01, 0x58, 0x01, 0x76, 0x01, // ŘŶ (U+0158 U+0176)
  0x01, 0x58, 0x01, 0x78, 0x01, // ŘŸ (U+0158 U+0178)
  0x01, 0x59, 0x00, 0x2C, 0x02, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x02, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x20, 0x1A, 0x02, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x02, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x02, // ř… (U+0159 U+2026)
  0x01, 0x5B, 0x00, 0x59, 0x01, // śY (U+015B U+0059)
  0x01, 0x5B, 0x00, 0xDD, 0x01, // śÝ (U+015B U+00DD)
  0x01, 0x5B, 0x01, 0x76, 0x01, // śŶ (U+015B U+0176)
  0x01, 0x5B, 0x01, 0x78, 0x01, // śŸ (U+015B U+0178)
  0x01, 0x5D, 0x00, 0x59, 0x01, // ŝY (U+015D U+0059)
  0x01, 0x5D, 0x00, 0xDD, 0x01, // ŝÝ (U+015D U+00DD)
  0x01, 0x5D, 0x01, 0x76, 0x01, // ŝŶ (U+015D U+0176)
  0x01, 0x5D, 0x01, 0x78, 0x01, // ŝŸ (U+015D U+0178)
  0x01, 0x5F, 0x00, 0x59, 0x01, // şY (U+015F U+0059)
  0x01, 0x5F, 0x00, 0xDD, 0x01, // şÝ (U+015F U+00DD)
  0x01, 0x5F, 0x01, 0x76, 0x01, // şŶ (U+015F U+0176)
  0x01, 0x5F, 0x01, 0x78, 0x01, // şŸ (U+015F U+0178)
  0x01, 0x61, 0x00, 0x59, 0x01, // šY (U+0161 U+0059)
  0x01, 0x61, 0x00, 0xDD, 0x01, // šÝ (U+0161 U+00DD)
  0x01, 0x61, 0x01, 0x76, 0x01, // šŶ (U+0161 U+0176)
  0x01, 0x61, 0x01, 0x78, 0x01, // šŸ (U+0161 U+0178)
  0x01, 0x62, 0x00, 0x2C, 0x02, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2E, 0x02, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0x40, 0x01, // Ţ@ (U+0162 U+0040)
  0x01, 0x62, 0x00, 0x41, 0x01, // ŢA (U+0162 U+0041)
  0x01, 0x62, 0x00, 0x61, 0x01, // Ţa (U+0162 U+0061)
  0x01, 0x62, 0x00, 0x63, 0x01, // Ţc (U+0162 U+0063)
  0x01, 0x62, 0x00, 0x64, 0x01, // Ţd (U+0162 U+0064)
  0x01, 0x62, 0x00, 0x65, 0x01, // Ţe (U+0162 U+0065)
  0x01, 0x62, 0x00, 0x67, 0x01, // Ţg (U+0162 U+0067)
  0x01, 0x62, 0x00, 0x6F, 0x01, // Ţo (U+0162 U+006F)
  0x01, 0x62, 0x00, 0x71, 0x01, // Ţq (U+0162 U+0071)
  0x01, 0x62, 0x00, 0xC0, 0x01, // ŢÀ (U+0162 U+00C0)
  0x01, 0x62, 0x00, 0xC1, 0x01, // ŢÁ (U+0162 U+00C1)
  0x01, 0x62, 0x00, 0xC2, 0x01, // ŢÂ (U+0162 U+00C2)
  0x01, 0x62, 0x00, 0xC3, 0x01, // ŢÃ (U+0162 U+00C3)
  0x01, 0x62, 0x00, 0xC4, 0x01, // ŢÄ (U+0162 U+00C4)
  0x01, 0x62, 0x00, 0xC5, 0x01, // ŢÅ (U+0162 U+00C5)
  0x01, 0x62, 0x00, 0xC6, 0x01, // ŢÆ (U+0162 U+00C6)
  0x01, 0x62, 0x00, 0xE0, 0x01, // Ţà (U+0162 U+00E0)
  0x01, 0x62, 0x00, 0xE1, 0x01, // Ţá (U+0162 U+00E1)
  0x01, 0x62, 0x00, 0xE2, 0x01, // Ţâ (U+0162 U+00E2)
  0x01, 0x62, 0x00, 0xE3, 0x01, // Ţã (U+0162 U+00E3)
  0x01, 0x62, 0x00, 0xE4, 0x01, // Ţä (U+0162 U+00E4)
  0x01, 0x62, 0x00, 0xE5, 0x01, // Ţå (U+0162 U+00E5)
  0x01, 0x62, 0x00, 0xE6, 0x01, // Ţæ (U+0162 U+00E6)
  0x01, 0x62, 0x00, 0xE7, 0x01, // Ţç (U+0162 U+00E7)
  0x01, 0x62, 0x00, 0xE8, 0x01, // Ţè (U+0162 U+00E8)
  0x01, 0x62, 0x00, 0xE9, 0x01, // Ţé (U+0162 U+00E9)
  0x01, 0x62, 0x00, 0xEA, 0x01, // Ţê (U+0162 U+00EA)
  0x01, 0x62, 0x00, 0xEB, 0x01, // Ţë (U+0162 U+00EB)
  0x01, 0x62, 0x00, 0xF0, 0x01, // Ţð (U+0162 U+00F0)
  0x01, 0x62, 0x00, 0xF2, 0x01, // Ţò (U+0162 U+00F2)
  0x01, 0x62, 0x00, 0xF3, 0x01, // Ţó (U+0162 U+00F3)
  0x01, 0x62, 0x00, 0xF4, 0x01, // Ţô (U+0162 U+00F4)
  0x01, 0x62, 0x00, 0xF5, 0x01, // Ţõ (U+0162 U+00F5)
  0x01, 0x62, 0x00, 0xF6, 0x01, // Ţö (U+0162 U+00F6)
  0x01, 0x62, 0x00, 0xF8, 0x01, // Ţø (U+0162 U+00F8)
  0x01, 0x62, 0x01, 0x00, 0x01, // ŢĀ (U+0162 U+0100)
  0x01, 0x62, 0x01, 0x01, 0x01, // Ţā (U+0162 U+0101)
  0x01, 0x62, 0x01, 0x02, 0x01, // ŢĂ (U+0162 U+0102)
  0x01, 0x62, 0x01, 0x03, 0x01, // Ţă (U+0162 U+0103)
  0x01, 0x62, 0x01, 0x04, 0x01, // ŢĄ (U+0162 U+0104)
  0x01, 0x62, 0x01, 0x05, 0x01, // Ţą (U+0162 U+0105)
  0x01, 0x62, 0x01, 0x07, 0x01, // Ţć (U+0162 U+0107)
  0x01, 0x62, 0x01, 0x09, 0x01, // Ţĉ (U+0162 U+0109)
  0x01, 0x62, 0x01, 0x0B, 0x01, // Ţċ (U+0162 U+010B)
  0x01, 0x62, 0x01, 0x0D, 0x01, // Ţč (U+0162 U+010D)
  0x01, 0x62, 0x01, 0x0F, 0x01, // Ţď (U+0162 U+010F)
  0x01, 0x62, 0x01, 0x11, 0x01, // Ţđ (U+0162 U+0111)
  0x01, 0x62, 0x01, 0x13, 0x01, // Ţē (U+0162 U+0113)
  0x01, 0x62, 0x01, 0x15, 0x01, // Ţĕ (U+0162 U+0115)
  0x01, 0x62, 0x01, 0x17, 0x01, // Ţė (U+0162 U+0117)
  0x01, 0x62, 0x01, 0x19, 0x01, // Ţę (U+0162 U+0119)
  0x01, 0x62, 0x01, 0x1B, 0x01, // Ţě (U+0162 U+011B)
  0x01, 0x62, 0x01, 0x1D, 0x01, // Ţĝ (U+0162 U+011D)
  0x01, 0x62, 0x01, 0x1F, 0x01, // Ţğ (U+0162 U+011F)
  0x01, 0x62, 0x01, 0x21, 0x01, // Ţġ (U+0162 U+0121)
  0x01, 0x62, 0x01, 0x23, 0x01, // Ţģ (U+0162 U+0123)
  0x01, 0x62, 0x01, 0x4D, 0x01, // Ţō (U+0162 U+014D)
  0x01, 0x62, 0x01, 0x4F, 0x01, // Ţŏ (U+0162 U+014F)
  0x01, 0x62, 0x01, 0x51, 0x01, // Ţő (U+0162 U+0151)
  0x01, 0x62, 0x01, 0x53, 0x01, // Ţœ (U+0162 U+0153)
  0x01, 0x62, 0x20, 0x1A, 0x02, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x02, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x02, // Ţ… (U+0162 U+2026)
  0x01, 0x64, 0x00, 0x2C, 0x02, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2E, 0x02, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0x40, 0x01, // Ť@ (U+0164 U+0040)
  0x01, 0x64, 0x00, 0x41, 0x01, // ŤA (U+0164 U+0041)
  0x01, 0x64, 0x00, 0x61, 0x01, // Ťa (U+0164 U+0061)
  0x01, 0x64, 0x00, 0x63, 0x01, // Ťc (U+0164 U+0063)
  0x01, 0x64, 0x00, 0x64, 0x01, // Ťd (U+0164 U+0064)
  0x01, 0x64, 0x00, 0x65, 0x01, // Ťe (U+0164 U+0065)
  0x01, 0x64, 0x00, 0x67, 0x01, // Ťg (U+0164 U+0067)
  0x01, 0x64, 0x00, 0x6F, 0x01, // Ťo (U+0164 U+006F)
  0x01, 0x64, 0x00, 0x71, 0x01, // Ťq (U+0164 U+0071)
  0x01, 0x64, 0x00, 0xC0, 0x01, // ŤÀ (U+0164 U+00C0)
  0x01, 0x64, 0x00, 0xC1, 0x01, // ŤÁ (U+0164 U+00C1)
  0x01, 0x64, 0x00, 0xC2, 0x01, // ŤÂ (U+0164 U+00C2)
  0x01, 0x64, 0x00, 0xC3, 0x01, // ŤÃ (U+0164 U+00C3)
  0x01, 0x64, 0x00, 0xC4, 0x01, // ŤÄ (U+0164 U+00C4)
  0x01, 0x64, 0x00, 0xC5, 0x01, // ŤÅ (U+0164 U+00C5)
  0x01, 0x64, 0x00, 0xC6, 0x01, // ŤÆ (U+0164 U+00C6)
  0x01, 0x64, 0x00, 0xE0, 0x01, // Ťà (U+0164 U+00E0)
  0x01, 0x64, 0x00, 0xE1, 0x01, // Ťá (U+0164 U+00E1)
  0x01, 0x64, 0x00, 0xE2, 0x01, // Ťâ (U+0164 U+00E2)
  0x01, 0x64, 0x00, 0xE3, 0x01, // Ťã (U+0164 U+00E3)
  0x01, 0x64, 0x00, 0xE4, 0x01, // Ťä (U+0164 U+00E4)
  0x01, 0x64, 0x00, 0xE5, 0x01, // Ťå (U+0164 U+00E5)
  0x01, 0x64, 0x00, 0xE6, 0x01, // Ťæ (U+0164 U+00E6)
  0x01, 0x64, 0x00, 0xE7, 0x01, // Ťç (U+0164 U+00E7)
  0x01, 0x64, 0x00, 0xE8, 0x01, // Ťè (U+0164 U+00E8)
  0x01, 0x64, 0x00, 0xE9, 0x01, // Ťé (U+0164 U+00E9)
  0x01, 0x64, 0x00, 0xEA, 0x01, // Ťê (U+0164 U+00EA)
  0x01, 0x64, 0x00, 0xEB, 0x01, // Ťë (U+0164 U+00EB)
  0x01, 0x64, 0x00, 0xF0, 0x01, // Ťð (U+0164 U+00F0)
  0x01, 0x64, 0x00, 0xF2, 0x01, // Ťò (U+0164 U+00F2)
  0x01, 0x64, 0x00, 0xF3, 0x01, // Ťó (U+0164 U+00F3)
  0x01, 0x64, 0x00, 0xF4, 0x01, // Ťô (U+0164 U+00F4)
  0x01, 0x64, 0x00, 0xF5, 0x01, // Ťõ (U+0164 U+00F5)
  0x01, 0x64, 0x00, 0xF6, 0x01, // Ťö (U+0164 U+00F6)
  0x01, 0x64, 0x00, 0xF8, 0x01, // Ťø (U+0164 U+00F8)
  0x01, 0x64, 0x01, 0x00, 0x01, // ŤĀ (U+0164 U+0100)
  0x01, 0x64, 0x01, 0x01, 0x01, // Ťā (U+0164 U+0101)
  0x01, 0x64, 0x01, 0x02, 0x01, // ŤĂ (U+0164 U+0102)
  0x01, 0x64, 0x01, 0x03, 0x01, // Ťă (U+0164 U+0103)
  0x01, 0x64, 0x01, 0x04, 0x01, // ŤĄ (U+0164 U+0104)
  0x01, 0x64, 0x01, 0x05, 0x01, // Ťą (U+0164 U+0105)
  0x01, 0x64, 0x01, 0x07, 0x01, // Ťć (U+0164 U+0107)
  0x01, 0x64, 0x01, 0x09, 0x01, // Ťĉ (U+0164 U+0109)
  0x01, 0x64, 0x01, 0x0B, 0x01, // Ťċ (U+0164 U+010B)
  0x01, 0x64, 0x01, 0x0D, 0x01, // Ťč (U+0164 U+010D)
  0x01, 0x64, 0x01, 0x0F, 0x01, // Ťď (U+0164 U+010F)
  0x01, 0x64, 0x01, 0x11, 0x01, // Ťđ (U+0164 U+0111)
  0x01, 0x64, 0x01, 0x13, 0x01, // Ťē (U+0164 U+0113)
  0x01, 0x64, 0x01, 0x15, 0x01, // Ťĕ (U+0164 U+0115)
  0x01, 0x64, 0x01, 0x17, 0x01, // Ťė (U+0164 U+0117)
  0x01, 0x64, 0x01, 0x19, 0x01, // Ťę (U+0164 U+0119)
  0x01, 0x64, 0x01, 0x1B, 0x01, // Ťě (U+0164 U+011B)
  0x01, 0x64, 0x01, 0x1D, 0x01, // Ťĝ (U+0164 U+011D)
  0x01, 0x64, 0x01, 0x1F, 0x01, // Ťğ (U+0164 U+011F)
  0x01, 0x64, 0x01, 0x21, 0x01, // Ťġ (U+0164 U+0121)
  0x01, 0x64, 0x01, 0x23, 0x01, // Ťģ (U+0164 U+0123)
  0x01, 0x64, 0x01, 0x4D, 0x01, // Ťō (U+0164 U+014D)
  0x01, 0x64, 0x01, 0x4F, 0x01, // Ťŏ (U+0164 U+014F)
  0x01, 0x64, 0x01, 0x51, 0x01, // Ťő (U+0164 U+0151)
  0x01, 0x64, 0x01, 0x53, 0x01, // Ťœ (U+0164 U+0153)
  0x01, 0x64, 0x20, 0x1A, 0x02, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x02, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x02, // Ť… (U+0164 U+2026)
  0x01, 0x66, 0x00, 0x2C, 0x02, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2E, 0x02, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0x40, 0x01, // Ŧ@ (U+0166 U+0040)
  0x01, 0x66, 0x00, 0x41, 0x01, // ŦA (U+0166 U+0041)
  0x01, 0x66, 0x00, 0x61, 0x01, // Ŧa (U+0166 U+0061)
  0x01, 0x66, 0x00, 0x63, 0x01, // Ŧc (U+0166 U+0063)
  0x01, 0x66, 0x00, 0x64, 0x01, // Ŧd (U+0166 U+0064)
  0x01, 0x66, 0x00, 0x65, 0x01, // Ŧe (U+0166 U+0065)
  0x01, 0x66, 0x00, 0x67, 0x01, // Ŧg (U+0166 U+0067)
  0x01, 0x66, 0x00, 0x6F, 0x01, // Ŧo (U+0166 U+006F)
  0x01, 0x66, 0x00, 0x71, 0x01, // Ŧq (U+0166 U+0071)
  0x01, 0x66, 0x00, 0xC0, 0x01, // ŦÀ (U+0166 U+00C0)
  0x01, 0x66, 0x00, 0xC1, 0x01, // ŦÁ (U+0166 U+00C1)
  0x01, 0x66, 0x00, 0xC2, 0x01, // ŦÂ (U+0166 U+00C2)
  0x01, 0x66, 0x00, 0xC3, 0x01, // ŦÃ (U+0166 U+00C3)
  0x01, 0x66, 0x00, 0xC4, 0x01, // ŦÄ (U+0166 U+00C4)
  0x01, 0x66, 0x00, 0xC5, 0x01, // ŦÅ (U+0166 U+00C5)
  0x01, 0x66, 0x00, 0xC6, 0x01, // ŦÆ (U+0166 U+00C6)
  0x01, 0x66, 0x00, 0xE0, 0x01, // Ŧà (U+0166 U+00E0)
  0x01, 0x66, 0x00, 0xE1, 0x01, // Ŧá (U+0166 U+00E1)
  0x01, 0x66, 0x00, 0xE2, 0x01, // Ŧâ (U+0166 U+00E2)
  0x01, 0x66, 0x00, 0xE3, 0x01, // Ŧã (U+0166 U+00E3)
  0x01, 0x66, 0x00, 0xE4, 0x01, // Ŧä (U+0166 U+00E4)
  0x01, 0x66, 0x00, 0xE5, 0x01, // Ŧå (U+0166 U+00E5)
  0x01, 0x66, 0x00, 0xE6, 0x01, // Ŧæ (U+0166 U+00E6)
  0x01, 0x66, 0x00, 0xE7, 0x01, // Ŧç (U+0166 U+00E7)
  0x01, 0x66, 0x00, 0xE8, 0x01, // Ŧè (U+0166 U+00E8)
  0x01, 0x66, 0x00, 0xE9, 0x01, // Ŧé (U+0166 U+00E9)
  0x01, 0x66, 0x00, 0xEA, 0x01, // Ŧê (U+0166 U+00EA)
  0x01, 0x66, 0x00, 0xEB, 0x01, // Ŧë (U+0166 U+00EB)
  0x01, 0x66, 0x00, 0xF0, 0x01, // Ŧð (U+0166 U+00F0)
  0x01, 0x66, 0x00, 0xF2, 0x01, // Ŧò (U+0166 U+00F2)
  0x01, 0x66, 0x00, 0xF3, 0x01, // Ŧó (U+0166 U+00F3)
  0x01, 0x66, 0x00, 0xF4, 0x01, // Ŧô (U+0166 U+00F4)
  0x01, 0x66, 0x00, 0xF5, 0x01, // Ŧõ (U+0166 U+00F5)
  0x01, 0x66, 0x00, 0xF6, 0x01, // Ŧö (U+0166 U+00F6)
  0x01, 0x66, 0x00, 0xF8, 0x01, // Ŧø (U+0166 U+00F8)
  0x01, 0x66, 0x01, 0x00, 0x01, // ŦĀ (U+0166 U+0100)
  0x01, 0x66, 0x01, 0x01, 0x01, // Ŧā (U+0166 U+0101)
  0x01, 0x66, 0x01, 0x02, 0x01, // ŦĂ (U+0166 U+0102)
  0x01, 0x66, 0x01, 0x03, 0x01, // Ŧă (U+0166 U+0103)
  0x01, 0x66, 0x01, 0x04, 0x01, // ŦĄ (U+0166 U+0104)
  0x01, 0x66, 0x01, 0x05, 0x01, // Ŧą (U+0166 U+0105)
  0x01, 0x66, 0x01, 0x07, 0x01, // Ŧć (U+0166 U+0107)
  0x01, 0x66, 0x01, 0x09, 0x01, // Ŧĉ (U+0166 U+0109)
  0x01, 0x66, 0x01, 0x0B, 0x01, // Ŧċ (U+0166 U+010B)
  0x01, 0x66, 0x01, 0x0D, 0x01, // Ŧč (U+0166 U+010D)
  0x01, 0x66, 0x01, 0x0F, 0x01, // Ŧď (U+0166 U+010F)
  0x01, 0x66, 0x01, 0x11, 0x01, // Ŧđ (U+0166 U+0111)
  0x01, 0x66, 0x01, 0x13, 0x01, // Ŧē (U+0166 U+0113)
  0x01, 0x66, 0x01, 0x15, 0x01, // Ŧĕ (U+0166 U+0115)
  0x01, 0x66, 0x01, 0x17, 0x01, // Ŧė (U+0166 U+0117)
  0x01, 0x66, 0x01, 0x19, 0x01, // Ŧę (U+0166 U+0119)
  0x01, 0x66, 0x01, 0x1B, 0x01, // Ŧě (U+0166 U+011B)
  0x01, 0x66, 0x01, 0x1D, 0x01, // Ŧĝ (U+0166 U+011D)
  0x01, 0x66, 0x01, 0x1F, 0x01, // Ŧğ (U+0166 U+011F)
  0x01, 0x66, 0x01, 0x21, 0x01, // Ŧġ (U+0166 U+0121)
  0x01, 0x66, 0x01, 0x23, 0x01, // Ŧģ (U+0166 U+0123)
  0x01, 0x66, 0x01, 0x4D, 0x01, // Ŧō (U+0166 U+014D)
  0x01, 0x66, 0x01, 0x4F, 0x01, // Ŧŏ (U+0166 U+014F)
  0x01, 0x66, 0x01, 0x51, 0x01, // Ŧő (U+0166 U+0151)
  0x01, 0x66, 0x01, 0x53, 0x01, // Ŧœ (U+0166 U+0153)
  0x01, 0x66, 0x20, 0x1A, 0x02, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x02, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x02, // Ŧ… (U+0166 U+2026)
  0x01, 0x68, 0x00, 0xC6, 0x01, // ŨÆ (U+0168 U+00C6)
  0x01, 0x6A, 0x00, 0xC6, 0x01, // ŪÆ (U+016A U+00C6)
  0x01, 0x6C, 0x00, 0xC6, 0x01, // ŬÆ (U+016C U+00C6)
  0x01, 0x6E, 0x00, 0xC6, 0x01, // ŮÆ (U+016E U+00C6)
  0x01, 0x70, 0x00, 0xC6, 0x01, // ŰÆ (U+0170 U+00C6)
  0x01, 0x72, 0x00, 0xC6, 0x01, // ŲÆ (U+0172 U+00C6)
  0x01, 0x74, 0x00, 0x2C, 0x02, // Ŵ, (U+0174 U+002C)
  0x01, 0x74, 0x00, 0x2E, 0x02, // Ŵ. (U+0174 U+002E)
  0x01, 0x74, 0x00, 0x40, 0x01, // Ŵ@ (U+0174 U+0040)
  0x01, 0x74, 0x00, 0x41, 0x01, // ŴA (U+0174 U+0041)
  0x01, 0x74, 0x00, 0x61, 0x01, // Ŵa (U+0174 U+0061)
  0x01, 0x74, 0x00, 0x63, 0x01, // Ŵc (U+0174 U+0063)
  0x01, 0x74, 0x00, 0x64, 0x01, // Ŵd (U+0174 U+0064)
  0x01, 0x74, 0x00, 0x65, 0x01, // Ŵe (U+0174 U+0065)
  0x01, 0x74, 0x00, 0x67, 0x01, // Ŵg (U+0174 U+0067)
  0x01, 0x74, 0x00, 0x6F, 0x01, // Ŵo (U+0174 U+006F)
  0x01, 0x74, 0x00, 0x71, 0x01, // Ŵq (U+0174 U+0071)
  0x01, 0x74, 0x00, 0x73, 0x01, // Ŵs (U+0174 U+0073)
  0x01, 0x74, 0x00, 0x7A, 0x01, // Ŵz (U+0174 U+007A)
  0x01, 0x74, 0x00, 0xC0, 0x01, // ŴÀ (U+0174 U+00C0)
  0x01, 0x74, 0x00, 0xC1, 0x01, // ŴÁ (U+0174 U+00C1)
  0x01, 0x74, 0x00, 0xC2, 0x01, // ŴÂ (U+0174 U+00C2)
  0x01, 0x74, 0x00, 0xC3, 0x01, // ŴÃ (U+0174 U+00C3)
  0x01, 0x74, 0x00, 0xC4, 0x01, // ŴÄ (U+0174 U+00C4)
  0x01, 0x74, 0x00, 0xC5, 0x01, // ŴÅ (U+0174 U+00C5)
  0x01, 0x74, 0x00, 0xC6, 0x02, // ŴÆ (U+0174 U+00C6)
  0x01, 0x74, 0x00, 0xE0, 0x01, // Ŵà (U+0174 U+00E0)
  0x01, 0x74, 0x00, 0xE1, 0x01, // Ŵá (U+0174 U+00E1)
  0x01, 0x74, 0x00, 0xE2, 0x01, // Ŵâ (U+0174 U+00E2)
  0x01, 0x74, 0x00, 0xE3, 0x01, // Ŵã (U+0174 U+00E3)
  0x01, 0x74, 0x00, 0xE4, 0x01, // Ŵä (U+0174 U+00E4)
  0x01, 0x74, 0x00, 0xE5, 0x01, // Ŵå (U+0174 U+00E5)
  0x01, 0x74, 0x00, 0xE6, 0x01, // Ŵæ (U+0174 U+00E6)
  0x01, 0x74, 0x00, 0xE7, 0x01, // Ŵç (U+0174 U+00E7)
  0x01, 0x74, 0x00, 0xE8, 0x01, // Ŵè (U+0174 U+00E8)
  0x01, 0x74, 0x00, 0xE9, 0x01, // Ŵé (U+0174 U+00E9)
  0x01, 0x74, 0x00, 0xEA, 0x01, // Ŵê (U+0174 U+00EA)
  0x01, 0x74, 0x00, 0xEB, 0x01, // Ŵë (U+0174 U+00EB)
  0x01, 0x74, 0x00, 0xF0, 0x01, // Ŵð (U+0174 U+00F0)
  0x01, 0x74, 0x00, 0xF2, 0x01, // Ŵò (U+0174 U+00F2)
  0x01, 0x74, 0x00, 0xF3, 0x01, // Ŵó (U+0174 U+00F3)
  0x01, 0x74, 0x00, 0xF4, 0x01, // Ŵô (U+0174 U+00F4)
  0x01, 0x74, 0x00, 0xF5, 0x01, // Ŵõ (U+0174 U+00F5)
  0x01, 0x74, 0x00, 0xF6, 0x01, // Ŵö (U+0174 U+00F6)
  0x01, 0x74, 0x00, 0xF8, 0x01, // Ŵø (U+0174 U+00F8)
  0x01, 0x74, 0x01, 0x00, 0x01, // ŴĀ (U+0174 U+0100)
  0x01, 0x74, 0x01, 0x01, 0x01, // Ŵā (U+0174 U+0101)
  0x01, 0x74, 0x01, 0x02, 0x01, // ŴĂ (U+0174 U+0102)
  0x01, 0x74, 0x01, 0x03, 0x01, // Ŵă (U+0174 U+0103)
  0x01, 0x74, 0x01, 0x04, 0x01, // ŴĄ (U+0174 U+0104)
  0x01, 0x74, 0x01, 0x05, 0x01, // Ŵą (U+0174 U+0105)
  0x01, 0x74, 0x01, 0x07, 0x01, // Ŵć (U+0174 U+0107)
  0x01, 0x74, 0x01, 0x09, 0x01, // Ŵĉ (U+0174 U+0109)
  0x01, 0x74, 0x01, 0x0B, 0x01, // Ŵċ (U+0174 U+010B)
  0x01, 0x74, 0x01, 0x0D, 0x01, // Ŵč (U+0174 U+010D)
  0x01, 0x74, 0x01, 0x0F, 0x01, // Ŵď (U+0174 U+010F)
  0x01, 0x74, 0x01, 0x11, 0x01, // Ŵđ (U+0174 U+0111)
  0x01, 0x74, 0x01, 0x13, 0x01, // Ŵē (U+0174 U+0113)
  0x01, 0x74, 0x01, 0x15, 0x01, // Ŵĕ (U+0174 U+0115)
  0x01, 0x74, 0x01, 0x17, 0x01, // Ŵė (U+0174 U+0117)
  0x01, 0x74, 0x01, 0x19, 0x01, // Ŵę (U+0174 U+0119)
  0x01, 0x74, 0x01, 0x1B, 0x01, // Ŵě (U+0174 U+011B)
  0x01, 0x74, 0x01, 0x1D, 0x01, // Ŵĝ (U+0174 U+011D)
  0x01, 0x74, 0x01, 0x1F, 0x01, // Ŵğ (U+0174 U+011F)
  0x01, 0x74, 0x01, 0x21, 0x01, // Ŵġ (U+0174 U+0121)
  0x01, 0x74, 0x01, 0x23, 0x01, // Ŵģ (U+0174 U+0123)
  0x01, 0x74, 0x01, 0x4D, 0x01, // Ŵō (U+0174 U+014D)
  0x01, 0x74, 0x01, 0x4F, 0x01, // Ŵŏ (U+0174 U+014F)
  0x01, 0x74, 0x01, 0x51, 0x01, // Ŵő (U+0174 U+0151)
  0x01, 0x74, 0x01, 0x53, 0x01, // Ŵœ (U+0174 U+0153)
  0x01, 0x74, 0x01, 0x5B, 0x01, // Ŵś (U+0174 U+015B)
  0x01, 0x74, 0x01, 0x5D, 0x01, // Ŵŝ (U+0174 U+015D)
  0x01, 0x74, 0x01, 0x5F, 0x01, // Ŵş (U+0174 U+015F)
  0x01, 0x74, 0x01, 0x61, 0x01, // Ŵš (U+0174 U+0161)
  0x01, 0x74, 0x01, 0x7A, 0x01, // Ŵź (U+0174 U+017A)
  0x01, 0x74, 0x01, 0x7C, 0x01, // Ŵż (U+0174 U+017C)
  0x01, 0x74, 0x01, 0x7E, 0x01, // Ŵž (U+0174 U+017E)
  0x01, 0x74, 0x20, 0x1A, 0x02, // Ŵ‚ (U+0174 U+201A)
  0x01, 0x74, 0x20, 0x1E, 0x02, // Ŵ„ (U+0174 U+201E)
  0x01, 0x74, 0x20, 0x26, 0x02, // Ŵ… (U+0174 U+2026)
  0x01, 0x75, 0x00, 0x2C, 0x01, // ŵ, (U+0175 U+002C)
  0x01, 0x75, 0x00, 0x2E, 0x01, // ŵ. (U+0175 U+002E)
  0x01, 0x75, 0x00, 0x41, 0x01, // ŵA (U+0175 U+0041)
  0x01, 0x75, 0x00, 0xC0, 0x01, // ŵÀ (U+0175 U+00C0)
  0x01, 0x75, 0x00, 0xC1, 0x01, // ŵÁ (U+0175 U+00C1)
  0x01, 0x75, 0x00, 0xC2, 0x01, // ŵÂ (U+0175 U+00C2)
  0x01, 0x75, 0x00, 0xC3, 0x01, // ŵÃ (U+0175 U+00C3)
  0x01, 0x75, 0x00, 0xC4, 0x01, // ŵÄ (U+0175 U+00C4)
  0x01, 0x75, 0x00, 0xC5, 0x01, // ŵÅ (U+0175 U+00C5)
  0x01, 0x75, 0x01, 0x00, 0x01, // ŵĀ (U+0175 U+0100)
  0x01, 0x75, 0x01, 0x02, 0x01, // ŵĂ (U+0175 U+0102)
  0x01, 0x75, 0x01, 0x04, 0x01, // ŵĄ (U+0175 U+0104)
  0x01, 0x75, 0x20, 0x1A, 0x01, // ŵ‚ (U+0175 U+201A)
  0x01, 0x75, 0x20, 0x1E, 0x01, // ŵ„ (U+0175 U+201E)
  0x01, 0x75, 0x20, 0x26, 0x01, // ŵ… (U+0175 U+2026)
  0x01, 0x76, 0x00, 0x2C, 0x01, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x01, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x00, 0x40, 0x01, // Ŷ@ (U+0176 U+0040)
  0x01, 0x76, 0x00, 0x41, 0x01, // ŶA (U+0176 U+0041)
  0x01, 0x76, 0x00, 0x43, 0x01, // ŶC (U+0176 U+0043)
  0x01, 0x76, 0x00, 0x47, 0x01, // ŶG (U+0176 U+0047)
  0x01, 0x76, 0x00, 0x4F, 0x01, // ŶO (U+0176 U+004F)
  0x01, 0x76, 0x00, 0x51, 0x01, // ŶQ (U+0176 U+0051)
  0x01, 0x76, 0x00, 0x61, 0x01, // Ŷa (U+0176 U+0061)
  0x01, 0x76, 0x00, 0x63, 0x01, // Ŷc (U+0176 U+0063)
  0x01, 0x76, 0x00, 0x64, 0x01, // Ŷd (U+0176 U+0064)
  0x01, 0x76, 0x00, 0x65, 0x01, // Ŷe (U+0176 U+0065)
  0x01, 0x76, 0x00, 0x67, 0x01, // Ŷg (U+0176 U+0067)
  0x01, 0x76, 0x00, 0x6F, 0x01, // Ŷo (U+0176 U+006F)
  0x01, 0x76, 0x00, 0x71, 0x01, // Ŷq (U+0176 U+0071)
  0x01, 0x76, 0x00, 0x73, 0x01, // Ŷs (U+0176 U+0073)
  0x01, 0x76, 0x00, 0xC0, 0x01, // ŶÀ (U+0176 U+00C0)
  0x01, 0x76, 0x00, 0xC1, 0x01, // ŶÁ (U+0176 U+00C1)
  0x01, 0x76, 0x00, 0xC2, 0x01, // ŶÂ (U+0176 U+00C2)
  0x01, 0x76, 0x00, 0xC3, 0x01, // ŶÃ (U+0176 U+00C3)
  0x01, 0x76, 0x00, 0xC4, 0x01, // ŶÄ (U+0176 U+00C4)
  0x01, 0x76, 0x00, 0xC5, 0x01, // ŶÅ (U+0176 U+00C5)
  0x01, 0x76, 0x00, 0xC6, 0x02, // ŶÆ (U+0176 U+00C6)
  0x01, 0x76, 0x00, 0xC7, 0x01, // ŶÇ (U+0176 U+00C7)
  0x01, 0x76, 0x00, 0xD2, 0x01, // ŶÒ (U+0176 U+00D2)
  0x01, 0x76, 0x00, 0xD3, 0x01, // ŶÓ (U+0176 U+00D3)
  0x01, 0x76, 0x00, 0xD4, 0x01, // ŶÔ (U+0176 U+00D4)
  0x01, 0x76, 0x00, 0xD5, 0x01, // ŶÕ (U+0176 U+00D5)
  0x01, 0x76, 0x00, 0xD6, 0x01, // ŶÖ (U+0176 U+00D6)
  0x01, 0x76, 0x00, 0xD8, 0x01, // ŶØ (U+0176 U+00D8)
  0x01, 0x76, 0x00, 0xE0, 0x01, // Ŷà (U+0176 U+00E0)
  0x01, 0x76, 0x00, 0xE1, 0x01, // Ŷá (U+0176 U+00E1)
  0x01, 0x76, 0x00, 0xE2, 0x01, // Ŷâ (U+0176 U+00E2)
  0x01, 0x76, 0x00, 0xE3, 0x01, // Ŷã (U+0176 U+00E3)
  0x01, 0x76, 0x00, 0xE4, 0x01, // Ŷä (U+0176 U+00E4)
  0x01, 0x76, 0x00, 0xE5, 0x01, // Ŷå (U+0176 U+00E5)
  0x01, 0x76, 0x00, 0xE6, 0x01, // Ŷæ (U+0176 U+00E6)
  0x01, 0x76, 0x00, 0xE7, 0x01, // Ŷç (U+0176 U+00E7)
  0x01, 0x76, 0x00, 0xE8, 0x01, // Ŷè (U+0176 U+00E8)
  0x01, 0x76, 0x00, 0xE9, 0x01, // Ŷé (U+0176 U+00E9)
  0x01, 0x76, 0x00, 0xEA, 0x01, // Ŷê (U+0176 U+00EA)
  0x01, 0x76, 0x00, 0xEB, 0x01, // Ŷë (U+0176 U+00EB)
  0x01, 0x76, 0x00, 0xF0, 0x01, // Ŷð (U+0176 U+00F0)
  0x01, 0x76, 0x00, 0xF2, 0x01, // Ŷò (U+0176 U+00F2)
  0x01, 0x76, 0x00, 0xF3, 0x01, // Ŷó (U+0176 U+00F3)
  0x01, 0x76, 0x00, 0xF4, 0x01, // Ŷô (U+0176 U+00F4)
  0x01, 0x76, 0x00, 0xF5, 0x01, // Ŷõ (U+0176 U+00F5)
  0x01, 0x76, 0x00, 0xF6, 0x01, // Ŷö (U+0176 U+00F6)
  0x01, 0x76, 0x00, 0xF8, 0x01, // Ŷø (U+0176 U+00F8)
  0x01, 0x76, 0x01, 0x00, 0x01, // ŶĀ (U+0176 U+0100)
  0x01, 0x76, 0x01, 0x01, 0x01, // Ŷā (U+0176 U+0101)
  0x01, 0x76, 0x01, 0x02, 0x01, // ŶĂ (U+0176 U+0102)
  0x01, 0x76, 0x01, 0x03, 0x01, // Ŷă (U+0176 U+0103)
  0x01, 0x76, 0x01, 0x04, 0x01, // ŶĄ (U+0176 U+0104)
  0x01, 0x76, 0x01, 0x05, 0x01, // Ŷą (U+0176 U+0105)
  0x01, 0x76, 0x01, 0x06, 0x01, // ŶĆ (U+0176 U+0106)
  0x01, 0x76, 0x01, 0x07, 0x01, // Ŷć (U+0176 U+0107)
  0x01, 0x76, 0x01, 0x08, 0x01, // ŶĈ (U+0176 U+0108)
  0x01, 0x76, 0x01, 0x09, 0x01, // Ŷĉ (U+0176 U+0109)
  0x01, 0x76, 0x01, 0x0A, 0x01, // ŶĊ (U+0176 U+010A)
  0x01, 0x76, 0x01, 0x0B, 0x01, // Ŷċ (U+0176 U+010B)
  0x01, 0x76, 0x01, 0x0C, 0x01, // ŶČ (U+0176 U+010C)
  0x01, 0x76, 0x01, 0x0D, 0x01, // Ŷč (U+0176 U+010D)
  0x01, 0x76, 0x01, 0x0F, 0x01, // Ŷď (U+0176 U+010F)
  0x01, 0x76, 0x01, 0x11, 0x01, // Ŷđ (U+0176 U+0111)
  0x01, 0x76, 0x01, 0x13, 0x01, // Ŷē (U+0176 U+0113)
  0x01, 0x76, 0x01, 0x15, 0x01, // Ŷĕ (U+0176 U+0115)
  0x01, 0x76, 0x01, 0x17, 0x01, // Ŷė (U+0176 U+0117)
  0x01, 0x76, 0x01, 0x19, 0x01, // Ŷę (U+0176 U+0119)
  0x01, 0x76, 0x01, 0x1B, 0x01, // Ŷě (U+0176 U+011B)
  0x01, 0x76, 0x01, 0x1C, 0x01, // ŶĜ (U+0176 U+011C)
  0x01, 0x76, 0x01, 0x1D, 0x01, // Ŷĝ (U+0176 U+011D)
  0x01, 0x76, 0x01, 0x1E, 0x01, // ŶĞ (U+0176 U+011E)
  0x01, 0x76, 0x01, 0x1F, 0x01, // Ŷğ (U+0176 U+011F)
  0x01, 0x76, 0x01, 0x20, 0x01, // ŶĠ (U+0176 U+0120)
  0x01, 0x76, 0x01, 0x21, 0x01, // Ŷġ (U+0176 U+0121)
  0x01, 0x76, 0x01, 0x22, 0x01, // ŶĢ (U+0176 U+0122)
  0x01, 0x76, 0x01, 0x23, 0x01, // Ŷģ (U+0176 U+0123)
  0x01, 0x76, 0x01, 0x4C, 0x01, // ŶŌ (U+0176 U+014C)
  0x01, 0x76, 0x01, 0x4D, 0x01, // Ŷō (U+0176 U+014D)
  0x01, 0x76, 0x01, 0x4E, 0x01, // ŶŎ (U+0176 U+014E)
  0x01, 0x76, 0x01, 0x4F, 0x01, // Ŷŏ (U+0176 U+014F)
  0x01, 0x76, 0x01, 0x50, 0x01, // ŶŐ (U+0176 U+0150)
  0x01, 0x76, 0x01, 0x51, 0x01, // Ŷő (U+0176 U+0151)
  0x01, 0x76, 0x01, 0x52, 0x01, // ŶŒ (U+0176 U+0152)
  0x01, 0x76, 0x01, 0x53, 0x01, // Ŷœ (U+0176 U+0153)
  0x01, 0x76, 0x01, 0x5B, 0x01, // Ŷś (U+0176 U+015B)
  0x01, 0x76, 0x01, 0x5D, 0x01, // Ŷŝ (U+0176 U+015D)
  0x01, 0x76, 0x01, 0x5F, 0x01, // Ŷş (U+0176 U+015F)
  0x01, 0x76, 0x01, 0x61, 0x01, // Ŷš (U+0176 U+0161)
  0x01, 0x76, 0x20, 0x1A, 0x01, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x01, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x01, // Ŷ… (U+0176 U+2026)
  0x01, 0x77, 0x00, 0x2C, 0x02, // ŷ, (U+0177 U+002C)
  0x01, 0x77, 0x00, 0x2E, 0x02, // ŷ. (U+0177 U+002E)
  0x01, 0x77, 0x00, 0x41, 0x01, // ŷA (U+0177 U+0041)
  0x01, 0x77, 0x00, 0xC0, 0x01, // ŷÀ (U+0177 U+00C0)
  0x01, 0x77, 0x00, 0xC1, 0x01, // ŷÁ (U+0177 U+00C1)
  0x01, 0x77, 0x00, 0xC2, 0x01, // ŷÂ (U+0177 U+00C2)
  0x01, 0x77, 0x00, 0xC3, 0x01, // ŷÃ (U+0177 U+00C3)
  0x01, 0x77, 0x00, 0xC4, 0x01, // ŷÄ (U+0177 U+00C4)
  0x01, 0x77, 0x00, 0xC5, 0x01, // ŷÅ (U+0177 U+00C5)
  0x01, 0x77, 0x01, 0x00, 0x01, // ŷĀ (U+0177 U+0100)
  0x01, 0x77, 0x01, 0x02, 0x01, // ŷĂ (U+0177 U+0102)
  0x01, 0x77, 0x01, 0x04, 0x01, // ŷĄ (U+0177 U+0104)
  0x01, 0x77, 0x20, 0x1A, 0x02, // ŷ‚ (U+0177 U+201A)
  0x01, 0x77, 0x20, 0x1E, 0x02, // ŷ„ (U+0177 U+201E)
  0x01, 0x77, 0x20, 0x26, 0x02, // ŷ… (U+0177 U+2026)
  0x01, 0x78, 0x00, 0x2C, 0x01, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x01, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x00, 0x40, 0x01, // Ÿ@ (U+0178 U+0040)
  0x01, 0x78, 0x00, 0x41, 0x01, // ŸA (U+0178 U+0041)
  0x01, 0x78, 0x00, 0x43, 0x01, // ŸC (U+0178 U+0043)
  0x01, 0x78, 0x00, 0x47, 0x01, // ŸG (U+0178 U+0047)
  0x01, 0x78, 0x00, 0x4F, 0x01, // ŸO (U+0178 U+004F)
  0x01, 0x78, 0x00, 0x51, 0x01, // ŸQ (U+0178 U+0051)
  0x01, 0x78, 0x00, 0x61, 0x01, // Ÿa (U+0178 U+0061)
  0x01, 0x78, 0x00, 0x63, 0x01, // Ÿc (U+0178 U+0063)
  0x01, 0x78, 0x00, 0x64, 0x01, // Ÿd (U+0178 U+0064)
  0x01, 0x78, 0x00, 0x65, 0x01, // Ÿe (U+0178 U+0065)
  0x01, 0x78, 0x00, 0x67, 0x01, // Ÿg (U+0178 U+0067)
  0x01, 0x78, 0x00, 0x6F, 0x01, // Ÿo (U+0178 U+006F)
  0x01, 0x78, 0x00, 0x71, 0x01, // Ÿq (U+0178 U+0071)
  0x01, 0x78, 0x00, 0x73, 0x01, // Ÿs (U+0178 U+0073)
  0x01, 0x78, 0x00, 0xC0, 0x01, // ŸÀ (U+0178 U+00C0)
  0x01, 0x78, 0x00, 0xC1, 0x01, // ŸÁ (U+0178 U+00C1)
  0x01, 0x78, 0x00, 0xC2, 0x01, // ŸÂ (U+0178 U+00C2)
  0x01, 0x78, 0x00, 0xC3, 0x01, // ŸÃ (U+0178 U+00C3)
  0x01, 0x78, 0x00, 0xC4, 0x01, // ŸÄ (U+0178 U+00C4)
  0x01, 0x78, 0x00, 0xC5, 0x01, // ŸÅ (U+0178 U+00C5)
  0x01, 0x78, 0x00, 0xC6, 0x02, // ŸÆ (U+0178 U+00C6)
  0x01, 0x78, 0x00, 0xC7, 0x01, // ŸÇ (U+0178 U+00C7)
  0x01, 0x78, 0x00, 0xD2, 0x01, // ŸÒ (U+0178 U+00D2)
  0x01, 0x78, 0x00, 0xD3, 0x01, // ŸÓ (U+0178 U+00D3)
  0x01, 0x78, 0x00, 0xD4, 0x01, // ŸÔ (U+0178 U+00D4)
  0x01, 0x78, 0x00, 0xD5, 0x01, // ŸÕ (U+0178 U+00D5)
  0x01, 0x78, 0x00, 0xD6, 0x01, // ŸÖ (U+0178 U+00D6)
  0x01, 0x78, 0x00, 0xD8, 0x01, // ŸØ (U+0178 U+00D8)
  0x01, 0x78, 0x00, 0xE0, 0x01, // Ÿà (U+0178 U+00E0)
  0x01, 0x78, 0x00, 0xE1, 0x01, // Ÿá (U+0178 U+00E1)
  0x01, 0x78, 0x00, 0xE2, 0x01, // Ÿâ (U+0178 U+00E2)
  0x01, 0x78, 0x00, 0xE3, 0x01, // Ÿã (U+0178 U+00E3)
  0x01, 0x78, 0x00, 0xE4, 0x01, // Ÿä (U+0178 U+00E4)
  0x01, 0x78, 0x00, 0xE5, 0x01, // Ÿå (U+0178 U+00E5)
  0x01, 0x78, 0x00, 0xE6, 0x01, // Ÿæ (U+0178 U+00E6)
  0x01, 0x78, 0x00, 0xE7, 0x01, // Ÿç (U+0178 U+00E7)
  0x01, 0x78, 0x00, 0xE8, 0x01, // Ÿè (U+0178 U+00E8)
  0x01, 0x78, 0x00, 0xE9, 0x01, // Ÿé (U+0178 U+00E9)
  0x01, 0x78, 0x00, 0xEA, 0x01, // Ÿê (U+0178 U+00EA)
  0x01, 0x78, 0x00, 0xEB, 0x01, // Ÿë (U+0178 U+00EB)
  0x01, 0x78, 0x00, 0xF0, 0x01, // Ÿð (U+0178 U+00F0)
  0x01, 0x78, 0x00, 0xF2, 0x01, // Ÿò (U+0178 U+00F2)
  0x01, 0x78, 0x00, 0xF3, 0x01, // Ÿó (U+0178 U+00F3)
  0x01, 0x78, 0x00, 0xF4, 0x01, // Ÿô (U+0178 U+00F4)
  0x01, 0x78, 0x00, 0xF5, 0x01, // Ÿõ (U+0178 U+00F5)
  0x01, 0x78, 0x00, 0xF6, 0x01, // Ÿö (U+0178 U+00F6)
  0x01, 0x78, 0x00, 0xF8, 0x01, // Ÿø (U+0178 U+00F8)
  0x01, 0x78, 0x01, 0x00, 0x01, // ŸĀ (U+0178 U+0100)
  0x01, 0x78, 0x01, 0x01, 0x01, // Ÿā (U+0178 U+0101)
  0x01, 0x78, 0x01, 0x02, 0x01, // ŸĂ (U+0178 U+0102)
  0x01, 0x78, 0x01, 0x03, 0x01, // Ÿă (U+0178 U+0103)
  0x01, 0x78, 0x01, 0x04, 0x01, // ŸĄ (U+0178 U+0104)
  0x01, 0x78, 0x01, 0x05, 0x01, // Ÿą (U+0178 U+0105)
  0x01, 0x78, 0x01, 0x06, 0x01, // ŸĆ (U+0178 U+0106)
  0x01, 0x78, 0x01, 0x07, 0x01, // Ÿć (U+0178 U+0107)
  0x01, 0x78, 0x01, 0x08, 0x01, // ŸĈ (U+0178 U+0108)
  0x01, 0x78, 0x01, 0x09, 0x01, // Ÿĉ (U+0178 U+0109)
  0x01, 0x78, 0x01, 0x0A, 0x01, // ŸĊ (U+0178 U+010A)
  0x01, 0x78, 0x01, 0x0B, 0x01, // Ÿċ (U+0178 U+010B)
  0x01, 0x78, 0x01, 0x0C, 0x01, // ŸČ (U+0178 U+010C)
  0x01, 0x78, 0x01, 0x0D, 0x01, // Ÿč (U+0178 U+010D)
  0x01, 0x78, 0x01, 0x0F, 0x01, // Ÿď (U+0178 U+010F)
  0x01, 0x78, 0x01, 0x11, 0x01, // Ÿđ (U+0178 U+0111)
  0x01, 0x78, 0x01, 0x13, 0x01, // Ÿē (U+0178 U+0113)
  0x01, 0x78, 0x01, 0x15, 0x01, // Ÿĕ (U+0178 U+0115)
  0x01, 0x78, 0x01, 0x17, 0x01, // Ÿė (U+0178 U+0117)
  0x01, 0x78, 0x01, 0x19, 0x01, // Ÿę (U+0178 U+0119)
  0x01, 0x78, 0x01, 0x1B, 0x01, // Ÿě (U+0178 U+011B)
  0x01, 0x78, 0x01, 0x1C, 0x01, // ŸĜ (U+0178 U+011C)
  0x01, 0x78, 0x01, 0x1D, 0x01, // Ÿĝ (U+0178 U+011D)
  0x01, 0x78, 0x01, 0x1E, 0x01, // ŸĞ (U+0178 U+011E)
  0x01, 0x78, 0x01, 0x1F, 0x01, // Ÿğ (U+0178 U+011F)
  0x01, 0x78, 0x01, 0x20, 0x01, // ŸĠ (U+0178 U+0120)
  0x01, 0x78, 0x01, 0x21, 0x01, // Ÿġ (U+0178 U+0121)
  0x01, 0x78, 0x01, 0x22, 0x01, // ŸĢ (U+0178 U+0122)
  0x01, 0x78, 0x01, 0x23, 0x01, // Ÿģ (U+0178 U+0123)
  0x01, 0x78, 0x01, 0x4C, 0x01, // ŸŌ (U+0178 U+014C)
  0x01, 0x78, 0x01, 0x4D, 0x01, // Ÿō (U+0178 U+014D)
  0x01, 0x78, 0x01, 0x4E, 0x01, // ŸŎ (U+0178 U+014E)
  0x01, 0x78, 0x01, 0x4F, 0x01, // Ÿŏ (U+0178 U+014F)
  0x01, 0x78, 0x01, 0x50, 0x01, // ŸŐ (U+0178 U+0150)
  0x01, 0x78, 0x01, 0x51, 0x01, // Ÿő (U+0178 U+0151)
  0x01, 0x78, 0x01, 0x52, 0x01, // ŸŒ (U+0178 U+0152)
  0x01, 0x78, 0x01, 0x53, 0x01, // Ÿœ (U+0178 U+0153)
  0x01, 0x78, 0x01, 0x5B, 0x01, // Ÿś (U+0178 U+015B)
  0x01, 0x78, 0x01, 0x5D, 0x01, // Ÿŝ (U+0178 U+015D)
  0x01, 0x78, 0x01, 0x5F, 0x01, // Ÿş (U+0178 U+015F)
  0x01, 0x78, 0x01, 0x61, 0x01, // Ÿš (U+0178 U+0161)
  0x01, 0x78, 0x20, 0x1A, 0x01, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x01, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x01, // Ÿ… (U+0178 U+2026)
  0x20, 0x18, 0x00, 0x41, 0x01, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0xC0, 0x01, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x01, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x01, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x01, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x01, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x01, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xC6, 0x03, // ‘Æ (U+2018 U+00C6)
  0x20, 0x18, 0x01, 0x00, 0x01, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x02, 0x01, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x04, 0x01, // ‘Ą (U+2018 U+0104)
  0x20, 0x19, 0x00, 0x41, 0x02, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0x61, 0x01, // ’a (U+2019 U+0061)
  0x20, 0x19, 0x00, 0x63, 0x01, // ’c (U+2019 U+0063)
  0x20, 0x19, 0x00, 0x64, 0x01, // ’d (U+2019 U+0064)
  0x20, 0x19, 0x00, 0x65, 0x01, // ’e (U+2019 U+0065)
  0x20, 0x19, 0x00, 0x67, 0x01, // ’g (U+2019 U+0067)
  0x20, 0x19, 0x00, 0x6F, 0x01, // ’o (U+2019 U+006F)
  0x20, 0x19, 0x00, 0x71, 0x01, // ’q (U+2019 U+0071)
  0x20, 0x19, 0x00, 0x73, 0x01, // ’s (U+2019 U+0073)
  0x20, 0x19, 0x00, 0xC0, 0x02, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x02, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x02, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x02, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x02, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x02, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xE0, 0x01, // ’à (U+2019 U+00E0)
  0x20, 0x19, 0x00, 0xE1, 0x01, // ’á (U+2019 U+00E1)
  0x20, 0x19, 0x00, 0xE2, 0x01, // ’â (U+2019 U+00E2)
  0x20, 0x19, 0x00, 0xE3, 0x01, // ’ã (U+2019 U+00E3)
  0x20, 0x19, 0x00, 0xE4, 0x01, // ’ä (U+2019 U+00E4)
  0x20, 0x19, 0x00, 0xE5, 0x01, // ’å (U+2019 U+00E5)
  0x20, 0x19, 0x00, 0xE6, 0x01, // ’æ (U+2019 U+00E6)
  0x20, 0x19, 0x00, 0xE7, 0x01, // ’ç (U+2019 U+00E7)
  0x20, 0x19, 0x00, 0xE8, 0x01, // ’è (U+2019 U+00E8)
  0x20, 0x19, 0x00, 0xE9, 0x01, // ’é (U+2019 U+00E9)
  0x20, 0x19, 0x00, 0xEA, 0x01, // ’ê (U+2019 U+00EA)
  0x20, 0x19, 0x00, 0xEB, 0x01, // ’ë (U+2019 U+00EB)
  0x20, 0x19, 0x00, 0xF0, 0x01, // ’ð (U+2019 U+00F0)
  0x20, 0x19, 0x00, 0xF2, 0x01, // ’ò (U+2019 U+00F2)
  0x20, 0x19, 0x00, 0xF3, 0x01, // ’ó (U+2019 U+00F3)
  0x20, 0x19, 0x00, 0xF4, 0x01, // ’ô (U+2019 U+00F4)
  0x20, 0x19, 0x00, 0xF5, 0x01, // ’õ (U+2019 U+00F5)
  0x20, 0x19, 0x00, 0xF6, 0x01, // ’ö (U+2019 U+00F6)
  0x20, 0x19, 0x00, 0xF8, 0x01, // ’ø (U+2019 U+00F8)
  0x20, 0x19, 0x01, 0x00, 0x02, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x01, 0x01, // ’ā (U+2019 U+0101)
  0x20, 0x19, 0x01, 0x02, 0x02, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x03, 0x01, // ’ă (U+2019 U+0103)
  0x20, 0x19, 0x01, 0x04, 0x02, // ’Ą (U+2019 U+0104)
  0x20, 0x19, 0x01, 0x05, 0x01, // ’ą (U+2019 U+0105)
  0x20, 0x19, 0x01, 0x07, 0x01, // ’ć (U+2019 U+0107)
  0x20, 0x19, 0x01, 0x09, 0x01, // ’ĉ (U+2019 U+0109)
  0x20, 0x19, 0x01, 0x0B, 0x01, // ’ċ (U+2019 U+010B)
  0x20, 0x19, 0x01, 0x0D, 0x01, // ’č (U+2019 U+010D)
  0x20, 0x19, 0x01, 0x0F, 0x01, // ’ď (U+2019 U+010F)
  0x20, 0x19, 0x01, 0x11, 0x01, // ’đ (U+2019 U+0111)
  0x20, 0x19, 0x01, 0x13, 0x01, // ’ē (U+2019 U+0113)
  0x20, 0x19, 0x01, 0x15, 0x01, // ’ĕ (U+2019 U+0115)
  0x20, 0x19, 0x01, 0x17, 0x01, // ’ė (U+2019 U+0117)
  0x20, 0x19, 0x01, 0x19, 0x01, // ’ę (U+2019 U+0119)
  0x20, 0x19, 0x01, 0x1B, 0x01, // ’ě (U+2019 U+011B)
  0x20, 0x19, 0x01, 0x1D, 0x01, // ’ĝ (U+2019 U+011D)
  0x20, 0x19, 0x01, 0x1F, 0x01, // ’ğ (U+2019 U+011F)
  0x20, 0x19, 0x01, 0x21, 0x01, // ’ġ (U+2019 U+0121)
  0x20, 0x19, 0x01, 0x23, 0x01, // ’ģ (U+2019 U+0123)
  0x20, 0x19, 0x01, 0x4D, 0x01, // ’ō (U+2019 U+014D)
  0x20, 0x19, 0x01, 0x4F, 0x01, // ’ŏ (U+2019 U+014F)
  0x20, 0x19, 0x01, 0x51, 0x01, // ’ő (U+2019 U+0151)
  0x20, 0x19, 0x01, 0x53, 0x01, // ’œ (U+2019 U+0153)
  0x20, 0x19, 0x01, 0x5B, 0x01, // ’ś (U+2019 U+015B)
  0x20, 0x19, 0x01, 0x5D, 0x01, // ’ŝ (U+2019 U+015D)
  0x20, 0x19, 0x01, 0x5F, 0x01, // ’ş (U+2019 U+015F)
  0x20, 0x19, 0x01, 0x61, 0x01, // ’š (U+2019 U+0161)
  0x20, 0x1A, 0x00, 0x3F, 0x02, // ‚? (U+201A U+003F)
  0x20, 0x1A, 0x00, 0x54, 0x02, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x56, 0x02, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x02, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x01, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0x76, 0x01, // ‚v (U+201A U+0076)
  0x20, 0x1A, 0x00, 0x77, 0x01, // ‚w (U+201A U+0077)
  0x20, 0x1A, 0x00, 0x79, 0x01, // ‚y (U+201A U+0079)
  0x20, 0x1A, 0x00, 0xDD, 0x01, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x00, 0xFD, 0x01, // ‚ý (U+201A U+00FD)
  0x20, 0x1A, 0x00, 0xFF, 0x01, // ‚ÿ (U+201A U+00FF)
  0x20, 0x1A, 0x01, 0x62, 0x02, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x02, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x02, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1A, 0x01, 0x74, 0x02, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x75, 0x01, // ‚ŵ (U+201A U+0175)
  0x20, 0x1A, 0x01, 0x76, 0x01, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x77, 0x01, // ‚ŷ (U+201A U+0177)
  0x20, 0x1A, 0x01, 0x78, 0x01, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x01, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0xC0, 0x01, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x01, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x01, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x01, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x01, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x01, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xC6, 0x03, // “Æ (U+201C U+00C6)
  0x20, 0x1C, 0x01, 0x00, 0x01, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x02, 0x01, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x04, 0x01, // “Ą (U+201C U+0104)
  0x20, 0x1D, 0x00, 0x41, 0x02, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0x61, 0x01, // ”a (U+201D U+0061)
  0x20, 0x1D, 0x00, 0x63, 0x01, // ”c (U+201D U+0063)
  0x20, 0x1D, 0x00, 0x64, 0x01, // ”d (U+201D U+0064)
  0x20, 0x1D, 0x00, 0x65, 0x01, // ”e (U+201D U+0065)
  0x20, 0x1D, 0x00, 0x67, 0x01, // ”g (U+201D U+0067)
  0x20, 0x1D, 0x00, 0x6F, 0x01, // ”o (U+201D U+006F)
  0x20, 0x1D, 0x00, 0x71, 0x01, // ”q (U+201D U+0071)
  0x20, 0x1D, 0x00, 0x73, 0x01, // ”s (U+201D U+0073)
  0x20, 0x1D, 0x00, 0xC0, 0x02, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x02, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x02, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x02, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x02, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x02, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xE0, 0x01, // ”à (U+201D U+00E0)
  0x20, 0x1D, 0x00, 0xE1, 0x01, // ”á (U+201D U+00E1)
  0x20, 0x1D, 0x00, 0xE2, 0x01, // ”â (U+201D U+00E2)
  0x20, 0x1D, 0x00, 0xE3, 0x01, // ”ã (U+201D U+00E3)
  0x20, 0x1D, 0x00, 0xE4, 0x01, // ”ä (U+201D U+00E4)
  0x20, 0x1D, 0x00, 0xE5, 0x01, // ”å (U+201D U+00E5)
  0x20, 0x1D, 0x00, 0xE6, 0x01, // ”æ (U+201D U+00E6)
  0x20, 0x1D, 0x00, 0xE7, 0x01, // ”ç (U+201D U+00E7)
  0x20, 0x1D, 0x00, 0xE8, 0x01, // ”è (U+201D U+00E8)
  0x20, 0x1D, 0x00, 0xE9, 0x01, // ”é (U+201D U+00E9)
  0x20, 0x1D, 0x00, 0xEA, 0x01, // ”ê (U+201D U+00EA)
  0x20, 0x1D, 0x00, 0xEB, 0x01, // ”ë (U+201D U+00EB)
  0x20, 0x1D, 0x00, 0xF0, 0x01, // ”ð (U+201D U+00F0)
  0x20, 0x1D, 0x00, 0xF2, 0x01, // ”ò (U+201D U+00F2)
  0x20, 0x1D, 0x00, 0xF3, 0x01, // ”ó (U+201D U+00F3)
  0x20, 0x1D, 0x00, 0xF4, 0x01, // ”ô (U+201D U+00F4)
  0x20, 0x1D, 0x00, 0xF5, 0x01, // ”õ (U+201D U+00F5)
  0x20, 0x1D, 0x00, 0xF6, 0x01, // ”ö (U+201D U+00F6)
  0x20, 0x1D, 0x00, 0xF8, 0x01, // ”ø (U+201D U+00F8)
  0x20, 0x1D, 0x01, 0x00, 0x02, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x01, 0x01, // ”ā (U+201D U+0101)
  0x20, 0x1D, 0x01, 0x02, 0x02, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x03, 0x01, // ”ă (U+201D U+0103)
  0x20, 0x1D, 0x01, 0x04, 0x02, // ”Ą (U+201D U+0104)
  0x20, 0x1D, 0x01, 0x05, 0x01, // ”ą (U+201D U+0105)
  0x20, 0x1D, 0x01, 0x07, 0x01, // ”ć (U+201D U+0107)
  0x20, 0x1D, 0x01, 0x09, 0x01, // ”ĉ (U+201D U+0109)
  0x20, 0x1D, 0x01, 0x0B, 0x01, // ”ċ (U+201D U+010B)
  0x20, 0x1D, 0x01, 0x0D, 0x01, // ”č (U+201D U+010D)
  0x20, 0x1D, 0x01, 0x0F, 0x01, // ”ď (U+201D U+010F)
  0x20, 0x1D, 0x01, 0x11, 0x01, // ”đ (U+201D U+0111)
  0x20, 0x1D, 0x01, 0x13, 0x01, // ”ē (U+201D U+0113)
  0x20, 0x1D, 0x01, 0x15, 0x01, // ”ĕ (U+201D U+0115)
  0x20, 0x1D, 0x01, 0x17, 0x01, // ”ė (U+201D U+0117)
  0x20, 0x1D, 0x01, 0x19, 0x01, // ”ę (U+201D U+0119)
  0x20, 0x1D, 0x01, 0x1B, 0x01, // ”ě (U+201D U+011B)
  0x20, 0x1D, 0x01, 0x1D, 0x01, // ”ĝ (U+201D U+011D)
  0x20, 0x1D, 0x01, 0x1F, 0x01, // ”ğ (U+201D U+011F)
  0x20, 0x1D, 0x01, 0x21, 0x01, // ”ġ (U+201D U+0121)
  0x20, 0x1D, 0x01, 0x23, 0x01, // ”ģ (U+201D U+0123)
  0x20, 0x1D, 0x01, 0x4D, 0x01, // ”ō (U+201D U+014D)
  0x20, 0x1D, 0x01, 0x4F, 0x01, // ”ŏ (U+201D U+014F)
  0x20, 0x1D, 0x01, 0x51, 0x01, // ”ő (U+201D U+0151)
  0x20, 0x1D, 0x01, 0x53, 0x01, // ”œ (U+201D U+0153)
  0x20, 0x1D, 0x01, 0x5B, 0x01, // ”ś (U+201D U+015B)
  0x20, 0x1D, 0x01, 0x5D, 0x01, // ”ŝ (U+201D U+015D)
  0x20, 0x1D, 0x01, 0x5F, 0x01, // ”ş (U+201D U+015F)
  0x20, 0x1D, 0x01, 0x61, 0x01, // ”š (U+201D U+0161)
  0x20, 0x1E, 0x00, 0x3F, 0x02, // „? (U+201E U+003F)
  0x20, 0x1E, 0x00, 0x54, 0x02, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x56, 0x02, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x02, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x01, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0x76, 0x01, // „v (U+201E U+0076)
  0x20, 0x1E, 0x00, 0x77, 0x01, // „w (U+201E U+0077)
  0x20, 0x1E, 0x00, 0x79, 0x01, // „y (U+201E U+0079)
  0x20, 0x1E, 0x00, 0xDD, 0x01, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x00, 0xFD, 0x01, // „ý (U+201E U+00FD)
  0x20, 0x1E, 0x00, 0xFF, 0x01, // „ÿ (U+201E U+00FF)
  0x20, 0x1E, 0x01, 0x62, 0x02, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x02, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x02, // „Ŧ (U+201E U+0166)
  0x20, 0x1E, 0x01, 0x74, 0x02, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x75, 0x01, // „ŵ (U+201E U+0175)
  0x20, 0x1E, 0x01, 0x76, 0x01, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x77, 0x01, // „ŷ (U+201E U+0177)
  0x20, 0x1E, 0x01, 0x78, 0x01, // „Ÿ (U+201E U+0178)
  0x20, 0x26, 0x00, 0x3F, 0x02, // …? (U+2026 U+003F)
  0x20, 0x26, 0x00, 0x54, 0x02, // …T (U+2026 U+0054)
  0x20, 0x26, 0x00, 0x56, 0x02, // …V (U+2026 U+0056)
  0x20, 0x26, 0x00, 0x57, 0x02, // …W (U+2026 U+0057)
  0x20, 0x26, 0x00, 0x59, 0x01, // …Y (U+2026 U+0059)
  0x20, 0x26, 0x00, 0x76, 0x01, // …v (U+2026 U+0076)
  0x20, 0x26, 0x00, 0x77, 0x01, // …w (U+2026 U+0077)
  0x20, 0x26, 0x00, 0x79, 0x01, // …y (U+2026 U+0079)
  0x20, 0x26, 0x00, 0xDD, 0x01, // …Ý (U+2026 U+00DD)
  0x20, 0x26, 0x00, 0xFD, 0x01, // …ý (U+2026 U+00FD)
  0x20, 0x26, 0x00, 0xFF, 0x01, // …ÿ (U+2026 U+00FF)
  0x20, 0x26, 0x01, 0x62, 0x02, // …Ţ (U+2026 U+0162)
  0x20, 0x26, 0x01, 0x64, 0x02, // …Ť (U+2026 U+0164)
  0x20, 0x26, 0x01, 0x66, 0x02, // …Ŧ (U+2026 U+0166)
  0x20, 0x26, 0x01, 0x74, 0x02, // …Ŵ (U+2026 U+0174)
  0x20, 0x26, 0x01, 0x75, 0x01, // …ŵ (U+2026 U+0175)
  0x20, 0x26, 0x01, 0x76, 0x01, // …Ŷ (U+2026 U+0176)
  0x20, 0x26, 0x01, 0x77, 0x01, // …ŷ (U+2026 U+0177)
  0x20, 0x26, 0x01, 0x78, 0x01, // …Ÿ (U+2026 U+0178)
  
  // Glyph data
  // "!" (U+0021)
  0x1F, 0xFE, 0x0F, 0xFD, 0x0D, 0xFB, 0x0B, 0xF9, 0x0A, 0xF8, 0x08, 0xF6, 0x06, 0xF5, 0x05, 0xF3,
  0x03, 0xF1, 0x00, 0x00, 0x08, 0xD7, 0x0F, 0xFD, 0x0A, 0xF8,
  // """ (U+0022)
  0xBF, 0xE0, 0xCF, 0xD8, 0xFB, 0x09, 0xFA, 0x6F, 0x90, 0x7F, 0x83, 0xF6, 0x04, 0xF5, 0x1F, 0x40,
  0x2F, 0x30,
  // "#" (U+0023)
  0x38, 0x41, 0xF3, 0x0D, 0x54, 0x84, 0x4F, 0x01, 0xF2, 0x48, 0x37, 0xC0, 0x5E, 0x30, 0xEF, 0x89,
  0x18, 0x02, 0x2E, 0x72, 0xB9, 0x21, 0x39, 0x82, 0x30, 0xD5, 0x48, 0x43, 0xF1, 0x0F, 0x34, 0x84,
  0x6D, 0x03, 0xF1, 0x20, 0x7F, 0x91, 0x87, 0x12, 0xC9, 0x2A, 0xB2, 0x23, 0x83, 0xE5, 0x0C, 0x74,
  0x84, 0x1F, 0x20, 0xE5, 0x48, 0x44, 0xF0, 0x2F, 0x23,
  // "$" (U+0024)
  0x40, 0x60, 0x96, 0x85, 0x2B, 0xEF, 0xEA, 0x12, 0x86, 0x2E, 0xB6, 0xAC, 0xF9, 0x28, 0x69, 0xF7,
  0x69, 0x5D, 0x42, 0x83, 0xAF, 0xC7, 0x95, 0x07, 0xB0, 0xB6, 0x0B, 0xB0, 0xE0, 0x65, 0x05, 0x0D,
  0xB0, 0x75, 0x81, 0x6C, 0xEA, 0x28, 0x4B, 0x90, 0x69, 0x3A, 0x89, 0x01, 0x1F, 0xD0, 0x69, 0x0F,
  0xE2, 0x86, 0xCF, 0x76, 0x97, 0xF7, 0x20, 0x10, 0xAB, 0x0D, 0x06, 0x60, 0x70, 0x97, 0x10, 0x60,
  0x97, 0x10, 0x20, 0x44,
  // "%" (U+0025)
  0x18, 0x32, 0xBF, 0xE8, 0x40, 0xB0, 0xA5, 0x84, 0xCF, 0x58, 0xF7, 0x28, 0x12, 0xF3, 0x48, 0x52,
  0xFC, 0x01, 0xFD, 0x20, 0xA0, 0xB5, 0x81, 0x5F, 0xA2, 0xA1, 0x81, 0x2F, 0x35, 0x81, 0x5F, 0xA2,
  0xA1, 0x09, 0x0C, 0x68, 0x95, 0x3F, 0xB0, 0x1F, 0xE1, 0xF4, 0x5D, 0xEC, 0x42, 0x8A, 0x0D, 0xF2,
  0x6F, 0x89, 0xC3, 0xFC, 0x3D, 0xF1, 0x03, 0xDA, 0x89, 0x1B, 0x2F, 0x59, 0xF6, 0x07, 0xF7, 0x38,
  0x93, 0x11, 0x08, 0xD0, 0xBF, 0x40, 0x5F, 0x95, 0x89, 0x11, 0xE6, 0x0B, 0xF4, 0x06, 0xF9, 0x50,
  0x70, 0xD2, 0x85, 0x9F, 0x50, 0x7F, 0x75, 0x0E, 0x06, 0x28, 0x53, 0xFC, 0x3D, 0xF1, 0x40, 0x70,
  0xE4, 0x83, 0x5D, 0xFD, 0x41,
  // "&" (U+0026)
  0x38, 0x44, 0xBE, 0xEC, 0x57, 0x10, 0x2A, 0x83, 0x73, 0xDF, 0x47, 0x06, 0xA2, 0x81, 0x9F, 0x87,
  0x04, 0xA8, 0x32, 0x0A, 0xF5, 0x71, 0x84, 0xDF, 0xB5, 0xE7, 0x72, 0x06, 0xB8, 0x13, 0x04, 0xB0,
  0xA2, 0x82, 0x1A, 0xFD, 0xA8, 0x5C, 0x04, 0xFE, 0x51, 0x28, 0x3B, 0xFD, 0x06, 0xA8, 0x2B, 0x5F,
  0x73, 0x01, 0xA0, 0x92, 0x07, 0xA8, 0x1E, 0xF2, 0x30, 0x1A, 0x08, 0x30, 0x7A, 0x0D, 0x58, 0x1E,
  0xFC, 0x40, 0xAA, 0x09, 0x40, 0x6A, 0x84, 0x93, 0x38, 0xFB, 0xA0, 0xA0, 0x33, 0x87, 0x4B, 0xEF,
  0xDA, 0x20, 0xBB, 0x02,
  // "'" (U+0027)
  0xBF, 0xE8, 0xFB, 0x6F, 0x93, 0xF6, 0x1F, 0x40,
  // "(" (U+0028)
  0x40, 0x50, 0x72, 0x87, 0x1B, 0xF5, 0x01, 0xDF, 0x52, 0x81, 0xBF, 0xB2, 0x03, 0xA0, 0x52, 0x09,
  0xA0, 0x22, 0x0C, 0xA3, 0x0E, 0xA3, 0x81, 0xEF, 0xE3, 0x0D, 0xA3, 0x0B, 0xA0, 0x12, 0x07, 0xA0,
  0x32, 0x82, 0x1E, 0xF7, 0x38, 0x17, 0xFE, 0x48, 0x19, 0xFA, 0x48, 0x15, 0xE8, 0x50, 0x30,
  // ")" (U+0029)
  0x05, 0x07, 0x58, 0x22, 0xED, 0x34, 0x82, 0x2F, 0xE3, 0x48, 0x18, 0xFD, 0x40, 0x2A, 0x07, 0x48,
  0x1E, 0xFC, 0x40, 0xDA, 0x40, 0xCA, 0x01, 0x30, 0xBA, 0x02, 0x30, 0xCA, 0x01, 0x38, 0x1D, 0xFE,
  0x4A, 0x0A, 0x30, 0x5A, 0x04, 0x38, 0x1B, 0xFA, 0x38, 0x17, 0xFB, 0x38, 0x15, 0xF7, 0x40, 0x20,
  0x15,
  // "*" (U+002A)
  0x38, 0x15, 0xF6, 0x48, 0x79, 0x32, 0xF3, 0x39, 0x02, 0xA8, 0x17, 0xE8, 0xA8, 0xB1, 0x30, 0x18,
  0xEF, 0xE8, 0x10, 0x2E, 0xF9, 0xE9, 0xFE, 0x30, 0xA4, 0x2F, 0x34, 0xA4, 0x81, 0x5F, 0x63,
  // "+" (U+002B)
  0x30, 0x90, 0xA6, 0x09, 0x0A, 0x60, 0x90, 0xA6, 0x09, 0x0A, 0x30, 0xCE, 0x84, 0xD2, 0x22, 0xAB,
  0x0F, 0x23, 0x09, 0x0A, 0x60, 0x90, 0xA3,
  // "," (U+002C)
  0x09, 0xE6, 0x0D, 0xFE, 0x04, 0xEE, 0x00, 0xB9, 0x1A, 0xC1, 0x15, 0x00,
  // "-" (U+002D)
  0x7E, 0xEE, 0xE1, 0x8F, 0xFF, 0xF1,
  // "." (U+002E)
  0x6D, 0x90, 0xCF, 0xF1, 0x7E, 0xB0,
  // "/" (U+002F)
  0x38, 0x13, 0xF1, 0x30, 0x60, 0xC4, 0x0A, 0x09, 0x40, 0xE0, 0x53, 0x81, 0x2F, 0x13, 0x06, 0x0D,
  0x40, 0xA0, 0x94, 0x0E, 0x05, 0x38, 0x12, 0xF1, 0x30, 0x60, 0xD4, 0x0A, 0x09, 0x40, 0xD0, 0x63,
  0x81, 0x2F, 0x23, 0x06, 0x0D, 0x40, 0x90, 0xA4, 0x0D, 0x06, 0x40,
  // "0" (U+0030)
  0x00, 0x3B, 0xEE, 0xB3, 0x00, 0x03, 0xFF, 0x54, 0xFF, 0x30, 0x0B, 0xFB, 0x00, 0xAF, 0xB0, 0x1F,
  0xF8, 0x00, 0x7F, 0xF1, 0x3F, 0xF7, 0x00, 0x6F, 0xF4, 0x5F, 0xF6, 0x00, 0x5F, 0xF6, 0x5F, 0xF6,
  0x00, 0x5F, 0xF6, 0x5F, 0xF6, 0x00, 0x5F, 0xF6, 0x3F, 0xF7, 0x00, 0x6F, 0xF4, 0x0F, 0xF8, 0x00,
  0x7F, 0xF1, 0x0B, 0xFB, 0x00, 0xAF, 0xB0, 0x03, 0xEF, 0x54, 0xFE, 0x30, 0x00, 0x3B, 0xEE, 0xB3,
  0x00,
  // "1" (U+0031)
  0x38, 0x21, 0xCF, 0xC5, 0x06, 0x0E, 0xA0, 0xC3, 0x85, 0x2E, 0xF7, 0xDF, 0xC4, 0x84, 0x75, 0x0D,
  0xFC, 0x78, 0x1D, 0xFC, 0x78, 0x1D, 0xFC, 0x78, 0x1D, 0xFC, 0x78, 0x1D, 0xFC, 0x78, 0x1D, 0xFC,
  0x78, 0x1D, 0xFC, 0x78, 0x1D, 0xFC, 0x50, 0x20, 0x4A, 0x81, 0xE3, 0x22, 0x03, 0xF0, 0x20,
  // "2" (U+0032)
  0x18, 0x52, 0x9D, 0xFE, 0xB4, 0x28, 0x41, 0xEF, 0xB3, 0x8A, 0x81, 0x50, 0x3A, 0x03, 0x2A, 0x0B,
  0x20, 0xC9, 0x3A, 0x0A, 0x30, 0x22, 0x02, 0xA0, 0x66, 0x81, 0x7F, 0xB6, 0x82, 0x1E, 0xD1, 0x68,
  0x1C, 0xD1, 0x68, 0x1B, 0xD1, 0x68, 0x1B, 0xC1, 0x38, 0x4B, 0x20, 0xBC, 0x13, 0x82, 0x6F, 0x35,
  0xF9, 0x02, 0x05, 0xF9, 0x02,
  // "3" (U+0033)
  0x18, 0x52, 0xAD, 0xFD, 0xB3, 0x28, 0x41, 0xEF, 0xA3, 0x9A, 0x81, 0x40, 0x4A, 0x81, 0x20, 0x1A,
  0x0B, 0x20, 0xA9, 0x3A, 0x0A, 0x60, 0x2A, 0x05, 0x58, 0x22, 0xBF, 0x74, 0x06, 0xB0, 0x90, 0x24,
  0x82, 0x12, 0x4A, 0xA0, 0x67, 0x0C, 0xA8, 0x11, 0x03, 0x40, 0x8A, 0x82, 0x35, 0xF3, 0x30, 0xBA,
  0x85, 0x15, 0xFC, 0x43, 0x7A, 0x07, 0x28, 0x55, 0xCE, 0xFD, 0xA4, 0x20,
  // "4" (U+0034)
  0x48, 0x21, 0xEF, 0xD6, 0x09, 0xA0, 0xD5, 0x83, 0x3D, 0xBF, 0xD5, 0x83, 0xD5, 0xBF, 0xD4, 0x84,
  0x7B, 0x0C, 0xFD, 0x38, 0x52, 0xE2, 0x0C, 0xFD, 0x30, 0xB0, 0x72, 0x81, 0xCF, 0xD2, 0x06, 0x0C,
  0x38, 0x1C, 0xFD, 0x20, 0xBF, 0x98, 0x91, 0xB1, 0x22, 0x22, 0xCF, 0xD2, 0x15, 0x81, 0xCF, 0xD5,
  0x01, 0x05, 0xB0, 0x50, 0x13, 0x0B, 0xD0, 0x80,
  // "5" (U+0035)
  0x10, 0x6E, 0x07, 0x20, 0x7E, 0x07, 0x20, 0x90, 0xB4, 0x0B, 0x08, 0x20, 0x0A, 0x40, 0x02, 0x20,
  0xB0, 0x97, 0x18, 0x5D, 0xDE, 0xED, 0xA2, 0x38, 0x34, 0x53, 0x3B, 0xA0, 0x57, 0x81, 0xDF, 0xD7,
  0x0A, 0xA8, 0x11, 0x03, 0x40, 0xAA, 0x18, 0x12, 0xF5, 0x38, 0x93, 0xDF, 0xC0, 0x1F, 0xD4, 0x3A,
  0xFE, 0x32, 0x85, 0x4B, 0xEF, 0xD8, 0x22,
  // "6" (U+0036)
  0x00, 0x04, 0xBE, 0xEC, 0x40, 0x00, 0x7F, 0xB3, 0x9F, 0xF0, 0x03, 0xFE, 0x10, 0x2F, 0xD0, 0x09,
  0xFA, 0x00, 0x04, 0x00, 0x0E, 0xF7, 0x00, 0x00, 0x00, 0x1F, 0xFA, 0xCE, 0xD9, 0x10, 0x2F, 0xFD,
  0x43, 0xDF, 0xB0, 0x2F, 0xF5, 0x00, 0x5F, 0xF3, 0x1F, 0xF6, 0x00, 0x3F, 0xF6, 0x0D, 0xF8, 0x00,
  0x3F, 0xF5, 0x08, 0xFD, 0x00, 0x5F, 0xF2, 0x01, 0xDF, 0x83, 0xCF, 0x90, 0x00, 0x19, 0xDF, 0xD7,
  0x00,
  // "7" (U+0037)
  0x02, 0xF9, 0x07, 0x02, 0xF9, 0x82, 0x32, 0xF3, 0x38, 0x42, 0xFC, 0x02, 0xB4, 0x81, 0x9F, 0x66,
  0x81, 0x1F, 0xE7, 0x81, 0x7F, 0x97, 0x81, 0xDF, 0x26, 0x81, 0x5F, 0xB7, 0x81, 0xCF, 0x56, 0x81,
  0x3F, 0xE7, 0x81, 0xAF, 0x86, 0x01, 0xA0, 0x16, 0x81, 0x8F, 0xA5,
  // "8" (U+0038)
  0x00, 0x6C, 0xEE, 0xC5, 0x00, 0x07, 0xFE, 0x44, 0xEF, 0x60, 0x0E, 0xF9, 0x00, 0x7F, 0xD0, 0x0F,
  0xF8, 0x00, 0x5F, 0xE0, 0x0B, 0xFD, 0x10, 0x8F, 0x80, 0x02, 0xEF, 0xE9, 0xE7, 0x00, 0x00, 0x3F,
  0xFF, 0xE6, 0x00, 0x06, 0xFD, 0x5B, 0xFF, 0xA0, 0x2F, 0xF3, 0x00, 0x7F, 0xF4, 0x6F, 0xF0, 0x00,
  0x0F, 0xF7, 0x4F, 0xF2, 0x00, 0x2F, 0xF5, 0x0C, 0xFC, 0x33, 0xCF, 0xC0, 0x00, 0x8D, 0xFE, 0xC7,
  0x00,
  // "9" (U+0039)
  0x00, 0x5C, 0xEE, 0x91, 0x00, 0x06, 0xFE, 0x46, 0xFD, 0x10, 0x0E, 0xF7, 0x00, 0xBF, 0x90, 0x4F,
  0xF4, 0x00, 0x7F, 0xE0, 0x5F, 0xF3, 0x00, 0x5F, 0xF2, 0x3F, 0xF5, 0x00, 0x4F, 0xF3, 0x0C, 0xFC,
  0x11, 0xCF, 0xF3, 0x02, 0xBF, 0xFD, 0x9F, 0xF2, 0x00, 0x00, 0x10, 0x6F, 0xE0, 0x00, 0x00, 0x00,
  0x9F, 0xA0, 0x08, 0x30, 0x00, 0xEF, 0x40, 0x0B, 0xD4, 0x3A, 0xF8, 0x00, 0x02, 0xBE, 0xEC, 0x50,
  0x00,
  // ":" (U+003A)
  0x83, 0x6E, 0xC0, 0xAA, 0x82, 0x24, 0xDA, 0x77, 0x38, 0x35, 0xDA, 0x0A, 0xA8, 0x22, 0x6E, 0xC1,
  // ";" (U+003B)
  0x83, 0x6E, 0xC0, 0xAA, 0x82, 0x25, 0xDA, 0x77, 0x01, 0x28, 0x37, 0xFB, 0x0A, 0xA8, 0x94, 0x21,
  0xCF, 0x10, 0x8B, 0x0B, 0xC2, 0x04, 0x30,
  // "<" (U+003C)
  0x60, 0x30, 0xA4, 0x82, 0x2B, 0xF9, 0x28, 0x91, 0x19, 0xFB, 0x20, 0x18, 0xFC, 0x43, 0x81, 0xCF,
  0x85, 0x83, 0x2A, 0xFA, 0x25, 0x83, 0x3B, 0xF9, 0x15, 0x82, 0x4C, 0xE7, 0x60, 0x50, 0xB0,
  // "=" (U+003D)
  0x0D, 0xE0, 0xE8, 0x04, 0x27, 0x72, 0x0D, 0xE0, 0xE8, 0x04, 0x20,
  // ">" (U+003E)
  0x0A, 0x04, 0x68, 0x28, 0xFB, 0x35, 0x83, 0x2A, 0xFA, 0x25, 0x83, 0x3C, 0xF8, 0x15, 0x81, 0x7F,
  0xD3, 0x89, 0x11, 0x9F, 0xA2, 0x01, 0x8F, 0xC3, 0x28, 0x26, 0xED, 0x54, 0x0B, 0x06, 0x60,
  // "?" (U+003F)
  0x18, 0x74, 0xBE, 0xFE, 0xA3, 0x02, 0xA8, 0x1B, 0x38, 0xA8, 0x34, 0x2E, 0xF4, 0x2A, 0x83, 0xB0,
  0x14, 0x12, 0xA0, 0xD5, 0x03, 0xA0, 0x95, 0x82, 0xCF, 0xD1, 0x38, 0x33, 0xDF, 0x91, 0x48, 0x16,
  0xF4, 0x68, 0x13, 0xB1, 0x77, 0x18, 0x19, 0xD6, 0x6A, 0x0C, 0x68, 0x1A, 0xE7, 0x30,
  // "@" (U+0040)
  0x48, 0x61, 0x7B, 0xEF, 0xEB, 0x66, 0x89, 0x17, 0xFD, 0x73, 0x23, 0x7E, 0xD2, 0x38, 0x1A, 0xF7,
  0x68, 0xC7, 0x1C, 0xD1, 0x08, 0xF6, 0x01, 0x9E, 0xEA, 0x94, 0x2F, 0x72, 0xFB, 0x02, 0xEF, 0x63,
  0xDF, 0x10, 0xBB, 0x9F, 0x30, 0xBF, 0x72, 0x00, 0xE2, 0x84, 0x9D, 0xDE, 0x03, 0xA8, 0x31, 0x01,
  0xFC, 0x28, 0x69, 0xCF, 0xB0, 0x6F, 0xD2, 0x81, 0x5F, 0x92, 0x86, 0xBA, 0xFB, 0x06, 0xFC, 0x28,
  0xA5, 0x9F, 0x70, 0x1F, 0x5F, 0xC0, 0x2F, 0xE1, 0x2B, 0xEA, 0x0A, 0xB0, 0xB9, 0x28, 0x94, 0x6E,
  0xFC, 0x15, 0xEF, 0xA1, 0x05, 0xF7, 0x30, 0x17, 0x28, 0x1B, 0xF4, 0x71, 0x03, 0x48, 0x3B, 0xFA,
  0x41, 0x28, 0x23, 0x7D, 0x75, 0x81, 0x4B, 0xEB, 0x81, 0xD9, 0x27, 0x28, 0x11, 0x21, 0x60,
  // "A" (U+0041)
  0x50, 0x8A, 0x04, 0x73, 0x0D, 0xA0, 0x97, 0x28, 0x34, 0xFB, 0xFE, 0x72, 0x81, 0xAC, 0x6A, 0x05,
  0x71, 0x90, 0x70, 0x2A, 0x0A, 0x78, 0x36, 0xF2, 0x0D, 0xA0, 0x16, 0x0B, 0x0C, 0x20, 0x8A, 0x06,
  0x58, 0x12, 0xF7, 0x20, 0x3A, 0x0B, 0x50, 0x7F, 0x90, 0x14, 0x85, 0xDC, 0x22, 0x22, 0x9A, 0x07,
  0x38, 0x14, 0xF5, 0x40, 0x2A, 0x0D, 0x28, 0x33, 0xCF, 0x61, 0x30, 0x3B, 0x81, 0x71, 0xEB, 0x0B,
  0x20, 0x6D, 0x08,
  // "B" (U+0042)
  0x07, 0xE8, 0x1D, 0x93, 0x28, 0x11, 0x3E, 0xA8, 0x12, 0x4C, 0xA0, 0x43, 0x0C, 0xA2, 0x03, 0xA0,
  0xB3, 0x0C, 0xA2, 0x02, 0xA0, 0xD3, 0x0C, 0xA2, 0x03, 0xA0, 0xB3, 0x0C, 0xA1, 0x83, 0x1B, 0xFE,
  0x33, 0x0C, 0xD0, 0xE0, 0x34, 0x0C, 0xA8, 0x12, 0x37, 0xA0, 0x73, 0x0C, 0xA3, 0x0B, 0xA0, 0x32,
  0x0C, 0xA3, 0x09, 0xA0, 0x62, 0x0C, 0xA3, 0x0B, 0xA8, 0x24, 0x13, 0xEA, 0x81, 0x22, 0x6A, 0x81,
  0xC0, 0x7E, 0x81, 0xEC, 0x72,
  // "C" (U+0043)
  0x28, 0x61, 0x7C, 0xEF, 0xEA, 0x32, 0x85, 0x2D, 0xF9, 0x33, 0xBA, 0x83, 0x20, 0xDF, 0xB3, 0x02,
  0xA0, 0x20, 0x6A, 0x05, 0x48, 0x29, 0x40, 0xBA, 0x02, 0x70, 0xEA, 0x71, 0xB7, 0x10, 0xEA, 0x71,
  0x0C, 0xA0, 0x27, 0x07, 0xA0, 0x57, 0x18, 0x1D, 0xFC, 0x58, 0x93, 0x52, 0x03, 0xDF, 0xB4, 0x23,
  0x9E, 0x12, 0x86, 0x17, 0xCE, 0xFE, 0xA2, 0x10,
  // "D" (U+0044)
  0x07, 0xE8, 0x1E, 0xB6, 0x38, 0x11, 0x3E, 0xA8, 0x52, 0x26, 0xEF, 0xC1, 0x30, 0xCA, 0x30, 0x2A,
  0x0C, 0x30, 0xCA, 0x40, 0x9A, 0x05, 0x20, 0xCA, 0x40, 0x5A, 0x09, 0x20, 0xCA, 0x40, 0x4A, 0x0B,
  0x20, 0xCA, 0x40, 0x3A, 0x0C, 0x20, 0xCA, 0x40, 0x4A, 0x0A, 0x20, 0xCA, 0x40, 0x7A, 0x07, 0x20,
  0xCA, 0x40, 0xBA, 0x02, 0x20, 0xCA, 0x30, 0x4A, 0x83, 0x90, 0x13, 0xEA, 0x84, 0x23, 0x7E, 0xFA,
  0x20, 0x7E, 0x81, 0xDB, 0x53,
  // "E" (U+0045)
  0x07, 0xC0, 0xFE, 0xA0, 0x73, 0x0E, 0xA3, 0x81, 0x2F, 0x83, 0x0C, 0xA4, 0x0C, 0x08, 0x30, 0xCA,
  0x40, 0x50, 0x43, 0x0C, 0xA7, 0x20, 0xCA, 0x72, 0x0C, 0xE0, 0x44, 0x0C, 0xA0, 0x30, 0xF2, 0x50,
  0xCA, 0x72, 0x0C, 0xA5, 0x02, 0x30, 0xCA, 0x48, 0x12, 0xF2, 0x20, 0xEA, 0x48, 0x28, 0xF1, 0x7C,
  0x80, 0x0E, 0xA0, 0x10,
  // "F" (U+0046)
  0x07, 0xFA, 0x82, 0x71, 0x3E, 0xA0, 0xF2, 0x81, 0x5F, 0x72, 0x0C, 0xA4, 0x0C, 0x08, 0x20, 0xCA,
  0x40, 0x40, 0x32, 0x0C, 0xA7, 0x10, 0xCA, 0x71, 0x0C, 0xE0, 0x43, 0x0C, 0xA8, 0x00, 0x24, 0x0C,
  0xA7, 0x10, 0xCA, 0x71, 0x0C, 0xA6, 0x81, 0x13, 0xEA, 0x05, 0x02, 0x40, 0x7E, 0x01, 0x30,
  // "G" (U+0047)
  0x38, 0x15, 0xBD, 0xA8, 0x1D, 0x92, 0x38, 0x91, 0x1C, 0xFC, 0x52, 0x5D, 0xFE, 0x12, 0x81, 0xCF,
  0xD4, 0x05, 0xA8, 0x11, 0x06, 0xA0, 0x64, 0x81, 0x18, 0x32, 0x0B, 0xA0, 0x27, 0x20, 0xEA, 0x73,
  0xB7, 0x30, 0xEA, 0x01, 0x20, 0x4D, 0x05, 0x0B, 0xA0, 0x23, 0x04, 0x0E, 0xA8, 0x16, 0x06, 0xA0,
  0x74, 0x0C, 0xA3, 0x82, 0xDF, 0xD1, 0x30, 0xCA, 0x38, 0x62, 0xCF, 0xC5, 0x22, 0xDA, 0x58, 0x66,
  0xBD, 0xFE, 0xC9, 0x42,
  // "H" (U+0048)
  0x07, 0xD0, 0xB1, 0xE8, 0x23, 0x13, 0xEA, 0x83, 0x51, 0x02, 0x9A, 0x0C, 0x02, 0x30, 0xCA, 0x40,
  0x4A, 0x08, 0x40, 0xCA, 0x40, 0x4A, 0x08, 0x40, 0xCA, 0x40, 0x4A, 0x08, 0x40, 0xCA, 0x40, 0x4A,
  0x08, 0x40, 0xCF, 0xA0, 0x84, 0x0C, 0xA8, 0x00, 0x20, 0x6A, 0x08, 0x40, 0xCA, 0x40, 0x4A, 0x08,
  0x40, 0xCA, 0x40, 0x4A, 0x08, 0x40, 0xCA, 0x40, 0x4A, 0x08, 0x28, 0x11, 0x3E, 0xA8, 0x35, 0x10,
  0x28, 0xA8, 0x2B, 0x20, 0x7D, 0x0B, 0x1E, 0x03,
  // "I" (U+0049)
  0x07, 0xD8, 0x2B, 0x13, 0xEA, 0x05, 0x01, 0x20, 0xCA, 0x40, 0xCA, 0x40, 0xCA, 0x40, 0xCA, 0x40,
  0xCA, 0x40, 0xCA, 0x40, 0xCA, 0x40, 0xCA, 0x40, 0xCA, 0x28, 0x11, 0x3E, 0xA8, 0x15, 0x17, 0xD0,
  0xB0,
  // "J" (U+004A)
  0x10, 0x7D, 0x83, 0xB0, 0x13, 0xEA, 0x06, 0x01, 0x30, 0xCA, 0x01, 0x40, 0xCA, 0x01, 0x40, 0xCA,
  0x01, 0x40, 0xCA, 0x01, 0x40, 0xCA, 0x01, 0x40, 0xCA, 0x01, 0x40, 0xCA, 0x01, 0x40, 0xCA, 0x01,
  0x40, 0xCA, 0x01, 0x40, 0xCA, 0x01, 0x40, 0xCA, 0x50, 0xDA, 0x40, 0x1A, 0x0B, 0x38, 0x33, 0xCF,
  0xE3, 0x28, 0x35, 0xFD, 0x92, 0x30,
  // "K" (U+004B)
  0x07, 0xD0, 0xB0, 0x2C, 0x83, 0xA0, 0x13, 0xEA, 0x82, 0x51, 0x06, 0xA0, 0x80, 0x23, 0x0C, 0xA3,
  0x81, 0x7F, 0x55, 0x0C, 0xA2, 0x81, 0x4F, 0x66, 0x0C, 0xA1, 0x81, 0x3E, 0x77, 0x0C, 0xA8, 0x12,
  0xEE, 0x71, 0x0C, 0xA0, 0xDA, 0x07, 0x70, 0xCA, 0x07, 0x0E, 0xA0, 0x26, 0x0C, 0xA1, 0x06, 0xA0,
  0xC6, 0x0C, 0xA2, 0x0C, 0xA0, 0x75, 0x0C, 0xA2, 0x03, 0xB0, 0x22, 0x81, 0x13, 0xEA, 0x82, 0x51,
  0x09, 0xA8, 0x2D, 0x40, 0x7D, 0x0B, 0x20, 0x80, 0xDA, 0x03,
  // "L" (U+004C)
  0x07, 0xD0, 0xA7, 0x0E, 0xA0, 0x37, 0x10, 0xCA, 0x72, 0x0C, 0xA7, 0x20, 0xCA, 0x72, 0x0C, 0xA7,
  0x20, 0xCA, 0x72, 0x0C, 0xA7, 0x20, 0xCA, 0x72, 0x0C, 0xA5, 0x0E, 0x02, 0x20, 0xCA, 0x48, 0x12,
  0xF1, 0x20, 0xEA, 0x48, 0x29, 0xF1, 0x7C, 0x0F, 0xEB, 0x10,
  // "M" (U+004D)
  0x07, 0xC0, 0xD5, 0x09, 0xC8, 0x29, 0x13, 0xEB, 0x03, 0x40, 0xEB, 0x04, 0x01, 0x20, 0xC0, 0xDA,
  0x08, 0x38, 0x34, 0xFD, 0xFE, 0x48, 0x3C, 0x8E, 0xFD, 0x38, 0x39, 0xBC, 0xFE, 0x48, 0x1C, 0x89,
  0xA0, 0x32, 0x83, 0xE6, 0xCF, 0xE4, 0x81, 0xC8, 0x4A, 0x86, 0x80, 0x4F, 0x1C, 0xFE, 0x48, 0x93,
  0xC8, 0x0E, 0xFD, 0x09, 0xB0, 0xCF, 0xE4, 0x82, 0xC8, 0x09, 0xA8, 0x53, 0xE5, 0x0C, 0xFE, 0x48,
  0x2C, 0x80, 0x3A, 0x85, 0xCF, 0x10, 0xCF, 0xE4, 0x0C, 0x08, 0x20, 0xDA, 0x0B, 0x28, 0x1C, 0xFE,
  0x40, 0xC0, 0x82, 0x08, 0xA0, 0x52, 0x81, 0xCF, 0xE2, 0x85, 0x13, 0xEC, 0x20, 0x3A, 0x82, 0x10,
  0x3E, 0xA8, 0x14, 0x17, 0xC2, 0x82, 0xDB, 0x01, 0xD0, 0x90,
  // "N" (U+004E)
  0x07, 0xB0, 0xC4, 0x0C, 0xB8, 0x2D, 0x13, 0xEA, 0x08, 0x38, 0x31, 0x6F, 0x71, 0x20, 0xCB, 0x04,
  0x38, 0x12, 0xF3, 0x30, 0xC0, 0xBA, 0x0D, 0x01, 0x28, 0x12, 0xF3, 0x38, 0x1C, 0x88, 0xA0, 0xA2,
  0x81, 0x2F, 0x33, 0x82, 0xC8, 0x0C, 0xA8, 0x35, 0x02, 0xF3, 0x38, 0x91, 0xC8, 0x02, 0xEF, 0xE1,
  0x2F, 0x33, 0x0C, 0x08, 0x20, 0x6A, 0x82, 0xB2, 0xF3, 0x30, 0xC0, 0x83, 0x0A, 0xA8, 0x19, 0xF3,
  0x30, 0xC0, 0x83, 0x01, 0x0D, 0xB0, 0x33, 0x0C, 0x08, 0x40, 0x3B, 0x85, 0x30, 0x13, 0xEB, 0x24,
  0x08, 0xA8, 0x13, 0x07, 0xC0, 0x34, 0x81, 0xCF, 0x31,
  // "O" (U+004F)
  0x28, 0x61, 0x7C, 0xEE, 0xD8, 0x24, 0x89, 0x03, 0xEF, 0xA3, 0x28, 0xFE, 0x42, 0x82, 0x1D, 0xFB,
  0x48, 0x49, 0xFE, 0x10, 0x7A, 0x05, 0x40, 0x3A, 0x81, 0x90, 0xCA, 0x02, 0x5A, 0x81, 0xE0, 0xEA,
  0x60, 0xDA, 0x01, 0xB6, 0x0D, 0xA0, 0x20, 0xEA, 0x60, 0xDA, 0x01, 0x0C, 0xA0, 0x25, 0xA8, 0x1E,
  0x07, 0xA0, 0x54, 0x03, 0xA0, 0x92, 0x81, 0xDF, 0xB4, 0x82, 0x9F, 0xE1, 0x28, 0x90, 0x3E, 0xFA,
  0x32, 0x8F, 0xE4, 0x48, 0x61, 0x7C, 0xEE, 0xD8, 0x13,
  // "P" (U+0050)
  0x07, 0xE8, 0x5D, 0x92, 0x01, 0x3E, 0xA8, 0x42, 0x4D, 0xFE, 0x22, 0x0C, 0xA2, 0x04, 0xA0, 0xA2,
  0x0C, 0xA2, 0x01, 0xA0, 0xD2, 0x0C, 0xA2, 0x02, 0xA0, 0xD2, 0x0C, 0xA2, 0x04, 0xA0, 0x92, 0x0C,
  0xA1, 0x83, 0x2C, 0xFE, 0x12, 0x0C, 0xC8, 0x1E, 0x91, 0x30, 0xCA, 0x02, 0x01, 0x60, 0xCA, 0x71,
  0x0C, 0xA6, 0x81, 0x13, 0xEA, 0x05, 0x02, 0x40, 0x7E, 0x01, 0x30,
  // "Q" (U+0051)
  0x28, 0x61, 0x7C, 0xEE, 0xD8, 0x24, 0x89, 0x03, 0xEF, 0xA3, 0x28, 0xFE, 0x42, 0x82, 0x1D, 0xFB,
  0x48, 0x49, 0xFE, 0x20, 0x7A, 0x05, 0x40, 0x2A, 0x81, 0x90, 0xCA, 0x02, 0x5A, 0x81, 0xE0, 0xEA,
  0x60, 0xDA, 0x01, 0xB6, 0x0D, 0xA0, 0x20, 0xEA, 0x60, 0xDA, 0x01, 0x0C, 0xA0, 0x25, 0xA8, 0x1E,
  0x07, 0xA0, 0x64, 0x03, 0xA8, 0x49, 0x01, 0xEF, 0xC4, 0x82, 0xAF, 0xE1, 0x28, 0x90, 0x3E, 0xFB,
  0x54, 0xAF, 0xE3, 0x48, 0x11, 0x7C, 0xA8, 0x1E, 0x71, 0x70, 0x1A, 0x0E, 0x73, 0x0B, 0xA0, 0x37,
  0x28, 0x43, 0xEF, 0xD5, 0x17, 0x18, 0x32, 0x9D, 0xFA, 0x20,
  // "R" (U+0052)
  0x07, 0xE8, 0x1E, 0xB6, 0x38, 0x11, 0x3E, 0xA8, 0x12, 0x39, 0xA0, 0xA4, 0x0C, 0xA3, 0x0E, 0xA0,
  0x13, 0x0C, 0xA3, 0x0C, 0xA0, 0x33, 0x0C, 0xA3, 0x81, 0xEF, 0xE4, 0x0C, 0xA2, 0x07, 0xA0, 0x44,
  0x0C, 0xD0, 0xE0, 0x25, 0x0C, 0xA0, 0x20, 0x9A, 0x04, 0x50, 0xCA, 0x10, 0x1A, 0x0D, 0x50, 0xCA,
  0x20, 0x9A, 0x06, 0x40, 0xCA, 0x28, 0x71, 0xEF, 0xE1, 0x01, 0x3E, 0xA8, 0x25, 0x10, 0x7A, 0x81,
  0xB2, 0x7D, 0x0B, 0x28, 0x27, 0xDF, 0xC0,
  // "S" (U+0053)
  0x28, 0x53, 0xAE, 0xFE, 0xB2, 0x28, 0x65, 0xFC, 0x33, 0xDF, 0xE2, 0x81, 0xDF, 0x42, 0x83, 0x5F,
  0xE0, 0x1A, 0x07, 0x28, 0x11, 0x72, 0x28, 0x2E, 0xFE, 0x66, 0x07, 0xB0, 0xD0, 0x75, 0x06, 0x0E,
  0xB0, 0xE0, 0x44, 0x81, 0x17, 0xDB, 0x02, 0x20, 0x13, 0x08, 0xA8, 0x28, 0x2D, 0xA4, 0x84, 0xDF,
  0x96, 0xFE, 0x48, 0x2D, 0xF5, 0x2A, 0x84, 0xB3, 0x39, 0xFA, 0x28, 0x53, 0xAE, 0xFE, 0xB6, 0x20,
  // "T" (U+0054)
  0x0B, 0xFB, 0x84, 0x7B, 0xD3, 0x29, 0xA8, 0x56, 0x25, 0xF8, 0xC7, 0x20, 0x8A, 0x04, 0x28, 0x2B,
  0x86, 0x32, 0x08, 0xA0, 0x42, 0x05, 0x04, 0x40, 0x8A, 0x04, 0x71, 0x08, 0xA0, 0x47, 0x10, 0x8A,
  0x04, 0x71, 0x08, 0xA0, 0x47, 0x10, 0x8A, 0x04, 0x71, 0x08, 0xA0, 0x47, 0x10, 0x8A, 0x04, 0x70,
  0x20, 0xBA, 0x09, 0x02, 0x50, 0x3E, 0x30,
  // "U" (U+0055)
  0x0B, 0xD8, 0x17, 0x08, 0xC8, 0x12, 0x15, 0xA8, 0x7E, 0x31, 0x01, 0x3F, 0xB2, 0x3A, 0x0C, 0x50,
  0xD0, 0x74, 0xA0, 0xC5, 0x0D, 0x07, 0x4A, 0x0C, 0x50, 0xD0, 0x74, 0xA0, 0xC5, 0x0D, 0x07, 0x4A,
  0x0C, 0x50, 0xD0, 0x74, 0xA0, 0xC5, 0x0D, 0x07, 0x4A, 0x0C, 0x50, 0xD0, 0x74, 0xA0, 0xD5, 0x0E,
  0x06, 0x40, 0xCA, 0x01, 0x38, 0x12, 0xF4, 0x40, 0x4A, 0x84, 0xC4, 0x24, 0xDB, 0x68, 0x13, 0x9D,
  0xA0, 0xD0, 0x84,
  // "V" (U+0056)
  0xD8, 0x1E, 0x01, 0xC8, 0x18, 0x2C, 0xA0, 0x90, 0x22, 0x85, 0x29, 0xF5, 0x10, 0x4A, 0x08, 0x40,
  0x90, 0xC4, 0x81, 0xEF, 0xD4, 0x0E, 0x07, 0x40, 0x9A, 0x03, 0x28, 0x14, 0xF1, 0x40, 0x3A, 0x08,
  0x20, 0x90, 0xB6, 0x81, 0xDF, 0xD2, 0x0E, 0x06, 0x60, 0x8A, 0x82, 0x34, 0xF1, 0x60, 0x3A, 0x81,
  0x89, 0xB7, 0x18, 0x3D, 0xFC, 0xD5, 0x71, 0x07, 0xB7, 0x20, 0x2A, 0x0A, 0x73, 0x81, 0xCF, 0x55,
  // "W" (U+0057)
  0xE3, 0x81, 0x9F, 0x12, 0x07, 0xC8, 0x13, 0x3C, 0xA0, 0xB0, 0x23, 0x81, 0xDF, 0x62, 0x83, 0x14,
  0xFE, 0x32, 0x05, 0xA0, 0x93, 0x02, 0xA0, 0xB4, 0x90, 0x83, 0x01, 0xA0, 0xD3, 0x07, 0xB0, 0x12,
  0x81, 0x3F, 0x34, 0x0B, 0xA0, 0x22, 0x0C, 0x0E, 0xA0, 0x72, 0x07, 0x0E, 0x50, 0x7A, 0x83, 0x60,
  0x1F, 0x6A, 0x0C, 0x20, 0x0B, 0x50, 0x2A, 0x84, 0xB0, 0x5F, 0x0A, 0xA8, 0x22, 0x0E, 0x66, 0x0D,
  0xA1, 0x82, 0xAB, 0x05, 0xA8, 0x27, 0x3F, 0x26, 0x08, 0xA8, 0x14, 0xE6, 0x28, 0x3E, 0xFC, 0x6E,
  0x70, 0x3A, 0x81, 0xBF, 0x12, 0x09, 0xA0, 0xB0, 0x97, 0x10, 0xEA, 0x0C, 0x30, 0x3B, 0x05, 0x71,
  0x09, 0xA0, 0x74, 0x0D, 0xA0, 0x17, 0x10, 0x5A, 0x02, 0x48, 0x18, 0xFD, 0x50,
  // "X" (U+0058)
  0x06, 0xD8, 0x18, 0x09, 0xB8, 0x28, 0x15, 0xEA, 0x86, 0x91, 0x01, 0xBF, 0x71, 0x20, 0x6A, 0x0B,
  0x30, 0xD0, 0x95, 0x0B, 0xA8, 0x25, 0x09, 0xC6, 0x85, 0x2E, 0xFE, 0x6E, 0x27, 0x07, 0xB0, 0x57,
  0x20, 0xDA, 0x05, 0x71, 0x05, 0x0E, 0xA0, 0xE0, 0x16, 0x82, 0x2E, 0x57, 0xA0, 0xA5, 0x81, 0x1D,
  0x82, 0x0B, 0xA0, 0x54, 0x0B, 0x0D, 0x30, 0x2A, 0x86, 0xE1, 0x02, 0xAF, 0xB1, 0x20, 0x20, 0xDA,
  0x81, 0xC3, 0xCB, 0x0B, 0x20, 0xED,
  // "Y" (U+0059)
  0xE1, 0x03, 0xC8, 0x17, 0x3D, 0xA0, 0xC0, 0x32, 0x85, 0x3C, 0xF7, 0x10, 0x4A, 0x0B, 0x40, 0xB0,
  0xC4, 0x0B, 0xA0, 0x32, 0x81, 0x2F, 0x44, 0x03, 0xA0, 0xB2, 0x09, 0x0B, 0x60, 0xAA, 0x82, 0x32,
  0xF3, 0x60, 0x2A, 0x81, 0xA9, 0xA7, 0x10, 0x9A, 0x0E, 0x02, 0x71, 0x03, 0xA0, 0xB7, 0x20, 0x2A,
  0x0A, 0x72, 0x02, 0xA0, 0xA7, 0x10, 0x20, 0x7A, 0x81, 0xD3, 0x16, 0xE0, 0x93,
  // "Z" (U+005A)
  0x10, 0xCF, 0x90, 0xC2, 0x85, 0xDD, 0x21, 0x11, 0xCA, 0x06, 0x20, 0xD0, 0x83, 0x05, 0xA0, 0xC3,
  0x0A, 0x04, 0x20, 0x10, 0xEA, 0x03, 0x70, 0x9A, 0x09, 0x70, 0x3A, 0x0E, 0x01, 0x70, 0xCA, 0x05,
  0x70, 0x6A, 0x0B, 0x70, 0x10, 0xEA, 0x02, 0x70, 0xAA, 0x07, 0x38, 0x31, 0xB2, 0x04, 0xA0, 0xD4,
  0x83, 0x4F, 0x20, 0xDA, 0x87, 0x51, 0x11, 0x2C, 0xF2, 0x3F, 0xB0, 0x10,
  // "[" (U+005B)
  0x3F, 0xFF, 0xFC, 0x3F, 0xFC, 0x31, 0x3F, 0xF8, 0x00, 0x3F, 0xF8, 0x00, 0x3F, 0xF8, 0x00, 0x3F,
  0xF8, 0x00, 0x3F, 0xF8, 0x00, 0x3F, 0xF8, 0x00, 0x3F, 0xF8, 0x00, 0x3F, 0xF8, 0x00, 0x3F, 0xF8,
  0x00, 0x3F, 0xF8, 0x00, 0x3F, 0xF8, 0x00, 0x3F, 0xF8, 0x00, 0x3F, 0xFB, 0x10, 0x3F, 0xFF, 0xFB,
  0x02, 0x22, 0x21,
  // "\" (U+005C)
  0x0D, 0x06, 0x40, 0x90, 0xA4, 0x06, 0x0D, 0x48, 0x12, 0xF2, 0x40, 0xE0, 0x54, 0x0A, 0x09, 0x40,
  0x60, 0xD4, 0x81, 0x2F, 0x14, 0x0E, 0x05, 0x40, 0xA0, 0x94, 0x06, 0x0D, 0x48, 0x13, 0xF1, 0x40,
  0xE0, 0x54, 0x0B, 0x09, 0x40, 0x70, 0xC4, 0x81, 0x3F, 0x10,
  // "]" (U+005D)
  0x5F, 0xFF, 0xFA, 0x02, 0x7F, 0xFA, 0x00, 0x1F, 0xFA, 0x00, 0x1F, 0xFA, 0x00, 0x1F, 0xFA, 0x00,
  0x1F, 0xFA, 0x00, 0x1F, 0xFA, 0x00, 0x1F, 0xFA, 0x00, 0x1F, 0xFA, 0x00, 0x1F, 0xFA, 0x00, 0x1F,
  0xFA, 0x00, 0x1F, 0xFA, 0x00, 0x1F, 0xFA, 0x00, 0x1F, 0xFA, 0x00, 0x5F, 0xFA, 0x5F, 0xFF, 0xFA,
  0x02, 0x22, 0x21,
  // "^" (U+005E)
  0x30, 0x30, 0x46, 0x0C, 0x0D, 0x50, 0x4A, 0x04, 0x48, 0x2B, 0x99, 0xB3, 0x84, 0x2F, 0x32, 0xF3,
  0x20, 0x90, 0xB2, 0x84, 0xBA, 0x01, 0xF5, 0x28, 0x34, 0xF1, 0x7D, 0x48, 0x2D, 0x8E, 0x74, 0x06,
  0x0E,
  // "_" (U+005F)
  0x01, 0xF9, 0x05, 0x18, 0x04, 0x21,
  // "`" (U+0060)
  0x1D, 0xFC, 0x00, 0x02, 0xDF, 0x60, 0x00, 0x09, 0xE2,
  // "a" (U+0061)
  0x28, 0x57, 0xCE, 0xFD, 0x81, 0x30, 0x5A, 0x83, 0x73, 0xEF, 0xA3, 0x81, 0x2B, 0xD2, 0x81, 0xBF,
  0xE7, 0x10, 0xAA, 0x38, 0x21, 0x8D, 0xEC, 0x30, 0xBA, 0x81, 0x62, 0xBA, 0x20, 0x1A, 0x0A, 0x20,
  0xAA, 0x20, 0x1A, 0x09, 0x20, 0xDA, 0x38, 0x4D, 0xFD, 0x37, 0xCA, 0x05, 0x28, 0x42, 0xBE, 0xD5,
  0x4B, 0x03,
  // "b" (U+0062)
  0x0A, 0xB0, 0x86, 0x02, 0x09, 0xA0, 0x87, 0x03, 0xA0, 0x87, 0x03, 0xA0, 0x87, 0x03, 0xA8, 0x47,
  0x8E, 0xFC, 0x32, 0x03, 0xA8, 0x7E, 0x73, 0xBF, 0xE1, 0x03, 0xA0, 0xC2, 0x03, 0xA8, 0x17, 0x03,
  0xA0, 0x93, 0xA8, 0x1B, 0x03, 0xA0, 0x83, 0xA8, 0x1C, 0x03, 0xA0, 0x83, 0xA8, 0x1C, 0x03, 0xA0,
  0x93, 0xA8, 0x1B, 0x03, 0xA0, 0xD2, 0x03, 0xA8, 0x17, 0x19, 0xA8, 0x6D, 0x73, 0xBF, 0xE1, 0xAA,
  0x85, 0xD0, 0x9E, 0xFB, 0x31,
  // "c" (U+0063)
  0x28, 0x73, 0xAE, 0xFD, 0x91, 0x03, 0xA8, 0x78, 0x3E, 0xFA, 0x0B, 0xFE, 0x28, 0x19, 0xF9, 0x1A,
  0x0B, 0x28, 0x23, 0x50, 0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x6A, 0x0B, 0x68, 0x1B, 0xFE, 0x48, 0x14,
  0x03, 0xA8, 0x3A, 0x33, 0xAA, 0x28, 0x53, 0xAE, 0xFD, 0x91,
  // "d" (U+0064)
  0x50, 0x7B, 0x0D, 0x70, 0x10, 0x5A, 0x0D, 0x72, 0x81, 0xDF, 0xD7, 0x28, 0x1D, 0xFD, 0x48, 0x66,
  0xDF, 0xD5, 0xCF, 0xD3, 0x06, 0xA8, 0x48, 0x3B, 0xEF, 0xD3, 0x81, 0xDF, 0xD2, 0x02, 0xA0, 0xD3,
  0xA0, 0xA3, 0xA0, 0xD2, 0x02, 0xA0, 0x93, 0x81, 0xEF, 0xD2, 0x02, 0xA0, 0x93, 0x81, 0xEF, 0xD2,
  0x01, 0xA0, 0xA3, 0xA0, 0xD3, 0x81, 0xDF, 0xD2, 0x02, 0xA0, 0xD3, 0x06, 0xA8, 0x27, 0x3B, 0xDA,
  0x05, 0x01, 0x28, 0x46, 0xDF, 0xD6, 0x3B, 0x06,
  // "e" (U+0065)
  0x28, 0x42, 0xAE, 0xFD, 0x73, 0x86, 0x2E, 0xF8, 0x3C, 0xFB, 0x28, 0x1B, 0xFD, 0x20, 0x6A, 0x03,
  0x1A, 0x0B, 0x20, 0x4A, 0x07, 0x01, 0xF9, 0x07, 0x02, 0xA0, 0xA8, 0x01, 0x20, 0x11, 0xA0, 0xB7,
  0x0A, 0xA0, 0x13, 0x05, 0x28, 0x62, 0xEF, 0xC3, 0x38, 0xE3, 0x85, 0x2A, 0xEF, 0xEB, 0x31,
  // "f" (U+0066)
  0x38, 0x47, 0xDF, 0xEC, 0x42, 0x85, 0x7F, 0xE3, 0xCF, 0x92, 0x84, 0xDF, 0xC0, 0x35, 0x3A, 0x0B,
  0x40, 0x9E, 0x82, 0x30, 0x12, 0xA8, 0x1C, 0x22, 0x4A, 0x0B, 0x6A, 0x0B, 0x6A, 0x0B, 0x6A, 0x0B,
  0x6A, 0x0B, 0x6A, 0x0B, 0x40, 0x10, 0x6A, 0x81, 0xE4, 0x12, 0x0A, 0xD0, 0xD2,
  // "g" (U+0067)
  0x78, 0x17, 0xEA, 0x28, 0x96, 0x8D, 0xFE, 0xDB, 0xAC, 0x09, 0xFC, 0x39, 0xFB, 0x38, 0x3E, 0xF6,
  0x03, 0xA0, 0x32, 0xA8, 0x16, 0x02, 0xA0, 0x32, 0x85, 0xBF, 0xB0, 0x7F, 0xE3, 0x01, 0x0B, 0xB0,
  0xC0, 0x33, 0x82, 0x3E, 0x52, 0x68, 0x4C, 0xF4, 0x22, 0x14, 0x09, 0xD0, 0xE0, 0x72, 0x05, 0x0E,
  0xE8, 0x23, 0xAF, 0x83, 0x85, 0x1D, 0xF6, 0xEF, 0x34, 0x89, 0x6C, 0xF4, 0xBF, 0xB3, 0x23, 0x9F,
  0xB0, 0x18, 0xDA, 0x81, 0xEB, 0x62,
  // "h" (U+0068)
  0x0A, 0xB0, 0x87, 0x10, 0x6A, 0x08, 0x71, 0x03, 0xA0, 0x87, 0x10, 0x3A, 0x07, 0x71, 0x03, 0xA8,
  0x48, 0xAE, 0xEB, 0x23, 0x03, 0xB8, 0x35, 0x4E, 0xFD, 0x30, 0x3A, 0x0B, 0x20, 0x9A, 0x02, 0x20,
  0x3A, 0x09, 0x20, 0x7A, 0x04, 0x20, 0x3A, 0x08, 0x20, 0x7A, 0x04, 0x20, 0x3A, 0x08, 0x20, 0x7A,
  0x04, 0x20, 0x3A, 0x08, 0x20, 0x7A, 0x04, 0x20, 0x3A, 0x08, 0x20, 0x7A, 0x04, 0x20, 0x6A, 0x0B,
  0x20, 0x7A, 0x81, 0x70, 0x9C, 0x81, 0xD0, 0x7B, 0x08,
  // "i" (U+0069)
  0x18, 0x22, 0xDE, 0x42, 0x06, 0xA0, 0x82, 0x82, 0x1B, 0xB2, 0x70, 0xAB, 0x82, 0x80, 0x19, 0xA0,
  0x82, 0x03, 0xA0, 0x82, 0x03, 0xA0, 0x82, 0x03, 0xA0, 0x82, 0x03, 0xA0, 0x82, 0x03, 0xA0, 0x82,
  0x03, 0xA8, 0x28, 0x01, 0x9A, 0x81, 0xC3, 0xAD,
  // "j" (U+006A)
  0x28, 0x22, 0xDE, 0x42, 0x06, 0xA0, 0x92, 0x82, 0x1B, 0xB3, 0x70, 0xAB, 0x82, 0x80, 0x29, 0xA0,
  0x82, 0x03, 0xA0, 0x82, 0x03, 0xA0, 0x82, 0x03, 0xA0, 0x82, 0x03, 0xA0, 0x82, 0x03, 0xA0, 0x82,
  0x03, 0xA0, 0x82, 0x03, 0xA0, 0x82, 0x03, 0xA0, 0x82, 0x03, 0xA0, 0x72, 0x06, 0xA8, 0x91, 0x40,
  0x5E, 0xFB, 0x05, 0xFD, 0x82,
  // "k" (U+006B)
  0x0A, 0xB0, 0x87, 0x01, 0x09, 0xA0, 0x87, 0x10, 0x3A, 0x08, 0x71, 0x03, 0xA0, 0x87, 0x10, 0x3A,
  0x81, 0x80, 0xBB, 0x0C, 0x20, 0x3A, 0x85, 0x80, 0x2E, 0xF9, 0x22, 0x03, 0xA8, 0x38, 0x04, 0xF7,
  0x40, 0x3A, 0x82, 0x83, 0xE8, 0x50, 0x3A, 0x82, 0x9E, 0xF7, 0x50, 0x3B, 0x0E, 0xA0, 0x24, 0x03,
  0xA0, 0x90, 0x4A, 0x0C, 0x40, 0x3A, 0x81, 0x80, 0xAA, 0x08, 0x20, 0x10, 0x8A, 0x82, 0xC3, 0x1E,
  0xA8, 0x17, 0x1A, 0xD1, 0x03, 0x0C, 0xA0, 0x70,
  // "l" (U+006C)
  0xAF, 0xFF, 0x80, 0x19, 0xFF, 0x80, 0x03, 0xFF, 0x80, 0x03, 0xFF, 0x80, 0x03, 0xFF, 0x80, 0x03,
  0xFF, 0x80, 0x03, 0xFF, 0x80, 0x03, 0xFF, 0x80, 0x03, 0xFF, 0x80, 0x03, 0xFF, 0x80, 0x03, 0xFF,
  0x80, 0x03, 0xFF, 0x80, 0x18, 0xFF, 0xC3, 0xAF, 0xFF, 0xFF,
  // "m" (U+006D)
  0x08, 0xB8, 0x91, 0x69, 0xEF, 0xD6, 0x3B, 0xEE, 0x93, 0x01, 0x08, 0xB8, 0x15, 0x4E, 0xA8, 0x1D,
  0x36, 0xA0, 0x93, 0x03, 0xA0, 0xB2, 0x09, 0xA0, 0x72, 0x81, 0xDF, 0xE3, 0x03, 0xA0, 0x92, 0x07,
  0xA0, 0x52, 0x0B, 0xA3, 0x03, 0xA0, 0x82, 0x07, 0xA0, 0x42, 0x0B, 0xA3, 0x03, 0xA0, 0x82, 0x07,
  0xA0, 0x42, 0x0B, 0xA3, 0x03, 0xA0, 0x82, 0x07, 0xA0, 0x42, 0x0B, 0xA3, 0x03, 0xA0, 0x82, 0x07,
  0xA0, 0x42, 0x0B, 0xA3, 0x06, 0xA0, 0xB2, 0x07, 0xA0, 0x72, 0x0B, 0xA8, 0x13, 0x09, 0xC8, 0x1D,
  0x07, 0xB8, 0x18, 0x0B, 0xB0, 0x40,
  // "n" (U+006E)
  0x8F, 0xFF, 0x69, 0xEE, 0xB2, 0x00, 0x18, 0xFF, 0xF5, 0x4E, 0xFD, 0x00, 0x03, 0xFF, 0xB0, 0x09,
  0xFF, 0x20, 0x03, 0xFF, 0x90, 0x07, 0xFF, 0x40, 0x03, 0xFF, 0x80, 0x07, 0xFF, 0x40, 0x03, 0xFF,
  0x80, 0x07, 0xFF, 0x40, 0x03, 0xFF, 0x80, 0x07, 0xFF, 0x40, 0x03, 0xFF, 0x80, 0x07, 0xFF, 0x40,
  0x29, 0xFF, 0xC3, 0x07, 0xFF, 0x91, 0x9F, 0xFF, 0xFD, 0x07, 0xFF, 0xF8,
  // "o" (U+006F)
  0x28, 0x52, 0xAE, 0xFE, 0xA2, 0x38, 0x73, 0xEF, 0x93, 0x9F, 0xE2, 0x28, 0x1B, 0xFE, 0x38, 0x1E,
  0xFB, 0x2A, 0x0B, 0x30, 0xBA, 0x10, 0x1A, 0x0A, 0x30, 0x9A, 0x02, 0x01, 0xA0, 0xA3, 0x0A, 0xA0,
  0x21, 0xA0, 0xB3, 0x0B, 0xA2, 0x81, 0xBF, 0xE3, 0x81, 0xEF, 0xB2, 0x87, 0x2E, 0xF9, 0x39, 0xFE,
  0x33, 0x85, 0x29, 0xEF, 0xEA, 0x22,
  // "p" (U+0070)
  0x09, 0xB8, 0x71, 0x9E, 0xEB, 0x20, 0x19, 0xA8, 0x7D, 0x73, 0xCF, 0xE1, 0x04, 0xA0, 0xB2, 0x05,
  0xA8, 0x16, 0x04, 0xA0, 0x82, 0x01, 0xA8, 0x1A, 0x04, 0xA0, 0x73, 0xA8, 0x1B, 0x04, 0xA0, 0x73,
  0xA8, 0x1B, 0x04, 0xA0, 0x82, 0x01, 0xA8, 0x1A, 0x04, 0xA0, 0xB2, 0x04, 0xA8, 0x16, 0x04, 0xA8,
  0x7E, 0x63, 0xCF, 0xE1, 0x04, 0xA8, 0x46, 0x9E, 0xFB, 0x22, 0x04, 0xA0, 0x77, 0x04, 0xA0, 0x76,
  0x01, 0x09, 0xA0, 0xB0, 0x25, 0x0B, 0xD0, 0x24,
  // "q" (U+0071)
  0x28, 0x46, 0xDF, 0xD6, 0x5B, 0x81, 0x60, 0x6A, 0x82, 0x83, 0xBD, 0xA8, 0x45, 0x10, 0xDF, 0xD2,
  0x02, 0xA0, 0xD2, 0x01, 0xA0, 0xA3, 0x81, 0xEF, 0xD2, 0x02, 0xA0, 0x93, 0x81, 0xDF, 0xD2, 0x02,
  0xA0, 0x93, 0x81, 0xEF, 0xD3, 0xA0, 0xA3, 0xA0, 0xD3, 0x81, 0xDF, 0xD2, 0x02, 0xA0, 0xD3, 0x06,
  0xA8, 0x48, 0x3B, 0xEF, 0xD4, 0x86, 0x6D, 0xFD, 0x5C, 0xFD, 0x72, 0x81, 0xDF, 0xD7, 0x28, 0x1D,
  0xFD, 0x70, 0x10, 0x4B, 0x05, 0x01, 0x50, 0xAD, 0x09,
  // "r" (U+0072)
  0x08, 0xB8, 0x65, 0xAE, 0xEA, 0x01, 0x8B, 0x05, 0x07, 0xA8, 0x11, 0x03, 0xA8, 0x3B, 0x01, 0xA4,
  0x20, 0x3A, 0x09, 0x60, 0x3A, 0x08, 0x60, 0x3A, 0x08, 0x60, 0x3A, 0x08, 0x60, 0x3A, 0x08, 0x50,
  0x10, 0x9A, 0x0C, 0x03, 0x40, 0x9D, 0x05, 0x30,
  // "s" (U+0073)
  0x01, 0x9D, 0xFE, 0xA1, 0x0D, 0xF5, 0x2A, 0xFA, 0x3F, 0xE0, 0x02, 0xE5, 0x2F, 0xFB, 0x40, 0x00,
  0x09, 0xFF, 0xFD, 0x60, 0x00, 0x5C, 0xFF, 0xF8, 0x05, 0x10, 0x3B, 0xFF, 0x5F, 0x60, 0x01, 0xFF,
  0x4F, 0xE4, 0x28, 0xF9, 0x06, 0xCF, 0xEC, 0x70,
  // "t" (U+0074)
  0x28, 0x13, 0xF7, 0x38, 0x24, 0xDF, 0x72, 0x09, 0xD8, 0x1B, 0x15, 0xA8, 0x38, 0x21, 0x04, 0xA0,
  0x73, 0x04, 0xA0, 0x73, 0x04, 0xA0, 0x73, 0x04, 0xA0, 0x73, 0x04, 0xA0, 0x73, 0x03, 0xA0, 0x74,
  0x83, 0xEF, 0xC2, 0x32, 0x83, 0x5D, 0xFE, 0xB0,
  // "u" (U+0075)
  0x8F, 0xFF, 0x70, 0xDF, 0xFF, 0x30, 0x19, 0xFF, 0x70, 0x3C, 0xFF, 0x30, 0x04, 0xFF, 0x70, 0x08,
  0xFF, 0x30, 0x04, 0xFF, 0x70, 0x08, 0xFF, 0x30, 0x04, 0xFF, 0x70, 0x08, 0xFF, 0x30, 0x04, 0xFF,
  0x70, 0x08, 0xFF, 0x30, 0x03, 0xFF, 0x70, 0x08, 0xFF, 0x30, 0x02, 0xFF, 0x90, 0x0B, 0xFF, 0x30,
  0x00, 0xCF, 0xE3, 0x6E, 0xFF, 0x81, 0x00, 0x2B, 0xED, 0xA4, 0xFF, 0xF8,
  // "v" (U+0076)
  0xD0, 0x91, 0xB8, 0x1E, 0x3D, 0xA8, 0x76, 0x10, 0x2E, 0xC2, 0x05, 0xA0, 0x63, 0x0E, 0x05, 0x38,
  0x1E, 0xFB, 0x20, 0x49, 0x40, 0xAA, 0x82, 0x10, 0x9A, 0x40, 0x4A, 0x82, 0x60, 0xE5, 0x58, 0x3D,
  0xFB, 0x4E, 0x60, 0x8A, 0x00, 0x96, 0x02, 0xB0, 0x47, 0x81, 0xCF, 0xE4,
  // "w" (U+0077)
  0xD8, 0x53, 0x07, 0xF1, 0x0A, 0xB8, 0x16, 0x4E, 0xA0, 0x42, 0x86, 0xCF, 0x50, 0x1A, 0xF6, 0x20,
  0x9A, 0x20, 0x1A, 0x0A, 0x20, 0x60, 0xD3, 0x04, 0xA8, 0x14, 0x07, 0xA0, 0xE2, 0x0B, 0x08, 0x4A,
  0x82, 0x80, 0xCA, 0xA8, 0x24, 0x0E, 0x34, 0x89, 0x1B, 0xFC, 0x1F, 0x1D, 0xF9, 0x4E, 0x50, 0x6A,
  0x86, 0x7B, 0x08, 0xFD, 0x89, 0x50, 0x2A, 0x82, 0xD6, 0x03, 0xA0, 0xD0, 0x46, 0x0D, 0xA0, 0x12,
  0x81, 0xEF, 0xE7, 0x81, 0x8F, 0xB3, 0x81, 0x9F, 0xA4,
  // "x" (U+0078)
  0x07, 0xD0, 0x5C, 0x10, 0x10, 0x6B, 0x84, 0x50, 0x6F, 0xB3, 0x30, 0x5A, 0x82, 0x80, 0x7C, 0x60,
  0x9A, 0x81, 0x8E, 0x27, 0x0C, 0xA0, 0x67, 0x10, 0xBA, 0x0D, 0x78, 0x19, 0xA3, 0xA0, 0xA5, 0x07,
  0x0D, 0x20, 0x6A, 0x07, 0x28, 0x52, 0x7F, 0xB2, 0x04, 0xB8, 0x17, 0x1C, 0xB0, 0xB0, 0x3D, 0x07,
  // "y" (U+0079)
  0xD0, 0x10, 0x9B, 0x81, 0x63, 0xEA, 0x87, 0x40, 0x18, 0xF8, 0x10, 0x8A, 0x02, 0x20, 0x70, 0xE3,
  0x01, 0xA0, 0x82, 0x0C, 0x09, 0x48, 0x5A, 0xFE, 0x01, 0xF3, 0x40, 0x4A, 0x81, 0x57, 0xC6, 0x83,
  0xDF, 0xAC, 0x76, 0x83, 0x7F, 0xEF, 0x16, 0x01, 0xA0, 0xB7, 0x18, 0x1A, 0xF5, 0x71, 0x0D, 0x0E,
  0x71, 0x81, 0x6F, 0x85, 0x84, 0x13, 0x8F, 0xD1, 0x58, 0x37, 0xFD, 0x91, 0x60,
  // "z" (U+007A)
  0x1F, 0x85, 0xB1, 0xF8, 0x33, 0xAA, 0x04, 0x02, 0x92, 0x03, 0xA0, 0x95, 0x81, 0xDF, 0xD5, 0x08,
  0xA0, 0x44, 0x03, 0xA0, 0x95, 0x82, 0xCF, 0xD1, 0x28, 0x15, 0x07, 0xA0, 0x42, 0x81, 0x3E, 0x2A,
  0x85, 0xC3, 0x33, 0xBE, 0xAF, 0x0E,
  // "{" (U+007B)
  0x38, 0x34, 0xCE, 0xF6, 0x28, 0x31, 0xEF, 0xC2, 0x30, 0x4A, 0x07, 0x40, 0x5A, 0x06, 0x40, 0x5A,
  0x06, 0x40, 0x5A, 0x06, 0x40, 0x6A, 0x06, 0x38, 0x32, 0xCF, 0xE1, 0x20, 0x7A, 0x0C, 0x02, 0x38,
  0x41, 0x5D, 0xFD, 0x14, 0x06, 0xA0, 0x64, 0x05, 0xA0, 0x64, 0x05, 0xA0, 0x64, 0x05, 0xA0, 0x74,
  0x02, 0xA0, 0xB5, 0x07, 0x0E, 0xA0, 0x65, 0x81, 0x12, 0x10,
  // "|" (U+007C)
  0x9A, 0x9A, 0x9A, 0x9A, 0x9A, 0x9A, 0x9A, 0x9A, 0x9A, 0x9A, 0x9A, 0x9A, 0x9A, 0x9A, 0x9A, 0x9A,
  0x9A, 0x9A,
  // "}" (U+007D)
  0x83, 0x7F, 0xEC, 0x33, 0x84, 0x13, 0xDF, 0xE1, 0x40, 0x8A, 0x04, 0x40, 0x7A, 0x05, 0x40, 0x7A,
  0x05, 0x40, 0x7A, 0x05, 0x40, 0x6A, 0x05, 0x48, 0x32, 0xEF, 0xC2, 0x40, 0x20, 0xCA, 0x06, 0x28,
  0x42, 0xDF, 0xD4, 0x12, 0x07, 0xA0, 0x54, 0x07, 0xA0, 0x54, 0x07, 0xA0, 0x54, 0x07, 0xA0, 0x44,
  0x0B, 0xA0, 0x22, 0x06, 0xA0, 0xE0, 0x63, 0x81, 0x12, 0x15,
  // "~" (U+007E)
  0x04, 0xDE, 0x80, 0x02, 0xF2, 0x0D, 0x94, 0xDC, 0x27, 0xE0, 0x1F, 0x30, 0x1A, 0xFF, 0x60, 0x02,
  0x00, 0x00, 0x11, 0x00,
  // "¡" (U+00A1)
  0x8E, 0x90, 0xDF, 0xF0, 0x7D, 0x80, 0x00, 0x00, 0x1F, 0x30, 0x3F, 0x50, 0x5F, 0x60, 0x6F, 0x80,
  0x8F, 0xA0, 0x9F, 0xB0, 0xBF, 0xD0, 0xDF, 0xE0, 0xEF, 0xF1,
  // "¢" (U+00A2)
  0x49, 0x02, 0x79, 0x02, 0x48, 0x12, 0xAE, 0xA8, 0x7D, 0x70, 0x2E, 0xF8, 0xF8, 0xA0, 0x30, 0x9A,
  0x19, 0x89, 0x03, 0xFB, 0x0D, 0xFD, 0x0F, 0x23, 0x84, 0xEF, 0xC0, 0xF2, 0x38, 0x4D, 0xFD, 0x0F,
  0x23, 0x0B, 0xA1, 0x98, 0x32, 0x01, 0x04, 0xA8, 0x79, 0xF2, 0x4D, 0x10, 0x5D, 0xB0, 0xE0, 0x64,
  0x81, 0x1F, 0x37, 0x90, 0x23,
  // "£" (U+00A3)
  0x28, 0x52, 0xAD, 0xFE, 0xB3, 0x28, 0x62, 0xEF, 0x82, 0xBF, 0xE2, 0x06, 0xA2, 0x81, 0x4F, 0xB2,
  0x05, 0xA3, 0x01, 0x30, 0x1A, 0x04, 0x50, 0x8E, 0x0A, 0x28, 0x61, 0x27, 0xFE, 0x22, 0x14, 0x02,
  0xA0, 0x16, 0x81, 0x2F, 0xE7, 0x81, 0x6F, 0x76, 0x89, 0x12, 0xED, 0x86, 0x20, 0x37, 0x2E, 0xF8,
  0x91, 0x84, 0xB5, 0x36, 0xAD, 0xFB, 0x10,
  // "¤" (U+00A4)
  0x13, 0x00, 0x00, 0x32, 0x7E, 0xAE, 0xE9, 0xE8, 0x0D, 0xB3, 0x3B, 0xD0, 0x3F, 0x10, 0x01, 0xF3,
  0x3F, 0x00, 0x00, 0xF3, 0x0E, 0xA1, 0x19, 0xE0, 0x7F, 0xCF, 0xFC, 0xF7, 0x24, 0x01, 0x10, 0x32,
  // "¥" (U+00A5)
  0x0D, 0xC0, 0x40, 0xDA, 0x81, 0xE3, 0xEA, 0x86, 0x50, 0x2D, 0xE3, 0x07, 0xA0, 0x42, 0x0C, 0x08,
  0x20, 0x1A, 0x83, 0x90, 0x1F, 0x13, 0x84, 0x9F, 0xE0, 0x7A, 0x40, 0x2A, 0x81, 0x5D, 0x45, 0x82,
  0xBF, 0xDD, 0x40, 0xBF, 0x28, 0x11, 0x25, 0xA8, 0x18, 0x22, 0x20, 0xBF, 0x28, 0x11, 0x25, 0xA8,
  0x18, 0x22, 0x30, 0x20, 0x8A, 0x0A, 0x02, 0x30, 0x1E, 0x05, 0x10,
  // "¦" (U+00A6)
  0x9A, 0x9A, 0x9A, 0x9A, 0x9A, 0x9A, 0x9A, 0x00, 0x00, 0x00, 0x00, 0x9A, 0x9A, 0x9A, 0x9A, 0x9A,
  0x9A, 0x9A,
  // "§" (U+00A7)
  0x02, 0xAE, 0xEC, 0x50, 0x01, 0xED, 0x44, 0xEF, 0x20, 0x5F, 0x60, 0x08, 0xF3, 0x05, 0xF8, 0x00,
  0x34, 0x00, 0x1F, 0xF8, 0x10, 0x00, 0x01, 0xDF, 0xFE, 0x70, 0x00, 0xAC, 0x19, 0xFF, 0xD2, 0x0B,
  0xF1, 0x02, 0xBF, 0xC0, 0x6F, 0xE6, 0x00, 0xDF, 0x10, 0x9F, 0xFD, 0x5B, 0xE0, 0x00, 0x3C, 0xFF,
  0xF4, 0x00, 0x00, 0x05, 0xEF, 0x40, 0x19, 0x10, 0x03, 0xF8, 0x07, 0xF4, 0x00, 0x0F, 0x70, 0x5F,
  0xC2, 0x08, 0xF2, 0x00, 0x8E, 0xFF, 0xD4, 0x00, 0x00, 0x01, 0x10, 0x00, 0x00,
  // "¨" (U+00A8)
  0x01, 0x00, 0x00, 0x9F, 0x40, 0xEE, 0x7E, 0x30, 0xCC,
  // "©" (U+00A9)
  0x38, 0x54, 0xAD, 0xED, 0xB5, 0x68, 0x90, 0xAE, 0x84, 0x24, 0x7D, 0xC1, 0x38, 0x91, 0xAC, 0x13,
  0xBE, 0xEA, 0x1A, 0xC2, 0x8A, 0x14, 0xE1, 0x3F, 0xA3, 0x5F, 0x60, 0xC7, 0x0A, 0x80, 0xBE, 0x38,
  0x91, 0x71, 0x05, 0xD0, 0xD5, 0x0F, 0xA6, 0x86, 0x1F, 0x1F, 0x31, 0xF9, 0x79, 0x84, 0x2E, 0x40,
  0xFA, 0x68, 0x61, 0xF1, 0xB7, 0x0C, 0xD6, 0x89, 0x64, 0xE0, 0x5D, 0x05, 0xF9, 0x11, 0x77, 0x0B,
  0x92, 0x83, 0xCA, 0x07, 0xEA, 0x83, 0xB1, 0x7E, 0x12, 0x89, 0x11, 0xCC, 0x52, 0x22, 0x4B, 0xE3,
  0x50, 0x70, 0xDB, 0x81, 0xD8, 0x17, 0x20, 0x17,
  // "ª" (U+00AA)
  0x08, 0xDC, 0xD9, 0x00, 0x09, 0xC0, 0xAF, 0x50, 0x07, 0xCC, 0xEF, 0x60, 0x5F, 0xC0, 0x9F, 0x60,
  0x6F, 0x90, 0xCF, 0x60, 0x0B, 0xE9, 0x5F, 0xE2,
  // "«" (U+00AB)
  0x00, 0x8D, 0x01, 0xC8, 0x06, 0xF6, 0x0B, 0xE1, 0x5F, 0xD0, 0xAF, 0x80, 0xCF, 0x73, 0xFF, 0x10,
  0x5F, 0xD0, 0xBF, 0x70, 0x06, 0xF6, 0x0C, 0xE1, 0x00, 0x8D, 0x01, 0xD8,
  // "¬" (U+00AC)
  0x0C, 0xE0, 0xD8, 0x02, 0x20, 0x70, 0xD6, 0x06, 0x0D, 0x60, 0x60, 0xD7, 0x01,
  // "®" (U+00AE)
  0x38, 0x54, 0xAD, 0xED, 0xB5, 0x68, 0x90, 0xAE, 0x84, 0x24, 0x7D, 0xC1, 0x38, 0x1A, 0xCE, 0xB8,
  0x3D, 0x80, 0xAC, 0x28, 0x96, 0x4E, 0x12, 0xCB, 0x26, 0xF6, 0x0C, 0x70, 0xA8, 0x20, 0x0A, 0x28,
  0x6D, 0x90, 0x5D, 0x0D, 0x52, 0x89, 0x2A, 0xA0, 0x3F, 0x60, 0x1F, 0x1F, 0x32, 0x0A, 0xB0, 0x63,
  0x98, 0x12, 0xE4, 0x28, 0x3A, 0xB5, 0xF5, 0x28, 0x31, 0xF1, 0xB7, 0x28, 0x3A, 0xA0, 0xBD, 0x28,
  0x34, 0xE0, 0x5D, 0x28, 0x7C, 0xC0, 0x4F, 0x80, 0xB9, 0x28, 0x1C, 0xAD, 0xA8, 0x5C, 0x0B, 0xFE,
  0xE1, 0x28, 0x91, 0x1C, 0xE8, 0x42, 0x15, 0xDF, 0x35, 0x07, 0x0D, 0xB8, 0x1D, 0x81, 0x72, 0x01,
  0x70,
  // "¯" (U+00AF)
  0x01, 0xF9, 0x05, 0x18, 0x04, 0x21,
  // "°" (U+00B0)
  0x03, 0xBE, 0xC4, 0x00, 0xDA, 0x37, 0xF2, 0x2F, 0x20, 0x0F, 0x50, 0xE8, 0x05, 0xF3, 0x05, 0xEF,
  0xF7, 0x00, 0x00, 0x10, 0x00,
  // "±" (U+00B1)
  0x30, 0x90, 0xA6, 0x09, 0x0A, 0x60, 0x90, 0xA6, 0x09, 0x0A, 0x30, 0xCE, 0x84, 0xD2, 0x22, 0xAB,
  0x0F, 0x23, 0x09, 0x0A, 0x60, 0x90, 0xA7, 0x40, 0x18, 0x02, 0x20, 0x10, 0xCE, 0x0D,
  // "²" (U+00B2)
  0x06, 0xCC, 0xB4, 0x01, 0xFA, 0x0D, 0xE0, 0x09, 0x50, 0xCF, 0x00, 0x00, 0x1F, 0xA0, 0x00, 0x0A,
  0xC1, 0x00, 0x09, 0xB0, 0x01, 0x0B, 0xA1, 0x17, 0x65, 0xFF, 0xFF, 0xF6, 0x14, 0x44, 0x44, 0x10,
  // "³" (U+00B3)
  0x06, 0xCC, 0xB5, 0x01, 0xF8, 0x0D, 0xF1, 0x01, 0x11, 0xEC, 0x00, 0x09, 0xED, 0x30, 0x00, 0x00,
  0xBF, 0x21, 0x40, 0x07, 0xF6, 0x5D, 0x10, 0xBE, 0x20, 0x9C, 0xC9, 0x20,
  // "´" (U+00B4)
  0x00, 0xCF, 0xD1, 0x06, 0xFD, 0x20, 0x1E, 0x90, 0x00,
  // "µ" (U+00B5)
  0x05, 0xA0, 0x62, 0x09, 0xA8, 0x12, 0x05, 0xA0, 0x62, 0x09, 0xA8, 0x12, 0x05, 0xA0, 0x62, 0x09,
  0xA8, 0x12, 0x05, 0xA0, 0x62, 0x09, 0xA8, 0x12, 0x05, 0xA0, 0x62, 0x09, 0xA8, 0x12, 0x05, 0xA0,
  0x62, 0x09, 0xA8, 0x12, 0x05, 0xA0, 0x62, 0x0A, 0xA8, 0x12, 0x05, 0xA0, 0x92, 0x0D, 0xA8, 0x12,
  0x06, 0xA8, 0x2E, 0x7A, 0xBA, 0x89, 0x48, 0x17, 0xE7, 0xEE, 0x80, 0x8E, 0xF7, 0x79, 0x72, 0x81,
  0x8F, 0x47, 0x18, 0x26, 0xFE, 0x67, 0x82, 0x1C, 0xE5, 0x70,
  // "¶" (U+00B6)
  0x10, 0x30, 0xCF, 0x81, 0x80, 0xDC, 0x84, 0x28, 0xF5, 0x12, 0xD1, 0x06, 0x0D, 0x20, 0x3D, 0x10,
  0x60, 0xD2, 0x01, 0xD1, 0x06, 0x0D, 0x30, 0xDC, 0x10, 0x60, 0xD3, 0x81, 0x2C, 0xEA, 0x10, 0x60,
  0xD6, 0x83, 0x3F, 0x06, 0xD6, 0x83, 0x3F, 0x06, 0xD6, 0x83, 0x3F, 0x06, 0xD6, 0x83, 0x3F, 0x06,
  0xD6, 0x83, 0x3F, 0x06, 0xD6, 0x83, 0x3F, 0x06, 0xD6, 0x83, 0x3F, 0x06, 0xD6, 0x84, 0x8F, 0x06,
  0xF2, 0x40, 0xEA, 0x10, 0x6A, 0x08, 0x30, 0xF2, 0x18, 0x21, 0x22, 0x10,
  // "·" (U+00B7)
  0x6D, 0x90, 0xCF, 0xF1, 0x7E, 0xB0,
  // "¸" (U+00B8)
  0x00, 0xD6, 0x00, 0x04, 0xEC, 0x00, 0x1D, 0xE1, 0xFF, 0xE5, 0x01, 0x20, 0x00,
  // "¹" (U+00B9)
  0x00, 0x11, 0x00, 0x07, 0xF9, 0x00, 0xCB, 0xF9, 0x00, 0x42, 0xF9, 0x00, 0x02, 0xF9, 0x00, 0x02,
  0xF9, 0x00, 0x02, 0xF9, 0x00, 0x02, 0xFA, 0x00, 0xAD, 0xDD, 0xC2,
  // "º" (U+00BA)
  0x03, 0xBC, 0xCA, 0x20, 0x1E, 0xE0, 0x1F, 0xD0, 0x4F, 0xB0, 0x0D, 0xF2, 0x4F, 0xB0, 0x0D, 0xF2,
  0x1E, 0xE0, 0x1F, 0xD0, 0x03, 0xBC, 0xCB, 0x20,
  // "»" (U+00BB)
  0x8C, 0x00, 0xE7, 0x00, 0x1E, 0xB0, 0x7F, 0x60, 0x08, 0xFA, 0x0D, 0xF4, 0x02, 0xFF, 0x28, 0xFC,
  0x08, 0xFA, 0x0D, 0xF5, 0x1E, 0xB0, 0x6F, 0x60, 0x8C, 0x10, 0xE7, 0x00,
  // "¼" (U+00BC)
  0x20, 0x01, 0x75, 0x81, 0x7F, 0x95, 0x81, 0x2F, 0x33, 0x82, 0xCB, 0xF9, 0x50, 0xA0, 0xB4, 0x82,
  0x42, 0xF9, 0x48, 0x12, 0xF3, 0x58, 0x12, 0xF9, 0x40, 0xA0, 0xB6, 0x81, 0x2F, 0x93, 0x81, 0x2F,
  0x32, 0x01, 0x38, 0x12, 0xF9, 0x30, 0x90, 0xB2, 0x81, 0x8F, 0x72, 0x81, 0x2F, 0xA2, 0x89, 0x72,
  0xF4, 0x03, 0xEF, 0x70, 0xAD, 0xDD, 0xC2, 0x9B, 0x28, 0x2C, 0x7F, 0x76, 0x87, 0x2F, 0x40, 0x88,
  0x4F, 0x76, 0x87, 0x9C, 0x03, 0xC0, 0x4F, 0x75, 0x89, 0x12, 0xF4, 0x09, 0xDC, 0xDF, 0xDB, 0x40,
  0x90, 0xC5, 0x81, 0x5F, 0x84, 0x81, 0x1F, 0x44, 0x83, 0x6D, 0xDD, 0x70,
  // "½" (U+00BD)
  0x20, 0x01, 0x75, 0x81, 0x7F, 0x95, 0x81, 0x2F, 0x33, 0x82, 0xCB, 0xF9, 0x50, 0xA0, 0xB4, 0x82,
  0x42, 0xF9, 0x48, 0x12, 0xF3, 0x58, 0x12, 0xF9, 0x40, 0xA0, 0xB6, 0x81, 0x2F, 0x93, 0x81, 0x2F,
  0x36, 0x81, 0x2F, 0x93, 0x85, 0x9B, 0x6C, 0xCB, 0x42, 0x81, 0x2F, 0xA2, 0x8A, 0x42, 0xF5, 0xFA,
  0x0D, 0xE0, 0xAD, 0xDD, 0xC2, 0x9B, 0x09, 0x50, 0xC9, 0x68, 0x12, 0xF4, 0x38, 0x11, 0xFA, 0x60,
  0x90, 0xC4, 0x81, 0xAC, 0x15, 0x81, 0x2F, 0x43, 0x09, 0x0B, 0x20, 0x14, 0x09, 0x0C, 0x38, 0x4B,
  0xA1, 0x17, 0x63, 0x81, 0x1F, 0x42, 0x05, 0xD0, 0x67, 0x10, 0x18, 0x01, 0x40, 0x10,
  // "¾" (U+00BE)
  0x18, 0x36, 0xCC, 0xB5, 0x38, 0x12, 0xF3, 0x38, 0x51, 0xF8, 0x0D, 0xF1, 0x20, 0xA0, 0xB5, 0x0F,
  0x10, 0xE0, 0xC2, 0x81, 0x2F, 0x36, 0x82, 0x9E, 0xD3, 0x20, 0xA0, 0xB7, 0x28, 0x4B, 0xF2, 0x2F,
  0x32, 0x01, 0x20, 0x10, 0x42, 0x83, 0x7F, 0x69, 0xB2, 0x8A, 0x08, 0xF7, 0x05, 0xD1, 0x0B, 0xE4,
  0xF4, 0x03, 0xEF, 0x72, 0x85, 0x9C, 0xC9, 0x29, 0xB2, 0x82, 0xC7, 0xF7, 0x68, 0x72, 0xF4, 0x08,
  0x84, 0xF7, 0x68, 0x79, 0xC0, 0x3C, 0x04, 0xF7, 0x58, 0x91, 0x2F, 0x40, 0x9D, 0xCD, 0xFD, 0xB4,
  0x09, 0x0C, 0x58, 0x15, 0xF8, 0x48, 0x11, 0xF4, 0x48, 0x36, 0xDD, 0xD7,
  // "¿" (U+00BF)
  0x38, 0x17, 0xEA, 0x60, 0xDA, 0x68, 0x16, 0xD9, 0x77, 0x18, 0x11, 0xB3, 0x68, 0x14, 0xF6, 0x48,
  0x31, 0x9F, 0xD3, 0x38, 0x21, 0xDF, 0xC5, 0x09, 0xA0, 0x35, 0x0D, 0xA2, 0x83, 0x14, 0x10, 0xCA,
  0x28, 0x34, 0xFE, 0x24, 0xA8, 0x18, 0x3B, 0xA8, 0x72, 0x03, 0xAE, 0xFE, 0xB4, 0x10,
  // "À" (U+00C0)
  0x38, 0x21, 0xDF, 0xC7, 0x48, 0x22, 0xDF, 0x67, 0x58, 0x19, 0xE2, 0x77, 0x73, 0x08, 0xA0, 0x47,
  0x30, 0xDA, 0x09, 0x72, 0x83, 0x4F, 0xBF, 0xE7, 0x28, 0x1A, 0xC6, 0xA0, 0x57, 0x19, 0x07, 0x02,
  0xA0, 0xA7, 0x83, 0x6F, 0x20, 0xDA, 0x01, 0x60, 0xB0, 0xC2, 0x08, 0xA0, 0x65, 0x81, 0x2F, 0x72,
  0x03, 0xA0, 0xB5, 0x07, 0xF9, 0x01, 0x48, 0x5D, 0xC2, 0x22, 0x29, 0xA0, 0x73, 0x81, 0x4F, 0x54,
  0x02, 0xA0, 0xD2, 0x83, 0x3C, 0xF6, 0x13, 0x03, 0xB8, 0x17, 0x1E, 0xB0, 0xB2, 0x06, 0xD0, 0x80,
  // "Á" (U+00C1)
  0x78, 0x2C, 0xFD, 0x17, 0x28, 0x26, 0xFD, 0x27, 0x28, 0x11, 0xE9, 0x77, 0x74, 0x08, 0xA0, 0x47,
  0x30, 0xDA, 0x09, 0x72, 0x83, 0x4F, 0xBF, 0xE7, 0x28, 0x1A, 0xC6, 0xA0, 0x57, 0x19, 0x07, 0x02,
  0xA0, 0xA7, 0x83, 0x6F, 0x20, 0xDA, 0x01, 0x60, 0xB0, 0xC2, 0x08, 0xA0, 0x65, 0x81, 0x2F, 0x72,
  0x03, 0xA0, 0xB5, 0x07, 0xF9, 0x01, 0x48, 0x5D, 0xC2, 0x22, 0x29, 0xA0, 0x73, 0x81, 0x4F, 0x54,
  0x02, 0xA0, 0xD2, 0x83, 0x3C, 0xF6, 0x13, 0x03, 0xB8, 0x17, 0x1E, 0xB0, 0xB2, 0x06, 0xD0, 0x80,
  // "Â" (U+00C2)
  0x50, 0x9A, 0x06, 0x72, 0x84, 0x4F, 0xAC, 0xE2, 0x78, 0x11, 0xE8, 0x20, 0xA0, 0xD7, 0x77, 0x20,
  0x8A, 0x04, 0x73, 0x0D, 0xA0, 0x97, 0x28, 0x34, 0xFB, 0xFE, 0x72, 0x81, 0xAC, 0x6A, 0x05, 0x71,
  0x90, 0x70, 0x2A, 0x0A, 0x78, 0x36, 0xF2, 0x0D, 0xA0, 0x16, 0x0B, 0x0C, 0x20, 0x8A, 0x06, 0x58,
  0x12, 0xF7, 0x20, 0x3A, 0x0B, 0x50, 0x7F, 0x90, 0x14, 0x85, 0xDC, 0x22, 0x22, 0x9A, 0x07, 0x38,
  0x14, 0xF5, 0x40, 0x2A, 0x0D, 0x28, 0x33, 0xCF, 0x61, 0x30, 0x3B, 0x81, 0x71, 0xEB, 0x0B, 0x20,
  0x6D, 0x08,
  // "Ã" (U+00C3)
  0x38, 0x55, 0xED, 0x71, 0x8B, 0x68, 0x61, 0xF4, 0x6D, 0xFE, 0x27, 0x02, 0x30, 0x17, 0x77, 0x40,
  0x8A, 0x04, 0x73, 0x0D, 0xA0, 0x97, 0x28, 0x34, 0xFB, 0xFE, 0x72, 0x81, 0xAC, 0x6A, 0x05, 0x71,
  0x90, 0x70, 0x2A, 0x0A, 0x78, 0x36, 0xF2, 0x0D, 0xA0, 0x16, 0x0B, 0x0C, 0x20, 0x8A, 0x06, 0x58,
  0x12, 0xF7, 0x20, 0x3A, 0x0B, 0x50, 0x7F, 0x90, 0x14, 0x85, 0xDC, 0x22, 0x22, 0x9A, 0x07, 0x38,
  0x14, 0xF5, 0x40, 0x2A, 0x0D, 0x28, 0x33, 0xCF, 0x61, 0x30, 0x3B, 0x81, 0x71, 0xEB, 0x0B, 0x20,
  0x6D, 0x08,
  // "Ä" (U+00C4)
  0x50, 0x17, 0x58, 0x49, 0xF4, 0x0E, 0xE7, 0x18, 0x47, 0xE3, 0x0C, 0xC7, 0x77, 0x20, 0x8A, 0x04,
  0x73, 0x0D, 0xA0, 0x97, 0x28, 0x34, 0xFB, 0xFE, 0x72, 0x81, 0xAC, 0x6A, 0x05, 0x71, 0x90, 0x70,
  0x2A, 0x0A, 0x78, 0x36, 0xF2, 0x0D, 0xA0, 0x16, 0x0B, 0x0C, 0x20, 0x8A, 0x06, 0x58, 0x12, 0xF7,
  0x20, 0x3A, 0x0B, 0x50, 0x7F, 0x90, 0x14, 0x85, 0xDC, 0x22, 0x22, 0x9A, 0x07, 0x38, 0x14, 0xF5,
  0x40, 0x2A, 0x0D, 0x28, 0x33, 0xCF, 0x61, 0x30, 0x3B, 0x81, 0x71, 0xEB, 0x0B, 0x20, 0x6D, 0x08,
  // "Å" (U+00C5)
  0x58, 0x28, 0xED, 0x47, 0x28, 0x33, 0xE4, 0x7D, 0x72, 0x83, 0x3D, 0x14, 0xE7, 0x30, 0xCA, 0x07,
  0x73, 0x0D, 0xA0, 0x97, 0x28, 0x34, 0xFB, 0xFE, 0x72, 0x81, 0x9B, 0x6A, 0x04, 0x71, 0x81, 0xE7,
  0x2A, 0x0A, 0x78, 0x35, 0xF2, 0x0D, 0xA0, 0x16, 0x0B, 0x0C, 0x20, 0x8A, 0x06, 0x58, 0x12, 0xF7,
  0x20, 0x3A, 0x0B, 0x50, 0x7F, 0x90, 0x14, 0x85, 0xDC, 0x22, 0x22, 0x9A, 0x07, 0x38, 0x13, 0xF5,
  0x40, 0x2A, 0x0C, 0x28, 0x33, 0xCF, 0x61, 0x30, 0x3B, 0x81, 0x71, 0xEB, 0x0B, 0x20, 0x6D, 0x08,
  // "Æ" (U+00C6)
  0x50, 0x4F, 0xB0, 0x97, 0x81, 0x6E, 0xBA, 0x84, 0x42, 0x23, 0xE9, 0x78, 0x1D, 0x7A, 0xA0, 0x23,
  0x00, 0xA6, 0x82, 0x6E, 0x0A, 0xA0, 0x23, 0x00, 0x56, 0x82, 0xD7, 0x0A, 0xA0, 0x27, 0x30, 0x70,
  0xE2, 0x0A, 0xA0, 0x27, 0x28, 0x11, 0xE7, 0x20, 0xAE, 0x06, 0x50, 0x80, 0xE3, 0x0A, 0xA8, 0x34,
  0x22, 0x21, 0x40, 0x10, 0xEF, 0x02, 0x71, 0x85, 0x9E, 0x22, 0x22, 0xBA, 0x02, 0x40, 0x12, 0x81,
  0x2F, 0x64, 0x0A, 0xA0, 0x23, 0x85, 0x1F, 0x40, 0xBF, 0x34, 0x0D, 0xA0, 0x23, 0x81, 0x6F, 0x3C,
  0x81, 0x70, 0x5C, 0x80, 0x0E, 0xA0, 0x30,
  // "Ç" (U+00C7)
  0x28, 0x61, 0x7C, 0xEF, 0xEA, 0x32, 0x85, 0x2D, 0xF9, 0x33, 0xBA, 0x83, 0x20, 0xDF, 0xB3, 0x02,
  0xA0, 0x20, 0x6A, 0x05, 0x48, 0x29, 0x40, 0xBA, 0x02, 0x70, 0xEA, 0x71, 0xB7, 0x10, 0xEA, 0x71,
  0x0C, 0xA0, 0x27, 0x07, 0xA0, 0x57, 0x18, 0x1D, 0xFC, 0x58, 0x93, 0x52, 0x03, 0xDF, 0xB4, 0x23,
  0x9E, 0x12, 0x86, 0x17, 0xCE, 0xFE, 0xA2, 0x60, 0xD0, 0x77, 0x28, 0x14, 0xEC, 0x71, 0x01, 0x0D,
  0x97, 0xA0, 0xE0, 0x67, 0x01, 0x02, 0x50,
  // "È" (U+00C8)
  0x28, 0x21, 0xDF, 0xC7, 0x28, 0x22, 0xDF, 0x67, 0x38, 0x19, 0xE2, 0x77, 0x20, 0x7C, 0x0F, 0xEA,
  0x07, 0x30, 0xEA, 0x38, 0x12, 0xF8, 0x30, 0xCA, 0x40, 0xC0, 0x83, 0x0C, 0xA4, 0x05, 0x04, 0x30,
  0xCA, 0x72, 0x0C, 0xA7, 0x20, 0xCE, 0x04, 0x40, 0xCA, 0x03, 0x0F, 0x25, 0x0C, 0xA7, 0x20, 0xCA,
  0x50, 0x23, 0x0C, 0xA4, 0x81, 0x2F, 0x22, 0x0E, 0xA4, 0x82, 0x8F, 0x17, 0xC8, 0x00, 0xEA, 0x01,
  // "É" (U+00C9)
  0x68, 0x2C, 0xFD, 0x17, 0x82, 0x6F, 0xD2, 0x78, 0x11, 0xE9, 0x77, 0x30, 0x7C, 0x0F, 0xEA, 0x07,
  0x30, 0xEA, 0x38, 0x12, 0xF8, 0x30, 0xCA, 0x40, 0xC0, 0x83, 0x0C, 0xA4, 0x05, 0x04, 0x30, 0xCA,
  0x72, 0x0C, 0xA7, 0x20, 0xCE, 0x04, 0x40, 0xCA, 0x03, 0x0F, 0x25, 0x0C, 0xA7, 0x20, 0xCA, 0x50,
  0x23, 0x0C, 0xA4, 0x81, 0x2F, 0x22, 0x0E, 0xA4, 0x82, 0x8F, 0x17, 0xC8, 0x00, 0xEA, 0x01,
  // "Ê" (U+00CA)
  0x40, 0x9A, 0x06, 0x78, 0x44, 0xFA, 0xCE, 0x25, 0x81, 0x1E, 0x82, 0x0A, 0x0D, 0x77, 0x10, 0x7C,
  0x0F, 0xEA, 0x07, 0x30, 0xEA, 0x38, 0x12, 0xF8, 0x30, 0xCA, 0x40, 0xC0, 0x83, 0x0C, 0xA4, 0x05,
  0x04, 0x30, 0xCA, 0x72, 0x0C, 0xA7, 0x20, 0xCE, 0x04, 0x40, 0xCA, 0x03, 0x0F, 0x25, 0x0C, 0xA7,
  0x20, 0xCA, 0x50, 0x23, 0x0C, 0xA4, 0x81, 0x2F, 0x22, 0x0E, 0xA4, 0x82, 0x8F, 0x17, 0xC8, 0x00,
  0xEA, 0x01,
  // "Ë" (U+00CB)
  0x40, 0x17, 0x38, 0x49, 0xF4, 0x0E, 0xE6, 0x84, 0x7E, 0x30, 0xCC, 0x77, 0x10, 0x7C, 0x0F, 0xEA,
  0x07, 0x30, 0xEA, 0x38, 0x12, 0xF8, 0x30, 0xCA, 0x40, 0xC0, 0x83, 0x0C, 0xA4, 0x05, 0x04, 0x30,
  0xCA, 0x72, 0x0C, 0xA7, 0x20, 0xCE, 0x04, 0x40, 0xCA, 0x03, 0x0F, 0x25, 0x0C, 0xA7, 0x20, 0xCA,
  0x50, 0x23, 0x0C, 0xA4, 0x81, 0x2F, 0x22, 0x0E, 0xA4, 0x82, 0x8F, 0x17, 0xC8, 0x00, 0xEA, 0x01,
  // "Ì" (U+00CC)
  0x82, 0x1D, 0xFC, 0x48, 0x22, 0xDF, 0x65, 0x81, 0x9E, 0x27, 0x10, 0x7D, 0x82, 0xB1, 0x3E, 0xA0,
  0x50, 0x12, 0x0C, 0xA4, 0x0C, 0xA4, 0x0C, 0xA4, 0x0C, 0xA4, 0x0C, 0xA4, 0x0C, 0xA4, 0x0C, 0xA4,
  0x0C, 0xA4, 0x0C, 0xA2, 0x81, 0x13, 0xEA, 0x81, 0x51, 0x7D, 0x0B,
  // "Í" (U+00CD)
  0x48, 0x2C, 0xFD, 0x13, 0x82, 0x6F, 0xD2, 0x38, 0x11, 0xE9, 0x74, 0x07, 0xD8, 0x3B, 0x01, 0x3E,
  0xA0, 0x50, 0x13, 0x0C, 0xA5, 0x0C, 0xA5, 0x0C, 0xA5, 0x0C, 0xA5, 0x0C, 0xA5, 0x0C, 0xA5, 0x0C,
  0xA5, 0x0C, 0xA5, 0x0C, 0xA3, 0x81, 0x13, 0xEA, 0x82, 0x51, 0x07, 0xD0, 0xB1,
  // "Î" (U+00CE)
  0x20, 0x9A, 0x06, 0x28, 0x74, 0xFA, 0xCE, 0x21, 0xE8, 0x20, 0xA0, 0xD7, 0x07, 0xD8, 0x2B, 0x13,
  0xEA, 0x05, 0x01, 0x20, 0xCA, 0x40, 0xCA, 0x40, 0xCA, 0x40, 0xCA, 0x40, 0xCA, 0x40, 0xCA, 0x40,
  0xCA, 0x40, 0xCA, 0x40, 0xCA, 0x28, 0x11, 0x3E, 0xA8, 0x15, 0x17, 0xD0, 0xB0,
  // "Ï" (U+00CF)
  0x10, 0x15, 0x89, 0x39, 0xF4, 0x0E, 0xE0, 0x7E, 0x30, 0xCC, 0x71, 0x07, 0xD8, 0x2B, 0x13, 0xEA,
  0x05, 0x01, 0x20, 0xCA, 0x40, 0xCA, 0x40, 0xCA, 0x40, 0xCA, 0x40, 0xCA, 0x40, 0xCA, 0x40, 0xCA,
  0x40, 0xCA, 0x40, 0xCA, 0x28, 0x11, 0x3E, 0xA8, 0x15, 0x17, 0xD0, 0xB0,
  // "Ð" (U+00D0)
  0x07, 0xE8, 0x1E, 0xB6, 0x38, 0x11, 0x3E, 0xA8, 0x52, 0x26, 0xEF, 0xC1, 0x30, 0xCA, 0x30, 0x2A,
  0x0C, 0x30, 0xCA, 0x40, 0x9A, 0x05, 0x20, 0xCA, 0x40, 0x5A, 0x09, 0x20, 0xCA, 0x40, 0x4A, 0x0B,
  0x04, 0xE8, 0x14, 0x03, 0xA8, 0x2C, 0x02, 0xDA, 0x00, 0x22, 0x04, 0xA0, 0xA2, 0x0C, 0xA4, 0x07,
  0xA0, 0x72, 0x0C, 0xA4, 0x0B, 0xA0, 0x22, 0x0C, 0xA3, 0x04, 0xA8, 0x39, 0x01, 0x3E, 0xA8, 0x42,
  0x37, 0xEF, 0xA2, 0x07, 0xE8, 0x1D, 0xB5, 0x30,
  // "Ñ" (U+00D1)
  0x48, 0x55, 0xED, 0x71, 0x8B, 0x68, 0x61, 0xF4, 0x6D, 0xFE, 0x27, 0x02, 0x30, 0x17, 0x75, 0x07,
  0xB0, 0xC4, 0x0C, 0xB8, 0x2D, 0x13, 0xEA, 0x08, 0x38, 0x31, 0x6F, 0x71, 0x20, 0xCB, 0x04, 0x38,
  0x12, 0xF3, 0x30, 0xC0, 0xBA, 0x0D, 0x01, 0x28, 0x12, 0xF3, 0x38, 0x1C, 0x88, 0xA0, 0xA2, 0x81,
  0x2F, 0x33, 0x82, 0xC8, 0x0C, 0xA8, 0x35, 0x02, 0xF3, 0x38, 0x91, 0xC8, 0x02, 0xEF, 0xE1, 0x2F,
  0x33, 0x0C, 0x08, 0x20, 0x6A, 0x82, 0xB2, 0xF3, 0x30, 0xC0, 0x83, 0x0A, 0xA8, 0x19, 0xF3, 0x30,
  0xC0, 0x83, 0x01, 0x0D, 0xB0, 0x33, 0x0C, 0x08, 0x40, 0x3B, 0x85, 0x30, 0x13, 0xEB, 0x24, 0x08,
  0xA8, 0x13, 0x07, 0xC0, 0x34, 0x81, 0xCF, 0x31,
  // "Ò" (U+00D2)
  0x28, 0x21, 0xDF, 0xC7, 0x38, 0x22, 0xDF, 0x67, 0x48, 0x19, 0xE2, 0x77, 0x68, 0x61, 0x7C, 0xEE,
  0xD8, 0x24, 0x89, 0x03, 0xEF, 0xA3, 0x28, 0xFE, 0x42, 0x82, 0x1D, 0xFB, 0x48, 0x49, 0xFE, 0x10,
  0x7A, 0x05, 0x40, 0x3A, 0x81, 0x90, 0xCA, 0x02, 0x5A, 0x81, 0xE0, 0xEA, 0x60, 0xDA, 0x01, 0xB6,
  0x0D, 0xA0, 0x20, 0xEA, 0x60, 0xDA, 0x01, 0x0C, 0xA0, 0x25, 0xA8, 0x1E, 0x07, 0xA0, 0x54, 0x03,
  0xA0, 0x92, 0x81, 0xDF, 0xB4, 0x82, 0x9F, 0xE1, 0x28, 0x90, 0x3E, 0xFA, 0x32, 0x8F, 0xE4, 0x48,
  0x61, 0x7C, 0xEE, 0xD8, 0x13,
  // "Ó" (U+00D3)
  0x68, 0x2C, 0xFD, 0x17, 0x18, 0x26, 0xFD, 0x27, 0x18, 0x11, 0xE9, 0x77, 0x78, 0x61, 0x7C, 0xEE,
  0xD8, 0x24, 0x89, 0x03, 0xEF, 0xA3, 0x28, 0xFE, 0x42, 0x82, 0x1D, 0xFB, 0x48, 0x49, 0xFE, 0x10,
  0x7A, 0x05, 0x40, 0x3A, 0x81, 0x90, 0xCA, 0x02, 0x5A, 0x81, 0xE0, 0xEA, 0x60, 0xDA, 0x01, 0xB6,
  0x0D, 0xA0, 0x20, 0xEA, 0x60, 0xDA, 0x01, 0x0C, 0xA0, 0x25, 0xA8, 0x1E, 0x07, 0xA0, 0x54, 0x03,
  0xA0, 0x92, 0x81, 0xDF, 0xB4, 0x82, 0x9F, 0xE1, 0x28, 0x90, 0x3E, 0xFA, 0x32, 0x8F, 0xE4, 0x48,
  0x61, 0x7C, 0xEE, 0xD8, 0x13,
  // "Ô" (U+00D4)
  0x40, 0x9A, 0x06, 0x71, 0x84, 0x4F, 0xAC, 0xE2, 0x68, 0x11, 0xE8, 0x20, 0xA0, 0xD7, 0x75, 0x86,
  0x17, 0xCE, 0xED, 0x82, 0x48, 0x90, 0x3E, 0xFA, 0x32, 0x8F, 0xE4, 0x28, 0x21, 0xDF, 0xB4, 0x84,
  0x9F, 0xE1, 0x07, 0xA0, 0x54, 0x03, 0xA8, 0x19, 0x0C, 0xA0, 0x25, 0xA8, 0x1E, 0x0E, 0xA6, 0x0D,
  0xA0, 0x1B, 0x60, 0xDA, 0x02, 0x0E, 0xA6, 0x0D, 0xA0, 0x10, 0xCA, 0x02, 0x5A, 0x81, 0xE0, 0x7A,
  0x05, 0x40, 0x3A, 0x09, 0x28, 0x1D, 0xFB, 0x48, 0x29, 0xFE, 0x12, 0x89, 0x03, 0xEF, 0xA3, 0x28,
  0xFE, 0x44, 0x86, 0x17, 0xCE, 0xED, 0x81, 0x30,
  // "Õ" (U+00D5)
  0x38, 0x55, 0xED, 0x71, 0x8B, 0x58, 0x61, 0xF4, 0x6D, 0xFE, 0x26, 0x02, 0x30, 0x17, 0x76, 0x86,
  0x17, 0xCE, 0xED, 0x82, 0x48, 0x90, 0x3E, 0xFA, 0x32, 0x8F, 0xE4, 0x28, 0x21, 0xDF, 0xB4, 0x84,
  0x9F, 0xE1, 0x07, 0xA0, 0x54, 0x03, 0xA8, 0x19, 0x0C, 0xA0, 0x25, 0xA8, 0x1E, 0x0E, 0xA6, 0x0D,
  0xA0, 0x1B, 0x60, 0xDA, 0x02, 0x0E, 0xA6, 0x0D, 0xA0, 0x10, 0xCA, 0x02, 0x5A, 0x81, 0xE0, 0x7A,
  0x05, 0x40, 0x3A, 0x09, 0x28, 0x1D, 0xFB, 0x48, 0x29, 0xFE, 0x12, 0x89, 0x03, 0xEF, 0xA3, 0x28,
  0xFE, 0x44, 0x86, 0x17, 0xCE, 0xED, 0x81, 0x30,
  // "Ö" (U+00D6)
  0x40, 0x17, 0x48, 0x49, 0xF4, 0x0E, 0xE7, 0x84, 0x7E, 0x30, 0xCC, 0x77, 0x58, 0x61, 0x7C, 0xEE,
  0xD8, 0x24, 0x89, 0x03, 0xEF, 0xA3, 0x28, 0xFE, 0x42, 0x82, 0x1D, 0xFB, 0x48, 0x49, 0xFE, 0x10,
  0x7A, 0x05, 0x40, 0x3A, 0x81, 0x90, 0xCA, 0x02, 0x5A, 0x81, 0xE0, 0xEA, 0x60, 0xDA, 0x01, 0xB6,
  0x0D, 0xA0, 0x20, 0xEA, 0x60, 0xDA, 0x01, 0x0C, 0xA0, 0x25, 0xA8, 0x1E, 0x07, 0xA0, 0x54, 0x03,
  0xA0, 0x92, 0x81, 0xDF, 0xB4, 0x82, 0x9F, 0xE1, 0x28, 0x90, 0x3E, 0xFA, 0x32, 0x8F, 0xE4, 0x48,
  0x61, 0x7C, 0xEE, 0xD8, 0x13,
  // "×" (U+00D7)
  0x3B, 0x10, 0x00, 0xB3, 0x1D, 0xC1, 0x0C, 0xD1, 0x01, 0xDC, 0xCD, 0x10, 0x00, 0x2F, 0xF2, 0x00,
  0x00, 0xCD, 0xDC, 0x10, 0x0C, 0xD1, 0x1D, 0xC1, 0x3D, 0x10, 0x01, 0xC4,
  // "Ø" (U+00D8)
  0x72, 0x0D, 0x05, 0x48, 0x61, 0x7C, 0xEE, 0xDA, 0xE4, 0x85, 0x3E, 0xFA, 0x33, 0x8A, 0x05, 0x28,
  0x21, 0xDF, 0xB3, 0x05, 0xB8, 0x12, 0x07, 0xA0, 0x53, 0x0D, 0x08, 0xA8, 0x19, 0x0C, 0xA0, 0x22,
  0x06, 0x0C, 0x1A, 0x81, 0xE0, 0xEA, 0x28, 0x31, 0xE4, 0x0E, 0xA0, 0x1B, 0x20, 0x80, 0xB2, 0x0D,
  0xA0, 0x20, 0xEA, 0x82, 0x11, 0xE2, 0x20, 0xDA, 0x01, 0x0B, 0xA8, 0x12, 0x99, 0x3A, 0x81, 0xE0,
  0x7A, 0x81, 0x9E, 0x12, 0x03, 0xA0, 0x92, 0x0D, 0xA0, 0x83, 0x82, 0x9F, 0xE1, 0x28, 0x90, 0x2E,
  0xFA, 0x32, 0x8F, 0xE4, 0x48, 0x6C, 0xBC, 0xEE, 0xD8, 0x14, 0x01, 0x07, 0x73,
  // "Ù" (U+00D9)
  0x38, 0x21, 0xDF, 0xC7, 0x48, 0x22, 0xDF, 0x67, 0x58, 0x19, 0xE2, 0x77, 0x50, 0xBD, 0x81, 0x70,
  0x8C, 0x81, 0x21, 0x5A, 0x87, 0xE3, 0x10, 0x13, 0xFB, 0x23, 0xA0, 0xC5, 0x0D, 0x07, 0x4A, 0x0C,
  0x50, 0xD0, 0x74, 0xA0, 0xC5, 0x0D, 0x07, 0x4A, 0x0C, 0x50, 0xD0, 0x74, 0xA0, 0xC5, 0x0D, 0x07,
  0x4A, 0x0C, 0x50, 0xD0, 0x74, 0xA0, 0xC5, 0x0D, 0x07, 0x4A, 0x0D, 0x50, 0xE0, 0x64, 0x0C, 0xA0,
  0x13, 0x81, 0x2F, 0x44, 0x04, 0xA8, 0x4C, 0x42, 0x4D, 0xB6, 0x81, 0x39, 0xDA, 0x0D, 0x08, 0x40,
  // "Ú" (U+00DA)
  0x78, 0x2C, 0xFD, 0x17, 0x28, 0x26, 0xFD, 0x27, 0x28, 0x11, 0xE9, 0x77, 0x60, 0xBD, 0x81, 0x70,
  0x8C, 0x81, 0x21, 0x5A, 0x87, 0xE3, 0x10, 0x13, 0xFB, 0x23, 0xA0, 0xC5, 0x0D, 0x07, 0x4A, 0x0C,
  0x50, 0xD0, 0x74, 0xA0, 0xC5, 0x0D, 0x07, 0x4A, 0x0C, 0x50, 0xD0, 0x74, 0xA0, 0xC5, 0x0D, 0x07,
  0x4A, 0x0C, 0x50, 0xD0, 0x74, 0xA0, 0xC5, 0x0D, 0x07, 0x4A, 0x0D, 0x50, 0xE0, 0x64, 0x0C, 0xA0,
  0x13, 0x81, 0x2F, 0x44, 0x04, 0xA8, 0x4C, 0x42, 0x4D, 0xB6, 0x81, 0x39, 0xDA, 0x0D, 0x08, 0x40,
  // "Û" (U+00DB)
  0x50, 0x9A, 0x06, 0x72, 0x84, 0x4F, 0xAC, 0xE2, 0x78, 0x11, 0xE8, 0x20, 0xA0, 0xD7, 0x74, 0x0B,
  0xD8, 0x17, 0x08, 0xC8, 0x12, 0x15, 0xA8, 0x7E, 0x31, 0x01, 0x3F, 0xB2, 0x3A, 0x0C, 0x50, 0xD0,
  0x74, 0xA0, 0xC5, 0x0D, 0x07, 0x4A, 0x0C, 0x50, 0xD0, 0x74, 0xA0, 0xC5, 0x0D, 0x07, 0x4A, 0x0C,
  0x50, 0xD0, 0x74, 0xA0, 0xC5, 0x0D, 0x07, 0x4A, 0x0C, 0x50, 0xD0, 0x74, 0xA0, 0xD5, 0x0E, 0x06,
  0x40, 0xCA, 0x01, 0x38, 0x12, 0xF4, 0x40, 0x4A, 0x84, 0xC4, 0x24, 0xDB, 0x68, 0x13, 0x9D, 0xA0,
  0xD0, 0x84,
  // "Ü" (U+00DC)
  0x50, 0x17, 0x58, 0x49, 0xF4, 0x0E, 0xE7, 0x18, 0x47, 0xE3, 0x0C, 0xC7, 0x74, 0x0B, 0xD8, 0x17,
  0x08, 0xC8, 0x12, 0x15, 0xA8, 0x7E, 0x31, 0x01, 0x3F, 0xB2, 0x3A, 0x0C, 0x50, 0xD0, 0x74, 0xA0,
  0xC5, 0x0D, 0x07, 0x4A, 0x0C, 0x50, 0xD0, 0x74, 0xA0, 0xC5, 0x0D, 0x07, 0x4A, 0x0C, 0x50, 0xD0,
  0x74, 0xA0, 0xC5, 0x0D, 0x07, 0x4A, 0x0C, 0x50, 0xD0, 0x74, 0xA0, 0xD5, 0x0E, 0x06, 0x40, 0xCA,
  0x01, 0x38, 0x12, 0xF4, 0x40, 0x4A, 0x84, 0xC4, 0x24, 0xDB, 0x68, 0x13, 0x9D, 0xA0, 0xD0, 0x84,
  // "Ý" (U+00DD)
  0x78, 0x2C, 0xFD, 0x17, 0x18, 0x26, 0xFD, 0x27, 0x18, 0x11, 0xE9, 0x77, 0x4E, 0x10, 0x3C, 0x81,
  0x73, 0xDA, 0x0C, 0x03, 0x28, 0x53, 0xCF, 0x71, 0x04, 0xA0, 0xB4, 0x0B, 0x0C, 0x40, 0xBA, 0x03,
  0x28, 0x12, 0xF4, 0x40, 0x3A, 0x0B, 0x20, 0x90, 0xB6, 0x0A, 0xA8, 0x23, 0x2F, 0x36, 0x02, 0xA8,
  0x1A, 0x9A, 0x71, 0x09, 0xA0, 0xE0, 0x27, 0x10, 0x3A, 0x0B, 0x72, 0x02, 0xA0, 0xA7, 0x20, 0x2A,
  0x0A, 0x71, 0x02, 0x07, 0xA8, 0x1D, 0x31, 0x6E, 0x09, 0x30,
  // "Þ" (U+00DE)
  0x07, 0xD0, 0xB4, 0x81, 0x13, 0xEA, 0x04, 0x01, 0x60, 0xCB, 0x82, 0xED, 0x92, 0x30, 0xCA, 0x84,
  0x24, 0xDF, 0xE2, 0x20, 0xCA, 0x20, 0x4A, 0x0A, 0x20, 0xCA, 0x20, 0x2A, 0x0D, 0x20, 0xCA, 0x20,
  0x2A, 0x0D, 0x20, 0xCA, 0x20, 0x4A, 0x09, 0x20, 0xCA, 0x18, 0x32, 0xCF, 0xE1, 0x20, 0xCC, 0x81,
  0xE9, 0x13, 0x0C, 0xA0, 0x20, 0x14, 0x81, 0x13, 0xEA, 0x05, 0x01, 0x40, 0x7D, 0x0B, 0x40,
  // "ß" (U+00DF)
  0x00, 0x05, 0xBE, 0xFE, 0xA3, 0x00, 0x00, 0x7F, 0xF5, 0x15, 0xFF, 0x30, 0x00, 0xEF, 0xA0, 0x00,
  0xAF, 0xA0, 0x02, 0xFF, 0x80, 0x00, 0x8F, 0xE0, 0x9F, 0xFF, 0x80, 0x5D, 0xFD, 0xB0, 0x14, 0xFF,
  0x82, 0xFF, 0x20, 0x00, 0x03, 0xFF, 0x85, 0xFF, 0x10, 0x00, 0x03, 0xFF, 0x83, 0xFF, 0xD4, 0x00,
  0x03, 0xFF, 0x80, 0xAF, 0xFF, 0xB0, 0x03, 0xFF, 0x80, 0x06, 0xEF, 0xF9, 0x03, 0xFF, 0x81, 0x30,
  0x1C, 0xFE, 0x03, 0xFF, 0x8C, 0xD0, 0x05, 0xFD, 0x06, 0xFF, 0x8A, 0xF7, 0x19, 0xF8, 0xDF, 0xFF,
  0x81, 0x9E, 0xFD, 0x80,
  // "à" (U+00E0)
  0x18, 0x21, 0xDF, 0xC7, 0x18, 0x22, 0xDF, 0x67, 0x28, 0x19, 0xE2, 0x77, 0x38, 0x57, 0xCE, 0xFD,
  0x81, 0x30, 0x5A, 0x83, 0x73, 0xEF, 0xA3, 0x81, 0x2B, 0xD2, 0x81, 0xBF, 0xE7, 0x10, 0xAA, 0x38,
  0x21, 0x8D, 0xEC, 0x30, 0xBA, 0x81, 0x62, 0xBA, 0x20, 0x1A, 0x0A, 0x20, 0xAA, 0x20, 0x1A, 0x09,
  0x20, 0xDA, 0x38, 0x4D, 0xFD, 0x37, 0xCA, 0x05, 0x28, 0x42, 0xBE, 0xD5, 0x4B, 0x03,
  // "á" (U+00E1)
  0x58, 0x2C, 0xFD, 0x16, 0x82, 0x6F, 0xD2, 0x68, 0x11, 0xE9, 0x77, 0x48, 0x57, 0xCE, 0xFD, 0x81,
  0x30, 0x5A, 0x83, 0x73, 0xEF, 0xA3, 0x81, 0x2B, 0xD2, 0x81, 0xBF, 0xE7, 0x10, 0xAA, 0x38, 0x21,
  0x8D, 0xEC, 0x30, 0xBA, 0x81, 0x62, 0xBA, 0x20, 0x1A, 0x0A, 0x20, 0xAA, 0x20, 0x1A, 0x09, 0x20,
  0xDA, 0x38, 0x4D, 0xFD, 0x37, 0xCA, 0x05, 0x28, 0x42, 0xBE, 0xD5, 0x4B, 0x03,
  // "â" (U+00E2)
  0x40, 0x9A, 0x06, 0x68, 0x44, 0xFA, 0xCE, 0x24, 0x81, 0x1E, 0x82, 0x0A, 0x0D, 0x77, 0x18, 0x57,
  0xCE, 0xFD, 0x81, 0x30, 0x5A, 0x83, 0x73, 0xEF, 0xA3, 0x81, 0x2B, 0xD2, 0x81, 0xBF, 0xE7, 0x10,
  0xAA, 0x38, 0x21, 0x8D, 0xEC, 0x30, 0xBA, 0x81, 0x62, 0xBA, 0x20, 0x1A, 0x0A, 0x20, 0xAA, 0x20,
  0x1A, 0x09, 0x20, 0xDA, 0x38, 0x4D, 0xFD, 0x37, 0xCA, 0x05, 0x28, 0x42, 0xBE, 0xD5, 0x4B, 0x03,
  // "ã" (U+00E3)
  0x28, 0x55, 0xED, 0x71, 0x8B, 0x38, 0x61, 0xF4, 0x6D, 0xFE, 0x24, 0x02, 0x30, 0x17, 0x73, 0x85,
  0x7C, 0xEF, 0xD8, 0x13, 0x05, 0xA8, 0x37, 0x3E, 0xFA, 0x38, 0x12, 0xBD, 0x28, 0x1B, 0xFE, 0x71,
  0x0A, 0xA3, 0x82, 0x18, 0xDE, 0xC3, 0x0B, 0xA8, 0x16, 0x2B, 0xA2, 0x01, 0xA0, 0xA2, 0x0A, 0xA2,
  0x01, 0xA0, 0x92, 0x0D, 0xA3, 0x84, 0xDF, 0xD3, 0x7C, 0xA0, 0x52, 0x84, 0x2B, 0xED, 0x54, 0xB0,
  0x30,
  // "ä" (U+00E4)
  0x30, 0x17, 0x28, 0x49, 0xF4, 0x0E, 0xE5, 0x84, 0x7E, 0x30, 0xCC, 0x77, 0x28, 0x57, 0xCE, 0xFD,
  0x81, 0x30, 0x5A, 0x83, 0x73, 0xEF, 0xA3, 0x81, 0x2B, 0xD2, 0x81, 0xBF, 0xE7, 0x10, 0xAA, 0x38,
  0x21, 0x8D, 0xEC, 0x30, 0xBA, 0x81, 0x62, 0xBA, 0x20, 0x1A, 0x0A, 0x20, 0xAA, 0x20, 0x1A, 0x09,
  0x20, 0xDA, 0x38, 0x4D, 0xFD, 0x37, 0xCA, 0x05, 0x28, 0x42, 0xBE, 0xD5, 0x4B, 0x03,
  // "å" (U+00E5)
  0x38, 0x26, 0xDD, 0x56, 0x82, 0x1F, 0x55, 0x96, 0x84, 0x1F, 0x22, 0xF1, 0x60, 0x8A, 0x08, 0x71,
  0x00, 0x17, 0x85, 0x7C, 0xEF, 0xD8, 0x13, 0x05, 0xA8, 0x37, 0x3E, 0xFA, 0x38, 0x12, 0xBD, 0x28,
  0x1B, 0xFE, 0x71, 0x0A, 0xA3, 0x82, 0x18, 0xDE, 0xC3, 0x0B, 0xA8, 0x16, 0x2B, 0xA2, 0x01, 0xA0,
  0xA2, 0x0A, 0xA2, 0x01, 0xA0, 0x92, 0x0D, 0xA3, 0x84, 0xDF, 0xD3, 0x7C, 0xA0, 0x52, 0x84, 0x2B,
  0xED, 0x54, 0xB0, 0x30,
  // "æ" (U+00E6)
  0x28, 0x92, 0x7C, 0xEE, 0xC6, 0x3B, 0xFE, 0xB3, 0x20, 0x5A, 0x81, 0x73, 0xEA, 0x81, 0xD3, 0x7A,
  0x83, 0x30, 0x2B, 0xD2, 0x0B, 0xA0, 0x52, 0x81, 0xEF, 0xB6, 0x0A, 0xA0, 0x22, 0x86, 0xCF, 0xE0,
  0x18, 0xDE, 0xFB, 0x10, 0xBA, 0x81, 0x62, 0xBA, 0x04, 0x80, 0x12, 0x01, 0xA0, 0xA2, 0x0A, 0xA0,
  0x35, 0x01, 0xA0, 0x92, 0x0D, 0xA0, 0x83, 0x89, 0x01, 0x30, 0xDF, 0xD3, 0x7E, 0xBA, 0x8A, 0x17,
  0x25, 0xD6, 0x02, 0xBE, 0xEA, 0x20, 0x7C, 0xEE, 0xD7, 0x10,
  // "ç" (U+00E7)
  0x28, 0x73, 0xAE, 0xFD, 0x91, 0x03, 0xA8, 0x78, 0x3E, 0xFA, 0x0B, 0xFE, 0x28, 0x19, 0xF9, 0x1A,
  0x0B, 0x28, 0x23, 0x50, 0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x6A, 0x0B, 0x68, 0x1B, 0xFE, 0x48, 0x14,
  0x03, 0xA8, 0x3A, 0x33, 0xAA, 0x28, 0x53, 0xAE, 0xFD, 0x91, 0x40, 0xD0, 0x67, 0x81, 0x4E, 0xC6,
  0x81, 0x1D, 0xE4, 0x01, 0xA0, 0xE0, 0x55, 0x01, 0x02, 0x40,
  // "è" (U+00E8)
  0x28, 0x21, 0xDF, 0xC7, 0x82, 0x2D, 0xF6, 0x71, 0x81, 0x9E, 0x27, 0x78, 0x42, 0xAE, 0xFD, 0x73,
  0x86, 0x2E, 0xF8, 0x3C, 0xFB, 0x28, 0x1B, 0xFD, 0x20, 0x6A, 0x03, 0x1A, 0x0B, 0x20, 0x4A, 0x07,
  0x01, 0xF9, 0x07, 0x02, 0xA0, 0xA8, 0x01, 0x20, 0x11, 0xA0, 0xB7, 0x0A, 0xA0, 0x13, 0x05, 0x28,
  0x62, 0xEF, 0xC3, 0x38, 0xE3, 0x85, 0x2A, 0xEF, 0xEB, 0x31,
  // "é" (U+00E9)
  0x58, 0x2C, 0xFD, 0x15, 0x82, 0x6F, 0xD2, 0x58, 0x11, 0xE9, 0x77, 0x28, 0x42, 0xAE, 0xFD, 0x73,
  0x86, 0x2E, 0xF8, 0x3C, 0xFB, 0x28, 0x1B, 0xFD, 0x20, 0x6A, 0x03, 0x1A, 0x0B, 0x20, 0x4A, 0x07,
  0x01, 0xF9, 0x07, 0x02, 0xA0, 0xA8, 0x01, 0x20, 0x11, 0xA0, 0xB7, 0x0A, 0xA0, 0x13, 0x05, 0x28,
  0x62, 0xEF, 0xC3, 0x38, 0xE3, 0x85, 0x2A, 0xEF, 0xEB, 0x31,
  // "ê" (U+00EA)
  0x40, 0x9A, 0x06, 0x58, 0x44, 0xFA, 0xCE, 0x23, 0x81, 0x1E, 0x82, 0x0A, 0x0D, 0x76, 0x84, 0x2A,
  0xEF, 0xD7, 0x38, 0x62, 0xEF, 0x83, 0xCF, 0xB2, 0x81, 0xBF, 0xD2, 0x06, 0xA0, 0x31, 0xA0, 0xB2,
  0x04, 0xA0, 0x70, 0x1F, 0x90, 0x70, 0x2A, 0x0A, 0x80, 0x12, 0x01, 0x1A, 0x0B, 0x70, 0xAA, 0x01,
  0x30, 0x52, 0x86, 0x2E, 0xFC, 0x33, 0x8E, 0x38, 0x52, 0xAE, 0xFE, 0xB3, 0x10,
  // "ë" (U+00EB)
  0x30, 0x17, 0x18, 0x49, 0xF4, 0x0E, 0xE4, 0x84, 0x7E, 0x30, 0xCC, 0x77, 0x84, 0x2A, 0xEF, 0xD7,
  0x38, 0x62, 0xEF, 0x83, 0xCF, 0xB2, 0x81, 0xBF, 0xD2, 0x06, 0xA0, 0x31, 0xA0, 0xB2, 0x04, 0xA0,
  0x70, 0x1F, 0x90, 0x70, 0x2A, 0x0A, 0x80, 0x12, 0x01, 0x1A, 0x0B, 0x70, 0xAA, 0x01, 0x30, 0x52,
  0x86, 0x2E, 0xFC, 0x33, 0x8E, 0x38, 0x52, 0xAE, 0xFE, 0xB3, 0x10,
  // "ì" (U+00EC)
  0x82, 0x1D, 0xFC, 0x48, 0x22, 0xDF, 0x65, 0x81, 0x9E, 0x27, 0x20, 0xAB, 0x08, 0x20, 0x10, 0x9A,
  0x08, 0x30, 0x3A, 0x08, 0x30, 0x3A, 0x08, 0x30, 0x3A, 0x08, 0x30, 0x3A, 0x08, 0x30, 0x3A, 0x08,
  0x30, 0x3A, 0x08, 0x20, 0x10, 0x9A, 0x82, 0xC3, 0x0A, 0xD0,
  // "í" (U+00ED)
  0x38, 0x2C, 0xFD, 0x12, 0x82, 0x6F, 0xD2, 0x28, 0x11, 0xE9, 0x73, 0x0A, 0xB0, 0x82, 0x01, 0x09,
  0xA0, 0x83, 0x03, 0xA0, 0x83, 0x03, 0xA0, 0x83, 0x03, 0xA0, 0x83, 0x03, 0xA0, 0x83, 0x03, 0xA0,
  0x83, 0x03, 0xA0, 0x82, 0x01, 0x09, 0xA8, 0x2C, 0x30, 0xAD, 0x10,
  // "î" (U+00EE)
  0x20, 0x9A, 0x06, 0x28, 0x74, 0xFA, 0xCE, 0x21, 0xE8, 0x20, 0xA0, 0xD7, 0x10, 0xAB, 0x08, 0x20,
  0x10, 0x9A, 0x08, 0x30, 0x3A, 0x08, 0x30, 0x3A, 0x08, 0x30, 0x3A, 0x08, 0x30, 0x3A, 0x08, 0x30,
  0x3A, 0x08, 0x30, 0x3A, 0x08, 0x20, 0x10, 0x9A, 0x82, 0xC3, 0x0A, 0xD0,
  // "ï" (U+00EF)
  0x10, 0x14, 0x89, 0x29, 0xF4, 0x0E, 0xE7, 0xE3, 0x0C, 0xC6, 0x0A, 0xB8, 0x28, 0x01, 0x9A, 0x08,
  0x20, 0x3A, 0x08, 0x20, 0x3A, 0x08, 0x20, 0x3A, 0x08, 0x20, 0x3A, 0x08, 0x20, 0x3A, 0x08, 0x20,
  0x3A, 0x82, 0x80, 0x19, 0xA8, 0x1C, 0x3A, 0xD0,
  // "ð" (U+00F0)
  0x20, 0x20, 0x34, 0x01, 0x48, 0x55, 0xEE, 0x87, 0xE4, 0x60, 0xBA, 0x06, 0x68, 0x4C, 0xB5, 0xDE,
  0x25, 0x03, 0x28, 0x14, 0xFC, 0x48, 0x33, 0xBE, 0xEB, 0xA0, 0x52, 0x03, 0xA8, 0x19, 0x38, 0xA0,
  0xB2, 0x81, 0xBF, 0xE3, 0x0D, 0xA2, 0xA0, 0xB3, 0x0A, 0xA0, 0x01, 0xA0, 0xA3, 0x09, 0xA0, 0x20,
  0x1A, 0x0A, 0x30, 0x9A, 0x01, 0x1A, 0x0B, 0x38, 0x1A, 0xFE, 0x28, 0x1B, 0xFE, 0x38, 0x1E, 0xF9,
  0x28, 0x72, 0xEF, 0x93, 0x8F, 0xE1, 0x38, 0x52, 0xAE, 0xFD, 0x91, 0x20,
  // "ñ" (U+00F1)
  0x38, 0x55, 0xED, 0x71, 0x8B, 0x48, 0x61, 0xF4, 0x6D, 0xFE, 0x25, 0x02, 0x30, 0x17, 0x72, 0x08,
  0xB8, 0x46, 0x9E, 0xEB, 0x22, 0x01, 0x08, 0xB8, 0x35, 0x4E, 0xFD, 0x30, 0x3A, 0x0B, 0x20, 0x9A,
  0x02, 0x20, 0x3A, 0x09, 0x20, 0x7A, 0x04, 0x20, 0x3A, 0x08, 0x20, 0x7A, 0x04, 0x20, 0x3A, 0x08,
  0x20, 0x7A, 0x04, 0x20, 0x3A, 0x08, 0x20, 0x7A, 0x04, 0x20, 0x3A, 0x08, 0x20, 0x7A, 0x82, 0x40,
  0x29, 0xA8, 0x2C, 0x30, 0x7A, 0x81, 0x91, 0x9C, 0x81, 0xD0, 0x7B, 0x08,
  // "ò" (U+00F2)
  0x18, 0x21, 0xDF, 0xC7, 0x18, 0x22, 0xDF, 0x67, 0x28, 0x19, 0xE2, 0x77, 0x38, 0x52, 0xAE, 0xFE,
  0xA2, 0x38, 0x73, 0xEF, 0x93, 0x9F, 0xE2, 0x28, 0x1B, 0xFE, 0x38, 0x1E, 0xFB, 0x2A, 0x0B, 0x30,
  0xBA, 0x10, 0x1A, 0x0A, 0x30, 0x9A, 0x02, 0x01, 0xA0, 0xA3, 0x0A, 0xA0, 0x21, 0xA0, 0xB3, 0x0B,
  0xA2, 0x81, 0xBF, 0xE3, 0x81, 0xEF, 0xB2, 0x87, 0x2E, 0xF9, 0x39, 0xFE, 0x33, 0x85, 0x29, 0xEF,
  0xEA, 0x22,
  // "ó" (U+00F3)
  0x68, 0x2C, 0xFD, 0x16, 0x82, 0x6F, 0xD2, 0x68, 0x11, 0xE9, 0x77, 0x38, 0x52, 0xAE, 0xFE, 0xA2,
  0x38, 0x73, 0xEF, 0x93, 0x9F, 0xE2, 0x28, 0x1B, 0xFE, 0x38, 0x1E, 0xFB, 0x2A, 0x0B, 0x30, 0xBA,
  0x10, 0x1A, 0x0A, 0x30, 0x9A, 0x02, 0x01, 0xA0, 0xA3, 0x0A, 0xA0, 0x21, 0xA0, 0xB3, 0x0B, 0xA2,
  0x81, 0xBF, 0xE3, 0x81, 0xEF, 0xB2, 0x87, 0x2E, 0xF9, 0x39, 0xFE, 0x33, 0x85, 0x29, 0xEF, 0xEA,
  0x22,
  // "ô" (U+00F4)
  0x40, 0x9A, 0x06, 0x68, 0x44, 0xFA, 0xCE, 0x24, 0x81, 0x1E, 0x82, 0x0A, 0x0D, 0x77, 0x18, 0x52,
  0xAE, 0xFE, 0xA2, 0x38, 0x73, 0xEF, 0x93, 0x9F, 0xE2, 0x28, 0x1B, 0xFE, 0x38, 0x1E, 0xFB, 0x2A,
  0x0B, 0x30, 0xBA, 0x10, 0x1A, 0x0A, 0x30, 0x9A, 0x02, 0x01, 0xA0, 0xA3, 0x0A, 0xA0, 0x21, 0xA0,
  0xB3, 0x0B, 0xA2, 0x81, 0xBF, 0xE3, 0x81, 0xEF, 0xB2, 0x87, 0x2E, 0xF9, 0x39, 0xFE, 0x33, 0x85,
  0x29, 0xEF, 0xEA, 0x22,
  // "õ" (U+00F5)
  0x28, 0x55, 0xED, 0x71, 0x8B, 0x38, 0x61, 0xF4, 0x6D, 0xFE, 0x24, 0x02, 0x30, 0x17, 0x73, 0x85,
  0x2A, 0xEF, 0xEA, 0x23, 0x87, 0x3E, 0xF9, 0x39, 0xFE, 0x22, 0x81, 0xBF, 0xE3, 0x81, 0xEF, 0xB2,
  0xA0, 0xB3, 0x0B, 0xA1, 0x01, 0xA0, 0xA3, 0x09, 0xA0, 0x20, 0x1A, 0x0A, 0x30, 0xAA, 0x02, 0x1A,
  0x0B, 0x30, 0xBA, 0x28, 0x1B, 0xFE, 0x38, 0x1E, 0xFB, 0x28, 0x72, 0xEF, 0x93, 0x9F, 0xE3, 0x38,
  0x52, 0x9E, 0xFE, 0xA2, 0x20,
  // "ö" (U+00F6)
  0x30, 0x17, 0x28, 0x49, 0xF4, 0x0E, 0xE5, 0x84, 0x7E, 0x30, 0xCC, 0x77, 0x28, 0x52, 0xAE, 0xFE,
  0xA2, 0x38, 0x73, 0xEF, 0x93, 0x9F, 0xE2, 0x28, 0x1B, 0xFE, 0x38, 0x1E, 0xFB, 0x2A, 0x0B, 0x30,
  0xBA, 0x10, 0x1A, 0x0A, 0x30, 0x9A, 0x02, 0x01, 0xA0, 0xA3, 0x0A, 0xA0, 0x21, 0xA0, 0xB3, 0x0B,
  0xA2, 0x81, 0xBF, 0xE3, 0x81, 0xEF, 0xB2, 0x87, 0x2E, 0xF9, 0x39, 0xFE, 0x33, 0x85, 0x29, 0xEF,
  0xEA, 0x22,
  // "÷" (U+00F7)
  0x30, 0xD0, 0xE6, 0x0B, 0x0C, 0x77, 0x50, 0xCE, 0x0D, 0x80, 0x42, 0x74, 0x0D, 0x0E, 0x60, 0xB0,
  0xC3,
  // "ø" (U+00F8)
  0x71, 0x06, 0x03, 0x38, 0x62, 0xAE, 0xFE, 0xBE, 0x12, 0x87, 0x3E, 0xF9, 0x38, 0xFE, 0x22, 0x81,
  0xBF, 0xE2, 0x08, 0xA0, 0xB2, 0xA8, 0x3B, 0x02, 0xED, 0xA1, 0x01, 0xA8, 0x3A, 0x0B, 0x89, 0xA0,
  0x20, 0x1A, 0x83, 0xA5, 0xD0, 0x9A, 0x87, 0x20, 0xEF, 0xCE, 0x40, 0xBA, 0x20, 0xAA, 0x0A, 0x28,
  0x1E, 0xFB, 0x28, 0x72, 0xEF, 0x93, 0x9F, 0xE3, 0x38, 0x5D, 0xBE, 0xFE, 0xA2, 0x30, 0x20, 0x77,
  0x10,
  // "ù" (U+00F9)
  0x28, 0x21, 0xDF, 0xC7, 0x28, 0x22, 0xDF, 0x67, 0x38, 0x19, 0xE2, 0x77, 0x20, 0x8B, 0x81, 0x70,
  0xDB, 0x82, 0x30, 0x19, 0xA8, 0x27, 0x03, 0xCA, 0x03, 0x20, 0x4A, 0x07, 0x20, 0x8A, 0x03, 0x20,
  0x4A, 0x07, 0x20, 0x8A, 0x03, 0x20, 0x4A, 0x07, 0x20, 0x8A, 0x03, 0x20, 0x4A, 0x07, 0x20, 0x8A,
  0x03, 0x20, 0x3A, 0x07, 0x20, 0x8A, 0x03, 0x20, 0x2A, 0x09, 0x20, 0xBA, 0x03, 0x38, 0x4C, 0xFE,
  0x36, 0xEA, 0x08, 0x01, 0x28, 0x42, 0xBE, 0xDA, 0x4B, 0x08,
  // "ú" (U+00FA)
  0x68, 0x2C, 0xFD, 0x17, 0x82, 0x6F, 0xD2, 0x78, 0x11, 0xE9, 0x77, 0x30, 0x8B, 0x81, 0x70, 0xDB,
  0x82, 0x30, 0x19, 0xA8, 0x27, 0x03, 0xCA, 0x03, 0x20, 0x4A, 0x07, 0x20, 0x8A, 0x03, 0x20, 0x4A,
  0x07, 0x20, 0x8A, 0x03, 0x20, 0x4A, 0x07, 0x20, 0x8A, 0x03, 0x20, 0x4A, 0x07, 0x20, 0x8A, 0x03,
  0x20, 0x3A, 0x07, 0x20, 0x8A, 0x03, 0x20, 0x2A, 0x09, 0x20, 0xBA, 0x03, 0x38, 0x4C, 0xFE, 0x36,
  0xEA, 0x08, 0x01, 0x28, 0x42, 0xBE, 0xDA, 0x4B, 0x08,
  // "û" (U+00FB)
  0x40, 0x9A, 0x06, 0x78, 0x44, 0xFA, 0xCE, 0x25, 0x81, 0x1E, 0x82, 0x0A, 0x0D, 0x77, 0x10, 0x8B,
  0x81, 0x70, 0xDB, 0x82, 0x30, 0x19, 0xA8, 0x27, 0x03, 0xCA, 0x03, 0x20, 0x4A, 0x07, 0x20, 0x8A,
  0x03, 0x20, 0x4A, 0x07, 0x20, 0x8A, 0x03, 0x20, 0x4A, 0x07, 0x20, 0x8A, 0x03, 0x20, 0x4A, 0x07,
  0x20, 0x8A, 0x03, 0x20, 0x3A, 0x07, 0x20, 0x8A, 0x03, 0x20, 0x2A, 0x09, 0x20, 0xBA, 0x03, 0x38,
  0x4C, 0xFE, 0x36, 0xEA, 0x08, 0x01, 0x28, 0x42, 0xBE, 0xDA, 0x4B, 0x08,
  // "ü" (U+00FC)
  0x40, 0x17, 0x38, 0x49, 0xF4, 0x0E, 0xE6, 0x84, 0x7E, 0x30, 0xCC, 0x77, 0x10, 0x8B, 0x81, 0x70,
  0xDB, 0x82, 0x30, 0x19, 0xA8, 0x27, 0x03, 0xCA, 0x03, 0x20, 0x4A, 0x07, 0x20, 0x8A, 0x03, 0x20,
  0x4A, 0x07, 0x20, 0x8A, 0x03, 0x20, 0x4A, 0x07, 0x20, 0x8A, 0x03, 0x20, 0x4A, 0x07, 0x20, 0x8A,
  0x03, 0x20, 0x3A, 0x07, 0x20, 0x8A, 0x03, 0x20, 0x2A, 0x09, 0x20, 0xBA, 0x03, 0x38, 0x4C, 0xFE,
  0x36, 0xEA, 0x08, 0x01, 0x28, 0x42, 0xBE, 0xDA, 0x4B, 0x08,
  // "ý" (U+00FD)
  0x58, 0x2C, 0xFD, 0x16, 0x82, 0x6F, 0xD2, 0x68, 0x11, 0xE9, 0x77, 0x2D, 0x01, 0x09, 0xB8, 0x16,
  0x3E, 0xA8, 0x74, 0x01, 0x8F, 0x81, 0x08, 0xA0, 0x22, 0x07, 0x0E, 0x30, 0x1A, 0x08, 0x20, 0xC0,
  0x94, 0x85, 0xAF, 0xE0, 0x1F, 0x34, 0x04, 0xA8, 0x15, 0x7C, 0x68, 0x3D, 0xFA, 0xC7, 0x68, 0x37,
  0xFE, 0xF1, 0x60, 0x1A, 0x0B, 0x71, 0x81, 0xAF, 0x57, 0x10, 0xD0, 0xE7, 0x18, 0x16, 0xF8, 0x58,
  0x41, 0x38, 0xFD, 0x15, 0x83, 0x7F, 0xD9, 0x16,
  // "þ" (U+00FE)
  0x09, 0xB0, 0x76, 0x01, 0x09, 0xA0, 0x77, 0x04, 0xA0, 0x77, 0x04, 0xA0, 0x77, 0x04, 0xA8, 0x46,
  0x9E, 0xEB, 0x22, 0x04, 0xA8, 0x7D, 0x73, 0xCF, 0xE1, 0x04, 0xA0, 0xB2, 0x05, 0xA8, 0x16, 0x04,
  0xA0, 0x82, 0x01, 0xA8, 0x1A, 0x04, 0xA0, 0x73, 0xA8, 0x1B, 0x04, 0xA0, 0x73, 0xA8, 0x1B, 0x04,
  0xA0, 0x82, 0x01, 0xA8, 0x1A, 0x04, 0xA0, 0xB2, 0x04, 0xA8, 0x16, 0x04, 0xA8, 0x7E, 0x63, 0xCF,
  0xE1, 0x04, 0xA8, 0x46, 0x9E, 0xFB, 0x22, 0x04, 0xA0, 0x77, 0x04, 0xA0, 0x76, 0x01, 0x0A, 0xA0,
  0xB0, 0x25, 0x0B, 0xD0, 0x24,
  // "ÿ" (U+00FF)
  0x30, 0x17, 0x28, 0x49, 0xF4, 0x0E, 0xE5, 0x84, 0x7E, 0x30, 0xCC, 0x77, 0xD0, 0x10, 0x9B, 0x81,
  0x63, 0xEA, 0x87, 0x40, 0x18, 0xF8, 0x10, 0x8A, 0x02, 0x20, 0x70, 0xE3, 0x01, 0xA0, 0x82, 0x0C,
  0x09, 0x48, 0x5A, 0xFE, 0x01, 0xF3, 0x40, 0x4A, 0x81, 0x57, 0xC6, 0x83, 0xDF, 0xAC, 0x76, 0x83,
  0x7F, 0xEF, 0x16, 0x01, 0xA0, 0xB7, 0x18, 0x1A, 0xF5, 0x71, 0x0D, 0x0E, 0x71, 0x81, 0x6F, 0x85,
  0x84, 0x13, 0x8F, 0xD1, 0x58, 0x37, 0xFD, 0x91, 0x60,
  // "Ā" (U+0100)
  0x30, 0x4C, 0x0E, 0x72, 0x80, 0x12, 0x73, 0x08, 0xA0, 0x47, 0x30, 0xDA, 0x09, 0x72, 0x83, 0x4F,
  0xBF, 0xE7, 0x28, 0x1A, 0xC6, 0xA0, 0x57, 0x19, 0x07, 0x02, 0xA0, 0xA7, 0x83, 0x6F, 0x20, 0xDA,
  0x01, 0x60, 0xB0, 0xC2, 0x08, 0xA0, 0x65, 0x81, 0x2F, 0x72, 0x03, 0xA0, 0xB5, 0x07, 0xF9, 0x01,
  0x48, 0x5D, 0xC2, 0x22, 0x29, 0xA0, 0x73, 0x81, 0x4F, 0x54, 0x02, 0xA0, 0xD2, 0x83, 0x3C, 0xF6,
  0x13, 0x03, 0xB8, 0x17, 0x1E, 0xB0, 0xB2, 0x06, 0xD0, 0x80,
  // "ā" (U+0101)
  0x20, 0x4C, 0x0E, 0x68, 0x01, 0x25, 0x85, 0x7C, 0xEF, 0xD8, 0x13, 0x05, 0xA8, 0x37, 0x3E, 0xFA,
  0x38, 0x12, 0xBD, 0x28, 0x1B, 0xFE, 0x71, 0x0A, 0xA3, 0x82, 0x18, 0xDE, 0xC3, 0x0B, 0xA8, 0x16,
  0x2B, 0xA2, 0x01, 0xA0, 0xA2, 0x0A, 0xA2, 0x01, 0xA0, 0x92, 0x0D, 0xA3, 0x84, 0xDF, 0xD3, 0x7C,
  0xA0, 0x52, 0x84, 0x2B, 0xED, 0x54, 0xB0, 0x30,
  // "Ă" (U+0102)
  0x30, 0x20, 0xC3, 0x0A, 0x05, 0x71, 0x84, 0xE7, 0x05, 0xF2, 0x71, 0x83, 0x3E, 0xFE, 0x67, 0x40,
  0x17, 0x50, 0x8A, 0x04, 0x73, 0x0D, 0xA0, 0x97, 0x28, 0x34, 0xFB, 0xFE, 0x72, 0x81, 0xAC, 0x6A,
  0x05, 0x71, 0x90, 0x70, 0x2A, 0x0A, 0x78, 0x36, 0xF2, 0x0D, 0xA0, 0x16, 0x0B, 0x0C, 0x20, 0x8A,
  0x06, 0x58, 0x12, 0xF7, 0x20, 0x3A, 0x0B, 0x50, 0x7F, 0x90, 0x14, 0x85, 0xDC, 0x22, 0x22, 0x9A,
  0x07, 0x38, 0x14, 0xF5, 0x40, 0x2A, 0x0D, 0x28, 0x33, 0xCF, 0x61, 0x30, 0x3B, 0x81, 0x71, 0xEB,
  0x0B, 0x20, 0x6D, 0x08,
  // "ă" (U+0103)
  0x20, 0x20, 0xC3, 0x0A, 0x05, 0x58, 0x4E, 0x70, 0x5F, 0x25, 0x83, 0x3E, 0xFE, 0x67, 0x10, 0x17,
  0x85, 0x7C, 0xEF, 0xD8, 0x13, 0x05, 0xA8, 0x37, 0x3E, 0xFA, 0x38, 0x12, 0xBD, 0x28, 0x1B, 0xFE,
  0x71, 0x0A, 0xA3, 0x82, 0x18, 0xDE, 0xC3, 0x0B, 0xA8, 0x16, 0x2B, 0xA2, 0x01, 0xA0, 0xA2, 0x0A,
  0xA2, 0x01, 0xA0, 0x92, 0x0D, 0xA3, 0x84, 0xDF, 0xD3, 0x7C, 0xA0, 0x52, 0x84, 0x2B, 0xED, 0x54,
  0xB0, 0x30,
  // "Ą" (U+0104)
  0x50, 0x8A, 0x04, 0x73, 0x0D, 0xA0, 0x97, 0x28, 0x34, 0xFB, 0xFE, 0x72, 0x81, 0xAC, 0x6A, 0x05,
  0x71, 0x90, 0x70, 0x2A, 0x0A, 0x78, 0x36, 0xF2, 0x0D, 0xA0, 0x16, 0x0B, 0x0C, 0x20, 0x8A, 0x06,
  0x58, 0x12, 0xF7, 0x20, 0x3A, 0x0B, 0x50, 0x7F, 0x90, 0x14, 0x85, 0xDC, 0x22, 0x22, 0x9A, 0x07,
  0x38, 0x14, 0xF5, 0x40, 0x2A, 0x0D, 0x28, 0x33, 0xCF, 0x61, 0x30, 0x3B, 0x81, 0x71, 0xEB, 0x0B,
  0x20, 0x6D, 0x08, 0x72, 0x81, 0x6E, 0x37, 0x38, 0x11, 0xFA, 0x74, 0x83, 0x3F, 0xC2, 0x17, 0x30,
  0xAA, 0x0E, 0x74, 0x81, 0x13, 0x11,
  // "ą" (U+0105)
  0x28, 0x57, 0xCE, 0xFD, 0x81, 0x30, 0x5A, 0x83, 0x73, 0xEF, 0xA3, 0x81, 0x2B, 0xD2, 0x81, 0xBF,
  0xE7, 0x10, 0xAA, 0x38, 0x21, 0x8D, 0xEC, 0x30, 0xBA, 0x81, 0x62, 0xBA, 0x20, 0x1A, 0x0A, 0x20,
  0xAA, 0x20, 0x1A, 0x09, 0x20, 0xDA, 0x38, 0x4D, 0xFD, 0x37, 0xCA, 0x05, 0x28, 0x42, 0xBE, 0xD5,
  0x5B, 0x03, 0x58, 0x16, 0xE3, 0x78, 0x11, 0xFA, 0x71, 0x83, 0x3F, 0xC2, 0x17, 0x0A, 0xA0, 0xE7,
  0x18, 0x11, 0x31, 0x20,
  // "Ć" (U+0106)
  0x68, 0x2C, 0xFD, 0x16, 0x82, 0x6F, 0xD2, 0x68, 0x11, 0xE9, 0x77, 0x38, 0x61, 0x7C, 0xEF, 0xEA,
  0x32, 0x85, 0x2D, 0xF9, 0x33, 0xBA, 0x83, 0x20, 0xDF, 0xB3, 0x02, 0xA0, 0x20, 0x6A, 0x05, 0x48,
  0x29, 0x40, 0xBA, 0x02, 0x70, 0xEA, 0x71, 0xB7, 0x10, 0xEA, 0x71, 0x0C, 0xA0, 0x27, 0x07, 0xA0,
  0x57, 0x18, 0x1D, 0xFC, 0x58, 0x93, 0x52, 0x03, 0xDF, 0xB4, 0x23, 0x9E, 0x12, 0x86, 0x17, 0xCE,
  0xFE, 0xA2, 0x10,
  // "ć" (U+0107)
  0x58, 0x2C, 0xFD, 0x14, 0x82, 0x6F, 0xD2, 0x48, 0x11, 0xE9, 0x77, 0x87, 0x3A, 0xEF, 0xD9, 0x10,
  0x3A, 0x87, 0x83, 0xEF, 0xA0, 0xBF, 0xE2, 0x81, 0x9F, 0x91, 0xA0, 0xB2, 0x82, 0x35, 0x01, 0xA0,
  0xA5, 0x01, 0xA0, 0xA6, 0xA0, 0xB6, 0x81, 0xBF, 0xE4, 0x81, 0x40, 0x3A, 0x83, 0xA3, 0x3A, 0xA2,
  0x85, 0x3A, 0xEF, 0xD9, 0x10,
  // "Ĉ" (U+0108)
  0x40, 0x9A, 0x06, 0x68, 0x44, 0xFA, 0xCE, 0x24, 0x81, 0x1E, 0x82, 0x0A, 0x0D, 0x77, 0x18, 0x61,
  0x7C, 0xEF, 0xEA, 0x32, 0x85, 0x2D, 0xF9, 0x33, 0xBA, 0x83, 0x20, 0xDF, 0xB3, 0x02, 0xA0, 0x20,
  0x6A, 0x05, 0x48, 0x29, 0x40, 0xBA, 0x02, 0x70, 0xEA, 0x71, 0xB7, 0x10, 0xEA, 0x71, 0x0C, 0xA0,
  0x27, 0x07, 0xA0, 0x57, 0x18, 0x1D, 0xFC, 0x58, 0x93, 0x52, 0x03, 0xDF, 0xB4, 0x23, 0x9E, 0x12,
  0x86, 0x17, 0xCE, 0xFE, 0xA2, 0x10,
  // "ĉ" (U+0109)
  0x30, 0x9A, 0x06, 0x48, 0x44, 0xFA, 0xCE, 0x22, 0x81, 0x1E, 0x82, 0x0A, 0x0D, 0x75, 0x87, 0x3A,
  0xEF, 0xD9, 0x10, 0x3A, 0x87, 0x83, 0xEF, 0xA0, 0xBF, 0xE2, 0x81, 0x9F, 0x91, 0xA0, 0xB2, 0x82,
  0x35, 0x01, 0xA0, 0xA5, 0x01, 0xA0, 0xA6, 0xA0, 0xB6, 0x81, 0xBF, 0xE4, 0x81, 0x40, 0x3A, 0x83,
  0xA3, 0x3A, 0xA2, 0x85, 0x3A, 0xEF, 0xD9, 0x10,
  // "Ċ" (U+010A)
  0x58, 0x1A, 0xC4, 0x70, 0x3A, 0x0B, 0x71, 0x81, 0xCE, 0x67, 0x72, 0x86, 0x17, 0xCE, 0xFE, 0xA3,
  0x28, 0x52, 0xDF, 0x93, 0x3B, 0xA8, 0x32, 0x0D, 0xFB, 0x30, 0x2A, 0x02, 0x06, 0xA0, 0x54, 0x82,
  0x94, 0x0B, 0xA0, 0x27, 0x0E, 0xA7, 0x1B, 0x71, 0x0E, 0xA7, 0x10, 0xCA, 0x02, 0x70, 0x7A, 0x05,
  0x71, 0x81, 0xDF, 0xC5, 0x89, 0x35, 0x20, 0x3D, 0xFB, 0x42, 0x39, 0xE1, 0x28, 0x61, 0x7C, 0xEF,
  0xEA, 0x21,
  // "ċ" (U+010B)
  0x48, 0x1A, 0xC4, 0x50, 0x3A, 0x0B, 0x68, 0x1C, 0xE6, 0x76, 0x87, 0x3A, 0xEF, 0xD9, 0x10, 0x3A,
  0x87, 0x83, 0xEF, 0xA0, 0xBF, 0xE2, 0x81, 0x9F, 0x91, 0xA0, 0xB2, 0x82, 0x35, 0x01, 0xA0, 0xA5,
  0x01, 0xA0, 0xA6, 0xA0, 0xB6, 0x81, 0xBF, 0xE4, 0x81, 0x40, 0x3A, 0x83, 0xA3, 0x3A, 0xA2, 0x85,
  0x3A, 0xEF, 0xD9, 0x10,
  // "Č" (U+010C)
  0x28, 0x11, 0xE8, 0x20, 0xA0, 0xD5, 0x84, 0x4F, 0xAC, 0xE2, 0x60, 0x9A, 0x06, 0x77, 0x28, 0x61,
  0x7C, 0xEF, 0xEA, 0x32, 0x85, 0x2D, 0xF9, 0x33, 0xBA, 0x83, 0x20, 0xDF, 0xB3, 0x02, 0xA0, 0x20,
  0x6A, 0x05, 0x48, 0x29, 0x40, 0xBA, 0x02, 0x70, 0xEA, 0x71, 0xB7, 0x10, 0xEA, 0x71, 0x0C, 0xA0,
  0x27, 0x07, 0xA0, 0x57, 0x18, 0x1D, 0xFC, 0x58, 0x93, 0x52, 0x03, 0xDF, 0xB4, 0x23, 0x9E, 0x12,
  0x86, 0x17, 0xCE, 0xFE, 0xA2, 0x10,
  // "č" (U+010D)
  0x18, 0x11, 0xE8, 0x20, 0xA0, 0xD3, 0x84, 0x4F, 0xAC, 0xE2, 0x40, 0x9A, 0x06, 0x76, 0x87, 0x3A,
  0xEF, 0xD9, 0x10, 0x3A, 0x87, 0x83, 0xEF, 0xA0, 0xBF, 0xE2, 0x81, 0x9F, 0x91, 0xA0, 0xB2, 0x82,
  0x35, 0x01, 0xA0, 0xA5, 0x01, 0xA0, 0xA6, 0xA0, 0xB6, 0x81, 0xBF, 0xE4, 0x81, 0x40, 0x3A, 0x83,
  0xA3, 0x3A, 0xA2, 0x85, 0x3A, 0xEF, 0xD9, 0x10,
  // "Ď" (U+010E)
  0x38, 0x11, 0xE8, 0x20, 0xA0, 0xD7, 0x84, 0x4F, 0xAC, 0xE2, 0x71, 0x09, 0xA0, 0x67, 0x73, 0x07,
  0xE8, 0x1E, 0xB6, 0x38, 0x11, 0x3E, 0xA8, 0x52, 0x26, 0xEF, 0xC1, 0x30, 0xCA, 0x30, 0x2A, 0x0C,
  0x30, 0xCA, 0x40, 0x9A, 0x05, 0x20, 0xCA, 0x40, 0x5A, 0x09, 0x20, 0xCA, 0x40, 0x4A, 0x0B, 0x20,
  0xCA, 0x40, 0x3A, 0x0C, 0x20, 0xCA, 0x40, 0x4A, 0x0A, 0x20, 0xCA, 0x40, 0x7A, 0x07, 0x20, 0xCA,
  0x40, 0xBA, 0x02, 0x20, 0xCA, 0x30, 0x4A, 0x83, 0x90, 0x13, 0xEA, 0x84, 0x23, 0x7E, 0xFA, 0x20,
  0x7E, 0x81, 0xDB, 0x53,
  // "ď" (U+010F)
  0x50, 0x7B, 0x83, 0xD0, 0x8F, 0x75, 0x01, 0x05, 0xA8, 0x2D, 0x0C, 0xD7, 0x18, 0x4D, 0xFD, 0x1E,
  0x47, 0x18, 0x1D, 0xFD, 0x68, 0x66, 0xDF, 0xD5, 0xCF, 0xD5, 0x06, 0xA8, 0x48, 0x3B, 0xEF, 0xD5,
  0x81, 0xDF, 0xD2, 0x02, 0xA0, 0xD5, 0xA0, 0xA3, 0xA0, 0xD4, 0x02, 0xA0, 0x93, 0x81, 0xEF, 0xD4,
  0x02, 0xA0, 0x93, 0x81, 0xEF, 0xD4, 0x01, 0xA0, 0xA3, 0xA0, 0xD5, 0x81, 0xDF, 0xD2, 0x02, 0xA0,
  0xD5, 0x06, 0xA8, 0x27, 0x3B, 0xDA, 0x05, 0x01, 0x48, 0x46, 0xDF, 0xD6, 0x3B, 0x06, 0x20,
  // "Đ" (U+0110)
  0x07, 0xE8, 0x1E, 0xB6, 0x38, 0x11, 0x3E, 0xA8, 0x52, 0x26, 0xEF, 0xC1, 0x30, 0xCA, 0x30, 0x2A,
  0x0C, 0x30, 0xCA, 0x40, 0x9A, 0x05, 0x20, 0xCA, 0x40, 0x5A, 0x09, 0x20, 0xCA, 0x40, 0x4A, 0x0B,
  0x04, 0xE8, 0x14, 0x03, 0xA8, 0x2C, 0x02, 0xDA, 0x00, 0x22, 0x04, 0xA0, 0xA2, 0x0C, 0xA4, 0x07,
  0xA0, 0x72, 0x0C, 0xA4, 0x0B, 0xA0, 0x22, 0x0C, 0xA3, 0x04, 0xA8, 0x39, 0x01, 0x3E, 0xA8, 0x42,
  0x37, 0xEF, 0xA2, 0x07, 0xE8, 0x1D, 0xB5, 0x30,
  // "đ" (U+0111)
  0x50, 0x7B, 0x0D, 0x78, 0x31, 0x4E, 0xFD, 0x60, 0xAE, 0x06, 0x48, 0x61, 0x22, 0xDF, 0xD2, 0x12,
  0x86, 0x6D, 0xFD, 0x5C, 0xFD, 0x30, 0x6A, 0x84, 0x73, 0xBE, 0xFD, 0x38, 0x1D, 0xFD, 0x20, 0x2A,
  0x0D, 0x3A, 0x0A, 0x3A, 0x0D, 0x20, 0x2A, 0x09, 0x38, 0x1E, 0xFD, 0x20, 0x2A, 0x09, 0x38, 0x1E,
  0xFD, 0x20, 0x1A, 0x0A, 0x38, 0x1E, 0xFD, 0x38, 0x1D, 0xFD, 0x20, 0x2A, 0x0D, 0x30, 0x6A, 0x82,
  0x73, 0xBD, 0xA0, 0x50, 0x12, 0x84, 0x6D, 0xFD, 0x63, 0xB0, 0x60,
  // "Ē" (U+0112)
  0x30, 0x4C, 0x0E, 0x78, 0x01, 0x23, 0x07, 0xC0, 0xFE, 0xA0, 0x73, 0x0E, 0xA3, 0x81, 0x2F, 0x83,
  0x0C, 0xA4, 0x0C, 0x08, 0x30, 0xCA, 0x40, 0x50, 0x43, 0x0C, 0xA7, 0x20, 0xCA, 0x72, 0x0C, 0xE0,
  0x44, 0x0C, 0xA0, 0x30, 0xF2, 0x50, 0xCA, 0x72, 0x0C, 0xA5, 0x02, 0x30, 0xCA, 0x48, 0x12, 0xF2,
  0x20, 0xEA, 0x48, 0x28, 0xF1, 0x7C, 0x80, 0x0E, 0xA0, 0x10,
  // "ē" (U+0113)
  0x20, 0x4C, 0x0E, 0x58, 0x01, 0x24, 0x84, 0x2A, 0xEF, 0xD7, 0x38, 0x62, 0xEF, 0x83, 0xCF, 0xB2,
  0x81, 0xBF, 0xD2, 0x06, 0xA0, 0x31, 0xA0, 0xB2, 0x04, 0xA0, 0x70, 0x1F, 0x90, 0x70, 0x2A, 0x0A,
  0x80, 0x12, 0x01, 0x1A, 0x0B, 0x70, 0xAA, 0x01, 0x30, 0x52, 0x86, 0x2E, 0xFC, 0x33, 0x8E, 0x38,
  0x52, 0xAE, 0xFE, 0xB3, 0x10,
  // "Ĕ" (U+0114)
  0x20, 0x20, 0xC3, 0x0A, 0x05, 0x68, 0x4E, 0x70, 0x5F, 0x26, 0x83, 0x3E, 0xFE, 0x67, 0x20, 0x16,
  0x07, 0xC0, 0xFE, 0xA0, 0x73, 0x0E, 0xA3, 0x81, 0x2F, 0x83, 0x0C, 0xA4, 0x0C, 0x08, 0x30, 0xCA,
  0x40, 0x50, 0x43, 0x0C, 0xA7, 0x20, 0xCA, 0x72, 0x0C, 0xE0, 0x44, 0x0C, 0xA0, 0x30, 0xF2, 0x50,
  0xCA, 0x72, 0x0C, 0xA5, 0x02, 0x30, 0xCA, 0x48, 0x12, 0xF2, 0x20, 0xEA, 0x48, 0x28, 0xF1, 0x7C,
  0x80, 0x0E, 0xA0, 0x10,
  // "ĕ" (U+0115)
  0x20, 0x20, 0xC3, 0x0A, 0x05, 0x48, 0x4E, 0x70, 0x5F, 0x24, 0x83, 0x3E, 0xFE, 0x67, 0x01, 0x68,
  0x42, 0xAE, 0xFD, 0x73, 0x86, 0x2E, 0xF8, 0x3C, 0xFB, 0x28, 0x1B, 0xFD, 0x20, 0x6A, 0x03, 0x1A,
  0x0B, 0x20, 0x4A, 0x07, 0x01, 0xF9, 0x07, 0x02, 0xA0, 0xA8, 0x01, 0x20, 0x11, 0xA0, 0xB7, 0x0A,
  0xA0, 0x13, 0x05, 0x28, 0x62, 0xEF, 0xC3, 0x38, 0xE3, 0x85, 0x2A, 0xEF, 0xEB, 0x31,
  // "Ė" (U+0116)
  0x58, 0x1A, 0xC4, 0x71, 0x03, 0xA0, 0xB7, 0x28, 0x1C, 0xE6, 0x77, 0x20, 0x7C, 0x0F, 0xEA, 0x07,
  0x30, 0xEA, 0x38, 0x12, 0xF8, 0x30, 0xCA, 0x40, 0xC0, 0x83, 0x0C, 0xA4, 0x05, 0x04, 0x30, 0xCA,
  0x72, 0x0C, 0xA7, 0x20, 0xCE, 0x04, 0x40, 0xCA, 0x03, 0x0F, 0x25, 0x0C, 0xA7, 0x20, 0xCA, 0x50,
  0x23, 0x0C, 0xA4, 0x81, 0x2F, 0x22, 0x0E, 0xA4, 0x82, 0x8F, 0x17, 0xC8, 0x00, 0xEA, 0x01,
  // "ė" (U+0117)
  0x48, 0x1A, 0xC4, 0x60, 0x3A, 0x0B, 0x78, 0x1C, 0xE6, 0x77, 0x18, 0x42, 0xAE, 0xFD, 0x73, 0x86,
  0x2E, 0xF8, 0x3C, 0xFB, 0x28, 0x1B, 0xFD, 0x20, 0x6A, 0x03, 0x1A, 0x0B, 0x20, 0x4A, 0x07, 0x01,
  0xF9, 0x07, 0x02, 0xA0, 0xA8, 0x01, 0x20, 0x11, 0xA0, 0xB7, 0x0A, 0xA0, 0x13, 0x05, 0x28, 0x62,
  0xEF, 0xC3, 0x38, 0xE3, 0x85, 0x2A, 0xEF, 0xEB, 0x31,
  // "Ę" (U+0118)
  0x07, 0xC0, 0xFE, 0xA0, 0x73, 0x0E, 0xA3, 0x81, 0x2F, 0x83, 0x0C, 0xA4, 0x0C, 0x08, 0x30, 0xCA,
  0x40, 0x50, 0x43, 0x0C, 0xA7, 0x20, 0xCA, 0x72, 0x0C, 0xE0, 0x44, 0x0C, 0xA0, 0x30, 0xF2, 0x50,
  0xCA, 0x72, 0x0C, 0xA5, 0x02, 0x30, 0xCA, 0x48, 0x12, 0xF2, 0x20, 0xEA, 0x48, 0x28, 0xF1, 0x7C,
  0x00, 0xEC, 0x01, 0x68, 0x14, 0xE5, 0x72, 0x0E, 0x0C, 0x73, 0x98, 0x1D, 0x21, 0x71, 0x08, 0xB0,
  0x17, 0x18, 0x11, 0x31, 0x20,
  // "ę" (U+0119)
  0x28, 0x42, 0xAE, 0xFD, 0x73, 0x86, 0x2E, 0xF8, 0x3C, 0xFB, 0x28, 0x1B, 0xFD, 0x20, 0x6A, 0x03,
  0x1A, 0x0B, 0x20, 0x4A, 0x07, 0x01, 0xF9, 0x07, 0x02, 0xA0, 0xA8, 0x01, 0x20, 0x11, 0xA0, 0xB7,
  0x0A, 0xA0, 0x13, 0x05, 0x28, 0x62, 0xEF, 0xC3, 0x38, 0xE3, 0x81, 0x2A, 0xEA, 0x0D, 0x04, 0x58,
  0x12, 0xD9, 0x70, 0xB9, 0x71, 0x83, 0xCF, 0x52, 0x15, 0x83, 0x3C, 0xFE, 0x41,
  // "Ě" (U+011A)
  0x28, 0x11, 0xE8, 0x20, 0xA0, 0xD6, 0x84, 0x4F, 0xAC, 0xE2, 0x70, 0x9A, 0x06, 0x77, 0x20, 0x7C,
  0x0F, 0xEA, 0x07, 0x30, 0xEA, 0x38, 0x12, 0xF8, 0x30, 0xCA, 0x40, 0xC0, 0x83, 0x0C, 0xA4, 0x05,
  0x04, 0x30, 0xCA, 0x72, 0x0C, 0xA7, 0x20, 0xCE, 0x04, 0x40, 0xCA, 0x03, 0x0F, 0x25, 0x0C, 0xA7,
  0x20, 0xCA, 0x50, 0x23, 0x0C, 0xA4, 0x81, 0x2F, 0x22, 0x0E, 0xA4, 0x82, 0x8F, 0x17, 0xC8, 0x00,
  0xEA, 0x01,
  // "ě" (U+011B)
  0x18, 0x11, 0xE8, 0x20, 0xA0, 0xD4, 0x84, 0x4F, 0xAC, 0xE2, 0x50, 0x9A, 0x06, 0x77, 0x18, 0x42,
  0xAE, 0xFD, 0x73, 0x86, 0x2E, 0xF8, 0x3C, 0xFB, 0x28, 0x1B, 0xFD, 0x20, 0x6A, 0x03, 0x1A, 0x0B,
  0x20, 0x4A, 0x07, 0x01, 0xF9, 0x07, 0x02, 0xA0, 0xA8, 0x01, 0x20, 0x11, 0xA0, 0xB7, 0x0A, 0xA0,
  0x13, 0x05, 0x28, 0x62, 0xEF, 0xC3, 0x38, 0xE3, 0x85, 0x2A, 0xEF, 0xEB, 0x31,
  // "Ĝ" (U+011C)
  0x40, 0x9A, 0x06, 0x71, 0x84, 0x4F, 0xAC, 0xE2, 0x68, 0x11, 0xE8, 0x20, 0xA0, 0xD7, 0x76, 0x81,
  0x5B, 0xDA, 0x81, 0xD9, 0x23, 0x89, 0x11, 0xCF, 0xC5, 0x25, 0xDF, 0xE1, 0x28, 0x1C, 0xFD, 0x40,
  0x5A, 0x81, 0x10, 0x6A, 0x06, 0x48, 0x11, 0x83, 0x20, 0xBA, 0x02, 0x72, 0x0E, 0xA7, 0x3B, 0x73,
  0x0E, 0xA0, 0x12, 0x04, 0xD0, 0x50, 0xBA, 0x02, 0x30, 0x40, 0xEA, 0x81, 0x60, 0x6A, 0x07, 0x40,
  0xCA, 0x38, 0x2D, 0xFD, 0x13, 0x0C, 0xA3, 0x86, 0x2C, 0xFC, 0x52, 0x2D, 0xA5, 0x86, 0x6B, 0xDF,
  0xEC, 0x94, 0x20,
  // "ĝ" (U+011D)
  0x30, 0x9A, 0x06, 0x58, 0x44, 0xFA, 0xCE, 0x23, 0x81, 0x1E, 0x82, 0x0A, 0x0D, 0x72, 0x81, 0x7E,
  0xA2, 0x89, 0x68, 0xDF, 0xED, 0xBA, 0xC0, 0x9F, 0xC3, 0x9F, 0xB3, 0x83, 0xEF, 0x60, 0x3A, 0x03,
  0x2A, 0x81, 0x60, 0x2A, 0x03, 0x28, 0x5B, 0xFB, 0x07, 0xFE, 0x30, 0x10, 0xBB, 0x0C, 0x03, 0x38,
  0x23, 0xE5, 0x26, 0x84, 0xCF, 0x42, 0x21, 0x40, 0x9D, 0x0E, 0x07, 0x20, 0x50, 0xEE, 0x82, 0x3A,
  0xF8, 0x38, 0x51, 0xDF, 0x6E, 0xF3, 0x48, 0x96, 0xCF, 0x4B, 0xFB, 0x32, 0x39, 0xFB, 0x01, 0x8D,
  0xA8, 0x1E, 0xB6, 0x20,
  // "Ğ" (U+011E)
  0x30, 0x20, 0xC3, 0x0A, 0x05, 0x78, 0x4E, 0x70, 0x5F, 0x27, 0x83, 0x3E, 0xFE, 0x67, 0x30, 0x17,
  0x28, 0x15, 0xBD, 0xA8, 0x1D, 0x92, 0x38, 0x91, 0x1C, 0xFC, 0x52, 0x5D, 0xFE, 0x12, 0x81, 0xCF,
  0xD4, 0x05, 0xA8, 0x11, 0x06, 0xA0, 0x64, 0x81, 0x18, 0x32, 0x0B, 0xA0, 0x27, 0x20, 0xEA, 0x73,
  0xB7, 0x30, 0xEA, 0x01, 0x20, 0x4D, 0x05, 0x0B, 0xA0, 0x23, 0x04, 0x0E, 0xA8, 0x16, 0x06, 0xA0,
  0x74, 0x0C, 0xA3, 0x82, 0xDF, 0xD1, 0x30, 0xCA, 0x38, 0x62, 0xCF, 0xC5, 0x22, 0xDA, 0x58, 0x66,
  0xBD, 0xFE, 0xC9, 0x42,
  // "ğ" (U+011F)
  0x10, 0x20, 0xC3, 0x0A, 0x05, 0x48, 0x4E, 0x70, 0x5F, 0x24, 0x83, 0x3E, 0xFE, 0x67, 0x01, 0x28,
  0x17, 0xEA, 0x28, 0x96, 0x8D, 0xFE, 0xDB, 0xAC, 0x09, 0xFC, 0x39, 0xFB, 0x38, 0x3E, 0xF6, 0x03,
  0xA0, 0x32, 0xA8, 0x16, 0x02, 0xA0, 0x32, 0x85, 0xBF, 0xB0, 0x7F, 0xE3, 0x01, 0x0B, 0xB0, 0xC0,
  0x33, 0x82, 0x3E, 0x52, 0x68, 0x4C, 0xF4, 0x22, 0x14, 0x09, 0xD0, 0xE0, 0x72, 0x05, 0x0E, 0xE8,
  0x23, 0xAF, 0x83, 0x85, 0x1D, 0xF6, 0xEF, 0x34, 0x89, 0x6C, 0xF4, 0xBF, 0xB3, 0x23, 0x9F, 0xB0,
  0x18, 0xDA, 0x81, 0xEB, 0x62,
  // "Ġ" (U+0120)
  0x58, 0x1A, 0xC4, 0x72, 0x03, 0xA0, 0xB7, 0x38, 0x1C, 0xE6, 0x77, 0x78, 0x15, 0xBD, 0xA8, 0x1D,
  0x92, 0x38, 0x91, 0x1C, 0xFC, 0x52, 0x5D, 0xFE, 0x12, 0x81, 0xCF, 0xD4, 0x05, 0xA8, 0x11, 0x06,
  0xA0, 0x64, 0x81, 0x18, 0x32, 0x0B, 0xA0, 0x27, 0x20, 0xEA, 0x73, 0xB7, 0x30, 0xEA, 0x01, 0x20,
  0x4D, 0x05, 0x0B, 0xA0, 0x23, 0x04, 0x0E, 0xA8, 0x16, 0x06, 0xA0, 0x74, 0x0C, 0xA3, 0x82, 0xDF,
  0xD1, 0x30, 0xCA, 0x38, 0x62, 0xCF, 0xC5, 0x22, 0xDA, 0x58, 0x66, 0xBD, 0xFE, 0xC9, 0x42,
  // "ġ" (U+0121)
  0x38, 0x1A, 0xC4, 0x60, 0x3A, 0x0B, 0x78, 0x1C, 0xE6, 0x74, 0x81, 0x7E, 0xA2, 0x89, 0x68, 0xDF,
  0xED, 0xBA, 0xC0, 0x9F, 0xC3, 0x9F, 0xB3, 0x83, 0xEF, 0x60, 0x3A, 0x03, 0x2A, 0x81, 0x60, 0x2A,
  0x03, 0x28, 0x5B, 0xFB, 0x07, 0xFE, 0x30, 0x10, 0xBB, 0x0C, 0x03, 0x38, 0x23, 0xE5, 0x26, 0x84,
  0xCF, 0x42, 0x21, 0x40, 0x9D, 0x0E, 0x07, 0x20, 0x50, 0xEE, 0x82, 0x3A, 0xF8, 0x38, 0x51, 0xDF,
  0x6E, 0xF3, 0x48, 0x96, 0xCF, 0x4B, 0xFB, 0x32, 0x39, 0xFB, 0x01, 0x8D, 0xA8, 0x1E, 0xB6, 0x20,
  // "Ģ" (U+0122)
  0x38, 0x15, 0xBD, 0xA8, 0x1D, 0x92, 0x38, 0x91, 0x1C, 0xFC, 0x52, 0x5D, 0xFE, 0x12, 0x81, 0xCF,
  0xD4, 0x05, 0xA8, 0x11, 0x06, 0xA0, 0x64, 0x81, 0x18, 0x32, 0x0B, 0xA0, 0x27, 0x20, 0xEA, 0x73,
  0xB7, 0x30, 0xEA, 0x01, 0x20, 0x4D, 0x05, 0x0B, 0xA0, 0x23, 0x04, 0x0E, 0xA8, 0x16, 0x06, 0xA0,
  0x74, 0x0C, 0xA3, 0x82, 0xDF, 0xD1, 0x30, 0xCA, 0x38, 0x62, 0xCF, 0xC5, 0x22, 0xDA, 0x58, 0x66,
  0xBD, 0xFE, 0xC9, 0x47, 0x76, 0x81, 0xBE, 0x37, 0x39, 0x0B, 0x73, 0x81, 0x4E, 0x16,
  // "ģ" (U+0123)
  0x48, 0x11, 0xD6, 0x78, 0x19, 0xF2, 0x68, 0x12, 0xEC, 0x74, 0x81, 0x7E, 0xA2, 0x89, 0x68, 0xDF,
  0xED, 0xBA, 0xC0, 0x9F, 0xC3, 0x9F, 0xB3, 0x83, 0xEF, 0x60, 0x3A, 0x03, 0x2A, 0x81, 0x60, 0x2A,
  0x03, 0x28, 0x5B, 0xFB, 0x07, 0xFE, 0x30, 0x10, 0xBB, 0x0C, 0x03, 0x38, 0x23, 0xE5, 0x26, 0x84,
  0xCF, 0x42, 0x21, 0x40, 0x9D, 0x0E, 0x07, 0x20, 0x50, 0xEE, 0x82, 0x3A, 0xF8, 0x38, 0x51, 0xDF,
  0x6E, 0xF3, 0x48, 0x96, 0xCF, 0x4B, 0xFB, 0x32, 0x39, 0xFB, 0x01, 0x8D, 0xA8, 0x1E, 0xB6, 0x20,
  // "Ĥ" (U+0124)
  0x50, 0x9A, 0x06, 0x73, 0x84, 0x4F, 0xAC, 0xE2, 0x71, 0x81, 0x1E, 0x82, 0x0A, 0x0D, 0x77, 0x60,
  0x7D, 0x0B, 0x1E, 0x82, 0x31, 0x3E, 0xA8, 0x35, 0x10, 0x29, 0xA0, 0xC0, 0x23, 0x0C, 0xA4, 0x04,
  0xA0, 0x84, 0x0C, 0xA4, 0x04, 0xA0, 0x84, 0x0C, 0xA4, 0x04, 0xA0, 0x84, 0x0C, 0xA4, 0x04, 0xA0,
  0x84, 0x0C, 0xFA, 0x08, 0x40, 0xCA, 0x80, 0x02, 0x06, 0xA0, 0x84, 0x0C, 0xA4, 0x04, 0xA0, 0x84,
  0x0C, 0xA4, 0x04, 0xA0, 0x84, 0x0C, 0xA4, 0x04, 0xA0, 0x82, 0x81, 0x13, 0xEA, 0x83, 0x51, 0x02,
  0x8A, 0x82, 0xB2, 0x07, 0xD0, 0xB1, 0xE0, 0x30,
  // "ĥ" (U+0125)
  0x40, 0x9A, 0x06, 0x78, 0x44, 0xFA, 0xCE, 0x25, 0x81, 0x1E, 0x82, 0x0A, 0x0D, 0x30, 0xAB, 0x08,
  0x71, 0x06, 0xA0, 0x87, 0x10, 0x3A, 0x08, 0x71, 0x03, 0xA0, 0x77, 0x10, 0x3A, 0x84, 0x8A, 0xEE,
  0xB2, 0x30, 0x3B, 0x83, 0x54, 0xEF, 0xD3, 0x03, 0xA0, 0xB2, 0x09, 0xA0, 0x22, 0x03, 0xA0, 0x92,
  0x07, 0xA0, 0x42, 0x03, 0xA0, 0x82, 0x07, 0xA0, 0x42, 0x03, 0xA0, 0x82, 0x07, 0xA0, 0x42, 0x03,
  0xA0, 0x82, 0x07, 0xA0, 0x42, 0x03, 0xA0, 0x82, 0x07, 0xA0, 0x42, 0x06, 0xA0, 0xB2, 0x07, 0xA8,
  0x17, 0x09, 0xC8, 0x1D, 0x07, 0xB0, 0x80,
  // "Ħ" (U+0126)
  0x07, 0xD0, 0xB1, 0xE8, 0x23, 0x13, 0xEA, 0x83, 0x51, 0x02, 0x8A, 0x0B, 0x02, 0x30, 0xCA, 0x40,
  0x4A, 0x08, 0x20, 0xAF, 0xE8, 0x26, 0x12, 0xDA, 0x80, 0x02, 0x05, 0xA0, 0x90, 0x23, 0x0C, 0xA4,
  0x04, 0xA0, 0x84, 0x0C, 0xFA, 0x08, 0x40, 0xCA, 0x80, 0x02, 0x06, 0xA0, 0x84, 0x0C, 0xA4, 0x04,
  0xA0, 0x84, 0x0C, 0xA4, 0x04, 0xA0, 0x84, 0x0C, 0xA4, 0x04, 0xA0, 0x82, 0x81, 0x13, 0xEA, 0x83,
  0x51, 0x02, 0x8A, 0x82, 0xB2, 0x07, 0xD0, 0xB1, 0xE0, 0x30,
  // "ħ" (U+0127)
  0x0A, 0xB0, 0x87, 0x10, 0x5A, 0x08, 0x70, 0xB0, 0xEB, 0x81, 0xEE, 0x45, 0x03, 0xA0, 0x87, 0x10,
  0x3A, 0x84, 0x8A, 0xEE, 0xB2, 0x30, 0x3B, 0x83, 0x64, 0xEF, 0xD3, 0x03, 0xA0, 0xB2, 0x09, 0xA0,
  0x22, 0x03, 0xA0, 0x92, 0x07, 0xA0, 0x42, 0x03, 0xA0, 0x82, 0x07, 0xA0, 0x42, 0x03, 0xA0, 0x82,
  0x07, 0xA0, 0x42, 0x03, 0xA0, 0x82, 0x07, 0xA0, 0x42, 0x03, 0xA0, 0x82, 0x07, 0xA0, 0x42, 0x06,
  0xA0, 0xB2, 0x07, 0xA8, 0x17, 0x09, 0xC8, 0x1D, 0x07, 0xB0, 0x80,
  // "Ĩ" (U+0128)
  0x18, 0x97, 0x5E, 0xD7, 0x18, 0xB1, 0xF4, 0x6D, 0xFE, 0x20, 0x23, 0x01, 0x74, 0x07, 0xD8, 0x3B,
  0x01, 0x3E, 0xA0, 0x50, 0x13, 0x0C, 0xA5, 0x0C, 0xA5, 0x0C, 0xA5, 0x0C, 0xA5, 0x0C, 0xA5, 0x0C,
  0xA5, 0x0C, 0xA5, 0x0C, 0xA5, 0x0C, 0xA3, 0x81, 0x13, 0xEA, 0x82, 0x51, 0x07, 0xD0, 0xB0,
  // "ĩ" (U+0129)
  0x18, 0x97, 0x5E, 0xD7, 0x18, 0xB1, 0xF4, 0x6D, 0xFE, 0x20, 0x23, 0x01, 0x74, 0x0A, 0xB0, 0x83,
  0x01, 0x09, 0xA0, 0x84, 0x03, 0xA0, 0x84, 0x03, 0xA0, 0x84, 0x03, 0xA0, 0x84, 0x03, 0xA0, 0x84,
  0x03, 0xA0, 0x84, 0x03, 0xA0, 0x83, 0x01, 0x09, 0xA0, 0xC0, 0x32, 0x0A, 0xD1,
  // "Ī" (U+012A)
  0x04, 0xC0, 0xE2, 0x80, 0x12, 0x10, 0x7D, 0x82, 0xB1, 0x3E, 0xA0, 0x50, 0x12, 0x0C, 0xA4, 0x0C,
  0xA4, 0x0C, 0xA4, 0x0C, 0xA4, 0x0C, 0xA4, 0x0C, 0xA4, 0x0C, 0xA4, 0x0C, 0xA4, 0x0C, 0xA2, 0x81,
  0x13, 0xEA, 0x81, 0x51, 0x7D, 0x0B,
  // "ī" (U+012B)
  0x04, 0xC0, 0xE1, 0x80, 0x12, 0x0A, 0xB8, 0x28, 0x01, 0x9A, 0x08, 0x20, 0x3A, 0x08, 0x20, 0x3A,
  0x08, 0x20, 0x3A, 0x08, 0x20, 0x3A, 0x08, 0x20, 0x3A, 0x08, 0x20, 0x3A, 0x82, 0x80, 0x19, 0xA8,
  0x1C, 0x3A, 0xD0,
  // "Ĭ" (U+012C)
  0x02, 0x0C, 0x38, 0x95, 0xA5, 0x0E, 0x70, 0x5F, 0x20, 0x3E, 0xFE, 0x64, 0x01, 0x30, 0x7D, 0x82,
  0xB1, 0x3E, 0xA0, 0x50, 0x12, 0x0C, 0xA4, 0x0C, 0xA4, 0x0C, 0xA4, 0x0C, 0xA4, 0x0C, 0xA4, 0x0C,
  0xA4, 0x0C, 0xA4, 0x0C, 0xA4, 0x0C, 0xA2, 0x81, 0x13, 0xEA, 0x81, 0x51, 0x7D, 0x0B,
  // "ĭ" (U+012D)
  0x02, 0x0C, 0x38, 0x95, 0xA5, 0x0E, 0x70, 0x5F, 0x20, 0x3E, 0xFE, 0x64, 0x01, 0x40, 0xAB, 0x08,
  0x20, 0x10, 0x9A, 0x08, 0x30, 0x3A, 0x08, 0x30, 0x3A, 0x08, 0x30, 0x3A, 0x08, 0x30, 0x3A, 0x08,
  0x30, 0x3A, 0x08, 0x30, 0x3A, 0x08, 0x20, 0x10, 0x9A, 0x82, 0xC3, 0x0A, 0xD0,
  // "Į" (U+012E)
  0x07, 0xD8, 0x2B, 0x13, 0xEA, 0x05, 0x01, 0x20, 0xCA, 0x40, 0xCA, 0x40, 0xCA, 0x40, 0xCA, 0x40,
  0xCA, 0x40, 0xCA, 0x40, 0xCA, 0x40, 0xCA, 0x40, 0xCA, 0x28, 0x11, 0x3E, 0xA8, 0x15, 0x17, 0xD0,
  0xB2, 0x81, 0x4E, 0x54, 0x0E, 0x0C, 0x59, 0x81, 0xD2, 0x13, 0x08, 0xB0, 0x13, 0x81, 0x13, 0x11,
  // "į" (U+012F)
  0x18, 0x22, 0xDE, 0x42, 0x06, 0xA0, 0x82, 0x82, 0x1B, 0xB2, 0x70, 0xAB, 0x82, 0x80, 0x19, 0xA0,
  0x82, 0x03, 0xA0, 0x82, 0x03, 0xA0, 0x82, 0x03, 0xA0, 0x82, 0x03, 0xA0, 0x82, 0x03, 0xA0, 0x82,
  0x03, 0xA8, 0x28, 0x01, 0x9A, 0x81, 0xC3, 0xAD, 0x18, 0x14, 0xE5, 0x30, 0xE0, 0xC4, 0x98, 0x1D,
  0x21, 0x20, 0x8B, 0x01, 0x28, 0x11, 0x31, 0x10,
  // "İ" (U+0130)
  0x28, 0x1A, 0xC4, 0x30, 0x3A, 0x0B, 0x48, 0x1C, 0xE6, 0x72, 0x07, 0xD8, 0x2B, 0x13, 0xEA, 0x05,
  0x01, 0x20, 0xCA, 0x40, 0xCA, 0x40, 0xCA, 0x40, 0xCA, 0x40, 0xCA, 0x40, 0xCA, 0x40, 0xCA, 0x40,
  0xCA, 0x40, 0xCA, 0x28, 0x11, 0x3E, 0xA8, 0x15, 0x17, 0xD0, 0xB0,
  // "ı" (U+0131)
  0xAF, 0xFF, 0x80, 0x19, 0xFF, 0x80, 0x03, 0xFF, 0x80, 0x03, 0xFF, 0x80, 0x03, 0xFF, 0x80, 0x03,
  0xFF, 0x80, 0x03, 0xFF, 0x80, 0x03, 0xFF, 0x80, 0x19, 0xFF, 0xC3, 0xAF, 0xFF, 0xFF,
  // "Ĳ" (U+0132)
  0x07, 0xD0, 0xB0, 0x7D, 0x82, 0xB1, 0x3E, 0xA8, 0x35, 0x11, 0x3E, 0xA0, 0x60, 0x12, 0x0C, 0xA4,
  0x0C, 0xA0, 0x13, 0x0C, 0xA4, 0x0C, 0xA0, 0x13, 0x0C, 0xA4, 0x0C, 0xA0, 0x13, 0x0C, 0xA4, 0x0C,
  0xA0, 0x13, 0x0C, 0xA4, 0x0C, 0xA0, 0x13, 0x0C, 0xA4, 0x0C, 0xA0, 0x13, 0x0C, 0xA4, 0x0C, 0xA0,
  0x13, 0x0C, 0xA4, 0x0C, 0xA0, 0x13, 0x0C, 0xA4, 0x0C, 0xA8, 0x31, 0x01, 0x3E, 0xA0, 0x50, 0x12,
  0x0C, 0xA8, 0x11, 0x07, 0xD0, 0xB2, 0x0C, 0xA7, 0x40, 0xDA, 0x73, 0x01, 0xA0, 0xB7, 0x28, 0x33,
  0xCF, 0xE3, 0x71, 0x83, 0x5F, 0xD9, 0x23,
  // "ĳ" (U+0133)
  0x18, 0x22, 0xDE, 0x42, 0x84, 0x2D, 0xE4, 0x06, 0xA0, 0x82, 0x06, 0xA8, 0x49, 0x01, 0xBB, 0x22,
  0x82, 0x1B, 0xB3, 0x74, 0x0A, 0xB8, 0x18, 0x0A, 0xB8, 0x18, 0x19, 0xA8, 0x28, 0x02, 0x9A, 0x81,
  0x80, 0x3A, 0x08, 0x20, 0x3A, 0x81, 0x80, 0x3A, 0x08, 0x20, 0x3A, 0x81, 0x80, 0x3A, 0x08, 0x20,
  0x3A, 0x81, 0x80, 0x3A, 0x08, 0x20, 0x3A, 0x81, 0x80, 0x3A, 0x08, 0x20, 0x3A, 0x81, 0x80, 0x3A,
  0x08, 0x20, 0x3A, 0x81, 0x81, 0x9A, 0x82, 0xC3, 0x03, 0xA0, 0x80, 0xAD, 0x10, 0x3A, 0x08, 0x70,
  0x3A, 0x07, 0x70, 0x6A, 0x04, 0x68, 0x25, 0xEF, 0xB6, 0x82, 0x5F, 0xD8, 0x20,
  // "Ĵ" (U+0134)
  0x30, 0x9A, 0x06, 0x38, 0x90, 0x4F, 0xAC, 0xE2, 0x01, 0xE8, 0x20, 0xA0, 0xD7, 0x20, 0x7D, 0x83,
  0xB0, 0x13, 0xEA, 0x06, 0x01, 0x30, 0xCA, 0x01, 0x40, 0xCA, 0x01, 0x40, 0xCA, 0x01, 0x40, 0xCA,
  0x01, 0x40, 0xCA, 0x01, 0x40, 0xCA, 0x01, 0x40, 0xCA, 0x01, 0x40, 0xCA, 0x01, 0x40, 0xCA, 0x01,
  0x40, 0xCA, 0x01, 0x40, 0xCA, 0x50, 0xDA, 0x40, 0x1A, 0x0B, 0x38, 0x33, 0xCF, 0xE3, 0x28, 0x35,
  0xFD, 0x92, 0x30,
  // "ĵ" (U+0135)
  0x20, 0x9A, 0x06, 0x28, 0x74, 0xFA, 0xCE, 0x21, 0xE8, 0x20, 0xA0, 0xD7, 0x10, 0xAB, 0x08, 0x20,
  0x20, 0x9A, 0x08, 0x30, 0x3A, 0x08, 0x30, 0x3A, 0x08, 0x30, 0x3A, 0x08, 0x30, 0x3A, 0x08, 0x30,
  0x3A, 0x08, 0x30, 0x3A, 0x08, 0x30, 0x3A, 0x08, 0x30, 0x3A, 0x08, 0x30, 0x3A, 0x07, 0x30, 0x6A,
  0x04, 0x28, 0x24, 0xDF, 0xC2, 0x83, 0x1F, 0xD9, 0x12,
  // "Ķ" (U+0136)
  0x07, 0xD0, 0xB0, 0x2C, 0x83, 0xA0, 0x13, 0xEA, 0x82, 0x51, 0x06, 0xA0, 0x80, 0x23, 0x0C, 0xA3,
  0x81, 0x7F, 0x55, 0x0C, 0xA2, 0x81, 0x4F, 0x66, 0x0C, 0xA1, 0x81, 0x3E, 0x77, 0x0C, 0xA8, 0x12,
  0xEE, 0x71, 0x0C, 0xA0, 0xDA, 0x07, 0x70, 0xCA, 0x07, 0x0E, 0xA0, 0x26, 0x0C, 0xA1, 0x06, 0xA0,
  0xC6, 0x0C, 0xA2, 0x0C, 0xA0, 0x75, 0x0C, 0xA2, 0x03, 0xB0, 0x22, 0x81, 0x13, 0xEA, 0x82, 0x51,
  0x09, 0xA8, 0x2D, 0x40, 0x7D, 0x0B, 0x20, 0x80, 0xDA, 0x03, 0x77, 0x68, 0x1B, 0xE3, 0x74, 0x90,
  0xB7, 0x48, 0x14, 0xE1, 0x60,
  // "ķ" (U+0137)
  0x0A, 0xB0, 0x87, 0x01, 0x09, 0xA0, 0x87, 0x10, 0x3A, 0x08, 0x71, 0x03, 0xA0, 0x87, 0x10, 0x3A,
  0x81, 0x80, 0xBB, 0x0C, 0x20, 0x3A, 0x85, 0x80, 0x2E, 0xF9, 0x22, 0x03, 0xA8, 0x38, 0x04, 0xF7,
  0x40, 0x3A, 0x82, 0x83, 0xE8, 0x50, 0x3A, 0x82, 0x9E, 0xF7, 0x50, 0x3B, 0x0E, 0xA0, 0x24, 0x03,
  0xA0, 0x90, 0x4A, 0x0C, 0x40, 0x3A, 0x81, 0x80, 0xAA, 0x08, 0x20, 0x10, 0x8A, 0x82, 0xC3, 0x1E,
  0xA8, 0x17, 0x1A, 0xD1, 0x03, 0x0C, 0xA0, 0x77, 0x73, 0x81, 0xBE, 0x37, 0x29, 0x0B, 0x72, 0x81,
  0x4E, 0x15,
  // "ĸ" (U+0138)
  0x0A, 0xB8, 0x18, 0x0B, 0xB8, 0x2C, 0x01, 0x9A, 0x85, 0x80, 0x2E, 0xF9, 0x22, 0x03, 0xA8, 0x38,
  0x04, 0xF7, 0x40, 0x3A, 0x82, 0x83, 0xE8, 0x50, 0x3A, 0x82, 0x9E, 0xF7, 0x50, 0x3B, 0x0E, 0xA0,
  0x24, 0x03, 0xA0, 0x90, 0x4A, 0x0C, 0x40, 0x3A, 0x81, 0x80, 0xAA, 0x08, 0x20, 0x10, 0x9A, 0x82,
  0xC3, 0x1E, 0xA8, 0x17, 0x1A, 0xD1, 0x03, 0x0C, 0xA0, 0x70,
  // "Ĺ" (U+0139)
  0x48, 0x2C, 0xFD, 0x17, 0x82, 0x6F, 0xD2, 0x78, 0x11, 0xE9, 0x77, 0x50, 0x7D, 0x0A, 0x70, 0xEA,
  0x03, 0x71, 0x0C, 0xA7, 0x20, 0xCA, 0x72, 0x0C, 0xA7, 0x20, 0xCA, 0x72, 0x0C, 0xA7, 0x20, 0xCA,
  0x72, 0x0C, 0xA7, 0x20, 0xCA, 0x50, 0xE0, 0x22, 0x0C, 0xA4, 0x81, 0x2F, 0x12, 0x0E, 0xA4, 0x82,
  0x9F, 0x17, 0xC0, 0xFE, 0xB1,
  // "ĺ" (U+013A)
  0x38, 0x2C, 0xFD, 0x12, 0x82, 0x6F, 0xD2, 0x28, 0x11, 0xE9, 0x30, 0xAB, 0x08, 0x20, 0x10, 0x9A,
  0x08, 0x30, 0x3A, 0x08, 0x30, 0x3A, 0x08, 0x30, 0x3A, 0x08, 0x30, 0x3A, 0x08, 0x30, 0x3A, 0x08,
  0x30, 0x3A, 0x08, 0x30, 0x3A, 0x08, 0x30, 0x3A, 0x08, 0x30, 0x3A, 0x08, 0x30, 0x3A, 0x08, 0x20,
  0x10, 0x8A, 0x82, 0xC3, 0x0A, 0xD1,
  // "Ļ" (U+013B)
  0x07, 0xD0, 0xA7, 0x0E, 0xA0, 0x37, 0x10, 0xCA, 0x72, 0x0C, 0xA7, 0x20, 0xCA, 0x72, 0x0C, 0xA7,
  0x20, 0xCA, 0x72, 0x0C, 0xA7, 0x20, 0xCA, 0x72, 0x0C, 0xA5, 0x0E, 0x02, 0x20, 0xCA, 0x48, 0x12,
  0xF1, 0x20, 0xEA, 0x48, 0x29, 0xF1, 0x7C, 0x0F, 0xEB, 0x77, 0x48, 0x1B, 0xE3, 0x72, 0x90, 0xB7,
  0x28, 0x14, 0xE1, 0x50,
  // "ļ" (U+013C)
  0x0A, 0xB8, 0x28, 0x01, 0x9A, 0x08, 0x20, 0x3A, 0x08, 0x20, 0x3A, 0x08, 0x20, 0x3A, 0x08, 0x20,
  0x3A, 0x08, 0x20, 0x3A, 0x08, 0x20, 0x3A, 0x08, 0x20, 0x3A, 0x08, 0x20, 0x3A, 0x08, 0x20, 0x3A,
  0x08, 0x20, 0x3A, 0x82, 0x80, 0x18, 0xA8, 0x1C, 0x3A, 0xD7, 0x18, 0x1B, 0xE3, 0x39, 0x0B, 0x38,
  0x14, 0xE1, 0x20,
  // "Ľ" (U+013D)
  0x07, 0xD8, 0x3A, 0x04, 0xFB, 0x30, 0xEA, 0x03, 0x28, 0x18, 0xF2, 0x30, 0xCA, 0x30, 0xB0, 0x74,
  0x0C, 0xA7, 0x20, 0xCA, 0x72, 0x0C, 0xA7, 0x20, 0xCA, 0x72, 0x0C, 0xA7, 0x20, 0xCA, 0x72, 0x0C,
  0xA5, 0x0E, 0x02, 0x20, 0xCA, 0x48, 0x12, 0xF1, 0x20, 0xEA, 0x48, 0x29, 0xF1, 0x7C, 0x0F, 0xEB,
  0x10,
  // "ľ" (U+013E)
  0x0A, 0xB8, 0x58, 0x0D, 0xF2, 0x19, 0xA8, 0x28, 0x2F, 0x92, 0x03, 0xA8, 0x18, 0x5C, 0x30, 0x3A,
  0x08, 0x50, 0x3A, 0x08, 0x50, 0x3A, 0x08, 0x50, 0x3A, 0x08, 0x50, 0x3A, 0x08, 0x50, 0x3A, 0x08,
  0x50, 0x3A, 0x08, 0x50, 0x3A, 0x08, 0x50, 0x3A, 0x08, 0x40, 0x10, 0x8A, 0x0C, 0x03, 0x30, 0xAD,
  0x30,
  // "Ŀ" (U+013F)
  0x07, 0xD0, 0xA7, 0x0E, 0xA0, 0x37, 0x10, 0xCA, 0x72, 0x0C, 0xA7, 0x20, 0xCA, 0x72, 0x0C, 0xA3,
  0x81, 0xAC, 0x43, 0x0C, 0xA2, 0x03, 0xA0, 0xB3, 0x0C, 0xA3, 0x81, 0xCE, 0x63, 0x0C, 0xA7, 0x20,
  0xCA, 0x50, 0xE0, 0x22, 0x0C, 0xA4, 0x81, 0x2F, 0x12, 0x0E, 0xA4, 0x82, 0x9F, 0x17, 0xC0, 0xFE,
  0xB1,
  // "ŀ" (U+0140)
  0x0A, 0xB0, 0x84, 0x01, 0x09, 0xA0, 0x85, 0x03, 0xA0, 0x85, 0x03, 0xA0, 0x85, 0x03, 0xA0, 0x85,
  0x03, 0xA0, 0x85, 0x03, 0xA0, 0x85, 0x03, 0xA8, 0x58, 0x0A, 0xC4, 0x03, 0xA0, 0x80, 0x3A, 0x81,
  0xB0, 0x3A, 0x85, 0x80, 0xCE, 0x60, 0x3A, 0x08, 0x50, 0x3A, 0x08, 0x40, 0x10, 0x8A, 0x0C, 0x03,
  0x30, 0xAD, 0x30,
  // "Ł" (U+0141)
  0x07, 0xD0, 0xA7, 0x0E, 0xA0, 0x37, 0x10, 0xCA, 0x72, 0x0C, 0xA2, 0x02, 0x60, 0xCA, 0x81, 0x4C,
  0x96, 0x0C, 0xA0, 0xE0, 0x77, 0x0D, 0xA0, 0x16, 0x02, 0x0D, 0xB7, 0x81, 0x35, 0xCA, 0x72, 0x0C,
  0xA5, 0x0E, 0x02, 0x20, 0xCA, 0x48, 0x12, 0xF1, 0x20, 0xEA, 0x48, 0x29, 0xF1, 0x7C, 0x0F, 0xEB,
  0x10,
  // "ł" (U+0142)
  0xAF, 0xFF, 0x80, 0x18, 0xFF, 0x80, 0x03, 0xFF, 0x80, 0x03, 0xFF, 0x80, 0x03, 0xFF, 0x80, 0x03,
  0xFF, 0x82, 0x03, 0xFF, 0xDE, 0x03, 0xFF, 0xB1, 0x3D, 0xFF, 0x80, 0x57, 0xFF, 0x80, 0x03, 0xFF,
  0x80, 0x03, 0xFF, 0x80, 0x19, 0xFF, 0xC3, 0xAF, 0xFF, 0xFF,
  // "Ń" (U+0143)
  0x71, 0x82, 0xCF, 0xD1, 0x72, 0x82, 0x6F, 0xD2, 0x72, 0x81, 0x1E, 0x97, 0x75, 0x07, 0xB0, 0xC4,
  0x0C, 0xB8, 0x2D, 0x13, 0xEA, 0x08, 0x38, 0x31, 0x6F, 0x71, 0x20, 0xCB, 0x04, 0x38, 0x12, 0xF3,
  0x30, 0xC0, 0xBA, 0x0D, 0x01, 0x28, 0x12, 0xF3, 0x38, 0x1C, 0x88, 0xA0, 0xA2, 0x81, 0x2F, 0x33,
  0x82, 0xC8, 0x0C, 0xA8, 0x35, 0x02, 0xF3, 0x38, 0x91, 0xC8, 0x02, 0xEF, 0xE1, 0x2F, 0x33, 0x0C,
  0x08, 0x20, 0x6A, 0x82, 0xB2, 0xF3, 0x30, 0xC0, 0x83, 0x0A, 0xA8, 0x19, 0xF3, 0x30, 0xC0, 0x83,
  0x01, 0x0D, 0xB0, 0x33, 0x0C, 0x08, 0x40, 0x3B, 0x85, 0x30, 0x13, 0xEB, 0x24, 0x08, 0xA8, 0x13,
  0x07, 0xC0, 0x34, 0x81, 0xCF, 0x31,
  // "ń" (U+0144)
  0x68, 0x2C, 0xFD, 0x17, 0x82, 0x6F, 0xD2, 0x78, 0x11, 0xE9, 0x77, 0x30, 0x8B, 0x84, 0x69, 0xEE,
  0xB2, 0x20, 0x10, 0x8B, 0x83, 0x54, 0xEF, 0xD3, 0x03, 0xA0, 0xB2, 0x09, 0xA0, 0x22, 0x03, 0xA0,
  0x92, 0x07, 0xA0, 0x42, 0x03, 0xA0, 0x82, 0x07, 0xA0, 0x42, 0x03, 0xA0, 0x82, 0x07, 0xA0, 0x42,
  0x03, 0xA0, 0x82, 0x07, 0xA0, 0x42, 0x03, 0xA0, 0x82, 0x07, 0xA8, 0x24, 0x02, 0x9A, 0x82, 0xC3,
  0x07, 0xA8, 0x19, 0x19, 0xC8, 0x1D, 0x07, 0xB0, 0x80,
  // "Ņ" (U+0145)
  0x07, 0xB0, 0xC4, 0x0C, 0xB8, 0x2D, 0x13, 0xEA, 0x08, 0x38, 0x31, 0x6F, 0x71, 0x20, 0xCB, 0x04,
  0x38, 0x12, 0xF3, 0x30, 0xC0, 0xBA, 0x0D, 0x01, 0x28, 0x12, 0xF3, 0x38, 0x1C, 0x88, 0xA0, 0xA2,
  0x81, 0x2F, 0x33, 0x82, 0xC8, 0x0C, 0xA8, 0x35, 0x02, 0xF3, 0x38, 0x91, 0xC8, 0x02, 0xEF, 0xE1,
  0x2F, 0x33, 0x0C, 0x08, 0x20, 0x6A, 0x82, 0xB2, 0xF3, 0x30, 0xC0, 0x83, 0x0A, 0xA8, 0x19, 0xF3,
  0x30, 0xC0, 0x83, 0x01, 0x0D, 0xB0, 0x33, 0x0C, 0x08, 0x40, 0x3B, 0x85, 0x30, 0x13, 0xEB, 0x24,
  0x08, 0xA8, 0x13, 0x07, 0xC0, 0x34, 0x81, 0xCF, 0x37, 0x77, 0x81, 0xBE, 0x37, 0x49, 0x0B, 0x74,
  0x81, 0x4E, 0x16,
  // "ņ" (U+0146)
  0x08, 0xB8, 0x46, 0x9E, 0xEB, 0x22, 0x01, 0x08, 0xB8, 0x35, 0x4E, 0xFD, 0x30, 0x3A, 0x0B, 0x20,
  0x9A, 0x02, 0x20, 0x3A, 0x09, 0x20, 0x7A, 0x04, 0x20, 0x3A, 0x08, 0x20, 0x7A, 0x04, 0x20, 0x3A,
  0x08, 0x20, 0x7A, 0x04, 0x20, 0x3A, 0x08, 0x20, 0x7A, 0x04, 0x20, 0x3A, 0x08, 0x20, 0x7A, 0x82,
  0x40, 0x29, 0xA8, 0x2C, 0x30, 0x7A, 0x81, 0x91, 0x9C, 0x81, 0xD0, 0x7B, 0x08, 0x77, 0x38, 0x1B,
  0xE3, 0x72, 0x90, 0xB7, 0x28, 0x14, 0xE1, 0x50,
  // "Ň" (U+0147)
  0x48, 0x11, 0xE8, 0x20, 0xA0, 0xD7, 0x18, 0x44, 0xFA, 0xCE, 0x27, 0x20, 0x9A, 0x06, 0x77, 0x40,
  0x7B, 0x0C, 0x40, 0xCB, 0x82, 0xD1, 0x3E, 0xA0, 0x83, 0x83, 0x16, 0xF7, 0x12, 0x0C, 0xB0, 0x43,
  0x81, 0x2F, 0x33, 0x0C, 0x0B, 0xA0, 0xD0, 0x12, 0x81, 0x2F, 0x33, 0x81, 0xC8, 0x8A, 0x0A, 0x28,
  0x12, 0xF3, 0x38, 0x2C, 0x80, 0xCA, 0x83, 0x50, 0x2F, 0x33, 0x89, 0x1C, 0x80, 0x2E, 0xFE, 0x12,
  0xF3, 0x30, 0xC0, 0x82, 0x06, 0xA8, 0x2B, 0x2F, 0x33, 0x0C, 0x08, 0x30, 0xAA, 0x81, 0x9F, 0x33,
  0x0C, 0x08, 0x30, 0x10, 0xDB, 0x03, 0x30, 0xC0, 0x84, 0x03, 0xB8, 0x53, 0x01, 0x3E, 0xB2, 0x40,
  0x8A, 0x81, 0x30, 0x7C, 0x03, 0x48, 0x1C, 0xF3, 0x10,
  // "ň" (U+0148)
  0x28, 0x11, 0xE8, 0x20, 0xA0, 0xD6, 0x84, 0x4F, 0xAC, 0xE2, 0x70, 0x9A, 0x06, 0x77, 0x20, 0x8B,
  0x84, 0x69, 0xEE, 0xB2, 0x20, 0x10, 0x8B, 0x83, 0x54, 0xEF, 0xD3, 0x03, 0xA0, 0xB2, 0x09, 0xA0,
  0x22, 0x03, 0xA0, 0x92, 0x07, 0xA0, 0x42, 0x03, 0xA0, 0x82, 0x07, 0xA0, 0x42, 0x03, 0xA0, 0x82,
  0x07, 0xA0, 0x42, 0x03, 0xA0, 0x82, 0x07, 0xA0, 0x42, 0x03, 0xA0, 0x82, 0x07, 0xA8, 0x24, 0x02,
  0x9A, 0x82, 0xC3, 0x07, 0xA8, 0x19, 0x19, 0xC8, 0x1D, 0x07, 0xB0, 0x80,
  // "ŉ" (U+0149)
  0x18, 0x19, 0xE6, 0x76, 0x81, 0xDF, 0xE7, 0x68, 0x14, 0xEE, 0x77, 0x81, 0xBA, 0x8B, 0x84, 0x69,
  0xEE, 0xB2, 0x28, 0x41, 0xAC, 0x11, 0x8B, 0x83, 0x54, 0xEF, 0xD2, 0x01, 0x05, 0x30, 0x3A, 0x0B,
  0x20, 0x9A, 0x02, 0x60, 0x3A, 0x09, 0x20, 0x7A, 0x04, 0x60, 0x3A, 0x08, 0x20, 0x7A, 0x04, 0x60,
  0x3A, 0x08, 0x20, 0x7A, 0x04, 0x60, 0x3A, 0x08, 0x20, 0x7A, 0x04, 0x60, 0x3A, 0x08, 0x20, 0x7A,
  0x04, 0x50, 0x20, 0x9A, 0x82, 0xC3, 0x07, 0xA0, 0x90, 0x14, 0x09, 0xC8, 0x1D, 0x07, 0xB0, 0x80,
  // "Ŋ" (U+014A)
  0x07, 0xB0, 0xC4, 0x0C, 0xB8, 0x2D, 0x13, 0xEA, 0x09, 0x38, 0x31, 0x6F, 0x71, 0x20, 0xCB, 0x05,
  0x38, 0x12, 0xF3, 0x30, 0xC0, 0xBA, 0x0E, 0x02, 0x28, 0x12, 0xF3, 0x38, 0x1C, 0x87, 0xA0, 0xC2,
  0x81, 0x2F, 0x33, 0x82, 0xC8, 0x0B, 0xA8, 0x38, 0x02, 0xF3, 0x38, 0x3C, 0x80, 0x1E, 0xA8, 0x24,
  0x2F, 0x33, 0x0C, 0x08, 0x20, 0x4A, 0x82, 0xE3, 0xF3, 0x30, 0xC0, 0x83, 0x07, 0xA8, 0x1D, 0xF3,
  0x30, 0xC0, 0x84, 0x0B, 0xB0, 0x33, 0x0C, 0x08, 0x40, 0x10, 0xEA, 0x85, 0x30, 0x13, 0xEB, 0x24,
  0x04, 0xA8, 0x13, 0x07, 0xC0, 0x34, 0x81, 0x8F, 0x37, 0x48, 0x12, 0xF2, 0x74, 0x05, 0x97, 0x48,
  0x14, 0xDB, 0x73, 0x82, 0x5F, 0xB1, 0x20,
  // "ŋ" (U+014B)
  0x08, 0xB8, 0x76, 0x9E, 0xEB, 0x20, 0x18, 0xB8, 0x35, 0x4E, 0xFD, 0x20, 0x3A, 0x0B, 0x20, 0x9A,
  0x81, 0x20, 0x3A, 0x09, 0x20, 0x7A, 0x81, 0x40, 0x3A, 0x08, 0x20, 0x7A, 0x81, 0x40, 0x3A, 0x08,
  0x20, 0x7A, 0x81, 0x40, 0x3A, 0x08, 0x20, 0x7A, 0x81, 0x40, 0x3A, 0x08, 0x20, 0x7A, 0x81, 0x42,
  0x9A, 0x82, 0xC3, 0x07, 0xA0, 0x40, 0x9C, 0x81, 0xD0, 0x7A, 0x04, 0x70, 0x7A, 0x03, 0x70, 0xAA,
  0x01, 0x60, 0x5A, 0x09, 0x68, 0x25, 0xEC, 0x72,
  // "Ō" (U+014C)
  0x30, 0x4C, 0x0E, 0x71, 0x80, 0x12, 0x68, 0x61, 0x7C, 0xEE, 0xD8, 0x24, 0x89, 0x03, 0xEF, 0xA3,
  0x28, 0xFE, 0x42, 0x82, 0x1D, 0xFB, 0x48, 0x49, 0xFE, 0x10, 0x7A, 0x05, 0x40, 0x3A, 0x81, 0x90,
  0xCA, 0x02, 0x5A, 0x81, 0xE0, 0xEA, 0x60, 0xDA, 0x01, 0xB6, 0x0D, 0xA0, 0x20, 0xEA, 0x60, 0xDA,
  0x01, 0x0C, 0xA0, 0x25, 0xA8, 0x1E, 0x07, 0xA0, 0x54, 0x03, 0xA0, 0x92, 0x81, 0xDF, 0xB4, 0x82,
  0x9F, 0xE1, 0x28, 0x90, 0x3E, 0xFA, 0x32, 0x8F, 0xE4, 0x48, 0x61, 0x7C, 0xEE, 0xD8, 0x13,
  // "ō" (U+014D)
  0x20, 0x4C, 0x0E, 0x68, 0x01, 0x25, 0x85, 0x2A, 0xEF, 0xEA, 0x23, 0x87, 0x3E, 0xF9, 0x39, 0xFE,
  0x22, 0x81, 0xBF, 0xE3, 0x81, 0xEF, 0xB2, 0xA0, 0xB3, 0x0B, 0xA1, 0x01, 0xA0, 0xA3, 0x09, 0xA0,
  0x20, 0x1A, 0x0A, 0x30, 0xAA, 0x02, 0x1A, 0x0B, 0x30, 0xBA, 0x28, 0x1B, 0xFE, 0x38, 0x1E, 0xFB,
  0x28, 0x72, 0xEF, 0x93, 0x9F, 0xE3, 0x38, 0x52, 0x9E, 0xFE, 0xA2, 0x20,
  // "Ŏ" (U+014E)
  0x20, 0x20, 0xC3, 0x0A, 0x05, 0x78, 0x4E, 0x70, 0x5F, 0x27, 0x83, 0x3E, 0xFE, 0x67, 0x30, 0x17,
  0x28, 0x61, 0x7C, 0xEE, 0xD8, 0x24, 0x89, 0x03, 0xEF, 0xA3, 0x28, 0xFE, 0x42, 0x82, 0x1D, 0xFB,
  0x48, 0x49, 0xFE, 0x10, 0x7A, 0x05, 0x40, 0x3A, 0x81, 0x90, 0xCA, 0x02, 0x5A, 0x81, 0xE0, 0xEA,
  0x60, 0xDA, 0x01, 0xB6, 0x0D, 0xA0, 0x20, 0xEA, 0x60, 0xDA, 0x01, 0x0C, 0xA0, 0x25, 0xA8, 0x1E,
  0x07, 0xA0, 0x54, 0x03, 0xA0, 0x92, 0x81, 0xDF, 0xB4, 0x82, 0x9F, 0xE1, 0x28, 0x90, 0x3E, 0xFA,
  0x32, 0x8F, 0xE4, 0x48, 0x61, 0x7C, 0xEE, 0xD8, 0x13,
  // "ŏ" (U+014F)
  0x20, 0x20, 0xC3, 0x0A, 0x05, 0x58, 0x4E, 0x70, 0x5F, 0x25, 0x83, 0x3E, 0xFE, 0x67, 0x10, 0x17,
  0x85, 0x2A, 0xEF, 0xEA, 0x23, 0x87, 0x3E, 0xF9, 0x39, 0xFE, 0x22, 0x81, 0xBF, 0xE3, 0x81, 0xEF,
  0xB2, 0xA0, 0xB3, 0x0B, 0xA1, 0x01, 0xA0, 0xA3, 0x09, 0xA0, 0x20, 0x1A, 0x0A, 0x30, 0xAA, 0x02,
  0x1A, 0x0B, 0x30, 0xBA, 0x28, 0x1B, 0xFE, 0x38, 0x1E, 0xFB, 0x28, 0x72, 0xEF, 0x93, 0x9F, 0xE3,
  0x38, 0x52, 0x9E, 0xFE, 0xA2, 0x20,
  // "Ő" (U+0150)
  0x48, 0x4D, 0xE4, 0x8E, 0xA6, 0x85, 0x8F, 0x72, 0xFD, 0x15, 0x85, 0x2F, 0x70, 0xAC, 0x17, 0x75,
  0x86, 0x17, 0xCE, 0xED, 0x82, 0x48, 0x90, 0x3E, 0xFA, 0x32, 0x8F, 0xE4, 0x28, 0x21, 0xDF, 0xB4,
  0x84, 0x9F, 0xE1, 0x07, 0xA0, 0x54, 0x03, 0xA8, 0x19, 0x0C, 0xA0, 0x25, 0xA8, 0x1E, 0x0E, 0xA6,
  0x0D, 0xA0, 0x1B, 0x60, 0xDA, 0x02, 0x0E, 0xA6, 0x0D, 0xA0, 0x10, 0xCA, 0x02, 0x5A, 0x81, 0xE0,
  0x7A, 0x05, 0x40, 0x3A, 0x09, 0x28, 0x1D, 0xFB, 0x48, 0x29, 0xFE, 0x12, 0x89, 0x03, 0xEF, 0xA3,
  0x28, 0xFE, 0x44, 0x86, 0x17, 0xCE, 0xED, 0x81, 0x30,
  // "ő" (U+0151)
  0x48, 0x4D, 0xE4, 0x8E, 0xA4, 0x85, 0x8F, 0x72, 0xFD, 0x13, 0x85, 0x2F, 0x70, 0xAC, 0x17, 0x71,
  0x85, 0x2A, 0xEF, 0xEA, 0x23, 0x87, 0x3E, 0xF9, 0x39, 0xFE, 0x22, 0x81, 0xBF, 0xE3, 0x81, 0xEF,
  0xB2, 0xA0, 0xB3, 0x0B, 0xA1, 0x01, 0xA0, 0xA3, 0x09, 0xA0, 0x20, 0x1A, 0x0A, 0x30, 0xAA, 0x02,
  0x1A, 0x0B, 0x30, 0xBA, 0x28, 0x1B, 0xFE, 0x38, 0x1E, 0xFB, 0x28, 0x72, 0xEF, 0x93, 0x9F, 0xE3,
  0x38, 0x52, 0x9E, 0xFE, 0xA2, 0x20,
  // "Œ" (U+0152)
  0x28, 0x21, 0x7C, 0xEF, 0xB8, 0x71, 0x03, 0xEF, 0xB5, 0x49, 0xA8, 0x91, 0xB4, 0x44, 0xAF, 0x11,
  0xDF, 0xC3, 0x03, 0xA0, 0x93, 0x82, 0x3F, 0x27, 0xA0, 0x63, 0x03, 0xA0, 0x94, 0x81, 0x10, 0xCA,
  0x02, 0x30, 0x3A, 0x09, 0x60, 0xEA, 0x40, 0x3E, 0x0D, 0x2B, 0x40, 0x3A, 0x0A, 0x80, 0x02, 0x20,
  0xEA, 0x40, 0x3A, 0x09, 0x60, 0xCA, 0x02, 0x30, 0x3A, 0x09, 0x60, 0x7A, 0x06, 0x30, 0x3A, 0x09,
  0x48, 0x45, 0x80, 0xDF, 0xC3, 0x03, 0xA0, 0x94, 0x89, 0x0B, 0xB0, 0x3E, 0xFB, 0x54, 0xAA, 0x85,
  0xB4, 0x44, 0x5F, 0xA2, 0x82, 0x17, 0xCE, 0xFB, 0x0A,
  // "œ" (U+0153)
  0x28, 0x93, 0x2A, 0xEF, 0xD8, 0x04, 0xCE, 0xEB, 0x33, 0x89, 0x23, 0xEF, 0x93, 0x9F, 0xDF, 0xE4,
  0x6A, 0x04, 0x28, 0x1B, 0xFE, 0x30, 0xEA, 0x07, 0x28, 0x1D, 0xFC, 0x2A, 0x0B, 0x30, 0xBA, 0x04,
  0x20, 0xBA, 0x10, 0x1A, 0x0A, 0x30, 0x9F, 0x90, 0x01, 0xA0, 0xA3, 0x09, 0xA0, 0x58, 0x01, 0x22,
  0xA0, 0xB3, 0x0A, 0xA0, 0x47, 0x81, 0xBF, 0xE3, 0x0D, 0xA0, 0x93, 0x01, 0x04, 0x28, 0x62, 0xEF,
  0x93, 0x8F, 0xEA, 0x83, 0x72, 0x4C, 0x73, 0x89, 0x32, 0x9E, 0xFE, 0xA2, 0x4B, 0xEE, 0xD8, 0x20,
  // "Ŕ" (U+0154)
  0x68, 0x2C, 0xFD, 0x17, 0x18, 0x26, 0xFD, 0x27, 0x18, 0x11, 0xE9, 0x77, 0x50, 0x7E, 0x81, 0xEB,
  0x63, 0x81, 0x13, 0xEA, 0x81, 0x23, 0x9A, 0x0A, 0x40, 0xCA, 0x30, 0xEA, 0x01, 0x30, 0xCA, 0x30,
  0xCA, 0x03, 0x30, 0xCA, 0x38, 0x1E, 0xFE, 0x40, 0xCA, 0x20, 0x7A, 0x04, 0x40, 0xCD, 0x0E, 0x02,
  0x50, 0xCA, 0x02, 0x09, 0xA0, 0x45, 0x0C, 0xA1, 0x01, 0xA0, 0xD5, 0x0C, 0xA2, 0x09, 0xA0, 0x64,
  0x0C, 0xA2, 0x87, 0x1E, 0xFE, 0x10, 0x13, 0xEA, 0x82, 0x51, 0x07, 0xA8, 0x1B, 0x27, 0xD0, 0xB2,
  0x82, 0x7D, 0xFC,
  // "ŕ" (U+0155)
  0x58, 0x2C, 0xFD, 0x15, 0x82, 0x6F, 0xD2, 0x58, 0x11, 0xE9, 0x77, 0x08, 0xB8, 0x65, 0xAE, 0xEA,
  0x01, 0x8B, 0x05, 0x07, 0xA8, 0x11, 0x03, 0xA8, 0x3B, 0x01, 0xA4, 0x20, 0x3A, 0x09, 0x60, 0x3A,
  0x08, 0x60, 0x3A, 0x08, 0x60, 0x3A, 0x08, 0x60, 0x3A, 0x08, 0x50, 0x10, 0x9A, 0x0C, 0x03, 0x40,
  0x9D, 0x05, 0x30,
  // "Ŗ" (U+0156)
  0x07, 0xE8, 0x1E, 0xB6, 0x38, 0x11, 0x3E, 0xA8, 0x12, 0x39, 0xA0, 0xA4, 0x0C, 0xA3, 0x0E, 0xA0,
  0x13, 0x0C, 0xA3, 0x0C, 0xA0, 0x33, 0x0C, 0xA3, 0x81, 0xEF, 0xE4, 0x0C, 0xA2, 0x07, 0xA0, 0x44,
  0x0C, 0xD0, 0xE0, 0x25, 0x0C, 0xA0, 0x20, 0x9A, 0x04, 0x50, 0xCA, 0x10, 0x1A, 0x0D, 0x50, 0xCA,
  0x20, 0x9A, 0x06, 0x40, 0xCA, 0x28, 0x71, 0xEF, 0xE1, 0x01, 0x3E, 0xA8, 0x25, 0x10, 0x7A, 0x81,
  0xB2, 0x7D, 0x0B, 0x28, 0x27, 0xDF, 0xC7, 0x74, 0x81, 0xBE, 0x37, 0x39, 0x0B, 0x73, 0x81, 0x4E,
  0x16,
  // "ŗ" (U+0157)
  0x08, 0xB8, 0x65, 0xAE, 0xEA, 0x01, 0x8B, 0x05, 0x07, 0xA8, 0x11, 0x03, 0xA8, 0x3B, 0x01, 0xA4,
  0x20, 0x3A, 0x09, 0x60, 0x3A, 0x08, 0x60, 0x3A, 0x08, 0x60, 0x3A, 0x08, 0x60, 0x3A, 0x08, 0x50,
  0x10, 0x9A, 0x0C, 0x03, 0x40, 0x9D, 0x05, 0x77, 0x18, 0x1B, 0xE3, 0x79, 0x0B, 0x78, 0x14, 0xE1,
  0x60,
  // "Ř" (U+0158)
  0x28, 0x11, 0xE8, 0x20, 0xA0, 0xD7, 0x84, 0x4F, 0xAC, 0xE2, 0x71, 0x09, 0xA0, 0x67, 0x74, 0x07,
  0xE8, 0x1E, 0xB6, 0x38, 0x11, 0x3E, 0xA8, 0x12, 0x39, 0xA0, 0xA4, 0x0C, 0xA3, 0x0E, 0xA0, 0x13,
  0x0C, 0xA3, 0x0C, 0xA0, 0x33, 0x0C, 0xA3, 0x81, 0xEF, 0xE4, 0x0C, 0xA2, 0x07, 0xA0, 0x44, 0x0C,
  0xD0, 0xE0, 0x25, 0x0C, 0xA0, 0x20, 0x9A, 0x04, 0x50, 0xCA, 0x10, 0x1A, 0x0D, 0x50, 0xCA, 0x20,
  0x9A, 0x06, 0x40, 0xCA, 0x28, 0x71, 0xEF, 0xE1, 0x01, 0x3E, 0xA8, 0x25, 0x10, 0x7A, 0x81, 0xB2,
  0x7D, 0x0B, 0x28, 0x27, 0xDF, 0xC0,
  // "ř" (U+0159)
  0x18, 0x11, 0xE8, 0x20, 0xA0, 0xD4, 0x84, 0x4F, 0xAC, 0xE2, 0x50, 0x9A, 0x06, 0x76, 0x08, 0xB8,
  0x65, 0xAE, 0xEA, 0x01, 0x8B, 0x05, 0x07, 0xA8, 0x11, 0x03, 0xA8, 0x3B, 0x01, 0xA4, 0x20, 0x3A,
  0x09, 0x60, 0x3A, 0x08, 0x60, 0x3A, 0x08, 0x60, 0x3A, 0x08, 0x60, 0x3A, 0x08, 0x50, 0x10, 0x9A,
  0x0C, 0x03, 0x40, 0x9D, 0x05, 0x30,
  // "Ś" (U+015A)
  0x68, 0x2C, 0xFD, 0x15, 0x82, 0x6F, 0xD2, 0x58, 0x11, 0xE9, 0x77, 0x18, 0x53, 0xAE, 0xFE, 0xB2,
  0x28, 0x65, 0xFC, 0x33, 0xDF, 0xE2, 0x81, 0xDF, 0x42, 0x83, 0x5F, 0xE0, 0x1A, 0x07, 0x28, 0x11,
  0x72, 0x28, 0x2E, 0xFE, 0x66, 0x07, 0xB0, 0xD0, 0x75, 0x06, 0x0E, 0xB0, 0xE0, 0x44, 0x81, 0x17,
  0xDB, 0x02, 0x20, 0x13, 0x08, 0xA8, 0x28, 0x2D, 0xA4, 0x84, 0xDF, 0x96, 0xFE, 0x48, 0x2D, 0xF5,
  0x2A, 0x84, 0xB3, 0x39, 0xFA, 0x28, 0x53, 0xAE, 0xFE, 0xB6, 0x20,
  // "ś" (U+015B)
  0x58, 0x2C, 0xFD, 0x14, 0x82, 0x6F, 0xD2, 0x48, 0x11, 0xE9, 0x76, 0x85, 0x19, 0xDF, 0xEA, 0x12,
  0x89, 0x1D, 0xF5, 0x2A, 0xFA, 0x03, 0xFE, 0x28, 0x32, 0xE5, 0x02, 0xA0, 0xB0, 0x45, 0x09, 0xB0,
  0xD0, 0x64, 0x05, 0x0C, 0xB0, 0x82, 0x83, 0x51, 0x03, 0xBA, 0x18, 0x15, 0xF6, 0x20, 0x1A, 0x18,
  0x64, 0xFE, 0x42, 0x8F, 0x92, 0x84, 0x6C, 0xFE, 0xC7, 0x20,
  // "Ŝ" (U+015C)
  0x30, 0x9A, 0x06, 0x58, 0x44, 0xFA, 0xCE, 0x23, 0x81, 0x1E, 0x82, 0x0A, 0x0D, 0x77, 0x85, 0x3A,
  0xEF, 0xEB, 0x22, 0x86, 0x5F, 0xC3, 0x3D, 0xFE, 0x28, 0x1D, 0xF4, 0x28, 0x35, 0xFE, 0x01, 0xA0,
  0x72, 0x81, 0x17, 0x22, 0x82, 0xEF, 0xE6, 0x60, 0x7B, 0x0D, 0x07, 0x50, 0x60, 0xEB, 0x0E, 0x04,
  0x48, 0x11, 0x7D, 0xB0, 0x22, 0x01, 0x30, 0x8A, 0x82, 0x82, 0xDA, 0x48, 0x4D, 0xF9, 0x6F, 0xE4,
  0x82, 0xDF, 0x52, 0xA8, 0x4B, 0x33, 0x9F, 0xA2, 0x85, 0x3A, 0xEF, 0xEB, 0x62,
  // "ŝ" (U+015D)
  0x00, 0x9F, 0xF6, 0x00, 0x04, 0xFA, 0xCE, 0x20, 0x1E, 0x80, 0x0A, 0xD0, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x9D, 0xFE, 0xA1, 0x0D, 0xF5, 0x2A, 0xFA, 0x3F, 0xE0, 0x02, 0xE5, 0x2F, 0xFB, 0x40, 0x00,
  0x09, 0xFF, 0xFD, 0x60, 0x00, 0x5C, 0xFF, 0xF8, 0x05, 0x10, 0x3B, 0xFF, 0x5F, 0x60, 0x01, 0xFF,
  0x4F, 0xE4, 0x28, 0xF9, 0x06, 0xCF, 0xEC, 0x70,
  // "Ş" (U+015E)
  0x28, 0x53, 0xAE, 0xFE, 0xB2, 0x28, 0x65, 0xFC, 0x33, 0xDF, 0xE2, 0x81, 0xDF, 0x42, 0x83, 0x5F,
  0xE0, 0x1A, 0x07, 0x28, 0x11, 0x72, 0x28, 0x2E, 0xFE, 0x66, 0x07, 0xB0, 0xD0, 0x75, 0x06, 0x0E,
  0xB0, 0xE0, 0x44, 0x81, 0x17, 0xDB, 0x02, 0x20, 0x13, 0x08, 0xA8, 0x28, 0x2D, 0xA4, 0x84, 0xDF,
  0x96, 0xFE, 0x48, 0x2D, 0xF5, 0x2A, 0x84, 0xB3, 0x39, 0xFA, 0x28, 0x53, 0xAE, 0xFE, 0xB6, 0x60,
  0xD0, 0x67, 0x18, 0x14, 0xEC, 0x78, 0x11, 0xDE, 0x50, 0x1A, 0x0E, 0x05, 0x60, 0x10, 0x25,
  // "ş" (U+015F)
  0x18, 0xA0, 0x19, 0xDF, 0xEA, 0x10, 0xDF, 0x52, 0xAF, 0xA3, 0xFE, 0x28, 0x22, 0xE5, 0x2A, 0x0B,
  0x04, 0x40, 0x9B, 0x0D, 0x06, 0x30, 0x50, 0xCB, 0x85, 0x80, 0x51, 0x03, 0xBA, 0x81, 0x5F, 0x62,
  0x01, 0xA8, 0x95, 0x4F, 0xE4, 0x28, 0xF9, 0x06, 0xCF, 0xEC, 0x74, 0x0D, 0x06, 0x68, 0x14, 0xEC,
  0x58, 0x11, 0xDE, 0x30, 0x1A, 0x0E, 0x05, 0x40, 0x10, 0x24,
  // "Š" (U+0160)
  0x18, 0x11, 0xE8, 0x20, 0xA0, 0xD4, 0x84, 0x4F, 0xAC, 0xE2, 0x50, 0x9A, 0x06, 0x77, 0x18, 0x53,
  0xAE, 0xFE, 0xB2, 0x28, 0x65, 0xFC, 0x33, 0xDF, 0xE2, 0x81, 0xDF, 0x42, 0x83, 0x5F, 0xE0, 0x1A,
  0x07, 0x28, 0x11, 0x72, 0x28, 0x2E, 0xFE, 0x66, 0x07, 0xB0, 0xD0, 0x75, 0x06, 0x0E, 0xB0, 0xE0,
  0x44, 0x81, 0x17, 0xDB, 0x02, 0x20, 0x13, 0x08, 0xA8, 0x28, 0x2D, 0xA4, 0x84, 0xDF, 0x96, 0xFE,
  0x48, 0x2D, 0xF5, 0x2A, 0x84, 0xB3, 0x39, 0xFA, 0x28, 0x53, 0xAE, 0xFE, 0xB6, 0x20,
  // "š" (U+0161)
  0x1E, 0x80, 0x0A, 0xD0, 0x04, 0xFA, 0xCE, 0x20, 0x00, 0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x9D, 0xFE, 0xA1, 0x0D, 0xF5, 0x2A, 0xFA, 0x3F, 0xE0, 0x02, 0xE5, 0x2F, 0xFB, 0x40, 0x00,
  0x09, 0xFF, 0xFD, 0x60, 0x00, 0x5C, 0xFF, 0xF8, 0x05, 0x10, 0x3B, 0xFF, 0x5F, 0x60, 0x01, 0xFF,
  0x4F, 0xE4, 0x28, 0xF9, 0x06, 0xCF, 0xEC, 0x70,
  // "Ţ" (U+0162)
  0x0B, 0xFB, 0x84, 0x7B, 0xD3, 0x29, 0xA8, 0x56, 0x25, 0xF8, 0xC7, 0x20, 0x8A, 0x04, 0x28, 0x2B,
  0x86, 0x32, 0x08, 0xA0, 0x42, 0x05, 0x04, 0x40, 0x8A, 0x04, 0x71, 0x08, 0xA0, 0x47, 0x10, 0x8A,
  0x04, 0x71, 0x08, 0xA0, 0x47, 0x10, 0x8A, 0x04, 0x71, 0x08, 0xA0, 0x47, 0x10, 0x8A, 0x04, 0x70,
  0x20, 0xBA, 0x09, 0x02, 0x50, 0x3E, 0x71, 0x0D, 0x07, 0x73, 0x81, 0x4E, 0xC7, 0x20, 0x10, 0xD9,
  0x71, 0xA0, 0xE0, 0x67, 0x10, 0x10, 0x26,
  // "ţ" (U+0163)
  0x28, 0x13, 0xF7, 0x38, 0x24, 0xDF, 0x72, 0x09, 0xD8, 0x1B, 0x15, 0xA8, 0x38, 0x21, 0x04, 0xA0,
  0x73, 0x04, 0xA0, 0x73, 0x04, 0xA0, 0x73, 0x04, 0xA0, 0x73, 0x04, 0xA0, 0x73, 0x03, 0xA0, 0x74,
  0x83, 0xEF, 0xC2, 0x32, 0x83, 0x5D, 0xFE, 0xB4, 0x0D, 0x07, 0x58, 0x14, 0xEC, 0x40, 0x10, 0xD9,
  0x3A, 0x0E, 0x06, 0x30, 0x10, 0x22,
  // "Ť" (U+0164)
  0x28, 0x11, 0xE8, 0x20, 0xA0, 0xD6, 0x84, 0x4F, 0xAC, 0xE2, 0x70, 0x9A, 0x06, 0x77, 0x20, 0xBF,
  0xB8, 0x47, 0xBD, 0x32, 0x9A, 0x85, 0x62, 0x5F, 0x8C, 0x72, 0x08, 0xA0, 0x42, 0x82, 0xB8, 0x63,
  0x20, 0x8A, 0x04, 0x20, 0x50, 0x44, 0x08, 0xA0, 0x47, 0x10, 0x8A, 0x04, 0x71, 0x08, 0xA0, 0x47,
  0x10, 0x8A, 0x04, 0x71, 0x08, 0xA0, 0x47, 0x10, 0x8A, 0x04, 0x71, 0x08, 0xA0, 0x47, 0x02, 0x0B,
  0xA0, 0x90, 0x25, 0x03, 0xE3,
  // "ť" (U+0165)
  0x68, 0x1D, 0xF2, 0x38, 0x32, 0x12, 0xF9, 0x38, 0x34, 0xF7, 0x5C, 0x38, 0x24, 0xDF, 0x74, 0x09,
  0xD0, 0xB2, 0x01, 0x05, 0xA8, 0x18, 0x21, 0x30, 0x4A, 0x07, 0x50, 0x4A, 0x07, 0x50, 0x4A, 0x07,
  0x50, 0x4A, 0x07, 0x50, 0x4A, 0x07, 0x50, 0x3A, 0x07, 0x68, 0x3E, 0xFC, 0x23, 0x48, 0x35, 0xDF,
  0xEB, 0x20,
  // "Ŧ" (U+0166)
  0x0B, 0xFB, 0x84, 0x7B, 0xD3, 0x29, 0xA8, 0x56, 0x25, 0xF8, 0xC8, 0x20, 0x8A, 0x04, 0x28, 0x2C,
  0x86, 0x32, 0x08, 0xA0, 0x42, 0x05, 0x04, 0x40, 0x8A, 0x04, 0x71, 0x08, 0xA0, 0x45, 0x02, 0xF0,
  0xD4, 0x81, 0x22, 0x9A, 0x81, 0x62, 0x26, 0x08, 0xA0, 0x47, 0x10, 0x8A, 0x04, 0x71, 0x08, 0xA0,
  0x47, 0x02, 0x0B, 0xA0, 0x80, 0x25, 0x03, 0xE3,
  // "ŧ" (U+0167)
  0x28, 0x13, 0xF7, 0x38, 0x24, 0xDF, 0x72, 0x09, 0xD8, 0x1B, 0x15, 0xA8, 0x38, 0x21, 0x04, 0xA0,
  0x73, 0x04, 0xA0, 0x72, 0x07, 0xD8, 0x17, 0x15, 0xA8, 0x38, 0x21, 0x04, 0xA0, 0x73, 0x03, 0xA0,
  0x73, 0x01, 0xA8, 0x1C, 0x23, 0x28, 0x35, 0xDF, 0xEB,
  // "Ũ" (U+0168)
  0x48, 0x55, 0xED, 0x71, 0x8B, 0x68, 0x61, 0xF4, 0x6D, 0xFE, 0x27, 0x02, 0x30, 0x17, 0x75, 0x0B,
  0xD8, 0x17, 0x08, 0xC8, 0x12, 0x15, 0xA8, 0x7E, 0x31, 0x01, 0x3F, 0xB2, 0x3A, 0x0C, 0x50, 0xD0,
  0x74, 0xA0, 0xC5, 0x0D, 0x07, 0x4A, 0x0C, 0x50, 0xD0, 0x74, 0xA0, 0xC5, 0x0D, 0x07, 0x4A, 0x0C,
  0x50, 0xD0, 0x74, 0xA0, 0xC5, 0x0D, 0x07, 0x4A, 0x0C, 0x50, 0xD0, 0x74, 0xA0, 0xD5, 0x0E, 0x06,
  0x40, 0xCA, 0x01, 0x38, 0x12, 0xF4, 0x40, 0x4A, 0x84, 0xC4, 0x24, 0xDB, 0x68, 0x13, 0x9D, 0xA0,
  0xD0, 0x84,
  // "ũ" (U+0169)
  0x38, 0x55, 0xED, 0x71, 0x8B, 0x48, 0x61, 0xF4, 0x6D, 0xFE, 0x25, 0x02, 0x30, 0x17, 0x72, 0x08,
  0xB8, 0x17, 0x0D, 0xB8, 0x23, 0x01, 0x9A, 0x82, 0x70, 0x3C, 0xA0, 0x32, 0x04, 0xA0, 0x72, 0x08,
  0xA0, 0x32, 0x04, 0xA0, 0x72, 0x08, 0xA0, 0x32, 0x04, 0xA0, 0x72, 0x08, 0xA0, 0x32, 0x04, 0xA0,
  0x72, 0x08, 0xA0, 0x32, 0x03, 0xA0, 0x72, 0x08, 0xA0, 0x32, 0x02, 0xA0, 0x92, 0x0B, 0xA0, 0x33,
  0x84, 0xCF, 0xE3, 0x6E, 0xA0, 0x80, 0x12, 0x84, 0x2B, 0xED, 0xA4, 0xB0, 0x80,
  // "Ū" (U+016A)
  0x40, 0x4C, 0x0E, 0x72, 0x80, 0x12, 0x40, 0xBD, 0x81, 0x70, 0x8C, 0x81, 0x21, 0x5A, 0x87, 0xE3,
  0x10, 0x13, 0xFB, 0x23, 0xA0, 0xC5, 0x0D, 0x07, 0x4A, 0x0C, 0x50, 0xD0, 0x74, 0xA0, 0xC5, 0x0D,
  0x07, 0x4A, 0x0C, 0x50, 0xD0, 0x74, 0xA0, 0xC5, 0x0D, 0x07, 0x4A, 0x0C, 0x50, 0xD0, 0x74, 0xA0,
  0xC5, 0x0D, 0x07, 0x4A, 0x0D, 0x50, 0xE0, 0x64, 0x0C, 0xA0, 0x13, 0x81, 0x2F, 0x44, 0x04, 0xA8,
  0x4C, 0x42, 0x4D, 0xB6, 0x81, 0x39, 0xDA, 0x0D, 0x08, 0x40,
  // "ū" (U+016B)
  0x20, 0x4C, 0x0E, 0x78, 0x01, 0x24, 0x08, 0xB8, 0x17, 0x0D, 0xB8, 0x23, 0x01, 0x9A, 0x82, 0x70,
  0x3C, 0xA0, 0x32, 0x04, 0xA0, 0x72, 0x08, 0xA0, 0x32, 0x04, 0xA0, 0x72, 0x08, 0xA0, 0x32, 0x04,
  0xA0, 0x72, 0x08, 0xA0, 0x32, 0x04, 0xA0, 0x72, 0x08, 0xA0, 0x32, 0x03, 0xA0, 0x72, 0x08, 0xA0,
  0x32, 0x02, 0xA0, 0x92, 0x0B, 0xA0, 0x33, 0x84, 0xCF, 0xE3, 0x6E, 0xA0, 0x80, 0x12, 0x84, 0x2B,
  0xED, 0xA4, 0xB0, 0x80,
  // "Ŭ" (U+016C)
  0x30, 0x20, 0xC3, 0x0A, 0x05, 0x71, 0x84, 0xE7, 0x05, 0xF2, 0x71, 0x83, 0x3E, 0xFE, 0x67, 0x40,
  0x17, 0x0B, 0xD8, 0x17, 0x08, 0xC8, 0x12, 0x15, 0xA8, 0x7E, 0x31, 0x01, 0x3F, 0xB2, 0x3A, 0x0C,
  0x50, 0xD0, 0x74, 0xA0, 0xC5, 0x0D, 0x07, 0x4A, 0x0C, 0x50, 0xD0, 0x74, 0xA0, 0xC5, 0x0D, 0x07,
  0x4A, 0x0C, 0x50, 0xD0, 0x74, 0xA0, 0xC5, 0x0D, 0x07, 0x4A, 0x0C, 0x50, 0xD0, 0x74, 0xA0, 0xD5,
  0x0E, 0x06, 0x40, 0xCA, 0x01, 0x38, 0x12, 0xF4, 0x40, 0x4A, 0x84, 0xC4, 0x24, 0xDB, 0x68, 0x13,
  0x9D, 0xA0, 0xD0, 0x84,
  // "ŭ" (U+016D)
  0x20, 0x20, 0xC3, 0x0A, 0x05, 0x68, 0x4E, 0x70, 0x5F, 0x26, 0x83, 0x3E, 0xFE, 0x67, 0x20, 0x16,
  0x08, 0xB8, 0x17, 0x0D, 0xB8, 0x23, 0x01, 0x9A, 0x82, 0x70, 0x3C, 0xA0, 0x32, 0x04, 0xA0, 0x72,
  0x08, 0xA0, 0x32, 0x04, 0xA0, 0x72, 0x08, 0xA0, 0x32, 0x04, 0xA0, 0x72, 0x08, 0xA0, 0x32, 0x04,
  0xA0, 0x72, 0x08, 0xA0, 0x32, 0x03, 0xA0, 0x72, 0x08, 0xA0, 0x32, 0x02, 0xA0, 0x92, 0x0B, 0xA0,
  0x33, 0x84, 0xCF, 0xE3, 0x6E, 0xA0, 0x80, 0x12, 0x84, 0x2B, 0xED, 0xA4, 0xB0, 0x80,
  // "Ů" (U+016E)
  0x58, 0x26, 0xDD, 0x57, 0x28, 0x21, 0xF5, 0x59, 0x72, 0x84, 0x1F, 0x22, 0xF1, 0x72, 0x08, 0xA0,
  0x87, 0x40, 0x01, 0x60, 0xBD, 0x81, 0x70, 0x8C, 0x81, 0x21, 0x5A, 0x87, 0xE3, 0x10, 0x13, 0xFB,
  0x23, 0xA0, 0xC5, 0x0D, 0x07, 0x4A, 0x0C, 0x50, 0xD0, 0x74, 0xA0, 0xC5, 0x0D, 0x07, 0x4A, 0x0C,
  0x50, 0xD0, 0x74, 0xA0, 0xC5, 0x0D, 0x07, 0x4A, 0x0C, 0x50, 0xD0, 0x74, 0xA0, 0xC5, 0x0D, 0x07,
  0x4A, 0x0D, 0x50, 0xE0, 0x64, 0x0C, 0xA0, 0x13, 0x81, 0x2F, 0x44, 0x04, 0xA8, 0x4C, 0x42, 0x4D,
  0xB6, 0x81, 0x39, 0xDA, 0x0D, 0x08, 0x40,
  // "ů" (U+016F)
  0x48, 0x26, 0xDD, 0x57, 0x82, 0x1F, 0x55, 0x97, 0x84, 0x1F, 0x22, 0xF1, 0x70, 0x8A, 0x08, 0x72,
  0x00, 0x15, 0x08, 0xB8, 0x17, 0x0D, 0xB8, 0x23, 0x01, 0x9A, 0x82, 0x70, 0x3C, 0xA0, 0x32, 0x04,
  0xA0, 0x72, 0x08, 0xA0, 0x32, 0x04, 0xA0, 0x72, 0x08, 0xA0, 0x32, 0x04, 0xA0, 0x72, 0x08, 0xA0,
  0x32, 0x04, 0xA0, 0x72, 0x08, 0xA0, 0x32, 0x03, 0xA0, 0x72, 0x08, 0xA0, 0x32, 0x02, 0xA0, 0x92,
  0x0B, 0xA0, 0x33, 0x84, 0xCF, 0xE3, 0x6E, 0xA0, 0x80, 0x12, 0x84, 0x2B, 0xED, 0xA4, 0xB0, 0x80,
  // "Ű" (U+0170)
  0x68, 0x4D, 0xE4, 0x8E, 0xA7, 0x85, 0x8F, 0x72, 0xFD, 0x16, 0x85, 0x2F, 0x70, 0xAC, 0x17, 0x73,
  0x0B, 0xD8, 0x17, 0x08, 0xC8, 0x12, 0x15, 0xA8, 0x7E, 0x31, 0x01, 0x3F, 0xB2, 0x3A, 0x0C, 0x50,
  0xD0, 0x74, 0xA0, 0xC5, 0x0D, 0x07, 0x4A, 0x0C, 0x50, 0xD0, 0x74, 0xA0, 0xC5, 0x0D, 0x07, 0x4A,
  0x0C, 0x50, 0xD0, 0x74, 0xA0, 0xC5, 0x0D, 0x07, 0x4A, 0x0C, 0x50, 0xD0, 0x74, 0xA0, 0xD5, 0x0E,
  0x06, 0x40, 0xCA, 0x01, 0x38, 0x12, 0xF4, 0x40, 0x4A, 0x84, 0xC4, 0x24, 0xDB, 0x68, 0x13, 0x9D,
  0xA0, 0xD0, 0x84,
  // "ű" (U+0171)
  0x48, 0x4D, 0xE4, 0x8E, 0xA5, 0x85, 0x8F, 0x72, 0xFD, 0x14, 0x85, 0x2F, 0x70, 0xAC, 0x17, 0x71,
  0x08, 0xB8, 0x17, 0x0D, 0xB8, 0x23, 0x01, 0x9A, 0x82, 0x70, 0x3C, 0xA0, 0x32, 0x04, 0xA0, 0x72,
  0x08, 0xA0, 0x32, 0x04, 0xA0, 0x72, 0x08, 0xA0, 0x32, 0x04, 0xA0, 0x72, 0x08, 0xA0, 0x32, 0x04,
  0xA0, 0x72, 0x08, 0xA0, 0x32, 0x03, 0xA0, 0x72, 0x08, 0xA0, 0x32, 0x02, 0xA0, 0x92, 0x0B, 0xA0,
  0x33, 0x84, 0xCF, 0xE3, 0x6E, 0xA0, 0x80, 0x12, 0x84, 0x2B, 0xED, 0xA4, 0xB0, 0x80,
  // "Ų" (U+0172)
  0x0B, 0xD8, 0x17, 0x08, 0xC8, 0x12, 0x15, 0xA8, 0x7E, 0x31, 0x01, 0x3F, 0xB2, 0x3A, 0x0C, 0x50,
  0xD0, 0x74, 0xA0, 0xC5, 0x0D, 0x07, 0x4A, 0x0C, 0x50, 0xD0, 0x74, 0xA0, 0xC5, 0x0D, 0x07, 0x4A,
  0x0C, 0x50, 0xD0, 0x74, 0xA0, 0xC5, 0x0D, 0x07, 0x4A, 0x0C, 0x50, 0xD0, 0x74, 0xA0, 0xD5, 0x0E,
  0x06, 0x40, 0xCA, 0x01, 0x38, 0x12, 0xF4, 0x40, 0x4A, 0x84, 0xC4, 0x24, 0xDB, 0x68, 0x13, 0x9D,
  0xA0, 0xD0, 0x87, 0x28, 0x14, 0xE5, 0x74, 0x0E, 0x0C, 0x75, 0x98, 0x1D, 0x21, 0x73, 0x08, 0xB0,
  0x17, 0x38, 0x11, 0x31, 0x50,
  // "ų" (U+0173)
  0x08, 0xB8, 0x17, 0x0D, 0xB8, 0x23, 0x01, 0x9A, 0x82, 0x70, 0x3C, 0xA0, 0x32, 0x04, 0xA0, 0x72,
  0x08, 0xA0, 0x32, 0x04, 0xA0, 0x72, 0x08, 0xA0, 0x32, 0x04, 0xA0, 0x72, 0x08, 0xA0, 0x32, 0x04,
  0xA0, 0x72, 0x08, 0xA0, 0x32, 0x03, 0xA0, 0x72, 0x08, 0xA0, 0x32, 0x02, 0xA0, 0x92, 0x0B, 0xA0,
  0x33, 0x84, 0xCF, 0xE3, 0x6E, 0xA0, 0x80, 0x12, 0x84, 0x2B, 0xED, 0xA5, 0xB0, 0x86, 0x81, 0x6E,
  0x37, 0x18, 0x11, 0xFA, 0x72, 0x83, 0x3F, 0xC2, 0x17, 0x10, 0xAA, 0x0E, 0x72, 0x81, 0x13, 0x12,
  // "Ŵ" (U+0174)
  0x71, 0x09, 0xA0, 0x67, 0x71, 0x84, 0x4F, 0xAC, 0xE2, 0x76, 0x81, 0x1E, 0x82, 0x0A, 0x0D, 0x77,
  0x76, 0xE3, 0x81, 0x9F, 0x12, 0x07, 0xC8, 0x13, 0x3C, 0xA0, 0xB0, 0x23, 0x81, 0xDF, 0x62, 0x83,
  0x14, 0xFE, 0x32, 0x05, 0xA0, 0x93, 0x02, 0xA0, 0xB4, 0x90, 0x83, 0x01, 0xA0, 0xD3, 0x07, 0xB0,
  0x12, 0x81, 0x3F, 0x34, 0x0B, 0xA0, 0x22, 0x0C, 0x0E, 0xA0, 0x72, 0x07, 0x0E, 0x50, 0x7A, 0x83,
  0x60, 0x1F, 0x6A, 0x0C, 0x20, 0x0B, 0x50, 0x2A, 0x84, 0xB0, 0x5F, 0x0A, 0xA8, 0x22, 0x0E, 0x66,
  0x0D, 0xA1, 0x82, 0xAB, 0x05, 0xA8, 0x27, 0x3F, 0x26, 0x08, 0xA8, 0x14, 0xE6, 0x28, 0x3E, 0xFC,
  0x6E, 0x70, 0x3A, 0x81, 0xBF, 0x12, 0x09, 0xA0, 0xB0, 0x97, 0x10, 0xEA, 0x0C, 0x30, 0x3B, 0x05,
  0x71, 0x09, 0xA0, 0x74, 0x0D, 0xA0, 0x17, 0x10, 0x5A, 0x02, 0x48, 0x18, 0xFD, 0x50,
  // "ŵ" (U+0175)
  0x60, 0x9A, 0x06, 0x74, 0x84, 0x4F, 0xAC, 0xE2, 0x72, 0x81, 0x1E, 0x82, 0x0A, 0x0D, 0x77, 0x7D,
  0x85, 0x30, 0x7F, 0x10, 0xAB, 0x81, 0x64, 0xEA, 0x04, 0x28, 0x6C, 0xF5, 0x01, 0xAF, 0x62, 0x09,
  0xA2, 0x01, 0xA0, 0xA2, 0x06, 0x0D, 0x30, 0x4A, 0x81, 0x40, 0x7A, 0x0E, 0x20, 0xB0, 0x84, 0xA8,
  0x28, 0x0C, 0xAA, 0x82, 0x40, 0xE3, 0x48, 0x91, 0xBF, 0xC1, 0xF1, 0xDF, 0x94, 0xE5, 0x06, 0xA8,
  0x67, 0xB0, 0x8F, 0xD8, 0x95, 0x02, 0xA8, 0x2D, 0x60, 0x3A, 0x0D, 0x04, 0x60, 0xDA, 0x01, 0x28,
  0x1E, 0xFE, 0x78, 0x18, 0xFB, 0x38, 0x19, 0xFA, 0x40,
  // "Ŷ" (U+0176)
  0x40, 0x9A, 0x06, 0x71, 0x84, 0x4F, 0xAC, 0xE2, 0x68, 0x11, 0xE8, 0x20, 0xA0, 0xD7, 0x73, 0xE1,
  0x03, 0xC8, 0x17, 0x3D, 0xA0, 0xC0, 0x32, 0x85, 0x3C, 0xF7, 0x10, 0x4A, 0x0B, 0x40, 0xB0, 0xC4,
  0x0B, 0xA0, 0x32, 0x81, 0x2F, 0x44, 0x03, 0xA0, 0xB2, 0x09, 0x0B, 0x60, 0xAA, 0x82, 0x32, 0xF3,
  0x60, 0x2A, 0x81, 0xA9, 0xA7, 0x10, 0x9A, 0x0E, 0x02, 0x71, 0x03, 0xA0, 0xB7, 0x20, 0x2A, 0x0A,
  0x72, 0x02, 0xA0, 0xA7, 0x10, 0x20, 0x7A, 0x81, 0xD3, 0x16, 0xE0, 0x93,
  // "ŷ" (U+0177)
  0x30, 0x9A, 0x06, 0x68, 0x44, 0xFA, 0xCE, 0x24, 0x81, 0x1E, 0x82, 0x0A, 0x0D, 0x77, 0xD0, 0x10,
  0x9B, 0x81, 0x63, 0xEA, 0x87, 0x40, 0x18, 0xF8, 0x10, 0x8A, 0x02, 0x20, 0x70, 0xE3, 0x01, 0xA0,
  0x82, 0x0C, 0x09, 0x48, 0x5A, 0xFE, 0x01, 0xF3, 0x40, 0x4A, 0x81, 0x57, 0xC6, 0x83, 0xDF, 0xAC,
  0x76, 0x83, 0x7F, 0xEF, 0x16, 0x01, 0xA0, 0xB7, 0x18, 0x1A, 0xF5, 0x71, 0x0D, 0x0E, 0x71, 0x81,
  0x6F, 0x85, 0x84, 0x13, 0x8F, 0xD1, 0x58, 0x37, 0xFD, 0x91, 0x60,
  // "Ÿ" (U+0178)
  0x40, 0x17, 0x48, 0x49, 0xF4, 0x0E, 0xE7, 0x84, 0x7E, 0x30, 0xCC, 0x77, 0x3E, 0x10, 0x3C, 0x81,
  0x73, 0xDA, 0x0C, 0x03, 0x28, 0x53, 0xCF, 0x71, 0x04, 0xA0, 0xB4, 0x0B, 0x0C, 0x40, 0xBA, 0x03,
  0x28, 0x12, 0xF4, 0x40, 0x3A, 0x0B, 0x20, 0x90, 0xB6, 0x0A, 0xA8, 0x23, 0x2F, 0x36, 0x02, 0xA8,
  0x1A, 0x9A, 0x71, 0x09, 0xA0, 0xE0, 0x27, 0x10, 0x3A, 0x0B, 0x72, 0x02, 0xA0, 0xA7, 0x20, 0x2A,
  0x0A, 0x71, 0x02, 0x07, 0xA8, 0x1D, 0x31, 0x6E, 0x09, 0x30,
  // "Ź" (U+0179)
  0x68, 0x2C, 0xFD, 0x17, 0x82, 0x6F, 0xD2, 0x78, 0x11, 0xE9, 0x77, 0x40, 0xCF, 0x90, 0xC2, 0x85,
  0xDD, 0x21, 0x11, 0xCA, 0x06, 0x20, 0xD0, 0x83, 0x05, 0xA0, 0xC3, 0x0A, 0x04, 0x20, 0x10, 0xEA,
  0x03, 0x70, 0x9A, 0x09, 0x70, 0x3A, 0x0E, 0x01, 0x70, 0xCA, 0x05, 0x70, 0x6A, 0x0B, 0x70, 0x10,
  0xEA, 0x02, 0x70, 0xAA, 0x07, 0x38, 0x31, 0xB2, 0x04, 0xA0, 0xD4, 0x83, 0x4F, 0x20, 0xDA, 0x87,
  0x51, 0x11, 0x2C, 0xF2, 0x3F, 0xB0, 0x10,
  // "ź" (U+017A)
  0x58, 0x2C, 0xFD, 0x14, 0x82, 0x6F, 0xD2, 0x48, 0x11, 0xE9, 0x76, 0xF8, 0x5B, 0x1F, 0x83, 0x3A,
  0xA0, 0x40, 0x29, 0x20, 0x3A, 0x09, 0x58, 0x1D, 0xFD, 0x50, 0x8A, 0x04, 0x40, 0x3A, 0x09, 0x58,
  0x2C, 0xFD, 0x12, 0x81, 0x50, 0x7A, 0x04, 0x28, 0x13, 0xE2, 0xA8, 0x5C, 0x33, 0x3B, 0xEA, 0xF0,
  0xE0,
  // "Ż" (U+017B)
  0x58, 0x1A, 0xC4, 0x71, 0x03, 0xA0, 0xB7, 0x28, 0x1C, 0xE6, 0x77, 0x30, 0xCF, 0x90, 0xC2, 0x85,
  0xDD, 0x21, 0x11, 0xCA, 0x06, 0x20, 0xD0, 0x83, 0x05, 0xA0, 0xC3, 0x0A, 0x04, 0x20, 0x10, 0xEA,
  0x03, 0x70, 0x9A, 0x09, 0x70, 0x3A, 0x0E, 0x01, 0x70, 0xCA, 0x05, 0x70, 0x6A, 0x0B, 0x70, 0x10,
  0xEA, 0x02, 0x70, 0xAA, 0x07, 0x38, 0x31, 0xB2, 0x04, 0xA0, 0xD4, 0x83, 0x4F, 0x20, 0xDA, 0x87,
  0x51, 0x11, 0x2C, 0xF2, 0x3F, 0xB0, 0x10,
  // "ż" (U+017C)
  0x48, 0x1A, 0xC4, 0x50, 0x3A, 0x0B, 0x68, 0x1C, 0xE6, 0x75, 0xF8, 0x5B, 0x1F, 0x83, 0x3A, 0xA0,
  0x40, 0x29, 0x20, 0x3A, 0x09, 0x58, 0x1D, 0xFD, 0x50, 0x8A, 0x04, 0x40, 0x3A, 0x09, 0x58, 0x2C,
  0xFD, 0x12, 0x81, 0x50, 0x7A, 0x04, 0x28, 0x13, 0xE2, 0xA8, 0x5C, 0x33, 0x3B, 0xEA, 0xF0, 0xE0,
  // "Ž" (U+017D)
  0x28, 0x11, 0xE8, 0x20, 0xA0, 0xD6, 0x84, 0x4F, 0xAC, 0xE2, 0x70, 0x9A, 0x06, 0x77, 0x30, 0xCF,
  0x90, 0xC2, 0x85, 0xDD, 0x21, 0x11, 0xCA, 0x06, 0x20, 0xD0, 0x83, 0x05, 0xA0, 0xC3, 0x0A, 0x04,
  0x20, 0x10, 0xEA, 0x03, 0x70, 0x9A, 0x09, 0x70, 0x3A, 0x0E, 0x01, 0x70, 0xCA, 0x05, 0x70, 0x6A,
  0x0B, 0x70, 0x10, 0xEA, 0x02, 0x70, 0xAA, 0x07, 0x38, 0x31, 0xB2, 0x04, 0xA0, 0xD4, 0x83, 0x4F,
  0x20, 0xDA, 0x87, 0x51, 0x11, 0x2C, 0xF2, 0x3F, 0xB0, 0x10,
  // "ž" (U+017E)
  0x18, 0x11, 0xE8, 0x20, 0xA0, 0xD3, 0x84, 0x4F, 0xAC, 0xE2, 0x40, 0x9A, 0x06, 0x75, 0xF8, 0x5B,
  0x1F, 0x83, 0x3A, 0xA0, 0x40, 0x29, 0x20, 0x3A, 0x09, 0x58, 0x1D, 0xFD, 0x50, 0x8A, 0x04, 0x40,
  0x3A, 0x09, 0x58, 0x2C, 0xFD, 0x12, 0x81, 0x50, 0x7A, 0x04, 0x28, 0x13, 0xE2, 0xA8, 0x5C, 0x33,
  0x3B, 0xEA, 0xF0, 0xE0,
  // "ſ" (U+017F)
  0x28, 0x51, 0x9E, 0xFE, 0xB1, 0x28, 0x5A, 0xFC, 0x4E, 0xF6, 0x2A, 0x82, 0x80, 0x66, 0x20, 0x2A,
  0x08, 0x50, 0x3A, 0x08, 0x50, 0x3A, 0x08, 0x50, 0x3A, 0x08, 0x50, 0x3A, 0x08, 0x50, 0x3A, 0x08,
  0x50, 0x3A, 0x08, 0x50, 0x3A, 0x08, 0x50, 0x3A, 0x08, 0x40, 0x20, 0x9A, 0x81, 0xC3, 0x12, 0x0D,
  0xD0, 0xA2,
  // "Ω" (U+03A9)
  0x38, 0x63, 0x9D, 0xEF, 0xDB, 0x65, 0x06, 0xA8, 0x6A, 0x43, 0x6E, 0xFC, 0x12, 0x03, 0xA0, 0xC4,
  0x03, 0xA0, 0xB2, 0x09, 0xA0, 0x65, 0x0D, 0xA8, 0x12, 0x0C, 0xA0, 0x45, 0x0B, 0xA8, 0x15, 0x0C,
  0xA0, 0x45, 0x0C, 0xA8, 0x15, 0x09, 0xA0, 0x65, 0x0E, 0xA8, 0x42, 0x02, 0xEF, 0xC4, 0x04, 0xA0,
  0x93, 0x89, 0x03, 0xDF, 0xB4, 0x08, 0xEF, 0x92, 0x01, 0x08, 0x28, 0x93, 0x4B, 0x91, 0xF6, 0x20,
  0x27, 0x2F, 0x32, 0x82, 0x6A, 0x1E, 0x38, 0x1A, 0xB2, 0xA0, 0xFE, 0x83, 0xA2, 0xFE, 0xEA, 0x0A,
  0x01, 0xD0, 0xA0, 0x2D, 0x09,
  // "μ" (U+03BC)
  0x05, 0xA0, 0x62, 0x09, 0xA8, 0x12, 0x05, 0xA0, 0x62, 0x09, 0xA8, 0x12, 0x05, 0xA0, 0x62, 0x09,
  0xA8, 0x12, 0x05, 0xA0, 0x62, 0x09, 0xA8, 0x12, 0x05, 0xA0, 0x62, 0x09, 0xA8, 0x12, 0x05, 0xA0,
  0x62, 0x09, 0xA8, 0x12, 0x05, 0xA0, 0x62, 0x0A, 0xA8, 0x12, 0x05, 0xA0, 0x92, 0x0D, 0xA8, 0x12,
  0x06, 0xA8, 0x2E, 0x7A, 0xBA, 0x89, 0x48, 0x17, 0xE7, 0xEE, 0x80, 0x8E, 0xF7, 0x79, 0x72, 0x81,
  0x8F, 0x47, 0x18, 0x26, 0xFE, 0x67, 0x82, 0x1C, 0xE5, 0x70,
  // "π" (U+03C0)
  0x10, 0x30, 0xCF, 0x98, 0x18, 0x0E, 0xFA, 0x8A, 0x08, 0x4E, 0x38, 0xD2, 0x25, 0xF3, 0x21, 0x24,
  0x09, 0xB2, 0x81, 0x5F, 0x15, 0x0A, 0x0B, 0x20, 0x79, 0x60, 0xC0, 0xA2, 0x09, 0x96, 0x0E, 0x09,
  0x20, 0xB0, 0xE5, 0x81, 0x4F, 0x82, 0x0B, 0x94, 0x82, 0x5D, 0xF5, 0x28, 0x7A, 0xF5, 0x20, 0x1F,
  0xE9, 0x38, 0x23, 0xDE, 0x91,
  // "–" (U+2013)
  0x01, 0xFA, 0x01, 0x18, 0x05, 0x21,
  // "—" (U+2014)
  0x01, 0xFF, 0xC0, 0x11, 0x80, 0x96, 0x21,
  // "€" (U+20AC)
  0x38, 0x42, 0xAE, 0xFD, 0x83, 0x86, 0x2E, 0xF5, 0x3E, 0xF8, 0x28, 0x1C, 0xF9, 0x28, 0x3A, 0xF9,
  0x02, 0xA0, 0x52, 0x83, 0x58, 0x10, 0x5A, 0x03, 0x50, 0x7E, 0x06, 0x20, 0x10, 0x9A, 0x82, 0x32,
  0x21, 0x20, 0x7D, 0x0B, 0x30, 0x10, 0x7A, 0x81, 0x52, 0x14, 0x02, 0xA0, 0x67, 0x81, 0xBF, 0xB4,
  0x03, 0x28, 0x62, 0xEF, 0x93, 0x3B, 0x83, 0x84, 0x19, 0xDF, 0xE9, 0x10,
  // "₿" (U+20BF)
  0x38, 0x28, 0x78, 0x73, 0x06, 0xD0, 0xD0, 0x53, 0x09, 0xA0, 0x40, 0x5A, 0x07, 0x20, 0x5A, 0x83,
  0x20, 0xAF, 0xD2, 0x05, 0xA8, 0x12, 0x09, 0xA2, 0x05, 0xA8, 0x32, 0x0A, 0xFE, 0x20, 0x5A, 0x83,
  0x23, 0xEF, 0x62, 0x05, 0xD0, 0x83, 0x05, 0xA8, 0x34, 0x3B, 0xFA, 0x20, 0x5A, 0x81, 0x20, 0x4A,
  0x81, 0x40, 0x5A, 0x81, 0x20, 0x2A, 0x81, 0x70, 0x5A, 0x81, 0x20, 0x3A, 0x81, 0x50, 0x9A, 0x85,
  0x43, 0xBF, 0xD0, 0x6D, 0x81, 0xE9, 0x14, 0x82, 0x87, 0x87, 0x68, 0x24, 0x34, 0x33,
  // "‘" (U+2018)
  0x00, 0x52, 0x1C, 0xA1, 0x9B, 0x00, 0xEE, 0x50, 0xEF, 0xE0, 0x6E, 0x90,
  // "’" (U+2019)
  0x09, 0xE6, 0x0D, 0xFE, 0x04, 0xEE, 0x00, 0xBA, 0x1A, 0xC1, 0x15, 0x00,
  // "‚" (U+201A)
  0x09, 0xE6, 0x0D, 0xFE, 0x04, 0xEE, 0x00, 0xB9, 0x1A, 0xC1, 0x15, 0x00,
  // "‛" (U+201B)
  0x6E, 0x90, 0xEF, 0xE0, 0xEE, 0x50, 0x9B, 0x00, 0x1C, 0xA1, 0x00, 0x52,
  // "“" (U+201C)
  0x00, 0x52, 0x00, 0x61, 0xCA, 0x12, 0xD8, 0x9B, 0x00, 0xD7, 0x0E, 0xE5, 0x2F, 0xD2, 0xEF, 0xE2,
  0xFF, 0xA6, 0xE9, 0x09, 0xE6,
  // "”" (U+201D)
  0x09, 0xE6, 0x0C, 0xE3, 0x0D, 0xFE, 0x1F, 0xFB, 0x04, 0xEE, 0x07, 0xFB, 0x00, 0xBA, 0x00, 0xE6,
  0x1A, 0xC1, 0x2C, 0xA0, 0x15, 0x00, 0x34, 0x00,
  // "„" (U+201E)
  0x09, 0xE6, 0x0C, 0xE3, 0x0D, 0xFE, 0x1F, 0xFB, 0x04, 0xEE, 0x07, 0xFB, 0x00, 0xB9, 0x00, 0xE6,
  0x1A, 0xC1, 0x3C, 0xA0, 0x15, 0x00, 0x33, 0x00,
  // "‟" (U+201F)
  0x6E, 0x90, 0x9E, 0x6E, 0xFE, 0x2F, 0xFA, 0xEE, 0x52, 0xFD, 0x29, 0xB0, 0x0D, 0x70, 0x1C, 0xA1,
  0x2D, 0x80, 0x05, 0x20, 0x06,
  // "†" (U+2020)
  0x38, 0x1B, 0xF5, 0x58, 0x19, 0xF3, 0x50, 0x69, 0x38, 0x71, 0x31, 0x4D, 0x02, 0x45, 0xA0, 0xEC,
  0x86, 0x49, 0x78, 0xE5, 0x8A, 0x38, 0x1A, 0xF4, 0x58, 0x1E, 0xF8, 0x58, 0x1B, 0xF6, 0x58, 0x19,
  0xF3, 0x58, 0x17, 0xF1, 0x50, 0x69, 0x60, 0x40, 0xE6, 0x04, 0x0D, 0x60, 0x30, 0xC6, 0x02, 0x0B,
  0x30,
  // "‡" (U+2021)
  0x38, 0x1B, 0xF5, 0x58, 0x17, 0xF1, 0x28, 0x72, 0x42, 0x4D, 0x13, 0x55, 0xF8, 0x63, 0x85, 0x7E,
  0x46, 0x83, 0x81, 0xBF, 0x55, 0x81, 0xAF, 0x45, 0x02, 0x0B, 0x60, 0x20, 0xB6, 0x81, 0x9F, 0x35,
  0x81, 0xCF, 0x62, 0x87, 0x25, 0x36, 0xE2, 0x46, 0x5F, 0x86, 0x37, 0x56, 0xD3, 0x68, 0x38, 0x17,
  0xF1, 0x58, 0x1A, 0xF5, 0x20,
  // "•" (U+2022)
  0x2C, 0xFD, 0x30, 0xBF, 0xFF, 0xE0, 0xEF, 0xFF, 0xF2, 0xEF, 0xFF, 0xF2, 0xBF, 0xFF, 0xE0, 0x2C,
  0xFD, 0x40,
  // "…" (U+2026)
  0x5D, 0xA0, 0x00, 0xBC, 0x40, 0x05, 0xD9, 0x0A, 0xFF, 0x20, 0x3F, 0xFA, 0x00, 0xBF, 0xF1, 0x6E,
  0xC0, 0x00, 0xCE, 0x50, 0x06, 0xEB, 0x00,
  // "‰" (U+2030)
  0x18, 0x32, 0xBF, 0xE8, 0x40, 0xB0, 0xA7, 0x58, 0x4C, 0xF5, 0x8F, 0x72, 0x81, 0x2F, 0x37, 0x48,
  0x52, 0xFC, 0x01, 0xFD, 0x20, 0xA0, 0xB7, 0x58, 0x15, 0xFA, 0x2A, 0x18, 0x12, 0xF3, 0x75, 0x81,
  0x5F, 0xA2, 0xA1, 0x09, 0x0C, 0x76, 0x89, 0x53, 0xFB, 0x01, 0xFE, 0x1F, 0x45, 0xDE, 0xC4, 0x28,
  0x33, 0xCE, 0xD7, 0x28, 0xA7, 0xDF, 0x26, 0xF8, 0x9C, 0x3F, 0xC3, 0xDF, 0x10, 0xEE, 0x4A, 0xF5,
  0x03, 0xDA, 0x8A, 0x0B, 0x2F, 0x59, 0xF6, 0x07, 0xF7, 0x5F, 0xA0, 0x3F, 0xB3, 0x8A, 0x21, 0x10,
  0x8D, 0x0B, 0xF4, 0x05, 0xF9, 0x7F, 0x80, 0x1F, 0xE5, 0x8A, 0x01, 0xE6, 0x0B, 0xF4, 0x06, 0xF9,
  0x7F, 0x80, 0x1F, 0xE5, 0x07, 0x0D, 0x28, 0x94, 0x9F, 0x50, 0x7F, 0x74, 0xFA, 0x03, 0xFB, 0x50,
  0xE0, 0x62, 0x89, 0x43, 0xFC, 0x3D, 0xF1, 0x0D, 0xE3, 0x9F, 0x54, 0x07, 0x0E, 0x48, 0x35, 0xDF,
  0xD4, 0x28, 0x33, 0xCF, 0xE7, 0x10,
  // "‹" (U+2039)
  0x00, 0x8D, 0x06, 0xF6, 0x5F, 0xD0, 0xCF, 0x70, 0x5F, 0xD0, 0x06, 0xF6, 0x00, 0x8D,
  // "›" (U+203A)
  0x8C, 0x00, 0x01, 0xEB, 0x00, 0x08, 0xFA, 0x00, 0x2F, 0xF2, 0x08, 0xFA, 0x01, 0xEB, 0x00, 0x8C,
  0x10, 0x00,
  // "⁄" (U+2044)
  0x68, 0x12, 0xF3, 0x60, 0xA0, 0xB6, 0x81, 0x2F, 0x36, 0x0A, 0x0B, 0x68, 0x12, 0xF3, 0x60, 0x90,
  0xB6, 0x81, 0x2F, 0x46, 0x09, 0x0B, 0x68, 0x12, 0xF4, 0x60, 0x90, 0xC6, 0x81, 0x2F, 0x46, 0x09,
  0x0C, 0x68, 0x11, 0xF4, 0x60,
  // "™" (U+2122)
  0x5A, 0xAB, 0x99, 0x7C, 0x40, 0x00, 0xBA, 0x26, 0x16, 0xA0, 0x70, 0xEB, 0x00, 0x4E, 0x60, 0x00,
  0x6A, 0x00, 0x09, 0xE1, 0x08, 0xA6, 0x00, 0x06, 0xA0, 0x00, 0x99, 0x71, 0x7A, 0x60, 0x00, 0x6A,
  0x00, 0x09, 0x3D, 0x62, 0xA6, 0x00, 0x06, 0xB0, 0x00, 0x90, 0xCA, 0x0A, 0x60, 0x02, 0xAB, 0x50,
  0x7A, 0x25, 0x43, 0xB9, 0x20,
  // "⅒" (U+2152)
  0x20, 0x01, 0x77, 0x38, 0x17, 0xF9, 0x58, 0x12, 0xF3, 0x71, 0x82, 0xCB, 0xF9, 0x50, 0xA0, 0xB7,
  0x28, 0x24, 0x2F, 0x94, 0x81, 0x2F, 0x37, 0x38, 0x12, 0xF9, 0x40, 0xA0, 0xB7, 0x48, 0x12, 0xF9,
  0x38, 0x42, 0xF3, 0x01, 0x17, 0x18, 0x12, 0xF9, 0x38, 0x92, 0x9B, 0x07, 0xF9, 0x02, 0xAD, 0xC3,
  0x28, 0x12, 0xFA, 0x28, 0xC0, 0x2F, 0x4C, 0xBF, 0x90, 0xDC, 0x0A, 0xE0, 0xAD, 0xDD, 0xC2, 0x9B,
  0x04, 0x2F, 0x93, 0xF9, 0x06, 0xF5, 0x58, 0x12, 0xF4, 0x28, 0x90, 0x2F, 0x95, 0xF8, 0x05, 0xF7,
  0x50, 0x90, 0xC3, 0x89, 0x02, 0xF9, 0x5F, 0x80, 0x5F, 0x74, 0x81, 0x2F, 0x43, 0x89, 0x02, 0xF9,
  0x3F, 0x90, 0x6F, 0x54, 0x09, 0x0C, 0x48, 0x72, 0xFA, 0x0D, 0xD0, 0xAE, 0x48, 0x11, 0xF4, 0x38,
  0x90, 0xAD, 0xDD, 0xC4, 0xAD, 0xB3, 0x10,
  // "ﬁ" (U+FB01)
  0x38, 0x13, 0xAD, 0xA8, 0x1E, 0xB3, 0x40, 0x3A, 0x81, 0x72, 0x8A, 0x0C, 0x48, 0x1B, 0xFD, 0x38,
  0x1D, 0xD4, 0x48, 0x1E, 0xFB, 0x71, 0x09, 0xFB, 0x82, 0x20, 0x12, 0xA8, 0x3C, 0x22, 0x2A, 0xA0,
  0x23, 0xA0, 0xB3, 0x09, 0xA0, 0x23, 0xA0, 0xB3, 0x09, 0xA0, 0x23, 0xA0, 0xB3, 0x09, 0xA0, 0x23,
  0xA0, 0xB3, 0x09, 0xA0, 0x23, 0xA0, 0xB3, 0x09, 0xA0, 0x23, 0xA0, 0xB3, 0x09, 0xA8, 0x22, 0x01,
  0x6A, 0x83, 0xE4, 0x13, 0xDA, 0x81, 0x81, 0xAD, 0x09, 0xD0, 0x90,
  // "ﬂ" (U+FB02)
  0x38, 0x13, 0xAD, 0xD0, 0x23, 0x03, 0xA8, 0x17, 0x28, 0xB0, 0x23, 0x81, 0xBF, 0xD3, 0x0D, 0xA0,
  0x23, 0x81, 0xEF, 0xB3, 0x09, 0xA8, 0x12, 0x09, 0xE1, 0x09, 0xA8, 0x22, 0x01, 0x2A, 0x83, 0xC2,
  0x20, 0x9A, 0x02, 0x3A, 0x0B, 0x30, 0x9A, 0x02, 0x3A, 0x0B, 0x30, 0x9A, 0x02, 0x3A, 0x0B, 0x30,
  0x9A, 0x02, 0x3A, 0x0B, 0x30, 0x9A, 0x02, 0x3A, 0x0B, 0x30, 0x9A, 0x02, 0x3A, 0x0B, 0x30, 0x9A,
  0x82, 0x20, 0x16, 0xA8, 0x3E, 0x40, 0x3D, 0xA8, 0x18, 0x1A, 0xD0, 0x50, 0xEC, 0x09,
};

const Font& font_NotoSerif_Bold_18() {
  static SmoothFont font(font_NotoSerif_Bold_18_data);
  return font;
}

}  // namespace roo_display
