#include "15.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSerif-Bold (Noto Serif Bold)
// Generated on Wed Nov 19 19:11:38 CET 2025
static const uint8_t font_NotoSerif_Bold_15_data[] PROGMEM = {
  
  // Header
  0x01, 0x02, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x06, 0x56,
  0xFD, 0xFD, 0x13, 0x0F, 0x0B, 0xFD, 0x05, 0x01, 0x14, 0x05, 0x05, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x41, 0x01, 0x04, 0x0A, 0x06, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x41, 0x07, 0x06, 0x0A, 0x08, 0x00, 0x14, // """ (U+0022)
  0x00, 0x23, 0x40, 0x01, 0x07, 0x0A, 0x08, 0x00, 0x20, // "#" (U+0023)
  0x00, 0x24, 0x00, 0x00, 0x07, 0x0B, 0x08, 0x00, 0x48, // "$" (U+0024)
  0x00, 0x25, 0x40, 0x01, 0x0C, 0x0A, 0x0E, 0x00, 0x75, // "%" (U+0025)
  0x00, 0x26, 0x00, 0x01, 0x0B, 0x0A, 0x0C, 0x00, 0xB6, // "&" (U+0026)
  0x00, 0x27, 0x41, 0x07, 0x03, 0x0A, 0x04, 0x00, 0xEF, // "'" (U+0027)
  0x00, 0x28, 0x00, 0xFF, 0x05, 0x0C, 0x06, 0x00, 0xF5, // "(" (U+0028)
  0x00, 0x29, 0x00, 0xFF, 0x05, 0x0C, 0x06, 0x01, 0x1E, // ")" (U+0029)
  0x00, 0x2A, 0x40, 0x06, 0x06, 0x0B, 0x08, 0x01, 0x47, // "*" (U+002A)
  0x00, 0x2B, 0x01, 0x03, 0x07, 0x08, 0x08, 0x01, 0x5C, // "+" (U+002B)
  0x00, 0x2C, 0x40, 0xFE, 0x03, 0x02, 0x04, 0x01, 0x6E, // "," (U+002C)
  0x00, 0x2D, 0x40, 0x04, 0x04, 0x04, 0x05, 0x01, 0x78, // "-" (U+002D)
  0x00, 0x2E, 0x41, 0x01, 0x03, 0x03, 0x04, 0x01, 0x7B, // "." (U+002E)
  0x00, 0x2F, 0x40, 0xFF, 0x04, 0x0B, 0x04, 0x01, 0x80, // "/" (U+002F)
  0x00, 0x30, 0x40, 0x01, 0x07, 0x0A, 0x08, 0x01, 0xA1, // "0" (U+0030)
  0x00, 0x31, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x01, 0xC9, // "1" (U+0031)
  0x00, 0x32, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x01, 0xED, // "2" (U+0032)
  0x00, 0x33, 0x40, 0x01, 0x07, 0x0A, 0x08, 0x02, 0x14, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x01, 0x08, 0x0A, 0x08, 0x02, 0x3C, // "4" (U+0034)
  0x00, 0x35, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x02, 0x65, // "5" (U+0035)
  0x00, 0x36, 0x40, 0x01, 0x07, 0x0A, 0x08, 0x02, 0x8B, // "6" (U+0036)
  0x00, 0x37, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x02, 0xB3, // "7" (U+0037)
  0x00, 0x38, 0x40, 0x01, 0x07, 0x0A, 0x08, 0x02, 0xD3, // "8" (U+0038)
  0x00, 0x39, 0x40, 0x01, 0x07, 0x0A, 0x08, 0x02, 0xFB, // "9" (U+0039)
  0x00, 0x3A, 0x01, 0x01, 0x03, 0x08, 0x05, 0x03, 0x23, // ":" (U+003A)
  0x00, 0x3B, 0x00, 0xFF, 0x03, 0x08, 0x05, 0x03, 0x2E, // ";" (U+003B)
  0x00, 0x3C, 0x01, 0x02, 0x07, 0x09, 0x08, 0x03, 0x41, // "<" (U+003C)
  0x00, 0x3D, 0x01, 0x04, 0x07, 0x07, 0x08, 0x03, 0x5A, // "=" (U+003D)
  0x00, 0x3E, 0x01, 0x02, 0x07, 0x09, 0x08, 0x03, 0x61, // ">" (U+003E)
  0x00, 0x3F, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x03, 0x78, // "?" (U+003F)
  0x00, 0x40, 0x00, 0xFF, 0x0D, 0x0A, 0x0E, 0x03, 0x9A, // "@" (U+0040)
  0x00, 0x41, 0x00, 0x01, 0x0B, 0x0A, 0x0B, 0x03, 0xEC, // "A" (U+0041)
  0x00, 0x42, 0x40, 0x01, 0x09, 0x0A, 0x0A, 0x04, 0x1D, // "B" (U+0042)
  0x00, 0x43, 0x00, 0x01, 0x09, 0x0A, 0x0A, 0x04, 0x4F, // "C" (U+0043)
  0x00, 0x44, 0x40, 0x01, 0x0A, 0x0A, 0x0C, 0x04, 0x78, // "D" (U+0044)
  0x00, 0x45, 0x00, 0x01, 0x09, 0x0A, 0x0A, 0x04, 0xAF, // "E" (U+0045)
  0x00, 0x46, 0x00, 0x01, 0x08, 0x0A, 0x09, 0x04, 0xDE, // "F" (U+0046)
  0x00, 0x47, 0x00, 0x01, 0x0B, 0x0A, 0x0C, 0x05, 0x04, // "G" (U+0047)
  0x00, 0x48, 0x00, 0x01, 0x0B, 0x0A, 0x0C, 0x05, 0x37, // "H" (U+0048)
  0x00, 0x49, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x05, 0x72, // "I" (U+0049)
  0x00, 0x4A, 0xFF, 0xFE, 0x05, 0x0A, 0x06, 0x05, 0x90, // "J" (U+004A)
  0x00, 0x4B, 0x00, 0x01, 0x0A, 0x0A, 0x0B, 0x05, 0xB9, // "K" (U+004B)
  0x00, 0x4C, 0x00, 0x01, 0x09, 0x0A, 0x0A, 0x05, 0xEE, // "L" (U+004C)
  0x00, 0x4D, 0x40, 0x01, 0x0D, 0x0A, 0x0E, 0x06, 0x17, // "M" (U+004D)
  0x00, 0x4E, 0x40, 0x01, 0x0B, 0x0A, 0x0C, 0x06, 0x5D, // "N" (U+004E)
  0x00, 0x4F, 0x00, 0x01, 0x0A, 0x0A, 0x0C, 0x06, 0x99, // "O" (U+004F)
  0x00, 0x50, 0x00, 0x01, 0x09, 0x0A, 0x0A, 0x06, 0xCF, // "P" (U+0050)
  0x00, 0x51, 0x00, 0xFE, 0x0A, 0x0A, 0x0C, 0x06, 0xFB, // "Q" (U+0051)
  0x00, 0x52, 0x40, 0x01, 0x0A, 0x0A, 0x0B, 0x07, 0x3B, // "R" (U+0052)
  0x00, 0x53, 0x40, 0x01, 0x07, 0x0A, 0x09, 0x07, 0x72, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x09, 0x0A, 0x0A, 0x07, 0x9A, // "T" (U+0054)
  0x00, 0x55, 0x00, 0x01, 0x0A, 0x0A, 0x0B, 0x07, 0xC1, // "U" (U+0055)
  0x00, 0x56, 0x00, 0x01, 0x0A, 0x0A, 0x0A, 0x07, 0xF1, // "V" (U+0056)
  0x00, 0x57, 0x00, 0x01, 0x0F, 0x0A, 0x10, 0x08, 0x20, // "W" (U+0057)
  0x00, 0x58, 0x00, 0x01, 0x0A, 0x0A, 0x0B, 0x08, 0x6B, // "X" (U+0058)
  0x00, 0x59, 0x00, 0x01, 0x0A, 0x0A, 0x0A, 0x08, 0x9B, // "Y" (U+0059)
  0x00, 0x5A, 0x00, 0x01, 0x09, 0x0A, 0x0A, 0x08, 0xC2, // "Z" (U+005A)
  0x00, 0x5B, 0x41, 0xFF, 0x05, 0x0B, 0x06, 0x08, 0xEB, // "[" (U+005B)
  0x00, 0x5C, 0x00, 0xFF, 0x04, 0x0B, 0x04, 0x09, 0x0C, // "\" (U+005C)
  0x00, 0x5D, 0x40, 0xFF, 0x04, 0x0B, 0x06, 0x09, 0x2C, // "]" (U+005D)
  0x00, 0x5E, 0x00, 0x05, 0x07, 0x0B, 0x08, 0x09, 0x4D, // "^" (U+005E)
  0x00, 0x5F, 0xBF, 0xFF, 0x06, 0xFF, 0x07, 0x09, 0x67, // "_" (U+005F)
  0x00, 0x60, 0x40, 0x0A, 0x04, 0x0C, 0x05, 0x09, 0x6B, // "`" (U+0060)
  0x00, 0x61, 0x40, 0x01, 0x08, 0x08, 0x09, 0x09, 0x73, // "a" (U+0061)
  0x00, 0x62, 0x00, 0x01, 0x08, 0x0B, 0x0A, 0x09, 0x97, // "b" (U+0062)
  0x00, 0x63, 0x00, 0x01, 0x07, 0x08, 0x08, 0x09, 0xC8, // "c" (U+0063)
  0x00, 0x64, 0x00, 0x01, 0x09, 0x0B, 0x0A, 0x09, 0xE6, // "d" (U+0064)
  0x00, 0x65, 0x40, 0x01, 0x07, 0x08, 0x09, 0x0A, 0x1B, // "e" (U+0065)
  0x00, 0x66, 0x00, 0x01, 0x07, 0x0B, 0x06, 0x0A, 0x3B, // "f" (U+0066)
  0x00, 0x67, 0x00, 0xFE, 0x08, 0x09, 0x08, 0x0A, 0x60, // "g" (U+0067)
  0x00, 0x68, 0x40, 0x01, 0x09, 0x0B, 0x0A, 0x0A, 0x94, // "h" (U+0068)
  0x00, 0x69, 0x40, 0x01, 0x04, 0x0B, 0x05, 0x0A, 0xCB, // "i" (U+0069)
  0x00, 0x6A, 0xBF, 0xFE, 0x03, 0x0B, 0x05, 0x0A, 0xE7, // "j" (U+006A)
  0x00, 0x6B, 0x00, 0x01, 0x09, 0x0B, 0x0A, 0x0B, 0x0A, // "k" (U+006B)
  0x00, 0x6C, 0x40, 0x01, 0x04, 0x0B, 0x05, 0x0B, 0x3A, // "l" (U+006C)
  0x00, 0x6D, 0x40, 0x01, 0x0E, 0x08, 0x0F, 0x0B, 0x56, // "m" (U+006D)
  0x00, 0x6E, 0x40, 0x01, 0x09, 0x08, 0x0A, 0x0B, 0x92, // "n" (U+006E)
  0x00, 0x6F, 0x40, 0x01, 0x08, 0x08, 0x09, 0x0B, 0xBA, // "o" (U+006F)
  0x00, 0x70, 0x40, 0xFE, 0x08, 0x08, 0x0A, 0x0B, 0xDE, // "p" (U+0070)
  0x00, 0x71, 0x00, 0xFE, 0x09, 0x08, 0x0A, 0x0C, 0x10, // "q" (U+0071)
  0x00, 0x72, 0x00, 0x01, 0x07, 0x08, 0x08, 0x0C, 0x44, // "r" (U+0072)
  0x00, 0x73, 0x40, 0x01, 0x06, 0x08, 0x07, 0x0C, 0x5F, // "s" (U+0073)
  0x00, 0x74, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x0C, 0x7B, // "t" (U+0074)
  0x00, 0x75, 0x40, 0x01, 0x09, 0x08, 0x0A, 0x0C, 0x99, // "u" (U+0075)
  0x00, 0x76, 0x00, 0x01, 0x09, 0x08, 0x09, 0x0C, 0xC1, // "v" (U+0076)
  0x00, 0x77, 0x40, 0x01, 0x0C, 0x08, 0x0D, 0x0C, 0xE4, // "w" (U+0077)
  0x00, 0x78, 0x00, 0x01, 0x09, 0x08, 0x0A, 0x0D, 0x18, // "x" (U+0078)
  0x00, 0x79, 0x00, 0xFE, 0x08, 0x08, 0x09, 0x0D, 0x3C, // "y" (U+0079)
  0x00, 0x7A, 0x00, 0x01, 0x07, 0x08, 0x08, 0x0D, 0x67, // "z" (U+007A)
  0x00, 0x7B, 0x00, 0xFF, 0x06, 0x0B, 0x07, 0x0D, 0x85, // "{" (U+007B)
  0x00, 0x7C, 0x43, 0xFE, 0x04, 0x0B, 0x08, 0x0D, 0xAF, // "|" (U+007C)
  0x00, 0x7D, 0x00, 0xFF, 0x06, 0x0B, 0x07, 0x0D, 0xBD, // "}" (U+007D)
  0x00, 0x7E, 0x40, 0x05, 0x07, 0x07, 0x08, 0x0D, 0xE6, // "~" (U+007E)
  0x00, 0xA1, 0x41, 0xFF, 0x04, 0x08, 0x06, 0x0D, 0xF2, // "¡" (U+00A1)
  0x00, 0xA2, 0x40, 0x01, 0x07, 0x0A, 0x08, 0x0E, 0x06, // "¢" (U+00A2)
  0x00, 0xA3, 0x40, 0x01, 0x07, 0x0A, 0x08, 0x0E, 0x2E, // "£" (U+00A3)
  0x00, 0xA4, 0x41, 0x03, 0x07, 0x09, 0x08, 0x0E, 0x56, // "¤" (U+00A4)
  0x00, 0xA5, 0x00, 0x01, 0x08, 0x0A, 0x08, 0x0E, 0x6F, // "¥" (U+00A5)
  0x00, 0xA6, 0x43, 0xFE, 0x04, 0x0B, 0x08, 0x0E, 0x9A, // "¦" (U+00A6)
  0x00, 0xA7, 0x41, 0xFF, 0x07, 0x0B, 0x08, 0x0E, 0xA8, // "§" (U+00A7)
  0x00, 0xA8, 0x42, 0x0A, 0x06, 0x0B, 0x09, 0x0E, 0xD6, // "¨" (U+00A8)
  0x00, 0xA9, 0x00, 0x01, 0x0B, 0x0B, 0x0D, 0x0E, 0xDB, // "©" (U+00A9)
  0x00, 0xAA, 0x40, 0x07, 0x05, 0x0A, 0x06, 0x0F, 0x1C, // "ª" (U+00AA)
  0x00, 0xAB, 0x41, 0x02, 0x07, 0x07, 0x08, 0x0F, 0x28, // "«" (U+00AB)
  0x00, 0xAC, 0x01, 0x03, 0x07, 0x06, 0x08, 0x0F, 0x3D, // "¬" (U+00AC)
  0x00, 0xAE, 0x40, 0x01, 0x0B, 0x0B, 0x0D, 0x0F, 0x48, // "®" (U+00AE)
  0x00, 0xAF, 0xBF, 0x0C, 0x06, 0x0C, 0x07, 0x0F, 0x8A, // "¯" (U+00AF)
  0x00, 0xB0, 0x40, 0x07, 0x05, 0x0A, 0x06, 0x0F, 0x8E, // "°" (U+00B0)
  0x00, 0xB1, 0x01, 0x01, 0x07, 0x08, 0x08, 0x0F, 0x9A, // "±" (U+00B1)
  0x00, 0xB2, 0x40, 0x06, 0x05, 0x0D, 0x06, 0x0F, 0xB0, // "²" (U+00B2)
  0x00, 0xB3, 0x40, 0x07, 0x05, 0x0D, 0x06, 0x0F, 0xC8, // "³" (U+00B3)
  0x00, 0xB4, 0x40, 0x0A, 0x04, 0x0C, 0x05, 0x0F, 0xDD, // "´" (U+00B4)
  0x00, 0xB5, 0x01, 0xFE, 0x09, 0x08, 0x0A, 0x0F, 0xE5, // "µ" (U+00B5)
  0x00, 0xB6, 0x00, 0xFF, 0x08, 0x0B, 0x09, 0x10, 0x15, // "¶" (U+00B6)
  0x00, 0xB7, 0x41, 0x05, 0x03, 0x07, 0x04, 0x10, 0x4B, // "·" (U+00B7)
  0x00, 0xB8, 0x40, 0xFD, 0x04, 0x00, 0x05, 0x10, 0x50, // "¸" (U+00B8)
  0x00, 0xB9, 0x40, 0x07, 0x05, 0x0D, 0x06, 0x10, 0x5A, // "¹" (U+00B9)
  0x00, 0xBA, 0x40, 0x07, 0x05, 0x0A, 0x07, 0x10, 0x6F, // "º" (U+00BA)
  0x00, 0xBB, 0x41, 0x02, 0x07, 0x07, 0x08, 0x10, 0x7B, // "»" (U+00BB)
  0x00, 0xBC, 0xFF, 0x01, 0x0C, 0x0C, 0x0D, 0x10, 0x90, // "¼" (U+00BC)
  0x00, 0xBD, 0xFF, 0x00, 0x0C, 0x0C, 0x0D, 0x10, 0xD2, // "½" (U+00BD)
  0x00, 0xBE, 0x00, 0x01, 0x0C, 0x0C, 0x0D, 0x11, 0x18, // "¾" (U+00BE)
  0x00, 0xBF, 0x00, 0xFF, 0x07, 0x08, 0x08, 0x11, 0x5C, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x0B, 0x0E, 0x0B, 0x11, 0x7E, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x0B, 0x0E, 0x0B, 0x11, 0xBA, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x01, 0x0B, 0x0E, 0x0B, 0x11, 0xF6, // "Â" (U+00C2)
  0x00, 0xC3, 0x00, 0x01, 0x0B, 0x0D, 0x0B, 0x12, 0x34, // "Ã" (U+00C3)
  0x00, 0xC4, 0x00, 0x01, 0x0B, 0x0D, 0x0B, 0x12, 0x6F, // "Ä" (U+00C4)
  0x00, 0xC5, 0x00, 0x01, 0x0B, 0x0D, 0x0B, 0x12, 0xA9, // "Å" (U+00C5)
  0x00, 0xC6, 0x00, 0x01, 0x0E, 0x0A, 0x0F, 0x12, 0xE6, // "Æ" (U+00C6)
  0x00, 0xC7, 0x00, 0xFD, 0x09, 0x0A, 0x0A, 0x13, 0x27, // "Ç" (U+00C7)
  0x00, 0xC8, 0x00, 0x01, 0x09, 0x0E, 0x0A, 0x13, 0x5D, // "È" (U+00C8)
  0x00, 0xC9, 0x00, 0x01, 0x09, 0x0E, 0x0A, 0x13, 0x97, // "É" (U+00C9)
  0x00, 0xCA, 0x00, 0x01, 0x09, 0x0E, 0x0A, 0x13, 0xD0, // "Ê" (U+00CA)
  0x00, 0xCB, 0x00, 0x01, 0x09, 0x0D, 0x0A, 0x14, 0x0B, // "Ë" (U+00CB)
  0x00, 0xCC, 0x00, 0x01, 0x05, 0x0E, 0x06, 0x14, 0x43, // "Ì" (U+00CC)
  0x00, 0xCD, 0x00, 0x01, 0x05, 0x0E, 0x06, 0x14, 0x6A, // "Í" (U+00CD)
  0x00, 0xCE, 0x00, 0x01, 0x05, 0x0E, 0x06, 0x14, 0x92, // "Î" (U+00CE)
  0x00, 0xCF, 0x00, 0x01, 0x05, 0x0D, 0x06, 0x14, 0xBB, // "Ï" (U+00CF)
  0x00, 0xD0, 0x40, 0x01, 0x0A, 0x0A, 0x0C, 0x14, 0xE1, // "Ð" (U+00D0)
  0x00, 0xD1, 0x00, 0x01, 0x0B, 0x0D, 0x0C, 0x15, 0x18, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x00, 0x01, 0x0A, 0x0E, 0x0C, 0x15, 0x62, // "Ò" (U+00D2)
  0x00, 0xD3, 0x00, 0x01, 0x0A, 0x0E, 0x0C, 0x15, 0xA3, // "Ó" (U+00D3)
  0x00, 0xD4, 0x00, 0x01, 0x0A, 0x0E, 0x0C, 0x15, 0xE3, // "Ô" (U+00D4)
  0x00, 0xD5, 0x00, 0x01, 0x0A, 0x0D, 0x0C, 0x16, 0x25, // "Õ" (U+00D5)
  0x00, 0xD6, 0x00, 0x01, 0x0A, 0x0D, 0x0C, 0x16, 0x65, // "Ö" (U+00D6)
  0x00, 0xD7, 0x41, 0x03, 0x06, 0x09, 0x08, 0x16, 0xA4, // "×" (U+00D7)
  0x00, 0xD8, 0x40, 0x00, 0x0A, 0x0B, 0x0C, 0x16, 0xB9, // "Ø" (U+00D8)
  0x00, 0xD9, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x16, 0xFB, // "Ù" (U+00D9)
  0x00, 0xDA, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x17, 0x36, // "Ú" (U+00DA)
  0x00, 0xDB, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x17, 0x70, // "Û" (U+00DB)
  0x00, 0xDC, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x17, 0xAC, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x01, 0x0A, 0x0E, 0x0A, 0x17, 0xE5, // "Ý" (U+00DD)
  0x00, 0xDE, 0x00, 0x01, 0x09, 0x0A, 0x0A, 0x18, 0x16, // "Þ" (U+00DE)
  0x00, 0xDF, 0x40, 0x01, 0x09, 0x0B, 0x0B, 0x18, 0x46, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x01, 0x08, 0x0C, 0x09, 0x18, 0x7D, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x08, 0x0C, 0x09, 0x18, 0xAE, // "á" (U+00E1)
  0x00, 0xE2, 0x00, 0x01, 0x08, 0x0C, 0x09, 0x18, 0xDF, // "â" (U+00E2)
  0x00, 0xE3, 0x00, 0x01, 0x08, 0x0B, 0x09, 0x19, 0x12, // "ã" (U+00E3)
  0x00, 0xE4, 0x00, 0x01, 0x08, 0x0B, 0x09, 0x19, 0x43, // "ä" (U+00E4)
  0x00, 0xE5, 0x00, 0x01, 0x08, 0x0C, 0x09, 0x19, 0x73, // "å" (U+00E5)
  0x00, 0xE6, 0x40, 0x01, 0x0C, 0x08, 0x0D, 0x19, 0xA5, // "æ" (U+00E6)
  0x00, 0xE7, 0x00, 0xFD, 0x07, 0x08, 0x08, 0x19, 0xD9, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x01, 0x07, 0x0C, 0x09, 0x1A, 0x03, // "è" (U+00E8)
  0x00, 0xE9, 0x00, 0x01, 0x07, 0x0C, 0x09, 0x1A, 0x2D, // "é" (U+00E9)
  0x00, 0xEA, 0x00, 0x01, 0x07, 0x0C, 0x09, 0x1A, 0x57, // "ê" (U+00EA)
  0x00, 0xEB, 0x00, 0x01, 0x07, 0x0B, 0x09, 0x1A, 0x83, // "ë" (U+00EB)
  0x00, 0xEC, 0xFF, 0x01, 0x04, 0x0C, 0x05, 0x1A, 0xAC, // "ì" (U+00EC)
  0x00, 0xED, 0x00, 0x01, 0x05, 0x0C, 0x05, 0x1A, 0xCC, // "í" (U+00ED)
  0x00, 0xEE, 0xFF, 0x01, 0x04, 0x0C, 0x05, 0x1A, 0xED, // "î" (U+00EE)
  0x00, 0xEF, 0x40, 0x01, 0x04, 0x0B, 0x05, 0x1B, 0x0F, // "ï" (U+00EF)
  0x00, 0xF0, 0x40, 0x01, 0x08, 0x0C, 0x09, 0x1B, 0x2B, // "ð" (U+00F0)
  0x00, 0xF1, 0x40, 0x01, 0x09, 0x0B, 0x0A, 0x1B, 0x61, // "ñ" (U+00F1)
  0x00, 0xF2, 0x00, 0x01, 0x08, 0x0C, 0x09, 0x1B, 0x98, // "ò" (U+00F2)
  0x00, 0xF3, 0x00, 0x01, 0x08, 0x0C, 0x09, 0x1B, 0xC8, // "ó" (U+00F3)
  0x00, 0xF4, 0x00, 0x01, 0x08, 0x0C, 0x09, 0x1B, 0xF8, // "ô" (U+00F4)
  0x00, 0xF5, 0x00, 0x01, 0x08, 0x0B, 0x09, 0x1C, 0x2A, // "õ" (U+00F5)
  0x00, 0xF6, 0x00, 0x01, 0x08, 0x0B, 0x09, 0x1C, 0x5A, // "ö" (U+00F6)
  0x00, 0xF7, 0x01, 0x03, 0x07, 0x09, 0x08, 0x1C, 0x89, // "÷" (U+00F7)
  0x00, 0xF8, 0x40, 0x00, 0x08, 0x09, 0x09, 0x1C, 0x98, // "ø" (U+00F8)
  0x00, 0xF9, 0x00, 0x01, 0x09, 0x0C, 0x0A, 0x1C, 0xC5, // "ù" (U+00F9)
  0x00, 0xFA, 0x00, 0x01, 0x09, 0x0C, 0x0A, 0x1C, 0xFF, // "ú" (U+00FA)
  0x00, 0xFB, 0x00, 0x01, 0x09, 0x0C, 0x0A, 0x1D, 0x38, // "û" (U+00FB)
  0x00, 0xFC, 0x40, 0x01, 0x09, 0x0B, 0x0A, 0x1D, 0x73, // "ü" (U+00FC)
  0x00, 0xFD, 0x00, 0xFE, 0x08, 0x0C, 0x09, 0x1D, 0xAA, // "ý" (U+00FD)
  0x00, 0xFE, 0x00, 0xFE, 0x08, 0x0B, 0x0A, 0x1D, 0xDF, // "þ" (U+00FE)
  0x00, 0xFF, 0x00, 0xFE, 0x08, 0x0B, 0x09, 0x1E, 0x1B, // "ÿ" (U+00FF)
  0x01, 0x00, 0x00, 0x01, 0x0B, 0x0C, 0x0B, 0x1E, 0x4F, // "Ā" (U+0100)
  0x01, 0x01, 0x00, 0x01, 0x08, 0x0A, 0x09, 0x1E, 0x85, // "ā" (U+0101)
  0x01, 0x02, 0x00, 0x01, 0x0B, 0x0E, 0x0B, 0x1E, 0xB1, // "Ă" (U+0102)
  0x01, 0x03, 0x00, 0x01, 0x08, 0x0C, 0x09, 0x1E, 0xF0, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0xFD, 0x0B, 0x0A, 0x0B, 0x1F, 0x25, // "Ą" (U+0104)
  0x01, 0x05, 0x00, 0xFD, 0x08, 0x08, 0x09, 0x1F, 0x63, // "ą" (U+0105)
  0x01, 0x06, 0x00, 0x01, 0x09, 0x0E, 0x0A, 0x1F, 0x96, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x1F, 0xC9, // "ć" (U+0107)
  0x01, 0x08, 0x00, 0x01, 0x09, 0x0E, 0x0A, 0x1F, 0xF0, // "Ĉ" (U+0108)
  0x01, 0x09, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x20, 0x25, // "ĉ" (U+0109)
  0x01, 0x0A, 0x00, 0x01, 0x09, 0x0D, 0x0A, 0x20, 0x4E, // "Ċ" (U+010A)
  0x01, 0x0B, 0x00, 0x01, 0x07, 0x0B, 0x08, 0x20, 0x7F, // "ċ" (U+010B)
  0x01, 0x0C, 0x00, 0x01, 0x09, 0x0E, 0x0A, 0x20, 0xA4, // "Č" (U+010C)
  0x01, 0x0D, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x20, 0xDB, // "č" (U+010D)
  0x01, 0x0E, 0x00, 0x01, 0x0A, 0x0E, 0x0C, 0x21, 0x06, // "Ď" (U+010E)
  0x01, 0x0F, 0x00, 0x01, 0x0B, 0x0B, 0x0A, 0x21, 0x4D, // "ď" (U+010F)
  0x01, 0x10, 0x40, 0x01, 0x0A, 0x0A, 0x0C, 0x21, 0x87, // "Đ" (U+0110)
  0x01, 0x11, 0x40, 0x01, 0x09, 0x0B, 0x0A, 0x21, 0xBE, // "đ" (U+0111)
  0x01, 0x12, 0x00, 0x01, 0x09, 0x0C, 0x0A, 0x21, 0xF5, // "Ē" (U+0112)
  0x01, 0x13, 0x00, 0x01, 0x07, 0x0A, 0x09, 0x22, 0x29, // "ē" (U+0113)
  0x01, 0x14, 0x00, 0x01, 0x09, 0x0E, 0x0A, 0x22, 0x4E, // "Ĕ" (U+0114)
  0x01, 0x15, 0x00, 0x01, 0x07, 0x0C, 0x09, 0x22, 0x8B, // "ĕ" (U+0115)
  0x01, 0x16, 0x00, 0x01, 0x09, 0x0D, 0x0A, 0x22, 0xB9, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x01, 0x07, 0x0B, 0x09, 0x22, 0xEF, // "ė" (U+0117)
  0x01, 0x18, 0x00, 0xFD, 0x09, 0x0A, 0x0A, 0x23, 0x17, // "Ę" (U+0118)
  0x01, 0x19, 0x00, 0xFE, 0x07, 0x08, 0x09, 0x23, 0x52, // "ę" (U+0119)
  0x01, 0x1A, 0x00, 0x01, 0x09, 0x0E, 0x0A, 0x23, 0x7D, // "Ě" (U+011A)
  0x01, 0x1B, 0x00, 0x01, 0x07, 0x0C, 0x09, 0x23, 0xB9, // "ě" (U+011B)
  0x01, 0x1C, 0x00, 0x01, 0x0B, 0x0E, 0x0C, 0x23, 0xE7, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x00, 0xFE, 0x08, 0x0C, 0x08, 0x24, 0x27, // "ĝ" (U+011D)
  0x01, 0x1E, 0x00, 0x01, 0x0B, 0x0E, 0x0C, 0x24, 0x67, // "Ğ" (U+011E)
  0x01, 0x1F, 0x00, 0xFE, 0x08, 0x0C, 0x08, 0x24, 0xA8, // "ğ" (U+011F)
  0x01, 0x20, 0x00, 0x01, 0x0B, 0x0D, 0x0C, 0x24, 0xEA, // "Ġ" (U+0120)
  0x01, 0x21, 0x00, 0xFE, 0x08, 0x0B, 0x08, 0x25, 0x25, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0xFE, 0x0B, 0x0A, 0x0C, 0x25, 0x60, // "Ģ" (U+0122)
  0x01, 0x23, 0x00, 0xFE, 0x08, 0x0B, 0x08, 0x25, 0x9C, // "ģ" (U+0123)
  0x01, 0x24, 0x00, 0x01, 0x0B, 0x0E, 0x0C, 0x25, 0xD6, // "Ĥ" (U+0124)
  0x01, 0x25, 0x00, 0x01, 0x09, 0x0F, 0x0A, 0x26, 0x1E, // "ĥ" (U+0125)
  0x01, 0x26, 0x00, 0x01, 0x0B, 0x0A, 0x0C, 0x26, 0x61, // "Ħ" (U+0126)
  0x01, 0x27, 0x40, 0x01, 0x09, 0x0B, 0x0A, 0x26, 0x9C, // "ħ" (U+0127)
  0x01, 0x28, 0xFF, 0x01, 0x05, 0x0D, 0x06, 0x26, 0xD3, // "Ĩ" (U+0128)
  0x01, 0x29, 0xFF, 0x01, 0x05, 0x0B, 0x05, 0x26, 0xFA, // "ĩ" (U+0129)
  0x01, 0x2A, 0x00, 0x01, 0x05, 0x0C, 0x06, 0x27, 0x1A, // "Ī" (U+012A)
  0x01, 0x2B, 0x40, 0x01, 0x04, 0x0A, 0x05, 0x27, 0x3C, // "ī" (U+012B)
  0x01, 0x2C, 0x00, 0x01, 0x05, 0x0E, 0x06, 0x27, 0x55, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x00, 0x01, 0x05, 0x0C, 0x05, 0x27, 0x7E, // "ĭ" (U+012D)
  0x01, 0x2E, 0x00, 0xFD, 0x05, 0x0A, 0x06, 0x27, 0xA0, // "Į" (U+012E)
  0x01, 0x2F, 0x40, 0xFD, 0x04, 0x0B, 0x05, 0x27, 0xC8, // "į" (U+012F)
  0x01, 0x30, 0x00, 0x01, 0x05, 0x0D, 0x06, 0x27, 0xEE, // "İ" (U+0130)
  0x01, 0x31, 0x40, 0x01, 0x04, 0x08, 0x05, 0x28, 0x13, // "ı" (U+0131)
  0x01, 0x32, 0x00, 0xFE, 0x0B, 0x0A, 0x0C, 0x28, 0x27, // "Ĳ" (U+0132)
  0x01, 0x33, 0x40, 0xFE, 0x08, 0x0B, 0x0A, 0x28, 0x6D, // "ĳ" (U+0133)
  0x01, 0x34, 0xFF, 0xFE, 0x05, 0x0E, 0x06, 0x28, 0xAC, // "Ĵ" (U+0134)
  0x01, 0x35, 0xBF, 0xFE, 0x04, 0x0C, 0x05, 0x28, 0xE0, // "ĵ" (U+0135)
  0x01, 0x36, 0x00, 0xFE, 0x0A, 0x0A, 0x0B, 0x29, 0x0D, // "Ķ" (U+0136)
  0x01, 0x37, 0x00, 0xFE, 0x09, 0x0B, 0x0A, 0x29, 0x4B, // "ķ" (U+0137)
  0x01, 0x38, 0x00, 0x01, 0x09, 0x08, 0x0A, 0x29, 0x84, // "ĸ" (U+0138)
  0x01, 0x39, 0x00, 0x01, 0x09, 0x0E, 0x0A, 0x29, 0xAB, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x00, 0x01, 0x05, 0x0F, 0x05, 0x29, 0xDE, // "ĺ" (U+013A)
  0x01, 0x3B, 0x00, 0xFE, 0x09, 0x0A, 0x0A, 0x2A, 0x08, // "Ļ" (U+013B)
  0x01, 0x3C, 0x40, 0xFE, 0x04, 0x0B, 0x05, 0x2A, 0x3A, // "ļ" (U+013C)
  0x01, 0x3D, 0x00, 0x01, 0x09, 0x0A, 0x0A, 0x2A, 0x5D, // "Ľ" (U+013D)
  0x01, 0x3E, 0x00, 0x01, 0x06, 0x0B, 0x05, 0x2A, 0x8B, // "ľ" (U+013E)
  0x01, 0x3F, 0x00, 0x01, 0x09, 0x0A, 0x0A, 0x2A, 0xAE, // "Ŀ" (U+013F)
  0x01, 0x40, 0x00, 0x01, 0x07, 0x0B, 0x07, 0x2A, 0xDC, // "ŀ" (U+0140)
  0x01, 0x41, 0x00, 0x01, 0x09, 0x0A, 0x0A, 0x2A, 0xFF, // "Ł" (U+0141)
  0x01, 0x42, 0x40, 0x01, 0x04, 0x0B, 0x05, 0x2B, 0x2C, // "ł" (U+0142)
  0x01, 0x43, 0x00, 0x01, 0x0B, 0x0E, 0x0C, 0x2B, 0x48, // "Ń" (U+0143)
  0x01, 0x44, 0x00, 0x01, 0x09, 0x0C, 0x0A, 0x2B, 0x93, // "ń" (U+0144)
  0x01, 0x45, 0x00, 0xFE, 0x0B, 0x0A, 0x0C, 0x2B, 0xCB, // "Ņ" (U+0145)
  0x01, 0x46, 0x40, 0xFE, 0x09, 0x08, 0x0A, 0x2C, 0x13, // "ņ" (U+0146)
  0x01, 0x47, 0x00, 0x01, 0x0B, 0x0E, 0x0C, 0x2C, 0x4A, // "Ň" (U+0147)
  0x01, 0x48, 0x40, 0x01, 0x09, 0x0C, 0x0A, 0x2C, 0x97, // "ň" (U+0148)
  0x01, 0x49, 0x00, 0x01, 0x0C, 0x0A, 0x0D, 0x2C, 0xD3, // "ŉ" (U+0149)
  0x01, 0x4A, 0x00, 0xFE, 0x0B, 0x0A, 0x0C, 0x2D, 0x0F, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x40, 0xFE, 0x08, 0x08, 0x0A, 0x2D, 0x59, // "ŋ" (U+014B)
  0x01, 0x4C, 0x00, 0x01, 0x0A, 0x0C, 0x0C, 0x2D, 0x8B, // "Ō" (U+014C)
  0x01, 0x4D, 0x00, 0x01, 0x08, 0x0A, 0x09, 0x2D, 0xC6, // "ō" (U+014D)
  0x01, 0x4E, 0x00, 0x01, 0x0A, 0x0E, 0x0C, 0x2D, 0xF1, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x00, 0x01, 0x08, 0x0C, 0x09, 0x2E, 0x35, // "ŏ" (U+014F)
  0x01, 0x50, 0x00, 0x01, 0x0A, 0x0E, 0x0C, 0x2E, 0x69, // "Ő" (U+0150)
  0x01, 0x51, 0x00, 0x01, 0x08, 0x0C, 0x09, 0x2E, 0xAD, // "ő" (U+0151)
  0x01, 0x52, 0x00, 0x01, 0x0E, 0x0A, 0x0F, 0x2E, 0xE1, // "Œ" (U+0152)
  0x01, 0x53, 0x40, 0x01, 0x0D, 0x08, 0x0E, 0x2F, 0x26, // "œ" (U+0153)
  0x01, 0x54, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x2F, 0x5E, // "Ŕ" (U+0154)
  0x01, 0x55, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x2F, 0xA1, // "ŕ" (U+0155)
  0x01, 0x56, 0x00, 0xFE, 0x0A, 0x0A, 0x0B, 0x2F, 0xC6, // "Ŗ" (U+0156)
  0x01, 0x57, 0x00, 0xFE, 0x07, 0x08, 0x08, 0x30, 0x07, // "ŗ" (U+0157)
  0x01, 0x58, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x30, 0x2A, // "Ř" (U+0158)
  0x01, 0x59, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x30, 0x70, // "ř" (U+0159)
  0x01, 0x5A, 0x00, 0x01, 0x07, 0x0E, 0x09, 0x30, 0x99, // "Ś" (U+015A)
  0x01, 0x5B, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x30, 0xCE, // "ś" (U+015B)
  0x01, 0x5C, 0x00, 0x01, 0x07, 0x0E, 0x09, 0x30, 0xF7, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x40, 0x01, 0x06, 0x0C, 0x07, 0x31, 0x2E, // "ŝ" (U+015D)
  0x01, 0x5E, 0x40, 0xFD, 0x07, 0x0A, 0x09, 0x31, 0x58, // "Ş" (U+015E)
  0x01, 0x5F, 0x40, 0xFD, 0x06, 0x08, 0x07, 0x31, 0x90, // "ş" (U+015F)
  0x01, 0x60, 0x40, 0x01, 0x07, 0x0E, 0x09, 0x31, 0xBA, // "Š" (U+0160)
  0x01, 0x61, 0x40, 0x01, 0x06, 0x0C, 0x07, 0x31, 0xF2, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFD, 0x09, 0x0A, 0x0A, 0x32, 0x1C, // "Ţ" (U+0162)
  0x01, 0x63, 0x00, 0xFD, 0x05, 0x0A, 0x06, 0x32, 0x50, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x09, 0x0E, 0x0A, 0x32, 0x79, // "Ť" (U+0164)
  0x01, 0x65, 0x00, 0x01, 0x06, 0x0B, 0x06, 0x32, 0xAE, // "ť" (U+0165)
  0x01, 0x66, 0x00, 0x01, 0x09, 0x0A, 0x0A, 0x32, 0xD2, // "Ŧ" (U+0166)
  0x01, 0x67, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x32, 0xFC, // "ŧ" (U+0167)
  0x01, 0x68, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x33, 0x1A, // "Ũ" (U+0168)
  0x01, 0x69, 0x40, 0x01, 0x09, 0x0B, 0x0A, 0x33, 0x54, // "ũ" (U+0169)
  0x01, 0x6A, 0x00, 0x01, 0x0A, 0x0C, 0x0B, 0x33, 0x8B, // "Ū" (U+016A)
  0x01, 0x6B, 0x40, 0x01, 0x09, 0x0A, 0x0A, 0x33, 0xC0, // "ū" (U+016B)
  0x01, 0x6C, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x33, 0xF2, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x40, 0x01, 0x09, 0x0C, 0x0A, 0x34, 0x30, // "ŭ" (U+016D)
  0x01, 0x6E, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x34, 0x6C, // "Ů" (U+016E)
  0x01, 0x6F, 0x00, 0x01, 0x09, 0x0C, 0x0A, 0x34, 0xA7, // "ů" (U+016F)
  0x01, 0x70, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x34, 0xE1, // "Ű" (U+0170)
  0x01, 0x71, 0x40, 0x01, 0x09, 0x0C, 0x0A, 0x35, 0x1F, // "ű" (U+0171)
  0x01, 0x72, 0x00, 0xFD, 0x0A, 0x0A, 0x0B, 0x35, 0x5B, // "Ų" (U+0172)
  0x01, 0x73, 0x00, 0xFD, 0x09, 0x08, 0x0A, 0x35, 0x97, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x0F, 0x0E, 0x10, 0x35, 0xD2, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x0C, 0x0C, 0x0D, 0x36, 0x2A, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x01, 0x0A, 0x0E, 0x0A, 0x36, 0x6D, // "Ŷ" (U+0176)
  0x01, 0x77, 0x00, 0xFE, 0x08, 0x0C, 0x09, 0x36, 0xA0, // "ŷ" (U+0177)
  0x01, 0x78, 0x00, 0x01, 0x0A, 0x0D, 0x0A, 0x36, 0xD7, // "Ÿ" (U+0178)
  0x01, 0x79, 0x00, 0x01, 0x09, 0x0E, 0x0A, 0x37, 0x07, // "Ź" (U+0179)
  0x01, 0x7A, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x37, 0x3A, // "ź" (U+017A)
  0x01, 0x7B, 0x00, 0x01, 0x09, 0x0D, 0x0A, 0x37, 0x62, // "Ż" (U+017B)
  0x01, 0x7C, 0x00, 0x01, 0x07, 0x0B, 0x08, 0x37, 0x92, // "ż" (U+017C)
  0x01, 0x7D, 0x00, 0x01, 0x09, 0x0E, 0x0A, 0x37, 0xB8, // "Ž" (U+017D)
  0x01, 0x7E, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x37, 0xEE, // "ž" (U+017E)
  0x01, 0x7F, 0x00, 0x01, 0x06, 0x0B, 0x06, 0x38, 0x1A, // "ſ" (U+017F)
  0x03, 0xA9, 0x00, 0x01, 0x0B, 0x0A, 0x0C, 0x38, 0x3E, // "Ω" (U+03A9)
  0x03, 0xBC, 0x01, 0xFE, 0x09, 0x08, 0x0A, 0x38, 0x78, // "μ" (U+03BC)
  0x03, 0xC0, 0x40, 0x01, 0x09, 0x08, 0x0A, 0x38, 0xA8, // "π" (U+03C0)
  0x20, 0x13, 0xFF, 0x04, 0x07, 0x04, 0x08, 0x38, 0xD0, // "–" (U+2013)
  0x20, 0x14, 0xFF, 0x04, 0x0F, 0x04, 0x0F, 0x38, 0xD4, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x38, 0xD9, // "€" (U+20AC)
  0x20, 0xBF, 0x40, 0xFF, 0x07, 0x0B, 0x08, 0x39, 0x00, // "₿" (U+20BF)
  0x20, 0x18, 0x40, 0x07, 0x03, 0x0B, 0x04, 0x39, 0x34, // "‘" (U+2018)
  0x20, 0x19, 0x40, 0x06, 0x03, 0x0A, 0x04, 0x39, 0x3E, // "’" (U+2019)
  0x20, 0x1A, 0x40, 0xFE, 0x03, 0x02, 0x04, 0x39, 0x48, // "‚" (U+201A)
  0x20, 0x1B, 0x40, 0x06, 0x03, 0x0A, 0x04, 0x39, 0x52, // "‛" (U+201B)
  0x20, 0x1C, 0x40, 0x07, 0x06, 0x0B, 0x07, 0x39, 0x5C, // "“" (U+201C)
  0x20, 0x1D, 0x40, 0x06, 0x06, 0x0A, 0x07, 0x39, 0x6E, // "”" (U+201D)
  0x20, 0x1E, 0x40, 0xFE, 0x06, 0x02, 0x07, 0x39, 0x80, // "„" (U+201E)
  0x20, 0x1F, 0x40, 0x06, 0x06, 0x0A, 0x07, 0x39, 0x92, // "‟" (U+201F)
  0x20, 0x20, 0x00, 0xFF, 0x06, 0x0B, 0x07, 0x39, 0xA4, // "†" (U+2020)
  0x20, 0x21, 0x00, 0xFF, 0x06, 0x0B, 0x07, 0x39, 0xC8, // "‡" (U+2021)
  0x20, 0x22, 0x00, 0x04, 0x05, 0x08, 0x06, 0x39, 0xF3, // "•" (U+2022)
  0x20, 0x26, 0x41, 0x01, 0x0C, 0x03, 0x0E, 0x3A, 0x00, // "…" (U+2026)
  0x20, 0x30, 0x00, 0x01, 0x13, 0x0A, 0x14, 0x3A, 0x12, // "‰" (U+2030)
  0x20, 0x39, 0x41, 0x02, 0x04, 0x07, 0x05, 0x3A, 0x6D, // "‹" (U+2039)
  0x20, 0x3A, 0x41, 0x02, 0x04, 0x07, 0x05, 0x3A, 0x79, // "›" (U+203A)
  0x20, 0x44, 0xFD, 0x01, 0x03, 0x0A, 0x01, 0x3A, 0x85, // "⁄" (U+2044)
  0x21, 0x22, 0x40, 0x06, 0x0B, 0x0B, 0x0D, 0x3A, 0x9F, // "™" (U+2122)
  0x21, 0x52, 0x00, 0x01, 0x11, 0x0C, 0x12, 0x3A, 0xC3, // "⅒" (U+2152)
  0xFB, 0x01, 0x00, 0x01, 0x0A, 0x0B, 0x0B, 0x3B, 0x1C, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0x00, 0x01, 0x0A, 0x0B, 0x0B, 0x3B, 0x53, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x01, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0x67, 0x01, // "g (U+0022 U+0067)
  0x00, 0x22, 0x00, 0xC0, 0x01, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x01, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x01, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x01, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x01, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x01, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xC6, 0x02, // "Æ (U+0022 U+00C6)
  0x00, 0x22, 0x01, 0x00, 0x01, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x02, 0x01, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x04, 0x01, // "Ą (U+0022 U+0104)
  0x00, 0x26, 0x00, 0x56, 0x01, // &V (U+0026 U+0056)
  0x00, 0x26, 0x00, 0x57, 0x01, // &W (U+0026 U+0057)
  0x00, 0x26, 0x01, 0x74, 0x01, // &Ŵ (U+0026 U+0174)
  0x00, 0x27, 0x00, 0x41, 0x01, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0x67, 0x01, // 'g (U+0027 U+0067)
  0x00, 0x27, 0x00, 0xC0, 0x01, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x01, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x01, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x01, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x01, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x01, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xC6, 0x02, // 'Æ (U+0027 U+00C6)
  0x00, 0x27, 0x01, 0x00, 0x01, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x02, 0x01, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x04, 0x01, // 'Ą (U+0027 U+0104)
  0x00, 0x2A, 0x00, 0x2C, 0x02, // *, (U+002A U+002C)
  0x00, 0x2A, 0x00, 0x2E, 0x02, // *. (U+002A U+002E)
  0x00, 0x2A, 0x00, 0x41, 0x01, // *A (U+002A U+0041)
  0x00, 0x2A, 0x00, 0xC0, 0x01, // *À (U+002A U+00C0)
  0x00, 0x2A, 0x00, 0xC1, 0x01, // *Á (U+002A U+00C1)
  0x00, 0x2A, 0x00, 0xC2, 0x01, // *Â (U+002A U+00C2)
  0x00, 0x2A, 0x00, 0xC3, 0x01, // *Ã (U+002A U+00C3)
  0x00, 0x2A, 0x00, 0xC4, 0x01, // *Ä (U+002A U+00C4)
  0x00, 0x2A, 0x00, 0xC5, 0x01, // *Å (U+002A U+00C5)
  0x00, 0x2A, 0x00, 0xC6, 0x01, // *Æ (U+002A U+00C6)
  0x00, 0x2A, 0x01, 0x00, 0x01, // *Ā (U+002A U+0100)
  0x00, 0x2A, 0x01, 0x02, 0x01, // *Ă (U+002A U+0102)
  0x00, 0x2A, 0x01, 0x04, 0x01, // *Ą (U+002A U+0104)
  0x00, 0x2A, 0x20, 0x1A, 0x02, // *‚ (U+002A U+201A)
  0x00, 0x2A, 0x20, 0x1E, 0x02, // *„ (U+002A U+201E)
  0x00, 0x2A, 0x20, 0x26, 0x02, // *… (U+002A U+2026)
  0x00, 0x2C, 0x00, 0x3F, 0x01, // ,? (U+002C U+003F)
  0x00, 0x2C, 0x00, 0x54, 0x01, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x56, 0x02, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x01, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x01, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0x76, 0x01, // ,v (U+002C U+0076)
  0x00, 0x2C, 0x00, 0x77, 0x01, // ,w (U+002C U+0077)
  0x00, 0x2C, 0x00, 0x79, 0x01, // ,y (U+002C U+0079)
  0x00, 0x2C, 0x00, 0xDD, 0x01, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x00, 0xFD, 0x01, // ,ý (U+002C U+00FD)
  0x00, 0x2C, 0x00, 0xFF, 0x01, // ,ÿ (U+002C U+00FF)
  0x00, 0x2C, 0x01, 0x62, 0x01, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x01, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x01, // ,Ŧ (U+002C U+0166)
  0x00, 0x2C, 0x01, 0x74, 0x01, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x75, 0x01, // ,ŵ (U+002C U+0175)
  0x00, 0x2C, 0x01, 0x76, 0x01, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x77, 0x01, // ,ŷ (U+002C U+0177)
  0x00, 0x2C, 0x01, 0x78, 0x01, // ,Ÿ (U+002C U+0178)
  0x00, 0x2E, 0x00, 0x3F, 0x01, // .? (U+002E U+003F)
  0x00, 0x2E, 0x00, 0x54, 0x01, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x56, 0x02, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x01, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x01, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0x76, 0x01, // .v (U+002E U+0076)
  0x00, 0x2E, 0x00, 0x77, 0x01, // .w (U+002E U+0077)
  0x00, 0x2E, 0x00, 0x79, 0x01, // .y (U+002E U+0079)
  0x00, 0x2E, 0x00, 0xDD, 0x01, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x00, 0xFD, 0x01, // .ý (U+002E U+00FD)
  0x00, 0x2E, 0x00, 0xFF, 0x01, // .ÿ (U+002E U+00FF)
  0x00, 0x2E, 0x01, 0x62, 0x01, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x01, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x01, // .Ŧ (U+002E U+0166)
  0x00, 0x2E, 0x01, 0x74, 0x01, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x75, 0x01, // .ŵ (U+002E U+0175)
  0x00, 0x2E, 0x01, 0x76, 0x01, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x77, 0x01, // .ŷ (U+002E U+0177)
  0x00, 0x2E, 0x01, 0x78, 0x01, // .Ÿ (U+002E U+0178)
  0x00, 0x41, 0x00, 0x22, 0x01, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x01, // A' (U+0041 U+0027)
  0x00, 0x41, 0x00, 0x2A, 0x01, // A* (U+0041 U+002A)
  0x00, 0x41, 0x00, 0x3F, 0x01, // A? (U+0041 U+003F)
  0x00, 0x41, 0x00, 0x54, 0x01, // AT (U+0041 U+0054)
  0x00, 0x41, 0x00, 0x56, 0x01, // AV (U+0041 U+0056)
  0x00, 0x41, 0x00, 0x57, 0x01, // AW (U+0041 U+0057)
  0x00, 0x41, 0x00, 0x59, 0x01, // AY (U+0041 U+0059)
  0x00, 0x41, 0x00, 0x76, 0x01, // Av (U+0041 U+0076)
  0x00, 0x41, 0x00, 0x79, 0x01, // Ay (U+0041 U+0079)
  0x00, 0x41, 0x00, 0xDD, 0x01, // AÝ (U+0041 U+00DD)
  0x00, 0x41, 0x00, 0xFD, 0x01, // Aý (U+0041 U+00FD)
  0x00, 0x41, 0x00, 0xFF, 0x01, // Aÿ (U+0041 U+00FF)
  0x00, 0x41, 0x01, 0x62, 0x01, // AŢ (U+0041 U+0162)
  0x00, 0x41, 0x01, 0x64, 0x01, // AŤ (U+0041 U+0164)
  0x00, 0x41, 0x01, 0x66, 0x01, // AŦ (U+0041 U+0166)
  0x00, 0x41, 0x01, 0x74, 0x01, // AŴ (U+0041 U+0174)
  0x00, 0x41, 0x01, 0x76, 0x01, // AŶ (U+0041 U+0176)
  0x00, 0x41, 0x01, 0x77, 0x01, // Aŷ (U+0041 U+0177)
  0x00, 0x41, 0x01, 0x78, 0x01, // AŸ (U+0041 U+0178)
  0x00, 0x41, 0x20, 0x18, 0x01, // A‘ (U+0041 U+2018)
  0x00, 0x41, 0x20, 0x19, 0x01, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1C, 0x01, // A“ (U+0041 U+201C)
  0x00, 0x41, 0x20, 0x1D, 0x01, // A” (U+0041 U+201D)
  0x00, 0x41, 0x21, 0x22, 0x01, // A™ (U+0041 U+2122)
  0x00, 0x42, 0x00, 0x56, 0x01, // BV (U+0042 U+0056)
  0x00, 0x42, 0x00, 0x59, 0x01, // BY (U+0042 U+0059)
  0x00, 0x42, 0x00, 0xDD, 0x01, // BÝ (U+0042 U+00DD)
  0x00, 0x42, 0x01, 0x76, 0x01, // BŶ (U+0042 U+0176)
  0x00, 0x42, 0x01, 0x78, 0x01, // BŸ (U+0042 U+0178)
  0x00, 0x44, 0x00, 0xC6, 0x01, // DÆ (U+0044 U+00C6)
  0x00, 0x46, 0x00, 0x2C, 0x02, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x02, // F. (U+0046 U+002E)
  0x00, 0x46, 0x00, 0x40, 0x01, // F@ (U+0046 U+0040)
  0x00, 0x46, 0x00, 0x41, 0x01, // FA (U+0046 U+0041)
  0x00, 0x46, 0x00, 0x61, 0x01, // Fa (U+0046 U+0061)
  0x00, 0x46, 0x00, 0x63, 0x01, // Fc (U+0046 U+0063)
  0x00, 0x46, 0x00, 0x64, 0x01, // Fd (U+0046 U+0064)
  0x00, 0x46, 0x00, 0x65, 0x01, // Fe (U+0046 U+0065)
  0x00, 0x46, 0x00, 0x67, 0x01, // Fg (U+0046 U+0067)
  0x00, 0x46, 0x00, 0x6F, 0x01, // Fo (U+0046 U+006F)
  0x00, 0x46, 0x00, 0x71, 0x01, // Fq (U+0046 U+0071)
  0x00, 0x46, 0x00, 0xC0, 0x01, // FÀ (U+0046 U+00C0)
  0x00, 0x46, 0x00, 0xC1, 0x01, // FÁ (U+0046 U+00C1)
  0x00, 0x46, 0x00, 0xC2, 0x01, // FÂ (U+0046 U+00C2)
  0x00, 0x46, 0x00, 0xC3, 0x01, // FÃ (U+0046 U+00C3)
  0x00, 0x46, 0x00, 0xC4, 0x01, // FÄ (U+0046 U+00C4)
  0x00, 0x46, 0x00, 0xC5, 0x01, // FÅ (U+0046 U+00C5)
  0x00, 0x46, 0x00, 0xC6, 0x02, // FÆ (U+0046 U+00C6)
  0x00, 0x46, 0x00, 0xE0, 0x01, // Fà (U+0046 U+00E0)
  0x00, 0x46, 0x00, 0xE1, 0x01, // Fá (U+0046 U+00E1)
  0x00, 0x46, 0x00, 0xE2, 0x01, // Fâ (U+0046 U+00E2)
  0x00, 0x46, 0x00, 0xE3, 0x01, // Fã (U+0046 U+00E3)
  0x00, 0x46, 0x00, 0xE4, 0x01, // Fä (U+0046 U+00E4)
  0x00, 0x46, 0x00, 0xE5, 0x01, // Få (U+0046 U+00E5)
  0x00, 0x46, 0x00, 0xE6, 0x01, // Fæ (U+0046 U+00E6)
  0x00, 0x46, 0x00, 0xE7, 0x01, // Fç (U+0046 U+00E7)
  0x00, 0x46, 0x00, 0xE8, 0x01, // Fè (U+0046 U+00E8)
  0x00, 0x46, 0x00, 0xE9, 0x01, // Fé (U+0046 U+00E9)
  0x00, 0x46, 0x00, 0xEA, 0x01, // Fê (U+0046 U+00EA)
  0x00, 0x46, 0x00, 0xEB, 0x01, // Fë (U+0046 U+00EB)
  0x00, 0x46, 0x00, 0xF0, 0x01, // Fð (U+0046 U+00F0)
  0x00, 0x46, 0x00, 0xF2, 0x01, // Fò (U+0046 U+00F2)
  0x00, 0x46, 0x00, 0xF3, 0x01, // Fó (U+0046 U+00F3)
  0x00, 0x46, 0x00, 0xF4, 0x01, // Fô (U+0046 U+00F4)
  0x00, 0x46, 0x00, 0xF5, 0x01, // Fõ (U+0046 U+00F5)
  0x00, 0x46, 0x00, 0xF6, 0x01, // Fö (U+0046 U+00F6)
  0x00, 0x46, 0x00, 0xF8, 0x01, // Fø (U+0046 U+00F8)
  0x00, 0x46, 0x01, 0x00, 0x01, // FĀ (U+0046 U+0100)
  0x00, 0x46, 0x01, 0x01, 0x01, // Fā (U+0046 U+0101)
  0x00, 0x46, 0x01, 0x02, 0x01, // FĂ (U+0046 U+0102)
  0x00, 0x46, 0x01, 0x03, 0x01, // Fă (U+0046 U+0103)
  0x00, 0x46, 0x01, 0x04, 0x01, // FĄ (U+0046 U+0104)
  0x00, 0x46, 0x01, 0x05, 0x01, // Fą (U+0046 U+0105)
  0x00, 0x46, 0x01, 0x07, 0x01, // Fć (U+0046 U+0107)
  0x00, 0x46, 0x01, 0x09, 0x01, // Fĉ (U+0046 U+0109)
  0x00, 0x46, 0x01, 0x0B, 0x01, // Fċ (U+0046 U+010B)
  0x00, 0x46, 0x01, 0x0D, 0x01, // Fč (U+0046 U+010D)
  0x00, 0x46, 0x01, 0x0F, 0x01, // Fď (U+0046 U+010F)
  0x00, 0x46, 0x01, 0x11, 0x01, // Fđ (U+0046 U+0111)
  0x00, 0x46, 0x01, 0x13, 0x01, // Fē (U+0046 U+0113)
  0x00, 0x46, 0x01, 0x15, 0x01, // Fĕ (U+0046 U+0115)
  0x00, 0x46, 0x01, 0x17, 0x01, // Fė (U+0046 U+0117)
  0x00, 0x46, 0x01, 0x19, 0x01, // Fę (U+0046 U+0119)
  0x00, 0x46, 0x01, 0x1B, 0x01, // Fě (U+0046 U+011B)
  0x00, 0x46, 0x01, 0x1D, 0x01, // Fĝ (U+0046 U+011D)
  0x00, 0x46, 0x01, 0x1F, 0x01, // Fğ (U+0046 U+011F)
  0x00, 0x46, 0x01, 0x21, 0x01, // Fġ (U+0046 U+0121)
  0x00, 0x46, 0x01, 0x23, 0x01, // Fģ (U+0046 U+0123)
  0x00, 0x46, 0x01, 0x4D, 0x01, // Fō (U+0046 U+014D)
  0x00, 0x46, 0x01, 0x4F, 0x01, // Fŏ (U+0046 U+014F)
  0x00, 0x46, 0x01, 0x51, 0x01, // Fő (U+0046 U+0151)
  0x00, 0x46, 0x01, 0x53, 0x01, // Fœ (U+0046 U+0153)
  0x00, 0x46, 0x20, 0x1A, 0x02, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x02, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x02, // F… (U+0046 U+2026)
  0x00, 0x4C, 0x00, 0x22, 0x01, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x01, // L' (U+004C U+0027)
  0x00, 0x4C, 0x00, 0x2A, 0x01, // L* (U+004C U+002A)
  0x00, 0x4C, 0x00, 0x3F, 0x01, // L? (U+004C U+003F)
  0x00, 0x4C, 0x00, 0x54, 0x01, // LT (U+004C U+0054)
  0x00, 0x4C, 0x00, 0x56, 0x01, // LV (U+004C U+0056)
  0x00, 0x4C, 0x00, 0x57, 0x01, // LW (U+004C U+0057)
  0x00, 0x4C, 0x00, 0x59, 0x01, // LY (U+004C U+0059)
  0x00, 0x4C, 0x00, 0xDD, 0x01, // LÝ (U+004C U+00DD)
  0x00, 0x4C, 0x01, 0x62, 0x01, // LŢ (U+004C U+0162)
  0x00, 0x4C, 0x01, 0x64, 0x01, // LŤ (U+004C U+0164)
  0x00, 0x4C, 0x01, 0x66, 0x01, // LŦ (U+004C U+0166)
  0x00, 0x4C, 0x01, 0x74, 0x01, // LŴ (U+004C U+0174)
  0x00, 0x4C, 0x01, 0x76, 0x01, // LŶ (U+004C U+0176)
  0x00, 0x4C, 0x01, 0x78, 0x01, // LŸ (U+004C U+0178)
  0x00, 0x4C, 0x20, 0x18, 0x01, // L‘ (U+004C U+2018)
  0x00, 0x4C, 0x20, 0x19, 0x01, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1C, 0x01, // L“ (U+004C U+201C)
  0x00, 0x4C, 0x20, 0x1D, 0x01, // L” (U+004C U+201D)
  0x00, 0x4C, 0x21, 0x22, 0x01, // L™ (U+004C U+2122)
  0x00, 0x4F, 0x00, 0xC6, 0x01, // OÆ (U+004F U+00C6)
  0x00, 0x50, 0x00, 0x2C, 0x02, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x02, // P. (U+0050 U+002E)
  0x00, 0x50, 0x00, 0x41, 0x01, // PA (U+0050 U+0041)
  0x00, 0x50, 0x00, 0xC0, 0x01, // PÀ (U+0050 U+00C0)
  0x00, 0x50, 0x00, 0xC1, 0x01, // PÁ (U+0050 U+00C1)
  0x00, 0x50, 0x00, 0xC2, 0x01, // PÂ (U+0050 U+00C2)
  0x00, 0x50, 0x00, 0xC3, 0x01, // PÃ (U+0050 U+00C3)
  0x00, 0x50, 0x00, 0xC4, 0x01, // PÄ (U+0050 U+00C4)
  0x00, 0x50, 0x00, 0xC5, 0x01, // PÅ (U+0050 U+00C5)
  0x00, 0x50, 0x00, 0xC6, 0x01, // PÆ (U+0050 U+00C6)
  0x00, 0x50, 0x01, 0x00, 0x01, // PĀ (U+0050 U+0100)
  0x00, 0x50, 0x01, 0x02, 0x01, // PĂ (U+0050 U+0102)
  0x00, 0x50, 0x01, 0x04, 0x01, // PĄ (U+0050 U+0104)
  0x00, 0x50, 0x20, 0x1A, 0x02, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x02, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x02, // P… (U+0050 U+2026)
  0x00, 0x51, 0x00, 0xC6, 0x01, // QÆ (U+0051 U+00C6)
  0x00, 0x54, 0x00, 0x2C, 0x01, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2E, 0x01, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0x41, 0x01, // TA (U+0054 U+0041)
  0x00, 0x54, 0x00, 0xC0, 0x01, // TÀ (U+0054 U+00C0)
  0x00, 0x54, 0x00, 0xC1, 0x01, // TÁ (U+0054 U+00C1)
  0x00, 0x54, 0x00, 0xC2, 0x01, // TÂ (U+0054 U+00C2)
  0x00, 0x54, 0x00, 0xC3, 0x01, // TÃ (U+0054 U+00C3)
  0x00, 0x54, 0x00, 0xC4, 0x01, // TÄ (U+0054 U+00C4)
  0x00, 0x54, 0x00, 0xC5, 0x01, // TÅ (U+0054 U+00C5)
  0x00, 0x54, 0x00, 0xC6, 0x01, // TÆ (U+0054 U+00C6)
  0x00, 0x54, 0x01, 0x00, 0x01, // TĀ (U+0054 U+0100)
  0x00, 0x54, 0x01, 0x02, 0x01, // TĂ (U+0054 U+0102)
  0x00, 0x54, 0x01, 0x04, 0x01, // TĄ (U+0054 U+0104)
  0x00, 0x54, 0x20, 0x1A, 0x01, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x01, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x01, // T… (U+0054 U+2026)
  0x00, 0x55, 0x00, 0xC6, 0x01, // UÆ (U+0055 U+00C6)
  0x00, 0x56, 0x00, 0x2C, 0x02, // V, (U+0056 U+002C)
  0x00, 0x56, 0x00, 0x2E, 0x02, // V. (U+0056 U+002E)
  0x00, 0x56, 0x00, 0x40, 0x01, // V@ (U+0056 U+0040)
  0x00, 0x56, 0x00, 0x41, 0x01, // VA (U+0056 U+0041)
  0x00, 0x56, 0x00, 0x61, 0x01, // Va (U+0056 U+0061)
  0x00, 0x56, 0x00, 0x63, 0x01, // Vc (U+0056 U+0063)
  0x00, 0x56, 0x00, 0x64, 0x01, // Vd (U+0056 U+0064)
  0x00, 0x56, 0x00, 0x65, 0x01, // Ve (U+0056 U+0065)
  0x00, 0x56, 0x00, 0x67, 0x01, // Vg (U+0056 U+0067)
  0x00, 0x56, 0x00, 0x6F, 0x01, // Vo (U+0056 U+006F)
  0x00, 0x56, 0x00, 0x71, 0x01, // Vq (U+0056 U+0071)
  0x00, 0x56, 0x00, 0x73, 0x01, // Vs (U+0056 U+0073)
  0x00, 0x56, 0x00, 0xC0, 0x01, // VÀ (U+0056 U+00C0)
  0x00, 0x56, 0x00, 0xC1, 0x01, // VÁ (U+0056 U+00C1)
  0x00, 0x56, 0x00, 0xC2, 0x01, // VÂ (U+0056 U+00C2)
  0x00, 0x56, 0x00, 0xC3, 0x01, // VÃ (U+0056 U+00C3)
  0x00, 0x56, 0x00, 0xC4, 0x01, // VÄ (U+0056 U+00C4)
  0x00, 0x56, 0x00, 0xC5, 0x01, // VÅ (U+0056 U+00C5)
  0x00, 0x56, 0x00, 0xC6, 0x02, // VÆ (U+0056 U+00C6)
  0x00, 0x56, 0x00, 0xE0, 0x01, // Và (U+0056 U+00E0)
  0x00, 0x56, 0x00, 0xE1, 0x01, // Vá (U+0056 U+00E1)
  0x00, 0x56, 0x00, 0xE2, 0x01, // Vâ (U+0056 U+00E2)
  0x00, 0x56, 0x00, 0xE3, 0x01, // Vã (U+0056 U+00E3)
  0x00, 0x56, 0x00, 0xE4, 0x01, // Vä (U+0056 U+00E4)
  0x00, 0x56, 0x00, 0xE5, 0x01, // Vå (U+0056 U+00E5)
  0x00, 0x56, 0x00, 0xE6, 0x01, // Væ (U+0056 U+00E6)
  0x00, 0x56, 0x00, 0xE7, 0x01, // Vç (U+0056 U+00E7)
  0x00, 0x56, 0x00, 0xE8, 0x01, // Vè (U+0056 U+00E8)
  0x00, 0x56, 0x00, 0xE9, 0x01, // Vé (U+0056 U+00E9)
  0x00, 0x56, 0x00, 0xEA, 0x01, // Vê (U+0056 U+00EA)
  0x00, 0x56, 0x00, 0xEB, 0x01, // Vë (U+0056 U+00EB)
  0x00, 0x56, 0x00, 0xF0, 0x01, // Vð (U+0056 U+00F0)
  0x00, 0x56, 0x00, 0xF2, 0x01, // Vò (U+0056 U+00F2)
  0x00, 0x56, 0x00, 0xF3, 0x01, // Vó (U+0056 U+00F3)
  0x00, 0x56, 0x00, 0xF4, 0x01, // Vô (U+0056 U+00F4)
  0x00, 0x56, 0x00, 0xF5, 0x01, // Võ (U+0056 U+00F5)
  0x00, 0x56, 0x00, 0xF6, 0x01, // Vö (U+0056 U+00F6)
  0x00, 0x56, 0x00, 0xF8, 0x01, // Vø (U+0056 U+00F8)
  0x00, 0x56, 0x01, 0x00, 0x01, // VĀ (U+0056 U+0100)
  0x00, 0x56, 0x01, 0x01, 0x01, // Vā (U+0056 U+0101)
  0x00, 0x56, 0x01, 0x02, 0x01, // VĂ (U+0056 U+0102)
  0x00, 0x56, 0x01, 0x03, 0x01, // Vă (U+0056 U+0103)
  0x00, 0x56, 0x01, 0x04, 0x01, // VĄ (U+0056 U+0104)
  0x00, 0x56, 0x01, 0x05, 0x01, // Vą (U+0056 U+0105)
  0x00, 0x56, 0x01, 0x07, 0x01, // Vć (U+0056 U+0107)
  0x00, 0x56, 0x01, 0x09, 0x01, // Vĉ (U+0056 U+0109)
  0x00, 0x56, 0x01, 0x0B, 0x01, // Vċ (U+0056 U+010B)
  0x00, 0x56, 0x01, 0x0D, 0x01, // Vč (U+0056 U+010D)
  0x00, 0x56, 0x01, 0x0F, 0x01, // Vď (U+0056 U+010F)
  0x00, 0x56, 0x01, 0x11, 0x01, // Vđ (U+0056 U+0111)
  0x00, 0x56, 0x01, 0x13, 0x01, // Vē (U+0056 U+0113)
  0x00, 0x56, 0x01, 0x15, 0x01, // Vĕ (U+0056 U+0115)
  0x00, 0x56, 0x01, 0x17, 0x01, // Vė (U+0056 U+0117)
  0x00, 0x56, 0x01, 0x19, 0x01, // Vę (U+0056 U+0119)
  0x00, 0x56, 0x01, 0x1B, 0x01, // Vě (U+0056 U+011B)
  0x00, 0x56, 0x01, 0x1D, 0x01, // Vĝ (U+0056 U+011D)
  0x00, 0x56, 0x01, 0x1F, 0x01, // Vğ (U+0056 U+011F)
  0x00, 0x56, 0x01, 0x21, 0x01, // Vġ (U+0056 U+0121)
  0x00, 0x56, 0x01, 0x23, 0x01, // Vģ (U+0056 U+0123)
  0x00, 0x56, 0x01, 0x4D, 0x01, // Vō (U+0056 U+014D)
  0x00, 0x56, 0x01, 0x4F, 0x01, // Vŏ (U+0056 U+014F)
  0x00, 0x56, 0x01, 0x51, 0x01, // Vő (U+0056 U+0151)
  0x00, 0x56, 0x01, 0x53, 0x01, // Vœ (U+0056 U+0153)
  0x00, 0x56, 0x01, 0x5B, 0x01, // Vś (U+0056 U+015B)
  0x00, 0x56, 0x01, 0x5D, 0x01, // Vŝ (U+0056 U+015D)
  0x00, 0x56, 0x01, 0x5F, 0x01, // Vş (U+0056 U+015F)
  0x00, 0x56, 0x01, 0x61, 0x01, // Vš (U+0056 U+0161)
  0x00, 0x56, 0x20, 0x1A, 0x02, // V‚ (U+0056 U+201A)
  0x00, 0x56, 0x20, 0x1E, 0x02, // V„ (U+0056 U+201E)
  0x00, 0x56, 0x20, 0x26, 0x02, // V… (U+0056 U+2026)
  0x00, 0x57, 0x00, 0x2C, 0x01, // W, (U+0057 U+002C)
  0x00, 0x57, 0x00, 0x2E, 0x01, // W. (U+0057 U+002E)
  0x00, 0x57, 0x00, 0x40, 0x01, // W@ (U+0057 U+0040)
  0x00, 0x57, 0x00, 0x41, 0x01, // WA (U+0057 U+0041)
  0x00, 0x57, 0x00, 0x61, 0x01, // Wa (U+0057 U+0061)
  0x00, 0x57, 0x00, 0x63, 0x01, // Wc (U+0057 U+0063)
  0x00, 0x57, 0x00, 0x64, 0x01, // Wd (U+0057 U+0064)
  0x00, 0x57, 0x00, 0x65, 0x01, // We (U+0057 U+0065)
  0x00, 0x57, 0x00, 0x67, 0x01, // Wg (U+0057 U+0067)
  0x00, 0x57, 0x00, 0x6F, 0x01, // Wo (U+0057 U+006F)
  0x00, 0x57, 0x00, 0x71, 0x01, // Wq (U+0057 U+0071)
  0x00, 0x57, 0x00, 0x73, 0x01, // Ws (U+0057 U+0073)
  0x00, 0x57, 0x00, 0xC0, 0x01, // WÀ (U+0057 U+00C0)
  0x00, 0x57, 0x00, 0xC1, 0x01, // WÁ (U+0057 U+00C1)
  0x00, 0x57, 0x00, 0xC2, 0x01, // WÂ (U+0057 U+00C2)
  0x00, 0x57, 0x00, 0xC3, 0x01, // WÃ (U+0057 U+00C3)
  0x00, 0x57, 0x00, 0xC4, 0x01, // WÄ (U+0057 U+00C4)
  0x00, 0x57, 0x00, 0xC5, 0x01, // WÅ (U+0057 U+00C5)
  0x00, 0x57, 0x00, 0xC6, 0x02, // WÆ (U+0057 U+00C6)
  0x00, 0x57, 0x00, 0xE0, 0x01, // Wà (U+0057 U+00E0)
  0x00, 0x57, 0x00, 0xE1, 0x01, // Wá (U+0057 U+00E1)
  0x00, 0x57, 0x00, 0xE2, 0x01, // Wâ (U+0057 U+00E2)
  0x00, 0x57, 0x00, 0xE3, 0x01, // Wã (U+0057 U+00E3)
  0x00, 0x57, 0x00, 0xE4, 0x01, // Wä (U+0057 U+00E4)
  0x00, 0x57, 0x00, 0xE5, 0x01, // Wå (U+0057 U+00E5)
  0x00, 0x57, 0x00, 0xE6, 0x01, // Wæ (U+0057 U+00E6)
  0x00, 0x57, 0x00, 0xE7, 0x01, // Wç (U+0057 U+00E7)
  0x00, 0x57, 0x00, 0xE8, 0x01, // Wè (U+0057 U+00E8)
  0x00, 0x57, 0x00, 0xE9, 0x01, // Wé (U+0057 U+00E9)
  0x00, 0x57, 0x00, 0xEA, 0x01, // Wê (U+0057 U+00EA)
  0x00, 0x57, 0x00, 0xEB, 0x01, // Wë (U+0057 U+00EB)
  0x00, 0x57, 0x00, 0xF0, 0x01, // Wð (U+0057 U+00F0)
  0x00, 0x57, 0x00, 0xF2, 0x01, // Wò (U+0057 U+00F2)
  0x00, 0x57, 0x00, 0xF3, 0x01, // Wó (U+0057 U+00F3)
  0x00, 0x57, 0x00, 0xF4, 0x01, // Wô (U+0057 U+00F4)
  0x00, 0x57, 0x00, 0xF5, 0x01, // Wõ (U+0057 U+00F5)
  0x00, 0x57, 0x00, 0xF6, 0x01, // Wö (U+0057 U+00F6)
  0x00, 0x57, 0x00, 0xF8, 0x01, // Wø (U+0057 U+00F8)
  0x00, 0x57, 0x01, 0x00, 0x01, // WĀ (U+0057 U+0100)
  0x00, 0x57, 0x01, 0x01, 0x01, // Wā (U+0057 U+0101)
  0x00, 0x57, 0x01, 0x02, 0x01, // WĂ (U+0057 U+0102)
  0x00, 0x57, 0x01, 0x03, 0x01, // Wă (U+0057 U+0103)
  0x00, 0x57, 0x01, 0x04, 0x01, // WĄ (U+0057 U+0104)
  0x00, 0x57, 0x01, 0x05, 0x01, // Wą (U+0057 U+0105)
  0x00, 0x57, 0x01, 0x07, 0x01, // Wć (U+0057 U+0107)
  0x00, 0x57, 0x01, 0x09, 0x01, // Wĉ (U+0057 U+0109)
  0x00, 0x57, 0x01, 0x0B, 0x01, // Wċ (U+0057 U+010B)
  0x00, 0x57, 0x01, 0x0D, 0x01, // Wč (U+0057 U+010D)
  0x00, 0x57, 0x01, 0x0F, 0x01, // Wď (U+0057 U+010F)
  0x00, 0x57, 0x01, 0x11, 0x01, // Wđ (U+0057 U+0111)
  0x00, 0x57, 0x01, 0x13, 0x01, // Wē (U+0057 U+0113)
  0x00, 0x57, 0x01, 0x15, 0x01, // Wĕ (U+0057 U+0115)
  0x00, 0x57, 0x01, 0x17, 0x01, // Wė (U+0057 U+0117)
  0x00, 0x57, 0x01, 0x19, 0x01, // Wę (U+0057 U+0119)
  0x00, 0x57, 0x01, 0x1B, 0x01, // Wě (U+0057 U+011B)
  0x00, 0x57, 0x01, 0x1D, 0x01, // Wĝ (U+0057 U+011D)
  0x00, 0x57, 0x01, 0x1F, 0x01, // Wğ (U+0057 U+011F)
  0x00, 0x57, 0x01, 0x21, 0x01, // Wġ (U+0057 U+0121)
  0x00, 0x57, 0x01, 0x23, 0x01, // Wģ (U+0057 U+0123)
  0x00, 0x57, 0x01, 0x4D, 0x01, // Wō (U+0057 U+014D)
  0x00, 0x57, 0x01, 0x4F, 0x01, // Wŏ (U+0057 U+014F)
  0x00, 0x57, 0x01, 0x51, 0x01, // Wő (U+0057 U+0151)
  0x00, 0x57, 0x01, 0x53, 0x01, // Wœ (U+0057 U+0153)
  0x00, 0x57, 0x01, 0x5B, 0x01, // Wś (U+0057 U+015B)
  0x00, 0x57, 0x01, 0x5D, 0x01, // Wŝ (U+0057 U+015D)
  0x00, 0x57, 0x01, 0x5F, 0x01, // Wş (U+0057 U+015F)
  0x00, 0x57, 0x01, 0x61, 0x01, // Wš (U+0057 U+0161)
  0x00, 0x57, 0x20, 0x1A, 0x01, // W‚ (U+0057 U+201A)
  0x00, 0x57, 0x20, 0x1E, 0x01, // W„ (U+0057 U+201E)
  0x00, 0x57, 0x20, 0x26, 0x01, // W… (U+0057 U+2026)
  0x00, 0x58, 0x00, 0x79, 0x01, // Xy (U+0058 U+0079)
  0x00, 0x58, 0x00, 0xFD, 0x01, // Xý (U+0058 U+00FD)
  0x00, 0x58, 0x00, 0xFF, 0x01, // Xÿ (U+0058 U+00FF)
  0x00, 0x58, 0x01, 0x77, 0x01, // Xŷ (U+0058 U+0177)
  0x00, 0x59, 0x00, 0x2C, 0x01, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x01, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x00, 0x40, 0x01, // Y@ (U+0059 U+0040)
  0x00, 0x59, 0x00, 0x41, 0x01, // YA (U+0059 U+0041)
  0x00, 0x59, 0x00, 0x61, 0x01, // Ya (U+0059 U+0061)
  0x00, 0x59, 0x00, 0x63, 0x01, // Yc (U+0059 U+0063)
  0x00, 0x59, 0x00, 0x64, 0x01, // Yd (U+0059 U+0064)
  0x00, 0x59, 0x00, 0x65, 0x01, // Ye (U+0059 U+0065)
  0x00, 0x59, 0x00, 0x67, 0x01, // Yg (U+0059 U+0067)
  0x00, 0x59, 0x00, 0x6F, 0x01, // Yo (U+0059 U+006F)
  0x00, 0x59, 0x00, 0x71, 0x01, // Yq (U+0059 U+0071)
  0x00, 0x59, 0x00, 0x73, 0x01, // Ys (U+0059 U+0073)
  0x00, 0x59, 0x00, 0xC0, 0x01, // YÀ (U+0059 U+00C0)
  0x00, 0x59, 0x00, 0xC1, 0x01, // YÁ (U+0059 U+00C1)
  0x00, 0x59, 0x00, 0xC2, 0x01, // YÂ (U+0059 U+00C2)
  0x00, 0x59, 0x00, 0xC3, 0x01, // YÃ (U+0059 U+00C3)
  0x00, 0x59, 0x00, 0xC4, 0x01, // YÄ (U+0059 U+00C4)
  0x00, 0x59, 0x00, 0xC5, 0x01, // YÅ (U+0059 U+00C5)
  0x00, 0x59, 0x00, 0xC6, 0x01, // YÆ (U+0059 U+00C6)
  0x00, 0x59, 0x00, 0xE0, 0x01, // Yà (U+0059 U+00E0)
  0x00, 0x59, 0x00, 0xE1, 0x01, // Yá (U+0059 U+00E1)
  0x00, 0x59, 0x00, 0xE2, 0x01, // Yâ (U+0059 U+00E2)
  0x00, 0x59, 0x00, 0xE3, 0x01, // Yã (U+0059 U+00E3)
  0x00, 0x59, 0x00, 0xE4, 0x01, // Yä (U+0059 U+00E4)
  0x00, 0x59, 0x00, 0xE5, 0x01, // Yå (U+0059 U+00E5)
  0x00, 0x59, 0x00, 0xE6, 0x01, // Yæ (U+0059 U+00E6)
  0x00, 0x59, 0x00, 0xE7, 0x01, // Yç (U+0059 U+00E7)
  0x00, 0x59, 0x00, 0xE8, 0x01, // Yè (U+0059 U+00E8)
  0x00, 0x59, 0x00, 0xE9, 0x01, // Yé (U+0059 U+00E9)
  0x00, 0x59, 0x00, 0xEA, 0x01, // Yê (U+0059 U+00EA)
  0x00, 0x59, 0x00, 0xEB, 0x01, // Yë (U+0059 U+00EB)
  0x00, 0x59, 0x00, 0xF0, 0x01, // Yð (U+0059 U+00F0)
  0x00, 0x59, 0x00, 0xF2, 0x01, // Yò (U+0059 U+00F2)
  0x00, 0x59, 0x00, 0xF3, 0x01, // Yó (U+0059 U+00F3)
  0x00, 0x59, 0x00, 0xF4, 0x01, // Yô (U+0059 U+00F4)
  0x00, 0x59, 0x00, 0xF5, 0x01, // Yõ (U+0059 U+00F5)
  0x00, 0x59, 0x00, 0xF6, 0x01, // Yö (U+0059 U+00F6)
  0x00, 0x59, 0x00, 0xF8, 0x01, // Yø (U+0059 U+00F8)
  0x00, 0x59, 0x01, 0x00, 0x01, // YĀ (U+0059 U+0100)
  0x00, 0x59, 0x01, 0x01, 0x01, // Yā (U+0059 U+0101)
  0x00, 0x59, 0x01, 0x02, 0x01, // YĂ (U+0059 U+0102)
  0x00, 0x59, 0x01, 0x03, 0x01, // Yă (U+0059 U+0103)
  0x00, 0x59, 0x01, 0x04, 0x01, // YĄ (U+0059 U+0104)
  0x00, 0x59, 0x01, 0x05, 0x01, // Yą (U+0059 U+0105)
  0x00, 0x59, 0x01, 0x07, 0x01, // Yć (U+0059 U+0107)
  0x00, 0x59, 0x01, 0x09, 0x01, // Yĉ (U+0059 U+0109)
  0x00, 0x59, 0x01, 0x0B, 0x01, // Yċ (U+0059 U+010B)
  0x00, 0x59, 0x01, 0x0D, 0x01, // Yč (U+0059 U+010D)
  0x00, 0x59, 0x01, 0x0F, 0x01, // Yď (U+0059 U+010F)
  0x00, 0x59, 0x01, 0x11, 0x01, // Yđ (U+0059 U+0111)
  0x00, 0x59, 0x01, 0x13, 0x01, // Yē (U+0059 U+0113)
  0x00, 0x59, 0x01, 0x15, 0x01, // Yĕ (U+0059 U+0115)
  0x00, 0x59, 0x01, 0x17, 0x01, // Yė (U+0059 U+0117)
  0x00, 0x59, 0x01, 0x19, 0x01, // Yę (U+0059 U+0119)
  0x00, 0x59, 0x01, 0x1B, 0x01, // Yě (U+0059 U+011B)
  0x00, 0x59, 0x01, 0x1D, 0x01, // Yĝ (U+0059 U+011D)
  0x00, 0x59, 0x01, 0x1F, 0x01, // Yğ (U+0059 U+011F)
  0x00, 0x59, 0x01, 0x21, 0x01, // Yġ (U+0059 U+0121)
  0x00, 0x59, 0x01, 0x23, 0x01, // Yģ (U+0059 U+0123)
  0x00, 0x59, 0x01, 0x4D, 0x01, // Yō (U+0059 U+014D)
  0x00, 0x59, 0x01, 0x4F, 0x01, // Yŏ (U+0059 U+014F)
  0x00, 0x59, 0x01, 0x51, 0x01, // Yő (U+0059 U+0151)
  0x00, 0x59, 0x01, 0x53, 0x01, // Yœ (U+0059 U+0153)
  0x00, 0x59, 0x01, 0x5B, 0x01, // Yś (U+0059 U+015B)
  0x00, 0x59, 0x01, 0x5D, 0x01, // Yŝ (U+0059 U+015D)
  0x00, 0x59, 0x01, 0x5F, 0x01, // Yş (U+0059 U+015F)
  0x00, 0x59, 0x01, 0x61, 0x01, // Yš (U+0059 U+0161)
  0x00, 0x59, 0x20, 0x1A, 0x01, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x01, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x01, // Y… (U+0059 U+2026)
  0x00, 0x61, 0x00, 0x22, 0x01, // a" (U+0061 U+0022)
  0x00, 0x61, 0x00, 0x27, 0x01, // a' (U+0061 U+0027)
  0x00, 0x62, 0x00, 0x56, 0x01, // bV (U+0062 U+0056)
  0x00, 0x62, 0x00, 0x57, 0x01, // bW (U+0062 U+0057)
  0x00, 0x62, 0x00, 0x59, 0x01, // bY (U+0062 U+0059)
  0x00, 0x62, 0x00, 0xDD, 0x01, // bÝ (U+0062 U+00DD)
  0x00, 0x62, 0x01, 0x74, 0x01, // bŴ (U+0062 U+0174)
  0x00, 0x62, 0x01, 0x76, 0x01, // bŶ (U+0062 U+0176)
  0x00, 0x62, 0x01, 0x78, 0x01, // bŸ (U+0062 U+0178)
  0x00, 0x65, 0x00, 0x56, 0x01, // eV (U+0065 U+0056)
  0x00, 0x65, 0x00, 0x57, 0x01, // eW (U+0065 U+0057)
  0x00, 0x65, 0x00, 0x59, 0x01, // eY (U+0065 U+0059)
  0x00, 0x65, 0x00, 0xDD, 0x01, // eÝ (U+0065 U+00DD)
  0x00, 0x65, 0x01, 0x74, 0x01, // eŴ (U+0065 U+0174)
  0x00, 0x65, 0x01, 0x76, 0x01, // eŶ (U+0065 U+0176)
  0x00, 0x65, 0x01, 0x78, 0x01, // eŸ (U+0065 U+0178)
  0x00, 0x68, 0x00, 0x22, 0x01, // h" (U+0068 U+0022)
  0x00, 0x68, 0x00, 0x27, 0x01, // h' (U+0068 U+0027)
  0x00, 0x6D, 0x00, 0x22, 0x01, // m" (U+006D U+0022)
  0x00, 0x6D, 0x00, 0x27, 0x01, // m' (U+006D U+0027)
  0x00, 0x6E, 0x00, 0x22, 0x01, // n" (U+006E U+0022)
  0x00, 0x6E, 0x00, 0x27, 0x01, // n' (U+006E U+0027)
  0x00, 0x6F, 0x00, 0x56, 0x01, // oV (U+006F U+0056)
  0x00, 0x6F, 0x00, 0x57, 0x01, // oW (U+006F U+0057)
  0x00, 0x6F, 0x00, 0x59, 0x01, // oY (U+006F U+0059)
  0x00, 0x6F, 0x00, 0xDD, 0x01, // oÝ (U+006F U+00DD)
  0x00, 0x6F, 0x01, 0x74, 0x01, // oŴ (U+006F U+0174)
  0x00, 0x6F, 0x01, 0x76, 0x01, // oŶ (U+006F U+0176)
  0x00, 0x6F, 0x01, 0x78, 0x01, // oŸ (U+006F U+0178)
  0x00, 0x70, 0x00, 0x56, 0x01, // pV (U+0070 U+0056)
  0x00, 0x70, 0x00, 0x57, 0x01, // pW (U+0070 U+0057)
  0x00, 0x70, 0x00, 0x59, 0x01, // pY (U+0070 U+0059)
  0x00, 0x70, 0x00, 0xDD, 0x01, // pÝ (U+0070 U+00DD)
  0x00, 0x70, 0x01, 0x74, 0x01, // pŴ (U+0070 U+0174)
  0x00, 0x70, 0x01, 0x76, 0x01, // pŶ (U+0070 U+0176)
  0x00, 0x70, 0x01, 0x78, 0x01, // pŸ (U+0070 U+0178)
  0x00, 0x72, 0x00, 0x2C, 0x02, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x02, // r. (U+0072 U+002E)
  0x00, 0x72, 0x20, 0x1A, 0x02, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x02, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x02, // r… (U+0072 U+2026)
  0x00, 0x73, 0x00, 0x59, 0x01, // sY (U+0073 U+0059)
  0x00, 0x73, 0x00, 0xDD, 0x01, // sÝ (U+0073 U+00DD)
  0x00, 0x73, 0x01, 0x76, 0x01, // sŶ (U+0073 U+0176)
  0x00, 0x73, 0x01, 0x78, 0x01, // sŸ (U+0073 U+0178)
  0x00, 0x76, 0x00, 0x2C, 0x01, // v, (U+0076 U+002C)
  0x00, 0x76, 0x00, 0x2E, 0x01, // v. (U+0076 U+002E)
  0x00, 0x76, 0x00, 0x41, 0x01, // vA (U+0076 U+0041)
  0x00, 0x76, 0x00, 0xC0, 0x01, // vÀ (U+0076 U+00C0)
  0x00, 0x76, 0x00, 0xC1, 0x01, // vÁ (U+0076 U+00C1)
  0x00, 0x76, 0x00, 0xC2, 0x01, // vÂ (U+0076 U+00C2)
  0x00, 0x76, 0x00, 0xC3, 0x01, // vÃ (U+0076 U+00C3)
  0x00, 0x76, 0x00, 0xC4, 0x01, // vÄ (U+0076 U+00C4)
  0x00, 0x76, 0x00, 0xC5, 0x01, // vÅ (U+0076 U+00C5)
  0x00, 0x76, 0x01, 0x00, 0x01, // vĀ (U+0076 U+0100)
  0x00, 0x76, 0x01, 0x02, 0x01, // vĂ (U+0076 U+0102)
  0x00, 0x76, 0x01, 0x04, 0x01, // vĄ (U+0076 U+0104)
  0x00, 0x76, 0x20, 0x1A, 0x01, // v‚ (U+0076 U+201A)
  0x00, 0x76, 0x20, 0x1E, 0x01, // v„ (U+0076 U+201E)
  0x00, 0x76, 0x20, 0x26, 0x01, // v… (U+0076 U+2026)
  0x00, 0x77, 0x00, 0x2C, 0x01, // w, (U+0077 U+002C)
  0x00, 0x77, 0x00, 0x2E, 0x01, // w. (U+0077 U+002E)
  0x00, 0x77, 0x20, 0x1A, 0x01, // w‚ (U+0077 U+201A)
  0x00, 0x77, 0x20, 0x1E, 0x01, // w„ (U+0077 U+201E)
  0x00, 0x77, 0x20, 0x26, 0x01, // w… (U+0077 U+2026)
  0x00, 0x79, 0x00, 0x2C, 0x01, // y, (U+0079 U+002C)
  0x00, 0x79, 0x00, 0x2E, 0x01, // y. (U+0079 U+002E)
  0x00, 0x79, 0x00, 0x41, 0x01, // yA (U+0079 U+0041)
  0x00, 0x79, 0x00, 0xC0, 0x01, // yÀ (U+0079 U+00C0)
  0x00, 0x79, 0x00, 0xC1, 0x01, // yÁ (U+0079 U+00C1)
  0x00, 0x79, 0x00, 0xC2, 0x01, // yÂ (U+0079 U+00C2)
  0x00, 0x79, 0x00, 0xC3, 0x01, // yÃ (U+0079 U+00C3)
  0x00, 0x79, 0x00, 0xC4, 0x01, // yÄ (U+0079 U+00C4)
  0x00, 0x79, 0x00, 0xC5, 0x01, // yÅ (U+0079 U+00C5)
  0x00, 0x79, 0x01, 0x00, 0x01, // yĀ (U+0079 U+0100)
  0x00, 0x79, 0x01, 0x02, 0x01, // yĂ (U+0079 U+0102)
  0x00, 0x79, 0x01, 0x04, 0x01, // yĄ (U+0079 U+0104)
  0x00, 0x79, 0x20, 0x1A, 0x01, // y‚ (U+0079 U+201A)
  0x00, 0x79, 0x20, 0x1E, 0x01, // y„ (U+0079 U+201E)
  0x00, 0x79, 0x20, 0x26, 0x01, // y… (U+0079 U+2026)
  0x00, 0xBF, 0x00, 0x56, 0x01, // ¿V (U+00BF U+0056)
  0x00, 0xBF, 0x00, 0x57, 0x01, // ¿W (U+00BF U+0057)
  0x00, 0xBF, 0x00, 0x59, 0x01, // ¿Y (U+00BF U+0059)
  0x00, 0xBF, 0x00, 0xDD, 0x01, // ¿Ý (U+00BF U+00DD)
  0x00, 0xBF, 0x01, 0x74, 0x01, // ¿Ŵ (U+00BF U+0174)
  0x00, 0xBF, 0x01, 0x76, 0x01, // ¿Ŷ (U+00BF U+0176)
  0x00, 0xBF, 0x01, 0x78, 0x01, // ¿Ÿ (U+00BF U+0178)
  0x00, 0xC0, 0x00, 0x22, 0x01, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x01, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x00, 0x2A, 0x01, // À* (U+00C0 U+002A)
  0x00, 0xC0, 0x00, 0x3F, 0x01, // À? (U+00C0 U+003F)
  0x00, 0xC0, 0x00, 0x54, 0x01, // ÀT (U+00C0 U+0054)
  0x00, 0xC0, 0x00, 0x56, 0x01, // ÀV (U+00C0 U+0056)
  0x00, 0xC0, 0x00, 0x57, 0x01, // ÀW (U+00C0 U+0057)
  0x00, 0xC0, 0x00, 0x59, 0x01, // ÀY (U+00C0 U+0059)
  0x00, 0xC0, 0x00, 0x76, 0x01, // Àv (U+00C0 U+0076)
  0x00, 0xC0, 0x00, 0x79, 0x01, // Ày (U+00C0 U+0079)
  0x00, 0xC0, 0x00, 0xDD, 0x01, // ÀÝ (U+00C0 U+00DD)
  0x00, 0xC0, 0x00, 0xFD, 0x01, // Àý (U+00C0 U+00FD)
  0x00, 0xC0, 0x00, 0xFF, 0x01, // Àÿ (U+00C0 U+00FF)
  0x00, 0xC0, 0x01, 0x62, 0x01, // ÀŢ (U+00C0 U+0162)
  0x00, 0xC0, 0x01, 0x64, 0x01, // ÀŤ (U+00C0 U+0164)
  0x00, 0xC0, 0x01, 0x66, 0x01, // ÀŦ (U+00C0 U+0166)
  0x00, 0xC0, 0x01, 0x74, 0x01, // ÀŴ (U+00C0 U+0174)
  0x00, 0xC0, 0x01, 0x76, 0x01, // ÀŶ (U+00C0 U+0176)
  0x00, 0xC0, 0x01, 0x77, 0x01, // Àŷ (U+00C0 U+0177)
  0x00, 0xC0, 0x01, 0x78, 0x01, // ÀŸ (U+00C0 U+0178)
  0x00, 0xC0, 0x20, 0x18, 0x01, // À‘ (U+00C0 U+2018)
  0x00, 0xC0, 0x20, 0x19, 0x01, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1C, 0x01, // À“ (U+00C0 U+201C)
  0x00, 0xC0, 0x20, 0x1D, 0x01, // À” (U+00C0 U+201D)
  0x00, 0xC0, 0x21, 0x22, 0x01, // À™ (U+00C0 U+2122)
  0x00, 0xC1, 0x00, 0x22, 0x01, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x01, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x00, 0x2A, 0x01, // Á* (U+00C1 U+002A)
  0x00, 0xC1, 0x00, 0x3F, 0x01, // Á? (U+00C1 U+003F)
  0x00, 0xC1, 0x00, 0x54, 0x01, // ÁT (U+00C1 U+0054)
  0x00, 0xC1, 0x00, 0x56, 0x01, // ÁV (U+00C1 U+0056)
  0x00, 0xC1, 0x00, 0x57, 0x01, // ÁW (U+00C1 U+0057)
  0x00, 0xC1, 0x00, 0x59, 0x01, // ÁY (U+00C1 U+0059)
  0x00, 0xC1, 0x00, 0x76, 0x01, // Áv (U+00C1 U+0076)
  0x00, 0xC1, 0x00, 0x79, 0x01, // Áy (U+00C1 U+0079)
  0x00, 0xC1, 0x00, 0xDD, 0x01, // ÁÝ (U+00C1 U+00DD)
  0x00, 0xC1, 0x00, 0xFD, 0x01, // Áý (U+00C1 U+00FD)
  0x00, 0xC1, 0x00, 0xFF, 0x01, // Áÿ (U+00C1 U+00FF)
  0x00, 0xC1, 0x01, 0x62, 0x01, // ÁŢ (U+00C1 U+0162)
  0x00, 0xC1, 0x01, 0x64, 0x01, // ÁŤ (U+00C1 U+0164)
  0x00, 0xC1, 0x01, 0x66, 0x01, // ÁŦ (U+00C1 U+0166)
  0x00, 0xC1, 0x01, 0x74, 0x01, // ÁŴ (U+00C1 U+0174)
  0x00, 0xC1, 0x01, 0x76, 0x01, // ÁŶ (U+00C1 U+0176)
  0x00, 0xC1, 0x01, 0x77, 0x01, // Áŷ (U+00C1 U+0177)
  0x00, 0xC1, 0x01, 0x78, 0x01, // ÁŸ (U+00C1 U+0178)
  0x00, 0xC1, 0x20, 0x18, 0x01, // Á‘ (U+00C1 U+2018)
  0x00, 0xC1, 0x20, 0x19, 0x01, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1C, 0x01, // Á“ (U+00C1 U+201C)
  0x00, 0xC1, 0x20, 0x1D, 0x01, // Á” (U+00C1 U+201D)
  0x00, 0xC1, 0x21, 0x22, 0x01, // Á™ (U+00C1 U+2122)
  0x00, 0xC2, 0x00, 0x22, 0x01, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x01, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x00, 0x2A, 0x01, // Â* (U+00C2 U+002A)
  0x00, 0xC2, 0x00, 0x3F, 0x01, // Â? (U+00C2 U+003F)
  0x00, 0xC2, 0x00, 0x54, 0x01, // ÂT (U+00C2 U+0054)
  0x00, 0xC2, 0x00, 0x56, 0x01, // ÂV (U+00C2 U+0056)
  0x00, 0xC2, 0x00, 0x57, 0x01, // ÂW (U+00C2 U+0057)
  0x00, 0xC2, 0x00, 0x59, 0x01, // ÂY (U+00C2 U+0059)
  0x00, 0xC2, 0x00, 0x76, 0x01, // Âv (U+00C2 U+0076)
  0x00, 0xC2, 0x00, 0x79, 0x01, // Ây (U+00C2 U+0079)
  0x00, 0xC2, 0x00, 0xDD, 0x01, // ÂÝ (U+00C2 U+00DD)
  0x00, 0xC2, 0x00, 0xFD, 0x01, // Âý (U+00C2 U+00FD)
  0x00, 0xC2, 0x00, 0xFF, 0x01, // Âÿ (U+00C2 U+00FF)
  0x00, 0xC2, 0x01, 0x62, 0x01, // ÂŢ (U+00C2 U+0162)
  0x00, 0xC2, 0x01, 0x64, 0x01, // ÂŤ (U+00C2 U+0164)
  0x00, 0xC2, 0x01, 0x66, 0x01, // ÂŦ (U+00C2 U+0166)
  0x00, 0xC2, 0x01, 0x74, 0x01, // ÂŴ (U+00C2 U+0174)
  0x00, 0xC2, 0x01, 0x76, 0x01, // ÂŶ (U+00C2 U+0176)
  0x00, 0xC2, 0x01, 0x77, 0x01, // Âŷ (U+00C2 U+0177)
  0x00, 0xC2, 0x01, 0x78, 0x01, // ÂŸ (U+00C2 U+0178)
  0x00, 0xC2, 0x20, 0x18, 0x01, // Â‘ (U+00C2 U+2018)
  0x00, 0xC2, 0x20, 0x19, 0x01, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1C, 0x01, // Â“ (U+00C2 U+201C)
  0x00, 0xC2, 0x20, 0x1D, 0x01, // Â” (U+00C2 U+201D)
  0x00, 0xC2, 0x21, 0x22, 0x01, // Â™ (U+00C2 U+2122)
  0x00, 0xC3, 0x00, 0x22, 0x01, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x01, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x00, 0x2A, 0x01, // Ã* (U+00C3 U+002A)
  0x00, 0xC3, 0x00, 0x3F, 0x01, // Ã? (U+00C3 U+003F)
  0x00, 0xC3, 0x00, 0x54, 0x01, // ÃT (U+00C3 U+0054)
  0x00, 0xC3, 0x00, 0x56, 0x01, // ÃV (U+00C3 U+0056)
  0x00, 0xC3, 0x00, 0x57, 0x01, // ÃW (U+00C3 U+0057)
  0x00, 0xC3, 0x00, 0x59, 0x01, // ÃY (U+00C3 U+0059)
  0x00, 0xC3, 0x00, 0x76, 0x01, // Ãv (U+00C3 U+0076)
  0x00, 0xC3, 0x00, 0x79, 0x01, // Ãy (U+00C3 U+0079)
  0x00, 0xC3, 0x00, 0xDD, 0x01, // ÃÝ (U+00C3 U+00DD)
  0x00, 0xC3, 0x00, 0xFD, 0x01, // Ãý (U+00C3 U+00FD)
  0x00, 0xC3, 0x00, 0xFF, 0x01, // Ãÿ (U+00C3 U+00FF)
  0x00, 0xC3, 0x01, 0x62, 0x01, // ÃŢ (U+00C3 U+0162)
  0x00, 0xC3, 0x01, 0x64, 0x01, // ÃŤ (U+00C3 U+0164)
  0x00, 0xC3, 0x01, 0x66, 0x01, // ÃŦ (U+00C3 U+0166)
  0x00, 0xC3, 0x01, 0x74, 0x01, // ÃŴ (U+00C3 U+0174)
  0x00, 0xC3, 0x01, 0x76, 0x01, // ÃŶ (U+00C3 U+0176)
  0x00, 0xC3, 0x01, 0x77, 0x01, // Ãŷ (U+00C3 U+0177)
  0x00, 0xC3, 0x01, 0x78, 0x01, // ÃŸ (U+00C3 U+0178)
  0x00, 0xC3, 0x20, 0x18, 0x01, // Ã‘ (U+00C3 U+2018)
  0x00, 0xC3, 0x20, 0x19, 0x01, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1C, 0x01, // Ã“ (U+00C3 U+201C)
  0x00, 0xC3, 0x20, 0x1D, 0x01, // Ã” (U+00C3 U+201D)
  0x00, 0xC3, 0x21, 0x22, 0x01, // Ã™ (U+00C3 U+2122)
  0x00, 0xC4, 0x00, 0x22, 0x01, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x01, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x00, 0x2A, 0x01, // Ä* (U+00C4 U+002A)
  0x00, 0xC4, 0x00, 0x3F, 0x01, // Ä? (U+00C4 U+003F)
  0x00, 0xC4, 0x00, 0x54, 0x01, // ÄT (U+00C4 U+0054)
  0x00, 0xC4, 0x00, 0x56, 0x01, // ÄV (U+00C4 U+0056)
  0x00, 0xC4, 0x00, 0x57, 0x01, // ÄW (U+00C4 U+0057)
  0x00, 0xC4, 0x00, 0x59, 0x01, // ÄY (U+00C4 U+0059)
  0x00, 0xC4, 0x00, 0x76, 0x01, // Äv (U+00C4 U+0076)
  0x00, 0xC4, 0x00, 0x79, 0x01, // Äy (U+00C4 U+0079)
  0x00, 0xC4, 0x00, 0xDD, 0x01, // ÄÝ (U+00C4 U+00DD)
  0x00, 0xC4, 0x00, 0xFD, 0x01, // Äý (U+00C4 U+00FD)
  0x00, 0xC4, 0x00, 0xFF, 0x01, // Äÿ (U+00C4 U+00FF)
  0x00, 0xC4, 0x01, 0x62, 0x01, // ÄŢ (U+00C4 U+0162)
  0x00, 0xC4, 0x01, 0x64, 0x01, // ÄŤ (U+00C4 U+0164)
  0x00, 0xC4, 0x01, 0x66, 0x01, // ÄŦ (U+00C4 U+0166)
  0x00, 0xC4, 0x01, 0x74, 0x01, // ÄŴ (U+00C4 U+0174)
  0x00, 0xC4, 0x01, 0x76, 0x01, // ÄŶ (U+00C4 U+0176)
  0x00, 0xC4, 0x01, 0x77, 0x01, // Äŷ (U+00C4 U+0177)
  0x00, 0xC4, 0x01, 0x78, 0x01, // ÄŸ (U+00C4 U+0178)
  0x00, 0xC4, 0x20, 0x18, 0x01, // Ä‘ (U+00C4 U+2018)
  0x00, 0xC4, 0x20, 0x19, 0x01, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1C, 0x01, // Ä“ (U+00C4 U+201C)
  0x00, 0xC4, 0x20, 0x1D, 0x01, // Ä” (U+00C4 U+201D)
  0x00, 0xC4, 0x21, 0x22, 0x01, // Ä™ (U+00C4 U+2122)
  0x00, 0xC5, 0x00, 0x22, 0x01, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x01, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x00, 0x2A, 0x01, // Å* (U+00C5 U+002A)
  0x00, 0xC5, 0x00, 0x3F, 0x01, // Å? (U+00C5 U+003F)
  0x00, 0xC5, 0x00, 0x54, 0x01, // ÅT (U+00C5 U+0054)
  0x00, 0xC5, 0x00, 0x56, 0x01, // ÅV (U+00C5 U+0056)
  0x00, 0xC5, 0x00, 0x57, 0x01, // ÅW (U+00C5 U+0057)
  0x00, 0xC5, 0x00, 0x59, 0x01, // ÅY (U+00C5 U+0059)
  0x00, 0xC5, 0x00, 0x76, 0x01, // Åv (U+00C5 U+0076)
  0x00, 0xC5, 0x00, 0x79, 0x01, // Åy (U+00C5 U+0079)
  0x00, 0xC5, 0x00, 0xDD, 0x01, // ÅÝ (U+00C5 U+00DD)
  0x00, 0xC5, 0x00, 0xFD, 0x01, // Åý (U+00C5 U+00FD)
  0x00, 0xC5, 0x00, 0xFF, 0x01, // Åÿ (U+00C5 U+00FF)
  0x00, 0xC5, 0x01, 0x62, 0x01, // ÅŢ (U+00C5 U+0162)
  0x00, 0xC5, 0x01, 0x64, 0x01, // ÅŤ (U+00C5 U+0164)
  0x00, 0xC5, 0x01, 0x66, 0x01, // ÅŦ (U+00C5 U+0166)
  0x00, 0xC5, 0x01, 0x74, 0x01, // ÅŴ (U+00C5 U+0174)
  0x00, 0xC5, 0x01, 0x76, 0x01, // ÅŶ (U+00C5 U+0176)
  0x00, 0xC5, 0x01, 0x77, 0x01, // Åŷ (U+00C5 U+0177)
  0x00, 0xC5, 0x01, 0x78, 0x01, // ÅŸ (U+00C5 U+0178)
  0x00, 0xC5, 0x20, 0x18, 0x01, // Å‘ (U+00C5 U+2018)
  0x00, 0xC5, 0x20, 0x19, 0x01, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1C, 0x01, // Å“ (U+00C5 U+201C)
  0x00, 0xC5, 0x20, 0x1D, 0x01, // Å” (U+00C5 U+201D)
  0x00, 0xC5, 0x21, 0x22, 0x01, // Å™ (U+00C5 U+2122)
  0x00, 0xD0, 0x00, 0xC6, 0x01, // ÐÆ (U+00D0 U+00C6)
  0x00, 0xD2, 0x00, 0xC6, 0x01, // ÒÆ (U+00D2 U+00C6)
  0x00, 0xD3, 0x00, 0xC6, 0x01, // ÓÆ (U+00D3 U+00C6)
  0x00, 0xD4, 0x00, 0xC6, 0x01, // ÔÆ (U+00D4 U+00C6)
  0x00, 0xD5, 0x00, 0xC6, 0x01, // ÕÆ (U+00D5 U+00C6)
  0x00, 0xD6, 0x00, 0xC6, 0x01, // ÖÆ (U+00D6 U+00C6)
  0x00, 0xD8, 0x00, 0xC6, 0x01, // ØÆ (U+00D8 U+00C6)
  0x00, 0xD9, 0x00, 0xC6, 0x01, // ÙÆ (U+00D9 U+00C6)
  0x00, 0xDA, 0x00, 0xC6, 0x01, // ÚÆ (U+00DA U+00C6)
  0x00, 0xDB, 0x00, 0xC6, 0x01, // ÛÆ (U+00DB U+00C6)
  0x00, 0xDC, 0x00, 0xC6, 0x01, // ÜÆ (U+00DC U+00C6)
  0x00, 0xDD, 0x00, 0x2C, 0x01, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x01, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x00, 0x40, 0x01, // Ý@ (U+00DD U+0040)
  0x00, 0xDD, 0x00, 0x41, 0x01, // ÝA (U+00DD U+0041)
  0x00, 0xDD, 0x00, 0x61, 0x01, // Ýa (U+00DD U+0061)
  0x00, 0xDD, 0x00, 0x63, 0x01, // Ýc (U+00DD U+0063)
  0x00, 0xDD, 0x00, 0x64, 0x01, // Ýd (U+00DD U+0064)
  0x00, 0xDD, 0x00, 0x65, 0x01, // Ýe (U+00DD U+0065)
  0x00, 0xDD, 0x00, 0x67, 0x01, // Ýg (U+00DD U+0067)
  0x00, 0xDD, 0x00, 0x6F, 0x01, // Ýo (U+00DD U+006F)
  0x00, 0xDD, 0x00, 0x71, 0x01, // Ýq (U+00DD U+0071)
  0x00, 0xDD, 0x00, 0x73, 0x01, // Ýs (U+00DD U+0073)
  0x00, 0xDD, 0x00, 0xC0, 0x01, // ÝÀ (U+00DD U+00C0)
  0x00, 0xDD, 0x00, 0xC1, 0x01, // ÝÁ (U+00DD U+00C1)
  0x00, 0xDD, 0x00, 0xC2, 0x01, // ÝÂ (U+00DD U+00C2)
  0x00, 0xDD, 0x00, 0xC3, 0x01, // ÝÃ (U+00DD U+00C3)
  0x00, 0xDD, 0x00, 0xC4, 0x01, // ÝÄ (U+00DD U+00C4)
  0x00, 0xDD, 0x00, 0xC5, 0x01, // ÝÅ (U+00DD U+00C5)
  0x00, 0xDD, 0x00, 0xC6, 0x01, // ÝÆ (U+00DD U+00C6)
  0x00, 0xDD, 0x00, 0xE0, 0x01, // Ýà (U+00DD U+00E0)
  0x00, 0xDD, 0x00, 0xE1, 0x01, // Ýá (U+00DD U+00E1)
  0x00, 0xDD, 0x00, 0xE2, 0x01, // Ýâ (U+00DD U+00E2)
  0x00, 0xDD, 0x00, 0xE3, 0x01, // Ýã (U+00DD U+00E3)
  0x00, 0xDD, 0x00, 0xE4, 0x01, // Ýä (U+00DD U+00E4)
  0x00, 0xDD, 0x00, 0xE5, 0x01, // Ýå (U+00DD U+00E5)
  0x00, 0xDD, 0x00, 0xE6, 0x01, // Ýæ (U+00DD U+00E6)
  0x00, 0xDD, 0x00, 0xE7, 0x01, // Ýç (U+00DD U+00E7)
  0x00, 0xDD, 0x00, 0xE8, 0x01, // Ýè (U+00DD U+00E8)
  0x00, 0xDD, 0x00, 0xE9, 0x01, // Ýé (U+00DD U+00E9)
  0x00, 0xDD, 0x00, 0xEA, 0x01, // Ýê (U+00DD U+00EA)
  0x00, 0xDD, 0x00, 0xEB, 0x01, // Ýë (U+00DD U+00EB)
  0x00, 0xDD, 0x00, 0xF0, 0x01, // Ýð (U+00DD U+00F0)
  0x00, 0xDD, 0x00, 0xF2, 0x01, // Ýò (U+00DD U+00F2)
  0x00, 0xDD, 0x00, 0xF3, 0x01, // Ýó (U+00DD U+00F3)
  0x00, 0xDD, 0x00, 0xF4, 0x01, // Ýô (U+00DD U+00F4)
  0x00, 0xDD, 0x00, 0xF5, 0x01, // Ýõ (U+00DD U+00F5)
  0x00, 0xDD, 0x00, 0xF6, 0x01, // Ýö (U+00DD U+00F6)
  0x00, 0xDD, 0x00, 0xF8, 0x01, // Ýø (U+00DD U+00F8)
  0x00, 0xDD, 0x01, 0x00, 0x01, // ÝĀ (U+00DD U+0100)
  0x00, 0xDD, 0x01, 0x01, 0x01, // Ýā (U+00DD U+0101)
  0x00, 0xDD, 0x01, 0x02, 0x01, // ÝĂ (U+00DD U+0102)
  0x00, 0xDD, 0x01, 0x03, 0x01, // Ýă (U+00DD U+0103)
  0x00, 0xDD, 0x01, 0x04, 0x01, // ÝĄ (U+00DD U+0104)
  0x00, 0xDD, 0x01, 0x05, 0x01, // Ýą (U+00DD U+0105)
  0x00, 0xDD, 0x01, 0x07, 0x01, // Ýć (U+00DD U+0107)
  0x00, 0xDD, 0x01, 0x09, 0x01, // Ýĉ (U+00DD U+0109)
  0x00, 0xDD, 0x01, 0x0B, 0x01, // Ýċ (U+00DD U+010B)
  0x00, 0xDD, 0x01, 0x0D, 0x01, // Ýč (U+00DD U+010D)
  0x00, 0xDD, 0x01, 0x0F, 0x01, // Ýď (U+00DD U+010F)
  0x00, 0xDD, 0x01, 0x11, 0x01, // Ýđ (U+00DD U+0111)
  0x00, 0xDD, 0x01, 0x13, 0x01, // Ýē (U+00DD U+0113)
  0x00, 0xDD, 0x01, 0x15, 0x01, // Ýĕ (U+00DD U+0115)
  0x00, 0xDD, 0x01, 0x17, 0x01, // Ýė (U+00DD U+0117)
  0x00, 0xDD, 0x01, 0x19, 0x01, // Ýę (U+00DD U+0119)
  0x00, 0xDD, 0x01, 0x1B, 0x01, // Ýě (U+00DD U+011B)
  0x00, 0xDD, 0x01, 0x1D, 0x01, // Ýĝ (U+00DD U+011D)
  0x00, 0xDD, 0x01, 0x1F, 0x01, // Ýğ (U+00DD U+011F)
  0x00, 0xDD, 0x01, 0x21, 0x01, // Ýġ (U+00DD U+0121)
  0x00, 0xDD, 0x01, 0x23, 0x01, // Ýģ (U+00DD U+0123)
  0x00, 0xDD, 0x01, 0x4D, 0x01, // Ýō (U+00DD U+014D)
  0x00, 0xDD, 0x01, 0x4F, 0x01, // Ýŏ (U+00DD U+014F)
  0x00, 0xDD, 0x01, 0x51, 0x01, // Ýő (U+00DD U+0151)
  0x00, 0xDD, 0x01, 0x53, 0x01, // Ýœ (U+00DD U+0153)
  0x00, 0xDD, 0x01, 0x5B, 0x01, // Ýś (U+00DD U+015B)
  0x00, 0xDD, 0x01, 0x5D, 0x01, // Ýŝ (U+00DD U+015D)
  0x00, 0xDD, 0x01, 0x5F, 0x01, // Ýş (U+00DD U+015F)
  0x00, 0xDD, 0x01, 0x61, 0x01, // Ýš (U+00DD U+0161)
  0x00, 0xDD, 0x20, 0x1A, 0x01, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x01, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x01, // Ý… (U+00DD U+2026)
  0x00, 0xDE, 0x00, 0xC6, 0x01, // ÞÆ (U+00DE U+00C6)
  0x00, 0xDF, 0x00, 0x56, 0x01, // ßV (U+00DF U+0056)
  0x00, 0xDF, 0x00, 0x57, 0x01, // ßW (U+00DF U+0057)
  0x00, 0xDF, 0x00, 0x59, 0x01, // ßY (U+00DF U+0059)
  0x00, 0xDF, 0x00, 0xDD, 0x01, // ßÝ (U+00DF U+00DD)
  0x00, 0xDF, 0x01, 0x74, 0x01, // ßŴ (U+00DF U+0174)
  0x00, 0xDF, 0x01, 0x76, 0x01, // ßŶ (U+00DF U+0176)
  0x00, 0xDF, 0x01, 0x78, 0x01, // ßŸ (U+00DF U+0178)
  0x00, 0xE0, 0x00, 0x22, 0x01, // à" (U+00E0 U+0022)
  0x00, 0xE0, 0x00, 0x27, 0x01, // à' (U+00E0 U+0027)
  0x00, 0xE1, 0x00, 0x22, 0x01, // á" (U+00E1 U+0022)
  0x00, 0xE1, 0x00, 0x27, 0x01, // á' (U+00E1 U+0027)
  0x00, 0xE2, 0x00, 0x22, 0x01, // â" (U+00E2 U+0022)
  0x00, 0xE2, 0x00, 0x27, 0x01, // â' (U+00E2 U+0027)
  0x00, 0xE3, 0x00, 0x22, 0x01, // ã" (U+00E3 U+0022)
  0x00, 0xE3, 0x00, 0x27, 0x01, // ã' (U+00E3 U+0027)
  0x00, 0xE4, 0x00, 0x22, 0x01, // ä" (U+00E4 U+0022)
  0x00, 0xE4, 0x00, 0x27, 0x01, // ä' (U+00E4 U+0027)
  0x00, 0xE5, 0x00, 0x22, 0x01, // å" (U+00E5 U+0022)
  0x00, 0xE5, 0x00, 0x27, 0x01, // å' (U+00E5 U+0027)
  0x00, 0xE6, 0x00, 0x56, 0x01, // æV (U+00E6 U+0056)
  0x00, 0xE6, 0x00, 0x57, 0x01, // æW (U+00E6 U+0057)
  0x00, 0xE6, 0x00, 0x59, 0x01, // æY (U+00E6 U+0059)
  0x00, 0xE6, 0x00, 0xDD, 0x01, // æÝ (U+00E6 U+00DD)
  0x00, 0xE6, 0x01, 0x74, 0x01, // æŴ (U+00E6 U+0174)
  0x00, 0xE6, 0x01, 0x76, 0x01, // æŶ (U+00E6 U+0176)
  0x00, 0xE6, 0x01, 0x78, 0x01, // æŸ (U+00E6 U+0178)
  0x00, 0xE8, 0x00, 0x56, 0x01, // èV (U+00E8 U+0056)
  0x00, 0xE8, 0x00, 0x57, 0x01, // èW (U+00E8 U+0057)
  0x00, 0xE8, 0x00, 0x59, 0x01, // èY (U+00E8 U+0059)
  0x00, 0xE8, 0x00, 0xDD, 0x01, // èÝ (U+00E8 U+00DD)
  0x00, 0xE8, 0x01, 0x74, 0x01, // èŴ (U+00E8 U+0174)
  0x00, 0xE8, 0x01, 0x76, 0x01, // èŶ (U+00E8 U+0176)
  0x00, 0xE8, 0x01, 0x78, 0x01, // èŸ (U+00E8 U+0178)
  0x00, 0xE9, 0x00, 0x56, 0x01, // éV (U+00E9 U+0056)
  0x00, 0xE9, 0x00, 0x57, 0x01, // éW (U+00E9 U+0057)
  0x00, 0xE9, 0x00, 0x59, 0x01, // éY (U+00E9 U+0059)
  0x00, 0xE9, 0x00, 0xDD, 0x01, // éÝ (U+00E9 U+00DD)
  0x00, 0xE9, 0x01, 0x74, 0x01, // éŴ (U+00E9 U+0174)
  0x00, 0xE9, 0x01, 0x76, 0x01, // éŶ (U+00E9 U+0176)
  0x00, 0xE9, 0x01, 0x78, 0x01, // éŸ (U+00E9 U+0178)
  0x00, 0xEA, 0x00, 0x56, 0x01, // êV (U+00EA U+0056)
  0x00, 0xEA, 0x00, 0x57, 0x01, // êW (U+00EA U+0057)
  0x00, 0xEA, 0x00, 0x59, 0x01, // êY (U+00EA U+0059)
  0x00, 0xEA, 0x00, 0xDD, 0x01, // êÝ (U+00EA U+00DD)
  0x00, 0xEA, 0x01, 0x74, 0x01, // êŴ (U+00EA U+0174)
  0x00, 0xEA, 0x01, 0x76, 0x01, // êŶ (U+00EA U+0176)
  0x00, 0xEA, 0x01, 0x78, 0x01, // êŸ (U+00EA U+0178)
  0x00, 0xEB, 0x00, 0x56, 0x01, // ëV (U+00EB U+0056)
  0x00, 0xEB, 0x00, 0x57, 0x01, // ëW (U+00EB U+0057)
  0x00, 0xEB, 0x00, 0x59, 0x01, // ëY (U+00EB U+0059)
  0x00, 0xEB, 0x00, 0xDD, 0x01, // ëÝ (U+00EB U+00DD)
  0x00, 0xEB, 0x01, 0x74, 0x01, // ëŴ (U+00EB U+0174)
  0x00, 0xEB, 0x01, 0x76, 0x01, // ëŶ (U+00EB U+0176)
  0x00, 0xEB, 0x01, 0x78, 0x01, // ëŸ (U+00EB U+0178)
  0x00, 0xF0, 0x00, 0x56, 0x01, // ðV (U+00F0 U+0056)
  0x00, 0xF0, 0x00, 0x57, 0x01, // ðW (U+00F0 U+0057)
  0x00, 0xF0, 0x00, 0x59, 0x01, // ðY (U+00F0 U+0059)
  0x00, 0xF0, 0x00, 0xDD, 0x01, // ðÝ (U+00F0 U+00DD)
  0x00, 0xF0, 0x01, 0x74, 0x01, // ðŴ (U+00F0 U+0174)
  0x00, 0xF0, 0x01, 0x76, 0x01, // ðŶ (U+00F0 U+0176)
  0x00, 0xF0, 0x01, 0x78, 0x01, // ðŸ (U+00F0 U+0178)
  0x00, 0xF1, 0x00, 0x22, 0x01, // ñ" (U+00F1 U+0022)
  0x00, 0xF1, 0x00, 0x27, 0x01, // ñ' (U+00F1 U+0027)
  0x00, 0xF2, 0x00, 0x56, 0x01, // òV (U+00F2 U+0056)
  0x00, 0xF2, 0x00, 0x57, 0x01, // òW (U+00F2 U+0057)
  0x00, 0xF2, 0x00, 0x59, 0x01, // òY (U+00F2 U+0059)
  0x00, 0xF2, 0x00, 0xDD, 0x01, // òÝ (U+00F2 U+00DD)
  0x00, 0xF2, 0x01, 0x74, 0x01, // òŴ (U+00F2 U+0174)
  0x00, 0xF2, 0x01, 0x76, 0x01, // òŶ (U+00F2 U+0176)
  0x00, 0xF2, 0x01, 0x78, 0x01, // òŸ (U+00F2 U+0178)
  0x00, 0xF3, 0x00, 0x56, 0x01, // óV (U+00F3 U+0056)
  0x00, 0xF3, 0x00, 0x57, 0x01, // óW (U+00F3 U+0057)
  0x00, 0xF3, 0x00, 0x59, 0x01, // óY (U+00F3 U+0059)
  0x00, 0xF3, 0x00, 0xDD, 0x01, // óÝ (U+00F3 U+00DD)
  0x00, 0xF3, 0x01, 0x74, 0x01, // óŴ (U+00F3 U+0174)
  0x00, 0xF3, 0x01, 0x76, 0x01, // óŶ (U+00F3 U+0176)
  0x00, 0xF3, 0x01, 0x78, 0x01, // óŸ (U+00F3 U+0178)
  0x00, 0xF4, 0x00, 0x56, 0x01, // ôV (U+00F4 U+0056)
  0x00, 0xF4, 0x00, 0x57, 0x01, // ôW (U+00F4 U+0057)
  0x00, 0xF4, 0x00, 0x59, 0x01, // ôY (U+00F4 U+0059)
  0x00, 0xF4, 0x00, 0xDD, 0x01, // ôÝ (U+00F4 U+00DD)
  0x00, 0xF4, 0x01, 0x74, 0x01, // ôŴ (U+00F4 U+0174)
  0x00, 0xF4, 0x01, 0x76, 0x01, // ôŶ (U+00F4 U+0176)
  0x00, 0xF4, 0x01, 0x78, 0x01, // ôŸ (U+00F4 U+0178)
  0x00, 0xF5, 0x00, 0x56, 0x01, // õV (U+00F5 U+0056)
  0x00, 0xF5, 0x00, 0x57, 0x01, // õW (U+00F5 U+0057)
  0x00, 0xF5, 0x00, 0x59, 0x01, // õY (U+00F5 U+0059)
  0x00, 0xF5, 0x00, 0xDD, 0x01, // õÝ (U+00F5 U+00DD)
  0x00, 0xF5, 0x01, 0x74, 0x01, // õŴ (U+00F5 U+0174)
  0x00, 0xF5, 0x01, 0x76, 0x01, // õŶ (U+00F5 U+0176)
  0x00, 0xF5, 0x01, 0x78, 0x01, // õŸ (U+00F5 U+0178)
  0x00, 0xF6, 0x00, 0x56, 0x01, // öV (U+00F6 U+0056)
  0x00, 0xF6, 0x00, 0x57, 0x01, // öW (U+00F6 U+0057)
  0x00, 0xF6, 0x00, 0x59, 0x01, // öY (U+00F6 U+0059)
  0x00, 0xF6, 0x00, 0xDD, 0x01, // öÝ (U+00F6 U+00DD)
  0x00, 0xF6, 0x01, 0x74, 0x01, // öŴ (U+00F6 U+0174)
  0x00, 0xF6, 0x01, 0x76, 0x01, // öŶ (U+00F6 U+0176)
  0x00, 0xF6, 0x01, 0x78, 0x01, // öŸ (U+00F6 U+0178)
  0x00, 0xF8, 0x00, 0x56, 0x01, // øV (U+00F8 U+0056)
  0x00, 0xF8, 0x00, 0x57, 0x01, // øW (U+00F8 U+0057)
  0x00, 0xF8, 0x00, 0x59, 0x01, // øY (U+00F8 U+0059)
  0x00, 0xF8, 0x00, 0xDD, 0x01, // øÝ (U+00F8 U+00DD)
  0x00, 0xF8, 0x01, 0x74, 0x01, // øŴ (U+00F8 U+0174)
  0x00, 0xF8, 0x01, 0x76, 0x01, // øŶ (U+00F8 U+0176)
  0x00, 0xF8, 0x01, 0x78, 0x01, // øŸ (U+00F8 U+0178)
  0x00, 0xFD, 0x00, 0x2C, 0x01, // ý, (U+00FD U+002C)
  0x00, 0xFD, 0x00, 0x2E, 0x01, // ý. (U+00FD U+002E)
  0x00, 0xFD, 0x00, 0x41, 0x01, // ýA (U+00FD U+0041)
  0x00, 0xFD, 0x00, 0xC0, 0x01, // ýÀ (U+00FD U+00C0)
  0x00, 0xFD, 0x00, 0xC1, 0x01, // ýÁ (U+00FD U+00C1)
  0x00, 0xFD, 0x00, 0xC2, 0x01, // ýÂ (U+00FD U+00C2)
  0x00, 0xFD, 0x00, 0xC3, 0x01, // ýÃ (U+00FD U+00C3)
  0x00, 0xFD, 0x00, 0xC4, 0x01, // ýÄ (U+00FD U+00C4)
  0x00, 0xFD, 0x00, 0xC5, 0x01, // ýÅ (U+00FD U+00C5)
  0x00, 0xFD, 0x01, 0x00, 0x01, // ýĀ (U+00FD U+0100)
  0x00, 0xFD, 0x01, 0x02, 0x01, // ýĂ (U+00FD U+0102)
  0x00, 0xFD, 0x01, 0x04, 0x01, // ýĄ (U+00FD U+0104)
  0x00, 0xFD, 0x20, 0x1A, 0x01, // ý‚ (U+00FD U+201A)
  0x00, 0xFD, 0x20, 0x1E, 0x01, // ý„ (U+00FD U+201E)
  0x00, 0xFD, 0x20, 0x26, 0x01, // ý… (U+00FD U+2026)
  0x00, 0xFE, 0x00, 0x56, 0x01, // þV (U+00FE U+0056)
  0x00, 0xFE, 0x00, 0x57, 0x01, // þW (U+00FE U+0057)
  0x00, 0xFE, 0x00, 0x59, 0x01, // þY (U+00FE U+0059)
  0x00, 0xFE, 0x00, 0xDD, 0x01, // þÝ (U+00FE U+00DD)
  0x00, 0xFE, 0x01, 0x74, 0x01, // þŴ (U+00FE U+0174)
  0x00, 0xFE, 0x01, 0x76, 0x01, // þŶ (U+00FE U+0176)
  0x00, 0xFE, 0x01, 0x78, 0x01, // þŸ (U+00FE U+0178)
  0x00, 0xFF, 0x00, 0x2C, 0x01, // ÿ, (U+00FF U+002C)
  0x00, 0xFF, 0x00, 0x2E, 0x01, // ÿ. (U+00FF U+002E)
  0x00, 0xFF, 0x00, 0x41, 0x01, // ÿA (U+00FF U+0041)
  0x00, 0xFF, 0x00, 0xC0, 0x01, // ÿÀ (U+00FF U+00C0)
  0x00, 0xFF, 0x00, 0xC1, 0x01, // ÿÁ (U+00FF U+00C1)
  0x00, 0xFF, 0x00, 0xC2, 0x01, // ÿÂ (U+00FF U+00C2)
  0x00, 0xFF, 0x00, 0xC3, 0x01, // ÿÃ (U+00FF U+00C3)
  0x00, 0xFF, 0x00, 0xC4, 0x01, // ÿÄ (U+00FF U+00C4)
  0x00, 0xFF, 0x00, 0xC5, 0x01, // ÿÅ (U+00FF U+00C5)
  0x00, 0xFF, 0x01, 0x00, 0x01, // ÿĀ (U+00FF U+0100)
  0x00, 0xFF, 0x01, 0x02, 0x01, // ÿĂ (U+00FF U+0102)
  0x00, 0xFF, 0x01, 0x04, 0x01, // ÿĄ (U+00FF U+0104)
  0x00, 0xFF, 0x20, 0x1A, 0x01, // ÿ‚ (U+00FF U+201A)
  0x00, 0xFF, 0x20, 0x1E, 0x01, // ÿ„ (U+00FF U+201E)
  0x00, 0xFF, 0x20, 0x26, 0x01, // ÿ… (U+00FF U+2026)
  0x01, 0x00, 0x00, 0x22, 0x01, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x01, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x00, 0x2A, 0x01, // Ā* (U+0100 U+002A)
  0x01, 0x00, 0x00, 0x3F, 0x01, // Ā? (U+0100 U+003F)
  0x01, 0x00, 0x00, 0x54, 0x01, // ĀT (U+0100 U+0054)
  0x01, 0x00, 0x00, 0x56, 0x01, // ĀV (U+0100 U+0056)
  0x01, 0x00, 0x00, 0x57, 0x01, // ĀW (U+0100 U+0057)
  0x01, 0x00, 0x00, 0x59, 0x01, // ĀY (U+0100 U+0059)
  0x01, 0x00, 0x00, 0x76, 0x01, // Āv (U+0100 U+0076)
  0x01, 0x00, 0x00, 0x79, 0x01, // Āy (U+0100 U+0079)
  0x01, 0x00, 0x00, 0xDD, 0x01, // ĀÝ (U+0100 U+00DD)
  0x01, 0x00, 0x00, 0xFD, 0x01, // Āý (U+0100 U+00FD)
  0x01, 0x00, 0x00, 0xFF, 0x01, // Āÿ (U+0100 U+00FF)
  0x01, 0x00, 0x01, 0x62, 0x01, // ĀŢ (U+0100 U+0162)
  0x01, 0x00, 0x01, 0x64, 0x01, // ĀŤ (U+0100 U+0164)
  0x01, 0x00, 0x01, 0x66, 0x01, // ĀŦ (U+0100 U+0166)
  0x01, 0x00, 0x01, 0x74, 0x01, // ĀŴ (U+0100 U+0174)
  0x01, 0x00, 0x01, 0x76, 0x01, // ĀŶ (U+0100 U+0176)
  0x01, 0x00, 0x01, 0x77, 0x01, // Āŷ (U+0100 U+0177)
  0x01, 0x00, 0x01, 0x78, 0x01, // ĀŸ (U+0100 U+0178)
  0x01, 0x00, 0x20, 0x18, 0x01, // Ā‘ (U+0100 U+2018)
  0x01, 0x00, 0x20, 0x19, 0x01, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1C, 0x01, // Ā“ (U+0100 U+201C)
  0x01, 0x00, 0x20, 0x1D, 0x01, // Ā” (U+0100 U+201D)
  0x01, 0x00, 0x21, 0x22, 0x01, // Ā™ (U+0100 U+2122)
  0x01, 0x02, 0x00, 0x22, 0x01, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x01, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x00, 0x2A, 0x01, // Ă* (U+0102 U+002A)
  0x01, 0x02, 0x00, 0x3F, 0x01, // Ă? (U+0102 U+003F)
  0x01, 0x02, 0x00, 0x54, 0x01, // ĂT (U+0102 U+0054)
  0x01, 0x02, 0x00, 0x56, 0x01, // ĂV (U+0102 U+0056)
  0x01, 0x02, 0x00, 0x57, 0x01, // ĂW (U+0102 U+0057)
  0x01, 0x02, 0x00, 0x59, 0x01, // ĂY (U+0102 U+0059)
  0x01, 0x02, 0x00, 0x76, 0x01, // Ăv (U+0102 U+0076)
  0x01, 0x02, 0x00, 0x79, 0x01, // Ăy (U+0102 U+0079)
  0x01, 0x02, 0x00, 0xDD, 0x01, // ĂÝ (U+0102 U+00DD)
  0x01, 0x02, 0x00, 0xFD, 0x01, // Ăý (U+0102 U+00FD)
  0x01, 0x02, 0x00, 0xFF, 0x01, // Ăÿ (U+0102 U+00FF)
  0x01, 0x02, 0x01, 0x62, 0x01, // ĂŢ (U+0102 U+0162)
  0x01, 0x02, 0x01, 0x64, 0x01, // ĂŤ (U+0102 U+0164)
  0x01, 0x02, 0x01, 0x66, 0x01, // ĂŦ (U+0102 U+0166)
  0x01, 0x02, 0x01, 0x74, 0x01, // ĂŴ (U+0102 U+0174)
  0x01, 0x02, 0x01, 0x76, 0x01, // ĂŶ (U+0102 U+0176)
  0x01, 0x02, 0x01, 0x77, 0x01, // Ăŷ (U+0102 U+0177)
  0x01, 0x02, 0x01, 0x78, 0x01, // ĂŸ (U+0102 U+0178)
  0x01, 0x02, 0x20, 0x18, 0x01, // Ă‘ (U+0102 U+2018)
  0x01, 0x02, 0x20, 0x19, 0x01, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1C, 0x01, // Ă“ (U+0102 U+201C)
  0x01, 0x02, 0x20, 0x1D, 0x01, // Ă” (U+0102 U+201D)
  0x01, 0x02, 0x21, 0x22, 0x01, // Ă™ (U+0102 U+2122)
  0x01, 0x04, 0x00, 0x22, 0x01, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x01, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x00, 0x2A, 0x01, // Ą* (U+0104 U+002A)
  0x01, 0x04, 0x00, 0x3F, 0x01, // Ą? (U+0104 U+003F)
  0x01, 0x04, 0x00, 0x54, 0x01, // ĄT (U+0104 U+0054)
  0x01, 0x04, 0x00, 0x56, 0x01, // ĄV (U+0104 U+0056)
  0x01, 0x04, 0x00, 0x57, 0x01, // ĄW (U+0104 U+0057)
  0x01, 0x04, 0x00, 0x59, 0x01, // ĄY (U+0104 U+0059)
  0x01, 0x04, 0x00, 0x76, 0x01, // Ąv (U+0104 U+0076)
  0x01, 0x04, 0x00, 0x79, 0x01, // Ąy (U+0104 U+0079)
  0x01, 0x04, 0x00, 0xDD, 0x01, // ĄÝ (U+0104 U+00DD)
  0x01, 0x04, 0x00, 0xFD, 0x01, // Ąý (U+0104 U+00FD)
  0x01, 0x04, 0x00, 0xFF, 0x01, // Ąÿ (U+0104 U+00FF)
  0x01, 0x04, 0x01, 0x62, 0x01, // ĄŢ (U+0104 U+0162)
  0x01, 0x04, 0x01, 0x64, 0x01, // ĄŤ (U+0104 U+0164)
  0x01, 0x04, 0x01, 0x66, 0x01, // ĄŦ (U+0104 U+0166)
  0x01, 0x04, 0x01, 0x74, 0x01, // ĄŴ (U+0104 U+0174)
  0x01, 0x04, 0x01, 0x76, 0x01, // ĄŶ (U+0104 U+0176)
  0x01, 0x04, 0x01, 0x77, 0x01, // Ąŷ (U+0104 U+0177)
  0x01, 0x04, 0x01, 0x78, 0x01, // ĄŸ (U+0104 U+0178)
  0x01, 0x04, 0x20, 0x18, 0x01, // Ą‘ (U+0104 U+2018)
  0x01, 0x04, 0x20, 0x19, 0x01, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1C, 0x01, // Ą“ (U+0104 U+201C)
  0x01, 0x04, 0x20, 0x1D, 0x01, // Ą” (U+0104 U+201D)
  0x01, 0x04, 0x21, 0x22, 0x01, // Ą™ (U+0104 U+2122)
  0x01, 0x0E, 0x00, 0xC6, 0x01, // ĎÆ (U+010E U+00C6)
  0x01, 0x10, 0x00, 0xC6, 0x01, // ĐÆ (U+0110 U+00C6)
  0x01, 0x13, 0x00, 0x56, 0x01, // ēV (U+0113 U+0056)
  0x01, 0x13, 0x00, 0x57, 0x01, // ēW (U+0113 U+0057)
  0x01, 0x13, 0x00, 0x59, 0x01, // ēY (U+0113 U+0059)
  0x01, 0x13, 0x00, 0xDD, 0x01, // ēÝ (U+0113 U+00DD)
  0x01, 0x13, 0x01, 0x74, 0x01, // ēŴ (U+0113 U+0174)
  0x01, 0x13, 0x01, 0x76, 0x01, // ēŶ (U+0113 U+0176)
  0x01, 0x13, 0x01, 0x78, 0x01, // ēŸ (U+0113 U+0178)
  0x01, 0x15, 0x00, 0x56, 0x01, // ĕV (U+0115 U+0056)
  0x01, 0x15, 0x00, 0x57, 0x01, // ĕW (U+0115 U+0057)
  0x01, 0x15, 0x00, 0x59, 0x01, // ĕY (U+0115 U+0059)
  0x01, 0x15, 0x00, 0xDD, 0x01, // ĕÝ (U+0115 U+00DD)
  0x01, 0x15, 0x01, 0x74, 0x01, // ĕŴ (U+0115 U+0174)
  0x01, 0x15, 0x01, 0x76, 0x01, // ĕŶ (U+0115 U+0176)
  0x01, 0x15, 0x01, 0x78, 0x01, // ĕŸ (U+0115 U+0178)
  0x01, 0x17, 0x00, 0x56, 0x01, // ėV (U+0117 U+0056)
  0x01, 0x17, 0x00, 0x57, 0x01, // ėW (U+0117 U+0057)
  0x01, 0x17, 0x00, 0x59, 0x01, // ėY (U+0117 U+0059)
  0x01, 0x17, 0x00, 0xDD, 0x01, // ėÝ (U+0117 U+00DD)
  0x01, 0x17, 0x01, 0x74, 0x01, // ėŴ (U+0117 U+0174)
  0x01, 0x17, 0x01, 0x76, 0x01, // ėŶ (U+0117 U+0176)
  0x01, 0x17, 0x01, 0x78, 0x01, // ėŸ (U+0117 U+0178)
  0x01, 0x19, 0x00, 0x56, 0x01, // ęV (U+0119 U+0056)
  0x01, 0x19, 0x00, 0x57, 0x01, // ęW (U+0119 U+0057)
  0x01, 0x19, 0x00, 0x59, 0x01, // ęY (U+0119 U+0059)
  0x01, 0x19, 0x00, 0xDD, 0x01, // ęÝ (U+0119 U+00DD)
  0x01, 0x19, 0x01, 0x74, 0x01, // ęŴ (U+0119 U+0174)
  0x01, 0x19, 0x01, 0x76, 0x01, // ęŶ (U+0119 U+0176)
  0x01, 0x19, 0x01, 0x78, 0x01, // ęŸ (U+0119 U+0178)
  0x01, 0x1B, 0x00, 0x56, 0x01, // ěV (U+011B U+0056)
  0x01, 0x1B, 0x00, 0x57, 0x01, // ěW (U+011B U+0057)
  0x01, 0x1B, 0x00, 0x59, 0x01, // ěY (U+011B U+0059)
  0x01, 0x1B, 0x00, 0xDD, 0x01, // ěÝ (U+011B U+00DD)
  0x01, 0x1B, 0x01, 0x74, 0x01, // ěŴ (U+011B U+0174)
  0x01, 0x1B, 0x01, 0x76, 0x01, // ěŶ (U+011B U+0176)
  0x01, 0x1B, 0x01, 0x78, 0x01, // ěŸ (U+011B U+0178)
  0x01, 0x25, 0x00, 0x22, 0x01, // ĥ" (U+0125 U+0022)
  0x01, 0x25, 0x00, 0x27, 0x01, // ĥ' (U+0125 U+0027)
  0x01, 0x27, 0x00, 0x22, 0x01, // ħ" (U+0127 U+0022)
  0x01, 0x27, 0x00, 0x27, 0x01, // ħ' (U+0127 U+0027)
  0x01, 0x39, 0x00, 0x22, 0x01, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x01, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x00, 0x2A, 0x01, // Ĺ* (U+0139 U+002A)
  0x01, 0x39, 0x00, 0x3F, 0x01, // Ĺ? (U+0139 U+003F)
  0x01, 0x39, 0x00, 0x54, 0x01, // ĹT (U+0139 U+0054)
  0x01, 0x39, 0x00, 0x56, 0x01, // ĹV (U+0139 U+0056)
  0x01, 0x39, 0x00, 0x57, 0x01, // ĹW (U+0139 U+0057)
  0x01, 0x39, 0x00, 0x59, 0x01, // ĹY (U+0139 U+0059)
  0x01, 0x39, 0x00, 0xDD, 0x01, // ĹÝ (U+0139 U+00DD)
  0x01, 0x39, 0x01, 0x62, 0x01, // ĹŢ (U+0139 U+0162)
  0x01, 0x39, 0x01, 0x64, 0x01, // ĹŤ (U+0139 U+0164)
  0x01, 0x39, 0x01, 0x66, 0x01, // ĹŦ (U+0139 U+0166)
  0x01, 0x39, 0x01, 0x74, 0x01, // ĹŴ (U+0139 U+0174)
  0x01, 0x39, 0x01, 0x76, 0x01, // ĹŶ (U+0139 U+0176)
  0x01, 0x39, 0x01, 0x78, 0x01, // ĹŸ (U+0139 U+0178)
  0x01, 0x39, 0x20, 0x18, 0x01, // Ĺ‘ (U+0139 U+2018)
  0x01, 0x39, 0x20, 0x19, 0x01, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1C, 0x01, // Ĺ“ (U+0139 U+201C)
  0x01, 0x39, 0x20, 0x1D, 0x01, // Ĺ” (U+0139 U+201D)
  0x01, 0x39, 0x21, 0x22, 0x01, // Ĺ™ (U+0139 U+2122)
  0x01, 0x3B, 0x00, 0x22, 0x01, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x01, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x00, 0x2A, 0x01, // Ļ* (U+013B U+002A)
  0x01, 0x3B, 0x00, 0x3F, 0x01, // Ļ? (U+013B U+003F)
  0x01, 0x3B, 0x00, 0x54, 0x01, // ĻT (U+013B U+0054)
  0x01, 0x3B, 0x00, 0x56, 0x01, // ĻV (U+013B U+0056)
  0x01, 0x3B, 0x00, 0x57, 0x01, // ĻW (U+013B U+0057)
  0x01, 0x3B, 0x00, 0x59, 0x01, // ĻY (U+013B U+0059)
  0x01, 0x3B, 0x00, 0xDD, 0x01, // ĻÝ (U+013B U+00DD)
  0x01, 0x3B, 0x01, 0x62, 0x01, // ĻŢ (U+013B U+0162)
  0x01, 0x3B, 0x01, 0x64, 0x01, // ĻŤ (U+013B U+0164)
  0x01, 0x3B, 0x01, 0x66, 0x01, // ĻŦ (U+013B U+0166)
  0x01, 0x3B, 0x01, 0x74, 0x01, // ĻŴ (U+013B U+0174)
  0x01, 0x3B, 0x01, 0x76, 0x01, // ĻŶ (U+013B U+0176)
  0x01, 0x3B, 0x01, 0x78, 0x01, // ĻŸ (U+013B U+0178)
  0x01, 0x3B, 0x20, 0x18, 0x01, // Ļ‘ (U+013B U+2018)
  0x01, 0x3B, 0x20, 0x19, 0x01, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1C, 0x01, // Ļ“ (U+013B U+201C)
  0x01, 0x3B, 0x20, 0x1D, 0x01, // Ļ” (U+013B U+201D)
  0x01, 0x3B, 0x21, 0x22, 0x01, // Ļ™ (U+013B U+2122)
  0x01, 0x41, 0x00, 0x22, 0x01, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x01, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x00, 0x2A, 0x01, // Ł* (U+0141 U+002A)
  0x01, 0x41, 0x00, 0x3F, 0x01, // Ł? (U+0141 U+003F)
  0x01, 0x41, 0x00, 0x54, 0x01, // ŁT (U+0141 U+0054)
  0x01, 0x41, 0x00, 0x56, 0x01, // ŁV (U+0141 U+0056)
  0x01, 0x41, 0x00, 0x57, 0x01, // ŁW (U+0141 U+0057)
  0x01, 0x41, 0x00, 0x59, 0x01, // ŁY (U+0141 U+0059)
  0x01, 0x41, 0x00, 0xDD, 0x01, // ŁÝ (U+0141 U+00DD)
  0x01, 0x41, 0x01, 0x62, 0x01, // ŁŢ (U+0141 U+0162)
  0x01, 0x41, 0x01, 0x64, 0x01, // ŁŤ (U+0141 U+0164)
  0x01, 0x41, 0x01, 0x66, 0x01, // ŁŦ (U+0141 U+0166)
  0x01, 0x41, 0x01, 0x74, 0x01, // ŁŴ (U+0141 U+0174)
  0x01, 0x41, 0x01, 0x76, 0x01, // ŁŶ (U+0141 U+0176)
  0x01, 0x41, 0x01, 0x78, 0x01, // ŁŸ (U+0141 U+0178)
  0x01, 0x41, 0x20, 0x18, 0x01, // Ł‘ (U+0141 U+2018)
  0x01, 0x41, 0x20, 0x19, 0x01, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1C, 0x01, // Ł“ (U+0141 U+201C)
  0x01, 0x41, 0x20, 0x1D, 0x01, // Ł” (U+0141 U+201D)
  0x01, 0x41, 0x21, 0x22, 0x01, // Ł™ (U+0141 U+2122)
  0x01, 0x44, 0x00, 0x22, 0x01, // ń" (U+0144 U+0022)
  0x01, 0x44, 0x00, 0x27, 0x01, // ń' (U+0144 U+0027)
  0x01, 0x46, 0x00, 0x22, 0x01, // ņ" (U+0146 U+0022)
  0x01, 0x46, 0x00, 0x27, 0x01, // ņ' (U+0146 U+0027)
  0x01, 0x48, 0x00, 0x22, 0x01, // ň" (U+0148 U+0022)
  0x01, 0x48, 0x00, 0x27, 0x01, // ň' (U+0148 U+0027)
  0x01, 0x49, 0x00, 0x22, 0x01, // ŉ" (U+0149 U+0022)
  0x01, 0x49, 0x00, 0x27, 0x01, // ŉ' (U+0149 U+0027)
  0x01, 0x4B, 0x00, 0x22, 0x01, // ŋ" (U+014B U+0022)
  0x01, 0x4B, 0x00, 0x27, 0x01, // ŋ' (U+014B U+0027)
  0x01, 0x4C, 0x00, 0xC6, 0x01, // ŌÆ (U+014C U+00C6)
  0x01, 0x4D, 0x00, 0x56, 0x01, // ōV (U+014D U+0056)
  0x01, 0x4D, 0x00, 0x57, 0x01, // ōW (U+014D U+0057)
  0x01, 0x4D, 0x00, 0x59, 0x01, // ōY (U+014D U+0059)
  0x01, 0x4D, 0x00, 0xDD, 0x01, // ōÝ (U+014D U+00DD)
  0x01, 0x4D, 0x01, 0x74, 0x01, // ōŴ (U+014D U+0174)
  0x01, 0x4D, 0x01, 0x76, 0x01, // ōŶ (U+014D U+0176)
  0x01, 0x4D, 0x01, 0x78, 0x01, // ōŸ (U+014D U+0178)
  0x01, 0x4E, 0x00, 0xC6, 0x01, // ŎÆ (U+014E U+00C6)
  0x01, 0x4F, 0x00, 0x56, 0x01, // ŏV (U+014F U+0056)
  0x01, 0x4F, 0x00, 0x57, 0x01, // ŏW (U+014F U+0057)
  0x01, 0x4F, 0x00, 0x59, 0x01, // ŏY (U+014F U+0059)
  0x01, 0x4F, 0x00, 0xDD, 0x01, // ŏÝ (U+014F U+00DD)
  0x01, 0x4F, 0x01, 0x74, 0x01, // ŏŴ (U+014F U+0174)
  0x01, 0x4F, 0x01, 0x76, 0x01, // ŏŶ (U+014F U+0176)
  0x01, 0x4F, 0x01, 0x78, 0x01, // ŏŸ (U+014F U+0178)
  0x01, 0x50, 0x00, 0xC6, 0x01, // ŐÆ (U+0150 U+00C6)
  0x01, 0x51, 0x00, 0x56, 0x01, // őV (U+0151 U+0056)
  0x01, 0x51, 0x00, 0x57, 0x01, // őW (U+0151 U+0057)
  0x01, 0x51, 0x00, 0x59, 0x01, // őY (U+0151 U+0059)
  0x01, 0x51, 0x00, 0xDD, 0x01, // őÝ (U+0151 U+00DD)
  0x01, 0x51, 0x01, 0x74, 0x01, // őŴ (U+0151 U+0174)
  0x01, 0x51, 0x01, 0x76, 0x01, // őŶ (U+0151 U+0176)
  0x01, 0x51, 0x01, 0x78, 0x01, // őŸ (U+0151 U+0178)
  0x01, 0x53, 0x00, 0x56, 0x01, // œV (U+0153 U+0056)
  0x01, 0x53, 0x00, 0x57, 0x01, // œW (U+0153 U+0057)
  0x01, 0x53, 0x00, 0x59, 0x01, // œY (U+0153 U+0059)
  0x01, 0x53, 0x00, 0xDD, 0x01, // œÝ (U+0153 U+00DD)
  0x01, 0x53, 0x01, 0x74, 0x01, // œŴ (U+0153 U+0174)
  0x01, 0x53, 0x01, 0x76, 0x01, // œŶ (U+0153 U+0176)
  0x01, 0x53, 0x01, 0x78, 0x01, // œŸ (U+0153 U+0178)
  0x01, 0x55, 0x00, 0x2C, 0x02, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x02, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x20, 0x1A, 0x02, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x02, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x02, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x02, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x02, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x20, 0x1A, 0x02, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x02, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x02, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x02, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x02, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x20, 0x1A, 0x02, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x02, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x02, // ř… (U+0159 U+2026)
  0x01, 0x5B, 0x00, 0x59, 0x01, // śY (U+015B U+0059)
  0x01, 0x5B, 0x00, 0xDD, 0x01, // śÝ (U+015B U+00DD)
  0x01, 0x5B, 0x01, 0x76, 0x01, // śŶ (U+015B U+0176)
  0x01, 0x5B, 0x01, 0x78, 0x01, // śŸ (U+015B U+0178)
  0x01, 0x5D, 0x00, 0x59, 0x01, // ŝY (U+015D U+0059)
  0x01, 0x5D, 0x00, 0xDD, 0x01, // ŝÝ (U+015D U+00DD)
  0x01, 0x5D, 0x01, 0x76, 0x01, // ŝŶ (U+015D U+0176)
  0x01, 0x5D, 0x01, 0x78, 0x01, // ŝŸ (U+015D U+0178)
  0x01, 0x5F, 0x00, 0x59, 0x01, // şY (U+015F U+0059)
  0x01, 0x5F, 0x00, 0xDD, 0x01, // şÝ (U+015F U+00DD)
  0x01, 0x5F, 0x01, 0x76, 0x01, // şŶ (U+015F U+0176)
  0x01, 0x5F, 0x01, 0x78, 0x01, // şŸ (U+015F U+0178)
  0x01, 0x61, 0x00, 0x59, 0x01, // šY (U+0161 U+0059)
  0x01, 0x61, 0x00, 0xDD, 0x01, // šÝ (U+0161 U+00DD)
  0x01, 0x61, 0x01, 0x76, 0x01, // šŶ (U+0161 U+0176)
  0x01, 0x61, 0x01, 0x78, 0x01, // šŸ (U+0161 U+0178)
  0x01, 0x62, 0x00, 0x2C, 0x01, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2E, 0x01, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0x41, 0x01, // ŢA (U+0162 U+0041)
  0x01, 0x62, 0x00, 0xC0, 0x01, // ŢÀ (U+0162 U+00C0)
  0x01, 0x62, 0x00, 0xC1, 0x01, // ŢÁ (U+0162 U+00C1)
  0x01, 0x62, 0x00, 0xC2, 0x01, // ŢÂ (U+0162 U+00C2)
  0x01, 0x62, 0x00, 0xC3, 0x01, // ŢÃ (U+0162 U+00C3)
  0x01, 0x62, 0x00, 0xC4, 0x01, // ŢÄ (U+0162 U+00C4)
  0x01, 0x62, 0x00, 0xC5, 0x01, // ŢÅ (U+0162 U+00C5)
  0x01, 0x62, 0x00, 0xC6, 0x01, // ŢÆ (U+0162 U+00C6)
  0x01, 0x62, 0x01, 0x00, 0x01, // ŢĀ (U+0162 U+0100)
  0x01, 0x62, 0x01, 0x02, 0x01, // ŢĂ (U+0162 U+0102)
  0x01, 0x62, 0x01, 0x04, 0x01, // ŢĄ (U+0162 U+0104)
  0x01, 0x62, 0x20, 0x1A, 0x01, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x01, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x01, // Ţ… (U+0162 U+2026)
  0x01, 0x64, 0x00, 0x2C, 0x01, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2E, 0x01, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0x41, 0x01, // ŤA (U+0164 U+0041)
  0x01, 0x64, 0x00, 0xC0, 0x01, // ŤÀ (U+0164 U+00C0)
  0x01, 0x64, 0x00, 0xC1, 0x01, // ŤÁ (U+0164 U+00C1)
  0x01, 0x64, 0x00, 0xC2, 0x01, // ŤÂ (U+0164 U+00C2)
  0x01, 0x64, 0x00, 0xC3, 0x01, // ŤÃ (U+0164 U+00C3)
  0x01, 0x64, 0x00, 0xC4, 0x01, // ŤÄ (U+0164 U+00C4)
  0x01, 0x64, 0x00, 0xC5, 0x01, // ŤÅ (U+0164 U+00C5)
  0x01, 0x64, 0x00, 0xC6, 0x01, // ŤÆ (U+0164 U+00C6)
  0x01, 0x64, 0x01, 0x00, 0x01, // ŤĀ (U+0164 U+0100)
  0x01, 0x64, 0x01, 0x02, 0x01, // ŤĂ (U+0164 U+0102)
  0x01, 0x64, 0x01, 0x04, 0x01, // ŤĄ (U+0164 U+0104)
  0x01, 0x64, 0x20, 0x1A, 0x01, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x01, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x01, // Ť… (U+0164 U+2026)
  0x01, 0x66, 0x00, 0x2C, 0x01, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2E, 0x01, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0x41, 0x01, // ŦA (U+0166 U+0041)
  0x01, 0x66, 0x00, 0xC0, 0x01, // ŦÀ (U+0166 U+00C0)
  0x01, 0x66, 0x00, 0xC1, 0x01, // ŦÁ (U+0166 U+00C1)
  0x01, 0x66, 0x00, 0xC2, 0x01, // ŦÂ (U+0166 U+00C2)
  0x01, 0x66, 0x00, 0xC3, 0x01, // ŦÃ (U+0166 U+00C3)
  0x01, 0x66, 0x00, 0xC4, 0x01, // ŦÄ (U+0166 U+00C4)
  0x01, 0x66, 0x00, 0xC5, 0x01, // ŦÅ (U+0166 U+00C5)
  0x01, 0x66, 0x00, 0xC6, 0x01, // ŦÆ (U+0166 U+00C6)
  0x01, 0x66, 0x01, 0x00, 0x01, // ŦĀ (U+0166 U+0100)
  0x01, 0x66, 0x01, 0x02, 0x01, // ŦĂ (U+0166 U+0102)
  0x01, 0x66, 0x01, 0x04, 0x01, // ŦĄ (U+0166 U+0104)
  0x01, 0x66, 0x20, 0x1A, 0x01, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x01, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x01, // Ŧ… (U+0166 U+2026)
  0x01, 0x68, 0x00, 0xC6, 0x01, // ŨÆ (U+0168 U+00C6)
  0x01, 0x6A, 0x00, 0xC6, 0x01, // ŪÆ (U+016A U+00C6)
  0x01, 0x6C, 0x00, 0xC6, 0x01, // ŬÆ (U+016C U+00C6)
  0x01, 0x6E, 0x00, 0xC6, 0x01, // ŮÆ (U+016E U+00C6)
  0x01, 0x70, 0x00, 0xC6, 0x01, // ŰÆ (U+0170 U+00C6)
  0x01, 0x72, 0x00, 0xC6, 0x01, // ŲÆ (U+0172 U+00C6)
  0x01, 0x74, 0x00, 0x2C, 0x01, // Ŵ, (U+0174 U+002C)
  0x01, 0x74, 0x00, 0x2E, 0x01, // Ŵ. (U+0174 U+002E)
  0x01, 0x74, 0x00, 0x40, 0x01, // Ŵ@ (U+0174 U+0040)
  0x01, 0x74, 0x00, 0x41, 0x01, // ŴA (U+0174 U+0041)
  0x01, 0x74, 0x00, 0x61, 0x01, // Ŵa (U+0174 U+0061)
  0x01, 0x74, 0x00, 0x63, 0x01, // Ŵc (U+0174 U+0063)
  0x01, 0x74, 0x00, 0x64, 0x01, // Ŵd (U+0174 U+0064)
  0x01, 0x74, 0x00, 0x65, 0x01, // Ŵe (U+0174 U+0065)
  0x01, 0x74, 0x00, 0x67, 0x01, // Ŵg (U+0174 U+0067)
  0x01, 0x74, 0x00, 0x6F, 0x01, // Ŵo (U+0174 U+006F)
  0x01, 0x74, 0x00, 0x71, 0x01, // Ŵq (U+0174 U+0071)
  0x01, 0x74, 0x00, 0x73, 0x01, // Ŵs (U+0174 U+0073)
  0x01, 0x74, 0x00, 0xC0, 0x01, // ŴÀ (U+0174 U+00C0)
  0x01, 0x74, 0x00, 0xC1, 0x01, // ŴÁ (U+0174 U+00C1)
  0x01, 0x74, 0x00, 0xC2, 0x01, // ŴÂ (U+0174 U+00C2)
  0x01, 0x74, 0x00, 0xC3, 0x01, // ŴÃ (U+0174 U+00C3)
  0x01, 0x74, 0x00, 0xC4, 0x01, // ŴÄ (U+0174 U+00C4)
  0x01, 0x74, 0x00, 0xC5, 0x01, // ŴÅ (U+0174 U+00C5)
  0x01, 0x74, 0x00, 0xC6, 0x02, // ŴÆ (U+0174 U+00C6)
  0x01, 0x74, 0x00, 0xE0, 0x01, // Ŵà (U+0174 U+00E0)
  0x01, 0x74, 0x00, 0xE1, 0x01, // Ŵá (U+0174 U+00E1)
  0x01, 0x74, 0x00, 0xE2, 0x01, // Ŵâ (U+0174 U+00E2)
  0x01, 0x74, 0x00, 0xE3, 0x01, // Ŵã (U+0174 U+00E3)
  0x01, 0x74, 0x00, 0xE4, 0x01, // Ŵä (U+0174 U+00E4)
  0x01, 0x74, 0x00, 0xE5, 0x01, // Ŵå (U+0174 U+00E5)
  0x01, 0x74, 0x00, 0xE6, 0x01, // Ŵæ (U+0174 U+00E6)
  0x01, 0x74, 0x00, 0xE7, 0x01, // Ŵç (U+0174 U+00E7)
  0x01, 0x74, 0x00, 0xE8, 0x01, // Ŵè (U+0174 U+00E8)
  0x01, 0x74, 0x00, 0xE9, 0x01, // Ŵé (U+0174 U+00E9)
  0x01, 0x74, 0x00, 0xEA, 0x01, // Ŵê (U+0174 U+00EA)
  0x01, 0x74, 0x00, 0xEB, 0x01, // Ŵë (U+0174 U+00EB)
  0x01, 0x74, 0x00, 0xF0, 0x01, // Ŵð (U+0174 U+00F0)
  0x01, 0x74, 0x00, 0xF2, 0x01, // Ŵò (U+0174 U+00F2)
  0x01, 0x74, 0x00, 0xF3, 0x01, // Ŵó (U+0174 U+00F3)
  0x01, 0x74, 0x00, 0xF4, 0x01, // Ŵô (U+0174 U+00F4)
  0x01, 0x74, 0x00, 0xF5, 0x01, // Ŵõ (U+0174 U+00F5)
  0x01, 0x74, 0x00, 0xF6, 0x01, // Ŵö (U+0174 U+00F6)
  0x01, 0x74, 0x00, 0xF8, 0x01, // Ŵø (U+0174 U+00F8)
  0x01, 0x74, 0x01, 0x00, 0x01, // ŴĀ (U+0174 U+0100)
  0x01, 0x74, 0x01, 0x01, 0x01, // Ŵā (U+0174 U+0101)
  0x01, 0x74, 0x01, 0x02, 0x01, // ŴĂ (U+0174 U+0102)
  0x01, 0x74, 0x01, 0x03, 0x01, // Ŵă (U+0174 U+0103)
  0x01, 0x74, 0x01, 0x04, 0x01, // ŴĄ (U+0174 U+0104)
  0x01, 0x74, 0x01, 0x05, 0x01, // Ŵą (U+0174 U+0105)
  0x01, 0x74, 0x01, 0x07, 0x01, // Ŵć (U+0174 U+0107)
  0x01, 0x74, 0x01, 0x09, 0x01, // Ŵĉ (U+0174 U+0109)
  0x01, 0x74, 0x01, 0x0B, 0x01, // Ŵċ (U+0174 U+010B)
  0x01, 0x74, 0x01, 0x0D, 0x01, // Ŵč (U+0174 U+010D)
  0x01, 0x74, 0x01, 0x0F, 0x01, // Ŵď (U+0174 U+010F)
  0x01, 0x74, 0x01, 0x11, 0x01, // Ŵđ (U+0174 U+0111)
  0x01, 0x74, 0x01, 0x13, 0x01, // Ŵē (U+0174 U+0113)
  0x01, 0x74, 0x01, 0x15, 0x01, // Ŵĕ (U+0174 U+0115)
  0x01, 0x74, 0x01, 0x17, 0x01, // Ŵė (U+0174 U+0117)
  0x01, 0x74, 0x01, 0x19, 0x01, // Ŵę (U+0174 U+0119)
  0x01, 0x74, 0x01, 0x1B, 0x01, // Ŵě (U+0174 U+011B)
  0x01, 0x74, 0x01, 0x1D, 0x01, // Ŵĝ (U+0174 U+011D)
  0x01, 0x74, 0x01, 0x1F, 0x01, // Ŵğ (U+0174 U+011F)
  0x01, 0x74, 0x01, 0x21, 0x01, // Ŵġ (U+0174 U+0121)
  0x01, 0x74, 0x01, 0x23, 0x01, // Ŵģ (U+0174 U+0123)
  0x01, 0x74, 0x01, 0x4D, 0x01, // Ŵō (U+0174 U+014D)
  0x01, 0x74, 0x01, 0x4F, 0x01, // Ŵŏ (U+0174 U+014F)
  0x01, 0x74, 0x01, 0x51, 0x01, // Ŵő (U+0174 U+0151)
  0x01, 0x74, 0x01, 0x53, 0x01, // Ŵœ (U+0174 U+0153)
  0x01, 0x74, 0x01, 0x5B, 0x01, // Ŵś (U+0174 U+015B)
  0x01, 0x74, 0x01, 0x5D, 0x01, // Ŵŝ (U+0174 U+015D)
  0x01, 0x74, 0x01, 0x5F, 0x01, // Ŵş (U+0174 U+015F)
  0x01, 0x74, 0x01, 0x61, 0x01, // Ŵš (U+0174 U+0161)
  0x01, 0x74, 0x20, 0x1A, 0x01, // Ŵ‚ (U+0174 U+201A)
  0x01, 0x74, 0x20, 0x1E, 0x01, // Ŵ„ (U+0174 U+201E)
  0x01, 0x74, 0x20, 0x26, 0x01, // Ŵ… (U+0174 U+2026)
  0x01, 0x75, 0x00, 0x2C, 0x01, // ŵ, (U+0175 U+002C)
  0x01, 0x75, 0x00, 0x2E, 0x01, // ŵ. (U+0175 U+002E)
  0x01, 0x75, 0x20, 0x1A, 0x01, // ŵ‚ (U+0175 U+201A)
  0x01, 0x75, 0x20, 0x1E, 0x01, // ŵ„ (U+0175 U+201E)
  0x01, 0x75, 0x20, 0x26, 0x01, // ŵ… (U+0175 U+2026)
  0x01, 0x76, 0x00, 0x2C, 0x01, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x01, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x00, 0x40, 0x01, // Ŷ@ (U+0176 U+0040)
  0x01, 0x76, 0x00, 0x41, 0x01, // ŶA (U+0176 U+0041)
  0x01, 0x76, 0x00, 0x61, 0x01, // Ŷa (U+0176 U+0061)
  0x01, 0x76, 0x00, 0x63, 0x01, // Ŷc (U+0176 U+0063)
  0x01, 0x76, 0x00, 0x64, 0x01, // Ŷd (U+0176 U+0064)
  0x01, 0x76, 0x00, 0x65, 0x01, // Ŷe (U+0176 U+0065)
  0x01, 0x76, 0x00, 0x67, 0x01, // Ŷg (U+0176 U+0067)
  0x01, 0x76, 0x00, 0x6F, 0x01, // Ŷo (U+0176 U+006F)
  0x01, 0x76, 0x00, 0x71, 0x01, // Ŷq (U+0176 U+0071)
  0x01, 0x76, 0x00, 0x73, 0x01, // Ŷs (U+0176 U+0073)
  0x01, 0x76, 0x00, 0xC0, 0x01, // ŶÀ (U+0176 U+00C0)
  0x01, 0x76, 0x00, 0xC1, 0x01, // ŶÁ (U+0176 U+00C1)
  0x01, 0x76, 0x00, 0xC2, 0x01, // ŶÂ (U+0176 U+00C2)
  0x01, 0x76, 0x00, 0xC3, 0x01, // ŶÃ (U+0176 U+00C3)
  0x01, 0x76, 0x00, 0xC4, 0x01, // ŶÄ (U+0176 U+00C4)
  0x01, 0x76, 0x00, 0xC5, 0x01, // ŶÅ (U+0176 U+00C5)
  0x01, 0x76, 0x00, 0xC6, 0x01, // ŶÆ (U+0176 U+00C6)
  0x01, 0x76, 0x00, 0xE0, 0x01, // Ŷà (U+0176 U+00E0)
  0x01, 0x76, 0x00, 0xE1, 0x01, // Ŷá (U+0176 U+00E1)
  0x01, 0x76, 0x00, 0xE2, 0x01, // Ŷâ (U+0176 U+00E2)
  0x01, 0x76, 0x00, 0xE3, 0x01, // Ŷã (U+0176 U+00E3)
  0x01, 0x76, 0x00, 0xE4, 0x01, // Ŷä (U+0176 U+00E4)
  0x01, 0x76, 0x00, 0xE5, 0x01, // Ŷå (U+0176 U+00E5)
  0x01, 0x76, 0x00, 0xE6, 0x01, // Ŷæ (U+0176 U+00E6)
  0x01, 0x76, 0x00, 0xE7, 0x01, // Ŷç (U+0176 U+00E7)
  0x01, 0x76, 0x00, 0xE8, 0x01, // Ŷè (U+0176 U+00E8)
  0x01, 0x76, 0x00, 0xE9, 0x01, // Ŷé (U+0176 U+00E9)
  0x01, 0x76, 0x00, 0xEA, 0x01, // Ŷê (U+0176 U+00EA)
  0x01, 0x76, 0x00, 0xEB, 0x01, // Ŷë (U+0176 U+00EB)
  0x01, 0x76, 0x00, 0xF0, 0x01, // Ŷð (U+0176 U+00F0)
  0x01, 0x76, 0x00, 0xF2, 0x01, // Ŷò (U+0176 U+00F2)
  0x01, 0x76, 0x00, 0xF3, 0x01, // Ŷó (U+0176 U+00F3)
  0x01, 0x76, 0x00, 0xF4, 0x01, // Ŷô (U+0176 U+00F4)
  0x01, 0x76, 0x00, 0xF5, 0x01, // Ŷõ (U+0176 U+00F5)
  0x01, 0x76, 0x00, 0xF6, 0x01, // Ŷö (U+0176 U+00F6)
  0x01, 0x76, 0x00, 0xF8, 0x01, // Ŷø (U+0176 U+00F8)
  0x01, 0x76, 0x01, 0x00, 0x01, // ŶĀ (U+0176 U+0100)
  0x01, 0x76, 0x01, 0x01, 0x01, // Ŷā (U+0176 U+0101)
  0x01, 0x76, 0x01, 0x02, 0x01, // ŶĂ (U+0176 U+0102)
  0x01, 0x76, 0x01, 0x03, 0x01, // Ŷă (U+0176 U+0103)
  0x01, 0x76, 0x01, 0x04, 0x01, // ŶĄ (U+0176 U+0104)
  0x01, 0x76, 0x01, 0x05, 0x01, // Ŷą (U+0176 U+0105)
  0x01, 0x76, 0x01, 0x07, 0x01, // Ŷć (U+0176 U+0107)
  0x01, 0x76, 0x01, 0x09, 0x01, // Ŷĉ (U+0176 U+0109)
  0x01, 0x76, 0x01, 0x0B, 0x01, // Ŷċ (U+0176 U+010B)
  0x01, 0x76, 0x01, 0x0D, 0x01, // Ŷč (U+0176 U+010D)
  0x01, 0x76, 0x01, 0x0F, 0x01, // Ŷď (U+0176 U+010F)
  0x01, 0x76, 0x01, 0x11, 0x01, // Ŷđ (U+0176 U+0111)
  0x01, 0x76, 0x01, 0x13, 0x01, // Ŷē (U+0176 U+0113)
  0x01, 0x76, 0x01, 0x15, 0x01, // Ŷĕ (U+0176 U+0115)
  0x01, 0x76, 0x01, 0x17, 0x01, // Ŷė (U+0176 U+0117)
  0x01, 0x76, 0x01, 0x19, 0x01, // Ŷę (U+0176 U+0119)
  0x01, 0x76, 0x01, 0x1B, 0x01, // Ŷě (U+0176 U+011B)
  0x01, 0x76, 0x01, 0x1D, 0x01, // Ŷĝ (U+0176 U+011D)
  0x01, 0x76, 0x01, 0x1F, 0x01, // Ŷğ (U+0176 U+011F)
  0x01, 0x76, 0x01, 0x21, 0x01, // Ŷġ (U+0176 U+0121)
  0x01, 0x76, 0x01, 0x23, 0x01, // Ŷģ (U+0176 U+0123)
  0x01, 0x76, 0x01, 0x4D, 0x01, // Ŷō (U+0176 U+014D)
  0x01, 0x76, 0x01, 0x4F, 0x01, // Ŷŏ (U+0176 U+014F)
  0x01, 0x76, 0x01, 0x51, 0x01, // Ŷő (U+0176 U+0151)
  0x01, 0x76, 0x01, 0x53, 0x01, // Ŷœ (U+0176 U+0153)
  0x01, 0x76, 0x01, 0x5B, 0x01, // Ŷś (U+0176 U+015B)
  0x01, 0x76, 0x01, 0x5D, 0x01, // Ŷŝ (U+0176 U+015D)
  0x01, 0x76, 0x01, 0x5F, 0x01, // Ŷş (U+0176 U+015F)
  0x01, 0x76, 0x01, 0x61, 0x01, // Ŷš (U+0176 U+0161)
  0x01, 0x76, 0x20, 0x1A, 0x01, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x01, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x01, // Ŷ… (U+0176 U+2026)
  0x01, 0x77, 0x00, 0x2C, 0x01, // ŷ, (U+0177 U+002C)
  0x01, 0x77, 0x00, 0x2E, 0x01, // ŷ. (U+0177 U+002E)
  0x01, 0x77, 0x00, 0x41, 0x01, // ŷA (U+0177 U+0041)
  0x01, 0x77, 0x00, 0xC0, 0x01, // ŷÀ (U+0177 U+00C0)
  0x01, 0x77, 0x00, 0xC1, 0x01, // ŷÁ (U+0177 U+00C1)
  0x01, 0x77, 0x00, 0xC2, 0x01, // ŷÂ (U+0177 U+00C2)
  0x01, 0x77, 0x00, 0xC3, 0x01, // ŷÃ (U+0177 U+00C3)
  0x01, 0x77, 0x00, 0xC4, 0x01, // ŷÄ (U+0177 U+00C4)
  0x01, 0x77, 0x00, 0xC5, 0x01, // ŷÅ (U+0177 U+00C5)
  0x01, 0x77, 0x01, 0x00, 0x01, // ŷĀ (U+0177 U+0100)
  0x01, 0x77, 0x01, 0x02, 0x01, // ŷĂ (U+0177 U+0102)
  0x01, 0x77, 0x01, 0x04, 0x01, // ŷĄ (U+0177 U+0104)
  0x01, 0x77, 0x20, 0x1A, 0x01, // ŷ‚ (U+0177 U+201A)
  0x01, 0x77, 0x20, 0x1E, 0x01, // ŷ„ (U+0177 U+201E)
  0x01, 0x77, 0x20, 0x26, 0x01, // ŷ… (U+0177 U+2026)
  0x01, 0x78, 0x00, 0x2C, 0x01, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x01, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x00, 0x40, 0x01, // Ÿ@ (U+0178 U+0040)
  0x01, 0x78, 0x00, 0x41, 0x01, // ŸA (U+0178 U+0041)
  0x01, 0x78, 0x00, 0x61, 0x01, // Ÿa (U+0178 U+0061)
  0x01, 0x78, 0x00, 0x63, 0x01, // Ÿc (U+0178 U+0063)
  0x01, 0x78, 0x00, 0x64, 0x01, // Ÿd (U+0178 U+0064)
  0x01, 0x78, 0x00, 0x65, 0x01, // Ÿe (U+0178 U+0065)
  0x01, 0x78, 0x00, 0x67, 0x01, // Ÿg (U+0178 U+0067)
  0x01, 0x78, 0x00, 0x6F, 0x01, // Ÿo (U+0178 U+006F)
  0x01, 0x78, 0x00, 0x71, 0x01, // Ÿq (U+0178 U+0071)
  0x01, 0x78, 0x00, 0x73, 0x01, // Ÿs (U+0178 U+0073)
  0x01, 0x78, 0x00, 0xC0, 0x01, // ŸÀ (U+0178 U+00C0)
  0x01, 0x78, 0x00, 0xC1, 0x01, // ŸÁ (U+0178 U+00C1)
  0x01, 0x78, 0x00, 0xC2, 0x01, // ŸÂ (U+0178 U+00C2)
  0x01, 0x78, 0x00, 0xC3, 0x01, // ŸÃ (U+0178 U+00C3)
  0x01, 0x78, 0x00, 0xC4, 0x01, // ŸÄ (U+0178 U+00C4)
  0x01, 0x78, 0x00, 0xC5, 0x01, // ŸÅ (U+0178 U+00C5)
  0x01, 0x78, 0x00, 0xC6, 0x01, // ŸÆ (U+0178 U+00C6)
  0x01, 0x78, 0x00, 0xE0, 0x01, // Ÿà (U+0178 U+00E0)
  0x01, 0x78, 0x00, 0xE1, 0x01, // Ÿá (U+0178 U+00E1)
  0x01, 0x78, 0x00, 0xE2, 0x01, // Ÿâ (U+0178 U+00E2)
  0x01, 0x78, 0x00, 0xE3, 0x01, // Ÿã (U+0178 U+00E3)
  0x01, 0x78, 0x00, 0xE4, 0x01, // Ÿä (U+0178 U+00E4)
  0x01, 0x78, 0x00, 0xE5, 0x01, // Ÿå (U+0178 U+00E5)
  0x01, 0x78, 0x00, 0xE6, 0x01, // Ÿæ (U+0178 U+00E6)
  0x01, 0x78, 0x00, 0xE7, 0x01, // Ÿç (U+0178 U+00E7)
  0x01, 0x78, 0x00, 0xE8, 0x01, // Ÿè (U+0178 U+00E8)
  0x01, 0x78, 0x00, 0xE9, 0x01, // Ÿé (U+0178 U+00E9)
  0x01, 0x78, 0x00, 0xEA, 0x01, // Ÿê (U+0178 U+00EA)
  0x01, 0x78, 0x00, 0xEB, 0x01, // Ÿë (U+0178 U+00EB)
  0x01, 0x78, 0x00, 0xF0, 0x01, // Ÿð (U+0178 U+00F0)
  0x01, 0x78, 0x00, 0xF2, 0x01, // Ÿò (U+0178 U+00F2)
  0x01, 0x78, 0x00, 0xF3, 0x01, // Ÿó (U+0178 U+00F3)
  0x01, 0x78, 0x00, 0xF4, 0x01, // Ÿô (U+0178 U+00F4)
  0x01, 0x78, 0x00, 0xF5, 0x01, // Ÿõ (U+0178 U+00F5)
  0x01, 0x78, 0x00, 0xF6, 0x01, // Ÿö (U+0178 U+00F6)
  0x01, 0x78, 0x00, 0xF8, 0x01, // Ÿø (U+0178 U+00F8)
  0x01, 0x78, 0x01, 0x00, 0x01, // ŸĀ (U+0178 U+0100)
  0x01, 0x78, 0x01, 0x01, 0x01, // Ÿā (U+0178 U+0101)
  0x01, 0x78, 0x01, 0x02, 0x01, // ŸĂ (U+0178 U+0102)
  0x01, 0x78, 0x01, 0x03, 0x01, // Ÿă (U+0178 U+0103)
  0x01, 0x78, 0x01, 0x04, 0x01, // ŸĄ (U+0178 U+0104)
  0x01, 0x78, 0x01, 0x05, 0x01, // Ÿą (U+0178 U+0105)
  0x01, 0x78, 0x01, 0x07, 0x01, // Ÿć (U+0178 U+0107)
  0x01, 0x78, 0x01, 0x09, 0x01, // Ÿĉ (U+0178 U+0109)
  0x01, 0x78, 0x01, 0x0B, 0x01, // Ÿċ (U+0178 U+010B)
  0x01, 0x78, 0x01, 0x0D, 0x01, // Ÿč (U+0178 U+010D)
  0x01, 0x78, 0x01, 0x0F, 0x01, // Ÿď (U+0178 U+010F)
  0x01, 0x78, 0x01, 0x11, 0x01, // Ÿđ (U+0178 U+0111)
  0x01, 0x78, 0x01, 0x13, 0x01, // Ÿē (U+0178 U+0113)
  0x01, 0x78, 0x01, 0x15, 0x01, // Ÿĕ (U+0178 U+0115)
  0x01, 0x78, 0x01, 0x17, 0x01, // Ÿė (U+0178 U+0117)
  0x01, 0x78, 0x01, 0x19, 0x01, // Ÿę (U+0178 U+0119)
  0x01, 0x78, 0x01, 0x1B, 0x01, // Ÿě (U+0178 U+011B)
  0x01, 0x78, 0x01, 0x1D, 0x01, // Ÿĝ (U+0178 U+011D)
  0x01, 0x78, 0x01, 0x1F, 0x01, // Ÿğ (U+0178 U+011F)
  0x01, 0x78, 0x01, 0x21, 0x01, // Ÿġ (U+0178 U+0121)
  0x01, 0x78, 0x01, 0x23, 0x01, // Ÿģ (U+0178 U+0123)
  0x01, 0x78, 0x01, 0x4D, 0x01, // Ÿō (U+0178 U+014D)
  0x01, 0x78, 0x01, 0x4F, 0x01, // Ÿŏ (U+0178 U+014F)
  0x01, 0x78, 0x01, 0x51, 0x01, // Ÿő (U+0178 U+0151)
  0x01, 0x78, 0x01, 0x53, 0x01, // Ÿœ (U+0178 U+0153)
  0x01, 0x78, 0x01, 0x5B, 0x01, // Ÿś (U+0178 U+015B)
  0x01, 0x78, 0x01, 0x5D, 0x01, // Ÿŝ (U+0178 U+015D)
  0x01, 0x78, 0x01, 0x5F, 0x01, // Ÿş (U+0178 U+015F)
  0x01, 0x78, 0x01, 0x61, 0x01, // Ÿš (U+0178 U+0161)
  0x01, 0x78, 0x20, 0x1A, 0x01, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x01, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x01, // Ÿ… (U+0178 U+2026)
  0x20, 0x18, 0x00, 0x41, 0x01, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0xC0, 0x01, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x01, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x01, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x01, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x01, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x01, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xC6, 0x02, // ‘Æ (U+2018 U+00C6)
  0x20, 0x18, 0x01, 0x00, 0x01, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x02, 0x01, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x04, 0x01, // ‘Ą (U+2018 U+0104)
  0x20, 0x19, 0x00, 0x41, 0x02, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0x63, 0x01, // ’c (U+2019 U+0063)
  0x20, 0x19, 0x00, 0x64, 0x01, // ’d (U+2019 U+0064)
  0x20, 0x19, 0x00, 0x65, 0x01, // ’e (U+2019 U+0065)
  0x20, 0x19, 0x00, 0x67, 0x01, // ’g (U+2019 U+0067)
  0x20, 0x19, 0x00, 0x6F, 0x01, // ’o (U+2019 U+006F)
  0x20, 0x19, 0x00, 0x71, 0x01, // ’q (U+2019 U+0071)
  0x20, 0x19, 0x00, 0x73, 0x01, // ’s (U+2019 U+0073)
  0x20, 0x19, 0x00, 0xC0, 0x02, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x02, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x02, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x02, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x02, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x02, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xE7, 0x01, // ’ç (U+2019 U+00E7)
  0x20, 0x19, 0x00, 0xE8, 0x01, // ’è (U+2019 U+00E8)
  0x20, 0x19, 0x00, 0xE9, 0x01, // ’é (U+2019 U+00E9)
  0x20, 0x19, 0x00, 0xEA, 0x01, // ’ê (U+2019 U+00EA)
  0x20, 0x19, 0x00, 0xEB, 0x01, // ’ë (U+2019 U+00EB)
  0x20, 0x19, 0x00, 0xF0, 0x01, // ’ð (U+2019 U+00F0)
  0x20, 0x19, 0x00, 0xF2, 0x01, // ’ò (U+2019 U+00F2)
  0x20, 0x19, 0x00, 0xF3, 0x01, // ’ó (U+2019 U+00F3)
  0x20, 0x19, 0x00, 0xF4, 0x01, // ’ô (U+2019 U+00F4)
  0x20, 0x19, 0x00, 0xF5, 0x01, // ’õ (U+2019 U+00F5)
  0x20, 0x19, 0x00, 0xF6, 0x01, // ’ö (U+2019 U+00F6)
  0x20, 0x19, 0x00, 0xF8, 0x01, // ’ø (U+2019 U+00F8)
  0x20, 0x19, 0x01, 0x00, 0x02, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x02, 0x02, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x04, 0x02, // ’Ą (U+2019 U+0104)
  0x20, 0x19, 0x01, 0x07, 0x01, // ’ć (U+2019 U+0107)
  0x20, 0x19, 0x01, 0x09, 0x01, // ’ĉ (U+2019 U+0109)
  0x20, 0x19, 0x01, 0x0B, 0x01, // ’ċ (U+2019 U+010B)
  0x20, 0x19, 0x01, 0x0D, 0x01, // ’č (U+2019 U+010D)
  0x20, 0x19, 0x01, 0x0F, 0x01, // ’ď (U+2019 U+010F)
  0x20, 0x19, 0x01, 0x11, 0x01, // ’đ (U+2019 U+0111)
  0x20, 0x19, 0x01, 0x13, 0x01, // ’ē (U+2019 U+0113)
  0x20, 0x19, 0x01, 0x15, 0x01, // ’ĕ (U+2019 U+0115)
  0x20, 0x19, 0x01, 0x17, 0x01, // ’ė (U+2019 U+0117)
  0x20, 0x19, 0x01, 0x19, 0x01, // ’ę (U+2019 U+0119)
  0x20, 0x19, 0x01, 0x1B, 0x01, // ’ě (U+2019 U+011B)
  0x20, 0x19, 0x01, 0x1D, 0x01, // ’ĝ (U+2019 U+011D)
  0x20, 0x19, 0x01, 0x1F, 0x01, // ’ğ (U+2019 U+011F)
  0x20, 0x19, 0x01, 0x21, 0x01, // ’ġ (U+2019 U+0121)
  0x20, 0x19, 0x01, 0x23, 0x01, // ’ģ (U+2019 U+0123)
  0x20, 0x19, 0x01, 0x4D, 0x01, // ’ō (U+2019 U+014D)
  0x20, 0x19, 0x01, 0x4F, 0x01, // ’ŏ (U+2019 U+014F)
  0x20, 0x19, 0x01, 0x51, 0x01, // ’ő (U+2019 U+0151)
  0x20, 0x19, 0x01, 0x53, 0x01, // ’œ (U+2019 U+0153)
  0x20, 0x19, 0x01, 0x5B, 0x01, // ’ś (U+2019 U+015B)
  0x20, 0x19, 0x01, 0x5D, 0x01, // ’ŝ (U+2019 U+015D)
  0x20, 0x19, 0x01, 0x5F, 0x01, // ’ş (U+2019 U+015F)
  0x20, 0x19, 0x01, 0x61, 0x01, // ’š (U+2019 U+0161)
  0x20, 0x1A, 0x00, 0x3F, 0x01, // ‚? (U+201A U+003F)
  0x20, 0x1A, 0x00, 0x54, 0x01, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x56, 0x02, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x01, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x01, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0x76, 0x01, // ‚v (U+201A U+0076)
  0x20, 0x1A, 0x00, 0x77, 0x01, // ‚w (U+201A U+0077)
  0x20, 0x1A, 0x00, 0x79, 0x01, // ‚y (U+201A U+0079)
  0x20, 0x1A, 0x00, 0xDD, 0x01, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x00, 0xFD, 0x01, // ‚ý (U+201A U+00FD)
  0x20, 0x1A, 0x00, 0xFF, 0x01, // ‚ÿ (U+201A U+00FF)
  0x20, 0x1A, 0x01, 0x62, 0x01, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x01, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x01, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1A, 0x01, 0x74, 0x01, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x75, 0x01, // ‚ŵ (U+201A U+0175)
  0x20, 0x1A, 0x01, 0x76, 0x01, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x77, 0x01, // ‚ŷ (U+201A U+0177)
  0x20, 0x1A, 0x01, 0x78, 0x01, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x01, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0xC0, 0x01, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x01, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x01, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x01, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x01, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x01, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xC6, 0x02, // “Æ (U+201C U+00C6)
  0x20, 0x1C, 0x01, 0x00, 0x01, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x02, 0x01, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x04, 0x01, // “Ą (U+201C U+0104)
  0x20, 0x1D, 0x00, 0x41, 0x02, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0x63, 0x01, // ”c (U+201D U+0063)
  0x20, 0x1D, 0x00, 0x64, 0x01, // ”d (U+201D U+0064)
  0x20, 0x1D, 0x00, 0x65, 0x01, // ”e (U+201D U+0065)
  0x20, 0x1D, 0x00, 0x67, 0x01, // ”g (U+201D U+0067)
  0x20, 0x1D, 0x00, 0x6F, 0x01, // ”o (U+201D U+006F)
  0x20, 0x1D, 0x00, 0x71, 0x01, // ”q (U+201D U+0071)
  0x20, 0x1D, 0x00, 0x73, 0x01, // ”s (U+201D U+0073)
  0x20, 0x1D, 0x00, 0xC0, 0x02, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x02, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x02, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x02, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x02, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x02, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xE7, 0x01, // ”ç (U+201D U+00E7)
  0x20, 0x1D, 0x00, 0xE8, 0x01, // ”è (U+201D U+00E8)
  0x20, 0x1D, 0x00, 0xE9, 0x01, // ”é (U+201D U+00E9)
  0x20, 0x1D, 0x00, 0xEA, 0x01, // ”ê (U+201D U+00EA)
  0x20, 0x1D, 0x00, 0xEB, 0x01, // ”ë (U+201D U+00EB)
  0x20, 0x1D, 0x00, 0xF0, 0x01, // ”ð (U+201D U+00F0)
  0x20, 0x1D, 0x00, 0xF2, 0x01, // ”ò (U+201D U+00F2)
  0x20, 0x1D, 0x00, 0xF3, 0x01, // ”ó (U+201D U+00F3)
  0x20, 0x1D, 0x00, 0xF4, 0x01, // ”ô (U+201D U+00F4)
  0x20, 0x1D, 0x00, 0xF5, 0x01, // ”õ (U+201D U+00F5)
  0x20, 0x1D, 0x00, 0xF6, 0x01, // ”ö (U+201D U+00F6)
  0x20, 0x1D, 0x00, 0xF8, 0x01, // ”ø (U+201D U+00F8)
  0x20, 0x1D, 0x01, 0x00, 0x02, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x02, 0x02, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x04, 0x02, // ”Ą (U+201D U+0104)
  0x20, 0x1D, 0x01, 0x07, 0x01, // ”ć (U+201D U+0107)
  0x20, 0x1D, 0x01, 0x09, 0x01, // ”ĉ (U+201D U+0109)
  0x20, 0x1D, 0x01, 0x0B, 0x01, // ”ċ (U+201D U+010B)
  0x20, 0x1D, 0x01, 0x0D, 0x01, // ”č (U+201D U+010D)
  0x20, 0x1D, 0x01, 0x0F, 0x01, // ”ď (U+201D U+010F)
  0x20, 0x1D, 0x01, 0x11, 0x01, // ”đ (U+201D U+0111)
  0x20, 0x1D, 0x01, 0x13, 0x01, // ”ē (U+201D U+0113)
  0x20, 0x1D, 0x01, 0x15, 0x01, // ”ĕ (U+201D U+0115)
  0x20, 0x1D, 0x01, 0x17, 0x01, // ”ė (U+201D U+0117)
  0x20, 0x1D, 0x01, 0x19, 0x01, // ”ę (U+201D U+0119)
  0x20, 0x1D, 0x01, 0x1B, 0x01, // ”ě (U+201D U+011B)
  0x20, 0x1D, 0x01, 0x1D, 0x01, // ”ĝ (U+201D U+011D)
  0x20, 0x1D, 0x01, 0x1F, 0x01, // ”ğ (U+201D U+011F)
  0x20, 0x1D, 0x01, 0x21, 0x01, // ”ġ (U+201D U+0121)
  0x20, 0x1D, 0x01, 0x23, 0x01, // ”ģ (U+201D U+0123)
  0x20, 0x1D, 0x01, 0x4D, 0x01, // ”ō (U+201D U+014D)
  0x20, 0x1D, 0x01, 0x4F, 0x01, // ”ŏ (U+201D U+014F)
  0x20, 0x1D, 0x01, 0x51, 0x01, // ”ő (U+201D U+0151)
  0x20, 0x1D, 0x01, 0x53, 0x01, // ”œ (U+201D U+0153)
  0x20, 0x1D, 0x01, 0x5B, 0x01, // ”ś (U+201D U+015B)
  0x20, 0x1D, 0x01, 0x5D, 0x01, // ”ŝ (U+201D U+015D)
  0x20, 0x1D, 0x01, 0x5F, 0x01, // ”ş (U+201D U+015F)
  0x20, 0x1D, 0x01, 0x61, 0x01, // ”š (U+201D U+0161)
  0x20, 0x1E, 0x00, 0x3F, 0x01, // „? (U+201E U+003F)
  0x20, 0x1E, 0x00, 0x54, 0x01, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x56, 0x02, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x01, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x01, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0x76, 0x01, // „v (U+201E U+0076)
  0x20, 0x1E, 0x00, 0x77, 0x01, // „w (U+201E U+0077)
  0x20, 0x1E, 0x00, 0x79, 0x01, // „y (U+201E U+0079)
  0x20, 0x1E, 0x00, 0xDD, 0x01, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x00, 0xFD, 0x01, // „ý (U+201E U+00FD)
  0x20, 0x1E, 0x00, 0xFF, 0x01, // „ÿ (U+201E U+00FF)
  0x20, 0x1E, 0x01, 0x62, 0x01, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x01, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x01, // „Ŧ (U+201E U+0166)
  0x20, 0x1E, 0x01, 0x74, 0x01, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x75, 0x01, // „ŵ (U+201E U+0175)
  0x20, 0x1E, 0x01, 0x76, 0x01, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x77, 0x01, // „ŷ (U+201E U+0177)
  0x20, 0x1E, 0x01, 0x78, 0x01, // „Ÿ (U+201E U+0178)
  0x20, 0x26, 0x00, 0x3F, 0x01, // …? (U+2026 U+003F)
  0x20, 0x26, 0x00, 0x54, 0x01, // …T (U+2026 U+0054)
  0x20, 0x26, 0x00, 0x56, 0x02, // …V (U+2026 U+0056)
  0x20, 0x26, 0x00, 0x57, 0x01, // …W (U+2026 U+0057)
  0x20, 0x26, 0x00, 0x59, 0x01, // …Y (U+2026 U+0059)
  0x20, 0x26, 0x00, 0x76, 0x01, // …v (U+2026 U+0076)
  0x20, 0x26, 0x00, 0x77, 0x01, // …w (U+2026 U+0077)
  0x20, 0x26, 0x00, 0x79, 0x01, // …y (U+2026 U+0079)
  0x20, 0x26, 0x00, 0xDD, 0x01, // …Ý (U+2026 U+00DD)
  0x20, 0x26, 0x00, 0xFD, 0x01, // …ý (U+2026 U+00FD)
  0x20, 0x26, 0x00, 0xFF, 0x01, // …ÿ (U+2026 U+00FF)
  0x20, 0x26, 0x01, 0x62, 0x01, // …Ţ (U+2026 U+0162)
  0x20, 0x26, 0x01, 0x64, 0x01, // …Ť (U+2026 U+0164)
  0x20, 0x26, 0x01, 0x66, 0x01, // …Ŧ (U+2026 U+0166)
  0x20, 0x26, 0x01, 0x74, 0x01, // …Ŵ (U+2026 U+0174)
  0x20, 0x26, 0x01, 0x75, 0x01, // …ŵ (U+2026 U+0175)
  0x20, 0x26, 0x01, 0x76, 0x01, // …Ŷ (U+2026 U+0176)
  0x20, 0x26, 0x01, 0x77, 0x01, // …ŷ (U+2026 U+0177)
  0x20, 0x26, 0x01, 0x78, 0x01, // …Ÿ (U+2026 U+0178)
  
  // Glyph data
  // "!" (U+0021)
  0x5F, 0xF1, 0x4F, 0xF0, 0x2F, 0xD0, 0x0F, 0xC0, 0x0E, 0xA0, 0x0C, 0x80, 0x0A, 0x60, 0x00, 0x00,
  0x3F, 0xE0, 0x2D, 0xC0,
  // """ (U+0022)
  0xEF, 0x39, 0xF8, 0xBF, 0x17, 0xF5, 0x8E, 0x04, 0xF2, 0x6B, 0x02, 0xF0,
  // "#" (U+0023)
  0x00, 0x0C, 0x41, 0xE0, 0x00, 0x0F, 0x06, 0xA0, 0x1E, 0xEF, 0xEF, 0xED, 0x00, 0x79, 0x0C, 0x30,
  0x00, 0x96, 0x0F, 0x10, 0x00, 0xC4, 0x2D, 0x00, 0x8E, 0xFE, 0xEF, 0xE6, 0x02, 0xD0, 0x87, 0x00,
  0x05, 0xA0, 0xB5, 0x00, 0x08, 0x70, 0xE2, 0x00,
  // "$" (U+0024)
  0x30, 0x20, 0xA4, 0x84, 0x19, 0xCE, 0xEA, 0x28, 0x92, 0xAD, 0x2A, 0x9E, 0x20, 0xDF, 0x5A, 0x40,
  0x9A, 0x0D, 0x03, 0x40, 0x80, 0xEA, 0x0A, 0x48, 0xB2, 0x2D, 0xEF, 0x71, 0xE3, 0x2A, 0x4F, 0x92,
  0xF9, 0x2A, 0x4F, 0x50, 0x7E, 0xCE, 0xD7, 0x40, 0x40, 0xB6, 0x02, 0x0A, 0x30,
  // "%" (U+0025)
  0x06, 0xDE, 0xA1, 0x00, 0x7A, 0x00, 0x03, 0xF7, 0x1F, 0x90, 0x1E, 0x20, 0x00, 0x6F, 0x30, 0xCD,
  0x08, 0x90, 0x00, 0x06, 0xF3, 0x0C, 0xC1, 0xE2, 0x00, 0x00, 0x2F, 0x71, 0xF8, 0x89, 0x4C, 0xEB,
  0x20, 0x5D, 0xD9, 0x2E, 0x2E, 0xA0, 0xDB, 0x00, 0x00, 0x09, 0x83, 0xF6, 0x0A, 0xF0, 0x00, 0x02,
  0xE1, 0x3F, 0x60, 0xAF, 0x00, 0x00, 0x98, 0x00, 0xE9, 0x0D, 0xB0, 0x00, 0x2E, 0x10, 0x04, 0xDE,
  0xB2,
  // "&" (U+0026)
  0x28, 0x42, 0xBE, 0xEC, 0x36, 0x84, 0xBF, 0x50, 0xED, 0x68, 0x4C, 0xF4, 0x0D, 0xD6, 0x84, 0x7F,
  0xA3, 0xE4, 0x68, 0x53, 0xEF, 0xE1, 0x0D, 0xA8, 0x94, 0x50, 0x8F, 0xAB, 0xFC, 0x1E, 0xC1, 0x02,
  0xA2, 0x83, 0xAF, 0xCF, 0x52, 0x81, 0x3F, 0xE3, 0x09, 0xA0, 0x23, 0x81, 0xDF, 0x72, 0x83, 0x5E,
  0xFE, 0x42, 0x86, 0x19, 0xDE, 0xD9, 0x19, 0xA0, 0xB0,
  // "'" (U+0027)
  0xEF, 0x3B, 0xF1, 0x8E, 0x06, 0xB0,
  // "(" (U+0028)
  0x40, 0x10, 0x33, 0x81, 0x7E, 0x42, 0x81, 0x8F, 0x52, 0x81, 0x4F, 0xD3, 0x81, 0xAF, 0x83, 0x81,
  0xEF, 0x62, 0x01, 0xA0, 0x42, 0x01, 0xA0, 0x43, 0xA0, 0x53, 0x81, 0xDF, 0x73, 0x81, 0x7F, 0xA3,
  0x82, 0x1D, 0xF1, 0x38, 0x12, 0xDB, 0x48, 0x11, 0x97,
  // ")" (U+0029)
  0x03, 0x01, 0x48, 0x14, 0xE7, 0x48, 0x16, 0xF8, 0x48, 0x1D, 0xF3, 0x38, 0x18, 0xFA, 0x38, 0x16,
  0xFE, 0x30, 0x5A, 0x01, 0x20, 0x4A, 0x01, 0x20, 0x5A, 0x38, 0x17, 0xFD, 0x38, 0x1A, 0xF7, 0x28,
  0x11, 0xFD, 0x38, 0x1B, 0xD2, 0x28, 0x17, 0x91, 0x30,
  // "*" (U+002A)
  0x00, 0x0E, 0x70, 0x01, 0xC2, 0xC4, 0x78, 0x2A, 0xDD, 0xDC, 0x82, 0x9D, 0xDD, 0xB7, 0x1D, 0x3B,
  0x48, 0x90, 0x00, 0xE7, 0x00,
  // "+" (U+002B)
  0x20, 0x50, 0xB5, 0x05, 0x0B, 0x30, 0xFE, 0x98, 0x1E, 0xE5, 0x20, 0x50, 0xB5, 0x05, 0x0B, 0x50,
  0x50, 0xB3,
  // "," (U+002C)
  0x0D, 0xD1, 0x0E, 0xF4, 0x02, 0xF2, 0x1A, 0x70, 0x22, 0x00,
  // "-" (U+002D)
  0x8E, 0xEE, 0x40,
  // "." (U+002E)
  0x01, 0x0D, 0xF4, 0xBE, 0x30,
  // "/" (U+002F)
  0x00, 0x0D, 0x20, 0x01, 0xE0, 0x00, 0x5A, 0x00, 0x09, 0x60, 0x00, 0xD2, 0x00, 0x1E, 0x00, 0x05,
  0xA0, 0x00, 0x96, 0x00, 0x0D, 0x30, 0x01, 0xE0, 0x00, 0x5A, 0x00, 0x09, 0x60, 0x00, 0xD3, 0x00,
  0x00,
  // "0" (U+0030)
  0x01, 0x9E, 0xEB, 0x30, 0x0B, 0xF5, 0x0D, 0xE1, 0x2F, 0xF0, 0x09, 0xF8, 0x5F, 0xD0, 0x07, 0xFB,
  0x7F, 0xD0, 0x07, 0xFD, 0x7F, 0xD0, 0x07, 0xFD, 0x5F, 0xD0, 0x07, 0xFB, 0x2F, 0xF0, 0x09, 0xF7,
  0x0A, 0xF5, 0x0D, 0xE1, 0x00, 0x9E, 0xEB, 0x30,
  // "1" (U+0031)
  0x28, 0x21, 0xAF, 0xA2, 0x84, 0x17, 0xEC, 0xFA, 0x28, 0x41, 0xB4, 0x8F, 0xA5, 0x81, 0x8F, 0xA5,
  0x81, 0x8F, 0xA5, 0x81, 0x8F, 0xA5, 0x81, 0x8F, 0xA5, 0x81, 0x8F, 0xA5, 0x81, 0x9F, 0xB3, 0x07,
  0x0E, 0xB0, 0xE0, 0x90,
  // "2" (U+0032)
  0x18, 0x92, 0x7D, 0xEE, 0xB4, 0x04, 0xFD, 0x03, 0xA8, 0x21, 0x3F, 0x82, 0xA8, 0x63, 0x01, 0x10,
  0x1F, 0xD5, 0x81, 0x8F, 0x34, 0x81, 0x5E, 0x44, 0x81, 0x5D, 0x34, 0x81, 0x6D, 0x22, 0x89, 0x15,
  0xA5, 0xFA, 0x99, 0xAE, 0xA7, 0xE0, 0x90,
  // "3" (U+0033)
  0x08, 0xDE, 0xEC, 0x50, 0x5F, 0xC0, 0x3F, 0xF2, 0x19, 0x50, 0x0F, 0xF3, 0x00, 0x00, 0x7F, 0x80,
  0x00, 0xCF, 0xFA, 0x20, 0x00, 0x00, 0x5F, 0xE3, 0x00, 0x00, 0x0A, 0xF9, 0x38, 0x00, 0x0A, 0xF9,
  0x7F, 0x30, 0x3E, 0xF3, 0x19, 0xEE, 0xEA, 0x30,
  // "4" (U+0034)
  0x48, 0x1D, 0xF8, 0x58, 0x29, 0xDF, 0x84, 0x83, 0x4A, 0x9F, 0x83, 0x84, 0x1C, 0x1A, 0xF8, 0x38,
  0x4A, 0x40, 0xAF, 0x82, 0x05, 0x09, 0x28, 0x1A, 0xF8, 0x20, 0xB0, 0xFE, 0xA8, 0x1E, 0xE1, 0x48,
  0x1A, 0xF8, 0x68, 0x1C, 0xFA, 0x40, 0x4C, 0x0E, 0x10,
  // "5" (U+0035)
  0x10, 0xAD, 0x28, 0x90, 0xBD, 0xDD, 0xDF, 0x10, 0xD4, 0x38, 0x3B, 0x10, 0xE2, 0x69, 0x83, 0xDE,
  0xDA, 0x32, 0x02, 0x20, 0x5A, 0x03, 0x58, 0x3B, 0xF8, 0x15, 0x38, 0xA0, 0xBF, 0x75, 0xF3, 0x04,
  0xFE, 0x20, 0x8D, 0xEE, 0xA2, 0x10,
  // "6" (U+0036)
  0x00, 0x3B, 0xEF, 0xC3, 0x03, 0xF9, 0x05, 0xF6, 0x0C, 0xF0, 0x00, 0x00, 0x1F, 0xEB, 0xED, 0x70,
  0x4F, 0xE3, 0x0C, 0xF6, 0x4F, 0xC0, 0x06, 0xFB, 0x3F, 0xE0, 0x05, 0xFC, 0x0F, 0xF1, 0x06, 0xFA,
  0x08, 0xF8, 0x0B, 0xF3, 0x00, 0x7D, 0xED, 0x50,
  // "7" (U+0037)
  0x04, 0xE8, 0x91, 0xD4, 0xFD, 0xDD, 0xDF, 0x95, 0xA3, 0x83, 0x7F, 0x21, 0x13, 0x0E, 0x0A, 0x58,
  0x16, 0xF3, 0x50, 0xD0, 0xC5, 0x81, 0x6F, 0x55, 0x00, 0xD5, 0x81, 0x6F, 0x65, 0x0D, 0x0E, 0x40,
  // "8" (U+0038)
  0x02, 0xBE, 0xEC, 0x50, 0x0E, 0xF3, 0x0C, 0xF3, 0x2F, 0xE0, 0x07, 0xF6, 0x0E, 0xF2, 0x08, 0xE2,
  0x03, 0xDE, 0x8C, 0x10, 0x05, 0xDB, 0xDF, 0xB1, 0x4F, 0xB0, 0x09, 0xFB, 0x7F, 0x70, 0x03, 0xFD,
  0x3F, 0xD1, 0x09, 0xF9, 0x05, 0xCE, 0xEC, 0x70,
  // "9" (U+0039)
  0x02, 0xBE, 0xEA, 0x10, 0x1E, 0xF2, 0x1E, 0xD0, 0x5F, 0xB0, 0x09, 0xF5, 0x6F, 0xB0, 0x07, 0xF9,
  0x2F, 0xE2, 0x1B, 0xFA, 0x04, 0xCE, 0xB9, 0xF9, 0x00, 0x00, 0x08, 0xF7, 0x03, 0x00, 0x0C, 0xF2,
  0x0E, 0x40, 0x6F, 0x90, 0x06, 0xDE, 0xD7, 0x00,
  // ":" (U+003A)
  0x86, 0xAE, 0x4C, 0xF5, 0x01, 0x71, 0x86, 0x10, 0xCF, 0x5A, 0xE4,
  // ";" (U+003B)
  0x18, 0x5A, 0xE4, 0x0C, 0xF5, 0x20, 0x17, 0x30, 0x20, 0x42, 0x85, 0xDF, 0x50, 0x8F, 0x72, 0x83,
  0xE2, 0x1B, 0x41,
  // "<" (U+003C)
  0x48, 0x12, 0xA6, 0x28, 0x21, 0x9E, 0x72, 0x82, 0x7E, 0x91, 0x28, 0x1E, 0xE2, 0x48, 0x23, 0xBD,
  0x45, 0x82, 0x4D, 0xC3, 0x58, 0x16, 0xD5, 0x60, 0x20,
  // "=" (U+003D)
  0x80, 0x2E, 0x06, 0x77, 0x80, 0x2E, 0x06,
  // ">" (U+003E)
  0x0D, 0x05, 0x58, 0x24, 0xCC, 0x45, 0x82, 0x5D, 0xB2, 0x58, 0x1A, 0xF4, 0x28, 0x72, 0xAE, 0x60,
  0x18, 0xE8, 0x38, 0x1E, 0x91, 0x40, 0x26,
  // "?" (U+003F)
  0x18, 0x92, 0x8D, 0xEE, 0xB3, 0x05, 0xFE, 0x03, 0xA8, 0x22, 0x07, 0x62, 0xA0, 0x54, 0x03, 0xA0,
  0x23, 0x82, 0x2C, 0xF6, 0x49, 0x0A, 0x01, 0x50, 0xB0, 0x36, 0x01, 0x68, 0x16, 0xFB, 0x58, 0x15,
  0xE9, 0x30,
  // "@" (U+0040)
  0x48, 0x63, 0x9D, 0xEE, 0xC7, 0x15, 0x82, 0xAE, 0x71, 0x28, 0x22, 0xAD, 0x13, 0x89, 0x1B, 0xD1,
  0x3B, 0xEC, 0xA3, 0x9B, 0x28, 0xA5, 0x6F, 0x23, 0xFA, 0x08, 0xF1, 0x2F, 0x10, 0xD9, 0x0C, 0xF1,
  0x0A, 0xE2, 0x98, 0x53, 0x1F, 0x51, 0xFB, 0x20, 0xD0, 0xB2, 0x98, 0xB2, 0x23, 0xF3, 0x2F, 0xA0,
  0x1F, 0x90, 0x4D, 0x02, 0xF5, 0x0E, 0xC0, 0x8D, 0xA0, 0xC6, 0x28, 0x91, 0xD9, 0x04, 0xCD, 0x52,
  0xCD, 0x63, 0x81, 0x6F, 0x37, 0x58, 0x27, 0xE8, 0x32, 0x82, 0x14, 0xA4, 0x58, 0x62, 0x8C, 0xEE,
  0xC8, 0x23,
  // "A" (U+0041)
  0x48, 0x18, 0xFE, 0x72, 0x82, 0xDE, 0xF5, 0x78, 0x34, 0xD8, 0xFB, 0x78, 0x1B, 0x83, 0xA0, 0x15,
  0x85, 0x2F, 0x20, 0xEF, 0x75, 0x08, 0x0C, 0x28, 0x19, 0xFD, 0x58, 0x3E, 0xED, 0xDE, 0xA0, 0x43,
  0x81, 0x5E, 0x13, 0x81, 0xCF, 0xA3, 0x0C, 0x0B, 0x40, 0x7A, 0x81, 0x20, 0xEA, 0x0D, 0x20, 0x9C,
  0x04,
  // "B" (U+0042)
  0x8F, 0xFF, 0xEE, 0xD9, 0x20, 0x04, 0xFF, 0x20, 0xBF, 0xD0, 0x02, 0xFF, 0x20, 0x7F, 0xF0, 0x02,
  0xFF, 0x21, 0xBF, 0xA0, 0x02, 0xFF, 0xEF, 0xFA, 0x00, 0x02, 0xFF, 0x20, 0x7F, 0xD1, 0x02, 0xFF,
  0x20, 0x0F, 0xF6, 0x02, 0xFF, 0x20, 0x0F, 0xF7, 0x04, 0xFF, 0x20, 0x6F, 0xF2, 0x8F, 0xFF, 0xEE,
  0xEA, 0x30,
  // "C" (U+0043)
  0x38, 0x47, 0xCE, 0xED, 0x72, 0x89, 0x31, 0xCF, 0x50, 0x1D, 0xF5, 0x09, 0xFB, 0x38, 0x56, 0xA1,
  0x0E, 0xF7, 0x60, 0x1A, 0x06, 0x60, 0x1A, 0x05, 0x78, 0x1E, 0xF7, 0x78, 0x19, 0xFC, 0x78, 0x71,
  0xDF, 0x81, 0x01, 0x94, 0x38, 0x47, 0xCE, 0xED, 0x71,
  // "D" (U+0044)
  0x8F, 0xFF, 0xEF, 0xEA, 0x40, 0x00, 0x3F, 0xF2, 0x04, 0xEF, 0x70, 0x02, 0xFF, 0x20, 0x05, 0xFF,
  0x30, 0x2F, 0xF2, 0x00, 0x0F, 0xF8, 0x02, 0xFF, 0x20, 0x00, 0xDF, 0xA0, 0x2F, 0xF2, 0x00, 0x0E,
  0xF9, 0x02, 0xFF, 0x20, 0x01, 0xFF, 0x60, 0x2F, 0xF2, 0x00, 0x7F, 0xE1, 0x03, 0xFF, 0x20, 0x4E,
  0xF5, 0x08, 0xFF, 0xFE, 0xED, 0xA3, 0x00,
  // "E" (U+0045)
  0x07, 0x0E, 0xA0, 0xFC, 0x0E, 0x0B, 0x20, 0x3A, 0x03, 0x20, 0x60, 0xC2, 0x02, 0xA0, 0x32, 0x01,
  0x05, 0x20, 0x2A, 0x03, 0x60, 0x2A, 0x0F, 0xE0, 0xA3, 0x02, 0xA0, 0x36, 0x02, 0xA0, 0x36, 0x02,
  0xA0, 0x33, 0x82, 0x83, 0x03, 0xA0, 0x33, 0x82, 0xE4, 0x7E, 0xA0, 0xFC, 0x81, 0xDF, 0x30,
  // "F" (U+0046)
  0x08, 0xB0, 0xFE, 0x98, 0x1B, 0x03, 0xA0, 0x22, 0x82, 0x7C, 0x02, 0xA0, 0x22, 0x82, 0x14, 0x02,
  0xA0, 0x25, 0x02, 0xA0, 0xFE, 0x0A, 0x20, 0x2A, 0x02, 0x50, 0x2A, 0x02, 0x50, 0x2A, 0x02, 0x50,
  0x3A, 0x04, 0x40, 0x8C, 0x0C, 0x30,
  // "G" (U+0047)
  0x38, 0x56, 0xBD, 0xEE, 0xB5, 0x48, 0x1B, 0xF8, 0x20, 0x4A, 0x01, 0x28, 0x18, 0xFC, 0x40, 0x70,
  0x53, 0x81, 0xEF, 0x77, 0x10, 0x1A, 0x06, 0x71, 0x01, 0xA0, 0x62, 0x08, 0xB8, 0x4E, 0x10, 0xEF,
  0x73, 0x07, 0xA0, 0x22, 0x81, 0x9F, 0xC3, 0x05, 0xA4, 0x84, 0xCF, 0x81, 0x05, 0xA5, 0x85, 0x6C,
  0xEE, 0xDB, 0x62,
  // "H" (U+0048)
  0x08, 0xC8, 0x18, 0x4E, 0xB8, 0x1C, 0x03, 0xA0, 0x33, 0x81, 0xEF, 0x82, 0x02, 0xA0, 0x23, 0x81,
  0xEF, 0x72, 0x02, 0xA0, 0x23, 0x81, 0xEF, 0x72, 0x02, 0xA8, 0x00, 0xEA, 0x07, 0x20, 0x2A, 0x02,
  0x38, 0x1E, 0xF7, 0x20, 0x2A, 0x02, 0x38, 0x1E, 0xF7, 0x20, 0x2A, 0x02, 0x38, 0x1E, 0xF7, 0x20,
  0x4A, 0x04, 0x38, 0x3E, 0xF8, 0x08, 0xC8, 0x18, 0x4E, 0xB0, 0xC0,
  // "I" (U+0049)
  0x8F, 0xFF, 0xF8, 0x04, 0xFF, 0x40, 0x02, 0xFF, 0x30, 0x02, 0xFF, 0x30, 0x02, 0xFF, 0x30, 0x02,
  0xFF, 0x30, 0x02, 0xFF, 0x30, 0x02, 0xFF, 0x30, 0x03, 0xFF, 0x40, 0x8F, 0xFF, 0xF8,
  // "J" (U+004A)
  0x10, 0x7C, 0x08, 0x20, 0x3A, 0x04, 0x30, 0x2A, 0x03, 0x30, 0x2A, 0x03, 0x30, 0x2A, 0x03, 0x30,
  0x2A, 0x03, 0x30, 0x2A, 0x03, 0x30, 0x2A, 0x03, 0x30, 0x2A, 0x03, 0x30, 0x2A, 0x03, 0x30, 0x3A,
  0x02, 0x28, 0x21, 0xBF, 0xB2, 0x82, 0x4E, 0xD8, 0x30,
  // "K" (U+004B)
  0x08, 0xC0, 0x80, 0x6B, 0x81, 0x80, 0x3A, 0x04, 0x28, 0x1B, 0xE4, 0x20, 0x2A, 0x83, 0x20, 0x5D,
  0x23, 0x02, 0xA8, 0x22, 0x5D, 0x24, 0x02, 0xA8, 0x18, 0xFB, 0x50, 0x2A, 0x0C, 0xA0, 0x64, 0x02,
  0xA0, 0x20, 0x8A, 0x02, 0x30, 0x2A, 0x83, 0x20, 0xDF, 0xD3, 0x03, 0xA8, 0x13, 0x04, 0xA8, 0x1A,
  0x08, 0xC8, 0x28, 0x05, 0xDA,
  // "L" (U+004C)
  0x07, 0x0E, 0xA0, 0xE0, 0x75, 0x03, 0xA0, 0x36, 0x02, 0xA0, 0x36, 0x02, 0xA0, 0x36, 0x02, 0xA0,
  0x36, 0x02, 0xA0, 0x36, 0x02, 0xA0, 0x33, 0x01, 0x20, 0x2A, 0x03, 0x38, 0x2A, 0x40, 0x3A, 0x03,
  0x28, 0x31, 0xE3, 0x7E, 0xA0, 0xFC, 0x81, 0xEF, 0x30,
  // "M" (U+004D)
  0x8F, 0xFF, 0xE0, 0x00, 0x08, 0xFF, 0xFC, 0x03, 0xFF, 0xF4, 0x00, 0x0E, 0xFF, 0x80, 0x02, 0xEB,
  0xFA, 0x00, 0x4D, 0xDF, 0x70, 0x02, 0xE5, 0xFF, 0x10, 0x97, 0xDF, 0x70, 0x02, 0xE0, 0xEF, 0x60,
  0xE1, 0xDF, 0x70, 0x02, 0xE0, 0x9F, 0xC5, 0xB0, 0xDF, 0x70, 0x02, 0xE0, 0x3F, 0xFC, 0x60, 0xDF,
  0x70, 0x02, 0xE0, 0x0D, 0xFF, 0x10, 0xDF, 0x70, 0x03, 0xF0, 0x07, 0xFA, 0x00, 0xDF, 0x80, 0x8F,
  0xFF, 0x21, 0xF4, 0x0E, 0xFF, 0xFC,
  // "N" (U+004E)
  0x8F, 0xFE, 0x20, 0x04, 0xFF, 0xF8, 0x03, 0xFF, 0xD0, 0x00, 0x0F, 0x30, 0x02, 0xFE, 0xFA, 0x00,
  0x0E, 0x20, 0x02, 0xE4, 0xFF, 0x60, 0x0E, 0x20, 0x02, 0xE0, 0x7F, 0xF3, 0x0E, 0x20, 0x02, 0xE0,
  0x0B, 0xFD, 0x1E, 0x20, 0x02, 0xE0, 0x01, 0xDF, 0xAE, 0x20, 0x02, 0xE0, 0x00, 0x3F, 0xFF, 0x20,
  0x04, 0xF0, 0x00, 0x05, 0xFF, 0x20, 0x8F, 0xFF, 0x40, 0x00, 0x9F, 0x20,
  // "O" (U+004F)
  0x28, 0x51, 0x8D, 0xEE, 0xC6, 0x38, 0x21, 0xDF, 0x62, 0x81, 0x8F, 0xB2, 0x81, 0x9F, 0xB4, 0x85,
  0xEF, 0x60, 0xEF, 0x74, 0x82, 0xAF, 0xC1, 0xA0, 0x54, 0x82, 0x9F, 0xE1, 0xA0, 0x54, 0x85, 0x9F,
  0xE0, 0xEF, 0x74, 0x85, 0xAF, 0xC0, 0x9F, 0xB4, 0x86, 0xEF, 0x60, 0x1D, 0xF6, 0x28, 0x18, 0xFA,
  0x38, 0x51, 0x8D, 0xEE, 0xC6, 0x20,
  // "P" (U+0050)
  0x08, 0xB8, 0x2E, 0xFD, 0x83, 0x03, 0xA8, 0x32, 0x1C, 0xFB, 0x20, 0x2A, 0x81, 0x20, 0x7A, 0x81,
  0x10, 0x2A, 0x81, 0x20, 0x7A, 0x20, 0x2A, 0x83, 0x22, 0xDF, 0x82, 0x02, 0xA8, 0x2E, 0xDB, 0x53,
  0x02, 0xA0, 0x26, 0x02, 0xA0, 0x26, 0x03, 0xA0, 0x45, 0x08, 0xC0, 0xC4,
  // "Q" (U+0051)
  0x28, 0x51, 0x8D, 0xEE, 0xC6, 0x38, 0x21, 0xDF, 0x52, 0x81, 0x8F, 0xB2, 0x81, 0xAF, 0xB4, 0x81,
  0xEF, 0x61, 0xA0, 0x74, 0x82, 0xAF, 0xC1, 0xA0, 0x54, 0x82, 0x9F, 0xE1, 0xA0, 0x64, 0x85, 0x9F,
  0xD0, 0xEF, 0x74, 0x85, 0xAF, 0xB0, 0x8F, 0xC4, 0x89, 0x3E, 0xF4, 0x01, 0xDF, 0x81, 0x2A, 0xF8,
  0x40, 0x70, 0xCA, 0x0A, 0x03, 0x7A, 0x07, 0x71, 0x82, 0x8F, 0xE2, 0x71, 0x82, 0x7D, 0xFA, 0x10,
  // "R" (U+0052)
  0x8F, 0xFF, 0xEE, 0xEA, 0x20, 0x00, 0x3F, 0xF2, 0x09, 0xFE, 0x10, 0x02, 0xFF, 0x20, 0x3F, 0xF4,
  0x00, 0x2F, 0xF2, 0x03, 0xFF, 0x30, 0x02, 0xFF, 0x20, 0x9F, 0xA0, 0x00, 0x2F, 0xFE, 0xFF, 0x90,
  0x00, 0x02, 0xFF, 0x27, 0xFE, 0x10, 0x00, 0x2F, 0xF2, 0x0D, 0xFB, 0x00, 0x03, 0xFF, 0x30, 0x3F,
  0xF7, 0x08, 0xFF, 0xFF, 0x80, 0x5D, 0xFA,
  // "S" (U+0053)
  0x01, 0x9D, 0xEE, 0xA1, 0x0D, 0xD1, 0x0B, 0xF8, 0x3F, 0xC0, 0x03, 0x92, 0x1F, 0xF9, 0x10, 0x00,
  0x07, 0xFF, 0xFA, 0x30, 0x00, 0x29, 0xEF, 0xF6, 0x01, 0x00, 0x19, 0xFE, 0x5F, 0x30, 0x00, 0xFE,
  0x6F, 0xB1, 0x05, 0xF8, 0x07, 0xDF, 0xEC, 0x60,
  // "T" (U+0054)
  0x82, 0xCF, 0xEE, 0xA8, 0x6E, 0xEF, 0x8C, 0x70, 0x4A, 0x86, 0x10, 0xA9, 0x92, 0x04, 0xA8, 0x21,
  0x04, 0x73, 0x04, 0xA0, 0x16, 0x04, 0xA0, 0x16, 0x04, 0xA0, 0x16, 0x04, 0xA0, 0x16, 0x04, 0xA0,
  0x16, 0x05, 0xA0, 0x25, 0x09, 0xC0, 0x62,
  // "U" (U+0055)
  0x0B, 0xC8, 0x16, 0x0E, 0xA8, 0x1E, 0x06, 0xA0, 0x13, 0x00, 0x92, 0x05, 0xA4, 0x00, 0x82, 0x05,
  0xA4, 0x00, 0x82, 0x05, 0xA4, 0x00, 0x82, 0x05, 0xA4, 0x00, 0x82, 0x05, 0xA4, 0x00, 0x82, 0x04,
  0xA0, 0x13, 0x09, 0x07, 0x38, 0x1D, 0xF8, 0x28, 0x13, 0xE2, 0x38, 0x52, 0x9D, 0xEE, 0xC4, 0x20,
  // "V" (U+0056)
  0x0E, 0xB8, 0x2D, 0x05, 0xEA, 0x83, 0x60, 0xCF, 0xB3, 0x81, 0x1F, 0x32, 0x81, 0x5F, 0xE3, 0x05,
  0x0C, 0x48, 0x1E, 0xF5, 0x20, 0xB0, 0x64, 0x85, 0x9F, 0xB0, 0x1F, 0x14, 0x03, 0xA8, 0x11, 0x7A,
  0x68, 0x3D, 0xF6, 0xC4, 0x68, 0x27, 0xFC, 0xD7, 0x01, 0xA0, 0x87, 0x18, 0x1B, 0xF2, 0x40,
  // "W" (U+0057)
  0xC0, 0xE2, 0x81, 0x3F, 0x32, 0x0D, 0xB1, 0x81, 0xCF, 0xD3, 0x81, 0x8F, 0x93, 0x0A, 0x0C, 0x28,
  0x17, 0xFE, 0x38, 0x1D, 0xFE, 0x30, 0xC0, 0x62, 0x02, 0xA8, 0x91, 0x40, 0x2F, 0xEF, 0x50, 0x1F,
  0x23, 0x89, 0x2C, 0xF9, 0x07, 0xB9, 0xFB, 0x05, 0xD4, 0x85, 0x7F, 0xE0, 0xC5, 0x3A, 0x81, 0x29,
  0x84, 0x02, 0xA8, 0x75, 0xF1, 0x0C, 0xF7, 0xD4, 0x58, 0x2C, 0xFD, 0xA2, 0x82, 0x6F, 0xDE, 0x60,
  0x7A, 0x05, 0x20, 0x1A, 0x0A, 0x60, 0x2A, 0x48, 0x1A, 0xF6, 0x30,
  // "X" (U+0058)
  0x07, 0xC0, 0x61, 0xB8, 0x16, 0x03, 0xA0, 0x92, 0x81, 0x4F, 0x43, 0x06, 0xA8, 0x22, 0x0C, 0x55,
  0x83, 0xBF, 0xD9, 0x86, 0x82, 0x1E, 0xFD, 0x71, 0x0D, 0xA0, 0x46, 0x84, 0xB7, 0x8F, 0xE1, 0x40,
  0x09, 0x28, 0x1C, 0xFB, 0x38, 0x18, 0xF1, 0x20, 0x4A, 0x81, 0x90, 0xCA, 0x81, 0xD0, 0x1C, 0x0C,
  // "Y" (U+0059)
  0xD1, 0x07, 0xB8, 0x35, 0x0C, 0xFE, 0x38, 0x14, 0xF4, 0x20, 0x3A, 0x03, 0x20, 0x80, 0xA4, 0x85,
  0xAF, 0xB0, 0x1E, 0x14, 0x01, 0xA8, 0x14, 0x88, 0x68, 0x27, 0xFC, 0xD7, 0x1A, 0x07, 0x71, 0xA0,
  0x67, 0x1A, 0x07, 0x60, 0x7C, 0x0E, 0x30,
  // "Z" (U+005A)
  0x1A, 0x0F, 0xEB, 0x29, 0x04, 0x20, 0x2A, 0x82, 0x70, 0x1D, 0x38, 0x1C, 0xFC, 0x60, 0x7A, 0x02,
  0x50, 0x2A, 0x07, 0x68, 0x1C, 0xFC, 0x68, 0x28, 0xFE, 0x25, 0x03, 0xA0, 0x63, 0x84, 0xB4, 0x0C,
  0xFB, 0x38, 0x22, 0xF4, 0x5A, 0x80, 0x0E, 0xA0, 0x40,
  // "[" (U+005B)
  0x7F, 0xFF, 0x97, 0xFD, 0x00, 0x7F, 0xC0, 0x07, 0xFC, 0x00, 0x7F, 0xC0, 0x07, 0xFC, 0x00, 0x7F,
  0xC0, 0x07, 0xFC, 0x00, 0x7F, 0xC0, 0x07, 0xFC, 0x00, 0x7F, 0xC0, 0x07, 0xFD, 0x10, 0x7E, 0xEE,
  0x90,
  // "\" (U+005C)
  0x0D, 0x02, 0x30, 0x90, 0x63, 0x05, 0x0A, 0x30, 0x20, 0xE4, 0x0D, 0x02, 0x30, 0x90, 0x63, 0x05,
  0x0A, 0x30, 0x20, 0xE4, 0x0D, 0x02, 0x30, 0x90, 0x63, 0x06, 0x0A, 0x30, 0x20, 0xE4, 0x0D, 0x02,
  // "]" (U+005D)
  0x6F, 0xFF, 0xA0, 0x0A, 0xFA, 0x00, 0x8F, 0xA0, 0x08, 0xFA, 0x00, 0x8F, 0xA0, 0x08, 0xFA, 0x00,
  0x8F, 0xA0, 0x08, 0xFA, 0x00, 0x8F, 0xA0, 0x08, 0xFA, 0x00, 0x8F, 0xA0, 0x0B, 0xFA, 0x6E, 0xEE,
  0xA0,
  // "^" (U+005E)
  0x30, 0x20, 0x46, 0x09, 0x0E, 0x58, 0x22, 0xEA, 0x74, 0x82, 0x97, 0x2E, 0x38, 0x41, 0xE1, 0x0A,
  0x72, 0x09, 0x08, 0x28, 0x43, 0xE0, 0x1E, 0x13, 0x0B, 0x06,
  // "_" (U+005F)
  0x1E, 0xEE, 0xEE, 0xED,
  // "`" (U+0060)
  0x27, 0x70, 0x00, 0x9F, 0x80, 0x00, 0x6E, 0x30,
  // "a" (U+0061)
  0x03, 0xBE, 0xED, 0x80, 0x00, 0x9F, 0x80, 0xDF, 0x50, 0x00, 0x21, 0x0B, 0xF8, 0x00, 0x4B, 0xEE,
  0xFF, 0x80, 0x1F, 0xF5, 0x0B, 0xF8, 0x04, 0xFF, 0x00, 0xCF, 0x80, 0x2F, 0xF2, 0x3E, 0xF9, 0x00,
  0x6E, 0xE8, 0x6F, 0xF7,
  // "b" (U+0062)
  0x0B, 0xA0, 0xC6, 0x81, 0x9F, 0xC6, 0x81, 0x7F, 0xC6, 0x85, 0x7F, 0xB8, 0xEE, 0x92, 0x07, 0xA8,
  0x74, 0x0B, 0xF8, 0x07, 0xFE, 0x28, 0x56, 0xFD, 0x07, 0xFC, 0x20, 0x4A, 0x18, 0x17, 0xFC, 0x20,
  0x4A, 0x18, 0x17, 0xFE, 0x28, 0x36, 0xFD, 0x0A, 0xA8, 0x44, 0x0B, 0xF8, 0xBA, 0x83, 0x59, 0xED,
  0x81,
  // "c" (U+0063)
  0x28, 0x38, 0xDE, 0xD8, 0x28, 0x6A, 0xF7, 0x0D, 0xF4, 0x1A, 0x84, 0x20, 0x79, 0x03, 0xA5, 0x03,
  0xA5, 0x01, 0xA0, 0x25, 0x81, 0xAF, 0x92, 0x09, 0x03, 0x28, 0x39, 0xDE, 0xD8, 0x10,
  // "d" (U+0064)
  0x40, 0x5B, 0x03, 0x60, 0x2A, 0x03, 0x7A, 0x03, 0x28, 0x31, 0xBE, 0xD5, 0xA0, 0x32, 0x83, 0xCF,
  0x70, 0x9A, 0x81, 0x30, 0x2A, 0x81, 0x20, 0x3A, 0x81, 0x30, 0x4A, 0x20, 0x1A, 0x81, 0x30, 0x4A,
  0x20, 0x1A, 0x81, 0x30, 0x2A, 0x81, 0x10, 0x3A, 0x03, 0x28, 0x3C, 0xF7, 0x08, 0xA0, 0x52, 0x84,
  0x1B, 0xED, 0x69, 0xA0, 0x70,
  // "e" (U+0065)
  0x00, 0x8D, 0xED, 0x60, 0x09, 0xF7, 0x0A, 0xF7, 0x1F, 0xF1, 0x06, 0xFC, 0x3F, 0xFE, 0xEE, 0xED,
  0x3F, 0xF1, 0x00, 0x00, 0x1F, 0xF3, 0x00, 0x00, 0x09, 0xFB, 0x10, 0x77, 0x00, 0x8D, 0xFD, 0xA1,
  // "f" (U+0066)
  0x28, 0x34, 0xCE, 0xEB, 0x20, 0x1A, 0x86, 0x1B, 0xE1, 0x04, 0xFE, 0x40, 0x90, 0xEA, 0x00, 0xE3,
  0x81, 0x4F, 0xE5, 0x81, 0x4F, 0xE5, 0x81, 0x4F, 0xE5, 0x81, 0x4F, 0xE5, 0x81, 0x4F, 0xE5, 0x07,
  0xA0, 0x13, 0x0A, 0xC0, 0xA2,
  // "g" (U+0067)
  0x68, 0xA1, 0xAE, 0x20, 0x3C, 0xEF, 0xE7, 0xB1, 0x0E, 0xF1, 0x5F, 0x92, 0x85, 0x3F, 0xD0, 0x2F,
  0xD3, 0x84, 0xEF, 0x15, 0xFA, 0x38, 0x43, 0xEE, 0xD9, 0x13, 0x0B, 0x09, 0x78, 0x90, 0xEF, 0xEE,
  0xDA, 0x20, 0x19, 0xD8, 0x3B, 0x0C, 0xE2, 0x28, 0x51, 0xFD, 0x0D, 0xE1, 0x28, 0x91, 0x5F, 0x80,
  0x3B, 0xEE, 0xEC, 0x62,
  // "h" (U+0068)
  0x9F, 0xFC, 0x00, 0x00, 0x00, 0x08, 0xFC, 0x00, 0x00, 0x00, 0x07, 0xFB, 0x00, 0x00, 0x00, 0x07,
  0xFB, 0xAE, 0xE9, 0x00, 0x07, 0xFF, 0x31, 0xEF, 0x50, 0x07, 0xFD, 0x00, 0xBF, 0x80, 0x07, 0xFC,
  0x00, 0xBF, 0x80, 0x07, 0xFC, 0x00, 0xBF, 0x80, 0x07, 0xFC, 0x00, 0xBF, 0x80, 0x08, 0xFD, 0x00,
  0xBF, 0x90, 0x9F, 0xFF, 0xC0, 0xBF, 0xF7,
  // "i" (U+0069)
  0x07, 0xE8, 0x00, 0x7F, 0xA0, 0x00, 0x00, 0x0B, 0xFF, 0xC0, 0x09, 0xFC, 0x00, 0x7F, 0xC0, 0x07,
  0xFC, 0x00, 0x7F, 0xC0, 0x07, 0xFC, 0x00, 0x9F, 0xD0, 0xBF, 0xFF, 0xF0,
  // "j" (U+006A)
  0x00, 0x6E, 0x90, 0x07, 0xFA, 0x00, 0x00, 0x00, 0xBF, 0xFC, 0x00, 0x9F, 0xC0, 0x07, 0xFC, 0x00,
  0x7F, 0xC0, 0x07, 0xFC, 0x00, 0x7F, 0xC0, 0x07, 0xFC, 0x00, 0x7F, 0xC0, 0x09, 0xFA, 0x01, 0xDF,
  0x54, 0xEC, 0x60,
  // "k" (U+006B)
  0x0B, 0xA0, 0xC7, 0x81, 0x9F, 0xC7, 0x81, 0x7F, 0xC7, 0x83, 0x7F, 0xC0, 0xBB, 0x28, 0x57, 0xFC,
  0x02, 0xF9, 0x38, 0x47, 0xFC, 0x0B, 0x84, 0x84, 0x7F, 0xBA, 0xF3, 0x40, 0x7A, 0x81, 0xDF, 0xD4,
  0x85, 0x7F, 0xC1, 0xEF, 0x93, 0x83, 0x9F, 0xD0, 0x6A, 0x81, 0x60, 0xBC, 0x18, 0x28, 0xEF, 0x80,
  // "l" (U+006C)
  0xBF, 0xFC, 0x00, 0x9F, 0xC0, 0x07, 0xFC, 0x00, 0x7F, 0xC0, 0x07, 0xFC, 0x00, 0x7F, 0xC0, 0x07,
  0xFC, 0x00, 0x7F, 0xC0, 0x07, 0xFC, 0x00, 0x9F, 0xD0, 0xBF, 0xFF, 0xF0,
  // "m" (U+006D)
  0x8F, 0xFA, 0x9E, 0xEB, 0x4B, 0xFD, 0x60, 0x00, 0x8F, 0xF3, 0x1E, 0xFE, 0x13, 0xFF, 0x10, 0x07,
  0xFD, 0x00, 0xBF, 0x90, 0x0F, 0xF4, 0x00, 0x7F, 0xC0, 0x0B, 0xF8, 0x00, 0xEF, 0x50, 0x07, 0xFC,
  0x00, 0xBF, 0x80, 0x0E, 0xF5, 0x00, 0x7F, 0xC0, 0x0B, 0xF8, 0x00, 0xEF, 0x50, 0x08, 0xFD, 0x00,
  0xBF, 0x90, 0x0E, 0xF6, 0x09, 0xFF, 0xFC, 0x0B, 0xFF, 0x70, 0xEF, 0xE5,
  // "n" (U+006E)
  0x9F, 0xFA, 0x9E, 0xE9, 0x00, 0x09, 0xFF, 0x31, 0xEF, 0x50, 0x07, 0xFD, 0x00, 0xBF, 0x80, 0x07,
  0xFC, 0x00, 0xBF, 0x80, 0x07, 0xFC, 0x00, 0xBF, 0x80, 0x07, 0xFC, 0x00, 0xBF, 0x80, 0x09, 0xFD,
  0x00, 0xBF, 0xA0, 0xAF, 0xFF, 0xD0, 0xBF, 0xF9,
  // "o" (U+006F)
  0x00, 0x7C, 0xED, 0x91, 0x00, 0xAF, 0x80, 0x6F, 0xC0, 0x1F, 0xF2, 0x00, 0xEF, 0x44, 0xFF, 0x00,
  0x0D, 0xF6, 0x4F, 0xF1, 0x00, 0xDF, 0x61, 0xFF, 0x20, 0x0E, 0xF4, 0x0A, 0xF8, 0x06, 0xFC, 0x00,
  0x07, 0xDE, 0xD9, 0x10,
  // "p" (U+0070)
  0xAF, 0xF6, 0x9E, 0xD8, 0x00, 0xAF, 0xF3, 0x0C, 0xF7, 0x08, 0xFD, 0x00, 0x7F, 0xC0, 0x8F, 0xB0,
  0x05, 0xFE, 0x08, 0xFB, 0x00, 0x5F, 0xE0, 0x8F, 0xD0, 0x07, 0xFC, 0x08, 0xFF, 0x30, 0xCF, 0x70,
  0x8F, 0xA9, 0xED, 0x80, 0x08, 0xFB, 0x00, 0x00, 0x00, 0xAF, 0xC0, 0x00, 0x00, 0xCF, 0xFF, 0xE1,
  0x00, 0x00,
  // "q" (U+0071)
  0x18, 0x41, 0xBE, 0xD6, 0x9A, 0x85, 0x70, 0xCF, 0x70, 0x8A, 0x81, 0x50, 0x2A, 0x81, 0x10, 0x3A,
  0x81, 0x30, 0x4A, 0x20, 0x1A, 0x81, 0x30, 0x4A, 0x20, 0x1A, 0x81, 0x30, 0x2A, 0x81, 0x20, 0x3A,
  0x03, 0x28, 0x3C, 0xF7, 0x09, 0xA0, 0x32, 0x83, 0x2B, 0xED, 0x6A, 0x03, 0x7A, 0x03, 0x60, 0x2A,
  0x05, 0x50, 0x7C, 0x0A,
  // "r" (U+0072)
  0x09, 0xA8, 0x59, 0xAE, 0xE5, 0x09, 0xA8, 0x63, 0x6F, 0x50, 0x7F, 0xD5, 0x81, 0x7F, 0xC5, 0x81,
  0x7F, 0xC5, 0x81, 0x7F, 0xC5, 0x81, 0x9F, 0xD4, 0x0A, 0xC0, 0x42,
  // "s" (U+0073)
  0x05, 0xCE, 0xEB, 0x13, 0xF8, 0x05, 0xF5, 0x5F, 0xB1, 0x04, 0x01, 0xDF, 0xFB, 0x40, 0x00, 0x6D,
  0xFF, 0x52, 0xA0, 0x06, 0xFA, 0x7F, 0x40, 0x3F, 0x71, 0xAE, 0xED, 0x80,
  // "t" (U+0074)
  0x00, 0xBB, 0x00, 0x06, 0xFB, 0x00, 0x9F, 0xFF, 0xE9, 0x08, 0xFB, 0x00, 0x08, 0xFB, 0x00, 0x08,
  0xFB, 0x00, 0x08, 0xFB, 0x00, 0x08, 0xFB, 0x00, 0x06, 0xFD, 0x00, 0x00, 0xBF, 0xE9,
  // "u" (U+0075)
  0x9F, 0xFB, 0x0D, 0xFF, 0x70, 0x0A, 0xFB, 0x00, 0xDF, 0x70, 0x08, 0xFB, 0x00, 0xCF, 0x70, 0x08,
  0xFB, 0x00, 0xCF, 0x70, 0x08, 0xFB, 0x00, 0xCF, 0x70, 0x08, 0xFB, 0x00, 0xDF, 0x70, 0x05, 0xFE,
  0x13, 0xFF, 0x90, 0x00, 0x9E, 0xEA, 0x9F, 0xF9,
  // "v" (U+0076)
  0xC0, 0x90, 0x2B, 0x83, 0x10, 0xDF, 0x92, 0x81, 0x3E, 0x12, 0x81, 0x7F, 0xC2, 0x07, 0x09, 0x30,
  0x1A, 0x82, 0x30, 0xC4, 0x48, 0x3A, 0xF8, 0x2D, 0x58, 0x34, 0xFD, 0x78, 0x68, 0x2E, 0xFD, 0x26,
  0x81, 0x8F, 0xC4,
  // "w" (U+0077)
  0xFF, 0xFF, 0x40, 0xB8, 0x08, 0xFF, 0xC1, 0xEF, 0x40, 0x1F, 0xD0, 0x09, 0xC0, 0x0A, 0xF7, 0x07,
  0xFF, 0x30, 0xA6, 0x00, 0x6F, 0xB0, 0xCB, 0xF8, 0x0E, 0x10, 0x01, 0xFF, 0x3D, 0x3F, 0xD4, 0xB0,
  0x00, 0x0C, 0xFA, 0x70, 0xDF, 0xA6, 0x00, 0x00, 0x7F, 0xF2, 0x08, 0xFF, 0x10, 0x00, 0x02, 0xFC,
  0x00, 0x2F, 0xB0, 0x00,
  // "x" (U+0078)
  0x08, 0xC0, 0x6B, 0x81, 0x20, 0x5A, 0x83, 0x60, 0x8C, 0x13, 0x84, 0x6F, 0xD4, 0xC1, 0x50, 0x9A,
  0x03, 0x68, 0x29, 0xEF, 0xA5, 0x84, 0x7A, 0x1D, 0xF7, 0x38, 0x36, 0xF1, 0x05, 0xA8, 0x16, 0x0C,
  0xA0, 0xE0, 0x2C, 0x08,
  // "y" (U+0079)
  0xC0, 0x40, 0xAA, 0x83, 0xA1, 0xEF, 0x62, 0x0A, 0x0B, 0x28, 0x18, 0xFA, 0x20, 0xD0, 0x32, 0x01,
  0xA8, 0x11, 0x3D, 0x48, 0x3A, 0xF7, 0x97, 0x48, 0x33, 0xFD, 0xE1, 0x58, 0x1C, 0xFA, 0x68, 0x16,
  0xF4, 0x60, 0xA0, 0xD6, 0x81, 0x7F, 0x54, 0x82, 0x8E, 0xC5, 0x50,
  // "z" (U+007A)
  0x03, 0xE8, 0x14, 0x4D, 0x28, 0x91, 0xAF, 0xB0, 0x24, 0x05, 0xFE, 0x13, 0x82, 0x1E, 0xF4, 0x48,
  0x1B, 0xF9, 0x48, 0x16, 0xFD, 0x28, 0x45, 0x52, 0xEF, 0x32, 0x81, 0xB6, 0xAE, 0x06,
  // "{" (U+007B)
  0x28, 0x32, 0xBE, 0xE2, 0x28, 0x1A, 0xFA, 0x48, 0x1C, 0xF8, 0x48, 0x1C, 0xF8, 0x48, 0x1C, 0xF8,
  0x30, 0x3A, 0x04, 0x20, 0x8A, 0x06, 0x48, 0x23, 0xEF, 0x44, 0x81, 0xCF, 0x84, 0x81, 0xCF, 0x84,
  0x81, 0xCF, 0x84, 0x81, 0xAF, 0xB4, 0x83, 0x1A, 0xEE, 0x20,
  // "|" (U+007C)
  0x5B, 0x5B, 0x5B, 0x5B, 0x5B, 0x5B, 0x5B, 0x5B, 0x5B, 0x5B, 0x5B, 0x5B, 0x5B, 0x5B,
  // "}" (U+007D)
  0x82, 0x7F, 0xE8, 0x40, 0x1A, 0x04, 0x48, 0x1E, 0xF6, 0x48, 0x1E, 0xF6, 0x48, 0x1D, 0xF7, 0x48,
  0x2A, 0xFB, 0x14, 0x0B, 0xA0, 0x22, 0x82, 0xAF, 0xB1, 0x38, 0x1E, 0xF6, 0x48, 0x1E, 0xF6, 0x48,
  0x1E, 0xF6, 0x30, 0x1A, 0x04, 0x28, 0x27, 0xED, 0x73,
  // "~" (U+007E)
  0x07, 0xEA, 0x10, 0x79, 0x1E, 0x17, 0xC1, 0xB6, 0x3C, 0x00, 0x6D, 0xB0,
  // "¡" (U+00A1)
  0x0C, 0xD2, 0x0E, 0xF3, 0x00, 0x10, 0x07, 0xA0, 0x08, 0xC0, 0x0A, 0xE0, 0x0C, 0xF0, 0x0D, 0xF2,
  0x0F, 0xF4, 0x1F, 0xF5,
  // "¢" (U+00A2)
  0x00, 0x00, 0xC1, 0x00, 0x00, 0x8D, 0xFE, 0xC3, 0x08, 0xFA, 0xC8, 0xFA, 0x0E, 0xF4, 0xC4, 0xC4,
  0x1F, 0xF2, 0xC1, 0x00, 0x1F, 0xF2, 0xC1, 0x00, 0x0E, 0xF4, 0xC1, 0x00, 0x08, 0xFB, 0xD2, 0x58,
  0x00, 0x7D, 0xFE, 0xA1, 0x00, 0x00, 0xC1, 0x00,
  // "£" (U+00A3)
  0x00, 0x8D, 0xEE, 0xA1, 0x07, 0xF7, 0x09, 0xF7, 0x0A, 0xF4, 0x02, 0x71, 0x07, 0xF8, 0x00, 0x00,
  0x9E, 0xFF, 0xEE, 0x60, 0x00, 0xBF, 0x30, 0x00, 0x00, 0x9F, 0x20, 0x00, 0x01, 0xE9, 0x30, 0x05,
  0x3D, 0xFF, 0xFE, 0xDE, 0x69, 0x45, 0xAE, 0xE6,
  // "¤" (U+00A4)
  0x20, 0x00, 0x03, 0x0A, 0xCD, 0xEB, 0xE1, 0x4C, 0x10, 0x8A, 0x08, 0x70, 0x02, 0xD0, 0x5D, 0x20,
  0x9A, 0x0B, 0xBD, 0xEA, 0xE1, 0x20, 0x00, 0x01, 0x00,
  // "¥" (U+00A5)
  0x0D, 0xB0, 0x50, 0xDA, 0x83, 0x31, 0xDF, 0x82, 0x90, 0x52, 0x84, 0x6F, 0xC0, 0x3C, 0x48, 0x3D,
  0xF4, 0xA4, 0x48, 0x26, 0xFC, 0xB4, 0x0D, 0x0E, 0xA8, 0x1E, 0xE6, 0x48, 0x1D, 0xF6, 0x40, 0xD0,
  0xEA, 0x81, 0xEE, 0x64, 0x81, 0xDF, 0x74, 0x06, 0x0E, 0xB0, 0xD2,
  // "¦" (U+00A6)
  0x5B, 0x5B, 0x5B, 0x5B, 0x5B, 0x00, 0x00, 0x00, 0x00, 0x5B, 0x5B, 0x5B, 0x5B, 0x5B,
  // "§" (U+00A7)
  0x08, 0xDE, 0xC4, 0x07, 0xE2, 0x0C, 0xD0, 0xAD, 0x00, 0x67, 0x07, 0xF9, 0x10, 0x00, 0x5E, 0xFE,
  0x80, 0x0E, 0x64, 0xBF, 0xD1, 0xDC, 0x20, 0x7F, 0x83, 0xEF, 0x81, 0xE7, 0x01, 0x8E, 0xEC, 0x00,
  0x10, 0x1B, 0xF0, 0x9A, 0x00, 0x3F, 0x19, 0xF3, 0x07, 0xC0, 0x1A, 0xED, 0xA2, 0x00,
  // "¨" (U+00A8)
  0xB6, 0x0A, 0x7D, 0x70, 0xD8,
  // "©" (U+00A9)
  0x38, 0x53, 0xAD, 0xEC, 0x81, 0x48, 0x18, 0xC5, 0x28, 0x21, 0x7D, 0x32, 0x8B, 0x25, 0xC0, 0x4B,
  0xED, 0x43, 0xD1, 0x0C, 0x33, 0xF4, 0x08, 0x90, 0x87, 0x0E, 0x09, 0xB5, 0x85, 0x4B, 0x2D, 0x0B,
  0xA5, 0x85, 0x2C, 0x0E, 0x09, 0xC5, 0x8B, 0x04, 0xB0, 0xC3, 0x3F, 0x50, 0x27, 0x08, 0x70, 0x5C,
  0x05, 0xCE, 0xC3, 0x3D, 0x12, 0x81, 0x7C, 0x52, 0x82, 0x17, 0xD3, 0x48, 0x53, 0xAD, 0xEC, 0x81,
  0x20,
  // "ª" (U+00AA)
  0x0C, 0xDC, 0xC1, 0x1B, 0xBB, 0xF5, 0x7F, 0x36, 0xF5, 0x3D, 0xB6, 0xED,
  // "«" (U+00AB)
  0x03, 0xE1, 0x3E, 0x11, 0xE8, 0x1D, 0x90, 0xCF, 0x1C, 0xF1, 0x0D, 0xE1, 0xDE, 0x10, 0x2E, 0x82,
  0xE8, 0x00, 0x3E, 0x13, 0xE1,
  // "¬" (U+00AC)
  0x80, 0x2E, 0x06, 0x50, 0xA0, 0x65, 0x0A, 0x06, 0x50, 0x40, 0x20,
  // "®" (U+00AE)
  0x00, 0x03, 0xAD, 0xEC, 0x81, 0x00, 0x00, 0x8C, 0x50, 0x01, 0x7D, 0x30, 0x05, 0xC8, 0xFE, 0xEB,
  0x33, 0xD1, 0x0C, 0x30, 0x99, 0x08, 0xB0, 0x87, 0x0E, 0x00, 0x99, 0x09, 0xB0, 0x4B, 0x2D, 0x00,
  0x9F, 0xFB, 0x10, 0x2C, 0x0E, 0x00, 0x99, 0x5E, 0x00, 0x4B, 0x0C, 0x30, 0x99, 0x0B, 0x80, 0x87,
  0x05, 0xC4, 0xBA, 0x42, 0xB7, 0xD1, 0x00, 0x7C, 0x50, 0x01, 0x7D, 0x30, 0x00, 0x03, 0xAD, 0xEC,
  0x81, 0x00,
  // "¯" (U+00AF)
  0x1E, 0xEE, 0xEE, 0xED,
  // "°" (U+00B0)
  0x07, 0xDD, 0x70, 0x3E, 0x11, 0xE3, 0x3E, 0x11, 0xE3, 0x07, 0xDD, 0x70,
  // "±" (U+00B1)
  0x20, 0x50, 0xB5, 0x05, 0x0B, 0x30, 0xFE, 0x98, 0x1E, 0xE5, 0x20, 0x50, 0xB5, 0x05, 0x0B, 0x50,
  0x50, 0xB7, 0x38, 0x02, 0xE0, 0x50,
  // "²" (U+00B2)
  0x09, 0xCC, 0x50, 0x4F, 0x29, 0xF0, 0x06, 0x08, 0xE0, 0x00, 0x0D, 0x60, 0x00, 0xA7, 0x00, 0x0A,
  0x50, 0x45, 0x6F, 0xFF, 0xF5, 0x12, 0x22, 0x20,
  // "³" (U+00B3)
  0x08, 0xCC, 0x50, 0x3F, 0x29, 0xF0, 0x02, 0x0A, 0xD0, 0x02, 0xCE, 0x50, 0x00, 0x05, 0xF3, 0x67,
  0x05, 0xF3, 0x2B, 0xBB, 0x50,
  // "´" (U+00B4)
  0x00, 0x77, 0x20, 0x8F, 0x90, 0x3E, 0x60, 0x00,
  // "µ" (U+00B5)
  0x81, 0x9F, 0xA2, 0x85, 0xCF, 0x70, 0x9F, 0xA2, 0x85, 0xCF, 0x70, 0x9F, 0xA2, 0x85, 0xCF, 0x70,
  0x9F, 0xA2, 0x85, 0xCF, 0x70, 0x9F, 0xA2, 0x85, 0xCF, 0x70, 0x9F, 0xB2, 0x8A, 0x6E, 0xF7, 0x0A,
  0xFE, 0x37, 0xEF, 0x90, 0xBA, 0xDE, 0x83, 0xDF, 0x8B, 0x87, 0x81, 0xBE, 0x36, 0x81, 0x5E, 0xA6,
  // "¶" (U+00B6)
  0x10, 0x80, 0xEA, 0x0E, 0xA0, 0xC0, 0x3C, 0x18, 0x2A, 0x80, 0x5C, 0x18, 0x2A, 0x50, 0x4C, 0x10,
  0xA0, 0x52, 0x0E, 0xB1, 0x0A, 0x05, 0x28, 0x52, 0x79, 0xF0, 0xA5, 0x59, 0x10, 0xA0, 0x55, 0x91,
  0x0A, 0x05, 0x59, 0x10, 0xA0, 0x55, 0x91, 0x0A, 0x05, 0x59, 0x10, 0xA0, 0x54, 0x83, 0x3F, 0x0A,
  0x83, 0x85, 0x6E, 0xE0, 0xAE, 0xB0,
  // "·" (U+00B7)
  0x01, 0x0D, 0xF4, 0xBE, 0x30,
  // "¸" (U+00B8)
  0x04, 0xC2, 0x00, 0x07, 0xE1, 0x00, 0x7F, 0x13, 0xED, 0x60,
  // "¹" (U+00B9)
  0x00, 0x79, 0x00, 0x1B, 0xDD, 0x00, 0x02, 0x9D, 0x00, 0x00, 0x9D, 0x00, 0x00, 0x9D, 0x00, 0x00,
  0x9D, 0x00, 0x0A, 0xCC, 0xA1,
  // "º" (U+00BA)
  0x09, 0xDB, 0xC4, 0x5F, 0x50, 0xCE, 0x5F, 0x50, 0xCE, 0x09, 0xDB, 0xC4,
  // "»" (U+00BB)
  0xC7, 0x0B, 0x70, 0x04, 0xF4, 0x4F, 0x50, 0x0C, 0xE2, 0xBE, 0x20, 0xBF, 0x2B, 0xF3, 0x4F, 0x53,
  0xF5, 0x0C, 0x70, 0xB7, 0x00,
  // "¼" (U+00BC)
  0x20, 0x70, 0x97, 0x38, 0x21, 0xBD, 0xD7, 0x48, 0x12, 0x9D, 0x50, 0xB0, 0x75, 0x09, 0x0D, 0x40,
  0x30, 0xD6, 0x09, 0x0D, 0x40, 0xC0, 0x56, 0x09, 0x0D, 0x30, 0x40, 0xC2, 0x09, 0x06, 0x28, 0x92,
  0xAC, 0xCA, 0x10, 0xC4, 0x09, 0xE9, 0x78, 0x56, 0xC0, 0x67, 0xE9, 0x78, 0x5D, 0x32, 0xA0, 0xE9,
  0x68, 0x77, 0xB0, 0x9C, 0xBF, 0xD8, 0x48, 0x11, 0xE2, 0x40, 0xE0, 0x95, 0x08, 0x09, 0x48, 0x2A,
  0xCC, 0x50,
  // "½" (U+00BD)
  0x20, 0x70, 0x97, 0x38, 0x21, 0xBD, 0xD7, 0x48, 0x12, 0x9D, 0x50, 0xB0, 0x75, 0x09, 0x0D, 0x40,
  0x30, 0xD6, 0x09, 0x0D, 0x40, 0xC0, 0x56, 0x09, 0x0D, 0x38, 0x44, 0xD9, 0xCC, 0x52, 0x89, 0x1A,
  0xCC, 0xA1, 0x0C, 0x9F, 0x29, 0x97, 0x85, 0x6C, 0x06, 0x08, 0xE7, 0x0D, 0x03, 0x30, 0xD0, 0x66,
  0x07, 0x0B, 0x30, 0xA0, 0x76, 0x81, 0x1E, 0x22, 0x83, 0xA5, 0x04, 0x54, 0x08, 0x09, 0x20, 0x6C,
  0x05, 0x71, 0x01, 0x80, 0x02, 0x10,
  // "¾" (U+00BE)
  0x18, 0x28, 0xCC, 0x57, 0x18, 0x23, 0xF2, 0x99, 0x72, 0x82, 0x20, 0xAD, 0x30, 0xB0, 0x74, 0x82,
  0x2C, 0xE5, 0x20, 0x30, 0xD7, 0x84, 0x5F, 0x30, 0xC5, 0x48, 0x66, 0x70, 0x5F, 0x34, 0xC2, 0x89,
  0x59, 0x60, 0x2B, 0xBB, 0x50, 0xC4, 0x09, 0xE9, 0x68, 0x56, 0xC0, 0x67, 0xE9, 0x68, 0x5D, 0x32,
  0xA0, 0xE9, 0x58, 0x77, 0xB0, 0x9C, 0xBF, 0xD8, 0x38, 0x11, 0xE2, 0x40, 0xE0, 0x94, 0x08, 0x09,
  0x48, 0x2A, 0xCC, 0x50,
  // "¿" (U+00BF)
  0x38, 0x19, 0xE5, 0x58, 0x1B, 0xF6, 0x60, 0x16, 0x03, 0x0B, 0x50, 0x10, 0xA9, 0x48, 0x26, 0xFC,
  0x23, 0x02, 0xA0, 0x34, 0x05, 0xA2, 0x82, 0x66, 0x02, 0xA8, 0x92, 0x31, 0xDF, 0x50, 0x3B, 0xEE,
  0xD8, 0x10,
  // "À" (U+00C0)
  0x28, 0x12, 0x77, 0x73, 0x81, 0x9F, 0x87, 0x38, 0x16, 0xE3, 0x77, 0x78, 0x18, 0xFE, 0x72, 0x82,
  0xDE, 0xF5, 0x78, 0x34, 0xD8, 0xFB, 0x78, 0x1B, 0x83, 0xA0, 0x15, 0x85, 0x2F, 0x20, 0xEF, 0x75,
  0x08, 0x0C, 0x28, 0x19, 0xFD, 0x58, 0x3E, 0xED, 0xDE, 0xA0, 0x43, 0x81, 0x5E, 0x13, 0x81, 0xCF,
  0xA3, 0x0C, 0x0B, 0x40, 0x7A, 0x81, 0x20, 0xEA, 0x0D, 0x20, 0x9C, 0x04,
  // "Á" (U+00C1)
  0x68, 0x17, 0x72, 0x71, 0x81, 0x8F, 0x97, 0x18, 0x13, 0xE6, 0x77, 0x78, 0x18, 0xFE, 0x72, 0x82,
  0xDE, 0xF5, 0x78, 0x34, 0xD8, 0xFB, 0x78, 0x1B, 0x83, 0xA0, 0x15, 0x85, 0x2F, 0x20, 0xEF, 0x75,
  0x08, 0x0C, 0x28, 0x19, 0xFD, 0x58, 0x3E, 0xED, 0xDE, 0xA0, 0x43, 0x81, 0x5E, 0x13, 0x81, 0xCF,
  0xA3, 0x0C, 0x0B, 0x40, 0x7A, 0x81, 0x20, 0xEA, 0x0D, 0x20, 0x9C, 0x04,
  // "Â" (U+00C2)
  0x48, 0x16, 0x73, 0x71, 0x82, 0x6F, 0xDD, 0x78, 0x42, 0xE4, 0x0A, 0xA7, 0x76, 0x81, 0x8F, 0xE7,
  0x28, 0x2D, 0xEF, 0x57, 0x83, 0x4D, 0x8F, 0xB7, 0x81, 0xB8, 0x3A, 0x01, 0x58, 0x52, 0xF2, 0x0E,
  0xF7, 0x50, 0x80, 0xC2, 0x81, 0x9F, 0xD5, 0x83, 0xEE, 0xDD, 0xEA, 0x04, 0x38, 0x15, 0xE1, 0x38,
  0x1C, 0xFA, 0x30, 0xC0, 0xB4, 0x07, 0xA8, 0x12, 0x0E, 0xA0, 0xD2, 0x09, 0xC0, 0x40,
  // "Ã" (U+00C3)
  0x38, 0x49, 0xEA, 0x29, 0x65, 0x84, 0x3B, 0x08, 0xDA, 0x77, 0x68, 0x18, 0xFE, 0x72, 0x82, 0xDE,
  0xF5, 0x78, 0x34, 0xD8, 0xFB, 0x78, 0x1B, 0x83, 0xA0, 0x15, 0x85, 0x2F, 0x20, 0xEF, 0x75, 0x08,
  0x0C, 0x28, 0x19, 0xFD, 0x58, 0x3E, 0xED, 0xDE, 0xA0, 0x43, 0x81, 0x5E, 0x13, 0x81, 0xCF, 0xA3,
  0x0C, 0x0B, 0x40, 0x7A, 0x81, 0x20, 0xEA, 0x0D, 0x20, 0x9C, 0x04,
  // "Ä" (U+00C4)
  0x38, 0x3B, 0x60, 0xA7, 0x78, 0x3D, 0x70, 0xD8, 0x77, 0x68, 0x18, 0xFE, 0x72, 0x82, 0xDE, 0xF5,
  0x78, 0x34, 0xD8, 0xFB, 0x78, 0x1B, 0x83, 0xA0, 0x15, 0x85, 0x2F, 0x20, 0xEF, 0x75, 0x08, 0x0C,
  0x28, 0x19, 0xFD, 0x58, 0x3E, 0xED, 0xDE, 0xA0, 0x43, 0x81, 0x5E, 0x13, 0x81, 0xCF, 0xA3, 0x0C,
  0x0B, 0x40, 0x7A, 0x81, 0x20, 0xEA, 0x0D, 0x20, 0x9C, 0x04,
  // "Å" (U+00C5)
  0x48, 0x16, 0xEB, 0x72, 0x82, 0xD1, 0x96, 0x71, 0x82, 0xD1, 0x96, 0x71, 0x09, 0xA0, 0x17, 0x18,
  0x2D, 0xEF, 0x47, 0x83, 0x4D, 0x8F, 0xA7, 0x81, 0xA8, 0x3A, 0x01, 0x58, 0x51, 0xF2, 0x0E, 0xF7,
  0x50, 0x80, 0xC2, 0x81, 0x9F, 0xD5, 0x83, 0xDE, 0xDD, 0xEA, 0x04, 0x38, 0x15, 0xE1, 0x38, 0x1C,
  0xFA, 0x30, 0xC0, 0xB4, 0x07, 0xA8, 0x12, 0x0E, 0xA0, 0xD2, 0x09, 0xC0, 0x40,
  // "Æ" (U+00C6)
  0x40, 0x30, 0xDB, 0x0F, 0xE9, 0x0D, 0x60, 0x90, 0x8A, 0x04, 0x20, 0x60, 0xD5, 0x81, 0x3D, 0x1A,
  0x04, 0x20, 0x10, 0x65, 0x81, 0xC5, 0x1A, 0x04, 0x71, 0x82, 0x5C, 0x01, 0xA0, 0xFE, 0x0C, 0x58,
  0x2D, 0x30, 0x1A, 0x04, 0x70, 0x89, 0x0F, 0xEA, 0x04, 0x68, 0x12, 0xE2, 0x20, 0x1A, 0x04, 0x38,
  0x34, 0x30, 0xBA, 0x30, 0x2A, 0x04, 0x38, 0x1D, 0x5D, 0xA8, 0x29, 0x05, 0xEA, 0x84, 0xDC, 0xCD,
  0xF5,
  // "Ç" (U+00C7)
  0x38, 0x47, 0xCE, 0xED, 0x72, 0x89, 0x31, 0xCF, 0x50, 0x1D, 0xF5, 0x09, 0xFB, 0x38, 0x56, 0xA1,
  0x0E, 0xF7, 0x60, 0x1A, 0x06, 0x60, 0x1A, 0x05, 0x78, 0x1E, 0xF7, 0x78, 0x19, 0xFC, 0x78, 0x71,
  0xDF, 0x81, 0x01, 0x94, 0x38, 0x47, 0xCE, 0xED, 0x76, 0x0B, 0x07, 0x71, 0x81, 0x1D, 0x87, 0x10,
  0xD0, 0x96, 0x82, 0x9E, 0xB2, 0x20,
  // "È" (U+00C8)
  0x28, 0x12, 0x77, 0x71, 0x81, 0x9F, 0x87, 0x18, 0x16, 0xE3, 0x76, 0x07, 0x0E, 0xA0, 0xFC, 0x0E,
  0x0B, 0x20, 0x3A, 0x03, 0x20, 0x60, 0xC2, 0x02, 0xA0, 0x32, 0x01, 0x05, 0x20, 0x2A, 0x03, 0x60,
  0x2A, 0x0F, 0xE0, 0xA3, 0x02, 0xA0, 0x36, 0x02, 0xA0, 0x36, 0x02, 0xA0, 0x33, 0x82, 0x83, 0x03,
  0xA0, 0x33, 0x82, 0xE4, 0x7E, 0xA0, 0xFC, 0x81, 0xDF, 0x30,
  // "É" (U+00C9)
  0x58, 0x17, 0x72, 0x68, 0x18, 0xF9, 0x68, 0x13, 0xE6, 0x77, 0x07, 0x0E, 0xA0, 0xFC, 0x0E, 0x0B,
  0x20, 0x3A, 0x03, 0x20, 0x60, 0xC2, 0x02, 0xA0, 0x32, 0x01, 0x05, 0x20, 0x2A, 0x03, 0x60, 0x2A,
  0x0F, 0xE0, 0xA3, 0x02, 0xA0, 0x36, 0x02, 0xA0, 0x36, 0x02, 0xA0, 0x33, 0x82, 0x83, 0x03, 0xA0,
  0x33, 0x82, 0xE4, 0x7E, 0xA0, 0xFC, 0x81, 0xDF, 0x30,
  // "Ê" (U+00CA)
  0x48, 0x16, 0x73, 0x68, 0x26, 0xFD, 0xD5, 0x84, 0x2E, 0x40, 0xAA, 0x75, 0x07, 0x0E, 0xA0, 0xFC,
  0x0E, 0x0B, 0x20, 0x3A, 0x03, 0x20, 0x60, 0xC2, 0x02, 0xA0, 0x32, 0x01, 0x05, 0x20, 0x2A, 0x03,
  0x60, 0x2A, 0x0F, 0xE0, 0xA3, 0x02, 0xA0, 0x36, 0x02, 0xA0, 0x36, 0x02, 0xA0, 0x33, 0x82, 0x83,
  0x03, 0xA0, 0x33, 0x82, 0xE4, 0x7E, 0xA0, 0xFC, 0x81, 0xDF, 0x30,
  // "Ë" (U+00CB)
  0x38, 0x3B, 0x60, 0xA7, 0x58, 0x3D, 0x70, 0xD8, 0x75, 0x07, 0x0E, 0xA0, 0xFC, 0x0E, 0x0B, 0x20,
  0x3A, 0x03, 0x20, 0x60, 0xC2, 0x02, 0xA0, 0x32, 0x01, 0x05, 0x20, 0x2A, 0x03, 0x60, 0x2A, 0x0F,
  0xE0, 0xA3, 0x02, 0xA0, 0x36, 0x02, 0xA0, 0x36, 0x02, 0xA0, 0x33, 0x82, 0x83, 0x03, 0xA0, 0x33,
  0x82, 0xE4, 0x7E, 0xA0, 0xFC, 0x81, 0xDF, 0x30,
  // "Ì" (U+00CC)
  0x81, 0x27, 0x74, 0x81, 0x9F, 0x84, 0x81, 0x6E, 0x37, 0x08, 0xC8, 0x18, 0x04, 0xA0, 0x42, 0x02,
  0xA0, 0x32, 0x02, 0xA0, 0x32, 0x02, 0xA0, 0x32, 0x02, 0xA0, 0x32, 0x02, 0xA0, 0x32, 0x02, 0xA0,
  0x32, 0x03, 0xA8, 0x14, 0x08, 0xC0, 0x80,
  // "Í" (U+00CD)
  0x38, 0x17, 0x72, 0x28, 0x18, 0xF9, 0x28, 0x13, 0xE6, 0x71, 0x08, 0xC8, 0x18, 0x04, 0xA0, 0x42,
  0x02, 0xA0, 0x32, 0x02, 0xA0, 0x32, 0x02, 0xA0, 0x32, 0x02, 0xA0, 0x32, 0x02, 0xA0, 0x32, 0x02,
  0xA0, 0x32, 0x03, 0xA8, 0x14, 0x08, 0xC0, 0x80,
  // "Î" (U+00CE)
  0x28, 0x16, 0x73, 0x28, 0x91, 0x6F, 0xDD, 0x02, 0xE4, 0x0A, 0xA6, 0x08, 0xC8, 0x18, 0x04, 0xA0,
  0x42, 0x02, 0xA0, 0x32, 0x02, 0xA0, 0x32, 0x02, 0xA0, 0x32, 0x02, 0xA0, 0x32, 0x02, 0xA0, 0x32,
  0x02, 0xA0, 0x32, 0x03, 0xA8, 0x14, 0x08, 0xC0, 0x80,
  // "Ï" (U+00CF)
  0x18, 0x91, 0xB6, 0x0A, 0x70, 0xD7, 0x0D, 0x86, 0x08, 0xC8, 0x18, 0x04, 0xA0, 0x42, 0x02, 0xA0,
  0x32, 0x02, 0xA0, 0x32, 0x02, 0xA0, 0x32, 0x02, 0xA0, 0x32, 0x02, 0xA0, 0x32, 0x02, 0xA0, 0x32,
  0x03, 0xA8, 0x14, 0x08, 0xC0, 0x80,
  // "Ð" (U+00D0)
  0x8F, 0xFF, 0xEF, 0xEA, 0x40, 0x00, 0x3F, 0xF2, 0x04, 0xEF, 0x70, 0x02, 0xFF, 0x20, 0x05, 0xFF,
  0x30, 0x2F, 0xF2, 0x00, 0x0F, 0xF8, 0x6E, 0xFF, 0xEE, 0x00, 0xDF, 0xA0, 0x2F, 0xF2, 0x00, 0x0E,
  0xF9, 0x02, 0xFF, 0x20, 0x01, 0xFF, 0x60, 0x2F, 0xF2, 0x00, 0x7F, 0xE1, 0x04, 0xFF, 0x20, 0x4E,
  0xF5, 0x08, 0xFF, 0xFE, 0xED, 0xA3, 0x00,
  // "Ñ" (U+00D1)
  0x38, 0x49, 0xEA, 0x29, 0x65, 0x84, 0x3B, 0x08, 0xDA, 0x77, 0x20, 0x8A, 0x0E, 0x02, 0x20, 0x4B,
  0x81, 0x80, 0x3A, 0x0D, 0x49, 0x03, 0x28, 0x32, 0xFE, 0xFA, 0x30, 0xE0, 0x22, 0x81, 0x2E, 0x4A,
  0x06, 0x20, 0xE0, 0x22, 0x82, 0x2E, 0x07, 0xA8, 0x23, 0x0E, 0x22, 0x02, 0x0E, 0x28, 0x4B, 0xFD,
  0x1E, 0x22, 0x02, 0x0E, 0x28, 0x41, 0xDF, 0xAE, 0x22, 0x02, 0x0E, 0x30, 0x3B, 0x02, 0x20, 0x49,
  0x40, 0x5A, 0x81, 0x20, 0x8B, 0x04, 0x38, 0x19, 0xF2, 0x10,
  // "Ò" (U+00D2)
  0x38, 0x12, 0x77, 0x72, 0x81, 0x9F, 0x87, 0x28, 0x16, 0xE3, 0x77, 0x28, 0x51, 0x8D, 0xEE, 0xC6,
  0x38, 0x21, 0xDF, 0x62, 0x81, 0x8F, 0xB2, 0x81, 0x9F, 0xB4, 0x85, 0xEF, 0x60, 0xEF, 0x74, 0x82,
  0xAF, 0xC1, 0xA0, 0x54, 0x82, 0x9F, 0xE1, 0xA0, 0x54, 0x85, 0x9F, 0xE0, 0xEF, 0x74, 0x85, 0xAF,
  0xC0, 0x9F, 0xB4, 0x86, 0xEF, 0x60, 0x1D, 0xF6, 0x28, 0x18, 0xFA, 0x38, 0x51, 0x8D, 0xEE, 0xC6,
  0x20,
  // "Ó" (U+00D3)
  0x68, 0x17, 0x72, 0x78, 0x18, 0xF9, 0x78, 0x13, 0xE6, 0x77, 0x38, 0x51, 0x8D, 0xEE, 0xC6, 0x38,
  0x21, 0xDF, 0x62, 0x81, 0x8F, 0xB2, 0x81, 0x9F, 0xB4, 0x85, 0xEF, 0x60, 0xEF, 0x74, 0x82, 0xAF,
  0xC1, 0xA0, 0x54, 0x82, 0x9F, 0xE1, 0xA0, 0x54, 0x85, 0x9F, 0xE0, 0xEF, 0x74, 0x85, 0xAF, 0xC0,
  0x9F, 0xB4, 0x86, 0xEF, 0x60, 0x1D, 0xF6, 0x28, 0x18, 0xFA, 0x38, 0x51, 0x8D, 0xEE, 0xC6, 0x20,
  // "Ô" (U+00D4)
  0x58, 0x16, 0x73, 0x78, 0x26, 0xFD, 0xD6, 0x84, 0x2E, 0x40, 0xAA, 0x77, 0x18, 0x51, 0x8D, 0xEE,
  0xC6, 0x38, 0x21, 0xDF, 0x62, 0x81, 0x8F, 0xB2, 0x81, 0x9F, 0xB4, 0x85, 0xEF, 0x60, 0xEF, 0x74,
  0x82, 0xAF, 0xC1, 0xA0, 0x54, 0x82, 0x9F, 0xE1, 0xA0, 0x54, 0x85, 0x9F, 0xE0, 0xEF, 0x74, 0x85,
  0xAF, 0xC0, 0x9F, 0xB4, 0x86, 0xEF, 0x60, 0x1D, 0xF6, 0x28, 0x18, 0xFA, 0x38, 0x51, 0x8D, 0xEE,
  0xC6, 0x20,
  // "Õ" (U+00D5)
  0x38, 0x49, 0xEA, 0x29, 0x64, 0x84, 0x3B, 0x08, 0xDA, 0x77, 0x28, 0x51, 0x8D, 0xEE, 0xC6, 0x38,
  0x21, 0xDF, 0x62, 0x81, 0x8F, 0xB2, 0x81, 0x9F, 0xB4, 0x85, 0xEF, 0x60, 0xEF, 0x74, 0x82, 0xAF,
  0xC1, 0xA0, 0x54, 0x82, 0x9F, 0xE1, 0xA0, 0x54, 0x85, 0x9F, 0xE0, 0xEF, 0x74, 0x85, 0xAF, 0xC0,
  0x9F, 0xB4, 0x86, 0xEF, 0x60, 0x1D, 0xF6, 0x28, 0x18, 0xFA, 0x38, 0x51, 0x8D, 0xEE, 0xC6, 0x20,
  // "Ö" (U+00D6)
  0x48, 0x3B, 0x60, 0xA7, 0x68, 0x3D, 0x70, 0xD8, 0x77, 0x18, 0x51, 0x8D, 0xEE, 0xC6, 0x38, 0x21,
  0xDF, 0x62, 0x81, 0x8F, 0xB2, 0x81, 0x9F, 0xB4, 0x85, 0xEF, 0x60, 0xEF, 0x74, 0x82, 0xAF, 0xC1,
  0xA0, 0x54, 0x82, 0x9F, 0xE1, 0xA0, 0x54, 0x85, 0x9F, 0xE0, 0xEF, 0x74, 0x85, 0xAF, 0xC0, 0x9F,
  0xB4, 0x86, 0xEF, 0x60, 0x1D, 0xF6, 0x28, 0x18, 0xFA, 0x38, 0x51, 0x8D, 0xEE, 0xC6, 0x20,
  // "×" (U+00D7)
  0x10, 0x00, 0x01, 0x8B, 0x00, 0x7D, 0x0A, 0xB7, 0xE2, 0x00, 0xCF, 0x30, 0x07, 0xEA, 0xB0, 0x6E,
  0x20, 0xAB, 0x22, 0x00, 0x05,
  // "Ø" (U+00D8)
  0x00, 0x00, 0x00, 0x00, 0x86, 0x00, 0x01, 0x8D, 0xEE, 0xBE, 0x10, 0x01, 0xDF, 0x60, 0x0B, 0xFA,
  0x00, 0x9F, 0xB0, 0x02, 0xDE, 0xF6, 0x0E, 0xF7, 0x00, 0xB5, 0xAF, 0xB1, 0xFF, 0x50, 0x4B, 0x09,
  0xFE, 0x1F, 0xF5, 0x0D, 0x20, 0x9F, 0xE0, 0xFF, 0x77, 0x80, 0x0A, 0xFC, 0x0A, 0xFC, 0xD0, 0x00,
  0xEF, 0x60, 0x1D, 0xF9, 0x00, 0x8F, 0xB0, 0x00, 0x5D, 0xDE, 0xEC, 0x60, 0x00, 0x05, 0x20, 0x00,
  0x00, 0x00,
  // "Ù" (U+00D9)
  0x38, 0x12, 0x77, 0x72, 0x81, 0x9F, 0x87, 0x28, 0x16, 0xE3, 0x77, 0x0B, 0xC8, 0x16, 0x0E, 0xA8,
  0x1E, 0x06, 0xA0, 0x13, 0x00, 0x92, 0x05, 0xA4, 0x00, 0x82, 0x05, 0xA4, 0x00, 0x82, 0x05, 0xA4,
  0x00, 0x82, 0x05, 0xA4, 0x00, 0x82, 0x05, 0xA4, 0x00, 0x82, 0x04, 0xA0, 0x13, 0x09, 0x07, 0x38,
  0x1D, 0xF8, 0x28, 0x13, 0xE2, 0x38, 0x52, 0x9D, 0xEE, 0xC4, 0x20,
  // "Ú" (U+00DA)
  0x68, 0x17, 0x72, 0x78, 0x18, 0xF9, 0x78, 0x13, 0xE6, 0x77, 0x10, 0xBC, 0x81, 0x60, 0xEA, 0x81,
  0xE0, 0x6A, 0x01, 0x30, 0x09, 0x20, 0x5A, 0x40, 0x08, 0x20, 0x5A, 0x40, 0x08, 0x20, 0x5A, 0x40,
  0x08, 0x20, 0x5A, 0x40, 0x08, 0x20, 0x5A, 0x40, 0x08, 0x20, 0x4A, 0x01, 0x30, 0x90, 0x73, 0x81,
  0xDF, 0x82, 0x81, 0x3E, 0x23, 0x85, 0x29, 0xDE, 0xEC, 0x42,
  // "Û" (U+00DB)
  0x58, 0x16, 0x73, 0x78, 0x26, 0xFD, 0xD6, 0x84, 0x2E, 0x40, 0xAA, 0x76, 0x0B, 0xC8, 0x16, 0x0E,
  0xA8, 0x1E, 0x06, 0xA0, 0x13, 0x00, 0x92, 0x05, 0xA4, 0x00, 0x82, 0x05, 0xA4, 0x00, 0x82, 0x05,
  0xA4, 0x00, 0x82, 0x05, 0xA4, 0x00, 0x82, 0x05, 0xA4, 0x00, 0x82, 0x04, 0xA0, 0x13, 0x09, 0x07,
  0x38, 0x1D, 0xF8, 0x28, 0x13, 0xE2, 0x38, 0x52, 0x9D, 0xEE, 0xC4, 0x20,
  // "Ü" (U+00DC)
  0x48, 0x3B, 0x60, 0xA7, 0x68, 0x3D, 0x70, 0xD8, 0x76, 0x0B, 0xC8, 0x16, 0x0E, 0xA8, 0x1E, 0x06,
  0xA0, 0x13, 0x00, 0x92, 0x05, 0xA4, 0x00, 0x82, 0x05, 0xA4, 0x00, 0x82, 0x05, 0xA4, 0x00, 0x82,
  0x05, 0xA4, 0x00, 0x82, 0x05, 0xA4, 0x00, 0x82, 0x04, 0xA0, 0x13, 0x09, 0x07, 0x38, 0x1D, 0xF8,
  0x28, 0x13, 0xE2, 0x38, 0x52, 0x9D, 0xEE, 0xC4, 0x20,
  // "Ý" (U+00DD)
  0x68, 0x17, 0x72, 0x78, 0x18, 0xF9, 0x78, 0x13, 0xE6, 0x77, 0x1D, 0x10, 0x7B, 0x83, 0x50, 0xCF,
  0xE3, 0x81, 0x4F, 0x42, 0x03, 0xA0, 0x32, 0x08, 0x0A, 0x48, 0x5A, 0xFB, 0x01, 0xE1, 0x40, 0x1A,
  0x81, 0x48, 0x86, 0x82, 0x7F, 0xCD, 0x71, 0xA0, 0x77, 0x1A, 0x06, 0x71, 0xA0, 0x76, 0x07, 0xC0,
  0xE3,
  // "Þ" (U+00DE)
  0x08, 0xB0, 0xE0, 0x85, 0x04, 0xA8, 0x2E, 0xEC, 0x73, 0x02, 0xA8, 0x32, 0x1D, 0xF8, 0x20, 0x2A,
  0x81, 0x20, 0x7A, 0x20, 0x2A, 0x81, 0x20, 0x6A, 0x81, 0x10, 0x2A, 0x83, 0x20, 0x8F, 0xE2, 0x02,
  0xA8, 0x33, 0x2D, 0xF5, 0x20, 0x2A, 0x82, 0xED, 0xA4, 0x30, 0x3A, 0x03, 0x50, 0x8C, 0x08, 0x40,
  // "ß" (U+00DF)
  0x00, 0x3B, 0xED, 0xD9, 0x10, 0x02, 0xFF, 0x30, 0x5F, 0xA0, 0x07, 0xFC, 0x00, 0x0E, 0xF0, 0xAE,
  0xFB, 0x08, 0xEC, 0x91, 0x07, 0xFB, 0x3F, 0xA0, 0x00, 0x07, 0xFB, 0x3F, 0xE4, 0x00, 0x07, 0xFB,
  0x0B, 0xFF, 0xB1, 0x07, 0xFB, 0x00, 0x7E, 0xFB, 0x07, 0xFB, 0x46, 0x02, 0xFE, 0x08, 0xFB, 0x9E,
  0x11, 0xFB, 0xCF, 0xFB, 0x2B, 0xEE, 0xB2,
  // "à" (U+00E0)
  0x18, 0x12, 0x77, 0x78, 0x19, 0xF8, 0x78, 0x16, 0xE3, 0x76, 0x84, 0x3B, 0xEE, 0xD8, 0x38, 0x59,
  0xF8, 0x0D, 0xF5, 0x38, 0x42, 0x10, 0xBF, 0x82, 0x82, 0x4B, 0xEE, 0xA8, 0x18, 0x01, 0xA8, 0x55,
  0x0B, 0xF8, 0x04, 0xA2, 0x83, 0xCF, 0x80, 0x2A, 0x83, 0x23, 0xEF, 0x92, 0x83, 0x6E, 0xE8, 0x6A,
  0x07,
  // "á" (U+00E1)
  0x58, 0x17, 0x72, 0x58, 0x18, 0xF9, 0x58, 0x13, 0xE6, 0x76, 0x84, 0x3B, 0xEE, 0xD8, 0x38, 0x59,
  0xF8, 0x0D, 0xF5, 0x38, 0x42, 0x10, 0xBF, 0x82, 0x82, 0x4B, 0xEE, 0xA8, 0x18, 0x01, 0xA8, 0x55,
  0x0B, 0xF8, 0x04, 0xA2, 0x83, 0xCF, 0x80, 0x2A, 0x83, 0x23, 0xEF, 0x92, 0x83, 0x6E, 0xE8, 0x6A,
  0x07,
  // "â" (U+00E2)
  0x38, 0x16, 0x73, 0x58, 0x26, 0xFD, 0xD4, 0x84, 0x2E, 0x40, 0xAA, 0x75, 0x84, 0x3B, 0xEE, 0xD8,
  0x38, 0x59, 0xF8, 0x0D, 0xF5, 0x38, 0x42, 0x10, 0xBF, 0x82, 0x82, 0x4B, 0xEE, 0xA8, 0x18, 0x01,
  0xA8, 0x55, 0x0B, 0xF8, 0x04, 0xA2, 0x83, 0xCF, 0x80, 0x2A, 0x83, 0x23, 0xEF, 0x92, 0x83, 0x6E,
  0xE8, 0x6A, 0x07,
  // "ã" (U+00E3)
  0x28, 0x49, 0xEA, 0x29, 0x62, 0x84, 0x3B, 0x08, 0xDA, 0x75, 0x84, 0x3B, 0xEE, 0xD8, 0x38, 0x59,
  0xF8, 0x0D, 0xF5, 0x38, 0x42, 0x10, 0xBF, 0x82, 0x82, 0x4B, 0xEE, 0xA8, 0x18, 0x01, 0xA8, 0x55,
  0x0B, 0xF8, 0x04, 0xA2, 0x83, 0xCF, 0x80, 0x2A, 0x83, 0x23, 0xEF, 0x92, 0x83, 0x6E, 0xE8, 0x6A,
  0x07,
  // "ä" (U+00E4)
  0x28, 0x3B, 0x60, 0xA7, 0x48, 0x3D, 0x70, 0xD8, 0x75, 0x84, 0x3B, 0xEE, 0xD8, 0x38, 0x59, 0xF8,
  0x0D, 0xF5, 0x38, 0x42, 0x10, 0xBF, 0x82, 0x82, 0x4B, 0xEE, 0xA8, 0x18, 0x01, 0xA8, 0x55, 0x0B,
  0xF8, 0x04, 0xA2, 0x83, 0xCF, 0x80, 0x2A, 0x83, 0x23, 0xEF, 0x92, 0x83, 0x6E, 0xE8, 0x6A, 0x07,
  // "å" (U+00E5)
  0x38, 0x1B, 0xEA, 0x58, 0x34, 0xC0, 0xB3, 0x58, 0x1A, 0xEA, 0x76, 0x84, 0x3B, 0xEE, 0xD8, 0x38,
  0x59, 0xF8, 0x0D, 0xF5, 0x38, 0x42, 0x10, 0xBF, 0x82, 0x82, 0x4B, 0xEE, 0xA8, 0x18, 0x01, 0xA8,
  0x55, 0x0B, 0xF8, 0x04, 0xA2, 0x83, 0xCF, 0x80, 0x2A, 0x83, 0x23, 0xEF, 0x92, 0x83, 0x6E, 0xE8,
  0x6A, 0x07,
  // "æ" (U+00E6)
  0x03, 0xBE, 0xEC, 0x59, 0xDE, 0xB3, 0x00, 0x9F, 0x80, 0xDF, 0xE2, 0x2F, 0xE1, 0x00, 0x21, 0x0B,
  0xFA, 0x00, 0xDF, 0x50, 0x4B, 0xEE, 0xFF, 0xFE, 0xEE, 0xE7, 0x1F, 0xF5, 0x0B, 0xF9, 0x00, 0x00,
  0x04, 0xFF, 0x00, 0xCF, 0xC0, 0x00, 0x00, 0x2F, 0xF2, 0x3E, 0xFF, 0x50, 0x2C, 0x00, 0x6E, 0xEB,
  0x33, 0xBE, 0xED, 0x60,
  // "ç" (U+00E7)
  0x28, 0x38, 0xDE, 0xD8, 0x28, 0x6A, 0xF7, 0x0D, 0xF4, 0x1A, 0x84, 0x20, 0x79, 0x03, 0xA5, 0x03,
  0xA5, 0x01, 0xA0, 0x25, 0x81, 0xAF, 0x92, 0x09, 0x03, 0x28, 0x39, 0xDE, 0xD8, 0x48, 0x14, 0xC2,
  0x68, 0x17, 0xE1, 0x58, 0x17, 0xF1, 0x38, 0x23, 0xED, 0x62,
  // "è" (U+00E8)
  0x18, 0x12, 0x77, 0x68, 0x19, 0xF8, 0x68, 0x16, 0xE3, 0x75, 0x83, 0x8D, 0xED, 0x62, 0x86, 0x9F,
  0x70, 0xAF, 0x71, 0xA8, 0x41, 0x06, 0xFC, 0x3A, 0x80, 0x0E, 0x0D, 0x03, 0xA0, 0x14, 0x01, 0xA0,
  0x35, 0x85, 0x9F, 0xB1, 0x07, 0x72, 0x84, 0x8D, 0xFD, 0xA1,
  // "é" (U+00E9)
  0x58, 0x17, 0x72, 0x48, 0x18, 0xF9, 0x48, 0x13, 0xE6, 0x75, 0x83, 0x8D, 0xED, 0x62, 0x86, 0x9F,
  0x70, 0xAF, 0x71, 0xA8, 0x41, 0x06, 0xFC, 0x3A, 0x80, 0x0E, 0x0D, 0x03, 0xA0, 0x14, 0x01, 0xA0,
  0x35, 0x85, 0x9F, 0xB1, 0x07, 0x72, 0x84, 0x8D, 0xFD, 0xA1,
  // "ê" (U+00EA)
  0x38, 0x16, 0x73, 0x48, 0x26, 0xFD, 0xD3, 0x84, 0x2E, 0x40, 0xAA, 0x74, 0x83, 0x8D, 0xED, 0x62,
  0x86, 0x9F, 0x70, 0xAF, 0x71, 0xA8, 0x41, 0x06, 0xFC, 0x3A, 0x80, 0x0E, 0x0D, 0x03, 0xA0, 0x14,
  0x01, 0xA0, 0x35, 0x85, 0x9F, 0xB1, 0x07, 0x72, 0x84, 0x8D, 0xFD, 0xA1,
  // "ë" (U+00EB)
  0x28, 0x3B, 0x60, 0xA7, 0x38, 0x3D, 0x70, 0xD8, 0x74, 0x83, 0x8D, 0xED, 0x62, 0x86, 0x9F, 0x70,
  0xAF, 0x71, 0xA8, 0x41, 0x06, 0xFC, 0x3A, 0x80, 0x0E, 0x0D, 0x03, 0xA0, 0x14, 0x01, 0xA0, 0x35,
  0x85, 0x9F, 0xB1, 0x07, 0x72, 0x84, 0x8D, 0xFD, 0xA1,
  // "ì" (U+00EC)
  0x81, 0x27, 0x74, 0x81, 0x9F, 0x84, 0x81, 0x6E, 0x37, 0x10, 0xBA, 0x0C, 0x38, 0x19, 0xFC, 0x38,
  0x17, 0xFC, 0x38, 0x17, 0xFC, 0x38, 0x17, 0xFC, 0x38, 0x17, 0xFC, 0x38, 0x19, 0xFD, 0x20, 0xBC,
  // "í" (U+00ED)
  0x38, 0x17, 0x72, 0x28, 0x18, 0xF9, 0x28, 0x13, 0xE6, 0x71, 0x0B, 0xA0, 0xC3, 0x81, 0x9F, 0xC3,
  0x81, 0x7F, 0xC3, 0x81, 0x7F, 0xC3, 0x81, 0x7F, 0xC3, 0x81, 0x7F, 0xC3, 0x81, 0x9F, 0xD2, 0x0B,
  0xC1,
  // "î" (U+00EE)
  0x28, 0x16, 0x73, 0x28, 0x91, 0x6F, 0xDD, 0x02, 0xE4, 0x0A, 0xA7, 0x0B, 0xA0, 0xC3, 0x81, 0x9F,
  0xC3, 0x81, 0x7F, 0xC3, 0x81, 0x7F, 0xC3, 0x81, 0x7F, 0xC3, 0x81, 0x7F, 0xC3, 0x81, 0x9F, 0xD2,
  0x0B, 0xC0,
  // "ï" (U+00EF)
  0xB6, 0x0A, 0x7D, 0x70, 0xD8, 0x00, 0x00, 0x0B, 0xFF, 0xC0, 0x09, 0xFC, 0x00, 0x7F, 0xC0, 0x07,
  0xFC, 0x00, 0x7F, 0xC0, 0x07, 0xFC, 0x00, 0x9F, 0xD0, 0xBF, 0xFF, 0xF0,
  // "ð" (U+00F0)
  0x00, 0x63, 0x00, 0x40, 0x00, 0x06, 0xCD, 0xC9, 0x00, 0x00, 0x3C, 0xAF, 0x70, 0x00, 0x03, 0x20,
  0x7F, 0x40, 0x00, 0x8D, 0xEC, 0xFD, 0x00, 0xAF, 0x80, 0x6F, 0xF3, 0x1F, 0xF2, 0x00, 0xEF, 0x54,
  0xFF, 0x00, 0x0D, 0xF7, 0x4F, 0xF0, 0x00, 0xDF, 0x61, 0xFF, 0x20, 0x0E, 0xF3, 0x0A, 0xF8, 0x06,
  0xFB, 0x00, 0x07, 0xDE, 0xE9, 0x00,
  // "ñ" (U+00F1)
  0x00, 0x9E, 0xA2, 0x96, 0x00, 0x03, 0xB0, 0x8D, 0xA0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9F,
  0xFA, 0x9E, 0xE9, 0x00, 0x09, 0xFF, 0x31, 0xEF, 0x50, 0x07, 0xFD, 0x00, 0xBF, 0x80, 0x07, 0xFC,
  0x00, 0xBF, 0x80, 0x07, 0xFC, 0x00, 0xBF, 0x80, 0x07, 0xFC, 0x00, 0xBF, 0x80, 0x09, 0xFD, 0x00,
  0xBF, 0xA0, 0xAF, 0xFF, 0xD0, 0xBF, 0xF9,
  // "ò" (U+00F2)
  0x18, 0x12, 0x77, 0x78, 0x19, 0xF8, 0x78, 0x16, 0xE3, 0x77, 0x84, 0x7C, 0xED, 0x91, 0x28, 0x7A,
  0xF8, 0x06, 0xFC, 0x01, 0xA0, 0x22, 0x82, 0xEF, 0x44, 0xA3, 0x82, 0xDF, 0x64, 0xA0, 0x12, 0x82,
  0xDF, 0x61, 0xA0, 0x22, 0x89, 0x1E, 0xF4, 0x0A, 0xF8, 0x06, 0xFC, 0x38, 0x47, 0xDE, 0xD9, 0x11,
  // "ó" (U+00F3)
  0x58, 0x17, 0x72, 0x58, 0x18, 0xF9, 0x58, 0x13, 0xE6, 0x77, 0x84, 0x7C, 0xED, 0x91, 0x28, 0x7A,
  0xF8, 0x06, 0xFC, 0x01, 0xA0, 0x22, 0x82, 0xEF, 0x44, 0xA3, 0x82, 0xDF, 0x64, 0xA0, 0x12, 0x82,
  0xDF, 0x61, 0xA0, 0x22, 0x89, 0x1E, 0xF4, 0x0A, 0xF8, 0x06, 0xFC, 0x38, 0x47, 0xDE, 0xD9, 0x11,
  // "ô" (U+00F4)
  0x38, 0x16, 0x73, 0x58, 0x26, 0xFD, 0xD4, 0x84, 0x2E, 0x40, 0xAA, 0x76, 0x84, 0x7C, 0xED, 0x91,
  0x28, 0x7A, 0xF8, 0x06, 0xFC, 0x01, 0xA0, 0x22, 0x82, 0xEF, 0x44, 0xA3, 0x82, 0xDF, 0x64, 0xA0,
  0x12, 0x82, 0xDF, 0x61, 0xA0, 0x22, 0x89, 0x1E, 0xF4, 0x0A, 0xF8, 0x06, 0xFC, 0x38, 0x47, 0xDE,
  0xD9, 0x11,
  // "õ" (U+00F5)
  0x28, 0x49, 0xEA, 0x29, 0x62, 0x84, 0x3B, 0x08, 0xDA, 0x76, 0x84, 0x7C, 0xED, 0x91, 0x28, 0x7A,
  0xF8, 0x06, 0xFC, 0x01, 0xA0, 0x22, 0x82, 0xEF, 0x44, 0xA3, 0x82, 0xDF, 0x64, 0xA0, 0x12, 0x82,
  0xDF, 0x61, 0xA0, 0x22, 0x89, 0x1E, 0xF4, 0x0A, 0xF8, 0x06, 0xFC, 0x38, 0x47, 0xDE, 0xD9, 0x11,
  // "ö" (U+00F6)
  0x28, 0x3B, 0x60, 0xA7, 0x48, 0x3D, 0x70, 0xD8, 0x76, 0x84, 0x7C, 0xED, 0x91, 0x28, 0x7A, 0xF8,
  0x06, 0xFC, 0x01, 0xA0, 0x22, 0x82, 0xEF, 0x44, 0xA3, 0x82, 0xDF, 0x64, 0xA0, 0x12, 0x82, 0xDF,
  0x61, 0xA0, 0x22, 0x89, 0x1E, 0xF4, 0x0A, 0xF8, 0x06, 0xFC, 0x38, 0x47, 0xDE, 0xD9, 0x11,
  // "÷" (U+00F7)
  0x20, 0x70, 0xD5, 0x05, 0x0A, 0x73, 0x80, 0x2E, 0x05, 0x72, 0x05, 0x0A, 0x50, 0x70, 0xD3,
  // "ø" (U+00F8)
  0x00, 0x00, 0x00, 0x16, 0x00, 0x07, 0xCE, 0xEC, 0x70, 0x0A, 0xF8, 0x07, 0xFC, 0x01, 0xFF, 0x20,
  0xDF, 0xF4, 0x4F, 0xF1, 0x88, 0xDF, 0x64, 0xFF, 0x3C, 0x0D, 0xF6, 0x1F, 0xFD, 0x30, 0xEF, 0x40,
  0xAF, 0xB0, 0x6F, 0xC0, 0x02, 0xED, 0xED, 0x91, 0x00, 0x43, 0x00, 0x00, 0x00,
  // "ù" (U+00F9)
  0x18, 0x12, 0x77, 0x71, 0x81, 0x9F, 0x87, 0x18, 0x16, 0xE3, 0x77, 0x09, 0xA8, 0x1B, 0x0D, 0xA0,
  0x72, 0x81, 0xAF, 0xB2, 0x81, 0xDF, 0x72, 0x81, 0x8F, 0xB2, 0x81, 0xCF, 0x72, 0x81, 0x8F, 0xB2,
  0x81, 0xCF, 0x72, 0x81, 0x8F, 0xB2, 0x81, 0xCF, 0x72, 0x81, 0x8F, 0xB2, 0x81, 0xDF, 0x72, 0x83,
  0x5F, 0xE1, 0x3A, 0x09, 0x38, 0x39, 0xEE, 0xA9, 0xA0, 0x90,
  // "ú" (U+00FA)
  0x58, 0x17, 0x72, 0x68, 0x18, 0xF9, 0x68, 0x13, 0xE6, 0x77, 0x09, 0xA8, 0x1B, 0x0D, 0xA0, 0x72,
  0x81, 0xAF, 0xB2, 0x81, 0xDF, 0x72, 0x81, 0x8F, 0xB2, 0x81, 0xCF, 0x72, 0x81, 0x8F, 0xB2, 0x81,
  0xCF, 0x72, 0x81, 0x8F, 0xB2, 0x81, 0xCF, 0x72, 0x81, 0x8F, 0xB2, 0x81, 0xDF, 0x72, 0x83, 0x5F,
  0xE1, 0x3A, 0x09, 0x38, 0x39, 0xEE, 0xA9, 0xA0, 0x90,
  // "û" (U+00FB)
  0x48, 0x16, 0x73, 0x68, 0x26, 0xFD, 0xD5, 0x84, 0x2E, 0x40, 0xAA, 0x75, 0x09, 0xA8, 0x1B, 0x0D,
  0xA0, 0x72, 0x81, 0xAF, 0xB2, 0x81, 0xDF, 0x72, 0x81, 0x8F, 0xB2, 0x81, 0xCF, 0x72, 0x81, 0x8F,
  0xB2, 0x81, 0xCF, 0x72, 0x81, 0x8F, 0xB2, 0x81, 0xCF, 0x72, 0x81, 0x8F, 0xB2, 0x81, 0xDF, 0x72,
  0x83, 0x5F, 0xE1, 0x3A, 0x09, 0x38, 0x39, 0xEE, 0xA9, 0xA0, 0x90,
  // "ü" (U+00FC)
  0x00, 0x0B, 0x60, 0xA7, 0x00, 0x00, 0x0D, 0x70, 0xD8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9F,
  0xFB, 0x0D, 0xFF, 0x70, 0x0A, 0xFB, 0x00, 0xDF, 0x70, 0x08, 0xFB, 0x00, 0xCF, 0x70, 0x08, 0xFB,
  0x00, 0xCF, 0x70, 0x08, 0xFB, 0x00, 0xCF, 0x70, 0x08, 0xFB, 0x00, 0xDF, 0x70, 0x05, 0xFE, 0x13,
  0xFF, 0x90, 0x00, 0x9E, 0xEA, 0x9F, 0xF9,
  // "ý" (U+00FD)
  0x58, 0x17, 0x72, 0x58, 0x18, 0xF9, 0x58, 0x13, 0xE6, 0x75, 0xC0, 0x40, 0xAA, 0x83, 0xA1, 0xEF,
  0x62, 0x0A, 0x0B, 0x28, 0x18, 0xFA, 0x20, 0xD0, 0x32, 0x01, 0xA8, 0x11, 0x3D, 0x48, 0x3A, 0xF7,
  0x97, 0x48, 0x33, 0xFD, 0xE1, 0x58, 0x1C, 0xFA, 0x68, 0x16, 0xF4, 0x60, 0xA0, 0xD6, 0x81, 0x7F,
  0x54, 0x82, 0x8E, 0xC5, 0x50,
  // "þ" (U+00FE)
  0x0A, 0xA0, 0xB6, 0x81, 0xAF, 0xB6, 0x81, 0x8F, 0xB6, 0x85, 0x8F, 0x98, 0xED, 0x82, 0x89, 0x28,
  0xFE, 0x30, 0xCF, 0x70, 0x8F, 0xD2, 0x85, 0x7F, 0xC0, 0x8F, 0xB2, 0x85, 0x5F, 0xE0, 0x8F, 0xB2,
  0x85, 0x5F, 0xE0, 0x8F, 0xD2, 0x83, 0x7F, 0xC0, 0x8A, 0x89, 0x33, 0x0C, 0xF7, 0x08, 0xFA, 0x9E,
  0xD8, 0x28, 0x18, 0xFB, 0x68, 0x1A, 0xFC, 0x50, 0xCB, 0x0E, 0x01, 0x30,
  // "ÿ" (U+00FF)
  0x28, 0x3B, 0x60, 0xA7, 0x48, 0x3D, 0x70, 0xD8, 0x74, 0xC0, 0x40, 0xAA, 0x83, 0xA1, 0xEF, 0x62,
  0x0A, 0x0B, 0x28, 0x18, 0xFA, 0x20, 0xD0, 0x32, 0x01, 0xA8, 0x11, 0x3D, 0x48, 0x3A, 0xF7, 0x97,
  0x48, 0x33, 0xFD, 0xE1, 0x58, 0x1C, 0xFA, 0x68, 0x16, 0xF4, 0x60, 0xA0, 0xD6, 0x81, 0x7F, 0x54,
  0x82, 0x8E, 0xC5, 0x50,
  // "Ā" (U+0100)
  0x38, 0x35, 0xEE, 0xED, 0x77, 0x68, 0x18, 0xFE, 0x72, 0x82, 0xDE, 0xF5, 0x78, 0x34, 0xD8, 0xFB,
  0x78, 0x1B, 0x83, 0xA0, 0x15, 0x85, 0x2F, 0x20, 0xEF, 0x75, 0x08, 0x0C, 0x28, 0x19, 0xFD, 0x58,
  0x3E, 0xED, 0xDE, 0xA0, 0x43, 0x81, 0x5E, 0x13, 0x81, 0xCF, 0xA3, 0x0C, 0x0B, 0x40, 0x7A, 0x81,
  0x20, 0xEA, 0x0D, 0x20, 0x9C, 0x04,
  // "ā" (U+0101)
  0x28, 0x35, 0xEE, 0xED, 0x75, 0x84, 0x3B, 0xEE, 0xD8, 0x38, 0x59, 0xF8, 0x0D, 0xF5, 0x38, 0x42,
  0x10, 0xBF, 0x82, 0x82, 0x4B, 0xEE, 0xA8, 0x18, 0x01, 0xA8, 0x55, 0x0B, 0xF8, 0x04, 0xA2, 0x83,
  0xCF, 0x80, 0x2A, 0x83, 0x23, 0xEF, 0x92, 0x83, 0x6E, 0xE8, 0x6A, 0x07,
  // "Ă" (U+0102)
  0x30, 0x20, 0x52, 0x05, 0x03, 0x68, 0x42, 0xD1, 0x1E, 0x27, 0x82, 0x5D, 0xD5, 0x77, 0x68, 0x18,
  0xFE, 0x72, 0x82, 0xDE, 0xF5, 0x78, 0x34, 0xD8, 0xFB, 0x78, 0x1B, 0x83, 0xA0, 0x15, 0x85, 0x2F,
  0x20, 0xEF, 0x75, 0x08, 0x0C, 0x28, 0x19, 0xFD, 0x58, 0x3E, 0xED, 0xDE, 0xA0, 0x43, 0x81, 0x5E,
  0x13, 0x81, 0xCF, 0xA3, 0x0C, 0x0B, 0x40, 0x7A, 0x81, 0x20, 0xEA, 0x0D, 0x20, 0x9C, 0x04,
  // "ă" (U+0103)
  0x10, 0x20, 0x52, 0x05, 0x03, 0x38, 0x42, 0xD1, 0x1E, 0x24, 0x82, 0x5D, 0xD5, 0x76, 0x84, 0x3B,
  0xEE, 0xD8, 0x38, 0x59, 0xF8, 0x0D, 0xF5, 0x38, 0x42, 0x10, 0xBF, 0x82, 0x82, 0x4B, 0xEE, 0xA8,
  0x18, 0x01, 0xA8, 0x55, 0x0B, 0xF8, 0x04, 0xA2, 0x83, 0xCF, 0x80, 0x2A, 0x83, 0x23, 0xEF, 0x92,
  0x83, 0x6E, 0xE8, 0x6A, 0x07,
  // "Ą" (U+0104)
  0x48, 0x18, 0xFE, 0x72, 0x82, 0xDE, 0xF5, 0x78, 0x34, 0xD8, 0xFB, 0x78, 0x1B, 0x83, 0xA0, 0x15,
  0x85, 0x2F, 0x20, 0xEF, 0x75, 0x08, 0x0C, 0x28, 0x19, 0xFD, 0x58, 0x3E, 0xED, 0xDE, 0xA0, 0x43,
  0x81, 0x5E, 0x13, 0x81, 0xCF, 0xA3, 0x0C, 0x0B, 0x40, 0x7A, 0x81, 0x20, 0xEA, 0x0D, 0x20, 0x9C,
  0x04, 0x78, 0x14, 0xE2, 0x72, 0x0A, 0x0D, 0x73, 0x82, 0x5E, 0xFB, 0x73, 0x01, 0x20,
  // "ą" (U+0105)
  0x18, 0x43, 0xBE, 0xED, 0x83, 0x85, 0x9F, 0x80, 0xDF, 0x53, 0x84, 0x21, 0x0B, 0xF8, 0x28, 0x24,
  0xBE, 0xEA, 0x81, 0x80, 0x1A, 0x85, 0x50, 0xBF, 0x80, 0x4A, 0x28, 0x3C, 0xF8, 0x02, 0xA8, 0x32,
  0x3E, 0xF9, 0x28, 0x36, 0xEE, 0x88, 0xA0, 0x74, 0x81, 0x4E, 0x26, 0x0A, 0x0D, 0x78, 0x25, 0xEF,
  0xB7, 0x01, 0x20,
  // "Ć" (U+0106)
  0x68, 0x17, 0x72, 0x68, 0x18, 0xF9, 0x68, 0x13, 0xE6, 0x77, 0x28, 0x47, 0xCE, 0xED, 0x72, 0x89,
  0x31, 0xCF, 0x50, 0x1D, 0xF5, 0x09, 0xFB, 0x38, 0x56, 0xA1, 0x0E, 0xF7, 0x60, 0x1A, 0x06, 0x60,
  0x1A, 0x05, 0x78, 0x1E, 0xF7, 0x78, 0x19, 0xFC, 0x78, 0x71, 0xDF, 0x81, 0x01, 0x94, 0x38, 0x47,
  0xCE, 0xED, 0x71,
  // "ć" (U+0107)
  0x58, 0x17, 0x72, 0x48, 0x18, 0xF9, 0x48, 0x13, 0xE6, 0x75, 0x83, 0x8D, 0xED, 0x82, 0x86, 0xAF,
  0x70, 0xDF, 0x41, 0xA8, 0x42, 0x07, 0x90, 0x3A, 0x50, 0x3A, 0x50, 0x1A, 0x02, 0x58, 0x1A, 0xF9,
  0x20, 0x90, 0x32, 0x83, 0x9D, 0xED, 0x81,
  // "Ĉ" (U+0108)
  0x48, 0x16, 0x73, 0x68, 0x26, 0xFD, 0xD5, 0x84, 0x2E, 0x40, 0xAA, 0x77, 0x18, 0x47, 0xCE, 0xED,
  0x72, 0x89, 0x31, 0xCF, 0x50, 0x1D, 0xF5, 0x09, 0xFB, 0x38, 0x56, 0xA1, 0x0E, 0xF7, 0x60, 0x1A,
  0x06, 0x60, 0x1A, 0x05, 0x78, 0x1E, 0xF7, 0x78, 0x19, 0xFC, 0x78, 0x71, 0xDF, 0x81, 0x01, 0x94,
  0x38, 0x47, 0xCE, 0xED, 0x71,
  // "ĉ" (U+0109)
  0x38, 0x16, 0x73, 0x48, 0x26, 0xFD, 0xD3, 0x84, 0x2E, 0x40, 0xAA, 0x74, 0x83, 0x8D, 0xED, 0x82,
  0x86, 0xAF, 0x70, 0xDF, 0x41, 0xA8, 0x42, 0x07, 0x90, 0x3A, 0x50, 0x3A, 0x50, 0x1A, 0x02, 0x58,
  0x1A, 0xF9, 0x20, 0x90, 0x32, 0x83, 0x9D, 0xED, 0x81,
  // "Ċ" (U+010A)
  0x48, 0x23, 0xED, 0x16, 0x81, 0x3D, 0xC7, 0x72, 0x84, 0x7C, 0xEE, 0xD7, 0x28, 0x93, 0x1C, 0xF5,
  0x01, 0xDF, 0x50, 0x9F, 0xB3, 0x85, 0x6A, 0x10, 0xEF, 0x76, 0x01, 0xA0, 0x66, 0x01, 0xA0, 0x57,
  0x81, 0xEF, 0x77, 0x81, 0x9F, 0xC7, 0x87, 0x1D, 0xF8, 0x10, 0x19, 0x43, 0x84, 0x7C, 0xEE, 0xD7,
  0x10,
  // "ċ" (U+010B)
  0x28, 0x23, 0xED, 0x14, 0x81, 0x3D, 0xC7, 0x68, 0x38, 0xDE, 0xD8, 0x28, 0x6A, 0xF7, 0x0D, 0xF4,
  0x1A, 0x84, 0x20, 0x79, 0x03, 0xA5, 0x03, 0xA5, 0x01, 0xA0, 0x25, 0x81, 0xAF, 0x92, 0x09, 0x03,
  0x28, 0x39, 0xDE, 0xD8, 0x10,
  // "Č" (U+010C)
  0x20, 0x20, 0x62, 0x03, 0x06, 0x58, 0x3B, 0xB5, 0xE4, 0x58, 0x21, 0xEF, 0x97, 0x72, 0x84, 0x7C,
  0xEE, 0xD7, 0x28, 0x93, 0x1C, 0xF5, 0x01, 0xDF, 0x50, 0x9F, 0xB3, 0x85, 0x6A, 0x10, 0xEF, 0x76,
  0x01, 0xA0, 0x66, 0x01, 0xA0, 0x57, 0x81, 0xEF, 0x77, 0x81, 0x9F, 0xC7, 0x87, 0x1D, 0xF8, 0x10,
  0x19, 0x43, 0x84, 0x7C, 0xEE, 0xD7, 0x10,
  // "č" (U+010D)
  0x10, 0x20, 0x62, 0x03, 0x06, 0x38, 0x3B, 0xB5, 0xE4, 0x38, 0x21, 0xEF, 0x97, 0x58, 0x38, 0xDE,
  0xD8, 0x28, 0x6A, 0xF7, 0x0D, 0xF4, 0x1A, 0x84, 0x20, 0x79, 0x03, 0xA5, 0x03, 0xA5, 0x01, 0xA0,
  0x25, 0x81, 0xAF, 0x92, 0x09, 0x03, 0x28, 0x39, 0xDE, 0xD8, 0x10,
  // "Ď" (U+010E)
  0x20, 0x20, 0x62, 0x03, 0x06, 0x68, 0x3B, 0xB5, 0xE4, 0x68, 0x21, 0xEF, 0x97, 0x71, 0x08, 0xB8,
  0x3E, 0xFE, 0xA4, 0x30, 0x3A, 0x84, 0x20, 0x4E, 0xF7, 0x20, 0x2A, 0x02, 0x20, 0x5A, 0x81, 0x30,
  0x2A, 0x02, 0x3A, 0x81, 0x80, 0x2A, 0x02, 0x38, 0x3D, 0xFA, 0x02, 0xA0, 0x23, 0x83, 0xEF, 0x90,
  0x2A, 0x02, 0x20, 0x1A, 0x81, 0x60, 0x2A, 0x02, 0x28, 0x47, 0xFE, 0x10, 0x3A, 0x86, 0x20, 0x4E,
  0xF5, 0x08, 0xB8, 0x3E, 0xED, 0xA3, 0x20,
  // "ď" (U+010F)
  0x40, 0x5B, 0x82, 0x37, 0xF2, 0x50, 0x2A, 0x81, 0x3C, 0x77, 0xA0, 0x30, 0x23, 0x83, 0x1B, 0xED,
  0x5A, 0x03, 0x48, 0x3C, 0xF7, 0x09, 0xA0, 0x33, 0x02, 0xA8, 0x12, 0x03, 0xA0, 0x33, 0x04, 0xA2,
  0x01, 0xA0, 0x33, 0x04, 0xA2, 0x01, 0xA0, 0x33, 0x02, 0xA8, 0x11, 0x03, 0xA0, 0x34, 0x83, 0xCF,
  0x70, 0x8A, 0x05, 0x48, 0x41, 0xBE, 0xD6, 0x9A, 0x07, 0x20,
  // "Đ" (U+0110)
  0x8F, 0xFF, 0xEF, 0xEA, 0x40, 0x00, 0x3F, 0xF2, 0x04, 0xEF, 0x70, 0x02, 0xFF, 0x20, 0x05, 0xFF,
  0x30, 0x2F, 0xF2, 0x00, 0x0F, 0xF8, 0x6E, 0xFF, 0xEE, 0x00, 0xDF, 0xA0, 0x2F, 0xF2, 0x00, 0x0E,
  0xF9, 0x02, 0xFF, 0x20, 0x01, 0xFF, 0x60, 0x2F, 0xF2, 0x00, 0x7F, 0xE1, 0x04, 0xFF, 0x20, 0x4E,
  0xF5, 0x08, 0xFF, 0xFE, 0xED, 0xA3, 0x00,
  // "đ" (U+0111)
  0x00, 0x00, 0x5F, 0xFF, 0x30, 0x00, 0x00, 0x02, 0xFF, 0x30, 0x00, 0x05, 0xEE, 0xFF, 0xE7, 0x01,
  0xBE, 0xD5, 0xFF, 0x30, 0x0C, 0xF7, 0x09, 0xFF, 0x30, 0x2F, 0xF2, 0x03, 0xFF, 0x30, 0x4F, 0xF0,
  0x01, 0xFF, 0x30, 0x4F, 0xF0, 0x01, 0xFF, 0x30, 0x2F, 0xF1, 0x03, 0xFF, 0x30, 0x0C, 0xF7, 0x08,
  0xFF, 0x50, 0x01, 0xBE, 0xD6, 0x9F, 0xF7,
  // "Ē" (U+0112)
  0x28, 0x35, 0xEE, 0xED, 0x76, 0x07, 0x0E, 0xA0, 0xFC, 0x0E, 0x0B, 0x20, 0x3A, 0x03, 0x20, 0x60,
  0xC2, 0x02, 0xA0, 0x32, 0x01, 0x05, 0x20, 0x2A, 0x03, 0x60, 0x2A, 0x0F, 0xE0, 0xA3, 0x02, 0xA0,
  0x36, 0x02, 0xA0, 0x36, 0x02, 0xA0, 0x33, 0x82, 0x83, 0x03, 0xA0, 0x33, 0x82, 0xE4, 0x7E, 0xA0,
  0xFC, 0x81, 0xDF, 0x30,
  // "ē" (U+0113)
  0x28, 0x35, 0xEE, 0xED, 0x74, 0x83, 0x8D, 0xED, 0x62, 0x86, 0x9F, 0x70, 0xAF, 0x71, 0xA8, 0x41,
  0x06, 0xFC, 0x3A, 0x80, 0x0E, 0x0D, 0x03, 0xA0, 0x14, 0x01, 0xA0, 0x35, 0x85, 0x9F, 0xB1, 0x07,
  0x72, 0x84, 0x8D, 0xFD, 0xA1,
  // "Ĕ" (U+0114)
  0x20, 0x20, 0x52, 0x05, 0x03, 0x48, 0x42, 0xD1, 0x1E, 0x25, 0x82, 0x5D, 0xD5, 0x76, 0x07, 0x0E,
  0xA0, 0xFC, 0x0E, 0x0B, 0x20, 0x3A, 0x03, 0x20, 0x60, 0xC2, 0x02, 0xA0, 0x32, 0x01, 0x05, 0x20,
  0x2A, 0x03, 0x60, 0x2A, 0x0F, 0xE0, 0xA3, 0x02, 0xA0, 0x36, 0x02, 0xA0, 0x36, 0x02, 0xA0, 0x33,
  0x82, 0x83, 0x03, 0xA0, 0x33, 0x82, 0xE4, 0x7E, 0xA0, 0xFC, 0x81, 0xDF, 0x30,
  // "ĕ" (U+0115)
  0x10, 0x20, 0x52, 0x05, 0x03, 0x28, 0x42, 0xD1, 0x1E, 0x23, 0x82, 0x5D, 0xD5, 0x75, 0x83, 0x8D,
  0xED, 0x62, 0x86, 0x9F, 0x70, 0xAF, 0x71, 0xA8, 0x41, 0x06, 0xFC, 0x3A, 0x80, 0x0E, 0x0D, 0x03,
  0xA0, 0x14, 0x01, 0xA0, 0x35, 0x85, 0x9F, 0xB1, 0x07, 0x72, 0x84, 0x8D, 0xFD, 0xA1,
  // "Ė" (U+0116)
  0x38, 0x23, 0xED, 0x16, 0x81, 0x3D, 0xC7, 0x70, 0x70, 0xEA, 0x0F, 0xC0, 0xE0, 0xB2, 0x03, 0xA0,
  0x32, 0x06, 0x0C, 0x20, 0x2A, 0x03, 0x20, 0x10, 0x52, 0x02, 0xA0, 0x36, 0x02, 0xA0, 0xFE, 0x0A,
  0x30, 0x2A, 0x03, 0x60, 0x2A, 0x03, 0x60, 0x2A, 0x03, 0x38, 0x28, 0x30, 0x3A, 0x03, 0x38, 0x2E,
  0x47, 0xEA, 0x0F, 0xC8, 0x1D, 0xF3,
  // "ė" (U+0117)
  0x38, 0x23, 0xED, 0x14, 0x81, 0x3D, 0xC7, 0x58, 0x38, 0xDE, 0xD6, 0x28, 0x69, 0xF7, 0x0A, 0xF7,
  0x1A, 0x84, 0x10, 0x6F, 0xC3, 0xA8, 0x00, 0xE0, 0xD0, 0x3A, 0x01, 0x40, 0x1A, 0x03, 0x58, 0x59,
  0xFB, 0x10, 0x77, 0x28, 0x48, 0xDF, 0xDA, 0x10,
  // "Ę" (U+0118)
  0x07, 0x0E, 0xA0, 0xFC, 0x0E, 0x0B, 0x20, 0x3A, 0x03, 0x20, 0x60, 0xC2, 0x02, 0xA0, 0x32, 0x01,
  0x05, 0x20, 0x2A, 0x03, 0x60, 0x2A, 0x0F, 0xE0, 0xA3, 0x02, 0xA0, 0x36, 0x02, 0xA0, 0x36, 0x02,
  0xA0, 0x33, 0x82, 0x83, 0x03, 0xA0, 0x33, 0x82, 0xE4, 0x7E, 0xA8, 0x1C, 0xCE, 0xA0, 0x35, 0x81,
  0x4E, 0x17, 0x0A, 0x0D, 0x71, 0x82, 0x5E, 0xFA, 0x71, 0x01, 0x20,
  // "ę" (U+0119)
  0x28, 0x38, 0xDE, 0xD6, 0x28, 0x69, 0xF7, 0x0A, 0xF7, 0x1A, 0x84, 0x10, 0x6F, 0xC3, 0xA8, 0x00,
  0xE0, 0xD0, 0x3A, 0x01, 0x40, 0x1A, 0x03, 0x58, 0x59, 0xFB, 0x10, 0x77, 0x20, 0x80, 0xDA, 0x09,
  0x01, 0x38, 0x11, 0xC5, 0x58, 0x17, 0xF1, 0x58, 0x22, 0xCE, 0xC1,
  // "Ě" (U+011A)
  0x20, 0x20, 0x62, 0x03, 0x06, 0x58, 0x3B, 0xB5, 0xE4, 0x58, 0x21, 0xEF, 0x97, 0x60, 0x70, 0xEA,
  0x0F, 0xC0, 0xE0, 0xB2, 0x03, 0xA0, 0x32, 0x06, 0x0C, 0x20, 0x2A, 0x03, 0x20, 0x10, 0x52, 0x02,
  0xA0, 0x36, 0x02, 0xA0, 0xFE, 0x0A, 0x30, 0x2A, 0x03, 0x60, 0x2A, 0x03, 0x60, 0x2A, 0x03, 0x38,
  0x28, 0x30, 0x3A, 0x03, 0x38, 0x2E, 0x47, 0xEA, 0x0F, 0xC8, 0x1D, 0xF3,
  // "ě" (U+011B)
  0x10, 0x20, 0x62, 0x03, 0x06, 0x38, 0x3B, 0xB5, 0xE4, 0x38, 0x21, 0xEF, 0x97, 0x58, 0x38, 0xDE,
  0xD6, 0x28, 0x69, 0xF7, 0x0A, 0xF7, 0x1A, 0x84, 0x10, 0x6F, 0xC3, 0xA8, 0x00, 0xE0, 0xD0, 0x3A,
  0x01, 0x40, 0x1A, 0x03, 0x58, 0x59, 0xFB, 0x10, 0x77, 0x28, 0x48, 0xDF, 0xDA, 0x10,
  // "Ĝ" (U+011C)
  0x58, 0x16, 0x73, 0x71, 0x82, 0x6F, 0xDD, 0x78, 0x42, 0xE4, 0x0A, 0xA7, 0x74, 0x85, 0x6B, 0xDE,
  0xEB, 0x54, 0x81, 0xBF, 0x82, 0x04, 0xA0, 0x12, 0x81, 0x8F, 0xC4, 0x07, 0x05, 0x38, 0x1E, 0xF7,
  0x71, 0x01, 0xA0, 0x67, 0x10, 0x1A, 0x06, 0x20, 0x8B, 0x84, 0xE1, 0x0E, 0xF7, 0x30, 0x7A, 0x02,
  0x28, 0x19, 0xFC, 0x30, 0x5A, 0x48, 0x4C, 0xF8, 0x10, 0x5A, 0x58, 0x56, 0xCE, 0xED, 0xB6, 0x20,
  // "ĝ" (U+011D)
  0x38, 0x16, 0x73, 0x58, 0x26, 0xFD, 0xD4, 0x84, 0x2E, 0x40, 0xAA, 0x71, 0x8A, 0x1A, 0xE2, 0x03,
  0xCE, 0xFE, 0x7B, 0x10, 0xEF, 0x15, 0xF9, 0x28, 0x53, 0xFD, 0x02, 0xFD, 0x38, 0x4E, 0xF1, 0x5F,
  0xA3, 0x84, 0x3E, 0xED, 0x91, 0x30, 0xB0, 0x97, 0x89, 0x0E, 0xFE, 0xED, 0xA2, 0x01, 0x9D, 0x83,
  0xB0, 0xCE, 0x22, 0x85, 0x1F, 0xD0, 0xDE, 0x12, 0x89, 0x15, 0xF8, 0x03, 0xBE, 0xEE, 0xC6, 0x20,
  // "Ğ" (U+011E)
  0x30, 0x20, 0x52, 0x05, 0x03, 0x68, 0x42, 0xD1, 0x1E, 0x27, 0x82, 0x5D, 0xD5, 0x77, 0x58, 0x56,
  0xBD, 0xEE, 0xB5, 0x48, 0x1B, 0xF8, 0x20, 0x4A, 0x01, 0x28, 0x18, 0xFC, 0x40, 0x70, 0x53, 0x81,
  0xEF, 0x77, 0x10, 0x1A, 0x06, 0x71, 0x01, 0xA0, 0x62, 0x08, 0xB8, 0x4E, 0x10, 0xEF, 0x73, 0x07,
  0xA0, 0x22, 0x81, 0x9F, 0xC3, 0x05, 0xA4, 0x84, 0xCF, 0x81, 0x05, 0xA5, 0x85, 0x6C, 0xEE, 0xDB,
  0x62,
  // "ğ" (U+011F)
  0x10, 0x20, 0x52, 0x05, 0x03, 0x38, 0x42, 0xD1, 0x1E, 0x24, 0x82, 0x5D, 0xD5, 0x72, 0x8A, 0x1A,
  0xE2, 0x03, 0xCE, 0xFE, 0x7B, 0x10, 0xEF, 0x15, 0xF9, 0x28, 0x53, 0xFD, 0x02, 0xFD, 0x38, 0x4E,
  0xF1, 0x5F, 0xA3, 0x84, 0x3E, 0xED, 0x91, 0x30, 0xB0, 0x97, 0x89, 0x0E, 0xFE, 0xED, 0xA2, 0x01,
  0x9D, 0x83, 0xB0, 0xCE, 0x22, 0x85, 0x1F, 0xD0, 0xDE, 0x12, 0x89, 0x15, 0xF8, 0x03, 0xBE, 0xEE,
  0xC6, 0x20,
  // "Ġ" (U+0120)
  0x48, 0x23, 0xED, 0x17, 0x18, 0x13, 0xDC, 0x77, 0x68, 0x56, 0xBD, 0xEE, 0xB5, 0x48, 0x1B, 0xF8,
  0x20, 0x4A, 0x01, 0x28, 0x18, 0xFC, 0x40, 0x70, 0x53, 0x81, 0xEF, 0x77, 0x10, 0x1A, 0x06, 0x71,
  0x01, 0xA0, 0x62, 0x08, 0xB8, 0x4E, 0x10, 0xEF, 0x73, 0x07, 0xA0, 0x22, 0x81, 0x9F, 0xC3, 0x05,
  0xA4, 0x84, 0xCF, 0x81, 0x05, 0xA5, 0x85, 0x6C, 0xEE, 0xDB, 0x62,
  // "ġ" (U+0121)
  0x28, 0x23, 0xED, 0x15, 0x81, 0x3D, 0xC7, 0x38, 0xA1, 0xAE, 0x20, 0x3C, 0xEF, 0xE7, 0xB1, 0x0E,
  0xF1, 0x5F, 0x92, 0x85, 0x3F, 0xD0, 0x2F, 0xD3, 0x84, 0xEF, 0x15, 0xFA, 0x38, 0x43, 0xEE, 0xD9,
  0x13, 0x0B, 0x09, 0x78, 0x90, 0xEF, 0xEE, 0xDA, 0x20, 0x19, 0xD8, 0x3B, 0x0C, 0xE2, 0x28, 0x51,
  0xFD, 0x0D, 0xE1, 0x28, 0x91, 0x5F, 0x80, 0x3B, 0xEE, 0xEC, 0x62,
  // "Ģ" (U+0122)
  0x38, 0x56, 0xBD, 0xEE, 0xB5, 0x48, 0x1B, 0xF8, 0x20, 0x4A, 0x01, 0x28, 0x18, 0xFC, 0x40, 0x70,
  0x53, 0x81, 0xEF, 0x77, 0x10, 0x1A, 0x06, 0x71, 0x01, 0xA0, 0x62, 0x08, 0xB8, 0x4E, 0x10, 0xEF,
  0x73, 0x07, 0xA0, 0x22, 0x81, 0x9F, 0xC3, 0x05, 0xA4, 0x84, 0xCF, 0x81, 0x05, 0xA5, 0x85, 0x6C,
  0xEE, 0xDB, 0x67, 0x01, 0x02, 0x73, 0x0B, 0x0D, 0x73, 0x0E, 0x03, 0x50,
  // "ģ" (U+0123)
  0x40, 0xD0, 0x46, 0x09, 0x97, 0x8A, 0x42, 0x20, 0xAE, 0x20, 0x3C, 0xEF, 0xE7, 0xB1, 0x0E, 0xF1,
  0x5F, 0x92, 0x85, 0x3F, 0xD0, 0x2F, 0xD3, 0x84, 0xEF, 0x15, 0xFA, 0x38, 0x43, 0xEE, 0xD9, 0x13,
  0x0B, 0x09, 0x78, 0x90, 0xEF, 0xEE, 0xDA, 0x20, 0x19, 0xD8, 0x3B, 0x0C, 0xE2, 0x28, 0x51, 0xFD,
  0x0D, 0xE1, 0x28, 0x91, 0x5F, 0x80, 0x3B, 0xEE, 0xEC, 0x62,
  // "Ĥ" (U+0124)
  0x58, 0x16, 0x73, 0x71, 0x82, 0x6F, 0xDD, 0x78, 0x42, 0xE4, 0x0A, 0xA7, 0x71, 0x08, 0xC8, 0x18,
  0x4E, 0xB8, 0x1C, 0x03, 0xA0, 0x33, 0x81, 0xEF, 0x82, 0x02, 0xA0, 0x23, 0x81, 0xEF, 0x72, 0x02,
  0xA0, 0x23, 0x81, 0xEF, 0x72, 0x02, 0xA8, 0x00, 0xEA, 0x07, 0x20, 0x2A, 0x02, 0x38, 0x1E, 0xF7,
  0x20, 0x2A, 0x02, 0x38, 0x1E, 0xF7, 0x20, 0x2A, 0x02, 0x38, 0x1E, 0xF7, 0x20, 0x4A, 0x04, 0x38,
  0x3E, 0xF8, 0x08, 0xC8, 0x18, 0x4E, 0xB0, 0xC0,
  // "ĥ" (U+0125)
  0x48, 0x16, 0x73, 0x68, 0x26, 0xFD, 0xD5, 0x84, 0x2E, 0x40, 0xAA, 0x75, 0x09, 0xA0, 0xC7, 0x81,
  0x8F, 0xC7, 0x81, 0x7F, 0xB7, 0x85, 0x7F, 0xBA, 0xEE, 0x93, 0x07, 0xA8, 0x33, 0x1E, 0xF5, 0x28,
  0x17, 0xFD, 0x28, 0x1B, 0xF8, 0x28, 0x17, 0xFC, 0x28, 0x1B, 0xF8, 0x28, 0x17, 0xFC, 0x28, 0x1B,
  0xF8, 0x28, 0x17, 0xFC, 0x28, 0x1B, 0xF8, 0x28, 0x18, 0xFD, 0x28, 0x3B, 0xF9, 0x09, 0xB8, 0x1C,
  0x0B, 0xA0, 0x70,
  // "Ħ" (U+0126)
  0x08, 0xC8, 0x18, 0x4E, 0xB8, 0x1C, 0x03, 0xA0, 0x33, 0x84, 0xEF, 0x70, 0xAE, 0xA8, 0x00, 0xEA,
  0x82, 0xEE, 0x02, 0xA0, 0x23, 0x81, 0xEF, 0x72, 0x02, 0xA8, 0x00, 0xEA, 0x07, 0x20, 0x2A, 0x02,
  0x38, 0x1E, 0xF7, 0x20, 0x2A, 0x02, 0x38, 0x1E, 0xF7, 0x20, 0x2A, 0x02, 0x38, 0x1E, 0xF7, 0x20,
  0x4A, 0x04, 0x38, 0x3E, 0xF8, 0x08, 0xC8, 0x18, 0x4E, 0xB0, 0xC0,
  // "ħ" (U+0127)
  0x9F, 0xFC, 0x00, 0x00, 0x00, 0x09, 0xFC, 0x00, 0x00, 0x00, 0x9D, 0xFE, 0xCC, 0x10, 0x00, 0x07,
  0xFC, 0xAE, 0xE8, 0x00, 0x07, 0xFF, 0x31, 0xEF, 0x40, 0x07, 0xFD, 0x00, 0xBF, 0x70, 0x07, 0xFC,
  0x00, 0xBF, 0x80, 0x07, 0xFC, 0x00, 0xBF, 0x80, 0x07, 0xFC, 0x00, 0xBF, 0x80, 0x08, 0xFD, 0x00,
  0xBF, 0x90, 0x9F, 0xFF, 0xC0, 0xBF, 0xF7,
  // "Ĩ" (U+0128)
  0x18, 0x92, 0x9E, 0xA2, 0x96, 0x3B, 0x08, 0xDA, 0x72, 0x08, 0xC0, 0x82, 0x04, 0xA0, 0x43, 0x02,
  0xA0, 0x33, 0x02, 0xA0, 0x33, 0x02, 0xA0, 0x33, 0x02, 0xA0, 0x33, 0x02, 0xA0, 0x33, 0x02, 0xA0,
  0x33, 0x03, 0xA0, 0x42, 0x08, 0xC0, 0x80,
  // "ĩ" (U+0129)
  0x18, 0x92, 0x9E, 0xA2, 0x96, 0x3B, 0x08, 0xDA, 0x72, 0x0B, 0xA0, 0xC4, 0x81, 0x9F, 0xC4, 0x81,
  0x7F, 0xC4, 0x81, 0x7F, 0xC4, 0x81, 0x7F, 0xC4, 0x81, 0x7F, 0xC4, 0x81, 0x9F, 0xD3, 0x0B, 0xC1,
  // "Ī" (U+012A)
  0x83, 0x5E, 0xEE, 0xD7, 0x08, 0xC8, 0x18, 0x04, 0xA0, 0x42, 0x02, 0xA0, 0x32, 0x02, 0xA0, 0x32,
  0x02, 0xA0, 0x32, 0x02, 0xA0, 0x32, 0x02, 0xA0, 0x32, 0x02, 0xA0, 0x32, 0x03, 0xA8, 0x14, 0x08,
  0xC0, 0x80,
  // "ī" (U+012B)
  0x5E, 0xEE, 0xD0, 0x00, 0x00, 0xBF, 0xFC, 0x00, 0x9F, 0xC0, 0x07, 0xFC, 0x00, 0x7F, 0xC0, 0x07,
  0xFC, 0x00, 0x7F, 0xC0, 0x09, 0xFD, 0x0B, 0xFF, 0xFF,
  // "Ĭ" (U+012C)
  0x02, 0x05, 0x28, 0x93, 0x53, 0x2D, 0x11, 0xE2, 0x05, 0xDD, 0x57, 0x08, 0xC8, 0x18, 0x04, 0xA0,
  0x42, 0x02, 0xA0, 0x32, 0x02, 0xA0, 0x32, 0x02, 0xA0, 0x32, 0x02, 0xA0, 0x32, 0x02, 0xA0, 0x32,
  0x02, 0xA0, 0x32, 0x03, 0xA8, 0x14, 0x08, 0xC0, 0x80,
  // "ĭ" (U+012D)
  0x02, 0x05, 0x28, 0x93, 0x53, 0x2D, 0x11, 0xE2, 0x05, 0xDD, 0x57, 0x0B, 0xA0, 0xC3, 0x81, 0x9F,
  0xC3, 0x81, 0x7F, 0xC3, 0x81, 0x7F, 0xC3, 0x81, 0x7F, 0xC3, 0x81, 0x7F, 0xC3, 0x81, 0x9F, 0xD2,
  0x0B, 0xC1,
  // "Į" (U+012E)
  0x08, 0xC8, 0x18, 0x04, 0xA0, 0x42, 0x02, 0xA0, 0x32, 0x02, 0xA0, 0x32, 0x02, 0xA0, 0x32, 0x02,
  0xA0, 0x32, 0x02, 0xA0, 0x32, 0x02, 0xA0, 0x32, 0x03, 0xA8, 0x14, 0x08, 0xC8, 0x38, 0x04, 0xE1,
  0x30, 0xA0, 0xD4, 0x82, 0x5E, 0xFA, 0x40, 0x12,
  // "į" (U+012F)
  0x07, 0xE8, 0x00, 0x7F, 0xA0, 0x00, 0x00, 0x0B, 0xFF, 0xC0, 0x09, 0xFC, 0x00, 0x7F, 0xC0, 0x07,
  0xFC, 0x00, 0x7F, 0xC0, 0x07, 0xFC, 0x00, 0x9F, 0xD0, 0xBF, 0xFF, 0xF0, 0x4E, 0x10, 0x0A, 0xD0,
  0x00, 0x5E, 0xFA, 0x00, 0x01, 0x00,
  // "İ" (U+0130)
  0x18, 0x23, 0xED, 0x12, 0x81, 0x3D, 0xC7, 0x10, 0x8C, 0x81, 0x80, 0x4A, 0x04, 0x20, 0x2A, 0x03,
  0x20, 0x2A, 0x03, 0x20, 0x2A, 0x03, 0x20, 0x2A, 0x03, 0x20, 0x2A, 0x03, 0x20, 0x2A, 0x03, 0x20,
  0x3A, 0x81, 0x40, 0x8C, 0x08,
  // "ı" (U+0131)
  0xBF, 0xFC, 0x00, 0x9F, 0xC0, 0x07, 0xFC, 0x00, 0x7F, 0xC0, 0x07, 0xFC, 0x00, 0x7F, 0xC0, 0x09,
  0xFD, 0x0B, 0xFF, 0xFF,
  // "Ĳ" (U+0132)
  0x08, 0xC0, 0x80, 0x7C, 0x81, 0x80, 0x4A, 0x04, 0x20, 0x3A, 0x04, 0x20, 0x2A, 0x03, 0x20, 0x2A,
  0x03, 0x20, 0x2A, 0x03, 0x20, 0x2A, 0x03, 0x20, 0x2A, 0x03, 0x20, 0x2A, 0x03, 0x20, 0x2A, 0x03,
  0x20, 0x2A, 0x03, 0x20, 0x2A, 0x03, 0x20, 0x2A, 0x03, 0x20, 0x2A, 0x03, 0x20, 0x2A, 0x03, 0x20,
  0x3A, 0x04, 0x20, 0x2A, 0x81, 0x30, 0x8C, 0x81, 0x80, 0x2A, 0x03, 0x71, 0x03, 0xA0, 0x27, 0x82,
  0x1B, 0xFB, 0x78, 0x24, 0xED, 0x83,
  // "ĳ" (U+0133)
  0x07, 0xE8, 0x00, 0x6E, 0x90, 0x7F, 0xA0, 0x07, 0xFA, 0x00, 0x00, 0x00, 0x00, 0x0B, 0xFF, 0xC0,
  0xBF, 0xFC, 0x09, 0xFC, 0x00, 0x9F, 0xC0, 0x7F, 0xC0, 0x07, 0xFC, 0x07, 0xFC, 0x00, 0x7F, 0xC0,
  0x7F, 0xC0, 0x07, 0xFC, 0x07, 0xFC, 0x00, 0x7F, 0xC0, 0x9F, 0xD0, 0x07, 0xFC, 0xBF, 0xFF, 0xF0,
  0x7F, 0xC0, 0x00, 0x00, 0x09, 0xFA, 0x00, 0x00, 0x01, 0xDF, 0x50, 0x00, 0x04, 0xEC, 0x60,
  // "Ĵ" (U+0134)
  0x38, 0x16, 0x73, 0x38, 0x26, 0xFD, 0xD2, 0x84, 0x2E, 0x40, 0xAA, 0x71, 0x07, 0xC0, 0x82, 0x03,
  0xA0, 0x43, 0x02, 0xA0, 0x33, 0x02, 0xA0, 0x33, 0x02, 0xA0, 0x33, 0x02, 0xA0, 0x33, 0x02, 0xA0,
  0x33, 0x02, 0xA0, 0x33, 0x02, 0xA0, 0x33, 0x02, 0xA0, 0x33, 0x03, 0xA0, 0x22, 0x82, 0x1B, 0xFB,
  0x28, 0x24, 0xED, 0x83,
  // "ĵ" (U+0135)
  0x00, 0x67, 0x30, 0x06, 0xFD, 0xD0, 0x2E, 0x40, 0xAA, 0x00, 0x00, 0x00, 0x0B, 0xFF, 0xC0, 0x00,
  0x9F, 0xC0, 0x00, 0x7F, 0xC0, 0x00, 0x7F, 0xC0, 0x00, 0x7F, 0xC0, 0x00, 0x7F, 0xC0, 0x00, 0x7F,
  0xC0, 0x00, 0x7F, 0xC0, 0x00, 0x9F, 0xA0, 0x01, 0xDF, 0x50, 0x0E, 0xD7, 0x00,
  // "Ķ" (U+0136)
  0x08, 0xC0, 0x80, 0x6B, 0x81, 0x80, 0x3A, 0x04, 0x28, 0x1B, 0xE4, 0x20, 0x2A, 0x83, 0x20, 0x5D,
  0x23, 0x02, 0xA8, 0x22, 0x5D, 0x24, 0x02, 0xA8, 0x18, 0xFB, 0x50, 0x2A, 0x0C, 0xA0, 0x64, 0x02,
  0xA0, 0x20, 0x8A, 0x02, 0x30, 0x2A, 0x83, 0x20, 0xDF, 0xD3, 0x03, 0xA8, 0x13, 0x04, 0xA8, 0x1A,
  0x08, 0xC8, 0x28, 0x05, 0xDA, 0x50, 0x10, 0x27, 0x20, 0xB0, 0xD7, 0x20, 0xE0, 0x34,
  // "ķ" (U+0137)
  0x0B, 0xA0, 0xC7, 0x81, 0x9F, 0xC7, 0x81, 0x7F, 0xC7, 0x83, 0x7F, 0xC0, 0xBB, 0x28, 0x57, 0xFC,
  0x02, 0xF9, 0x38, 0x47, 0xFC, 0x0B, 0x84, 0x84, 0x7F, 0xBA, 0xF3, 0x40, 0x7A, 0x81, 0xDF, 0xD4,
  0x85, 0x7F, 0xC1, 0xEF, 0x93, 0x83, 0x9F, 0xD0, 0x6A, 0x81, 0x60, 0xBC, 0x18, 0x28, 0xEF, 0x84,
  0x01, 0x02, 0x71, 0x0B, 0x0D, 0x71, 0x0E, 0x03, 0x40,
  // "ĸ" (U+0138)
  0x0B, 0xA8, 0x1C, 0x0B, 0xB2, 0x85, 0x9F, 0xC0, 0x2F, 0x93, 0x84, 0x7F, 0xC0, 0xB8, 0x48, 0x47,
  0xFB, 0xAF, 0x34, 0x07, 0xA8, 0x1D, 0xFD, 0x48, 0x57, 0xFC, 0x1E, 0xF9, 0x38, 0x39, 0xFD, 0x06,
  0xA8, 0x16, 0x0B, 0xC1, 0x82, 0x8E, 0xF8,
  // "Ĺ" (U+0139)
  0x48, 0x17, 0x72, 0x68, 0x18, 0xF9, 0x68, 0x13, 0xE6, 0x77, 0x10, 0x70, 0xEA, 0x0E, 0x07, 0x50,
  0x3A, 0x03, 0x60, 0x2A, 0x03, 0x60, 0x2A, 0x03, 0x60, 0x2A, 0x03, 0x60, 0x2A, 0x03, 0x60, 0x2A,
  0x03, 0x30, 0x12, 0x02, 0xA0, 0x33, 0x82, 0xA4, 0x03, 0xA0, 0x32, 0x83, 0x1E, 0x37, 0xEA, 0x0F,
  0xC8, 0x1E, 0xF3,
  // "ĺ" (U+013A)
  0x38, 0x17, 0x72, 0x28, 0x18, 0xF9, 0x28, 0x13, 0xE6, 0x71, 0x0B, 0xA0, 0xC3, 0x81, 0x9F, 0xC3,
  0x81, 0x7F, 0xC3, 0x81, 0x7F, 0xC3, 0x81, 0x7F, 0xC3, 0x81, 0x7F, 0xC3, 0x81, 0x7F, 0xC3, 0x81,
  0x7F, 0xC3, 0x81, 0x7F, 0xC3, 0x81, 0x9F, 0xD2, 0x0B, 0xC1,
  // "Ļ" (U+013B)
  0x07, 0x0E, 0xA0, 0xE0, 0x75, 0x03, 0xA0, 0x36, 0x02, 0xA0, 0x36, 0x02, 0xA0, 0x36, 0x02, 0xA0,
  0x36, 0x02, 0xA0, 0x36, 0x02, 0xA0, 0x33, 0x01, 0x20, 0x2A, 0x03, 0x38, 0x2A, 0x40, 0x3A, 0x03,
  0x28, 0x31, 0xE3, 0x7E, 0xA0, 0xFC, 0x81, 0xEF, 0x34, 0x01, 0x02, 0x71, 0x0B, 0x0D, 0x71, 0x0E,
  0x03, 0x40,
  // "ļ" (U+013C)
  0xBF, 0xFC, 0x00, 0x9F, 0xC0, 0x07, 0xFC, 0x00, 0x7F, 0xC0, 0x07, 0xFC, 0x00, 0x7F, 0xC0, 0x07,
  0xFC, 0x00, 0x7F, 0xC0, 0x07, 0xFC, 0x00, 0x9F, 0xD0, 0xBF, 0xFF, 0xF0, 0x12, 0x00, 0x0B, 0xD0,
  0x00, 0xE3, 0x00,
  // "Ľ" (U+013D)
  0x07, 0x0E, 0xA8, 0x3E, 0x70, 0xCD, 0x20, 0x3A, 0x83, 0x30, 0x1E, 0x32, 0x02, 0xA0, 0x32, 0x01,
  0x30, 0x2A, 0x03, 0x60, 0x2A, 0x03, 0x60, 0x2A, 0x03, 0x60, 0x2A, 0x03, 0x30, 0x12, 0x02, 0xA0,
  0x33, 0x82, 0xA4, 0x03, 0xA0, 0x32, 0x83, 0x1E, 0x37, 0xEA, 0x0F, 0xC8, 0x1E, 0xF3,
  // "ľ" (U+013E)
  0x0B, 0xA8, 0x97, 0xC0, 0xEB, 0x09, 0xFC, 0x3E, 0x10, 0x7F, 0xC0, 0x12, 0x81, 0x7F, 0xC4, 0x81,
  0x7F, 0xC4, 0x81, 0x7F, 0xC4, 0x81, 0x7F, 0xC4, 0x81, 0x7F, 0xC4, 0x81, 0x7F, 0xC4, 0x81, 0x9F,
  0xD3, 0x0B, 0xC2,
  // "Ŀ" (U+013F)
  0x07, 0x0E, 0xA0, 0xE0, 0x75, 0x03, 0xA0, 0x36, 0x02, 0xA0, 0x36, 0x02, 0xA0, 0x36, 0x02, 0xA8,
  0x63, 0x03, 0xED, 0x10, 0x2A, 0x83, 0x30, 0x3D, 0xC2, 0x02, 0xA0, 0x33, 0x01, 0x20, 0x2A, 0x03,
  0x38, 0x2A, 0x40, 0x3A, 0x03, 0x28, 0x31, 0xE3, 0x7E, 0xA0, 0xFC, 0x81, 0xEF, 0x30,
  // "ŀ" (U+0140)
  0x0B, 0xA0, 0xC5, 0x81, 0x9F, 0xC5, 0x81, 0x7F, 0xC5, 0x81, 0x7F, 0xC5, 0x81, 0x7F, 0xC5, 0x81,
  0x7F, 0xC5, 0x89, 0x47, 0xFC, 0x3E, 0xD1, 0x07, 0xFC, 0x3D, 0xC2, 0x81, 0x7F, 0xC5, 0x81, 0x9F,
  0xD4, 0x0B, 0xC3,
  // "Ł" (U+0141)
  0x07, 0x0E, 0xA0, 0xE0, 0x75, 0x03, 0xA0, 0x36, 0x02, 0xA0, 0x36, 0x02, 0xA8, 0x16, 0xB4, 0x40,
  0x2A, 0x0B, 0x03, 0x40, 0x10, 0xAA, 0x03, 0x50, 0x40, 0x7A, 0x03, 0x30, 0x12, 0x02, 0xA0, 0x33,
  0x82, 0xA4, 0x03, 0xA0, 0x32, 0x83, 0x1E, 0x37, 0xEA, 0x0F, 0xC8, 0x1E, 0xF3,
  // "ł" (U+0142)
  0xBF, 0xFC, 0x00, 0x9F, 0xC0, 0x07, 0xFC, 0x00, 0x7F, 0xC0, 0x07, 0xFC, 0x50, 0x7F, 0xF8, 0x3D,
  0xFC, 0x05, 0x9F, 0xC0, 0x07, 0xFC, 0x00, 0x9F, 0xD0, 0xBF, 0xFF, 0xF0,
  // "Ń" (U+0143)
  0x78, 0x17, 0x72, 0x71, 0x81, 0x8F, 0x97, 0x18, 0x13, 0xE6, 0x77, 0x20, 0x8A, 0x0E, 0x02, 0x20,
  0x4B, 0x81, 0x80, 0x3A, 0x0D, 0x49, 0x03, 0x28, 0x32, 0xFE, 0xFA, 0x30, 0xE0, 0x22, 0x81, 0x2E,
  0x4A, 0x06, 0x20, 0xE0, 0x22, 0x82, 0x2E, 0x07, 0xA8, 0x23, 0x0E, 0x22, 0x02, 0x0E, 0x28, 0x4B,
  0xFD, 0x1E, 0x22, 0x02, 0x0E, 0x28, 0x41, 0xDF, 0xAE, 0x22, 0x02, 0x0E, 0x30, 0x3B, 0x02, 0x20,
  0x49, 0x40, 0x5A, 0x81, 0x20, 0x8B, 0x04, 0x38, 0x19, 0xF2, 0x10,
  // "ń" (U+0144)
  0x58, 0x17, 0x72, 0x68, 0x18, 0xF9, 0x68, 0x13, 0xE6, 0x77, 0x09, 0xA8, 0x3A, 0x9E, 0xE9, 0x30,
  0x9A, 0x83, 0x31, 0xEF, 0x52, 0x81, 0x7F, 0xD2, 0x81, 0xBF, 0x82, 0x81, 0x7F, 0xC2, 0x81, 0xBF,
  0x82, 0x81, 0x7F, 0xC2, 0x81, 0xBF, 0x82, 0x81, 0x7F, 0xC2, 0x81, 0xBF, 0x82, 0x81, 0x9F, 0xD2,
  0x83, 0xBF, 0xA0, 0xAB, 0x81, 0xD0, 0xBA, 0x09,
  // "Ņ" (U+0145)
  0x08, 0xA0, 0xE0, 0x22, 0x04, 0xB8, 0x18, 0x03, 0xA0, 0xD4, 0x90, 0x32, 0x83, 0x2F, 0xEF, 0xA3,
  0x0E, 0x02, 0x28, 0x12, 0xE4, 0xA0, 0x62, 0x0E, 0x02, 0x28, 0x22, 0xE0, 0x7A, 0x82, 0x30, 0xE2,
  0x20, 0x20, 0xE2, 0x84, 0xBF, 0xD1, 0xE2, 0x20, 0x20, 0xE2, 0x84, 0x1D, 0xFA, 0xE2, 0x20, 0x20,
  0xE3, 0x03, 0xB0, 0x22, 0x04, 0x94, 0x05, 0xA8, 0x12, 0x08, 0xB0, 0x43, 0x81, 0x9F, 0x26, 0x01,
  0x02, 0x73, 0x0B, 0x0D, 0x73, 0x0E, 0x03, 0x50,
  // "ņ" (U+0146)
  0x9F, 0xFA, 0x9E, 0xE9, 0x00, 0x09, 0xFF, 0x31, 0xEF, 0x50, 0x07, 0xFD, 0x00, 0xBF, 0x80, 0x07,
  0xFC, 0x00, 0xBF, 0x80, 0x07, 0xFC, 0x00, 0xBF, 0x80, 0x07, 0xFC, 0x00, 0xBF, 0x80, 0x09, 0xFD,
  0x00, 0xBF, 0xA0, 0xAF, 0xFF, 0xD0, 0xBF, 0xF9, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x00, 0xBD,
  0x00, 0x00, 0x00, 0x00, 0xE3, 0x00, 0x00,
  // "Ň" (U+0147)
  0x30, 0x20, 0x62, 0x03, 0x06, 0x78, 0x3B, 0xB5, 0xE4, 0x78, 0x21, 0xEF, 0x97, 0x72, 0x08, 0xA0,
  0xE0, 0x22, 0x04, 0xB8, 0x18, 0x03, 0xA0, 0xD4, 0x90, 0x32, 0x83, 0x2F, 0xEF, 0xA3, 0x0E, 0x02,
  0x28, 0x12, 0xE4, 0xA0, 0x62, 0x0E, 0x02, 0x28, 0x22, 0xE0, 0x7A, 0x82, 0x30, 0xE2, 0x20, 0x20,
  0xE2, 0x84, 0xBF, 0xD1, 0xE2, 0x20, 0x20, 0xE2, 0x84, 0x1D, 0xFA, 0xE2, 0x20, 0x20, 0xE3, 0x03,
  0xB0, 0x22, 0x04, 0x94, 0x05, 0xA8, 0x12, 0x08, 0xB0, 0x43, 0x81, 0x9F, 0x21,
  // "ň" (U+0148)
  0x00, 0x26, 0x00, 0x36, 0x00, 0x00, 0x0B, 0xB5, 0xE4, 0x00, 0x00, 0x01, 0xEF, 0x90, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x9F, 0xFA, 0x9E, 0xE9, 0x00, 0x09, 0xFF, 0x31, 0xEF, 0x50, 0x07, 0xFD,
  0x00, 0xBF, 0x80, 0x07, 0xFC, 0x00, 0xBF, 0x80, 0x07, 0xFC, 0x00, 0xBF, 0x80, 0x07, 0xFC, 0x00,
  0xBF, 0x80, 0x09, 0xFD, 0x00, 0xBF, 0xA0, 0xAF, 0xFF, 0xD0, 0xBF, 0xF9,
  // "ŉ" (U+0149)
  0x18, 0x1D, 0xD1, 0x73, 0x81, 0xEF, 0x47, 0x38, 0x12, 0xFB, 0xA8, 0x3A, 0x9E, 0xE9, 0x28, 0x31,
  0xB7, 0x09, 0xA8, 0x63, 0x1E, 0xF5, 0x01, 0x22, 0x81, 0x7F, 0xD2, 0x81, 0xBF, 0x85, 0x81, 0x7F,
  0xC2, 0x81, 0xBF, 0x85, 0x81, 0x7F, 0xC2, 0x81, 0xBF, 0x85, 0x81, 0x7F, 0xC2, 0x81, 0xBF, 0x85,
  0x81, 0x9F, 0xD2, 0x81, 0xBF, 0xA4, 0x0A, 0xB8, 0x1D, 0x0B, 0xA0, 0x90,
  // "Ŋ" (U+014A)
  0x08, 0xA0, 0xE0, 0x22, 0x04, 0xB8, 0x18, 0x03, 0xA0, 0xD0, 0x13, 0x90, 0x32, 0x83, 0x2F, 0xEF,
  0xB3, 0x0E, 0x02, 0x28, 0x12, 0xE4, 0xA0, 0x82, 0x0E, 0x02, 0x28, 0x22, 0xE0, 0x6A, 0x82, 0x50,
  0xE2, 0x20, 0x20, 0xE2, 0x84, 0x9F, 0xE2, 0xE2, 0x20, 0x20, 0xE3, 0x83, 0xCF, 0xDF, 0x22, 0x02,
  0x0E, 0x30, 0x10, 0xDA, 0x02, 0x20, 0x49, 0x40, 0x3A, 0x81, 0x20, 0x8B, 0x04, 0x38, 0x15, 0xF2,
  0x73, 0x90, 0x17, 0x20, 0x60, 0xE7, 0x28, 0x1B, 0xD4, 0x20,
  // "ŋ" (U+014B)
  0x9F, 0xFA, 0x9E, 0xE9, 0x00, 0x9F, 0xF3, 0x1E, 0xF5, 0x07, 0xFD, 0x00, 0xBF, 0x80, 0x7F, 0xC0,
  0x0B, 0xF8, 0x07, 0xFC, 0x00, 0xBF, 0x80, 0x7F, 0xC0, 0x0B, 0xF8, 0x09, 0xFD, 0x00, 0xBF, 0x8A,
  0xFF, 0xFD, 0x0B, 0xF8, 0x00, 0x00, 0x00, 0xCF, 0x70, 0x00, 0x00, 0x2F, 0xF2, 0x00, 0x00, 0x4E,
  0xC4, 0x00,
  // "Ō" (U+014C)
  0x38, 0x35, 0xEE, 0xED, 0x77, 0x28, 0x51, 0x8D, 0xEE, 0xC6, 0x38, 0x21, 0xDF, 0x62, 0x81, 0x8F,
  0xB2, 0x81, 0x9F, 0xB4, 0x85, 0xEF, 0x60, 0xEF, 0x74, 0x82, 0xAF, 0xC1, 0xA0, 0x54, 0x82, 0x9F,
  0xE1, 0xA0, 0x54, 0x85, 0x9F, 0xE0, 0xEF, 0x74, 0x85, 0xAF, 0xC0, 0x9F, 0xB4, 0x86, 0xEF, 0x60,
  0x1D, 0xF6, 0x28, 0x18, 0xFA, 0x38, 0x51, 0x8D, 0xEE, 0xC6, 0x20,
  // "ō" (U+014D)
  0x28, 0x35, 0xEE, 0xED, 0x76, 0x84, 0x7C, 0xED, 0x91, 0x28, 0x7A, 0xF8, 0x06, 0xFC, 0x01, 0xA0,
  0x22, 0x82, 0xEF, 0x44, 0xA3, 0x82, 0xDF, 0x64, 0xA0, 0x12, 0x82, 0xDF, 0x61, 0xA0, 0x22, 0x89,
  0x1E, 0xF4, 0x0A, 0xF8, 0x06, 0xFC, 0x38, 0x47, 0xDE, 0xD9, 0x11,
  // "Ŏ" (U+014E)
  0x30, 0x20, 0x52, 0x05, 0x03, 0x58, 0x42, 0xD1, 0x1E, 0x26, 0x82, 0x5D, 0xD5, 0x77, 0x28, 0x51,
  0x8D, 0xEE, 0xC6, 0x38, 0x21, 0xDF, 0x62, 0x81, 0x8F, 0xB2, 0x81, 0x9F, 0xB4, 0x85, 0xEF, 0x60,
  0xEF, 0x74, 0x82, 0xAF, 0xC1, 0xA0, 0x54, 0x82, 0x9F, 0xE1, 0xA0, 0x54, 0x85, 0x9F, 0xE0, 0xEF,
  0x74, 0x85, 0xAF, 0xC0, 0x9F, 0xB4, 0x86, 0xEF, 0x60, 0x1D, 0xF6, 0x28, 0x18, 0xFA, 0x38, 0x51,
  0x8D, 0xEE, 0xC6, 0x20,
  // "ŏ" (U+014F)
  0x20, 0x20, 0x52, 0x05, 0x03, 0x38, 0x42, 0xD1, 0x1E, 0x24, 0x82, 0x5D, 0xD5, 0x76, 0x84, 0x7C,
  0xED, 0x91, 0x28, 0x7A, 0xF8, 0x06, 0xFC, 0x01, 0xA0, 0x22, 0x82, 0xEF, 0x44, 0xA3, 0x82, 0xDF,
  0x64, 0xA0, 0x12, 0x82, 0xDF, 0x61, 0xA0, 0x22, 0x89, 0x1E, 0xF4, 0x0A, 0xF8, 0x06, 0xFC, 0x38,
  0x47, 0xDE, 0xD9, 0x11,
  // "Ő" (U+0150)
  0x58, 0x32, 0x10, 0x21, 0x58, 0x48, 0xF5, 0xAE, 0x34, 0x84, 0x2E, 0x44, 0xD3, 0x77, 0x18, 0x51,
  0x8D, 0xEE, 0xC6, 0x38, 0x21, 0xDF, 0x62, 0x81, 0x8F, 0xB2, 0x81, 0x9F, 0xB4, 0x85, 0xEF, 0x60,
  0xEF, 0x74, 0x82, 0xAF, 0xC1, 0xA0, 0x54, 0x82, 0x9F, 0xE1, 0xA0, 0x54, 0x85, 0x9F, 0xE0, 0xEF,
  0x74, 0x85, 0xAF, 0xC0, 0x9F, 0xB4, 0x86, 0xEF, 0x60, 0x1D, 0xF6, 0x28, 0x18, 0xFA, 0x38, 0x51,
  0x8D, 0xEE, 0xC6, 0x20,
  // "ő" (U+0151)
  0x48, 0x32, 0x10, 0x21, 0x38, 0x48, 0xF5, 0xAE, 0x32, 0x84, 0x2E, 0x44, 0xD3, 0x75, 0x84, 0x7C,
  0xED, 0x91, 0x28, 0x7A, 0xF8, 0x06, 0xFC, 0x01, 0xA0, 0x22, 0x82, 0xEF, 0x44, 0xA3, 0x82, 0xDF,
  0x64, 0xA0, 0x12, 0x82, 0xDF, 0x61, 0xA0, 0x22, 0x89, 0x1E, 0xF4, 0x0A, 0xF8, 0x06, 0xFC, 0x38,
  0x47, 0xDE, 0xD9, 0x11,
  // "Œ" (U+0152)
  0x28, 0x21, 0x8D, 0xEF, 0x98, 0x91, 0x30, 0x1D, 0xF7, 0x11, 0xCF, 0xA2, 0x85, 0x2E, 0x40, 0x9F,
  0xC3, 0x81, 0xAF, 0xA3, 0x84, 0x62, 0x0E, 0xF7, 0x38, 0x1A, 0xFA, 0x50, 0x1A, 0x06, 0x30, 0xAA,
  0x0F, 0xE8, 0x13, 0x01, 0xA0, 0x53, 0x81, 0xAF, 0xA6, 0x81, 0xEF, 0x73, 0x81, 0xAF, 0xA6, 0x81,
  0x9F, 0xC3, 0x81, 0xAF, 0xA3, 0x89, 0x23, 0x90, 0x1D, 0xF7, 0x11, 0xCF, 0xA3, 0x09, 0x0B, 0x28,
  0x21, 0x8D, 0xEF, 0x90, 0xB0,
  // "œ" (U+0153)
  0x00, 0x7C, 0xED, 0x72, 0xBE, 0xEA, 0x20, 0x0A, 0xF8, 0x06, 0xFF, 0xD1, 0x3F, 0xD0, 0x1F, 0xF2,
  0x00, 0xEF, 0x80, 0x0E, 0xF4, 0x4F, 0xF0, 0x00, 0xDF, 0xEE, 0xEE, 0xE5, 0x4F, 0xF1, 0x00, 0xDF,
  0x80, 0x00, 0x00, 0x1F, 0xF2, 0x00, 0xEF, 0xA0, 0x00, 0x00, 0x0A, 0xF8, 0x05, 0xFF, 0xF4, 0x02,
  0xC0, 0x00, 0x7D, 0xED, 0x93, 0xAE, 0xEC, 0x50,
  // "Ŕ" (U+0154)
  0x58, 0x17, 0x72, 0x78, 0x18, 0xF9, 0x78, 0x13, 0xE6, 0x77, 0x20, 0x8B, 0x0F, 0xE0, 0xA0, 0x23,
  0x03, 0xA8, 0x42, 0x09, 0xFE, 0x12, 0x02, 0xA8, 0x12, 0x03, 0xA0, 0x42, 0x02, 0xA8, 0x12, 0x03,
  0xA0, 0x32, 0x02, 0xA8, 0x32, 0x09, 0xFA, 0x30, 0x2A, 0x0E, 0xA0, 0x94, 0x02, 0xA8, 0x32, 0x7F,
  0xE1, 0x30, 0x2A, 0x83, 0x20, 0xDF, 0xB3, 0x03, 0xA8, 0x13, 0x03, 0xA8, 0x17, 0x08, 0xC8, 0x48,
  0x05, 0xDF, 0xA0,
  // "ŕ" (U+0155)
  0x48, 0x17, 0x72, 0x48, 0x18, 0xF9, 0x48, 0x13, 0xE6, 0x74, 0x09, 0xA8, 0x59, 0xAE, 0xE5, 0x09,
  0xA8, 0x63, 0x6F, 0x50, 0x7F, 0xD5, 0x81, 0x7F, 0xC5, 0x81, 0x7F, 0xC5, 0x81, 0x7F, 0xC5, 0x81,
  0x9F, 0xD4, 0x0A, 0xC0, 0x42,
  // "Ŗ" (U+0156)
  0x08, 0xB0, 0xFE, 0x0A, 0x02, 0x30, 0x3A, 0x84, 0x20, 0x9F, 0xE1, 0x20, 0x2A, 0x81, 0x20, 0x3A,
  0x04, 0x20, 0x2A, 0x81, 0x20, 0x3A, 0x03, 0x20, 0x2A, 0x83, 0x20, 0x9F, 0xA3, 0x02, 0xA0, 0xEA,
  0x09, 0x40, 0x2A, 0x83, 0x27, 0xFE, 0x13, 0x02, 0xA8, 0x32, 0x0D, 0xFB, 0x30, 0x3A, 0x81, 0x30,
  0x3A, 0x81, 0x70, 0x8C, 0x84, 0x80, 0x5D, 0xFA, 0x40, 0x10, 0x27, 0x20, 0xB0, 0xD7, 0x20, 0xE0,
  0x35,
  // "ŗ" (U+0157)
  0x09, 0xA8, 0x59, 0xAE, 0xE5, 0x09, 0xA8, 0x63, 0x6F, 0x50, 0x7F, 0xD5, 0x81, 0x7F, 0xC5, 0x81,
  0x7F, 0xC5, 0x81, 0x7F, 0xC5, 0x81, 0x9F, 0xD4, 0x0A, 0xC0, 0x44, 0x01, 0x02, 0x60, 0xB0, 0xD6,
  0x0E, 0x03, 0x40,
  // "Ř" (U+0158)
  0x20, 0x20, 0x62, 0x03, 0x06, 0x68, 0x3B, 0xB5, 0xE4, 0x68, 0x21, 0xEF, 0x97, 0x71, 0x08, 0xB0,
  0xFE, 0x0A, 0x02, 0x30, 0x3A, 0x84, 0x20, 0x9F, 0xE1, 0x20, 0x2A, 0x81, 0x20, 0x3A, 0x04, 0x20,
  0x2A, 0x81, 0x20, 0x3A, 0x03, 0x20, 0x2A, 0x83, 0x20, 0x9F, 0xA3, 0x02, 0xA0, 0xEA, 0x09, 0x40,
  0x2A, 0x83, 0x27, 0xFE, 0x13, 0x02, 0xA8, 0x32, 0x0D, 0xFB, 0x30, 0x3A, 0x81, 0x30, 0x3A, 0x81,
  0x70, 0x8C, 0x84, 0x80, 0x5D, 0xFA,
  // "ř" (U+0159)
  0x10, 0x20, 0x62, 0x03, 0x06, 0x38, 0x3B, 0xB5, 0xE4, 0x38, 0x21, 0xEF, 0x97, 0x30, 0x9A, 0x85,
  0x9A, 0xEE, 0x50, 0x9A, 0x86, 0x36, 0xF5, 0x07, 0xFD, 0x58, 0x17, 0xFC, 0x58, 0x17, 0xFC, 0x58,
  0x17, 0xFC, 0x58, 0x19, 0xFD, 0x40, 0xAC, 0x04, 0x20,
  // "Ś" (U+015A)
  0x58, 0x17, 0x72, 0x48, 0x18, 0xF9, 0x48, 0x13, 0xE6, 0x74, 0x8A, 0x01, 0x9D, 0xEE, 0xA1, 0x0D,
  0xD1, 0x0B, 0xF8, 0x3F, 0xC2, 0x82, 0x39, 0x21, 0xA0, 0x90, 0x14, 0x07, 0xB0, 0xA0, 0x33, 0x81,
  0x29, 0xEA, 0x81, 0x60, 0x12, 0x85, 0x19, 0xFE, 0x5F, 0x33, 0x98, 0x96, 0xE6, 0xFB, 0x10, 0x5F,
  0x80, 0x7D, 0xFE, 0xC6, 0x10,
  // "ś" (U+015B)
  0x48, 0x17, 0x72, 0x38, 0x18, 0xF9, 0x38, 0x13, 0xE6, 0x73, 0x8A, 0x45, 0xCE, 0xEB, 0x13, 0xF8,
  0x05, 0xF5, 0x5F, 0xB1, 0x04, 0x01, 0xDA, 0x0B, 0x04, 0x30, 0x60, 0xDA, 0x81, 0x52, 0xA2, 0x89,
  0x66, 0xFA, 0x7F, 0x40, 0x3F, 0x71, 0xAE, 0xED, 0x81,
  // "Ŝ" (U+015C)
  0x38, 0x16, 0x73, 0x48, 0x26, 0xFD, 0xD3, 0x84, 0x2E, 0x40, 0xAA, 0x73, 0x8A, 0x01, 0x9D, 0xEE,
  0xA1, 0x0D, 0xD1, 0x0B, 0xF8, 0x3F, 0xC2, 0x82, 0x39, 0x21, 0xA0, 0x90, 0x14, 0x07, 0xB0, 0xA0,
  0x33, 0x81, 0x29, 0xEA, 0x81, 0x60, 0x12, 0x85, 0x19, 0xFE, 0x5F, 0x33, 0x98, 0x96, 0xE6, 0xFB,
  0x10, 0x5F, 0x80, 0x7D, 0xFE, 0xC6, 0x10,
  // "ŝ" (U+015D)
  0x00, 0x67, 0x30, 0x00, 0x6F, 0xDD, 0x00, 0x2E, 0x40, 0xAA, 0x00, 0x00, 0x00, 0x00, 0x05, 0xCE,
  0xEB, 0x13, 0xF8, 0x05, 0xF5, 0x5F, 0xB1, 0x04, 0x01, 0xDF, 0xFB, 0x40, 0x00, 0x6D, 0xFF, 0x52,
  0xA0, 0x06, 0xFA, 0x7F, 0x40, 0x3F, 0x71, 0xAE, 0xED, 0x80,
  // "Ş" (U+015E)
  0x01, 0x9D, 0xEE, 0xA1, 0x0D, 0xD1, 0x0B, 0xF8, 0x3F, 0xC0, 0x03, 0x92, 0x1F, 0xF9, 0x10, 0x00,
  0x07, 0xFF, 0xFA, 0x30, 0x00, 0x29, 0xEF, 0xF6, 0x01, 0x00, 0x19, 0xFE, 0x5F, 0x30, 0x00, 0xFE,
  0x6F, 0xB1, 0x05, 0xF8, 0x07, 0xDF, 0xEC, 0x60, 0x00, 0x04, 0xC2, 0x00, 0x00, 0x00, 0x7E, 0x10,
  0x00, 0x00, 0x7F, 0x10, 0x00, 0x3E, 0xD6, 0x00,
  // "ş" (U+015F)
  0x05, 0xCE, 0xEB, 0x13, 0xF8, 0x05, 0xF5, 0x5F, 0xB1, 0x04, 0x01, 0xDF, 0xFB, 0x40, 0x00, 0x6D,
  0xFF, 0x52, 0xA0, 0x06, 0xFA, 0x7F, 0x40, 0x3F, 0x71, 0xAE, 0xED, 0x80, 0x00, 0x4C, 0x20, 0x00,
  0x00, 0x7E, 0x10, 0x00, 0x07, 0xF1, 0x00, 0x3E, 0xD6, 0x00,
  // "Š" (U+0160)
  0x02, 0x60, 0x03, 0x60, 0x00, 0xBB, 0x5E, 0x40, 0x00, 0x1E, 0xF9, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x9D, 0xEE, 0xA1, 0x0D, 0xD1, 0x0B, 0xF8, 0x3F, 0xC0, 0x03, 0x92, 0x1F, 0xF9, 0x10, 0x00,
  0x07, 0xFF, 0xFA, 0x30, 0x00, 0x29, 0xEF, 0xF6, 0x01, 0x00, 0x19, 0xFE, 0x5F, 0x30, 0x00, 0xFE,
  0x6F, 0xB1, 0x05, 0xF8, 0x07, 0xDF, 0xEC, 0x60,
  // "š" (U+0161)
  0x26, 0x00, 0x36, 0x00, 0xBB, 0x5E, 0x40, 0x01, 0xEF, 0x90, 0x00, 0x00, 0x00, 0x00, 0x05, 0xCE,
  0xEB, 0x13, 0xF8, 0x05, 0xF5, 0x5F, 0xB1, 0x04, 0x01, 0xDF, 0xFB, 0x40, 0x00, 0x6D, 0xFF, 0x52,
  0xA0, 0x06, 0xFA, 0x7F, 0x40, 0x3F, 0x71, 0xAE, 0xED, 0x80,
  // "Ţ" (U+0162)
  0x82, 0xCF, 0xEE, 0xA8, 0x6E, 0xEF, 0x8C, 0x70, 0x4A, 0x86, 0x10, 0xA9, 0x92, 0x04, 0xA8, 0x21,
  0x04, 0x73, 0x04, 0xA0, 0x16, 0x04, 0xA0, 0x16, 0x04, 0xA0, 0x16, 0x04, 0xA0, 0x16, 0x04, 0xA0,
  0x16, 0x05, 0xA0, 0x25, 0x09, 0xC0, 0x66, 0x0B, 0x07, 0x71, 0x81, 0x1D, 0x87, 0x10, 0xD0, 0x96,
  0x82, 0x9E, 0xB2, 0x30,
  // "ţ" (U+0163)
  0x20, 0x0B, 0x38, 0x16, 0xFB, 0x20, 0x9B, 0x84, 0xE9, 0x08, 0xFB, 0x38, 0x18, 0xFB, 0x38, 0x18,
  0xFB, 0x38, 0x18, 0xFB, 0x38, 0x18, 0xFB, 0x38, 0x16, 0xFD, 0x48, 0x2B, 0xFE, 0x93, 0x0B, 0x07,
  0x48, 0x11, 0xD8, 0x40, 0xD0, 0x92, 0x82, 0x9E, 0xB2,
  // "Ť" (U+0164)
  0x20, 0x20, 0x62, 0x03, 0x06, 0x58, 0x3B, 0xB5, 0xE4, 0x58, 0x21, 0xEF, 0x97, 0x68, 0x2C, 0xFE,
  0xEA, 0x86, 0xEE, 0xF8, 0xC7, 0x04, 0xA8, 0x61, 0x0A, 0x99, 0x20, 0x4A, 0x82, 0x10, 0x47, 0x30,
  0x4A, 0x01, 0x60, 0x4A, 0x01, 0x60, 0x4A, 0x01, 0x60, 0x4A, 0x01, 0x60, 0x4A, 0x01, 0x60, 0x5A,
  0x02, 0x50, 0x9C, 0x06, 0x20,
  // "ť" (U+0165)
  0x50, 0xE0, 0xB2, 0x89, 0x36, 0x73, 0xE1, 0x05, 0xFB, 0x01, 0x09, 0xB0, 0xE0, 0x92, 0x81, 0x8F,
  0xB4, 0x81, 0x8F, 0xB4, 0x81, 0x8F, 0xB4, 0x81, 0x8F, 0xB4, 0x81, 0x8F, 0xB4, 0x81, 0x6F, 0xD5,
  0x82, 0xBF, 0xE9, 0x10,
  // "Ŧ" (U+0166)
  0x82, 0xCF, 0xEE, 0xA8, 0x6E, 0xEF, 0x8C, 0x60, 0x4A, 0x86, 0x10, 0x99, 0x51, 0x04, 0xA8, 0x21,
  0x02, 0x43, 0x04, 0xA0, 0x14, 0x81, 0x6E, 0xEA, 0x81, 0xEE, 0x34, 0x04, 0xA0, 0x16, 0x04, 0xA0,
  0x16, 0x04, 0xA0, 0x16, 0x05, 0xA0, 0x25, 0x09, 0xC0, 0x62,
  // "ŧ" (U+0167)
  0x00, 0xBB, 0x00, 0x06, 0xFB, 0x00, 0x9F, 0xFF, 0xE9, 0x08, 0xFB, 0x00, 0x08, 0xFB, 0x00, 0x8F,
  0xFF, 0xE5, 0x08, 0xFB, 0x00, 0x08, 0xFB, 0x00, 0x07, 0xFD, 0x00, 0x01, 0xBF, 0xE9,
  // "Ũ" (U+0168)
  0x38, 0x49, 0xEA, 0x29, 0x64, 0x84, 0x3B, 0x08, 0xDA, 0x77, 0x0B, 0xC8, 0x16, 0x0E, 0xA8, 0x1E,
  0x06, 0xA0, 0x13, 0x00, 0x92, 0x05, 0xA4, 0x00, 0x82, 0x05, 0xA4, 0x00, 0x82, 0x05, 0xA4, 0x00,
  0x82, 0x05, 0xA4, 0x00, 0x82, 0x05, 0xA4, 0x00, 0x82, 0x04, 0xA0, 0x13, 0x09, 0x07, 0x38, 0x1D,
  0xF8, 0x28, 0x13, 0xE2, 0x38, 0x52, 0x9D, 0xEE, 0xC4, 0x20,
  // "ũ" (U+0169)
  0x00, 0x9E, 0xA2, 0x96, 0x00, 0x03, 0xB0, 0x8D, 0xA0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9F,
  0xFB, 0x0D, 0xFF, 0x70, 0x0A, 0xFB, 0x00, 0xDF, 0x70, 0x08, 0xFB, 0x00, 0xCF, 0x70, 0x08, 0xFB,
  0x00, 0xCF, 0x70, 0x08, 0xFB, 0x00, 0xCF, 0x70, 0x08, 0xFB, 0x00, 0xDF, 0x70, 0x05, 0xFE, 0x13,
  0xFF, 0x90, 0x00, 0x9E, 0xEA, 0x9F, 0xF9,
  // "Ū" (U+016A)
  0x38, 0x35, 0xEE, 0xED, 0x77, 0x0B, 0xC8, 0x16, 0x0E, 0xA8, 0x1E, 0x06, 0xA0, 0x13, 0x00, 0x92,
  0x05, 0xA4, 0x00, 0x82, 0x05, 0xA4, 0x00, 0x82, 0x05, 0xA4, 0x00, 0x82, 0x05, 0xA4, 0x00, 0x82,
  0x05, 0xA4, 0x00, 0x82, 0x04, 0xA0, 0x13, 0x09, 0x07, 0x38, 0x1D, 0xF8, 0x28, 0x13, 0xE2, 0x38,
  0x52, 0x9D, 0xEE, 0xC4, 0x20,
  // "ū" (U+016B)
  0x00, 0x5E, 0xEE, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9F, 0xFB, 0x0D, 0xFF, 0x70, 0x0A,
  0xFB, 0x00, 0xDF, 0x70, 0x08, 0xFB, 0x00, 0xCF, 0x70, 0x08, 0xFB, 0x00, 0xCF, 0x70, 0x08, 0xFB,
  0x00, 0xCF, 0x70, 0x08, 0xFB, 0x00, 0xDF, 0x70, 0x05, 0xFE, 0x13, 0xFF, 0x90, 0x00, 0x9E, 0xEA,
  0x9F, 0xF9,
  // "Ŭ" (U+016C)
  0x30, 0x20, 0x52, 0x05, 0x03, 0x58, 0x42, 0xD1, 0x1E, 0x26, 0x82, 0x5D, 0xD5, 0x77, 0x0B, 0xC8,
  0x16, 0x0E, 0xA8, 0x1E, 0x06, 0xA0, 0x13, 0x00, 0x92, 0x05, 0xA4, 0x00, 0x82, 0x05, 0xA4, 0x00,
  0x82, 0x05, 0xA4, 0x00, 0x82, 0x05, 0xA4, 0x00, 0x82, 0x05, 0xA4, 0x00, 0x82, 0x04, 0xA0, 0x13,
  0x09, 0x07, 0x38, 0x1D, 0xF8, 0x28, 0x13, 0xE2, 0x38, 0x52, 0x9D, 0xEE, 0xC4, 0x20,
  // "ŭ" (U+016D)
  0x00, 0x25, 0x00, 0x53, 0x00, 0x00, 0x2D, 0x11, 0xE2, 0x00, 0x00, 0x05, 0xDD, 0x50, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x9F, 0xFB, 0x0D, 0xFF, 0x70, 0x0A, 0xFB, 0x00, 0xDF, 0x70, 0x08, 0xFB,
  0x00, 0xCF, 0x70, 0x08, 0xFB, 0x00, 0xCF, 0x70, 0x08, 0xFB, 0x00, 0xCF, 0x70, 0x08, 0xFB, 0x00,
  0xDF, 0x70, 0x05, 0xFE, 0x13, 0xFF, 0x90, 0x00, 0x9E, 0xEA, 0x9F, 0xF9,
  // "Ů" (U+016E)
  0x48, 0x1B, 0xEA, 0x78, 0x34, 0xC0, 0xB3, 0x78, 0x1A, 0xEA, 0x77, 0x10, 0xBC, 0x81, 0x60, 0xEA,
  0x81, 0xE0, 0x6A, 0x01, 0x30, 0x09, 0x20, 0x5A, 0x40, 0x08, 0x20, 0x5A, 0x40, 0x08, 0x20, 0x5A,
  0x40, 0x08, 0x20, 0x5A, 0x40, 0x08, 0x20, 0x5A, 0x40, 0x08, 0x20, 0x4A, 0x01, 0x30, 0x90, 0x73,
  0x81, 0xDF, 0x82, 0x81, 0x3E, 0x23, 0x85, 0x29, 0xDE, 0xEC, 0x42,
  // "ů" (U+016F)
  0x38, 0x1B, 0xEA, 0x68, 0x34, 0xC0, 0xB3, 0x68, 0x1A, 0xEA, 0x77, 0x09, 0xA8, 0x1B, 0x0D, 0xA0,
  0x72, 0x81, 0xAF, 0xB2, 0x81, 0xDF, 0x72, 0x81, 0x8F, 0xB2, 0x81, 0xCF, 0x72, 0x81, 0x8F, 0xB2,
  0x81, 0xCF, 0x72, 0x81, 0x8F, 0xB2, 0x81, 0xCF, 0x72, 0x81, 0x8F, 0xB2, 0x81, 0xDF, 0x72, 0x83,
  0x5F, 0xE1, 0x3A, 0x09, 0x38, 0x39, 0xEE, 0xA9, 0xA0, 0x90,
  // "Ű" (U+0170)
  0x58, 0x32, 0x10, 0x21, 0x58, 0x48, 0xF5, 0xAE, 0x34, 0x84, 0x2E, 0x44, 0xD3, 0x76, 0x0B, 0xC8,
  0x16, 0x0E, 0xA8, 0x1E, 0x06, 0xA0, 0x13, 0x00, 0x92, 0x05, 0xA4, 0x00, 0x82, 0x05, 0xA4, 0x00,
  0x82, 0x05, 0xA4, 0x00, 0x82, 0x05, 0xA4, 0x00, 0x82, 0x05, 0xA4, 0x00, 0x82, 0x04, 0xA0, 0x13,
  0x09, 0x07, 0x38, 0x1D, 0xF8, 0x28, 0x13, 0xE2, 0x38, 0x52, 0x9D, 0xEE, 0xC4, 0x20,
  // "ű" (U+0171)
  0x00, 0x00, 0x21, 0x02, 0x10, 0x00, 0x08, 0xF5, 0xAE, 0x30, 0x00, 0x2E, 0x44, 0xD3, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x9F, 0xFB, 0x0D, 0xFF, 0x70, 0x0A, 0xFB, 0x00, 0xDF, 0x70, 0x08, 0xFB,
  0x00, 0xCF, 0x70, 0x08, 0xFB, 0x00, 0xCF, 0x70, 0x08, 0xFB, 0x00, 0xCF, 0x70, 0x08, 0xFB, 0x00,
  0xDF, 0x70, 0x05, 0xFE, 0x13, 0xFF, 0x90, 0x00, 0x9E, 0xEA, 0x9F, 0xF9,
  // "Ų" (U+0172)
  0x0B, 0xC8, 0x16, 0x0E, 0xA8, 0x1E, 0x06, 0xA0, 0x13, 0x00, 0x92, 0x05, 0xA4, 0x00, 0x82, 0x05,
  0xA4, 0x00, 0x82, 0x05, 0xA4, 0x00, 0x82, 0x05, 0xA4, 0x00, 0x82, 0x05, 0xA4, 0x00, 0x82, 0x04,
  0xA0, 0x13, 0x09, 0x07, 0x38, 0x1D, 0xF8, 0x28, 0x13, 0xE2, 0x38, 0x12, 0x9D, 0xA0, 0xC0, 0x46,
  0x81, 0x4E, 0x17, 0x10, 0xA0, 0xD7, 0x28, 0x25, 0xEF, 0xA7, 0x20, 0x14,
  // "ų" (U+0173)
  0x09, 0xA8, 0x1B, 0x0D, 0xA0, 0x72, 0x81, 0xAF, 0xB2, 0x81, 0xDF, 0x72, 0x81, 0x8F, 0xB2, 0x81,
  0xCF, 0x72, 0x81, 0x8F, 0xB2, 0x81, 0xCF, 0x72, 0x81, 0x8F, 0xB2, 0x81, 0xCF, 0x72, 0x81, 0x8F,
  0xB2, 0x81, 0xDF, 0x72, 0x83, 0x5F, 0xE1, 0x3A, 0x09, 0x38, 0x39, 0xEE, 0xAB, 0xA0, 0x95, 0x81,
  0x4E, 0x27, 0x0A, 0x0D, 0x71, 0x82, 0x5E, 0xFB, 0x71, 0x01, 0x20,
  // "Ŵ" (U+0174)
  0x78, 0x16, 0x73, 0x75, 0x82, 0x6F, 0xDD, 0x74, 0x84, 0x2E, 0x40, 0xAA, 0x77, 0x7C, 0x0E, 0x28,
  0x13, 0xF3, 0x20, 0xDB, 0x18, 0x1C, 0xFD, 0x38, 0x18, 0xF9, 0x30, 0xA0, 0xC2, 0x81, 0x7F, 0xE3,
  0x81, 0xDF, 0xE3, 0x0C, 0x06, 0x20, 0x2A, 0x89, 0x14, 0x02, 0xFE, 0xF5, 0x01, 0xF2, 0x38, 0x92,
  0xCF, 0x90, 0x7B, 0x9F, 0xB0, 0x5D, 0x48, 0x57, 0xFE, 0x0C, 0x53, 0xA8, 0x12, 0x98, 0x40, 0x2A,
  0x87, 0x5F, 0x10, 0xCF, 0x7D, 0x45, 0x82, 0xCF, 0xDA, 0x28, 0x26, 0xFD, 0xE6, 0x07, 0xA0, 0x52,
  0x01, 0xA0, 0xA6, 0x02, 0xA4, 0x81, 0xAF, 0x63,
  // "ŵ" (U+0175)
  0x68, 0x16, 0x73, 0x72, 0x82, 0x6F, 0xDD, 0x71, 0x84, 0x2E, 0x40, 0xAA, 0x77, 0x2C, 0x84, 0x40,
  0xB8, 0x08, 0xA8, 0x7C, 0x1E, 0xF4, 0x01, 0xFD, 0x20, 0x90, 0xC2, 0x83, 0xAF, 0x70, 0x7A, 0x82,
  0x30, 0xA6, 0x28, 0x91, 0x6F, 0xB0, 0xCB, 0xF8, 0x0E, 0x12, 0x01, 0xA8, 0x53, 0xD3, 0xFD, 0x4B,
  0x48, 0x7C, 0xFA, 0x70, 0xDF, 0xA6, 0x40, 0x7A, 0x81, 0x20, 0x8A, 0x01, 0x48, 0x12, 0xFC, 0x28,
  0x12, 0xFB, 0x30,
  // "Ŷ" (U+0176)
  0x48, 0x16, 0x73, 0x78, 0x26, 0xFD, 0xD6, 0x84, 0x2E, 0x40, 0xAA, 0x77, 0xD1, 0x07, 0xB8, 0x35,
  0x0C, 0xFE, 0x38, 0x14, 0xF4, 0x20, 0x3A, 0x03, 0x20, 0x80, 0xA4, 0x85, 0xAF, 0xB0, 0x1E, 0x14,
  0x01, 0xA8, 0x14, 0x88, 0x68, 0x27, 0xFC, 0xD7, 0x1A, 0x07, 0x71, 0xA0, 0x67, 0x1A, 0x07, 0x60,
  0x7C, 0x0E, 0x30,
  // "ŷ" (U+0177)
  0x38, 0x16, 0x73, 0x58, 0x26, 0xFD, 0xD4, 0x84, 0x2E, 0x40, 0xAA, 0x74, 0xC0, 0x40, 0xAA, 0x83,
  0xA1, 0xEF, 0x62, 0x0A, 0x0B, 0x28, 0x18, 0xFA, 0x20, 0xD0, 0x32, 0x01, 0xA8, 0x11, 0x3D, 0x48,
  0x3A, 0xF7, 0x97, 0x48, 0x33, 0xFD, 0xE1, 0x58, 0x1C, 0xFA, 0x68, 0x16, 0xF4, 0x60, 0xA0, 0xD6,
  0x81, 0x7F, 0x54, 0x82, 0x8E, 0xC5, 0x50,
  // "Ÿ" (U+0178)
  0x38, 0x3B, 0x60, 0xA7, 0x68, 0x3D, 0x70, 0xD8, 0x77, 0xD1, 0x07, 0xB8, 0x35, 0x0C, 0xFE, 0x38,
  0x14, 0xF4, 0x20, 0x3A, 0x03, 0x20, 0x80, 0xA4, 0x85, 0xAF, 0xB0, 0x1E, 0x14, 0x01, 0xA8, 0x14,
  0x88, 0x68, 0x27, 0xFC, 0xD7, 0x1A, 0x07, 0x71, 0xA0, 0x67, 0x1A, 0x07, 0x60, 0x7C, 0x0E, 0x30,
  // "Ź" (U+0179)
  0x58, 0x17, 0x72, 0x68, 0x18, 0xF9, 0x68, 0x13, 0xE6, 0x77, 0x1A, 0x0F, 0xEB, 0x29, 0x04, 0x20,
  0x2A, 0x82, 0x70, 0x1D, 0x38, 0x1C, 0xFC, 0x60, 0x7A, 0x02, 0x50, 0x2A, 0x07, 0x68, 0x1C, 0xFC,
  0x68, 0x28, 0xFE, 0x25, 0x03, 0xA0, 0x63, 0x84, 0xB4, 0x0C, 0xFB, 0x38, 0x22, 0xF4, 0x5A, 0x80,
  0x0E, 0xA0, 0x40,
  // "ź" (U+017A)
  0x48, 0x17, 0x72, 0x48, 0x18, 0xF9, 0x48, 0x13, 0xE6, 0x74, 0x03, 0xE8, 0x14, 0x4D, 0x28, 0x91,
  0xAF, 0xB0, 0x24, 0x05, 0xFE, 0x13, 0x82, 0x1E, 0xF4, 0x48, 0x1B, 0xF9, 0x48, 0x16, 0xFD, 0x28,
  0x45, 0x52, 0xEF, 0x32, 0x81, 0xB6, 0xAE, 0x06,
  // "Ż" (U+017B)
  0x38, 0x23, 0xED, 0x16, 0x81, 0x3D, 0xC7, 0x71, 0xA0, 0xFE, 0xB2, 0x90, 0x42, 0x02, 0xA8, 0x27,
  0x01, 0xD3, 0x81, 0xCF, 0xC6, 0x07, 0xA0, 0x25, 0x02, 0xA0, 0x76, 0x81, 0xCF, 0xC6, 0x82, 0x8F,
  0xE2, 0x50, 0x3A, 0x06, 0x38, 0x4B, 0x40, 0xCF, 0xB3, 0x82, 0x2F, 0x45, 0xA8, 0x00, 0xEA, 0x04,
  // "ż" (U+017C)
  0x28, 0x23, 0xED, 0x14, 0x81, 0x3D, 0xC7, 0x40, 0x3E, 0x81, 0x44, 0xD2, 0x89, 0x1A, 0xFB, 0x02,
  0x40, 0x5F, 0xE1, 0x38, 0x21, 0xEF, 0x44, 0x81, 0xBF, 0x94, 0x81, 0x6F, 0xD2, 0x84, 0x55, 0x2E,
  0xF3, 0x28, 0x1B, 0x6A, 0xE0, 0x60,
  // "Ž" (U+017D)
  0x20, 0x20, 0x62, 0x03, 0x06, 0x58, 0x3B, 0xB5, 0xE4, 0x58, 0x21, 0xEF, 0x97, 0x7A, 0x0F, 0xEB,
  0x29, 0x04, 0x20, 0x2A, 0x82, 0x70, 0x1D, 0x38, 0x1C, 0xFC, 0x60, 0x7A, 0x02, 0x50, 0x2A, 0x07,
  0x68, 0x1C, 0xFC, 0x68, 0x28, 0xFE, 0x25, 0x03, 0xA0, 0x63, 0x84, 0xB4, 0x0C, 0xFB, 0x38, 0x22,
  0xF4, 0x5A, 0x80, 0x0E, 0xA0, 0x40,
  // "ž" (U+017E)
  0x10, 0x20, 0x62, 0x03, 0x06, 0x38, 0x3B, 0xB5, 0xE4, 0x38, 0x21, 0xEF, 0x97, 0x30, 0x3E, 0x81,
  0x44, 0xD2, 0x89, 0x1A, 0xFB, 0x02, 0x40, 0x5F, 0xE1, 0x38, 0x21, 0xEF, 0x44, 0x81, 0xBF, 0x94,
  0x81, 0x6F, 0xD2, 0x84, 0x55, 0x2E, 0xF3, 0x28, 0x1B, 0x6A, 0xE0, 0x60,
  // "ſ" (U+017F)
  0x28, 0xA0, 0x6D, 0xEE, 0x90, 0x3F, 0xE0, 0xED, 0x07, 0xFC, 0x01, 0x28, 0x17, 0xFC, 0x48, 0x17,
  0xFC, 0x48, 0x17, 0xFC, 0x48, 0x17, 0xFC, 0x48, 0x17, 0xFC, 0x48, 0x17, 0xFC, 0x48, 0x19, 0xFD,
  0x30, 0xDC, 0x07, 0x10,
  // "Ω" (U+03A9)
  0x28, 0x62, 0x9D, 0xEE, 0xD9, 0x23, 0x03, 0xA0, 0x62, 0x04, 0xA0, 0x42, 0x81, 0xCF, 0xB4, 0x81,
  0xAF, 0xD2, 0xA0, 0x94, 0x07, 0xA8, 0x31, 0x0E, 0xF9, 0x40, 0x7A, 0x28, 0x18, 0xFD, 0x48, 0x1C,
  0xF9, 0x38, 0x67, 0xEB, 0x32, 0xBF, 0x82, 0x04, 0x08, 0x28, 0x27, 0x76, 0x92, 0x89, 0x56, 0x54,
  0xF9, 0x8A, 0x86, 0xB8, 0x9E, 0x63, 0xC0, 0x80, 0x7C, 0x05,
  // "μ" (U+03BC)
  0x81, 0x9F, 0xA2, 0x85, 0xCF, 0x70, 0x9F, 0xA2, 0x85, 0xCF, 0x70, 0x9F, 0xA2, 0x85, 0xCF, 0x70,
  0x9F, 0xA2, 0x85, 0xCF, 0x70, 0x9F, 0xA2, 0x85, 0xCF, 0x70, 0x9F, 0xB2, 0x8A, 0x6E, 0xF7, 0x0A,
  0xFE, 0x37, 0xEF, 0x90, 0xBA, 0xDE, 0x83, 0xDF, 0x8B, 0x87, 0x81, 0xBE, 0x36, 0x81, 0x5E, 0xA6,
  // "π" (U+03C0)
  0x08, 0xEF, 0xFF, 0xFF, 0xF9, 0x3F, 0xDF, 0xDD, 0xEE, 0xD8, 0x57, 0x1F, 0x00, 0x89, 0x00, 0x00,
  0x3E, 0x00, 0xB7, 0x00, 0x00, 0x5D, 0x00, 0xD7, 0x00, 0x00, 0x8D, 0x00, 0xE7, 0x00, 0x03, 0xEA,
  0x00, 0xE9, 0x00, 0x3F, 0xD3, 0x00, 0x7E, 0xC0,
  // "–" (U+2013)
  0x01, 0x80, 0x3E, 0x08,
  // "—" (U+2014)
  0x01, 0x80, 0x93, 0xE0, 0x10,
  // "€" (U+20AC)
  0x28, 0xA0, 0x3A, 0xEE, 0xD7, 0x02, 0xFD, 0x11, 0xEE, 0x09, 0xF8, 0x28, 0x13, 0x18, 0xA0, 0xFE,
  0x02, 0x28, 0x1C, 0xF6, 0x40, 0x8A, 0x81, 0xEE, 0x83, 0x81, 0x9F, 0x85, 0x81, 0x4F, 0xC6, 0x84,
  0xBF, 0x60, 0x1B, 0x38, 0x38, 0xDE, 0xD5,
  // "₿" (U+20BF)
  0x00, 0x1B, 0x76, 0x00, 0x7F, 0xFE, 0xFD, 0x60, 0x0A, 0xF7, 0x0D, 0xF5, 0x09, 0xF7, 0x0A, 0xF7,
  0x09, 0xF7, 0x1D, 0xE3, 0x09, 0xFE, 0xFF, 0x50, 0x09, 0xF7, 0x0A, 0xF6, 0x09, 0xF7, 0x05, 0xFC,
  0x09, 0xF7, 0x05, 0xFD, 0x0A, 0xF7, 0x09, 0xF8, 0x7F, 0xFE, 0xED, 0x80, 0x00, 0x1B, 0x76, 0x00,
  0x00, 0x01, 0x10, 0x00,
  // "‘" (U+2018)
  0x00, 0x12, 0x04, 0xB3, 0x0E, 0x50, 0x1F, 0xF2, 0x0B, 0xD2,
  // "’" (U+2019)
  0x0D, 0xD1, 0x0E, 0xF4, 0x02, 0xF2, 0x1B, 0x70, 0x12, 0x00,
  // "‚" (U+201A)
  0x0D, 0xD1, 0x0E, 0xF4, 0x02, 0xF2, 0x1A, 0x70, 0x22, 0x00,
  // "‛" (U+201B)
  0x0B, 0xE2, 0x1F, 0xF2, 0x0E, 0x50, 0x04, 0xC3, 0x00, 0x12,
  // "“" (U+201C)
  0x00, 0x12, 0x00, 0x30, 0x4B, 0x33, 0xC4, 0x0E, 0x50, 0xC7, 0x01, 0xFF, 0x2F, 0xF4, 0x0B, 0xD2,
  0x9E, 0x30,
  // "”" (U+201D)
  0x0D, 0xD1, 0xBD, 0x20, 0xEF, 0x4C, 0xF7, 0x02, 0xF2, 0x1E, 0x41, 0xB7, 0x19, 0x90, 0x12, 0x01,
  0x30, 0x00,
  // "„" (U+201E)
  0x0D, 0xD1, 0xBD, 0x20, 0xEF, 0x4C, 0xF7, 0x02, 0xF2, 0x1E, 0x41, 0xA7, 0x09, 0x90, 0x22, 0x01,
  0x30, 0x00,
  // "‟" (U+201F)
  0x0B, 0xE2, 0x9E, 0x31, 0xFF, 0x2F, 0xF4, 0x0E, 0x50, 0xC7, 0x00, 0x4C, 0x33, 0xC4, 0x00, 0x12,
  0x00, 0x30,
  // "†" (U+2020)
  0x28, 0x14, 0xF7, 0x48, 0x11, 0xF4, 0x50, 0xE0, 0x12, 0x89, 0x47, 0xEC, 0xEC, 0xE9, 0x36, 0x4E,
  0x55, 0x42, 0x81, 0x5F, 0x84, 0x81, 0x5F, 0x84, 0x81, 0x2F, 0x55, 0x90, 0x35, 0x0E, 0x01, 0x50,
  0xD6, 0x0D, 0x60, 0x63,
  // "‡" (U+2021)
  0x28, 0x13, 0xF6, 0x59, 0x02, 0x28, 0x94, 0x6C, 0xAE, 0xAC, 0x84, 0x86, 0xE7, 0x76, 0x28, 0x14,
  0xF7, 0x50, 0xE0, 0x25, 0x0A, 0x58, 0x13, 0xF5, 0x48, 0x13, 0xF5, 0x28, 0x94, 0x7D, 0xBE, 0xBD,
  0x94, 0x75, 0xE6, 0x75, 0x28, 0x11, 0xF4, 0x48, 0x12, 0x73, 0x20,
  // "•" (U+2022)
  0x18, 0x26, 0xDD, 0x62, 0xC1, 0x02, 0xC0, 0x21, 0xC2, 0x82, 0x6E, 0xD6, 0x10,
  // "…" (U+2026)
  0x01, 0x00, 0x01, 0x00, 0x00, 0x10, 0xCF, 0x50, 0x4F, 0xE0, 0x0A, 0xF7, 0xAE, 0x40, 0x3E, 0xB0,
  0x08, 0xE5,
  // "‰" (U+2030)
  0x18, 0x36, 0xDE, 0xA1, 0x20, 0x70, 0xA7, 0x38, 0x90, 0x3F, 0x71, 0xF9, 0x01, 0xE2, 0x73, 0x87,
  0x6F, 0x30, 0xCD, 0x08, 0x97, 0x48, 0x76, 0xF3, 0x0C, 0xC1, 0xE2, 0x74, 0x8A, 0x12, 0xF7, 0x1F,
  0x88, 0x94, 0xCE, 0xB2, 0x03, 0xCE, 0xB2, 0x28, 0xA0, 0x5D, 0xD9, 0x2E, 0x2E, 0xA0, 0xDB, 0x0E,
  0xB0, 0xCC, 0x68, 0x95, 0x98, 0x3F, 0x60, 0xAF, 0x3F, 0x70, 0x9F, 0x14, 0x89, 0x62, 0xE1, 0x3F,
  0x60, 0xAF, 0x3F, 0x70, 0x9F, 0x14, 0x09, 0x08, 0x28, 0x91, 0xE9, 0x0D, 0xB0, 0xEA, 0x0C, 0xC4,
  0x81, 0x2E, 0x12, 0x89, 0x14, 0xDE, 0xB2, 0x04, 0xCE, 0xC2, 0x10,
  // "‹" (U+2039)
  0x03, 0xE1, 0x1E, 0x80, 0xCF, 0x10, 0xDE, 0x10, 0x2E, 0x80, 0x03, 0xE1,
  // "›" (U+203A)
  0xC7, 0x00, 0x4F, 0x40, 0x0C, 0xE2, 0x0B, 0xF2, 0x4F, 0x50, 0xC7, 0x00,
  // "⁄" (U+2044)
  0x50, 0xB0, 0x74, 0x03, 0x0D, 0x50, 0xC0, 0x54, 0x04, 0x0C, 0x50, 0xC0, 0x44, 0x06, 0x0C, 0x50,
  0xD0, 0x34, 0x07, 0x0B, 0x48, 0x11, 0xE2, 0x40, 0x80, 0x95,
  // "™" (U+2122)
  0x68, 0xA7, 0x97, 0xB0, 0x00, 0xA7, 0x40, 0xD1, 0x42, 0xD5, 0x04, 0xE2, 0x00, 0xD1, 0x02, 0x8A,
  0x07, 0xB2, 0x00, 0xD1, 0x02, 0x5C, 0x26, 0xB2, 0x00, 0xD1, 0x02, 0x56, 0xC1, 0xB2, 0x04, 0xA7,
  0x07, 0x81, 0x72, 0xA7,
  // "⅒" (U+2152)
  0x20, 0x70, 0x97, 0x78, 0x21, 0xBD, 0xD7, 0x71, 0x81, 0x29, 0xD4, 0x0B, 0x07, 0x73, 0x09, 0x0D,
  0x30, 0x30, 0xD7, 0x40, 0x90, 0xD3, 0x0C, 0x05, 0x74, 0x09, 0x0D, 0x28, 0x34, 0xC0, 0x79, 0x28,
  0x25, 0xCB, 0x42, 0x89, 0x7A, 0xCC, 0xA1, 0xC6, 0xBD, 0xD0, 0x2F, 0x55, 0xF1, 0x58, 0x93, 0x6C,
  0x02, 0x9D, 0x05, 0xF1, 0x2F, 0x55, 0x0D, 0x03, 0x28, 0x79, 0xD0, 0x6F, 0x11, 0xF6, 0x40, 0x70,
  0xB3, 0x87, 0x9D, 0x05, 0xF1, 0x2F, 0x53, 0x81, 0x1E, 0x23, 0x87, 0x9D, 0x01, 0xF5, 0x5F, 0x13,
  0x08, 0x09, 0x38, 0x7A, 0xCC, 0xA1, 0x5C, 0xB4, 0x10,
  // "ﬁ" (U+FB01)
  0x28, 0x52, 0xAD, 0xEF, 0xD8, 0x48, 0x5D, 0xF4, 0x07, 0xFD, 0x30, 0x3A, 0x30, 0x33, 0x09, 0x0E,
  0xA0, 0xFE, 0xA0, 0x42, 0x81, 0x4F, 0xE3, 0xA0, 0x42, 0x81, 0x4F, 0xE3, 0xA0, 0x42, 0x81, 0x4F,
  0xE3, 0xA0, 0x42, 0x81, 0x4F, 0xE3, 0xA0, 0x42, 0x81, 0x4F, 0xE3, 0xA0, 0x42, 0x07, 0xA8, 0x11,
  0x02, 0xA8, 0x16, 0x0A, 0xC0, 0x9C, 0x07,
  // "ﬂ" (U+FB02)
  0x28, 0x22, 0xAD, 0xEB, 0x04, 0x38, 0x3D, 0xF4, 0x08, 0xA0, 0x42, 0x03, 0xA3, 0xA8, 0x24, 0x09,
  0xEA, 0x0E, 0x0B, 0x1A, 0x04, 0x28, 0x14, 0xFE, 0x3A, 0x04, 0x28, 0x14, 0xFE, 0x3A, 0x04, 0x28,
  0x14, 0xFE, 0x3A, 0x04, 0x28, 0x14, 0xFE, 0x3A, 0x04, 0x28, 0x14, 0xFE, 0x3A, 0x04, 0x20, 0x7A,
  0x81, 0x10, 0x2A, 0x81, 0x60, 0xAC, 0x05, 0xC0, 0x70,
};

const Font& font_NotoSerif_Bold_15() {
  static SmoothFont font(font_NotoSerif_Bold_15_data);
  return font;
}

}  // namespace roo_display
