#include "10.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSerif-Bold (Noto Serif Bold)
// Generated on Wed Nov 19 19:11:38 CET 2025
static const uint8_t font_NotoSerif_Bold_10_data[] PROGMEM = {
  
  // Header
  0x01, 0x02, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x05, 0x99,
  0xFE, 0xFE, 0x0C, 0x0B, 0x08, 0xFD, 0x03, 0x01, 0x0D, 0x04, 0x04, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x41, 0x01, 0x02, 0x08, 0x04, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x40, 0x06, 0x04, 0x08, 0x05, 0x00, 0x08, // """ (U+0022)
  0x00, 0x23, 0x40, 0x01, 0x05, 0x08, 0x06, 0x00, 0x10, // "#" (U+0023)
  0x00, 0x24, 0x40, 0x00, 0x04, 0x08, 0x06, 0x00, 0x28, // "$" (U+0024)
  0x00, 0x25, 0x40, 0x01, 0x08, 0x08, 0x09, 0x00, 0x3F, // "%" (U+0025)
  0x00, 0x26, 0x40, 0x01, 0x07, 0x08, 0x08, 0x00, 0x63, // "&" (U+0026)
  0x00, 0x27, 0x40, 0x06, 0x02, 0x08, 0x03, 0x00, 0x83, // "'" (U+0027)
  0x00, 0x28, 0x40, 0xFF, 0x03, 0x08, 0x04, 0x00, 0x88, // "(" (U+0028)
  0x00, 0x29, 0x40, 0xFF, 0x03, 0x08, 0x04, 0x00, 0x9C, // ")" (U+0029)
  0x00, 0x2A, 0x40, 0x05, 0x04, 0x08, 0x05, 0x00, 0xB0, // "*" (U+002A)
  0x00, 0x2B, 0x40, 0x03, 0x04, 0x07, 0x06, 0x00, 0xBA, // "+" (U+002B)
  0x00, 0x2C, 0x40, 0xFF, 0x02, 0x02, 0x03, 0x00, 0xC7, // "," (U+002C)
  0x00, 0x2D, 0x40, 0x03, 0x02, 0x03, 0x03, 0x00, 0xCD, // "-" (U+002D)
  0x00, 0x2E, 0x40, 0x01, 0x02, 0x02, 0x03, 0x00, 0xCF, // "." (U+002E)
  0x00, 0x2F, 0x40, 0xFF, 0x02, 0x08, 0x03, 0x00, 0xD2, // "/" (U+002F)
  0x00, 0x30, 0x40, 0x01, 0x05, 0x08, 0x06, 0x00, 0xE1, // "0" (U+0030)
  0x00, 0x31, 0x00, 0x01, 0x05, 0x08, 0x06, 0x00, 0xF9, // "1" (U+0031)
  0x00, 0x32, 0x40, 0x01, 0x05, 0x08, 0x06, 0x01, 0x10, // "2" (U+0032)
  0x00, 0x33, 0x40, 0x01, 0x05, 0x08, 0x06, 0x01, 0x28, // "3" (U+0033)
  0x00, 0x34, 0x40, 0x01, 0x05, 0x08, 0x06, 0x01, 0x40, // "4" (U+0034)
  0x00, 0x35, 0x40, 0x01, 0x04, 0x08, 0x06, 0x01, 0x58, // "5" (U+0035)
  0x00, 0x36, 0x40, 0x01, 0x05, 0x08, 0x06, 0x01, 0x6C, // "6" (U+0036)
  0x00, 0x37, 0x40, 0x01, 0x05, 0x08, 0x06, 0x01, 0x84, // "7" (U+0037)
  0x00, 0x38, 0x40, 0x01, 0x05, 0x08, 0x06, 0x01, 0x9C, // "8" (U+0038)
  0x00, 0x39, 0x40, 0x01, 0x05, 0x08, 0x06, 0x01, 0xB4, // "9" (U+0039)
  0x00, 0x3A, 0x40, 0x01, 0x02, 0x06, 0x03, 0x01, 0xCC, // ":" (U+003A)
  0x00, 0x3B, 0x40, 0xFF, 0x02, 0x06, 0x03, 0x01, 0xD5, // ";" (U+003B)
  0x00, 0x3C, 0x40, 0x02, 0x04, 0x06, 0x06, 0x01, 0xE1, // "<" (U+003C)
  0x00, 0x3D, 0x00, 0x03, 0x04, 0x05, 0x06, 0x01, 0xEE, // "=" (U+003D)
  0x00, 0x3E, 0x40, 0x02, 0x04, 0x06, 0x06, 0x01, 0xF5, // ">" (U+003E)
  0x00, 0x3F, 0x40, 0x01, 0x04, 0x08, 0x06, 0x02, 0x02, // "?" (U+003F)
  0x00, 0x40, 0x40, 0xFF, 0x08, 0x08, 0x09, 0x02, 0x16, // "@" (U+0040)
  0x00, 0x41, 0x00, 0x01, 0x07, 0x08, 0x08, 0x02, 0x43, // "A" (U+0041)
  0x00, 0x42, 0x40, 0x01, 0x06, 0x08, 0x07, 0x02, 0x62, // "B" (U+0042)
  0x00, 0x43, 0x40, 0x01, 0x06, 0x08, 0x07, 0x02, 0x7E, // "C" (U+0043)
  0x00, 0x44, 0x40, 0x01, 0x07, 0x08, 0x08, 0x02, 0x9A, // "D" (U+0044)
  0x00, 0x45, 0x00, 0x01, 0x06, 0x08, 0x07, 0x02, 0xBA, // "E" (U+0045)
  0x00, 0x46, 0x40, 0x01, 0x05, 0x08, 0x06, 0x02, 0xD5, // "F" (U+0046)
  0x00, 0x47, 0x40, 0x01, 0x07, 0x08, 0x08, 0x02, 0xED, // "G" (U+0047)
  0x00, 0x48, 0x40, 0x01, 0x07, 0x08, 0x08, 0x03, 0x0D, // "H" (U+0048)
  0x00, 0x49, 0x40, 0x01, 0x03, 0x08, 0x04, 0x03, 0x2D, // "I" (U+0049)
  0x00, 0x4A, 0xBF, 0xFE, 0x03, 0x08, 0x04, 0x03, 0x3D, // "J" (U+004A)
  0x00, 0x4B, 0x40, 0x01, 0x07, 0x08, 0x07, 0x03, 0x59, // "K" (U+004B)
  0x00, 0x4C, 0x00, 0x01, 0x06, 0x08, 0x07, 0x03, 0x79, // "L" (U+004C)
  0x00, 0x4D, 0x40, 0x01, 0x09, 0x08, 0x0A, 0x03, 0x90, // "M" (U+004D)
  0x00, 0x4E, 0x40, 0x01, 0x07, 0x08, 0x08, 0x03, 0xB8, // "N" (U+004E)
  0x00, 0x4F, 0x40, 0x01, 0x07, 0x08, 0x08, 0x03, 0xD8, // "O" (U+004F)
  0x00, 0x50, 0x40, 0x01, 0x05, 0x08, 0x06, 0x03, 0xF8, // "P" (U+0050)
  0x00, 0x51, 0x40, 0xFE, 0x07, 0x08, 0x08, 0x04, 0x10, // "Q" (U+0051)
  0x00, 0x52, 0x40, 0x01, 0x07, 0x08, 0x07, 0x04, 0x3C, // "R" (U+0052)
  0x00, 0x53, 0x40, 0x01, 0x05, 0x08, 0x06, 0x04, 0x5C, // "S" (U+0053)
  0x00, 0x54, 0x40, 0x01, 0x06, 0x08, 0x07, 0x04, 0x74, // "T" (U+0054)
  0x00, 0x55, 0x40, 0x01, 0x07, 0x08, 0x07, 0x04, 0x90, // "U" (U+0055)
  0x00, 0x56, 0x40, 0x01, 0x06, 0x08, 0x07, 0x04, 0xB0, // "V" (U+0056)
  0x00, 0x57, 0x40, 0x01, 0x0A, 0x08, 0x0B, 0x04, 0xCC, // "W" (U+0057)
  0x00, 0x58, 0x40, 0x01, 0x07, 0x08, 0x07, 0x04, 0xF8, // "X" (U+0058)
  0x00, 0x59, 0x40, 0x01, 0x06, 0x08, 0x07, 0x05, 0x18, // "Y" (U+0059)
  0x00, 0x5A, 0x40, 0x01, 0x06, 0x08, 0x07, 0x05, 0x34, // "Z" (U+005A)
  0x00, 0x5B, 0x41, 0xFF, 0x03, 0x08, 0x04, 0x05, 0x50, // "[" (U+005B)
  0x00, 0x5C, 0x40, 0xFF, 0x02, 0x08, 0x03, 0x05, 0x5F, // "\" (U+005C)
  0x00, 0x5D, 0x40, 0xFF, 0x03, 0x08, 0x04, 0x05, 0x6E, // "]" (U+005D)
  0x00, 0x5E, 0x40, 0x04, 0x04, 0x08, 0x06, 0x05, 0x82, // "^" (U+005E)
  0x00, 0x5F, 0x40, 0xFF, 0x04, 0xFF, 0x05, 0x05, 0x8F, // "_" (U+005F)
  0x00, 0x60, 0x40, 0x08, 0x02, 0x09, 0x03, 0x05, 0x92, // "`" (U+0060)
  0x00, 0x61, 0x40, 0x01, 0x05, 0x06, 0x06, 0x05, 0x95, // "a" (U+0061)
  0x00, 0x62, 0x40, 0x01, 0x05, 0x08, 0x06, 0x05, 0xA7, // "b" (U+0062)
  0x00, 0x63, 0x40, 0x01, 0x04, 0x06, 0x05, 0x05, 0xBF, // "c" (U+0063)
  0x00, 0x64, 0x40, 0x01, 0x06, 0x08, 0x06, 0x05, 0xCE, // "d" (U+0064)
  0x00, 0x65, 0x40, 0x01, 0x05, 0x06, 0x06, 0x05, 0xEA, // "e" (U+0065)
  0x00, 0x66, 0x40, 0x01, 0x04, 0x08, 0x04, 0x05, 0xFC, // "f" (U+0066)
  0x00, 0x67, 0x40, 0xFE, 0x05, 0x06, 0x06, 0x06, 0x10, // "g" (U+0067)
  0x00, 0x68, 0x40, 0x01, 0x06, 0x08, 0x07, 0x06, 0x2B, // "h" (U+0068)
  0x00, 0x69, 0x40, 0x01, 0x03, 0x08, 0x04, 0x06, 0x47, // "i" (U+0069)
  0x00, 0x6A, 0xBF, 0xFE, 0x02, 0x08, 0x03, 0x06, 0x57, // "j" (U+006A)
  0x00, 0x6B, 0x40, 0x01, 0x06, 0x08, 0x06, 0x06, 0x6D, // "k" (U+006B)
  0x00, 0x6C, 0x40, 0x01, 0x03, 0x08, 0x04, 0x06, 0x89, // "l" (U+006C)
  0x00, 0x6D, 0x40, 0x01, 0x09, 0x06, 0x0A, 0x06, 0x99, // "m" (U+006D)
  0x00, 0x6E, 0x40, 0x01, 0x06, 0x06, 0x07, 0x06, 0xB7, // "n" (U+006E)
  0x00, 0x6F, 0x40, 0x01, 0x05, 0x06, 0x06, 0x06, 0xCC, // "o" (U+006F)
  0x00, 0x70, 0x40, 0xFE, 0x05, 0x06, 0x06, 0x06, 0xDE, // "p" (U+0070)
  0x00, 0x71, 0x00, 0xFE, 0x06, 0x06, 0x06, 0x06, 0xF9, // "q" (U+0071)
  0x00, 0x72, 0x40, 0x01, 0x04, 0x06, 0x05, 0x07, 0x18, // "r" (U+0072)
  0x00, 0x73, 0x40, 0x01, 0x04, 0x06, 0x05, 0x07, 0x27, // "s" (U+0073)
  0x00, 0x74, 0x40, 0x01, 0x03, 0x08, 0x04, 0x07, 0x36, // "t" (U+0074)
  0x00, 0x75, 0x40, 0x01, 0x06, 0x06, 0x07, 0x07, 0x46, // "u" (U+0075)
  0x00, 0x76, 0x40, 0x01, 0x05, 0x06, 0x06, 0x07, 0x5B, // "v" (U+0076)
  0x00, 0x77, 0x40, 0x01, 0x08, 0x06, 0x09, 0x07, 0x6D, // "w" (U+0077)
  0x00, 0x78, 0x40, 0x01, 0x06, 0x06, 0x06, 0x07, 0x88, // "x" (U+0078)
  0x00, 0x79, 0x40, 0xFE, 0x05, 0x06, 0x06, 0x07, 0x9D, // "y" (U+0079)
  0x00, 0x7A, 0x40, 0x01, 0x04, 0x06, 0x05, 0x07, 0xB8, // "z" (U+007A)
  0x00, 0x7B, 0x40, 0xFF, 0x04, 0x08, 0x04, 0x07, 0xC7, // "{" (U+007B)
  0x00, 0x7C, 0x42, 0xFE, 0x03, 0x08, 0x06, 0x07, 0xE0, // "|" (U+007C)
  0x00, 0x7D, 0x40, 0xFF, 0x04, 0x08, 0x04, 0x07, 0xEB, // "}" (U+007D)
  0x00, 0x7E, 0x40, 0x04, 0x04, 0x05, 0x06, 0x08, 0x04, // "~" (U+007E)
  0x00, 0xA1, 0x41, 0xFE, 0x02, 0x05, 0x04, 0x08, 0x09, // "¡" (U+00A1)
  0x00, 0xA2, 0x40, 0x01, 0x05, 0x08, 0x06, 0x08, 0x11, // "¢" (U+00A2)
  0x00, 0xA3, 0x40, 0x01, 0x05, 0x08, 0x06, 0x08, 0x29, // "£" (U+00A3)
  0x00, 0xA4, 0x40, 0x03, 0x04, 0x07, 0x06, 0x08, 0x41, // "¤" (U+00A4)
  0x00, 0xA5, 0x40, 0x01, 0x05, 0x08, 0x06, 0x08, 0x4E, // "¥" (U+00A5)
  0x00, 0xA6, 0x42, 0xFE, 0x03, 0x08, 0x06, 0x08, 0x66, // "¦" (U+00A6)
  0x00, 0xA7, 0x40, 0xFF, 0x04, 0x08, 0x05, 0x08, 0x71, // "§" (U+00A7)
  0x00, 0xA8, 0x41, 0x07, 0x04, 0x08, 0x06, 0x08, 0x8A, // "¨" (U+00A8)
  0x00, 0xA9, 0x40, 0x01, 0x07, 0x08, 0x08, 0x08, 0x8E, // "©" (U+00A9)
  0x00, 0xAA, 0x40, 0x05, 0x03, 0x07, 0x04, 0x08, 0xAE, // "ª" (U+00AA)
  0x00, 0xAB, 0x40, 0x02, 0x04, 0x05, 0x06, 0x08, 0xB4, // "«" (U+00AB)
  0x00, 0xAC, 0x00, 0x02, 0x04, 0x04, 0x06, 0x08, 0xBE, // "¬" (U+00AC)
  0x00, 0xAE, 0x40, 0x01, 0x07, 0x08, 0x08, 0x08, 0xC5, // "®" (U+00AE)
  0x00, 0xAF, 0x40, 0x09, 0x04, 0x09, 0x05, 0x08, 0xE5, // "¯" (U+00AF)
  0x00, 0xB0, 0x40, 0x05, 0x03, 0x08, 0x04, 0x08, 0xE8, // "°" (U+00B0)
  0x00, 0xB1, 0x40, 0x01, 0x04, 0x06, 0x06, 0x08, 0xF0, // "±" (U+00B1)
  0x00, 0xB2, 0x40, 0x05, 0x03, 0x09, 0x04, 0x08, 0xFF, // "²" (U+00B2)
  0x00, 0xB3, 0x40, 0x05, 0x03, 0x09, 0x04, 0x09, 0x09, // "³" (U+00B3)
  0x00, 0xB4, 0x40, 0x08, 0x02, 0x09, 0x03, 0x09, 0x13, // "´" (U+00B4)
  0x00, 0xB5, 0x00, 0xFE, 0x06, 0x06, 0x07, 0x09, 0x16, // "µ" (U+00B5)
  0x00, 0xB6, 0x40, 0xFF, 0x05, 0x08, 0x06, 0x09, 0x34, // "¶" (U+00B6)
  0x00, 0xB7, 0x40, 0x04, 0x02, 0x05, 0x03, 0x09, 0x52, // "·" (U+00B7)
  0x00, 0xB8, 0x40, 0xFE, 0x02, 0x00, 0x03, 0x09, 0x55, // "¸" (U+00B8)
  0x00, 0xB9, 0x40, 0x05, 0x03, 0x09, 0x04, 0x09, 0x5A, // "¹" (U+00B9)
  0x00, 0xBA, 0x40, 0x05, 0x03, 0x07, 0x04, 0x09, 0x64, // "º" (U+00BA)
  0x00, 0xBB, 0x40, 0x02, 0x04, 0x05, 0x06, 0x09, 0x6A, // "»" (U+00BB)
  0x00, 0xBC, 0x40, 0x01, 0x07, 0x08, 0x08, 0x09, 0x74, // "¼" (U+00BC)
  0x00, 0xBD, 0x40, 0x01, 0x08, 0x08, 0x08, 0x09, 0x94, // "½" (U+00BD)
  0x00, 0xBE, 0x40, 0x01, 0x07, 0x08, 0x08, 0x09, 0xB8, // "¾" (U+00BE)
  0x00, 0xBF, 0x41, 0xFE, 0x05, 0x05, 0x06, 0x09, 0xD8, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x07, 0x0B, 0x08, 0x09, 0xEC, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x07, 0x0B, 0x08, 0x0A, 0x11, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x01, 0x07, 0x0B, 0x08, 0x0A, 0x36, // "Â" (U+00C2)
  0x00, 0xC3, 0x00, 0x01, 0x07, 0x0B, 0x08, 0x0A, 0x5C, // "Ã" (U+00C3)
  0x00, 0xC4, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x0A, 0x83, // "Ä" (U+00C4)
  0x00, 0xC5, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x0A, 0xA7, // "Å" (U+00C5)
  0x00, 0xC6, 0x00, 0x01, 0x09, 0x08, 0x0A, 0x0A, 0xCC, // "Æ" (U+00C6)
  0x00, 0xC7, 0x00, 0xFE, 0x06, 0x08, 0x07, 0x0A, 0xF3, // "Ç" (U+00C7)
  0x00, 0xC8, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x0B, 0x18, // "È" (U+00C8)
  0x00, 0xC9, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x0B, 0x3A, // "É" (U+00C9)
  0x00, 0xCA, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x0B, 0x5B, // "Ê" (U+00CA)
  0x00, 0xCB, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x0B, 0x7E, // "Ë" (U+00CB)
  0x00, 0xCC, 0x40, 0x01, 0x03, 0x0B, 0x04, 0x0B, 0x9F, // "Ì" (U+00CC)
  0x00, 0xCD, 0x40, 0x01, 0x03, 0x0B, 0x04, 0x0B, 0xB5, // "Í" (U+00CD)
  0x00, 0xCE, 0x40, 0x01, 0x03, 0x0B, 0x04, 0x0B, 0xCB, // "Î" (U+00CE)
  0x00, 0xCF, 0x40, 0x01, 0x03, 0x0A, 0x04, 0x0B, 0xE1, // "Ï" (U+00CF)
  0x00, 0xD0, 0x40, 0x01, 0x07, 0x08, 0x08, 0x0B, 0xF5, // "Ð" (U+00D0)
  0x00, 0xD1, 0x40, 0x01, 0x07, 0x0B, 0x08, 0x0C, 0x15, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x00, 0x01, 0x07, 0x0B, 0x08, 0x0C, 0x41, // "Ò" (U+00D2)
  0x00, 0xD3, 0x00, 0x01, 0x07, 0x0B, 0x08, 0x0C, 0x6B, // "Ó" (U+00D3)
  0x00, 0xD4, 0x00, 0x01, 0x07, 0x0B, 0x08, 0x0C, 0x95, // "Ô" (U+00D4)
  0x00, 0xD5, 0x40, 0x01, 0x07, 0x0B, 0x08, 0x0C, 0xC0, // "Õ" (U+00D5)
  0x00, 0xD6, 0x40, 0x01, 0x07, 0x0A, 0x08, 0x0C, 0xEC, // "Ö" (U+00D6)
  0x00, 0xD7, 0x41, 0x02, 0x04, 0x06, 0x06, 0x0D, 0x14, // "×" (U+00D7)
  0x00, 0xD8, 0x40, 0x00, 0x07, 0x08, 0x08, 0x0D, 0x1E, // "Ø" (U+00D8)
  0x00, 0xD9, 0x00, 0x01, 0x07, 0x0B, 0x07, 0x0D, 0x42, // "Ù" (U+00D9)
  0x00, 0xDA, 0x00, 0x01, 0x07, 0x0B, 0x07, 0x0D, 0x6D, // "Ú" (U+00DA)
  0x00, 0xDB, 0x40, 0x01, 0x07, 0x0B, 0x07, 0x0D, 0x97, // "Û" (U+00DB)
  0x00, 0xDC, 0x40, 0x01, 0x07, 0x0A, 0x07, 0x0D, 0xC3, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x0D, 0xEB, // "Ý" (U+00DD)
  0x00, 0xDE, 0x40, 0x01, 0x05, 0x08, 0x06, 0x0E, 0x0F, // "Þ" (U+00DE)
  0x00, 0xDF, 0x40, 0x01, 0x06, 0x08, 0x07, 0x0E, 0x27, // "ß" (U+00DF)
  0x00, 0xE0, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0E, 0x43, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x05, 0x09, 0x06, 0x0E, 0x5E, // "á" (U+00E1)
  0x00, 0xE2, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0E, 0x78, // "â" (U+00E2)
  0x00, 0xE3, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0E, 0x93, // "ã" (U+00E3)
  0x00, 0xE4, 0x40, 0x01, 0x05, 0x08, 0x06, 0x0E, 0xAE, // "ä" (U+00E4)
  0x00, 0xE5, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0E, 0xC6, // "å" (U+00E5)
  0x00, 0xE6, 0x40, 0x01, 0x08, 0x06, 0x09, 0x0E, 0xE1, // "æ" (U+00E6)
  0x00, 0xE7, 0x40, 0xFE, 0x04, 0x06, 0x05, 0x0E, 0xFC, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x01, 0x05, 0x09, 0x06, 0x0F, 0x13, // "è" (U+00E8)
  0x00, 0xE9, 0x00, 0x01, 0x05, 0x09, 0x06, 0x0F, 0x2D, // "é" (U+00E9)
  0x00, 0xEA, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0F, 0x47, // "ê" (U+00EA)
  0x00, 0xEB, 0x40, 0x01, 0x05, 0x08, 0x06, 0x0F, 0x62, // "ë" (U+00EB)
  0x00, 0xEC, 0x40, 0x01, 0x03, 0x09, 0x04, 0x0F, 0x7A, // "ì" (U+00EC)
  0x00, 0xED, 0x40, 0x01, 0x03, 0x09, 0x04, 0x0F, 0x8C, // "í" (U+00ED)
  0x00, 0xEE, 0xFF, 0x01, 0x03, 0x09, 0x04, 0x0F, 0x9E, // "î" (U+00EE)
  0x00, 0xEF, 0x40, 0x01, 0x03, 0x08, 0x04, 0x0F, 0xB2, // "ï" (U+00EF)
  0x00, 0xF0, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0F, 0xC2, // "ð" (U+00F0)
  0x00, 0xF1, 0x40, 0x01, 0x06, 0x09, 0x07, 0x0F, 0xDD, // "ñ" (U+00F1)
  0x00, 0xF2, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0F, 0xFD, // "ò" (U+00F2)
  0x00, 0xF3, 0x40, 0x01, 0x05, 0x09, 0x06, 0x10, 0x18, // "ó" (U+00F3)
  0x00, 0xF4, 0x40, 0x01, 0x05, 0x09, 0x06, 0x10, 0x33, // "ô" (U+00F4)
  0x00, 0xF5, 0x40, 0x01, 0x05, 0x09, 0x06, 0x10, 0x4E, // "õ" (U+00F5)
  0x00, 0xF6, 0x40, 0x01, 0x05, 0x08, 0x06, 0x10, 0x69, // "ö" (U+00F6)
  0x00, 0xF7, 0x00, 0x01, 0x04, 0x06, 0x06, 0x10, 0x81, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x00, 0x05, 0x07, 0x06, 0x10, 0x8E, // "ø" (U+00F8)
  0x00, 0xF9, 0x00, 0x01, 0x06, 0x09, 0x07, 0x10, 0xA5, // "ù" (U+00F9)
  0x00, 0xFA, 0x00, 0x01, 0x06, 0x09, 0x07, 0x10, 0xC4, // "ú" (U+00FA)
  0x00, 0xFB, 0x40, 0x01, 0x06, 0x09, 0x07, 0x10, 0xE3, // "û" (U+00FB)
  0x00, 0xFC, 0x40, 0x01, 0x06, 0x08, 0x07, 0x11, 0x03, // "ü" (U+00FC)
  0x00, 0xFD, 0x00, 0xFE, 0x05, 0x09, 0x06, 0x11, 0x1F, // "ý" (U+00FD)
  0x00, 0xFE, 0x40, 0xFE, 0x05, 0x08, 0x06, 0x11, 0x42, // "þ" (U+00FE)
  0x00, 0xFF, 0x40, 0xFE, 0x05, 0x08, 0x06, 0x11, 0x63, // "ÿ" (U+00FF)
  0x01, 0x00, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x11, 0x84, // "Ā" (U+0100)
  0x01, 0x01, 0x40, 0x01, 0x05, 0x08, 0x06, 0x11, 0xA7, // "ā" (U+0101)
  0x01, 0x02, 0x00, 0x01, 0x07, 0x0B, 0x08, 0x11, 0xBF, // "Ă" (U+0102)
  0x01, 0x03, 0x40, 0x01, 0x05, 0x09, 0x06, 0x11, 0xE6, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0xFE, 0x07, 0x08, 0x08, 0x12, 0x01, // "Ą" (U+0104)
  0x01, 0x05, 0x40, 0xFE, 0x05, 0x06, 0x06, 0x12, 0x28, // "ą" (U+0105)
  0x01, 0x06, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x12, 0x43, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x01, 0x04, 0x09, 0x05, 0x12, 0x65, // "ć" (U+0107)
  0x01, 0x08, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x12, 0x7B, // "Ĉ" (U+0108)
  0x01, 0x09, 0x00, 0x01, 0x04, 0x09, 0x05, 0x12, 0x9F, // "ĉ" (U+0109)
  0x01, 0x0A, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x12, 0xB5, // "Ċ" (U+010A)
  0x01, 0x0B, 0x00, 0x01, 0x04, 0x09, 0x05, 0x12, 0xD7, // "ċ" (U+010B)
  0x01, 0x0C, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x12, 0xED, // "Č" (U+010C)
  0x01, 0x0D, 0x40, 0x01, 0x04, 0x09, 0x05, 0x13, 0x11, // "č" (U+010D)
  0x01, 0x0E, 0x00, 0x01, 0x07, 0x0B, 0x08, 0x13, 0x28, // "Ď" (U+010E)
  0x01, 0x0F, 0x40, 0x01, 0x07, 0x08, 0x06, 0x13, 0x53, // "ď" (U+010F)
  0x01, 0x10, 0x40, 0x01, 0x07, 0x08, 0x08, 0x13, 0x73, // "Đ" (U+0110)
  0x01, 0x11, 0x40, 0x01, 0x06, 0x08, 0x06, 0x13, 0x93, // "đ" (U+0111)
  0x01, 0x12, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x13, 0xAF, // "Ē" (U+0112)
  0x01, 0x13, 0x40, 0x01, 0x05, 0x08, 0x06, 0x13, 0xCF, // "ē" (U+0113)
  0x01, 0x14, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x13, 0xE7, // "Ĕ" (U+0114)
  0x01, 0x15, 0x40, 0x01, 0x05, 0x09, 0x06, 0x14, 0x0A, // "ĕ" (U+0115)
  0x01, 0x16, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x14, 0x25, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x01, 0x05, 0x09, 0x06, 0x14, 0x46, // "ė" (U+0117)
  0x01, 0x18, 0x00, 0xFE, 0x06, 0x08, 0x07, 0x14, 0x60, // "Ę" (U+0118)
  0x01, 0x19, 0x40, 0xFE, 0x05, 0x06, 0x06, 0x14, 0x83, // "ę" (U+0119)
  0x01, 0x1A, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x14, 0x9E, // "Ě" (U+011A)
  0x01, 0x1B, 0x40, 0x01, 0x05, 0x09, 0x06, 0x14, 0xC1, // "ě" (U+011B)
  0x01, 0x1C, 0x00, 0x01, 0x07, 0x0B, 0x08, 0x14, 0xDC, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x40, 0xFE, 0x05, 0x09, 0x06, 0x15, 0x06, // "ĝ" (U+011D)
  0x01, 0x1E, 0x00, 0x01, 0x07, 0x0B, 0x08, 0x15, 0x2A, // "Ğ" (U+011E)
  0x01, 0x1F, 0x40, 0xFE, 0x05, 0x09, 0x06, 0x15, 0x55, // "ğ" (U+011F)
  0x01, 0x20, 0x00, 0x01, 0x07, 0x0B, 0x08, 0x15, 0x79, // "Ġ" (U+0120)
  0x01, 0x21, 0x40, 0xFE, 0x05, 0x09, 0x06, 0x15, 0xA2, // "ġ" (U+0121)
  0x01, 0x22, 0x40, 0xFF, 0x07, 0x08, 0x08, 0x15, 0xC6, // "Ģ" (U+0122)
  0x01, 0x23, 0x40, 0xFE, 0x05, 0x08, 0x06, 0x15, 0xEE, // "ģ" (U+0123)
  0x01, 0x24, 0x00, 0x01, 0x07, 0x0B, 0x08, 0x16, 0x0F, // "Ĥ" (U+0124)
  0x01, 0x25, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x16, 0x39, // "ĥ" (U+0125)
  0x01, 0x26, 0x40, 0x01, 0x07, 0x08, 0x08, 0x16, 0x5E, // "Ħ" (U+0126)
  0x01, 0x27, 0x40, 0x01, 0x06, 0x08, 0x07, 0x16, 0x7E, // "ħ" (U+0127)
  0x01, 0x28, 0x00, 0x01, 0x04, 0x0B, 0x04, 0x16, 0x9A, // "Ĩ" (U+0128)
  0x01, 0x29, 0xFF, 0x01, 0x03, 0x09, 0x04, 0x16, 0xB2, // "ĩ" (U+0129)
  0x01, 0x2A, 0x40, 0x01, 0x03, 0x0A, 0x04, 0x16, 0xC6, // "Ī" (U+012A)
  0x01, 0x2B, 0x40, 0x01, 0x03, 0x08, 0x04, 0x16, 0xDA, // "ī" (U+012B)
  0x01, 0x2C, 0x40, 0x01, 0x03, 0x0B, 0x04, 0x16, 0xEA, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x40, 0x01, 0x03, 0x09, 0x04, 0x17, 0x00, // "ĭ" (U+012D)
  0x01, 0x2E, 0x40, 0xFE, 0x03, 0x08, 0x04, 0x17, 0x12, // "Į" (U+012E)
  0x01, 0x2F, 0x40, 0xFE, 0x03, 0x08, 0x04, 0x17, 0x28, // "į" (U+012F)
  0x01, 0x30, 0x40, 0x01, 0x03, 0x0B, 0x04, 0x17, 0x3E, // "İ" (U+0130)
  0x01, 0x31, 0x40, 0x01, 0x03, 0x06, 0x04, 0x17, 0x54, // "ı" (U+0131)
  0x01, 0x32, 0x40, 0xFE, 0x07, 0x08, 0x08, 0x17, 0x60, // "Ĳ" (U+0132)
  0x01, 0x33, 0x40, 0xFE, 0x06, 0x08, 0x07, 0x17, 0x8C, // "ĳ" (U+0133)
  0x01, 0x34, 0xFF, 0xFE, 0x03, 0x0B, 0x04, 0x17, 0xB3, // "Ĵ" (U+0134)
  0x01, 0x35, 0xBF, 0xFE, 0x02, 0x09, 0x03, 0x17, 0xD5, // "ĵ" (U+0135)
  0x01, 0x36, 0x00, 0xFF, 0x07, 0x08, 0x07, 0x17, 0xED, // "Ķ" (U+0136)
  0x01, 0x37, 0x00, 0xFF, 0x06, 0x08, 0x06, 0x18, 0x14, // "ķ" (U+0137)
  0x01, 0x38, 0x40, 0x01, 0x06, 0x06, 0x06, 0x18, 0x35, // "ĸ" (U+0138)
  0x01, 0x39, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x18, 0x4A, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x40, 0x01, 0x03, 0x0B, 0x04, 0x18, 0x67, // "ĺ" (U+013A)
  0x01, 0x3B, 0x00, 0xFF, 0x06, 0x08, 0x07, 0x18, 0x7D, // "Ļ" (U+013B)
  0x01, 0x3C, 0x40, 0xFF, 0x03, 0x08, 0x04, 0x18, 0x9A, // "ļ" (U+013C)
  0x01, 0x3D, 0x00, 0x01, 0x06, 0x08, 0x07, 0x18, 0xAE, // "Ľ" (U+013D)
  0x01, 0x3E, 0x40, 0x01, 0x04, 0x08, 0x04, 0x18, 0xC8, // "ľ" (U+013E)
  0x01, 0x3F, 0x00, 0x01, 0x06, 0x08, 0x07, 0x18, 0xDC, // "Ŀ" (U+013F)
  0x01, 0x40, 0x40, 0x01, 0x04, 0x08, 0x05, 0x18, 0xF7, // "ŀ" (U+0140)
  0x01, 0x41, 0x40, 0x01, 0x06, 0x08, 0x07, 0x19, 0x0B, // "Ł" (U+0141)
  0x01, 0x42, 0x40, 0x01, 0x03, 0x08, 0x04, 0x19, 0x27, // "ł" (U+0142)
  0x01, 0x43, 0x00, 0x01, 0x07, 0x0B, 0x08, 0x19, 0x37, // "Ń" (U+0143)
  0x01, 0x44, 0x00, 0x01, 0x06, 0x09, 0x07, 0x19, 0x62, // "ń" (U+0144)
  0x01, 0x45, 0x40, 0xFF, 0x07, 0x08, 0x08, 0x19, 0x81, // "Ņ" (U+0145)
  0x01, 0x46, 0x40, 0xFF, 0x06, 0x06, 0x07, 0x19, 0xA9, // "ņ" (U+0146)
  0x01, 0x47, 0x40, 0x01, 0x07, 0x0B, 0x08, 0x19, 0xC5, // "Ň" (U+0147)
  0x01, 0x48, 0x40, 0x01, 0x06, 0x09, 0x07, 0x19, 0xF1, // "ň" (U+0148)
  0x01, 0x49, 0x00, 0x01, 0x08, 0x08, 0x09, 0x1A, 0x11, // "ŉ" (U+0149)
  0x01, 0x4A, 0x40, 0xFE, 0x07, 0x08, 0x08, 0x1A, 0x32, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x40, 0xFE, 0x05, 0x06, 0x07, 0x1A, 0x5E, // "ŋ" (U+014B)
  0x01, 0x4C, 0x40, 0x01, 0x07, 0x0A, 0x08, 0x1A, 0x79, // "Ō" (U+014C)
  0x01, 0x4D, 0x40, 0x01, 0x05, 0x08, 0x06, 0x1A, 0xA1, // "ō" (U+014D)
  0x01, 0x4E, 0x40, 0x01, 0x07, 0x0B, 0x08, 0x1A, 0xB9, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x40, 0x01, 0x05, 0x09, 0x06, 0x1A, 0xE5, // "ŏ" (U+014F)
  0x01, 0x50, 0x40, 0x01, 0x07, 0x0B, 0x08, 0x1B, 0x00, // "Ő" (U+0150)
  0x01, 0x51, 0x40, 0x01, 0x05, 0x09, 0x06, 0x1B, 0x2C, // "ő" (U+0151)
  0x01, 0x52, 0x40, 0x01, 0x09, 0x08, 0x0A, 0x1B, 0x47, // "Œ" (U+0152)
  0x01, 0x53, 0x40, 0x01, 0x08, 0x06, 0x09, 0x1B, 0x6F, // "œ" (U+0153)
  0x01, 0x54, 0x00, 0x01, 0x07, 0x0B, 0x07, 0x1B, 0x8A, // "Ŕ" (U+0154)
  0x01, 0x55, 0x00, 0x01, 0x04, 0x09, 0x05, 0x1B, 0xB3, // "ŕ" (U+0155)
  0x01, 0x56, 0x40, 0xFF, 0x07, 0x08, 0x07, 0x1B, 0xC9, // "Ŗ" (U+0156)
  0x01, 0x57, 0x40, 0xFF, 0x04, 0x06, 0x05, 0x1B, 0xF1, // "ŗ" (U+0157)
  0x01, 0x58, 0x00, 0x01, 0x07, 0x0B, 0x07, 0x1C, 0x05, // "Ř" (U+0158)
  0x01, 0x59, 0x40, 0x01, 0x04, 0x09, 0x05, 0x1C, 0x2F, // "ř" (U+0159)
  0x01, 0x5A, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x1C, 0x46, // "Ś" (U+015A)
  0x01, 0x5B, 0x40, 0x01, 0x04, 0x09, 0x05, 0x1C, 0x66, // "ś" (U+015B)
  0x01, 0x5C, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x1C, 0x7D, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x40, 0x01, 0x04, 0x09, 0x05, 0x1C, 0x9E, // "ŝ" (U+015D)
  0x01, 0x5E, 0x40, 0xFE, 0x05, 0x08, 0x06, 0x1C, 0xB5, // "Ş" (U+015E)
  0x01, 0x5F, 0x40, 0xFE, 0x04, 0x06, 0x05, 0x1C, 0xD6, // "ş" (U+015F)
  0x01, 0x60, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x1C, 0xED, // "Š" (U+0160)
  0x01, 0x61, 0x40, 0x01, 0x04, 0x09, 0x05, 0x1D, 0x0E, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFE, 0x06, 0x08, 0x07, 0x1D, 0x25, // "Ţ" (U+0162)
  0x01, 0x63, 0x00, 0xFE, 0x04, 0x08, 0x04, 0x1D, 0x49, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x1D, 0x64, // "Ť" (U+0164)
  0x01, 0x65, 0x00, 0x01, 0x04, 0x08, 0x04, 0x1D, 0x88, // "ť" (U+0165)
  0x01, 0x66, 0x40, 0x01, 0x06, 0x08, 0x07, 0x1D, 0x9B, // "Ŧ" (U+0166)
  0x01, 0x67, 0x40, 0x01, 0x03, 0x08, 0x04, 0x1D, 0xB7, // "ŧ" (U+0167)
  0x01, 0x68, 0x40, 0x01, 0x07, 0x0B, 0x07, 0x1D, 0xC7, // "Ũ" (U+0168)
  0x01, 0x69, 0x40, 0x01, 0x06, 0x09, 0x07, 0x1D, 0xF3, // "ũ" (U+0169)
  0x01, 0x6A, 0x40, 0x01, 0x07, 0x0A, 0x07, 0x1E, 0x13, // "Ū" (U+016A)
  0x01, 0x6B, 0x40, 0x01, 0x06, 0x08, 0x07, 0x1E, 0x3B, // "ū" (U+016B)
  0x01, 0x6C, 0x40, 0x01, 0x07, 0x0B, 0x07, 0x1E, 0x57, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x40, 0x01, 0x06, 0x09, 0x07, 0x1E, 0x83, // "ŭ" (U+016D)
  0x01, 0x6E, 0x40, 0x01, 0x07, 0x0B, 0x07, 0x1E, 0xA3, // "Ů" (U+016E)
  0x01, 0x6F, 0x40, 0x01, 0x06, 0x09, 0x07, 0x1E, 0xCF, // "ů" (U+016F)
  0x01, 0x70, 0x40, 0x01, 0x07, 0x0B, 0x07, 0x1E, 0xEF, // "Ű" (U+0170)
  0x01, 0x71, 0x40, 0x01, 0x06, 0x09, 0x07, 0x1F, 0x1B, // "ű" (U+0171)
  0x01, 0x72, 0x40, 0xFE, 0x07, 0x08, 0x08, 0x1F, 0x3B, // "Ų" (U+0172)
  0x01, 0x73, 0x40, 0xFE, 0x06, 0x06, 0x07, 0x1F, 0x67, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x0A, 0x0B, 0x0B, 0x1F, 0x87, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x08, 0x09, 0x09, 0x1F, 0xBC, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x1F, 0xE1, // "Ŷ" (U+0176)
  0x01, 0x77, 0x40, 0xFE, 0x05, 0x09, 0x06, 0x20, 0x06, // "ŷ" (U+0177)
  0x01, 0x78, 0x40, 0x01, 0x06, 0x0A, 0x07, 0x20, 0x2A, // "Ÿ" (U+0178)
  0x01, 0x79, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x20, 0x4D, // "Ź" (U+0179)
  0x01, 0x7A, 0x40, 0x01, 0x04, 0x09, 0x05, 0x20, 0x70, // "ź" (U+017A)
  0x01, 0x7B, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x20, 0x87, // "Ż" (U+017B)
  0x01, 0x7C, 0x40, 0x01, 0x04, 0x09, 0x05, 0x20, 0xAA, // "ż" (U+017C)
  0x01, 0x7D, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x20, 0xC1, // "Ž" (U+017D)
  0x01, 0x7E, 0x40, 0x01, 0x04, 0x09, 0x05, 0x20, 0xE5, // "ž" (U+017E)
  0x01, 0x7F, 0x40, 0x01, 0x04, 0x08, 0x04, 0x20, 0xFC, // "ſ" (U+017F)
  0x03, 0xA9, 0x40, 0x01, 0x07, 0x08, 0x08, 0x21, 0x10, // "Ω" (U+03A9)
  0x03, 0xBC, 0x00, 0xFE, 0x06, 0x06, 0x07, 0x21, 0x30, // "μ" (U+03BC)
  0x03, 0xC0, 0x40, 0x01, 0x06, 0x06, 0x07, 0x21, 0x4E, // "π" (U+03C0)
  0x20, 0x13, 0x00, 0x03, 0x04, 0x03, 0x05, 0x21, 0x63, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x03, 0x09, 0x03, 0x0A, 0x21, 0x65, // "—" (U+2014)
  0x20, 0xAC, 0x40, 0x01, 0x05, 0x08, 0x06, 0x21, 0x67, // "€" (U+20AC)
  0x20, 0xBF, 0x40, 0x00, 0x05, 0x08, 0x06, 0x21, 0x7F, // "₿" (U+20BF)
  0x20, 0x18, 0x40, 0x05, 0x02, 0x08, 0x03, 0x21, 0x9A, // "‘" (U+2018)
  0x20, 0x19, 0x40, 0x05, 0x02, 0x08, 0x03, 0x21, 0xA0, // "’" (U+2019)
  0x20, 0x1A, 0x40, 0xFF, 0x02, 0x02, 0x03, 0x21, 0xA6, // "‚" (U+201A)
  0x20, 0x1B, 0x40, 0x05, 0x02, 0x08, 0x03, 0x21, 0xAC, // "‛" (U+201B)
  0x20, 0x1C, 0x40, 0x05, 0x04, 0x08, 0x05, 0x21, 0xB2, // "“" (U+201C)
  0x20, 0x1D, 0x40, 0x05, 0x04, 0x08, 0x05, 0x21, 0xBC, // "”" (U+201D)
  0x20, 0x1E, 0x40, 0xFF, 0x04, 0x02, 0x05, 0x21, 0xC6, // "„" (U+201E)
  0x20, 0x1F, 0x40, 0x05, 0x04, 0x08, 0x05, 0x21, 0xD0, // "‟" (U+201F)
  0x20, 0x20, 0x00, 0xFF, 0x04, 0x08, 0x05, 0x21, 0xDA, // "†" (U+2020)
  0x20, 0x21, 0x40, 0xFF, 0x04, 0x08, 0x05, 0x21, 0xF0, // "‡" (U+2021)
  0x20, 0x22, 0x40, 0x04, 0x03, 0x06, 0x04, 0x22, 0x09, // "•" (U+2022)
  0x20, 0x26, 0x40, 0x01, 0x08, 0x02, 0x09, 0x22, 0x0F, // "…" (U+2026)
  0x20, 0x30, 0x00, 0x01, 0x0C, 0x08, 0x0D, 0x22, 0x18, // "‰" (U+2030)
  0x20, 0x39, 0x40, 0x02, 0x02, 0x05, 0x04, 0x22, 0x4A, // "‹" (U+2039)
  0x20, 0x3A, 0x40, 0x02, 0x02, 0x05, 0x04, 0x22, 0x50, // "›" (U+203A)
  0x20, 0x44, 0xFE, 0x01, 0x02, 0x08, 0x01, 0x22, 0x56, // "⁄" (U+2044)
  0x21, 0x22, 0x40, 0x04, 0x07, 0x07, 0x08, 0x22, 0x69, // "™" (U+2122)
  0x21, 0x52, 0x00, 0x01, 0x0B, 0x08, 0x0C, 0x22, 0x79, // "⅒" (U+2152)
  0xFB, 0x01, 0x40, 0x01, 0x06, 0x08, 0x07, 0x22, 0xA7, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0x40, 0x01, 0x06, 0x08, 0x07, 0x22, 0xC3, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x01, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0xC0, 0x01, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x01, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x01, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x01, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x01, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x01, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xC6, 0x01, // "Æ (U+0022 U+00C6)
  0x00, 0x22, 0x01, 0x00, 0x01, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x02, 0x01, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x04, 0x01, // "Ą (U+0022 U+0104)
  0x00, 0x27, 0x00, 0x41, 0x01, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0xC0, 0x01, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x01, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x01, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x01, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x01, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x01, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xC6, 0x01, // 'Æ (U+0027 U+00C6)
  0x00, 0x27, 0x01, 0x00, 0x01, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x02, 0x01, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x04, 0x01, // 'Ą (U+0027 U+0104)
  0x00, 0x2A, 0x00, 0x2C, 0x01, // *, (U+002A U+002C)
  0x00, 0x2A, 0x00, 0x2E, 0x01, // *. (U+002A U+002E)
  0x00, 0x2A, 0x00, 0x41, 0x01, // *A (U+002A U+0041)
  0x00, 0x2A, 0x00, 0xC0, 0x01, // *À (U+002A U+00C0)
  0x00, 0x2A, 0x00, 0xC1, 0x01, // *Á (U+002A U+00C1)
  0x00, 0x2A, 0x00, 0xC2, 0x01, // *Â (U+002A U+00C2)
  0x00, 0x2A, 0x00, 0xC3, 0x01, // *Ã (U+002A U+00C3)
  0x00, 0x2A, 0x00, 0xC4, 0x01, // *Ä (U+002A U+00C4)
  0x00, 0x2A, 0x00, 0xC5, 0x01, // *Å (U+002A U+00C5)
  0x00, 0x2A, 0x00, 0xC6, 0x01, // *Æ (U+002A U+00C6)
  0x00, 0x2A, 0x01, 0x00, 0x01, // *Ā (U+002A U+0100)
  0x00, 0x2A, 0x01, 0x02, 0x01, // *Ă (U+002A U+0102)
  0x00, 0x2A, 0x01, 0x04, 0x01, // *Ą (U+002A U+0104)
  0x00, 0x2A, 0x20, 0x1A, 0x01, // *‚ (U+002A U+201A)
  0x00, 0x2A, 0x20, 0x1E, 0x01, // *„ (U+002A U+201E)
  0x00, 0x2A, 0x20, 0x26, 0x01, // *… (U+002A U+2026)
  0x00, 0x2C, 0x00, 0x3F, 0x01, // ,? (U+002C U+003F)
  0x00, 0x2C, 0x00, 0x54, 0x01, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x56, 0x01, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x01, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x01, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0x76, 0x01, // ,v (U+002C U+0076)
  0x00, 0x2C, 0x00, 0x77, 0x01, // ,w (U+002C U+0077)
  0x00, 0x2C, 0x00, 0x79, 0x01, // ,y (U+002C U+0079)
  0x00, 0x2C, 0x00, 0xDD, 0x01, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x00, 0xFD, 0x01, // ,ý (U+002C U+00FD)
  0x00, 0x2C, 0x00, 0xFF, 0x01, // ,ÿ (U+002C U+00FF)
  0x00, 0x2C, 0x01, 0x62, 0x01, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x01, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x01, // ,Ŧ (U+002C U+0166)
  0x00, 0x2C, 0x01, 0x74, 0x01, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x75, 0x01, // ,ŵ (U+002C U+0175)
  0x00, 0x2C, 0x01, 0x76, 0x01, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x77, 0x01, // ,ŷ (U+002C U+0177)
  0x00, 0x2C, 0x01, 0x78, 0x01, // ,Ÿ (U+002C U+0178)
  0x00, 0x2E, 0x00, 0x3F, 0x01, // .? (U+002E U+003F)
  0x00, 0x2E, 0x00, 0x54, 0x01, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x56, 0x01, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x01, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x01, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0x76, 0x01, // .v (U+002E U+0076)
  0x00, 0x2E, 0x00, 0x77, 0x01, // .w (U+002E U+0077)
  0x00, 0x2E, 0x00, 0x79, 0x01, // .y (U+002E U+0079)
  0x00, 0x2E, 0x00, 0xDD, 0x01, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x00, 0xFD, 0x01, // .ý (U+002E U+00FD)
  0x00, 0x2E, 0x00, 0xFF, 0x01, // .ÿ (U+002E U+00FF)
  0x00, 0x2E, 0x01, 0x62, 0x01, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x01, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x01, // .Ŧ (U+002E U+0166)
  0x00, 0x2E, 0x01, 0x74, 0x01, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x75, 0x01, // .ŵ (U+002E U+0175)
  0x00, 0x2E, 0x01, 0x76, 0x01, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x77, 0x01, // .ŷ (U+002E U+0177)
  0x00, 0x2E, 0x01, 0x78, 0x01, // .Ÿ (U+002E U+0178)
  0x00, 0x41, 0x00, 0x22, 0x01, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x01, // A' (U+0041 U+0027)
  0x00, 0x41, 0x00, 0x2A, 0x01, // A* (U+0041 U+002A)
  0x00, 0x41, 0x00, 0x3F, 0x01, // A? (U+0041 U+003F)
  0x00, 0x41, 0x00, 0x54, 0x01, // AT (U+0041 U+0054)
  0x00, 0x41, 0x00, 0x56, 0x01, // AV (U+0041 U+0056)
  0x00, 0x41, 0x00, 0x57, 0x01, // AW (U+0041 U+0057)
  0x00, 0x41, 0x00, 0x59, 0x01, // AY (U+0041 U+0059)
  0x00, 0x41, 0x00, 0x76, 0x01, // Av (U+0041 U+0076)
  0x00, 0x41, 0x00, 0x79, 0x01, // Ay (U+0041 U+0079)
  0x00, 0x41, 0x00, 0xDD, 0x01, // AÝ (U+0041 U+00DD)
  0x00, 0x41, 0x00, 0xFD, 0x01, // Aý (U+0041 U+00FD)
  0x00, 0x41, 0x00, 0xFF, 0x01, // Aÿ (U+0041 U+00FF)
  0x00, 0x41, 0x01, 0x62, 0x01, // AŢ (U+0041 U+0162)
  0x00, 0x41, 0x01, 0x64, 0x01, // AŤ (U+0041 U+0164)
  0x00, 0x41, 0x01, 0x66, 0x01, // AŦ (U+0041 U+0166)
  0x00, 0x41, 0x01, 0x74, 0x01, // AŴ (U+0041 U+0174)
  0x00, 0x41, 0x01, 0x76, 0x01, // AŶ (U+0041 U+0176)
  0x00, 0x41, 0x01, 0x77, 0x01, // Aŷ (U+0041 U+0177)
  0x00, 0x41, 0x01, 0x78, 0x01, // AŸ (U+0041 U+0178)
  0x00, 0x41, 0x20, 0x18, 0x01, // A‘ (U+0041 U+2018)
  0x00, 0x41, 0x20, 0x19, 0x01, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1C, 0x01, // A“ (U+0041 U+201C)
  0x00, 0x41, 0x20, 0x1D, 0x01, // A” (U+0041 U+201D)
  0x00, 0x41, 0x21, 0x22, 0x01, // A™ (U+0041 U+2122)
  0x00, 0x44, 0x00, 0xC6, 0x01, // DÆ (U+0044 U+00C6)
  0x00, 0x46, 0x00, 0x2C, 0x01, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x01, // F. (U+0046 U+002E)
  0x00, 0x46, 0x00, 0x41, 0x01, // FA (U+0046 U+0041)
  0x00, 0x46, 0x00, 0xC0, 0x01, // FÀ (U+0046 U+00C0)
  0x00, 0x46, 0x00, 0xC1, 0x01, // FÁ (U+0046 U+00C1)
  0x00, 0x46, 0x00, 0xC2, 0x01, // FÂ (U+0046 U+00C2)
  0x00, 0x46, 0x00, 0xC3, 0x01, // FÃ (U+0046 U+00C3)
  0x00, 0x46, 0x00, 0xC4, 0x01, // FÄ (U+0046 U+00C4)
  0x00, 0x46, 0x00, 0xC5, 0x01, // FÅ (U+0046 U+00C5)
  0x00, 0x46, 0x00, 0xC6, 0x01, // FÆ (U+0046 U+00C6)
  0x00, 0x46, 0x01, 0x00, 0x01, // FĀ (U+0046 U+0100)
  0x00, 0x46, 0x01, 0x02, 0x01, // FĂ (U+0046 U+0102)
  0x00, 0x46, 0x01, 0x04, 0x01, // FĄ (U+0046 U+0104)
  0x00, 0x46, 0x20, 0x1A, 0x01, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x01, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x01, // F… (U+0046 U+2026)
  0x00, 0x4C, 0x00, 0x22, 0x01, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x01, // L' (U+004C U+0027)
  0x00, 0x4C, 0x00, 0x2A, 0x01, // L* (U+004C U+002A)
  0x00, 0x4C, 0x00, 0x3F, 0x01, // L? (U+004C U+003F)
  0x00, 0x4C, 0x00, 0x54, 0x01, // LT (U+004C U+0054)
  0x00, 0x4C, 0x00, 0x56, 0x01, // LV (U+004C U+0056)
  0x00, 0x4C, 0x00, 0x57, 0x01, // LW (U+004C U+0057)
  0x00, 0x4C, 0x00, 0x59, 0x01, // LY (U+004C U+0059)
  0x00, 0x4C, 0x00, 0xDD, 0x01, // LÝ (U+004C U+00DD)
  0x00, 0x4C, 0x01, 0x62, 0x01, // LŢ (U+004C U+0162)
  0x00, 0x4C, 0x01, 0x64, 0x01, // LŤ (U+004C U+0164)
  0x00, 0x4C, 0x01, 0x66, 0x01, // LŦ (U+004C U+0166)
  0x00, 0x4C, 0x01, 0x74, 0x01, // LŴ (U+004C U+0174)
  0x00, 0x4C, 0x01, 0x76, 0x01, // LŶ (U+004C U+0176)
  0x00, 0x4C, 0x01, 0x78, 0x01, // LŸ (U+004C U+0178)
  0x00, 0x4C, 0x20, 0x18, 0x01, // L‘ (U+004C U+2018)
  0x00, 0x4C, 0x20, 0x19, 0x01, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1C, 0x01, // L“ (U+004C U+201C)
  0x00, 0x4C, 0x20, 0x1D, 0x01, // L” (U+004C U+201D)
  0x00, 0x4C, 0x21, 0x22, 0x01, // L™ (U+004C U+2122)
  0x00, 0x4F, 0x00, 0xC6, 0x01, // OÆ (U+004F U+00C6)
  0x00, 0x50, 0x00, 0x2C, 0x01, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x01, // P. (U+0050 U+002E)
  0x00, 0x50, 0x00, 0x41, 0x01, // PA (U+0050 U+0041)
  0x00, 0x50, 0x00, 0xC0, 0x01, // PÀ (U+0050 U+00C0)
  0x00, 0x50, 0x00, 0xC1, 0x01, // PÁ (U+0050 U+00C1)
  0x00, 0x50, 0x00, 0xC2, 0x01, // PÂ (U+0050 U+00C2)
  0x00, 0x50, 0x00, 0xC3, 0x01, // PÃ (U+0050 U+00C3)
  0x00, 0x50, 0x00, 0xC4, 0x01, // PÄ (U+0050 U+00C4)
  0x00, 0x50, 0x00, 0xC5, 0x01, // PÅ (U+0050 U+00C5)
  0x00, 0x50, 0x00, 0xC6, 0x01, // PÆ (U+0050 U+00C6)
  0x00, 0x50, 0x01, 0x00, 0x01, // PĀ (U+0050 U+0100)
  0x00, 0x50, 0x01, 0x02, 0x01, // PĂ (U+0050 U+0102)
  0x00, 0x50, 0x01, 0x04, 0x01, // PĄ (U+0050 U+0104)
  0x00, 0x50, 0x20, 0x1A, 0x01, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x01, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x01, // P… (U+0050 U+2026)
  0x00, 0x51, 0x00, 0xC6, 0x01, // QÆ (U+0051 U+00C6)
  0x00, 0x54, 0x00, 0x2C, 0x01, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2E, 0x01, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0x41, 0x01, // TA (U+0054 U+0041)
  0x00, 0x54, 0x00, 0xC0, 0x01, // TÀ (U+0054 U+00C0)
  0x00, 0x54, 0x00, 0xC1, 0x01, // TÁ (U+0054 U+00C1)
  0x00, 0x54, 0x00, 0xC2, 0x01, // TÂ (U+0054 U+00C2)
  0x00, 0x54, 0x00, 0xC3, 0x01, // TÃ (U+0054 U+00C3)
  0x00, 0x54, 0x00, 0xC4, 0x01, // TÄ (U+0054 U+00C4)
  0x00, 0x54, 0x00, 0xC5, 0x01, // TÅ (U+0054 U+00C5)
  0x00, 0x54, 0x00, 0xC6, 0x01, // TÆ (U+0054 U+00C6)
  0x00, 0x54, 0x01, 0x00, 0x01, // TĀ (U+0054 U+0100)
  0x00, 0x54, 0x01, 0x02, 0x01, // TĂ (U+0054 U+0102)
  0x00, 0x54, 0x01, 0x04, 0x01, // TĄ (U+0054 U+0104)
  0x00, 0x54, 0x20, 0x1A, 0x01, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x01, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x01, // T… (U+0054 U+2026)
  0x00, 0x56, 0x00, 0x2C, 0x01, // V, (U+0056 U+002C)
  0x00, 0x56, 0x00, 0x2E, 0x01, // V. (U+0056 U+002E)
  0x00, 0x56, 0x00, 0x40, 0x01, // V@ (U+0056 U+0040)
  0x00, 0x56, 0x00, 0x41, 0x01, // VA (U+0056 U+0041)
  0x00, 0x56, 0x00, 0x61, 0x01, // Va (U+0056 U+0061)
  0x00, 0x56, 0x00, 0x63, 0x01, // Vc (U+0056 U+0063)
  0x00, 0x56, 0x00, 0x64, 0x01, // Vd (U+0056 U+0064)
  0x00, 0x56, 0x00, 0x65, 0x01, // Ve (U+0056 U+0065)
  0x00, 0x56, 0x00, 0x67, 0x01, // Vg (U+0056 U+0067)
  0x00, 0x56, 0x00, 0x6F, 0x01, // Vo (U+0056 U+006F)
  0x00, 0x56, 0x00, 0x71, 0x01, // Vq (U+0056 U+0071)
  0x00, 0x56, 0x00, 0xC0, 0x01, // VÀ (U+0056 U+00C0)
  0x00, 0x56, 0x00, 0xC1, 0x01, // VÁ (U+0056 U+00C1)
  0x00, 0x56, 0x00, 0xC2, 0x01, // VÂ (U+0056 U+00C2)
  0x00, 0x56, 0x00, 0xC3, 0x01, // VÃ (U+0056 U+00C3)
  0x00, 0x56, 0x00, 0xC4, 0x01, // VÄ (U+0056 U+00C4)
  0x00, 0x56, 0x00, 0xC5, 0x01, // VÅ (U+0056 U+00C5)
  0x00, 0x56, 0x00, 0xC6, 0x01, // VÆ (U+0056 U+00C6)
  0x00, 0x56, 0x00, 0xE0, 0x01, // Và (U+0056 U+00E0)
  0x00, 0x56, 0x00, 0xE1, 0x01, // Vá (U+0056 U+00E1)
  0x00, 0x56, 0x00, 0xE2, 0x01, // Vâ (U+0056 U+00E2)
  0x00, 0x56, 0x00, 0xE3, 0x01, // Vã (U+0056 U+00E3)
  0x00, 0x56, 0x00, 0xE4, 0x01, // Vä (U+0056 U+00E4)
  0x00, 0x56, 0x00, 0xE5, 0x01, // Vå (U+0056 U+00E5)
  0x00, 0x56, 0x00, 0xE6, 0x01, // Væ (U+0056 U+00E6)
  0x00, 0x56, 0x00, 0xE7, 0x01, // Vç (U+0056 U+00E7)
  0x00, 0x56, 0x00, 0xE8, 0x01, // Vè (U+0056 U+00E8)
  0x00, 0x56, 0x00, 0xE9, 0x01, // Vé (U+0056 U+00E9)
  0x00, 0x56, 0x00, 0xEA, 0x01, // Vê (U+0056 U+00EA)
  0x00, 0x56, 0x00, 0xEB, 0x01, // Vë (U+0056 U+00EB)
  0x00, 0x56, 0x00, 0xF0, 0x01, // Vð (U+0056 U+00F0)
  0x00, 0x56, 0x00, 0xF2, 0x01, // Vò (U+0056 U+00F2)
  0x00, 0x56, 0x00, 0xF3, 0x01, // Vó (U+0056 U+00F3)
  0x00, 0x56, 0x00, 0xF4, 0x01, // Vô (U+0056 U+00F4)
  0x00, 0x56, 0x00, 0xF5, 0x01, // Võ (U+0056 U+00F5)
  0x00, 0x56, 0x00, 0xF6, 0x01, // Vö (U+0056 U+00F6)
  0x00, 0x56, 0x00, 0xF8, 0x01, // Vø (U+0056 U+00F8)
  0x00, 0x56, 0x01, 0x00, 0x01, // VĀ (U+0056 U+0100)
  0x00, 0x56, 0x01, 0x01, 0x01, // Vā (U+0056 U+0101)
  0x00, 0x56, 0x01, 0x02, 0x01, // VĂ (U+0056 U+0102)
  0x00, 0x56, 0x01, 0x03, 0x01, // Vă (U+0056 U+0103)
  0x00, 0x56, 0x01, 0x04, 0x01, // VĄ (U+0056 U+0104)
  0x00, 0x56, 0x01, 0x05, 0x01, // Vą (U+0056 U+0105)
  0x00, 0x56, 0x01, 0x07, 0x01, // Vć (U+0056 U+0107)
  0x00, 0x56, 0x01, 0x09, 0x01, // Vĉ (U+0056 U+0109)
  0x00, 0x56, 0x01, 0x0B, 0x01, // Vċ (U+0056 U+010B)
  0x00, 0x56, 0x01, 0x0D, 0x01, // Vč (U+0056 U+010D)
  0x00, 0x56, 0x01, 0x0F, 0x01, // Vď (U+0056 U+010F)
  0x00, 0x56, 0x01, 0x11, 0x01, // Vđ (U+0056 U+0111)
  0x00, 0x56, 0x01, 0x13, 0x01, // Vē (U+0056 U+0113)
  0x00, 0x56, 0x01, 0x15, 0x01, // Vĕ (U+0056 U+0115)
  0x00, 0x56, 0x01, 0x17, 0x01, // Vė (U+0056 U+0117)
  0x00, 0x56, 0x01, 0x19, 0x01, // Vę (U+0056 U+0119)
  0x00, 0x56, 0x01, 0x1B, 0x01, // Vě (U+0056 U+011B)
  0x00, 0x56, 0x01, 0x1D, 0x01, // Vĝ (U+0056 U+011D)
  0x00, 0x56, 0x01, 0x1F, 0x01, // Vğ (U+0056 U+011F)
  0x00, 0x56, 0x01, 0x21, 0x01, // Vġ (U+0056 U+0121)
  0x00, 0x56, 0x01, 0x23, 0x01, // Vģ (U+0056 U+0123)
  0x00, 0x56, 0x01, 0x4D, 0x01, // Vō (U+0056 U+014D)
  0x00, 0x56, 0x01, 0x4F, 0x01, // Vŏ (U+0056 U+014F)
  0x00, 0x56, 0x01, 0x51, 0x01, // Vő (U+0056 U+0151)
  0x00, 0x56, 0x01, 0x53, 0x01, // Vœ (U+0056 U+0153)
  0x00, 0x56, 0x20, 0x1A, 0x01, // V‚ (U+0056 U+201A)
  0x00, 0x56, 0x20, 0x1E, 0x01, // V„ (U+0056 U+201E)
  0x00, 0x56, 0x20, 0x26, 0x01, // V… (U+0056 U+2026)
  0x00, 0x57, 0x00, 0x2C, 0x01, // W, (U+0057 U+002C)
  0x00, 0x57, 0x00, 0x2E, 0x01, // W. (U+0057 U+002E)
  0x00, 0x57, 0x00, 0x40, 0x01, // W@ (U+0057 U+0040)
  0x00, 0x57, 0x00, 0x41, 0x01, // WA (U+0057 U+0041)
  0x00, 0x57, 0x00, 0x61, 0x01, // Wa (U+0057 U+0061)
  0x00, 0x57, 0x00, 0x63, 0x01, // Wc (U+0057 U+0063)
  0x00, 0x57, 0x00, 0x64, 0x01, // Wd (U+0057 U+0064)
  0x00, 0x57, 0x00, 0x65, 0x01, // We (U+0057 U+0065)
  0x00, 0x57, 0x00, 0x67, 0x01, // Wg (U+0057 U+0067)
  0x00, 0x57, 0x00, 0x6F, 0x01, // Wo (U+0057 U+006F)
  0x00, 0x57, 0x00, 0x71, 0x01, // Wq (U+0057 U+0071)
  0x00, 0x57, 0x00, 0x73, 0x01, // Ws (U+0057 U+0073)
  0x00, 0x57, 0x00, 0xC0, 0x01, // WÀ (U+0057 U+00C0)
  0x00, 0x57, 0x00, 0xC1, 0x01, // WÁ (U+0057 U+00C1)
  0x00, 0x57, 0x00, 0xC2, 0x01, // WÂ (U+0057 U+00C2)
  0x00, 0x57, 0x00, 0xC3, 0x01, // WÃ (U+0057 U+00C3)
  0x00, 0x57, 0x00, 0xC4, 0x01, // WÄ (U+0057 U+00C4)
  0x00, 0x57, 0x00, 0xC5, 0x01, // WÅ (U+0057 U+00C5)
  0x00, 0x57, 0x00, 0xC6, 0x01, // WÆ (U+0057 U+00C6)
  0x00, 0x57, 0x00, 0xE0, 0x01, // Wà (U+0057 U+00E0)
  0x00, 0x57, 0x00, 0xE1, 0x01, // Wá (U+0057 U+00E1)
  0x00, 0x57, 0x00, 0xE2, 0x01, // Wâ (U+0057 U+00E2)
  0x00, 0x57, 0x00, 0xE3, 0x01, // Wã (U+0057 U+00E3)
  0x00, 0x57, 0x00, 0xE4, 0x01, // Wä (U+0057 U+00E4)
  0x00, 0x57, 0x00, 0xE5, 0x01, // Wå (U+0057 U+00E5)
  0x00, 0x57, 0x00, 0xE6, 0x01, // Wæ (U+0057 U+00E6)
  0x00, 0x57, 0x00, 0xE7, 0x01, // Wç (U+0057 U+00E7)
  0x00, 0x57, 0x00, 0xE8, 0x01, // Wè (U+0057 U+00E8)
  0x00, 0x57, 0x00, 0xE9, 0x01, // Wé (U+0057 U+00E9)
  0x00, 0x57, 0x00, 0xEA, 0x01, // Wê (U+0057 U+00EA)
  0x00, 0x57, 0x00, 0xEB, 0x01, // Wë (U+0057 U+00EB)
  0x00, 0x57, 0x00, 0xF0, 0x01, // Wð (U+0057 U+00F0)
  0x00, 0x57, 0x00, 0xF2, 0x01, // Wò (U+0057 U+00F2)
  0x00, 0x57, 0x00, 0xF3, 0x01, // Wó (U+0057 U+00F3)
  0x00, 0x57, 0x00, 0xF4, 0x01, // Wô (U+0057 U+00F4)
  0x00, 0x57, 0x00, 0xF5, 0x01, // Wõ (U+0057 U+00F5)
  0x00, 0x57, 0x00, 0xF6, 0x01, // Wö (U+0057 U+00F6)
  0x00, 0x57, 0x00, 0xF8, 0x01, // Wø (U+0057 U+00F8)
  0x00, 0x57, 0x01, 0x00, 0x01, // WĀ (U+0057 U+0100)
  0x00, 0x57, 0x01, 0x01, 0x01, // Wā (U+0057 U+0101)
  0x00, 0x57, 0x01, 0x02, 0x01, // WĂ (U+0057 U+0102)
  0x00, 0x57, 0x01, 0x03, 0x01, // Wă (U+0057 U+0103)
  0x00, 0x57, 0x01, 0x04, 0x01, // WĄ (U+0057 U+0104)
  0x00, 0x57, 0x01, 0x05, 0x01, // Wą (U+0057 U+0105)
  0x00, 0x57, 0x01, 0x07, 0x01, // Wć (U+0057 U+0107)
  0x00, 0x57, 0x01, 0x09, 0x01, // Wĉ (U+0057 U+0109)
  0x00, 0x57, 0x01, 0x0B, 0x01, // Wċ (U+0057 U+010B)
  0x00, 0x57, 0x01, 0x0D, 0x01, // Wč (U+0057 U+010D)
  0x00, 0x57, 0x01, 0x0F, 0x01, // Wď (U+0057 U+010F)
  0x00, 0x57, 0x01, 0x11, 0x01, // Wđ (U+0057 U+0111)
  0x00, 0x57, 0x01, 0x13, 0x01, // Wē (U+0057 U+0113)
  0x00, 0x57, 0x01, 0x15, 0x01, // Wĕ (U+0057 U+0115)
  0x00, 0x57, 0x01, 0x17, 0x01, // Wė (U+0057 U+0117)
  0x00, 0x57, 0x01, 0x19, 0x01, // Wę (U+0057 U+0119)
  0x00, 0x57, 0x01, 0x1B, 0x01, // Wě (U+0057 U+011B)
  0x00, 0x57, 0x01, 0x1D, 0x01, // Wĝ (U+0057 U+011D)
  0x00, 0x57, 0x01, 0x1F, 0x01, // Wğ (U+0057 U+011F)
  0x00, 0x57, 0x01, 0x21, 0x01, // Wġ (U+0057 U+0121)
  0x00, 0x57, 0x01, 0x23, 0x01, // Wģ (U+0057 U+0123)
  0x00, 0x57, 0x01, 0x4D, 0x01, // Wō (U+0057 U+014D)
  0x00, 0x57, 0x01, 0x4F, 0x01, // Wŏ (U+0057 U+014F)
  0x00, 0x57, 0x01, 0x51, 0x01, // Wő (U+0057 U+0151)
  0x00, 0x57, 0x01, 0x53, 0x01, // Wœ (U+0057 U+0153)
  0x00, 0x57, 0x01, 0x5B, 0x01, // Wś (U+0057 U+015B)
  0x00, 0x57, 0x01, 0x5D, 0x01, // Wŝ (U+0057 U+015D)
  0x00, 0x57, 0x01, 0x5F, 0x01, // Wş (U+0057 U+015F)
  0x00, 0x57, 0x01, 0x61, 0x01, // Wš (U+0057 U+0161)
  0x00, 0x57, 0x20, 0x1A, 0x01, // W‚ (U+0057 U+201A)
  0x00, 0x57, 0x20, 0x1E, 0x01, // W„ (U+0057 U+201E)
  0x00, 0x57, 0x20, 0x26, 0x01, // W… (U+0057 U+2026)
  0x00, 0x58, 0x00, 0x79, 0x01, // Xy (U+0058 U+0079)
  0x00, 0x58, 0x00, 0xFD, 0x01, // Xý (U+0058 U+00FD)
  0x00, 0x58, 0x00, 0xFF, 0x01, // Xÿ (U+0058 U+00FF)
  0x00, 0x58, 0x01, 0x77, 0x01, // Xŷ (U+0058 U+0177)
  0x00, 0x59, 0x00, 0x2C, 0x01, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x01, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x00, 0x41, 0x01, // YA (U+0059 U+0041)
  0x00, 0x59, 0x00, 0x61, 0x01, // Ya (U+0059 U+0061)
  0x00, 0x59, 0x00, 0x63, 0x01, // Yc (U+0059 U+0063)
  0x00, 0x59, 0x00, 0x64, 0x01, // Yd (U+0059 U+0064)
  0x00, 0x59, 0x00, 0x65, 0x01, // Ye (U+0059 U+0065)
  0x00, 0x59, 0x00, 0x67, 0x01, // Yg (U+0059 U+0067)
  0x00, 0x59, 0x00, 0x6F, 0x01, // Yo (U+0059 U+006F)
  0x00, 0x59, 0x00, 0x71, 0x01, // Yq (U+0059 U+0071)
  0x00, 0x59, 0x00, 0x73, 0x01, // Ys (U+0059 U+0073)
  0x00, 0x59, 0x00, 0xC0, 0x01, // YÀ (U+0059 U+00C0)
  0x00, 0x59, 0x00, 0xC1, 0x01, // YÁ (U+0059 U+00C1)
  0x00, 0x59, 0x00, 0xC2, 0x01, // YÂ (U+0059 U+00C2)
  0x00, 0x59, 0x00, 0xC3, 0x01, // YÃ (U+0059 U+00C3)
  0x00, 0x59, 0x00, 0xC4, 0x01, // YÄ (U+0059 U+00C4)
  0x00, 0x59, 0x00, 0xC5, 0x01, // YÅ (U+0059 U+00C5)
  0x00, 0x59, 0x00, 0xC6, 0x01, // YÆ (U+0059 U+00C6)
  0x00, 0x59, 0x00, 0xE0, 0x01, // Yà (U+0059 U+00E0)
  0x00, 0x59, 0x00, 0xE1, 0x01, // Yá (U+0059 U+00E1)
  0x00, 0x59, 0x00, 0xE2, 0x01, // Yâ (U+0059 U+00E2)
  0x00, 0x59, 0x00, 0xE3, 0x01, // Yã (U+0059 U+00E3)
  0x00, 0x59, 0x00, 0xE4, 0x01, // Yä (U+0059 U+00E4)
  0x00, 0x59, 0x00, 0xE5, 0x01, // Yå (U+0059 U+00E5)
  0x00, 0x59, 0x00, 0xE6, 0x01, // Yæ (U+0059 U+00E6)
  0x00, 0x59, 0x00, 0xE7, 0x01, // Yç (U+0059 U+00E7)
  0x00, 0x59, 0x00, 0xE8, 0x01, // Yè (U+0059 U+00E8)
  0x00, 0x59, 0x00, 0xE9, 0x01, // Yé (U+0059 U+00E9)
  0x00, 0x59, 0x00, 0xEA, 0x01, // Yê (U+0059 U+00EA)
  0x00, 0x59, 0x00, 0xEB, 0x01, // Yë (U+0059 U+00EB)
  0x00, 0x59, 0x00, 0xF0, 0x01, // Yð (U+0059 U+00F0)
  0x00, 0x59, 0x00, 0xF2, 0x01, // Yò (U+0059 U+00F2)
  0x00, 0x59, 0x00, 0xF3, 0x01, // Yó (U+0059 U+00F3)
  0x00, 0x59, 0x00, 0xF4, 0x01, // Yô (U+0059 U+00F4)
  0x00, 0x59, 0x00, 0xF5, 0x01, // Yõ (U+0059 U+00F5)
  0x00, 0x59, 0x00, 0xF6, 0x01, // Yö (U+0059 U+00F6)
  0x00, 0x59, 0x00, 0xF8, 0x01, // Yø (U+0059 U+00F8)
  0x00, 0x59, 0x01, 0x00, 0x01, // YĀ (U+0059 U+0100)
  0x00, 0x59, 0x01, 0x01, 0x01, // Yā (U+0059 U+0101)
  0x00, 0x59, 0x01, 0x02, 0x01, // YĂ (U+0059 U+0102)
  0x00, 0x59, 0x01, 0x03, 0x01, // Yă (U+0059 U+0103)
  0x00, 0x59, 0x01, 0x04, 0x01, // YĄ (U+0059 U+0104)
  0x00, 0x59, 0x01, 0x05, 0x01, // Yą (U+0059 U+0105)
  0x00, 0x59, 0x01, 0x07, 0x01, // Yć (U+0059 U+0107)
  0x00, 0x59, 0x01, 0x09, 0x01, // Yĉ (U+0059 U+0109)
  0x00, 0x59, 0x01, 0x0B, 0x01, // Yċ (U+0059 U+010B)
  0x00, 0x59, 0x01, 0x0D, 0x01, // Yč (U+0059 U+010D)
  0x00, 0x59, 0x01, 0x0F, 0x01, // Yď (U+0059 U+010F)
  0x00, 0x59, 0x01, 0x11, 0x01, // Yđ (U+0059 U+0111)
  0x00, 0x59, 0x01, 0x13, 0x01, // Yē (U+0059 U+0113)
  0x00, 0x59, 0x01, 0x15, 0x01, // Yĕ (U+0059 U+0115)
  0x00, 0x59, 0x01, 0x17, 0x01, // Yė (U+0059 U+0117)
  0x00, 0x59, 0x01, 0x19, 0x01, // Yę (U+0059 U+0119)
  0x00, 0x59, 0x01, 0x1B, 0x01, // Yě (U+0059 U+011B)
  0x00, 0x59, 0x01, 0x1D, 0x01, // Yĝ (U+0059 U+011D)
  0x00, 0x59, 0x01, 0x1F, 0x01, // Yğ (U+0059 U+011F)
  0x00, 0x59, 0x01, 0x21, 0x01, // Yġ (U+0059 U+0121)
  0x00, 0x59, 0x01, 0x23, 0x01, // Yģ (U+0059 U+0123)
  0x00, 0x59, 0x01, 0x4D, 0x01, // Yō (U+0059 U+014D)
  0x00, 0x59, 0x01, 0x4F, 0x01, // Yŏ (U+0059 U+014F)
  0x00, 0x59, 0x01, 0x51, 0x01, // Yő (U+0059 U+0151)
  0x00, 0x59, 0x01, 0x53, 0x01, // Yœ (U+0059 U+0153)
  0x00, 0x59, 0x01, 0x5B, 0x01, // Yś (U+0059 U+015B)
  0x00, 0x59, 0x01, 0x5D, 0x01, // Yŝ (U+0059 U+015D)
  0x00, 0x59, 0x01, 0x5F, 0x01, // Yş (U+0059 U+015F)
  0x00, 0x59, 0x01, 0x61, 0x01, // Yš (U+0059 U+0161)
  0x00, 0x59, 0x20, 0x1A, 0x01, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x01, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x01, // Y… (U+0059 U+2026)
  0x00, 0x62, 0x00, 0x56, 0x01, // bV (U+0062 U+0056)
  0x00, 0x62, 0x00, 0x57, 0x01, // bW (U+0062 U+0057)
  0x00, 0x62, 0x00, 0x59, 0x01, // bY (U+0062 U+0059)
  0x00, 0x62, 0x00, 0xDD, 0x01, // bÝ (U+0062 U+00DD)
  0x00, 0x62, 0x01, 0x74, 0x01, // bŴ (U+0062 U+0174)
  0x00, 0x62, 0x01, 0x76, 0x01, // bŶ (U+0062 U+0176)
  0x00, 0x62, 0x01, 0x78, 0x01, // bŸ (U+0062 U+0178)
  0x00, 0x65, 0x00, 0x56, 0x01, // eV (U+0065 U+0056)
  0x00, 0x65, 0x00, 0x57, 0x01, // eW (U+0065 U+0057)
  0x00, 0x65, 0x00, 0x59, 0x01, // eY (U+0065 U+0059)
  0x00, 0x65, 0x00, 0xDD, 0x01, // eÝ (U+0065 U+00DD)
  0x00, 0x65, 0x01, 0x74, 0x01, // eŴ (U+0065 U+0174)
  0x00, 0x65, 0x01, 0x76, 0x01, // eŶ (U+0065 U+0176)
  0x00, 0x65, 0x01, 0x78, 0x01, // eŸ (U+0065 U+0178)
  0x00, 0x6F, 0x00, 0x56, 0x01, // oV (U+006F U+0056)
  0x00, 0x6F, 0x00, 0x57, 0x01, // oW (U+006F U+0057)
  0x00, 0x6F, 0x00, 0x59, 0x01, // oY (U+006F U+0059)
  0x00, 0x6F, 0x00, 0xDD, 0x01, // oÝ (U+006F U+00DD)
  0x00, 0x6F, 0x01, 0x74, 0x01, // oŴ (U+006F U+0174)
  0x00, 0x6F, 0x01, 0x76, 0x01, // oŶ (U+006F U+0176)
  0x00, 0x6F, 0x01, 0x78, 0x01, // oŸ (U+006F U+0178)
  0x00, 0x70, 0x00, 0x56, 0x01, // pV (U+0070 U+0056)
  0x00, 0x70, 0x00, 0x57, 0x01, // pW (U+0070 U+0057)
  0x00, 0x70, 0x00, 0x59, 0x01, // pY (U+0070 U+0059)
  0x00, 0x70, 0x00, 0xDD, 0x01, // pÝ (U+0070 U+00DD)
  0x00, 0x70, 0x01, 0x74, 0x01, // pŴ (U+0070 U+0174)
  0x00, 0x70, 0x01, 0x76, 0x01, // pŶ (U+0070 U+0176)
  0x00, 0x70, 0x01, 0x78, 0x01, // pŸ (U+0070 U+0178)
  0x00, 0x72, 0x00, 0x2C, 0x01, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x01, // r. (U+0072 U+002E)
  0x00, 0x72, 0x20, 0x1A, 0x01, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x01, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x01, // r… (U+0072 U+2026)
  0x00, 0x73, 0x00, 0x59, 0x01, // sY (U+0073 U+0059)
  0x00, 0x73, 0x00, 0xDD, 0x01, // sÝ (U+0073 U+00DD)
  0x00, 0x73, 0x01, 0x76, 0x01, // sŶ (U+0073 U+0176)
  0x00, 0x73, 0x01, 0x78, 0x01, // sŸ (U+0073 U+0178)
  0x00, 0x76, 0x00, 0x2C, 0x01, // v, (U+0076 U+002C)
  0x00, 0x76, 0x00, 0x2E, 0x01, // v. (U+0076 U+002E)
  0x00, 0x76, 0x00, 0x41, 0x01, // vA (U+0076 U+0041)
  0x00, 0x76, 0x00, 0xC0, 0x01, // vÀ (U+0076 U+00C0)
  0x00, 0x76, 0x00, 0xC1, 0x01, // vÁ (U+0076 U+00C1)
  0x00, 0x76, 0x00, 0xC2, 0x01, // vÂ (U+0076 U+00C2)
  0x00, 0x76, 0x00, 0xC3, 0x01, // vÃ (U+0076 U+00C3)
  0x00, 0x76, 0x00, 0xC4, 0x01, // vÄ (U+0076 U+00C4)
  0x00, 0x76, 0x00, 0xC5, 0x01, // vÅ (U+0076 U+00C5)
  0x00, 0x76, 0x01, 0x00, 0x01, // vĀ (U+0076 U+0100)
  0x00, 0x76, 0x01, 0x02, 0x01, // vĂ (U+0076 U+0102)
  0x00, 0x76, 0x01, 0x04, 0x01, // vĄ (U+0076 U+0104)
  0x00, 0x76, 0x20, 0x1A, 0x01, // v‚ (U+0076 U+201A)
  0x00, 0x76, 0x20, 0x1E, 0x01, // v„ (U+0076 U+201E)
  0x00, 0x76, 0x20, 0x26, 0x01, // v… (U+0076 U+2026)
  0x00, 0x77, 0x00, 0x2C, 0x01, // w, (U+0077 U+002C)
  0x00, 0x77, 0x00, 0x2E, 0x01, // w. (U+0077 U+002E)
  0x00, 0x77, 0x20, 0x1A, 0x01, // w‚ (U+0077 U+201A)
  0x00, 0x77, 0x20, 0x1E, 0x01, // w„ (U+0077 U+201E)
  0x00, 0x77, 0x20, 0x26, 0x01, // w… (U+0077 U+2026)
  0x00, 0x79, 0x00, 0x2C, 0x01, // y, (U+0079 U+002C)
  0x00, 0x79, 0x00, 0x2E, 0x01, // y. (U+0079 U+002E)
  0x00, 0x79, 0x00, 0x41, 0x01, // yA (U+0079 U+0041)
  0x00, 0x79, 0x00, 0xC0, 0x01, // yÀ (U+0079 U+00C0)
  0x00, 0x79, 0x00, 0xC1, 0x01, // yÁ (U+0079 U+00C1)
  0x00, 0x79, 0x00, 0xC2, 0x01, // yÂ (U+0079 U+00C2)
  0x00, 0x79, 0x00, 0xC3, 0x01, // yÃ (U+0079 U+00C3)
  0x00, 0x79, 0x00, 0xC4, 0x01, // yÄ (U+0079 U+00C4)
  0x00, 0x79, 0x00, 0xC5, 0x01, // yÅ (U+0079 U+00C5)
  0x00, 0x79, 0x01, 0x00, 0x01, // yĀ (U+0079 U+0100)
  0x00, 0x79, 0x01, 0x02, 0x01, // yĂ (U+0079 U+0102)
  0x00, 0x79, 0x01, 0x04, 0x01, // yĄ (U+0079 U+0104)
  0x00, 0x79, 0x20, 0x1A, 0x01, // y‚ (U+0079 U+201A)
  0x00, 0x79, 0x20, 0x1E, 0x01, // y„ (U+0079 U+201E)
  0x00, 0x79, 0x20, 0x26, 0x01, // y… (U+0079 U+2026)
  0x00, 0xBF, 0x00, 0x56, 0x01, // ¿V (U+00BF U+0056)
  0x00, 0xBF, 0x00, 0x57, 0x01, // ¿W (U+00BF U+0057)
  0x00, 0xBF, 0x00, 0x59, 0x01, // ¿Y (U+00BF U+0059)
  0x00, 0xBF, 0x00, 0xDD, 0x01, // ¿Ý (U+00BF U+00DD)
  0x00, 0xBF, 0x01, 0x74, 0x01, // ¿Ŵ (U+00BF U+0174)
  0x00, 0xBF, 0x01, 0x76, 0x01, // ¿Ŷ (U+00BF U+0176)
  0x00, 0xBF, 0x01, 0x78, 0x01, // ¿Ÿ (U+00BF U+0178)
  0x00, 0xC0, 0x00, 0x22, 0x01, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x01, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x00, 0x2A, 0x01, // À* (U+00C0 U+002A)
  0x00, 0xC0, 0x00, 0x3F, 0x01, // À? (U+00C0 U+003F)
  0x00, 0xC0, 0x00, 0x54, 0x01, // ÀT (U+00C0 U+0054)
  0x00, 0xC0, 0x00, 0x56, 0x01, // ÀV (U+00C0 U+0056)
  0x00, 0xC0, 0x00, 0x57, 0x01, // ÀW (U+00C0 U+0057)
  0x00, 0xC0, 0x00, 0x59, 0x01, // ÀY (U+00C0 U+0059)
  0x00, 0xC0, 0x00, 0x76, 0x01, // Àv (U+00C0 U+0076)
  0x00, 0xC0, 0x00, 0x79, 0x01, // Ày (U+00C0 U+0079)
  0x00, 0xC0, 0x00, 0xDD, 0x01, // ÀÝ (U+00C0 U+00DD)
  0x00, 0xC0, 0x00, 0xFD, 0x01, // Àý (U+00C0 U+00FD)
  0x00, 0xC0, 0x00, 0xFF, 0x01, // Àÿ (U+00C0 U+00FF)
  0x00, 0xC0, 0x01, 0x62, 0x01, // ÀŢ (U+00C0 U+0162)
  0x00, 0xC0, 0x01, 0x64, 0x01, // ÀŤ (U+00C0 U+0164)
  0x00, 0xC0, 0x01, 0x66, 0x01, // ÀŦ (U+00C0 U+0166)
  0x00, 0xC0, 0x01, 0x74, 0x01, // ÀŴ (U+00C0 U+0174)
  0x00, 0xC0, 0x01, 0x76, 0x01, // ÀŶ (U+00C0 U+0176)
  0x00, 0xC0, 0x01, 0x77, 0x01, // Àŷ (U+00C0 U+0177)
  0x00, 0xC0, 0x01, 0x78, 0x01, // ÀŸ (U+00C0 U+0178)
  0x00, 0xC0, 0x20, 0x18, 0x01, // À‘ (U+00C0 U+2018)
  0x00, 0xC0, 0x20, 0x19, 0x01, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1C, 0x01, // À“ (U+00C0 U+201C)
  0x00, 0xC0, 0x20, 0x1D, 0x01, // À” (U+00C0 U+201D)
  0x00, 0xC0, 0x21, 0x22, 0x01, // À™ (U+00C0 U+2122)
  0x00, 0xC1, 0x00, 0x22, 0x01, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x01, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x00, 0x2A, 0x01, // Á* (U+00C1 U+002A)
  0x00, 0xC1, 0x00, 0x3F, 0x01, // Á? (U+00C1 U+003F)
  0x00, 0xC1, 0x00, 0x54, 0x01, // ÁT (U+00C1 U+0054)
  0x00, 0xC1, 0x00, 0x56, 0x01, // ÁV (U+00C1 U+0056)
  0x00, 0xC1, 0x00, 0x57, 0x01, // ÁW (U+00C1 U+0057)
  0x00, 0xC1, 0x00, 0x59, 0x01, // ÁY (U+00C1 U+0059)
  0x00, 0xC1, 0x00, 0x76, 0x01, // Áv (U+00C1 U+0076)
  0x00, 0xC1, 0x00, 0x79, 0x01, // Áy (U+00C1 U+0079)
  0x00, 0xC1, 0x00, 0xDD, 0x01, // ÁÝ (U+00C1 U+00DD)
  0x00, 0xC1, 0x00, 0xFD, 0x01, // Áý (U+00C1 U+00FD)
  0x00, 0xC1, 0x00, 0xFF, 0x01, // Áÿ (U+00C1 U+00FF)
  0x00, 0xC1, 0x01, 0x62, 0x01, // ÁŢ (U+00C1 U+0162)
  0x00, 0xC1, 0x01, 0x64, 0x01, // ÁŤ (U+00C1 U+0164)
  0x00, 0xC1, 0x01, 0x66, 0x01, // ÁŦ (U+00C1 U+0166)
  0x00, 0xC1, 0x01, 0x74, 0x01, // ÁŴ (U+00C1 U+0174)
  0x00, 0xC1, 0x01, 0x76, 0x01, // ÁŶ (U+00C1 U+0176)
  0x00, 0xC1, 0x01, 0x77, 0x01, // Áŷ (U+00C1 U+0177)
  0x00, 0xC1, 0x01, 0x78, 0x01, // ÁŸ (U+00C1 U+0178)
  0x00, 0xC1, 0x20, 0x18, 0x01, // Á‘ (U+00C1 U+2018)
  0x00, 0xC1, 0x20, 0x19, 0x01, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1C, 0x01, // Á“ (U+00C1 U+201C)
  0x00, 0xC1, 0x20, 0x1D, 0x01, // Á” (U+00C1 U+201D)
  0x00, 0xC1, 0x21, 0x22, 0x01, // Á™ (U+00C1 U+2122)
  0x00, 0xC2, 0x00, 0x22, 0x01, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x01, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x00, 0x2A, 0x01, // Â* (U+00C2 U+002A)
  0x00, 0xC2, 0x00, 0x3F, 0x01, // Â? (U+00C2 U+003F)
  0x00, 0xC2, 0x00, 0x54, 0x01, // ÂT (U+00C2 U+0054)
  0x00, 0xC2, 0x00, 0x56, 0x01, // ÂV (U+00C2 U+0056)
  0x00, 0xC2, 0x00, 0x57, 0x01, // ÂW (U+00C2 U+0057)
  0x00, 0xC2, 0x00, 0x59, 0x01, // ÂY (U+00C2 U+0059)
  0x00, 0xC2, 0x00, 0x76, 0x01, // Âv (U+00C2 U+0076)
  0x00, 0xC2, 0x00, 0x79, 0x01, // Ây (U+00C2 U+0079)
  0x00, 0xC2, 0x00, 0xDD, 0x01, // ÂÝ (U+00C2 U+00DD)
  0x00, 0xC2, 0x00, 0xFD, 0x01, // Âý (U+00C2 U+00FD)
  0x00, 0xC2, 0x00, 0xFF, 0x01, // Âÿ (U+00C2 U+00FF)
  0x00, 0xC2, 0x01, 0x62, 0x01, // ÂŢ (U+00C2 U+0162)
  0x00, 0xC2, 0x01, 0x64, 0x01, // ÂŤ (U+00C2 U+0164)
  0x00, 0xC2, 0x01, 0x66, 0x01, // ÂŦ (U+00C2 U+0166)
  0x00, 0xC2, 0x01, 0x74, 0x01, // ÂŴ (U+00C2 U+0174)
  0x00, 0xC2, 0x01, 0x76, 0x01, // ÂŶ (U+00C2 U+0176)
  0x00, 0xC2, 0x01, 0x77, 0x01, // Âŷ (U+00C2 U+0177)
  0x00, 0xC2, 0x01, 0x78, 0x01, // ÂŸ (U+00C2 U+0178)
  0x00, 0xC2, 0x20, 0x18, 0x01, // Â‘ (U+00C2 U+2018)
  0x00, 0xC2, 0x20, 0x19, 0x01, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1C, 0x01, // Â“ (U+00C2 U+201C)
  0x00, 0xC2, 0x20, 0x1D, 0x01, // Â” (U+00C2 U+201D)
  0x00, 0xC2, 0x21, 0x22, 0x01, // Â™ (U+00C2 U+2122)
  0x00, 0xC3, 0x00, 0x22, 0x01, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x01, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x00, 0x2A, 0x01, // Ã* (U+00C3 U+002A)
  0x00, 0xC3, 0x00, 0x3F, 0x01, // Ã? (U+00C3 U+003F)
  0x00, 0xC3, 0x00, 0x54, 0x01, // ÃT (U+00C3 U+0054)
  0x00, 0xC3, 0x00, 0x56, 0x01, // ÃV (U+00C3 U+0056)
  0x00, 0xC3, 0x00, 0x57, 0x01, // ÃW (U+00C3 U+0057)
  0x00, 0xC3, 0x00, 0x59, 0x01, // ÃY (U+00C3 U+0059)
  0x00, 0xC3, 0x00, 0x76, 0x01, // Ãv (U+00C3 U+0076)
  0x00, 0xC3, 0x00, 0x79, 0x01, // Ãy (U+00C3 U+0079)
  0x00, 0xC3, 0x00, 0xDD, 0x01, // ÃÝ (U+00C3 U+00DD)
  0x00, 0xC3, 0x00, 0xFD, 0x01, // Ãý (U+00C3 U+00FD)
  0x00, 0xC3, 0x00, 0xFF, 0x01, // Ãÿ (U+00C3 U+00FF)
  0x00, 0xC3, 0x01, 0x62, 0x01, // ÃŢ (U+00C3 U+0162)
  0x00, 0xC3, 0x01, 0x64, 0x01, // ÃŤ (U+00C3 U+0164)
  0x00, 0xC3, 0x01, 0x66, 0x01, // ÃŦ (U+00C3 U+0166)
  0x00, 0xC3, 0x01, 0x74, 0x01, // ÃŴ (U+00C3 U+0174)
  0x00, 0xC3, 0x01, 0x76, 0x01, // ÃŶ (U+00C3 U+0176)
  0x00, 0xC3, 0x01, 0x77, 0x01, // Ãŷ (U+00C3 U+0177)
  0x00, 0xC3, 0x01, 0x78, 0x01, // ÃŸ (U+00C3 U+0178)
  0x00, 0xC3, 0x20, 0x18, 0x01, // Ã‘ (U+00C3 U+2018)
  0x00, 0xC3, 0x20, 0x19, 0x01, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1C, 0x01, // Ã“ (U+00C3 U+201C)
  0x00, 0xC3, 0x20, 0x1D, 0x01, // Ã” (U+00C3 U+201D)
  0x00, 0xC3, 0x21, 0x22, 0x01, // Ã™ (U+00C3 U+2122)
  0x00, 0xC4, 0x00, 0x22, 0x01, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x01, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x00, 0x2A, 0x01, // Ä* (U+00C4 U+002A)
  0x00, 0xC4, 0x00, 0x3F, 0x01, // Ä? (U+00C4 U+003F)
  0x00, 0xC4, 0x00, 0x54, 0x01, // ÄT (U+00C4 U+0054)
  0x00, 0xC4, 0x00, 0x56, 0x01, // ÄV (U+00C4 U+0056)
  0x00, 0xC4, 0x00, 0x57, 0x01, // ÄW (U+00C4 U+0057)
  0x00, 0xC4, 0x00, 0x59, 0x01, // ÄY (U+00C4 U+0059)
  0x00, 0xC4, 0x00, 0x76, 0x01, // Äv (U+00C4 U+0076)
  0x00, 0xC4, 0x00, 0x79, 0x01, // Äy (U+00C4 U+0079)
  0x00, 0xC4, 0x00, 0xDD, 0x01, // ÄÝ (U+00C4 U+00DD)
  0x00, 0xC4, 0x00, 0xFD, 0x01, // Äý (U+00C4 U+00FD)
  0x00, 0xC4, 0x00, 0xFF, 0x01, // Äÿ (U+00C4 U+00FF)
  0x00, 0xC4, 0x01, 0x62, 0x01, // ÄŢ (U+00C4 U+0162)
  0x00, 0xC4, 0x01, 0x64, 0x01, // ÄŤ (U+00C4 U+0164)
  0x00, 0xC4, 0x01, 0x66, 0x01, // ÄŦ (U+00C4 U+0166)
  0x00, 0xC4, 0x01, 0x74, 0x01, // ÄŴ (U+00C4 U+0174)
  0x00, 0xC4, 0x01, 0x76, 0x01, // ÄŶ (U+00C4 U+0176)
  0x00, 0xC4, 0x01, 0x77, 0x01, // Äŷ (U+00C4 U+0177)
  0x00, 0xC4, 0x01, 0x78, 0x01, // ÄŸ (U+00C4 U+0178)
  0x00, 0xC4, 0x20, 0x18, 0x01, // Ä‘ (U+00C4 U+2018)
  0x00, 0xC4, 0x20, 0x19, 0x01, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1C, 0x01, // Ä“ (U+00C4 U+201C)
  0x00, 0xC4, 0x20, 0x1D, 0x01, // Ä” (U+00C4 U+201D)
  0x00, 0xC4, 0x21, 0x22, 0x01, // Ä™ (U+00C4 U+2122)
  0x00, 0xC5, 0x00, 0x22, 0x01, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x01, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x00, 0x2A, 0x01, // Å* (U+00C5 U+002A)
  0x00, 0xC5, 0x00, 0x3F, 0x01, // Å? (U+00C5 U+003F)
  0x00, 0xC5, 0x00, 0x54, 0x01, // ÅT (U+00C5 U+0054)
  0x00, 0xC5, 0x00, 0x56, 0x01, // ÅV (U+00C5 U+0056)
  0x00, 0xC5, 0x00, 0x57, 0x01, // ÅW (U+00C5 U+0057)
  0x00, 0xC5, 0x00, 0x59, 0x01, // ÅY (U+00C5 U+0059)
  0x00, 0xC5, 0x00, 0x76, 0x01, // Åv (U+00C5 U+0076)
  0x00, 0xC5, 0x00, 0x79, 0x01, // Åy (U+00C5 U+0079)
  0x00, 0xC5, 0x00, 0xDD, 0x01, // ÅÝ (U+00C5 U+00DD)
  0x00, 0xC5, 0x00, 0xFD, 0x01, // Åý (U+00C5 U+00FD)
  0x00, 0xC5, 0x00, 0xFF, 0x01, // Åÿ (U+00C5 U+00FF)
  0x00, 0xC5, 0x01, 0x62, 0x01, // ÅŢ (U+00C5 U+0162)
  0x00, 0xC5, 0x01, 0x64, 0x01, // ÅŤ (U+00C5 U+0164)
  0x00, 0xC5, 0x01, 0x66, 0x01, // ÅŦ (U+00C5 U+0166)
  0x00, 0xC5, 0x01, 0x74, 0x01, // ÅŴ (U+00C5 U+0174)
  0x00, 0xC5, 0x01, 0x76, 0x01, // ÅŶ (U+00C5 U+0176)
  0x00, 0xC5, 0x01, 0x77, 0x01, // Åŷ (U+00C5 U+0177)
  0x00, 0xC5, 0x01, 0x78, 0x01, // ÅŸ (U+00C5 U+0178)
  0x00, 0xC5, 0x20, 0x18, 0x01, // Å‘ (U+00C5 U+2018)
  0x00, 0xC5, 0x20, 0x19, 0x01, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1C, 0x01, // Å“ (U+00C5 U+201C)
  0x00, 0xC5, 0x20, 0x1D, 0x01, // Å” (U+00C5 U+201D)
  0x00, 0xC5, 0x21, 0x22, 0x01, // Å™ (U+00C5 U+2122)
  0x00, 0xD0, 0x00, 0xC6, 0x01, // ÐÆ (U+00D0 U+00C6)
  0x00, 0xD2, 0x00, 0xC6, 0x01, // ÒÆ (U+00D2 U+00C6)
  0x00, 0xD3, 0x00, 0xC6, 0x01, // ÓÆ (U+00D3 U+00C6)
  0x00, 0xD4, 0x00, 0xC6, 0x01, // ÔÆ (U+00D4 U+00C6)
  0x00, 0xD5, 0x00, 0xC6, 0x01, // ÕÆ (U+00D5 U+00C6)
  0x00, 0xD6, 0x00, 0xC6, 0x01, // ÖÆ (U+00D6 U+00C6)
  0x00, 0xD8, 0x00, 0xC6, 0x01, // ØÆ (U+00D8 U+00C6)
  0x00, 0xDD, 0x00, 0x2C, 0x01, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x01, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x00, 0x41, 0x01, // ÝA (U+00DD U+0041)
  0x00, 0xDD, 0x00, 0x61, 0x01, // Ýa (U+00DD U+0061)
  0x00, 0xDD, 0x00, 0x63, 0x01, // Ýc (U+00DD U+0063)
  0x00, 0xDD, 0x00, 0x64, 0x01, // Ýd (U+00DD U+0064)
  0x00, 0xDD, 0x00, 0x65, 0x01, // Ýe (U+00DD U+0065)
  0x00, 0xDD, 0x00, 0x67, 0x01, // Ýg (U+00DD U+0067)
  0x00, 0xDD, 0x00, 0x6F, 0x01, // Ýo (U+00DD U+006F)
  0x00, 0xDD, 0x00, 0x71, 0x01, // Ýq (U+00DD U+0071)
  0x00, 0xDD, 0x00, 0x73, 0x01, // Ýs (U+00DD U+0073)
  0x00, 0xDD, 0x00, 0xC0, 0x01, // ÝÀ (U+00DD U+00C0)
  0x00, 0xDD, 0x00, 0xC1, 0x01, // ÝÁ (U+00DD U+00C1)
  0x00, 0xDD, 0x00, 0xC2, 0x01, // ÝÂ (U+00DD U+00C2)
  0x00, 0xDD, 0x00, 0xC3, 0x01, // ÝÃ (U+00DD U+00C3)
  0x00, 0xDD, 0x00, 0xC4, 0x01, // ÝÄ (U+00DD U+00C4)
  0x00, 0xDD, 0x00, 0xC5, 0x01, // ÝÅ (U+00DD U+00C5)
  0x00, 0xDD, 0x00, 0xC6, 0x01, // ÝÆ (U+00DD U+00C6)
  0x00, 0xDD, 0x00, 0xE0, 0x01, // Ýà (U+00DD U+00E0)
  0x00, 0xDD, 0x00, 0xE1, 0x01, // Ýá (U+00DD U+00E1)
  0x00, 0xDD, 0x00, 0xE2, 0x01, // Ýâ (U+00DD U+00E2)
  0x00, 0xDD, 0x00, 0xE3, 0x01, // Ýã (U+00DD U+00E3)
  0x00, 0xDD, 0x00, 0xE4, 0x01, // Ýä (U+00DD U+00E4)
  0x00, 0xDD, 0x00, 0xE5, 0x01, // Ýå (U+00DD U+00E5)
  0x00, 0xDD, 0x00, 0xE6, 0x01, // Ýæ (U+00DD U+00E6)
  0x00, 0xDD, 0x00, 0xE7, 0x01, // Ýç (U+00DD U+00E7)
  0x00, 0xDD, 0x00, 0xE8, 0x01, // Ýè (U+00DD U+00E8)
  0x00, 0xDD, 0x00, 0xE9, 0x01, // Ýé (U+00DD U+00E9)
  0x00, 0xDD, 0x00, 0xEA, 0x01, // Ýê (U+00DD U+00EA)
  0x00, 0xDD, 0x00, 0xEB, 0x01, // Ýë (U+00DD U+00EB)
  0x00, 0xDD, 0x00, 0xF0, 0x01, // Ýð (U+00DD U+00F0)
  0x00, 0xDD, 0x00, 0xF2, 0x01, // Ýò (U+00DD U+00F2)
  0x00, 0xDD, 0x00, 0xF3, 0x01, // Ýó (U+00DD U+00F3)
  0x00, 0xDD, 0x00, 0xF4, 0x01, // Ýô (U+00DD U+00F4)
  0x00, 0xDD, 0x00, 0xF5, 0x01, // Ýõ (U+00DD U+00F5)
  0x00, 0xDD, 0x00, 0xF6, 0x01, // Ýö (U+00DD U+00F6)
  0x00, 0xDD, 0x00, 0xF8, 0x01, // Ýø (U+00DD U+00F8)
  0x00, 0xDD, 0x01, 0x00, 0x01, // ÝĀ (U+00DD U+0100)
  0x00, 0xDD, 0x01, 0x01, 0x01, // Ýā (U+00DD U+0101)
  0x00, 0xDD, 0x01, 0x02, 0x01, // ÝĂ (U+00DD U+0102)
  0x00, 0xDD, 0x01, 0x03, 0x01, // Ýă (U+00DD U+0103)
  0x00, 0xDD, 0x01, 0x04, 0x01, // ÝĄ (U+00DD U+0104)
  0x00, 0xDD, 0x01, 0x05, 0x01, // Ýą (U+00DD U+0105)
  0x00, 0xDD, 0x01, 0x07, 0x01, // Ýć (U+00DD U+0107)
  0x00, 0xDD, 0x01, 0x09, 0x01, // Ýĉ (U+00DD U+0109)
  0x00, 0xDD, 0x01, 0x0B, 0x01, // Ýċ (U+00DD U+010B)
  0x00, 0xDD, 0x01, 0x0D, 0x01, // Ýč (U+00DD U+010D)
  0x00, 0xDD, 0x01, 0x0F, 0x01, // Ýď (U+00DD U+010F)
  0x00, 0xDD, 0x01, 0x11, 0x01, // Ýđ (U+00DD U+0111)
  0x00, 0xDD, 0x01, 0x13, 0x01, // Ýē (U+00DD U+0113)
  0x00, 0xDD, 0x01, 0x15, 0x01, // Ýĕ (U+00DD U+0115)
  0x00, 0xDD, 0x01, 0x17, 0x01, // Ýė (U+00DD U+0117)
  0x00, 0xDD, 0x01, 0x19, 0x01, // Ýę (U+00DD U+0119)
  0x00, 0xDD, 0x01, 0x1B, 0x01, // Ýě (U+00DD U+011B)
  0x00, 0xDD, 0x01, 0x1D, 0x01, // Ýĝ (U+00DD U+011D)
  0x00, 0xDD, 0x01, 0x1F, 0x01, // Ýğ (U+00DD U+011F)
  0x00, 0xDD, 0x01, 0x21, 0x01, // Ýġ (U+00DD U+0121)
  0x00, 0xDD, 0x01, 0x23, 0x01, // Ýģ (U+00DD U+0123)
  0x00, 0xDD, 0x01, 0x4D, 0x01, // Ýō (U+00DD U+014D)
  0x00, 0xDD, 0x01, 0x4F, 0x01, // Ýŏ (U+00DD U+014F)
  0x00, 0xDD, 0x01, 0x51, 0x01, // Ýő (U+00DD U+0151)
  0x00, 0xDD, 0x01, 0x53, 0x01, // Ýœ (U+00DD U+0153)
  0x00, 0xDD, 0x01, 0x5B, 0x01, // Ýś (U+00DD U+015B)
  0x00, 0xDD, 0x01, 0x5D, 0x01, // Ýŝ (U+00DD U+015D)
  0x00, 0xDD, 0x01, 0x5F, 0x01, // Ýş (U+00DD U+015F)
  0x00, 0xDD, 0x01, 0x61, 0x01, // Ýš (U+00DD U+0161)
  0x00, 0xDD, 0x20, 0x1A, 0x01, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x01, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x01, // Ý… (U+00DD U+2026)
  0x00, 0xDE, 0x00, 0xC6, 0x01, // ÞÆ (U+00DE U+00C6)
  0x00, 0xDF, 0x00, 0x56, 0x01, // ßV (U+00DF U+0056)
  0x00, 0xDF, 0x00, 0x57, 0x01, // ßW (U+00DF U+0057)
  0x00, 0xDF, 0x00, 0x59, 0x01, // ßY (U+00DF U+0059)
  0x00, 0xDF, 0x00, 0xDD, 0x01, // ßÝ (U+00DF U+00DD)
  0x00, 0xDF, 0x01, 0x74, 0x01, // ßŴ (U+00DF U+0174)
  0x00, 0xDF, 0x01, 0x76, 0x01, // ßŶ (U+00DF U+0176)
  0x00, 0xDF, 0x01, 0x78, 0x01, // ßŸ (U+00DF U+0178)
  0x00, 0xE6, 0x00, 0x56, 0x01, // æV (U+00E6 U+0056)
  0x00, 0xE6, 0x00, 0x57, 0x01, // æW (U+00E6 U+0057)
  0x00, 0xE6, 0x00, 0x59, 0x01, // æY (U+00E6 U+0059)
  0x00, 0xE6, 0x00, 0xDD, 0x01, // æÝ (U+00E6 U+00DD)
  0x00, 0xE6, 0x01, 0x74, 0x01, // æŴ (U+00E6 U+0174)
  0x00, 0xE6, 0x01, 0x76, 0x01, // æŶ (U+00E6 U+0176)
  0x00, 0xE6, 0x01, 0x78, 0x01, // æŸ (U+00E6 U+0178)
  0x00, 0xE8, 0x00, 0x56, 0x01, // èV (U+00E8 U+0056)
  0x00, 0xE8, 0x00, 0x57, 0x01, // èW (U+00E8 U+0057)
  0x00, 0xE8, 0x00, 0x59, 0x01, // èY (U+00E8 U+0059)
  0x00, 0xE8, 0x00, 0xDD, 0x01, // èÝ (U+00E8 U+00DD)
  0x00, 0xE8, 0x01, 0x74, 0x01, // èŴ (U+00E8 U+0174)
  0x00, 0xE8, 0x01, 0x76, 0x01, // èŶ (U+00E8 U+0176)
  0x00, 0xE8, 0x01, 0x78, 0x01, // èŸ (U+00E8 U+0178)
  0x00, 0xE9, 0x00, 0x56, 0x01, // éV (U+00E9 U+0056)
  0x00, 0xE9, 0x00, 0x57, 0x01, // éW (U+00E9 U+0057)
  0x00, 0xE9, 0x00, 0x59, 0x01, // éY (U+00E9 U+0059)
  0x00, 0xE9, 0x00, 0xDD, 0x01, // éÝ (U+00E9 U+00DD)
  0x00, 0xE9, 0x01, 0x74, 0x01, // éŴ (U+00E9 U+0174)
  0x00, 0xE9, 0x01, 0x76, 0x01, // éŶ (U+00E9 U+0176)
  0x00, 0xE9, 0x01, 0x78, 0x01, // éŸ (U+00E9 U+0178)
  0x00, 0xEA, 0x00, 0x56, 0x01, // êV (U+00EA U+0056)
  0x00, 0xEA, 0x00, 0x57, 0x01, // êW (U+00EA U+0057)
  0x00, 0xEA, 0x00, 0x59, 0x01, // êY (U+00EA U+0059)
  0x00, 0xEA, 0x00, 0xDD, 0x01, // êÝ (U+00EA U+00DD)
  0x00, 0xEA, 0x01, 0x74, 0x01, // êŴ (U+00EA U+0174)
  0x00, 0xEA, 0x01, 0x76, 0x01, // êŶ (U+00EA U+0176)
  0x00, 0xEA, 0x01, 0x78, 0x01, // êŸ (U+00EA U+0178)
  0x00, 0xEB, 0x00, 0x56, 0x01, // ëV (U+00EB U+0056)
  0x00, 0xEB, 0x00, 0x57, 0x01, // ëW (U+00EB U+0057)
  0x00, 0xEB, 0x00, 0x59, 0x01, // ëY (U+00EB U+0059)
  0x00, 0xEB, 0x00, 0xDD, 0x01, // ëÝ (U+00EB U+00DD)
  0x00, 0xEB, 0x01, 0x74, 0x01, // ëŴ (U+00EB U+0174)
  0x00, 0xEB, 0x01, 0x76, 0x01, // ëŶ (U+00EB U+0176)
  0x00, 0xEB, 0x01, 0x78, 0x01, // ëŸ (U+00EB U+0178)
  0x00, 0xF0, 0x00, 0x56, 0x01, // ðV (U+00F0 U+0056)
  0x00, 0xF0, 0x00, 0x57, 0x01, // ðW (U+00F0 U+0057)
  0x00, 0xF0, 0x00, 0x59, 0x01, // ðY (U+00F0 U+0059)
  0x00, 0xF0, 0x00, 0xDD, 0x01, // ðÝ (U+00F0 U+00DD)
  0x00, 0xF0, 0x01, 0x74, 0x01, // ðŴ (U+00F0 U+0174)
  0x00, 0xF0, 0x01, 0x76, 0x01, // ðŶ (U+00F0 U+0176)
  0x00, 0xF0, 0x01, 0x78, 0x01, // ðŸ (U+00F0 U+0178)
  0x00, 0xF2, 0x00, 0x56, 0x01, // òV (U+00F2 U+0056)
  0x00, 0xF2, 0x00, 0x57, 0x01, // òW (U+00F2 U+0057)
  0x00, 0xF2, 0x00, 0x59, 0x01, // òY (U+00F2 U+0059)
  0x00, 0xF2, 0x00, 0xDD, 0x01, // òÝ (U+00F2 U+00DD)
  0x00, 0xF2, 0x01, 0x74, 0x01, // òŴ (U+00F2 U+0174)
  0x00, 0xF2, 0x01, 0x76, 0x01, // òŶ (U+00F2 U+0176)
  0x00, 0xF2, 0x01, 0x78, 0x01, // òŸ (U+00F2 U+0178)
  0x00, 0xF3, 0x00, 0x56, 0x01, // óV (U+00F3 U+0056)
  0x00, 0xF3, 0x00, 0x57, 0x01, // óW (U+00F3 U+0057)
  0x00, 0xF3, 0x00, 0x59, 0x01, // óY (U+00F3 U+0059)
  0x00, 0xF3, 0x00, 0xDD, 0x01, // óÝ (U+00F3 U+00DD)
  0x00, 0xF3, 0x01, 0x74, 0x01, // óŴ (U+00F3 U+0174)
  0x00, 0xF3, 0x01, 0x76, 0x01, // óŶ (U+00F3 U+0176)
  0x00, 0xF3, 0x01, 0x78, 0x01, // óŸ (U+00F3 U+0178)
  0x00, 0xF4, 0x00, 0x56, 0x01, // ôV (U+00F4 U+0056)
  0x00, 0xF4, 0x00, 0x57, 0x01, // ôW (U+00F4 U+0057)
  0x00, 0xF4, 0x00, 0x59, 0x01, // ôY (U+00F4 U+0059)
  0x00, 0xF4, 0x00, 0xDD, 0x01, // ôÝ (U+00F4 U+00DD)
  0x00, 0xF4, 0x01, 0x74, 0x01, // ôŴ (U+00F4 U+0174)
  0x00, 0xF4, 0x01, 0x76, 0x01, // ôŶ (U+00F4 U+0176)
  0x00, 0xF4, 0x01, 0x78, 0x01, // ôŸ (U+00F4 U+0178)
  0x00, 0xF5, 0x00, 0x56, 0x01, // õV (U+00F5 U+0056)
  0x00, 0xF5, 0x00, 0x57, 0x01, // õW (U+00F5 U+0057)
  0x00, 0xF5, 0x00, 0x59, 0x01, // õY (U+00F5 U+0059)
  0x00, 0xF5, 0x00, 0xDD, 0x01, // õÝ (U+00F5 U+00DD)
  0x00, 0xF5, 0x01, 0x74, 0x01, // õŴ (U+00F5 U+0174)
  0x00, 0xF5, 0x01, 0x76, 0x01, // õŶ (U+00F5 U+0176)
  0x00, 0xF5, 0x01, 0x78, 0x01, // õŸ (U+00F5 U+0178)
  0x00, 0xF6, 0x00, 0x56, 0x01, // öV (U+00F6 U+0056)
  0x00, 0xF6, 0x00, 0x57, 0x01, // öW (U+00F6 U+0057)
  0x00, 0xF6, 0x00, 0x59, 0x01, // öY (U+00F6 U+0059)
  0x00, 0xF6, 0x00, 0xDD, 0x01, // öÝ (U+00F6 U+00DD)
  0x00, 0xF6, 0x01, 0x74, 0x01, // öŴ (U+00F6 U+0174)
  0x00, 0xF6, 0x01, 0x76, 0x01, // öŶ (U+00F6 U+0176)
  0x00, 0xF6, 0x01, 0x78, 0x01, // öŸ (U+00F6 U+0178)
  0x00, 0xF8, 0x00, 0x56, 0x01, // øV (U+00F8 U+0056)
  0x00, 0xF8, 0x00, 0x57, 0x01, // øW (U+00F8 U+0057)
  0x00, 0xF8, 0x00, 0x59, 0x01, // øY (U+00F8 U+0059)
  0x00, 0xF8, 0x00, 0xDD, 0x01, // øÝ (U+00F8 U+00DD)
  0x00, 0xF8, 0x01, 0x74, 0x01, // øŴ (U+00F8 U+0174)
  0x00, 0xF8, 0x01, 0x76, 0x01, // øŶ (U+00F8 U+0176)
  0x00, 0xF8, 0x01, 0x78, 0x01, // øŸ (U+00F8 U+0178)
  0x00, 0xFD, 0x00, 0x2C, 0x01, // ý, (U+00FD U+002C)
  0x00, 0xFD, 0x00, 0x2E, 0x01, // ý. (U+00FD U+002E)
  0x00, 0xFD, 0x00, 0x41, 0x01, // ýA (U+00FD U+0041)
  0x00, 0xFD, 0x00, 0xC0, 0x01, // ýÀ (U+00FD U+00C0)
  0x00, 0xFD, 0x00, 0xC1, 0x01, // ýÁ (U+00FD U+00C1)
  0x00, 0xFD, 0x00, 0xC2, 0x01, // ýÂ (U+00FD U+00C2)
  0x00, 0xFD, 0x00, 0xC3, 0x01, // ýÃ (U+00FD U+00C3)
  0x00, 0xFD, 0x00, 0xC4, 0x01, // ýÄ (U+00FD U+00C4)
  0x00, 0xFD, 0x00, 0xC5, 0x01, // ýÅ (U+00FD U+00C5)
  0x00, 0xFD, 0x01, 0x00, 0x01, // ýĀ (U+00FD U+0100)
  0x00, 0xFD, 0x01, 0x02, 0x01, // ýĂ (U+00FD U+0102)
  0x00, 0xFD, 0x01, 0x04, 0x01, // ýĄ (U+00FD U+0104)
  0x00, 0xFD, 0x20, 0x1A, 0x01, // ý‚ (U+00FD U+201A)
  0x00, 0xFD, 0x20, 0x1E, 0x01, // ý„ (U+00FD U+201E)
  0x00, 0xFD, 0x20, 0x26, 0x01, // ý… (U+00FD U+2026)
  0x00, 0xFE, 0x00, 0x56, 0x01, // þV (U+00FE U+0056)
  0x00, 0xFE, 0x00, 0x57, 0x01, // þW (U+00FE U+0057)
  0x00, 0xFE, 0x00, 0x59, 0x01, // þY (U+00FE U+0059)
  0x00, 0xFE, 0x00, 0xDD, 0x01, // þÝ (U+00FE U+00DD)
  0x00, 0xFE, 0x01, 0x74, 0x01, // þŴ (U+00FE U+0174)
  0x00, 0xFE, 0x01, 0x76, 0x01, // þŶ (U+00FE U+0176)
  0x00, 0xFE, 0x01, 0x78, 0x01, // þŸ (U+00FE U+0178)
  0x00, 0xFF, 0x00, 0x2C, 0x01, // ÿ, (U+00FF U+002C)
  0x00, 0xFF, 0x00, 0x2E, 0x01, // ÿ. (U+00FF U+002E)
  0x00, 0xFF, 0x00, 0x41, 0x01, // ÿA (U+00FF U+0041)
  0x00, 0xFF, 0x00, 0xC0, 0x01, // ÿÀ (U+00FF U+00C0)
  0x00, 0xFF, 0x00, 0xC1, 0x01, // ÿÁ (U+00FF U+00C1)
  0x00, 0xFF, 0x00, 0xC2, 0x01, // ÿÂ (U+00FF U+00C2)
  0x00, 0xFF, 0x00, 0xC3, 0x01, // ÿÃ (U+00FF U+00C3)
  0x00, 0xFF, 0x00, 0xC4, 0x01, // ÿÄ (U+00FF U+00C4)
  0x00, 0xFF, 0x00, 0xC5, 0x01, // ÿÅ (U+00FF U+00C5)
  0x00, 0xFF, 0x01, 0x00, 0x01, // ÿĀ (U+00FF U+0100)
  0x00, 0xFF, 0x01, 0x02, 0x01, // ÿĂ (U+00FF U+0102)
  0x00, 0xFF, 0x01, 0x04, 0x01, // ÿĄ (U+00FF U+0104)
  0x00, 0xFF, 0x20, 0x1A, 0x01, // ÿ‚ (U+00FF U+201A)
  0x00, 0xFF, 0x20, 0x1E, 0x01, // ÿ„ (U+00FF U+201E)
  0x00, 0xFF, 0x20, 0x26, 0x01, // ÿ… (U+00FF U+2026)
  0x01, 0x00, 0x00, 0x22, 0x01, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x01, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x00, 0x2A, 0x01, // Ā* (U+0100 U+002A)
  0x01, 0x00, 0x00, 0x3F, 0x01, // Ā? (U+0100 U+003F)
  0x01, 0x00, 0x00, 0x54, 0x01, // ĀT (U+0100 U+0054)
  0x01, 0x00, 0x00, 0x56, 0x01, // ĀV (U+0100 U+0056)
  0x01, 0x00, 0x00, 0x57, 0x01, // ĀW (U+0100 U+0057)
  0x01, 0x00, 0x00, 0x59, 0x01, // ĀY (U+0100 U+0059)
  0x01, 0x00, 0x00, 0x76, 0x01, // Āv (U+0100 U+0076)
  0x01, 0x00, 0x00, 0x79, 0x01, // Āy (U+0100 U+0079)
  0x01, 0x00, 0x00, 0xDD, 0x01, // ĀÝ (U+0100 U+00DD)
  0x01, 0x00, 0x00, 0xFD, 0x01, // Āý (U+0100 U+00FD)
  0x01, 0x00, 0x00, 0xFF, 0x01, // Āÿ (U+0100 U+00FF)
  0x01, 0x00, 0x01, 0x62, 0x01, // ĀŢ (U+0100 U+0162)
  0x01, 0x00, 0x01, 0x64, 0x01, // ĀŤ (U+0100 U+0164)
  0x01, 0x00, 0x01, 0x66, 0x01, // ĀŦ (U+0100 U+0166)
  0x01, 0x00, 0x01, 0x74, 0x01, // ĀŴ (U+0100 U+0174)
  0x01, 0x00, 0x01, 0x76, 0x01, // ĀŶ (U+0100 U+0176)
  0x01, 0x00, 0x01, 0x77, 0x01, // Āŷ (U+0100 U+0177)
  0x01, 0x00, 0x01, 0x78, 0x01, // ĀŸ (U+0100 U+0178)
  0x01, 0x00, 0x20, 0x18, 0x01, // Ā‘ (U+0100 U+2018)
  0x01, 0x00, 0x20, 0x19, 0x01, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1C, 0x01, // Ā“ (U+0100 U+201C)
  0x01, 0x00, 0x20, 0x1D, 0x01, // Ā” (U+0100 U+201D)
  0x01, 0x00, 0x21, 0x22, 0x01, // Ā™ (U+0100 U+2122)
  0x01, 0x02, 0x00, 0x22, 0x01, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x01, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x00, 0x2A, 0x01, // Ă* (U+0102 U+002A)
  0x01, 0x02, 0x00, 0x3F, 0x01, // Ă? (U+0102 U+003F)
  0x01, 0x02, 0x00, 0x54, 0x01, // ĂT (U+0102 U+0054)
  0x01, 0x02, 0x00, 0x56, 0x01, // ĂV (U+0102 U+0056)
  0x01, 0x02, 0x00, 0x57, 0x01, // ĂW (U+0102 U+0057)
  0x01, 0x02, 0x00, 0x59, 0x01, // ĂY (U+0102 U+0059)
  0x01, 0x02, 0x00, 0x76, 0x01, // Ăv (U+0102 U+0076)
  0x01, 0x02, 0x00, 0x79, 0x01, // Ăy (U+0102 U+0079)
  0x01, 0x02, 0x00, 0xDD, 0x01, // ĂÝ (U+0102 U+00DD)
  0x01, 0x02, 0x00, 0xFD, 0x01, // Ăý (U+0102 U+00FD)
  0x01, 0x02, 0x00, 0xFF, 0x01, // Ăÿ (U+0102 U+00FF)
  0x01, 0x02, 0x01, 0x62, 0x01, // ĂŢ (U+0102 U+0162)
  0x01, 0x02, 0x01, 0x64, 0x01, // ĂŤ (U+0102 U+0164)
  0x01, 0x02, 0x01, 0x66, 0x01, // ĂŦ (U+0102 U+0166)
  0x01, 0x02, 0x01, 0x74, 0x01, // ĂŴ (U+0102 U+0174)
  0x01, 0x02, 0x01, 0x76, 0x01, // ĂŶ (U+0102 U+0176)
  0x01, 0x02, 0x01, 0x77, 0x01, // Ăŷ (U+0102 U+0177)
  0x01, 0x02, 0x01, 0x78, 0x01, // ĂŸ (U+0102 U+0178)
  0x01, 0x02, 0x20, 0x18, 0x01, // Ă‘ (U+0102 U+2018)
  0x01, 0x02, 0x20, 0x19, 0x01, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1C, 0x01, // Ă“ (U+0102 U+201C)
  0x01, 0x02, 0x20, 0x1D, 0x01, // Ă” (U+0102 U+201D)
  0x01, 0x02, 0x21, 0x22, 0x01, // Ă™ (U+0102 U+2122)
  0x01, 0x04, 0x00, 0x22, 0x01, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x01, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x00, 0x2A, 0x01, // Ą* (U+0104 U+002A)
  0x01, 0x04, 0x00, 0x3F, 0x01, // Ą? (U+0104 U+003F)
  0x01, 0x04, 0x00, 0x54, 0x01, // ĄT (U+0104 U+0054)
  0x01, 0x04, 0x00, 0x56, 0x01, // ĄV (U+0104 U+0056)
  0x01, 0x04, 0x00, 0x57, 0x01, // ĄW (U+0104 U+0057)
  0x01, 0x04, 0x00, 0x59, 0x01, // ĄY (U+0104 U+0059)
  0x01, 0x04, 0x00, 0x76, 0x01, // Ąv (U+0104 U+0076)
  0x01, 0x04, 0x00, 0x79, 0x01, // Ąy (U+0104 U+0079)
  0x01, 0x04, 0x00, 0xDD, 0x01, // ĄÝ (U+0104 U+00DD)
  0x01, 0x04, 0x00, 0xFD, 0x01, // Ąý (U+0104 U+00FD)
  0x01, 0x04, 0x00, 0xFF, 0x01, // Ąÿ (U+0104 U+00FF)
  0x01, 0x04, 0x01, 0x62, 0x01, // ĄŢ (U+0104 U+0162)
  0x01, 0x04, 0x01, 0x64, 0x01, // ĄŤ (U+0104 U+0164)
  0x01, 0x04, 0x01, 0x66, 0x01, // ĄŦ (U+0104 U+0166)
  0x01, 0x04, 0x01, 0x74, 0x01, // ĄŴ (U+0104 U+0174)
  0x01, 0x04, 0x01, 0x76, 0x01, // ĄŶ (U+0104 U+0176)
  0x01, 0x04, 0x01, 0x77, 0x01, // Ąŷ (U+0104 U+0177)
  0x01, 0x04, 0x01, 0x78, 0x01, // ĄŸ (U+0104 U+0178)
  0x01, 0x04, 0x20, 0x18, 0x01, // Ą‘ (U+0104 U+2018)
  0x01, 0x04, 0x20, 0x19, 0x01, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1C, 0x01, // Ą“ (U+0104 U+201C)
  0x01, 0x04, 0x20, 0x1D, 0x01, // Ą” (U+0104 U+201D)
  0x01, 0x04, 0x21, 0x22, 0x01, // Ą™ (U+0104 U+2122)
  0x01, 0x0E, 0x00, 0xC6, 0x01, // ĎÆ (U+010E U+00C6)
  0x01, 0x10, 0x00, 0xC6, 0x01, // ĐÆ (U+0110 U+00C6)
  0x01, 0x13, 0x00, 0x56, 0x01, // ēV (U+0113 U+0056)
  0x01, 0x13, 0x00, 0x57, 0x01, // ēW (U+0113 U+0057)
  0x01, 0x13, 0x00, 0x59, 0x01, // ēY (U+0113 U+0059)
  0x01, 0x13, 0x00, 0xDD, 0x01, // ēÝ (U+0113 U+00DD)
  0x01, 0x13, 0x01, 0x74, 0x01, // ēŴ (U+0113 U+0174)
  0x01, 0x13, 0x01, 0x76, 0x01, // ēŶ (U+0113 U+0176)
  0x01, 0x13, 0x01, 0x78, 0x01, // ēŸ (U+0113 U+0178)
  0x01, 0x15, 0x00, 0x56, 0x01, // ĕV (U+0115 U+0056)
  0x01, 0x15, 0x00, 0x57, 0x01, // ĕW (U+0115 U+0057)
  0x01, 0x15, 0x00, 0x59, 0x01, // ĕY (U+0115 U+0059)
  0x01, 0x15, 0x00, 0xDD, 0x01, // ĕÝ (U+0115 U+00DD)
  0x01, 0x15, 0x01, 0x74, 0x01, // ĕŴ (U+0115 U+0174)
  0x01, 0x15, 0x01, 0x76, 0x01, // ĕŶ (U+0115 U+0176)
  0x01, 0x15, 0x01, 0x78, 0x01, // ĕŸ (U+0115 U+0178)
  0x01, 0x17, 0x00, 0x56, 0x01, // ėV (U+0117 U+0056)
  0x01, 0x17, 0x00, 0x57, 0x01, // ėW (U+0117 U+0057)
  0x01, 0x17, 0x00, 0x59, 0x01, // ėY (U+0117 U+0059)
  0x01, 0x17, 0x00, 0xDD, 0x01, // ėÝ (U+0117 U+00DD)
  0x01, 0x17, 0x01, 0x74, 0x01, // ėŴ (U+0117 U+0174)
  0x01, 0x17, 0x01, 0x76, 0x01, // ėŶ (U+0117 U+0176)
  0x01, 0x17, 0x01, 0x78, 0x01, // ėŸ (U+0117 U+0178)
  0x01, 0x19, 0x00, 0x56, 0x01, // ęV (U+0119 U+0056)
  0x01, 0x19, 0x00, 0x57, 0x01, // ęW (U+0119 U+0057)
  0x01, 0x19, 0x00, 0x59, 0x01, // ęY (U+0119 U+0059)
  0x01, 0x19, 0x00, 0xDD, 0x01, // ęÝ (U+0119 U+00DD)
  0x01, 0x19, 0x01, 0x74, 0x01, // ęŴ (U+0119 U+0174)
  0x01, 0x19, 0x01, 0x76, 0x01, // ęŶ (U+0119 U+0176)
  0x01, 0x19, 0x01, 0x78, 0x01, // ęŸ (U+0119 U+0178)
  0x01, 0x1B, 0x00, 0x56, 0x01, // ěV (U+011B U+0056)
  0x01, 0x1B, 0x00, 0x57, 0x01, // ěW (U+011B U+0057)
  0x01, 0x1B, 0x00, 0x59, 0x01, // ěY (U+011B U+0059)
  0x01, 0x1B, 0x00, 0xDD, 0x01, // ěÝ (U+011B U+00DD)
  0x01, 0x1B, 0x01, 0x74, 0x01, // ěŴ (U+011B U+0174)
  0x01, 0x1B, 0x01, 0x76, 0x01, // ěŶ (U+011B U+0176)
  0x01, 0x1B, 0x01, 0x78, 0x01, // ěŸ (U+011B U+0178)
  0x01, 0x39, 0x00, 0x22, 0x01, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x01, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x00, 0x2A, 0x01, // Ĺ* (U+0139 U+002A)
  0x01, 0x39, 0x00, 0x3F, 0x01, // Ĺ? (U+0139 U+003F)
  0x01, 0x39, 0x00, 0x54, 0x01, // ĹT (U+0139 U+0054)
  0x01, 0x39, 0x00, 0x56, 0x01, // ĹV (U+0139 U+0056)
  0x01, 0x39, 0x00, 0x57, 0x01, // ĹW (U+0139 U+0057)
  0x01, 0x39, 0x00, 0x59, 0x01, // ĹY (U+0139 U+0059)
  0x01, 0x39, 0x00, 0xDD, 0x01, // ĹÝ (U+0139 U+00DD)
  0x01, 0x39, 0x01, 0x62, 0x01, // ĹŢ (U+0139 U+0162)
  0x01, 0x39, 0x01, 0x64, 0x01, // ĹŤ (U+0139 U+0164)
  0x01, 0x39, 0x01, 0x66, 0x01, // ĹŦ (U+0139 U+0166)
  0x01, 0x39, 0x01, 0x74, 0x01, // ĹŴ (U+0139 U+0174)
  0x01, 0x39, 0x01, 0x76, 0x01, // ĹŶ (U+0139 U+0176)
  0x01, 0x39, 0x01, 0x78, 0x01, // ĹŸ (U+0139 U+0178)
  0x01, 0x39, 0x20, 0x18, 0x01, // Ĺ‘ (U+0139 U+2018)
  0x01, 0x39, 0x20, 0x19, 0x01, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1C, 0x01, // Ĺ“ (U+0139 U+201C)
  0x01, 0x39, 0x20, 0x1D, 0x01, // Ĺ” (U+0139 U+201D)
  0x01, 0x39, 0x21, 0x22, 0x01, // Ĺ™ (U+0139 U+2122)
  0x01, 0x3B, 0x00, 0x22, 0x01, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x01, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x00, 0x2A, 0x01, // Ļ* (U+013B U+002A)
  0x01, 0x3B, 0x00, 0x3F, 0x01, // Ļ? (U+013B U+003F)
  0x01, 0x3B, 0x00, 0x54, 0x01, // ĻT (U+013B U+0054)
  0x01, 0x3B, 0x00, 0x56, 0x01, // ĻV (U+013B U+0056)
  0x01, 0x3B, 0x00, 0x57, 0x01, // ĻW (U+013B U+0057)
  0x01, 0x3B, 0x00, 0x59, 0x01, // ĻY (U+013B U+0059)
  0x01, 0x3B, 0x00, 0xDD, 0x01, // ĻÝ (U+013B U+00DD)
  0x01, 0x3B, 0x01, 0x62, 0x01, // ĻŢ (U+013B U+0162)
  0x01, 0x3B, 0x01, 0x64, 0x01, // ĻŤ (U+013B U+0164)
  0x01, 0x3B, 0x01, 0x66, 0x01, // ĻŦ (U+013B U+0166)
  0x01, 0x3B, 0x01, 0x74, 0x01, // ĻŴ (U+013B U+0174)
  0x01, 0x3B, 0x01, 0x76, 0x01, // ĻŶ (U+013B U+0176)
  0x01, 0x3B, 0x01, 0x78, 0x01, // ĻŸ (U+013B U+0178)
  0x01, 0x3B, 0x20, 0x18, 0x01, // Ļ‘ (U+013B U+2018)
  0x01, 0x3B, 0x20, 0x19, 0x01, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1C, 0x01, // Ļ“ (U+013B U+201C)
  0x01, 0x3B, 0x20, 0x1D, 0x01, // Ļ” (U+013B U+201D)
  0x01, 0x3B, 0x21, 0x22, 0x01, // Ļ™ (U+013B U+2122)
  0x01, 0x41, 0x00, 0x22, 0x01, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x01, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x00, 0x2A, 0x01, // Ł* (U+0141 U+002A)
  0x01, 0x41, 0x00, 0x3F, 0x01, // Ł? (U+0141 U+003F)
  0x01, 0x41, 0x00, 0x54, 0x01, // ŁT (U+0141 U+0054)
  0x01, 0x41, 0x00, 0x56, 0x01, // ŁV (U+0141 U+0056)
  0x01, 0x41, 0x00, 0x57, 0x01, // ŁW (U+0141 U+0057)
  0x01, 0x41, 0x00, 0x59, 0x01, // ŁY (U+0141 U+0059)
  0x01, 0x41, 0x00, 0xDD, 0x01, // ŁÝ (U+0141 U+00DD)
  0x01, 0x41, 0x01, 0x62, 0x01, // ŁŢ (U+0141 U+0162)
  0x01, 0x41, 0x01, 0x64, 0x01, // ŁŤ (U+0141 U+0164)
  0x01, 0x41, 0x01, 0x66, 0x01, // ŁŦ (U+0141 U+0166)
  0x01, 0x41, 0x01, 0x74, 0x01, // ŁŴ (U+0141 U+0174)
  0x01, 0x41, 0x01, 0x76, 0x01, // ŁŶ (U+0141 U+0176)
  0x01, 0x41, 0x01, 0x78, 0x01, // ŁŸ (U+0141 U+0178)
  0x01, 0x41, 0x20, 0x18, 0x01, // Ł‘ (U+0141 U+2018)
  0x01, 0x41, 0x20, 0x19, 0x01, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1C, 0x01, // Ł“ (U+0141 U+201C)
  0x01, 0x41, 0x20, 0x1D, 0x01, // Ł” (U+0141 U+201D)
  0x01, 0x41, 0x21, 0x22, 0x01, // Ł™ (U+0141 U+2122)
  0x01, 0x4C, 0x00, 0xC6, 0x01, // ŌÆ (U+014C U+00C6)
  0x01, 0x4D, 0x00, 0x56, 0x01, // ōV (U+014D U+0056)
  0x01, 0x4D, 0x00, 0x57, 0x01, // ōW (U+014D U+0057)
  0x01, 0x4D, 0x00, 0x59, 0x01, // ōY (U+014D U+0059)
  0x01, 0x4D, 0x00, 0xDD, 0x01, // ōÝ (U+014D U+00DD)
  0x01, 0x4D, 0x01, 0x74, 0x01, // ōŴ (U+014D U+0174)
  0x01, 0x4D, 0x01, 0x76, 0x01, // ōŶ (U+014D U+0176)
  0x01, 0x4D, 0x01, 0x78, 0x01, // ōŸ (U+014D U+0178)
  0x01, 0x4E, 0x00, 0xC6, 0x01, // ŎÆ (U+014E U+00C6)
  0x01, 0x4F, 0x00, 0x56, 0x01, // ŏV (U+014F U+0056)
  0x01, 0x4F, 0x00, 0x57, 0x01, // ŏW (U+014F U+0057)
  0x01, 0x4F, 0x00, 0x59, 0x01, // ŏY (U+014F U+0059)
  0x01, 0x4F, 0x00, 0xDD, 0x01, // ŏÝ (U+014F U+00DD)
  0x01, 0x4F, 0x01, 0x74, 0x01, // ŏŴ (U+014F U+0174)
  0x01, 0x4F, 0x01, 0x76, 0x01, // ŏŶ (U+014F U+0176)
  0x01, 0x4F, 0x01, 0x78, 0x01, // ŏŸ (U+014F U+0178)
  0x01, 0x50, 0x00, 0xC6, 0x01, // ŐÆ (U+0150 U+00C6)
  0x01, 0x51, 0x00, 0x56, 0x01, // őV (U+0151 U+0056)
  0x01, 0x51, 0x00, 0x57, 0x01, // őW (U+0151 U+0057)
  0x01, 0x51, 0x00, 0x59, 0x01, // őY (U+0151 U+0059)
  0x01, 0x51, 0x00, 0xDD, 0x01, // őÝ (U+0151 U+00DD)
  0x01, 0x51, 0x01, 0x74, 0x01, // őŴ (U+0151 U+0174)
  0x01, 0x51, 0x01, 0x76, 0x01, // őŶ (U+0151 U+0176)
  0x01, 0x51, 0x01, 0x78, 0x01, // őŸ (U+0151 U+0178)
  0x01, 0x53, 0x00, 0x56, 0x01, // œV (U+0153 U+0056)
  0x01, 0x53, 0x00, 0x57, 0x01, // œW (U+0153 U+0057)
  0x01, 0x53, 0x00, 0x59, 0x01, // œY (U+0153 U+0059)
  0x01, 0x53, 0x00, 0xDD, 0x01, // œÝ (U+0153 U+00DD)
  0x01, 0x53, 0x01, 0x74, 0x01, // œŴ (U+0153 U+0174)
  0x01, 0x53, 0x01, 0x76, 0x01, // œŶ (U+0153 U+0176)
  0x01, 0x53, 0x01, 0x78, 0x01, // œŸ (U+0153 U+0178)
  0x01, 0x55, 0x00, 0x2C, 0x01, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x01, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x20, 0x1A, 0x01, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x01, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x01, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x01, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x01, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x20, 0x1A, 0x01, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x01, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x01, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x01, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x01, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x20, 0x1A, 0x01, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x01, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x01, // ř… (U+0159 U+2026)
  0x01, 0x5B, 0x00, 0x59, 0x01, // śY (U+015B U+0059)
  0x01, 0x5B, 0x00, 0xDD, 0x01, // śÝ (U+015B U+00DD)
  0x01, 0x5B, 0x01, 0x76, 0x01, // śŶ (U+015B U+0176)
  0x01, 0x5B, 0x01, 0x78, 0x01, // śŸ (U+015B U+0178)
  0x01, 0x5D, 0x00, 0x59, 0x01, // ŝY (U+015D U+0059)
  0x01, 0x5D, 0x00, 0xDD, 0x01, // ŝÝ (U+015D U+00DD)
  0x01, 0x5D, 0x01, 0x76, 0x01, // ŝŶ (U+015D U+0176)
  0x01, 0x5D, 0x01, 0x78, 0x01, // ŝŸ (U+015D U+0178)
  0x01, 0x5F, 0x00, 0x59, 0x01, // şY (U+015F U+0059)
  0x01, 0x5F, 0x00, 0xDD, 0x01, // şÝ (U+015F U+00DD)
  0x01, 0x5F, 0x01, 0x76, 0x01, // şŶ (U+015F U+0176)
  0x01, 0x5F, 0x01, 0x78, 0x01, // şŸ (U+015F U+0178)
  0x01, 0x61, 0x00, 0x59, 0x01, // šY (U+0161 U+0059)
  0x01, 0x61, 0x00, 0xDD, 0x01, // šÝ (U+0161 U+00DD)
  0x01, 0x61, 0x01, 0x76, 0x01, // šŶ (U+0161 U+0176)
  0x01, 0x61, 0x01, 0x78, 0x01, // šŸ (U+0161 U+0178)
  0x01, 0x62, 0x00, 0x2C, 0x01, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2E, 0x01, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0x41, 0x01, // ŢA (U+0162 U+0041)
  0x01, 0x62, 0x00, 0xC0, 0x01, // ŢÀ (U+0162 U+00C0)
  0x01, 0x62, 0x00, 0xC1, 0x01, // ŢÁ (U+0162 U+00C1)
  0x01, 0x62, 0x00, 0xC2, 0x01, // ŢÂ (U+0162 U+00C2)
  0x01, 0x62, 0x00, 0xC3, 0x01, // ŢÃ (U+0162 U+00C3)
  0x01, 0x62, 0x00, 0xC4, 0x01, // ŢÄ (U+0162 U+00C4)
  0x01, 0x62, 0x00, 0xC5, 0x01, // ŢÅ (U+0162 U+00C5)
  0x01, 0x62, 0x00, 0xC6, 0x01, // ŢÆ (U+0162 U+00C6)
  0x01, 0x62, 0x01, 0x00, 0x01, // ŢĀ (U+0162 U+0100)
  0x01, 0x62, 0x01, 0x02, 0x01, // ŢĂ (U+0162 U+0102)
  0x01, 0x62, 0x01, 0x04, 0x01, // ŢĄ (U+0162 U+0104)
  0x01, 0x62, 0x20, 0x1A, 0x01, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x01, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x01, // Ţ… (U+0162 U+2026)
  0x01, 0x64, 0x00, 0x2C, 0x01, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2E, 0x01, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0x41, 0x01, // ŤA (U+0164 U+0041)
  0x01, 0x64, 0x00, 0xC0, 0x01, // ŤÀ (U+0164 U+00C0)
  0x01, 0x64, 0x00, 0xC1, 0x01, // ŤÁ (U+0164 U+00C1)
  0x01, 0x64, 0x00, 0xC2, 0x01, // ŤÂ (U+0164 U+00C2)
  0x01, 0x64, 0x00, 0xC3, 0x01, // ŤÃ (U+0164 U+00C3)
  0x01, 0x64, 0x00, 0xC4, 0x01, // ŤÄ (U+0164 U+00C4)
  0x01, 0x64, 0x00, 0xC5, 0x01, // ŤÅ (U+0164 U+00C5)
  0x01, 0x64, 0x00, 0xC6, 0x01, // ŤÆ (U+0164 U+00C6)
  0x01, 0x64, 0x01, 0x00, 0x01, // ŤĀ (U+0164 U+0100)
  0x01, 0x64, 0x01, 0x02, 0x01, // ŤĂ (U+0164 U+0102)
  0x01, 0x64, 0x01, 0x04, 0x01, // ŤĄ (U+0164 U+0104)
  0x01, 0x64, 0x20, 0x1A, 0x01, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x01, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x01, // Ť… (U+0164 U+2026)
  0x01, 0x66, 0x00, 0x2C, 0x01, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2E, 0x01, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0x41, 0x01, // ŦA (U+0166 U+0041)
  0x01, 0x66, 0x00, 0xC0, 0x01, // ŦÀ (U+0166 U+00C0)
  0x01, 0x66, 0x00, 0xC1, 0x01, // ŦÁ (U+0166 U+00C1)
  0x01, 0x66, 0x00, 0xC2, 0x01, // ŦÂ (U+0166 U+00C2)
  0x01, 0x66, 0x00, 0xC3, 0x01, // ŦÃ (U+0166 U+00C3)
  0x01, 0x66, 0x00, 0xC4, 0x01, // ŦÄ (U+0166 U+00C4)
  0x01, 0x66, 0x00, 0xC5, 0x01, // ŦÅ (U+0166 U+00C5)
  0x01, 0x66, 0x00, 0xC6, 0x01, // ŦÆ (U+0166 U+00C6)
  0x01, 0x66, 0x01, 0x00, 0x01, // ŦĀ (U+0166 U+0100)
  0x01, 0x66, 0x01, 0x02, 0x01, // ŦĂ (U+0166 U+0102)
  0x01, 0x66, 0x01, 0x04, 0x01, // ŦĄ (U+0166 U+0104)
  0x01, 0x66, 0x20, 0x1A, 0x01, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x01, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x01, // Ŧ… (U+0166 U+2026)
  0x01, 0x74, 0x00, 0x2C, 0x01, // Ŵ, (U+0174 U+002C)
  0x01, 0x74, 0x00, 0x2E, 0x01, // Ŵ. (U+0174 U+002E)
  0x01, 0x74, 0x00, 0x40, 0x01, // Ŵ@ (U+0174 U+0040)
  0x01, 0x74, 0x00, 0x41, 0x01, // ŴA (U+0174 U+0041)
  0x01, 0x74, 0x00, 0x61, 0x01, // Ŵa (U+0174 U+0061)
  0x01, 0x74, 0x00, 0x63, 0x01, // Ŵc (U+0174 U+0063)
  0x01, 0x74, 0x00, 0x64, 0x01, // Ŵd (U+0174 U+0064)
  0x01, 0x74, 0x00, 0x65, 0x01, // Ŵe (U+0174 U+0065)
  0x01, 0x74, 0x00, 0x67, 0x01, // Ŵg (U+0174 U+0067)
  0x01, 0x74, 0x00, 0x6F, 0x01, // Ŵo (U+0174 U+006F)
  0x01, 0x74, 0x00, 0x71, 0x01, // Ŵq (U+0174 U+0071)
  0x01, 0x74, 0x00, 0x73, 0x01, // Ŵs (U+0174 U+0073)
  0x01, 0x74, 0x00, 0xC0, 0x01, // ŴÀ (U+0174 U+00C0)
  0x01, 0x74, 0x00, 0xC1, 0x01, // ŴÁ (U+0174 U+00C1)
  0x01, 0x74, 0x00, 0xC2, 0x01, // ŴÂ (U+0174 U+00C2)
  0x01, 0x74, 0x00, 0xC3, 0x01, // ŴÃ (U+0174 U+00C3)
  0x01, 0x74, 0x00, 0xC4, 0x01, // ŴÄ (U+0174 U+00C4)
  0x01, 0x74, 0x00, 0xC5, 0x01, // ŴÅ (U+0174 U+00C5)
  0x01, 0x74, 0x00, 0xC6, 0x01, // ŴÆ (U+0174 U+00C6)
  0x01, 0x74, 0x00, 0xE0, 0x01, // Ŵà (U+0174 U+00E0)
  0x01, 0x74, 0x00, 0xE1, 0x01, // Ŵá (U+0174 U+00E1)
  0x01, 0x74, 0x00, 0xE2, 0x01, // Ŵâ (U+0174 U+00E2)
  0x01, 0x74, 0x00, 0xE3, 0x01, // Ŵã (U+0174 U+00E3)
  0x01, 0x74, 0x00, 0xE4, 0x01, // Ŵä (U+0174 U+00E4)
  0x01, 0x74, 0x00, 0xE5, 0x01, // Ŵå (U+0174 U+00E5)
  0x01, 0x74, 0x00, 0xE6, 0x01, // Ŵæ (U+0174 U+00E6)
  0x01, 0x74, 0x00, 0xE7, 0x01, // Ŵç (U+0174 U+00E7)
  0x01, 0x74, 0x00, 0xE8, 0x01, // Ŵè (U+0174 U+00E8)
  0x01, 0x74, 0x00, 0xE9, 0x01, // Ŵé (U+0174 U+00E9)
  0x01, 0x74, 0x00, 0xEA, 0x01, // Ŵê (U+0174 U+00EA)
  0x01, 0x74, 0x00, 0xEB, 0x01, // Ŵë (U+0174 U+00EB)
  0x01, 0x74, 0x00, 0xF0, 0x01, // Ŵð (U+0174 U+00F0)
  0x01, 0x74, 0x00, 0xF2, 0x01, // Ŵò (U+0174 U+00F2)
  0x01, 0x74, 0x00, 0xF3, 0x01, // Ŵó (U+0174 U+00F3)
  0x01, 0x74, 0x00, 0xF4, 0x01, // Ŵô (U+0174 U+00F4)
  0x01, 0x74, 0x00, 0xF5, 0x01, // Ŵõ (U+0174 U+00F5)
  0x01, 0x74, 0x00, 0xF6, 0x01, // Ŵö (U+0174 U+00F6)
  0x01, 0x74, 0x00, 0xF8, 0x01, // Ŵø (U+0174 U+00F8)
  0x01, 0x74, 0x01, 0x00, 0x01, // ŴĀ (U+0174 U+0100)
  0x01, 0x74, 0x01, 0x01, 0x01, // Ŵā (U+0174 U+0101)
  0x01, 0x74, 0x01, 0x02, 0x01, // ŴĂ (U+0174 U+0102)
  0x01, 0x74, 0x01, 0x03, 0x01, // Ŵă (U+0174 U+0103)
  0x01, 0x74, 0x01, 0x04, 0x01, // ŴĄ (U+0174 U+0104)
  0x01, 0x74, 0x01, 0x05, 0x01, // Ŵą (U+0174 U+0105)
  0x01, 0x74, 0x01, 0x07, 0x01, // Ŵć (U+0174 U+0107)
  0x01, 0x74, 0x01, 0x09, 0x01, // Ŵĉ (U+0174 U+0109)
  0x01, 0x74, 0x01, 0x0B, 0x01, // Ŵċ (U+0174 U+010B)
  0x01, 0x74, 0x01, 0x0D, 0x01, // Ŵč (U+0174 U+010D)
  0x01, 0x74, 0x01, 0x0F, 0x01, // Ŵď (U+0174 U+010F)
  0x01, 0x74, 0x01, 0x11, 0x01, // Ŵđ (U+0174 U+0111)
  0x01, 0x74, 0x01, 0x13, 0x01, // Ŵē (U+0174 U+0113)
  0x01, 0x74, 0x01, 0x15, 0x01, // Ŵĕ (U+0174 U+0115)
  0x01, 0x74, 0x01, 0x17, 0x01, // Ŵė (U+0174 U+0117)
  0x01, 0x74, 0x01, 0x19, 0x01, // Ŵę (U+0174 U+0119)
  0x01, 0x74, 0x01, 0x1B, 0x01, // Ŵě (U+0174 U+011B)
  0x01, 0x74, 0x01, 0x1D, 0x01, // Ŵĝ (U+0174 U+011D)
  0x01, 0x74, 0x01, 0x1F, 0x01, // Ŵğ (U+0174 U+011F)
  0x01, 0x74, 0x01, 0x21, 0x01, // Ŵġ (U+0174 U+0121)
  0x01, 0x74, 0x01, 0x23, 0x01, // Ŵģ (U+0174 U+0123)
  0x01, 0x74, 0x01, 0x4D, 0x01, // Ŵō (U+0174 U+014D)
  0x01, 0x74, 0x01, 0x4F, 0x01, // Ŵŏ (U+0174 U+014F)
  0x01, 0x74, 0x01, 0x51, 0x01, // Ŵő (U+0174 U+0151)
  0x01, 0x74, 0x01, 0x53, 0x01, // Ŵœ (U+0174 U+0153)
  0x01, 0x74, 0x01, 0x5B, 0x01, // Ŵś (U+0174 U+015B)
  0x01, 0x74, 0x01, 0x5D, 0x01, // Ŵŝ (U+0174 U+015D)
  0x01, 0x74, 0x01, 0x5F, 0x01, // Ŵş (U+0174 U+015F)
  0x01, 0x74, 0x01, 0x61, 0x01, // Ŵš (U+0174 U+0161)
  0x01, 0x74, 0x20, 0x1A, 0x01, // Ŵ‚ (U+0174 U+201A)
  0x01, 0x74, 0x20, 0x1E, 0x01, // Ŵ„ (U+0174 U+201E)
  0x01, 0x74, 0x20, 0x26, 0x01, // Ŵ… (U+0174 U+2026)
  0x01, 0x75, 0x00, 0x2C, 0x01, // ŵ, (U+0175 U+002C)
  0x01, 0x75, 0x00, 0x2E, 0x01, // ŵ. (U+0175 U+002E)
  0x01, 0x75, 0x20, 0x1A, 0x01, // ŵ‚ (U+0175 U+201A)
  0x01, 0x75, 0x20, 0x1E, 0x01, // ŵ„ (U+0175 U+201E)
  0x01, 0x75, 0x20, 0x26, 0x01, // ŵ… (U+0175 U+2026)
  0x01, 0x76, 0x00, 0x2C, 0x01, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x01, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x00, 0x41, 0x01, // ŶA (U+0176 U+0041)
  0x01, 0x76, 0x00, 0x61, 0x01, // Ŷa (U+0176 U+0061)
  0x01, 0x76, 0x00, 0x63, 0x01, // Ŷc (U+0176 U+0063)
  0x01, 0x76, 0x00, 0x64, 0x01, // Ŷd (U+0176 U+0064)
  0x01, 0x76, 0x00, 0x65, 0x01, // Ŷe (U+0176 U+0065)
  0x01, 0x76, 0x00, 0x67, 0x01, // Ŷg (U+0176 U+0067)
  0x01, 0x76, 0x00, 0x6F, 0x01, // Ŷo (U+0176 U+006F)
  0x01, 0x76, 0x00, 0x71, 0x01, // Ŷq (U+0176 U+0071)
  0x01, 0x76, 0x00, 0x73, 0x01, // Ŷs (U+0176 U+0073)
  0x01, 0x76, 0x00, 0xC0, 0x01, // ŶÀ (U+0176 U+00C0)
  0x01, 0x76, 0x00, 0xC1, 0x01, // ŶÁ (U+0176 U+00C1)
  0x01, 0x76, 0x00, 0xC2, 0x01, // ŶÂ (U+0176 U+00C2)
  0x01, 0x76, 0x00, 0xC3, 0x01, // ŶÃ (U+0176 U+00C3)
  0x01, 0x76, 0x00, 0xC4, 0x01, // ŶÄ (U+0176 U+00C4)
  0x01, 0x76, 0x00, 0xC5, 0x01, // ŶÅ (U+0176 U+00C5)
  0x01, 0x76, 0x00, 0xC6, 0x01, // ŶÆ (U+0176 U+00C6)
  0x01, 0x76, 0x00, 0xE0, 0x01, // Ŷà (U+0176 U+00E0)
  0x01, 0x76, 0x00, 0xE1, 0x01, // Ŷá (U+0176 U+00E1)
  0x01, 0x76, 0x00, 0xE2, 0x01, // Ŷâ (U+0176 U+00E2)
  0x01, 0x76, 0x00, 0xE3, 0x01, // Ŷã (U+0176 U+00E3)
  0x01, 0x76, 0x00, 0xE4, 0x01, // Ŷä (U+0176 U+00E4)
  0x01, 0x76, 0x00, 0xE5, 0x01, // Ŷå (U+0176 U+00E5)
  0x01, 0x76, 0x00, 0xE6, 0x01, // Ŷæ (U+0176 U+00E6)
  0x01, 0x76, 0x00, 0xE7, 0x01, // Ŷç (U+0176 U+00E7)
  0x01, 0x76, 0x00, 0xE8, 0x01, // Ŷè (U+0176 U+00E8)
  0x01, 0x76, 0x00, 0xE9, 0x01, // Ŷé (U+0176 U+00E9)
  0x01, 0x76, 0x00, 0xEA, 0x01, // Ŷê (U+0176 U+00EA)
  0x01, 0x76, 0x00, 0xEB, 0x01, // Ŷë (U+0176 U+00EB)
  0x01, 0x76, 0x00, 0xF0, 0x01, // Ŷð (U+0176 U+00F0)
  0x01, 0x76, 0x00, 0xF2, 0x01, // Ŷò (U+0176 U+00F2)
  0x01, 0x76, 0x00, 0xF3, 0x01, // Ŷó (U+0176 U+00F3)
  0x01, 0x76, 0x00, 0xF4, 0x01, // Ŷô (U+0176 U+00F4)
  0x01, 0x76, 0x00, 0xF5, 0x01, // Ŷõ (U+0176 U+00F5)
  0x01, 0x76, 0x00, 0xF6, 0x01, // Ŷö (U+0176 U+00F6)
  0x01, 0x76, 0x00, 0xF8, 0x01, // Ŷø (U+0176 U+00F8)
  0x01, 0x76, 0x01, 0x00, 0x01, // ŶĀ (U+0176 U+0100)
  0x01, 0x76, 0x01, 0x01, 0x01, // Ŷā (U+0176 U+0101)
  0x01, 0x76, 0x01, 0x02, 0x01, // ŶĂ (U+0176 U+0102)
  0x01, 0x76, 0x01, 0x03, 0x01, // Ŷă (U+0176 U+0103)
  0x01, 0x76, 0x01, 0x04, 0x01, // ŶĄ (U+0176 U+0104)
  0x01, 0x76, 0x01, 0x05, 0x01, // Ŷą (U+0176 U+0105)
  0x01, 0x76, 0x01, 0x07, 0x01, // Ŷć (U+0176 U+0107)
  0x01, 0x76, 0x01, 0x09, 0x01, // Ŷĉ (U+0176 U+0109)
  0x01, 0x76, 0x01, 0x0B, 0x01, // Ŷċ (U+0176 U+010B)
  0x01, 0x76, 0x01, 0x0D, 0x01, // Ŷč (U+0176 U+010D)
  0x01, 0x76, 0x01, 0x0F, 0x01, // Ŷď (U+0176 U+010F)
  0x01, 0x76, 0x01, 0x11, 0x01, // Ŷđ (U+0176 U+0111)
  0x01, 0x76, 0x01, 0x13, 0x01, // Ŷē (U+0176 U+0113)
  0x01, 0x76, 0x01, 0x15, 0x01, // Ŷĕ (U+0176 U+0115)
  0x01, 0x76, 0x01, 0x17, 0x01, // Ŷė (U+0176 U+0117)
  0x01, 0x76, 0x01, 0x19, 0x01, // Ŷę (U+0176 U+0119)
  0x01, 0x76, 0x01, 0x1B, 0x01, // Ŷě (U+0176 U+011B)
  0x01, 0x76, 0x01, 0x1D, 0x01, // Ŷĝ (U+0176 U+011D)
  0x01, 0x76, 0x01, 0x1F, 0x01, // Ŷğ (U+0176 U+011F)
  0x01, 0x76, 0x01, 0x21, 0x01, // Ŷġ (U+0176 U+0121)
  0x01, 0x76, 0x01, 0x23, 0x01, // Ŷģ (U+0176 U+0123)
  0x01, 0x76, 0x01, 0x4D, 0x01, // Ŷō (U+0176 U+014D)
  0x01, 0x76, 0x01, 0x4F, 0x01, // Ŷŏ (U+0176 U+014F)
  0x01, 0x76, 0x01, 0x51, 0x01, // Ŷő (U+0176 U+0151)
  0x01, 0x76, 0x01, 0x53, 0x01, // Ŷœ (U+0176 U+0153)
  0x01, 0x76, 0x01, 0x5B, 0x01, // Ŷś (U+0176 U+015B)
  0x01, 0x76, 0x01, 0x5D, 0x01, // Ŷŝ (U+0176 U+015D)
  0x01, 0x76, 0x01, 0x5F, 0x01, // Ŷş (U+0176 U+015F)
  0x01, 0x76, 0x01, 0x61, 0x01, // Ŷš (U+0176 U+0161)
  0x01, 0x76, 0x20, 0x1A, 0x01, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x01, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x01, // Ŷ… (U+0176 U+2026)
  0x01, 0x77, 0x00, 0x2C, 0x01, // ŷ, (U+0177 U+002C)
  0x01, 0x77, 0x00, 0x2E, 0x01, // ŷ. (U+0177 U+002E)
  0x01, 0x77, 0x00, 0x41, 0x01, // ŷA (U+0177 U+0041)
  0x01, 0x77, 0x00, 0xC0, 0x01, // ŷÀ (U+0177 U+00C0)
  0x01, 0x77, 0x00, 0xC1, 0x01, // ŷÁ (U+0177 U+00C1)
  0x01, 0x77, 0x00, 0xC2, 0x01, // ŷÂ (U+0177 U+00C2)
  0x01, 0x77, 0x00, 0xC3, 0x01, // ŷÃ (U+0177 U+00C3)
  0x01, 0x77, 0x00, 0xC4, 0x01, // ŷÄ (U+0177 U+00C4)
  0x01, 0x77, 0x00, 0xC5, 0x01, // ŷÅ (U+0177 U+00C5)
  0x01, 0x77, 0x01, 0x00, 0x01, // ŷĀ (U+0177 U+0100)
  0x01, 0x77, 0x01, 0x02, 0x01, // ŷĂ (U+0177 U+0102)
  0x01, 0x77, 0x01, 0x04, 0x01, // ŷĄ (U+0177 U+0104)
  0x01, 0x77, 0x20, 0x1A, 0x01, // ŷ‚ (U+0177 U+201A)
  0x01, 0x77, 0x20, 0x1E, 0x01, // ŷ„ (U+0177 U+201E)
  0x01, 0x77, 0x20, 0x26, 0x01, // ŷ… (U+0177 U+2026)
  0x01, 0x78, 0x00, 0x2C, 0x01, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x01, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x00, 0x41, 0x01, // ŸA (U+0178 U+0041)
  0x01, 0x78, 0x00, 0x61, 0x01, // Ÿa (U+0178 U+0061)
  0x01, 0x78, 0x00, 0x63, 0x01, // Ÿc (U+0178 U+0063)
  0x01, 0x78, 0x00, 0x64, 0x01, // Ÿd (U+0178 U+0064)
  0x01, 0x78, 0x00, 0x65, 0x01, // Ÿe (U+0178 U+0065)
  0x01, 0x78, 0x00, 0x67, 0x01, // Ÿg (U+0178 U+0067)
  0x01, 0x78, 0x00, 0x6F, 0x01, // Ÿo (U+0178 U+006F)
  0x01, 0x78, 0x00, 0x71, 0x01, // Ÿq (U+0178 U+0071)
  0x01, 0x78, 0x00, 0x73, 0x01, // Ÿs (U+0178 U+0073)
  0x01, 0x78, 0x00, 0xC0, 0x01, // ŸÀ (U+0178 U+00C0)
  0x01, 0x78, 0x00, 0xC1, 0x01, // ŸÁ (U+0178 U+00C1)
  0x01, 0x78, 0x00, 0xC2, 0x01, // ŸÂ (U+0178 U+00C2)
  0x01, 0x78, 0x00, 0xC3, 0x01, // ŸÃ (U+0178 U+00C3)
  0x01, 0x78, 0x00, 0xC4, 0x01, // ŸÄ (U+0178 U+00C4)
  0x01, 0x78, 0x00, 0xC5, 0x01, // ŸÅ (U+0178 U+00C5)
  0x01, 0x78, 0x00, 0xC6, 0x01, // ŸÆ (U+0178 U+00C6)
  0x01, 0x78, 0x00, 0xE0, 0x01, // Ÿà (U+0178 U+00E0)
  0x01, 0x78, 0x00, 0xE1, 0x01, // Ÿá (U+0178 U+00E1)
  0x01, 0x78, 0x00, 0xE2, 0x01, // Ÿâ (U+0178 U+00E2)
  0x01, 0x78, 0x00, 0xE3, 0x01, // Ÿã (U+0178 U+00E3)
  0x01, 0x78, 0x00, 0xE4, 0x01, // Ÿä (U+0178 U+00E4)
  0x01, 0x78, 0x00, 0xE5, 0x01, // Ÿå (U+0178 U+00E5)
  0x01, 0x78, 0x00, 0xE6, 0x01, // Ÿæ (U+0178 U+00E6)
  0x01, 0x78, 0x00, 0xE7, 0x01, // Ÿç (U+0178 U+00E7)
  0x01, 0x78, 0x00, 0xE8, 0x01, // Ÿè (U+0178 U+00E8)
  0x01, 0x78, 0x00, 0xE9, 0x01, // Ÿé (U+0178 U+00E9)
  0x01, 0x78, 0x00, 0xEA, 0x01, // Ÿê (U+0178 U+00EA)
  0x01, 0x78, 0x00, 0xEB, 0x01, // Ÿë (U+0178 U+00EB)
  0x01, 0x78, 0x00, 0xF0, 0x01, // Ÿð (U+0178 U+00F0)
  0x01, 0x78, 0x00, 0xF2, 0x01, // Ÿò (U+0178 U+00F2)
  0x01, 0x78, 0x00, 0xF3, 0x01, // Ÿó (U+0178 U+00F3)
  0x01, 0x78, 0x00, 0xF4, 0x01, // Ÿô (U+0178 U+00F4)
  0x01, 0x78, 0x00, 0xF5, 0x01, // Ÿõ (U+0178 U+00F5)
  0x01, 0x78, 0x00, 0xF6, 0x01, // Ÿö (U+0178 U+00F6)
  0x01, 0x78, 0x00, 0xF8, 0x01, // Ÿø (U+0178 U+00F8)
  0x01, 0x78, 0x01, 0x00, 0x01, // ŸĀ (U+0178 U+0100)
  0x01, 0x78, 0x01, 0x01, 0x01, // Ÿā (U+0178 U+0101)
  0x01, 0x78, 0x01, 0x02, 0x01, // ŸĂ (U+0178 U+0102)
  0x01, 0x78, 0x01, 0x03, 0x01, // Ÿă (U+0178 U+0103)
  0x01, 0x78, 0x01, 0x04, 0x01, // ŸĄ (U+0178 U+0104)
  0x01, 0x78, 0x01, 0x05, 0x01, // Ÿą (U+0178 U+0105)
  0x01, 0x78, 0x01, 0x07, 0x01, // Ÿć (U+0178 U+0107)
  0x01, 0x78, 0x01, 0x09, 0x01, // Ÿĉ (U+0178 U+0109)
  0x01, 0x78, 0x01, 0x0B, 0x01, // Ÿċ (U+0178 U+010B)
  0x01, 0x78, 0x01, 0x0D, 0x01, // Ÿč (U+0178 U+010D)
  0x01, 0x78, 0x01, 0x0F, 0x01, // Ÿď (U+0178 U+010F)
  0x01, 0x78, 0x01, 0x11, 0x01, // Ÿđ (U+0178 U+0111)
  0x01, 0x78, 0x01, 0x13, 0x01, // Ÿē (U+0178 U+0113)
  0x01, 0x78, 0x01, 0x15, 0x01, // Ÿĕ (U+0178 U+0115)
  0x01, 0x78, 0x01, 0x17, 0x01, // Ÿė (U+0178 U+0117)
  0x01, 0x78, 0x01, 0x19, 0x01, // Ÿę (U+0178 U+0119)
  0x01, 0x78, 0x01, 0x1B, 0x01, // Ÿě (U+0178 U+011B)
  0x01, 0x78, 0x01, 0x1D, 0x01, // Ÿĝ (U+0178 U+011D)
  0x01, 0x78, 0x01, 0x1F, 0x01, // Ÿğ (U+0178 U+011F)
  0x01, 0x78, 0x01, 0x21, 0x01, // Ÿġ (U+0178 U+0121)
  0x01, 0x78, 0x01, 0x23, 0x01, // Ÿģ (U+0178 U+0123)
  0x01, 0x78, 0x01, 0x4D, 0x01, // Ÿō (U+0178 U+014D)
  0x01, 0x78, 0x01, 0x4F, 0x01, // Ÿŏ (U+0178 U+014F)
  0x01, 0x78, 0x01, 0x51, 0x01, // Ÿő (U+0178 U+0151)
  0x01, 0x78, 0x01, 0x53, 0x01, // Ÿœ (U+0178 U+0153)
  0x01, 0x78, 0x01, 0x5B, 0x01, // Ÿś (U+0178 U+015B)
  0x01, 0x78, 0x01, 0x5D, 0x01, // Ÿŝ (U+0178 U+015D)
  0x01, 0x78, 0x01, 0x5F, 0x01, // Ÿş (U+0178 U+015F)
  0x01, 0x78, 0x01, 0x61, 0x01, // Ÿš (U+0178 U+0161)
  0x01, 0x78, 0x20, 0x1A, 0x01, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x01, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x01, // Ÿ… (U+0178 U+2026)
  0x20, 0x18, 0x00, 0x41, 0x01, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0xC0, 0x01, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x01, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x01, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x01, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x01, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x01, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xC6, 0x01, // ‘Æ (U+2018 U+00C6)
  0x20, 0x18, 0x01, 0x00, 0x01, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x02, 0x01, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x04, 0x01, // ‘Ą (U+2018 U+0104)
  0x20, 0x19, 0x00, 0x41, 0x01, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0x73, 0x01, // ’s (U+2019 U+0073)
  0x20, 0x19, 0x00, 0xC0, 0x01, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x01, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x01, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x01, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x01, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x01, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x01, 0x00, 0x01, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x02, 0x01, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x04, 0x01, // ’Ą (U+2019 U+0104)
  0x20, 0x19, 0x01, 0x5B, 0x01, // ’ś (U+2019 U+015B)
  0x20, 0x19, 0x01, 0x5D, 0x01, // ’ŝ (U+2019 U+015D)
  0x20, 0x19, 0x01, 0x5F, 0x01, // ’ş (U+2019 U+015F)
  0x20, 0x19, 0x01, 0x61, 0x01, // ’š (U+2019 U+0161)
  0x20, 0x1A, 0x00, 0x3F, 0x01, // ‚? (U+201A U+003F)
  0x20, 0x1A, 0x00, 0x54, 0x01, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x56, 0x01, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x01, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x01, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0x76, 0x01, // ‚v (U+201A U+0076)
  0x20, 0x1A, 0x00, 0x77, 0x01, // ‚w (U+201A U+0077)
  0x20, 0x1A, 0x00, 0x79, 0x01, // ‚y (U+201A U+0079)
  0x20, 0x1A, 0x00, 0xDD, 0x01, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x00, 0xFD, 0x01, // ‚ý (U+201A U+00FD)
  0x20, 0x1A, 0x00, 0xFF, 0x01, // ‚ÿ (U+201A U+00FF)
  0x20, 0x1A, 0x01, 0x62, 0x01, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x01, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x01, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1A, 0x01, 0x74, 0x01, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x75, 0x01, // ‚ŵ (U+201A U+0175)
  0x20, 0x1A, 0x01, 0x76, 0x01, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x77, 0x01, // ‚ŷ (U+201A U+0177)
  0x20, 0x1A, 0x01, 0x78, 0x01, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x01, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0xC0, 0x01, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x01, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x01, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x01, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x01, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x01, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xC6, 0x01, // “Æ (U+201C U+00C6)
  0x20, 0x1C, 0x01, 0x00, 0x01, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x02, 0x01, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x04, 0x01, // “Ą (U+201C U+0104)
  0x20, 0x1D, 0x00, 0x41, 0x01, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0x73, 0x01, // ”s (U+201D U+0073)
  0x20, 0x1D, 0x00, 0xC0, 0x01, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x01, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x01, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x01, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x01, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x01, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x01, 0x00, 0x01, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x02, 0x01, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x04, 0x01, // ”Ą (U+201D U+0104)
  0x20, 0x1D, 0x01, 0x5B, 0x01, // ”ś (U+201D U+015B)
  0x20, 0x1D, 0x01, 0x5D, 0x01, // ”ŝ (U+201D U+015D)
  0x20, 0x1D, 0x01, 0x5F, 0x01, // ”ş (U+201D U+015F)
  0x20, 0x1D, 0x01, 0x61, 0x01, // ”š (U+201D U+0161)
  0x20, 0x1E, 0x00, 0x3F, 0x01, // „? (U+201E U+003F)
  0x20, 0x1E, 0x00, 0x54, 0x01, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x56, 0x01, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x01, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x01, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0x76, 0x01, // „v (U+201E U+0076)
  0x20, 0x1E, 0x00, 0x77, 0x01, // „w (U+201E U+0077)
  0x20, 0x1E, 0x00, 0x79, 0x01, // „y (U+201E U+0079)
  0x20, 0x1E, 0x00, 0xDD, 0x01, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x00, 0xFD, 0x01, // „ý (U+201E U+00FD)
  0x20, 0x1E, 0x00, 0xFF, 0x01, // „ÿ (U+201E U+00FF)
  0x20, 0x1E, 0x01, 0x62, 0x01, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x01, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x01, // „Ŧ (U+201E U+0166)
  0x20, 0x1E, 0x01, 0x74, 0x01, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x75, 0x01, // „ŵ (U+201E U+0175)
  0x20, 0x1E, 0x01, 0x76, 0x01, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x77, 0x01, // „ŷ (U+201E U+0177)
  0x20, 0x1E, 0x01, 0x78, 0x01, // „Ÿ (U+201E U+0178)
  0x20, 0x26, 0x00, 0x3F, 0x01, // …? (U+2026 U+003F)
  0x20, 0x26, 0x00, 0x54, 0x01, // …T (U+2026 U+0054)
  0x20, 0x26, 0x00, 0x56, 0x01, // …V (U+2026 U+0056)
  0x20, 0x26, 0x00, 0x57, 0x01, // …W (U+2026 U+0057)
  0x20, 0x26, 0x00, 0x59, 0x01, // …Y (U+2026 U+0059)
  0x20, 0x26, 0x00, 0x76, 0x01, // …v (U+2026 U+0076)
  0x20, 0x26, 0x00, 0x77, 0x01, // …w (U+2026 U+0077)
  0x20, 0x26, 0x00, 0x79, 0x01, // …y (U+2026 U+0079)
  0x20, 0x26, 0x00, 0xDD, 0x01, // …Ý (U+2026 U+00DD)
  0x20, 0x26, 0x00, 0xFD, 0x01, // …ý (U+2026 U+00FD)
  0x20, 0x26, 0x00, 0xFF, 0x01, // …ÿ (U+2026 U+00FF)
  0x20, 0x26, 0x01, 0x62, 0x01, // …Ţ (U+2026 U+0162)
  0x20, 0x26, 0x01, 0x64, 0x01, // …Ť (U+2026 U+0164)
  0x20, 0x26, 0x01, 0x66, 0x01, // …Ŧ (U+2026 U+0166)
  0x20, 0x26, 0x01, 0x74, 0x01, // …Ŵ (U+2026 U+0174)
  0x20, 0x26, 0x01, 0x75, 0x01, // …ŵ (U+2026 U+0175)
  0x20, 0x26, 0x01, 0x76, 0x01, // …Ŷ (U+2026 U+0176)
  0x20, 0x26, 0x01, 0x77, 0x01, // …ŷ (U+2026 U+0177)
  0x20, 0x26, 0x01, 0x78, 0x01, // …Ÿ (U+2026 U+0178)
  
  // Glyph data
  // "!" (U+0021)
  0xEB, 0xC9, 0xA8, 0x96, 0x74, 0x00, 0x97, 0xB8,
  // """ (U+0022)
  0x3F, 0x3F, 0x51, 0xF0, 0xE2, 0x0C, 0x0B, 0x00,
  // "#" (U+0023)
  0x00, 0xB1, 0x90, 0x00, 0xA4, 0x60, 0x4C, 0xDD, 0xC3, 0x05, 0x59, 0x10, 0x07, 0x3A, 0x00, 0x8E,
  0xBE, 0xB0, 0x0A, 0x19, 0x00, 0x0A, 0x37, 0x00,
  // "$" (U+0024)
  0x00, 0x61, 0x00, 0x8C, 0xD7, 0x3E, 0x66, 0x82, 0xFD, 0x30, 0x05, 0xDF, 0x72, 0x36, 0x9F, 0x6A,
  0x65, 0xD0, 0x8C, 0x92, 0x00, 0x61, 0x00,
  // "%" (U+0025)
  0x2C, 0xC4, 0x05, 0x60, 0x08, 0x84, 0xC0, 0xB0, 0x00, 0x97, 0x3E, 0x38, 0x00, 0x07, 0x95, 0xBA,
  0x5B, 0xB1, 0x1A, 0xB5, 0xAB, 0x68, 0x80, 0x00, 0x84, 0xD4, 0x6A, 0x00, 0x0B, 0x0B, 0x57, 0x80,
  0x05, 0x60, 0x4C, 0xC2,
  // "&" (U+0026)
  0x02, 0xCC, 0xB0, 0x00, 0x08, 0xD0, 0xE4, 0x00, 0x05, 0xF6, 0xD1, 0x00, 0x02, 0xEF, 0x28, 0xD7,
  0x3E, 0x7E, 0xB9, 0x70, 0x7F, 0x03, 0xEF, 0x20, 0x5F, 0x20, 0x7F, 0x70, 0x09, 0xDB, 0x87, 0xFB,
  // "'" (U+0027)
  0x3F, 0x21, 0xF0, 0x0C, 0x00,
  // "(" (U+0028)
  0x00, 0x15, 0x03, 0xD2, 0x0D, 0x80, 0x4F, 0x40, 0x6F, 0x30, 0x5F, 0x30, 0x2F, 0x50, 0x0A, 0xA0,
  0x00, 0xB5, 0x00, 0x02,
  // ")" (U+0029)
  0x51, 0x00, 0x2D, 0x30, 0x08, 0xD0, 0x04, 0xF3, 0x03, 0xF6, 0x03, 0xF5, 0x05, 0xF2, 0x0A, 0xA0,
  0x5B, 0x00, 0x20, 0x00,
  // "*" (U+002A)
  0x10, 0xD0, 0x15, 0xBB, 0xB6, 0x5B, 0xCB, 0x51, 0x1D, 0x11,
  // "+" (U+002B)
  0x00, 0x82, 0x00, 0x08, 0x20, 0x4B, 0xDC, 0xA0, 0x08, 0x20, 0x00, 0x82, 0x00,
  // "," (U+002C)
  0x4D, 0x01, 0xD2, 0x3A, 0x01, 0x00,
  // "-" (U+002D)
  0x8B, 0x90,
  // "." (U+002E)
  0x2B, 0x23, 0xE2,
  // "/" (U+002F)
  0x00, 0xA0, 0x28, 0x06, 0x40, 0x91, 0x0A, 0x01, 0x90, 0x46, 0x08, 0x20, 0xB0, 0x05, 0x00,
  // "0" (U+0030)
  0x08, 0xDC, 0x30, 0x4F, 0x28, 0xD0, 0x8E, 0x05, 0xF1, 0x9E, 0x04, 0xF3, 0x9E, 0x04, 0xF3, 0x8E,
  0x05, 0xF1, 0x4F, 0x28, 0xD0, 0x08, 0xDC, 0x30,
  // "1" (U+0031)
  0x18, 0x12, 0xCC, 0x20, 0x50, 0xFC, 0x40, 0xA0, 0xC4, 0x0A, 0x0C, 0x40, 0xA0, 0xC4, 0x0A, 0x0C,
  0x40, 0xB0, 0xC3, 0x0B, 0xA0, 0xB0, 0x10,
  // "2" (U+0032)
  0x2B, 0xCD, 0x30, 0x8C, 0x0A, 0xC0, 0x25, 0x0A, 0xB0, 0x00, 0x0E, 0x30, 0x00, 0x96, 0x00, 0x06,
  0x80, 0x20, 0x5B, 0x23, 0xC1, 0xAF, 0xFF, 0xF1,
  // "3" (U+0033)
  0x3C, 0xCD, 0x40, 0x8B, 0x0B, 0xC0, 0x01, 0x0D, 0x80, 0x06, 0xDC, 0x10, 0x00, 0x0B, 0xD0, 0x10,
  0x06, 0xF1, 0x94, 0x09, 0xD0, 0x3C, 0xCC, 0x30,
  // "4" (U+0034)
  0x00, 0x4F, 0x50, 0x00, 0xAF, 0x50, 0x06, 0x5F, 0x50, 0x09, 0x1F, 0x50, 0x72, 0x1F, 0x50, 0xBB,
  0xCF, 0xD4, 0x00, 0x1F, 0x50, 0x02, 0xDF, 0xE3,
  // "5" (U+0035)
  0x1D, 0xBB, 0xB3, 0x80, 0x05, 0x47, 0x00, 0x05, 0xCC, 0xA2, 0x00, 0x0B, 0xD0, 0x00, 0x7F, 0x75,
  0x0A, 0xC3, 0xCC, 0xC2,
  // "6" (U+0036)
  0x03, 0xCD, 0xA0, 0x0E, 0x43, 0xE0, 0x4F, 0x00, 0x00, 0x7E, 0xAC, 0x50, 0x8E, 0x06, 0xF1, 0x6E,
  0x03, 0xF3, 0x2F, 0x35, 0xE0, 0x06, 0xDC, 0x50,
  // "7" (U+0037)
  0x8D, 0xBC, 0xF2, 0x71, 0x05, 0xD0, 0x00, 0x0B, 0x70, 0x00, 0x1F, 0x10, 0x00, 0x7B, 0x00, 0x00,
  0xC6, 0x00, 0x03, 0xF1, 0x00, 0x08, 0xA0, 0x00,
  // "8" (U+0038)
  0x0A, 0xCD, 0x50, 0x5F, 0x06, 0xD0, 0x5F, 0x27, 0xD0, 0x0B, 0xFD, 0x20, 0x1C, 0x8E, 0xA0, 0x9B,
  0x03, 0xF3, 0x8C, 0x03, 0xF2, 0x1B, 0xCC, 0x60,
  // "9" (U+0039)
  0x0A, 0xCC, 0x20, 0x6E, 0x08, 0xB0, 0x9C, 0x05, 0xF0, 0x7E, 0x06, 0xF1, 0x1A, 0xBA, 0xF0, 0x00,
  0x06, 0xD0, 0x34, 0x0B, 0x80, 0x1C, 0xCA, 0x00,
  // ":" (U+003A)
  0x2E, 0x32, 0xB2, 0x00, 0x00, 0x00, 0x2B, 0x22, 0xE3,
  // ";" (U+003B)
  0x2E, 0x32, 0xB2, 0x00, 0x00, 0x00, 0x19, 0x02, 0xF4, 0x0A, 0x13, 0x30,
  // "<" (U+003C)
  0x00, 0x05, 0xA0, 0x3B, 0x70, 0x3E, 0x30, 0x00, 0x19, 0x91, 0x00, 0x02, 0x90,
  // "=" (U+003D)
  0x04, 0x80, 0x0B, 0x50, 0x48, 0x00, 0xB0,
  // ">" (U+003E)
  0x49, 0x20, 0x00, 0x2A, 0x81, 0x00, 0x09, 0xB0, 0x4B, 0x60, 0x47, 0x00, 0x00,
  // "?" (U+003F)
  0x3D, 0xCC, 0x37, 0xD0, 0xBD, 0x00, 0x0B, 0xD0, 0x04, 0xE4, 0x00, 0xE1, 0x00, 0x04, 0x00, 0x02,
  0xB1, 0x00, 0x3E, 0x20,
  // "@" (U+0040)
  0x00, 0x19, 0xCB, 0xB4, 0x00, 0x2D, 0x40, 0x01, 0xB3, 0x0B, 0x54, 0xCC, 0x92, 0xA3, 0xC1, 0xF3,
  0x69, 0x0C, 0x68, 0x6D, 0x09, 0x71, 0xA7, 0x75, 0xC0, 0xC6, 0x65, 0x59, 0x09, 0x93, 0xA7, 0x01,
  0xD1, 0x00, 0x00, 0x00, 0x07, 0xB2, 0x00, 0x57, 0x00, 0x05, 0xBC, 0xB6, 0x00,
  // "A" (U+0041)
  0x28, 0x11, 0xFA, 0x58, 0x15, 0xDE, 0x58, 0x2B, 0x6F, 0x43, 0x83, 0x1D, 0x0F, 0x93, 0x83, 0x69,
  0x0C, 0xE3, 0x87, 0xBB, 0xAC, 0xF4, 0x01, 0xD2, 0x87, 0x1F, 0x90, 0xDF, 0x70, 0x9A, 0x06,
  // "B" (U+0042)
  0x8F, 0xEC, 0xC5, 0x00, 0xCC, 0x0B, 0xE0, 0x0C, 0xC0, 0xBD, 0x00, 0xCE, 0xCE, 0x30, 0x0C, 0xC0,
  0x8E, 0x10, 0xCC, 0x05, 0xF4, 0x0C, 0xC0, 0x7F, 0x28, 0xFE, 0xBD, 0x60,
  // "C" (U+0043)
  0x01, 0xAC, 0xDA, 0x00, 0xCB, 0x02, 0xF2, 0x3F, 0x50, 0x02, 0x06, 0xF4, 0x00, 0x00, 0x6F, 0x40,
  0x00, 0x03, 0xF5, 0x00, 0x00, 0x0C, 0xB0, 0x03, 0x20, 0x1A, 0xDB, 0xA0,
  // "D" (U+0044)
  0x8F, 0xEC, 0xC7, 0x00, 0x0C, 0xC0, 0x3F, 0x70, 0x0C, 0xC0, 0x0B, 0xE0, 0x0C, 0xC0, 0x09, 0xF1,
  0x0C, 0xC0, 0x09, 0xF1, 0x0C, 0xC0, 0x0C, 0xD0, 0x0C, 0xC0, 0x4F, 0x60, 0x8F, 0xEC, 0xD6, 0x00,
  // "E" (U+0045)
  0x84, 0x6E, 0xE9, 0x9D, 0x20, 0x0C, 0x20, 0xA2, 0x00, 0xC5, 0x83, 0xCE, 0xBB, 0x22, 0x00, 0xC5,
  0x00, 0xC2, 0x01, 0x20, 0x0C, 0x28, 0x79, 0x26, 0xEE, 0x99, 0xE2,
  // "F" (U+0046)
  0x8F, 0xEB, 0xDC, 0x0C, 0xC0, 0x0C, 0x0C, 0xC0, 0x03, 0x0C, 0xC0, 0x00, 0x0C, 0xEB, 0xB1, 0x0C,
  0xC0, 0x00, 0x0C, 0xC0, 0x00, 0x8F, 0xFB, 0x00,
  // "G" (U+0047)
  0x00, 0x9C, 0xCD, 0x40, 0x0B, 0xC0, 0x0A, 0xA0, 0x3F, 0x60, 0x01, 0x00, 0x6F, 0x40, 0x00, 0x00,
  0x6F, 0x40, 0x9D, 0xD4, 0x3F, 0x60, 0x0E, 0xB0, 0x0C, 0xC0, 0x0D, 0xA0, 0x01, 0x9D, 0xBC, 0x50,
  // "H" (U+0048)
  0x8F, 0xF8, 0x6E, 0xFB, 0x0C, 0xC0, 0x09, 0xF0, 0x0C, 0xC0, 0x09, 0xF0, 0x0C, 0xEB, 0xBD, 0xF0,
  0x0C, 0xC0, 0x09, 0xF0, 0x0C, 0xC0, 0x09, 0xF0, 0x0C, 0xC0, 0x09, 0xF0, 0x8F, 0xF8, 0x6E, 0xFB,
  // "I" (U+0049)
  0x8F, 0xF8, 0x0C, 0xC0, 0x0C, 0xC0, 0x0C, 0xC0, 0x0C, 0xC0, 0x0C, 0xC0, 0x0C, 0xC0, 0x8F, 0xF8,
  // "J" (U+004A)
  0x08, 0xFF, 0x90, 0x0C, 0xC0, 0x00, 0xBC, 0x00, 0x0B, 0xC0, 0x00, 0xBC, 0x00, 0x0B, 0xC0, 0x00,
  0xBC, 0x00, 0x0B, 0xC0, 0x00, 0xCB, 0x00, 0x1E, 0x80, 0x2D, 0xA1, 0x00,
  // "K" (U+004B)
  0x8F, 0xF8, 0x8F, 0xD0, 0x0C, 0xC0, 0x3C, 0x00, 0x0C, 0xC1, 0xB1, 0x00, 0x0C, 0xCB, 0x70, 0x00,
  0x0C, 0xEC, 0xE1, 0x00, 0x0C, 0xC3, 0xF9, 0x00, 0x0C, 0xC0, 0xAF, 0x30, 0x8F, 0xF8, 0x1C, 0xE4,
  // "L" (U+004C)
  0x82, 0x6E, 0xE6, 0x40, 0x0C, 0x50, 0x0C, 0x50, 0x0C, 0x50, 0x0C, 0x50, 0x0C, 0x28, 0x32, 0x10,
  0xCC, 0x28, 0x78, 0x26, 0xEE, 0x99, 0xE2,
  // "M" (U+004D)
  0x8F, 0xF4, 0x00, 0xBF, 0xD2, 0x0C, 0xE9, 0x00, 0xDF, 0x50, 0x0B, 0xAE, 0x05, 0x9F, 0x40, 0x0B,
  0x5F, 0x39, 0x5F, 0x40, 0x0B, 0x0F, 0x8B, 0x3F, 0x40, 0x0B, 0x0B, 0xE7, 0x3F, 0x40, 0x0B, 0x06,
  0xF3, 0x3F, 0x50, 0x8F, 0x91, 0xD0, 0xCF, 0xD2,
  // "N" (U+004E)
  0x8F, 0xC0, 0x0B, 0xF8, 0x0C, 0xF7, 0x00, 0xB0, 0x0B, 0xAE, 0x20, 0xB0, 0x0B, 0x1E, 0xB0, 0xB0,
  0x0B, 0x06, 0xF5, 0xB0, 0x0B, 0x00, 0xBE, 0xB0, 0x0B, 0x00, 0x2F, 0xC0, 0x8F, 0xB0, 0x07, 0xC0,
  // "O" (U+004F)
  0x01, 0xAC, 0xC9, 0x00, 0x0C, 0xB0, 0x0D, 0xA0, 0x3F, 0x50, 0x07, 0xF1, 0x6F, 0x40, 0x06, 0xF4,
  0x6F, 0x40, 0x06, 0xF4, 0x3F, 0x50, 0x07, 0xF1, 0x0C, 0xB0, 0x0D, 0xA0, 0x01, 0xAC, 0xC9, 0x00,
  // "P" (U+0050)
  0x8F, 0xEC, 0xC3, 0x0C, 0xC0, 0xBD, 0x0C, 0xC0, 0x9F, 0x0C, 0xC0, 0xCC, 0x0C, 0xEC, 0x91, 0x0C,
  0xC0, 0x00, 0x0C, 0xC0, 0x00, 0x8F, 0xFB, 0x00,
  // "Q" (U+0051)
  0x01, 0xAC, 0xC9, 0x00, 0x0C, 0xB0, 0x0D, 0xA0, 0x3F, 0x60, 0x08, 0xF1, 0x6F, 0x40, 0x06, 0xF3,
  0x6F, 0x30, 0x05, 0xF4, 0x4F, 0x50, 0x07, 0xF2, 0x0E, 0x90, 0x0B, 0xC0, 0x04, 0xE8, 0x9D, 0x20,
  0x00, 0x1C, 0xE0, 0x00, 0x00, 0x07, 0xF3, 0x00, 0x00, 0x00, 0x9E, 0x50,
  // "R" (U+0052)
  0x8F, 0xEC, 0xD6, 0x00, 0x0C, 0xC0, 0x9F, 0x10, 0x0C, 0xC0, 0x7F, 0x20, 0x0C, 0xC0, 0xAD, 0x00,
  0x0C, 0xED, 0xF2, 0x00, 0x0C, 0xC3, 0xF7, 0x00, 0x0C, 0xC0, 0xAE, 0x20, 0x8F, 0xF8, 0x1C, 0xE1,
  // "S" (U+0053)
  0x08, 0xCE, 0x90, 0x5D, 0x05, 0xE0, 0x6E, 0x30, 0x10, 0x1E, 0xF9, 0x10, 0x01, 0x8F, 0xE1, 0x34,
  0x03, 0xF4, 0x9A, 0x01, 0xF2, 0x3C, 0xCC, 0x50,
  // "T" (U+0054)
  0xDC, 0xDF, 0xBE, 0x6B, 0x08, 0xF1, 0x56, 0x10, 0x8F, 0x10, 0x10, 0x08, 0xF1, 0x00, 0x00, 0x8F,
  0x10, 0x00, 0x08, 0xF1, 0x00, 0x00, 0x8F, 0x10, 0x00, 0x5E, 0xFC, 0x00,
  // "U" (U+0055)
  0xAF, 0xF7, 0x3D, 0xD3, 0x0E, 0xA0, 0x05, 0x50, 0x0E, 0xA0, 0x05, 0x50, 0x0E, 0xA0, 0x05, 0x50,
  0x0E, 0xA0, 0x05, 0x50, 0x0D, 0xA0, 0x05, 0x50, 0x0B, 0xD0, 0x09, 0x30, 0x02, 0xBD, 0xB8, 0x00,
  // "V" (U+0056)
  0xDF, 0xD3, 0x6E, 0xC1, 0xF8, 0x00, 0xB1, 0x0B, 0xC0, 0x1A, 0x00, 0x7F, 0x15, 0x60, 0x02, 0xF6,
  0xA1, 0x00, 0x0C, 0xAB, 0x00, 0x00, 0x7F, 0x70, 0x00, 0x02, 0xF2, 0x00,
  // "W" (U+0057)
  0xDF, 0xE4, 0x0C, 0x30, 0xCF, 0x81, 0xF8, 0x01, 0xF8, 0x01, 0xB0, 0x0D, 0xB0, 0x5F, 0xC0, 0x47,
  0x00, 0x8F, 0x09, 0x9F, 0x28, 0x40, 0x04, 0xF4, 0xC1, 0xF7, 0xB0, 0x00, 0x0F, 0xA9, 0x0C, 0xBB,
  0x00, 0x00, 0xBF, 0x50, 0x7F, 0x80, 0x00, 0x07, 0xF0, 0x02, 0xF4, 0x00,
  // "X" (U+0058)
  0x8F, 0xF7, 0x4F, 0xD0, 0x09, 0xF2, 0x0C, 0x00, 0x01, 0xEB, 0x83, 0x00, 0x00, 0x6F, 0x90, 0x00,
  0x00, 0x5E, 0xD0, 0x00, 0x01, 0xA3, 0xF8, 0x00, 0x0C, 0x20, 0x9F, 0x30, 0xCF, 0x70, 0xEF, 0xE2,
  // "Y" (U+0059)
  0xDF, 0xE4, 0x8F, 0xC1, 0xFA, 0x00, 0xC1, 0x09, 0xE1, 0x38, 0x00, 0x1F, 0x79, 0x10, 0x00, 0x9E,
  0x80, 0x00, 0x04, 0xF4, 0x00, 0x00, 0x5F, 0x40, 0x00, 0x4D, 0xFD, 0x30,
  // "Z" (U+005A)
  0x5E, 0xAA, 0xFE, 0x05, 0x60, 0x4F, 0x70, 0x11, 0x0C, 0xD0, 0x00, 0x06, 0xF5, 0x00, 0x00, 0xEC,
  0x00, 0x00, 0x7F, 0x40, 0x21, 0x1E, 0xA0, 0x09, 0x38, 0xFB, 0xAA, 0xF2,
  // "[" (U+005B)
  0xFE, 0x9F, 0x80, 0xF8, 0x0F, 0x80, 0xF8, 0x0F, 0x80, 0xF8, 0x0F, 0x80, 0xF8, 0x0D, 0xD9,
  // "\" (U+005C)
  0xA0, 0x0A, 0x00, 0x64, 0x03, 0x70, 0x0A, 0x00, 0xA0, 0x08, 0x20, 0x46, 0x01, 0x90, 0x05,
  // "]" (U+005D)
  0x7E, 0xF2, 0x06, 0xF2, 0x05, 0xF2, 0x05, 0xF2, 0x05, 0xF2, 0x05, 0xF2, 0x05, 0xF2, 0x05, 0xF2,
  0x06, 0xF2, 0x7D, 0xD1,
  // "^" (U+005E)
  0x00, 0xA3, 0x00, 0x1B, 0x90, 0x07, 0x4A, 0x10, 0xB0, 0x47, 0x56, 0x00, 0xB0,
  // "_" (U+005F)
  0xBB, 0xBB, 0x70,
  // "`" (U+0060)
  0x4F, 0x30, 0x5A,
  // "a" (U+0061)
  0x0B, 0xDD, 0x70, 0x08, 0x28, 0xF0, 0x09, 0xCD, 0xF0, 0x7F, 0x27, 0xF0, 0x7F, 0x09, 0xF0, 0x1D,
  0xB7, 0xF8,
  // "b" (U+0062)
  0xBF, 0x80, 0x00, 0x0F, 0x70, 0x00, 0x0F, 0xAA, 0xD4, 0x0F, 0xB0, 0xBC, 0x0F, 0x80, 0x8F, 0x0F,
  0x80, 0x8E, 0x0F, 0xB0, 0xBC, 0xAF, 0x7A, 0xD3,
  // "c" (U+0063)
  0x08, 0xDD, 0x74, 0xF3, 0x7B, 0x7F, 0x00, 0x07, 0xF0, 0x00, 0x4F, 0x30, 0x40, 0x8D, 0xB7,
  // "d" (U+0064)
  0x00, 0x0C, 0xF7, 0x00, 0x00, 0x0F, 0x70, 0x0A, 0xD8, 0xF7, 0x05, 0xF3, 0x3F, 0x70, 0x7F, 0x01,
  0xF7, 0x07, 0xF0, 0x1F, 0x70, 0x5F, 0x23, 0xF7, 0x00, 0xAD, 0x8B, 0xE4,
  // "e" (U+0065)
  0x07, 0xCC, 0x60, 0x3F, 0x25, 0xF2, 0x7F, 0xBC, 0xD3, 0x7F, 0x10, 0x00, 0x3F, 0x50, 0x50, 0x07,
  0xDB, 0x90,
  // "f" (U+0066)
  0x05, 0xDE, 0x80, 0xCA, 0x45, 0x8F, 0xEB, 0x00, 0xD9, 0x00, 0x0D, 0x90, 0x00, 0xD9, 0x00, 0x0E,
  0xA0, 0x0A, 0xFF, 0x90,
  // "g" (U+0067)
  0x0A, 0xCD, 0x74, 0x5E, 0x0D, 0x60, 0x7D, 0x0B, 0x90, 0x4F, 0x0D, 0x60, 0x0C, 0xEB, 0x00, 0x3E,
  0xFF, 0xC0, 0xC5, 0x01, 0xF3, 0xE4, 0x02, 0xF1, 0x5C, 0xBC, 0x50,
  // "h" (U+0068)
  0x8F, 0x80, 0x00, 0x00, 0xF7, 0x00, 0x00, 0x0F, 0xBC, 0xD3, 0x00, 0xFA, 0x0E, 0x90, 0x0F, 0x80,
  0xCA, 0x00, 0xF8, 0x0C, 0xA0, 0x0F, 0x80, 0xCB, 0x08, 0xFD, 0x2C, 0xE3,
  // "i" (U+0069)
  0x0D, 0x60, 0x0B, 0x40, 0xAF, 0x80, 0x0F, 0x80, 0x0F, 0x80, 0x0F, 0x80, 0x0F, 0x80, 0xAF, 0xE4,
  // "j" (U+006A)
  0x00, 0xD6, 0x00, 0xB4, 0x0B, 0xF8, 0x00, 0xF8, 0x00, 0xF8, 0x00, 0xF8, 0x00, 0xF8, 0x00, 0xF8,
  0x00, 0xF7, 0x03, 0xF5, 0x2C, 0x90,
  // "k" (U+006B)
  0xAF, 0x80, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x0F, 0x86, 0xFE, 0x00, 0xF7, 0x4B, 0x00, 0x0F, 0xAE,
  0x20, 0x00, 0xFC, 0xEA, 0x00, 0x0F, 0x87, 0xF5, 0x0A, 0xFE, 0x4B, 0xF4,
  // "l" (U+006C)
  0xAF, 0x80, 0x0F, 0x80, 0x0F, 0x80, 0x0F, 0x80, 0x0F, 0x80, 0x0F, 0x80, 0x0F, 0x80, 0xAF, 0xE4,
  // "m" (U+006D)
  0x8F, 0xAC, 0xE7, 0xBE, 0x50, 0x0F, 0xA0, 0xED, 0x0B, 0xC0, 0x0F, 0x80, 0xCB, 0x09, 0xE0, 0x0F,
  0x80, 0xCA, 0x09, 0xE0, 0x0F, 0x80, 0xCB, 0x09, 0xE0, 0x8F, 0xD2, 0xCE, 0x39, 0xF5,
  // "n" (U+006E)
  0x9F, 0xAC, 0xE3, 0x00, 0xFA, 0x0E, 0x90, 0x0F, 0x80, 0xCA, 0x00, 0xF8, 0x0C, 0xA0, 0x0F, 0x80,
  0xCB, 0x0A, 0xFE, 0x3C, 0xF5,
  // "o" (U+006F)
  0x07, 0xCC, 0x80, 0x3F, 0x31, 0xF5, 0x7F, 0x00, 0xE9, 0x7F, 0x00, 0xE9, 0x3F, 0x31, 0xF5, 0x07,
  0xCC, 0x90,
  // "p" (U+0070)
  0xAF, 0x8B, 0xD3, 0x1F, 0xA0, 0xBB, 0x0F, 0x70, 0x9E, 0x0F, 0x70, 0x9E, 0x0F, 0xA0, 0xBC, 0x0F,
  0xAB, 0xD3, 0x0F, 0x70, 0x00, 0x1F, 0x80, 0x00, 0xBF, 0xE4, 0x00,
  // "q" (U+0071)
  0x18, 0xB7, 0xAD, 0x8C, 0xE4, 0x5F, 0x33, 0xF8, 0x07, 0xF0, 0x1F, 0x70, 0x7F, 0x01, 0xF7, 0x05,
  0xF3, 0x3F, 0x72, 0x83, 0xAD, 0x8F, 0x75, 0x90, 0x74, 0x81, 0x1F, 0x74, 0x82, 0xDF, 0xE5,
  // "r" (U+0072)
  0x9F, 0xAC, 0xD0, 0xFA, 0x27, 0x0F, 0x80, 0x00, 0xF8, 0x00, 0x0F, 0x80, 0x0A, 0xFE, 0x60,
  // "s" (U+0073)
  0x2C, 0xCC, 0x18, 0xA0, 0x91, 0x5F, 0xB3, 0x00, 0x3A, 0xF4, 0x95, 0x0C, 0x65, 0xDB, 0xB0,
  // "t" (U+0074)
  0x03, 0x30, 0x1C, 0x70, 0x9F, 0xD8, 0x0F, 0x70, 0x0F, 0x70, 0x0F, 0x70, 0x0F, 0x80, 0x09, 0xE8,
  // "u" (U+0075)
  0x9F, 0x77, 0xFA, 0x00, 0xF7, 0x0D, 0xA0, 0x0F, 0x70, 0xDA, 0x00, 0xF7, 0x0D, 0xA0, 0x0F, 0x90,
  0xEA, 0x00, 0x7E, 0xAC, 0xF5,
  // "v" (U+0076)
  0xDF, 0xD2, 0xDD, 0x2F, 0x60, 0x83, 0x0C, 0xB0, 0xB0, 0x06, 0xF3, 0x80, 0x01, 0xFC, 0x30, 0x00,
  0xBE, 0x00,
  // "w" (U+0077)
  0xEF, 0xC0, 0xD1, 0x9F, 0x74, 0xF3, 0x2F, 0x50, 0xB0, 0x0E, 0x77, 0xEA, 0x46, 0x00, 0xAA, 0xA7,
  0xE8, 0x20, 0x06, 0xE8, 0x2F, 0xB0, 0x00, 0x2F, 0x30, 0xD8, 0x00,
  // "x" (U+0078)
  0x9F, 0xF7, 0xEE, 0x10, 0x8F, 0x2B, 0x10, 0x00, 0xCE, 0x30, 0x00, 0x0A, 0xE8, 0x00, 0x0A, 0x25,
  0xF4, 0x0B, 0xF8, 0xAF, 0xF4,
  // "y" (U+0079)
  0xEF, 0xB5, 0xFB, 0x3F, 0x40, 0xB0, 0x0D, 0x91, 0xA0, 0x07, 0xE5, 0x50, 0x02, 0xFD, 0x10, 0x00,
  0xCB, 0x00, 0x00, 0x96, 0x00, 0x03, 0xE1, 0x00, 0x8D, 0x50, 0x00,
  // "z" (U+007A)
  0x7D, 0xBF, 0xC6, 0x15, 0xF3, 0x00, 0xD9, 0x00, 0x8E, 0x10, 0x2F, 0x50, 0xAB, 0xFB, 0xBE,
  // "{" (U+007B)
  0x03, 0xDC, 0x10, 0x8F, 0x00, 0x08, 0xF0, 0x00, 0xAE, 0x00, 0x9F, 0x50, 0x00, 0xAE, 0x00, 0x08,
  0xF0, 0x00, 0x8F, 0x00, 0x07, 0xF1, 0x00, 0x1B, 0xC1,
  // "|" (U+007C)
  0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82,
  // "}" (U+007D)
  0x8E, 0x70, 0x00, 0x9E, 0x00, 0x09, 0xE0, 0x00, 0x8F, 0x10, 0x01, 0xDE, 0x10, 0x7F, 0x10, 0x09,
  0xE0, 0x00, 0x9E, 0x00, 0x0A, 0xD0, 0x08, 0xC5, 0x00,
  // "~" (U+007E)
  0x2B, 0x91, 0x96, 0x34, 0xB8,
  // "¡" (U+00A1)
  0x8B, 0x79, 0x00, 0x57, 0x69, 0x8A, 0x9C, 0xBD,
  // "¢" (U+00A2)
  0x00, 0x36, 0x00, 0x07, 0xEE, 0xB0, 0x3F, 0x79, 0xD1, 0x6F, 0x56, 0x00, 0x6F, 0x56, 0x00, 0x2F,
  0x96, 0x50, 0x06, 0xDD, 0x80, 0x00, 0x36, 0x00,
  // "£" (U+00A3)
  0x07, 0xCD, 0x90, 0x1F, 0x34, 0xC0, 0x0F, 0x40, 0x00, 0x8E, 0xDB, 0x30, 0x07, 0xC0, 0x00, 0x06,
  0xB0, 0x00, 0x0B, 0x60, 0x02, 0x7B, 0xBD, 0xB2,
  // "¤" (U+00A4)
  0x01, 0x00, 0x11, 0xCB, 0xB9, 0x0A, 0x03, 0x80, 0xB0, 0x47, 0x1B, 0xBA, 0x90,
  // "¥" (U+00A5)
  0xDF, 0xC7, 0xF6, 0x2F, 0x50, 0xB0, 0x0B, 0xB4, 0x50, 0x05, 0xFA, 0x00, 0x3B, 0xFE, 0xB0, 0x3B,
  0xFD, 0xB0, 0x00, 0xE9, 0x00, 0x0B, 0xFE, 0x70,
  // "¦" (U+00A6)
  0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82,
  // "§" (U+00A7)
  0x07, 0xCD, 0x30, 0xE0, 0x78, 0x0F, 0x30, 0x01, 0xCE, 0xA1, 0x4B, 0x1A, 0xC1, 0xDC, 0x5E, 0x01,
  0x9F, 0x90, 0x40, 0x5B, 0x1E, 0x13, 0x90, 0x8C, 0xA1,
  // "¨" (U+00A8)
  0x95, 0x85, 0x10, 0x00,
  // "©" (U+00A9)
  0x00, 0x6B, 0xB9, 0x20, 0x09, 0x68, 0x98, 0xB2, 0x28, 0x75, 0x07, 0x19, 0x64, 0xB2, 0x00, 0x0A,
  0x64, 0xC2, 0x00, 0x0A, 0x28, 0x87, 0x04, 0x19, 0x09, 0x7A, 0xB7, 0xB2, 0x00, 0x7B, 0xB9, 0x20,
  // "ª" (U+00AA)
  0x3C, 0xB5, 0x48, 0xB8, 0x7B, 0x9C,
  // "«" (U+00AB)
  0x04, 0x94, 0x92, 0xE4, 0xE2, 0x2E, 0x4E, 0x20, 0x49, 0x49,
  // "¬" (U+00AC)
  0x83, 0x4B, 0xBB, 0xC4, 0x0B, 0x40, 0x90,
  // "®" (U+00AE)
  0x00, 0x6B, 0xB9, 0x20, 0x09, 0xCA, 0x86, 0xB2, 0x28, 0x1B, 0x0C, 0x19, 0x64, 0x1B, 0x0C, 0x0A,
  0x64, 0x1D, 0xC3, 0x0A, 0x28, 0x1B, 0x58, 0x19, 0x09, 0xBA, 0x2B, 0xD2, 0x00, 0x7B, 0xB9, 0x20,
  // "¯" (U+00AF)
  0xBB, 0xBB, 0x70,
  // "°" (U+00B0)
  0x1A, 0xA1, 0x75, 0x57, 0x75, 0x57, 0x1B, 0xA1,
  // "±" (U+00B1)
  0x00, 0x82, 0x00, 0x08, 0x20, 0x4B, 0xDC, 0xA0, 0x08, 0x20, 0x00, 0x82, 0x04, 0xBB, 0xBA,
  // "²" (U+00B2)
  0x39, 0x91, 0x43, 0xB5, 0x01, 0xC0, 0x19, 0x13, 0x8C, 0xC7,
  // "³" (U+00B3)
  0x28, 0x81, 0x33, 0xB4, 0x07, 0xC1, 0x40, 0x87, 0x59, 0x81,
  // "´" (U+00B4)
  0x0D, 0x96, 0xA0,
  // "µ" (U+00B5)
  0x8D, 0x21, 0xF7, 0x0D, 0x90, 0x1F, 0x70, 0xD9, 0x01, 0xF7, 0x0D, 0x90, 0x1F, 0x70, 0xD9, 0x01,
  0xF9, 0x1F, 0xA0, 0x1C, 0xD9, 0x7E, 0x42, 0xA5, 0x81, 0x2E, 0x25, 0x0D, 0x06, 0x40,
  // "¶" (U+00B6)
  0x2D, 0xFD, 0xEB, 0x8F, 0xF5, 0xB0, 0x8F, 0xF5, 0xB0, 0x3F, 0xF5, 0xB0, 0x02, 0x85, 0xB0, 0x00,
  0x55, 0xB0, 0x00, 0x55, 0xB0, 0x00, 0x55, 0xB0, 0x00, 0x65, 0xB0, 0x03, 0xD4, 0xAA,
  // "·" (U+00B7)
  0x2B, 0x23, 0xE2,
  // "¸" (U+00B8)
  0x09, 0x20, 0x4B, 0x5C, 0x50,
  // "¹" (U+00B9)
  0x07, 0x70, 0x49, 0x90, 0x06, 0x90, 0x06, 0x90, 0x29, 0x93,
  // "º" (U+00BA)
  0x4B, 0xA8, 0x98, 0x2F, 0x4B, 0xA8,
  // "»" (U+00BB)
  0x1B, 0x2B, 0x00, 0x99, 0x99, 0x09, 0xA8, 0xA1, 0xB2, 0xB0,
  // "¼" (U+00BC)
  0x07, 0x70, 0x08, 0x40, 0x49, 0x90, 0x0B, 0x00, 0x06, 0x90, 0x65, 0x00, 0x06, 0x90, 0xB1, 0xB0,
  0x29, 0x97, 0x78, 0xE0, 0x00, 0x0B, 0x54, 0xE0, 0x00, 0x39, 0x88, 0xF7, 0x00, 0x92, 0x04, 0xB5,
  // "½" (U+00BD)
  0x07, 0x70, 0x08, 0x40, 0x04, 0x99, 0x00, 0xB0, 0x00, 0x06, 0x90, 0x65, 0x00, 0x00, 0x69, 0x0B,
  0x39, 0x91, 0x29, 0x97, 0x74, 0x3B, 0x50, 0x00, 0xB1, 0x01, 0xC0, 0x00, 0x39, 0x01, 0x91, 0x30,
  0x09, 0x20, 0x8C, 0xC7,
  // "¾" (U+00BE)
  0x28, 0x81, 0x08, 0x40, 0x33, 0xB4, 0x0B, 0x00, 0x07, 0xC1, 0x65, 0x00, 0x40, 0x88, 0xB1, 0xB0,
  0x59, 0x86, 0x78, 0xE0, 0x00, 0x0B, 0x54, 0xE0, 0x00, 0x39, 0x88, 0xF7, 0x00, 0x92, 0x04, 0xB5,
  // "¿" (U+00BF)
  0x02, 0xE3, 0x00, 0x1B, 0x30, 0x00, 0x40, 0x00, 0x1E, 0x00, 0x4E, 0x50, 0x0D, 0xB0, 0x00, 0xDB,
  0x0D, 0x73, 0xCC, 0xD3,
  // "À" (U+00C0)
  0x18, 0x14, 0xF3, 0x60, 0x50, 0xA7, 0x78, 0x11, 0xFA, 0x58, 0x15, 0xDE, 0x58, 0x2B, 0x6F, 0x43,
  0x83, 0x1D, 0x0F, 0x93, 0x83, 0x69, 0x0C, 0xE3, 0x87, 0xBB, 0xAC, 0xF4, 0x01, 0xD2, 0x87, 0x1F,
  0x90, 0xDF, 0x70, 0x9A, 0x06,
  // "Á" (U+00C1)
  0x40, 0xD0, 0x95, 0x06, 0x0A, 0x76, 0x81, 0x1F, 0xA5, 0x81, 0x5D, 0xE5, 0x82, 0xB6, 0xF4, 0x38,
  0x31, 0xD0, 0xF9, 0x38, 0x36, 0x90, 0xCE, 0x38, 0x7B, 0xBA, 0xCF, 0x40, 0x1D, 0x28, 0x71, 0xF9,
  0x0D, 0xF7, 0x09, 0xA0, 0x60,
  // "Â" (U+00C2)
  0x38, 0x1B, 0xE1, 0x48, 0x25, 0x94, 0xA7, 0x58, 0x11, 0xFA, 0x58, 0x15, 0xDE, 0x58, 0x2B, 0x6F,
  0x43, 0x83, 0x1D, 0x0F, 0x93, 0x83, 0x69, 0x0C, 0xE3, 0x87, 0xBB, 0xAC, 0xF4, 0x01, 0xD2, 0x87,
  0x1F, 0x90, 0xDF, 0x70, 0x9A, 0x06,
  // "Ã" (U+00C3)
  0x18, 0x32, 0xB8, 0x73, 0x38, 0x26, 0x29, 0xA7, 0x68, 0x11, 0xFA, 0x58, 0x15, 0xDE, 0x58, 0x2B,
  0x6F, 0x43, 0x83, 0x1D, 0x0F, 0x93, 0x83, 0x69, 0x0C, 0xE3, 0x87, 0xBB, 0xAC, 0xF4, 0x01, 0xD2,
  0x87, 0x1F, 0x90, 0xDF, 0x70, 0x9A, 0x06,
  // "Ä" (U+00C4)
  0x28, 0x29, 0x58, 0x54, 0x01, 0x78, 0x11, 0xFA, 0x58, 0x15, 0xDE, 0x58, 0x2B, 0x6F, 0x43, 0x83,
  0x1D, 0x0F, 0x93, 0x83, 0x69, 0x0C, 0xE3, 0x87, 0xBB, 0xAC, 0xF4, 0x01, 0xD2, 0x87, 0x1F, 0x90,
  0xDF, 0x70, 0x9A, 0x06,
  // "Å" (U+00C5)
  0x28, 0x11, 0xB8, 0x58, 0x15, 0x5A, 0x58, 0x11, 0xFB, 0x58, 0x15, 0xDE, 0x58, 0x2A, 0x6F, 0x43,
  0x83, 0x1D, 0x0F, 0x93, 0x83, 0x59, 0x0C, 0xE3, 0x87, 0xBB, 0xAC, 0xF4, 0x01, 0xD2, 0x87, 0x1F,
  0x90, 0xDF, 0x70, 0x9A, 0x06,
  // "Æ" (U+00C6)
  0x38, 0x5A, 0xEF, 0xCB, 0xE3, 0x38, 0x58, 0x9F, 0x30, 0x73, 0x28, 0x31, 0xB6, 0xF3, 0x58, 0x58,
  0x56, 0xFC, 0xB6, 0x38, 0x3C, 0x06, 0xF3, 0x48, 0x47, 0xDB, 0xDF, 0x34, 0x0C, 0x28, 0x96, 0x6F,
  0x30, 0x16, 0xCE, 0x42, 0xCF, 0xA9, 0xB8,
  // "Ç" (U+00C7)
  0x18, 0x31, 0xAC, 0xDA, 0x28, 0x7C, 0xB0, 0x2F, 0x23, 0xF5, 0x28, 0x32, 0x06, 0xF4, 0x48, 0x16,
  0xF4, 0x48, 0x13, 0xF5, 0x50, 0xC0, 0xB2, 0x86, 0x32, 0x01, 0xAD, 0xBA, 0x40, 0x60, 0x56, 0x0E,
  0x01, 0x38, 0x11, 0xB9, 0x20,
  // "È" (U+00C8)
  0x18, 0x14, 0xF3, 0x50, 0x50, 0xA7, 0x38, 0x46, 0xEE, 0x99, 0xD2, 0x00, 0xC2, 0x0A, 0x20, 0x0C,
  0x58, 0x3C, 0xEB, 0xB2, 0x20, 0x0C, 0x50, 0x0C, 0x20, 0x12, 0x00, 0xC2, 0x87, 0x92, 0x6E, 0xE9,
  0x9E, 0x20,
  // "É" (U+00C9)
  0x30, 0xD0, 0x94, 0x06, 0x0A, 0x73, 0x84, 0x6E, 0xE9, 0x9D, 0x20, 0x0C, 0x20, 0xA2, 0x00, 0xC5,
  0x83, 0xCE, 0xBB, 0x22, 0x00, 0xC5, 0x00, 0xC2, 0x01, 0x20, 0x0C, 0x28, 0x79, 0x26, 0xEE, 0x99,
  0xE2,
  // "Ê" (U+00CA)
  0x28, 0x1B, 0xE1, 0x38, 0x25, 0x94, 0xA7, 0x28, 0x46, 0xEE, 0x99, 0xD2, 0x00, 0xC2, 0x0A, 0x20,
  0x0C, 0x58, 0x3C, 0xEB, 0xB2, 0x20, 0x0C, 0x50, 0x0C, 0x20, 0x12, 0x00, 0xC2, 0x87, 0x92, 0x6E,
  0xE9, 0x9E, 0x20,
  // "Ë" (U+00CB)
  0x18, 0x29, 0x58, 0x53, 0x01, 0x58, 0x46, 0xEE, 0x99, 0xD2, 0x00, 0xC2, 0x0A, 0x20, 0x0C, 0x58,
  0x3C, 0xEB, 0xB2, 0x20, 0x0C, 0x50, 0x0C, 0x20, 0x12, 0x00, 0xC2, 0x87, 0x92, 0x6E, 0xE9, 0x9E,
  0x20,
  // "Ì" (U+00CC)
  0x4F, 0x30, 0x05, 0xA0, 0x00, 0x00, 0x8F, 0xF8, 0x0C, 0xC0, 0x0C, 0xC0, 0x0C, 0xC0, 0x0C, 0xC0,
  0x0C, 0xC0, 0x0C, 0xC0, 0x8F, 0xF8,
  // "Í" (U+00CD)
  0x00, 0xD9, 0x06, 0xA0, 0x00, 0x00, 0x8F, 0xF8, 0x0C, 0xC0, 0x0C, 0xC0, 0x0C, 0xC0, 0x0C, 0xC0,
  0x0C, 0xC0, 0x0C, 0xC0, 0x8F, 0xF8,
  // "Î" (U+00CE)
  0x0B, 0xE1, 0x59, 0x4A, 0x00, 0x00, 0x8F, 0xF8, 0x0C, 0xC0, 0x0C, 0xC0, 0x0C, 0xC0, 0x0C, 0xC0,
  0x0C, 0xC0, 0x0C, 0xC0, 0x8F, 0xF8,
  // "Ï" (U+00CF)
  0x95, 0x85, 0x10, 0x00, 0x8F, 0xF8, 0x0C, 0xC0, 0x0C, 0xC0, 0x0C, 0xC0, 0x0C, 0xC0, 0x0C, 0xC0,
  0x0C, 0xC0, 0x8F, 0xF8,
  // "Ð" (U+00D0)
  0x8F, 0xEC, 0xC7, 0x00, 0x0C, 0xC0, 0x3F, 0x70, 0x0C, 0xC0, 0x0B, 0xE0, 0x7E, 0xEB, 0x09, 0xF1,
  0x0C, 0xC0, 0x09, 0xF1, 0x0C, 0xC0, 0x0C, 0xD0, 0x0C, 0xC0, 0x4F, 0x60, 0x8F, 0xEC, 0xD6, 0x00,
  // "Ñ" (U+00D1)
  0x00, 0x2B, 0x87, 0x30, 0x00, 0x62, 0x9A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8F, 0xC0, 0x0B, 0xF8,
  0x0C, 0xF7, 0x00, 0xB0, 0x0B, 0xAE, 0x20, 0xB0, 0x0B, 0x1E, 0xB0, 0xB0, 0x0B, 0x06, 0xF5, 0xB0,
  0x0B, 0x00, 0xBE, 0xB0, 0x0B, 0x00, 0x2F, 0xC0, 0x8F, 0xB0, 0x07, 0xC0,
  // "Ò" (U+00D2)
  0x28, 0x14, 0xF3, 0x60, 0x50, 0xA7, 0x58, 0x31, 0xAC, 0xC9, 0x30, 0xC0, 0xB2, 0x84, 0xDA, 0x03,
  0xF5, 0x28, 0x47, 0xF1, 0x6F, 0x42, 0x84, 0x6F, 0x46, 0xF4, 0x28, 0x46, 0xF4, 0x3F, 0x52, 0x84,
  0x7F, 0x10, 0xCB, 0x20, 0xD0, 0xA2, 0x83, 0x1A, 0xCC, 0x92,
  // "Ó" (U+00D3)
  0x40, 0xD0, 0x95, 0x06, 0x0A, 0x75, 0x83, 0x1A, 0xCC, 0x93, 0x0C, 0x0B, 0x28, 0x4D, 0xA0, 0x3F,
  0x52, 0x84, 0x7F, 0x16, 0xF4, 0x28, 0x46, 0xF4, 0x6F, 0x42, 0x84, 0x6F, 0x43, 0xF5, 0x28, 0x47,
  0xF1, 0x0C, 0xB2, 0x0D, 0x0A, 0x28, 0x31, 0xAC, 0xC9, 0x20,
  // "Ô" (U+00D4)
  0x38, 0x1B, 0xE1, 0x48, 0x25, 0x94, 0xA7, 0x48, 0x31, 0xAC, 0xC9, 0x30, 0xC0, 0xB2, 0x84, 0xDA,
  0x03, 0xF5, 0x28, 0x47, 0xF1, 0x6F, 0x42, 0x84, 0x6F, 0x46, 0xF4, 0x28, 0x46, 0xF4, 0x3F, 0x52,
  0x84, 0x7F, 0x10, 0xCB, 0x20, 0xD0, 0xA2, 0x83, 0x1A, 0xCC, 0x92,
  // "Õ" (U+00D5)
  0x00, 0x2B, 0x87, 0x30, 0x00, 0x62, 0x9A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xAC, 0xC9, 0x00,
  0x0C, 0xB0, 0x0D, 0xA0, 0x3F, 0x50, 0x07, 0xF1, 0x6F, 0x40, 0x06, 0xF4, 0x6F, 0x40, 0x06, 0xF4,
  0x3F, 0x50, 0x07, 0xF1, 0x0C, 0xB0, 0x0D, 0xA0, 0x01, 0xAC, 0xC9, 0x00,
  // "Ö" (U+00D6)
  0x00, 0x95, 0x85, 0x00, 0x00, 0x10, 0x00, 0x00, 0x01, 0xAC, 0xC9, 0x00, 0x0C, 0xB0, 0x0D, 0xA0,
  0x3F, 0x50, 0x07, 0xF1, 0x6F, 0x40, 0x06, 0xF4, 0x6F, 0x40, 0x06, 0xF4, 0x3F, 0x50, 0x07, 0xF1,
  0x0C, 0xB0, 0x0D, 0xA0, 0x01, 0xAC, 0xC9, 0x00,
  // "×" (U+00D7)
  0x40, 0x04, 0x96, 0xA4, 0x0E, 0x80, 0xB4, 0x95, 0x20, 0x02,
  // "Ø" (U+00D8)
  0x01, 0xAC, 0xCD, 0x20, 0x0C, 0xB0, 0x3F, 0xA0, 0x3F, 0x50, 0x99, 0xF1, 0x6F, 0x42, 0x86, 0xF4,
  0x6F, 0x49, 0x16, 0xF4, 0x4F, 0x88, 0x07, 0xF1, 0x0D, 0xF1, 0x0D, 0xA0, 0x04, 0xDC, 0xC9, 0x00,
  0x03, 0x10, 0x00, 0x00,
  // "Ù" (U+00D9)
  0x28, 0x14, 0xF3, 0x60, 0x50, 0xA7, 0x40, 0xAA, 0x86, 0x73, 0xDD, 0x30, 0xEA, 0x20, 0x05, 0x20,
  0xE0, 0xA2, 0x00, 0x52, 0x0E, 0x0A, 0x20, 0x05, 0x20, 0xE0, 0xA2, 0x00, 0x52, 0x0D, 0x0A, 0x20,
  0x05, 0x20, 0xB0, 0xD2, 0x09, 0x03, 0x28, 0x32, 0xBD, 0xB8, 0x20,
  // "Ú" (U+00DA)
  0x40, 0xD0, 0x95, 0x06, 0x0A, 0x74, 0x0A, 0xA8, 0x67, 0x3D, 0xD3, 0x0E, 0xA2, 0x00, 0x52, 0x0E,
  0x0A, 0x20, 0x05, 0x20, 0xE0, 0xA2, 0x00, 0x52, 0x0E, 0x0A, 0x20, 0x05, 0x20, 0xD0, 0xA2, 0x00,
  0x52, 0x0B, 0x0D, 0x20, 0x90, 0x32, 0x83, 0x2B, 0xDB, 0x82,
  // "Û" (U+00DB)
  0x00, 0x0B, 0xE1, 0x00, 0x00, 0x59, 0x4A, 0x00, 0x00, 0x00, 0x00, 0x00, 0xAF, 0xF7, 0x3D, 0xD3,
  0x0E, 0xA0, 0x05, 0x50, 0x0E, 0xA0, 0x05, 0x50, 0x0E, 0xA0, 0x05, 0x50, 0x0E, 0xA0, 0x05, 0x50,
  0x0D, 0xA0, 0x05, 0x50, 0x0B, 0xD0, 0x09, 0x30, 0x02, 0xBD, 0xB8, 0x00,
  // "Ü" (U+00DC)
  0x00, 0x95, 0x85, 0x00, 0x00, 0x10, 0x00, 0x00, 0xAF, 0xF7, 0x3D, 0xD3, 0x0E, 0xA0, 0x05, 0x50,
  0x0E, 0xA0, 0x05, 0x50, 0x0E, 0xA0, 0x05, 0x50, 0x0E, 0xA0, 0x05, 0x50, 0x0D, 0xA0, 0x05, 0x50,
  0x0B, 0xD0, 0x09, 0x30, 0x02, 0xBD, 0xB8, 0x00,
  // "Ý" (U+00DD)
  0x40, 0xD0, 0x94, 0x06, 0x0A, 0x72, 0x89, 0x0D, 0xFE, 0x48, 0xFC, 0x1F, 0xA2, 0x86, 0xC1, 0x09,
  0xE1, 0x38, 0x28, 0x31, 0xF7, 0x91, 0x38, 0x19, 0xE8, 0x48, 0x14, 0xF4, 0x48, 0x15, 0xF4, 0x38,
  0x34, 0xDF, 0xD3, 0x10,
  // "Þ" (U+00DE)
  0x8F, 0xF8, 0x00, 0x0C, 0xEC, 0xA1, 0x0C, 0xC0, 0xDB, 0x0C, 0xC0, 0x9F, 0x0C, 0xC0, 0x9F, 0x0C,
  0xC0, 0xDA, 0x0C, 0xEC, 0x91, 0x8F, 0xF8, 0x00,
  // "ß" (U+00DF)
  0x04, 0xC9, 0xB5, 0x00, 0xE9, 0x05, 0xE0, 0x9F, 0x87, 0xC8, 0x00, 0xF8, 0xD8, 0x00, 0x0F, 0x89,
  0xF9, 0x00, 0xF8, 0x07, 0xF7, 0x0F, 0x9B, 0x0B, 0x99, 0xF8, 0xAA, 0xC2,
  // "à" (U+00E0)
  0x04, 0xF3, 0x00, 0x00, 0x5A, 0x00, 0x00, 0x00, 0x00, 0x0B, 0xDD, 0x70, 0x08, 0x28, 0xF0, 0x09,
  0xCD, 0xF0, 0x7F, 0x27, 0xF0, 0x7F, 0x09, 0xF0, 0x1D, 0xB7, 0xF8,
  // "á" (U+00E1)
  0x30, 0xD0, 0x93, 0x06, 0x0A, 0x72, 0x82, 0xBD, 0xD7, 0x28, 0x18, 0x28, 0x92, 0x8A, 0x59, 0xCD,
  0xF0, 0x7F, 0x27, 0xF0, 0x7F, 0x09, 0xF0, 0x1D, 0xB7, 0xF8,
  // "â" (U+00E2)
  0x00, 0xBE, 0x10, 0x05, 0x94, 0xA0, 0x00, 0x00, 0x00, 0x0B, 0xDD, 0x70, 0x08, 0x28, 0xF0, 0x09,
  0xCD, 0xF0, 0x7F, 0x27, 0xF0, 0x7F, 0x09, 0xF0, 0x1D, 0xB7, 0xF8,
  // "ã" (U+00E3)
  0x02, 0xB8, 0x73, 0x06, 0x29, 0xA0, 0x00, 0x00, 0x00, 0x0B, 0xDD, 0x70, 0x08, 0x28, 0xF0, 0x09,
  0xCD, 0xF0, 0x7F, 0x27, 0xF0, 0x7F, 0x09, 0xF0, 0x1D, 0xB7, 0xF8,
  // "ä" (U+00E4)
  0x09, 0x58, 0x50, 0x01, 0x00, 0x00, 0x0B, 0xDD, 0x70, 0x08, 0x28, 0xF0, 0x09, 0xCD, 0xF0, 0x7F,
  0x27, 0xF0, 0x7F, 0x09, 0xF0, 0x1D, 0xB7, 0xF8,
  // "å" (U+00E5)
  0x03, 0xB6, 0x00, 0x07, 0x2A, 0x00, 0x03, 0xB6, 0x00, 0x0B, 0xDD, 0x70, 0x08, 0x28, 0xF0, 0x09,
  0xCD, 0xF0, 0x7F, 0x27, 0xF0, 0x7F, 0x09, 0xF0, 0x1D, 0xB7, 0xF8,
  // "æ" (U+00E6)
  0x0B, 0xDC, 0x7C, 0xC7, 0x00, 0x82, 0x8F, 0x34, 0xF2, 0x09, 0xCD, 0xFB, 0xCD, 0x47, 0xF2, 0x7F,
  0x10, 0x00, 0x7F, 0x09, 0xF5, 0x05, 0x01, 0xDB, 0x76, 0xDB, 0x90,
  // "ç" (U+00E7)
  0x08, 0xDD, 0x74, 0xF3, 0x7B, 0x7F, 0x00, 0x07, 0xF0, 0x00, 0x4F, 0x30, 0x40, 0x8D, 0xB7, 0x00,
  0x92, 0x00, 0x04, 0xB0, 0x05, 0xC5, 0x00,
  // "è" (U+00E8)
  0x18, 0x14, 0xF3, 0x40, 0x50, 0xA7, 0x28, 0xA2, 0x7C, 0xC6, 0x03, 0xF2, 0x5F, 0x27, 0xFB, 0xCD,
  0x37, 0xF1, 0x38, 0x33, 0xF5, 0x05, 0x28, 0x27, 0xDB, 0x91,
  // "é" (U+00E9)
  0x30, 0xD0, 0x93, 0x06, 0x0A, 0x72, 0x8A, 0x27, 0xCC, 0x60, 0x3F, 0x25, 0xF2, 0x7F, 0xBC, 0xD3,
  0x7F, 0x13, 0x83, 0x3F, 0x50, 0x52, 0x82, 0x7D, 0xB9, 0x10,
  // "ê" (U+00EA)
  0x00, 0xBE, 0x10, 0x05, 0x94, 0xA0, 0x00, 0x00, 0x00, 0x07, 0xCC, 0x60, 0x3F, 0x25, 0xF2, 0x7F,
  0xBC, 0xD3, 0x7F, 0x10, 0x00, 0x3F, 0x50, 0x50, 0x07, 0xDB, 0x90,
  // "ë" (U+00EB)
  0x09, 0x58, 0x50, 0x01, 0x00, 0x00, 0x07, 0xCC, 0x60, 0x3F, 0x25, 0xF2, 0x7F, 0xBC, 0xD3, 0x7F,
  0x10, 0x00, 0x3F, 0x50, 0x50, 0x07, 0xDB, 0x90,
  // "ì" (U+00EC)
  0x4F, 0x30, 0x05, 0xA0, 0x00, 0x00, 0xAF, 0x80, 0x0F, 0x80, 0x0F, 0x80, 0x0F, 0x80, 0x0F, 0x80,
  0xAF, 0xE4,
  // "í" (U+00ED)
  0x00, 0xD9, 0x06, 0xA0, 0x00, 0x00, 0xAF, 0x80, 0x0F, 0x80, 0x0F, 0x80, 0x0F, 0x80, 0x0F, 0x80,
  0xAF, 0xE4,
  // "î" (U+00EE)
  0x18, 0x6B, 0xE1, 0x05, 0x94, 0xA7, 0x81, 0xAF, 0x83, 0x90, 0x83, 0x90, 0x83, 0x90, 0x83, 0x90,
  0x82, 0x82, 0xAF, 0xE4,
  // "ï" (U+00EF)
  0x95, 0x85, 0x10, 0x00, 0xAF, 0x80, 0x0F, 0x80, 0x0F, 0x80, 0x0F, 0x80, 0x0F, 0x80, 0xAF, 0xE4,
  // "ð" (U+00F0)
  0x05, 0x51, 0x40, 0x01, 0xCF, 0x40, 0x02, 0x46, 0xB0, 0x08, 0xDC, 0xF4, 0x4F, 0x31, 0xF8, 0x7F,
  0x00, 0xE9, 0x7F, 0x00, 0xE8, 0x3F, 0x31, 0xF4, 0x07, 0xCC, 0x80,
  // "ñ" (U+00F1)
  0x02, 0xB8, 0x73, 0x00, 0x62, 0x9A, 0x00, 0x00, 0x00, 0x00, 0x09, 0xFA, 0xCE, 0x30, 0x0F, 0xA0,
  0xE9, 0x00, 0xF8, 0x0C, 0xA0, 0x0F, 0x80, 0xCA, 0x00, 0xF8, 0x0C, 0xB0, 0xAF, 0xE3, 0xCF, 0x50,
  // "ò" (U+00F2)
  0x04, 0xF3, 0x00, 0x00, 0x5A, 0x00, 0x00, 0x00, 0x00, 0x07, 0xCC, 0x80, 0x3F, 0x31, 0xF5, 0x7F,
  0x00, 0xE9, 0x7F, 0x00, 0xE9, 0x3F, 0x31, 0xF5, 0x07, 0xCC, 0x90,
  // "ó" (U+00F3)
  0x00, 0x0D, 0x90, 0x00, 0x6A, 0x00, 0x00, 0x00, 0x00, 0x07, 0xCC, 0x80, 0x3F, 0x31, 0xF5, 0x7F,
  0x00, 0xE9, 0x7F, 0x00, 0xE9, 0x3F, 0x31, 0xF5, 0x07, 0xCC, 0x90,
  // "ô" (U+00F4)
  0x00, 0xBE, 0x10, 0x05, 0x94, 0xA0, 0x00, 0x00, 0x00, 0x07, 0xCC, 0x80, 0x3F, 0x31, 0xF5, 0x7F,
  0x00, 0xE9, 0x7F, 0x00, 0xE9, 0x3F, 0x31, 0xF5, 0x07, 0xCC, 0x90,
  // "õ" (U+00F5)
  0x02, 0xB8, 0x73, 0x06, 0x29, 0xA0, 0x00, 0x00, 0x00, 0x07, 0xCC, 0x80, 0x3F, 0x31, 0xF5, 0x7F,
  0x00, 0xE9, 0x7F, 0x00, 0xE9, 0x3F, 0x31, 0xF5, 0x07, 0xCC, 0x90,
  // "ö" (U+00F6)
  0x09, 0x58, 0x50, 0x01, 0x00, 0x00, 0x07, 0xCC, 0x80, 0x3F, 0x31, 0xF5, 0x7F, 0x00, 0xE9, 0x7F,
  0x00, 0xE9, 0x3F, 0x31, 0xF5, 0x07, 0xCC, 0x90,
  // "÷" (U+00F7)
  0x20, 0x90, 0x33, 0x01, 0x28, 0x34, 0xBB, 0xBA, 0x70, 0x90, 0x33, 0x01, 0x20,
  // "ø" (U+00F8)
  0x48, 0xC3, 0x31, 0x07, 0xCC, 0xD0, 0x3F, 0x36, 0xF5, 0x7F, 0x1A, 0xE8, 0x7F, 0x82, 0xE9, 0x4F,
  0x81, 0xF5, 0x0C, 0xCC, 0x92, 0x04, 0x40,
  // "ù" (U+00F9)
  0x18, 0x14, 0xF3, 0x50, 0x50, 0xA7, 0x38, 0x49, 0xF7, 0x7F, 0xA2, 0x98, 0x27, 0x0D, 0xA2, 0x98,
  0x27, 0x0D, 0xA2, 0x98, 0x27, 0x0D, 0xA2, 0x98, 0x29, 0x0E, 0xA2, 0x84, 0x7E, 0xAC, 0xF5,
  // "ú" (U+00FA)
  0x30, 0xD0, 0x94, 0x06, 0x0A, 0x73, 0x84, 0x9F, 0x77, 0xFA, 0x29, 0x82, 0x70, 0xDA, 0x29, 0x82,
  0x70, 0xDA, 0x29, 0x82, 0x70, 0xDA, 0x29, 0x82, 0x90, 0xEA, 0x28, 0x47, 0xEA, 0xCF, 0x50,
  // "û" (U+00FB)
  0x00, 0xBE, 0x10, 0x00, 0x59, 0x4A, 0x00, 0x00, 0x00, 0x00, 0x09, 0xF7, 0x7F, 0xA0, 0x0F, 0x70,
  0xDA, 0x00, 0xF7, 0x0D, 0xA0, 0x0F, 0x70, 0xDA, 0x00, 0xF9, 0x0E, 0xA0, 0x07, 0xEA, 0xCF, 0x50,
  // "ü" (U+00FC)
  0x09, 0x58, 0x50, 0x00, 0x10, 0x00, 0x00, 0x9F, 0x77, 0xFA, 0x00, 0xF7, 0x0D, 0xA0, 0x0F, 0x70,
  0xDA, 0x00, 0xF7, 0x0D, 0xA0, 0x0F, 0x90, 0xEA, 0x00, 0x7E, 0xAC, 0xF5,
  // "ý" (U+00FD)
  0x30, 0xD0, 0x93, 0x06, 0x0A, 0x71, 0x89, 0x1E, 0xFB, 0x5F, 0xB3, 0xF4, 0x0B, 0x28, 0x2D, 0x91,
  0xA2, 0x82, 0x7E, 0x55, 0x28, 0x22, 0xFD, 0x13, 0x0C, 0x0B, 0x40, 0x90, 0x63, 0x81, 0x3E, 0x12,
  0x81, 0x8D, 0x53,
  // "þ" (U+00FE)
  0xAF, 0x70, 0x00, 0x1F, 0x70, 0x00, 0x0F, 0xAB, 0xD3, 0x0F, 0xA0, 0xBB, 0x0F, 0x70, 0x9E, 0x0F,
  0x70, 0x9E, 0x0F, 0xA0, 0xBC, 0x0F, 0xAB, 0xD3, 0x0F, 0x70, 0x00, 0x1F, 0x80, 0x00, 0xBF, 0xE4,
  0x00,
  // "ÿ" (U+00FF)
  0x09, 0x58, 0x50, 0x01, 0x00, 0x00, 0xEF, 0xB5, 0xFB, 0x3F, 0x40, 0xB0, 0x0D, 0x91, 0xA0, 0x07,
  0xE5, 0x50, 0x02, 0xFD, 0x10, 0x00, 0xCB, 0x00, 0x00, 0x96, 0x00, 0x03, 0xE1, 0x00, 0x8D, 0x50,
  0x00,
  // "Ā" (U+0100)
  0x28, 0x26, 0xBB, 0x37, 0x58, 0x11, 0xFA, 0x58, 0x15, 0xDE, 0x58, 0x2B, 0x6F, 0x43, 0x83, 0x1D,
  0x0F, 0x93, 0x83, 0x69, 0x0C, 0xE3, 0x87, 0xBB, 0xAC, 0xF4, 0x01, 0xD2, 0x87, 0x1F, 0x90, 0xDF,
  0x70, 0x9A, 0x06,
  // "ā" (U+0101)
  0x06, 0xBB, 0x30, 0x00, 0x00, 0x00, 0x0B, 0xDD, 0x70, 0x08, 0x28, 0xF0, 0x09, 0xCD, 0xF0, 0x7F,
  0x27, 0xF0, 0x7F, 0x09, 0xF0, 0x1D, 0xB7, 0xF8,
  // "Ă" (U+0102)
  0x28, 0x25, 0x22, 0x44, 0x82, 0x1B, 0xB1, 0x75, 0x81, 0x1F, 0xA5, 0x81, 0x5D, 0xE5, 0x82, 0xB6,
  0xF4, 0x38, 0x31, 0xD0, 0xF9, 0x38, 0x36, 0x90, 0xCE, 0x38, 0x7B, 0xBA, 0xCF, 0x40, 0x1D, 0x28,
  0x71, 0xF9, 0x0D, 0xF7, 0x09, 0xA0, 0x60,
  // "ă" (U+0103)
  0x05, 0x22, 0x40, 0x01, 0xBB, 0x10, 0x00, 0x00, 0x00, 0x0B, 0xDD, 0x70, 0x08, 0x28, 0xF0, 0x09,
  0xCD, 0xF0, 0x7F, 0x27, 0xF0, 0x7F, 0x09, 0xF0, 0x1D, 0xB7, 0xF8,
  // "Ą" (U+0104)
  0x28, 0x11, 0xFA, 0x58, 0x15, 0xDE, 0x58, 0x2B, 0x6F, 0x43, 0x83, 0x1D, 0x0F, 0x93, 0x83, 0x69,
  0x0C, 0xE3, 0x87, 0xBB, 0xAC, 0xF4, 0x01, 0xD2, 0x87, 0x1F, 0x90, 0xDF, 0x70, 0x9A, 0x06, 0x50,
  0x66, 0x06, 0x09, 0x68, 0x13, 0xC9, 0x10,
  // "ą" (U+0105)
  0x0B, 0xDD, 0x70, 0x08, 0x28, 0xF0, 0x09, 0xCD, 0xF0, 0x7F, 0x27, 0xF0, 0x7F, 0x09, 0xF0, 0x1D,
  0xB7, 0xF8, 0x00, 0x06, 0x00, 0x00, 0x69, 0x00, 0x00, 0x3C, 0x90,
  // "Ć" (U+0106)
  0x40, 0xD0, 0x94, 0x06, 0x0A, 0x73, 0x83, 0x1A, 0xCD, 0xA2, 0x87, 0xCB, 0x02, 0xF2, 0x3F, 0x52,
  0x83, 0x20, 0x6F, 0x44, 0x81, 0x6F, 0x44, 0x81, 0x3F, 0x55, 0x0C, 0x0B, 0x28, 0x63, 0x20, 0x1A,
  0xDB, 0xA1,
  // "ć" (U+0107)
  0x30, 0xD0, 0x92, 0x06, 0x0A, 0x78, 0x90, 0x8D, 0xD7, 0x4F, 0x37, 0xB7, 0x93, 0x07, 0x93, 0x89,
  0x04, 0xF3, 0x04, 0x08, 0xDB, 0x70,
  // "Ĉ" (U+0108)
  0x38, 0x1B, 0xE1, 0x38, 0x25, 0x94, 0xA7, 0x28, 0x31, 0xAC, 0xDA, 0x28, 0x7C, 0xB0, 0x2F, 0x23,
  0xF5, 0x28, 0x32, 0x06, 0xF4, 0x48, 0x16, 0xF4, 0x48, 0x13, 0xF5, 0x50, 0xC0, 0xB2, 0x86, 0x32,
  0x01, 0xAD, 0xBA, 0x10,
  // "ĉ" (U+0109)
  0x28, 0x6B, 0xE1, 0x05, 0x94, 0xA6, 0x89, 0x08, 0xDD, 0x74, 0xF3, 0x7B, 0x79, 0x30, 0x79, 0x38,
  0x90, 0x4F, 0x30, 0x40, 0x8D, 0xB7,
  // "Ċ" (U+010A)
  0x30, 0x50, 0xB5, 0x06, 0x0D, 0x73, 0x83, 0x1A, 0xCD, 0xA2, 0x87, 0xCB, 0x02, 0xF2, 0x3F, 0x52,
  0x83, 0x20, 0x6F, 0x44, 0x81, 0x6F, 0x44, 0x81, 0x3F, 0x55, 0x0C, 0x0B, 0x28, 0x63, 0x20, 0x1A,
  0xDB, 0xA1,
  // "ċ" (U+010B)
  0x20, 0x50, 0xB3, 0x06, 0x0D, 0x78, 0x90, 0x8D, 0xD7, 0x4F, 0x37, 0xB7, 0x93, 0x07, 0x93, 0x89,
  0x04, 0xF3, 0x04, 0x08, 0xDB, 0x70,
  // "Č" (U+010C)
  0x28, 0x25, 0x84, 0xA4, 0x81, 0xBE, 0x27, 0x28, 0x31, 0xAC, 0xDA, 0x28, 0x7C, 0xB0, 0x2F, 0x23,
  0xF5, 0x28, 0x32, 0x06, 0xF4, 0x48, 0x16, 0xF4, 0x48, 0x13, 0xF5, 0x50, 0xC0, 0xB2, 0x86, 0x32,
  0x01, 0xAD, 0xBA, 0x10,
  // "č" (U+010D)
  0x05, 0x84, 0xA0, 0x0B, 0xE2, 0x00, 0x00, 0x00, 0x8D, 0xD7, 0x4F, 0x37, 0xB7, 0xF0, 0x00, 0x7F,
  0x00, 0x04, 0xF3, 0x04, 0x08, 0xDB, 0x70,
  // "Ď" (U+010E)
  0x18, 0x25, 0x84, 0xA5, 0x81, 0xBE, 0x27, 0x48, 0x48, 0xFE, 0xCC, 0x73, 0x84, 0xCC, 0x03, 0xF7,
  0x20, 0x0C, 0x20, 0xB0, 0xE2, 0x00, 0xC2, 0x84, 0x9F, 0x10, 0xCC, 0x28, 0x49, 0xF1, 0x0C, 0xC2,
  0x0C, 0x0D, 0x28, 0x93, 0xCC, 0x04, 0xF6, 0x08, 0xFE, 0xCD, 0x62,
  // "ď" (U+010F)
  0x00, 0x0C, 0xF7, 0xA6, 0x00, 0x00, 0xF7, 0xA0, 0x0A, 0xD8, 0xF7, 0x00, 0x5F, 0x33, 0xF7, 0x00,
  0x7F, 0x01, 0xF7, 0x00, 0x7F, 0x01, 0xF7, 0x00, 0x5F, 0x23, 0xF7, 0x00, 0x0A, 0xD8, 0xBE, 0x40,
  // "Đ" (U+0110)
  0x8F, 0xEC, 0xC7, 0x00, 0x0C, 0xC0, 0x3F, 0x70, 0x0C, 0xC0, 0x0B, 0xE0, 0x7E, 0xEB, 0x09, 0xF1,
  0x0C, 0xC0, 0x09, 0xF1, 0x0C, 0xC0, 0x0C, 0xD0, 0x0C, 0xC0, 0x4F, 0x60, 0x8F, 0xEC, 0xD6, 0x00,
  // "đ" (U+0111)
  0x00, 0x0B, 0xF7, 0x00, 0x06, 0xBF, 0xD4, 0x0A, 0xD8, 0xF7, 0x05, 0xF3, 0x3F, 0x70, 0x7F, 0x01,
  0xF7, 0x07, 0xF0, 0x1F, 0x70, 0x5F, 0x23, 0xF7, 0x00, 0xAD, 0x8B, 0xE4,
  // "Ē" (U+0112)
  0x18, 0x26, 0xBB, 0x37, 0x28, 0x46, 0xEE, 0x99, 0xD2, 0x00, 0xC2, 0x0A, 0x20, 0x0C, 0x58, 0x3C,
  0xEB, 0xB2, 0x20, 0x0C, 0x50, 0x0C, 0x20, 0x12, 0x00, 0xC2, 0x87, 0x92, 0x6E, 0xE9, 0x9E, 0x20,
  // "ē" (U+0113)
  0x06, 0xBB, 0x30, 0x00, 0x00, 0x00, 0x07, 0xCC, 0x60, 0x3F, 0x25, 0xF2, 0x7F, 0xBC, 0xD3, 0x7F,
  0x10, 0x00, 0x3F, 0x50, 0x50, 0x07, 0xDB, 0x90,
  // "Ĕ" (U+0114)
  0x18, 0x25, 0x22, 0x43, 0x82, 0x1B, 0xB1, 0x72, 0x84, 0x6E, 0xE9, 0x9D, 0x20, 0x0C, 0x20, 0xA2,
  0x00, 0xC5, 0x83, 0xCE, 0xBB, 0x22, 0x00, 0xC5, 0x00, 0xC2, 0x01, 0x20, 0x0C, 0x28, 0x79, 0x26,
  0xEE, 0x99, 0xE2,
  // "ĕ" (U+0115)
  0x05, 0x22, 0x40, 0x01, 0xBB, 0x10, 0x00, 0x00, 0x00, 0x07, 0xCC, 0x60, 0x3F, 0x25, 0xF2, 0x7F,
  0xBC, 0xD3, 0x7F, 0x10, 0x00, 0x3F, 0x50, 0x50, 0x07, 0xDB, 0x90,
  // "Ė" (U+0116)
  0x20, 0x50, 0xB5, 0x06, 0x0D, 0x73, 0x84, 0x6E, 0xE9, 0x9D, 0x20, 0x0C, 0x20, 0xA2, 0x00, 0xC5,
  0x83, 0xCE, 0xBB, 0x22, 0x00, 0xC5, 0x00, 0xC2, 0x01, 0x20, 0x0C, 0x28, 0x79, 0x26, 0xEE, 0x99,
  0xE2,
  // "ė" (U+0117)
  0x20, 0x50, 0xB4, 0x06, 0x0D, 0x72, 0x8A, 0x27, 0xCC, 0x60, 0x3F, 0x25, 0xF2, 0x7F, 0xBC, 0xD3,
  0x7F, 0x13, 0x83, 0x3F, 0x50, 0x52, 0x82, 0x7D, 0xB9, 0x10,
  // "Ę" (U+0118)
  0x84, 0x6E, 0xE9, 0x9D, 0x20, 0x0C, 0x20, 0xA2, 0x00, 0xC5, 0x83, 0xCE, 0xBB, 0x22, 0x00, 0xC5,
  0x00, 0xC2, 0x01, 0x20, 0x0C, 0x28, 0x79, 0x26, 0xEE, 0x99, 0xE2, 0x40, 0x40, 0x24, 0x01, 0x0E,
  0x68, 0x1B, 0xC1,
  // "ę" (U+0119)
  0x07, 0xDC, 0x40, 0x3F, 0x46, 0xE0, 0x7F, 0x14, 0xF3, 0x7F, 0xBC, 0xD3, 0x3F, 0x20, 0x10, 0x07,
  0xDC, 0xD0, 0x00, 0x4C, 0x20, 0x00, 0xA5, 0x00, 0x00, 0x5D, 0x60,
  // "Ě" (U+011A)
  0x18, 0x25, 0x84, 0xA4, 0x81, 0xBE, 0x27, 0x28, 0x46, 0xEE, 0x99, 0xD2, 0x00, 0xC2, 0x0A, 0x20,
  0x0C, 0x58, 0x3C, 0xEB, 0xB2, 0x20, 0x0C, 0x50, 0x0C, 0x20, 0x12, 0x00, 0xC2, 0x87, 0x92, 0x6E,
  0xE9, 0x9E, 0x20,
  // "ě" (U+011B)
  0x05, 0x84, 0xA0, 0x00, 0xBE, 0x20, 0x00, 0x00, 0x00, 0x07, 0xCC, 0x60, 0x3F, 0x25, 0xF2, 0x7F,
  0xBC, 0xD3, 0x7F, 0x10, 0x00, 0x3F, 0x50, 0x50, 0x07, 0xDB, 0x90,
  // "Ĝ" (U+011C)
  0x38, 0x1B, 0xE1, 0x48, 0x25, 0x94, 0xA7, 0x58, 0x39, 0xCC, 0xD4, 0x20, 0xB0, 0xC2, 0x84, 0xAA,
  0x03, 0xF6, 0x20, 0x12, 0x81, 0x6F, 0x45, 0x89, 0x16, 0xF4, 0x09, 0xDD, 0x43, 0xF6, 0x20, 0xE0,
  0xB2, 0x00, 0xC2, 0x0D, 0x0A, 0x28, 0x41, 0x9D, 0xBC, 0x51,
  // "ĝ" (U+011D)
  0x0B, 0xE1, 0x00, 0x59, 0x4A, 0x00, 0x00, 0x00, 0x00, 0x0A, 0xCD, 0x74, 0x5E, 0x0D, 0x60, 0x7D,
  0x0B, 0x90, 0x4F, 0x0D, 0x60, 0x0C, 0xEB, 0x00, 0x3E, 0xFF, 0xC0, 0xC5, 0x01, 0xF3, 0xE4, 0x02,
  0xF1, 0x5C, 0xBC, 0x50,
  // "Ğ" (U+011E)
  0x28, 0x25, 0x22, 0x44, 0x82, 0x1B, 0xB1, 0x75, 0x83, 0x9C, 0xCD, 0x42, 0x0B, 0x0C, 0x28, 0x4A,
  0xA0, 0x3F, 0x62, 0x01, 0x28, 0x16, 0xF4, 0x58, 0x91, 0x6F, 0x40, 0x9D, 0xD4, 0x3F, 0x62, 0x0E,
  0x0B, 0x20, 0x0C, 0x20, 0xD0, 0xA2, 0x84, 0x19, 0xDB, 0xC5, 0x10,
  // "ğ" (U+011F)
  0x05, 0x22, 0x40, 0x01, 0xBB, 0x10, 0x00, 0x00, 0x00, 0x0A, 0xCD, 0x74, 0x5E, 0x0D, 0x60, 0x7D,
  0x0B, 0x90, 0x4F, 0x0D, 0x60, 0x0C, 0xEB, 0x00, 0x3E, 0xFF, 0xC0, 0xC5, 0x01, 0xF3, 0xE4, 0x02,
  0xF1, 0x5C, 0xBC, 0x50,
  // "Ġ" (U+0120)
  0x30, 0x50, 0xB6, 0x06, 0x0D, 0x76, 0x83, 0x9C, 0xCD, 0x42, 0x0B, 0x0C, 0x28, 0x4A, 0xA0, 0x3F,
  0x62, 0x01, 0x28, 0x16, 0xF4, 0x58, 0x91, 0x6F, 0x40, 0x9D, 0xD4, 0x3F, 0x62, 0x0E, 0x0B, 0x20,
  0x0C, 0x20, 0xD0, 0xA2, 0x84, 0x19, 0xDB, 0xC5, 0x10,
  // "ġ" (U+0121)
  0x05, 0xB0, 0x00, 0x06, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x0A, 0xCD, 0x74, 0x5E, 0x0D, 0x60, 0x7D,
  0x0B, 0x90, 0x4F, 0x0D, 0x60, 0x0C, 0xEB, 0x00, 0x3E, 0xFF, 0xC0, 0xC5, 0x01, 0xF3, 0xE4, 0x02,
  0xF1, 0x5C, 0xBC, 0x50,
  // "Ģ" (U+0122)
  0x00, 0x9C, 0xCD, 0x40, 0x0B, 0xC0, 0x0A, 0xA0, 0x3F, 0x60, 0x01, 0x00, 0x6F, 0x40, 0x00, 0x00,
  0x6F, 0x40, 0x9D, 0xD4, 0x3F, 0x60, 0x0E, 0xB0, 0x0C, 0xC0, 0x0D, 0xA0, 0x01, 0x9D, 0xBC, 0x50,
  0x00, 0x06, 0x80, 0x00, 0x00, 0x0A, 0x20, 0x00,
  // "ģ" (U+0123)
  0x00, 0x47, 0x00, 0x00, 0xA3, 0x00, 0x0A, 0xCD, 0x74, 0x5E, 0x0D, 0x60, 0x7D, 0x0B, 0x90, 0x4F,
  0x0D, 0x60, 0x0C, 0xEB, 0x00, 0x3E, 0xFF, 0xC0, 0xC5, 0x01, 0xF3, 0xE4, 0x02, 0xF1, 0x5C, 0xBC,
  0x50,
  // "Ĥ" (U+0124)
  0x38, 0x1B, 0xE1, 0x48, 0x25, 0x94, 0xA7, 0x30, 0x8A, 0x86, 0x86, 0xEF, 0xB0, 0xCC, 0x20, 0x99,
  0x20, 0x0C, 0x20, 0x99, 0x28, 0x3C, 0xEB, 0xBD, 0x92, 0x00, 0xC2, 0x09, 0x92, 0x00, 0xC2, 0x09,
  0x92, 0x00, 0xC2, 0x82, 0x9F, 0x08, 0xA8, 0x38, 0x6E, 0xFB,
  // "ĥ" (U+0125)
  0x28, 0x1B, 0xE1, 0x38, 0x25, 0x94, 0xA7, 0x28, 0x18, 0xF8, 0x59, 0x07, 0x59, 0x82, 0xBC, 0xD3,
  0x29, 0x82, 0xA0, 0xE9, 0x29, 0x82, 0x80, 0xCA, 0x29, 0x82, 0x80, 0xCA, 0x29, 0x89, 0x28, 0x0C,
  0xB0, 0x8F, 0xD2, 0xCE, 0x30,
  // "Ħ" (U+0126)
  0x8F, 0xF8, 0x6E, 0xFB, 0x0C, 0xC0, 0x09, 0xF0, 0x9E, 0xEB, 0xBD, 0xFB, 0x0C, 0xEB, 0xBD, 0xF0,
  0x0C, 0xC0, 0x09, 0xF0, 0x0C, 0xC0, 0x09, 0xF0, 0x0C, 0xC0, 0x09, 0xF0, 0x8F, 0xF8, 0x6E, 0xFB,
  // "ħ" (U+0127)
  0x8F, 0x80, 0x00, 0x07, 0xFC, 0x90, 0x00, 0x0F, 0xBB, 0xD3, 0x00, 0xFA, 0x0E, 0x90, 0x0F, 0x80,
  0xCA, 0x00, 0xF8, 0x0C, 0xA0, 0x0F, 0x80, 0xCB, 0x08, 0xFD, 0x2C, 0xE3,
  // "Ĩ" (U+0128)
  0x87, 0x2B, 0x87, 0x36, 0x29, 0xA6, 0x08, 0xA0, 0x82, 0x00, 0xC3, 0x00, 0xC3, 0x00, 0xC3, 0x00,
  0xC3, 0x00, 0xC3, 0x00, 0xC2, 0x08, 0xA0, 0x81,
  // "ĩ" (U+0129)
  0x87, 0x2B, 0x87, 0x36, 0x29, 0xA7, 0x81, 0xAF, 0x83, 0x90, 0x83, 0x90, 0x83, 0x90, 0x83, 0x90,
  0x82, 0x82, 0xAF, 0xE4,
  // "Ī" (U+012A)
  0x6B, 0xB3, 0x00, 0x00, 0x8F, 0xF8, 0x0C, 0xC0, 0x0C, 0xC0, 0x0C, 0xC0, 0x0C, 0xC0, 0x0C, 0xC0,
  0x0C, 0xC0, 0x8F, 0xF8,
  // "ī" (U+012B)
  0x6B, 0xB3, 0x00, 0x00, 0xAF, 0x80, 0x0F, 0x80, 0x0F, 0x80, 0x0F, 0x80, 0x0F, 0x80, 0xAF, 0xE4,
  // "Ĭ" (U+012C)
  0x52, 0x24, 0x1B, 0xB1, 0x00, 0x00, 0x8F, 0xF8, 0x0C, 0xC0, 0x0C, 0xC0, 0x0C, 0xC0, 0x0C, 0xC0,
  0x0C, 0xC0, 0x0C, 0xC0, 0x8F, 0xF8,
  // "ĭ" (U+012D)
  0x52, 0x24, 0x1B, 0xB1, 0x00, 0x00, 0xAF, 0x80, 0x0F, 0x80, 0x0F, 0x80, 0x0F, 0x80, 0x0F, 0x80,
  0xAF, 0xE4,
  // "Į" (U+012E)
  0x8F, 0xF8, 0x0C, 0xC0, 0x0C, 0xC0, 0x0C, 0xC0, 0x0C, 0xC0, 0x0C, 0xC0, 0x0C, 0xC0, 0x8F, 0xF8,
  0x04, 0x20, 0x1E, 0x00, 0x0B, 0xC1,
  // "į" (U+012F)
  0x0D, 0x60, 0x0B, 0x40, 0xAF, 0x80, 0x0F, 0x80, 0x0F, 0x80, 0x0F, 0x80, 0x0F, 0x80, 0xAF, 0xE4,
  0x04, 0x20, 0x1E, 0x00, 0x0B, 0xC1,
  // "İ" (U+0130)
  0x05, 0xB0, 0x06, 0xD0, 0x00, 0x00, 0x8F, 0xF8, 0x0C, 0xC0, 0x0C, 0xC0, 0x0C, 0xC0, 0x0C, 0xC0,
  0x0C, 0xC0, 0x0C, 0xC0, 0x8F, 0xF8,
  // "ı" (U+0131)
  0xAF, 0x80, 0x0F, 0x80, 0x0F, 0x80, 0x0F, 0x80, 0x0F, 0x80, 0xAF, 0xE4,
  // "Ĳ" (U+0132)
  0x8F, 0xF8, 0x8F, 0xF9, 0x0C, 0xC0, 0x0C, 0xC0, 0x0C, 0xC0, 0x0B, 0xC0, 0x0C, 0xC0, 0x0B, 0xC0,
  0x0C, 0xC0, 0x0B, 0xC0, 0x0C, 0xC0, 0x0B, 0xC0, 0x0C, 0xC0, 0x0B, 0xC0, 0x8F, 0xF8, 0x0B, 0xC0,
  0x00, 0x00, 0x0C, 0xB0, 0x00, 0x00, 0x1E, 0x80, 0x00, 0x02, 0xDA, 0x10,
  // "ĳ" (U+0133)
  0x0D, 0x60, 0x0D, 0x60, 0xB4, 0x00, 0xB4, 0xAF, 0x80, 0xBF, 0x80, 0xF8, 0x00, 0xF8, 0x0F, 0x80,
  0x0F, 0x80, 0xF8, 0x00, 0xF8, 0x0F, 0x80, 0x0F, 0x8A, 0xFE, 0x40, 0xF8, 0x00, 0x00, 0x0F, 0x70,
  0x00, 0x03, 0xF5, 0x00, 0x02, 0xC9, 0x00,
  // "Ĵ" (U+0134)
  0x28, 0x6B, 0xE1, 0x05, 0x94, 0xA6, 0x08, 0xA0, 0x92, 0x00, 0xC3, 0x0B, 0x0C, 0x30, 0xB0, 0xC3,
  0x0B, 0x0C, 0x30, 0xB0, 0xC3, 0x0B, 0x0C, 0x30, 0xB0, 0xC3, 0x0C, 0x0B, 0x28, 0x61, 0xE8, 0x02,
  0xDA, 0x11,
  // "ĵ" (U+0135)
  0x0B, 0xE1, 0x59, 0x4A, 0x00, 0x00, 0x0B, 0xF8, 0x00, 0xF8, 0x00, 0xF8, 0x00, 0xF8, 0x00, 0xF8,
  0x00, 0xF8, 0x00, 0xF7, 0x02, 0xF5, 0x0D, 0x90,
  // "Ķ" (U+0136)
  0x08, 0xA8, 0x28, 0x8F, 0xD2, 0x83, 0xCC, 0x03, 0xC3, 0x83, 0xCC, 0x1B, 0x13, 0x82, 0xCC, 0xB7,
  0x48, 0x3C, 0xEC, 0xE1, 0x38, 0x3C, 0xC3, 0xF9, 0x38, 0x6C, 0xC0, 0xAF, 0x30, 0x8A, 0x83, 0x81,
  0xCE, 0x43, 0x06, 0x08, 0x60, 0xA0, 0x23,
  // "ķ" (U+0137)
  0x81, 0xAF, 0x85, 0x90, 0x85, 0x98, 0x28, 0x6F, 0xE2, 0x98, 0x17, 0x4B, 0x39, 0x81, 0xAE, 0x23,
  0x98, 0x1C, 0xEA, 0x39, 0x89, 0x28, 0x7F, 0x50, 0xAF, 0xE4, 0xBF, 0x42, 0x06, 0x08, 0x50, 0xA0,
  0x23,
  // "ĸ" (U+0138)
  0xAF, 0x86, 0xFE, 0x00, 0xF7, 0x4B, 0x00, 0x0F, 0xAE, 0x20, 0x00, 0xFC, 0xEA, 0x00, 0x0F, 0x87,
  0xF5, 0x0A, 0xFE, 0x4B, 0xF4,
  // "Ĺ" (U+0139)
  0x20, 0xD0, 0x94, 0x06, 0x0A, 0x74, 0x82, 0x6E, 0xE6, 0x40, 0x0C, 0x50, 0x0C, 0x50, 0x0C, 0x50,
  0x0C, 0x50, 0x0C, 0x28, 0x32, 0x10, 0xCC, 0x28, 0x78, 0x26, 0xEE, 0x99, 0xE2,
  // "ĺ" (U+013A)
  0x00, 0xD9, 0x06, 0xA0, 0x00, 0x00, 0xAF, 0x80, 0x0F, 0x80, 0x0F, 0x80, 0x0F, 0x80, 0x0F, 0x80,
  0x0F, 0x80, 0x0F, 0x80, 0xAF, 0xE4,
  // "Ļ" (U+013B)
  0x82, 0x6E, 0xE6, 0x40, 0x0C, 0x50, 0x0C, 0x50, 0x0C, 0x50, 0x0C, 0x50, 0x0C, 0x28, 0x32, 0x10,
  0xCC, 0x28, 0x78, 0x26, 0xEE, 0x99, 0xE2, 0x20, 0x60, 0x85, 0x0A, 0x02, 0x30,
  // "ļ" (U+013C)
  0xAF, 0x80, 0x0F, 0x80, 0x0F, 0x80, 0x0F, 0x80, 0x0F, 0x80, 0x0F, 0x80, 0x0F, 0x80, 0xAF, 0xE4,
  0x06, 0x80, 0x0A, 0x20,
  // "Ľ" (U+013D)
  0x84, 0x6E, 0xE6, 0x3D, 0x28, 0x3C, 0xC0, 0x54, 0x20, 0x0C, 0x50, 0x0C, 0x50, 0x0C, 0x50, 0x0C,
  0x28, 0x32, 0x10, 0xCC, 0x28, 0x78, 0x26, 0xEE, 0x99, 0xE2,
  // "ľ" (U+013E)
  0xAF, 0x8A, 0x60, 0xF8, 0x90, 0x0F, 0x80, 0x00, 0xF8, 0x00, 0x0F, 0x80, 0x00, 0xF8, 0x00, 0x0F,
  0x80, 0x0A, 0xFE, 0x40,
  // "Ŀ" (U+013F)
  0x82, 0x6E, 0xE6, 0x40, 0x0C, 0x58, 0x3C, 0xC0, 0x5B, 0x28, 0x3C, 0xC0, 0x6D, 0x20, 0x0C, 0x50,
  0x0C, 0x28, 0x32, 0x10, 0xCC, 0x28, 0x78, 0x26, 0xEE, 0x99, 0xE2,
  // "ŀ" (U+0140)
  0xAF, 0x80, 0x00, 0xF8, 0x00, 0x0F, 0x80, 0x00, 0xF8, 0x5B, 0x0F, 0x86, 0xD0, 0xF8, 0x00, 0x0F,
  0x80, 0x0A, 0xFE, 0x40,
  // "Ł" (U+0141)
  0x6E, 0xE6, 0x00, 0x00, 0xCC, 0x00, 0x00, 0x0C, 0xC5, 0x20, 0x00, 0xCE, 0x60, 0x00, 0x5E, 0xC0,
  0x00, 0x02, 0xCC, 0x00, 0x21, 0x0C, 0xC0, 0x08, 0x26, 0xEE, 0x99, 0xE2,
  // "ł" (U+0142)
  0xAF, 0x80, 0x0F, 0x80, 0x0F, 0x80, 0x0F, 0xB3, 0x3F, 0x90, 0x4F, 0x80, 0x0F, 0x80, 0xAF, 0xE4,
  // "Ń" (U+0143)
  0x40, 0xD0, 0x95, 0x06, 0x0A, 0x74, 0x81, 0x8F, 0xC2, 0x85, 0xBF, 0x80, 0xCF, 0x72, 0x0B, 0x28,
  0x4B, 0xAE, 0x20, 0xB2, 0x84, 0xB1, 0xEB, 0x0B, 0x28, 0x4B, 0x06, 0xF5, 0xB2, 0x0B, 0x28, 0x1B,
  0xEB, 0x20, 0xB2, 0x85, 0x2F, 0xC0, 0x8F, 0xB2, 0x07, 0x0C, 0x10,
  // "ń" (U+0144)
  0x30, 0xD0, 0x94, 0x06, 0x0A, 0x73, 0x84, 0x9F, 0xAC, 0xE3, 0x29, 0x82, 0xA0, 0xE9, 0x29, 0x82,
  0x80, 0xCA, 0x29, 0x82, 0x80, 0xCA, 0x29, 0x89, 0x28, 0x0C, 0xB0, 0xAF, 0xE3, 0xCF, 0x50,
  // "Ņ" (U+0145)
  0x8F, 0xC0, 0x0B, 0xF8, 0x0C, 0xF7, 0x00, 0xB0, 0x0B, 0xAE, 0x20, 0xB0, 0x0B, 0x1E, 0xB0, 0xB0,
  0x0B, 0x06, 0xF5, 0xB0, 0x0B, 0x00, 0xBE, 0xB0, 0x0B, 0x00, 0x2F, 0xC0, 0x8F, 0xB0, 0x07, 0xC0,
  0x00, 0x06, 0x80, 0x00, 0x00, 0x0A, 0x20, 0x00,
  // "ņ" (U+0146)
  0x9F, 0xAC, 0xE3, 0x00, 0xFA, 0x0E, 0x90, 0x0F, 0x80, 0xCA, 0x00, 0xF8, 0x0C, 0xA0, 0x0F, 0x80,
  0xCB, 0x0A, 0xFE, 0x3C, 0xF5, 0x00, 0x68, 0x00, 0x00, 0x0A, 0x20, 0x00,
  // "Ň" (U+0147)
  0x00, 0x58, 0x4A, 0x00, 0x00, 0x0B, 0xE2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8F, 0xC0, 0x0B, 0xF8,
  0x0C, 0xF7, 0x00, 0xB0, 0x0B, 0xAE, 0x20, 0xB0, 0x0B, 0x1E, 0xB0, 0xB0, 0x0B, 0x06, 0xF5, 0xB0,
  0x0B, 0x00, 0xBE, 0xB0, 0x0B, 0x00, 0x2F, 0xC0, 0x8F, 0xB0, 0x07, 0xC0,
  // "ň" (U+0148)
  0x05, 0x84, 0xA0, 0x00, 0x0B, 0xE2, 0x00, 0x00, 0x00, 0x00, 0x09, 0xFA, 0xCE, 0x30, 0x0F, 0xA0,
  0xE9, 0x00, 0xF8, 0x0C, 0xA0, 0x0F, 0x80, 0xCA, 0x00, 0xF8, 0x0C, 0xB0, 0xAF, 0xE3, 0xCF, 0x50,
  // "ŉ" (U+0149)
  0x04, 0x0D, 0x78, 0x11, 0xD2, 0x68, 0x90, 0x3A, 0x9F, 0xAC, 0xE3, 0x01, 0x29, 0x82, 0xA0, 0xE9,
  0x49, 0x82, 0x80, 0xCA, 0x49, 0x82, 0x80, 0xCA, 0x49, 0x82, 0x80, 0xCB, 0x38, 0x5A, 0xFE, 0x3C,
  0xF5,
  // "Ŋ" (U+014A)
  0x8F, 0xC0, 0x0B, 0xF8, 0x0C, 0xF7, 0x00, 0xB0, 0x0B, 0xAF, 0x20, 0xB0, 0x0B, 0x1E, 0xC0, 0xB0,
  0x0B, 0x05, 0xF7, 0xB0, 0x0B, 0x00, 0xAF, 0xB0, 0x0B, 0x00, 0x1E, 0xC0, 0x8F, 0xB0, 0x04, 0xC0,
  0x00, 0x00, 0x00, 0xB0, 0x00, 0x00, 0x03, 0xA0, 0x00, 0x00, 0x2C, 0x30,
  // "ŋ" (U+014B)
  0x9F, 0xAC, 0xD3, 0x0F, 0xA0, 0xE9, 0x0F, 0x80, 0xCA, 0x0F, 0x80, 0xCA, 0x0F, 0x80, 0xCA, 0xAF,
  0xE3, 0xCA, 0x00, 0x00, 0xCA, 0x00, 0x00, 0xE8, 0x00, 0x0A, 0xB1,
  // "Ō" (U+014C)
  0x00, 0x6B, 0xB3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xAC, 0xC9, 0x00, 0x0C, 0xB0, 0x0D, 0xA0,
  0x3F, 0x50, 0x07, 0xF1, 0x6F, 0x40, 0x06, 0xF4, 0x6F, 0x40, 0x06, 0xF4, 0x3F, 0x50, 0x07, 0xF1,
  0x0C, 0xB0, 0x0D, 0xA0, 0x01, 0xAC, 0xC9, 0x00,
  // "ō" (U+014D)
  0x06, 0xBB, 0x30, 0x00, 0x00, 0x00, 0x07, 0xCC, 0x80, 0x3F, 0x31, 0xF5, 0x7F, 0x00, 0xE9, 0x7F,
  0x00, 0xE9, 0x3F, 0x31, 0xF5, 0x07, 0xCC, 0x90,
  // "Ŏ" (U+014E)
  0x00, 0x52, 0x24, 0x00, 0x00, 0x1B, 0xB1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xAC, 0xC9, 0x00,
  0x0C, 0xB0, 0x0D, 0xA0, 0x3F, 0x50, 0x07, 0xF1, 0x6F, 0x40, 0x06, 0xF4, 0x6F, 0x40, 0x06, 0xF4,
  0x3F, 0x50, 0x07, 0xF1, 0x0C, 0xB0, 0x0D, 0xA0, 0x01, 0xAC, 0xC9, 0x00,
  // "ŏ" (U+014F)
  0x05, 0x22, 0x40, 0x01, 0xBB, 0x10, 0x00, 0x00, 0x00, 0x07, 0xCC, 0x80, 0x3F, 0x31, 0xF5, 0x7F,
  0x00, 0xE9, 0x7F, 0x00, 0xE9, 0x3F, 0x31, 0xF5, 0x07, 0xCC, 0x90,
  // "Ő" (U+0150)
  0x00, 0x0C, 0x5C, 0x20, 0x00, 0x68, 0x77, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xAC, 0xC9, 0x00,
  0x0C, 0xB0, 0x0D, 0xA0, 0x3F, 0x50, 0x07, 0xF1, 0x6F, 0x40, 0x06, 0xF4, 0x6F, 0x40, 0x06, 0xF4,
  0x3F, 0x50, 0x07, 0xF1, 0x0C, 0xB0, 0x0D, 0xA0, 0x01, 0xAC, 0xC9, 0x00,
  // "ő" (U+0151)
  0x00, 0xC5, 0xC2, 0x06, 0x87, 0x70, 0x00, 0x00, 0x00, 0x07, 0xCC, 0x80, 0x3F, 0x31, 0xF5, 0x7F,
  0x00, 0xE9, 0x7F, 0x00, 0xE9, 0x3F, 0x31, 0xF5, 0x07, 0xCC, 0x90,
  // "Œ" (U+0152)
  0x01, 0xAC, 0xDF, 0xDB, 0xD7, 0x0C, 0xB0, 0x1F, 0x70, 0x37, 0x3F, 0x50, 0x1F, 0x70, 0x00, 0x6F,
  0x40, 0x1F, 0xDB, 0x90, 0x6F, 0x40, 0x1F, 0x70, 0x00, 0x3F, 0x50, 0x1F, 0x70, 0x02, 0x0C, 0xB0,
  0x1F, 0x70, 0x0C, 0x01, 0xAC, 0xDF, 0xDB, 0xCC,
  // "œ" (U+0153)
  0x07, 0xCC, 0x69, 0xCC, 0x33, 0xF3, 0x1F, 0xC0, 0xAC, 0x7F, 0x00, 0xEE, 0xBC, 0xC7, 0xF0, 0x0E,
  0xA0, 0x00, 0x3F, 0x31, 0xFE, 0x00, 0x50, 0x7C, 0xC8, 0x9D, 0xB4,
  // "Ŕ" (U+0154)
  0x30, 0xD0, 0x95, 0x06, 0x0A, 0x75, 0x84, 0x8F, 0xEC, 0xD6, 0x38, 0x4C, 0xC0, 0x9F, 0x12, 0x84,
  0xCC, 0x07, 0xF2, 0x28, 0x3C, 0xC0, 0xAD, 0x38, 0x3C, 0xED, 0xF2, 0x38, 0x3C, 0xC3, 0xF7, 0x38,
  0x6C, 0xC0, 0xAE, 0x20, 0x8A, 0x83, 0x81, 0xCE, 0x10,
  // "ŕ" (U+0155)
  0x20, 0xD0, 0x92, 0x06, 0x0A, 0x78, 0x93, 0x9F, 0xAC, 0xD0, 0xFA, 0x27, 0x0F, 0x83, 0x90, 0x83,
  0x90, 0x82, 0x82, 0xAF, 0xE6, 0x10,
  // "Ŗ" (U+0156)
  0x8F, 0xEC, 0xD6, 0x00, 0x0C, 0xC0, 0x9F, 0x10, 0x0C, 0xC0, 0x7F, 0x20, 0x0C, 0xC0, 0xAD, 0x00,
  0x0C, 0xED, 0xF2, 0x00, 0x0C, 0xC3, 0xF7, 0x00, 0x0C, 0xC0, 0xAE, 0x20, 0x8F, 0xF8, 0x1C, 0xE1,
  0x00, 0x68, 0x00, 0x00, 0x00, 0xA2, 0x00, 0x00,
  // "ŗ" (U+0157)
  0x9F, 0xAC, 0xD0, 0xFA, 0x27, 0x0F, 0x80, 0x00, 0xF8, 0x00, 0x0F, 0x80, 0x0A, 0xFE, 0x60, 0x06,
  0x80, 0x00, 0xA2, 0x00,
  // "Ř" (U+0158)
  0x18, 0x25, 0x84, 0xA5, 0x81, 0xBE, 0x27, 0x48, 0x48, 0xFE, 0xCD, 0x63, 0x84, 0xCC, 0x09, 0xF1,
  0x28, 0x4C, 0xC0, 0x7F, 0x22, 0x83, 0xCC, 0x0A, 0xD3, 0x83, 0xCE, 0xDF, 0x23, 0x83, 0xCC, 0x3F,
  0x73, 0x86, 0xCC, 0x0A, 0xE2, 0x08, 0xA8, 0x38, 0x1C, 0xE1,
  // "ř" (U+0159)
  0x58, 0x4A, 0x00, 0xBE, 0x20, 0x00, 0x00, 0x09, 0xFA, 0xCD, 0x0F, 0xA2, 0x70, 0xF8, 0x00, 0x0F,
  0x80, 0x00, 0xF8, 0x00, 0xAF, 0xE6, 0x00,
  // "Ś" (U+015A)
  0x30, 0xD0, 0x93, 0x06, 0x0A, 0x72, 0x8A, 0x48, 0xCE, 0x90, 0x5D, 0x05, 0xE0, 0x6E, 0x30, 0x10,
  0x1E, 0xF9, 0x12, 0x8A, 0x41, 0x8F, 0xE1, 0x34, 0x03, 0xF4, 0x9A, 0x01, 0xF2, 0x3C, 0xCC, 0x51,
  // "ś" (U+015B)
  0x00, 0xD9, 0x00, 0x6A, 0x00, 0x00, 0x00, 0x02, 0xCC, 0xC1, 0x8A, 0x09, 0x15, 0xFB, 0x30, 0x03,
  0xAF, 0x49, 0x50, 0xC6, 0x5D, 0xBB, 0x00,
  // "Ŝ" (U+015C)
  0x00, 0xBE, 0x10, 0x05, 0x94, 0xA0, 0x00, 0x00, 0x00, 0x08, 0xCE, 0x90, 0x5D, 0x05, 0xE0, 0x6E,
  0x30, 0x10, 0x1E, 0xF9, 0x10, 0x01, 0x8F, 0xE1, 0x34, 0x03, 0xF4, 0x9A, 0x01, 0xF2, 0x3C, 0xCC,
  0x50,
  // "ŝ" (U+015D)
  0x0B, 0xE1, 0x05, 0x94, 0xA0, 0x00, 0x00, 0x02, 0xCC, 0xC1, 0x8A, 0x09, 0x15, 0xFB, 0x30, 0x03,
  0xAF, 0x49, 0x50, 0xC6, 0x5D, 0xBB, 0x00,
  // "Ş" (U+015E)
  0x08, 0xCE, 0x90, 0x5D, 0x05, 0xE0, 0x6E, 0x30, 0x10, 0x1E, 0xF9, 0x10, 0x01, 0x8F, 0xE1, 0x34,
  0x03, 0xF4, 0x9A, 0x01, 0xF2, 0x3C, 0xCC, 0x50, 0x00, 0x92, 0x00, 0x00, 0x4B, 0x00, 0x05, 0xC5,
  0x00,
  // "ş" (U+015F)
  0x2C, 0xCC, 0x18, 0xA0, 0x91, 0x5F, 0xB3, 0x00, 0x3A, 0xF4, 0x95, 0x0C, 0x65, 0xDB, 0xB0, 0x00,
  0x92, 0x00, 0x04, 0xB0, 0x05, 0xC5, 0x00,
  // "Š" (U+0160)
  0x05, 0x84, 0xA0, 0x00, 0xBE, 0x20, 0x00, 0x00, 0x00, 0x08, 0xCE, 0x90, 0x5D, 0x05, 0xE0, 0x6E,
  0x30, 0x10, 0x1E, 0xF9, 0x10, 0x01, 0x8F, 0xE1, 0x34, 0x03, 0xF4, 0x9A, 0x01, 0xF2, 0x3C, 0xCC,
  0x50,
  // "š" (U+0161)
  0x58, 0x4A, 0x00, 0xBE, 0x20, 0x00, 0x00, 0x02, 0xCC, 0xC1, 0x8A, 0x09, 0x15, 0xFB, 0x30, 0x03,
  0xAF, 0x49, 0x50, 0xC6, 0x5D, 0xBB, 0x00,
  // "Ţ" (U+0162)
  0x8A, 0x3D, 0xCD, 0xFB, 0xE6, 0xB0, 0x8F, 0x15, 0x61, 0x08, 0xF1, 0x01, 0x28, 0x18, 0xF1, 0x48,
  0x18, 0xF1, 0x48, 0x18, 0xF1, 0x48, 0x18, 0xF1, 0x38, 0x25, 0xEF, 0xC4, 0x06, 0x05, 0x60, 0xE0,
  0x13, 0x81, 0x1B, 0x93,
  // "ţ" (U+0163)
  0x10, 0x03, 0x28, 0x11, 0xC7, 0x28, 0x29, 0xFD, 0x82, 0x90, 0x73, 0x90, 0x73, 0x90, 0x73, 0x90,
  0x83, 0x81, 0x9E, 0x83, 0x06, 0x05, 0x48, 0x4E, 0x10, 0x1B, 0x91,
  // "Ť" (U+0164)
  0x18, 0x25, 0x84, 0xA4, 0x81, 0xBE, 0x27, 0x28, 0xA3, 0xDC, 0xDF, 0xBE, 0x6B, 0x08, 0xF1, 0x56,
  0x10, 0x8F, 0x10, 0x12, 0x81, 0x8F, 0x14, 0x81, 0x8F, 0x14, 0x81, 0x8F, 0x14, 0x81, 0x8F, 0x13,
  0x82, 0x5E, 0xFC, 0x20,
  // "ť" (U+0165)
  0x38, 0x91, 0xA6, 0x08, 0x69, 0x09, 0xFD, 0x82, 0x90, 0x73, 0x90, 0x73, 0x90, 0x73, 0x90, 0x83,
  0x81, 0x9E, 0x81,
  // "Ŧ" (U+0166)
  0xDC, 0xDF, 0xBE, 0x5C, 0x08, 0xF1, 0x56, 0x40, 0x8F, 0x11, 0x20, 0x08, 0xF1, 0x00, 0x0B, 0xDF,
  0xB5, 0x00, 0x08, 0xF1, 0x00, 0x00, 0x8F, 0x10, 0x00, 0x5E, 0xFC, 0x00,
  // "ŧ" (U+0167)
  0x03, 0x30, 0x1C, 0x70, 0x9F, 0xD8, 0x0F, 0x70, 0x8F, 0xD6, 0x0F, 0x70, 0x0F, 0x80, 0x09, 0xE8,
  // "Ũ" (U+0168)
  0x00, 0x2B, 0x87, 0x30, 0x00, 0x62, 0x9A, 0x00, 0x00, 0x00, 0x00, 0x00, 0xAF, 0xF7, 0x3D, 0xD3,
  0x0E, 0xA0, 0x05, 0x50, 0x0E, 0xA0, 0x05, 0x50, 0x0E, 0xA0, 0x05, 0x50, 0x0E, 0xA0, 0x05, 0x50,
  0x0D, 0xA0, 0x05, 0x50, 0x0B, 0xD0, 0x09, 0x30, 0x02, 0xBD, 0xB8, 0x00,
  // "ũ" (U+0169)
  0x02, 0xB8, 0x73, 0x00, 0x62, 0x9A, 0x00, 0x00, 0x00, 0x00, 0x09, 0xF7, 0x7F, 0xA0, 0x0F, 0x70,
  0xDA, 0x00, 0xF7, 0x0D, 0xA0, 0x0F, 0x70, 0xDA, 0x00, 0xF9, 0x0E, 0xA0, 0x07, 0xEA, 0xCF, 0x50,
  // "Ū" (U+016A)
  0x00, 0x6B, 0xB3, 0x00, 0x00, 0x00, 0x00, 0x00, 0xAF, 0xF7, 0x3D, 0xD3, 0x0E, 0xA0, 0x05, 0x50,
  0x0E, 0xA0, 0x05, 0x50, 0x0E, 0xA0, 0x05, 0x50, 0x0E, 0xA0, 0x05, 0x50, 0x0D, 0xA0, 0x05, 0x50,
  0x0B, 0xD0, 0x09, 0x30, 0x02, 0xBD, 0xB8, 0x00,
  // "ū" (U+016B)
  0x06, 0xBB, 0x30, 0x00, 0x00, 0x00, 0x00, 0x9F, 0x77, 0xFA, 0x00, 0xF7, 0x0D, 0xA0, 0x0F, 0x70,
  0xDA, 0x00, 0xF7, 0x0D, 0xA0, 0x0F, 0x90, 0xEA, 0x00, 0x7E, 0xAC, 0xF5,
  // "Ŭ" (U+016C)
  0x00, 0x52, 0x24, 0x00, 0x00, 0x1B, 0xB1, 0x00, 0x00, 0x00, 0x00, 0x00, 0xAF, 0xF7, 0x3D, 0xD3,
  0x0E, 0xA0, 0x05, 0x50, 0x0E, 0xA0, 0x05, 0x50, 0x0E, 0xA0, 0x05, 0x50, 0x0E, 0xA0, 0x05, 0x50,
  0x0D, 0xA0, 0x05, 0x50, 0x0B, 0xD0, 0x09, 0x30, 0x02, 0xBD, 0xB8, 0x00,
  // "ŭ" (U+016D)
  0x05, 0x22, 0x40, 0x00, 0x1B, 0xB1, 0x00, 0x00, 0x00, 0x00, 0x09, 0xF7, 0x7F, 0xA0, 0x0F, 0x70,
  0xDA, 0x00, 0xF7, 0x0D, 0xA0, 0x0F, 0x70, 0xDA, 0x00, 0xF9, 0x0E, 0xA0, 0x07, 0xEA, 0xCF, 0x50,
  // "Ů" (U+016E)
  0x00, 0x3B, 0x60, 0x00, 0x00, 0x72, 0xA0, 0x00, 0x00, 0x3B, 0x60, 0x00, 0xAF, 0xF7, 0x3D, 0xD3,
  0x0E, 0xA0, 0x05, 0x50, 0x0E, 0xA0, 0x05, 0x50, 0x0E, 0xA0, 0x05, 0x50, 0x0E, 0xA0, 0x05, 0x50,
  0x0D, 0xA0, 0x05, 0x50, 0x0B, 0xD0, 0x09, 0x30, 0x02, 0xBD, 0xB8, 0x00,
  // "ů" (U+016F)
  0x00, 0x3B, 0x60, 0x00, 0x07, 0x2A, 0x00, 0x00, 0x3B, 0x60, 0x09, 0xF7, 0x7F, 0xA0, 0x0F, 0x70,
  0xDA, 0x00, 0xF7, 0x0D, 0xA0, 0x0F, 0x70, 0xDA, 0x00, 0xF9, 0x0E, 0xA0, 0x07, 0xEA, 0xCF, 0x50,
  // "Ű" (U+0170)
  0x00, 0x0C, 0x5C, 0x20, 0x00, 0x68, 0x77, 0x00, 0x00, 0x00, 0x00, 0x00, 0xAF, 0xF7, 0x3D, 0xD3,
  0x0E, 0xA0, 0x05, 0x50, 0x0E, 0xA0, 0x05, 0x50, 0x0E, 0xA0, 0x05, 0x50, 0x0E, 0xA0, 0x05, 0x50,
  0x0D, 0xA0, 0x05, 0x50, 0x0B, 0xD0, 0x09, 0x30, 0x02, 0xBD, 0xB8, 0x00,
  // "ű" (U+0171)
  0x00, 0xC5, 0xC2, 0x00, 0x68, 0x77, 0x00, 0x00, 0x00, 0x00, 0x09, 0xF7, 0x7F, 0xA0, 0x0F, 0x70,
  0xDA, 0x00, 0xF7, 0x0D, 0xA0, 0x0F, 0x70, 0xDA, 0x00, 0xF9, 0x0E, 0xA0, 0x07, 0xEA, 0xCF, 0x50,
  // "Ų" (U+0172)
  0xAF, 0xF7, 0x3D, 0xD3, 0x0E, 0xA0, 0x05, 0x50, 0x0E, 0xA0, 0x05, 0x50, 0x0E, 0xA0, 0x05, 0x50,
  0x0E, 0xA0, 0x05, 0x50, 0x0D, 0xA0, 0x05, 0x50, 0x0B, 0xD0, 0x09, 0x30, 0x02, 0xBD, 0xB8, 0x00,
  0x00, 0x04, 0x20, 0x00, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x0B, 0xC1, 0x00,
  // "ų" (U+0173)
  0x9F, 0x77, 0xFA, 0x00, 0xF7, 0x0D, 0xA0, 0x0F, 0x70, 0xDA, 0x00, 0xF7, 0x0D, 0xA0, 0x0F, 0x90,
  0xEA, 0x00, 0x7E, 0xAC, 0xF5, 0x00, 0x00, 0x60, 0x00, 0x00, 0x69, 0x00, 0x00, 0x03, 0xC9, 0x00,
  // "Ŵ" (U+0174)
  0x48, 0x1B, 0xE1, 0x78, 0x25, 0x94, 0xA7, 0x71, 0x8A, 0x3D, 0xFE, 0x40, 0xC3, 0x0C, 0xF8, 0x1F,
  0x80, 0x1F, 0x80, 0x1B, 0x28, 0x7D, 0xB0, 0x5F, 0xC0, 0x47, 0x28, 0x78, 0xF0, 0x99, 0xF2, 0x84,
  0x28, 0x64, 0xF4, 0xC1, 0xF7, 0xB4, 0x98, 0x4A, 0x90, 0xCB, 0xB4, 0x85, 0xBF, 0x50, 0x7F, 0x84,
  0x07, 0x92, 0x81, 0x2F, 0x42,
  // "ŵ" (U+0175)
  0x38, 0x1B, 0xE1, 0x58, 0x25, 0x94, 0xA7, 0x58, 0x97, 0xEF, 0xC0, 0xD1, 0x9F, 0x74, 0xF3, 0x2F,
  0x50, 0xB2, 0x85, 0xE7, 0x7E, 0xA4, 0x62, 0x0F, 0xA8, 0x27, 0xE8, 0x22, 0x84, 0x6E, 0x82, 0xFB,
  0x38, 0x42, 0xF3, 0x0D, 0x82,
  // "Ŷ" (U+0176)
  0x28, 0x1B, 0xE1, 0x38, 0x25, 0x94, 0xA7, 0x28, 0x90, 0xDF, 0xE4, 0x8F, 0xC1, 0xFA, 0x28, 0x6C,
  0x10, 0x9E, 0x13, 0x82, 0x83, 0x1F, 0x79, 0x13, 0x81, 0x9E, 0x84, 0x81, 0x4F, 0x44, 0x81, 0x5F,
  0x43, 0x83, 0x4D, 0xFD, 0x31,
  // "ŷ" (U+0177)
  0x00, 0xBE, 0x10, 0x05, 0x94, 0xA0, 0x00, 0x00, 0x00, 0xEF, 0xB5, 0xFB, 0x3F, 0x40, 0xB0, 0x0D,
  0x91, 0xA0, 0x07, 0xE5, 0x50, 0x02, 0xFD, 0x10, 0x00, 0xCB, 0x00, 0x00, 0x96, 0x00, 0x03, 0xE1,
  0x00, 0x8D, 0x50, 0x00,
  // "Ÿ" (U+0178)
  0x00, 0x95, 0x85, 0x00, 0x01, 0x00, 0x00, 0xDF, 0xE4, 0x8F, 0xC1, 0xFA, 0x00, 0xC1, 0x09, 0xE1,
  0x38, 0x00, 0x1F, 0x79, 0x10, 0x00, 0x9E, 0x80, 0x00, 0x04, 0xF4, 0x00, 0x00, 0x5F, 0x40, 0x00,
  0x4D, 0xFD, 0x30,
  // "Ź" (U+0179)
  0x30, 0xD0, 0x94, 0x06, 0x0A, 0x73, 0x8A, 0x15, 0xEA, 0xAF, 0xE0, 0x56, 0x04, 0xF7, 0x01, 0x10,
  0xCD, 0x48, 0x16, 0xF5, 0x40, 0xE0, 0xC4, 0x87, 0x7F, 0x40, 0x21, 0x1E, 0xA2, 0x87, 0x93, 0x8F,
  0xBA, 0xAF, 0x20,
  // "ź" (U+017A)
  0x00, 0x0D, 0x90, 0x06, 0xA0, 0x00, 0x00, 0x07, 0xDB, 0xFC, 0x61, 0x5F, 0x30, 0x0D, 0x90, 0x08,
  0xE1, 0x02, 0xF5, 0x0A, 0xBF, 0xBB, 0xE0,
  // "Ż" (U+017B)
  0x20, 0x50, 0xB5, 0x06, 0x0D, 0x73, 0x8A, 0x15, 0xEA, 0xAF, 0xE0, 0x56, 0x04, 0xF7, 0x01, 0x10,
  0xCD, 0x48, 0x16, 0xF5, 0x40, 0xE0, 0xC4, 0x87, 0x7F, 0x40, 0x21, 0x1E, 0xA2, 0x87, 0x93, 0x8F,
  0xBA, 0xAF, 0x20,
  // "ż" (U+017C)
  0x00, 0x5B, 0x00, 0x06, 0xD0, 0x00, 0x00, 0x07, 0xDB, 0xFC, 0x61, 0x5F, 0x30, 0x0D, 0x90, 0x08,
  0xE1, 0x02, 0xF5, 0x0A, 0xBF, 0xBB, 0xE0,
  // "Ž" (U+017D)
  0x18, 0x25, 0x84, 0xA4, 0x81, 0xBE, 0x27, 0x28, 0xA1, 0x5E, 0xAA, 0xFE, 0x05, 0x60, 0x4F, 0x70,
  0x11, 0x0C, 0xD4, 0x81, 0x6F, 0x54, 0x0E, 0x0C, 0x48, 0x77, 0xF4, 0x02, 0x11, 0xEA, 0x28, 0x79,
  0x38, 0xFB, 0xAA, 0xF2,
  // "ž" (U+017E)
  0x05, 0x84, 0xA0, 0x0B, 0xE2, 0x00, 0x00, 0x07, 0xDB, 0xFC, 0x61, 0x5F, 0x30, 0x0D, 0x90, 0x08,
  0xE1, 0x02, 0xF5, 0x0A, 0xBF, 0xBB, 0xE0,
  // "ſ" (U+017F)
  0x06, 0xDE, 0x70, 0xE8, 0x54, 0x0F, 0x80, 0x00, 0xF8, 0x00, 0x0F, 0x80, 0x00, 0xF8, 0x00, 0x0F,
  0x80, 0x0C, 0xFE, 0x80,
  // "Ω" (U+03A9)
  0x02, 0xBC, 0xCB, 0x30, 0x0D, 0xB0, 0x0A, 0xE1, 0x4F, 0x60, 0x05, 0xF5, 0x4F, 0x60, 0x05, 0xF5,
  0x0E, 0x90, 0x08, 0xE1, 0x12, 0xB7, 0x6B, 0x31, 0x85, 0x29, 0x92, 0x49, 0x7F, 0xFB, 0xAF, 0xF9,
  // "μ" (U+03BC)
  0x8D, 0x21, 0xF7, 0x0D, 0x90, 0x1F, 0x70, 0xD9, 0x01, 0xF7, 0x0D, 0x90, 0x1F, 0x70, 0xD9, 0x01,
  0xF9, 0x1F, 0xA0, 0x1C, 0xD9, 0x7E, 0x42, 0xA5, 0x81, 0x2E, 0x25, 0x0D, 0x06, 0x40,
  // "π" (U+03C0)
  0x3E, 0xFF, 0xFF, 0x68, 0x4B, 0x2B, 0x31, 0x02, 0x90, 0xC0, 0x00, 0x49, 0x0D, 0x00, 0x08, 0x80,
  0xE0, 0x06, 0xE3, 0x0B, 0xB0,
  // "–" (U+2013)
  0x80, 0x1B,
  // "—" (U+2014)
  0x80, 0x6B,
  // "€" (U+20AC)
  0x02, 0xBD, 0xC1, 0x0B, 0x90, 0xE5, 0x0F, 0x50, 0x30, 0x9F, 0xCB, 0x10, 0x9F, 0xC8, 0x00, 0x0F,
  0x60, 0x00, 0x0A, 0xB0, 0x12, 0x01, 0xBC, 0xB1,
  // "₿" (U+20BF)
  0x9F, 0xDD, 0x60, 0x1F, 0x47, 0xE0, 0x1F, 0x48, 0xD0, 0x1F, 0xDF, 0x40, 0x1F, 0x45, 0xE1, 0x1F,
  0x43, 0xF3, 0x1F, 0x44, 0xF2, 0x8F, 0xCD, 0x70, 0x01, 0x67, 0x00,
  // "‘" (U+2018)
  0x00, 0x11, 0xA1, 0x5C, 0x03, 0xE1,
  // "’" (U+2019)
  0x4D, 0x01, 0xD2, 0x3A, 0x01, 0x00,
  // "‚" (U+201A)
  0x4D, 0x01, 0xD2, 0x3A, 0x01, 0x00,
  // "‛" (U+201B)
  0x3E, 0x15, 0xC0, 0x1A, 0x10, 0x01,
  // "“" (U+201C)
  0x00, 0x10, 0x11, 0xA2, 0xA2, 0x5C, 0x5D, 0x13, 0xE3, 0xE2,
  // "”" (U+201D)
  0x4D, 0x3E, 0x11, 0xD3, 0xD4, 0x3A, 0x2A, 0x01, 0x01, 0x00,
  // "„" (U+201E)
  0x4D, 0x3E, 0x11, 0xD3, 0xD4, 0x3A, 0x2A, 0x01, 0x01, 0x00,
  // "‟" (U+201F)
  0x3E, 0x3E, 0x25, 0xC5, 0xD1, 0x1A, 0x2A, 0x20, 0x01, 0x01,
  // "†" (U+2020)
  0x10, 0x20, 0xE4, 0x0C, 0x28, 0x92, 0x8B, 0xDB, 0x63, 0x3D, 0x32, 0x04, 0x93, 0x02, 0x0E, 0x40,
  0xC4, 0x0A, 0x40, 0x94, 0x04, 0x20,
  // "‡" (U+2021)
  0x02, 0xE0, 0x05, 0x5C, 0x63, 0x67, 0xD8, 0x40, 0x2E, 0x00, 0x00, 0x80, 0x00, 0x1C, 0x00, 0x12,
  0xD0, 0x1A, 0xDD, 0xE6, 0x00, 0xC0, 0x00, 0x17, 0x00,
  // "•" (U+2022)
  0x2D, 0xD2, 0x6F, 0xF5, 0x2D, 0xD2,
  // "…" (U+2026)
  0x2B, 0x21, 0xB2, 0x1B, 0x32, 0xE3, 0x2E, 0x31, 0xE4,
  // "‰" (U+2030)
  0x85, 0x2C, 0xC4, 0x05, 0x66, 0x84, 0x88, 0x4C, 0x0B, 0x78, 0x49, 0x73, 0xE3, 0x87, 0x8B, 0x07,
  0x95, 0xBA, 0x5B, 0xB1, 0x2B, 0xB1, 0x1A, 0xB5, 0xAB, 0x68, 0x8A, 0x67, 0x93, 0x89, 0x08, 0x4D,
  0x46, 0xAC, 0x46, 0xB3, 0x89, 0x0B, 0x0B, 0x57, 0x8B, 0x67, 0x92, 0x89, 0x15, 0x60, 0x4C, 0xC2,
  0x3C, 0xC2,
  // "‹" (U+2039)
  0x04, 0x92, 0xE2, 0x2E, 0x20, 0x49,
  // "›" (U+203A)
  0x1B, 0x00, 0x99, 0x09, 0xA1, 0xB0,
  // "⁄" (U+2044)
  0x30, 0x80, 0x43, 0x0B, 0x30, 0x60, 0x53, 0x0B, 0x30, 0x40, 0x73, 0x0B, 0x01, 0x20, 0x30, 0x93,
  0x09, 0x02, 0x30,
  // "™" (U+2122)
  0x57, 0x55, 0x60, 0x36, 0x18, 0x12, 0xB1, 0x76, 0x08, 0x11, 0x59, 0x56, 0x07, 0x33, 0x45, 0x36,
  // "⅒" (U+2152)
  0x10, 0x07, 0x20, 0x80, 0x45, 0x81, 0x49, 0x92, 0x0B, 0x78, 0x36, 0x90, 0x65, 0x78, 0xA1, 0x69,
  0x0B, 0x07, 0x70, 0x88, 0x12, 0x99, 0x77, 0x49, 0x98, 0x00, 0x73, 0x87, 0xB1, 0x06, 0x99, 0x66,
  0x92, 0x03, 0x09, 0x20, 0x60, 0x98, 0x00, 0x72, 0x87, 0x92, 0x02, 0x99, 0x38, 0x81,
  // "ﬁ" (U+FB01)
  0x03, 0xCC, 0xEB, 0x00, 0xCB, 0x04, 0x50, 0x8F, 0xEB, 0xCF, 0x20, 0xD9, 0x05, 0xF2, 0x0D, 0x90,
  0x5F, 0x20, 0xD9, 0x05, 0xF2, 0x0E, 0xA0, 0x5F, 0x3A, 0xFF, 0x9E, 0xFD,
  // "ﬂ" (U+FB02)
  0x03, 0xCC, 0xFF, 0x20, 0xCB, 0x07, 0xF2, 0x8F, 0xEA, 0x5F, 0x20, 0xD9, 0x05, 0xF2, 0x0D, 0x90,
  0x5F, 0x20, 0xD9, 0x05, 0xF2, 0x0E, 0xA0, 0x5F, 0x3A, 0xFF, 0x6E, 0xFD,
};

const Font& font_NotoSerif_Bold_10() {
  static SmoothFont font(font_NotoSerif_Bold_10_data);
  return font;
}

}  // namespace roo_display
