#include "8.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSans-Regular (Noto Sans Regular)
// Generated on Wed Nov 19 19:11:00 CET 2025
static const uint8_t font_NotoSans_Regular_8_data[] PROGMEM = {
  
  // Header
  0x01, 0x02, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x01, 0xCC,
  0xFE, 0xFE, 0x08, 0x0A, 0x07, 0xFE, 0x04, 0x01, 0x09, 0x04, 0x02, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x40, 0x01, 0x01, 0x07, 0x02, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x40, 0x05, 0x02, 0x07, 0x03, 0x00, 0x07, // """ (U+0022)
  0x00, 0x23, 0x40, 0x01, 0x04, 0x07, 0x05, 0x00, 0x0C, // "#" (U+0023)
  0x00, 0x24, 0x40, 0x00, 0x04, 0x07, 0x05, 0x00, 0x1E, // "$" (U+0024)
  0x00, 0x25, 0x40, 0x01, 0x06, 0x07, 0x07, 0x00, 0x32, // "%" (U+0025)
  0x00, 0x26, 0x40, 0x01, 0x05, 0x07, 0x06, 0x00, 0x4B, // "&" (U+0026)
  0x00, 0x27, 0x40, 0x06, 0x01, 0x07, 0x02, 0x00, 0x60, // "'" (U+0027)
  0x00, 0x28, 0x40, 0x00, 0x01, 0x07, 0x02, 0x00, 0x62, // "(" (U+0028)
  0x00, 0x29, 0x40, 0x00, 0x01, 0x07, 0x02, 0x00, 0x6A, // ")" (U+0029)
  0x00, 0x2A, 0x40, 0x04, 0x03, 0x07, 0x04, 0x00, 0x72, // "*" (U+002A)
  0x00, 0x2B, 0x00, 0x02, 0x04, 0x05, 0x05, 0x00, 0x7A, // "+" (U+002B)
  0x00, 0x2C, 0x40, 0x00, 0x01, 0x02, 0x02, 0x00, 0x83, // "," (U+002C)
  0x00, 0x2D, 0x40, 0x03, 0x02, 0x03, 0x03, 0x00, 0x86, // "-" (U+002D)
  0x00, 0x2E, 0x40, 0x01, 0x01, 0x01, 0x02, 0x00, 0x88, // "." (U+002E)
  0x00, 0x2F, 0x40, 0x01, 0x02, 0x07, 0x03, 0x00, 0x89, // "/" (U+002F)
  0x00, 0x30, 0x40, 0x01, 0x04, 0x07, 0x05, 0x00, 0x94, // "0" (U+0030)
  0x00, 0x31, 0x40, 0x01, 0x02, 0x07, 0x05, 0x00, 0xA6, // "1" (U+0031)
  0x00, 0x32, 0x40, 0x01, 0x04, 0x07, 0x05, 0x00, 0xB1, // "2" (U+0032)
  0x00, 0x33, 0x40, 0x01, 0x03, 0x07, 0x05, 0x00, 0xC3, // "3" (U+0033)
  0x00, 0x34, 0x40, 0x01, 0x04, 0x07, 0x05, 0x00, 0xD1, // "4" (U+0034)
  0x00, 0x35, 0x40, 0x01, 0x03, 0x07, 0x05, 0x00, 0xE3, // "5" (U+0035)
  0x00, 0x36, 0x40, 0x01, 0x04, 0x07, 0x05, 0x00, 0xF1, // "6" (U+0036)
  0x00, 0x37, 0x00, 0x01, 0x04, 0x07, 0x05, 0x01, 0x03, // "7" (U+0037)
  0x00, 0x38, 0x40, 0x01, 0x04, 0x07, 0x05, 0x01, 0x14, // "8" (U+0038)
  0x00, 0x39, 0x40, 0x01, 0x04, 0x07, 0x05, 0x01, 0x26, // "9" (U+0039)
  0x00, 0x3A, 0x40, 0x01, 0x01, 0x05, 0x02, 0x01, 0x38, // ":" (U+003A)
  0x00, 0x3B, 0x40, 0x00, 0x01, 0x05, 0x02, 0x01, 0x3D, // ";" (U+003B)
  0x00, 0x3C, 0x40, 0x02, 0x04, 0x05, 0x05, 0x01, 0x43, // "<" (U+003C)
  0x00, 0x3D, 0x40, 0x03, 0x04, 0x05, 0x05, 0x01, 0x4D, // "=" (U+003D)
  0x00, 0x3E, 0x40, 0x02, 0x04, 0x05, 0x05, 0x01, 0x55, // ">" (U+003E)
  0x00, 0x3F, 0x40, 0x01, 0x03, 0x07, 0x03, 0x01, 0x5F, // "?" (U+003F)
  0x00, 0x40, 0x40, 0x00, 0x06, 0x07, 0x07, 0x01, 0x6D, // "@" (U+0040)
  0x00, 0x41, 0x40, 0x01, 0x04, 0x07, 0x05, 0x01, 0x89, // "A" (U+0041)
  0x00, 0x42, 0x40, 0x01, 0x04, 0x07, 0x05, 0x01, 0x9B, // "B" (U+0042)
  0x00, 0x43, 0x40, 0x01, 0x04, 0x07, 0x05, 0x01, 0xAD, // "C" (U+0043)
  0x00, 0x44, 0x40, 0x01, 0x05, 0x07, 0x06, 0x01, 0xBF, // "D" (U+0044)
  0x00, 0x45, 0x40, 0x01, 0x03, 0x07, 0x04, 0x01, 0xD4, // "E" (U+0045)
  0x00, 0x46, 0x40, 0x01, 0x03, 0x07, 0x04, 0x01, 0xE2, // "F" (U+0046)
  0x00, 0x47, 0x40, 0x01, 0x05, 0x07, 0x06, 0x01, 0xF0, // "G" (U+0047)
  0x00, 0x48, 0x40, 0x01, 0x05, 0x07, 0x06, 0x02, 0x05, // "H" (U+0048)
  0x00, 0x49, 0x40, 0x01, 0x02, 0x07, 0x03, 0x02, 0x1A, // "I" (U+0049)
  0x00, 0x4A, 0xBF, 0x00, 0x01, 0x07, 0x02, 0x02, 0x25, // "J" (U+004A)
  0x00, 0x4B, 0x40, 0x01, 0x04, 0x07, 0x05, 0x02, 0x31, // "K" (U+004B)
  0x00, 0x4C, 0x40, 0x01, 0x03, 0x07, 0x04, 0x02, 0x43, // "L" (U+004C)
  0x00, 0x4D, 0x40, 0x01, 0x06, 0x07, 0x07, 0x02, 0x51, // "M" (U+004D)
  0x00, 0x4E, 0x40, 0x01, 0x05, 0x07, 0x06, 0x02, 0x6A, // "N" (U+004E)
  0x00, 0x4F, 0x40, 0x01, 0x05, 0x07, 0x06, 0x02, 0x7F, // "O" (U+004F)
  0x00, 0x50, 0x40, 0x01, 0x04, 0x07, 0x05, 0x02, 0x94, // "P" (U+0050)
  0x00, 0x51, 0x40, 0xFF, 0x05, 0x07, 0x06, 0x02, 0xA6, // "Q" (U+0051)
  0x00, 0x52, 0x40, 0x01, 0x04, 0x07, 0x05, 0x02, 0xC1, // "R" (U+0052)
  0x00, 0x53, 0x40, 0x01, 0x03, 0x07, 0x04, 0x02, 0xD3, // "S" (U+0053)
  0x00, 0x54, 0x40, 0x01, 0x04, 0x07, 0x04, 0x02, 0xE1, // "T" (U+0054)
  0x00, 0x55, 0x40, 0x01, 0x05, 0x07, 0x06, 0x02, 0xF3, // "U" (U+0055)
  0x00, 0x56, 0x40, 0x01, 0x04, 0x07, 0x05, 0x03, 0x08, // "V" (U+0056)
  0x00, 0x57, 0x40, 0x01, 0x07, 0x07, 0x07, 0x03, 0x1A, // "W" (U+0057)
  0x00, 0x58, 0x40, 0x01, 0x04, 0x07, 0x05, 0x03, 0x36, // "X" (U+0058)
  0x00, 0x59, 0x40, 0x01, 0x04, 0x07, 0x05, 0x03, 0x48, // "Y" (U+0059)
  0x00, 0x5A, 0x40, 0x01, 0x04, 0x07, 0x05, 0x03, 0x5A, // "Z" (U+005A)
  0x00, 0x5B, 0x40, 0x00, 0x02, 0x07, 0x03, 0x03, 0x6C, // "[" (U+005B)
  0x00, 0x5C, 0x40, 0x01, 0x02, 0x07, 0x03, 0x03, 0x78, // "\" (U+005C)
  0x00, 0x5D, 0x40, 0x00, 0x01, 0x07, 0x03, 0x03, 0x83, // "]" (U+005D)
  0x00, 0x5E, 0x40, 0x03, 0x04, 0x06, 0x05, 0x03, 0x8B, // "^" (U+005E)
  0x00, 0x5F, 0x40, 0xFF, 0x03, 0xFF, 0x04, 0x03, 0x95, // "_" (U+005F)
  0x00, 0x60, 0x40, 0x07, 0x01, 0x08, 0x02, 0x03, 0x97, // "`" (U+0060)
  0x00, 0x61, 0x40, 0x01, 0x03, 0x05, 0x04, 0x03, 0x99, // "a" (U+0061)
  0x00, 0x62, 0x40, 0x01, 0x04, 0x07, 0x05, 0x03, 0xA3, // "b" (U+0062)
  0x00, 0x63, 0x40, 0x01, 0x03, 0x05, 0x04, 0x03, 0xB5, // "c" (U+0063)
  0x00, 0x64, 0x40, 0x01, 0x04, 0x07, 0x05, 0x03, 0xBF, // "d" (U+0064)
  0x00, 0x65, 0x40, 0x01, 0x04, 0x05, 0x05, 0x03, 0xD1, // "e" (U+0065)
  0x00, 0x66, 0x40, 0x01, 0x02, 0x07, 0x03, 0x03, 0xDE, // "f" (U+0066)
  0x00, 0x67, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x03, 0xE9, // "g" (U+0067)
  0x00, 0x68, 0x40, 0x01, 0x04, 0x07, 0x05, 0x03, 0xFB, // "h" (U+0068)
  0x00, 0x69, 0x40, 0x01, 0x01, 0x07, 0x02, 0x04, 0x0D, // "i" (U+0069)
  0x00, 0x6A, 0xBF, 0xFF, 0x01, 0x07, 0x02, 0x04, 0x14, // "j" (U+006A)
  0x00, 0x6B, 0x40, 0x01, 0x03, 0x07, 0x04, 0x04, 0x22, // "k" (U+006B)
  0x00, 0x6C, 0x40, 0x01, 0x01, 0x07, 0x02, 0x04, 0x30, // "l" (U+006C)
  0x00, 0x6D, 0x40, 0x01, 0x06, 0x05, 0x07, 0x04, 0x37, // "m" (U+006D)
  0x00, 0x6E, 0x40, 0x01, 0x04, 0x05, 0x05, 0x04, 0x49, // "n" (U+006E)
  0x00, 0x6F, 0x40, 0x01, 0x04, 0x05, 0x05, 0x04, 0x56, // "o" (U+006F)
  0x00, 0x70, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x04, 0x63, // "p" (U+0070)
  0x00, 0x71, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x04, 0x75, // "q" (U+0071)
  0x00, 0x72, 0x40, 0x01, 0x03, 0x05, 0x03, 0x04, 0x87, // "r" (U+0072)
  0x00, 0x73, 0x40, 0x01, 0x03, 0x05, 0x04, 0x04, 0x91, // "s" (U+0073)
  0x00, 0x74, 0x40, 0x01, 0x02, 0x06, 0x03, 0x04, 0x9B, // "t" (U+0074)
  0x00, 0x75, 0x40, 0x01, 0x04, 0x05, 0x05, 0x04, 0xA4, // "u" (U+0075)
  0x00, 0x76, 0x40, 0x01, 0x03, 0x05, 0x04, 0x04, 0xB1, // "v" (U+0076)
  0x00, 0x77, 0x40, 0x01, 0x06, 0x05, 0x06, 0x04, 0xBB, // "w" (U+0077)
  0x00, 0x78, 0x40, 0x01, 0x03, 0x05, 0x04, 0x04, 0xCD, // "x" (U+0078)
  0x00, 0x79, 0x40, 0xFF, 0x03, 0x05, 0x04, 0x04, 0xD7, // "y" (U+0079)
  0x00, 0x7A, 0x40, 0x01, 0x03, 0x05, 0x04, 0x04, 0xE5, // "z" (U+007A)
  0x00, 0x7B, 0x40, 0x00, 0x02, 0x07, 0x03, 0x04, 0xEF, // "{" (U+007B)
  0x00, 0x7C, 0x41, 0xFF, 0x02, 0x07, 0x04, 0x04, 0xFB, // "|" (U+007C)
  0x00, 0x7D, 0x40, 0x00, 0x02, 0x07, 0x03, 0x05, 0x04, // "}" (U+007D)
  0x00, 0x7E, 0x40, 0x03, 0x04, 0x04, 0x05, 0x05, 0x10, // "~" (U+007E)
  0x00, 0xA1, 0x40, 0x00, 0x01, 0x05, 0x02, 0x05, 0x15, // "¡" (U+00A1)
  0x00, 0xA2, 0x40, 0x01, 0x03, 0x07, 0x05, 0x05, 0x1B, // "¢" (U+00A2)
  0x00, 0xA3, 0x40, 0x01, 0x04, 0x07, 0x05, 0x05, 0x29, // "£" (U+00A3)
  0x00, 0xA4, 0x40, 0x02, 0x03, 0x05, 0x05, 0x05, 0x3B, // "¤" (U+00A4)
  0x00, 0xA5, 0x40, 0x01, 0x04, 0x07, 0x05, 0x05, 0x43, // "¥" (U+00A5)
  0x00, 0xA6, 0x41, 0xFF, 0x02, 0x07, 0x04, 0x05, 0x55, // "¦" (U+00A6)
  0x00, 0xA7, 0x40, 0x01, 0x03, 0x07, 0x04, 0x05, 0x5E, // "§" (U+00A7)
  0x00, 0xA8, 0x41, 0x07, 0x03, 0x07, 0x05, 0x05, 0x6C, // "¨" (U+00A8)
  0x00, 0xA9, 0x40, 0x01, 0x06, 0x07, 0x07, 0x05, 0x6E, // "©" (U+00A9)
  0x00, 0xAA, 0x40, 0x04, 0x02, 0x06, 0x03, 0x05, 0x87, // "ª" (U+00AA)
  0x00, 0xAB, 0x40, 0x01, 0x03, 0x04, 0x04, 0x05, 0x8C, // "«" (U+00AB)
  0x00, 0xAC, 0x40, 0x02, 0x04, 0x04, 0x05, 0x05, 0x94, // "¬" (U+00AC)
  0x00, 0xAE, 0x40, 0x01, 0x06, 0x07, 0x07, 0x05, 0x9C, // "®" (U+00AE)
  0x00, 0xAF, 0x40, 0x08, 0x03, 0x08, 0x04, 0x05, 0xB5, // "¯" (U+00AF)
  0x00, 0xB0, 0x40, 0x05, 0x02, 0x07, 0x03, 0x05, 0xB7, // "°" (U+00B0)
  0x00, 0xB1, 0x40, 0x01, 0x04, 0x05, 0x05, 0x05, 0xBC, // "±" (U+00B1)
  0x00, 0xB2, 0x40, 0x04, 0x02, 0x07, 0x03, 0x05, 0xC9, // "²" (U+00B2)
  0x00, 0xB3, 0x40, 0x04, 0x02, 0x07, 0x03, 0x05, 0xCF, // "³" (U+00B3)
  0x00, 0xB4, 0x40, 0x07, 0x01, 0x08, 0x02, 0x05, 0xD5, // "´" (U+00B4)
  0x00, 0xB5, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x05, 0xD7, // "µ" (U+00B5)
  0x00, 0xB6, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x05, 0xE9, // "¶" (U+00B6)
  0x00, 0xB7, 0x40, 0x03, 0x01, 0x03, 0x02, 0x06, 0x00, // "·" (U+00B7)
  0x00, 0xB8, 0x40, 0xFF, 0x01, 0x01, 0x02, 0x06, 0x01, // "¸" (U+00B8)
  0x00, 0xB9, 0x40, 0x04, 0x01, 0x07, 0x03, 0x06, 0x04, // "¹" (U+00B9)
  0x00, 0xBA, 0x40, 0x04, 0x02, 0x06, 0x03, 0x06, 0x08, // "º" (U+00BA)
  0x00, 0xBB, 0x40, 0x01, 0x03, 0x04, 0x04, 0x06, 0x0D, // "»" (U+00BB)
  0x00, 0xBC, 0x40, 0x01, 0x05, 0x07, 0x06, 0x06, 0x15, // "¼" (U+00BC)
  0x00, 0xBD, 0x40, 0x01, 0x05, 0x07, 0x06, 0x06, 0x2A, // "½" (U+00BD)
  0x00, 0xBE, 0x40, 0x01, 0x06, 0x07, 0x06, 0x06, 0x3F, // "¾" (U+00BE)
  0x00, 0xBF, 0xBF, 0xFE, 0x02, 0x04, 0x03, 0x06, 0x58, // "¿" (U+00BF)
  0x00, 0xC0, 0x40, 0x01, 0x04, 0x09, 0x05, 0x06, 0x66, // "À" (U+00C0)
  0x00, 0xC1, 0x40, 0x01, 0x04, 0x09, 0x05, 0x06, 0x7D, // "Á" (U+00C1)
  0x00, 0xC2, 0x40, 0x01, 0x04, 0x09, 0x05, 0x06, 0x94, // "Â" (U+00C2)
  0x00, 0xC3, 0x40, 0x01, 0x04, 0x07, 0x05, 0x06, 0xAB, // "Ã" (U+00C3)
  0x00, 0xC4, 0x40, 0x01, 0x04, 0x08, 0x05, 0x06, 0xBD, // "Ä" (U+00C4)
  0x00, 0xC5, 0x40, 0x01, 0x04, 0x07, 0x05, 0x06, 0xD1, // "Å" (U+00C5)
  0x00, 0xC6, 0x40, 0x01, 0x06, 0x07, 0x07, 0x06, 0xE3, // "Æ" (U+00C6)
  0x00, 0xC7, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x06, 0xFC, // "Ç" (U+00C7)
  0x00, 0xC8, 0x40, 0x01, 0x03, 0x09, 0x04, 0x07, 0x13, // "È" (U+00C8)
  0x00, 0xC9, 0x40, 0x01, 0x03, 0x09, 0x04, 0x07, 0x25, // "É" (U+00C9)
  0x00, 0xCA, 0x40, 0x01, 0x03, 0x09, 0x04, 0x07, 0x37, // "Ê" (U+00CA)
  0x00, 0xCB, 0x40, 0x01, 0x03, 0x08, 0x04, 0x07, 0x49, // "Ë" (U+00CB)
  0x00, 0xCC, 0x40, 0x01, 0x02, 0x09, 0x03, 0x07, 0x59, // "Ì" (U+00CC)
  0x00, 0xCD, 0x40, 0x01, 0x02, 0x09, 0x03, 0x07, 0x67, // "Í" (U+00CD)
  0x00, 0xCE, 0x40, 0x01, 0x02, 0x09, 0x03, 0x07, 0x75, // "Î" (U+00CE)
  0x00, 0xCF, 0x40, 0x01, 0x02, 0x08, 0x03, 0x07, 0x83, // "Ï" (U+00CF)
  0x00, 0xD0, 0x40, 0x01, 0x05, 0x07, 0x06, 0x07, 0x8F, // "Ð" (U+00D0)
  0x00, 0xD1, 0x40, 0x01, 0x05, 0x07, 0x06, 0x07, 0xA4, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x40, 0x01, 0x05, 0x09, 0x06, 0x07, 0xB9, // "Ò" (U+00D2)
  0x00, 0xD3, 0x40, 0x01, 0x05, 0x09, 0x06, 0x07, 0xD4, // "Ó" (U+00D3)
  0x00, 0xD4, 0x40, 0x01, 0x05, 0x09, 0x06, 0x07, 0xEF, // "Ô" (U+00D4)
  0x00, 0xD5, 0x40, 0x01, 0x05, 0x07, 0x06, 0x08, 0x0A, // "Õ" (U+00D5)
  0x00, 0xD6, 0x40, 0x01, 0x05, 0x08, 0x06, 0x08, 0x1F, // "Ö" (U+00D6)
  0x00, 0xD7, 0x40, 0x02, 0x03, 0x05, 0x05, 0x08, 0x37, // "×" (U+00D7)
  0x00, 0xD8, 0x40, 0x01, 0x05, 0x07, 0x06, 0x08, 0x3F, // "Ø" (U+00D8)
  0x00, 0xD9, 0x40, 0x01, 0x05, 0x09, 0x06, 0x08, 0x54, // "Ù" (U+00D9)
  0x00, 0xDA, 0x40, 0x01, 0x05, 0x09, 0x06, 0x08, 0x6F, // "Ú" (U+00DA)
  0x00, 0xDB, 0x40, 0x01, 0x05, 0x09, 0x06, 0x08, 0x8A, // "Û" (U+00DB)
  0x00, 0xDC, 0x40, 0x01, 0x05, 0x08, 0x06, 0x08, 0xA5, // "Ü" (U+00DC)
  0x00, 0xDD, 0x40, 0x01, 0x04, 0x09, 0x05, 0x08, 0xBD, // "Ý" (U+00DD)
  0x00, 0xDE, 0x40, 0x01, 0x04, 0x07, 0x05, 0x08, 0xD4, // "Þ" (U+00DE)
  0x00, 0xDF, 0x40, 0x01, 0x04, 0x07, 0x05, 0x08, 0xE6, // "ß" (U+00DF)
  0x00, 0xE0, 0x40, 0x01, 0x03, 0x08, 0x04, 0x08, 0xF8, // "à" (U+00E0)
  0x00, 0xE1, 0x40, 0x01, 0x03, 0x08, 0x04, 0x09, 0x08, // "á" (U+00E1)
  0x00, 0xE2, 0x40, 0x01, 0x03, 0x08, 0x04, 0x09, 0x18, // "â" (U+00E2)
  0x00, 0xE3, 0x40, 0x01, 0x03, 0x06, 0x04, 0x09, 0x28, // "ã" (U+00E3)
  0x00, 0xE4, 0x40, 0x01, 0x03, 0x07, 0x04, 0x09, 0x34, // "ä" (U+00E4)
  0x00, 0xE5, 0x40, 0x01, 0x03, 0x07, 0x04, 0x09, 0x42, // "å" (U+00E5)
  0x00, 0xE6, 0x40, 0x01, 0x06, 0x05, 0x07, 0x09, 0x50, // "æ" (U+00E6)
  0x00, 0xE7, 0x40, 0xFF, 0x03, 0x05, 0x04, 0x09, 0x62, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x01, 0x04, 0x08, 0x05, 0x09, 0x70, // "è" (U+00E8)
  0x00, 0xE9, 0x00, 0x01, 0x04, 0x08, 0x05, 0x09, 0x83, // "é" (U+00E9)
  0x00, 0xEA, 0x00, 0x01, 0x04, 0x08, 0x05, 0x09, 0x95, // "ê" (U+00EA)
  0x00, 0xEB, 0x00, 0x01, 0x04, 0x07, 0x05, 0x09, 0xA8, // "ë" (U+00EB)
  0x00, 0xEC, 0x40, 0x01, 0x01, 0x08, 0x02, 0x09, 0xB9, // "ì" (U+00EC)
  0x00, 0xED, 0x40, 0x01, 0x01, 0x08, 0x02, 0x09, 0xC1, // "í" (U+00ED)
  0x00, 0xEE, 0xBF, 0x01, 0x01, 0x08, 0x02, 0x09, 0xC9, // "î" (U+00EE)
  0x00, 0xEF, 0x40, 0x01, 0x02, 0x07, 0x02, 0x09, 0xD5, // "ï" (U+00EF)
  0x00, 0xF0, 0x40, 0x01, 0x04, 0x08, 0x05, 0x09, 0xE0, // "ð" (U+00F0)
  0x00, 0xF1, 0x40, 0x01, 0x04, 0x06, 0x05, 0x09, 0xF4, // "ñ" (U+00F1)
  0x00, 0xF2, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0A, 0x03, // "ò" (U+00F2)
  0x00, 0xF3, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0A, 0x17, // "ó" (U+00F3)
  0x00, 0xF4, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0A, 0x29, // "ô" (U+00F4)
  0x00, 0xF5, 0x40, 0x01, 0x04, 0x06, 0x05, 0x0A, 0x3D, // "õ" (U+00F5)
  0x00, 0xF6, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x4C, // "ö" (U+00F6)
  0x00, 0xF7, 0x40, 0x02, 0x04, 0x05, 0x05, 0x0A, 0x5D, // "÷" (U+00F7)
  0x00, 0xF8, 0x40, 0x01, 0x04, 0x05, 0x05, 0x0A, 0x67, // "ø" (U+00F8)
  0x00, 0xF9, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0A, 0x74, // "ù" (U+00F9)
  0x00, 0xFA, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0A, 0x88, // "ú" (U+00FA)
  0x00, 0xFB, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0A, 0x9B, // "û" (U+00FB)
  0x00, 0xFC, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0A, 0xAF, // "ü" (U+00FC)
  0x00, 0xFD, 0x40, 0xFF, 0x03, 0x08, 0x04, 0x0A, 0xC1, // "ý" (U+00FD)
  0x00, 0xFE, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x0A, 0xD5, // "þ" (U+00FE)
  0x00, 0xFF, 0x40, 0xFF, 0x03, 0x07, 0x04, 0x0A, 0xEC, // "ÿ" (U+00FF)
  0x01, 0x00, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0A, 0xFE, // "Ā" (U+0100)
  0x01, 0x01, 0x40, 0x01, 0x03, 0x06, 0x04, 0x0B, 0x10, // "ā" (U+0101)
  0x01, 0x02, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0B, 0x1C, // "Ă" (U+0102)
  0x01, 0x03, 0x40, 0x01, 0x03, 0x07, 0x04, 0x0B, 0x30, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0B, 0x3E, // "Ą" (U+0104)
  0x01, 0x05, 0x40, 0xFF, 0x03, 0x05, 0x04, 0x0B, 0x54, // "ą" (U+0105)
  0x01, 0x06, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0B, 0x62, // "Ć" (U+0106)
  0x01, 0x07, 0x40, 0x01, 0x03, 0x08, 0x04, 0x0B, 0x78, // "ć" (U+0107)
  0x01, 0x08, 0x40, 0x01, 0x04, 0x09, 0x05, 0x0B, 0x88, // "Ĉ" (U+0108)
  0x01, 0x09, 0x40, 0x01, 0x03, 0x08, 0x04, 0x0B, 0x9F, // "ĉ" (U+0109)
  0x01, 0x0A, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0B, 0xAF, // "Ċ" (U+010A)
  0x01, 0x0B, 0x40, 0x01, 0x03, 0x07, 0x04, 0x0B, 0xC3, // "ċ" (U+010B)
  0x01, 0x0C, 0x40, 0x01, 0x04, 0x09, 0x05, 0x0B, 0xD1, // "Č" (U+010C)
  0x01, 0x0D, 0x40, 0x01, 0x03, 0x08, 0x04, 0x0B, 0xE8, // "č" (U+010D)
  0x01, 0x0E, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0B, 0xF8, // "Ď" (U+010E)
  0x01, 0x0F, 0x40, 0x01, 0x05, 0x07, 0x05, 0x0C, 0x13, // "ď" (U+010F)
  0x01, 0x10, 0x40, 0x01, 0x05, 0x07, 0x06, 0x0C, 0x28, // "Đ" (U+0110)
  0x01, 0x11, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0C, 0x3D, // "đ" (U+0111)
  0x01, 0x12, 0x40, 0x01, 0x03, 0x07, 0x04, 0x0C, 0x4F, // "Ē" (U+0112)
  0x01, 0x13, 0x40, 0x01, 0x04, 0x06, 0x05, 0x0C, 0x5D, // "ē" (U+0113)
  0x01, 0x14, 0x40, 0x01, 0x03, 0x08, 0x04, 0x0C, 0x6C, // "Ĕ" (U+0114)
  0x01, 0x15, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0C, 0x7C, // "ĕ" (U+0115)
  0x01, 0x16, 0x40, 0x01, 0x03, 0x08, 0x04, 0x0C, 0x8E, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0C, 0x9E, // "ė" (U+0117)
  0x01, 0x18, 0x40, 0xFF, 0x03, 0x07, 0x04, 0x0C, 0xAE, // "Ę" (U+0118)
  0x01, 0x19, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x0C, 0xC0, // "ę" (U+0119)
  0x01, 0x1A, 0x40, 0x01, 0x03, 0x09, 0x04, 0x0C, 0xD2, // "Ě" (U+011A)
  0x01, 0x1B, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0C, 0xE4, // "ě" (U+011B)
  0x01, 0x1C, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0C, 0xF8, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x40, 0xFF, 0x04, 0x08, 0x05, 0x0D, 0x13, // "ĝ" (U+011D)
  0x01, 0x1E, 0x40, 0x01, 0x05, 0x08, 0x06, 0x0D, 0x2C, // "Ğ" (U+011E)
  0x01, 0x1F, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x0D, 0x44, // "ğ" (U+011F)
  0x01, 0x20, 0x40, 0x01, 0x05, 0x08, 0x06, 0x0D, 0x5B, // "Ġ" (U+0120)
  0x01, 0x21, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0D, 0x73, // "ġ" (U+0121)
  0x01, 0x22, 0x40, 0xFF, 0x05, 0x07, 0x06, 0x0D, 0x88, // "Ģ" (U+0122)
  0x01, 0x23, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0D, 0xA3, // "ģ" (U+0123)
  0x01, 0x24, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0D, 0xB9, // "Ĥ" (U+0124)
  0x01, 0x25, 0xFF, 0x01, 0x04, 0x0A, 0x05, 0x0D, 0xD4, // "ĥ" (U+0125)
  0x01, 0x26, 0x40, 0x01, 0x05, 0x07, 0x06, 0x0D, 0xF0, // "Ħ" (U+0126)
  0x01, 0x27, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0E, 0x05, // "ħ" (U+0127)
  0x01, 0x28, 0x40, 0x01, 0x03, 0x07, 0x03, 0x0E, 0x17, // "Ĩ" (U+0128)
  0x01, 0x29, 0xBF, 0x01, 0x02, 0x06, 0x02, 0x0E, 0x25, // "ĩ" (U+0129)
  0x01, 0x2A, 0x40, 0x01, 0x02, 0x07, 0x03, 0x0E, 0x31, // "Ī" (U+012A)
  0x01, 0x2B, 0x40, 0x01, 0x02, 0x06, 0x02, 0x0E, 0x3C, // "ī" (U+012B)
  0x01, 0x2C, 0x40, 0x01, 0x02, 0x08, 0x03, 0x0E, 0x45, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x40, 0x01, 0x02, 0x07, 0x02, 0x0E, 0x51, // "ĭ" (U+012D)
  0x01, 0x2E, 0x40, 0xFF, 0x02, 0x07, 0x03, 0x0E, 0x5C, // "Į" (U+012E)
  0x01, 0x2F, 0x40, 0xFF, 0x01, 0x07, 0x02, 0x0E, 0x6A, // "į" (U+012F)
  0x01, 0x30, 0x40, 0x01, 0x02, 0x08, 0x03, 0x0E, 0x73, // "İ" (U+0130)
  0x01, 0x31, 0x40, 0x01, 0x01, 0x05, 0x02, 0x0E, 0x7F, // "ı" (U+0131)
  0x01, 0x32, 0x40, 0x00, 0x04, 0x07, 0x05, 0x0E, 0x84, // "Ĳ" (U+0132)
  0x01, 0x33, 0x40, 0xFF, 0x03, 0x07, 0x04, 0x0E, 0x98, // "ĳ" (U+0133)
  0x01, 0x34, 0xBF, 0x00, 0x01, 0x09, 0x02, 0x0E, 0xAA, // "Ĵ" (U+0134)
  0x01, 0x35, 0xBF, 0xFF, 0x01, 0x08, 0x02, 0x0E, 0xB9, // "ĵ" (U+0135)
  0x01, 0x36, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x0E, 0xC8, // "Ķ" (U+0136)
  0x01, 0x37, 0x40, 0xFF, 0x03, 0x07, 0x04, 0x0E, 0xDF, // "ķ" (U+0137)
  0x01, 0x38, 0x40, 0x01, 0x03, 0x05, 0x04, 0x0E, 0xF1, // "ĸ" (U+0138)
  0x01, 0x39, 0x40, 0x01, 0x03, 0x09, 0x04, 0x0E, 0xFB, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x40, 0x01, 0x01, 0x0A, 0x02, 0x0F, 0x0D, // "ĺ" (U+013A)
  0x01, 0x3B, 0x40, 0xFF, 0x03, 0x07, 0x04, 0x0F, 0x17, // "Ļ" (U+013B)
  0x01, 0x3C, 0x40, 0xFF, 0x01, 0x07, 0x02, 0x0F, 0x29, // "ļ" (U+013C)
  0x01, 0x3D, 0x40, 0x01, 0x03, 0x07, 0x04, 0x0F, 0x32, // "Ľ" (U+013D)
  0x01, 0x3E, 0x40, 0x01, 0x02, 0x07, 0x02, 0x0F, 0x40, // "ľ" (U+013E)
  0x01, 0x3F, 0x40, 0x01, 0x03, 0x07, 0x04, 0x0F, 0x4B, // "Ŀ" (U+013F)
  0x01, 0x40, 0x40, 0x01, 0x01, 0x07, 0x02, 0x0F, 0x59, // "ŀ" (U+0140)
  0x01, 0x41, 0x40, 0x01, 0x03, 0x07, 0x04, 0x0F, 0x60, // "Ł" (U+0141)
  0x01, 0x42, 0x40, 0x01, 0x01, 0x07, 0x02, 0x0F, 0x6E, // "ł" (U+0142)
  0x01, 0x43, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0F, 0x75, // "Ń" (U+0143)
  0x01, 0x44, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0F, 0x90, // "ń" (U+0144)
  0x01, 0x45, 0x40, 0xFF, 0x05, 0x07, 0x06, 0x0F, 0xA3, // "Ņ" (U+0145)
  0x01, 0x46, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x0F, 0xBE, // "ņ" (U+0146)
  0x01, 0x47, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0F, 0xD0, // "Ň" (U+0147)
  0x01, 0x48, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0F, 0xEB, // "ň" (U+0148)
  0x01, 0x49, 0x40, 0x01, 0x05, 0x07, 0x06, 0x0F, 0xFF, // "ŉ" (U+0149)
  0x01, 0x4A, 0x40, 0xFF, 0x05, 0x07, 0x06, 0x10, 0x14, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x10, 0x2F, // "ŋ" (U+014B)
  0x01, 0x4C, 0x40, 0x01, 0x05, 0x07, 0x06, 0x10, 0x41, // "Ō" (U+014C)
  0x01, 0x4D, 0x40, 0x01, 0x04, 0x06, 0x05, 0x10, 0x56, // "ō" (U+014D)
  0x01, 0x4E, 0x40, 0x01, 0x05, 0x08, 0x06, 0x10, 0x65, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x40, 0x01, 0x04, 0x07, 0x05, 0x10, 0x7D, // "ŏ" (U+014F)
  0x01, 0x50, 0x40, 0x01, 0x05, 0x08, 0x06, 0x10, 0x8F, // "Ő" (U+0150)
  0x01, 0x51, 0x40, 0x01, 0x04, 0x07, 0x05, 0x10, 0xA7, // "ő" (U+0151)
  0x01, 0x52, 0x40, 0x01, 0x06, 0x07, 0x07, 0x10, 0xB9, // "Œ" (U+0152)
  0x01, 0x53, 0x40, 0x01, 0x07, 0x05, 0x08, 0x10, 0xD2, // "œ" (U+0153)
  0x01, 0x54, 0x40, 0x01, 0x04, 0x09, 0x05, 0x10, 0xE6, // "Ŕ" (U+0154)
  0x01, 0x55, 0x40, 0x01, 0x03, 0x08, 0x03, 0x10, 0xFD, // "ŕ" (U+0155)
  0x01, 0x56, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x11, 0x0D, // "Ŗ" (U+0156)
  0x01, 0x57, 0x40, 0xFF, 0x03, 0x05, 0x03, 0x11, 0x24, // "ŗ" (U+0157)
  0x01, 0x58, 0x40, 0x01, 0x04, 0x09, 0x05, 0x11, 0x32, // "Ř" (U+0158)
  0x01, 0x59, 0x40, 0x01, 0x03, 0x08, 0x03, 0x11, 0x49, // "ř" (U+0159)
  0x01, 0x5A, 0x40, 0x01, 0x03, 0x09, 0x04, 0x11, 0x59, // "Ś" (U+015A)
  0x01, 0x5B, 0x40, 0x01, 0x03, 0x08, 0x04, 0x11, 0x6B, // "ś" (U+015B)
  0x01, 0x5C, 0x40, 0x01, 0x03, 0x09, 0x04, 0x11, 0x7B, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x40, 0x01, 0x03, 0x08, 0x04, 0x11, 0x8D, // "ŝ" (U+015D)
  0x01, 0x5E, 0x40, 0xFF, 0x03, 0x07, 0x04, 0x11, 0x9D, // "Ş" (U+015E)
  0x01, 0x5F, 0x40, 0xFF, 0x03, 0x05, 0x04, 0x11, 0xAF, // "ş" (U+015F)
  0x01, 0x60, 0x40, 0x01, 0x03, 0x09, 0x04, 0x11, 0xBD, // "Š" (U+0160)
  0x01, 0x61, 0x40, 0x01, 0x03, 0x08, 0x04, 0x11, 0xCF, // "š" (U+0161)
  0x01, 0x62, 0x40, 0xFF, 0x04, 0x07, 0x04, 0x11, 0xDF, // "Ţ" (U+0162)
  0x01, 0x63, 0x40, 0xFF, 0x02, 0x06, 0x03, 0x11, 0xF6, // "ţ" (U+0163)
  0x01, 0x64, 0x40, 0x01, 0x04, 0x09, 0x04, 0x12, 0x02, // "Ť" (U+0164)
  0x01, 0x65, 0x40, 0x01, 0x03, 0x07, 0x03, 0x12, 0x19, // "ť" (U+0165)
  0x01, 0x66, 0x40, 0x01, 0x04, 0x07, 0x04, 0x12, 0x27, // "Ŧ" (U+0166)
  0x01, 0x67, 0x40, 0x01, 0x02, 0x06, 0x03, 0x12, 0x39, // "ŧ" (U+0167)
  0x01, 0x68, 0x40, 0x01, 0x05, 0x07, 0x06, 0x12, 0x42, // "Ũ" (U+0168)
  0x01, 0x69, 0x40, 0x01, 0x04, 0x06, 0x05, 0x12, 0x57, // "ũ" (U+0169)
  0x01, 0x6A, 0x40, 0x01, 0x05, 0x07, 0x06, 0x12, 0x66, // "Ū" (U+016A)
  0x01, 0x6B, 0x40, 0x01, 0x04, 0x06, 0x05, 0x12, 0x7B, // "ū" (U+016B)
  0x01, 0x6C, 0x40, 0x01, 0x05, 0x08, 0x06, 0x12, 0x8A, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x40, 0x01, 0x04, 0x07, 0x05, 0x12, 0xA2, // "ŭ" (U+016D)
  0x01, 0x6E, 0x40, 0x01, 0x05, 0x08, 0x06, 0x12, 0xB4, // "Ů" (U+016E)
  0x01, 0x6F, 0x40, 0x01, 0x04, 0x07, 0x05, 0x12, 0xCC, // "ů" (U+016F)
  0x01, 0x70, 0x40, 0x01, 0x05, 0x08, 0x06, 0x12, 0xDE, // "Ű" (U+0170)
  0x01, 0x71, 0x40, 0x01, 0x04, 0x07, 0x05, 0x12, 0xF6, // "ű" (U+0171)
  0x01, 0x72, 0x40, 0xFF, 0x05, 0x07, 0x06, 0x13, 0x08, // "Ų" (U+0172)
  0x01, 0x73, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x13, 0x23, // "ų" (U+0173)
  0x01, 0x74, 0x40, 0x01, 0x07, 0x09, 0x07, 0x13, 0x35, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x06, 0x08, 0x06, 0x13, 0x59, // "ŵ" (U+0175)
  0x01, 0x76, 0x40, 0x01, 0x04, 0x09, 0x05, 0x13, 0x73, // "Ŷ" (U+0176)
  0x01, 0x77, 0x40, 0xFF, 0x03, 0x08, 0x04, 0x13, 0x8A, // "ŷ" (U+0177)
  0x01, 0x78, 0x40, 0x01, 0x04, 0x08, 0x05, 0x13, 0x9E, // "Ÿ" (U+0178)
  0x01, 0x79, 0x40, 0x01, 0x04, 0x09, 0x05, 0x13, 0xB2, // "Ź" (U+0179)
  0x01, 0x7A, 0x40, 0x01, 0x03, 0x08, 0x04, 0x13, 0xC9, // "ź" (U+017A)
  0x01, 0x7B, 0x40, 0x01, 0x04, 0x08, 0x05, 0x13, 0xD9, // "Ż" (U+017B)
  0x01, 0x7C, 0x40, 0x01, 0x03, 0x07, 0x04, 0x13, 0xED, // "ż" (U+017C)
  0x01, 0x7D, 0x40, 0x01, 0x04, 0x09, 0x05, 0x13, 0xFB, // "Ž" (U+017D)
  0x01, 0x7E, 0x40, 0x01, 0x03, 0x08, 0x04, 0x14, 0x12, // "ž" (U+017E)
  0x01, 0x7F, 0x40, 0x01, 0x02, 0x07, 0x03, 0x14, 0x22, // "ſ" (U+017F)
  0x03, 0xA9, 0x40, 0x01, 0x05, 0x07, 0x06, 0x14, 0x2D, // "Ω" (U+03A9)
  0x03, 0xBC, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x14, 0x42, // "μ" (U+03BC)
  0x03, 0xC0, 0x40, 0x01, 0x04, 0x05, 0x05, 0x14, 0x54, // "π" (U+03C0)
  0x20, 0x13, 0x40, 0x03, 0x03, 0x03, 0x04, 0x14, 0x61, // "–" (U+2013)
  0x20, 0x14, 0x40, 0x03, 0x07, 0x03, 0x08, 0x14, 0x63, // "—" (U+2014)
  0x20, 0xAC, 0x40, 0x01, 0x04, 0x07, 0x05, 0x14, 0x67, // "€" (U+20AC)
  0x20, 0xBF, 0x40, 0x00, 0x04, 0x08, 0x05, 0x14, 0x79, // "₿" (U+20BF)
  0x20, 0x18, 0x40, 0x05, 0x01, 0x07, 0x01, 0x14, 0x90, // "‘" (U+2018)
  0x20, 0x19, 0x40, 0x05, 0x01, 0x07, 0x01, 0x14, 0x93, // "’" (U+2019)
  0x20, 0x1A, 0x40, 0x00, 0x01, 0x02, 0x02, 0x14, 0x96, // "‚" (U+201A)
  0x20, 0x1B, 0x40, 0x06, 0x01, 0x07, 0x01, 0x14, 0x99, // "‛" (U+201B)
  0x20, 0x1C, 0x40, 0x05, 0x02, 0x07, 0x03, 0x14, 0x9B, // "“" (U+201C)
  0x20, 0x1D, 0x40, 0x05, 0x02, 0x07, 0x03, 0x14, 0xA0, // "”" (U+201D)
  0x20, 0x1E, 0x40, 0x00, 0x02, 0x02, 0x03, 0x14, 0xA5, // "„" (U+201E)
  0x20, 0x1F, 0x40, 0x05, 0x02, 0x07, 0x03, 0x14, 0xAA, // "‟" (U+201F)
  0x20, 0x20, 0x40, 0x01, 0x03, 0x07, 0x04, 0x14, 0xAF, // "†" (U+2020)
  0x20, 0x21, 0x40, 0x01, 0x03, 0x07, 0x04, 0x14, 0xBD, // "‡" (U+2021)
  0x20, 0x22, 0x40, 0x03, 0x02, 0x04, 0x03, 0x14, 0xCB, // "•" (U+2022)
  0x20, 0x26, 0x40, 0x01, 0x05, 0x01, 0x06, 0x14, 0xCE, // "…" (U+2026)
  0x20, 0x30, 0x40, 0x01, 0x08, 0x07, 0x09, 0x14, 0xD1, // "‰" (U+2030)
  0x20, 0x39, 0x40, 0x01, 0x01, 0x04, 0x02, 0x14, 0xF1, // "‹" (U+2039)
  0x20, 0x3A, 0x40, 0x01, 0x01, 0x04, 0x02, 0x14, 0xF5, // "›" (U+203A)
  0x20, 0x44, 0xFE, 0x01, 0x02, 0x07, 0x01, 0x14, 0xF9, // "⁄" (U+2044)
  0x21, 0x22, 0x40, 0x03, 0x05, 0x06, 0x06, 0x15, 0x07, // "™" (U+2122)
  0x21, 0x52, 0x00, 0x01, 0x08, 0x07, 0x08, 0x15, 0x13, // "⅒" (U+2152)
  0xFB, 0x01, 0x40, 0x01, 0x04, 0x07, 0x05, 0x15, 0x30, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0x40, 0x01, 0x04, 0x07, 0x05, 0x15, 0x42, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x01, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0xC0, 0x01, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x01, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x01, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x01, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x01, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x01, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xC6, 0x01, // "Æ (U+0022 U+00C6)
  0x00, 0x22, 0x01, 0x00, 0x01, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x02, 0x01, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x04, 0x01, // "Ą (U+0022 U+0104)
  0x00, 0x27, 0x00, 0x41, 0x01, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0xC0, 0x01, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x01, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x01, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x01, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x01, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x01, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xC6, 0x01, // 'Æ (U+0027 U+00C6)
  0x00, 0x27, 0x01, 0x00, 0x01, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x02, 0x01, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x04, 0x01, // 'Ą (U+0027 U+0104)
  0x00, 0x2C, 0x00, 0x54, 0x01, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x01, 0x62, 0x01, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x01, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x01, // ,Ŧ (U+002C U+0166)
  0x00, 0x2E, 0x00, 0x54, 0x01, // .T (U+002E U+0054)
  0x00, 0x2E, 0x01, 0x62, 0x01, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x01, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x01, // .Ŧ (U+002E U+0166)
  0x00, 0x41, 0x00, 0x22, 0x01, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x01, // A' (U+0041 U+0027)
  0x00, 0x41, 0x00, 0x54, 0x01, // AT (U+0041 U+0054)
  0x00, 0x41, 0x01, 0x62, 0x01, // AŢ (U+0041 U+0162)
  0x00, 0x41, 0x01, 0x64, 0x01, // AŤ (U+0041 U+0164)
  0x00, 0x41, 0x01, 0x66, 0x01, // AŦ (U+0041 U+0166)
  0x00, 0x41, 0x20, 0x19, 0x01, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1D, 0x01, // A” (U+0041 U+201D)
  0x00, 0x4C, 0x00, 0x22, 0x01, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x01, // L' (U+004C U+0027)
  0x00, 0x4C, 0x20, 0x19, 0x01, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1D, 0x01, // L” (U+004C U+201D)
  0x00, 0x50, 0x00, 0x2C, 0x01, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x01, // P. (U+0050 U+002E)
  0x00, 0x50, 0x20, 0x1A, 0x01, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x01, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x01, // P… (U+0050 U+2026)
  0x00, 0x54, 0x00, 0x41, 0x01, // TA (U+0054 U+0041)
  0x00, 0x54, 0x00, 0x61, 0x01, // Ta (U+0054 U+0061)
  0x00, 0x54, 0x00, 0x63, 0x01, // Tc (U+0054 U+0063)
  0x00, 0x54, 0x00, 0x64, 0x01, // Td (U+0054 U+0064)
  0x00, 0x54, 0x00, 0x65, 0x01, // Te (U+0054 U+0065)
  0x00, 0x54, 0x00, 0x67, 0x01, // Tg (U+0054 U+0067)
  0x00, 0x54, 0x00, 0x6F, 0x01, // To (U+0054 U+006F)
  0x00, 0x54, 0x00, 0x71, 0x01, // Tq (U+0054 U+0071)
  0x00, 0x54, 0x00, 0xC0, 0x01, // TÀ (U+0054 U+00C0)
  0x00, 0x54, 0x00, 0xC1, 0x01, // TÁ (U+0054 U+00C1)
  0x00, 0x54, 0x00, 0xC2, 0x01, // TÂ (U+0054 U+00C2)
  0x00, 0x54, 0x00, 0xC3, 0x01, // TÃ (U+0054 U+00C3)
  0x00, 0x54, 0x00, 0xC4, 0x01, // TÄ (U+0054 U+00C4)
  0x00, 0x54, 0x00, 0xC5, 0x01, // TÅ (U+0054 U+00C5)
  0x00, 0x54, 0x00, 0xE0, 0x01, // Tà (U+0054 U+00E0)
  0x00, 0x54, 0x00, 0xE1, 0x01, // Tá (U+0054 U+00E1)
  0x00, 0x54, 0x00, 0xE2, 0x01, // Tâ (U+0054 U+00E2)
  0x00, 0x54, 0x00, 0xE3, 0x01, // Tã (U+0054 U+00E3)
  0x00, 0x54, 0x00, 0xE4, 0x01, // Tä (U+0054 U+00E4)
  0x00, 0x54, 0x00, 0xE5, 0x01, // Tå (U+0054 U+00E5)
  0x00, 0x54, 0x00, 0xE6, 0x01, // Tæ (U+0054 U+00E6)
  0x00, 0x54, 0x00, 0xE7, 0x01, // Tç (U+0054 U+00E7)
  0x00, 0x54, 0x00, 0xE8, 0x01, // Tè (U+0054 U+00E8)
  0x00, 0x54, 0x00, 0xE9, 0x01, // Té (U+0054 U+00E9)
  0x00, 0x54, 0x00, 0xEA, 0x01, // Tê (U+0054 U+00EA)
  0x00, 0x54, 0x00, 0xEB, 0x01, // Të (U+0054 U+00EB)
  0x00, 0x54, 0x00, 0xF2, 0x01, // Tò (U+0054 U+00F2)
  0x00, 0x54, 0x00, 0xF3, 0x01, // Tó (U+0054 U+00F3)
  0x00, 0x54, 0x00, 0xF4, 0x01, // Tô (U+0054 U+00F4)
  0x00, 0x54, 0x00, 0xF5, 0x01, // Tõ (U+0054 U+00F5)
  0x00, 0x54, 0x00, 0xF6, 0x01, // Tö (U+0054 U+00F6)
  0x00, 0x54, 0x00, 0xF8, 0x01, // Tø (U+0054 U+00F8)
  0x00, 0x54, 0x01, 0x00, 0x01, // TĀ (U+0054 U+0100)
  0x00, 0x54, 0x01, 0x01, 0x01, // Tā (U+0054 U+0101)
  0x00, 0x54, 0x01, 0x02, 0x01, // TĂ (U+0054 U+0102)
  0x00, 0x54, 0x01, 0x03, 0x01, // Tă (U+0054 U+0103)
  0x00, 0x54, 0x01, 0x04, 0x01, // TĄ (U+0054 U+0104)
  0x00, 0x54, 0x01, 0x05, 0x01, // Tą (U+0054 U+0105)
  0x00, 0x54, 0x01, 0x07, 0x01, // Tć (U+0054 U+0107)
  0x00, 0x54, 0x01, 0x09, 0x01, // Tĉ (U+0054 U+0109)
  0x00, 0x54, 0x01, 0x0B, 0x01, // Tċ (U+0054 U+010B)
  0x00, 0x54, 0x01, 0x0D, 0x01, // Tč (U+0054 U+010D)
  0x00, 0x54, 0x01, 0x0F, 0x01, // Tď (U+0054 U+010F)
  0x00, 0x54, 0x01, 0x11, 0x01, // Tđ (U+0054 U+0111)
  0x00, 0x54, 0x01, 0x13, 0x01, // Tē (U+0054 U+0113)
  0x00, 0x54, 0x01, 0x15, 0x01, // Tĕ (U+0054 U+0115)
  0x00, 0x54, 0x01, 0x17, 0x01, // Tė (U+0054 U+0117)
  0x00, 0x54, 0x01, 0x19, 0x01, // Tę (U+0054 U+0119)
  0x00, 0x54, 0x01, 0x1B, 0x01, // Tě (U+0054 U+011B)
  0x00, 0x54, 0x01, 0x1D, 0x01, // Tĝ (U+0054 U+011D)
  0x00, 0x54, 0x01, 0x1F, 0x01, // Tğ (U+0054 U+011F)
  0x00, 0x54, 0x01, 0x21, 0x01, // Tġ (U+0054 U+0121)
  0x00, 0x54, 0x01, 0x23, 0x01, // Tģ (U+0054 U+0123)
  0x00, 0x54, 0x01, 0x4D, 0x01, // Tō (U+0054 U+014D)
  0x00, 0x54, 0x01, 0x4F, 0x01, // Tŏ (U+0054 U+014F)
  0x00, 0x54, 0x01, 0x51, 0x01, // Tő (U+0054 U+0151)
  0x00, 0x54, 0x01, 0x53, 0x01, // Tœ (U+0054 U+0153)
  0x00, 0x59, 0x00, 0xAB, 0x01, // Y« (U+0059 U+00AB)
  0x00, 0x59, 0x20, 0x39, 0x01, // Y‹ (U+0059 U+2039)
  0x00, 0x72, 0x00, 0x2C, 0x01, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x01, // r. (U+0072 U+002E)
  0x00, 0x72, 0x20, 0x1A, 0x01, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x01, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x01, // r… (U+0072 U+2026)
  0x00, 0xBB, 0x00, 0x59, 0x01, // »Y (U+00BB U+0059)
  0x00, 0xBB, 0x00, 0xDD, 0x01, // »Ý (U+00BB U+00DD)
  0x00, 0xBB, 0x01, 0x76, 0x01, // »Ŷ (U+00BB U+0176)
  0x00, 0xBB, 0x01, 0x78, 0x01, // »Ÿ (U+00BB U+0178)
  0x00, 0xC0, 0x00, 0x22, 0x01, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x01, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x00, 0x54, 0x01, // ÀT (U+00C0 U+0054)
  0x00, 0xC0, 0x01, 0x62, 0x01, // ÀŢ (U+00C0 U+0162)
  0x00, 0xC0, 0x01, 0x64, 0x01, // ÀŤ (U+00C0 U+0164)
  0x00, 0xC0, 0x01, 0x66, 0x01, // ÀŦ (U+00C0 U+0166)
  0x00, 0xC0, 0x20, 0x19, 0x01, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1D, 0x01, // À” (U+00C0 U+201D)
  0x00, 0xC1, 0x00, 0x22, 0x01, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x01, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x00, 0x54, 0x01, // ÁT (U+00C1 U+0054)
  0x00, 0xC1, 0x01, 0x62, 0x01, // ÁŢ (U+00C1 U+0162)
  0x00, 0xC1, 0x01, 0x64, 0x01, // ÁŤ (U+00C1 U+0164)
  0x00, 0xC1, 0x01, 0x66, 0x01, // ÁŦ (U+00C1 U+0166)
  0x00, 0xC1, 0x20, 0x19, 0x01, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1D, 0x01, // Á” (U+00C1 U+201D)
  0x00, 0xC2, 0x00, 0x22, 0x01, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x01, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x00, 0x54, 0x01, // ÂT (U+00C2 U+0054)
  0x00, 0xC2, 0x01, 0x62, 0x01, // ÂŢ (U+00C2 U+0162)
  0x00, 0xC2, 0x01, 0x64, 0x01, // ÂŤ (U+00C2 U+0164)
  0x00, 0xC2, 0x01, 0x66, 0x01, // ÂŦ (U+00C2 U+0166)
  0x00, 0xC2, 0x20, 0x19, 0x01, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1D, 0x01, // Â” (U+00C2 U+201D)
  0x00, 0xC3, 0x00, 0x22, 0x01, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x01, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x00, 0x54, 0x01, // ÃT (U+00C3 U+0054)
  0x00, 0xC3, 0x01, 0x62, 0x01, // ÃŢ (U+00C3 U+0162)
  0x00, 0xC3, 0x01, 0x64, 0x01, // ÃŤ (U+00C3 U+0164)
  0x00, 0xC3, 0x01, 0x66, 0x01, // ÃŦ (U+00C3 U+0166)
  0x00, 0xC3, 0x20, 0x19, 0x01, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1D, 0x01, // Ã” (U+00C3 U+201D)
  0x00, 0xC4, 0x00, 0x22, 0x01, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x01, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x00, 0x54, 0x01, // ÄT (U+00C4 U+0054)
  0x00, 0xC4, 0x01, 0x62, 0x01, // ÄŢ (U+00C4 U+0162)
  0x00, 0xC4, 0x01, 0x64, 0x01, // ÄŤ (U+00C4 U+0164)
  0x00, 0xC4, 0x01, 0x66, 0x01, // ÄŦ (U+00C4 U+0166)
  0x00, 0xC4, 0x20, 0x19, 0x01, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1D, 0x01, // Ä” (U+00C4 U+201D)
  0x00, 0xC5, 0x00, 0x22, 0x01, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x01, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x00, 0x54, 0x01, // ÅT (U+00C5 U+0054)
  0x00, 0xC5, 0x01, 0x62, 0x01, // ÅŢ (U+00C5 U+0162)
  0x00, 0xC5, 0x01, 0x64, 0x01, // ÅŤ (U+00C5 U+0164)
  0x00, 0xC5, 0x01, 0x66, 0x01, // ÅŦ (U+00C5 U+0166)
  0x00, 0xC5, 0x20, 0x19, 0x01, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1D, 0x01, // Å” (U+00C5 U+201D)
  0x00, 0xDD, 0x00, 0xAB, 0x01, // Ý« (U+00DD U+00AB)
  0x00, 0xDD, 0x20, 0x39, 0x01, // Ý‹ (U+00DD U+2039)
  0x00, 0xDE, 0x00, 0x2C, 0x01, // Þ, (U+00DE U+002C)
  0x00, 0xDE, 0x00, 0x2E, 0x01, // Þ. (U+00DE U+002E)
  0x00, 0xDE, 0x20, 0x1A, 0x01, // Þ‚ (U+00DE U+201A)
  0x00, 0xDE, 0x20, 0x1E, 0x01, // Þ„ (U+00DE U+201E)
  0x00, 0xDE, 0x20, 0x26, 0x01, // Þ… (U+00DE U+2026)
  0x01, 0x00, 0x00, 0x22, 0x01, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x01, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x00, 0x54, 0x01, // ĀT (U+0100 U+0054)
  0x01, 0x00, 0x01, 0x62, 0x01, // ĀŢ (U+0100 U+0162)
  0x01, 0x00, 0x01, 0x64, 0x01, // ĀŤ (U+0100 U+0164)
  0x01, 0x00, 0x01, 0x66, 0x01, // ĀŦ (U+0100 U+0166)
  0x01, 0x00, 0x20, 0x19, 0x01, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1D, 0x01, // Ā” (U+0100 U+201D)
  0x01, 0x02, 0x00, 0x22, 0x01, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x01, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x00, 0x54, 0x01, // ĂT (U+0102 U+0054)
  0x01, 0x02, 0x01, 0x62, 0x01, // ĂŢ (U+0102 U+0162)
  0x01, 0x02, 0x01, 0x64, 0x01, // ĂŤ (U+0102 U+0164)
  0x01, 0x02, 0x01, 0x66, 0x01, // ĂŦ (U+0102 U+0166)
  0x01, 0x02, 0x20, 0x19, 0x01, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1D, 0x01, // Ă” (U+0102 U+201D)
  0x01, 0x04, 0x00, 0x22, 0x01, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x01, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x00, 0x54, 0x01, // ĄT (U+0104 U+0054)
  0x01, 0x04, 0x01, 0x62, 0x01, // ĄŢ (U+0104 U+0162)
  0x01, 0x04, 0x01, 0x64, 0x01, // ĄŤ (U+0104 U+0164)
  0x01, 0x04, 0x01, 0x66, 0x01, // ĄŦ (U+0104 U+0166)
  0x01, 0x04, 0x20, 0x19, 0x01, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1D, 0x01, // Ą” (U+0104 U+201D)
  0x01, 0x39, 0x00, 0x22, 0x01, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x01, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x20, 0x19, 0x01, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1D, 0x01, // Ĺ” (U+0139 U+201D)
  0x01, 0x3B, 0x00, 0x22, 0x01, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x01, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x20, 0x19, 0x01, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1D, 0x01, // Ļ” (U+013B U+201D)
  0x01, 0x3D, 0x00, 0x22, 0x01, // Ľ" (U+013D U+0022)
  0x01, 0x3D, 0x00, 0x27, 0x01, // Ľ' (U+013D U+0027)
  0x01, 0x3D, 0x20, 0x19, 0x01, // Ľ’ (U+013D U+2019)
  0x01, 0x3D, 0x20, 0x1D, 0x01, // Ľ” (U+013D U+201D)
  0x01, 0x3F, 0x00, 0x22, 0x01, // Ŀ" (U+013F U+0022)
  0x01, 0x3F, 0x00, 0x27, 0x01, // Ŀ' (U+013F U+0027)
  0x01, 0x3F, 0x20, 0x19, 0x01, // Ŀ’ (U+013F U+2019)
  0x01, 0x3F, 0x20, 0x1D, 0x01, // Ŀ” (U+013F U+201D)
  0x01, 0x41, 0x00, 0x22, 0x01, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x01, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x20, 0x19, 0x01, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1D, 0x01, // Ł” (U+0141 U+201D)
  0x01, 0x55, 0x00, 0x2C, 0x01, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x01, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x20, 0x1A, 0x01, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x01, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x01, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x01, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x01, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x20, 0x1A, 0x01, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x01, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x01, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x01, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x01, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x20, 0x1A, 0x01, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x01, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x01, // ř… (U+0159 U+2026)
  0x01, 0x62, 0x00, 0x41, 0x01, // ŢA (U+0162 U+0041)
  0x01, 0x62, 0x00, 0x61, 0x01, // Ţa (U+0162 U+0061)
  0x01, 0x62, 0x00, 0x63, 0x01, // Ţc (U+0162 U+0063)
  0x01, 0x62, 0x00, 0x64, 0x01, // Ţd (U+0162 U+0064)
  0x01, 0x62, 0x00, 0x65, 0x01, // Ţe (U+0162 U+0065)
  0x01, 0x62, 0x00, 0x67, 0x01, // Ţg (U+0162 U+0067)
  0x01, 0x62, 0x00, 0x6F, 0x01, // Ţo (U+0162 U+006F)
  0x01, 0x62, 0x00, 0x71, 0x01, // Ţq (U+0162 U+0071)
  0x01, 0x62, 0x00, 0xC0, 0x01, // ŢÀ (U+0162 U+00C0)
  0x01, 0x62, 0x00, 0xC1, 0x01, // ŢÁ (U+0162 U+00C1)
  0x01, 0x62, 0x00, 0xC2, 0x01, // ŢÂ (U+0162 U+00C2)
  0x01, 0x62, 0x00, 0xC3, 0x01, // ŢÃ (U+0162 U+00C3)
  0x01, 0x62, 0x00, 0xC4, 0x01, // ŢÄ (U+0162 U+00C4)
  0x01, 0x62, 0x00, 0xC5, 0x01, // ŢÅ (U+0162 U+00C5)
  0x01, 0x62, 0x00, 0xE0, 0x01, // Ţà (U+0162 U+00E0)
  0x01, 0x62, 0x00, 0xE1, 0x01, // Ţá (U+0162 U+00E1)
  0x01, 0x62, 0x00, 0xE2, 0x01, // Ţâ (U+0162 U+00E2)
  0x01, 0x62, 0x00, 0xE3, 0x01, // Ţã (U+0162 U+00E3)
  0x01, 0x62, 0x00, 0xE4, 0x01, // Ţä (U+0162 U+00E4)
  0x01, 0x62, 0x00, 0xE5, 0x01, // Ţå (U+0162 U+00E5)
  0x01, 0x62, 0x00, 0xE6, 0x01, // Ţæ (U+0162 U+00E6)
  0x01, 0x62, 0x00, 0xE7, 0x01, // Ţç (U+0162 U+00E7)
  0x01, 0x62, 0x00, 0xE8, 0x01, // Ţè (U+0162 U+00E8)
  0x01, 0x62, 0x00, 0xE9, 0x01, // Ţé (U+0162 U+00E9)
  0x01, 0x62, 0x00, 0xEA, 0x01, // Ţê (U+0162 U+00EA)
  0x01, 0x62, 0x00, 0xEB, 0x01, // Ţë (U+0162 U+00EB)
  0x01, 0x62, 0x00, 0xF2, 0x01, // Ţò (U+0162 U+00F2)
  0x01, 0x62, 0x00, 0xF3, 0x01, // Ţó (U+0162 U+00F3)
  0x01, 0x62, 0x00, 0xF4, 0x01, // Ţô (U+0162 U+00F4)
  0x01, 0x62, 0x00, 0xF5, 0x01, // Ţõ (U+0162 U+00F5)
  0x01, 0x62, 0x00, 0xF6, 0x01, // Ţö (U+0162 U+00F6)
  0x01, 0x62, 0x00, 0xF8, 0x01, // Ţø (U+0162 U+00F8)
  0x01, 0x62, 0x01, 0x00, 0x01, // ŢĀ (U+0162 U+0100)
  0x01, 0x62, 0x01, 0x01, 0x01, // Ţā (U+0162 U+0101)
  0x01, 0x62, 0x01, 0x02, 0x01, // ŢĂ (U+0162 U+0102)
  0x01, 0x62, 0x01, 0x03, 0x01, // Ţă (U+0162 U+0103)
  0x01, 0x62, 0x01, 0x04, 0x01, // ŢĄ (U+0162 U+0104)
  0x01, 0x62, 0x01, 0x05, 0x01, // Ţą (U+0162 U+0105)
  0x01, 0x62, 0x01, 0x07, 0x01, // Ţć (U+0162 U+0107)
  0x01, 0x62, 0x01, 0x09, 0x01, // Ţĉ (U+0162 U+0109)
  0x01, 0x62, 0x01, 0x0B, 0x01, // Ţċ (U+0162 U+010B)
  0x01, 0x62, 0x01, 0x0D, 0x01, // Ţč (U+0162 U+010D)
  0x01, 0x62, 0x01, 0x0F, 0x01, // Ţď (U+0162 U+010F)
  0x01, 0x62, 0x01, 0x11, 0x01, // Ţđ (U+0162 U+0111)
  0x01, 0x62, 0x01, 0x13, 0x01, // Ţē (U+0162 U+0113)
  0x01, 0x62, 0x01, 0x15, 0x01, // Ţĕ (U+0162 U+0115)
  0x01, 0x62, 0x01, 0x17, 0x01, // Ţė (U+0162 U+0117)
  0x01, 0x62, 0x01, 0x19, 0x01, // Ţę (U+0162 U+0119)
  0x01, 0x62, 0x01, 0x1B, 0x01, // Ţě (U+0162 U+011B)
  0x01, 0x62, 0x01, 0x1D, 0x01, // Ţĝ (U+0162 U+011D)
  0x01, 0x62, 0x01, 0x1F, 0x01, // Ţğ (U+0162 U+011F)
  0x01, 0x62, 0x01, 0x21, 0x01, // Ţġ (U+0162 U+0121)
  0x01, 0x62, 0x01, 0x23, 0x01, // Ţģ (U+0162 U+0123)
  0x01, 0x62, 0x01, 0x4D, 0x01, // Ţō (U+0162 U+014D)
  0x01, 0x62, 0x01, 0x4F, 0x01, // Ţŏ (U+0162 U+014F)
  0x01, 0x62, 0x01, 0x51, 0x01, // Ţő (U+0162 U+0151)
  0x01, 0x62, 0x01, 0x53, 0x01, // Ţœ (U+0162 U+0153)
  0x01, 0x64, 0x00, 0x41, 0x01, // ŤA (U+0164 U+0041)
  0x01, 0x64, 0x00, 0x61, 0x01, // Ťa (U+0164 U+0061)
  0x01, 0x64, 0x00, 0x63, 0x01, // Ťc (U+0164 U+0063)
  0x01, 0x64, 0x00, 0x64, 0x01, // Ťd (U+0164 U+0064)
  0x01, 0x64, 0x00, 0x65, 0x01, // Ťe (U+0164 U+0065)
  0x01, 0x64, 0x00, 0x67, 0x01, // Ťg (U+0164 U+0067)
  0x01, 0x64, 0x00, 0x6F, 0x01, // Ťo (U+0164 U+006F)
  0x01, 0x64, 0x00, 0x71, 0x01, // Ťq (U+0164 U+0071)
  0x01, 0x64, 0x00, 0xC0, 0x01, // ŤÀ (U+0164 U+00C0)
  0x01, 0x64, 0x00, 0xC1, 0x01, // ŤÁ (U+0164 U+00C1)
  0x01, 0x64, 0x00, 0xC2, 0x01, // ŤÂ (U+0164 U+00C2)
  0x01, 0x64, 0x00, 0xC3, 0x01, // ŤÃ (U+0164 U+00C3)
  0x01, 0x64, 0x00, 0xC4, 0x01, // ŤÄ (U+0164 U+00C4)
  0x01, 0x64, 0x00, 0xC5, 0x01, // ŤÅ (U+0164 U+00C5)
  0x01, 0x64, 0x00, 0xE0, 0x01, // Ťà (U+0164 U+00E0)
  0x01, 0x64, 0x00, 0xE1, 0x01, // Ťá (U+0164 U+00E1)
  0x01, 0x64, 0x00, 0xE2, 0x01, // Ťâ (U+0164 U+00E2)
  0x01, 0x64, 0x00, 0xE3, 0x01, // Ťã (U+0164 U+00E3)
  0x01, 0x64, 0x00, 0xE4, 0x01, // Ťä (U+0164 U+00E4)
  0x01, 0x64, 0x00, 0xE5, 0x01, // Ťå (U+0164 U+00E5)
  0x01, 0x64, 0x00, 0xE6, 0x01, // Ťæ (U+0164 U+00E6)
  0x01, 0x64, 0x00, 0xE7, 0x01, // Ťç (U+0164 U+00E7)
  0x01, 0x64, 0x00, 0xE8, 0x01, // Ťè (U+0164 U+00E8)
  0x01, 0x64, 0x00, 0xE9, 0x01, // Ťé (U+0164 U+00E9)
  0x01, 0x64, 0x00, 0xEA, 0x01, // Ťê (U+0164 U+00EA)
  0x01, 0x64, 0x00, 0xEB, 0x01, // Ťë (U+0164 U+00EB)
  0x01, 0x64, 0x00, 0xF2, 0x01, // Ťò (U+0164 U+00F2)
  0x01, 0x64, 0x00, 0xF3, 0x01, // Ťó (U+0164 U+00F3)
  0x01, 0x64, 0x00, 0xF4, 0x01, // Ťô (U+0164 U+00F4)
  0x01, 0x64, 0x00, 0xF5, 0x01, // Ťõ (U+0164 U+00F5)
  0x01, 0x64, 0x00, 0xF6, 0x01, // Ťö (U+0164 U+00F6)
  0x01, 0x64, 0x00, 0xF8, 0x01, // Ťø (U+0164 U+00F8)
  0x01, 0x64, 0x01, 0x00, 0x01, // ŤĀ (U+0164 U+0100)
  0x01, 0x64, 0x01, 0x01, 0x01, // Ťā (U+0164 U+0101)
  0x01, 0x64, 0x01, 0x02, 0x01, // ŤĂ (U+0164 U+0102)
  0x01, 0x64, 0x01, 0x03, 0x01, // Ťă (U+0164 U+0103)
  0x01, 0x64, 0x01, 0x04, 0x01, // ŤĄ (U+0164 U+0104)
  0x01, 0x64, 0x01, 0x05, 0x01, // Ťą (U+0164 U+0105)
  0x01, 0x64, 0x01, 0x07, 0x01, // Ťć (U+0164 U+0107)
  0x01, 0x64, 0x01, 0x09, 0x01, // Ťĉ (U+0164 U+0109)
  0x01, 0x64, 0x01, 0x0B, 0x01, // Ťċ (U+0164 U+010B)
  0x01, 0x64, 0x01, 0x0D, 0x01, // Ťč (U+0164 U+010D)
  0x01, 0x64, 0x01, 0x0F, 0x01, // Ťď (U+0164 U+010F)
  0x01, 0x64, 0x01, 0x11, 0x01, // Ťđ (U+0164 U+0111)
  0x01, 0x64, 0x01, 0x13, 0x01, // Ťē (U+0164 U+0113)
  0x01, 0x64, 0x01, 0x15, 0x01, // Ťĕ (U+0164 U+0115)
  0x01, 0x64, 0x01, 0x17, 0x01, // Ťė (U+0164 U+0117)
  0x01, 0x64, 0x01, 0x19, 0x01, // Ťę (U+0164 U+0119)
  0x01, 0x64, 0x01, 0x1B, 0x01, // Ťě (U+0164 U+011B)
  0x01, 0x64, 0x01, 0x1D, 0x01, // Ťĝ (U+0164 U+011D)
  0x01, 0x64, 0x01, 0x1F, 0x01, // Ťğ (U+0164 U+011F)
  0x01, 0x64, 0x01, 0x21, 0x01, // Ťġ (U+0164 U+0121)
  0x01, 0x64, 0x01, 0x23, 0x01, // Ťģ (U+0164 U+0123)
  0x01, 0x64, 0x01, 0x4D, 0x01, // Ťō (U+0164 U+014D)
  0x01, 0x64, 0x01, 0x4F, 0x01, // Ťŏ (U+0164 U+014F)
  0x01, 0x64, 0x01, 0x51, 0x01, // Ťő (U+0164 U+0151)
  0x01, 0x64, 0x01, 0x53, 0x01, // Ťœ (U+0164 U+0153)
  0x01, 0x66, 0x00, 0x41, 0x01, // ŦA (U+0166 U+0041)
  0x01, 0x66, 0x00, 0x61, 0x01, // Ŧa (U+0166 U+0061)
  0x01, 0x66, 0x00, 0x63, 0x01, // Ŧc (U+0166 U+0063)
  0x01, 0x66, 0x00, 0x64, 0x01, // Ŧd (U+0166 U+0064)
  0x01, 0x66, 0x00, 0x65, 0x01, // Ŧe (U+0166 U+0065)
  0x01, 0x66, 0x00, 0x67, 0x01, // Ŧg (U+0166 U+0067)
  0x01, 0x66, 0x00, 0x6F, 0x01, // Ŧo (U+0166 U+006F)
  0x01, 0x66, 0x00, 0x71, 0x01, // Ŧq (U+0166 U+0071)
  0x01, 0x66, 0x00, 0xC0, 0x01, // ŦÀ (U+0166 U+00C0)
  0x01, 0x66, 0x00, 0xC1, 0x01, // ŦÁ (U+0166 U+00C1)
  0x01, 0x66, 0x00, 0xC2, 0x01, // ŦÂ (U+0166 U+00C2)
  0x01, 0x66, 0x00, 0xC3, 0x01, // ŦÃ (U+0166 U+00C3)
  0x01, 0x66, 0x00, 0xC4, 0x01, // ŦÄ (U+0166 U+00C4)
  0x01, 0x66, 0x00, 0xC5, 0x01, // ŦÅ (U+0166 U+00C5)
  0x01, 0x66, 0x00, 0xE0, 0x01, // Ŧà (U+0166 U+00E0)
  0x01, 0x66, 0x00, 0xE1, 0x01, // Ŧá (U+0166 U+00E1)
  0x01, 0x66, 0x00, 0xE2, 0x01, // Ŧâ (U+0166 U+00E2)
  0x01, 0x66, 0x00, 0xE3, 0x01, // Ŧã (U+0166 U+00E3)
  0x01, 0x66, 0x00, 0xE4, 0x01, // Ŧä (U+0166 U+00E4)
  0x01, 0x66, 0x00, 0xE5, 0x01, // Ŧå (U+0166 U+00E5)
  0x01, 0x66, 0x00, 0xE6, 0x01, // Ŧæ (U+0166 U+00E6)
  0x01, 0x66, 0x00, 0xE7, 0x01, // Ŧç (U+0166 U+00E7)
  0x01, 0x66, 0x00, 0xE8, 0x01, // Ŧè (U+0166 U+00E8)
  0x01, 0x66, 0x00, 0xE9, 0x01, // Ŧé (U+0166 U+00E9)
  0x01, 0x66, 0x00, 0xEA, 0x01, // Ŧê (U+0166 U+00EA)
  0x01, 0x66, 0x00, 0xEB, 0x01, // Ŧë (U+0166 U+00EB)
  0x01, 0x66, 0x00, 0xF2, 0x01, // Ŧò (U+0166 U+00F2)
  0x01, 0x66, 0x00, 0xF3, 0x01, // Ŧó (U+0166 U+00F3)
  0x01, 0x66, 0x00, 0xF4, 0x01, // Ŧô (U+0166 U+00F4)
  0x01, 0x66, 0x00, 0xF5, 0x01, // Ŧõ (U+0166 U+00F5)
  0x01, 0x66, 0x00, 0xF6, 0x01, // Ŧö (U+0166 U+00F6)
  0x01, 0x66, 0x00, 0xF8, 0x01, // Ŧø (U+0166 U+00F8)
  0x01, 0x66, 0x01, 0x00, 0x01, // ŦĀ (U+0166 U+0100)
  0x01, 0x66, 0x01, 0x01, 0x01, // Ŧā (U+0166 U+0101)
  0x01, 0x66, 0x01, 0x02, 0x01, // ŦĂ (U+0166 U+0102)
  0x01, 0x66, 0x01, 0x03, 0x01, // Ŧă (U+0166 U+0103)
  0x01, 0x66, 0x01, 0x04, 0x01, // ŦĄ (U+0166 U+0104)
  0x01, 0x66, 0x01, 0x05, 0x01, // Ŧą (U+0166 U+0105)
  0x01, 0x66, 0x01, 0x07, 0x01, // Ŧć (U+0166 U+0107)
  0x01, 0x66, 0x01, 0x09, 0x01, // Ŧĉ (U+0166 U+0109)
  0x01, 0x66, 0x01, 0x0B, 0x01, // Ŧċ (U+0166 U+010B)
  0x01, 0x66, 0x01, 0x0D, 0x01, // Ŧč (U+0166 U+010D)
  0x01, 0x66, 0x01, 0x0F, 0x01, // Ŧď (U+0166 U+010F)
  0x01, 0x66, 0x01, 0x11, 0x01, // Ŧđ (U+0166 U+0111)
  0x01, 0x66, 0x01, 0x13, 0x01, // Ŧē (U+0166 U+0113)
  0x01, 0x66, 0x01, 0x15, 0x01, // Ŧĕ (U+0166 U+0115)
  0x01, 0x66, 0x01, 0x17, 0x01, // Ŧė (U+0166 U+0117)
  0x01, 0x66, 0x01, 0x19, 0x01, // Ŧę (U+0166 U+0119)
  0x01, 0x66, 0x01, 0x1B, 0x01, // Ŧě (U+0166 U+011B)
  0x01, 0x66, 0x01, 0x1D, 0x01, // Ŧĝ (U+0166 U+011D)
  0x01, 0x66, 0x01, 0x1F, 0x01, // Ŧğ (U+0166 U+011F)
  0x01, 0x66, 0x01, 0x21, 0x01, // Ŧġ (U+0166 U+0121)
  0x01, 0x66, 0x01, 0x23, 0x01, // Ŧģ (U+0166 U+0123)
  0x01, 0x66, 0x01, 0x4D, 0x01, // Ŧō (U+0166 U+014D)
  0x01, 0x66, 0x01, 0x4F, 0x01, // Ŧŏ (U+0166 U+014F)
  0x01, 0x66, 0x01, 0x51, 0x01, // Ŧő (U+0166 U+0151)
  0x01, 0x66, 0x01, 0x53, 0x01, // Ŧœ (U+0166 U+0153)
  0x01, 0x76, 0x00, 0xAB, 0x01, // Ŷ« (U+0176 U+00AB)
  0x01, 0x76, 0x20, 0x39, 0x01, // Ŷ‹ (U+0176 U+2039)
  0x01, 0x78, 0x00, 0xAB, 0x01, // Ÿ« (U+0178 U+00AB)
  0x01, 0x78, 0x20, 0x39, 0x01, // Ÿ‹ (U+0178 U+2039)
  0x20, 0x18, 0x00, 0x41, 0x01, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0xC0, 0x01, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x01, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x01, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x01, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x01, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x01, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xC6, 0x01, // ‘Æ (U+2018 U+00C6)
  0x20, 0x18, 0x01, 0x00, 0x01, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x02, 0x01, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x04, 0x01, // ‘Ą (U+2018 U+0104)
  0x20, 0x19, 0x00, 0x41, 0x01, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0xC0, 0x01, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x01, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x01, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x01, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x01, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x01, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xC6, 0x01, // ’Æ (U+2019 U+00C6)
  0x20, 0x19, 0x01, 0x00, 0x01, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x02, 0x01, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x04, 0x01, // ’Ą (U+2019 U+0104)
  0x20, 0x1A, 0x00, 0x54, 0x01, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x01, 0x62, 0x01, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x01, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x01, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1C, 0x00, 0x41, 0x01, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0xC0, 0x01, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x01, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x01, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x01, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x01, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x01, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xC6, 0x01, // “Æ (U+201C U+00C6)
  0x20, 0x1C, 0x01, 0x00, 0x01, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x02, 0x01, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x04, 0x01, // “Ą (U+201C U+0104)
  0x20, 0x1D, 0x00, 0x41, 0x01, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0xC0, 0x01, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x01, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x01, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x01, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x01, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x01, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xC6, 0x01, // ”Æ (U+201D U+00C6)
  0x20, 0x1D, 0x01, 0x00, 0x01, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x02, 0x01, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x04, 0x01, // ”Ą (U+201D U+0104)
  0x20, 0x1E, 0x00, 0x54, 0x01, // „T (U+201E U+0054)
  0x20, 0x1E, 0x01, 0x62, 0x01, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x01, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x01, // „Ŧ (U+201E U+0166)
  0x20, 0x3A, 0x00, 0x59, 0x01, // ›Y (U+203A U+0059)
  0x20, 0x3A, 0x00, 0xDD, 0x01, // ›Ý (U+203A U+00DD)
  0x20, 0x3A, 0x01, 0x76, 0x01, // ›Ŷ (U+203A U+0176)
  0x20, 0x3A, 0x01, 0x78, 0x01, // ›Ÿ (U+203A U+0178)
  
  // Glyph data
  // "!" (U+0021)
  0x57, 0x46, 0x46, 0x35, 0x24, 0x00, 0x34,
  // """ (U+0022)
  0x63, 0xA5, 0x28, 0x00, 0x10,
  // "#" (U+0023)
  0x01, 0x75, 0x20, 0x35, 0x70, 0x5D, 0xCD, 0xB0, 0x80, 0x80, 0x9D, 0xBD, 0x80, 0x82, 0x60, 0x08,
  0x53, 0x00,
  // "$" (U+0024)
  0x00, 0x80, 0x03, 0xCD, 0xA0, 0x74, 0x70, 0x02, 0xCA, 0x00, 0x00, 0xBB, 0x01, 0x07, 0xA1, 0x4B,
  0xD6, 0x00, 0x03, 0x00,
  // "%" (U+0025)
  0x3C, 0x40, 0x80, 0x08, 0x19, 0x17, 0x00, 0x80, 0x97, 0x10, 0x07, 0x19, 0x89, 0xA0, 0x2B, 0xA3,
  0x86, 0x20, 0x09, 0x18, 0x53, 0x05, 0x40, 0xAB, 0x00,
  // "&" (U+0026)
  0x09, 0xC6, 0x00, 0x0B, 0x0B, 0x00, 0x0B, 0x39, 0x00, 0x08, 0xD0, 0x00, 0x49, 0x77, 0x64, 0x83,
  0x08, 0xC0, 0x2C, 0xB9, 0x86,
  // "'" (U+0027)
  0x63, 0x52,
  // "(" (U+0028)
  0x0A, 0x47, 0x83, 0xA1, 0xA0, 0x82, 0x47, 0x0A,
  // ")" (U+0029)
  0x73, 0x19, 0x0B, 0x0A, 0x0A, 0x0B, 0x1A, 0x73,
  // "*" (U+002A)
  0x02, 0x80, 0x67, 0x99, 0x18, 0xC2, 0x0A, 0x64,
  // "+" (U+002B)
  0x20, 0x82, 0x83, 0x6B, 0xDB, 0x12, 0x08, 0x40, 0x82,
  // "," (U+002C)
  0x01, 0x55, 0x81,
  // "-" (U+002D)
  0x8B, 0x20,
  // "." (U+002E)
  0x34,
  // "/" (U+002F)
  0x00, 0xA0, 0x36, 0x08, 0x20, 0xA0, 0x28, 0x07, 0x30, 0xA0, 0x00,
  // "0" (U+0030)
  0x0B, 0xB5, 0x05, 0x60, 0xB0, 0x82, 0x09, 0x19, 0x10, 0x82, 0x82, 0x09, 0x15, 0x60, 0xB0, 0x0A,
  0xC5, 0x00,
  // "1" (U+0031)
  0x04, 0xC1, 0x9A, 0x00, 0xA0, 0x0A, 0x00, 0xA0, 0x0A, 0x00, 0xA0,
  // "2" (U+0032)
  0x3B, 0xC5, 0x01, 0x00, 0xB0, 0x00, 0x0B, 0x00, 0x05, 0x60, 0x02, 0xA0, 0x01, 0xA0, 0x00, 0x8D,
  0xBB, 0x10,
  // "3" (U+0033)
  0x4B, 0xC6, 0x10, 0x0B, 0x00, 0x1A, 0x09, 0xE5, 0x00, 0x0B, 0x00, 0x0B, 0x7B, 0xC6,
  // "4" (U+0034)
  0x00, 0x69, 0x00, 0x0A, 0x90, 0x06, 0x59, 0x00, 0x91, 0x90, 0x73, 0x19, 0x0A, 0xBB, 0xD4, 0x00,
  0x19, 0x00,
  // "5" (U+0035)
  0x2D, 0xB8, 0x36, 0x00, 0x45, 0x00, 0x4C, 0xB6, 0x00, 0x0B, 0x00, 0x0B, 0x5B, 0xB6,
  // "6" (U+0036)
  0x05, 0xC9, 0x02, 0xB0, 0x00, 0x65, 0x00, 0x08, 0x8B, 0x70, 0x85, 0x0A, 0x15, 0x50, 0x91, 0x0A,
  0xB8, 0x00,
  // "7" (U+0037)
  0x83, 0x7B, 0xBE, 0x23, 0x0B, 0x30, 0x30, 0x73, 0x09, 0x02, 0x30, 0xB3, 0x05, 0x06, 0x30, 0xA0,
  0x12,
  // "8" (U+0038)
  0x1B, 0xC7, 0x05, 0x50, 0xB0, 0x39, 0x39, 0x00, 0xBD, 0x40, 0x64, 0x0A, 0x08, 0x20, 0x91, 0x2B,
  0xB8, 0x00,
  // "9" (U+0039)
  0x0B, 0xC5, 0x06, 0x40, 0xB0, 0x81, 0x09, 0x17, 0x40, 0xC1, 0x1A, 0xBA, 0x00, 0x01, 0x90, 0x2B,
  0xB1, 0x00,
  // ":" (U+003A)
  0x34, 0x00, 0x00, 0x00, 0x34,
  // ";" (U+003B)
  0x34, 0x00, 0x00, 0x01, 0x74, 0x80,
  // "<" (U+003C)
  0x00, 0x17, 0x11, 0x77, 0x10, 0x59, 0x30, 0x00, 0x05, 0x91,
  // "=" (U+003D)
  0x6B, 0xBB, 0x10, 0x00, 0x00, 0x6B, 0xBB, 0x10,
  // ">" (U+003E)
  0x54, 0x00, 0x00, 0x48, 0x40, 0x00, 0x69, 0x15, 0x82, 0x00,
  // "?" (U+003F)
  0x9B, 0xA0, 0x00, 0x73, 0x00, 0x92, 0x04, 0x80, 0x0A, 0x00, 0x03, 0x00, 0x08, 0x00,
  // "@" (U+0040)
  0x01, 0xAB, 0xB6, 0x00, 0xA2, 0x00, 0x74, 0x35, 0x4C, 0xC0, 0x86, 0x1A, 0x09, 0x08, 0x71, 0xA0,
  0xB1, 0x85, 0x36, 0xB5, 0xB2, 0x1B, 0x10, 0x00, 0x00, 0x2A, 0xBA, 0x10,
  // "A" (U+0041)
  0x00, 0xD0, 0x00, 0x3B, 0x50, 0x08, 0x3A, 0x00, 0xB0, 0xA0, 0x3D, 0xBD, 0x48, 0x30, 0x19, 0xB0,
  0x00, 0xB0,
  // "B" (U+0042)
  0x3D, 0xBB, 0x23, 0x70, 0x48, 0x37, 0x05, 0x63, 0xDB, 0xD1, 0x37, 0x02, 0x93, 0x70, 0x1A, 0x3D,
  0xBC, 0x30,
  // "C" (U+0043)
  0x04, 0xCC, 0x81, 0xB0, 0x00, 0x65, 0x00, 0x07, 0x40, 0x00, 0x65, 0x00, 0x02, 0xB0, 0x00, 0x06,
  0xCB, 0x60,
  // "D" (U+0044)
  0x3D, 0xBB, 0x30, 0x37, 0x01, 0xC0, 0x37, 0x00, 0x84, 0x37, 0x00, 0x65, 0x37, 0x00, 0x83, 0x37,
  0x02, 0xC0, 0x3D, 0xBB, 0x20,
  // "E" (U+0045)
  0x3D, 0xBB, 0x37, 0x00, 0x37, 0x00, 0x3D, 0xB9, 0x37, 0x00, 0x37, 0x00, 0x3D, 0xBB,
  // "F" (U+0046)
  0x3D, 0xBB, 0x37, 0x00, 0x37, 0x00, 0x3D, 0xB9, 0x37, 0x00, 0x37, 0x00, 0x37, 0x00,
  // "G" (U+0047)
  0x04, 0xBB, 0xB0, 0x1C, 0x10, 0x00, 0x65, 0x00, 0x00, 0x74, 0x08, 0xC3, 0x66, 0x00, 0x73, 0x2C,
  0x00, 0x73, 0x05, 0xCB, 0xC2,
  // "H" (U+0048)
  0x37, 0x00, 0x92, 0x37, 0x00, 0x92, 0x37, 0x00, 0x92, 0x3D, 0xBB, 0xD2, 0x37, 0x00, 0x92, 0x37,
  0x00, 0x92, 0x37, 0x00, 0x92,
  // "I" (U+0049)
  0x7E, 0x30, 0xB0, 0x0B, 0x00, 0xB0, 0x0B, 0x00, 0xB0, 0x6D, 0x30,
  // "J" (U+004A)
  0x04, 0x70, 0x47, 0x04, 0x70, 0x47, 0x04, 0x70, 0x47, 0x05, 0x67, 0xB1,
  // "K" (U+004B)
  0x37, 0x05, 0x73, 0x71, 0xA0, 0x37, 0xA1, 0x03, 0xDC, 0x00, 0x38, 0x66, 0x03, 0x70, 0xB1, 0x37,
  0x03, 0x90,
  // "L" (U+004C)
  0x37, 0x00, 0x37, 0x00, 0x37, 0x00, 0x37, 0x00, 0x37, 0x00, 0x37, 0x00, 0x3D, 0xBB,
  // "M" (U+004D)
  0x3E, 0x00, 0x0B, 0x73, 0xC4, 0x01, 0xC7, 0x38, 0x90, 0x58, 0x73, 0x6A, 0x09, 0x47, 0x36, 0x73,
  0x93, 0x73, 0x62, 0xC5, 0x37, 0x36, 0x0D, 0x13, 0x70,
  // "N" (U+004E)
  0x3D, 0x00, 0x54, 0x3C, 0x80, 0x54, 0x37, 0xD3, 0x54, 0x36, 0x6C, 0x64, 0x36, 0x0D, 0xC4, 0x36,
  0x05, 0xF4, 0x36, 0x00, 0xC4,
  // "O" (U+004F)
  0x05, 0xCC, 0x80, 0x2B, 0x00, 0x85, 0x65, 0x00, 0x1A, 0x74, 0x00, 0x0B, 0x65, 0x00, 0x1A, 0x2B,
  0x00, 0x85, 0x06, 0xCC, 0x80,
  // "P" (U+0050)
  0x3D, 0xBA, 0x03, 0x70, 0x84, 0x37, 0x05, 0x63, 0x70, 0x93, 0x3D, 0xB7, 0x03, 0x70, 0x00, 0x37,
  0x00, 0x00,
  // "Q" (U+0051)
  0x05, 0xCC, 0x80, 0x2B, 0x00, 0x85, 0x65, 0x00, 0x1A, 0x74, 0x00, 0x0B, 0x65, 0x00, 0x1A, 0x2B,
  0x00, 0x85, 0x06, 0xCC, 0x90, 0x00, 0x04, 0x90, 0x00, 0x00, 0x51,
  // "R" (U+0052)
  0x3D, 0xBB, 0x03, 0x70, 0x65, 0x37, 0x07, 0x43, 0xDC, 0x90, 0x37, 0x1A, 0x03, 0x70, 0xA2, 0x37,
  0x03, 0x90,
  // "S" (U+0053)
  0x1B, 0xB9, 0x64, 0x00, 0x58, 0x00, 0x07, 0xC3, 0x00, 0x1C, 0x00, 0x0B, 0x7B, 0xB5,
  // "T" (U+0054)
  0xAC, 0xDB, 0x40, 0x29, 0x00, 0x02, 0x90, 0x00, 0x29, 0x00, 0x02, 0x90, 0x00, 0x29, 0x00, 0x02,
  0x90, 0x00,
  // "U" (U+0055)
  0x46, 0x00, 0x91, 0x46, 0x00, 0x91, 0x46, 0x00, 0x91, 0x46, 0x00, 0x91, 0x47, 0x00, 0x91, 0x1A,
  0x00, 0xB0, 0x06, 0xBC, 0x50,
  // "V" (U+0056)
  0xB0, 0x01, 0xA8, 0x20, 0x55, 0x47, 0x0A, 0x10, 0xB0, 0xB0, 0x0A, 0x47, 0x00, 0x6C, 0x30, 0x01,
  0xD0, 0x00,
  // "W" (U+0057)
  0xB0, 0x0C, 0x20, 0x83, 0x92, 0x0D, 0x60, 0xA0, 0x55, 0x47, 0xA0, 0xB0, 0x28, 0x72, 0xA2, 0x80,
  0x0A, 0xA0, 0x87, 0x50, 0x0A, 0x90, 0x4D, 0x20, 0x07, 0x70, 0x0D, 0x00,
  // "X" (U+0058)
  0x93, 0x07, 0x31, 0xA0, 0xA0, 0x08, 0xA3, 0x00, 0x3D, 0x00, 0x09, 0x85, 0x02, 0x80, 0xB0, 0xA1,
  0x06, 0x60,
  // "Y" (U+0059)
  0xB1, 0x08, 0x45, 0x81, 0xC0, 0x0D, 0xA6, 0x00, 0x7E, 0x00, 0x01, 0xA0, 0x00, 0x19, 0x00, 0x01,
  0x90, 0x00,
  // "Z" (U+005A)
  0x6B, 0xBE, 0x20, 0x01, 0xA0, 0x00, 0x93, 0x00, 0x29, 0x00, 0x0A, 0x20, 0x03, 0x80, 0x00, 0xAC,
  0xBB, 0x30,
  // "[" (U+005B)
  0x5C, 0x55, 0x50, 0x55, 0x05, 0x50, 0x55, 0x05, 0x50, 0x55, 0x04, 0xC5,
  // "\" (U+005C)
  0xA0, 0x07, 0x30, 0x28, 0x00, 0xA0, 0x08, 0x20, 0x36, 0x00, 0xA0,
  // "]" (U+005D)
  0x9E, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x9C,
  // "^" (U+005E)
  0x03, 0x90, 0x00, 0x87, 0x10, 0x17, 0x18, 0x07, 0x20, 0x81,
  // "_" (U+005F)
  0x99, 0x95,
  // "`" (U+0060)
  0x42, 0x18,
  // "a" (U+0061)
  0x0B, 0xC7, 0x00, 0x0B, 0x2B, 0xBC, 0x93, 0x0B, 0x4C, 0xA9,
  // "b" (U+0062)
  0x46, 0x00, 0x04, 0x60, 0x00, 0x4A, 0xBA, 0x04, 0x80, 0x65, 0x46, 0x04, 0x74, 0x80, 0x65, 0x49,
  0xBA, 0x00,
  // "c" (U+0063)
  0x0A, 0xB5, 0x65, 0x00, 0x83, 0x00, 0x65, 0x00, 0x0A, 0xB5,
  // "d" (U+0064)
  0x00, 0x07, 0x30, 0x00, 0x73, 0x0B, 0xBA, 0x36, 0x50, 0x93, 0x83, 0x07, 0x36, 0x50, 0x93, 0x1B,
  0xA9, 0x30,
  // "e" (U+0065)
  0x0A, 0xC6, 0x05, 0x50, 0xB0, 0x8C, 0xBC, 0x16, 0x50, 0x00, 0x0A, 0xBA, 0x00,
  // "f" (U+0066)
  0x0A, 0xB1, 0x90, 0x9D, 0x71, 0x90, 0x19, 0x01, 0x90, 0x19, 0x00,
  // "g" (U+0067)
  0x0B, 0xB9, 0x36, 0x50, 0x93, 0x83, 0x07, 0x36, 0x50, 0x93, 0x1B, 0xBA, 0x30, 0x00, 0x92, 0x2B,
  0xB9, 0x00,
  // "h" (U+0068)
  0x46, 0x00, 0x04, 0x60, 0x00, 0x4A, 0xBB, 0x04, 0x80, 0x74, 0x46, 0x06, 0x44, 0x60, 0x64, 0x46,
  0x06, 0x40,
  // "i" (U+0069)
  0x33, 0x00, 0x46, 0x46, 0x46, 0x46, 0x46,
  // "j" (U+006A)
  0x03, 0x30, 0x00, 0x04, 0x60, 0x46, 0x04, 0x60, 0x46, 0x04, 0x60, 0x55, 0x5C, 0x20,
  // "k" (U+006B)
  0x45, 0x00, 0x45, 0x00, 0x45, 0x29, 0x46, 0xA0, 0x4D, 0x90, 0x46, 0x93, 0x45, 0x1B,
  // "l" (U+006C)
  0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46,
  // "m" (U+006D)
  0x49, 0xB9, 0x8C, 0x64, 0x80, 0xA4, 0x0B, 0x46, 0x09, 0x10, 0xA4, 0x60, 0x91, 0x0A, 0x46, 0x09,
  0x10, 0xA0,
  // "n" (U+006E)
  0x49, 0xBB, 0x04, 0x80, 0x74, 0x46, 0x06, 0x44, 0x60, 0x64, 0x46, 0x06, 0x40,
  // "o" (U+006F)
  0x0A, 0xB9, 0x06, 0x50, 0x83, 0x83, 0x05, 0x55, 0x50, 0x83, 0x0A, 0xB9, 0x00,
  // "p" (U+0070)
  0x49, 0xBA, 0x04, 0x80, 0x65, 0x46, 0x04, 0x74, 0x80, 0x75, 0x4A, 0xBB, 0x04, 0x60, 0x00, 0x46,
  0x00, 0x00,
  // "q" (U+0071)
  0x0B, 0xB9, 0x36, 0x50, 0xA3, 0x83, 0x07, 0x36, 0x50, 0x93, 0x1B, 0xAA, 0x30, 0x00, 0x73, 0x00,
  0x07, 0x30,
  // "r" (U+0072)
  0x48, 0xB1, 0x4A, 0x00, 0x46, 0x00, 0x46, 0x00, 0x46, 0x00,
  // "s" (U+0073)
  0x4C, 0xB3, 0x73, 0x00, 0x07, 0x80, 0x00, 0x56, 0x6B, 0xB2,
  // "t" (U+0074)
  0x16, 0x09, 0xD8, 0x46, 0x04, 0x60, 0x37, 0x01, 0xC8,
  // "u" (U+0075)
  0x55, 0x06, 0x45, 0x50, 0x64, 0x55, 0x07, 0x45, 0x60, 0x94, 0x1C, 0xB9, 0x40,
  // "v" (U+0076)
  0xB0, 0x0B, 0x73, 0x28, 0x28, 0x73, 0x0A, 0xA0, 0x08, 0x90,
  // "w" (U+0077)
  0xB0, 0x5A, 0x09, 0x18, 0x29, 0xA0, 0xA0, 0x55, 0x97, 0x49, 0x01, 0xB7, 0x3B, 0x50, 0x0D, 0x30,
  0xE2, 0x00,
  // "x" (U+0078)
  0x74, 0x1A, 0x0A, 0x92, 0x07, 0xA0, 0x0B, 0x92, 0x83, 0x1A,
  // "y" (U+0079)
  0xB0, 0x0B, 0x74, 0x28, 0x19, 0x73, 0x0A, 0xA0, 0x06, 0x80, 0x08, 0x30, 0xA9, 0x00,
  // "z" (U+007A)
  0x6B, 0xD5, 0x00, 0xA0, 0x07, 0x30, 0x29, 0x00, 0x9C, 0xB5,
  // "{" (U+007B)
  0x05, 0x90, 0xA0, 0x0A, 0x00, 0xA0, 0xB6, 0x00, 0xB0, 0x0B, 0x00, 0x59,
  // "|" (U+007C)
  0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17,
  // "}" (U+007D)
  0x96, 0x00, 0xB0, 0x0A, 0x00, 0xA0, 0x05, 0xB0, 0xB0, 0x0B, 0x09, 0x60,
  // "~" (U+007E)
  0x4B, 0x64, 0x23, 0x08, 0xA0,
  // "¡" (U+00A1)
  0x35, 0x34, 0x35, 0x46, 0x46, 0x57,
  // "¢" (U+00A2)
  0x00, 0x80, 0x06, 0xD9, 0x2A, 0x00, 0x37, 0x00, 0x2A, 0x00, 0x07, 0xD9, 0x00, 0x80,
  // "£" (U+00A3)
  0x06, 0xBB, 0x00, 0xB0, 0x00, 0x0A, 0x00, 0x08, 0xEB, 0x40, 0x0A, 0x00, 0x01, 0x90, 0x00, 0xAC,
  0xBB, 0x30,
  // "¤" (U+00A4)
  0x4B, 0xBB, 0x26, 0x08, 0x26, 0x09, 0x4A, 0xBA,
  // "¥" (U+00A5)
  0xA2, 0x08, 0x34, 0x91, 0xC0, 0x0D, 0xA7, 0x00, 0x8F, 0x10, 0x3C, 0xE9, 0x03, 0xBE, 0x90, 0x01,
  0x90, 0x00,
  // "¦" (U+00A6)
  0x17, 0x17, 0x17, 0x00, 0x00, 0x00, 0x17, 0x17, 0x17,
  // "§" (U+00A7)
  0x2B, 0xB4, 0x56, 0x00, 0x2B, 0xA2, 0x64, 0x28, 0x09, 0xB3, 0x00, 0x47, 0x6B, 0xB3,
  // "¨" (U+00A8)
  0x62, 0x30,
  // "©" (U+00A9)
  0x01, 0x67, 0x50, 0x00, 0x75, 0x95, 0x70, 0x60, 0x90, 0x06, 0x16, 0x18, 0x00, 0x33, 0x61, 0x90,
  0x06, 0x10, 0x86, 0x95, 0x70, 0x01, 0x77, 0x60, 0x00,
  // "ª" (U+00AA)
  0x36, 0x47, 0x67, 0x66, 0x70,
  // "«" (U+00AB)
  0x06, 0x15, 0x66, 0xA1, 0x38, 0x82, 0x04, 0x04,
  // "¬" (U+00AC)
  0x6B, 0xBC, 0x20, 0x00, 0x62, 0x00, 0x02, 0x00,
  // "®" (U+00AE)
  0x01, 0x67, 0x50, 0x00, 0x79, 0x94, 0x70, 0x60, 0x92, 0x76, 0x16, 0x0A, 0xC1, 0x33, 0x60, 0x94,
  0x56, 0x10, 0x83, 0x06, 0x70, 0x01, 0x77, 0x60, 0x00,
  // "¯" (U+00AF)
  0x99, 0x99,
  // "°" (U+00B0)
  0x28, 0x67, 0x08, 0x29, 0x60,
  // "±" (U+00B1)
  0x00, 0x80, 0x06, 0xBD, 0xB1, 0x00, 0x80, 0x00, 0x08, 0x00, 0x6B, 0xBB, 0x20,
  // "²" (U+00B2)
  0x58, 0x20, 0x35, 0x17, 0x08, 0x73,
  // "³" (U+00B3)
  0x47, 0x32, 0xA3, 0x01, 0x76, 0x82,
  // "´" (U+00B4)
  0x06, 0x63,
  // "µ" (U+00B5)
  0x46, 0x06, 0x44, 0x60, 0x64, 0x46, 0x06, 0x44, 0x70, 0x94, 0x4D, 0xB9, 0x44, 0x50, 0x00, 0x46,
  0x00, 0x00,
  // "¶" (U+00B6)
  0x1C, 0xFC, 0x67, 0xFF, 0x26, 0x8F, 0xF2, 0x66, 0xFF, 0x26, 0x08, 0xC2, 0x60, 0x05, 0x26, 0x00,
  0x52, 0x60, 0x05, 0x26, 0x00, 0x10, 0x10,
  // "·" (U+00B7)
  0x34,
  // "¸" (U+00B8)
  0x10, 0x46, 0x75,
  // "¹" (U+00B9)
  0x05, 0x4A, 0x08, 0x08,
  // "º" (U+00BA)
  0x67, 0x68, 0x08, 0x37, 0x30,
  // "»" (U+00BB)
  0x52, 0x70, 0x0A, 0x56, 0x29, 0x74, 0x30, 0x40,
  // "¼" (U+00BC)
  0x3C, 0x00, 0x90, 0x38, 0x03, 0x50, 0x08, 0x09, 0x00, 0x08, 0x35, 0x76, 0x00, 0x93, 0x76, 0x03,
  0x58, 0x9A, 0x09, 0x00, 0x36,
  // "½" (U+00BD)
  0x4B, 0x01, 0x80, 0x48, 0x07, 0x10, 0x08, 0x18, 0x00, 0x08, 0x72, 0x86, 0x01, 0x70, 0x08, 0x08,
  0x10, 0x71, 0x06, 0x04, 0x97,
  // "¾" (U+00BE)
  0x69, 0x20, 0x43, 0x00, 0x36, 0x09, 0x00, 0x3C, 0x25, 0x40, 0x00, 0x17, 0x93, 0xA0, 0x79, 0x74,
  0x99, 0x00, 0x09, 0x59, 0xC1, 0x05, 0x30, 0x09, 0x00,
  // "¿" (U+00BF)
  0x00, 0x80, 0x00, 0x30, 0x00, 0x90, 0x08, 0x40, 0x29, 0x00, 0x37, 0x00, 0x0A, 0xB9,
  // "À" (U+00C0)
  0x04, 0x20, 0x00, 0x18, 0x00, 0x00, 0xD0, 0x00, 0x3B, 0x50, 0x08, 0x3A, 0x00, 0xB0, 0xA0, 0x3D,
  0xBD, 0x48, 0x30, 0x19, 0xB0, 0x00, 0xB0,
  // "Á" (U+00C1)
  0x00, 0x06, 0x00, 0x06, 0x30, 0x00, 0xD0, 0x00, 0x3B, 0x50, 0x08, 0x3A, 0x00, 0xB0, 0xA0, 0x3D,
  0xBD, 0x48, 0x30, 0x19, 0xB0, 0x00, 0xB0,
  // "Â" (U+00C2)
  0x00, 0x61, 0x00, 0x56, 0x80, 0x00, 0xD0, 0x00, 0x3B, 0x50, 0x08, 0x3A, 0x00, 0xB0, 0xA0, 0x3D,
  0xBD, 0x48, 0x30, 0x19, 0xB0, 0x00, 0xB0,
  // "Ã" (U+00C3)
  0x05, 0xFB, 0x10, 0x3B, 0x50, 0x08, 0x3A, 0x00, 0xB0, 0xA0, 0x3D, 0xBD, 0x48, 0x30, 0x19, 0xB0,
  0x00, 0xB0,
  // "Ä" (U+00C4)
  0x06, 0x23, 0x00, 0x0D, 0x00, 0x03, 0xB5, 0x00, 0x83, 0xA0, 0x0B, 0x0A, 0x03, 0xDB, 0xD4, 0x83,
  0x01, 0x9B, 0x00, 0x0B,
  // "Å" (U+00C5)
  0x04, 0xF1, 0x00, 0x8F, 0x50, 0x08, 0x3A, 0x00, 0xB0, 0xA0, 0x3D, 0xBD, 0x48, 0x30, 0x19, 0xB0,
  0x00, 0xB0,
  // "Æ" (U+00C6)
  0x00, 0x7D, 0xCB, 0x60, 0x0B, 0x64, 0x00, 0x04, 0x76, 0x40, 0x00, 0xA1, 0x6C, 0xB4, 0x1E, 0xBD,
  0x40, 0x06, 0x50, 0x64, 0x00, 0xB0, 0x06, 0xCB, 0x60,
  // "Ç" (U+00C7)
  0x04, 0xCC, 0x81, 0xB0, 0x00, 0x65, 0x00, 0x07, 0x40, 0x00, 0x65, 0x00, 0x02, 0xB0, 0x00, 0x06,
  0xDC, 0x60, 0x04, 0x60, 0x00, 0x75, 0x00,
  // "È" (U+00C8)
  0x04, 0x20, 0x01, 0x80, 0x3D, 0xBB, 0x37, 0x00, 0x37, 0x00, 0x3D, 0xB9, 0x37, 0x00, 0x37, 0x00,
  0x3D, 0xBB,
  // "É" (U+00C9)
  0x00, 0x06, 0x00, 0x63, 0x3D, 0xBB, 0x37, 0x00, 0x37, 0x00, 0x3D, 0xB9, 0x37, 0x00, 0x37, 0x00,
  0x3D, 0xBB,
  // "Ê" (U+00CA)
  0x00, 0x61, 0x05, 0x68, 0x3D, 0xBB, 0x37, 0x00, 0x37, 0x00, 0x3D, 0xB9, 0x37, 0x00, 0x37, 0x00,
  0x3D, 0xBB,
  // "Ë" (U+00CB)
  0x06, 0x23, 0x3D, 0xBB, 0x37, 0x00, 0x37, 0x00, 0x3D, 0xB9, 0x37, 0x00, 0x37, 0x00, 0x3D, 0xBB,
  // "Ì" (U+00CC)
  0x42, 0x01, 0x80, 0x7E, 0x30, 0xB0, 0x0B, 0x00, 0xB0, 0x0B, 0x00, 0xB0, 0x6D, 0x30,
  // "Í" (U+00CD)
  0x00, 0x60, 0x63, 0x7E, 0x30, 0xB0, 0x0B, 0x00, 0xB0, 0x0B, 0x00, 0xB0, 0x6D, 0x30,
  // "Î" (U+00CE)
  0x06, 0x15, 0x68, 0x7E, 0x30, 0xB0, 0x0B, 0x00, 0xB0, 0x0B, 0x00, 0xB0, 0x6D, 0x30,
  // "Ï" (U+00CF)
  0x62, 0x37, 0xE3, 0x0B, 0x00, 0xB0, 0x0B, 0x00, 0xB0, 0x0B, 0x06, 0xD3,
  // "Ð" (U+00D0)
  0x2D, 0xBB, 0x30, 0x28, 0x01, 0xC0, 0x28, 0x00, 0x84, 0x9D, 0xB0, 0x65, 0x28, 0x00, 0x83, 0x28,
  0x02, 0xC0, 0x2D, 0xBB, 0x20,
  // "Ñ" (U+00D1)
  0x3F, 0xCA, 0x64, 0x3C, 0x80, 0x54, 0x37, 0xD3, 0x54, 0x36, 0x6C, 0x64, 0x36, 0x0D, 0xC4, 0x36,
  0x05, 0xF4, 0x36, 0x00, 0xC4,
  // "Ò" (U+00D2)
  0x00, 0x42, 0x00, 0x00, 0x18, 0x00, 0x05, 0xCC, 0x80, 0x2B, 0x00, 0x85, 0x65, 0x00, 0x1A, 0x74,
  0x00, 0x0B, 0x65, 0x00, 0x1A, 0x2B, 0x00, 0x85, 0x06, 0xCC, 0x80,
  // "Ó" (U+00D3)
  0x00, 0x06, 0x00, 0x00, 0x63, 0x00, 0x05, 0xCC, 0x80, 0x2B, 0x00, 0x85, 0x65, 0x00, 0x1A, 0x74,
  0x00, 0x0B, 0x65, 0x00, 0x1A, 0x2B, 0x00, 0x85, 0x06, 0xCC, 0x80,
  // "Ô" (U+00D4)
  0x00, 0x61, 0x00, 0x05, 0x68, 0x00, 0x05, 0xCC, 0x80, 0x2B, 0x00, 0x85, 0x65, 0x00, 0x1A, 0x74,
  0x00, 0x0B, 0x65, 0x00, 0x1A, 0x2B, 0x00, 0x85, 0x06, 0xCC, 0x80,
  // "Õ" (U+00D5)
  0x0B, 0xFF, 0x90, 0x2B, 0x00, 0x85, 0x65, 0x00, 0x1A, 0x74, 0x00, 0x0B, 0x65, 0x00, 0x1A, 0x2B,
  0x00, 0x85, 0x06, 0xCC, 0x80,
  // "Ö" (U+00D6)
  0x00, 0x62, 0x30, 0x05, 0xCC, 0x80, 0x2B, 0x00, 0x85, 0x65, 0x00, 0x1A, 0x74, 0x00, 0x0B, 0x65,
  0x00, 0x1A, 0x2B, 0x00, 0x85, 0x06, 0xCC, 0x80,
  // "×" (U+00D7)
  0x22, 0x04, 0x09, 0x85, 0x07, 0xB2, 0x35, 0x08,
  // "Ø" (U+00D8)
  0x05, 0xCB, 0xC3, 0x2B, 0x01, 0xD4, 0x65, 0x09, 0x39, 0x74, 0x37, 0x0B, 0x65, 0xA0, 0x1A, 0x1E,
  0x40, 0x75, 0x0C, 0xCC, 0x80,
  // "Ù" (U+00D9)
  0x00, 0x42, 0x00, 0x00, 0x18, 0x00, 0x46, 0x00, 0x91, 0x46, 0x00, 0x91, 0x46, 0x00, 0x91, 0x46,
  0x00, 0x91, 0x47, 0x00, 0x91, 0x1A, 0x00, 0xB0, 0x06, 0xBC, 0x50,
  // "Ú" (U+00DA)
  0x00, 0x06, 0x00, 0x00, 0x63, 0x00, 0x46, 0x00, 0x91, 0x46, 0x00, 0x91, 0x46, 0x00, 0x91, 0x46,
  0x00, 0x91, 0x47, 0x00, 0x91, 0x1A, 0x00, 0xB0, 0x06, 0xBC, 0x50,
  // "Û" (U+00DB)
  0x00, 0x61, 0x00, 0x05, 0x68, 0x00, 0x46, 0x00, 0x91, 0x46, 0x00, 0x91, 0x46, 0x00, 0x91, 0x46,
  0x00, 0x91, 0x47, 0x00, 0x91, 0x1A, 0x00, 0xB0, 0x06, 0xBC, 0x50,
  // "Ü" (U+00DC)
  0x00, 0x62, 0x30, 0x46, 0x00, 0x91, 0x46, 0x00, 0x91, 0x46, 0x00, 0x91, 0x46, 0x00, 0x91, 0x47,
  0x00, 0x91, 0x1A, 0x00, 0xB0, 0x06, 0xBC, 0x50,
  // "Ý" (U+00DD)
  0x00, 0x60, 0x00, 0x63, 0x00, 0xB1, 0x08, 0x45, 0x81, 0xC0, 0x0D, 0xA6, 0x00, 0x7E, 0x00, 0x01,
  0xA0, 0x00, 0x19, 0x00, 0x01, 0x90, 0x00,
  // "Þ" (U+00DE)
  0x37, 0x00, 0x03, 0xDB, 0x80, 0x37, 0x09, 0x43, 0x70, 0x56, 0x37, 0x09, 0x33, 0xDB, 0x70, 0x37,
  0x00, 0x00,
  // "ß" (U+00DF)
  0x0B, 0xBA, 0x04, 0x70, 0x91, 0x46, 0x48, 0x04, 0x68, 0x40, 0x46, 0x09, 0x44, 0x60, 0x19, 0x46,
  0xBC, 0x50,
  // "à" (U+00E0)
  0x04, 0x20, 0x01, 0x80, 0x00, 0x00, 0x0B, 0xC7, 0x00, 0x0B, 0x2B, 0xBC, 0x93, 0x0B, 0x4C, 0xA9,
  // "á" (U+00E1)
  0x00, 0x60, 0x06, 0x30, 0x00, 0x00, 0x0B, 0xC7, 0x00, 0x0B, 0x2B, 0xBC, 0x93, 0x0B, 0x4C, 0xA9,
  // "â" (U+00E2)
  0x00, 0x61, 0x05, 0x68, 0x00, 0x00, 0x0B, 0xC7, 0x00, 0x0B, 0x2B, 0xBC, 0x93, 0x0B, 0x4C, 0xA9,
  // "ã" (U+00E3)
  0x5B, 0xA1, 0x0B, 0xC7, 0x00, 0x0B, 0x2B, 0xBC, 0x93, 0x0B, 0x4C, 0xA9,
  // "ä" (U+00E4)
  0x06, 0x23, 0x00, 0x00, 0x0B, 0xC7, 0x00, 0x0B, 0x2B, 0xBC, 0x93, 0x0B, 0x4C, 0xA9,
  // "å" (U+00E5)
  0x04, 0x70, 0x04, 0x70, 0x0B, 0xC7, 0x00, 0x0B, 0x2B, 0xBC, 0x93, 0x0B, 0x4C, 0xA9,
  // "æ" (U+00E6)
  0x1B, 0xC6, 0xBB, 0x00, 0x00, 0xD0, 0x65, 0x2B, 0xBE, 0xBC, 0x69, 0x31, 0xD0, 0x00, 0x4C, 0xB5,
  0xCB, 0x30,
  // "ç" (U+00E7)
  0x0A, 0xB5, 0x65, 0x00, 0x83, 0x00, 0x65, 0x00, 0x0C, 0xC5, 0x04, 0x60, 0x07, 0x50,
  // "è" (U+00E8)
  0x10, 0x40, 0x23, 0x01, 0x08, 0x71, 0x89, 0x6A, 0xC6, 0x05, 0x50, 0xB0, 0x8C, 0xBC, 0x16, 0x54,
  0x81, 0xAB, 0xA1,
  // "é" (U+00E9)
  0x20, 0x63, 0x06, 0x03, 0x71, 0x89, 0x6A, 0xC6, 0x05, 0x50, 0xB0, 0x8C, 0xBC, 0x16, 0x54, 0x81,
  0xAB, 0xA1,
  // "ê" (U+00EA)
  0x20, 0x60, 0x12, 0x81, 0x56, 0x87, 0x89, 0x6A, 0xC6, 0x05, 0x50, 0xB0, 0x8C, 0xBC, 0x16, 0x54,
  0x81, 0xAB, 0xA1,
  // "ë" (U+00EB)
  0x18, 0x16, 0x23, 0x78, 0x96, 0xAC, 0x60, 0x55, 0x0B, 0x08, 0xCB, 0xC1, 0x65, 0x48, 0x1A, 0xBA,
  0x10,
  // "ì" (U+00EC)
  0x42, 0x18, 0x00, 0x46, 0x46, 0x46, 0x46, 0x46,
  // "í" (U+00ED)
  0x06, 0x63, 0x00, 0x46, 0x46, 0x46, 0x46, 0x46,
  // "î" (U+00EE)
  0x06, 0x15, 0x68, 0x00, 0x00, 0x46, 0x04, 0x60, 0x46, 0x04, 0x60, 0x46,
  // "ï" (U+00EF)
  0x62, 0x30, 0x00, 0x46, 0x04, 0x60, 0x46, 0x04, 0x60, 0x46, 0x00,
  // "ð" (U+00F0)
  0x02, 0x14, 0x00, 0x3E, 0x70, 0x04, 0x2A, 0x00, 0x9B, 0xC2, 0x56, 0x08, 0x58, 0x20, 0x55, 0x55,
  0x08, 0x30, 0xAB, 0x80,
  // "ñ" (U+00F1)
  0x05, 0xBA, 0x14, 0x9B, 0xB0, 0x48, 0x07, 0x44, 0x60, 0x64, 0x46, 0x06, 0x44, 0x60, 0x64,
  // "ò" (U+00F2)
  0x04, 0x20, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0xAB, 0x90, 0x65, 0x08, 0x38, 0x30, 0x55, 0x55,
  0x08, 0x30, 0xAB, 0x90,
  // "ó" (U+00F3)
  0x30, 0x63, 0x06, 0x03, 0x78, 0xA5, 0xAB, 0x90, 0x65, 0x08, 0x38, 0x30, 0x55, 0x55, 0x08, 0x30,
  0xAB, 0x91,
  // "ô" (U+00F4)
  0x00, 0x61, 0x00, 0x56, 0x80, 0x00, 0x00, 0x00, 0xAB, 0x90, 0x65, 0x08, 0x38, 0x30, 0x55, 0x55,
  0x08, 0x30, 0xAB, 0x90,
  // "õ" (U+00F5)
  0x05, 0xBA, 0x10, 0xAB, 0x90, 0x65, 0x08, 0x38, 0x30, 0x55, 0x55, 0x08, 0x30, 0xAB, 0x90,
  // "ö" (U+00F6)
  0x18, 0x16, 0x23, 0x78, 0xA5, 0xAB, 0x90, 0x65, 0x08, 0x38, 0x30, 0x55, 0x55, 0x08, 0x30, 0xAB,
  0x91,
  // "÷" (U+00F7)
  0x01, 0x60, 0x06, 0xBB, 0xB2, 0x00, 0x00, 0x00, 0x16, 0x00,
  // "ø" (U+00F8)
  0x0A, 0xBC, 0x16, 0x53, 0xD2, 0x83, 0x95, 0x55, 0xC2, 0x83, 0x3D, 0xB9, 0x00,
  // "ù" (U+00F9)
  0x04, 0x20, 0x00, 0x18, 0x00, 0x00, 0x00, 0x05, 0x50, 0x64, 0x55, 0x06, 0x45, 0x50, 0x74, 0x56,
  0x09, 0x41, 0xCB, 0x94,
  // "ú" (U+00FA)
  0x30, 0x63, 0x06, 0x03, 0x68, 0xA7, 0x55, 0x06, 0x45, 0x50, 0x64, 0x55, 0x07, 0x45, 0x60, 0x94,
  0x1C, 0xB9, 0x40,
  // "û" (U+00FB)
  0x00, 0x61, 0x00, 0x56, 0x80, 0x00, 0x00, 0x05, 0x50, 0x64, 0x55, 0x06, 0x45, 0x50, 0x74, 0x56,
  0x09, 0x41, 0xCB, 0x94,
  // "ü" (U+00FC)
  0x06, 0x23, 0x00, 0x00, 0x00, 0x55, 0x06, 0x45, 0x50, 0x64, 0x55, 0x07, 0x45, 0x60, 0x94, 0x1C,
  0xB9, 0x40,
  // "ý" (U+00FD)
  0x00, 0x60, 0x06, 0x30, 0x00, 0x00, 0xB0, 0x0B, 0x74, 0x28, 0x19, 0x73, 0x0A, 0xA0, 0x06, 0x80,
  0x08, 0x30, 0xA9, 0x00,
  // "þ" (U+00FE)
  0x46, 0x00, 0x04, 0x60, 0x00, 0x4A, 0xBA, 0x04, 0x80, 0x65, 0x46, 0x04, 0x74, 0x80, 0x65, 0x4A,
  0xBA, 0x04, 0x60, 0x00, 0x46, 0x00, 0x00,
  // "ÿ" (U+00FF)
  0x06, 0x23, 0x00, 0x00, 0xB0, 0x0B, 0x74, 0x28, 0x19, 0x73, 0x0A, 0xA0, 0x06, 0x80, 0x08, 0x30,
  0xA9, 0x00,
  // "Ā" (U+0100)
  0x08, 0xF9, 0x00, 0x3B, 0x50, 0x08, 0x3A, 0x00, 0xB0, 0xA0, 0x3D, 0xBD, 0x48, 0x30, 0x19, 0xB0,
  0x00, 0xB0,
  // "ā" (U+0101)
  0x08, 0xB8, 0x0B, 0xC7, 0x00, 0x0B, 0x2B, 0xBC, 0x93, 0x0B, 0x4C, 0xA9,
  // "Ă" (U+0102)
  0x00, 0x01, 0x00, 0x5F, 0x70, 0x03, 0xB5, 0x00, 0x83, 0xA0, 0x0B, 0x0A, 0x03, 0xDB, 0xD4, 0x83,
  0x01, 0x9B, 0x00, 0x0B,
  // "ă" (U+0103)
  0x00, 0x01, 0x05, 0xB6, 0x0B, 0xC7, 0x00, 0x0B, 0x2B, 0xBC, 0x93, 0x0B, 0x4C, 0xA9,
  // "Ą" (U+0104)
  0x20, 0xD3, 0x81, 0x3B, 0x52, 0x81, 0x83, 0xA2, 0x89, 0x5B, 0x0A, 0x03, 0xDB, 0xD4, 0x83, 0x01,
  0x9B, 0x30, 0xD3, 0x08, 0x40, 0x05,
  // "ą" (U+0105)
  0x0B, 0xC7, 0x00, 0x0B, 0x2B, 0xBC, 0x93, 0x0B, 0x4C, 0xAB, 0x00, 0x80, 0x00, 0x55,
  // "Ć" (U+0106)
  0x30, 0x63, 0x06, 0x03, 0x28, 0x44, 0xCC, 0x81, 0xB3, 0x06, 0x05, 0x30, 0x70, 0x43, 0x06, 0x05,
  0x30, 0x20, 0xB4, 0x82, 0x6C, 0xB6,
  // "ć" (U+0107)
  0x00, 0x60, 0x06, 0x30, 0x00, 0x00, 0x0A, 0xB5, 0x65, 0x00, 0x83, 0x00, 0x65, 0x00, 0x0A, 0xB5,
  // "Ĉ" (U+0108)
  0x00, 0x61, 0x00, 0x56, 0x80, 0x04, 0xCC, 0x81, 0xB0, 0x00, 0x65, 0x00, 0x07, 0x40, 0x00, 0x65,
  0x00, 0x02, 0xB0, 0x00, 0x06, 0xCB, 0x60,
  // "ĉ" (U+0109)
  0x00, 0x61, 0x05, 0x68, 0x00, 0x00, 0x0A, 0xB5, 0x65, 0x00, 0x83, 0x00, 0x65, 0x00, 0x0A, 0xB5,
  // "Ċ" (U+010A)
  0x00, 0x60, 0x00, 0x4C, 0xC8, 0x1B, 0x00, 0x06, 0x50, 0x00, 0x74, 0x00, 0x06, 0x50, 0x00, 0x2B,
  0x00, 0x00, 0x6C, 0xB6,
  // "ċ" (U+010B)
  0x00, 0x60, 0x00, 0x00, 0x0A, 0xB5, 0x65, 0x00, 0x83, 0x00, 0x65, 0x00, 0x0A, 0xB5,
  // "Č" (U+010C)
  0x04, 0x04, 0x00, 0x1C, 0x50, 0x04, 0xCC, 0x81, 0xB0, 0x00, 0x65, 0x00, 0x07, 0x40, 0x00, 0x65,
  0x00, 0x02, 0xB0, 0x00, 0x06, 0xCB, 0x60,
  // "č" (U+010D)
  0x04, 0x04, 0x01, 0xC5, 0x00, 0x00, 0x0A, 0xB5, 0x65, 0x00, 0x83, 0x00, 0x65, 0x00, 0x0A, 0xB5,
  // "Ď" (U+010E)
  0x04, 0x04, 0x00, 0x01, 0xC5, 0x00, 0x3D, 0xBB, 0x30, 0x37, 0x01, 0xC0, 0x37, 0x00, 0x84, 0x37,
  0x00, 0x65, 0x37, 0x00, 0x83, 0x37, 0x02, 0xC0, 0x3D, 0xBB, 0x20,
  // "ď" (U+010F)
  0x00, 0x07, 0x84, 0x00, 0x07, 0x40, 0x0B, 0xBA, 0x30, 0x65, 0x09, 0x30, 0x83, 0x07, 0x30, 0x65,
  0x09, 0x30, 0x1B, 0xA9, 0x30,
  // "Đ" (U+0110)
  0x2D, 0xBB, 0x30, 0x28, 0x01, 0xC0, 0x28, 0x00, 0x84, 0x9D, 0xB0, 0x65, 0x28, 0x00, 0x83, 0x28,
  0x02, 0xC0, 0x2D, 0xBB, 0x20,
  // "đ" (U+0111)
  0x00, 0x07, 0x30, 0x2B, 0xDA, 0x1B, 0xBA, 0x36, 0x50, 0x93, 0x83, 0x07, 0x36, 0x50, 0x93, 0x1B,
  0xAA, 0x30,
  // "Ē" (U+0112)
  0x3F, 0xFF, 0x37, 0x00, 0x37, 0x00, 0x3D, 0xB9, 0x37, 0x00, 0x37, 0x00, 0x3D, 0xBB,
  // "ē" (U+0113)
  0x08, 0xB8, 0x00, 0xAC, 0x60, 0x55, 0x0B, 0x08, 0xCB, 0xC1, 0x65, 0x00, 0x00, 0xAB, 0xA0,
  // "Ĕ" (U+0114)
  0x00, 0x01, 0x3F, 0xFF, 0x37, 0x00, 0x37, 0x00, 0x3D, 0xB9, 0x37, 0x00, 0x37, 0x00, 0x3D, 0xBB,
  // "ĕ" (U+0115)
  0x00, 0x01, 0x00, 0x5B, 0x60, 0x0A, 0xC6, 0x05, 0x50, 0xB0, 0x8C, 0xBC, 0x16, 0x50, 0x00, 0x0A,
  0xBA, 0x00,
  // "Ė" (U+0116)
  0x00, 0x60, 0x3D, 0xBB, 0x37, 0x00, 0x37, 0x00, 0x3D, 0xB9, 0x37, 0x00, 0x37, 0x00, 0x3D, 0xBB,
  // "ė" (U+0117)
  0x20, 0x67, 0x18, 0x96, 0xAC, 0x60, 0x55, 0x0B, 0x08, 0xCB, 0xC1, 0x65, 0x48, 0x1A, 0xBA, 0x10,
  // "Ę" (U+0118)
  0x3D, 0xBB, 0x37, 0x00, 0x37, 0x00, 0x3D, 0xB9, 0x37, 0x00, 0x37, 0x00, 0x3D, 0xCD, 0x00, 0x80,
  0x00, 0x55,
  // "ę" (U+0119)
  0x0A, 0xC6, 0x05, 0x50, 0xB0, 0x8C, 0xBC, 0x16, 0x50, 0x00, 0x0A, 0xBB, 0x00, 0x03, 0x30, 0x00,
  0x4A, 0x00,
  // "Ě" (U+011A)
  0x04, 0x04, 0x01, 0xC5, 0x3D, 0xBB, 0x37, 0x00, 0x37, 0x00, 0x3D, 0xB9, 0x37, 0x00, 0x37, 0x00,
  0x3D, 0xBB,
  // "ě" (U+011B)
  0x04, 0x04, 0x00, 0x1C, 0x50, 0x00, 0x00, 0x00, 0xAC, 0x60, 0x55, 0x0B, 0x08, 0xCB, 0xC1, 0x65,
  0x00, 0x00, 0xAB, 0xA0,
  // "Ĝ" (U+011C)
  0x00, 0x06, 0x10, 0x00, 0x56, 0x80, 0x04, 0xBB, 0xB0, 0x1C, 0x10, 0x00, 0x65, 0x00, 0x00, 0x74,
  0x08, 0xC3, 0x66, 0x00, 0x73, 0x2C, 0x00, 0x73, 0x05, 0xCB, 0xC2,
  // "ĝ" (U+011D)
  0x00, 0x61, 0x00, 0x56, 0x80, 0x00, 0x00, 0x00, 0xBB, 0x93, 0x65, 0x09, 0x38, 0x30, 0x73, 0x65,
  0x09, 0x31, 0xBB, 0xA3, 0x00, 0x09, 0x22, 0xBB, 0x90,
  // "Ğ" (U+011E)
  0x00, 0x00, 0x10, 0x04, 0xFF, 0xF0, 0x1C, 0x10, 0x00, 0x65, 0x00, 0x00, 0x74, 0x08, 0xC3, 0x66,
  0x00, 0x73, 0x2C, 0x00, 0x73, 0x05, 0xCB, 0xC2,
  // "ğ" (U+011F)
  0x00, 0x01, 0x00, 0x5B, 0x60, 0x0B, 0xB9, 0x36, 0x50, 0x93, 0x83, 0x07, 0x36, 0x50, 0x93, 0x1B,
  0xBA, 0x30, 0x00, 0x92, 0x2B, 0xB9, 0x00,
  // "Ġ" (U+0120)
  0x00, 0x06, 0x00, 0x04, 0xBB, 0xB0, 0x1C, 0x10, 0x00, 0x65, 0x00, 0x00, 0x74, 0x08, 0xC3, 0x66,
  0x00, 0x73, 0x2C, 0x00, 0x73, 0x05, 0xCB, 0xC2,
  // "ġ" (U+0121)
  0x20, 0x67, 0x18, 0xA6, 0xBB, 0x93, 0x65, 0x09, 0x38, 0x30, 0x73, 0x65, 0x09, 0x31, 0xBB, 0xA3,
  0x38, 0x49, 0x22, 0xBB, 0x91,
  // "Ģ" (U+0122)
  0x04, 0xBB, 0xB0, 0x1C, 0x10, 0x00, 0x65, 0x00, 0x00, 0x74, 0x08, 0xC3, 0x66, 0x00, 0x73, 0x2C,
  0x00, 0x73, 0x05, 0xCB, 0xC2, 0x00, 0x01, 0x00, 0x00, 0x26, 0x00,
  // "ģ" (U+0123)
  0x20, 0x84, 0x01, 0x38, 0xA6, 0xBB, 0x93, 0x65, 0x09, 0x38, 0x30, 0x73, 0x65, 0x09, 0x31, 0xBB,
  0xA3, 0x38, 0x49, 0x22, 0xBB, 0x91,
  // "Ĥ" (U+0124)
  0x00, 0x61, 0x00, 0x05, 0x68, 0x00, 0x37, 0x00, 0x92, 0x37, 0x00, 0x92, 0x37, 0x00, 0x92, 0x3D,
  0xBB, 0xD2, 0x37, 0x00, 0x92, 0x37, 0x00, 0x92, 0x37, 0x00, 0x92,
  // "ĥ" (U+0125)
  0x10, 0x60, 0x13, 0x81, 0x56, 0x87, 0x30, 0x40, 0x64, 0x04, 0x06, 0x48, 0x24, 0xAB, 0xB2, 0x8A,
  0x54, 0x80, 0x74, 0x04, 0x60, 0x64, 0x04, 0x60, 0x64, 0x04, 0x60, 0x64,
  // "Ħ" (U+0126)
  0x37, 0x00, 0x92, 0xCD, 0xBB, 0xDB, 0x37, 0x00, 0x92, 0x3D, 0xBB, 0xD2, 0x37, 0x00, 0x92, 0x37,
  0x00, 0x92, 0x37, 0x00, 0x92,
  // "ħ" (U+0127)
  0x46, 0x00, 0x0B, 0xDB, 0x00, 0x4A, 0xBB, 0x04, 0x90, 0x73, 0x46, 0x06, 0x44, 0x60, 0x64, 0x46,
  0x06, 0x40,
  // "Ĩ" (U+0128)
  0xCF, 0xE1, 0x0B, 0x00, 0x0B, 0x00, 0x0B, 0x00, 0x0B, 0x00, 0x0B, 0x00, 0x6D, 0x30,
  // "ĩ" (U+0129)
  0x5B, 0xA1, 0x04, 0x60, 0x04, 0x60, 0x04, 0x60, 0x04, 0x60, 0x04, 0x60,
  // "Ī" (U+012A)
  0xFF, 0xC0, 0xB0, 0x0B, 0x00, 0xB0, 0x0B, 0x00, 0xB0, 0x6D, 0x30,
  // "ī" (U+012B)
  0x8B, 0x84, 0x60, 0x46, 0x04, 0x60, 0x46, 0x04, 0x60,
  // "Ĭ" (U+012C)
  0x00, 0x1C, 0xFA, 0x0B, 0x00, 0xB0, 0x0B, 0x00, 0xB0, 0x0B, 0x06, 0xD3,
  // "ĭ" (U+012D)
  0x00, 0x15, 0xB6, 0x46, 0x04, 0x60, 0x46, 0x04, 0x60, 0x46, 0x00,
  // "Į" (U+012E)
  0x7E, 0x30, 0xB0, 0x0B, 0x00, 0xB0, 0x0B, 0x00, 0xB0, 0x6E, 0x50, 0x80, 0x05, 0x50,
  // "į" (U+012F)
  0x33, 0x00, 0x46, 0x46, 0x46, 0x46, 0x57, 0x80, 0x55,
  // "İ" (U+0130)
  0x06, 0x07, 0xE3, 0x0B, 0x00, 0xB0, 0x0B, 0x00, 0xB0, 0x0B, 0x06, 0xD3,
  // "ı" (U+0131)
  0x46, 0x46, 0x46, 0x46, 0x46,
  // "Ĳ" (U+0132)
  0x7E, 0x34, 0x70, 0xB0, 0x47, 0x0B, 0x04, 0x70, 0xB0, 0x47, 0x0B, 0x04, 0x70, 0xB0, 0x47, 0x6D,
  0x35, 0x60, 0x07, 0xB1,
  // "ĳ" (U+0133)
  0x33, 0x33, 0x00, 0x00, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x00, 0x55,
  0x05, 0xC2,
  // "Ĵ" (U+0134)
  0x06, 0x15, 0x68, 0x04, 0x70, 0x47, 0x04, 0x70, 0x47, 0x04, 0x70, 0x47, 0x05, 0x67, 0xB1,
  // "ĵ" (U+0135)
  0x06, 0x15, 0x68, 0x00, 0x00, 0x46, 0x04, 0x60, 0x46, 0x04, 0x60, 0x46, 0x05, 0x55, 0xC2,
  // "Ķ" (U+0136)
  0x37, 0x05, 0x73, 0x71, 0xA0, 0x37, 0xA1, 0x03, 0xDC, 0x00, 0x38, 0x66, 0x03, 0x70, 0xB1, 0x37,
  0x03, 0x90, 0x01, 0x00, 0x00, 0x80, 0x00,
  // "ķ" (U+0137)
  0x45, 0x00, 0x45, 0x00, 0x45, 0x29, 0x46, 0xA0, 0x4D, 0x90, 0x46, 0x93, 0x45, 0x1B, 0x00, 0x10,
  0x03, 0x50,
  // "ĸ" (U+0138)
  0x46, 0x2A, 0x47, 0xB1, 0x4D, 0xA0, 0x47, 0x93, 0x46, 0x0B,
  // "Ĺ" (U+0139)
  0x06, 0x00, 0x63, 0x00, 0x37, 0x00, 0x37, 0x00, 0x37, 0x00, 0x37, 0x00, 0x37, 0x00, 0x37, 0x00,
  0x3D, 0xBB,
  // "ĺ" (U+013A)
  0x06, 0x63, 0x00, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46,
  // "Ļ" (U+013B)
  0x37, 0x00, 0x37, 0x00, 0x37, 0x00, 0x37, 0x00, 0x37, 0x00, 0x37, 0x00, 0x3D, 0xBB, 0x00, 0x10,
  0x00, 0x80,
  // "ļ" (U+013C)
  0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x01, 0x53,
  // "Ľ" (U+013D)
  0x37, 0x09, 0x37, 0x01, 0x37, 0x00, 0x37, 0x00, 0x37, 0x00, 0x37, 0x00, 0x3D, 0xBB,
  // "ľ" (U+013E)
  0x47, 0x74, 0x60, 0x46, 0x04, 0x60, 0x46, 0x04, 0x60, 0x46, 0x00,
  // "Ŀ" (U+013F)
  0x37, 0x00, 0x37, 0x00, 0x37, 0x00, 0x37, 0x60, 0x37, 0x00, 0x37, 0x00, 0x3D, 0xBB,
  // "ŀ" (U+0140)
  0x46, 0x46, 0x4C, 0x46, 0x46, 0x46, 0x46,
  // "Ł" (U+0141)
  0x37, 0x00, 0x37, 0x00, 0x37, 0x30, 0x3D, 0x50, 0x97, 0x00, 0x37, 0x00, 0x3D, 0xBB,
  // "ł" (U+0142)
  0x55, 0x55, 0x56, 0x7B, 0xA5, 0x55, 0x55,
  // "Ń" (U+0143)
  0x00, 0x06, 0x00, 0x00, 0x63, 0x00, 0x3D, 0x00, 0x54, 0x3C, 0x80, 0x54, 0x37, 0xD3, 0x54, 0x36,
  0x6C, 0x64, 0x36, 0x0D, 0xC4, 0x36, 0x05, 0xF4, 0x36, 0x00, 0xC4,
  // "ń" (U+0144)
  0x30, 0x63, 0x06, 0x03, 0x68, 0xA7, 0x49, 0xBB, 0x04, 0x80, 0x74, 0x46, 0x06, 0x44, 0x60, 0x64,
  0x46, 0x06, 0x40,
  // "Ņ" (U+0145)
  0x3D, 0x00, 0x54, 0x3C, 0x80, 0x54, 0x37, 0xD3, 0x54, 0x36, 0x6C, 0x64, 0x36, 0x0D, 0xC4, 0x36,
  0x05, 0xF4, 0x36, 0x00, 0xC4, 0x00, 0x01, 0x00, 0x00, 0x44, 0x00,
  // "ņ" (U+0146)
  0x49, 0xBB, 0x04, 0x80, 0x74, 0x46, 0x06, 0x44, 0x60, 0x64, 0x46, 0x06, 0x40, 0x01, 0x00, 0x00,
  0x80, 0x00,
  // "Ň" (U+0147)
  0x04, 0x04, 0x00, 0x01, 0xC5, 0x00, 0x3D, 0x00, 0x54, 0x3C, 0x80, 0x54, 0x37, 0xD3, 0x54, 0x36,
  0x6C, 0x64, 0x36, 0x0D, 0xC4, 0x36, 0x05, 0xF4, 0x36, 0x00, 0xC4,
  // "ň" (U+0148)
  0x04, 0x04, 0x00, 0x1C, 0x50, 0x00, 0x00, 0x04, 0x9B, 0xB0, 0x48, 0x07, 0x44, 0x60, 0x64, 0x46,
  0x06, 0x44, 0x60, 0x64,
  // "ŉ" (U+0149)
  0x92, 0x00, 0x00, 0x90, 0x00, 0x00, 0x14, 0x9B, 0xB0, 0x04, 0x80, 0x74, 0x04, 0x60, 0x64, 0x04,
  0x60, 0x64, 0x04, 0x60, 0x64,
  // "Ŋ" (U+014A)
  0x3D, 0x00, 0x54, 0x3F, 0x60, 0x54, 0x3C, 0xE0, 0x54, 0x36, 0xB7, 0x54, 0x36, 0x1D, 0x74, 0x36,
  0x06, 0xD4, 0x36, 0x00, 0xB4, 0x00, 0x00, 0x73, 0x00, 0x09, 0x90,
  // "ŋ" (U+014B)
  0x49, 0xBB, 0x04, 0x80, 0x74, 0x46, 0x06, 0x44, 0x60, 0x64, 0x46, 0x06, 0x40, 0x00, 0x64, 0x00,
  0x4C, 0x10,
  // "Ō" (U+014C)
  0x05, 0xFF, 0xF0, 0x2B, 0x00, 0x85, 0x65, 0x00, 0x1A, 0x74, 0x00, 0x0B, 0x65, 0x00, 0x1A, 0x2B,
  0x00, 0x85, 0x06, 0xCC, 0x80,
  // "ō" (U+014D)
  0x08, 0xB8, 0x00, 0xAB, 0x90, 0x65, 0x08, 0x38, 0x30, 0x55, 0x55, 0x08, 0x30, 0xAB, 0x90,
  // "Ŏ" (U+014E)
  0x00, 0x00, 0x10, 0x05, 0xFF, 0xF0, 0x2B, 0x00, 0x85, 0x65, 0x00, 0x1A, 0x74, 0x00, 0x0B, 0x65,
  0x00, 0x1A, 0x2B, 0x00, 0x85, 0x06, 0xCC, 0x80,
  // "ŏ" (U+014F)
  0x00, 0x01, 0x00, 0x5B, 0x60, 0x0A, 0xB9, 0x06, 0x50, 0x83, 0x83, 0x05, 0x55, 0x50, 0x83, 0x0A,
  0xB9, 0x00,
  // "Ő" (U+0150)
  0x00, 0x46, 0x90, 0x05, 0xDC, 0x90, 0x2B, 0x00, 0x85, 0x65, 0x00, 0x1A, 0x74, 0x00, 0x0B, 0x65,
  0x00, 0x1A, 0x2B, 0x00, 0x85, 0x06, 0xCC, 0x80,
  // "ő" (U+0151)
  0x04, 0x69, 0x00, 0x10, 0x00, 0x0A, 0xB9, 0x06, 0x50, 0x83, 0x83, 0x05, 0x55, 0x50, 0x83, 0x0A,
  0xB9, 0x00,
  // "Œ" (U+0152)
  0x06, 0xCC, 0xEB, 0xA2, 0xB0, 0x19, 0x00, 0x65, 0x01, 0x90, 0x07, 0x40, 0x1E, 0xB9, 0x65, 0x01,
  0x90, 0x02, 0xB0, 0x19, 0x00, 0x06, 0xCC, 0xEB, 0xA0,
  // "œ" (U+0153)
  0x0A, 0xB6, 0x8B, 0x70, 0x65, 0x09, 0x70, 0xB0, 0x83, 0x06, 0xCB, 0xC1, 0x55, 0x09, 0x70, 0x00,
  0x0A, 0xB7, 0x8B, 0xA0,
  // "Ŕ" (U+0154)
  0x00, 0x06, 0x00, 0x06, 0x30, 0x3D, 0xBB, 0x03, 0x70, 0x65, 0x37, 0x07, 0x43, 0xDC, 0x90, 0x37,
  0x1A, 0x03, 0x70, 0xA2, 0x37, 0x03, 0x90,
  // "ŕ" (U+0155)
  0x00, 0x60, 0x06, 0x30, 0x00, 0x00, 0x48, 0xB1, 0x4A, 0x00, 0x46, 0x00, 0x46, 0x00, 0x46, 0x00,
  // "Ŗ" (U+0156)
  0x3D, 0xBB, 0x03, 0x70, 0x65, 0x37, 0x07, 0x43, 0xDC, 0x90, 0x37, 0x1A, 0x03, 0x70, 0xA2, 0x37,
  0x03, 0x90, 0x01, 0x00, 0x00, 0x80, 0x00,
  // "ŗ" (U+0157)
  0x48, 0xB1, 0x4A, 0x00, 0x46, 0x00, 0x46, 0x00, 0x46, 0x00, 0x01, 0x00, 0x53, 0x00,
  // "Ř" (U+0158)
  0x04, 0x04, 0x00, 0x1C, 0x50, 0x3D, 0xBB, 0x03, 0x70, 0x65, 0x37, 0x07, 0x43, 0xDC, 0x90, 0x37,
  0x1A, 0x03, 0x70, 0xA2, 0x37, 0x03, 0x90,
  // "ř" (U+0159)
  0x40, 0x40, 0x1C, 0x50, 0x00, 0x00, 0x48, 0xB1, 0x4A, 0x00, 0x46, 0x00, 0x46, 0x00, 0x46, 0x00,
  // "Ś" (U+015A)
  0x00, 0x60, 0x06, 0x30, 0x1B, 0xB9, 0x64, 0x00, 0x58, 0x00, 0x07, 0xC3, 0x00, 0x1C, 0x00, 0x0B,
  0x7B, 0xB5,
  // "ś" (U+015B)
  0x00, 0x60, 0x06, 0x30, 0x00, 0x00, 0x4C, 0xB3, 0x73, 0x00, 0x07, 0x80, 0x00, 0x56, 0x6B, 0xB2,
  // "Ŝ" (U+015C)
  0x00, 0x61, 0x05, 0x68, 0x1B, 0xB9, 0x64, 0x00, 0x58, 0x00, 0x07, 0xC3, 0x00, 0x1C, 0x00, 0x0B,
  0x7B, 0xB5,
  // "ŝ" (U+015D)
  0x06, 0x10, 0x56, 0x80, 0x00, 0x00, 0x4C, 0xB3, 0x73, 0x00, 0x07, 0x80, 0x00, 0x56, 0x6B, 0xB2,
  // "Ş" (U+015E)
  0x1B, 0xB9, 0x64, 0x00, 0x58, 0x00, 0x07, 0xC3, 0x00, 0x1C, 0x00, 0x0B, 0x7D, 0xC5, 0x04, 0x60,
  0x07, 0x50,
  // "ş" (U+015F)
  0x4C, 0xB3, 0x73, 0x00, 0x07, 0x80, 0x00, 0x56, 0x6D, 0xC2, 0x04, 0x60, 0x07, 0x50,
  // "Š" (U+0160)
  0x04, 0x04, 0x01, 0xC5, 0x1B, 0xB9, 0x64, 0x00, 0x58, 0x00, 0x07, 0xC3, 0x00, 0x1C, 0x00, 0x0B,
  0x7B, 0xB5,
  // "š" (U+0161)
  0x40, 0x40, 0x1C, 0x50, 0x00, 0x00, 0x4C, 0xB3, 0x73, 0x00, 0x07, 0x80, 0x00, 0x56, 0x6B, 0xB2,
  // "Ţ" (U+0162)
  0xAC, 0xDB, 0x40, 0x29, 0x00, 0x02, 0x90, 0x00, 0x29, 0x00, 0x02, 0x90, 0x00, 0x29, 0x00, 0x03,
  0x90, 0x00, 0x46, 0x00, 0x07, 0x50, 0x00,
  // "ţ" (U+0163)
  0x16, 0x09, 0xD8, 0x46, 0x04, 0x60, 0x37, 0x01, 0xD8, 0x04, 0x60, 0x75,
  // "Ť" (U+0164)
  0x04, 0x04, 0x00, 0x1C, 0x50, 0xAC, 0xDB, 0x40, 0x29, 0x00, 0x02, 0x90, 0x00, 0x29, 0x00, 0x02,
  0x90, 0x00, 0x29, 0x00, 0x02, 0x90, 0x00,
  // "ť" (U+0165)
  0x01, 0x08, 0x26, 0x00, 0xAD, 0x80, 0x46, 0x00, 0x46, 0x00, 0x37, 0x00, 0x1C, 0x80,
  // "Ŧ" (U+0166)
  0xAC, 0xDB, 0x40, 0x29, 0x00, 0x02, 0x90, 0x04, 0xCD, 0x80, 0x02, 0x90, 0x00, 0x29, 0x00, 0x02,
  0x90, 0x00,
  // "ŧ" (U+0167)
  0x16, 0x09, 0xD8, 0x46, 0x0A, 0xD7, 0x47, 0x01, 0xC8,
  // "Ũ" (U+0168)
  0x4B, 0xBA, 0xA1, 0x46, 0x00, 0x91, 0x46, 0x00, 0x91, 0x46, 0x00, 0x91, 0x47, 0x00, 0x91, 0x1A,
  0x00, 0xB0, 0x06, 0xBC, 0x50,
  // "ũ" (U+0169)
  0x05, 0xBA, 0x15, 0x50, 0x64, 0x55, 0x06, 0x45, 0x50, 0x74, 0x56, 0x09, 0x41, 0xCB, 0x94,
  // "Ū" (U+016A)
  0x4E, 0xB8, 0x91, 0x46, 0x00, 0x91, 0x46, 0x00, 0x91, 0x46, 0x00, 0x91, 0x47, 0x00, 0x91, 0x1A,
  0x00, 0xB0, 0x06, 0xBC, 0x50,
  // "ū" (U+016B)
  0x08, 0xB8, 0x05, 0x50, 0x64, 0x55, 0x06, 0x45, 0x50, 0x74, 0x56, 0x09, 0x41, 0xCB, 0x94,
  // "Ŭ" (U+016C)
  0x00, 0x01, 0x00, 0x4B, 0xB6, 0x91, 0x46, 0x00, 0x91, 0x46, 0x00, 0x91, 0x46, 0x00, 0x91, 0x47,
  0x00, 0x91, 0x1A, 0x00, 0xB0, 0x06, 0xBC, 0x50,
  // "ŭ" (U+016D)
  0x00, 0x01, 0x00, 0x5B, 0x60, 0x55, 0x06, 0x45, 0x50, 0x64, 0x55, 0x07, 0x45, 0x60, 0x94, 0x1C,
  0xB9, 0x40,
  // "Ů" (U+016E)
  0x00, 0x47, 0x00, 0x46, 0x47, 0x91, 0x46, 0x00, 0x91, 0x46, 0x00, 0x91, 0x46, 0x00, 0x91, 0x47,
  0x00, 0x91, 0x1A, 0x00, 0xB0, 0x06, 0xBC, 0x50,
  // "ů" (U+016F)
  0x04, 0x70, 0x00, 0x47, 0x00, 0x55, 0x06, 0x45, 0x50, 0x64, 0x55, 0x07, 0x45, 0x60, 0x94, 0x1C,
  0xB9, 0x40,
  // "Ű" (U+0170)
  0x00, 0x46, 0x90, 0x46, 0x10, 0x91, 0x46, 0x00, 0x91, 0x46, 0x00, 0x91, 0x46, 0x00, 0x91, 0x47,
  0x00, 0x91, 0x1A, 0x00, 0xB0, 0x06, 0xBC, 0x50,
  // "ű" (U+0171)
  0x04, 0x69, 0x00, 0x10, 0x00, 0x55, 0x06, 0x45, 0x50, 0x64, 0x55, 0x07, 0x45, 0x60, 0x94, 0x1C,
  0xB9, 0x40,
  // "Ų" (U+0172)
  0x46, 0x00, 0x91, 0x46, 0x00, 0x91, 0x46, 0x00, 0x91, 0x46, 0x00, 0x91, 0x47, 0x00, 0x91, 0x1A,
  0x00, 0xA0, 0x06, 0xBD, 0x40, 0x00, 0x07, 0x00, 0x00, 0x09, 0x50,
  // "ų" (U+0173)
  0x55, 0x06, 0x45, 0x50, 0x64, 0x55, 0x07, 0x45, 0x60, 0x94, 0x1C, 0xBA, 0x50, 0x00, 0x80, 0x00,
  0x05, 0x50,
  // "Ŵ" (U+0174)
  0x00, 0x06, 0x10, 0x00, 0x00, 0x56, 0x80, 0x00, 0xB0, 0x0C, 0x20, 0x83, 0x92, 0x0D, 0x60, 0xA0,
  0x55, 0x47, 0xA0, 0xB0, 0x28, 0x72, 0xA2, 0x80, 0x0A, 0xA0, 0x87, 0x50, 0x0A, 0x90, 0x4D, 0x20,
  0x07, 0x70, 0x0D, 0x00,
  // "ŵ" (U+0175)
  0x20, 0x60, 0x14, 0x81, 0x56, 0x87, 0x38, 0xB1, 0xB0, 0x5A, 0x09, 0x18, 0x29, 0xA0, 0xA0, 0x55,
  0x97, 0x49, 0x01, 0xB7, 0x3B, 0x52, 0x83, 0xD3, 0x0E, 0x21,
  // "Ŷ" (U+0176)
  0x00, 0x61, 0x00, 0x56, 0x80, 0xB1, 0x08, 0x45, 0x81, 0xC0, 0x0D, 0xA6, 0x00, 0x7E, 0x00, 0x01,
  0xA0, 0x00, 0x19, 0x00, 0x01, 0x90, 0x00,
  // "ŷ" (U+0177)
  0x06, 0x10, 0x56, 0x80, 0x00, 0x00, 0xB0, 0x0B, 0x74, 0x28, 0x19, 0x73, 0x0A, 0xA0, 0x06, 0x80,
  0x08, 0x30, 0xA9, 0x00,
  // "Ÿ" (U+0178)
  0x06, 0x23, 0x0B, 0x10, 0x84, 0x58, 0x1C, 0x00, 0xDA, 0x60, 0x07, 0xE0, 0x00, 0x1A, 0x00, 0x01,
  0x90, 0x00, 0x19, 0x00,
  // "Ź" (U+0179)
  0x00, 0x06, 0x00, 0x06, 0x30, 0x6B, 0xBE, 0x20, 0x01, 0xA0, 0x00, 0x93, 0x00, 0x29, 0x00, 0x0A,
  0x20, 0x03, 0x80, 0x00, 0xAC, 0xBB, 0x30,
  // "ź" (U+017A)
  0x00, 0x60, 0x06, 0x30, 0x00, 0x00, 0x6B, 0xD5, 0x00, 0xA0, 0x07, 0x30, 0x29, 0x00, 0x9C, 0xB5,
  // "Ż" (U+017B)
  0x00, 0x60, 0x06, 0xBB, 0xE2, 0x00, 0x1A, 0x00, 0x09, 0x30, 0x02, 0x90, 0x00, 0xA2, 0x00, 0x38,
  0x00, 0x0A, 0xCB, 0xB3,
  // "ż" (U+017C)
  0x06, 0x00, 0x00, 0x00, 0x6B, 0xD5, 0x00, 0xA0, 0x07, 0x30, 0x29, 0x00, 0x9C, 0xB5,
  // "Ž" (U+017D)
  0x04, 0x04, 0x00, 0x1C, 0x50, 0x6B, 0xBE, 0x20, 0x01, 0xA0, 0x00, 0x93, 0x00, 0x29, 0x00, 0x0A,
  0x20, 0x03, 0x80, 0x00, 0xAC, 0xBB, 0x30,
  // "ž" (U+017E)
  0x40, 0x40, 0x1C, 0x50, 0x00, 0x00, 0x6B, 0xD5, 0x00, 0xA0, 0x07, 0x30, 0x29, 0x00, 0x9C, 0xB5,
  // "ſ" (U+017F)
  0x1C, 0x94, 0x60, 0x46, 0x04, 0x60, 0x46, 0x04, 0x60, 0x46, 0x00,
  // "Ω" (U+03A9)
  0x06, 0xCC, 0x90, 0x2A, 0x00, 0x76, 0x65, 0x00, 0x1A, 0x74, 0x00, 0x0B, 0x47, 0x00, 0x38, 0x0A,
  0x00, 0x92, 0x8D, 0x84, 0xEB,
  // "μ" (U+03BC)
  0x46, 0x06, 0x44, 0x60, 0x64, 0x46, 0x06, 0x44, 0x70, 0x94, 0x4D, 0xB9, 0x44, 0x50, 0x00, 0x46,
  0x00, 0x00,
  // "π" (U+03C0)
  0x9E, 0xBD, 0xC0, 0xA0, 0x82, 0x0A, 0x08, 0x20, 0xA0, 0x72, 0x0A, 0x05, 0xB0,
  // "–" (U+2013)
  0x8B, 0xB8,
  // "—" (U+2014)
  0x8B, 0xBB, 0xBB, 0xB8,
  // "€" (U+20AC)
  0x02, 0xBC, 0x30, 0xA1, 0x00, 0x0A, 0x00, 0x08, 0xC9, 0x40, 0x8C, 0x92, 0x00, 0xB0, 0x00, 0x04,
  0xCB, 0x30,
  // "₿" (U+20BF)
  0x06, 0x61, 0x03, 0xDC, 0x80, 0x37, 0x0B, 0x13, 0x70, 0xB0, 0x3D, 0xC9, 0x03, 0x70, 0x92, 0x37,
  0x09, 0x33, 0xDC, 0xA0, 0x06, 0x61, 0x00,
  // "‘" (U+2018)
  0x63, 0xB0, 0x10,
  // "’" (U+2019)
  0x92, 0x90, 0x10,
  // "‚" (U+201A)
  0x92, 0x90, 0x10,
  // "‛" (U+201B)
  0xB0, 0x72,
  // "“" (U+201C)
  0x63, 0x9B, 0x47, 0x11, 0x00,
  // "”" (U+201D)
  0x94, 0xA9, 0x45, 0x11, 0x00,
  // "„" (U+201E)
  0x94, 0xA9, 0x45, 0x11, 0x00,
  // "‟" (U+201F)
  0xB5, 0x77, 0x39, 0x00, 0x10,
  // "†" (U+2020)
  0x05, 0x50, 0x15, 0x51, 0x49, 0x94, 0x03, 0x40, 0x04, 0x40, 0x05, 0x50, 0x05, 0x60,
  // "‡" (U+2021)
  0x05, 0x50, 0x26, 0x73, 0x37, 0x83, 0x04, 0x60, 0x26, 0x72, 0x37, 0x83, 0x04, 0x50,
  // "•" (U+2022)
  0x4F, 0x43, 0xE3,
  // "…" (U+2026)
  0x34, 0x34, 0x34,
  // "‰" (U+2030)
  0x3C, 0x40, 0x80, 0x00, 0x08, 0x19, 0x17, 0x00, 0x00, 0x80, 0x97, 0x10, 0x00, 0x07, 0x19, 0x89,
  0xA0, 0xB7, 0x2B, 0xA3, 0x86, 0x74, 0x90, 0x09, 0x18, 0x57, 0x49, 0x05, 0x40, 0xAB, 0x1B, 0x90,
  // "‹" (U+2039)
  0x06, 0x65, 0x38, 0x04,
  // "›" (U+203A)
  0x51, 0x0A, 0x29, 0x30,
  // "⁄" (U+2044)
  0x30, 0x04, 0x30, 0x93, 0x00, 0x43, 0x09, 0x30, 0x40, 0x53, 0x09, 0x30, 0x40, 0x53,
  // "™" (U+2122)
  0xBE, 0x97, 0x38, 0x17, 0x69, 0x78, 0x17, 0x68, 0x78, 0x02, 0x21, 0x23,
  // "⅒" (U+2152)
  0x30, 0x04, 0x58, 0x15, 0x09, 0x58, 0x24, 0xA4, 0x46, 0x8A, 0x18, 0x90, 0x50, 0x48, 0x20, 0xD5,
  0x4A, 0x09, 0x08, 0x09, 0x28, 0x58, 0x08, 0x08, 0x45, 0x28, 0x38, 0x04, 0x82,
  // "ﬁ" (U+FB01)
  0x0A, 0xB3, 0x31, 0x90, 0x00, 0x9D, 0x74, 0x61, 0x90, 0x46, 0x19, 0x04, 0x61, 0x90, 0x46, 0x19,
  0x04, 0x60,
  // "ﬂ" (U+FB02)
  0x0A, 0xB5, 0x61, 0x90, 0x46, 0x9D, 0x74, 0x61, 0x90, 0x46, 0x19, 0x04, 0x61, 0x90, 0x46, 0x19,
  0x04, 0x60,
};

const Font& font_NotoSans_Regular_8() {
  static SmoothFont font(font_NotoSans_Regular_8_data);
  return font;
}

}  // namespace roo_display
