#include "10.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSans-Regular (Noto Sans Regular)
// Generated on Wed Nov 19 19:11:00 CET 2025
static const uint8_t font_NotoSans_Regular_10_data[] PROGMEM = {
  
  // Header
  0x01, 0x02, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x04, 0xD4,
  0xFE, 0xFE, 0x0B, 0x0B, 0x08, 0xFD, 0x03, 0x01, 0x0C, 0x04, 0x03, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x40, 0x01, 0x01, 0x08, 0x03, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x40, 0x06, 0x03, 0x08, 0x04, 0x00, 0x08, // """ (U+0022)
  0x00, 0x23, 0x40, 0x01, 0x06, 0x08, 0x06, 0x00, 0x0E, // "#" (U+0023)
  0x00, 0x24, 0x40, 0x00, 0x05, 0x08, 0x06, 0x00, 0x2A, // "$" (U+0024)
  0x00, 0x25, 0x40, 0x01, 0x07, 0x08, 0x08, 0x00, 0x45, // "%" (U+0025)
  0x00, 0x26, 0x40, 0x01, 0x06, 0x08, 0x07, 0x00, 0x65, // "&" (U+0026)
  0x00, 0x27, 0x40, 0x06, 0x01, 0x08, 0x02, 0x00, 0x81, // "'" (U+0027)
  0x00, 0x28, 0x40, 0xFF, 0x02, 0x08, 0x03, 0x00, 0x84, // "(" (U+0028)
  0x00, 0x29, 0x40, 0xFF, 0x02, 0x08, 0x03, 0x00, 0x93, // ")" (U+0029)
  0x00, 0x2A, 0x40, 0x04, 0x04, 0x08, 0x06, 0x00, 0xA2, // "*" (U+002A)
  0x00, 0x2B, 0x40, 0x02, 0x05, 0x06, 0x06, 0x00, 0xAF, // "+" (U+002B)
  0x00, 0x2C, 0x40, 0x00, 0x01, 0x02, 0x03, 0x00, 0xBE, // "," (U+002C)
  0x00, 0x2D, 0x40, 0x03, 0x02, 0x03, 0x03, 0x00, 0xC1, // "-" (U+002D)
  0x00, 0x2E, 0x40, 0x01, 0x01, 0x02, 0x03, 0x00, 0xC3, // "." (U+002E)
  0x00, 0x2F, 0x40, 0x01, 0x03, 0x08, 0x04, 0x00, 0xC5, // "/" (U+002F)
  0x00, 0x30, 0x40, 0x01, 0x05, 0x08, 0x06, 0x00, 0xD5, // "0" (U+0030)
  0x00, 0x31, 0x41, 0x01, 0x03, 0x08, 0x06, 0x00, 0xED, // "1" (U+0031)
  0x00, 0x32, 0x40, 0x01, 0x05, 0x08, 0x06, 0x00, 0xF9, // "2" (U+0032)
  0x00, 0x33, 0x40, 0x01, 0x05, 0x08, 0x06, 0x01, 0x11, // "3" (U+0033)
  0x00, 0x34, 0x40, 0x01, 0x05, 0x08, 0x06, 0x01, 0x29, // "4" (U+0034)
  0x00, 0x35, 0x00, 0x01, 0x05, 0x08, 0x06, 0x01, 0x41, // "5" (U+0035)
  0x00, 0x36, 0x40, 0x01, 0x05, 0x08, 0x06, 0x01, 0x58, // "6" (U+0036)
  0x00, 0x37, 0x00, 0x01, 0x05, 0x08, 0x06, 0x01, 0x70, // "7" (U+0037)
  0x00, 0x38, 0x40, 0x01, 0x05, 0x08, 0x06, 0x01, 0x85, // "8" (U+0038)
  0x00, 0x39, 0x40, 0x01, 0x05, 0x08, 0x06, 0x01, 0x9D, // "9" (U+0039)
  0x00, 0x3A, 0x40, 0x01, 0x01, 0x06, 0x03, 0x01, 0xB5, // ":" (U+003A)
  0x00, 0x3B, 0x40, 0xFF, 0x01, 0x06, 0x03, 0x01, 0xBB, // ";" (U+003B)
  0x00, 0x3C, 0x40, 0x02, 0x05, 0x06, 0x06, 0x01, 0xC3, // "<" (U+003C)
  0x00, 0x3D, 0x40, 0x03, 0x05, 0x05, 0x06, 0x01, 0xD2, // "=" (U+003D)
  0x00, 0x3E, 0x00, 0x02, 0x05, 0x06, 0x06, 0x01, 0xDB, // ">" (U+003E)
  0x00, 0x3F, 0x40, 0x01, 0x03, 0x08, 0x04, 0x01, 0xE9, // "?" (U+003F)
  0x00, 0x40, 0x40, 0x00, 0x08, 0x08, 0x09, 0x01, 0xF9, // "@" (U+0040)
  0x00, 0x41, 0x40, 0x01, 0x06, 0x08, 0x06, 0x02, 0x22, // "A" (U+0041)
  0x00, 0x42, 0x41, 0x01, 0x05, 0x08, 0x07, 0x02, 0x3E, // "B" (U+0042)
  0x00, 0x43, 0x00, 0x01, 0x05, 0x08, 0x06, 0x02, 0x52, // "C" (U+0043)
  0x00, 0x44, 0x41, 0x01, 0x06, 0x08, 0x07, 0x02, 0x68, // "D" (U+0044)
  0x00, 0x45, 0x41, 0x01, 0x04, 0x08, 0x06, 0x02, 0x80, // "E" (U+0045)
  0x00, 0x46, 0x01, 0x01, 0x04, 0x08, 0x05, 0x02, 0x90, // "F" (U+0046)
  0x00, 0x47, 0x40, 0x01, 0x06, 0x08, 0x07, 0x02, 0x9E, // "G" (U+0047)
  0x00, 0x48, 0x41, 0x01, 0x06, 0x08, 0x07, 0x02, 0xBA, // "H" (U+0048)
  0x00, 0x49, 0x40, 0x01, 0x02, 0x08, 0x03, 0x02, 0xD2, // "I" (U+0049)
  0x00, 0x4A, 0xBF, 0xFF, 0x01, 0x08, 0x03, 0x02, 0xDE, // "J" (U+004A)
  0x00, 0x4B, 0x41, 0x01, 0x05, 0x08, 0x06, 0x02, 0xED, // "K" (U+004B)
  0x00, 0x4C, 0x01, 0x01, 0x04, 0x08, 0x05, 0x03, 0x01, // "L" (U+004C)
  0x00, 0x4D, 0x41, 0x01, 0x08, 0x08, 0x09, 0x03, 0x0E, // "M" (U+004D)
  0x00, 0x4E, 0x41, 0x01, 0x06, 0x08, 0x08, 0x03, 0x2E, // "N" (U+004E)
  0x00, 0x4F, 0x40, 0x01, 0x07, 0x08, 0x08, 0x03, 0x46, // "O" (U+004F)
  0x00, 0x50, 0x01, 0x01, 0x05, 0x08, 0x06, 0x03, 0x66, // "P" (U+0050)
  0x00, 0x51, 0x00, 0xFF, 0x07, 0x08, 0x08, 0x03, 0x79, // "Q" (U+0051)
  0x00, 0x52, 0x41, 0x01, 0x05, 0x08, 0x06, 0x03, 0x9E, // "R" (U+0052)
  0x00, 0x53, 0x40, 0x01, 0x04, 0x08, 0x05, 0x03, 0xB2, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x05, 0x08, 0x06, 0x03, 0xC6, // "T" (U+0054)
  0x00, 0x55, 0x40, 0x01, 0x06, 0x08, 0x07, 0x03, 0xDC, // "U" (U+0055)
  0x00, 0x56, 0x40, 0x01, 0x05, 0x08, 0x06, 0x03, 0xF8, // "V" (U+0056)
  0x00, 0x57, 0x40, 0x01, 0x08, 0x08, 0x09, 0x04, 0x10, // "W" (U+0057)
  0x00, 0x58, 0x40, 0x01, 0x05, 0x08, 0x06, 0x04, 0x34, // "X" (U+0058)
  0x00, 0x59, 0x40, 0x01, 0x05, 0x08, 0x06, 0x04, 0x4C, // "Y" (U+0059)
  0x00, 0x5A, 0x40, 0x01, 0x05, 0x08, 0x06, 0x04, 0x64, // "Z" (U+005A)
  0x00, 0x5B, 0x40, 0xFF, 0x02, 0x08, 0x03, 0x04, 0x7C, // "[" (U+005B)
  0x00, 0x5C, 0x40, 0x01, 0x03, 0x08, 0x04, 0x04, 0x8B, // "\" (U+005C)
  0x00, 0x5D, 0x40, 0xFF, 0x02, 0x08, 0x03, 0x04, 0x9B, // "]" (U+005D)
  0x00, 0x5E, 0x40, 0x04, 0x05, 0x08, 0x06, 0x04, 0xAA, // "^" (U+005E)
  0x00, 0x5F, 0x40, 0xFF, 0x04, 0xFF, 0x04, 0x04, 0xB9, // "_" (U+005F)
  0x00, 0x60, 0x40, 0x08, 0x02, 0x09, 0x03, 0x04, 0xBC, // "`" (U+0060)
  0x00, 0x61, 0x40, 0x01, 0x04, 0x06, 0x06, 0x04, 0xBF, // "a" (U+0061)
  0x00, 0x62, 0x40, 0x01, 0x05, 0x08, 0x06, 0x04, 0xCE, // "b" (U+0062)
  0x00, 0x63, 0x40, 0x01, 0x04, 0x06, 0x05, 0x04, 0xE6, // "c" (U+0063)
  0x00, 0x64, 0x40, 0x01, 0x05, 0x08, 0x06, 0x04, 0xF5, // "d" (U+0064)
  0x00, 0x65, 0x40, 0x01, 0x05, 0x06, 0x06, 0x05, 0x0D, // "e" (U+0065)
  0x00, 0x66, 0x00, 0x01, 0x03, 0x08, 0x03, 0x05, 0x1F, // "f" (U+0066)
  0x00, 0x67, 0x40, 0xFE, 0x05, 0x06, 0x06, 0x05, 0x2E, // "g" (U+0067)
  0x00, 0x68, 0x40, 0x01, 0x05, 0x08, 0x06, 0x05, 0x49, // "h" (U+0068)
  0x00, 0x69, 0x40, 0x01, 0x01, 0x08, 0x03, 0x05, 0x61, // "i" (U+0069)
  0x00, 0x6A, 0xBF, 0xFE, 0x01, 0x08, 0x03, 0x05, 0x69, // "j" (U+006A)
  0x00, 0x6B, 0x40, 0x01, 0x04, 0x08, 0x05, 0x05, 0x7A, // "k" (U+006B)
  0x00, 0x6C, 0x40, 0x01, 0x01, 0x08, 0x03, 0x05, 0x8E, // "l" (U+006C)
  0x00, 0x6D, 0x40, 0x01, 0x08, 0x06, 0x09, 0x05, 0x96, // "m" (U+006D)
  0x00, 0x6E, 0x40, 0x01, 0x05, 0x06, 0x06, 0x05, 0xB1, // "n" (U+006E)
  0x00, 0x6F, 0x40, 0x01, 0x05, 0x06, 0x06, 0x05, 0xC3, // "o" (U+006F)
  0x00, 0x70, 0x40, 0xFE, 0x05, 0x06, 0x06, 0x05, 0xD5, // "p" (U+0070)
  0x00, 0x71, 0x40, 0xFE, 0x05, 0x06, 0x06, 0x05, 0xF0, // "q" (U+0071)
  0x00, 0x72, 0x40, 0x01, 0x03, 0x06, 0x04, 0x06, 0x0B, // "r" (U+0072)
  0x00, 0x73, 0x40, 0x01, 0x04, 0x06, 0x05, 0x06, 0x17, // "s" (U+0073)
  0x00, 0x74, 0x40, 0x01, 0x03, 0x08, 0x04, 0x06, 0x26, // "t" (U+0074)
  0x00, 0x75, 0x40, 0x01, 0x05, 0x06, 0x06, 0x06, 0x36, // "u" (U+0075)
  0x00, 0x76, 0x40, 0x01, 0x04, 0x06, 0x05, 0x06, 0x48, // "v" (U+0076)
  0x00, 0x77, 0x40, 0x01, 0x07, 0x06, 0x08, 0x06, 0x57, // "w" (U+0077)
  0x00, 0x78, 0x40, 0x01, 0x04, 0x06, 0x05, 0x06, 0x6F, // "x" (U+0078)
  0x00, 0x79, 0x40, 0xFE, 0x04, 0x06, 0x05, 0x06, 0x7E, // "y" (U+0079)
  0x00, 0x7A, 0x40, 0x01, 0x04, 0x06, 0x05, 0x06, 0x95, // "z" (U+007A)
  0x00, 0x7B, 0x40, 0xFF, 0x03, 0x08, 0x04, 0x06, 0xA4, // "{" (U+007B)
  0x00, 0x7C, 0x42, 0xFE, 0x03, 0x08, 0x06, 0x06, 0xB8, // "|" (U+007C)
  0x00, 0x7D, 0x40, 0xFF, 0x03, 0x08, 0x04, 0x06, 0xC3, // "}" (U+007D)
  0x00, 0x7E, 0x40, 0x04, 0x05, 0x05, 0x06, 0x06, 0xD7, // "~" (U+007E)
  0x00, 0xA1, 0x40, 0xFF, 0x01, 0x06, 0x03, 0x06, 0xDD, // "¡" (U+00A1)
  0x00, 0xA2, 0x41, 0x01, 0x04, 0x08, 0x06, 0x06, 0xE5, // "¢" (U+00A2)
  0x00, 0xA3, 0x40, 0x01, 0x05, 0x08, 0x06, 0x06, 0xF5, // "£" (U+00A3)
  0x00, 0xA4, 0x40, 0x02, 0x04, 0x07, 0x06, 0x07, 0x0D, // "¤" (U+00A4)
  0x00, 0xA5, 0x40, 0x01, 0x05, 0x08, 0x06, 0x07, 0x1C, // "¥" (U+00A5)
  0x00, 0xA6, 0x42, 0xFE, 0x03, 0x08, 0x06, 0x07, 0x34, // "¦" (U+00A6)
  0x00, 0xA7, 0x40, 0x01, 0x04, 0x08, 0x05, 0x07, 0x3F, // "§" (U+00A7)
  0x00, 0xA8, 0x41, 0x08, 0x04, 0x08, 0x06, 0x07, 0x53, // "¨" (U+00A8)
  0x00, 0xA9, 0x40, 0x01, 0x07, 0x08, 0x08, 0x07, 0x55, // "©" (U+00A9)
  0x00, 0xAA, 0x40, 0x05, 0x03, 0x07, 0x04, 0x07, 0x75, // "ª" (U+00AA)
  0x00, 0xAB, 0x40, 0x01, 0x04, 0x05, 0x05, 0x07, 0x7B, // "«" (U+00AB)
  0x00, 0xAC, 0x40, 0x02, 0x05, 0x04, 0x06, 0x07, 0x88, // "¬" (U+00AC)
  0x00, 0xAE, 0x40, 0x01, 0x07, 0x08, 0x08, 0x07, 0x91, // "®" (U+00AE)
  0x00, 0xAF, 0x00, 0x09, 0x04, 0x09, 0x05, 0x07, 0xB1, // "¯" (U+00AF)
  0x00, 0xB0, 0x40, 0x05, 0x03, 0x08, 0x04, 0x07, 0xB3, // "°" (U+00B0)
  0x00, 0xB1, 0x40, 0x01, 0x05, 0x06, 0x06, 0x07, 0xBB, // "±" (U+00B1)
  0x00, 0xB2, 0x40, 0x05, 0x02, 0x09, 0x04, 0x07, 0xCD, // "²" (U+00B2)
  0x00, 0xB3, 0x40, 0x05, 0x03, 0x09, 0x04, 0x07, 0xD5, // "³" (U+00B3)
  0x00, 0xB4, 0x40, 0x08, 0x02, 0x09, 0x03, 0x07, 0xDF, // "´" (U+00B4)
  0x00, 0xB5, 0x40, 0xFE, 0x05, 0x06, 0x06, 0x07, 0xE2, // "µ" (U+00B5)
  0x00, 0xB6, 0x40, 0xFF, 0x05, 0x08, 0x07, 0x07, 0xFD, // "¶" (U+00B6)
  0x00, 0xB7, 0x40, 0x04, 0x01, 0x05, 0x03, 0x08, 0x1B, // "·" (U+00B7)
  0x00, 0xB8, 0x40, 0xFE, 0x01, 0x00, 0x02, 0x08, 0x1D, // "¸" (U+00B8)
  0x00, 0xB9, 0x40, 0x05, 0x02, 0x08, 0x04, 0x08, 0x20, // "¹" (U+00B9)
  0x00, 0xBA, 0x40, 0x04, 0x03, 0x07, 0x04, 0x08, 0x26, // "º" (U+00BA)
  0x00, 0xBB, 0x40, 0x01, 0x04, 0x05, 0x05, 0x08, 0x2E, // "»" (U+00BB)
  0x00, 0xBC, 0x40, 0x01, 0x07, 0x08, 0x07, 0x08, 0x3B, // "¼" (U+00BC)
  0x00, 0xBD, 0x40, 0x01, 0x07, 0x08, 0x08, 0x08, 0x5B, // "½" (U+00BD)
  0x00, 0xBE, 0x40, 0x01, 0x07, 0x08, 0x08, 0x08, 0x7B, // "¾" (U+00BE)
  0x00, 0xBF, 0x40, 0xFE, 0x03, 0x05, 0x04, 0x08, 0x9B, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x06, 0x0B, 0x06, 0x08, 0xAB, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x06, 0x0B, 0x06, 0x08, 0xCD, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x01, 0x06, 0x0B, 0x06, 0x08, 0xEF, // "Â" (U+00C2)
  0x00, 0xC3, 0x00, 0x01, 0x06, 0x0B, 0x06, 0x09, 0x12, // "Ã" (U+00C3)
  0x00, 0xC4, 0x00, 0x01, 0x06, 0x0A, 0x06, 0x09, 0x36, // "Ä" (U+00C4)
  0x00, 0xC5, 0x40, 0x01, 0x06, 0x0A, 0x06, 0x09, 0x57, // "Å" (U+00C5)
  0x00, 0xC6, 0x40, 0x01, 0x08, 0x08, 0x09, 0x09, 0x7A, // "Æ" (U+00C6)
  0x00, 0xC7, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x09, 0x9E, // "Ç" (U+00C7)
  0x00, 0xC8, 0x01, 0x01, 0x04, 0x0B, 0x06, 0x09, 0xBC, // "È" (U+00C8)
  0x00, 0xC9, 0x01, 0x01, 0x04, 0x0B, 0x06, 0x09, 0xD1, // "É" (U+00C9)
  0x00, 0xCA, 0x01, 0x01, 0x04, 0x0B, 0x06, 0x09, 0xE5, // "Ê" (U+00CA)
  0x00, 0xCB, 0x01, 0x01, 0x04, 0x0A, 0x06, 0x09, 0xFA, // "Ë" (U+00CB)
  0x00, 0xCC, 0x40, 0x01, 0x02, 0x0B, 0x03, 0x0A, 0x0D, // "Ì" (U+00CC)
  0x00, 0xCD, 0x40, 0x01, 0x03, 0x0B, 0x03, 0x0A, 0x1E, // "Í" (U+00CD)
  0x00, 0xCE, 0x40, 0x01, 0x03, 0x0B, 0x03, 0x0A, 0x34, // "Î" (U+00CE)
  0x00, 0xCF, 0x40, 0x01, 0x03, 0x0A, 0x03, 0x0A, 0x4A, // "Ï" (U+00CF)
  0x00, 0xD0, 0x40, 0x01, 0x06, 0x08, 0x07, 0x0A, 0x5E, // "Ð" (U+00D0)
  0x00, 0xD1, 0x41, 0x01, 0x06, 0x0B, 0x08, 0x0A, 0x7A, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x00, 0x01, 0x07, 0x0B, 0x08, 0x0A, 0x9B, // "Ò" (U+00D2)
  0x00, 0xD3, 0x00, 0x01, 0x07, 0x0B, 0x08, 0x0A, 0xC1, // "Ó" (U+00D3)
  0x00, 0xD4, 0x00, 0x01, 0x07, 0x0B, 0x08, 0x0A, 0xE6, // "Ô" (U+00D4)
  0x00, 0xD5, 0x00, 0x01, 0x07, 0x0B, 0x08, 0x0B, 0x0D, // "Õ" (U+00D5)
  0x00, 0xD6, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x0B, 0x35, // "Ö" (U+00D6)
  0x00, 0xD7, 0x40, 0x02, 0x04, 0x06, 0x06, 0x0B, 0x59, // "×" (U+00D7)
  0x00, 0xD8, 0x40, 0x00, 0x07, 0x08, 0x08, 0x0B, 0x66, // "Ø" (U+00D8)
  0x00, 0xD9, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x0B, 0x8A, // "Ù" (U+00D9)
  0x00, 0xDA, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x0B, 0xAE, // "Ú" (U+00DA)
  0x00, 0xDB, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x0B, 0xD1, // "Û" (U+00DB)
  0x00, 0xDC, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x0B, 0xF6, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x0C, 0x18, // "Ý" (U+00DD)
  0x00, 0xDE, 0x01, 0x01, 0x05, 0x08, 0x06, 0x0C, 0x36, // "Þ" (U+00DE)
  0x00, 0xDF, 0x40, 0x01, 0x05, 0x08, 0x06, 0x0C, 0x49, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x01, 0x04, 0x09, 0x06, 0x0C, 0x61, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x04, 0x09, 0x06, 0x0C, 0x77, // "á" (U+00E1)
  0x00, 0xE2, 0x40, 0x01, 0x04, 0x09, 0x06, 0x0C, 0x8C, // "â" (U+00E2)
  0x00, 0xE3, 0x40, 0x01, 0x04, 0x09, 0x06, 0x0C, 0xA3, // "ã" (U+00E3)
  0x00, 0xE4, 0x40, 0x01, 0x04, 0x08, 0x06, 0x0C, 0xBA, // "ä" (U+00E4)
  0x00, 0xE5, 0x40, 0x01, 0x04, 0x09, 0x06, 0x0C, 0xCE, // "å" (U+00E5)
  0x00, 0xE6, 0x40, 0x01, 0x08, 0x06, 0x09, 0x0C, 0xE5, // "æ" (U+00E6)
  0x00, 0xE7, 0x40, 0xFE, 0x04, 0x06, 0x05, 0x0D, 0x00, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x01, 0x05, 0x09, 0x06, 0x0D, 0x17, // "è" (U+00E8)
  0x00, 0xE9, 0x00, 0x01, 0x05, 0x09, 0x06, 0x0D, 0x31, // "é" (U+00E9)
  0x00, 0xEA, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0D, 0x4A, // "ê" (U+00EA)
  0x00, 0xEB, 0x40, 0x01, 0x05, 0x08, 0x06, 0x0D, 0x65, // "ë" (U+00EB)
  0x00, 0xEC, 0x40, 0x01, 0x02, 0x09, 0x03, 0x0D, 0x7D, // "ì" (U+00EC)
  0x00, 0xED, 0x40, 0x01, 0x02, 0x09, 0x03, 0x0D, 0x8B, // "í" (U+00ED)
  0x00, 0xEE, 0xBF, 0x01, 0x02, 0x09, 0x03, 0x0D, 0x99, // "î" (U+00EE)
  0x00, 0xEF, 0xBF, 0x01, 0x02, 0x08, 0x03, 0x0D, 0xAB, // "ï" (U+00EF)
  0x00, 0xF0, 0x40, 0x01, 0x05, 0x08, 0x06, 0x0D, 0xBB, // "ð" (U+00F0)
  0x00, 0xF1, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0D, 0xD3, // "ñ" (U+00F1)
  0x00, 0xF2, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0D, 0xEE, // "ò" (U+00F2)
  0x00, 0xF3, 0x00, 0x01, 0x05, 0x09, 0x06, 0x0E, 0x09, // "ó" (U+00F3)
  0x00, 0xF4, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0E, 0x23, // "ô" (U+00F4)
  0x00, 0xF5, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0E, 0x3E, // "õ" (U+00F5)
  0x00, 0xF6, 0x40, 0x01, 0x05, 0x08, 0x06, 0x0E, 0x59, // "ö" (U+00F6)
  0x00, 0xF7, 0x00, 0x02, 0x05, 0x06, 0x06, 0x0E, 0x71, // "÷" (U+00F7)
  0x00, 0xF8, 0x40, 0x00, 0x05, 0x06, 0x06, 0x0E, 0x7C, // "ø" (U+00F8)
  0x00, 0xF9, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0E, 0x91, // "ù" (U+00F9)
  0x00, 0xFA, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0E, 0xAC, // "ú" (U+00FA)
  0x00, 0xFB, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0E, 0xC7, // "û" (U+00FB)
  0x00, 0xFC, 0x40, 0x01, 0x05, 0x08, 0x06, 0x0E, 0xE2, // "ü" (U+00FC)
  0x00, 0xFD, 0x40, 0xFE, 0x04, 0x09, 0x05, 0x0E, 0xFA, // "ý" (U+00FD)
  0x00, 0xFE, 0x40, 0xFE, 0x05, 0x08, 0x06, 0x0F, 0x18, // "þ" (U+00FE)
  0x00, 0xFF, 0x40, 0xFE, 0x04, 0x08, 0x05, 0x0F, 0x39, // "ÿ" (U+00FF)
  0x01, 0x00, 0x00, 0x01, 0x06, 0x0A, 0x06, 0x0F, 0x55, // "Ā" (U+0100)
  0x01, 0x01, 0x40, 0x01, 0x04, 0x08, 0x06, 0x0F, 0x76, // "ā" (U+0101)
  0x01, 0x02, 0x00, 0x01, 0x06, 0x0B, 0x06, 0x0F, 0x8A, // "Ă" (U+0102)
  0x01, 0x03, 0x40, 0x01, 0x04, 0x09, 0x06, 0x0F, 0xAE, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0xFE, 0x06, 0x08, 0x06, 0x0F, 0xC5, // "Ą" (U+0104)
  0x01, 0x05, 0x40, 0xFE, 0x04, 0x06, 0x06, 0x0F, 0xEA, // "ą" (U+0105)
  0x01, 0x06, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x10, 0x01, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x01, 0x04, 0x09, 0x05, 0x10, 0x1C, // "ć" (U+0107)
  0x01, 0x08, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x10, 0x30, // "Ĉ" (U+0108)
  0x01, 0x09, 0x00, 0x01, 0x04, 0x09, 0x05, 0x10, 0x4D, // "ĉ" (U+0109)
  0x01, 0x0A, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x10, 0x63, // "Ċ" (U+010A)
  0x01, 0x0B, 0x00, 0x01, 0x04, 0x08, 0x05, 0x10, 0x7C, // "ċ" (U+010B)
  0x01, 0x0C, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x10, 0x8E, // "Č" (U+010C)
  0x01, 0x0D, 0x00, 0x01, 0x04, 0x09, 0x05, 0x10, 0xAB, // "č" (U+010D)
  0x01, 0x0E, 0x41, 0x01, 0x06, 0x0B, 0x07, 0x10, 0xC1, // "Ď" (U+010E)
  0x01, 0x0F, 0x40, 0x01, 0x06, 0x08, 0x06, 0x10, 0xE2, // "ď" (U+010F)
  0x01, 0x10, 0x40, 0x01, 0x06, 0x08, 0x07, 0x10, 0xFE, // "Đ" (U+0110)
  0x01, 0x11, 0x40, 0x01, 0x05, 0x08, 0x06, 0x11, 0x1A, // "đ" (U+0111)
  0x01, 0x12, 0x01, 0x01, 0x04, 0x0A, 0x06, 0x11, 0x32, // "Ē" (U+0112)
  0x01, 0x13, 0x40, 0x01, 0x05, 0x08, 0x06, 0x11, 0x45, // "ē" (U+0113)
  0x01, 0x14, 0x01, 0x01, 0x04, 0x0B, 0x06, 0x11, 0x5D, // "Ĕ" (U+0114)
  0x01, 0x15, 0x40, 0x01, 0x05, 0x09, 0x06, 0x11, 0x72, // "ĕ" (U+0115)
  0x01, 0x16, 0x01, 0x01, 0x04, 0x0A, 0x06, 0x11, 0x8D, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x01, 0x05, 0x08, 0x06, 0x11, 0xA0, // "ė" (U+0117)
  0x01, 0x18, 0x41, 0xFE, 0x04, 0x08, 0x06, 0x11, 0xB7, // "Ę" (U+0118)
  0x01, 0x19, 0x00, 0xFE, 0x05, 0x06, 0x06, 0x11, 0xCD, // "ę" (U+0119)
  0x01, 0x1A, 0x01, 0x01, 0x04, 0x0B, 0x06, 0x11, 0xE7, // "Ě" (U+011A)
  0x01, 0x1B, 0x40, 0x01, 0x05, 0x09, 0x06, 0x11, 0xFC, // "ě" (U+011B)
  0x01, 0x1C, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x12, 0x17, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x40, 0xFE, 0x05, 0x09, 0x06, 0x12, 0x3A, // "ĝ" (U+011D)
  0x01, 0x1E, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x12, 0x5E, // "Ğ" (U+011E)
  0x01, 0x1F, 0x40, 0xFE, 0x05, 0x09, 0x06, 0x12, 0x82, // "ğ" (U+011F)
  0x01, 0x20, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x12, 0xA6, // "Ġ" (U+0120)
  0x01, 0x21, 0x40, 0xFE, 0x05, 0x08, 0x06, 0x12, 0xC5, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0xFE, 0x06, 0x08, 0x07, 0x12, 0xE6, // "Ģ" (U+0122)
  0x01, 0x23, 0x40, 0xFE, 0x05, 0x08, 0x06, 0x13, 0x08, // "ģ" (U+0123)
  0x01, 0x24, 0x01, 0x01, 0x06, 0x0B, 0x07, 0x13, 0x29, // "Ĥ" (U+0124)
  0x01, 0x25, 0xFF, 0x01, 0x05, 0x0B, 0x06, 0x13, 0x48, // "ĥ" (U+0125)
  0x01, 0x26, 0x40, 0x01, 0x07, 0x08, 0x07, 0x13, 0x6C, // "Ħ" (U+0126)
  0x01, 0x27, 0x40, 0x01, 0x05, 0x08, 0x06, 0x13, 0x8C, // "ħ" (U+0127)
  0x01, 0x28, 0xBF, 0x01, 0x02, 0x0B, 0x03, 0x13, 0xA4, // "Ĩ" (U+0128)
  0x01, 0x29, 0xBF, 0x01, 0x02, 0x09, 0x03, 0x13, 0xBA, // "ĩ" (U+0129)
  0x01, 0x2A, 0x40, 0x01, 0x03, 0x0A, 0x03, 0x13, 0xCC, // "Ī" (U+012A)
  0x01, 0x2B, 0xBF, 0x01, 0x02, 0x08, 0x03, 0x13, 0xE0, // "ī" (U+012B)
  0x01, 0x2C, 0x40, 0x01, 0x03, 0x0B, 0x03, 0x13, 0xF0, // "Ĭ" (U+012C)
  0x01, 0x2D, 0xBF, 0x01, 0x02, 0x09, 0x03, 0x14, 0x06, // "ĭ" (U+012D)
  0x01, 0x2E, 0x40, 0xFE, 0x02, 0x08, 0x03, 0x14, 0x18, // "Į" (U+012E)
  0x01, 0x2F, 0x40, 0xFE, 0x01, 0x08, 0x03, 0x14, 0x29, // "į" (U+012F)
  0x01, 0x30, 0x40, 0x01, 0x02, 0x0A, 0x03, 0x14, 0x34, // "İ" (U+0130)
  0x01, 0x31, 0x40, 0x01, 0x01, 0x06, 0x03, 0x14, 0x43, // "ı" (U+0131)
  0x01, 0x32, 0x40, 0xFF, 0x04, 0x08, 0x06, 0x14, 0x49, // "Ĳ" (U+0132)
  0x01, 0x33, 0x40, 0xFE, 0x04, 0x08, 0x05, 0x14, 0x62, // "ĳ" (U+0133)
  0x01, 0x34, 0xBF, 0xFF, 0x02, 0x0B, 0x03, 0x14, 0x7E, // "Ĵ" (U+0134)
  0x01, 0x35, 0xBF, 0xFE, 0x02, 0x09, 0x03, 0x14, 0x98, // "ĵ" (U+0135)
  0x01, 0x36, 0x41, 0xFE, 0x05, 0x08, 0x06, 0x14, 0xB0, // "Ķ" (U+0136)
  0x01, 0x37, 0x00, 0xFE, 0x04, 0x08, 0x05, 0x14, 0xCC, // "ķ" (U+0137)
  0x01, 0x38, 0x40, 0x01, 0x04, 0x06, 0x05, 0x14, 0xE6, // "ĸ" (U+0138)
  0x01, 0x39, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x14, 0xF5, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x40, 0x01, 0x02, 0x0B, 0x03, 0x15, 0x07, // "ĺ" (U+013A)
  0x01, 0x3B, 0x01, 0xFE, 0x04, 0x08, 0x05, 0x15, 0x18, // "Ļ" (U+013B)
  0x01, 0x3C, 0x40, 0xFE, 0x01, 0x08, 0x03, 0x15, 0x2A, // "ļ" (U+013C)
  0x01, 0x3D, 0x01, 0x01, 0x04, 0x08, 0x05, 0x15, 0x35, // "Ľ" (U+013D)
  0x01, 0x3E, 0x40, 0x01, 0x03, 0x08, 0x03, 0x15, 0x43, // "ľ" (U+013E)
  0x01, 0x3F, 0x01, 0x01, 0x04, 0x08, 0x05, 0x15, 0x53, // "Ŀ" (U+013F)
  0x01, 0x40, 0x40, 0x01, 0x03, 0x08, 0x03, 0x15, 0x61, // "ŀ" (U+0140)
  0x01, 0x41, 0x00, 0x01, 0x04, 0x08, 0x05, 0x15, 0x71, // "Ł" (U+0141)
  0x01, 0x42, 0x40, 0x01, 0x02, 0x08, 0x03, 0x15, 0x81, // "ł" (U+0142)
  0x01, 0x43, 0x01, 0x01, 0x06, 0x0B, 0x08, 0x15, 0x8D, // "Ń" (U+0143)
  0x01, 0x44, 0x40, 0x01, 0x05, 0x09, 0x06, 0x15, 0xAD, // "ń" (U+0144)
  0x01, 0x45, 0x01, 0xFE, 0x06, 0x08, 0x08, 0x15, 0xC8, // "Ņ" (U+0145)
  0x01, 0x46, 0x40, 0xFE, 0x05, 0x06, 0x06, 0x15, 0xE8, // "ņ" (U+0146)
  0x01, 0x47, 0x41, 0x01, 0x06, 0x0B, 0x08, 0x16, 0x03, // "Ň" (U+0147)
  0x01, 0x48, 0x40, 0x01, 0x05, 0x09, 0x06, 0x16, 0x24, // "ň" (U+0148)
  0x01, 0x49, 0x40, 0x01, 0x06, 0x08, 0x07, 0x16, 0x3F, // "ŉ" (U+0149)
  0x01, 0x4A, 0x41, 0xFF, 0x06, 0x08, 0x08, 0x16, 0x5B, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x40, 0xFE, 0x05, 0x06, 0x06, 0x16, 0x79, // "ŋ" (U+014B)
  0x01, 0x4C, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x16, 0x94, // "Ō" (U+014C)
  0x01, 0x4D, 0x40, 0x01, 0x05, 0x08, 0x06, 0x16, 0xB8, // "ō" (U+014D)
  0x01, 0x4E, 0x00, 0x01, 0x07, 0x0B, 0x08, 0x16, 0xD0, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x40, 0x01, 0x05, 0x09, 0x06, 0x16, 0xF8, // "ŏ" (U+014F)
  0x01, 0x50, 0x00, 0x01, 0x07, 0x0B, 0x08, 0x17, 0x13, // "Ő" (U+0150)
  0x01, 0x51, 0x40, 0x01, 0x05, 0x09, 0x06, 0x17, 0x3A, // "ő" (U+0151)
  0x01, 0x52, 0x40, 0x01, 0x08, 0x08, 0x09, 0x17, 0x55, // "Œ" (U+0152)
  0x01, 0x53, 0x40, 0x01, 0x08, 0x06, 0x09, 0x17, 0x79, // "œ" (U+0153)
  0x01, 0x54, 0x41, 0x01, 0x05, 0x0B, 0x06, 0x17, 0x94, // "Ŕ" (U+0154)
  0x01, 0x55, 0x40, 0x01, 0x03, 0x09, 0x04, 0x17, 0xB0, // "ŕ" (U+0155)
  0x01, 0x56, 0x41, 0xFE, 0x05, 0x08, 0x06, 0x17, 0xC2, // "Ŗ" (U+0156)
  0x01, 0x57, 0x40, 0xFE, 0x03, 0x06, 0x04, 0x17, 0xDE, // "ŗ" (U+0157)
  0x01, 0x58, 0x41, 0x01, 0x05, 0x0B, 0x06, 0x17, 0xF0, // "Ř" (U+0158)
  0x01, 0x59, 0x40, 0x01, 0x03, 0x09, 0x04, 0x18, 0x0C, // "ř" (U+0159)
  0x01, 0x5A, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x18, 0x1E, // "Ś" (U+015A)
  0x01, 0x5B, 0x00, 0x01, 0x04, 0x09, 0x05, 0x18, 0x38, // "ś" (U+015B)
  0x01, 0x5C, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x18, 0x4E, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x40, 0x01, 0x04, 0x09, 0x05, 0x18, 0x69, // "ŝ" (U+015D)
  0x01, 0x5E, 0x40, 0xFE, 0x04, 0x08, 0x05, 0x18, 0x80, // "Ş" (U+015E)
  0x01, 0x5F, 0x40, 0xFE, 0x04, 0x06, 0x05, 0x18, 0x9C, // "ş" (U+015F)
  0x01, 0x60, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x18, 0xB3, // "Š" (U+0160)
  0x01, 0x61, 0x40, 0x01, 0x04, 0x09, 0x05, 0x18, 0xCE, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x18, 0xE5, // "Ţ" (U+0162)
  0x01, 0x63, 0x40, 0xFE, 0x03, 0x08, 0x04, 0x19, 0x03, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x19, 0x19, // "Ť" (U+0164)
  0x01, 0x65, 0x00, 0x01, 0x04, 0x08, 0x04, 0x19, 0x36, // "ť" (U+0165)
  0x01, 0x66, 0x40, 0x01, 0x05, 0x08, 0x06, 0x19, 0x49, // "Ŧ" (U+0166)
  0x01, 0x67, 0x40, 0x01, 0x03, 0x08, 0x04, 0x19, 0x61, // "ŧ" (U+0167)
  0x01, 0x68, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x19, 0x71, // "Ũ" (U+0168)
  0x01, 0x69, 0x40, 0x01, 0x05, 0x09, 0x06, 0x19, 0x97, // "ũ" (U+0169)
  0x01, 0x6A, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x19, 0xB2, // "Ū" (U+016A)
  0x01, 0x6B, 0x40, 0x01, 0x05, 0x08, 0x06, 0x19, 0xD4, // "ū" (U+016B)
  0x01, 0x6C, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x19, 0xEC, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x40, 0x01, 0x05, 0x09, 0x06, 0x1A, 0x12, // "ŭ" (U+016D)
  0x01, 0x6E, 0x40, 0x01, 0x06, 0x0B, 0x07, 0x1A, 0x2D, // "Ů" (U+016E)
  0x01, 0x6F, 0x40, 0x01, 0x05, 0x09, 0x06, 0x1A, 0x54, // "ů" (U+016F)
  0x01, 0x70, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x1A, 0x6F, // "Ű" (U+0170)
  0x01, 0x71, 0x40, 0x01, 0x05, 0x09, 0x06, 0x1A, 0x94, // "ű" (U+0171)
  0x01, 0x72, 0x00, 0xFE, 0x06, 0x08, 0x07, 0x1A, 0xAF, // "Ų" (U+0172)
  0x01, 0x73, 0x40, 0xFE, 0x05, 0x06, 0x06, 0x1A, 0xD3, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x08, 0x0B, 0x09, 0x1A, 0xEE, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x07, 0x09, 0x08, 0x1B, 0x1E, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x1B, 0x40, // "Ŷ" (U+0176)
  0x01, 0x77, 0x40, 0xFE, 0x04, 0x09, 0x05, 0x1B, 0x5F, // "ŷ" (U+0177)
  0x01, 0x78, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x1B, 0x7D, // "Ÿ" (U+0178)
  0x01, 0x79, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x1B, 0x99, // "Ź" (U+0179)
  0x01, 0x7A, 0x00, 0x01, 0x04, 0x09, 0x05, 0x1B, 0xB7, // "ź" (U+017A)
  0x01, 0x7B, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x1B, 0xCD, // "Ż" (U+017B)
  0x01, 0x7C, 0x40, 0x01, 0x04, 0x08, 0x05, 0x1B, 0xE9, // "ż" (U+017C)
  0x01, 0x7D, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x1B, 0xFD, // "Ž" (U+017D)
  0x01, 0x7E, 0x40, 0x01, 0x04, 0x09, 0x05, 0x1C, 0x1C, // "ž" (U+017E)
  0x01, 0x7F, 0x40, 0x01, 0x03, 0x08, 0x03, 0x1C, 0x33, // "ſ" (U+017F)
  0x03, 0xA9, 0x40, 0x01, 0x07, 0x08, 0x08, 0x1C, 0x43, // "Ω" (U+03A9)
  0x03, 0xBC, 0x40, 0xFE, 0x05, 0x06, 0x06, 0x1C, 0x63, // "μ" (U+03BC)
  0x03, 0xC0, 0x40, 0x01, 0x06, 0x06, 0x07, 0x1C, 0x7E, // "π" (U+03C0)
  0x20, 0x13, 0x40, 0x03, 0x04, 0x03, 0x05, 0x1C, 0x93, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x03, 0x09, 0x03, 0x0A, 0x1C, 0x96, // "—" (U+2014)
  0x20, 0xAC, 0x40, 0x01, 0x05, 0x08, 0x06, 0x1C, 0x9A, // "€" (U+20AC)
  0x20, 0xBF, 0x41, 0x00, 0x05, 0x0A, 0x06, 0x1C, 0xB2, // "₿" (U+20BF)
  0x20, 0x18, 0x40, 0x06, 0x01, 0x08, 0x02, 0x1C, 0xCE, // "‘" (U+2018)
  0x20, 0x19, 0x40, 0x06, 0x01, 0x08, 0x02, 0x1C, 0xD1, // "’" (U+2019)
  0x20, 0x1A, 0x40, 0x00, 0x01, 0x02, 0x03, 0x1C, 0xD4, // "‚" (U+201A)
  0x20, 0x1B, 0x40, 0x06, 0x01, 0x08, 0x02, 0x1C, 0xD7, // "‛" (U+201B)
  0x20, 0x1C, 0x40, 0x06, 0x03, 0x08, 0x04, 0x1C, 0xDA, // "“" (U+201C)
  0x20, 0x1D, 0x40, 0x06, 0x03, 0x08, 0x04, 0x1C, 0xE0, // "”" (U+201D)
  0x20, 0x1E, 0x40, 0x00, 0x03, 0x02, 0x04, 0x1C, 0xE6, // "„" (U+201E)
  0x20, 0x1F, 0x40, 0x06, 0x03, 0x08, 0x04, 0x1C, 0xEC, // "‟" (U+201F)
  0x20, 0x20, 0x00, 0x01, 0x04, 0x08, 0x05, 0x1C, 0xF2, // "†" (U+2020)
  0x20, 0x21, 0x40, 0x01, 0x04, 0x08, 0x05, 0x1D, 0x01, // "‡" (U+2021)
  0x20, 0x22, 0x40, 0x04, 0x02, 0x06, 0x04, 0x1D, 0x15, // "•" (U+2022)
  0x20, 0x26, 0x40, 0x01, 0x06, 0x02, 0x08, 0x1D, 0x1A, // "…" (U+2026)
  0x20, 0x30, 0x40, 0x01, 0x0B, 0x08, 0x0C, 0x1D, 0x21, // "‰" (U+2030)
  0x20, 0x39, 0x40, 0x01, 0x02, 0x05, 0x03, 0x1D, 0x51, // "‹" (U+2039)
  0x20, 0x3A, 0x40, 0x01, 0x02, 0x05, 0x03, 0x1D, 0x59, // "›" (U+203A)
  0x20, 0x44, 0xFE, 0x01, 0x02, 0x08, 0x01, 0x1D, 0x61, // "⁄" (U+2044)
  0x21, 0x22, 0x40, 0x04, 0x06, 0x07, 0x08, 0x1D, 0x73, // "™" (U+2122)
  0x21, 0x52, 0x00, 0x01, 0x0A, 0x08, 0x0A, 0x1D, 0x81, // "⅒" (U+2152)
  0xFB, 0x01, 0x40, 0x01, 0x04, 0x08, 0x06, 0x1D, 0xAB, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0x40, 0x01, 0x04, 0x08, 0x06, 0x1D, 0xBF, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x01, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0x63, 0x01, // "c (U+0022 U+0063)
  0x00, 0x22, 0x00, 0x64, 0x01, // "d (U+0022 U+0064)
  0x00, 0x22, 0x00, 0x65, 0x01, // "e (U+0022 U+0065)
  0x00, 0x22, 0x00, 0x6F, 0x01, // "o (U+0022 U+006F)
  0x00, 0x22, 0x00, 0x71, 0x01, // "q (U+0022 U+0071)
  0x00, 0x22, 0x00, 0xC0, 0x01, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x01, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x01, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x01, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x01, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x01, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xC6, 0x01, // "Æ (U+0022 U+00C6)
  0x00, 0x22, 0x00, 0xE0, 0x01, // "à (U+0022 U+00E0)
  0x00, 0x22, 0x00, 0xE7, 0x01, // "ç (U+0022 U+00E7)
  0x00, 0x22, 0x00, 0xE8, 0x01, // "è (U+0022 U+00E8)
  0x00, 0x22, 0x00, 0xE9, 0x01, // "é (U+0022 U+00E9)
  0x00, 0x22, 0x00, 0xEA, 0x01, // "ê (U+0022 U+00EA)
  0x00, 0x22, 0x00, 0xEB, 0x01, // "ë (U+0022 U+00EB)
  0x00, 0x22, 0x00, 0xF2, 0x01, // "ò (U+0022 U+00F2)
  0x00, 0x22, 0x00, 0xF3, 0x01, // "ó (U+0022 U+00F3)
  0x00, 0x22, 0x00, 0xF4, 0x01, // "ô (U+0022 U+00F4)
  0x00, 0x22, 0x00, 0xF5, 0x01, // "õ (U+0022 U+00F5)
  0x00, 0x22, 0x00, 0xF6, 0x01, // "ö (U+0022 U+00F6)
  0x00, 0x22, 0x00, 0xF8, 0x01, // "ø (U+0022 U+00F8)
  0x00, 0x22, 0x01, 0x00, 0x01, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x02, 0x01, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x04, 0x01, // "Ą (U+0022 U+0104)
  0x00, 0x22, 0x01, 0x07, 0x01, // "ć (U+0022 U+0107)
  0x00, 0x22, 0x01, 0x09, 0x01, // "ĉ (U+0022 U+0109)
  0x00, 0x22, 0x01, 0x0B, 0x01, // "ċ (U+0022 U+010B)
  0x00, 0x22, 0x01, 0x0D, 0x01, // "č (U+0022 U+010D)
  0x00, 0x22, 0x01, 0x0F, 0x01, // "ď (U+0022 U+010F)
  0x00, 0x22, 0x01, 0x11, 0x01, // "đ (U+0022 U+0111)
  0x00, 0x22, 0x01, 0x13, 0x01, // "ē (U+0022 U+0113)
  0x00, 0x22, 0x01, 0x15, 0x01, // "ĕ (U+0022 U+0115)
  0x00, 0x22, 0x01, 0x17, 0x01, // "ė (U+0022 U+0117)
  0x00, 0x22, 0x01, 0x19, 0x01, // "ę (U+0022 U+0119)
  0x00, 0x22, 0x01, 0x1B, 0x01, // "ě (U+0022 U+011B)
  0x00, 0x22, 0x01, 0x4D, 0x01, // "ō (U+0022 U+014D)
  0x00, 0x22, 0x01, 0x4F, 0x01, // "ŏ (U+0022 U+014F)
  0x00, 0x22, 0x01, 0x51, 0x01, // "ő (U+0022 U+0151)
  0x00, 0x22, 0x01, 0x53, 0x01, // "œ (U+0022 U+0153)
  0x00, 0x26, 0x00, 0x54, 0x01, // &T (U+0026 U+0054)
  0x00, 0x26, 0x01, 0x62, 0x01, // &Ţ (U+0026 U+0162)
  0x00, 0x26, 0x01, 0x64, 0x01, // &Ť (U+0026 U+0164)
  0x00, 0x26, 0x01, 0x66, 0x01, // &Ŧ (U+0026 U+0166)
  0x00, 0x27, 0x00, 0x41, 0x01, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0x63, 0x01, // 'c (U+0027 U+0063)
  0x00, 0x27, 0x00, 0x64, 0x01, // 'd (U+0027 U+0064)
  0x00, 0x27, 0x00, 0x65, 0x01, // 'e (U+0027 U+0065)
  0x00, 0x27, 0x00, 0x6F, 0x01, // 'o (U+0027 U+006F)
  0x00, 0x27, 0x00, 0x71, 0x01, // 'q (U+0027 U+0071)
  0x00, 0x27, 0x00, 0xC0, 0x01, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x01, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x01, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x01, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x01, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x01, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xC6, 0x01, // 'Æ (U+0027 U+00C6)
  0x00, 0x27, 0x00, 0xE0, 0x01, // 'à (U+0027 U+00E0)
  0x00, 0x27, 0x00, 0xE7, 0x01, // 'ç (U+0027 U+00E7)
  0x00, 0x27, 0x00, 0xE8, 0x01, // 'è (U+0027 U+00E8)
  0x00, 0x27, 0x00, 0xE9, 0x01, // 'é (U+0027 U+00E9)
  0x00, 0x27, 0x00, 0xEA, 0x01, // 'ê (U+0027 U+00EA)
  0x00, 0x27, 0x00, 0xEB, 0x01, // 'ë (U+0027 U+00EB)
  0x00, 0x27, 0x00, 0xF2, 0x01, // 'ò (U+0027 U+00F2)
  0x00, 0x27, 0x00, 0xF3, 0x01, // 'ó (U+0027 U+00F3)
  0x00, 0x27, 0x00, 0xF4, 0x01, // 'ô (U+0027 U+00F4)
  0x00, 0x27, 0x00, 0xF5, 0x01, // 'õ (U+0027 U+00F5)
  0x00, 0x27, 0x00, 0xF6, 0x01, // 'ö (U+0027 U+00F6)
  0x00, 0x27, 0x00, 0xF8, 0x01, // 'ø (U+0027 U+00F8)
  0x00, 0x27, 0x01, 0x00, 0x01, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x02, 0x01, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x04, 0x01, // 'Ą (U+0027 U+0104)
  0x00, 0x27, 0x01, 0x07, 0x01, // 'ć (U+0027 U+0107)
  0x00, 0x27, 0x01, 0x09, 0x01, // 'ĉ (U+0027 U+0109)
  0x00, 0x27, 0x01, 0x0B, 0x01, // 'ċ (U+0027 U+010B)
  0x00, 0x27, 0x01, 0x0D, 0x01, // 'č (U+0027 U+010D)
  0x00, 0x27, 0x01, 0x0F, 0x01, // 'ď (U+0027 U+010F)
  0x00, 0x27, 0x01, 0x11, 0x01, // 'đ (U+0027 U+0111)
  0x00, 0x27, 0x01, 0x13, 0x01, // 'ē (U+0027 U+0113)
  0x00, 0x27, 0x01, 0x15, 0x01, // 'ĕ (U+0027 U+0115)
  0x00, 0x27, 0x01, 0x17, 0x01, // 'ė (U+0027 U+0117)
  0x00, 0x27, 0x01, 0x19, 0x01, // 'ę (U+0027 U+0119)
  0x00, 0x27, 0x01, 0x1B, 0x01, // 'ě (U+0027 U+011B)
  0x00, 0x27, 0x01, 0x4D, 0x01, // 'ō (U+0027 U+014D)
  0x00, 0x27, 0x01, 0x4F, 0x01, // 'ŏ (U+0027 U+014F)
  0x00, 0x27, 0x01, 0x51, 0x01, // 'ő (U+0027 U+0151)
  0x00, 0x27, 0x01, 0x53, 0x01, // 'œ (U+0027 U+0153)
  0x00, 0x2C, 0x00, 0x43, 0x01, // ,C (U+002C U+0043)
  0x00, 0x2C, 0x00, 0x47, 0x01, // ,G (U+002C U+0047)
  0x00, 0x2C, 0x00, 0x4F, 0x01, // ,O (U+002C U+004F)
  0x00, 0x2C, 0x00, 0x51, 0x01, // ,Q (U+002C U+0051)
  0x00, 0x2C, 0x00, 0x54, 0x01, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x56, 0x01, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x01, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x01, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0xC7, 0x01, // ,Ç (U+002C U+00C7)
  0x00, 0x2C, 0x00, 0xD2, 0x01, // ,Ò (U+002C U+00D2)
  0x00, 0x2C, 0x00, 0xD3, 0x01, // ,Ó (U+002C U+00D3)
  0x00, 0x2C, 0x00, 0xD4, 0x01, // ,Ô (U+002C U+00D4)
  0x00, 0x2C, 0x00, 0xD5, 0x01, // ,Õ (U+002C U+00D5)
  0x00, 0x2C, 0x00, 0xD6, 0x01, // ,Ö (U+002C U+00D6)
  0x00, 0x2C, 0x00, 0xD8, 0x01, // ,Ø (U+002C U+00D8)
  0x00, 0x2C, 0x00, 0xDD, 0x01, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x01, 0x06, 0x01, // ,Ć (U+002C U+0106)
  0x00, 0x2C, 0x01, 0x08, 0x01, // ,Ĉ (U+002C U+0108)
  0x00, 0x2C, 0x01, 0x0A, 0x01, // ,Ċ (U+002C U+010A)
  0x00, 0x2C, 0x01, 0x0C, 0x01, // ,Č (U+002C U+010C)
  0x00, 0x2C, 0x01, 0x1C, 0x01, // ,Ĝ (U+002C U+011C)
  0x00, 0x2C, 0x01, 0x1E, 0x01, // ,Ğ (U+002C U+011E)
  0x00, 0x2C, 0x01, 0x20, 0x01, // ,Ġ (U+002C U+0120)
  0x00, 0x2C, 0x01, 0x22, 0x01, // ,Ģ (U+002C U+0122)
  0x00, 0x2C, 0x01, 0x4C, 0x01, // ,Ō (U+002C U+014C)
  0x00, 0x2C, 0x01, 0x4E, 0x01, // ,Ŏ (U+002C U+014E)
  0x00, 0x2C, 0x01, 0x50, 0x01, // ,Ő (U+002C U+0150)
  0x00, 0x2C, 0x01, 0x52, 0x01, // ,Œ (U+002C U+0152)
  0x00, 0x2C, 0x01, 0x62, 0x01, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x01, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x01, // ,Ŧ (U+002C U+0166)
  0x00, 0x2C, 0x01, 0x74, 0x01, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x76, 0x01, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x78, 0x01, // ,Ÿ (U+002C U+0178)
  0x00, 0x2E, 0x00, 0x43, 0x01, // .C (U+002E U+0043)
  0x00, 0x2E, 0x00, 0x47, 0x01, // .G (U+002E U+0047)
  0x00, 0x2E, 0x00, 0x4F, 0x01, // .O (U+002E U+004F)
  0x00, 0x2E, 0x00, 0x51, 0x01, // .Q (U+002E U+0051)
  0x00, 0x2E, 0x00, 0x54, 0x01, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x56, 0x01, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x01, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x01, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0xC7, 0x01, // .Ç (U+002E U+00C7)
  0x00, 0x2E, 0x00, 0xD2, 0x01, // .Ò (U+002E U+00D2)
  0x00, 0x2E, 0x00, 0xD3, 0x01, // .Ó (U+002E U+00D3)
  0x00, 0x2E, 0x00, 0xD4, 0x01, // .Ô (U+002E U+00D4)
  0x00, 0x2E, 0x00, 0xD5, 0x01, // .Õ (U+002E U+00D5)
  0x00, 0x2E, 0x00, 0xD6, 0x01, // .Ö (U+002E U+00D6)
  0x00, 0x2E, 0x00, 0xD8, 0x01, // .Ø (U+002E U+00D8)
  0x00, 0x2E, 0x00, 0xDD, 0x01, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x01, 0x06, 0x01, // .Ć (U+002E U+0106)
  0x00, 0x2E, 0x01, 0x08, 0x01, // .Ĉ (U+002E U+0108)
  0x00, 0x2E, 0x01, 0x0A, 0x01, // .Ċ (U+002E U+010A)
  0x00, 0x2E, 0x01, 0x0C, 0x01, // .Č (U+002E U+010C)
  0x00, 0x2E, 0x01, 0x1C, 0x01, // .Ĝ (U+002E U+011C)
  0x00, 0x2E, 0x01, 0x1E, 0x01, // .Ğ (U+002E U+011E)
  0x00, 0x2E, 0x01, 0x20, 0x01, // .Ġ (U+002E U+0120)
  0x00, 0x2E, 0x01, 0x22, 0x01, // .Ģ (U+002E U+0122)
  0x00, 0x2E, 0x01, 0x4C, 0x01, // .Ō (U+002E U+014C)
  0x00, 0x2E, 0x01, 0x4E, 0x01, // .Ŏ (U+002E U+014E)
  0x00, 0x2E, 0x01, 0x50, 0x01, // .Ő (U+002E U+0150)
  0x00, 0x2E, 0x01, 0x52, 0x01, // .Œ (U+002E U+0152)
  0x00, 0x2E, 0x01, 0x62, 0x01, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x01, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x01, // .Ŧ (U+002E U+0166)
  0x00, 0x2E, 0x01, 0x74, 0x01, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x76, 0x01, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x78, 0x01, // .Ÿ (U+002E U+0178)
  0x00, 0x41, 0x00, 0x22, 0x01, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x01, // A' (U+0041 U+0027)
  0x00, 0x41, 0x00, 0x54, 0x01, // AT (U+0041 U+0054)
  0x00, 0x41, 0x00, 0x59, 0x01, // AY (U+0041 U+0059)
  0x00, 0x41, 0x00, 0xDD, 0x01, // AÝ (U+0041 U+00DD)
  0x00, 0x41, 0x01, 0x62, 0x01, // AŢ (U+0041 U+0162)
  0x00, 0x41, 0x01, 0x64, 0x01, // AŤ (U+0041 U+0164)
  0x00, 0x41, 0x01, 0x66, 0x01, // AŦ (U+0041 U+0166)
  0x00, 0x41, 0x01, 0x76, 0x01, // AŶ (U+0041 U+0176)
  0x00, 0x41, 0x01, 0x78, 0x01, // AŸ (U+0041 U+0178)
  0x00, 0x41, 0x20, 0x19, 0x01, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1D, 0x01, // A” (U+0041 U+201D)
  0x00, 0x46, 0x00, 0x2C, 0x01, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x01, // F. (U+0046 U+002E)
  0x00, 0x46, 0x20, 0x1A, 0x01, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x01, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x01, // F… (U+0046 U+2026)
  0x00, 0x4C, 0x00, 0x22, 0x01, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x01, // L' (U+004C U+0027)
  0x00, 0x4C, 0x20, 0x19, 0x01, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1D, 0x01, // L” (U+004C U+201D)
  0x00, 0x50, 0x00, 0x2C, 0x01, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x01, // P. (U+0050 U+002E)
  0x00, 0x50, 0x00, 0x41, 0x01, // PA (U+0050 U+0041)
  0x00, 0x50, 0x00, 0xC0, 0x01, // PÀ (U+0050 U+00C0)
  0x00, 0x50, 0x00, 0xC1, 0x01, // PÁ (U+0050 U+00C1)
  0x00, 0x50, 0x00, 0xC2, 0x01, // PÂ (U+0050 U+00C2)
  0x00, 0x50, 0x00, 0xC3, 0x01, // PÃ (U+0050 U+00C3)
  0x00, 0x50, 0x00, 0xC4, 0x01, // PÄ (U+0050 U+00C4)
  0x00, 0x50, 0x00, 0xC5, 0x01, // PÅ (U+0050 U+00C5)
  0x00, 0x50, 0x01, 0x00, 0x01, // PĀ (U+0050 U+0100)
  0x00, 0x50, 0x01, 0x02, 0x01, // PĂ (U+0050 U+0102)
  0x00, 0x50, 0x01, 0x04, 0x01, // PĄ (U+0050 U+0104)
  0x00, 0x50, 0x20, 0x1A, 0x01, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x01, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x01, // P… (U+0050 U+2026)
  0x00, 0x54, 0x00, 0x2C, 0x01, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2E, 0x01, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0x41, 0x01, // TA (U+0054 U+0041)
  0x00, 0x54, 0x00, 0x61, 0x01, // Ta (U+0054 U+0061)
  0x00, 0x54, 0x00, 0x63, 0x01, // Tc (U+0054 U+0063)
  0x00, 0x54, 0x00, 0x64, 0x01, // Td (U+0054 U+0064)
  0x00, 0x54, 0x00, 0x65, 0x01, // Te (U+0054 U+0065)
  0x00, 0x54, 0x00, 0x67, 0x01, // Tg (U+0054 U+0067)
  0x00, 0x54, 0x00, 0x6D, 0x01, // Tm (U+0054 U+006D)
  0x00, 0x54, 0x00, 0x6E, 0x01, // Tn (U+0054 U+006E)
  0x00, 0x54, 0x00, 0x6F, 0x01, // To (U+0054 U+006F)
  0x00, 0x54, 0x00, 0x70, 0x01, // Tp (U+0054 U+0070)
  0x00, 0x54, 0x00, 0x71, 0x01, // Tq (U+0054 U+0071)
  0x00, 0x54, 0x00, 0x72, 0x01, // Tr (U+0054 U+0072)
  0x00, 0x54, 0x00, 0x73, 0x01, // Ts (U+0054 U+0073)
  0x00, 0x54, 0x00, 0x75, 0x01, // Tu (U+0054 U+0075)
  0x00, 0x54, 0x00, 0xAB, 0x01, // T« (U+0054 U+00AB)
  0x00, 0x54, 0x00, 0xC0, 0x01, // TÀ (U+0054 U+00C0)
  0x00, 0x54, 0x00, 0xC1, 0x01, // TÁ (U+0054 U+00C1)
  0x00, 0x54, 0x00, 0xC2, 0x01, // TÂ (U+0054 U+00C2)
  0x00, 0x54, 0x00, 0xC3, 0x01, // TÃ (U+0054 U+00C3)
  0x00, 0x54, 0x00, 0xC4, 0x01, // TÄ (U+0054 U+00C4)
  0x00, 0x54, 0x00, 0xC5, 0x01, // TÅ (U+0054 U+00C5)
  0x00, 0x54, 0x00, 0xE0, 0x01, // Tà (U+0054 U+00E0)
  0x00, 0x54, 0x00, 0xE1, 0x01, // Tá (U+0054 U+00E1)
  0x00, 0x54, 0x00, 0xE2, 0x01, // Tâ (U+0054 U+00E2)
  0x00, 0x54, 0x00, 0xE3, 0x01, // Tã (U+0054 U+00E3)
  0x00, 0x54, 0x00, 0xE4, 0x01, // Tä (U+0054 U+00E4)
  0x00, 0x54, 0x00, 0xE5, 0x01, // Tå (U+0054 U+00E5)
  0x00, 0x54, 0x00, 0xE6, 0x01, // Tæ (U+0054 U+00E6)
  0x00, 0x54, 0x00, 0xE7, 0x01, // Tç (U+0054 U+00E7)
  0x00, 0x54, 0x00, 0xE8, 0x01, // Tè (U+0054 U+00E8)
  0x00, 0x54, 0x00, 0xE9, 0x01, // Té (U+0054 U+00E9)
  0x00, 0x54, 0x00, 0xEA, 0x01, // Tê (U+0054 U+00EA)
  0x00, 0x54, 0x00, 0xEB, 0x01, // Të (U+0054 U+00EB)
  0x00, 0x54, 0x00, 0xF2, 0x01, // Tò (U+0054 U+00F2)
  0x00, 0x54, 0x00, 0xF3, 0x01, // Tó (U+0054 U+00F3)
  0x00, 0x54, 0x00, 0xF4, 0x01, // Tô (U+0054 U+00F4)
  0x00, 0x54, 0x00, 0xF5, 0x01, // Tõ (U+0054 U+00F5)
  0x00, 0x54, 0x00, 0xF6, 0x01, // Tö (U+0054 U+00F6)
  0x00, 0x54, 0x00, 0xF8, 0x01, // Tø (U+0054 U+00F8)
  0x00, 0x54, 0x00, 0xF9, 0x01, // Tù (U+0054 U+00F9)
  0x00, 0x54, 0x00, 0xFA, 0x01, // Tú (U+0054 U+00FA)
  0x00, 0x54, 0x00, 0xFB, 0x01, // Tû (U+0054 U+00FB)
  0x00, 0x54, 0x00, 0xFC, 0x01, // Tü (U+0054 U+00FC)
  0x00, 0x54, 0x01, 0x00, 0x01, // TĀ (U+0054 U+0100)
  0x00, 0x54, 0x01, 0x01, 0x01, // Tā (U+0054 U+0101)
  0x00, 0x54, 0x01, 0x02, 0x01, // TĂ (U+0054 U+0102)
  0x00, 0x54, 0x01, 0x03, 0x01, // Tă (U+0054 U+0103)
  0x00, 0x54, 0x01, 0x04, 0x01, // TĄ (U+0054 U+0104)
  0x00, 0x54, 0x01, 0x05, 0x01, // Tą (U+0054 U+0105)
  0x00, 0x54, 0x01, 0x07, 0x01, // Tć (U+0054 U+0107)
  0x00, 0x54, 0x01, 0x09, 0x01, // Tĉ (U+0054 U+0109)
  0x00, 0x54, 0x01, 0x0B, 0x01, // Tċ (U+0054 U+010B)
  0x00, 0x54, 0x01, 0x0D, 0x01, // Tč (U+0054 U+010D)
  0x00, 0x54, 0x01, 0x0F, 0x01, // Tď (U+0054 U+010F)
  0x00, 0x54, 0x01, 0x11, 0x01, // Tđ (U+0054 U+0111)
  0x00, 0x54, 0x01, 0x13, 0x01, // Tē (U+0054 U+0113)
  0x00, 0x54, 0x01, 0x15, 0x01, // Tĕ (U+0054 U+0115)
  0x00, 0x54, 0x01, 0x17, 0x01, // Tė (U+0054 U+0117)
  0x00, 0x54, 0x01, 0x19, 0x01, // Tę (U+0054 U+0119)
  0x00, 0x54, 0x01, 0x1B, 0x01, // Tě (U+0054 U+011B)
  0x00, 0x54, 0x01, 0x1D, 0x01, // Tĝ (U+0054 U+011D)
  0x00, 0x54, 0x01, 0x1F, 0x01, // Tğ (U+0054 U+011F)
  0x00, 0x54, 0x01, 0x21, 0x01, // Tġ (U+0054 U+0121)
  0x00, 0x54, 0x01, 0x23, 0x01, // Tģ (U+0054 U+0123)
  0x00, 0x54, 0x01, 0x38, 0x01, // Tĸ (U+0054 U+0138)
  0x00, 0x54, 0x01, 0x44, 0x01, // Tń (U+0054 U+0144)
  0x00, 0x54, 0x01, 0x46, 0x01, // Tņ (U+0054 U+0146)
  0x00, 0x54, 0x01, 0x4B, 0x01, // Tŋ (U+0054 U+014B)
  0x00, 0x54, 0x01, 0x4D, 0x01, // Tō (U+0054 U+014D)
  0x00, 0x54, 0x01, 0x4F, 0x01, // Tŏ (U+0054 U+014F)
  0x00, 0x54, 0x01, 0x51, 0x01, // Tő (U+0054 U+0151)
  0x00, 0x54, 0x01, 0x53, 0x01, // Tœ (U+0054 U+0153)
  0x00, 0x54, 0x01, 0x55, 0x01, // Tŕ (U+0054 U+0155)
  0x00, 0x54, 0x01, 0x57, 0x01, // Tŗ (U+0054 U+0157)
  0x00, 0x54, 0x01, 0x5B, 0x01, // Tś (U+0054 U+015B)
  0x00, 0x54, 0x01, 0x5F, 0x01, // Tş (U+0054 U+015F)
  0x00, 0x54, 0x01, 0x69, 0x01, // Tũ (U+0054 U+0169)
  0x00, 0x54, 0x01, 0x6B, 0x01, // Tū (U+0054 U+016B)
  0x00, 0x54, 0x01, 0x6D, 0x01, // Tŭ (U+0054 U+016D)
  0x00, 0x54, 0x01, 0x6F, 0x01, // Tů (U+0054 U+016F)
  0x00, 0x54, 0x01, 0x71, 0x01, // Tű (U+0054 U+0171)
  0x00, 0x54, 0x01, 0x73, 0x01, // Tų (U+0054 U+0173)
  0x00, 0x54, 0x20, 0x1A, 0x01, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x01, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x01, // T… (U+0054 U+2026)
  0x00, 0x54, 0x20, 0x39, 0x01, // T‹ (U+0054 U+2039)
  0x00, 0x56, 0x00, 0x2C, 0x01, // V, (U+0056 U+002C)
  0x00, 0x56, 0x00, 0x2E, 0x01, // V. (U+0056 U+002E)
  0x00, 0x56, 0x20, 0x1A, 0x01, // V‚ (U+0056 U+201A)
  0x00, 0x56, 0x20, 0x1E, 0x01, // V„ (U+0056 U+201E)
  0x00, 0x56, 0x20, 0x26, 0x01, // V… (U+0056 U+2026)
  0x00, 0x57, 0x00, 0x2C, 0x01, // W, (U+0057 U+002C)
  0x00, 0x57, 0x00, 0x2E, 0x01, // W. (U+0057 U+002E)
  0x00, 0x57, 0x20, 0x1A, 0x01, // W‚ (U+0057 U+201A)
  0x00, 0x57, 0x20, 0x1E, 0x01, // W„ (U+0057 U+201E)
  0x00, 0x57, 0x20, 0x26, 0x01, // W… (U+0057 U+2026)
  0x00, 0x59, 0x00, 0x2C, 0x01, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x01, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x00, 0x41, 0x01, // YA (U+0059 U+0041)
  0x00, 0x59, 0x00, 0x61, 0x01, // Ya (U+0059 U+0061)
  0x00, 0x59, 0x00, 0x63, 0x01, // Yc (U+0059 U+0063)
  0x00, 0x59, 0x00, 0x64, 0x01, // Yd (U+0059 U+0064)
  0x00, 0x59, 0x00, 0x65, 0x01, // Ye (U+0059 U+0065)
  0x00, 0x59, 0x00, 0x67, 0x01, // Yg (U+0059 U+0067)
  0x00, 0x59, 0x00, 0x6F, 0x01, // Yo (U+0059 U+006F)
  0x00, 0x59, 0x00, 0x71, 0x01, // Yq (U+0059 U+0071)
  0x00, 0x59, 0x00, 0xAB, 0x01, // Y« (U+0059 U+00AB)
  0x00, 0x59, 0x00, 0xC0, 0x01, // YÀ (U+0059 U+00C0)
  0x00, 0x59, 0x00, 0xC1, 0x01, // YÁ (U+0059 U+00C1)
  0x00, 0x59, 0x00, 0xC2, 0x01, // YÂ (U+0059 U+00C2)
  0x00, 0x59, 0x00, 0xC3, 0x01, // YÃ (U+0059 U+00C3)
  0x00, 0x59, 0x00, 0xC4, 0x01, // YÄ (U+0059 U+00C4)
  0x00, 0x59, 0x00, 0xC5, 0x01, // YÅ (U+0059 U+00C5)
  0x00, 0x59, 0x00, 0xE0, 0x01, // Yà (U+0059 U+00E0)
  0x00, 0x59, 0x00, 0xE1, 0x01, // Yá (U+0059 U+00E1)
  0x00, 0x59, 0x00, 0xE2, 0x01, // Yâ (U+0059 U+00E2)
  0x00, 0x59, 0x00, 0xE3, 0x01, // Yã (U+0059 U+00E3)
  0x00, 0x59, 0x00, 0xE4, 0x01, // Yä (U+0059 U+00E4)
  0x00, 0x59, 0x00, 0xE5, 0x01, // Yå (U+0059 U+00E5)
  0x00, 0x59, 0x00, 0xE6, 0x01, // Yæ (U+0059 U+00E6)
  0x00, 0x59, 0x00, 0xE7, 0x01, // Yç (U+0059 U+00E7)
  0x00, 0x59, 0x00, 0xE8, 0x01, // Yè (U+0059 U+00E8)
  0x00, 0x59, 0x00, 0xE9, 0x01, // Yé (U+0059 U+00E9)
  0x00, 0x59, 0x00, 0xEA, 0x01, // Yê (U+0059 U+00EA)
  0x00, 0x59, 0x00, 0xEB, 0x01, // Yë (U+0059 U+00EB)
  0x00, 0x59, 0x00, 0xF2, 0x01, // Yò (U+0059 U+00F2)
  0x00, 0x59, 0x00, 0xF3, 0x01, // Yó (U+0059 U+00F3)
  0x00, 0x59, 0x00, 0xF4, 0x01, // Yô (U+0059 U+00F4)
  0x00, 0x59, 0x00, 0xF5, 0x01, // Yõ (U+0059 U+00F5)
  0x00, 0x59, 0x00, 0xF6, 0x01, // Yö (U+0059 U+00F6)
  0x00, 0x59, 0x00, 0xF8, 0x01, // Yø (U+0059 U+00F8)
  0x00, 0x59, 0x01, 0x00, 0x01, // YĀ (U+0059 U+0100)
  0x00, 0x59, 0x01, 0x01, 0x01, // Yā (U+0059 U+0101)
  0x00, 0x59, 0x01, 0x02, 0x01, // YĂ (U+0059 U+0102)
  0x00, 0x59, 0x01, 0x03, 0x01, // Yă (U+0059 U+0103)
  0x00, 0x59, 0x01, 0x04, 0x01, // YĄ (U+0059 U+0104)
  0x00, 0x59, 0x01, 0x05, 0x01, // Yą (U+0059 U+0105)
  0x00, 0x59, 0x01, 0x07, 0x01, // Yć (U+0059 U+0107)
  0x00, 0x59, 0x01, 0x09, 0x01, // Yĉ (U+0059 U+0109)
  0x00, 0x59, 0x01, 0x0B, 0x01, // Yċ (U+0059 U+010B)
  0x00, 0x59, 0x01, 0x0D, 0x01, // Yč (U+0059 U+010D)
  0x00, 0x59, 0x01, 0x0F, 0x01, // Yď (U+0059 U+010F)
  0x00, 0x59, 0x01, 0x11, 0x01, // Yđ (U+0059 U+0111)
  0x00, 0x59, 0x01, 0x13, 0x01, // Yē (U+0059 U+0113)
  0x00, 0x59, 0x01, 0x15, 0x01, // Yĕ (U+0059 U+0115)
  0x00, 0x59, 0x01, 0x17, 0x01, // Yė (U+0059 U+0117)
  0x00, 0x59, 0x01, 0x19, 0x01, // Yę (U+0059 U+0119)
  0x00, 0x59, 0x01, 0x1B, 0x01, // Yě (U+0059 U+011B)
  0x00, 0x59, 0x01, 0x1D, 0x01, // Yĝ (U+0059 U+011D)
  0x00, 0x59, 0x01, 0x1F, 0x01, // Yğ (U+0059 U+011F)
  0x00, 0x59, 0x01, 0x21, 0x01, // Yġ (U+0059 U+0121)
  0x00, 0x59, 0x01, 0x23, 0x01, // Yģ (U+0059 U+0123)
  0x00, 0x59, 0x01, 0x4D, 0x01, // Yō (U+0059 U+014D)
  0x00, 0x59, 0x01, 0x4F, 0x01, // Yŏ (U+0059 U+014F)
  0x00, 0x59, 0x01, 0x51, 0x01, // Yő (U+0059 U+0151)
  0x00, 0x59, 0x01, 0x53, 0x01, // Yœ (U+0059 U+0153)
  0x00, 0x59, 0x20, 0x1A, 0x01, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x01, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x01, // Y… (U+0059 U+2026)
  0x00, 0x59, 0x20, 0x39, 0x01, // Y‹ (U+0059 U+2039)
  0x00, 0x72, 0x00, 0x2C, 0x02, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x02, // r. (U+0072 U+002E)
  0x00, 0x72, 0x20, 0x1A, 0x02, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x02, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x02, // r… (U+0072 U+2026)
  0x00, 0xBB, 0x00, 0x54, 0x01, // »T (U+00BB U+0054)
  0x00, 0xBB, 0x00, 0x59, 0x01, // »Y (U+00BB U+0059)
  0x00, 0xBB, 0x00, 0xDD, 0x01, // »Ý (U+00BB U+00DD)
  0x00, 0xBB, 0x01, 0x62, 0x01, // »Ţ (U+00BB U+0162)
  0x00, 0xBB, 0x01, 0x64, 0x01, // »Ť (U+00BB U+0164)
  0x00, 0xBB, 0x01, 0x66, 0x01, // »Ŧ (U+00BB U+0166)
  0x00, 0xBB, 0x01, 0x76, 0x01, // »Ŷ (U+00BB U+0176)
  0x00, 0xBB, 0x01, 0x78, 0x01, // »Ÿ (U+00BB U+0178)
  0x00, 0xC0, 0x00, 0x22, 0x01, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x01, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x00, 0x54, 0x01, // ÀT (U+00C0 U+0054)
  0x00, 0xC0, 0x00, 0x59, 0x01, // ÀY (U+00C0 U+0059)
  0x00, 0xC0, 0x00, 0xDD, 0x01, // ÀÝ (U+00C0 U+00DD)
  0x00, 0xC0, 0x01, 0x62, 0x01, // ÀŢ (U+00C0 U+0162)
  0x00, 0xC0, 0x01, 0x64, 0x01, // ÀŤ (U+00C0 U+0164)
  0x00, 0xC0, 0x01, 0x66, 0x01, // ÀŦ (U+00C0 U+0166)
  0x00, 0xC0, 0x01, 0x76, 0x01, // ÀŶ (U+00C0 U+0176)
  0x00, 0xC0, 0x01, 0x78, 0x01, // ÀŸ (U+00C0 U+0178)
  0x00, 0xC0, 0x20, 0x19, 0x01, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1D, 0x01, // À” (U+00C0 U+201D)
  0x00, 0xC1, 0x00, 0x22, 0x01, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x01, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x00, 0x54, 0x01, // ÁT (U+00C1 U+0054)
  0x00, 0xC1, 0x00, 0x59, 0x01, // ÁY (U+00C1 U+0059)
  0x00, 0xC1, 0x00, 0xDD, 0x01, // ÁÝ (U+00C1 U+00DD)
  0x00, 0xC1, 0x01, 0x62, 0x01, // ÁŢ (U+00C1 U+0162)
  0x00, 0xC1, 0x01, 0x64, 0x01, // ÁŤ (U+00C1 U+0164)
  0x00, 0xC1, 0x01, 0x66, 0x01, // ÁŦ (U+00C1 U+0166)
  0x00, 0xC1, 0x01, 0x76, 0x01, // ÁŶ (U+00C1 U+0176)
  0x00, 0xC1, 0x01, 0x78, 0x01, // ÁŸ (U+00C1 U+0178)
  0x00, 0xC1, 0x20, 0x19, 0x01, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1D, 0x01, // Á” (U+00C1 U+201D)
  0x00, 0xC2, 0x00, 0x22, 0x01, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x01, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x00, 0x54, 0x01, // ÂT (U+00C2 U+0054)
  0x00, 0xC2, 0x00, 0x59, 0x01, // ÂY (U+00C2 U+0059)
  0x00, 0xC2, 0x00, 0xDD, 0x01, // ÂÝ (U+00C2 U+00DD)
  0x00, 0xC2, 0x01, 0x62, 0x01, // ÂŢ (U+00C2 U+0162)
  0x00, 0xC2, 0x01, 0x64, 0x01, // ÂŤ (U+00C2 U+0164)
  0x00, 0xC2, 0x01, 0x66, 0x01, // ÂŦ (U+00C2 U+0166)
  0x00, 0xC2, 0x01, 0x76, 0x01, // ÂŶ (U+00C2 U+0176)
  0x00, 0xC2, 0x01, 0x78, 0x01, // ÂŸ (U+00C2 U+0178)
  0x00, 0xC2, 0x20, 0x19, 0x01, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1D, 0x01, // Â” (U+00C2 U+201D)
  0x00, 0xC3, 0x00, 0x22, 0x01, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x01, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x00, 0x54, 0x01, // ÃT (U+00C3 U+0054)
  0x00, 0xC3, 0x00, 0x59, 0x01, // ÃY (U+00C3 U+0059)
  0x00, 0xC3, 0x00, 0xDD, 0x01, // ÃÝ (U+00C3 U+00DD)
  0x00, 0xC3, 0x01, 0x62, 0x01, // ÃŢ (U+00C3 U+0162)
  0x00, 0xC3, 0x01, 0x64, 0x01, // ÃŤ (U+00C3 U+0164)
  0x00, 0xC3, 0x01, 0x66, 0x01, // ÃŦ (U+00C3 U+0166)
  0x00, 0xC3, 0x01, 0x76, 0x01, // ÃŶ (U+00C3 U+0176)
  0x00, 0xC3, 0x01, 0x78, 0x01, // ÃŸ (U+00C3 U+0178)
  0x00, 0xC3, 0x20, 0x19, 0x01, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1D, 0x01, // Ã” (U+00C3 U+201D)
  0x00, 0xC4, 0x00, 0x22, 0x01, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x01, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x00, 0x54, 0x01, // ÄT (U+00C4 U+0054)
  0x00, 0xC4, 0x00, 0x59, 0x01, // ÄY (U+00C4 U+0059)
  0x00, 0xC4, 0x00, 0xDD, 0x01, // ÄÝ (U+00C4 U+00DD)
  0x00, 0xC4, 0x01, 0x62, 0x01, // ÄŢ (U+00C4 U+0162)
  0x00, 0xC4, 0x01, 0x64, 0x01, // ÄŤ (U+00C4 U+0164)
  0x00, 0xC4, 0x01, 0x66, 0x01, // ÄŦ (U+00C4 U+0166)
  0x00, 0xC4, 0x01, 0x76, 0x01, // ÄŶ (U+00C4 U+0176)
  0x00, 0xC4, 0x01, 0x78, 0x01, // ÄŸ (U+00C4 U+0178)
  0x00, 0xC4, 0x20, 0x19, 0x01, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1D, 0x01, // Ä” (U+00C4 U+201D)
  0x00, 0xC5, 0x00, 0x22, 0x01, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x01, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x00, 0x54, 0x01, // ÅT (U+00C5 U+0054)
  0x00, 0xC5, 0x00, 0x59, 0x01, // ÅY (U+00C5 U+0059)
  0x00, 0xC5, 0x00, 0xDD, 0x01, // ÅÝ (U+00C5 U+00DD)
  0x00, 0xC5, 0x01, 0x62, 0x01, // ÅŢ (U+00C5 U+0162)
  0x00, 0xC5, 0x01, 0x64, 0x01, // ÅŤ (U+00C5 U+0164)
  0x00, 0xC5, 0x01, 0x66, 0x01, // ÅŦ (U+00C5 U+0166)
  0x00, 0xC5, 0x01, 0x76, 0x01, // ÅŶ (U+00C5 U+0176)
  0x00, 0xC5, 0x01, 0x78, 0x01, // ÅŸ (U+00C5 U+0178)
  0x00, 0xC5, 0x20, 0x19, 0x01, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1D, 0x01, // Å” (U+00C5 U+201D)
  0x00, 0xDD, 0x00, 0x2C, 0x01, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x01, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x00, 0x41, 0x01, // ÝA (U+00DD U+0041)
  0x00, 0xDD, 0x00, 0x61, 0x01, // Ýa (U+00DD U+0061)
  0x00, 0xDD, 0x00, 0x63, 0x01, // Ýc (U+00DD U+0063)
  0x00, 0xDD, 0x00, 0x64, 0x01, // Ýd (U+00DD U+0064)
  0x00, 0xDD, 0x00, 0x65, 0x01, // Ýe (U+00DD U+0065)
  0x00, 0xDD, 0x00, 0x67, 0x01, // Ýg (U+00DD U+0067)
  0x00, 0xDD, 0x00, 0x6F, 0x01, // Ýo (U+00DD U+006F)
  0x00, 0xDD, 0x00, 0x71, 0x01, // Ýq (U+00DD U+0071)
  0x00, 0xDD, 0x00, 0xAB, 0x01, // Ý« (U+00DD U+00AB)
  0x00, 0xDD, 0x00, 0xC0, 0x01, // ÝÀ (U+00DD U+00C0)
  0x00, 0xDD, 0x00, 0xC1, 0x01, // ÝÁ (U+00DD U+00C1)
  0x00, 0xDD, 0x00, 0xC2, 0x01, // ÝÂ (U+00DD U+00C2)
  0x00, 0xDD, 0x00, 0xC3, 0x01, // ÝÃ (U+00DD U+00C3)
  0x00, 0xDD, 0x00, 0xC4, 0x01, // ÝÄ (U+00DD U+00C4)
  0x00, 0xDD, 0x00, 0xC5, 0x01, // ÝÅ (U+00DD U+00C5)
  0x00, 0xDD, 0x00, 0xE0, 0x01, // Ýà (U+00DD U+00E0)
  0x00, 0xDD, 0x00, 0xE1, 0x01, // Ýá (U+00DD U+00E1)
  0x00, 0xDD, 0x00, 0xE2, 0x01, // Ýâ (U+00DD U+00E2)
  0x00, 0xDD, 0x00, 0xE3, 0x01, // Ýã (U+00DD U+00E3)
  0x00, 0xDD, 0x00, 0xE4, 0x01, // Ýä (U+00DD U+00E4)
  0x00, 0xDD, 0x00, 0xE5, 0x01, // Ýå (U+00DD U+00E5)
  0x00, 0xDD, 0x00, 0xE6, 0x01, // Ýæ (U+00DD U+00E6)
  0x00, 0xDD, 0x00, 0xE7, 0x01, // Ýç (U+00DD U+00E7)
  0x00, 0xDD, 0x00, 0xE8, 0x01, // Ýè (U+00DD U+00E8)
  0x00, 0xDD, 0x00, 0xE9, 0x01, // Ýé (U+00DD U+00E9)
  0x00, 0xDD, 0x00, 0xEA, 0x01, // Ýê (U+00DD U+00EA)
  0x00, 0xDD, 0x00, 0xEB, 0x01, // Ýë (U+00DD U+00EB)
  0x00, 0xDD, 0x00, 0xF2, 0x01, // Ýò (U+00DD U+00F2)
  0x00, 0xDD, 0x00, 0xF3, 0x01, // Ýó (U+00DD U+00F3)
  0x00, 0xDD, 0x00, 0xF4, 0x01, // Ýô (U+00DD U+00F4)
  0x00, 0xDD, 0x00, 0xF5, 0x01, // Ýõ (U+00DD U+00F5)
  0x00, 0xDD, 0x00, 0xF6, 0x01, // Ýö (U+00DD U+00F6)
  0x00, 0xDD, 0x00, 0xF8, 0x01, // Ýø (U+00DD U+00F8)
  0x00, 0xDD, 0x01, 0x00, 0x01, // ÝĀ (U+00DD U+0100)
  0x00, 0xDD, 0x01, 0x01, 0x01, // Ýā (U+00DD U+0101)
  0x00, 0xDD, 0x01, 0x02, 0x01, // ÝĂ (U+00DD U+0102)
  0x00, 0xDD, 0x01, 0x03, 0x01, // Ýă (U+00DD U+0103)
  0x00, 0xDD, 0x01, 0x04, 0x01, // ÝĄ (U+00DD U+0104)
  0x00, 0xDD, 0x01, 0x05, 0x01, // Ýą (U+00DD U+0105)
  0x00, 0xDD, 0x01, 0x07, 0x01, // Ýć (U+00DD U+0107)
  0x00, 0xDD, 0x01, 0x09, 0x01, // Ýĉ (U+00DD U+0109)
  0x00, 0xDD, 0x01, 0x0B, 0x01, // Ýċ (U+00DD U+010B)
  0x00, 0xDD, 0x01, 0x0D, 0x01, // Ýč (U+00DD U+010D)
  0x00, 0xDD, 0x01, 0x0F, 0x01, // Ýď (U+00DD U+010F)
  0x00, 0xDD, 0x01, 0x11, 0x01, // Ýđ (U+00DD U+0111)
  0x00, 0xDD, 0x01, 0x13, 0x01, // Ýē (U+00DD U+0113)
  0x00, 0xDD, 0x01, 0x15, 0x01, // Ýĕ (U+00DD U+0115)
  0x00, 0xDD, 0x01, 0x17, 0x01, // Ýė (U+00DD U+0117)
  0x00, 0xDD, 0x01, 0x19, 0x01, // Ýę (U+00DD U+0119)
  0x00, 0xDD, 0x01, 0x1B, 0x01, // Ýě (U+00DD U+011B)
  0x00, 0xDD, 0x01, 0x1D, 0x01, // Ýĝ (U+00DD U+011D)
  0x00, 0xDD, 0x01, 0x1F, 0x01, // Ýğ (U+00DD U+011F)
  0x00, 0xDD, 0x01, 0x21, 0x01, // Ýġ (U+00DD U+0121)
  0x00, 0xDD, 0x01, 0x23, 0x01, // Ýģ (U+00DD U+0123)
  0x00, 0xDD, 0x01, 0x4D, 0x01, // Ýō (U+00DD U+014D)
  0x00, 0xDD, 0x01, 0x4F, 0x01, // Ýŏ (U+00DD U+014F)
  0x00, 0xDD, 0x01, 0x51, 0x01, // Ýő (U+00DD U+0151)
  0x00, 0xDD, 0x01, 0x53, 0x01, // Ýœ (U+00DD U+0153)
  0x00, 0xDD, 0x20, 0x1A, 0x01, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x01, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x01, // Ý… (U+00DD U+2026)
  0x00, 0xDD, 0x20, 0x39, 0x01, // Ý‹ (U+00DD U+2039)
  0x00, 0xDE, 0x00, 0x2C, 0x01, // Þ, (U+00DE U+002C)
  0x00, 0xDE, 0x00, 0x2E, 0x01, // Þ. (U+00DE U+002E)
  0x00, 0xDE, 0x00, 0x41, 0x01, // ÞA (U+00DE U+0041)
  0x00, 0xDE, 0x00, 0xC0, 0x01, // ÞÀ (U+00DE U+00C0)
  0x00, 0xDE, 0x00, 0xC1, 0x01, // ÞÁ (U+00DE U+00C1)
  0x00, 0xDE, 0x00, 0xC2, 0x01, // ÞÂ (U+00DE U+00C2)
  0x00, 0xDE, 0x00, 0xC3, 0x01, // ÞÃ (U+00DE U+00C3)
  0x00, 0xDE, 0x00, 0xC4, 0x01, // ÞÄ (U+00DE U+00C4)
  0x00, 0xDE, 0x00, 0xC5, 0x01, // ÞÅ (U+00DE U+00C5)
  0x00, 0xDE, 0x01, 0x00, 0x01, // ÞĀ (U+00DE U+0100)
  0x00, 0xDE, 0x01, 0x02, 0x01, // ÞĂ (U+00DE U+0102)
  0x00, 0xDE, 0x01, 0x04, 0x01, // ÞĄ (U+00DE U+0104)
  0x00, 0xDE, 0x20, 0x1A, 0x01, // Þ‚ (U+00DE U+201A)
  0x00, 0xDE, 0x20, 0x1E, 0x01, // Þ„ (U+00DE U+201E)
  0x00, 0xDE, 0x20, 0x26, 0x01, // Þ… (U+00DE U+2026)
  0x01, 0x00, 0x00, 0x22, 0x01, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x01, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x00, 0x54, 0x01, // ĀT (U+0100 U+0054)
  0x01, 0x00, 0x00, 0x59, 0x01, // ĀY (U+0100 U+0059)
  0x01, 0x00, 0x00, 0xDD, 0x01, // ĀÝ (U+0100 U+00DD)
  0x01, 0x00, 0x01, 0x62, 0x01, // ĀŢ (U+0100 U+0162)
  0x01, 0x00, 0x01, 0x64, 0x01, // ĀŤ (U+0100 U+0164)
  0x01, 0x00, 0x01, 0x66, 0x01, // ĀŦ (U+0100 U+0166)
  0x01, 0x00, 0x01, 0x76, 0x01, // ĀŶ (U+0100 U+0176)
  0x01, 0x00, 0x01, 0x78, 0x01, // ĀŸ (U+0100 U+0178)
  0x01, 0x00, 0x20, 0x19, 0x01, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1D, 0x01, // Ā” (U+0100 U+201D)
  0x01, 0x02, 0x00, 0x22, 0x01, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x01, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x00, 0x54, 0x01, // ĂT (U+0102 U+0054)
  0x01, 0x02, 0x00, 0x59, 0x01, // ĂY (U+0102 U+0059)
  0x01, 0x02, 0x00, 0xDD, 0x01, // ĂÝ (U+0102 U+00DD)
  0x01, 0x02, 0x01, 0x62, 0x01, // ĂŢ (U+0102 U+0162)
  0x01, 0x02, 0x01, 0x64, 0x01, // ĂŤ (U+0102 U+0164)
  0x01, 0x02, 0x01, 0x66, 0x01, // ĂŦ (U+0102 U+0166)
  0x01, 0x02, 0x01, 0x76, 0x01, // ĂŶ (U+0102 U+0176)
  0x01, 0x02, 0x01, 0x78, 0x01, // ĂŸ (U+0102 U+0178)
  0x01, 0x02, 0x20, 0x19, 0x01, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1D, 0x01, // Ă” (U+0102 U+201D)
  0x01, 0x04, 0x00, 0x22, 0x01, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x01, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x00, 0x54, 0x01, // ĄT (U+0104 U+0054)
  0x01, 0x04, 0x00, 0x59, 0x01, // ĄY (U+0104 U+0059)
  0x01, 0x04, 0x00, 0xDD, 0x01, // ĄÝ (U+0104 U+00DD)
  0x01, 0x04, 0x01, 0x62, 0x01, // ĄŢ (U+0104 U+0162)
  0x01, 0x04, 0x01, 0x64, 0x01, // ĄŤ (U+0104 U+0164)
  0x01, 0x04, 0x01, 0x66, 0x01, // ĄŦ (U+0104 U+0166)
  0x01, 0x04, 0x01, 0x76, 0x01, // ĄŶ (U+0104 U+0176)
  0x01, 0x04, 0x01, 0x78, 0x01, // ĄŸ (U+0104 U+0178)
  0x01, 0x04, 0x20, 0x19, 0x01, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1D, 0x01, // Ą” (U+0104 U+201D)
  0x01, 0x39, 0x00, 0x22, 0x01, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x01, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x20, 0x19, 0x01, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1D, 0x01, // Ĺ” (U+0139 U+201D)
  0x01, 0x3B, 0x00, 0x22, 0x01, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x01, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x20, 0x19, 0x01, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1D, 0x01, // Ļ” (U+013B U+201D)
  0x01, 0x3D, 0x00, 0x22, 0x01, // Ľ" (U+013D U+0022)
  0x01, 0x3D, 0x00, 0x27, 0x01, // Ľ' (U+013D U+0027)
  0x01, 0x3D, 0x20, 0x19, 0x01, // Ľ’ (U+013D U+2019)
  0x01, 0x3D, 0x20, 0x1D, 0x01, // Ľ” (U+013D U+201D)
  0x01, 0x3F, 0x00, 0x22, 0x01, // Ŀ" (U+013F U+0022)
  0x01, 0x3F, 0x00, 0x27, 0x01, // Ŀ' (U+013F U+0027)
  0x01, 0x3F, 0x20, 0x19, 0x01, // Ŀ’ (U+013F U+2019)
  0x01, 0x3F, 0x20, 0x1D, 0x01, // Ŀ” (U+013F U+201D)
  0x01, 0x41, 0x00, 0x22, 0x01, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x01, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x20, 0x19, 0x01, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1D, 0x01, // Ł” (U+0141 U+201D)
  0x01, 0x55, 0x00, 0x2C, 0x02, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x02, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x20, 0x1A, 0x02, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x02, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x02, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x02, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x02, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x20, 0x1A, 0x02, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x02, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x02, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x02, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x02, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x20, 0x1A, 0x02, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x02, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x02, // ř… (U+0159 U+2026)
  0x01, 0x62, 0x00, 0x2C, 0x01, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2E, 0x01, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0x41, 0x01, // ŢA (U+0162 U+0041)
  0x01, 0x62, 0x00, 0x61, 0x01, // Ţa (U+0162 U+0061)
  0x01, 0x62, 0x00, 0x63, 0x01, // Ţc (U+0162 U+0063)
  0x01, 0x62, 0x00, 0x64, 0x01, // Ţd (U+0162 U+0064)
  0x01, 0x62, 0x00, 0x65, 0x01, // Ţe (U+0162 U+0065)
  0x01, 0x62, 0x00, 0x67, 0x01, // Ţg (U+0162 U+0067)
  0x01, 0x62, 0x00, 0x6D, 0x01, // Ţm (U+0162 U+006D)
  0x01, 0x62, 0x00, 0x6E, 0x01, // Ţn (U+0162 U+006E)
  0x01, 0x62, 0x00, 0x6F, 0x01, // Ţo (U+0162 U+006F)
  0x01, 0x62, 0x00, 0x70, 0x01, // Ţp (U+0162 U+0070)
  0x01, 0x62, 0x00, 0x71, 0x01, // Ţq (U+0162 U+0071)
  0x01, 0x62, 0x00, 0x72, 0x01, // Ţr (U+0162 U+0072)
  0x01, 0x62, 0x00, 0x73, 0x01, // Ţs (U+0162 U+0073)
  0x01, 0x62, 0x00, 0x75, 0x01, // Ţu (U+0162 U+0075)
  0x01, 0x62, 0x00, 0xAB, 0x01, // Ţ« (U+0162 U+00AB)
  0x01, 0x62, 0x00, 0xC0, 0x01, // ŢÀ (U+0162 U+00C0)
  0x01, 0x62, 0x00, 0xC1, 0x01, // ŢÁ (U+0162 U+00C1)
  0x01, 0x62, 0x00, 0xC2, 0x01, // ŢÂ (U+0162 U+00C2)
  0x01, 0x62, 0x00, 0xC3, 0x01, // ŢÃ (U+0162 U+00C3)
  0x01, 0x62, 0x00, 0xC4, 0x01, // ŢÄ (U+0162 U+00C4)
  0x01, 0x62, 0x00, 0xC5, 0x01, // ŢÅ (U+0162 U+00C5)
  0x01, 0x62, 0x00, 0xE0, 0x01, // Ţà (U+0162 U+00E0)
  0x01, 0x62, 0x00, 0xE1, 0x01, // Ţá (U+0162 U+00E1)
  0x01, 0x62, 0x00, 0xE2, 0x01, // Ţâ (U+0162 U+00E2)
  0x01, 0x62, 0x00, 0xE3, 0x01, // Ţã (U+0162 U+00E3)
  0x01, 0x62, 0x00, 0xE4, 0x01, // Ţä (U+0162 U+00E4)
  0x01, 0x62, 0x00, 0xE5, 0x01, // Ţå (U+0162 U+00E5)
  0x01, 0x62, 0x00, 0xE6, 0x01, // Ţæ (U+0162 U+00E6)
  0x01, 0x62, 0x00, 0xE7, 0x01, // Ţç (U+0162 U+00E7)
  0x01, 0x62, 0x00, 0xE8, 0x01, // Ţè (U+0162 U+00E8)
  0x01, 0x62, 0x00, 0xE9, 0x01, // Ţé (U+0162 U+00E9)
  0x01, 0x62, 0x00, 0xEA, 0x01, // Ţê (U+0162 U+00EA)
  0x01, 0x62, 0x00, 0xEB, 0x01, // Ţë (U+0162 U+00EB)
  0x01, 0x62, 0x00, 0xF2, 0x01, // Ţò (U+0162 U+00F2)
  0x01, 0x62, 0x00, 0xF3, 0x01, // Ţó (U+0162 U+00F3)
  0x01, 0x62, 0x00, 0xF4, 0x01, // Ţô (U+0162 U+00F4)
  0x01, 0x62, 0x00, 0xF5, 0x01, // Ţõ (U+0162 U+00F5)
  0x01, 0x62, 0x00, 0xF6, 0x01, // Ţö (U+0162 U+00F6)
  0x01, 0x62, 0x00, 0xF8, 0x01, // Ţø (U+0162 U+00F8)
  0x01, 0x62, 0x00, 0xF9, 0x01, // Ţù (U+0162 U+00F9)
  0x01, 0x62, 0x00, 0xFA, 0x01, // Ţú (U+0162 U+00FA)
  0x01, 0x62, 0x00, 0xFB, 0x01, // Ţû (U+0162 U+00FB)
  0x01, 0x62, 0x00, 0xFC, 0x01, // Ţü (U+0162 U+00FC)
  0x01, 0x62, 0x01, 0x00, 0x01, // ŢĀ (U+0162 U+0100)
  0x01, 0x62, 0x01, 0x01, 0x01, // Ţā (U+0162 U+0101)
  0x01, 0x62, 0x01, 0x02, 0x01, // ŢĂ (U+0162 U+0102)
  0x01, 0x62, 0x01, 0x03, 0x01, // Ţă (U+0162 U+0103)
  0x01, 0x62, 0x01, 0x04, 0x01, // ŢĄ (U+0162 U+0104)
  0x01, 0x62, 0x01, 0x05, 0x01, // Ţą (U+0162 U+0105)
  0x01, 0x62, 0x01, 0x07, 0x01, // Ţć (U+0162 U+0107)
  0x01, 0x62, 0x01, 0x09, 0x01, // Ţĉ (U+0162 U+0109)
  0x01, 0x62, 0x01, 0x0B, 0x01, // Ţċ (U+0162 U+010B)
  0x01, 0x62, 0x01, 0x0D, 0x01, // Ţč (U+0162 U+010D)
  0x01, 0x62, 0x01, 0x0F, 0x01, // Ţď (U+0162 U+010F)
  0x01, 0x62, 0x01, 0x11, 0x01, // Ţđ (U+0162 U+0111)
  0x01, 0x62, 0x01, 0x13, 0x01, // Ţē (U+0162 U+0113)
  0x01, 0x62, 0x01, 0x15, 0x01, // Ţĕ (U+0162 U+0115)
  0x01, 0x62, 0x01, 0x17, 0x01, // Ţė (U+0162 U+0117)
  0x01, 0x62, 0x01, 0x19, 0x01, // Ţę (U+0162 U+0119)
  0x01, 0x62, 0x01, 0x1B, 0x01, // Ţě (U+0162 U+011B)
  0x01, 0x62, 0x01, 0x1D, 0x01, // Ţĝ (U+0162 U+011D)
  0x01, 0x62, 0x01, 0x1F, 0x01, // Ţğ (U+0162 U+011F)
  0x01, 0x62, 0x01, 0x21, 0x01, // Ţġ (U+0162 U+0121)
  0x01, 0x62, 0x01, 0x23, 0x01, // Ţģ (U+0162 U+0123)
  0x01, 0x62, 0x01, 0x38, 0x01, // Ţĸ (U+0162 U+0138)
  0x01, 0x62, 0x01, 0x44, 0x01, // Ţń (U+0162 U+0144)
  0x01, 0x62, 0x01, 0x46, 0x01, // Ţņ (U+0162 U+0146)
  0x01, 0x62, 0x01, 0x4B, 0x01, // Ţŋ (U+0162 U+014B)
  0x01, 0x62, 0x01, 0x4D, 0x01, // Ţō (U+0162 U+014D)
  0x01, 0x62, 0x01, 0x4F, 0x01, // Ţŏ (U+0162 U+014F)
  0x01, 0x62, 0x01, 0x51, 0x01, // Ţő (U+0162 U+0151)
  0x01, 0x62, 0x01, 0x53, 0x01, // Ţœ (U+0162 U+0153)
  0x01, 0x62, 0x01, 0x55, 0x01, // Ţŕ (U+0162 U+0155)
  0x01, 0x62, 0x01, 0x57, 0x01, // Ţŗ (U+0162 U+0157)
  0x01, 0x62, 0x01, 0x5B, 0x01, // Ţś (U+0162 U+015B)
  0x01, 0x62, 0x01, 0x5F, 0x01, // Ţş (U+0162 U+015F)
  0x01, 0x62, 0x01, 0x69, 0x01, // Ţũ (U+0162 U+0169)
  0x01, 0x62, 0x01, 0x6B, 0x01, // Ţū (U+0162 U+016B)
  0x01, 0x62, 0x01, 0x6D, 0x01, // Ţŭ (U+0162 U+016D)
  0x01, 0x62, 0x01, 0x6F, 0x01, // Ţů (U+0162 U+016F)
  0x01, 0x62, 0x01, 0x71, 0x01, // Ţű (U+0162 U+0171)
  0x01, 0x62, 0x01, 0x73, 0x01, // Ţų (U+0162 U+0173)
  0x01, 0x62, 0x20, 0x1A, 0x01, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x01, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x01, // Ţ… (U+0162 U+2026)
  0x01, 0x62, 0x20, 0x39, 0x01, // Ţ‹ (U+0162 U+2039)
  0x01, 0x64, 0x00, 0x2C, 0x01, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2E, 0x01, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0x41, 0x01, // ŤA (U+0164 U+0041)
  0x01, 0x64, 0x00, 0x61, 0x01, // Ťa (U+0164 U+0061)
  0x01, 0x64, 0x00, 0x63, 0x01, // Ťc (U+0164 U+0063)
  0x01, 0x64, 0x00, 0x64, 0x01, // Ťd (U+0164 U+0064)
  0x01, 0x64, 0x00, 0x65, 0x01, // Ťe (U+0164 U+0065)
  0x01, 0x64, 0x00, 0x67, 0x01, // Ťg (U+0164 U+0067)
  0x01, 0x64, 0x00, 0x6D, 0x01, // Ťm (U+0164 U+006D)
  0x01, 0x64, 0x00, 0x6E, 0x01, // Ťn (U+0164 U+006E)
  0x01, 0x64, 0x00, 0x6F, 0x01, // Ťo (U+0164 U+006F)
  0x01, 0x64, 0x00, 0x70, 0x01, // Ťp (U+0164 U+0070)
  0x01, 0x64, 0x00, 0x71, 0x01, // Ťq (U+0164 U+0071)
  0x01, 0x64, 0x00, 0x72, 0x01, // Ťr (U+0164 U+0072)
  0x01, 0x64, 0x00, 0x73, 0x01, // Ťs (U+0164 U+0073)
  0x01, 0x64, 0x00, 0x75, 0x01, // Ťu (U+0164 U+0075)
  0x01, 0x64, 0x00, 0xAB, 0x01, // Ť« (U+0164 U+00AB)
  0x01, 0x64, 0x00, 0xC0, 0x01, // ŤÀ (U+0164 U+00C0)
  0x01, 0x64, 0x00, 0xC1, 0x01, // ŤÁ (U+0164 U+00C1)
  0x01, 0x64, 0x00, 0xC2, 0x01, // ŤÂ (U+0164 U+00C2)
  0x01, 0x64, 0x00, 0xC3, 0x01, // ŤÃ (U+0164 U+00C3)
  0x01, 0x64, 0x00, 0xC4, 0x01, // ŤÄ (U+0164 U+00C4)
  0x01, 0x64, 0x00, 0xC5, 0x01, // ŤÅ (U+0164 U+00C5)
  0x01, 0x64, 0x00, 0xE0, 0x01, // Ťà (U+0164 U+00E0)
  0x01, 0x64, 0x00, 0xE1, 0x01, // Ťá (U+0164 U+00E1)
  0x01, 0x64, 0x00, 0xE2, 0x01, // Ťâ (U+0164 U+00E2)
  0x01, 0x64, 0x00, 0xE3, 0x01, // Ťã (U+0164 U+00E3)
  0x01, 0x64, 0x00, 0xE4, 0x01, // Ťä (U+0164 U+00E4)
  0x01, 0x64, 0x00, 0xE5, 0x01, // Ťå (U+0164 U+00E5)
  0x01, 0x64, 0x00, 0xE6, 0x01, // Ťæ (U+0164 U+00E6)
  0x01, 0x64, 0x00, 0xE7, 0x01, // Ťç (U+0164 U+00E7)
  0x01, 0x64, 0x00, 0xE8, 0x01, // Ťè (U+0164 U+00E8)
  0x01, 0x64, 0x00, 0xE9, 0x01, // Ťé (U+0164 U+00E9)
  0x01, 0x64, 0x00, 0xEA, 0x01, // Ťê (U+0164 U+00EA)
  0x01, 0x64, 0x00, 0xEB, 0x01, // Ťë (U+0164 U+00EB)
  0x01, 0x64, 0x00, 0xF2, 0x01, // Ťò (U+0164 U+00F2)
  0x01, 0x64, 0x00, 0xF3, 0x01, // Ťó (U+0164 U+00F3)
  0x01, 0x64, 0x00, 0xF4, 0x01, // Ťô (U+0164 U+00F4)
  0x01, 0x64, 0x00, 0xF5, 0x01, // Ťõ (U+0164 U+00F5)
  0x01, 0x64, 0x00, 0xF6, 0x01, // Ťö (U+0164 U+00F6)
  0x01, 0x64, 0x00, 0xF8, 0x01, // Ťø (U+0164 U+00F8)
  0x01, 0x64, 0x00, 0xF9, 0x01, // Ťù (U+0164 U+00F9)
  0x01, 0x64, 0x00, 0xFA, 0x01, // Ťú (U+0164 U+00FA)
  0x01, 0x64, 0x00, 0xFB, 0x01, // Ťû (U+0164 U+00FB)
  0x01, 0x64, 0x00, 0xFC, 0x01, // Ťü (U+0164 U+00FC)
  0x01, 0x64, 0x01, 0x00, 0x01, // ŤĀ (U+0164 U+0100)
  0x01, 0x64, 0x01, 0x01, 0x01, // Ťā (U+0164 U+0101)
  0x01, 0x64, 0x01, 0x02, 0x01, // ŤĂ (U+0164 U+0102)
  0x01, 0x64, 0x01, 0x03, 0x01, // Ťă (U+0164 U+0103)
  0x01, 0x64, 0x01, 0x04, 0x01, // ŤĄ (U+0164 U+0104)
  0x01, 0x64, 0x01, 0x05, 0x01, // Ťą (U+0164 U+0105)
  0x01, 0x64, 0x01, 0x07, 0x01, // Ťć (U+0164 U+0107)
  0x01, 0x64, 0x01, 0x09, 0x01, // Ťĉ (U+0164 U+0109)
  0x01, 0x64, 0x01, 0x0B, 0x01, // Ťċ (U+0164 U+010B)
  0x01, 0x64, 0x01, 0x0D, 0x01, // Ťč (U+0164 U+010D)
  0x01, 0x64, 0x01, 0x0F, 0x01, // Ťď (U+0164 U+010F)
  0x01, 0x64, 0x01, 0x11, 0x01, // Ťđ (U+0164 U+0111)
  0x01, 0x64, 0x01, 0x13, 0x01, // Ťē (U+0164 U+0113)
  0x01, 0x64, 0x01, 0x15, 0x01, // Ťĕ (U+0164 U+0115)
  0x01, 0x64, 0x01, 0x17, 0x01, // Ťė (U+0164 U+0117)
  0x01, 0x64, 0x01, 0x19, 0x01, // Ťę (U+0164 U+0119)
  0x01, 0x64, 0x01, 0x1B, 0x01, // Ťě (U+0164 U+011B)
  0x01, 0x64, 0x01, 0x1D, 0x01, // Ťĝ (U+0164 U+011D)
  0x01, 0x64, 0x01, 0x1F, 0x01, // Ťğ (U+0164 U+011F)
  0x01, 0x64, 0x01, 0x21, 0x01, // Ťġ (U+0164 U+0121)
  0x01, 0x64, 0x01, 0x23, 0x01, // Ťģ (U+0164 U+0123)
  0x01, 0x64, 0x01, 0x38, 0x01, // Ťĸ (U+0164 U+0138)
  0x01, 0x64, 0x01, 0x44, 0x01, // Ťń (U+0164 U+0144)
  0x01, 0x64, 0x01, 0x46, 0x01, // Ťņ (U+0164 U+0146)
  0x01, 0x64, 0x01, 0x4B, 0x01, // Ťŋ (U+0164 U+014B)
  0x01, 0x64, 0x01, 0x4D, 0x01, // Ťō (U+0164 U+014D)
  0x01, 0x64, 0x01, 0x4F, 0x01, // Ťŏ (U+0164 U+014F)
  0x01, 0x64, 0x01, 0x51, 0x01, // Ťő (U+0164 U+0151)
  0x01, 0x64, 0x01, 0x53, 0x01, // Ťœ (U+0164 U+0153)
  0x01, 0x64, 0x01, 0x55, 0x01, // Ťŕ (U+0164 U+0155)
  0x01, 0x64, 0x01, 0x57, 0x01, // Ťŗ (U+0164 U+0157)
  0x01, 0x64, 0x01, 0x5B, 0x01, // Ťś (U+0164 U+015B)
  0x01, 0x64, 0x01, 0x5F, 0x01, // Ťş (U+0164 U+015F)
  0x01, 0x64, 0x01, 0x69, 0x01, // Ťũ (U+0164 U+0169)
  0x01, 0x64, 0x01, 0x6B, 0x01, // Ťū (U+0164 U+016B)
  0x01, 0x64, 0x01, 0x6D, 0x01, // Ťŭ (U+0164 U+016D)
  0x01, 0x64, 0x01, 0x6F, 0x01, // Ťů (U+0164 U+016F)
  0x01, 0x64, 0x01, 0x71, 0x01, // Ťű (U+0164 U+0171)
  0x01, 0x64, 0x01, 0x73, 0x01, // Ťų (U+0164 U+0173)
  0x01, 0x64, 0x20, 0x1A, 0x01, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x01, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x01, // Ť… (U+0164 U+2026)
  0x01, 0x64, 0x20, 0x39, 0x01, // Ť‹ (U+0164 U+2039)
  0x01, 0x66, 0x00, 0x2C, 0x01, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2E, 0x01, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0x41, 0x01, // ŦA (U+0166 U+0041)
  0x01, 0x66, 0x00, 0x61, 0x01, // Ŧa (U+0166 U+0061)
  0x01, 0x66, 0x00, 0x63, 0x01, // Ŧc (U+0166 U+0063)
  0x01, 0x66, 0x00, 0x64, 0x01, // Ŧd (U+0166 U+0064)
  0x01, 0x66, 0x00, 0x65, 0x01, // Ŧe (U+0166 U+0065)
  0x01, 0x66, 0x00, 0x67, 0x01, // Ŧg (U+0166 U+0067)
  0x01, 0x66, 0x00, 0x6D, 0x01, // Ŧm (U+0166 U+006D)
  0x01, 0x66, 0x00, 0x6E, 0x01, // Ŧn (U+0166 U+006E)
  0x01, 0x66, 0x00, 0x6F, 0x01, // Ŧo (U+0166 U+006F)
  0x01, 0x66, 0x00, 0x70, 0x01, // Ŧp (U+0166 U+0070)
  0x01, 0x66, 0x00, 0x71, 0x01, // Ŧq (U+0166 U+0071)
  0x01, 0x66, 0x00, 0x72, 0x01, // Ŧr (U+0166 U+0072)
  0x01, 0x66, 0x00, 0x73, 0x01, // Ŧs (U+0166 U+0073)
  0x01, 0x66, 0x00, 0x75, 0x01, // Ŧu (U+0166 U+0075)
  0x01, 0x66, 0x00, 0xAB, 0x01, // Ŧ« (U+0166 U+00AB)
  0x01, 0x66, 0x00, 0xC0, 0x01, // ŦÀ (U+0166 U+00C0)
  0x01, 0x66, 0x00, 0xC1, 0x01, // ŦÁ (U+0166 U+00C1)
  0x01, 0x66, 0x00, 0xC2, 0x01, // ŦÂ (U+0166 U+00C2)
  0x01, 0x66, 0x00, 0xC3, 0x01, // ŦÃ (U+0166 U+00C3)
  0x01, 0x66, 0x00, 0xC4, 0x01, // ŦÄ (U+0166 U+00C4)
  0x01, 0x66, 0x00, 0xC5, 0x01, // ŦÅ (U+0166 U+00C5)
  0x01, 0x66, 0x00, 0xE0, 0x01, // Ŧà (U+0166 U+00E0)
  0x01, 0x66, 0x00, 0xE1, 0x01, // Ŧá (U+0166 U+00E1)
  0x01, 0x66, 0x00, 0xE2, 0x01, // Ŧâ (U+0166 U+00E2)
  0x01, 0x66, 0x00, 0xE3, 0x01, // Ŧã (U+0166 U+00E3)
  0x01, 0x66, 0x00, 0xE4, 0x01, // Ŧä (U+0166 U+00E4)
  0x01, 0x66, 0x00, 0xE5, 0x01, // Ŧå (U+0166 U+00E5)
  0x01, 0x66, 0x00, 0xE6, 0x01, // Ŧæ (U+0166 U+00E6)
  0x01, 0x66, 0x00, 0xE7, 0x01, // Ŧç (U+0166 U+00E7)
  0x01, 0x66, 0x00, 0xE8, 0x01, // Ŧè (U+0166 U+00E8)
  0x01, 0x66, 0x00, 0xE9, 0x01, // Ŧé (U+0166 U+00E9)
  0x01, 0x66, 0x00, 0xEA, 0x01, // Ŧê (U+0166 U+00EA)
  0x01, 0x66, 0x00, 0xEB, 0x01, // Ŧë (U+0166 U+00EB)
  0x01, 0x66, 0x00, 0xF2, 0x01, // Ŧò (U+0166 U+00F2)
  0x01, 0x66, 0x00, 0xF3, 0x01, // Ŧó (U+0166 U+00F3)
  0x01, 0x66, 0x00, 0xF4, 0x01, // Ŧô (U+0166 U+00F4)
  0x01, 0x66, 0x00, 0xF5, 0x01, // Ŧõ (U+0166 U+00F5)
  0x01, 0x66, 0x00, 0xF6, 0x01, // Ŧö (U+0166 U+00F6)
  0x01, 0x66, 0x00, 0xF8, 0x01, // Ŧø (U+0166 U+00F8)
  0x01, 0x66, 0x00, 0xF9, 0x01, // Ŧù (U+0166 U+00F9)
  0x01, 0x66, 0x00, 0xFA, 0x01, // Ŧú (U+0166 U+00FA)
  0x01, 0x66, 0x00, 0xFB, 0x01, // Ŧû (U+0166 U+00FB)
  0x01, 0x66, 0x00, 0xFC, 0x01, // Ŧü (U+0166 U+00FC)
  0x01, 0x66, 0x01, 0x00, 0x01, // ŦĀ (U+0166 U+0100)
  0x01, 0x66, 0x01, 0x01, 0x01, // Ŧā (U+0166 U+0101)
  0x01, 0x66, 0x01, 0x02, 0x01, // ŦĂ (U+0166 U+0102)
  0x01, 0x66, 0x01, 0x03, 0x01, // Ŧă (U+0166 U+0103)
  0x01, 0x66, 0x01, 0x04, 0x01, // ŦĄ (U+0166 U+0104)
  0x01, 0x66, 0x01, 0x05, 0x01, // Ŧą (U+0166 U+0105)
  0x01, 0x66, 0x01, 0x07, 0x01, // Ŧć (U+0166 U+0107)
  0x01, 0x66, 0x01, 0x09, 0x01, // Ŧĉ (U+0166 U+0109)
  0x01, 0x66, 0x01, 0x0B, 0x01, // Ŧċ (U+0166 U+010B)
  0x01, 0x66, 0x01, 0x0D, 0x01, // Ŧč (U+0166 U+010D)
  0x01, 0x66, 0x01, 0x0F, 0x01, // Ŧď (U+0166 U+010F)
  0x01, 0x66, 0x01, 0x11, 0x01, // Ŧđ (U+0166 U+0111)
  0x01, 0x66, 0x01, 0x13, 0x01, // Ŧē (U+0166 U+0113)
  0x01, 0x66, 0x01, 0x15, 0x01, // Ŧĕ (U+0166 U+0115)
  0x01, 0x66, 0x01, 0x17, 0x01, // Ŧė (U+0166 U+0117)
  0x01, 0x66, 0x01, 0x19, 0x01, // Ŧę (U+0166 U+0119)
  0x01, 0x66, 0x01, 0x1B, 0x01, // Ŧě (U+0166 U+011B)
  0x01, 0x66, 0x01, 0x1D, 0x01, // Ŧĝ (U+0166 U+011D)
  0x01, 0x66, 0x01, 0x1F, 0x01, // Ŧğ (U+0166 U+011F)
  0x01, 0x66, 0x01, 0x21, 0x01, // Ŧġ (U+0166 U+0121)
  0x01, 0x66, 0x01, 0x23, 0x01, // Ŧģ (U+0166 U+0123)
  0x01, 0x66, 0x01, 0x38, 0x01, // Ŧĸ (U+0166 U+0138)
  0x01, 0x66, 0x01, 0x44, 0x01, // Ŧń (U+0166 U+0144)
  0x01, 0x66, 0x01, 0x46, 0x01, // Ŧņ (U+0166 U+0146)
  0x01, 0x66, 0x01, 0x4B, 0x01, // Ŧŋ (U+0166 U+014B)
  0x01, 0x66, 0x01, 0x4D, 0x01, // Ŧō (U+0166 U+014D)
  0x01, 0x66, 0x01, 0x4F, 0x01, // Ŧŏ (U+0166 U+014F)
  0x01, 0x66, 0x01, 0x51, 0x01, // Ŧő (U+0166 U+0151)
  0x01, 0x66, 0x01, 0x53, 0x01, // Ŧœ (U+0166 U+0153)
  0x01, 0x66, 0x01, 0x55, 0x01, // Ŧŕ (U+0166 U+0155)
  0x01, 0x66, 0x01, 0x57, 0x01, // Ŧŗ (U+0166 U+0157)
  0x01, 0x66, 0x01, 0x5B, 0x01, // Ŧś (U+0166 U+015B)
  0x01, 0x66, 0x01, 0x5F, 0x01, // Ŧş (U+0166 U+015F)
  0x01, 0x66, 0x01, 0x69, 0x01, // Ŧũ (U+0166 U+0169)
  0x01, 0x66, 0x01, 0x6B, 0x01, // Ŧū (U+0166 U+016B)
  0x01, 0x66, 0x01, 0x6D, 0x01, // Ŧŭ (U+0166 U+016D)
  0x01, 0x66, 0x01, 0x6F, 0x01, // Ŧů (U+0166 U+016F)
  0x01, 0x66, 0x01, 0x71, 0x01, // Ŧű (U+0166 U+0171)
  0x01, 0x66, 0x01, 0x73, 0x01, // Ŧų (U+0166 U+0173)
  0x01, 0x66, 0x20, 0x1A, 0x01, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x01, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x01, // Ŧ… (U+0166 U+2026)
  0x01, 0x66, 0x20, 0x39, 0x01, // Ŧ‹ (U+0166 U+2039)
  0x01, 0x74, 0x00, 0x2C, 0x01, // Ŵ, (U+0174 U+002C)
  0x01, 0x74, 0x00, 0x2E, 0x01, // Ŵ. (U+0174 U+002E)
  0x01, 0x74, 0x20, 0x1A, 0x01, // Ŵ‚ (U+0174 U+201A)
  0x01, 0x74, 0x20, 0x1E, 0x01, // Ŵ„ (U+0174 U+201E)
  0x01, 0x74, 0x20, 0x26, 0x01, // Ŵ… (U+0174 U+2026)
  0x01, 0x76, 0x00, 0x2C, 0x01, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x01, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x00, 0x41, 0x01, // ŶA (U+0176 U+0041)
  0x01, 0x76, 0x00, 0x61, 0x01, // Ŷa (U+0176 U+0061)
  0x01, 0x76, 0x00, 0x63, 0x01, // Ŷc (U+0176 U+0063)
  0x01, 0x76, 0x00, 0x64, 0x01, // Ŷd (U+0176 U+0064)
  0x01, 0x76, 0x00, 0x65, 0x01, // Ŷe (U+0176 U+0065)
  0x01, 0x76, 0x00, 0x67, 0x01, // Ŷg (U+0176 U+0067)
  0x01, 0x76, 0x00, 0x6F, 0x01, // Ŷo (U+0176 U+006F)
  0x01, 0x76, 0x00, 0x71, 0x01, // Ŷq (U+0176 U+0071)
  0x01, 0x76, 0x00, 0xAB, 0x01, // Ŷ« (U+0176 U+00AB)
  0x01, 0x76, 0x00, 0xC0, 0x01, // ŶÀ (U+0176 U+00C0)
  0x01, 0x76, 0x00, 0xC1, 0x01, // ŶÁ (U+0176 U+00C1)
  0x01, 0x76, 0x00, 0xC2, 0x01, // ŶÂ (U+0176 U+00C2)
  0x01, 0x76, 0x00, 0xC3, 0x01, // ŶÃ (U+0176 U+00C3)
  0x01, 0x76, 0x00, 0xC4, 0x01, // ŶÄ (U+0176 U+00C4)
  0x01, 0x76, 0x00, 0xC5, 0x01, // ŶÅ (U+0176 U+00C5)
  0x01, 0x76, 0x00, 0xE0, 0x01, // Ŷà (U+0176 U+00E0)
  0x01, 0x76, 0x00, 0xE1, 0x01, // Ŷá (U+0176 U+00E1)
  0x01, 0x76, 0x00, 0xE2, 0x01, // Ŷâ (U+0176 U+00E2)
  0x01, 0x76, 0x00, 0xE3, 0x01, // Ŷã (U+0176 U+00E3)
  0x01, 0x76, 0x00, 0xE4, 0x01, // Ŷä (U+0176 U+00E4)
  0x01, 0x76, 0x00, 0xE5, 0x01, // Ŷå (U+0176 U+00E5)
  0x01, 0x76, 0x00, 0xE6, 0x01, // Ŷæ (U+0176 U+00E6)
  0x01, 0x76, 0x00, 0xE7, 0x01, // Ŷç (U+0176 U+00E7)
  0x01, 0x76, 0x00, 0xE8, 0x01, // Ŷè (U+0176 U+00E8)
  0x01, 0x76, 0x00, 0xE9, 0x01, // Ŷé (U+0176 U+00E9)
  0x01, 0x76, 0x00, 0xEA, 0x01, // Ŷê (U+0176 U+00EA)
  0x01, 0x76, 0x00, 0xEB, 0x01, // Ŷë (U+0176 U+00EB)
  0x01, 0x76, 0x00, 0xF2, 0x01, // Ŷò (U+0176 U+00F2)
  0x01, 0x76, 0x00, 0xF3, 0x01, // Ŷó (U+0176 U+00F3)
  0x01, 0x76, 0x00, 0xF4, 0x01, // Ŷô (U+0176 U+00F4)
  0x01, 0x76, 0x00, 0xF5, 0x01, // Ŷõ (U+0176 U+00F5)
  0x01, 0x76, 0x00, 0xF6, 0x01, // Ŷö (U+0176 U+00F6)
  0x01, 0x76, 0x00, 0xF8, 0x01, // Ŷø (U+0176 U+00F8)
  0x01, 0x76, 0x01, 0x00, 0x01, // ŶĀ (U+0176 U+0100)
  0x01, 0x76, 0x01, 0x01, 0x01, // Ŷā (U+0176 U+0101)
  0x01, 0x76, 0x01, 0x02, 0x01, // ŶĂ (U+0176 U+0102)
  0x01, 0x76, 0x01, 0x03, 0x01, // Ŷă (U+0176 U+0103)
  0x01, 0x76, 0x01, 0x04, 0x01, // ŶĄ (U+0176 U+0104)
  0x01, 0x76, 0x01, 0x05, 0x01, // Ŷą (U+0176 U+0105)
  0x01, 0x76, 0x01, 0x07, 0x01, // Ŷć (U+0176 U+0107)
  0x01, 0x76, 0x01, 0x09, 0x01, // Ŷĉ (U+0176 U+0109)
  0x01, 0x76, 0x01, 0x0B, 0x01, // Ŷċ (U+0176 U+010B)
  0x01, 0x76, 0x01, 0x0D, 0x01, // Ŷč (U+0176 U+010D)
  0x01, 0x76, 0x01, 0x0F, 0x01, // Ŷď (U+0176 U+010F)
  0x01, 0x76, 0x01, 0x11, 0x01, // Ŷđ (U+0176 U+0111)
  0x01, 0x76, 0x01, 0x13, 0x01, // Ŷē (U+0176 U+0113)
  0x01, 0x76, 0x01, 0x15, 0x01, // Ŷĕ (U+0176 U+0115)
  0x01, 0x76, 0x01, 0x17, 0x01, // Ŷė (U+0176 U+0117)
  0x01, 0x76, 0x01, 0x19, 0x01, // Ŷę (U+0176 U+0119)
  0x01, 0x76, 0x01, 0x1B, 0x01, // Ŷě (U+0176 U+011B)
  0x01, 0x76, 0x01, 0x1D, 0x01, // Ŷĝ (U+0176 U+011D)
  0x01, 0x76, 0x01, 0x1F, 0x01, // Ŷğ (U+0176 U+011F)
  0x01, 0x76, 0x01, 0x21, 0x01, // Ŷġ (U+0176 U+0121)
  0x01, 0x76, 0x01, 0x23, 0x01, // Ŷģ (U+0176 U+0123)
  0x01, 0x76, 0x01, 0x4D, 0x01, // Ŷō (U+0176 U+014D)
  0x01, 0x76, 0x01, 0x4F, 0x01, // Ŷŏ (U+0176 U+014F)
  0x01, 0x76, 0x01, 0x51, 0x01, // Ŷő (U+0176 U+0151)
  0x01, 0x76, 0x01, 0x53, 0x01, // Ŷœ (U+0176 U+0153)
  0x01, 0x76, 0x20, 0x1A, 0x01, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x01, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x01, // Ŷ… (U+0176 U+2026)
  0x01, 0x76, 0x20, 0x39, 0x01, // Ŷ‹ (U+0176 U+2039)
  0x01, 0x78, 0x00, 0x2C, 0x01, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x01, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x00, 0x41, 0x01, // ŸA (U+0178 U+0041)
  0x01, 0x78, 0x00, 0x61, 0x01, // Ÿa (U+0178 U+0061)
  0x01, 0x78, 0x00, 0x63, 0x01, // Ÿc (U+0178 U+0063)
  0x01, 0x78, 0x00, 0x64, 0x01, // Ÿd (U+0178 U+0064)
  0x01, 0x78, 0x00, 0x65, 0x01, // Ÿe (U+0178 U+0065)
  0x01, 0x78, 0x00, 0x67, 0x01, // Ÿg (U+0178 U+0067)
  0x01, 0x78, 0x00, 0x6F, 0x01, // Ÿo (U+0178 U+006F)
  0x01, 0x78, 0x00, 0x71, 0x01, // Ÿq (U+0178 U+0071)
  0x01, 0x78, 0x00, 0xAB, 0x01, // Ÿ« (U+0178 U+00AB)
  0x01, 0x78, 0x00, 0xC0, 0x01, // ŸÀ (U+0178 U+00C0)
  0x01, 0x78, 0x00, 0xC1, 0x01, // ŸÁ (U+0178 U+00C1)
  0x01, 0x78, 0x00, 0xC2, 0x01, // ŸÂ (U+0178 U+00C2)
  0x01, 0x78, 0x00, 0xC3, 0x01, // ŸÃ (U+0178 U+00C3)
  0x01, 0x78, 0x00, 0xC4, 0x01, // ŸÄ (U+0178 U+00C4)
  0x01, 0x78, 0x00, 0xC5, 0x01, // ŸÅ (U+0178 U+00C5)
  0x01, 0x78, 0x00, 0xE0, 0x01, // Ÿà (U+0178 U+00E0)
  0x01, 0x78, 0x00, 0xE1, 0x01, // Ÿá (U+0178 U+00E1)
  0x01, 0x78, 0x00, 0xE2, 0x01, // Ÿâ (U+0178 U+00E2)
  0x01, 0x78, 0x00, 0xE3, 0x01, // Ÿã (U+0178 U+00E3)
  0x01, 0x78, 0x00, 0xE4, 0x01, // Ÿä (U+0178 U+00E4)
  0x01, 0x78, 0x00, 0xE5, 0x01, // Ÿå (U+0178 U+00E5)
  0x01, 0x78, 0x00, 0xE6, 0x01, // Ÿæ (U+0178 U+00E6)
  0x01, 0x78, 0x00, 0xE7, 0x01, // Ÿç (U+0178 U+00E7)
  0x01, 0x78, 0x00, 0xE8, 0x01, // Ÿè (U+0178 U+00E8)
  0x01, 0x78, 0x00, 0xE9, 0x01, // Ÿé (U+0178 U+00E9)
  0x01, 0x78, 0x00, 0xEA, 0x01, // Ÿê (U+0178 U+00EA)
  0x01, 0x78, 0x00, 0xEB, 0x01, // Ÿë (U+0178 U+00EB)
  0x01, 0x78, 0x00, 0xF2, 0x01, // Ÿò (U+0178 U+00F2)
  0x01, 0x78, 0x00, 0xF3, 0x01, // Ÿó (U+0178 U+00F3)
  0x01, 0x78, 0x00, 0xF4, 0x01, // Ÿô (U+0178 U+00F4)
  0x01, 0x78, 0x00, 0xF5, 0x01, // Ÿõ (U+0178 U+00F5)
  0x01, 0x78, 0x00, 0xF6, 0x01, // Ÿö (U+0178 U+00F6)
  0x01, 0x78, 0x00, 0xF8, 0x01, // Ÿø (U+0178 U+00F8)
  0x01, 0x78, 0x01, 0x00, 0x01, // ŸĀ (U+0178 U+0100)
  0x01, 0x78, 0x01, 0x01, 0x01, // Ÿā (U+0178 U+0101)
  0x01, 0x78, 0x01, 0x02, 0x01, // ŸĂ (U+0178 U+0102)
  0x01, 0x78, 0x01, 0x03, 0x01, // Ÿă (U+0178 U+0103)
  0x01, 0x78, 0x01, 0x04, 0x01, // ŸĄ (U+0178 U+0104)
  0x01, 0x78, 0x01, 0x05, 0x01, // Ÿą (U+0178 U+0105)
  0x01, 0x78, 0x01, 0x07, 0x01, // Ÿć (U+0178 U+0107)
  0x01, 0x78, 0x01, 0x09, 0x01, // Ÿĉ (U+0178 U+0109)
  0x01, 0x78, 0x01, 0x0B, 0x01, // Ÿċ (U+0178 U+010B)
  0x01, 0x78, 0x01, 0x0D, 0x01, // Ÿč (U+0178 U+010D)
  0x01, 0x78, 0x01, 0x0F, 0x01, // Ÿď (U+0178 U+010F)
  0x01, 0x78, 0x01, 0x11, 0x01, // Ÿđ (U+0178 U+0111)
  0x01, 0x78, 0x01, 0x13, 0x01, // Ÿē (U+0178 U+0113)
  0x01, 0x78, 0x01, 0x15, 0x01, // Ÿĕ (U+0178 U+0115)
  0x01, 0x78, 0x01, 0x17, 0x01, // Ÿė (U+0178 U+0117)
  0x01, 0x78, 0x01, 0x19, 0x01, // Ÿę (U+0178 U+0119)
  0x01, 0x78, 0x01, 0x1B, 0x01, // Ÿě (U+0178 U+011B)
  0x01, 0x78, 0x01, 0x1D, 0x01, // Ÿĝ (U+0178 U+011D)
  0x01, 0x78, 0x01, 0x1F, 0x01, // Ÿğ (U+0178 U+011F)
  0x01, 0x78, 0x01, 0x21, 0x01, // Ÿġ (U+0178 U+0121)
  0x01, 0x78, 0x01, 0x23, 0x01, // Ÿģ (U+0178 U+0123)
  0x01, 0x78, 0x01, 0x4D, 0x01, // Ÿō (U+0178 U+014D)
  0x01, 0x78, 0x01, 0x4F, 0x01, // Ÿŏ (U+0178 U+014F)
  0x01, 0x78, 0x01, 0x51, 0x01, // Ÿő (U+0178 U+0151)
  0x01, 0x78, 0x01, 0x53, 0x01, // Ÿœ (U+0178 U+0153)
  0x01, 0x78, 0x20, 0x1A, 0x01, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x01, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x01, // Ÿ… (U+0178 U+2026)
  0x01, 0x78, 0x20, 0x39, 0x01, // Ÿ‹ (U+0178 U+2039)
  0x20, 0x18, 0x00, 0x41, 0x01, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0x63, 0x01, // ‘c (U+2018 U+0063)
  0x20, 0x18, 0x00, 0x64, 0x01, // ‘d (U+2018 U+0064)
  0x20, 0x18, 0x00, 0x65, 0x01, // ‘e (U+2018 U+0065)
  0x20, 0x18, 0x00, 0x6F, 0x01, // ‘o (U+2018 U+006F)
  0x20, 0x18, 0x00, 0x71, 0x01, // ‘q (U+2018 U+0071)
  0x20, 0x18, 0x00, 0xC0, 0x01, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x01, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x01, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x01, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x01, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x01, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xC6, 0x01, // ‘Æ (U+2018 U+00C6)
  0x20, 0x18, 0x00, 0xE0, 0x01, // ‘à (U+2018 U+00E0)
  0x20, 0x18, 0x00, 0xE7, 0x01, // ‘ç (U+2018 U+00E7)
  0x20, 0x18, 0x00, 0xE8, 0x01, // ‘è (U+2018 U+00E8)
  0x20, 0x18, 0x00, 0xE9, 0x01, // ‘é (U+2018 U+00E9)
  0x20, 0x18, 0x00, 0xEA, 0x01, // ‘ê (U+2018 U+00EA)
  0x20, 0x18, 0x00, 0xEB, 0x01, // ‘ë (U+2018 U+00EB)
  0x20, 0x18, 0x00, 0xF2, 0x01, // ‘ò (U+2018 U+00F2)
  0x20, 0x18, 0x00, 0xF3, 0x01, // ‘ó (U+2018 U+00F3)
  0x20, 0x18, 0x00, 0xF4, 0x01, // ‘ô (U+2018 U+00F4)
  0x20, 0x18, 0x00, 0xF5, 0x01, // ‘õ (U+2018 U+00F5)
  0x20, 0x18, 0x00, 0xF6, 0x01, // ‘ö (U+2018 U+00F6)
  0x20, 0x18, 0x00, 0xF8, 0x01, // ‘ø (U+2018 U+00F8)
  0x20, 0x18, 0x01, 0x00, 0x01, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x02, 0x01, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x04, 0x01, // ‘Ą (U+2018 U+0104)
  0x20, 0x18, 0x01, 0x07, 0x01, // ‘ć (U+2018 U+0107)
  0x20, 0x18, 0x01, 0x09, 0x01, // ‘ĉ (U+2018 U+0109)
  0x20, 0x18, 0x01, 0x0B, 0x01, // ‘ċ (U+2018 U+010B)
  0x20, 0x18, 0x01, 0x0D, 0x01, // ‘č (U+2018 U+010D)
  0x20, 0x18, 0x01, 0x0F, 0x01, // ‘ď (U+2018 U+010F)
  0x20, 0x18, 0x01, 0x11, 0x01, // ‘đ (U+2018 U+0111)
  0x20, 0x18, 0x01, 0x13, 0x01, // ‘ē (U+2018 U+0113)
  0x20, 0x18, 0x01, 0x15, 0x01, // ‘ĕ (U+2018 U+0115)
  0x20, 0x18, 0x01, 0x17, 0x01, // ‘ė (U+2018 U+0117)
  0x20, 0x18, 0x01, 0x19, 0x01, // ‘ę (U+2018 U+0119)
  0x20, 0x18, 0x01, 0x1B, 0x01, // ‘ě (U+2018 U+011B)
  0x20, 0x18, 0x01, 0x4D, 0x01, // ‘ō (U+2018 U+014D)
  0x20, 0x18, 0x01, 0x4F, 0x01, // ‘ŏ (U+2018 U+014F)
  0x20, 0x18, 0x01, 0x51, 0x01, // ‘ő (U+2018 U+0151)
  0x20, 0x18, 0x01, 0x53, 0x01, // ‘œ (U+2018 U+0153)
  0x20, 0x19, 0x00, 0x41, 0x01, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0x63, 0x01, // ’c (U+2019 U+0063)
  0x20, 0x19, 0x00, 0x64, 0x01, // ’d (U+2019 U+0064)
  0x20, 0x19, 0x00, 0x65, 0x01, // ’e (U+2019 U+0065)
  0x20, 0x19, 0x00, 0x6F, 0x01, // ’o (U+2019 U+006F)
  0x20, 0x19, 0x00, 0x71, 0x01, // ’q (U+2019 U+0071)
  0x20, 0x19, 0x00, 0xC0, 0x01, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x01, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x01, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x01, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x01, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x01, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xC6, 0x01, // ’Æ (U+2019 U+00C6)
  0x20, 0x19, 0x00, 0xE0, 0x01, // ’à (U+2019 U+00E0)
  0x20, 0x19, 0x00, 0xE7, 0x01, // ’ç (U+2019 U+00E7)
  0x20, 0x19, 0x00, 0xE8, 0x01, // ’è (U+2019 U+00E8)
  0x20, 0x19, 0x00, 0xE9, 0x01, // ’é (U+2019 U+00E9)
  0x20, 0x19, 0x00, 0xEA, 0x01, // ’ê (U+2019 U+00EA)
  0x20, 0x19, 0x00, 0xEB, 0x01, // ’ë (U+2019 U+00EB)
  0x20, 0x19, 0x00, 0xF2, 0x01, // ’ò (U+2019 U+00F2)
  0x20, 0x19, 0x00, 0xF3, 0x01, // ’ó (U+2019 U+00F3)
  0x20, 0x19, 0x00, 0xF4, 0x01, // ’ô (U+2019 U+00F4)
  0x20, 0x19, 0x00, 0xF5, 0x01, // ’õ (U+2019 U+00F5)
  0x20, 0x19, 0x00, 0xF6, 0x01, // ’ö (U+2019 U+00F6)
  0x20, 0x19, 0x00, 0xF8, 0x01, // ’ø (U+2019 U+00F8)
  0x20, 0x19, 0x01, 0x00, 0x01, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x02, 0x01, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x04, 0x01, // ’Ą (U+2019 U+0104)
  0x20, 0x19, 0x01, 0x07, 0x01, // ’ć (U+2019 U+0107)
  0x20, 0x19, 0x01, 0x09, 0x01, // ’ĉ (U+2019 U+0109)
  0x20, 0x19, 0x01, 0x0B, 0x01, // ’ċ (U+2019 U+010B)
  0x20, 0x19, 0x01, 0x0D, 0x01, // ’č (U+2019 U+010D)
  0x20, 0x19, 0x01, 0x0F, 0x01, // ’ď (U+2019 U+010F)
  0x20, 0x19, 0x01, 0x11, 0x01, // ’đ (U+2019 U+0111)
  0x20, 0x19, 0x01, 0x13, 0x01, // ’ē (U+2019 U+0113)
  0x20, 0x19, 0x01, 0x15, 0x01, // ’ĕ (U+2019 U+0115)
  0x20, 0x19, 0x01, 0x17, 0x01, // ’ė (U+2019 U+0117)
  0x20, 0x19, 0x01, 0x19, 0x01, // ’ę (U+2019 U+0119)
  0x20, 0x19, 0x01, 0x1B, 0x01, // ’ě (U+2019 U+011B)
  0x20, 0x19, 0x01, 0x4D, 0x01, // ’ō (U+2019 U+014D)
  0x20, 0x19, 0x01, 0x4F, 0x01, // ’ŏ (U+2019 U+014F)
  0x20, 0x19, 0x01, 0x51, 0x01, // ’ő (U+2019 U+0151)
  0x20, 0x19, 0x01, 0x53, 0x01, // ’œ (U+2019 U+0153)
  0x20, 0x1A, 0x00, 0x43, 0x01, // ‚C (U+201A U+0043)
  0x20, 0x1A, 0x00, 0x47, 0x01, // ‚G (U+201A U+0047)
  0x20, 0x1A, 0x00, 0x4F, 0x01, // ‚O (U+201A U+004F)
  0x20, 0x1A, 0x00, 0x51, 0x01, // ‚Q (U+201A U+0051)
  0x20, 0x1A, 0x00, 0x54, 0x01, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x56, 0x01, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x01, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x01, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0xC7, 0x01, // ‚Ç (U+201A U+00C7)
  0x20, 0x1A, 0x00, 0xD2, 0x01, // ‚Ò (U+201A U+00D2)
  0x20, 0x1A, 0x00, 0xD3, 0x01, // ‚Ó (U+201A U+00D3)
  0x20, 0x1A, 0x00, 0xD4, 0x01, // ‚Ô (U+201A U+00D4)
  0x20, 0x1A, 0x00, 0xD5, 0x01, // ‚Õ (U+201A U+00D5)
  0x20, 0x1A, 0x00, 0xD6, 0x01, // ‚Ö (U+201A U+00D6)
  0x20, 0x1A, 0x00, 0xD8, 0x01, // ‚Ø (U+201A U+00D8)
  0x20, 0x1A, 0x00, 0xDD, 0x01, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x01, 0x06, 0x01, // ‚Ć (U+201A U+0106)
  0x20, 0x1A, 0x01, 0x08, 0x01, // ‚Ĉ (U+201A U+0108)
  0x20, 0x1A, 0x01, 0x0A, 0x01, // ‚Ċ (U+201A U+010A)
  0x20, 0x1A, 0x01, 0x0C, 0x01, // ‚Č (U+201A U+010C)
  0x20, 0x1A, 0x01, 0x1C, 0x01, // ‚Ĝ (U+201A U+011C)
  0x20, 0x1A, 0x01, 0x1E, 0x01, // ‚Ğ (U+201A U+011E)
  0x20, 0x1A, 0x01, 0x20, 0x01, // ‚Ġ (U+201A U+0120)
  0x20, 0x1A, 0x01, 0x22, 0x01, // ‚Ģ (U+201A U+0122)
  0x20, 0x1A, 0x01, 0x4C, 0x01, // ‚Ō (U+201A U+014C)
  0x20, 0x1A, 0x01, 0x4E, 0x01, // ‚Ŏ (U+201A U+014E)
  0x20, 0x1A, 0x01, 0x50, 0x01, // ‚Ő (U+201A U+0150)
  0x20, 0x1A, 0x01, 0x52, 0x01, // ‚Œ (U+201A U+0152)
  0x20, 0x1A, 0x01, 0x62, 0x01, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x01, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x01, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1A, 0x01, 0x74, 0x01, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x76, 0x01, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x78, 0x01, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x01, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0x63, 0x01, // “c (U+201C U+0063)
  0x20, 0x1C, 0x00, 0x64, 0x01, // “d (U+201C U+0064)
  0x20, 0x1C, 0x00, 0x65, 0x01, // “e (U+201C U+0065)
  0x20, 0x1C, 0x00, 0x6F, 0x01, // “o (U+201C U+006F)
  0x20, 0x1C, 0x00, 0x71, 0x01, // “q (U+201C U+0071)
  0x20, 0x1C, 0x00, 0xC0, 0x01, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x01, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x01, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x01, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x01, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x01, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xC6, 0x01, // “Æ (U+201C U+00C6)
  0x20, 0x1C, 0x00, 0xE0, 0x01, // “à (U+201C U+00E0)
  0x20, 0x1C, 0x00, 0xE7, 0x01, // “ç (U+201C U+00E7)
  0x20, 0x1C, 0x00, 0xE8, 0x01, // “è (U+201C U+00E8)
  0x20, 0x1C, 0x00, 0xE9, 0x01, // “é (U+201C U+00E9)
  0x20, 0x1C, 0x00, 0xEA, 0x01, // “ê (U+201C U+00EA)
  0x20, 0x1C, 0x00, 0xEB, 0x01, // “ë (U+201C U+00EB)
  0x20, 0x1C, 0x00, 0xF2, 0x01, // “ò (U+201C U+00F2)
  0x20, 0x1C, 0x00, 0xF3, 0x01, // “ó (U+201C U+00F3)
  0x20, 0x1C, 0x00, 0xF4, 0x01, // “ô (U+201C U+00F4)
  0x20, 0x1C, 0x00, 0xF5, 0x01, // “õ (U+201C U+00F5)
  0x20, 0x1C, 0x00, 0xF6, 0x01, // “ö (U+201C U+00F6)
  0x20, 0x1C, 0x00, 0xF8, 0x01, // “ø (U+201C U+00F8)
  0x20, 0x1C, 0x01, 0x00, 0x01, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x02, 0x01, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x04, 0x01, // “Ą (U+201C U+0104)
  0x20, 0x1C, 0x01, 0x07, 0x01, // “ć (U+201C U+0107)
  0x20, 0x1C, 0x01, 0x09, 0x01, // “ĉ (U+201C U+0109)
  0x20, 0x1C, 0x01, 0x0B, 0x01, // “ċ (U+201C U+010B)
  0x20, 0x1C, 0x01, 0x0D, 0x01, // “č (U+201C U+010D)
  0x20, 0x1C, 0x01, 0x0F, 0x01, // “ď (U+201C U+010F)
  0x20, 0x1C, 0x01, 0x11, 0x01, // “đ (U+201C U+0111)
  0x20, 0x1C, 0x01, 0x13, 0x01, // “ē (U+201C U+0113)
  0x20, 0x1C, 0x01, 0x15, 0x01, // “ĕ (U+201C U+0115)
  0x20, 0x1C, 0x01, 0x17, 0x01, // “ė (U+201C U+0117)
  0x20, 0x1C, 0x01, 0x19, 0x01, // “ę (U+201C U+0119)
  0x20, 0x1C, 0x01, 0x1B, 0x01, // “ě (U+201C U+011B)
  0x20, 0x1C, 0x01, 0x4D, 0x01, // “ō (U+201C U+014D)
  0x20, 0x1C, 0x01, 0x4F, 0x01, // “ŏ (U+201C U+014F)
  0x20, 0x1C, 0x01, 0x51, 0x01, // “ő (U+201C U+0151)
  0x20, 0x1C, 0x01, 0x53, 0x01, // “œ (U+201C U+0153)
  0x20, 0x1D, 0x00, 0x41, 0x01, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0x63, 0x01, // ”c (U+201D U+0063)
  0x20, 0x1D, 0x00, 0x64, 0x01, // ”d (U+201D U+0064)
  0x20, 0x1D, 0x00, 0x65, 0x01, // ”e (U+201D U+0065)
  0x20, 0x1D, 0x00, 0x6F, 0x01, // ”o (U+201D U+006F)
  0x20, 0x1D, 0x00, 0x71, 0x01, // ”q (U+201D U+0071)
  0x20, 0x1D, 0x00, 0xC0, 0x01, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x01, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x01, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x01, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x01, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x01, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xC6, 0x01, // ”Æ (U+201D U+00C6)
  0x20, 0x1D, 0x00, 0xE0, 0x01, // ”à (U+201D U+00E0)
  0x20, 0x1D, 0x00, 0xE7, 0x01, // ”ç (U+201D U+00E7)
  0x20, 0x1D, 0x00, 0xE8, 0x01, // ”è (U+201D U+00E8)
  0x20, 0x1D, 0x00, 0xE9, 0x01, // ”é (U+201D U+00E9)
  0x20, 0x1D, 0x00, 0xEA, 0x01, // ”ê (U+201D U+00EA)
  0x20, 0x1D, 0x00, 0xEB, 0x01, // ”ë (U+201D U+00EB)
  0x20, 0x1D, 0x00, 0xF2, 0x01, // ”ò (U+201D U+00F2)
  0x20, 0x1D, 0x00, 0xF3, 0x01, // ”ó (U+201D U+00F3)
  0x20, 0x1D, 0x00, 0xF4, 0x01, // ”ô (U+201D U+00F4)
  0x20, 0x1D, 0x00, 0xF5, 0x01, // ”õ (U+201D U+00F5)
  0x20, 0x1D, 0x00, 0xF6, 0x01, // ”ö (U+201D U+00F6)
  0x20, 0x1D, 0x00, 0xF8, 0x01, // ”ø (U+201D U+00F8)
  0x20, 0x1D, 0x01, 0x00, 0x01, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x02, 0x01, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x04, 0x01, // ”Ą (U+201D U+0104)
  0x20, 0x1D, 0x01, 0x07, 0x01, // ”ć (U+201D U+0107)
  0x20, 0x1D, 0x01, 0x09, 0x01, // ”ĉ (U+201D U+0109)
  0x20, 0x1D, 0x01, 0x0B, 0x01, // ”ċ (U+201D U+010B)
  0x20, 0x1D, 0x01, 0x0D, 0x01, // ”č (U+201D U+010D)
  0x20, 0x1D, 0x01, 0x0F, 0x01, // ”ď (U+201D U+010F)
  0x20, 0x1D, 0x01, 0x11, 0x01, // ”đ (U+201D U+0111)
  0x20, 0x1D, 0x01, 0x13, 0x01, // ”ē (U+201D U+0113)
  0x20, 0x1D, 0x01, 0x15, 0x01, // ”ĕ (U+201D U+0115)
  0x20, 0x1D, 0x01, 0x17, 0x01, // ”ė (U+201D U+0117)
  0x20, 0x1D, 0x01, 0x19, 0x01, // ”ę (U+201D U+0119)
  0x20, 0x1D, 0x01, 0x1B, 0x01, // ”ě (U+201D U+011B)
  0x20, 0x1D, 0x01, 0x4D, 0x01, // ”ō (U+201D U+014D)
  0x20, 0x1D, 0x01, 0x4F, 0x01, // ”ŏ (U+201D U+014F)
  0x20, 0x1D, 0x01, 0x51, 0x01, // ”ő (U+201D U+0151)
  0x20, 0x1D, 0x01, 0x53, 0x01, // ”œ (U+201D U+0153)
  0x20, 0x1E, 0x00, 0x43, 0x01, // „C (U+201E U+0043)
  0x20, 0x1E, 0x00, 0x47, 0x01, // „G (U+201E U+0047)
  0x20, 0x1E, 0x00, 0x4F, 0x01, // „O (U+201E U+004F)
  0x20, 0x1E, 0x00, 0x51, 0x01, // „Q (U+201E U+0051)
  0x20, 0x1E, 0x00, 0x54, 0x01, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x56, 0x01, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x01, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x01, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0xC7, 0x01, // „Ç (U+201E U+00C7)
  0x20, 0x1E, 0x00, 0xD2, 0x01, // „Ò (U+201E U+00D2)
  0x20, 0x1E, 0x00, 0xD3, 0x01, // „Ó (U+201E U+00D3)
  0x20, 0x1E, 0x00, 0xD4, 0x01, // „Ô (U+201E U+00D4)
  0x20, 0x1E, 0x00, 0xD5, 0x01, // „Õ (U+201E U+00D5)
  0x20, 0x1E, 0x00, 0xD6, 0x01, // „Ö (U+201E U+00D6)
  0x20, 0x1E, 0x00, 0xD8, 0x01, // „Ø (U+201E U+00D8)
  0x20, 0x1E, 0x00, 0xDD, 0x01, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x01, 0x06, 0x01, // „Ć (U+201E U+0106)
  0x20, 0x1E, 0x01, 0x08, 0x01, // „Ĉ (U+201E U+0108)
  0x20, 0x1E, 0x01, 0x0A, 0x01, // „Ċ (U+201E U+010A)
  0x20, 0x1E, 0x01, 0x0C, 0x01, // „Č (U+201E U+010C)
  0x20, 0x1E, 0x01, 0x1C, 0x01, // „Ĝ (U+201E U+011C)
  0x20, 0x1E, 0x01, 0x1E, 0x01, // „Ğ (U+201E U+011E)
  0x20, 0x1E, 0x01, 0x20, 0x01, // „Ġ (U+201E U+0120)
  0x20, 0x1E, 0x01, 0x22, 0x01, // „Ģ (U+201E U+0122)
  0x20, 0x1E, 0x01, 0x4C, 0x01, // „Ō (U+201E U+014C)
  0x20, 0x1E, 0x01, 0x4E, 0x01, // „Ŏ (U+201E U+014E)
  0x20, 0x1E, 0x01, 0x50, 0x01, // „Ő (U+201E U+0150)
  0x20, 0x1E, 0x01, 0x52, 0x01, // „Œ (U+201E U+0152)
  0x20, 0x1E, 0x01, 0x62, 0x01, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x01, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x01, // „Ŧ (U+201E U+0166)
  0x20, 0x1E, 0x01, 0x74, 0x01, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x76, 0x01, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x78, 0x01, // „Ÿ (U+201E U+0178)
  0x20, 0x3A, 0x00, 0x54, 0x01, // ›T (U+203A U+0054)
  0x20, 0x3A, 0x00, 0x59, 0x01, // ›Y (U+203A U+0059)
  0x20, 0x3A, 0x00, 0xDD, 0x01, // ›Ý (U+203A U+00DD)
  0x20, 0x3A, 0x01, 0x62, 0x01, // ›Ţ (U+203A U+0162)
  0x20, 0x3A, 0x01, 0x64, 0x01, // ›Ť (U+203A U+0164)
  0x20, 0x3A, 0x01, 0x66, 0x01, // ›Ŧ (U+203A U+0166)
  0x20, 0x3A, 0x01, 0x76, 0x01, // ›Ŷ (U+203A U+0176)
  0x20, 0x3A, 0x01, 0x78, 0x01, // ›Ÿ (U+203A U+0178)
  
  // Glyph data
  // "!" (U+0021)
  0x2D, 0x1C, 0x1B, 0x0B, 0x0A, 0x09, 0x01, 0x2C,
  // """ (U+0022)
  0x48, 0x76, 0x37, 0x65, 0x25, 0x43,
  // "#" (U+0023)
  0x00, 0x91, 0x73, 0x00, 0x0B, 0x0A, 0x00, 0x4C, 0xEC, 0xEC, 0x20, 0x28, 0x0A, 0x00, 0x04, 0x62,
  0x80, 0x09, 0xDD, 0xDD, 0xA0, 0x09, 0x17, 0x30, 0x00, 0xA0, 0xA0, 0x00,
  // "$" (U+0024)
  0x00, 0x72, 0x00, 0x0A, 0xED, 0x90, 0x4A, 0x72, 0x10, 0x3C, 0x92, 0x00, 0x05, 0xDB, 0x30, 0x00,
  0x75, 0xD0, 0x11, 0x73, 0xC1, 0x3C, 0xEC, 0x50, 0x00, 0x72, 0x00,
  // "%" (U+0025)
  0x1C, 0xB0, 0x07, 0x40, 0x65, 0x65, 0x0A, 0x00, 0x73, 0x46, 0x74, 0x00, 0x55, 0x75, 0xB7, 0xC3,
  0x0B, 0xA7, 0x5B, 0x1A, 0x00, 0x0B, 0x19, 0x0B, 0x00, 0x74, 0x0A, 0x0A, 0x00, 0xB0, 0x08, 0xC4,
  // "&" (U+0026)
  0x04, 0xDD, 0x40, 0x00, 0xB2, 0x3B, 0x00, 0x09, 0x57, 0x80, 0x00, 0x2F, 0xA0, 0x00, 0x1D, 0x9E,
  0x22, 0xA6, 0x80, 0x4D, 0xA5, 0x59, 0x00, 0x9F, 0x10, 0xAC, 0xD8, 0x5C,
  // "'" (U+0027)
  0x48, 0x37, 0x25,
  // "(" (U+0028)
  0x06, 0x60, 0xD0, 0x49, 0x07, 0x60, 0x84, 0x08, 0x50, 0x67, 0x02, 0xB0, 0x0B, 0x20, 0x24,
  // ")" (U+0029)
  0x66, 0x00, 0xD0, 0x09, 0x40, 0x67, 0x05, 0x80, 0x58, 0x07, 0x60, 0xB2, 0x2B, 0x04, 0x20,
  // "*" (U+002A)
  0x00, 0xB2, 0x03, 0x39, 0x25, 0x49, 0xEB, 0x90, 0x49, 0xB0, 0x09, 0x28, 0x20,
  // "+" (U+002B)
  0x00, 0x83, 0x00, 0x00, 0x83, 0x00, 0x6C, 0xDD, 0xC2, 0x00, 0x83, 0x00, 0x00, 0x83, 0x00,
  // "," (U+002C)
  0x2A, 0x49, 0x73,
  // "-" (U+002D)
  0x7C, 0xA0,
  // "." (U+002E)
  0x01, 0x2C,
  // "/" (U+002F)
  0x00, 0x67, 0x00, 0xB1, 0x01, 0xB0, 0x06, 0x70, 0x0B, 0x10, 0x1B, 0x00, 0x67, 0x00, 0xB1, 0x00,
  // "0" (U+0030)
  0x07, 0xDC, 0x30, 0x2C, 0x02, 0xC0, 0x67, 0x00, 0xC1, 0x76, 0x00, 0xA2, 0x76, 0x00, 0xA3, 0x57,
  0x00, 0xC1, 0x1C, 0x02, 0xC0, 0x06, 0xDC, 0x30,
  // "1" (U+0031)
  0x0B, 0x8B, 0x98, 0x14, 0x80, 0x48, 0x04, 0x80, 0x48, 0x04, 0x80, 0x48,
  // "2" (U+0032)
  0x1A, 0xCC, 0x30, 0x14, 0x02, 0xC0, 0x00, 0x00, 0xC0, 0x00, 0x06, 0x80, 0x00, 0x2C, 0x00, 0x01,
  0xC2, 0x00, 0x0B, 0x30, 0x00, 0x7E, 0xCC, 0xC2,
  // "3" (U+0033)
  0x2B, 0xCC, 0x50, 0x11, 0x01, 0xD0, 0x00, 0x04, 0xB0, 0x05, 0xDD, 0x20, 0x00, 0x03, 0xD0, 0x00,
  0x00, 0xC1, 0x20, 0x02, 0xD0, 0x5D, 0xCC, 0x40,
  // "4" (U+0034)
  0x00, 0x0B, 0x70, 0x00, 0x6B, 0x70, 0x02, 0xB5, 0x70, 0x0A, 0x25, 0x70, 0x66, 0x05, 0x70, 0xBD,
  0xDE, 0xE6, 0x00, 0x05, 0x70, 0x00, 0x05, 0x70,
  // "5" (U+0035)
  0x18, 0x2E, 0xCC, 0x82, 0x0B, 0x40, 0x10, 0xA4, 0x83, 0x2E, 0xCB, 0x34, 0x02, 0x0D, 0x58, 0x1C,
  0x11, 0x28, 0x61, 0xD0, 0x3C, 0xCC, 0x31,
  // "6" (U+0036)
  0x02, 0xBC, 0x80, 0x0C, 0x40, 0x00, 0x2A, 0x00, 0x00, 0x59, 0xBC, 0x50, 0x6B, 0x00, 0xD1, 0x57,
  0x00, 0xA3, 0x1C, 0x00, 0xC1, 0x05, 0xCC, 0x50,
  // "7" (U+0037)
  0x84, 0x6C, 0xCC, 0xE3, 0x40, 0xD4, 0x06, 0x07, 0x40, 0xC0, 0x13, 0x03, 0x0B, 0x40, 0x90, 0x53,
  0x01, 0x0D, 0x40, 0x60, 0x83,
  // "8" (U+0038)
  0x08, 0xCC, 0x50, 0x3B, 0x01, 0xD0, 0x2B, 0x01, 0xC0, 0x07, 0xCC, 0x20, 0x0B, 0x6A, 0x80, 0x66,
  0x00, 0xB1, 0x68, 0x00, 0xC1, 0x0A, 0xCC, 0x60,
  // "9" (U+0039)
  0x09, 0xCC, 0x30, 0x4A, 0x02, 0xC0, 0x76, 0x00, 0xB1, 0x5A, 0x02, 0xE2, 0x08, 0xC9, 0xB1, 0x00,
  0x00, 0xD0, 0x00, 0x07, 0x80, 0x0C, 0xD9, 0x00,
  // ":" (U+003A)
  0x2C, 0x2A, 0x00, 0x00, 0x01, 0x2C,
  // ";" (U+003B)
  0x3C, 0x29, 0x00, 0x00, 0x00, 0x4B, 0x66, 0x71,
  // "<" (U+003C)
  0x00, 0x03, 0xA2, 0x03, 0xA7, 0x10, 0x5D, 0x20, 0x00, 0x03, 0x99, 0x30, 0x00, 0x01, 0x82,
  // "=" (U+003D)
  0x5C, 0xCC, 0xC1, 0x00, 0x00, 0x00, 0x5C, 0xCC, 0xC1,
  // ">" (U+003E)
  0x81, 0x58, 0x14, 0x82, 0x29, 0x81, 0x48, 0x91, 0x5E, 0x10, 0x5A, 0x81, 0x05, 0x64,
  // "?" (U+003F)
  0x8C, 0xC6, 0x20, 0x0D, 0x00, 0x0D, 0x00, 0x97, 0x05, 0x90, 0x08, 0x10, 0x01, 0x00, 0x0A, 0x40,
  // "@" (U+0040)
  0x00, 0x4B, 0xCC, 0x80, 0x00, 0x5A, 0x10, 0x05, 0xA0, 0x0B, 0x08, 0xCC, 0x29, 0x24, 0x72, 0xA0,
  0x82, 0x55, 0x65, 0x56, 0x09, 0x25, 0x55, 0x64, 0x80, 0xC3, 0x92, 0x2A, 0x0A, 0xB3, 0xC7, 0x00,
  0x97, 0x00, 0x01, 0x00, 0x00, 0x7C, 0xCB, 0x30, 0x00,
  // "A" (U+0041)
  0x00, 0x5B, 0x00, 0x00, 0x0B, 0xD1, 0x00, 0x01, 0xD7, 0x70, 0x00, 0x68, 0x2C, 0x00, 0x0C, 0x30,
  0xD2, 0x02, 0xFD, 0xDE, 0x70, 0x78, 0x00, 0x2D, 0x0C, 0x10, 0x00, 0xB3,
  // "B" (U+0042)
  0xFC, 0xCB, 0x2D, 0x00, 0x5A, 0xD0, 0x06, 0x8F, 0xCD, 0xC1, 0xD0, 0x05, 0xBD, 0x00, 0x0E, 0xD0,
  0x04, 0xBF, 0xCC, 0xB2,
  // "C" (U+0043)
  0x28, 0x59, 0xDC, 0xA0, 0xB7, 0x28, 0x11, 0x2C, 0x40, 0x50, 0x94, 0x05, 0x09, 0x40, 0x30, 0xC5,
  0x0C, 0x06, 0x48, 0x31, 0xAD, 0xC9,
  // "D" (U+0044)
  0xFC, 0xDB, 0x30, 0xD0, 0x03, 0xD1, 0xD0, 0x00, 0x77, 0xD0, 0x00, 0x5A, 0xD0, 0x00, 0x59, 0xD0,
  0x00, 0x86, 0xD0, 0x04, 0xD1, 0xFC, 0xDB, 0x20,
  // "E" (U+0045)
  0xFC, 0xCB, 0xD0, 0x00, 0xD0, 0x00, 0xFC, 0xC9, 0xD0, 0x00, 0xD0, 0x00, 0xD0, 0x00, 0xFC, 0xCB,
  // "F" (U+0046)
  0x98, 0x2C, 0xCB, 0xD3, 0x0D, 0x30, 0xD3, 0x98, 0x2C, 0xC9, 0xD3, 0x0D, 0x30, 0xD3,
  // "G" (U+0047)
  0x00, 0x8C, 0xCC, 0x30, 0xA7, 0x00, 0x10, 0x2C, 0x00, 0x00, 0x05, 0x90, 0x00, 0x00, 0x59, 0x00,
  0xBD, 0x72, 0xC0, 0x00, 0x58, 0x0B, 0x60, 0x05, 0x80, 0x1A, 0xDC, 0xC6,
  // "H" (U+0048)
  0xD0, 0x00, 0x76, 0xD0, 0x00, 0x76, 0xD0, 0x00, 0x76, 0xFC, 0xCC, 0xD6, 0xD0, 0x00, 0x76, 0xD0,
  0x00, 0x76, 0xD0, 0x00, 0x76, 0xD0, 0x00, 0x76,
  // "I" (U+0049)
  0x6E, 0xB0, 0xB2, 0x0B, 0x20, 0xB2, 0x0B, 0x20, 0xB2, 0x0B, 0x25, 0xEB,
  // "J" (U+004A)
  0x01, 0xC0, 0x1C, 0x01, 0xC0, 0x1C, 0x01, 0xC0, 0x1C, 0x01, 0xC0, 0x1C, 0x04, 0xA9, 0xB2,
  // "K" (U+004B)
  0xD0, 0x05, 0xAD, 0x03, 0xC0, 0xD1, 0xC2, 0x0D, 0xB6, 0x00, 0xF7, 0xD0, 0x0D, 0x08, 0x80, 0xD0,
  0x0C, 0x3D, 0x00, 0x3C,
  // "L" (U+004C)
  0x0D, 0x30, 0xD3, 0x0D, 0x30, 0xD3, 0x0D, 0x30, 0xD3, 0x0D, 0x39, 0x0F, 0xD0,
  // "M" (U+004D)
  0xF7, 0x00, 0x06, 0xF1, 0xDC, 0x00, 0x0B, 0xC1, 0xCB, 0x20, 0x1B, 0xC1, 0xC6, 0x70, 0x66, 0xC1,
  0xC1, 0xC0, 0xB1, 0xC1, 0xC0, 0xB3, 0xA0, 0xC1, 0xC0, 0x5D, 0x50, 0xC1, 0xC0, 0x1E, 0x00, 0xC1,
  // "N" (U+004E)
  0xF5, 0x00, 0x39, 0xDD, 0x10, 0x39, 0xB9, 0x90, 0x39, 0xC1, 0xE4, 0x39, 0xC0, 0x6D, 0x39, 0xC0,
  0x0D, 0xB9, 0xC0, 0x04, 0xF9, 0xC0, 0x00, 0xB9,
  // "O" (U+004F)
  0x01, 0xAC, 0xD9, 0x00, 0x0C, 0x50, 0x08, 0x90, 0x3C, 0x00, 0x00, 0xE0, 0x59, 0x00, 0x00, 0xC2,
  0x59, 0x00, 0x00, 0xC2, 0x3C, 0x00, 0x00, 0xE0, 0x0C, 0x50, 0x08, 0x90, 0x01, 0xAC, 0xD9, 0x00,
  // "P" (U+0050)
  0x98, 0x3C, 0xC9, 0x0D, 0x28, 0x1A, 0x5D, 0x28, 0x16, 0x7D, 0x28, 0x6B, 0x4F, 0xCC, 0x60, 0xD4,
  0x0D, 0x40, 0xD4,
  // "Q" (U+0051)
  0x18, 0x31, 0xAC, 0xD9, 0x30, 0xC0, 0x52, 0x83, 0x89, 0x03, 0xC4, 0x82, 0xE0, 0x59, 0x48, 0x2C,
  0x25, 0x94, 0x82, 0xC2, 0x3C, 0x40, 0xE2, 0x0C, 0x05, 0x20, 0x80, 0x92, 0x83, 0x1A, 0xCE, 0x96,
  0x07, 0x09, 0x70, 0xB0, 0x61,
  // "R" (U+0052)
  0xFC, 0xC9, 0x0D, 0x00, 0x95, 0xD0, 0x06, 0x7D, 0x00, 0xB4, 0xFC, 0xE7, 0x0D, 0x05, 0x90, 0xD0,
  0x0C, 0x3D, 0x00, 0x4B,
  // "S" (U+0053)
  0x08, 0xCD, 0x84, 0xA0, 0x01, 0x5A, 0x00, 0x00, 0xBB, 0x30, 0x00, 0x5D, 0x70, 0x00, 0x0D, 0x10,
  0x01, 0xC5, 0xDC, 0xB3,
  // "T" (U+0054)
  0x84, 0xBC, 0xED, 0xC5, 0x20, 0xA0, 0x34, 0x0A, 0x03, 0x40, 0xA0, 0x34, 0x0A, 0x03, 0x40, 0xA0,
  0x34, 0x0A, 0x03, 0x40, 0xA0, 0x32,
  // "U" (U+0055)
  0x1C, 0x00, 0x07, 0x61, 0xC0, 0x00, 0x76, 0x1C, 0x00, 0x07, 0x61, 0xC0, 0x00, 0x76, 0x1C, 0x00,
  0x07, 0x60, 0xD0, 0x00, 0x85, 0x0B, 0x30, 0x1C, 0x10, 0x2B, 0xCC, 0x50,
  // "V" (U+0056)
  0xC1, 0x00, 0x1C, 0x86, 0x00, 0x68, 0x3B, 0x00, 0xB3, 0x0D, 0x01, 0xD0, 0x08, 0x55, 0x80, 0x03,
  0xAA, 0x30, 0x00, 0xCC, 0x00, 0x00, 0x99, 0x00,
  // "W" (U+0057)
  0xB2, 0x00, 0xE3, 0x00, 0xD8, 0x60, 0x3D, 0x70, 0x1C, 0x49, 0x07, 0x6B, 0x05, 0x80, 0xD0, 0xB1,
  0xC0, 0x85, 0x0C, 0x1C, 0x08, 0x4C, 0x10, 0x98, 0x80, 0x48, 0xC0, 0x05, 0xD4, 0x00, 0xD9, 0x00,
  0x1F, 0x10, 0x0C, 0x50,
  // "X" (U+0058)
  0x87, 0x00, 0x95, 0x0D, 0x12, 0xB0, 0x05, 0x8A, 0x30, 0x00, 0xCA, 0x00, 0x00, 0xCC, 0x00, 0x08,
  0x59, 0x50, 0x2C, 0x01, 0xD0, 0xA4, 0x00, 0x78,
  // "Y" (U+0059)
  0xB3, 0x00, 0x96, 0x4B, 0x02, 0xD0, 0x0C, 0x49, 0x60, 0x05, 0xDE, 0x00, 0x00, 0xD7, 0x00, 0x00,
  0x94, 0x00, 0x00, 0x94, 0x00, 0x00, 0x94, 0x00,
  // "Z" (U+005A)
  0x6C, 0xCC, 0xF3, 0x00, 0x04, 0xB0, 0x00, 0x0C, 0x30, 0x00, 0x69, 0x00, 0x01, 0xD1, 0x00, 0x09,
  0x70, 0x00, 0x2D, 0x00, 0x00, 0x9E, 0xCC, 0xC4,
  // "[" (U+005B)
  0x3E, 0xC3, 0xA0, 0x3A, 0x03, 0xA0, 0x3A, 0x03, 0xA0, 0x3A, 0x03, 0xA0, 0x3A, 0x02, 0xDC,
  // "\" (U+005C)
  0xB1, 0x00, 0x67, 0x00, 0x1B, 0x00, 0x0B, 0x10, 0x06, 0x70, 0x01, 0xC0, 0x00, 0xB1, 0x00, 0x67,
  // "]" (U+005D)
  0x9D, 0x70, 0x57, 0x05, 0x70, 0x57, 0x05, 0x70, 0x57, 0x05, 0x70, 0x57, 0x05, 0x79, 0xC6,
  // "^" (U+005E)
  0x00, 0xB3, 0x00, 0x02, 0xAA, 0x00, 0x08, 0x28, 0x20, 0x0A, 0x02, 0x90, 0x65, 0x00, 0xA1,
  // "_" (U+005F)
  0xCC, 0xCC, 0x50,
  // "`" (U+0060)
  0x5A, 0x00, 0x93,
  // "a" (U+0061)
  0x09, 0xCD, 0x40, 0x00, 0x2B, 0x08, 0xCC, 0xC6, 0x90, 0x1C, 0x77, 0x05, 0xC1, 0xCC, 0x7B,
  // "b" (U+0062)
  0x2B, 0x00, 0x00, 0x2B, 0x00, 0x00, 0x2B, 0xAC, 0x90, 0x2E, 0x10, 0xA5, 0x2C, 0x00, 0x58, 0x2C,
  0x00, 0x58, 0x2E, 0x10, 0xA5, 0x2A, 0xAC, 0x90,
  // "c" (U+0063)
  0x06, 0xCD, 0x42, 0xC0, 0x00, 0x67, 0x00, 0x06, 0x70, 0x00, 0x3C, 0x00, 0x00, 0x7C, 0xC4,
  // "d" (U+0064)
  0x00, 0x00, 0x94, 0x00, 0x00, 0x94, 0x07, 0xCB, 0xA4, 0x2C, 0x00, 0xD4, 0x67, 0x00, 0x94, 0x67,
  0x00, 0x94, 0x3C, 0x00, 0xD4, 0x08, 0xCB, 0x94,
  // "e" (U+0065)
  0x06, 0xCC, 0x40, 0x2A, 0x00, 0xD0, 0x6D, 0xCC, 0xD1, 0x68, 0x00, 0x00, 0x2D, 0x10, 0x10, 0x06,
  0xDC, 0xA0,
  // "f" (U+0066)
  0x18, 0x36, 0xD9, 0x0D, 0x28, 0x48, 0xFC, 0x30, 0xD3, 0x0D, 0x30, 0xD3, 0x0D, 0x30, 0xD2,
  // "g" (U+0067)
  0x07, 0xCB, 0x94, 0x2C, 0x00, 0xD4, 0x67, 0x00, 0x94, 0x67, 0x00, 0x94, 0x3C, 0x00, 0xC4, 0x07,
  0xCB, 0xA4, 0x00, 0x00, 0x94, 0x01, 0x00, 0xD1, 0x0C, 0xCC, 0x60,
  // "h" (U+0068)
  0x2B, 0x00, 0x00, 0x2B, 0x00, 0x00, 0x2B, 0xAC, 0xA0, 0x2E, 0x10, 0xA4, 0x2C, 0x00, 0x75, 0x2B,
  0x00, 0x75, 0x2B, 0x00, 0x75, 0x2B, 0x00, 0x75,
  // "i" (U+0069)
  0x17, 0x00, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
  // "j" (U+006A)
  0x01, 0x70, 0x00, 0x02, 0xB0, 0x2B, 0x02, 0xB0, 0x2B, 0x02, 0xB0, 0x2B, 0x02, 0xB0, 0x3A, 0x6D,
  0x40,
  // "k" (U+006B)
  0x2B, 0x00, 0x02, 0xB0, 0x00, 0x2B, 0x05, 0xA2, 0xB3, 0xC0, 0x2C, 0xD2, 0x02, 0xE9, 0x80, 0x2B,
  0x0C, 0x32, 0xB0, 0x2D,
  // "l" (U+006C)
  0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
  // "m" (U+006D)
  0x2A, 0xAC, 0x77, 0xBC, 0x12, 0xE1, 0x0D, 0x60, 0x77, 0x2B, 0x00, 0xB2, 0x05, 0x82, 0xB0, 0x0B,
  0x10, 0x58, 0x2B, 0x00, 0xB1, 0x05, 0x82, 0xB0, 0x0B, 0x10, 0x58,
  // "n" (U+006E)
  0x2A, 0xAC, 0xA0, 0x2E, 0x10, 0xA4, 0x2C, 0x00, 0x75, 0x2B, 0x00, 0x75, 0x2B, 0x00, 0x75, 0x2B,
  0x00, 0x75,
  // "o" (U+006F)
  0x06, 0xCC, 0x70, 0x2C, 0x00, 0xB3, 0x67, 0x00, 0x77, 0x67, 0x00, 0x76, 0x2C, 0x00, 0xB3, 0x06,
  0xCC, 0x60,
  // "p" (U+0070)
  0x2A, 0xAC, 0x90, 0x2E, 0x10, 0xA5, 0x2B, 0x00, 0x58, 0x2C, 0x00, 0x68, 0x2E, 0x10, 0xA5, 0x2C,
  0xAC, 0x90, 0x2B, 0x00, 0x00, 0x2B, 0x00, 0x00, 0x2B, 0x00, 0x00,
  // "q" (U+0071)
  0x07, 0xCB, 0x94, 0x2C, 0x00, 0xD4, 0x67, 0x00, 0x94, 0x67, 0x00, 0x94, 0x3C, 0x00, 0xC4, 0x07,
  0xCB, 0xA4, 0x00, 0x00, 0x94, 0x00, 0x00, 0x94, 0x00, 0x00, 0x94,
  // "r" (U+0072)
  0x29, 0xAB, 0x2F, 0x20, 0x2C, 0x00, 0x2B, 0x00, 0x2B, 0x00, 0x2B, 0x00,
  // "s" (U+0073)
  0x1B, 0xCC, 0x16, 0x60, 0x00, 0x2C, 0x71, 0x00, 0x06, 0xD1, 0x10, 0x09, 0x45, 0xDC, 0xA0,
  // "t" (U+0074)
  0x04, 0x00, 0x0B, 0x00, 0x9E, 0xC4, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x0D, 0x00, 0x09, 0xD4,
  // "u" (U+0075)
  0x3A, 0x00, 0x85, 0x3A, 0x00, 0x85, 0x3A, 0x00, 0x85, 0x3A, 0x00, 0x95, 0x1C, 0x00, 0xD5, 0x09,
  0xDB, 0x95,
  // "v" (U+0076)
  0xC1, 0x00, 0xD7, 0x60, 0x58, 0x2B, 0x0A, 0x30, 0xC1, 0xD0, 0x07, 0xA8, 0x00, 0x2F, 0x30,
  // "w" (U+0077)
  0xB2, 0x0A, 0x80, 0x49, 0x85, 0x0B, 0xC0, 0x75, 0x49, 0x38, 0xB1, 0xB2, 0x0C, 0x74, 0x75, 0xD0,
  0x0C, 0xB0, 0x2B, 0x90, 0x08, 0xB0, 0x0D, 0x60,
  // "x" (U+0078)
  0x68, 0x04, 0xA0, 0xB3, 0xC1, 0x02, 0xE6, 0x00, 0x3E, 0x70, 0x0C, 0x2C, 0x27, 0x70, 0x3B,
  // "y" (U+0079)
  0xC1, 0x00, 0xD7, 0x60, 0x49, 0x2B, 0x09, 0x40, 0xC1, 0xD0, 0x06, 0x99, 0x00, 0x1E, 0x40, 0x00,
  0xD0, 0x00, 0x59, 0x00, 0xAC, 0x10, 0x00,
  // "z" (U+007A)
  0x5C, 0xCE, 0x30, 0x03, 0xB0, 0x00, 0xC2, 0x00, 0x77, 0x00, 0x1C, 0x00, 0x08, 0xDC, 0xC3,
  // "{" (U+007B)
  0x01, 0xC6, 0x07, 0x70, 0x07, 0x50, 0x09, 0x40, 0x9B, 0x00, 0x0A, 0x40, 0x07, 0x50, 0x07, 0x50,
  0x06, 0x80, 0x00, 0xA5,
  // "|" (U+007C)
  0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91,
  // "}" (U+007D)
  0x9A, 0x00, 0x09, 0x40, 0x08, 0x40, 0x07, 0x60, 0x01, 0xD7, 0x07, 0x70, 0x08, 0x40, 0x08, 0x40,
  0x0B, 0x30, 0x88, 0x00,
  // "~" (U+007E)
  0x3C, 0xA4, 0x42, 0x40, 0x3B, 0xA0,
  // "¡" (U+00A1)
  0x2C, 0x01, 0x09, 0x0A, 0x0B, 0x1B, 0x2C, 0x2D,
  // "¢" (U+00A2)
  0x02, 0x80, 0x2B, 0xD8, 0xC3, 0x01, 0xD0, 0x00, 0xD0, 0x00, 0xC3, 0x01, 0x2B, 0xD8, 0x02, 0x80,
  // "£" (U+00A3)
  0x01, 0xBC, 0xB0, 0x08, 0x50, 0x10, 0x0A, 0x30, 0x00, 0x0A, 0x20, 0x00, 0x8E, 0xCC, 0x20, 0x0A,
  0x20, 0x00, 0x0C, 0x10, 0x00, 0x9E, 0xCC, 0xC4,
  // "¤" (U+00A4)
  0x01, 0x00, 0x12, 0xCC, 0xCC, 0x0B, 0x02, 0x91, 0x90, 0x0A, 0x0B, 0x13, 0x92, 0xBC, 0xBB,
  // "¥" (U+00A5)
  0x94, 0x00, 0x94, 0x2C, 0x02, 0xC0, 0x0A, 0x5A, 0x50, 0x02, 0xDC, 0x00, 0x1C, 0xED, 0x90, 0x00,
  0x94, 0x00, 0x1C, 0xED, 0x90, 0x00, 0x94, 0x00,
  // "¦" (U+00A6)
  0x91, 0x91, 0x91, 0x91, 0x00, 0x00, 0x00, 0x91, 0x91, 0x91, 0x91,
  // "§" (U+00A7)
  0x0B, 0xCC, 0x23, 0xA0, 0x00, 0x0C, 0xB4, 0x03, 0x91, 0xA4, 0x2B, 0x27, 0x40, 0x29, 0xD1, 0x00,
  0x07, 0x64, 0xCC, 0xB1,
  // "¨" (U+00A8)
  0x43, 0x62,
  // "©" (U+00A9)
  0x00, 0x58, 0x97, 0x00, 0x07, 0x4A, 0xC7, 0x90, 0x36, 0x76, 0x00, 0x27, 0x71, 0x92, 0x00, 0x09,
  0x72, 0x75, 0x00, 0x09, 0x36, 0x1A, 0xC4, 0x27, 0x08, 0x40, 0x02, 0xA0, 0x00, 0x59, 0x97, 0x00,
  // "ª" (U+00AA)
  0x27, 0xA0, 0x67, 0xB1, 0x77, 0xB1,
  // "«" (U+00AB)
  0x02, 0x52, 0x51, 0xB2, 0xB1, 0x68, 0x78, 0x00, 0xA4, 0xA3, 0x00, 0x20, 0x20,
  // "¬" (U+00AC)
  0x6C, 0xCC, 0xD2, 0x00, 0x00, 0x83, 0x00, 0x00, 0x72,
  // "®" (U+00AE)
  0x00, 0x58, 0x97, 0x00, 0x07, 0x6D, 0xC6, 0x90, 0x36, 0x38, 0x39, 0x27, 0x71, 0x3E, 0xE2, 0x09,
  0x72, 0x38, 0x84, 0x09, 0x36, 0x38, 0x1B, 0x27, 0x08, 0x50, 0x03, 0xA0, 0x00, 0x59, 0x97, 0x00,
  // "¯" (U+00AF)
  0x80, 0x1C,
  // "°" (U+00B0)
  0x0A, 0xB2, 0x55, 0x19, 0x55, 0x19, 0x0A, 0xB2,
  // "±" (U+00B1)
  0x00, 0x83, 0x00, 0x00, 0x83, 0x00, 0x6C, 0xDD, 0xC2, 0x00, 0x83, 0x00, 0x00, 0x83, 0x00, 0x6C,
  0xCC, 0xC2,
  // "²" (U+00B2)
  0x4B, 0x91, 0x0B, 0x02, 0x82, 0x90, 0xAB, 0xB0,
  // "³" (U+00B3)
  0x6B, 0x90, 0x10, 0xB0, 0x2C, 0xA0, 0x00, 0x92, 0x8B, 0x90,
  // "´" (U+00B4)
  0x0D, 0x26, 0x60,
  // "µ" (U+00B5)
  0x2B, 0x00, 0x75, 0x2B, 0x00, 0x75, 0x2B, 0x00, 0x75, 0x2B, 0x00, 0x85, 0x2D, 0x00, 0xC5, 0x2D,
  0xCB, 0x95, 0x2B, 0x00, 0x00, 0x2B, 0x00, 0x00, 0x2B, 0x00, 0x00,
  // "¶" (U+00B6)
  0x09, 0xFF, 0xC7, 0x4F, 0xFD, 0x17, 0x6F, 0xFD, 0x17, 0x6F, 0xFD, 0x17, 0x2F, 0xFD, 0x17, 0x03,
  0x8B, 0x17, 0x00, 0x09, 0x17, 0x00, 0x09, 0x17, 0x00, 0x09, 0x17, 0x00, 0x07, 0x15,
  // "·" (U+00B7)
  0x01, 0x2C,
  // "¸" (U+00B8)
  0x24, 0x1B, 0x89,
  // "¹" (U+00B9)
  0x2B, 0x61, 0x56, 0x04, 0x60, 0x46,
  // "º" (U+00BA)
  0x39, 0x91, 0x90, 0x36, 0x81, 0x45, 0x18, 0x70,
  // "»" (U+00BB)
  0x43, 0x43, 0x01, 0xB3, 0xB1, 0x06, 0x87, 0x72, 0xB3, 0xB0, 0x21, 0x21, 0x00,
  // "¼" (U+00BC)
  0x2C, 0x50, 0x09, 0x10, 0x35, 0x50, 0x38, 0x00, 0x05, 0x50, 0xA1, 0x00, 0x05, 0x54, 0x74, 0xB0,
  0x05, 0x5A, 0x1A, 0xB0, 0x00, 0x55, 0x73, 0xB0, 0x00, 0xB0, 0xBA, 0xE3, 0x07, 0x40, 0x00, 0xB0,
  // "½" (U+00BD)
  0x3D, 0x30, 0x0A, 0x00, 0x47, 0x30, 0x83, 0x00, 0x07, 0x31, 0x90, 0x00, 0x07, 0x39, 0x4B, 0xB0,
  0x07, 0x68, 0x10, 0x83, 0x00, 0xA1, 0x00, 0x90, 0x04, 0x70, 0x09, 0x10, 0x09, 0x00, 0x7C, 0xC3,
  // "¾" (U+00BE)
  0x6A, 0x80, 0x02, 0x70, 0x10, 0xB0, 0x0A, 0x10, 0x1A, 0xA0, 0x37, 0x00, 0x10, 0x91, 0xA1, 0xD1,
  0x8A, 0x85, 0x67, 0xB1, 0x00, 0x0A, 0x27, 0x91, 0x00, 0x74, 0x7A, 0xD8, 0x01, 0xA0, 0x00, 0x91,
  // "¿" (U+00BF)
  0x04, 0xA0, 0x00, 0x10, 0x01, 0x80, 0x09, 0x50, 0x79, 0x00, 0xD0, 0x00, 0xD0, 0x02, 0x6C, 0xC8,
  // "À" (U+00C0)
  0x10, 0x50, 0xA6, 0x09, 0x03, 0x75, 0x05, 0x0B, 0x58, 0x1B, 0xD1, 0x38, 0x21, 0xD7, 0x73, 0x82,
  0x68, 0x2C, 0x38, 0x95, 0xC3, 0x0D, 0x20, 0x2F, 0xDD, 0xE7, 0x07, 0x82, 0x83, 0x2D, 0x0C, 0x13,
  0x0B, 0x03,
  // "Á" (U+00C1)
  0x30, 0xD0, 0x24, 0x00, 0x67, 0x50, 0x50, 0xB5, 0x81, 0xBD, 0x13, 0x82, 0x1D, 0x77, 0x38, 0x26,
  0x82, 0xC3, 0x89, 0x5C, 0x30, 0xD2, 0x02, 0xFD, 0xDE, 0x70, 0x78, 0x28, 0x32, 0xD0, 0xC1, 0x30,
  0xB0, 0x30,
  // "Â" (U+00C2)
  0x20, 0xA0, 0xC4, 0x82, 0x57, 0x57, 0x74, 0x05, 0x0B, 0x58, 0x1B, 0xD1, 0x38, 0x21, 0xD7, 0x73,
  0x82, 0x68, 0x2C, 0x38, 0x95, 0xC3, 0x0D, 0x20, 0x2F, 0xDD, 0xE7, 0x07, 0x82, 0x83, 0x2D, 0x0C,
  0x13, 0x0B, 0x03,
  // "Ã" (U+00C3)
  0x18, 0x22, 0xC5, 0x83, 0x82, 0x71, 0x98, 0x74, 0x05, 0x0B, 0x58, 0x1B, 0xD1, 0x38, 0x21, 0xD7,
  0x73, 0x82, 0x68, 0x2C, 0x38, 0x95, 0xC3, 0x0D, 0x20, 0x2F, 0xDD, 0xE7, 0x07, 0x82, 0x83, 0x2D,
  0x0C, 0x13, 0x0B, 0x03,
  // "Ä" (U+00C4)
  0x18, 0x24, 0x36, 0x27, 0x40, 0x50, 0xB5, 0x81, 0xBD, 0x13, 0x82, 0x1D, 0x77, 0x38, 0x26, 0x82,
  0xC3, 0x89, 0x5C, 0x30, 0xD2, 0x02, 0xFD, 0xDE, 0x70, 0x78, 0x28, 0x32, 0xD0, 0xC1, 0x30, 0xB0,
  0x30,
  // "Å" (U+00C5)
  0x00, 0x39, 0x30, 0x00, 0x08, 0x08, 0x00, 0x00, 0x9F, 0x30, 0x00, 0x0B, 0xD1, 0x00, 0x01, 0xD7,
  0x70, 0x00, 0x68, 0x2C, 0x00, 0x0C, 0x30, 0xD2, 0x02, 0xFD, 0xDE, 0x70, 0x78, 0x00, 0x2D, 0x0C,
  0x10, 0x00, 0xB3,
  // "Æ" (U+00C6)
  0x00, 0x0C, 0xDD, 0xCC, 0x20, 0x04, 0xA8, 0x60, 0x00, 0x00, 0xA4, 0x86, 0x00, 0x00, 0x1D, 0x08,
  0xDC, 0xC0, 0x08, 0x80, 0x86, 0x00, 0x00, 0xEC, 0xCD, 0x60, 0x00, 0x5A, 0x00, 0x86, 0x00, 0x0C,
  0x20, 0x08, 0xDC, 0xC2,
  // "Ç" (U+00C7)
  0x28, 0x59, 0xDC, 0xA0, 0xB7, 0x28, 0x11, 0x2C, 0x40, 0x50, 0x94, 0x05, 0x09, 0x40, 0x30, 0xC5,
  0x0C, 0x06, 0x48, 0x31, 0xAD, 0xC9, 0x30, 0x20, 0x44, 0x01, 0x0B, 0x40, 0x80, 0x91,
  // "È" (U+00C8)
  0x05, 0x0A, 0x30, 0x90, 0x35, 0x98, 0x2C, 0xCB, 0xD3, 0x0D, 0x39, 0x82, 0xCC, 0x9D, 0x30, 0xD3,
  0x0D, 0x39, 0x81, 0xCC, 0xB0,
  // "É" (U+00C9)
  0x28, 0x3D, 0x20, 0x66, 0x59, 0x82, 0xCC, 0xBD, 0x30, 0xD3, 0x98, 0x2C, 0xC9, 0xD3, 0x0D, 0x30,
  0xD3, 0x98, 0x1C, 0xCB,
  // "Ê" (U+00CA)
  0x18, 0x5A, 0xC0, 0x57, 0x57, 0x49, 0x82, 0xCC, 0xBD, 0x30, 0xD3, 0x98, 0x2C, 0xC9, 0xD3, 0x0D,
  0x30, 0xD3, 0x98, 0x1C, 0xCB,
  // "Ë" (U+00CB)
  0x82, 0x43, 0x62, 0x49, 0x82, 0xCC, 0xBD, 0x30, 0xD3, 0x98, 0x2C, 0xC9, 0xD3, 0x0D, 0x30, 0xD3,
  0x98, 0x1C, 0xCB,
  // "Ì" (U+00CC)
  0x5A, 0x00, 0x93, 0x00, 0x06, 0xEB, 0x0B, 0x20, 0xB2, 0x0B, 0x20, 0xB2, 0x0B, 0x20, 0xB2, 0x5E,
  0xB0,
  // "Í" (U+00CD)
  0x00, 0xD2, 0x06, 0x60, 0x00, 0x00, 0x6E, 0xB0, 0x0B, 0x20, 0x0B, 0x20, 0x0B, 0x20, 0x0B, 0x20,
  0x0B, 0x20, 0x0B, 0x20, 0x5E, 0xB0,
  // "Î" (U+00CE)
  0x0A, 0xC0, 0x57, 0x57, 0x00, 0x00, 0x6E, 0xB0, 0x0B, 0x20, 0x0B, 0x20, 0x0B, 0x20, 0x0B, 0x20,
  0x0B, 0x20, 0x0B, 0x20, 0x5E, 0xB0,
  // "Ï" (U+00CF)
  0x43, 0x62, 0x00, 0x00, 0x6E, 0xB0, 0x0B, 0x20, 0x0B, 0x20, 0x0B, 0x20, 0x0B, 0x20, 0x0B, 0x20,
  0x0B, 0x20, 0x5E, 0xB0,
  // "Ð" (U+00D0)
  0x0E, 0xCC, 0xB3, 0x00, 0xD0, 0x03, 0xD1, 0x0D, 0x00, 0x07, 0x70, 0xD0, 0x00, 0x5A, 0x8F, 0xC8,
  0x05, 0x90, 0xD0, 0x00, 0x86, 0x0D, 0x00, 0x4D, 0x10, 0xEC, 0xDB, 0x20,
  // "Ñ" (U+00D1)
  0x02, 0xC5, 0x80, 0x07, 0x19, 0x80, 0x00, 0x00, 0x00, 0xF5, 0x00, 0x39, 0xDD, 0x10, 0x39, 0xB9,
  0x90, 0x39, 0xC1, 0xE4, 0x39, 0xC0, 0x6D, 0x39, 0xC0, 0x0D, 0xB9, 0xC0, 0x04, 0xF9, 0xC0, 0x00,
  0xB9,
  // "Ò" (U+00D2)
  0x20, 0x50, 0xA7, 0x09, 0x03, 0x75, 0x83, 0x1A, 0xCD, 0x93, 0x0C, 0x05, 0x28, 0x38, 0x90, 0x3C,
  0x48, 0x2E, 0x05, 0x94, 0x82, 0xC2, 0x59, 0x48, 0x2C, 0x23, 0xC4, 0x0E, 0x20, 0xC0, 0x52, 0x08,
  0x09, 0x28, 0x31, 0xAC, 0xD9, 0x20,
  // "Ó" (U+00D3)
  0x40, 0xD0, 0x25, 0x00, 0x67, 0x58, 0x31, 0xAC, 0xD9, 0x30, 0xC0, 0x52, 0x83, 0x89, 0x03, 0xC4,
  0x82, 0xE0, 0x59, 0x48, 0x2C, 0x25, 0x94, 0x82, 0xC2, 0x3C, 0x40, 0xE2, 0x0C, 0x05, 0x20, 0x80,
  0x92, 0x83, 0x1A, 0xCD, 0x92,
  // "Ô" (U+00D4)
  0x30, 0xA0, 0xC5, 0x82, 0x57, 0x57, 0x74, 0x83, 0x1A, 0xCD, 0x93, 0x0C, 0x05, 0x28, 0x38, 0x90,
  0x3C, 0x48, 0x2E, 0x05, 0x94, 0x82, 0xC2, 0x59, 0x48, 0x2C, 0x23, 0xC4, 0x0E, 0x20, 0xC0, 0x52,
  0x08, 0x09, 0x28, 0x31, 0xAC, 0xD9, 0x20,
  // "Õ" (U+00D5)
  0x28, 0x22, 0xC5, 0x84, 0x82, 0x71, 0x98, 0x74, 0x83, 0x1A, 0xCD, 0x93, 0x0C, 0x05, 0x28, 0x38,
  0x90, 0x3C, 0x48, 0x2E, 0x05, 0x94, 0x82, 0xC2, 0x59, 0x48, 0x2C, 0x23, 0xC4, 0x0E, 0x20, 0xC0,
  0x52, 0x08, 0x09, 0x28, 0x31, 0xAC, 0xD9, 0x20,
  // "Ö" (U+00D6)
  0x28, 0x24, 0x36, 0x27, 0x48, 0x31, 0xAC, 0xD9, 0x30, 0xC0, 0x52, 0x83, 0x89, 0x03, 0xC4, 0x82,
  0xE0, 0x59, 0x48, 0x2C, 0x25, 0x94, 0x82, 0xC2, 0x3C, 0x40, 0xE2, 0x0C, 0x05, 0x20, 0x80, 0x92,
  0x83, 0x1A, 0xCD, 0x92,
  // "×" (U+00D7)
  0x15, 0x00, 0x70, 0x96, 0xA5, 0x00, 0xD9, 0x00, 0xA5, 0x95, 0x15, 0x00, 0x60,
  // "Ø" (U+00D8)
  0x01, 0xAC, 0xCB, 0x80, 0x0C, 0x50, 0x1E, 0x80, 0x3C, 0x00, 0x95, 0xE0, 0x59, 0x03, 0xA0, 0xC2,
  0x59, 0x0C, 0x10, 0xC2, 0x3C, 0x85, 0x00, 0xE0, 0x0C, 0xB0, 0x08, 0x90, 0x0B, 0xBC, 0xD9, 0x00,
  0x01, 0x00, 0x00, 0x00,
  // "Ù" (U+00D9)
  0x20, 0x50, 0xA6, 0x09, 0x03, 0x72, 0x01, 0x0C, 0x38, 0x27, 0x61, 0xC3, 0x82, 0x76, 0x1C, 0x38,
  0x27, 0x61, 0xC3, 0x82, 0x76, 0x1C, 0x38, 0x27, 0x60, 0xD3, 0x89, 0x58, 0x50, 0xB3, 0x01, 0xC1,
  0x02, 0xBC, 0xC5, 0x10,
  // "Ú" (U+00DA)
  0x40, 0xD0, 0x24, 0x00, 0x67, 0x20, 0x10, 0xC3, 0x82, 0x76, 0x1C, 0x38, 0x27, 0x61, 0xC3, 0x82,
  0x76, 0x1C, 0x38, 0x27, 0x61, 0xC3, 0x82, 0x76, 0x0D, 0x38, 0x95, 0x85, 0x0B, 0x30, 0x1C, 0x10,
  0x2B, 0xCC, 0x51,
  // "Û" (U+00DB)
  0x30, 0xA0, 0xC4, 0x82, 0x57, 0x57, 0x71, 0x01, 0x0C, 0x38, 0x27, 0x61, 0xC3, 0x82, 0x76, 0x1C,
  0x38, 0x27, 0x61, 0xC3, 0x82, 0x76, 0x1C, 0x38, 0x27, 0x60, 0xD3, 0x89, 0x58, 0x50, 0xB3, 0x01,
  0xC1, 0x02, 0xBC, 0xC5, 0x10,
  // "Ü" (U+00DC)
  0x28, 0x24, 0x36, 0x27, 0x10, 0x10, 0xC3, 0x82, 0x76, 0x1C, 0x38, 0x27, 0x61, 0xC3, 0x82, 0x76,
  0x1C, 0x38, 0x27, 0x61, 0xC3, 0x82, 0x76, 0x0D, 0x38, 0x95, 0x85, 0x0B, 0x30, 0x1C, 0x10, 0x2B,
  0xCC, 0x51,
  // "Ý" (U+00DD)
  0x30, 0xD0, 0x23, 0x00, 0x67, 0x10, 0xB0, 0x32, 0x85, 0x96, 0x4B, 0x02, 0xD2, 0x82, 0xC4, 0x96,
  0x28, 0x15, 0xDE, 0x40, 0xD0, 0x74, 0x09, 0x04, 0x40, 0x90, 0x44, 0x09, 0x04, 0x20,
  // "Þ" (U+00DE)
  0x0D, 0x49, 0x83, 0xCC, 0x70, 0xD2, 0x81, 0xB5, 0xD2, 0x81, 0x67, 0xD2, 0x86, 0xB4, 0xFC, 0xC6,
  0x0D, 0x40, 0xD4,
  // "ß" (U+00DF)
  0x07, 0xCD, 0x90, 0x1D, 0x00, 0xB2, 0x2B, 0x04, 0xB0, 0x2B, 0x0D, 0x00, 0x2B, 0x09, 0x90, 0x2B,
  0x00, 0x79, 0x2B, 0x00, 0x1C, 0x2B, 0x5C, 0xC5,
  // "à" (U+00E0)
  0x10, 0x50, 0xA4, 0x09, 0x03, 0x78, 0x29, 0xCD, 0x43, 0x8A, 0x42, 0xB0, 0x8C, 0xCC, 0x69, 0x01,
  0xC7, 0x70, 0x5C, 0x1C, 0xC7, 0xB0,
  // "á" (U+00E1)
  0x30, 0xD0, 0x22, 0x00, 0x67, 0x82, 0x9C, 0xD4, 0x38, 0xA4, 0x2B, 0x08, 0xCC, 0xC6, 0x90, 0x1C,
  0x77, 0x05, 0xC1, 0xCC, 0x7B,
  // "â" (U+00E2)
  0x00, 0xAC, 0x00, 0x57, 0x57, 0x00, 0x00, 0x00, 0x9C, 0xD4, 0x00, 0x02, 0xB0, 0x8C, 0xCC, 0x69,
  0x01, 0xC7, 0x70, 0x5C, 0x1C, 0xC7, 0xB0,
  // "ã" (U+00E3)
  0x02, 0xC5, 0x80, 0x71, 0x98, 0x00, 0x00, 0x00, 0x9C, 0xD4, 0x00, 0x02, 0xB0, 0x8C, 0xCC, 0x69,
  0x01, 0xC7, 0x70, 0x5C, 0x1C, 0xC7, 0xB0,
  // "ä" (U+00E4)
  0x04, 0x36, 0x20, 0x00, 0x00, 0x09, 0xCD, 0x40, 0x00, 0x2B, 0x08, 0xCC, 0xC6, 0x90, 0x1C, 0x77,
  0x05, 0xC1, 0xCC, 0x7B,
  // "å" (U+00E5)
  0x03, 0x93, 0x00, 0x80, 0x80, 0x03, 0x93, 0x00, 0x9C, 0xD4, 0x00, 0x02, 0xB0, 0x8C, 0xCC, 0x69,
  0x01, 0xC7, 0x70, 0x5C, 0x1C, 0xC7, 0xB0,
  // "æ" (U+00E6)
  0x0A, 0xCC, 0x5B, 0xC5, 0x00, 0x00, 0x4D, 0x00, 0xD0, 0x09, 0xCD, 0xEC, 0xCD, 0x16, 0x90, 0x3B,
  0x00, 0x00, 0x77, 0x07, 0xE1, 0x01, 0x01, 0xCC, 0x73, 0xCC, 0xA0,
  // "ç" (U+00E7)
  0x06, 0xCD, 0x42, 0xC0, 0x00, 0x67, 0x00, 0x06, 0x70, 0x00, 0x3C, 0x00, 0x00, 0x7C, 0xC4, 0x00,
  0x24, 0x00, 0x01, 0xB0, 0x00, 0x89, 0x00,
  // "è" (U+00E8)
  0x10, 0x50, 0xA5, 0x09, 0x03, 0x72, 0x85, 0x6C, 0xC4, 0x02, 0xA2, 0x89, 0x0D, 0x06, 0xDC, 0xCD,
  0x16, 0x84, 0x83, 0x2D, 0x10, 0x12, 0x82, 0x6D, 0xCA, 0x10,
  // "é" (U+00E9)
  0x30, 0xD0, 0x23, 0x00, 0x67, 0x28, 0x56, 0xCC, 0x40, 0x2A, 0x28, 0x90, 0xD0, 0x6D, 0xCC, 0xD1,
  0x68, 0x48, 0x32, 0xD1, 0x01, 0x28, 0x26, 0xDC, 0xA1,
  // "ê" (U+00EA)
  0x00, 0xAC, 0x00, 0x05, 0x75, 0x70, 0x00, 0x00, 0x00, 0x06, 0xCC, 0x40, 0x2A, 0x00, 0xD0, 0x6D,
  0xCC, 0xD1, 0x68, 0x00, 0x00, 0x2D, 0x10, 0x10, 0x06, 0xDC, 0xA0,
  // "ë" (U+00EB)
  0x04, 0x36, 0x20, 0x00, 0x00, 0x00, 0x06, 0xCC, 0x40, 0x2A, 0x00, 0xD0, 0x6D, 0xCC, 0xD1, 0x68,
  0x00, 0x00, 0x2D, 0x10, 0x10, 0x06, 0xDC, 0xA0,
  // "ì" (U+00EC)
  0x5A, 0x00, 0x93, 0x00, 0x02, 0xB0, 0x2B, 0x02, 0xB0, 0x2B, 0x02, 0xB0, 0x2B, 0x00,
  // "í" (U+00ED)
  0x0D, 0x26, 0x60, 0x00, 0x02, 0xB0, 0x2B, 0x02, 0xB0, 0x2B, 0x02, 0xB0, 0x2B, 0x00,
  // "î" (U+00EE)
  0x0A, 0xC0, 0x57, 0x57, 0x00, 0x00, 0x02, 0xB0, 0x02, 0xB0, 0x02, 0xB0, 0x02, 0xB0, 0x02, 0xB0,
  0x02, 0xB0,
  // "ï" (U+00EF)
  0x43, 0x62, 0x00, 0x00, 0x02, 0xB0, 0x02, 0xB0, 0x02, 0xB0, 0x02, 0xB0, 0x02, 0xB0, 0x02, 0xB0,
  // "ð" (U+00F0)
  0x00, 0xB7, 0x90, 0x01, 0xBD, 0x40, 0x01, 0x21, 0xC0, 0x06, 0xCB, 0xC4, 0x3B, 0x00, 0xA7, 0x67,
  0x00, 0x67, 0x4B, 0x00, 0xA3, 0x07, 0xCC, 0x70,
  // "ñ" (U+00F1)
  0x02, 0xC5, 0x80, 0x07, 0x19, 0x80, 0x00, 0x00, 0x00, 0x2A, 0xAC, 0xA0, 0x2E, 0x10, 0xA4, 0x2C,
  0x00, 0x75, 0x2B, 0x00, 0x75, 0x2B, 0x00, 0x75, 0x2B, 0x00, 0x75,
  // "ò" (U+00F2)
  0x05, 0xA0, 0x00, 0x00, 0x93, 0x00, 0x00, 0x00, 0x00, 0x06, 0xCC, 0x70, 0x2C, 0x00, 0xB3, 0x67,
  0x00, 0x77, 0x67, 0x00, 0x76, 0x2C, 0x00, 0xB3, 0x06, 0xCC, 0x60,
  // "ó" (U+00F3)
  0x30, 0xD0, 0x23, 0x00, 0x67, 0x28, 0x56, 0xCC, 0x70, 0x2C, 0x28, 0x2B, 0x36, 0x72, 0x82, 0x77,
  0x67, 0x28, 0x27, 0x62, 0xC2, 0x85, 0xB3, 0x06, 0xCC, 0x61,
  // "ô" (U+00F4)
  0x00, 0xAC, 0x00, 0x05, 0x75, 0x70, 0x00, 0x00, 0x00, 0x06, 0xCC, 0x70, 0x2C, 0x00, 0xB3, 0x67,
  0x00, 0x77, 0x67, 0x00, 0x76, 0x2C, 0x00, 0xB3, 0x06, 0xCC, 0x60,
  // "õ" (U+00F5)
  0x02, 0xC5, 0x80, 0x07, 0x19, 0x80, 0x00, 0x00, 0x00, 0x06, 0xCC, 0x70, 0x2C, 0x00, 0xB3, 0x67,
  0x00, 0x77, 0x67, 0x00, 0x76, 0x2C, 0x00, 0xB3, 0x06, 0xCC, 0x60,
  // "ö" (U+00F6)
  0x04, 0x36, 0x20, 0x00, 0x00, 0x00, 0x06, 0xCC, 0x70, 0x2C, 0x00, 0xB3, 0x67, 0x00, 0x77, 0x67,
  0x00, 0x76, 0x2C, 0x00, 0xB3, 0x06, 0xCC, 0x60,
  // "÷" (U+00F7)
  0x20, 0x60, 0x37, 0x18, 0x46, 0xCC, 0xCC, 0x27, 0x10, 0x60, 0x32,
  // "ø" (U+00F8)
  0x06, 0xCC, 0xC1, 0x2C, 0x05, 0xE2, 0x67, 0x1B, 0x76, 0x67, 0xA2, 0x76, 0x2E, 0x70, 0xB3, 0x1C,
  0xDC, 0x60, 0x01, 0x00, 0x00,
  // "ù" (U+00F9)
  0x05, 0xA0, 0x00, 0x00, 0x93, 0x00, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x85, 0x3A, 0x00, 0x85, 0x3A,
  0x00, 0x85, 0x3A, 0x00, 0x95, 0x1C, 0x00, 0xD5, 0x09, 0xDB, 0x95,
  // "ú" (U+00FA)
  0x00, 0x0D, 0x20, 0x00, 0x66, 0x00, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x85, 0x3A, 0x00, 0x85, 0x3A,
  0x00, 0x85, 0x3A, 0x00, 0x95, 0x1C, 0x00, 0xD5, 0x09, 0xDB, 0x95,
  // "û" (U+00FB)
  0x00, 0xAC, 0x00, 0x05, 0x75, 0x70, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x85, 0x3A, 0x00, 0x85, 0x3A,
  0x00, 0x85, 0x3A, 0x00, 0x95, 0x1C, 0x00, 0xD5, 0x09, 0xDB, 0x95,
  // "ü" (U+00FC)
  0x04, 0x36, 0x20, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x85, 0x3A, 0x00, 0x85, 0x3A, 0x00, 0x85, 0x3A,
  0x00, 0x95, 0x1C, 0x00, 0xD5, 0x09, 0xDB, 0x95,
  // "ý" (U+00FD)
  0x00, 0x0D, 0x20, 0x06, 0x60, 0x00, 0x00, 0x0C, 0x10, 0x0D, 0x76, 0x04, 0x92, 0xB0, 0x94, 0x0C,
  0x1D, 0x00, 0x69, 0x90, 0x01, 0xE4, 0x00, 0x0D, 0x00, 0x05, 0x90, 0x0A, 0xC1, 0x00,
  // "þ" (U+00FE)
  0x2B, 0x00, 0x00, 0x2B, 0x00, 0x00, 0x2C, 0xAC, 0x90, 0x2E, 0x10, 0xA5, 0x2B, 0x00, 0x58, 0x2C,
  0x00, 0x58, 0x2E, 0x10, 0xA5, 0x2C, 0xAC, 0x90, 0x2B, 0x00, 0x00, 0x2B, 0x00, 0x00, 0x2B, 0x00,
  0x00,
  // "ÿ" (U+00FF)
  0x04, 0x36, 0x20, 0x00, 0x00, 0xC1, 0x00, 0xD7, 0x60, 0x49, 0x2B, 0x09, 0x40, 0xC1, 0xD0, 0x06,
  0x99, 0x00, 0x1E, 0x40, 0x00, 0xD0, 0x00, 0x59, 0x00, 0xAC, 0x10, 0x00,
  // "Ā" (U+0100)
  0x18, 0x27, 0xCC, 0x47, 0x40, 0x50, 0xB5, 0x81, 0xBD, 0x13, 0x82, 0x1D, 0x77, 0x38, 0x26, 0x82,
  0xC3, 0x89, 0x5C, 0x30, 0xD2, 0x02, 0xFD, 0xDE, 0x70, 0x78, 0x28, 0x32, 0xD0, 0xC1, 0x30, 0xB0,
  0x30,
  // "ā" (U+0101)
  0x07, 0xCC, 0x40, 0x00, 0x00, 0x09, 0xCD, 0x40, 0x00, 0x2B, 0x08, 0xCC, 0xC6, 0x90, 0x1C, 0x77,
  0x05, 0xC1, 0xCC, 0x7B,
  // "Ă" (U+0102)
  0x18, 0x24, 0x01, 0x43, 0x82, 0x2C, 0xB1, 0x74, 0x05, 0x0B, 0x58, 0x1B, 0xD1, 0x38, 0x21, 0xD7,
  0x73, 0x82, 0x68, 0x2C, 0x38, 0x95, 0xC3, 0x0D, 0x20, 0x2F, 0xDD, 0xE7, 0x07, 0x82, 0x83, 0x2D,
  0x0C, 0x13, 0x0B, 0x03,
  // "ă" (U+0103)
  0x04, 0x01, 0x40, 0x2C, 0xB1, 0x00, 0x00, 0x00, 0x9C, 0xD4, 0x00, 0x02, 0xB0, 0x8C, 0xCC, 0x69,
  0x01, 0xC7, 0x70, 0x5C, 0x1C, 0xC7, 0xB0,
  // "Ą" (U+0104)
  0x20, 0x50, 0xB5, 0x81, 0xBD, 0x13, 0x82, 0x1D, 0x77, 0x38, 0x26, 0x82, 0xC3, 0x89, 0x5C, 0x30,
  0xD2, 0x02, 0xFD, 0xDE, 0x70, 0x78, 0x28, 0x32, 0xD0, 0xC1, 0x30, 0xB0, 0x34, 0x01, 0x06, 0x50,
  0x70, 0x35, 0x04, 0x0C, 0x10,
  // "ą" (U+0105)
  0x09, 0xCD, 0x40, 0x00, 0x2B, 0x08, 0xCC, 0xC6, 0x90, 0x1C, 0x77, 0x05, 0xC1, 0xCC, 0x7B, 0x00,
  0x01, 0x60, 0x00, 0x73, 0x00, 0x04, 0xC0,
  // "Ć" (U+0106)
  0x40, 0xD0, 0x23, 0x00, 0x67, 0x28, 0x59, 0xDC, 0xA0, 0xB7, 0x28, 0x11, 0x2C, 0x40, 0x50, 0x94,
  0x05, 0x09, 0x40, 0x30, 0xC5, 0x0C, 0x06, 0x48, 0x31, 0xAD, 0xC9,
  // "ć" (U+0107)
  0x30, 0xD0, 0x22, 0x00, 0x67, 0x84, 0x6C, 0xD4, 0x2C, 0x30, 0x60, 0x73, 0x06, 0x07, 0x30, 0x30,
  0xC4, 0x82, 0x7C, 0xC4,
  // "Ĉ" (U+0108)
  0x30, 0xA0, 0xC3, 0x82, 0x57, 0x57, 0x71, 0x85, 0x9D, 0xCA, 0x0B, 0x72, 0x81, 0x12, 0xC4, 0x05,
  0x09, 0x40, 0x50, 0x94, 0x03, 0x0C, 0x50, 0xC0, 0x64, 0x83, 0x1A, 0xDC, 0x90,
  // "ĉ" (U+0109)
  0x20, 0xA0, 0xC2, 0x82, 0x57, 0x57, 0x68, 0x46, 0xCD, 0x42, 0xC3, 0x06, 0x07, 0x30, 0x60, 0x73,
  0x03, 0x0C, 0x48, 0x27, 0xCC, 0x40,
  // "Ċ" (U+010A)
  0x30, 0x50, 0x37, 0x28, 0x59, 0xDC, 0xA0, 0xB7, 0x28, 0x11, 0x2C, 0x40, 0x50, 0x94, 0x05, 0x09,
  0x40, 0x30, 0xC5, 0x0C, 0x06, 0x48, 0x31, 0xAD, 0xC9,
  // "ċ" (U+010B)
  0x20, 0x50, 0x37, 0x84, 0x6C, 0xD4, 0x2C, 0x30, 0x60, 0x73, 0x06, 0x07, 0x30, 0x30, 0xC4, 0x82,
  0x7C, 0xC4,
  // "Č" (U+010C)
  0x28, 0x25, 0x75, 0x73, 0x0A, 0x0C, 0x72, 0x85, 0x9D, 0xCA, 0x0B, 0x72, 0x81, 0x12, 0xC4, 0x05,
  0x09, 0x40, 0x50, 0x94, 0x03, 0x0C, 0x50, 0xC0, 0x64, 0x83, 0x1A, 0xDC, 0x90,
  // "č" (U+010D)
  0x18, 0x25, 0x75, 0x72, 0x0A, 0x0C, 0x78, 0x46, 0xCD, 0x42, 0xC3, 0x06, 0x07, 0x30, 0x60, 0x73,
  0x03, 0x0C, 0x48, 0x27, 0xCC, 0x40,
  // "Ď" (U+010E)
  0x05, 0x75, 0x70, 0x00, 0xAC, 0x00, 0x00, 0x00, 0x00, 0xFC, 0xDB, 0x30, 0xD0, 0x03, 0xD1, 0xD0,
  0x00, 0x77, 0xD0, 0x00, 0x5A, 0xD0, 0x00, 0x59, 0xD0, 0x00, 0x86, 0xD0, 0x04, 0xD1, 0xFC, 0xDB,
  0x20,
  // "ď" (U+010F)
  0x00, 0x00, 0x95, 0xB0, 0x00, 0x09, 0x74, 0x07, 0xCB, 0xA4, 0x02, 0xC0, 0x0D, 0x40, 0x67, 0x00,
  0x94, 0x06, 0x70, 0x09, 0x40, 0x3C, 0x00, 0xD4, 0x00, 0x8C, 0xB9, 0x40,
  // "Đ" (U+0110)
  0x0E, 0xCC, 0xB3, 0x00, 0xD0, 0x03, 0xD1, 0x0D, 0x00, 0x07, 0x70, 0xD0, 0x00, 0x5A, 0x8F, 0xC8,
  0x05, 0x90, 0xD0, 0x00, 0x86, 0x0D, 0x00, 0x4D, 0x10, 0xEC, 0xDB, 0x20,
  // "đ" (U+0111)
  0x00, 0x8C, 0xED, 0x00, 0x00, 0x84, 0x07, 0xCB, 0xA4, 0x3C, 0x00, 0xD4, 0x68, 0x00, 0x94, 0x67,
  0x00, 0x94, 0x3C, 0x00, 0xD4, 0x08, 0xCB, 0x94,
  // "Ē" (U+0112)
  0x82, 0x7C, 0xC4, 0x49, 0x82, 0xCC, 0xBD, 0x30, 0xD3, 0x98, 0x2C, 0xC9, 0xD3, 0x0D, 0x30, 0xD3,
  0x98, 0x1C, 0xCB,
  // "ē" (U+0113)
  0x07, 0xCC, 0x40, 0x00, 0x00, 0x00, 0x06, 0xCC, 0x40, 0x2A, 0x00, 0xD0, 0x6D, 0xCC, 0xD1, 0x68,
  0x00, 0x00, 0x2D, 0x10, 0x10, 0x06, 0xDC, 0xA0,
  // "Ĕ" (U+0114)
  0x86, 0x40, 0x14, 0x2C, 0xB1, 0x49, 0x82, 0xCC, 0xBD, 0x30, 0xD3, 0x98, 0x2C, 0xC9, 0xD3, 0x0D,
  0x30, 0xD3, 0x98, 0x1C, 0xCB,
  // "ĕ" (U+0115)
  0x04, 0x01, 0x40, 0x02, 0xCB, 0x10, 0x00, 0x00, 0x00, 0x06, 0xCC, 0x40, 0x2A, 0x00, 0xD0, 0x6D,
  0xCC, 0xD1, 0x68, 0x00, 0x00, 0x2D, 0x10, 0x10, 0x06, 0xDC, 0xA0,
  // "Ė" (U+0116)
  0x10, 0x50, 0x35, 0x98, 0x2C, 0xCB, 0xD3, 0x0D, 0x39, 0x82, 0xCC, 0x9D, 0x30, 0xD3, 0x0D, 0x39,
  0x81, 0xCC, 0xB0,
  // "ė" (U+0117)
  0x20, 0x50, 0x37, 0x28, 0x56, 0xCC, 0x40, 0x2A, 0x28, 0x90, 0xD0, 0x6D, 0xCC, 0xD1, 0x68, 0x48,
  0x32, 0xD1, 0x01, 0x28, 0x26, 0xDC, 0xA1,
  // "Ę" (U+0118)
  0xFC, 0xCB, 0xD0, 0x00, 0xD0, 0x00, 0xFC, 0xC9, 0xD0, 0x00, 0xD0, 0x00, 0xD0, 0x00, 0xFC, 0xCB,
  0x00, 0x16, 0x00, 0x73, 0x00, 0x4C,
  // "ę" (U+0119)
  0x18, 0x93, 0x6D, 0xC3, 0x02, 0xD0, 0x2C, 0x06, 0x82, 0x89, 0x0D, 0x16, 0xDC, 0xCD, 0x12, 0xA5,
  0x06, 0x0F, 0xC4, 0x07, 0x03, 0x40, 0xB5, 0x09, 0x0A, 0x10,
  // "Ě" (U+011A)
  0x85, 0x57, 0x57, 0x0A, 0xC5, 0x98, 0x2C, 0xCB, 0xD3, 0x0D, 0x39, 0x82, 0xCC, 0x9D, 0x30, 0xD3,
  0x0D, 0x39, 0x81, 0xCC, 0xB0,
  // "ě" (U+011B)
  0x05, 0x75, 0x70, 0x00, 0xAC, 0x00, 0x00, 0x00, 0x00, 0x06, 0xCC, 0x40, 0x2A, 0x00, 0xD0, 0x6D,
  0xCC, 0xD1, 0x68, 0x00, 0x00, 0x2D, 0x10, 0x10, 0x06, 0xDC, 0xA0,
  // "Ĝ" (U+011C)
  0x30, 0xA0, 0xC4, 0x82, 0x57, 0x57, 0x73, 0x86, 0x8C, 0xCC, 0x30, 0xA7, 0x28, 0x21, 0x02, 0xC5,
  0x05, 0x09, 0x50, 0x50, 0x92, 0x83, 0xBD, 0x72, 0xC3, 0x83, 0x58, 0x0B, 0x62, 0x87, 0x58, 0x01,
  0xAD, 0xCC, 0x60,
  // "ĝ" (U+011D)
  0x00, 0xAC, 0x00, 0x05, 0x75, 0x70, 0x00, 0x00, 0x00, 0x07, 0xCB, 0x94, 0x2C, 0x00, 0xD4, 0x67,
  0x00, 0x94, 0x67, 0x00, 0x94, 0x3C, 0x00, 0xC4, 0x07, 0xCB, 0xA4, 0x00, 0x00, 0x94, 0x01, 0x00,
  0xD1, 0x0C, 0xCC, 0x60,
  // "Ğ" (U+011E)
  0x28, 0x24, 0x01, 0x43, 0x82, 0x2C, 0xB1, 0x73, 0x86, 0x8C, 0xCC, 0x30, 0xA7, 0x28, 0x21, 0x02,
  0xC5, 0x05, 0x09, 0x50, 0x50, 0x92, 0x83, 0xBD, 0x72, 0xC3, 0x83, 0x58, 0x0B, 0x62, 0x87, 0x58,
  0x01, 0xAD, 0xCC, 0x60,
  // "ğ" (U+011F)
  0x04, 0x01, 0x40, 0x02, 0xCB, 0x10, 0x00, 0x00, 0x00, 0x07, 0xCB, 0x94, 0x2C, 0x00, 0xD4, 0x67,
  0x00, 0x94, 0x67, 0x00, 0x94, 0x3C, 0x00, 0xC4, 0x07, 0xCB, 0xA4, 0x00, 0x00, 0x94, 0x01, 0x00,
  0xD1, 0x0C, 0xCC, 0x60,
  // "Ġ" (U+0120)
  0x30, 0x50, 0x37, 0x48, 0x68, 0xCC, 0xC3, 0x0A, 0x72, 0x82, 0x10, 0x2C, 0x50, 0x50, 0x95, 0x05,
  0x09, 0x28, 0x3B, 0xD7, 0x2C, 0x38, 0x35, 0x80, 0xB6, 0x28, 0x75, 0x80, 0x1A, 0xDC, 0xC6,
  // "ġ" (U+0121)
  0x00, 0x53, 0x00, 0x00, 0x00, 0x00, 0x07, 0xCB, 0x94, 0x2C, 0x00, 0xD4, 0x67, 0x00, 0x94, 0x67,
  0x00, 0x94, 0x3C, 0x00, 0xC4, 0x07, 0xCB, 0xA4, 0x00, 0x00, 0x94, 0x01, 0x00, 0xD1, 0x0C, 0xCC,
  0x60,
  // "Ģ" (U+0122)
  0x28, 0x68, 0xCC, 0xC3, 0x0A, 0x72, 0x82, 0x10, 0x2C, 0x50, 0x50, 0x95, 0x05, 0x09, 0x28, 0x3B,
  0xD7, 0x2C, 0x38, 0x35, 0x80, 0xB6, 0x28, 0x75, 0x80, 0x1A, 0xDC, 0xC6, 0x73, 0x03, 0x07, 0x50,
  0x70, 0x22,
  // "ģ" (U+0123)
  0x00, 0x27, 0x00, 0x00, 0x73, 0x00, 0x07, 0xCB, 0x94, 0x2C, 0x00, 0xD4, 0x67, 0x00, 0x94, 0x67,
  0x00, 0x94, 0x3C, 0x00, 0xC4, 0x07, 0xCB, 0xA4, 0x00, 0x00, 0x94, 0x01, 0x00, 0xD1, 0x0C, 0xCC,
  0x60,
  // "Ĥ" (U+0124)
  0x20, 0xA0, 0xC3, 0x82, 0x57, 0x57, 0x70, 0xD3, 0x81, 0x76, 0xD3, 0x81, 0x76, 0xD3, 0x87, 0x76,
  0xFC, 0xCC, 0xD6, 0xD3, 0x81, 0x76, 0xD3, 0x81, 0x76, 0xD3, 0x81, 0x76, 0xD3, 0x07, 0x06,
  // "ĥ" (U+0125)
  0x10, 0xA0, 0xC4, 0x82, 0x57, 0x57, 0x74, 0x02, 0x0B, 0x50, 0x20, 0xB5, 0x83, 0x2B, 0xAC, 0xA2,
  0x87, 0x2E, 0x10, 0xA4, 0x02, 0xC2, 0x83, 0x75, 0x02, 0xB2, 0x83, 0x75, 0x02, 0xB2, 0x83, 0x75,
  0x02, 0xB2, 0x07, 0x05,
  // "Ħ" (U+0126)
  0x0D, 0x00, 0x07, 0x60, 0xCF, 0xCC, 0xCD, 0xD5, 0x0D, 0x00, 0x07, 0x60, 0x0F, 0xCC, 0xCD, 0x60,
  0x0D, 0x00, 0x07, 0x60, 0x0D, 0x00, 0x07, 0x60, 0x0D, 0x00, 0x07, 0x60, 0x0D, 0x00, 0x07, 0x60,
  // "ħ" (U+0127)
  0xBE, 0xCA, 0x00, 0x2B, 0x00, 0x00, 0x2C, 0xAC, 0xA0, 0x2E, 0x10, 0xA4, 0x2C, 0x00, 0x75, 0x2B,
  0x00, 0x75, 0x2B, 0x00, 0x75, 0x2B, 0x00, 0x75,
  // "Ĩ" (U+0128)
  0x2C, 0x58, 0x71, 0x98, 0x00, 0x00, 0x06, 0xEB, 0x00, 0xB2, 0x00, 0xB2, 0x00, 0xB2, 0x00, 0xB2,
  0x00, 0xB2, 0x00, 0xB2, 0x05, 0xEB,
  // "ĩ" (U+0129)
  0x2C, 0x58, 0x71, 0x98, 0x00, 0x00, 0x02, 0xB0, 0x02, 0xB0, 0x02, 0xB0, 0x02, 0xB0, 0x02, 0xB0,
  0x02, 0xB0,
  // "Ī" (U+012A)
  0x7C, 0xC4, 0x00, 0x00, 0x6E, 0xB0, 0x0B, 0x20, 0x0B, 0x20, 0x0B, 0x20, 0x0B, 0x20, 0x0B, 0x20,
  0x0B, 0x20, 0x5E, 0xB0,
  // "ī" (U+012B)
  0x7C, 0xC4, 0x00, 0x00, 0x02, 0xB0, 0x02, 0xB0, 0x02, 0xB0, 0x02, 0xB0, 0x02, 0xB0, 0x02, 0xB0,
  // "Ĭ" (U+012C)
  0x40, 0x14, 0x2C, 0xB1, 0x00, 0x00, 0x6E, 0xB0, 0x0B, 0x20, 0x0B, 0x20, 0x0B, 0x20, 0x0B, 0x20,
  0x0B, 0x20, 0x0B, 0x20, 0x5E, 0xB0,
  // "ĭ" (U+012D)
  0x40, 0x14, 0x2C, 0xB1, 0x00, 0x00, 0x02, 0xB0, 0x02, 0xB0, 0x02, 0xB0, 0x02, 0xB0, 0x02, 0xB0,
  0x02, 0xB0,
  // "Į" (U+012E)
  0x6E, 0xB0, 0xB2, 0x0B, 0x20, 0xB2, 0x0B, 0x20, 0xB2, 0x0B, 0x25, 0xEB, 0x01, 0x60, 0x73, 0x04,
  0xC0,
  // "į" (U+012F)
  0x17, 0x00, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x16, 0x73, 0x4C,
  // "İ" (U+0130)
  0x05, 0x30, 0x00, 0x6E, 0xB0, 0xB2, 0x0B, 0x20, 0xB2, 0x0B, 0x20, 0xB2, 0x0B, 0x25, 0xEB,
  // "ı" (U+0131)
  0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
  // "Ĳ" (U+0132)
  0x6E, 0xB1, 0xC0, 0xB2, 0x1C, 0x0B, 0x21, 0xC0, 0xB2, 0x1C, 0x0B, 0x21, 0xC0, 0xB2, 0x1C, 0x0B,
  0x21, 0xC5, 0xEB, 0x1C, 0x00, 0x04, 0xA0, 0x09, 0xB2,
  // "ĳ" (U+0133)
  0x17, 0x01, 0x70, 0x00, 0x00, 0x2B, 0x02, 0xB2, 0xB0, 0x2B, 0x2B, 0x02, 0xB2, 0xB0, 0x2B, 0x2B,
  0x02, 0xB2, 0xB0, 0x2B, 0x00, 0x02, 0xB0, 0x00, 0x3A, 0x00, 0x6D, 0x40,
  // "Ĵ" (U+0134)
  0x0A, 0xC0, 0x57, 0x57, 0x00, 0x00, 0x01, 0xC0, 0x01, 0xC0, 0x01, 0xC0, 0x01, 0xC0, 0x01, 0xC0,
  0x01, 0xC0, 0x01, 0xC0, 0x01, 0xC0, 0x04, 0xA0, 0x9B, 0x20,
  // "ĵ" (U+0135)
  0x0A, 0xC0, 0x57, 0x57, 0x00, 0x00, 0x02, 0xB0, 0x02, 0xB0, 0x02, 0xB0, 0x02, 0xB0, 0x02, 0xB0,
  0x02, 0xB0, 0x02, 0xB0, 0x03, 0xA0, 0x6D, 0x40,
  // "Ķ" (U+0136)
  0xD0, 0x05, 0xAD, 0x03, 0xC0, 0xD1, 0xC2, 0x0D, 0xB6, 0x00, 0xF7, 0xD0, 0x0D, 0x08, 0x80, 0xD0,
  0x0C, 0x3D, 0x00, 0x3C, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x03, 0x60, 0x00,
  // "ķ" (U+0137)
  0x02, 0x0B, 0x30, 0x20, 0xB3, 0x8B, 0x42, 0xB0, 0x5A, 0x2B, 0x3C, 0x02, 0xCD, 0x20, 0x2E, 0x98,
  0x02, 0xB0, 0xC3, 0x2B, 0x02, 0xD7, 0x08, 0x02, 0x30, 0xA2,
  // "ĸ" (U+0138)
  0x2C, 0x05, 0xB2, 0xC2, 0xC1, 0x2C, 0xC4, 0x02, 0xE9, 0x90, 0x2C, 0x0B, 0x42, 0xC0, 0x2D,
  // "Ĺ" (U+0139)
  0x10, 0xD0, 0x22, 0x00, 0x67, 0x20, 0xD4, 0x0D, 0x40, 0xD4, 0x0D, 0x40, 0xD4, 0x0D, 0x40, 0xD4,
  0x90, 0xFD,
  // "ĺ" (U+013A)
  0x0D, 0x26, 0x60, 0x00, 0x02, 0xB0, 0x2B, 0x02, 0xB0, 0x2B, 0x02, 0xB0, 0x2B, 0x02, 0xB0, 0x2B,
  0x00,
  // "Ļ" (U+013B)
  0x0D, 0x30, 0xD3, 0x0D, 0x30, 0xD3, 0x0D, 0x30, 0xD3, 0x0D, 0x39, 0x0F, 0xD5, 0x04, 0x07, 0x20,
  0x70, 0x21,
  // "ļ" (U+013C)
  0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x00, 0x0A, 0x36,
  // "Ľ" (U+013D)
  0x0D, 0x28, 0x4C, 0xD0, 0x16, 0xD3, 0x0D, 0x30, 0xD3, 0x0D, 0x30, 0xD3, 0x90, 0xFD,
  // "ľ" (U+013E)
  0x2B, 0x83, 0x2B, 0x80, 0x2B, 0x00, 0x2B, 0x00, 0x2B, 0x00, 0x2B, 0x00, 0x2B, 0x00, 0x2B, 0x00,
  // "Ŀ" (U+013F)
  0x0D, 0x30, 0xD3, 0x0D, 0x38, 0x3D, 0x05, 0x3D, 0x30, 0xD3, 0x0D, 0x39, 0x0F, 0xD0,
  // "ŀ" (U+0140)
  0x2B, 0x00, 0x2B, 0x00, 0x2B, 0x00, 0x2B, 0x53, 0x2B, 0x00, 0x2B, 0x00, 0x2B, 0x00, 0x2B, 0x00,
  // "Ł" (U+0141)
  0x10, 0xD4, 0x0D, 0x40, 0xD4, 0x85, 0xEA, 0x50, 0x5E, 0x42, 0x04, 0x0D, 0x40, 0xD4, 0x90, 0xFD,
  // "ł" (U+0142)
  0x3A, 0x03, 0xA0, 0x3A, 0x03, 0xD6, 0xAB, 0x05, 0xA0, 0x3A, 0x03, 0xA0,
  // "Ń" (U+0143)
  0x30, 0xD0, 0x23, 0x00, 0x67, 0x19, 0x05, 0x28, 0xB1, 0x39, 0xDD, 0x10, 0x39, 0xB9, 0x90, 0x39,
  0xC1, 0xE4, 0x39, 0xC0, 0x6D, 0x39, 0xC2, 0x82, 0xDB, 0x9C, 0x28, 0x24, 0xF9, 0xC3, 0x0B, 0x09,
  // "ń" (U+0144)
  0x00, 0x0D, 0x20, 0x00, 0x66, 0x00, 0x00, 0x00, 0x00, 0x2A, 0xAC, 0xA0, 0x2E, 0x10, 0xA4, 0x2C,
  0x00, 0x75, 0x2B, 0x00, 0x75, 0x2B, 0x00, 0x75, 0x2B, 0x00, 0x75,
  // "Ņ" (U+0145)
  0x90, 0x52, 0x8B, 0x13, 0x9D, 0xD1, 0x03, 0x9B, 0x99, 0x03, 0x9C, 0x1E, 0x43, 0x9C, 0x06, 0xD3,
  0x9C, 0x28, 0x2D, 0xB9, 0xC2, 0x82, 0x4F, 0x9C, 0x30, 0xB0, 0x97, 0x10, 0x60, 0x44, 0x09, 0x30,
  // "ņ" (U+0146)
  0x2A, 0xAC, 0xA0, 0x2E, 0x10, 0xA4, 0x2C, 0x00, 0x75, 0x2B, 0x00, 0x75, 0x2B, 0x00, 0x75, 0x2B,
  0x00, 0x75, 0x00, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x63, 0x00,
  // "Ň" (U+0147)
  0x05, 0x75, 0x70, 0x00, 0xAC, 0x00, 0x00, 0x00, 0x00, 0xF5, 0x00, 0x39, 0xDD, 0x10, 0x39, 0xB9,
  0x90, 0x39, 0xC1, 0xE4, 0x39, 0xC0, 0x6D, 0x39, 0xC0, 0x0D, 0xB9, 0xC0, 0x04, 0xF9, 0xC0, 0x00,
  0xB9,
  // "ň" (U+0148)
  0x05, 0x75, 0x70, 0x00, 0xAC, 0x00, 0x00, 0x00, 0x00, 0x2A, 0xAC, 0xA0, 0x2E, 0x10, 0xA4, 0x2C,
  0x00, 0x75, 0x2B, 0x00, 0x75, 0x2B, 0x00, 0x75, 0x2B, 0x00, 0x75,
  // "ŉ" (U+0149)
  0x77, 0x00, 0x00, 0x09, 0x30, 0x00, 0x00, 0x92, 0xAA, 0xCA, 0x00, 0x2E, 0x10, 0xA4, 0x02, 0xC0,
  0x07, 0x50, 0x2B, 0x00, 0x75, 0x02, 0xB0, 0x07, 0x50, 0x2B, 0x00, 0x75,
  // "Ŋ" (U+014A)
  0xF4, 0x00, 0x39, 0xFD, 0x00, 0x39, 0xCD, 0x70, 0x39, 0xC4, 0xE1, 0x39, 0xC0, 0x9A, 0x39, 0xC0,
  0x0D, 0x79, 0xC0, 0x03, 0xE9, 0xC0, 0x00, 0x89, 0x00, 0x00, 0x57, 0x00, 0x0C, 0xA1,
  // "ŋ" (U+014B)
  0x2A, 0xAC, 0xA0, 0x2E, 0x10, 0xA4, 0x2C, 0x00, 0x75, 0x2B, 0x00, 0x75, 0x2B, 0x00, 0x75, 0x2B,
  0x00, 0x75, 0x00, 0x00, 0x75, 0x00, 0x00, 0x85, 0x00, 0x09, 0xC1,
  // "Ō" (U+014C)
  0x28, 0x27, 0xCC, 0x47, 0x48, 0x31, 0xAC, 0xD9, 0x30, 0xC0, 0x52, 0x83, 0x89, 0x03, 0xC4, 0x82,
  0xE0, 0x59, 0x48, 0x2C, 0x25, 0x94, 0x82, 0xC2, 0x3C, 0x40, 0xE2, 0x0C, 0x05, 0x20, 0x80, 0x92,
  0x83, 0x1A, 0xCD, 0x92,
  // "ō" (U+014D)
  0x07, 0xCC, 0x40, 0x00, 0x00, 0x00, 0x06, 0xCC, 0x70, 0x2C, 0x00, 0xB3, 0x67, 0x00, 0x77, 0x67,
  0x00, 0x76, 0x2C, 0x00, 0xB3, 0x06, 0xCC, 0x60,
  // "Ŏ" (U+014E)
  0x28, 0x24, 0x01, 0x44, 0x82, 0x2C, 0xB1, 0x74, 0x83, 0x1A, 0xCD, 0x93, 0x0C, 0x05, 0x28, 0x38,
  0x90, 0x3C, 0x48, 0x2E, 0x05, 0x94, 0x82, 0xC2, 0x59, 0x48, 0x2C, 0x23, 0xC4, 0x0E, 0x20, 0xC0,
  0x52, 0x08, 0x09, 0x28, 0x31, 0xAC, 0xD9, 0x20,
  // "ŏ" (U+014F)
  0x04, 0x01, 0x40, 0x02, 0xCB, 0x10, 0x00, 0x00, 0x00, 0x06, 0xCC, 0x70, 0x2C, 0x00, 0xB3, 0x67,
  0x00, 0x77, 0x67, 0x00, 0x76, 0x2C, 0x00, 0xB3, 0x06, 0xCC, 0x60,
  // "Ő" (U+0150)
  0x38, 0x1B, 0x3A, 0x48, 0x25, 0x58, 0x27, 0x48, 0x31, 0xAC, 0xD9, 0x30, 0xC0, 0x52, 0x83, 0x89,
  0x03, 0xC4, 0x82, 0xE0, 0x59, 0x48, 0x2C, 0x25, 0x94, 0x82, 0xC2, 0x3C, 0x40, 0xE2, 0x0C, 0x05,
  0x20, 0x80, 0x92, 0x83, 0x1A, 0xCD, 0x92,
  // "ő" (U+0151)
  0x00, 0xB3, 0xA0, 0x05, 0x58, 0x20, 0x00, 0x00, 0x00, 0x06, 0xCC, 0x70, 0x2C, 0x00, 0xB3, 0x67,
  0x00, 0x77, 0x67, 0x00, 0x76, 0x2C, 0x00, 0xB3, 0x06, 0xCC, 0x60,
  // "Œ" (U+0152)
  0x01, 0xBD, 0xDE, 0xCC, 0x80, 0xC5, 0x01, 0xC0, 0x00, 0x3C, 0x00, 0x1C, 0x00, 0x05, 0x90, 0x01,
  0xEC, 0xC5, 0x59, 0x00, 0x1C, 0x00, 0x03, 0xC0, 0x01, 0xC0, 0x00, 0x0C, 0x50, 0x1C, 0x00, 0x00,
  0x1A, 0xCD, 0xEC, 0xC8,
  // "œ" (U+0153)
  0x06, 0xCC, 0x57, 0xCC, 0x32, 0xB0, 0x0D, 0x90, 0x2C, 0x67, 0x00, 0x9D, 0xCC, 0xC6, 0x70, 0x08,
  0x60, 0x00, 0x2C, 0x00, 0xCB, 0x00, 0x10, 0x6C, 0xC5, 0x6C, 0xC8,
  // "Ŕ" (U+0154)
  0x00, 0xD2, 0x00, 0x66, 0x00, 0x00, 0x00, 0x0F, 0xCC, 0x90, 0xD0, 0x09, 0x5D, 0x00, 0x67, 0xD0,
  0x0B, 0x4F, 0xCE, 0x70, 0xD0, 0x59, 0x0D, 0x00, 0xC3, 0xD0, 0x04, 0xB0,
  // "ŕ" (U+0155)
  0x00, 0xD2, 0x06, 0x60, 0x00, 0x00, 0x29, 0xAB, 0x2F, 0x20, 0x2C, 0x00, 0x2B, 0x00, 0x2B, 0x00,
  0x2B, 0x00,
  // "Ŗ" (U+0156)
  0xFC, 0xC9, 0x0D, 0x00, 0x95, 0xD0, 0x06, 0x7D, 0x00, 0xB4, 0xFC, 0xE7, 0x0D, 0x05, 0x90, 0xD0,
  0x0C, 0x3D, 0x00, 0x4B, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x03, 0x60, 0x00,
  // "ŗ" (U+0157)
  0x29, 0xAB, 0x2F, 0x20, 0x2C, 0x00, 0x2B, 0x00, 0x2B, 0x00, 0x2B, 0x00, 0x00, 0x00, 0x0A, 0x00,
  0x46, 0x00,
  // "Ř" (U+0158)
  0x57, 0x57, 0x00, 0xAC, 0x00, 0x00, 0x00, 0x0F, 0xCC, 0x90, 0xD0, 0x09, 0x5D, 0x00, 0x67, 0xD0,
  0x0B, 0x4F, 0xCE, 0x70, 0xD0, 0x59, 0x0D, 0x00, 0xC3, 0xD0, 0x04, 0xB0,
  // "ř" (U+0159)
  0x57, 0x57, 0x0A, 0xC0, 0x00, 0x00, 0x29, 0xAB, 0x2F, 0x20, 0x2C, 0x00, 0x2B, 0x00, 0x2B, 0x00,
  0x2B, 0x00,
  // "Ś" (U+015A)
  0x30, 0xD0, 0x22, 0x00, 0x67, 0x84, 0x8C, 0xD8, 0x4A, 0x28, 0x11, 0x5A, 0x48, 0x1B, 0xB3, 0x38,
  0x15, 0xD7, 0x40, 0xD0, 0x12, 0x85, 0x1C, 0x5D, 0xCB, 0x30,
  // "ś" (U+015B)
  0x20, 0xD0, 0x22, 0x00, 0x67, 0x85, 0x1B, 0xCC, 0x16, 0x63, 0x82, 0x2C, 0x71, 0x38, 0x26, 0xD1,
  0x12, 0x84, 0x94, 0x5D, 0xCA, 0x10,
  // "Ŝ" (U+015C)
  0x20, 0xA0, 0xC2, 0x82, 0x57, 0x57, 0x68, 0x48, 0xCD, 0x84, 0xA2, 0x81, 0x15, 0xA4, 0x81, 0xBB,
  0x33, 0x81, 0x5D, 0x74, 0x0D, 0x01, 0x28, 0x51, 0xC5, 0xDC, 0xB3,
  // "ŝ" (U+015D)
  0x0A, 0xC0, 0x05, 0x75, 0x70, 0x00, 0x00, 0x01, 0xBC, 0xC1, 0x66, 0x00, 0x02, 0xC7, 0x10, 0x00,
  0x6D, 0x11, 0x00, 0x94, 0x5D, 0xCA, 0x00,
  // "Ş" (U+015E)
  0x08, 0xCD, 0x84, 0xA0, 0x01, 0x5A, 0x00, 0x00, 0xBB, 0x30, 0x00, 0x5D, 0x70, 0x00, 0x0D, 0x10,
  0x01, 0xC5, 0xDC, 0xB3, 0x02, 0x40, 0x00, 0x1B, 0x00, 0x08, 0x90, 0x00,
  // "ş" (U+015F)
  0x1B, 0xCC, 0x16, 0x60, 0x00, 0x2C, 0x71, 0x00, 0x06, 0xD1, 0x10, 0x09, 0x45, 0xDC, 0xA0, 0x02,
  0x40, 0x00, 0x1B, 0x00, 0x08, 0x90, 0x00,
  // "Š" (U+0160)
  0x18, 0x25, 0x75, 0x72, 0x0A, 0x0C, 0x78, 0x48, 0xCD, 0x84, 0xA2, 0x81, 0x15, 0xA4, 0x81, 0xBB,
  0x33, 0x81, 0x5D, 0x74, 0x0D, 0x01, 0x28, 0x51, 0xC5, 0xDC, 0xB3,
  // "š" (U+0161)
  0x57, 0x57, 0x00, 0xAC, 0x00, 0x00, 0x00, 0x01, 0xBC, 0xC1, 0x66, 0x00, 0x02, 0xC7, 0x10, 0x00,
  0x6D, 0x11, 0x00, 0x94, 0x5D, 0xCA, 0x00,
  // "Ţ" (U+0162)
  0x84, 0xBC, 0xED, 0xC5, 0x20, 0xA0, 0x34, 0x0A, 0x03, 0x40, 0xA0, 0x34, 0x0A, 0x03, 0x40, 0xA0,
  0x34, 0x0A, 0x03, 0x40, 0xA0, 0x34, 0x02, 0x04, 0x40, 0x10, 0xB4, 0x08, 0x09, 0x20,
  // "ţ" (U+0163)
  0x04, 0x00, 0x0B, 0x00, 0x9E, 0xC4, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x0D, 0x00, 0x09, 0xD4,
  0x02, 0x40, 0x01, 0xB0, 0x08, 0x90,
  // "Ť" (U+0164)
  0x18, 0x25, 0x75, 0x73, 0x0A, 0x0C, 0x71, 0x84, 0xBC, 0xED, 0xC5, 0x20, 0xA0, 0x34, 0x0A, 0x03,
  0x40, 0xA0, 0x34, 0x0A, 0x03, 0x40, 0xA0, 0x34, 0x0A, 0x03, 0x40, 0xA0, 0x32,
  // "ť" (U+0165)
  0x38, 0x94, 0x38, 0x08, 0x05, 0x28, 0xEC, 0x40, 0x1C, 0x30, 0x10, 0xC3, 0x01, 0x0C, 0x40, 0xD4,
  0x81, 0x9D, 0x41,
  // "Ŧ" (U+0166)
  0xBC, 0xED, 0xC5, 0x00, 0xA3, 0x00, 0x00, 0xA3, 0x00, 0x00, 0xA3, 0x00, 0x2C, 0xED, 0x80, 0x00,
  0xA3, 0x00, 0x00, 0xA3, 0x00, 0x00, 0xA3, 0x00,
  // "ŧ" (U+0167)
  0x04, 0x00, 0x0B, 0x00, 0x9E, 0xC4, 0x1C, 0x00, 0x9E, 0xC3, 0x1C, 0x00, 0x0D, 0x00, 0x09, 0xD4,
  // "Ũ" (U+0168)
  0x18, 0x22, 0xC5, 0x83, 0x82, 0x71, 0x98, 0x72, 0x01, 0x0C, 0x38, 0x27, 0x61, 0xC3, 0x82, 0x76,
  0x1C, 0x38, 0x27, 0x61, 0xC3, 0x82, 0x76, 0x1C, 0x38, 0x27, 0x60, 0xD3, 0x89, 0x58, 0x50, 0xB3,
  0x01, 0xC1, 0x02, 0xBC, 0xC5, 0x10,
  // "ũ" (U+0169)
  0x02, 0xC5, 0x80, 0x07, 0x19, 0x80, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x85, 0x3A, 0x00, 0x85, 0x3A,
  0x00, 0x85, 0x3A, 0x00, 0x95, 0x1C, 0x00, 0xD5, 0x09, 0xDB, 0x95,
  // "Ū" (U+016A)
  0x28, 0x27, 0xCC, 0x47, 0x10, 0x10, 0xC3, 0x82, 0x76, 0x1C, 0x38, 0x27, 0x61, 0xC3, 0x82, 0x76,
  0x1C, 0x38, 0x27, 0x61, 0xC3, 0x82, 0x76, 0x0D, 0x38, 0x95, 0x85, 0x0B, 0x30, 0x1C, 0x10, 0x2B,
  0xCC, 0x51,
  // "ū" (U+016B)
  0x07, 0xCC, 0x40, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x85, 0x3A, 0x00, 0x85, 0x3A, 0x00, 0x85, 0x3A,
  0x00, 0x95, 0x1C, 0x00, 0xD5, 0x09, 0xDB, 0x95,
  // "Ŭ" (U+016C)
  0x28, 0x24, 0x01, 0x43, 0x82, 0x2C, 0xB1, 0x71, 0x01, 0x0C, 0x38, 0x27, 0x61, 0xC3, 0x82, 0x76,
  0x1C, 0x38, 0x27, 0x61, 0xC3, 0x82, 0x76, 0x1C, 0x38, 0x27, 0x60, 0xD3, 0x89, 0x58, 0x50, 0xB3,
  0x01, 0xC1, 0x02, 0xBC, 0xC5, 0x10,
  // "ŭ" (U+016D)
  0x04, 0x01, 0x40, 0x02, 0xCB, 0x10, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x85, 0x3A, 0x00, 0x85, 0x3A,
  0x00, 0x85, 0x3A, 0x00, 0x95, 0x1C, 0x00, 0xD5, 0x09, 0xDB, 0x95,
  // "Ů" (U+016E)
  0x00, 0x39, 0x30, 0x00, 0x08, 0x08, 0x00, 0x00, 0x39, 0x30, 0x01, 0xC0, 0x00, 0x76, 0x1C, 0x00,
  0x07, 0x61, 0xC0, 0x00, 0x76, 0x1C, 0x00, 0x07, 0x61, 0xC0, 0x00, 0x76, 0x0D, 0x00, 0x08, 0x50,
  0xB3, 0x01, 0xC1, 0x02, 0xBC, 0xC5, 0x00,
  // "ů" (U+016F)
  0x00, 0x39, 0x30, 0x00, 0x80, 0x80, 0x00, 0x39, 0x30, 0x3A, 0x00, 0x85, 0x3A, 0x00, 0x85, 0x3A,
  0x00, 0x85, 0x3A, 0x00, 0x95, 0x1C, 0x00, 0xD5, 0x09, 0xDB, 0x95,
  // "Ű" (U+0170)
  0x38, 0x1B, 0x3A, 0x38, 0x25, 0x58, 0x27, 0x10, 0x10, 0xC3, 0x82, 0x76, 0x1C, 0x38, 0x27, 0x61,
  0xC3, 0x82, 0x76, 0x1C, 0x38, 0x27, 0x61, 0xC3, 0x82, 0x76, 0x0D, 0x38, 0x95, 0x85, 0x0B, 0x30,
  0x1C, 0x10, 0x2B, 0xCC, 0x51,
  // "ű" (U+0171)
  0x00, 0xB3, 0xA0, 0x05, 0x58, 0x20, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x85, 0x3A, 0x00, 0x85, 0x3A,
  0x00, 0x85, 0x3A, 0x00, 0x95, 0x1C, 0x00, 0xD5, 0x09, 0xDB, 0x95,
  // "Ų" (U+0172)
  0x01, 0x0C, 0x38, 0x27, 0x61, 0xC3, 0x82, 0x76, 0x1C, 0x38, 0x27, 0x61, 0xC3, 0x82, 0x76, 0x1C,
  0x38, 0x27, 0x60, 0xD3, 0x89, 0x58, 0x50, 0xB3, 0x01, 0xD3, 0x02, 0xBC, 0xEA, 0x50, 0xB0, 0x15,
  0x0B, 0x60, 0xB0, 0x71,
  // "ų" (U+0173)
  0x3A, 0x00, 0x85, 0x3A, 0x00, 0x85, 0x3A, 0x00, 0x85, 0x3A, 0x00, 0x95, 0x1C, 0x00, 0xD5, 0x09,
  0xDB, 0x95, 0x00, 0x01, 0x60, 0x00, 0x07, 0x30, 0x00, 0x04, 0xC0,
  // "Ŵ" (U+0174)
  0x40, 0xA0, 0xC6, 0x82, 0x57, 0x57, 0x74, 0x0B, 0x02, 0x20, 0xE0, 0x32, 0x8D, 0x3D, 0x86, 0x03,
  0xD7, 0x01, 0xC4, 0x90, 0x76, 0xB0, 0x58, 0x0D, 0x0B, 0x1C, 0x08, 0x50, 0xC1, 0xC0, 0x84, 0xC1,
  0x09, 0x88, 0x04, 0x8C, 0x28, 0x15, 0xD4, 0x20, 0xD0, 0x92, 0x81, 0x1F, 0x12, 0x0C, 0x05, 0x10,
  // "ŵ" (U+0175)
  0x30, 0xA0, 0xC5, 0x82, 0x57, 0x57, 0x73, 0x8B, 0x5B, 0x20, 0xA8, 0x04, 0x98, 0x50, 0xBC, 0x07,
  0x54, 0x93, 0x8B, 0x1B, 0x20, 0xC7, 0x47, 0x5D, 0x28, 0x4C, 0xB0, 0x2B, 0x92, 0x08, 0x0B, 0x20,
  0xD0, 0x61,
  // "Ŷ" (U+0176)
  0x20, 0xA0, 0xC3, 0x82, 0x57, 0x57, 0x70, 0xB0, 0x32, 0x85, 0x96, 0x4B, 0x02, 0xD2, 0x82, 0xC4,
  0x96, 0x28, 0x15, 0xDE, 0x40, 0xD0, 0x74, 0x09, 0x04, 0x40, 0x90, 0x44, 0x09, 0x04, 0x20,
  // "ŷ" (U+0177)
  0x0A, 0xC0, 0x05, 0x75, 0x70, 0x00, 0x00, 0x0C, 0x10, 0x0D, 0x76, 0x04, 0x92, 0xB0, 0x94, 0x0C,
  0x1D, 0x00, 0x69, 0x90, 0x01, 0xE4, 0x00, 0x0D, 0x00, 0x05, 0x90, 0x0A, 0xC1, 0x00,
  // "Ÿ" (U+0178)
  0x18, 0x24, 0x36, 0x27, 0x0B, 0x03, 0x28, 0x59, 0x64, 0xB0, 0x2D, 0x28, 0x2C, 0x49, 0x62, 0x81,
  0x5D, 0xE4, 0x0D, 0x07, 0x40, 0x90, 0x44, 0x09, 0x04, 0x40, 0x90, 0x42,
  // "Ź" (U+0179)
  0x30, 0xD0, 0x23, 0x00, 0x67, 0x18, 0x46, 0xCC, 0xCF, 0x33, 0x04, 0x0B, 0x40, 0xC0, 0x33, 0x06,
  0x09, 0x38, 0x11, 0xD1, 0x30, 0x90, 0x73, 0x02, 0x0D, 0x48, 0x49, 0xEC, 0xCC, 0x40,
  // "ź" (U+017A)
  0x20, 0xD0, 0x22, 0x00, 0x67, 0x83, 0x5C, 0xCE, 0x32, 0x03, 0x0B, 0x30, 0xC0, 0x22, 0x00, 0x72,
  0x01, 0x0C, 0x38, 0x38, 0xDC, 0xC3,
  // "Ż" (U+017B)
  0x20, 0x50, 0x37, 0x18, 0x46, 0xCC, 0xCF, 0x33, 0x04, 0x0B, 0x40, 0xC0, 0x33, 0x06, 0x09, 0x38,
  0x11, 0xD1, 0x30, 0x90, 0x73, 0x02, 0x0D, 0x48, 0x49, 0xEC, 0xCC, 0x40,
  // "ż" (U+017C)
  0x05, 0x30, 0x00, 0x00, 0x00, 0x5C, 0xCE, 0x30, 0x03, 0xB0, 0x00, 0xC2, 0x00, 0x77, 0x00, 0x1C,
  0x00, 0x08, 0xDC, 0xC3,
  // "Ž" (U+017D)
  0x18, 0x25, 0x75, 0x73, 0x0A, 0x0C, 0x71, 0x84, 0x6C, 0xCC, 0xF3, 0x30, 0x40, 0xB4, 0x0C, 0x03,
  0x30, 0x60, 0x93, 0x81, 0x1D, 0x13, 0x09, 0x07, 0x30, 0x20, 0xD4, 0x84, 0x9E, 0xCC, 0xC4,
  // "ž" (U+017E)
  0x57, 0x57, 0x00, 0xAC, 0x00, 0x00, 0x00, 0x05, 0xCC, 0xE3, 0x00, 0x3B, 0x00, 0x0C, 0x20, 0x07,
  0x70, 0x01, 0xC0, 0x00, 0x8D, 0xCC, 0x30,
  // "ſ" (U+017F)
  0x09, 0xC6, 0x1C, 0x00, 0x2B, 0x00, 0x2B, 0x00, 0x2B, 0x00, 0x2B, 0x00, 0x2B, 0x00, 0x2B, 0x00,
  // "Ω" (U+03A9)
  0x01, 0xAC, 0xC9, 0x00, 0x0C, 0x40, 0x07, 0xA0, 0x3B, 0x00, 0x00, 0xD1, 0x59, 0x00, 0x00, 0xC2,
  0x4A, 0x00, 0x00, 0xD1, 0x0D, 0x00, 0x01, 0xC0, 0x06, 0x80, 0x0A, 0x40, 0x7C, 0xF3, 0x6E, 0xC5,
  // "μ" (U+03BC)
  0x2B, 0x00, 0x75, 0x2B, 0x00, 0x75, 0x2B, 0x00, 0x75, 0x2B, 0x00, 0x85, 0x2D, 0x00, 0xC5, 0x2D,
  0xCB, 0x95, 0x2B, 0x00, 0x00, 0x2B, 0x00, 0x00, 0x2B, 0x00, 0x00,
  // "π" (U+03C0)
  0x8E, 0xCC, 0xED, 0x30, 0xC1, 0x0A, 0x30, 0x0C, 0x10, 0xA3, 0x00, 0xC1, 0x0A, 0x30, 0x0C, 0x10,
  0xA3, 0x00, 0xC1, 0x06, 0xD1,
  // "–" (U+2013)
  0x7C, 0xCC, 0x70,
  // "—" (U+2014)
  0x07, 0x80, 0x4C, 0x07,
  // "€" (U+20AC)
  0x00, 0x9C, 0xD4, 0x07, 0x80, 0x01, 0x0C, 0x10, 0x00, 0x8E, 0xBB, 0x30, 0x8E, 0xBB, 0x00, 0x0C,
  0x10, 0x00, 0x06, 0x90, 0x00, 0x00, 0x8C, 0xC4,
  // "₿" (U+20BF)
  0x01, 0x10, 0x01, 0x89, 0x00, 0xFC, 0xD8, 0x0D, 0x00, 0xD1, 0xD0, 0x1D, 0x0F, 0xCE, 0x60, 0xD0,
  0x0C, 0x2D, 0x00, 0x95, 0xD0, 0x0C, 0x3F, 0xCD, 0x80, 0x18, 0x90, 0x00,
  // "‘" (U+2018)
  0x38, 0x85, 0xA2,
  // "’" (U+2019)
  0x77, 0x93, 0x90,
  // "‚" (U+201A)
  0x77, 0x93, 0x90,
  // "‛" (U+201B)
  0xB3, 0x75, 0x27,
  // "“" (U+201C)
  0x38, 0x55, 0x85, 0xA2, 0xA2, 0xC0,
  // "”" (U+201D)
  0x77, 0x95, 0x93, 0xC1, 0x90, 0x90,
  // "„" (U+201E)
  0x77, 0x95, 0x93, 0xC1, 0x90, 0x90,
  // "‟" (U+201F)
  0xB3, 0xE0, 0x75, 0xA3, 0x27, 0x45,
  // "†" (U+2020)
  0x20, 0xD4, 0x0A, 0x28, 0x34, 0xBC, 0xB6, 0x20, 0x84, 0x0A, 0x40, 0xB4, 0x0D, 0x40, 0xE2,
  // "‡" (U+2021)
  0x00, 0xD0, 0x00, 0x1A, 0x11, 0x49, 0xC9, 0x50, 0x0C, 0x00, 0x00, 0xC0, 0x04, 0x9C, 0x95, 0x12,
  0xA2, 0x10, 0x0D, 0x00,
  // "•" (U+2022)
  0x0B, 0x83, 0xFE, 0x0D, 0xA0,
  // "…" (U+2026)
  0x01, 0x00, 0x10, 0x12, 0xC0, 0x2C, 0x2C,
  // "‰" (U+2030)
  0x1C, 0xB0, 0x07, 0x40, 0x00, 0x00, 0x65, 0x65, 0x0A, 0x00, 0x00, 0x00, 0x73, 0x46, 0x74, 0x00,
  0x00, 0x00, 0x55, 0x75, 0xB7, 0xC3, 0x2C, 0x90, 0x0B, 0xA7, 0x5B, 0x1A, 0x83, 0x92, 0x00, 0x0B,
  0x19, 0x0B, 0xA0, 0x73, 0x00, 0x74, 0x0A, 0x0A, 0x82, 0x92, 0x00, 0xB0, 0x08, 0xC4, 0x2C, 0xA0,
  // "‹" (U+2039)
  0x02, 0x51, 0xB1, 0x68, 0x00, 0xA4, 0x00, 0x20,
  // "›" (U+203A)
  0x43, 0x01, 0xB1, 0x06, 0x82, 0xB0, 0x21, 0x00,
  // "⁄" (U+2044)
  0x40, 0xA3, 0x00, 0x53, 0x0B, 0x30, 0x70, 0x42, 0x01, 0x0A, 0x30, 0x80, 0x32, 0x01, 0x09, 0x30,
  0x90, 0x23,
  // "™" (U+2122)
  0x7A, 0x79, 0x30, 0xB0, 0x90, 0x98, 0x5C, 0x09, 0x09, 0x88, 0x90, 0x70, 0x63, 0x57,
  // "⅒" (U+2152)
  0x50, 0xA5, 0x84, 0x2B, 0x60, 0x55, 0x58, 0x31, 0x56, 0x0B, 0x78, 0x24, 0x67, 0x42, 0x81, 0x3B,
  0x82, 0x89, 0x04, 0x7A, 0x2B, 0x6A, 0x19, 0x22, 0x89, 0x28, 0x31, 0x56, 0xB0, 0x64, 0x01, 0x92,
  0x87, 0x46, 0xA1, 0x92, 0x09, 0x22, 0x83, 0x46, 0x3B, 0x91,
  // "ﬁ" (U+FB01)
  0x06, 0xDA, 0x70, 0xD0, 0x00, 0x8F, 0xC6, 0xB0, 0xD0, 0x2B, 0x0D, 0x02, 0xB0, 0xD0, 0x2B, 0x0D,
  0x02, 0xB0, 0xD0, 0x2B,
  // "ﬂ" (U+FB02)
  0x06, 0xDB, 0xB0, 0xD0, 0x2B, 0x8F, 0xC6, 0xB0, 0xD0, 0x2B, 0x0D, 0x02, 0xB0, 0xD0, 0x2B, 0x0D,
  0x02, 0xB0, 0xD0, 0x2B,
};

const Font& font_NotoSans_Regular_10() {
  static SmoothFont font(font_NotoSans_Regular_10_data);
  return font;
}

}  // namespace roo_display
