#include "8.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSans-CondensedItalic (Noto Sans Condensed Italic)
// Generated on Wed Nov 19 19:11:24 CET 2025
static const uint8_t font_NotoSans_CondensedItalic_8_data[] PROGMEM = {
  
  // Header
  0x01, 0x02, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x00, 0x36,
  0xFE, 0xFE, 0x07, 0x0A, 0x07, 0xFE, 0x04, 0x01, 0x08, 0x03, 0x02, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x40, 0x01, 0x01, 0x07, 0x02, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x40, 0x05, 0x02, 0x07, 0x03, 0x00, 0x07, // """ (U+0022)
  0x00, 0x23, 0x40, 0x01, 0x03, 0x07, 0x04, 0x00, 0x0C, // "#" (U+0023)
  0x00, 0x24, 0x40, 0x01, 0x03, 0x07, 0x04, 0x00, 0x1A, // "$" (U+0024)
  0x00, 0x25, 0x40, 0x01, 0x04, 0x07, 0x05, 0x00, 0x28, // "%" (U+0025)
  0x00, 0x26, 0x40, 0x01, 0x03, 0x07, 0x04, 0x00, 0x3A, // "&" (U+0026)
  0x00, 0x27, 0x40, 0x06, 0x01, 0x07, 0x02, 0x00, 0x48, // "'" (U+0027)
  0x00, 0x28, 0x40, 0x00, 0x02, 0x07, 0x02, 0x00, 0x4A, // "(" (U+0028)
  0x00, 0x29, 0xBF, 0x00, 0x01, 0x07, 0x02, 0x00, 0x56, // ")" (U+0029)
  0x00, 0x2A, 0x40, 0x04, 0x03, 0x07, 0x03, 0x00, 0x62, // "*" (U+002A)
  0x00, 0x2B, 0x40, 0x02, 0x03, 0x05, 0x04, 0x00, 0x6A, // "+" (U+002B)
  0x00, 0x2C, 0xBF, 0x00, 0x00, 0x01, 0x02, 0x00, 0x72, // "," (U+002C)
  0x00, 0x2D, 0x40, 0x03, 0x01, 0x03, 0x02, 0x00, 0x74, // "-" (U+002D)
  0x00, 0x2E, 0x40, 0x01, 0x00, 0x01, 0x02, 0x00, 0x75, // "." (U+002E)
  0x00, 0x2F, 0xFF, 0x01, 0x03, 0x07, 0x03, 0x00, 0x76, // "/" (U+002F)
  0x00, 0x30, 0x40, 0x01, 0x03, 0x07, 0x04, 0x00, 0x85, // "0" (U+0030)
  0x00, 0x31, 0x41, 0x01, 0x02, 0x07, 0x04, 0x00, 0x93, // "1" (U+0031)
  0x00, 0x32, 0xBF, 0x01, 0x03, 0x07, 0x04, 0x00, 0x9A, // "2" (U+0032)
  0x00, 0x33, 0x40, 0x01, 0x03, 0x07, 0x04, 0x00, 0xAC, // "3" (U+0033)
  0x00, 0x34, 0x40, 0x01, 0x03, 0x07, 0x04, 0x00, 0xBA, // "4" (U+0034)
  0x00, 0x35, 0x40, 0x01, 0x03, 0x07, 0x04, 0x00, 0xC8, // "5" (U+0035)
  0x00, 0x36, 0x40, 0x01, 0x03, 0x07, 0x04, 0x00, 0xD6, // "6" (U+0036)
  0x00, 0x37, 0x40, 0x01, 0x03, 0x07, 0x04, 0x00, 0xE4, // "7" (U+0037)
  0x00, 0x38, 0x40, 0x01, 0x03, 0x07, 0x04, 0x00, 0xF2, // "8" (U+0038)
  0x00, 0x39, 0x40, 0x01, 0x03, 0x07, 0x04, 0x01, 0x00, // "9" (U+0039)
  0x00, 0x3A, 0x00, 0x01, 0x01, 0x05, 0x02, 0x01, 0x0E, // ":" (U+003A)
  0x00, 0x3B, 0xFF, 0x00, 0x01, 0x05, 0x02, 0x01, 0x12, // ";" (U+003B)
  0x00, 0x3C, 0x40, 0x02, 0x03, 0x05, 0x04, 0x01, 0x1A, // "<" (U+003C)
  0x00, 0x3D, 0x40, 0x03, 0x03, 0x05, 0x04, 0x01, 0x22, // "=" (U+003D)
  0x00, 0x3E, 0x40, 0x02, 0x03, 0x05, 0x04, 0x01, 0x28, // ">" (U+003E)
  0x00, 0x3F, 0x40, 0x01, 0x02, 0x07, 0x03, 0x01, 0x30, // "?" (U+003F)
  0x00, 0x40, 0x40, 0x00, 0x05, 0x07, 0x05, 0x01, 0x3B, // "@" (U+0040)
  0x00, 0x41, 0xBF, 0x01, 0x03, 0x07, 0x04, 0x01, 0x53, // "A" (U+0041)
  0x00, 0x42, 0x40, 0x01, 0x03, 0x07, 0x04, 0x01, 0x65, // "B" (U+0042)
  0x00, 0x43, 0x40, 0x01, 0x03, 0x07, 0x04, 0x01, 0x73, // "C" (U+0043)
  0x00, 0x44, 0x40, 0x01, 0x03, 0x07, 0x04, 0x01, 0x81, // "D" (U+0044)
  0x00, 0x45, 0x40, 0x01, 0x03, 0x07, 0x03, 0x01, 0x8F, // "E" (U+0045)
  0x00, 0x46, 0x40, 0x01, 0x03, 0x07, 0x03, 0x01, 0x9D, // "F" (U+0046)
  0x00, 0x47, 0x40, 0x01, 0x04, 0x07, 0x04, 0x01, 0xAB, // "G" (U+0047)
  0x00, 0x48, 0x40, 0x01, 0x04, 0x07, 0x04, 0x01, 0xBD, // "H" (U+0048)
  0x00, 0x49, 0xBF, 0x01, 0x02, 0x07, 0x02, 0x01, 0xCF, // "I" (U+0049)
  0x00, 0x4A, 0xBE, 0x00, 0x01, 0x07, 0x02, 0x01, 0xDD, // "J" (U+004A)
  0x00, 0x4B, 0x40, 0x01, 0x04, 0x07, 0x04, 0x01, 0xED, // "K" (U+004B)
  0x00, 0x4C, 0x40, 0x01, 0x02, 0x07, 0x03, 0x01, 0xFF, // "L" (U+004C)
  0x00, 0x4D, 0x40, 0x01, 0x05, 0x07, 0x06, 0x02, 0x0A, // "M" (U+004D)
  0x00, 0x4E, 0x40, 0x01, 0x04, 0x07, 0x05, 0x02, 0x1F, // "N" (U+004E)
  0x00, 0x4F, 0x40, 0x01, 0x04, 0x07, 0x05, 0x02, 0x31, // "O" (U+004F)
  0x00, 0x50, 0x40, 0x01, 0x03, 0x07, 0x04, 0x02, 0x43, // "P" (U+0050)
  0x00, 0x51, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x02, 0x51, // "Q" (U+0051)
  0x00, 0x52, 0x40, 0x01, 0x03, 0x07, 0x04, 0x02, 0x68, // "R" (U+0052)
  0x00, 0x53, 0x40, 0x01, 0x03, 0x07, 0x03, 0x02, 0x76, // "S" (U+0053)
  0x00, 0x54, 0x40, 0x01, 0x03, 0x07, 0x03, 0x02, 0x84, // "T" (U+0054)
  0x00, 0x55, 0x40, 0x01, 0x04, 0x07, 0x04, 0x02, 0x92, // "U" (U+0055)
  0x00, 0x56, 0x40, 0x01, 0x04, 0x07, 0x04, 0x02, 0xA4, // "V" (U+0056)
  0x00, 0x57, 0x40, 0x01, 0x06, 0x07, 0x06, 0x02, 0xB6, // "W" (U+0057)
  0x00, 0x58, 0xBF, 0x01, 0x03, 0x07, 0x03, 0x02, 0xCF, // "X" (U+0058)
  0x00, 0x59, 0x40, 0x01, 0x03, 0x07, 0x03, 0x02, 0xE1, // "Y" (U+0059)
  0x00, 0x5A, 0xBF, 0x01, 0x03, 0x07, 0x03, 0x02, 0xEF, // "Z" (U+005A)
  0x00, 0x5B, 0xBF, 0x00, 0x02, 0x07, 0x02, 0x03, 0x01, // "[" (U+005B)
  0x00, 0x5C, 0x40, 0x01, 0x02, 0x07, 0x03, 0x03, 0x11, // "\" (U+005C)
  0x00, 0x5D, 0xBF, 0x00, 0x02, 0x07, 0x02, 0x03, 0x1C, // "]" (U+005D)
  0x00, 0x5E, 0x40, 0x04, 0x03, 0x07, 0x04, 0x03, 0x2C, // "^" (U+005E)
  0x00, 0x5F, 0xBF, 0xFF, 0x01, 0xFF, 0x03, 0x03, 0x34, // "_" (U+005F)
  0x00, 0x60, 0x41, 0x07, 0x02, 0x08, 0x02, 0x03, 0x36, // "`" (U+0060)
  0x00, 0x61, 0x40, 0x01, 0x03, 0x05, 0x04, 0x03, 0x38, // "a" (U+0061)
  0x00, 0x62, 0x40, 0x01, 0x03, 0x07, 0x04, 0x03, 0x42, // "b" (U+0062)
  0x00, 0x63, 0x40, 0x01, 0x02, 0x05, 0x03, 0x03, 0x50, // "c" (U+0063)
  0x00, 0x64, 0x40, 0x01, 0x03, 0x07, 0x04, 0x03, 0x58, // "d" (U+0064)
  0x00, 0x65, 0x40, 0x01, 0x03, 0x05, 0x03, 0x03, 0x66, // "e" (U+0065)
  0x00, 0x66, 0xBF, 0xFF, 0x02, 0x07, 0x02, 0x03, 0x70, // "f" (U+0066)
  0x00, 0x67, 0x40, 0xFF, 0x03, 0x05, 0x04, 0x03, 0x82, // "g" (U+0067)
  0x00, 0x68, 0x40, 0x01, 0x03, 0x07, 0x04, 0x03, 0x90, // "h" (U+0068)
  0x00, 0x69, 0x40, 0x01, 0x01, 0x07, 0x02, 0x03, 0x9E, // "i" (U+0069)
  0x00, 0x6A, 0xBF, 0xFF, 0x01, 0x07, 0x02, 0x03, 0xA5, // "j" (U+006A)
  0x00, 0x6B, 0x40, 0x01, 0x03, 0x07, 0x03, 0x03, 0xB3, // "k" (U+006B)
  0x00, 0x6C, 0x40, 0x01, 0x01, 0x07, 0x02, 0x03, 0xC1, // "l" (U+006C)
  0x00, 0x6D, 0x40, 0x01, 0x05, 0x05, 0x06, 0x03, 0xC8, // "m" (U+006D)
  0x00, 0x6E, 0x40, 0x01, 0x03, 0x05, 0x04, 0x03, 0xD7, // "n" (U+006E)
  0x00, 0x6F, 0x40, 0x01, 0x03, 0x05, 0x04, 0x03, 0xE1, // "o" (U+006F)
  0x00, 0x70, 0xBF, 0xFF, 0x03, 0x05, 0x04, 0x03, 0xEB, // "p" (U+0070)
  0x00, 0x71, 0x40, 0xFF, 0x03, 0x05, 0x04, 0x03, 0xFD, // "q" (U+0071)
  0x00, 0x72, 0x40, 0x01, 0x02, 0x05, 0x03, 0x04, 0x0B, // "r" (U+0072)
  0x00, 0x73, 0x40, 0x01, 0x02, 0x05, 0x03, 0x04, 0x13, // "s" (U+0073)
  0x00, 0x74, 0x40, 0x01, 0x02, 0x06, 0x02, 0x04, 0x1B, // "t" (U+0074)
  0x00, 0x75, 0x40, 0x01, 0x03, 0x05, 0x04, 0x04, 0x24, // "u" (U+0075)
  0x00, 0x76, 0x40, 0x01, 0x03, 0x05, 0x03, 0x04, 0x2E, // "v" (U+0076)
  0x00, 0x77, 0x40, 0x01, 0x04, 0x05, 0x05, 0x04, 0x38, // "w" (U+0077)
  0x00, 0x78, 0xBF, 0x01, 0x03, 0x05, 0x03, 0x04, 0x45, // "x" (U+0078)
  0x00, 0x79, 0xBF, 0xFF, 0x03, 0x05, 0x03, 0x04, 0x52, // "y" (U+0079)
  0x00, 0x7A, 0xBF, 0x01, 0x02, 0x05, 0x03, 0x04, 0x64, // "z" (U+007A)
  0x00, 0x7B, 0x40, 0x00, 0x02, 0x07, 0x03, 0x04, 0x6E, // "{" (U+007B)
  0x00, 0x7C, 0x01, 0xFF, 0x01, 0x07, 0x03, 0x04, 0x7A, // "|" (U+007C)
  0x00, 0x7D, 0xBF, 0x00, 0x02, 0x07, 0x03, 0x04, 0x7C, // "}" (U+007D)
  0x00, 0x7E, 0x40, 0x03, 0x03, 0x03, 0x04, 0x04, 0x8C, // "~" (U+007E)
  0x00, 0xA1, 0x40, 0xFF, 0x01, 0x05, 0x02, 0x04, 0x8E, // "¡" (U+00A1)
  0x00, 0xA2, 0x40, 0x01, 0x03, 0x07, 0x04, 0x04, 0x95, // "¢" (U+00A2)
  0x00, 0xA3, 0xBF, 0x01, 0x03, 0x07, 0x04, 0x04, 0xA3, // "£" (U+00A3)
  0x00, 0xA4, 0x40, 0x02, 0x03, 0x05, 0x04, 0x04, 0xB5, // "¤" (U+00A4)
  0x00, 0xA5, 0x40, 0x01, 0x03, 0x07, 0x04, 0x04, 0xBD, // "¥" (U+00A5)
  0x00, 0xA6, 0x01, 0xFF, 0x01, 0x07, 0x03, 0x04, 0xCB, // "¦" (U+00A6)
  0x00, 0xA7, 0x40, 0x01, 0x03, 0x07, 0x03, 0x04, 0xCF, // "§" (U+00A7)
  0x00, 0xA8, 0x41, 0x07, 0x03, 0x07, 0x04, 0x04, 0xDD, // "¨" (U+00A8)
  0x00, 0xA9, 0x40, 0x01, 0x06, 0x07, 0x07, 0x04, 0xDF, // "©" (U+00A9)
  0x00, 0xAA, 0x40, 0x04, 0x02, 0x06, 0x02, 0x04, 0xF8, // "ª" (U+00AA)
  0x00, 0xAB, 0x40, 0x01, 0x03, 0x04, 0x03, 0x04, 0xFD, // "«" (U+00AB)
  0x00, 0xAC, 0x40, 0x02, 0x03, 0x04, 0x04, 0x05, 0x05, // "¬" (U+00AC)
  0x00, 0xAE, 0x40, 0x01, 0x06, 0x07, 0x07, 0x05, 0x0B, // "®" (U+00AE)
  0x00, 0xAF, 0x40, 0x08, 0x03, 0x08, 0x03, 0x05, 0x24, // "¯" (U+00AF)
  0x00, 0xB0, 0x40, 0x05, 0x02, 0x07, 0x03, 0x05, 0x26, // "°" (U+00B0)
  0x00, 0xB1, 0x40, 0x01, 0x03, 0x05, 0x04, 0x05, 0x2B, // "±" (U+00B1)
  0x00, 0xB2, 0x40, 0x04, 0x02, 0x07, 0x02, 0x05, 0x35, // "²" (U+00B2)
  0x00, 0xB3, 0x40, 0x04, 0x02, 0x07, 0x02, 0x05, 0x3B, // "³" (U+00B3)
  0x00, 0xB4, 0x41, 0x07, 0x02, 0x08, 0x02, 0x05, 0x41, // "´" (U+00B4)
  0x00, 0xB5, 0xBF, 0xFF, 0x03, 0x05, 0x04, 0x05, 0x43, // "µ" (U+00B5)
  0x00, 0xB6, 0x40, 0xFF, 0x03, 0x07, 0x04, 0x05, 0x55, // "¶" (U+00B6)
  0x00, 0xB7, 0x40, 0x03, 0x00, 0x03, 0x02, 0x05, 0x67, // "·" (U+00B7)
  0x00, 0xB8, 0xBF, 0xFF, 0x00, 0x01, 0x02, 0x05, 0x68, // "¸" (U+00B8)
  0x00, 0xB9, 0x41, 0x04, 0x02, 0x07, 0x02, 0x05, 0x6B, // "¹" (U+00B9)
  0x00, 0xBA, 0x40, 0x04, 0x02, 0x06, 0x02, 0x05, 0x6F, // "º" (U+00BA)
  0x00, 0xBB, 0x40, 0x01, 0x03, 0x04, 0x04, 0x05, 0x74, // "»" (U+00BB)
  0x00, 0xBC, 0x40, 0x01, 0x04, 0x07, 0x05, 0x05, 0x7C, // "¼" (U+00BC)
  0x00, 0xBD, 0x40, 0x01, 0x05, 0x07, 0x06, 0x05, 0x8E, // "½" (U+00BD)
  0x00, 0xBE, 0x40, 0x01, 0x05, 0x07, 0x06, 0x05, 0xA3, // "¾" (U+00BE)
  0x00, 0xBF, 0x40, 0xFE, 0x02, 0x04, 0x03, 0x05, 0xB8, // "¿" (U+00BF)
  0x00, 0xC0, 0xBF, 0x01, 0x03, 0x09, 0x04, 0x05, 0xC3, // "À" (U+00C0)
  0x00, 0xC1, 0xBF, 0x01, 0x03, 0x09, 0x04, 0x05, 0xDA, // "Á" (U+00C1)
  0x00, 0xC2, 0xBF, 0x01, 0x03, 0x09, 0x04, 0x05, 0xF1, // "Â" (U+00C2)
  0x00, 0xC3, 0xBF, 0x01, 0x04, 0x07, 0x04, 0x06, 0x08, // "Ã" (U+00C3)
  0x00, 0xC4, 0xBF, 0x01, 0x03, 0x08, 0x04, 0x06, 0x1D, // "Ä" (U+00C4)
  0x00, 0xC5, 0xBF, 0x01, 0x03, 0x08, 0x04, 0x06, 0x31, // "Å" (U+00C5)
  0x00, 0xC6, 0xFF, 0x01, 0x05, 0x07, 0x05, 0x06, 0x45, // "Æ" (U+00C6)
  0x00, 0xC7, 0x40, 0xFF, 0x03, 0x07, 0x04, 0x06, 0x5D, // "Ç" (U+00C7)
  0x00, 0xC8, 0x40, 0x01, 0x03, 0x09, 0x03, 0x06, 0x6F, // "È" (U+00C8)
  0x00, 0xC9, 0x40, 0x01, 0x03, 0x09, 0x03, 0x06, 0x81, // "É" (U+00C9)
  0x00, 0xCA, 0x40, 0x01, 0x03, 0x09, 0x03, 0x06, 0x93, // "Ê" (U+00CA)
  0x00, 0xCB, 0x40, 0x01, 0x03, 0x08, 0x03, 0x06, 0xA5, // "Ë" (U+00CB)
  0x00, 0xCC, 0xBF, 0x01, 0x02, 0x09, 0x02, 0x06, 0xB5, // "Ì" (U+00CC)
  0x00, 0xCD, 0xFF, 0x01, 0x03, 0x09, 0x02, 0x06, 0xC7, // "Í" (U+00CD)
  0x00, 0xCE, 0xBF, 0x01, 0x02, 0x09, 0x02, 0x06, 0xDC, // "Î" (U+00CE)
  0x00, 0xCF, 0xFF, 0x01, 0x03, 0x08, 0x02, 0x06, 0xEE, // "Ï" (U+00CF)
  0x00, 0xD0, 0x40, 0x01, 0x03, 0x07, 0x04, 0x07, 0x01, // "Ð" (U+00D0)
  0x00, 0xD1, 0x40, 0x01, 0x04, 0x07, 0x05, 0x07, 0x0F, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x40, 0x01, 0x04, 0x09, 0x05, 0x07, 0x21, // "Ò" (U+00D2)
  0x00, 0xD3, 0x40, 0x01, 0x04, 0x09, 0x05, 0x07, 0x38, // "Ó" (U+00D3)
  0x00, 0xD4, 0x40, 0x01, 0x04, 0x09, 0x05, 0x07, 0x4F, // "Ô" (U+00D4)
  0x00, 0xD5, 0x40, 0x01, 0x04, 0x07, 0x05, 0x07, 0x66, // "Õ" (U+00D5)
  0x00, 0xD6, 0x40, 0x01, 0x04, 0x08, 0x05, 0x07, 0x78, // "Ö" (U+00D6)
  0x00, 0xD7, 0x40, 0x02, 0x03, 0x05, 0x04, 0x07, 0x8C, // "×" (U+00D7)
  0x00, 0xD8, 0x00, 0x00, 0x04, 0x08, 0x05, 0x07, 0x94, // "Ø" (U+00D8)
  0x00, 0xD9, 0x40, 0x01, 0x04, 0x09, 0x04, 0x07, 0xA9, // "Ù" (U+00D9)
  0x00, 0xDA, 0x40, 0x01, 0x04, 0x09, 0x04, 0x07, 0xC0, // "Ú" (U+00DA)
  0x00, 0xDB, 0x40, 0x01, 0x04, 0x09, 0x04, 0x07, 0xD7, // "Û" (U+00DB)
  0x00, 0xDC, 0x40, 0x01, 0x04, 0x08, 0x04, 0x07, 0xEE, // "Ü" (U+00DC)
  0x00, 0xDD, 0x40, 0x01, 0x03, 0x09, 0x03, 0x08, 0x02, // "Ý" (U+00DD)
  0x00, 0xDE, 0x40, 0x01, 0x03, 0x07, 0x04, 0x08, 0x14, // "Þ" (U+00DE)
  0x00, 0xDF, 0xBF, 0xFF, 0x03, 0x07, 0x04, 0x08, 0x22, // "ß" (U+00DF)
  0x00, 0xE0, 0x40, 0x01, 0x03, 0x08, 0x04, 0x08, 0x39, // "à" (U+00E0)
  0x00, 0xE1, 0x40, 0x01, 0x03, 0x08, 0x04, 0x08, 0x49, // "á" (U+00E1)
  0x00, 0xE2, 0x40, 0x01, 0x03, 0x08, 0x04, 0x08, 0x59, // "â" (U+00E2)
  0x00, 0xE3, 0x40, 0x01, 0x03, 0x06, 0x04, 0x08, 0x69, // "ã" (U+00E3)
  0x00, 0xE4, 0x40, 0x01, 0x03, 0x07, 0x04, 0x08, 0x75, // "ä" (U+00E4)
  0x00, 0xE5, 0x40, 0x01, 0x03, 0x07, 0x04, 0x08, 0x83, // "å" (U+00E5)
  0x00, 0xE6, 0x40, 0x01, 0x05, 0x05, 0x05, 0x08, 0x91, // "æ" (U+00E6)
  0x00, 0xE7, 0x40, 0xFF, 0x02, 0x05, 0x03, 0x08, 0xA0, // "ç" (U+00E7)
  0x00, 0xE8, 0x40, 0x01, 0x03, 0x08, 0x03, 0x08, 0xAB, // "è" (U+00E8)
  0x00, 0xE9, 0x40, 0x01, 0x03, 0x08, 0x03, 0x08, 0xBB, // "é" (U+00E9)
  0x00, 0xEA, 0x40, 0x01, 0x03, 0x08, 0x03, 0x08, 0xCB, // "ê" (U+00EA)
  0x00, 0xEB, 0x40, 0x01, 0x03, 0x07, 0x03, 0x08, 0xDB, // "ë" (U+00EB)
  0x00, 0xEC, 0x40, 0x01, 0x01, 0x08, 0x02, 0x08, 0xE9, // "ì" (U+00EC)
  0x00, 0xED, 0x40, 0x01, 0x02, 0x08, 0x02, 0x08, 0xF1, // "í" (U+00ED)
  0x00, 0xEE, 0x40, 0x01, 0x01, 0x08, 0x02, 0x08, 0xFD, // "î" (U+00EE)
  0x00, 0xEF, 0x40, 0x01, 0x02, 0x07, 0x02, 0x09, 0x05, // "ï" (U+00EF)
  0x00, 0xF0, 0x40, 0x01, 0x03, 0x08, 0x04, 0x09, 0x10, // "ð" (U+00F0)
  0x00, 0xF1, 0x40, 0x01, 0x03, 0x06, 0x04, 0x09, 0x20, // "ñ" (U+00F1)
  0x00, 0xF2, 0x40, 0x01, 0x03, 0x08, 0x04, 0x09, 0x2C, // "ò" (U+00F2)
  0x00, 0xF3, 0x40, 0x01, 0x03, 0x08, 0x04, 0x09, 0x3C, // "ó" (U+00F3)
  0x00, 0xF4, 0x40, 0x01, 0x03, 0x08, 0x04, 0x09, 0x4C, // "ô" (U+00F4)
  0x00, 0xF5, 0x40, 0x01, 0x03, 0x06, 0x04, 0x09, 0x5C, // "õ" (U+00F5)
  0x00, 0xF6, 0x40, 0x01, 0x03, 0x07, 0x04, 0x09, 0x68, // "ö" (U+00F6)
  0x00, 0xF7, 0x40, 0x02, 0x03, 0x05, 0x04, 0x09, 0x76, // "÷" (U+00F7)
  0x00, 0xF8, 0x40, 0x00, 0x03, 0x06, 0x04, 0x09, 0x7E, // "ø" (U+00F8)
  0x00, 0xF9, 0x40, 0x01, 0x03, 0x08, 0x04, 0x09, 0x8C, // "ù" (U+00F9)
  0x00, 0xFA, 0x40, 0x01, 0x03, 0x08, 0x04, 0x09, 0x9C, // "ú" (U+00FA)
  0x00, 0xFB, 0x40, 0x01, 0x03, 0x08, 0x04, 0x09, 0xAC, // "û" (U+00FB)
  0x00, 0xFC, 0x40, 0x01, 0x03, 0x07, 0x04, 0x09, 0xBC, // "ü" (U+00FC)
  0x00, 0xFD, 0xFF, 0xFF, 0x03, 0x08, 0x03, 0x09, 0xCA, // "ý" (U+00FD)
  0x00, 0xFE, 0xFF, 0xFF, 0x03, 0x07, 0x04, 0x09, 0xE1, // "þ" (U+00FE)
  0x00, 0xFF, 0xFF, 0xFF, 0x03, 0x07, 0x03, 0x09, 0xF6, // "ÿ" (U+00FF)
  0x01, 0x00, 0xBF, 0x01, 0x03, 0x07, 0x04, 0x0A, 0x0C, // "Ā" (U+0100)
  0x01, 0x01, 0x40, 0x01, 0x03, 0x06, 0x04, 0x0A, 0x1E, // "ā" (U+0101)
  0x01, 0x02, 0xBF, 0x01, 0x03, 0x08, 0x04, 0x0A, 0x2A, // "Ă" (U+0102)
  0x01, 0x03, 0x40, 0x01, 0x03, 0x07, 0x04, 0x0A, 0x3E, // "ă" (U+0103)
  0x01, 0x04, 0xBF, 0xFF, 0x03, 0x07, 0x04, 0x0A, 0x4C, // "Ą" (U+0104)
  0x01, 0x05, 0x40, 0xFF, 0x03, 0x05, 0x04, 0x0A, 0x63, // "ą" (U+0105)
  0x01, 0x06, 0x40, 0x01, 0x03, 0x09, 0x04, 0x0A, 0x71, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x01, 0x03, 0x08, 0x03, 0x0A, 0x83, // "ć" (U+0107)
  0x01, 0x08, 0x40, 0x01, 0x03, 0x09, 0x04, 0x0A, 0x92, // "Ĉ" (U+0108)
  0x01, 0x09, 0x40, 0x01, 0x02, 0x08, 0x03, 0x0A, 0xA4, // "ĉ" (U+0109)
  0x01, 0x0A, 0x40, 0x01, 0x03, 0x08, 0x04, 0x0A, 0xB0, // "Ċ" (U+010A)
  0x01, 0x0B, 0x40, 0x01, 0x02, 0x07, 0x03, 0x0A, 0xC0, // "ċ" (U+010B)
  0x01, 0x0C, 0x40, 0x01, 0x04, 0x09, 0x04, 0x0A, 0xCB, // "Č" (U+010C)
  0x01, 0x0D, 0x00, 0x01, 0x03, 0x08, 0x03, 0x0A, 0xE2, // "č" (U+010D)
  0x01, 0x0E, 0x40, 0x01, 0x04, 0x09, 0x04, 0x0A, 0xF1, // "Ď" (U+010E)
  0x01, 0x0F, 0x40, 0x01, 0x05, 0x07, 0x04, 0x0B, 0x08, // "ď" (U+010F)
  0x01, 0x10, 0x40, 0x01, 0x03, 0x07, 0x04, 0x0B, 0x1D, // "Đ" (U+0110)
  0x01, 0x11, 0x00, 0x01, 0x04, 0x07, 0x04, 0x0B, 0x2B, // "đ" (U+0111)
  0x01, 0x12, 0x40, 0x01, 0x03, 0x07, 0x03, 0x0B, 0x3C, // "Ē" (U+0112)
  0x01, 0x13, 0x40, 0x01, 0x03, 0x06, 0x03, 0x0B, 0x4A, // "ē" (U+0113)
  0x01, 0x14, 0x40, 0x01, 0x03, 0x08, 0x03, 0x0B, 0x56, // "Ĕ" (U+0114)
  0x01, 0x15, 0x40, 0x01, 0x03, 0x07, 0x03, 0x0B, 0x66, // "ĕ" (U+0115)
  0x01, 0x16, 0x40, 0x01, 0x03, 0x08, 0x03, 0x0B, 0x74, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x01, 0x03, 0x07, 0x03, 0x0B, 0x84, // "ė" (U+0117)
  0x01, 0x18, 0x40, 0xFF, 0x03, 0x07, 0x03, 0x0B, 0x91, // "Ę" (U+0118)
  0x01, 0x19, 0x40, 0xFF, 0x03, 0x05, 0x03, 0x0B, 0xA3, // "ę" (U+0119)
  0x01, 0x1A, 0x40, 0x01, 0x04, 0x09, 0x03, 0x0B, 0xB1, // "Ě" (U+011A)
  0x01, 0x1B, 0x40, 0x01, 0x03, 0x08, 0x03, 0x0B, 0xC8, // "ě" (U+011B)
  0x01, 0x1C, 0x40, 0x01, 0x04, 0x09, 0x04, 0x0B, 0xD8, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x40, 0xFF, 0x03, 0x08, 0x04, 0x0B, 0xEF, // "ĝ" (U+011D)
  0x01, 0x1E, 0x40, 0x01, 0x04, 0x08, 0x04, 0x0C, 0x03, // "Ğ" (U+011E)
  0x01, 0x1F, 0x40, 0xFF, 0x03, 0x07, 0x04, 0x0C, 0x17, // "ğ" (U+011F)
  0x01, 0x20, 0x40, 0x01, 0x04, 0x08, 0x04, 0x0C, 0x29, // "Ġ" (U+0120)
  0x01, 0x21, 0x40, 0xFF, 0x03, 0x07, 0x04, 0x0C, 0x3D, // "ġ" (U+0121)
  0x01, 0x22, 0x40, 0xFF, 0x04, 0x07, 0x04, 0x0C, 0x4F, // "Ģ" (U+0122)
  0x01, 0x23, 0x40, 0xFF, 0x03, 0x07, 0x04, 0x0C, 0x66, // "ģ" (U+0123)
  0x01, 0x24, 0x40, 0x01, 0x04, 0x09, 0x04, 0x0C, 0x78, // "Ĥ" (U+0124)
  0x01, 0x25, 0x40, 0x01, 0x03, 0x0A, 0x04, 0x0C, 0x8F, // "ĥ" (U+0125)
  0x01, 0x26, 0x40, 0x01, 0x04, 0x07, 0x04, 0x0C, 0xA3, // "Ħ" (U+0126)
  0x01, 0x27, 0x40, 0x01, 0x03, 0x07, 0x04, 0x0C, 0xB5, // "ħ" (U+0127)
  0x01, 0x28, 0xFF, 0x01, 0x03, 0x07, 0x02, 0x0C, 0xC3, // "Ĩ" (U+0128)
  0x01, 0x29, 0x40, 0x01, 0x02, 0x06, 0x02, 0x0C, 0xD4, // "ĩ" (U+0129)
  0x01, 0x2A, 0xBF, 0x01, 0x02, 0x07, 0x02, 0x0C, 0xDD, // "Ī" (U+012A)
  0x01, 0x2B, 0x40, 0x01, 0x01, 0x06, 0x02, 0x0C, 0xEB, // "ī" (U+012B)
  0x01, 0x2C, 0xBF, 0x01, 0x02, 0x08, 0x02, 0x0C, 0xF1, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x40, 0x01, 0x01, 0x07, 0x02, 0x0D, 0x01, // "ĭ" (U+012D)
  0x01, 0x2E, 0xBF, 0xFF, 0x02, 0x07, 0x02, 0x0D, 0x08, // "Į" (U+012E)
  0x01, 0x2F, 0xBF, 0xFF, 0x01, 0x07, 0x02, 0x0D, 0x1A, // "į" (U+012F)
  0x01, 0x30, 0xBF, 0x01, 0x02, 0x08, 0x02, 0x0D, 0x28, // "İ" (U+0130)
  0x01, 0x31, 0x40, 0x01, 0x01, 0x05, 0x02, 0x0D, 0x38, // "ı" (U+0131)
  0x01, 0x32, 0xBF, 0x00, 0x03, 0x07, 0x04, 0x0D, 0x3D, // "Ĳ" (U+0132)
  0x01, 0x33, 0x40, 0xFF, 0x03, 0x07, 0x03, 0x0D, 0x51, // "ĳ" (U+0133)
  0x01, 0x34, 0xFE, 0x00, 0x02, 0x09, 0x02, 0x0D, 0x63, // "Ĵ" (U+0134)
  0x01, 0x35, 0xBF, 0xFF, 0x01, 0x08, 0x02, 0x0D, 0x7A, // "ĵ" (U+0135)
  0x01, 0x36, 0x40, 0xFF, 0x04, 0x07, 0x04, 0x0D, 0x89, // "Ķ" (U+0136)
  0x01, 0x37, 0x40, 0xFF, 0x03, 0x07, 0x03, 0x0D, 0xA0, // "ķ" (U+0137)
  0x01, 0x38, 0x40, 0x01, 0x03, 0x05, 0x03, 0x0D, 0xB2, // "ĸ" (U+0138)
  0x01, 0x39, 0x40, 0x01, 0x03, 0x09, 0x03, 0x0D, 0xBC, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x40, 0x01, 0x02, 0x0A, 0x02, 0x0D, 0xCE, // "ĺ" (U+013A)
  0x01, 0x3B, 0x40, 0xFF, 0x02, 0x07, 0x03, 0x0D, 0xDD, // "Ļ" (U+013B)
  0x01, 0x3C, 0xBF, 0xFF, 0x01, 0x07, 0x02, 0x0D, 0xEB, // "ļ" (U+013C)
  0x01, 0x3D, 0x40, 0x01, 0x03, 0x07, 0x03, 0x0D, 0xF9, // "Ľ" (U+013D)
  0x01, 0x3E, 0x40, 0x01, 0x03, 0x07, 0x02, 0x0E, 0x07, // "ľ" (U+013E)
  0x01, 0x3F, 0x40, 0x01, 0x02, 0x07, 0x03, 0x0E, 0x15, // "Ŀ" (U+013F)
  0x01, 0x40, 0x40, 0x01, 0x02, 0x07, 0x02, 0x0E, 0x20, // "ŀ" (U+0140)
  0x01, 0x41, 0x40, 0x01, 0x02, 0x07, 0x03, 0x0E, 0x2B, // "Ł" (U+0141)
  0x01, 0x42, 0x40, 0x01, 0x01, 0x07, 0x02, 0x0E, 0x36, // "ł" (U+0142)
  0x01, 0x43, 0x40, 0x01, 0x04, 0x09, 0x05, 0x0E, 0x3D, // "Ń" (U+0143)
  0x01, 0x44, 0x40, 0x01, 0x03, 0x08, 0x04, 0x0E, 0x54, // "ń" (U+0144)
  0x01, 0x45, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x0E, 0x64, // "Ņ" (U+0145)
  0x01, 0x46, 0x40, 0xFF, 0x03, 0x05, 0x04, 0x0E, 0x7B, // "ņ" (U+0146)
  0x01, 0x47, 0x40, 0x01, 0x04, 0x09, 0x05, 0x0E, 0x89, // "Ň" (U+0147)
  0x01, 0x48, 0x40, 0x01, 0x03, 0x08, 0x04, 0x0E, 0xA0, // "ň" (U+0148)
  0x01, 0x49, 0x40, 0x01, 0x03, 0x07, 0x04, 0x0E, 0xB0, // "ŉ" (U+0149)
  0x01, 0x4A, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x0E, 0xBE, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x40, 0xFF, 0x03, 0x05, 0x04, 0x0E, 0xD5, // "ŋ" (U+014B)
  0x01, 0x4C, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0E, 0xE3, // "Ō" (U+014C)
  0x01, 0x4D, 0x40, 0x01, 0x03, 0x06, 0x04, 0x0E, 0xF5, // "ō" (U+014D)
  0x01, 0x4E, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0F, 0x01, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x40, 0x01, 0x03, 0x07, 0x04, 0x0F, 0x15, // "ŏ" (U+014F)
  0x01, 0x50, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0F, 0x23, // "Ő" (U+0150)
  0x01, 0x51, 0x40, 0x01, 0x04, 0x07, 0x04, 0x0F, 0x37, // "ő" (U+0151)
  0x01, 0x52, 0x40, 0x01, 0x05, 0x07, 0x05, 0x0F, 0x49, // "Œ" (U+0152)
  0x01, 0x53, 0x40, 0x01, 0x05, 0x05, 0x06, 0x0F, 0x5E, // "œ" (U+0153)
  0x01, 0x54, 0x40, 0x01, 0x03, 0x09, 0x04, 0x0F, 0x6D, // "Ŕ" (U+0154)
  0x01, 0x55, 0x00, 0x01, 0x03, 0x08, 0x03, 0x0F, 0x7F, // "ŕ" (U+0155)
  0x01, 0x56, 0x40, 0xFF, 0x03, 0x07, 0x04, 0x0F, 0x8E, // "Ŗ" (U+0156)
  0x01, 0x57, 0xBF, 0xFF, 0x02, 0x05, 0x03, 0x0F, 0xA0, // "ŗ" (U+0157)
  0x01, 0x58, 0x40, 0x01, 0x04, 0x09, 0x04, 0x0F, 0xAE, // "Ř" (U+0158)
  0x01, 0x59, 0x00, 0x01, 0x03, 0x08, 0x03, 0x0F, 0xC5, // "ř" (U+0159)
  0x01, 0x5A, 0x40, 0x01, 0x03, 0x09, 0x03, 0x0F, 0xD4, // "Ś" (U+015A)
  0x01, 0x5B, 0x40, 0x01, 0x03, 0x08, 0x03, 0x0F, 0xE6, // "ś" (U+015B)
  0x01, 0x5C, 0x40, 0x01, 0x03, 0x09, 0x03, 0x0F, 0xF6, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x40, 0x01, 0x02, 0x08, 0x03, 0x10, 0x08, // "ŝ" (U+015D)
  0x01, 0x5E, 0x40, 0xFF, 0x03, 0x07, 0x03, 0x10, 0x14, // "Ş" (U+015E)
  0x01, 0x5F, 0x40, 0xFF, 0x02, 0x05, 0x03, 0x10, 0x26, // "ş" (U+015F)
  0x01, 0x60, 0x00, 0x01, 0x04, 0x09, 0x03, 0x10, 0x31, // "Š" (U+0160)
  0x01, 0x61, 0x40, 0x01, 0x03, 0x08, 0x03, 0x10, 0x46, // "š" (U+0161)
  0x01, 0x62, 0x40, 0xFF, 0x03, 0x07, 0x03, 0x10, 0x56, // "Ţ" (U+0162)
  0x01, 0x63, 0x40, 0xFF, 0x02, 0x06, 0x02, 0x10, 0x68, // "ţ" (U+0163)
  0x01, 0x64, 0x40, 0x01, 0x03, 0x09, 0x03, 0x10, 0x74, // "Ť" (U+0164)
  0x01, 0x65, 0x40, 0x01, 0x02, 0x07, 0x02, 0x10, 0x86, // "ť" (U+0165)
  0x01, 0x66, 0x40, 0x01, 0x03, 0x07, 0x03, 0x10, 0x91, // "Ŧ" (U+0166)
  0x01, 0x67, 0x40, 0x01, 0x02, 0x06, 0x02, 0x10, 0x9F, // "ŧ" (U+0167)
  0x01, 0x68, 0x40, 0x01, 0x04, 0x07, 0x04, 0x10, 0xA8, // "Ũ" (U+0168)
  0x01, 0x69, 0x40, 0x01, 0x03, 0x06, 0x04, 0x10, 0xBA, // "ũ" (U+0169)
  0x01, 0x6A, 0x40, 0x01, 0x04, 0x07, 0x04, 0x10, 0xC6, // "Ū" (U+016A)
  0x01, 0x6B, 0x40, 0x01, 0x03, 0x06, 0x04, 0x10, 0xD8, // "ū" (U+016B)
  0x01, 0x6C, 0x40, 0x01, 0x04, 0x08, 0x04, 0x10, 0xE4, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x40, 0x01, 0x03, 0x07, 0x04, 0x10, 0xF8, // "ŭ" (U+016D)
  0x01, 0x6E, 0x40, 0x01, 0x04, 0x08, 0x04, 0x11, 0x06, // "Ů" (U+016E)
  0x01, 0x6F, 0x40, 0x01, 0x03, 0x07, 0x04, 0x11, 0x1A, // "ů" (U+016F)
  0x01, 0x70, 0x40, 0x01, 0x04, 0x08, 0x04, 0x11, 0x28, // "Ű" (U+0170)
  0x01, 0x71, 0x40, 0x01, 0x04, 0x07, 0x04, 0x11, 0x3C, // "ű" (U+0171)
  0x01, 0x72, 0x40, 0xFF, 0x04, 0x07, 0x04, 0x11, 0x4E, // "Ų" (U+0172)
  0x01, 0x73, 0x40, 0xFF, 0x03, 0x05, 0x04, 0x11, 0x65, // "ų" (U+0173)
  0x01, 0x74, 0x40, 0x01, 0x06, 0x09, 0x06, 0x11, 0x73, // "Ŵ" (U+0174)
  0x01, 0x75, 0x40, 0x01, 0x04, 0x08, 0x05, 0x11, 0x93, // "ŵ" (U+0175)
  0x01, 0x76, 0x40, 0x01, 0x03, 0x09, 0x03, 0x11, 0xA7, // "Ŷ" (U+0176)
  0x01, 0x77, 0xFF, 0xFF, 0x03, 0x08, 0x03, 0x11, 0xB9, // "ŷ" (U+0177)
  0x01, 0x78, 0x40, 0x01, 0x03, 0x08, 0x03, 0x11, 0xD1, // "Ÿ" (U+0178)
  0x01, 0x79, 0xBF, 0x01, 0x03, 0x09, 0x03, 0x11, 0xE1, // "Ź" (U+0179)
  0x01, 0x7A, 0xFF, 0x01, 0x03, 0x08, 0x03, 0x11, 0xF8, // "ź" (U+017A)
  0x01, 0x7B, 0xBF, 0x01, 0x03, 0x08, 0x03, 0x12, 0x0A, // "Ż" (U+017B)
  0x01, 0x7C, 0xBF, 0x01, 0x02, 0x07, 0x03, 0x12, 0x1E, // "ż" (U+017C)
  0x01, 0x7D, 0xBF, 0x01, 0x03, 0x09, 0x03, 0x12, 0x2C, // "Ž" (U+017D)
  0x01, 0x7E, 0xFF, 0x01, 0x03, 0x08, 0x03, 0x12, 0x43, // "ž" (U+017E)
  0x01, 0x7F, 0xBF, 0xFF, 0x02, 0x07, 0x02, 0x12, 0x56, // "ſ" (U+017F)
  0x03, 0xA9, 0xBF, 0x01, 0x04, 0x07, 0x05, 0x12, 0x68, // "Ω" (U+03A9)
  0x03, 0xBC, 0xBF, 0xFF, 0x03, 0x05, 0x04, 0x12, 0x7D, // "μ" (U+03BC)
  0x03, 0xC0, 0x40, 0x01, 0x03, 0x05, 0x04, 0x12, 0x8F, // "π" (U+03C0)
  0x20, 0x13, 0x40, 0x03, 0x03, 0x03, 0x04, 0x12, 0x99, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x03, 0x06, 0x03, 0x07, 0x12, 0x9B, // "—" (U+2014)
  0x20, 0xAC, 0x40, 0x01, 0x03, 0x07, 0x04, 0x12, 0x9E, // "€" (U+20AC)
  0x20, 0xBF, 0x40, 0x00, 0x03, 0x08, 0x04, 0x12, 0xAC, // "₿" (U+20BF)
  0x20, 0x18, 0x40, 0x06, 0x01, 0x07, 0x01, 0x12, 0xBE, // "‘" (U+2018)
  0x20, 0x19, 0x40, 0x06, 0x01, 0x07, 0x01, 0x12, 0xC0, // "’" (U+2019)
  0x20, 0x1A, 0xBF, 0x00, 0x00, 0x01, 0x02, 0x12, 0xC2, // "‚" (U+201A)
  0x20, 0x1B, 0x40, 0x05, 0x01, 0x07, 0x01, 0x12, 0xC4, // "‛" (U+201B)
  0x20, 0x1C, 0x40, 0x05, 0x03, 0x07, 0x03, 0x12, 0xC7, // "“" (U+201C)
  0x20, 0x1D, 0x40, 0x05, 0x03, 0x07, 0x03, 0x12, 0xCD, // "”" (U+201D)
  0x20, 0x1E, 0xBF, 0x00, 0x02, 0x02, 0x03, 0x12, 0xD3, // "„" (U+201E)
  0x20, 0x1F, 0x40, 0x05, 0x02, 0x07, 0x03, 0x12, 0xD9, // "‟" (U+201F)
  0x20, 0x20, 0x40, 0x01, 0x03, 0x07, 0x03, 0x12, 0xDE, // "†" (U+2020)
  0x20, 0x21, 0x40, 0x01, 0x03, 0x07, 0x03, 0x12, 0xEC, // "‡" (U+2021)
  0x20, 0x22, 0x40, 0x03, 0x02, 0x05, 0x03, 0x12, 0xFA, // "•" (U+2022)
  0x20, 0x26, 0x40, 0x01, 0x04, 0x01, 0x05, 0x12, 0xFF, // "…" (U+2026)
  0x20, 0x30, 0x40, 0x01, 0x07, 0x07, 0x08, 0x13, 0x02, // "‰" (U+2030)
  0x20, 0x39, 0x40, 0x01, 0x01, 0x04, 0x02, 0x13, 0x1E, // "‹" (U+2039)
  0x20, 0x3A, 0x40, 0x01, 0x01, 0x04, 0x02, 0x13, 0x22, // "›" (U+203A)
  0x20, 0x44, 0xFE, 0x01, 0x02, 0x07, 0x01, 0x13, 0x26, // "⁄" (U+2044)
  0x21, 0x22, 0x40, 0x03, 0x04, 0x06, 0x05, 0x13, 0x35, // "™" (U+2122)
  0x21, 0x52, 0x00, 0x01, 0x06, 0x07, 0x08, 0x13, 0x3F, // "⅒" (U+2152)
  0xFB, 0x01, 0xBF, 0xFF, 0x03, 0x07, 0x04, 0x13, 0x57, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0xBF, 0xFF, 0x03, 0x07, 0x04, 0x13, 0x6E, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x4C, 0x00, 0x22, 0x01, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x01, // L' (U+004C U+0027)
  0x00, 0x4C, 0x20, 0x19, 0x01, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1D, 0x01, // L” (U+004C U+201D)
  0x00, 0x50, 0x00, 0x2C, 0x01, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x01, // P. (U+0050 U+002E)
  0x00, 0x50, 0x20, 0x1A, 0x01, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x01, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x01, // P… (U+0050 U+2026)
  0x00, 0x72, 0x00, 0x2C, 0x01, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x01, // r. (U+0072 U+002E)
  0x00, 0x72, 0x20, 0x1A, 0x01, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x01, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x01, // r… (U+0072 U+2026)
  0x00, 0xDE, 0x00, 0x2C, 0x01, // Þ, (U+00DE U+002C)
  0x00, 0xDE, 0x00, 0x2E, 0x01, // Þ. (U+00DE U+002E)
  0x00, 0xDE, 0x20, 0x1A, 0x01, // Þ‚ (U+00DE U+201A)
  0x00, 0xDE, 0x20, 0x1E, 0x01, // Þ„ (U+00DE U+201E)
  0x00, 0xDE, 0x20, 0x26, 0x01, // Þ… (U+00DE U+2026)
  0x01, 0x39, 0x00, 0x22, 0x01, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x01, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x20, 0x19, 0x01, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1D, 0x01, // Ĺ” (U+0139 U+201D)
  0x01, 0x3B, 0x00, 0x22, 0x01, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x01, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x20, 0x19, 0x01, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1D, 0x01, // Ļ” (U+013B U+201D)
  0x01, 0x3D, 0x00, 0x22, 0x01, // Ľ" (U+013D U+0022)
  0x01, 0x3D, 0x00, 0x27, 0x01, // Ľ' (U+013D U+0027)
  0x01, 0x3D, 0x20, 0x19, 0x01, // Ľ’ (U+013D U+2019)
  0x01, 0x3D, 0x20, 0x1D, 0x01, // Ľ” (U+013D U+201D)
  0x01, 0x3F, 0x00, 0x22, 0x01, // Ŀ" (U+013F U+0022)
  0x01, 0x3F, 0x00, 0x27, 0x01, // Ŀ' (U+013F U+0027)
  0x01, 0x3F, 0x20, 0x19, 0x01, // Ŀ’ (U+013F U+2019)
  0x01, 0x3F, 0x20, 0x1D, 0x01, // Ŀ” (U+013F U+201D)
  0x01, 0x41, 0x00, 0x22, 0x01, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x01, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x20, 0x19, 0x01, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1D, 0x01, // Ł” (U+0141 U+201D)
  0x01, 0x55, 0x00, 0x2C, 0x01, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x01, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x20, 0x1A, 0x01, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x01, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x01, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x01, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x01, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x20, 0x1A, 0x01, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x01, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x01, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x01, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x01, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x20, 0x1A, 0x01, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x01, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x01, // ř… (U+0159 U+2026)
  
  // Glyph data
  // "!" (U+0021)
  0x0B, 0x0A, 0x09, 0x36, 0x53, 0x20, 0x70,
  // """ (U+0022)
  0x0A, 0x91, 0x78, 0x00, 0x10,
  // "#" (U+0023)
  0x02, 0x67, 0x05, 0x27, 0x4D, 0xCC, 0x07, 0x70, 0xAD, 0xD6, 0x52, 0x70, 0x74, 0x30,
  // "$" (U+0024)
  0x02, 0x91, 0x1A, 0x72, 0x1B, 0x30, 0x06, 0x80, 0x05, 0xA0, 0x9D, 0x60, 0x04, 0x00,
  // "%" (U+0025)
  0x0A, 0x61, 0x63, 0x47, 0x70, 0x71, 0x87, 0x07, 0x4B, 0x6A, 0x4B, 0x79, 0x70, 0x72, 0x78, 0x07,
  0x0C, 0x50,
  // "&" (U+0026)
  0x06, 0xC1, 0x09, 0x63, 0x0B, 0xC0, 0x0C, 0x40, 0x86, 0x79, 0xA0, 0xD2, 0xAB, 0x94,
  // "'" (U+0027)
  0x0A, 0x17,
  // "(" (U+0028)
  0x03, 0x50, 0x90, 0x35, 0x08, 0x10, 0x90, 0x09, 0x00, 0x90, 0x07, 0x10,
  // ")" (U+0029)
  0x00, 0x80, 0x09, 0x00, 0x90, 0x09, 0x00, 0x90, 0x45, 0x09, 0x04, 0x40,
  // "*" (U+002A)
  0x00, 0x70, 0x19, 0xB5, 0x09, 0x80, 0x01, 0x30,
  // "+" (U+002B)
  0x04, 0x40, 0x7C, 0xC6, 0x04, 0x40, 0x04, 0x40,
  // "," (U+002C)
  0x0A, 0x26,
  // "-" (U+002D)
  0x9B,
  // "." (U+002E)
  0x70,
  // "/" (U+002F)
  0x30, 0x70, 0x23, 0x09, 0x30, 0x50, 0x33, 0x09, 0x30, 0x40, 0x53, 0x09, 0x30, 0x20, 0x73,
  // "0" (U+0030)
  0x06, 0xC2, 0x19, 0x36, 0x54, 0x36, 0x91, 0x54, 0x90, 0x81, 0x90, 0xA0, 0x6C, 0x30,
  // "1" (U+0031)
  0x2D, 0xAA, 0x09, 0x36, 0x64, 0x81, 0xA0,
  // "2" (U+0032)
  0x00, 0xAC, 0x20, 0x01, 0x46, 0x00, 0x06, 0x30, 0x00, 0xA0, 0x00, 0x92, 0x00, 0x64, 0x00, 0x1E,
  0xB8, 0x00,
  // "3" (U+0033)
  0x0A, 0xC2, 0x00, 0x46, 0x00, 0x83, 0x0C, 0x80, 0x00, 0xB0, 0x00, 0xA0, 0xBC, 0x40,
  // "4" (U+0034)
  0x00, 0x76, 0x01, 0xC3, 0x08, 0x91, 0x17, 0x90, 0x80, 0x90, 0xBA, 0xD2, 0x03, 0x50,
  // "5" (U+0035)
  0x0A, 0xB5, 0x09, 0x00, 0x27, 0x00, 0x4C, 0x90, 0x00, 0xB0, 0x00, 0xB0, 0xBC, 0x50,
  // "6" (U+0036)
  0x03, 0xC7, 0x0B, 0x00, 0x47, 0x00, 0x89, 0xB0, 0xA2, 0x82, 0xA0, 0x90, 0x5C, 0x70,
  // "7" (U+0037)
  0x1B, 0xBA, 0x00, 0x55, 0x00, 0xA0, 0x02, 0x70, 0x08, 0x10, 0x09, 0x00, 0x64, 0x00,
  // "8" (U+0038)
  0x08, 0xC4, 0x19, 0x28, 0x0C, 0xA3, 0x1B, 0x80, 0x91, 0xA0, 0xA0, 0xA0, 0x8C, 0x70,
  // "9" (U+0039)
  0x09, 0xC2, 0x37, 0x46, 0x63, 0x45, 0x63, 0x83, 0x2B, 0xB0, 0x01, 0x80, 0xAB, 0x10,
  // ":" (U+003A)
  0x01, 0x05, 0x60, 0x71,
  // ";" (U+003B)
  0x10, 0x10, 0x67, 0x05, 0x28, 0x29, 0x03, 0x31,
  // "<" (U+003C)
  0x00, 0x24, 0x18, 0x70, 0x49, 0x20, 0x00, 0x65,
  // "=" (U+003D)
  0x6B, 0xB6, 0x00, 0x00, 0x6B, 0xB6,
  // ">" (U+003E)
  0x52, 0x00, 0x07, 0x81, 0x02, 0x94, 0x56, 0x00,
  // "?" (U+003F)
  0x2B, 0xA0, 0x0A, 0x01, 0x90, 0x91, 0x26, 0x02, 0x10, 0x60, 0x00,
  // "@" (U+0040)
  0x01, 0xAB, 0x70, 0x09, 0x10, 0x70, 0x35, 0x9B, 0x52, 0x74, 0x57, 0x61, 0x86, 0x37, 0x80, 0x84,
  0x99, 0x40, 0x72, 0x00, 0x00, 0x1A, 0xB3, 0x00,
  // "A" (U+0041)
  0x00, 0x1D, 0x00, 0x07, 0xB0, 0x00, 0xA9, 0x00, 0x37, 0x90, 0x08, 0xBD, 0x00, 0xA0, 0x91, 0x46,
  0x08, 0x10,
  // "B" (U+0042)
  0x0B, 0xC7, 0x0A, 0x0B, 0x28, 0x19, 0x4D, 0xD1, 0x73, 0x55, 0x90, 0x64, 0xCB, 0x90,
  // "C" (U+0043)
  0x02, 0xBB, 0x0B, 0x00, 0x46, 0x00, 0x82, 0x00, 0x91, 0x00, 0x83, 0x00, 0x2C, 0xA0,
  // "D" (U+0044)
  0x0B, 0xC6, 0x0A, 0x0B, 0x28, 0x0A, 0x45, 0x0B, 0x72, 0x0A, 0x90, 0x84, 0xCB, 0x70,
  // "E" (U+0045)
  0x0B, 0xB6, 0x0A, 0x00, 0x28, 0x00, 0x4D, 0xA0, 0x73, 0x00, 0x90, 0x00, 0xCB, 0x50,
  // "F" (U+0046)
  0x0B, 0xB6, 0x0A, 0x00, 0x28, 0x00, 0x4C, 0xA0, 0x72, 0x00, 0x90, 0x00, 0xA0, 0x00,
  // "G" (U+0047)
  0x03, 0xBC, 0x30, 0xB1, 0x00, 0x46, 0x00, 0x07, 0x25, 0xC0, 0x91, 0x0A, 0x08, 0x30, 0x90, 0x2C,
  0xB5, 0x00,
  // "H" (U+0048)
  0x0A, 0x04, 0x50, 0xA0, 0x63, 0x18, 0x09, 0x04, 0xCA, 0xC0, 0x73, 0x09, 0x09, 0x02, 0x70, 0xA0,
  0x45, 0x00,
  // "I" (U+0049)
  0x01, 0xD6, 0x00, 0xA0, 0x00, 0xA0, 0x01, 0x80, 0x04, 0x50, 0x07, 0x30, 0x2C, 0x50,
  // "J" (U+004A)
  0x00, 0x0A, 0x00, 0x09, 0x00, 0x27, 0x00, 0x54, 0x00, 0x91, 0x00, 0xA0, 0x01, 0xA0, 0x1B, 0x30,
  // "K" (U+004B)
  0x0A, 0x0A, 0x10, 0xA6, 0x50, 0x29, 0xA0, 0x04, 0xE5, 0x00, 0x75, 0x80, 0x09, 0x0A, 0x00, 0xA0,
  0xA0, 0x00,
  // "L" (U+004C)
  0x0A, 0x00, 0xA0, 0x28, 0x04, 0x50, 0x72, 0x09, 0x00, 0xCA, 0x40,
  // "M" (U+004D)
  0x0C, 0x30, 0x6A, 0x0D, 0x40, 0xB8, 0x2B, 0x53, 0xB5, 0x47, 0x68, 0x82, 0x74, 0x78, 0x90, 0x91,
  0xD3, 0xA0, 0x90, 0xC0, 0x90,
  // "N" (U+004E)
  0x0C, 0x20, 0x90, 0xD5, 0x27, 0x29, 0x85, 0x44, 0x59, 0x81, 0x72, 0x99, 0x09, 0x08, 0xA0, 0x90,
  0x59, 0x00,
  // "O" (U+004F)
  0x03, 0xBB, 0x00, 0xB0, 0x64, 0x46, 0x05, 0x57, 0x20, 0x73, 0x91, 0x0A, 0x08, 0x22, 0x90, 0x2C,
  0xB1, 0x00,
  // "P" (U+0050)
  0x0B, 0xC4, 0x0A, 0x0A, 0x29, 0x09, 0x46, 0x56, 0x7C, 0x90, 0xA1, 0x00, 0xA0, 0x00,
  // "Q" (U+0051)
  0x03, 0xBB, 0x00, 0xB0, 0x64, 0x46, 0x05, 0x57, 0x20, 0x73, 0x91, 0x0A, 0x08, 0x22, 0x90, 0x2C,
  0xC1, 0x00, 0x0B, 0x00, 0x00, 0x40, 0x00,
  // "R" (U+0052)
  0x0B, 0xC5, 0x0A, 0x0A, 0x27, 0x38, 0x4D, 0xC1, 0x73, 0x90, 0x90, 0xA0, 0xA0, 0xA0,
  // "S" (U+0053)
  0x09, 0xB5, 0x37, 0x00, 0x38, 0x00, 0x09, 0x40, 0x00, 0xA0, 0x00, 0xB0, 0xCC, 0x40,
  // "T" (U+0054)
  0x3C, 0xD8, 0x05, 0x50, 0x07, 0x20, 0x0A, 0x00, 0x0A, 0x00, 0x0A, 0x00, 0x27, 0x00,
  // "U" (U+0055)
  0x0A, 0x04, 0x50, 0x90, 0x72, 0x27, 0x09, 0x05, 0x40, 0xA0, 0x82, 0x09, 0x09, 0x14, 0x50, 0x4B,
  0x90, 0x00,
  // "V" (U+0056)
  0x45, 0x09, 0x13, 0x60, 0xA0, 0x36, 0x55, 0x03, 0x6A, 0x00, 0x28, 0x80, 0x02, 0xD3, 0x00, 0x1D,
  0x00, 0x00,
  // "W" (U+0057)
  0x35, 0x0B, 0x07, 0x24, 0x54, 0xC0, 0xA0, 0x45, 0x89, 0x27, 0x04, 0x58, 0x87, 0x20, 0x49, 0x48,
  0x90, 0x04, 0xD0, 0x97, 0x00, 0x49, 0x0B, 0x20, 0x00,
  // "X" (U+0058)
  0x00, 0x91, 0x90, 0x09, 0x72, 0x00, 0x99, 0x00, 0x0A, 0x40, 0x02, 0xB5, 0x00, 0x92, 0x80, 0x37,
  0x0A, 0x00,
  // "Y" (U+0059)
  0x36, 0x19, 0x18, 0x73, 0x09, 0x90, 0x0D, 0x40, 0x0A, 0x00, 0x0A, 0x00, 0x28, 0x00,
  // "Z" (U+005A)
  0x00, 0xBD, 0x70, 0x00, 0x91, 0x00, 0x28, 0x00, 0x09, 0x10, 0x03, 0x80, 0x00, 0x91, 0x00, 0x2E,
  0xB6, 0x00,
  // "[" (U+005B)
  0x00, 0xB9, 0x00, 0x90, 0x02, 0x70, 0x05, 0x40, 0x08, 0x10, 0x09, 0x00, 0x09, 0x00, 0x1C, 0x40,
  // "\" (U+005C)
  0x17, 0x00, 0x80, 0x09, 0x00, 0x90, 0x09, 0x00, 0x80, 0x07, 0x10,
  // "]" (U+005D)
  0x01, 0xC5, 0x00, 0x62, 0x00, 0x80, 0x00, 0x90, 0x00, 0x90, 0x03, 0x60, 0x06, 0x30, 0x5C, 0x00,
  // "^" (U+005E)
  0x01, 0x30, 0x07, 0x90, 0x17, 0x80, 0x81, 0x45,
  // "_" (U+005F)
  0x58, 0x80,
  // "`" (U+0060)
  0x50, 0x62,
  // "a" (U+0061)
  0x0A, 0x98, 0x55, 0x56, 0x90, 0x63, 0xA0, 0xC0, 0x7B, 0xA0,
  // "b" (U+0062)
  0x09, 0x00, 0x09, 0x00, 0x1B, 0xC3, 0x48, 0x37, 0x72, 0x45, 0xA1, 0x91, 0x9B, 0x70,
  // "c" (U+0063)
  0x0A, 0xB5, 0x50, 0x90, 0x0A, 0x00, 0x6C, 0x30,
  // "d" (U+0064)
  0x00, 0x09, 0x00, 0x09, 0x0A, 0x99, 0x55, 0x56, 0x90, 0x63, 0xA0, 0xC0, 0x7A, 0xA0,
  // "e" (U+0065)
  0x0A, 0xC0, 0x55, 0x91, 0x9B, 0x60, 0xA0, 0x00, 0x6C, 0x60,
  // "f" (U+0066)
  0x00, 0x6A, 0x00, 0xA0, 0x04, 0xD3, 0x03, 0x60, 0x06, 0x30, 0x09, 0x00, 0x0A, 0x00, 0x09, 0x00,
  0xB3, 0x00,
  // "g" (U+0067)
  0x0A, 0x98, 0x55, 0x56, 0x90, 0x63, 0xA0, 0xC0, 0x7B, 0xB0, 0x01, 0x90, 0xBB, 0x20,
  // "h" (U+0068)
  0x0A, 0x00, 0x0A, 0x00, 0x1B, 0xC3, 0x47, 0x45, 0x73, 0x72, 0x90, 0x90, 0xA0, 0x90,
  // "i" (U+0069)
  0x06, 0x00, 0x18, 0x45, 0x72, 0x90, 0x90,
  // "j" (U+006A)
  0x00, 0x60, 0x00, 0x02, 0x70, 0x45, 0x07, 0x20, 0x90, 0x0A, 0x01, 0x80, 0xC3, 0x00,
  // "k" (U+006B)
  0x09, 0x00, 0x09, 0x00, 0x18, 0x83, 0x49, 0x70, 0x7D, 0x20, 0x94, 0x60, 0xA1, 0x90,
  // "l" (U+006C)
  0x09, 0x09, 0x18, 0x45, 0x72, 0x90, 0x90,
  // "m" (U+006D)
  0x1A, 0xC7, 0xC1, 0x47, 0x56, 0x73, 0x72, 0x81, 0x90, 0x90, 0x90, 0x90, 0xA0, 0x90, 0x90,
  // "n" (U+006E)
  0x1B, 0xB3, 0x48, 0x45, 0x73, 0x72, 0x90, 0x90, 0xA0, 0xA0,
  // "o" (U+006F)
  0x0A, 0xC1, 0x55, 0x55, 0x90, 0x64, 0xA0, 0xA0, 0x6C, 0x60,
  // "p" (U+0070)
  0x01, 0xAC, 0x30, 0x48, 0x37, 0x07, 0x24, 0x50, 0xA1, 0x81, 0x0A, 0x97, 0x00, 0x90, 0x00, 0x36,
  0x00, 0x00,
  // "q" (U+0071)
  0x0A, 0x98, 0x55, 0x56, 0x90, 0x63, 0xA0, 0xC0, 0x7B, 0xA0, 0x00, 0x90, 0x02, 0x70,
  // "r" (U+0072)
  0x1A, 0x84, 0x80, 0x72, 0x09, 0x00, 0xA0, 0x00,
  // "s" (U+0073)
  0x3C, 0x87, 0x30, 0x1A, 0x00, 0x64, 0xBC, 0x10,
  // "t" (U+0074)
  0x08, 0x05, 0xD3, 0x45, 0x07, 0x20, 0x90, 0x08, 0x70,
  // "u" (U+0075)
  0x27, 0x28, 0x54, 0x45, 0x82, 0x72, 0xA0, 0xB0, 0x89, 0xA0,
  // "v" (U+0076)
  0x81, 0x73, 0x72, 0xB0, 0x78, 0x60, 0x6D, 0x00, 0x59, 0x00,
  // "w" (U+0077)
  0x81, 0xB2, 0x98, 0x3C, 0x38, 0x88, 0x78, 0x38, 0x96, 0xA0, 0x86, 0x68, 0x00,
  // "x" (U+0078)
  0x04, 0x59, 0x10, 0x0B, 0x70, 0x00, 0xD0, 0x00, 0x7A, 0x20, 0x19, 0x46, 0x00,
  // "y" (U+0079)
  0x07, 0x26, 0x30, 0x62, 0xA0, 0x05, 0x76, 0x00, 0x5C, 0x00, 0x04, 0x80, 0x00, 0x82, 0x00, 0x88,
  0x00, 0x00,
  // "z" (U+007A)
  0x03, 0xBA, 0x00, 0x62, 0x01, 0x80, 0x08, 0x10, 0x1D, 0xB0,
  // "{" (U+007B)
  0x01, 0xC0, 0x63, 0x09, 0x00, 0x90, 0xB4, 0x03, 0x60, 0x53, 0x03, 0x90,
  // "|" (U+007C)
  0x80, 0x58,
  // "}" (U+007D)
  0x00, 0xC0, 0x00, 0x81, 0x00, 0x90, 0x00, 0x90, 0x00, 0x96, 0x03, 0x70, 0x08, 0x20, 0x59, 0x00,
  // "~" (U+007E)
  0x7B, 0xB7,
  // "¡" (U+00A1)
  0x07, 0x12, 0x53, 0x80, 0xA0, 0xA0, 0x20,
  // "¢" (U+00A2)
  0x00, 0x81, 0x07, 0x31, 0x17, 0x00, 0x45, 0x00, 0x55, 0x00, 0x2E, 0x70, 0x06, 0x00,
  // "£" (U+00A3)
  0x00, 0x3C, 0x80, 0x09, 0x10, 0x00, 0x90, 0x00, 0x6E, 0x80, 0x02, 0x70, 0x00, 0x63, 0x00, 0x1E,
  0xB9, 0x00,
  // "¤" (U+00A4)
  0x4B, 0xB8, 0x34, 0x07, 0x25, 0x17, 0x4A, 0xB8,
  // "¥" (U+00A5)
  0x09, 0x0A, 0x09, 0x55, 0x09, 0x90, 0x0A, 0x70, 0x5E, 0xB0, 0x8E, 0x80, 0x09, 0x00,
  // "¦" (U+00A6)
  0x0F, 0x83, 0x0F, 0x80,
  // "§" (U+00A7)
  0x0A, 0xC2, 0x09, 0x00, 0x1B, 0x60, 0x63, 0x90, 0x1C, 0x50, 0x04, 0x60, 0xBC, 0x10,
  // "¨" (U+00A8)
  0x43, 0x40,
  // "©" (U+00A9)
  0x01, 0x66, 0x50, 0x01, 0x75, 0x85, 0x70, 0x61, 0x90, 0x05, 0x16, 0x17, 0x00, 0x33, 0x61, 0x90,
  0x05, 0x10, 0x85, 0x84, 0x70, 0x01, 0x66, 0x50, 0x00,
  // "ª" (U+00AA)
  0x18, 0x95, 0x17, 0x47, 0x50,
  // "«" (U+00AB)
  0x06, 0x23, 0x65, 0x90, 0x74, 0x80, 0x03, 0x30,
  // "¬" (U+00AC)
  0x7B, 0xB7, 0x00, 0x08, 0x00, 0x07,
  // "®" (U+00AE)
  0x01, 0x66, 0x50, 0x01, 0x78, 0x93, 0x70, 0x60, 0x93, 0x65, 0x16, 0x0A, 0xB1, 0x33, 0x60, 0x94,
  0x45, 0x10, 0x83, 0x05, 0x70, 0x01, 0x66, 0x50, 0x00,
  // "¯" (U+00AF)
  0x19, 0x98,
  // "°" (U+00B0)
  0x38, 0x37, 0x08, 0x38, 0x30,
  // "±" (U+00B1)
  0x04, 0x40, 0x7C, 0xC6, 0x04, 0x40, 0x04, 0x40, 0x7B, 0xB6,
  // "²" (U+00B2)
  0x06, 0x50, 0x07, 0x07, 0x05, 0x82,
  // "³" (U+00B3)
  0x06, 0x50, 0x74, 0x01, 0x64, 0x71,
  // "´" (U+00B4)
  0x23, 0x80,
  // "µ" (U+00B5)
  0x02, 0x81, 0x80, 0x45, 0x45, 0x07, 0x27, 0x20, 0xA0, 0xB0, 0x0C, 0x9A, 0x01, 0x90, 0x00, 0x35,
  0x00, 0x00,
  // "¶" (U+00B6)
  0x0C, 0xE9, 0x3F, 0x97, 0x4F, 0x97, 0x2F, 0x97, 0x05, 0x87, 0x00, 0x67, 0x00, 0x67, 0x00, 0x67,
  0x00, 0x11,
  // "·" (U+00B7)
  0x70,
  // "¸" (U+00B8)
  0x01, 0x08, 0x46,
  // "¹" (U+00B9)
  0x23, 0x84, 0x61, 0x70,
  // "º" (U+00BA)
  0x18, 0x65, 0x17, 0x38, 0x30,
  // "»" (U+00BB)
  0x31, 0x50, 0x18, 0x91, 0x65, 0x90, 0x33, 0x00,
  // "¼" (U+00BC)
  0x00, 0x00, 0x70, 0x23, 0x71, 0x08, 0x75, 0x00, 0x6A, 0x17, 0x0D, 0x37, 0x60, 0x74, 0x96, 0x71,
  0x03, 0x00,
  // "½" (U+00BD)
  0x00, 0x00, 0x70, 0x02, 0x37, 0x10, 0x08, 0x75, 0x00, 0x06, 0xA0, 0x65, 0x0D, 0x30, 0x07, 0x07,
  0x00, 0x70, 0x71, 0x05, 0x82,
  // "¾" (U+00BE)
  0x00, 0x00, 0x07, 0x06, 0x50, 0x71, 0x07, 0x42, 0x50, 0x01, 0x68, 0x17, 0x47, 0x73, 0x76, 0x00,
  0x74, 0x96, 0x07, 0x10, 0x30,
  // "¿" (U+00BF)
  0x00, 0x60, 0x12, 0x06, 0x21, 0x90, 0x91, 0x0A, 0x00, 0xAB, 0x20,
  // "À" (U+00C0)
  0x00, 0x05, 0x00, 0x00, 0x62, 0x00, 0x1D, 0x00, 0x07, 0xB0, 0x00, 0xA9, 0x00, 0x37, 0x90, 0x08,
  0xBD, 0x00, 0xA0, 0x91, 0x46, 0x08, 0x10,
  // "Á" (U+00C1)
  0x00, 0x02, 0x30, 0x00, 0x80, 0x00, 0x1D, 0x00, 0x07, 0xB0, 0x00, 0xA9, 0x00, 0x37, 0x90, 0x08,
  0xBD, 0x00, 0xA0, 0x91, 0x46, 0x08, 0x10,
  // "Â" (U+00C2)
  0x00, 0x01, 0x40, 0x00, 0x78, 0x00, 0x1D, 0x00, 0x07, 0xB0, 0x00, 0xA9, 0x00, 0x37, 0x90, 0x08,
  0xBD, 0x00, 0xA0, 0x91, 0x46, 0x08, 0x10,
  // "Ã" (U+00C3)
  0x00, 0x1F, 0xB2, 0x00, 0x7B, 0x00, 0x00, 0xA9, 0x00, 0x03, 0x79, 0x00, 0x08, 0xBD, 0x00, 0x0A,
  0x09, 0x10, 0x46, 0x08, 0x10,
  // "Ä" (U+00C4)
  0x00, 0x43, 0x40, 0x01, 0xD0, 0x00, 0x7B, 0x00, 0x0A, 0x90, 0x03, 0x79, 0x00, 0x8B, 0xD0, 0x0A,
  0x09, 0x14, 0x60, 0x81,
  // "Å" (U+00C5)
  0x00, 0x05, 0x40, 0x01, 0xF4, 0x00, 0x7B, 0x00, 0x0A, 0x90, 0x03, 0x79, 0x00, 0x8B, 0xD0, 0x0A,
  0x09, 0x14, 0x60, 0x81,
  // "Æ" (U+00C6)
  0x38, 0x2A, 0xEB, 0x42, 0x81, 0x29, 0x84, 0x81, 0x86, 0x54, 0x82, 0xA7, 0xC8, 0x28, 0x16, 0xCD,
  0x48, 0x1B, 0x0A, 0x38, 0x44, 0x60, 0xEB, 0x31,
  // "Ç" (U+00C7)
  0x02, 0xBB, 0x0B, 0x00, 0x46, 0x00, 0x82, 0x00, 0x91, 0x00, 0x83, 0x00, 0x2E, 0xA0, 0x08, 0x00,
  0x46, 0x00,
  // "È" (U+00C8)
  0x00, 0x50, 0x00, 0x62, 0x0B, 0xB6, 0x0A, 0x00, 0x28, 0x00, 0x4D, 0xA0, 0x73, 0x00, 0x90, 0x00,
  0xCB, 0x50,
  // "É" (U+00C9)
  0x00, 0x23, 0x00, 0x80, 0x0B, 0xB6, 0x0A, 0x00, 0x28, 0x00, 0x4D, 0xA0, 0x73, 0x00, 0x90, 0x00,
  0xCB, 0x50,
  // "Ê" (U+00CA)
  0x00, 0x14, 0x00, 0x78, 0x0B, 0xB6, 0x0A, 0x00, 0x28, 0x00, 0x4D, 0xA0, 0x73, 0x00, 0x90, 0x00,
  0xCB, 0x50,
  // "Ë" (U+00CB)
  0x04, 0x34, 0x0B, 0xB6, 0x0A, 0x00, 0x28, 0x00, 0x4D, 0xA0, 0x73, 0x00, 0x90, 0x00, 0xCB, 0x50,
  // "Ì" (U+00CC)
  0x00, 0x50, 0x00, 0x62, 0x01, 0xD6, 0x00, 0xA0, 0x00, 0xA0, 0x01, 0x80, 0x04, 0x50, 0x07, 0x30,
  0x2C, 0x50,
  // "Í" (U+00CD)
  0x30, 0x20, 0x33, 0x08, 0x28, 0x11, 0xD6, 0x30, 0xA4, 0x0A, 0x30, 0x10, 0x83, 0x04, 0x05, 0x30,
  0x70, 0x32, 0x81, 0x2C, 0x52,
  // "Î" (U+00CE)
  0x00, 0x14, 0x00, 0x78, 0x01, 0xD6, 0x00, 0xA0, 0x00, 0xA0, 0x01, 0x80, 0x04, 0x50, 0x07, 0x30,
  0x2C, 0x50,
  // "Ï" (U+00CF)
  0x28, 0x54, 0x34, 0x01, 0xD6, 0x30, 0xA4, 0x0A, 0x30, 0x10, 0x83, 0x04, 0x05, 0x30, 0x70, 0x32,
  0x81, 0x2C, 0x52,
  // "Ð" (U+00D0)
  0x0B, 0xC6, 0x0A, 0x0B, 0x28, 0x0A, 0x9D, 0x2B, 0x73, 0x0A, 0x90, 0x84, 0xCC, 0x70,
  // "Ñ" (U+00D1)
  0x0C, 0xCB, 0xC0, 0xD5, 0x27, 0x29, 0x85, 0x44, 0x59, 0x81, 0x72, 0x99, 0x09, 0x08, 0xA0, 0x90,
  0x59, 0x00,
  // "Ò" (U+00D2)
  0x00, 0x50, 0x00, 0x06, 0x20, 0x03, 0xBB, 0x00, 0xB0, 0x64, 0x46, 0x05, 0x57, 0x20, 0x73, 0x91,
  0x0A, 0x08, 0x22, 0x90, 0x2C, 0xB1, 0x00,
  // "Ó" (U+00D3)
  0x00, 0x02, 0x30, 0x00, 0x80, 0x03, 0xBB, 0x00, 0xB0, 0x64, 0x46, 0x05, 0x57, 0x20, 0x73, 0x91,
  0x0A, 0x08, 0x22, 0x90, 0x2C, 0xB1, 0x00,
  // "Ô" (U+00D4)
  0x00, 0x14, 0x00, 0x07, 0x80, 0x03, 0xBB, 0x00, 0xB0, 0x64, 0x46, 0x05, 0x57, 0x20, 0x73, 0x91,
  0x0A, 0x08, 0x22, 0x90, 0x2C, 0xB1, 0x00,
  // "Õ" (U+00D5)
  0x03, 0xFF, 0x30, 0xB0, 0x64, 0x46, 0x05, 0x57, 0x20, 0x73, 0x91, 0x0A, 0x08, 0x22, 0x90, 0x2C,
  0xB1, 0x00,
  // "Ö" (U+00D6)
  0x00, 0x43, 0x40, 0x3B, 0xB0, 0x0B, 0x06, 0x44, 0x60, 0x55, 0x72, 0x07, 0x39, 0x10, 0xA0, 0x82,
  0x29, 0x02, 0xCB, 0x10,
  // "×" (U+00D7)
  0x10, 0x01, 0x29, 0x92, 0x09, 0x90, 0x42, 0x23,
  // "Ø" (U+00D8)
  0x48, 0xC3, 0x10, 0x3B, 0xB6, 0x0B, 0x0B, 0x44, 0x64, 0xA5, 0x83, 0x87, 0x39, 0x81, 0xA0, 0x87,
  0x29, 0x08, 0xCB, 0x10, 0x14,
  // "Ù" (U+00D9)
  0x00, 0x50, 0x00, 0x06, 0x20, 0x0A, 0x04, 0x50, 0x90, 0x72, 0x27, 0x09, 0x05, 0x40, 0xA0, 0x82,
  0x09, 0x09, 0x14, 0x50, 0x4B, 0x90, 0x00,
  // "Ú" (U+00DA)
  0x00, 0x02, 0x30, 0x00, 0x80, 0x0A, 0x04, 0x50, 0x90, 0x72, 0x27, 0x09, 0x05, 0x40, 0xA0, 0x82,
  0x09, 0x09, 0x14, 0x50, 0x4B, 0x90, 0x00,
  // "Û" (U+00DB)
  0x00, 0x14, 0x00, 0x07, 0x80, 0x0A, 0x04, 0x50, 0x90, 0x72, 0x27, 0x09, 0x05, 0x40, 0xA0, 0x82,
  0x09, 0x09, 0x14, 0x50, 0x4B, 0x90, 0x00,
  // "Ü" (U+00DC)
  0x00, 0x43, 0x40, 0xA0, 0x45, 0x09, 0x07, 0x22, 0x70, 0x90, 0x54, 0x0A, 0x08, 0x20, 0x90, 0x91,
  0x45, 0x04, 0xB9, 0x00,
  // "Ý" (U+00DD)
  0x00, 0x23, 0x00, 0x80, 0x36, 0x19, 0x18, 0x73, 0x09, 0x90, 0x0D, 0x40, 0x0A, 0x00, 0x0A, 0x00,
  0x28, 0x00,
  // "Þ" (U+00DE)
  0x0A, 0x00, 0x0D, 0xB1, 0x28, 0x47, 0x45, 0x36, 0x73, 0x83, 0xAC, 0x70, 0xA0, 0x00,
  // "ß" (U+00DF)
  0x00, 0x6C, 0x60, 0x0A, 0x18, 0x02, 0x79, 0x10, 0x56, 0x80, 0x08, 0x1A, 0x00, 0xA0, 0x73, 0x0A,
  0xBB, 0x02, 0x80, 0x00, 0xC2, 0x00, 0x00,
  // "à" (U+00E0)
  0x05, 0x00, 0x06, 0x20, 0x00, 0x00, 0x0A, 0x98, 0x55, 0x56, 0x90, 0x63, 0xA0, 0xC0, 0x7B, 0xA0,
  // "á" (U+00E1)
  0x00, 0x23, 0x00, 0x80, 0x00, 0x00, 0x0A, 0x98, 0x55, 0x56, 0x90, 0x63, 0xA0, 0xC0, 0x7B, 0xA0,
  // "â" (U+00E2)
  0x01, 0x40, 0x07, 0x80, 0x00, 0x00, 0x0A, 0x98, 0x55, 0x56, 0x90, 0x63, 0xA0, 0xC0, 0x7B, 0xA0,
  // "ã" (U+00E3)
  0x09, 0xB2, 0x0A, 0x98, 0x55, 0x56, 0x90, 0x63, 0xA0, 0xC0, 0x7B, 0xA0,
  // "ä" (U+00E4)
  0x04, 0x34, 0x00, 0x00, 0x0A, 0x98, 0x55, 0x56, 0x90, 0x63, 0xA0, 0xC0, 0x7B, 0xA0,
  // "å" (U+00E5)
  0x00, 0x54, 0x00, 0x54, 0x0A, 0x98, 0x55, 0x56, 0x90, 0x63, 0xA0, 0xC0, 0x7B, 0xA0,
  // "æ" (U+00E6)
  0x0A, 0x9B, 0xC2, 0x55, 0x66, 0x73, 0x90, 0x8B, 0x70, 0xA0, 0xD1, 0x00, 0x7A, 0xAC, 0x70,
  // "ç" (U+00E7)
  0x0A, 0xB5, 0x50, 0x90, 0x0A, 0x00, 0x6D, 0x30, 0x80, 0x46, 0x00,
  // "è" (U+00E8)
  0x05, 0x00, 0x06, 0x20, 0x00, 0x00, 0x0A, 0xC0, 0x55, 0x91, 0x9B, 0x60, 0xA0, 0x00, 0x6C, 0x60,
  // "é" (U+00E9)
  0x00, 0x23, 0x00, 0x80, 0x00, 0x00, 0x0A, 0xC0, 0x55, 0x91, 0x9B, 0x60, 0xA0, 0x00, 0x6C, 0x60,
  // "ê" (U+00EA)
  0x01, 0x40, 0x07, 0x80, 0x00, 0x00, 0x0A, 0xC0, 0x55, 0x91, 0x9B, 0x60, 0xA0, 0x00, 0x6C, 0x60,
  // "ë" (U+00EB)
  0x04, 0x34, 0x00, 0x00, 0x0A, 0xC0, 0x55, 0x91, 0x9B, 0x60, 0xA0, 0x00, 0x6C, 0x60,
  // "ì" (U+00EC)
  0x50, 0x62, 0x00, 0x18, 0x45, 0x72, 0x90, 0x90,
  // "í" (U+00ED)
  0x02, 0x30, 0x80, 0x00, 0x01, 0x80, 0x45, 0x07, 0x20, 0x90, 0x09, 0x00,
  // "î" (U+00EE)
  0x14, 0x78, 0x00, 0x18, 0x45, 0x72, 0x90, 0x90,
  // "ï" (U+00EF)
  0x43, 0x40, 0x00, 0x18, 0x04, 0x50, 0x72, 0x09, 0x00, 0x90, 0x00,
  // "ð" (U+00F0)
  0x03, 0x12, 0x05, 0xD1, 0x02, 0x72, 0x0A, 0xB4, 0x73, 0x84, 0xA0, 0x72, 0xA0, 0xA0, 0x7C, 0x50,
  // "ñ" (U+00F1)
  0x09, 0xB2, 0x1B, 0xB3, 0x48, 0x45, 0x73, 0x72, 0x90, 0x90, 0xA0, 0xA0,
  // "ò" (U+00F2)
  0x05, 0x00, 0x06, 0x20, 0x00, 0x00, 0x0A, 0xC1, 0x55, 0x55, 0x90, 0x64, 0xA0, 0xA0, 0x6C, 0x60,
  // "ó" (U+00F3)
  0x00, 0x23, 0x00, 0x80, 0x00, 0x00, 0x0A, 0xC1, 0x55, 0x55, 0x90, 0x64, 0xA0, 0xA0, 0x6C, 0x60,
  // "ô" (U+00F4)
  0x01, 0x40, 0x07, 0x80, 0x00, 0x00, 0x0A, 0xC1, 0x55, 0x55, 0x90, 0x64, 0xA0, 0xA0, 0x6C, 0x60,
  // "õ" (U+00F5)
  0x09, 0xB2, 0x0A, 0xC1, 0x55, 0x55, 0x90, 0x64, 0xA0, 0xA0, 0x6C, 0x60,
  // "ö" (U+00F6)
  0x04, 0x34, 0x00, 0x00, 0x0A, 0xC1, 0x55, 0x55, 0x90, 0x64, 0xA0, 0xA0, 0x6C, 0x60,
  // "÷" (U+00F7)
  0x03, 0x30, 0x7B, 0xB6, 0x00, 0x00, 0x03, 0x30,
  // "ø" (U+00F8)
  0x00, 0x01, 0x0A, 0xC5, 0x64, 0xA5, 0x96, 0x74, 0xA6, 0xA0, 0x9C, 0x60, 0x20, 0x00,
  // "ù" (U+00F9)
  0x05, 0x00, 0x06, 0x20, 0x00, 0x00, 0x27, 0x28, 0x54, 0x45, 0x82, 0x72, 0xA0, 0xB0, 0x89, 0xA0,
  // "ú" (U+00FA)
  0x00, 0x23, 0x00, 0x80, 0x00, 0x00, 0x27, 0x28, 0x54, 0x45, 0x82, 0x72, 0xA0, 0xB0, 0x89, 0xA0,
  // "û" (U+00FB)
  0x01, 0x40, 0x07, 0x80, 0x00, 0x00, 0x27, 0x28, 0x54, 0x45, 0x82, 0x72, 0xA0, 0xB0, 0x89, 0xA0,
  // "ü" (U+00FC)
  0x04, 0x34, 0x00, 0x00, 0x27, 0x28, 0x54, 0x45, 0x82, 0x72, 0xA0, 0xB0, 0x89, 0xA0,
  // "ý" (U+00FD)
  0x30, 0x20, 0x33, 0x08, 0x78, 0x67, 0x26, 0x30, 0x62, 0xA2, 0x81, 0x57, 0x62, 0x05, 0x0C, 0x30,
  0x40, 0x83, 0x08, 0x02, 0x20, 0x08, 0x30,
  // "þ" (U+00FE)
  0x20, 0xA4, 0x0A, 0x38, 0xA5, 0x1B, 0xC3, 0x04, 0x83, 0x70, 0x72, 0x45, 0x0A, 0x19, 0x10, 0xAB,
  0x72, 0x08, 0x30, 0x30, 0x63,
  // "ÿ" (U+00FF)
  0x28, 0x14, 0x34, 0x68, 0x67, 0x26, 0x30, 0x62, 0xA2, 0x81, 0x57, 0x62, 0x05, 0x0C, 0x30, 0x40,
  0x83, 0x08, 0x02, 0x20, 0x08, 0x30,
  // "Ā" (U+0100)
  0x00, 0x1F, 0x80, 0x07, 0xB0, 0x00, 0xA9, 0x00, 0x37, 0x90, 0x08, 0xBD, 0x00, 0xA0, 0x91, 0x46,
  0x08, 0x10,
  // "ā" (U+0101)
  0x00, 0x88, 0x0A, 0x98, 0x55, 0x56, 0x90, 0x63, 0xA0, 0xC0, 0x7B, 0xA0,
  // "Ă" (U+0102)
  0x00, 0x02, 0x20, 0x01, 0xF7, 0x00, 0x7B, 0x00, 0x0A, 0x90, 0x03, 0x79, 0x00, 0x8B, 0xD0, 0x0A,
  0x09, 0x14, 0x60, 0x81,
  // "ă" (U+0103)
  0x02, 0x20, 0x07, 0x70, 0x0A, 0x98, 0x55, 0x56, 0x90, 0x63, 0xA0, 0xC0, 0x7B, 0xA0,
  // "Ą" (U+0104)
  0x00, 0x1D, 0x00, 0x07, 0xB0, 0x00, 0xA9, 0x00, 0x37, 0x90, 0x08, 0xBD, 0x00, 0xA0, 0x91, 0x46,
  0x0A, 0x10, 0x02, 0x50, 0x00, 0x26, 0x00,
  // "ą" (U+0105)
  0x0A, 0x98, 0x55, 0x56, 0x90, 0x63, 0xA0, 0xC0, 0x7B, 0xB0, 0x02, 0x50, 0x02, 0x60,
  // "Ć" (U+0106)
  0x00, 0x23, 0x00, 0x80, 0x02, 0xBB, 0x0B, 0x00, 0x46, 0x00, 0x82, 0x00, 0x91, 0x00, 0x83, 0x00,
  0x2C, 0xA0,
  // "ć" (U+0107)
  0x20, 0x20, 0x32, 0x08, 0x68, 0x3A, 0xB0, 0x55, 0x20, 0x93, 0x0A, 0x38, 0x16, 0xC3, 0x10,
  // "Ĉ" (U+0108)
  0x00, 0x14, 0x00, 0x78, 0x02, 0xBB, 0x0B, 0x00, 0x46, 0x00, 0x82, 0x00, 0x91, 0x00, 0x83, 0x00,
  0x2C, 0xA0,
  // "ĉ" (U+0109)
  0x01, 0x40, 0x78, 0x00, 0x00, 0xAB, 0x55, 0x09, 0x00, 0xA0, 0x06, 0xC3,
  // "Ċ" (U+010A)
  0x00, 0x06, 0x02, 0xBB, 0x0B, 0x00, 0x46, 0x00, 0x82, 0x00, 0x91, 0x00, 0x83, 0x00, 0x2C, 0xA0,
  // "ċ" (U+010B)
  0x00, 0x60, 0x00, 0x0A, 0xB5, 0x50, 0x90, 0x0A, 0x00, 0x6C, 0x30,
  // "Č" (U+010C)
  0x00, 0x33, 0x10, 0x07, 0x70, 0x02, 0xBB, 0x00, 0xB0, 0x00, 0x46, 0x00, 0x08, 0x20, 0x00, 0x91,
  0x00, 0x08, 0x30, 0x00, 0x2C, 0xA0, 0x00,
  // "č" (U+010D)
  0x18, 0x43, 0x31, 0x07, 0x76, 0x83, 0xAB, 0x05, 0x52, 0x09, 0x30, 0xA3, 0x81, 0x6C, 0x31,
  // "Ď" (U+010E)
  0x00, 0x33, 0x10, 0x07, 0x70, 0x0B, 0xC6, 0x00, 0xA0, 0xB0, 0x28, 0x0A, 0x04, 0x50, 0xB0, 0x72,
  0x0A, 0x09, 0x08, 0x40, 0xCB, 0x70, 0x00,
  // "ď" (U+010F)
  0x00, 0x09, 0x81, 0x00, 0x09, 0x30, 0x0A, 0x99, 0x00, 0x55, 0x56, 0x00, 0x90, 0x63, 0x00, 0xA0,
  0xC0, 0x00, 0x7A, 0xA0, 0x00,
  // "Đ" (U+0110)
  0x0B, 0xC6, 0x0A, 0x0B, 0x28, 0x0A, 0x9D, 0x2B, 0x73, 0x0A, 0x90, 0x84, 0xCC, 0x70,
  // "đ" (U+0111)
  0x30, 0x93, 0x8B, 0x08, 0xE4, 0x0A, 0x99, 0x05, 0x55, 0x70, 0x90, 0x64, 0x0A, 0x0C, 0x10, 0x7A,
  0xA2,
  // "Ē" (U+0112)
  0x0B, 0xFE, 0x0A, 0x00, 0x28, 0x00, 0x4D, 0xA0, 0x73, 0x00, 0x90, 0x00, 0xCB, 0x50,
  // "ē" (U+0113)
  0x08, 0x80, 0x0A, 0xC0, 0x55, 0x91, 0x9B, 0x60, 0xA0, 0x00, 0x6C, 0x60,
  // "Ĕ" (U+0114)
  0x00, 0x22, 0x0B, 0xFE, 0x0A, 0x00, 0x28, 0x00, 0x4D, 0xA0, 0x73, 0x00, 0x90, 0x00, 0xCB, 0x50,
  // "ĕ" (U+0115)
  0x02, 0x20, 0x07, 0x70, 0x0A, 0xC0, 0x55, 0x91, 0x9B, 0x60, 0xA0, 0x00, 0x6C, 0x60,
  // "Ė" (U+0116)
  0x00, 0x60, 0x0B, 0xB6, 0x0A, 0x00, 0x28, 0x00, 0x4D, 0xA0, 0x73, 0x00, 0x90, 0x00, 0xCB, 0x50,
  // "ė" (U+0117)
  0x20, 0x66, 0x89, 0x2A, 0xC0, 0x55, 0x91, 0x9B, 0x60, 0xA3, 0x81, 0x6C, 0x61,
  // "Ę" (U+0118)
  0x0B, 0xB6, 0x0A, 0x00, 0x28, 0x00, 0x4D, 0xA0, 0x73, 0x00, 0x90, 0x00, 0xCD, 0x50, 0x25, 0x00,
  0x26, 0x00,
  // "ę" (U+0119)
  0x0A, 0xC0, 0x55, 0x91, 0x9B, 0x60, 0xA0, 0x00, 0x6C, 0x60, 0x07, 0x00, 0x0A, 0x20,
  // "Ě" (U+011A)
  0x00, 0x33, 0x10, 0x07, 0x70, 0x0B, 0xB6, 0x00, 0xA0, 0x00, 0x28, 0x00, 0x04, 0xDA, 0x00, 0x73,
  0x00, 0x09, 0x00, 0x00, 0xCB, 0x50, 0x00,
  // "ě" (U+011B)
  0x03, 0x31, 0x07, 0x70, 0x00, 0x00, 0x0A, 0xC0, 0x55, 0x91, 0x9B, 0x60, 0xA0, 0x00, 0x6C, 0x60,
  // "Ĝ" (U+011C)
  0x00, 0x14, 0x00, 0x07, 0x80, 0x03, 0xBC, 0x30, 0xB1, 0x00, 0x46, 0x00, 0x07, 0x25, 0xC0, 0x91,
  0x0A, 0x08, 0x30, 0x90, 0x2C, 0xB5, 0x00,
  // "ĝ" (U+011D)
  0x01, 0x40, 0x07, 0x80, 0x00, 0x00, 0x0A, 0x98, 0x55, 0x56, 0x90, 0x63, 0xA0, 0xC0, 0x7B, 0xB0,
  0x01, 0x90, 0xBB, 0x20,
  // "Ğ" (U+011E)
  0x00, 0x22, 0x00, 0x3F, 0xF3, 0x0B, 0x10, 0x04, 0x60, 0x00, 0x72, 0x5C, 0x09, 0x10, 0xA0, 0x83,
  0x09, 0x02, 0xCB, 0x50,
  // "ğ" (U+011F)
  0x02, 0x20, 0x07, 0x70, 0x0A, 0x98, 0x55, 0x56, 0x90, 0x63, 0xA0, 0xC0, 0x7B, 0xB0, 0x01, 0x90,
  0xBB, 0x20,
  // "Ġ" (U+0120)
  0x00, 0x06, 0x00, 0x3B, 0xC3, 0x0B, 0x10, 0x04, 0x60, 0x00, 0x72, 0x5C, 0x09, 0x10, 0xA0, 0x83,
  0x09, 0x02, 0xCB, 0x50,
  // "ġ" (U+0121)
  0x00, 0x60, 0x00, 0x00, 0x0A, 0x98, 0x55, 0x56, 0x90, 0x63, 0xA0, 0xC0, 0x7B, 0xB0, 0x01, 0x90,
  0xBB, 0x20,
  // "Ģ" (U+0122)
  0x03, 0xBC, 0x30, 0xB1, 0x00, 0x46, 0x00, 0x07, 0x25, 0xC0, 0x91, 0x0A, 0x08, 0x30, 0x90, 0x2C,
  0xB5, 0x00, 0x50, 0x00, 0x34, 0x00, 0x00,
  // "ģ" (U+0123)
  0x00, 0x70, 0x00, 0x40, 0x0A, 0x98, 0x55, 0x56, 0x90, 0x63, 0xA0, 0xC0, 0x7B, 0xB0, 0x01, 0x90,
  0xBB, 0x20,
  // "Ĥ" (U+0124)
  0x00, 0x14, 0x00, 0x07, 0x80, 0x0A, 0x04, 0x50, 0xA0, 0x63, 0x18, 0x09, 0x04, 0xCA, 0xC0, 0x73,
  0x09, 0x09, 0x02, 0x70, 0xA0, 0x45, 0x00,
  // "ĥ" (U+0125)
  0x01, 0x40, 0x07, 0x80, 0x00, 0x00, 0x0A, 0x00, 0x0A, 0x00, 0x1B, 0xC3, 0x47, 0x45, 0x73, 0x72,
  0x90, 0x90, 0xA0, 0x90,
  // "Ħ" (U+0126)
  0x0A, 0x04, 0x56, 0xEB, 0xD9, 0x18, 0x09, 0x04, 0xDB, 0xC0, 0x73, 0x09, 0x09, 0x02, 0x70, 0xA0,
  0x45, 0x00,
  // "ħ" (U+0127)
  0x09, 0x00, 0x3D, 0x60, 0x0B, 0xC3, 0x37, 0x45, 0x62, 0x72, 0x90, 0x90, 0xA0, 0x90,
  // "Ĩ" (U+0128)
  0x10, 0x1A, 0x02, 0x20, 0xA4, 0x0A, 0x30, 0x10, 0x83, 0x04, 0x05, 0x30, 0x70, 0x32, 0x81, 0x2C,
  0x52,
  // "ĩ" (U+0129)
  0x9B, 0x21, 0x80, 0x45, 0x07, 0x20, 0x90, 0x09, 0x00,
  // "Ī" (U+012A)
  0x01, 0xFE, 0x00, 0xA0, 0x00, 0xA0, 0x01, 0x80, 0x04, 0x50, 0x07, 0x30, 0x2C, 0x50,
  // "ī" (U+012B)
  0x88, 0x18, 0x45, 0x72, 0x90, 0x90,
  // "Ĭ" (U+012C)
  0x00, 0x22, 0x01, 0xFD, 0x00, 0xA0, 0x00, 0xA0, 0x01, 0x80, 0x04, 0x50, 0x07, 0x30, 0x2C, 0x50,
  // "ĭ" (U+012D)
  0x22, 0x77, 0x18, 0x45, 0x72, 0x90, 0x90,
  // "Į" (U+012E)
  0x01, 0xD6, 0x00, 0xA0, 0x00, 0xA0, 0x01, 0x80, 0x04, 0x50, 0x07, 0x30, 0x2E, 0x50, 0x25, 0x00,
  0x26, 0x00,
  // "į" (U+012F)
  0x00, 0x60, 0x00, 0x01, 0x80, 0x45, 0x07, 0x20, 0x90, 0x0B, 0x02, 0x50, 0x26, 0x00,
  // "İ" (U+0130)
  0x00, 0x06, 0x01, 0xD6, 0x00, 0xA0, 0x00, 0xA0, 0x01, 0x80, 0x04, 0x50, 0x07, 0x30, 0x2C, 0x50,
  // "ı" (U+0131)
  0x18, 0x45, 0x72, 0x90, 0x90,
  // "Ĳ" (U+0132)
  0x01, 0xD6, 0xA0, 0x0A, 0x09, 0x00, 0xA2, 0x70, 0x18, 0x54, 0x04, 0x59, 0x10, 0x73, 0xA0, 0x2C,
  0x6A, 0x00, 0x1B, 0x30,
  // "ĳ" (U+0133)
  0x06, 0x06, 0x00, 0x00, 0x18, 0x27, 0x45, 0x45, 0x72, 0x72, 0x90, 0x90, 0x90, 0xA0, 0x01, 0x80,
  0x0C, 0x30,
  // "Ĵ" (U+0134)
  0x30, 0x10, 0x43, 0x07, 0x08, 0x30, 0xA4, 0x09, 0x30, 0x20, 0x73, 0x05, 0x04, 0x30, 0x90, 0x13,
  0x0A, 0x30, 0x10, 0xA2, 0x81, 0x1B, 0x32,
  // "ĵ" (U+0135)
  0x01, 0x40, 0x78, 0x00, 0x00, 0x27, 0x04, 0x50, 0x72, 0x09, 0x00, 0xA0, 0x18, 0x0C, 0x30,
  // "Ķ" (U+0136)
  0x0A, 0x0A, 0x10, 0xA6, 0x50, 0x29, 0xA0, 0x04, 0xE5, 0x00, 0x75, 0x80, 0x09, 0x0A, 0x00, 0xA0,
  0xA0, 0x00, 0x50, 0x00, 0x34, 0x00, 0x00,
  // "ķ" (U+0137)
  0x09, 0x00, 0x09, 0x00, 0x18, 0x83, 0x49, 0x70, 0x7D, 0x20, 0x94, 0x60, 0xA1, 0x90, 0x05, 0x00,
  0x34, 0x00,
  // "ĸ" (U+0138)
  0x18, 0x83, 0x49, 0x70, 0x7D, 0x20, 0x94, 0x60, 0xA1, 0x90,
  // "Ĺ" (U+0139)
  0x00, 0x23, 0x00, 0x80, 0x0A, 0x00, 0x0A, 0x00, 0x28, 0x00, 0x45, 0x00, 0x72, 0x00, 0x90, 0x00,
  0xCA, 0x40,
  // "ĺ" (U+013A)
  0x02, 0x30, 0x80, 0x00, 0x00, 0x90, 0x09, 0x01, 0x80, 0x45, 0x07, 0x20, 0x90, 0x09, 0x00,
  // "Ļ" (U+013B)
  0x0A, 0x00, 0xA0, 0x28, 0x04, 0x50, 0x72, 0x09, 0x00, 0xCA, 0x40, 0x50, 0x34, 0x00,
  // "ļ" (U+013C)
  0x00, 0x90, 0x09, 0x01, 0x80, 0x45, 0x07, 0x20, 0x90, 0x09, 0x00, 0x50, 0x34, 0x00,
  // "Ľ" (U+013D)
  0x0A, 0x54, 0x0A, 0x40, 0x28, 0x00, 0x45, 0x00, 0x72, 0x00, 0x90, 0x00, 0xCA, 0x40,
  // "ľ" (U+013E)
  0x09, 0x81, 0x09, 0x30, 0x18, 0x00, 0x45, 0x00, 0x72, 0x00, 0x90, 0x00, 0x90, 0x00,
  // "Ŀ" (U+013F)
  0x0A, 0x00, 0xA0, 0x28, 0x04, 0x56, 0x72, 0x09, 0x00, 0xCA, 0x40,
  // "ŀ" (U+0140)
  0x09, 0x00, 0x90, 0x18, 0x04, 0x56, 0x72, 0x09, 0x00, 0x90, 0x00,
  // "Ł" (U+0141)
  0x0A, 0x00, 0xA0, 0x1A, 0x35, 0xB1, 0xC3, 0x09, 0x10, 0xBA, 0x50,
  // "ł" (U+0142)
  0x09, 0x09, 0x0A, 0x6A, 0x93, 0x90, 0x90,
  // "Ń" (U+0143)
  0x00, 0x02, 0x30, 0x00, 0x80, 0x0C, 0x20, 0x90, 0xD5, 0x27, 0x29, 0x85, 0x44, 0x59, 0x81, 0x72,
  0x99, 0x09, 0x08, 0xA0, 0x90, 0x59, 0x00,
  // "ń" (U+0144)
  0x00, 0x23, 0x00, 0x80, 0x00, 0x00, 0x1B, 0xB3, 0x48, 0x45, 0x73, 0x72, 0x90, 0x90, 0xA0, 0xA0,
  // "Ņ" (U+0145)
  0x0C, 0x20, 0x90, 0xD5, 0x27, 0x29, 0x85, 0x44, 0x59, 0x81, 0x72, 0x99, 0x09, 0x08, 0xA0, 0x90,
  0x59, 0x00, 0x50, 0x00, 0x34, 0x00, 0x00,
  // "ņ" (U+0146)
  0x1B, 0xB3, 0x48, 0x45, 0x73, 0x72, 0x90, 0x90, 0xA0, 0xA0, 0x05, 0x00, 0x34, 0x00,
  // "Ň" (U+0147)
  0x00, 0x33, 0x10, 0x07, 0x70, 0x0C, 0x20, 0x90, 0xD5, 0x27, 0x29, 0x85, 0x44, 0x59, 0x81, 0x72,
  0x99, 0x09, 0x08, 0xA0, 0x90, 0x59, 0x00,
  // "ň" (U+0148)
  0x03, 0x31, 0x07, 0x70, 0x00, 0x00, 0x1B, 0xB3, 0x48, 0x45, 0x73, 0x72, 0x90, 0x90, 0xA0, 0xA0,
  // "ŉ" (U+0149)
  0x0A, 0x00, 0x53, 0x00, 0x1B, 0xB3, 0x48, 0x45, 0x73, 0x72, 0x90, 0x90, 0xA0, 0xA0,
  // "Ŋ" (U+014A)
  0x0C, 0x20, 0x90, 0xD5, 0x37, 0x28, 0x85, 0x44, 0x59, 0x81, 0x72, 0x99, 0x09, 0x07, 0xA0, 0x90,
  0x49, 0x00, 0x04, 0x50, 0x04, 0xB0, 0x00,
  // "ŋ" (U+014B)
  0x1A, 0xC3, 0x47, 0x45, 0x72, 0x72, 0x90, 0x90, 0xA0, 0xA0, 0x01, 0x80, 0x0C, 0x30,
  // "Ō" (U+014C)
  0x04, 0xFF, 0x00, 0xB0, 0x64, 0x46, 0x05, 0x57, 0x20, 0x73, 0x91, 0x0A, 0x08, 0x22, 0x90, 0x2C,
  0xB1, 0x00,
  // "ō" (U+014D)
  0x08, 0x80, 0x0A, 0xC1, 0x55, 0x55, 0x90, 0x64, 0xA0, 0xA0, 0x6C, 0x60,
  // "Ŏ" (U+014E)
  0x00, 0x22, 0x00, 0x3F, 0xF0, 0x0B, 0x06, 0x44, 0x60, 0x55, 0x72, 0x07, 0x39, 0x10, 0xA0, 0x82,
  0x29, 0x02, 0xCB, 0x10,
  // "ŏ" (U+014F)
  0x02, 0x20, 0x07, 0x70, 0x0A, 0xC1, 0x55, 0x55, 0x90, 0x64, 0xA0, 0xA0, 0x6C, 0x60,
  // "Ő" (U+0150)
  0x00, 0x77, 0x40, 0x3C, 0xC0, 0x0B, 0x06, 0x44, 0x60, 0x55, 0x72, 0x07, 0x39, 0x10, 0xA0, 0x82,
  0x29, 0x02, 0xCB, 0x10,
  // "ő" (U+0151)
  0x00, 0x77, 0x40, 0x00, 0x10, 0x0A, 0xC1, 0x05, 0x55, 0x50, 0x90, 0x64, 0x0A, 0x0A, 0x00, 0x6C,
  0x60, 0x00,
  // "Œ" (U+0152)
  0x04, 0xCE, 0xB7, 0x0B, 0x0A, 0x00, 0x46, 0x19, 0x00, 0x82, 0x3D, 0xB0, 0x91, 0x63, 0x00, 0x82,
  0x91, 0x00, 0x2C, 0xEB, 0x60,
  // "œ" (U+0153)
  0x0A, 0xB5, 0xC4, 0x55, 0x59, 0x55, 0x90, 0x5C, 0x90, 0xA0, 0xA3, 0x00, 0x6C, 0x6C, 0x90,
  // "Ŕ" (U+0154)
  0x00, 0x23, 0x00, 0x80, 0x0B, 0xC5, 0x0A, 0x0A, 0x27, 0x38, 0x4D, 0xC1, 0x73, 0x90, 0x90, 0xA0,
  0xA0, 0xA0,
  // "ŕ" (U+0155)
  0x20, 0x20, 0x32, 0x08, 0x58, 0x41, 0xA8, 0x04, 0x82, 0x07, 0x02, 0x20, 0x93, 0x0A, 0x30,
  // "Ŗ" (U+0156)
  0x0B, 0xC5, 0x0A, 0x0A, 0x27, 0x38, 0x4D, 0xC1, 0x73, 0x90, 0x90, 0xA0, 0xA0, 0xA0, 0x05, 0x00,
  0x34, 0x00,
  // "ŗ" (U+0157)
  0x01, 0xA8, 0x04, 0x80, 0x07, 0x20, 0x09, 0x00, 0x0A, 0x00, 0x05, 0x00, 0x34, 0x00,
  // "Ř" (U+0158)
  0x00, 0x33, 0x10, 0x07, 0x70, 0x0B, 0xC5, 0x00, 0xA0, 0xA0, 0x27, 0x38, 0x04, 0xDC, 0x10, 0x73,
  0x90, 0x09, 0x0A, 0x00, 0xA0, 0xA0, 0x00,
  // "ř" (U+0159)
  0x18, 0x43, 0x31, 0x07, 0x75, 0x84, 0x1A, 0x80, 0x48, 0x20, 0x70, 0x22, 0x09, 0x30, 0xA3,
  // "Ś" (U+015A)
  0x00, 0x23, 0x00, 0x80, 0x09, 0xB5, 0x37, 0x00, 0x38, 0x00, 0x09, 0x40, 0x00, 0xA0, 0x00, 0xB0,
  0xCC, 0x40,
  // "ś" (U+015B)
  0x00, 0x23, 0x00, 0x80, 0x00, 0x00, 0x3C, 0x80, 0x73, 0x00, 0x1A, 0x00, 0x06, 0x40, 0xBC, 0x10,
  // "Ŝ" (U+015C)
  0x01, 0x40, 0x07, 0x80, 0x09, 0xB5, 0x37, 0x00, 0x38, 0x00, 0x09, 0x40, 0x00, 0xA0, 0x00, 0xB0,
  0xCC, 0x40,
  // "ŝ" (U+015D)
  0x01, 0x40, 0x78, 0x00, 0x03, 0xC8, 0x73, 0x01, 0xA0, 0x06, 0x4B, 0xC1,
  // "Ş" (U+015E)
  0x09, 0xB5, 0x37, 0x00, 0x38, 0x00, 0x09, 0x40, 0x00, 0xA0, 0x00, 0xB0, 0xCD, 0x40, 0x08, 0x00,
  0x46, 0x00,
  // "ş" (U+015F)
  0x3C, 0x87, 0x30, 0x1A, 0x00, 0x64, 0xBD, 0x10, 0x80, 0x46, 0x00,
  // "Š" (U+0160)
  0x28, 0x13, 0x31, 0x20, 0x07, 0x28, 0x49, 0xB5, 0x03, 0x73, 0x03, 0x08, 0x40, 0x90, 0x44, 0x0A,
  0x40, 0xB2, 0x81, 0xCC, 0x42,
  // "š" (U+0161)
  0x03, 0x31, 0x07, 0x70, 0x00, 0x00, 0x3C, 0x80, 0x73, 0x00, 0x1A, 0x00, 0x06, 0x40, 0xBC, 0x10,
  // "Ţ" (U+0162)
  0x3C, 0xD8, 0x05, 0x50, 0x07, 0x20, 0x0A, 0x00, 0x0A, 0x00, 0x0A, 0x00, 0x29, 0x00, 0x08, 0x00,
  0x46, 0x00,
  // "ţ" (U+0163)
  0x08, 0x05, 0xD3, 0x45, 0x07, 0x20, 0x90, 0x08, 0x80, 0x08, 0x04, 0x60,
  // "Ť" (U+0164)
  0x03, 0x31, 0x07, 0x70, 0x3C, 0xD8, 0x05, 0x50, 0x07, 0x20, 0x0A, 0x00, 0x0A, 0x00, 0x0A, 0x00,
  0x27, 0x00,
  // "ť" (U+0165)
  0x00, 0x80, 0x83, 0x5D, 0x34, 0x50, 0x72, 0x09, 0x00, 0x87, 0x00,
  // "Ŧ" (U+0166)
  0x3C, 0xD8, 0x04, 0x50, 0x07, 0x20, 0x5E, 0xA0, 0x0A, 0x00, 0x09, 0x00, 0x27, 0x00,
  // "ŧ" (U+0167)
  0x07, 0x05, 0xD3, 0x36, 0x0B, 0xC0, 0x80, 0x09, 0x70,
  // "Ũ" (U+0168)
  0x0A, 0x9F, 0x70, 0x90, 0x72, 0x27, 0x09, 0x05, 0x40, 0xA0, 0x82, 0x09, 0x09, 0x14, 0x50, 0x4B,
  0x90, 0x00,
  // "ũ" (U+0169)
  0x09, 0xB2, 0x27, 0x28, 0x54, 0x45, 0x82, 0x72, 0xA0, 0xB0, 0x89, 0xA0,
  // "Ū" (U+016A)
  0x0A, 0x8D, 0x50, 0x90, 0x72, 0x27, 0x09, 0x05, 0x40, 0xA0, 0x82, 0x09, 0x09, 0x14, 0x50, 0x4B,
  0x90, 0x00,
  // "ū" (U+016B)
  0x08, 0x80, 0x27, 0x28, 0x54, 0x45, 0x82, 0x72, 0xA0, 0xB0, 0x89, 0xA0,
  // "Ŭ" (U+016C)
  0x00, 0x22, 0x00, 0xA7, 0xC5, 0x09, 0x07, 0x22, 0x70, 0x90, 0x54, 0x0A, 0x08, 0x20, 0x90, 0x91,
  0x45, 0x04, 0xB9, 0x00,
  // "ŭ" (U+016D)
  0x02, 0x20, 0x07, 0x70, 0x27, 0x28, 0x54, 0x45, 0x82, 0x72, 0xA0, 0xB0, 0x89, 0xA0,
  // "Ů" (U+016E)
  0x00, 0x54, 0x00, 0xA5, 0x95, 0x09, 0x07, 0x22, 0x70, 0x90, 0x54, 0x0A, 0x08, 0x20, 0x90, 0x91,
  0x45, 0x04, 0xB9, 0x00,
  // "ů" (U+016F)
  0x00, 0x54, 0x00, 0x54, 0x27, 0x28, 0x54, 0x45, 0x82, 0x72, 0xA0, 0xB0, 0x89, 0xA0,
  // "Ű" (U+0170)
  0x00, 0x77, 0x40, 0xA0, 0x55, 0x09, 0x07, 0x22, 0x70, 0x90, 0x54, 0x0A, 0x08, 0x20, 0x90, 0x91,
  0x45, 0x04, 0xB9, 0x00,
  // "ű" (U+0171)
  0x00, 0x77, 0x40, 0x00, 0x10, 0x27, 0x28, 0x05, 0x44, 0x50, 0x82, 0x72, 0x0A, 0x0B, 0x00, 0x89,
  0xA0, 0x00,
  // "Ų" (U+0172)
  0x0A, 0x04, 0x50, 0x90, 0x72, 0x27, 0x09, 0x05, 0x40, 0xA0, 0x82, 0x09, 0x09, 0x14, 0x50, 0x4D,
  0x90, 0x02, 0x50, 0x00, 0x26, 0x00, 0x00,
  // "ų" (U+0173)
  0x27, 0x28, 0x54, 0x45, 0x82, 0x72, 0xA0, 0xB0, 0x89, 0xB0, 0x02, 0x50, 0x02, 0x60,
  // "Ŵ" (U+0174)
  0x00, 0x01, 0x40, 0x00, 0x00, 0x78, 0x00, 0x35, 0x0B, 0x07, 0x24, 0x54, 0xC0, 0xA0, 0x45, 0x89,
  0x27, 0x04, 0x58, 0x87, 0x20, 0x49, 0x48, 0x90, 0x04, 0xD0, 0x97, 0x00, 0x49, 0x0B, 0x20, 0x00,
  // "ŵ" (U+0175)
  0x00, 0x14, 0x00, 0x07, 0x80, 0x00, 0x00, 0x08, 0x1B, 0x29, 0x83, 0xC3, 0x88, 0x87, 0x83, 0x89,
  0x6A, 0x08, 0x66, 0x80,
  // "Ŷ" (U+0176)
  0x01, 0x40, 0x07, 0x80, 0x36, 0x19, 0x18, 0x73, 0x09, 0x90, 0x0D, 0x40, 0x0A, 0x00, 0x0A, 0x00,
  0x28, 0x00,
  // "ŷ" (U+0177)
  0x20, 0x10, 0x43, 0x07, 0x08, 0x78, 0x67, 0x26, 0x30, 0x62, 0xA2, 0x81, 0x57, 0x62, 0x05, 0x0C,
  0x30, 0x40, 0x83, 0x08, 0x02, 0x20, 0x08, 0x30,
  // "Ÿ" (U+0178)
  0x04, 0x34, 0x36, 0x19, 0x18, 0x73, 0x09, 0x90, 0x0D, 0x40, 0x0A, 0x00, 0x0A, 0x00, 0x28, 0x00,
  // "Ź" (U+0179)
  0x00, 0x02, 0x30, 0x00, 0x80, 0x00, 0xBD, 0x70, 0x00, 0x91, 0x00, 0x28, 0x00, 0x09, 0x10, 0x03,
  0x80, 0x00, 0x91, 0x00, 0x2E, 0xB6, 0x00,
  // "ź" (U+017A)
  0x30, 0x20, 0x33, 0x08, 0x78, 0x13, 0xBA, 0x30, 0x60, 0x22, 0x01, 0x08, 0x30, 0x80, 0x12, 0x81,
  0x1D, 0xB2,
  // "Ż" (U+017B)
  0x00, 0x06, 0x00, 0x0B, 0xD7, 0x00, 0x09, 0x10, 0x02, 0x80, 0x00, 0x91, 0x00, 0x38, 0x00, 0x09,
  0x10, 0x02, 0xEB, 0x60,
  // "ż" (U+017C)
  0x00, 0x06, 0x00, 0x00, 0x03, 0xBA, 0x00, 0x62, 0x01, 0x80, 0x08, 0x10, 0x1D, 0xB0,
  // "Ž" (U+017D)
  0x00, 0x33, 0x10, 0x07, 0x70, 0x00, 0xBD, 0x70, 0x00, 0x91, 0x00, 0x28, 0x00, 0x09, 0x10, 0x03,
  0x80, 0x00, 0x91, 0x00, 0x2E, 0xB6, 0x00,
  // "ž" (U+017E)
  0x28, 0x13, 0x31, 0x20, 0x07, 0x78, 0x13, 0xBA, 0x30, 0x60, 0x22, 0x01, 0x08, 0x30, 0x80, 0x12,
  0x81, 0x1D, 0xB2,
  // "ſ" (U+017F)
  0x00, 0x79, 0x00, 0xA0, 0x02, 0x80, 0x05, 0x50, 0x08, 0x20, 0x0A, 0x00, 0x0A, 0x00, 0x18, 0x00,
  0xC3, 0x00,
  // "Ω" (U+03A9)
  0x00, 0x4C, 0xB0, 0x00, 0xB0, 0x64, 0x05, 0x50, 0x55, 0x07, 0x20, 0x73, 0x08, 0x20, 0xA0, 0x05,
  0x43, 0x60, 0x2C, 0x8C, 0xA0,
  // "μ" (U+03BC)
  0x02, 0x81, 0x80, 0x45, 0x45, 0x07, 0x27, 0x20, 0xA0, 0xB0, 0x0C, 0x9A, 0x01, 0x90, 0x00, 0x35,
  0x00, 0x00,
  // "π" (U+03C0)
  0x5D, 0xCD, 0x27, 0x63, 0x54, 0x90, 0x81, 0x90, 0x90, 0xB2,
  // "–" (U+2013)
  0x8B, 0xB4,
  // "—" (U+2014)
  0x08, 0x80, 0x2B,
  // "€" (U+20AC)
  0x01, 0xBA, 0x09, 0x20, 0x09, 0x00, 0x8D, 0x90, 0xBC, 0x50, 0x55, 0x00, 0x1C, 0x90,
  // "₿" (U+20BF)
  0x00, 0x71, 0x0B, 0xD3, 0x0A, 0x28, 0x28, 0x55, 0x4D, 0xC0, 0x73, 0xA1, 0x90, 0xA0, 0xCC, 0x60,
  0x54, 0x00,
  // "‘" (U+2018)
  0x08, 0x54,
  // "’" (U+2019)
  0x0A, 0x53,
  // "‚" (U+201A)
  0x0A, 0x26,
  // "‛" (U+201B)
  0x37, 0x17, 0x01,
  // "“" (U+201C)
  0x08, 0x71, 0x46, 0x90, 0x11, 0x10,
  // "”" (U+201D)
  0x0A, 0x91, 0x44, 0x80, 0x10, 0x00,
  // "„" (U+201E)
  0x01, 0x10, 0x0A, 0x91, 0x44, 0x80,
  // "‟" (U+201F)
  0x27, 0xA1, 0x78, 0x01, 0x10,
  // "†" (U+2020)
  0x00, 0x90, 0x02, 0x70, 0x19, 0x82, 0x06, 0x00, 0x08, 0x00, 0x09, 0x00, 0x18, 0x00,
  // "‡" (U+2021)
  0x00, 0x90, 0x04, 0x91, 0x17, 0x71, 0x07, 0x10, 0x39, 0x30, 0x49, 0x40, 0x18, 0x00,
  // "•" (U+2022)
  0x01, 0x04, 0xF6, 0x3E, 0x40,
  // "…" (U+2026)
  0x70, 0x70, 0x70,
  // "‰" (U+2030)
  0x0A, 0x61, 0x60, 0x00, 0x34, 0x77, 0x00, 0x00, 0x71, 0x87, 0x00, 0x00, 0x74, 0xB6, 0xA2, 0xB1,
  0x4B, 0x79, 0x78, 0x44, 0x07, 0x27, 0x88, 0x71, 0x07, 0x0C, 0x59, 0x80,
  // "‹" (U+2039)
  0x06, 0x64, 0x72, 0x03,
  // "›" (U+203A)
  0x31, 0x18, 0x64, 0x30,
  // "⁄" (U+2044)
  0x40, 0x73, 0x07, 0x01, 0x20, 0x20, 0x53, 0x08, 0x30, 0x50, 0x33, 0x07, 0x30, 0x70, 0x13,
  // "™" (U+2122)
  0xCD, 0xA0, 0xA2, 0x49, 0x5C, 0x24, 0x6B, 0x71, 0x12, 0x32,
  // "⅒" (U+2152)
  0x40, 0x73, 0x82, 0x23, 0x71, 0x38, 0x18, 0x75, 0x48, 0xB1, 0x6A, 0x23, 0x65, 0x0D, 0x38, 0x75,
  0x70, 0x70, 0x67, 0x27, 0x71, 0x07, 0x28, 0x10,
  // "ﬁ" (U+FB01)
  0x00, 0x6A, 0x60, 0x0A, 0x00, 0x04, 0xD5, 0x80, 0x36, 0x45, 0x06, 0x37, 0x20, 0x90, 0x90, 0x0A,
  0x09, 0x00, 0x90, 0x00, 0xB3, 0x00, 0x00,
  // "ﬂ" (U+FB02)
  0x00, 0x6A, 0x90, 0x0A, 0x09, 0x04, 0xD5, 0x80, 0x36, 0x45, 0x06, 0x37, 0x20, 0x90, 0x90, 0x0A,
  0x09, 0x00, 0x90, 0x00, 0xB3, 0x00, 0x00,
};

const Font& font_NotoSans_CondensedItalic_8() {
  static SmoothFont font(font_NotoSans_CondensedItalic_8_data);
  return font;
}

}  // namespace roo_display
