#include "40.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSans-CondensedItalic (Noto Sans Condensed Italic)
// Generated on Wed Nov 19 19:11:24 CET 2025
static const uint8_t font_NotoSans_CondensedItalic_40_data[] PROGMEM = {
  
  // Header
  0x01, 0x02, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x0C, 0x3D,
  0xF6, 0xF7, 0x25, 0x28, 0x1E, 0xF7, 0x0B, 0x05, 0x26, 0x09, 0x08, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x00, 0x01, 0x0A, 0x1D, 0x0A, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x44, 0x14, 0x0F, 0x1D, 0x0E, 0x00, 0x4F, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x14, 0x1D, 0x14, 0x00, 0x8B, // "#" (U+0023)
  0x00, 0x24, 0x00, 0xFE, 0x11, 0x1E, 0x12, 0x01, 0x41, // "$" (U+0024)
  0x00, 0x25, 0x02, 0x01, 0x19, 0x1D, 0x1B, 0x01, 0xF1, // "%" (U+0025)
  0x00, 0x26, 0x00, 0x01, 0x13, 0x1D, 0x14, 0x03, 0x07, // "&" (U+0026)
  0x00, 0x27, 0x44, 0x14, 0x09, 0x1D, 0x08, 0x03, 0xCA, // "'" (U+0027)
  0x00, 0x28, 0x01, 0xFB, 0x0D, 0x1D, 0x0B, 0x03, 0xE8, // "(" (U+0028)
  0x00, 0x29, 0xFD, 0xFB, 0x09, 0x1D, 0x0B, 0x04, 0x60, // ")" (U+0029)
  0x00, 0x2A, 0x04, 0x10, 0x11, 0x1F, 0x11, 0x04, 0xDC, // "*" (U+002A)
  0x00, 0x2B, 0x02, 0x06, 0x11, 0x18, 0x13, 0x05, 0x2B, // "+" (U+002B)
  0x00, 0x2C, 0xFE, 0xFC, 0x05, 0x05, 0x09, 0x05, 0x70, // "," (U+002C)
  0x00, 0x2D, 0x00, 0x0A, 0x09, 0x0C, 0x0B, 0x05, 0x8F, // "-" (U+002D)
  0x00, 0x2E, 0x40, 0x01, 0x04, 0x05, 0x09, 0x05, 0x9A, // "." (U+002E)
  0x00, 0x2F, 0xFE, 0x01, 0x10, 0x1D, 0x0E, 0x05, 0xA7, // "/" (U+002F)
  0x00, 0x30, 0x01, 0x01, 0x11, 0x1D, 0x12, 0x06, 0x17, // "0" (U+0030)
  0x00, 0x31, 0x04, 0x01, 0x0F, 0x1D, 0x12, 0x06, 0xBF, // "1" (U+0031)
  0x00, 0x32, 0xFF, 0x01, 0x11, 0x1D, 0x12, 0x07, 0x27, // "2" (U+0032)
  0x00, 0x33, 0xFF, 0x01, 0x11, 0x1D, 0x12, 0x07, 0xA8, // "3" (U+0033)
  0x00, 0x34, 0xFF, 0x01, 0x11, 0x1D, 0x12, 0x08, 0x33, // "4" (U+0034)
  0x00, 0x35, 0x00, 0x01, 0x11, 0x1D, 0x12, 0x08, 0xC8, // "5" (U+0035)
  0x00, 0x36, 0x01, 0x01, 0x12, 0x1D, 0x12, 0x09, 0x46, // "6" (U+0036)
  0x00, 0x37, 0x02, 0x01, 0x12, 0x1D, 0x12, 0x09, 0xE5, // "7" (U+0037)
  0x00, 0x38, 0x00, 0x01, 0x11, 0x1D, 0x12, 0x0A, 0x57, // "8" (U+0038)
  0x00, 0x39, 0x00, 0x01, 0x11, 0x1D, 0x12, 0x0B, 0x0D, // "9" (U+0039)
  0x00, 0x3A, 0x00, 0x01, 0x08, 0x16, 0x09, 0x0B, 0xAD, // ":" (U+003A)
  0x00, 0x3B, 0xFE, 0xFC, 0x08, 0x16, 0x09, 0x0B, 0xD0, // ";" (U+003B)
  0x00, 0x3C, 0x01, 0x06, 0x11, 0x18, 0x13, 0x0C, 0x03, // "<" (U+003C)
  0x00, 0x3D, 0x02, 0x0A, 0x11, 0x14, 0x13, 0x0C, 0x5E, // "=" (U+003D)
  0x00, 0x3E, 0x02, 0x06, 0x11, 0x18, 0x13, 0x0C, 0x76, // ">" (U+003E)
  0x00, 0x3F, 0x01, 0x01, 0x0E, 0x1D, 0x0D, 0x0C, 0xCA, // "?" (U+003F)
  0x00, 0x40, 0x01, 0xFD, 0x19, 0x1D, 0x1B, 0x0D, 0x35, // "@" (U+0040)
  0x00, 0x41, 0xFD, 0x01, 0x0F, 0x1D, 0x12, 0x0E, 0x5D, // "A" (U+0041)
  0x00, 0x42, 0x00, 0x01, 0x13, 0x1D, 0x13, 0x0E, 0xFE, // "B" (U+0042)
  0x00, 0x43, 0x01, 0x01, 0x14, 0x1D, 0x12, 0x0F, 0xAE, // "C" (U+0043)
  0x00, 0x44, 0x00, 0x01, 0x14, 0x1D, 0x15, 0x10, 0x35, // "D" (U+0044)
  0x00, 0x45, 0x00, 0x01, 0x11, 0x1D, 0x10, 0x10, 0xE6, // "E" (U+0045)
  0x00, 0x46, 0x00, 0x01, 0x11, 0x1D, 0x0F, 0x11, 0x4D, // "F" (U+0046)
  0x00, 0x47, 0x01, 0x01, 0x16, 0x1D, 0x16, 0x11, 0xB2, // "G" (U+0047)
  0x00, 0x48, 0x00, 0x01, 0x16, 0x1D, 0x16, 0x12, 0x5C, // "H" (U+0048)
  0x00, 0x49, 0xFE, 0x01, 0x0D, 0x1D, 0x0B, 0x13, 0x10, // "I" (U+0049)
  0x00, 0x4A, 0xFA, 0xFA, 0x09, 0x1D, 0x09, 0x13, 0x78, // "J" (U+004A)
  0x00, 0x4B, 0x00, 0x01, 0x15, 0x1D, 0x12, 0x13, 0xF8, // "K" (U+004B)
  0x00, 0x4C, 0x00, 0x01, 0x0C, 0x1D, 0x0F, 0x14, 0xAA, // "L" (U+004C)
  0x00, 0x4D, 0x00, 0x01, 0x1C, 0x1D, 0x1C, 0x15, 0x0B, // "M" (U+004D)
  0x00, 0x4E, 0x00, 0x01, 0x17, 0x1D, 0x17, 0x16, 0x27, // "N" (U+004E)
  0x00, 0x4F, 0x01, 0x01, 0x15, 0x1D, 0x17, 0x16, 0xFA, // "O" (U+004F)
  0x00, 0x50, 0x00, 0x01, 0x12, 0x1D, 0x12, 0x17, 0xB2, // "P" (U+0050)
  0x00, 0x51, 0x01, 0xFA, 0x15, 0x1D, 0x17, 0x18, 0x45, // "Q" (U+0051)
  0x00, 0x52, 0x00, 0x01, 0x12, 0x1D, 0x13, 0x19, 0x19, // "R" (U+0052)
  0x00, 0x53, 0xFF, 0x01, 0x11, 0x1D, 0x11, 0x19, 0xBF, // "S" (U+0053)
  0x00, 0x54, 0x03, 0x01, 0x12, 0x1D, 0x10, 0x1A, 0x42, // "T" (U+0054)
  0x00, 0x55, 0x01, 0x01, 0x16, 0x1D, 0x15, 0x1A, 0xA8, // "U" (U+0055)
  0x00, 0x56, 0x03, 0x01, 0x15, 0x1D, 0x12, 0x1B, 0x5A, // "V" (U+0056)
  0x00, 0x57, 0x03, 0x01, 0x1F, 0x1D, 0x1D, 0x1B, 0xFD, // "W" (U+0057)
  0x00, 0x58, 0xFD, 0x01, 0x13, 0x1D, 0x11, 0x1D, 0x26, // "X" (U+0058)
  0x00, 0x59, 0x03, 0x01, 0x13, 0x1D, 0x10, 0x1D, 0xD6, // "Y" (U+0059)
  0x00, 0x5A, 0xFE, 0x01, 0x11, 0x1D, 0x10, 0x1E, 0x5C, // "Z" (U+005A)
  0x00, 0x5B, 0xFF, 0xFA, 0x0E, 0x1D, 0x0B, 0x1E, 0xD3, // "[" (U+005B)
  0x00, 0x5C, 0x04, 0x01, 0x0A, 0x1D, 0x0E, 0x1F, 0x4F, // "\" (U+005C)
  0x00, 0x5D, 0xFD, 0xFA, 0x0C, 0x1D, 0x0B, 0x1F, 0xA1, // "]" (U+005D)
  0x00, 0x5E, 0x01, 0x0E, 0x11, 0x1E, 0x12, 0x20, 0x1B, // "^" (U+005E)
  0x00, 0x5F, 0xFC, 0xFB, 0x0A, 0xFD, 0x0D, 0x20, 0x76, // "_" (U+005F)
  0x00, 0x60, 0x46, 0x19, 0x0B, 0x1F, 0x0A, 0x20, 0x81, // "`" (U+0060)
  0x00, 0x61, 0x01, 0x01, 0x12, 0x16, 0x13, 0x20, 0x96, // "a" (U+0061)
  0x00, 0x62, 0x00, 0x01, 0x11, 0x1E, 0x13, 0x21, 0x21, // "b" (U+0062)
  0x00, 0x63, 0x01, 0x01, 0x0E, 0x16, 0x0E, 0x21, 0xCD, // "c" (U+0063)
  0x00, 0x64, 0x01, 0x01, 0x14, 0x1E, 0x13, 0x22, 0x2B, // "d" (U+0064)
  0x00, 0x65, 0x01, 0x01, 0x0F, 0x16, 0x11, 0x22, 0xD8, // "e" (U+0065)
  0x00, 0x66, 0xFB, 0xF8, 0x0E, 0x20, 0x0A, 0x23, 0x4A, // "f" (U+0066)
  0x00, 0x67, 0xFF, 0xF8, 0x12, 0x16, 0x13, 0x23, 0xF2, // "g" (U+0067)
  0x00, 0x68, 0x00, 0x01, 0x10, 0x1E, 0x12, 0x24, 0xAC, // "h" (U+0068)
  0x00, 0x69, 0x00, 0x01, 0x09, 0x1E, 0x08, 0x25, 0x4C, // "i" (U+0069)
  0x00, 0x6A, 0xFA, 0xF8, 0x09, 0x1E, 0x09, 0x25, 0x9C, // "j" (U+006A)
  0x00, 0x6B, 0x00, 0x01, 0x11, 0x1E, 0x10, 0x26, 0x1C, // "k" (U+006B)
  0x00, 0x6C, 0x00, 0x01, 0x09, 0x1E, 0x08, 0x26, 0xB9, // "l" (U+006C)
  0x00, 0x6D, 0x00, 0x01, 0x1A, 0x16, 0x1C, 0x27, 0x0F, // "m" (U+006D)
  0x00, 0x6E, 0x00, 0x01, 0x10, 0x16, 0x12, 0x27, 0xDA, // "n" (U+006E)
  0x00, 0x6F, 0x01, 0x01, 0x10, 0x16, 0x12, 0x28, 0x60, // "o" (U+006F)
  0x00, 0x70, 0xFE, 0xF8, 0x11, 0x16, 0x13, 0x28, 0xDC, // "p" (U+0070)
  0x00, 0x71, 0x01, 0xF8, 0x12, 0x16, 0x13, 0x29, 0x91, // "q" (U+0071)
  0x00, 0x72, 0x00, 0x01, 0x0D, 0x16, 0x0D, 0x2A, 0x3A, // "r" (U+0072)
  0x00, 0x73, 0xFF, 0x01, 0x0D, 0x16, 0x0E, 0x2A, 0x91, // "s" (U+0073)
  0x00, 0x74, 0x01, 0x01, 0x0B, 0x1B, 0x0B, 0x2A, 0xF2, // "t" (U+0074)
  0x00, 0x75, 0x01, 0x01, 0x11, 0x16, 0x13, 0x2B, 0x4C, // "u" (U+0075)
  0x00, 0x76, 0x02, 0x01, 0x10, 0x16, 0x0F, 0x2B, 0xD0, // "v" (U+0076)
  0x00, 0x77, 0x02, 0x01, 0x19, 0x16, 0x18, 0x2C, 0x48, // "w" (U+0077)
  0x00, 0x78, 0xFE, 0x01, 0x10, 0x16, 0x0F, 0x2D, 0x17, // "x" (U+0078)
  0x00, 0x79, 0xFC, 0xF8, 0x10, 0x16, 0x0F, 0x2D, 0x95, // "y" (U+0079)
  0x00, 0x7A, 0xFE, 0x01, 0x0D, 0x16, 0x0D, 0x2E, 0x37, // "z" (U+007A)
  0x00, 0x7B, 0x00, 0xFB, 0x0F, 0x1D, 0x0D, 0x2E, 0x8C, // "{" (U+007B)
  0x00, 0x7C, 0x47, 0xF8, 0x09, 0x20, 0x11, 0x2F, 0x14, // "|" (U+007C)
  0x00, 0x7D, 0xFD, 0xFB, 0x0C, 0x1D, 0x0D, 0x2F, 0x52, // "}" (U+007D)
  0x00, 0x7E, 0x01, 0x0D, 0x11, 0x11, 0x13, 0x2F, 0xD8, // "~" (U+007E)
  0x00, 0xA1, 0xFF, 0xFA, 0x09, 0x16, 0x0A, 0x2F, 0xF9, // "¡" (U+00A1)
  0x00, 0xA2, 0x03, 0x01, 0x10, 0x1D, 0x12, 0x30, 0x49, // "¢" (U+00A2)
  0x00, 0xA3, 0xFF, 0x01, 0x12, 0x1D, 0x12, 0x30, 0xBE, // "£" (U+00A3)
  0x00, 0xA4, 0x02, 0x06, 0x13, 0x17, 0x15, 0x31, 0x3E, // "¤" (U+00A4)
  0x00, 0xA5, 0x01, 0x01, 0x13, 0x1D, 0x11, 0x31, 0xBD, // "¥" (U+00A5)
  0x00, 0xA6, 0x07, 0xF8, 0x09, 0x1F, 0x11, 0x32, 0x53, // "¦" (U+00A6)
  0x00, 0xA7, 0x00, 0x02, 0x10, 0x1F, 0x0F, 0x32, 0x83, // "§" (U+00A7)
  0x00, 0xA8, 0x47, 0x1A, 0x11, 0x1D, 0x14, 0x33, 0x1E, // "¨" (U+00A8)
  0x00, 0xA9, 0x01, 0x01, 0x1F, 0x1E, 0x21, 0x33, 0x34, // "©" (U+00A9)
  0x00, 0xAA, 0x02, 0x11, 0x0D, 0x1E, 0x0C, 0x34, 0x54, // "ª" (U+00AA)
  0x00, 0xAB, 0x01, 0x03, 0x11, 0x13, 0x11, 0x34, 0xA4, // "«" (U+00AB)
  0x00, 0xAC, 0x02, 0x06, 0x11, 0x10, 0x13, 0x35, 0x0D, // "¬" (U+00AC)
  0x00, 0xAE, 0x01, 0x01, 0x1F, 0x1E, 0x21, 0x35, 0x32, // "®" (U+00AE)
  0x00, 0xAF, 0x03, 0x20, 0x14, 0x22, 0x10, 0x36, 0x66, // "¯" (U+00AF)
  0x00, 0xB0, 0x02, 0x13, 0x0D, 0x1E, 0x0F, 0x36, 0x73, // "°" (U+00B0)
  0x00, 0xB1, 0x02, 0x01, 0x11, 0x18, 0x13, 0x36, 0xAE, // "±" (U+00B1)
  0x00, 0xB2, 0x02, 0x12, 0x0D, 0x23, 0x0C, 0x36, 0xFD, // "²" (U+00B2)
  0x00, 0xB3, 0x02, 0x11, 0x0D, 0x22, 0x0C, 0x37, 0x3E, // "³" (U+00B3)
  0x00, 0xB4, 0x04, 0x19, 0x0C, 0x1F, 0x0A, 0x37, 0x8D, // "´" (U+00B4)
  0x00, 0xB5, 0xFE, 0xF8, 0x11, 0x16, 0x13, 0x37, 0xA5, // "µ" (U+00B5)
  0x00, 0xB6, 0x03, 0xFA, 0x12, 0x1E, 0x15, 0x38, 0x50, // "¶" (U+00B6)
  0x00, 0xB7, 0x42, 0x0D, 0x06, 0x11, 0x09, 0x39, 0x25, // "·" (U+00B7)
  0x00, 0xB8, 0xFC, 0xF7, 0x04, 0x00, 0x08, 0x39, 0x32, // "¸" (U+00B8)
  0x00, 0xB9, 0x05, 0x12, 0x0C, 0x22, 0x0C, 0x39, 0x54, // "¹" (U+00B9)
  0x00, 0xBA, 0x03, 0x11, 0x0D, 0x1E, 0x0C, 0x39, 0x8B, // "º" (U+00BA)
  0x00, 0xBB, 0x00, 0x03, 0x0F, 0x13, 0x11, 0x39, 0xD4, // "»" (U+00BB)
  0x00, 0xBC, 0x02, 0x00, 0x1A, 0x1D, 0x1B, 0x3A, 0x3E, // "¼" (U+00BC)
  0x00, 0xBD, 0x01, 0x01, 0x1B, 0x1D, 0x1D, 0x3B, 0x2C, // "½" (U+00BD)
  0x00, 0xBE, 0x01, 0x00, 0x1B, 0x1D, 0x1C, 0x3C, 0x12, // "¾" (U+00BE)
  0x00, 0xBF, 0xFE, 0xF9, 0x0B, 0x15, 0x0D, 0x3D, 0x15, // "¿" (U+00BF)
  0x00, 0xC0, 0xFD, 0x01, 0x0F, 0x26, 0x12, 0x3D, 0x80, // "À" (U+00C0)
  0x00, 0xC1, 0xFD, 0x01, 0x13, 0x26, 0x12, 0x3E, 0x3E, // "Á" (U+00C1)
  0x00, 0xC2, 0xFD, 0x01, 0x11, 0x26, 0x12, 0x3F, 0x06, // "Â" (U+00C2)
  0x00, 0xC3, 0xFD, 0x01, 0x14, 0x24, 0x12, 0x3F, 0xD3, // "Ã" (U+00C3)
  0x00, 0xC4, 0xFD, 0x01, 0x12, 0x24, 0x12, 0x40, 0xA3, // "Ä" (U+00C4)
  0x00, 0xC5, 0xFD, 0x01, 0x11, 0x27, 0x12, 0x41, 0x66, // "Å" (U+00C5)
  0x00, 0xC6, 0xFD, 0x01, 0x1A, 0x1D, 0x19, 0x42, 0x3B, // "Æ" (U+00C6)
  0x00, 0xC7, 0x01, 0xF7, 0x14, 0x1D, 0x12, 0x42, 0xFD, // "Ç" (U+00C7)
  0x00, 0xC8, 0x00, 0x01, 0x11, 0x26, 0x10, 0x43, 0xAF, // "È" (U+00C8)
  0x00, 0xC9, 0x00, 0x01, 0x12, 0x26, 0x10, 0x44, 0x31, // "É" (U+00C9)
  0x00, 0xCA, 0x00, 0x01, 0x11, 0x26, 0x10, 0x44, 0xBC, // "Ê" (U+00CA)
  0x00, 0xCB, 0x00, 0x01, 0x12, 0x24, 0x10, 0x45, 0x4A, // "Ë" (U+00CB)
  0x00, 0xCC, 0xFE, 0x01, 0x0D, 0x26, 0x0B, 0x45, 0xD5, // "Ì" (U+00CC)
  0x00, 0xCD, 0xFE, 0x01, 0x0F, 0x26, 0x0B, 0x46, 0x57, // "Í" (U+00CD)
  0x00, 0xCE, 0xFE, 0x01, 0x0E, 0x26, 0x0B, 0x46, 0xDE, // "Î" (U+00CE)
  0x00, 0xCF, 0xFE, 0x01, 0x0F, 0x24, 0x0B, 0x47, 0x6D, // "Ï" (U+00CF)
  0x00, 0xD0, 0x00, 0x01, 0x14, 0x1D, 0x15, 0x47, 0xF2, // "Ð" (U+00D0)
  0x00, 0xD1, 0x00, 0x01, 0x17, 0x24, 0x17, 0x48, 0xA7, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x01, 0x01, 0x15, 0x26, 0x17, 0x49, 0xA0, // "Ò" (U+00D2)
  0x00, 0xD3, 0x01, 0x01, 0x15, 0x26, 0x17, 0x4A, 0x75, // "Ó" (U+00D3)
  0x00, 0xD4, 0x01, 0x01, 0x15, 0x26, 0x17, 0x4B, 0x4D, // "Ô" (U+00D4)
  0x00, 0xD5, 0x01, 0x01, 0x16, 0x24, 0x17, 0x4C, 0x2D, // "Õ" (U+00D5)
  0x00, 0xD6, 0x01, 0x01, 0x15, 0x24, 0x17, 0x4D, 0x0B, // "Ö" (U+00D6)
  0x00, 0xD7, 0x02, 0x07, 0x11, 0x16, 0x13, 0x4D, 0xE0, // "×" (U+00D7)
  0x00, 0xD8, 0x00, 0xFF, 0x17, 0x1F, 0x17, 0x4E, 0x37, // "Ø" (U+00D8)
  0x00, 0xD9, 0x01, 0x01, 0x16, 0x26, 0x15, 0x4F, 0x2D, // "Ù" (U+00D9)
  0x00, 0xDA, 0x01, 0x01, 0x16, 0x26, 0x15, 0x4F, 0xFC, // "Ú" (U+00DA)
  0x00, 0xDB, 0x01, 0x01, 0x16, 0x26, 0x15, 0x50, 0xCE, // "Û" (U+00DB)
  0x00, 0xDC, 0x01, 0x01, 0x16, 0x24, 0x15, 0x51, 0xA9, // "Ü" (U+00DC)
  0x00, 0xDD, 0x03, 0x01, 0x13, 0x26, 0x10, 0x52, 0x78, // "Ý" (U+00DD)
  0x00, 0xDE, 0x00, 0x01, 0x11, 0x1D, 0x12, 0x53, 0x1C, // "Þ" (U+00DE)
  0x00, 0xDF, 0xFA, 0xF8, 0x12, 0x20, 0x13, 0x53, 0xA7, // "ß" (U+00DF)
  0x00, 0xE0, 0x01, 0x01, 0x12, 0x1F, 0x13, 0x54, 0xAA, // "à" (U+00E0)
  0x00, 0xE1, 0x01, 0x01, 0x12, 0x1F, 0x13, 0x55, 0x50, // "á" (U+00E1)
  0x00, 0xE2, 0x01, 0x01, 0x12, 0x1F, 0x13, 0x55, 0xF8, // "â" (U+00E2)
  0x00, 0xE3, 0x01, 0x01, 0x13, 0x1D, 0x13, 0x56, 0xAB, // "ã" (U+00E3)
  0x00, 0xE4, 0x01, 0x01, 0x12, 0x1D, 0x13, 0x57, 0x5A, // "ä" (U+00E4)
  0x00, 0xE5, 0x01, 0x01, 0x12, 0x20, 0x13, 0x58, 0x00, // "å" (U+00E5)
  0x00, 0xE6, 0x01, 0x01, 0x1A, 0x16, 0x1B, 0x58, 0xBD, // "æ" (U+00E6)
  0x00, 0xE7, 0x00, 0xF7, 0x0E, 0x16, 0x0E, 0x59, 0x86, // "ç" (U+00E7)
  0x00, 0xE8, 0x01, 0x01, 0x0F, 0x1F, 0x11, 0x5A, 0x0B, // "è" (U+00E8)
  0x00, 0xE9, 0x01, 0x01, 0x10, 0x1F, 0x11, 0x5A, 0x97, // "é" (U+00E9)
  0x00, 0xEA, 0x01, 0x01, 0x0F, 0x1F, 0x11, 0x5B, 0x27, // "ê" (U+00EA)
  0x00, 0xEB, 0x01, 0x01, 0x11, 0x1D, 0x11, 0x5B, 0xBF, // "ë" (U+00EB)
  0x00, 0xEC, 0x00, 0x01, 0x08, 0x1F, 0x08, 0x5C, 0x4D, // "ì" (U+00EC)
  0x00, 0xED, 0x00, 0x01, 0x0C, 0x1F, 0x08, 0x5C, 0xA5, // "í" (U+00ED)
  0x00, 0xEE, 0x00, 0x01, 0x0B, 0x1F, 0x08, 0x5D, 0x0E, // "î" (U+00EE)
  0x00, 0xEF, 0x00, 0x01, 0x0C, 0x1D, 0x08, 0x5D, 0x7A, // "ï" (U+00EF)
  0x00, 0xF0, 0x00, 0x01, 0x11, 0x20, 0x12, 0x5D, 0xE2, // "ð" (U+00F0)
  0x00, 0xF1, 0x00, 0x01, 0x13, 0x1D, 0x12, 0x5E, 0xA0, // "ñ" (U+00F1)
  0x00, 0xF2, 0x01, 0x01, 0x10, 0x1F, 0x12, 0x5F, 0x4C, // "ò" (U+00F2)
  0x00, 0xF3, 0x01, 0x01, 0x11, 0x1F, 0x12, 0x5F, 0xE2, // "ó" (U+00F3)
  0x00, 0xF4, 0x01, 0x01, 0x10, 0x1F, 0x12, 0x60, 0x7D, // "ô" (U+00F4)
  0x00, 0xF5, 0x01, 0x01, 0x12, 0x1D, 0x12, 0x61, 0x20, // "õ" (U+00F5)
  0x00, 0xF6, 0x01, 0x01, 0x11, 0x1D, 0x12, 0x61, 0xC3, // "ö" (U+00F6)
  0x00, 0xF7, 0x02, 0x06, 0x11, 0x18, 0x13, 0x62, 0x5C, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0xFF, 0x12, 0x18, 0x12, 0x62, 0x8C, // "ø" (U+00F8)
  0x00, 0xF9, 0x01, 0x01, 0x11, 0x1F, 0x13, 0x63, 0x36, // "ù" (U+00F9)
  0x00, 0xFA, 0x01, 0x01, 0x11, 0x1F, 0x13, 0x63, 0xD4, // "ú" (U+00FA)
  0x00, 0xFB, 0x01, 0x01, 0x11, 0x1F, 0x13, 0x64, 0x75, // "û" (U+00FB)
  0x00, 0xFC, 0x01, 0x01, 0x11, 0x1D, 0x13, 0x65, 0x20, // "ü" (U+00FC)
  0x00, 0xFD, 0xFC, 0xF8, 0x10, 0x1F, 0x0F, 0x65, 0xBF, // "ý" (U+00FD)
  0x00, 0xFE, 0xFE, 0xF8, 0x11, 0x1E, 0x13, 0x66, 0x81, // "þ" (U+00FE)
  0x00, 0xFF, 0xFC, 0xF8, 0x10, 0x1D, 0x0F, 0x67, 0x54, // "ÿ" (U+00FF)
  0x01, 0x00, 0xFD, 0x01, 0x11, 0x23, 0x12, 0x68, 0x13, // "Ā" (U+0100)
  0x01, 0x01, 0x01, 0x01, 0x12, 0x1C, 0x13, 0x68, 0xC5, // "ā" (U+0101)
  0x01, 0x02, 0xFD, 0x01, 0x12, 0x25, 0x12, 0x69, 0x5D, // "Ă" (U+0102)
  0x01, 0x03, 0x01, 0x01, 0x12, 0x1E, 0x13, 0x6A, 0x28, // "ă" (U+0103)
  0x01, 0x04, 0xFD, 0xF8, 0x0F, 0x1D, 0x12, 0x6A, 0xD7, // "Ą" (U+0104)
  0x01, 0x05, 0x01, 0xF8, 0x12, 0x16, 0x13, 0x6B, 0x9D, // "ą" (U+0105)
  0x01, 0x06, 0x01, 0x01, 0x14, 0x26, 0x12, 0x6C, 0x4B, // "Ć" (U+0106)
  0x01, 0x07, 0x01, 0x01, 0x0F, 0x1F, 0x0E, 0x6C, 0xF1, // "ć" (U+0107)
  0x01, 0x08, 0x01, 0x01, 0x14, 0x26, 0x12, 0x6D, 0x6C, // "Ĉ" (U+0108)
  0x01, 0x09, 0x01, 0x01, 0x0F, 0x1F, 0x0E, 0x6E, 0x1C, // "ĉ" (U+0109)
  0x01, 0x0A, 0x01, 0x01, 0x14, 0x24, 0x12, 0x6E, 0xA0, // "Ċ" (U+010A)
  0x01, 0x0B, 0x01, 0x01, 0x0E, 0x1D, 0x0E, 0x6F, 0x3A, // "ċ" (U+010B)
  0x01, 0x0C, 0x01, 0x01, 0x16, 0x26, 0x12, 0x6F, 0xA9, // "Č" (U+010C)
  0x01, 0x0D, 0x01, 0x01, 0x11, 0x1F, 0x0E, 0x70, 0x5D, // "č" (U+010D)
  0x01, 0x0E, 0x00, 0x01, 0x14, 0x26, 0x15, 0x70, 0xE3, // "Ď" (U+010E)
  0x01, 0x0F, 0x01, 0x01, 0x1A, 0x1E, 0x15, 0x71, 0xBE, // "ď" (U+010F)
  0x01, 0x10, 0x00, 0x01, 0x14, 0x1D, 0x15, 0x72, 0x88, // "Đ" (U+0110)
  0x01, 0x11, 0x01, 0x01, 0x15, 0x1E, 0x13, 0x73, 0x3D, // "đ" (U+0111)
  0x01, 0x12, 0x00, 0x01, 0x11, 0x23, 0x10, 0x73, 0xEF, // "Ē" (U+0112)
  0x01, 0x13, 0x01, 0x01, 0x10, 0x1C, 0x11, 0x74, 0x63, // "ē" (U+0113)
  0x01, 0x14, 0x00, 0x01, 0x12, 0x25, 0x10, 0x74, 0xE2, // "Ĕ" (U+0114)
  0x01, 0x15, 0x01, 0x01, 0x11, 0x1E, 0x11, 0x75, 0x75, // "ĕ" (U+0115)
  0x01, 0x16, 0x00, 0x01, 0x11, 0x23, 0x10, 0x76, 0x0B, // "Ė" (U+0116)
  0x01, 0x17, 0x01, 0x01, 0x0F, 0x1D, 0x11, 0x76, 0x83, // "ė" (U+0117)
  0x01, 0x18, 0x00, 0xF8, 0x11, 0x1D, 0x10, 0x77, 0x06, // "Ę" (U+0118)
  0x01, 0x19, 0x01, 0xF9, 0x0F, 0x16, 0x11, 0x77, 0x90, // "ę" (U+0119)
  0x01, 0x1A, 0x00, 0x01, 0x13, 0x26, 0x10, 0x78, 0x21, // "Ě" (U+011A)
  0x01, 0x1B, 0x01, 0x01, 0x12, 0x1F, 0x11, 0x78, 0xBE, // "ě" (U+011B)
  0x01, 0x1C, 0x01, 0x01, 0x16, 0x26, 0x16, 0x79, 0x5B, // "Ĝ" (U+011C)
  0x01, 0x1D, 0xFF, 0xF8, 0x12, 0x1F, 0x13, 0x7A, 0x2E, // "ĝ" (U+011D)
  0x01, 0x1E, 0x01, 0x01, 0x16, 0x25, 0x16, 0x7B, 0x11, // "Ğ" (U+011E)
  0x01, 0x1F, 0xFF, 0xF8, 0x12, 0x1E, 0x13, 0x7B, 0xE0, // "ğ" (U+011F)
  0x01, 0x20, 0x01, 0x01, 0x16, 0x24, 0x16, 0x7C, 0xBF, // "Ġ" (U+0120)
  0x01, 0x21, 0xFF, 0xF8, 0x12, 0x1D, 0x13, 0x7D, 0x7C, // "ġ" (U+0121)
  0x01, 0x22, 0x01, 0xF8, 0x16, 0x1D, 0x16, 0x7E, 0x49, // "Ģ" (U+0122)
  0x01, 0x23, 0xFF, 0xF8, 0x12, 0x20, 0x13, 0x7F, 0x13, // "ģ" (U+0123)
  0x01, 0x24, 0x00, 0x01, 0x16, 0x26, 0x16, 0x7F, 0xEC, // "Ĥ" (U+0124)
  0x01, 0x25, 0x00, 0x01, 0x10, 0x28, 0x12, 0x80, 0xCA, // "ĥ" (U+0125)
  0x01, 0x26, 0x00, 0x01, 0x17, 0x1D, 0x16, 0x81, 0x91, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x10, 0x1E, 0x12, 0x82, 0x43, // "ħ" (U+0127)
  0x01, 0x28, 0xFE, 0x01, 0x10, 0x24, 0x0B, 0x82, 0xEB, // "Ĩ" (U+0128)
  0x01, 0x29, 0x00, 0x01, 0x0E, 0x1D, 0x08, 0x83, 0x80, // "ĩ" (U+0129)
  0x01, 0x2A, 0xFE, 0x01, 0x0E, 0x23, 0x0B, 0x83, 0xF0, // "Ī" (U+012A)
  0x01, 0x2B, 0x00, 0x01, 0x0B, 0x1C, 0x08, 0x84, 0x65, // "ī" (U+012B)
  0x01, 0x2C, 0xFE, 0x01, 0x0F, 0x25, 0x0B, 0x84, 0xBB, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x00, 0x01, 0x0C, 0x1E, 0x08, 0x85, 0x48, // "ĭ" (U+012D)
  0x01, 0x2E, 0xFE, 0xF8, 0x0D, 0x1D, 0x0B, 0x85, 0xB7, // "Į" (U+012E)
  0x01, 0x2F, 0xFD, 0xF8, 0x09, 0x1E, 0x08, 0x86, 0x42, // "į" (U+012F)
  0x01, 0x30, 0xFE, 0x01, 0x0D, 0x24, 0x0B, 0x86, 0xC1, // "İ" (U+0130)
  0x01, 0x31, 0x00, 0x01, 0x07, 0x16, 0x08, 0x87, 0x3A, // "ı" (U+0131)
  0x01, 0x32, 0xFE, 0xFA, 0x14, 0x1D, 0x14, 0x87, 0x7C, // "Ĳ" (U+0132)
  0x01, 0x33, 0x00, 0xF8, 0x11, 0x1E, 0x11, 0x88, 0x58, // "ĳ" (U+0133)
  0x01, 0x34, 0xFA, 0xFA, 0x0D, 0x26, 0x09, 0x89, 0x19, // "Ĵ" (U+0134)
  0x01, 0x35, 0xFA, 0xF8, 0x0B, 0x1F, 0x08, 0x89, 0xD2, // "ĵ" (U+0135)
  0x01, 0x36, 0x00, 0xF8, 0x15, 0x1D, 0x12, 0x8A, 0x68, // "Ķ" (U+0136)
  0x01, 0x37, 0x00, 0xF8, 0x11, 0x1E, 0x10, 0x8B, 0x3A, // "ķ" (U+0137)
  0x01, 0x38, 0x00, 0x01, 0x11, 0x16, 0x10, 0x8B, 0xF4, // "ĸ" (U+0138)
  0x01, 0x39, 0x00, 0x01, 0x10, 0x26, 0x0F, 0x8C, 0x77, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x00, 0x01, 0x0E, 0x28, 0x08, 0x8C, 0xF6, // "ĺ" (U+013A)
  0x01, 0x3B, 0x00, 0xF8, 0x0C, 0x1D, 0x0F, 0x8D, 0x78, // "Ļ" (U+013B)
  0x01, 0x3C, 0xFE, 0xF8, 0x09, 0x1E, 0x08, 0x8D, 0xF6, // "ļ" (U+013C)
  0x01, 0x3D, 0x00, 0x01, 0x11, 0x1D, 0x0F, 0x8E, 0x72, // "Ľ" (U+013D)
  0x01, 0x3E, 0x00, 0x01, 0x0F, 0x1E, 0x0B, 0x8E, 0xE6, // "ľ" (U+013E)
  0x01, 0x3F, 0x00, 0x01, 0x0D, 0x1D, 0x0F, 0x8F, 0x5C, // "Ŀ" (U+013F)
  0x01, 0x40, 0x00, 0x01, 0x0C, 0x1E, 0x0C, 0x8F, 0xC9, // "ŀ" (U+0140)
  0x01, 0x41, 0xFF, 0x01, 0x0C, 0x1D, 0x0F, 0x90, 0x39, // "Ł" (U+0141)
  0x01, 0x42, 0x00, 0x01, 0x0A, 0x1E, 0x09, 0x90, 0xA9, // "ł" (U+0142)
  0x01, 0x43, 0x00, 0x01, 0x17, 0x26, 0x17, 0x91, 0x09, // "Ń" (U+0143)
  0x01, 0x44, 0x00, 0x01, 0x11, 0x1F, 0x12, 0x91, 0xFD, // "ń" (U+0144)
  0x01, 0x45, 0x00, 0xF8, 0x17, 0x1D, 0x17, 0x92, 0xA0, // "Ņ" (U+0145)
  0x01, 0x46, 0x00, 0xF8, 0x10, 0x16, 0x12, 0x93, 0x93, // "ņ" (U+0146)
  0x01, 0x47, 0x00, 0x01, 0x17, 0x26, 0x17, 0x94, 0x36, // "Ň" (U+0147)
  0x01, 0x48, 0x00, 0x01, 0x12, 0x1F, 0x12, 0x95, 0x34, // "ň" (U+0148)
  0x01, 0x49, 0x01, 0x01, 0x12, 0x1D, 0x15, 0x95, 0xE3, // "ŉ" (U+0149)
  0x01, 0x4A, 0x00, 0xF9, 0x17, 0x1D, 0x17, 0x96, 0x88, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x00, 0xF8, 0x10, 0x16, 0x12, 0x97, 0x83, // "ŋ" (U+014B)
  0x01, 0x4C, 0x01, 0x01, 0x15, 0x23, 0x17, 0x98, 0x2D, // "Ō" (U+014C)
  0x01, 0x4D, 0x01, 0x01, 0x10, 0x1C, 0x12, 0x98, 0xF3, // "ō" (U+014D)
  0x01, 0x4E, 0x01, 0x01, 0x15, 0x25, 0x17, 0x99, 0x7C, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x01, 0x01, 0x11, 0x1E, 0x12, 0x9A, 0x58, // "ŏ" (U+014F)
  0x01, 0x50, 0x01, 0x01, 0x18, 0x25, 0x17, 0x9A, 0xF9, // "Ő" (U+0150)
  0x01, 0x51, 0x01, 0x01, 0x15, 0x1E, 0x12, 0x9B, 0xDF, // "ő" (U+0151)
  0x01, 0x52, 0x01, 0x01, 0x1C, 0x1D, 0x1B, 0x9C, 0x8C, // "Œ" (U+0152)
  0x01, 0x53, 0x01, 0x01, 0x1B, 0x16, 0x1C, 0x9D, 0x49, // "œ" (U+0153)
  0x01, 0x54, 0x00, 0x01, 0x13, 0x26, 0x13, 0x9E, 0x11, // "Ŕ" (U+0154)
  0x01, 0x55, 0x00, 0x01, 0x0F, 0x1F, 0x0D, 0x9E, 0xD8, // "ŕ" (U+0155)
  0x01, 0x56, 0x00, 0xF8, 0x12, 0x1D, 0x13, 0x9F, 0x4C, // "Ŗ" (U+0156)
  0x01, 0x57, 0xFF, 0xF8, 0x0D, 0x16, 0x0D, 0xA0, 0x10, // "ŗ" (U+0157)
  0x01, 0x58, 0x00, 0x01, 0x13, 0x26, 0x13, 0xA0, 0x83, // "Ř" (U+0158)
  0x01, 0x59, 0x00, 0x01, 0x10, 0x1F, 0x0D, 0xA1, 0x54, // "ř" (U+0159)
  0x01, 0x5A, 0xFF, 0x01, 0x12, 0x26, 0x11, 0xA1, 0xD3, // "Ś" (U+015A)
  0x01, 0x5B, 0xFF, 0x01, 0x0F, 0x1F, 0x0E, 0xA2, 0x7B, // "ś" (U+015B)
  0x01, 0x5C, 0xFF, 0x01, 0x11, 0x26, 0x11, 0xA2, 0xFA, // "Ŝ" (U+015C)
  0x01, 0x5D, 0xFF, 0x01, 0x0E, 0x1F, 0x0E, 0xA3, 0xA4, // "ŝ" (U+015D)
  0x01, 0x5E, 0xFF, 0xF7, 0x11, 0x1D, 0x11, 0xA4, 0x2C, // "Ş" (U+015E)
  0x01, 0x5F, 0xFF, 0xF7, 0x0D, 0x16, 0x0E, 0xA4, 0xD9, // "ş" (U+015F)
  0x01, 0x60, 0xFF, 0x01, 0x12, 0x26, 0x11, 0xA5, 0x61, // "Š" (U+0160)
  0x01, 0x61, 0xFF, 0x01, 0x10, 0x1F, 0x0E, 0xA6, 0x13, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xF7, 0x12, 0x1D, 0x10, 0xA6, 0x9E, // "Ţ" (U+0162)
  0x01, 0x63, 0xFF, 0xF7, 0x0B, 0x1B, 0x0B, 0xA7, 0x38, // "ţ" (U+0163)
  0x01, 0x64, 0x03, 0x01, 0x12, 0x26, 0x10, 0xA7, 0xC1, // "Ť" (U+0164)
  0x01, 0x65, 0x01, 0x01, 0x0F, 0x1E, 0x0B, 0xA8, 0x4E, // "ť" (U+0165)
  0x01, 0x66, 0x02, 0x01, 0x12, 0x1D, 0x10, 0xA8, 0xC3, // "Ŧ" (U+0166)
  0x01, 0x67, 0x00, 0x01, 0x0B, 0x1B, 0x0B, 0xA9, 0x30, // "ŧ" (U+0167)
  0x01, 0x68, 0x01, 0x01, 0x16, 0x24, 0x15, 0xA9, 0x94, // "Ũ" (U+0168)
  0x01, 0x69, 0x01, 0x01, 0x13, 0x1D, 0x13, 0xAA, 0x6C, // "ũ" (U+0169)
  0x01, 0x6A, 0x01, 0x01, 0x16, 0x23, 0x15, 0xAB, 0x14, // "Ū" (U+016A)
  0x01, 0x6B, 0x01, 0x01, 0x11, 0x1C, 0x13, 0xAB, 0xD4, // "ū" (U+016B)
  0x01, 0x6C, 0x01, 0x01, 0x16, 0x25, 0x15, 0xAC, 0x64, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x01, 0x01, 0x11, 0x1E, 0x13, 0xAD, 0x3B, // "ŭ" (U+016D)
  0x01, 0x6E, 0x01, 0x01, 0x16, 0x27, 0x15, 0xAD, 0xE2, // "Ů" (U+016E)
  0x01, 0x6F, 0x01, 0x01, 0x11, 0x20, 0x13, 0xAE, 0xC7, // "ů" (U+016F)
  0x01, 0x70, 0x01, 0x01, 0x18, 0x25, 0x15, 0xAF, 0x7D, // "Ű" (U+0170)
  0x01, 0x71, 0x01, 0x01, 0x15, 0x1E, 0x13, 0xB0, 0x5D, // "ű" (U+0171)
  0x01, 0x72, 0x01, 0xF8, 0x16, 0x1D, 0x15, 0xB1, 0x0E, // "Ų" (U+0172)
  0x01, 0x73, 0x01, 0xF8, 0x11, 0x16, 0x13, 0xB1, 0xE7, // "ų" (U+0173)
  0x01, 0x74, 0x03, 0x01, 0x1F, 0x26, 0x1D, 0xB2, 0x8E, // "Ŵ" (U+0174)
  0x01, 0x75, 0x02, 0x01, 0x19, 0x1F, 0x18, 0xB3, 0xE4, // "ŵ" (U+0175)
  0x01, 0x76, 0x03, 0x01, 0x13, 0x26, 0x10, 0xB4, 0xDE, // "Ŷ" (U+0176)
  0x01, 0x77, 0xFC, 0xF8, 0x10, 0x1F, 0x0F, 0xB5, 0x8C, // "ŷ" (U+0177)
  0x01, 0x78, 0x03, 0x01, 0x13, 0x24, 0x10, 0xB6, 0x57, // "Ÿ" (U+0178)
  0x01, 0x79, 0xFE, 0x01, 0x11, 0x26, 0x10, 0xB6, 0xF9, // "Ź" (U+0179)
  0x01, 0x7A, 0xFE, 0x01, 0x0F, 0x1F, 0x0D, 0xB7, 0x8F, // "ź" (U+017A)
  0x01, 0x7B, 0xFE, 0x01, 0x11, 0x24, 0x10, 0xB8, 0x01, // "Ż" (U+017B)
  0x01, 0x7C, 0xFE, 0x01, 0x0D, 0x1D, 0x0D, 0xB8, 0x8B, // "ż" (U+017C)
  0x01, 0x7D, 0xFE, 0x01, 0x12, 0x26, 0x10, 0xB8, 0xF1, // "Ž" (U+017D)
  0x01, 0x7E, 0xFE, 0x01, 0x0F, 0x1F, 0x0D, 0xB9, 0x96, // "ž" (U+017E)
  0x01, 0x7F, 0xFA, 0xF8, 0x0E, 0x20, 0x09, 0xBA, 0x13, // "ſ" (U+017F)
  0x03, 0xA9, 0xFE, 0x01, 0x15, 0x1D, 0x17, 0xBA, 0xB9, // "Ω" (U+03A9)
  0x03, 0xBC, 0xFE, 0xF8, 0x11, 0x16, 0x13, 0xBB, 0x7F, // "μ" (U+03BC)
  0x03, 0xC0, 0x01, 0x01, 0x14, 0x16, 0x13, 0xBC, 0x2A, // "π" (U+03C0)
  0x20, 0x13, 0x01, 0x0A, 0x11, 0x0C, 0x12, 0xBC, 0xAA, // "–" (U+2013)
  0x20, 0x14, 0x01, 0x0A, 0x23, 0x0C, 0x25, 0xBC, 0xB5, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x01, 0x13, 0x1D, 0x12, 0xBC, 0xC3, // "€" (U+20AC)
  0x20, 0xBF, 0x00, 0xFD, 0x11, 0x21, 0x12, 0xBD, 0x4D, // "₿" (U+20BF)
  0x20, 0x18, 0x02, 0x14, 0x09, 0x1D, 0x07, 0xBE, 0x22, // "‘" (U+2018)
  0x20, 0x19, 0x02, 0x14, 0x09, 0x1D, 0x07, 0xBE, 0x41, // "’" (U+2019)
  0x20, 0x1A, 0xFE, 0xFC, 0x05, 0x05, 0x09, 0xBE, 0x60, // "‚" (U+201A)
  0x20, 0x1B, 0x43, 0x14, 0x07, 0x1D, 0x07, 0xBE, 0x7E, // "‛" (U+201B)
  0x20, 0x1C, 0x02, 0x14, 0x0F, 0x1D, 0x0D, 0xBE, 0x97, // "“" (U+201C)
  0x20, 0x1D, 0x02, 0x14, 0x0F, 0x1D, 0x0D, 0xBE, 0xD3, // "”" (U+201D)
  0x20, 0x1E, 0xFD, 0xFC, 0x0B, 0x05, 0x0E, 0xBF, 0x11, // "„" (U+201E)
  0x20, 0x1F, 0x44, 0x14, 0x0D, 0x1D, 0x0D, 0xBF, 0x51, // "‟" (U+201F)
  0x20, 0x20, 0x03, 0x01, 0x10, 0x1E, 0x11, 0xBF, 0x83, // "†" (U+2020)
  0x20, 0x21, 0x01, 0x01, 0x11, 0x1E, 0x11, 0xBF, 0xF4, // "‡" (U+2021)
  0x20, 0x22, 0x03, 0x0A, 0x0C, 0x14, 0x0E, 0xC0, 0x74, // "•" (U+2022)
  0x20, 0x26, 0x00, 0x01, 0x16, 0x05, 0x1A, 0xC0, 0x99, // "…" (U+2026)
  0x20, 0x30, 0x02, 0x01, 0x24, 0x1D, 0x26, 0xC0, 0xC9, // "‰" (U+2030)
  0x20, 0x39, 0x01, 0x03, 0x09, 0x13, 0x0A, 0xC2, 0x40, // "‹" (U+2039)
  0x20, 0x3A, 0x00, 0x03, 0x08, 0x13, 0x0A, 0xC2, 0x74, // "›" (U+203A)
  0x20, 0x44, 0xF6, 0x01, 0x0E, 0x1D, 0x05, 0xC2, 0xA9, // "⁄" (U+2044)
  0x21, 0x22, 0x00, 0x10, 0x18, 0x1D, 0x1B, 0xC3, 0x25, // "™" (U+2122)
  0x21, 0x52, 0x02, 0x00, 0x25, 0x1D, 0x26, 0xC3, 0xBF, // "⅒" (U+2152)
  0xFB, 0x01, 0xFB, 0xF8, 0x13, 0x20, 0x13, 0xC5, 0x08, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0xFB, 0xF8, 0x13, 0x20, 0x13, 0xC5, 0xF6, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x02, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0x61, 0x02, // "a (U+0022 U+0061)
  0x00, 0x22, 0x00, 0x63, 0x02, // "c (U+0022 U+0063)
  0x00, 0x22, 0x00, 0x64, 0x02, // "d (U+0022 U+0064)
  0x00, 0x22, 0x00, 0x65, 0x02, // "e (U+0022 U+0065)
  0x00, 0x22, 0x00, 0x67, 0x01, // "g (U+0022 U+0067)
  0x00, 0x22, 0x00, 0x6D, 0x01, // "m (U+0022 U+006D)
  0x00, 0x22, 0x00, 0x6E, 0x01, // "n (U+0022 U+006E)
  0x00, 0x22, 0x00, 0x6F, 0x02, // "o (U+0022 U+006F)
  0x00, 0x22, 0x00, 0x70, 0x01, // "p (U+0022 U+0070)
  0x00, 0x22, 0x00, 0x71, 0x02, // "q (U+0022 U+0071)
  0x00, 0x22, 0x00, 0x72, 0x01, // "r (U+0022 U+0072)
  0x00, 0x22, 0x00, 0x73, 0x01, // "s (U+0022 U+0073)
  0x00, 0x22, 0x00, 0x75, 0x01, // "u (U+0022 U+0075)
  0x00, 0x22, 0x00, 0xC0, 0x02, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x02, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x02, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x02, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x02, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x02, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xE0, 0x02, // "à (U+0022 U+00E0)
  0x00, 0x22, 0x00, 0xE1, 0x02, // "á (U+0022 U+00E1)
  0x00, 0x22, 0x00, 0xE2, 0x02, // "â (U+0022 U+00E2)
  0x00, 0x22, 0x00, 0xE3, 0x02, // "ã (U+0022 U+00E3)
  0x00, 0x22, 0x00, 0xE4, 0x02, // "ä (U+0022 U+00E4)
  0x00, 0x22, 0x00, 0xE5, 0x02, // "å (U+0022 U+00E5)
  0x00, 0x22, 0x00, 0xE6, 0x02, // "æ (U+0022 U+00E6)
  0x00, 0x22, 0x00, 0xE7, 0x02, // "ç (U+0022 U+00E7)
  0x00, 0x22, 0x00, 0xE8, 0x02, // "è (U+0022 U+00E8)
  0x00, 0x22, 0x00, 0xE9, 0x02, // "é (U+0022 U+00E9)
  0x00, 0x22, 0x00, 0xEA, 0x02, // "ê (U+0022 U+00EA)
  0x00, 0x22, 0x00, 0xEB, 0x02, // "ë (U+0022 U+00EB)
  0x00, 0x22, 0x00, 0xF1, 0x01, // "ñ (U+0022 U+00F1)
  0x00, 0x22, 0x00, 0xF2, 0x02, // "ò (U+0022 U+00F2)
  0x00, 0x22, 0x00, 0xF3, 0x02, // "ó (U+0022 U+00F3)
  0x00, 0x22, 0x00, 0xF4, 0x02, // "ô (U+0022 U+00F4)
  0x00, 0x22, 0x00, 0xF5, 0x02, // "õ (U+0022 U+00F5)
  0x00, 0x22, 0x00, 0xF6, 0x02, // "ö (U+0022 U+00F6)
  0x00, 0x22, 0x00, 0xF8, 0x02, // "ø (U+0022 U+00F8)
  0x00, 0x22, 0x00, 0xF9, 0x01, // "ù (U+0022 U+00F9)
  0x00, 0x22, 0x00, 0xFA, 0x01, // "ú (U+0022 U+00FA)
  0x00, 0x22, 0x00, 0xFB, 0x01, // "û (U+0022 U+00FB)
  0x00, 0x22, 0x00, 0xFC, 0x01, // "ü (U+0022 U+00FC)
  0x00, 0x22, 0x01, 0x00, 0x02, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x01, 0x02, // "ā (U+0022 U+0101)
  0x00, 0x22, 0x01, 0x02, 0x02, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x03, 0x02, // "ă (U+0022 U+0103)
  0x00, 0x22, 0x01, 0x04, 0x02, // "Ą (U+0022 U+0104)
  0x00, 0x22, 0x01, 0x05, 0x02, // "ą (U+0022 U+0105)
  0x00, 0x22, 0x01, 0x07, 0x02, // "ć (U+0022 U+0107)
  0x00, 0x22, 0x01, 0x09, 0x02, // "ĉ (U+0022 U+0109)
  0x00, 0x22, 0x01, 0x0B, 0x02, // "ċ (U+0022 U+010B)
  0x00, 0x22, 0x01, 0x0D, 0x02, // "č (U+0022 U+010D)
  0x00, 0x22, 0x01, 0x0F, 0x02, // "ď (U+0022 U+010F)
  0x00, 0x22, 0x01, 0x11, 0x02, // "đ (U+0022 U+0111)
  0x00, 0x22, 0x01, 0x13, 0x02, // "ē (U+0022 U+0113)
  0x00, 0x22, 0x01, 0x15, 0x02, // "ĕ (U+0022 U+0115)
  0x00, 0x22, 0x01, 0x17, 0x02, // "ė (U+0022 U+0117)
  0x00, 0x22, 0x01, 0x19, 0x02, // "ę (U+0022 U+0119)
  0x00, 0x22, 0x01, 0x1B, 0x02, // "ě (U+0022 U+011B)
  0x00, 0x22, 0x01, 0x1D, 0x01, // "ĝ (U+0022 U+011D)
  0x00, 0x22, 0x01, 0x1F, 0x01, // "ğ (U+0022 U+011F)
  0x00, 0x22, 0x01, 0x21, 0x01, // "ġ (U+0022 U+0121)
  0x00, 0x22, 0x01, 0x23, 0x01, // "ģ (U+0022 U+0123)
  0x00, 0x22, 0x01, 0x38, 0x01, // "ĸ (U+0022 U+0138)
  0x00, 0x22, 0x01, 0x44, 0x01, // "ń (U+0022 U+0144)
  0x00, 0x22, 0x01, 0x46, 0x01, // "ņ (U+0022 U+0146)
  0x00, 0x22, 0x01, 0x48, 0x01, // "ň (U+0022 U+0148)
  0x00, 0x22, 0x01, 0x4B, 0x01, // "ŋ (U+0022 U+014B)
  0x00, 0x22, 0x01, 0x4D, 0x02, // "ō (U+0022 U+014D)
  0x00, 0x22, 0x01, 0x4F, 0x02, // "ŏ (U+0022 U+014F)
  0x00, 0x22, 0x01, 0x51, 0x02, // "ő (U+0022 U+0151)
  0x00, 0x22, 0x01, 0x53, 0x02, // "œ (U+0022 U+0153)
  0x00, 0x22, 0x01, 0x55, 0x01, // "ŕ (U+0022 U+0155)
  0x00, 0x22, 0x01, 0x57, 0x01, // "ŗ (U+0022 U+0157)
  0x00, 0x22, 0x01, 0x5B, 0x01, // "ś (U+0022 U+015B)
  0x00, 0x22, 0x01, 0x5D, 0x01, // "ŝ (U+0022 U+015D)
  0x00, 0x22, 0x01, 0x5F, 0x01, // "ş (U+0022 U+015F)
  0x00, 0x22, 0x01, 0x61, 0x01, // "š (U+0022 U+0161)
  0x00, 0x22, 0x01, 0x69, 0x01, // "ũ (U+0022 U+0169)
  0x00, 0x22, 0x01, 0x6B, 0x01, // "ū (U+0022 U+016B)
  0x00, 0x22, 0x01, 0x6D, 0x01, // "ŭ (U+0022 U+016D)
  0x00, 0x22, 0x01, 0x6F, 0x01, // "ů (U+0022 U+016F)
  0x00, 0x22, 0x01, 0x71, 0x01, // "ű (U+0022 U+0171)
  0x00, 0x22, 0x01, 0x73, 0x01, // "ų (U+0022 U+0173)
  0x00, 0x26, 0x00, 0x54, 0x02, // &T (U+0026 U+0054)
  0x00, 0x26, 0x00, 0x56, 0x01, // &V (U+0026 U+0056)
  0x00, 0x26, 0x00, 0x57, 0x01, // &W (U+0026 U+0057)
  0x00, 0x26, 0x00, 0x59, 0x02, // &Y (U+0026 U+0059)
  0x00, 0x26, 0x00, 0xDD, 0x02, // &Ý (U+0026 U+00DD)
  0x00, 0x26, 0x01, 0x62, 0x02, // &Ţ (U+0026 U+0162)
  0x00, 0x26, 0x01, 0x64, 0x02, // &Ť (U+0026 U+0164)
  0x00, 0x26, 0x01, 0x66, 0x02, // &Ŧ (U+0026 U+0166)
  0x00, 0x26, 0x01, 0x74, 0x01, // &Ŵ (U+0026 U+0174)
  0x00, 0x26, 0x01, 0x76, 0x02, // &Ŷ (U+0026 U+0176)
  0x00, 0x26, 0x01, 0x78, 0x02, // &Ÿ (U+0026 U+0178)
  0x00, 0x27, 0x00, 0x41, 0x02, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0x61, 0x02, // 'a (U+0027 U+0061)
  0x00, 0x27, 0x00, 0x63, 0x02, // 'c (U+0027 U+0063)
  0x00, 0x27, 0x00, 0x64, 0x02, // 'd (U+0027 U+0064)
  0x00, 0x27, 0x00, 0x65, 0x02, // 'e (U+0027 U+0065)
  0x00, 0x27, 0x00, 0x67, 0x01, // 'g (U+0027 U+0067)
  0x00, 0x27, 0x00, 0x6D, 0x01, // 'm (U+0027 U+006D)
  0x00, 0x27, 0x00, 0x6E, 0x01, // 'n (U+0027 U+006E)
  0x00, 0x27, 0x00, 0x6F, 0x02, // 'o (U+0027 U+006F)
  0x00, 0x27, 0x00, 0x70, 0x01, // 'p (U+0027 U+0070)
  0x00, 0x27, 0x00, 0x71, 0x02, // 'q (U+0027 U+0071)
  0x00, 0x27, 0x00, 0x72, 0x01, // 'r (U+0027 U+0072)
  0x00, 0x27, 0x00, 0x73, 0x01, // 's (U+0027 U+0073)
  0x00, 0x27, 0x00, 0x75, 0x01, // 'u (U+0027 U+0075)
  0x00, 0x27, 0x00, 0xC0, 0x02, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x02, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x02, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x02, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x02, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x02, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xE0, 0x02, // 'à (U+0027 U+00E0)
  0x00, 0x27, 0x00, 0xE1, 0x02, // 'á (U+0027 U+00E1)
  0x00, 0x27, 0x00, 0xE2, 0x02, // 'â (U+0027 U+00E2)
  0x00, 0x27, 0x00, 0xE3, 0x02, // 'ã (U+0027 U+00E3)
  0x00, 0x27, 0x00, 0xE4, 0x02, // 'ä (U+0027 U+00E4)
  0x00, 0x27, 0x00, 0xE5, 0x02, // 'å (U+0027 U+00E5)
  0x00, 0x27, 0x00, 0xE6, 0x02, // 'æ (U+0027 U+00E6)
  0x00, 0x27, 0x00, 0xE7, 0x02, // 'ç (U+0027 U+00E7)
  0x00, 0x27, 0x00, 0xE8, 0x02, // 'è (U+0027 U+00E8)
  0x00, 0x27, 0x00, 0xE9, 0x02, // 'é (U+0027 U+00E9)
  0x00, 0x27, 0x00, 0xEA, 0x02, // 'ê (U+0027 U+00EA)
  0x00, 0x27, 0x00, 0xEB, 0x02, // 'ë (U+0027 U+00EB)
  0x00, 0x27, 0x00, 0xF1, 0x01, // 'ñ (U+0027 U+00F1)
  0x00, 0x27, 0x00, 0xF2, 0x02, // 'ò (U+0027 U+00F2)
  0x00, 0x27, 0x00, 0xF3, 0x02, // 'ó (U+0027 U+00F3)
  0x00, 0x27, 0x00, 0xF4, 0x02, // 'ô (U+0027 U+00F4)
  0x00, 0x27, 0x00, 0xF5, 0x02, // 'õ (U+0027 U+00F5)
  0x00, 0x27, 0x00, 0xF6, 0x02, // 'ö (U+0027 U+00F6)
  0x00, 0x27, 0x00, 0xF8, 0x02, // 'ø (U+0027 U+00F8)
  0x00, 0x27, 0x00, 0xF9, 0x01, // 'ù (U+0027 U+00F9)
  0x00, 0x27, 0x00, 0xFA, 0x01, // 'ú (U+0027 U+00FA)
  0x00, 0x27, 0x00, 0xFB, 0x01, // 'û (U+0027 U+00FB)
  0x00, 0x27, 0x00, 0xFC, 0x01, // 'ü (U+0027 U+00FC)
  0x00, 0x27, 0x01, 0x00, 0x02, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x01, 0x02, // 'ā (U+0027 U+0101)
  0x00, 0x27, 0x01, 0x02, 0x02, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x03, 0x02, // 'ă (U+0027 U+0103)
  0x00, 0x27, 0x01, 0x04, 0x02, // 'Ą (U+0027 U+0104)
  0x00, 0x27, 0x01, 0x05, 0x02, // 'ą (U+0027 U+0105)
  0x00, 0x27, 0x01, 0x07, 0x02, // 'ć (U+0027 U+0107)
  0x00, 0x27, 0x01, 0x09, 0x02, // 'ĉ (U+0027 U+0109)
  0x00, 0x27, 0x01, 0x0B, 0x02, // 'ċ (U+0027 U+010B)
  0x00, 0x27, 0x01, 0x0D, 0x02, // 'č (U+0027 U+010D)
  0x00, 0x27, 0x01, 0x0F, 0x02, // 'ď (U+0027 U+010F)
  0x00, 0x27, 0x01, 0x11, 0x02, // 'đ (U+0027 U+0111)
  0x00, 0x27, 0x01, 0x13, 0x02, // 'ē (U+0027 U+0113)
  0x00, 0x27, 0x01, 0x15, 0x02, // 'ĕ (U+0027 U+0115)
  0x00, 0x27, 0x01, 0x17, 0x02, // 'ė (U+0027 U+0117)
  0x00, 0x27, 0x01, 0x19, 0x02, // 'ę (U+0027 U+0119)
  0x00, 0x27, 0x01, 0x1B, 0x02, // 'ě (U+0027 U+011B)
  0x00, 0x27, 0x01, 0x1D, 0x01, // 'ĝ (U+0027 U+011D)
  0x00, 0x27, 0x01, 0x1F, 0x01, // 'ğ (U+0027 U+011F)
  0x00, 0x27, 0x01, 0x21, 0x01, // 'ġ (U+0027 U+0121)
  0x00, 0x27, 0x01, 0x23, 0x01, // 'ģ (U+0027 U+0123)
  0x00, 0x27, 0x01, 0x38, 0x01, // 'ĸ (U+0027 U+0138)
  0x00, 0x27, 0x01, 0x44, 0x01, // 'ń (U+0027 U+0144)
  0x00, 0x27, 0x01, 0x46, 0x01, // 'ņ (U+0027 U+0146)
  0x00, 0x27, 0x01, 0x48, 0x01, // 'ň (U+0027 U+0148)
  0x00, 0x27, 0x01, 0x4B, 0x01, // 'ŋ (U+0027 U+014B)
  0x00, 0x27, 0x01, 0x4D, 0x02, // 'ō (U+0027 U+014D)
  0x00, 0x27, 0x01, 0x4F, 0x02, // 'ŏ (U+0027 U+014F)
  0x00, 0x27, 0x01, 0x51, 0x02, // 'ő (U+0027 U+0151)
  0x00, 0x27, 0x01, 0x53, 0x02, // 'œ (U+0027 U+0153)
  0x00, 0x27, 0x01, 0x55, 0x01, // 'ŕ (U+0027 U+0155)
  0x00, 0x27, 0x01, 0x57, 0x01, // 'ŗ (U+0027 U+0157)
  0x00, 0x27, 0x01, 0x5B, 0x01, // 'ś (U+0027 U+015B)
  0x00, 0x27, 0x01, 0x5D, 0x01, // 'ŝ (U+0027 U+015D)
  0x00, 0x27, 0x01, 0x5F, 0x01, // 'ş (U+0027 U+015F)
  0x00, 0x27, 0x01, 0x61, 0x01, // 'š (U+0027 U+0161)
  0x00, 0x27, 0x01, 0x69, 0x01, // 'ũ (U+0027 U+0169)
  0x00, 0x27, 0x01, 0x6B, 0x01, // 'ū (U+0027 U+016B)
  0x00, 0x27, 0x01, 0x6D, 0x01, // 'ŭ (U+0027 U+016D)
  0x00, 0x27, 0x01, 0x6F, 0x01, // 'ů (U+0027 U+016F)
  0x00, 0x27, 0x01, 0x71, 0x01, // 'ű (U+0027 U+0171)
  0x00, 0x27, 0x01, 0x73, 0x01, // 'ų (U+0027 U+0173)
  0x00, 0x2C, 0x00, 0x43, 0x01, // ,C (U+002C U+0043)
  0x00, 0x2C, 0x00, 0x47, 0x01, // ,G (U+002C U+0047)
  0x00, 0x2C, 0x00, 0x4F, 0x01, // ,O (U+002C U+004F)
  0x00, 0x2C, 0x00, 0x51, 0x01, // ,Q (U+002C U+0051)
  0x00, 0x2C, 0x00, 0x54, 0x02, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x55, 0x01, // ,U (U+002C U+0055)
  0x00, 0x2C, 0x00, 0x56, 0x02, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x02, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x02, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0xC7, 0x01, // ,Ç (U+002C U+00C7)
  0x00, 0x2C, 0x00, 0xD2, 0x01, // ,Ò (U+002C U+00D2)
  0x00, 0x2C, 0x00, 0xD3, 0x01, // ,Ó (U+002C U+00D3)
  0x00, 0x2C, 0x00, 0xD4, 0x01, // ,Ô (U+002C U+00D4)
  0x00, 0x2C, 0x00, 0xD5, 0x01, // ,Õ (U+002C U+00D5)
  0x00, 0x2C, 0x00, 0xD6, 0x01, // ,Ö (U+002C U+00D6)
  0x00, 0x2C, 0x00, 0xD8, 0x01, // ,Ø (U+002C U+00D8)
  0x00, 0x2C, 0x00, 0xD9, 0x01, // ,Ù (U+002C U+00D9)
  0x00, 0x2C, 0x00, 0xDA, 0x01, // ,Ú (U+002C U+00DA)
  0x00, 0x2C, 0x00, 0xDB, 0x01, // ,Û (U+002C U+00DB)
  0x00, 0x2C, 0x00, 0xDC, 0x01, // ,Ü (U+002C U+00DC)
  0x00, 0x2C, 0x00, 0xDD, 0x02, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x01, 0x06, 0x01, // ,Ć (U+002C U+0106)
  0x00, 0x2C, 0x01, 0x08, 0x01, // ,Ĉ (U+002C U+0108)
  0x00, 0x2C, 0x01, 0x0A, 0x01, // ,Ċ (U+002C U+010A)
  0x00, 0x2C, 0x01, 0x0C, 0x01, // ,Č (U+002C U+010C)
  0x00, 0x2C, 0x01, 0x1C, 0x01, // ,Ĝ (U+002C U+011C)
  0x00, 0x2C, 0x01, 0x1E, 0x01, // ,Ğ (U+002C U+011E)
  0x00, 0x2C, 0x01, 0x20, 0x01, // ,Ġ (U+002C U+0120)
  0x00, 0x2C, 0x01, 0x22, 0x01, // ,Ģ (U+002C U+0122)
  0x00, 0x2C, 0x01, 0x4C, 0x01, // ,Ō (U+002C U+014C)
  0x00, 0x2C, 0x01, 0x4E, 0x01, // ,Ŏ (U+002C U+014E)
  0x00, 0x2C, 0x01, 0x50, 0x01, // ,Ő (U+002C U+0150)
  0x00, 0x2C, 0x01, 0x52, 0x01, // ,Œ (U+002C U+0152)
  0x00, 0x2C, 0x01, 0x62, 0x02, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x02, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x02, // ,Ŧ (U+002C U+0166)
  0x00, 0x2C, 0x01, 0x68, 0x01, // ,Ũ (U+002C U+0168)
  0x00, 0x2C, 0x01, 0x6A, 0x01, // ,Ū (U+002C U+016A)
  0x00, 0x2C, 0x01, 0x6C, 0x01, // ,Ŭ (U+002C U+016C)
  0x00, 0x2C, 0x01, 0x6E, 0x01, // ,Ů (U+002C U+016E)
  0x00, 0x2C, 0x01, 0x70, 0x01, // ,Ű (U+002C U+0170)
  0x00, 0x2C, 0x01, 0x72, 0x01, // ,Ų (U+002C U+0172)
  0x00, 0x2C, 0x01, 0x74, 0x02, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x76, 0x02, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x78, 0x02, // ,Ÿ (U+002C U+0178)
  0x00, 0x2D, 0x00, 0x54, 0x02, // -T (U+002D U+0054)
  0x00, 0x2D, 0x01, 0x62, 0x02, // -Ţ (U+002D U+0162)
  0x00, 0x2D, 0x01, 0x64, 0x02, // -Ť (U+002D U+0164)
  0x00, 0x2D, 0x01, 0x66, 0x02, // -Ŧ (U+002D U+0166)
  0x00, 0x2E, 0x00, 0x43, 0x01, // .C (U+002E U+0043)
  0x00, 0x2E, 0x00, 0x47, 0x01, // .G (U+002E U+0047)
  0x00, 0x2E, 0x00, 0x4F, 0x01, // .O (U+002E U+004F)
  0x00, 0x2E, 0x00, 0x51, 0x01, // .Q (U+002E U+0051)
  0x00, 0x2E, 0x00, 0x54, 0x02, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x55, 0x01, // .U (U+002E U+0055)
  0x00, 0x2E, 0x00, 0x56, 0x02, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x02, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x02, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0xC7, 0x01, // .Ç (U+002E U+00C7)
  0x00, 0x2E, 0x00, 0xD2, 0x01, // .Ò (U+002E U+00D2)
  0x00, 0x2E, 0x00, 0xD3, 0x01, // .Ó (U+002E U+00D3)
  0x00, 0x2E, 0x00, 0xD4, 0x01, // .Ô (U+002E U+00D4)
  0x00, 0x2E, 0x00, 0xD5, 0x01, // .Õ (U+002E U+00D5)
  0x00, 0x2E, 0x00, 0xD6, 0x01, // .Ö (U+002E U+00D6)
  0x00, 0x2E, 0x00, 0xD8, 0x01, // .Ø (U+002E U+00D8)
  0x00, 0x2E, 0x00, 0xD9, 0x01, // .Ù (U+002E U+00D9)
  0x00, 0x2E, 0x00, 0xDA, 0x01, // .Ú (U+002E U+00DA)
  0x00, 0x2E, 0x00, 0xDB, 0x01, // .Û (U+002E U+00DB)
  0x00, 0x2E, 0x00, 0xDC, 0x01, // .Ü (U+002E U+00DC)
  0x00, 0x2E, 0x00, 0xDD, 0x02, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x01, 0x06, 0x01, // .Ć (U+002E U+0106)
  0x00, 0x2E, 0x01, 0x08, 0x01, // .Ĉ (U+002E U+0108)
  0x00, 0x2E, 0x01, 0x0A, 0x01, // .Ċ (U+002E U+010A)
  0x00, 0x2E, 0x01, 0x0C, 0x01, // .Č (U+002E U+010C)
  0x00, 0x2E, 0x01, 0x1C, 0x01, // .Ĝ (U+002E U+011C)
  0x00, 0x2E, 0x01, 0x1E, 0x01, // .Ğ (U+002E U+011E)
  0x00, 0x2E, 0x01, 0x20, 0x01, // .Ġ (U+002E U+0120)
  0x00, 0x2E, 0x01, 0x22, 0x01, // .Ģ (U+002E U+0122)
  0x00, 0x2E, 0x01, 0x4C, 0x01, // .Ō (U+002E U+014C)
  0x00, 0x2E, 0x01, 0x4E, 0x01, // .Ŏ (U+002E U+014E)
  0x00, 0x2E, 0x01, 0x50, 0x01, // .Ő (U+002E U+0150)
  0x00, 0x2E, 0x01, 0x52, 0x01, // .Œ (U+002E U+0152)
  0x00, 0x2E, 0x01, 0x62, 0x02, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x02, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x02, // .Ŧ (U+002E U+0166)
  0x00, 0x2E, 0x01, 0x68, 0x01, // .Ũ (U+002E U+0168)
  0x00, 0x2E, 0x01, 0x6A, 0x01, // .Ū (U+002E U+016A)
  0x00, 0x2E, 0x01, 0x6C, 0x01, // .Ŭ (U+002E U+016C)
  0x00, 0x2E, 0x01, 0x6E, 0x01, // .Ů (U+002E U+016E)
  0x00, 0x2E, 0x01, 0x70, 0x01, // .Ű (U+002E U+0170)
  0x00, 0x2E, 0x01, 0x72, 0x01, // .Ų (U+002E U+0172)
  0x00, 0x2E, 0x01, 0x74, 0x02, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x76, 0x02, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x78, 0x02, // .Ÿ (U+002E U+0178)
  0x00, 0x41, 0x00, 0x22, 0x02, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x02, // A' (U+0041 U+0027)
  0x00, 0x41, 0x00, 0x43, 0x01, // AC (U+0041 U+0043)
  0x00, 0x41, 0x00, 0x47, 0x01, // AG (U+0041 U+0047)
  0x00, 0x41, 0x00, 0x4F, 0x01, // AO (U+0041 U+004F)
  0x00, 0x41, 0x00, 0x51, 0x01, // AQ (U+0041 U+0051)
  0x00, 0x41, 0x00, 0x54, 0x01, // AT (U+0041 U+0054)
  0x00, 0x41, 0x00, 0x59, 0x01, // AY (U+0041 U+0059)
  0x00, 0x41, 0x00, 0xC7, 0x01, // AÇ (U+0041 U+00C7)
  0x00, 0x41, 0x00, 0xD2, 0x01, // AÒ (U+0041 U+00D2)
  0x00, 0x41, 0x00, 0xD3, 0x01, // AÓ (U+0041 U+00D3)
  0x00, 0x41, 0x00, 0xD4, 0x01, // AÔ (U+0041 U+00D4)
  0x00, 0x41, 0x00, 0xD5, 0x01, // AÕ (U+0041 U+00D5)
  0x00, 0x41, 0x00, 0xD6, 0x01, // AÖ (U+0041 U+00D6)
  0x00, 0x41, 0x00, 0xD8, 0x01, // AØ (U+0041 U+00D8)
  0x00, 0x41, 0x00, 0xDD, 0x01, // AÝ (U+0041 U+00DD)
  0x00, 0x41, 0x01, 0x06, 0x01, // AĆ (U+0041 U+0106)
  0x00, 0x41, 0x01, 0x08, 0x01, // AĈ (U+0041 U+0108)
  0x00, 0x41, 0x01, 0x0A, 0x01, // AĊ (U+0041 U+010A)
  0x00, 0x41, 0x01, 0x0C, 0x01, // AČ (U+0041 U+010C)
  0x00, 0x41, 0x01, 0x1C, 0x01, // AĜ (U+0041 U+011C)
  0x00, 0x41, 0x01, 0x1E, 0x01, // AĞ (U+0041 U+011E)
  0x00, 0x41, 0x01, 0x20, 0x01, // AĠ (U+0041 U+0120)
  0x00, 0x41, 0x01, 0x22, 0x01, // AĢ (U+0041 U+0122)
  0x00, 0x41, 0x01, 0x4C, 0x01, // AŌ (U+0041 U+014C)
  0x00, 0x41, 0x01, 0x4E, 0x01, // AŎ (U+0041 U+014E)
  0x00, 0x41, 0x01, 0x50, 0x01, // AŐ (U+0041 U+0150)
  0x00, 0x41, 0x01, 0x52, 0x01, // AŒ (U+0041 U+0152)
  0x00, 0x41, 0x01, 0x62, 0x01, // AŢ (U+0041 U+0162)
  0x00, 0x41, 0x01, 0x64, 0x01, // AŤ (U+0041 U+0164)
  0x00, 0x41, 0x01, 0x66, 0x01, // AŦ (U+0041 U+0166)
  0x00, 0x41, 0x01, 0x76, 0x01, // AŶ (U+0041 U+0176)
  0x00, 0x41, 0x01, 0x78, 0x01, // AŸ (U+0041 U+0178)
  0x00, 0x41, 0x20, 0x19, 0x02, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1D, 0x02, // A” (U+0041 U+201D)
  0x00, 0x42, 0x00, 0x2C, 0x01, // B, (U+0042 U+002C)
  0x00, 0x42, 0x00, 0x2E, 0x01, // B. (U+0042 U+002E)
  0x00, 0x42, 0x20, 0x1A, 0x01, // B‚ (U+0042 U+201A)
  0x00, 0x42, 0x20, 0x1E, 0x01, // B„ (U+0042 U+201E)
  0x00, 0x42, 0x20, 0x26, 0x01, // B… (U+0042 U+2026)
  0x00, 0x43, 0x00, 0x43, 0x01, // CC (U+0043 U+0043)
  0x00, 0x43, 0x00, 0x47, 0x01, // CG (U+0043 U+0047)
  0x00, 0x43, 0x00, 0x4F, 0x01, // CO (U+0043 U+004F)
  0x00, 0x43, 0x00, 0x51, 0x01, // CQ (U+0043 U+0051)
  0x00, 0x43, 0x00, 0xAB, 0x01, // C« (U+0043 U+00AB)
  0x00, 0x43, 0x00, 0xC7, 0x01, // CÇ (U+0043 U+00C7)
  0x00, 0x43, 0x00, 0xD2, 0x01, // CÒ (U+0043 U+00D2)
  0x00, 0x43, 0x00, 0xD3, 0x01, // CÓ (U+0043 U+00D3)
  0x00, 0x43, 0x00, 0xD4, 0x01, // CÔ (U+0043 U+00D4)
  0x00, 0x43, 0x00, 0xD5, 0x01, // CÕ (U+0043 U+00D5)
  0x00, 0x43, 0x00, 0xD6, 0x01, // CÖ (U+0043 U+00D6)
  0x00, 0x43, 0x00, 0xD8, 0x01, // CØ (U+0043 U+00D8)
  0x00, 0x43, 0x01, 0x06, 0x01, // CĆ (U+0043 U+0106)
  0x00, 0x43, 0x01, 0x08, 0x01, // CĈ (U+0043 U+0108)
  0x00, 0x43, 0x01, 0x0A, 0x01, // CĊ (U+0043 U+010A)
  0x00, 0x43, 0x01, 0x0C, 0x01, // CČ (U+0043 U+010C)
  0x00, 0x43, 0x01, 0x1C, 0x01, // CĜ (U+0043 U+011C)
  0x00, 0x43, 0x01, 0x1E, 0x01, // CĞ (U+0043 U+011E)
  0x00, 0x43, 0x01, 0x20, 0x01, // CĠ (U+0043 U+0120)
  0x00, 0x43, 0x01, 0x22, 0x01, // CĢ (U+0043 U+0122)
  0x00, 0x43, 0x01, 0x4C, 0x01, // CŌ (U+0043 U+014C)
  0x00, 0x43, 0x01, 0x4E, 0x01, // CŎ (U+0043 U+014E)
  0x00, 0x43, 0x01, 0x50, 0x01, // CŐ (U+0043 U+0150)
  0x00, 0x43, 0x01, 0x52, 0x01, // CŒ (U+0043 U+0152)
  0x00, 0x43, 0x20, 0x39, 0x01, // C‹ (U+0043 U+2039)
  0x00, 0x44, 0x00, 0x2C, 0x02, // D, (U+0044 U+002C)
  0x00, 0x44, 0x00, 0x2E, 0x02, // D. (U+0044 U+002E)
  0x00, 0x44, 0x00, 0x54, 0x01, // DT (U+0044 U+0054)
  0x00, 0x44, 0x00, 0x58, 0x01, // DX (U+0044 U+0058)
  0x00, 0x44, 0x01, 0x62, 0x01, // DŢ (U+0044 U+0162)
  0x00, 0x44, 0x01, 0x64, 0x01, // DŤ (U+0044 U+0164)
  0x00, 0x44, 0x01, 0x66, 0x01, // DŦ (U+0044 U+0166)
  0x00, 0x44, 0x20, 0x1A, 0x02, // D‚ (U+0044 U+201A)
  0x00, 0x44, 0x20, 0x1E, 0x02, // D„ (U+0044 U+201E)
  0x00, 0x44, 0x20, 0x26, 0x02, // D… (U+0044 U+2026)
  0x00, 0x46, 0x00, 0x2C, 0x02, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x02, // F. (U+0046 U+002E)
  0x00, 0x46, 0x20, 0x1A, 0x02, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x02, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x02, // F… (U+0046 U+2026)
  0x00, 0x4B, 0x00, 0x43, 0x01, // KC (U+004B U+0043)
  0x00, 0x4B, 0x00, 0x47, 0x01, // KG (U+004B U+0047)
  0x00, 0x4B, 0x00, 0x4F, 0x01, // KO (U+004B U+004F)
  0x00, 0x4B, 0x00, 0x51, 0x01, // KQ (U+004B U+0051)
  0x00, 0x4B, 0x00, 0xAB, 0x01, // K« (U+004B U+00AB)
  0x00, 0x4B, 0x00, 0xC7, 0x01, // KÇ (U+004B U+00C7)
  0x00, 0x4B, 0x00, 0xD2, 0x01, // KÒ (U+004B U+00D2)
  0x00, 0x4B, 0x00, 0xD3, 0x01, // KÓ (U+004B U+00D3)
  0x00, 0x4B, 0x00, 0xD4, 0x01, // KÔ (U+004B U+00D4)
  0x00, 0x4B, 0x00, 0xD5, 0x01, // KÕ (U+004B U+00D5)
  0x00, 0x4B, 0x00, 0xD6, 0x01, // KÖ (U+004B U+00D6)
  0x00, 0x4B, 0x00, 0xD8, 0x01, // KØ (U+004B U+00D8)
  0x00, 0x4B, 0x01, 0x06, 0x01, // KĆ (U+004B U+0106)
  0x00, 0x4B, 0x01, 0x08, 0x01, // KĈ (U+004B U+0108)
  0x00, 0x4B, 0x01, 0x0A, 0x01, // KĊ (U+004B U+010A)
  0x00, 0x4B, 0x01, 0x0C, 0x01, // KČ (U+004B U+010C)
  0x00, 0x4B, 0x01, 0x1C, 0x01, // KĜ (U+004B U+011C)
  0x00, 0x4B, 0x01, 0x1E, 0x01, // KĞ (U+004B U+011E)
  0x00, 0x4B, 0x01, 0x20, 0x01, // KĠ (U+004B U+0120)
  0x00, 0x4B, 0x01, 0x22, 0x01, // KĢ (U+004B U+0122)
  0x00, 0x4B, 0x01, 0x4C, 0x01, // KŌ (U+004B U+014C)
  0x00, 0x4B, 0x01, 0x4E, 0x01, // KŎ (U+004B U+014E)
  0x00, 0x4B, 0x01, 0x50, 0x01, // KŐ (U+004B U+0150)
  0x00, 0x4B, 0x01, 0x52, 0x01, // KŒ (U+004B U+0152)
  0x00, 0x4B, 0x20, 0x39, 0x01, // K‹ (U+004B U+2039)
  0x00, 0x4C, 0x00, 0x22, 0x03, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x03, // L' (U+004C U+0027)
  0x00, 0x4C, 0x00, 0x43, 0x01, // LC (U+004C U+0043)
  0x00, 0x4C, 0x00, 0x47, 0x01, // LG (U+004C U+0047)
  0x00, 0x4C, 0x00, 0x4F, 0x01, // LO (U+004C U+004F)
  0x00, 0x4C, 0x00, 0x51, 0x01, // LQ (U+004C U+0051)
  0x00, 0x4C, 0x00, 0x54, 0x02, // LT (U+004C U+0054)
  0x00, 0x4C, 0x00, 0x55, 0x01, // LU (U+004C U+0055)
  0x00, 0x4C, 0x00, 0x56, 0x01, // LV (U+004C U+0056)
  0x00, 0x4C, 0x00, 0x57, 0x01, // LW (U+004C U+0057)
  0x00, 0x4C, 0x00, 0x59, 0x02, // LY (U+004C U+0059)
  0x00, 0x4C, 0x00, 0xAB, 0x02, // L« (U+004C U+00AB)
  0x00, 0x4C, 0x00, 0xC7, 0x01, // LÇ (U+004C U+00C7)
  0x00, 0x4C, 0x00, 0xD2, 0x01, // LÒ (U+004C U+00D2)
  0x00, 0x4C, 0x00, 0xD3, 0x01, // LÓ (U+004C U+00D3)
  0x00, 0x4C, 0x00, 0xD4, 0x01, // LÔ (U+004C U+00D4)
  0x00, 0x4C, 0x00, 0xD5, 0x01, // LÕ (U+004C U+00D5)
  0x00, 0x4C, 0x00, 0xD6, 0x01, // LÖ (U+004C U+00D6)
  0x00, 0x4C, 0x00, 0xD8, 0x01, // LØ (U+004C U+00D8)
  0x00, 0x4C, 0x00, 0xD9, 0x01, // LÙ (U+004C U+00D9)
  0x00, 0x4C, 0x00, 0xDA, 0x01, // LÚ (U+004C U+00DA)
  0x00, 0x4C, 0x00, 0xDB, 0x01, // LÛ (U+004C U+00DB)
  0x00, 0x4C, 0x00, 0xDC, 0x01, // LÜ (U+004C U+00DC)
  0x00, 0x4C, 0x00, 0xDD, 0x02, // LÝ (U+004C U+00DD)
  0x00, 0x4C, 0x01, 0x06, 0x01, // LĆ (U+004C U+0106)
  0x00, 0x4C, 0x01, 0x08, 0x01, // LĈ (U+004C U+0108)
  0x00, 0x4C, 0x01, 0x0A, 0x01, // LĊ (U+004C U+010A)
  0x00, 0x4C, 0x01, 0x0C, 0x01, // LČ (U+004C U+010C)
  0x00, 0x4C, 0x01, 0x1C, 0x01, // LĜ (U+004C U+011C)
  0x00, 0x4C, 0x01, 0x1E, 0x01, // LĞ (U+004C U+011E)
  0x00, 0x4C, 0x01, 0x20, 0x01, // LĠ (U+004C U+0120)
  0x00, 0x4C, 0x01, 0x22, 0x01, // LĢ (U+004C U+0122)
  0x00, 0x4C, 0x01, 0x4C, 0x01, // LŌ (U+004C U+014C)
  0x00, 0x4C, 0x01, 0x4E, 0x01, // LŎ (U+004C U+014E)
  0x00, 0x4C, 0x01, 0x50, 0x01, // LŐ (U+004C U+0150)
  0x00, 0x4C, 0x01, 0x52, 0x01, // LŒ (U+004C U+0152)
  0x00, 0x4C, 0x01, 0x62, 0x02, // LŢ (U+004C U+0162)
  0x00, 0x4C, 0x01, 0x64, 0x02, // LŤ (U+004C U+0164)
  0x00, 0x4C, 0x01, 0x66, 0x02, // LŦ (U+004C U+0166)
  0x00, 0x4C, 0x01, 0x68, 0x01, // LŨ (U+004C U+0168)
  0x00, 0x4C, 0x01, 0x6A, 0x01, // LŪ (U+004C U+016A)
  0x00, 0x4C, 0x01, 0x6C, 0x01, // LŬ (U+004C U+016C)
  0x00, 0x4C, 0x01, 0x6E, 0x01, // LŮ (U+004C U+016E)
  0x00, 0x4C, 0x01, 0x70, 0x01, // LŰ (U+004C U+0170)
  0x00, 0x4C, 0x01, 0x72, 0x01, // LŲ (U+004C U+0172)
  0x00, 0x4C, 0x01, 0x74, 0x01, // LŴ (U+004C U+0174)
  0x00, 0x4C, 0x01, 0x76, 0x02, // LŶ (U+004C U+0176)
  0x00, 0x4C, 0x01, 0x78, 0x02, // LŸ (U+004C U+0178)
  0x00, 0x4C, 0x20, 0x19, 0x03, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1D, 0x03, // L” (U+004C U+201D)
  0x00, 0x4C, 0x20, 0x39, 0x02, // L‹ (U+004C U+2039)
  0x00, 0x4F, 0x00, 0x2C, 0x02, // O, (U+004F U+002C)
  0x00, 0x4F, 0x00, 0x2E, 0x02, // O. (U+004F U+002E)
  0x00, 0x4F, 0x00, 0x54, 0x01, // OT (U+004F U+0054)
  0x00, 0x4F, 0x00, 0x58, 0x01, // OX (U+004F U+0058)
  0x00, 0x4F, 0x01, 0x62, 0x01, // OŢ (U+004F U+0162)
  0x00, 0x4F, 0x01, 0x64, 0x01, // OŤ (U+004F U+0164)
  0x00, 0x4F, 0x01, 0x66, 0x01, // OŦ (U+004F U+0166)
  0x00, 0x4F, 0x20, 0x1A, 0x02, // O‚ (U+004F U+201A)
  0x00, 0x4F, 0x20, 0x1E, 0x02, // O„ (U+004F U+201E)
  0x00, 0x4F, 0x20, 0x26, 0x02, // O… (U+004F U+2026)
  0x00, 0x50, 0x00, 0x2C, 0x05, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x05, // P. (U+0050 U+002E)
  0x00, 0x50, 0x00, 0x41, 0x01, // PA (U+0050 U+0041)
  0x00, 0x50, 0x00, 0x58, 0x01, // PX (U+0050 U+0058)
  0x00, 0x50, 0x00, 0xC0, 0x01, // PÀ (U+0050 U+00C0)
  0x00, 0x50, 0x00, 0xC1, 0x01, // PÁ (U+0050 U+00C1)
  0x00, 0x50, 0x00, 0xC2, 0x01, // PÂ (U+0050 U+00C2)
  0x00, 0x50, 0x00, 0xC3, 0x01, // PÃ (U+0050 U+00C3)
  0x00, 0x50, 0x00, 0xC4, 0x01, // PÄ (U+0050 U+00C4)
  0x00, 0x50, 0x00, 0xC5, 0x01, // PÅ (U+0050 U+00C5)
  0x00, 0x50, 0x01, 0x00, 0x01, // PĀ (U+0050 U+0100)
  0x00, 0x50, 0x01, 0x02, 0x01, // PĂ (U+0050 U+0102)
  0x00, 0x50, 0x01, 0x04, 0x01, // PĄ (U+0050 U+0104)
  0x00, 0x50, 0x20, 0x1A, 0x05, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x05, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x05, // P… (U+0050 U+2026)
  0x00, 0x51, 0x00, 0x2C, 0x02, // Q, (U+0051 U+002C)
  0x00, 0x51, 0x00, 0x2E, 0x02, // Q. (U+0051 U+002E)
  0x00, 0x51, 0x00, 0x54, 0x01, // QT (U+0051 U+0054)
  0x00, 0x51, 0x00, 0x58, 0x01, // QX (U+0051 U+0058)
  0x00, 0x51, 0x01, 0x62, 0x01, // QŢ (U+0051 U+0162)
  0x00, 0x51, 0x01, 0x64, 0x01, // QŤ (U+0051 U+0164)
  0x00, 0x51, 0x01, 0x66, 0x01, // QŦ (U+0051 U+0166)
  0x00, 0x51, 0x20, 0x1A, 0x02, // Q‚ (U+0051 U+201A)
  0x00, 0x51, 0x20, 0x1E, 0x02, // Q„ (U+0051 U+201E)
  0x00, 0x51, 0x20, 0x26, 0x02, // Q… (U+0051 U+2026)
  0x00, 0x54, 0x00, 0x26, 0x01, // T& (U+0054 U+0026)
  0x00, 0x54, 0x00, 0x2C, 0x02, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2D, 0x02, // T- (U+0054 U+002D)
  0x00, 0x54, 0x00, 0x2E, 0x02, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0x41, 0x01, // TA (U+0054 U+0041)
  0x00, 0x54, 0x00, 0x43, 0x01, // TC (U+0054 U+0043)
  0x00, 0x54, 0x00, 0x47, 0x01, // TG (U+0054 U+0047)
  0x00, 0x54, 0x00, 0x4F, 0x01, // TO (U+0054 U+004F)
  0x00, 0x54, 0x00, 0x51, 0x01, // TQ (U+0054 U+0051)
  0x00, 0x54, 0x00, 0x61, 0x02, // Ta (U+0054 U+0061)
  0x00, 0x54, 0x00, 0x63, 0x02, // Tc (U+0054 U+0063)
  0x00, 0x54, 0x00, 0x64, 0x02, // Td (U+0054 U+0064)
  0x00, 0x54, 0x00, 0x65, 0x02, // Te (U+0054 U+0065)
  0x00, 0x54, 0x00, 0x67, 0x02, // Tg (U+0054 U+0067)
  0x00, 0x54, 0x00, 0x6D, 0x02, // Tm (U+0054 U+006D)
  0x00, 0x54, 0x00, 0x6E, 0x02, // Tn (U+0054 U+006E)
  0x00, 0x54, 0x00, 0x6F, 0x02, // To (U+0054 U+006F)
  0x00, 0x54, 0x00, 0x70, 0x02, // Tp (U+0054 U+0070)
  0x00, 0x54, 0x00, 0x71, 0x02, // Tq (U+0054 U+0071)
  0x00, 0x54, 0x00, 0x72, 0x02, // Tr (U+0054 U+0072)
  0x00, 0x54, 0x00, 0x73, 0x02, // Ts (U+0054 U+0073)
  0x00, 0x54, 0x00, 0x75, 0x02, // Tu (U+0054 U+0075)
  0x00, 0x54, 0x00, 0x76, 0x01, // Tv (U+0054 U+0076)
  0x00, 0x54, 0x00, 0x77, 0x01, // Tw (U+0054 U+0077)
  0x00, 0x54, 0x00, 0x79, 0x01, // Ty (U+0054 U+0079)
  0x00, 0x54, 0x00, 0x7A, 0x01, // Tz (U+0054 U+007A)
  0x00, 0x54, 0x00, 0xAB, 0x02, // T« (U+0054 U+00AB)
  0x00, 0x54, 0x00, 0xBB, 0x01, // T» (U+0054 U+00BB)
  0x00, 0x54, 0x00, 0xC0, 0x01, // TÀ (U+0054 U+00C0)
  0x00, 0x54, 0x00, 0xC1, 0x01, // TÁ (U+0054 U+00C1)
  0x00, 0x54, 0x00, 0xC2, 0x01, // TÂ (U+0054 U+00C2)
  0x00, 0x54, 0x00, 0xC3, 0x01, // TÃ (U+0054 U+00C3)
  0x00, 0x54, 0x00, 0xC4, 0x01, // TÄ (U+0054 U+00C4)
  0x00, 0x54, 0x00, 0xC5, 0x01, // TÅ (U+0054 U+00C5)
  0x00, 0x54, 0x00, 0xC7, 0x01, // TÇ (U+0054 U+00C7)
  0x00, 0x54, 0x00, 0xD2, 0x01, // TÒ (U+0054 U+00D2)
  0x00, 0x54, 0x00, 0xD3, 0x01, // TÓ (U+0054 U+00D3)
  0x00, 0x54, 0x00, 0xD4, 0x01, // TÔ (U+0054 U+00D4)
  0x00, 0x54, 0x00, 0xD5, 0x01, // TÕ (U+0054 U+00D5)
  0x00, 0x54, 0x00, 0xD6, 0x01, // TÖ (U+0054 U+00D6)
  0x00, 0x54, 0x00, 0xD8, 0x01, // TØ (U+0054 U+00D8)
  0x00, 0x54, 0x00, 0xE0, 0x02, // Tà (U+0054 U+00E0)
  0x00, 0x54, 0x00, 0xE1, 0x02, // Tá (U+0054 U+00E1)
  0x00, 0x54, 0x00, 0xE2, 0x02, // Tâ (U+0054 U+00E2)
  0x00, 0x54, 0x00, 0xE3, 0x02, // Tã (U+0054 U+00E3)
  0x00, 0x54, 0x00, 0xE4, 0x02, // Tä (U+0054 U+00E4)
  0x00, 0x54, 0x00, 0xE5, 0x02, // Tå (U+0054 U+00E5)
  0x00, 0x54, 0x00, 0xE6, 0x02, // Tæ (U+0054 U+00E6)
  0x00, 0x54, 0x00, 0xE7, 0x02, // Tç (U+0054 U+00E7)
  0x00, 0x54, 0x00, 0xE8, 0x02, // Tè (U+0054 U+00E8)
  0x00, 0x54, 0x00, 0xE9, 0x02, // Té (U+0054 U+00E9)
  0x00, 0x54, 0x00, 0xEA, 0x02, // Tê (U+0054 U+00EA)
  0x00, 0x54, 0x00, 0xEB, 0x02, // Të (U+0054 U+00EB)
  0x00, 0x54, 0x00, 0xF1, 0x02, // Tñ (U+0054 U+00F1)
  0x00, 0x54, 0x00, 0xF2, 0x02, // Tò (U+0054 U+00F2)
  0x00, 0x54, 0x00, 0xF3, 0x02, // Tó (U+0054 U+00F3)
  0x00, 0x54, 0x00, 0xF4, 0x02, // Tô (U+0054 U+00F4)
  0x00, 0x54, 0x00, 0xF5, 0x02, // Tõ (U+0054 U+00F5)
  0x00, 0x54, 0x00, 0xF6, 0x02, // Tö (U+0054 U+00F6)
  0x00, 0x54, 0x00, 0xF8, 0x02, // Tø (U+0054 U+00F8)
  0x00, 0x54, 0x00, 0xF9, 0x02, // Tù (U+0054 U+00F9)
  0x00, 0x54, 0x00, 0xFA, 0x02, // Tú (U+0054 U+00FA)
  0x00, 0x54, 0x00, 0xFB, 0x02, // Tû (U+0054 U+00FB)
  0x00, 0x54, 0x00, 0xFC, 0x02, // Tü (U+0054 U+00FC)
  0x00, 0x54, 0x00, 0xFD, 0x01, // Tý (U+0054 U+00FD)
  0x00, 0x54, 0x00, 0xFF, 0x01, // Tÿ (U+0054 U+00FF)
  0x00, 0x54, 0x01, 0x00, 0x01, // TĀ (U+0054 U+0100)
  0x00, 0x54, 0x01, 0x01, 0x02, // Tā (U+0054 U+0101)
  0x00, 0x54, 0x01, 0x02, 0x01, // TĂ (U+0054 U+0102)
  0x00, 0x54, 0x01, 0x03, 0x02, // Tă (U+0054 U+0103)
  0x00, 0x54, 0x01, 0x04, 0x01, // TĄ (U+0054 U+0104)
  0x00, 0x54, 0x01, 0x05, 0x02, // Tą (U+0054 U+0105)
  0x00, 0x54, 0x01, 0x06, 0x01, // TĆ (U+0054 U+0106)
  0x00, 0x54, 0x01, 0x07, 0x02, // Tć (U+0054 U+0107)
  0x00, 0x54, 0x01, 0x08, 0x01, // TĈ (U+0054 U+0108)
  0x00, 0x54, 0x01, 0x09, 0x02, // Tĉ (U+0054 U+0109)
  0x00, 0x54, 0x01, 0x0A, 0x01, // TĊ (U+0054 U+010A)
  0x00, 0x54, 0x01, 0x0B, 0x02, // Tċ (U+0054 U+010B)
  0x00, 0x54, 0x01, 0x0C, 0x01, // TČ (U+0054 U+010C)
  0x00, 0x54, 0x01, 0x0D, 0x02, // Tč (U+0054 U+010D)
  0x00, 0x54, 0x01, 0x0F, 0x02, // Tď (U+0054 U+010F)
  0x00, 0x54, 0x01, 0x11, 0x02, // Tđ (U+0054 U+0111)
  0x00, 0x54, 0x01, 0x13, 0x02, // Tē (U+0054 U+0113)
  0x00, 0x54, 0x01, 0x15, 0x02, // Tĕ (U+0054 U+0115)
  0x00, 0x54, 0x01, 0x17, 0x02, // Tė (U+0054 U+0117)
  0x00, 0x54, 0x01, 0x19, 0x02, // Tę (U+0054 U+0119)
  0x00, 0x54, 0x01, 0x1B, 0x02, // Tě (U+0054 U+011B)
  0x00, 0x54, 0x01, 0x1C, 0x01, // TĜ (U+0054 U+011C)
  0x00, 0x54, 0x01, 0x1D, 0x02, // Tĝ (U+0054 U+011D)
  0x00, 0x54, 0x01, 0x1E, 0x01, // TĞ (U+0054 U+011E)
  0x00, 0x54, 0x01, 0x1F, 0x02, // Tğ (U+0054 U+011F)
  0x00, 0x54, 0x01, 0x20, 0x01, // TĠ (U+0054 U+0120)
  0x00, 0x54, 0x01, 0x21, 0x02, // Tġ (U+0054 U+0121)
  0x00, 0x54, 0x01, 0x22, 0x01, // TĢ (U+0054 U+0122)
  0x00, 0x54, 0x01, 0x23, 0x02, // Tģ (U+0054 U+0123)
  0x00, 0x54, 0x01, 0x38, 0x02, // Tĸ (U+0054 U+0138)
  0x00, 0x54, 0x01, 0x44, 0x02, // Tń (U+0054 U+0144)
  0x00, 0x54, 0x01, 0x46, 0x02, // Tņ (U+0054 U+0146)
  0x00, 0x54, 0x01, 0x48, 0x02, // Tň (U+0054 U+0148)
  0x00, 0x54, 0x01, 0x4B, 0x02, // Tŋ (U+0054 U+014B)
  0x00, 0x54, 0x01, 0x4C, 0x01, // TŌ (U+0054 U+014C)
  0x00, 0x54, 0x01, 0x4D, 0x02, // Tō (U+0054 U+014D)
  0x00, 0x54, 0x01, 0x4E, 0x01, // TŎ (U+0054 U+014E)
  0x00, 0x54, 0x01, 0x4F, 0x02, // Tŏ (U+0054 U+014F)
  0x00, 0x54, 0x01, 0x50, 0x01, // TŐ (U+0054 U+0150)
  0x00, 0x54, 0x01, 0x51, 0x02, // Tő (U+0054 U+0151)
  0x00, 0x54, 0x01, 0x52, 0x01, // TŒ (U+0054 U+0152)
  0x00, 0x54, 0x01, 0x53, 0x02, // Tœ (U+0054 U+0153)
  0x00, 0x54, 0x01, 0x55, 0x02, // Tŕ (U+0054 U+0155)
  0x00, 0x54, 0x01, 0x57, 0x02, // Tŗ (U+0054 U+0157)
  0x00, 0x54, 0x01, 0x5B, 0x02, // Tś (U+0054 U+015B)
  0x00, 0x54, 0x01, 0x5D, 0x02, // Tŝ (U+0054 U+015D)
  0x00, 0x54, 0x01, 0x5F, 0x02, // Tş (U+0054 U+015F)
  0x00, 0x54, 0x01, 0x61, 0x02, // Tš (U+0054 U+0161)
  0x00, 0x54, 0x01, 0x69, 0x02, // Tũ (U+0054 U+0169)
  0x00, 0x54, 0x01, 0x6B, 0x02, // Tū (U+0054 U+016B)
  0x00, 0x54, 0x01, 0x6D, 0x02, // Tŭ (U+0054 U+016D)
  0x00, 0x54, 0x01, 0x6F, 0x02, // Tů (U+0054 U+016F)
  0x00, 0x54, 0x01, 0x71, 0x02, // Tű (U+0054 U+0171)
  0x00, 0x54, 0x01, 0x73, 0x02, // Tų (U+0054 U+0173)
  0x00, 0x54, 0x01, 0x75, 0x01, // Tŵ (U+0054 U+0175)
  0x00, 0x54, 0x01, 0x77, 0x01, // Tŷ (U+0054 U+0177)
  0x00, 0x54, 0x01, 0x7A, 0x01, // Tź (U+0054 U+017A)
  0x00, 0x54, 0x01, 0x7C, 0x01, // Tż (U+0054 U+017C)
  0x00, 0x54, 0x01, 0x7E, 0x01, // Tž (U+0054 U+017E)
  0x00, 0x54, 0x20, 0x13, 0x02, // T– (U+0054 U+2013)
  0x00, 0x54, 0x20, 0x14, 0x02, // T— (U+0054 U+2014)
  0x00, 0x54, 0x20, 0x1A, 0x02, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x02, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x02, // T… (U+0054 U+2026)
  0x00, 0x54, 0x20, 0x39, 0x02, // T‹ (U+0054 U+2039)
  0x00, 0x54, 0x20, 0x3A, 0x01, // T› (U+0054 U+203A)
  0x00, 0x55, 0x00, 0x2C, 0x01, // U, (U+0055 U+002C)
  0x00, 0x55, 0x00, 0x2E, 0x01, // U. (U+0055 U+002E)
  0x00, 0x55, 0x20, 0x1A, 0x01, // U‚ (U+0055 U+201A)
  0x00, 0x55, 0x20, 0x1E, 0x01, // U„ (U+0055 U+201E)
  0x00, 0x55, 0x20, 0x26, 0x01, // U… (U+0055 U+2026)
  0x00, 0x56, 0x00, 0x2C, 0x02, // V, (U+0056 U+002C)
  0x00, 0x56, 0x00, 0x2E, 0x02, // V. (U+0056 U+002E)
  0x00, 0x56, 0x00, 0x61, 0x01, // Va (U+0056 U+0061)
  0x00, 0x56, 0x00, 0x63, 0x01, // Vc (U+0056 U+0063)
  0x00, 0x56, 0x00, 0x64, 0x01, // Vd (U+0056 U+0064)
  0x00, 0x56, 0x00, 0x65, 0x01, // Ve (U+0056 U+0065)
  0x00, 0x56, 0x00, 0x6F, 0x01, // Vo (U+0056 U+006F)
  0x00, 0x56, 0x00, 0x71, 0x01, // Vq (U+0056 U+0071)
  0x00, 0x56, 0x00, 0xAB, 0x01, // V« (U+0056 U+00AB)
  0x00, 0x56, 0x00, 0xBB, 0x01, // V» (U+0056 U+00BB)
  0x00, 0x56, 0x00, 0xE0, 0x01, // Và (U+0056 U+00E0)
  0x00, 0x56, 0x00, 0xE1, 0x01, // Vá (U+0056 U+00E1)
  0x00, 0x56, 0x00, 0xE2, 0x01, // Vâ (U+0056 U+00E2)
  0x00, 0x56, 0x00, 0xE3, 0x01, // Vã (U+0056 U+00E3)
  0x00, 0x56, 0x00, 0xE4, 0x01, // Vä (U+0056 U+00E4)
  0x00, 0x56, 0x00, 0xE5, 0x01, // Vå (U+0056 U+00E5)
  0x00, 0x56, 0x00, 0xE6, 0x01, // Væ (U+0056 U+00E6)
  0x00, 0x56, 0x00, 0xE7, 0x01, // Vç (U+0056 U+00E7)
  0x00, 0x56, 0x00, 0xE8, 0x01, // Vè (U+0056 U+00E8)
  0x00, 0x56, 0x00, 0xE9, 0x01, // Vé (U+0056 U+00E9)
  0x00, 0x56, 0x00, 0xEA, 0x01, // Vê (U+0056 U+00EA)
  0x00, 0x56, 0x00, 0xEB, 0x01, // Vë (U+0056 U+00EB)
  0x00, 0x56, 0x00, 0xF2, 0x01, // Vò (U+0056 U+00F2)
  0x00, 0x56, 0x00, 0xF3, 0x01, // Vó (U+0056 U+00F3)
  0x00, 0x56, 0x00, 0xF4, 0x01, // Vô (U+0056 U+00F4)
  0x00, 0x56, 0x00, 0xF5, 0x01, // Võ (U+0056 U+00F5)
  0x00, 0x56, 0x00, 0xF6, 0x01, // Vö (U+0056 U+00F6)
  0x00, 0x56, 0x00, 0xF8, 0x01, // Vø (U+0056 U+00F8)
  0x00, 0x56, 0x01, 0x01, 0x01, // Vā (U+0056 U+0101)
  0x00, 0x56, 0x01, 0x03, 0x01, // Vă (U+0056 U+0103)
  0x00, 0x56, 0x01, 0x05, 0x01, // Vą (U+0056 U+0105)
  0x00, 0x56, 0x01, 0x07, 0x01, // Vć (U+0056 U+0107)
  0x00, 0x56, 0x01, 0x09, 0x01, // Vĉ (U+0056 U+0109)
  0x00, 0x56, 0x01, 0x0B, 0x01, // Vċ (U+0056 U+010B)
  0x00, 0x56, 0x01, 0x0D, 0x01, // Vč (U+0056 U+010D)
  0x00, 0x56, 0x01, 0x0F, 0x01, // Vď (U+0056 U+010F)
  0x00, 0x56, 0x01, 0x11, 0x01, // Vđ (U+0056 U+0111)
  0x00, 0x56, 0x01, 0x13, 0x01, // Vē (U+0056 U+0113)
  0x00, 0x56, 0x01, 0x15, 0x01, // Vĕ (U+0056 U+0115)
  0x00, 0x56, 0x01, 0x17, 0x01, // Vė (U+0056 U+0117)
  0x00, 0x56, 0x01, 0x19, 0x01, // Vę (U+0056 U+0119)
  0x00, 0x56, 0x01, 0x1B, 0x01, // Vě (U+0056 U+011B)
  0x00, 0x56, 0x01, 0x4D, 0x01, // Vō (U+0056 U+014D)
  0x00, 0x56, 0x01, 0x4F, 0x01, // Vŏ (U+0056 U+014F)
  0x00, 0x56, 0x01, 0x51, 0x01, // Vő (U+0056 U+0151)
  0x00, 0x56, 0x01, 0x53, 0x01, // Vœ (U+0056 U+0153)
  0x00, 0x56, 0x20, 0x1A, 0x02, // V‚ (U+0056 U+201A)
  0x00, 0x56, 0x20, 0x1E, 0x02, // V„ (U+0056 U+201E)
  0x00, 0x56, 0x20, 0x26, 0x02, // V… (U+0056 U+2026)
  0x00, 0x56, 0x20, 0x39, 0x01, // V‹ (U+0056 U+2039)
  0x00, 0x56, 0x20, 0x3A, 0x01, // V› (U+0056 U+203A)
  0x00, 0x57, 0x00, 0x2C, 0x02, // W, (U+0057 U+002C)
  0x00, 0x57, 0x00, 0x2E, 0x02, // W. (U+0057 U+002E)
  0x00, 0x57, 0x00, 0x61, 0x01, // Wa (U+0057 U+0061)
  0x00, 0x57, 0x00, 0x63, 0x01, // Wc (U+0057 U+0063)
  0x00, 0x57, 0x00, 0x64, 0x01, // Wd (U+0057 U+0064)
  0x00, 0x57, 0x00, 0x65, 0x01, // We (U+0057 U+0065)
  0x00, 0x57, 0x00, 0x6F, 0x01, // Wo (U+0057 U+006F)
  0x00, 0x57, 0x00, 0x71, 0x01, // Wq (U+0057 U+0071)
  0x00, 0x57, 0x00, 0xAB, 0x01, // W« (U+0057 U+00AB)
  0x00, 0x57, 0x00, 0xBB, 0x01, // W» (U+0057 U+00BB)
  0x00, 0x57, 0x00, 0xE0, 0x01, // Wà (U+0057 U+00E0)
  0x00, 0x57, 0x00, 0xE1, 0x01, // Wá (U+0057 U+00E1)
  0x00, 0x57, 0x00, 0xE2, 0x01, // Wâ (U+0057 U+00E2)
  0x00, 0x57, 0x00, 0xE3, 0x01, // Wã (U+0057 U+00E3)
  0x00, 0x57, 0x00, 0xE4, 0x01, // Wä (U+0057 U+00E4)
  0x00, 0x57, 0x00, 0xE5, 0x01, // Wå (U+0057 U+00E5)
  0x00, 0x57, 0x00, 0xE6, 0x01, // Wæ (U+0057 U+00E6)
  0x00, 0x57, 0x00, 0xE7, 0x01, // Wç (U+0057 U+00E7)
  0x00, 0x57, 0x00, 0xE8, 0x01, // Wè (U+0057 U+00E8)
  0x00, 0x57, 0x00, 0xE9, 0x01, // Wé (U+0057 U+00E9)
  0x00, 0x57, 0x00, 0xEA, 0x01, // Wê (U+0057 U+00EA)
  0x00, 0x57, 0x00, 0xEB, 0x01, // Wë (U+0057 U+00EB)
  0x00, 0x57, 0x00, 0xF2, 0x01, // Wò (U+0057 U+00F2)
  0x00, 0x57, 0x00, 0xF3, 0x01, // Wó (U+0057 U+00F3)
  0x00, 0x57, 0x00, 0xF4, 0x01, // Wô (U+0057 U+00F4)
  0x00, 0x57, 0x00, 0xF5, 0x01, // Wõ (U+0057 U+00F5)
  0x00, 0x57, 0x00, 0xF6, 0x01, // Wö (U+0057 U+00F6)
  0x00, 0x57, 0x00, 0xF8, 0x01, // Wø (U+0057 U+00F8)
  0x00, 0x57, 0x01, 0x01, 0x01, // Wā (U+0057 U+0101)
  0x00, 0x57, 0x01, 0x03, 0x01, // Wă (U+0057 U+0103)
  0x00, 0x57, 0x01, 0x05, 0x01, // Wą (U+0057 U+0105)
  0x00, 0x57, 0x01, 0x07, 0x01, // Wć (U+0057 U+0107)
  0x00, 0x57, 0x01, 0x09, 0x01, // Wĉ (U+0057 U+0109)
  0x00, 0x57, 0x01, 0x0B, 0x01, // Wċ (U+0057 U+010B)
  0x00, 0x57, 0x01, 0x0D, 0x01, // Wč (U+0057 U+010D)
  0x00, 0x57, 0x01, 0x0F, 0x01, // Wď (U+0057 U+010F)
  0x00, 0x57, 0x01, 0x11, 0x01, // Wđ (U+0057 U+0111)
  0x00, 0x57, 0x01, 0x13, 0x01, // Wē (U+0057 U+0113)
  0x00, 0x57, 0x01, 0x15, 0x01, // Wĕ (U+0057 U+0115)
  0x00, 0x57, 0x01, 0x17, 0x01, // Wė (U+0057 U+0117)
  0x00, 0x57, 0x01, 0x19, 0x01, // Wę (U+0057 U+0119)
  0x00, 0x57, 0x01, 0x1B, 0x01, // Wě (U+0057 U+011B)
  0x00, 0x57, 0x01, 0x4D, 0x01, // Wō (U+0057 U+014D)
  0x00, 0x57, 0x01, 0x4F, 0x01, // Wŏ (U+0057 U+014F)
  0x00, 0x57, 0x01, 0x51, 0x01, // Wő (U+0057 U+0151)
  0x00, 0x57, 0x01, 0x53, 0x01, // Wœ (U+0057 U+0153)
  0x00, 0x57, 0x20, 0x1A, 0x02, // W‚ (U+0057 U+201A)
  0x00, 0x57, 0x20, 0x1E, 0x02, // W„ (U+0057 U+201E)
  0x00, 0x57, 0x20, 0x26, 0x02, // W… (U+0057 U+2026)
  0x00, 0x57, 0x20, 0x39, 0x01, // W‹ (U+0057 U+2039)
  0x00, 0x57, 0x20, 0x3A, 0x01, // W› (U+0057 U+203A)
  0x00, 0x58, 0x00, 0x43, 0x01, // XC (U+0058 U+0043)
  0x00, 0x58, 0x00, 0x47, 0x01, // XG (U+0058 U+0047)
  0x00, 0x58, 0x00, 0x4F, 0x01, // XO (U+0058 U+004F)
  0x00, 0x58, 0x00, 0x51, 0x01, // XQ (U+0058 U+0051)
  0x00, 0x58, 0x00, 0xAB, 0x01, // X« (U+0058 U+00AB)
  0x00, 0x58, 0x00, 0xC7, 0x01, // XÇ (U+0058 U+00C7)
  0x00, 0x58, 0x00, 0xD2, 0x01, // XÒ (U+0058 U+00D2)
  0x00, 0x58, 0x00, 0xD3, 0x01, // XÓ (U+0058 U+00D3)
  0x00, 0x58, 0x00, 0xD4, 0x01, // XÔ (U+0058 U+00D4)
  0x00, 0x58, 0x00, 0xD5, 0x01, // XÕ (U+0058 U+00D5)
  0x00, 0x58, 0x00, 0xD6, 0x01, // XÖ (U+0058 U+00D6)
  0x00, 0x58, 0x00, 0xD8, 0x01, // XØ (U+0058 U+00D8)
  0x00, 0x58, 0x01, 0x06, 0x01, // XĆ (U+0058 U+0106)
  0x00, 0x58, 0x01, 0x08, 0x01, // XĈ (U+0058 U+0108)
  0x00, 0x58, 0x01, 0x0A, 0x01, // XĊ (U+0058 U+010A)
  0x00, 0x58, 0x01, 0x0C, 0x01, // XČ (U+0058 U+010C)
  0x00, 0x58, 0x01, 0x1C, 0x01, // XĜ (U+0058 U+011C)
  0x00, 0x58, 0x01, 0x1E, 0x01, // XĞ (U+0058 U+011E)
  0x00, 0x58, 0x01, 0x20, 0x01, // XĠ (U+0058 U+0120)
  0x00, 0x58, 0x01, 0x22, 0x01, // XĢ (U+0058 U+0122)
  0x00, 0x58, 0x01, 0x4C, 0x01, // XŌ (U+0058 U+014C)
  0x00, 0x58, 0x01, 0x4E, 0x01, // XŎ (U+0058 U+014E)
  0x00, 0x58, 0x01, 0x50, 0x01, // XŐ (U+0058 U+0150)
  0x00, 0x58, 0x01, 0x52, 0x01, // XŒ (U+0058 U+0152)
  0x00, 0x58, 0x20, 0x39, 0x01, // X‹ (U+0058 U+2039)
  0x00, 0x59, 0x00, 0x26, 0x01, // Y& (U+0059 U+0026)
  0x00, 0x59, 0x00, 0x2C, 0x02, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x02, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x00, 0x41, 0x01, // YA (U+0059 U+0041)
  0x00, 0x59, 0x00, 0x43, 0x01, // YC (U+0059 U+0043)
  0x00, 0x59, 0x00, 0x47, 0x01, // YG (U+0059 U+0047)
  0x00, 0x59, 0x00, 0x4F, 0x01, // YO (U+0059 U+004F)
  0x00, 0x59, 0x00, 0x51, 0x01, // YQ (U+0059 U+0051)
  0x00, 0x59, 0x00, 0x61, 0x01, // Ya (U+0059 U+0061)
  0x00, 0x59, 0x00, 0x63, 0x01, // Yc (U+0059 U+0063)
  0x00, 0x59, 0x00, 0x64, 0x01, // Yd (U+0059 U+0064)
  0x00, 0x59, 0x00, 0x65, 0x01, // Ye (U+0059 U+0065)
  0x00, 0x59, 0x00, 0x67, 0x01, // Yg (U+0059 U+0067)
  0x00, 0x59, 0x00, 0x6D, 0x01, // Ym (U+0059 U+006D)
  0x00, 0x59, 0x00, 0x6E, 0x01, // Yn (U+0059 U+006E)
  0x00, 0x59, 0x00, 0x6F, 0x01, // Yo (U+0059 U+006F)
  0x00, 0x59, 0x00, 0x70, 0x01, // Yp (U+0059 U+0070)
  0x00, 0x59, 0x00, 0x71, 0x01, // Yq (U+0059 U+0071)
  0x00, 0x59, 0x00, 0x72, 0x01, // Yr (U+0059 U+0072)
  0x00, 0x59, 0x00, 0x73, 0x01, // Ys (U+0059 U+0073)
  0x00, 0x59, 0x00, 0x75, 0x01, // Yu (U+0059 U+0075)
  0x00, 0x59, 0x00, 0x7A, 0x01, // Yz (U+0059 U+007A)
  0x00, 0x59, 0x00, 0xAB, 0x02, // Y« (U+0059 U+00AB)
  0x00, 0x59, 0x00, 0xBB, 0x02, // Y» (U+0059 U+00BB)
  0x00, 0x59, 0x00, 0xC0, 0x01, // YÀ (U+0059 U+00C0)
  0x00, 0x59, 0x00, 0xC1, 0x01, // YÁ (U+0059 U+00C1)
  0x00, 0x59, 0x00, 0xC2, 0x01, // YÂ (U+0059 U+00C2)
  0x00, 0x59, 0x00, 0xC3, 0x01, // YÃ (U+0059 U+00C3)
  0x00, 0x59, 0x00, 0xC4, 0x01, // YÄ (U+0059 U+00C4)
  0x00, 0x59, 0x00, 0xC5, 0x01, // YÅ (U+0059 U+00C5)
  0x00, 0x59, 0x00, 0xC6, 0x01, // YÆ (U+0059 U+00C6)
  0x00, 0x59, 0x00, 0xC7, 0x01, // YÇ (U+0059 U+00C7)
  0x00, 0x59, 0x00, 0xD2, 0x01, // YÒ (U+0059 U+00D2)
  0x00, 0x59, 0x00, 0xD3, 0x01, // YÓ (U+0059 U+00D3)
  0x00, 0x59, 0x00, 0xD4, 0x01, // YÔ (U+0059 U+00D4)
  0x00, 0x59, 0x00, 0xD5, 0x01, // YÕ (U+0059 U+00D5)
  0x00, 0x59, 0x00, 0xD6, 0x01, // YÖ (U+0059 U+00D6)
  0x00, 0x59, 0x00, 0xD8, 0x01, // YØ (U+0059 U+00D8)
  0x00, 0x59, 0x00, 0xE0, 0x01, // Yà (U+0059 U+00E0)
  0x00, 0x59, 0x00, 0xE1, 0x01, // Yá (U+0059 U+00E1)
  0x00, 0x59, 0x00, 0xE2, 0x01, // Yâ (U+0059 U+00E2)
  0x00, 0x59, 0x00, 0xE3, 0x01, // Yã (U+0059 U+00E3)
  0x00, 0x59, 0x00, 0xE4, 0x01, // Yä (U+0059 U+00E4)
  0x00, 0x59, 0x00, 0xE5, 0x01, // Yå (U+0059 U+00E5)
  0x00, 0x59, 0x00, 0xE6, 0x01, // Yæ (U+0059 U+00E6)
  0x00, 0x59, 0x00, 0xE7, 0x01, // Yç (U+0059 U+00E7)
  0x00, 0x59, 0x00, 0xE8, 0x01, // Yè (U+0059 U+00E8)
  0x00, 0x59, 0x00, 0xE9, 0x01, // Yé (U+0059 U+00E9)
  0x00, 0x59, 0x00, 0xEA, 0x01, // Yê (U+0059 U+00EA)
  0x00, 0x59, 0x00, 0xEB, 0x01, // Yë (U+0059 U+00EB)
  0x00, 0x59, 0x00, 0xF1, 0x01, // Yñ (U+0059 U+00F1)
  0x00, 0x59, 0x00, 0xF2, 0x01, // Yò (U+0059 U+00F2)
  0x00, 0x59, 0x00, 0xF3, 0x01, // Yó (U+0059 U+00F3)
  0x00, 0x59, 0x00, 0xF4, 0x01, // Yô (U+0059 U+00F4)
  0x00, 0x59, 0x00, 0xF5, 0x01, // Yõ (U+0059 U+00F5)
  0x00, 0x59, 0x00, 0xF6, 0x01, // Yö (U+0059 U+00F6)
  0x00, 0x59, 0x00, 0xF8, 0x01, // Yø (U+0059 U+00F8)
  0x00, 0x59, 0x00, 0xF9, 0x01, // Yù (U+0059 U+00F9)
  0x00, 0x59, 0x00, 0xFA, 0x01, // Yú (U+0059 U+00FA)
  0x00, 0x59, 0x00, 0xFB, 0x01, // Yû (U+0059 U+00FB)
  0x00, 0x59, 0x00, 0xFC, 0x01, // Yü (U+0059 U+00FC)
  0x00, 0x59, 0x01, 0x00, 0x01, // YĀ (U+0059 U+0100)
  0x00, 0x59, 0x01, 0x01, 0x01, // Yā (U+0059 U+0101)
  0x00, 0x59, 0x01, 0x02, 0x01, // YĂ (U+0059 U+0102)
  0x00, 0x59, 0x01, 0x03, 0x01, // Yă (U+0059 U+0103)
  0x00, 0x59, 0x01, 0x04, 0x01, // YĄ (U+0059 U+0104)
  0x00, 0x59, 0x01, 0x05, 0x01, // Yą (U+0059 U+0105)
  0x00, 0x59, 0x01, 0x06, 0x01, // YĆ (U+0059 U+0106)
  0x00, 0x59, 0x01, 0x07, 0x01, // Yć (U+0059 U+0107)
  0x00, 0x59, 0x01, 0x08, 0x01, // YĈ (U+0059 U+0108)
  0x00, 0x59, 0x01, 0x09, 0x01, // Yĉ (U+0059 U+0109)
  0x00, 0x59, 0x01, 0x0A, 0x01, // YĊ (U+0059 U+010A)
  0x00, 0x59, 0x01, 0x0B, 0x01, // Yċ (U+0059 U+010B)
  0x00, 0x59, 0x01, 0x0C, 0x01, // YČ (U+0059 U+010C)
  0x00, 0x59, 0x01, 0x0D, 0x01, // Yč (U+0059 U+010D)
  0x00, 0x59, 0x01, 0x0F, 0x01, // Yď (U+0059 U+010F)
  0x00, 0x59, 0x01, 0x11, 0x01, // Yđ (U+0059 U+0111)
  0x00, 0x59, 0x01, 0x13, 0x01, // Yē (U+0059 U+0113)
  0x00, 0x59, 0x01, 0x15, 0x01, // Yĕ (U+0059 U+0115)
  0x00, 0x59, 0x01, 0x17, 0x01, // Yė (U+0059 U+0117)
  0x00, 0x59, 0x01, 0x19, 0x01, // Yę (U+0059 U+0119)
  0x00, 0x59, 0x01, 0x1B, 0x01, // Yě (U+0059 U+011B)
  0x00, 0x59, 0x01, 0x1C, 0x01, // YĜ (U+0059 U+011C)
  0x00, 0x59, 0x01, 0x1D, 0x01, // Yĝ (U+0059 U+011D)
  0x00, 0x59, 0x01, 0x1E, 0x01, // YĞ (U+0059 U+011E)
  0x00, 0x59, 0x01, 0x1F, 0x01, // Yğ (U+0059 U+011F)
  0x00, 0x59, 0x01, 0x20, 0x01, // YĠ (U+0059 U+0120)
  0x00, 0x59, 0x01, 0x21, 0x01, // Yġ (U+0059 U+0121)
  0x00, 0x59, 0x01, 0x22, 0x01, // YĢ (U+0059 U+0122)
  0x00, 0x59, 0x01, 0x23, 0x01, // Yģ (U+0059 U+0123)
  0x00, 0x59, 0x01, 0x38, 0x01, // Yĸ (U+0059 U+0138)
  0x00, 0x59, 0x01, 0x44, 0x01, // Yń (U+0059 U+0144)
  0x00, 0x59, 0x01, 0x46, 0x01, // Yņ (U+0059 U+0146)
  0x00, 0x59, 0x01, 0x48, 0x01, // Yň (U+0059 U+0148)
  0x00, 0x59, 0x01, 0x4B, 0x01, // Yŋ (U+0059 U+014B)
  0x00, 0x59, 0x01, 0x4C, 0x01, // YŌ (U+0059 U+014C)
  0x00, 0x59, 0x01, 0x4D, 0x01, // Yō (U+0059 U+014D)
  0x00, 0x59, 0x01, 0x4E, 0x01, // YŎ (U+0059 U+014E)
  0x00, 0x59, 0x01, 0x4F, 0x01, // Yŏ (U+0059 U+014F)
  0x00, 0x59, 0x01, 0x50, 0x01, // YŐ (U+0059 U+0150)
  0x00, 0x59, 0x01, 0x51, 0x01, // Yő (U+0059 U+0151)
  0x00, 0x59, 0x01, 0x52, 0x01, // YŒ (U+0059 U+0152)
  0x00, 0x59, 0x01, 0x53, 0x01, // Yœ (U+0059 U+0153)
  0x00, 0x59, 0x01, 0x55, 0x01, // Yŕ (U+0059 U+0155)
  0x00, 0x59, 0x01, 0x57, 0x01, // Yŗ (U+0059 U+0157)
  0x00, 0x59, 0x01, 0x5B, 0x01, // Yś (U+0059 U+015B)
  0x00, 0x59, 0x01, 0x5D, 0x01, // Yŝ (U+0059 U+015D)
  0x00, 0x59, 0x01, 0x5F, 0x01, // Yş (U+0059 U+015F)
  0x00, 0x59, 0x01, 0x61, 0x01, // Yš (U+0059 U+0161)
  0x00, 0x59, 0x01, 0x69, 0x01, // Yũ (U+0059 U+0169)
  0x00, 0x59, 0x01, 0x6B, 0x01, // Yū (U+0059 U+016B)
  0x00, 0x59, 0x01, 0x6D, 0x01, // Yŭ (U+0059 U+016D)
  0x00, 0x59, 0x01, 0x6F, 0x01, // Yů (U+0059 U+016F)
  0x00, 0x59, 0x01, 0x71, 0x01, // Yű (U+0059 U+0171)
  0x00, 0x59, 0x01, 0x73, 0x01, // Yų (U+0059 U+0173)
  0x00, 0x59, 0x01, 0x7A, 0x01, // Yź (U+0059 U+017A)
  0x00, 0x59, 0x01, 0x7C, 0x01, // Yż (U+0059 U+017C)
  0x00, 0x59, 0x01, 0x7E, 0x01, // Yž (U+0059 U+017E)
  0x00, 0x59, 0x20, 0x1A, 0x02, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x02, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x02, // Y… (U+0059 U+2026)
  0x00, 0x59, 0x20, 0x39, 0x02, // Y‹ (U+0059 U+2039)
  0x00, 0x59, 0x20, 0x3A, 0x02, // Y› (U+0059 U+203A)
  0x00, 0x5A, 0x00, 0x26, 0x01, // Z& (U+005A U+0026)
  0x00, 0x72, 0x00, 0x2C, 0x04, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x04, // r. (U+0072 U+002E)
  0x00, 0x72, 0x20, 0x1A, 0x04, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x04, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x04, // r… (U+0072 U+2026)
  0x00, 0x76, 0x00, 0x2C, 0x01, // v, (U+0076 U+002C)
  0x00, 0x76, 0x00, 0x2E, 0x01, // v. (U+0076 U+002E)
  0x00, 0x76, 0x20, 0x1A, 0x01, // v‚ (U+0076 U+201A)
  0x00, 0x76, 0x20, 0x1E, 0x01, // v„ (U+0076 U+201E)
  0x00, 0x76, 0x20, 0x26, 0x01, // v… (U+0076 U+2026)
  0x00, 0x77, 0x00, 0x2C, 0x01, // w, (U+0077 U+002C)
  0x00, 0x77, 0x00, 0x2E, 0x01, // w. (U+0077 U+002E)
  0x00, 0x77, 0x20, 0x1A, 0x01, // w‚ (U+0077 U+201A)
  0x00, 0x77, 0x20, 0x1E, 0x01, // w„ (U+0077 U+201E)
  0x00, 0x77, 0x20, 0x26, 0x01, // w… (U+0077 U+2026)
  0x00, 0x79, 0x00, 0x2C, 0x01, // y, (U+0079 U+002C)
  0x00, 0x79, 0x00, 0x2E, 0x01, // y. (U+0079 U+002E)
  0x00, 0x79, 0x20, 0x1A, 0x01, // y‚ (U+0079 U+201A)
  0x00, 0x79, 0x20, 0x1E, 0x01, // y„ (U+0079 U+201E)
  0x00, 0x79, 0x20, 0x26, 0x01, // y… (U+0079 U+2026)
  0x00, 0xA1, 0x00, 0x54, 0x01, // ¡T (U+00A1 U+0054)
  0x00, 0xA1, 0x00, 0x59, 0x01, // ¡Y (U+00A1 U+0059)
  0x00, 0xA1, 0x00, 0xDD, 0x01, // ¡Ý (U+00A1 U+00DD)
  0x00, 0xA1, 0x01, 0x62, 0x01, // ¡Ţ (U+00A1 U+0162)
  0x00, 0xA1, 0x01, 0x64, 0x01, // ¡Ť (U+00A1 U+0164)
  0x00, 0xA1, 0x01, 0x66, 0x01, // ¡Ŧ (U+00A1 U+0166)
  0x00, 0xA1, 0x01, 0x76, 0x01, // ¡Ŷ (U+00A1 U+0176)
  0x00, 0xA1, 0x01, 0x78, 0x01, // ¡Ÿ (U+00A1 U+0178)
  0x00, 0xAB, 0x00, 0x54, 0x01, // «T (U+00AB U+0054)
  0x00, 0xAB, 0x00, 0x56, 0x01, // «V (U+00AB U+0056)
  0x00, 0xAB, 0x00, 0x57, 0x01, // «W (U+00AB U+0057)
  0x00, 0xAB, 0x00, 0x59, 0x02, // «Y (U+00AB U+0059)
  0x00, 0xAB, 0x00, 0xDD, 0x02, // «Ý (U+00AB U+00DD)
  0x00, 0xAB, 0x01, 0x62, 0x01, // «Ţ (U+00AB U+0162)
  0x00, 0xAB, 0x01, 0x64, 0x01, // «Ť (U+00AB U+0164)
  0x00, 0xAB, 0x01, 0x66, 0x01, // «Ŧ (U+00AB U+0166)
  0x00, 0xAB, 0x01, 0x74, 0x01, // «Ŵ (U+00AB U+0174)
  0x00, 0xAB, 0x01, 0x76, 0x02, // «Ŷ (U+00AB U+0176)
  0x00, 0xAB, 0x01, 0x78, 0x02, // «Ÿ (U+00AB U+0178)
  0x00, 0xBB, 0x00, 0x54, 0x02, // »T (U+00BB U+0054)
  0x00, 0xBB, 0x00, 0x56, 0x01, // »V (U+00BB U+0056)
  0x00, 0xBB, 0x00, 0x57, 0x01, // »W (U+00BB U+0057)
  0x00, 0xBB, 0x00, 0x59, 0x02, // »Y (U+00BB U+0059)
  0x00, 0xBB, 0x00, 0xDD, 0x02, // »Ý (U+00BB U+00DD)
  0x00, 0xBB, 0x01, 0x62, 0x02, // »Ţ (U+00BB U+0162)
  0x00, 0xBB, 0x01, 0x64, 0x02, // »Ť (U+00BB U+0164)
  0x00, 0xBB, 0x01, 0x66, 0x02, // »Ŧ (U+00BB U+0166)
  0x00, 0xBB, 0x01, 0x74, 0x01, // »Ŵ (U+00BB U+0174)
  0x00, 0xBB, 0x01, 0x76, 0x02, // »Ŷ (U+00BB U+0176)
  0x00, 0xBB, 0x01, 0x78, 0x02, // »Ÿ (U+00BB U+0178)
  0x00, 0xBF, 0x00, 0x54, 0x01, // ¿T (U+00BF U+0054)
  0x00, 0xBF, 0x00, 0x59, 0x01, // ¿Y (U+00BF U+0059)
  0x00, 0xBF, 0x00, 0xDD, 0x01, // ¿Ý (U+00BF U+00DD)
  0x00, 0xBF, 0x01, 0x62, 0x01, // ¿Ţ (U+00BF U+0162)
  0x00, 0xBF, 0x01, 0x64, 0x01, // ¿Ť (U+00BF U+0164)
  0x00, 0xBF, 0x01, 0x66, 0x01, // ¿Ŧ (U+00BF U+0166)
  0x00, 0xBF, 0x01, 0x76, 0x01, // ¿Ŷ (U+00BF U+0176)
  0x00, 0xBF, 0x01, 0x78, 0x01, // ¿Ÿ (U+00BF U+0178)
  0x00, 0xC0, 0x00, 0x22, 0x02, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x02, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x00, 0x43, 0x01, // ÀC (U+00C0 U+0043)
  0x00, 0xC0, 0x00, 0x47, 0x01, // ÀG (U+00C0 U+0047)
  0x00, 0xC0, 0x00, 0x4F, 0x01, // ÀO (U+00C0 U+004F)
  0x00, 0xC0, 0x00, 0x51, 0x01, // ÀQ (U+00C0 U+0051)
  0x00, 0xC0, 0x00, 0x54, 0x01, // ÀT (U+00C0 U+0054)
  0x00, 0xC0, 0x00, 0x59, 0x01, // ÀY (U+00C0 U+0059)
  0x00, 0xC0, 0x00, 0xC7, 0x01, // ÀÇ (U+00C0 U+00C7)
  0x00, 0xC0, 0x00, 0xD2, 0x01, // ÀÒ (U+00C0 U+00D2)
  0x00, 0xC0, 0x00, 0xD3, 0x01, // ÀÓ (U+00C0 U+00D3)
  0x00, 0xC0, 0x00, 0xD4, 0x01, // ÀÔ (U+00C0 U+00D4)
  0x00, 0xC0, 0x00, 0xD5, 0x01, // ÀÕ (U+00C0 U+00D5)
  0x00, 0xC0, 0x00, 0xD6, 0x01, // ÀÖ (U+00C0 U+00D6)
  0x00, 0xC0, 0x00, 0xD8, 0x01, // ÀØ (U+00C0 U+00D8)
  0x00, 0xC0, 0x00, 0xDD, 0x01, // ÀÝ (U+00C0 U+00DD)
  0x00, 0xC0, 0x01, 0x06, 0x01, // ÀĆ (U+00C0 U+0106)
  0x00, 0xC0, 0x01, 0x08, 0x01, // ÀĈ (U+00C0 U+0108)
  0x00, 0xC0, 0x01, 0x0A, 0x01, // ÀĊ (U+00C0 U+010A)
  0x00, 0xC0, 0x01, 0x0C, 0x01, // ÀČ (U+00C0 U+010C)
  0x00, 0xC0, 0x01, 0x1C, 0x01, // ÀĜ (U+00C0 U+011C)
  0x00, 0xC0, 0x01, 0x1E, 0x01, // ÀĞ (U+00C0 U+011E)
  0x00, 0xC0, 0x01, 0x20, 0x01, // ÀĠ (U+00C0 U+0120)
  0x00, 0xC0, 0x01, 0x22, 0x01, // ÀĢ (U+00C0 U+0122)
  0x00, 0xC0, 0x01, 0x4C, 0x01, // ÀŌ (U+00C0 U+014C)
  0x00, 0xC0, 0x01, 0x4E, 0x01, // ÀŎ (U+00C0 U+014E)
  0x00, 0xC0, 0x01, 0x50, 0x01, // ÀŐ (U+00C0 U+0150)
  0x00, 0xC0, 0x01, 0x52, 0x01, // ÀŒ (U+00C0 U+0152)
  0x00, 0xC0, 0x01, 0x62, 0x01, // ÀŢ (U+00C0 U+0162)
  0x00, 0xC0, 0x01, 0x64, 0x01, // ÀŤ (U+00C0 U+0164)
  0x00, 0xC0, 0x01, 0x66, 0x01, // ÀŦ (U+00C0 U+0166)
  0x00, 0xC0, 0x01, 0x76, 0x01, // ÀŶ (U+00C0 U+0176)
  0x00, 0xC0, 0x01, 0x78, 0x01, // ÀŸ (U+00C0 U+0178)
  0x00, 0xC0, 0x20, 0x19, 0x02, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1D, 0x02, // À” (U+00C0 U+201D)
  0x00, 0xC1, 0x00, 0x22, 0x02, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x02, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x00, 0x43, 0x01, // ÁC (U+00C1 U+0043)
  0x00, 0xC1, 0x00, 0x47, 0x01, // ÁG (U+00C1 U+0047)
  0x00, 0xC1, 0x00, 0x4F, 0x01, // ÁO (U+00C1 U+004F)
  0x00, 0xC1, 0x00, 0x51, 0x01, // ÁQ (U+00C1 U+0051)
  0x00, 0xC1, 0x00, 0x54, 0x01, // ÁT (U+00C1 U+0054)
  0x00, 0xC1, 0x00, 0x59, 0x01, // ÁY (U+00C1 U+0059)
  0x00, 0xC1, 0x00, 0xC7, 0x01, // ÁÇ (U+00C1 U+00C7)
  0x00, 0xC1, 0x00, 0xD2, 0x01, // ÁÒ (U+00C1 U+00D2)
  0x00, 0xC1, 0x00, 0xD3, 0x01, // ÁÓ (U+00C1 U+00D3)
  0x00, 0xC1, 0x00, 0xD4, 0x01, // ÁÔ (U+00C1 U+00D4)
  0x00, 0xC1, 0x00, 0xD5, 0x01, // ÁÕ (U+00C1 U+00D5)
  0x00, 0xC1, 0x00, 0xD6, 0x01, // ÁÖ (U+00C1 U+00D6)
  0x00, 0xC1, 0x00, 0xD8, 0x01, // ÁØ (U+00C1 U+00D8)
  0x00, 0xC1, 0x00, 0xDD, 0x01, // ÁÝ (U+00C1 U+00DD)
  0x00, 0xC1, 0x01, 0x06, 0x01, // ÁĆ (U+00C1 U+0106)
  0x00, 0xC1, 0x01, 0x08, 0x01, // ÁĈ (U+00C1 U+0108)
  0x00, 0xC1, 0x01, 0x0A, 0x01, // ÁĊ (U+00C1 U+010A)
  0x00, 0xC1, 0x01, 0x0C, 0x01, // ÁČ (U+00C1 U+010C)
  0x00, 0xC1, 0x01, 0x1C, 0x01, // ÁĜ (U+00C1 U+011C)
  0x00, 0xC1, 0x01, 0x1E, 0x01, // ÁĞ (U+00C1 U+011E)
  0x00, 0xC1, 0x01, 0x20, 0x01, // ÁĠ (U+00C1 U+0120)
  0x00, 0xC1, 0x01, 0x22, 0x01, // ÁĢ (U+00C1 U+0122)
  0x00, 0xC1, 0x01, 0x4C, 0x01, // ÁŌ (U+00C1 U+014C)
  0x00, 0xC1, 0x01, 0x4E, 0x01, // ÁŎ (U+00C1 U+014E)
  0x00, 0xC1, 0x01, 0x50, 0x01, // ÁŐ (U+00C1 U+0150)
  0x00, 0xC1, 0x01, 0x52, 0x01, // ÁŒ (U+00C1 U+0152)
  0x00, 0xC1, 0x01, 0x62, 0x01, // ÁŢ (U+00C1 U+0162)
  0x00, 0xC1, 0x01, 0x64, 0x01, // ÁŤ (U+00C1 U+0164)
  0x00, 0xC1, 0x01, 0x66, 0x01, // ÁŦ (U+00C1 U+0166)
  0x00, 0xC1, 0x01, 0x76, 0x01, // ÁŶ (U+00C1 U+0176)
  0x00, 0xC1, 0x01, 0x78, 0x01, // ÁŸ (U+00C1 U+0178)
  0x00, 0xC1, 0x20, 0x19, 0x02, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1D, 0x02, // Á” (U+00C1 U+201D)
  0x00, 0xC2, 0x00, 0x22, 0x02, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x02, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x00, 0x43, 0x01, // ÂC (U+00C2 U+0043)
  0x00, 0xC2, 0x00, 0x47, 0x01, // ÂG (U+00C2 U+0047)
  0x00, 0xC2, 0x00, 0x4F, 0x01, // ÂO (U+00C2 U+004F)
  0x00, 0xC2, 0x00, 0x51, 0x01, // ÂQ (U+00C2 U+0051)
  0x00, 0xC2, 0x00, 0x54, 0x01, // ÂT (U+00C2 U+0054)
  0x00, 0xC2, 0x00, 0x59, 0x01, // ÂY (U+00C2 U+0059)
  0x00, 0xC2, 0x00, 0xC7, 0x01, // ÂÇ (U+00C2 U+00C7)
  0x00, 0xC2, 0x00, 0xD2, 0x01, // ÂÒ (U+00C2 U+00D2)
  0x00, 0xC2, 0x00, 0xD3, 0x01, // ÂÓ (U+00C2 U+00D3)
  0x00, 0xC2, 0x00, 0xD4, 0x01, // ÂÔ (U+00C2 U+00D4)
  0x00, 0xC2, 0x00, 0xD5, 0x01, // ÂÕ (U+00C2 U+00D5)
  0x00, 0xC2, 0x00, 0xD6, 0x01, // ÂÖ (U+00C2 U+00D6)
  0x00, 0xC2, 0x00, 0xD8, 0x01, // ÂØ (U+00C2 U+00D8)
  0x00, 0xC2, 0x00, 0xDD, 0x01, // ÂÝ (U+00C2 U+00DD)
  0x00, 0xC2, 0x01, 0x06, 0x01, // ÂĆ (U+00C2 U+0106)
  0x00, 0xC2, 0x01, 0x08, 0x01, // ÂĈ (U+00C2 U+0108)
  0x00, 0xC2, 0x01, 0x0A, 0x01, // ÂĊ (U+00C2 U+010A)
  0x00, 0xC2, 0x01, 0x0C, 0x01, // ÂČ (U+00C2 U+010C)
  0x00, 0xC2, 0x01, 0x1C, 0x01, // ÂĜ (U+00C2 U+011C)
  0x00, 0xC2, 0x01, 0x1E, 0x01, // ÂĞ (U+00C2 U+011E)
  0x00, 0xC2, 0x01, 0x20, 0x01, // ÂĠ (U+00C2 U+0120)
  0x00, 0xC2, 0x01, 0x22, 0x01, // ÂĢ (U+00C2 U+0122)
  0x00, 0xC2, 0x01, 0x4C, 0x01, // ÂŌ (U+00C2 U+014C)
  0x00, 0xC2, 0x01, 0x4E, 0x01, // ÂŎ (U+00C2 U+014E)
  0x00, 0xC2, 0x01, 0x50, 0x01, // ÂŐ (U+00C2 U+0150)
  0x00, 0xC2, 0x01, 0x52, 0x01, // ÂŒ (U+00C2 U+0152)
  0x00, 0xC2, 0x01, 0x62, 0x01, // ÂŢ (U+00C2 U+0162)
  0x00, 0xC2, 0x01, 0x64, 0x01, // ÂŤ (U+00C2 U+0164)
  0x00, 0xC2, 0x01, 0x66, 0x01, // ÂŦ (U+00C2 U+0166)
  0x00, 0xC2, 0x01, 0x76, 0x01, // ÂŶ (U+00C2 U+0176)
  0x00, 0xC2, 0x01, 0x78, 0x01, // ÂŸ (U+00C2 U+0178)
  0x00, 0xC2, 0x20, 0x19, 0x02, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1D, 0x02, // Â” (U+00C2 U+201D)
  0x00, 0xC3, 0x00, 0x22, 0x02, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x02, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x00, 0x43, 0x01, // ÃC (U+00C3 U+0043)
  0x00, 0xC3, 0x00, 0x47, 0x01, // ÃG (U+00C3 U+0047)
  0x00, 0xC3, 0x00, 0x4F, 0x01, // ÃO (U+00C3 U+004F)
  0x00, 0xC3, 0x00, 0x51, 0x01, // ÃQ (U+00C3 U+0051)
  0x00, 0xC3, 0x00, 0x54, 0x01, // ÃT (U+00C3 U+0054)
  0x00, 0xC3, 0x00, 0x59, 0x01, // ÃY (U+00C3 U+0059)
  0x00, 0xC3, 0x00, 0xC7, 0x01, // ÃÇ (U+00C3 U+00C7)
  0x00, 0xC3, 0x00, 0xD2, 0x01, // ÃÒ (U+00C3 U+00D2)
  0x00, 0xC3, 0x00, 0xD3, 0x01, // ÃÓ (U+00C3 U+00D3)
  0x00, 0xC3, 0x00, 0xD4, 0x01, // ÃÔ (U+00C3 U+00D4)
  0x00, 0xC3, 0x00, 0xD5, 0x01, // ÃÕ (U+00C3 U+00D5)
  0x00, 0xC3, 0x00, 0xD6, 0x01, // ÃÖ (U+00C3 U+00D6)
  0x00, 0xC3, 0x00, 0xD8, 0x01, // ÃØ (U+00C3 U+00D8)
  0x00, 0xC3, 0x00, 0xDD, 0x01, // ÃÝ (U+00C3 U+00DD)
  0x00, 0xC3, 0x01, 0x06, 0x01, // ÃĆ (U+00C3 U+0106)
  0x00, 0xC3, 0x01, 0x08, 0x01, // ÃĈ (U+00C3 U+0108)
  0x00, 0xC3, 0x01, 0x0A, 0x01, // ÃĊ (U+00C3 U+010A)
  0x00, 0xC3, 0x01, 0x0C, 0x01, // ÃČ (U+00C3 U+010C)
  0x00, 0xC3, 0x01, 0x1C, 0x01, // ÃĜ (U+00C3 U+011C)
  0x00, 0xC3, 0x01, 0x1E, 0x01, // ÃĞ (U+00C3 U+011E)
  0x00, 0xC3, 0x01, 0x20, 0x01, // ÃĠ (U+00C3 U+0120)
  0x00, 0xC3, 0x01, 0x22, 0x01, // ÃĢ (U+00C3 U+0122)
  0x00, 0xC3, 0x01, 0x4C, 0x01, // ÃŌ (U+00C3 U+014C)
  0x00, 0xC3, 0x01, 0x4E, 0x01, // ÃŎ (U+00C3 U+014E)
  0x00, 0xC3, 0x01, 0x50, 0x01, // ÃŐ (U+00C3 U+0150)
  0x00, 0xC3, 0x01, 0x52, 0x01, // ÃŒ (U+00C3 U+0152)
  0x00, 0xC3, 0x01, 0x62, 0x01, // ÃŢ (U+00C3 U+0162)
  0x00, 0xC3, 0x01, 0x64, 0x01, // ÃŤ (U+00C3 U+0164)
  0x00, 0xC3, 0x01, 0x66, 0x01, // ÃŦ (U+00C3 U+0166)
  0x00, 0xC3, 0x01, 0x76, 0x01, // ÃŶ (U+00C3 U+0176)
  0x00, 0xC3, 0x01, 0x78, 0x01, // ÃŸ (U+00C3 U+0178)
  0x00, 0xC3, 0x20, 0x19, 0x02, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1D, 0x02, // Ã” (U+00C3 U+201D)
  0x00, 0xC4, 0x00, 0x22, 0x02, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x02, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x00, 0x43, 0x01, // ÄC (U+00C4 U+0043)
  0x00, 0xC4, 0x00, 0x47, 0x01, // ÄG (U+00C4 U+0047)
  0x00, 0xC4, 0x00, 0x4F, 0x01, // ÄO (U+00C4 U+004F)
  0x00, 0xC4, 0x00, 0x51, 0x01, // ÄQ (U+00C4 U+0051)
  0x00, 0xC4, 0x00, 0x54, 0x01, // ÄT (U+00C4 U+0054)
  0x00, 0xC4, 0x00, 0x59, 0x01, // ÄY (U+00C4 U+0059)
  0x00, 0xC4, 0x00, 0xC7, 0x01, // ÄÇ (U+00C4 U+00C7)
  0x00, 0xC4, 0x00, 0xD2, 0x01, // ÄÒ (U+00C4 U+00D2)
  0x00, 0xC4, 0x00, 0xD3, 0x01, // ÄÓ (U+00C4 U+00D3)
  0x00, 0xC4, 0x00, 0xD4, 0x01, // ÄÔ (U+00C4 U+00D4)
  0x00, 0xC4, 0x00, 0xD5, 0x01, // ÄÕ (U+00C4 U+00D5)
  0x00, 0xC4, 0x00, 0xD6, 0x01, // ÄÖ (U+00C4 U+00D6)
  0x00, 0xC4, 0x00, 0xD8, 0x01, // ÄØ (U+00C4 U+00D8)
  0x00, 0xC4, 0x00, 0xDD, 0x01, // ÄÝ (U+00C4 U+00DD)
  0x00, 0xC4, 0x01, 0x06, 0x01, // ÄĆ (U+00C4 U+0106)
  0x00, 0xC4, 0x01, 0x08, 0x01, // ÄĈ (U+00C4 U+0108)
  0x00, 0xC4, 0x01, 0x0A, 0x01, // ÄĊ (U+00C4 U+010A)
  0x00, 0xC4, 0x01, 0x0C, 0x01, // ÄČ (U+00C4 U+010C)
  0x00, 0xC4, 0x01, 0x1C, 0x01, // ÄĜ (U+00C4 U+011C)
  0x00, 0xC4, 0x01, 0x1E, 0x01, // ÄĞ (U+00C4 U+011E)
  0x00, 0xC4, 0x01, 0x20, 0x01, // ÄĠ (U+00C4 U+0120)
  0x00, 0xC4, 0x01, 0x22, 0x01, // ÄĢ (U+00C4 U+0122)
  0x00, 0xC4, 0x01, 0x4C, 0x01, // ÄŌ (U+00C4 U+014C)
  0x00, 0xC4, 0x01, 0x4E, 0x01, // ÄŎ (U+00C4 U+014E)
  0x00, 0xC4, 0x01, 0x50, 0x01, // ÄŐ (U+00C4 U+0150)
  0x00, 0xC4, 0x01, 0x52, 0x01, // ÄŒ (U+00C4 U+0152)
  0x00, 0xC4, 0x01, 0x62, 0x01, // ÄŢ (U+00C4 U+0162)
  0x00, 0xC4, 0x01, 0x64, 0x01, // ÄŤ (U+00C4 U+0164)
  0x00, 0xC4, 0x01, 0x66, 0x01, // ÄŦ (U+00C4 U+0166)
  0x00, 0xC4, 0x01, 0x76, 0x01, // ÄŶ (U+00C4 U+0176)
  0x00, 0xC4, 0x01, 0x78, 0x01, // ÄŸ (U+00C4 U+0178)
  0x00, 0xC4, 0x20, 0x19, 0x02, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1D, 0x02, // Ä” (U+00C4 U+201D)
  0x00, 0xC5, 0x00, 0x22, 0x02, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x02, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x00, 0x43, 0x01, // ÅC (U+00C5 U+0043)
  0x00, 0xC5, 0x00, 0x47, 0x01, // ÅG (U+00C5 U+0047)
  0x00, 0xC5, 0x00, 0x4F, 0x01, // ÅO (U+00C5 U+004F)
  0x00, 0xC5, 0x00, 0x51, 0x01, // ÅQ (U+00C5 U+0051)
  0x00, 0xC5, 0x00, 0x54, 0x01, // ÅT (U+00C5 U+0054)
  0x00, 0xC5, 0x00, 0x59, 0x01, // ÅY (U+00C5 U+0059)
  0x00, 0xC5, 0x00, 0xC7, 0x01, // ÅÇ (U+00C5 U+00C7)
  0x00, 0xC5, 0x00, 0xD2, 0x01, // ÅÒ (U+00C5 U+00D2)
  0x00, 0xC5, 0x00, 0xD3, 0x01, // ÅÓ (U+00C5 U+00D3)
  0x00, 0xC5, 0x00, 0xD4, 0x01, // ÅÔ (U+00C5 U+00D4)
  0x00, 0xC5, 0x00, 0xD5, 0x01, // ÅÕ (U+00C5 U+00D5)
  0x00, 0xC5, 0x00, 0xD6, 0x01, // ÅÖ (U+00C5 U+00D6)
  0x00, 0xC5, 0x00, 0xD8, 0x01, // ÅØ (U+00C5 U+00D8)
  0x00, 0xC5, 0x00, 0xDD, 0x01, // ÅÝ (U+00C5 U+00DD)
  0x00, 0xC5, 0x01, 0x06, 0x01, // ÅĆ (U+00C5 U+0106)
  0x00, 0xC5, 0x01, 0x08, 0x01, // ÅĈ (U+00C5 U+0108)
  0x00, 0xC5, 0x01, 0x0A, 0x01, // ÅĊ (U+00C5 U+010A)
  0x00, 0xC5, 0x01, 0x0C, 0x01, // ÅČ (U+00C5 U+010C)
  0x00, 0xC5, 0x01, 0x1C, 0x01, // ÅĜ (U+00C5 U+011C)
  0x00, 0xC5, 0x01, 0x1E, 0x01, // ÅĞ (U+00C5 U+011E)
  0x00, 0xC5, 0x01, 0x20, 0x01, // ÅĠ (U+00C5 U+0120)
  0x00, 0xC5, 0x01, 0x22, 0x01, // ÅĢ (U+00C5 U+0122)
  0x00, 0xC5, 0x01, 0x4C, 0x01, // ÅŌ (U+00C5 U+014C)
  0x00, 0xC5, 0x01, 0x4E, 0x01, // ÅŎ (U+00C5 U+014E)
  0x00, 0xC5, 0x01, 0x50, 0x01, // ÅŐ (U+00C5 U+0150)
  0x00, 0xC5, 0x01, 0x52, 0x01, // ÅŒ (U+00C5 U+0152)
  0x00, 0xC5, 0x01, 0x62, 0x01, // ÅŢ (U+00C5 U+0162)
  0x00, 0xC5, 0x01, 0x64, 0x01, // ÅŤ (U+00C5 U+0164)
  0x00, 0xC5, 0x01, 0x66, 0x01, // ÅŦ (U+00C5 U+0166)
  0x00, 0xC5, 0x01, 0x76, 0x01, // ÅŶ (U+00C5 U+0176)
  0x00, 0xC5, 0x01, 0x78, 0x01, // ÅŸ (U+00C5 U+0178)
  0x00, 0xC5, 0x20, 0x19, 0x02, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1D, 0x02, // Å” (U+00C5 U+201D)
  0x00, 0xC7, 0x00, 0x43, 0x01, // ÇC (U+00C7 U+0043)
  0x00, 0xC7, 0x00, 0x47, 0x01, // ÇG (U+00C7 U+0047)
  0x00, 0xC7, 0x00, 0x4F, 0x01, // ÇO (U+00C7 U+004F)
  0x00, 0xC7, 0x00, 0x51, 0x01, // ÇQ (U+00C7 U+0051)
  0x00, 0xC7, 0x00, 0xAB, 0x01, // Ç« (U+00C7 U+00AB)
  0x00, 0xC7, 0x00, 0xC7, 0x01, // ÇÇ (U+00C7 U+00C7)
  0x00, 0xC7, 0x00, 0xD2, 0x01, // ÇÒ (U+00C7 U+00D2)
  0x00, 0xC7, 0x00, 0xD3, 0x01, // ÇÓ (U+00C7 U+00D3)
  0x00, 0xC7, 0x00, 0xD4, 0x01, // ÇÔ (U+00C7 U+00D4)
  0x00, 0xC7, 0x00, 0xD5, 0x01, // ÇÕ (U+00C7 U+00D5)
  0x00, 0xC7, 0x00, 0xD6, 0x01, // ÇÖ (U+00C7 U+00D6)
  0x00, 0xC7, 0x00, 0xD8, 0x01, // ÇØ (U+00C7 U+00D8)
  0x00, 0xC7, 0x01, 0x06, 0x01, // ÇĆ (U+00C7 U+0106)
  0x00, 0xC7, 0x01, 0x08, 0x01, // ÇĈ (U+00C7 U+0108)
  0x00, 0xC7, 0x01, 0x0A, 0x01, // ÇĊ (U+00C7 U+010A)
  0x00, 0xC7, 0x01, 0x0C, 0x01, // ÇČ (U+00C7 U+010C)
  0x00, 0xC7, 0x01, 0x1C, 0x01, // ÇĜ (U+00C7 U+011C)
  0x00, 0xC7, 0x01, 0x1E, 0x01, // ÇĞ (U+00C7 U+011E)
  0x00, 0xC7, 0x01, 0x20, 0x01, // ÇĠ (U+00C7 U+0120)
  0x00, 0xC7, 0x01, 0x22, 0x01, // ÇĢ (U+00C7 U+0122)
  0x00, 0xC7, 0x01, 0x4C, 0x01, // ÇŌ (U+00C7 U+014C)
  0x00, 0xC7, 0x01, 0x4E, 0x01, // ÇŎ (U+00C7 U+014E)
  0x00, 0xC7, 0x01, 0x50, 0x01, // ÇŐ (U+00C7 U+0150)
  0x00, 0xC7, 0x01, 0x52, 0x01, // ÇŒ (U+00C7 U+0152)
  0x00, 0xC7, 0x20, 0x39, 0x01, // Ç‹ (U+00C7 U+2039)
  0x00, 0xD0, 0x00, 0x2C, 0x02, // Ð, (U+00D0 U+002C)
  0x00, 0xD0, 0x00, 0x2E, 0x02, // Ð. (U+00D0 U+002E)
  0x00, 0xD0, 0x00, 0x54, 0x01, // ÐT (U+00D0 U+0054)
  0x00, 0xD0, 0x00, 0x58, 0x01, // ÐX (U+00D0 U+0058)
  0x00, 0xD0, 0x01, 0x62, 0x01, // ÐŢ (U+00D0 U+0162)
  0x00, 0xD0, 0x01, 0x64, 0x01, // ÐŤ (U+00D0 U+0164)
  0x00, 0xD0, 0x01, 0x66, 0x01, // ÐŦ (U+00D0 U+0166)
  0x00, 0xD0, 0x20, 0x1A, 0x02, // Ð‚ (U+00D0 U+201A)
  0x00, 0xD0, 0x20, 0x1E, 0x02, // Ð„ (U+00D0 U+201E)
  0x00, 0xD0, 0x20, 0x26, 0x02, // Ð… (U+00D0 U+2026)
  0x00, 0xD2, 0x00, 0x2C, 0x02, // Ò, (U+00D2 U+002C)
  0x00, 0xD2, 0x00, 0x2E, 0x02, // Ò. (U+00D2 U+002E)
  0x00, 0xD2, 0x00, 0x54, 0x01, // ÒT (U+00D2 U+0054)
  0x00, 0xD2, 0x00, 0x58, 0x01, // ÒX (U+00D2 U+0058)
  0x00, 0xD2, 0x01, 0x62, 0x01, // ÒŢ (U+00D2 U+0162)
  0x00, 0xD2, 0x01, 0x64, 0x01, // ÒŤ (U+00D2 U+0164)
  0x00, 0xD2, 0x01, 0x66, 0x01, // ÒŦ (U+00D2 U+0166)
  0x00, 0xD2, 0x20, 0x1A, 0x02, // Ò‚ (U+00D2 U+201A)
  0x00, 0xD2, 0x20, 0x1E, 0x02, // Ò„ (U+00D2 U+201E)
  0x00, 0xD2, 0x20, 0x26, 0x02, // Ò… (U+00D2 U+2026)
  0x00, 0xD3, 0x00, 0x2C, 0x02, // Ó, (U+00D3 U+002C)
  0x00, 0xD3, 0x00, 0x2E, 0x02, // Ó. (U+00D3 U+002E)
  0x00, 0xD3, 0x00, 0x54, 0x01, // ÓT (U+00D3 U+0054)
  0x00, 0xD3, 0x00, 0x58, 0x01, // ÓX (U+00D3 U+0058)
  0x00, 0xD3, 0x01, 0x62, 0x01, // ÓŢ (U+00D3 U+0162)
  0x00, 0xD3, 0x01, 0x64, 0x01, // ÓŤ (U+00D3 U+0164)
  0x00, 0xD3, 0x01, 0x66, 0x01, // ÓŦ (U+00D3 U+0166)
  0x00, 0xD3, 0x20, 0x1A, 0x02, // Ó‚ (U+00D3 U+201A)
  0x00, 0xD3, 0x20, 0x1E, 0x02, // Ó„ (U+00D3 U+201E)
  0x00, 0xD3, 0x20, 0x26, 0x02, // Ó… (U+00D3 U+2026)
  0x00, 0xD4, 0x00, 0x2C, 0x02, // Ô, (U+00D4 U+002C)
  0x00, 0xD4, 0x00, 0x2E, 0x02, // Ô. (U+00D4 U+002E)
  0x00, 0xD4, 0x00, 0x54, 0x01, // ÔT (U+00D4 U+0054)
  0x00, 0xD4, 0x00, 0x58, 0x01, // ÔX (U+00D4 U+0058)
  0x00, 0xD4, 0x01, 0x62, 0x01, // ÔŢ (U+00D4 U+0162)
  0x00, 0xD4, 0x01, 0x64, 0x01, // ÔŤ (U+00D4 U+0164)
  0x00, 0xD4, 0x01, 0x66, 0x01, // ÔŦ (U+00D4 U+0166)
  0x00, 0xD4, 0x20, 0x1A, 0x02, // Ô‚ (U+00D4 U+201A)
  0x00, 0xD4, 0x20, 0x1E, 0x02, // Ô„ (U+00D4 U+201E)
  0x00, 0xD4, 0x20, 0x26, 0x02, // Ô… (U+00D4 U+2026)
  0x00, 0xD5, 0x00, 0x2C, 0x02, // Õ, (U+00D5 U+002C)
  0x00, 0xD5, 0x00, 0x2E, 0x02, // Õ. (U+00D5 U+002E)
  0x00, 0xD5, 0x00, 0x54, 0x01, // ÕT (U+00D5 U+0054)
  0x00, 0xD5, 0x00, 0x58, 0x01, // ÕX (U+00D5 U+0058)
  0x00, 0xD5, 0x01, 0x62, 0x01, // ÕŢ (U+00D5 U+0162)
  0x00, 0xD5, 0x01, 0x64, 0x01, // ÕŤ (U+00D5 U+0164)
  0x00, 0xD5, 0x01, 0x66, 0x01, // ÕŦ (U+00D5 U+0166)
  0x00, 0xD5, 0x20, 0x1A, 0x02, // Õ‚ (U+00D5 U+201A)
  0x00, 0xD5, 0x20, 0x1E, 0x02, // Õ„ (U+00D5 U+201E)
  0x00, 0xD5, 0x20, 0x26, 0x02, // Õ… (U+00D5 U+2026)
  0x00, 0xD6, 0x00, 0x2C, 0x02, // Ö, (U+00D6 U+002C)
  0x00, 0xD6, 0x00, 0x2E, 0x02, // Ö. (U+00D6 U+002E)
  0x00, 0xD6, 0x00, 0x54, 0x01, // ÖT (U+00D6 U+0054)
  0x00, 0xD6, 0x00, 0x58, 0x01, // ÖX (U+00D6 U+0058)
  0x00, 0xD6, 0x01, 0x62, 0x01, // ÖŢ (U+00D6 U+0162)
  0x00, 0xD6, 0x01, 0x64, 0x01, // ÖŤ (U+00D6 U+0164)
  0x00, 0xD6, 0x01, 0x66, 0x01, // ÖŦ (U+00D6 U+0166)
  0x00, 0xD6, 0x20, 0x1A, 0x02, // Ö‚ (U+00D6 U+201A)
  0x00, 0xD6, 0x20, 0x1E, 0x02, // Ö„ (U+00D6 U+201E)
  0x00, 0xD6, 0x20, 0x26, 0x02, // Ö… (U+00D6 U+2026)
  0x00, 0xD8, 0x00, 0x2C, 0x02, // Ø, (U+00D8 U+002C)
  0x00, 0xD8, 0x00, 0x2E, 0x02, // Ø. (U+00D8 U+002E)
  0x00, 0xD8, 0x00, 0x54, 0x01, // ØT (U+00D8 U+0054)
  0x00, 0xD8, 0x00, 0x58, 0x01, // ØX (U+00D8 U+0058)
  0x00, 0xD8, 0x01, 0x62, 0x01, // ØŢ (U+00D8 U+0162)
  0x00, 0xD8, 0x01, 0x64, 0x01, // ØŤ (U+00D8 U+0164)
  0x00, 0xD8, 0x01, 0x66, 0x01, // ØŦ (U+00D8 U+0166)
  0x00, 0xD8, 0x20, 0x1A, 0x02, // Ø‚ (U+00D8 U+201A)
  0x00, 0xD8, 0x20, 0x1E, 0x02, // Ø„ (U+00D8 U+201E)
  0x00, 0xD8, 0x20, 0x26, 0x02, // Ø… (U+00D8 U+2026)
  0x00, 0xD9, 0x00, 0x2C, 0x01, // Ù, (U+00D9 U+002C)
  0x00, 0xD9, 0x00, 0x2E, 0x01, // Ù. (U+00D9 U+002E)
  0x00, 0xD9, 0x20, 0x1A, 0x01, // Ù‚ (U+00D9 U+201A)
  0x00, 0xD9, 0x20, 0x1E, 0x01, // Ù„ (U+00D9 U+201E)
  0x00, 0xD9, 0x20, 0x26, 0x01, // Ù… (U+00D9 U+2026)
  0x00, 0xDA, 0x00, 0x2C, 0x01, // Ú, (U+00DA U+002C)
  0x00, 0xDA, 0x00, 0x2E, 0x01, // Ú. (U+00DA U+002E)
  0x00, 0xDA, 0x20, 0x1A, 0x01, // Ú‚ (U+00DA U+201A)
  0x00, 0xDA, 0x20, 0x1E, 0x01, // Ú„ (U+00DA U+201E)
  0x00, 0xDA, 0x20, 0x26, 0x01, // Ú… (U+00DA U+2026)
  0x00, 0xDB, 0x00, 0x2C, 0x01, // Û, (U+00DB U+002C)
  0x00, 0xDB, 0x00, 0x2E, 0x01, // Û. (U+00DB U+002E)
  0x00, 0xDB, 0x20, 0x1A, 0x01, // Û‚ (U+00DB U+201A)
  0x00, 0xDB, 0x20, 0x1E, 0x01, // Û„ (U+00DB U+201E)
  0x00, 0xDB, 0x20, 0x26, 0x01, // Û… (U+00DB U+2026)
  0x00, 0xDC, 0x00, 0x2C, 0x01, // Ü, (U+00DC U+002C)
  0x00, 0xDC, 0x00, 0x2E, 0x01, // Ü. (U+00DC U+002E)
  0x00, 0xDC, 0x20, 0x1A, 0x01, // Ü‚ (U+00DC U+201A)
  0x00, 0xDC, 0x20, 0x1E, 0x01, // Ü„ (U+00DC U+201E)
  0x00, 0xDC, 0x20, 0x26, 0x01, // Ü… (U+00DC U+2026)
  0x00, 0xDD, 0x00, 0x26, 0x01, // Ý& (U+00DD U+0026)
  0x00, 0xDD, 0x00, 0x2C, 0x02, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x02, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x00, 0x41, 0x01, // ÝA (U+00DD U+0041)
  0x00, 0xDD, 0x00, 0x43, 0x01, // ÝC (U+00DD U+0043)
  0x00, 0xDD, 0x00, 0x47, 0x01, // ÝG (U+00DD U+0047)
  0x00, 0xDD, 0x00, 0x4F, 0x01, // ÝO (U+00DD U+004F)
  0x00, 0xDD, 0x00, 0x51, 0x01, // ÝQ (U+00DD U+0051)
  0x00, 0xDD, 0x00, 0x61, 0x01, // Ýa (U+00DD U+0061)
  0x00, 0xDD, 0x00, 0x63, 0x01, // Ýc (U+00DD U+0063)
  0x00, 0xDD, 0x00, 0x64, 0x01, // Ýd (U+00DD U+0064)
  0x00, 0xDD, 0x00, 0x65, 0x01, // Ýe (U+00DD U+0065)
  0x00, 0xDD, 0x00, 0x67, 0x01, // Ýg (U+00DD U+0067)
  0x00, 0xDD, 0x00, 0x6D, 0x01, // Ým (U+00DD U+006D)
  0x00, 0xDD, 0x00, 0x6E, 0x01, // Ýn (U+00DD U+006E)
  0x00, 0xDD, 0x00, 0x6F, 0x01, // Ýo (U+00DD U+006F)
  0x00, 0xDD, 0x00, 0x70, 0x01, // Ýp (U+00DD U+0070)
  0x00, 0xDD, 0x00, 0x71, 0x01, // Ýq (U+00DD U+0071)
  0x00, 0xDD, 0x00, 0x72, 0x01, // Ýr (U+00DD U+0072)
  0x00, 0xDD, 0x00, 0x73, 0x01, // Ýs (U+00DD U+0073)
  0x00, 0xDD, 0x00, 0x75, 0x01, // Ýu (U+00DD U+0075)
  0x00, 0xDD, 0x00, 0x7A, 0x01, // Ýz (U+00DD U+007A)
  0x00, 0xDD, 0x00, 0xAB, 0x02, // Ý« (U+00DD U+00AB)
  0x00, 0xDD, 0x00, 0xBB, 0x02, // Ý» (U+00DD U+00BB)
  0x00, 0xDD, 0x00, 0xC0, 0x01, // ÝÀ (U+00DD U+00C0)
  0x00, 0xDD, 0x00, 0xC1, 0x01, // ÝÁ (U+00DD U+00C1)
  0x00, 0xDD, 0x00, 0xC2, 0x01, // ÝÂ (U+00DD U+00C2)
  0x00, 0xDD, 0x00, 0xC3, 0x01, // ÝÃ (U+00DD U+00C3)
  0x00, 0xDD, 0x00, 0xC4, 0x01, // ÝÄ (U+00DD U+00C4)
  0x00, 0xDD, 0x00, 0xC5, 0x01, // ÝÅ (U+00DD U+00C5)
  0x00, 0xDD, 0x00, 0xC6, 0x01, // ÝÆ (U+00DD U+00C6)
  0x00, 0xDD, 0x00, 0xC7, 0x01, // ÝÇ (U+00DD U+00C7)
  0x00, 0xDD, 0x00, 0xD2, 0x01, // ÝÒ (U+00DD U+00D2)
  0x00, 0xDD, 0x00, 0xD3, 0x01, // ÝÓ (U+00DD U+00D3)
  0x00, 0xDD, 0x00, 0xD4, 0x01, // ÝÔ (U+00DD U+00D4)
  0x00, 0xDD, 0x00, 0xD5, 0x01, // ÝÕ (U+00DD U+00D5)
  0x00, 0xDD, 0x00, 0xD6, 0x01, // ÝÖ (U+00DD U+00D6)
  0x00, 0xDD, 0x00, 0xD8, 0x01, // ÝØ (U+00DD U+00D8)
  0x00, 0xDD, 0x00, 0xE0, 0x01, // Ýà (U+00DD U+00E0)
  0x00, 0xDD, 0x00, 0xE1, 0x01, // Ýá (U+00DD U+00E1)
  0x00, 0xDD, 0x00, 0xE2, 0x01, // Ýâ (U+00DD U+00E2)
  0x00, 0xDD, 0x00, 0xE3, 0x01, // Ýã (U+00DD U+00E3)
  0x00, 0xDD, 0x00, 0xE4, 0x01, // Ýä (U+00DD U+00E4)
  0x00, 0xDD, 0x00, 0xE5, 0x01, // Ýå (U+00DD U+00E5)
  0x00, 0xDD, 0x00, 0xE6, 0x01, // Ýæ (U+00DD U+00E6)
  0x00, 0xDD, 0x00, 0xE7, 0x01, // Ýç (U+00DD U+00E7)
  0x00, 0xDD, 0x00, 0xE8, 0x01, // Ýè (U+00DD U+00E8)
  0x00, 0xDD, 0x00, 0xE9, 0x01, // Ýé (U+00DD U+00E9)
  0x00, 0xDD, 0x00, 0xEA, 0x01, // Ýê (U+00DD U+00EA)
  0x00, 0xDD, 0x00, 0xEB, 0x01, // Ýë (U+00DD U+00EB)
  0x00, 0xDD, 0x00, 0xF1, 0x01, // Ýñ (U+00DD U+00F1)
  0x00, 0xDD, 0x00, 0xF2, 0x01, // Ýò (U+00DD U+00F2)
  0x00, 0xDD, 0x00, 0xF3, 0x01, // Ýó (U+00DD U+00F3)
  0x00, 0xDD, 0x00, 0xF4, 0x01, // Ýô (U+00DD U+00F4)
  0x00, 0xDD, 0x00, 0xF5, 0x01, // Ýõ (U+00DD U+00F5)
  0x00, 0xDD, 0x00, 0xF6, 0x01, // Ýö (U+00DD U+00F6)
  0x00, 0xDD, 0x00, 0xF8, 0x01, // Ýø (U+00DD U+00F8)
  0x00, 0xDD, 0x00, 0xF9, 0x01, // Ýù (U+00DD U+00F9)
  0x00, 0xDD, 0x00, 0xFA, 0x01, // Ýú (U+00DD U+00FA)
  0x00, 0xDD, 0x00, 0xFB, 0x01, // Ýû (U+00DD U+00FB)
  0x00, 0xDD, 0x00, 0xFC, 0x01, // Ýü (U+00DD U+00FC)
  0x00, 0xDD, 0x01, 0x00, 0x01, // ÝĀ (U+00DD U+0100)
  0x00, 0xDD, 0x01, 0x01, 0x01, // Ýā (U+00DD U+0101)
  0x00, 0xDD, 0x01, 0x02, 0x01, // ÝĂ (U+00DD U+0102)
  0x00, 0xDD, 0x01, 0x03, 0x01, // Ýă (U+00DD U+0103)
  0x00, 0xDD, 0x01, 0x04, 0x01, // ÝĄ (U+00DD U+0104)
  0x00, 0xDD, 0x01, 0x05, 0x01, // Ýą (U+00DD U+0105)
  0x00, 0xDD, 0x01, 0x06, 0x01, // ÝĆ (U+00DD U+0106)
  0x00, 0xDD, 0x01, 0x07, 0x01, // Ýć (U+00DD U+0107)
  0x00, 0xDD, 0x01, 0x08, 0x01, // ÝĈ (U+00DD U+0108)
  0x00, 0xDD, 0x01, 0x09, 0x01, // Ýĉ (U+00DD U+0109)
  0x00, 0xDD, 0x01, 0x0A, 0x01, // ÝĊ (U+00DD U+010A)
  0x00, 0xDD, 0x01, 0x0B, 0x01, // Ýċ (U+00DD U+010B)
  0x00, 0xDD, 0x01, 0x0C, 0x01, // ÝČ (U+00DD U+010C)
  0x00, 0xDD, 0x01, 0x0D, 0x01, // Ýč (U+00DD U+010D)
  0x00, 0xDD, 0x01, 0x0F, 0x01, // Ýď (U+00DD U+010F)
  0x00, 0xDD, 0x01, 0x11, 0x01, // Ýđ (U+00DD U+0111)
  0x00, 0xDD, 0x01, 0x13, 0x01, // Ýē (U+00DD U+0113)
  0x00, 0xDD, 0x01, 0x15, 0x01, // Ýĕ (U+00DD U+0115)
  0x00, 0xDD, 0x01, 0x17, 0x01, // Ýė (U+00DD U+0117)
  0x00, 0xDD, 0x01, 0x19, 0x01, // Ýę (U+00DD U+0119)
  0x00, 0xDD, 0x01, 0x1B, 0x01, // Ýě (U+00DD U+011B)
  0x00, 0xDD, 0x01, 0x1C, 0x01, // ÝĜ (U+00DD U+011C)
  0x00, 0xDD, 0x01, 0x1D, 0x01, // Ýĝ (U+00DD U+011D)
  0x00, 0xDD, 0x01, 0x1E, 0x01, // ÝĞ (U+00DD U+011E)
  0x00, 0xDD, 0x01, 0x1F, 0x01, // Ýğ (U+00DD U+011F)
  0x00, 0xDD, 0x01, 0x20, 0x01, // ÝĠ (U+00DD U+0120)
  0x00, 0xDD, 0x01, 0x21, 0x01, // Ýġ (U+00DD U+0121)
  0x00, 0xDD, 0x01, 0x22, 0x01, // ÝĢ (U+00DD U+0122)
  0x00, 0xDD, 0x01, 0x23, 0x01, // Ýģ (U+00DD U+0123)
  0x00, 0xDD, 0x01, 0x38, 0x01, // Ýĸ (U+00DD U+0138)
  0x00, 0xDD, 0x01, 0x44, 0x01, // Ýń (U+00DD U+0144)
  0x00, 0xDD, 0x01, 0x46, 0x01, // Ýņ (U+00DD U+0146)
  0x00, 0xDD, 0x01, 0x48, 0x01, // Ýň (U+00DD U+0148)
  0x00, 0xDD, 0x01, 0x4B, 0x01, // Ýŋ (U+00DD U+014B)
  0x00, 0xDD, 0x01, 0x4C, 0x01, // ÝŌ (U+00DD U+014C)
  0x00, 0xDD, 0x01, 0x4D, 0x01, // Ýō (U+00DD U+014D)
  0x00, 0xDD, 0x01, 0x4E, 0x01, // ÝŎ (U+00DD U+014E)
  0x00, 0xDD, 0x01, 0x4F, 0x01, // Ýŏ (U+00DD U+014F)
  0x00, 0xDD, 0x01, 0x50, 0x01, // ÝŐ (U+00DD U+0150)
  0x00, 0xDD, 0x01, 0x51, 0x01, // Ýő (U+00DD U+0151)
  0x00, 0xDD, 0x01, 0x52, 0x01, // ÝŒ (U+00DD U+0152)
  0x00, 0xDD, 0x01, 0x53, 0x01, // Ýœ (U+00DD U+0153)
  0x00, 0xDD, 0x01, 0x55, 0x01, // Ýŕ (U+00DD U+0155)
  0x00, 0xDD, 0x01, 0x57, 0x01, // Ýŗ (U+00DD U+0157)
  0x00, 0xDD, 0x01, 0x5B, 0x01, // Ýś (U+00DD U+015B)
  0x00, 0xDD, 0x01, 0x5D, 0x01, // Ýŝ (U+00DD U+015D)
  0x00, 0xDD, 0x01, 0x5F, 0x01, // Ýş (U+00DD U+015F)
  0x00, 0xDD, 0x01, 0x61, 0x01, // Ýš (U+00DD U+0161)
  0x00, 0xDD, 0x01, 0x69, 0x01, // Ýũ (U+00DD U+0169)
  0x00, 0xDD, 0x01, 0x6B, 0x01, // Ýū (U+00DD U+016B)
  0x00, 0xDD, 0x01, 0x6D, 0x01, // Ýŭ (U+00DD U+016D)
  0x00, 0xDD, 0x01, 0x6F, 0x01, // Ýů (U+00DD U+016F)
  0x00, 0xDD, 0x01, 0x71, 0x01, // Ýű (U+00DD U+0171)
  0x00, 0xDD, 0x01, 0x73, 0x01, // Ýų (U+00DD U+0173)
  0x00, 0xDD, 0x01, 0x7A, 0x01, // Ýź (U+00DD U+017A)
  0x00, 0xDD, 0x01, 0x7C, 0x01, // Ýż (U+00DD U+017C)
  0x00, 0xDD, 0x01, 0x7E, 0x01, // Ýž (U+00DD U+017E)
  0x00, 0xDD, 0x20, 0x1A, 0x02, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x02, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x02, // Ý… (U+00DD U+2026)
  0x00, 0xDD, 0x20, 0x39, 0x02, // Ý‹ (U+00DD U+2039)
  0x00, 0xDD, 0x20, 0x3A, 0x02, // Ý› (U+00DD U+203A)
  0x00, 0xDE, 0x00, 0x2C, 0x05, // Þ, (U+00DE U+002C)
  0x00, 0xDE, 0x00, 0x2E, 0x05, // Þ. (U+00DE U+002E)
  0x00, 0xDE, 0x00, 0x41, 0x01, // ÞA (U+00DE U+0041)
  0x00, 0xDE, 0x00, 0x58, 0x01, // ÞX (U+00DE U+0058)
  0x00, 0xDE, 0x00, 0xC0, 0x01, // ÞÀ (U+00DE U+00C0)
  0x00, 0xDE, 0x00, 0xC1, 0x01, // ÞÁ (U+00DE U+00C1)
  0x00, 0xDE, 0x00, 0xC2, 0x01, // ÞÂ (U+00DE U+00C2)
  0x00, 0xDE, 0x00, 0xC3, 0x01, // ÞÃ (U+00DE U+00C3)
  0x00, 0xDE, 0x00, 0xC4, 0x01, // ÞÄ (U+00DE U+00C4)
  0x00, 0xDE, 0x00, 0xC5, 0x01, // ÞÅ (U+00DE U+00C5)
  0x00, 0xDE, 0x01, 0x00, 0x01, // ÞĀ (U+00DE U+0100)
  0x00, 0xDE, 0x01, 0x02, 0x01, // ÞĂ (U+00DE U+0102)
  0x00, 0xDE, 0x01, 0x04, 0x01, // ÞĄ (U+00DE U+0104)
  0x00, 0xDE, 0x20, 0x1A, 0x05, // Þ‚ (U+00DE U+201A)
  0x00, 0xDE, 0x20, 0x1E, 0x05, // Þ„ (U+00DE U+201E)
  0x00, 0xDE, 0x20, 0x26, 0x05, // Þ… (U+00DE U+2026)
  0x00, 0xFD, 0x00, 0x2C, 0x01, // ý, (U+00FD U+002C)
  0x00, 0xFD, 0x00, 0x2E, 0x01, // ý. (U+00FD U+002E)
  0x00, 0xFD, 0x20, 0x1A, 0x01, // ý‚ (U+00FD U+201A)
  0x00, 0xFD, 0x20, 0x1E, 0x01, // ý„ (U+00FD U+201E)
  0x00, 0xFD, 0x20, 0x26, 0x01, // ý… (U+00FD U+2026)
  0x00, 0xFF, 0x00, 0x2C, 0x01, // ÿ, (U+00FF U+002C)
  0x00, 0xFF, 0x00, 0x2E, 0x01, // ÿ. (U+00FF U+002E)
  0x00, 0xFF, 0x20, 0x1A, 0x01, // ÿ‚ (U+00FF U+201A)
  0x00, 0xFF, 0x20, 0x1E, 0x01, // ÿ„ (U+00FF U+201E)
  0x00, 0xFF, 0x20, 0x26, 0x01, // ÿ… (U+00FF U+2026)
  0x01, 0x00, 0x00, 0x22, 0x02, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x02, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x00, 0x43, 0x01, // ĀC (U+0100 U+0043)
  0x01, 0x00, 0x00, 0x47, 0x01, // ĀG (U+0100 U+0047)
  0x01, 0x00, 0x00, 0x4F, 0x01, // ĀO (U+0100 U+004F)
  0x01, 0x00, 0x00, 0x51, 0x01, // ĀQ (U+0100 U+0051)
  0x01, 0x00, 0x00, 0x54, 0x01, // ĀT (U+0100 U+0054)
  0x01, 0x00, 0x00, 0x59, 0x01, // ĀY (U+0100 U+0059)
  0x01, 0x00, 0x00, 0xC7, 0x01, // ĀÇ (U+0100 U+00C7)
  0x01, 0x00, 0x00, 0xD2, 0x01, // ĀÒ (U+0100 U+00D2)
  0x01, 0x00, 0x00, 0xD3, 0x01, // ĀÓ (U+0100 U+00D3)
  0x01, 0x00, 0x00, 0xD4, 0x01, // ĀÔ (U+0100 U+00D4)
  0x01, 0x00, 0x00, 0xD5, 0x01, // ĀÕ (U+0100 U+00D5)
  0x01, 0x00, 0x00, 0xD6, 0x01, // ĀÖ (U+0100 U+00D6)
  0x01, 0x00, 0x00, 0xD8, 0x01, // ĀØ (U+0100 U+00D8)
  0x01, 0x00, 0x00, 0xDD, 0x01, // ĀÝ (U+0100 U+00DD)
  0x01, 0x00, 0x01, 0x06, 0x01, // ĀĆ (U+0100 U+0106)
  0x01, 0x00, 0x01, 0x08, 0x01, // ĀĈ (U+0100 U+0108)
  0x01, 0x00, 0x01, 0x0A, 0x01, // ĀĊ (U+0100 U+010A)
  0x01, 0x00, 0x01, 0x0C, 0x01, // ĀČ (U+0100 U+010C)
  0x01, 0x00, 0x01, 0x1C, 0x01, // ĀĜ (U+0100 U+011C)
  0x01, 0x00, 0x01, 0x1E, 0x01, // ĀĞ (U+0100 U+011E)
  0x01, 0x00, 0x01, 0x20, 0x01, // ĀĠ (U+0100 U+0120)
  0x01, 0x00, 0x01, 0x22, 0x01, // ĀĢ (U+0100 U+0122)
  0x01, 0x00, 0x01, 0x4C, 0x01, // ĀŌ (U+0100 U+014C)
  0x01, 0x00, 0x01, 0x4E, 0x01, // ĀŎ (U+0100 U+014E)
  0x01, 0x00, 0x01, 0x50, 0x01, // ĀŐ (U+0100 U+0150)
  0x01, 0x00, 0x01, 0x52, 0x01, // ĀŒ (U+0100 U+0152)
  0x01, 0x00, 0x01, 0x62, 0x01, // ĀŢ (U+0100 U+0162)
  0x01, 0x00, 0x01, 0x64, 0x01, // ĀŤ (U+0100 U+0164)
  0x01, 0x00, 0x01, 0x66, 0x01, // ĀŦ (U+0100 U+0166)
  0x01, 0x00, 0x01, 0x76, 0x01, // ĀŶ (U+0100 U+0176)
  0x01, 0x00, 0x01, 0x78, 0x01, // ĀŸ (U+0100 U+0178)
  0x01, 0x00, 0x20, 0x19, 0x02, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1D, 0x02, // Ā” (U+0100 U+201D)
  0x01, 0x02, 0x00, 0x22, 0x02, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x02, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x00, 0x43, 0x01, // ĂC (U+0102 U+0043)
  0x01, 0x02, 0x00, 0x47, 0x01, // ĂG (U+0102 U+0047)
  0x01, 0x02, 0x00, 0x4F, 0x01, // ĂO (U+0102 U+004F)
  0x01, 0x02, 0x00, 0x51, 0x01, // ĂQ (U+0102 U+0051)
  0x01, 0x02, 0x00, 0x54, 0x01, // ĂT (U+0102 U+0054)
  0x01, 0x02, 0x00, 0x59, 0x01, // ĂY (U+0102 U+0059)
  0x01, 0x02, 0x00, 0xC7, 0x01, // ĂÇ (U+0102 U+00C7)
  0x01, 0x02, 0x00, 0xD2, 0x01, // ĂÒ (U+0102 U+00D2)
  0x01, 0x02, 0x00, 0xD3, 0x01, // ĂÓ (U+0102 U+00D3)
  0x01, 0x02, 0x00, 0xD4, 0x01, // ĂÔ (U+0102 U+00D4)
  0x01, 0x02, 0x00, 0xD5, 0x01, // ĂÕ (U+0102 U+00D5)
  0x01, 0x02, 0x00, 0xD6, 0x01, // ĂÖ (U+0102 U+00D6)
  0x01, 0x02, 0x00, 0xD8, 0x01, // ĂØ (U+0102 U+00D8)
  0x01, 0x02, 0x00, 0xDD, 0x01, // ĂÝ (U+0102 U+00DD)
  0x01, 0x02, 0x01, 0x06, 0x01, // ĂĆ (U+0102 U+0106)
  0x01, 0x02, 0x01, 0x08, 0x01, // ĂĈ (U+0102 U+0108)
  0x01, 0x02, 0x01, 0x0A, 0x01, // ĂĊ (U+0102 U+010A)
  0x01, 0x02, 0x01, 0x0C, 0x01, // ĂČ (U+0102 U+010C)
  0x01, 0x02, 0x01, 0x1C, 0x01, // ĂĜ (U+0102 U+011C)
  0x01, 0x02, 0x01, 0x1E, 0x01, // ĂĞ (U+0102 U+011E)
  0x01, 0x02, 0x01, 0x20, 0x01, // ĂĠ (U+0102 U+0120)
  0x01, 0x02, 0x01, 0x22, 0x01, // ĂĢ (U+0102 U+0122)
  0x01, 0x02, 0x01, 0x4C, 0x01, // ĂŌ (U+0102 U+014C)
  0x01, 0x02, 0x01, 0x4E, 0x01, // ĂŎ (U+0102 U+014E)
  0x01, 0x02, 0x01, 0x50, 0x01, // ĂŐ (U+0102 U+0150)
  0x01, 0x02, 0x01, 0x52, 0x01, // ĂŒ (U+0102 U+0152)
  0x01, 0x02, 0x01, 0x62, 0x01, // ĂŢ (U+0102 U+0162)
  0x01, 0x02, 0x01, 0x64, 0x01, // ĂŤ (U+0102 U+0164)
  0x01, 0x02, 0x01, 0x66, 0x01, // ĂŦ (U+0102 U+0166)
  0x01, 0x02, 0x01, 0x76, 0x01, // ĂŶ (U+0102 U+0176)
  0x01, 0x02, 0x01, 0x78, 0x01, // ĂŸ (U+0102 U+0178)
  0x01, 0x02, 0x20, 0x19, 0x02, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1D, 0x02, // Ă” (U+0102 U+201D)
  0x01, 0x04, 0x00, 0x22, 0x02, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x02, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x00, 0x43, 0x01, // ĄC (U+0104 U+0043)
  0x01, 0x04, 0x00, 0x47, 0x01, // ĄG (U+0104 U+0047)
  0x01, 0x04, 0x00, 0x4F, 0x01, // ĄO (U+0104 U+004F)
  0x01, 0x04, 0x00, 0x51, 0x01, // ĄQ (U+0104 U+0051)
  0x01, 0x04, 0x00, 0x54, 0x01, // ĄT (U+0104 U+0054)
  0x01, 0x04, 0x00, 0x59, 0x01, // ĄY (U+0104 U+0059)
  0x01, 0x04, 0x00, 0xC7, 0x01, // ĄÇ (U+0104 U+00C7)
  0x01, 0x04, 0x00, 0xD2, 0x01, // ĄÒ (U+0104 U+00D2)
  0x01, 0x04, 0x00, 0xD3, 0x01, // ĄÓ (U+0104 U+00D3)
  0x01, 0x04, 0x00, 0xD4, 0x01, // ĄÔ (U+0104 U+00D4)
  0x01, 0x04, 0x00, 0xD5, 0x01, // ĄÕ (U+0104 U+00D5)
  0x01, 0x04, 0x00, 0xD6, 0x01, // ĄÖ (U+0104 U+00D6)
  0x01, 0x04, 0x00, 0xD8, 0x01, // ĄØ (U+0104 U+00D8)
  0x01, 0x04, 0x00, 0xDD, 0x01, // ĄÝ (U+0104 U+00DD)
  0x01, 0x04, 0x01, 0x06, 0x01, // ĄĆ (U+0104 U+0106)
  0x01, 0x04, 0x01, 0x08, 0x01, // ĄĈ (U+0104 U+0108)
  0x01, 0x04, 0x01, 0x0A, 0x01, // ĄĊ (U+0104 U+010A)
  0x01, 0x04, 0x01, 0x0C, 0x01, // ĄČ (U+0104 U+010C)
  0x01, 0x04, 0x01, 0x1C, 0x01, // ĄĜ (U+0104 U+011C)
  0x01, 0x04, 0x01, 0x1E, 0x01, // ĄĞ (U+0104 U+011E)
  0x01, 0x04, 0x01, 0x20, 0x01, // ĄĠ (U+0104 U+0120)
  0x01, 0x04, 0x01, 0x22, 0x01, // ĄĢ (U+0104 U+0122)
  0x01, 0x04, 0x01, 0x4C, 0x01, // ĄŌ (U+0104 U+014C)
  0x01, 0x04, 0x01, 0x4E, 0x01, // ĄŎ (U+0104 U+014E)
  0x01, 0x04, 0x01, 0x50, 0x01, // ĄŐ (U+0104 U+0150)
  0x01, 0x04, 0x01, 0x52, 0x01, // ĄŒ (U+0104 U+0152)
  0x01, 0x04, 0x01, 0x62, 0x01, // ĄŢ (U+0104 U+0162)
  0x01, 0x04, 0x01, 0x64, 0x01, // ĄŤ (U+0104 U+0164)
  0x01, 0x04, 0x01, 0x66, 0x01, // ĄŦ (U+0104 U+0166)
  0x01, 0x04, 0x01, 0x76, 0x01, // ĄŶ (U+0104 U+0176)
  0x01, 0x04, 0x01, 0x78, 0x01, // ĄŸ (U+0104 U+0178)
  0x01, 0x04, 0x20, 0x19, 0x02, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1D, 0x02, // Ą” (U+0104 U+201D)
  0x01, 0x06, 0x00, 0x43, 0x01, // ĆC (U+0106 U+0043)
  0x01, 0x06, 0x00, 0x47, 0x01, // ĆG (U+0106 U+0047)
  0x01, 0x06, 0x00, 0x4F, 0x01, // ĆO (U+0106 U+004F)
  0x01, 0x06, 0x00, 0x51, 0x01, // ĆQ (U+0106 U+0051)
  0x01, 0x06, 0x00, 0xAB, 0x01, // Ć« (U+0106 U+00AB)
  0x01, 0x06, 0x00, 0xC7, 0x01, // ĆÇ (U+0106 U+00C7)
  0x01, 0x06, 0x00, 0xD2, 0x01, // ĆÒ (U+0106 U+00D2)
  0x01, 0x06, 0x00, 0xD3, 0x01, // ĆÓ (U+0106 U+00D3)
  0x01, 0x06, 0x00, 0xD4, 0x01, // ĆÔ (U+0106 U+00D4)
  0x01, 0x06, 0x00, 0xD5, 0x01, // ĆÕ (U+0106 U+00D5)
  0x01, 0x06, 0x00, 0xD6, 0x01, // ĆÖ (U+0106 U+00D6)
  0x01, 0x06, 0x00, 0xD8, 0x01, // ĆØ (U+0106 U+00D8)
  0x01, 0x06, 0x01, 0x06, 0x01, // ĆĆ (U+0106 U+0106)
  0x01, 0x06, 0x01, 0x08, 0x01, // ĆĈ (U+0106 U+0108)
  0x01, 0x06, 0x01, 0x0A, 0x01, // ĆĊ (U+0106 U+010A)
  0x01, 0x06, 0x01, 0x0C, 0x01, // ĆČ (U+0106 U+010C)
  0x01, 0x06, 0x01, 0x1C, 0x01, // ĆĜ (U+0106 U+011C)
  0x01, 0x06, 0x01, 0x1E, 0x01, // ĆĞ (U+0106 U+011E)
  0x01, 0x06, 0x01, 0x20, 0x01, // ĆĠ (U+0106 U+0120)
  0x01, 0x06, 0x01, 0x22, 0x01, // ĆĢ (U+0106 U+0122)
  0x01, 0x06, 0x01, 0x4C, 0x01, // ĆŌ (U+0106 U+014C)
  0x01, 0x06, 0x01, 0x4E, 0x01, // ĆŎ (U+0106 U+014E)
  0x01, 0x06, 0x01, 0x50, 0x01, // ĆŐ (U+0106 U+0150)
  0x01, 0x06, 0x01, 0x52, 0x01, // ĆŒ (U+0106 U+0152)
  0x01, 0x06, 0x20, 0x39, 0x01, // Ć‹ (U+0106 U+2039)
  0x01, 0x08, 0x00, 0x43, 0x01, // ĈC (U+0108 U+0043)
  0x01, 0x08, 0x00, 0x47, 0x01, // ĈG (U+0108 U+0047)
  0x01, 0x08, 0x00, 0x4F, 0x01, // ĈO (U+0108 U+004F)
  0x01, 0x08, 0x00, 0x51, 0x01, // ĈQ (U+0108 U+0051)
  0x01, 0x08, 0x00, 0xAB, 0x01, // Ĉ« (U+0108 U+00AB)
  0x01, 0x08, 0x00, 0xC7, 0x01, // ĈÇ (U+0108 U+00C7)
  0x01, 0x08, 0x00, 0xD2, 0x01, // ĈÒ (U+0108 U+00D2)
  0x01, 0x08, 0x00, 0xD3, 0x01, // ĈÓ (U+0108 U+00D3)
  0x01, 0x08, 0x00, 0xD4, 0x01, // ĈÔ (U+0108 U+00D4)
  0x01, 0x08, 0x00, 0xD5, 0x01, // ĈÕ (U+0108 U+00D5)
  0x01, 0x08, 0x00, 0xD6, 0x01, // ĈÖ (U+0108 U+00D6)
  0x01, 0x08, 0x00, 0xD8, 0x01, // ĈØ (U+0108 U+00D8)
  0x01, 0x08, 0x01, 0x06, 0x01, // ĈĆ (U+0108 U+0106)
  0x01, 0x08, 0x01, 0x08, 0x01, // ĈĈ (U+0108 U+0108)
  0x01, 0x08, 0x01, 0x0A, 0x01, // ĈĊ (U+0108 U+010A)
  0x01, 0x08, 0x01, 0x0C, 0x01, // ĈČ (U+0108 U+010C)
  0x01, 0x08, 0x01, 0x1C, 0x01, // ĈĜ (U+0108 U+011C)
  0x01, 0x08, 0x01, 0x1E, 0x01, // ĈĞ (U+0108 U+011E)
  0x01, 0x08, 0x01, 0x20, 0x01, // ĈĠ (U+0108 U+0120)
  0x01, 0x08, 0x01, 0x22, 0x01, // ĈĢ (U+0108 U+0122)
  0x01, 0x08, 0x01, 0x4C, 0x01, // ĈŌ (U+0108 U+014C)
  0x01, 0x08, 0x01, 0x4E, 0x01, // ĈŎ (U+0108 U+014E)
  0x01, 0x08, 0x01, 0x50, 0x01, // ĈŐ (U+0108 U+0150)
  0x01, 0x08, 0x01, 0x52, 0x01, // ĈŒ (U+0108 U+0152)
  0x01, 0x08, 0x20, 0x39, 0x01, // Ĉ‹ (U+0108 U+2039)
  0x01, 0x0A, 0x00, 0x43, 0x01, // ĊC (U+010A U+0043)
  0x01, 0x0A, 0x00, 0x47, 0x01, // ĊG (U+010A U+0047)
  0x01, 0x0A, 0x00, 0x4F, 0x01, // ĊO (U+010A U+004F)
  0x01, 0x0A, 0x00, 0x51, 0x01, // ĊQ (U+010A U+0051)
  0x01, 0x0A, 0x00, 0xAB, 0x01, // Ċ« (U+010A U+00AB)
  0x01, 0x0A, 0x00, 0xC7, 0x01, // ĊÇ (U+010A U+00C7)
  0x01, 0x0A, 0x00, 0xD2, 0x01, // ĊÒ (U+010A U+00D2)
  0x01, 0x0A, 0x00, 0xD3, 0x01, // ĊÓ (U+010A U+00D3)
  0x01, 0x0A, 0x00, 0xD4, 0x01, // ĊÔ (U+010A U+00D4)
  0x01, 0x0A, 0x00, 0xD5, 0x01, // ĊÕ (U+010A U+00D5)
  0x01, 0x0A, 0x00, 0xD6, 0x01, // ĊÖ (U+010A U+00D6)
  0x01, 0x0A, 0x00, 0xD8, 0x01, // ĊØ (U+010A U+00D8)
  0x01, 0x0A, 0x01, 0x06, 0x01, // ĊĆ (U+010A U+0106)
  0x01, 0x0A, 0x01, 0x08, 0x01, // ĊĈ (U+010A U+0108)
  0x01, 0x0A, 0x01, 0x0A, 0x01, // ĊĊ (U+010A U+010A)
  0x01, 0x0A, 0x01, 0x0C, 0x01, // ĊČ (U+010A U+010C)
  0x01, 0x0A, 0x01, 0x1C, 0x01, // ĊĜ (U+010A U+011C)
  0x01, 0x0A, 0x01, 0x1E, 0x01, // ĊĞ (U+010A U+011E)
  0x01, 0x0A, 0x01, 0x20, 0x01, // ĊĠ (U+010A U+0120)
  0x01, 0x0A, 0x01, 0x22, 0x01, // ĊĢ (U+010A U+0122)
  0x01, 0x0A, 0x01, 0x4C, 0x01, // ĊŌ (U+010A U+014C)
  0x01, 0x0A, 0x01, 0x4E, 0x01, // ĊŎ (U+010A U+014E)
  0x01, 0x0A, 0x01, 0x50, 0x01, // ĊŐ (U+010A U+0150)
  0x01, 0x0A, 0x01, 0x52, 0x01, // ĊŒ (U+010A U+0152)
  0x01, 0x0A, 0x20, 0x39, 0x01, // Ċ‹ (U+010A U+2039)
  0x01, 0x0C, 0x00, 0x43, 0x01, // ČC (U+010C U+0043)
  0x01, 0x0C, 0x00, 0x47, 0x01, // ČG (U+010C U+0047)
  0x01, 0x0C, 0x00, 0x4F, 0x01, // ČO (U+010C U+004F)
  0x01, 0x0C, 0x00, 0x51, 0x01, // ČQ (U+010C U+0051)
  0x01, 0x0C, 0x00, 0xAB, 0x01, // Č« (U+010C U+00AB)
  0x01, 0x0C, 0x00, 0xC7, 0x01, // ČÇ (U+010C U+00C7)
  0x01, 0x0C, 0x00, 0xD2, 0x01, // ČÒ (U+010C U+00D2)
  0x01, 0x0C, 0x00, 0xD3, 0x01, // ČÓ (U+010C U+00D3)
  0x01, 0x0C, 0x00, 0xD4, 0x01, // ČÔ (U+010C U+00D4)
  0x01, 0x0C, 0x00, 0xD5, 0x01, // ČÕ (U+010C U+00D5)
  0x01, 0x0C, 0x00, 0xD6, 0x01, // ČÖ (U+010C U+00D6)
  0x01, 0x0C, 0x00, 0xD8, 0x01, // ČØ (U+010C U+00D8)
  0x01, 0x0C, 0x01, 0x06, 0x01, // ČĆ (U+010C U+0106)
  0x01, 0x0C, 0x01, 0x08, 0x01, // ČĈ (U+010C U+0108)
  0x01, 0x0C, 0x01, 0x0A, 0x01, // ČĊ (U+010C U+010A)
  0x01, 0x0C, 0x01, 0x0C, 0x01, // ČČ (U+010C U+010C)
  0x01, 0x0C, 0x01, 0x1C, 0x01, // ČĜ (U+010C U+011C)
  0x01, 0x0C, 0x01, 0x1E, 0x01, // ČĞ (U+010C U+011E)
  0x01, 0x0C, 0x01, 0x20, 0x01, // ČĠ (U+010C U+0120)
  0x01, 0x0C, 0x01, 0x22, 0x01, // ČĢ (U+010C U+0122)
  0x01, 0x0C, 0x01, 0x4C, 0x01, // ČŌ (U+010C U+014C)
  0x01, 0x0C, 0x01, 0x4E, 0x01, // ČŎ (U+010C U+014E)
  0x01, 0x0C, 0x01, 0x50, 0x01, // ČŐ (U+010C U+0150)
  0x01, 0x0C, 0x01, 0x52, 0x01, // ČŒ (U+010C U+0152)
  0x01, 0x0C, 0x20, 0x39, 0x01, // Č‹ (U+010C U+2039)
  0x01, 0x0E, 0x00, 0x2C, 0x02, // Ď, (U+010E U+002C)
  0x01, 0x0E, 0x00, 0x2E, 0x02, // Ď. (U+010E U+002E)
  0x01, 0x0E, 0x00, 0x54, 0x01, // ĎT (U+010E U+0054)
  0x01, 0x0E, 0x00, 0x58, 0x01, // ĎX (U+010E U+0058)
  0x01, 0x0E, 0x01, 0x62, 0x01, // ĎŢ (U+010E U+0162)
  0x01, 0x0E, 0x01, 0x64, 0x01, // ĎŤ (U+010E U+0164)
  0x01, 0x0E, 0x01, 0x66, 0x01, // ĎŦ (U+010E U+0166)
  0x01, 0x0E, 0x20, 0x1A, 0x02, // Ď‚ (U+010E U+201A)
  0x01, 0x0E, 0x20, 0x1E, 0x02, // Ď„ (U+010E U+201E)
  0x01, 0x0E, 0x20, 0x26, 0x02, // Ď… (U+010E U+2026)
  0x01, 0x10, 0x00, 0x2C, 0x02, // Đ, (U+0110 U+002C)
  0x01, 0x10, 0x00, 0x2E, 0x02, // Đ. (U+0110 U+002E)
  0x01, 0x10, 0x00, 0x54, 0x01, // ĐT (U+0110 U+0054)
  0x01, 0x10, 0x00, 0x58, 0x01, // ĐX (U+0110 U+0058)
  0x01, 0x10, 0x01, 0x62, 0x01, // ĐŢ (U+0110 U+0162)
  0x01, 0x10, 0x01, 0x64, 0x01, // ĐŤ (U+0110 U+0164)
  0x01, 0x10, 0x01, 0x66, 0x01, // ĐŦ (U+0110 U+0166)
  0x01, 0x10, 0x20, 0x1A, 0x02, // Đ‚ (U+0110 U+201A)
  0x01, 0x10, 0x20, 0x1E, 0x02, // Đ„ (U+0110 U+201E)
  0x01, 0x10, 0x20, 0x26, 0x02, // Đ… (U+0110 U+2026)
  0x01, 0x36, 0x00, 0x43, 0x01, // ĶC (U+0136 U+0043)
  0x01, 0x36, 0x00, 0x47, 0x01, // ĶG (U+0136 U+0047)
  0x01, 0x36, 0x00, 0x4F, 0x01, // ĶO (U+0136 U+004F)
  0x01, 0x36, 0x00, 0x51, 0x01, // ĶQ (U+0136 U+0051)
  0x01, 0x36, 0x00, 0xAB, 0x01, // Ķ« (U+0136 U+00AB)
  0x01, 0x36, 0x00, 0xC7, 0x01, // ĶÇ (U+0136 U+00C7)
  0x01, 0x36, 0x00, 0xD2, 0x01, // ĶÒ (U+0136 U+00D2)
  0x01, 0x36, 0x00, 0xD3, 0x01, // ĶÓ (U+0136 U+00D3)
  0x01, 0x36, 0x00, 0xD4, 0x01, // ĶÔ (U+0136 U+00D4)
  0x01, 0x36, 0x00, 0xD5, 0x01, // ĶÕ (U+0136 U+00D5)
  0x01, 0x36, 0x00, 0xD6, 0x01, // ĶÖ (U+0136 U+00D6)
  0x01, 0x36, 0x00, 0xD8, 0x01, // ĶØ (U+0136 U+00D8)
  0x01, 0x36, 0x01, 0x06, 0x01, // ĶĆ (U+0136 U+0106)
  0x01, 0x36, 0x01, 0x08, 0x01, // ĶĈ (U+0136 U+0108)
  0x01, 0x36, 0x01, 0x0A, 0x01, // ĶĊ (U+0136 U+010A)
  0x01, 0x36, 0x01, 0x0C, 0x01, // ĶČ (U+0136 U+010C)
  0x01, 0x36, 0x01, 0x1C, 0x01, // ĶĜ (U+0136 U+011C)
  0x01, 0x36, 0x01, 0x1E, 0x01, // ĶĞ (U+0136 U+011E)
  0x01, 0x36, 0x01, 0x20, 0x01, // ĶĠ (U+0136 U+0120)
  0x01, 0x36, 0x01, 0x22, 0x01, // ĶĢ (U+0136 U+0122)
  0x01, 0x36, 0x01, 0x4C, 0x01, // ĶŌ (U+0136 U+014C)
  0x01, 0x36, 0x01, 0x4E, 0x01, // ĶŎ (U+0136 U+014E)
  0x01, 0x36, 0x01, 0x50, 0x01, // ĶŐ (U+0136 U+0150)
  0x01, 0x36, 0x01, 0x52, 0x01, // ĶŒ (U+0136 U+0152)
  0x01, 0x36, 0x20, 0x39, 0x01, // Ķ‹ (U+0136 U+2039)
  0x01, 0x39, 0x00, 0x22, 0x03, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x03, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x00, 0x43, 0x01, // ĹC (U+0139 U+0043)
  0x01, 0x39, 0x00, 0x47, 0x01, // ĹG (U+0139 U+0047)
  0x01, 0x39, 0x00, 0x4F, 0x01, // ĹO (U+0139 U+004F)
  0x01, 0x39, 0x00, 0x51, 0x01, // ĹQ (U+0139 U+0051)
  0x01, 0x39, 0x00, 0x54, 0x02, // ĹT (U+0139 U+0054)
  0x01, 0x39, 0x00, 0x55, 0x01, // ĹU (U+0139 U+0055)
  0x01, 0x39, 0x00, 0x56, 0x01, // ĹV (U+0139 U+0056)
  0x01, 0x39, 0x00, 0x57, 0x01, // ĹW (U+0139 U+0057)
  0x01, 0x39, 0x00, 0x59, 0x02, // ĹY (U+0139 U+0059)
  0x01, 0x39, 0x00, 0xAB, 0x02, // Ĺ« (U+0139 U+00AB)
  0x01, 0x39, 0x00, 0xC7, 0x01, // ĹÇ (U+0139 U+00C7)
  0x01, 0x39, 0x00, 0xD2, 0x01, // ĹÒ (U+0139 U+00D2)
  0x01, 0x39, 0x00, 0xD3, 0x01, // ĹÓ (U+0139 U+00D3)
  0x01, 0x39, 0x00, 0xD4, 0x01, // ĹÔ (U+0139 U+00D4)
  0x01, 0x39, 0x00, 0xD5, 0x01, // ĹÕ (U+0139 U+00D5)
  0x01, 0x39, 0x00, 0xD6, 0x01, // ĹÖ (U+0139 U+00D6)
  0x01, 0x39, 0x00, 0xD8, 0x01, // ĹØ (U+0139 U+00D8)
  0x01, 0x39, 0x00, 0xD9, 0x01, // ĹÙ (U+0139 U+00D9)
  0x01, 0x39, 0x00, 0xDA, 0x01, // ĹÚ (U+0139 U+00DA)
  0x01, 0x39, 0x00, 0xDB, 0x01, // ĹÛ (U+0139 U+00DB)
  0x01, 0x39, 0x00, 0xDC, 0x01, // ĹÜ (U+0139 U+00DC)
  0x01, 0x39, 0x00, 0xDD, 0x02, // ĹÝ (U+0139 U+00DD)
  0x01, 0x39, 0x01, 0x06, 0x01, // ĹĆ (U+0139 U+0106)
  0x01, 0x39, 0x01, 0x08, 0x01, // ĹĈ (U+0139 U+0108)
  0x01, 0x39, 0x01, 0x0A, 0x01, // ĹĊ (U+0139 U+010A)
  0x01, 0x39, 0x01, 0x0C, 0x01, // ĹČ (U+0139 U+010C)
  0x01, 0x39, 0x01, 0x1C, 0x01, // ĹĜ (U+0139 U+011C)
  0x01, 0x39, 0x01, 0x1E, 0x01, // ĹĞ (U+0139 U+011E)
  0x01, 0x39, 0x01, 0x20, 0x01, // ĹĠ (U+0139 U+0120)
  0x01, 0x39, 0x01, 0x22, 0x01, // ĹĢ (U+0139 U+0122)
  0x01, 0x39, 0x01, 0x4C, 0x01, // ĹŌ (U+0139 U+014C)
  0x01, 0x39, 0x01, 0x4E, 0x01, // ĹŎ (U+0139 U+014E)
  0x01, 0x39, 0x01, 0x50, 0x01, // ĹŐ (U+0139 U+0150)
  0x01, 0x39, 0x01, 0x52, 0x01, // ĹŒ (U+0139 U+0152)
  0x01, 0x39, 0x01, 0x62, 0x02, // ĹŢ (U+0139 U+0162)
  0x01, 0x39, 0x01, 0x64, 0x02, // ĹŤ (U+0139 U+0164)
  0x01, 0x39, 0x01, 0x66, 0x02, // ĹŦ (U+0139 U+0166)
  0x01, 0x39, 0x01, 0x68, 0x01, // ĹŨ (U+0139 U+0168)
  0x01, 0x39, 0x01, 0x6A, 0x01, // ĹŪ (U+0139 U+016A)
  0x01, 0x39, 0x01, 0x6C, 0x01, // ĹŬ (U+0139 U+016C)
  0x01, 0x39, 0x01, 0x6E, 0x01, // ĹŮ (U+0139 U+016E)
  0x01, 0x39, 0x01, 0x70, 0x01, // ĹŰ (U+0139 U+0170)
  0x01, 0x39, 0x01, 0x72, 0x01, // ĹŲ (U+0139 U+0172)
  0x01, 0x39, 0x01, 0x74, 0x01, // ĹŴ (U+0139 U+0174)
  0x01, 0x39, 0x01, 0x76, 0x02, // ĹŶ (U+0139 U+0176)
  0x01, 0x39, 0x01, 0x78, 0x02, // ĹŸ (U+0139 U+0178)
  0x01, 0x39, 0x20, 0x19, 0x03, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1D, 0x03, // Ĺ” (U+0139 U+201D)
  0x01, 0x39, 0x20, 0x39, 0x02, // Ĺ‹ (U+0139 U+2039)
  0x01, 0x3B, 0x00, 0x22, 0x03, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x03, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x00, 0x43, 0x01, // ĻC (U+013B U+0043)
  0x01, 0x3B, 0x00, 0x47, 0x01, // ĻG (U+013B U+0047)
  0x01, 0x3B, 0x00, 0x4F, 0x01, // ĻO (U+013B U+004F)
  0x01, 0x3B, 0x00, 0x51, 0x01, // ĻQ (U+013B U+0051)
  0x01, 0x3B, 0x00, 0x54, 0x02, // ĻT (U+013B U+0054)
  0x01, 0x3B, 0x00, 0x55, 0x01, // ĻU (U+013B U+0055)
  0x01, 0x3B, 0x00, 0x56, 0x01, // ĻV (U+013B U+0056)
  0x01, 0x3B, 0x00, 0x57, 0x01, // ĻW (U+013B U+0057)
  0x01, 0x3B, 0x00, 0x59, 0x02, // ĻY (U+013B U+0059)
  0x01, 0x3B, 0x00, 0xAB, 0x02, // Ļ« (U+013B U+00AB)
  0x01, 0x3B, 0x00, 0xC7, 0x01, // ĻÇ (U+013B U+00C7)
  0x01, 0x3B, 0x00, 0xD2, 0x01, // ĻÒ (U+013B U+00D2)
  0x01, 0x3B, 0x00, 0xD3, 0x01, // ĻÓ (U+013B U+00D3)
  0x01, 0x3B, 0x00, 0xD4, 0x01, // ĻÔ (U+013B U+00D4)
  0x01, 0x3B, 0x00, 0xD5, 0x01, // ĻÕ (U+013B U+00D5)
  0x01, 0x3B, 0x00, 0xD6, 0x01, // ĻÖ (U+013B U+00D6)
  0x01, 0x3B, 0x00, 0xD8, 0x01, // ĻØ (U+013B U+00D8)
  0x01, 0x3B, 0x00, 0xD9, 0x01, // ĻÙ (U+013B U+00D9)
  0x01, 0x3B, 0x00, 0xDA, 0x01, // ĻÚ (U+013B U+00DA)
  0x01, 0x3B, 0x00, 0xDB, 0x01, // ĻÛ (U+013B U+00DB)
  0x01, 0x3B, 0x00, 0xDC, 0x01, // ĻÜ (U+013B U+00DC)
  0x01, 0x3B, 0x00, 0xDD, 0x02, // ĻÝ (U+013B U+00DD)
  0x01, 0x3B, 0x01, 0x06, 0x01, // ĻĆ (U+013B U+0106)
  0x01, 0x3B, 0x01, 0x08, 0x01, // ĻĈ (U+013B U+0108)
  0x01, 0x3B, 0x01, 0x0A, 0x01, // ĻĊ (U+013B U+010A)
  0x01, 0x3B, 0x01, 0x0C, 0x01, // ĻČ (U+013B U+010C)
  0x01, 0x3B, 0x01, 0x1C, 0x01, // ĻĜ (U+013B U+011C)
  0x01, 0x3B, 0x01, 0x1E, 0x01, // ĻĞ (U+013B U+011E)
  0x01, 0x3B, 0x01, 0x20, 0x01, // ĻĠ (U+013B U+0120)
  0x01, 0x3B, 0x01, 0x22, 0x01, // ĻĢ (U+013B U+0122)
  0x01, 0x3B, 0x01, 0x4C, 0x01, // ĻŌ (U+013B U+014C)
  0x01, 0x3B, 0x01, 0x4E, 0x01, // ĻŎ (U+013B U+014E)
  0x01, 0x3B, 0x01, 0x50, 0x01, // ĻŐ (U+013B U+0150)
  0x01, 0x3B, 0x01, 0x52, 0x01, // ĻŒ (U+013B U+0152)
  0x01, 0x3B, 0x01, 0x62, 0x02, // ĻŢ (U+013B U+0162)
  0x01, 0x3B, 0x01, 0x64, 0x02, // ĻŤ (U+013B U+0164)
  0x01, 0x3B, 0x01, 0x66, 0x02, // ĻŦ (U+013B U+0166)
  0x01, 0x3B, 0x01, 0x68, 0x01, // ĻŨ (U+013B U+0168)
  0x01, 0x3B, 0x01, 0x6A, 0x01, // ĻŪ (U+013B U+016A)
  0x01, 0x3B, 0x01, 0x6C, 0x01, // ĻŬ (U+013B U+016C)
  0x01, 0x3B, 0x01, 0x6E, 0x01, // ĻŮ (U+013B U+016E)
  0x01, 0x3B, 0x01, 0x70, 0x01, // ĻŰ (U+013B U+0170)
  0x01, 0x3B, 0x01, 0x72, 0x01, // ĻŲ (U+013B U+0172)
  0x01, 0x3B, 0x01, 0x74, 0x01, // ĻŴ (U+013B U+0174)
  0x01, 0x3B, 0x01, 0x76, 0x02, // ĻŶ (U+013B U+0176)
  0x01, 0x3B, 0x01, 0x78, 0x02, // ĻŸ (U+013B U+0178)
  0x01, 0x3B, 0x20, 0x19, 0x03, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1D, 0x03, // Ļ” (U+013B U+201D)
  0x01, 0x3B, 0x20, 0x39, 0x02, // Ļ‹ (U+013B U+2039)
  0x01, 0x3D, 0x00, 0x22, 0x03, // Ľ" (U+013D U+0022)
  0x01, 0x3D, 0x00, 0x27, 0x03, // Ľ' (U+013D U+0027)
  0x01, 0x3D, 0x00, 0x43, 0x01, // ĽC (U+013D U+0043)
  0x01, 0x3D, 0x00, 0x47, 0x01, // ĽG (U+013D U+0047)
  0x01, 0x3D, 0x00, 0x4F, 0x01, // ĽO (U+013D U+004F)
  0x01, 0x3D, 0x00, 0x51, 0x01, // ĽQ (U+013D U+0051)
  0x01, 0x3D, 0x00, 0x54, 0x02, // ĽT (U+013D U+0054)
  0x01, 0x3D, 0x00, 0x55, 0x01, // ĽU (U+013D U+0055)
  0x01, 0x3D, 0x00, 0x56, 0x01, // ĽV (U+013D U+0056)
  0x01, 0x3D, 0x00, 0x57, 0x01, // ĽW (U+013D U+0057)
  0x01, 0x3D, 0x00, 0x59, 0x02, // ĽY (U+013D U+0059)
  0x01, 0x3D, 0x00, 0xAB, 0x02, // Ľ« (U+013D U+00AB)
  0x01, 0x3D, 0x00, 0xC7, 0x01, // ĽÇ (U+013D U+00C7)
  0x01, 0x3D, 0x00, 0xD2, 0x01, // ĽÒ (U+013D U+00D2)
  0x01, 0x3D, 0x00, 0xD3, 0x01, // ĽÓ (U+013D U+00D3)
  0x01, 0x3D, 0x00, 0xD4, 0x01, // ĽÔ (U+013D U+00D4)
  0x01, 0x3D, 0x00, 0xD5, 0x01, // ĽÕ (U+013D U+00D5)
  0x01, 0x3D, 0x00, 0xD6, 0x01, // ĽÖ (U+013D U+00D6)
  0x01, 0x3D, 0x00, 0xD8, 0x01, // ĽØ (U+013D U+00D8)
  0x01, 0x3D, 0x00, 0xD9, 0x01, // ĽÙ (U+013D U+00D9)
  0x01, 0x3D, 0x00, 0xDA, 0x01, // ĽÚ (U+013D U+00DA)
  0x01, 0x3D, 0x00, 0xDB, 0x01, // ĽÛ (U+013D U+00DB)
  0x01, 0x3D, 0x00, 0xDC, 0x01, // ĽÜ (U+013D U+00DC)
  0x01, 0x3D, 0x00, 0xDD, 0x02, // ĽÝ (U+013D U+00DD)
  0x01, 0x3D, 0x01, 0x06, 0x01, // ĽĆ (U+013D U+0106)
  0x01, 0x3D, 0x01, 0x08, 0x01, // ĽĈ (U+013D U+0108)
  0x01, 0x3D, 0x01, 0x0A, 0x01, // ĽĊ (U+013D U+010A)
  0x01, 0x3D, 0x01, 0x0C, 0x01, // ĽČ (U+013D U+010C)
  0x01, 0x3D, 0x01, 0x1C, 0x01, // ĽĜ (U+013D U+011C)
  0x01, 0x3D, 0x01, 0x1E, 0x01, // ĽĞ (U+013D U+011E)
  0x01, 0x3D, 0x01, 0x20, 0x01, // ĽĠ (U+013D U+0120)
  0x01, 0x3D, 0x01, 0x22, 0x01, // ĽĢ (U+013D U+0122)
  0x01, 0x3D, 0x01, 0x4C, 0x01, // ĽŌ (U+013D U+014C)
  0x01, 0x3D, 0x01, 0x4E, 0x01, // ĽŎ (U+013D U+014E)
  0x01, 0x3D, 0x01, 0x50, 0x01, // ĽŐ (U+013D U+0150)
  0x01, 0x3D, 0x01, 0x52, 0x01, // ĽŒ (U+013D U+0152)
  0x01, 0x3D, 0x01, 0x62, 0x02, // ĽŢ (U+013D U+0162)
  0x01, 0x3D, 0x01, 0x64, 0x02, // ĽŤ (U+013D U+0164)
  0x01, 0x3D, 0x01, 0x66, 0x02, // ĽŦ (U+013D U+0166)
  0x01, 0x3D, 0x01, 0x68, 0x01, // ĽŨ (U+013D U+0168)
  0x01, 0x3D, 0x01, 0x6A, 0x01, // ĽŪ (U+013D U+016A)
  0x01, 0x3D, 0x01, 0x6C, 0x01, // ĽŬ (U+013D U+016C)
  0x01, 0x3D, 0x01, 0x6E, 0x01, // ĽŮ (U+013D U+016E)
  0x01, 0x3D, 0x01, 0x70, 0x01, // ĽŰ (U+013D U+0170)
  0x01, 0x3D, 0x01, 0x72, 0x01, // ĽŲ (U+013D U+0172)
  0x01, 0x3D, 0x01, 0x74, 0x01, // ĽŴ (U+013D U+0174)
  0x01, 0x3D, 0x01, 0x76, 0x02, // ĽŶ (U+013D U+0176)
  0x01, 0x3D, 0x01, 0x78, 0x02, // ĽŸ (U+013D U+0178)
  0x01, 0x3D, 0x20, 0x19, 0x03, // Ľ’ (U+013D U+2019)
  0x01, 0x3D, 0x20, 0x1D, 0x03, // Ľ” (U+013D U+201D)
  0x01, 0x3D, 0x20, 0x39, 0x02, // Ľ‹ (U+013D U+2039)
  0x01, 0x3F, 0x00, 0x22, 0x03, // Ŀ" (U+013F U+0022)
  0x01, 0x3F, 0x00, 0x27, 0x03, // Ŀ' (U+013F U+0027)
  0x01, 0x3F, 0x00, 0x43, 0x01, // ĿC (U+013F U+0043)
  0x01, 0x3F, 0x00, 0x47, 0x01, // ĿG (U+013F U+0047)
  0x01, 0x3F, 0x00, 0x4F, 0x01, // ĿO (U+013F U+004F)
  0x01, 0x3F, 0x00, 0x51, 0x01, // ĿQ (U+013F U+0051)
  0x01, 0x3F, 0x00, 0x54, 0x02, // ĿT (U+013F U+0054)
  0x01, 0x3F, 0x00, 0x55, 0x01, // ĿU (U+013F U+0055)
  0x01, 0x3F, 0x00, 0x56, 0x01, // ĿV (U+013F U+0056)
  0x01, 0x3F, 0x00, 0x57, 0x01, // ĿW (U+013F U+0057)
  0x01, 0x3F, 0x00, 0x59, 0x02, // ĿY (U+013F U+0059)
  0x01, 0x3F, 0x00, 0xAB, 0x02, // Ŀ« (U+013F U+00AB)
  0x01, 0x3F, 0x00, 0xC7, 0x01, // ĿÇ (U+013F U+00C7)
  0x01, 0x3F, 0x00, 0xD2, 0x01, // ĿÒ (U+013F U+00D2)
  0x01, 0x3F, 0x00, 0xD3, 0x01, // ĿÓ (U+013F U+00D3)
  0x01, 0x3F, 0x00, 0xD4, 0x01, // ĿÔ (U+013F U+00D4)
  0x01, 0x3F, 0x00, 0xD5, 0x01, // ĿÕ (U+013F U+00D5)
  0x01, 0x3F, 0x00, 0xD6, 0x01, // ĿÖ (U+013F U+00D6)
  0x01, 0x3F, 0x00, 0xD8, 0x01, // ĿØ (U+013F U+00D8)
  0x01, 0x3F, 0x00, 0xD9, 0x01, // ĿÙ (U+013F U+00D9)
  0x01, 0x3F, 0x00, 0xDA, 0x01, // ĿÚ (U+013F U+00DA)
  0x01, 0x3F, 0x00, 0xDB, 0x01, // ĿÛ (U+013F U+00DB)
  0x01, 0x3F, 0x00, 0xDC, 0x01, // ĿÜ (U+013F U+00DC)
  0x01, 0x3F, 0x00, 0xDD, 0x02, // ĿÝ (U+013F U+00DD)
  0x01, 0x3F, 0x01, 0x06, 0x01, // ĿĆ (U+013F U+0106)
  0x01, 0x3F, 0x01, 0x08, 0x01, // ĿĈ (U+013F U+0108)
  0x01, 0x3F, 0x01, 0x0A, 0x01, // ĿĊ (U+013F U+010A)
  0x01, 0x3F, 0x01, 0x0C, 0x01, // ĿČ (U+013F U+010C)
  0x01, 0x3F, 0x01, 0x1C, 0x01, // ĿĜ (U+013F U+011C)
  0x01, 0x3F, 0x01, 0x1E, 0x01, // ĿĞ (U+013F U+011E)
  0x01, 0x3F, 0x01, 0x20, 0x01, // ĿĠ (U+013F U+0120)
  0x01, 0x3F, 0x01, 0x22, 0x01, // ĿĢ (U+013F U+0122)
  0x01, 0x3F, 0x01, 0x4C, 0x01, // ĿŌ (U+013F U+014C)
  0x01, 0x3F, 0x01, 0x4E, 0x01, // ĿŎ (U+013F U+014E)
  0x01, 0x3F, 0x01, 0x50, 0x01, // ĿŐ (U+013F U+0150)
  0x01, 0x3F, 0x01, 0x52, 0x01, // ĿŒ (U+013F U+0152)
  0x01, 0x3F, 0x01, 0x62, 0x02, // ĿŢ (U+013F U+0162)
  0x01, 0x3F, 0x01, 0x64, 0x02, // ĿŤ (U+013F U+0164)
  0x01, 0x3F, 0x01, 0x66, 0x02, // ĿŦ (U+013F U+0166)
  0x01, 0x3F, 0x01, 0x68, 0x01, // ĿŨ (U+013F U+0168)
  0x01, 0x3F, 0x01, 0x6A, 0x01, // ĿŪ (U+013F U+016A)
  0x01, 0x3F, 0x01, 0x6C, 0x01, // ĿŬ (U+013F U+016C)
  0x01, 0x3F, 0x01, 0x6E, 0x01, // ĿŮ (U+013F U+016E)
  0x01, 0x3F, 0x01, 0x70, 0x01, // ĿŰ (U+013F U+0170)
  0x01, 0x3F, 0x01, 0x72, 0x01, // ĿŲ (U+013F U+0172)
  0x01, 0x3F, 0x01, 0x74, 0x01, // ĿŴ (U+013F U+0174)
  0x01, 0x3F, 0x01, 0x76, 0x02, // ĿŶ (U+013F U+0176)
  0x01, 0x3F, 0x01, 0x78, 0x02, // ĿŸ (U+013F U+0178)
  0x01, 0x3F, 0x20, 0x19, 0x03, // Ŀ’ (U+013F U+2019)
  0x01, 0x3F, 0x20, 0x1D, 0x03, // Ŀ” (U+013F U+201D)
  0x01, 0x3F, 0x20, 0x39, 0x02, // Ŀ‹ (U+013F U+2039)
  0x01, 0x41, 0x00, 0x22, 0x03, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x03, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x00, 0x43, 0x01, // ŁC (U+0141 U+0043)
  0x01, 0x41, 0x00, 0x47, 0x01, // ŁG (U+0141 U+0047)
  0x01, 0x41, 0x00, 0x4F, 0x01, // ŁO (U+0141 U+004F)
  0x01, 0x41, 0x00, 0x51, 0x01, // ŁQ (U+0141 U+0051)
  0x01, 0x41, 0x00, 0x54, 0x02, // ŁT (U+0141 U+0054)
  0x01, 0x41, 0x00, 0x55, 0x01, // ŁU (U+0141 U+0055)
  0x01, 0x41, 0x00, 0x56, 0x01, // ŁV (U+0141 U+0056)
  0x01, 0x41, 0x00, 0x57, 0x01, // ŁW (U+0141 U+0057)
  0x01, 0x41, 0x00, 0x59, 0x02, // ŁY (U+0141 U+0059)
  0x01, 0x41, 0x00, 0xAB, 0x02, // Ł« (U+0141 U+00AB)
  0x01, 0x41, 0x00, 0xC7, 0x01, // ŁÇ (U+0141 U+00C7)
  0x01, 0x41, 0x00, 0xD2, 0x01, // ŁÒ (U+0141 U+00D2)
  0x01, 0x41, 0x00, 0xD3, 0x01, // ŁÓ (U+0141 U+00D3)
  0x01, 0x41, 0x00, 0xD4, 0x01, // ŁÔ (U+0141 U+00D4)
  0x01, 0x41, 0x00, 0xD5, 0x01, // ŁÕ (U+0141 U+00D5)
  0x01, 0x41, 0x00, 0xD6, 0x01, // ŁÖ (U+0141 U+00D6)
  0x01, 0x41, 0x00, 0xD8, 0x01, // ŁØ (U+0141 U+00D8)
  0x01, 0x41, 0x00, 0xD9, 0x01, // ŁÙ (U+0141 U+00D9)
  0x01, 0x41, 0x00, 0xDA, 0x01, // ŁÚ (U+0141 U+00DA)
  0x01, 0x41, 0x00, 0xDB, 0x01, // ŁÛ (U+0141 U+00DB)
  0x01, 0x41, 0x00, 0xDC, 0x01, // ŁÜ (U+0141 U+00DC)
  0x01, 0x41, 0x00, 0xDD, 0x02, // ŁÝ (U+0141 U+00DD)
  0x01, 0x41, 0x01, 0x06, 0x01, // ŁĆ (U+0141 U+0106)
  0x01, 0x41, 0x01, 0x08, 0x01, // ŁĈ (U+0141 U+0108)
  0x01, 0x41, 0x01, 0x0A, 0x01, // ŁĊ (U+0141 U+010A)
  0x01, 0x41, 0x01, 0x0C, 0x01, // ŁČ (U+0141 U+010C)
  0x01, 0x41, 0x01, 0x1C, 0x01, // ŁĜ (U+0141 U+011C)
  0x01, 0x41, 0x01, 0x1E, 0x01, // ŁĞ (U+0141 U+011E)
  0x01, 0x41, 0x01, 0x20, 0x01, // ŁĠ (U+0141 U+0120)
  0x01, 0x41, 0x01, 0x22, 0x01, // ŁĢ (U+0141 U+0122)
  0x01, 0x41, 0x01, 0x4C, 0x01, // ŁŌ (U+0141 U+014C)
  0x01, 0x41, 0x01, 0x4E, 0x01, // ŁŎ (U+0141 U+014E)
  0x01, 0x41, 0x01, 0x50, 0x01, // ŁŐ (U+0141 U+0150)
  0x01, 0x41, 0x01, 0x52, 0x01, // ŁŒ (U+0141 U+0152)
  0x01, 0x41, 0x01, 0x62, 0x02, // ŁŢ (U+0141 U+0162)
  0x01, 0x41, 0x01, 0x64, 0x02, // ŁŤ (U+0141 U+0164)
  0x01, 0x41, 0x01, 0x66, 0x02, // ŁŦ (U+0141 U+0166)
  0x01, 0x41, 0x01, 0x68, 0x01, // ŁŨ (U+0141 U+0168)
  0x01, 0x41, 0x01, 0x6A, 0x01, // ŁŪ (U+0141 U+016A)
  0x01, 0x41, 0x01, 0x6C, 0x01, // ŁŬ (U+0141 U+016C)
  0x01, 0x41, 0x01, 0x6E, 0x01, // ŁŮ (U+0141 U+016E)
  0x01, 0x41, 0x01, 0x70, 0x01, // ŁŰ (U+0141 U+0170)
  0x01, 0x41, 0x01, 0x72, 0x01, // ŁŲ (U+0141 U+0172)
  0x01, 0x41, 0x01, 0x74, 0x01, // ŁŴ (U+0141 U+0174)
  0x01, 0x41, 0x01, 0x76, 0x02, // ŁŶ (U+0141 U+0176)
  0x01, 0x41, 0x01, 0x78, 0x02, // ŁŸ (U+0141 U+0178)
  0x01, 0x41, 0x20, 0x19, 0x03, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1D, 0x03, // Ł” (U+0141 U+201D)
  0x01, 0x41, 0x20, 0x39, 0x02, // Ł‹ (U+0141 U+2039)
  0x01, 0x4C, 0x00, 0x2C, 0x02, // Ō, (U+014C U+002C)
  0x01, 0x4C, 0x00, 0x2E, 0x02, // Ō. (U+014C U+002E)
  0x01, 0x4C, 0x00, 0x54, 0x01, // ŌT (U+014C U+0054)
  0x01, 0x4C, 0x00, 0x58, 0x01, // ŌX (U+014C U+0058)
  0x01, 0x4C, 0x01, 0x62, 0x01, // ŌŢ (U+014C U+0162)
  0x01, 0x4C, 0x01, 0x64, 0x01, // ŌŤ (U+014C U+0164)
  0x01, 0x4C, 0x01, 0x66, 0x01, // ŌŦ (U+014C U+0166)
  0x01, 0x4C, 0x20, 0x1A, 0x02, // Ō‚ (U+014C U+201A)
  0x01, 0x4C, 0x20, 0x1E, 0x02, // Ō„ (U+014C U+201E)
  0x01, 0x4C, 0x20, 0x26, 0x02, // Ō… (U+014C U+2026)
  0x01, 0x4E, 0x00, 0x2C, 0x02, // Ŏ, (U+014E U+002C)
  0x01, 0x4E, 0x00, 0x2E, 0x02, // Ŏ. (U+014E U+002E)
  0x01, 0x4E, 0x00, 0x54, 0x01, // ŎT (U+014E U+0054)
  0x01, 0x4E, 0x00, 0x58, 0x01, // ŎX (U+014E U+0058)
  0x01, 0x4E, 0x01, 0x62, 0x01, // ŎŢ (U+014E U+0162)
  0x01, 0x4E, 0x01, 0x64, 0x01, // ŎŤ (U+014E U+0164)
  0x01, 0x4E, 0x01, 0x66, 0x01, // ŎŦ (U+014E U+0166)
  0x01, 0x4E, 0x20, 0x1A, 0x02, // Ŏ‚ (U+014E U+201A)
  0x01, 0x4E, 0x20, 0x1E, 0x02, // Ŏ„ (U+014E U+201E)
  0x01, 0x4E, 0x20, 0x26, 0x02, // Ŏ… (U+014E U+2026)
  0x01, 0x50, 0x00, 0x2C, 0x02, // Ő, (U+0150 U+002C)
  0x01, 0x50, 0x00, 0x2E, 0x02, // Ő. (U+0150 U+002E)
  0x01, 0x50, 0x00, 0x54, 0x01, // ŐT (U+0150 U+0054)
  0x01, 0x50, 0x00, 0x58, 0x01, // ŐX (U+0150 U+0058)
  0x01, 0x50, 0x01, 0x62, 0x01, // ŐŢ (U+0150 U+0162)
  0x01, 0x50, 0x01, 0x64, 0x01, // ŐŤ (U+0150 U+0164)
  0x01, 0x50, 0x01, 0x66, 0x01, // ŐŦ (U+0150 U+0166)
  0x01, 0x50, 0x20, 0x1A, 0x02, // Ő‚ (U+0150 U+201A)
  0x01, 0x50, 0x20, 0x1E, 0x02, // Ő„ (U+0150 U+201E)
  0x01, 0x50, 0x20, 0x26, 0x02, // Ő… (U+0150 U+2026)
  0x01, 0x55, 0x00, 0x2C, 0x04, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x04, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x20, 0x1A, 0x04, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x04, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x04, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x04, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x04, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x20, 0x1A, 0x04, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x04, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x04, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x04, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x04, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x20, 0x1A, 0x04, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x04, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x04, // ř… (U+0159 U+2026)
  0x01, 0x62, 0x00, 0x26, 0x01, // Ţ& (U+0162 U+0026)
  0x01, 0x62, 0x00, 0x2C, 0x02, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2D, 0x02, // Ţ- (U+0162 U+002D)
  0x01, 0x62, 0x00, 0x2E, 0x02, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0x41, 0x01, // ŢA (U+0162 U+0041)
  0x01, 0x62, 0x00, 0x43, 0x01, // ŢC (U+0162 U+0043)
  0x01, 0x62, 0x00, 0x47, 0x01, // ŢG (U+0162 U+0047)
  0x01, 0x62, 0x00, 0x4F, 0x01, // ŢO (U+0162 U+004F)
  0x01, 0x62, 0x00, 0x51, 0x01, // ŢQ (U+0162 U+0051)
  0x01, 0x62, 0x00, 0x61, 0x02, // Ţa (U+0162 U+0061)
  0x01, 0x62, 0x00, 0x63, 0x02, // Ţc (U+0162 U+0063)
  0x01, 0x62, 0x00, 0x64, 0x02, // Ţd (U+0162 U+0064)
  0x01, 0x62, 0x00, 0x65, 0x02, // Ţe (U+0162 U+0065)
  0x01, 0x62, 0x00, 0x67, 0x02, // Ţg (U+0162 U+0067)
  0x01, 0x62, 0x00, 0x6D, 0x02, // Ţm (U+0162 U+006D)
  0x01, 0x62, 0x00, 0x6E, 0x02, // Ţn (U+0162 U+006E)
  0x01, 0x62, 0x00, 0x6F, 0x02, // Ţo (U+0162 U+006F)
  0x01, 0x62, 0x00, 0x70, 0x02, // Ţp (U+0162 U+0070)
  0x01, 0x62, 0x00, 0x71, 0x02, // Ţq (U+0162 U+0071)
  0x01, 0x62, 0x00, 0x72, 0x02, // Ţr (U+0162 U+0072)
  0x01, 0x62, 0x00, 0x73, 0x02, // Ţs (U+0162 U+0073)
  0x01, 0x62, 0x00, 0x75, 0x02, // Ţu (U+0162 U+0075)
  0x01, 0x62, 0x00, 0x76, 0x01, // Ţv (U+0162 U+0076)
  0x01, 0x62, 0x00, 0x77, 0x01, // Ţw (U+0162 U+0077)
  0x01, 0x62, 0x00, 0x79, 0x01, // Ţy (U+0162 U+0079)
  0x01, 0x62, 0x00, 0x7A, 0x01, // Ţz (U+0162 U+007A)
  0x01, 0x62, 0x00, 0xAB, 0x02, // Ţ« (U+0162 U+00AB)
  0x01, 0x62, 0x00, 0xBB, 0x01, // Ţ» (U+0162 U+00BB)
  0x01, 0x62, 0x00, 0xC0, 0x01, // ŢÀ (U+0162 U+00C0)
  0x01, 0x62, 0x00, 0xC1, 0x01, // ŢÁ (U+0162 U+00C1)
  0x01, 0x62, 0x00, 0xC2, 0x01, // ŢÂ (U+0162 U+00C2)
  0x01, 0x62, 0x00, 0xC3, 0x01, // ŢÃ (U+0162 U+00C3)
  0x01, 0x62, 0x00, 0xC4, 0x01, // ŢÄ (U+0162 U+00C4)
  0x01, 0x62, 0x00, 0xC5, 0x01, // ŢÅ (U+0162 U+00C5)
  0x01, 0x62, 0x00, 0xC7, 0x01, // ŢÇ (U+0162 U+00C7)
  0x01, 0x62, 0x00, 0xD2, 0x01, // ŢÒ (U+0162 U+00D2)
  0x01, 0x62, 0x00, 0xD3, 0x01, // ŢÓ (U+0162 U+00D3)
  0x01, 0x62, 0x00, 0xD4, 0x01, // ŢÔ (U+0162 U+00D4)
  0x01, 0x62, 0x00, 0xD5, 0x01, // ŢÕ (U+0162 U+00D5)
  0x01, 0x62, 0x00, 0xD6, 0x01, // ŢÖ (U+0162 U+00D6)
  0x01, 0x62, 0x00, 0xD8, 0x01, // ŢØ (U+0162 U+00D8)
  0x01, 0x62, 0x00, 0xE0, 0x02, // Ţà (U+0162 U+00E0)
  0x01, 0x62, 0x00, 0xE1, 0x02, // Ţá (U+0162 U+00E1)
  0x01, 0x62, 0x00, 0xE2, 0x02, // Ţâ (U+0162 U+00E2)
  0x01, 0x62, 0x00, 0xE3, 0x02, // Ţã (U+0162 U+00E3)
  0x01, 0x62, 0x00, 0xE4, 0x02, // Ţä (U+0162 U+00E4)
  0x01, 0x62, 0x00, 0xE5, 0x02, // Ţå (U+0162 U+00E5)
  0x01, 0x62, 0x00, 0xE6, 0x02, // Ţæ (U+0162 U+00E6)
  0x01, 0x62, 0x00, 0xE7, 0x02, // Ţç (U+0162 U+00E7)
  0x01, 0x62, 0x00, 0xE8, 0x02, // Ţè (U+0162 U+00E8)
  0x01, 0x62, 0x00, 0xE9, 0x02, // Ţé (U+0162 U+00E9)
  0x01, 0x62, 0x00, 0xEA, 0x02, // Ţê (U+0162 U+00EA)
  0x01, 0x62, 0x00, 0xEB, 0x02, // Ţë (U+0162 U+00EB)
  0x01, 0x62, 0x00, 0xF1, 0x02, // Ţñ (U+0162 U+00F1)
  0x01, 0x62, 0x00, 0xF2, 0x02, // Ţò (U+0162 U+00F2)
  0x01, 0x62, 0x00, 0xF3, 0x02, // Ţó (U+0162 U+00F3)
  0x01, 0x62, 0x00, 0xF4, 0x02, // Ţô (U+0162 U+00F4)
  0x01, 0x62, 0x00, 0xF5, 0x02, // Ţõ (U+0162 U+00F5)
  0x01, 0x62, 0x00, 0xF6, 0x02, // Ţö (U+0162 U+00F6)
  0x01, 0x62, 0x00, 0xF8, 0x02, // Ţø (U+0162 U+00F8)
  0x01, 0x62, 0x00, 0xF9, 0x02, // Ţù (U+0162 U+00F9)
  0x01, 0x62, 0x00, 0xFA, 0x02, // Ţú (U+0162 U+00FA)
  0x01, 0x62, 0x00, 0xFB, 0x02, // Ţû (U+0162 U+00FB)
  0x01, 0x62, 0x00, 0xFC, 0x02, // Ţü (U+0162 U+00FC)
  0x01, 0x62, 0x00, 0xFD, 0x01, // Ţý (U+0162 U+00FD)
  0x01, 0x62, 0x00, 0xFF, 0x01, // Ţÿ (U+0162 U+00FF)
  0x01, 0x62, 0x01, 0x00, 0x01, // ŢĀ (U+0162 U+0100)
  0x01, 0x62, 0x01, 0x01, 0x02, // Ţā (U+0162 U+0101)
  0x01, 0x62, 0x01, 0x02, 0x01, // ŢĂ (U+0162 U+0102)
  0x01, 0x62, 0x01, 0x03, 0x02, // Ţă (U+0162 U+0103)
  0x01, 0x62, 0x01, 0x04, 0x01, // ŢĄ (U+0162 U+0104)
  0x01, 0x62, 0x01, 0x05, 0x02, // Ţą (U+0162 U+0105)
  0x01, 0x62, 0x01, 0x06, 0x01, // ŢĆ (U+0162 U+0106)
  0x01, 0x62, 0x01, 0x07, 0x02, // Ţć (U+0162 U+0107)
  0x01, 0x62, 0x01, 0x08, 0x01, // ŢĈ (U+0162 U+0108)
  0x01, 0x62, 0x01, 0x09, 0x02, // Ţĉ (U+0162 U+0109)
  0x01, 0x62, 0x01, 0x0A, 0x01, // ŢĊ (U+0162 U+010A)
  0x01, 0x62, 0x01, 0x0B, 0x02, // Ţċ (U+0162 U+010B)
  0x01, 0x62, 0x01, 0x0C, 0x01, // ŢČ (U+0162 U+010C)
  0x01, 0x62, 0x01, 0x0D, 0x02, // Ţč (U+0162 U+010D)
  0x01, 0x62, 0x01, 0x0F, 0x02, // Ţď (U+0162 U+010F)
  0x01, 0x62, 0x01, 0x11, 0x02, // Ţđ (U+0162 U+0111)
  0x01, 0x62, 0x01, 0x13, 0x02, // Ţē (U+0162 U+0113)
  0x01, 0x62, 0x01, 0x15, 0x02, // Ţĕ (U+0162 U+0115)
  0x01, 0x62, 0x01, 0x17, 0x02, // Ţė (U+0162 U+0117)
  0x01, 0x62, 0x01, 0x19, 0x02, // Ţę (U+0162 U+0119)
  0x01, 0x62, 0x01, 0x1B, 0x02, // Ţě (U+0162 U+011B)
  0x01, 0x62, 0x01, 0x1C, 0x01, // ŢĜ (U+0162 U+011C)
  0x01, 0x62, 0x01, 0x1D, 0x02, // Ţĝ (U+0162 U+011D)
  0x01, 0x62, 0x01, 0x1E, 0x01, // ŢĞ (U+0162 U+011E)
  0x01, 0x62, 0x01, 0x1F, 0x02, // Ţğ (U+0162 U+011F)
  0x01, 0x62, 0x01, 0x20, 0x01, // ŢĠ (U+0162 U+0120)
  0x01, 0x62, 0x01, 0x21, 0x02, // Ţġ (U+0162 U+0121)
  0x01, 0x62, 0x01, 0x22, 0x01, // ŢĢ (U+0162 U+0122)
  0x01, 0x62, 0x01, 0x23, 0x02, // Ţģ (U+0162 U+0123)
  0x01, 0x62, 0x01, 0x38, 0x02, // Ţĸ (U+0162 U+0138)
  0x01, 0x62, 0x01, 0x44, 0x02, // Ţń (U+0162 U+0144)
  0x01, 0x62, 0x01, 0x46, 0x02, // Ţņ (U+0162 U+0146)
  0x01, 0x62, 0x01, 0x48, 0x02, // Ţň (U+0162 U+0148)
  0x01, 0x62, 0x01, 0x4B, 0x02, // Ţŋ (U+0162 U+014B)
  0x01, 0x62, 0x01, 0x4C, 0x01, // ŢŌ (U+0162 U+014C)
  0x01, 0x62, 0x01, 0x4D, 0x02, // Ţō (U+0162 U+014D)
  0x01, 0x62, 0x01, 0x4E, 0x01, // ŢŎ (U+0162 U+014E)
  0x01, 0x62, 0x01, 0x4F, 0x02, // Ţŏ (U+0162 U+014F)
  0x01, 0x62, 0x01, 0x50, 0x01, // ŢŐ (U+0162 U+0150)
  0x01, 0x62, 0x01, 0x51, 0x02, // Ţő (U+0162 U+0151)
  0x01, 0x62, 0x01, 0x52, 0x01, // ŢŒ (U+0162 U+0152)
  0x01, 0x62, 0x01, 0x53, 0x02, // Ţœ (U+0162 U+0153)
  0x01, 0x62, 0x01, 0x55, 0x02, // Ţŕ (U+0162 U+0155)
  0x01, 0x62, 0x01, 0x57, 0x02, // Ţŗ (U+0162 U+0157)
  0x01, 0x62, 0x01, 0x5B, 0x02, // Ţś (U+0162 U+015B)
  0x01, 0x62, 0x01, 0x5D, 0x02, // Ţŝ (U+0162 U+015D)
  0x01, 0x62, 0x01, 0x5F, 0x02, // Ţş (U+0162 U+015F)
  0x01, 0x62, 0x01, 0x61, 0x02, // Ţš (U+0162 U+0161)
  0x01, 0x62, 0x01, 0x69, 0x02, // Ţũ (U+0162 U+0169)
  0x01, 0x62, 0x01, 0x6B, 0x02, // Ţū (U+0162 U+016B)
  0x01, 0x62, 0x01, 0x6D, 0x02, // Ţŭ (U+0162 U+016D)
  0x01, 0x62, 0x01, 0x6F, 0x02, // Ţů (U+0162 U+016F)
  0x01, 0x62, 0x01, 0x71, 0x02, // Ţű (U+0162 U+0171)
  0x01, 0x62, 0x01, 0x73, 0x02, // Ţų (U+0162 U+0173)
  0x01, 0x62, 0x01, 0x75, 0x01, // Ţŵ (U+0162 U+0175)
  0x01, 0x62, 0x01, 0x77, 0x01, // Ţŷ (U+0162 U+0177)
  0x01, 0x62, 0x01, 0x7A, 0x01, // Ţź (U+0162 U+017A)
  0x01, 0x62, 0x01, 0x7C, 0x01, // Ţż (U+0162 U+017C)
  0x01, 0x62, 0x01, 0x7E, 0x01, // Ţž (U+0162 U+017E)
  0x01, 0x62, 0x20, 0x13, 0x02, // Ţ– (U+0162 U+2013)
  0x01, 0x62, 0x20, 0x14, 0x02, // Ţ— (U+0162 U+2014)
  0x01, 0x62, 0x20, 0x1A, 0x02, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x02, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x02, // Ţ… (U+0162 U+2026)
  0x01, 0x62, 0x20, 0x39, 0x02, // Ţ‹ (U+0162 U+2039)
  0x01, 0x62, 0x20, 0x3A, 0x01, // Ţ› (U+0162 U+203A)
  0x01, 0x64, 0x00, 0x26, 0x01, // Ť& (U+0164 U+0026)
  0x01, 0x64, 0x00, 0x2C, 0x02, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2D, 0x02, // Ť- (U+0164 U+002D)
  0x01, 0x64, 0x00, 0x2E, 0x02, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0x41, 0x01, // ŤA (U+0164 U+0041)
  0x01, 0x64, 0x00, 0x43, 0x01, // ŤC (U+0164 U+0043)
  0x01, 0x64, 0x00, 0x47, 0x01, // ŤG (U+0164 U+0047)
  0x01, 0x64, 0x00, 0x4F, 0x01, // ŤO (U+0164 U+004F)
  0x01, 0x64, 0x00, 0x51, 0x01, // ŤQ (U+0164 U+0051)
  0x01, 0x64, 0x00, 0x61, 0x02, // Ťa (U+0164 U+0061)
  0x01, 0x64, 0x00, 0x63, 0x02, // Ťc (U+0164 U+0063)
  0x01, 0x64, 0x00, 0x64, 0x02, // Ťd (U+0164 U+0064)
  0x01, 0x64, 0x00, 0x65, 0x02, // Ťe (U+0164 U+0065)
  0x01, 0x64, 0x00, 0x67, 0x02, // Ťg (U+0164 U+0067)
  0x01, 0x64, 0x00, 0x6D, 0x02, // Ťm (U+0164 U+006D)
  0x01, 0x64, 0x00, 0x6E, 0x02, // Ťn (U+0164 U+006E)
  0x01, 0x64, 0x00, 0x6F, 0x02, // Ťo (U+0164 U+006F)
  0x01, 0x64, 0x00, 0x70, 0x02, // Ťp (U+0164 U+0070)
  0x01, 0x64, 0x00, 0x71, 0x02, // Ťq (U+0164 U+0071)
  0x01, 0x64, 0x00, 0x72, 0x02, // Ťr (U+0164 U+0072)
  0x01, 0x64, 0x00, 0x73, 0x02, // Ťs (U+0164 U+0073)
  0x01, 0x64, 0x00, 0x75, 0x02, // Ťu (U+0164 U+0075)
  0x01, 0x64, 0x00, 0x76, 0x01, // Ťv (U+0164 U+0076)
  0x01, 0x64, 0x00, 0x77, 0x01, // Ťw (U+0164 U+0077)
  0x01, 0x64, 0x00, 0x79, 0x01, // Ťy (U+0164 U+0079)
  0x01, 0x64, 0x00, 0x7A, 0x01, // Ťz (U+0164 U+007A)
  0x01, 0x64, 0x00, 0xAB, 0x02, // Ť« (U+0164 U+00AB)
  0x01, 0x64, 0x00, 0xBB, 0x01, // Ť» (U+0164 U+00BB)
  0x01, 0x64, 0x00, 0xC0, 0x01, // ŤÀ (U+0164 U+00C0)
  0x01, 0x64, 0x00, 0xC1, 0x01, // ŤÁ (U+0164 U+00C1)
  0x01, 0x64, 0x00, 0xC2, 0x01, // ŤÂ (U+0164 U+00C2)
  0x01, 0x64, 0x00, 0xC3, 0x01, // ŤÃ (U+0164 U+00C3)
  0x01, 0x64, 0x00, 0xC4, 0x01, // ŤÄ (U+0164 U+00C4)
  0x01, 0x64, 0x00, 0xC5, 0x01, // ŤÅ (U+0164 U+00C5)
  0x01, 0x64, 0x00, 0xC7, 0x01, // ŤÇ (U+0164 U+00C7)
  0x01, 0x64, 0x00, 0xD2, 0x01, // ŤÒ (U+0164 U+00D2)
  0x01, 0x64, 0x00, 0xD3, 0x01, // ŤÓ (U+0164 U+00D3)
  0x01, 0x64, 0x00, 0xD4, 0x01, // ŤÔ (U+0164 U+00D4)
  0x01, 0x64, 0x00, 0xD5, 0x01, // ŤÕ (U+0164 U+00D5)
  0x01, 0x64, 0x00, 0xD6, 0x01, // ŤÖ (U+0164 U+00D6)
  0x01, 0x64, 0x00, 0xD8, 0x01, // ŤØ (U+0164 U+00D8)
  0x01, 0x64, 0x00, 0xE0, 0x02, // Ťà (U+0164 U+00E0)
  0x01, 0x64, 0x00, 0xE1, 0x02, // Ťá (U+0164 U+00E1)
  0x01, 0x64, 0x00, 0xE2, 0x02, // Ťâ (U+0164 U+00E2)
  0x01, 0x64, 0x00, 0xE3, 0x02, // Ťã (U+0164 U+00E3)
  0x01, 0x64, 0x00, 0xE4, 0x02, // Ťä (U+0164 U+00E4)
  0x01, 0x64, 0x00, 0xE5, 0x02, // Ťå (U+0164 U+00E5)
  0x01, 0x64, 0x00, 0xE6, 0x02, // Ťæ (U+0164 U+00E6)
  0x01, 0x64, 0x00, 0xE7, 0x02, // Ťç (U+0164 U+00E7)
  0x01, 0x64, 0x00, 0xE8, 0x02, // Ťè (U+0164 U+00E8)
  0x01, 0x64, 0x00, 0xE9, 0x02, // Ťé (U+0164 U+00E9)
  0x01, 0x64, 0x00, 0xEA, 0x02, // Ťê (U+0164 U+00EA)
  0x01, 0x64, 0x00, 0xEB, 0x02, // Ťë (U+0164 U+00EB)
  0x01, 0x64, 0x00, 0xF1, 0x02, // Ťñ (U+0164 U+00F1)
  0x01, 0x64, 0x00, 0xF2, 0x02, // Ťò (U+0164 U+00F2)
  0x01, 0x64, 0x00, 0xF3, 0x02, // Ťó (U+0164 U+00F3)
  0x01, 0x64, 0x00, 0xF4, 0x02, // Ťô (U+0164 U+00F4)
  0x01, 0x64, 0x00, 0xF5, 0x02, // Ťõ (U+0164 U+00F5)
  0x01, 0x64, 0x00, 0xF6, 0x02, // Ťö (U+0164 U+00F6)
  0x01, 0x64, 0x00, 0xF8, 0x02, // Ťø (U+0164 U+00F8)
  0x01, 0x64, 0x00, 0xF9, 0x02, // Ťù (U+0164 U+00F9)
  0x01, 0x64, 0x00, 0xFA, 0x02, // Ťú (U+0164 U+00FA)
  0x01, 0x64, 0x00, 0xFB, 0x02, // Ťû (U+0164 U+00FB)
  0x01, 0x64, 0x00, 0xFC, 0x02, // Ťü (U+0164 U+00FC)
  0x01, 0x64, 0x00, 0xFD, 0x01, // Ťý (U+0164 U+00FD)
  0x01, 0x64, 0x00, 0xFF, 0x01, // Ťÿ (U+0164 U+00FF)
  0x01, 0x64, 0x01, 0x00, 0x01, // ŤĀ (U+0164 U+0100)
  0x01, 0x64, 0x01, 0x01, 0x02, // Ťā (U+0164 U+0101)
  0x01, 0x64, 0x01, 0x02, 0x01, // ŤĂ (U+0164 U+0102)
  0x01, 0x64, 0x01, 0x03, 0x02, // Ťă (U+0164 U+0103)
  0x01, 0x64, 0x01, 0x04, 0x01, // ŤĄ (U+0164 U+0104)
  0x01, 0x64, 0x01, 0x05, 0x02, // Ťą (U+0164 U+0105)
  0x01, 0x64, 0x01, 0x06, 0x01, // ŤĆ (U+0164 U+0106)
  0x01, 0x64, 0x01, 0x07, 0x02, // Ťć (U+0164 U+0107)
  0x01, 0x64, 0x01, 0x08, 0x01, // ŤĈ (U+0164 U+0108)
  0x01, 0x64, 0x01, 0x09, 0x02, // Ťĉ (U+0164 U+0109)
  0x01, 0x64, 0x01, 0x0A, 0x01, // ŤĊ (U+0164 U+010A)
  0x01, 0x64, 0x01, 0x0B, 0x02, // Ťċ (U+0164 U+010B)
  0x01, 0x64, 0x01, 0x0C, 0x01, // ŤČ (U+0164 U+010C)
  0x01, 0x64, 0x01, 0x0D, 0x02, // Ťč (U+0164 U+010D)
  0x01, 0x64, 0x01, 0x0F, 0x02, // Ťď (U+0164 U+010F)
  0x01, 0x64, 0x01, 0x11, 0x02, // Ťđ (U+0164 U+0111)
  0x01, 0x64, 0x01, 0x13, 0x02, // Ťē (U+0164 U+0113)
  0x01, 0x64, 0x01, 0x15, 0x02, // Ťĕ (U+0164 U+0115)
  0x01, 0x64, 0x01, 0x17, 0x02, // Ťė (U+0164 U+0117)
  0x01, 0x64, 0x01, 0x19, 0x02, // Ťę (U+0164 U+0119)
  0x01, 0x64, 0x01, 0x1B, 0x02, // Ťě (U+0164 U+011B)
  0x01, 0x64, 0x01, 0x1C, 0x01, // ŤĜ (U+0164 U+011C)
  0x01, 0x64, 0x01, 0x1D, 0x02, // Ťĝ (U+0164 U+011D)
  0x01, 0x64, 0x01, 0x1E, 0x01, // ŤĞ (U+0164 U+011E)
  0x01, 0x64, 0x01, 0x1F, 0x02, // Ťğ (U+0164 U+011F)
  0x01, 0x64, 0x01, 0x20, 0x01, // ŤĠ (U+0164 U+0120)
  0x01, 0x64, 0x01, 0x21, 0x02, // Ťġ (U+0164 U+0121)
  0x01, 0x64, 0x01, 0x22, 0x01, // ŤĢ (U+0164 U+0122)
  0x01, 0x64, 0x01, 0x23, 0x02, // Ťģ (U+0164 U+0123)
  0x01, 0x64, 0x01, 0x38, 0x02, // Ťĸ (U+0164 U+0138)
  0x01, 0x64, 0x01, 0x44, 0x02, // Ťń (U+0164 U+0144)
  0x01, 0x64, 0x01, 0x46, 0x02, // Ťņ (U+0164 U+0146)
  0x01, 0x64, 0x01, 0x48, 0x02, // Ťň (U+0164 U+0148)
  0x01, 0x64, 0x01, 0x4B, 0x02, // Ťŋ (U+0164 U+014B)
  0x01, 0x64, 0x01, 0x4C, 0x01, // ŤŌ (U+0164 U+014C)
  0x01, 0x64, 0x01, 0x4D, 0x02, // Ťō (U+0164 U+014D)
  0x01, 0x64, 0x01, 0x4E, 0x01, // ŤŎ (U+0164 U+014E)
  0x01, 0x64, 0x01, 0x4F, 0x02, // Ťŏ (U+0164 U+014F)
  0x01, 0x64, 0x01, 0x50, 0x01, // ŤŐ (U+0164 U+0150)
  0x01, 0x64, 0x01, 0x51, 0x02, // Ťő (U+0164 U+0151)
  0x01, 0x64, 0x01, 0x52, 0x01, // ŤŒ (U+0164 U+0152)
  0x01, 0x64, 0x01, 0x53, 0x02, // Ťœ (U+0164 U+0153)
  0x01, 0x64, 0x01, 0x55, 0x02, // Ťŕ (U+0164 U+0155)
  0x01, 0x64, 0x01, 0x57, 0x02, // Ťŗ (U+0164 U+0157)
  0x01, 0x64, 0x01, 0x5B, 0x02, // Ťś (U+0164 U+015B)
  0x01, 0x64, 0x01, 0x5D, 0x02, // Ťŝ (U+0164 U+015D)
  0x01, 0x64, 0x01, 0x5F, 0x02, // Ťş (U+0164 U+015F)
  0x01, 0x64, 0x01, 0x61, 0x02, // Ťš (U+0164 U+0161)
  0x01, 0x64, 0x01, 0x69, 0x02, // Ťũ (U+0164 U+0169)
  0x01, 0x64, 0x01, 0x6B, 0x02, // Ťū (U+0164 U+016B)
  0x01, 0x64, 0x01, 0x6D, 0x02, // Ťŭ (U+0164 U+016D)
  0x01, 0x64, 0x01, 0x6F, 0x02, // Ťů (U+0164 U+016F)
  0x01, 0x64, 0x01, 0x71, 0x02, // Ťű (U+0164 U+0171)
  0x01, 0x64, 0x01, 0x73, 0x02, // Ťų (U+0164 U+0173)
  0x01, 0x64, 0x01, 0x75, 0x01, // Ťŵ (U+0164 U+0175)
  0x01, 0x64, 0x01, 0x77, 0x01, // Ťŷ (U+0164 U+0177)
  0x01, 0x64, 0x01, 0x7A, 0x01, // Ťź (U+0164 U+017A)
  0x01, 0x64, 0x01, 0x7C, 0x01, // Ťż (U+0164 U+017C)
  0x01, 0x64, 0x01, 0x7E, 0x01, // Ťž (U+0164 U+017E)
  0x01, 0x64, 0x20, 0x13, 0x02, // Ť– (U+0164 U+2013)
  0x01, 0x64, 0x20, 0x14, 0x02, // Ť— (U+0164 U+2014)
  0x01, 0x64, 0x20, 0x1A, 0x02, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x02, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x02, // Ť… (U+0164 U+2026)
  0x01, 0x64, 0x20, 0x39, 0x02, // Ť‹ (U+0164 U+2039)
  0x01, 0x64, 0x20, 0x3A, 0x01, // Ť› (U+0164 U+203A)
  0x01, 0x66, 0x00, 0x26, 0x01, // Ŧ& (U+0166 U+0026)
  0x01, 0x66, 0x00, 0x2C, 0x02, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2D, 0x02, // Ŧ- (U+0166 U+002D)
  0x01, 0x66, 0x00, 0x2E, 0x02, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0x41, 0x01, // ŦA (U+0166 U+0041)
  0x01, 0x66, 0x00, 0x43, 0x01, // ŦC (U+0166 U+0043)
  0x01, 0x66, 0x00, 0x47, 0x01, // ŦG (U+0166 U+0047)
  0x01, 0x66, 0x00, 0x4F, 0x01, // ŦO (U+0166 U+004F)
  0x01, 0x66, 0x00, 0x51, 0x01, // ŦQ (U+0166 U+0051)
  0x01, 0x66, 0x00, 0x61, 0x02, // Ŧa (U+0166 U+0061)
  0x01, 0x66, 0x00, 0x63, 0x02, // Ŧc (U+0166 U+0063)
  0x01, 0x66, 0x00, 0x64, 0x02, // Ŧd (U+0166 U+0064)
  0x01, 0x66, 0x00, 0x65, 0x02, // Ŧe (U+0166 U+0065)
  0x01, 0x66, 0x00, 0x67, 0x02, // Ŧg (U+0166 U+0067)
  0x01, 0x66, 0x00, 0x6D, 0x02, // Ŧm (U+0166 U+006D)
  0x01, 0x66, 0x00, 0x6E, 0x02, // Ŧn (U+0166 U+006E)
  0x01, 0x66, 0x00, 0x6F, 0x02, // Ŧo (U+0166 U+006F)
  0x01, 0x66, 0x00, 0x70, 0x02, // Ŧp (U+0166 U+0070)
  0x01, 0x66, 0x00, 0x71, 0x02, // Ŧq (U+0166 U+0071)
  0x01, 0x66, 0x00, 0x72, 0x02, // Ŧr (U+0166 U+0072)
  0x01, 0x66, 0x00, 0x73, 0x02, // Ŧs (U+0166 U+0073)
  0x01, 0x66, 0x00, 0x75, 0x02, // Ŧu (U+0166 U+0075)
  0x01, 0x66, 0x00, 0x76, 0x01, // Ŧv (U+0166 U+0076)
  0x01, 0x66, 0x00, 0x77, 0x01, // Ŧw (U+0166 U+0077)
  0x01, 0x66, 0x00, 0x79, 0x01, // Ŧy (U+0166 U+0079)
  0x01, 0x66, 0x00, 0x7A, 0x01, // Ŧz (U+0166 U+007A)
  0x01, 0x66, 0x00, 0xAB, 0x02, // Ŧ« (U+0166 U+00AB)
  0x01, 0x66, 0x00, 0xBB, 0x01, // Ŧ» (U+0166 U+00BB)
  0x01, 0x66, 0x00, 0xC0, 0x01, // ŦÀ (U+0166 U+00C0)
  0x01, 0x66, 0x00, 0xC1, 0x01, // ŦÁ (U+0166 U+00C1)
  0x01, 0x66, 0x00, 0xC2, 0x01, // ŦÂ (U+0166 U+00C2)
  0x01, 0x66, 0x00, 0xC3, 0x01, // ŦÃ (U+0166 U+00C3)
  0x01, 0x66, 0x00, 0xC4, 0x01, // ŦÄ (U+0166 U+00C4)
  0x01, 0x66, 0x00, 0xC5, 0x01, // ŦÅ (U+0166 U+00C5)
  0x01, 0x66, 0x00, 0xC7, 0x01, // ŦÇ (U+0166 U+00C7)
  0x01, 0x66, 0x00, 0xD2, 0x01, // ŦÒ (U+0166 U+00D2)
  0x01, 0x66, 0x00, 0xD3, 0x01, // ŦÓ (U+0166 U+00D3)
  0x01, 0x66, 0x00, 0xD4, 0x01, // ŦÔ (U+0166 U+00D4)
  0x01, 0x66, 0x00, 0xD5, 0x01, // ŦÕ (U+0166 U+00D5)
  0x01, 0x66, 0x00, 0xD6, 0x01, // ŦÖ (U+0166 U+00D6)
  0x01, 0x66, 0x00, 0xD8, 0x01, // ŦØ (U+0166 U+00D8)
  0x01, 0x66, 0x00, 0xE0, 0x02, // Ŧà (U+0166 U+00E0)
  0x01, 0x66, 0x00, 0xE1, 0x02, // Ŧá (U+0166 U+00E1)
  0x01, 0x66, 0x00, 0xE2, 0x02, // Ŧâ (U+0166 U+00E2)
  0x01, 0x66, 0x00, 0xE3, 0x02, // Ŧã (U+0166 U+00E3)
  0x01, 0x66, 0x00, 0xE4, 0x02, // Ŧä (U+0166 U+00E4)
  0x01, 0x66, 0x00, 0xE5, 0x02, // Ŧå (U+0166 U+00E5)
  0x01, 0x66, 0x00, 0xE6, 0x02, // Ŧæ (U+0166 U+00E6)
  0x01, 0x66, 0x00, 0xE7, 0x02, // Ŧç (U+0166 U+00E7)
  0x01, 0x66, 0x00, 0xE8, 0x02, // Ŧè (U+0166 U+00E8)
  0x01, 0x66, 0x00, 0xE9, 0x02, // Ŧé (U+0166 U+00E9)
  0x01, 0x66, 0x00, 0xEA, 0x02, // Ŧê (U+0166 U+00EA)
  0x01, 0x66, 0x00, 0xEB, 0x02, // Ŧë (U+0166 U+00EB)
  0x01, 0x66, 0x00, 0xF1, 0x02, // Ŧñ (U+0166 U+00F1)
  0x01, 0x66, 0x00, 0xF2, 0x02, // Ŧò (U+0166 U+00F2)
  0x01, 0x66, 0x00, 0xF3, 0x02, // Ŧó (U+0166 U+00F3)
  0x01, 0x66, 0x00, 0xF4, 0x02, // Ŧô (U+0166 U+00F4)
  0x01, 0x66, 0x00, 0xF5, 0x02, // Ŧõ (U+0166 U+00F5)
  0x01, 0x66, 0x00, 0xF6, 0x02, // Ŧö (U+0166 U+00F6)
  0x01, 0x66, 0x00, 0xF8, 0x02, // Ŧø (U+0166 U+00F8)
  0x01, 0x66, 0x00, 0xF9, 0x02, // Ŧù (U+0166 U+00F9)
  0x01, 0x66, 0x00, 0xFA, 0x02, // Ŧú (U+0166 U+00FA)
  0x01, 0x66, 0x00, 0xFB, 0x02, // Ŧû (U+0166 U+00FB)
  0x01, 0x66, 0x00, 0xFC, 0x02, // Ŧü (U+0166 U+00FC)
  0x01, 0x66, 0x00, 0xFD, 0x01, // Ŧý (U+0166 U+00FD)
  0x01, 0x66, 0x00, 0xFF, 0x01, // Ŧÿ (U+0166 U+00FF)
  0x01, 0x66, 0x01, 0x00, 0x01, // ŦĀ (U+0166 U+0100)
  0x01, 0x66, 0x01, 0x01, 0x02, // Ŧā (U+0166 U+0101)
  0x01, 0x66, 0x01, 0x02, 0x01, // ŦĂ (U+0166 U+0102)
  0x01, 0x66, 0x01, 0x03, 0x02, // Ŧă (U+0166 U+0103)
  0x01, 0x66, 0x01, 0x04, 0x01, // ŦĄ (U+0166 U+0104)
  0x01, 0x66, 0x01, 0x05, 0x02, // Ŧą (U+0166 U+0105)
  0x01, 0x66, 0x01, 0x06, 0x01, // ŦĆ (U+0166 U+0106)
  0x01, 0x66, 0x01, 0x07, 0x02, // Ŧć (U+0166 U+0107)
  0x01, 0x66, 0x01, 0x08, 0x01, // ŦĈ (U+0166 U+0108)
  0x01, 0x66, 0x01, 0x09, 0x02, // Ŧĉ (U+0166 U+0109)
  0x01, 0x66, 0x01, 0x0A, 0x01, // ŦĊ (U+0166 U+010A)
  0x01, 0x66, 0x01, 0x0B, 0x02, // Ŧċ (U+0166 U+010B)
  0x01, 0x66, 0x01, 0x0C, 0x01, // ŦČ (U+0166 U+010C)
  0x01, 0x66, 0x01, 0x0D, 0x02, // Ŧč (U+0166 U+010D)
  0x01, 0x66, 0x01, 0x0F, 0x02, // Ŧď (U+0166 U+010F)
  0x01, 0x66, 0x01, 0x11, 0x02, // Ŧđ (U+0166 U+0111)
  0x01, 0x66, 0x01, 0x13, 0x02, // Ŧē (U+0166 U+0113)
  0x01, 0x66, 0x01, 0x15, 0x02, // Ŧĕ (U+0166 U+0115)
  0x01, 0x66, 0x01, 0x17, 0x02, // Ŧė (U+0166 U+0117)
  0x01, 0x66, 0x01, 0x19, 0x02, // Ŧę (U+0166 U+0119)
  0x01, 0x66, 0x01, 0x1B, 0x02, // Ŧě (U+0166 U+011B)
  0x01, 0x66, 0x01, 0x1C, 0x01, // ŦĜ (U+0166 U+011C)
  0x01, 0x66, 0x01, 0x1D, 0x02, // Ŧĝ (U+0166 U+011D)
  0x01, 0x66, 0x01, 0x1E, 0x01, // ŦĞ (U+0166 U+011E)
  0x01, 0x66, 0x01, 0x1F, 0x02, // Ŧğ (U+0166 U+011F)
  0x01, 0x66, 0x01, 0x20, 0x01, // ŦĠ (U+0166 U+0120)
  0x01, 0x66, 0x01, 0x21, 0x02, // Ŧġ (U+0166 U+0121)
  0x01, 0x66, 0x01, 0x22, 0x01, // ŦĢ (U+0166 U+0122)
  0x01, 0x66, 0x01, 0x23, 0x02, // Ŧģ (U+0166 U+0123)
  0x01, 0x66, 0x01, 0x38, 0x02, // Ŧĸ (U+0166 U+0138)
  0x01, 0x66, 0x01, 0x44, 0x02, // Ŧń (U+0166 U+0144)
  0x01, 0x66, 0x01, 0x46, 0x02, // Ŧņ (U+0166 U+0146)
  0x01, 0x66, 0x01, 0x48, 0x02, // Ŧň (U+0166 U+0148)
  0x01, 0x66, 0x01, 0x4B, 0x02, // Ŧŋ (U+0166 U+014B)
  0x01, 0x66, 0x01, 0x4C, 0x01, // ŦŌ (U+0166 U+014C)
  0x01, 0x66, 0x01, 0x4D, 0x02, // Ŧō (U+0166 U+014D)
  0x01, 0x66, 0x01, 0x4E, 0x01, // ŦŎ (U+0166 U+014E)
  0x01, 0x66, 0x01, 0x4F, 0x02, // Ŧŏ (U+0166 U+014F)
  0x01, 0x66, 0x01, 0x50, 0x01, // ŦŐ (U+0166 U+0150)
  0x01, 0x66, 0x01, 0x51, 0x02, // Ŧő (U+0166 U+0151)
  0x01, 0x66, 0x01, 0x52, 0x01, // ŦŒ (U+0166 U+0152)
  0x01, 0x66, 0x01, 0x53, 0x02, // Ŧœ (U+0166 U+0153)
  0x01, 0x66, 0x01, 0x55, 0x02, // Ŧŕ (U+0166 U+0155)
  0x01, 0x66, 0x01, 0x57, 0x02, // Ŧŗ (U+0166 U+0157)
  0x01, 0x66, 0x01, 0x5B, 0x02, // Ŧś (U+0166 U+015B)
  0x01, 0x66, 0x01, 0x5D, 0x02, // Ŧŝ (U+0166 U+015D)
  0x01, 0x66, 0x01, 0x5F, 0x02, // Ŧş (U+0166 U+015F)
  0x01, 0x66, 0x01, 0x61, 0x02, // Ŧš (U+0166 U+0161)
  0x01, 0x66, 0x01, 0x69, 0x02, // Ŧũ (U+0166 U+0169)
  0x01, 0x66, 0x01, 0x6B, 0x02, // Ŧū (U+0166 U+016B)
  0x01, 0x66, 0x01, 0x6D, 0x02, // Ŧŭ (U+0166 U+016D)
  0x01, 0x66, 0x01, 0x6F, 0x02, // Ŧů (U+0166 U+016F)
  0x01, 0x66, 0x01, 0x71, 0x02, // Ŧű (U+0166 U+0171)
  0x01, 0x66, 0x01, 0x73, 0x02, // Ŧų (U+0166 U+0173)
  0x01, 0x66, 0x01, 0x75, 0x01, // Ŧŵ (U+0166 U+0175)
  0x01, 0x66, 0x01, 0x77, 0x01, // Ŧŷ (U+0166 U+0177)
  0x01, 0x66, 0x01, 0x7A, 0x01, // Ŧź (U+0166 U+017A)
  0x01, 0x66, 0x01, 0x7C, 0x01, // Ŧż (U+0166 U+017C)
  0x01, 0x66, 0x01, 0x7E, 0x01, // Ŧž (U+0166 U+017E)
  0x01, 0x66, 0x20, 0x13, 0x02, // Ŧ– (U+0166 U+2013)
  0x01, 0x66, 0x20, 0x14, 0x02, // Ŧ— (U+0166 U+2014)
  0x01, 0x66, 0x20, 0x1A, 0x02, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x02, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x02, // Ŧ… (U+0166 U+2026)
  0x01, 0x66, 0x20, 0x39, 0x02, // Ŧ‹ (U+0166 U+2039)
  0x01, 0x66, 0x20, 0x3A, 0x01, // Ŧ› (U+0166 U+203A)
  0x01, 0x68, 0x00, 0x2C, 0x01, // Ũ, (U+0168 U+002C)
  0x01, 0x68, 0x00, 0x2E, 0x01, // Ũ. (U+0168 U+002E)
  0x01, 0x68, 0x20, 0x1A, 0x01, // Ũ‚ (U+0168 U+201A)
  0x01, 0x68, 0x20, 0x1E, 0x01, // Ũ„ (U+0168 U+201E)
  0x01, 0x68, 0x20, 0x26, 0x01, // Ũ… (U+0168 U+2026)
  0x01, 0x6A, 0x00, 0x2C, 0x01, // Ū, (U+016A U+002C)
  0x01, 0x6A, 0x00, 0x2E, 0x01, // Ū. (U+016A U+002E)
  0x01, 0x6A, 0x20, 0x1A, 0x01, // Ū‚ (U+016A U+201A)
  0x01, 0x6A, 0x20, 0x1E, 0x01, // Ū„ (U+016A U+201E)
  0x01, 0x6A, 0x20, 0x26, 0x01, // Ū… (U+016A U+2026)
  0x01, 0x6C, 0x00, 0x2C, 0x01, // Ŭ, (U+016C U+002C)
  0x01, 0x6C, 0x00, 0x2E, 0x01, // Ŭ. (U+016C U+002E)
  0x01, 0x6C, 0x20, 0x1A, 0x01, // Ŭ‚ (U+016C U+201A)
  0x01, 0x6C, 0x20, 0x1E, 0x01, // Ŭ„ (U+016C U+201E)
  0x01, 0x6C, 0x20, 0x26, 0x01, // Ŭ… (U+016C U+2026)
  0x01, 0x6E, 0x00, 0x2C, 0x01, // Ů, (U+016E U+002C)
  0x01, 0x6E, 0x00, 0x2E, 0x01, // Ů. (U+016E U+002E)
  0x01, 0x6E, 0x20, 0x1A, 0x01, // Ů‚ (U+016E U+201A)
  0x01, 0x6E, 0x20, 0x1E, 0x01, // Ů„ (U+016E U+201E)
  0x01, 0x6E, 0x20, 0x26, 0x01, // Ů… (U+016E U+2026)
  0x01, 0x70, 0x00, 0x2C, 0x01, // Ű, (U+0170 U+002C)
  0x01, 0x70, 0x00, 0x2E, 0x01, // Ű. (U+0170 U+002E)
  0x01, 0x70, 0x20, 0x1A, 0x01, // Ű‚ (U+0170 U+201A)
  0x01, 0x70, 0x20, 0x1E, 0x01, // Ű„ (U+0170 U+201E)
  0x01, 0x70, 0x20, 0x26, 0x01, // Ű… (U+0170 U+2026)
  0x01, 0x72, 0x00, 0x2C, 0x01, // Ų, (U+0172 U+002C)
  0x01, 0x72, 0x00, 0x2E, 0x01, // Ų. (U+0172 U+002E)
  0x01, 0x72, 0x20, 0x1A, 0x01, // Ų‚ (U+0172 U+201A)
  0x01, 0x72, 0x20, 0x1E, 0x01, // Ų„ (U+0172 U+201E)
  0x01, 0x72, 0x20, 0x26, 0x01, // Ų… (U+0172 U+2026)
  0x01, 0x74, 0x00, 0x2C, 0x02, // Ŵ, (U+0174 U+002C)
  0x01, 0x74, 0x00, 0x2E, 0x02, // Ŵ. (U+0174 U+002E)
  0x01, 0x74, 0x00, 0x61, 0x01, // Ŵa (U+0174 U+0061)
  0x01, 0x74, 0x00, 0x63, 0x01, // Ŵc (U+0174 U+0063)
  0x01, 0x74, 0x00, 0x64, 0x01, // Ŵd (U+0174 U+0064)
  0x01, 0x74, 0x00, 0x65, 0x01, // Ŵe (U+0174 U+0065)
  0x01, 0x74, 0x00, 0x6F, 0x01, // Ŵo (U+0174 U+006F)
  0x01, 0x74, 0x00, 0x71, 0x01, // Ŵq (U+0174 U+0071)
  0x01, 0x74, 0x00, 0xAB, 0x01, // Ŵ« (U+0174 U+00AB)
  0x01, 0x74, 0x00, 0xBB, 0x01, // Ŵ» (U+0174 U+00BB)
  0x01, 0x74, 0x00, 0xE0, 0x01, // Ŵà (U+0174 U+00E0)
  0x01, 0x74, 0x00, 0xE1, 0x01, // Ŵá (U+0174 U+00E1)
  0x01, 0x74, 0x00, 0xE2, 0x01, // Ŵâ (U+0174 U+00E2)
  0x01, 0x74, 0x00, 0xE3, 0x01, // Ŵã (U+0174 U+00E3)
  0x01, 0x74, 0x00, 0xE4, 0x01, // Ŵä (U+0174 U+00E4)
  0x01, 0x74, 0x00, 0xE5, 0x01, // Ŵå (U+0174 U+00E5)
  0x01, 0x74, 0x00, 0xE6, 0x01, // Ŵæ (U+0174 U+00E6)
  0x01, 0x74, 0x00, 0xE7, 0x01, // Ŵç (U+0174 U+00E7)
  0x01, 0x74, 0x00, 0xE8, 0x01, // Ŵè (U+0174 U+00E8)
  0x01, 0x74, 0x00, 0xE9, 0x01, // Ŵé (U+0174 U+00E9)
  0x01, 0x74, 0x00, 0xEA, 0x01, // Ŵê (U+0174 U+00EA)
  0x01, 0x74, 0x00, 0xEB, 0x01, // Ŵë (U+0174 U+00EB)
  0x01, 0x74, 0x00, 0xF2, 0x01, // Ŵò (U+0174 U+00F2)
  0x01, 0x74, 0x00, 0xF3, 0x01, // Ŵó (U+0174 U+00F3)
  0x01, 0x74, 0x00, 0xF4, 0x01, // Ŵô (U+0174 U+00F4)
  0x01, 0x74, 0x00, 0xF5, 0x01, // Ŵõ (U+0174 U+00F5)
  0x01, 0x74, 0x00, 0xF6, 0x01, // Ŵö (U+0174 U+00F6)
  0x01, 0x74, 0x00, 0xF8, 0x01, // Ŵø (U+0174 U+00F8)
  0x01, 0x74, 0x01, 0x01, 0x01, // Ŵā (U+0174 U+0101)
  0x01, 0x74, 0x01, 0x03, 0x01, // Ŵă (U+0174 U+0103)
  0x01, 0x74, 0x01, 0x05, 0x01, // Ŵą (U+0174 U+0105)
  0x01, 0x74, 0x01, 0x07, 0x01, // Ŵć (U+0174 U+0107)
  0x01, 0x74, 0x01, 0x09, 0x01, // Ŵĉ (U+0174 U+0109)
  0x01, 0x74, 0x01, 0x0B, 0x01, // Ŵċ (U+0174 U+010B)
  0x01, 0x74, 0x01, 0x0D, 0x01, // Ŵč (U+0174 U+010D)
  0x01, 0x74, 0x01, 0x0F, 0x01, // Ŵď (U+0174 U+010F)
  0x01, 0x74, 0x01, 0x11, 0x01, // Ŵđ (U+0174 U+0111)
  0x01, 0x74, 0x01, 0x13, 0x01, // Ŵē (U+0174 U+0113)
  0x01, 0x74, 0x01, 0x15, 0x01, // Ŵĕ (U+0174 U+0115)
  0x01, 0x74, 0x01, 0x17, 0x01, // Ŵė (U+0174 U+0117)
  0x01, 0x74, 0x01, 0x19, 0x01, // Ŵę (U+0174 U+0119)
  0x01, 0x74, 0x01, 0x1B, 0x01, // Ŵě (U+0174 U+011B)
  0x01, 0x74, 0x01, 0x4D, 0x01, // Ŵō (U+0174 U+014D)
  0x01, 0x74, 0x01, 0x4F, 0x01, // Ŵŏ (U+0174 U+014F)
  0x01, 0x74, 0x01, 0x51, 0x01, // Ŵő (U+0174 U+0151)
  0x01, 0x74, 0x01, 0x53, 0x01, // Ŵœ (U+0174 U+0153)
  0x01, 0x74, 0x20, 0x1A, 0x02, // Ŵ‚ (U+0174 U+201A)
  0x01, 0x74, 0x20, 0x1E, 0x02, // Ŵ„ (U+0174 U+201E)
  0x01, 0x74, 0x20, 0x26, 0x02, // Ŵ… (U+0174 U+2026)
  0x01, 0x74, 0x20, 0x39, 0x01, // Ŵ‹ (U+0174 U+2039)
  0x01, 0x74, 0x20, 0x3A, 0x01, // Ŵ› (U+0174 U+203A)
  0x01, 0x75, 0x00, 0x2C, 0x01, // ŵ, (U+0175 U+002C)
  0x01, 0x75, 0x00, 0x2E, 0x01, // ŵ. (U+0175 U+002E)
  0x01, 0x75, 0x20, 0x1A, 0x01, // ŵ‚ (U+0175 U+201A)
  0x01, 0x75, 0x20, 0x1E, 0x01, // ŵ„ (U+0175 U+201E)
  0x01, 0x75, 0x20, 0x26, 0x01, // ŵ… (U+0175 U+2026)
  0x01, 0x76, 0x00, 0x26, 0x01, // Ŷ& (U+0176 U+0026)
  0x01, 0x76, 0x00, 0x2C, 0x02, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x02, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x00, 0x41, 0x01, // ŶA (U+0176 U+0041)
  0x01, 0x76, 0x00, 0x43, 0x01, // ŶC (U+0176 U+0043)
  0x01, 0x76, 0x00, 0x47, 0x01, // ŶG (U+0176 U+0047)
  0x01, 0x76, 0x00, 0x4F, 0x01, // ŶO (U+0176 U+004F)
  0x01, 0x76, 0x00, 0x51, 0x01, // ŶQ (U+0176 U+0051)
  0x01, 0x76, 0x00, 0x61, 0x01, // Ŷa (U+0176 U+0061)
  0x01, 0x76, 0x00, 0x63, 0x01, // Ŷc (U+0176 U+0063)
  0x01, 0x76, 0x00, 0x64, 0x01, // Ŷd (U+0176 U+0064)
  0x01, 0x76, 0x00, 0x65, 0x01, // Ŷe (U+0176 U+0065)
  0x01, 0x76, 0x00, 0x67, 0x01, // Ŷg (U+0176 U+0067)
  0x01, 0x76, 0x00, 0x6D, 0x01, // Ŷm (U+0176 U+006D)
  0x01, 0x76, 0x00, 0x6E, 0x01, // Ŷn (U+0176 U+006E)
  0x01, 0x76, 0x00, 0x6F, 0x01, // Ŷo (U+0176 U+006F)
  0x01, 0x76, 0x00, 0x70, 0x01, // Ŷp (U+0176 U+0070)
  0x01, 0x76, 0x00, 0x71, 0x01, // Ŷq (U+0176 U+0071)
  0x01, 0x76, 0x00, 0x72, 0x01, // Ŷr (U+0176 U+0072)
  0x01, 0x76, 0x00, 0x73, 0x01, // Ŷs (U+0176 U+0073)
  0x01, 0x76, 0x00, 0x75, 0x01, // Ŷu (U+0176 U+0075)
  0x01, 0x76, 0x00, 0x7A, 0x01, // Ŷz (U+0176 U+007A)
  0x01, 0x76, 0x00, 0xAB, 0x02, // Ŷ« (U+0176 U+00AB)
  0x01, 0x76, 0x00, 0xBB, 0x02, // Ŷ» (U+0176 U+00BB)
  0x01, 0x76, 0x00, 0xC0, 0x01, // ŶÀ (U+0176 U+00C0)
  0x01, 0x76, 0x00, 0xC1, 0x01, // ŶÁ (U+0176 U+00C1)
  0x01, 0x76, 0x00, 0xC2, 0x01, // ŶÂ (U+0176 U+00C2)
  0x01, 0x76, 0x00, 0xC3, 0x01, // ŶÃ (U+0176 U+00C3)
  0x01, 0x76, 0x00, 0xC4, 0x01, // ŶÄ (U+0176 U+00C4)
  0x01, 0x76, 0x00, 0xC5, 0x01, // ŶÅ (U+0176 U+00C5)
  0x01, 0x76, 0x00, 0xC6, 0x01, // ŶÆ (U+0176 U+00C6)
  0x01, 0x76, 0x00, 0xC7, 0x01, // ŶÇ (U+0176 U+00C7)
  0x01, 0x76, 0x00, 0xD2, 0x01, // ŶÒ (U+0176 U+00D2)
  0x01, 0x76, 0x00, 0xD3, 0x01, // ŶÓ (U+0176 U+00D3)
  0x01, 0x76, 0x00, 0xD4, 0x01, // ŶÔ (U+0176 U+00D4)
  0x01, 0x76, 0x00, 0xD5, 0x01, // ŶÕ (U+0176 U+00D5)
  0x01, 0x76, 0x00, 0xD6, 0x01, // ŶÖ (U+0176 U+00D6)
  0x01, 0x76, 0x00, 0xD8, 0x01, // ŶØ (U+0176 U+00D8)
  0x01, 0x76, 0x00, 0xE0, 0x01, // Ŷà (U+0176 U+00E0)
  0x01, 0x76, 0x00, 0xE1, 0x01, // Ŷá (U+0176 U+00E1)
  0x01, 0x76, 0x00, 0xE2, 0x01, // Ŷâ (U+0176 U+00E2)
  0x01, 0x76, 0x00, 0xE3, 0x01, // Ŷã (U+0176 U+00E3)
  0x01, 0x76, 0x00, 0xE4, 0x01, // Ŷä (U+0176 U+00E4)
  0x01, 0x76, 0x00, 0xE5, 0x01, // Ŷå (U+0176 U+00E5)
  0x01, 0x76, 0x00, 0xE6, 0x01, // Ŷæ (U+0176 U+00E6)
  0x01, 0x76, 0x00, 0xE7, 0x01, // Ŷç (U+0176 U+00E7)
  0x01, 0x76, 0x00, 0xE8, 0x01, // Ŷè (U+0176 U+00E8)
  0x01, 0x76, 0x00, 0xE9, 0x01, // Ŷé (U+0176 U+00E9)
  0x01, 0x76, 0x00, 0xEA, 0x01, // Ŷê (U+0176 U+00EA)
  0x01, 0x76, 0x00, 0xEB, 0x01, // Ŷë (U+0176 U+00EB)
  0x01, 0x76, 0x00, 0xF1, 0x01, // Ŷñ (U+0176 U+00F1)
  0x01, 0x76, 0x00, 0xF2, 0x01, // Ŷò (U+0176 U+00F2)
  0x01, 0x76, 0x00, 0xF3, 0x01, // Ŷó (U+0176 U+00F3)
  0x01, 0x76, 0x00, 0xF4, 0x01, // Ŷô (U+0176 U+00F4)
  0x01, 0x76, 0x00, 0xF5, 0x01, // Ŷõ (U+0176 U+00F5)
  0x01, 0x76, 0x00, 0xF6, 0x01, // Ŷö (U+0176 U+00F6)
  0x01, 0x76, 0x00, 0xF8, 0x01, // Ŷø (U+0176 U+00F8)
  0x01, 0x76, 0x00, 0xF9, 0x01, // Ŷù (U+0176 U+00F9)
  0x01, 0x76, 0x00, 0xFA, 0x01, // Ŷú (U+0176 U+00FA)
  0x01, 0x76, 0x00, 0xFB, 0x01, // Ŷû (U+0176 U+00FB)
  0x01, 0x76, 0x00, 0xFC, 0x01, // Ŷü (U+0176 U+00FC)
  0x01, 0x76, 0x01, 0x00, 0x01, // ŶĀ (U+0176 U+0100)
  0x01, 0x76, 0x01, 0x01, 0x01, // Ŷā (U+0176 U+0101)
  0x01, 0x76, 0x01, 0x02, 0x01, // ŶĂ (U+0176 U+0102)
  0x01, 0x76, 0x01, 0x03, 0x01, // Ŷă (U+0176 U+0103)
  0x01, 0x76, 0x01, 0x04, 0x01, // ŶĄ (U+0176 U+0104)
  0x01, 0x76, 0x01, 0x05, 0x01, // Ŷą (U+0176 U+0105)
  0x01, 0x76, 0x01, 0x06, 0x01, // ŶĆ (U+0176 U+0106)
  0x01, 0x76, 0x01, 0x07, 0x01, // Ŷć (U+0176 U+0107)
  0x01, 0x76, 0x01, 0x08, 0x01, // ŶĈ (U+0176 U+0108)
  0x01, 0x76, 0x01, 0x09, 0x01, // Ŷĉ (U+0176 U+0109)
  0x01, 0x76, 0x01, 0x0A, 0x01, // ŶĊ (U+0176 U+010A)
  0x01, 0x76, 0x01, 0x0B, 0x01, // Ŷċ (U+0176 U+010B)
  0x01, 0x76, 0x01, 0x0C, 0x01, // ŶČ (U+0176 U+010C)
  0x01, 0x76, 0x01, 0x0D, 0x01, // Ŷč (U+0176 U+010D)
  0x01, 0x76, 0x01, 0x0F, 0x01, // Ŷď (U+0176 U+010F)
  0x01, 0x76, 0x01, 0x11, 0x01, // Ŷđ (U+0176 U+0111)
  0x01, 0x76, 0x01, 0x13, 0x01, // Ŷē (U+0176 U+0113)
  0x01, 0x76, 0x01, 0x15, 0x01, // Ŷĕ (U+0176 U+0115)
  0x01, 0x76, 0x01, 0x17, 0x01, // Ŷė (U+0176 U+0117)
  0x01, 0x76, 0x01, 0x19, 0x01, // Ŷę (U+0176 U+0119)
  0x01, 0x76, 0x01, 0x1B, 0x01, // Ŷě (U+0176 U+011B)
  0x01, 0x76, 0x01, 0x1C, 0x01, // ŶĜ (U+0176 U+011C)
  0x01, 0x76, 0x01, 0x1D, 0x01, // Ŷĝ (U+0176 U+011D)
  0x01, 0x76, 0x01, 0x1E, 0x01, // ŶĞ (U+0176 U+011E)
  0x01, 0x76, 0x01, 0x1F, 0x01, // Ŷğ (U+0176 U+011F)
  0x01, 0x76, 0x01, 0x20, 0x01, // ŶĠ (U+0176 U+0120)
  0x01, 0x76, 0x01, 0x21, 0x01, // Ŷġ (U+0176 U+0121)
  0x01, 0x76, 0x01, 0x22, 0x01, // ŶĢ (U+0176 U+0122)
  0x01, 0x76, 0x01, 0x23, 0x01, // Ŷģ (U+0176 U+0123)
  0x01, 0x76, 0x01, 0x38, 0x01, // Ŷĸ (U+0176 U+0138)
  0x01, 0x76, 0x01, 0x44, 0x01, // Ŷń (U+0176 U+0144)
  0x01, 0x76, 0x01, 0x46, 0x01, // Ŷņ (U+0176 U+0146)
  0x01, 0x76, 0x01, 0x48, 0x01, // Ŷň (U+0176 U+0148)
  0x01, 0x76, 0x01, 0x4B, 0x01, // Ŷŋ (U+0176 U+014B)
  0x01, 0x76, 0x01, 0x4C, 0x01, // ŶŌ (U+0176 U+014C)
  0x01, 0x76, 0x01, 0x4D, 0x01, // Ŷō (U+0176 U+014D)
  0x01, 0x76, 0x01, 0x4E, 0x01, // ŶŎ (U+0176 U+014E)
  0x01, 0x76, 0x01, 0x4F, 0x01, // Ŷŏ (U+0176 U+014F)
  0x01, 0x76, 0x01, 0x50, 0x01, // ŶŐ (U+0176 U+0150)
  0x01, 0x76, 0x01, 0x51, 0x01, // Ŷő (U+0176 U+0151)
  0x01, 0x76, 0x01, 0x52, 0x01, // ŶŒ (U+0176 U+0152)
  0x01, 0x76, 0x01, 0x53, 0x01, // Ŷœ (U+0176 U+0153)
  0x01, 0x76, 0x01, 0x55, 0x01, // Ŷŕ (U+0176 U+0155)
  0x01, 0x76, 0x01, 0x57, 0x01, // Ŷŗ (U+0176 U+0157)
  0x01, 0x76, 0x01, 0x5B, 0x01, // Ŷś (U+0176 U+015B)
  0x01, 0x76, 0x01, 0x5D, 0x01, // Ŷŝ (U+0176 U+015D)
  0x01, 0x76, 0x01, 0x5F, 0x01, // Ŷş (U+0176 U+015F)
  0x01, 0x76, 0x01, 0x61, 0x01, // Ŷš (U+0176 U+0161)
  0x01, 0x76, 0x01, 0x69, 0x01, // Ŷũ (U+0176 U+0169)
  0x01, 0x76, 0x01, 0x6B, 0x01, // Ŷū (U+0176 U+016B)
  0x01, 0x76, 0x01, 0x6D, 0x01, // Ŷŭ (U+0176 U+016D)
  0x01, 0x76, 0x01, 0x6F, 0x01, // Ŷů (U+0176 U+016F)
  0x01, 0x76, 0x01, 0x71, 0x01, // Ŷű (U+0176 U+0171)
  0x01, 0x76, 0x01, 0x73, 0x01, // Ŷų (U+0176 U+0173)
  0x01, 0x76, 0x01, 0x7A, 0x01, // Ŷź (U+0176 U+017A)
  0x01, 0x76, 0x01, 0x7C, 0x01, // Ŷż (U+0176 U+017C)
  0x01, 0x76, 0x01, 0x7E, 0x01, // Ŷž (U+0176 U+017E)
  0x01, 0x76, 0x20, 0x1A, 0x02, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x02, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x02, // Ŷ… (U+0176 U+2026)
  0x01, 0x76, 0x20, 0x39, 0x02, // Ŷ‹ (U+0176 U+2039)
  0x01, 0x76, 0x20, 0x3A, 0x02, // Ŷ› (U+0176 U+203A)
  0x01, 0x77, 0x00, 0x2C, 0x01, // ŷ, (U+0177 U+002C)
  0x01, 0x77, 0x00, 0x2E, 0x01, // ŷ. (U+0177 U+002E)
  0x01, 0x77, 0x20, 0x1A, 0x01, // ŷ‚ (U+0177 U+201A)
  0x01, 0x77, 0x20, 0x1E, 0x01, // ŷ„ (U+0177 U+201E)
  0x01, 0x77, 0x20, 0x26, 0x01, // ŷ… (U+0177 U+2026)
  0x01, 0x78, 0x00, 0x26, 0x01, // Ÿ& (U+0178 U+0026)
  0x01, 0x78, 0x00, 0x2C, 0x02, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x02, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x00, 0x41, 0x01, // ŸA (U+0178 U+0041)
  0x01, 0x78, 0x00, 0x43, 0x01, // ŸC (U+0178 U+0043)
  0x01, 0x78, 0x00, 0x47, 0x01, // ŸG (U+0178 U+0047)
  0x01, 0x78, 0x00, 0x4F, 0x01, // ŸO (U+0178 U+004F)
  0x01, 0x78, 0x00, 0x51, 0x01, // ŸQ (U+0178 U+0051)
  0x01, 0x78, 0x00, 0x61, 0x01, // Ÿa (U+0178 U+0061)
  0x01, 0x78, 0x00, 0x63, 0x01, // Ÿc (U+0178 U+0063)
  0x01, 0x78, 0x00, 0x64, 0x01, // Ÿd (U+0178 U+0064)
  0x01, 0x78, 0x00, 0x65, 0x01, // Ÿe (U+0178 U+0065)
  0x01, 0x78, 0x00, 0x67, 0x01, // Ÿg (U+0178 U+0067)
  0x01, 0x78, 0x00, 0x6D, 0x01, // Ÿm (U+0178 U+006D)
  0x01, 0x78, 0x00, 0x6E, 0x01, // Ÿn (U+0178 U+006E)
  0x01, 0x78, 0x00, 0x6F, 0x01, // Ÿo (U+0178 U+006F)
  0x01, 0x78, 0x00, 0x70, 0x01, // Ÿp (U+0178 U+0070)
  0x01, 0x78, 0x00, 0x71, 0x01, // Ÿq (U+0178 U+0071)
  0x01, 0x78, 0x00, 0x72, 0x01, // Ÿr (U+0178 U+0072)
  0x01, 0x78, 0x00, 0x73, 0x01, // Ÿs (U+0178 U+0073)
  0x01, 0x78, 0x00, 0x75, 0x01, // Ÿu (U+0178 U+0075)
  0x01, 0x78, 0x00, 0x7A, 0x01, // Ÿz (U+0178 U+007A)
  0x01, 0x78, 0x00, 0xAB, 0x02, // Ÿ« (U+0178 U+00AB)
  0x01, 0x78, 0x00, 0xBB, 0x02, // Ÿ» (U+0178 U+00BB)
  0x01, 0x78, 0x00, 0xC0, 0x01, // ŸÀ (U+0178 U+00C0)
  0x01, 0x78, 0x00, 0xC1, 0x01, // ŸÁ (U+0178 U+00C1)
  0x01, 0x78, 0x00, 0xC2, 0x01, // ŸÂ (U+0178 U+00C2)
  0x01, 0x78, 0x00, 0xC3, 0x01, // ŸÃ (U+0178 U+00C3)
  0x01, 0x78, 0x00, 0xC4, 0x01, // ŸÄ (U+0178 U+00C4)
  0x01, 0x78, 0x00, 0xC5, 0x01, // ŸÅ (U+0178 U+00C5)
  0x01, 0x78, 0x00, 0xC6, 0x01, // ŸÆ (U+0178 U+00C6)
  0x01, 0x78, 0x00, 0xC7, 0x01, // ŸÇ (U+0178 U+00C7)
  0x01, 0x78, 0x00, 0xD2, 0x01, // ŸÒ (U+0178 U+00D2)
  0x01, 0x78, 0x00, 0xD3, 0x01, // ŸÓ (U+0178 U+00D3)
  0x01, 0x78, 0x00, 0xD4, 0x01, // ŸÔ (U+0178 U+00D4)
  0x01, 0x78, 0x00, 0xD5, 0x01, // ŸÕ (U+0178 U+00D5)
  0x01, 0x78, 0x00, 0xD6, 0x01, // ŸÖ (U+0178 U+00D6)
  0x01, 0x78, 0x00, 0xD8, 0x01, // ŸØ (U+0178 U+00D8)
  0x01, 0x78, 0x00, 0xE0, 0x01, // Ÿà (U+0178 U+00E0)
  0x01, 0x78, 0x00, 0xE1, 0x01, // Ÿá (U+0178 U+00E1)
  0x01, 0x78, 0x00, 0xE2, 0x01, // Ÿâ (U+0178 U+00E2)
  0x01, 0x78, 0x00, 0xE3, 0x01, // Ÿã (U+0178 U+00E3)
  0x01, 0x78, 0x00, 0xE4, 0x01, // Ÿä (U+0178 U+00E4)
  0x01, 0x78, 0x00, 0xE5, 0x01, // Ÿå (U+0178 U+00E5)
  0x01, 0x78, 0x00, 0xE6, 0x01, // Ÿæ (U+0178 U+00E6)
  0x01, 0x78, 0x00, 0xE7, 0x01, // Ÿç (U+0178 U+00E7)
  0x01, 0x78, 0x00, 0xE8, 0x01, // Ÿè (U+0178 U+00E8)
  0x01, 0x78, 0x00, 0xE9, 0x01, // Ÿé (U+0178 U+00E9)
  0x01, 0x78, 0x00, 0xEA, 0x01, // Ÿê (U+0178 U+00EA)
  0x01, 0x78, 0x00, 0xEB, 0x01, // Ÿë (U+0178 U+00EB)
  0x01, 0x78, 0x00, 0xF1, 0x01, // Ÿñ (U+0178 U+00F1)
  0x01, 0x78, 0x00, 0xF2, 0x01, // Ÿò (U+0178 U+00F2)
  0x01, 0x78, 0x00, 0xF3, 0x01, // Ÿó (U+0178 U+00F3)
  0x01, 0x78, 0x00, 0xF4, 0x01, // Ÿô (U+0178 U+00F4)
  0x01, 0x78, 0x00, 0xF5, 0x01, // Ÿõ (U+0178 U+00F5)
  0x01, 0x78, 0x00, 0xF6, 0x01, // Ÿö (U+0178 U+00F6)
  0x01, 0x78, 0x00, 0xF8, 0x01, // Ÿø (U+0178 U+00F8)
  0x01, 0x78, 0x00, 0xF9, 0x01, // Ÿù (U+0178 U+00F9)
  0x01, 0x78, 0x00, 0xFA, 0x01, // Ÿú (U+0178 U+00FA)
  0x01, 0x78, 0x00, 0xFB, 0x01, // Ÿû (U+0178 U+00FB)
  0x01, 0x78, 0x00, 0xFC, 0x01, // Ÿü (U+0178 U+00FC)
  0x01, 0x78, 0x01, 0x00, 0x01, // ŸĀ (U+0178 U+0100)
  0x01, 0x78, 0x01, 0x01, 0x01, // Ÿā (U+0178 U+0101)
  0x01, 0x78, 0x01, 0x02, 0x01, // ŸĂ (U+0178 U+0102)
  0x01, 0x78, 0x01, 0x03, 0x01, // Ÿă (U+0178 U+0103)
  0x01, 0x78, 0x01, 0x04, 0x01, // ŸĄ (U+0178 U+0104)
  0x01, 0x78, 0x01, 0x05, 0x01, // Ÿą (U+0178 U+0105)
  0x01, 0x78, 0x01, 0x06, 0x01, // ŸĆ (U+0178 U+0106)
  0x01, 0x78, 0x01, 0x07, 0x01, // Ÿć (U+0178 U+0107)
  0x01, 0x78, 0x01, 0x08, 0x01, // ŸĈ (U+0178 U+0108)
  0x01, 0x78, 0x01, 0x09, 0x01, // Ÿĉ (U+0178 U+0109)
  0x01, 0x78, 0x01, 0x0A, 0x01, // ŸĊ (U+0178 U+010A)
  0x01, 0x78, 0x01, 0x0B, 0x01, // Ÿċ (U+0178 U+010B)
  0x01, 0x78, 0x01, 0x0C, 0x01, // ŸČ (U+0178 U+010C)
  0x01, 0x78, 0x01, 0x0D, 0x01, // Ÿč (U+0178 U+010D)
  0x01, 0x78, 0x01, 0x0F, 0x01, // Ÿď (U+0178 U+010F)
  0x01, 0x78, 0x01, 0x11, 0x01, // Ÿđ (U+0178 U+0111)
  0x01, 0x78, 0x01, 0x13, 0x01, // Ÿē (U+0178 U+0113)
  0x01, 0x78, 0x01, 0x15, 0x01, // Ÿĕ (U+0178 U+0115)
  0x01, 0x78, 0x01, 0x17, 0x01, // Ÿė (U+0178 U+0117)
  0x01, 0x78, 0x01, 0x19, 0x01, // Ÿę (U+0178 U+0119)
  0x01, 0x78, 0x01, 0x1B, 0x01, // Ÿě (U+0178 U+011B)
  0x01, 0x78, 0x01, 0x1C, 0x01, // ŸĜ (U+0178 U+011C)
  0x01, 0x78, 0x01, 0x1D, 0x01, // Ÿĝ (U+0178 U+011D)
  0x01, 0x78, 0x01, 0x1E, 0x01, // ŸĞ (U+0178 U+011E)
  0x01, 0x78, 0x01, 0x1F, 0x01, // Ÿğ (U+0178 U+011F)
  0x01, 0x78, 0x01, 0x20, 0x01, // ŸĠ (U+0178 U+0120)
  0x01, 0x78, 0x01, 0x21, 0x01, // Ÿġ (U+0178 U+0121)
  0x01, 0x78, 0x01, 0x22, 0x01, // ŸĢ (U+0178 U+0122)
  0x01, 0x78, 0x01, 0x23, 0x01, // Ÿģ (U+0178 U+0123)
  0x01, 0x78, 0x01, 0x38, 0x01, // Ÿĸ (U+0178 U+0138)
  0x01, 0x78, 0x01, 0x44, 0x01, // Ÿń (U+0178 U+0144)
  0x01, 0x78, 0x01, 0x46, 0x01, // Ÿņ (U+0178 U+0146)
  0x01, 0x78, 0x01, 0x48, 0x01, // Ÿň (U+0178 U+0148)
  0x01, 0x78, 0x01, 0x4B, 0x01, // Ÿŋ (U+0178 U+014B)
  0x01, 0x78, 0x01, 0x4C, 0x01, // ŸŌ (U+0178 U+014C)
  0x01, 0x78, 0x01, 0x4D, 0x01, // Ÿō (U+0178 U+014D)
  0x01, 0x78, 0x01, 0x4E, 0x01, // ŸŎ (U+0178 U+014E)
  0x01, 0x78, 0x01, 0x4F, 0x01, // Ÿŏ (U+0178 U+014F)
  0x01, 0x78, 0x01, 0x50, 0x01, // ŸŐ (U+0178 U+0150)
  0x01, 0x78, 0x01, 0x51, 0x01, // Ÿő (U+0178 U+0151)
  0x01, 0x78, 0x01, 0x52, 0x01, // ŸŒ (U+0178 U+0152)
  0x01, 0x78, 0x01, 0x53, 0x01, // Ÿœ (U+0178 U+0153)
  0x01, 0x78, 0x01, 0x55, 0x01, // Ÿŕ (U+0178 U+0155)
  0x01, 0x78, 0x01, 0x57, 0x01, // Ÿŗ (U+0178 U+0157)
  0x01, 0x78, 0x01, 0x5B, 0x01, // Ÿś (U+0178 U+015B)
  0x01, 0x78, 0x01, 0x5D, 0x01, // Ÿŝ (U+0178 U+015D)
  0x01, 0x78, 0x01, 0x5F, 0x01, // Ÿş (U+0178 U+015F)
  0x01, 0x78, 0x01, 0x61, 0x01, // Ÿš (U+0178 U+0161)
  0x01, 0x78, 0x01, 0x69, 0x01, // Ÿũ (U+0178 U+0169)
  0x01, 0x78, 0x01, 0x6B, 0x01, // Ÿū (U+0178 U+016B)
  0x01, 0x78, 0x01, 0x6D, 0x01, // Ÿŭ (U+0178 U+016D)
  0x01, 0x78, 0x01, 0x6F, 0x01, // Ÿů (U+0178 U+016F)
  0x01, 0x78, 0x01, 0x71, 0x01, // Ÿű (U+0178 U+0171)
  0x01, 0x78, 0x01, 0x73, 0x01, // Ÿų (U+0178 U+0173)
  0x01, 0x78, 0x01, 0x7A, 0x01, // Ÿź (U+0178 U+017A)
  0x01, 0x78, 0x01, 0x7C, 0x01, // Ÿż (U+0178 U+017C)
  0x01, 0x78, 0x01, 0x7E, 0x01, // Ÿž (U+0178 U+017E)
  0x01, 0x78, 0x20, 0x1A, 0x02, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x02, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x02, // Ÿ… (U+0178 U+2026)
  0x01, 0x78, 0x20, 0x39, 0x02, // Ÿ‹ (U+0178 U+2039)
  0x01, 0x78, 0x20, 0x3A, 0x02, // Ÿ› (U+0178 U+203A)
  0x01, 0x79, 0x00, 0x26, 0x01, // Ź& (U+0179 U+0026)
  0x01, 0x7B, 0x00, 0x26, 0x01, // Ż& (U+017B U+0026)
  0x01, 0x7D, 0x00, 0x26, 0x01, // Ž& (U+017D U+0026)
  0x20, 0x13, 0x00, 0x54, 0x02, // –T (U+2013 U+0054)
  0x20, 0x13, 0x01, 0x62, 0x02, // –Ţ (U+2013 U+0162)
  0x20, 0x13, 0x01, 0x64, 0x02, // –Ť (U+2013 U+0164)
  0x20, 0x13, 0x01, 0x66, 0x02, // –Ŧ (U+2013 U+0166)
  0x20, 0x14, 0x00, 0x54, 0x02, // —T (U+2014 U+0054)
  0x20, 0x14, 0x01, 0x62, 0x02, // —Ţ (U+2014 U+0162)
  0x20, 0x14, 0x01, 0x64, 0x02, // —Ť (U+2014 U+0164)
  0x20, 0x14, 0x01, 0x66, 0x02, // —Ŧ (U+2014 U+0166)
  0x20, 0x18, 0x00, 0x41, 0x02, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0x61, 0x02, // ‘a (U+2018 U+0061)
  0x20, 0x18, 0x00, 0x63, 0x02, // ‘c (U+2018 U+0063)
  0x20, 0x18, 0x00, 0x64, 0x02, // ‘d (U+2018 U+0064)
  0x20, 0x18, 0x00, 0x65, 0x02, // ‘e (U+2018 U+0065)
  0x20, 0x18, 0x00, 0x67, 0x01, // ‘g (U+2018 U+0067)
  0x20, 0x18, 0x00, 0x6D, 0x01, // ‘m (U+2018 U+006D)
  0x20, 0x18, 0x00, 0x6E, 0x01, // ‘n (U+2018 U+006E)
  0x20, 0x18, 0x00, 0x6F, 0x02, // ‘o (U+2018 U+006F)
  0x20, 0x18, 0x00, 0x70, 0x01, // ‘p (U+2018 U+0070)
  0x20, 0x18, 0x00, 0x71, 0x02, // ‘q (U+2018 U+0071)
  0x20, 0x18, 0x00, 0x72, 0x01, // ‘r (U+2018 U+0072)
  0x20, 0x18, 0x00, 0x73, 0x01, // ‘s (U+2018 U+0073)
  0x20, 0x18, 0x00, 0x75, 0x01, // ‘u (U+2018 U+0075)
  0x20, 0x18, 0x00, 0xC0, 0x02, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x02, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x02, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x02, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x02, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x02, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xE0, 0x02, // ‘à (U+2018 U+00E0)
  0x20, 0x18, 0x00, 0xE1, 0x02, // ‘á (U+2018 U+00E1)
  0x20, 0x18, 0x00, 0xE2, 0x02, // ‘â (U+2018 U+00E2)
  0x20, 0x18, 0x00, 0xE3, 0x02, // ‘ã (U+2018 U+00E3)
  0x20, 0x18, 0x00, 0xE4, 0x02, // ‘ä (U+2018 U+00E4)
  0x20, 0x18, 0x00, 0xE5, 0x02, // ‘å (U+2018 U+00E5)
  0x20, 0x18, 0x00, 0xE6, 0x02, // ‘æ (U+2018 U+00E6)
  0x20, 0x18, 0x00, 0xE7, 0x02, // ‘ç (U+2018 U+00E7)
  0x20, 0x18, 0x00, 0xE8, 0x02, // ‘è (U+2018 U+00E8)
  0x20, 0x18, 0x00, 0xE9, 0x02, // ‘é (U+2018 U+00E9)
  0x20, 0x18, 0x00, 0xEA, 0x02, // ‘ê (U+2018 U+00EA)
  0x20, 0x18, 0x00, 0xEB, 0x02, // ‘ë (U+2018 U+00EB)
  0x20, 0x18, 0x00, 0xF1, 0x01, // ‘ñ (U+2018 U+00F1)
  0x20, 0x18, 0x00, 0xF2, 0x02, // ‘ò (U+2018 U+00F2)
  0x20, 0x18, 0x00, 0xF3, 0x02, // ‘ó (U+2018 U+00F3)
  0x20, 0x18, 0x00, 0xF4, 0x02, // ‘ô (U+2018 U+00F4)
  0x20, 0x18, 0x00, 0xF5, 0x02, // ‘õ (U+2018 U+00F5)
  0x20, 0x18, 0x00, 0xF6, 0x02, // ‘ö (U+2018 U+00F6)
  0x20, 0x18, 0x00, 0xF8, 0x02, // ‘ø (U+2018 U+00F8)
  0x20, 0x18, 0x00, 0xF9, 0x01, // ‘ù (U+2018 U+00F9)
  0x20, 0x18, 0x00, 0xFA, 0x01, // ‘ú (U+2018 U+00FA)
  0x20, 0x18, 0x00, 0xFB, 0x01, // ‘û (U+2018 U+00FB)
  0x20, 0x18, 0x00, 0xFC, 0x01, // ‘ü (U+2018 U+00FC)
  0x20, 0x18, 0x01, 0x00, 0x02, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x01, 0x02, // ‘ā (U+2018 U+0101)
  0x20, 0x18, 0x01, 0x02, 0x02, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x03, 0x02, // ‘ă (U+2018 U+0103)
  0x20, 0x18, 0x01, 0x04, 0x02, // ‘Ą (U+2018 U+0104)
  0x20, 0x18, 0x01, 0x05, 0x02, // ‘ą (U+2018 U+0105)
  0x20, 0x18, 0x01, 0x07, 0x02, // ‘ć (U+2018 U+0107)
  0x20, 0x18, 0x01, 0x09, 0x02, // ‘ĉ (U+2018 U+0109)
  0x20, 0x18, 0x01, 0x0B, 0x02, // ‘ċ (U+2018 U+010B)
  0x20, 0x18, 0x01, 0x0D, 0x02, // ‘č (U+2018 U+010D)
  0x20, 0x18, 0x01, 0x0F, 0x02, // ‘ď (U+2018 U+010F)
  0x20, 0x18, 0x01, 0x11, 0x02, // ‘đ (U+2018 U+0111)
  0x20, 0x18, 0x01, 0x13, 0x02, // ‘ē (U+2018 U+0113)
  0x20, 0x18, 0x01, 0x15, 0x02, // ‘ĕ (U+2018 U+0115)
  0x20, 0x18, 0x01, 0x17, 0x02, // ‘ė (U+2018 U+0117)
  0x20, 0x18, 0x01, 0x19, 0x02, // ‘ę (U+2018 U+0119)
  0x20, 0x18, 0x01, 0x1B, 0x02, // ‘ě (U+2018 U+011B)
  0x20, 0x18, 0x01, 0x1D, 0x01, // ‘ĝ (U+2018 U+011D)
  0x20, 0x18, 0x01, 0x1F, 0x01, // ‘ğ (U+2018 U+011F)
  0x20, 0x18, 0x01, 0x21, 0x01, // ‘ġ (U+2018 U+0121)
  0x20, 0x18, 0x01, 0x23, 0x01, // ‘ģ (U+2018 U+0123)
  0x20, 0x18, 0x01, 0x38, 0x01, // ‘ĸ (U+2018 U+0138)
  0x20, 0x18, 0x01, 0x44, 0x01, // ‘ń (U+2018 U+0144)
  0x20, 0x18, 0x01, 0x46, 0x01, // ‘ņ (U+2018 U+0146)
  0x20, 0x18, 0x01, 0x48, 0x01, // ‘ň (U+2018 U+0148)
  0x20, 0x18, 0x01, 0x4B, 0x01, // ‘ŋ (U+2018 U+014B)
  0x20, 0x18, 0x01, 0x4D, 0x02, // ‘ō (U+2018 U+014D)
  0x20, 0x18, 0x01, 0x4F, 0x02, // ‘ŏ (U+2018 U+014F)
  0x20, 0x18, 0x01, 0x51, 0x02, // ‘ő (U+2018 U+0151)
  0x20, 0x18, 0x01, 0x53, 0x02, // ‘œ (U+2018 U+0153)
  0x20, 0x18, 0x01, 0x55, 0x01, // ‘ŕ (U+2018 U+0155)
  0x20, 0x18, 0x01, 0x57, 0x01, // ‘ŗ (U+2018 U+0157)
  0x20, 0x18, 0x01, 0x5B, 0x01, // ‘ś (U+2018 U+015B)
  0x20, 0x18, 0x01, 0x5D, 0x01, // ‘ŝ (U+2018 U+015D)
  0x20, 0x18, 0x01, 0x5F, 0x01, // ‘ş (U+2018 U+015F)
  0x20, 0x18, 0x01, 0x61, 0x01, // ‘š (U+2018 U+0161)
  0x20, 0x18, 0x01, 0x69, 0x01, // ‘ũ (U+2018 U+0169)
  0x20, 0x18, 0x01, 0x6B, 0x01, // ‘ū (U+2018 U+016B)
  0x20, 0x18, 0x01, 0x6D, 0x01, // ‘ŭ (U+2018 U+016D)
  0x20, 0x18, 0x01, 0x6F, 0x01, // ‘ů (U+2018 U+016F)
  0x20, 0x18, 0x01, 0x71, 0x01, // ‘ű (U+2018 U+0171)
  0x20, 0x18, 0x01, 0x73, 0x01, // ‘ų (U+2018 U+0173)
  0x20, 0x19, 0x00, 0x41, 0x02, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0x61, 0x02, // ’a (U+2019 U+0061)
  0x20, 0x19, 0x00, 0x63, 0x02, // ’c (U+2019 U+0063)
  0x20, 0x19, 0x00, 0x64, 0x02, // ’d (U+2019 U+0064)
  0x20, 0x19, 0x00, 0x65, 0x02, // ’e (U+2019 U+0065)
  0x20, 0x19, 0x00, 0x67, 0x01, // ’g (U+2019 U+0067)
  0x20, 0x19, 0x00, 0x6D, 0x01, // ’m (U+2019 U+006D)
  0x20, 0x19, 0x00, 0x6E, 0x01, // ’n (U+2019 U+006E)
  0x20, 0x19, 0x00, 0x6F, 0x02, // ’o (U+2019 U+006F)
  0x20, 0x19, 0x00, 0x70, 0x01, // ’p (U+2019 U+0070)
  0x20, 0x19, 0x00, 0x71, 0x02, // ’q (U+2019 U+0071)
  0x20, 0x19, 0x00, 0x72, 0x01, // ’r (U+2019 U+0072)
  0x20, 0x19, 0x00, 0x73, 0x01, // ’s (U+2019 U+0073)
  0x20, 0x19, 0x00, 0x75, 0x01, // ’u (U+2019 U+0075)
  0x20, 0x19, 0x00, 0xC0, 0x02, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x02, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x02, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x02, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x02, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x02, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xE0, 0x02, // ’à (U+2019 U+00E0)
  0x20, 0x19, 0x00, 0xE1, 0x02, // ’á (U+2019 U+00E1)
  0x20, 0x19, 0x00, 0xE2, 0x02, // ’â (U+2019 U+00E2)
  0x20, 0x19, 0x00, 0xE3, 0x02, // ’ã (U+2019 U+00E3)
  0x20, 0x19, 0x00, 0xE4, 0x02, // ’ä (U+2019 U+00E4)
  0x20, 0x19, 0x00, 0xE5, 0x02, // ’å (U+2019 U+00E5)
  0x20, 0x19, 0x00, 0xE6, 0x02, // ’æ (U+2019 U+00E6)
  0x20, 0x19, 0x00, 0xE7, 0x02, // ’ç (U+2019 U+00E7)
  0x20, 0x19, 0x00, 0xE8, 0x02, // ’è (U+2019 U+00E8)
  0x20, 0x19, 0x00, 0xE9, 0x02, // ’é (U+2019 U+00E9)
  0x20, 0x19, 0x00, 0xEA, 0x02, // ’ê (U+2019 U+00EA)
  0x20, 0x19, 0x00, 0xEB, 0x02, // ’ë (U+2019 U+00EB)
  0x20, 0x19, 0x00, 0xF1, 0x01, // ’ñ (U+2019 U+00F1)
  0x20, 0x19, 0x00, 0xF2, 0x02, // ’ò (U+2019 U+00F2)
  0x20, 0x19, 0x00, 0xF3, 0x02, // ’ó (U+2019 U+00F3)
  0x20, 0x19, 0x00, 0xF4, 0x02, // ’ô (U+2019 U+00F4)
  0x20, 0x19, 0x00, 0xF5, 0x02, // ’õ (U+2019 U+00F5)
  0x20, 0x19, 0x00, 0xF6, 0x02, // ’ö (U+2019 U+00F6)
  0x20, 0x19, 0x00, 0xF8, 0x02, // ’ø (U+2019 U+00F8)
  0x20, 0x19, 0x00, 0xF9, 0x01, // ’ù (U+2019 U+00F9)
  0x20, 0x19, 0x00, 0xFA, 0x01, // ’ú (U+2019 U+00FA)
  0x20, 0x19, 0x00, 0xFB, 0x01, // ’û (U+2019 U+00FB)
  0x20, 0x19, 0x00, 0xFC, 0x01, // ’ü (U+2019 U+00FC)
  0x20, 0x19, 0x01, 0x00, 0x02, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x01, 0x02, // ’ā (U+2019 U+0101)
  0x20, 0x19, 0x01, 0x02, 0x02, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x03, 0x02, // ’ă (U+2019 U+0103)
  0x20, 0x19, 0x01, 0x04, 0x02, // ’Ą (U+2019 U+0104)
  0x20, 0x19, 0x01, 0x05, 0x02, // ’ą (U+2019 U+0105)
  0x20, 0x19, 0x01, 0x07, 0x02, // ’ć (U+2019 U+0107)
  0x20, 0x19, 0x01, 0x09, 0x02, // ’ĉ (U+2019 U+0109)
  0x20, 0x19, 0x01, 0x0B, 0x02, // ’ċ (U+2019 U+010B)
  0x20, 0x19, 0x01, 0x0D, 0x02, // ’č (U+2019 U+010D)
  0x20, 0x19, 0x01, 0x0F, 0x02, // ’ď (U+2019 U+010F)
  0x20, 0x19, 0x01, 0x11, 0x02, // ’đ (U+2019 U+0111)
  0x20, 0x19, 0x01, 0x13, 0x02, // ’ē (U+2019 U+0113)
  0x20, 0x19, 0x01, 0x15, 0x02, // ’ĕ (U+2019 U+0115)
  0x20, 0x19, 0x01, 0x17, 0x02, // ’ė (U+2019 U+0117)
  0x20, 0x19, 0x01, 0x19, 0x02, // ’ę (U+2019 U+0119)
  0x20, 0x19, 0x01, 0x1B, 0x02, // ’ě (U+2019 U+011B)
  0x20, 0x19, 0x01, 0x1D, 0x01, // ’ĝ (U+2019 U+011D)
  0x20, 0x19, 0x01, 0x1F, 0x01, // ’ğ (U+2019 U+011F)
  0x20, 0x19, 0x01, 0x21, 0x01, // ’ġ (U+2019 U+0121)
  0x20, 0x19, 0x01, 0x23, 0x01, // ’ģ (U+2019 U+0123)
  0x20, 0x19, 0x01, 0x38, 0x01, // ’ĸ (U+2019 U+0138)
  0x20, 0x19, 0x01, 0x44, 0x01, // ’ń (U+2019 U+0144)
  0x20, 0x19, 0x01, 0x46, 0x01, // ’ņ (U+2019 U+0146)
  0x20, 0x19, 0x01, 0x48, 0x01, // ’ň (U+2019 U+0148)
  0x20, 0x19, 0x01, 0x4B, 0x01, // ’ŋ (U+2019 U+014B)
  0x20, 0x19, 0x01, 0x4D, 0x02, // ’ō (U+2019 U+014D)
  0x20, 0x19, 0x01, 0x4F, 0x02, // ’ŏ (U+2019 U+014F)
  0x20, 0x19, 0x01, 0x51, 0x02, // ’ő (U+2019 U+0151)
  0x20, 0x19, 0x01, 0x53, 0x02, // ’œ (U+2019 U+0153)
  0x20, 0x19, 0x01, 0x55, 0x01, // ’ŕ (U+2019 U+0155)
  0x20, 0x19, 0x01, 0x57, 0x01, // ’ŗ (U+2019 U+0157)
  0x20, 0x19, 0x01, 0x5B, 0x01, // ’ś (U+2019 U+015B)
  0x20, 0x19, 0x01, 0x5D, 0x01, // ’ŝ (U+2019 U+015D)
  0x20, 0x19, 0x01, 0x5F, 0x01, // ’ş (U+2019 U+015F)
  0x20, 0x19, 0x01, 0x61, 0x01, // ’š (U+2019 U+0161)
  0x20, 0x19, 0x01, 0x69, 0x01, // ’ũ (U+2019 U+0169)
  0x20, 0x19, 0x01, 0x6B, 0x01, // ’ū (U+2019 U+016B)
  0x20, 0x19, 0x01, 0x6D, 0x01, // ’ŭ (U+2019 U+016D)
  0x20, 0x19, 0x01, 0x6F, 0x01, // ’ů (U+2019 U+016F)
  0x20, 0x19, 0x01, 0x71, 0x01, // ’ű (U+2019 U+0171)
  0x20, 0x19, 0x01, 0x73, 0x01, // ’ų (U+2019 U+0173)
  0x20, 0x1A, 0x00, 0x43, 0x01, // ‚C (U+201A U+0043)
  0x20, 0x1A, 0x00, 0x47, 0x01, // ‚G (U+201A U+0047)
  0x20, 0x1A, 0x00, 0x4F, 0x01, // ‚O (U+201A U+004F)
  0x20, 0x1A, 0x00, 0x51, 0x01, // ‚Q (U+201A U+0051)
  0x20, 0x1A, 0x00, 0x54, 0x02, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x55, 0x01, // ‚U (U+201A U+0055)
  0x20, 0x1A, 0x00, 0x56, 0x02, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x02, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x02, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0xC7, 0x01, // ‚Ç (U+201A U+00C7)
  0x20, 0x1A, 0x00, 0xD2, 0x01, // ‚Ò (U+201A U+00D2)
  0x20, 0x1A, 0x00, 0xD3, 0x01, // ‚Ó (U+201A U+00D3)
  0x20, 0x1A, 0x00, 0xD4, 0x01, // ‚Ô (U+201A U+00D4)
  0x20, 0x1A, 0x00, 0xD5, 0x01, // ‚Õ (U+201A U+00D5)
  0x20, 0x1A, 0x00, 0xD6, 0x01, // ‚Ö (U+201A U+00D6)
  0x20, 0x1A, 0x00, 0xD8, 0x01, // ‚Ø (U+201A U+00D8)
  0x20, 0x1A, 0x00, 0xD9, 0x01, // ‚Ù (U+201A U+00D9)
  0x20, 0x1A, 0x00, 0xDA, 0x01, // ‚Ú (U+201A U+00DA)
  0x20, 0x1A, 0x00, 0xDB, 0x01, // ‚Û (U+201A U+00DB)
  0x20, 0x1A, 0x00, 0xDC, 0x01, // ‚Ü (U+201A U+00DC)
  0x20, 0x1A, 0x00, 0xDD, 0x02, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x01, 0x06, 0x01, // ‚Ć (U+201A U+0106)
  0x20, 0x1A, 0x01, 0x08, 0x01, // ‚Ĉ (U+201A U+0108)
  0x20, 0x1A, 0x01, 0x0A, 0x01, // ‚Ċ (U+201A U+010A)
  0x20, 0x1A, 0x01, 0x0C, 0x01, // ‚Č (U+201A U+010C)
  0x20, 0x1A, 0x01, 0x1C, 0x01, // ‚Ĝ (U+201A U+011C)
  0x20, 0x1A, 0x01, 0x1E, 0x01, // ‚Ğ (U+201A U+011E)
  0x20, 0x1A, 0x01, 0x20, 0x01, // ‚Ġ (U+201A U+0120)
  0x20, 0x1A, 0x01, 0x22, 0x01, // ‚Ģ (U+201A U+0122)
  0x20, 0x1A, 0x01, 0x4C, 0x01, // ‚Ō (U+201A U+014C)
  0x20, 0x1A, 0x01, 0x4E, 0x01, // ‚Ŏ (U+201A U+014E)
  0x20, 0x1A, 0x01, 0x50, 0x01, // ‚Ő (U+201A U+0150)
  0x20, 0x1A, 0x01, 0x52, 0x01, // ‚Œ (U+201A U+0152)
  0x20, 0x1A, 0x01, 0x62, 0x02, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x02, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x02, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1A, 0x01, 0x68, 0x01, // ‚Ũ (U+201A U+0168)
  0x20, 0x1A, 0x01, 0x6A, 0x01, // ‚Ū (U+201A U+016A)
  0x20, 0x1A, 0x01, 0x6C, 0x01, // ‚Ŭ (U+201A U+016C)
  0x20, 0x1A, 0x01, 0x6E, 0x01, // ‚Ů (U+201A U+016E)
  0x20, 0x1A, 0x01, 0x70, 0x01, // ‚Ű (U+201A U+0170)
  0x20, 0x1A, 0x01, 0x72, 0x01, // ‚Ų (U+201A U+0172)
  0x20, 0x1A, 0x01, 0x74, 0x02, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x76, 0x02, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x78, 0x02, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x02, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0x61, 0x02, // “a (U+201C U+0061)
  0x20, 0x1C, 0x00, 0x63, 0x02, // “c (U+201C U+0063)
  0x20, 0x1C, 0x00, 0x64, 0x02, // “d (U+201C U+0064)
  0x20, 0x1C, 0x00, 0x65, 0x02, // “e (U+201C U+0065)
  0x20, 0x1C, 0x00, 0x67, 0x01, // “g (U+201C U+0067)
  0x20, 0x1C, 0x00, 0x6D, 0x01, // “m (U+201C U+006D)
  0x20, 0x1C, 0x00, 0x6E, 0x01, // “n (U+201C U+006E)
  0x20, 0x1C, 0x00, 0x6F, 0x02, // “o (U+201C U+006F)
  0x20, 0x1C, 0x00, 0x70, 0x01, // “p (U+201C U+0070)
  0x20, 0x1C, 0x00, 0x71, 0x02, // “q (U+201C U+0071)
  0x20, 0x1C, 0x00, 0x72, 0x01, // “r (U+201C U+0072)
  0x20, 0x1C, 0x00, 0x73, 0x01, // “s (U+201C U+0073)
  0x20, 0x1C, 0x00, 0x75, 0x01, // “u (U+201C U+0075)
  0x20, 0x1C, 0x00, 0xC0, 0x02, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x02, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x02, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x02, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x02, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x02, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xE0, 0x02, // “à (U+201C U+00E0)
  0x20, 0x1C, 0x00, 0xE1, 0x02, // “á (U+201C U+00E1)
  0x20, 0x1C, 0x00, 0xE2, 0x02, // “â (U+201C U+00E2)
  0x20, 0x1C, 0x00, 0xE3, 0x02, // “ã (U+201C U+00E3)
  0x20, 0x1C, 0x00, 0xE4, 0x02, // “ä (U+201C U+00E4)
  0x20, 0x1C, 0x00, 0xE5, 0x02, // “å (U+201C U+00E5)
  0x20, 0x1C, 0x00, 0xE6, 0x02, // “æ (U+201C U+00E6)
  0x20, 0x1C, 0x00, 0xE7, 0x02, // “ç (U+201C U+00E7)
  0x20, 0x1C, 0x00, 0xE8, 0x02, // “è (U+201C U+00E8)
  0x20, 0x1C, 0x00, 0xE9, 0x02, // “é (U+201C U+00E9)
  0x20, 0x1C, 0x00, 0xEA, 0x02, // “ê (U+201C U+00EA)
  0x20, 0x1C, 0x00, 0xEB, 0x02, // “ë (U+201C U+00EB)
  0x20, 0x1C, 0x00, 0xF1, 0x01, // “ñ (U+201C U+00F1)
  0x20, 0x1C, 0x00, 0xF2, 0x02, // “ò (U+201C U+00F2)
  0x20, 0x1C, 0x00, 0xF3, 0x02, // “ó (U+201C U+00F3)
  0x20, 0x1C, 0x00, 0xF4, 0x02, // “ô (U+201C U+00F4)
  0x20, 0x1C, 0x00, 0xF5, 0x02, // “õ (U+201C U+00F5)
  0x20, 0x1C, 0x00, 0xF6, 0x02, // “ö (U+201C U+00F6)
  0x20, 0x1C, 0x00, 0xF8, 0x02, // “ø (U+201C U+00F8)
  0x20, 0x1C, 0x00, 0xF9, 0x01, // “ù (U+201C U+00F9)
  0x20, 0x1C, 0x00, 0xFA, 0x01, // “ú (U+201C U+00FA)
  0x20, 0x1C, 0x00, 0xFB, 0x01, // “û (U+201C U+00FB)
  0x20, 0x1C, 0x00, 0xFC, 0x01, // “ü (U+201C U+00FC)
  0x20, 0x1C, 0x01, 0x00, 0x02, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x01, 0x02, // “ā (U+201C U+0101)
  0x20, 0x1C, 0x01, 0x02, 0x02, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x03, 0x02, // “ă (U+201C U+0103)
  0x20, 0x1C, 0x01, 0x04, 0x02, // “Ą (U+201C U+0104)
  0x20, 0x1C, 0x01, 0x05, 0x02, // “ą (U+201C U+0105)
  0x20, 0x1C, 0x01, 0x07, 0x02, // “ć (U+201C U+0107)
  0x20, 0x1C, 0x01, 0x09, 0x02, // “ĉ (U+201C U+0109)
  0x20, 0x1C, 0x01, 0x0B, 0x02, // “ċ (U+201C U+010B)
  0x20, 0x1C, 0x01, 0x0D, 0x02, // “č (U+201C U+010D)
  0x20, 0x1C, 0x01, 0x0F, 0x02, // “ď (U+201C U+010F)
  0x20, 0x1C, 0x01, 0x11, 0x02, // “đ (U+201C U+0111)
  0x20, 0x1C, 0x01, 0x13, 0x02, // “ē (U+201C U+0113)
  0x20, 0x1C, 0x01, 0x15, 0x02, // “ĕ (U+201C U+0115)
  0x20, 0x1C, 0x01, 0x17, 0x02, // “ė (U+201C U+0117)
  0x20, 0x1C, 0x01, 0x19, 0x02, // “ę (U+201C U+0119)
  0x20, 0x1C, 0x01, 0x1B, 0x02, // “ě (U+201C U+011B)
  0x20, 0x1C, 0x01, 0x1D, 0x01, // “ĝ (U+201C U+011D)
  0x20, 0x1C, 0x01, 0x1F, 0x01, // “ğ (U+201C U+011F)
  0x20, 0x1C, 0x01, 0x21, 0x01, // “ġ (U+201C U+0121)
  0x20, 0x1C, 0x01, 0x23, 0x01, // “ģ (U+201C U+0123)
  0x20, 0x1C, 0x01, 0x38, 0x01, // “ĸ (U+201C U+0138)
  0x20, 0x1C, 0x01, 0x44, 0x01, // “ń (U+201C U+0144)
  0x20, 0x1C, 0x01, 0x46, 0x01, // “ņ (U+201C U+0146)
  0x20, 0x1C, 0x01, 0x48, 0x01, // “ň (U+201C U+0148)
  0x20, 0x1C, 0x01, 0x4B, 0x01, // “ŋ (U+201C U+014B)
  0x20, 0x1C, 0x01, 0x4D, 0x02, // “ō (U+201C U+014D)
  0x20, 0x1C, 0x01, 0x4F, 0x02, // “ŏ (U+201C U+014F)
  0x20, 0x1C, 0x01, 0x51, 0x02, // “ő (U+201C U+0151)
  0x20, 0x1C, 0x01, 0x53, 0x02, // “œ (U+201C U+0153)
  0x20, 0x1C, 0x01, 0x55, 0x01, // “ŕ (U+201C U+0155)
  0x20, 0x1C, 0x01, 0x57, 0x01, // “ŗ (U+201C U+0157)
  0x20, 0x1C, 0x01, 0x5B, 0x01, // “ś (U+201C U+015B)
  0x20, 0x1C, 0x01, 0x5D, 0x01, // “ŝ (U+201C U+015D)
  0x20, 0x1C, 0x01, 0x5F, 0x01, // “ş (U+201C U+015F)
  0x20, 0x1C, 0x01, 0x61, 0x01, // “š (U+201C U+0161)
  0x20, 0x1C, 0x01, 0x69, 0x01, // “ũ (U+201C U+0169)
  0x20, 0x1C, 0x01, 0x6B, 0x01, // “ū (U+201C U+016B)
  0x20, 0x1C, 0x01, 0x6D, 0x01, // “ŭ (U+201C U+016D)
  0x20, 0x1C, 0x01, 0x6F, 0x01, // “ů (U+201C U+016F)
  0x20, 0x1C, 0x01, 0x71, 0x01, // “ű (U+201C U+0171)
  0x20, 0x1C, 0x01, 0x73, 0x01, // “ų (U+201C U+0173)
  0x20, 0x1D, 0x00, 0x41, 0x02, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0x61, 0x02, // ”a (U+201D U+0061)
  0x20, 0x1D, 0x00, 0x63, 0x02, // ”c (U+201D U+0063)
  0x20, 0x1D, 0x00, 0x64, 0x02, // ”d (U+201D U+0064)
  0x20, 0x1D, 0x00, 0x65, 0x02, // ”e (U+201D U+0065)
  0x20, 0x1D, 0x00, 0x67, 0x01, // ”g (U+201D U+0067)
  0x20, 0x1D, 0x00, 0x6D, 0x01, // ”m (U+201D U+006D)
  0x20, 0x1D, 0x00, 0x6E, 0x01, // ”n (U+201D U+006E)
  0x20, 0x1D, 0x00, 0x6F, 0x02, // ”o (U+201D U+006F)
  0x20, 0x1D, 0x00, 0x70, 0x01, // ”p (U+201D U+0070)
  0x20, 0x1D, 0x00, 0x71, 0x02, // ”q (U+201D U+0071)
  0x20, 0x1D, 0x00, 0x72, 0x01, // ”r (U+201D U+0072)
  0x20, 0x1D, 0x00, 0x73, 0x01, // ”s (U+201D U+0073)
  0x20, 0x1D, 0x00, 0x75, 0x01, // ”u (U+201D U+0075)
  0x20, 0x1D, 0x00, 0xC0, 0x02, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x02, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x02, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x02, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x02, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x02, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xE0, 0x02, // ”à (U+201D U+00E0)
  0x20, 0x1D, 0x00, 0xE1, 0x02, // ”á (U+201D U+00E1)
  0x20, 0x1D, 0x00, 0xE2, 0x02, // ”â (U+201D U+00E2)
  0x20, 0x1D, 0x00, 0xE3, 0x02, // ”ã (U+201D U+00E3)
  0x20, 0x1D, 0x00, 0xE4, 0x02, // ”ä (U+201D U+00E4)
  0x20, 0x1D, 0x00, 0xE5, 0x02, // ”å (U+201D U+00E5)
  0x20, 0x1D, 0x00, 0xE6, 0x02, // ”æ (U+201D U+00E6)
  0x20, 0x1D, 0x00, 0xE7, 0x02, // ”ç (U+201D U+00E7)
  0x20, 0x1D, 0x00, 0xE8, 0x02, // ”è (U+201D U+00E8)
  0x20, 0x1D, 0x00, 0xE9, 0x02, // ”é (U+201D U+00E9)
  0x20, 0x1D, 0x00, 0xEA, 0x02, // ”ê (U+201D U+00EA)
  0x20, 0x1D, 0x00, 0xEB, 0x02, // ”ë (U+201D U+00EB)
  0x20, 0x1D, 0x00, 0xF1, 0x01, // ”ñ (U+201D U+00F1)
  0x20, 0x1D, 0x00, 0xF2, 0x02, // ”ò (U+201D U+00F2)
  0x20, 0x1D, 0x00, 0xF3, 0x02, // ”ó (U+201D U+00F3)
  0x20, 0x1D, 0x00, 0xF4, 0x02, // ”ô (U+201D U+00F4)
  0x20, 0x1D, 0x00, 0xF5, 0x02, // ”õ (U+201D U+00F5)
  0x20, 0x1D, 0x00, 0xF6, 0x02, // ”ö (U+201D U+00F6)
  0x20, 0x1D, 0x00, 0xF8, 0x02, // ”ø (U+201D U+00F8)
  0x20, 0x1D, 0x00, 0xF9, 0x01, // ”ù (U+201D U+00F9)
  0x20, 0x1D, 0x00, 0xFA, 0x01, // ”ú (U+201D U+00FA)
  0x20, 0x1D, 0x00, 0xFB, 0x01, // ”û (U+201D U+00FB)
  0x20, 0x1D, 0x00, 0xFC, 0x01, // ”ü (U+201D U+00FC)
  0x20, 0x1D, 0x01, 0x00, 0x02, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x01, 0x02, // ”ā (U+201D U+0101)
  0x20, 0x1D, 0x01, 0x02, 0x02, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x03, 0x02, // ”ă (U+201D U+0103)
  0x20, 0x1D, 0x01, 0x04, 0x02, // ”Ą (U+201D U+0104)
  0x20, 0x1D, 0x01, 0x05, 0x02, // ”ą (U+201D U+0105)
  0x20, 0x1D, 0x01, 0x07, 0x02, // ”ć (U+201D U+0107)
  0x20, 0x1D, 0x01, 0x09, 0x02, // ”ĉ (U+201D U+0109)
  0x20, 0x1D, 0x01, 0x0B, 0x02, // ”ċ (U+201D U+010B)
  0x20, 0x1D, 0x01, 0x0D, 0x02, // ”č (U+201D U+010D)
  0x20, 0x1D, 0x01, 0x0F, 0x02, // ”ď (U+201D U+010F)
  0x20, 0x1D, 0x01, 0x11, 0x02, // ”đ (U+201D U+0111)
  0x20, 0x1D, 0x01, 0x13, 0x02, // ”ē (U+201D U+0113)
  0x20, 0x1D, 0x01, 0x15, 0x02, // ”ĕ (U+201D U+0115)
  0x20, 0x1D, 0x01, 0x17, 0x02, // ”ė (U+201D U+0117)
  0x20, 0x1D, 0x01, 0x19, 0x02, // ”ę (U+201D U+0119)
  0x20, 0x1D, 0x01, 0x1B, 0x02, // ”ě (U+201D U+011B)
  0x20, 0x1D, 0x01, 0x1D, 0x01, // ”ĝ (U+201D U+011D)
  0x20, 0x1D, 0x01, 0x1F, 0x01, // ”ğ (U+201D U+011F)
  0x20, 0x1D, 0x01, 0x21, 0x01, // ”ġ (U+201D U+0121)
  0x20, 0x1D, 0x01, 0x23, 0x01, // ”ģ (U+201D U+0123)
  0x20, 0x1D, 0x01, 0x38, 0x01, // ”ĸ (U+201D U+0138)
  0x20, 0x1D, 0x01, 0x44, 0x01, // ”ń (U+201D U+0144)
  0x20, 0x1D, 0x01, 0x46, 0x01, // ”ņ (U+201D U+0146)
  0x20, 0x1D, 0x01, 0x48, 0x01, // ”ň (U+201D U+0148)
  0x20, 0x1D, 0x01, 0x4B, 0x01, // ”ŋ (U+201D U+014B)
  0x20, 0x1D, 0x01, 0x4D, 0x02, // ”ō (U+201D U+014D)
  0x20, 0x1D, 0x01, 0x4F, 0x02, // ”ŏ (U+201D U+014F)
  0x20, 0x1D, 0x01, 0x51, 0x02, // ”ő (U+201D U+0151)
  0x20, 0x1D, 0x01, 0x53, 0x02, // ”œ (U+201D U+0153)
  0x20, 0x1D, 0x01, 0x55, 0x01, // ”ŕ (U+201D U+0155)
  0x20, 0x1D, 0x01, 0x57, 0x01, // ”ŗ (U+201D U+0157)
  0x20, 0x1D, 0x01, 0x5B, 0x01, // ”ś (U+201D U+015B)
  0x20, 0x1D, 0x01, 0x5D, 0x01, // ”ŝ (U+201D U+015D)
  0x20, 0x1D, 0x01, 0x5F, 0x01, // ”ş (U+201D U+015F)
  0x20, 0x1D, 0x01, 0x61, 0x01, // ”š (U+201D U+0161)
  0x20, 0x1D, 0x01, 0x69, 0x01, // ”ũ (U+201D U+0169)
  0x20, 0x1D, 0x01, 0x6B, 0x01, // ”ū (U+201D U+016B)
  0x20, 0x1D, 0x01, 0x6D, 0x01, // ”ŭ (U+201D U+016D)
  0x20, 0x1D, 0x01, 0x6F, 0x01, // ”ů (U+201D U+016F)
  0x20, 0x1D, 0x01, 0x71, 0x01, // ”ű (U+201D U+0171)
  0x20, 0x1D, 0x01, 0x73, 0x01, // ”ų (U+201D U+0173)
  0x20, 0x1E, 0x00, 0x43, 0x01, // „C (U+201E U+0043)
  0x20, 0x1E, 0x00, 0x47, 0x01, // „G (U+201E U+0047)
  0x20, 0x1E, 0x00, 0x4F, 0x01, // „O (U+201E U+004F)
  0x20, 0x1E, 0x00, 0x51, 0x01, // „Q (U+201E U+0051)
  0x20, 0x1E, 0x00, 0x54, 0x02, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x55, 0x01, // „U (U+201E U+0055)
  0x20, 0x1E, 0x00, 0x56, 0x02, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x02, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x02, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0xC7, 0x01, // „Ç (U+201E U+00C7)
  0x20, 0x1E, 0x00, 0xD2, 0x01, // „Ò (U+201E U+00D2)
  0x20, 0x1E, 0x00, 0xD3, 0x01, // „Ó (U+201E U+00D3)
  0x20, 0x1E, 0x00, 0xD4, 0x01, // „Ô (U+201E U+00D4)
  0x20, 0x1E, 0x00, 0xD5, 0x01, // „Õ (U+201E U+00D5)
  0x20, 0x1E, 0x00, 0xD6, 0x01, // „Ö (U+201E U+00D6)
  0x20, 0x1E, 0x00, 0xD8, 0x01, // „Ø (U+201E U+00D8)
  0x20, 0x1E, 0x00, 0xD9, 0x01, // „Ù (U+201E U+00D9)
  0x20, 0x1E, 0x00, 0xDA, 0x01, // „Ú (U+201E U+00DA)
  0x20, 0x1E, 0x00, 0xDB, 0x01, // „Û (U+201E U+00DB)
  0x20, 0x1E, 0x00, 0xDC, 0x01, // „Ü (U+201E U+00DC)
  0x20, 0x1E, 0x00, 0xDD, 0x02, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x01, 0x06, 0x01, // „Ć (U+201E U+0106)
  0x20, 0x1E, 0x01, 0x08, 0x01, // „Ĉ (U+201E U+0108)
  0x20, 0x1E, 0x01, 0x0A, 0x01, // „Ċ (U+201E U+010A)
  0x20, 0x1E, 0x01, 0x0C, 0x01, // „Č (U+201E U+010C)
  0x20, 0x1E, 0x01, 0x1C, 0x01, // „Ĝ (U+201E U+011C)
  0x20, 0x1E, 0x01, 0x1E, 0x01, // „Ğ (U+201E U+011E)
  0x20, 0x1E, 0x01, 0x20, 0x01, // „Ġ (U+201E U+0120)
  0x20, 0x1E, 0x01, 0x22, 0x01, // „Ģ (U+201E U+0122)
  0x20, 0x1E, 0x01, 0x4C, 0x01, // „Ō (U+201E U+014C)
  0x20, 0x1E, 0x01, 0x4E, 0x01, // „Ŏ (U+201E U+014E)
  0x20, 0x1E, 0x01, 0x50, 0x01, // „Ő (U+201E U+0150)
  0x20, 0x1E, 0x01, 0x52, 0x01, // „Œ (U+201E U+0152)
  0x20, 0x1E, 0x01, 0x62, 0x02, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x02, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x02, // „Ŧ (U+201E U+0166)
  0x20, 0x1E, 0x01, 0x68, 0x01, // „Ũ (U+201E U+0168)
  0x20, 0x1E, 0x01, 0x6A, 0x01, // „Ū (U+201E U+016A)
  0x20, 0x1E, 0x01, 0x6C, 0x01, // „Ŭ (U+201E U+016C)
  0x20, 0x1E, 0x01, 0x6E, 0x01, // „Ů (U+201E U+016E)
  0x20, 0x1E, 0x01, 0x70, 0x01, // „Ű (U+201E U+0170)
  0x20, 0x1E, 0x01, 0x72, 0x01, // „Ų (U+201E U+0172)
  0x20, 0x1E, 0x01, 0x74, 0x02, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x76, 0x02, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x78, 0x02, // „Ÿ (U+201E U+0178)
  0x20, 0x39, 0x00, 0x54, 0x01, // ‹T (U+2039 U+0054)
  0x20, 0x39, 0x00, 0x56, 0x01, // ‹V (U+2039 U+0056)
  0x20, 0x39, 0x00, 0x57, 0x01, // ‹W (U+2039 U+0057)
  0x20, 0x39, 0x00, 0x59, 0x02, // ‹Y (U+2039 U+0059)
  0x20, 0x39, 0x00, 0xDD, 0x02, // ‹Ý (U+2039 U+00DD)
  0x20, 0x39, 0x01, 0x62, 0x01, // ‹Ţ (U+2039 U+0162)
  0x20, 0x39, 0x01, 0x64, 0x01, // ‹Ť (U+2039 U+0164)
  0x20, 0x39, 0x01, 0x66, 0x01, // ‹Ŧ (U+2039 U+0166)
  0x20, 0x39, 0x01, 0x74, 0x01, // ‹Ŵ (U+2039 U+0174)
  0x20, 0x39, 0x01, 0x76, 0x02, // ‹Ŷ (U+2039 U+0176)
  0x20, 0x39, 0x01, 0x78, 0x02, // ‹Ÿ (U+2039 U+0178)
  0x20, 0x3A, 0x00, 0x54, 0x02, // ›T (U+203A U+0054)
  0x20, 0x3A, 0x00, 0x56, 0x01, // ›V (U+203A U+0056)
  0x20, 0x3A, 0x00, 0x57, 0x01, // ›W (U+203A U+0057)
  0x20, 0x3A, 0x00, 0x59, 0x02, // ›Y (U+203A U+0059)
  0x20, 0x3A, 0x00, 0xDD, 0x02, // ›Ý (U+203A U+00DD)
  0x20, 0x3A, 0x01, 0x62, 0x02, // ›Ţ (U+203A U+0162)
  0x20, 0x3A, 0x01, 0x64, 0x02, // ›Ť (U+203A U+0164)
  0x20, 0x3A, 0x01, 0x66, 0x02, // ›Ŧ (U+203A U+0166)
  0x20, 0x3A, 0x01, 0x74, 0x01, // ›Ŵ (U+203A U+0174)
  0x20, 0x3A, 0x01, 0x76, 0x02, // ›Ŷ (U+203A U+0176)
  0x20, 0x3A, 0x01, 0x78, 0x02, // ›Ÿ (U+203A U+0178)
  
  // Glyph data
  // "!" (U+0021)
  0x60, 0x9B, 0x02, 0x60, 0xCA, 0x0E, 0x7B, 0x0A, 0x60, 0x2B, 0x07, 0x60, 0x5B, 0x03, 0x60, 0x8A,
  0x0E, 0x70, 0xBA, 0x0B, 0x70, 0xEA, 0x07, 0x60, 0x1B, 0x03, 0x60, 0x4A, 0x0E, 0x70, 0x7A, 0x0B,
  0x70, 0xAA, 0x07, 0x70, 0xDA, 0x03, 0x7B, 0x70, 0x3A, 0x0B, 0x70, 0x6A, 0x07, 0x70, 0x9A, 0x03,
  0x70, 0xBA, 0x71, 0x81, 0xEF, 0xB7, 0x02, 0xA0, 0x87, 0x82, 0x3A, 0xA3, 0x80, 0xC3, 0x08, 0x24,
  0xDE, 0x66, 0x01, 0xB0, 0xD6, 0x06, 0xB0, 0xD6, 0x06, 0xB0, 0x86, 0x82, 0x1C, 0xE9, 0x70,
  // """ (U+0022)
  0x06, 0xFF, 0xF1, 0x02, 0xFF, 0xF5, 0x09, 0xFF, 0xC0, 0x04, 0xFF, 0xF1, 0x0B, 0xFF, 0x70, 0x06,
  0xFF, 0xC0, 0x0E, 0xFF, 0x30, 0x09, 0xFF, 0x80, 0x1F, 0xFE, 0x00, 0x0B, 0xFF, 0x30, 0x3F, 0xFA,
  0x00, 0x0E, 0xFE, 0x00, 0x5F, 0xF5, 0x00, 0x1F, 0xFA, 0x00, 0x8F, 0xF1, 0x00, 0x3F, 0xF6, 0x00,
  0xAF, 0xC0, 0x00, 0x6F, 0xF1, 0x00, 0xDF, 0x80, 0x00, 0x8F, 0xC0, 0x00,
  // "#" (U+0023)
  0x72, 0x03, 0xA0, 0x63, 0x06, 0xA0, 0x27, 0x30, 0x7A, 0x01, 0x38, 0x1A, 0xFC, 0x74, 0x81, 0xCF,
  0xC4, 0x81, 0xEF, 0x87, 0x30, 0x1A, 0x07, 0x30, 0x4A, 0x03, 0x73, 0x05, 0xA0, 0x23, 0x81, 0x9F,
  0xE7, 0x48, 0x1A, 0xFD, 0x48, 0x1D, 0xF9, 0x74, 0x81, 0xEF, 0x83, 0x03, 0xA0, 0x47, 0x30, 0x4A,
  0x04, 0x30, 0x7A, 0x78, 0x38, 0xCC, 0xCD, 0xA8, 0x00, 0xC8, 0x5E, 0xFE, 0xCC, 0xC4, 0x30, 0xCF,
  0xFA, 0x03, 0x3F, 0xFB, 0x70, 0x6A, 0x02, 0x38, 0x1A, 0xFD, 0x74, 0x81, 0xBF, 0xC4, 0x81, 0xEF,
  0x87, 0x4A, 0x08, 0x30, 0x3A, 0x03, 0x73, 0x05, 0xA0, 0x33, 0x81, 0x8F, 0xE7, 0x48, 0x19, 0xFE,
  0x48, 0x1C, 0xFA, 0x74, 0x81, 0xEF, 0xA3, 0x01, 0xA0, 0x57, 0x30, 0x3A, 0x05, 0x30, 0x6A, 0x01,
  0x60, 0x4F, 0xFA, 0x0A, 0x30, 0x7F, 0xFA, 0x08, 0x30, 0x70, 0xFC, 0xA8, 0x3D, 0xCC, 0xCD, 0xA8,
  0x00, 0xC0, 0x56, 0x05, 0xA0, 0x33, 0x81, 0x8F, 0xE7, 0x48, 0x1A, 0xFD, 0x48, 0x1D, 0xF9, 0x74,
  0x81, 0xEF, 0x83, 0x03, 0xA0, 0x47, 0x30, 0x4A, 0x03, 0x38, 0x18, 0xFE, 0x74, 0x81, 0x9F, 0xE4,
  0x81, 0xDF, 0xA7, 0x48, 0x1E, 0xF9, 0x30, 0x2A, 0x05, 0x73, 0x03, 0xA0, 0x43, 0x07, 0xA7, 0x48,
  0x18, 0xFE, 0x48, 0x1D, 0xFB, 0x73,
  // "$" (U+0024)
  0x74, 0x81, 0x6F, 0x77, 0x71, 0x81, 0x9F, 0x47, 0x71, 0x81, 0xDF, 0x17, 0x58, 0x11, 0x68, 0xA8,
  0x1A, 0x73, 0x71, 0x02, 0x0A, 0xF9, 0x0C, 0x05, 0x50, 0x40, 0xEF, 0xB0, 0x54, 0x01, 0x0E, 0xA8,
  0x7D, 0x7C, 0xF3, 0x27, 0xED, 0x50, 0x9A, 0x0B, 0x20, 0xD9, 0x30, 0x10, 0x25, 0x0E, 0xA8, 0x32,
  0x01, 0xFC, 0x72, 0x01, 0xA0, 0xD2, 0x81, 0x4F, 0x97, 0x20, 0x2A, 0x0C, 0x28, 0x17, 0xF5, 0x72,
  0x02, 0xA0, 0xE2, 0x81, 0xBF, 0x27, 0x30, 0xEA, 0x82, 0x90, 0xEE, 0x74, 0x08, 0xB8, 0x1B, 0xFB,
  0x75, 0x0C, 0xC0, 0x97, 0x60, 0xBC, 0x09, 0x76, 0x07, 0xC0, 0xC0, 0x17, 0x5D, 0x0C, 0x74, 0x82,
  0x3F, 0xA9, 0xB0, 0x77, 0x38, 0x36, 0xF7, 0x0B, 0xA0, 0xC7, 0x38, 0x39, 0xF4, 0x03, 0xA0, 0xE7,
  0x30, 0xC9, 0x20, 0x1A, 0x0E, 0x73, 0x90, 0xD2, 0x02, 0xA0, 0xC7, 0x28, 0x13, 0xF9, 0x20, 0x7A,
  0x08, 0x30, 0x30, 0x44, 0x84, 0x7F, 0x60, 0x4E, 0xA0, 0x23, 0x89, 0x06, 0xFC, 0x62, 0x0A, 0xF8,
  0xAB, 0x06, 0x40, 0x7F, 0xC0, 0x65, 0x05, 0x0E, 0xF8, 0x1D, 0x81, 0x71, 0x85, 0x58, 0xAD, 0xF9,
  0x27, 0x78, 0x17, 0xF4, 0x77, 0x18, 0x1B, 0xF1, 0x77, 0x19, 0x0D, 0x77, 0x18, 0x11, 0x75, 0x74,
  // "%" (U+0025)
  0x48, 0x41, 0x9D, 0xFC, 0x37, 0x10, 0x8A, 0x02, 0x50, 0x20, 0xDC, 0x0E, 0x02, 0x60, 0x2A, 0x08,
  0x60, 0xCA, 0x0D, 0x0E, 0xA0, 0x96, 0x81, 0xBF, 0xE6, 0x07, 0xA8, 0x49, 0x01, 0xEF, 0xC5, 0x04,
  0xA0, 0x66, 0x81, 0xEF, 0xD3, 0x81, 0xAF, 0xD5, 0x81, 0xDF, 0xC6, 0x05, 0xA0, 0x53, 0x81, 0xAF,
  0xD4, 0x07, 0xA0, 0x36, 0x0A, 0xA4, 0x81, 0xBF, 0xC3, 0x82, 0x1E, 0xFA, 0x78, 0x1E, 0xFB, 0x48,
  0x1D, 0xFA, 0x38, 0x29, 0xFE, 0x16, 0x03, 0xA0, 0x63, 0x01, 0xA0, 0x82, 0x03, 0xA0, 0x77, 0x05,
  0xA0, 0x33, 0x04, 0xA0, 0x52, 0x81, 0xCF, 0xD7, 0x10, 0x8A, 0x40, 0x9A, 0x81, 0x10, 0x5A, 0x05,
  0x71, 0x81, 0x9F, 0xE4, 0x81, 0xDF, 0xC2, 0x81, 0xDF, 0xB2, 0x83, 0x7D, 0xFD, 0x52, 0x81, 0xAF,
  0xD3, 0x04, 0xA8, 0x16, 0x08, 0xA8, 0x13, 0x0B, 0xD8, 0x35, 0x0A, 0xFE, 0x38, 0x3B, 0xFE, 0x02,
  0xA8, 0x19, 0x09, 0xA0, 0xE0, 0xDA, 0x81, 0xC0, 0x8A, 0x81, 0x61, 0x9A, 0x85, 0x70, 0xAF, 0xE1,
  0x3A, 0x0B, 0x20, 0xCA, 0x10, 0x4E, 0x81, 0xC0, 0x4A, 0x84, 0x70, 0xBF, 0xE1, 0x20, 0x7A, 0x81,
  0x20, 0xBC, 0x86, 0xD1, 0x0C, 0xFD, 0x02, 0xA0, 0x83, 0x07, 0xA0, 0x12, 0x82, 0x7B, 0xA7, 0x20,
  0x6A, 0x81, 0x40, 0x7A, 0x03, 0x30, 0x8A, 0x71, 0x82, 0x1E, 0xFB, 0x28, 0x1B, 0xFE, 0x48, 0x1A,
  0xFE, 0x71, 0x09, 0xA0, 0x22, 0xA0, 0xA4, 0x81, 0xDF, 0xC7, 0x02, 0xA0, 0x92, 0x02, 0xA0, 0x73,
  0x01, 0xA0, 0x97, 0x82, 0xBF, 0xE1, 0x20, 0x4A, 0x04, 0x30, 0x5A, 0x05, 0x60, 0x4A, 0x06, 0x30,
  0x6A, 0x02, 0x30, 0xAA, 0x01, 0x68, 0x1D, 0xFD, 0x40, 0x7A, 0x01, 0x38, 0x1E, 0xFB, 0x60, 0x7A,
  0x04, 0x40, 0x7A, 0x02, 0x20, 0x7A, 0x04, 0x58, 0x21, 0xEF, 0xA5, 0x05, 0xA8, 0x46, 0x03, 0xEF,
  0xC6, 0x09, 0xA0, 0x25, 0x02, 0xB0, 0xDB, 0x03, 0x50, 0x3A, 0x08, 0x70, 0xAD, 0x05, 0x68, 0x1C,
  0xFE, 0x72, 0x83, 0x9E, 0xEB, 0x35,
  // "&" (U+0026)
  0x71, 0x85, 0x18, 0xDF, 0xEB, 0x47, 0x50, 0x20, 0xEE, 0x07, 0x73, 0x01, 0x0E, 0xB0, 0xCC, 0x01,
  0x72, 0x09, 0xA8, 0x3D, 0x10, 0x2E, 0xA0, 0x67, 0x20, 0xEA, 0x04, 0x30, 0xAA, 0x07, 0x71, 0x03,
  0xA0, 0xD4, 0x09, 0xA0, 0x67, 0x10, 0x5A, 0x0A, 0x40, 0xBA, 0x03, 0x71, 0x07, 0xA0, 0x93, 0x01,
  0xA0, 0xD7, 0x20, 0x6A, 0x0A, 0x30, 0x8A, 0x06, 0x72, 0x04, 0xA0, 0xC2, 0x04, 0xA0, 0xB7, 0x30,
  0x1B, 0x18, 0x32, 0xEF, 0xC1, 0x74, 0x0B, 0xA8, 0x38, 0xEF, 0xD1, 0x75, 0x06, 0xC0, 0xB0, 0x17,
  0x50, 0x30, 0xCB, 0x0B, 0x76, 0x05, 0xD0, 0xE7, 0x50, 0x6B, 0x07, 0xB0, 0x64, 0xB0, 0x22, 0x05,
  0xB8, 0x14, 0x09, 0xA0, 0xD3, 0x05, 0xA0, 0xC2, 0x02, 0xB0, 0x62, 0x02, 0xB0, 0x42, 0x0B, 0xA0,
  0x62, 0x0B, 0xA0, 0x94, 0x0B, 0xA8, 0x1B, 0x02, 0xA0, 0xE2, 0x02, 0xB0, 0x14, 0x04, 0xB0, 0x20,
  0xAA, 0x07, 0x20, 0x7A, 0x0B, 0x60, 0xDA, 0x0C, 0xA0, 0xD3, 0x0A, 0xA0, 0x86, 0x06, 0xD0, 0x53,
  0x0B, 0xA0, 0x77, 0x0E, 0xB0, 0xA4, 0x0B, 0xA0, 0x96, 0x01, 0x0D, 0xB0, 0x24, 0x0A, 0xA0, 0xD5,
  0x01, 0x0C, 0xC0, 0x84, 0x06, 0xB0, 0x83, 0x04, 0x0D, 0xD0, 0xE5, 0x0E, 0xB8, 0x1E, 0xCE, 0xB0,
  0xB0, 0x3B, 0x06, 0x40, 0x30, 0xEF, 0x07, 0x20, 0xCA, 0x0D, 0x58, 0x61, 0x8D, 0xFE, 0xC8, 0x23,
  0x06, 0xB0, 0x42,
  // "'" (U+0027)
  0x04, 0xFF, 0xF2, 0x07, 0xFF, 0xD0, 0x09, 0xFF, 0x90, 0x0C, 0xFF, 0x50, 0x0E, 0xFF, 0x10, 0x1F,
  0xFB, 0x00, 0x3F, 0xF7, 0x00, 0x6F, 0xF3, 0x00, 0x8F, 0xE0, 0x00, 0xBF, 0xA0, 0x00,
  // "(" (U+0028)
  0x72, 0x82, 0xCF, 0xE1, 0x71, 0x0A, 0xA0, 0x47, 0x10, 0x8A, 0x07, 0x71, 0x03, 0xA0, 0xC7, 0x20,
  0xDA, 0x03, 0x71, 0x09, 0xA0, 0x87, 0x10, 0x2A, 0x0E, 0x72, 0x0B, 0xA0, 0x67, 0x10, 0x4A, 0x0D,
  0x72, 0x0B, 0xA0, 0x67, 0x10, 0x2A, 0x0E, 0x72, 0x09, 0xA0, 0x87, 0x20, 0xEA, 0x03, 0x71, 0x04,
  0xA0, 0xD7, 0x20, 0x9A, 0x07, 0x72, 0x0D, 0xA0, 0x37, 0x10, 0x1B, 0x72, 0x05, 0xA0, 0xB7, 0x20,
  0x7A, 0x09, 0x72, 0x0A, 0xA0, 0x67, 0x20, 0xCA, 0x04, 0x72, 0x0D, 0xA0, 0x37, 0x20, 0xEA, 0x02,
  0x72, 0xB0, 0x17, 0x2B, 0x01, 0x72, 0x0E, 0xA0, 0x27, 0x20, 0xDA, 0x02, 0x72, 0x0C, 0xA0, 0x37,
  0x20, 0x9A, 0x05, 0x72, 0x07, 0xA0, 0x77, 0x20, 0x4A, 0x0A, 0x73, 0xA0, 0xD7, 0x30, 0xBA, 0x01,
  0x72, 0x05, 0xA0, 0x67, 0x38, 0x1D, 0xFB, 0x71,
  // ")" (U+0029)
  0x70, 0x5A, 0x05, 0x73, 0x81, 0xEF, 0xB7, 0x30, 0xAA, 0x02, 0x72, 0x07, 0xA0, 0x67, 0x20, 0x4A,
  0x0A, 0x72, 0x01, 0xA0, 0xE7, 0x3B, 0x73, 0x0D, 0xA0, 0x37, 0x20, 0xCA, 0x04, 0x72, 0x0B, 0xA0,
  0x57, 0x20, 0xBA, 0x06, 0x72, 0x0B, 0xA0, 0x57, 0x20, 0xCA, 0x05, 0x72, 0x0D, 0xA0, 0x47, 0x20,
  0xEA, 0x03, 0x71, 0x01, 0xB0, 0x17, 0x10, 0x3A, 0x0E, 0x72, 0x06, 0xA0, 0xB7, 0x20, 0x9A, 0x08,
  0x72, 0x0D, 0xA0, 0x47, 0x10, 0x1B, 0x72, 0x07, 0xA0, 0xB7, 0x20, 0xCA, 0x05, 0x71, 0x02, 0xB7,
  0x20, 0x9A, 0x09, 0x71, 0x01, 0x0E, 0xA0, 0x27, 0x10, 0x7A, 0x0A, 0x71, 0x01, 0x0E, 0xA0, 0x27,
  0x10, 0x8A, 0x09, 0x71, 0x02, 0xA0, 0xE0, 0x17, 0x10, 0xBA, 0x05, 0x71, 0x06, 0xA0, 0xA7, 0x18,
  0x31, 0xEF, 0xD1, 0x71, 0x82, 0xCF, 0xE2, 0x71, 0x08, 0xA0, 0x47, 0x20,
  // "*" (U+002A)
  0x68, 0x12, 0x31, 0x74, 0x08, 0xA0, 0x87, 0x30, 0x9A, 0x04, 0x73, 0x0A, 0xA0, 0x14, 0x81, 0x2B,
  0x43, 0x81, 0xBF, 0xC5, 0x08, 0xA8, 0x4B, 0x30, 0xCF, 0x85, 0x0D, 0xC8, 0x93, 0xBE, 0xF6, 0x46,
  0x9B, 0xA0, 0x59, 0xEF, 0xA0, 0xD4, 0x04, 0xF9, 0x0D, 0x30, 0x10, 0xCB, 0x0A, 0x70, 0x10, 0xDA,
  0x05, 0xA0, 0x35, 0x01, 0x0D, 0xA8, 0x36, 0x0C, 0xFC, 0x50, 0xDA, 0x0A, 0x20, 0x7A, 0x05, 0x48,
  0x26, 0xFD, 0x12, 0x02, 0xA0, 0xD5, 0x05, 0x03, 0x48, 0x2D, 0xFB, 0x17, 0x30, 0x40, 0x24,
  // "+" (U+002B)
  0x60, 0x6A, 0x05, 0x75, 0x06, 0xA0, 0x57, 0x50, 0x6A, 0x05, 0x75, 0x06, 0xA0, 0x57, 0x50, 0x6A,
  0x05, 0x75, 0x06, 0xA0, 0x57, 0x50, 0x6A, 0x05, 0x75, 0x06, 0xA0, 0x56, 0x80, 0x2C, 0x0D, 0xA0,
  0xD8, 0x01, 0xC0, 0xBF, 0xF9, 0x0E, 0xFF, 0x90, 0xE6, 0x06, 0xA0, 0x57, 0x50, 0x6A, 0x05, 0x75,
  0x06, 0xA0, 0x57, 0x50, 0x6A, 0x05, 0x75, 0x06, 0xA0, 0x57, 0x50, 0x6A, 0x05, 0x75, 0x06, 0xA0,
  0x57, 0x50, 0x6A, 0x05, 0x60,
  // "," (U+002C)
  0x30, 0x3B, 0x06, 0x30, 0x7B, 0x01, 0x30, 0xDA, 0x09, 0x30, 0x3B, 0x02, 0x30, 0x9A, 0x0A, 0x40,
  0xEA, 0x02, 0x30, 0x5A, 0x0A, 0x40, 0xBA, 0x02, 0x30, 0x2A, 0x08, 0x48, 0x28, 0xFE, 0x14,
  // "-" (U+002D)
  0x10, 0x88, 0x03, 0xC8, 0x1B, 0x0E, 0xF0, 0xB0, 0x2F, 0x90, 0x80,
  // "." (U+002E)
  0x04, 0xDE, 0x61, 0xEF, 0xFE, 0x5F, 0xFF, 0xD5, 0xFF, 0xF8, 0x1C, 0xEA, 0x00,
  // "/" (U+002F)
  0x77, 0x10, 0x9A, 0x07, 0x77, 0x02, 0xA0, 0xE7, 0x71, 0x0A, 0xA0, 0x67, 0x70, 0x3A, 0x0D, 0x77,
  0x10, 0xBA, 0x05, 0x77, 0x04, 0xA0, 0xC7, 0x71, 0x0C, 0xA0, 0x47, 0x70, 0x6A, 0x0B, 0x77, 0x10,
  0xDA, 0x03, 0x77, 0x07, 0xA0, 0xA7, 0x70, 0x10, 0xEA, 0x02, 0x77, 0x08, 0xA0, 0x97, 0x78, 0x31,
  0xEF, 0xE1, 0x77, 0x09, 0xA0, 0x87, 0x70, 0x2A, 0x0E, 0x77, 0x10, 0xAA, 0x06, 0x77, 0x03, 0xA0,
  0xD7, 0x71, 0x0B, 0xA0, 0x57, 0x70, 0x4A, 0x0C, 0x77, 0x10, 0xCA, 0x04, 0x77, 0x05, 0xA0, 0xB7,
  0x71, 0x0D, 0xA0, 0x37, 0x70, 0x6A, 0x0A, 0x77, 0x10, 0xEA, 0x02, 0x77, 0x07, 0xA0, 0x97, 0x70,
  0x10, 0xEA, 0x01, 0x77, 0x09, 0xA0, 0x87, 0x70, 0x2A, 0x0E, 0x01, 0x77, 0x0A, 0xA0, 0x77, 0x71,
  // "0" (U+0030)
  0x71, 0x84, 0x7C, 0xFE, 0xC6, 0x72, 0x01, 0x0D, 0xE0, 0xA7, 0x01, 0x0E, 0xB0, 0xD0, 0xEB, 0x05,
  0x60, 0xCA, 0x0D, 0x02, 0x20, 0xBA, 0x0B, 0x50, 0x7A, 0x0E, 0x02, 0x30, 0x3B, 0x40, 0x10, 0xEA,
  0x06, 0x5B, 0x03, 0x30, 0x8A, 0x0D, 0x60, 0xDA, 0x04, 0x30, 0xEA, 0x06, 0x60, 0xDA, 0x04, 0x20,
  0x5A, 0x0E, 0x70, 0xEA, 0x04, 0x20, 0xAA, 0x0A, 0x7B, 0x03, 0x20, 0xEA, 0x05, 0x60, 0x1B, 0x81,
  0x20, 0x4B, 0x01, 0x60, 0x3B, 0x20, 0x8A, 0x0D, 0x70, 0x6A, 0x0E, 0x20, 0xBA, 0x09, 0x70, 0x8A,
  0x0B, 0x20, 0xEA, 0x05, 0x70, 0xAA, 0x81, 0x90, 0x2B, 0x02, 0x70, 0xEA, 0x81, 0x60, 0x4B, 0x70,
  0x2B, 0x81, 0x20, 0x6A, 0x0D, 0x70, 0x6A, 0x0E, 0x20, 0x8A, 0x0A, 0x70, 0xAA, 0x0A, 0x20, 0x9A,
  0x09, 0x70, 0xEA, 0x05, 0x20, 0xAA, 0x08, 0x60, 0x4B, 0x30, 0xAA, 0x07, 0x60, 0xAA, 0x09, 0x30,
  0x9A, 0x08, 0x50, 0x2B, 0x02, 0x30, 0x8A, 0x09, 0x50, 0xAA, 0x0A, 0x40, 0x6A, 0x0D, 0x40, 0x5B,
  0x02, 0x40, 0x1B, 0x07, 0x20, 0x50, 0xEA, 0x07, 0x60, 0xAB, 0x00, 0xDB, 0x0A, 0x70, 0x10, 0xDE,
  0x09, 0x72, 0x85, 0x18, 0xDF, 0xEA, 0x47, 0x10,
  // "1" (U+0031)
  0x70, 0x5B, 0x01, 0x60, 0x8B, 0x0E, 0x60, 0xAC, 0x0B, 0x40, 0x10, 0xCD, 0x07, 0x30, 0x30, 0xEA,
  0x00, 0xEA, 0x04, 0x20, 0x5B, 0x0D, 0x03, 0xB8, 0x11, 0x02, 0xB8, 0x1B, 0x14, 0xA0, 0xD3, 0x81,
  0x9F, 0x82, 0x08, 0xA0, 0xA4, 0x05, 0x30, 0xCA, 0x07, 0x71, 0xB0, 0x37, 0x03, 0xB7, 0x10, 0x6A,
  0x0C, 0x71, 0x09, 0xA0, 0x97, 0x10, 0xDA, 0x06, 0x71, 0xB0, 0x37, 0x04, 0xB7, 0x10, 0x7A, 0x0C,
  0x71, 0x0A, 0xA0, 0x87, 0x10, 0xDA, 0x05, 0x70, 0x1B, 0x02, 0x70, 0x5A, 0x0E, 0x71, 0x08, 0xA0,
  0xB7, 0x10, 0xBA, 0x08, 0x71, 0x0E, 0xA0, 0x47, 0x02, 0xB0, 0x17, 0x05, 0xA0, 0xD7, 0x10, 0x9A,
  0x0A, 0x71, 0x0C, 0xA0, 0x77, 0x1B, 0x04, 0x60,
  // "2" (U+0032)
  0x71, 0x86, 0x38, 0xCE, 0xFD, 0xA3, 0x72, 0x01, 0x0A, 0xF9, 0x07, 0x70, 0x20, 0xEB, 0x81, 0xEC,
  0xEC, 0x05, 0x78, 0x2E, 0xFE, 0x63, 0x04, 0x0E, 0xA0, 0xD7, 0x81, 0x7B, 0x15, 0x07, 0xB0, 0x27,
  0x70, 0x3B, 0x04, 0x77, 0x01, 0xB0, 0x47, 0x70, 0x3B, 0x02, 0x77, 0x05, 0xB7, 0x71, 0x0A, 0xA0,
  0xB7, 0x70, 0x1B, 0x05, 0x77, 0x09, 0xA0, 0xD7, 0x70, 0x3B, 0x05, 0x76, 0x01, 0x0D, 0xA0, 0xB7,
  0x70, 0xBA, 0x0E, 0x01, 0x76, 0x08, 0xB0, 0x47, 0x60, 0x6B, 0x07, 0x76, 0x04, 0xB0, 0x97, 0x60,
  0x30, 0xEA, 0x0B, 0x76, 0x02, 0x0E, 0xA0, 0xC7, 0x60, 0x10, 0xDA, 0x0D, 0x01, 0x75, 0x01, 0x0C,
  0xA0, 0xD0, 0x17, 0x60, 0xCA, 0x0E, 0x02, 0x76, 0x0B, 0xA0, 0xE0, 0x37, 0x60, 0x9B, 0x04, 0x76,
  0x08, 0xB0, 0x57, 0x60, 0x5B, 0x0E, 0x80, 0x5C, 0x08, 0x40, 0x9F, 0xE0, 0x84, 0x0C, 0xFE, 0x04,
  0x40,
  // "3" (U+0033)
  0x71, 0x86, 0x49, 0xDE, 0xFE, 0xA5, 0x72, 0x04, 0x0D, 0xF9, 0x0A, 0x70, 0x3C, 0x81, 0xEC, 0xDC,
  0x08, 0x78, 0x2D, 0xF9, 0x33, 0x03, 0x0E, 0xB7, 0x04, 0x02, 0x60, 0x5B, 0x04, 0x77, 0x01, 0xB0,
  0x57, 0x71, 0xB0, 0x47, 0x70, 0x2B, 0x01, 0x77, 0x08, 0xA0, 0xC7, 0x70, 0x20, 0xEA, 0x05, 0x76,
  0x01, 0x0C, 0xA0, 0xA7, 0x58, 0x11, 0x7E, 0xA0, 0xB7, 0x28, 0x24, 0xCC, 0xDB, 0x0E, 0x06, 0x73,
  0x08, 0xD0, 0x57, 0x50, 0xBE, 0x07, 0x77, 0x03, 0x09, 0xB0, 0x87, 0x71, 0x07, 0xB0, 0x37, 0x71,
  0x0E, 0xA0, 0x97, 0x71, 0x0A, 0xA0, 0xC7, 0x71, 0x09, 0xA0, 0xC7, 0x71, 0x09, 0xA0, 0xC7, 0x71,
  0x0B, 0xA0, 0xA7, 0x70, 0x1B, 0x06, 0x77, 0x08, 0xB0, 0x13, 0x00, 0x17, 0x10, 0x4B, 0x09, 0x48,
  0x23, 0xE9, 0x34, 0x01, 0x08, 0xB0, 0xD0, 0x14, 0x03, 0xC8, 0x1D, 0xCD, 0xC0, 0xE0, 0x25, 0x02,
  0xFB, 0x0B, 0x01, 0x78, 0x90, 0x17, 0xBD, 0xEF, 0xEC, 0x93, 0x71,
  // "4" (U+0034)
  0x77, 0x07, 0xB0, 0x57, 0x60, 0x3C, 0x01, 0x76, 0x0C, 0xB0, 0xE7, 0x60, 0x8C, 0x0B, 0x75, 0x03,
  0xA0, 0xBA, 0x07, 0x75, 0x82, 0xDF, 0xBA, 0xA0, 0x47, 0x40, 0x9A, 0x03, 0x0E, 0xA0, 0x17, 0x30,
  0x4A, 0x08, 0x02, 0xA0, 0xD7, 0x48, 0x3D, 0xFD, 0x06, 0xA0, 0xA7, 0x30, 0x9A, 0x81, 0x30, 0xAA,
  0x07, 0x72, 0x04, 0xA0, 0x82, 0x0D, 0xA0, 0x47, 0x18, 0x21, 0xEF, 0xD2, 0x01, 0xB0, 0x17, 0x10,
  0xAA, 0x03, 0x20, 0x4A, 0x0D, 0x71, 0x05, 0xA0, 0x83, 0x07, 0xA0, 0xA7, 0x82, 0x1E, 0xFC, 0x40,
  0xBA, 0x06, 0x70, 0xBA, 0x03, 0x40, 0xEA, 0x03, 0x60, 0x6A, 0x07, 0x40, 0x2B, 0x68, 0x21, 0xEF,
  0xC5, 0x05, 0xA0, 0xC6, 0x0B, 0xA0, 0x25, 0x08, 0xA0, 0x95, 0x06, 0xA0, 0x76, 0x0B, 0xA0, 0x65,
  0x0E, 0xFF, 0x98, 0x16, 0x02, 0xFF, 0xA8, 0x12, 0x04, 0x80, 0x6E, 0xB8, 0x1E, 0xED, 0x75, 0x09,
  0xA0, 0x87, 0x71, 0x0D, 0xA0, 0x57, 0x70, 0x1B, 0x01, 0x77, 0x04, 0xA0, 0xD7, 0x71, 0x08, 0xA0,
  0xA7, 0x71, 0x0B, 0xA0, 0x66,
  // "5" (U+0035)
  0x60, 0x5F, 0xB0, 0x86, 0x0A, 0xFB, 0x04, 0x60, 0xEA, 0x80, 0x4C, 0x01, 0x50, 0x3A, 0x0C, 0x77,
  0x07, 0xA0, 0x87, 0x70, 0xBA, 0x03, 0x77, 0xA0, 0xE7, 0x70, 0x5A, 0x0A, 0x77, 0x09, 0xA0, 0x67,
  0x70, 0xDA, 0x01, 0x76, 0x02, 0xA0, 0xC7, 0x70, 0x6A, 0x85, 0xDD, 0xEF, 0xD9, 0x27, 0x10, 0xBF,
  0xA0, 0x57, 0x09, 0xA8, 0x1E, 0xCD, 0xD0, 0x37, 0x05, 0x01, 0x30, 0x10, 0xAB, 0x0B, 0x77, 0x0C,
  0xB0, 0x17, 0x60, 0x5B, 0x04, 0x76, 0x01, 0xB0, 0x67, 0x7B, 0x06, 0x76, 0x01, 0xB0, 0x57, 0x60,
  0x2B, 0x03, 0x76, 0x07, 0xB7, 0x70, 0xCA, 0x0A, 0x76, 0x06, 0xB0, 0x43, 0x03, 0x71, 0x04, 0x0E,
  0xA0, 0xB4, 0x81, 0xDA, 0x34, 0x01, 0x07, 0xB0, 0xE0, 0x24, 0x0D, 0xA8, 0x2E, 0xDC, 0xDC, 0x0E,
  0x03, 0x50, 0xDF, 0xA0, 0xB0, 0x26, 0x89, 0x01, 0x6A, 0xDE, 0xFD, 0xC8, 0x37, 0x10,
  // "6" (U+0036)
  0x73, 0x86, 0x5A, 0xDF, 0xED, 0xB1, 0x71, 0x03, 0x0D, 0xE0, 0xE7, 0x10, 0x6C, 0x83, 0xEC, 0xDF,
  0xA7, 0x07, 0xB0, 0x90, 0x34, 0x01, 0x60, 0x5A, 0x0E, 0x04, 0x75, 0x01, 0x0E, 0xA0, 0x37, 0x60,
  0xBA, 0x06, 0x76, 0x04, 0xA0, 0xC7, 0x70, 0xBA, 0x04, 0x76, 0x03, 0xA0, 0xD7, 0x70, 0x8A, 0x86,
  0x60, 0x28, 0xAB, 0x82, 0x70, 0xEA, 0x01, 0x08, 0xE0, 0x55, 0x03, 0xA0, 0xC0, 0x9F, 0x0E, 0x01,
  0x40, 0x7A, 0x85, 0xEF, 0xC4, 0x01, 0x8B, 0x08, 0x40, 0xBB, 0x0B, 0x50, 0xCA, 0x0C, 0x40, 0xEA,
  0x0E, 0x01, 0x50, 0x6B, 0x30, 0x1B, 0x07, 0x60, 0x4B, 0x30, 0x4B, 0x02, 0x60, 0x4B, 0x30, 0x6A,
  0x0E, 0x70, 0x5A, 0x0E, 0x30, 0x7A, 0x0C, 0x70, 0x7A, 0x0B, 0x30, 0x8A, 0x0B, 0x70, 0xBA, 0x08,
  0x30, 0x8A, 0x0A, 0x70, 0xEA, 0x04, 0x30, 0x7A, 0x0B, 0x60, 0x5A, 0x0E, 0x40, 0x6A, 0x0D, 0x60,
  0xCA, 0x09, 0x40, 0x2B, 0x03, 0x40, 0x6B, 0x02, 0x50, 0xDA, 0x0C, 0x01, 0x20, 0x6B, 0x07, 0x60,
  0x5B, 0x81, 0xEC, 0xEB, 0x0B, 0x71, 0x08, 0xF0, 0xA7, 0x38, 0x54, 0xBE, 0xFE, 0xA4, 0x71,
  // "7" (U+0037)
  0x20, 0x9F, 0xE0, 0xC2, 0x0C, 0xFE, 0x09, 0x20, 0xB8, 0x06, 0xCB, 0x06, 0x75, 0x06, 0xA0, 0xE7,
  0x60, 0xDA, 0x07, 0x75, 0x06, 0xA0, 0xE7, 0x60, 0xDA, 0x07, 0x75, 0x06, 0xA0, 0xE7, 0x60, 0xDA,
  0x07, 0x75, 0x06, 0xA0, 0xE0, 0x17, 0x50, 0xDA, 0x07, 0x75, 0x06, 0xA0, 0xE0, 0x17, 0x50, 0xDA,
  0x07, 0x75, 0x06, 0xA0, 0xE0, 0x17, 0x50, 0xDA, 0x07, 0x75, 0x06, 0xA0, 0xE0, 0x17, 0x50, 0xDA,
  0x07, 0x75, 0x06, 0xA0, 0xE0, 0x17, 0x50, 0xDA, 0x07, 0x75, 0x06, 0xA0, 0xE0, 0x17, 0x50, 0xDA,
  0x08, 0x75, 0x06, 0xA0, 0xE0, 0x17, 0x50, 0xDA, 0x08, 0x75, 0x06, 0xA0, 0xE0, 0x17, 0x50, 0xDA,
  0x08, 0x75, 0x06, 0xA0, 0xE0, 0x17, 0x50, 0xDA, 0x08, 0x75, 0x06, 0xA0, 0xE0, 0x17, 0x50, 0xDA,
  0x08, 0x76,
  // "8" (U+0038)
  0x71, 0x86, 0x4A, 0xDE, 0xEC, 0x81, 0x71, 0x01, 0x0B, 0xF0, 0xE0, 0x37, 0x0D, 0xB8, 0x1E, 0xCE,
  0xB0, 0xD6, 0x09, 0xA0, 0xE0, 0x53, 0x08, 0xB0, 0x64, 0x01, 0xB0, 0x45, 0x0C, 0xA0, 0xA4, 0x06,
  0xA0, 0xC6, 0x08, 0xA0, 0xC4, 0x08, 0xA0, 0x96, 0x07, 0xA0, 0xB4, 0x0A, 0xA0, 0x86, 0x09, 0xA0,
  0x84, 0x09, 0xA0, 0x96, 0x0E, 0xA0, 0x44, 0x06, 0xA0, 0xD5, 0x07, 0xA0, 0xC5, 0x01, 0xB0, 0x43,
  0x05, 0xA0, 0xE0, 0x26, 0x09, 0xA8, 0x2D, 0x10, 0x8A, 0x0E, 0x04, 0x70, 0x10, 0xDA, 0x00, 0xDA,
  0x0D, 0x03, 0x72, 0x03, 0xD0, 0x87, 0x30, 0x50, 0xDD, 0x04, 0x71, 0x01, 0x0A, 0xB0, 0xB0, 0xCB,
  0x03, 0x60, 0x10, 0xDA, 0x0D, 0x04, 0x20, 0xCA, 0x0D, 0x60, 0xDA, 0x0C, 0x01, 0x30, 0x20, 0xEA,
  0x08, 0x40, 0x9A, 0x0D, 0x60, 0x8A, 0x0D, 0x30, 0x1B, 0x04, 0x60, 0x2B, 0x02, 0x20, 0x5A, 0x0D,
  0x71, 0xB0, 0x32, 0x08, 0xA0, 0xB7, 0x10, 0xEA, 0x03, 0x20, 0x9A, 0x0A, 0x70, 0x1B, 0x02, 0x20,
  0x9A, 0x0C, 0x70, 0x6A, 0x0D, 0x30, 0x6B, 0x03, 0x50, 0x10, 0xEA, 0x08, 0x30, 0x1B, 0x0D, 0x03,
  0x30, 0x40, 0xDA, 0x0D, 0x01, 0x40, 0x7C, 0x81, 0xDC, 0xEC, 0x04, 0x60, 0x9F, 0x90, 0xD0, 0x37,
  0x18, 0x63, 0x9D, 0xEF, 0xEB, 0x67,
  // "9" (U+0039)
  0x71, 0x85, 0x6B, 0xEF, 0xD9, 0x27, 0x20, 0x20, 0xDE, 0x0E, 0x03, 0x70, 0x30, 0xEB, 0x00, 0xDB,
  0x0E, 0x01, 0x50, 0x10, 0xDA, 0x0C, 0x03, 0x20, 0x4B, 0x07, 0x50, 0x9A, 0x0D, 0x01, 0x40, 0x9A,
  0x0C, 0x40, 0x1B, 0x04, 0x50, 0x4B, 0x40, 0x7A, 0x0C, 0x60, 0x2B, 0x01, 0x30, 0xCA, 0x06, 0x60,
  0x1B, 0x01, 0x3B, 0x02, 0x60, 0x2B, 0x01, 0x20, 0x3B, 0x70, 0x4B, 0x30, 0x5A, 0x0D, 0x70, 0x7A,
  0x0E, 0x30, 0x6A, 0x0D, 0x70, 0xCA, 0x0C, 0x30, 0x5B, 0x60, 0x5B, 0x0A, 0x30, 0x3B, 0x03, 0x40,
  0x10, 0xEB, 0x08, 0x40, 0xEA, 0x0C, 0x01, 0x20, 0x30, 0xDC, 0x04, 0x40, 0x9C, 0x00, 0xDA, 0x08,
  0xB0, 0x14, 0x01, 0x0D, 0xE0, 0x70, 0x5A, 0x0D, 0x68, 0x71, 0x8D, 0xFD, 0xA3, 0x09, 0xA0, 0x87,
  0x70, 0xEA, 0x03, 0x76, 0x04, 0xA0, 0xD7, 0x70, 0xBA, 0x07, 0x76, 0x03, 0xA0, 0xE0, 0x17, 0x60,
  0xCA, 0x06, 0x76, 0x08, 0xA0, 0xC7, 0x60, 0x7B, 0x02, 0x50, 0x02, 0x40, 0x30, 0xBB, 0x06, 0x68,
  0x47, 0xFE, 0xDC, 0xEC, 0x05, 0x70, 0x7F, 0x0D, 0x04, 0x71, 0x86, 0x4B, 0xDE, 0xFE, 0xB6, 0x73,
  // ":" (U+003A)
  0x48, 0x21, 0xBE, 0xA5, 0x0B, 0xB0, 0x23, 0x01, 0xC0, 0x23, 0x02, 0xB0, 0xC5, 0x82, 0x9E, 0xC2,
  0x80, 0x9D, 0x20, 0x82, 0x7D, 0xE3, 0x40, 0x4B, 0x0B, 0x40, 0x9B, 0x0A, 0x40, 0xAB, 0x05, 0x48,
  0x23, 0xDE, 0x75,
  // ";" (U+003B)
  0x68, 0x21, 0xAE, 0xB7, 0x0A, 0xB0, 0x56, 0xC0, 0x46, 0xB0, 0xE7, 0x82, 0x7E, 0xC3, 0x80, 0xA8,
  0x40, 0x83, 0x4C, 0xCC, 0x26, 0x0A, 0xA0, 0xE7, 0x0E, 0xA0, 0x76, 0x05, 0xA0, 0xE0, 0x16, 0x0B,
  0xA0, 0x86, 0x02, 0xA0, 0xE0, 0x16, 0x08, 0xA0, 0x77, 0x81, 0xEF, 0xD7, 0x05, 0xA0, 0x57, 0x81,
  0xCF, 0xB7, 0x10,
  // "<" (U+003C)
  0x77, 0x20, 0x37, 0x78, 0x13, 0xBE, 0x75, 0x02, 0x0A, 0xA0, 0xE7, 0x30, 0x20, 0x9C, 0x0C, 0x71,
  0x01, 0x09, 0xC0, 0xD0, 0x57, 0x01, 0x08, 0xC0, 0xD0, 0x57, 0x10, 0x70, 0xEB, 0x0D, 0x06, 0x71,
  0x07, 0x0E, 0xB0, 0xD0, 0x67, 0x10, 0x60, 0xEB, 0x0D, 0x06, 0x72, 0x01, 0xB0, 0xE0, 0x67, 0x40,
  0x1C, 0x0B, 0x03, 0x74, 0x02, 0x09, 0xC0, 0xB0, 0x47, 0x40, 0x20, 0xAC, 0x0C, 0x05, 0x74, 0x02,
  0x0A, 0xC0, 0xC0, 0x57, 0x40, 0x20, 0xAC, 0x0D, 0x06, 0x74, 0x02, 0x0A, 0xC0, 0xD0, 0x67, 0x40,
  0x20, 0xAB, 0x0E, 0x76, 0x82, 0x2A, 0xFE, 0x77, 0x10, 0x30, 0xA0,
  // "=" (U+003D)
  0x0E, 0xFF, 0x0D, 0x0E, 0xFF, 0x0D, 0x0B, 0x80, 0x92, 0xC0, 0xA8, 0x09, 0x94, 0x00, 0xB8, 0x09,
  0x2C, 0x0A, 0x0E, 0xFF, 0x0D, 0x0E, 0xFF, 0x0D,
  // ">" (U+003E)
  0x03, 0x77, 0x19, 0x0A, 0x02, 0x76, 0xB0, 0x90, 0x27, 0x40, 0xDC, 0x09, 0x01, 0x73, 0x06, 0x0D,
  0xC0, 0x80, 0x17, 0x30, 0x60, 0xDB, 0x0E, 0x07, 0x74, 0x06, 0x0D, 0xB0, 0xE0, 0x77, 0x40, 0x60,
  0xEB, 0x0E, 0x06, 0x74, 0x06, 0x0E, 0xB0, 0xD0, 0x57, 0x40, 0x70, 0xEB, 0x73, 0x04, 0x0C, 0xC7,
  0x10, 0x50, 0xCC, 0x09, 0x01, 0x60, 0x50, 0xDC, 0x09, 0x01, 0x60, 0x60, 0xDC, 0x09, 0x02, 0x60,
  0x60, 0xDC, 0x09, 0x02, 0x60, 0x70, 0xEC, 0x09, 0x02, 0x71, 0xC0, 0x90, 0x27, 0x3A, 0x09, 0x02,
  0x75, 0x0A, 0x02, 0x77,
  // "?" (U+003F)
  0x48, 0x63, 0x8C, 0xEF, 0xDA, 0x34, 0x02, 0x0B, 0xF9, 0x06, 0x30, 0x4B, 0x81, 0xEC, 0xEC, 0x02,
  0x38, 0x1D, 0xB3, 0x30, 0x6B, 0x07, 0x30, 0x16, 0x0B, 0xA0, 0xA7, 0x30, 0x9A, 0x0A, 0x73, 0x0A,
  0xA0, 0x97, 0x30, 0xDA, 0x06, 0x72, 0x03, 0xB0, 0x17, 0x20, 0xCA, 0x08, 0x72, 0x0A, 0xA0, 0xC7,
  0x20, 0x8A, 0x0E, 0x01, 0x71, 0x07, 0xA0, 0xE0, 0x37, 0x10, 0x6A, 0x0E, 0x03, 0x71, 0x03, 0xB0,
  0x47, 0x20, 0xDA, 0x05, 0x72, 0x06, 0xA0, 0x87, 0x38, 0x1D, 0xFD, 0x73, 0x03, 0xA0, 0x77, 0x30,
  0x7A, 0x02, 0x73, 0x81, 0x7B, 0xA8, 0x0E, 0x00, 0x82, 0x6D, 0xE3, 0x72, 0x04, 0xB0, 0xB7, 0x20,
  0x9B, 0x0A, 0x72, 0x09, 0xB0, 0x57, 0x28, 0x23, 0xDE, 0x77, 0x30,
  // "@" (U+0040)
  0x74, 0x87, 0x16, 0xAD, 0xEF, 0xEB, 0x67, 0x71, 0x08, 0xFA, 0x0E, 0x04, 0x74, 0x04, 0x0D, 0xC8,
  0x2D, 0xCC, 0xEC, 0x04, 0x72, 0x05, 0xB8, 0x1C, 0x61, 0x40, 0x30, 0xAA, 0x0E, 0x01, 0x70, 0x6B,
  0x06, 0x72, 0x07, 0xA0, 0xA6, 0x04, 0xA0, 0xE0, 0x37, 0x40, 0xBA, 0x01, 0x48, 0x31, 0xEF, 0xE2,
  0x75, 0x03, 0xA0, 0x64, 0x0A, 0xA0, 0x47, 0x78, 0x1D, 0xFA, 0x30, 0x3A, 0x09, 0x58, 0x57, 0xCF,
  0xEC, 0x82, 0x38, 0x1A, 0xFC, 0x38, 0x2C, 0xFE, 0x13, 0x01, 0x0C, 0xE0, 0xE3, 0x81, 0x9F, 0xD2,
  0x03, 0xA0, 0x73, 0x01, 0x0D, 0xA8, 0x1E, 0xCE, 0xA0, 0xB3, 0x81, 0x8F, 0xE2, 0x81, 0xAF, 0xE4,
  0x0A, 0xA0, 0x92, 0x01, 0xA0, 0x73, 0x83, 0x8F, 0xD0, 0x1A, 0x09, 0x30, 0x5A, 0x09, 0x30, 0x5A,
  0x03, 0x38, 0x3A, 0xFC, 0x05, 0xA0, 0x33, 0x81, 0xCF, 0xD4, 0x81, 0x9F, 0xE4, 0x85, 0xCF, 0xA0,
  0xAF, 0xE3, 0x04, 0xA0, 0x64, 0x81, 0xDF, 0xA4, 0xA8, 0x38, 0x0E, 0xFA, 0x30, 0x9A, 0x40, 0x2A,
  0x06, 0x30, 0x3A, 0x05, 0x01, 0xA0, 0x73, 0x81, 0xEF, 0xB4, 0x06, 0xA0, 0x23, 0x06, 0xA0, 0x10,
  0x4A, 0x04, 0x20, 0x1A, 0x07, 0x48, 0x1B, 0xFE, 0x48, 0x3B, 0xFD, 0x06, 0xA0, 0x12, 0x04, 0xA0,
  0x43, 0x01, 0xA0, 0xA3, 0x01, 0xA8, 0x17, 0x08, 0xA3, 0x05, 0xA0, 0x33, 0x08, 0xA0, 0x73, 0x07,
  0xA8, 0x31, 0x09, 0xFE, 0x30, 0x6A, 0x04, 0x20, 0x10, 0xEA, 0x05, 0x28, 0x21, 0xEF, 0xA2, 0x81,
  0xAF, 0xD3, 0x05, 0xA0, 0x92, 0x86, 0xBF, 0xBF, 0x90, 0x1C, 0xA0, 0x12, 0x81, 0xAF, 0xE3, 0x02,
  0xB8, 0x3D, 0xEF, 0x87, 0xA0, 0xD0, 0xEA, 0x06, 0x30, 0x9A, 0x40, 0xBC, 0x81, 0xC0, 0x1D, 0x09,
  0x40, 0x8A, 0x02, 0x48, 0x39, 0xEE, 0x91, 0x28, 0x35, 0xDF, 0xC6, 0x50, 0x4A, 0x06, 0x77, 0x70,
  0x1A, 0x0C, 0x77, 0x71, 0x0A, 0xA0, 0x57, 0x77, 0x03, 0xA0, 0xE0, 0x37, 0x77, 0x09, 0xB0, 0x80,
  0x25, 0x82, 0x37, 0xC1, 0x74, 0x0B, 0xC8, 0x2E, 0xCC, 0xDC, 0x01, 0x75, 0x08, 0xFA, 0x0E, 0x08,
  0x77, 0x87, 0x27, 0xBD, 0xFE, 0xDA, 0x57, 0x40,
  // "A" (U+0041)
  0x76, 0x0B, 0xB0, 0x87, 0x60, 0x2C, 0x08, 0x76, 0x09, 0xC0, 0x97, 0x50, 0x1A, 0x0E, 0xA0, 0xA7,
  0x50, 0x7A, 0x08, 0xA0, 0xA7, 0x50, 0xEA, 0x03, 0xA0, 0xB7, 0x40, 0x6A, 0x09, 0x02, 0xA0, 0xB7,
  0x40, 0xDA, 0x03, 0x02, 0xA0, 0xC7, 0x30, 0x4A, 0x81, 0xC0, 0x1A, 0x0D, 0x73, 0x0B, 0xA8, 0x16,
  0x01, 0xA0, 0xD7, 0x20, 0x3A, 0x0E, 0x20, 0x1A, 0x0E, 0x72, 0x0A, 0xA0, 0x92, 0x01, 0xA0, 0xE7,
  0x10, 0x1B, 0x02, 0x20, 0x1B, 0x71, 0x08, 0xA0, 0xC3, 0x01, 0xB7, 0x10, 0xEA, 0x05, 0x30, 0x1B,
  0x01, 0x60, 0x7A, 0x0E, 0x40, 0x1B, 0x01, 0x60, 0xDA, 0x08, 0x5B, 0x02, 0x50, 0x5F, 0xD0, 0x35,
  0x0C, 0xFD, 0x03, 0x40, 0x3B, 0x80, 0x3C, 0xB0, 0x44, 0x0A, 0xA0, 0xC7, 0xB0, 0x43, 0x02, 0xB0,
  0x57, 0xB0, 0x53, 0x09, 0xA0, 0xE7, 0x10, 0xEA, 0x06, 0x20, 0x10, 0xEA, 0x07, 0x71, 0x0E, 0xA0,
  0x62, 0x07, 0xB0, 0x17, 0x10, 0xDA, 0x07, 0x20, 0xEA, 0x09, 0x72, 0x0D, 0xA8, 0x17, 0x06, 0xB0,
  0x37, 0x20, 0xCA, 0x81, 0x80, 0xDA, 0x0C, 0x73, 0x0C, 0xA0, 0x90, 0x4B, 0x05, 0x73, 0x0B, 0xA0,
  0x90,
  // "B" (U+0042)
  0x60, 0x9E, 0x82, 0xEC, 0x81, 0x72, 0x0C, 0xFB, 0x06, 0x71, 0xB8, 0x00, 0xC0, 0xEC, 0x05, 0x60,
  0x3B, 0x01, 0x40, 0x6B, 0x0D, 0x60, 0x6A, 0x0D, 0x60, 0x9B, 0x02, 0x50, 0x9A, 0x0A, 0x60, 0x5B,
  0x04, 0x50, 0xDA, 0x06, 0x60, 0x3B, 0x04, 0x5B, 0x03, 0x60, 0x5B, 0x02, 0x40, 0x3B, 0x70, 0x8A,
  0x0E, 0x50, 0x7A, 0x0C, 0x60, 0x10, 0xEA, 0x08, 0x50, 0xAA, 0x09, 0x60, 0xBA, 0x0E, 0x01, 0x50,
  0xDA, 0x05, 0x40, 0x30, 0xCB, 0x04, 0x50, 0x1B, 0x83, 0xDC, 0xCC, 0xEB, 0x0C, 0x03, 0x60, 0x4F,
  0xA0, 0xD0, 0x47, 0x10, 0x7F, 0xB0, 0xC0, 0x27, 0x0B, 0xA0, 0x93, 0x81, 0x15, 0xDA, 0x0D, 0x01,
  0x60, 0xEA, 0x05, 0x50, 0x10, 0xEA, 0x08, 0x50, 0x1B, 0x02, 0x60, 0x8A, 0x0E, 0x50, 0x5A, 0x0E,
  0x70, 0x5B, 0x50, 0x8A, 0x0B, 0x70, 0x4B, 0x02, 0x40, 0xBA, 0x08, 0x70, 0x5B, 0x01, 0x40, 0xEA,
  0x05, 0x70, 0x8A, 0x0E, 0x40, 0x2B, 0x02, 0x70, 0xDA, 0x0B, 0x40, 0x5A, 0x0E, 0x70, 0x4B, 0x05,
  0x40, 0x9A, 0x0B, 0x60, 0x20, 0xDA, 0x0C, 0x50, 0xCA, 0x08, 0x50, 0x50, 0xEB, 0x02, 0x5B, 0x83,
  0xDC, 0xCC, 0xDC, 0x0E, 0x05, 0x50, 0x3F, 0xC0, 0xD0, 0x26, 0x06, 0xF8, 0x2E, 0xD9, 0x57, 0x10,
  // "C" (U+0043)
  0x73, 0x87, 0x4A, 0xDE, 0xFE, 0xB7, 0x27, 0x20, 0x30, 0xCF, 0xA0, 0x37, 0x06, 0xD8, 0x1C, 0xCE,
  0xA0, 0xC7, 0x06, 0xB0, 0xD0, 0x54, 0x81, 0x5D, 0x36, 0x05, 0xB0, 0xB0, 0x17, 0x60, 0x10, 0xEA,
  0x0C, 0x77, 0x10, 0xBA, 0x0E, 0x01, 0x77, 0x03, 0xB0, 0x67, 0x71, 0x0B, 0xA0, 0xD7, 0x71, 0x02,
  0xB0, 0x67, 0x71, 0x08, 0xA0, 0xE7, 0x72, 0x0D, 0xA0, 0x97, 0x71, 0x02, 0xB0, 0x57, 0x71, 0x06,
  0xB0, 0x17, 0x71, 0x09, 0xA0, 0xD7, 0x72, 0x0C, 0xA0, 0xA7, 0x72, 0x0E, 0xA0, 0x87, 0x72, 0xB0,
  0x67, 0x71, 0x01, 0xB0, 0x57, 0x71, 0x01, 0xB0, 0x57, 0x71, 0x01, 0xB0, 0x57, 0x72, 0xB0, 0x77,
  0x72, 0x0D, 0xA0, 0xA7, 0x72, 0x09, 0xA0, 0xE7, 0x72, 0x04, 0xB0, 0x87, 0x72, 0x0C, 0xB0, 0x80,
  0x13, 0x81, 0x16, 0x67, 0x10, 0x30, 0xEC, 0x81, 0xCC, 0xDA, 0x09, 0x72, 0x03, 0x0E, 0xF9, 0x09,
  0x74, 0x87, 0x7C, 0xEF, 0xEC, 0xA6, 0x16,
  // "D" (U+0044)
  0x60, 0x9D, 0x82, 0xED, 0xA5, 0x74, 0x0C, 0xFA, 0x0C, 0x02, 0x72, 0xB0, 0xFC, 0x0D, 0xC0, 0xE0,
  0x27, 0x03, 0xB0, 0x13, 0x02, 0x0A, 0xB0, 0xC7, 0x06, 0xA0, 0xD6, 0x09, 0xB0, 0x56, 0x09, 0xA0,
  0xA7, 0x0E, 0xA0, 0xB6, 0x0D, 0xA0, 0x77, 0x09, 0xA0, 0xE6, 0xB0, 0x47, 0x06, 0xB0, 0x14, 0x03,
  0xB7, 0x10, 0x5B, 0x02, 0x40, 0x7A, 0x0D, 0x71, 0x04, 0xB0, 0x34, 0x0A, 0xA0, 0x97, 0x10, 0x5B,
  0x02, 0x40, 0xDA, 0x06, 0x71, 0x06, 0xB0, 0x23, 0x01, 0xB0, 0x37, 0x10, 0x7B, 0x40, 0x4B, 0x72,
  0x09, 0xA0, 0xE4, 0x07, 0xA0, 0xC7, 0x20, 0xCA, 0x0B, 0x40, 0xBA, 0x09, 0x72, 0x0E, 0xA0, 0x84,
  0x0E, 0xA0, 0x67, 0x10, 0x3B, 0x04, 0x30, 0x1B, 0x03, 0x71, 0x07, 0xB0, 0x13, 0x05, 0xB7, 0x20,
  0xCA, 0x0B, 0x40, 0x8A, 0x0C, 0x71, 0x04, 0xB0, 0x54, 0x0B, 0xA0, 0x97, 0x10, 0xAA, 0x0E, 0x50,
  0xEA, 0x05, 0x70, 0x4B, 0x06, 0x40, 0x2B, 0x02, 0x70, 0xDA, 0x0D, 0x50, 0x5A, 0x0E, 0x70, 0xBB,
  0x03, 0x50, 0x9A, 0x0B, 0x50, 0x10, 0xCB, 0x07, 0x60, 0xCA, 0x08, 0x38, 0x11, 0x7E, 0xB0, 0x77,
  0xB8, 0x2D, 0xCC, 0xDC, 0x0E, 0x06, 0x70, 0x3F, 0xB0, 0xA0, 0x17, 0x10, 0x6E, 0x82, 0xEB, 0x72,
  0x73,
  // "E" (U+0045)
  0x60, 0x9F, 0xC6, 0x0C, 0xFB, 0x0C, 0x6B, 0x80, 0x4C, 0x07, 0x50, 0x3B, 0x77, 0x06, 0xA0, 0xD7,
  0x70, 0x9A, 0x0A, 0x77, 0x0D, 0xA0, 0x67, 0x7B, 0x03, 0x76, 0x03, 0xB7, 0x70, 0x7A, 0x0C, 0x77,
  0x0A, 0xA0, 0x97, 0x70, 0xDA, 0x06, 0x76, 0x01, 0xB0, 0xD8, 0x02, 0xC0, 0xB6, 0x04, 0xFB, 0x0B,
  0x60, 0x7F, 0xB0, 0x76, 0x0B, 0xA0, 0x87, 0x70, 0xEA, 0x05, 0x76, 0x01, 0xB0, 0x27, 0x60, 0x5A,
  0x0E, 0x77, 0x08, 0xA0, 0xB7, 0x70, 0xBA, 0x08, 0x77, 0x0E, 0xA0, 0x57, 0x60, 0x2B, 0x02, 0x76,
  0x05, 0xA0, 0xE7, 0x70, 0x9A, 0x0B, 0x77, 0x0C, 0xA0, 0x87, 0x7B, 0x0D, 0x80, 0x3C, 0x07, 0x50,
  0x3F, 0xC0, 0x65, 0x06, 0xFC, 0x03, 0x50,
  // "F" (U+0046)
  0x60, 0x9F, 0xC6, 0x0C, 0xFB, 0x0C, 0x6B, 0x80, 0x4C, 0x07, 0x50, 0x3B, 0x01, 0x76, 0x06, 0xA0,
  0xD7, 0x70, 0x9A, 0x0A, 0x77, 0x0D, 0xA0, 0x77, 0x7B, 0x04, 0x76, 0x03, 0xB0, 0x17, 0x60, 0x7A,
  0x0E, 0x77, 0x0A, 0xA0, 0xB7, 0x70, 0xDA, 0x08, 0x76, 0x01, 0xB0, 0x57, 0x60, 0x4B, 0x02, 0x76,
  0x07, 0xFB, 0x0A, 0x60, 0xBF, 0xB0, 0x76, 0x0E, 0xA0, 0xD8, 0x03, 0xC0, 0x35, 0x01, 0xB0, 0x37,
  0x60, 0x5B, 0x77, 0x08, 0xA0, 0xC7, 0x70, 0xBA, 0x09, 0x77, 0x0E, 0xA0, 0x67, 0x60, 0x2B, 0x02,
  0x76, 0x05, 0xA0, 0xE7, 0x70, 0x9A, 0x0B, 0x77, 0x0C, 0xA0, 0x87, 0x7B, 0x05, 0x76, 0x03, 0xB0,
  0x17, 0x60, 0x6A, 0x0E, 0x77,
  // "G" (U+0047)
  0x73, 0x89, 0x02, 0x8B, 0xEF, 0xED, 0xB7, 0x27, 0x30, 0x10, 0xAF, 0xB0, 0xB0, 0x17, 0x05, 0x0E,
  0xC8, 0x1D, 0xCD, 0xC0, 0xD7, 0x06, 0xB8, 0x1E, 0x71, 0x48, 0x24, 0xBF, 0x56, 0x05, 0xB0, 0xD0,
  0x27, 0x10, 0x36, 0x02, 0x0E, 0xA0, 0xD0, 0x17, 0x72, 0x0B, 0xB0, 0x27, 0x72, 0x04, 0xB0, 0x77,
  0x73, 0x0C, 0xA0, 0xD7, 0x73, 0x03, 0xB0, 0x67, 0x73, 0x09, 0xA0, 0xE7, 0x74, 0x0E, 0xA0, 0x97,
  0x73, 0x03, 0xB0, 0x47, 0x73, 0x06, 0xB6, 0x02, 0x80, 0x3C, 0x02, 0x30, 0xAA, 0x0C, 0x60, 0x6F,
  0x40, 0xDA, 0x0A, 0x60, 0xAE, 0x0C, 0x40, 0xEA, 0x07, 0x73, 0x0A, 0xA0, 0x94, 0xB0, 0x67, 0x30,
  0xDA, 0x06, 0x30, 0x1B, 0x05, 0x72, 0x01, 0xB0, 0x33, 0x01, 0xB0, 0x57, 0x20, 0x4B, 0x40, 0x1B,
  0x05, 0x72, 0x07, 0xA0, 0xC5, 0xB0, 0x77, 0x20, 0xAA, 0x08, 0x50, 0xCA, 0x0B, 0x72, 0x0D, 0xA0,
  0x55, 0x09, 0xB0, 0x17, 0x01, 0xB0, 0x25, 0x03, 0xB0, 0xA7, 0x04, 0xA0, 0xE7, 0x0B, 0xB0, 0xB0,
  0x24, 0x01, 0x09, 0xA0, 0xB7, 0x01, 0x0D, 0xC8, 0x2E, 0xCC, 0xEC, 0x08, 0x71, 0x01, 0x0B, 0xFB,
  0x0D, 0x03, 0x73, 0x89, 0x04, 0x9C, 0xEF, 0xED, 0xB7, 0x27,
  // "H" (U+0048)
  0x60, 0x8A, 0x0B, 0x71, 0x01, 0xB0, 0x36, 0x0B, 0xA0, 0x87, 0x10, 0x4B, 0x70, 0xEA, 0x04, 0x71,
  0x07, 0xA0, 0xC6, 0x02, 0xB0, 0x17, 0x10, 0xAA, 0x09, 0x60, 0x5A, 0x0D, 0x72, 0x0D, 0xA0, 0x66,
  0x09, 0xA0, 0xA7, 0x10, 0x1B, 0x03, 0x60, 0xCA, 0x07, 0x71, 0x04, 0xB7, 0xB0, 0x47, 0x10, 0x8A,
  0x0C, 0x60, 0x3B, 0x01, 0x71, 0x0B, 0xA0, 0x86, 0x06, 0xA0, 0xD7, 0x20, 0xEA, 0x05, 0x60, 0x9A,
  0x09, 0x71, 0x02, 0xB0, 0x26, 0x0D, 0xA0, 0x67, 0x10, 0x5A, 0x0E, 0x7B, 0x0D, 0x80, 0x4C, 0x0D,
  0xA0, 0xB6, 0x03, 0xFF, 0x90, 0x86, 0x07, 0xFF, 0x90, 0x46, 0x0A, 0xA0, 0x87, 0x10, 0x4B, 0x01,
  0x60, 0xDA, 0x05, 0x71, 0x07, 0xA0, 0xD6, 0x01, 0xB0, 0x27, 0x10, 0xAA, 0x0A, 0x60, 0x4A, 0x0E,
  0x72, 0x0E, 0xA0, 0x76, 0x07, 0xA0, 0xB7, 0x10, 0x1B, 0x04, 0x60, 0xBA, 0x08, 0x71, 0x04, 0xB0,
  0x16, 0x0E, 0xA0, 0x47, 0x10, 0x7A, 0x0D, 0x60, 0x2B, 0x01, 0x71, 0x0A, 0xA0, 0x96, 0x05, 0xA0,
  0xE7, 0x20, 0xEA, 0x06, 0x60, 0x8A, 0x0B, 0x71, 0x01, 0xB0, 0x36, 0x0B, 0xA0, 0x77, 0x10, 0x4B,
  0x70, 0xEA, 0x04, 0x71, 0x07, 0xA0, 0xC6, 0x02, 0xB0, 0x17, 0x10, 0xAA, 0x09, 0x60, 0x5A, 0x0D,
  0x72, 0x0D, 0xA0, 0x56,
  // "I" (U+0049)
  0x60, 0xBF, 0x90, 0xB6, 0x0D, 0xF9, 0x07, 0x68, 0x13, 0x7A, 0xB8, 0x19, 0x41, 0x72, 0x03, 0xB7,
  0x50, 0x6A, 0x0C, 0x75, 0x0A, 0xA0, 0x97, 0x50, 0xDA, 0x06, 0x74, 0x01, 0xB0, 0x37, 0x40, 0x4B,
  0x75, 0x07, 0xA0, 0xC7, 0x50, 0xAA, 0x09, 0x75, 0x0E, 0xA0, 0x57, 0x40, 0x1B, 0x02, 0x74, 0x05,
  0xA0, 0xE7, 0x50, 0x8A, 0x0B, 0x75, 0x0B, 0xA0, 0x87, 0x50, 0xEA, 0x05, 0x74, 0x02, 0xB0, 0x27,
  0x40, 0x5A, 0x0E, 0x75, 0x09, 0xA0, 0xB7, 0x50, 0xCA, 0x08, 0x75, 0xB0, 0x47, 0x40, 0x3B, 0x01,
  0x74, 0x06, 0xA0, 0xD7, 0x50, 0x9A, 0x0A, 0x75, 0x0D, 0xA0, 0x77, 0x30, 0x30, 0x6B, 0x09, 0x03,
  0x70, 0x5F, 0xA0, 0x15, 0x09, 0xF9, 0x0D, 0x60,
  // "J" (U+004A)
  0x75, 0x08, 0xA0, 0xB7, 0x50, 0xBA, 0x08, 0x75, 0x0E, 0xA0, 0x57, 0x40, 0x2B, 0x02, 0x74, 0x06,
  0xA0, 0xE7, 0x50, 0x9A, 0x0B, 0x75, 0x0C, 0xA0, 0x77, 0x5B, 0x04, 0x74, 0x03, 0xB0, 0x17, 0x40,
  0x6A, 0x0D, 0x75, 0x0A, 0xA0, 0xA7, 0x50, 0xDA, 0x06, 0x74, 0x01, 0xB0, 0x37, 0x40, 0x4B, 0x75,
  0x07, 0xA0, 0xC7, 0x50, 0xBA, 0x09, 0x75, 0x0E, 0xA0, 0x57, 0x40, 0x2B, 0x02, 0x74, 0x05, 0xA0,
  0xE7, 0x50, 0x8A, 0x0B, 0x75, 0x0B, 0xA0, 0x87, 0x50, 0xEA, 0x04, 0x74, 0x02, 0xB0, 0x17, 0x40,
  0x6A, 0x0D, 0x75, 0x09, 0xA0, 0xA7, 0x50, 0xCA, 0x07, 0x75, 0xB0, 0x37, 0x40, 0x3B, 0x75, 0x07,
  0xA0, 0xC7, 0x50, 0xBA, 0x09, 0x74, 0x01, 0xB0, 0x47, 0x40, 0x8A, 0x0E, 0x70, 0x13, 0x06, 0xB0,
  0x77, 0x82, 0x9E, 0xCD, 0xB0, 0xC7, 0x10, 0xCD, 0x0C, 0x01, 0x71, 0x84, 0xAE, 0xFE, 0xC6, 0x73,
  // "K" (U+004B)
  0x60, 0x9A, 0x0B, 0x70, 0xAA, 0x0E, 0x01, 0x60, 0xCA, 0x08, 0x60, 0x7B, 0x04, 0x7B, 0x05, 0x50,
  0x3B, 0x08, 0x70, 0x3B, 0x01, 0x40, 0x10, 0xDA, 0x0B, 0x71, 0x06, 0xA0, 0xE5, 0x0B, 0xA0, 0xE0,
  0x17, 0x10, 0x9A, 0x0A, 0x40, 0x8B, 0x04, 0x72, 0x0D, 0xA0, 0x73, 0x04, 0xB0, 0x87, 0x3B, 0x04,
  0x20, 0x10, 0xEA, 0x0B, 0x73, 0x03, 0xB0, 0x12, 0x0C, 0xA0, 0xE0, 0x17, 0x30, 0x7A, 0x0D, 0x20,
  0x9B, 0x03, 0x74, 0x0A, 0xA8, 0x1A, 0x05, 0xB0, 0x77, 0x50, 0xDA, 0x81, 0x72, 0xEA, 0x0B, 0x75,
  0x01, 0xB0, 0x40, 0xCA, 0x0D, 0x01, 0x75, 0x04, 0xB0, 0x8B, 0x07, 0x76, 0x07, 0xF0, 0xB7, 0x60,
  0xBC, 0x0E, 0xB7, 0x60, 0xEB, 0x0A, 0x02, 0xB0, 0x47, 0x40, 0x1B, 0x09, 0x20, 0xDA, 0x08, 0x74,
  0x05, 0xB3, 0x09, 0xA0, 0xD7, 0x40, 0x8A, 0x0C, 0x30, 0x5B, 0x01, 0x73, 0x0B, 0xA0, 0x93, 0x01,
  0xB0, 0x67, 0x30, 0xEA, 0x05, 0x40, 0xCA, 0x0A, 0x72, 0x02, 0xB0, 0x24, 0x08, 0xA0, 0xE7, 0x20,
  0x5A, 0x0E, 0x50, 0x4B, 0x03, 0x71, 0x09, 0xA0, 0xB6, 0xB0, 0x77, 0x10, 0xCA, 0x08, 0x60, 0xCA,
  0x0B, 0x71, 0xB0, 0x56, 0x08, 0xB7, 0x03, 0xB0, 0x16, 0x04, 0xB0, 0x46, 0x06, 0xA0, 0xD7, 0x1B,
  0x09, 0x60,
  // "L" (U+004C)
  0x60, 0x9A, 0x0B, 0x72, 0x0C, 0xA0, 0x87, 0x2B, 0x05, 0x71, 0x03, 0xB0, 0x17, 0x10, 0x6A, 0x0E,
  0x72, 0x09, 0xA0, 0xA7, 0x20, 0xDA, 0x07, 0x72, 0xB0, 0x47, 0x10, 0x3B, 0x01, 0x71, 0x07, 0xA0,
  0xD7, 0x20, 0xAA, 0x0A, 0x72, 0x0D, 0xA0, 0x67, 0x10, 0x1B, 0x03, 0x71, 0x04, 0xB7, 0x20, 0x7A,
  0x0C, 0x72, 0x0B, 0xA0, 0x97, 0x20, 0xEA, 0x06, 0x71, 0x01, 0xB0, 0x27, 0x10, 0x5A, 0x0E, 0x72,
  0x08, 0xA0, 0xB7, 0x20, 0xBA, 0x08, 0x72, 0x0E, 0xA0, 0x57, 0x10, 0x2B, 0x02, 0x71, 0x05, 0xA0,
  0xE7, 0x20, 0x9A, 0x0B, 0x72, 0x0C, 0xA0, 0x87, 0x2F, 0xC0, 0x70, 0x3F, 0xC0, 0x40, 0x6F, 0xC0,
  0x10,
  // "M" (U+004D)
  0x60, 0x9C, 0x02, 0x74, 0x06, 0xC0, 0xB6, 0x0C, 0xC0, 0x37, 0x40, 0xDC, 0x08, 0x6D, 0x04, 0x73,
  0x05, 0xD0, 0x55, 0x03, 0xD0, 0x57, 0x30, 0xCD, 0x02, 0x50, 0x6D, 0x06, 0x72, 0x04, 0xD0, 0xE6,
  0x09, 0xA0, 0xDA, 0x07, 0x72, 0x0B, 0xA0, 0xDA, 0x0B, 0x60, 0xDA, 0x09, 0xA0, 0x87, 0x10, 0x3A,
  0x0E, 0x0A, 0xA0, 0x86, 0xB0, 0x6A, 0x09, 0x71, 0x0A, 0xA0, 0x70, 0xDA, 0x04, 0x50, 0x3A, 0x0D,
  0x04, 0xA0, 0xA7, 0x02, 0xA0, 0xE0, 0x2B, 0x01, 0x50, 0x7A, 0x0A, 0x03, 0xA0, 0xB7, 0x09, 0xA0,
  0x80, 0x5A, 0x0D, 0x60, 0xAA, 0x08, 0x02, 0xA0, 0xC6, 0x01, 0xA8, 0x1E, 0x18, 0xA0, 0xA6, 0x0D,
  0xA0, 0x40, 0x1A, 0x0D, 0x60, 0x8A, 0x81, 0x80, 0xBA, 0x07, 0x50, 0x1B, 0x01, 0x1A, 0x0E, 0x50,
  0x10, 0xEA, 0x81, 0x10, 0xEA, 0x04, 0x50, 0x4A, 0x0D, 0x20, 0xEA, 0x50, 0x7A, 0x81, 0x90, 0x2B,
  0x01, 0x50, 0x7A, 0x0A, 0x20, 0xDA, 0x50, 0xEA, 0x81, 0x20, 0x6A, 0x0D, 0x60, 0xBA, 0x07, 0x20,
  0xCA, 0x01, 0x30, 0x6A, 0x09, 0x20, 0x9A, 0x0A, 0x60, 0xEA, 0x03, 0x20, 0xBA, 0x02, 0x30, 0xDA,
  0x02, 0x20, 0xCA, 0x06, 0x50, 0x1B, 0x30, 0xAA, 0x03, 0x20, 0x5A, 0x0A, 0x3B, 0x03, 0x50, 0x5A,
  0x0C, 0x30, 0x9A, 0x04, 0x20, 0xDA, 0x03, 0x20, 0x3B, 0x60, 0x8A, 0x09, 0x30, 0x8A, 0x81, 0x50,
  0x4A, 0x0B, 0x30, 0x7A, 0x0C, 0x60, 0xBA, 0x06, 0x30, 0x7A, 0x81, 0x60, 0xCA, 0x03, 0x30, 0xAA,
  0x09, 0x60, 0xEA, 0x02, 0x30, 0x6A, 0x07, 0x03, 0xA0, 0xB4, 0x0D, 0xA0, 0x65, 0x02, 0xA0, 0xE4,
  0x05, 0xA0, 0x80, 0xBA, 0x04, 0x30, 0x1B, 0x03, 0x50, 0x5A, 0x0B, 0x40, 0x4A, 0x0C, 0xA0, 0xC4,
  0x04, 0xB6, 0x09, 0xA0, 0x84, 0x03, 0xD0, 0x44, 0x08, 0xA0, 0xC6, 0x0C, 0xA0, 0x54, 0x02, 0xC0,
  0xC5, 0x0B, 0xA0, 0x86, 0xB0, 0x14, 0x01, 0xC0, 0x55, 0x0E, 0xA0, 0x55, 0x03, 0xA0, 0xE6, 0xB0,
  0xD5, 0x02, 0xB0, 0x25, 0x06, 0xA0, 0xA6, 0xB0, 0x65, 0x05, 0xA0, 0xE6,
  // "N" (U+004E)
  0x60, 0x9B, 0x06, 0x72, 0x0B, 0xA0, 0x76, 0x0C, 0xB0, 0xA7, 0x20, 0xEA, 0x03, 0x6C, 0x0D, 0x71,
  0x02, 0xB6, 0x03, 0xD0, 0x17, 0x05, 0xA0, 0xC6, 0x06, 0xD0, 0x57, 0x09, 0xA0, 0x96, 0x09, 0xA0,
  0xEA, 0x08, 0x70, 0xCA, 0x06, 0x60, 0xDA, 0x08, 0xA0, 0xB7, 0xB0, 0x36, 0xB0, 0x2B, 0x60, 0x3B,
  0x60, 0x3A, 0x81, 0xD0, 0xDA, 0x03, 0x50, 0x6A, 0x0C, 0x60, 0x7A, 0x81, 0xA0, 0xAA, 0x06, 0x50,
  0x9A, 0x08, 0x60, 0xAA, 0x81, 0x70, 0x6A, 0x0A, 0x50, 0xCA, 0x05, 0x60, 0xDA, 0x81, 0x40, 0x3A,
  0x0D, 0x5B, 0x02, 0x50, 0x1B, 0x01, 0x2B, 0x01, 0x30, 0x3A, 0x0E, 0x60, 0x4A, 0x0D, 0x30, 0xBA,
  0x05, 0x30, 0x7A, 0x0B, 0x60, 0x7A, 0x0A, 0x30, 0x8A, 0x08, 0x30, 0xAA, 0x08, 0x60, 0xBA, 0x07,
  0x30, 0x4A, 0x0C, 0x30, 0xDA, 0x04, 0x60, 0xEA, 0x04, 0x30, 0x1B, 0x20, 0x1B, 0x01, 0x50, 0x1B,
  0x50, 0xDA, 0x81, 0x30, 0x4A, 0x0D, 0x60, 0x5A, 0x0D, 0x50, 0x9A, 0x81, 0x70, 0x7A, 0x0A, 0x60,
  0x8A, 0x09, 0x50, 0x6A, 0x81, 0xA0, 0xAA, 0x07, 0x60, 0xBA, 0x06, 0x50, 0x2A, 0x81, 0xE0, 0xCA,
  0x04, 0x60, 0xEA, 0x03, 0x60, 0xEA, 0x02, 0xB6, 0x02, 0xB7, 0x0B, 0xA0, 0x8A, 0x0D, 0x60, 0x5A,
  0x0C, 0x70, 0x7A, 0x0E, 0xA0, 0x96, 0x09, 0xA0, 0x97, 0x04, 0xD0, 0x66, 0x0C, 0xA0, 0x57, 0x1D,
  0x03, 0x6B, 0x02, 0x71, 0x0C, 0xC6, 0x03, 0xA0, 0xE7, 0x20, 0x9B, 0x0C, 0x60, 0x6A, 0x0B, 0x72,
  0x05, 0xB0, 0x96,
  // "O" (U+004F)
  0x72, 0x86, 0x28, 0xCE, 0xFE, 0xB6, 0x75, 0x07, 0xF9, 0x0D, 0x02, 0x72, 0x0B, 0xC0, 0x0C, 0xC0,
  0xE0, 0x17, 0x0B, 0xB0, 0x80, 0x13, 0x08, 0xB0, 0x96, 0x09, 0xB0, 0x56, 0x0A, 0xB0, 0x14, 0x03,
  0xB0, 0x67, 0x02, 0xB0, 0x54, 0x0D, 0xA0, 0xB7, 0x20, 0xEA, 0x08, 0x30, 0x5B, 0x03, 0x72, 0x0B,
  0xA0, 0xA3, 0x0C, 0xA0, 0xB7, 0x30, 0xAA, 0x0B, 0x20, 0x3B, 0x04, 0x73, 0x0B, 0xA0, 0xB2, 0x09,
  0xA0, 0xE7, 0x40, 0xBA, 0x0A, 0x20, 0xEA, 0x09, 0x74, 0x0D, 0xA8, 0x19, 0x02, 0xB0, 0x57, 0x40,
  0xEA, 0x81, 0x70, 0x6B, 0x01, 0x73, 0x01, 0xB8, 0x15, 0x09, 0xA0, 0xD7, 0x40, 0x4B, 0x81, 0x30,
  0xCA, 0x0A, 0x74, 0x07, 0xB2, 0x0E, 0xA0, 0x87, 0x40, 0xBA, 0x0C, 0x2B, 0x07, 0x74, 0xB8, 0x17,
  0x01, 0xB0, 0x57, 0x30, 0x5B, 0x81, 0x20, 0x2B, 0x05, 0x73, 0x0A, 0xA0, 0xD2, 0x01, 0xB0, 0x57,
  0x20, 0x1B, 0x06, 0x20, 0x1B, 0x06, 0x72, 0x08, 0xA0, 0xE4, 0x0E, 0xA0, 0x87, 0x10, 0x2B, 0x07,
  0x40, 0xBA, 0x0C, 0x71, 0x0C, 0xA0, 0xD5, 0x07, 0xB0, 0x46, 0x0A, 0xB0, 0x45, 0x01, 0x0E, 0xA0,
  0xE0, 0x53, 0x03, 0x0B, 0xB0, 0x67, 0x06, 0xC8, 0x1E, 0xCD, 0xC0, 0x77, 0x20, 0x6F, 0x90, 0xE0,
  0x47, 0x48, 0x62, 0x8C, 0xEF, 0xEB, 0x67, 0x20,
  // "P" (U+0050)
  0x60, 0x9D, 0x82, 0xEC, 0x82, 0x72, 0x0C, 0xFA, 0x07, 0x71, 0xB0, 0xFC, 0x0E, 0xC0, 0x56, 0x03,
  0xB0, 0x13, 0x05, 0x0E, 0xA0, 0xE6, 0x06, 0xA0, 0xD5, 0x06, 0xB0, 0x55, 0x09, 0xA0, 0xA6, 0x0E,
  0xA0, 0x85, 0x0D, 0xA0, 0x76, 0x0C, 0xA0, 0x95, 0xB0, 0x46, 0x0C, 0xA0, 0x94, 0x03, 0xB0, 0x16,
  0x0D, 0xA0, 0x84, 0x07, 0xA0, 0xD6, 0x01, 0xB0, 0x54, 0x0A, 0xA0, 0xA6, 0x05, 0xB0, 0x24, 0x0D,
  0xA0, 0x76, 0x0B, 0xA0, 0xC4, 0x01, 0xB0, 0x45, 0x05, 0xB0, 0x64, 0x04, 0xB0, 0x14, 0x04, 0x0E,
  0xA0, 0xC5, 0x07, 0xA0, 0xD2, 0x81, 0x14, 0xAB, 0x0E, 0x02, 0x50, 0xBF, 0xB0, 0xD0, 0x26, 0x0E,
  0xFA, 0x08, 0x01, 0x60, 0x1B, 0x85, 0xCC, 0xBB, 0x85, 0x17, 0x10, 0x5B, 0x77, 0x10, 0x8A, 0x0C,
  0x77, 0x10, 0xBA, 0x09, 0x77, 0x10, 0xEA, 0x05, 0x77, 0x02, 0xB0, 0x27, 0x70, 0x5A, 0x0E, 0x77,
  0x10, 0x9A, 0x0B, 0x77, 0x10, 0xCA, 0x08, 0x77, 0x1B, 0x05, 0x77, 0x03, 0xB0, 0x17, 0x70, 0x6A,
  0x0D, 0x77, 0x10,
  // "Q" (U+0051)
  0x72, 0x86, 0x28, 0xCE, 0xFE, 0xB6, 0x75, 0x07, 0xF9, 0x0D, 0x02, 0x72, 0x0B, 0xC0, 0x0C, 0xC0,
  0xE0, 0x17, 0x0B, 0xB0, 0x80, 0x13, 0x08, 0xB0, 0x96, 0x09, 0xB0, 0x56, 0x0A, 0xB0, 0x14, 0x03,
  0xB0, 0x67, 0x02, 0xB0, 0x54, 0x0D, 0xA0, 0xB7, 0x20, 0xEA, 0x08, 0x30, 0x5B, 0x03, 0x72, 0x0B,
  0xA0, 0xA3, 0x0C, 0xA0, 0xB7, 0x30, 0xAA, 0x0B, 0x20, 0x3B, 0x04, 0x73, 0x0B, 0xA0, 0xB2, 0x09,
  0xA0, 0xE7, 0x40, 0xBA, 0x0A, 0x20, 0xEA, 0x09, 0x74, 0x0D, 0xA8, 0x19, 0x02, 0xB0, 0x57, 0x40,
  0xEA, 0x81, 0x70, 0x6B, 0x01, 0x73, 0x01, 0xB8, 0x15, 0x09, 0xA0, 0xD7, 0x40, 0x4B, 0x81, 0x30,
  0xCA, 0x0A, 0x74, 0x07, 0xB2, 0x0E, 0xA0, 0x87, 0x40, 0xBA, 0x0B, 0x2B, 0x07, 0x74, 0xB8, 0x18,
  0x01, 0xB0, 0x57, 0x30, 0x5B, 0x81, 0x30, 0x2B, 0x05, 0x73, 0x0A, 0xA0, 0xD2, 0x02, 0xB0, 0x57,
  0x20, 0x1B, 0x07, 0x20, 0x1B, 0x06, 0x72, 0x08, 0xA0, 0xE0, 0x13, 0x0E, 0xA0, 0x87, 0x10, 0x20,
  0xEA, 0x08, 0x40, 0xBA, 0x0C, 0x71, 0x0B, 0xA0, 0xE0, 0x14, 0x07, 0xB0, 0x46, 0x0A, 0xB0, 0x55,
  0x01, 0x0E, 0xA0, 0xE0, 0x53, 0x02, 0x0B, 0xB0, 0x97, 0x07, 0xC8, 0x1E, 0xCD, 0xC0, 0xA7, 0x20,
  0x8F, 0xA0, 0x77, 0x48, 0x23, 0x9D, 0xEC, 0x02, 0x77, 0x20, 0x3B, 0x05, 0x77, 0x30, 0xCA, 0x0C,
  0x77, 0x30, 0x6B, 0x04, 0x77, 0x30, 0xEA, 0x0B, 0x77, 0x30, 0x9B, 0x03, 0x77, 0x20, 0x3B, 0x0A,
  0x77, 0x38, 0x00, 0x76,
  // "R" (U+0052)
  0x60, 0x9D, 0x82, 0xEC, 0x82, 0x72, 0x0C, 0xFA, 0x07, 0x71, 0xB0, 0xFC, 0x0E, 0xC0, 0x76, 0x03,
  0xB0, 0x13, 0x05, 0x0E, 0xA0, 0xE0, 0x15, 0x06, 0xA0, 0xD5, 0x05, 0xB0, 0x65, 0x09, 0xA0, 0xA6,
  0x0E, 0xA0, 0x95, 0x0D, 0xA0, 0x76, 0x0C, 0xA0, 0xA5, 0xB0, 0x46, 0x0D, 0xA0, 0x94, 0x03, 0xB0,
  0x16, 0x0E, 0xA0, 0x84, 0x07, 0xA0, 0xD6, 0x02, 0xB0, 0x54, 0x0A, 0xA0, 0xA6, 0x07, 0xB0, 0x14,
  0x0D, 0xA0, 0x76, 0x0E, 0xA0, 0xB4, 0x01, 0xB0, 0x45, 0x0B, 0xB0, 0x34, 0x04, 0xB0, 0x13, 0x03,
  0x0B, 0xB0, 0x95, 0x07, 0xB0, 0xFC, 0x0E, 0xC0, 0xA6, 0x0B, 0xFA, 0x0E, 0x06, 0x70, 0xEF, 0x90,
  0x97, 0x10, 0x1B, 0x03, 0x20, 0x9A, 0x0B, 0x71, 0x05, 0xB3, 0x05, 0xA0, 0xE7, 0x10, 0x8A, 0x0C,
  0x30, 0x2B, 0x03, 0x70, 0xBA, 0x08, 0x40, 0xEA, 0x07, 0x70, 0xEA, 0x05, 0x40, 0xAA, 0x0B, 0x60,
  0x2B, 0x02, 0x40, 0x7B, 0x60, 0x5A, 0x0E, 0x50, 0x3B, 0x03, 0x50, 0x9A, 0x0B, 0x6B, 0x07, 0x50,
  0xCA, 0x08, 0x60, 0xCA, 0x0B, 0x5B, 0x04, 0x60, 0x8B, 0x40, 0x3B, 0x01, 0x60, 0x5B, 0x04, 0x30,
  0x6A, 0x0D, 0x70, 0x1B, 0x07, 0x30,
  // "S" (U+0053)
  0x72, 0x87, 0x5A, 0xDE, 0xED, 0xB7, 0x27, 0x10, 0x40, 0xEF, 0xA0, 0x76, 0x06, 0xC8, 0x1E, 0xCD,
  0xC0, 0x35, 0x03, 0xB0, 0xD0, 0x44, 0x81, 0x6D, 0xA6, 0x0C, 0xA0, 0xD0, 0x17, 0x01, 0x50, 0x3B,
  0x04, 0x77, 0x06, 0xB7, 0x71, 0x08, 0xA0, 0xD7, 0x71, 0x08, 0xA0, 0xE7, 0x71, 0x07, 0xB0, 0x47,
  0x70, 0x4B, 0x0C, 0x77, 0x10, 0xDB, 0x0A, 0x77, 0x04, 0xC0, 0xA7, 0x70, 0x7C, 0x0B, 0x77, 0x08,
  0xC0, 0xC0, 0x17, 0x60, 0x7C, 0x0A, 0x77, 0x06, 0xC0, 0x67, 0x70, 0x7B, 0x0C, 0x77, 0x10, 0xBB,
  0x02, 0x77, 0x05, 0xB0, 0x37, 0x70, 0x2B, 0x05, 0x77, 0x02, 0xB0, 0x47, 0x70, 0x4B, 0x02, 0x77,
  0x0A, 0xA0, 0xD5, 0x01, 0x71, 0x05, 0xB0, 0x74, 0x82, 0x3F, 0x93, 0x40, 0x10, 0x8B, 0x0D, 0x50,
  0x4C, 0x81, 0xDC, 0xDC, 0x0E, 0x02, 0x50, 0x5F, 0xB0, 0xC0, 0x27, 0x82, 0x38, 0xBD, 0xA8, 0x2E,
  0xC9, 0x47, 0x10,
  // "T" (U+0054)
  0x02, 0xFF, 0x0B, 0x06, 0xFF, 0x00, 0x78, 0x01, 0xCB, 0x0D, 0x80, 0x1C, 0x03, 0x50, 0x1B, 0x04,
  0x74, 0x04, 0xB0, 0x17, 0x40, 0x7A, 0x0D, 0x75, 0x0A, 0xA0, 0xA7, 0x50, 0xDA, 0x07, 0x74, 0x01,
  0xB0, 0x37, 0x40, 0x4B, 0x75, 0x07, 0xA0, 0xC7, 0x50, 0xBA, 0x09, 0x75, 0x0E, 0xA0, 0x67, 0x40,
  0x1B, 0x03, 0x74, 0x05, 0xB7, 0x50, 0x8A, 0x0C, 0x75, 0x0B, 0xA0, 0x97, 0x50, 0xEA, 0x05, 0x74,
  0x02, 0xB0, 0x27, 0x40, 0x5A, 0x0E, 0x75, 0x08, 0xA0, 0xB7, 0x50, 0xBA, 0x08, 0x75, 0x0E, 0xA0,
  0x57, 0x40, 0x2B, 0x02, 0x74, 0x06, 0xA0, 0xE7, 0x50, 0x9A, 0x0B, 0x75, 0x0C, 0xA0, 0x87, 0x5B,
  0x04, 0x74, 0x03, 0xB0, 0x17, 0x40,
  // "U" (U+0055)
  0x50, 0xCA, 0x08, 0x71, 0x03, 0xB0, 0x15, 0xB0, 0x57, 0x10, 0x6A, 0x0D, 0x50, 0x3B, 0x01, 0x71,
  0x0A, 0xA0, 0xA5, 0x06, 0xA0, 0xD7, 0x20, 0xDA, 0x07, 0x50, 0xAA, 0x0A, 0x71, 0x01, 0xB0, 0x35,
  0x0D, 0xA0, 0x77, 0x10, 0x4B, 0x50, 0x1B, 0x04, 0x71, 0x07, 0xA0, 0xC5, 0x04, 0xB7, 0x20, 0xBA,
  0x09, 0x50, 0x7A, 0x0D, 0x72, 0x0E, 0xA0, 0x55, 0x0B, 0xA0, 0x97, 0x10, 0x2B, 0x02, 0x50, 0xEA,
  0x06, 0x71, 0x05, 0xA0, 0xE5, 0x02, 0xB0, 0x37, 0x10, 0x8A, 0x0B, 0x50, 0x5B, 0x72, 0x0C, 0xA0,
  0x85, 0x08, 0xA0, 0xC7, 0x20, 0xEA, 0x04, 0x50, 0xCA, 0x08, 0x71, 0x03, 0xB0, 0x15, 0xB0, 0x57,
  0x10, 0x6A, 0x0D, 0x50, 0x3B, 0x02, 0x71, 0x09, 0xA0, 0xA5, 0x06, 0xA0, 0xE7, 0x20, 0xCA, 0x07,
  0x50, 0x9A, 0x0B, 0x72, 0xB0, 0x35, 0x0C, 0xA0, 0x87, 0x10, 0x4B, 0x6B, 0x05, 0x71, 0x08, 0xA0,
  0xB5, 0x01, 0xB0, 0x37, 0x10, 0xCA, 0x07, 0x50, 0x1B, 0x03, 0x70, 0x3B, 0x02, 0x6B, 0x05, 0x70,
  0xAA, 0x0A, 0x70, 0xDA, 0x0A, 0x60, 0x5B, 0x03, 0x70, 0x8B, 0x08, 0x40, 0x7B, 0x09, 0x71, 0x01,
  0x0E, 0xC0, 0xD0, 0xCC, 0x0B, 0x73, 0x03, 0x0E, 0xF9, 0x09, 0x75, 0x87, 0x17, 0xCE, 0xFE, 0xC9,
  0x37, 0x30,
  // "V" (U+0056)
  0x07, 0xA0, 0xD7, 0x30, 0x7B, 0x01, 0x06, 0xA0, 0xE7, 0x30, 0xDA, 0x81, 0x90, 0x6A, 0x0E, 0x72,
  0x05, 0xB8, 0x12, 0x05, 0xA0, 0xE7, 0x20, 0xBA, 0x0B, 0x20, 0x5B, 0x71, 0x02, 0xB0, 0x42, 0x04,
  0xB7, 0x10, 0x9A, 0x0C, 0x30, 0x3B, 0x70, 0x1B, 0x06, 0x30, 0x3B, 0x70, 0x7A, 0x0E, 0x40, 0x2B,
  0x01, 0x60, 0xEA, 0x07, 0x40, 0x2B, 0x01, 0x50, 0x5A, 0x0E, 0x01, 0x40, 0x1B, 0x01, 0x50, 0xCA,
  0x09, 0x50, 0x1B, 0x02, 0x40, 0x3B, 0x02, 0x6B, 0x02, 0x40, 0xAA, 0x0A, 0x7B, 0x02, 0x30, 0x1B,
  0x03, 0x70, 0xEA, 0x03, 0x30, 0x8A, 0x0C, 0x71, 0x0E, 0xA0, 0x33, 0x0E, 0xA0, 0x57, 0x10, 0xDA,
  0x03, 0x20, 0x6A, 0x0D, 0x72, 0x0D, 0xA0, 0x42, 0x0C, 0xA0, 0x67, 0x20, 0xCA, 0x81, 0x40, 0x4A,
  0x0E, 0x73, 0x0C, 0xA8, 0x14, 0x0A, 0xA0, 0x87, 0x30, 0xBA, 0x04, 0x01, 0xB0, 0x17, 0x30, 0xBA,
  0x04, 0x08, 0xA0, 0xA7, 0x40, 0xAA, 0x04, 0x0D, 0xA0, 0x37, 0x40, 0x9A, 0x08, 0xA0, 0xB7, 0x50,
  0x9A, 0x0D, 0xA0, 0x47, 0x50, 0x8C, 0x0D, 0x76, 0x08, 0xC0, 0x67, 0x60, 0x7B, 0x0E, 0x77, 0x07,
  0xB0, 0x77, 0x60,
  // "W" (U+0057)
  0x04, 0xA0, 0xE7, 0x20, 0xEA, 0x04, 0x71, 0x0D, 0xA0, 0x90, 0x4A, 0x0E, 0x71, 0x06, 0xB0, 0x47,
  0x03, 0xB0, 0x20, 0x4A, 0x0E, 0x71, 0x0C, 0xB0, 0x47, 0x09, 0xA8, 0x1C, 0x04, 0xA0, 0xE7, 0x03,
  0xC0, 0x46, 0x01, 0x0E, 0xA8, 0x15, 0x04, 0xA0, 0xE7, 0x09, 0xC0, 0x46, 0x06, 0xA0, 0xE2, 0x04,
  0xA0, 0xD6, 0x01, 0x0E, 0xC0, 0x46, 0x0C, 0xA0, 0x82, 0x04, 0xA0, 0xD6, 0x06, 0xA0, 0xCA, 0x03,
  0x50, 0x3B, 0x02, 0x20, 0x4A, 0x0D, 0x68, 0x2C, 0xFE, 0x7A, 0x03, 0x50, 0x9A, 0x0B, 0x30, 0x4A,
  0x0D, 0x50, 0x3A, 0x09, 0x07, 0xA0, 0x35, 0x0E, 0xA0, 0x53, 0x05, 0xA0, 0xD5, 0x0A, 0xA0, 0x30,
  0x7A, 0x03, 0x40, 0x6A, 0x0E, 0x40, 0x5A, 0x0D, 0x40, 0x1A, 0x81, 0xD0, 0x7A, 0x03, 0x40, 0xCA,
  0x08, 0x40, 0x5A, 0x0C, 0x40, 0x7A, 0x81, 0x70, 0x8A, 0x03, 0x30, 0x3B, 0x01, 0x40, 0x5A, 0x0C,
  0x40, 0xDA, 0x81, 0x10, 0x8A, 0x03, 0x30, 0x9A, 0x0B, 0x50, 0x5A, 0x0C, 0x30, 0x4A, 0x0A, 0x20,
  0x8A, 0x02, 0x30, 0xEA, 0x04, 0x50, 0x5A, 0x0C, 0x30, 0xAA, 0x03, 0x20, 0x8A, 0x02, 0x20, 0x5A,
  0x0D, 0x60, 0x5A, 0x0C, 0x20, 0x1A, 0x0C, 0x30, 0x9A, 0x02, 0x20, 0xCA, 0x07, 0x60, 0x5A, 0x0C,
  0x20, 0x7A, 0x06, 0x30, 0x9A, 0x81, 0x20, 0x2B, 0x01, 0x60, 0x5A, 0x0B, 0x28, 0x1D, 0xFE, 0x40,
  0x9A, 0x81, 0x20, 0x8A, 0x0A, 0x70, 0x5A, 0x81, 0xB0, 0x4A, 0x09, 0x40, 0x9A, 0x81, 0x20, 0xEA,
  0x04, 0x70, 0x5A, 0x81, 0xB0, 0xAA, 0x03, 0x40, 0x9A, 0x02, 0x05, 0xA0, 0xD7, 0x10, 0x5A, 0x0A,
  0x01, 0xA0, 0xC5, 0x0A, 0xA0, 0x10, 0xAA, 0x07, 0x71, 0x05, 0xA0, 0xA0, 0x7A, 0x06, 0x50, 0xAA,
  0x02, 0xB0, 0x17, 0x10, 0x5A, 0x82, 0x9C, 0xFE, 0x60, 0xAA, 0x06, 0xA0, 0x97, 0x20, 0x5A, 0x0B,
  0xA0, 0x96, 0x0A, 0xA0, 0xBA, 0x03, 0x72, 0x06, 0xD0, 0x26, 0x0B, 0xC0, 0xC7, 0x30, 0x6C, 0x0C,
  0x70, 0xBC, 0x06, 0x73, 0x06, 0xC0, 0x57, 0x0B, 0xB0, 0xE7, 0x40, 0x6B, 0x0E, 0x71, 0x0B, 0xB0,
  0x97, 0x40, 0x6B, 0x08, 0x71, 0x0B, 0xB0, 0x37, 0x40,
  // "X" (U+0058)
  0x70, 0x8A, 0x0D, 0x70, 0x2B, 0x05, 0x70, 0x5B, 0x70, 0xBA, 0x0B, 0x71, 0x01, 0xB0, 0x35, 0x05,
  0xB0, 0x27, 0x20, 0xEA, 0x06, 0x50, 0xDA, 0x08, 0x73, 0x0B, 0xA0, 0x94, 0x07, 0xA0, 0xD7, 0x40,
  0x7A, 0x0B, 0x30, 0x10, 0xEA, 0x04, 0x74, 0x04, 0xA0, 0xE3, 0x0A, 0xA0, 0xA7, 0x50, 0x1B, 0x81,
  0x20, 0x3A, 0x0E, 0x02, 0x76, 0x0D, 0xA8, 0x14, 0x0C, 0xA0, 0x77, 0x70, 0xAA, 0x07, 0x06, 0xA0,
  0xD7, 0x71, 0x07, 0xA0, 0xB0, 0xEA, 0x04, 0x77, 0x10, 0x3D, 0x09, 0x77, 0x3C, 0x0E, 0x01, 0x77,
  0x30, 0xDB, 0x06, 0x77, 0x30, 0x3C, 0x01, 0x77, 0x30, 0xCC, 0x04, 0x77, 0x20, 0x6D, 0x07, 0x77,
  0x10, 0x10, 0xEA, 0x0B, 0xA0, 0xA7, 0x71, 0x0A, 0xA0, 0xA0, 0x4A, 0x0D, 0x77, 0x05, 0xA8, 0x1E,
  0x11, 0xB0, 0x17, 0x60, 0xDA, 0x07, 0x20, 0xEA, 0x04, 0x75, 0x09, 0xA0, 0xC3, 0x0C, 0xA0, 0x77,
  0x40, 0x3B, 0x03, 0x30, 0x9A, 0x0A, 0x74, 0x0C, 0xA0, 0x94, 0x06, 0xA0, 0xD7, 0x30, 0x7A, 0x0E,
  0x01, 0x40, 0x4B, 0x01, 0x71, 0x01, 0x0E, 0xA0, 0x65, 0x01, 0xB0, 0x47, 0x10, 0xBA, 0x0C, 0x70,
  0xEA, 0x07, 0x70, 0x5B, 0x03, 0x70, 0xBA, 0x0A, 0x60, 0x10, 0xEA, 0x09, 0x71, 0x09, 0xA0, 0xD6,
  // "Y" (U+0059)
  0x06, 0xA0, 0xE7, 0x10, 0x4B, 0x00, 0x4B, 0x71, 0x0C, 0xA8, 0x1B, 0x02, 0xB0, 0x26, 0x05, 0xB0,
  0x22, 0xB0, 0x46, 0x0D, 0xA0, 0x93, 0x0D, 0xA0, 0x65, 0x06, 0xA0, 0xE0, 0x13, 0x0A, 0xA0, 0x85,
  0x0D, 0xA0, 0x74, 0x08, 0xA0, 0xA4, 0x07, 0xA0, 0xD5, 0x06, 0xA0, 0xC3, 0x01, 0x0E, 0xA0, 0x55,
  0x04, 0xA0, 0xE3, 0x08, 0xA0, 0xC6, 0x01, 0xB2, 0x01, 0x0E, 0xA0, 0x37, 0x0E, 0xA8, 0x12, 0x09,
  0xA0, 0xA7, 0x10, 0xCA, 0x04, 0x02, 0xB0, 0x27, 0x10, 0xAA, 0x06, 0x0A, 0xA0, 0x87, 0x20, 0x8A,
  0x0B, 0xA0, 0xE7, 0x30, 0x5D, 0x06, 0x73, 0x03, 0xC0, 0xC7, 0x40, 0x1C, 0x04, 0x75, 0x0E, 0xA0,
  0xB7, 0x60, 0xEA, 0x05, 0x75, 0x02, 0xB0, 0x27, 0x50, 0x5A, 0x0E, 0x76, 0x09, 0xA0, 0xB7, 0x60,
  0xCA, 0x08, 0x76, 0xB0, 0x47, 0x50, 0x3B, 0x01, 0x75, 0x06, 0xA0, 0xD7, 0x60, 0x9A, 0x0A, 0x76,
  0x0D, 0xA0, 0x77, 0x6B, 0x04, 0x75,
  // "Z" (U+005A)
  0x60, 0x1F, 0xD0, 0xD6, 0x04, 0xFD, 0x0B, 0x60, 0x68, 0x04, 0xC0, 0xDB, 0x07, 0x77, 0x10, 0xDA,
  0x0E, 0x77, 0x10, 0x7B, 0x05, 0x77, 0x01, 0x0E, 0xA0, 0xB7, 0x71, 0x0A, 0xB0, 0x27, 0x70, 0x4B,
  0x08, 0x77, 0x10, 0xDA, 0x0D, 0x77, 0x10, 0x7B, 0x04, 0x77, 0x02, 0xB0, 0xA7, 0x71, 0x0B, 0xA0,
  0xE0, 0x27, 0x70, 0x5B, 0x07, 0x77, 0x10, 0xDA, 0x0D, 0x77, 0x10, 0x8B, 0x04, 0x77, 0x02, 0xB0,
  0xA7, 0x71, 0x0B, 0xA0, 0xE0, 0x17, 0x70, 0x5B, 0x06, 0x77, 0x10, 0xDA, 0x0C, 0x77, 0x10, 0x8B,
  0x03, 0x77, 0x02, 0xB0, 0x97, 0x71, 0x0B, 0xA0, 0xE0, 0x17, 0x70, 0x5B, 0x06, 0x77, 0x01, 0x0E,
  0xA0, 0xC7, 0x71, 0x09, 0xB0, 0x27, 0x70, 0x3B, 0x08, 0x77, 0x10, 0xBB, 0x80, 0x5C, 0x09, 0x60,
  0xEF, 0xD0, 0x95, 0x02, 0xFE, 0x06, 0x50,
  // "[" (U+005B)
  0x70, 0x7F, 0x01, 0x70, 0xAE, 0x0E, 0x71, 0x0D, 0xA8, 0x00, 0xC0, 0x87, 0x01, 0xA0, 0xE7, 0x50,
  0x4A, 0x0B, 0x75, 0x08, 0xA0, 0x77, 0x50, 0xBA, 0x04, 0x75, 0x0E, 0xA0, 0x17, 0x40, 0x2A, 0x0D,
  0x75, 0x05, 0xA0, 0xA7, 0x50, 0x8A, 0x07, 0x75, 0x0C, 0xA0, 0x37, 0x5B, 0x75, 0x03, 0xA0, 0xC7,
  0x50, 0x6A, 0x09, 0x75, 0x09, 0xA0, 0x67, 0x50, 0xCA, 0x02, 0x75, 0xA0, 0xE7, 0x50, 0x3A, 0x0B,
  0x75, 0x07, 0xA0, 0x87, 0x50, 0xAA, 0x05, 0x75, 0x0D, 0xA0, 0x27, 0x40, 0x1A, 0x0E, 0x75, 0x04,
  0xA0, 0xB7, 0x50, 0x7A, 0x07, 0x75, 0x0B, 0xA0, 0x47, 0x50, 0xEA, 0x01, 0x74, 0x02, 0xA0, 0xD7,
  0x50, 0x5A, 0x0A, 0x75, 0x08, 0xA0, 0x77, 0x50, 0xBA, 0x03, 0x75, 0x0E, 0xA7, 0x50, 0x2A, 0x0C,
  0x75, 0x06, 0xF0, 0x37, 0x09, 0xF7, 0x10, 0x98, 0x02, 0xC0, 0xA7, 0x10,
  // "\" (U+005C)
  0x0C, 0xA0, 0x23, 0x0A, 0xA0, 0x43, 0x08, 0xA0, 0x63, 0x06, 0xA0, 0x83, 0x04, 0xA0, 0xA3, 0x02,
  0xA0, 0xC4, 0xA0, 0xE4, 0x0E, 0xA4, 0x0C, 0xA0, 0x23, 0x0A, 0xA0, 0x53, 0x08, 0xA0, 0x73, 0x06,
  0xA0, 0x93, 0x04, 0xA0, 0xB3, 0x02, 0xA0, 0xD4, 0xB4, 0x0D, 0xA0, 0x13, 0x0B, 0xA0, 0x33, 0x09,
  0xA0, 0x53, 0x07, 0xA0, 0x73, 0x05, 0xA0, 0x93, 0x03, 0xA0, 0xB3, 0x01, 0xA0, 0xD4, 0x0E, 0xA4,
  0x0D, 0xA0, 0x23, 0x0B, 0xA0, 0x43, 0x09, 0xA0, 0x63, 0x07, 0xA0, 0x83, 0x05, 0xA0, 0xA3, 0x03,
  0xA0, 0xC0,
  // "]" (U+005D)
  0x70, 0x5F, 0x03, 0x70, 0x8F, 0x71, 0x83, 0x9C, 0xCC, 0xDA, 0x0C, 0x75, 0x06, 0xA0, 0x97, 0x50,
  0x9A, 0x06, 0x75, 0x0C, 0xA0, 0x37, 0x5B, 0x75, 0x03, 0xA0, 0xC7, 0x50, 0x6A, 0x08, 0x75, 0x09,
  0xA0, 0x57, 0x50, 0xDA, 0x02, 0x74, 0x01, 0xA0, 0xE7, 0x50, 0x4A, 0x0B, 0x75, 0x07, 0xA0, 0x87,
  0x50, 0xAA, 0x04, 0x75, 0x0D, 0xA0, 0x17, 0x40, 0x1A, 0x0D, 0x75, 0x04, 0xA0, 0xA7, 0x50, 0x8A,
  0x07, 0x75, 0x0B, 0xA0, 0x47, 0x50, 0xEA, 0x75, 0x02, 0xA0, 0xD7, 0x50, 0x5A, 0x09, 0x75, 0x08,
  0xA0, 0x67, 0x50, 0xCA, 0x03, 0x75, 0xB7, 0x50, 0x3A, 0x0C, 0x75, 0x06, 0xA0, 0x97, 0x50, 0x9A,
  0x05, 0x75, 0x0C, 0xA0, 0x27, 0x5A, 0x0E, 0x75, 0x03, 0xA0, 0xB7, 0x50, 0x7A, 0x08, 0x70, 0x4F,
  0x05, 0x70, 0x7F, 0x01, 0x70, 0x78, 0x02, 0xC0, 0xB7, 0x10,
  // "^" (U+005E)
  0x71, 0x81, 0x27, 0x77, 0x70, 0xCA, 0x02, 0x75, 0x05, 0xB0, 0x87, 0x50, 0xDB, 0x0D, 0x74, 0x06,
  0xD0, 0x37, 0x38, 0x2E, 0xFE, 0x8A, 0x08, 0x72, 0x07, 0xA0, 0x60, 0x1A, 0x0D, 0x71, 0x82, 0x1E,
  0xFD, 0x20, 0xBA, 0x03, 0x70, 0x9A, 0x05, 0x20, 0x6A, 0x08, 0x60, 0x2A, 0x0C, 0x30, 0x1A, 0x0E,
  0x60, 0xAA, 0x04, 0x40, 0xBA, 0x04, 0x40, 0x3A, 0x0C, 0x50, 0x5A, 0x09, 0x40, 0xCA, 0x03, 0x68,
  0x1E, 0xFE, 0x30, 0x5A, 0x0B, 0x70, 0xAA, 0x04, 0x20, 0xDA, 0x02, 0x70, 0x4A, 0x81, 0x90, 0x6A,
  0x09, 0x72, 0x83, 0xEF, 0xE0, 0xEA, 0x02, 0x72, 0x09, 0xA0, 0x40,
  // "_" (U+005F)
  0x01, 0x80, 0x91, 0xC0, 0x10, 0x4F, 0xE1, 0x06, 0xFD, 0x0C, 0x10,
  // "`" (U+0060)
  0x66, 0x63, 0x00, 0xDF, 0xFB, 0x00, 0x6F, 0xFF, 0x10, 0x0C, 0xFF, 0x50, 0x03, 0xFF, 0xB0, 0x00,
  0x8F, 0xF2, 0x00, 0x0C, 0xF8,
  // "a" (U+0061)
  0x68, 0x42, 0x9D, 0xEC, 0x62, 0x06, 0xA0, 0x45, 0x06, 0xE8, 0x18, 0x0B, 0xA0, 0x14, 0x06, 0xC0,
  0xC0, 0xEA, 0x03, 0xA0, 0xD4, 0x03, 0xB0, 0xC0, 0x22, 0x81, 0x7F, 0xDA, 0x0A, 0x40, 0xDA, 0x0D,
  0x50, 0xCB, 0x07, 0x30, 0x6B, 0x03, 0x50, 0x8B, 0x04, 0x30, 0xDA, 0x0A, 0x60, 0x7B, 0x01, 0x20,
  0x3B, 0x03, 0x60, 0x8A, 0x0D, 0x30, 0x8A, 0x0C, 0x70, 0x9A, 0x09, 0x30, 0xDA, 0x07, 0x70, 0xCA,
  0x06, 0x20, 0x1B, 0x03, 0x7B, 0x03, 0x20, 0x4B, 0x70, 0x3B, 0x30, 0x7A, 0x0D, 0x70, 0x7A, 0x0C,
  0x30, 0x9A, 0x0B, 0x70, 0xCA, 0x09, 0x30, 0xAA, 0x0A, 0x60, 0x3B, 0x06, 0x30, 0xAA, 0x09, 0x60,
  0xAB, 0x02, 0x30, 0xAA, 0x0A, 0x50, 0x3C, 0x40, 0x8A, 0x0D, 0x40, 0x10, 0xDB, 0x0C, 0x40, 0x5B,
  0x06, 0x28, 0x22, 0xCF, 0xCA, 0x08, 0x50, 0xEB, 0x00, 0xDA, 0x00, 0x8A, 0x05, 0x50, 0x5E, 0x81,
  0x80, 0x9A, 0x02, 0x68, 0x44, 0xBE, 0xEB, 0x32, 0x81, 0xBF, 0xE5,
  // "b" (U+0062)
  0x60, 0x5A, 0x0D, 0x77, 0x08, 0xA0, 0x97, 0x70, 0xCA, 0x06, 0x77, 0xB0, 0x27, 0x60, 0x3A, 0x0E,
  0x77, 0x06, 0xA0, 0xB7, 0x70, 0x9A, 0x08, 0x77, 0x0D, 0xA0, 0x47, 0x60, 0x1B, 0x86, 0x10, 0x6C,
  0xFE, 0xA2, 0x60, 0x4A, 0x81, 0xC0, 0xAD, 0x0E, 0x02, 0x50, 0x7A, 0x08, 0x0B, 0xA0, 0xD0, 0xEB,
  0x0A, 0x50, 0xBA, 0x82, 0xCF, 0xA1, 0x20, 0xAB, 0x01, 0x40, 0xEB, 0x0A, 0x40, 0x2B, 0x04, 0x30,
  0x2B, 0x0E, 0x01, 0x50, 0xEA, 0x06, 0x30, 0x5B, 0x06, 0x60, 0xDA, 0x06, 0x30, 0x8A, 0x0E, 0x70,
  0xEA, 0x05, 0x30, 0xCA, 0x08, 0x7B, 0x04, 0x3B, 0x02, 0x60, 0x2B, 0x02, 0x20, 0x3A, 0x0D, 0x70,
  0x4B, 0x30, 0x6A, 0x0A, 0x70, 0x8A, 0x0C, 0x30, 0xAA, 0x06, 0x70, 0xCA, 0x09, 0x30, 0xDA, 0x04,
  0x60, 0x1B, 0x04, 0x20, 0x1B, 0x03, 0x60, 0x7A, 0x0E, 0x30, 0x4B, 0x02, 0x60, 0xDA, 0x08, 0x30,
  0x7B, 0x03, 0x50, 0x7B, 0x02, 0x30, 0xBB, 0x07, 0x40, 0x2B, 0x08, 0x40, 0xEB, 0x0E, 0x03, 0x20,
  0x30, 0xDA, 0x0D, 0x01, 0x30, 0x2A, 0x0A, 0x09, 0xA0, 0x0D, 0xB0, 0xE0, 0x34, 0x05, 0xA8, 0x15,
  0x1D, 0xD0, 0xE0, 0x35, 0x81, 0x9F, 0xE2, 0x85, 0x19, 0xDE, 0xC7, 0x16,
  // "c" (U+0063)
  0x68, 0x61, 0x8C, 0xEE, 0xDA, 0x45, 0x05, 0x0E, 0xE0, 0xE4, 0x05, 0xC0, 0xD0, 0xCA, 0x09, 0x30,
  0x3B, 0x0B, 0x02, 0x30, 0x70, 0x33, 0x0D, 0xA0, 0xB7, 0x20, 0x7A, 0x0E, 0x01, 0x72, 0x0E, 0xA0,
  0x77, 0x20, 0x5A, 0x0E, 0x73, 0x0A, 0xA0, 0x97, 0x30, 0xEA, 0x05, 0x72, 0x03, 0xB0, 0x17, 0x20,
  0x5A, 0x0D, 0x73, 0x08, 0xA0, 0xB7, 0x30, 0x9A, 0x09, 0x73, 0x0A, 0xA0, 0x97, 0x30, 0xAA, 0x09,
  0x73, 0x09, 0xA0, 0xB7, 0x30, 0x7A, 0x0E, 0x01, 0x72, 0x02, 0xB0, 0xB0, 0x13, 0x06, 0x08, 0x40,
  0xAC, 0x00, 0xCA, 0x0A, 0x40, 0x10, 0xCF, 0x0A, 0x68, 0x56, 0xCE, 0xFD, 0xA5, 0x40,
  // "d" (U+0064)
  0x77, 0x10, 0x1B, 0x01, 0x77, 0x10, 0x4A, 0x0E, 0x77, 0x20, 0x7A, 0x0A, 0x77, 0x20, 0xBA, 0x07,
  0x77, 0x20, 0xEA, 0x04, 0x77, 0x10, 0x2B, 0x77, 0x20, 0x5A, 0x0D, 0x77, 0x20, 0x9A, 0x09, 0x71,
  0x84, 0x3A, 0xEE, 0xC6, 0x20, 0xCA, 0x06, 0x70, 0x6E, 0x08, 0x1B, 0x03, 0x60, 0x7C, 0x0D, 0x0E,
  0xA0, 0x5A, 0x0E, 0x60, 0x4B, 0x0B, 0x01, 0x28, 0x16, 0xFE, 0xA0, 0xB6, 0x0D, 0xA0, 0xC5, 0x0B,
  0xB0, 0x85, 0x06, 0xB0, 0x25, 0x08, 0xB0, 0x55, 0x0D, 0xA0, 0x96, 0x07, 0xB0, 0x14, 0x04, 0xB0,
  0x26, 0x07, 0xA0, 0xE5, 0x09, 0xA0, 0xC7, 0x09, 0xA0, 0xA5, 0x0D, 0xA0, 0x87, 0x0C, 0xA0, 0x74,
  0x02, 0xB0, 0x47, 0xB0, 0x44, 0x05, 0xB7, 0x04, 0xB5, 0x07, 0xA0, 0xD7, 0x08, 0xA0, 0xC5, 0x09,
  0xA0, 0xA7, 0x0D, 0xA0, 0x95, 0x0B, 0xA0, 0x96, 0x04, 0xB0, 0x65, 0x0B, 0xA0, 0x86, 0x0B, 0xB0,
  0x25, 0x0B, 0xA0, 0xA5, 0x05, 0xB0, 0xE6, 0x09, 0xA0, 0xD4, 0x02, 0x0E, 0xB0, 0xB6, 0x06, 0xB0,
  0x62, 0x82, 0x3D, 0xFC, 0xA0, 0x86, 0x01, 0x0E, 0xB0, 0x0D, 0xA0, 0x60, 0x9A, 0x05, 0x70, 0x6E,
  0x81, 0x60, 0xAA, 0x01, 0x71, 0x84, 0x5C, 0xEE, 0xA3, 0x28, 0x1B, 0xFE, 0x70,
  // "e" (U+0065)
  0x68, 0x51, 0x8C, 0xEF, 0xC7, 0x70, 0x50, 0xEE, 0x0C, 0x50, 0x6B, 0x81, 0xEC, 0xEB, 0x07, 0x30,
  0x3B, 0x09, 0x30, 0xAA, 0x0B, 0x20, 0x10, 0xEA, 0x08, 0x40, 0x4A, 0x0C, 0x20, 0x7A, 0x0C, 0x50,
  0x5A, 0x82, 0xB0, 0x1E, 0xA0, 0x35, 0x0A, 0xA8, 0x18, 0x06, 0xA0, 0xB5, 0x07, 0xB8, 0x12, 0x0B,
  0xA0, 0x62, 0x81, 0x15, 0xCB, 0x81, 0x70, 0x1B, 0x81, 0xDC, 0xED, 0x08, 0x20, 0x4F, 0xA0, 0xC0,
  0x43, 0x07, 0xC8, 0x3E, 0xDB, 0x83, 0x50, 0x9A, 0x0A, 0x74, 0x0A, 0xA0, 0x97, 0x40, 0xBA, 0x07,
  0x74, 0x0B, 0xA0, 0x87, 0x40, 0xAA, 0x0B, 0x74, 0x07, 0xB0, 0x17, 0x30, 0x2B, 0x0C, 0x02, 0x38,
  0x12, 0x7B, 0x40, 0x9C, 0x81, 0xDC, 0xDA, 0x0D, 0x50, 0xBF, 0x90, 0xB6, 0x86, 0x5B, 0xEF, 0xEC,
  0x93, 0x40,
  // "f" (U+0066)
  0x77, 0x84, 0x49, 0xBB, 0x94, 0x76, 0x0A, 0xD0, 0xB7, 0x50, 0x7E, 0x05, 0x75, 0x0E, 0xA8, 0x29,
  0x11, 0x57, 0x50, 0x6A, 0x0D, 0x77, 0x20, 0xBA, 0x07, 0x77, 0x2B, 0x02, 0x77, 0x10, 0x3A, 0x0E,
  0x77, 0x20, 0x7A, 0x0B, 0x77, 0x20, 0xAA, 0x08, 0x76, 0x81, 0x16, 0xCE, 0x0B, 0x73, 0x0C, 0xF9,
  0x08, 0x73, 0x81, 0xBC, 0xDB, 0x0F, 0xC0, 0x47, 0x50, 0x7A, 0x0B, 0x77, 0x20, 0xAA, 0x08, 0x77,
  0x20, 0xDA, 0x05, 0x77, 0x10, 0x1B, 0x01, 0x77, 0x10, 0x5A, 0x0D, 0x77, 0x20, 0x8A, 0x0A, 0x77,
  0x20, 0xBA, 0x07, 0x77, 0x20, 0xEA, 0x03, 0x77, 0x10, 0x3B, 0x77, 0x20, 0x6A, 0x0C, 0x77, 0x20,
  0x9A, 0x09, 0x77, 0x20, 0xDA, 0x06, 0x77, 0x2B, 0x02, 0x77, 0x10, 0x4A, 0x0E, 0x77, 0x20, 0x7A,
  0x0B, 0x77, 0x20, 0xAA, 0x08, 0x77, 0x20, 0xEA, 0x04, 0x77, 0x10, 0x2B, 0x01, 0x77, 0x10, 0x5A,
  0x0D, 0x77, 0x20, 0x8A, 0x0A, 0x77, 0x20, 0xCA, 0x06, 0x77, 0x2B, 0x03, 0x77, 0x10, 0x4A, 0x0E,
  0x77, 0x20, 0xAA, 0x09, 0x77, 0x10, 0x4B, 0x03, 0x75, 0x81, 0xCD, 0xDB, 0x0B, 0x76, 0x0C, 0xC0,
  0xD0, 0x17, 0x68, 0x49, 0xEF, 0xD9, 0x17, 0x70,
  // "g" (U+0067)
  0x71, 0x84, 0x29, 0xDF, 0xD7, 0x20, 0x6A, 0x03, 0x70, 0x6E, 0x81, 0x90, 0xAA, 0x70, 0x6C, 0x0D,
  0x0E, 0xA8, 0x23, 0xEF, 0xC6, 0x03, 0xB0, 0xB0, 0x22, 0x81, 0x6F, 0xDA, 0x09, 0x60, 0xDA, 0x0C,
  0x50, 0xCB, 0x06, 0x50, 0x6B, 0x02, 0x50, 0x8B, 0x03, 0x50, 0xDA, 0x09, 0x60, 0x7B, 0x50, 0x4B,
  0x02, 0x60, 0x8A, 0x0C, 0x50, 0x9A, 0x0C, 0x70, 0xAA, 0x08, 0x50, 0xDA, 0x08, 0x70, 0xCA, 0x05,
  0x40, 0x2B, 0x04, 0x7B, 0x02, 0x40, 0x5B, 0x70, 0x4A, 0x0E, 0x50, 0x7A, 0x0D, 0x70, 0x8A, 0x0B,
  0x50, 0x9A, 0x0A, 0x70, 0xEA, 0x07, 0x50, 0xBA, 0x09, 0x60, 0x4B, 0x04, 0x50, 0xBA, 0x08, 0x60,
  0xCB, 0x01, 0x50, 0xBA, 0x0A, 0x50, 0x5B, 0x0D, 0x60, 0x9A, 0x0D, 0x40, 0x20, 0xEB, 0x0A, 0x60,
  0x6B, 0x06, 0x28, 0x23, 0xDF, 0xDA, 0x07, 0x60, 0x10, 0xEB, 0x00, 0xDA, 0x08, 0x0D, 0xA0, 0x37,
  0x06, 0xE0, 0x80, 0x1B, 0x72, 0x86, 0x5C, 0xFE, 0xA3, 0x05, 0xA0, 0xC7, 0x72, 0x08, 0xA0, 0x97,
  0x72, 0x0D, 0xA0, 0x57, 0x71, 0x02, 0xB0, 0x17, 0x71, 0x09, 0xA0, 0xB6, 0x01, 0x71, 0x04, 0xB0,
  0x46, 0x82, 0x4D, 0x61, 0x40, 0x7B, 0x0B, 0x70, 0x4B, 0x81, 0xDC, 0xCC, 0x0D, 0x01, 0x70, 0x3F,
  0xA0, 0xB0, 0x17, 0x28, 0x71, 0x7B, 0xEF, 0xED, 0x94, 0x73,
  // "h" (U+0068)
  0x60, 0x5A, 0x0D, 0x76, 0x08, 0xA0, 0xA7, 0x60, 0xCA, 0x06, 0x76, 0xB0, 0x37, 0x50, 0x3A, 0x0E,
  0x76, 0x06, 0xA0, 0xB7, 0x60, 0x9A, 0x08, 0x76, 0x0D, 0xA0, 0x47, 0x50, 0x1B, 0x86, 0x10, 0x7D,
  0xFE, 0xA2, 0x50, 0x4A, 0x81, 0xC1, 0xCD, 0x0E, 0x02, 0x40, 0x7A, 0x84, 0x8D, 0xFE, 0xCE, 0xB0,
  0xA4, 0x0B, 0xA8, 0x1D, 0xF8, 0x30, 0xBA, 0x0E, 0x40, 0xEB, 0x07, 0x40, 0x5B, 0x30, 0x2B, 0x0B,
  0x50, 0x5A, 0x0E, 0x30, 0x5B, 0x03, 0x50, 0x6A, 0x0C, 0x30, 0x8A, 0x0C, 0x60, 0x9A, 0x09, 0x30,
  0xCA, 0x07, 0x60, 0xCA, 0x06, 0x3B, 0x03, 0x6B, 0x03, 0x20, 0x3A, 0x0E, 0x60, 0x3B, 0x30, 0x6A,
  0x0B, 0x60, 0x6A, 0x0C, 0x30, 0xAA, 0x08, 0x60, 0x9A, 0x09, 0x30, 0xDA, 0x05, 0x60, 0xDA, 0x06,
  0x20, 0x1B, 0x02, 0x6B, 0x02, 0x20, 0x4A, 0x0E, 0x60, 0x4A, 0x0E, 0x30, 0x7A, 0x0B, 0x60, 0x7A,
  0x0B, 0x30, 0xBA, 0x07, 0x60, 0xAA, 0x08, 0x30, 0xEA, 0x04, 0x60, 0xDA, 0x05, 0x20, 0x2B, 0x01,
  0x50, 0x1B, 0x01, 0x20, 0x5A, 0x0D, 0x60, 0x4A, 0x0E, 0x30, 0x9A, 0x0A, 0x60, 0x7A, 0x0A, 0x30,
  // "i" (U+0069)
  0x68, 0x24, 0xDE, 0x56, 0x0E, 0xA0, 0xA5, 0x02, 0xB0, 0x66, 0x81, 0xBE, 0xA8, 0x0D, 0x10, 0x03,
  0xA0, 0xE6, 0x06, 0xA0, 0xB6, 0x0A, 0xA0, 0x86, 0x0D, 0xA0, 0x55, 0x01, 0xB0, 0x25, 0x04, 0xA0,
  0xE6, 0x07, 0xA0, 0xB6, 0x0A, 0xA0, 0x86, 0x0D, 0xA0, 0x45, 0x01, 0xB0, 0x15, 0x04, 0xA0, 0xD6,
  0x07, 0xA0, 0xA6, 0x0B, 0xA0, 0x76, 0x0E, 0xA0, 0x45, 0x02, 0xB0, 0x15, 0x05, 0xA0, 0xD6, 0x08,
  0xA0, 0xA6, 0x0B, 0xA0, 0x66, 0x0E, 0xA0, 0x35, 0x02, 0xB6, 0x05, 0xA0, 0xC6, 0x09, 0xA0, 0x96,
  // "j" (U+006A)
  0x75, 0x82, 0x4D, 0xE5, 0x75, 0x0E, 0xA0, 0xA7, 0x40, 0x2B, 0x06, 0x75, 0x81, 0xBE, 0xA8, 0x09,
  0x87, 0x00, 0x3A, 0x0E, 0x75, 0x06, 0xA0, 0xB7, 0x50, 0xAA, 0x08, 0x75, 0x0D, 0xA0, 0x57, 0x40,
  0x1B, 0x01, 0x74, 0x04, 0xA0, 0xE7, 0x50, 0x7A, 0x0A, 0x75, 0x0B, 0xA0, 0x77, 0x50, 0xEA, 0x04,
  0x74, 0x02, 0xB0, 0x17, 0x40, 0x5A, 0x0D, 0x75, 0x08, 0xA0, 0x97, 0x50, 0xBA, 0x06, 0x75, 0x0E,
  0xA0, 0x37, 0x40, 0x2B, 0x75, 0x06, 0xA0, 0xC7, 0x50, 0x9A, 0x09, 0x75, 0x0C, 0xA0, 0x57, 0x5B,
  0x02, 0x74, 0x03, 0xA0, 0xE7, 0x50, 0x7A, 0x0B, 0x75, 0x0A, 0xA0, 0x87, 0x50, 0xDA, 0x04, 0x74,
  0x01, 0xB0, 0x17, 0x40, 0x4A, 0x0D, 0x75, 0x08, 0xA0, 0x97, 0x50, 0xEA, 0x04, 0x74, 0x08, 0xA0,
  0xE7, 0x18, 0x21, 0xEC, 0xEB, 0x06, 0x71, 0x01, 0xD0, 0xA7, 0x28, 0x41, 0xDF, 0xEC, 0x67, 0x30,
  // "k" (U+006B)
  0x60, 0x4A, 0x0D, 0x77, 0x08, 0xA0, 0xA7, 0x70, 0xBA, 0x06, 0x77, 0x0E, 0xA0, 0x37, 0x60, 0x2B,
  0x77, 0x06, 0xA0, 0xC7, 0x70, 0x9A, 0x08, 0x77, 0x0C, 0xA0, 0x57, 0x7B, 0x01, 0x40, 0x5B, 0x03,
  0x40, 0x4A, 0x0E, 0x40, 0x20, 0xEA, 0x06, 0x50, 0x7A, 0x0A, 0x30, 0x10, 0xDA, 0x0A, 0x60, 0xAA,
  0x07, 0x30, 0xBA, 0x0C, 0x70, 0xEA, 0x03, 0x20, 0x7A, 0x0E, 0x01, 0x60, 0x1B, 0x20, 0x4B, 0x04,
  0x70, 0x5A, 0x82, 0xC0, 0x2E, 0xA0, 0x77, 0x10, 0x8A, 0x81, 0x80, 0xCA, 0x0A, 0x72, 0x0B, 0xA0,
  0x40, 0xAA, 0x0C, 0x73, 0xA0, 0xE0, 0x7B, 0x07, 0x72, 0x03, 0xA0, 0xEC, 0x0B, 0x72, 0x06, 0xC0,
  0xEA, 0x0E, 0x72, 0x09, 0xB0, 0xB0, 0x2B, 0x03, 0x71, 0x0D, 0xA0, 0xB2, 0x0D, 0xA0, 0x77, 0x01,
  0xB0, 0x12, 0x09, 0xA0, 0xB7, 0x04, 0xA0, 0xD3, 0x05, 0xB7, 0x07, 0xA0, 0xA3, 0x01, 0xB0, 0x46,
  0x0B, 0xA0, 0x74, 0x0D, 0xA0, 0x86, 0x0E, 0xA0, 0x44, 0x09, 0xA0, 0xC5, 0x02, 0xB0, 0x14, 0x05,
  0xB5, 0x05, 0xA0, 0xD5, 0x02, 0xB0, 0x44, 0x09, 0xA0, 0xA6, 0x0D, 0xA0, 0x84,
  // "l" (U+006C)
  0x60, 0x4A, 0x0D, 0x60, 0x8A, 0x0A, 0x60, 0xBA, 0x07, 0x60, 0xEA, 0x03, 0x50, 0x2B, 0x60, 0x6A,
  0x0C, 0x60, 0x9A, 0x09, 0x60, 0xCA, 0x05, 0x6B, 0x02, 0x50, 0x4A, 0x0E, 0x60, 0x7A, 0x0B, 0x60,
  0xAA, 0x07, 0x60, 0xEA, 0x04, 0x50, 0x1B, 0x01, 0x50, 0x5A, 0x0D, 0x60, 0x8A, 0x0A, 0x60, 0xBA,
  0x06, 0x6B, 0x03, 0x50, 0x3B, 0x60, 0x6A, 0x0C, 0x60, 0x9A, 0x08, 0x60, 0xDA, 0x05, 0x50, 0x1B,
  0x02, 0x50, 0x4A, 0x0E, 0x60, 0x7A, 0x0A, 0x60, 0xBA, 0x07, 0x60, 0xEA, 0x04, 0x50, 0x2B, 0x60,
  0x5A, 0x0D, 0x60, 0x9A, 0x09, 0x60,
  // "m" (U+006D)
  0x40, 0x3A, 0x87, 0x60, 0x18, 0xDF, 0xD8, 0x13, 0x84, 0x4B, 0xEF, 0xC5, 0x60, 0x6A, 0x81, 0x42,
  0xDD, 0x0B, 0x20, 0x9E, 0x06, 0x50, 0xAA, 0x83, 0x4D, 0xFE, 0xCC, 0x04, 0x09, 0xA0, 0x0D, 0xB0,
  0xE5, 0x0D, 0xA8, 0x1C, 0xF6, 0x20, 0x2B, 0x82, 0xDF, 0xC2, 0x20, 0x8B, 0x02, 0x30, 0x1C, 0x06,
  0x40, 0xBB, 0x0D, 0x01, 0x30, 0x1B, 0x03, 0x30, 0x4B, 0x0B, 0x50, 0xAB, 0x05, 0x40, 0x1B, 0x02,
  0x30, 0x7B, 0x03, 0x50, 0xBA, 0x0C, 0x50, 0x3B, 0x40, 0xAA, 0x0C, 0x60, 0xEA, 0x06, 0x50, 0x5A,
  0x0D, 0x40, 0xDA, 0x07, 0x50, 0x2B, 0x02, 0x50, 0x8A, 0x09, 0x30, 0x1B, 0x03, 0x50, 0x5A, 0x0D,
  0x60, 0xCA, 0x06, 0x30, 0x4A, 0x0E, 0x60, 0x8A, 0x0A, 0x6B, 0x03, 0x30, 0x7A, 0x0B, 0x60, 0xBA,
  0x06, 0x50, 0x3B, 0x40, 0xBA, 0x08, 0x60, 0xEA, 0x03, 0x50, 0x6A, 0x0C, 0x40, 0xEA, 0x05, 0x50,
  0x2B, 0x60, 0x9A, 0x09, 0x30, 0x2B, 0x01, 0x50, 0x5A, 0x0C, 0x60, 0xCA, 0x05, 0x30, 0x5A, 0x0E,
  0x60, 0x9A, 0x09, 0x6B, 0x02, 0x30, 0x8A, 0x0B, 0x60, 0xCA, 0x06, 0x50, 0x3A, 0x0E, 0x40, 0xBA,
  0x07, 0x6B, 0x02, 0x50, 0x7A, 0x0B, 0x40, 0xEA, 0x04, 0x50, 0x3A, 0x0E, 0x60, 0xAA, 0x08, 0x30,
  0x2B, 0x01, 0x50, 0x6A, 0x0B, 0x60, 0xDA, 0x05, 0x30, 0x5A, 0x0D, 0x60, 0x9A, 0x08, 0x50, 0x1B,
  0x01, 0x30, 0x9A, 0x0A, 0x60, 0xDA, 0x05, 0x50, 0x4A, 0x0D, 0x40,
  // "n" (U+006E)
  0x40, 0x4A, 0x07, 0x28, 0x48, 0xDF, 0xEA, 0x25, 0x07, 0xA8, 0x15, 0x2D, 0xD0, 0xE0, 0x34, 0x0A,
  0xA8, 0x45, 0xDF, 0xEC, 0xEB, 0x0B, 0x40, 0xDA, 0x81, 0xDF, 0x93, 0x0B, 0xA0, 0xE3, 0x01, 0xC0,
  0x84, 0x05, 0xB3, 0x04, 0xB0, 0xC5, 0x05, 0xA0, 0xE3, 0x07, 0xB0, 0x45, 0x07, 0xA0, 0xD3, 0x0B,
  0xA0, 0xD6, 0x0A, 0xA0, 0xA3, 0x0E, 0xA0, 0x86, 0x0D, 0xA0, 0x72, 0x01, 0xB0, 0x35, 0x01, 0xB0,
  0x42, 0x05, 0xB6, 0x04, 0xB0, 0x12, 0x08, 0xA0, 0xB6, 0x07, 0xA0, 0xD3, 0x0B, 0xA0, 0x86, 0x0A,
  0xA0, 0x93, 0x0E, 0xA0, 0x56, 0x0E, 0xA0, 0x62, 0x02, 0xB0, 0x25, 0x01, 0xB0, 0x32, 0x05, 0xA0,
  0xE6, 0x05, 0xB3, 0x09, 0xA0, 0xB6, 0x08, 0xA0, 0xC3, 0x0C, 0xA0, 0x76, 0x0B, 0xA0, 0x83, 0xB0,
  0x46, 0x0E, 0xA0, 0x52, 0x03, 0xB0, 0x15, 0x02, 0xB0, 0x22, 0x06, 0xA0, 0xD6, 0x05, 0xA0, 0xE3,
  0x09, 0xA0, 0xA6, 0x09, 0xA0, 0xA3,
  // "o" (U+006F)
  0x68, 0x51, 0x8C, 0xEE, 0xC7, 0x71, 0x06, 0xF0, 0xC0, 0x15, 0x07, 0xB8, 0x1E, 0xCE, 0xB0, 0xB4,
  0x05, 0xB0, 0x83, 0x07, 0xB0, 0x33, 0x0E, 0xA0, 0x95, 0x0D, 0xA0, 0x82, 0x08, 0xA0, 0xD6, 0x08,
  0xA0, 0xB2, 0x0E, 0xA0, 0x66, 0x06, 0xA8, 0x1D, 0x06, 0xA0, 0xE7, 0x06, 0xA8, 0x1D, 0x0A, 0xA0,
  0x97, 0x07, 0xA0, 0xC1, 0xB0, 0x47, 0x09, 0xA0, 0xB0, 0x3B, 0x01, 0x70, 0xBA, 0x08, 0x06, 0xA0,
  0xD7, 0x10, 0xEA, 0x06, 0x08, 0xA0, 0xB7, 0x02, 0xB0, 0x20, 0xAA, 0x09, 0x70, 0x6A, 0x81, 0xD0,
  0xAA, 0x08, 0x70, 0xCA, 0x81, 0x90, 0xAA, 0x08, 0x60, 0x3B, 0x81, 0x20, 0x9A, 0x0A, 0x60, 0xBA,
  0x0B, 0x20, 0x6A, 0x0E, 0x50, 0x7B, 0x02, 0x20, 0x2B, 0x09, 0x30, 0x7B, 0x07, 0x40, 0x9B, 0x81,
  0xEC, 0xEB, 0x09, 0x60, 0xBF, 0x09, 0x71, 0x85, 0x6B, 0xEF, 0xDA, 0x36,
  // "p" (U+0070)
  0x60, 0x3A, 0x07, 0x28, 0x45, 0xCF, 0xEA, 0x27, 0x10, 0x6A, 0x81, 0x60, 0xAD, 0x0E, 0x02, 0x70,
  0xAA, 0x04, 0x0A, 0xA0, 0xD0, 0xEB, 0x0B, 0x70, 0xDA, 0x82, 0x9F, 0xB1, 0x20, 0xAB, 0x01, 0x50,
  0x1C, 0x0B, 0x40, 0x2B, 0x04, 0x50, 0x4B, 0x0E, 0x01, 0x50, 0xEA, 0x06, 0x50, 0x7B, 0x07, 0x60,
  0xDA, 0x06, 0x50, 0xAA, 0x0E, 0x70, 0xEA, 0x05, 0x50, 0xDA, 0x09, 0x7B, 0x04, 0x40, 0x1B, 0x03,
  0x60, 0x1B, 0x02, 0x40, 0x4A, 0x0E, 0x70, 0x4B, 0x50, 0x8A, 0x0B, 0x70, 0x7A, 0x0C, 0x50, 0xBA,
  0x07, 0x70, 0xBA, 0x09, 0x50, 0xEA, 0x05, 0x60, 0x1B, 0x04, 0x40, 0x2B, 0x03, 0x60, 0x6A, 0x0E,
  0x50, 0x5B, 0x02, 0x60, 0xDA, 0x09, 0x50, 0x8B, 0x03, 0x50, 0x6B, 0x02, 0x50, 0xCB, 0x07, 0x40,
  0x20, 0xEA, 0x09, 0x6C, 0x0E, 0x03, 0x20, 0x30, 0xDA, 0x0D, 0x01, 0x50, 0x3A, 0x0D, 0x08, 0xA0,
  0x0D, 0xC0, 0x36, 0x06, 0xA8, 0x1B, 0x1D, 0xD0, 0xE0, 0x37, 0x09, 0xA8, 0x78, 0x01, 0x9D, 0xEC,
  0x71, 0x71, 0x0C, 0xA0, 0x57, 0x72, 0xB0, 0x27, 0x71, 0x03, 0xA0, 0xE7, 0x72, 0x06, 0xA0, 0xB7,
  0x72, 0x0A, 0xA0, 0x87, 0x72, 0x0D, 0xA0, 0x47, 0x71, 0x01, 0xB0, 0x17, 0x71, 0x04, 0xA0, 0xD7,
  0x72, 0x07, 0xA0, 0xA7, 0x72,
  // "q" (U+0071)
  0x68, 0x43, 0xAD, 0xFD, 0x72, 0x06, 0xA0, 0x35, 0x06, 0xE8, 0x19, 0x0B, 0xA5, 0x07, 0xC0, 0xC0,
  0xEA, 0x04, 0xA0, 0xC4, 0x03, 0xB0, 0xB0, 0x12, 0x81, 0x7F, 0xDA, 0x09, 0x40, 0xDA, 0x0C, 0x50,
  0xCB, 0x06, 0x30, 0x6B, 0x02, 0x50, 0x8B, 0x03, 0x30, 0xDA, 0x09, 0x60, 0x7A, 0x0E, 0x30, 0x3B,
  0x02, 0x60, 0x8A, 0x0B, 0x30, 0x8A, 0x0C, 0x70, 0xAA, 0x08, 0x30, 0xDA, 0x07, 0x70, 0xCA, 0x05,
  0x20, 0x1B, 0x03, 0x7B, 0x02, 0x20, 0x5B, 0x70, 0x3A, 0x0E, 0x30, 0x7A, 0x0C, 0x70, 0x8A, 0x0B,
  0x30, 0x9A, 0x0A, 0x70, 0xDA, 0x07, 0x30, 0xBA, 0x09, 0x60, 0x4B, 0x04, 0x30, 0xBA, 0x09, 0x60,
  0xCB, 0x01, 0x30, 0xBA, 0x0A, 0x50, 0x5B, 0x0D, 0x40, 0x9A, 0x0D, 0x40, 0x20, 0xEB, 0x0A, 0x40,
  0x6B, 0x06, 0x28, 0x23, 0xDF, 0xDA, 0x06, 0x40, 0x1C, 0x00, 0xDA, 0x08, 0x0D, 0xA0, 0x35, 0x06,
  0xE0, 0x70, 0x1B, 0x78, 0x65, 0xCF, 0xEA, 0x30, 0x5A, 0x0C, 0x77, 0x09, 0xA0, 0x97, 0x70, 0xCA,
  0x05, 0x77, 0xB0, 0x27, 0x60, 0x3A, 0x0E, 0x77, 0x07, 0xA0, 0xB7, 0x70, 0xAA, 0x08, 0x77, 0x0D,
  0xA0, 0x57, 0x60, 0x1B, 0x01, 0x76, 0x04, 0xA0, 0xE7,
  // "r" (U+0072)
  0x40, 0x3A, 0x83, 0x50, 0x19, 0xEA, 0x40, 0x6A, 0x81, 0x32, 0xEB, 0x0B, 0x40, 0xAA, 0x85, 0x2E,
  0xFE, 0xCE, 0x74, 0x0D, 0xA8, 0x1A, 0xF8, 0x70, 0x1C, 0x08, 0x71, 0x04, 0xB0, 0xC7, 0x20, 0x7B,
  0x04, 0x72, 0x0A, 0xA0, 0xC7, 0x30, 0xDA, 0x07, 0x72, 0x01, 0xB0, 0x27, 0x20, 0x4A, 0x0E, 0x73,
  0x07, 0xA0, 0xB7, 0x30, 0xBA, 0x07, 0x73, 0x0E, 0xA0, 0x47, 0x20, 0x2B, 0x01, 0x72, 0x05, 0xA0,
  0xD7, 0x30, 0x8A, 0x0A, 0x73, 0x0B, 0xA0, 0x77, 0x30, 0xEA, 0x04, 0x72, 0x02, 0xB0, 0x17, 0x20,
  0x5A, 0x0D, 0x73, 0x09, 0xA0, 0xA7, 0x30,
  // "s" (U+0073)
  0x68, 0x64, 0xAD, 0xFE, 0xDA, 0x56, 0x09, 0xF9, 0x0D, 0x40, 0x8C, 0x00, 0xDB, 0x0A, 0x30, 0x2B,
  0x0A, 0x01, 0x38, 0x16, 0xE2, 0x30, 0x7A, 0x0D, 0x74, 0x09, 0xA0, 0xA7, 0x40, 0x9A, 0x0B, 0x74,
  0x06, 0xB0, 0x17, 0x30, 0x1B, 0x0C, 0x01, 0x73, 0x07, 0xB0, 0xD0, 0x27, 0x30, 0x9B, 0x0E, 0x02,
  0x73, 0x09, 0xB0, 0xE0, 0x27, 0x30, 0x7B, 0x0C, 0x74, 0x08, 0xB0, 0x47, 0x40, 0xEA, 0x07, 0x74,
  0x0B, 0xA0, 0x87, 0x40, 0xCA, 0x07, 0x73, 0x02, 0xB0, 0x52, 0x82, 0x3C, 0x51, 0x30, 0x40, 0xDA,
  0x0E, 0x30, 0x3B, 0x81, 0xDC, 0xEC, 0x05, 0x30, 0x3F, 0xA0, 0x65, 0x87, 0x39, 0xCE, 0xFE, 0xC8,
  0x25,
  // "t" (U+0074)
  0x50, 0x3A, 0x71, 0x81, 0x9F, 0xD7, 0x18, 0x1E, 0xF9, 0x70, 0x6A, 0x06, 0x70, 0xCA, 0x03, 0x48,
  0x11, 0x7D, 0xE8, 0x1B, 0x0B, 0xF9, 0x83, 0x80, 0xBC, 0xEA, 0x83, 0xDC, 0xCC, 0x43, 0x0C, 0xA0,
  0x67, 0xB0, 0x36, 0x03, 0xB7, 0x06, 0xA0, 0xC7, 0x0A, 0xA0, 0x87, 0x0D, 0xA0, 0x56, 0x01, 0xB0,
  0x26, 0x04, 0xA0, 0xE7, 0x07, 0xA0, 0xB7, 0x0A, 0xA0, 0x87, 0x0E, 0xA0, 0x46, 0x01, 0xB0, 0x16,
  0x05, 0xA0, 0xD7, 0x07, 0xA0, 0xA7, 0x09, 0xA0, 0x97, 0x09, 0xA0, 0xB7, 0x06, 0xB8, 0x2D, 0xCF,
  0x13, 0x01, 0x0E, 0xD0, 0x14, 0x84, 0x2B, 0xEE, 0xC9, 0x40,
  // "u" (U+0075)
  0x30, 0x5A, 0x0D, 0x60, 0x4A, 0x0E, 0x30, 0x8A, 0x0A, 0x60, 0x7A, 0x0B, 0x30, 0xBA, 0x07, 0x60,
  0xAA, 0x08, 0x30, 0xEA, 0x04, 0x60, 0xEA, 0x04, 0x20, 0x3B, 0x60, 0x1B, 0x01, 0x20, 0x6A, 0x0C,
  0x60, 0x5A, 0x0E, 0x30, 0x9A, 0x09, 0x60, 0x8A, 0x0A, 0x30, 0xCA, 0x06, 0x60, 0xBA, 0x07, 0x3B,
  0x03, 0x60, 0xEA, 0x04, 0x20, 0x3B, 0x60, 0x2B, 0x01, 0x20, 0x7A, 0x0C, 0x60, 0x6A, 0x0D, 0x30,
  0xAA, 0x08, 0x60, 0x9A, 0x0A, 0x30, 0xDA, 0x05, 0x60, 0xDA, 0x07, 0x20, 0x1B, 0x02, 0x50, 0x2B,
  0x03, 0x20, 0x4A, 0x0E, 0x60, 0x7B, 0x30, 0x7A, 0x0C, 0x60, 0xEA, 0x0C, 0x30, 0x8A, 0x0B, 0x50,
  0x8B, 0x09, 0x30, 0x9A, 0x0B, 0x40, 0x4C, 0x06, 0x30, 0x8B, 0x03, 0x28, 0x26, 0xFE, 0xEA, 0x03,
  0x30, 0x4C, 0x0D, 0x0E, 0xA0, 0x40, 0xDA, 0x50, 0xBE, 0x04, 0x1A, 0x0C, 0x68, 0x68, 0xDF, 0xD9,
  0x20, 0x1A, 0x09, 0x40,
  // "v" (U+0076)
  0x0B, 0xA0, 0x77, 0x09, 0xA0, 0xB0, 0xAA, 0x07, 0x60, 0x10, 0xEA, 0x04, 0x0A, 0xA0, 0x76, 0x07,
  0xA8, 0x1D, 0x09, 0xA0, 0x86, 0x0E, 0xA8, 0x16, 0x08, 0xA0, 0x85, 0x06, 0xA0, 0xE2, 0x08, 0xA0,
  0x95, 0x0D, 0xA0, 0x72, 0x07, 0xA0, 0x94, 0x04, 0xA0, 0xE0, 0x12, 0x06, 0xA0, 0x94, 0x0B, 0xA0,
  0x83, 0x06, 0xA0, 0xA3, 0x03, 0xB0, 0x23, 0x05, 0xA0, 0xA3, 0x0A, 0xA0, 0xA4, 0x04, 0xA0, 0xB2,
  0x02, 0xB0, 0x34, 0x04, 0xA0, 0xB2, 0x08, 0xA0, 0xB5, 0x03, 0xA8, 0x2C, 0x01, 0xEA, 0x04, 0x50,
  0x2A, 0x81, 0xC0, 0x7A, 0x0C, 0x60, 0x2A, 0x81, 0xC0, 0xDA, 0x05, 0x60, 0x1A, 0x0C, 0x05, 0xA0,
  0xD7, 0x1A, 0x00, 0xBA, 0x07, 0x71, 0xA0, 0xDA, 0x0E, 0x72, 0x0E, 0xC0, 0x87, 0x20, 0xEC, 0x01,
  0x72, 0x0D, 0xB0, 0x97, 0x30, 0xCB, 0x02, 0x72,
  // "w" (U+0077)
  0x08, 0xA0, 0x96, 0x0E, 0xA0, 0xC6, 0x0C, 0xA0, 0x70, 0x8A, 0x08, 0x50, 0x6B, 0x0C, 0x50, 0x2B,
  0x01, 0x08, 0xA0, 0x85, 0x0C, 0xB0, 0xC5, 0x08, 0xA8, 0x1A, 0x08, 0xA0, 0x84, 0x03, 0xC0, 0xC5,
  0x0E, 0xA8, 0x13, 0x08, 0xA0, 0x84, 0x84, 0x9F, 0xED, 0xFB, 0x40, 0x5A, 0x0D, 0x20, 0x8A, 0x08,
  0x48, 0x4E, 0xFA, 0xDF, 0xB4, 0x0B, 0xA0, 0x62, 0x08, 0xA0, 0x73, 0x06, 0xA8, 0x24, 0xDF, 0xB3,
  0x02, 0xA0, 0xE0, 0x12, 0x08, 0xA0, 0x73, 0x85, 0xCF, 0xD0, 0xEF, 0xB3, 0x08, 0xA0, 0x93, 0x08,
  0xA0, 0x72, 0x03, 0xA8, 0x37, 0x0E, 0xFB, 0x30, 0xEA, 0x03, 0x30, 0x8A, 0x07, 0x20, 0x9A, 0x83,
  0x10, 0xEF, 0xB2, 0x05, 0xA0, 0xC4, 0x08, 0xA0, 0x72, 0x81, 0xEF, 0xB2, 0x81, 0xEF, 0xB2, 0x0B,
  0xA0, 0x64, 0x08, 0xA8, 0x16, 0x06, 0xA0, 0x42, 0xA8, 0x1B, 0x01, 0xA0, 0xE5, 0x08, 0xA8, 0x36,
  0x0C, 0xFD, 0x3A, 0x81, 0xB0, 0x7A, 0x08, 0x50, 0x8A, 0x06, 0x03, 0xA0, 0x83, 0xA8, 0x1A, 0x0D,
  0xA0, 0x25, 0x08, 0xA0, 0x50, 0x9A, 0x02, 0x3A, 0x0A, 0x03, 0xA0, 0xB6, 0x08, 0xA8, 0x25, 0xEF,
  0xB4, 0xA0, 0x09, 0xA0, 0x56, 0x08, 0xA0, 0x9A, 0x05, 0x4A, 0x82, 0x9E, 0xFE, 0x70, 0x8A, 0x81,
  0xDF, 0xE5, 0xA0, 0xCA, 0x08, 0x70, 0x8C, 0x08, 0x40, 0x1D, 0x01, 0x70, 0x8C, 0x02, 0x40, 0x1C,
  0x0B, 0x71, 0x08, 0xB0, 0xB5, 0x01, 0xC0, 0x47, 0x10, 0x8B, 0x05, 0x50, 0x1B, 0x0D, 0x72,
  // "x" (U+0078)
  0x50, 0xCA, 0x08, 0x50, 0x2B, 0x07, 0x50, 0x8A, 0x0B, 0x50, 0xBA, 0x0C, 0x60, 0x4A, 0x0E, 0x40,
  0x5B, 0x02, 0x7B, 0x03, 0x20, 0x10, 0xEA, 0x07, 0x71, 0x0B, 0xA0, 0x62, 0x09, 0xA0, 0xC7, 0x20,
  0x7A, 0x81, 0xA0, 0x3B, 0x02, 0x72, 0x03, 0xA8, 0x1D, 0x0C, 0xA0, 0x77, 0x40, 0xEA, 0x09, 0xA0,
  0xB7, 0x50, 0xAC, 0x0E, 0x02, 0x75, 0x06, 0xC0, 0x67, 0x60, 0x3B, 0x0C, 0x77, 0x0B, 0xB0, 0xA7,
  0x60, 0x5C, 0x0E, 0x75, 0x01, 0x0E, 0xA0, 0xEA, 0x03, 0x74, 0x0B, 0xA0, 0x09, 0xA0, 0x77, 0x30,
  0x5A, 0x81, 0xD0, 0x5A, 0x0C, 0x72, 0x01, 0x0E, 0xA8, 0x14, 0x01, 0xB0, 0x17, 0x10, 0xBA, 0x0A,
  0x30, 0xDA, 0x05, 0x70, 0x5A, 0x0E, 0x01, 0x30, 0x9A, 0x09, 0x60, 0x10, 0xEA, 0x06, 0x40, 0x5A,
  0x0D, 0x60, 0xBA, 0x0C, 0x50, 0x2B, 0x02, 0x40, 0x6B, 0x02, 0x60, 0xDA, 0x07, 0x40,
  // "y" (U+0079)
  0x60, 0x9A, 0x09, 0x70, 0x6A, 0x0D, 0x60, 0x8A, 0x0A, 0x70, 0xDA, 0x06, 0x60, 0x7A, 0x0A, 0x60,
  0x5A, 0x0E, 0x70, 0x6A, 0x0B, 0x60, 0xCA, 0x07, 0x70, 0x5A, 0x0B, 0x50, 0x3A, 0x0E, 0x01, 0x70,
  0x4A, 0x0C, 0x50, 0xAA, 0x08, 0x71, 0x03, 0xA0, 0xD4, 0x02, 0xB0, 0x17, 0x10, 0x2A, 0x0D, 0x40,
  0x9A, 0x09, 0x72, 0x01, 0xA0, 0xE3, 0x01, 0xB0, 0x27, 0x3B, 0x30, 0x7A, 0x0A, 0x74, 0xB3, 0x0E,
  0xA0, 0x37, 0x40, 0xEA, 0x20, 0x6A, 0x0B, 0x75, 0x0D, 0xA8, 0x11, 0x0D, 0xA0, 0x37, 0x50, 0xCA,
  0x01, 0x04, 0xA0, 0xC7, 0x60, 0xBA, 0x01, 0x0A, 0xA0, 0x47, 0x60, 0xAA, 0x03, 0xA0, 0xC7, 0x70,
  0x9A, 0x08, 0xA0, 0x57, 0x70, 0x8A, 0x81, 0xEF, 0xD7, 0x71, 0x07, 0xC0, 0x67, 0x71, 0x06, 0xB0,
  0xE7, 0x72, 0x05, 0xB0, 0x77, 0x72, 0x05, 0xA0, 0xE0, 0x17, 0x72, 0x0B, 0xA0, 0x87, 0x72, 0x03,
  0xB0, 0x17, 0x72, 0x0A, 0xA0, 0x97, 0x72, 0x03, 0xB0, 0x27, 0x72, 0x0C, 0xA0, 0x97, 0x72, 0x0A,
  0xA0, 0xE0, 0x17, 0x58, 0x18, 0xDC, 0xC0, 0x47, 0x60, 0xAD, 0x06, 0x77, 0x84, 0x8E, 0xFE, 0xA3,
  0x77, 0x10,
  // "z" (U+007A)
  0x50, 0x4F, 0xA0, 0xE5, 0x07, 0xFA, 0x0B, 0x50, 0x88, 0x02, 0xCB, 0x06, 0x74, 0x08, 0xA0, 0xD7,
  0x40, 0x2B, 0x03, 0x74, 0x0B, 0xA0, 0x97, 0x40, 0x6A, 0x0E, 0x01, 0x73, 0x01, 0x0E, 0xA0, 0x57,
  0x40, 0xAA, 0x0B, 0x74, 0x04, 0xB0, 0x27, 0x40, 0xDA, 0x07, 0x74, 0x08, 0xA0, 0xD7, 0x40, 0x2B,
  0x03, 0x74, 0x0C, 0xA0, 0x97, 0x40, 0x6A, 0x0E, 0x01, 0x73, 0x01, 0x0E, 0xA0, 0x57, 0x40, 0xAA,
  0x0B, 0x74, 0x04, 0xB0, 0x27, 0x40, 0xDA, 0x07, 0x74, 0x08, 0xB8, 0x03, 0xC0, 0x34, 0x0D, 0xFB,
  0x02, 0x30, 0x1F, 0xB0, 0xE4,
  // "{" (U+007B)
  0x74, 0x83, 0x6A, 0xDE, 0x97, 0x20, 0x30, 0xDC, 0x06, 0x71, 0x01, 0x0D, 0xB8, 0x1E, 0xD2, 0x71,
  0x08, 0xA0, 0xE0, 0x67, 0x40, 0xDA, 0x06, 0x74, 0x02, 0xA0, 0xE7, 0x50, 0x6A, 0x0B, 0x75, 0x09,
  0xA0, 0x87, 0x50, 0xCA, 0x04, 0x75, 0xB0, 0x17, 0x40, 0x3A, 0x0D, 0x75, 0x07, 0xA0, 0xA7, 0x50,
  0xAA, 0x06, 0x74, 0x01, 0xB0, 0x17, 0x40, 0xAA, 0x0B, 0x72, 0x81, 0x25, 0xCA, 0x0E, 0x02, 0x71,
  0x0B, 0xC0, 0xC0, 0x37, 0x20, 0xEA, 0x0D, 0x04, 0x73, 0x81, 0x1C, 0xEB, 0x05, 0x75, 0x08, 0xA0,
  0xE0, 0x17, 0x50, 0xDA, 0x05, 0x75, 0x0B, 0xA0, 0x67, 0x50, 0xCA, 0x04, 0x75, 0x0E, 0xA0, 0x17,
  0x40, 0x2A, 0x0E, 0x75, 0x05, 0xA0, 0xA7, 0x50, 0x9A, 0x07, 0x75, 0x0C, 0xA0, 0x47, 0x5B, 0x01,
  0x74, 0x02, 0xA0, 0xE7, 0x50, 0x3B, 0x75, 0x01, 0xB0, 0x87, 0x50, 0xCB, 0x0E, 0x0A, 0x73, 0x03,
  0x0E, 0xB0, 0xB7, 0x48, 0x32, 0x8C, 0xEB, 0x70,
  // "|" (U+007C)
  0x67, 0x7C, 0xFF, 0xCF, 0xFC, 0xFF, 0xCF, 0xFC, 0xFF, 0xCF, 0xFC, 0xFF, 0xCF, 0xFC, 0xFF, 0xCF,
  0xFC, 0xFF, 0xCF, 0xFC, 0xFF, 0xCF, 0xFC, 0xFF, 0xCF, 0xFC, 0xFF, 0xCF, 0xFC, 0xFF, 0xCF, 0xFC,
  0xFF, 0xCF, 0xFC, 0xFF, 0xCF, 0xFC, 0xFF, 0xCF, 0xFC, 0xFF, 0xCF, 0xFC, 0xFF, 0xCF, 0xFC, 0xFF,
  0xCF, 0xFC, 0xFF, 0xCF, 0xFC, 0xFF, 0xCF, 0xFC, 0xFF, 0xCF, 0xFC, 0xFF, 0xCF, 0xF0,
  // "}" (U+007D)
  0x78, 0x32, 0xFE, 0xB5, 0x74, 0x05, 0xC0, 0x97, 0x30, 0x60, 0xEC, 0x03, 0x74, 0x04, 0xB0, 0x77,
  0x50, 0x9A, 0x08, 0x75, 0x08, 0xA0, 0x87, 0x50, 0xAA, 0x05, 0x75, 0x0D, 0xA0, 0x27, 0x40, 0x1A,
  0x0E, 0x75, 0x04, 0xA0, 0xB7, 0x50, 0x8A, 0x08, 0x75, 0x0B, 0xA0, 0x47, 0x50, 0xEA, 0x02, 0x75,
  0xB0, 0x17, 0x5B, 0x03, 0x75, 0x0A, 0xA0, 0xC0, 0x17, 0x40, 0x10, 0xCB, 0x0D, 0x05, 0x73, 0x01,
  0x0A, 0xB0, 0x47, 0x20, 0x9D, 0x01, 0x71, 0x0B, 0xA8, 0x1E, 0x72, 0x72, 0x05, 0xA0, 0xE0, 0x17,
  0x40, 0xCA, 0x06, 0x74, 0x01, 0xB0, 0x17, 0x40, 0x4A, 0x0C, 0x75, 0x08, 0xA0, 0x97, 0x50, 0xBA,
  0x06, 0x75, 0x0E, 0xA0, 0x27, 0x40, 0x2A, 0x0E, 0x75, 0x06, 0xA0, 0xB7, 0x50, 0xAA, 0x08, 0x74,
  0x02, 0xB0, 0x37, 0x30, 0x40, 0xDA, 0x0D, 0x71, 0x81, 0x1C, 0xEC, 0x05, 0x71, 0x01, 0xD0, 0x77,
  0x28, 0x41, 0xFE, 0xC9, 0x27, 0x30,
  // "~" (U+007E)
  0x28, 0x54, 0xBE, 0xFD, 0x83, 0x78, 0x17, 0x08, 0xF0, 0xC0, 0x53, 0x82, 0x2A, 0xF1, 0xB0, 0x0D,
  0xE0, 0xC0, 0xDB, 0x82, 0x1F, 0xA2, 0x30, 0x60, 0xCF, 0x81, 0x81, 0x77, 0x85, 0x4A, 0xDF, 0xEB,
  0x41,
  // "¡" (U+00A1)
  0x68, 0x23, 0xCE, 0x87, 0x0D, 0xB0, 0x15, 0x03, 0xC6, 0x04, 0xB0, 0xA7, 0x82, 0xBE, 0xB1, 0x80,
  0xC3, 0x08, 0x16, 0xA8, 0x71, 0x81, 0xDF, 0xA7, 0x01, 0xA0, 0x77, 0x05, 0xA0, 0x47, 0x09, 0xA0,
  0x17, 0x81, 0xDF, 0xE7, 0x01, 0xA0, 0xB7, 0x05, 0xA0, 0x87, 0x09, 0xA0, 0x67, 0x0D, 0xA0, 0x36,
  0x01, 0xB7, 0x05, 0xA0, 0xD7, 0x09, 0xA0, 0xA7, 0x0D, 0xA0, 0x76, 0x01, 0xB0, 0x46, 0x05, 0xB0,
  0x16, 0x09, 0xA0, 0xE7, 0x0D, 0xA0, 0xB6, 0x01, 0xB0, 0x86, 0x05, 0xB0, 0x66, 0x09, 0xB0, 0x36,
  // "¢" (U+00A2)
  0x72, 0x81, 0xAF, 0x87, 0x48, 0x1E, 0xF5, 0x73, 0x01, 0xA0, 0x17, 0x20, 0x60, 0xBA, 0x81, 0x96,
  0x15, 0x05, 0x0E, 0xE0, 0xD4, 0x06, 0xF9, 0x07, 0x30, 0x4B, 0x0C, 0x04, 0x28, 0x15, 0xC1, 0x20,
  0x10, 0xEA, 0x0C, 0x72, 0x08, 0xA0, 0xE0, 0x17, 0x10, 0x1B, 0x06, 0x72, 0x07, 0xA0, 0xD7, 0x30,
  0xDA, 0x07, 0x72, 0x02, 0xB0, 0x27, 0x20, 0x6A, 0x0E, 0x73, 0x09, 0xA0, 0xA7, 0x30, 0xBA, 0x08,
  0x73, 0x0D, 0xA0, 0x67, 0x30, 0xEA, 0x05, 0x73, 0x0E, 0xA0, 0x57, 0x30, 0xDA, 0x07, 0x73, 0x0B,
  0xA0, 0xC7, 0x30, 0x7B, 0x08, 0x38, 0x11, 0x83, 0x30, 0x10, 0xEB, 0x81, 0xEC, 0xDA, 0x06, 0x40,
  0x5F, 0x90, 0x85, 0x03, 0x0B, 0xB8, 0x1D, 0xA4, 0x71, 0xA0, 0x37, 0x30, 0x3A, 0x74, 0x81, 0x7F,
  0xC7, 0x48, 0x1A, 0xF9, 0x71,
  // "£" (U+00A3)
  0x74, 0x86, 0x29, 0xDF, 0xED, 0x94, 0x74, 0x07, 0xF9, 0x0B, 0x72, 0x06, 0xC0, 0xC0, 0xDB, 0x08,
  0x71, 0x01, 0x0E, 0xA0, 0xA0, 0x12, 0x81, 0x17, 0xD7, 0x20, 0x8A, 0x0D, 0x77, 0x20, 0xDA, 0x05,
  0x77, 0x10, 0x2B, 0x01, 0x77, 0x10, 0x6A, 0x0C, 0x77, 0x20, 0x9A, 0x09, 0x77, 0x20, 0xDA, 0x05,
  0x77, 0x2B, 0x02, 0x77, 0x10, 0x4A, 0x0E, 0x77, 0x20, 0x7A, 0x0B, 0x76, 0x82, 0x8C, 0xCE, 0xA8,
  0x4E, 0xCC, 0xCC, 0x97, 0x10, 0xDF, 0xB0, 0x97, 0x01, 0xFC, 0x06, 0x73, 0x04, 0xA0, 0xE7, 0x72,
  0x07, 0xA0, 0xB7, 0x72, 0x0A, 0xA0, 0x87, 0x72, 0x0E, 0xA0, 0x57, 0x71, 0x02, 0xB0, 0x27, 0x71,
  0x05, 0xA0, 0xD7, 0x72, 0x0B, 0xA0, 0x87, 0x71, 0x02, 0xB0, 0x17, 0x70, 0x10, 0xCA, 0x07, 0x77,
  0x02, 0x0C, 0xA0, 0x97, 0x70, 0x3C, 0x80, 0x6C, 0x02, 0x40, 0x7F, 0xF5, 0x0A, 0xFE, 0x0C, 0x50,
  // "¤" (U+00A4)
  0x10, 0x80, 0x97, 0x58, 0x2B, 0x50, 0x5A, 0x87, 0x80, 0x17, 0xCE, 0xEB, 0x62, 0x0A, 0xA8, 0x12,
  0x0C, 0xA0, 0x80, 0xDE, 0x0C, 0x0A, 0xA0, 0x92, 0x01, 0x0D, 0xD0, 0xC0, 0xDD, 0x0B, 0x40, 0x4B,
  0x07, 0x30, 0x10, 0x9A, 0x0E, 0x01, 0x40, 0x8A, 0x03, 0x60, 0x6A, 0x05, 0x38, 0x21, 0xEF, 0x77,
  0x18, 0x1B, 0xFC, 0x30, 0x4A, 0x01, 0x71, 0x04, 0xA0, 0x12, 0x81, 0x6F, 0xE7, 0x20, 0x1A, 0x03,
  0x28, 0x16, 0xFE, 0x72, 0x01, 0xA0, 0x32, 0x04, 0xA0, 0x27, 0x10, 0x5A, 0x01, 0x38, 0x1E, 0xF9,
  0x71, 0x81, 0xCF, 0xC4, 0x08, 0xA0, 0x66, 0x09, 0xA0, 0x54, 0x04, 0xB8, 0x4A, 0x30, 0x14, 0xBB,
  0x01, 0x30, 0x20, 0xEF, 0xD0, 0xC2, 0x01, 0x0D, 0xA0, 0x50, 0xCE, 0x0C, 0x0A, 0xA8, 0x1B, 0x03,
  0xA0, 0x42, 0x84, 0x49, 0xBB, 0x94, 0x28, 0x5A, 0xFE, 0x20, 0x46, 0x75, 0x09, 0x03, 0x10,
  // "¥" (U+00A5)
  0x30, 0x3B, 0x71, 0x0E, 0xA0, 0x63, 0x01, 0xB0, 0x16, 0x07, 0xA0, 0xD5, 0xB0, 0x25, 0x01, 0x0E,
  0xA0, 0x45, 0x0D, 0xA0, 0x45, 0x08, 0xA0, 0xB6, 0x0B, 0xA0, 0x64, 0x01, 0x0E, 0xA0, 0x36, 0x09,
  0xA0, 0x74, 0x08, 0xA0, 0xA7, 0x07, 0xA0, 0x93, 0x01, 0xB0, 0x17, 0x05, 0xA0, 0xA3, 0x09, 0xA0,
  0x87, 0x10, 0x3A, 0x0C, 0x20, 0x2A, 0x0E, 0x01, 0x71, 0x01, 0xA0, 0xE2, 0x0A, 0xA0, 0x67, 0x30,
  0xEA, 0x10, 0x2A, 0x0D, 0x74, 0x0D, 0xA0, 0x10, 0xAA, 0x05, 0x74, 0x0B, 0xA0, 0x6A, 0x0C, 0x75,
  0x09, 0xA0, 0xEA, 0x03, 0x75, 0x07, 0xC0, 0xA7, 0x28, 0x31, 0xCC, 0xCD, 0xC8, 0x2D, 0xCC, 0xB6,
  0x04, 0xFC, 0x0D, 0x60, 0x7F, 0xC0, 0xA7, 0x30, 0x3A, 0x0E, 0x77, 0x10, 0x7A, 0x0A, 0x77, 0x10,
  0xAA, 0x07, 0x73, 0x84, 0x4C, 0xCC, 0xCE, 0xA8, 0x3D, 0xCC, 0xC9, 0x60, 0x8F, 0xC0, 0xA6, 0x0A,
  0xFC, 0x07, 0x73, 0x06, 0xA0, 0xB7, 0x71, 0x0A, 0xA0, 0x77, 0x71, 0x0D, 0xA0, 0x47, 0x70, 0x1B,
  0x01, 0x77, 0x05, 0xA0, 0xC7, 0x50,
  // "¦" (U+00A6)
  0x0C, 0xA0, 0xCA, 0x0C, 0xA0, 0xCA, 0x0C, 0xA0, 0xCA, 0x0C, 0xA0, 0xCA, 0x0C, 0xA0, 0xCA, 0x0C,
  0xA0, 0xCA, 0x0C, 0xA0, 0xCA, 0x0C, 0xA7, 0x77, 0x72, 0x0C, 0xA0, 0xCA, 0x0C, 0xA0, 0xCA, 0x0C,
  0xA0, 0xCA, 0x0C, 0xA0, 0xCA, 0x0C, 0xA0, 0xCA, 0x0C, 0xA0, 0xCA, 0x0C, 0xA0, 0xCA, 0x0C, 0xA0,
  // "§" (U+00A7)
  0x78, 0x61, 0x8C, 0xEF, 0xDB, 0x67, 0x10, 0x50, 0xEF, 0x0E, 0x03, 0x50, 0x3C, 0x81, 0xDC, 0xEA,
  0x0E, 0x01, 0x50, 0xCA, 0x0B, 0x02, 0x38, 0x13, 0xB8, 0x50, 0x2A, 0x0E, 0x76, 0x04, 0xA0, 0xB7,
  0x60, 0x3A, 0x0C, 0x76, 0x01, 0xB0, 0x57, 0x60, 0x9B, 0x08, 0x75, 0x01, 0x0C, 0xB0, 0xD0, 0x37,
  0x30, 0x70, 0xED, 0x06, 0x71, 0x0B, 0xA8, 0x17, 0x4D, 0xB0, 0x56, 0x0A, 0xA0, 0x43, 0x0B, 0xA0,
  0xE5, 0x03, 0xA0, 0xA5, 0x0E, 0xA0, 0x34, 0x06, 0xA0, 0x65, 0x0A, 0xA0, 0x44, 0x07, 0xA0, 0x75,
  0x0A, 0xA0, 0x24, 0x05, 0xA0, 0xD5, 0x81, 0xEF, 0xC6, 0x0E, 0xA0, 0xB0, 0x12, 0x09, 0xA0, 0x36,
  0x04, 0x0E, 0xA8, 0x1E, 0x59, 0xA0, 0x57, 0x10, 0x30, 0xDC, 0x0D, 0x03, 0x74, 0x09, 0xB0, 0xD0,
  0x17, 0x50, 0x40, 0xEA, 0x0A, 0x76, 0x03, 0xB7, 0x70, 0xDA, 0x02, 0x76, 0x0D, 0xA0, 0x14, 0x01,
  0x70, 0x4A, 0x0E, 0x58, 0x1B, 0x83, 0x40, 0x60, 0xEA, 0x08, 0x50, 0xCA, 0x81, 0xEC, 0xDC, 0x0D,
  0x60, 0xBF, 0x90, 0xC0, 0x17, 0x86, 0x5A, 0xDE, 0xFD, 0xA5, 0x71,
  // "¨" (U+00A8)
  0x09, 0xEA, 0x00, 0x05, 0xED, 0x14, 0xFF, 0xE0, 0x00, 0xEF, 0xF4, 0x7F, 0xFC, 0x00, 0x2F, 0xFF,
  0x23, 0xED, 0x30, 0x00, 0xBE, 0x70,
  // "©" (U+00A9)
  0x77, 0x10, 0x01, 0x77, 0x73, 0x82, 0x49, 0xCE, 0xC8, 0x1D, 0x95, 0x77, 0x40, 0x50, 0xDF, 0xC0,
  0xE0, 0x77, 0x70, 0x20, 0xDA, 0x83, 0xE9, 0x52, 0x12, 0x82, 0x24, 0x8D, 0xA0, 0xD0, 0x47, 0x48,
  0x35, 0xEF, 0xE7, 0x74, 0x05, 0x0D, 0xA0, 0x67, 0x20, 0x5A, 0x0C, 0x01, 0x76, 0x01, 0x0A, 0xA0,
  0x77, 0x82, 0x3E, 0xFA, 0x68, 0x55, 0x9B, 0xBA, 0x84, 0x40, 0x9A, 0x04, 0x68, 0x1D, 0xFC, 0x50,
  0x40, 0xDF, 0x0D, 0x02, 0x38, 0x2A, 0xFE, 0x14, 0x06, 0xA0, 0x24, 0x06, 0xFA, 0x0D, 0x48, 0x21,
  0xEF, 0x84, 0x81, 0xDF, 0x84, 0x03, 0xB8, 0x6C, 0x51, 0x02, 0x5A, 0x75, 0x06, 0xA0, 0x12, 0x04,
  0xA0, 0x14, 0x0B, 0xA0, 0xB7, 0x78, 0x1E, 0xF7, 0x28, 0x19, 0xFB, 0x40, 0x2A, 0x0E, 0x01, 0x77,
  0x81, 0x9F, 0xC2, 0x81, 0xCF, 0x74, 0x06, 0xA0, 0x97, 0x71, 0x05, 0xA2, 0x81, 0xEF, 0x44, 0x09,
  0xA0, 0x57, 0x71, 0x02, 0xA0, 0x21, 0xA0, 0x34, 0x0A, 0xA0, 0x47, 0x72, 0xA0, 0x30, 0x1A, 0x02,
  0x40, 0xAA, 0x04, 0x77, 0x2A, 0x04, 0x1A, 0x03, 0x40, 0x9A, 0x05, 0x77, 0x10, 0x1A, 0x83, 0x30,
  0xEF, 0x44, 0x07, 0xA0, 0x77, 0x71, 0x02, 0xA8, 0x32, 0x0C, 0xF7, 0x40, 0x4A, 0x0D, 0x77, 0x10,
  0x5A, 0x28, 0x18, 0xFB, 0x50, 0xEA, 0x06, 0x77, 0x81, 0x9F, 0xB2, 0x03, 0xA0, 0x24, 0x07, 0xB0,
  0x70, 0x14, 0x00, 0x56, 0x81, 0xEF, 0x73, 0x81, 0xCF, 0x95, 0x0B, 0xC8, 0x1D, 0xCE, 0xA0, 0x95,
  0x07, 0xA0, 0x13, 0x05, 0xA0, 0x35, 0x0A, 0xF9, 0x09, 0x48, 0x21, 0xEF, 0x85, 0x82, 0xCF, 0xD1,
  0x58, 0x63, 0x9D, 0xEF, 0xEB, 0x65, 0x82, 0xBF, 0xE1, 0x58, 0x31, 0xEF, 0xC1, 0x77, 0x20, 0xAA,
  0x04, 0x70, 0x4A, 0x0D, 0x03, 0x76, 0x01, 0x0B, 0xA0, 0x77, 0x20, 0x30, 0xEA, 0x09, 0x01, 0x73,
  0x07, 0x0E, 0xA0, 0x67, 0x40, 0x20, 0xBB, 0x89, 0x0B, 0x74, 0x21, 0x23, 0x6A, 0xEA, 0x0D, 0x03,
  0x77, 0x04, 0x0C, 0xFC, 0x0D, 0x06, 0x77, 0x48, 0x91, 0x37, 0xBD, 0xEF, 0xED, 0xB8, 0x47, 0x30,
  // "ª" (U+00AA)
  0x48, 0x61, 0x79, 0x93, 0x05, 0x73, 0x04, 0x0E, 0xC8, 0x16, 0xFD, 0x28, 0x52, 0xEF, 0x70, 0x3E,
  0xA0, 0xA2, 0x81, 0xBF, 0xA3, 0x08, 0xA8, 0x17, 0x03, 0xA0, 0x13, 0x06, 0xA8, 0x34, 0x09, 0xFB,
  0x40, 0x6A, 0x83, 0x10, 0xCF, 0x74, 0x81, 0x7F, 0xD2, 0xA0, 0x44, 0x83, 0xAF, 0xA0, 0x1A, 0x03,
  0x48, 0x3E, 0xF6, 0x02, 0xA0, 0x23, 0x04, 0xA8, 0x13, 0x02, 0xA0, 0x33, 0x0B, 0xA3, 0x81, 0xEF,
  0x82, 0x07, 0xA0, 0xC3, 0x07, 0xA8, 0x4B, 0xCF, 0x9F, 0x94, 0x86, 0x7E, 0xEB, 0x44, 0xC5, 0x20,
  // "«" (U+00AB)
  0x70, 0x66, 0x05, 0x71, 0x81, 0xBF, 0xB4, 0x82, 0x9F, 0xC1, 0x50, 0xAA, 0x0A, 0x30, 0x7A, 0x0C,
  0x50, 0x9A, 0x0C, 0x30, 0x5A, 0x0E, 0x02, 0x40, 0x7A, 0x0D, 0x01, 0x20, 0x3B, 0x04, 0x40, 0x6A,
  0x0E, 0x03, 0x20, 0x20, 0xEA, 0x07, 0x40, 0x5B, 0x05, 0x20, 0x10, 0xDA, 0x0A, 0x40, 0x4B, 0x07,
  0x30, 0xBA, 0x0C, 0x50, 0xAA, 0x0D, 0x30, 0x6B, 0x02, 0x50, 0x3B, 0x02, 0x20, 0x2B, 0x04, 0x60,
  0xBA, 0x08, 0x30, 0xAA, 0x0A, 0x60, 0x4A, 0x0E, 0x30, 0x2B, 0x01, 0x60, 0xCA, 0x05, 0x30, 0xAA,
  0x07, 0x60, 0x4A, 0x0B, 0x30, 0x2A, 0x0D, 0x70, 0xCA, 0x02, 0x30, 0xAA, 0x05, 0x60, 0x5A, 0x05,
  0x30, 0x2A, 0x07, 0x70, 0x70, 0x15, 0x06, 0x02, 0x40,
  // "¬" (U+00AC)
  0x80, 0x93, 0xC0, 0x8F, 0xF9, 0x0B, 0xFF, 0x90, 0xB7, 0x50, 0x1A, 0x0B, 0x75, 0x01, 0xA0, 0xB7,
  0x50, 0x1A, 0x0B, 0x75, 0x01, 0xA0, 0xB7, 0x50, 0x1A, 0x0B, 0x75, 0x01, 0xA0, 0xB7, 0x50, 0x1A,
  0x0B, 0x75, 0x01, 0xA0, 0xB0,
  // "®" (U+00AE)
  0x77, 0x10, 0x01, 0x77, 0x73, 0x82, 0x49, 0xCE, 0xC8, 0x1D, 0x95, 0x77, 0x40, 0x50, 0xDF, 0xC0,
  0xE0, 0x77, 0x70, 0x20, 0xDA, 0x83, 0xE9, 0x52, 0x12, 0x82, 0x24, 0x8D, 0xA0, 0xD0, 0x47, 0x48,
  0x35, 0xEF, 0xE7, 0x74, 0x05, 0x0D, 0xA0, 0x67, 0x20, 0x5A, 0x0C, 0x01, 0x76, 0x01, 0x0A, 0xA0,
  0x77, 0x82, 0x3E, 0xFA, 0x38, 0x78, 0xCC, 0xCC, 0xBA, 0x73, 0x50, 0x9A, 0x04, 0x68, 0x1D, 0xFC,
  0x40, 0xBF, 0x90, 0xA5, 0x82, 0xAF, 0xE1, 0x40, 0x6A, 0x02, 0x40, 0xBF, 0xA0, 0x94, 0x82, 0x1E,
  0xF8, 0x48, 0x1D, 0xF8, 0x50, 0xBA, 0x83, 0x20, 0x13, 0xAB, 0x01, 0x40, 0x6A, 0x01, 0x20, 0x4A,
  0x01, 0x50, 0xBA, 0x02, 0x40, 0xDA, 0x04, 0x58, 0x1E, 0xF7, 0x28, 0x19, 0xFB, 0x60, 0xBA, 0x02,
  0x40, 0xAA, 0x05, 0x58, 0x19, 0xFC, 0x28, 0x1C, 0xF7, 0x60, 0xBA, 0x02, 0x40, 0xDA, 0x03, 0x50,
  0x5A, 0x28, 0x1E, 0xF4, 0x60, 0xBA, 0x02, 0x20, 0x10, 0x9A, 0x0E, 0x60, 0x2A, 0x02, 0x1A, 0x03,
  0x60, 0xBA, 0x81, 0xCC, 0xDC, 0x06, 0x7A, 0x03, 0x01, 0xA0, 0x26, 0x0B, 0xF9, 0x07, 0x71, 0xA0,
  0x41, 0xA0, 0x36, 0x0B, 0xF0, 0xA7, 0x10, 0x1A, 0x83, 0x30, 0xEF, 0x46, 0x0B, 0xA0, 0x22, 0x0E,
  0xA0, 0x27, 0x02, 0xA8, 0x32, 0x0C, 0xF7, 0x60, 0xBA, 0x02, 0x20, 0x6A, 0x0A, 0x70, 0x5A, 0x28,
  0x18, 0xFB, 0x60, 0xBA, 0x02, 0x30, 0xDA, 0x03, 0x68, 0x19, 0xFB, 0x20, 0x3A, 0x02, 0x50, 0xBA,
  0x02, 0x30, 0x6A, 0x0B, 0x68, 0x1E, 0xF7, 0x38, 0x1C, 0xF9, 0x50, 0xBA, 0x02, 0x40, 0xDA, 0x04,
  0x40, 0x7A, 0x01, 0x30, 0x5A, 0x03, 0x40, 0xBA, 0x02, 0x40, 0x6A, 0x0C, 0x38, 0x21, 0xEF, 0x85,
  0x82, 0xCF, 0xD1, 0x38, 0x29, 0xDD, 0x25, 0x82, 0xCD, 0xD3, 0x28, 0x2B, 0xFE, 0x15, 0x83, 0x1E,
  0xFC, 0x17, 0x72, 0x0A, 0xA0, 0x47, 0x04, 0xA0, 0xD0, 0x37, 0x60, 0x10, 0xBA, 0x07, 0x72, 0x03,
  0x0E, 0xA0, 0x90, 0x17, 0x30, 0x70, 0xEA, 0x06, 0x74, 0x02, 0x0B, 0xB8, 0x90, 0xB7, 0x42, 0x12,
  0x36, 0xAE, 0xA0, 0xD0, 0x37, 0x70, 0x40, 0xCF, 0xC0, 0xD0, 0x67, 0x74, 0x89, 0x13, 0x7B, 0xDE,
  0xFE, 0xDB, 0x84, 0x73,
  // "¯" (U+00AF)
  0x10, 0x88, 0x09, 0x3C, 0x81, 0x20, 0xDF, 0xF9, 0x00, 0x1F, 0xF9, 0x0D, 0x10,
  // "°" (U+00B0)
  0x38, 0x46, 0xAB, 0xB7, 0x14, 0x02, 0x0D, 0xE0, 0x62, 0x01, 0x0E, 0xF9, 0x81, 0x50, 0x8A, 0x83,
  0xA3, 0x01, 0x7A, 0x83, 0xD0, 0xDF, 0xC5, 0x06, 0xA0, 0x3A, 0x06, 0x50, 0x1A, 0x05, 0xA0, 0x56,
  0xA8, 0x26, 0xEF, 0x95, 0x04, 0xA0, 0x40, 0xAA, 0x07, 0x38, 0x43, 0xDF, 0xE0, 0x2B, 0x81, 0xEC,
  0xDB, 0x07, 0x20, 0x5F, 0x0A, 0x48, 0x52, 0x9D, 0xFE, 0xB5, 0x30,
  // "±" (U+00B1)
  0x60, 0x6A, 0x05, 0x75, 0x06, 0xA0, 0x57, 0x50, 0x6A, 0x05, 0x75, 0x06, 0xA0, 0x57, 0x50, 0x6A,
  0x05, 0x75, 0x06, 0xA0, 0x57, 0x50, 0x6A, 0x05, 0x75, 0x06, 0xA0, 0x56, 0xFF, 0x90, 0xEF, 0xF9,
  0x0E, 0x80, 0x2C, 0x0D, 0xA0, 0xD8, 0x01, 0xC0, 0xB6, 0x06, 0xA0, 0x57, 0x50, 0x6A, 0x05, 0x75,
  0x06, 0xA0, 0x57, 0x50, 0x6A, 0x05, 0x75, 0x06, 0xA0, 0x57, 0x50, 0x6A, 0x05, 0x75, 0x06, 0xA0,
  0x57, 0x50, 0x6A, 0x05, 0x80, 0xC2, 0x08, 0x09, 0x3C, 0x0B, 0xFF, 0x90, 0xEF, 0xF9, 0x0E,
  // "²" (U+00B2)
  0x68, 0x12, 0x43, 0x70, 0x70, 0xEB, 0x0E, 0x05, 0x40, 0xBF, 0x02, 0x38, 0x49, 0xE7, 0x10, 0x7A,
  0x08, 0x30, 0x10, 0x24, 0xA0, 0xA7, 0x2A, 0x09, 0x71, 0x03, 0xA0, 0x57, 0x18, 0x1B, 0xFD, 0x71,
  0x08, 0xA0, 0x47, 0x05, 0xA0, 0x77, 0x05, 0xA0, 0x97, 0x05, 0xA0, 0x97, 0x05, 0xA0, 0x97, 0x05,
  0xA0, 0x87, 0x05, 0xA0, 0x87, 0x05, 0xA0, 0xB8, 0x01, 0x40, 0x32, 0x0D, 0xF9, 0x0A, 0x2F, 0xA0,
  0x72,
  // "³" (U+00B3)
  0x48, 0x55, 0xAE, 0xFE, 0x91, 0x40, 0xBE, 0x0D, 0x48, 0x4C, 0xF9, 0x55, 0xCA, 0x06, 0x30, 0x30,
  0x23, 0x01, 0xA0, 0xA7, 0x28, 0x1E, 0xF9, 0x71, 0x02, 0xA0, 0x67, 0x18, 0x1B, 0xFE, 0x58, 0x54,
  0x57, 0xDF, 0xE3, 0x40, 0x2C, 0x08, 0x01, 0x50, 0x5C, 0x0D, 0x02, 0x78, 0x31, 0x5E, 0xFC, 0x72,
  0x06, 0xA0, 0x37, 0x10, 0x4A, 0x04, 0x71, 0x06, 0xA8, 0x13, 0x03, 0x58, 0x21, 0xEF, 0xE2, 0x85,
  0xCD, 0x75, 0x58, 0xEA, 0x06, 0x20, 0xCF, 0x08, 0x38, 0x12, 0x8D, 0xA8, 0x1D, 0xA3, 0x40,
  // "´" (U+00B4)
  0x48, 0x31, 0x77, 0x75, 0x40, 0xAB, 0x04, 0x30, 0x4B, 0x05, 0x30, 0x10, 0xEA, 0x06, 0x40, 0xBA,
  0x06, 0x40, 0x9A, 0x05, 0x48, 0x24, 0xFE, 0x45,
  // "µ" (U+00B5)
  0x60, 0x4A, 0x0E, 0x60, 0x2A, 0x0E, 0x60, 0x7A, 0x0B, 0x60, 0x6A, 0x0B, 0x60, 0xAA, 0x08, 0x60,
  0x9A, 0x08, 0x60, 0xDA, 0x04, 0x60, 0xCA, 0x05, 0x50, 0x1B, 0x01, 0x6B, 0x02, 0x50, 0x5A, 0x0D,
  0x60, 0x3A, 0x0E, 0x60, 0x8A, 0x0A, 0x60, 0x7A, 0x0B, 0x60, 0xBA, 0x07, 0x60, 0xAA, 0x08, 0x60,
  0xEA, 0x04, 0x60, 0xDA, 0x05, 0x50, 0x2B, 0x60, 0x1B, 0x01, 0x50, 0x5A, 0x0D, 0x60, 0x5A, 0x0E,
  0x60, 0x9A, 0x09, 0x60, 0x8A, 0x0B, 0x60, 0xCA, 0x06, 0x60, 0xCA, 0x07, 0x6B, 0x03, 0x50, 0x1B,
  0x04, 0x50, 0x3B, 0x60, 0x6B, 0x01, 0x50, 0x6A, 0x0D, 0x60, 0xDA, 0x0D, 0x60, 0xAA, 0x0C, 0x50,
  0x6B, 0x0A, 0x60, 0xDA, 0x0D, 0x40, 0x30, 0xEB, 0x07, 0x50, 0x1C, 0x06, 0x28, 0x25, 0xEF, 0xEA,
  0x04, 0x50, 0x4D, 0x0E, 0xB0, 0x70, 0xCA, 0x01, 0x50, 0x7A, 0x0D, 0xD8, 0x39, 0x0D, 0xFD, 0x60,
  0xBA, 0x84, 0x67, 0xEE, 0xC5, 0x2A, 0x0A, 0x60, 0xEA, 0x04, 0x77, 0x10, 0x2B, 0x01, 0x77, 0x10,
  0x5A, 0x0D, 0x77, 0x20, 0x8A, 0x0A, 0x77, 0x20, 0xBA, 0x06, 0x77, 0x20, 0xEA, 0x03, 0x77, 0x10,
  0x3B, 0x77, 0x20, 0x6A, 0x0B, 0x77, 0x20, 0x9A, 0x08, 0x77, 0x20,
  // "¶" (U+00B6)
  0x48, 0x16, 0xCE, 0xF9, 0x06, 0x20, 0x10, 0xCF, 0xC0, 0x62, 0x0B, 0xF0, 0xFC, 0x83, 0xEF, 0x60,
  0x5F, 0x90, 0x12, 0x83, 0xCF, 0x60, 0xCF, 0x90, 0x12, 0x82, 0xCF, 0x61, 0xFA, 0x01, 0x28, 0x2C,
  0xF6, 0x4F, 0xA0, 0x12, 0x82, 0xCF, 0x67, 0xFA, 0x01, 0x28, 0x2C, 0xF6, 0x8F, 0xA0, 0x12, 0x82,
  0xCF, 0x69, 0xFA, 0x01, 0x28, 0x2C, 0xF6, 0x8F, 0xA0, 0x12, 0x82, 0xCF, 0x67, 0xFA, 0x01, 0x28,
  0x2C, 0xF6, 0x6F, 0xA0, 0x12, 0x82, 0xCF, 0x63, 0xFA, 0x01, 0x28, 0x1C, 0xF6, 0x1F, 0xA0, 0x12,
  0x83, 0xCF, 0x60, 0xBF, 0x90, 0x12, 0x83, 0xCF, 0x60, 0x4F, 0x90, 0x12, 0x81, 0xCF, 0x62, 0x09,
  0xF0, 0x12, 0x81, 0xCF, 0x63, 0x09, 0xE0, 0x12, 0x81, 0xCF, 0x64, 0x82, 0x25, 0x54, 0xA0, 0x12,
  0x81, 0xCF, 0x67, 0x01, 0xA0, 0x12, 0x81, 0xCF, 0x67, 0x01, 0xA0, 0x12, 0x81, 0xCF, 0x67, 0x01,
  0xA0, 0x12, 0x81, 0xCF, 0x67, 0x01, 0xA0, 0x12, 0x81, 0xCF, 0x67, 0x01, 0xA0, 0x12, 0x81, 0xCF,
  0x67, 0x01, 0xA0, 0x12, 0x81, 0xCF, 0x67, 0x01, 0xA0, 0x12, 0x81, 0xCF, 0x67, 0x01, 0xA0, 0x12,
  0x81, 0xCF, 0x67, 0x01, 0xA0, 0x12, 0x81, 0xCF, 0x67, 0x1A, 0x01, 0x28, 0x1C, 0xF6, 0x71, 0xA0,
  0x12, 0x81, 0xCF, 0x67, 0x1A, 0x01, 0x28, 0x1C, 0xF6, 0x71, 0xA0, 0x12, 0x81, 0xCF, 0x67, 0x1A,
  0x01, 0x28, 0x1C, 0xF6, 0x71, 0xA0, 0x12, 0x81, 0xCF, 0x67, 0x1A, 0x01, 0x28, 0x1C, 0xF6, 0x71,
  0x00, 0x43, 0x81, 0x34, 0x10,
  // "·" (U+00B7)
  0x04, 0xDE, 0x61, 0xEF, 0xFE, 0x5F, 0xFF, 0xD5, 0xFF, 0xF8, 0x1C, 0xEA, 0x00,
  // "¸" (U+00B8)
  0x50, 0x07, 0x68, 0x18, 0xF7, 0x58, 0x22, 0xFE, 0x15, 0x09, 0xB0, 0x65, 0x02, 0x0C, 0xA0, 0x25,
  0x04, 0xA0, 0x65, 0x06, 0xA8, 0x91, 0x50, 0x31, 0x26, 0xEF, 0xE1, 0x1E, 0x05, 0x20, 0xDA, 0x81,
  0xD9, 0x22,
  // "¹" (U+00B9)
  0x40, 0x7A, 0x07, 0x20, 0x10, 0xBB, 0x82, 0x40, 0x4D, 0xC1, 0x07, 0xA8, 0x97, 0xCB, 0xFD, 0x0C,
  0xF8, 0x0D, 0xF9, 0x03, 0x40, 0x2A, 0x06, 0x40, 0x5A, 0x02, 0x48, 0x18, 0xFE, 0x58, 0x1C, 0xFB,
  0x5A, 0x08, 0x40, 0x3A, 0x05, 0x40, 0x6A, 0x01, 0x48, 0x1A, 0xFD, 0x58, 0x1D, 0xFA, 0x40, 0x1A,
  0x07, 0x40, 0x4A, 0x03, 0x40, 0x8A, 0x40,
  // "º" (U+00BA)
  0x48, 0x26, 0x99, 0x65, 0x03, 0x0D, 0xC0, 0xD0, 0x12, 0x87, 0x1E, 0xF7, 0x02, 0xDF, 0x92, 0x81,
  0xAF, 0x93, 0x83, 0x6F, 0xE0, 0x2A, 0x02, 0x30, 0x4A, 0x82, 0x18, 0xFC, 0x40, 0x3A, 0x82, 0x1B,
  0xF8, 0x40, 0x4A, 0x18, 0x1E, 0xF6, 0x48, 0x16, 0xFD, 0x1A, 0x04, 0x48, 0x19, 0xFA, 0x1A, 0x04,
  0x48, 0x5E, 0xF5, 0x0E, 0xF6, 0x38, 0x15, 0xFD, 0x28, 0x1A, 0xFC, 0x28, 0x21, 0xDF, 0x52, 0x02,
  0xA8, 0x3D, 0xAE, 0xF7, 0x48, 0x43, 0xBE, 0xEB, 0x44,
  // "»" (U+00BB)
  0x40, 0x66, 0x05, 0x02, 0x58, 0x23, 0xEF, 0x73, 0x82, 0x1E, 0xFA, 0x68, 0x1E, 0xFE, 0x40, 0xDA,
  0x02, 0x50, 0x9A, 0x07, 0x30, 0x6A, 0x0A, 0x50, 0x3A, 0x0E, 0x30, 0x1B, 0x02, 0x50, 0xCA, 0x07,
  0x30, 0x9A, 0x09, 0x50, 0x6A, 0x0E, 0x30, 0x3B, 0x02, 0x50, 0xEA, 0x06, 0x30, 0xCA, 0x09, 0x50,
  0xCA, 0x0B, 0x30, 0x8B, 0x40, 0x8A, 0x0E, 0x03, 0x20, 0x3B, 0x09, 0x30, 0x5B, 0x04, 0x20, 0x10,
  0xEA, 0x0A, 0x30, 0x20, 0xEA, 0x06, 0x30, 0xCA, 0x0B, 0x30, 0x10, 0xDA, 0x08, 0x30, 0xAA, 0x0C,
  0x40, 0xBA, 0x09, 0x30, 0x7A, 0x0D, 0x01, 0x30, 0x8A, 0x0B, 0x30, 0x5A, 0x0D, 0x02, 0x48, 0x18,
  0xFC, 0x48, 0x26, 0xFE, 0x26, 0x03, 0x01, 0x50, 0x03, 0x60,
  // "¼" (U+00BC)
  0x60, 0x7A, 0x07, 0x74, 0x0A, 0xA0, 0x24, 0x01, 0x0B, 0xB0, 0x47, 0x30, 0x5A, 0x06, 0x40, 0x40,
  0xDC, 0x73, 0x82, 0x2E, 0xFA, 0x40, 0x7A, 0x82, 0xCB, 0xFD, 0x73, 0x82, 0xCF, 0xD1, 0x48, 0x5C,
  0xF8, 0x0D, 0xF9, 0x72, 0x08, 0xA0, 0x35, 0x82, 0x34, 0x02, 0xA0, 0x67, 0x10, 0x4A, 0x08, 0x72,
  0x05, 0xA0, 0x27, 0x82, 0x1E, 0xFC, 0x73, 0x81, 0x8F, 0xE7, 0x18, 0x2B, 0xFE, 0x17, 0x38, 0x1C,
  0xFB, 0x70, 0x7A, 0x05, 0x74, 0xA0, 0x86, 0x03, 0xA0, 0x97, 0x40, 0x3A, 0x05, 0x68, 0x1D, 0xFD,
  0x75, 0x06, 0xA0, 0x15, 0x0A, 0xA0, 0x27, 0x58, 0x1A, 0xFD, 0x50, 0x6A, 0x06, 0x58, 0x17, 0x76,
  0x58, 0x1D, 0xFA, 0x48, 0x22, 0xEF, 0xA5, 0x08, 0xA0, 0x94, 0x01, 0xA0, 0x74, 0x82, 0xCF, 0xD1,
  0x40, 0x4B, 0x06, 0x40, 0x4A, 0x03, 0x30, 0x8A, 0x03, 0x40, 0x10, 0xEB, 0x03, 0x40, 0x8A, 0x30,
  0x4A, 0x08, 0x58, 0x3B, 0xFC, 0xFE, 0x73, 0x82, 0x1E, 0xFC, 0x58, 0x48, 0xFB, 0xBF, 0xB7, 0x38,
  0x2B, 0xFE, 0x14, 0x85, 0x4F, 0xE1, 0xEF, 0x87, 0x20, 0x7A, 0x05, 0x48, 0x31, 0xEF, 0x42, 0xA0,
  0x57, 0x10, 0x3A, 0x09, 0x58, 0x3B, 0xF8, 0x05, 0xA0, 0x17, 0x82, 0x1D, 0xFD, 0x58, 0x17, 0xFC,
  0x28, 0x19, 0xFD, 0x71, 0x0A, 0xA0, 0x24, 0x82, 0x3F, 0xE2, 0x28, 0x1C, 0xFA, 0x70, 0x6A, 0x06,
  0x48, 0x21, 0xDF, 0x80, 0xF3, 0xA8, 0x19, 0x31, 0x48, 0x22, 0xEF, 0xA5, 0x07, 0xFB, 0x04, 0x48,
  0x2C, 0xFD, 0x15, 0x0A, 0xFB, 0x01, 0x30, 0x9A, 0x04, 0x75, 0x81, 0xAF, 0xD5, 0x04, 0xA0, 0x87,
  0x68, 0x1D, 0xFA, 0x48, 0x21, 0xEF, 0xC7, 0x7A, 0x07, 0x77, 0x70, 0x3A, 0x03, 0x40,
  // "½" (U+00BD)
  0x70, 0x7A, 0x07, 0x73, 0x0A, 0xA0, 0x27, 0x01, 0x0B, 0xB0, 0x47, 0x20, 0x5A, 0x06, 0x70, 0x40,
  0xDC, 0x72, 0x82, 0x2E, 0xFA, 0x70, 0x7A, 0x82, 0xCB, 0xFD, 0x72, 0x82, 0xCF, 0xD1, 0x78, 0x5C,
  0xF8, 0x0D, 0xF9, 0x71, 0x08, 0xA0, 0x37, 0x18, 0x23, 0x40, 0x2A, 0x06, 0x70, 0x4A, 0x08, 0x75,
  0x05, 0xA0, 0x26, 0x82, 0x1E, 0xFC, 0x76, 0x81, 0x8F, 0xE7, 0x82, 0xBF, 0xE1, 0x76, 0x81, 0xCF,
  0xB6, 0x07, 0xA0, 0x57, 0x7A, 0x08, 0x50, 0x3A, 0x09, 0x77, 0x03, 0xA0, 0x55, 0x81, 0xDF, 0xD7,
  0x71, 0x06, 0xA0, 0x14, 0x0A, 0xA0, 0x24, 0x81, 0x24, 0x37, 0x18, 0x1A, 0xFD, 0x40, 0x6A, 0x06,
  0x30, 0x70, 0xEB, 0x0E, 0x05, 0x68, 0x1D, 0xFA, 0x38, 0x22, 0xEF, 0xA3, 0x0B, 0xF0, 0x24, 0x01,
  0xA0, 0x73, 0x82, 0xCF, 0xD1, 0x38, 0x49, 0xE7, 0x10, 0x7A, 0x08, 0x40, 0x4A, 0x03, 0x20, 0x8A,
  0x03, 0x40, 0x10, 0x24, 0xA0, 0xA4, 0x08, 0xA2, 0x04, 0xA0, 0x87, 0x4A, 0x09, 0x71, 0x82, 0x1E,
  0xFC, 0x74, 0x03, 0xA0, 0x57, 0x18, 0x2B, 0xFE, 0x17, 0x48, 0x1B, 0xFD, 0x71, 0x07, 0xA0, 0x57,
  0x40, 0x8A, 0x04, 0x70, 0x3A, 0x09, 0x74, 0x05, 0xA0, 0x77, 0x82, 0x1D, 0xFD, 0x74, 0x05, 0xA0,
  0x97, 0x10, 0xAA, 0x02, 0x73, 0x05, 0xA0, 0x97, 0x10, 0x6A, 0x06, 0x73, 0x05, 0xA0, 0x97, 0x18,
  0x22, 0xEF, 0xA7, 0x30, 0x5A, 0x08, 0x72, 0x82, 0xCF, 0xD1, 0x72, 0x05, 0xA0, 0x87, 0x20, 0x9A,
  0x04, 0x72, 0x05, 0xA0, 0xB8, 0x01, 0x40, 0x33, 0x04, 0xA0, 0x87, 0x30, 0xDF, 0x90, 0xA2, 0x82,
  0x1E, 0xFC, 0x74, 0xFA, 0x07, 0x20,
  // "¾" (U+00BE)
  0x48, 0x55, 0xAE, 0xFE, 0x91, 0x75, 0x0A, 0xA0, 0x23, 0x0B, 0xE0, 0xD7, 0x40, 0x5A, 0x06, 0x48,
  0x4C, 0xF9, 0x55, 0xCA, 0x06, 0x72, 0x82, 0x2E, 0xFA, 0x50, 0x30, 0x23, 0x01, 0xA0, 0xA7, 0x28,
  0x2C, 0xFD, 0x17, 0x48, 0x1E, 0xF9, 0x71, 0x08, 0xA0, 0x37, 0x40, 0x2A, 0x06, 0x70, 0x4A, 0x08,
  0x75, 0x81, 0xBF, 0xE7, 0x82, 0x1E, 0xFC, 0x72, 0x85, 0x45, 0x7D, 0xFE, 0x37, 0x82, 0xBF, 0xE1,
  0x71, 0x02, 0xC0, 0x80, 0x17, 0x07, 0xA0, 0x57, 0x20, 0x5C, 0x0D, 0x02, 0x60, 0x3A, 0x09, 0x75,
  0x83, 0x15, 0xEF, 0xC6, 0x81, 0xDF, 0xD7, 0x71, 0x06, 0xA0, 0x34, 0x0A, 0xA0, 0x27, 0x71, 0x04,
  0xA0, 0x43, 0x06, 0xA0, 0x65, 0x81, 0x77, 0x67, 0x10, 0x6A, 0x03, 0x28, 0x22, 0xEF, 0xA5, 0x08,
  0xA8, 0x19, 0x03, 0x58, 0x21, 0xEF, 0xE3, 0x82, 0xCF, 0xD1, 0x40, 0x4B, 0x87, 0x60, 0xCD, 0x75,
  0x58, 0xEA, 0x06, 0x20, 0x8A, 0x03, 0x40, 0x10, 0xEB, 0x81, 0x30, 0xCF, 0x08, 0x20, 0x4A, 0x08,
  0x58, 0x3B, 0xFC, 0xFE, 0x28, 0x12, 0x8D, 0xA8, 0x1D, 0xA3, 0x28, 0x21, 0xEF, 0xC5, 0x84, 0x8F,
  0xBB, 0xFB, 0x75, 0x82, 0xBF, 0xE1, 0x48, 0x54, 0xFE, 0x1E, 0xF8, 0x74, 0x07, 0xA0, 0x54, 0x83,
  0x1E, 0xF4, 0x2A, 0x05, 0x73, 0x03, 0xA0, 0x95, 0x83, 0xBF, 0x80, 0x5A, 0x01, 0x72, 0x82, 0x1D,
  0xFD, 0x58, 0x17, 0xFC, 0x28, 0x19, 0xFD, 0x73, 0x0A, 0xA0, 0x24, 0x82, 0x3F, 0xE2, 0x28, 0x1C,
  0xFA, 0x72, 0x06, 0xA0, 0x64, 0x82, 0x1D, 0xF8, 0x0F, 0x3A, 0x81, 0x93, 0x16, 0x82, 0x2E, 0xFA,
  0x50, 0x7F, 0xB0, 0x46, 0x82, 0xCF, 0xD1, 0x50, 0xAF, 0xB0, 0x15, 0x09, 0xA0, 0x47, 0x58, 0x1A,
  0xFD, 0x70, 0x4A, 0x08, 0x76, 0x81, 0xDF, 0xA6, 0x82, 0x1E, 0xFC, 0x77, 0xA0, 0x77, 0x77, 0x20,
  0x3A, 0x03, 0x40,
  // "¿" (U+00BF)
  0x73, 0x82, 0x7E, 0xD3, 0x72, 0x05, 0xB0, 0x97, 0x20, 0xAB, 0x09, 0x72, 0x0B, 0xB0, 0x47, 0x28,
  0x24, 0xED, 0x68, 0x0E, 0x00, 0x81, 0xAB, 0x77, 0x30, 0x2A, 0x07, 0x73, 0x07, 0xA0, 0x37, 0x38,
  0x1D, 0xFD, 0x73, 0x08, 0xA0, 0x77, 0x20, 0x5A, 0x0D, 0x72, 0x04, 0xB0, 0x37, 0x10, 0x30, 0xEA,
  0x06, 0x71, 0x03, 0x0E, 0xA0, 0x77, 0x10, 0x20, 0xEA, 0x08, 0x72, 0x0C, 0xA0, 0xA7, 0x20, 0x8A,
  0x0C, 0x72, 0x01, 0xB0, 0x37, 0x20, 0x6A, 0x0D, 0x73, 0x09, 0xA0, 0x97, 0x30, 0xAA, 0x09, 0x73,
  0x0A, 0xA0, 0xB6, 0x01, 0x30, 0x7B, 0x06, 0x38, 0x13, 0xBD, 0x30, 0x2C, 0x81, 0xEC, 0xEB, 0x04,
  0x30, 0x6F, 0x90, 0xB0, 0x24, 0x86, 0x3A, 0xDF, 0xEC, 0x83, 0x40,
  // "À" (U+00C0)
  0x76, 0x0F, 0x60, 0x37, 0x71, 0x0D, 0xA0, 0xB7, 0x71, 0x06, 0xB0, 0x17, 0x71, 0x0C, 0xA0, 0x57,
  0x71, 0x03, 0xA0, 0xB7, 0x72, 0x08, 0xA0, 0x27, 0x72, 0x81, 0xCF, 0x88, 0x0D, 0x70, 0x0B, 0xB0,
  0x87, 0x60, 0x2C, 0x08, 0x76, 0x09, 0xC0, 0x97, 0x50, 0x1A, 0x0E, 0xA0, 0xA7, 0x50, 0x7A, 0x08,
  0xA0, 0xA7, 0x50, 0xEA, 0x03, 0xA0, 0xB7, 0x40, 0x6A, 0x09, 0x02, 0xA0, 0xB7, 0x40, 0xDA, 0x03,
  0x02, 0xA0, 0xC7, 0x30, 0x4A, 0x81, 0xC0, 0x1A, 0x0D, 0x73, 0x0B, 0xA8, 0x16, 0x01, 0xA0, 0xD7,
  0x20, 0x3A, 0x0E, 0x20, 0x1A, 0x0E, 0x72, 0x0A, 0xA0, 0x92, 0x01, 0xA0, 0xE7, 0x10, 0x1B, 0x02,
  0x20, 0x1B, 0x71, 0x08, 0xA0, 0xC3, 0x01, 0xB7, 0x10, 0xEA, 0x05, 0x30, 0x1B, 0x01, 0x60, 0x7A,
  0x0E, 0x40, 0x1B, 0x01, 0x60, 0xDA, 0x08, 0x5B, 0x02, 0x50, 0x5F, 0xD0, 0x35, 0x0C, 0xFD, 0x03,
  0x40, 0x3B, 0x80, 0x3C, 0xB0, 0x44, 0x0A, 0xA0, 0xC7, 0xB0, 0x43, 0x02, 0xB0, 0x57, 0xB0, 0x53,
  0x09, 0xA0, 0xE7, 0x10, 0xEA, 0x06, 0x20, 0x10, 0xEA, 0x07, 0x71, 0x0E, 0xA0, 0x62, 0x07, 0xB0,
  0x17, 0x10, 0xDA, 0x07, 0x20, 0xEA, 0x09, 0x72, 0x0D, 0xA8, 0x17, 0x06, 0xB0, 0x37, 0x20, 0xCA,
  0x81, 0x80, 0xDA, 0x0C, 0x73, 0x0C, 0xA0, 0x90, 0x4B, 0x05, 0x73, 0x0B, 0xA0, 0x90,
  // "Á" (U+00C1)
  0x77, 0x48, 0x31, 0x77, 0x75, 0x77, 0x40, 0xAB, 0x04, 0x77, 0x30, 0x4B, 0x05, 0x77, 0x30, 0x10,
  0xEA, 0x06, 0x77, 0x40, 0xBA, 0x06, 0x77, 0x40, 0x9A, 0x05, 0x77, 0x48, 0x24, 0xFE, 0x48, 0x0F,
  0x40, 0x0B, 0xB0, 0x87, 0x73, 0x02, 0xC0, 0x87, 0x73, 0x09, 0xC0, 0x97, 0x72, 0x01, 0xA0, 0xEA,
  0x0A, 0x77, 0x20, 0x7A, 0x08, 0xA0, 0xA7, 0x72, 0x0E, 0xA0, 0x3A, 0x0B, 0x77, 0x10, 0x6A, 0x09,
  0x02, 0xA0, 0xB7, 0x71, 0x0D, 0xA0, 0x30, 0x2A, 0x0C, 0x77, 0x04, 0xA8, 0x1C, 0x01, 0xA0, 0xD7,
  0x70, 0xBA, 0x81, 0x60, 0x1A, 0x0D, 0x76, 0x03, 0xA0, 0xE2, 0x01, 0xA0, 0xE7, 0x60, 0xAA, 0x09,
  0x20, 0x1A, 0x0E, 0x75, 0x01, 0xB0, 0x22, 0x01, 0xB7, 0x50, 0x8A, 0x0C, 0x30, 0x1B, 0x75, 0x0E,
  0xA0, 0x53, 0x01, 0xB0, 0x17, 0x30, 0x7A, 0x0E, 0x40, 0x1B, 0x01, 0x73, 0x0D, 0xA0, 0x85, 0xB0,
  0x27, 0x20, 0x5F, 0xD0, 0x37, 0x20, 0xCF, 0xD0, 0x37, 0x10, 0x3B, 0x80, 0x3C, 0xB0, 0x47, 0x10,
  0xAA, 0x0C, 0x7B, 0x04, 0x70, 0x2B, 0x05, 0x7B, 0x05, 0x70, 0x9A, 0x0E, 0x71, 0x0E, 0xA0, 0x66,
  0x01, 0x0E, 0xA0, 0x77, 0x10, 0xEA, 0x06, 0x60, 0x7B, 0x01, 0x71, 0x0D, 0xA0, 0x76, 0x0E, 0xA0,
  0x97, 0x20, 0xDA, 0x07, 0x50, 0x6B, 0x03, 0x72, 0x0C, 0xA0, 0x85, 0x0D, 0xA0, 0xC7, 0x30, 0xCA,
  0x09, 0x40, 0x4B, 0x05, 0x73, 0x0B, 0xA0, 0x94,
  // "Â" (U+00C2)
  0x77, 0x18, 0x24, 0x77, 0x47, 0x72, 0x02, 0x0E, 0xA0, 0xC7, 0x72, 0x0C, 0xC0, 0x37, 0x70, 0xAA,
  0x09, 0xA0, 0x97, 0x60, 0x8A, 0x81, 0x50, 0xAA, 0x01, 0x74, 0x82, 0x7F, 0xE4, 0x28, 0x21, 0xEF,
  0x77, 0x38, 0x24, 0xFD, 0x34, 0x81, 0x4F, 0xE8, 0x0E, 0x30, 0x0B, 0xB0, 0x87, 0x71, 0x02, 0xC0,
  0x87, 0x71, 0x09, 0xC0, 0x97, 0x70, 0x1A, 0x0E, 0xA0, 0xA7, 0x70, 0x7A, 0x08, 0xA0, 0xA7, 0x70,
  0xEA, 0x03, 0xA0, 0xB7, 0x60, 0x6A, 0x09, 0x02, 0xA0, 0xB7, 0x60, 0xDA, 0x03, 0x02, 0xA0, 0xC7,
  0x50, 0x4A, 0x81, 0xC0, 0x1A, 0x0D, 0x75, 0x0B, 0xA8, 0x16, 0x01, 0xA0, 0xD7, 0x40, 0x3A, 0x0E,
  0x20, 0x1A, 0x0E, 0x74, 0x0A, 0xA0, 0x92, 0x01, 0xA0, 0xE7, 0x30, 0x1B, 0x02, 0x20, 0x1B, 0x73,
  0x08, 0xA0, 0xC3, 0x01, 0xB7, 0x30, 0xEA, 0x05, 0x30, 0x1B, 0x01, 0x71, 0x07, 0xA0, 0xE4, 0x01,
  0xB0, 0x17, 0x10, 0xDA, 0x08, 0x5B, 0x02, 0x70, 0x5F, 0xD0, 0x37, 0x0C, 0xFD, 0x03, 0x60, 0x3B,
  0x80, 0x3C, 0xB0, 0x46, 0x0A, 0xA0, 0xC7, 0xB0, 0x45, 0x02, 0xB0, 0x57, 0xB0, 0x55, 0x09, 0xA0,
  0xE7, 0x10, 0xEA, 0x06, 0x40, 0x10, 0xEA, 0x07, 0x71, 0x0E, 0xA0, 0x64, 0x07, 0xB0, 0x17, 0x10,
  0xDA, 0x07, 0x40, 0xEA, 0x09, 0x72, 0x0D, 0xA0, 0x73, 0x06, 0xB0, 0x37, 0x20, 0xCA, 0x08, 0x30,
  0xDA, 0x0C, 0x73, 0x0C, 0xA0, 0x92, 0x04, 0xB0, 0x57, 0x30, 0xBA, 0x09, 0x20,
  // "Ã" (U+00C3)
  0x75, 0x83, 0x3C, 0xFD, 0x64, 0x81, 0xEF, 0x17, 0x40, 0x2D, 0x84, 0xA1, 0x07, 0xFC, 0x75, 0x0B,
  0xA0, 0xCB, 0x0E, 0x0D, 0xA0, 0x67, 0x40, 0x1A, 0x82, 0x30, 0x2C, 0xC0, 0xC7, 0x58, 0x16, 0xFA,
  0x48, 0x37, 0xDE, 0xA1, 0x80, 0xF3, 0x00, 0xBB, 0x08, 0x77, 0x40, 0x2C, 0x08, 0x77, 0x40, 0x9C,
  0x09, 0x77, 0x30, 0x1A, 0x0E, 0xA0, 0xA7, 0x73, 0x07, 0xA0, 0x8A, 0x0A, 0x77, 0x30, 0xEA, 0x03,
  0xA0, 0xB7, 0x72, 0x06, 0xA0, 0x90, 0x2A, 0x0B, 0x77, 0x20, 0xDA, 0x03, 0x02, 0xA0, 0xC7, 0x71,
  0x04, 0xA8, 0x1C, 0x01, 0xA0, 0xD7, 0x71, 0x0B, 0xA8, 0x16, 0x01, 0xA0, 0xD7, 0x70, 0x3A, 0x0E,
  0x20, 0x1A, 0x0E, 0x77, 0x0A, 0xA0, 0x92, 0x01, 0xA0, 0xE7, 0x60, 0x1B, 0x02, 0x20, 0x1B, 0x76,
  0x08, 0xA0, 0xC3, 0x01, 0xB7, 0x60, 0xEA, 0x05, 0x30, 0x1B, 0x01, 0x74, 0x07, 0xA0, 0xE4, 0x01,
  0xB0, 0x17, 0x40, 0xDA, 0x08, 0x5B, 0x02, 0x73, 0x05, 0xFD, 0x03, 0x73, 0x0C, 0xFD, 0x03, 0x72,
  0x03, 0xB8, 0x03, 0xCB, 0x04, 0x72, 0x0A, 0xA0, 0xC7, 0xB0, 0x47, 0x10, 0x2B, 0x05, 0x7B, 0x05,
  0x71, 0x09, 0xA0, 0xE7, 0x10, 0xEA, 0x06, 0x70, 0x10, 0xEA, 0x07, 0x71, 0x0E, 0xA0, 0x67, 0x07,
  0xB0, 0x17, 0x10, 0xDA, 0x07, 0x70, 0xEA, 0x09, 0x72, 0x0D, 0xA0, 0x76, 0x06, 0xB0, 0x37, 0x20,
  0xCA, 0x08, 0x60, 0xDA, 0x0C, 0x73, 0x0C, 0xA0, 0x95, 0x04, 0xB0, 0x57, 0x30, 0xBA, 0x09, 0x50,
  // "Ä" (U+00C4)
  0x75, 0x81, 0x9E, 0xA3, 0x82, 0x5E, 0xD1, 0x74, 0x04, 0xA0, 0xE3, 0x0E, 0xA0, 0x47, 0x40, 0x7A,
  0x0C, 0x20, 0x2B, 0x02, 0x74, 0x82, 0x3E, 0xD3, 0x38, 0x1B, 0xE7, 0x80, 0x99, 0x40, 0x0B, 0xB0,
  0x87, 0x72, 0x02, 0xC0, 0x87, 0x72, 0x09, 0xC0, 0x97, 0x71, 0x01, 0xA0, 0xEA, 0x0A, 0x77, 0x10,
  0x7A, 0x08, 0xA0, 0xA7, 0x71, 0x0E, 0xA0, 0x3A, 0x0B, 0x77, 0x06, 0xA0, 0x90, 0x2A, 0x0B, 0x77,
  0x0D, 0xA0, 0x30, 0x2A, 0x0C, 0x76, 0x04, 0xA8, 0x1C, 0x01, 0xA0, 0xD7, 0x60, 0xBA, 0x81, 0x60,
  0x1A, 0x0D, 0x75, 0x03, 0xA0, 0xE2, 0x01, 0xA0, 0xE7, 0x50, 0xAA, 0x09, 0x20, 0x1A, 0x0E, 0x74,
  0x01, 0xB0, 0x22, 0x01, 0xB7, 0x40, 0x8A, 0x0C, 0x30, 0x1B, 0x74, 0x0E, 0xA0, 0x53, 0x01, 0xB0,
  0x17, 0x20, 0x7A, 0x0E, 0x40, 0x1B, 0x01, 0x72, 0x0D, 0xA0, 0x85, 0xB0, 0x27, 0x10, 0x5F, 0xD0,
  0x37, 0x10, 0xCF, 0xD0, 0x37, 0x03, 0xB8, 0x03, 0xCB, 0x04, 0x70, 0xAA, 0x0C, 0x7B, 0x04, 0x60,
  0x2B, 0x05, 0x7B, 0x05, 0x60, 0x9A, 0x0E, 0x71, 0x0E, 0xA0, 0x65, 0x01, 0x0E, 0xA0, 0x77, 0x10,
  0xEA, 0x06, 0x50, 0x7B, 0x01, 0x71, 0x0D, 0xA0, 0x75, 0x0E, 0xA0, 0x97, 0x20, 0xDA, 0x07, 0x40,
  0x6B, 0x03, 0x72, 0x0C, 0xA0, 0x84, 0x0D, 0xA0, 0xC7, 0x30, 0xCA, 0x09, 0x30, 0x4B, 0x05, 0x73,
  0x0B, 0xA0, 0x93,
  // "Å" (U+00C5)
  0x77, 0x84, 0x7D, 0xFE, 0x91, 0x77, 0x0A, 0xA0, 0xDA, 0x0D, 0x01, 0x75, 0x87, 0x4F, 0xE2, 0x01,
  0xBF, 0x77, 0x58, 0x17, 0xF8, 0x38, 0x14, 0xFB, 0x75, 0x81, 0x7F, 0x83, 0x81, 0x4F, 0xB7, 0x58,
  0x74, 0xFE, 0x20, 0x1C, 0xF7, 0x76, 0x0B, 0xA0, 0xEA, 0x0D, 0x01, 0x77, 0x84, 0x8D, 0xFE, 0x91,
  0x80, 0xE4, 0x00, 0xBB, 0x08, 0x77, 0x10, 0x2C, 0x08, 0x77, 0x10, 0x9C, 0x09, 0x77, 0x01, 0xA0,
  0xEA, 0x0A, 0x77, 0x07, 0xA0, 0x8A, 0x0A, 0x77, 0x0E, 0xA0, 0x3A, 0x0B, 0x76, 0x06, 0xA0, 0x90,
  0x2A, 0x0B, 0x76, 0x0D, 0xA0, 0x30, 0x2A, 0x0C, 0x75, 0x04, 0xA8, 0x1C, 0x01, 0xA0, 0xD7, 0x50,
  0xBA, 0x81, 0x60, 0x1A, 0x0D, 0x74, 0x03, 0xA0, 0xE2, 0x01, 0xA0, 0xE7, 0x40, 0xAA, 0x09, 0x20,
  0x1A, 0x0E, 0x73, 0x01, 0xB0, 0x22, 0x01, 0xB7, 0x30, 0x8A, 0x0C, 0x30, 0x1B, 0x73, 0x0E, 0xA0,
  0x53, 0x01, 0xB0, 0x17, 0x10, 0x7A, 0x0E, 0x40, 0x1B, 0x01, 0x71, 0x0D, 0xA0, 0x85, 0xB0, 0x27,
  0x05, 0xFD, 0x03, 0x70, 0xCF, 0xD0, 0x36, 0x03, 0xB8, 0x03, 0xCB, 0x04, 0x60, 0xAA, 0x0C, 0x7B,
  0x04, 0x50, 0x2B, 0x05, 0x7B, 0x05, 0x50, 0x9A, 0x0E, 0x71, 0x0E, 0xA0, 0x64, 0x01, 0x0E, 0xA0,
  0x77, 0x10, 0xEA, 0x06, 0x40, 0x7B, 0x01, 0x71, 0x0D, 0xA0, 0x74, 0x0E, 0xA0, 0x97, 0x20, 0xDA,
  0x07, 0x30, 0x6B, 0x03, 0x72, 0x0C, 0xA0, 0x83, 0x0D, 0xA0, 0xC7, 0x30, 0xCA, 0x09, 0x20, 0x4B,
  0x05, 0x73, 0x0B, 0xA0, 0x92,
  // "Æ" (U+00C6)
  0x77, 0x10, 0xDF, 0xF7, 0x70, 0x5F, 0xF0, 0xC7, 0x70, 0xDA, 0x0C, 0xB8, 0x04, 0xC0, 0x77, 0x60,
  0x6A, 0x0B, 0x03, 0xB0, 0x17, 0x77, 0x0D, 0xA0, 0x30, 0x6A, 0x0D, 0x77, 0x70, 0x6A, 0x81, 0xB0,
  0x9A, 0x0A, 0x77, 0x70, 0xEA, 0x81, 0x40, 0xCA, 0x07, 0x77, 0x60, 0x7A, 0x0C, 0x2B, 0x03, 0x77,
  0x60, 0xEA, 0x81, 0x40, 0x3B, 0x77, 0x60, 0x7A, 0x0C, 0x20, 0x6A, 0x0D, 0x77, 0x50, 0x10, 0xEA,
  0x05, 0x20, 0x9A, 0x09, 0x77, 0x50, 0x8A, 0x0D, 0x30, 0xCA, 0x06, 0x77, 0x40, 0x10, 0xEA, 0x05,
  0x3B, 0x0D, 0x80, 0x2C, 0x0B, 0x74, 0x08, 0xA0, 0xD3, 0x03, 0xFB, 0x0B, 0x73, 0x01, 0xB0, 0x63,
  0x06, 0xFB, 0x08, 0x73, 0x09, 0xA0, 0xD4, 0x09, 0xA0, 0x87, 0x73, 0x02, 0xB0, 0x64, 0x0C, 0xA0,
  0x57, 0x73, 0x09, 0xFC, 0x02, 0x77, 0x20, 0x2F, 0xC0, 0xE7, 0x73, 0x0A, 0xA0, 0xE8, 0x01, 0xC0,
  0xEA, 0x0B, 0x77, 0x20, 0x2B, 0x05, 0x50, 0xBA, 0x08, 0x77, 0x20, 0xAA, 0x0C, 0x60, 0xEA, 0x05,
  0x77, 0x10, 0x3B, 0x04, 0x50, 0x2B, 0x02, 0x77, 0x10, 0xBA, 0x0C, 0x60, 0x5A, 0x0E, 0x77, 0x10,
  0x3B, 0x04, 0x60, 0x8A, 0x0C, 0x77, 0x10, 0xBA, 0x0C, 0x70, 0xCA, 0x08, 0x77, 0x04, 0xB0, 0x47,
  0xB0, 0xD8, 0x03, 0xC0, 0x76, 0x0C, 0xA0, 0xC7, 0x03, 0xFC, 0x06, 0x50, 0x4B, 0x04, 0x70, 0x6F,
  0xC0, 0x35,
  // "Ç" (U+00C7)
  0x73, 0x87, 0x4A, 0xDE, 0xFE, 0xB7, 0x27, 0x20, 0x30, 0xCF, 0xA0, 0x37, 0x06, 0xD8, 0x1C, 0xCE,
  0xA0, 0xC7, 0x06, 0xB0, 0xD0, 0x54, 0x81, 0x5D, 0x36, 0x05, 0xB0, 0xB0, 0x17, 0x60, 0x10, 0xEA,
  0x0C, 0x77, 0x10, 0xBA, 0x0E, 0x01, 0x77, 0x03, 0xB0, 0x67, 0x71, 0x0B, 0xA0, 0xD7, 0x71, 0x02,
  0xB0, 0x67, 0x71, 0x08, 0xA0, 0xE7, 0x72, 0x0D, 0xA0, 0x97, 0x71, 0x02, 0xB0, 0x57, 0x71, 0x06,
  0xB0, 0x17, 0x71, 0x09, 0xA0, 0xD7, 0x72, 0x0C, 0xA0, 0xA7, 0x72, 0x0E, 0xA0, 0x87, 0x72, 0xB0,
  0x67, 0x71, 0x01, 0xB0, 0x57, 0x71, 0x01, 0xB0, 0x57, 0x71, 0x01, 0xB0, 0x57, 0x72, 0xB0, 0x77,
  0x72, 0x0D, 0xA0, 0xA7, 0x72, 0x09, 0xA0, 0xE7, 0x72, 0x04, 0xB0, 0x87, 0x72, 0x0C, 0xB0, 0x80,
  0x13, 0x81, 0x16, 0x67, 0x10, 0x30, 0xEC, 0x81, 0xCC, 0xDA, 0x09, 0x72, 0x03, 0x0E, 0xF9, 0x09,
  0x74, 0x87, 0x7C, 0xEF, 0xEC, 0xA6, 0x17, 0x60, 0x07, 0x77, 0x38, 0x18, 0xF7, 0x77, 0x28, 0x22,
  0xFE, 0x17, 0x72, 0x09, 0xB0, 0x67, 0x72, 0x02, 0x0C, 0xA0, 0x27, 0x72, 0x04, 0xA0, 0x67, 0x72,
  0x06, 0xA0, 0x57, 0x58, 0x63, 0x12, 0x6E, 0xFE, 0x17, 0x40, 0x1E, 0x05, 0x76, 0x0D, 0xA8, 0x1D,
  0x92, 0x74,
  // "È" (U+00C8)
  0x72, 0x0F, 0x60, 0x37, 0x70, 0xDA, 0x0B, 0x77, 0x06, 0xB0, 0x17, 0x70, 0xCA, 0x05, 0x77, 0x03,
  0xA0, 0xB7, 0x71, 0x08, 0xA0, 0x27, 0x71, 0x81, 0xCF, 0x88, 0x0D, 0x10, 0x09, 0xFC, 0x60, 0xCF,
  0xB0, 0xC6, 0xB8, 0x04, 0xC0, 0x75, 0x03, 0xB7, 0x70, 0x6A, 0x0D, 0x77, 0x09, 0xA0, 0xA7, 0x70,
  0xDA, 0x06, 0x77, 0xB0, 0x37, 0x60, 0x3B, 0x77, 0x07, 0xA0, 0xC7, 0x70, 0xAA, 0x09, 0x77, 0x0D,
  0xA0, 0x67, 0x60, 0x1B, 0x0D, 0x80, 0x2C, 0x0B, 0x60, 0x4F, 0xB0, 0xB6, 0x07, 0xFB, 0x07, 0x60,
  0xBA, 0x08, 0x77, 0x0E, 0xA0, 0x57, 0x60, 0x1B, 0x02, 0x76, 0x05, 0xA0, 0xE7, 0x70, 0x8A, 0x0B,
  0x77, 0x0B, 0xA0, 0x87, 0x70, 0xEA, 0x05, 0x76, 0x02, 0xB0, 0x27, 0x60, 0x5A, 0x0E, 0x77, 0x09,
  0xA0, 0xB7, 0x70, 0xCA, 0x08, 0x77, 0xB0, 0xD8, 0x03, 0xC0, 0x75, 0x03, 0xFC, 0x06, 0x50, 0x6F,
  0xC0, 0x35,
  // "É" (U+00C9)
  0x77, 0x83, 0x17, 0x77, 0x57, 0x70, 0xAB, 0x04, 0x76, 0x04, 0xB0, 0x57, 0x60, 0x10, 0xEA, 0x06,
  0x77, 0x0B, 0xA0, 0x67, 0x70, 0x9A, 0x05, 0x77, 0x82, 0x4F, 0xE4, 0x80, 0xD5, 0x00, 0x9F, 0xC7,
  0x0C, 0xFB, 0x0C, 0x7B, 0x80, 0x4C, 0x07, 0x60, 0x3B, 0x77, 0x10, 0x6A, 0x0D, 0x77, 0x10, 0x9A,
  0x0A, 0x77, 0x10, 0xDA, 0x06, 0x77, 0x1B, 0x03, 0x77, 0x03, 0xB7, 0x71, 0x07, 0xA0, 0xC7, 0x71,
  0x0A, 0xA0, 0x97, 0x71, 0x0D, 0xA0, 0x67, 0x70, 0x1B, 0x0D, 0x80, 0x2C, 0x0B, 0x70, 0x4F, 0xB0,
  0xB7, 0x07, 0xFB, 0x07, 0x70, 0xBA, 0x08, 0x77, 0x10, 0xEA, 0x05, 0x77, 0x01, 0xB0, 0x27, 0x70,
  0x5A, 0x0E, 0x77, 0x10, 0x8A, 0x0B, 0x77, 0x10, 0xBA, 0x08, 0x77, 0x10, 0xEA, 0x05, 0x77, 0x02,
  0xB0, 0x27, 0x70, 0x5A, 0x0E, 0x77, 0x10, 0x9A, 0x0B, 0x77, 0x10, 0xCA, 0x08, 0x77, 0x1B, 0x0D,
  0x80, 0x3C, 0x07, 0x60, 0x3F, 0xC0, 0x66, 0x06, 0xFC, 0x03, 0x60,
  // "Ê" (U+00CA)
  0x75, 0x82, 0x47, 0x74, 0x76, 0x02, 0x0E, 0xA0, 0xC7, 0x60, 0xCC, 0x03, 0x74, 0x0A, 0xA0, 0x9A,
  0x09, 0x73, 0x08, 0xA8, 0x15, 0x0A, 0xA0, 0x17, 0x18, 0x27, 0xFE, 0x42, 0x82, 0x1E, 0xF7, 0x78,
  0x24, 0xFD, 0x34, 0x81, 0x4F, 0xE8, 0x0C, 0x60, 0x09, 0xFC, 0x60, 0xCF, 0xB0, 0xC6, 0xB8, 0x04,
  0xC0, 0x75, 0x03, 0xB7, 0x70, 0x6A, 0x0D, 0x77, 0x09, 0xA0, 0xA7, 0x70, 0xDA, 0x06, 0x77, 0xB0,
  0x37, 0x60, 0x3B, 0x77, 0x07, 0xA0, 0xC7, 0x70, 0xAA, 0x09, 0x77, 0x0D, 0xA0, 0x67, 0x60, 0x1B,
  0x0D, 0x80, 0x2C, 0x0B, 0x60, 0x4F, 0xB0, 0xB6, 0x07, 0xFB, 0x07, 0x60, 0xBA, 0x08, 0x77, 0x0E,
  0xA0, 0x57, 0x60, 0x1B, 0x02, 0x76, 0x05, 0xA0, 0xE7, 0x70, 0x8A, 0x0B, 0x77, 0x0B, 0xA0, 0x87,
  0x70, 0xEA, 0x05, 0x76, 0x02, 0xB0, 0x27, 0x60, 0x5A, 0x0E, 0x77, 0x09, 0xA0, 0xB7, 0x70, 0xCA,
  0x08, 0x77, 0xB0, 0xD8, 0x03, 0xC0, 0x75, 0x03, 0xFC, 0x06, 0x50, 0x6F, 0xC0, 0x35,
  // "Ë" (U+00CB)
  0x72, 0x81, 0x9E, 0xA3, 0x82, 0x5E, 0xD1, 0x71, 0x04, 0xA0, 0xE3, 0x0E, 0xA0, 0x47, 0x10, 0x7A,
  0x0C, 0x20, 0x2B, 0x02, 0x71, 0x82, 0x3E, 0xD3, 0x38, 0x1B, 0xE7, 0x80, 0xF4, 0x00, 0x9F, 0xC7,
  0x0C, 0xFB, 0x0C, 0x7B, 0x80, 0x4C, 0x07, 0x60, 0x3B, 0x77, 0x10, 0x6A, 0x0D, 0x77, 0x10, 0x9A,
  0x0A, 0x77, 0x10, 0xDA, 0x06, 0x77, 0x1B, 0x03, 0x77, 0x03, 0xB7, 0x71, 0x07, 0xA0, 0xC7, 0x71,
  0x0A, 0xA0, 0x97, 0x71, 0x0D, 0xA0, 0x67, 0x70, 0x1B, 0x0D, 0x80, 0x2C, 0x0B, 0x70, 0x4F, 0xB0,
  0xB7, 0x07, 0xFB, 0x07, 0x70, 0xBA, 0x08, 0x77, 0x10, 0xEA, 0x05, 0x77, 0x01, 0xB0, 0x27, 0x70,
  0x5A, 0x0E, 0x77, 0x10, 0x8A, 0x0B, 0x77, 0x10, 0xBA, 0x08, 0x77, 0x10, 0xEA, 0x05, 0x77, 0x02,
  0xB0, 0x27, 0x70, 0x5A, 0x0E, 0x77, 0x10, 0x9A, 0x0B, 0x77, 0x10, 0xCA, 0x08, 0x77, 0x1B, 0x0D,
  0x80, 0x3C, 0x07, 0x60, 0x3F, 0xC0, 0x66, 0x06, 0xFC, 0x03, 0x60,
  // "Ì" (U+00CC)
  0x71, 0x0F, 0x60, 0x37, 0x50, 0xDA, 0x0B, 0x75, 0x06, 0xB0, 0x17, 0x50, 0xCA, 0x05, 0x75, 0x03,
  0xA0, 0xB7, 0x60, 0x8A, 0x02, 0x76, 0x81, 0xCF, 0x88, 0x0C, 0x40, 0x0B, 0xF9, 0x0B, 0x60, 0xDF,
  0x90, 0x76, 0x81, 0x37, 0xAB, 0x81, 0x94, 0x17, 0x20, 0x3B, 0x75, 0x06, 0xA0, 0xC7, 0x50, 0xAA,
  0x09, 0x75, 0x0D, 0xA0, 0x67, 0x40, 0x1B, 0x03, 0x74, 0x04, 0xB7, 0x50, 0x7A, 0x0C, 0x75, 0x0A,
  0xA0, 0x97, 0x50, 0xEA, 0x05, 0x74, 0x01, 0xB0, 0x27, 0x40, 0x5A, 0x0E, 0x75, 0x08, 0xA0, 0xB7,
  0x50, 0xBA, 0x08, 0x75, 0x0E, 0xA0, 0x57, 0x40, 0x2B, 0x02, 0x74, 0x05, 0xA0, 0xE7, 0x50, 0x9A,
  0x0B, 0x75, 0x0C, 0xA0, 0x87, 0x5B, 0x04, 0x74, 0x03, 0xB0, 0x17, 0x40, 0x6A, 0x0D, 0x75, 0x09,
  0xA0, 0xA7, 0x50, 0xDA, 0x07, 0x73, 0x03, 0x06, 0xB0, 0x90, 0x37, 0x05, 0xFA, 0x01, 0x50, 0x9F,
  0x90, 0xD6,
  // "Í" (U+00CD)
  0x76, 0x83, 0x17, 0x77, 0x57, 0x60, 0xAB, 0x04, 0x75, 0x04, 0xB0, 0x57, 0x50, 0x10, 0xEA, 0x06,
  0x76, 0x0B, 0xA0, 0x67, 0x60, 0x9A, 0x05, 0x76, 0x82, 0x4F, 0xE4, 0x80, 0xD3, 0x00, 0xBF, 0x90,
  0xB7, 0x10, 0xDF, 0x90, 0x77, 0x18, 0x13, 0x7A, 0xB8, 0x19, 0x41, 0x74, 0x03, 0xB7, 0x70, 0x6A,
  0x0C, 0x77, 0x0A, 0xA0, 0x97, 0x70, 0xDA, 0x06, 0x76, 0x01, 0xB0, 0x37, 0x60, 0x4B, 0x77, 0x07,
  0xA0, 0xC7, 0x70, 0xAA, 0x09, 0x77, 0x0E, 0xA0, 0x57, 0x60, 0x1B, 0x02, 0x76, 0x05, 0xA0, 0xE7,
  0x70, 0x8A, 0x0B, 0x77, 0x0B, 0xA0, 0x87, 0x70, 0xEA, 0x05, 0x76, 0x02, 0xB0, 0x27, 0x60, 0x5A,
  0x0E, 0x77, 0x09, 0xA0, 0xB7, 0x70, 0xCA, 0x08, 0x77, 0xB0, 0x47, 0x60, 0x3B, 0x01, 0x76, 0x06,
  0xA0, 0xD7, 0x70, 0x9A, 0x0A, 0x77, 0x0D, 0xA0, 0x77, 0x50, 0x30, 0x6B, 0x09, 0x03, 0x72, 0x05,
  0xFA, 0x01, 0x70, 0x9F, 0x90, 0xD7, 0x10,
  // "Î" (U+00CE)
  0x74, 0x82, 0x47, 0x74, 0x75, 0x02, 0x0E, 0xA0, 0xC7, 0x50, 0xCC, 0x03, 0x73, 0x0A, 0xA0, 0x9A,
  0x09, 0x72, 0x08, 0xA8, 0x15, 0x0A, 0xA0, 0x17, 0x82, 0x7F, 0xE4, 0x28, 0x21, 0xEF, 0x76, 0x82,
  0x4F, 0xD3, 0x48, 0x14, 0xFE, 0x80, 0xC4, 0x00, 0xBF, 0x90, 0xB7, 0x0D, 0xF9, 0x07, 0x78, 0x13,
  0x7A, 0xB8, 0x19, 0x41, 0x73, 0x03, 0xB7, 0x60, 0x6A, 0x0C, 0x76, 0x0A, 0xA0, 0x97, 0x60, 0xDA,
  0x06, 0x75, 0x01, 0xB0, 0x37, 0x50, 0x4B, 0x76, 0x07, 0xA0, 0xC7, 0x60, 0xAA, 0x09, 0x76, 0x0E,
  0xA0, 0x57, 0x50, 0x1B, 0x02, 0x75, 0x05, 0xA0, 0xE7, 0x60, 0x8A, 0x0B, 0x76, 0x0B, 0xA0, 0x87,
  0x60, 0xEA, 0x05, 0x75, 0x02, 0xB0, 0x27, 0x50, 0x5A, 0x0E, 0x76, 0x09, 0xA0, 0xB7, 0x60, 0xCA,
  0x08, 0x76, 0xB0, 0x47, 0x50, 0x3B, 0x01, 0x75, 0x06, 0xA0, 0xD7, 0x60, 0x9A, 0x0A, 0x76, 0x0D,
  0xA0, 0x77, 0x40, 0x30, 0x6B, 0x09, 0x03, 0x71, 0x05, 0xFA, 0x01, 0x60, 0x9F, 0x90, 0xD7,
  // "Ï" (U+00CF)
  0x71, 0x81, 0x9E, 0xA3, 0x82, 0x5E, 0xD1, 0x70, 0x4A, 0x0E, 0x30, 0xEA, 0x04, 0x70, 0x7A, 0x0C,
  0x20, 0x2B, 0x02, 0x78, 0x23, 0xED, 0x33, 0x81, 0xBE, 0x78, 0x0F, 0x10, 0x0B, 0xF9, 0x0B, 0x71,
  0x0D, 0xF9, 0x07, 0x71, 0x81, 0x37, 0xAB, 0x81, 0x94, 0x17, 0x40, 0x3B, 0x77, 0x06, 0xA0, 0xC7,
  0x70, 0xAA, 0x09, 0x77, 0x0D, 0xA0, 0x67, 0x60, 0x1B, 0x03, 0x76, 0x04, 0xB7, 0x70, 0x7A, 0x0C,
  0x77, 0x0A, 0xA0, 0x97, 0x70, 0xEA, 0x05, 0x76, 0x01, 0xB0, 0x27, 0x60, 0x5A, 0x0E, 0x77, 0x08,
  0xA0, 0xB7, 0x70, 0xBA, 0x08, 0x77, 0x0E, 0xA0, 0x57, 0x60, 0x2B, 0x02, 0x76, 0x05, 0xA0, 0xE7,
  0x70, 0x9A, 0x0B, 0x77, 0x0C, 0xA0, 0x87, 0x7B, 0x04, 0x76, 0x03, 0xB0, 0x17, 0x60, 0x6A, 0x0D,
  0x77, 0x09, 0xA0, 0xA7, 0x70, 0xDA, 0x07, 0x75, 0x03, 0x06, 0xB0, 0x90, 0x37, 0x20, 0x5F, 0xA0,
  0x17, 0x09, 0xF9, 0x0D, 0x71,
  // "Ð" (U+00D0)
  0x60, 0x9D, 0x82, 0xED, 0xA5, 0x74, 0x0C, 0xFA, 0x0C, 0x02, 0x72, 0xB0, 0xFC, 0x0D, 0xC0, 0xE0,
  0x27, 0x03, 0xB0, 0x13, 0x02, 0x0A, 0xB0, 0xC7, 0x06, 0xA0, 0xD6, 0x09, 0xB0, 0x56, 0x09, 0xA0,
  0xA7, 0x0E, 0xA0, 0xB6, 0x0C, 0xA0, 0x77, 0x09, 0xA0, 0xE6, 0xB0, 0x47, 0x06, 0xB0, 0x14, 0x03,
  0xB0, 0x17, 0x05, 0xB0, 0x24, 0x06, 0xA0, 0xD7, 0x10, 0x4B, 0x03, 0x40, 0xAA, 0x0A, 0x71, 0x05,
  0xB0, 0x24, 0x0D, 0xA0, 0x77, 0x10, 0x5B, 0x02, 0x4B, 0x04, 0x71, 0x07, 0xB2, 0x07, 0xFA, 0x05,
  0x40, 0x9A, 0x0E, 0x20, 0xAF, 0xA0, 0x14, 0x0C, 0xA0, 0xB2, 0x81, 0xAC, 0xEA, 0x83, 0xDC, 0xCC,
  0xB5, 0x0E, 0xA0, 0x84, 0x0D, 0xA0, 0x67, 0x10, 0x3B, 0x05, 0x30, 0x1B, 0x03, 0x71, 0x08, 0xB0,
  0x13, 0x04, 0xB7, 0x20, 0xDA, 0x0B, 0x40, 0x7A, 0x0C, 0x71, 0x04, 0xB0, 0x54, 0x0B, 0xA0, 0x97,
  0x10, 0xBA, 0x0E, 0x50, 0xEA, 0x05, 0x70, 0x5B, 0x06, 0x40, 0x2B, 0x02, 0x60, 0x10, 0xDA, 0x0D,
  0x50, 0x5A, 0x0E, 0x70, 0xCB, 0x03, 0x50, 0x8A, 0x0B, 0x50, 0x10, 0xCB, 0x07, 0x60, 0xCA, 0x08,
  0x38, 0x11, 0x7E, 0xB0, 0x87, 0xB8, 0x2D, 0xCC, 0xDD, 0x06, 0x70, 0x3F, 0xB0, 0xB0, 0x27, 0x10,
  0x6E, 0x82, 0xEB, 0x82, 0x73,
  // "Ñ" (U+00D1)
  0x74, 0x83, 0x3C, 0xFD, 0x64, 0x81, 0xEF, 0x17, 0x40, 0x2D, 0x84, 0xA1, 0x07, 0xFC, 0x75, 0x0B,
  0xA0, 0xCB, 0x0E, 0x0D, 0xA0, 0x67, 0x40, 0x1A, 0x82, 0x30, 0x2C, 0xC0, 0xC7, 0x58, 0x16, 0xFA,
  0x48, 0x37, 0xDE, 0xA1, 0x80, 0xE5, 0x00, 0x9B, 0x06, 0x72, 0x0B, 0xA0, 0x76, 0x0C, 0xB0, 0xA7,
  0x20, 0xEA, 0x03, 0x6C, 0x0D, 0x71, 0x02, 0xB6, 0x03, 0xD0, 0x17, 0x05, 0xA0, 0xC6, 0x06, 0xD0,
  0x57, 0x09, 0xA0, 0x96, 0x09, 0xA0, 0xEA, 0x08, 0x70, 0xCA, 0x06, 0x60, 0xDA, 0x08, 0xA0, 0xB7,
  0xB0, 0x36, 0xB0, 0x2B, 0x60, 0x3B, 0x60, 0x3A, 0x81, 0xD0, 0xDA, 0x03, 0x50, 0x6A, 0x0C, 0x60,
  0x7A, 0x81, 0xA0, 0xAA, 0x06, 0x50, 0x9A, 0x08, 0x60, 0xAA, 0x81, 0x70, 0x6A, 0x0A, 0x50, 0xCA,
  0x05, 0x60, 0xDA, 0x81, 0x40, 0x3A, 0x0D, 0x5B, 0x02, 0x50, 0x1B, 0x01, 0x2B, 0x01, 0x30, 0x3A,
  0x0E, 0x60, 0x4A, 0x0D, 0x30, 0xBA, 0x05, 0x30, 0x7A, 0x0B, 0x60, 0x7A, 0x0A, 0x30, 0x8A, 0x08,
  0x30, 0xAA, 0x08, 0x60, 0xBA, 0x07, 0x30, 0x4A, 0x0C, 0x30, 0xDA, 0x04, 0x60, 0xEA, 0x04, 0x30,
  0x1B, 0x20, 0x1B, 0x01, 0x50, 0x1B, 0x50, 0xDA, 0x81, 0x30, 0x4A, 0x0D, 0x60, 0x5A, 0x0D, 0x50,
  0x9A, 0x81, 0x70, 0x7A, 0x0A, 0x60, 0x8A, 0x09, 0x50, 0x6A, 0x81, 0xA0, 0xAA, 0x07, 0x60, 0xBA,
  0x06, 0x50, 0x2A, 0x81, 0xE0, 0xCA, 0x04, 0x60, 0xEA, 0x03, 0x60, 0xEA, 0x02, 0xB6, 0x02, 0xB7,
  0x0B, 0xA0, 0x8A, 0x0D, 0x60, 0x5A, 0x0C, 0x70, 0x7A, 0x0E, 0xA0, 0x96, 0x09, 0xA0, 0x97, 0x04,
  0xD0, 0x66, 0x0C, 0xA0, 0x57, 0x1D, 0x03, 0x6B, 0x02, 0x71, 0x0C, 0xC6, 0x03, 0xA0, 0xE7, 0x20,
  0x9B, 0x0C, 0x60, 0x6A, 0x0B, 0x72, 0x05, 0xB0, 0x96,
  // "Ò" (U+00D2)
  0x74, 0x0F, 0x60, 0x37, 0x73, 0x0D, 0xA0, 0xB7, 0x73, 0x06, 0xB0, 0x17, 0x73, 0x0C, 0xA0, 0x57,
  0x73, 0x03, 0xA0, 0xB7, 0x74, 0x08, 0xA0, 0x27, 0x74, 0x81, 0xCF, 0x88, 0x0E, 0x30, 0x86, 0x28,
  0xCE, 0xFE, 0xB6, 0x75, 0x07, 0xF9, 0x0D, 0x02, 0x72, 0x0B, 0xC0, 0x0C, 0xC0, 0xE0, 0x17, 0x0B,
  0xB0, 0x80, 0x13, 0x08, 0xB0, 0x96, 0x09, 0xB0, 0x56, 0x0A, 0xB0, 0x14, 0x03, 0xB0, 0x67, 0x02,
  0xB0, 0x54, 0x0D, 0xA0, 0xB7, 0x20, 0xEA, 0x08, 0x30, 0x5B, 0x03, 0x72, 0x0B, 0xA0, 0xA3, 0x0C,
  0xA0, 0xB7, 0x30, 0xAA, 0x0B, 0x20, 0x3B, 0x04, 0x73, 0x0B, 0xA0, 0xB2, 0x09, 0xA0, 0xE7, 0x40,
  0xBA, 0x0A, 0x20, 0xEA, 0x09, 0x74, 0x0D, 0xA8, 0x19, 0x02, 0xB0, 0x57, 0x40, 0xEA, 0x81, 0x70,
  0x6B, 0x01, 0x73, 0x01, 0xB8, 0x15, 0x09, 0xA0, 0xD7, 0x40, 0x4B, 0x81, 0x30, 0xCA, 0x0A, 0x74,
  0x07, 0xB2, 0x0E, 0xA0, 0x87, 0x40, 0xBA, 0x0C, 0x2B, 0x07, 0x74, 0xB8, 0x17, 0x01, 0xB0, 0x57,
  0x30, 0x5B, 0x81, 0x20, 0x2B, 0x05, 0x73, 0x0A, 0xA0, 0xD2, 0x01, 0xB0, 0x57, 0x20, 0x1B, 0x06,
  0x20, 0x1B, 0x06, 0x72, 0x08, 0xA0, 0xE4, 0x0E, 0xA0, 0x87, 0x10, 0x2B, 0x07, 0x40, 0xBA, 0x0C,
  0x71, 0x0C, 0xA0, 0xD5, 0x07, 0xB0, 0x46, 0x0A, 0xB0, 0x45, 0x01, 0x0E, 0xA0, 0xE0, 0x53, 0x03,
  0x0B, 0xB0, 0x67, 0x06, 0xC8, 0x1E, 0xCD, 0xC0, 0x77, 0x20, 0x6F, 0x90, 0xE0, 0x47, 0x48, 0x62,
  0x8C, 0xEF, 0xEB, 0x67, 0x20,
  // "Ó" (U+00D3)
  0x77, 0x28, 0x31, 0x77, 0x75, 0x77, 0x20, 0xAB, 0x04, 0x77, 0x10, 0x4B, 0x05, 0x77, 0x10, 0x10,
  0xEA, 0x06, 0x77, 0x20, 0xBA, 0x06, 0x77, 0x20, 0x9A, 0x05, 0x77, 0x28, 0x24, 0xFE, 0x48, 0x0E,
  0x40, 0x86, 0x28, 0xCE, 0xFE, 0xB6, 0x75, 0x07, 0xF9, 0x0D, 0x02, 0x72, 0x0B, 0xC0, 0x0C, 0xC0,
  0xE0, 0x17, 0x0B, 0xB0, 0x80, 0x13, 0x08, 0xB0, 0x96, 0x09, 0xB0, 0x56, 0x0A, 0xB0, 0x14, 0x03,
  0xB0, 0x67, 0x02, 0xB0, 0x54, 0x0D, 0xA0, 0xB7, 0x20, 0xEA, 0x08, 0x30, 0x5B, 0x03, 0x72, 0x0B,
  0xA0, 0xA3, 0x0C, 0xA0, 0xB7, 0x30, 0xAA, 0x0B, 0x20, 0x3B, 0x04, 0x73, 0x0B, 0xA0, 0xB2, 0x09,
  0xA0, 0xE7, 0x40, 0xBA, 0x0A, 0x20, 0xEA, 0x09, 0x74, 0x0D, 0xA8, 0x19, 0x02, 0xB0, 0x57, 0x40,
  0xEA, 0x81, 0x70, 0x6B, 0x01, 0x73, 0x01, 0xB8, 0x15, 0x09, 0xA0, 0xD7, 0x40, 0x4B, 0x81, 0x30,
  0xCA, 0x0A, 0x74, 0x07, 0xB2, 0x0E, 0xA0, 0x87, 0x40, 0xBA, 0x0C, 0x2B, 0x07, 0x74, 0xB8, 0x17,
  0x01, 0xB0, 0x57, 0x30, 0x5B, 0x81, 0x20, 0x2B, 0x05, 0x73, 0x0A, 0xA0, 0xD2, 0x01, 0xB0, 0x57,
  0x20, 0x1B, 0x06, 0x20, 0x1B, 0x06, 0x72, 0x08, 0xA0, 0xE4, 0x0E, 0xA0, 0x87, 0x10, 0x2B, 0x07,
  0x40, 0xBA, 0x0C, 0x71, 0x0C, 0xA0, 0xD5, 0x07, 0xB0, 0x46, 0x0A, 0xB0, 0x45, 0x01, 0x0E, 0xA0,
  0xE0, 0x53, 0x03, 0x0B, 0xB0, 0x67, 0x06, 0xC8, 0x1E, 0xCD, 0xC0, 0x77, 0x20, 0x6F, 0x90, 0xE0,
  0x47, 0x48, 0x62, 0x8C, 0xEF, 0xEB, 0x67, 0x20,
  // "Ô" (U+00D4)
  0x76, 0x82, 0x47, 0x74, 0x77, 0x20, 0x20, 0xEA, 0x0C, 0x77, 0x20, 0xCC, 0x03, 0x77, 0x0A, 0xA0,
  0x9A, 0x09, 0x76, 0x08, 0xA8, 0x15, 0x0A, 0xA0, 0x17, 0x48, 0x27, 0xFE, 0x42, 0x82, 0x1E, 0xF7,
  0x73, 0x82, 0x4F, 0xD3, 0x48, 0x14, 0xFE, 0x80, 0xE1, 0x08, 0x62, 0x8C, 0xEF, 0xEB, 0x67, 0x50,
  0x7F, 0x90, 0xD0, 0x27, 0x20, 0xBC, 0x00, 0xCC, 0x0E, 0x01, 0x70, 0xBB, 0x08, 0x01, 0x30, 0x8B,
  0x09, 0x60, 0x9B, 0x05, 0x60, 0xAB, 0x01, 0x40, 0x3B, 0x06, 0x70, 0x2B, 0x05, 0x40, 0xDA, 0x0B,
  0x72, 0x0E, 0xA0, 0x83, 0x05, 0xB0, 0x37, 0x20, 0xBA, 0x0A, 0x30, 0xCA, 0x0B, 0x73, 0x0A, 0xA0,
  0xB2, 0x03, 0xB0, 0x47, 0x30, 0xBA, 0x0B, 0x20, 0x9A, 0x0E, 0x74, 0x0B, 0xA0, 0xA2, 0x0E, 0xA0,
  0x97, 0x40, 0xDA, 0x81, 0x90, 0x2B, 0x05, 0x74, 0x0E, 0xA8, 0x17, 0x06, 0xB0, 0x17, 0x30, 0x1B,
  0x81, 0x50, 0x9A, 0x0D, 0x74, 0x04, 0xB8, 0x13, 0x0C, 0xA0, 0xA7, 0x40, 0x7B, 0x20, 0xEA, 0x08,
  0x74, 0x0B, 0xA0, 0xC2, 0xB0, 0x77, 0x4B, 0x81, 0x70, 0x1B, 0x05, 0x73, 0x05, 0xB8, 0x12, 0x02,
  0xB0, 0x57, 0x30, 0xAA, 0x0D, 0x20, 0x1B, 0x05, 0x72, 0x01, 0xB0, 0x62, 0x01, 0xB0, 0x67, 0x20,
  0x8A, 0x0E, 0x40, 0xEA, 0x08, 0x71, 0x02, 0xB0, 0x74, 0x0B, 0xA0, 0xC7, 0x10, 0xCA, 0x0D, 0x50,
  0x7B, 0x04, 0x60, 0xAB, 0x04, 0x50, 0x10, 0xEA, 0x0E, 0x05, 0x30, 0x30, 0xBB, 0x06, 0x70, 0x6C,
  0x81, 0xEC, 0xDC, 0x07, 0x72, 0x06, 0xF9, 0x0E, 0x04, 0x74, 0x86, 0x28, 0xCE, 0xFE, 0xB6, 0x72,
  // "Õ" (U+00D5)
  0x73, 0x83, 0x3C, 0xFD, 0x64, 0x81, 0xEF, 0x17, 0x20, 0x2D, 0x84, 0xA1, 0x07, 0xFC, 0x73, 0x0B,
  0xA0, 0xCB, 0x0E, 0x0D, 0xA0, 0x67, 0x20, 0x1A, 0x82, 0x30, 0x2C, 0xC0, 0xC7, 0x38, 0x16, 0xFA,
  0x48, 0x37, 0xDE, 0xA1, 0x80, 0xE3, 0x08, 0x62, 0x8C, 0xEF, 0xEB, 0x67, 0x60, 0x7F, 0x90, 0xD0,
  0x27, 0x30, 0xBC, 0x00, 0xCC, 0x0E, 0x01, 0x71, 0x0B, 0xB0, 0x80, 0x13, 0x08, 0xB0, 0x97, 0x09,
  0xB0, 0x56, 0x0A, 0xB0, 0x15, 0x03, 0xB0, 0x67, 0x02, 0xB0, 0x55, 0x0D, 0xA0, 0xB7, 0x20, 0xEA,
  0x08, 0x40, 0x5B, 0x03, 0x72, 0x0B, 0xA0, 0xA4, 0x0C, 0xA0, 0xB7, 0x30, 0xAA, 0x0B, 0x30, 0x3B,
  0x04, 0x73, 0x0B, 0xA0, 0xB3, 0x09, 0xA0, 0xE7, 0x40, 0xBA, 0x0A, 0x30, 0xEA, 0x09, 0x74, 0x0D,
  0xA0, 0x92, 0x02, 0xB0, 0x57, 0x40, 0xEA, 0x07, 0x20, 0x6B, 0x01, 0x73, 0x01, 0xB0, 0x52, 0x09,
  0xA0, 0xD7, 0x40, 0x4B, 0x03, 0x20, 0xCA, 0x0A, 0x74, 0x07, 0xB3, 0x0E, 0xA0, 0x87, 0x40, 0xBA,
  0x0C, 0x3B, 0x07, 0x74, 0xB0, 0x72, 0x01, 0xB0, 0x57, 0x30, 0x5B, 0x02, 0x20, 0x2B, 0x05, 0x73,
  0x0A, 0xA0, 0xD3, 0x01, 0xB0, 0x57, 0x20, 0x1B, 0x06, 0x30, 0x1B, 0x06, 0x72, 0x08, 0xA0, 0xE5,
  0x0E, 0xA0, 0x87, 0x10, 0x2B, 0x07, 0x50, 0xBA, 0x0C, 0x71, 0x0C, 0xA0, 0xD6, 0x07, 0xB0, 0x46,
  0x0A, 0xB0, 0x46, 0x01, 0x0E, 0xA0, 0xE0, 0x53, 0x03, 0x0B, 0xB0, 0x67, 0x10, 0x6C, 0x81, 0xEC,
  0xDC, 0x07, 0x73, 0x06, 0xF9, 0x0E, 0x04, 0x75, 0x86, 0x28, 0xCE, 0xFE, 0xB6, 0x73,
  // "Ö" (U+00D6)
  0x73, 0x81, 0x9E, 0xA3, 0x82, 0x5E, 0xD1, 0x73, 0x04, 0xA0, 0xE3, 0x0E, 0xA0, 0x47, 0x30, 0x7A,
  0x0C, 0x20, 0x2B, 0x02, 0x73, 0x82, 0x3E, 0xD3, 0x38, 0x1B, 0xE7, 0x80, 0x98, 0x60, 0x86, 0x28,
  0xCE, 0xFE, 0xB6, 0x75, 0x07, 0xF9, 0x0D, 0x02, 0x72, 0x0B, 0xC0, 0x0C, 0xC0, 0xE0, 0x17, 0x0B,
  0xB0, 0x80, 0x13, 0x08, 0xB0, 0x96, 0x09, 0xB0, 0x56, 0x0A, 0xB0, 0x14, 0x03, 0xB0, 0x67, 0x02,
  0xB0, 0x54, 0x0D, 0xA0, 0xB7, 0x20, 0xEA, 0x08, 0x30, 0x5B, 0x03, 0x72, 0x0B, 0xA0, 0xA3, 0x0C,
  0xA0, 0xB7, 0x30, 0xAA, 0x0B, 0x20, 0x3B, 0x04, 0x73, 0x0B, 0xA0, 0xB2, 0x09, 0xA0, 0xE7, 0x40,
  0xBA, 0x0A, 0x20, 0xEA, 0x09, 0x74, 0x0D, 0xA8, 0x19, 0x02, 0xB0, 0x57, 0x40, 0xEA, 0x81, 0x70,
  0x6B, 0x01, 0x73, 0x01, 0xB8, 0x15, 0x09, 0xA0, 0xD7, 0x40, 0x4B, 0x81, 0x30, 0xCA, 0x0A, 0x74,
  0x07, 0xB2, 0x0E, 0xA0, 0x87, 0x40, 0xBA, 0x0C, 0x2B, 0x07, 0x74, 0xB8, 0x17, 0x01, 0xB0, 0x57,
  0x30, 0x5B, 0x81, 0x20, 0x2B, 0x05, 0x73, 0x0A, 0xA0, 0xD2, 0x01, 0xB0, 0x57, 0x20, 0x1B, 0x06,
  0x20, 0x1B, 0x06, 0x72, 0x08, 0xA0, 0xE4, 0x0E, 0xA0, 0x87, 0x10, 0x2B, 0x07, 0x40, 0xBA, 0x0C,
  0x71, 0x0C, 0xA0, 0xD5, 0x07, 0xB0, 0x46, 0x0A, 0xB0, 0x45, 0x01, 0x0E, 0xA0, 0xE0, 0x53, 0x03,
  0x0B, 0xB0, 0x67, 0x06, 0xC8, 0x1E, 0xCD, 0xC0, 0x77, 0x20, 0x6F, 0x90, 0xE0, 0x47, 0x48, 0x62,
  0x8C, 0xEF, 0xEB, 0x67, 0x20,
  // "×" (U+00D7)
  0x10, 0x40, 0x67, 0x38, 0x28, 0x40, 0x4A, 0x07, 0x71, 0x09, 0xA0, 0x05, 0xB0, 0x76, 0x09, 0xA8,
  0x2E, 0x40, 0x5B, 0x07, 0x40, 0x9A, 0x0E, 0x04, 0x30, 0x5B, 0x07, 0x20, 0x9A, 0x0E, 0x04, 0x50,
  0x5B, 0x07, 0x09, 0xB0, 0x47, 0x05, 0xE0, 0x47, 0x20, 0x6C, 0x04, 0x73, 0x09, 0xC0, 0x77, 0x20,
  0x9E, 0x07, 0x70, 0x9A, 0x81, 0xE4, 0x5B, 0x07, 0x50, 0x9A, 0x0E, 0x04, 0x20, 0x5B, 0x07, 0x30,
  0x9B, 0x04, 0x40, 0x5B, 0x81, 0x70, 0x7B, 0x04, 0x60, 0x5B, 0x83, 0x62, 0xDF, 0x47, 0x18, 0x55,
  0xFC, 0x10, 0x24, 0x73, 0x04, 0x01, 0x10,
  // "Ø" (U+00D8)
  0x77, 0x70, 0x17, 0x77, 0x18, 0x12, 0xE8, 0x74, 0x86, 0x17, 0xCE, 0xFE, 0xB5, 0x28, 0x2C, 0xFE,
  0x17, 0x20, 0x7F, 0x90, 0xC0, 0x9A, 0x05, 0x72, 0x0B, 0xC0, 0x0C, 0xE0, 0xA7, 0x20, 0xBB, 0x08,
  0x01, 0x20, 0x10, 0xAB, 0x0E, 0x01, 0x71, 0x08, 0xB0, 0x56, 0x0D, 0xA0, 0xE7, 0x10, 0x3B, 0x07,
  0x60, 0x4C, 0x04, 0x70, 0xCA, 0x0B, 0x70, 0xDC, 0x08, 0x60, 0x5B, 0x03, 0x60, 0x9D, 0x0A, 0x60,
  0xCA, 0x0A, 0x60, 0x4A, 0x08, 0x0D, 0xA0, 0xB5, 0x03, 0xB0, 0x45, 0x84, 0x1E, 0xFC, 0x0C, 0xA0,
  0xB5, 0x08, 0xA0, 0xE6, 0x0A, 0xA8, 0x12, 0x0C, 0xA0, 0xA5, 0x0D, 0xA0, 0x95, 0x05, 0xA0, 0x62,
  0x0D, 0xA0, 0x94, 0x02, 0xB0, 0x54, 0x82, 0x1E, 0xFB, 0x3B, 0x07, 0x40, 0x6B, 0x01, 0x48, 0x2B,
  0xFE, 0x12, 0x01, 0xB0, 0x54, 0x09, 0xA0, 0xE4, 0x06, 0xA0, 0x53, 0x04, 0xB0, 0x34, 0x0C, 0xA0,
  0xB3, 0x82, 0x2E, 0xFA, 0x40, 0x7B, 0x50, 0xEA, 0x09, 0x38, 0x2B, 0xFE, 0x14, 0x0A, 0xA0, 0xC5,
  0xB0, 0x72, 0x06, 0xA0, 0x45, 0x0E, 0xA0, 0x74, 0x01, 0xB8, 0x16, 0x02, 0xA0, 0x95, 0x04, 0xB0,
  0x34, 0x02, 0xB8, 0x35, 0x0C, 0xFD, 0x60, 0x9A, 0x0D, 0x50, 0x2B, 0x06, 0x07, 0xA0, 0x35, 0x01,
  0x0E, 0xA0, 0x75, 0x01, 0xB0, 0xBA, 0x08, 0x60, 0x8A, 0x0E, 0x01, 0x60, 0xEC, 0x0C, 0x60, 0x10,
  0xEA, 0x07, 0x70, 0xBC, 0x02, 0x60, 0xBA, 0x0D, 0x71, 0x07, 0xB0, 0x96, 0x0A, 0xB0, 0x47, 0x10,
  0x2B, 0x0E, 0x05, 0x30, 0x20, 0xBB, 0x07, 0x72, 0x0A, 0xD8, 0x1E, 0xCD, 0xC0, 0x77, 0x20, 0x6A,
  0x09, 0x0E, 0xF0, 0xE0, 0x47, 0x28, 0x93, 0x2E, 0xFA, 0x01, 0x7C, 0xEF, 0xEB, 0x67, 0x48, 0x23,
  0xDD, 0x17, 0x77, 0x10, 0x27, 0x77,
  // "Ù" (U+00D9)
  0x73, 0x0F, 0x60, 0x37, 0x74, 0x0D, 0xA0, 0xB7, 0x74, 0x06, 0xB0, 0x17, 0x74, 0x0C, 0xA0, 0x57,
  0x74, 0x03, 0xA0, 0xB7, 0x75, 0x08, 0xA0, 0x27, 0x75, 0x81, 0xCF, 0x88, 0x0E, 0x30, 0x0C, 0xA0,
  0x87, 0x10, 0x3B, 0x01, 0x5B, 0x05, 0x71, 0x06, 0xA0, 0xD5, 0x03, 0xB0, 0x17, 0x10, 0xAA, 0x0A,
  0x50, 0x6A, 0x0D, 0x72, 0x0D, 0xA0, 0x75, 0x0A, 0xA0, 0xA7, 0x10, 0x1B, 0x03, 0x50, 0xDA, 0x07,
  0x71, 0x04, 0xB5, 0x01, 0xB0, 0x47, 0x10, 0x7A, 0x0C, 0x50, 0x4B, 0x72, 0x0B, 0xA0, 0x95, 0x07,
  0xA0, 0xD7, 0x20, 0xEA, 0x05, 0x50, 0xBA, 0x09, 0x71, 0x02, 0xB0, 0x25, 0x0E, 0xA0, 0x67, 0x10,
  0x5A, 0x0E, 0x50, 0x2B, 0x03, 0x71, 0x08, 0xA0, 0xB5, 0x05, 0xB7, 0x20, 0xCA, 0x08, 0x50, 0x8A,
  0x0C, 0x72, 0x0E, 0xA0, 0x45, 0x0C, 0xA0, 0x87, 0x10, 0x3B, 0x01, 0x5B, 0x05, 0x71, 0x06, 0xA0,
  0xD5, 0x03, 0xB0, 0x27, 0x10, 0x9A, 0x0A, 0x50, 0x6A, 0x0E, 0x72, 0x0C, 0xA0, 0x75, 0x09, 0xA0,
  0xB7, 0x2B, 0x03, 0x50, 0xCA, 0x08, 0x71, 0x04, 0xB6, 0xB0, 0x57, 0x10, 0x8A, 0x0B, 0x50, 0x1B,
  0x03, 0x71, 0x0C, 0xA0, 0x75, 0x01, 0xB0, 0x37, 0x03, 0xB0, 0x26, 0xB0, 0x57, 0x0A, 0xA0, 0xA7,
  0x0D, 0xA0, 0xA6, 0x05, 0xB0, 0x37, 0x08, 0xB0, 0x84, 0x07, 0xB0, 0x97, 0x10, 0x10, 0xEC, 0x0D,
  0x0C, 0xC0, 0xB7, 0x30, 0x30, 0xEF, 0x90, 0x97, 0x58, 0x71, 0x7C, 0xEF, 0xEC, 0x93, 0x73,
  // "Ú" (U+00DA)
  0x77, 0x18, 0x31, 0x77, 0x75, 0x77, 0x30, 0xAB, 0x04, 0x77, 0x20, 0x4B, 0x05, 0x77, 0x20, 0x10,
  0xEA, 0x06, 0x77, 0x30, 0xBA, 0x06, 0x77, 0x30, 0x9A, 0x05, 0x77, 0x38, 0x24, 0xFE, 0x48, 0x0E,
  0x40, 0x0C, 0xA0, 0x87, 0x10, 0x3B, 0x01, 0x5B, 0x05, 0x71, 0x06, 0xA0, 0xD5, 0x03, 0xB0, 0x17,
  0x10, 0xAA, 0x0A, 0x50, 0x6A, 0x0D, 0x72, 0x0D, 0xA0, 0x75, 0x0A, 0xA0, 0xA7, 0x10, 0x1B, 0x03,
  0x50, 0xDA, 0x07, 0x71, 0x04, 0xB5, 0x01, 0xB0, 0x47, 0x10, 0x7A, 0x0C, 0x50, 0x4B, 0x72, 0x0B,
  0xA0, 0x95, 0x07, 0xA0, 0xD7, 0x20, 0xEA, 0x05, 0x50, 0xBA, 0x09, 0x71, 0x02, 0xB0, 0x25, 0x0E,
  0xA0, 0x67, 0x10, 0x5A, 0x0E, 0x50, 0x2B, 0x03, 0x71, 0x08, 0xA0, 0xB5, 0x05, 0xB7, 0x20, 0xCA,
  0x08, 0x50, 0x8A, 0x0C, 0x72, 0x0E, 0xA0, 0x45, 0x0C, 0xA0, 0x87, 0x10, 0x3B, 0x01, 0x5B, 0x05,
  0x71, 0x06, 0xA0, 0xD5, 0x03, 0xB0, 0x27, 0x10, 0x9A, 0x0A, 0x50, 0x6A, 0x0E, 0x72, 0x0C, 0xA0,
  0x75, 0x09, 0xA0, 0xB7, 0x2B, 0x03, 0x50, 0xCA, 0x08, 0x71, 0x04, 0xB6, 0xB0, 0x57, 0x10, 0x8A,
  0x0B, 0x50, 0x1B, 0x03, 0x71, 0x0C, 0xA0, 0x75, 0x01, 0xB0, 0x37, 0x03, 0xB0, 0x26, 0xB0, 0x57,
  0x0A, 0xA0, 0xA7, 0x0D, 0xA0, 0xA6, 0x05, 0xB0, 0x37, 0x08, 0xB0, 0x84, 0x07, 0xB0, 0x97, 0x10,
  0x10, 0xEC, 0x0D, 0x0C, 0xC0, 0xB7, 0x30, 0x30, 0xEF, 0x90, 0x97, 0x58, 0x71, 0x7C, 0xEF, 0xEC,
  0x93, 0x73,
  // "Û" (U+00DB)
  0x76, 0x82, 0x47, 0x74, 0x77, 0x30, 0x20, 0xEA, 0x0C, 0x77, 0x30, 0xCC, 0x03, 0x77, 0x10, 0xAA,
  0x09, 0xA0, 0x97, 0x70, 0x8A, 0x81, 0x50, 0xAA, 0x01, 0x75, 0x82, 0x7F, 0xE4, 0x28, 0x21, 0xEF,
  0x77, 0x48, 0x24, 0xFD, 0x34, 0x81, 0x4F, 0xE8, 0x0E, 0x00, 0x0C, 0xA0, 0x87, 0x10, 0x3B, 0x01,
  0x5B, 0x05, 0x71, 0x06, 0xA0, 0xD5, 0x03, 0xB0, 0x17, 0x10, 0xAA, 0x0A, 0x50, 0x6A, 0x0D, 0x72,
  0x0D, 0xA0, 0x75, 0x0A, 0xA0, 0xA7, 0x10, 0x1B, 0x03, 0x50, 0xDA, 0x07, 0x71, 0x04, 0xB5, 0x01,
  0xB0, 0x47, 0x10, 0x7A, 0x0C, 0x50, 0x4B, 0x72, 0x0B, 0xA0, 0x95, 0x07, 0xA0, 0xD7, 0x20, 0xEA,
  0x05, 0x50, 0xBA, 0x09, 0x71, 0x02, 0xB0, 0x25, 0x0E, 0xA0, 0x67, 0x10, 0x5A, 0x0E, 0x50, 0x2B,
  0x03, 0x71, 0x08, 0xA0, 0xB5, 0x05, 0xB7, 0x20, 0xCA, 0x08, 0x50, 0x8A, 0x0C, 0x72, 0x0E, 0xA0,
  0x45, 0x0C, 0xA0, 0x87, 0x10, 0x3B, 0x01, 0x5B, 0x05, 0x71, 0x06, 0xA0, 0xD5, 0x03, 0xB0, 0x27,
  0x10, 0x9A, 0x0A, 0x50, 0x6A, 0x0E, 0x72, 0x0C, 0xA0, 0x75, 0x09, 0xA0, 0xB7, 0x2B, 0x03, 0x50,
  0xCA, 0x08, 0x71, 0x04, 0xB6, 0xB0, 0x57, 0x10, 0x8A, 0x0B, 0x50, 0x1B, 0x03, 0x71, 0x0C, 0xA0,
  0x75, 0x01, 0xB0, 0x37, 0x03, 0xB0, 0x26, 0xB0, 0x57, 0x0A, 0xA0, 0xA7, 0x0D, 0xA0, 0xA6, 0x05,
  0xB0, 0x37, 0x08, 0xB0, 0x84, 0x07, 0xB0, 0x97, 0x10, 0x10, 0xEC, 0x0D, 0x0C, 0xC0, 0xB7, 0x30,
  0x30, 0xEF, 0x90, 0x97, 0x58, 0x71, 0x7C, 0xEF, 0xEC, 0x93, 0x73,
  // "Ü" (U+00DC)
  0x73, 0x81, 0x9E, 0xA3, 0x82, 0x5E, 0xD1, 0x74, 0x04, 0xA0, 0xE3, 0x0E, 0xA0, 0x47, 0x40, 0x7A,
  0x0C, 0x20, 0x2B, 0x02, 0x74, 0x82, 0x3E, 0xD3, 0x38, 0x1B, 0xE7, 0x80, 0x98, 0x60, 0x0C, 0xA0,
  0x87, 0x10, 0x3B, 0x01, 0x5B, 0x05, 0x71, 0x06, 0xA0, 0xD5, 0x03, 0xB0, 0x17, 0x10, 0xAA, 0x0A,
  0x50, 0x6A, 0x0D, 0x72, 0x0D, 0xA0, 0x75, 0x0A, 0xA0, 0xA7, 0x10, 0x1B, 0x03, 0x50, 0xDA, 0x07,
  0x71, 0x04, 0xB5, 0x01, 0xB0, 0x47, 0x10, 0x7A, 0x0C, 0x50, 0x4B, 0x72, 0x0B, 0xA0, 0x95, 0x07,
  0xA0, 0xD7, 0x20, 0xEA, 0x05, 0x50, 0xBA, 0x09, 0x71, 0x02, 0xB0, 0x25, 0x0E, 0xA0, 0x67, 0x10,
  0x5A, 0x0E, 0x50, 0x2B, 0x03, 0x71, 0x08, 0xA0, 0xB5, 0x05, 0xB7, 0x20, 0xCA, 0x08, 0x50, 0x8A,
  0x0C, 0x72, 0x0E, 0xA0, 0x45, 0x0C, 0xA0, 0x87, 0x10, 0x3B, 0x01, 0x5B, 0x05, 0x71, 0x06, 0xA0,
  0xD5, 0x03, 0xB0, 0x27, 0x10, 0x9A, 0x0A, 0x50, 0x6A, 0x0E, 0x72, 0x0C, 0xA0, 0x75, 0x09, 0xA0,
  0xB7, 0x2B, 0x03, 0x50, 0xCA, 0x08, 0x71, 0x04, 0xB6, 0xB0, 0x57, 0x10, 0x8A, 0x0B, 0x50, 0x1B,
  0x03, 0x71, 0x0C, 0xA0, 0x75, 0x01, 0xB0, 0x37, 0x03, 0xB0, 0x26, 0xB0, 0x57, 0x0A, 0xA0, 0xA7,
  0x0D, 0xA0, 0xA6, 0x05, 0xB0, 0x37, 0x08, 0xB0, 0x84, 0x07, 0xB0, 0x97, 0x10, 0x10, 0xEC, 0x0D,
  0x0C, 0xC0, 0xB7, 0x30, 0x30, 0xEF, 0x90, 0x97, 0x58, 0x71, 0x7C, 0xEF, 0xEC, 0x93, 0x73,
  // "Ý" (U+00DD)
  0x74, 0x83, 0x17, 0x77, 0x57, 0x50, 0xAB, 0x04, 0x74, 0x04, 0xB0, 0x57, 0x40, 0x10, 0xEA, 0x06,
  0x75, 0x0B, 0xA0, 0x67, 0x50, 0x9A, 0x05, 0x75, 0x82, 0x4F, 0xE4, 0x80, 0xC4, 0x00, 0x6A, 0x0E,
  0x71, 0x04, 0xB0, 0x04, 0xB7, 0x10, 0xCA, 0x81, 0xB0, 0x2B, 0x02, 0x60, 0x5B, 0x02, 0x2B, 0x04,
  0x60, 0xDA, 0x09, 0x30, 0xDA, 0x06, 0x50, 0x6A, 0x0E, 0x01, 0x30, 0xAA, 0x08, 0x50, 0xDA, 0x07,
  0x40, 0x8A, 0x0A, 0x40, 0x7A, 0x0D, 0x50, 0x6A, 0x0C, 0x30, 0x10, 0xEA, 0x05, 0x50, 0x4A, 0x0E,
  0x30, 0x8A, 0x0C, 0x60, 0x1B, 0x20, 0x10, 0xEA, 0x03, 0x70, 0xEA, 0x81, 0x20, 0x9A, 0x0A, 0x71,
  0x0C, 0xA0, 0x40, 0x2B, 0x02, 0x71, 0x0A, 0xA0, 0x60, 0xAA, 0x08, 0x72, 0x08, 0xA0, 0xBA, 0x0E,
  0x73, 0x05, 0xD0, 0x67, 0x30, 0x3C, 0x0C, 0x74, 0x01, 0xC0, 0x47, 0x50, 0xEA, 0x0B, 0x76, 0x0E,
  0xA0, 0x57, 0x50, 0x2B, 0x02, 0x75, 0x05, 0xA0, 0xE7, 0x60, 0x9A, 0x0B, 0x76, 0x0C, 0xA0, 0x87,
  0x6B, 0x04, 0x75, 0x03, 0xB0, 0x17, 0x50, 0x6A, 0x0D, 0x76, 0x09, 0xA0, 0xA7, 0x60, 0xDA, 0x07,
  0x76, 0xB0, 0x47, 0x50,
  // "Þ" (U+00DE)
  0x60, 0x9A, 0x0B, 0x77, 0x0C, 0xA0, 0x87, 0x7B, 0x05, 0x76, 0x03, 0xB0, 0x27, 0x60, 0x6A, 0x0E,
  0x77, 0x09, 0xA8, 0x4E, 0xCB, 0xA8, 0x47, 0x20, 0xDF, 0x90, 0xD0, 0x37, 0xFC, 0x03, 0x50, 0x3B,
  0x30, 0x30, 0x9B, 0x0C, 0x50, 0x7A, 0x0D, 0x50, 0x8B, 0x03, 0x40, 0xAA, 0x0A, 0x50, 0x1B, 0x07,
  0x40, 0xDA, 0x06, 0x60, 0xDA, 0x08, 0x30, 0x1B, 0x03, 0x60, 0xDA, 0x08, 0x30, 0x4B, 0x70, 0xEA,
  0x07, 0x30, 0x7A, 0x0C, 0x60, 0x1B, 0x05, 0x30, 0xBA, 0x09, 0x60, 0x5B, 0x01, 0x30, 0xEA, 0x06,
  0x60, 0xBA, 0x0C, 0x30, 0x1B, 0x03, 0x50, 0x5B, 0x05, 0x30, 0x5B, 0x50, 0x5B, 0x0B, 0x40, 0x8A,
  0x0C, 0x28, 0x11, 0x5A, 0xB0, 0xD0, 0x14, 0x0B, 0xFB, 0x0D, 0x02, 0x50, 0xEF, 0x90, 0xE0, 0x86,
  0x02, 0xB8, 0x4C, 0xCB, 0xA8, 0x57, 0x10, 0x5A, 0x0E, 0x77, 0x09, 0xA0, 0xB7, 0x70, 0xCA, 0x08,
  0x77, 0xB0, 0x47, 0x60, 0x3B, 0x01, 0x76, 0x06, 0xA0, 0xD7, 0x70,
  // "ß" (U+00DF)
  0x77, 0x18, 0x51, 0x7A, 0xBB, 0x83, 0x77, 0x30, 0x7F, 0x0A, 0x77, 0x10, 0x8F, 0xA0, 0x87, 0x60,
  0x4B, 0x83, 0x92, 0x03, 0xCB, 0x76, 0x0C, 0xA0, 0x94, 0x03, 0xB0, 0x37, 0x40, 0x3A, 0x0E, 0x01,
  0x5B, 0x03, 0x74, 0x09, 0xA0, 0x95, 0x02, 0xB0, 0x17, 0x40, 0xDA, 0x05, 0x50, 0x8A, 0x0C, 0x74,
  0x01, 0xB0, 0x14, 0x02, 0x0E, 0xA0, 0x57, 0x40, 0x4A, 0x0E, 0x40, 0x10, 0xDA, 0x0B, 0x75, 0x07,
  0xA0, 0xA3, 0x01, 0x0C, 0xA0, 0xC0, 0x17, 0x50, 0xBA, 0x07, 0x30, 0xCA, 0x0D, 0x01, 0x76, 0x0E,
  0xA0, 0x42, 0x0A, 0xA0, 0xD0, 0x17, 0x60, 0x1B, 0x81, 0x10, 0x3B, 0x03, 0x77, 0x05, 0xA0, 0xD2,
  0x09, 0xA0, 0x97, 0x71, 0x08, 0xA0, 0xA2, 0x0C, 0xA0, 0x67, 0x71, 0x0B, 0xA0, 0x62, 0x0C, 0xA0,
  0x77, 0x71, 0x0E, 0xA0, 0x32, 0x0A, 0xA0, 0xD7, 0x70, 0x2B, 0x30, 0x4B, 0x08, 0x76, 0x05, 0xA0,
  0xC4, 0x0B, 0xB0, 0x37, 0x50, 0x9A, 0x09, 0x40, 0x10, 0xEA, 0x0D, 0x75, 0x0C, 0xA0, 0x65, 0x05,
  0xB0, 0x77, 0x4B, 0x02, 0x60, 0xCA, 0x0D, 0x73, 0x03, 0xA0, 0xE7, 0x05, 0xB0, 0x27, 0x20, 0x6A,
  0x0B, 0x70, 0x1B, 0x03, 0x72, 0x09, 0xA0, 0x87, 0x01, 0xB0, 0x37, 0x20, 0xDA, 0x05, 0x70, 0x3B,
  0x01, 0x71, 0x01, 0xB0, 0x27, 0x0A, 0xA0, 0xD7, 0x20, 0x4A, 0x83, 0xE0, 0x87, 0x13, 0x07, 0xB0,
  0x67, 0x20, 0x7A, 0x81, 0xB0, 0xAA, 0x81, 0xDC, 0xEB, 0x0C, 0x73, 0x0A, 0xA8, 0x18, 0x0B, 0xF0,
  0xB0, 0x17, 0x30, 0xDA, 0x89, 0x04, 0x01, 0x8C, 0xEF, 0xDA, 0x57, 0x40, 0x1B, 0x01, 0x77, 0x60,
  0x4A, 0x0D, 0x77, 0x70, 0x8A, 0x0A, 0x77, 0x70, 0xCA, 0x06, 0x77, 0x60, 0x2B, 0x01, 0x77, 0x60,
  0xBA, 0x0A, 0x77, 0x38, 0x24, 0xDC, 0xEB, 0x03, 0x77, 0x30, 0x4D, 0x07, 0x77, 0x48, 0x43, 0xDF,
  0xEB, 0x47, 0x75,
  // "à" (U+00E0)
  0x70, 0xF6, 0x03, 0x77, 0x0D, 0xA0, 0xB7, 0x70, 0x6B, 0x01, 0x77, 0x0C, 0xA0, 0x57, 0x70, 0x3A,
  0x0B, 0x77, 0x10, 0x8A, 0x02, 0x77, 0x18, 0x1C, 0xF8, 0x80, 0xD3, 0x08, 0x42, 0x9D, 0xEC, 0x62,
  0x06, 0xA0, 0x45, 0x06, 0xE8, 0x18, 0x0B, 0xA0, 0x14, 0x06, 0xC0, 0xC0, 0xEA, 0x03, 0xA0, 0xD4,
  0x03, 0xB0, 0xC0, 0x22, 0x81, 0x7F, 0xDA, 0x0A, 0x40, 0xDA, 0x0D, 0x50, 0xCB, 0x07, 0x30, 0x6B,
  0x03, 0x50, 0x8B, 0x04, 0x30, 0xDA, 0x0A, 0x60, 0x7B, 0x01, 0x20, 0x3B, 0x03, 0x60, 0x8A, 0x0D,
  0x30, 0x8A, 0x0C, 0x70, 0x9A, 0x09, 0x30, 0xDA, 0x07, 0x70, 0xCA, 0x06, 0x20, 0x1B, 0x03, 0x7B,
  0x03, 0x20, 0x4B, 0x70, 0x3B, 0x30, 0x7A, 0x0D, 0x70, 0x7A, 0x0C, 0x30, 0x9A, 0x0B, 0x70, 0xCA,
  0x09, 0x30, 0xAA, 0x0A, 0x60, 0x3B, 0x06, 0x30, 0xAA, 0x09, 0x60, 0xAB, 0x02, 0x30, 0xAA, 0x0A,
  0x50, 0x3C, 0x40, 0x8A, 0x0D, 0x40, 0x10, 0xDB, 0x0C, 0x40, 0x5B, 0x06, 0x28, 0x22, 0xCF, 0xCA,
  0x08, 0x50, 0xEB, 0x00, 0xDA, 0x00, 0x8A, 0x05, 0x50, 0x5E, 0x81, 0x80, 0x9A, 0x02, 0x68, 0x44,
  0xBE, 0xEB, 0x32, 0x81, 0xBF, 0xE5,
  // "á" (U+00E1)
  0x75, 0x83, 0x17, 0x77, 0x57, 0x60, 0xAB, 0x04, 0x75, 0x04, 0xB0, 0x57, 0x50, 0x10, 0xEA, 0x06,
  0x76, 0x0B, 0xA0, 0x67, 0x60, 0x9A, 0x05, 0x76, 0x82, 0x4F, 0xE4, 0x80, 0xD4, 0x08, 0x42, 0x9D,
  0xEC, 0x62, 0x06, 0xA0, 0x45, 0x06, 0xE8, 0x18, 0x0B, 0xA0, 0x14, 0x06, 0xC0, 0xC0, 0xEA, 0x03,
  0xA0, 0xD4, 0x03, 0xB0, 0xC0, 0x22, 0x81, 0x7F, 0xDA, 0x0A, 0x40, 0xDA, 0x0D, 0x50, 0xCB, 0x07,
  0x30, 0x6B, 0x03, 0x50, 0x8B, 0x04, 0x30, 0xDA, 0x0A, 0x60, 0x7B, 0x01, 0x20, 0x3B, 0x03, 0x60,
  0x8A, 0x0D, 0x30, 0x8A, 0x0C, 0x70, 0x9A, 0x09, 0x30, 0xDA, 0x07, 0x70, 0xCA, 0x06, 0x20, 0x1B,
  0x03, 0x7B, 0x03, 0x20, 0x4B, 0x70, 0x3B, 0x30, 0x7A, 0x0D, 0x70, 0x7A, 0x0C, 0x30, 0x9A, 0x0B,
  0x70, 0xCA, 0x09, 0x30, 0xAA, 0x0A, 0x60, 0x3B, 0x06, 0x30, 0xAA, 0x09, 0x60, 0xAB, 0x02, 0x30,
  0xAA, 0x0A, 0x50, 0x3C, 0x40, 0x8A, 0x0D, 0x40, 0x10, 0xDB, 0x0C, 0x40, 0x5B, 0x06, 0x28, 0x22,
  0xCF, 0xCA, 0x08, 0x50, 0xEB, 0x00, 0xDA, 0x00, 0x8A, 0x05, 0x50, 0x5E, 0x81, 0x80, 0x9A, 0x02,
  0x68, 0x44, 0xBE, 0xEB, 0x32, 0x81, 0xBF, 0xE5,
  // "â" (U+00E2)
  0x73, 0x82, 0x47, 0x74, 0x76, 0x02, 0x0E, 0xA0, 0xC7, 0x60, 0xCC, 0x03, 0x74, 0x0A, 0xA0, 0x9A,
  0x09, 0x73, 0x08, 0xA8, 0x15, 0x0A, 0xA0, 0x17, 0x18, 0x27, 0xFE, 0x42, 0x82, 0x1E, 0xF7, 0x78,
  0x24, 0xFD, 0x34, 0x81, 0x4F, 0xE8, 0x0D, 0x00, 0x84, 0x29, 0xDE, 0xC6, 0x20, 0x6A, 0x04, 0x50,
  0x6E, 0x81, 0x80, 0xBA, 0x01, 0x40, 0x6C, 0x0C, 0x0E, 0xA0, 0x3A, 0x0D, 0x40, 0x3B, 0x0C, 0x02,
  0x28, 0x17, 0xFD, 0xA0, 0xA4, 0x0D, 0xA0, 0xD5, 0x0C, 0xB0, 0x73, 0x06, 0xB0, 0x35, 0x08, 0xB0,
  0x43, 0x0D, 0xA0, 0xA6, 0x07, 0xB0, 0x12, 0x03, 0xB0, 0x36, 0x08, 0xA0, 0xD3, 0x08, 0xA0, 0xC7,
  0x09, 0xA0, 0x93, 0x0D, 0xA0, 0x77, 0x0C, 0xA0, 0x62, 0x01, 0xB0, 0x37, 0xB0, 0x32, 0x04, 0xB7,
  0x03, 0xB3, 0x07, 0xA0, 0xD7, 0x07, 0xA0, 0xC3, 0x09, 0xA0, 0xB7, 0x0C, 0xA0, 0x93, 0x0A, 0xA0,
  0xA6, 0x03, 0xB0, 0x63, 0x0A, 0xA0, 0x96, 0x0A, 0xB0, 0x23, 0x0A, 0xA0, 0xA5, 0x03, 0xC4, 0x08,
  0xA0, 0xD4, 0x01, 0x0D, 0xB0, 0xC4, 0x05, 0xB0, 0x62, 0x82, 0x2C, 0xFC, 0xA0, 0x85, 0x0E, 0xB0,
  0x0D, 0xA0, 0x08, 0xA0, 0x55, 0x05, 0xE8, 0x18, 0x09, 0xA0, 0x26, 0x84, 0x4B, 0xEE, 0xB3, 0x28,
  0x1B, 0xFE, 0x50,
  // "ã" (U+00E3)
  0x78, 0x33, 0xCF, 0xD6, 0x48, 0x1E, 0xF1, 0x60, 0x2D, 0x84, 0xA1, 0x07, 0xFC, 0x70, 0xBA, 0x0C,
  0xB0, 0xE0, 0xDA, 0x06, 0x60, 0x1A, 0x82, 0x30, 0x2C, 0xC0, 0xC7, 0x81, 0x6F, 0xA4, 0x83, 0x7D,
  0xEA, 0x18, 0x0D, 0x20, 0x84, 0x29, 0xDE, 0xC6, 0x20, 0x6A, 0x04, 0x60, 0x6E, 0x81, 0x80, 0xBA,
  0x01, 0x50, 0x6C, 0x0C, 0x0E, 0xA0, 0x3A, 0x0D, 0x50, 0x3B, 0x0C, 0x02, 0x28, 0x17, 0xFD, 0xA0,
  0xA5, 0x0D, 0xA0, 0xD5, 0x0C, 0xB0, 0x74, 0x06, 0xB0, 0x35, 0x08, 0xB0, 0x44, 0x0D, 0xA0, 0xA6,
  0x07, 0xB0, 0x13, 0x03, 0xB0, 0x36, 0x08, 0xA0, 0xD4, 0x08, 0xA0, 0xC7, 0x09, 0xA0, 0x94, 0x0D,
  0xA0, 0x77, 0x0C, 0xA0, 0x63, 0x01, 0xB0, 0x37, 0xB0, 0x33, 0x04, 0xB7, 0x03, 0xB4, 0x07, 0xA0,
  0xD7, 0x07, 0xA0, 0xC4, 0x09, 0xA0, 0xB7, 0x0C, 0xA0, 0x94, 0x0A, 0xA0, 0xA6, 0x03, 0xB0, 0x64,
  0x0A, 0xA0, 0x96, 0x0A, 0xB0, 0x24, 0x0A, 0xA0, 0xA5, 0x03, 0xC5, 0x08, 0xA0, 0xD4, 0x01, 0x0D,
  0xB0, 0xC5, 0x05, 0xB0, 0x62, 0x82, 0x2C, 0xFC, 0xA0, 0x86, 0x0E, 0xB0, 0x0D, 0xA0, 0x08, 0xA0,
  0x56, 0x05, 0xE8, 0x18, 0x09, 0xA0, 0x27, 0x84, 0x4B, 0xEE, 0xB3, 0x28, 0x1B, 0xFE, 0x60,
  // "ä" (U+00E4)
  0x78, 0x19, 0xEA, 0x38, 0x25, 0xED, 0x17, 0x04, 0xA0, 0xE3, 0x0E, 0xA0, 0x47, 0x07, 0xA0, 0xC2,
  0x02, 0xB0, 0x27, 0x82, 0x3E, 0xD3, 0x38, 0x1B, 0xE7, 0x80, 0xF2, 0x08, 0x42, 0x9D, 0xEC, 0x62,
  0x06, 0xA0, 0x45, 0x06, 0xE8, 0x18, 0x0B, 0xA0, 0x14, 0x06, 0xC0, 0xC0, 0xEA, 0x03, 0xA0, 0xD4,
  0x03, 0xB0, 0xC0, 0x22, 0x81, 0x7F, 0xDA, 0x0A, 0x40, 0xDA, 0x0D, 0x50, 0xCB, 0x07, 0x30, 0x6B,
  0x03, 0x50, 0x8B, 0x04, 0x30, 0xDA, 0x0A, 0x60, 0x7B, 0x01, 0x20, 0x3B, 0x03, 0x60, 0x8A, 0x0D,
  0x30, 0x8A, 0x0C, 0x70, 0x9A, 0x09, 0x30, 0xDA, 0x07, 0x70, 0xCA, 0x06, 0x20, 0x1B, 0x03, 0x7B,
  0x03, 0x20, 0x4B, 0x70, 0x3B, 0x30, 0x7A, 0x0D, 0x70, 0x7A, 0x0C, 0x30, 0x9A, 0x0B, 0x70, 0xCA,
  0x09, 0x30, 0xAA, 0x0A, 0x60, 0x3B, 0x06, 0x30, 0xAA, 0x09, 0x60, 0xAB, 0x02, 0x30, 0xAA, 0x0A,
  0x50, 0x3C, 0x40, 0x8A, 0x0D, 0x40, 0x10, 0xDB, 0x0C, 0x40, 0x5B, 0x06, 0x28, 0x22, 0xCF, 0xCA,
  0x08, 0x50, 0xEB, 0x00, 0xDA, 0x00, 0x8A, 0x05, 0x50, 0x5E, 0x81, 0x80, 0x9A, 0x02, 0x68, 0x44,
  0xBE, 0xEB, 0x32, 0x81, 0xBF, 0xE5,
  // "å" (U+00E5)
  0x72, 0x84, 0x7D, 0xFE, 0x91, 0x74, 0x0A, 0xA0, 0xDA, 0x0D, 0x01, 0x72, 0x87, 0x4F, 0xE2, 0x01,
  0xBF, 0x77, 0x28, 0x17, 0xF8, 0x38, 0x14, 0xFB, 0x72, 0x81, 0x7F, 0x83, 0x81, 0x4F, 0xB7, 0x28,
  0x74, 0xFE, 0x20, 0x1C, 0xF7, 0x73, 0x0B, 0xA0, 0xEA, 0x0D, 0x01, 0x74, 0x84, 0x8D, 0xFE, 0x91,
  0x80, 0xD1, 0x08, 0x42, 0x9D, 0xEC, 0x62, 0x06, 0xA0, 0x45, 0x06, 0xE8, 0x18, 0x0B, 0xA0, 0x14,
  0x06, 0xC0, 0xC0, 0xEA, 0x03, 0xA0, 0xD4, 0x03, 0xB0, 0xC0, 0x22, 0x81, 0x7F, 0xDA, 0x0A, 0x40,
  0xDA, 0x0D, 0x50, 0xCB, 0x07, 0x30, 0x6B, 0x03, 0x50, 0x8B, 0x04, 0x30, 0xDA, 0x0A, 0x60, 0x7B,
  0x01, 0x20, 0x3B, 0x03, 0x60, 0x8A, 0x0D, 0x30, 0x8A, 0x0C, 0x70, 0x9A, 0x09, 0x30, 0xDA, 0x07,
  0x70, 0xCA, 0x06, 0x20, 0x1B, 0x03, 0x7B, 0x03, 0x20, 0x4B, 0x70, 0x3B, 0x30, 0x7A, 0x0D, 0x70,
  0x7A, 0x0C, 0x30, 0x9A, 0x0B, 0x70, 0xCA, 0x09, 0x30, 0xAA, 0x0A, 0x60, 0x3B, 0x06, 0x30, 0xAA,
  0x09, 0x60, 0xAB, 0x02, 0x30, 0xAA, 0x0A, 0x50, 0x3C, 0x40, 0x8A, 0x0D, 0x40, 0x10, 0xDB, 0x0C,
  0x40, 0x5B, 0x06, 0x28, 0x22, 0xCF, 0xCA, 0x08, 0x50, 0xEB, 0x00, 0xDA, 0x00, 0x8A, 0x05, 0x50,
  0x5E, 0x81, 0x80, 0x9A, 0x02, 0x68, 0x44, 0xBE, 0xEB, 0x32, 0x81, 0xBF, 0xE5,
  // "æ" (U+00E6)
  0x68, 0x43, 0xAE, 0xEC, 0x42, 0x89, 0x0E, 0xF5, 0x04, 0xBE, 0xEC, 0x57, 0x06, 0xE0, 0x40, 0x3A,
  0x02, 0x09, 0xE0, 0x85, 0x06, 0xC8, 0x3C, 0xEF, 0xC8, 0xA0, 0xAA, 0x0E, 0x0C, 0xC0, 0x23, 0x03,
  0xB0, 0xB0, 0x12, 0x81, 0xBF, 0xEB, 0x0E, 0x05, 0x20, 0x10, 0xEA, 0x06, 0x30, 0xDA, 0x0D, 0x40,
  0x3D, 0x03, 0x40, 0xAA, 0x07, 0x20, 0x6B, 0x02, 0x5C, 0x07, 0x50, 0xAA, 0x05, 0x20, 0xDA, 0x09,
  0x60, 0xEA, 0x0D, 0x60, 0xEA, 0x81, 0x20, 0x4B, 0x02, 0x6B, 0x07, 0x50, 0xAA, 0x0C, 0x20, 0x9A,
  0x0C, 0x60, 0x1B, 0x01, 0x30, 0x40, 0xCB, 0x02, 0x20, 0xEA, 0x07, 0x60, 0x3A, 0x83, 0xE9, 0xAC,
  0xEB, 0x0E, 0x04, 0x20, 0x2B, 0x03, 0x60, 0x6F, 0xA0, 0xA0, 0x13, 0x05, 0xA0, 0xE7, 0x09, 0xB8,
  0x4E, 0xEC, 0xA6, 0x15, 0x08, 0xA0, 0xC7, 0x0E, 0xA0, 0x47, 0x40, 0x9A, 0x0A, 0x60, 0x3B, 0x02,
  0x74, 0x0A, 0xA0, 0x96, 0x09, 0xB0, 0x17, 0x40, 0xBA, 0x08, 0x50, 0x10, 0xEB, 0x02, 0x74, 0x0B,
  0xA0, 0x95, 0x08, 0xC0, 0x57, 0x40, 0x9A, 0x0C, 0x40, 0x4D, 0x0B, 0x74, 0x06, 0xB0, 0x52, 0x82,
  0x5E, 0xDD, 0xC0, 0x74, 0x81, 0x4A, 0x83, 0x01, 0xC0, 0xD0, 0xEA, 0x82, 0x3E, 0xF9, 0xB8, 0x2E,
  0xCC, 0xEA, 0x07, 0x40, 0x7D, 0x81, 0xE3, 0x1A, 0x04, 0x07, 0xF9, 0x05, 0x58, 0x65, 0xCF, 0xD9,
  0x10, 0x3A, 0x89, 0x02, 0x04, 0xBE, 0xFE, 0xB7, 0x14,
  // "ç" (U+00E7)
  0x78, 0x61, 0x8C, 0xEE, 0xDA, 0x46, 0x05, 0x0E, 0xE0, 0xE5, 0x05, 0xC0, 0xD0, 0xCA, 0x09, 0x40,
  0x3B, 0x0B, 0x02, 0x30, 0x70, 0x34, 0x0D, 0xA0, 0xB7, 0x30, 0x7A, 0x0E, 0x01, 0x73, 0x0E, 0xA0,
  0x77, 0x30, 0x5A, 0x0E, 0x74, 0x0A, 0xA0, 0x97, 0x40, 0xEA, 0x05, 0x73, 0x03, 0xB0, 0x17, 0x30,
  0x5A, 0x0D, 0x74, 0x08, 0xA0, 0xB7, 0x40, 0x9A, 0x09, 0x74, 0x0A, 0xA0, 0x97, 0x40, 0xAA, 0x09,
  0x74, 0x09, 0xA0, 0xB7, 0x40, 0x7A, 0x0E, 0x01, 0x73, 0x02, 0xB0, 0xB0, 0x13, 0x06, 0x08, 0x50,
  0xAC, 0x00, 0xCA, 0x0A, 0x50, 0x10, 0xCF, 0x0A, 0x78, 0x56, 0xCE, 0xFD, 0xA5, 0x72, 0x00, 0x77,
  0x58, 0x18, 0xF7, 0x74, 0x82, 0x2F, 0xE1, 0x74, 0x09, 0xB0, 0x67, 0x40, 0x20, 0xCA, 0x02, 0x74,
  0x04, 0xA0, 0x67, 0x40, 0x6A, 0x05, 0x78, 0x63, 0x12, 0x6E, 0xFE, 0x16, 0x01, 0xE0, 0x57, 0x10,
  0xDA, 0x81, 0xD9, 0x27, 0x10,
  // "è" (U+00E8)
  0x60, 0xF6, 0x03, 0x74, 0x0D, 0xA0, 0xB7, 0x40, 0x6B, 0x01, 0x74, 0x0C, 0xA0, 0x57, 0x40, 0x3A,
  0x0B, 0x75, 0x08, 0xA0, 0x27, 0x58, 0x1C, 0xF8, 0x80, 0xC3, 0x08, 0x51, 0x8C, 0xEF, 0xC7, 0x70,
  0x50, 0xEE, 0x0C, 0x50, 0x6B, 0x81, 0xEC, 0xEB, 0x07, 0x30, 0x3B, 0x09, 0x30, 0xAA, 0x0B, 0x20,
  0x10, 0xEA, 0x08, 0x40, 0x4A, 0x0C, 0x20, 0x7A, 0x0C, 0x50, 0x5A, 0x82, 0xB0, 0x1E, 0xA0, 0x35,
  0x0A, 0xA8, 0x18, 0x06, 0xA0, 0xB5, 0x07, 0xB8, 0x12, 0x0B, 0xA0, 0x62, 0x81, 0x15, 0xCB, 0x81,
  0x70, 0x1B, 0x81, 0xDC, 0xED, 0x08, 0x20, 0x4F, 0xA0, 0xC0, 0x43, 0x07, 0xC8, 0x3E, 0xDB, 0x83,
  0x50, 0x9A, 0x0A, 0x74, 0x0A, 0xA0, 0x97, 0x40, 0xBA, 0x07, 0x74, 0x0B, 0xA0, 0x87, 0x40, 0xAA,
  0x0B, 0x74, 0x07, 0xB0, 0x17, 0x30, 0x2B, 0x0C, 0x02, 0x38, 0x12, 0x7B, 0x40, 0x9C, 0x81, 0xDC,
  0xDA, 0x0D, 0x50, 0xBF, 0x90, 0xB6, 0x86, 0x5B, 0xEF, 0xEC, 0x93, 0x40,
  // "é" (U+00E9)
  0x74, 0x83, 0x17, 0x77, 0x57, 0x40, 0xAB, 0x04, 0x73, 0x04, 0xB0, 0x57, 0x30, 0x10, 0xEA, 0x06,
  0x74, 0x0B, 0xA0, 0x67, 0x40, 0x9A, 0x05, 0x74, 0x82, 0x4F, 0xE4, 0x80, 0xC7, 0x08, 0x51, 0x8C,
  0xEF, 0xC7, 0x71, 0x05, 0x0E, 0xE0, 0xC6, 0x06, 0xB8, 0x1E, 0xCE, 0xB0, 0x74, 0x03, 0xB0, 0x93,
  0x0A, 0xA0, 0xB3, 0x01, 0x0E, 0xA0, 0x84, 0x04, 0xA0, 0xC3, 0x07, 0xA0, 0xC5, 0x05, 0xA0, 0xB2,
  0x01, 0x0E, 0xA0, 0x35, 0x0A, 0xA0, 0x82, 0x06, 0xA0, 0xB5, 0x07, 0xB0, 0x22, 0x0B, 0xA0, 0x62,
  0x81, 0x15, 0xCB, 0x07, 0x20, 0x1B, 0x81, 0xDC, 0xED, 0x08, 0x30, 0x4F, 0xA0, 0xC0, 0x44, 0x07,
  0xC8, 0x3E, 0xDB, 0x83, 0x60, 0x9A, 0x0A, 0x75, 0x0A, 0xA0, 0x97, 0x50, 0xBA, 0x07, 0x75, 0x0B,
  0xA0, 0x87, 0x50, 0xAA, 0x0B, 0x75, 0x07, 0xB0, 0x17, 0x40, 0x2B, 0x0C, 0x02, 0x38, 0x12, 0x7B,
  0x50, 0x9C, 0x81, 0xDC, 0xDA, 0x0D, 0x60, 0xBF, 0x90, 0xB7, 0x86, 0x5B, 0xEF, 0xEC, 0x93, 0x50,
  // "ê" (U+00EA)
  0x72, 0x82, 0x47, 0x74, 0x73, 0x02, 0x0E, 0xA0, 0xC7, 0x30, 0xCC, 0x03, 0x71, 0x0A, 0xA0, 0x9A,
  0x09, 0x70, 0x8A, 0x81, 0x50, 0xAA, 0x01, 0x58, 0x27, 0xFE, 0x42, 0x82, 0x1E, 0xF7, 0x48, 0x24,
  0xFD, 0x34, 0x81, 0x4F, 0xE8, 0x0C, 0x00, 0x85, 0x18, 0xCE, 0xFC, 0x77, 0x05, 0x0E, 0xE0, 0xC5,
  0x06, 0xB8, 0x1E, 0xCE, 0xB0, 0x73, 0x03, 0xB0, 0x93, 0x0A, 0xA0, 0xB2, 0x01, 0x0E, 0xA0, 0x84,
  0x04, 0xA0, 0xC2, 0x07, 0xA0, 0xC5, 0x05, 0xA8, 0x2B, 0x01, 0xEA, 0x03, 0x50, 0xAA, 0x81, 0x80,
  0x6A, 0x0B, 0x50, 0x7B, 0x81, 0x20, 0xBA, 0x06, 0x28, 0x11, 0x5C, 0xB8, 0x17, 0x01, 0xB8, 0x1D,
  0xCE, 0xD0, 0x82, 0x04, 0xFA, 0x0C, 0x04, 0x30, 0x7C, 0x83, 0xED, 0xB8, 0x35, 0x09, 0xA0, 0xA7,
  0x40, 0xAA, 0x09, 0x74, 0x0B, 0xA0, 0x77, 0x40, 0xBA, 0x08, 0x74, 0x0A, 0xA0, 0xB7, 0x40, 0x7B,
  0x01, 0x73, 0x02, 0xB0, 0xC0, 0x23, 0x81, 0x27, 0xB4, 0x09, 0xC8, 0x1D, 0xCD, 0xA0, 0xD5, 0x0B,
  0xF9, 0x0B, 0x68, 0x65, 0xBE, 0xFE, 0xC9, 0x34,
  // "ë" (U+00EB)
  0x78, 0x19, 0xEA, 0x38, 0x25, 0xED, 0x16, 0x04, 0xA0, 0xE3, 0x0E, 0xA0, 0x46, 0x07, 0xA0, 0xC2,
  0x02, 0xB0, 0x26, 0x82, 0x3E, 0xD3, 0x38, 0x1B, 0xE7, 0x80, 0xE6, 0x08, 0x51, 0x8C, 0xEF, 0xC7,
  0x72, 0x05, 0x0E, 0xE0, 0xC7, 0x06, 0xB8, 0x1E, 0xCE, 0xB0, 0x75, 0x03, 0xB0, 0x93, 0x0A, 0xA0,
  0xB4, 0x01, 0x0E, 0xA0, 0x84, 0x04, 0xA0, 0xC4, 0x07, 0xA0, 0xC5, 0x05, 0xA0, 0xB3, 0x01, 0x0E,
  0xA0, 0x35, 0x0A, 0xA0, 0x83, 0x06, 0xA0, 0xB5, 0x07, 0xB0, 0x23, 0x0B, 0xA0, 0x62, 0x81, 0x15,
  0xCB, 0x07, 0x30, 0x1B, 0x81, 0xDC, 0xED, 0x08, 0x40, 0x4F, 0xA0, 0xC0, 0x45, 0x07, 0xC8, 0x3E,
  0xDB, 0x83, 0x70, 0x9A, 0x0A, 0x76, 0x0A, 0xA0, 0x97, 0x60, 0xBA, 0x07, 0x76, 0x0B, 0xA0, 0x87,
  0x60, 0xAA, 0x0B, 0x76, 0x07, 0xB0, 0x17, 0x50, 0x2B, 0x0C, 0x02, 0x38, 0x12, 0x7B, 0x60, 0x9C,
  0x81, 0xDC, 0xDA, 0x0D, 0x70, 0xBF, 0x90, 0xB7, 0x18, 0x65, 0xBE, 0xFE, 0xC9, 0x36,
  // "ì" (U+00EC)
  0x30, 0xF6, 0x03, 0x50, 0xDA, 0x0B, 0x50, 0x6B, 0x01, 0x50, 0xCA, 0x05, 0x50, 0x3A, 0x0B, 0x60,
  0x8A, 0x02, 0x68, 0x1C, 0xF8, 0x77, 0x71, 0x03, 0xA0, 0xE5, 0x06, 0xA0, 0xB5, 0x0A, 0xA0, 0x85,
  0x0D, 0xA0, 0x54, 0x01, 0xB0, 0x24, 0x04, 0xA0, 0xE5, 0x07, 0xA0, 0xB5, 0x0A, 0xA0, 0x85, 0x0D,
  0xA0, 0x44, 0x01, 0xB0, 0x14, 0x04, 0xA0, 0xD5, 0x07, 0xA0, 0xA5, 0x0B, 0xA0, 0x75, 0x0E, 0xA0,
  0x44, 0x02, 0xB0, 0x14, 0x05, 0xA0, 0xD5, 0x08, 0xA0, 0xA5, 0x0B, 0xA0, 0x65, 0x0E, 0xA0, 0x34,
  0x02, 0xB5, 0x05, 0xA0, 0xC5, 0x09, 0xA0, 0x95,
  // "í" (U+00ED)
  0x71, 0x83, 0x17, 0x77, 0x57, 0x10, 0xAB, 0x04, 0x70, 0x4B, 0x05, 0x70, 0x10, 0xEA, 0x06, 0x71,
  0x0B, 0xA0, 0x67, 0x10, 0x9A, 0x05, 0x71, 0x82, 0x4F, 0xE4, 0x77, 0x77, 0x70, 0x3A, 0x0E, 0x72,
  0x06, 0xA0, 0xB7, 0x20, 0xAA, 0x08, 0x72, 0x0D, 0xA0, 0x57, 0x10, 0x1B, 0x02, 0x71, 0x04, 0xA0,
  0xE7, 0x20, 0x7A, 0x0B, 0x72, 0x0A, 0xA0, 0x87, 0x20, 0xDA, 0x04, 0x71, 0x01, 0xB0, 0x17, 0x10,
  0x4A, 0x0D, 0x72, 0x07, 0xA0, 0xA7, 0x20, 0xBA, 0x07, 0x72, 0x0E, 0xA0, 0x47, 0x10, 0x2B, 0x01,
  0x71, 0x05, 0xA0, 0xD7, 0x20, 0x8A, 0x0A, 0x72, 0x0B, 0xA0, 0x67, 0x20, 0xEA, 0x03, 0x71, 0x02,
  0xB7, 0x20, 0x5A, 0x0C, 0x72, 0x09, 0xA0, 0x97, 0x20,
  // "î" (U+00EE)
  0x68, 0x24, 0x77, 0x47, 0x02, 0x0E, 0xA0, 0xC7, 0x0C, 0xC0, 0x35, 0x0A, 0xA0, 0x9A, 0x09, 0x40,
  0x8A, 0x81, 0x50, 0xAA, 0x01, 0x28, 0x27, 0xFE, 0x42, 0x87, 0x1E, 0xF7, 0x04, 0xFD, 0x34, 0x81,
  0x4F, 0xE7, 0x77, 0x70, 0x3A, 0x0E, 0x71, 0x06, 0xA0, 0xB7, 0x10, 0xAA, 0x08, 0x71, 0x0D, 0xA0,
  0x57, 0x01, 0xB0, 0x27, 0x04, 0xA0, 0xE7, 0x10, 0x7A, 0x0B, 0x71, 0x0A, 0xA0, 0x87, 0x10, 0xDA,
  0x04, 0x70, 0x1B, 0x01, 0x70, 0x4A, 0x0D, 0x71, 0x07, 0xA0, 0xA7, 0x10, 0xBA, 0x07, 0x71, 0x0E,
  0xA0, 0x47, 0x02, 0xB0, 0x17, 0x05, 0xA0, 0xD7, 0x10, 0x8A, 0x0A, 0x71, 0x0B, 0xA0, 0x67, 0x10,
  0xEA, 0x03, 0x70, 0x2B, 0x71, 0x05, 0xA0, 0xC7, 0x10, 0x9A, 0x09, 0x71,
  // "ï" (U+00EF)
  0x38, 0x19, 0xEA, 0x38, 0x25, 0xED, 0x12, 0x04, 0xA0, 0xE3, 0x0E, 0xA0, 0x42, 0x07, 0xA0, 0xC2,
  0x02, 0xB0, 0x22, 0x82, 0x3E, 0xD3, 0x38, 0x1B, 0xE7, 0x80, 0xD0, 0x00, 0x3A, 0x0E, 0x72, 0x06,
  0xA0, 0xB7, 0x20, 0xAA, 0x08, 0x72, 0x0D, 0xA0, 0x57, 0x10, 0x1B, 0x02, 0x71, 0x04, 0xA0, 0xE7,
  0x20, 0x7A, 0x0B, 0x72, 0x0A, 0xA0, 0x87, 0x20, 0xDA, 0x04, 0x71, 0x01, 0xB0, 0x17, 0x10, 0x4A,
  0x0D, 0x72, 0x07, 0xA0, 0xA7, 0x20, 0xBA, 0x07, 0x72, 0x0E, 0xA0, 0x47, 0x10, 0x2B, 0x01, 0x71,
  0x05, 0xA0, 0xD7, 0x20, 0x8A, 0x0A, 0x72, 0x0B, 0xA0, 0x67, 0x20, 0xEA, 0x03, 0x71, 0x02, 0xB7,
  0x20, 0x5A, 0x0C, 0x72, 0x09, 0xA0, 0x97, 0x20,
  // "ð" (U+00F0)
  0x71, 0x02, 0x03, 0x60, 0x17, 0x18, 0x21, 0xDF, 0x84, 0x81, 0x8F, 0x47, 0x06, 0xB8, 0x2A, 0x05,
  0xDA, 0x08, 0x71, 0x05, 0x0E, 0xA0, 0xEA, 0x0D, 0x04, 0x73, 0x04, 0xC0, 0x77, 0x40, 0x50, 0xDC,
  0x03, 0x72, 0x02, 0x0B, 0xA0, 0xD0, 0xBA, 0x0C, 0x72, 0x0C, 0xA8, 0x27, 0x01, 0xEA, 0x04, 0x71,
  0x81, 0x3B, 0x23, 0x06, 0xA0, 0xA7, 0x70, 0x1A, 0x0E, 0x77, 0x10, 0xBA, 0x03, 0x77, 0x09, 0xA0,
  0x67, 0x18, 0x56, 0xAB, 0xA6, 0x06, 0xA0, 0x86, 0x04, 0x0E, 0xD0, 0x80, 0x5A, 0x09, 0x50, 0x5F,
  0x90, 0x7A, 0x0A, 0x40, 0x2B, 0x85, 0xC4, 0x01, 0x8F, 0xDA, 0x0A, 0x40, 0xDA, 0x0B, 0x50, 0xBB,
  0x09, 0x30, 0x6A, 0x0E, 0x01, 0x50, 0x5B, 0x08, 0x30, 0xDA, 0x07, 0x60, 0x2B, 0x06, 0x20, 0x3B,
  0x01, 0x60, 0x1B, 0x04, 0x20, 0x8A, 0x0B, 0x70, 0x2B, 0x02, 0x20, 0xCA, 0x07, 0x70, 0x4A, 0x0E,
  0x30, 0xEA, 0x04, 0x70, 0x7A, 0x0B, 0x20, 0x1B, 0x02, 0x70, 0xBA, 0x07, 0x20, 0x2B, 0x01, 0x60,
  0x10, 0xEA, 0x02, 0x20, 0x2B, 0x01, 0x60, 0x6A, 0x0C, 0x30, 0x1B, 0x03, 0x60, 0xEA, 0x05, 0x40,
  0xEA, 0x07, 0x50, 0xAA, 0x0C, 0x50, 0x9A, 0x0E, 0x03, 0x20, 0x10, 0xAB, 0x02, 0x50, 0x20, 0xEB,
  0x00, 0xDC, 0x05, 0x70, 0x4F, 0x0E, 0x04, 0x72, 0x86, 0x29, 0xDF, 0xEC, 0x81, 0x70,
  // "ñ" (U+00F1)
  0x71, 0x83, 0x3C, 0xFD, 0x64, 0x81, 0xEF, 0x17, 0x02, 0xD8, 0x4A, 0x10, 0x7F, 0xC7, 0x10, 0xBA,
  0x0C, 0xB0, 0xE0, 0xDA, 0x06, 0x70, 0x1A, 0x82, 0x30, 0x2C, 0xC0, 0xC7, 0x18, 0x16, 0xFA, 0x48,
  0x37, 0xDE, 0xA1, 0x80, 0xD2, 0x00, 0x4A, 0x07, 0x28, 0x48, 0xDF, 0xEA, 0x27, 0x10, 0x7A, 0x81,
  0x52, 0xDD, 0x0E, 0x03, 0x70, 0xAA, 0x84, 0x5D, 0xFE, 0xCE, 0xB0, 0xB7, 0x0D, 0xA8, 0x1D, 0xF9,
  0x30, 0xBA, 0x0E, 0x60, 0x1C, 0x08, 0x40, 0x5B, 0x60, 0x4B, 0x0C, 0x50, 0x5A, 0x0E, 0x60, 0x7B,
  0x04, 0x50, 0x7A, 0x0D, 0x60, 0xBA, 0x0D, 0x60, 0xAA, 0x0A, 0x60, 0xEA, 0x08, 0x60, 0xDA, 0x07,
  0x50, 0x1B, 0x03, 0x50, 0x1B, 0x04, 0x50, 0x5B, 0x60, 0x4B, 0x01, 0x50, 0x8A, 0x0B, 0x60, 0x7A,
  0x0D, 0x60, 0xBA, 0x08, 0x60, 0xAA, 0x09, 0x60, 0xEA, 0x05, 0x60, 0xEA, 0x06, 0x50, 0x2B, 0x02,
  0x50, 0x1B, 0x03, 0x50, 0x5A, 0x0E, 0x60, 0x5B, 0x60, 0x9A, 0x0B, 0x60, 0x8A, 0x0C, 0x60, 0xCA,
  0x07, 0x60, 0xBA, 0x08, 0x6B, 0x04, 0x60, 0xEA, 0x05, 0x50, 0x3B, 0x01, 0x50, 0x2B, 0x02, 0x50,
  0x6A, 0x0D, 0x60, 0x5A, 0x0E, 0x60, 0x9A, 0x0A, 0x60, 0x9A, 0x0A, 0x60,
  // "ò" (U+00F2)
  0x70, 0xF6, 0x03, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0x6B, 0x01, 0x75, 0x0C, 0xA0, 0x57, 0x50, 0x3A,
  0x0B, 0x76, 0x08, 0xA0, 0x27, 0x68, 0x1C, 0xF8, 0x80, 0xC5, 0x08, 0x51, 0x8C, 0xEE, 0xC7, 0x71,
  0x06, 0xF0, 0xC0, 0x15, 0x07, 0xB8, 0x1E, 0xCE, 0xB0, 0xB4, 0x05, 0xB0, 0x83, 0x07, 0xB0, 0x33,
  0x0E, 0xA0, 0x95, 0x0D, 0xA0, 0x82, 0x08, 0xA0, 0xD6, 0x08, 0xA0, 0xB2, 0x0E, 0xA0, 0x66, 0x06,
  0xA8, 0x1D, 0x06, 0xA0, 0xE7, 0x06, 0xA8, 0x1D, 0x0A, 0xA0, 0x97, 0x07, 0xA0, 0xC1, 0xB0, 0x47,
  0x09, 0xA0, 0xB0, 0x3B, 0x01, 0x70, 0xBA, 0x08, 0x06, 0xA0, 0xD7, 0x10, 0xEA, 0x06, 0x08, 0xA0,
  0xB7, 0x02, 0xB0, 0x20, 0xAA, 0x09, 0x70, 0x6A, 0x81, 0xD0, 0xAA, 0x08, 0x70, 0xCA, 0x81, 0x90,
  0xAA, 0x08, 0x60, 0x3B, 0x81, 0x20, 0x9A, 0x0A, 0x60, 0xBA, 0x0B, 0x20, 0x6A, 0x0E, 0x50, 0x7B,
  0x02, 0x20, 0x2B, 0x09, 0x30, 0x7B, 0x07, 0x40, 0x9B, 0x81, 0xEC, 0xEB, 0x09, 0x60, 0xBF, 0x09,
  0x71, 0x85, 0x6B, 0xEF, 0xDA, 0x36,
  // "ó" (U+00F3)
  0x75, 0x83, 0x17, 0x77, 0x57, 0x50, 0xAB, 0x04, 0x74, 0x04, 0xB0, 0x57, 0x40, 0x10, 0xEA, 0x06,
  0x75, 0x0B, 0xA0, 0x67, 0x50, 0x9A, 0x05, 0x75, 0x82, 0x4F, 0xE4, 0x80, 0xD1, 0x08, 0x51, 0x8C,
  0xEE, 0xC7, 0x72, 0x06, 0xF0, 0xC0, 0x16, 0x07, 0xB8, 0x1E, 0xCE, 0xB0, 0xB5, 0x05, 0xB0, 0x83,
  0x07, 0xB0, 0x34, 0x0E, 0xA0, 0x95, 0x0D, 0xA0, 0x83, 0x08, 0xA0, 0xD6, 0x08, 0xA0, 0xB3, 0x0E,
  0xA0, 0x66, 0x06, 0xA0, 0xD2, 0x06, 0xA0, 0xE7, 0x06, 0xA0, 0xD2, 0x0A, 0xA0, 0x97, 0x07, 0xA0,
  0xC2, 0xB0, 0x47, 0x09, 0xA8, 0x1B, 0x03, 0xB0, 0x17, 0x0B, 0xA8, 0x18, 0x06, 0xA0, 0xD7, 0x10,
  0xEA, 0x81, 0x60, 0x8A, 0x0B, 0x70, 0x2B, 0x81, 0x20, 0xAA, 0x09, 0x70, 0x6A, 0x0D, 0x20, 0xAA,
  0x08, 0x70, 0xCA, 0x09, 0x20, 0xAA, 0x08, 0x60, 0x3B, 0x02, 0x20, 0x9A, 0x0A, 0x60, 0xBA, 0x0B,
  0x30, 0x6A, 0x0E, 0x50, 0x7B, 0x02, 0x30, 0x2B, 0x09, 0x30, 0x7B, 0x07, 0x50, 0x9B, 0x81, 0xEC,
  0xEB, 0x09, 0x70, 0xBF, 0x09, 0x72, 0x85, 0x6B, 0xEF, 0xDA, 0x37,
  // "ô" (U+00F4)
  0x73, 0x82, 0x47, 0x74, 0x74, 0x02, 0x0E, 0xA0, 0xC7, 0x40, 0xCC, 0x03, 0x72, 0x0A, 0xA0, 0x9A,
  0x09, 0x71, 0x08, 0xA8, 0x15, 0x0A, 0xA0, 0x16, 0x82, 0x7F, 0xE4, 0x28, 0x21, 0xEF, 0x75, 0x82,
  0x4F, 0xD3, 0x48, 0x14, 0xFE, 0x80, 0xC2, 0x08, 0x51, 0x8C, 0xEE, 0xC7, 0x71, 0x06, 0xF0, 0xC0,
  0x15, 0x07, 0xB8, 0x1E, 0xCE, 0xB0, 0xB4, 0x05, 0xB0, 0x83, 0x07, 0xB0, 0x33, 0x0E, 0xA0, 0x95,
  0x0D, 0xA0, 0x82, 0x08, 0xA0, 0xD6, 0x08, 0xA0, 0xB2, 0x0E, 0xA0, 0x66, 0x06, 0xA8, 0x1D, 0x06,
  0xA0, 0xE7, 0x06, 0xA8, 0x1D, 0x0A, 0xA0, 0x97, 0x07, 0xA0, 0xC1, 0xB0, 0x47, 0x09, 0xA0, 0xB0,
  0x3B, 0x01, 0x70, 0xBA, 0x08, 0x06, 0xA0, 0xD7, 0x10, 0xEA, 0x06, 0x08, 0xA0, 0xB7, 0x02, 0xB0,
  0x20, 0xAA, 0x09, 0x70, 0x6A, 0x81, 0xD0, 0xAA, 0x08, 0x70, 0xCA, 0x81, 0x90, 0xAA, 0x08, 0x60,
  0x3B, 0x81, 0x20, 0x9A, 0x0A, 0x60, 0xBA, 0x0B, 0x20, 0x6A, 0x0E, 0x50, 0x7B, 0x02, 0x20, 0x2B,
  0x09, 0x30, 0x7B, 0x07, 0x40, 0x9B, 0x81, 0xEC, 0xEB, 0x09, 0x60, 0xBF, 0x09, 0x71, 0x85, 0x6B,
  0xEF, 0xDA, 0x36,
  // "õ" (U+00F5)
  0x68, 0x33, 0xCF, 0xD6, 0x48, 0x1E, 0xF1, 0x50, 0x2D, 0x84, 0xA1, 0x07, 0xFC, 0x60, 0xBA, 0x0C,
  0xB0, 0xE0, 0xDA, 0x06, 0x50, 0x1A, 0x82, 0x30, 0x2C, 0xC0, 0xC6, 0x81, 0x6F, 0xA4, 0x83, 0x7D,
  0xEA, 0x18, 0x0D, 0x00, 0x85, 0x18, 0xCE, 0xEC, 0x77, 0x30, 0x6F, 0x0C, 0x01, 0x70, 0x7B, 0x81,
  0xEC, 0xEB, 0x0B, 0x60, 0x5B, 0x08, 0x30, 0x7B, 0x03, 0x50, 0xEA, 0x09, 0x50, 0xDA, 0x08, 0x40,
  0x8A, 0x0D, 0x60, 0x8A, 0x0B, 0x40, 0xEA, 0x06, 0x60, 0x6A, 0x0D, 0x30, 0x6A, 0x0E, 0x70, 0x6A,
  0x0D, 0x30, 0xAA, 0x09, 0x70, 0x7A, 0x0C, 0x3B, 0x04, 0x70, 0x9A, 0x0B, 0x20, 0x3B, 0x01, 0x70,
  0xBA, 0x08, 0x20, 0x6A, 0x0D, 0x71, 0x0E, 0xA0, 0x62, 0x08, 0xA0, 0xB7, 0x02, 0xB0, 0x22, 0x0A,
  0xA0, 0x97, 0x06, 0xA0, 0xD3, 0x0A, 0xA0, 0x87, 0x0C, 0xA0, 0x93, 0x0A, 0xA0, 0x86, 0x03, 0xB0,
  0x23, 0x09, 0xA0, 0xA6, 0x0B, 0xA0, 0xB4, 0x06, 0xA0, 0xE5, 0x07, 0xB0, 0x24, 0x02, 0xB0, 0x93,
  0x07, 0xB0, 0x76, 0x09, 0xB8, 0x1E, 0xCE, 0xB0, 0x97, 0x10, 0xBF, 0x09, 0x73, 0x85, 0x6B, 0xEF,
  0xDA, 0x37, 0x10,
  // "ö" (U+00F6)
  0x78, 0x19, 0xEA, 0x38, 0x25, 0xED, 0x16, 0x04, 0xA0, 0xE3, 0x0E, 0xA0, 0x46, 0x07, 0xA0, 0xC2,
  0x02, 0xB0, 0x26, 0x82, 0x3E, 0xD3, 0x38, 0x1B, 0xE7, 0x80, 0xE6, 0x08, 0x51, 0x8C, 0xEE, 0xC7,
  0x72, 0x06, 0xF0, 0xC0, 0x16, 0x07, 0xB8, 0x1E, 0xCE, 0xB0, 0xB5, 0x05, 0xB0, 0x83, 0x07, 0xB0,
  0x34, 0x0E, 0xA0, 0x95, 0x0D, 0xA0, 0x83, 0x08, 0xA0, 0xD6, 0x08, 0xA0, 0xB3, 0x0E, 0xA0, 0x66,
  0x06, 0xA0, 0xD2, 0x06, 0xA0, 0xE7, 0x06, 0xA0, 0xD2, 0x0A, 0xA0, 0x97, 0x07, 0xA0, 0xC2, 0xB0,
  0x47, 0x09, 0xA8, 0x1B, 0x03, 0xB0, 0x17, 0x0B, 0xA8, 0x18, 0x06, 0xA0, 0xD7, 0x10, 0xEA, 0x81,
  0x60, 0x8A, 0x0B, 0x70, 0x2B, 0x81, 0x20, 0xAA, 0x09, 0x70, 0x6A, 0x0D, 0x20, 0xAA, 0x08, 0x70,
  0xCA, 0x09, 0x20, 0xAA, 0x08, 0x60, 0x3B, 0x02, 0x20, 0x9A, 0x0A, 0x60, 0xBA, 0x0B, 0x30, 0x6A,
  0x0E, 0x50, 0x7B, 0x02, 0x30, 0x2B, 0x09, 0x30, 0x7B, 0x07, 0x50, 0x9B, 0x81, 0xEC, 0xEB, 0x09,
  0x70, 0xBF, 0x09, 0x72, 0x85, 0x6B, 0xEF, 0xDA, 0x37,
  // "÷" (U+00F7)
  0x68, 0x25, 0xED, 0x47, 0x50, 0xEA, 0x0D, 0x74, 0x01, 0xC7, 0x50, 0xEA, 0x0D, 0x75, 0x82, 0x5E,
  0xD4, 0x80, 0xE2, 0x0F, 0xF9, 0x0E, 0xFF, 0x90, 0xE8, 0x09, 0x3C, 0x0B, 0x80, 0xE2, 0x08, 0x25,
  0xED, 0x47, 0x50, 0xEA, 0x0D, 0x74, 0x01, 0xC7, 0x50, 0xEA, 0x0D, 0x75, 0x82, 0x5E, 0xD4, 0x60,
  // "ø" (U+00F8)
  0x77, 0x20, 0x37, 0x73, 0x82, 0x2F, 0xB1, 0x78, 0x91, 0x18, 0xCE, 0xEC, 0x60, 0xCF, 0xC7, 0x06,
  0xF8, 0x2D, 0xFE, 0x26, 0x07, 0xC0, 0xC0, 0xEC, 0x06, 0x60, 0x4B, 0x09, 0x30, 0x7B, 0x03, 0x60,
  0xDA, 0x0A, 0x40, 0x6B, 0x08, 0x50, 0x7A, 0x0D, 0x40, 0x20, 0xEB, 0x0B, 0x50, 0xEA, 0x05, 0x48,
  0x1C, 0xFA, 0xA0, 0xC4, 0x05, 0xA0, 0xE4, 0x82, 0x7F, 0xA5, 0xA0, 0xD4, 0x0A, 0xA0, 0x83, 0x83,
  0x2F, 0xE1, 0x6A, 0x0C, 0x40, 0xEA, 0x04, 0x38, 0x3C, 0xF4, 0x07, 0xA0, 0xA3, 0x03, 0xB3, 0x81,
  0x8F, 0x92, 0x0A, 0xA0, 0x83, 0x06, 0xA0, 0xC2, 0x81, 0x3F, 0xD3, 0x0D, 0xA0, 0x53, 0x08, 0xA0,
  0xA2, 0x81, 0xDF, 0x42, 0x01, 0xB0, 0x13, 0x0A, 0xA8, 0x38, 0x08, 0xF8, 0x30, 0x6A, 0x0C, 0x40,
  0xAA, 0x82, 0x73, 0xFD, 0x40, 0xBA, 0x08, 0x40, 0xAA, 0x82, 0x8D, 0xF3, 0x30, 0x3B, 0x02, 0x40,
  0x8C, 0x08, 0x40, 0xBA, 0x0A, 0x50, 0x5B, 0x0C, 0x40, 0x7B, 0x02, 0x60, 0xEA, 0x0B, 0x30, 0x7B,
  0x07, 0x60, 0x10, 0xEC, 0x0C, 0x0E, 0xB0, 0xA7, 0x0A, 0xFA, 0x08, 0x70, 0x5A, 0x86, 0x45, 0xBE,
  0xFD, 0x92, 0x71, 0x81, 0xCF, 0x97, 0x73, 0x08, 0x77, 0x30,
  // "ù" (U+00F9)
  0x70, 0xF6, 0x03, 0x76, 0x0D, 0xA0, 0xB7, 0x60, 0x6B, 0x01, 0x76, 0x0C, 0xA0, 0x57, 0x60, 0x3A,
  0x0B, 0x77, 0x08, 0xA0, 0x27, 0x78, 0x1C, 0xF8, 0x80, 0xC5, 0x00, 0x5A, 0x0D, 0x60, 0x4A, 0x0E,
  0x30, 0x8A, 0x0A, 0x60, 0x7A, 0x0B, 0x30, 0xBA, 0x07, 0x60, 0xAA, 0x08, 0x30, 0xEA, 0x04, 0x60,
  0xEA, 0x04, 0x20, 0x3B, 0x60, 0x1B, 0x01, 0x20, 0x6A, 0x0C, 0x60, 0x5A, 0x0E, 0x30, 0x9A, 0x09,
  0x60, 0x8A, 0x0A, 0x30, 0xCA, 0x06, 0x60, 0xBA, 0x07, 0x3B, 0x03, 0x60, 0xEA, 0x04, 0x20, 0x3B,
  0x60, 0x2B, 0x01, 0x20, 0x7A, 0x0C, 0x60, 0x6A, 0x0D, 0x30, 0xAA, 0x08, 0x60, 0x9A, 0x0A, 0x30,
  0xDA, 0x05, 0x60, 0xDA, 0x07, 0x20, 0x1B, 0x02, 0x50, 0x2B, 0x03, 0x20, 0x4A, 0x0E, 0x60, 0x7B,
  0x30, 0x7A, 0x0C, 0x60, 0xEA, 0x0C, 0x30, 0x8A, 0x0B, 0x50, 0x8B, 0x09, 0x30, 0x9A, 0x0B, 0x40,
  0x4C, 0x06, 0x30, 0x8B, 0x03, 0x28, 0x26, 0xFE, 0xEA, 0x03, 0x30, 0x4C, 0x0D, 0x0E, 0xA0, 0x40,
  0xDA, 0x50, 0xBE, 0x04, 0x1A, 0x0C, 0x68, 0x68, 0xDF, 0xD9, 0x20, 0x1A, 0x09, 0x40,
  // "ú" (U+00FA)
  0x75, 0x83, 0x17, 0x77, 0x57, 0x50, 0xAB, 0x04, 0x74, 0x04, 0xB0, 0x57, 0x40, 0x10, 0xEA, 0x06,
  0x75, 0x0B, 0xA0, 0x67, 0x50, 0x9A, 0x05, 0x75, 0x82, 0x4F, 0xE4, 0x80, 0xC6, 0x00, 0x5A, 0x0D,
  0x60, 0x4A, 0x0E, 0x30, 0x8A, 0x0A, 0x60, 0x7A, 0x0B, 0x30, 0xBA, 0x07, 0x60, 0xAA, 0x08, 0x30,
  0xEA, 0x04, 0x60, 0xEA, 0x04, 0x20, 0x3B, 0x60, 0x1B, 0x01, 0x20, 0x6A, 0x0C, 0x60, 0x5A, 0x0E,
  0x30, 0x9A, 0x09, 0x60, 0x8A, 0x0A, 0x30, 0xCA, 0x06, 0x60, 0xBA, 0x07, 0x3B, 0x03, 0x60, 0xEA,
  0x04, 0x20, 0x3B, 0x60, 0x2B, 0x01, 0x20, 0x7A, 0x0C, 0x60, 0x6A, 0x0D, 0x30, 0xAA, 0x08, 0x60,
  0x9A, 0x0A, 0x30, 0xDA, 0x05, 0x60, 0xDA, 0x07, 0x20, 0x1B, 0x02, 0x50, 0x2B, 0x03, 0x20, 0x4A,
  0x0E, 0x60, 0x7B, 0x30, 0x7A, 0x0C, 0x60, 0xEA, 0x0C, 0x30, 0x8A, 0x0B, 0x50, 0x8B, 0x09, 0x30,
  0x9A, 0x0B, 0x40, 0x4C, 0x06, 0x30, 0x8B, 0x03, 0x28, 0x26, 0xFE, 0xEA, 0x03, 0x30, 0x4C, 0x0D,
  0x0E, 0xA0, 0x40, 0xDA, 0x50, 0xBE, 0x04, 0x1A, 0x0C, 0x68, 0x68, 0xDF, 0xD9, 0x20, 0x1A, 0x09,
  0x40,
  // "û" (U+00FB)
  0x73, 0x82, 0x47, 0x74, 0x75, 0x02, 0x0E, 0xA0, 0xC7, 0x50, 0xCC, 0x03, 0x73, 0x0A, 0xA0, 0x9A,
  0x09, 0x72, 0x08, 0xA8, 0x15, 0x0A, 0xA0, 0x17, 0x82, 0x7F, 0xE4, 0x28, 0x21, 0xEF, 0x76, 0x82,
  0x4F, 0xD3, 0x48, 0x14, 0xFE, 0x80, 0xC2, 0x00, 0x5A, 0x0D, 0x60, 0x4A, 0x0E, 0x30, 0x8A, 0x0A,
  0x60, 0x7A, 0x0B, 0x30, 0xBA, 0x07, 0x60, 0xAA, 0x08, 0x30, 0xEA, 0x04, 0x60, 0xEA, 0x04, 0x20,
  0x3B, 0x60, 0x1B, 0x01, 0x20, 0x6A, 0x0C, 0x60, 0x5A, 0x0E, 0x30, 0x9A, 0x09, 0x60, 0x8A, 0x0A,
  0x30, 0xCA, 0x06, 0x60, 0xBA, 0x07, 0x3B, 0x03, 0x60, 0xEA, 0x04, 0x20, 0x3B, 0x60, 0x2B, 0x01,
  0x20, 0x7A, 0x0C, 0x60, 0x6A, 0x0D, 0x30, 0xAA, 0x08, 0x60, 0x9A, 0x0A, 0x30, 0xDA, 0x05, 0x60,
  0xDA, 0x07, 0x20, 0x1B, 0x02, 0x50, 0x2B, 0x03, 0x20, 0x4A, 0x0E, 0x60, 0x7B, 0x30, 0x7A, 0x0C,
  0x60, 0xEA, 0x0C, 0x30, 0x8A, 0x0B, 0x50, 0x8B, 0x09, 0x30, 0x9A, 0x0B, 0x40, 0x4C, 0x06, 0x30,
  0x8B, 0x03, 0x28, 0x26, 0xFE, 0xEA, 0x03, 0x30, 0x4C, 0x0D, 0x0E, 0xA0, 0x40, 0xDA, 0x50, 0xBE,
  0x04, 0x1A, 0x0C, 0x68, 0x68, 0xDF, 0xD9, 0x20, 0x1A, 0x09, 0x40,
  // "ü" (U+00FC)
  0x78, 0x19, 0xEA, 0x38, 0x25, 0xED, 0x16, 0x04, 0xA0, 0xE3, 0x0E, 0xA0, 0x46, 0x07, 0xA0, 0xC2,
  0x02, 0xB0, 0x26, 0x82, 0x3E, 0xD3, 0x38, 0x1B, 0xE7, 0x80, 0xE3, 0x00, 0x5A, 0x0D, 0x60, 0x4A,
  0x0E, 0x30, 0x8A, 0x0A, 0x60, 0x7A, 0x0B, 0x30, 0xBA, 0x07, 0x60, 0xAA, 0x08, 0x30, 0xEA, 0x04,
  0x60, 0xEA, 0x04, 0x20, 0x3B, 0x60, 0x1B, 0x01, 0x20, 0x6A, 0x0C, 0x60, 0x5A, 0x0E, 0x30, 0x9A,
  0x09, 0x60, 0x8A, 0x0A, 0x30, 0xCA, 0x06, 0x60, 0xBA, 0x07, 0x3B, 0x03, 0x60, 0xEA, 0x04, 0x20,
  0x3B, 0x60, 0x2B, 0x01, 0x20, 0x7A, 0x0C, 0x60, 0x6A, 0x0D, 0x30, 0xAA, 0x08, 0x60, 0x9A, 0x0A,
  0x30, 0xDA, 0x05, 0x60, 0xDA, 0x07, 0x20, 0x1B, 0x02, 0x50, 0x2B, 0x03, 0x20, 0x4A, 0x0E, 0x60,
  0x7B, 0x30, 0x7A, 0x0C, 0x60, 0xEA, 0x0C, 0x30, 0x8A, 0x0B, 0x50, 0x8B, 0x09, 0x30, 0x9A, 0x0B,
  0x40, 0x4C, 0x06, 0x30, 0x8B, 0x03, 0x28, 0x26, 0xFE, 0xEA, 0x03, 0x30, 0x4C, 0x0D, 0x0E, 0xA0,
  0x40, 0xDA, 0x50, 0xBE, 0x04, 0x1A, 0x0C, 0x68, 0x68, 0xDF, 0xD9, 0x20, 0x1A, 0x09, 0x40,
  // "ý" (U+00FD)
  0x77, 0x18, 0x31, 0x77, 0x75, 0x77, 0x20, 0xAB, 0x04, 0x77, 0x10, 0x4B, 0x05, 0x77, 0x10, 0x10,
  0xEA, 0x06, 0x77, 0x20, 0xBA, 0x06, 0x77, 0x20, 0x9A, 0x05, 0x77, 0x28, 0x24, 0xFE, 0x48, 0x0E,
  0x20, 0x09, 0xA0, 0x97, 0x06, 0xA0, 0xD6, 0x08, 0xA0, 0xA7, 0x0D, 0xA0, 0x66, 0x07, 0xA0, 0xA6,
  0x05, 0xA0, 0xE7, 0x06, 0xA0, 0xB6, 0x0C, 0xA0, 0x77, 0x05, 0xA0, 0xB5, 0x03, 0xA0, 0xE0, 0x17,
  0x04, 0xA0, 0xC5, 0x0A, 0xA0, 0x87, 0x10, 0x3A, 0x0D, 0x40, 0x2B, 0x01, 0x71, 0x02, 0xA0, 0xD4,
  0x09, 0xA0, 0x97, 0x20, 0x1A, 0x0E, 0x30, 0x1B, 0x02, 0x73, 0xB3, 0x07, 0xA0, 0xA7, 0x4B, 0x30,
  0xEA, 0x03, 0x74, 0x0E, 0xA2, 0x06, 0xA0, 0xB7, 0x50, 0xDA, 0x81, 0x10, 0xDA, 0x03, 0x75, 0x0C,
  0xA0, 0x10, 0x4A, 0x0C, 0x76, 0x0B, 0xA0, 0x10, 0xAA, 0x04, 0x76, 0x0A, 0xA0, 0x3A, 0x0C, 0x77,
  0x09, 0xA0, 0x8A, 0x05, 0x77, 0x08, 0xA8, 0x1E, 0xFD, 0x77, 0x10, 0x7C, 0x06, 0x77, 0x10, 0x6B,
  0x0E, 0x77, 0x20, 0x5B, 0x07, 0x77, 0x20, 0x5A, 0x0E, 0x01, 0x77, 0x20, 0xBA, 0x08, 0x77, 0x20,
  0x3B, 0x01, 0x77, 0x20, 0xAA, 0x09, 0x77, 0x20, 0x3B, 0x02, 0x77, 0x20, 0xCA, 0x09, 0x77, 0x20,
  0xAA, 0x0E, 0x01, 0x75, 0x81, 0x8D, 0xCC, 0x04, 0x76, 0x0A, 0xD0, 0x67, 0x78, 0x48, 0xEF, 0xEA,
  0x37, 0x71,
  // "þ" (U+00FE)
  0x71, 0x04, 0xA0, 0xD7, 0x72, 0x08, 0xA0, 0xA7, 0x72, 0x0B, 0xA0, 0x67, 0x72, 0x0E, 0xA0, 0x37,
  0x71, 0x02, 0xB7, 0x72, 0x06, 0xA0, 0xB7, 0x72, 0x09, 0xA0, 0x87, 0x72, 0x0C, 0xA0, 0x57, 0x72,
  0xB8, 0x61, 0x05, 0xCF, 0xEA, 0x27, 0x10, 0x3A, 0x81, 0xD0, 0xAD, 0x0E, 0x02, 0x70, 0x7A, 0x09,
  0x0A, 0xA0, 0xC0, 0xEB, 0x0B, 0x70, 0xAA, 0x82, 0xCF, 0xA1, 0x20, 0xAB, 0x01, 0x60, 0xDB, 0x0A,
  0x40, 0x2B, 0x04, 0x50, 0x1B, 0x0E, 0x60, 0xEA, 0x06, 0x50, 0x5B, 0x05, 0x60, 0xDA, 0x06, 0x50,
  0x8A, 0x0D, 0x70, 0xDA, 0x05, 0x50, 0xBA, 0x07, 0x7B, 0x04, 0x50, 0xEA, 0x02, 0x60, 0x1B, 0x02,
  0x40, 0x2A, 0x0E, 0x70, 0x5B, 0x50, 0x6A, 0x0A, 0x70, 0x8A, 0x0C, 0x50, 0x9A, 0x07, 0x70, 0xBA,
  0x09, 0x50, 0xCA, 0x05, 0x60, 0x1B, 0x04, 0x5B, 0x03, 0x60, 0x6A, 0x0E, 0x50, 0x4B, 0x02, 0x60,
  0xDA, 0x08, 0x50, 0x7B, 0x03, 0x50, 0x6B, 0x02, 0x50, 0xAB, 0x07, 0x40, 0x20, 0xEA, 0x09, 0x60,
  0xEA, 0x81, 0xEE, 0x32, 0x03, 0x0D, 0xA0, 0xD0, 0x15, 0x01, 0xA0, 0xD0, 0x8A, 0x00, 0xDC, 0x03,
  0x60, 0x5A, 0x81, 0xB0, 0xCD, 0x0E, 0x03, 0x70, 0x8A, 0x87, 0x80, 0x19, 0xDE, 0xC7, 0x17, 0x10,
  0xBA, 0x05, 0x77, 0x20, 0xEA, 0x02, 0x77, 0x10, 0x3A, 0x0E, 0x77, 0x20, 0x6A, 0x0B, 0x77, 0x20,
  0x9A, 0x07, 0x77, 0x20, 0xDA, 0x04, 0x77, 0x2B, 0x01, 0x77, 0x10, 0x4A, 0x0D, 0x77, 0x20, 0x7A,
  0x0A, 0x77, 0x20,
  // "ÿ" (U+00FF)
  0x73, 0x81, 0x9E, 0xA3, 0x82, 0x5E, 0xD1, 0x73, 0x04, 0xA0, 0xE3, 0x0E, 0xA0, 0x47, 0x30, 0x7A,
  0x0C, 0x20, 0x2B, 0x02, 0x73, 0x82, 0x3E, 0xD3, 0x38, 0x1B, 0xE7, 0x80, 0x98, 0x30, 0x09, 0xA0,
  0x97, 0x06, 0xA0, 0xD6, 0x08, 0xA0, 0xA7, 0x0D, 0xA0, 0x66, 0x07, 0xA0, 0xA6, 0x05, 0xA0, 0xE7,
  0x06, 0xA0, 0xB6, 0x0C, 0xA0, 0x77, 0x05, 0xA0, 0xB5, 0x03, 0xA0, 0xE0, 0x17, 0x04, 0xA0, 0xC5,
  0x0A, 0xA0, 0x87, 0x10, 0x3A, 0x0D, 0x40, 0x2B, 0x01, 0x71, 0x02, 0xA0, 0xD4, 0x09, 0xA0, 0x97,
  0x20, 0x1A, 0x0E, 0x30, 0x1B, 0x02, 0x73, 0xB3, 0x07, 0xA0, 0xA7, 0x4B, 0x30, 0xEA, 0x03, 0x74,
  0x0E, 0xA2, 0x06, 0xA0, 0xB7, 0x50, 0xDA, 0x81, 0x10, 0xDA, 0x03, 0x75, 0x0C, 0xA0, 0x10, 0x4A,
  0x0C, 0x76, 0x0B, 0xA0, 0x10, 0xAA, 0x04, 0x76, 0x0A, 0xA0, 0x3A, 0x0C, 0x77, 0x09, 0xA0, 0x8A,
  0x05, 0x77, 0x08, 0xA8, 0x1E, 0xFD, 0x77, 0x10, 0x7C, 0x06, 0x77, 0x10, 0x6B, 0x0E, 0x77, 0x20,
  0x5B, 0x07, 0x77, 0x20, 0x5A, 0x0E, 0x01, 0x77, 0x20, 0xBA, 0x08, 0x77, 0x20, 0x3B, 0x01, 0x77,
  0x20, 0xAA, 0x09, 0x77, 0x20, 0x3B, 0x02, 0x77, 0x20, 0xCA, 0x09, 0x77, 0x20, 0xAA, 0x0E, 0x01,
  0x75, 0x81, 0x8D, 0xCC, 0x04, 0x76, 0x0A, 0xD0, 0x67, 0x78, 0x48, 0xEF, 0xEA, 0x37, 0x71,
  // "Ā" (U+0100)
  0x74, 0x80, 0x5C, 0x0A, 0x73, 0x03, 0xFA, 0x0B, 0x73, 0x06, 0xFA, 0x08, 0x80, 0x99, 0x00, 0x0B,
  0xB0, 0x87, 0x71, 0x02, 0xC0, 0x87, 0x71, 0x09, 0xC0, 0x97, 0x70, 0x1A, 0x0E, 0xA0, 0xA7, 0x70,
  0x7A, 0x08, 0xA0, 0xA7, 0x70, 0xEA, 0x03, 0xA0, 0xB7, 0x60, 0x6A, 0x09, 0x02, 0xA0, 0xB7, 0x60,
  0xDA, 0x03, 0x02, 0xA0, 0xC7, 0x50, 0x4A, 0x81, 0xC0, 0x1A, 0x0D, 0x75, 0x0B, 0xA8, 0x16, 0x01,
  0xA0, 0xD7, 0x40, 0x3A, 0x0E, 0x20, 0x1A, 0x0E, 0x74, 0x0A, 0xA0, 0x92, 0x01, 0xA0, 0xE7, 0x30,
  0x1B, 0x02, 0x20, 0x1B, 0x73, 0x08, 0xA0, 0xC3, 0x01, 0xB7, 0x30, 0xEA, 0x05, 0x30, 0x1B, 0x01,
  0x71, 0x07, 0xA0, 0xE4, 0x01, 0xB0, 0x17, 0x10, 0xDA, 0x08, 0x5B, 0x02, 0x70, 0x5F, 0xD0, 0x37,
  0x0C, 0xFD, 0x03, 0x60, 0x3B, 0x80, 0x3C, 0xB0, 0x46, 0x0A, 0xA0, 0xC7, 0xB0, 0x45, 0x02, 0xB0,
  0x57, 0xB0, 0x55, 0x09, 0xA0, 0xE7, 0x10, 0xEA, 0x06, 0x40, 0x10, 0xEA, 0x07, 0x71, 0x0E, 0xA0,
  0x64, 0x07, 0xB0, 0x17, 0x10, 0xDA, 0x07, 0x40, 0xEA, 0x09, 0x72, 0x0D, 0xA0, 0x73, 0x06, 0xB0,
  0x37, 0x20, 0xCA, 0x08, 0x30, 0xDA, 0x0C, 0x73, 0x0C, 0xA0, 0x92, 0x04, 0xB0, 0x57, 0x30, 0xBA,
  0x09, 0x20,
  // "ā" (U+0101)
  0x78, 0x05, 0xC0, 0xA7, 0x03, 0xFA, 0x0B, 0x70, 0x6F, 0xA0, 0x88, 0x0F, 0x10, 0x84, 0x29, 0xDE,
  0xC6, 0x20, 0x6A, 0x04, 0x50, 0x6E, 0x81, 0x80, 0xBA, 0x01, 0x40, 0x6C, 0x0C, 0x0E, 0xA0, 0x3A,
  0x0D, 0x40, 0x3B, 0x0C, 0x02, 0x28, 0x17, 0xFD, 0xA0, 0xA4, 0x0D, 0xA0, 0xD5, 0x0C, 0xB0, 0x73,
  0x06, 0xB0, 0x35, 0x08, 0xB0, 0x43, 0x0D, 0xA0, 0xA6, 0x07, 0xB0, 0x12, 0x03, 0xB0, 0x36, 0x08,
  0xA0, 0xD3, 0x08, 0xA0, 0xC7, 0x09, 0xA0, 0x93, 0x0D, 0xA0, 0x77, 0x0C, 0xA0, 0x62, 0x01, 0xB0,
  0x37, 0xB0, 0x32, 0x04, 0xB7, 0x03, 0xB3, 0x07, 0xA0, 0xD7, 0x07, 0xA0, 0xC3, 0x09, 0xA0, 0xB7,
  0x0C, 0xA0, 0x93, 0x0A, 0xA0, 0xA6, 0x03, 0xB0, 0x63, 0x0A, 0xA0, 0x96, 0x0A, 0xB0, 0x23, 0x0A,
  0xA0, 0xA5, 0x03, 0xC4, 0x08, 0xA0, 0xD4, 0x01, 0x0D, 0xB0, 0xC4, 0x05, 0xB0, 0x62, 0x82, 0x2C,
  0xFC, 0xA0, 0x85, 0x0E, 0xB0, 0x0D, 0xA0, 0x08, 0xA0, 0x55, 0x05, 0xE8, 0x18, 0x09, 0xA0, 0x26,
  0x84, 0x4B, 0xEE, 0xB3, 0x28, 0x1B, 0xFE, 0x50,
  // "Ă" (U+0102)
  0x74, 0x81, 0x37, 0x55, 0x81, 0x67, 0x27, 0x48, 0x17, 0xFB, 0x40, 0x1A, 0x01, 0x74, 0x06, 0xA0,
  0x23, 0x81, 0xBF, 0xB7, 0x50, 0x3A, 0x82, 0xEA, 0xAE, 0xA0, 0x47, 0x60, 0xAE, 0x08, 0x77, 0x18,
  0x47, 0xDF, 0xEB, 0x48, 0x0F, 0x00, 0x0B, 0xB0, 0x87, 0x72, 0x02, 0xC0, 0x87, 0x72, 0x09, 0xC0,
  0x97, 0x71, 0x01, 0xA0, 0xEA, 0x0A, 0x77, 0x10, 0x7A, 0x08, 0xA0, 0xA7, 0x71, 0x0E, 0xA0, 0x3A,
  0x0B, 0x77, 0x06, 0xA0, 0x90, 0x2A, 0x0B, 0x77, 0x0D, 0xA0, 0x30, 0x2A, 0x0C, 0x76, 0x04, 0xA8,
  0x1C, 0x01, 0xA0, 0xD7, 0x60, 0xBA, 0x81, 0x60, 0x1A, 0x0D, 0x75, 0x03, 0xA0, 0xE2, 0x01, 0xA0,
  0xE7, 0x50, 0xAA, 0x09, 0x20, 0x1A, 0x0E, 0x74, 0x01, 0xB0, 0x22, 0x01, 0xB7, 0x40, 0x8A, 0x0C,
  0x30, 0x1B, 0x74, 0x0E, 0xA0, 0x53, 0x01, 0xB0, 0x17, 0x20, 0x7A, 0x0E, 0x40, 0x1B, 0x01, 0x72,
  0x0D, 0xA0, 0x85, 0xB0, 0x27, 0x10, 0x5F, 0xD0, 0x37, 0x10, 0xCF, 0xD0, 0x37, 0x03, 0xB8, 0x03,
  0xCB, 0x04, 0x70, 0xAA, 0x0C, 0x7B, 0x04, 0x60, 0x2B, 0x05, 0x7B, 0x05, 0x60, 0x9A, 0x0E, 0x71,
  0x0E, 0xA0, 0x65, 0x01, 0x0E, 0xA0, 0x77, 0x10, 0xEA, 0x06, 0x50, 0x7B, 0x01, 0x71, 0x0D, 0xA0,
  0x75, 0x0E, 0xA0, 0x97, 0x20, 0xDA, 0x07, 0x40, 0x6B, 0x03, 0x72, 0x0C, 0xA0, 0x84, 0x0D, 0xA0,
  0xC7, 0x30, 0xCA, 0x09, 0x30, 0x4B, 0x05, 0x73, 0x0B, 0xA0, 0x93,
  // "ă" (U+0103)
  0x68, 0x13, 0x75, 0x58, 0x16, 0x72, 0x78, 0x17, 0xFB, 0x40, 0x1A, 0x01, 0x70, 0x6A, 0x02, 0x38,
  0x1B, 0xFB, 0x71, 0x03, 0xA8, 0x2E, 0xAA, 0xEA, 0x04, 0x72, 0x0A, 0xE0, 0x87, 0x48, 0x47, 0xDF,
  0xEB, 0x48, 0x0D, 0x20, 0x84, 0x29, 0xDE, 0xC6, 0x20, 0x6A, 0x04, 0x50, 0x6E, 0x81, 0x80, 0xBA,
  0x01, 0x40, 0x6C, 0x0C, 0x0E, 0xA0, 0x3A, 0x0D, 0x40, 0x3B, 0x0C, 0x02, 0x28, 0x17, 0xFD, 0xA0,
  0xA4, 0x0D, 0xA0, 0xD5, 0x0C, 0xB0, 0x73, 0x06, 0xB0, 0x35, 0x08, 0xB0, 0x43, 0x0D, 0xA0, 0xA6,
  0x07, 0xB0, 0x12, 0x03, 0xB0, 0x36, 0x08, 0xA0, 0xD3, 0x08, 0xA0, 0xC7, 0x09, 0xA0, 0x93, 0x0D,
  0xA0, 0x77, 0x0C, 0xA0, 0x62, 0x01, 0xB0, 0x37, 0xB0, 0x32, 0x04, 0xB7, 0x03, 0xB3, 0x07, 0xA0,
  0xD7, 0x07, 0xA0, 0xC3, 0x09, 0xA0, 0xB7, 0x0C, 0xA0, 0x93, 0x0A, 0xA0, 0xA6, 0x03, 0xB0, 0x63,
  0x0A, 0xA0, 0x96, 0x0A, 0xB0, 0x23, 0x0A, 0xA0, 0xA5, 0x03, 0xC4, 0x08, 0xA0, 0xD4, 0x01, 0x0D,
  0xB0, 0xC4, 0x05, 0xB0, 0x62, 0x82, 0x2C, 0xFC, 0xA0, 0x85, 0x0E, 0xB0, 0x0D, 0xA0, 0x08, 0xA0,
  0x55, 0x05, 0xE8, 0x18, 0x09, 0xA0, 0x26, 0x84, 0x4B, 0xEE, 0xB3, 0x28, 0x1B, 0xFE, 0x50,
  // "Ą" (U+0104)
  0x76, 0x0B, 0xB0, 0x87, 0x60, 0x2C, 0x08, 0x76, 0x09, 0xC0, 0x97, 0x50, 0x1A, 0x0E, 0xA0, 0xA7,
  0x50, 0x7A, 0x08, 0xA0, 0xA7, 0x50, 0xEA, 0x03, 0xA0, 0xB7, 0x40, 0x6A, 0x09, 0x02, 0xA0, 0xB7,
  0x40, 0xDA, 0x03, 0x02, 0xA0, 0xC7, 0x30, 0x4A, 0x81, 0xC0, 0x1A, 0x0D, 0x73, 0x0B, 0xA8, 0x16,
  0x01, 0xA0, 0xD7, 0x20, 0x3A, 0x0E, 0x20, 0x1A, 0x0E, 0x72, 0x0A, 0xA0, 0x92, 0x01, 0xA0, 0xE7,
  0x10, 0x1B, 0x02, 0x20, 0x1B, 0x71, 0x08, 0xA0, 0xC3, 0x01, 0xB7, 0x10, 0xEA, 0x05, 0x30, 0x1B,
  0x01, 0x60, 0x7A, 0x0E, 0x40, 0x1B, 0x01, 0x60, 0xDA, 0x08, 0x5B, 0x02, 0x50, 0x5F, 0xD0, 0x35,
  0x0C, 0xFD, 0x03, 0x40, 0x3B, 0x80, 0x3C, 0xB0, 0x44, 0x0A, 0xA0, 0xC7, 0xB0, 0x43, 0x02, 0xB0,
  0x57, 0xB0, 0x53, 0x09, 0xA0, 0xE7, 0x10, 0xEA, 0x06, 0x20, 0x10, 0xEA, 0x07, 0x71, 0x0E, 0xA0,
  0x62, 0x07, 0xB0, 0x17, 0x10, 0xDA, 0x07, 0x20, 0xEA, 0x09, 0x72, 0x0D, 0xA8, 0x17, 0x06, 0xB0,
  0x37, 0x20, 0xCA, 0x81, 0x80, 0xDA, 0x0C, 0x73, 0x0C, 0xA0, 0x90, 0x4B, 0x05, 0x73, 0x0B, 0xA0,
  0x97, 0x78, 0x26, 0xFC, 0x17, 0x78, 0x18, 0xFC, 0x77, 0x18, 0x27, 0xFD, 0x17, 0x70, 0x2A, 0x06,
  0x77, 0x10, 0x9A, 0x01, 0x77, 0x10, 0xBA, 0x02, 0x77, 0x10, 0xBA, 0x81, 0xEC, 0xA7, 0x60, 0x6C,
  0x09, 0x77, 0x83, 0x7D, 0xFD, 0x52,
  // "ą" (U+0105)
  0x68, 0x42, 0x9D, 0xEC, 0x62, 0x06, 0xA0, 0x45, 0x06, 0xE8, 0x18, 0x0B, 0xA0, 0x14, 0x06, 0xC0,
  0xC0, 0xEA, 0x03, 0xA0, 0xD4, 0x03, 0xB0, 0xC0, 0x22, 0x81, 0x7F, 0xDA, 0x0A, 0x40, 0xDA, 0x0D,
  0x50, 0xCB, 0x07, 0x30, 0x6B, 0x03, 0x50, 0x8B, 0x04, 0x30, 0xDA, 0x0A, 0x60, 0x7B, 0x01, 0x20,
  0x3B, 0x03, 0x60, 0x8A, 0x0D, 0x30, 0x8A, 0x0C, 0x70, 0x9A, 0x09, 0x30, 0xDA, 0x07, 0x70, 0xCA,
  0x06, 0x20, 0x1B, 0x03, 0x7B, 0x03, 0x20, 0x4B, 0x70, 0x3B, 0x30, 0x7A, 0x0D, 0x70, 0x7A, 0x0C,
  0x30, 0x9A, 0x0B, 0x70, 0xCA, 0x09, 0x30, 0xAA, 0x0A, 0x60, 0x3B, 0x06, 0x30, 0xAA, 0x09, 0x60,
  0xAB, 0x02, 0x30, 0xAA, 0x0A, 0x50, 0x3C, 0x40, 0x8A, 0x0D, 0x40, 0x10, 0xDB, 0x0C, 0x40, 0x5B,
  0x06, 0x28, 0x22, 0xCF, 0xCA, 0x08, 0x50, 0xEB, 0x00, 0xDA, 0x00, 0x8A, 0x05, 0x50, 0x5E, 0x81,
  0x80, 0x9A, 0x02, 0x68, 0x44, 0xBE, 0xEB, 0x32, 0x81, 0xBF, 0xE7, 0x78, 0x26, 0xFC, 0x17, 0x68,
  0x18, 0xFC, 0x77, 0x82, 0x7F, 0xD1, 0x76, 0x02, 0xA0, 0x67, 0x70, 0x9A, 0x01, 0x77, 0x0B, 0xA0,
  0x27, 0x70, 0xBA, 0x81, 0xEC, 0xA7, 0x50, 0x6C, 0x09, 0x76, 0x83, 0x7D, 0xFD, 0x56,
  // "Ć" (U+0106)
  0x77, 0x83, 0x17, 0x77, 0x57, 0x71, 0x0A, 0xB0, 0x47, 0x70, 0x4B, 0x05, 0x77, 0x01, 0x0E, 0xA0,
  0x67, 0x71, 0x0B, 0xA0, 0x67, 0x71, 0x09, 0xA0, 0x57, 0x71, 0x82, 0x4F, 0xE4, 0x80, 0xE4, 0x08,
  0x74, 0xAD, 0xEF, 0xEB, 0x72, 0x72, 0x03, 0x0C, 0xFA, 0x03, 0x70, 0x6D, 0x81, 0xCC, 0xEA, 0x0C,
  0x70, 0x6B, 0x0D, 0x05, 0x48, 0x15, 0xD3, 0x60, 0x5B, 0x0B, 0x01, 0x76, 0x01, 0x0E, 0xA0, 0xC7,
  0x71, 0x0B, 0xA0, 0xE0, 0x17, 0x70, 0x3B, 0x06, 0x77, 0x10, 0xBA, 0x0D, 0x77, 0x10, 0x2B, 0x06,
  0x77, 0x10, 0x8A, 0x0E, 0x77, 0x20, 0xDA, 0x09, 0x77, 0x10, 0x2B, 0x05, 0x77, 0x10, 0x6B, 0x01,
  0x77, 0x10, 0x9A, 0x0D, 0x77, 0x20, 0xCA, 0x0A, 0x77, 0x20, 0xEA, 0x08, 0x77, 0x2B, 0x06, 0x77,
  0x10, 0x1B, 0x05, 0x77, 0x10, 0x1B, 0x05, 0x77, 0x10, 0x1B, 0x05, 0x77, 0x2B, 0x07, 0x77, 0x20,
  0xDA, 0x0A, 0x77, 0x20, 0x9A, 0x0E, 0x77, 0x20, 0x4B, 0x08, 0x77, 0x20, 0xCB, 0x08, 0x01, 0x38,
  0x11, 0x66, 0x71, 0x03, 0x0E, 0xC8, 0x1C, 0xCD, 0xA0, 0x97, 0x20, 0x30, 0xEF, 0x90, 0x97, 0x48,
  0x77, 0xCE, 0xFE, 0xCA, 0x61, 0x60,
  // "ć" (U+0107)
  0x73, 0x83, 0x17, 0x77, 0x57, 0x30, 0xAB, 0x04, 0x72, 0x04, 0xB0, 0x57, 0x20, 0x10, 0xEA, 0x06,
  0x73, 0x0B, 0xA0, 0x67, 0x30, 0x9A, 0x05, 0x73, 0x82, 0x4F, 0xE4, 0x80, 0xC5, 0x08, 0x61, 0x8C,
  0xEE, 0xDA, 0x46, 0x05, 0x0E, 0xE0, 0xE5, 0x05, 0xC0, 0xD0, 0xCA, 0x09, 0x40, 0x3B, 0x0B, 0x02,
  0x30, 0x70, 0x34, 0x0D, 0xA0, 0xB7, 0x30, 0x7A, 0x0E, 0x01, 0x73, 0x0E, 0xA0, 0x77, 0x30, 0x5A,
  0x0E, 0x74, 0x0A, 0xA0, 0x97, 0x40, 0xEA, 0x05, 0x73, 0x03, 0xB0, 0x17, 0x30, 0x5A, 0x0D, 0x74,
  0x08, 0xA0, 0xB7, 0x40, 0x9A, 0x09, 0x74, 0x0A, 0xA0, 0x97, 0x40, 0xAA, 0x09, 0x74, 0x09, 0xA0,
  0xB7, 0x40, 0x7A, 0x0E, 0x01, 0x73, 0x02, 0xB0, 0xB0, 0x13, 0x06, 0x08, 0x50, 0xAC, 0x00, 0xCA,
  0x0A, 0x50, 0x10, 0xCF, 0x0A, 0x78, 0x56, 0xCE, 0xFD, 0xA5, 0x50,
  // "Ĉ" (U+0108)
  0x76, 0x82, 0x47, 0x74, 0x77, 0x10, 0x20, 0xEA, 0x0C, 0x77, 0x10, 0xCC, 0x03, 0x76, 0x0A, 0xA0,
  0x9A, 0x09, 0x75, 0x08, 0xA8, 0x15, 0x0A, 0xA0, 0x17, 0x38, 0x27, 0xFE, 0x42, 0x82, 0x1E, 0xF7,
  0x72, 0x82, 0x4F, 0xD3, 0x48, 0x14, 0xFE, 0x80, 0xD7, 0x08, 0x74, 0xAD, 0xEF, 0xEB, 0x72, 0x72,
  0x03, 0x0C, 0xFA, 0x03, 0x70, 0x6D, 0x81, 0xCC, 0xEA, 0x0C, 0x70, 0x6B, 0x0D, 0x05, 0x48, 0x15,
  0xD3, 0x60, 0x5B, 0x0B, 0x01, 0x76, 0x01, 0x0E, 0xA0, 0xC7, 0x71, 0x0B, 0xA0, 0xE0, 0x17, 0x70,
  0x3B, 0x06, 0x77, 0x10, 0xBA, 0x0D, 0x77, 0x10, 0x2B, 0x06, 0x77, 0x10, 0x8A, 0x0E, 0x77, 0x20,
  0xDA, 0x09, 0x77, 0x10, 0x2B, 0x05, 0x77, 0x10, 0x6B, 0x01, 0x77, 0x10, 0x9A, 0x0D, 0x77, 0x20,
  0xCA, 0x0A, 0x77, 0x20, 0xEA, 0x08, 0x77, 0x2B, 0x06, 0x77, 0x10, 0x1B, 0x05, 0x77, 0x10, 0x1B,
  0x05, 0x77, 0x10, 0x1B, 0x05, 0x77, 0x2B, 0x07, 0x77, 0x20, 0xDA, 0x0A, 0x77, 0x20, 0x9A, 0x0E,
  0x77, 0x20, 0x4B, 0x08, 0x77, 0x20, 0xCB, 0x08, 0x01, 0x38, 0x11, 0x66, 0x71, 0x03, 0x0E, 0xC8,
  0x1C, 0xCD, 0xA0, 0x97, 0x20, 0x30, 0xEF, 0x90, 0x97, 0x48, 0x77, 0xCE, 0xFE, 0xCA, 0x61, 0x60,
  // "ĉ" (U+0109)
  0x72, 0x82, 0x47, 0x74, 0x73, 0x02, 0x0E, 0xA0, 0xC7, 0x30, 0xCC, 0x03, 0x71, 0x0A, 0xA0, 0x9A,
  0x09, 0x70, 0x8A, 0x81, 0x50, 0xAA, 0x01, 0x58, 0x27, 0xFE, 0x42, 0x82, 0x1E, 0xF7, 0x48, 0x24,
  0xFD, 0x34, 0x81, 0x4F, 0xE8, 0x0C, 0x00, 0x86, 0x18, 0xCE, 0xED, 0xA4, 0x60, 0x50, 0xEE, 0x0E,
  0x50, 0x5C, 0x0D, 0x0C, 0xA0, 0x94, 0x03, 0xB0, 0xB0, 0x23, 0x07, 0x03, 0x40, 0xDA, 0x0B, 0x73,
  0x07, 0xA0, 0xE0, 0x17, 0x30, 0xEA, 0x07, 0x73, 0x05, 0xA0, 0xE7, 0x40, 0xAA, 0x09, 0x74, 0x0E,
  0xA0, 0x57, 0x30, 0x3B, 0x01, 0x73, 0x05, 0xA0, 0xD7, 0x40, 0x8A, 0x0B, 0x74, 0x09, 0xA0, 0x97,
  0x40, 0xAA, 0x09, 0x74, 0x0A, 0xA0, 0x97, 0x40, 0x9A, 0x0B, 0x74, 0x07, 0xA0, 0xE0, 0x17, 0x30,
  0x2B, 0x0B, 0x01, 0x30, 0x60, 0x85, 0x0A, 0xC0, 0x0C, 0xA0, 0xA5, 0x01, 0x0C, 0xF0, 0xA7, 0x85,
  0x6C, 0xEF, 0xDA, 0x55,
  // "Ċ" (U+010A)
  0x76, 0x82, 0x2C, 0xE8, 0x77, 0x20, 0xAA, 0x0E, 0x77, 0x20, 0xDA, 0x0C, 0x77, 0x28, 0x27, 0xEC,
  0x28, 0x09, 0x85, 0x08, 0x74, 0xAD, 0xEF, 0xEB, 0x72, 0x72, 0x03, 0x0C, 0xFA, 0x03, 0x70, 0x6D,
  0x81, 0xCC, 0xEA, 0x0C, 0x70, 0x6B, 0x0D, 0x05, 0x48, 0x15, 0xD3, 0x60, 0x5B, 0x0B, 0x01, 0x76,
  0x01, 0x0E, 0xA0, 0xC7, 0x71, 0x0B, 0xA0, 0xE0, 0x17, 0x70, 0x3B, 0x06, 0x77, 0x10, 0xBA, 0x0D,
  0x77, 0x10, 0x2B, 0x06, 0x77, 0x10, 0x8A, 0x0E, 0x77, 0x20, 0xDA, 0x09, 0x77, 0x10, 0x2B, 0x05,
  0x77, 0x10, 0x6B, 0x01, 0x77, 0x10, 0x9A, 0x0D, 0x77, 0x20, 0xCA, 0x0A, 0x77, 0x20, 0xEA, 0x08,
  0x77, 0x2B, 0x06, 0x77, 0x10, 0x1B, 0x05, 0x77, 0x10, 0x1B, 0x05, 0x77, 0x10, 0x1B, 0x05, 0x77,
  0x2B, 0x07, 0x77, 0x20, 0xDA, 0x0A, 0x77, 0x20, 0x9A, 0x0E, 0x77, 0x20, 0x4B, 0x08, 0x77, 0x20,
  0xCB, 0x08, 0x01, 0x38, 0x11, 0x66, 0x71, 0x03, 0x0E, 0xC8, 0x1C, 0xCD, 0xA0, 0x97, 0x20, 0x30,
  0xEF, 0x90, 0x97, 0x48, 0x77, 0xCE, 0xFE, 0xCA, 0x61, 0x60,
  // "ċ" (U+010B)
  0x72, 0x82, 0x2C, 0xE8, 0x73, 0x0A, 0xA0, 0xE7, 0x30, 0xDA, 0x0C, 0x73, 0x82, 0x7E, 0xC2, 0x80,
  0xD5, 0x08, 0x61, 0x8C, 0xEE, 0xDA, 0x45, 0x05, 0x0E, 0xE0, 0xE4, 0x05, 0xC0, 0xD0, 0xCA, 0x09,
  0x30, 0x3B, 0x0B, 0x02, 0x30, 0x70, 0x33, 0x0D, 0xA0, 0xB7, 0x20, 0x7A, 0x0E, 0x01, 0x72, 0x0E,
  0xA0, 0x77, 0x20, 0x5A, 0x0E, 0x73, 0x0A, 0xA0, 0x97, 0x30, 0xEA, 0x05, 0x72, 0x03, 0xB0, 0x17,
  0x20, 0x5A, 0x0D, 0x73, 0x08, 0xA0, 0xB7, 0x30, 0x9A, 0x09, 0x73, 0x0A, 0xA0, 0x97, 0x30, 0xAA,
  0x09, 0x73, 0x09, 0xA0, 0xB7, 0x30, 0x7A, 0x0E, 0x01, 0x72, 0x02, 0xB0, 0xB0, 0x13, 0x06, 0x08,
  0x40, 0xAC, 0x00, 0xCA, 0x0A, 0x40, 0x10, 0xCF, 0x0A, 0x68, 0x56, 0xCE, 0xFD, 0xA5, 0x40,
  // "Č" (U+010C)
  0x73, 0x81, 0x17, 0x66, 0x81, 0x67, 0x27, 0x48, 0x1E, 0xF7, 0x38, 0x21, 0xBF, 0xB7, 0x50, 0x7A,
  0x84, 0x20, 0x1D, 0xFC, 0x76, 0x01, 0xA8, 0x4B, 0x1D, 0xFD, 0x17, 0x70, 0x9A, 0x82, 0xEF, 0xE3,
  0x77, 0x10, 0x3C, 0x05, 0x77, 0x30, 0xDA, 0x09, 0x80, 0xE7, 0x08, 0x74, 0xAD, 0xEF, 0xEB, 0x72,
  0x74, 0x03, 0x0C, 0xFA, 0x03, 0x72, 0x06, 0xD8, 0x1C, 0xCE, 0xA0, 0xC7, 0x20, 0x6B, 0x0D, 0x05,
  0x48, 0x15, 0xD3, 0x71, 0x05, 0xB0, 0xB0, 0x17, 0x71, 0x01, 0x0E, 0xA0, 0xC7, 0x73, 0x0B, 0xA0,
  0xE0, 0x17, 0x72, 0x03, 0xB0, 0x67, 0x73, 0x0B, 0xA0, 0xD7, 0x73, 0x02, 0xB0, 0x67, 0x73, 0x08,
  0xA0, 0xE7, 0x74, 0x0D, 0xA0, 0x97, 0x73, 0x02, 0xB0, 0x57, 0x73, 0x06, 0xB0, 0x17, 0x73, 0x09,
  0xA0, 0xD7, 0x74, 0x0C, 0xA0, 0xA7, 0x74, 0x0E, 0xA0, 0x87, 0x74, 0xB0, 0x67, 0x73, 0x01, 0xB0,
  0x57, 0x73, 0x01, 0xB0, 0x57, 0x73, 0x01, 0xB0, 0x57, 0x74, 0xB0, 0x77, 0x74, 0x0D, 0xA0, 0xA7,
  0x74, 0x09, 0xA0, 0xE7, 0x74, 0x04, 0xB0, 0x87, 0x74, 0x0C, 0xB0, 0x80, 0x13, 0x81, 0x16, 0x67,
  0x30, 0x30, 0xEC, 0x81, 0xCC, 0xDA, 0x09, 0x74, 0x03, 0x0E, 0xF9, 0x09, 0x76, 0x87, 0x7C, 0xEF,
  0xEC, 0xA6, 0x17, 0x10,
  // "č" (U+010D)
  0x58, 0x11, 0x76, 0x68, 0x16, 0x72, 0x68, 0x1E, 0xF7, 0x38, 0x21, 0xBF, 0xB7, 0x07, 0xA8, 0x42,
  0x01, 0xDF, 0xC7, 0x10, 0x1A, 0x84, 0xB1, 0xDF, 0xD1, 0x72, 0x09, 0xA8, 0x2E, 0xFE, 0x37, 0x30,
  0x3C, 0x05, 0x75, 0x0D, 0xA0, 0x98, 0x0D, 0x10, 0x86, 0x18, 0xCE, 0xED, 0xA4, 0x71, 0x05, 0x0E,
  0xE0, 0xE7, 0x05, 0xC0, 0xD0, 0xCA, 0x09, 0x60, 0x3B, 0x0B, 0x02, 0x30, 0x70, 0x36, 0x0D, 0xA0,
  0xB7, 0x50, 0x7A, 0x0E, 0x01, 0x75, 0x0E, 0xA0, 0x77, 0x50, 0x5A, 0x0E, 0x76, 0x0A, 0xA0, 0x97,
  0x60, 0xEA, 0x05, 0x75, 0x03, 0xB0, 0x17, 0x50, 0x5A, 0x0D, 0x76, 0x08, 0xA0, 0xB7, 0x60, 0x9A,
  0x09, 0x76, 0x0A, 0xA0, 0x97, 0x60, 0xAA, 0x09, 0x76, 0x09, 0xA0, 0xB7, 0x60, 0x7A, 0x0E, 0x01,
  0x75, 0x02, 0xB0, 0xB0, 0x13, 0x06, 0x08, 0x70, 0xAC, 0x00, 0xCA, 0x0A, 0x70, 0x10, 0xCF, 0x0A,
  0x72, 0x85, 0x6C, 0xEF, 0xDA, 0x57,
  // "Ď" (U+010E)
  0x72, 0x81, 0x17, 0x66, 0x81, 0x67, 0x27, 0x38, 0x1E, 0xF7, 0x38, 0x21, 0xBF, 0xB7, 0x40, 0x7A,
  0x84, 0x20, 0x1D, 0xFC, 0x75, 0x01, 0xA8, 0x4B, 0x1D, 0xFD, 0x17, 0x60, 0x9A, 0x82, 0xEF, 0xE3,
  0x77, 0x03, 0xC0, 0x57, 0x72, 0x0D, 0xA0, 0x98, 0x0E, 0x10, 0x09, 0xD8, 0x2E, 0xDA, 0x57, 0x40,
  0xCF, 0xA0, 0xC0, 0x27, 0x2B, 0x0F, 0xC0, 0xDC, 0x0E, 0x02, 0x70, 0x3B, 0x01, 0x30, 0x20, 0xAB,
  0x0C, 0x70, 0x6A, 0x0D, 0x60, 0x9B, 0x05, 0x60, 0x9A, 0x0A, 0x70, 0xEA, 0x0B, 0x60, 0xDA, 0x07,
  0x70, 0x9A, 0x0E, 0x6B, 0x04, 0x70, 0x6B, 0x01, 0x40, 0x3B, 0x71, 0x05, 0xB0, 0x24, 0x07, 0xA0,
  0xD7, 0x10, 0x4B, 0x03, 0x40, 0xAA, 0x09, 0x71, 0x05, 0xB0, 0x24, 0x0D, 0xA0, 0x67, 0x10, 0x6B,
  0x02, 0x30, 0x1B, 0x03, 0x71, 0x07, 0xB4, 0x04, 0xB7, 0x20, 0x9A, 0x0E, 0x40, 0x7A, 0x0C, 0x72,
  0x0C, 0xA0, 0xB4, 0x0B, 0xA0, 0x97, 0x20, 0xEA, 0x08, 0x40, 0xEA, 0x06, 0x71, 0x03, 0xB0, 0x43,
  0x01, 0xB0, 0x37, 0x10, 0x7B, 0x01, 0x30, 0x5B, 0x72, 0x0C, 0xA0, 0xB4, 0x08, 0xA0, 0xC7, 0x10,
  0x4B, 0x05, 0x40, 0xBA, 0x09, 0x71, 0x0A, 0xA0, 0xE5, 0x0E, 0xA0, 0x57, 0x04, 0xB0, 0x64, 0x02,
  0xB0, 0x27, 0x0D, 0xA0, 0xD5, 0x05, 0xA0, 0xE7, 0x0B, 0xB0, 0x35, 0x09, 0xA0, 0xB5, 0x01, 0x0C,
  0xB0, 0x76, 0x0C, 0xA0, 0x83, 0x81, 0x17, 0xEB, 0x07, 0x7B, 0x82, 0xDC, 0xCD, 0xC0, 0xE0, 0x67,
  0x03, 0xFB, 0x0A, 0x01, 0x71, 0x06, 0xE8, 0x2E, 0xB7, 0x27, 0x30,
  // "ď" (U+010F)
  0x77, 0x10, 0x1B, 0x81, 0x10, 0x3B, 0x01, 0x77, 0x10, 0x4A, 0x0E, 0x20, 0x8A, 0x08, 0x77, 0x20,
  0x7A, 0x0A, 0x28, 0x2E, 0xFD, 0x17, 0x72, 0x0B, 0xA8, 0x17, 0x06, 0xA0, 0x47, 0x73, 0x0E, 0xA8,
  0x34, 0x0D, 0xF9, 0x77, 0x30, 0x2B, 0x18, 0x15, 0xFC, 0x77, 0x40, 0x5A, 0x0D, 0x77, 0x71, 0x09,
  0xA0, 0x97, 0x78, 0x43, 0xAE, 0xEC, 0x62, 0x0C, 0xA0, 0x67, 0x60, 0x6E, 0x08, 0x1B, 0x03, 0x75,
  0x07, 0xC0, 0xD0, 0xEA, 0x05, 0xA0, 0xE7, 0x50, 0x4B, 0x0B, 0x01, 0x28, 0x16, 0xFE, 0xA0, 0xB7,
  0x50, 0xDA, 0x0C, 0x50, 0xBB, 0x08, 0x74, 0x06, 0xB0, 0x25, 0x08, 0xB0, 0x57, 0x40, 0xDA, 0x09,
  0x60, 0x7B, 0x01, 0x73, 0x04, 0xB0, 0x26, 0x07, 0xA0, 0xE7, 0x40, 0x9A, 0x0C, 0x70, 0x9A, 0x0A,
  0x74, 0x0D, 0xA0, 0x87, 0x0C, 0xA0, 0x77, 0x30, 0x2B, 0x04, 0x7B, 0x04, 0x73, 0x05, 0xB7, 0x04,
  0xB7, 0x40, 0x7A, 0x0D, 0x70, 0x8A, 0x0C, 0x74, 0x09, 0xA0, 0xA7, 0x0D, 0xA0, 0x97, 0x40, 0xBA,
  0x09, 0x60, 0x4B, 0x06, 0x74, 0x0B, 0xA0, 0x86, 0x0B, 0xB0, 0x27, 0x40, 0xBA, 0x0A, 0x50, 0x5B,
  0x0E, 0x75, 0x09, 0xA0, 0xD4, 0x02, 0x0E, 0xB0, 0xB7, 0x50, 0x6B, 0x06, 0x28, 0x23, 0xDF, 0xCA,
  0x08, 0x75, 0x01, 0x0E, 0xB0, 0x0D, 0xA0, 0x60, 0x9A, 0x05, 0x76, 0x06, 0xE8, 0x16, 0x0A, 0xA0,
  0x17, 0x78, 0x45, 0xCE, 0xEA, 0x32, 0x81, 0xBF, 0xE7, 0x60,
  // "Đ" (U+0110)
  0x60, 0x9D, 0x82, 0xED, 0xA5, 0x74, 0x0C, 0xFA, 0x0C, 0x02, 0x72, 0xB0, 0xFC, 0x0D, 0xC0, 0xE0,
  0x27, 0x03, 0xB0, 0x13, 0x02, 0x0A, 0xB0, 0xC7, 0x06, 0xA0, 0xD6, 0x09, 0xB0, 0x56, 0x09, 0xA0,
  0xA7, 0x0E, 0xA0, 0xB6, 0x0C, 0xA0, 0x77, 0x09, 0xA0, 0xE6, 0xB0, 0x47, 0x06, 0xB0, 0x14, 0x03,
  0xB0, 0x17, 0x05, 0xB0, 0x24, 0x06, 0xA0, 0xD7, 0x10, 0x4B, 0x03, 0x40, 0xAA, 0x0A, 0x71, 0x05,
  0xB0, 0x24, 0x0D, 0xA0, 0x77, 0x10, 0x5B, 0x02, 0x4B, 0x04, 0x71, 0x07, 0xB2, 0x07, 0xFA, 0x05,
  0x40, 0x9A, 0x0E, 0x20, 0xAF, 0xA0, 0x14, 0x0C, 0xA0, 0xB2, 0x81, 0xAC, 0xEA, 0x83, 0xDC, 0xCC,
  0xB5, 0x0E, 0xA0, 0x84, 0x0D, 0xA0, 0x67, 0x10, 0x3B, 0x05, 0x30, 0x1B, 0x03, 0x71, 0x08, 0xB0,
  0x13, 0x04, 0xB7, 0x20, 0xDA, 0x0B, 0x40, 0x7A, 0x0C, 0x71, 0x04, 0xB0, 0x54, 0x0B, 0xA0, 0x97,
  0x10, 0xBA, 0x0E, 0x50, 0xEA, 0x05, 0x70, 0x5B, 0x06, 0x40, 0x2B, 0x02, 0x60, 0x10, 0xDA, 0x0D,
  0x50, 0x5A, 0x0E, 0x70, 0xCB, 0x03, 0x50, 0x8A, 0x0B, 0x50, 0x10, 0xCB, 0x07, 0x60, 0xCA, 0x08,
  0x38, 0x11, 0x7E, 0xB0, 0x87, 0xB8, 0x2D, 0xCC, 0xDD, 0x06, 0x70, 0x3F, 0xB0, 0xB0, 0x27, 0x10,
  0x6E, 0x82, 0xEB, 0x82, 0x73,
  // "đ" (U+0111)
  0x77, 0x10, 0x1B, 0x01, 0x77, 0x20, 0x6A, 0x0C, 0x75, 0x84, 0x47, 0x77, 0x7C, 0xA8, 0x1C, 0x77,
  0x73, 0x0B, 0xFA, 0x0C, 0x73, 0x0E, 0xFA, 0x09, 0x77, 0x05, 0xA0, 0xD7, 0x73, 0x07, 0xA0, 0x97,
  0x73, 0x0A, 0xA0, 0x67, 0x28, 0x43, 0xAE, 0xEC, 0x62, 0x0D, 0xA0, 0x37, 0x10, 0x7E, 0x08, 0x1B,
  0x71, 0x08, 0xC0, 0xD0, 0xEA, 0x05, 0xA0, 0xC7, 0x04, 0xB0, 0xB0, 0x12, 0x81, 0x6F, 0xEA, 0x09,
  0x70, 0xDA, 0x0C, 0x50, 0xBB, 0x06, 0x60, 0x7B, 0x02, 0x50, 0x8B, 0x03, 0x60, 0xDA, 0x09, 0x60,
  0x7B, 0x60, 0x4B, 0x02, 0x60, 0x7A, 0x0C, 0x60, 0x9A, 0x0C, 0x70, 0x9A, 0x09, 0x60, 0xDA, 0x07,
  0x70, 0xCA, 0x05, 0x50, 0x2B, 0x04, 0x7B, 0x02, 0x50, 0x5B, 0x70, 0x4A, 0x0E, 0x60, 0x7A, 0x0D,
  0x70, 0x8A, 0x0B, 0x60, 0x9A, 0x0A, 0x70, 0xDA, 0x08, 0x60, 0xBA, 0x09, 0x60, 0x4B, 0x05, 0x60,
  0xBA, 0x08, 0x60, 0xBB, 0x02, 0x60, 0xBA, 0x0A, 0x50, 0x5B, 0x0E, 0x70, 0x9A, 0x0D, 0x40, 0x20,
  0xEB, 0x0B, 0x70, 0x6B, 0x06, 0x28, 0x23, 0xDF, 0xCA, 0x08, 0x70, 0x10, 0xEB, 0x00, 0xDA, 0x06,
  0x09, 0xA0, 0x47, 0x10, 0x6E, 0x81, 0x60, 0xAA, 0x01, 0x72, 0x84, 0x4C, 0xEE, 0xA3, 0x28, 0x1B,
  0xFD, 0x71,
  // "Ē" (U+0112)
  0x71, 0x80, 0x5C, 0x0A, 0x70, 0x3F, 0xA0, 0xB7, 0x06, 0xFA, 0x08, 0x80, 0xF0, 0x00, 0x9F, 0xC6,
  0x0C, 0xFB, 0x0C, 0x6B, 0x80, 0x4C, 0x07, 0x50, 0x3B, 0x77, 0x06, 0xA0, 0xD7, 0x70, 0x9A, 0x0A,
  0x77, 0x0D, 0xA0, 0x67, 0x7B, 0x03, 0x76, 0x03, 0xB7, 0x70, 0x7A, 0x0C, 0x77, 0x0A, 0xA0, 0x97,
  0x70, 0xDA, 0x06, 0x76, 0x01, 0xB0, 0xD8, 0x02, 0xC0, 0xB6, 0x04, 0xFB, 0x0B, 0x60, 0x7F, 0xB0,
  0x76, 0x0B, 0xA0, 0x87, 0x70, 0xEA, 0x05, 0x76, 0x01, 0xB0, 0x27, 0x60, 0x5A, 0x0E, 0x77, 0x08,
  0xA0, 0xB7, 0x70, 0xBA, 0x08, 0x77, 0x0E, 0xA0, 0x57, 0x60, 0x2B, 0x02, 0x76, 0x05, 0xA0, 0xE7,
  0x70, 0x9A, 0x0B, 0x77, 0x0C, 0xA0, 0x87, 0x7B, 0x0D, 0x80, 0x3C, 0x07, 0x50, 0x3F, 0xC0, 0x65,
  0x06, 0xFC, 0x03, 0x50,
  // "ē" (U+0113)
  0x68, 0x05, 0xC0, 0xA5, 0x03, 0xFA, 0x0B, 0x50, 0x6F, 0xA0, 0x88, 0x0E, 0x20, 0x85, 0x18, 0xCE,
  0xFC, 0x77, 0x10, 0x50, 0xEE, 0x0C, 0x60, 0x6B, 0x81, 0xEC, 0xEB, 0x07, 0x40, 0x3B, 0x09, 0x30,
  0xAA, 0x0B, 0x30, 0x10, 0xEA, 0x08, 0x40, 0x4A, 0x0C, 0x30, 0x7A, 0x0C, 0x50, 0x5A, 0x0B, 0x20,
  0x10, 0xEA, 0x03, 0x50, 0xAA, 0x08, 0x20, 0x6A, 0x0B, 0x50, 0x7B, 0x02, 0x20, 0xBA, 0x06, 0x28,
  0x11, 0x5C, 0xB0, 0x72, 0x01, 0xB8, 0x1D, 0xCE, 0xD0, 0x83, 0x04, 0xFA, 0x0C, 0x04, 0x40, 0x7C,
  0x83, 0xED, 0xB8, 0x36, 0x09, 0xA0, 0xA7, 0x50, 0xAA, 0x09, 0x75, 0x0B, 0xA0, 0x77, 0x50, 0xBA,
  0x08, 0x75, 0x0A, 0xA0, 0xB7, 0x50, 0x7B, 0x01, 0x74, 0x02, 0xB0, 0xC0, 0x23, 0x81, 0x27, 0xB5,
  0x09, 0xC8, 0x1D, 0xCD, 0xA0, 0xD6, 0x0B, 0xF9, 0x0B, 0x78, 0x65, 0xBE, 0xFE, 0xC9, 0x35,
  // "Ĕ" (U+0114)
  0x71, 0x81, 0x37, 0x55, 0x81, 0x67, 0x27, 0x18, 0x17, 0xFB, 0x40, 0x1A, 0x01, 0x71, 0x06, 0xA0,
  0x23, 0x81, 0xBF, 0xB7, 0x20, 0x3A, 0x82, 0xEA, 0xAE, 0xA0, 0x47, 0x30, 0xAE, 0x08, 0x75, 0x84,
  0x7D, 0xFE, 0xB4, 0x80, 0xD3, 0x00, 0x9F, 0xC7, 0x0C, 0xFB, 0x0C, 0x7B, 0x80, 0x4C, 0x07, 0x60,
  0x3B, 0x77, 0x10, 0x6A, 0x0D, 0x77, 0x10, 0x9A, 0x0A, 0x77, 0x10, 0xDA, 0x06, 0x77, 0x1B, 0x03,
  0x77, 0x03, 0xB7, 0x71, 0x07, 0xA0, 0xC7, 0x71, 0x0A, 0xA0, 0x97, 0x71, 0x0D, 0xA0, 0x67, 0x70,
  0x1B, 0x0D, 0x80, 0x2C, 0x0B, 0x70, 0x4F, 0xB0, 0xB7, 0x07, 0xFB, 0x07, 0x70, 0xBA, 0x08, 0x77,
  0x10, 0xEA, 0x05, 0x77, 0x01, 0xB0, 0x27, 0x70, 0x5A, 0x0E, 0x77, 0x10, 0x8A, 0x0B, 0x77, 0x10,
  0xBA, 0x08, 0x77, 0x10, 0xEA, 0x05, 0x77, 0x02, 0xB0, 0x27, 0x70, 0x5A, 0x0E, 0x77, 0x10, 0x9A,
  0x0B, 0x77, 0x10, 0xCA, 0x08, 0x77, 0x1B, 0x0D, 0x80, 0x3C, 0x07, 0x60, 0x3F, 0xC0, 0x66, 0x06,
  0xFC, 0x03, 0x60,
  // "ĕ" (U+0115)
  0x68, 0x13, 0x75, 0x58, 0x16, 0x72, 0x68, 0x17, 0xFB, 0x40, 0x1A, 0x01, 0x60, 0x6A, 0x02, 0x38,
  0x1B, 0xFB, 0x70, 0x3A, 0x82, 0xEA, 0xAE, 0xA0, 0x47, 0x10, 0xAE, 0x08, 0x73, 0x84, 0x7D, 0xFE,
  0xB4, 0x80, 0xC7, 0x08, 0x51, 0x8C, 0xEF, 0xC7, 0x72, 0x05, 0x0E, 0xE0, 0xC7, 0x06, 0xB8, 0x1E,
  0xCE, 0xB0, 0x75, 0x03, 0xB0, 0x93, 0x0A, 0xA0, 0xB4, 0x01, 0x0E, 0xA0, 0x84, 0x04, 0xA0, 0xC4,
  0x07, 0xA0, 0xC5, 0x05, 0xA0, 0xB3, 0x01, 0x0E, 0xA0, 0x35, 0x0A, 0xA0, 0x83, 0x06, 0xA0, 0xB5,
  0x07, 0xB0, 0x23, 0x0B, 0xA0, 0x62, 0x81, 0x15, 0xCB, 0x07, 0x30, 0x1B, 0x81, 0xDC, 0xED, 0x08,
  0x40, 0x4F, 0xA0, 0xC0, 0x45, 0x07, 0xC8, 0x3E, 0xDB, 0x83, 0x70, 0x9A, 0x0A, 0x76, 0x0A, 0xA0,
  0x97, 0x60, 0xBA, 0x07, 0x76, 0x0B, 0xA0, 0x87, 0x60, 0xAA, 0x0B, 0x76, 0x07, 0xB0, 0x17, 0x50,
  0x2B, 0x0C, 0x02, 0x38, 0x12, 0x7B, 0x60, 0x9C, 0x81, 0xDC, 0xDA, 0x0D, 0x70, 0xBF, 0x90, 0xB7,
  0x18, 0x65, 0xBE, 0xFE, 0xC9, 0x36,
  // "Ė" (U+0116)
  0x74, 0x82, 0x2C, 0xE8, 0x77, 0x0A, 0xA0, 0xE7, 0x70, 0xDA, 0x0C, 0x77, 0x82, 0x7E, 0xC2, 0x80,
  0xD1, 0x00, 0x9F, 0xC6, 0x0C, 0xFB, 0x0C, 0x6B, 0x80, 0x4C, 0x07, 0x50, 0x3B, 0x77, 0x06, 0xA0,
  0xD7, 0x70, 0x9A, 0x0A, 0x77, 0x0D, 0xA0, 0x67, 0x7B, 0x03, 0x76, 0x03, 0xB7, 0x70, 0x7A, 0x0C,
  0x77, 0x0A, 0xA0, 0x97, 0x70, 0xDA, 0x06, 0x76, 0x01, 0xB0, 0xD8, 0x02, 0xC0, 0xB6, 0x04, 0xFB,
  0x0B, 0x60, 0x7F, 0xB0, 0x76, 0x0B, 0xA0, 0x87, 0x70, 0xEA, 0x05, 0x76, 0x01, 0xB0, 0x27, 0x60,
  0x5A, 0x0E, 0x77, 0x08, 0xA0, 0xB7, 0x70, 0xBA, 0x08, 0x77, 0x0E, 0xA0, 0x57, 0x60, 0x2B, 0x02,
  0x76, 0x05, 0xA0, 0xE7, 0x70, 0x9A, 0x0B, 0x77, 0x0C, 0xA0, 0x87, 0x7B, 0x0D, 0x80, 0x3C, 0x07,
  0x50, 0x3F, 0xC0, 0x65, 0x06, 0xFC, 0x03, 0x50,
  // "ė" (U+0117)
  0x72, 0x82, 0x2C, 0xE8, 0x74, 0x0A, 0xA0, 0xE7, 0x40, 0xDA, 0x0C, 0x74, 0x82, 0x7E, 0xC2, 0x80,
  0xE1, 0x08, 0x51, 0x8C, 0xEF, 0xC7, 0x70, 0x50, 0xEE, 0x0C, 0x50, 0x6B, 0x81, 0xEC, 0xEB, 0x07,
  0x30, 0x3B, 0x09, 0x30, 0xAA, 0x0B, 0x20, 0x10, 0xEA, 0x08, 0x40, 0x4A, 0x0C, 0x20, 0x7A, 0x0C,
  0x50, 0x5A, 0x82, 0xB0, 0x1E, 0xA0, 0x35, 0x0A, 0xA8, 0x18, 0x06, 0xA0, 0xB5, 0x07, 0xB8, 0x12,
  0x0B, 0xA0, 0x62, 0x81, 0x15, 0xCB, 0x81, 0x70, 0x1B, 0x81, 0xDC, 0xED, 0x08, 0x20, 0x4F, 0xA0,
  0xC0, 0x43, 0x07, 0xC8, 0x3E, 0xDB, 0x83, 0x50, 0x9A, 0x0A, 0x74, 0x0A, 0xA0, 0x97, 0x40, 0xBA,
  0x07, 0x74, 0x0B, 0xA0, 0x87, 0x40, 0xAA, 0x0B, 0x74, 0x07, 0xB0, 0x17, 0x30, 0x2B, 0x0C, 0x02,
  0x38, 0x12, 0x7B, 0x40, 0x9C, 0x81, 0xDC, 0xDA, 0x0D, 0x50, 0xBF, 0x90, 0xB6, 0x86, 0x5B, 0xEF,
  0xEC, 0x93, 0x40,
  // "Ę" (U+0118)
  0x60, 0x9F, 0xC6, 0x0C, 0xFB, 0x0C, 0x6B, 0x80, 0x4C, 0x07, 0x50, 0x3B, 0x77, 0x06, 0xA0, 0xD7,
  0x70, 0x9A, 0x0A, 0x77, 0x0D, 0xA0, 0x67, 0x7B, 0x03, 0x76, 0x03, 0xB7, 0x70, 0x7A, 0x0C, 0x77,
  0x0A, 0xA0, 0x97, 0x70, 0xDA, 0x06, 0x76, 0x01, 0xB0, 0xD8, 0x02, 0xC0, 0xB6, 0x04, 0xFB, 0x0B,
  0x60, 0x7F, 0xB0, 0x76, 0x0B, 0xA0, 0x87, 0x70, 0xEA, 0x05, 0x76, 0x01, 0xB0, 0x27, 0x60, 0x5A,
  0x0E, 0x77, 0x08, 0xA0, 0xB7, 0x70, 0xBA, 0x08, 0x77, 0x0E, 0xA0, 0x57, 0x60, 0x2B, 0x02, 0x76,
  0x05, 0xA0, 0xE7, 0x70, 0x9A, 0x0B, 0x77, 0x0C, 0xA0, 0x87, 0x7B, 0x0D, 0x80, 0x3C, 0x07, 0x50,
  0x3F, 0xC0, 0x65, 0x06, 0xFC, 0x03, 0x75, 0x82, 0x6F, 0xC1, 0x76, 0x81, 0x8F, 0xC7, 0x78, 0x27,
  0xFD, 0x17, 0x60, 0x2A, 0x06, 0x77, 0x09, 0xA0, 0x17, 0x70, 0xBA, 0x02, 0x77, 0x0B, 0xA8, 0x1E,
  0xCA, 0x75, 0x06, 0xC0, 0x97, 0x68, 0x37, 0xDF, 0xD5, 0x71,
  // "ę" (U+0119)
  0x68, 0x51, 0x8C, 0xEF, 0xC7, 0x70, 0x50, 0xEE, 0x0C, 0x50, 0x6B, 0x81, 0xEC, 0xEB, 0x07, 0x30,
  0x3B, 0x09, 0x30, 0xAA, 0x0B, 0x20, 0x10, 0xEA, 0x08, 0x40, 0x4A, 0x0C, 0x20, 0x7A, 0x0C, 0x50,
  0x5A, 0x82, 0xB0, 0x1E, 0xA0, 0x35, 0x0A, 0xA8, 0x18, 0x06, 0xA0, 0xB5, 0x07, 0xB8, 0x12, 0x0B,
  0xA0, 0x62, 0x81, 0x15, 0xCB, 0x81, 0x70, 0x1B, 0x81, 0xDC, 0xED, 0x08, 0x20, 0x4F, 0xA0, 0xC0,
  0x43, 0x07, 0xC8, 0x3E, 0xDB, 0x83, 0x50, 0x9A, 0x0A, 0x74, 0x0A, 0xA0, 0x97, 0x40, 0xBA, 0x07,
  0x74, 0x0B, 0xA0, 0x87, 0x40, 0xAA, 0x0B, 0x74, 0x07, 0xB0, 0x17, 0x30, 0x2B, 0x0C, 0x02, 0x38,
  0x12, 0x7B, 0x40, 0x9C, 0x81, 0xDC, 0xDA, 0x0D, 0x50, 0xBF, 0x90, 0xA6, 0x81, 0x5B, 0xEC, 0x07,
  0x73, 0x82, 0x2D, 0xF5, 0x73, 0x82, 0x1E, 0xF6, 0x74, 0x81, 0xBF, 0xC7, 0x40, 0x2A, 0x07, 0x74,
  0x05, 0xA0, 0x87, 0x40, 0x5B, 0x0C, 0x0D, 0x72, 0x01, 0x0E, 0xB0, 0xE7, 0x38, 0x34, 0xCE, 0xE9,
  0x50,
  // "Ě" (U+011A)
  0x71, 0x81, 0x17, 0x66, 0x81, 0x67, 0x27, 0x28, 0x1E, 0xF7, 0x38, 0x21, 0xBF, 0xB7, 0x30, 0x7A,
  0x84, 0x20, 0x1D, 0xFC, 0x74, 0x01, 0xA8, 0x4B, 0x1D, 0xFD, 0x17, 0x50, 0x9A, 0x82, 0xEF, 0xE3,
  0x76, 0x03, 0xC0, 0x57, 0x71, 0x0D, 0xA0, 0x98, 0x0D, 0x70, 0x09, 0xFC, 0x71, 0x0C, 0xFB, 0x0C,
  0x71, 0xB8, 0x04, 0xC0, 0x77, 0x03, 0xB7, 0x72, 0x06, 0xA0, 0xD7, 0x72, 0x09, 0xA0, 0xA7, 0x72,
  0x0D, 0xA0, 0x67, 0x72, 0xB0, 0x37, 0x71, 0x03, 0xB7, 0x72, 0x07, 0xA0, 0xC7, 0x72, 0x0A, 0xA0,
  0x97, 0x72, 0x0D, 0xA0, 0x67, 0x71, 0x01, 0xB0, 0xD8, 0x02, 0xC0, 0xB7, 0x10, 0x4F, 0xB0, 0xB7,
  0x10, 0x7F, 0xB0, 0x77, 0x10, 0xBA, 0x08, 0x77, 0x20, 0xEA, 0x05, 0x77, 0x10, 0x1B, 0x02, 0x77,
  0x10, 0x5A, 0x0E, 0x77, 0x20, 0x8A, 0x0B, 0x77, 0x20, 0xBA, 0x08, 0x77, 0x20, 0xEA, 0x05, 0x77,
  0x10, 0x2B, 0x02, 0x77, 0x10, 0x5A, 0x0E, 0x77, 0x20, 0x9A, 0x0B, 0x77, 0x20, 0xCA, 0x08, 0x77,
  0x2B, 0x0D, 0x80, 0x3C, 0x07, 0x70, 0x3F, 0xC0, 0x67, 0x06, 0xFC, 0x03, 0x70,
  // "ě" (U+011B)
  0x68, 0x11, 0x76, 0x68, 0x16, 0x72, 0x78, 0x1E, 0xF7, 0x38, 0x21, 0xBF, 0xB7, 0x10, 0x7A, 0x84,
  0x20, 0x1D, 0xFC, 0x72, 0x01, 0xA8, 0x4B, 0x1D, 0xFD, 0x17, 0x30, 0x9A, 0x82, 0xEF, 0xE3, 0x74,
  0x03, 0xC0, 0x57, 0x60, 0xDA, 0x09, 0x80, 0xD3, 0x08, 0x51, 0x8C, 0xEF, 0xC7, 0x73, 0x05, 0x0E,
  0xE0, 0xC7, 0x10, 0x6B, 0x81, 0xEC, 0xEB, 0x07, 0x60, 0x3B, 0x09, 0x30, 0xAA, 0x0B, 0x50, 0x10,
  0xEA, 0x08, 0x40, 0x4A, 0x0C, 0x50, 0x7A, 0x0C, 0x50, 0x5A, 0x0B, 0x40, 0x10, 0xEA, 0x03, 0x50,
  0xAA, 0x08, 0x40, 0x6A, 0x0B, 0x50, 0x7B, 0x02, 0x40, 0xBA, 0x06, 0x28, 0x11, 0x5C, 0xB0, 0x74,
  0x01, 0xB8, 0x1D, 0xCE, 0xD0, 0x85, 0x04, 0xFA, 0x0C, 0x04, 0x60, 0x7C, 0x83, 0xED, 0xB8, 0x37,
  0x10, 0x9A, 0x0A, 0x77, 0x0A, 0xA0, 0x97, 0x70, 0xBA, 0x07, 0x77, 0x0B, 0xA0, 0x87, 0x70, 0xAA,
  0x0B, 0x77, 0x07, 0xB0, 0x17, 0x60, 0x2B, 0x0C, 0x02, 0x38, 0x12, 0x7B, 0x70, 0x9C, 0x81, 0xDC,
  0xDA, 0x0D, 0x71, 0x0B, 0xF9, 0x0B, 0x72, 0x86, 0x5B, 0xEF, 0xEC, 0x93, 0x70,
  // "Ĝ" (U+011C)
  0x77, 0x82, 0x47, 0x74, 0x77, 0x30, 0x20, 0xEA, 0x0C, 0x77, 0x30, 0xCC, 0x03, 0x77, 0x10, 0xAA,
  0x09, 0xA0, 0x97, 0x70, 0x8A, 0x81, 0x50, 0xAA, 0x01, 0x75, 0x82, 0x7F, 0xE4, 0x28, 0x21, 0xEF,
  0x77, 0x48, 0x24, 0xFD, 0x34, 0x81, 0x4F, 0xE8, 0x0E, 0x40, 0x89, 0x02, 0x8B, 0xEF, 0xED, 0xB7,
  0x27, 0x30, 0x10, 0xAF, 0xB0, 0xB0, 0x17, 0x05, 0x0E, 0xC8, 0x1D, 0xCD, 0xC0, 0xD7, 0x06, 0xB8,
  0x1E, 0x71, 0x48, 0x24, 0xBF, 0x56, 0x05, 0xB0, 0xD0, 0x27, 0x10, 0x36, 0x02, 0x0E, 0xA0, 0xD0,
  0x17, 0x72, 0x0B, 0xB0, 0x27, 0x72, 0x04, 0xB0, 0x77, 0x73, 0x0C, 0xA0, 0xD7, 0x73, 0x03, 0xB0,
  0x67, 0x73, 0x09, 0xA0, 0xE7, 0x74, 0x0E, 0xA0, 0x97, 0x73, 0x03, 0xB0, 0x47, 0x73, 0x06, 0xB6,
  0x02, 0x80, 0x3C, 0x02, 0x30, 0xAA, 0x0C, 0x60, 0x6F, 0x40, 0xDA, 0x0A, 0x60, 0xAE, 0x0C, 0x40,
  0xEA, 0x07, 0x73, 0x0A, 0xA0, 0x94, 0xB0, 0x67, 0x30, 0xDA, 0x06, 0x30, 0x1B, 0x05, 0x72, 0x01,
  0xB0, 0x33, 0x01, 0xB0, 0x57, 0x20, 0x4B, 0x40, 0x1B, 0x05, 0x72, 0x07, 0xA0, 0xC5, 0xB0, 0x77,
  0x20, 0xAA, 0x08, 0x50, 0xCA, 0x0B, 0x72, 0x0D, 0xA0, 0x55, 0x09, 0xB0, 0x17, 0x01, 0xB0, 0x25,
  0x03, 0xB0, 0xA7, 0x04, 0xA0, 0xE7, 0x0B, 0xB0, 0xB0, 0x24, 0x01, 0x09, 0xA0, 0xB7, 0x01, 0x0D,
  0xC8, 0x2E, 0xCC, 0xEC, 0x08, 0x71, 0x01, 0x0B, 0xFB, 0x0D, 0x03, 0x73, 0x89, 0x04, 0x9C, 0xEF,
  0xED, 0xB7, 0x27,
  // "ĝ" (U+011D)
  0x75, 0x82, 0x47, 0x74, 0x77, 0x10, 0x20, 0xEA, 0x0C, 0x77, 0x10, 0xCC, 0x03, 0x76, 0x0A, 0xA0,
  0x9A, 0x09, 0x75, 0x08, 0xA8, 0x15, 0x0A, 0xA0, 0x17, 0x38, 0x27, 0xFE, 0x42, 0x82, 0x1E, 0xF7,
  0x72, 0x82, 0x4F, 0xD3, 0x48, 0x14, 0xFE, 0x80, 0xD6, 0x08, 0x42, 0x9D, 0xFD, 0x72, 0x06, 0xA0,
  0x37, 0x06, 0xE8, 0x19, 0x0A, 0xA7, 0x06, 0xC0, 0xD0, 0xEA, 0x82, 0x3E, 0xFC, 0x60, 0x3B, 0x0B,
  0x02, 0x28, 0x16, 0xFD, 0xA0, 0x96, 0x0D, 0xA0, 0xC5, 0x0C, 0xB0, 0x65, 0x06, 0xB0, 0x25, 0x08,
  0xB0, 0x35, 0x0D, 0xA0, 0x96, 0x07, 0xB5, 0x04, 0xB0, 0x26, 0x08, 0xA0, 0xC5, 0x09, 0xA0, 0xC7,
  0x0A, 0xA0, 0x85, 0x0D, 0xA0, 0x87, 0x0C, 0xA0, 0x54, 0x02, 0xB0, 0x47, 0xB0, 0x24, 0x05, 0xB7,
  0x04, 0xA0, 0xE5, 0x07, 0xA0, 0xD7, 0x08, 0xA0, 0xB5, 0x09, 0xA0, 0xA7, 0x0E, 0xA0, 0x75, 0x0B,
  0xA0, 0x96, 0x04, 0xB0, 0x45, 0x0B, 0xA0, 0x86, 0x0C, 0xB0, 0x15, 0x0B, 0xA0, 0xA5, 0x05, 0xB0,
  0xD6, 0x09, 0xA0, 0xD4, 0x02, 0x0E, 0xB0, 0xA6, 0x06, 0xB0, 0x62, 0x82, 0x3D, 0xFD, 0xA0, 0x76,
  0x01, 0x0E, 0xB0, 0x0D, 0xA0, 0x80, 0xDA, 0x03, 0x70, 0x6E, 0x08, 0x01, 0xB7, 0x28, 0x65, 0xCF,
  0xEA, 0x30, 0x5A, 0x0C, 0x77, 0x20, 0x8A, 0x09, 0x77, 0x20, 0xDA, 0x05, 0x77, 0x10, 0x2B, 0x01,
  0x77, 0x10, 0x9A, 0x0B, 0x60, 0x17, 0x10, 0x4B, 0x04, 0x68, 0x24, 0xD6, 0x14, 0x07, 0xB0, 0xB7,
  0x04, 0xB8, 0x1D, 0xCC, 0xC0, 0xD0, 0x17, 0x03, 0xFA, 0x0B, 0x01, 0x72, 0x87, 0x17, 0xBE, 0xFE,
  0xD9, 0x47, 0x30,
  // "Ğ" (U+011E)
  0x73, 0x81, 0x37, 0x55, 0x81, 0x67, 0x27, 0x48, 0x17, 0xFB, 0x40, 0x1A, 0x01, 0x74, 0x06, 0xA0,
  0x23, 0x81, 0xBF, 0xB7, 0x50, 0x3A, 0x82, 0xEA, 0xAE, 0xA0, 0x47, 0x60, 0xAE, 0x08, 0x77, 0x18,
  0x47, 0xDF, 0xEB, 0x48, 0x0E, 0x60, 0x89, 0x02, 0x8B, 0xEF, 0xED, 0xB7, 0x27, 0x30, 0x10, 0xAF,
  0xB0, 0xB0, 0x17, 0x05, 0x0E, 0xC8, 0x1D, 0xCD, 0xC0, 0xD7, 0x06, 0xB8, 0x1E, 0x71, 0x48, 0x24,
  0xBF, 0x56, 0x05, 0xB0, 0xD0, 0x27, 0x10, 0x36, 0x02, 0x0E, 0xA0, 0xD0, 0x17, 0x72, 0x0B, 0xB0,
  0x27, 0x72, 0x04, 0xB0, 0x77, 0x73, 0x0C, 0xA0, 0xD7, 0x73, 0x03, 0xB0, 0x67, 0x73, 0x09, 0xA0,
  0xE7, 0x74, 0x0E, 0xA0, 0x97, 0x73, 0x03, 0xB0, 0x47, 0x73, 0x06, 0xB6, 0x02, 0x80, 0x3C, 0x02,
  0x30, 0xAA, 0x0C, 0x60, 0x6F, 0x40, 0xDA, 0x0A, 0x60, 0xAE, 0x0C, 0x40, 0xEA, 0x07, 0x73, 0x0A,
  0xA0, 0x94, 0xB0, 0x67, 0x30, 0xDA, 0x06, 0x30, 0x1B, 0x05, 0x72, 0x01, 0xB0, 0x33, 0x01, 0xB0,
  0x57, 0x20, 0x4B, 0x40, 0x1B, 0x05, 0x72, 0x07, 0xA0, 0xC5, 0xB0, 0x77, 0x20, 0xAA, 0x08, 0x50,
  0xCA, 0x0B, 0x72, 0x0D, 0xA0, 0x55, 0x09, 0xB0, 0x17, 0x01, 0xB0, 0x25, 0x03, 0xB0, 0xA7, 0x04,
  0xA0, 0xE7, 0x0B, 0xB0, 0xB0, 0x24, 0x01, 0x09, 0xA0, 0xB7, 0x01, 0x0D, 0xC8, 0x2E, 0xCC, 0xEC,
  0x08, 0x71, 0x01, 0x0B, 0xFB, 0x0D, 0x03, 0x73, 0x89, 0x04, 0x9C, 0xEF, 0xED, 0xB7, 0x27,
  // "ğ" (U+011F)
  0x71, 0x81, 0x37, 0x55, 0x81, 0x67, 0x27, 0x28, 0x17, 0xFB, 0x40, 0x1A, 0x01, 0x72, 0x06, 0xA0,
  0x23, 0x81, 0xBF, 0xB7, 0x30, 0x3A, 0x82, 0xEA, 0xAE, 0xA0, 0x47, 0x40, 0xAE, 0x08, 0x76, 0x84,
  0x7D, 0xFE, 0xB4, 0x80, 0xE0, 0x08, 0x42, 0x9D, 0xFD, 0x72, 0x06, 0xA0, 0x37, 0x06, 0xE8, 0x19,
  0x0A, 0xA7, 0x06, 0xC0, 0xD0, 0xEA, 0x82, 0x3E, 0xFC, 0x60, 0x3B, 0x0B, 0x02, 0x28, 0x16, 0xFD,
  0xA0, 0x96, 0x0D, 0xA0, 0xC5, 0x0C, 0xB0, 0x65, 0x06, 0xB0, 0x25, 0x08, 0xB0, 0x35, 0x0D, 0xA0,
  0x96, 0x07, 0xB5, 0x04, 0xB0, 0x26, 0x08, 0xA0, 0xC5, 0x09, 0xA0, 0xC7, 0x0A, 0xA0, 0x85, 0x0D,
  0xA0, 0x87, 0x0C, 0xA0, 0x54, 0x02, 0xB0, 0x47, 0xB0, 0x24, 0x05, 0xB7, 0x04, 0xA0, 0xE5, 0x07,
  0xA0, 0xD7, 0x08, 0xA0, 0xB5, 0x09, 0xA0, 0xA7, 0x0E, 0xA0, 0x75, 0x0B, 0xA0, 0x96, 0x04, 0xB0,
  0x45, 0x0B, 0xA0, 0x86, 0x0C, 0xB0, 0x15, 0x0B, 0xA0, 0xA5, 0x05, 0xB0, 0xD6, 0x09, 0xA0, 0xD4,
  0x02, 0x0E, 0xB0, 0xA6, 0x06, 0xB0, 0x62, 0x82, 0x3D, 0xFD, 0xA0, 0x76, 0x01, 0x0E, 0xB0, 0x0D,
  0xA0, 0x80, 0xDA, 0x03, 0x70, 0x6E, 0x08, 0x01, 0xB7, 0x28, 0x65, 0xCF, 0xEA, 0x30, 0x5A, 0x0C,
  0x77, 0x20, 0x8A, 0x09, 0x77, 0x20, 0xDA, 0x05, 0x77, 0x10, 0x2B, 0x01, 0x77, 0x10, 0x9A, 0x0B,
  0x60, 0x17, 0x10, 0x4B, 0x04, 0x68, 0x24, 0xD6, 0x14, 0x07, 0xB0, 0xB7, 0x04, 0xB8, 0x1D, 0xCC,
  0xC0, 0xD0, 0x17, 0x03, 0xFA, 0x0B, 0x01, 0x72, 0x87, 0x17, 0xBE, 0xFE, 0xD9, 0x47, 0x30,
  // "Ġ" (U+0120)
  0x77, 0x82, 0x2C, 0xE8, 0x77, 0x40, 0xAA, 0x0E, 0x77, 0x40, 0xDA, 0x0C, 0x77, 0x48, 0x27, 0xEC,
  0x28, 0x09, 0x94, 0x08, 0x90, 0x28, 0xBE, 0xFE, 0xDB, 0x72, 0x73, 0x01, 0x0A, 0xFB, 0x0B, 0x01,
  0x70, 0x50, 0xEC, 0x81, 0xDC, 0xDC, 0x0D, 0x70, 0x6B, 0x81, 0xE7, 0x14, 0x82, 0x4B, 0xF5, 0x60,
  0x5B, 0x0D, 0x02, 0x71, 0x03, 0x60, 0x20, 0xEA, 0x0D, 0x01, 0x77, 0x20, 0xBB, 0x02, 0x77, 0x20,
  0x4B, 0x07, 0x77, 0x30, 0xCA, 0x0D, 0x77, 0x30, 0x3B, 0x06, 0x77, 0x30, 0x9A, 0x0E, 0x77, 0x40,
  0xEA, 0x09, 0x77, 0x30, 0x3B, 0x04, 0x77, 0x30, 0x6B, 0x60, 0x28, 0x03, 0xC0, 0x23, 0x0A, 0xA0,
  0xC6, 0x06, 0xF4, 0x0D, 0xA0, 0xA6, 0x0A, 0xE0, 0xC4, 0x0E, 0xA0, 0x77, 0x30, 0xAA, 0x09, 0x4B,
  0x06, 0x73, 0x0D, 0xA0, 0x63, 0x01, 0xB0, 0x57, 0x20, 0x1B, 0x03, 0x30, 0x1B, 0x05, 0x72, 0x04,
  0xB4, 0x01, 0xB0, 0x57, 0x20, 0x7A, 0x0C, 0x5B, 0x07, 0x72, 0x0A, 0xA0, 0x85, 0x0C, 0xA0, 0xB7,
  0x20, 0xDA, 0x05, 0x50, 0x9B, 0x01, 0x70, 0x1B, 0x02, 0x50, 0x3B, 0x0A, 0x70, 0x4A, 0x0E, 0x70,
  0xBB, 0x0B, 0x02, 0x40, 0x10, 0x9A, 0x0B, 0x70, 0x10, 0xDC, 0x82, 0xEC, 0xCE, 0xC0, 0x87, 0x10,
  0x10, 0xBF, 0xB0, 0xD0, 0x37, 0x38, 0x90, 0x49, 0xCE, 0xFE, 0xDB, 0x72, 0x70,
  // "ġ" (U+0121)
  0x74, 0x82, 0x2C, 0xE8, 0x77, 0x20, 0xAA, 0x0E, 0x77, 0x20, 0xDA, 0x0C, 0x77, 0x28, 0x27, 0xEC,
  0x28, 0x09, 0x85, 0x08, 0x42, 0x9D, 0xFD, 0x72, 0x06, 0xA0, 0x37, 0x06, 0xE8, 0x19, 0x0A, 0xA7,
  0x06, 0xC0, 0xD0, 0xEA, 0x82, 0x3E, 0xFC, 0x60, 0x3B, 0x0B, 0x02, 0x28, 0x16, 0xFD, 0xA0, 0x96,
  0x0D, 0xA0, 0xC5, 0x0C, 0xB0, 0x65, 0x06, 0xB0, 0x25, 0x08, 0xB0, 0x35, 0x0D, 0xA0, 0x96, 0x07,
  0xB5, 0x04, 0xB0, 0x26, 0x08, 0xA0, 0xC5, 0x09, 0xA0, 0xC7, 0x0A, 0xA0, 0x85, 0x0D, 0xA0, 0x87,
  0x0C, 0xA0, 0x54, 0x02, 0xB0, 0x47, 0xB0, 0x24, 0x05, 0xB7, 0x04, 0xA0, 0xE5, 0x07, 0xA0, 0xD7,
  0x08, 0xA0, 0xB5, 0x09, 0xA0, 0xA7, 0x0E, 0xA0, 0x75, 0x0B, 0xA0, 0x96, 0x04, 0xB0, 0x45, 0x0B,
  0xA0, 0x86, 0x0C, 0xB0, 0x15, 0x0B, 0xA0, 0xA5, 0x05, 0xB0, 0xD6, 0x09, 0xA0, 0xD4, 0x02, 0x0E,
  0xB0, 0xA6, 0x06, 0xB0, 0x62, 0x82, 0x3D, 0xFD, 0xA0, 0x76, 0x01, 0x0E, 0xB0, 0x0D, 0xA0, 0x80,
  0xDA, 0x03, 0x70, 0x6E, 0x08, 0x01, 0xB7, 0x28, 0x65, 0xCF, 0xEA, 0x30, 0x5A, 0x0C, 0x77, 0x20,
  0x8A, 0x09, 0x77, 0x20, 0xDA, 0x05, 0x77, 0x10, 0x2B, 0x01, 0x77, 0x10, 0x9A, 0x0B, 0x60, 0x17,
  0x10, 0x4B, 0x04, 0x68, 0x24, 0xD6, 0x14, 0x07, 0xB0, 0xB7, 0x04, 0xB8, 0x1D, 0xCC, 0xC0, 0xD0,
  0x17, 0x03, 0xFA, 0x0B, 0x01, 0x72, 0x87, 0x17, 0xBE, 0xFE, 0xD9, 0x47, 0x30,
  // "Ģ" (U+0122)
  0x73, 0x89, 0x02, 0x8B, 0xEF, 0xED, 0xB7, 0x27, 0x30, 0x10, 0xAF, 0xB0, 0xB0, 0x17, 0x05, 0x0E,
  0xC8, 0x1D, 0xCD, 0xC0, 0xD7, 0x06, 0xB8, 0x1E, 0x71, 0x48, 0x24, 0xBF, 0x56, 0x05, 0xB0, 0xD0,
  0x27, 0x10, 0x36, 0x02, 0x0E, 0xA0, 0xD0, 0x17, 0x72, 0x0B, 0xB0, 0x27, 0x72, 0x04, 0xB0, 0x77,
  0x73, 0x0C, 0xA0, 0xD7, 0x73, 0x03, 0xB0, 0x67, 0x73, 0x09, 0xA0, 0xE7, 0x74, 0x0E, 0xA0, 0x97,
  0x73, 0x03, 0xB0, 0x47, 0x73, 0x06, 0xB6, 0x02, 0x80, 0x3C, 0x02, 0x30, 0xAA, 0x0C, 0x60, 0x6F,
  0x40, 0xDA, 0x0A, 0x60, 0xAE, 0x0C, 0x40, 0xEA, 0x07, 0x73, 0x0A, 0xA0, 0x94, 0xB0, 0x67, 0x30,
  0xDA, 0x06, 0x30, 0x1B, 0x05, 0x72, 0x01, 0xB0, 0x33, 0x01, 0xB0, 0x57, 0x20, 0x4B, 0x40, 0x1B,
  0x05, 0x72, 0x07, 0xA0, 0xC5, 0xB0, 0x77, 0x20, 0xAA, 0x08, 0x50, 0xCA, 0x0B, 0x72, 0x0D, 0xA0,
  0x55, 0x09, 0xB0, 0x17, 0x01, 0xB0, 0x25, 0x03, 0xB0, 0xA7, 0x04, 0xA0, 0xE7, 0x0B, 0xB0, 0xB0,
  0x24, 0x01, 0x09, 0xA0, 0xB7, 0x01, 0x0D, 0xC8, 0x2E, 0xCC, 0xEC, 0x08, 0x71, 0x01, 0x0B, 0xFB,
  0x0D, 0x03, 0x73, 0x89, 0x04, 0x9C, 0xEF, 0xED, 0xB7, 0x28, 0x0E, 0x50, 0x82, 0x27, 0x76, 0x77,
  0x40, 0x9A, 0x09, 0x77, 0x30, 0x10, 0xEA, 0x02, 0x77, 0x30, 0x7A, 0x07, 0x77, 0x48, 0x1E, 0xFC,
  0x77, 0x48, 0x27, 0xFE, 0x27, 0x74, 0x81, 0xEF, 0x47, 0x71,
  // "ģ" (U+0123)
  0x77, 0x81, 0x27, 0x57, 0x72, 0x82, 0x1D, 0xF7, 0x77, 0x28, 0x1B, 0xFD, 0x77, 0x20, 0x6A, 0x06,
  0x77, 0x18, 0x21, 0xEF, 0xE7, 0x72, 0x09, 0xA0, 0x87, 0x71, 0x01, 0xB0, 0x18, 0x09, 0x85, 0x08,
  0x42, 0x9D, 0xFD, 0x72, 0x06, 0xA0, 0x37, 0x06, 0xE8, 0x19, 0x0A, 0xA7, 0x06, 0xC0, 0xD0, 0xEA,
  0x82, 0x3E, 0xFC, 0x60, 0x3B, 0x0B, 0x02, 0x28, 0x16, 0xFD, 0xA0, 0x96, 0x0D, 0xA0, 0xC5, 0x0C,
  0xB0, 0x65, 0x06, 0xB0, 0x25, 0x08, 0xB0, 0x35, 0x0D, 0xA0, 0x96, 0x07, 0xB5, 0x04, 0xB0, 0x26,
  0x08, 0xA0, 0xC5, 0x09, 0xA0, 0xC7, 0x0A, 0xA0, 0x85, 0x0D, 0xA0, 0x87, 0x0C, 0xA0, 0x54, 0x02,
  0xB0, 0x47, 0xB0, 0x24, 0x05, 0xB7, 0x04, 0xA0, 0xE5, 0x07, 0xA0, 0xD7, 0x08, 0xA0, 0xB5, 0x09,
  0xA0, 0xA7, 0x0E, 0xA0, 0x75, 0x0B, 0xA0, 0x96, 0x04, 0xB0, 0x45, 0x0B, 0xA0, 0x86, 0x0C, 0xB0,
  0x15, 0x0B, 0xA0, 0xA5, 0x05, 0xB0, 0xD6, 0x09, 0xA0, 0xD4, 0x02, 0x0E, 0xB0, 0xA6, 0x06, 0xB0,
  0x62, 0x82, 0x3D, 0xFD, 0xA0, 0x76, 0x01, 0x0E, 0xB0, 0x0D, 0xA0, 0x80, 0xDA, 0x03, 0x70, 0x6E,
  0x08, 0x01, 0xB7, 0x28, 0x65, 0xCF, 0xEA, 0x30, 0x5A, 0x0C, 0x77, 0x20, 0x8A, 0x09, 0x77, 0x20,
  0xDA, 0x05, 0x77, 0x10, 0x2B, 0x01, 0x77, 0x10, 0x9A, 0x0B, 0x60, 0x17, 0x10, 0x4B, 0x04, 0x68,
  0x24, 0xD6, 0x14, 0x07, 0xB0, 0xB7, 0x04, 0xB8, 0x1D, 0xCC, 0xC0, 0xD0, 0x17, 0x03, 0xFA, 0x0B,
  0x01, 0x72, 0x87, 0x17, 0xBE, 0xFE, 0xD9, 0x47, 0x30,
  // "Ĥ" (U+0124)
  0x77, 0x82, 0x47, 0x74, 0x77, 0x40, 0x20, 0xEA, 0x0C, 0x77, 0x40, 0xCC, 0x03, 0x77, 0x20, 0xAA,
  0x09, 0xA0, 0x97, 0x71, 0x08, 0xA8, 0x15, 0x0A, 0xA0, 0x17, 0x68, 0x27, 0xFE, 0x42, 0x82, 0x1E,
  0xF7, 0x75, 0x82, 0x4F, 0xD3, 0x48, 0x14, 0xFE, 0x80, 0xE3, 0x00, 0x8A, 0x0B, 0x71, 0x01, 0xB0,
  0x36, 0x0B, 0xA0, 0x87, 0x10, 0x4B, 0x70, 0xEA, 0x04, 0x71, 0x07, 0xA0, 0xC6, 0x02, 0xB0, 0x17,
  0x10, 0xAA, 0x09, 0x60, 0x5A, 0x0D, 0x72, 0x0D, 0xA0, 0x66, 0x09, 0xA0, 0xA7, 0x10, 0x1B, 0x03,
  0x60, 0xCA, 0x07, 0x71, 0x04, 0xB7, 0xB0, 0x47, 0x10, 0x8A, 0x0C, 0x60, 0x3B, 0x01, 0x71, 0x0B,
  0xA0, 0x86, 0x06, 0xA0, 0xD7, 0x20, 0xEA, 0x05, 0x60, 0x9A, 0x09, 0x71, 0x02, 0xB0, 0x26, 0x0D,
  0xA0, 0x67, 0x10, 0x5A, 0x0E, 0x7B, 0x0D, 0x80, 0x4C, 0x0D, 0xA0, 0xB6, 0x03, 0xFF, 0x90, 0x86,
  0x07, 0xFF, 0x90, 0x46, 0x0A, 0xA0, 0x87, 0x10, 0x4B, 0x01, 0x60, 0xDA, 0x05, 0x71, 0x07, 0xA0,
  0xD6, 0x01, 0xB0, 0x27, 0x10, 0xAA, 0x0A, 0x60, 0x4A, 0x0E, 0x72, 0x0E, 0xA0, 0x76, 0x07, 0xA0,
  0xB7, 0x10, 0x1B, 0x04, 0x60, 0xBA, 0x08, 0x71, 0x04, 0xB0, 0x16, 0x0E, 0xA0, 0x47, 0x10, 0x7A,
  0x0D, 0x60, 0x2B, 0x01, 0x71, 0x0A, 0xA0, 0x96, 0x05, 0xA0, 0xE7, 0x20, 0xEA, 0x06, 0x60, 0x8A,
  0x0B, 0x71, 0x01, 0xB0, 0x36, 0x0B, 0xA0, 0x77, 0x10, 0x4B, 0x70, 0xEA, 0x04, 0x71, 0x07, 0xA0,
  0xC6, 0x02, 0xB0, 0x17, 0x10, 0xAA, 0x09, 0x60, 0x5A, 0x0D, 0x72, 0x0D, 0xA0, 0x56,
  // "ĥ" (U+0125)
  0x71, 0x82, 0x47, 0x74, 0x75, 0x02, 0x0E, 0xA0, 0xC7, 0x50, 0xCC, 0x03, 0x73, 0x0A, 0xA0, 0x9A,
  0x09, 0x72, 0x08, 0xA8, 0x15, 0x0A, 0xA0, 0x17, 0x82, 0x7F, 0xE4, 0x28, 0x21, 0xEF, 0x76, 0x82,
  0x4F, 0xD3, 0x48, 0x14, 0xFE, 0x80, 0xF0, 0x00, 0x5A, 0x0D, 0x76, 0x08, 0xA0, 0xA7, 0x60, 0xCA,
  0x06, 0x76, 0xB0, 0x37, 0x50, 0x3A, 0x0E, 0x76, 0x06, 0xA0, 0xB7, 0x60, 0x9A, 0x08, 0x76, 0x0D,
  0xA0, 0x47, 0x50, 0x1B, 0x86, 0x10, 0x7D, 0xFE, 0xA2, 0x50, 0x4A, 0x81, 0xC1, 0xCD, 0x0E, 0x02,
  0x40, 0x7A, 0x84, 0x8D, 0xFE, 0xCE, 0xB0, 0xA4, 0x0B, 0xA8, 0x1D, 0xF8, 0x30, 0xBA, 0x0E, 0x40,
  0xEB, 0x07, 0x40, 0x5B, 0x30, 0x2B, 0x0B, 0x50, 0x5A, 0x0E, 0x30, 0x5B, 0x03, 0x50, 0x6A, 0x0C,
  0x30, 0x8A, 0x0C, 0x60, 0x9A, 0x09, 0x30, 0xCA, 0x07, 0x60, 0xCA, 0x06, 0x3B, 0x03, 0x6B, 0x03,
  0x20, 0x3A, 0x0E, 0x60, 0x3B, 0x30, 0x6A, 0x0B, 0x60, 0x6A, 0x0C, 0x30, 0xAA, 0x08, 0x60, 0x9A,
  0x09, 0x30, 0xDA, 0x05, 0x60, 0xDA, 0x06, 0x20, 0x1B, 0x02, 0x6B, 0x02, 0x20, 0x4A, 0x0E, 0x60,
  0x4A, 0x0E, 0x30, 0x7A, 0x0B, 0x60, 0x7A, 0x0B, 0x30, 0xBA, 0x07, 0x60, 0xAA, 0x08, 0x30, 0xEA,
  0x04, 0x60, 0xDA, 0x05, 0x20, 0x2B, 0x01, 0x50, 0x1B, 0x01, 0x20, 0x5A, 0x0D, 0x60, 0x4A, 0x0E,
  0x30, 0x9A, 0x0A, 0x60, 0x7A, 0x0A, 0x30,
  // "Ħ" (U+0126)
  0x60, 0x9A, 0x0B, 0x71, 0x01, 0xB0, 0x37, 0x0C, 0xA0, 0x87, 0x10, 0x4B, 0x71, 0xB0, 0x47, 0x10,
  0x8A, 0x0C, 0x70, 0x3B, 0x01, 0x71, 0x0B, 0xA0, 0x97, 0x06, 0xA0, 0xD7, 0x20, 0xEA, 0x06, 0x40,
  0x7F, 0xFF, 0x20, 0xBF, 0xFE, 0x0D, 0x28, 0x18, 0x99, 0xB0, 0xA8, 0x04, 0x90, 0xDA, 0x82, 0xD9,
  0x96, 0x40, 0x3B, 0x01, 0x71, 0x0B, 0xA0, 0x97, 0x06, 0xA0, 0xD7, 0x20, 0xEA, 0x05, 0x70, 0xAA,
  0x0A, 0x71, 0x01, 0xB0, 0x27, 0x0D, 0xA0, 0x77, 0x10, 0x4A, 0x0E, 0x70, 0x1B, 0x05, 0x71, 0x07,
  0xA0, 0xB7, 0x04, 0xFF, 0x90, 0x87, 0x07, 0xFF, 0x90, 0x57, 0x0A, 0xA0, 0xE8, 0x05, 0xCB, 0x01,
  0x70, 0xEA, 0x07, 0x71, 0x05, 0xA0, 0xD7, 0x01, 0xB0, 0x47, 0x10, 0x8A, 0x0A, 0x70, 0x5B, 0x72,
  0x0C, 0xA0, 0x77, 0x08, 0xA0, 0xD7, 0x2B, 0x04, 0x70, 0xBA, 0x09, 0x71, 0x03, 0xB0, 0x17, 0x0E,
  0xA0, 0x67, 0x10, 0x6A, 0x0D, 0x70, 0x2B, 0x03, 0x71, 0x0A, 0xA0, 0x97, 0x05, 0xA0, 0xE7, 0x20,
  0xDA, 0x06, 0x70, 0x9A, 0x0B, 0x71, 0x01, 0xB0, 0x37, 0x0C, 0xA0, 0x87, 0x10, 0x4B, 0x71, 0xB0,
  0x57, 0x10, 0x7A, 0x0C, 0x70, 0x3B, 0x01, 0x71, 0x0B, 0xA0, 0x97, 0x06, 0xA0, 0xE7, 0x20, 0xEA,
  0x05, 0x70,
  // "ħ" (U+0127)
  0x60, 0x5A, 0x0D, 0x76, 0x09, 0xA0, 0x97, 0x60, 0xDA, 0x05, 0x73, 0x09, 0xFA, 0x0B, 0x60, 0xDF,
  0xA0, 0x86, 0x81, 0x77, 0xBA, 0x84, 0xC7, 0x77, 0x72, 0x71, 0x0A, 0xA0, 0x77, 0x60, 0xEA, 0x03,
  0x75, 0x01, 0xA0, 0xE2, 0x84, 0x8D, 0xFE, 0xA2, 0x50, 0x5A, 0x81, 0xB2, 0xDD, 0x0E, 0x01, 0x40,
  0x8A, 0x84, 0x8D, 0xFE, 0xCE, 0xB0, 0x84, 0x0B, 0xA8, 0x1D, 0xF7, 0x30, 0xCA, 0x0C, 0x40, 0xEB,
  0x06, 0x40, 0x6A, 0x0D, 0x30, 0x2B, 0x0B, 0x50, 0x6A, 0x0C, 0x30, 0x6B, 0x03, 0x50, 0x7A, 0x0B,
  0x30, 0x9A, 0x0C, 0x60, 0x9A, 0x08, 0x30, 0xCA, 0x06, 0x60, 0xCA, 0x05, 0x3B, 0x02, 0x6B, 0x02,
  0x20, 0x3A, 0x0E, 0x60, 0x3A, 0x0E, 0x30, 0x7A, 0x0B, 0x60, 0x6A, 0x0B, 0x30, 0xAA, 0x08, 0x60,
  0xAA, 0x08, 0x30, 0xDA, 0x04, 0x60, 0xDA, 0x05, 0x20, 0x1B, 0x01, 0x6B, 0x02, 0x20, 0x4A, 0x0D,
  0x60, 0x4A, 0x0E, 0x30, 0x8A, 0x0A, 0x60, 0x7A, 0x0B, 0x30, 0xBA, 0x07, 0x60, 0xAA, 0x08, 0x30,
  0xEA, 0x04, 0x60, 0xDA, 0x04, 0x20, 0x2B, 0x01, 0x50, 0x1B, 0x01, 0x20, 0x5A, 0x0D, 0x60, 0x4A,
  0x0E, 0x30, 0x9A, 0x0A, 0x60, 0x7A, 0x0A, 0x30,
  // "Ĩ" (U+0128)
  0x78, 0x33, 0xCF, 0xD6, 0x48, 0x1E, 0xF1, 0x60, 0x2D, 0x84, 0xA1, 0x07, 0xFC, 0x70, 0xBA, 0x0C,
  0xB0, 0xE0, 0xDA, 0x06, 0x60, 0x1A, 0x82, 0x30, 0x2C, 0xC0, 0xC7, 0x81, 0x6F, 0xA4, 0x83, 0x7D,
  0xEA, 0x18, 0x0D, 0x20, 0x0B, 0xF9, 0x0B, 0x72, 0x0D, 0xF9, 0x07, 0x72, 0x81, 0x37, 0xAB, 0x81,
  0x94, 0x17, 0x50, 0x3B, 0x77, 0x10, 0x6A, 0x0C, 0x77, 0x10, 0xAA, 0x09, 0x77, 0x10, 0xDA, 0x06,
  0x77, 0x01, 0xB0, 0x37, 0x70, 0x4B, 0x77, 0x10, 0x7A, 0x0C, 0x77, 0x10, 0xAA, 0x09, 0x77, 0x10,
  0xEA, 0x05, 0x77, 0x01, 0xB0, 0x27, 0x70, 0x5A, 0x0E, 0x77, 0x10, 0x8A, 0x0B, 0x77, 0x10, 0xBA,
  0x08, 0x77, 0x10, 0xEA, 0x05, 0x77, 0x02, 0xB0, 0x27, 0x70, 0x5A, 0x0E, 0x77, 0x10, 0x9A, 0x0B,
  0x77, 0x10, 0xCA, 0x08, 0x77, 0x1B, 0x04, 0x77, 0x03, 0xB0, 0x17, 0x70, 0x6A, 0x0D, 0x77, 0x10,
  0x9A, 0x0A, 0x77, 0x10, 0xDA, 0x07, 0x76, 0x03, 0x06, 0xB0, 0x90, 0x37, 0x30, 0x5F, 0xA0, 0x17,
  0x10, 0x9F, 0x90, 0xD7, 0x20,
  // "ĩ" (U+0129)
  0x38, 0x33, 0xCF, 0xD6, 0x48, 0x1E, 0xF1, 0x20, 0x2D, 0x84, 0xA1, 0x07, 0xFC, 0x30, 0xBA, 0x0C,
  0xB0, 0xE0, 0xDA, 0x06, 0x20, 0x1A, 0x82, 0x30, 0x2C, 0xC0, 0xC3, 0x81, 0x6F, 0xA4, 0x83, 0x7D,
  0xEA, 0x18, 0x0C, 0x00, 0x03, 0xA0, 0xE7, 0x40, 0x6A, 0x0B, 0x74, 0x0A, 0xA0, 0x87, 0x40, 0xDA,
  0x05, 0x73, 0x01, 0xB0, 0x27, 0x30, 0x4A, 0x0E, 0x74, 0x07, 0xA0, 0xB7, 0x40, 0xAA, 0x08, 0x74,
  0x0D, 0xA0, 0x47, 0x30, 0x1B, 0x01, 0x73, 0x04, 0xA0, 0xD7, 0x40, 0x7A, 0x0A, 0x74, 0x0B, 0xA0,
  0x77, 0x40, 0xEA, 0x04, 0x73, 0x02, 0xB0, 0x17, 0x30, 0x5A, 0x0D, 0x74, 0x08, 0xA0, 0xA7, 0x40,
  0xBA, 0x06, 0x74, 0x0E, 0xA0, 0x37, 0x30, 0x2B, 0x74, 0x05, 0xA0, 0xC7, 0x40, 0x9A, 0x09, 0x74,
  // "Ī" (U+012A)
  0x78, 0x05, 0xC0, 0xA6, 0x03, 0xFA, 0x0B, 0x60, 0x6F, 0xA0, 0x88, 0x0E, 0x50, 0x0B, 0xF9, 0x0B,
  0x70, 0xDF, 0x90, 0x77, 0x81, 0x37, 0xAB, 0x81, 0x94, 0x17, 0x30, 0x3B, 0x76, 0x06, 0xA0, 0xC7,
  0x60, 0xAA, 0x09, 0x76, 0x0D, 0xA0, 0x67, 0x50, 0x1B, 0x03, 0x75, 0x04, 0xB7, 0x60, 0x7A, 0x0C,
  0x76, 0x0A, 0xA0, 0x97, 0x60, 0xEA, 0x05, 0x75, 0x01, 0xB0, 0x27, 0x50, 0x5A, 0x0E, 0x76, 0x08,
  0xA0, 0xB7, 0x60, 0xBA, 0x08, 0x76, 0x0E, 0xA0, 0x57, 0x50, 0x2B, 0x02, 0x75, 0x05, 0xA0, 0xE7,
  0x60, 0x9A, 0x0B, 0x76, 0x0C, 0xA0, 0x87, 0x6B, 0x04, 0x75, 0x03, 0xB0, 0x17, 0x50, 0x6A, 0x0D,
  0x76, 0x09, 0xA0, 0xA7, 0x60, 0xDA, 0x07, 0x74, 0x03, 0x06, 0xB0, 0x90, 0x37, 0x10, 0x5F, 0xA0,
  0x16, 0x09, 0xF9, 0x0D, 0x70,
  // "ī" (U+012B)
  0x28, 0x05, 0xC8, 0x1A, 0x03, 0xFA, 0x81, 0xB0, 0x6F, 0xA0, 0x88, 0x0C, 0x40, 0x03, 0xA0, 0xE7,
  0x10, 0x6A, 0x0B, 0x71, 0x0A, 0xA0, 0x87, 0x10, 0xDA, 0x05, 0x70, 0x1B, 0x02, 0x70, 0x4A, 0x0E,
  0x71, 0x07, 0xA0, 0xB7, 0x10, 0xAA, 0x08, 0x71, 0x0D, 0xA0, 0x47, 0x01, 0xB0, 0x17, 0x04, 0xA0,
  0xD7, 0x10, 0x7A, 0x0A, 0x71, 0x0B, 0xA0, 0x77, 0x10, 0xEA, 0x04, 0x70, 0x2B, 0x01, 0x70, 0x5A,
  0x0D, 0x71, 0x08, 0xA0, 0xA7, 0x10, 0xBA, 0x06, 0x71, 0x0E, 0xA0, 0x37, 0x02, 0xB7, 0x10, 0x5A,
  0x0C, 0x71, 0x09, 0xA0, 0x97, 0x10,
  // "Ĭ" (U+012C)
  0x78, 0x13, 0x75, 0x58, 0x16, 0x72, 0x78, 0x17, 0xFB, 0x40, 0x1A, 0x01, 0x70, 0x6A, 0x02, 0x38,
  0x1B, 0xFB, 0x71, 0x03, 0xA8, 0x2E, 0xAA, 0xEA, 0x04, 0x72, 0x0A, 0xE0, 0x87, 0x48, 0x47, 0xDF,
  0xEB, 0x48, 0x0D, 0x10, 0x0B, 0xF9, 0x0B, 0x71, 0x0D, 0xF9, 0x07, 0x71, 0x81, 0x37, 0xAB, 0x81,
  0x94, 0x17, 0x40, 0x3B, 0x77, 0x06, 0xA0, 0xC7, 0x70, 0xAA, 0x09, 0x77, 0x0D, 0xA0, 0x67, 0x60,
  0x1B, 0x03, 0x76, 0x04, 0xB7, 0x70, 0x7A, 0x0C, 0x77, 0x0A, 0xA0, 0x97, 0x70, 0xEA, 0x05, 0x76,
  0x01, 0xB0, 0x27, 0x60, 0x5A, 0x0E, 0x77, 0x08, 0xA0, 0xB7, 0x70, 0xBA, 0x08, 0x77, 0x0E, 0xA0,
  0x57, 0x60, 0x2B, 0x02, 0x76, 0x05, 0xA0, 0xE7, 0x70, 0x9A, 0x0B, 0x77, 0x0C, 0xA0, 0x87, 0x7B,
  0x04, 0x76, 0x03, 0xB0, 0x17, 0x60, 0x6A, 0x0D, 0x77, 0x09, 0xA0, 0xA7, 0x70, 0xDA, 0x07, 0x75,
  0x03, 0x06, 0xB0, 0x90, 0x37, 0x20, 0x5F, 0xA0, 0x17, 0x09, 0xF9, 0x0D, 0x71,
  // "ĭ" (U+012D)
  0x28, 0x13, 0x75, 0x58, 0x16, 0x72, 0x28, 0x17, 0xFB, 0x40, 0x1A, 0x01, 0x20, 0x6A, 0x02, 0x38,
  0x1B, 0xFB, 0x30, 0x3A, 0x82, 0xEA, 0xAE, 0xA0, 0x44, 0x0A, 0xE0, 0x86, 0x84, 0x7D, 0xFE, 0xB4,
  0x77, 0x77, 0x50, 0x3A, 0x0E, 0x72, 0x06, 0xA0, 0xB7, 0x20, 0xAA, 0x08, 0x72, 0x0D, 0xA0, 0x57,
  0x10, 0x1B, 0x02, 0x71, 0x04, 0xA0, 0xE7, 0x20, 0x7A, 0x0B, 0x72, 0x0A, 0xA0, 0x87, 0x20, 0xDA,
  0x04, 0x71, 0x01, 0xB0, 0x17, 0x10, 0x4A, 0x0D, 0x72, 0x07, 0xA0, 0xA7, 0x20, 0xBA, 0x07, 0x72,
  0x0E, 0xA0, 0x47, 0x10, 0x2B, 0x01, 0x71, 0x05, 0xA0, 0xD7, 0x20, 0x8A, 0x0A, 0x72, 0x0B, 0xA0,
  0x67, 0x20, 0xEA, 0x03, 0x71, 0x02, 0xB7, 0x20, 0x5A, 0x0C, 0x72, 0x09, 0xA0, 0x97, 0x20,
  // "Į" (U+012E)
  0x60, 0xBF, 0x90, 0xB6, 0x0D, 0xF9, 0x07, 0x68, 0x13, 0x7A, 0xB8, 0x19, 0x41, 0x72, 0x03, 0xB7,
  0x50, 0x6A, 0x0C, 0x75, 0x0A, 0xA0, 0x97, 0x50, 0xDA, 0x06, 0x74, 0x01, 0xB0, 0x37, 0x40, 0x4B,
  0x75, 0x07, 0xA0, 0xC7, 0x50, 0xAA, 0x09, 0x75, 0x0E, 0xA0, 0x57, 0x40, 0x1B, 0x02, 0x74, 0x05,
  0xA0, 0xE7, 0x50, 0x8A, 0x0B, 0x75, 0x0B, 0xA0, 0x87, 0x50, 0xEA, 0x05, 0x74, 0x02, 0xB0, 0x27,
  0x40, 0x5A, 0x0E, 0x75, 0x09, 0xA0, 0xB7, 0x50, 0xCA, 0x08, 0x75, 0xB0, 0x47, 0x40, 0x3B, 0x01,
  0x74, 0x06, 0xA0, 0xD7, 0x50, 0x9A, 0x0A, 0x75, 0x0D, 0xA0, 0x77, 0x30, 0x30, 0x6B, 0x09, 0x03,
  0x70, 0x5F, 0xA0, 0x15, 0x09, 0xF9, 0x0D, 0x73, 0x82, 0x6F, 0xC1, 0x74, 0x81, 0x8F, 0xC7, 0x58,
  0x27, 0xFD, 0x17, 0x40, 0x2A, 0x06, 0x75, 0x09, 0xA0, 0x17, 0x50, 0xBA, 0x02, 0x75, 0x0B, 0xA8,
  0x1E, 0xCA, 0x73, 0x06, 0xC0, 0x97, 0x48, 0x37, 0xDF, 0xD5, 0x72,
  // "į" (U+012F)
  0x72, 0x82, 0x4D, 0xE5, 0x72, 0x0E, 0xA0, 0xA7, 0x10, 0x2B, 0x06, 0x72, 0x81, 0xBE, 0xA8, 0x0F,
  0x00, 0x03, 0xA0, 0xE7, 0x20, 0x6A, 0x0B, 0x72, 0x0A, 0xA0, 0x87, 0x20, 0xDA, 0x05, 0x71, 0x01,
  0xB0, 0x27, 0x10, 0x4A, 0x0E, 0x72, 0x07, 0xA0, 0xB7, 0x20, 0xAA, 0x08, 0x72, 0x0D, 0xA0, 0x47,
  0x10, 0x1B, 0x01, 0x71, 0x04, 0xA0, 0xD7, 0x20, 0x7A, 0x0A, 0x72, 0x0B, 0xA0, 0x77, 0x20, 0xEA,
  0x04, 0x71, 0x02, 0xB0, 0x17, 0x10, 0x5A, 0x0D, 0x72, 0x08, 0xA0, 0xA7, 0x20, 0xBA, 0x06, 0x72,
  0x0E, 0xA0, 0x37, 0x10, 0x2B, 0x72, 0x05, 0xA0, 0xC7, 0x20, 0x9A, 0x09, 0x72, 0x82, 0x6F, 0xC1,
  0x71, 0x81, 0x8F, 0xC7, 0x28, 0x27, 0xFD, 0x17, 0x10, 0x2A, 0x06, 0x72, 0x09, 0xA0, 0x17, 0x20,
  0xBA, 0x02, 0x72, 0x0B, 0xA8, 0x1E, 0xCA, 0x70, 0x6C, 0x09, 0x71, 0x83, 0x7D, 0xFD, 0x57,
  // "İ" (U+0130)
  0x73, 0x82, 0x2C, 0xE8, 0x75, 0x0A, 0xA0, 0xE7, 0x50, 0xDA, 0x0C, 0x75, 0x82, 0x7E, 0xC2, 0x80,
  0xE4, 0x00, 0xBF, 0x90, 0xB6, 0x0D, 0xF9, 0x07, 0x68, 0x13, 0x7A, 0xB8, 0x19, 0x41, 0x72, 0x03,
  0xB7, 0x50, 0x6A, 0x0C, 0x75, 0x0A, 0xA0, 0x97, 0x50, 0xDA, 0x06, 0x74, 0x01, 0xB0, 0x37, 0x40,
  0x4B, 0x75, 0x07, 0xA0, 0xC7, 0x50, 0xAA, 0x09, 0x75, 0x0E, 0xA0, 0x57, 0x40, 0x1B, 0x02, 0x74,
  0x05, 0xA0, 0xE7, 0x50, 0x8A, 0x0B, 0x75, 0x0B, 0xA0, 0x87, 0x50, 0xEA, 0x05, 0x74, 0x02, 0xB0,
  0x27, 0x40, 0x5A, 0x0E, 0x75, 0x09, 0xA0, 0xB7, 0x50, 0xCA, 0x08, 0x75, 0xB0, 0x47, 0x40, 0x3B,
  0x01, 0x74, 0x06, 0xA0, 0xD7, 0x50, 0x9A, 0x0A, 0x75, 0x0D, 0xA0, 0x77, 0x30, 0x30, 0x6B, 0x09,
  0x03, 0x70, 0x5F, 0xA0, 0x15, 0x09, 0xF9, 0x0D, 0x60,
  // "ı" (U+0131)
  0x40, 0x3A, 0x0E, 0x40, 0x6A, 0x0B, 0x40, 0xAA, 0x08, 0x40, 0xDA, 0x05, 0x30, 0x1B, 0x02, 0x30,
  0x4A, 0x0E, 0x40, 0x7A, 0x0B, 0x40, 0xAA, 0x08, 0x40, 0xDA, 0x04, 0x30, 0x1B, 0x01, 0x30, 0x4A,
  0x0D, 0x40, 0x7A, 0x0A, 0x40, 0xBA, 0x07, 0x40, 0xEA, 0x04, 0x30, 0x2B, 0x01, 0x30, 0x5A, 0x0D,
  0x40, 0x8A, 0x0A, 0x40, 0xBA, 0x06, 0x40, 0xEA, 0x03, 0x30, 0x2B, 0x40, 0x5A, 0x0C, 0x40, 0x9A,
  0x09, 0x40,
  // "Ĳ" (U+0132)
  0x60, 0xBF, 0x90, 0xB3, 0x08, 0xA0, 0xB6, 0x0D, 0xF9, 0x07, 0x30, 0xBA, 0x08, 0x68, 0x13, 0x7A,
  0xB8, 0x19, 0x41, 0x40, 0xEA, 0x05, 0x71, 0x03, 0xB6, 0x02, 0xB0, 0x27, 0x10, 0x6A, 0x0C, 0x60,
  0x6A, 0x0E, 0x72, 0x0A, 0xA0, 0x96, 0x09, 0xA0, 0xB7, 0x20, 0xDA, 0x06, 0x60, 0xCA, 0x07, 0x71,
  0x01, 0xB0, 0x36, 0xB0, 0x47, 0x10, 0x4B, 0x60, 0x3B, 0x01, 0x71, 0x07, 0xA0, 0xC6, 0x06, 0xA0,
  0xD7, 0x20, 0xAA, 0x09, 0x60, 0xAA, 0x0A, 0x72, 0x0E, 0xA0, 0x56, 0x0D, 0xA0, 0x67, 0x10, 0x1B,
  0x02, 0x50, 0x1B, 0x03, 0x71, 0x05, 0xA0, 0xE6, 0x04, 0xB7, 0x20, 0x8A, 0x0B, 0x60, 0x7A, 0x0C,
  0x72, 0x0B, 0xA0, 0x86, 0x0B, 0xA0, 0x97, 0x20, 0xEA, 0x05, 0x60, 0xEA, 0x05, 0x71, 0x02, 0xB0,
  0x25, 0x02, 0xB0, 0x27, 0x10, 0x5A, 0x0E, 0x60, 0x5A, 0x0E, 0x72, 0x09, 0xA0, 0xB6, 0x08, 0xA0,
  0xB7, 0x20, 0xCA, 0x08, 0x60, 0xBA, 0x08, 0x72, 0xB0, 0x46, 0x0E, 0xA0, 0x47, 0x10, 0x3B, 0x01,
  0x50, 0x2B, 0x01, 0x71, 0x06, 0xA0, 0xD6, 0x06, 0xA0, 0xD7, 0x20, 0x9A, 0x0A, 0x60, 0x9A, 0x0A,
  0x72, 0x0D, 0xA0, 0x76, 0x0C, 0xA0, 0x77, 0x03, 0x06, 0xB0, 0x90, 0x35, 0xB0, 0x35, 0x05, 0xFA,
  0x01, 0x20, 0x3B, 0x60, 0x9F, 0x90, 0xD3, 0x07, 0xA0, 0xC7, 0x75, 0x0B, 0xA0, 0x97, 0x74, 0x01,
  0xB0, 0x47, 0x74, 0x08, 0xA0, 0xE7, 0x70, 0x13, 0x06, 0xB0, 0x77, 0x78, 0x29, 0xEC, 0xDB, 0x0C,
  0x77, 0x10, 0xCD, 0x0C, 0x01, 0x77, 0x18, 0x4A, 0xEF, 0xEC, 0x67, 0x30,
  // "ĳ" (U+0133)
  0x68, 0x24, 0xDE, 0x54, 0x82, 0x4D, 0xE5, 0x60, 0xEA, 0x0A, 0x40, 0xEA, 0x0A, 0x50, 0x2B, 0x06,
  0x30, 0x2B, 0x06, 0x68, 0x1B, 0xEA, 0x58, 0x1B, 0xEA, 0x80, 0x99, 0x10, 0x03, 0xA0, 0xE4, 0x03,
  0xA0, 0xE6, 0x06, 0xA0, 0xB4, 0x06, 0xA0, 0xB6, 0x0A, 0xA0, 0x84, 0x0A, 0xA0, 0x86, 0x0D, 0xA0,
  0x54, 0x0D, 0xA0, 0x55, 0x01, 0xB0, 0x23, 0x01, 0xB0, 0x15, 0x04, 0xA0, 0xE4, 0x04, 0xA0, 0xE6,
  0x07, 0xA0, 0xB4, 0x07, 0xA0, 0xA6, 0x0A, 0xA0, 0x84, 0x0B, 0xA0, 0x76, 0x0D, 0xA0, 0x44, 0x0E,
  0xA0, 0x45, 0x01, 0xB0, 0x13, 0x02, 0xB0, 0x15, 0x04, 0xA0, 0xD4, 0x05, 0xA0, 0xD6, 0x07, 0xA0,
  0xA4, 0x08, 0xA0, 0x96, 0x0B, 0xA0, 0x74, 0x0B, 0xA0, 0x66, 0x0E, 0xA0, 0x44, 0x0E, 0xA0, 0x35,
  0x02, 0xB0, 0x13, 0x02, 0xB6, 0x05, 0xA0, 0xD4, 0x06, 0xA0, 0xC6, 0x08, 0xA0, 0xA4, 0x09, 0xA0,
  0x96, 0x0B, 0xA0, 0x64, 0x0C, 0xA0, 0x56, 0x0E, 0xA0, 0x34, 0xB0, 0x25, 0x02, 0xB4, 0x03, 0xA0,
  0xE6, 0x05, 0xA0, 0xC4, 0x07, 0xA0, 0xB6, 0x09, 0xA0, 0x94, 0x0A, 0xA0, 0x87, 0x70, 0xDA, 0x04,
  0x76, 0x01, 0xB0, 0x17, 0x60, 0x4A, 0x0D, 0x77, 0x08, 0xA0, 0x97, 0x70, 0xEA, 0x04, 0x76, 0x08,
  0xA0, 0xE7, 0x38, 0x21, 0xEC, 0xEB, 0x06, 0x73, 0x01, 0xD0, 0xA7, 0x48, 0x41, 0xDF, 0xEC, 0x67,
  0x30,
  // "Ĵ" (U+0134)
  0x77, 0x82, 0x47, 0x74, 0x77, 0x10, 0x20, 0xEA, 0x0C, 0x77, 0x10, 0xCC, 0x03, 0x76, 0x0A, 0xA0,
  0x9A, 0x09, 0x75, 0x08, 0xA8, 0x15, 0x0A, 0xA0, 0x17, 0x38, 0x27, 0xFE, 0x42, 0x82, 0x1E, 0xF7,
  0x72, 0x82, 0x4F, 0xD3, 0x48, 0x14, 0xFE, 0x80, 0xE0, 0x00, 0x8A, 0x0B, 0x77, 0x20, 0xBA, 0x08,
  0x77, 0x20, 0xEA, 0x05, 0x77, 0x10, 0x2B, 0x02, 0x77, 0x10, 0x6A, 0x0E, 0x77, 0x20, 0x9A, 0x0B,
  0x77, 0x20, 0xCA, 0x07, 0x77, 0x2B, 0x04, 0x77, 0x10, 0x3B, 0x01, 0x77, 0x10, 0x6A, 0x0D, 0x77,
  0x20, 0xAA, 0x0A, 0x77, 0x20, 0xDA, 0x06, 0x77, 0x10, 0x1B, 0x03, 0x77, 0x10, 0x4B, 0x77, 0x20,
  0x7A, 0x0C, 0x77, 0x20, 0xBA, 0x09, 0x77, 0x20, 0xEA, 0x05, 0x77, 0x10, 0x2B, 0x02, 0x77, 0x10,
  0x5A, 0x0E, 0x77, 0x20, 0x8A, 0x0B, 0x77, 0x20, 0xBA, 0x08, 0x77, 0x20, 0xEA, 0x04, 0x77, 0x10,
  0x2B, 0x01, 0x77, 0x10, 0x6A, 0x0D, 0x77, 0x20, 0x9A, 0x0A, 0x77, 0x20, 0xCA, 0x07, 0x77, 0x2B,
  0x03, 0x77, 0x10, 0x3B, 0x77, 0x20, 0x7A, 0x0C, 0x77, 0x20, 0xBA, 0x09, 0x77, 0x10, 0x1B, 0x04,
  0x77, 0x10, 0x8A, 0x0E, 0x74, 0x01, 0x30, 0x6B, 0x07, 0x74, 0x82, 0x9E, 0xCD, 0xB0, 0xC7, 0x50,
  0xCD, 0x0C, 0x01, 0x75, 0x84, 0xAE, 0xFE, 0xC6, 0x77,
  // "ĵ" (U+0135)
  0x75, 0x82, 0x47, 0x74, 0x76, 0x02, 0x0E, 0xA0, 0xC7, 0x60, 0xCC, 0x03, 0x74, 0x0A, 0xA0, 0x9A,
  0x09, 0x73, 0x08, 0xA8, 0x15, 0x0A, 0xA0, 0x17, 0x18, 0x27, 0xFE, 0x42, 0x82, 0x1E, 0xF7, 0x78,
  0x24, 0xFD, 0x34, 0x81, 0x4F, 0xE8, 0x0D, 0x20, 0x03, 0xA0, 0xE7, 0x70, 0x6A, 0x0B, 0x77, 0x0A,
  0xA0, 0x87, 0x70, 0xDA, 0x05, 0x76, 0x01, 0xB0, 0x17, 0x60, 0x4A, 0x0E, 0x77, 0x07, 0xA0, 0xA7,
  0x70, 0xBA, 0x07, 0x77, 0x0E, 0xA0, 0x47, 0x60, 0x2B, 0x01, 0x76, 0x05, 0xA0, 0xD7, 0x70, 0x8A,
  0x09, 0x77, 0x0B, 0xA0, 0x67, 0x70, 0xEA, 0x03, 0x76, 0x02, 0xB7, 0x70, 0x6A, 0x0C, 0x77, 0x09,
  0xA0, 0x97, 0x70, 0xCA, 0x05, 0x77, 0xB0, 0x27, 0x60, 0x3A, 0x0E, 0x77, 0x07, 0xA0, 0xB7, 0x70,
  0xAA, 0x08, 0x77, 0x0D, 0xA0, 0x47, 0x60, 0x1B, 0x01, 0x76, 0x04, 0xA0, 0xD7, 0x70, 0x8A, 0x09,
  0x77, 0x0E, 0xA0, 0x47, 0x60, 0x8A, 0x0E, 0x73, 0x82, 0x1E, 0xCE, 0xB0, 0x67, 0x30, 0x1D, 0x0A,
  0x74, 0x84, 0x1D, 0xFE, 0xC6, 0x75,
  // "Ķ" (U+0136)
  0x60, 0x9A, 0x0B, 0x70, 0xAA, 0x0E, 0x01, 0x60, 0xCA, 0x08, 0x60, 0x7B, 0x04, 0x7B, 0x05, 0x50,
  0x3B, 0x08, 0x70, 0x3B, 0x01, 0x40, 0x10, 0xDA, 0x0B, 0x71, 0x06, 0xA0, 0xE5, 0x0B, 0xA0, 0xE0,
  0x17, 0x10, 0x9A, 0x0A, 0x40, 0x8B, 0x04, 0x72, 0x0D, 0xA0, 0x73, 0x04, 0xB0, 0x87, 0x3B, 0x04,
  0x20, 0x10, 0xEA, 0x0B, 0x73, 0x03, 0xB0, 0x12, 0x0C, 0xA0, 0xE0, 0x17, 0x30, 0x7A, 0x0D, 0x20,
  0x9B, 0x03, 0x74, 0x0A, 0xA8, 0x1A, 0x05, 0xB0, 0x77, 0x50, 0xDA, 0x81, 0x72, 0xEA, 0x0B, 0x75,
  0x01, 0xB0, 0x40, 0xCA, 0x0D, 0x01, 0x75, 0x04, 0xB0, 0x8B, 0x07, 0x76, 0x07, 0xF0, 0xB7, 0x60,
  0xBC, 0x0E, 0xB7, 0x60, 0xEB, 0x0A, 0x02, 0xB0, 0x47, 0x40, 0x1B, 0x09, 0x20, 0xDA, 0x08, 0x74,
  0x05, 0xB3, 0x09, 0xA0, 0xD7, 0x40, 0x8A, 0x0C, 0x30, 0x5B, 0x01, 0x73, 0x0B, 0xA0, 0x93, 0x01,
  0xB0, 0x67, 0x30, 0xEA, 0x05, 0x40, 0xCA, 0x0A, 0x72, 0x02, 0xB0, 0x24, 0x08, 0xA0, 0xE7, 0x20,
  0x5A, 0x0E, 0x50, 0x4B, 0x03, 0x71, 0x09, 0xA0, 0xB6, 0xB0, 0x77, 0x10, 0xCA, 0x08, 0x60, 0xCA,
  0x0B, 0x71, 0xB0, 0x56, 0x08, 0xB7, 0x03, 0xB0, 0x16, 0x04, 0xB0, 0x46, 0x06, 0xA0, 0xD7, 0x1B,
  0x09, 0x80, 0xE3, 0x08, 0x22, 0x77, 0x67, 0x74, 0x09, 0xA0, 0x97, 0x73, 0x01, 0x0E, 0xA0, 0x27,
  0x73, 0x07, 0xA0, 0x77, 0x74, 0x81, 0xEF, 0xC7, 0x74, 0x82, 0x7F, 0xE2, 0x77, 0x48, 0x1E, 0xF4,
  0x77, 0x20,
  // "ķ" (U+0137)
  0x60, 0x4A, 0x0D, 0x77, 0x08, 0xA0, 0xA7, 0x70, 0xBA, 0x06, 0x77, 0x0E, 0xA0, 0x37, 0x60, 0x2B,
  0x77, 0x06, 0xA0, 0xC7, 0x70, 0x9A, 0x08, 0x77, 0x0C, 0xA0, 0x57, 0x7B, 0x01, 0x40, 0x5B, 0x03,
  0x40, 0x4A, 0x0E, 0x40, 0x20, 0xEA, 0x06, 0x50, 0x7A, 0x0A, 0x30, 0x10, 0xDA, 0x0A, 0x60, 0xAA,
  0x07, 0x30, 0xBA, 0x0C, 0x70, 0xEA, 0x03, 0x20, 0x7A, 0x0E, 0x01, 0x60, 0x1B, 0x20, 0x4B, 0x04,
  0x70, 0x5A, 0x82, 0xC0, 0x2E, 0xA0, 0x77, 0x10, 0x8A, 0x81, 0x80, 0xCA, 0x0A, 0x72, 0x0B, 0xA0,
  0x40, 0xAA, 0x0C, 0x73, 0xA0, 0xE0, 0x7B, 0x07, 0x72, 0x03, 0xA0, 0xEC, 0x0B, 0x72, 0x06, 0xC0,
  0xEA, 0x0E, 0x72, 0x09, 0xB0, 0xB0, 0x2B, 0x03, 0x71, 0x0D, 0xA0, 0xB2, 0x0D, 0xA0, 0x77, 0x01,
  0xB0, 0x12, 0x09, 0xA0, 0xB7, 0x04, 0xA0, 0xD3, 0x05, 0xB7, 0x07, 0xA0, 0xA3, 0x01, 0xB0, 0x46,
  0x0B, 0xA0, 0x74, 0x0D, 0xA0, 0x86, 0x0E, 0xA0, 0x44, 0x09, 0xA0, 0xC5, 0x02, 0xB0, 0x14, 0x05,
  0xB5, 0x05, 0xA0, 0xD5, 0x02, 0xB0, 0x44, 0x09, 0xA0, 0xA6, 0x0D, 0xA0, 0x88, 0x0D, 0x00, 0x82,
  0x27, 0x76, 0x77, 0x09, 0xA0, 0x97, 0x60, 0x10, 0xEA, 0x02, 0x76, 0x07, 0xA0, 0x77, 0x78, 0x1E,
  0xFC, 0x77, 0x82, 0x7F, 0xE2, 0x77, 0x81, 0xEF, 0x47, 0x60,
  // "ĸ" (U+0138)
  0x40, 0x2B, 0x50, 0x5B, 0x03, 0x40, 0x6A, 0x0C, 0x40, 0x20, 0xEA, 0x06, 0x50, 0x9A, 0x09, 0x30,
  0x10, 0xDA, 0x0A, 0x60, 0xCA, 0x05, 0x30, 0xBA, 0x0C, 0x7B, 0x02, 0x20, 0x7A, 0x0E, 0x01, 0x60,
  0x3A, 0x0E, 0x20, 0x4B, 0x04, 0x70, 0x6A, 0x82, 0xB0, 0x2E, 0xA0, 0x77, 0x10, 0xAA, 0x81, 0x70,
  0xCA, 0x0A, 0x72, 0x0D, 0xA0, 0x30, 0xAA, 0x0C, 0x72, 0x01, 0xA0, 0xE0, 0x7B, 0x07, 0x72, 0x04,
  0xA0, 0xEC, 0x0B, 0x72, 0x07, 0xC0, 0xEA, 0x0E, 0x72, 0x0A, 0xB0, 0xB0, 0x2B, 0x03, 0x71, 0x0E,
  0xA0, 0xB2, 0x0D, 0xA0, 0x77, 0x01, 0xB0, 0x12, 0x09, 0xA0, 0xB7, 0x05, 0xA0, 0xD3, 0x05, 0xB7,
  0x08, 0xA0, 0xA3, 0x01, 0xB0, 0x46, 0x0B, 0xA0, 0x74, 0x0D, 0xA0, 0x86, 0x0E, 0xA0, 0x44, 0x09,
  0xA0, 0xC5, 0x02, 0xB0, 0x14, 0x05, 0xB5, 0x05, 0xA0, 0xD5, 0x02, 0xB0, 0x44, 0x09, 0xA0, 0xA6,
  0x0D, 0xA0, 0x84,
  // "Ĺ" (U+0139)
  0x75, 0x83, 0x17, 0x77, 0x57, 0x50, 0xAB, 0x04, 0x74, 0x04, 0xB0, 0x57, 0x40, 0x10, 0xEA, 0x06,
  0x75, 0x0B, 0xA0, 0x67, 0x50, 0x9A, 0x05, 0x75, 0x82, 0x4F, 0xE4, 0x80, 0xD1, 0x00, 0x9A, 0x0B,
  0x76, 0x0C, 0xA0, 0x87, 0x6B, 0x05, 0x75, 0x03, 0xB0, 0x17, 0x50, 0x6A, 0x0E, 0x76, 0x09, 0xA0,
  0xA7, 0x60, 0xDA, 0x07, 0x76, 0xB0, 0x47, 0x50, 0x3B, 0x01, 0x75, 0x07, 0xA0, 0xD7, 0x60, 0xAA,
  0x0A, 0x76, 0x0D, 0xA0, 0x67, 0x50, 0x1B, 0x03, 0x75, 0x04, 0xB7, 0x60, 0x7A, 0x0C, 0x76, 0x0B,
  0xA0, 0x97, 0x60, 0xEA, 0x06, 0x75, 0x01, 0xB0, 0x27, 0x50, 0x5A, 0x0E, 0x76, 0x08, 0xA0, 0xB7,
  0x60, 0xBA, 0x08, 0x76, 0x0E, 0xA0, 0x57, 0x50, 0x2B, 0x02, 0x75, 0x05, 0xA0, 0xE7, 0x60, 0x9A,
  0x0B, 0x76, 0x0C, 0xA0, 0x87, 0x6F, 0xC0, 0x74, 0x03, 0xFC, 0x04, 0x40, 0x6F, 0xC0, 0x14,
  // "ĺ" (U+013A)
  0x73, 0x83, 0x17, 0x77, 0x57, 0x30, 0xAB, 0x04, 0x72, 0x04, 0xB0, 0x57, 0x20, 0x10, 0xEA, 0x06,
  0x73, 0x0B, 0xA0, 0x67, 0x30, 0x9A, 0x05, 0x73, 0x82, 0x4F, 0xE4, 0x80, 0xE4, 0x00, 0x4A, 0x0D,
  0x74, 0x08, 0xA0, 0xA7, 0x40, 0xBA, 0x07, 0x74, 0x0E, 0xA0, 0x37, 0x30, 0x2B, 0x74, 0x06, 0xA0,
  0xC7, 0x40, 0x9A, 0x09, 0x74, 0x0C, 0xA0, 0x57, 0x4B, 0x02, 0x73, 0x04, 0xA0, 0xE7, 0x40, 0x7A,
  0x0B, 0x74, 0x0A, 0xA0, 0x77, 0x40, 0xEA, 0x04, 0x73, 0x01, 0xB0, 0x17, 0x30, 0x5A, 0x0D, 0x74,
  0x08, 0xA0, 0xA7, 0x40, 0xBA, 0x06, 0x74, 0xB0, 0x37, 0x30, 0x3B, 0x74, 0x06, 0xA0, 0xC7, 0x40,
  0x9A, 0x08, 0x74, 0x0D, 0xA0, 0x57, 0x30, 0x1B, 0x02, 0x73, 0x04, 0xA0, 0xE7, 0x40, 0x7A, 0x0A,
  0x74, 0x0B, 0xA0, 0x77, 0x40, 0xEA, 0x04, 0x73, 0x02, 0xB7, 0x40, 0x5A, 0x0D, 0x74, 0x09, 0xA0,
  0x97, 0x40,
  // "Ļ" (U+013B)
  0x60, 0x9A, 0x0B, 0x72, 0x0C, 0xA0, 0x87, 0x2B, 0x05, 0x71, 0x03, 0xB0, 0x17, 0x10, 0x6A, 0x0E,
  0x72, 0x09, 0xA0, 0xA7, 0x20, 0xDA, 0x07, 0x72, 0xB0, 0x47, 0x10, 0x3B, 0x01, 0x71, 0x07, 0xA0,
  0xD7, 0x20, 0xAA, 0x0A, 0x72, 0x0D, 0xA0, 0x67, 0x10, 0x1B, 0x03, 0x71, 0x04, 0xB7, 0x20, 0x7A,
  0x0C, 0x72, 0x0B, 0xA0, 0x97, 0x20, 0xEA, 0x06, 0x71, 0x01, 0xB0, 0x27, 0x10, 0x5A, 0x0E, 0x72,
  0x08, 0xA0, 0xB7, 0x20, 0xBA, 0x08, 0x72, 0x0E, 0xA0, 0x57, 0x10, 0x2B, 0x02, 0x71, 0x05, 0xA0,
  0xE7, 0x20, 0x9A, 0x0B, 0x72, 0x0C, 0xA0, 0x87, 0x2F, 0xC0, 0x70, 0x3F, 0xC0, 0x40, 0x6F, 0xC0,
  0x17, 0x77, 0x72, 0x82, 0x27, 0x76, 0x72, 0x09, 0xA0, 0x97, 0x10, 0x10, 0xEA, 0x02, 0x71, 0x07,
  0xA0, 0x77, 0x28, 0x1E, 0xFC, 0x72, 0x82, 0x7F, 0xE2, 0x72, 0x81, 0xEF, 0x47, 0x10,
  // "ļ" (U+013C)
  0x71, 0x04, 0xA0, 0xD7, 0x10, 0x8A, 0x0A, 0x71, 0x0B, 0xA0, 0x77, 0x10, 0xEA, 0x03, 0x70, 0x2B,
  0x71, 0x06, 0xA0, 0xC7, 0x10, 0x9A, 0x09, 0x71, 0x0C, 0xA0, 0x57, 0x1B, 0x02, 0x70, 0x4A, 0x0E,
  0x71, 0x07, 0xA0, 0xB7, 0x10, 0xAA, 0x07, 0x71, 0x0E, 0xA0, 0x47, 0x01, 0xB0, 0x17, 0x05, 0xA0,
  0xD7, 0x10, 0x8A, 0x0A, 0x71, 0x0B, 0xA0, 0x67, 0x1B, 0x03, 0x70, 0x3B, 0x71, 0x06, 0xA0, 0xC7,
  0x10, 0x9A, 0x08, 0x71, 0x0D, 0xA0, 0x57, 0x01, 0xB0, 0x27, 0x04, 0xA0, 0xE7, 0x10, 0x7A, 0x0A,
  0x71, 0x0B, 0xA0, 0x77, 0x10, 0xEA, 0x04, 0x70, 0x2B, 0x71, 0x05, 0xA0, 0xD7, 0x10, 0x9A, 0x09,
  0x77, 0x77, 0x48, 0x22, 0x77, 0x67, 0x10, 0x9A, 0x09, 0x70, 0x10, 0xEA, 0x02, 0x70, 0x7A, 0x07,
  0x71, 0x81, 0xEF, 0xC7, 0x18, 0x27, 0xFE, 0x27, 0x18, 0x1E, 0xF4, 0x72,
  // "Ľ" (U+013D)
  0x60, 0x9A, 0x0B, 0x4B, 0x03, 0x60, 0xCA, 0x08, 0x30, 0x5A, 0x0C, 0x7B, 0x05, 0x30, 0xBA, 0x04,
  0x60, 0x3B, 0x01, 0x20, 0x2A, 0x0A, 0x70, 0x6A, 0x0E, 0x38, 0x28, 0xFE, 0x17, 0x09, 0xA0, 0xA3,
  0x81, 0xEF, 0x57, 0x10, 0xDA, 0x07, 0x28, 0x12, 0x86, 0x72, 0xB0, 0x47, 0x60, 0x3B, 0x01, 0x76,
  0x07, 0xA0, 0xD7, 0x70, 0xAA, 0x0A, 0x77, 0x0D, 0xA0, 0x67, 0x60, 0x1B, 0x03, 0x76, 0x04, 0xB7,
  0x70, 0x7A, 0x0C, 0x77, 0x0B, 0xA0, 0x97, 0x70, 0xEA, 0x06, 0x76, 0x01, 0xB0, 0x27, 0x60, 0x5A,
  0x0E, 0x77, 0x08, 0xA0, 0xB7, 0x70, 0xBA, 0x08, 0x77, 0x0E, 0xA0, 0x57, 0x60, 0x2B, 0x02, 0x76,
  0x05, 0xA0, 0xE7, 0x70, 0x9A, 0x0B, 0x77, 0x0C, 0xA0, 0x87, 0x7F, 0xC0, 0x75, 0x03, 0xFC, 0x04,
  0x50, 0x6F, 0xC0, 0x15,
  // "ľ" (U+013E)
  0x60, 0x4A, 0x0D, 0x20, 0x5A, 0x0E, 0x60, 0x8A, 0x0A, 0x20, 0xAA, 0x07, 0x60, 0xBA, 0x81, 0x70,
  0x1A, 0x0D, 0x70, 0xEA, 0x81, 0x30, 0x7A, 0x04, 0x60, 0x2B, 0x28, 0x1D, 0xFA, 0x70, 0x6A, 0x84,
  0xC0, 0x5F, 0xD1, 0x70, 0x9A, 0x83, 0x90, 0x24, 0x27, 0x10, 0xCA, 0x05, 0x75, 0xB0, 0x27, 0x40,
  0x4A, 0x0E, 0x75, 0x07, 0xA0, 0xB7, 0x50, 0xAA, 0x07, 0x75, 0x0E, 0xA0, 0x47, 0x40, 0x1B, 0x01,
  0x74, 0x05, 0xA0, 0xD7, 0x50, 0x8A, 0x0A, 0x75, 0x0B, 0xA0, 0x67, 0x5B, 0x03, 0x74, 0x03, 0xB7,
  0x50, 0x6A, 0x0C, 0x75, 0x09, 0xA0, 0x87, 0x50, 0xDA, 0x05, 0x74, 0x01, 0xB0, 0x27, 0x40, 0x4A,
  0x0E, 0x75, 0x07, 0xA0, 0xA7, 0x50, 0xBA, 0x07, 0x75, 0x0E, 0xA0, 0x47, 0x40, 0x2B, 0x75, 0x05,
  0xA0, 0xD7, 0x50, 0x9A, 0x09, 0x75,
  // "Ŀ" (U+013F)
  0x60, 0x9A, 0x0B, 0x73, 0x0C, 0xA0, 0x87, 0x3B, 0x05, 0x72, 0x03, 0xB0, 0x17, 0x20, 0x6A, 0x0E,
  0x73, 0x09, 0xA0, 0xA7, 0x30, 0xDA, 0x07, 0x73, 0xB0, 0x47, 0x20, 0x3B, 0x01, 0x72, 0x07, 0xA0,
  0xD7, 0x30, 0xAA, 0x0A, 0x73, 0x0D, 0xA0, 0x67, 0x20, 0x1B, 0x03, 0x72, 0x04, 0xB3, 0x82, 0x2C,
  0xE8, 0x30, 0x7A, 0x0C, 0x30, 0xAA, 0x0E, 0x30, 0xBA, 0x09, 0x30, 0xDA, 0x0C, 0x30, 0xEA, 0x06,
  0x38, 0x27, 0xEC, 0x22, 0x01, 0xB0, 0x27, 0x20, 0x5A, 0x0E, 0x73, 0x08, 0xA0, 0xB7, 0x30, 0xBA,
  0x08, 0x73, 0x0E, 0xA0, 0x57, 0x20, 0x2B, 0x02, 0x72, 0x05, 0xA0, 0xE7, 0x30, 0x9A, 0x0B, 0x73,
  0x0C, 0xA0, 0x87, 0x3F, 0xC8, 0x17, 0x03, 0xFC, 0x81, 0x40, 0x6F, 0xC0, 0x11,
  // "ŀ" (U+0140)
  0x60, 0x4A, 0x0D, 0x72, 0x08, 0xA0, 0xA7, 0x20, 0xBA, 0x07, 0x72, 0x0E, 0xA0, 0x37, 0x10, 0x2B,
  0x72, 0x06, 0xA0, 0xC7, 0x20, 0x9A, 0x09, 0x72, 0x0C, 0xA0, 0x57, 0x2B, 0x02, 0x71, 0x04, 0xA0,
  0xE7, 0x20, 0x7A, 0x0B, 0x72, 0x0A, 0xA0, 0x77, 0x20, 0xEA, 0x04, 0x71, 0x01, 0xB0, 0x17, 0x10,
  0x5A, 0x0D, 0x72, 0x08, 0xA0, 0xA2, 0x82, 0x2C, 0xE8, 0x30, 0xBA, 0x06, 0x20, 0xAA, 0x0E, 0x3B,
  0x03, 0x20, 0xDA, 0x0C, 0x20, 0x3B, 0x38, 0x27, 0xEC, 0x22, 0x06, 0xA0, 0xC7, 0x20, 0x9A, 0x08,
  0x72, 0x0D, 0xA0, 0x57, 0x10, 0x1B, 0x02, 0x71, 0x04, 0xA0, 0xE7, 0x20, 0x7A, 0x0A, 0x72, 0x0B,
  0xA0, 0x77, 0x20, 0xEA, 0x04, 0x71, 0x02, 0xB7, 0x20, 0x5A, 0x0D, 0x72, 0x09, 0xA0, 0x97, 0x20,
  // "Ł" (U+0141)
  0x70, 0x6A, 0x0E, 0x73, 0x09, 0xA0, 0xB7, 0x30, 0xCA, 0x08, 0x73, 0xB0, 0x57, 0x20, 0x3B, 0x01,
  0x72, 0x06, 0xA0, 0xE7, 0x30, 0x9A, 0x0A, 0x73, 0x0D, 0xA0, 0x77, 0x3B, 0x04, 0x72, 0x04, 0xB0,
  0x17, 0x20, 0x7A, 0x0D, 0x20, 0x30, 0x66, 0x0A, 0xA8, 0x1A, 0x19, 0xA0, 0x35, 0x0D, 0xA0, 0xC0,
  0xEA, 0x0E, 0x05, 0x40, 0x1E, 0x0A, 0x01, 0x50, 0x4C, 0x0D, 0x04, 0x60, 0x40, 0xDB, 0x08, 0x60,
  0x10, 0xAC, 0x09, 0x60, 0x30, 0xED, 0x05, 0x68, 0x21, 0xEF, 0xBB, 0x02, 0x78, 0x15, 0x44, 0xA0,
  0xE7, 0x30, 0x7A, 0x0B, 0x73, 0x0B, 0xA0, 0x87, 0x30, 0xEA, 0x05, 0x72, 0x02, 0xB0, 0x27, 0x20,
  0x5A, 0x0E, 0x73, 0x08, 0xA0, 0xB7, 0x30, 0xCF, 0xB0, 0xA2, 0xFC, 0x81, 0x70, 0x3F, 0xC0, 0x40,
  // "ł" (U+0142)
  0x60, 0x1B, 0x01, 0x60, 0x5A, 0x0D, 0x70, 0x8A, 0x0A, 0x70, 0xBA, 0x07, 0x70, 0xEA, 0x03, 0x60,
  0x2B, 0x70, 0x6A, 0x0C, 0x70, 0x9A, 0x09, 0x70, 0xCA, 0x06, 0x7B, 0x03, 0x60, 0x4A, 0x0E, 0x70,
  0x7A, 0x82, 0xB0, 0x11, 0x40, 0xAA, 0x82, 0x98, 0xE8, 0x40, 0xED, 0x0D, 0x30, 0x2D, 0x09, 0x01,
  0x20, 0x60, 0xEB, 0x0B, 0x02, 0x20, 0x40, 0xCC, 0x0A, 0x40, 0xDD, 0x07, 0x48, 0x26, 0xD4, 0xEA,
  0x03, 0x60, 0x2B, 0x70, 0x5A, 0x0C, 0x70, 0x9A, 0x09, 0x70, 0xCA, 0x05, 0x7B, 0x02, 0x60, 0x3A,
  0x0E, 0x70, 0x7A, 0x0A, 0x70, 0xAA, 0x07, 0x70, 0xDA, 0x04, 0x60, 0x1B, 0x70, 0x5A, 0x0C, 0x70,
  // "Ń" (U+0143)
  0x77, 0x38, 0x31, 0x77, 0x75, 0x77, 0x50, 0xAB, 0x04, 0x77, 0x40, 0x4B, 0x05, 0x77, 0x40, 0x10,
  0xEA, 0x06, 0x77, 0x50, 0xBA, 0x06, 0x77, 0x50, 0x9A, 0x05, 0x77, 0x58, 0x24, 0xFE, 0x48, 0x0F,
  0x10, 0x09, 0xB0, 0x67, 0x20, 0xBA, 0x07, 0x60, 0xCB, 0x0A, 0x72, 0x0E, 0xA0, 0x36, 0xC0, 0xD7,
  0x10, 0x2B, 0x60, 0x3D, 0x01, 0x70, 0x5A, 0x0C, 0x60, 0x6D, 0x05, 0x70, 0x9A, 0x09, 0x60, 0x9A,
  0x0E, 0xA0, 0x87, 0x0C, 0xA0, 0x66, 0x0D, 0xA0, 0x8A, 0x0B, 0x7B, 0x03, 0x6B, 0x02, 0xB6, 0x03,
  0xB6, 0x03, 0xA8, 0x1D, 0x0D, 0xA0, 0x35, 0x06, 0xA0, 0xC6, 0x07, 0xA8, 0x1A, 0x0A, 0xA0, 0x65,
  0x09, 0xA0, 0x86, 0x0A, 0xA8, 0x17, 0x06, 0xA0, 0xA5, 0x0C, 0xA0, 0x56, 0x0D, 0xA8, 0x14, 0x03,
  0xA0, 0xD5, 0xB0, 0x25, 0x01, 0xB0, 0x12, 0xB0, 0x13, 0x03, 0xA0, 0xE6, 0x04, 0xA0, 0xD3, 0x0B,
  0xA0, 0x53, 0x07, 0xA0, 0xB6, 0x07, 0xA0, 0xA3, 0x08, 0xA0, 0x83, 0x0A, 0xA0, 0x86, 0x0B, 0xA0,
  0x73, 0x04, 0xA0, 0xC3, 0x0D, 0xA0, 0x46, 0x0E, 0xA0, 0x43, 0x01, 0xB2, 0x01, 0xB0, 0x15, 0x01,
  0xB5, 0x0D, 0xA8, 0x13, 0x04, 0xA0, 0xD6, 0x05, 0xA0, 0xD5, 0x09, 0xA8, 0x17, 0x07, 0xA0, 0xA6,
  0x08, 0xA0, 0x95, 0x06, 0xA8, 0x1A, 0x0A, 0xA0, 0x76, 0x0B, 0xA0, 0x65, 0x02, 0xA8, 0x1E, 0x0C,
  0xA0, 0x46, 0x0E, 0xA0, 0x36, 0x0E, 0xA0, 0x2B, 0x60, 0x2B, 0x70, 0xBA, 0x08, 0xA0, 0xD6, 0x05,
  0xA0, 0xC7, 0x07, 0xA0, 0xEA, 0x09, 0x60, 0x9A, 0x09, 0x70, 0x4D, 0x06, 0x60, 0xCA, 0x05, 0x71,
  0xD0, 0x36, 0xB0, 0x27, 0x10, 0xCC, 0x60, 0x3A, 0x0E, 0x72, 0x09, 0xB0, 0xC6, 0x06, 0xA0, 0xB7,
  0x20, 0x5B, 0x09, 0x60,
  // "ń" (U+0144)
  0x76, 0x83, 0x17, 0x77, 0x57, 0x60, 0xAB, 0x04, 0x75, 0x04, 0xB0, 0x57, 0x50, 0x10, 0xEA, 0x06,
  0x76, 0x0B, 0xA0, 0x67, 0x60, 0x9A, 0x05, 0x76, 0x82, 0x4F, 0xE4, 0x80, 0xD1, 0x00, 0x4A, 0x07,
  0x28, 0x48, 0xDF, 0xEA, 0x26, 0x07, 0xA8, 0x15, 0x2D, 0xD0, 0xE0, 0x35, 0x0A, 0xA8, 0x45, 0xDF,
  0xEC, 0xEB, 0x0B, 0x50, 0xDA, 0x81, 0xDF, 0x93, 0x0B, 0xA0, 0xE4, 0x01, 0xC0, 0x84, 0x05, 0xB4,
  0x04, 0xB0, 0xC5, 0x05, 0xA0, 0xE4, 0x07, 0xB0, 0x45, 0x07, 0xA0, 0xD4, 0x0B, 0xA0, 0xD6, 0x0A,
  0xA0, 0xA4, 0x0E, 0xA0, 0x86, 0x0D, 0xA0, 0x73, 0x01, 0xB0, 0x35, 0x01, 0xB0, 0x43, 0x05, 0xB6,
  0x04, 0xB0, 0x13, 0x08, 0xA0, 0xB6, 0x07, 0xA0, 0xD4, 0x0B, 0xA0, 0x86, 0x0A, 0xA0, 0x94, 0x0E,
  0xA0, 0x56, 0x0E, 0xA0, 0x63, 0x02, 0xB0, 0x25, 0x01, 0xB0, 0x33, 0x05, 0xA0, 0xE6, 0x05, 0xB4,
  0x09, 0xA0, 0xB6, 0x08, 0xA0, 0xC4, 0x0C, 0xA0, 0x76, 0x0B, 0xA0, 0x84, 0xB0, 0x46, 0x0E, 0xA0,
  0x53, 0x03, 0xB0, 0x15, 0x02, 0xB0, 0x23, 0x06, 0xA0, 0xD6, 0x05, 0xA0, 0xE4, 0x09, 0xA0, 0xA6,
  0x09, 0xA0, 0xA4,
  // "Ņ" (U+0145)
  0x60, 0x9B, 0x06, 0x72, 0x0B, 0xA0, 0x76, 0x0C, 0xB0, 0xA7, 0x20, 0xEA, 0x03, 0x6C, 0x0D, 0x71,
  0x02, 0xB6, 0x03, 0xD0, 0x17, 0x05, 0xA0, 0xC6, 0x06, 0xD0, 0x57, 0x09, 0xA0, 0x96, 0x09, 0xA0,
  0xEA, 0x08, 0x70, 0xCA, 0x06, 0x60, 0xDA, 0x08, 0xA0, 0xB7, 0xB0, 0x36, 0xB0, 0x2B, 0x60, 0x3B,
  0x60, 0x3A, 0x81, 0xD0, 0xDA, 0x03, 0x50, 0x6A, 0x0C, 0x60, 0x7A, 0x81, 0xA0, 0xAA, 0x06, 0x50,
  0x9A, 0x08, 0x60, 0xAA, 0x81, 0x70, 0x6A, 0x0A, 0x50, 0xCA, 0x05, 0x60, 0xDA, 0x81, 0x40, 0x3A,
  0x0D, 0x5B, 0x02, 0x50, 0x1B, 0x01, 0x2B, 0x01, 0x30, 0x3A, 0x0E, 0x60, 0x4A, 0x0D, 0x30, 0xBA,
  0x05, 0x30, 0x7A, 0x0B, 0x60, 0x7A, 0x0A, 0x30, 0x8A, 0x08, 0x30, 0xAA, 0x08, 0x60, 0xBA, 0x07,
  0x30, 0x4A, 0x0C, 0x30, 0xDA, 0x04, 0x60, 0xEA, 0x04, 0x30, 0x1B, 0x20, 0x1B, 0x01, 0x50, 0x1B,
  0x50, 0xDA, 0x81, 0x30, 0x4A, 0x0D, 0x60, 0x5A, 0x0D, 0x50, 0x9A, 0x81, 0x70, 0x7A, 0x0A, 0x60,
  0x8A, 0x09, 0x50, 0x6A, 0x81, 0xA0, 0xAA, 0x07, 0x60, 0xBA, 0x06, 0x50, 0x2A, 0x81, 0xE0, 0xCA,
  0x04, 0x60, 0xEA, 0x03, 0x60, 0xEA, 0x02, 0xB6, 0x02, 0xB7, 0x0B, 0xA0, 0x8A, 0x0D, 0x60, 0x5A,
  0x0C, 0x70, 0x7A, 0x0E, 0xA0, 0x96, 0x09, 0xA0, 0x97, 0x04, 0xD0, 0x66, 0x0C, 0xA0, 0x57, 0x1D,
  0x03, 0x6B, 0x02, 0x71, 0x0C, 0xC6, 0x03, 0xA0, 0xE7, 0x20, 0x9B, 0x0C, 0x60, 0x6A, 0x0B, 0x72,
  0x05, 0xB0, 0x98, 0x0F, 0x10, 0x82, 0x27, 0x76, 0x77, 0x60, 0x9A, 0x09, 0x77, 0x50, 0x10, 0xEA,
  0x02, 0x77, 0x50, 0x7A, 0x07, 0x77, 0x68, 0x1E, 0xFC, 0x77, 0x68, 0x27, 0xFE, 0x27, 0x76, 0x81,
  0xEF, 0x47, 0x72,
  // "ņ" (U+0146)
  0x40, 0x4A, 0x07, 0x28, 0x48, 0xDF, 0xEA, 0x25, 0x07, 0xA8, 0x15, 0x2D, 0xD0, 0xE0, 0x34, 0x0A,
  0xA8, 0x45, 0xDF, 0xEC, 0xEB, 0x0B, 0x40, 0xDA, 0x81, 0xDF, 0x93, 0x0B, 0xA0, 0xE3, 0x01, 0xC0,
  0x84, 0x05, 0xB3, 0x04, 0xB0, 0xC5, 0x05, 0xA0, 0xE3, 0x07, 0xB0, 0x45, 0x07, 0xA0, 0xD3, 0x0B,
  0xA0, 0xD6, 0x0A, 0xA0, 0xA3, 0x0E, 0xA0, 0x86, 0x0D, 0xA0, 0x72, 0x01, 0xB0, 0x35, 0x01, 0xB0,
  0x42, 0x05, 0xB6, 0x04, 0xB0, 0x12, 0x08, 0xA0, 0xB6, 0x07, 0xA0, 0xD3, 0x0B, 0xA0, 0x86, 0x0A,
  0xA0, 0x93, 0x0E, 0xA0, 0x56, 0x0E, 0xA0, 0x62, 0x02, 0xB0, 0x25, 0x01, 0xB0, 0x32, 0x05, 0xA0,
  0xE6, 0x05, 0xB3, 0x09, 0xA0, 0xB6, 0x08, 0xA0, 0xC3, 0x0C, 0xA0, 0x76, 0x0B, 0xA0, 0x83, 0xB0,
  0x46, 0x0E, 0xA0, 0x52, 0x03, 0xB0, 0x15, 0x02, 0xB0, 0x22, 0x06, 0xA0, 0xD6, 0x05, 0xA0, 0xE3,
  0x09, 0xA0, 0xA6, 0x09, 0xA0, 0xA8, 0x0C, 0x60, 0x82, 0x27, 0x76, 0x76, 0x09, 0xA0, 0x97, 0x50,
  0x10, 0xEA, 0x02, 0x75, 0x07, 0xA0, 0x77, 0x68, 0x1E, 0xFC, 0x76, 0x82, 0x7F, 0xE2, 0x76, 0x81,
  0xEF, 0x47, 0x40,
  // "Ň" (U+0147)
  0x73, 0x81, 0x17, 0x66, 0x81, 0x67, 0x27, 0x68, 0x1E, 0xF7, 0x38, 0x21, 0xBF, 0xB7, 0x70, 0x7A,
  0x84, 0x20, 0x1D, 0xFC, 0x77, 0x10, 0x1A, 0x84, 0xB1, 0xDF, 0xD1, 0x77, 0x20, 0x9A, 0x82, 0xEF,
  0xE3, 0x77, 0x30, 0x3C, 0x05, 0x77, 0x50, 0xDA, 0x09, 0x80, 0xF1, 0x00, 0x9B, 0x06, 0x72, 0x0B,
  0xA0, 0x76, 0x0C, 0xB0, 0xA7, 0x20, 0xEA, 0x03, 0x6C, 0x0D, 0x71, 0x02, 0xB6, 0x03, 0xD0, 0x17,
  0x05, 0xA0, 0xC6, 0x06, 0xD0, 0x57, 0x09, 0xA0, 0x96, 0x09, 0xA0, 0xEA, 0x08, 0x70, 0xCA, 0x06,
  0x60, 0xDA, 0x08, 0xA0, 0xB7, 0xB0, 0x36, 0xB0, 0x2B, 0x60, 0x3B, 0x60, 0x3A, 0x81, 0xD0, 0xDA,
  0x03, 0x50, 0x6A, 0x0C, 0x60, 0x7A, 0x81, 0xA0, 0xAA, 0x06, 0x50, 0x9A, 0x08, 0x60, 0xAA, 0x81,
  0x70, 0x6A, 0x0A, 0x50, 0xCA, 0x05, 0x60, 0xDA, 0x81, 0x40, 0x3A, 0x0D, 0x5B, 0x02, 0x50, 0x1B,
  0x01, 0x2B, 0x01, 0x30, 0x3A, 0x0E, 0x60, 0x4A, 0x0D, 0x30, 0xBA, 0x05, 0x30, 0x7A, 0x0B, 0x60,
  0x7A, 0x0A, 0x30, 0x8A, 0x08, 0x30, 0xAA, 0x08, 0x60, 0xBA, 0x07, 0x30, 0x4A, 0x0C, 0x30, 0xDA,
  0x04, 0x60, 0xEA, 0x04, 0x30, 0x1B, 0x20, 0x1B, 0x01, 0x50, 0x1B, 0x50, 0xDA, 0x81, 0x30, 0x4A,
  0x0D, 0x60, 0x5A, 0x0D, 0x50, 0x9A, 0x81, 0x70, 0x7A, 0x0A, 0x60, 0x8A, 0x09, 0x50, 0x6A, 0x81,
  0xA0, 0xAA, 0x07, 0x60, 0xBA, 0x06, 0x50, 0x2A, 0x81, 0xE0, 0xCA, 0x04, 0x60, 0xEA, 0x03, 0x60,
  0xEA, 0x02, 0xB6, 0x02, 0xB7, 0x0B, 0xA0, 0x8A, 0x0D, 0x60, 0x5A, 0x0C, 0x70, 0x7A, 0x0E, 0xA0,
  0x96, 0x09, 0xA0, 0x97, 0x04, 0xD0, 0x66, 0x0C, 0xA0, 0x57, 0x1D, 0x03, 0x6B, 0x02, 0x71, 0x0C,
  0xC6, 0x03, 0xA0, 0xE7, 0x20, 0x9B, 0x0C, 0x60, 0x6A, 0x0B, 0x72, 0x05, 0xB0, 0x96,
  // "ň" (U+0148)
  0x78, 0x11, 0x76, 0x68, 0x16, 0x72, 0x71, 0x81, 0xEF, 0x73, 0x82, 0x1B, 0xFB, 0x72, 0x07, 0xA8,
  0x42, 0x01, 0xDF, 0xC7, 0x30, 0x1A, 0x84, 0xB1, 0xDF, 0xD1, 0x74, 0x09, 0xA8, 0x2E, 0xFE, 0x37,
  0x50, 0x3C, 0x05, 0x77, 0x0D, 0xA0, 0x98, 0x0D, 0x30, 0x04, 0xA0, 0x72, 0x84, 0x8D, 0xFE, 0xA2,
  0x70, 0x7A, 0x81, 0x52, 0xDD, 0x0E, 0x03, 0x60, 0xAA, 0x84, 0x5D, 0xFE, 0xCE, 0xB0, 0xB6, 0x0D,
  0xA8, 0x1D, 0xF9, 0x30, 0xBA, 0x0E, 0x50, 0x1C, 0x08, 0x40, 0x5B, 0x50, 0x4B, 0x0C, 0x50, 0x5A,
  0x0E, 0x50, 0x7B, 0x04, 0x50, 0x7A, 0x0D, 0x50, 0xBA, 0x0D, 0x60, 0xAA, 0x0A, 0x50, 0xEA, 0x08,
  0x60, 0xDA, 0x07, 0x40, 0x1B, 0x03, 0x50, 0x1B, 0x04, 0x40, 0x5B, 0x60, 0x4B, 0x01, 0x40, 0x8A,
  0x0B, 0x60, 0x7A, 0x0D, 0x50, 0xBA, 0x08, 0x60, 0xAA, 0x09, 0x50, 0xEA, 0x05, 0x60, 0xEA, 0x06,
  0x40, 0x2B, 0x02, 0x50, 0x1B, 0x03, 0x40, 0x5A, 0x0E, 0x60, 0x5B, 0x50, 0x9A, 0x0B, 0x60, 0x8A,
  0x0C, 0x50, 0xCA, 0x07, 0x60, 0xBA, 0x08, 0x5B, 0x04, 0x60, 0xEA, 0x05, 0x40, 0x3B, 0x01, 0x50,
  0x2B, 0x02, 0x40, 0x6A, 0x0D, 0x60, 0x5A, 0x0E, 0x50, 0x9A, 0x0A, 0x60, 0x9A, 0x0A, 0x50,
  // "ŉ" (U+0149)
  0x30, 0x2B, 0x06, 0x76, 0x07, 0xB0, 0x17, 0x60, 0xCA, 0x09, 0x76, 0x02, 0xB0, 0x27, 0x60, 0x8A,
  0x0A, 0x77, 0x0E, 0xA0, 0x37, 0x60, 0x5A, 0x0A, 0x77, 0x0B, 0xA0, 0x10, 0x4A, 0x07, 0x28, 0x68,
  0xDF, 0xEA, 0x20, 0x2A, 0x81, 0x80, 0x7A, 0x81, 0x52, 0xDD, 0x83, 0xE3, 0x9F, 0xE2, 0x0A, 0xA8,
  0x45, 0xDF, 0xEC, 0xEB, 0x0B, 0x50, 0xDA, 0x81, 0xDF, 0x93, 0x0B, 0xA0, 0xE4, 0x01, 0xC0, 0x84,
  0x05, 0xB4, 0x04, 0xB0, 0xC5, 0x05, 0xA0, 0xE4, 0x07, 0xB0, 0x45, 0x07, 0xA0, 0xD4, 0x0B, 0xA0,
  0xD6, 0x0A, 0xA0, 0xA4, 0x0E, 0xA0, 0x86, 0x0D, 0xA0, 0x73, 0x01, 0xB0, 0x35, 0x01, 0xB0, 0x43,
  0x05, 0xB6, 0x04, 0xB0, 0x13, 0x08, 0xA0, 0xB6, 0x07, 0xA0, 0xD4, 0x0B, 0xA0, 0x86, 0x0A, 0xA0,
  0x94, 0x0E, 0xA0, 0x56, 0x0E, 0xA0, 0x63, 0x02, 0xB0, 0x25, 0x01, 0xB0, 0x33, 0x05, 0xA0, 0xE6,
  0x05, 0xB4, 0x09, 0xA0, 0xB6, 0x08, 0xA0, 0xC4, 0x0C, 0xA0, 0x76, 0x0B, 0xA0, 0x84, 0xB0, 0x46,
  0x0E, 0xA0, 0x53, 0x03, 0xB0, 0x15, 0x02, 0xB0, 0x23, 0x06, 0xA0, 0xD6, 0x05, 0xA0, 0xE4, 0x09,
  0xA0, 0xA6, 0x09, 0xA0, 0xA3,
  // "Ŋ" (U+014A)
  0x60, 0x9B, 0x07, 0x72, 0x0C, 0xA0, 0x76, 0x0C, 0xB0, 0xA7, 0x2B, 0x03, 0x6C, 0x0E, 0x71, 0x03,
  0xB6, 0x03, 0xD0, 0x27, 0x06, 0xA0, 0xC6, 0x06, 0xD0, 0x67, 0x09, 0xA0, 0x96, 0x09, 0xA0, 0xCA,
  0x09, 0x70, 0xCA, 0x06, 0x60, 0xDA, 0x06, 0xA0, 0xD7, 0xB0, 0x36, 0xB0, 0x10, 0xEA, 0x01, 0x50,
  0x3B, 0x60, 0x3A, 0x81, 0xD0, 0xBA, 0x04, 0x50, 0x6A, 0x0C, 0x60, 0x7A, 0x81, 0xA0, 0x7A, 0x08,
  0x50, 0xAA, 0x09, 0x60, 0xAA, 0x81, 0x70, 0x4A, 0x0C, 0x50, 0xDA, 0x05, 0x60, 0xDA, 0x04, 0x2B,
  0x5B, 0x02, 0x50, 0x1B, 0x01, 0x20, 0xCA, 0x03, 0x30, 0x4A, 0x0E, 0x60, 0x4A, 0x0D, 0x30, 0x8A,
  0x07, 0x30, 0x7A, 0x0B, 0x60, 0x7A, 0x0A, 0x30, 0x5A, 0x0A, 0x30, 0xAA, 0x08, 0x60, 0xBA, 0x07,
  0x30, 0x1A, 0x0E, 0x30, 0xDA, 0x05, 0x60, 0xEA, 0x03, 0x40, 0xDA, 0x81, 0x20, 0x1B, 0x01, 0x50,
  0x1B, 0x50, 0x9A, 0x81, 0x60, 0x4A, 0x0E, 0x60, 0x5A, 0x0C, 0x50, 0x6A, 0x81, 0x90, 0x7A, 0x0B,
  0x60, 0x8A, 0x09, 0x50, 0x2A, 0x81, 0xD0, 0xAA, 0x07, 0x60, 0xBA, 0x06, 0x60, 0xEA, 0x01, 0x0D,
  0xA0, 0x46, 0x0E, 0xA0, 0x36, 0x0A, 0xA0, 0x5B, 0x01, 0x50, 0x2B, 0x70, 0x7A, 0x0B, 0xA0, 0xD6,
  0x05, 0xA0, 0xC7, 0x03, 0xD0, 0xA6, 0x09, 0xA0, 0x87, 0x10, 0xEC, 0x07, 0x60, 0xCA, 0x05, 0x71,
  0x0B, 0xC0, 0x36, 0xB0, 0x27, 0x10, 0x8C, 0x60, 0x3A, 0x0E, 0x72, 0x04, 0xB0, 0xD6, 0x06, 0xA0,
  0xB7, 0x3B, 0x09, 0x77, 0x60, 0xEA, 0x06, 0x77, 0x50, 0x2B, 0x01, 0x77, 0x50, 0x7A, 0x0C, 0x77,
  0x50, 0x10, 0xDA, 0x06, 0x77, 0x18, 0x34, 0x10, 0x3C, 0xA0, 0xD7, 0x72, 0x0E, 0xE0, 0x47, 0x71,
  0x01, 0xD0, 0xE0, 0x67, 0x72, 0x85, 0x18, 0xBB, 0xA7, 0x17, 0x30,
  // "ŋ" (U+014B)
  0x40, 0x3A, 0x06, 0x28, 0x48, 0xDF, 0xEA, 0x25, 0x06, 0xA8, 0x14, 0x1D, 0xD0, 0xE0, 0x34, 0x0A,
  0xA8, 0x44, 0xDF, 0xEC, 0xEB, 0x0A, 0x40, 0xDA, 0x81, 0xCF, 0x83, 0x0B, 0xA0, 0xE3, 0x01, 0xC0,
  0x74, 0x05, 0xB3, 0x04, 0xB0, 0xC5, 0x05, 0xA0, 0xD3, 0x07, 0xB0, 0x35, 0x07, 0xA0, 0xC3, 0x0A,
  0xA0, 0xC6, 0x09, 0xA0, 0x93, 0x0D, 0xA0, 0x76, 0x0D, 0xA0, 0x62, 0x01, 0xB0, 0x36, 0xB0, 0x32,
  0x04, 0xA0, 0xE6, 0x04, 0xA0, 0xE3, 0x07, 0xA0, 0xB6, 0x07, 0xA0, 0xB3, 0x0B, 0xA0, 0x86, 0x0A,
  0xA0, 0x83, 0x0E, 0xA0, 0x46, 0x0E, 0xA0, 0x52, 0x02, 0xB0, 0x15, 0x01, 0xB0, 0x12, 0x05, 0xA0,
  0xE6, 0x05, 0xA0, 0xD3, 0x08, 0xA0, 0xA6, 0x08, 0xA0, 0xA3, 0x0B, 0xA0, 0x76, 0x0B, 0xA0, 0x73,
  0x0E, 0xA0, 0x46, 0x0E, 0xA0, 0x32, 0x02, 0xB0, 0x15, 0x02, 0xB3, 0x05, 0xA0, 0xD6, 0x06, 0xA0,
  0xC3, 0x09, 0xA0, 0xA6, 0x09, 0xA0, 0x97, 0x60, 0xCA, 0x05, 0x76, 0xB0, 0x27, 0x50, 0x4A, 0x0E,
  0x76, 0x08, 0xA0, 0xA7, 0x60, 0xDA, 0x05, 0x75, 0x09, 0xA0, 0xE7, 0x28, 0x21, 0xEC, 0xEB, 0x07,
  0x72, 0x01, 0xD0, 0xC7, 0x30, 0x10, 0xDA, 0x0C, 0x07, 0x70,
  // "Ō" (U+014C)
  0x73, 0x80, 0x5C, 0x0A, 0x73, 0x03, 0xFA, 0x0B, 0x73, 0x06, 0xFA, 0x08, 0x80, 0x98, 0x50, 0x86,
  0x28, 0xCE, 0xFE, 0xB6, 0x75, 0x07, 0xF9, 0x0D, 0x02, 0x72, 0x0B, 0xC0, 0x0C, 0xC0, 0xE0, 0x17,
  0x0B, 0xB0, 0x80, 0x13, 0x08, 0xB0, 0x96, 0x09, 0xB0, 0x56, 0x0A, 0xB0, 0x14, 0x03, 0xB0, 0x67,
  0x02, 0xB0, 0x54, 0x0D, 0xA0, 0xB7, 0x20, 0xEA, 0x08, 0x30, 0x5B, 0x03, 0x72, 0x0B, 0xA0, 0xA3,
  0x0C, 0xA0, 0xB7, 0x30, 0xAA, 0x0B, 0x20, 0x3B, 0x04, 0x73, 0x0B, 0xA0, 0xB2, 0x09, 0xA0, 0xE7,
  0x40, 0xBA, 0x0A, 0x20, 0xEA, 0x09, 0x74, 0x0D, 0xA8, 0x19, 0x02, 0xB0, 0x57, 0x40, 0xEA, 0x81,
  0x70, 0x6B, 0x01, 0x73, 0x01, 0xB8, 0x15, 0x09, 0xA0, 0xD7, 0x40, 0x4B, 0x81, 0x30, 0xCA, 0x0A,
  0x74, 0x07, 0xB2, 0x0E, 0xA0, 0x87, 0x40, 0xBA, 0x0C, 0x2B, 0x07, 0x74, 0xB8, 0x17, 0x01, 0xB0,
  0x57, 0x30, 0x5B, 0x81, 0x20, 0x2B, 0x05, 0x73, 0x0A, 0xA0, 0xD2, 0x01, 0xB0, 0x57, 0x20, 0x1B,
  0x06, 0x20, 0x1B, 0x06, 0x72, 0x08, 0xA0, 0xE4, 0x0E, 0xA0, 0x87, 0x10, 0x2B, 0x07, 0x40, 0xBA,
  0x0C, 0x71, 0x0C, 0xA0, 0xD5, 0x07, 0xB0, 0x46, 0x0A, 0xB0, 0x45, 0x01, 0x0E, 0xA0, 0xE0, 0x53,
  0x03, 0x0B, 0xB0, 0x67, 0x06, 0xC8, 0x1E, 0xCD, 0xC0, 0x77, 0x20, 0x6F, 0x90, 0xE0, 0x47, 0x48,
  0x62, 0x8C, 0xEF, 0xEB, 0x67, 0x20,
  // "ō" (U+014D)
  0x68, 0x05, 0xC0, 0xA5, 0x03, 0xFA, 0x0B, 0x50, 0x6F, 0xA0, 0x88, 0x0E, 0x20, 0x85, 0x18, 0xCE,
  0xEC, 0x77, 0x10, 0x6F, 0x0C, 0x01, 0x50, 0x7B, 0x81, 0xEC, 0xEB, 0x0B, 0x40, 0x5B, 0x08, 0x30,
  0x7B, 0x03, 0x30, 0xEA, 0x09, 0x50, 0xDA, 0x08, 0x20, 0x8A, 0x0D, 0x60, 0x8A, 0x0B, 0x20, 0xEA,
  0x06, 0x60, 0x6A, 0x81, 0xD0, 0x6A, 0x0E, 0x70, 0x6A, 0x81, 0xD0, 0xAA, 0x09, 0x70, 0x7A, 0x0C,
  0x1B, 0x04, 0x70, 0x9A, 0x0B, 0x03, 0xB0, 0x17, 0x0B, 0xA0, 0x80, 0x6A, 0x0D, 0x71, 0x0E, 0xA0,
  0x60, 0x8A, 0x0B, 0x70, 0x2B, 0x02, 0x0A, 0xA0, 0x97, 0x06, 0xA8, 0x1D, 0x0A, 0xA0, 0x87, 0x0C,
  0xA8, 0x19, 0x0A, 0xA0, 0x86, 0x03, 0xB8, 0x12, 0x09, 0xA0, 0xA6, 0x0B, 0xA0, 0xB2, 0x06, 0xA0,
  0xE5, 0x07, 0xB0, 0x22, 0x02, 0xB0, 0x93, 0x07, 0xB0, 0x74, 0x09, 0xB8, 0x1E, 0xCE, 0xB0, 0x96,
  0x0B, 0xF0, 0x97, 0x18, 0x56, 0xBE, 0xFD, 0xA3, 0x60,
  // "Ŏ" (U+014E)
  0x73, 0x81, 0x37, 0x55, 0x81, 0x67, 0x27, 0x38, 0x17, 0xFB, 0x40, 0x1A, 0x01, 0x73, 0x06, 0xA0,
  0x23, 0x81, 0xBF, 0xB7, 0x40, 0x3A, 0x82, 0xEA, 0xAE, 0xA0, 0x47, 0x50, 0xAE, 0x08, 0x77, 0x84,
  0x7D, 0xFE, 0xB4, 0x80, 0xE2, 0x08, 0x62, 0x8C, 0xEF, 0xEB, 0x67, 0x50, 0x7F, 0x90, 0xD0, 0x27,
  0x20, 0xBC, 0x00, 0xCC, 0x0E, 0x01, 0x70, 0xBB, 0x08, 0x01, 0x30, 0x8B, 0x09, 0x60, 0x9B, 0x05,
  0x60, 0xAB, 0x01, 0x40, 0x3B, 0x06, 0x70, 0x2B, 0x05, 0x40, 0xDA, 0x0B, 0x72, 0x0E, 0xA0, 0x83,
  0x05, 0xB0, 0x37, 0x20, 0xBA, 0x0A, 0x30, 0xCA, 0x0B, 0x73, 0x0A, 0xA0, 0xB2, 0x03, 0xB0, 0x47,
  0x30, 0xBA, 0x0B, 0x20, 0x9A, 0x0E, 0x74, 0x0B, 0xA0, 0xA2, 0x0E, 0xA0, 0x97, 0x40, 0xDA, 0x81,
  0x90, 0x2B, 0x05, 0x74, 0x0E, 0xA8, 0x17, 0x06, 0xB0, 0x17, 0x30, 0x1B, 0x81, 0x50, 0x9A, 0x0D,
  0x74, 0x04, 0xB8, 0x13, 0x0C, 0xA0, 0xA7, 0x40, 0x7B, 0x20, 0xEA, 0x08, 0x74, 0x0B, 0xA0, 0xC2,
  0xB0, 0x77, 0x4B, 0x81, 0x70, 0x1B, 0x05, 0x73, 0x05, 0xB8, 0x12, 0x02, 0xB0, 0x57, 0x30, 0xAA,
  0x0D, 0x20, 0x1B, 0x05, 0x72, 0x01, 0xB0, 0x62, 0x01, 0xB0, 0x67, 0x20, 0x8A, 0x0E, 0x40, 0xEA,
  0x08, 0x71, 0x02, 0xB0, 0x74, 0x0B, 0xA0, 0xC7, 0x10, 0xCA, 0x0D, 0x50, 0x7B, 0x04, 0x60, 0xAB,
  0x04, 0x50, 0x10, 0xEA, 0x0E, 0x05, 0x30, 0x30, 0xBB, 0x06, 0x70, 0x6C, 0x81, 0xEC, 0xDC, 0x07,
  0x72, 0x06, 0xF9, 0x0E, 0x04, 0x74, 0x86, 0x28, 0xCE, 0xFE, 0xB6, 0x72,
  // "ŏ" (U+014F)
  0x68, 0x13, 0x75, 0x58, 0x16, 0x72, 0x68, 0x17, 0xFB, 0x40, 0x1A, 0x01, 0x60, 0x6A, 0x02, 0x38,
  0x1B, 0xFB, 0x70, 0x3A, 0x82, 0xEA, 0xAE, 0xA0, 0x47, 0x10, 0xAE, 0x08, 0x73, 0x84, 0x7D, 0xFE,
  0xB4, 0x80, 0xC7, 0x08, 0x51, 0x8C, 0xEE, 0xC7, 0x72, 0x06, 0xF0, 0xC0, 0x16, 0x07, 0xB8, 0x1E,
  0xCE, 0xB0, 0xB5, 0x05, 0xB0, 0x83, 0x07, 0xB0, 0x34, 0x0E, 0xA0, 0x95, 0x0D, 0xA0, 0x83, 0x08,
  0xA0, 0xD6, 0x08, 0xA0, 0xB3, 0x0E, 0xA0, 0x66, 0x06, 0xA0, 0xD2, 0x06, 0xA0, 0xE7, 0x06, 0xA0,
  0xD2, 0x0A, 0xA0, 0x97, 0x07, 0xA0, 0xC2, 0xB0, 0x47, 0x09, 0xA8, 0x1B, 0x03, 0xB0, 0x17, 0x0B,
  0xA8, 0x18, 0x06, 0xA0, 0xD7, 0x10, 0xEA, 0x81, 0x60, 0x8A, 0x0B, 0x70, 0x2B, 0x81, 0x20, 0xAA,
  0x09, 0x70, 0x6A, 0x0D, 0x20, 0xAA, 0x08, 0x70, 0xCA, 0x09, 0x20, 0xAA, 0x08, 0x60, 0x3B, 0x02,
  0x20, 0x9A, 0x0A, 0x60, 0xBA, 0x0B, 0x30, 0x6A, 0x0E, 0x50, 0x7B, 0x02, 0x30, 0x2B, 0x09, 0x30,
  0x7B, 0x07, 0x50, 0x9B, 0x81, 0xEC, 0xEB, 0x09, 0x70, 0xBF, 0x09, 0x72, 0x85, 0x6B, 0xEF, 0xDA,
  0x37,
  // "Ő" (U+0150)
  0x76, 0x07, 0xA8, 0x2E, 0x20, 0x4B, 0x05, 0x75, 0x02, 0xB8, 0x25, 0x01, 0xDA, 0x07, 0x76, 0x0D,
  0xA0, 0x52, 0x0A, 0xA0, 0x77, 0x68, 0x2A, 0xFE, 0x42, 0x07, 0xA0, 0x67, 0x68, 0x28, 0xFD, 0x32,
  0x05, 0xA0, 0x57, 0x68, 0x24, 0xFB, 0x12, 0x82, 0x2E, 0xD3, 0x80, 0xF2, 0x08, 0x62, 0x8C, 0xEF,
  0xEB, 0x67, 0x71, 0x07, 0xF9, 0x0D, 0x02, 0x75, 0x0B, 0xC0, 0x0C, 0xC0, 0xE0, 0x17, 0x30, 0xBB,
  0x08, 0x01, 0x30, 0x8B, 0x09, 0x72, 0x09, 0xB0, 0x56, 0x0A, 0xB0, 0x17, 0x03, 0xB0, 0x67, 0x02,
  0xB0, 0x57, 0x0D, 0xA0, 0xB7, 0x20, 0xEA, 0x08, 0x60, 0x5B, 0x03, 0x72, 0x0B, 0xA0, 0xA6, 0x0C,
  0xA0, 0xB7, 0x30, 0xAA, 0x0B, 0x50, 0x3B, 0x04, 0x73, 0x0B, 0xA0, 0xB5, 0x09, 0xA0, 0xE7, 0x40,
  0xBA, 0x0A, 0x50, 0xEA, 0x09, 0x74, 0x0D, 0xA0, 0x94, 0x02, 0xB0, 0x57, 0x40, 0xEA, 0x07, 0x40,
  0x6B, 0x01, 0x73, 0x01, 0xB0, 0x54, 0x09, 0xA0, 0xD7, 0x40, 0x4B, 0x03, 0x40, 0xCA, 0x0A, 0x74,
  0x07, 0xB5, 0x0E, 0xA0, 0x87, 0x40, 0xBA, 0x0C, 0x5B, 0x07, 0x74, 0xB0, 0x74, 0x01, 0xB0, 0x57,
  0x30, 0x5B, 0x02, 0x40, 0x2B, 0x05, 0x73, 0x0A, 0xA0, 0xD5, 0x01, 0xB0, 0x57, 0x20, 0x1B, 0x06,
  0x50, 0x1B, 0x06, 0x72, 0x08, 0xA0, 0xE7, 0x0E, 0xA0, 0x87, 0x10, 0x2B, 0x07, 0x70, 0xBA, 0x0C,
  0x71, 0x0C, 0xA0, 0xD7, 0x10, 0x7B, 0x04, 0x60, 0xAB, 0x04, 0x71, 0x01, 0x0E, 0xA0, 0xE0, 0x53,
  0x03, 0x0B, 0xB0, 0x67, 0x30, 0x6C, 0x81, 0xEC, 0xDC, 0x07, 0x75, 0x06, 0xF9, 0x0E, 0x04, 0x77,
  0x86, 0x28, 0xCE, 0xFE, 0xB6, 0x75,
  // "ő" (U+0151)
  0x73, 0x07, 0xA8, 0x2E, 0x20, 0x4B, 0x05, 0x72, 0x02, 0xB8, 0x25, 0x01, 0xDA, 0x07, 0x73, 0x0D,
  0xA0, 0x52, 0x0A, 0xA0, 0x77, 0x38, 0x2A, 0xFE, 0x42, 0x07, 0xA0, 0x67, 0x38, 0x28, 0xFD, 0x32,
  0x05, 0xA0, 0x57, 0x38, 0x24, 0xFB, 0x12, 0x82, 0x2E, 0xD3, 0x80, 0xE1, 0x08, 0x51, 0x8C, 0xEE,
  0xC7, 0x76, 0x06, 0xF0, 0xC0, 0x17, 0x30, 0x7B, 0x81, 0xEC, 0xEB, 0x0B, 0x72, 0x05, 0xB0, 0x83,
  0x07, 0xB0, 0x37, 0x10, 0xEA, 0x09, 0x50, 0xDA, 0x08, 0x70, 0x8A, 0x0D, 0x60, 0x8A, 0x0B, 0x70,
  0xEA, 0x06, 0x60, 0x6A, 0x0D, 0x60, 0x6A, 0x0E, 0x70, 0x6A, 0x0D, 0x60, 0xAA, 0x09, 0x70, 0x7A,
  0x0C, 0x6B, 0x04, 0x70, 0x9A, 0x0B, 0x50, 0x3B, 0x01, 0x70, 0xBA, 0x08, 0x50, 0x6A, 0x0D, 0x71,
  0x0E, 0xA0, 0x65, 0x08, 0xA0, 0xB7, 0x02, 0xB0, 0x25, 0x0A, 0xA0, 0x97, 0x06, 0xA0, 0xD6, 0x0A,
  0xA0, 0x87, 0x0C, 0xA0, 0x96, 0x0A, 0xA0, 0x86, 0x03, 0xB0, 0x26, 0x09, 0xA0, 0xA6, 0x0B, 0xA0,
  0xB7, 0x06, 0xA0, 0xE5, 0x07, 0xB0, 0x27, 0x02, 0xB0, 0x93, 0x07, 0xB0, 0x77, 0x20, 0x9B, 0x81,
  0xEC, 0xEB, 0x09, 0x74, 0x0B, 0xF0, 0x97, 0x68, 0x56, 0xBE, 0xFD, 0xA3, 0x74,
  // "Œ" (U+0152)
  0x72, 0x82, 0x39, 0xCE, 0xFF, 0x03, 0x71, 0x09, 0xFF, 0xC7, 0x02, 0x0C, 0xC0, 0xFC, 0xB0, 0xD8,
  0x03, 0xC0, 0x96, 0x01, 0x0D, 0xB0, 0x80, 0x13, 0xB0, 0x47, 0x70, 0xBB, 0x05, 0x40, 0x3B, 0x01,
  0x76, 0x05, 0xB0, 0x65, 0x06, 0xA0, 0xD7, 0x70, 0xEA, 0x0A, 0x60, 0x9A, 0x0A, 0x76, 0x07, 0xB0,
  0x26, 0x0C, 0xA0, 0x77, 0x60, 0xDA, 0x0A, 0x7B, 0x03, 0x75, 0x04, 0xB0, 0x36, 0x03, 0xB7, 0x60,
  0x9A, 0x0D, 0x70, 0x7A, 0x0D, 0x76, 0x0E, 0xA0, 0x87, 0x0A, 0xA0, 0x97, 0x50, 0x3B, 0x04, 0x70,
  0xDA, 0x0D, 0x80, 0x3C, 0x01, 0x40, 0x6B, 0x70, 0x1F, 0xB0, 0xE5, 0x0A, 0xA0, 0xD7, 0x04, 0xFB,
  0x0B, 0x50, 0xCA, 0x0A, 0x70, 0x7A, 0x0C, 0x76, 0x0E, 0xA0, 0x87, 0x0A, 0xA0, 0x87, 0x6B, 0x06,
  0x70, 0xEA, 0x05, 0x75, 0x01, 0xB0, 0x56, 0x01, 0xB0, 0x27, 0x50, 0x2B, 0x05, 0x60, 0x5A, 0x0E,
  0x76, 0x02, 0xB0, 0x56, 0x08, 0xA0, 0xC7, 0x60, 0x1B, 0x06, 0x60, 0xBA, 0x09, 0x77, 0x0E, 0xA0,
  0x86, 0x0E, 0xA0, 0x57, 0x70, 0xBA, 0x0D, 0x50, 0x2B, 0x02, 0x77, 0x06, 0xB0, 0x64, 0x05, 0xB7,
  0x72, 0x0E, 0xB0, 0x63, 0x08, 0xA0, 0xC7, 0x72, 0x04, 0xC8, 0x1E, 0xCC, 0xB0, 0xE8, 0x03, 0xC0,
  0xA7, 0x20, 0x50, 0xEF, 0xFA, 0x09, 0x73, 0x82, 0x18, 0xCE, 0xFE, 0x06, 0x60,
  // "œ" (U+0153)
  0x68, 0x52, 0x9D, 0xFE, 0xC6, 0x58, 0x53, 0x9D, 0xFE, 0xA3, 0x70, 0x6F, 0x08, 0x30, 0x7F, 0x05,
  0x50, 0x7C, 0x0C, 0x0E, 0xB8, 0x13, 0x09, 0xB0, 0xE0, 0xCB, 0x0E, 0x40, 0x5B, 0x09, 0x30, 0x7A,
  0x08, 0x06, 0xA0, 0xD0, 0x42, 0x03, 0xB0, 0x33, 0x0E, 0xA0, 0xA5, 0x81, 0xCF, 0xEA, 0x0D, 0x01,
  0x40, 0xCA, 0x04, 0x20, 0x7A, 0x0D, 0x60, 0x8C, 0x03, 0x50, 0xDA, 0x03, 0x20, 0xEA, 0x06, 0x60,
  0x6B, 0x09, 0x50, 0x3A, 0x0E, 0x20, 0x5A, 0x0E, 0x70, 0x6B, 0x02, 0x40, 0x20, 0xDA, 0x09, 0x20,
  0xAA, 0x09, 0x70, 0x7A, 0x0C, 0x38, 0x13, 0x8E, 0xA0, 0xD0, 0x12, 0x0E, 0xA0, 0x47, 0x09, 0xA8,
  0x1E, 0xCD, 0xD0, 0xD0, 0x22, 0x03, 0xB7, 0x10, 0xBF, 0xA0, 0x80, 0x13, 0x06, 0xA0, 0xD7, 0x10,
  0xEB, 0x84, 0xEE, 0xC9, 0x51, 0x50, 0x8A, 0x0A, 0x70, 0x2B, 0x01, 0x74, 0x0A, 0xA0, 0x97, 0x07,
  0xB7, 0x50, 0xAA, 0x08, 0x70, 0xCA, 0x0E, 0x75, 0x0A, 0xA0, 0x86, 0x03, 0xC7, 0x50, 0x9A, 0x09,
  0x60, 0xBC, 0x02, 0x74, 0x06, 0xA0, 0xD5, 0x07, 0xA0, 0xEA, 0x08, 0x74, 0x02, 0xB0, 0x83, 0x07,
  0xA0, 0xD0, 0x3B, 0x06, 0x48, 0x15, 0xC4, 0x40, 0x9B, 0x81, 0xEC, 0xEA, 0x82, 0xE3, 0x0B, 0xB8,
  0x1E, 0xCD, 0xB0, 0x45, 0x0B, 0xE0, 0xE0, 0x32, 0x01, 0x0D, 0xF0, 0xE0, 0x36, 0x85, 0x6C, 0xEF,
  0xC8, 0x15, 0x08, 0x0D, 0xA8, 0x1D, 0xA6, 0x50,
  // "Ŕ" (U+0154)
  0x77, 0x18, 0x31, 0x77, 0x75, 0x77, 0x10, 0xAB, 0x04, 0x77, 0x04, 0xB0, 0x57, 0x70, 0x10, 0xEA,
  0x06, 0x77, 0x10, 0xBA, 0x06, 0x77, 0x10, 0x9A, 0x05, 0x77, 0x18, 0x24, 0xFE, 0x48, 0x0D, 0x70,
  0x09, 0xD8, 0x2E, 0xC8, 0x27, 0x30, 0xCF, 0xA0, 0x77, 0x2B, 0x0F, 0xC0, 0xEC, 0x07, 0x70, 0x3B,
  0x01, 0x30, 0x50, 0xEA, 0x0E, 0x01, 0x60, 0x6A, 0x0D, 0x50, 0x5B, 0x06, 0x60, 0x9A, 0x0A, 0x60,
  0xEA, 0x09, 0x60, 0xDA, 0x07, 0x60, 0xCA, 0x0A, 0x6B, 0x04, 0x60, 0xDA, 0x09, 0x50, 0x3B, 0x01,
  0x60, 0xEA, 0x08, 0x50, 0x7A, 0x0D, 0x60, 0x2B, 0x05, 0x50, 0xAA, 0x0A, 0x60, 0x7B, 0x01, 0x50,
  0xDA, 0x07, 0x60, 0xEA, 0x0B, 0x50, 0x1B, 0x04, 0x50, 0xBB, 0x03, 0x50, 0x4B, 0x01, 0x30, 0x30,
  0xBB, 0x09, 0x60, 0x7B, 0x0F, 0xC0, 0xEC, 0x0A, 0x70, 0xBF, 0xA0, 0xE0, 0x67, 0x10, 0xEF, 0x90,
  0x97, 0x20, 0x1B, 0x03, 0x20, 0x9A, 0x0B, 0x72, 0x05, 0xB3, 0x05, 0xA0, 0xE7, 0x20, 0x8A, 0x0C,
  0x30, 0x2B, 0x03, 0x71, 0x0B, 0xA0, 0x84, 0x0E, 0xA0, 0x77, 0x10, 0xEA, 0x05, 0x40, 0xAA, 0x0B,
  0x70, 0x2B, 0x02, 0x40, 0x7B, 0x70, 0x5A, 0x0E, 0x50, 0x3B, 0x03, 0x60, 0x9A, 0x0B, 0x6B, 0x07,
  0x60, 0xCA, 0x08, 0x60, 0xCA, 0x0B, 0x6B, 0x04, 0x60, 0x8B, 0x50, 0x3B, 0x01, 0x60, 0x5B, 0x04,
  0x40, 0x6A, 0x0D, 0x70, 0x1B, 0x07, 0x40,
  // "ŕ" (U+0155)
  0x74, 0x83, 0x17, 0x77, 0x57, 0x40, 0xAB, 0x04, 0x73, 0x04, 0xB0, 0x57, 0x30, 0x10, 0xEA, 0x06,
  0x74, 0x0B, 0xA0, 0x67, 0x40, 0x9A, 0x05, 0x74, 0x82, 0x4F, 0xE4, 0x80, 0xC5, 0x00, 0x3A, 0x83,
  0x50, 0x19, 0xEA, 0x60, 0x6A, 0x81, 0x32, 0xEB, 0x0B, 0x60, 0xAA, 0x85, 0x2E, 0xFE, 0xCE, 0x76,
  0x0D, 0xA8, 0x1A, 0xF8, 0x72, 0x01, 0xC0, 0x87, 0x30, 0x4B, 0x0C, 0x74, 0x07, 0xB0, 0x47, 0x40,
  0xAA, 0x0C, 0x75, 0x0D, 0xA0, 0x77, 0x40, 0x1B, 0x02, 0x74, 0x04, 0xA0, 0xE7, 0x50, 0x7A, 0x0B,
  0x75, 0x0B, 0xA0, 0x77, 0x50, 0xEA, 0x04, 0x74, 0x02, 0xB0, 0x17, 0x40, 0x5A, 0x0D, 0x75, 0x08,
  0xA0, 0xA7, 0x50, 0xBA, 0x07, 0x75, 0x0E, 0xA0, 0x47, 0x40, 0x2B, 0x01, 0x74, 0x05, 0xA0, 0xD7,
  0x50, 0x9A, 0x0A, 0x75,
  // "Ŗ" (U+0156)
  0x60, 0x9D, 0x82, 0xEC, 0x82, 0x72, 0x0C, 0xFA, 0x07, 0x71, 0xB0, 0xFC, 0x0E, 0xC0, 0x76, 0x03,
  0xB0, 0x13, 0x05, 0x0E, 0xA0, 0xE0, 0x15, 0x06, 0xA0, 0xD5, 0x05, 0xB0, 0x65, 0x09, 0xA0, 0xA6,
  0x0E, 0xA0, 0x95, 0x0D, 0xA0, 0x76, 0x0C, 0xA0, 0xA5, 0xB0, 0x46, 0x0D, 0xA0, 0x94, 0x03, 0xB0,
  0x16, 0x0E, 0xA0, 0x84, 0x07, 0xA0, 0xD6, 0x02, 0xB0, 0x54, 0x0A, 0xA0, 0xA6, 0x07, 0xB0, 0x14,
  0x0D, 0xA0, 0x76, 0x0E, 0xA0, 0xB4, 0x01, 0xB0, 0x45, 0x0B, 0xB0, 0x34, 0x04, 0xB0, 0x13, 0x03,
  0x0B, 0xB0, 0x95, 0x07, 0xB0, 0xFC, 0x0E, 0xC0, 0xA6, 0x0B, 0xFA, 0x0E, 0x06, 0x70, 0xEF, 0x90,
  0x97, 0x10, 0x1B, 0x03, 0x20, 0x9A, 0x0B, 0x71, 0x05, 0xB3, 0x05, 0xA0, 0xE7, 0x10, 0x8A, 0x0C,
  0x30, 0x2B, 0x03, 0x70, 0xBA, 0x08, 0x40, 0xEA, 0x07, 0x70, 0xEA, 0x05, 0x40, 0xAA, 0x0B, 0x60,
  0x2B, 0x02, 0x40, 0x7B, 0x60, 0x5A, 0x0E, 0x50, 0x3B, 0x03, 0x50, 0x9A, 0x0B, 0x6B, 0x07, 0x50,
  0xCA, 0x08, 0x60, 0xCA, 0x0B, 0x5B, 0x04, 0x60, 0x8B, 0x40, 0x3B, 0x01, 0x60, 0x5B, 0x04, 0x30,
  0x6A, 0x0D, 0x70, 0x1B, 0x07, 0x80, 0xD2, 0x08, 0x22, 0x77, 0x67, 0x71, 0x09, 0xA0, 0x97, 0x70,
  0x10, 0xEA, 0x02, 0x77, 0x07, 0xA0, 0x77, 0x71, 0x81, 0xEF, 0xC7, 0x71, 0x82, 0x7F, 0xE2, 0x77,
  0x18, 0x1E, 0xF4, 0x76,
  // "ŗ" (U+0157)
  0x50, 0x3A, 0x83, 0x50, 0x19, 0xEA, 0x50, 0x6A, 0x81, 0x32, 0xEB, 0x0B, 0x50, 0xAA, 0x85, 0x2E,
  0xFE, 0xCE, 0x75, 0x0D, 0xA8, 0x1A, 0xF8, 0x71, 0x01, 0xC0, 0x87, 0x20, 0x4B, 0x0C, 0x73, 0x07,
  0xB0, 0x47, 0x30, 0xAA, 0x0C, 0x74, 0x0D, 0xA0, 0x77, 0x30, 0x1B, 0x02, 0x73, 0x04, 0xA0, 0xE7,
  0x40, 0x7A, 0x0B, 0x74, 0x0B, 0xA0, 0x77, 0x40, 0xEA, 0x04, 0x73, 0x02, 0xB0, 0x17, 0x30, 0x5A,
  0x0D, 0x74, 0x08, 0xA0, 0xA7, 0x40, 0xBA, 0x07, 0x74, 0x0E, 0xA0, 0x47, 0x30, 0x2B, 0x01, 0x73,
  0x05, 0xA0, 0xD7, 0x40, 0x9A, 0x0A, 0x80, 0xC6, 0x08, 0x22, 0x77, 0x67, 0x40, 0x9A, 0x09, 0x73,
  0x01, 0x0E, 0xA0, 0x27, 0x30, 0x7A, 0x07, 0x74, 0x81, 0xEF, 0xC7, 0x48, 0x27, 0xFE, 0x27, 0x48,
  0x1E, 0xF4, 0x75,
  // "Ř" (U+0158)
  0x71, 0x81, 0x17, 0x66, 0x81, 0x67, 0x27, 0x28, 0x1E, 0xF7, 0x38, 0x21, 0xBF, 0xB7, 0x30, 0x7A,
  0x84, 0x20, 0x1D, 0xFC, 0x74, 0x01, 0xA8, 0x4B, 0x1D, 0xFD, 0x17, 0x50, 0x9A, 0x82, 0xEF, 0xE3,
  0x76, 0x03, 0xC0, 0x57, 0x71, 0x0D, 0xA0, 0x98, 0x0D, 0x70, 0x09, 0xD8, 0x2E, 0xC8, 0x27, 0x30,
  0xCF, 0xA0, 0x77, 0x2B, 0x0F, 0xC0, 0xEC, 0x07, 0x70, 0x3B, 0x01, 0x30, 0x50, 0xEA, 0x0E, 0x01,
  0x60, 0x6A, 0x0D, 0x50, 0x5B, 0x06, 0x60, 0x9A, 0x0A, 0x60, 0xEA, 0x09, 0x60, 0xDA, 0x07, 0x60,
  0xCA, 0x0A, 0x6B, 0x04, 0x60, 0xDA, 0x09, 0x50, 0x3B, 0x01, 0x60, 0xEA, 0x08, 0x50, 0x7A, 0x0D,
  0x60, 0x2B, 0x05, 0x50, 0xAA, 0x0A, 0x60, 0x7B, 0x01, 0x50, 0xDA, 0x07, 0x60, 0xEA, 0x0B, 0x50,
  0x1B, 0x04, 0x50, 0xBB, 0x03, 0x50, 0x4B, 0x01, 0x30, 0x30, 0xBB, 0x09, 0x60, 0x7B, 0x0F, 0xC0,
  0xEC, 0x0A, 0x70, 0xBF, 0xA0, 0xE0, 0x67, 0x10, 0xEF, 0x90, 0x97, 0x20, 0x1B, 0x03, 0x20, 0x9A,
  0x0B, 0x72, 0x05, 0xB3, 0x05, 0xA0, 0xE7, 0x20, 0x8A, 0x0C, 0x30, 0x2B, 0x03, 0x71, 0x0B, 0xA0,
  0x84, 0x0E, 0xA0, 0x77, 0x10, 0xEA, 0x05, 0x40, 0xAA, 0x0B, 0x70, 0x2B, 0x02, 0x40, 0x7B, 0x70,
  0x5A, 0x0E, 0x50, 0x3B, 0x03, 0x60, 0x9A, 0x0B, 0x6B, 0x07, 0x60, 0xCA, 0x08, 0x60, 0xCA, 0x0B,
  0x6B, 0x04, 0x60, 0x8B, 0x50, 0x3B, 0x01, 0x60, 0x5B, 0x04, 0x40, 0x6A, 0x0D, 0x70, 0x1B, 0x07,
  0x40,
  // "ř" (U+0159)
  0x58, 0x11, 0x76, 0x68, 0x16, 0x72, 0x68, 0x1E, 0xF7, 0x38, 0x21, 0xBF, 0xB7, 0x07, 0xA8, 0x42,
  0x01, 0xDF, 0xC7, 0x10, 0x1A, 0x84, 0xB1, 0xDF, 0xD1, 0x72, 0x09, 0xA8, 0x2E, 0xFE, 0x37, 0x30,
  0x3C, 0x05, 0x75, 0x0D, 0xA0, 0x98, 0x0C, 0x70, 0x03, 0xA8, 0x35, 0x01, 0x9E, 0xA7, 0x06, 0xA8,
  0x13, 0x2E, 0xB0, 0xB7, 0x0A, 0xA8, 0x52, 0xEF, 0xEC, 0xE7, 0x70, 0xDA, 0x81, 0xAF, 0x87, 0x30,
  0x1C, 0x08, 0x74, 0x04, 0xB0, 0xC7, 0x50, 0x7B, 0x04, 0x75, 0x0A, 0xA0, 0xC7, 0x60, 0xDA, 0x07,
  0x75, 0x01, 0xB0, 0x27, 0x50, 0x4A, 0x0E, 0x76, 0x07, 0xA0, 0xB7, 0x60, 0xBA, 0x07, 0x76, 0x0E,
  0xA0, 0x47, 0x50, 0x2B, 0x01, 0x75, 0x05, 0xA0, 0xD7, 0x60, 0x8A, 0x0A, 0x76, 0x0B, 0xA0, 0x77,
  0x60, 0xEA, 0x04, 0x75, 0x02, 0xB0, 0x17, 0x50, 0x5A, 0x0D, 0x76, 0x09, 0xA0, 0xA7, 0x60,
  // "Ś" (U+015A)
  0x77, 0x18, 0x31, 0x77, 0x75, 0x77, 0x10, 0xAB, 0x04, 0x77, 0x04, 0xB0, 0x57, 0x70, 0x10, 0xEA,
  0x06, 0x77, 0x10, 0xBA, 0x06, 0x77, 0x10, 0x9A, 0x05, 0x77, 0x18, 0x24, 0xFE, 0x48, 0x0E, 0x20,
  0x87, 0x5A, 0xDE, 0xED, 0xB7, 0x27, 0x20, 0x40, 0xEF, 0xA0, 0x77, 0x06, 0xC8, 0x1E, 0xCD, 0xC0,
  0x36, 0x03, 0xB0, 0xD0, 0x44, 0x81, 0x6D, 0xA7, 0x0C, 0xA0, 0xD0, 0x17, 0x01, 0x60, 0x3B, 0x04,
  0x77, 0x10, 0x6B, 0x77, 0x20, 0x8A, 0x0D, 0x77, 0x20, 0x8A, 0x0E, 0x77, 0x20, 0x7B, 0x04, 0x77,
  0x10, 0x4B, 0x0C, 0x77, 0x20, 0xDB, 0x0A, 0x77, 0x10, 0x4C, 0x0A, 0x77, 0x10, 0x7C, 0x0B, 0x77,
  0x10, 0x8C, 0x0C, 0x01, 0x77, 0x07, 0xC0, 0xA7, 0x71, 0x06, 0xC0, 0x67, 0x71, 0x07, 0xB0, 0xC7,
  0x72, 0x0B, 0xB0, 0x27, 0x71, 0x05, 0xB0, 0x37, 0x71, 0x02, 0xB0, 0x57, 0x71, 0x02, 0xB0, 0x47,
  0x71, 0x04, 0xB0, 0x27, 0x71, 0x0A, 0xA0, 0xD6, 0x01, 0x71, 0x05, 0xB0, 0x75, 0x82, 0x3F, 0x93,
  0x40, 0x10, 0x8B, 0x0D, 0x60, 0x4C, 0x81, 0xDC, 0xDC, 0x0E, 0x02, 0x60, 0x5F, 0xB0, 0xC0, 0x27,
  0x18, 0x23, 0x8B, 0xDA, 0x82, 0xEC, 0x94, 0x72,
  // "ś" (U+015B)
  0x75, 0x83, 0x17, 0x77, 0x57, 0x50, 0xAB, 0x04, 0x74, 0x04, 0xB0, 0x57, 0x40, 0x10, 0xEA, 0x06,
  0x75, 0x0B, 0xA0, 0x67, 0x50, 0x9A, 0x05, 0x75, 0x82, 0x4F, 0xE4, 0x80, 0xD1, 0x08, 0x64, 0xAD,
  0xFE, 0xDA, 0x57, 0x10, 0x9F, 0x90, 0xD6, 0x08, 0xC0, 0x0D, 0xB0, 0xA5, 0x02, 0xB0, 0xA0, 0x13,
  0x81, 0x6E, 0x25, 0x07, 0xA0, 0xD7, 0x60, 0x9A, 0x0A, 0x76, 0x09, 0xA0, 0xB7, 0x60, 0x6B, 0x01,
  0x75, 0x01, 0xB0, 0xC0, 0x17, 0x50, 0x7B, 0x0D, 0x02, 0x75, 0x09, 0xB0, 0xE0, 0x27, 0x50, 0x9B,
  0x0E, 0x02, 0x75, 0x07, 0xB0, 0xC7, 0x60, 0x8B, 0x04, 0x76, 0x0E, 0xA0, 0x77, 0x60, 0xBA, 0x08,
  0x76, 0x0C, 0xA0, 0x77, 0x50, 0x2B, 0x05, 0x48, 0x23, 0xC5, 0x13, 0x04, 0x0D, 0xA0, 0xE5, 0x03,
  0xB8, 0x1D, 0xCE, 0xC0, 0x55, 0x03, 0xFA, 0x06, 0x78, 0x73, 0x9C, 0xEF, 0xEC, 0x82, 0x70,
  // "Ŝ" (U+015C)
  0x75, 0x82, 0x47, 0x74, 0x77, 0x02, 0x0E, 0xA0, 0xC7, 0x70, 0xCC, 0x03, 0x75, 0x0A, 0xA0, 0x9A,
  0x09, 0x74, 0x08, 0xA8, 0x15, 0x0A, 0xA0, 0x17, 0x28, 0x27, 0xFE, 0x42, 0x82, 0x1E, 0xF7, 0x71,
  0x82, 0x4F, 0xD3, 0x48, 0x14, 0xFE, 0x80, 0xD4, 0x08, 0x75, 0xAD, 0xEE, 0xDB, 0x72, 0x71, 0x04,
  0x0E, 0xFA, 0x07, 0x60, 0x6C, 0x81, 0xEC, 0xDC, 0x03, 0x50, 0x3B, 0x0D, 0x04, 0x48, 0x16, 0xDA,
  0x60, 0xCA, 0x0D, 0x01, 0x70, 0x15, 0x03, 0xB0, 0x47, 0x70, 0x6B, 0x77, 0x10, 0x8A, 0x0D, 0x77,
  0x10, 0x8A, 0x0E, 0x77, 0x10, 0x7B, 0x04, 0x77, 0x04, 0xB0, 0xC7, 0x71, 0x0D, 0xB0, 0xA7, 0x70,
  0x4C, 0x0A, 0x77, 0x07, 0xC0, 0xB7, 0x70, 0x8C, 0x0C, 0x01, 0x76, 0x07, 0xC0, 0xA7, 0x70, 0x6C,
  0x06, 0x77, 0x07, 0xB0, 0xC7, 0x71, 0x0B, 0xB0, 0x27, 0x70, 0x5B, 0x03, 0x77, 0x02, 0xB0, 0x57,
  0x70, 0x2B, 0x04, 0x77, 0x04, 0xB0, 0x27, 0x70, 0xAA, 0x0D, 0x50, 0x17, 0x10, 0x5B, 0x07, 0x48,
  0x23, 0xF9, 0x34, 0x01, 0x08, 0xB0, 0xD5, 0x04, 0xC8, 0x1D, 0xCD, 0xC0, 0xE0, 0x25, 0x05, 0xFB,
  0x0C, 0x02, 0x78, 0x23, 0x8B, 0xDA, 0x82, 0xEC, 0x94, 0x71,
  // "ŝ" (U+015D)
  0x73, 0x82, 0x47, 0x74, 0x74, 0x02, 0x0E, 0xA0, 0xC7, 0x40, 0xCC, 0x03, 0x72, 0x0A, 0xA0, 0x9A,
  0x09, 0x71, 0x08, 0xA8, 0x15, 0x0A, 0xA0, 0x16, 0x82, 0x7F, 0xE4, 0x28, 0x21, 0xEF, 0x75, 0x82,
  0x4F, 0xD3, 0x48, 0x14, 0xFE, 0x80, 0xC2, 0x08, 0x64, 0xAD, 0xFE, 0xDA, 0x57, 0x09, 0xF9, 0x0D,
  0x50, 0x8C, 0x00, 0xDB, 0x0A, 0x40, 0x2B, 0x0A, 0x01, 0x38, 0x16, 0xE2, 0x40, 0x7A, 0x0D, 0x75,
  0x09, 0xA0, 0xA7, 0x50, 0x9A, 0x0B, 0x75, 0x06, 0xB0, 0x17, 0x40, 0x1B, 0x0C, 0x01, 0x74, 0x07,
  0xB0, 0xD0, 0x27, 0x40, 0x9B, 0x0E, 0x02, 0x74, 0x09, 0xB0, 0xE0, 0x27, 0x40, 0x7B, 0x0C, 0x75,
  0x08, 0xB0, 0x47, 0x50, 0xEA, 0x07, 0x75, 0x0B, 0xA0, 0x87, 0x50, 0xCA, 0x07, 0x74, 0x02, 0xB0,
  0x53, 0x82, 0x3C, 0x51, 0x30, 0x40, 0xDA, 0x0E, 0x40, 0x3B, 0x81, 0xDC, 0xEC, 0x05, 0x40, 0x3F,
  0xA0, 0x66, 0x87, 0x39, 0xCE, 0xFE, 0xC8, 0x26,
  // "Ş" (U+015E)
  0x72, 0x87, 0x5A, 0xDE, 0xED, 0xB7, 0x27, 0x10, 0x40, 0xEF, 0xA0, 0x76, 0x06, 0xC8, 0x1E, 0xCD,
  0xC0, 0x35, 0x03, 0xB0, 0xD0, 0x44, 0x81, 0x6D, 0xA6, 0x0C, 0xA0, 0xD0, 0x17, 0x01, 0x50, 0x3B,
  0x04, 0x77, 0x06, 0xB7, 0x71, 0x08, 0xA0, 0xD7, 0x71, 0x08, 0xA0, 0xE7, 0x71, 0x07, 0xB0, 0x47,
  0x70, 0x4B, 0x0C, 0x77, 0x10, 0xDB, 0x0A, 0x77, 0x04, 0xC0, 0xA7, 0x70, 0x7C, 0x0B, 0x77, 0x08,
  0xC0, 0xC0, 0x17, 0x60, 0x7C, 0x0A, 0x77, 0x06, 0xC0, 0x67, 0x70, 0x7B, 0x0C, 0x77, 0x10, 0xBB,
  0x02, 0x77, 0x05, 0xB0, 0x37, 0x70, 0x2B, 0x05, 0x77, 0x02, 0xB0, 0x47, 0x70, 0x4B, 0x02, 0x77,
  0x0A, 0xA0, 0xD5, 0x01, 0x71, 0x05, 0xB0, 0x74, 0x82, 0x3F, 0x93, 0x40, 0x10, 0x8B, 0x0D, 0x50,
  0x4C, 0x81, 0xDC, 0xDC, 0x0E, 0x02, 0x50, 0x5F, 0xB0, 0xC0, 0x27, 0x82, 0x38, 0xBD, 0xA8, 0x2E,
  0xC9, 0x47, 0x70, 0x07, 0x77, 0x28, 0x18, 0xF7, 0x77, 0x18, 0x22, 0xFE, 0x17, 0x71, 0x09, 0xB0,
  0x67, 0x71, 0x02, 0x0C, 0xA0, 0x27, 0x71, 0x04, 0xA0, 0x67, 0x71, 0x06, 0xA0, 0x57, 0x48, 0x63,
  0x12, 0x6E, 0xFE, 0x17, 0x30, 0x1E, 0x05, 0x75, 0x0D, 0xA8, 0x1D, 0x92, 0x74,
  // "ş" (U+015F)
  0x68, 0x64, 0xAD, 0xFE, 0xDA, 0x56, 0x09, 0xF9, 0x0D, 0x40, 0x8C, 0x00, 0xDB, 0x0A, 0x30, 0x2B,
  0x0A, 0x01, 0x38, 0x16, 0xE2, 0x30, 0x7A, 0x0D, 0x74, 0x09, 0xA0, 0xA7, 0x40, 0x9A, 0x0B, 0x74,
  0x06, 0xB0, 0x17, 0x30, 0x1B, 0x0C, 0x01, 0x73, 0x07, 0xB0, 0xD0, 0x27, 0x30, 0x9B, 0x0E, 0x02,
  0x73, 0x09, 0xB0, 0xE0, 0x27, 0x30, 0x7B, 0x0C, 0x74, 0x08, 0xB0, 0x47, 0x40, 0xEA, 0x07, 0x74,
  0x0B, 0xA0, 0x87, 0x40, 0xCA, 0x07, 0x73, 0x02, 0xB0, 0x52, 0x82, 0x3C, 0x51, 0x30, 0x40, 0xDA,
  0x0E, 0x30, 0x3B, 0x81, 0xDC, 0xEC, 0x05, 0x30, 0x3F, 0xA0, 0x65, 0x87, 0x39, 0xCE, 0xFE, 0xC8,
  0x27, 0x30, 0x07, 0x75, 0x81, 0x8F, 0x77, 0x48, 0x22, 0xFE, 0x17, 0x40, 0x9B, 0x06, 0x74, 0x02,
  0x0C, 0xA0, 0x27, 0x40, 0x4A, 0x06, 0x74, 0x06, 0xA0, 0x57, 0x86, 0x31, 0x26, 0xEF, 0xE1, 0x60,
  0x1E, 0x05, 0x71, 0x0D, 0xA8, 0x1D, 0x92, 0x71,
  // "Š" (U+0160)
  0x71, 0x81, 0x17, 0x66, 0x81, 0x67, 0x27, 0x28, 0x1E, 0xF7, 0x38, 0x21, 0xBF, 0xB7, 0x30, 0x7A,
  0x84, 0x20, 0x1D, 0xFC, 0x74, 0x01, 0xA8, 0x4B, 0x1D, 0xFD, 0x17, 0x50, 0x9A, 0x82, 0xEF, 0xE3,
  0x76, 0x03, 0xC0, 0x57, 0x71, 0x0D, 0xA0, 0x98, 0x0E, 0x20, 0x87, 0x5A, 0xDE, 0xED, 0xB7, 0x27,
  0x20, 0x40, 0xEF, 0xA0, 0x77, 0x06, 0xC8, 0x1E, 0xCD, 0xC0, 0x36, 0x03, 0xB0, 0xD0, 0x44, 0x81,
  0x6D, 0xA7, 0x0C, 0xA0, 0xD0, 0x17, 0x01, 0x60, 0x3B, 0x04, 0x77, 0x10, 0x6B, 0x77, 0x20, 0x8A,
  0x0D, 0x77, 0x20, 0x8A, 0x0E, 0x77, 0x20, 0x7B, 0x04, 0x77, 0x10, 0x4B, 0x0C, 0x77, 0x20, 0xDB,
  0x0A, 0x77, 0x10, 0x4C, 0x0A, 0x77, 0x10, 0x7C, 0x0B, 0x77, 0x10, 0x8C, 0x0C, 0x01, 0x77, 0x07,
  0xC0, 0xA7, 0x71, 0x06, 0xC0, 0x67, 0x71, 0x07, 0xB0, 0xC7, 0x72, 0x0B, 0xB0, 0x27, 0x71, 0x05,
  0xB0, 0x37, 0x71, 0x02, 0xB0, 0x57, 0x71, 0x02, 0xB0, 0x47, 0x71, 0x04, 0xB0, 0x27, 0x71, 0x0A,
  0xA0, 0xD6, 0x01, 0x71, 0x05, 0xB0, 0x75, 0x82, 0x3F, 0x93, 0x40, 0x10, 0x8B, 0x0D, 0x60, 0x4C,
  0x81, 0xDC, 0xDC, 0x0E, 0x02, 0x60, 0x5F, 0xB0, 0xC0, 0x27, 0x18, 0x23, 0x8B, 0xDA, 0x82, 0xEC,
  0x94, 0x72,
  // "š" (U+0161)
  0x68, 0x11, 0x76, 0x68, 0x16, 0x72, 0x78, 0x1E, 0xF7, 0x38, 0x21, 0xBF, 0xB7, 0x10, 0x7A, 0x84,
  0x20, 0x1D, 0xFC, 0x72, 0x01, 0xA8, 0x4B, 0x1D, 0xFD, 0x17, 0x30, 0x9A, 0x82, 0xEF, 0xE3, 0x74,
  0x03, 0xC0, 0x57, 0x60, 0xDA, 0x09, 0x80, 0xD3, 0x08, 0x64, 0xAD, 0xFE, 0xDA, 0x57, 0x20, 0x9F,
  0x90, 0xD7, 0x08, 0xC0, 0x0D, 0xB0, 0xA6, 0x02, 0xB0, 0xA0, 0x13, 0x81, 0x6E, 0x26, 0x07, 0xA0,
  0xD7, 0x70, 0x9A, 0x0A, 0x77, 0x09, 0xA0, 0xB7, 0x70, 0x6B, 0x01, 0x76, 0x01, 0xB0, 0xC0, 0x17,
  0x60, 0x7B, 0x0D, 0x02, 0x76, 0x09, 0xB0, 0xE0, 0x27, 0x60, 0x9B, 0x0E, 0x02, 0x76, 0x07, 0xB0,
  0xC7, 0x70, 0x8B, 0x04, 0x77, 0x0E, 0xA0, 0x77, 0x70, 0xBA, 0x08, 0x77, 0x0C, 0xA0, 0x77, 0x60,
  0x2B, 0x05, 0x58, 0x23, 0xC5, 0x13, 0x04, 0x0D, 0xA0, 0xE6, 0x03, 0xB8, 0x1D, 0xCE, 0xC0, 0x56,
  0x03, 0xFA, 0x06, 0x71, 0x87, 0x39, 0xCE, 0xFE, 0xC8, 0x27, 0x10,
  // "Ţ" (U+0162)
  0x30, 0x2F, 0xF0, 0xB3, 0x06, 0xFF, 0x07, 0x30, 0x78, 0x01, 0xCB, 0x0D, 0x80, 0x1C, 0x03, 0x71,
  0x01, 0xB0, 0x47, 0x70, 0x4B, 0x01, 0x77, 0x07, 0xA0, 0xD7, 0x71, 0x0A, 0xA0, 0xA7, 0x71, 0x0D,
  0xA0, 0x77, 0x70, 0x1B, 0x03, 0x77, 0x04, 0xB7, 0x71, 0x07, 0xA0, 0xC7, 0x71, 0x0B, 0xA0, 0x97,
  0x71, 0x0E, 0xA0, 0x67, 0x70, 0x1B, 0x03, 0x77, 0x05, 0xB7, 0x71, 0x08, 0xA0, 0xC7, 0x71, 0x0B,
  0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x57, 0x70, 0x2B, 0x02, 0x77, 0x05, 0xA0, 0xE7, 0x71, 0x08, 0xA0,
  0xB7, 0x71, 0x0B, 0xA0, 0x87, 0x71, 0x0E, 0xA0, 0x57, 0x70, 0x2B, 0x02, 0x77, 0x06, 0xA0, 0xE7,
  0x71, 0x09, 0xA0, 0xB7, 0x71, 0x0C, 0xA0, 0x87, 0x71, 0xB0, 0x47, 0x70, 0x3B, 0x01, 0x77, 0x20,
  0x07, 0x77, 0x28, 0x18, 0xF7, 0x77, 0x18, 0x22, 0xFE, 0x17, 0x71, 0x09, 0xB0, 0x67, 0x71, 0x02,
  0x0C, 0xA0, 0x27, 0x71, 0x04, 0xA0, 0x67, 0x71, 0x06, 0xA0, 0x57, 0x48, 0x63, 0x12, 0x6E, 0xFE,
  0x17, 0x30, 0x1E, 0x05, 0x75, 0x0D, 0xA8, 0x1D, 0x92, 0x75,
  // "ţ" (U+0163)
  0x70, 0x3A, 0x73, 0x81, 0x9F, 0xD7, 0x38, 0x1E, 0xF9, 0x72, 0x06, 0xA0, 0x67, 0x20, 0xCA, 0x03,
  0x68, 0x11, 0x7D, 0xE0, 0xB3, 0x0B, 0xF9, 0x08, 0x38, 0x1B, 0xCE, 0xA8, 0x3D, 0xCC, 0xC4, 0x50,
  0xCA, 0x06, 0x72, 0xB0, 0x37, 0x10, 0x3B, 0x72, 0x06, 0xA0, 0xC7, 0x20, 0xAA, 0x08, 0x72, 0x0D,
  0xA0, 0x57, 0x10, 0x1B, 0x02, 0x71, 0x04, 0xA0, 0xE7, 0x20, 0x7A, 0x0B, 0x72, 0x0A, 0xA0, 0x87,
  0x20, 0xEA, 0x04, 0x71, 0x01, 0xB0, 0x17, 0x10, 0x5A, 0x0D, 0x72, 0x07, 0xA0, 0xA7, 0x20, 0x9A,
  0x09, 0x72, 0x09, 0xA0, 0xB7, 0x20, 0x6B, 0x82, 0xDC, 0xF1, 0x50, 0x10, 0xED, 0x01, 0x68, 0x42,
  0xBE, 0xEC, 0x97, 0x20, 0x07, 0x73, 0x81, 0x8F, 0x77, 0x28, 0x22, 0xFE, 0x17, 0x20, 0x9B, 0x06,
  0x72, 0x02, 0x0C, 0xA0, 0x27, 0x20, 0x4A, 0x06, 0x72, 0x06, 0xA0, 0x55, 0x86, 0x31, 0x26, 0xEF,
  0xE1, 0x40, 0x1E, 0x05, 0x60, 0xDA, 0x81, 0xD9, 0x26,
  // "Ť" (U+0164)
  0x48, 0x11, 0x76, 0x68, 0x16, 0x72, 0x58, 0x1E, 0xF7, 0x38, 0x21, 0xBF, 0xB6, 0x07, 0xA8, 0x42,
  0x01, 0xDF, 0xC7, 0x01, 0xA8, 0x4B, 0x1D, 0xFD, 0x17, 0x10, 0x9A, 0x82, 0xEF, 0xE3, 0x72, 0x03,
  0xC0, 0x57, 0x40, 0xDA, 0x09, 0x80, 0xC1, 0x00, 0x2F, 0xF0, 0xB0, 0x6F, 0xF0, 0x07, 0x80, 0x1C,
  0xB0, 0xD8, 0x01, 0xC0, 0x35, 0x01, 0xB0, 0x47, 0x40, 0x4B, 0x01, 0x74, 0x07, 0xA0, 0xD7, 0x50,
  0xAA, 0x0A, 0x75, 0x0D, 0xA0, 0x77, 0x40, 0x1B, 0x03, 0x74, 0x04, 0xB7, 0x50, 0x7A, 0x0C, 0x75,
  0x0B, 0xA0, 0x97, 0x50, 0xEA, 0x06, 0x74, 0x01, 0xB0, 0x37, 0x40, 0x5B, 0x75, 0x08, 0xA0, 0xC7,
  0x50, 0xBA, 0x09, 0x75, 0x0E, 0xA0, 0x57, 0x40, 0x2B, 0x02, 0x74, 0x05, 0xA0, 0xE7, 0x50, 0x8A,
  0x0B, 0x75, 0x0B, 0xA0, 0x87, 0x50, 0xEA, 0x05, 0x74, 0x02, 0xB0, 0x27, 0x40, 0x6A, 0x0E, 0x75,
  0x09, 0xA0, 0xB7, 0x50, 0xCA, 0x08, 0x75, 0xB0, 0x47, 0x40, 0x3B, 0x01, 0x74,
  // "ť" (U+0165)
  0x74, 0x09, 0xA0, 0x97, 0x40, 0xEA, 0x02, 0x73, 0x06, 0xA0, 0x87, 0x00, 0x82, 0x81, 0xDF, 0xD7,
  0x83, 0x6F, 0xE0, 0x5A, 0x03, 0x78, 0x5D, 0xFA, 0x0A, 0xE6, 0x70, 0x4A, 0x07, 0x74, 0x0A, 0xA0,
  0x37, 0x20, 0x40, 0xAE, 0x0B, 0x50, 0xBF, 0x90, 0x85, 0x81, 0xBC, 0xEA, 0x83, 0xDC, 0xCC, 0x47,
  0x0C, 0xA0, 0x67, 0x4B, 0x03, 0x73, 0x03, 0xB7, 0x40, 0x6A, 0x0C, 0x74, 0x0A, 0xA0, 0x87, 0x40,
  0xDA, 0x05, 0x73, 0x01, 0xB0, 0x27, 0x30, 0x4A, 0x0E, 0x74, 0x07, 0xA0, 0xB7, 0x40, 0xAA, 0x08,
  0x74, 0x0E, 0xA0, 0x47, 0x30, 0x1B, 0x01, 0x73, 0x05, 0xA0, 0xD7, 0x40, 0x7A, 0x0A, 0x74, 0x09,
  0xA0, 0x97, 0x40, 0x9A, 0x0B, 0x74, 0x06, 0xB8, 0x2D, 0xCF, 0x17, 0x01, 0x0E, 0xD0, 0x17, 0x18,
  0x42, 0xBE, 0xEC, 0x97, 0x10,
  // "Ŧ" (U+0166)
  0x10, 0x2F, 0xF8, 0x1B, 0x06, 0xFF, 0x81, 0x70, 0x78, 0x01, 0xCB, 0x0D, 0x80, 0x1C, 0x03, 0x60,
  0x1B, 0x04, 0x75, 0x04, 0xB0, 0x17, 0x50, 0x7A, 0x0D, 0x76, 0x0A, 0xA0, 0xA7, 0x60, 0xDA, 0x07,
  0x75, 0x01, 0xB0, 0x47, 0x50, 0x4B, 0x01, 0x75, 0x07, 0xA0, 0xD7, 0x60, 0xAA, 0x0A, 0x76, 0x0D,
  0xA0, 0x77, 0x10, 0x2F, 0xC0, 0x84, 0x05, 0xFC, 0x05, 0x48, 0x36, 0xCC, 0xCD, 0xA8, 0x4E, 0xCC,
  0xCC, 0x27, 0x10, 0xAA, 0x0A, 0x76, 0x0D, 0xA0, 0x67, 0x50, 0x1B, 0x03, 0x75, 0x04, 0xB7, 0x60,
  0x8A, 0x0C, 0x76, 0x0B, 0xA0, 0x97, 0x60, 0xEA, 0x06, 0x75, 0x02, 0xB0, 0x27, 0x50, 0x5B, 0x76,
  0x08, 0xA0, 0xC7, 0x60, 0xCA, 0x08, 0x76, 0xB0, 0x57, 0x50, 0x3B, 0x02, 0x74,
  // "ŧ" (U+0167)
  0x60, 0x3A, 0x72, 0x81, 0x9F, 0xC7, 0x28, 0x1E, 0xF9, 0x71, 0x06, 0xA0, 0x67, 0x10, 0xCA, 0x02,
  0x58, 0x11, 0x7D, 0xE0, 0xB2, 0x0B, 0xF9, 0x08, 0x28, 0x1B, 0xCE, 0xA8, 0x3D, 0xCC, 0xC4, 0x40,
  0xCA, 0x06, 0x71, 0xB0, 0x27, 0x03, 0xA0, 0xE7, 0x10, 0x6A, 0x0B, 0x71, 0x0A, 0xA0, 0x85, 0x01,
  0xFA, 0x20, 0x4F, 0x90, 0xD2, 0x81, 0x5C, 0xDB, 0x0F, 0xC0, 0x84, 0x06, 0xA0, 0xC7, 0x10, 0xAA,
  0x08, 0x71, 0x0D, 0xA0, 0x57, 0x01, 0xB0, 0x17, 0x04, 0xA0, 0xD7, 0x10, 0x7A, 0x0A, 0x71, 0x09,
  0xA0, 0x97, 0x10, 0x9A, 0x0C, 0x71, 0x07, 0xB8, 0x2D, 0xCE, 0x14, 0x01, 0x0E, 0xD0, 0x15, 0x84,
  0x3B, 0xEE, 0xC9, 0x40,
  // "Ũ" (U+0168)
  0x72, 0x83, 0x3C, 0xFD, 0x64, 0x81, 0xEF, 0x17, 0x20, 0x2D, 0x84, 0xA1, 0x07, 0xFC, 0x73, 0x0B,
  0xA0, 0xCB, 0x0E, 0x0D, 0xA0, 0x67, 0x20, 0x1A, 0x82, 0x30, 0x2C, 0xC0, 0xC7, 0x38, 0x16, 0xFA,
  0x48, 0x37, 0xDE, 0xA1, 0x80, 0xE0, 0x00, 0xCA, 0x08, 0x71, 0x03, 0xB0, 0x15, 0xB0, 0x57, 0x10,
  0x6A, 0x0D, 0x50, 0x3B, 0x01, 0x71, 0x0A, 0xA0, 0xA5, 0x06, 0xA0, 0xD7, 0x20, 0xDA, 0x07, 0x50,
  0xAA, 0x0A, 0x71, 0x01, 0xB0, 0x35, 0x0D, 0xA0, 0x77, 0x10, 0x4B, 0x50, 0x1B, 0x04, 0x71, 0x07,
  0xA0, 0xC5, 0x04, 0xB7, 0x20, 0xBA, 0x09, 0x50, 0x7A, 0x0D, 0x72, 0x0E, 0xA0, 0x55, 0x0B, 0xA0,
  0x97, 0x10, 0x2B, 0x02, 0x50, 0xEA, 0x06, 0x71, 0x05, 0xA0, 0xE5, 0x02, 0xB0, 0x37, 0x10, 0x8A,
  0x0B, 0x50, 0x5B, 0x72, 0x0C, 0xA0, 0x85, 0x08, 0xA0, 0xC7, 0x20, 0xEA, 0x04, 0x50, 0xCA, 0x08,
  0x71, 0x03, 0xB0, 0x15, 0xB0, 0x57, 0x10, 0x6A, 0x0D, 0x50, 0x3B, 0x02, 0x71, 0x09, 0xA0, 0xA5,
  0x06, 0xA0, 0xE7, 0x20, 0xCA, 0x07, 0x50, 0x9A, 0x0B, 0x72, 0xB0, 0x35, 0x0C, 0xA0, 0x87, 0x10,
  0x4B, 0x6B, 0x05, 0x71, 0x08, 0xA0, 0xB5, 0x01, 0xB0, 0x37, 0x10, 0xCA, 0x07, 0x50, 0x1B, 0x03,
  0x70, 0x3B, 0x02, 0x6B, 0x05, 0x70, 0xAA, 0x0A, 0x70, 0xDA, 0x0A, 0x60, 0x5B, 0x03, 0x70, 0x8B,
  0x08, 0x40, 0x7B, 0x09, 0x71, 0x01, 0x0E, 0xC0, 0xD0, 0xCC, 0x0B, 0x73, 0x03, 0x0E, 0xF9, 0x09,
  0x75, 0x87, 0x17, 0xCE, 0xFE, 0xC9, 0x37, 0x30,
  // "ũ" (U+0169)
  0x78, 0x33, 0xCF, 0xD6, 0x48, 0x1E, 0xF1, 0x60, 0x2D, 0x84, 0xA1, 0x07, 0xFC, 0x70, 0xBA, 0x0C,
  0xB0, 0xE0, 0xDA, 0x06, 0x60, 0x1A, 0x82, 0x30, 0x2C, 0xC0, 0xC7, 0x81, 0x6F, 0xA4, 0x83, 0x7D,
  0xEA, 0x18, 0x0C, 0x70, 0x05, 0xA0, 0xD6, 0x04, 0xA0, 0xE5, 0x08, 0xA0, 0xA6, 0x07, 0xA0, 0xB5,
  0x0B, 0xA0, 0x76, 0x0A, 0xA0, 0x85, 0x0E, 0xA0, 0x46, 0x0E, 0xA0, 0x44, 0x03, 0xB6, 0x01, 0xB0,
  0x14, 0x06, 0xA0, 0xC6, 0x05, 0xA0, 0xE5, 0x09, 0xA0, 0x96, 0x08, 0xA0, 0xA5, 0x0C, 0xA0, 0x66,
  0x0B, 0xA0, 0x75, 0xB0, 0x36, 0x0E, 0xA0, 0x44, 0x03, 0xB6, 0x02, 0xB0, 0x14, 0x07, 0xA0, 0xC6,
  0x06, 0xA0, 0xD5, 0x0A, 0xA0, 0x86, 0x09, 0xA0, 0xA5, 0x0D, 0xA0, 0x56, 0x0D, 0xA0, 0x74, 0x01,
  0xB0, 0x25, 0x02, 0xB0, 0x34, 0x04, 0xA0, 0xE6, 0x07, 0xB5, 0x07, 0xA0, 0xC6, 0x0E, 0xA0, 0xC5,
  0x08, 0xA0, 0xB5, 0x08, 0xB0, 0x95, 0x09, 0xA0, 0xB4, 0x04, 0xC0, 0x65, 0x08, 0xB0, 0x32, 0x82,
  0x6F, 0xEE, 0xA0, 0x35, 0x04, 0xC0, 0xD0, 0xEA, 0x04, 0x0D, 0xA7, 0x0B, 0xE0, 0x41, 0xA0, 0xC7,
  0x18, 0x68, 0xDF, 0xD9, 0x20, 0x1A, 0x09, 0x60,
  // "Ū" (U+016A)
  0x72, 0x80, 0x5C, 0x0A, 0x74, 0x03, 0xFA, 0x0B, 0x74, 0x06, 0xFA, 0x08, 0x80, 0x98, 0x60, 0x0C,
  0xA0, 0x87, 0x10, 0x3B, 0x01, 0x5B, 0x05, 0x71, 0x06, 0xA0, 0xD5, 0x03, 0xB0, 0x17, 0x10, 0xAA,
  0x0A, 0x50, 0x6A, 0x0D, 0x72, 0x0D, 0xA0, 0x75, 0x0A, 0xA0, 0xA7, 0x10, 0x1B, 0x03, 0x50, 0xDA,
  0x07, 0x71, 0x04, 0xB5, 0x01, 0xB0, 0x47, 0x10, 0x7A, 0x0C, 0x50, 0x4B, 0x72, 0x0B, 0xA0, 0x95,
  0x07, 0xA0, 0xD7, 0x20, 0xEA, 0x05, 0x50, 0xBA, 0x09, 0x71, 0x02, 0xB0, 0x25, 0x0E, 0xA0, 0x67,
  0x10, 0x5A, 0x0E, 0x50, 0x2B, 0x03, 0x71, 0x08, 0xA0, 0xB5, 0x05, 0xB7, 0x20, 0xCA, 0x08, 0x50,
  0x8A, 0x0C, 0x72, 0x0E, 0xA0, 0x45, 0x0C, 0xA0, 0x87, 0x10, 0x3B, 0x01, 0x5B, 0x05, 0x71, 0x06,
  0xA0, 0xD5, 0x03, 0xB0, 0x27, 0x10, 0x9A, 0x0A, 0x50, 0x6A, 0x0E, 0x72, 0x0C, 0xA0, 0x75, 0x09,
  0xA0, 0xB7, 0x2B, 0x03, 0x50, 0xCA, 0x08, 0x71, 0x04, 0xB6, 0xB0, 0x57, 0x10, 0x8A, 0x0B, 0x50,
  0x1B, 0x03, 0x71, 0x0C, 0xA0, 0x75, 0x01, 0xB0, 0x37, 0x03, 0xB0, 0x26, 0xB0, 0x57, 0x0A, 0xA0,
  0xA7, 0x0D, 0xA0, 0xA6, 0x05, 0xB0, 0x37, 0x08, 0xB0, 0x84, 0x07, 0xB0, 0x97, 0x10, 0x10, 0xEC,
  0x0D, 0x0C, 0xC0, 0xB7, 0x30, 0x30, 0xEF, 0x90, 0x97, 0x58, 0x71, 0x7C, 0xEF, 0xEC, 0x93, 0x73,
  // "ū" (U+016B)
  0x68, 0x05, 0xC0, 0xA6, 0x03, 0xFA, 0x0B, 0x60, 0x6F, 0xA0, 0x88, 0x0E, 0x30, 0x05, 0xA0, 0xD6,
  0x04, 0xA0, 0xE3, 0x08, 0xA0, 0xA6, 0x07, 0xA0, 0xB3, 0x0B, 0xA0, 0x76, 0x0A, 0xA0, 0x83, 0x0E,
  0xA0, 0x46, 0x0E, 0xA0, 0x42, 0x03, 0xB6, 0x01, 0xB0, 0x12, 0x06, 0xA0, 0xC6, 0x05, 0xA0, 0xE3,
  0x09, 0xA0, 0x96, 0x08, 0xA0, 0xA3, 0x0C, 0xA0, 0x66, 0x0B, 0xA0, 0x73, 0xB0, 0x36, 0x0E, 0xA0,
  0x42, 0x03, 0xB6, 0x02, 0xB0, 0x12, 0x07, 0xA0, 0xC6, 0x06, 0xA0, 0xD3, 0x0A, 0xA0, 0x86, 0x09,
  0xA0, 0xA3, 0x0D, 0xA0, 0x56, 0x0D, 0xA0, 0x72, 0x01, 0xB0, 0x25, 0x02, 0xB0, 0x32, 0x04, 0xA0,
  0xE6, 0x07, 0xB3, 0x07, 0xA0, 0xC6, 0x0E, 0xA0, 0xC3, 0x08, 0xA0, 0xB5, 0x08, 0xB0, 0x93, 0x09,
  0xA0, 0xB4, 0x04, 0xC0, 0x63, 0x08, 0xB0, 0x32, 0x82, 0x6F, 0xEE, 0xA0, 0x33, 0x04, 0xC0, 0xD0,
  0xEA, 0x04, 0x0D, 0xA5, 0x0B, 0xE0, 0x41, 0xA0, 0xC6, 0x86, 0x8D, 0xFD, 0x92, 0x01, 0xA0, 0x94,
  // "Ŭ" (U+016C)
  0x72, 0x81, 0x37, 0x55, 0x81, 0x67, 0x27, 0x48, 0x17, 0xFB, 0x40, 0x1A, 0x01, 0x74, 0x06, 0xA0,
  0x23, 0x81, 0xBF, 0xB7, 0x50, 0x3A, 0x82, 0xEA, 0xAE, 0xA0, 0x47, 0x60, 0xAE, 0x08, 0x77, 0x18,
  0x47, 0xDF, 0xEB, 0x48, 0x0E, 0x20, 0x0C, 0xA0, 0x87, 0x10, 0x3B, 0x01, 0x5B, 0x05, 0x71, 0x06,
  0xA0, 0xD5, 0x03, 0xB0, 0x17, 0x10, 0xAA, 0x0A, 0x50, 0x6A, 0x0D, 0x72, 0x0D, 0xA0, 0x75, 0x0A,
  0xA0, 0xA7, 0x10, 0x1B, 0x03, 0x50, 0xDA, 0x07, 0x71, 0x04, 0xB5, 0x01, 0xB0, 0x47, 0x10, 0x7A,
  0x0C, 0x50, 0x4B, 0x72, 0x0B, 0xA0, 0x95, 0x07, 0xA0, 0xD7, 0x20, 0xEA, 0x05, 0x50, 0xBA, 0x09,
  0x71, 0x02, 0xB0, 0x25, 0x0E, 0xA0, 0x67, 0x10, 0x5A, 0x0E, 0x50, 0x2B, 0x03, 0x71, 0x08, 0xA0,
  0xB5, 0x05, 0xB7, 0x20, 0xCA, 0x08, 0x50, 0x8A, 0x0C, 0x72, 0x0E, 0xA0, 0x45, 0x0C, 0xA0, 0x87,
  0x10, 0x3B, 0x01, 0x5B, 0x05, 0x71, 0x06, 0xA0, 0xD5, 0x03, 0xB0, 0x27, 0x10, 0x9A, 0x0A, 0x50,
  0x6A, 0x0E, 0x72, 0x0C, 0xA0, 0x75, 0x09, 0xA0, 0xB7, 0x2B, 0x03, 0x50, 0xCA, 0x08, 0x71, 0x04,
  0xB6, 0xB0, 0x57, 0x10, 0x8A, 0x0B, 0x50, 0x1B, 0x03, 0x71, 0x0C, 0xA0, 0x75, 0x01, 0xB0, 0x37,
  0x03, 0xB0, 0x26, 0xB0, 0x57, 0x0A, 0xA0, 0xA7, 0x0D, 0xA0, 0xA6, 0x05, 0xB0, 0x37, 0x08, 0xB0,
  0x84, 0x07, 0xB0, 0x97, 0x10, 0x10, 0xEC, 0x0D, 0x0C, 0xC0, 0xB7, 0x30, 0x30, 0xEF, 0x90, 0x97,
  0x58, 0x71, 0x7C, 0xEF, 0xEC, 0x93, 0x73,
  // "ŭ" (U+016D)
  0x68, 0x13, 0x75, 0x58, 0x16, 0x72, 0x68, 0x17, 0xFB, 0x40, 0x1A, 0x01, 0x60, 0x6A, 0x02, 0x38,
  0x1B, 0xFB, 0x70, 0x3A, 0x82, 0xEA, 0xAE, 0xA0, 0x47, 0x10, 0xAE, 0x08, 0x73, 0x84, 0x7D, 0xFE,
  0xB4, 0x80, 0xC4, 0x00, 0x5A, 0x0D, 0x60, 0x4A, 0x0E, 0x30, 0x8A, 0x0A, 0x60, 0x7A, 0x0B, 0x30,
  0xBA, 0x07, 0x60, 0xAA, 0x08, 0x30, 0xEA, 0x04, 0x60, 0xEA, 0x04, 0x20, 0x3B, 0x60, 0x1B, 0x01,
  0x20, 0x6A, 0x0C, 0x60, 0x5A, 0x0E, 0x30, 0x9A, 0x09, 0x60, 0x8A, 0x0A, 0x30, 0xCA, 0x06, 0x60,
  0xBA, 0x07, 0x3B, 0x03, 0x60, 0xEA, 0x04, 0x20, 0x3B, 0x60, 0x2B, 0x01, 0x20, 0x7A, 0x0C, 0x60,
  0x6A, 0x0D, 0x30, 0xAA, 0x08, 0x60, 0x9A, 0x0A, 0x30, 0xDA, 0x05, 0x60, 0xDA, 0x07, 0x20, 0x1B,
  0x02, 0x50, 0x2B, 0x03, 0x20, 0x4A, 0x0E, 0x60, 0x7B, 0x30, 0x7A, 0x0C, 0x60, 0xEA, 0x0C, 0x30,
  0x8A, 0x0B, 0x50, 0x8B, 0x09, 0x30, 0x9A, 0x0B, 0x40, 0x4C, 0x06, 0x30, 0x8B, 0x03, 0x28, 0x26,
  0xFE, 0xEA, 0x03, 0x30, 0x4C, 0x0D, 0x0E, 0xA0, 0x40, 0xDA, 0x50, 0xBE, 0x04, 0x1A, 0x0C, 0x68,
  0x68, 0xDF, 0xD9, 0x20, 0x1A, 0x09, 0x40,
  // "Ů" (U+016E)
  0x74, 0x84, 0x7D, 0xFE, 0x91, 0x77, 0x10, 0xAA, 0x0D, 0xA0, 0xD0, 0x17, 0x68, 0x74, 0xFE, 0x20,
  0x1B, 0xF7, 0x76, 0x81, 0x7F, 0x83, 0x81, 0x4F, 0xB7, 0x68, 0x17, 0xF8, 0x38, 0x14, 0xFB, 0x76,
  0x87, 0x4F, 0xE2, 0x01, 0xCF, 0x77, 0x70, 0xBA, 0x0E, 0xA0, 0xD0, 0x17, 0x71, 0x84, 0x8D, 0xFE,
  0x91, 0x80, 0xE2, 0x00, 0xCA, 0x08, 0x71, 0x03, 0xB0, 0x15, 0xB0, 0x57, 0x10, 0x6A, 0x0D, 0x50,
  0x3B, 0x01, 0x71, 0x0A, 0xA0, 0xA5, 0x06, 0xA0, 0xD7, 0x20, 0xDA, 0x07, 0x50, 0xAA, 0x0A, 0x71,
  0x01, 0xB0, 0x35, 0x0D, 0xA0, 0x77, 0x10, 0x4B, 0x50, 0x1B, 0x04, 0x71, 0x07, 0xA0, 0xC5, 0x04,
  0xB7, 0x20, 0xBA, 0x09, 0x50, 0x7A, 0x0D, 0x72, 0x0E, 0xA0, 0x55, 0x0B, 0xA0, 0x97, 0x10, 0x2B,
  0x02, 0x50, 0xEA, 0x06, 0x71, 0x05, 0xA0, 0xE5, 0x02, 0xB0, 0x37, 0x10, 0x8A, 0x0B, 0x50, 0x5B,
  0x72, 0x0C, 0xA0, 0x85, 0x08, 0xA0, 0xC7, 0x20, 0xEA, 0x04, 0x50, 0xCA, 0x08, 0x71, 0x03, 0xB0,
  0x15, 0xB0, 0x57, 0x10, 0x6A, 0x0D, 0x50, 0x3B, 0x02, 0x71, 0x09, 0xA0, 0xA5, 0x06, 0xA0, 0xE7,
  0x20, 0xCA, 0x07, 0x50, 0x9A, 0x0B, 0x72, 0xB0, 0x35, 0x0C, 0xA0, 0x87, 0x10, 0x4B, 0x6B, 0x05,
  0x71, 0x08, 0xA0, 0xB5, 0x01, 0xB0, 0x37, 0x10, 0xCA, 0x07, 0x50, 0x1B, 0x03, 0x70, 0x3B, 0x02,
  0x6B, 0x05, 0x70, 0xAA, 0x0A, 0x70, 0xDA, 0x0A, 0x60, 0x5B, 0x03, 0x70, 0x8B, 0x08, 0x40, 0x7B,
  0x09, 0x71, 0x01, 0x0E, 0xC0, 0xD0, 0xCC, 0x0B, 0x73, 0x03, 0x0E, 0xF9, 0x09, 0x75, 0x87, 0x17,
  0xCE, 0xFE, 0xC9, 0x37, 0x30,
  // "ů" (U+016F)
  0x72, 0x84, 0x7D, 0xFE, 0x91, 0x73, 0x0A, 0xA0, 0xDA, 0x0D, 0x01, 0x71, 0x87, 0x4F, 0xE2, 0x01,
  0xBF, 0x77, 0x18, 0x17, 0xF8, 0x38, 0x14, 0xFB, 0x71, 0x81, 0x7F, 0x83, 0x81, 0x4F, 0xB7, 0x18,
  0x74, 0xFE, 0x20, 0x1C, 0xF7, 0x72, 0x0B, 0xA0, 0xEA, 0x0D, 0x01, 0x73, 0x84, 0x8D, 0xFE, 0x91,
  0x80, 0xC3, 0x00, 0x5A, 0x0D, 0x60, 0x4A, 0x0E, 0x30, 0x8A, 0x0A, 0x60, 0x7A, 0x0B, 0x30, 0xBA,
  0x07, 0x60, 0xAA, 0x08, 0x30, 0xEA, 0x04, 0x60, 0xEA, 0x04, 0x20, 0x3B, 0x60, 0x1B, 0x01, 0x20,
  0x6A, 0x0C, 0x60, 0x5A, 0x0E, 0x30, 0x9A, 0x09, 0x60, 0x8A, 0x0A, 0x30, 0xCA, 0x06, 0x60, 0xBA,
  0x07, 0x3B, 0x03, 0x60, 0xEA, 0x04, 0x20, 0x3B, 0x60, 0x2B, 0x01, 0x20, 0x7A, 0x0C, 0x60, 0x6A,
  0x0D, 0x30, 0xAA, 0x08, 0x60, 0x9A, 0x0A, 0x30, 0xDA, 0x05, 0x60, 0xDA, 0x07, 0x20, 0x1B, 0x02,
  0x50, 0x2B, 0x03, 0x20, 0x4A, 0x0E, 0x60, 0x7B, 0x30, 0x7A, 0x0C, 0x60, 0xEA, 0x0C, 0x30, 0x8A,
  0x0B, 0x50, 0x8B, 0x09, 0x30, 0x9A, 0x0B, 0x40, 0x4C, 0x06, 0x30, 0x8B, 0x03, 0x28, 0x26, 0xFE,
  0xEA, 0x03, 0x30, 0x4C, 0x0D, 0x0E, 0xA0, 0x40, 0xDA, 0x50, 0xBE, 0x04, 0x1A, 0x0C, 0x68, 0x68,
  0xDF, 0xD9, 0x20, 0x1A, 0x09, 0x40,
  // "Ű" (U+0170)
  0x76, 0x07, 0xA8, 0x2E, 0x20, 0x4B, 0x05, 0x75, 0x02, 0xB8, 0x25, 0x01, 0xDA, 0x07, 0x76, 0x0D,
  0xA0, 0x52, 0x0A, 0xA0, 0x77, 0x68, 0x2A, 0xFE, 0x42, 0x07, 0xA0, 0x67, 0x68, 0x28, 0xFD, 0x32,
  0x05, 0xA0, 0x57, 0x68, 0x24, 0xFB, 0x12, 0x82, 0x2E, 0xD3, 0x80, 0xE6, 0x00, 0xCA, 0x08, 0x71,
  0x03, 0xB0, 0x17, 0xB0, 0x57, 0x10, 0x6A, 0x0D, 0x70, 0x3B, 0x01, 0x71, 0x0A, 0xA0, 0xA7, 0x06,
  0xA0, 0xD7, 0x20, 0xDA, 0x07, 0x70, 0xAA, 0x0A, 0x71, 0x01, 0xB0, 0x37, 0x0D, 0xA0, 0x77, 0x10,
  0x4B, 0x70, 0x1B, 0x04, 0x71, 0x07, 0xA0, 0xC7, 0x04, 0xB7, 0x20, 0xBA, 0x09, 0x70, 0x7A, 0x0D,
  0x72, 0x0E, 0xA0, 0x57, 0x0B, 0xA0, 0x97, 0x10, 0x2B, 0x02, 0x70, 0xEA, 0x06, 0x71, 0x05, 0xA0,
  0xE7, 0x02, 0xB0, 0x37, 0x10, 0x8A, 0x0B, 0x70, 0x5B, 0x72, 0x0C, 0xA0, 0x87, 0x08, 0xA0, 0xC7,
  0x20, 0xEA, 0x04, 0x70, 0xCA, 0x08, 0x71, 0x03, 0xB0, 0x17, 0xB0, 0x57, 0x10, 0x6A, 0x0D, 0x70,
  0x3B, 0x02, 0x71, 0x09, 0xA0, 0xA7, 0x06, 0xA0, 0xE7, 0x20, 0xCA, 0x07, 0x70, 0x9A, 0x0B, 0x72,
  0xB0, 0x37, 0x0C, 0xA0, 0x87, 0x10, 0x4B, 0x71, 0xB0, 0x57, 0x10, 0x8A, 0x0B, 0x70, 0x1B, 0x03,
  0x71, 0x0C, 0xA0, 0x77, 0x01, 0xB0, 0x37, 0x03, 0xB0, 0x27, 0x1B, 0x05, 0x70, 0xAA, 0x0A, 0x72,
  0x0D, 0xA0, 0xA6, 0x05, 0xB0, 0x37, 0x20, 0x8B, 0x08, 0x40, 0x7B, 0x09, 0x73, 0x01, 0x0E, 0xC0,
  0xD0, 0xCC, 0x0B, 0x75, 0x03, 0x0E, 0xF9, 0x09, 0x77, 0x87, 0x17, 0xCE, 0xFE, 0xC9, 0x37, 0x50,
  // "ű" (U+0171)
  0x73, 0x07, 0xA8, 0x2E, 0x20, 0x4B, 0x05, 0x72, 0x02, 0xB8, 0x25, 0x01, 0xDA, 0x07, 0x73, 0x0D,
  0xA0, 0x52, 0x0A, 0xA0, 0x77, 0x38, 0x2A, 0xFE, 0x42, 0x07, 0xA0, 0x67, 0x38, 0x28, 0xFD, 0x32,
  0x05, 0xA0, 0x57, 0x38, 0x24, 0xFB, 0x12, 0x82, 0x2E, 0xD3, 0x80, 0xD6, 0x00, 0x5A, 0x0D, 0x60,
  0x4A, 0x0E, 0x70, 0x8A, 0x0A, 0x60, 0x7A, 0x0B, 0x70, 0xBA, 0x07, 0x60, 0xAA, 0x08, 0x70, 0xEA,
  0x04, 0x60, 0xEA, 0x04, 0x60, 0x3B, 0x60, 0x1B, 0x01, 0x60, 0x6A, 0x0C, 0x60, 0x5A, 0x0E, 0x70,
  0x9A, 0x09, 0x60, 0x8A, 0x0A, 0x70, 0xCA, 0x06, 0x60, 0xBA, 0x07, 0x7B, 0x03, 0x60, 0xEA, 0x04,
  0x60, 0x3B, 0x60, 0x2B, 0x01, 0x60, 0x7A, 0x0C, 0x60, 0x6A, 0x0D, 0x70, 0xAA, 0x08, 0x60, 0x9A,
  0x0A, 0x70, 0xDA, 0x05, 0x60, 0xDA, 0x07, 0x60, 0x1B, 0x02, 0x50, 0x2B, 0x03, 0x60, 0x4A, 0x0E,
  0x60, 0x7B, 0x70, 0x7A, 0x0C, 0x60, 0xEA, 0x0C, 0x70, 0x8A, 0x0B, 0x50, 0x8B, 0x09, 0x70, 0x9A,
  0x0B, 0x40, 0x4C, 0x06, 0x70, 0x8B, 0x03, 0x28, 0x26, 0xFE, 0xEA, 0x03, 0x70, 0x4C, 0x0D, 0x0E,
  0xA0, 0x40, 0xDA, 0x72, 0x0B, 0xE0, 0x41, 0xA0, 0xC7, 0x38, 0x68, 0xDF, 0xD9, 0x20, 0x1A, 0x09,
  0x71,
  // "Ų" (U+0172)
  0x50, 0xCA, 0x08, 0x71, 0x03, 0xB0, 0x15, 0xB0, 0x57, 0x10, 0x6A, 0x0D, 0x50, 0x3B, 0x01, 0x71,
  0x0A, 0xA0, 0xA5, 0x06, 0xA0, 0xD7, 0x20, 0xDA, 0x07, 0x50, 0xAA, 0x0A, 0x71, 0x01, 0xB0, 0x35,
  0x0D, 0xA0, 0x77, 0x10, 0x4B, 0x50, 0x1B, 0x04, 0x71, 0x07, 0xA0, 0xC5, 0x04, 0xB7, 0x20, 0xBA,
  0x09, 0x50, 0x7A, 0x0D, 0x72, 0x0E, 0xA0, 0x55, 0x0B, 0xA0, 0x97, 0x10, 0x2B, 0x02, 0x50, 0xEA,
  0x06, 0x71, 0x05, 0xA0, 0xE5, 0x02, 0xB0, 0x37, 0x10, 0x8A, 0x0B, 0x50, 0x5B, 0x72, 0x0C, 0xA0,
  0x85, 0x08, 0xA0, 0xC7, 0x20, 0xEA, 0x04, 0x50, 0xCA, 0x08, 0x71, 0x03, 0xB0, 0x15, 0xB0, 0x57,
  0x10, 0x6A, 0x0D, 0x50, 0x3B, 0x02, 0x71, 0x09, 0xA0, 0xA5, 0x06, 0xA0, 0xE7, 0x20, 0xCA, 0x07,
  0x50, 0x9A, 0x0B, 0x72, 0xB0, 0x35, 0x0C, 0xA0, 0x87, 0x10, 0x4B, 0x6B, 0x05, 0x71, 0x08, 0xA0,
  0xB5, 0x01, 0xB0, 0x37, 0x10, 0xCA, 0x07, 0x50, 0x1B, 0x03, 0x70, 0x3B, 0x02, 0x6B, 0x05, 0x70,
  0xAA, 0x0A, 0x70, 0xDA, 0x0A, 0x60, 0x5B, 0x03, 0x70, 0x8B, 0x08, 0x40, 0x7B, 0x09, 0x71, 0x01,
  0x0E, 0xC0, 0xD0, 0xCC, 0x0B, 0x73, 0x03, 0x0E, 0xF9, 0x09, 0x75, 0x87, 0x17, 0xCE, 0xFE, 0xC9,
  0x37, 0x73, 0x82, 0x6F, 0xC1, 0x77, 0x38, 0x18, 0xFC, 0x77, 0x48, 0x27, 0xFD, 0x17, 0x73, 0x02,
  0xA0, 0x67, 0x74, 0x09, 0xA0, 0x17, 0x74, 0x0B, 0xA0, 0x27, 0x74, 0x0B, 0xA8, 0x1E, 0xCA, 0x77,
  0x20, 0x6C, 0x09, 0x77, 0x38, 0x37, 0xDF, 0xD5, 0x75,
  // "ų" (U+0173)
  0x30, 0x5A, 0x0D, 0x60, 0x4A, 0x0E, 0x30, 0x8A, 0x0A, 0x60, 0x7A, 0x0B, 0x30, 0xBA, 0x07, 0x60,
  0xAA, 0x08, 0x30, 0xEA, 0x04, 0x60, 0xEA, 0x04, 0x20, 0x3B, 0x60, 0x1B, 0x01, 0x20, 0x6A, 0x0C,
  0x60, 0x5A, 0x0E, 0x30, 0x9A, 0x09, 0x60, 0x8A, 0x0A, 0x30, 0xCA, 0x06, 0x60, 0xBA, 0x07, 0x3B,
  0x03, 0x60, 0xEA, 0x04, 0x20, 0x3B, 0x60, 0x2B, 0x01, 0x20, 0x7A, 0x0C, 0x60, 0x6A, 0x0D, 0x30,
  0xAA, 0x08, 0x60, 0x9A, 0x0A, 0x30, 0xDA, 0x05, 0x60, 0xDA, 0x07, 0x20, 0x1B, 0x02, 0x50, 0x2B,
  0x03, 0x20, 0x4A, 0x0E, 0x60, 0x7B, 0x30, 0x7A, 0x0C, 0x60, 0xEA, 0x0C, 0x30, 0x8A, 0x0B, 0x50,
  0x8B, 0x09, 0x30, 0x9A, 0x0B, 0x40, 0x4C, 0x06, 0x30, 0x8B, 0x03, 0x28, 0x26, 0xFE, 0xEA, 0x03,
  0x30, 0x4C, 0x0D, 0x0E, 0xA0, 0x40, 0xDA, 0x50, 0xBE, 0x04, 0x1A, 0x0C, 0x68, 0x68, 0xDF, 0xD9,
  0x20, 0x1A, 0x09, 0x76, 0x82, 0x6F, 0xC1, 0x75, 0x81, 0x8F, 0xC7, 0x68, 0x27, 0xFD, 0x17, 0x50,
  0x2A, 0x06, 0x76, 0x09, 0xA0, 0x17, 0x60, 0xBA, 0x02, 0x76, 0x0B, 0xA8, 0x1E, 0xCA, 0x74, 0x06,
  0xC0, 0x97, 0x58, 0x37, 0xDF, 0xD5, 0x50,
  // "Ŵ" (U+0174)
  0x77, 0x82, 0x47, 0x74, 0x77, 0x73, 0x02, 0x0E, 0xA0, 0xC7, 0x77, 0x30, 0xCC, 0x03, 0x77, 0x71,
  0x0A, 0xA0, 0x9A, 0x09, 0x77, 0x70, 0x8A, 0x81, 0x50, 0xAA, 0x01, 0x77, 0x58, 0x27, 0xFE, 0x42,
  0x82, 0x1E, 0xF7, 0x77, 0x48, 0x24, 0xFD, 0x34, 0x81, 0x4F, 0xE8, 0x0F, 0x70, 0x04, 0xA0, 0xE7,
  0x20, 0xEA, 0x04, 0x71, 0x0D, 0xA0, 0x90, 0x4A, 0x0E, 0x71, 0x06, 0xB0, 0x47, 0x03, 0xB0, 0x20,
  0x4A, 0x0E, 0x71, 0x0C, 0xB0, 0x47, 0x09, 0xA8, 0x1C, 0x04, 0xA0, 0xE7, 0x03, 0xC0, 0x46, 0x01,
  0x0E, 0xA8, 0x15, 0x04, 0xA0, 0xE7, 0x09, 0xC0, 0x46, 0x06, 0xA0, 0xE2, 0x04, 0xA0, 0xD6, 0x01,
  0x0E, 0xC0, 0x46, 0x0C, 0xA0, 0x82, 0x04, 0xA0, 0xD6, 0x06, 0xA0, 0xCA, 0x03, 0x50, 0x3B, 0x02,
  0x20, 0x4A, 0x0D, 0x68, 0x2C, 0xFE, 0x7A, 0x03, 0x50, 0x9A, 0x0B, 0x30, 0x4A, 0x0D, 0x50, 0x3A,
  0x09, 0x07, 0xA0, 0x35, 0x0E, 0xA0, 0x53, 0x05, 0xA0, 0xD5, 0x0A, 0xA0, 0x30, 0x7A, 0x03, 0x40,
  0x6A, 0x0E, 0x40, 0x5A, 0x0D, 0x40, 0x1A, 0x81, 0xD0, 0x7A, 0x03, 0x40, 0xCA, 0x08, 0x40, 0x5A,
  0x0C, 0x40, 0x7A, 0x81, 0x70, 0x8A, 0x03, 0x30, 0x3B, 0x01, 0x40, 0x5A, 0x0C, 0x40, 0xDA, 0x81,
  0x10, 0x8A, 0x03, 0x30, 0x9A, 0x0B, 0x50, 0x5A, 0x0C, 0x30, 0x4A, 0x0A, 0x20, 0x8A, 0x02, 0x30,
  0xEA, 0x04, 0x50, 0x5A, 0x0C, 0x30, 0xAA, 0x03, 0x20, 0x8A, 0x02, 0x20, 0x5A, 0x0D, 0x60, 0x5A,
  0x0C, 0x20, 0x1A, 0x0C, 0x30, 0x9A, 0x02, 0x20, 0xCA, 0x07, 0x60, 0x5A, 0x0C, 0x20, 0x7A, 0x06,
  0x30, 0x9A, 0x81, 0x20, 0x2B, 0x01, 0x60, 0x5A, 0x0B, 0x28, 0x1D, 0xFE, 0x40, 0x9A, 0x81, 0x20,
  0x8A, 0x0A, 0x70, 0x5A, 0x81, 0xB0, 0x4A, 0x09, 0x40, 0x9A, 0x81, 0x20, 0xEA, 0x04, 0x70, 0x5A,
  0x81, 0xB0, 0xAA, 0x03, 0x40, 0x9A, 0x02, 0x05, 0xA0, 0xD7, 0x10, 0x5A, 0x0A, 0x01, 0xA0, 0xC5,
  0x0A, 0xA0, 0x10, 0xAA, 0x07, 0x71, 0x05, 0xA0, 0xA0, 0x7A, 0x06, 0x50, 0xAA, 0x02, 0xB0, 0x17,
  0x10, 0x5A, 0x82, 0x9C, 0xFE, 0x60, 0xAA, 0x06, 0xA0, 0x97, 0x20, 0x5A, 0x0B, 0xA0, 0x96, 0x0A,
  0xA0, 0xBA, 0x03, 0x72, 0x06, 0xD0, 0x26, 0x0B, 0xC0, 0xC7, 0x30, 0x6C, 0x0C, 0x70, 0xBC, 0x06,
  0x73, 0x06, 0xC0, 0x57, 0x0B, 0xB0, 0xE7, 0x40, 0x6B, 0x0E, 0x71, 0x0B, 0xB0, 0x97, 0x40, 0x6B,
  0x08, 0x71, 0x0B, 0xB0, 0x37, 0x40,
  // "ŵ" (U+0175)
  0x75, 0x82, 0x47, 0x74, 0x77, 0x50, 0x20, 0xEA, 0x0C, 0x77, 0x50, 0xCC, 0x03, 0x77, 0x30, 0xAA,
  0x09, 0xA0, 0x97, 0x72, 0x08, 0xA8, 0x15, 0x0A, 0xA0, 0x17, 0x78, 0x27, 0xFE, 0x42, 0x82, 0x1E,
  0xF7, 0x76, 0x82, 0x4F, 0xD3, 0x48, 0x14, 0xFE, 0x80, 0xE2, 0x00, 0x8A, 0x09, 0x60, 0xEA, 0x0C,
  0x60, 0xCA, 0x07, 0x08, 0xA0, 0x85, 0x06, 0xB0, 0xC5, 0x02, 0xB0, 0x10, 0x8A, 0x08, 0x50, 0xCB,
  0x0C, 0x50, 0x8A, 0x81, 0xA0, 0x8A, 0x08, 0x40, 0x3C, 0x0C, 0x50, 0xEA, 0x81, 0x30, 0x8A, 0x08,
  0x48, 0x49, 0xFE, 0xDF, 0xB4, 0x05, 0xA0, 0xD2, 0x08, 0xA0, 0x84, 0x84, 0xEF, 0xAD, 0xFB, 0x40,
  0xBA, 0x06, 0x20, 0x8A, 0x07, 0x30, 0x6A, 0x82, 0x4D, 0xFB, 0x30, 0x2A, 0x0E, 0x01, 0x20, 0x8A,
  0x07, 0x38, 0x5C, 0xFD, 0x0E, 0xFB, 0x30, 0x8A, 0x09, 0x30, 0x8A, 0x07, 0x20, 0x3A, 0x83, 0x70,
  0xEF, 0xB3, 0x0E, 0xA0, 0x33, 0x08, 0xA0, 0x72, 0x09, 0xA8, 0x31, 0x0E, 0xFB, 0x20, 0x5A, 0x0C,
  0x40, 0x8A, 0x07, 0x28, 0x1E, 0xFB, 0x28, 0x1E, 0xFB, 0x20, 0xBA, 0x06, 0x40, 0x8A, 0x81, 0x60,
  0x6A, 0x04, 0x2A, 0x81, 0xB0, 0x1A, 0x0E, 0x50, 0x8A, 0x83, 0x60, 0xCF, 0xD3, 0xA8, 0x1B, 0x07,
  0xA0, 0x85, 0x08, 0xA0, 0x60, 0x3A, 0x08, 0x3A, 0x81, 0xA0, 0xDA, 0x02, 0x50, 0x8A, 0x05, 0x09,
  0xA0, 0x23, 0xA0, 0xA0, 0x3A, 0x0B, 0x60, 0x8A, 0x82, 0x5E, 0xFB, 0x4A, 0x00, 0x9A, 0x05, 0x60,
  0x8A, 0x09, 0xA0, 0x54, 0xA8, 0x29, 0xEF, 0xE7, 0x08, 0xA8, 0x1D, 0xFE, 0x5A, 0x0C, 0xA0, 0x87,
  0x08, 0xC0, 0x84, 0x01, 0xD0, 0x17, 0x08, 0xC0, 0x24, 0x01, 0xC0, 0xB7, 0x10, 0x8B, 0x0B, 0x50,
  0x1C, 0x04, 0x71, 0x08, 0xB0, 0x55, 0x01, 0xB0, 0xD7, 0x20,
  // "Ŷ" (U+0176)
  0x71, 0x82, 0x47, 0x74, 0x75, 0x02, 0x0E, 0xA0, 0xC7, 0x50, 0xCC, 0x03, 0x73, 0x0A, 0xA0, 0x9A,
  0x09, 0x72, 0x08, 0xA8, 0x15, 0x0A, 0xA0, 0x17, 0x82, 0x7F, 0xE4, 0x28, 0x21, 0xEF, 0x76, 0x82,
  0x4F, 0xD3, 0x48, 0x14, 0xFE, 0x80, 0xC1, 0x00, 0x6A, 0x0E, 0x71, 0x04, 0xB0, 0x04, 0xB7, 0x10,
  0xCA, 0x81, 0xB0, 0x2B, 0x02, 0x60, 0x5B, 0x02, 0x2B, 0x04, 0x60, 0xDA, 0x09, 0x30, 0xDA, 0x06,
  0x50, 0x6A, 0x0E, 0x01, 0x30, 0xAA, 0x08, 0x50, 0xDA, 0x07, 0x40, 0x8A, 0x0A, 0x40, 0x7A, 0x0D,
  0x50, 0x6A, 0x0C, 0x30, 0x10, 0xEA, 0x05, 0x50, 0x4A, 0x0E, 0x30, 0x8A, 0x0C, 0x60, 0x1B, 0x20,
  0x10, 0xEA, 0x03, 0x70, 0xEA, 0x81, 0x20, 0x9A, 0x0A, 0x71, 0x0C, 0xA0, 0x40, 0x2B, 0x02, 0x71,
  0x0A, 0xA0, 0x60, 0xAA, 0x08, 0x72, 0x08, 0xA0, 0xBA, 0x0E, 0x73, 0x05, 0xD0, 0x67, 0x30, 0x3C,
  0x0C, 0x74, 0x01, 0xC0, 0x47, 0x50, 0xEA, 0x0B, 0x76, 0x0E, 0xA0, 0x57, 0x50, 0x2B, 0x02, 0x75,
  0x05, 0xA0, 0xE7, 0x60, 0x9A, 0x0B, 0x76, 0x0C, 0xA0, 0x87, 0x6B, 0x04, 0x75, 0x03, 0xB0, 0x17,
  0x50, 0x6A, 0x0D, 0x76, 0x09, 0xA0, 0xA7, 0x60, 0xDA, 0x07, 0x76, 0xB0, 0x47, 0x50,
  // "ŷ" (U+0177)
  0x76, 0x82, 0x47, 0x74, 0x77, 0x20, 0x20, 0xEA, 0x0C, 0x77, 0x20, 0xCC, 0x03, 0x77, 0x0A, 0xA0,
  0x9A, 0x09, 0x76, 0x08, 0xA8, 0x15, 0x0A, 0xA0, 0x17, 0x48, 0x27, 0xFE, 0x42, 0x82, 0x1E, 0xF7,
  0x73, 0x82, 0x4F, 0xD3, 0x48, 0x14, 0xFE, 0x80, 0xD6, 0x00, 0x9A, 0x09, 0x70, 0x6A, 0x0D, 0x60,
  0x8A, 0x0A, 0x70, 0xDA, 0x06, 0x60, 0x7A, 0x0A, 0x60, 0x5A, 0x0E, 0x70, 0x6A, 0x0B, 0x60, 0xCA,
  0x07, 0x70, 0x5A, 0x0B, 0x50, 0x3A, 0x0E, 0x01, 0x70, 0x4A, 0x0C, 0x50, 0xAA, 0x08, 0x71, 0x03,
  0xA0, 0xD4, 0x02, 0xB0, 0x17, 0x10, 0x2A, 0x0D, 0x40, 0x9A, 0x09, 0x72, 0x01, 0xA0, 0xE3, 0x01,
  0xB0, 0x27, 0x3B, 0x30, 0x7A, 0x0A, 0x74, 0xB3, 0x0E, 0xA0, 0x37, 0x40, 0xEA, 0x20, 0x6A, 0x0B,
  0x75, 0x0D, 0xA8, 0x11, 0x0D, 0xA0, 0x37, 0x50, 0xCA, 0x01, 0x04, 0xA0, 0xC7, 0x60, 0xBA, 0x01,
  0x0A, 0xA0, 0x47, 0x60, 0xAA, 0x03, 0xA0, 0xC7, 0x70, 0x9A, 0x08, 0xA0, 0x57, 0x70, 0x8A, 0x81,
  0xEF, 0xD7, 0x71, 0x07, 0xC0, 0x67, 0x71, 0x06, 0xB0, 0xE7, 0x72, 0x05, 0xB0, 0x77, 0x72, 0x05,
  0xA0, 0xE0, 0x17, 0x72, 0x0B, 0xA0, 0x87, 0x72, 0x03, 0xB0, 0x17, 0x72, 0x0A, 0xA0, 0x97, 0x72,
  0x03, 0xB0, 0x27, 0x72, 0x0C, 0xA0, 0x97, 0x72, 0x0A, 0xA0, 0xE0, 0x17, 0x58, 0x18, 0xDC, 0xC0,
  0x47, 0x60, 0xAD, 0x06, 0x77, 0x84, 0x8E, 0xFE, 0xA3, 0x77, 0x10,
  // "Ÿ" (U+0178)
  0x58, 0x19, 0xEA, 0x38, 0x25, 0xED, 0x16, 0x04, 0xA0, 0xE3, 0x0E, 0xA0, 0x46, 0x07, 0xA0, 0xC2,
  0x02, 0xB0, 0x26, 0x82, 0x3E, 0xD3, 0x38, 0x1B, 0xE7, 0x80, 0xE2, 0x00, 0x6A, 0x0E, 0x71, 0x04,
  0xB0, 0x04, 0xB7, 0x10, 0xCA, 0x81, 0xB0, 0x2B, 0x02, 0x60, 0x5B, 0x02, 0x2B, 0x04, 0x60, 0xDA,
  0x09, 0x30, 0xDA, 0x06, 0x50, 0x6A, 0x0E, 0x01, 0x30, 0xAA, 0x08, 0x50, 0xDA, 0x07, 0x40, 0x8A,
  0x0A, 0x40, 0x7A, 0x0D, 0x50, 0x6A, 0x0C, 0x30, 0x10, 0xEA, 0x05, 0x50, 0x4A, 0x0E, 0x30, 0x8A,
  0x0C, 0x60, 0x1B, 0x20, 0x10, 0xEA, 0x03, 0x70, 0xEA, 0x81, 0x20, 0x9A, 0x0A, 0x71, 0x0C, 0xA0,
  0x40, 0x2B, 0x02, 0x71, 0x0A, 0xA0, 0x60, 0xAA, 0x08, 0x72, 0x08, 0xA0, 0xBA, 0x0E, 0x73, 0x05,
  0xD0, 0x67, 0x30, 0x3C, 0x0C, 0x74, 0x01, 0xC0, 0x47, 0x50, 0xEA, 0x0B, 0x76, 0x0E, 0xA0, 0x57,
  0x50, 0x2B, 0x02, 0x75, 0x05, 0xA0, 0xE7, 0x60, 0x9A, 0x0B, 0x76, 0x0C, 0xA0, 0x87, 0x6B, 0x04,
  0x75, 0x03, 0xB0, 0x17, 0x50, 0x6A, 0x0D, 0x76, 0x09, 0xA0, 0xA7, 0x60, 0xDA, 0x07, 0x76, 0xB0,
  0x47, 0x50,
  // "Ź" (U+0179)
  0x77, 0x18, 0x31, 0x77, 0x75, 0x77, 0x10, 0xAB, 0x04, 0x77, 0x04, 0xB0, 0x57, 0x70, 0x10, 0xEA,
  0x06, 0x77, 0x10, 0xBA, 0x06, 0x77, 0x10, 0x9A, 0x05, 0x77, 0x18, 0x24, 0xFE, 0x48, 0x0D, 0x70,
  0x01, 0xFD, 0x0D, 0x60, 0x4F, 0xD0, 0xB6, 0x06, 0x80, 0x4C, 0x0D, 0xB0, 0x77, 0x71, 0x0D, 0xA0,
  0xE7, 0x71, 0x07, 0xB0, 0x57, 0x70, 0x10, 0xEA, 0x0B, 0x77, 0x10, 0xAB, 0x02, 0x77, 0x04, 0xB0,
  0x87, 0x71, 0x0D, 0xA0, 0xD7, 0x71, 0x07, 0xB0, 0x47, 0x70, 0x2B, 0x0A, 0x77, 0x10, 0xBA, 0x0E,
  0x02, 0x77, 0x05, 0xB0, 0x77, 0x71, 0x0D, 0xA0, 0xD7, 0x71, 0x08, 0xB0, 0x47, 0x70, 0x2B, 0x0A,
  0x77, 0x10, 0xBA, 0x0E, 0x01, 0x77, 0x05, 0xB0, 0x67, 0x71, 0x0D, 0xA0, 0xC7, 0x71, 0x08, 0xB0,
  0x37, 0x70, 0x2B, 0x09, 0x77, 0x10, 0xBA, 0x0E, 0x01, 0x77, 0x05, 0xB0, 0x67, 0x70, 0x10, 0xEA,
  0x0C, 0x77, 0x10, 0x9B, 0x02, 0x77, 0x03, 0xB0, 0x87, 0x71, 0x0B, 0xB8, 0x05, 0xC0, 0x96, 0x0E,
  0xFD, 0x09, 0x50, 0x2F, 0xE0, 0x65,
  // "ź" (U+017A)
  0x76, 0x83, 0x17, 0x77, 0x57, 0x60, 0xAB, 0x04, 0x75, 0x04, 0xB0, 0x57, 0x50, 0x10, 0xEA, 0x06,
  0x76, 0x0B, 0xA0, 0x67, 0x60, 0x9A, 0x05, 0x76, 0x82, 0x4F, 0xE4, 0x80, 0xD2, 0x00, 0x4F, 0xA0,
  0xE7, 0x07, 0xFA, 0x0B, 0x70, 0x88, 0x02, 0xCB, 0x06, 0x76, 0x08, 0xA0, 0xD7, 0x60, 0x2B, 0x03,
  0x76, 0x0B, 0xA0, 0x97, 0x60, 0x6A, 0x0E, 0x01, 0x75, 0x01, 0x0E, 0xA0, 0x57, 0x60, 0xAA, 0x0B,
  0x76, 0x04, 0xB0, 0x27, 0x60, 0xDA, 0x07, 0x76, 0x08, 0xA0, 0xD7, 0x60, 0x2B, 0x03, 0x76, 0x0C,
  0xA0, 0x97, 0x60, 0x6A, 0x0E, 0x01, 0x75, 0x01, 0x0E, 0xA0, 0x57, 0x60, 0xAA, 0x0B, 0x76, 0x04,
  0xB0, 0x27, 0x60, 0xDA, 0x07, 0x76, 0x08, 0xB8, 0x03, 0xC0, 0x36, 0x0D, 0xFB, 0x02, 0x50, 0x1F,
  0xB0, 0xE6,
  // "Ż" (U+017B)
  0x75, 0x82, 0x2C, 0xE8, 0x77, 0x20, 0xAA, 0x0E, 0x77, 0x20, 0xDA, 0x0C, 0x77, 0x28, 0x27, 0xEC,
  0x28, 0x09, 0x82, 0x00, 0x1F, 0xD0, 0xD6, 0x04, 0xFD, 0x0B, 0x60, 0x68, 0x04, 0xC0, 0xDB, 0x07,
  0x77, 0x10, 0xDA, 0x0E, 0x77, 0x10, 0x7B, 0x05, 0x77, 0x01, 0x0E, 0xA0, 0xB7, 0x71, 0x0A, 0xB0,
  0x27, 0x70, 0x4B, 0x08, 0x77, 0x10, 0xDA, 0x0D, 0x77, 0x10, 0x7B, 0x04, 0x77, 0x02, 0xB0, 0xA7,
  0x71, 0x0B, 0xA0, 0xE0, 0x27, 0x70, 0x5B, 0x07, 0x77, 0x10, 0xDA, 0x0D, 0x77, 0x10, 0x8B, 0x04,
  0x77, 0x02, 0xB0, 0xA7, 0x71, 0x0B, 0xA0, 0xE0, 0x17, 0x70, 0x5B, 0x06, 0x77, 0x10, 0xDA, 0x0C,
  0x77, 0x10, 0x8B, 0x03, 0x77, 0x02, 0xB0, 0x97, 0x71, 0x0B, 0xA0, 0xE0, 0x17, 0x70, 0x5B, 0x06,
  0x77, 0x01, 0x0E, 0xA0, 0xC7, 0x71, 0x09, 0xB0, 0x27, 0x70, 0x3B, 0x08, 0x77, 0x10, 0xBB, 0x80,
  0x5C, 0x09, 0x60, 0xEF, 0xD0, 0x95, 0x02, 0xFE, 0x06, 0x50,
  // "ż" (U+017C)
  0x73, 0x82, 0x2C, 0xE8, 0x75, 0x0A, 0xA0, 0xE7, 0x50, 0xDA, 0x0C, 0x75, 0x82, 0x7E, 0xC2, 0x80,
  0xE3, 0x00, 0x4F, 0xA0, 0xE5, 0x07, 0xFA, 0x0B, 0x50, 0x88, 0x02, 0xCB, 0x06, 0x74, 0x08, 0xA0,
  0xD7, 0x40, 0x2B, 0x03, 0x74, 0x0B, 0xA0, 0x97, 0x40, 0x6A, 0x0E, 0x01, 0x73, 0x01, 0x0E, 0xA0,
  0x57, 0x40, 0xAA, 0x0B, 0x74, 0x04, 0xB0, 0x27, 0x40, 0xDA, 0x07, 0x74, 0x08, 0xA0, 0xD7, 0x40,
  0x2B, 0x03, 0x74, 0x0C, 0xA0, 0x97, 0x40, 0x6A, 0x0E, 0x01, 0x73, 0x01, 0x0E, 0xA0, 0x57, 0x40,
  0xAA, 0x0B, 0x74, 0x04, 0xB0, 0x27, 0x40, 0xDA, 0x07, 0x74, 0x08, 0xB8, 0x03, 0xC0, 0x34, 0x0D,
  0xFB, 0x02, 0x30, 0x1F, 0xB0, 0xE4,
  // "Ž" (U+017D)
  0x72, 0x81, 0x17, 0x66, 0x81, 0x67, 0x27, 0x38, 0x1E, 0xF7, 0x38, 0x21, 0xBF, 0xB7, 0x40, 0x7A,
  0x84, 0x20, 0x1D, 0xFC, 0x75, 0x01, 0xA8, 0x4B, 0x1D, 0xFD, 0x17, 0x60, 0x9A, 0x82, 0xEF, 0xE3,
  0x77, 0x03, 0xC0, 0x57, 0x72, 0x0D, 0xA0, 0x98, 0x0E, 0x10, 0x01, 0xFD, 0x0D, 0x70, 0x4F, 0xD0,
  0xB7, 0x06, 0x80, 0x4C, 0x0D, 0xB0, 0x77, 0x72, 0x0D, 0xA0, 0xE7, 0x72, 0x07, 0xB0, 0x57, 0x71,
  0x01, 0x0E, 0xA0, 0xB7, 0x72, 0x0A, 0xB0, 0x27, 0x71, 0x04, 0xB0, 0x87, 0x72, 0x0D, 0xA0, 0xD7,
  0x72, 0x07, 0xB0, 0x47, 0x71, 0x02, 0xB0, 0xA7, 0x72, 0x0B, 0xA0, 0xE0, 0x27, 0x71, 0x05, 0xB0,
  0x77, 0x72, 0x0D, 0xA0, 0xD7, 0x72, 0x08, 0xB0, 0x47, 0x71, 0x02, 0xB0, 0xA7, 0x72, 0x0B, 0xA0,
  0xE0, 0x17, 0x71, 0x05, 0xB0, 0x67, 0x72, 0x0D, 0xA0, 0xC7, 0x72, 0x08, 0xB0, 0x37, 0x71, 0x02,
  0xB0, 0x97, 0x72, 0x0B, 0xA0, 0xE0, 0x17, 0x71, 0x05, 0xB0, 0x67, 0x71, 0x01, 0x0E, 0xA0, 0xC7,
  0x72, 0x09, 0xB0, 0x27, 0x71, 0x03, 0xB0, 0x87, 0x72, 0x0B, 0xB8, 0x05, 0xC0, 0x97, 0x0E, 0xFD,
  0x09, 0x60, 0x2F, 0xE0, 0x66,
  // "ž" (U+017E)
  0x68, 0x11, 0x76, 0x68, 0x16, 0x72, 0x78, 0x1E, 0xF7, 0x38, 0x21, 0xBF, 0xB7, 0x10, 0x7A, 0x84,
  0x20, 0x1D, 0xFC, 0x72, 0x01, 0xA8, 0x4B, 0x1D, 0xFD, 0x17, 0x30, 0x9A, 0x82, 0xEF, 0xE3, 0x74,
  0x03, 0xC0, 0x57, 0x60, 0xDA, 0x09, 0x80, 0xD2, 0x00, 0x4F, 0xA0, 0xE7, 0x07, 0xFA, 0x0B, 0x70,
  0x88, 0x02, 0xCB, 0x06, 0x76, 0x08, 0xA0, 0xD7, 0x60, 0x2B, 0x03, 0x76, 0x0B, 0xA0, 0x97, 0x60,
  0x6A, 0x0E, 0x01, 0x75, 0x01, 0x0E, 0xA0, 0x57, 0x60, 0xAA, 0x0B, 0x76, 0x04, 0xB0, 0x27, 0x60,
  0xDA, 0x07, 0x76, 0x08, 0xA0, 0xD7, 0x60, 0x2B, 0x03, 0x76, 0x0C, 0xA0, 0x97, 0x60, 0x6A, 0x0E,
  0x01, 0x75, 0x01, 0x0E, 0xA0, 0x57, 0x60, 0xAA, 0x0B, 0x76, 0x04, 0xB0, 0x27, 0x60, 0xDA, 0x07,
  0x76, 0x08, 0xB8, 0x03, 0xC0, 0x36, 0x0D, 0xFB, 0x02, 0x50, 0x1F, 0xB0, 0xE6,
  // "ſ" (U+017F)
  0x77, 0x85, 0x17, 0xAB, 0xA7, 0x17, 0x60, 0x30, 0xED, 0x05, 0x76, 0x0E, 0xD0, 0xE7, 0x60, 0x7A,
  0x83, 0xE4, 0x03, 0x77, 0x60, 0xEA, 0x06, 0x77, 0x20, 0x4A, 0x0E, 0x77, 0x30, 0x8A, 0x0B, 0x77,
  0x30, 0xBA, 0x07, 0x77, 0x30, 0xEA, 0x03, 0x77, 0x20, 0x2B, 0x77, 0x30, 0x6A, 0x0D, 0x77, 0x30,
  0x9A, 0x09, 0x77, 0x30, 0xCA, 0x06, 0x77, 0x3B, 0x03, 0x77, 0x20, 0x3B, 0x77, 0x30, 0x6A, 0x0C,
  0x77, 0x30, 0x9A, 0x08, 0x77, 0x30, 0xDA, 0x05, 0x77, 0x20, 0x1B, 0x02, 0x77, 0x20, 0x4A, 0x0E,
  0x77, 0x30, 0x7A, 0x0B, 0x77, 0x30, 0xAA, 0x08, 0x77, 0x30, 0xDA, 0x04, 0x77, 0x20, 0x1B, 0x01,
  0x77, 0x20, 0x4A, 0x0D, 0x77, 0x30, 0x8A, 0x0A, 0x77, 0x30, 0xBA, 0x07, 0x77, 0x30, 0xEA, 0x04,
  0x77, 0x20, 0x2B, 0x01, 0x77, 0x20, 0x5A, 0x0D, 0x77, 0x30, 0x8A, 0x09, 0x77, 0x30, 0xCA, 0x06,
  0x77, 0x3B, 0x03, 0x77, 0x20, 0x3B, 0x77, 0x30, 0x6A, 0x0B, 0x77, 0x30, 0xBA, 0x07, 0x77, 0x20,
  0x1B, 0x02, 0x77, 0x20, 0xAA, 0x0C, 0x76, 0x82, 0x2E, 0xCE, 0xB0, 0x47, 0x60, 0x2D, 0x08, 0x77,
  0x84, 0x1D, 0xFE, 0xC5, 0x77, 0x10,
  // "Ω" (U+03A9)
  0x75, 0x86, 0x28, 0xCE, 0xFE, 0xB6, 0x77, 0x01, 0x0A, 0xF9, 0x0D, 0x02, 0x74, 0x02, 0x0D, 0xC0,
  0xD0, 0xCC, 0x0E, 0x02, 0x72, 0x02, 0x0E, 0xA0, 0xE0, 0x74, 0x07, 0xB0, 0xB7, 0x20, 0xCA, 0x0E,
  0x03, 0x60, 0x8B, 0x04, 0x70, 0x8B, 0x03, 0x71, 0x0E, 0xA0, 0x86, 0x01, 0xB0, 0x87, 0x20, 0xAA,
  0x0C, 0x60, 0x9A, 0x0E, 0x73, 0x08, 0xA0, 0xE5, 0x01, 0xB0, 0x77, 0x30, 0x7B, 0x50, 0x6B, 0x01,
  0x73, 0x07, 0xB5, 0x0B, 0xA0, 0xB7, 0x40, 0x8A, 0x0E, 0x5B, 0x06, 0x74, 0x09, 0xA0, 0xD4, 0x03,
  0xB0, 0x27, 0x40, 0xBA, 0x0B, 0x40, 0x6B, 0x75, 0x0E, 0xA0, 0x84, 0x09, 0xA0, 0xC7, 0x40, 0x2B,
  0x04, 0x40, 0xAA, 0x0A, 0x74, 0x06, 0xB0, 0x14, 0x0B, 0xA0, 0x97, 0x40, 0xBA, 0x0B, 0x50, 0xCA,
  0x08, 0x73, 0x01, 0xB0, 0x55, 0x0B, 0xA0, 0x87, 0x30, 0x7A, 0x0E, 0x60, 0xAA, 0x09, 0x73, 0x0E,
  0xA0, 0x86, 0x08, 0xA0, 0xA7, 0x20, 0x7A, 0x0E, 0x70, 0x5A, 0x0D, 0x71, 0x01, 0x0E, 0xA0, 0x67,
  0x01, 0xB0, 0x17, 0x0B, 0xA0, 0xB7, 0x20, 0xBA, 0x06, 0x60, 0x7A, 0x0E, 0x01, 0x72, 0x04, 0xA0,
  0xC5, 0x05, 0xA0, 0xE0, 0x37, 0x40, 0xAA, 0x05, 0x30, 0x6A, 0x0E, 0x03, 0x78, 0x47, 0xCC, 0xCC,
  0xDA, 0x0D, 0x20, 0x3B, 0x84, 0xDC, 0xCC, 0xCA, 0x30, 0xDF, 0x0B, 0x20, 0x7F, 0x90, 0x92, 0x01,
  0xF9, 0x08, 0x20, 0xAF, 0x90, 0x62,
  // "μ" (U+03BC)
  0x60, 0x4A, 0x0E, 0x60, 0x2A, 0x0E, 0x60, 0x7A, 0x0B, 0x60, 0x6A, 0x0B, 0x60, 0xAA, 0x08, 0x60,
  0x9A, 0x08, 0x60, 0xDA, 0x04, 0x60, 0xCA, 0x05, 0x50, 0x1B, 0x01, 0x6B, 0x02, 0x50, 0x5A, 0x0D,
  0x60, 0x3A, 0x0E, 0x60, 0x8A, 0x0A, 0x60, 0x7A, 0x0B, 0x60, 0xBA, 0x07, 0x60, 0xAA, 0x08, 0x60,
  0xEA, 0x04, 0x60, 0xDA, 0x05, 0x50, 0x2B, 0x60, 0x1B, 0x01, 0x50, 0x5A, 0x0D, 0x60, 0x5A, 0x0E,
  0x60, 0x9A, 0x09, 0x60, 0x8A, 0x0B, 0x60, 0xCA, 0x06, 0x60, 0xCA, 0x07, 0x6B, 0x03, 0x50, 0x1B,
  0x04, 0x50, 0x3B, 0x60, 0x6B, 0x01, 0x50, 0x6A, 0x0D, 0x60, 0xDA, 0x0D, 0x60, 0xAA, 0x0C, 0x50,
  0x6B, 0x0A, 0x60, 0xDA, 0x0D, 0x40, 0x30, 0xEB, 0x07, 0x50, 0x1C, 0x06, 0x28, 0x25, 0xEF, 0xEA,
  0x04, 0x50, 0x4D, 0x0E, 0xB0, 0x70, 0xCA, 0x01, 0x50, 0x7A, 0x0D, 0xD8, 0x39, 0x0D, 0xFD, 0x60,
  0xBA, 0x84, 0x67, 0xEE, 0xC5, 0x2A, 0x0A, 0x60, 0xEA, 0x04, 0x77, 0x10, 0x2B, 0x01, 0x77, 0x10,
  0x5A, 0x0D, 0x77, 0x20, 0x8A, 0x0A, 0x77, 0x20, 0xBA, 0x06, 0x77, 0x20, 0xEA, 0x03, 0x77, 0x10,
  0x3B, 0x77, 0x20, 0x6A, 0x0B, 0x77, 0x20, 0x9A, 0x08, 0x77, 0x20,
  // "π" (U+03C0)
  0x20, 0x60, 0xEF, 0xF9, 0x81, 0x61, 0xDF, 0xFB, 0x00, 0x30, 0xFC, 0xB8, 0x01, 0xC0, 0xDA, 0x0E,
  0x0F, 0xC4, 0x03, 0xA0, 0xE5, 0x08, 0xA0, 0xA7, 0x06, 0xA0, 0xB5, 0x0B, 0xA0, 0x77, 0x0A, 0xA0,
  0x75, 0x0E, 0xA0, 0x47, 0x0D, 0xA0, 0x44, 0x02, 0xB0, 0x16, 0x01, 0xB0, 0x14, 0x06, 0xA0, 0xD7,
  0x04, 0xA0, 0xD5, 0x09, 0xA0, 0xA7, 0x07, 0xA0, 0xA5, 0x0C, 0xA0, 0x67, 0x0B, 0xA0, 0x75, 0xB0,
  0x37, 0x0E, 0xA0, 0x44, 0x03, 0xB7, 0x01, 0xB5, 0x06, 0xA0, 0xC7, 0x05, 0xA0, 0xD5, 0x09, 0xA0,
  0x97, 0x08, 0xA0, 0x95, 0x0D, 0xA0, 0x67, 0x0B, 0xA0, 0x65, 0xB0, 0x37, 0x0E, 0xA0, 0x34, 0x03,
  0xB7, 0x02, 0xB5, 0x05, 0xA0, 0xD7, 0x06, 0xA0, 0xC5, 0x06, 0xA0, 0xD7, 0x09, 0xA0, 0x95, 0x04,
  0xB8, 0x1D, 0xD4, 0x40, 0xCA, 0x06, 0x60, 0xEC, 0x04, 0x4B, 0x02, 0x68, 0x43, 0xBE, 0xED, 0x34,
  // "–" (U+2013)
  0x05, 0x80, 0x93, 0xC0, 0x20, 0xAF, 0xF9, 0x10, 0xDF, 0xF0, 0xC1,
  // "—" (U+2014)
  0x05, 0x80, 0xB5, 0xC0, 0x60, 0xAF, 0xFF, 0xFD, 0x05, 0x0D, 0xFF, 0xFF, 0xD0, 0x20,
  // "€" (U+20AC)
  0x74, 0x86, 0x39, 0xDE, 0xFD, 0xA5, 0x73, 0x01, 0x0B, 0xF9, 0x0A, 0x71, 0x03, 0x0E, 0xC0, 0xD0,
  0xCB, 0x04, 0x70, 0x20, 0xEA, 0x0E, 0x06, 0x40, 0x70, 0x97, 0x10, 0xCA, 0x0D, 0x02, 0x77, 0x06,
  0xB0, 0x27, 0x71, 0x0E, 0xA0, 0x67, 0x71, 0x07, 0xA0, 0xD7, 0x72, 0x0D, 0xA0, 0x67, 0x71, 0x04,
  0xA0, 0xE7, 0x78, 0x1C, 0xCD, 0xA0, 0xE8, 0x02, 0xC0, 0x46, 0x03, 0xFD, 0x02, 0x60, 0x6F, 0xD7,
  0x20, 0x4A, 0x0E, 0x77, 0x20, 0x8A, 0x0B, 0x77, 0x20, 0xAA, 0x08, 0x76, 0x03, 0xFC, 0x04, 0x70,
  0x6F, 0xC0, 0x17, 0x81, 0x6C, 0xCB, 0x80, 0x1C, 0x0B, 0x74, 0x0E, 0xA0, 0x37, 0x72, 0x0D, 0xA0,
  0x47, 0x72, 0x0C, 0xA0, 0x67, 0x72, 0x0A, 0xA0, 0x87, 0x72, 0x07, 0xA0, 0xC7, 0x72, 0x03, 0xB0,
  0x37, 0x72, 0x0D, 0xA0, 0xD0, 0x33, 0x81, 0x17, 0x37, 0x20, 0x5C, 0x81, 0xDC, 0xEA, 0x05, 0x73,
  0x08, 0xF9, 0x08, 0x74, 0x86, 0x3A, 0xDF, 0xED, 0xA5, 0x60,
  // "₿" (U+20BF)
  0x73, 0x0D, 0x92, 0x0C, 0x97, 0x48, 0x11, 0xFC, 0x29, 0x0C, 0x74, 0x85, 0x4F, 0x80, 0x4F, 0x87,
  0x48, 0x58, 0xF5, 0x07, 0xF5, 0x71, 0x09, 0xD8, 0x2E, 0xEF, 0x27, 0x10, 0xCF, 0x90, 0xD0, 0x27,
  0xB8, 0x1C, 0xCD, 0xC0, 0xD6, 0x03, 0xB0, 0x12, 0x01, 0x0B, 0xB0, 0x65, 0x06, 0xA0, 0xD4, 0x01,
  0x0E, 0xA0, 0xA5, 0x09, 0xA0, 0xA5, 0x0B, 0xA0, 0xC5, 0x0D, 0xA0, 0x65, 0x0A, 0xA0, 0xC5, 0xB0,
  0x35, 0x0B, 0xA0, 0xA4, 0x03, 0xB6, 0x0E, 0xA0, 0x74, 0x07, 0xA0, 0xC5, 0x06, 0xB0, 0x24, 0x0A,
  0xA0, 0x94, 0x02, 0x0E, 0xA0, 0x95, 0x0D, 0xA0, 0x53, 0x05, 0x0D, 0xA0, 0xD0, 0x14, 0x01, 0xB8,
  0x2D, 0xCC, 0xEB, 0x0B, 0x01, 0x50, 0x4F, 0x90, 0xD0, 0x37, 0x07, 0xFA, 0x0B, 0x01, 0x60, 0xBA,
  0x09, 0x20, 0x10, 0x7B, 0x0A, 0x60, 0xEA, 0x05, 0x40, 0x7B, 0x02, 0x40, 0x1B, 0x02, 0x5B, 0x07,
  0x40, 0x5A, 0x0E, 0x60, 0xDA, 0x09, 0x40, 0x8A, 0x0B, 0x60, 0xCA, 0x0A, 0x40, 0xBA, 0x08, 0x60,
  0xDA, 0x09, 0x40, 0xEA, 0x05, 0x6B, 0x07, 0x30, 0x2B, 0x02, 0x50, 0x4B, 0x03, 0x30, 0x5A, 0x0E,
  0x60, 0xBA, 0x0D, 0x40, 0x9A, 0x0B, 0x50, 0x6B, 0x06, 0x40, 0xCA, 0x08, 0x30, 0x10, 0x8B, 0x0C,
  0x5B, 0x82, 0xDC, 0xCD, 0xC0, 0xD0, 0x14, 0x03, 0xFB, 0x09, 0x01, 0x50, 0x6F, 0x90, 0x90, 0x27,
  0x30, 0xC9, 0x20, 0xC9, 0x75, 0x90, 0xD2, 0x90, 0xD7, 0x48, 0x53, 0xF9, 0x03, 0xFA, 0x74, 0x85,
  0x7F, 0x60, 0x6F, 0x77, 0x20,
  // "‘" (U+2018)
  0x40, 0x2A, 0x06, 0x48, 0x1B, 0xFE, 0x40, 0x5A, 0x08, 0x40, 0xDA, 0x02, 0x30, 0x5A, 0x0B, 0x40,
  0xDA, 0x05, 0x30, 0x5A, 0x0E, 0x40, 0xCA, 0x09, 0x30, 0x3B, 0x04, 0x30, 0x9A, 0x0E, 0x40,
  // "’" (U+2019)
  0x30, 0x2B, 0x06, 0x30, 0x7B, 0x01, 0x30, 0xCA, 0x09, 0x30, 0x2B, 0x02, 0x30, 0x8A, 0x0A, 0x40,
  0xEA, 0x03, 0x30, 0x5A, 0x0A, 0x40, 0xBA, 0x01, 0x30, 0x2A, 0x08, 0x48, 0x19, 0xFE, 0x50,
  // "‚" (U+201A)
  0x30, 0x4B, 0x05, 0x30, 0x8A, 0x0E, 0x40, 0xDA, 0x08, 0x30, 0x4B, 0x01, 0x30, 0xAA, 0x09, 0x4B,
  0x02, 0x30, 0x6A, 0x08, 0x48, 0x2C, 0xFE, 0x13, 0x03, 0xA0, 0x74, 0x81, 0xAF, 0xD5,
  // "‛" (U+201B)
  0x1F, 0xFF, 0x60, 0xFF, 0xF5, 0x0F, 0xFF, 0x40, 0xEF, 0xF4, 0x0C, 0xFF, 0x40, 0xBF, 0xF4, 0x09,
  0xFF, 0x40, 0x7F, 0xF5, 0x04, 0xFF, 0x50, 0x2F, 0xF6,
  // "“" (U+201C)
  0x40, 0x1A, 0x07, 0x38, 0x18, 0xFE, 0x48, 0x2A, 0xFE, 0x12, 0x02, 0xA0, 0x83, 0x03, 0xA0, 0x93,
  0x0A, 0xA0, 0x23, 0x0C, 0xA0, 0x32, 0x03, 0xA0, 0xB3, 0x04, 0xA0, 0xC3, 0x0B, 0xA0, 0x53, 0x0B,
  0xA0, 0x62, 0x03, 0xA0, 0xE3, 0x03, 0xB0, 0x12, 0x0A, 0xA0, 0x93, 0x0A, 0xA0, 0xA2, 0x02, 0xB0,
  0x32, 0x02, 0xB0, 0x52, 0x09, 0xA0, 0xD3, 0x08, 0xB3, 0x0E, 0xA0, 0x93,
  // "”" (U+201D)
  0x30, 0x3B, 0x05, 0x20, 0xAA, 0x0D, 0x30, 0x8A, 0x0E, 0x30, 0xEA, 0x08, 0x30, 0xEA, 0x08, 0x20,
  0x5B, 0x02, 0x20, 0x4B, 0x01, 0x20, 0xAA, 0x0A, 0x30, 0x9A, 0x09, 0x20, 0x1B, 0x02, 0x30, 0xEA,
  0x02, 0x20, 0x6A, 0x0A, 0x30, 0x6A, 0x08, 0x30, 0xDA, 0x02, 0x38, 0x2C, 0xFE, 0x12, 0x04, 0xA0,
  0x83, 0x03, 0xA0, 0x73, 0x82, 0xAF, 0xE1, 0x38, 0x19, 0xFD, 0x30, 0x1A, 0x06, 0x40,
  // "„" (U+201E)
  0x40, 0xCA, 0x0B, 0x20, 0x4B, 0x04, 0x30, 0x2B, 0x06, 0x20, 0x9A, 0x0E, 0x40, 0x7A, 0x0E, 0x30,
  0xEA, 0x07, 0x40, 0xDA, 0x07, 0x20, 0x4A, 0x0E, 0x01, 0x30, 0x3A, 0x0E, 0x01, 0x20, 0xAA, 0x08,
  0x40, 0x9A, 0x08, 0x20, 0x1A, 0x0E, 0x01, 0x48, 0x1E, 0xFE, 0x30, 0x6A, 0x07, 0x40, 0x6A, 0x06,
  0x38, 0x1C, 0xFE, 0x58, 0x1C, 0xFD, 0x30, 0x3A, 0x06, 0x40, 0x3A, 0x05, 0x38, 0x1A, 0xFD, 0x50,
  // "‟" (U+201F)
  0xEF, 0xF8, 0x00, 0xAF, 0xFC, 0xEF, 0xF7, 0x00, 0xAF, 0xFB, 0xDF, 0xF7, 0x00, 0x9F, 0xFB, 0xCF,
  0xF6, 0x00, 0x7F, 0xFA, 0xAF, 0xF6, 0x00, 0x6F, 0xFA, 0x9F, 0xF6, 0x00, 0x4F, 0xFB, 0x7F, 0xF7,
  0x00, 0x2F, 0xFB, 0x4F, 0xF7, 0x00, 0x0F, 0xFC, 0x2F, 0xF8, 0x00, 0x0D, 0xFC, 0x0E, 0xF9, 0x00,
  0x0A, 0xFD,
  // "†" (U+2020)
  0x70, 0x9A, 0x0D, 0x73, 0x0B, 0xA0, 0x87, 0x30, 0xDA, 0x04, 0x73, 0x81, 0xEF, 0xE7, 0x30, 0x1A,
  0x0A, 0x73, 0x03, 0xA0, 0x57, 0x30, 0x5A, 0x01, 0x73, 0x81, 0x7F, 0xC6, 0x89, 0x3C, 0xED, 0xBA,
  0xCF, 0xCA, 0xBC, 0xEE, 0x1F, 0xD8, 0x5B, 0x3D, 0xCA, 0x99, 0xA8, 0x48, 0x9A, 0xBD, 0x75, 0x81,
  0x4F, 0xD7, 0x48, 0x18, 0xFB, 0x74, 0x81, 0xCF, 0x87, 0x30, 0x1A, 0x05, 0x73, 0x05, 0xA0, 0x27,
  0x30, 0x8A, 0x74, 0x81, 0xCF, 0xC7, 0x30, 0x1A, 0x09, 0x73, 0x05, 0xA0, 0x67, 0x30, 0x9A, 0x03,
  0x73, 0x0D, 0xA0, 0x17, 0x20, 0x1A, 0x0D, 0x73, 0x05, 0xA0, 0xA7, 0x30, 0x9A, 0x08, 0x73, 0x0D,
  0xA0, 0x57, 0x20, 0x1B, 0x02, 0x72, 0x05, 0xA0, 0xE7, 0x30, 0x9A, 0x0C, 0x73, 0x0D, 0xA0, 0x97,
  0x20,
  // "‡" (U+2021)
  0x72, 0x08, 0xA0, 0xD7, 0x60, 0xAA, 0x09, 0x76, 0x0C, 0xA0, 0x47, 0x68, 0x1E, 0xFE, 0x77, 0xA0,
  0xA7, 0x60, 0x2A, 0x05, 0x76, 0x04, 0xA0, 0x17, 0x18, 0x94, 0x79, 0x87, 0x58, 0xFD, 0x56, 0x79,
  0xA2, 0x30, 0xEF, 0xD3, 0x02, 0xB0, 0xE0, 0xDA, 0x81, 0xDD, 0xEA, 0x0C, 0x40, 0x20, 0x12, 0x01,
  0xA0, 0x23, 0x00, 0x17, 0x10, 0x6A, 0x77, 0x81, 0xAF, 0xE7, 0x7A, 0x0C, 0x76, 0x05, 0xA0, 0xA7,
  0x60, 0x8A, 0x07, 0x76, 0x0A, 0xA0, 0x27, 0x68, 0x1D, 0xFD, 0x77, 0x81, 0xEF, 0x87, 0x60, 0x1A,
  0x03, 0x71, 0x84, 0x7B, 0xA9, 0x88, 0xA8, 0x47, 0x89, 0xAB, 0x43, 0x0C, 0xFD, 0x02, 0x39, 0x89,
  0x2E, 0xDC, 0xAD, 0xFC, 0xBC, 0xDF, 0xD7, 0x28, 0x1E, 0xF5, 0x76, 0x03, 0xA0, 0x37, 0x60, 0x8A,
  0x01, 0x76, 0x81, 0xDF, 0xE7, 0x60, 0x2A, 0x0C, 0x76, 0x07, 0xA0, 0xA7, 0x60, 0xCA, 0x08, 0x73,
  // "•" (U+2022)
  0x28, 0x47, 0xDF, 0xEB, 0x33, 0x0B, 0xE8, 0x15, 0x05, 0xF8, 0x1E, 0x0A, 0xF9, 0x04, 0x0D, 0xF9,
  0x06, 0x0E, 0xF9, 0x07, 0x0D, 0xF9, 0x06, 0x0A, 0xF9, 0x04, 0x05, 0xF0, 0xE2, 0x0A, 0xE0, 0x43,
  0x84, 0x7C, 0xFE, 0xB3, 0x20,
  // "…" (U+2026)
  0x18, 0x24, 0xDE, 0x65, 0x82, 0x4D, 0xE6, 0x58, 0x44, 0xDE, 0x61, 0xEA, 0x0E, 0x40, 0x10, 0xEA,
  0x0E, 0x40, 0x10, 0xEA, 0x0E, 0x05, 0xB0, 0xD4, 0x05, 0xB0, 0xD4, 0x05, 0xB0, 0xD0, 0x5B, 0x08,
  0x40, 0x5B, 0x08, 0x40, 0x5B, 0x83, 0x81, 0xCE, 0xA5, 0x82, 0x1C, 0xEA, 0x58, 0x21, 0xCE, 0xA1,
  // "‰" (U+2030)
  0x48, 0x41, 0x9D, 0xFC, 0x37, 0x10, 0x8A, 0x02, 0x77, 0x20, 0x20, 0xDC, 0x0E, 0x02, 0x60, 0x2A,
  0x08, 0x77, 0x30, 0xCA, 0x0D, 0x0E, 0xA0, 0x96, 0x81, 0xBF, 0xE7, 0x73, 0x07, 0xA8, 0x49, 0x01,
  0xEF, 0xC5, 0x04, 0xA0, 0x67, 0x73, 0x81, 0xEF, 0xD3, 0x81, 0xAF, 0xD5, 0x81, 0xDF, 0xC7, 0x73,
  0x05, 0xA0, 0x53, 0x81, 0xAF, 0xD4, 0x07, 0xA0, 0x37, 0x73, 0x0A, 0xA4, 0x81, 0xBF, 0xC3, 0x82,
  0x1E, 0xFA, 0x77, 0x48, 0x1E, 0xFB, 0x48, 0x1D, 0xFA, 0x38, 0x29, 0xFE, 0x17, 0x73, 0x03, 0xA0,
  0x63, 0x01, 0xA0, 0x82, 0x03, 0xA0, 0x77, 0x74, 0x05, 0xA0, 0x33, 0x04, 0xA0, 0x52, 0x81, 0xCF,
  0xD7, 0x75, 0x08, 0xA4, 0x09, 0xA8, 0x11, 0x05, 0xA0, 0x57, 0x75, 0x81, 0x9F, 0xE4, 0x81, 0xDF,
  0xC2, 0x81, 0xDF, 0xB2, 0x83, 0x7D, 0xFD, 0x56, 0x83, 0x4B, 0xEE, 0x92, 0x81, 0xAF, 0xD3, 0x04,
  0xA8, 0x16, 0x08, 0xA8, 0x13, 0x0B, 0xD0, 0x54, 0x06, 0xD8, 0x3A, 0x0A, 0xFE, 0x38, 0x3B, 0xFE,
  0x02, 0xA8, 0x19, 0x09, 0xA0, 0xE0, 0xDA, 0x0C, 0x30, 0x3B, 0x0D, 0xB0, 0x20, 0x8A, 0x81, 0x61,
  0x9A, 0x85, 0x70, 0xAF, 0xE1, 0x3A, 0x0B, 0x20, 0xCA, 0x38, 0x4D, 0xFE, 0x30, 0x6A, 0x06, 0x04,
  0xE8, 0x1C, 0x04, 0xA8, 0x47, 0x0B, 0xFE, 0x12, 0x07, 0xA8, 0x12, 0x05, 0xA0, 0x62, 0x02, 0xA8,
  0x17, 0x0B, 0xC8, 0x6D, 0x10, 0xCF, 0xD0, 0x2A, 0x08, 0x30, 0x7A, 0x83, 0x10, 0xCF, 0xE3, 0x01,
  0xA0, 0x72, 0x82, 0x7B, 0xA7, 0x20, 0x6A, 0x81, 0x40, 0x7A, 0x03, 0x30, 0x8A, 0x10, 0x1A, 0x09,
  0x30, 0x2A, 0x06, 0x78, 0x21, 0xEF, 0xB2, 0x81, 0xBF, 0xE4, 0x83, 0xAF, 0xE0, 0x6A, 0x04, 0x30,
  0x5A, 0x04, 0x70, 0x9A, 0x02, 0x2A, 0x0A, 0x48, 0x3D, 0xFC, 0x09, 0xA4, 0x07, 0xA0, 0x16, 0x02,
  0xA0, 0x92, 0x02, 0xA0, 0x73, 0x01, 0xA8, 0x39, 0x0C, 0xFD, 0x48, 0x1A, 0xFE, 0x78, 0x2B, 0xFE,
  0x12, 0x04, 0xA0, 0x43, 0x05, 0xA8, 0x35, 0x0E, 0xFA, 0x48, 0x1E, 0xFA, 0x60, 0x4A, 0x06, 0x30,
  0x6A, 0x02, 0x30, 0xAA, 0x01, 0x1A, 0x08, 0x30, 0x4A, 0x05, 0x68, 0x1D, 0xFD, 0x40, 0x7A, 0x01,
  0x38, 0x3E, 0xFB, 0x01, 0xA0, 0x73, 0x09, 0xA6, 0x07, 0xA0, 0x44, 0x07, 0xA0, 0x22, 0x07, 0xA8,
  0x14, 0x01, 0xA0, 0x72, 0x02, 0xA0, 0x95, 0x82, 0x1E, 0xFA, 0x50, 0x5A, 0x84, 0x60, 0x3E, 0xFC,
  0x3A, 0x0C, 0x20, 0xCA, 0x02, 0x50, 0x9A, 0x02, 0x50, 0x2B, 0x0D, 0xB0, 0x33, 0x0C, 0xA0, 0xD0,
  0xEA, 0x07, 0x50, 0x3A, 0x08, 0x70, 0xAD, 0x05, 0x40, 0x4D, 0x0A, 0x68, 0x1C, 0xFE, 0x72, 0x83,
  0x9E, 0xEB, 0x36, 0x83, 0x5D, 0xFD, 0x65,
  // "‹" (U+2039)
  0x70, 0x67, 0x81, 0xBF, 0xB5, 0x0A, 0xA0, 0xA4, 0x08, 0xA0, 0xC4, 0x07, 0xA0, 0xD0, 0x13, 0x05,
  0xB0, 0x33, 0x04, 0xB0, 0x53, 0x03, 0x0E, 0xA0, 0x84, 0x0A, 0xA0, 0xD5, 0x04, 0xB0, 0x25, 0x0C,
  0xA0, 0x85, 0x04, 0xA0, 0xE6, 0x0C, 0xA0, 0x55, 0x05, 0xA0, 0xB6, 0x0C, 0xA0, 0x25, 0x05, 0xA0,
  0x56, 0x07, 0x01, 0x30,
  // "›" (U+203A)
  0x40, 0x60, 0x15, 0x82, 0x3E, 0xF7, 0x68, 0x1E, 0xFE, 0x60, 0x9A, 0x07, 0x50, 0x2A, 0x0E, 0x60,
  0xCA, 0x06, 0x50, 0x5A, 0x0D, 0x60, 0xEA, 0x06, 0x50, 0xBA, 0x0C, 0x40, 0x5B, 0x05, 0x30, 0x3B,
  0x06, 0x30, 0x10, 0xEA, 0x08, 0x40, 0xCA, 0x09, 0x40, 0xAA, 0x0A, 0x40, 0x8A, 0x0C, 0x58, 0x29,
  0xFD, 0x16, 0x05, 0x01, 0x60,
  // "⁄" (U+2044)
  0x77, 0x70, 0xAA, 0x02, 0x77, 0x60, 0x5A, 0x06, 0x77, 0x68, 0x22, 0xEF, 0xA7, 0x77, 0x82, 0xCF,
  0xD1, 0x77, 0x60, 0x8A, 0x03, 0x77, 0x60, 0x4A, 0x08, 0x77, 0x68, 0x21, 0xEF, 0xC7, 0x77, 0x82,
  0xBF, 0xE1, 0x77, 0x60, 0x7A, 0x05, 0x77, 0x60, 0x3A, 0x09, 0x77, 0x78, 0x1D, 0xFD, 0x77, 0x70,
  0xAA, 0x02, 0x77, 0x60, 0x6A, 0x06, 0x77, 0x68, 0x22, 0xEF, 0xA7, 0x77, 0x82, 0xCF, 0xD1, 0x77,
  0x60, 0x8A, 0x03, 0x77, 0x60, 0x4A, 0x08, 0x77, 0x68, 0x21, 0xEF, 0xC7, 0x77, 0x82, 0xBF, 0xE1,
  0x77, 0x60, 0x7A, 0x05, 0x77, 0x60, 0x3A, 0x09, 0x77, 0x68, 0x21, 0xDF, 0xD7, 0x77, 0x0A, 0xA0,
  0x27, 0x76, 0x06, 0xA0, 0x67, 0x76, 0x82, 0x2E, 0xFA, 0x77, 0x78, 0x2C, 0xFD, 0x17, 0x76, 0x09,
  0xA0, 0x47, 0x76, 0x04, 0xA0, 0x87, 0x76, 0x82, 0x1E, 0xFC, 0x77, 0x70,
  // "™" (U+2122)
  0x06, 0xFA, 0x10, 0xBA, 0x0A, 0x60, 0xAA, 0x08, 0x06, 0xFA, 0x10, 0xBA, 0x0E, 0x6B, 0x08, 0x48,
  0x1C, 0xF4, 0x40, 0xBB, 0x04, 0x40, 0x5B, 0x08, 0x48, 0x1C, 0xF4, 0x48, 0x3B, 0xFB, 0xF9, 0x48,
  0x3A, 0xFB, 0xF8, 0x48, 0x1C, 0xF4, 0x48, 0x3B, 0xF7, 0xFD, 0x48, 0x3E, 0xD9, 0xF8, 0x48, 0x1C,
  0xF4, 0x48, 0x4B, 0xF4, 0xDF, 0x32, 0x84, 0x4F, 0x89, 0xF8, 0x48, 0x1C, 0xF4, 0x48, 0x4B, 0xF4,
  0x8F, 0x82, 0x84, 0x9F, 0x29, 0xF8, 0x48, 0x1C, 0xF4, 0x48, 0x4B, 0xF4, 0x3F, 0xD2, 0x84, 0xED,
  0x09, 0xF8, 0x48, 0x1C, 0xF4, 0x48, 0x94, 0xBF, 0x40, 0xDF, 0x24, 0xF7, 0x09, 0xF8, 0x48, 0x1C,
  0xF4, 0x48, 0x94, 0xBF, 0x40, 0x9F, 0x79, 0xF2, 0x09, 0xF8, 0x48, 0x1C, 0xF4, 0x48, 0x7B, 0xF4,
  0x04, 0xFC, 0xEC, 0x28, 0x19, 0xF8, 0x48, 0x1C, 0xF4, 0x48, 0x1B, 0xF4, 0x20, 0xEA, 0x07, 0x28,
  0x19, 0xF8, 0x48, 0x1C, 0xF4, 0x48, 0x1B, 0xF4, 0x20, 0x9A, 0x02, 0x28, 0x19, 0xF8, 0x48, 0x1C,
  0xF4, 0x48, 0x1B, 0xF4, 0x28, 0x14, 0xFC, 0x38, 0x19, 0xF7,
  // "⅒" (U+2152)
  0x60, 0x7A, 0x07, 0x74, 0x0A, 0xA0, 0x27, 0x71, 0x01, 0x0B, 0xB0, 0x47, 0x30, 0x5A, 0x06, 0x77,
  0x10, 0x40, 0xDC, 0x73, 0x82, 0x2E, 0xFA, 0x77, 0x10, 0x7A, 0x82, 0xCB, 0xFD, 0x73, 0x82, 0xCF,
  0xD1, 0x77, 0x18, 0x5C, 0xF8, 0x0D, 0xF9, 0x72, 0x08, 0xA0, 0x37, 0x72, 0x82, 0x34, 0x02, 0xA0,
  0x67, 0x10, 0x4A, 0x08, 0x77, 0x60, 0x5A, 0x02, 0x78, 0x21, 0xEF, 0xC7, 0x77, 0x81, 0x8F, 0xE7,
  0x18, 0x2B, 0xFE, 0x17, 0x77, 0x81, 0xCF, 0xB7, 0x07, 0xA0, 0x57, 0x77, 0x1A, 0x08, 0x60, 0x3A,
  0x09, 0x77, 0x71, 0x03, 0xA0, 0x56, 0x81, 0xDF, 0xD7, 0x77, 0x20, 0x6A, 0x01, 0x50, 0xAA, 0x02,
  0x77, 0x72, 0x81, 0xAF, 0xD5, 0x06, 0xA0, 0x64, 0x07, 0xA0, 0x74, 0x84, 0x3B, 0xEE, 0xC4, 0x68,
  0x1D, 0xFA, 0x48, 0x22, 0xEF, 0xA3, 0x01, 0x0B, 0xB0, 0x43, 0x04, 0xE0, 0x44, 0x01, 0xA0, 0x74,
  0x82, 0xCF, 0xD1, 0x20, 0x40, 0xDC, 0x38, 0x42, 0xEF, 0xD6, 0x8A, 0x0B, 0x40, 0x4A, 0x03, 0x30,
  0x8A, 0x03, 0x20, 0x7A, 0x82, 0xCB, 0xFD, 0x38, 0x2B, 0xFE, 0x12, 0x0A, 0xA4, 0x08, 0xA3, 0x04,
  0xA0, 0x83, 0x85, 0xCF, 0x80, 0xDF, 0x92, 0x04, 0xA0, 0x73, 0x07, 0xA0, 0x17, 0x18, 0x21, 0xEF,
  0xC4, 0x82, 0x34, 0x02, 0xA0, 0x62, 0x81, 0xAF, 0xE4, 0x07, 0xA0, 0x27, 0x18, 0x2B, 0xFE, 0x17,
  0x05, 0xA0, 0x22, 0xA0, 0xA4, 0x07, 0xA0, 0x17, 0x07, 0xA0, 0x57, 0x18, 0x18, 0xFE, 0x20, 0x3A,
  0x06, 0x40, 0x9A, 0x70, 0x3A, 0x09, 0x72, 0x81, 0xCF, 0xB2, 0x07, 0xA0, 0x24, 0x81, 0xCF, 0xD6,
  0x82, 0x1D, 0xFD, 0x73, 0xA0, 0x82, 0x81, 0xAF, 0xE5, 0x81, 0xEF, 0xA6, 0x0A, 0xA0, 0x27, 0x20,
  0x3A, 0x05, 0x28, 0x1C, 0xFC, 0x40, 0x3A, 0x07, 0x50, 0x6A, 0x06, 0x73, 0x06, 0xA0, 0x12, 0x81,
  0xDF, 0xA4, 0x07, 0xA0, 0x34, 0x82, 0x2E, 0xFA, 0x74, 0x81, 0xAF, 0xD3, 0x81, 0xEF, 0xA4, 0x81,
  0xDF, 0xD5, 0x82, 0xCF, 0xD1, 0x74, 0x81, 0xDF, 0xA3, 0x81, 0xDF, 0xA3, 0x04, 0xA0, 0x74, 0x09,
  0xA0, 0x47, 0x40, 0x1A, 0x07, 0x38, 0x1B, 0xFD, 0x38, 0x1D, 0xFD, 0x40, 0x4A, 0x08, 0x75, 0x04,
  0xA0, 0x33, 0x07, 0xA8, 0x19, 0x5C, 0xA0, 0x53, 0x82, 0x1E, 0xFC, 0x76, 0x08, 0xA4, 0x01, 0x0D,
  0xD0, 0x77, 0x77, 0x71, 0x84, 0x2A, 0xEE, 0xB4, 0x50,
  // "ﬁ" (U+FB01)
  0x77, 0x84, 0x49, 0xBB, 0x94, 0x77, 0x40, 0xAD, 0x0B, 0x77, 0x30, 0x7E, 0x84, 0x50, 0x4D, 0xE5,
  0x75, 0x0E, 0xA8, 0x29, 0x11, 0x52, 0x0E, 0xA0, 0xA7, 0x40, 0x6A, 0x0D, 0x50, 0x2B, 0x06, 0x74,
  0x0B, 0xA0, 0x76, 0x81, 0xBE, 0xA7, 0x5B, 0x02, 0x77, 0x60, 0x3A, 0x0E, 0x77, 0x70, 0x7A, 0x0B,
  0x77, 0x70, 0xAA, 0x08, 0x77, 0x48, 0x11, 0x6C, 0xE0, 0xB2, 0x03, 0xA0, 0xE7, 0x20, 0xCF, 0x90,
  0x82, 0x06, 0xA0, 0xB7, 0x28, 0x1B, 0xCD, 0xB0, 0xFC, 0x04, 0x20, 0xAA, 0x08, 0x74, 0x07, 0xA0,
  0xB6, 0x0D, 0xA0, 0x57, 0x40, 0xAA, 0x08, 0x50, 0x1B, 0x02, 0x74, 0x0D, 0xA0, 0x55, 0x04, 0xA0,
  0xE7, 0x40, 0x1B, 0x01, 0x50, 0x7A, 0x0B, 0x74, 0x05, 0xA0, 0xD6, 0x0A, 0xA0, 0x87, 0x40, 0x8A,
  0x0A, 0x60, 0xDA, 0x04, 0x74, 0x0B, 0xA0, 0x75, 0x01, 0xB0, 0x17, 0x40, 0xEA, 0x03, 0x50, 0x4A,
  0x0D, 0x74, 0x03, 0xB6, 0x07, 0xA0, 0xA7, 0x40, 0x6A, 0x0C, 0x60, 0xBA, 0x07, 0x74, 0x09, 0xA0,
  0x96, 0x0E, 0xA0, 0x47, 0x40, 0xDA, 0x06, 0x50, 0x2B, 0x01, 0x74, 0xB0, 0x25, 0x05, 0xA0, 0xD7,
  0x40, 0x4A, 0x0E, 0x60, 0x8A, 0x0A, 0x74, 0x07, 0xA0, 0xB6, 0x0B, 0xA0, 0x67, 0x40, 0xAA, 0x08,
  0x60, 0xEA, 0x03, 0x74, 0x0E, 0xA0, 0x45, 0x02, 0xB7, 0x40, 0x2B, 0x01, 0x50, 0x5A, 0x0C, 0x74,
  0x05, 0xA0, 0xD6, 0x09, 0xA0, 0x97, 0x40, 0x8A, 0x0A, 0x77, 0x70, 0xCA, 0x06, 0x77, 0x7B, 0x03,
  0x77, 0x60, 0x4A, 0x0E, 0x77, 0x70, 0xAA, 0x09, 0x77, 0x60, 0x4B, 0x03, 0x77, 0x38, 0x1C, 0xDD,
  0xB0, 0xB7, 0x74, 0x0C, 0xC0, 0xD0, 0x17, 0x74, 0x84, 0x9E, 0xFD, 0x91, 0x77, 0x50,
  // "ﬂ" (U+FB02)
  0x77, 0x84, 0x49, 0xBB, 0x94, 0x77, 0x40, 0xAD, 0x0B, 0x77, 0x30, 0x7E, 0x81, 0x50, 0x4A, 0x0D,
  0x75, 0x0E, 0xA8, 0x29, 0x11, 0x52, 0x08, 0xA0, 0xA7, 0x40, 0x6A, 0x0D, 0x60, 0xBA, 0x07, 0x74,
  0x0B, 0xA0, 0x76, 0x0E, 0xA0, 0x37, 0x4B, 0x02, 0x50, 0x2B, 0x74, 0x03, 0xA0, 0xE6, 0x06, 0xA0,
  0xC7, 0x40, 0x7A, 0x0B, 0x60, 0x9A, 0x09, 0x74, 0x0A, 0xA0, 0x86, 0x0C, 0xA0, 0x57, 0x18, 0x11,
  0x6C, 0xE0, 0xB3, 0xB0, 0x27, 0x10, 0xCF, 0x90, 0x82, 0x04, 0xA0, 0xE7, 0x28, 0x1B, 0xCD, 0xB0,
  0xFC, 0x04, 0x20, 0x7A, 0x0B, 0x74, 0x07, 0xA0, 0xB6, 0x0A, 0xA0, 0x77, 0x40, 0xAA, 0x08, 0x60,
  0xEA, 0x04, 0x74, 0x0D, 0xA0, 0x55, 0x01, 0xB0, 0x17, 0x30, 0x1B, 0x01, 0x50, 0x5A, 0x0D, 0x74,
  0x05, 0xA0, 0xD6, 0x08, 0xA0, 0xA7, 0x40, 0x8A, 0x0A, 0x60, 0xBA, 0x06, 0x74, 0x0B, 0xA0, 0x76,
  0xB0, 0x37, 0x40, 0xEA, 0x03, 0x50, 0x3B, 0x74, 0x03, 0xB6, 0x06, 0xA0, 0xC7, 0x40, 0x6A, 0x0C,
  0x60, 0x9A, 0x08, 0x74, 0x09, 0xA0, 0x96, 0x0D, 0xA0, 0x57, 0x40, 0xDA, 0x06, 0x50, 0x1B, 0x02,
  0x74, 0xB0, 0x25, 0x04, 0xA0, 0xE7, 0x40, 0x4A, 0x0E, 0x60, 0x7A, 0x0A, 0x74, 0x07, 0xA0, 0xB6,
  0x0B, 0xA0, 0x77, 0x40, 0xAA, 0x08, 0x60, 0xEA, 0x04, 0x74, 0x0E, 0xA0, 0x45, 0x02, 0xB7, 0x40,
  0x2B, 0x01, 0x50, 0x5A, 0x0D, 0x74, 0x05, 0xA0, 0xD6, 0x09, 0xA0, 0x97, 0x40, 0x8A, 0x0A, 0x77,
  0x70, 0xCA, 0x06, 0x77, 0x7B, 0x03, 0x77, 0x60, 0x4A, 0x0E, 0x77, 0x70, 0xAA, 0x09, 0x77, 0x60,
  0x4B, 0x03, 0x77, 0x38, 0x1C, 0xDD, 0xB0, 0xB7, 0x74, 0x0C, 0xC0, 0xD0, 0x17, 0x74, 0x84, 0x9E,
  0xFD, 0x91, 0x77, 0x50,
};

const Font& font_NotoSans_CondensedItalic_40() {
  static SmoothFont font(font_NotoSans_CondensedItalic_40_data);
  return font;
}

}  // namespace roo_display
