#include "15.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSans-CondensedItalic (Noto Sans Condensed Italic)
// Generated on Wed Nov 19 19:11:24 CET 2025
static const uint8_t font_NotoSans_CondensedItalic_15_data[] PROGMEM = {
  
  // Header
  0x01, 0x02, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x05, 0x09,
  0xFC, 0xFD, 0x0E, 0x0F, 0x0B, 0xFD, 0x05, 0x02, 0x0E, 0x04, 0x03, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x40, 0x01, 0x03, 0x0A, 0x04, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x41, 0x08, 0x05, 0x0A, 0x05, 0x00, 0x14, // """ (U+0022)
  0x00, 0x23, 0x40, 0x01, 0x07, 0x0A, 0x07, 0x00, 0x1C, // "#" (U+0023)
  0x00, 0x24, 0x00, 0x00, 0x06, 0x0B, 0x07, 0x00, 0x44, // "$" (U+0024)
  0x00, 0x25, 0x40, 0x01, 0x09, 0x0A, 0x0A, 0x00, 0x6A, // "%" (U+0025)
  0x00, 0x26, 0x40, 0x01, 0x07, 0x0A, 0x08, 0x00, 0x9C, // "&" (U+0026)
  0x00, 0x27, 0x41, 0x08, 0x03, 0x0A, 0x03, 0x00, 0xC4, // "'" (U+0027)
  0x00, 0x28, 0x40, 0xFE, 0x04, 0x0A, 0x04, 0x00, 0xC9, // "(" (U+0028)
  0x00, 0x29, 0xBF, 0xFE, 0x03, 0x0A, 0x04, 0x00, 0xEA, // ")" (U+0029)
  0x00, 0x2A, 0x41, 0x06, 0x06, 0x0B, 0x06, 0x01, 0x0B, // "*" (U+002A)
  0x00, 0x2B, 0x00, 0x03, 0x06, 0x09, 0x07, 0x01, 0x1D, // "+" (U+002B)
  0x00, 0x2C, 0xBF, 0xFF, 0x01, 0x02, 0x03, 0x01, 0x33, // "," (U+002C)
  0x00, 0x2D, 0x40, 0x04, 0x03, 0x05, 0x04, 0x01, 0x39, // "-" (U+002D)
  0x00, 0x2E, 0x40, 0x01, 0x01, 0x02, 0x03, 0x01, 0x3D, // "." (U+002E)
  0x00, 0x2F, 0xFF, 0x01, 0x06, 0x0A, 0x05, 0x01, 0x3F, // "/" (U+002F)
  0x00, 0x30, 0x40, 0x01, 0x06, 0x0A, 0x07, 0x01, 0x5A, // "0" (U+0030)
  0x00, 0x31, 0x41, 0x01, 0x05, 0x0A, 0x07, 0x01, 0x7D, // "1" (U+0031)
  0x00, 0x32, 0xFF, 0x01, 0x06, 0x0A, 0x07, 0x01, 0x96, // "2" (U+0032)
  0x00, 0x33, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x01, 0xB4, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x01, 0xD5, // "4" (U+0034)
  0x00, 0x35, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x01, 0xF7, // "5" (U+0035)
  0x00, 0x36, 0x40, 0x01, 0x06, 0x0A, 0x07, 0x02, 0x16, // "6" (U+0036)
  0x00, 0x37, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x02, 0x39, // "7" (U+0037)
  0x00, 0x38, 0x40, 0x01, 0x06, 0x0A, 0x07, 0x02, 0x53, // "8" (U+0038)
  0x00, 0x39, 0x40, 0x01, 0x06, 0x0A, 0x07, 0x02, 0x76, // "9" (U+0039)
  0x00, 0x3A, 0x00, 0x01, 0x02, 0x08, 0x03, 0x02, 0x99, // ":" (U+003A)
  0x00, 0x3B, 0xFF, 0xFF, 0x03, 0x08, 0x03, 0x02, 0xA2, // ";" (U+003B)
  0x00, 0x3C, 0x00, 0x03, 0x06, 0x09, 0x07, 0x02, 0xB4, // "<" (U+003C)
  0x00, 0x3D, 0x00, 0x03, 0x06, 0x07, 0x07, 0x02, 0xC9, // "=" (U+003D)
  0x00, 0x3E, 0x00, 0x03, 0x06, 0x09, 0x07, 0x02, 0xD7, // ">" (U+003E)
  0x00, 0x3F, 0x00, 0x01, 0x05, 0x0A, 0x05, 0x02, 0xED, // "?" (U+003F)
  0x00, 0x40, 0x00, 0x00, 0x09, 0x0A, 0x0A, 0x03, 0x08, // "@" (U+0040)
  0x00, 0x41, 0xBF, 0x01, 0x05, 0x0A, 0x07, 0x03, 0x3D, // "A" (U+0041)
  0x00, 0x42, 0x40, 0x01, 0x07, 0x0A, 0x07, 0x03, 0x60, // "B" (U+0042)
  0x00, 0x43, 0x00, 0x01, 0x07, 0x0A, 0x07, 0x03, 0x88, // "C" (U+0043)
  0x00, 0x44, 0x40, 0x01, 0x07, 0x0A, 0x08, 0x03, 0xA9, // "D" (U+0044)
  0x00, 0x45, 0x00, 0x01, 0x06, 0x0A, 0x06, 0x03, 0xD1, // "E" (U+0045)
  0x00, 0x46, 0x00, 0x01, 0x06, 0x0A, 0x06, 0x03, 0xEE, // "F" (U+0046)
  0x00, 0x47, 0x00, 0x01, 0x08, 0x0A, 0x08, 0x04, 0x0B, // "G" (U+0047)
  0x00, 0x48, 0x40, 0x01, 0x08, 0x0A, 0x08, 0x04, 0x37, // "H" (U+0048)
  0x00, 0x49, 0xFF, 0x01, 0x05, 0x0A, 0x04, 0x04, 0x64, // "I" (U+0049)
  0x00, 0x4A, 0xFD, 0xFD, 0x03, 0x0A, 0x03, 0x04, 0x80, // "J" (U+004A)
  0x00, 0x4B, 0x40, 0x01, 0x07, 0x0A, 0x07, 0x04, 0xA5, // "K" (U+004B)
  0x00, 0x4C, 0x40, 0x01, 0x04, 0x0A, 0x06, 0x04, 0xCD, // "L" (U+004C)
  0x00, 0x4D, 0x40, 0x01, 0x0A, 0x0A, 0x0B, 0x04, 0xE6, // "M" (U+004D)
  0x00, 0x4E, 0x40, 0x01, 0x08, 0x0A, 0x09, 0x05, 0x1D, // "N" (U+004E)
  0x00, 0x4F, 0x40, 0x01, 0x08, 0x0A, 0x08, 0x05, 0x4A, // "O" (U+004F)
  0x00, 0x50, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x05, 0x77, // "P" (U+0050)
  0x00, 0x51, 0x00, 0xFE, 0x08, 0x0A, 0x08, 0x05, 0x98, // "Q" (U+0051)
  0x00, 0x52, 0x40, 0x01, 0x06, 0x0A, 0x07, 0x05, 0xCE, // "R" (U+0052)
  0x00, 0x53, 0xFF, 0x01, 0x06, 0x0A, 0x06, 0x05, 0xF1, // "S" (U+0053)
  0x00, 0x54, 0x01, 0x01, 0x06, 0x0A, 0x06, 0x06, 0x13, // "T" (U+0054)
  0x00, 0x55, 0x40, 0x01, 0x08, 0x0A, 0x08, 0x06, 0x2E, // "U" (U+0055)
  0x00, 0x56, 0x41, 0x01, 0x07, 0x0A, 0x07, 0x06, 0x5B, // "V" (U+0056)
  0x00, 0x57, 0x41, 0x01, 0x0B, 0x0A, 0x0B, 0x06, 0x7E, // "W" (U+0057)
  0x00, 0x58, 0xFF, 0x01, 0x07, 0x0A, 0x06, 0x06, 0xB5, // "X" (U+0058)
  0x00, 0x59, 0x01, 0x01, 0x07, 0x0A, 0x06, 0x06, 0xDD, // "Y" (U+0059)
  0x00, 0x5A, 0xFF, 0x01, 0x06, 0x0A, 0x06, 0x06, 0xFC, // "Z" (U+005A)
  0x00, 0x5B, 0xFF, 0xFD, 0x05, 0x0A, 0x04, 0x07, 0x18, // "[" (U+005B)
  0x00, 0x5C, 0x41, 0x01, 0x03, 0x0A, 0x05, 0x07, 0x3B, // "\" (U+005C)
  0x00, 0x5D, 0xFF, 0xFD, 0x04, 0x0A, 0x04, 0x07, 0x4A, // "]" (U+005D)
  0x00, 0x5E, 0x40, 0x06, 0x06, 0x0B, 0x07, 0x07, 0x6D, // "^" (U+005E)
  0x00, 0x5F, 0xBE, 0xFE, 0x03, 0xFF, 0x05, 0x07, 0x82, // "_" (U+005F)
  0x00, 0x60, 0x42, 0x0A, 0x04, 0x0C, 0x04, 0x07, 0x88, // "`" (U+0060)
  0x00, 0x61, 0x40, 0x01, 0x06, 0x08, 0x07, 0x07, 0x8D, // "a" (U+0061)
  0x00, 0x62, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x07, 0xA9, // "b" (U+0062)
  0x00, 0x63, 0x40, 0x01, 0x05, 0x08, 0x05, 0x07, 0xCF, // "c" (U+0063)
  0x00, 0x64, 0x00, 0x01, 0x07, 0x0B, 0x07, 0x07, 0xE7, // "d" (U+0064)
  0x00, 0x65, 0x40, 0x01, 0x05, 0x08, 0x06, 0x08, 0x12, // "e" (U+0065)
  0x00, 0x66, 0xFE, 0xFE, 0x05, 0x0B, 0x04, 0x08, 0x2A, // "f" (U+0066)
  0x00, 0x67, 0xBF, 0xFE, 0x06, 0x08, 0x07, 0x08, 0x50, // "g" (U+0067)
  0x00, 0x68, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x08, 0x7C, // "h" (U+0068)
  0x00, 0x69, 0x40, 0x01, 0x03, 0x0B, 0x03, 0x08, 0xA2, // "i" (U+0069)
  0x00, 0x6A, 0xFE, 0xFE, 0x03, 0x0B, 0x03, 0x08, 0xB8, // "j" (U+006A)
  0x00, 0x6B, 0x00, 0x01, 0x06, 0x0B, 0x06, 0x08, 0xD8, // "k" (U+006B)
  0x00, 0x6C, 0x40, 0x01, 0x03, 0x0B, 0x03, 0x08, 0xFE, // "l" (U+006C)
  0x00, 0x6D, 0x40, 0x01, 0x09, 0x08, 0x0A, 0x09, 0x14, // "m" (U+006D)
  0x00, 0x6E, 0x40, 0x01, 0x06, 0x08, 0x07, 0x09, 0x3C, // "n" (U+006E)
  0x00, 0x6F, 0x40, 0x01, 0x06, 0x08, 0x07, 0x09, 0x58, // "o" (U+006F)
  0x00, 0x70, 0xFF, 0xFE, 0x06, 0x08, 0x07, 0x09, 0x74, // "p" (U+0070)
  0x00, 0x71, 0x40, 0xFE, 0x06, 0x08, 0x07, 0x09, 0x9F, // "q" (U+0071)
  0x00, 0x72, 0x00, 0x01, 0x05, 0x08, 0x05, 0x09, 0xC6, // "r" (U+0072)
  0x00, 0x73, 0x40, 0x01, 0x05, 0x08, 0x05, 0x09, 0xDD, // "s" (U+0073)
  0x00, 0x74, 0x40, 0x01, 0x04, 0x0A, 0x04, 0x09, 0xF5, // "t" (U+0074)
  0x00, 0x75, 0x40, 0x01, 0x06, 0x08, 0x07, 0x0A, 0x0E, // "u" (U+0075)
  0x00, 0x76, 0x40, 0x01, 0x06, 0x08, 0x06, 0x0A, 0x2A, // "v" (U+0076)
  0x00, 0x77, 0x40, 0x01, 0x09, 0x08, 0x09, 0x0A, 0x46, // "w" (U+0077)
  0x00, 0x78, 0xFF, 0x01, 0x06, 0x08, 0x06, 0x0A, 0x6E, // "x" (U+0078)
  0x00, 0x79, 0xFE, 0xFE, 0x06, 0x08, 0x06, 0x0A, 0x8C, // "y" (U+0079)
  0x00, 0x7A, 0xFF, 0x01, 0x05, 0x08, 0x05, 0x0A, 0xB1, // "z" (U+007A)
  0x00, 0x7B, 0x00, 0xFE, 0x05, 0x0A, 0x05, 0x0A, 0xC8, // "{" (U+007B)
  0x00, 0x7C, 0x42, 0xFE, 0x03, 0x0B, 0x06, 0x0A, 0xEB, // "|" (U+007C)
  0x00, 0x7D, 0xFF, 0xFE, 0x04, 0x0A, 0x05, 0x0A, 0xF9, // "}" (U+007D)
  0x00, 0x7E, 0x40, 0x05, 0x06, 0x06, 0x07, 0x0B, 0x1C, // "~" (U+007E)
  0x00, 0xA1, 0xFF, 0xFE, 0x03, 0x08, 0x04, 0x0B, 0x23, // "¡" (U+00A1)
  0x00, 0xA2, 0x01, 0x01, 0x06, 0x0A, 0x07, 0x0B, 0x3E, // "¢" (U+00A2)
  0x00, 0xA3, 0xFF, 0x01, 0x06, 0x0A, 0x07, 0x0B, 0x5A, // "£" (U+00A3)
  0x00, 0xA4, 0x41, 0x02, 0x07, 0x09, 0x08, 0x0B, 0x7A, // "¤" (U+00A4)
  0x00, 0xA5, 0x00, 0x01, 0x07, 0x0A, 0x07, 0x0B, 0x96, // "¥" (U+00A5)
  0x00, 0xA6, 0x42, 0xFE, 0x03, 0x0B, 0x06, 0x0B, 0xBB, // "¦" (U+00A6)
  0x00, 0xA7, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x0B, 0xC9, // "§" (U+00A7)
  0x00, 0xA8, 0x42, 0x0B, 0x06, 0x0B, 0x07, 0x0B, 0xEA, // "¨" (U+00A8)
  0x00, 0xA9, 0x00, 0x00, 0x0B, 0x0B, 0x0C, 0x0B, 0xED, // "©" (U+00A9)
  0x00, 0xAA, 0x41, 0x07, 0x05, 0x0A, 0x04, 0x0C, 0x30, // "ª" (U+00AA)
  0x00, 0xAB, 0x40, 0x02, 0x06, 0x07, 0x07, 0x0C, 0x3A, // "«" (U+00AB)
  0x00, 0xAC, 0x00, 0x03, 0x06, 0x06, 0x07, 0x0C, 0x4F, // "¬" (U+00AC)
  0x00, 0xAE, 0x40, 0x00, 0x0B, 0x0B, 0x0C, 0x0C, 0x5C, // "®" (U+00AE)
  0x00, 0xAF, 0x41, 0x0B, 0x07, 0x0C, 0x06, 0x0C, 0xA4, // "¯" (U+00AF)
  0x00, 0xB0, 0x40, 0x08, 0x04, 0x0B, 0x06, 0x0C, 0xAB, // "°" (U+00B0)
  0x00, 0xB1, 0x00, 0x01, 0x06, 0x09, 0x07, 0x0C, 0xB5, // "±" (U+00B1)
  0x00, 0xB2, 0x40, 0x07, 0x05, 0x0D, 0x05, 0x0C, 0xCE, // "²" (U+00B2)
  0x00, 0xB3, 0x40, 0x07, 0x05, 0x0D, 0x05, 0x0C, 0xE3, // "³" (U+00B3)
  0x00, 0xB4, 0x41, 0x0A, 0x04, 0x0C, 0x04, 0x0C, 0xF8, // "´" (U+00B4)
  0x00, 0xB5, 0xBF, 0xFE, 0x06, 0x08, 0x07, 0x0C, 0xFE, // "µ" (U+00B5)
  0x00, 0xB6, 0x41, 0xFF, 0x06, 0x0B, 0x08, 0x0D, 0x2A, // "¶" (U+00B6)
  0x00, 0xB7, 0x41, 0x05, 0x02, 0x06, 0x03, 0x0D, 0x51, // "·" (U+00B7)
  0x00, 0xB8, 0xBE, 0xFD, 0x01, 0x00, 0x03, 0x0D, 0x53, // "¸" (U+00B8)
  0x00, 0xB9, 0x42, 0x07, 0x04, 0x0D, 0x05, 0x0D, 0x5B, // "¹" (U+00B9)
  0x00, 0xBA, 0x41, 0x07, 0x04, 0x0A, 0x04, 0x0D, 0x66, // "º" (U+00BA)
  0x00, 0xBB, 0x40, 0x02, 0x05, 0x07, 0x07, 0x0D, 0x6E, // "»" (U+00BB)
  0x00, 0xBC, 0x00, 0x01, 0x09, 0x0B, 0x0A, 0x0D, 0x80, // "¼" (U+00BC)
  0x00, 0xBD, 0x00, 0x01, 0x0A, 0x0B, 0x0B, 0x0D, 0xB5, // "½" (U+00BD)
  0x00, 0xBE, 0x00, 0x01, 0x0A, 0x0B, 0x0A, 0x0D, 0xEF, // "¾" (U+00BE)
  0x00, 0xBF, 0xFF, 0xFF, 0x04, 0x08, 0x05, 0x0E, 0x27, // "¿" (U+00BF)
  0x00, 0xC0, 0xFF, 0x01, 0x05, 0x0F, 0x07, 0x0E, 0x42, // "À" (U+00C0)
  0x00, 0xC1, 0xFF, 0x01, 0x06, 0x0F, 0x07, 0x0E, 0x6F, // "Á" (U+00C1)
  0x00, 0xC2, 0xFF, 0x01, 0x06, 0x0F, 0x07, 0x0E, 0xA0, // "Â" (U+00C2)
  0x00, 0xC3, 0xFF, 0x01, 0x07, 0x0E, 0x07, 0x0E, 0xD3, // "Ã" (U+00C3)
  0x00, 0xC4, 0xFF, 0x01, 0x06, 0x0E, 0x07, 0x0F, 0x05, // "Ä" (U+00C4)
  0x00, 0xC5, 0xFF, 0x01, 0x06, 0x0F, 0x07, 0x0F, 0x32, // "Å" (U+00C5)
  0x00, 0xC6, 0xFF, 0x01, 0x0A, 0x0A, 0x0A, 0x0F, 0x64, // "Æ" (U+00C6)
  0x00, 0xC7, 0x00, 0xFD, 0x07, 0x0A, 0x07, 0x0F, 0x90, // "Ç" (U+00C7)
  0x00, 0xC8, 0x00, 0x01, 0x06, 0x0F, 0x06, 0x0F, 0xBB, // "È" (U+00C8)
  0x00, 0xC9, 0x00, 0x01, 0x06, 0x0F, 0x06, 0x0F, 0xE0, // "É" (U+00C9)
  0x00, 0xCA, 0x00, 0x01, 0x06, 0x0F, 0x06, 0x10, 0x07, // "Ê" (U+00CA)
  0x00, 0xCB, 0x00, 0x01, 0x06, 0x0E, 0x06, 0x10, 0x2F, // "Ë" (U+00CB)
  0x00, 0xCC, 0xFF, 0x01, 0x05, 0x0F, 0x04, 0x10, 0x52, // "Ì" (U+00CC)
  0x00, 0xCD, 0xFF, 0x01, 0x05, 0x0F, 0x04, 0x10, 0x76, // "Í" (U+00CD)
  0x00, 0xCE, 0xFF, 0x01, 0x05, 0x0F, 0x04, 0x10, 0x9B, // "Î" (U+00CE)
  0x00, 0xCF, 0xFF, 0x01, 0x05, 0x0E, 0x04, 0x10, 0xC2, // "Ï" (U+00CF)
  0x00, 0xD0, 0x40, 0x01, 0x07, 0x0A, 0x08, 0x10, 0xE3, // "Ð" (U+00D0)
  0x00, 0xD1, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x11, 0x0B, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x00, 0x01, 0x08, 0x0F, 0x08, 0x11, 0x45, // "Ò" (U+00D2)
  0x00, 0xD3, 0x00, 0x01, 0x08, 0x0F, 0x08, 0x11, 0x7C, // "Ó" (U+00D3)
  0x00, 0xD4, 0x00, 0x01, 0x08, 0x0F, 0x08, 0x11, 0xB4, // "Ô" (U+00D4)
  0x00, 0xD5, 0x00, 0x01, 0x08, 0x0E, 0x08, 0x11, 0xED, // "Õ" (U+00D5)
  0x00, 0xD6, 0x00, 0x01, 0x08, 0x0E, 0x08, 0x12, 0x24, // "Ö" (U+00D6)
  0x00, 0xD7, 0x41, 0x03, 0x06, 0x08, 0x07, 0x12, 0x58, // "×" (U+00D7)
  0x00, 0xD8, 0x00, 0x00, 0x08, 0x0B, 0x08, 0x12, 0x6A, // "Ø" (U+00D8)
  0x00, 0xD9, 0x00, 0x01, 0x08, 0x0F, 0x08, 0x12, 0x9F, // "Ù" (U+00D9)
  0x00, 0xDA, 0x00, 0x01, 0x08, 0x0F, 0x08, 0x12, 0xD8, // "Ú" (U+00DA)
  0x00, 0xDB, 0x00, 0x01, 0x08, 0x0F, 0x08, 0x13, 0x12, // "Û" (U+00DB)
  0x00, 0xDC, 0x00, 0x01, 0x08, 0x0E, 0x08, 0x13, 0x4D, // "Ü" (U+00DC)
  0x00, 0xDD, 0x01, 0x01, 0x07, 0x0F, 0x06, 0x13, 0x83, // "Ý" (U+00DD)
  0x00, 0xDE, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x13, 0xAC, // "Þ" (U+00DE)
  0x00, 0xDF, 0xFE, 0xFE, 0x06, 0x0B, 0x07, 0x13, 0xCE, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x14, 0x06, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x14, 0x2D, // "á" (U+00E1)
  0x00, 0xE2, 0x40, 0x01, 0x06, 0x0C, 0x07, 0x14, 0x56, // "â" (U+00E2)
  0x00, 0xE3, 0x40, 0x01, 0x07, 0x0B, 0x07, 0x14, 0x80, // "ã" (U+00E3)
  0x00, 0xE4, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x14, 0xAC, // "ä" (U+00E4)
  0x00, 0xE5, 0x40, 0x01, 0x06, 0x0C, 0x07, 0x14, 0xD1, // "å" (U+00E5)
  0x00, 0xE6, 0x40, 0x01, 0x09, 0x08, 0x0A, 0x14, 0xFB, // "æ" (U+00E6)
  0x00, 0xE7, 0x00, 0xFD, 0x05, 0x08, 0x05, 0x15, 0x23, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x01, 0x05, 0x0C, 0x06, 0x15, 0x45, // "è" (U+00E8)
  0x00, 0xE9, 0x00, 0x01, 0x06, 0x0C, 0x06, 0x15, 0x65, // "é" (U+00E9)
  0x00, 0xEA, 0x00, 0x01, 0x06, 0x0C, 0x06, 0x15, 0x8A, // "ê" (U+00EA)
  0x00, 0xEB, 0x00, 0x01, 0x06, 0x0B, 0x06, 0x15, 0xB1, // "ë" (U+00EB)
  0x00, 0xEC, 0x40, 0x01, 0x03, 0x0C, 0x03, 0x15, 0xD2, // "ì" (U+00EC)
  0x00, 0xED, 0x00, 0x01, 0x04, 0x0C, 0x03, 0x15, 0xEA, // "í" (U+00ED)
  0x00, 0xEE, 0x40, 0x01, 0x04, 0x0C, 0x03, 0x16, 0x07, // "î" (U+00EE)
  0x00, 0xEF, 0x00, 0x01, 0x04, 0x0B, 0x03, 0x16, 0x25, // "ï" (U+00EF)
  0x00, 0xF0, 0x40, 0x01, 0x06, 0x0B, 0x07, 0x16, 0x3E, // "ð" (U+00F0)
  0x00, 0xF1, 0x40, 0x01, 0x07, 0x0B, 0x07, 0x16, 0x65, // "ñ" (U+00F1)
  0x00, 0xF2, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x16, 0x91, // "ò" (U+00F2)
  0x00, 0xF3, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x16, 0xB7, // "ó" (U+00F3)
  0x00, 0xF4, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x16, 0xDF, // "ô" (U+00F4)
  0x00, 0xF5, 0x40, 0x01, 0x06, 0x0B, 0x07, 0x17, 0x08, // "õ" (U+00F5)
  0x00, 0xF6, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x17, 0x2F, // "ö" (U+00F6)
  0x00, 0xF7, 0x00, 0x03, 0x06, 0x09, 0x07, 0x17, 0x53, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x00, 0x06, 0x09, 0x07, 0x17, 0x65, // "ø" (U+00F8)
  0x00, 0xF9, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x17, 0x85, // "ù" (U+00F9)
  0x00, 0xFA, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x17, 0xAD, // "ú" (U+00FA)
  0x00, 0xFB, 0x40, 0x01, 0x06, 0x0C, 0x07, 0x17, 0xD6, // "û" (U+00FB)
  0x00, 0xFC, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x18, 0x00, // "ü" (U+00FC)
  0x00, 0xFD, 0xFE, 0xFE, 0x06, 0x0C, 0x06, 0x18, 0x25, // "ý" (U+00FD)
  0x00, 0xFE, 0xFF, 0xFE, 0x06, 0x0B, 0x07, 0x18, 0x53, // "þ" (U+00FE)
  0x00, 0xFF, 0xFE, 0xFE, 0x06, 0x0B, 0x06, 0x18, 0x86, // "ÿ" (U+00FF)
  0x01, 0x00, 0xFF, 0x01, 0x06, 0x0D, 0x07, 0x18, 0xB0, // "Ā" (U+0100)
  0x01, 0x01, 0x40, 0x01, 0x06, 0x0A, 0x07, 0x18, 0xDE, // "ā" (U+0101)
  0x01, 0x02, 0xFF, 0x01, 0x06, 0x0E, 0x07, 0x19, 0x01, // "Ă" (U+0102)
  0x01, 0x03, 0x40, 0x01, 0x06, 0x0B, 0x07, 0x19, 0x31, // "ă" (U+0103)
  0x01, 0x04, 0xFF, 0xFD, 0x05, 0x0A, 0x07, 0x19, 0x58, // "Ą" (U+0104)
  0x01, 0x05, 0x00, 0xFD, 0x06, 0x08, 0x07, 0x19, 0x86, // "ą" (U+0105)
  0x01, 0x06, 0x00, 0x01, 0x07, 0x0F, 0x07, 0x19, 0xAF, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x01, 0x05, 0x0C, 0x05, 0x19, 0xD9, // "ć" (U+0107)
  0x01, 0x08, 0x00, 0x01, 0x07, 0x0F, 0x07, 0x19, 0xFA, // "Ĉ" (U+0108)
  0x01, 0x09, 0x00, 0x01, 0x05, 0x0C, 0x05, 0x1A, 0x26, // "ĉ" (U+0109)
  0x01, 0x0A, 0x00, 0x01, 0x07, 0x0E, 0x07, 0x1A, 0x48, // "Ċ" (U+010A)
  0x01, 0x0B, 0x00, 0x01, 0x05, 0x0B, 0x05, 0x1A, 0x6D, // "ċ" (U+010B)
  0x01, 0x0C, 0x00, 0x01, 0x07, 0x0F, 0x07, 0x1A, 0x88, // "Č" (U+010C)
  0x01, 0x0D, 0x00, 0x01, 0x06, 0x0C, 0x05, 0x1A, 0xB3, // "č" (U+010D)
  0x01, 0x0E, 0x00, 0x01, 0x07, 0x0F, 0x08, 0x1A, 0xD6, // "Ď" (U+010E)
  0x01, 0x0F, 0x00, 0x01, 0x09, 0x0B, 0x08, 0x1B, 0x0B, // "ď" (U+010F)
  0x01, 0x10, 0x40, 0x01, 0x07, 0x0A, 0x08, 0x1B, 0x3B, // "Đ" (U+0110)
  0x01, 0x11, 0x00, 0x01, 0x08, 0x0B, 0x07, 0x1B, 0x63, // "đ" (U+0111)
  0x01, 0x12, 0x00, 0x01, 0x06, 0x0D, 0x06, 0x1B, 0x92, // "Ē" (U+0112)
  0x01, 0x13, 0x00, 0x01, 0x06, 0x0A, 0x06, 0x1B, 0xB6, // "ē" (U+0113)
  0x01, 0x14, 0x00, 0x01, 0x06, 0x0E, 0x06, 0x1B, 0xD8, // "Ĕ" (U+0114)
  0x01, 0x15, 0x00, 0x01, 0x06, 0x0B, 0x06, 0x1B, 0xFD, // "ĕ" (U+0115)
  0x01, 0x16, 0x00, 0x01, 0x06, 0x0D, 0x06, 0x1C, 0x21, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x1C, 0x42, // "ė" (U+0117)
  0x01, 0x18, 0x00, 0xFD, 0x06, 0x0A, 0x06, 0x1C, 0x5E, // "Ę" (U+0118)
  0x01, 0x19, 0x40, 0xFE, 0x05, 0x08, 0x06, 0x1C, 0x85, // "ę" (U+0119)
  0x01, 0x1A, 0x00, 0x01, 0x06, 0x0F, 0x06, 0x1C, 0xA6, // "Ě" (U+011A)
  0x01, 0x1B, 0x00, 0x01, 0x06, 0x0C, 0x06, 0x1C, 0xCE, // "ě" (U+011B)
  0x01, 0x1C, 0x00, 0x01, 0x08, 0x0F, 0x08, 0x1C, 0xF4, // "Ĝ" (U+011C)
  0x01, 0x1D, 0xFF, 0xFE, 0x06, 0x0C, 0x07, 0x1D, 0x2B, // "ĝ" (U+011D)
  0x01, 0x1E, 0x00, 0x01, 0x08, 0x0E, 0x08, 0x1D, 0x65, // "Ğ" (U+011E)
  0x01, 0x1F, 0xFF, 0xFE, 0x06, 0x0B, 0x07, 0x1D, 0x99, // "ğ" (U+011F)
  0x01, 0x20, 0x00, 0x01, 0x08, 0x0E, 0x08, 0x1D, 0xD0, // "Ġ" (U+0120)
  0x01, 0x21, 0xFF, 0xFE, 0x06, 0x0B, 0x07, 0x1E, 0x00, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0xFE, 0x08, 0x0A, 0x08, 0x1E, 0x33, // "Ģ" (U+0122)
  0x01, 0x23, 0xFF, 0xFE, 0x06, 0x0B, 0x07, 0x1E, 0x66, // "ģ" (U+0123)
  0x01, 0x24, 0x00, 0x01, 0x08, 0x0F, 0x08, 0x1E, 0x9C, // "Ĥ" (U+0124)
  0x01, 0x25, 0x00, 0x01, 0x06, 0x0F, 0x07, 0x1E, 0xD9, // "ĥ" (U+0125)
  0x01, 0x26, 0x40, 0x01, 0x08, 0x0A, 0x08, 0x1F, 0x0A, // "Ħ" (U+0126)
  0x01, 0x27, 0x40, 0x01, 0x06, 0x0B, 0x07, 0x1F, 0x37, // "ħ" (U+0127)
  0x01, 0x28, 0xFF, 0x01, 0x06, 0x0E, 0x04, 0x1F, 0x5E, // "Ĩ" (U+0128)
  0x01, 0x29, 0x00, 0x01, 0x05, 0x0B, 0x03, 0x1F, 0x83, // "ĩ" (U+0129)
  0x01, 0x2A, 0xFF, 0x01, 0x05, 0x0D, 0x04, 0x1F, 0xA0, // "Ī" (U+012A)
  0x01, 0x2B, 0x40, 0x01, 0x04, 0x0A, 0x03, 0x1F, 0xC2, // "ī" (U+012B)
  0x01, 0x2C, 0xFF, 0x01, 0x05, 0x0E, 0x04, 0x1F, 0xDB, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x00, 0x01, 0x04, 0x0B, 0x03, 0x1F, 0xFF, // "ĭ" (U+012D)
  0x01, 0x2E, 0xFF, 0xFD, 0x05, 0x0A, 0x04, 0x20, 0x1A, // "Į" (U+012E)
  0x01, 0x2F, 0xFF, 0xFD, 0x03, 0x0B, 0x03, 0x20, 0x3F, // "į" (U+012F)
  0x01, 0x30, 0xFF, 0x01, 0x05, 0x0E, 0x04, 0x20, 0x61, // "İ" (U+0130)
  0x01, 0x31, 0x40, 0x01, 0x02, 0x08, 0x03, 0x20, 0x81, // "ı" (U+0131)
  0x01, 0x32, 0xFF, 0xFD, 0x07, 0x0A, 0x08, 0x20, 0x8D, // "Ĳ" (U+0132)
  0x01, 0x33, 0x00, 0xFE, 0x06, 0x0B, 0x06, 0x20, 0xC7, // "ĳ" (U+0133)
  0x01, 0x34, 0xFD, 0xFD, 0x04, 0x0F, 0x03, 0x20, 0xF5, // "Ĵ" (U+0134)
  0x01, 0x35, 0xFE, 0xFE, 0x04, 0x0C, 0x03, 0x21, 0x25, // "ĵ" (U+0135)
  0x01, 0x36, 0x00, 0xFE, 0x07, 0x0A, 0x07, 0x21, 0x4C, // "Ķ" (U+0136)
  0x01, 0x37, 0x00, 0xFE, 0x06, 0x0B, 0x06, 0x21, 0x7F, // "ķ" (U+0137)
  0x01, 0x38, 0x40, 0x01, 0x06, 0x08, 0x06, 0x21, 0xAD, // "ĸ" (U+0138)
  0x01, 0x39, 0x00, 0x01, 0x06, 0x0F, 0x06, 0x21, 0xC9, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x00, 0x01, 0x05, 0x0F, 0x03, 0x21, 0xEE, // "ĺ" (U+013A)
  0x01, 0x3B, 0x40, 0xFE, 0x04, 0x0A, 0x06, 0x22, 0x13, // "Ļ" (U+013B)
  0x01, 0x3C, 0xBF, 0xFE, 0x03, 0x0B, 0x03, 0x22, 0x34, // "ļ" (U+013C)
  0x01, 0x3D, 0x00, 0x01, 0x06, 0x0A, 0x06, 0x22, 0x57, // "Ľ" (U+013D)
  0x01, 0x3E, 0x00, 0x01, 0x05, 0x0B, 0x04, 0x22, 0x76, // "ľ" (U+013E)
  0x01, 0x3F, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x22, 0x95, // "Ŀ" (U+013F)
  0x01, 0x40, 0x40, 0x01, 0x04, 0x0B, 0x04, 0x22, 0xB1, // "ŀ" (U+0140)
  0x01, 0x41, 0x40, 0x01, 0x04, 0x0A, 0x06, 0x22, 0xCD, // "Ł" (U+0141)
  0x01, 0x42, 0x40, 0x01, 0x03, 0x0B, 0x03, 0x22, 0xE6, // "ł" (U+0142)
  0x01, 0x43, 0x00, 0x01, 0x08, 0x0F, 0x09, 0x22, 0xFC, // "Ń" (U+0143)
  0x01, 0x44, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x23, 0x37, // "ń" (U+0144)
  0x01, 0x45, 0x00, 0xFE, 0x08, 0x0A, 0x09, 0x23, 0x60, // "Ņ" (U+0145)
  0x01, 0x46, 0x40, 0xFE, 0x06, 0x08, 0x07, 0x23, 0x99, // "ņ" (U+0146)
  0x01, 0x47, 0x00, 0x01, 0x08, 0x0F, 0x09, 0x23, 0xC0, // "Ň" (U+0147)
  0x01, 0x48, 0x40, 0x01, 0x06, 0x0C, 0x07, 0x23, 0xFC, // "ň" (U+0148)
  0x01, 0x49, 0x40, 0x01, 0x07, 0x0A, 0x08, 0x24, 0x26, // "ŉ" (U+0149)
  0x01, 0x4A, 0x00, 0xFE, 0x08, 0x0A, 0x09, 0x24, 0x4E, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x40, 0xFE, 0x06, 0x08, 0x07, 0x24, 0x88, // "ŋ" (U+014B)
  0x01, 0x4C, 0x00, 0x01, 0x08, 0x0D, 0x08, 0x24, 0xAF, // "Ō" (U+014C)
  0x01, 0x4D, 0x40, 0x01, 0x06, 0x0A, 0x07, 0x24, 0xE3, // "ō" (U+014D)
  0x01, 0x4E, 0x00, 0x01, 0x08, 0x0E, 0x08, 0x25, 0x06, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x25, 0x3C, // "ŏ" (U+014F)
  0x01, 0x50, 0x00, 0x01, 0x08, 0x0F, 0x08, 0x25, 0x62, // "Ő" (U+0150)
  0x01, 0x51, 0x00, 0x01, 0x07, 0x0C, 0x07, 0x25, 0x9C, // "ő" (U+0151)
  0x01, 0x52, 0x00, 0x01, 0x0A, 0x0A, 0x0A, 0x25, 0xCA, // "Œ" (U+0152)
  0x01, 0x53, 0x40, 0x01, 0x0A, 0x08, 0x0B, 0x25, 0xF9, // "œ" (U+0153)
  0x01, 0x54, 0x00, 0x01, 0x07, 0x0F, 0x07, 0x26, 0x25, // "Ŕ" (U+0154)
  0x01, 0x55, 0x00, 0x01, 0x05, 0x0C, 0x05, 0x26, 0x5B, // "ŕ" (U+0155)
  0x01, 0x56, 0x40, 0xFE, 0x06, 0x0A, 0x07, 0x26, 0x7B, // "Ŗ" (U+0156)
  0x01, 0x57, 0x00, 0xFE, 0x05, 0x08, 0x05, 0x26, 0xA9, // "ŗ" (U+0157)
  0x01, 0x58, 0x00, 0x01, 0x06, 0x0F, 0x07, 0x26, 0xC8, // "Ř" (U+0158)
  0x01, 0x59, 0x00, 0x01, 0x05, 0x0C, 0x05, 0x26, 0xFA, // "ř" (U+0159)
  0x01, 0x5A, 0xFF, 0x01, 0x06, 0x0F, 0x06, 0x27, 0x1B, // "Ś" (U+015A)
  0x01, 0x5B, 0x00, 0x01, 0x05, 0x0C, 0x05, 0x27, 0x47, // "ś" (U+015B)
  0x01, 0x5C, 0xFF, 0x01, 0x06, 0x0F, 0x06, 0x27, 0x68, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x00, 0x01, 0x05, 0x0C, 0x05, 0x27, 0x95, // "ŝ" (U+015D)
  0x01, 0x5E, 0xFF, 0xFD, 0x06, 0x0A, 0x06, 0x27, 0xB7, // "Ş" (U+015E)
  0x01, 0x5F, 0xFF, 0xFD, 0x05, 0x08, 0x05, 0x27, 0xE4, // "ş" (U+015F)
  0x01, 0x60, 0xFF, 0x01, 0x06, 0x0F, 0x06, 0x28, 0x09, // "Š" (U+0160)
  0x01, 0x61, 0x00, 0x01, 0x05, 0x0C, 0x05, 0x28, 0x36, // "š" (U+0161)
  0x01, 0x62, 0xFF, 0xFD, 0x06, 0x0A, 0x06, 0x28, 0x58, // "Ţ" (U+0162)
  0x01, 0x63, 0xFF, 0xFD, 0x04, 0x0A, 0x04, 0x28, 0x7E, // "ţ" (U+0163)
  0x01, 0x64, 0x01, 0x01, 0x06, 0x0F, 0x06, 0x28, 0xA5, // "Ť" (U+0164)
  0x01, 0x65, 0x00, 0x01, 0x05, 0x0B, 0x04, 0x28, 0xCA, // "ť" (U+0165)
  0x01, 0x66, 0x01, 0x01, 0x06, 0x0A, 0x06, 0x28, 0xEA, // "Ŧ" (U+0166)
  0x01, 0x67, 0x40, 0x01, 0x04, 0x0A, 0x04, 0x29, 0x06, // "ŧ" (U+0167)
  0x01, 0x68, 0x00, 0x01, 0x08, 0x0E, 0x08, 0x29, 0x1F, // "Ũ" (U+0168)
  0x01, 0x69, 0x40, 0x01, 0x07, 0x0B, 0x07, 0x29, 0x58, // "ũ" (U+0169)
  0x01, 0x6A, 0x00, 0x01, 0x08, 0x0D, 0x08, 0x29, 0x84, // "Ū" (U+016A)
  0x01, 0x6B, 0x40, 0x01, 0x06, 0x0A, 0x07, 0x29, 0xBB, // "ū" (U+016B)
  0x01, 0x6C, 0x00, 0x01, 0x08, 0x0E, 0x08, 0x29, 0xDE, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x40, 0x01, 0x06, 0x0B, 0x07, 0x2A, 0x16, // "ŭ" (U+016D)
  0x01, 0x6E, 0x00, 0x01, 0x08, 0x0F, 0x08, 0x2A, 0x3D, // "Ů" (U+016E)
  0x01, 0x6F, 0x40, 0x01, 0x06, 0x0C, 0x07, 0x2A, 0x78, // "ů" (U+016F)
  0x01, 0x70, 0x00, 0x01, 0x08, 0x0F, 0x08, 0x2A, 0xA2, // "Ű" (U+0170)
  0x01, 0x71, 0x40, 0x01, 0x07, 0x0C, 0x07, 0x2A, 0xDE, // "ű" (U+0171)
  0x01, 0x72, 0x00, 0xFD, 0x08, 0x0A, 0x08, 0x2B, 0x0E, // "Ų" (U+0172)
  0x01, 0x73, 0x40, 0xFD, 0x06, 0x08, 0x07, 0x2B, 0x48, // "ų" (U+0173)
  0x01, 0x74, 0x01, 0x01, 0x0B, 0x0F, 0x0B, 0x2B, 0x72, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x09, 0x0C, 0x09, 0x2B, 0xBA, // "ŵ" (U+0175)
  0x01, 0x76, 0x01, 0x01, 0x07, 0x0F, 0x06, 0x2B, 0xEF, // "Ŷ" (U+0176)
  0x01, 0x77, 0xFE, 0xFE, 0x06, 0x0C, 0x06, 0x2C, 0x19, // "ŷ" (U+0177)
  0x01, 0x78, 0x01, 0x01, 0x07, 0x0E, 0x06, 0x2C, 0x49, // "Ÿ" (U+0178)
  0x01, 0x79, 0xFF, 0x01, 0x06, 0x0F, 0x06, 0x2C, 0x6E, // "Ź" (U+0179)
  0x01, 0x7A, 0xFF, 0x01, 0x05, 0x0C, 0x05, 0x2C, 0x94, // "ź" (U+017A)
  0x01, 0x7B, 0xFF, 0x01, 0x06, 0x0E, 0x06, 0x2C, 0xB4, // "Ż" (U+017B)
  0x01, 0x7C, 0xFF, 0x01, 0x05, 0x0B, 0x05, 0x2C, 0xD4, // "ż" (U+017C)
  0x01, 0x7D, 0xFF, 0x01, 0x06, 0x0F, 0x06, 0x2C, 0xEE, // "Ž" (U+017D)
  0x01, 0x7E, 0xFF, 0x01, 0x05, 0x0C, 0x05, 0x2D, 0x15, // "ž" (U+017E)
  0x01, 0x7F, 0xFE, 0xFE, 0x05, 0x0B, 0x03, 0x2D, 0x36, // "ſ" (U+017F)
  0x03, 0xA9, 0xBF, 0x01, 0x08, 0x0A, 0x09, 0x2D, 0x5B, // "Ω" (U+03A9)
  0x03, 0xBC, 0xBF, 0xFE, 0x06, 0x08, 0x07, 0x2D, 0x8D, // "μ" (U+03BC)
  0x03, 0xC0, 0x40, 0x01, 0x07, 0x08, 0x07, 0x2D, 0xB9, // "π" (U+03C0)
  0x20, 0x13, 0x40, 0x04, 0x06, 0x05, 0x07, 0x2D, 0xD9, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x04, 0x0D, 0x05, 0x0E, 0x2D, 0xE0, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x01, 0x07, 0x0A, 0x07, 0x2D, 0xE8, // "€" (U+20AC)
  0x20, 0xBF, 0x40, 0xFF, 0x06, 0x0C, 0x07, 0x2E, 0x0D, // "₿" (U+20BF)
  0x20, 0x18, 0x41, 0x07, 0x03, 0x0A, 0x03, 0x2E, 0x3E, // "‘" (U+2018)
  0x20, 0x19, 0x41, 0x07, 0x03, 0x0A, 0x03, 0x2E, 0x44, // "’" (U+2019)
  0x20, 0x1A, 0xBF, 0xFF, 0x01, 0x02, 0x03, 0x2E, 0x4A, // "‚" (U+201A)
  0x20, 0x1B, 0x41, 0x08, 0x02, 0x0A, 0x03, 0x2E, 0x50, // "‛" (U+201B)
  0x20, 0x1C, 0x41, 0x08, 0x05, 0x0A, 0x05, 0x2E, 0x53, // "“" (U+201C)
  0x20, 0x1D, 0x41, 0x08, 0x05, 0x0A, 0x05, 0x2E, 0x5B, // "”" (U+201D)
  0x20, 0x1E, 0xBF, 0xFF, 0x04, 0x02, 0x05, 0x2E, 0x63, // "„" (U+201E)
  0x20, 0x1F, 0x41, 0x08, 0x05, 0x0A, 0x05, 0x2E, 0x6F, // "‟" (U+201F)
  0x20, 0x20, 0x01, 0x01, 0x06, 0x0B, 0x06, 0x2E, 0x77, // "†" (U+2020)
  0x20, 0x21, 0x00, 0x01, 0x06, 0x0B, 0x06, 0x2E, 0x96, // "‡" (U+2021)
  0x20, 0x22, 0x41, 0x04, 0x04, 0x07, 0x05, 0x2E, 0xB9, // "•" (U+2022)
  0x20, 0x26, 0x40, 0x01, 0x08, 0x02, 0x0A, 0x2E, 0xC1, // "…" (U+2026)
  0x20, 0x30, 0x40, 0x01, 0x0D, 0x0A, 0x0E, 0x2E, 0xCA, // "‰" (U+2030)
  0x20, 0x39, 0x40, 0x02, 0x03, 0x07, 0x04, 0x2F, 0x10, // "‹" (U+2039)
  0x20, 0x3A, 0x40, 0x02, 0x03, 0x07, 0x04, 0x2F, 0x1C, // "›" (U+203A)
  0x20, 0x44, 0xFC, 0x01, 0x05, 0x0A, 0x02, 0x2F, 0x28, // "⁄" (U+2044)
  0x21, 0x22, 0x40, 0x06, 0x09, 0x0B, 0x0A, 0x2F, 0x43, // "™" (U+2122)
  0x21, 0x52, 0x00, 0x01, 0x0E, 0x0B, 0x0E, 0x2F, 0x61, // "⅒" (U+2152)
  0xFB, 0x01, 0xFE, 0xFE, 0x07, 0x0B, 0x07, 0x2F, 0xAB, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0xFE, 0xFE, 0x07, 0x0B, 0x07, 0x2F, 0xE5, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x01, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0x61, 0x01, // "a (U+0022 U+0061)
  0x00, 0x22, 0x00, 0x63, 0x01, // "c (U+0022 U+0063)
  0x00, 0x22, 0x00, 0x64, 0x01, // "d (U+0022 U+0064)
  0x00, 0x22, 0x00, 0x65, 0x01, // "e (U+0022 U+0065)
  0x00, 0x22, 0x00, 0x6F, 0x01, // "o (U+0022 U+006F)
  0x00, 0x22, 0x00, 0x71, 0x01, // "q (U+0022 U+0071)
  0x00, 0x22, 0x00, 0xC0, 0x01, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x01, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x01, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x01, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x01, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x01, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xE0, 0x01, // "à (U+0022 U+00E0)
  0x00, 0x22, 0x00, 0xE1, 0x01, // "á (U+0022 U+00E1)
  0x00, 0x22, 0x00, 0xE2, 0x01, // "â (U+0022 U+00E2)
  0x00, 0x22, 0x00, 0xE3, 0x01, // "ã (U+0022 U+00E3)
  0x00, 0x22, 0x00, 0xE4, 0x01, // "ä (U+0022 U+00E4)
  0x00, 0x22, 0x00, 0xE5, 0x01, // "å (U+0022 U+00E5)
  0x00, 0x22, 0x00, 0xE6, 0x01, // "æ (U+0022 U+00E6)
  0x00, 0x22, 0x00, 0xE7, 0x01, // "ç (U+0022 U+00E7)
  0x00, 0x22, 0x00, 0xE8, 0x01, // "è (U+0022 U+00E8)
  0x00, 0x22, 0x00, 0xE9, 0x01, // "é (U+0022 U+00E9)
  0x00, 0x22, 0x00, 0xEA, 0x01, // "ê (U+0022 U+00EA)
  0x00, 0x22, 0x00, 0xEB, 0x01, // "ë (U+0022 U+00EB)
  0x00, 0x22, 0x00, 0xF2, 0x01, // "ò (U+0022 U+00F2)
  0x00, 0x22, 0x00, 0xF3, 0x01, // "ó (U+0022 U+00F3)
  0x00, 0x22, 0x00, 0xF4, 0x01, // "ô (U+0022 U+00F4)
  0x00, 0x22, 0x00, 0xF5, 0x01, // "õ (U+0022 U+00F5)
  0x00, 0x22, 0x00, 0xF6, 0x01, // "ö (U+0022 U+00F6)
  0x00, 0x22, 0x00, 0xF8, 0x01, // "ø (U+0022 U+00F8)
  0x00, 0x22, 0x01, 0x00, 0x01, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x01, 0x01, // "ā (U+0022 U+0101)
  0x00, 0x22, 0x01, 0x02, 0x01, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x03, 0x01, // "ă (U+0022 U+0103)
  0x00, 0x22, 0x01, 0x04, 0x01, // "Ą (U+0022 U+0104)
  0x00, 0x22, 0x01, 0x05, 0x01, // "ą (U+0022 U+0105)
  0x00, 0x22, 0x01, 0x07, 0x01, // "ć (U+0022 U+0107)
  0x00, 0x22, 0x01, 0x09, 0x01, // "ĉ (U+0022 U+0109)
  0x00, 0x22, 0x01, 0x0B, 0x01, // "ċ (U+0022 U+010B)
  0x00, 0x22, 0x01, 0x0D, 0x01, // "č (U+0022 U+010D)
  0x00, 0x22, 0x01, 0x0F, 0x01, // "ď (U+0022 U+010F)
  0x00, 0x22, 0x01, 0x11, 0x01, // "đ (U+0022 U+0111)
  0x00, 0x22, 0x01, 0x13, 0x01, // "ē (U+0022 U+0113)
  0x00, 0x22, 0x01, 0x15, 0x01, // "ĕ (U+0022 U+0115)
  0x00, 0x22, 0x01, 0x17, 0x01, // "ė (U+0022 U+0117)
  0x00, 0x22, 0x01, 0x19, 0x01, // "ę (U+0022 U+0119)
  0x00, 0x22, 0x01, 0x1B, 0x01, // "ě (U+0022 U+011B)
  0x00, 0x22, 0x01, 0x4D, 0x01, // "ō (U+0022 U+014D)
  0x00, 0x22, 0x01, 0x4F, 0x01, // "ŏ (U+0022 U+014F)
  0x00, 0x22, 0x01, 0x51, 0x01, // "ő (U+0022 U+0151)
  0x00, 0x22, 0x01, 0x53, 0x01, // "œ (U+0022 U+0153)
  0x00, 0x26, 0x00, 0x54, 0x01, // &T (U+0026 U+0054)
  0x00, 0x26, 0x00, 0x59, 0x01, // &Y (U+0026 U+0059)
  0x00, 0x26, 0x00, 0xDD, 0x01, // &Ý (U+0026 U+00DD)
  0x00, 0x26, 0x01, 0x62, 0x01, // &Ţ (U+0026 U+0162)
  0x00, 0x26, 0x01, 0x64, 0x01, // &Ť (U+0026 U+0164)
  0x00, 0x26, 0x01, 0x66, 0x01, // &Ŧ (U+0026 U+0166)
  0x00, 0x26, 0x01, 0x76, 0x01, // &Ŷ (U+0026 U+0176)
  0x00, 0x26, 0x01, 0x78, 0x01, // &Ÿ (U+0026 U+0178)
  0x00, 0x27, 0x00, 0x41, 0x01, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0x61, 0x01, // 'a (U+0027 U+0061)
  0x00, 0x27, 0x00, 0x63, 0x01, // 'c (U+0027 U+0063)
  0x00, 0x27, 0x00, 0x64, 0x01, // 'd (U+0027 U+0064)
  0x00, 0x27, 0x00, 0x65, 0x01, // 'e (U+0027 U+0065)
  0x00, 0x27, 0x00, 0x6F, 0x01, // 'o (U+0027 U+006F)
  0x00, 0x27, 0x00, 0x71, 0x01, // 'q (U+0027 U+0071)
  0x00, 0x27, 0x00, 0xC0, 0x01, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x01, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x01, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x01, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x01, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x01, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xE0, 0x01, // 'à (U+0027 U+00E0)
  0x00, 0x27, 0x00, 0xE1, 0x01, // 'á (U+0027 U+00E1)
  0x00, 0x27, 0x00, 0xE2, 0x01, // 'â (U+0027 U+00E2)
  0x00, 0x27, 0x00, 0xE3, 0x01, // 'ã (U+0027 U+00E3)
  0x00, 0x27, 0x00, 0xE4, 0x01, // 'ä (U+0027 U+00E4)
  0x00, 0x27, 0x00, 0xE5, 0x01, // 'å (U+0027 U+00E5)
  0x00, 0x27, 0x00, 0xE6, 0x01, // 'æ (U+0027 U+00E6)
  0x00, 0x27, 0x00, 0xE7, 0x01, // 'ç (U+0027 U+00E7)
  0x00, 0x27, 0x00, 0xE8, 0x01, // 'è (U+0027 U+00E8)
  0x00, 0x27, 0x00, 0xE9, 0x01, // 'é (U+0027 U+00E9)
  0x00, 0x27, 0x00, 0xEA, 0x01, // 'ê (U+0027 U+00EA)
  0x00, 0x27, 0x00, 0xEB, 0x01, // 'ë (U+0027 U+00EB)
  0x00, 0x27, 0x00, 0xF2, 0x01, // 'ò (U+0027 U+00F2)
  0x00, 0x27, 0x00, 0xF3, 0x01, // 'ó (U+0027 U+00F3)
  0x00, 0x27, 0x00, 0xF4, 0x01, // 'ô (U+0027 U+00F4)
  0x00, 0x27, 0x00, 0xF5, 0x01, // 'õ (U+0027 U+00F5)
  0x00, 0x27, 0x00, 0xF6, 0x01, // 'ö (U+0027 U+00F6)
  0x00, 0x27, 0x00, 0xF8, 0x01, // 'ø (U+0027 U+00F8)
  0x00, 0x27, 0x01, 0x00, 0x01, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x01, 0x01, // 'ā (U+0027 U+0101)
  0x00, 0x27, 0x01, 0x02, 0x01, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x03, 0x01, // 'ă (U+0027 U+0103)
  0x00, 0x27, 0x01, 0x04, 0x01, // 'Ą (U+0027 U+0104)
  0x00, 0x27, 0x01, 0x05, 0x01, // 'ą (U+0027 U+0105)
  0x00, 0x27, 0x01, 0x07, 0x01, // 'ć (U+0027 U+0107)
  0x00, 0x27, 0x01, 0x09, 0x01, // 'ĉ (U+0027 U+0109)
  0x00, 0x27, 0x01, 0x0B, 0x01, // 'ċ (U+0027 U+010B)
  0x00, 0x27, 0x01, 0x0D, 0x01, // 'č (U+0027 U+010D)
  0x00, 0x27, 0x01, 0x0F, 0x01, // 'ď (U+0027 U+010F)
  0x00, 0x27, 0x01, 0x11, 0x01, // 'đ (U+0027 U+0111)
  0x00, 0x27, 0x01, 0x13, 0x01, // 'ē (U+0027 U+0113)
  0x00, 0x27, 0x01, 0x15, 0x01, // 'ĕ (U+0027 U+0115)
  0x00, 0x27, 0x01, 0x17, 0x01, // 'ė (U+0027 U+0117)
  0x00, 0x27, 0x01, 0x19, 0x01, // 'ę (U+0027 U+0119)
  0x00, 0x27, 0x01, 0x1B, 0x01, // 'ě (U+0027 U+011B)
  0x00, 0x27, 0x01, 0x4D, 0x01, // 'ō (U+0027 U+014D)
  0x00, 0x27, 0x01, 0x4F, 0x01, // 'ŏ (U+0027 U+014F)
  0x00, 0x27, 0x01, 0x51, 0x01, // 'ő (U+0027 U+0151)
  0x00, 0x27, 0x01, 0x53, 0x01, // 'œ (U+0027 U+0153)
  0x00, 0x2C, 0x00, 0x43, 0x01, // ,C (U+002C U+0043)
  0x00, 0x2C, 0x00, 0x47, 0x01, // ,G (U+002C U+0047)
  0x00, 0x2C, 0x00, 0x4F, 0x01, // ,O (U+002C U+004F)
  0x00, 0x2C, 0x00, 0x51, 0x01, // ,Q (U+002C U+0051)
  0x00, 0x2C, 0x00, 0x54, 0x01, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x56, 0x01, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x01, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x01, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0xC7, 0x01, // ,Ç (U+002C U+00C7)
  0x00, 0x2C, 0x00, 0xD2, 0x01, // ,Ò (U+002C U+00D2)
  0x00, 0x2C, 0x00, 0xD3, 0x01, // ,Ó (U+002C U+00D3)
  0x00, 0x2C, 0x00, 0xD4, 0x01, // ,Ô (U+002C U+00D4)
  0x00, 0x2C, 0x00, 0xD5, 0x01, // ,Õ (U+002C U+00D5)
  0x00, 0x2C, 0x00, 0xD6, 0x01, // ,Ö (U+002C U+00D6)
  0x00, 0x2C, 0x00, 0xD8, 0x01, // ,Ø (U+002C U+00D8)
  0x00, 0x2C, 0x00, 0xDD, 0x01, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x01, 0x06, 0x01, // ,Ć (U+002C U+0106)
  0x00, 0x2C, 0x01, 0x08, 0x01, // ,Ĉ (U+002C U+0108)
  0x00, 0x2C, 0x01, 0x0A, 0x01, // ,Ċ (U+002C U+010A)
  0x00, 0x2C, 0x01, 0x0C, 0x01, // ,Č (U+002C U+010C)
  0x00, 0x2C, 0x01, 0x1C, 0x01, // ,Ĝ (U+002C U+011C)
  0x00, 0x2C, 0x01, 0x1E, 0x01, // ,Ğ (U+002C U+011E)
  0x00, 0x2C, 0x01, 0x20, 0x01, // ,Ġ (U+002C U+0120)
  0x00, 0x2C, 0x01, 0x22, 0x01, // ,Ģ (U+002C U+0122)
  0x00, 0x2C, 0x01, 0x4C, 0x01, // ,Ō (U+002C U+014C)
  0x00, 0x2C, 0x01, 0x4E, 0x01, // ,Ŏ (U+002C U+014E)
  0x00, 0x2C, 0x01, 0x50, 0x01, // ,Ő (U+002C U+0150)
  0x00, 0x2C, 0x01, 0x52, 0x01, // ,Œ (U+002C U+0152)
  0x00, 0x2C, 0x01, 0x62, 0x01, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x01, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x01, // ,Ŧ (U+002C U+0166)
  0x00, 0x2C, 0x01, 0x74, 0x01, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x76, 0x01, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x78, 0x01, // ,Ÿ (U+002C U+0178)
  0x00, 0x2D, 0x00, 0x54, 0x01, // -T (U+002D U+0054)
  0x00, 0x2D, 0x01, 0x62, 0x01, // -Ţ (U+002D U+0162)
  0x00, 0x2D, 0x01, 0x64, 0x01, // -Ť (U+002D U+0164)
  0x00, 0x2D, 0x01, 0x66, 0x01, // -Ŧ (U+002D U+0166)
  0x00, 0x2E, 0x00, 0x43, 0x01, // .C (U+002E U+0043)
  0x00, 0x2E, 0x00, 0x47, 0x01, // .G (U+002E U+0047)
  0x00, 0x2E, 0x00, 0x4F, 0x01, // .O (U+002E U+004F)
  0x00, 0x2E, 0x00, 0x51, 0x01, // .Q (U+002E U+0051)
  0x00, 0x2E, 0x00, 0x54, 0x01, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x56, 0x01, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x01, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x01, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0xC7, 0x01, // .Ç (U+002E U+00C7)
  0x00, 0x2E, 0x00, 0xD2, 0x01, // .Ò (U+002E U+00D2)
  0x00, 0x2E, 0x00, 0xD3, 0x01, // .Ó (U+002E U+00D3)
  0x00, 0x2E, 0x00, 0xD4, 0x01, // .Ô (U+002E U+00D4)
  0x00, 0x2E, 0x00, 0xD5, 0x01, // .Õ (U+002E U+00D5)
  0x00, 0x2E, 0x00, 0xD6, 0x01, // .Ö (U+002E U+00D6)
  0x00, 0x2E, 0x00, 0xD8, 0x01, // .Ø (U+002E U+00D8)
  0x00, 0x2E, 0x00, 0xDD, 0x01, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x01, 0x06, 0x01, // .Ć (U+002E U+0106)
  0x00, 0x2E, 0x01, 0x08, 0x01, // .Ĉ (U+002E U+0108)
  0x00, 0x2E, 0x01, 0x0A, 0x01, // .Ċ (U+002E U+010A)
  0x00, 0x2E, 0x01, 0x0C, 0x01, // .Č (U+002E U+010C)
  0x00, 0x2E, 0x01, 0x1C, 0x01, // .Ĝ (U+002E U+011C)
  0x00, 0x2E, 0x01, 0x1E, 0x01, // .Ğ (U+002E U+011E)
  0x00, 0x2E, 0x01, 0x20, 0x01, // .Ġ (U+002E U+0120)
  0x00, 0x2E, 0x01, 0x22, 0x01, // .Ģ (U+002E U+0122)
  0x00, 0x2E, 0x01, 0x4C, 0x01, // .Ō (U+002E U+014C)
  0x00, 0x2E, 0x01, 0x4E, 0x01, // .Ŏ (U+002E U+014E)
  0x00, 0x2E, 0x01, 0x50, 0x01, // .Ő (U+002E U+0150)
  0x00, 0x2E, 0x01, 0x52, 0x01, // .Œ (U+002E U+0152)
  0x00, 0x2E, 0x01, 0x62, 0x01, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x01, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x01, // .Ŧ (U+002E U+0166)
  0x00, 0x2E, 0x01, 0x74, 0x01, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x76, 0x01, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x78, 0x01, // .Ÿ (U+002E U+0178)
  0x00, 0x41, 0x00, 0x22, 0x01, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x01, // A' (U+0041 U+0027)
  0x00, 0x41, 0x20, 0x19, 0x01, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1D, 0x01, // A” (U+0041 U+201D)
  0x00, 0x44, 0x00, 0x2C, 0x01, // D, (U+0044 U+002C)
  0x00, 0x44, 0x00, 0x2E, 0x01, // D. (U+0044 U+002E)
  0x00, 0x44, 0x20, 0x1A, 0x01, // D‚ (U+0044 U+201A)
  0x00, 0x44, 0x20, 0x1E, 0x01, // D„ (U+0044 U+201E)
  0x00, 0x44, 0x20, 0x26, 0x01, // D… (U+0044 U+2026)
  0x00, 0x46, 0x00, 0x2C, 0x01, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x01, // F. (U+0046 U+002E)
  0x00, 0x46, 0x20, 0x1A, 0x01, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x01, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x01, // F… (U+0046 U+2026)
  0x00, 0x4C, 0x00, 0x22, 0x01, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x01, // L' (U+004C U+0027)
  0x00, 0x4C, 0x00, 0x54, 0x01, // LT (U+004C U+0054)
  0x00, 0x4C, 0x00, 0x59, 0x01, // LY (U+004C U+0059)
  0x00, 0x4C, 0x00, 0xAB, 0x01, // L« (U+004C U+00AB)
  0x00, 0x4C, 0x00, 0xDD, 0x01, // LÝ (U+004C U+00DD)
  0x00, 0x4C, 0x01, 0x62, 0x01, // LŢ (U+004C U+0162)
  0x00, 0x4C, 0x01, 0x64, 0x01, // LŤ (U+004C U+0164)
  0x00, 0x4C, 0x01, 0x66, 0x01, // LŦ (U+004C U+0166)
  0x00, 0x4C, 0x01, 0x76, 0x01, // LŶ (U+004C U+0176)
  0x00, 0x4C, 0x01, 0x78, 0x01, // LŸ (U+004C U+0178)
  0x00, 0x4C, 0x20, 0x19, 0x01, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1D, 0x01, // L” (U+004C U+201D)
  0x00, 0x4C, 0x20, 0x39, 0x01, // L‹ (U+004C U+2039)
  0x00, 0x4F, 0x00, 0x2C, 0x01, // O, (U+004F U+002C)
  0x00, 0x4F, 0x00, 0x2E, 0x01, // O. (U+004F U+002E)
  0x00, 0x4F, 0x20, 0x1A, 0x01, // O‚ (U+004F U+201A)
  0x00, 0x4F, 0x20, 0x1E, 0x01, // O„ (U+004F U+201E)
  0x00, 0x4F, 0x20, 0x26, 0x01, // O… (U+004F U+2026)
  0x00, 0x50, 0x00, 0x2C, 0x02, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x02, // P. (U+0050 U+002E)
  0x00, 0x50, 0x20, 0x1A, 0x02, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x02, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x02, // P… (U+0050 U+2026)
  0x00, 0x51, 0x00, 0x2C, 0x01, // Q, (U+0051 U+002C)
  0x00, 0x51, 0x00, 0x2E, 0x01, // Q. (U+0051 U+002E)
  0x00, 0x51, 0x20, 0x1A, 0x01, // Q‚ (U+0051 U+201A)
  0x00, 0x51, 0x20, 0x1E, 0x01, // Q„ (U+0051 U+201E)
  0x00, 0x51, 0x20, 0x26, 0x01, // Q… (U+0051 U+2026)
  0x00, 0x54, 0x00, 0x2C, 0x01, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2D, 0x01, // T- (U+0054 U+002D)
  0x00, 0x54, 0x00, 0x2E, 0x01, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0x61, 0x01, // Ta (U+0054 U+0061)
  0x00, 0x54, 0x00, 0x63, 0x01, // Tc (U+0054 U+0063)
  0x00, 0x54, 0x00, 0x64, 0x01, // Td (U+0054 U+0064)
  0x00, 0x54, 0x00, 0x65, 0x01, // Te (U+0054 U+0065)
  0x00, 0x54, 0x00, 0x67, 0x01, // Tg (U+0054 U+0067)
  0x00, 0x54, 0x00, 0x6D, 0x01, // Tm (U+0054 U+006D)
  0x00, 0x54, 0x00, 0x6E, 0x01, // Tn (U+0054 U+006E)
  0x00, 0x54, 0x00, 0x6F, 0x01, // To (U+0054 U+006F)
  0x00, 0x54, 0x00, 0x70, 0x01, // Tp (U+0054 U+0070)
  0x00, 0x54, 0x00, 0x71, 0x01, // Tq (U+0054 U+0071)
  0x00, 0x54, 0x00, 0x72, 0x01, // Tr (U+0054 U+0072)
  0x00, 0x54, 0x00, 0x73, 0x01, // Ts (U+0054 U+0073)
  0x00, 0x54, 0x00, 0x75, 0x01, // Tu (U+0054 U+0075)
  0x00, 0x54, 0x00, 0xAB, 0x01, // T« (U+0054 U+00AB)
  0x00, 0x54, 0x00, 0xE0, 0x01, // Tà (U+0054 U+00E0)
  0x00, 0x54, 0x00, 0xE1, 0x01, // Tá (U+0054 U+00E1)
  0x00, 0x54, 0x00, 0xE2, 0x01, // Tâ (U+0054 U+00E2)
  0x00, 0x54, 0x00, 0xE3, 0x01, // Tã (U+0054 U+00E3)
  0x00, 0x54, 0x00, 0xE4, 0x01, // Tä (U+0054 U+00E4)
  0x00, 0x54, 0x00, 0xE5, 0x01, // Tå (U+0054 U+00E5)
  0x00, 0x54, 0x00, 0xE6, 0x01, // Tæ (U+0054 U+00E6)
  0x00, 0x54, 0x00, 0xE7, 0x01, // Tç (U+0054 U+00E7)
  0x00, 0x54, 0x00, 0xE8, 0x01, // Tè (U+0054 U+00E8)
  0x00, 0x54, 0x00, 0xE9, 0x01, // Té (U+0054 U+00E9)
  0x00, 0x54, 0x00, 0xEA, 0x01, // Tê (U+0054 U+00EA)
  0x00, 0x54, 0x00, 0xEB, 0x01, // Të (U+0054 U+00EB)
  0x00, 0x54, 0x00, 0xF1, 0x01, // Tñ (U+0054 U+00F1)
  0x00, 0x54, 0x00, 0xF2, 0x01, // Tò (U+0054 U+00F2)
  0x00, 0x54, 0x00, 0xF3, 0x01, // Tó (U+0054 U+00F3)
  0x00, 0x54, 0x00, 0xF4, 0x01, // Tô (U+0054 U+00F4)
  0x00, 0x54, 0x00, 0xF5, 0x01, // Tõ (U+0054 U+00F5)
  0x00, 0x54, 0x00, 0xF6, 0x01, // Tö (U+0054 U+00F6)
  0x00, 0x54, 0x00, 0xF8, 0x01, // Tø (U+0054 U+00F8)
  0x00, 0x54, 0x00, 0xF9, 0x01, // Tù (U+0054 U+00F9)
  0x00, 0x54, 0x00, 0xFA, 0x01, // Tú (U+0054 U+00FA)
  0x00, 0x54, 0x00, 0xFB, 0x01, // Tû (U+0054 U+00FB)
  0x00, 0x54, 0x00, 0xFC, 0x01, // Tü (U+0054 U+00FC)
  0x00, 0x54, 0x01, 0x01, 0x01, // Tā (U+0054 U+0101)
  0x00, 0x54, 0x01, 0x03, 0x01, // Tă (U+0054 U+0103)
  0x00, 0x54, 0x01, 0x05, 0x01, // Tą (U+0054 U+0105)
  0x00, 0x54, 0x01, 0x07, 0x01, // Tć (U+0054 U+0107)
  0x00, 0x54, 0x01, 0x09, 0x01, // Tĉ (U+0054 U+0109)
  0x00, 0x54, 0x01, 0x0B, 0x01, // Tċ (U+0054 U+010B)
  0x00, 0x54, 0x01, 0x0D, 0x01, // Tč (U+0054 U+010D)
  0x00, 0x54, 0x01, 0x0F, 0x01, // Tď (U+0054 U+010F)
  0x00, 0x54, 0x01, 0x11, 0x01, // Tđ (U+0054 U+0111)
  0x00, 0x54, 0x01, 0x13, 0x01, // Tē (U+0054 U+0113)
  0x00, 0x54, 0x01, 0x15, 0x01, // Tĕ (U+0054 U+0115)
  0x00, 0x54, 0x01, 0x17, 0x01, // Tė (U+0054 U+0117)
  0x00, 0x54, 0x01, 0x19, 0x01, // Tę (U+0054 U+0119)
  0x00, 0x54, 0x01, 0x1B, 0x01, // Tě (U+0054 U+011B)
  0x00, 0x54, 0x01, 0x1D, 0x01, // Tĝ (U+0054 U+011D)
  0x00, 0x54, 0x01, 0x1F, 0x01, // Tğ (U+0054 U+011F)
  0x00, 0x54, 0x01, 0x21, 0x01, // Tġ (U+0054 U+0121)
  0x00, 0x54, 0x01, 0x23, 0x01, // Tģ (U+0054 U+0123)
  0x00, 0x54, 0x01, 0x38, 0x01, // Tĸ (U+0054 U+0138)
  0x00, 0x54, 0x01, 0x44, 0x01, // Tń (U+0054 U+0144)
  0x00, 0x54, 0x01, 0x46, 0x01, // Tņ (U+0054 U+0146)
  0x00, 0x54, 0x01, 0x48, 0x01, // Tň (U+0054 U+0148)
  0x00, 0x54, 0x01, 0x4B, 0x01, // Tŋ (U+0054 U+014B)
  0x00, 0x54, 0x01, 0x4D, 0x01, // Tō (U+0054 U+014D)
  0x00, 0x54, 0x01, 0x4F, 0x01, // Tŏ (U+0054 U+014F)
  0x00, 0x54, 0x01, 0x51, 0x01, // Tő (U+0054 U+0151)
  0x00, 0x54, 0x01, 0x53, 0x01, // Tœ (U+0054 U+0153)
  0x00, 0x54, 0x01, 0x55, 0x01, // Tŕ (U+0054 U+0155)
  0x00, 0x54, 0x01, 0x57, 0x01, // Tŗ (U+0054 U+0157)
  0x00, 0x54, 0x01, 0x5B, 0x01, // Tś (U+0054 U+015B)
  0x00, 0x54, 0x01, 0x5D, 0x01, // Tŝ (U+0054 U+015D)
  0x00, 0x54, 0x01, 0x5F, 0x01, // Tş (U+0054 U+015F)
  0x00, 0x54, 0x01, 0x61, 0x01, // Tš (U+0054 U+0161)
  0x00, 0x54, 0x01, 0x69, 0x01, // Tũ (U+0054 U+0169)
  0x00, 0x54, 0x01, 0x6B, 0x01, // Tū (U+0054 U+016B)
  0x00, 0x54, 0x01, 0x6D, 0x01, // Tŭ (U+0054 U+016D)
  0x00, 0x54, 0x01, 0x6F, 0x01, // Tů (U+0054 U+016F)
  0x00, 0x54, 0x01, 0x71, 0x01, // Tű (U+0054 U+0171)
  0x00, 0x54, 0x01, 0x73, 0x01, // Tų (U+0054 U+0173)
  0x00, 0x54, 0x20, 0x13, 0x01, // T– (U+0054 U+2013)
  0x00, 0x54, 0x20, 0x14, 0x01, // T— (U+0054 U+2014)
  0x00, 0x54, 0x20, 0x1A, 0x01, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x01, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x01, // T… (U+0054 U+2026)
  0x00, 0x54, 0x20, 0x39, 0x01, // T‹ (U+0054 U+2039)
  0x00, 0x56, 0x00, 0x2C, 0x01, // V, (U+0056 U+002C)
  0x00, 0x56, 0x00, 0x2E, 0x01, // V. (U+0056 U+002E)
  0x00, 0x56, 0x20, 0x1A, 0x01, // V‚ (U+0056 U+201A)
  0x00, 0x56, 0x20, 0x1E, 0x01, // V„ (U+0056 U+201E)
  0x00, 0x56, 0x20, 0x26, 0x01, // V… (U+0056 U+2026)
  0x00, 0x57, 0x00, 0x2C, 0x01, // W, (U+0057 U+002C)
  0x00, 0x57, 0x00, 0x2E, 0x01, // W. (U+0057 U+002E)
  0x00, 0x57, 0x20, 0x1A, 0x01, // W‚ (U+0057 U+201A)
  0x00, 0x57, 0x20, 0x1E, 0x01, // W„ (U+0057 U+201E)
  0x00, 0x57, 0x20, 0x26, 0x01, // W… (U+0057 U+2026)
  0x00, 0x59, 0x00, 0x2C, 0x01, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x01, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x00, 0x61, 0x01, // Ya (U+0059 U+0061)
  0x00, 0x59, 0x00, 0x63, 0x01, // Yc (U+0059 U+0063)
  0x00, 0x59, 0x00, 0x64, 0x01, // Yd (U+0059 U+0064)
  0x00, 0x59, 0x00, 0x65, 0x01, // Ye (U+0059 U+0065)
  0x00, 0x59, 0x00, 0x6F, 0x01, // Yo (U+0059 U+006F)
  0x00, 0x59, 0x00, 0x71, 0x01, // Yq (U+0059 U+0071)
  0x00, 0x59, 0x00, 0xAB, 0x01, // Y« (U+0059 U+00AB)
  0x00, 0x59, 0x00, 0xBB, 0x01, // Y» (U+0059 U+00BB)
  0x00, 0x59, 0x00, 0xE0, 0x01, // Yà (U+0059 U+00E0)
  0x00, 0x59, 0x00, 0xE1, 0x01, // Yá (U+0059 U+00E1)
  0x00, 0x59, 0x00, 0xE2, 0x01, // Yâ (U+0059 U+00E2)
  0x00, 0x59, 0x00, 0xE3, 0x01, // Yã (U+0059 U+00E3)
  0x00, 0x59, 0x00, 0xE4, 0x01, // Yä (U+0059 U+00E4)
  0x00, 0x59, 0x00, 0xE5, 0x01, // Yå (U+0059 U+00E5)
  0x00, 0x59, 0x00, 0xE6, 0x01, // Yæ (U+0059 U+00E6)
  0x00, 0x59, 0x00, 0xE7, 0x01, // Yç (U+0059 U+00E7)
  0x00, 0x59, 0x00, 0xE8, 0x01, // Yè (U+0059 U+00E8)
  0x00, 0x59, 0x00, 0xE9, 0x01, // Yé (U+0059 U+00E9)
  0x00, 0x59, 0x00, 0xEA, 0x01, // Yê (U+0059 U+00EA)
  0x00, 0x59, 0x00, 0xEB, 0x01, // Yë (U+0059 U+00EB)
  0x00, 0x59, 0x00, 0xF2, 0x01, // Yò (U+0059 U+00F2)
  0x00, 0x59, 0x00, 0xF3, 0x01, // Yó (U+0059 U+00F3)
  0x00, 0x59, 0x00, 0xF4, 0x01, // Yô (U+0059 U+00F4)
  0x00, 0x59, 0x00, 0xF5, 0x01, // Yõ (U+0059 U+00F5)
  0x00, 0x59, 0x00, 0xF6, 0x01, // Yö (U+0059 U+00F6)
  0x00, 0x59, 0x00, 0xF8, 0x01, // Yø (U+0059 U+00F8)
  0x00, 0x59, 0x01, 0x01, 0x01, // Yā (U+0059 U+0101)
  0x00, 0x59, 0x01, 0x03, 0x01, // Yă (U+0059 U+0103)
  0x00, 0x59, 0x01, 0x05, 0x01, // Yą (U+0059 U+0105)
  0x00, 0x59, 0x01, 0x07, 0x01, // Yć (U+0059 U+0107)
  0x00, 0x59, 0x01, 0x09, 0x01, // Yĉ (U+0059 U+0109)
  0x00, 0x59, 0x01, 0x0B, 0x01, // Yċ (U+0059 U+010B)
  0x00, 0x59, 0x01, 0x0D, 0x01, // Yč (U+0059 U+010D)
  0x00, 0x59, 0x01, 0x0F, 0x01, // Yď (U+0059 U+010F)
  0x00, 0x59, 0x01, 0x11, 0x01, // Yđ (U+0059 U+0111)
  0x00, 0x59, 0x01, 0x13, 0x01, // Yē (U+0059 U+0113)
  0x00, 0x59, 0x01, 0x15, 0x01, // Yĕ (U+0059 U+0115)
  0x00, 0x59, 0x01, 0x17, 0x01, // Yė (U+0059 U+0117)
  0x00, 0x59, 0x01, 0x19, 0x01, // Yę (U+0059 U+0119)
  0x00, 0x59, 0x01, 0x1B, 0x01, // Yě (U+0059 U+011B)
  0x00, 0x59, 0x01, 0x4D, 0x01, // Yō (U+0059 U+014D)
  0x00, 0x59, 0x01, 0x4F, 0x01, // Yŏ (U+0059 U+014F)
  0x00, 0x59, 0x01, 0x51, 0x01, // Yő (U+0059 U+0151)
  0x00, 0x59, 0x01, 0x53, 0x01, // Yœ (U+0059 U+0153)
  0x00, 0x59, 0x20, 0x1A, 0x01, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x01, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x01, // Y… (U+0059 U+2026)
  0x00, 0x59, 0x20, 0x39, 0x01, // Y‹ (U+0059 U+2039)
  0x00, 0x59, 0x20, 0x3A, 0x01, // Y› (U+0059 U+203A)
  0x00, 0x72, 0x00, 0x2C, 0x02, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x02, // r. (U+0072 U+002E)
  0x00, 0x72, 0x20, 0x1A, 0x02, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x02, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x02, // r… (U+0072 U+2026)
  0x00, 0xAB, 0x00, 0x59, 0x01, // «Y (U+00AB U+0059)
  0x00, 0xAB, 0x00, 0xDD, 0x01, // «Ý (U+00AB U+00DD)
  0x00, 0xAB, 0x01, 0x76, 0x01, // «Ŷ (U+00AB U+0176)
  0x00, 0xAB, 0x01, 0x78, 0x01, // «Ÿ (U+00AB U+0178)
  0x00, 0xBB, 0x00, 0x54, 0x01, // »T (U+00BB U+0054)
  0x00, 0xBB, 0x00, 0x59, 0x01, // »Y (U+00BB U+0059)
  0x00, 0xBB, 0x00, 0xDD, 0x01, // »Ý (U+00BB U+00DD)
  0x00, 0xBB, 0x01, 0x62, 0x01, // »Ţ (U+00BB U+0162)
  0x00, 0xBB, 0x01, 0x64, 0x01, // »Ť (U+00BB U+0164)
  0x00, 0xBB, 0x01, 0x66, 0x01, // »Ŧ (U+00BB U+0166)
  0x00, 0xBB, 0x01, 0x76, 0x01, // »Ŷ (U+00BB U+0176)
  0x00, 0xBB, 0x01, 0x78, 0x01, // »Ÿ (U+00BB U+0178)
  0x00, 0xBF, 0x00, 0x54, 0x01, // ¿T (U+00BF U+0054)
  0x00, 0xBF, 0x01, 0x62, 0x01, // ¿Ţ (U+00BF U+0162)
  0x00, 0xBF, 0x01, 0x64, 0x01, // ¿Ť (U+00BF U+0164)
  0x00, 0xBF, 0x01, 0x66, 0x01, // ¿Ŧ (U+00BF U+0166)
  0x00, 0xC0, 0x00, 0x22, 0x01, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x01, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x20, 0x19, 0x01, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1D, 0x01, // À” (U+00C0 U+201D)
  0x00, 0xC1, 0x00, 0x22, 0x01, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x01, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x20, 0x19, 0x01, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1D, 0x01, // Á” (U+00C1 U+201D)
  0x00, 0xC2, 0x00, 0x22, 0x01, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x01, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x20, 0x19, 0x01, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1D, 0x01, // Â” (U+00C2 U+201D)
  0x00, 0xC3, 0x00, 0x22, 0x01, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x01, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x20, 0x19, 0x01, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1D, 0x01, // Ã” (U+00C3 U+201D)
  0x00, 0xC4, 0x00, 0x22, 0x01, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x01, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x20, 0x19, 0x01, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1D, 0x01, // Ä” (U+00C4 U+201D)
  0x00, 0xC5, 0x00, 0x22, 0x01, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x01, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x20, 0x19, 0x01, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1D, 0x01, // Å” (U+00C5 U+201D)
  0x00, 0xD0, 0x00, 0x2C, 0x01, // Ð, (U+00D0 U+002C)
  0x00, 0xD0, 0x00, 0x2E, 0x01, // Ð. (U+00D0 U+002E)
  0x00, 0xD0, 0x20, 0x1A, 0x01, // Ð‚ (U+00D0 U+201A)
  0x00, 0xD0, 0x20, 0x1E, 0x01, // Ð„ (U+00D0 U+201E)
  0x00, 0xD0, 0x20, 0x26, 0x01, // Ð… (U+00D0 U+2026)
  0x00, 0xD2, 0x00, 0x2C, 0x01, // Ò, (U+00D2 U+002C)
  0x00, 0xD2, 0x00, 0x2E, 0x01, // Ò. (U+00D2 U+002E)
  0x00, 0xD2, 0x20, 0x1A, 0x01, // Ò‚ (U+00D2 U+201A)
  0x00, 0xD2, 0x20, 0x1E, 0x01, // Ò„ (U+00D2 U+201E)
  0x00, 0xD2, 0x20, 0x26, 0x01, // Ò… (U+00D2 U+2026)
  0x00, 0xD3, 0x00, 0x2C, 0x01, // Ó, (U+00D3 U+002C)
  0x00, 0xD3, 0x00, 0x2E, 0x01, // Ó. (U+00D3 U+002E)
  0x00, 0xD3, 0x20, 0x1A, 0x01, // Ó‚ (U+00D3 U+201A)
  0x00, 0xD3, 0x20, 0x1E, 0x01, // Ó„ (U+00D3 U+201E)
  0x00, 0xD3, 0x20, 0x26, 0x01, // Ó… (U+00D3 U+2026)
  0x00, 0xD4, 0x00, 0x2C, 0x01, // Ô, (U+00D4 U+002C)
  0x00, 0xD4, 0x00, 0x2E, 0x01, // Ô. (U+00D4 U+002E)
  0x00, 0xD4, 0x20, 0x1A, 0x01, // Ô‚ (U+00D4 U+201A)
  0x00, 0xD4, 0x20, 0x1E, 0x01, // Ô„ (U+00D4 U+201E)
  0x00, 0xD4, 0x20, 0x26, 0x01, // Ô… (U+00D4 U+2026)
  0x00, 0xD5, 0x00, 0x2C, 0x01, // Õ, (U+00D5 U+002C)
  0x00, 0xD5, 0x00, 0x2E, 0x01, // Õ. (U+00D5 U+002E)
  0x00, 0xD5, 0x20, 0x1A, 0x01, // Õ‚ (U+00D5 U+201A)
  0x00, 0xD5, 0x20, 0x1E, 0x01, // Õ„ (U+00D5 U+201E)
  0x00, 0xD5, 0x20, 0x26, 0x01, // Õ… (U+00D5 U+2026)
  0x00, 0xD6, 0x00, 0x2C, 0x01, // Ö, (U+00D6 U+002C)
  0x00, 0xD6, 0x00, 0x2E, 0x01, // Ö. (U+00D6 U+002E)
  0x00, 0xD6, 0x20, 0x1A, 0x01, // Ö‚ (U+00D6 U+201A)
  0x00, 0xD6, 0x20, 0x1E, 0x01, // Ö„ (U+00D6 U+201E)
  0x00, 0xD6, 0x20, 0x26, 0x01, // Ö… (U+00D6 U+2026)
  0x00, 0xD8, 0x00, 0x2C, 0x01, // Ø, (U+00D8 U+002C)
  0x00, 0xD8, 0x00, 0x2E, 0x01, // Ø. (U+00D8 U+002E)
  0x00, 0xD8, 0x20, 0x1A, 0x01, // Ø‚ (U+00D8 U+201A)
  0x00, 0xD8, 0x20, 0x1E, 0x01, // Ø„ (U+00D8 U+201E)
  0x00, 0xD8, 0x20, 0x26, 0x01, // Ø… (U+00D8 U+2026)
  0x00, 0xDD, 0x00, 0x2C, 0x01, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x01, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x00, 0x61, 0x01, // Ýa (U+00DD U+0061)
  0x00, 0xDD, 0x00, 0x63, 0x01, // Ýc (U+00DD U+0063)
  0x00, 0xDD, 0x00, 0x64, 0x01, // Ýd (U+00DD U+0064)
  0x00, 0xDD, 0x00, 0x65, 0x01, // Ýe (U+00DD U+0065)
  0x00, 0xDD, 0x00, 0x6F, 0x01, // Ýo (U+00DD U+006F)
  0x00, 0xDD, 0x00, 0x71, 0x01, // Ýq (U+00DD U+0071)
  0x00, 0xDD, 0x00, 0xAB, 0x01, // Ý« (U+00DD U+00AB)
  0x00, 0xDD, 0x00, 0xBB, 0x01, // Ý» (U+00DD U+00BB)
  0x00, 0xDD, 0x00, 0xE0, 0x01, // Ýà (U+00DD U+00E0)
  0x00, 0xDD, 0x00, 0xE1, 0x01, // Ýá (U+00DD U+00E1)
  0x00, 0xDD, 0x00, 0xE2, 0x01, // Ýâ (U+00DD U+00E2)
  0x00, 0xDD, 0x00, 0xE3, 0x01, // Ýã (U+00DD U+00E3)
  0x00, 0xDD, 0x00, 0xE4, 0x01, // Ýä (U+00DD U+00E4)
  0x00, 0xDD, 0x00, 0xE5, 0x01, // Ýå (U+00DD U+00E5)
  0x00, 0xDD, 0x00, 0xE6, 0x01, // Ýæ (U+00DD U+00E6)
  0x00, 0xDD, 0x00, 0xE7, 0x01, // Ýç (U+00DD U+00E7)
  0x00, 0xDD, 0x00, 0xE8, 0x01, // Ýè (U+00DD U+00E8)
  0x00, 0xDD, 0x00, 0xE9, 0x01, // Ýé (U+00DD U+00E9)
  0x00, 0xDD, 0x00, 0xEA, 0x01, // Ýê (U+00DD U+00EA)
  0x00, 0xDD, 0x00, 0xEB, 0x01, // Ýë (U+00DD U+00EB)
  0x00, 0xDD, 0x00, 0xF2, 0x01, // Ýò (U+00DD U+00F2)
  0x00, 0xDD, 0x00, 0xF3, 0x01, // Ýó (U+00DD U+00F3)
  0x00, 0xDD, 0x00, 0xF4, 0x01, // Ýô (U+00DD U+00F4)
  0x00, 0xDD, 0x00, 0xF5, 0x01, // Ýõ (U+00DD U+00F5)
  0x00, 0xDD, 0x00, 0xF6, 0x01, // Ýö (U+00DD U+00F6)
  0x00, 0xDD, 0x00, 0xF8, 0x01, // Ýø (U+00DD U+00F8)
  0x00, 0xDD, 0x01, 0x01, 0x01, // Ýā (U+00DD U+0101)
  0x00, 0xDD, 0x01, 0x03, 0x01, // Ýă (U+00DD U+0103)
  0x00, 0xDD, 0x01, 0x05, 0x01, // Ýą (U+00DD U+0105)
  0x00, 0xDD, 0x01, 0x07, 0x01, // Ýć (U+00DD U+0107)
  0x00, 0xDD, 0x01, 0x09, 0x01, // Ýĉ (U+00DD U+0109)
  0x00, 0xDD, 0x01, 0x0B, 0x01, // Ýċ (U+00DD U+010B)
  0x00, 0xDD, 0x01, 0x0D, 0x01, // Ýč (U+00DD U+010D)
  0x00, 0xDD, 0x01, 0x0F, 0x01, // Ýď (U+00DD U+010F)
  0x00, 0xDD, 0x01, 0x11, 0x01, // Ýđ (U+00DD U+0111)
  0x00, 0xDD, 0x01, 0x13, 0x01, // Ýē (U+00DD U+0113)
  0x00, 0xDD, 0x01, 0x15, 0x01, // Ýĕ (U+00DD U+0115)
  0x00, 0xDD, 0x01, 0x17, 0x01, // Ýė (U+00DD U+0117)
  0x00, 0xDD, 0x01, 0x19, 0x01, // Ýę (U+00DD U+0119)
  0x00, 0xDD, 0x01, 0x1B, 0x01, // Ýě (U+00DD U+011B)
  0x00, 0xDD, 0x01, 0x4D, 0x01, // Ýō (U+00DD U+014D)
  0x00, 0xDD, 0x01, 0x4F, 0x01, // Ýŏ (U+00DD U+014F)
  0x00, 0xDD, 0x01, 0x51, 0x01, // Ýő (U+00DD U+0151)
  0x00, 0xDD, 0x01, 0x53, 0x01, // Ýœ (U+00DD U+0153)
  0x00, 0xDD, 0x20, 0x1A, 0x01, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x01, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x01, // Ý… (U+00DD U+2026)
  0x00, 0xDD, 0x20, 0x39, 0x01, // Ý‹ (U+00DD U+2039)
  0x00, 0xDD, 0x20, 0x3A, 0x01, // Ý› (U+00DD U+203A)
  0x00, 0xDE, 0x00, 0x2C, 0x02, // Þ, (U+00DE U+002C)
  0x00, 0xDE, 0x00, 0x2E, 0x02, // Þ. (U+00DE U+002E)
  0x00, 0xDE, 0x20, 0x1A, 0x02, // Þ‚ (U+00DE U+201A)
  0x00, 0xDE, 0x20, 0x1E, 0x02, // Þ„ (U+00DE U+201E)
  0x00, 0xDE, 0x20, 0x26, 0x02, // Þ… (U+00DE U+2026)
  0x01, 0x00, 0x00, 0x22, 0x01, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x01, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x20, 0x19, 0x01, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1D, 0x01, // Ā” (U+0100 U+201D)
  0x01, 0x02, 0x00, 0x22, 0x01, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x01, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x20, 0x19, 0x01, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1D, 0x01, // Ă” (U+0102 U+201D)
  0x01, 0x04, 0x00, 0x22, 0x01, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x01, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x20, 0x19, 0x01, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1D, 0x01, // Ą” (U+0104 U+201D)
  0x01, 0x0E, 0x00, 0x2C, 0x01, // Ď, (U+010E U+002C)
  0x01, 0x0E, 0x00, 0x2E, 0x01, // Ď. (U+010E U+002E)
  0x01, 0x0E, 0x20, 0x1A, 0x01, // Ď‚ (U+010E U+201A)
  0x01, 0x0E, 0x20, 0x1E, 0x01, // Ď„ (U+010E U+201E)
  0x01, 0x0E, 0x20, 0x26, 0x01, // Ď… (U+010E U+2026)
  0x01, 0x10, 0x00, 0x2C, 0x01, // Đ, (U+0110 U+002C)
  0x01, 0x10, 0x00, 0x2E, 0x01, // Đ. (U+0110 U+002E)
  0x01, 0x10, 0x20, 0x1A, 0x01, // Đ‚ (U+0110 U+201A)
  0x01, 0x10, 0x20, 0x1E, 0x01, // Đ„ (U+0110 U+201E)
  0x01, 0x10, 0x20, 0x26, 0x01, // Đ… (U+0110 U+2026)
  0x01, 0x39, 0x00, 0x22, 0x01, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x01, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x00, 0x54, 0x01, // ĹT (U+0139 U+0054)
  0x01, 0x39, 0x00, 0x59, 0x01, // ĹY (U+0139 U+0059)
  0x01, 0x39, 0x00, 0xAB, 0x01, // Ĺ« (U+0139 U+00AB)
  0x01, 0x39, 0x00, 0xDD, 0x01, // ĹÝ (U+0139 U+00DD)
  0x01, 0x39, 0x01, 0x62, 0x01, // ĹŢ (U+0139 U+0162)
  0x01, 0x39, 0x01, 0x64, 0x01, // ĹŤ (U+0139 U+0164)
  0x01, 0x39, 0x01, 0x66, 0x01, // ĹŦ (U+0139 U+0166)
  0x01, 0x39, 0x01, 0x76, 0x01, // ĹŶ (U+0139 U+0176)
  0x01, 0x39, 0x01, 0x78, 0x01, // ĹŸ (U+0139 U+0178)
  0x01, 0x39, 0x20, 0x19, 0x01, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1D, 0x01, // Ĺ” (U+0139 U+201D)
  0x01, 0x39, 0x20, 0x39, 0x01, // Ĺ‹ (U+0139 U+2039)
  0x01, 0x3B, 0x00, 0x22, 0x01, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x01, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x00, 0x54, 0x01, // ĻT (U+013B U+0054)
  0x01, 0x3B, 0x00, 0x59, 0x01, // ĻY (U+013B U+0059)
  0x01, 0x3B, 0x00, 0xAB, 0x01, // Ļ« (U+013B U+00AB)
  0x01, 0x3B, 0x00, 0xDD, 0x01, // ĻÝ (U+013B U+00DD)
  0x01, 0x3B, 0x01, 0x62, 0x01, // ĻŢ (U+013B U+0162)
  0x01, 0x3B, 0x01, 0x64, 0x01, // ĻŤ (U+013B U+0164)
  0x01, 0x3B, 0x01, 0x66, 0x01, // ĻŦ (U+013B U+0166)
  0x01, 0x3B, 0x01, 0x76, 0x01, // ĻŶ (U+013B U+0176)
  0x01, 0x3B, 0x01, 0x78, 0x01, // ĻŸ (U+013B U+0178)
  0x01, 0x3B, 0x20, 0x19, 0x01, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1D, 0x01, // Ļ” (U+013B U+201D)
  0x01, 0x3B, 0x20, 0x39, 0x01, // Ļ‹ (U+013B U+2039)
  0x01, 0x3D, 0x00, 0x22, 0x01, // Ľ" (U+013D U+0022)
  0x01, 0x3D, 0x00, 0x27, 0x01, // Ľ' (U+013D U+0027)
  0x01, 0x3D, 0x00, 0x54, 0x01, // ĽT (U+013D U+0054)
  0x01, 0x3D, 0x00, 0x59, 0x01, // ĽY (U+013D U+0059)
  0x01, 0x3D, 0x00, 0xAB, 0x01, // Ľ« (U+013D U+00AB)
  0x01, 0x3D, 0x00, 0xDD, 0x01, // ĽÝ (U+013D U+00DD)
  0x01, 0x3D, 0x01, 0x62, 0x01, // ĽŢ (U+013D U+0162)
  0x01, 0x3D, 0x01, 0x64, 0x01, // ĽŤ (U+013D U+0164)
  0x01, 0x3D, 0x01, 0x66, 0x01, // ĽŦ (U+013D U+0166)
  0x01, 0x3D, 0x01, 0x76, 0x01, // ĽŶ (U+013D U+0176)
  0x01, 0x3D, 0x01, 0x78, 0x01, // ĽŸ (U+013D U+0178)
  0x01, 0x3D, 0x20, 0x19, 0x01, // Ľ’ (U+013D U+2019)
  0x01, 0x3D, 0x20, 0x1D, 0x01, // Ľ” (U+013D U+201D)
  0x01, 0x3D, 0x20, 0x39, 0x01, // Ľ‹ (U+013D U+2039)
  0x01, 0x3F, 0x00, 0x22, 0x01, // Ŀ" (U+013F U+0022)
  0x01, 0x3F, 0x00, 0x27, 0x01, // Ŀ' (U+013F U+0027)
  0x01, 0x3F, 0x00, 0x54, 0x01, // ĿT (U+013F U+0054)
  0x01, 0x3F, 0x00, 0x59, 0x01, // ĿY (U+013F U+0059)
  0x01, 0x3F, 0x00, 0xAB, 0x01, // Ŀ« (U+013F U+00AB)
  0x01, 0x3F, 0x00, 0xDD, 0x01, // ĿÝ (U+013F U+00DD)
  0x01, 0x3F, 0x01, 0x62, 0x01, // ĿŢ (U+013F U+0162)
  0x01, 0x3F, 0x01, 0x64, 0x01, // ĿŤ (U+013F U+0164)
  0x01, 0x3F, 0x01, 0x66, 0x01, // ĿŦ (U+013F U+0166)
  0x01, 0x3F, 0x01, 0x76, 0x01, // ĿŶ (U+013F U+0176)
  0x01, 0x3F, 0x01, 0x78, 0x01, // ĿŸ (U+013F U+0178)
  0x01, 0x3F, 0x20, 0x19, 0x01, // Ŀ’ (U+013F U+2019)
  0x01, 0x3F, 0x20, 0x1D, 0x01, // Ŀ” (U+013F U+201D)
  0x01, 0x3F, 0x20, 0x39, 0x01, // Ŀ‹ (U+013F U+2039)
  0x01, 0x41, 0x00, 0x22, 0x01, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x01, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x00, 0x54, 0x01, // ŁT (U+0141 U+0054)
  0x01, 0x41, 0x00, 0x59, 0x01, // ŁY (U+0141 U+0059)
  0x01, 0x41, 0x00, 0xAB, 0x01, // Ł« (U+0141 U+00AB)
  0x01, 0x41, 0x00, 0xDD, 0x01, // ŁÝ (U+0141 U+00DD)
  0x01, 0x41, 0x01, 0x62, 0x01, // ŁŢ (U+0141 U+0162)
  0x01, 0x41, 0x01, 0x64, 0x01, // ŁŤ (U+0141 U+0164)
  0x01, 0x41, 0x01, 0x66, 0x01, // ŁŦ (U+0141 U+0166)
  0x01, 0x41, 0x01, 0x76, 0x01, // ŁŶ (U+0141 U+0176)
  0x01, 0x41, 0x01, 0x78, 0x01, // ŁŸ (U+0141 U+0178)
  0x01, 0x41, 0x20, 0x19, 0x01, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1D, 0x01, // Ł” (U+0141 U+201D)
  0x01, 0x41, 0x20, 0x39, 0x01, // Ł‹ (U+0141 U+2039)
  0x01, 0x4C, 0x00, 0x2C, 0x01, // Ō, (U+014C U+002C)
  0x01, 0x4C, 0x00, 0x2E, 0x01, // Ō. (U+014C U+002E)
  0x01, 0x4C, 0x20, 0x1A, 0x01, // Ō‚ (U+014C U+201A)
  0x01, 0x4C, 0x20, 0x1E, 0x01, // Ō„ (U+014C U+201E)
  0x01, 0x4C, 0x20, 0x26, 0x01, // Ō… (U+014C U+2026)
  0x01, 0x4E, 0x00, 0x2C, 0x01, // Ŏ, (U+014E U+002C)
  0x01, 0x4E, 0x00, 0x2E, 0x01, // Ŏ. (U+014E U+002E)
  0x01, 0x4E, 0x20, 0x1A, 0x01, // Ŏ‚ (U+014E U+201A)
  0x01, 0x4E, 0x20, 0x1E, 0x01, // Ŏ„ (U+014E U+201E)
  0x01, 0x4E, 0x20, 0x26, 0x01, // Ŏ… (U+014E U+2026)
  0x01, 0x50, 0x00, 0x2C, 0x01, // Ő, (U+0150 U+002C)
  0x01, 0x50, 0x00, 0x2E, 0x01, // Ő. (U+0150 U+002E)
  0x01, 0x50, 0x20, 0x1A, 0x01, // Ő‚ (U+0150 U+201A)
  0x01, 0x50, 0x20, 0x1E, 0x01, // Ő„ (U+0150 U+201E)
  0x01, 0x50, 0x20, 0x26, 0x01, // Ő… (U+0150 U+2026)
  0x01, 0x55, 0x00, 0x2C, 0x02, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x02, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x20, 0x1A, 0x02, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x02, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x02, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x02, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x02, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x20, 0x1A, 0x02, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x02, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x02, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x02, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x02, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x20, 0x1A, 0x02, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x02, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x02, // ř… (U+0159 U+2026)
  0x01, 0x62, 0x00, 0x2C, 0x01, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2D, 0x01, // Ţ- (U+0162 U+002D)
  0x01, 0x62, 0x00, 0x2E, 0x01, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0x61, 0x01, // Ţa (U+0162 U+0061)
  0x01, 0x62, 0x00, 0x63, 0x01, // Ţc (U+0162 U+0063)
  0x01, 0x62, 0x00, 0x64, 0x01, // Ţd (U+0162 U+0064)
  0x01, 0x62, 0x00, 0x65, 0x01, // Ţe (U+0162 U+0065)
  0x01, 0x62, 0x00, 0x67, 0x01, // Ţg (U+0162 U+0067)
  0x01, 0x62, 0x00, 0x6D, 0x01, // Ţm (U+0162 U+006D)
  0x01, 0x62, 0x00, 0x6E, 0x01, // Ţn (U+0162 U+006E)
  0x01, 0x62, 0x00, 0x6F, 0x01, // Ţo (U+0162 U+006F)
  0x01, 0x62, 0x00, 0x70, 0x01, // Ţp (U+0162 U+0070)
  0x01, 0x62, 0x00, 0x71, 0x01, // Ţq (U+0162 U+0071)
  0x01, 0x62, 0x00, 0x72, 0x01, // Ţr (U+0162 U+0072)
  0x01, 0x62, 0x00, 0x73, 0x01, // Ţs (U+0162 U+0073)
  0x01, 0x62, 0x00, 0x75, 0x01, // Ţu (U+0162 U+0075)
  0x01, 0x62, 0x00, 0xAB, 0x01, // Ţ« (U+0162 U+00AB)
  0x01, 0x62, 0x00, 0xE0, 0x01, // Ţà (U+0162 U+00E0)
  0x01, 0x62, 0x00, 0xE1, 0x01, // Ţá (U+0162 U+00E1)
  0x01, 0x62, 0x00, 0xE2, 0x01, // Ţâ (U+0162 U+00E2)
  0x01, 0x62, 0x00, 0xE3, 0x01, // Ţã (U+0162 U+00E3)
  0x01, 0x62, 0x00, 0xE4, 0x01, // Ţä (U+0162 U+00E4)
  0x01, 0x62, 0x00, 0xE5, 0x01, // Ţå (U+0162 U+00E5)
  0x01, 0x62, 0x00, 0xE6, 0x01, // Ţæ (U+0162 U+00E6)
  0x01, 0x62, 0x00, 0xE7, 0x01, // Ţç (U+0162 U+00E7)
  0x01, 0x62, 0x00, 0xE8, 0x01, // Ţè (U+0162 U+00E8)
  0x01, 0x62, 0x00, 0xE9, 0x01, // Ţé (U+0162 U+00E9)
  0x01, 0x62, 0x00, 0xEA, 0x01, // Ţê (U+0162 U+00EA)
  0x01, 0x62, 0x00, 0xEB, 0x01, // Ţë (U+0162 U+00EB)
  0x01, 0x62, 0x00, 0xF1, 0x01, // Ţñ (U+0162 U+00F1)
  0x01, 0x62, 0x00, 0xF2, 0x01, // Ţò (U+0162 U+00F2)
  0x01, 0x62, 0x00, 0xF3, 0x01, // Ţó (U+0162 U+00F3)
  0x01, 0x62, 0x00, 0xF4, 0x01, // Ţô (U+0162 U+00F4)
  0x01, 0x62, 0x00, 0xF5, 0x01, // Ţõ (U+0162 U+00F5)
  0x01, 0x62, 0x00, 0xF6, 0x01, // Ţö (U+0162 U+00F6)
  0x01, 0x62, 0x00, 0xF8, 0x01, // Ţø (U+0162 U+00F8)
  0x01, 0x62, 0x00, 0xF9, 0x01, // Ţù (U+0162 U+00F9)
  0x01, 0x62, 0x00, 0xFA, 0x01, // Ţú (U+0162 U+00FA)
  0x01, 0x62, 0x00, 0xFB, 0x01, // Ţû (U+0162 U+00FB)
  0x01, 0x62, 0x00, 0xFC, 0x01, // Ţü (U+0162 U+00FC)
  0x01, 0x62, 0x01, 0x01, 0x01, // Ţā (U+0162 U+0101)
  0x01, 0x62, 0x01, 0x03, 0x01, // Ţă (U+0162 U+0103)
  0x01, 0x62, 0x01, 0x05, 0x01, // Ţą (U+0162 U+0105)
  0x01, 0x62, 0x01, 0x07, 0x01, // Ţć (U+0162 U+0107)
  0x01, 0x62, 0x01, 0x09, 0x01, // Ţĉ (U+0162 U+0109)
  0x01, 0x62, 0x01, 0x0B, 0x01, // Ţċ (U+0162 U+010B)
  0x01, 0x62, 0x01, 0x0D, 0x01, // Ţč (U+0162 U+010D)
  0x01, 0x62, 0x01, 0x0F, 0x01, // Ţď (U+0162 U+010F)
  0x01, 0x62, 0x01, 0x11, 0x01, // Ţđ (U+0162 U+0111)
  0x01, 0x62, 0x01, 0x13, 0x01, // Ţē (U+0162 U+0113)
  0x01, 0x62, 0x01, 0x15, 0x01, // Ţĕ (U+0162 U+0115)
  0x01, 0x62, 0x01, 0x17, 0x01, // Ţė (U+0162 U+0117)
  0x01, 0x62, 0x01, 0x19, 0x01, // Ţę (U+0162 U+0119)
  0x01, 0x62, 0x01, 0x1B, 0x01, // Ţě (U+0162 U+011B)
  0x01, 0x62, 0x01, 0x1D, 0x01, // Ţĝ (U+0162 U+011D)
  0x01, 0x62, 0x01, 0x1F, 0x01, // Ţğ (U+0162 U+011F)
  0x01, 0x62, 0x01, 0x21, 0x01, // Ţġ (U+0162 U+0121)
  0x01, 0x62, 0x01, 0x23, 0x01, // Ţģ (U+0162 U+0123)
  0x01, 0x62, 0x01, 0x38, 0x01, // Ţĸ (U+0162 U+0138)
  0x01, 0x62, 0x01, 0x44, 0x01, // Ţń (U+0162 U+0144)
  0x01, 0x62, 0x01, 0x46, 0x01, // Ţņ (U+0162 U+0146)
  0x01, 0x62, 0x01, 0x48, 0x01, // Ţň (U+0162 U+0148)
  0x01, 0x62, 0x01, 0x4B, 0x01, // Ţŋ (U+0162 U+014B)
  0x01, 0x62, 0x01, 0x4D, 0x01, // Ţō (U+0162 U+014D)
  0x01, 0x62, 0x01, 0x4F, 0x01, // Ţŏ (U+0162 U+014F)
  0x01, 0x62, 0x01, 0x51, 0x01, // Ţő (U+0162 U+0151)
  0x01, 0x62, 0x01, 0x53, 0x01, // Ţœ (U+0162 U+0153)
  0x01, 0x62, 0x01, 0x55, 0x01, // Ţŕ (U+0162 U+0155)
  0x01, 0x62, 0x01, 0x57, 0x01, // Ţŗ (U+0162 U+0157)
  0x01, 0x62, 0x01, 0x5B, 0x01, // Ţś (U+0162 U+015B)
  0x01, 0x62, 0x01, 0x5D, 0x01, // Ţŝ (U+0162 U+015D)
  0x01, 0x62, 0x01, 0x5F, 0x01, // Ţş (U+0162 U+015F)
  0x01, 0x62, 0x01, 0x61, 0x01, // Ţš (U+0162 U+0161)
  0x01, 0x62, 0x01, 0x69, 0x01, // Ţũ (U+0162 U+0169)
  0x01, 0x62, 0x01, 0x6B, 0x01, // Ţū (U+0162 U+016B)
  0x01, 0x62, 0x01, 0x6D, 0x01, // Ţŭ (U+0162 U+016D)
  0x01, 0x62, 0x01, 0x6F, 0x01, // Ţů (U+0162 U+016F)
  0x01, 0x62, 0x01, 0x71, 0x01, // Ţű (U+0162 U+0171)
  0x01, 0x62, 0x01, 0x73, 0x01, // Ţų (U+0162 U+0173)
  0x01, 0x62, 0x20, 0x13, 0x01, // Ţ– (U+0162 U+2013)
  0x01, 0x62, 0x20, 0x14, 0x01, // Ţ— (U+0162 U+2014)
  0x01, 0x62, 0x20, 0x1A, 0x01, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x01, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x01, // Ţ… (U+0162 U+2026)
  0x01, 0x62, 0x20, 0x39, 0x01, // Ţ‹ (U+0162 U+2039)
  0x01, 0x64, 0x00, 0x2C, 0x01, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2D, 0x01, // Ť- (U+0164 U+002D)
  0x01, 0x64, 0x00, 0x2E, 0x01, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0x61, 0x01, // Ťa (U+0164 U+0061)
  0x01, 0x64, 0x00, 0x63, 0x01, // Ťc (U+0164 U+0063)
  0x01, 0x64, 0x00, 0x64, 0x01, // Ťd (U+0164 U+0064)
  0x01, 0x64, 0x00, 0x65, 0x01, // Ťe (U+0164 U+0065)
  0x01, 0x64, 0x00, 0x67, 0x01, // Ťg (U+0164 U+0067)
  0x01, 0x64, 0x00, 0x6D, 0x01, // Ťm (U+0164 U+006D)
  0x01, 0x64, 0x00, 0x6E, 0x01, // Ťn (U+0164 U+006E)
  0x01, 0x64, 0x00, 0x6F, 0x01, // Ťo (U+0164 U+006F)
  0x01, 0x64, 0x00, 0x70, 0x01, // Ťp (U+0164 U+0070)
  0x01, 0x64, 0x00, 0x71, 0x01, // Ťq (U+0164 U+0071)
  0x01, 0x64, 0x00, 0x72, 0x01, // Ťr (U+0164 U+0072)
  0x01, 0x64, 0x00, 0x73, 0x01, // Ťs (U+0164 U+0073)
  0x01, 0x64, 0x00, 0x75, 0x01, // Ťu (U+0164 U+0075)
  0x01, 0x64, 0x00, 0xAB, 0x01, // Ť« (U+0164 U+00AB)
  0x01, 0x64, 0x00, 0xE0, 0x01, // Ťà (U+0164 U+00E0)
  0x01, 0x64, 0x00, 0xE1, 0x01, // Ťá (U+0164 U+00E1)
  0x01, 0x64, 0x00, 0xE2, 0x01, // Ťâ (U+0164 U+00E2)
  0x01, 0x64, 0x00, 0xE3, 0x01, // Ťã (U+0164 U+00E3)
  0x01, 0x64, 0x00, 0xE4, 0x01, // Ťä (U+0164 U+00E4)
  0x01, 0x64, 0x00, 0xE5, 0x01, // Ťå (U+0164 U+00E5)
  0x01, 0x64, 0x00, 0xE6, 0x01, // Ťæ (U+0164 U+00E6)
  0x01, 0x64, 0x00, 0xE7, 0x01, // Ťç (U+0164 U+00E7)
  0x01, 0x64, 0x00, 0xE8, 0x01, // Ťè (U+0164 U+00E8)
  0x01, 0x64, 0x00, 0xE9, 0x01, // Ťé (U+0164 U+00E9)
  0x01, 0x64, 0x00, 0xEA, 0x01, // Ťê (U+0164 U+00EA)
  0x01, 0x64, 0x00, 0xEB, 0x01, // Ťë (U+0164 U+00EB)
  0x01, 0x64, 0x00, 0xF1, 0x01, // Ťñ (U+0164 U+00F1)
  0x01, 0x64, 0x00, 0xF2, 0x01, // Ťò (U+0164 U+00F2)
  0x01, 0x64, 0x00, 0xF3, 0x01, // Ťó (U+0164 U+00F3)
  0x01, 0x64, 0x00, 0xF4, 0x01, // Ťô (U+0164 U+00F4)
  0x01, 0x64, 0x00, 0xF5, 0x01, // Ťõ (U+0164 U+00F5)
  0x01, 0x64, 0x00, 0xF6, 0x01, // Ťö (U+0164 U+00F6)
  0x01, 0x64, 0x00, 0xF8, 0x01, // Ťø (U+0164 U+00F8)
  0x01, 0x64, 0x00, 0xF9, 0x01, // Ťù (U+0164 U+00F9)
  0x01, 0x64, 0x00, 0xFA, 0x01, // Ťú (U+0164 U+00FA)
  0x01, 0x64, 0x00, 0xFB, 0x01, // Ťû (U+0164 U+00FB)
  0x01, 0x64, 0x00, 0xFC, 0x01, // Ťü (U+0164 U+00FC)
  0x01, 0x64, 0x01, 0x01, 0x01, // Ťā (U+0164 U+0101)
  0x01, 0x64, 0x01, 0x03, 0x01, // Ťă (U+0164 U+0103)
  0x01, 0x64, 0x01, 0x05, 0x01, // Ťą (U+0164 U+0105)
  0x01, 0x64, 0x01, 0x07, 0x01, // Ťć (U+0164 U+0107)
  0x01, 0x64, 0x01, 0x09, 0x01, // Ťĉ (U+0164 U+0109)
  0x01, 0x64, 0x01, 0x0B, 0x01, // Ťċ (U+0164 U+010B)
  0x01, 0x64, 0x01, 0x0D, 0x01, // Ťč (U+0164 U+010D)
  0x01, 0x64, 0x01, 0x0F, 0x01, // Ťď (U+0164 U+010F)
  0x01, 0x64, 0x01, 0x11, 0x01, // Ťđ (U+0164 U+0111)
  0x01, 0x64, 0x01, 0x13, 0x01, // Ťē (U+0164 U+0113)
  0x01, 0x64, 0x01, 0x15, 0x01, // Ťĕ (U+0164 U+0115)
  0x01, 0x64, 0x01, 0x17, 0x01, // Ťė (U+0164 U+0117)
  0x01, 0x64, 0x01, 0x19, 0x01, // Ťę (U+0164 U+0119)
  0x01, 0x64, 0x01, 0x1B, 0x01, // Ťě (U+0164 U+011B)
  0x01, 0x64, 0x01, 0x1D, 0x01, // Ťĝ (U+0164 U+011D)
  0x01, 0x64, 0x01, 0x1F, 0x01, // Ťğ (U+0164 U+011F)
  0x01, 0x64, 0x01, 0x21, 0x01, // Ťġ (U+0164 U+0121)
  0x01, 0x64, 0x01, 0x23, 0x01, // Ťģ (U+0164 U+0123)
  0x01, 0x64, 0x01, 0x38, 0x01, // Ťĸ (U+0164 U+0138)
  0x01, 0x64, 0x01, 0x44, 0x01, // Ťń (U+0164 U+0144)
  0x01, 0x64, 0x01, 0x46, 0x01, // Ťņ (U+0164 U+0146)
  0x01, 0x64, 0x01, 0x48, 0x01, // Ťň (U+0164 U+0148)
  0x01, 0x64, 0x01, 0x4B, 0x01, // Ťŋ (U+0164 U+014B)
  0x01, 0x64, 0x01, 0x4D, 0x01, // Ťō (U+0164 U+014D)
  0x01, 0x64, 0x01, 0x4F, 0x01, // Ťŏ (U+0164 U+014F)
  0x01, 0x64, 0x01, 0x51, 0x01, // Ťő (U+0164 U+0151)
  0x01, 0x64, 0x01, 0x53, 0x01, // Ťœ (U+0164 U+0153)
  0x01, 0x64, 0x01, 0x55, 0x01, // Ťŕ (U+0164 U+0155)
  0x01, 0x64, 0x01, 0x57, 0x01, // Ťŗ (U+0164 U+0157)
  0x01, 0x64, 0x01, 0x5B, 0x01, // Ťś (U+0164 U+015B)
  0x01, 0x64, 0x01, 0x5D, 0x01, // Ťŝ (U+0164 U+015D)
  0x01, 0x64, 0x01, 0x5F, 0x01, // Ťş (U+0164 U+015F)
  0x01, 0x64, 0x01, 0x61, 0x01, // Ťš (U+0164 U+0161)
  0x01, 0x64, 0x01, 0x69, 0x01, // Ťũ (U+0164 U+0169)
  0x01, 0x64, 0x01, 0x6B, 0x01, // Ťū (U+0164 U+016B)
  0x01, 0x64, 0x01, 0x6D, 0x01, // Ťŭ (U+0164 U+016D)
  0x01, 0x64, 0x01, 0x6F, 0x01, // Ťů (U+0164 U+016F)
  0x01, 0x64, 0x01, 0x71, 0x01, // Ťű (U+0164 U+0171)
  0x01, 0x64, 0x01, 0x73, 0x01, // Ťų (U+0164 U+0173)
  0x01, 0x64, 0x20, 0x13, 0x01, // Ť– (U+0164 U+2013)
  0x01, 0x64, 0x20, 0x14, 0x01, // Ť— (U+0164 U+2014)
  0x01, 0x64, 0x20, 0x1A, 0x01, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x01, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x01, // Ť… (U+0164 U+2026)
  0x01, 0x64, 0x20, 0x39, 0x01, // Ť‹ (U+0164 U+2039)
  0x01, 0x66, 0x00, 0x2C, 0x01, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2D, 0x01, // Ŧ- (U+0166 U+002D)
  0x01, 0x66, 0x00, 0x2E, 0x01, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0x61, 0x01, // Ŧa (U+0166 U+0061)
  0x01, 0x66, 0x00, 0x63, 0x01, // Ŧc (U+0166 U+0063)
  0x01, 0x66, 0x00, 0x64, 0x01, // Ŧd (U+0166 U+0064)
  0x01, 0x66, 0x00, 0x65, 0x01, // Ŧe (U+0166 U+0065)
  0x01, 0x66, 0x00, 0x67, 0x01, // Ŧg (U+0166 U+0067)
  0x01, 0x66, 0x00, 0x6D, 0x01, // Ŧm (U+0166 U+006D)
  0x01, 0x66, 0x00, 0x6E, 0x01, // Ŧn (U+0166 U+006E)
  0x01, 0x66, 0x00, 0x6F, 0x01, // Ŧo (U+0166 U+006F)
  0x01, 0x66, 0x00, 0x70, 0x01, // Ŧp (U+0166 U+0070)
  0x01, 0x66, 0x00, 0x71, 0x01, // Ŧq (U+0166 U+0071)
  0x01, 0x66, 0x00, 0x72, 0x01, // Ŧr (U+0166 U+0072)
  0x01, 0x66, 0x00, 0x73, 0x01, // Ŧs (U+0166 U+0073)
  0x01, 0x66, 0x00, 0x75, 0x01, // Ŧu (U+0166 U+0075)
  0x01, 0x66, 0x00, 0xAB, 0x01, // Ŧ« (U+0166 U+00AB)
  0x01, 0x66, 0x00, 0xE0, 0x01, // Ŧà (U+0166 U+00E0)
  0x01, 0x66, 0x00, 0xE1, 0x01, // Ŧá (U+0166 U+00E1)
  0x01, 0x66, 0x00, 0xE2, 0x01, // Ŧâ (U+0166 U+00E2)
  0x01, 0x66, 0x00, 0xE3, 0x01, // Ŧã (U+0166 U+00E3)
  0x01, 0x66, 0x00, 0xE4, 0x01, // Ŧä (U+0166 U+00E4)
  0x01, 0x66, 0x00, 0xE5, 0x01, // Ŧå (U+0166 U+00E5)
  0x01, 0x66, 0x00, 0xE6, 0x01, // Ŧæ (U+0166 U+00E6)
  0x01, 0x66, 0x00, 0xE7, 0x01, // Ŧç (U+0166 U+00E7)
  0x01, 0x66, 0x00, 0xE8, 0x01, // Ŧè (U+0166 U+00E8)
  0x01, 0x66, 0x00, 0xE9, 0x01, // Ŧé (U+0166 U+00E9)
  0x01, 0x66, 0x00, 0xEA, 0x01, // Ŧê (U+0166 U+00EA)
  0x01, 0x66, 0x00, 0xEB, 0x01, // Ŧë (U+0166 U+00EB)
  0x01, 0x66, 0x00, 0xF1, 0x01, // Ŧñ (U+0166 U+00F1)
  0x01, 0x66, 0x00, 0xF2, 0x01, // Ŧò (U+0166 U+00F2)
  0x01, 0x66, 0x00, 0xF3, 0x01, // Ŧó (U+0166 U+00F3)
  0x01, 0x66, 0x00, 0xF4, 0x01, // Ŧô (U+0166 U+00F4)
  0x01, 0x66, 0x00, 0xF5, 0x01, // Ŧõ (U+0166 U+00F5)
  0x01, 0x66, 0x00, 0xF6, 0x01, // Ŧö (U+0166 U+00F6)
  0x01, 0x66, 0x00, 0xF8, 0x01, // Ŧø (U+0166 U+00F8)
  0x01, 0x66, 0x00, 0xF9, 0x01, // Ŧù (U+0166 U+00F9)
  0x01, 0x66, 0x00, 0xFA, 0x01, // Ŧú (U+0166 U+00FA)
  0x01, 0x66, 0x00, 0xFB, 0x01, // Ŧû (U+0166 U+00FB)
  0x01, 0x66, 0x00, 0xFC, 0x01, // Ŧü (U+0166 U+00FC)
  0x01, 0x66, 0x01, 0x01, 0x01, // Ŧā (U+0166 U+0101)
  0x01, 0x66, 0x01, 0x03, 0x01, // Ŧă (U+0166 U+0103)
  0x01, 0x66, 0x01, 0x05, 0x01, // Ŧą (U+0166 U+0105)
  0x01, 0x66, 0x01, 0x07, 0x01, // Ŧć (U+0166 U+0107)
  0x01, 0x66, 0x01, 0x09, 0x01, // Ŧĉ (U+0166 U+0109)
  0x01, 0x66, 0x01, 0x0B, 0x01, // Ŧċ (U+0166 U+010B)
  0x01, 0x66, 0x01, 0x0D, 0x01, // Ŧč (U+0166 U+010D)
  0x01, 0x66, 0x01, 0x0F, 0x01, // Ŧď (U+0166 U+010F)
  0x01, 0x66, 0x01, 0x11, 0x01, // Ŧđ (U+0166 U+0111)
  0x01, 0x66, 0x01, 0x13, 0x01, // Ŧē (U+0166 U+0113)
  0x01, 0x66, 0x01, 0x15, 0x01, // Ŧĕ (U+0166 U+0115)
  0x01, 0x66, 0x01, 0x17, 0x01, // Ŧė (U+0166 U+0117)
  0x01, 0x66, 0x01, 0x19, 0x01, // Ŧę (U+0166 U+0119)
  0x01, 0x66, 0x01, 0x1B, 0x01, // Ŧě (U+0166 U+011B)
  0x01, 0x66, 0x01, 0x1D, 0x01, // Ŧĝ (U+0166 U+011D)
  0x01, 0x66, 0x01, 0x1F, 0x01, // Ŧğ (U+0166 U+011F)
  0x01, 0x66, 0x01, 0x21, 0x01, // Ŧġ (U+0166 U+0121)
  0x01, 0x66, 0x01, 0x23, 0x01, // Ŧģ (U+0166 U+0123)
  0x01, 0x66, 0x01, 0x38, 0x01, // Ŧĸ (U+0166 U+0138)
  0x01, 0x66, 0x01, 0x44, 0x01, // Ŧń (U+0166 U+0144)
  0x01, 0x66, 0x01, 0x46, 0x01, // Ŧņ (U+0166 U+0146)
  0x01, 0x66, 0x01, 0x48, 0x01, // Ŧň (U+0166 U+0148)
  0x01, 0x66, 0x01, 0x4B, 0x01, // Ŧŋ (U+0166 U+014B)
  0x01, 0x66, 0x01, 0x4D, 0x01, // Ŧō (U+0166 U+014D)
  0x01, 0x66, 0x01, 0x4F, 0x01, // Ŧŏ (U+0166 U+014F)
  0x01, 0x66, 0x01, 0x51, 0x01, // Ŧő (U+0166 U+0151)
  0x01, 0x66, 0x01, 0x53, 0x01, // Ŧœ (U+0166 U+0153)
  0x01, 0x66, 0x01, 0x55, 0x01, // Ŧŕ (U+0166 U+0155)
  0x01, 0x66, 0x01, 0x57, 0x01, // Ŧŗ (U+0166 U+0157)
  0x01, 0x66, 0x01, 0x5B, 0x01, // Ŧś (U+0166 U+015B)
  0x01, 0x66, 0x01, 0x5D, 0x01, // Ŧŝ (U+0166 U+015D)
  0x01, 0x66, 0x01, 0x5F, 0x01, // Ŧş (U+0166 U+015F)
  0x01, 0x66, 0x01, 0x61, 0x01, // Ŧš (U+0166 U+0161)
  0x01, 0x66, 0x01, 0x69, 0x01, // Ŧũ (U+0166 U+0169)
  0x01, 0x66, 0x01, 0x6B, 0x01, // Ŧū (U+0166 U+016B)
  0x01, 0x66, 0x01, 0x6D, 0x01, // Ŧŭ (U+0166 U+016D)
  0x01, 0x66, 0x01, 0x6F, 0x01, // Ŧů (U+0166 U+016F)
  0x01, 0x66, 0x01, 0x71, 0x01, // Ŧű (U+0166 U+0171)
  0x01, 0x66, 0x01, 0x73, 0x01, // Ŧų (U+0166 U+0173)
  0x01, 0x66, 0x20, 0x13, 0x01, // Ŧ– (U+0166 U+2013)
  0x01, 0x66, 0x20, 0x14, 0x01, // Ŧ— (U+0166 U+2014)
  0x01, 0x66, 0x20, 0x1A, 0x01, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x01, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x01, // Ŧ… (U+0166 U+2026)
  0x01, 0x66, 0x20, 0x39, 0x01, // Ŧ‹ (U+0166 U+2039)
  0x01, 0x74, 0x00, 0x2C, 0x01, // Ŵ, (U+0174 U+002C)
  0x01, 0x74, 0x00, 0x2E, 0x01, // Ŵ. (U+0174 U+002E)
  0x01, 0x74, 0x20, 0x1A, 0x01, // Ŵ‚ (U+0174 U+201A)
  0x01, 0x74, 0x20, 0x1E, 0x01, // Ŵ„ (U+0174 U+201E)
  0x01, 0x74, 0x20, 0x26, 0x01, // Ŵ… (U+0174 U+2026)
  0x01, 0x76, 0x00, 0x2C, 0x01, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x01, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x00, 0x61, 0x01, // Ŷa (U+0176 U+0061)
  0x01, 0x76, 0x00, 0x63, 0x01, // Ŷc (U+0176 U+0063)
  0x01, 0x76, 0x00, 0x64, 0x01, // Ŷd (U+0176 U+0064)
  0x01, 0x76, 0x00, 0x65, 0x01, // Ŷe (U+0176 U+0065)
  0x01, 0x76, 0x00, 0x6F, 0x01, // Ŷo (U+0176 U+006F)
  0x01, 0x76, 0x00, 0x71, 0x01, // Ŷq (U+0176 U+0071)
  0x01, 0x76, 0x00, 0xAB, 0x01, // Ŷ« (U+0176 U+00AB)
  0x01, 0x76, 0x00, 0xBB, 0x01, // Ŷ» (U+0176 U+00BB)
  0x01, 0x76, 0x00, 0xE0, 0x01, // Ŷà (U+0176 U+00E0)
  0x01, 0x76, 0x00, 0xE1, 0x01, // Ŷá (U+0176 U+00E1)
  0x01, 0x76, 0x00, 0xE2, 0x01, // Ŷâ (U+0176 U+00E2)
  0x01, 0x76, 0x00, 0xE3, 0x01, // Ŷã (U+0176 U+00E3)
  0x01, 0x76, 0x00, 0xE4, 0x01, // Ŷä (U+0176 U+00E4)
  0x01, 0x76, 0x00, 0xE5, 0x01, // Ŷå (U+0176 U+00E5)
  0x01, 0x76, 0x00, 0xE6, 0x01, // Ŷæ (U+0176 U+00E6)
  0x01, 0x76, 0x00, 0xE7, 0x01, // Ŷç (U+0176 U+00E7)
  0x01, 0x76, 0x00, 0xE8, 0x01, // Ŷè (U+0176 U+00E8)
  0x01, 0x76, 0x00, 0xE9, 0x01, // Ŷé (U+0176 U+00E9)
  0x01, 0x76, 0x00, 0xEA, 0x01, // Ŷê (U+0176 U+00EA)
  0x01, 0x76, 0x00, 0xEB, 0x01, // Ŷë (U+0176 U+00EB)
  0x01, 0x76, 0x00, 0xF2, 0x01, // Ŷò (U+0176 U+00F2)
  0x01, 0x76, 0x00, 0xF3, 0x01, // Ŷó (U+0176 U+00F3)
  0x01, 0x76, 0x00, 0xF4, 0x01, // Ŷô (U+0176 U+00F4)
  0x01, 0x76, 0x00, 0xF5, 0x01, // Ŷõ (U+0176 U+00F5)
  0x01, 0x76, 0x00, 0xF6, 0x01, // Ŷö (U+0176 U+00F6)
  0x01, 0x76, 0x00, 0xF8, 0x01, // Ŷø (U+0176 U+00F8)
  0x01, 0x76, 0x01, 0x01, 0x01, // Ŷā (U+0176 U+0101)
  0x01, 0x76, 0x01, 0x03, 0x01, // Ŷă (U+0176 U+0103)
  0x01, 0x76, 0x01, 0x05, 0x01, // Ŷą (U+0176 U+0105)
  0x01, 0x76, 0x01, 0x07, 0x01, // Ŷć (U+0176 U+0107)
  0x01, 0x76, 0x01, 0x09, 0x01, // Ŷĉ (U+0176 U+0109)
  0x01, 0x76, 0x01, 0x0B, 0x01, // Ŷċ (U+0176 U+010B)
  0x01, 0x76, 0x01, 0x0D, 0x01, // Ŷč (U+0176 U+010D)
  0x01, 0x76, 0x01, 0x0F, 0x01, // Ŷď (U+0176 U+010F)
  0x01, 0x76, 0x01, 0x11, 0x01, // Ŷđ (U+0176 U+0111)
  0x01, 0x76, 0x01, 0x13, 0x01, // Ŷē (U+0176 U+0113)
  0x01, 0x76, 0x01, 0x15, 0x01, // Ŷĕ (U+0176 U+0115)
  0x01, 0x76, 0x01, 0x17, 0x01, // Ŷė (U+0176 U+0117)
  0x01, 0x76, 0x01, 0x19, 0x01, // Ŷę (U+0176 U+0119)
  0x01, 0x76, 0x01, 0x1B, 0x01, // Ŷě (U+0176 U+011B)
  0x01, 0x76, 0x01, 0x4D, 0x01, // Ŷō (U+0176 U+014D)
  0x01, 0x76, 0x01, 0x4F, 0x01, // Ŷŏ (U+0176 U+014F)
  0x01, 0x76, 0x01, 0x51, 0x01, // Ŷő (U+0176 U+0151)
  0x01, 0x76, 0x01, 0x53, 0x01, // Ŷœ (U+0176 U+0153)
  0x01, 0x76, 0x20, 0x1A, 0x01, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x01, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x01, // Ŷ… (U+0176 U+2026)
  0x01, 0x76, 0x20, 0x39, 0x01, // Ŷ‹ (U+0176 U+2039)
  0x01, 0x76, 0x20, 0x3A, 0x01, // Ŷ› (U+0176 U+203A)
  0x01, 0x78, 0x00, 0x2C, 0x01, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x01, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x00, 0x61, 0x01, // Ÿa (U+0178 U+0061)
  0x01, 0x78, 0x00, 0x63, 0x01, // Ÿc (U+0178 U+0063)
  0x01, 0x78, 0x00, 0x64, 0x01, // Ÿd (U+0178 U+0064)
  0x01, 0x78, 0x00, 0x65, 0x01, // Ÿe (U+0178 U+0065)
  0x01, 0x78, 0x00, 0x6F, 0x01, // Ÿo (U+0178 U+006F)
  0x01, 0x78, 0x00, 0x71, 0x01, // Ÿq (U+0178 U+0071)
  0x01, 0x78, 0x00, 0xAB, 0x01, // Ÿ« (U+0178 U+00AB)
  0x01, 0x78, 0x00, 0xBB, 0x01, // Ÿ» (U+0178 U+00BB)
  0x01, 0x78, 0x00, 0xE0, 0x01, // Ÿà (U+0178 U+00E0)
  0x01, 0x78, 0x00, 0xE1, 0x01, // Ÿá (U+0178 U+00E1)
  0x01, 0x78, 0x00, 0xE2, 0x01, // Ÿâ (U+0178 U+00E2)
  0x01, 0x78, 0x00, 0xE3, 0x01, // Ÿã (U+0178 U+00E3)
  0x01, 0x78, 0x00, 0xE4, 0x01, // Ÿä (U+0178 U+00E4)
  0x01, 0x78, 0x00, 0xE5, 0x01, // Ÿå (U+0178 U+00E5)
  0x01, 0x78, 0x00, 0xE6, 0x01, // Ÿæ (U+0178 U+00E6)
  0x01, 0x78, 0x00, 0xE7, 0x01, // Ÿç (U+0178 U+00E7)
  0x01, 0x78, 0x00, 0xE8, 0x01, // Ÿè (U+0178 U+00E8)
  0x01, 0x78, 0x00, 0xE9, 0x01, // Ÿé (U+0178 U+00E9)
  0x01, 0x78, 0x00, 0xEA, 0x01, // Ÿê (U+0178 U+00EA)
  0x01, 0x78, 0x00, 0xEB, 0x01, // Ÿë (U+0178 U+00EB)
  0x01, 0x78, 0x00, 0xF2, 0x01, // Ÿò (U+0178 U+00F2)
  0x01, 0x78, 0x00, 0xF3, 0x01, // Ÿó (U+0178 U+00F3)
  0x01, 0x78, 0x00, 0xF4, 0x01, // Ÿô (U+0178 U+00F4)
  0x01, 0x78, 0x00, 0xF5, 0x01, // Ÿõ (U+0178 U+00F5)
  0x01, 0x78, 0x00, 0xF6, 0x01, // Ÿö (U+0178 U+00F6)
  0x01, 0x78, 0x00, 0xF8, 0x01, // Ÿø (U+0178 U+00F8)
  0x01, 0x78, 0x01, 0x01, 0x01, // Ÿā (U+0178 U+0101)
  0x01, 0x78, 0x01, 0x03, 0x01, // Ÿă (U+0178 U+0103)
  0x01, 0x78, 0x01, 0x05, 0x01, // Ÿą (U+0178 U+0105)
  0x01, 0x78, 0x01, 0x07, 0x01, // Ÿć (U+0178 U+0107)
  0x01, 0x78, 0x01, 0x09, 0x01, // Ÿĉ (U+0178 U+0109)
  0x01, 0x78, 0x01, 0x0B, 0x01, // Ÿċ (U+0178 U+010B)
  0x01, 0x78, 0x01, 0x0D, 0x01, // Ÿč (U+0178 U+010D)
  0x01, 0x78, 0x01, 0x0F, 0x01, // Ÿď (U+0178 U+010F)
  0x01, 0x78, 0x01, 0x11, 0x01, // Ÿđ (U+0178 U+0111)
  0x01, 0x78, 0x01, 0x13, 0x01, // Ÿē (U+0178 U+0113)
  0x01, 0x78, 0x01, 0x15, 0x01, // Ÿĕ (U+0178 U+0115)
  0x01, 0x78, 0x01, 0x17, 0x01, // Ÿė (U+0178 U+0117)
  0x01, 0x78, 0x01, 0x19, 0x01, // Ÿę (U+0178 U+0119)
  0x01, 0x78, 0x01, 0x1B, 0x01, // Ÿě (U+0178 U+011B)
  0x01, 0x78, 0x01, 0x4D, 0x01, // Ÿō (U+0178 U+014D)
  0x01, 0x78, 0x01, 0x4F, 0x01, // Ÿŏ (U+0178 U+014F)
  0x01, 0x78, 0x01, 0x51, 0x01, // Ÿő (U+0178 U+0151)
  0x01, 0x78, 0x01, 0x53, 0x01, // Ÿœ (U+0178 U+0153)
  0x01, 0x78, 0x20, 0x1A, 0x01, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x01, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x01, // Ÿ… (U+0178 U+2026)
  0x01, 0x78, 0x20, 0x39, 0x01, // Ÿ‹ (U+0178 U+2039)
  0x01, 0x78, 0x20, 0x3A, 0x01, // Ÿ› (U+0178 U+203A)
  0x20, 0x13, 0x00, 0x54, 0x01, // –T (U+2013 U+0054)
  0x20, 0x13, 0x01, 0x62, 0x01, // –Ţ (U+2013 U+0162)
  0x20, 0x13, 0x01, 0x64, 0x01, // –Ť (U+2013 U+0164)
  0x20, 0x13, 0x01, 0x66, 0x01, // –Ŧ (U+2013 U+0166)
  0x20, 0x14, 0x00, 0x54, 0x01, // —T (U+2014 U+0054)
  0x20, 0x14, 0x01, 0x62, 0x01, // —Ţ (U+2014 U+0162)
  0x20, 0x14, 0x01, 0x64, 0x01, // —Ť (U+2014 U+0164)
  0x20, 0x14, 0x01, 0x66, 0x01, // —Ŧ (U+2014 U+0166)
  0x20, 0x18, 0x00, 0x41, 0x01, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0x61, 0x01, // ‘a (U+2018 U+0061)
  0x20, 0x18, 0x00, 0x63, 0x01, // ‘c (U+2018 U+0063)
  0x20, 0x18, 0x00, 0x64, 0x01, // ‘d (U+2018 U+0064)
  0x20, 0x18, 0x00, 0x65, 0x01, // ‘e (U+2018 U+0065)
  0x20, 0x18, 0x00, 0x6F, 0x01, // ‘o (U+2018 U+006F)
  0x20, 0x18, 0x00, 0x71, 0x01, // ‘q (U+2018 U+0071)
  0x20, 0x18, 0x00, 0xC0, 0x01, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x01, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x01, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x01, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x01, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x01, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xE0, 0x01, // ‘à (U+2018 U+00E0)
  0x20, 0x18, 0x00, 0xE1, 0x01, // ‘á (U+2018 U+00E1)
  0x20, 0x18, 0x00, 0xE2, 0x01, // ‘â (U+2018 U+00E2)
  0x20, 0x18, 0x00, 0xE3, 0x01, // ‘ã (U+2018 U+00E3)
  0x20, 0x18, 0x00, 0xE4, 0x01, // ‘ä (U+2018 U+00E4)
  0x20, 0x18, 0x00, 0xE5, 0x01, // ‘å (U+2018 U+00E5)
  0x20, 0x18, 0x00, 0xE6, 0x01, // ‘æ (U+2018 U+00E6)
  0x20, 0x18, 0x00, 0xE7, 0x01, // ‘ç (U+2018 U+00E7)
  0x20, 0x18, 0x00, 0xE8, 0x01, // ‘è (U+2018 U+00E8)
  0x20, 0x18, 0x00, 0xE9, 0x01, // ‘é (U+2018 U+00E9)
  0x20, 0x18, 0x00, 0xEA, 0x01, // ‘ê (U+2018 U+00EA)
  0x20, 0x18, 0x00, 0xEB, 0x01, // ‘ë (U+2018 U+00EB)
  0x20, 0x18, 0x00, 0xF2, 0x01, // ‘ò (U+2018 U+00F2)
  0x20, 0x18, 0x00, 0xF3, 0x01, // ‘ó (U+2018 U+00F3)
  0x20, 0x18, 0x00, 0xF4, 0x01, // ‘ô (U+2018 U+00F4)
  0x20, 0x18, 0x00, 0xF5, 0x01, // ‘õ (U+2018 U+00F5)
  0x20, 0x18, 0x00, 0xF6, 0x01, // ‘ö (U+2018 U+00F6)
  0x20, 0x18, 0x00, 0xF8, 0x01, // ‘ø (U+2018 U+00F8)
  0x20, 0x18, 0x01, 0x00, 0x01, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x01, 0x01, // ‘ā (U+2018 U+0101)
  0x20, 0x18, 0x01, 0x02, 0x01, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x03, 0x01, // ‘ă (U+2018 U+0103)
  0x20, 0x18, 0x01, 0x04, 0x01, // ‘Ą (U+2018 U+0104)
  0x20, 0x18, 0x01, 0x05, 0x01, // ‘ą (U+2018 U+0105)
  0x20, 0x18, 0x01, 0x07, 0x01, // ‘ć (U+2018 U+0107)
  0x20, 0x18, 0x01, 0x09, 0x01, // ‘ĉ (U+2018 U+0109)
  0x20, 0x18, 0x01, 0x0B, 0x01, // ‘ċ (U+2018 U+010B)
  0x20, 0x18, 0x01, 0x0D, 0x01, // ‘č (U+2018 U+010D)
  0x20, 0x18, 0x01, 0x0F, 0x01, // ‘ď (U+2018 U+010F)
  0x20, 0x18, 0x01, 0x11, 0x01, // ‘đ (U+2018 U+0111)
  0x20, 0x18, 0x01, 0x13, 0x01, // ‘ē (U+2018 U+0113)
  0x20, 0x18, 0x01, 0x15, 0x01, // ‘ĕ (U+2018 U+0115)
  0x20, 0x18, 0x01, 0x17, 0x01, // ‘ė (U+2018 U+0117)
  0x20, 0x18, 0x01, 0x19, 0x01, // ‘ę (U+2018 U+0119)
  0x20, 0x18, 0x01, 0x1B, 0x01, // ‘ě (U+2018 U+011B)
  0x20, 0x18, 0x01, 0x4D, 0x01, // ‘ō (U+2018 U+014D)
  0x20, 0x18, 0x01, 0x4F, 0x01, // ‘ŏ (U+2018 U+014F)
  0x20, 0x18, 0x01, 0x51, 0x01, // ‘ő (U+2018 U+0151)
  0x20, 0x18, 0x01, 0x53, 0x01, // ‘œ (U+2018 U+0153)
  0x20, 0x19, 0x00, 0x41, 0x01, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0x61, 0x01, // ’a (U+2019 U+0061)
  0x20, 0x19, 0x00, 0x63, 0x01, // ’c (U+2019 U+0063)
  0x20, 0x19, 0x00, 0x64, 0x01, // ’d (U+2019 U+0064)
  0x20, 0x19, 0x00, 0x65, 0x01, // ’e (U+2019 U+0065)
  0x20, 0x19, 0x00, 0x6F, 0x01, // ’o (U+2019 U+006F)
  0x20, 0x19, 0x00, 0x71, 0x01, // ’q (U+2019 U+0071)
  0x20, 0x19, 0x00, 0xC0, 0x01, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x01, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x01, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x01, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x01, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x01, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xE0, 0x01, // ’à (U+2019 U+00E0)
  0x20, 0x19, 0x00, 0xE1, 0x01, // ’á (U+2019 U+00E1)
  0x20, 0x19, 0x00, 0xE2, 0x01, // ’â (U+2019 U+00E2)
  0x20, 0x19, 0x00, 0xE3, 0x01, // ’ã (U+2019 U+00E3)
  0x20, 0x19, 0x00, 0xE4, 0x01, // ’ä (U+2019 U+00E4)
  0x20, 0x19, 0x00, 0xE5, 0x01, // ’å (U+2019 U+00E5)
  0x20, 0x19, 0x00, 0xE6, 0x01, // ’æ (U+2019 U+00E6)
  0x20, 0x19, 0x00, 0xE7, 0x01, // ’ç (U+2019 U+00E7)
  0x20, 0x19, 0x00, 0xE8, 0x01, // ’è (U+2019 U+00E8)
  0x20, 0x19, 0x00, 0xE9, 0x01, // ’é (U+2019 U+00E9)
  0x20, 0x19, 0x00, 0xEA, 0x01, // ’ê (U+2019 U+00EA)
  0x20, 0x19, 0x00, 0xEB, 0x01, // ’ë (U+2019 U+00EB)
  0x20, 0x19, 0x00, 0xF2, 0x01, // ’ò (U+2019 U+00F2)
  0x20, 0x19, 0x00, 0xF3, 0x01, // ’ó (U+2019 U+00F3)
  0x20, 0x19, 0x00, 0xF4, 0x01, // ’ô (U+2019 U+00F4)
  0x20, 0x19, 0x00, 0xF5, 0x01, // ’õ (U+2019 U+00F5)
  0x20, 0x19, 0x00, 0xF6, 0x01, // ’ö (U+2019 U+00F6)
  0x20, 0x19, 0x00, 0xF8, 0x01, // ’ø (U+2019 U+00F8)
  0x20, 0x19, 0x01, 0x00, 0x01, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x01, 0x01, // ’ā (U+2019 U+0101)
  0x20, 0x19, 0x01, 0x02, 0x01, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x03, 0x01, // ’ă (U+2019 U+0103)
  0x20, 0x19, 0x01, 0x04, 0x01, // ’Ą (U+2019 U+0104)
  0x20, 0x19, 0x01, 0x05, 0x01, // ’ą (U+2019 U+0105)
  0x20, 0x19, 0x01, 0x07, 0x01, // ’ć (U+2019 U+0107)
  0x20, 0x19, 0x01, 0x09, 0x01, // ’ĉ (U+2019 U+0109)
  0x20, 0x19, 0x01, 0x0B, 0x01, // ’ċ (U+2019 U+010B)
  0x20, 0x19, 0x01, 0x0D, 0x01, // ’č (U+2019 U+010D)
  0x20, 0x19, 0x01, 0x0F, 0x01, // ’ď (U+2019 U+010F)
  0x20, 0x19, 0x01, 0x11, 0x01, // ’đ (U+2019 U+0111)
  0x20, 0x19, 0x01, 0x13, 0x01, // ’ē (U+2019 U+0113)
  0x20, 0x19, 0x01, 0x15, 0x01, // ’ĕ (U+2019 U+0115)
  0x20, 0x19, 0x01, 0x17, 0x01, // ’ė (U+2019 U+0117)
  0x20, 0x19, 0x01, 0x19, 0x01, // ’ę (U+2019 U+0119)
  0x20, 0x19, 0x01, 0x1B, 0x01, // ’ě (U+2019 U+011B)
  0x20, 0x19, 0x01, 0x4D, 0x01, // ’ō (U+2019 U+014D)
  0x20, 0x19, 0x01, 0x4F, 0x01, // ’ŏ (U+2019 U+014F)
  0x20, 0x19, 0x01, 0x51, 0x01, // ’ő (U+2019 U+0151)
  0x20, 0x19, 0x01, 0x53, 0x01, // ’œ (U+2019 U+0153)
  0x20, 0x1A, 0x00, 0x43, 0x01, // ‚C (U+201A U+0043)
  0x20, 0x1A, 0x00, 0x47, 0x01, // ‚G (U+201A U+0047)
  0x20, 0x1A, 0x00, 0x4F, 0x01, // ‚O (U+201A U+004F)
  0x20, 0x1A, 0x00, 0x51, 0x01, // ‚Q (U+201A U+0051)
  0x20, 0x1A, 0x00, 0x54, 0x01, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x56, 0x01, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x01, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x01, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0xC7, 0x01, // ‚Ç (U+201A U+00C7)
  0x20, 0x1A, 0x00, 0xD2, 0x01, // ‚Ò (U+201A U+00D2)
  0x20, 0x1A, 0x00, 0xD3, 0x01, // ‚Ó (U+201A U+00D3)
  0x20, 0x1A, 0x00, 0xD4, 0x01, // ‚Ô (U+201A U+00D4)
  0x20, 0x1A, 0x00, 0xD5, 0x01, // ‚Õ (U+201A U+00D5)
  0x20, 0x1A, 0x00, 0xD6, 0x01, // ‚Ö (U+201A U+00D6)
  0x20, 0x1A, 0x00, 0xD8, 0x01, // ‚Ø (U+201A U+00D8)
  0x20, 0x1A, 0x00, 0xDD, 0x01, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x01, 0x06, 0x01, // ‚Ć (U+201A U+0106)
  0x20, 0x1A, 0x01, 0x08, 0x01, // ‚Ĉ (U+201A U+0108)
  0x20, 0x1A, 0x01, 0x0A, 0x01, // ‚Ċ (U+201A U+010A)
  0x20, 0x1A, 0x01, 0x0C, 0x01, // ‚Č (U+201A U+010C)
  0x20, 0x1A, 0x01, 0x1C, 0x01, // ‚Ĝ (U+201A U+011C)
  0x20, 0x1A, 0x01, 0x1E, 0x01, // ‚Ğ (U+201A U+011E)
  0x20, 0x1A, 0x01, 0x20, 0x01, // ‚Ġ (U+201A U+0120)
  0x20, 0x1A, 0x01, 0x22, 0x01, // ‚Ģ (U+201A U+0122)
  0x20, 0x1A, 0x01, 0x4C, 0x01, // ‚Ō (U+201A U+014C)
  0x20, 0x1A, 0x01, 0x4E, 0x01, // ‚Ŏ (U+201A U+014E)
  0x20, 0x1A, 0x01, 0x50, 0x01, // ‚Ő (U+201A U+0150)
  0x20, 0x1A, 0x01, 0x52, 0x01, // ‚Œ (U+201A U+0152)
  0x20, 0x1A, 0x01, 0x62, 0x01, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x01, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x01, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1A, 0x01, 0x74, 0x01, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x76, 0x01, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x78, 0x01, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x01, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0x61, 0x01, // “a (U+201C U+0061)
  0x20, 0x1C, 0x00, 0x63, 0x01, // “c (U+201C U+0063)
  0x20, 0x1C, 0x00, 0x64, 0x01, // “d (U+201C U+0064)
  0x20, 0x1C, 0x00, 0x65, 0x01, // “e (U+201C U+0065)
  0x20, 0x1C, 0x00, 0x6F, 0x01, // “o (U+201C U+006F)
  0x20, 0x1C, 0x00, 0x71, 0x01, // “q (U+201C U+0071)
  0x20, 0x1C, 0x00, 0xC0, 0x01, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x01, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x01, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x01, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x01, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x01, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xE0, 0x01, // “à (U+201C U+00E0)
  0x20, 0x1C, 0x00, 0xE1, 0x01, // “á (U+201C U+00E1)
  0x20, 0x1C, 0x00, 0xE2, 0x01, // “â (U+201C U+00E2)
  0x20, 0x1C, 0x00, 0xE3, 0x01, // “ã (U+201C U+00E3)
  0x20, 0x1C, 0x00, 0xE4, 0x01, // “ä (U+201C U+00E4)
  0x20, 0x1C, 0x00, 0xE5, 0x01, // “å (U+201C U+00E5)
  0x20, 0x1C, 0x00, 0xE6, 0x01, // “æ (U+201C U+00E6)
  0x20, 0x1C, 0x00, 0xE7, 0x01, // “ç (U+201C U+00E7)
  0x20, 0x1C, 0x00, 0xE8, 0x01, // “è (U+201C U+00E8)
  0x20, 0x1C, 0x00, 0xE9, 0x01, // “é (U+201C U+00E9)
  0x20, 0x1C, 0x00, 0xEA, 0x01, // “ê (U+201C U+00EA)
  0x20, 0x1C, 0x00, 0xEB, 0x01, // “ë (U+201C U+00EB)
  0x20, 0x1C, 0x00, 0xF2, 0x01, // “ò (U+201C U+00F2)
  0x20, 0x1C, 0x00, 0xF3, 0x01, // “ó (U+201C U+00F3)
  0x20, 0x1C, 0x00, 0xF4, 0x01, // “ô (U+201C U+00F4)
  0x20, 0x1C, 0x00, 0xF5, 0x01, // “õ (U+201C U+00F5)
  0x20, 0x1C, 0x00, 0xF6, 0x01, // “ö (U+201C U+00F6)
  0x20, 0x1C, 0x00, 0xF8, 0x01, // “ø (U+201C U+00F8)
  0x20, 0x1C, 0x01, 0x00, 0x01, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x01, 0x01, // “ā (U+201C U+0101)
  0x20, 0x1C, 0x01, 0x02, 0x01, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x03, 0x01, // “ă (U+201C U+0103)
  0x20, 0x1C, 0x01, 0x04, 0x01, // “Ą (U+201C U+0104)
  0x20, 0x1C, 0x01, 0x05, 0x01, // “ą (U+201C U+0105)
  0x20, 0x1C, 0x01, 0x07, 0x01, // “ć (U+201C U+0107)
  0x20, 0x1C, 0x01, 0x09, 0x01, // “ĉ (U+201C U+0109)
  0x20, 0x1C, 0x01, 0x0B, 0x01, // “ċ (U+201C U+010B)
  0x20, 0x1C, 0x01, 0x0D, 0x01, // “č (U+201C U+010D)
  0x20, 0x1C, 0x01, 0x0F, 0x01, // “ď (U+201C U+010F)
  0x20, 0x1C, 0x01, 0x11, 0x01, // “đ (U+201C U+0111)
  0x20, 0x1C, 0x01, 0x13, 0x01, // “ē (U+201C U+0113)
  0x20, 0x1C, 0x01, 0x15, 0x01, // “ĕ (U+201C U+0115)
  0x20, 0x1C, 0x01, 0x17, 0x01, // “ė (U+201C U+0117)
  0x20, 0x1C, 0x01, 0x19, 0x01, // “ę (U+201C U+0119)
  0x20, 0x1C, 0x01, 0x1B, 0x01, // “ě (U+201C U+011B)
  0x20, 0x1C, 0x01, 0x4D, 0x01, // “ō (U+201C U+014D)
  0x20, 0x1C, 0x01, 0x4F, 0x01, // “ŏ (U+201C U+014F)
  0x20, 0x1C, 0x01, 0x51, 0x01, // “ő (U+201C U+0151)
  0x20, 0x1C, 0x01, 0x53, 0x01, // “œ (U+201C U+0153)
  0x20, 0x1D, 0x00, 0x41, 0x01, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0x61, 0x01, // ”a (U+201D U+0061)
  0x20, 0x1D, 0x00, 0x63, 0x01, // ”c (U+201D U+0063)
  0x20, 0x1D, 0x00, 0x64, 0x01, // ”d (U+201D U+0064)
  0x20, 0x1D, 0x00, 0x65, 0x01, // ”e (U+201D U+0065)
  0x20, 0x1D, 0x00, 0x6F, 0x01, // ”o (U+201D U+006F)
  0x20, 0x1D, 0x00, 0x71, 0x01, // ”q (U+201D U+0071)
  0x20, 0x1D, 0x00, 0xC0, 0x01, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x01, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x01, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x01, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x01, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x01, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xE0, 0x01, // ”à (U+201D U+00E0)
  0x20, 0x1D, 0x00, 0xE1, 0x01, // ”á (U+201D U+00E1)
  0x20, 0x1D, 0x00, 0xE2, 0x01, // ”â (U+201D U+00E2)
  0x20, 0x1D, 0x00, 0xE3, 0x01, // ”ã (U+201D U+00E3)
  0x20, 0x1D, 0x00, 0xE4, 0x01, // ”ä (U+201D U+00E4)
  0x20, 0x1D, 0x00, 0xE5, 0x01, // ”å (U+201D U+00E5)
  0x20, 0x1D, 0x00, 0xE6, 0x01, // ”æ (U+201D U+00E6)
  0x20, 0x1D, 0x00, 0xE7, 0x01, // ”ç (U+201D U+00E7)
  0x20, 0x1D, 0x00, 0xE8, 0x01, // ”è (U+201D U+00E8)
  0x20, 0x1D, 0x00, 0xE9, 0x01, // ”é (U+201D U+00E9)
  0x20, 0x1D, 0x00, 0xEA, 0x01, // ”ê (U+201D U+00EA)
  0x20, 0x1D, 0x00, 0xEB, 0x01, // ”ë (U+201D U+00EB)
  0x20, 0x1D, 0x00, 0xF2, 0x01, // ”ò (U+201D U+00F2)
  0x20, 0x1D, 0x00, 0xF3, 0x01, // ”ó (U+201D U+00F3)
  0x20, 0x1D, 0x00, 0xF4, 0x01, // ”ô (U+201D U+00F4)
  0x20, 0x1D, 0x00, 0xF5, 0x01, // ”õ (U+201D U+00F5)
  0x20, 0x1D, 0x00, 0xF6, 0x01, // ”ö (U+201D U+00F6)
  0x20, 0x1D, 0x00, 0xF8, 0x01, // ”ø (U+201D U+00F8)
  0x20, 0x1D, 0x01, 0x00, 0x01, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x01, 0x01, // ”ā (U+201D U+0101)
  0x20, 0x1D, 0x01, 0x02, 0x01, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x03, 0x01, // ”ă (U+201D U+0103)
  0x20, 0x1D, 0x01, 0x04, 0x01, // ”Ą (U+201D U+0104)
  0x20, 0x1D, 0x01, 0x05, 0x01, // ”ą (U+201D U+0105)
  0x20, 0x1D, 0x01, 0x07, 0x01, // ”ć (U+201D U+0107)
  0x20, 0x1D, 0x01, 0x09, 0x01, // ”ĉ (U+201D U+0109)
  0x20, 0x1D, 0x01, 0x0B, 0x01, // ”ċ (U+201D U+010B)
  0x20, 0x1D, 0x01, 0x0D, 0x01, // ”č (U+201D U+010D)
  0x20, 0x1D, 0x01, 0x0F, 0x01, // ”ď (U+201D U+010F)
  0x20, 0x1D, 0x01, 0x11, 0x01, // ”đ (U+201D U+0111)
  0x20, 0x1D, 0x01, 0x13, 0x01, // ”ē (U+201D U+0113)
  0x20, 0x1D, 0x01, 0x15, 0x01, // ”ĕ (U+201D U+0115)
  0x20, 0x1D, 0x01, 0x17, 0x01, // ”ė (U+201D U+0117)
  0x20, 0x1D, 0x01, 0x19, 0x01, // ”ę (U+201D U+0119)
  0x20, 0x1D, 0x01, 0x1B, 0x01, // ”ě (U+201D U+011B)
  0x20, 0x1D, 0x01, 0x4D, 0x01, // ”ō (U+201D U+014D)
  0x20, 0x1D, 0x01, 0x4F, 0x01, // ”ŏ (U+201D U+014F)
  0x20, 0x1D, 0x01, 0x51, 0x01, // ”ő (U+201D U+0151)
  0x20, 0x1D, 0x01, 0x53, 0x01, // ”œ (U+201D U+0153)
  0x20, 0x1E, 0x00, 0x43, 0x01, // „C (U+201E U+0043)
  0x20, 0x1E, 0x00, 0x47, 0x01, // „G (U+201E U+0047)
  0x20, 0x1E, 0x00, 0x4F, 0x01, // „O (U+201E U+004F)
  0x20, 0x1E, 0x00, 0x51, 0x01, // „Q (U+201E U+0051)
  0x20, 0x1E, 0x00, 0x54, 0x01, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x56, 0x01, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x01, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x01, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0xC7, 0x01, // „Ç (U+201E U+00C7)
  0x20, 0x1E, 0x00, 0xD2, 0x01, // „Ò (U+201E U+00D2)
  0x20, 0x1E, 0x00, 0xD3, 0x01, // „Ó (U+201E U+00D3)
  0x20, 0x1E, 0x00, 0xD4, 0x01, // „Ô (U+201E U+00D4)
  0x20, 0x1E, 0x00, 0xD5, 0x01, // „Õ (U+201E U+00D5)
  0x20, 0x1E, 0x00, 0xD6, 0x01, // „Ö (U+201E U+00D6)
  0x20, 0x1E, 0x00, 0xD8, 0x01, // „Ø (U+201E U+00D8)
  0x20, 0x1E, 0x00, 0xDD, 0x01, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x01, 0x06, 0x01, // „Ć (U+201E U+0106)
  0x20, 0x1E, 0x01, 0x08, 0x01, // „Ĉ (U+201E U+0108)
  0x20, 0x1E, 0x01, 0x0A, 0x01, // „Ċ (U+201E U+010A)
  0x20, 0x1E, 0x01, 0x0C, 0x01, // „Č (U+201E U+010C)
  0x20, 0x1E, 0x01, 0x1C, 0x01, // „Ĝ (U+201E U+011C)
  0x20, 0x1E, 0x01, 0x1E, 0x01, // „Ğ (U+201E U+011E)
  0x20, 0x1E, 0x01, 0x20, 0x01, // „Ġ (U+201E U+0120)
  0x20, 0x1E, 0x01, 0x22, 0x01, // „Ģ (U+201E U+0122)
  0x20, 0x1E, 0x01, 0x4C, 0x01, // „Ō (U+201E U+014C)
  0x20, 0x1E, 0x01, 0x4E, 0x01, // „Ŏ (U+201E U+014E)
  0x20, 0x1E, 0x01, 0x50, 0x01, // „Ő (U+201E U+0150)
  0x20, 0x1E, 0x01, 0x52, 0x01, // „Œ (U+201E U+0152)
  0x20, 0x1E, 0x01, 0x62, 0x01, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x01, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x01, // „Ŧ (U+201E U+0166)
  0x20, 0x1E, 0x01, 0x74, 0x01, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x76, 0x01, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x78, 0x01, // „Ÿ (U+201E U+0178)
  0x20, 0x39, 0x00, 0x59, 0x01, // ‹Y (U+2039 U+0059)
  0x20, 0x39, 0x00, 0xDD, 0x01, // ‹Ý (U+2039 U+00DD)
  0x20, 0x39, 0x01, 0x76, 0x01, // ‹Ŷ (U+2039 U+0176)
  0x20, 0x39, 0x01, 0x78, 0x01, // ‹Ÿ (U+2039 U+0178)
  0x20, 0x3A, 0x00, 0x54, 0x01, // ›T (U+203A U+0054)
  0x20, 0x3A, 0x00, 0x59, 0x01, // ›Y (U+203A U+0059)
  0x20, 0x3A, 0x00, 0xDD, 0x01, // ›Ý (U+203A U+00DD)
  0x20, 0x3A, 0x01, 0x62, 0x01, // ›Ţ (U+203A U+0162)
  0x20, 0x3A, 0x01, 0x64, 0x01, // ›Ť (U+203A U+0164)
  0x20, 0x3A, 0x01, 0x66, 0x01, // ›Ŧ (U+203A U+0166)
  0x20, 0x3A, 0x01, 0x76, 0x01, // ›Ŷ (U+203A U+0176)
  0x20, 0x3A, 0x01, 0x78, 0x01, // ›Ÿ (U+203A U+0178)
  
  // Glyph data
  // "!" (U+0021)
  0x00, 0xAB, 0x00, 0xD7, 0x01, 0xF3, 0x04, 0xE0, 0x07, 0xA0, 0x0A, 0x50, 0x0E, 0x10, 0x00, 0x00,
  0x69, 0x00, 0xA9, 0x00,
  // """ (U+0022)
  0x0F, 0x49, 0x92, 0xE0, 0xC4, 0x59, 0x0D, 0x00,
  // "#" (U+0023)
  0x00, 0x07, 0x70, 0xD0, 0x00, 0x0D, 0x16, 0x80, 0x0B, 0xEF, 0xEF, 0xE8, 0x01, 0x96, 0x2D, 0x10,
  0x00, 0xD1, 0x49, 0x00, 0x01, 0xD0, 0x85, 0x00, 0xBE, 0xFE, 0xFE, 0x80, 0x1B, 0x53, 0xC1, 0x00,
  0x0D, 0x07, 0x70, 0x00, 0x59, 0x0C, 0x10, 0x00,
  // "$" (U+0024)
  0x40, 0xB4, 0x89, 0x74, 0xAE, 0xA4, 0x03, 0xD5, 0x95, 0x30, 0x89, 0x64, 0x38, 0x26, 0xDB, 0x14,
  0x81, 0x7F, 0x64, 0x82, 0x1B, 0xE5, 0x38, 0x93, 0x46, 0x98, 0x04, 0x18, 0x3C, 0x50, 0x9A, 0x0D,
  0x07, 0x40, 0xB5, 0x01, 0x05, 0x40,
  // "%" (U+0025)
  0x00, 0x9E, 0x70, 0x08, 0x70, 0x06, 0xA3, 0xC0, 0x3C, 0x00, 0x0C, 0x23, 0xB0, 0xC3, 0x00, 0x0E,
  0x06, 0x86, 0xAC, 0xC1, 0x1D, 0x1D, 0x4D, 0xC6, 0xB5, 0x0C, 0xF7, 0xA7, 0xD0, 0x96, 0x00, 0x05,
  0xA5, 0x90, 0xB3, 0x00, 0x0D, 0x18, 0x70, 0xE0, 0x00, 0x96, 0x07, 0x87, 0x90, 0x03, 0xC0, 0x02,
  0xEC, 0x00,
  // "&" (U+0026)
  0x00, 0x1C, 0xFA, 0x00, 0x00, 0xB9, 0x2F, 0x20, 0x00, 0xE4, 0x1D, 0x00, 0x00, 0xB4, 0x83, 0x00,
  0x00, 0xBD, 0x30, 0x00, 0x1C, 0x6D, 0x62, 0xE1, 0x99, 0x06, 0xD9, 0x90, 0xD5, 0x00, 0xED, 0x10,
  0xC9, 0x06, 0xFD, 0x00, 0x4D, 0xEA, 0x2E, 0x50,
  // "'" (U+0027)
  0x0E, 0x52, 0xE0, 0x59, 0x00,
  // "(" (U+0028)
  0x00, 0x06, 0xA0, 0x03, 0xD1, 0x00, 0xC5, 0x00, 0x5C, 0x00, 0x0C, 0x60, 0x01, 0xF1, 0x00, 0x5C,
  0x00, 0x07, 0xA0, 0x00, 0x98, 0x00, 0x08, 0x80, 0x00, 0x7A, 0x00, 0x04, 0xC0, 0x00, 0x0E, 0x10,
  0x00,
  // ")" (U+0029)
  0x00, 0x2D, 0x00, 0x00, 0xD2, 0x00, 0x0B, 0x50, 0x00, 0xA7, 0x00, 0x0A, 0x70, 0x00, 0xC6, 0x00,
  0x0E, 0x40, 0x03, 0xE0, 0x00, 0x7A, 0x00, 0x0D, 0x30, 0x06, 0xB0, 0x01, 0xD2, 0x00, 0xB5, 0x00,
  0x00,
  // "*" (U+002A)
  0x00, 0x1E, 0x00, 0x38, 0x3B, 0x00, 0x27, 0xDE, 0xEA, 0x05, 0xCC, 0x00, 0x0C, 0x29, 0x70, 0x00,
  0x02, 0x10,
  // "+" (U+002B)
  0x30, 0xC0, 0x45, 0x0C, 0x04, 0x50, 0xC0, 0x42, 0x89, 0x43, 0xEE, 0xFE, 0xEA, 0x01, 0x1C, 0x51,
  0x13, 0x0C, 0x04, 0x50, 0xC0, 0x42,
  // "," (U+002C)
  0x02, 0x70, 0x99, 0x0E, 0x26, 0x80,
  // "-" (U+002D)
  0x8E, 0xE9, 0x11, 0x10,
  // "." (U+002E)
  0x69, 0xA9,
  // "/" (U+002F)
  0x58, 0x13, 0xE1, 0x50, 0xB0, 0x65, 0x05, 0x0C, 0x60, 0xD0, 0x35, 0x08, 0x0A, 0x58, 0x12, 0xE1,
  0x50, 0xA0, 0x75, 0x04, 0x0D, 0x60, 0xC0, 0x55, 0x06, 0x0B, 0x60,
  // "0" (U+0030)
  0x00, 0x2B, 0xEA, 0x00, 0x0D, 0x81, 0xD5, 0x06, 0xD0, 0x0B, 0x70, 0xC6, 0x00, 0xC6, 0x1F, 0x20,
  0x0E, 0x45, 0xE0, 0x02, 0xF1, 0x7B, 0x00, 0x6C, 0x07, 0xB0, 0x0C, 0x60, 0x5D, 0x18, 0xC0, 0x00,
  0xAE, 0xB1, 0x00,
  // "1" (U+0031)
  0x00, 0x3D, 0x90, 0x6D, 0xE5, 0x1A, 0x3F, 0x20, 0x04, 0xE0, 0x00, 0x8A, 0x00, 0x0B, 0x70, 0x00,
  0xF3, 0x00, 0x3F, 0x00, 0x07, 0xC0, 0x00, 0xA8, 0x00,
  // "2" (U+0032)
  0x38, 0x27, 0xEE, 0xA4, 0x83, 0x92, 0x2E, 0x66, 0x0C, 0x06, 0x58, 0x11, 0xF2, 0x50, 0xB0, 0x95,
  0x09, 0x0B, 0x50, 0x80, 0xC5, 0x81, 0x8C, 0x14, 0x81, 0x8C, 0x14, 0x03, 0xD0, 0x11,
  // "3" (U+0033)
  0x18, 0x31, 0x8D, 0xEA, 0x38, 0x37, 0x11, 0xE6, 0x50, 0xC0, 0x53, 0x81, 0x18, 0xC3, 0x81, 0xDF,
  0x94, 0x82, 0x15, 0xE3, 0x50, 0xB0, 0x85, 0x89, 0x5D, 0x60, 0x51, 0x18, 0xE1, 0x0B, 0xEE, 0xB2,
  0x20,
  // "4" (U+0034)
  0x48, 0x13, 0xF6, 0x48, 0x1C, 0xF3, 0x30, 0x09, 0x93, 0x82, 0x5B, 0x6C, 0x28, 0x31, 0xD1, 0x98,
  0x28, 0xB0, 0xB4, 0x0D, 0x50, 0x79, 0x01, 0xF1, 0x0F, 0xEE, 0xEF, 0xE1, 0x11, 0x19, 0xA1, 0x40,
  0xC0, 0x52,
  // "5" (U+0035)
  0x20, 0xAB, 0x07, 0x20, 0xE0, 0x24, 0x05, 0x0B, 0x58, 0x2A, 0xED, 0x93, 0x83, 0x22, 0x3E, 0x85,
  0x08, 0x0B, 0x50, 0x80, 0xA5, 0x86, 0xC7, 0x06, 0x11, 0x8E, 0x28, 0x3B, 0xEE, 0xB2, 0x20,
  // "6" (U+0036)
  0x00, 0x04, 0xCF, 0xA0, 0x06, 0xC3, 0x01, 0x03, 0xD1, 0x00, 0x00, 0xA9, 0xCD, 0x40, 0x0E, 0xA2,
  0x9D, 0x03, 0xF1, 0x03, 0xF0, 0x5C, 0x00, 0x5D, 0x06, 0xB0, 0x09, 0x90, 0x4E, 0x24, 0xF2, 0x00,
  0x9E, 0xD5, 0x00,
  // "7" (U+0037)
  0x10, 0x6D, 0x50, 0xA0, 0x94, 0x81, 0x3E, 0x14, 0x0B, 0x07, 0x40, 0x40, 0xE5, 0x0C, 0x06, 0x40,
  0x60, 0xD5, 0x0D, 0x05, 0x40, 0x70, 0xC4, 0x81, 0x1E, 0x34,
  // "8" (U+0038)
  0x00, 0x5D, 0xFB, 0x10, 0x2F, 0x51, 0xC9, 0x05, 0xD0, 0x09, 0x80, 0x2E, 0x01, 0xD2, 0x00, 0x9A,
  0xA2, 0x00, 0x8C, 0x8E, 0x20, 0x7B, 0x00, 0xA9, 0x0C, 0x60, 0x08, 0xB0, 0xBA, 0x13, 0xE6, 0x02,
  0xBE, 0xD7, 0x00,
  // "9" (U+0039)
  0x00, 0x5D, 0xE9, 0x00, 0x4E, 0x32, 0xE3, 0x0B, 0x70, 0x0C, 0x60, 0xE3, 0x00, 0xE5, 0x0E, 0x60,
  0x8F, 0x30, 0x7F, 0xE9, 0xE0, 0x00, 0x00, 0x9A, 0x00, 0x00, 0x2E, 0x20, 0x10, 0x3D, 0x70, 0x0B,
  0xFD, 0x60, 0x00,
  // ":" (U+003A)
  0x18, 0x35, 0xE0, 0x5A, 0x75, 0x83, 0x78, 0x0B, 0x81,
  // ";" (U+003B)
  0x28, 0x14, 0xE1, 0x20, 0x50, 0xB7, 0x77, 0x10, 0x50, 0x93, 0x0C, 0x07, 0x20, 0x20, 0xE3, 0x07,
  0x05, 0x30,
  // "<" (U+003C)
  0x50, 0x20, 0x73, 0x87, 0x2A, 0xE6, 0x01, 0x9E, 0x72, 0x81, 0x3F, 0x95, 0x82, 0x7D, 0x92, 0x58,
  0x27, 0xEA, 0x25, 0x07, 0x0A,
  // "=" (U+003D)
  0x03, 0x80, 0x1E, 0x09, 0x18, 0x02, 0x17, 0x03, 0x80, 0x1E, 0x09, 0x18, 0x02, 0x10,
  // ">" (U+003E)
  0x03, 0x06, 0x58, 0x21, 0xBD, 0x55, 0x82, 0x3B, 0xC5, 0x58, 0x14, 0xEA, 0x38, 0x76, 0xDA, 0x20,
  0x6D, 0xA3, 0x28, 0x14, 0xB3, 0x40,
  // "?" (U+003F)
  0x18, 0x91, 0x5C, 0xEC, 0x10, 0x32, 0x1D, 0x74, 0x0C, 0x05, 0x30, 0x60, 0xC3, 0x81, 0x6C, 0x12,
  0x81, 0x3D, 0x13, 0x09, 0x05, 0x72, 0x02, 0x0C, 0x40, 0x50, 0xD4,
  // "@" (U+0040)
  0x38, 0x41, 0x9D, 0xFD, 0x53, 0x86, 0x2D, 0x72, 0x04, 0xD3, 0x28, 0xF2, 0xC3, 0x5E, 0xE5, 0x59,
  0x08, 0x74, 0xC1, 0xB3, 0x3A, 0x0D, 0x0B, 0x30, 0xE0, 0x59, 0x4A, 0x0E, 0x05, 0xA0, 0x95, 0x67,
  0x2D, 0x0B, 0x83, 0xD0, 0x77, 0x0D, 0xE4, 0xEE, 0x30, 0x5A, 0x72, 0x0D, 0x06, 0x20, 0x10, 0x24,
  0x84, 0x2B, 0xFE, 0xC3, 0x30,
  // "A" (U+0041)
  0x00, 0x00, 0x4F, 0x70, 0x00, 0x0C, 0xD7, 0x00, 0x04, 0xD9, 0x80, 0x00, 0xB7, 0x89, 0x00, 0x4F,
  0x18, 0x90, 0x0B, 0x90, 0x8A, 0x03, 0xFF, 0xEF, 0xB0, 0xBB, 0x22, 0x8B, 0x3F, 0x30, 0x07, 0xCA,
  0xA0, 0x00, 0x6D,
  // "B" (U+0042)
  0x00, 0xAF, 0xFD, 0x70, 0x00, 0xD5, 0x06, 0xF2, 0x01, 0xF1, 0x02, 0xF2, 0x05, 0xD0, 0x0A, 0xB0,
  0x09, 0xFE, 0xF9, 0x00, 0x0C, 0x71, 0x5F, 0x20, 0x0F, 0x30, 0x0D, 0x60, 0x3E, 0x00, 0x0F, 0x40,
  0x7B, 0x01, 0xAD, 0x00, 0xAF, 0xFE, 0xA1, 0x00,
  // "C" (U+0043)
  0x38, 0x35, 0xCF, 0xD5, 0x28, 0x90, 0x6E, 0x50, 0x31, 0x02, 0xF4, 0x50, 0x90, 0xB6, 0x0E, 0x05,
  0x58, 0x12, 0xF1, 0x50, 0x49, 0x68, 0x13, 0xF1, 0x68, 0x3D, 0x91, 0x12, 0x38, 0x33, 0xCF, 0xD5,
  0x20,
  // "D" (U+0044)
  0x00, 0xAF, 0xFC, 0x50, 0x00, 0xD5, 0x06, 0xF2, 0x01, 0xF2, 0x00, 0xD7, 0x05, 0xE0, 0x00, 0xB8,
  0x09, 0xA0, 0x00, 0xD7, 0x0C, 0x60, 0x00, 0xF4, 0x0F, 0x30, 0x05, 0xE0, 0x3F, 0x00, 0x1D, 0x60,
  0x7B, 0x03, 0xCA, 0x00, 0xAF, 0xFC, 0x60, 0x00,
  // "E" (U+0045)
  0x20, 0xAB, 0x0A, 0x20, 0xD0, 0x54, 0x81, 0x1F, 0x14, 0x05, 0x0D, 0x58, 0x39, 0xFE, 0xE7, 0x28,
  0x2C, 0x61, 0x13, 0x90, 0x24, 0x03, 0x0E, 0x50, 0x70, 0xB5, 0x0A, 0xB0, 0xA2,
  // "F" (U+0046)
  0x20, 0xAB, 0x0A, 0x20, 0xD0, 0x54, 0x81, 0x1F, 0x14, 0x05, 0x0C, 0x58, 0x39, 0xFE, 0xE6, 0x28,
  0x2C, 0x51, 0x13, 0x90, 0x14, 0x03, 0x0E, 0x50, 0x70, 0xB5, 0x0A, 0x08, 0x50,
  // "G" (U+0047)
  0x38, 0x44, 0xBE, 0xEB, 0x22, 0x84, 0x6E, 0x61, 0x15, 0x28, 0x13, 0xF4, 0x60, 0xA0, 0xB7, 0x98,
  0x90, 0x50, 0x3E, 0xE7, 0x03, 0xF1, 0x28, 0x31, 0xE5, 0x04, 0x93, 0x85, 0x1F, 0x10, 0x2F, 0x12,
  0x04, 0x0E, 0x38, 0x4D, 0xA1, 0x09, 0xA3, 0x84, 0x2B, 0xEE, 0xC4, 0x20,
  // "H" (U+0048)
  0x00, 0xA8, 0x00, 0x0E, 0x40, 0x0D, 0x50, 0x03, 0xF0, 0x01, 0xF1, 0x00, 0x7C, 0x00, 0x5D, 0x00,
  0x0A, 0x90, 0x08, 0xFE, 0xEE, 0xF5, 0x00, 0xC7, 0x22, 0x4F, 0x20, 0x0F, 0x20, 0x05, 0xE0, 0x03,
  0xE0, 0x00, 0x9A, 0x00, 0x7B, 0x00, 0x0C, 0x70, 0x0A, 0x80, 0x00, 0xF3, 0x00,
  // "I" (U+0049)
  0x28, 0x34, 0xEF, 0xB1, 0x30, 0x80, 0xA5, 0x0B, 0x07, 0x59, 0x03, 0x40, 0x39, 0x50, 0x70, 0xC5,
  0x0A, 0x08, 0x50, 0xD0, 0x54, 0x81, 0x1F, 0x13, 0x82, 0x5D, 0xFB, 0x30,
  // "J" (U+004A)
  0x50, 0xA0, 0x95, 0x0D, 0x05, 0x48, 0x11, 0xF2, 0x40, 0x40, 0xE5, 0x08, 0x0B, 0x50, 0xB0, 0x75,
  0x0E, 0x04, 0x48, 0x12, 0xF1, 0x40, 0x60, 0xD5, 0x00, 0x95, 0x0D, 0x05, 0x48, 0x14, 0xF1, 0x28,
  0x22, 0xEE, 0x54, 0x01, 0x50,
  // "K" (U+004B)
  0x00, 0xA8, 0x00, 0xB9, 0x00, 0xD5, 0x09, 0xB0, 0x01, 0xF1, 0x7D, 0x10, 0x05, 0xD5, 0xE2, 0x00,
  0x09, 0xCE, 0x60, 0x00, 0x0C, 0xDC, 0x80, 0x00, 0x0F, 0x36, 0xD0, 0x00, 0x3F, 0x02, 0xF2, 0x00,
  0x7B, 0x00, 0xD6, 0x00, 0xA8, 0x00, 0x9B, 0x00,
  // "L" (U+004C)
  0x00, 0xA8, 0x00, 0x0D, 0x50, 0x01, 0xF1, 0x00, 0x5D, 0x00, 0x09, 0xA0, 0x00, 0xC6, 0x00, 0x0F,
  0x30, 0x03, 0xE0, 0x00, 0x7C, 0x11, 0x1A, 0xFF, 0xF9,
  // "M" (U+004D)
  0x00, 0xAF, 0x30, 0x00, 0x5F, 0xB0, 0x0D, 0xF4, 0x00, 0x0C, 0xF7, 0x01, 0xFC, 0x50, 0x05, 0xCE,
  0x40, 0x5C, 0xA6, 0x00, 0xD7, 0xF0, 0x09, 0x99, 0x70, 0x5C, 0x6C, 0x00, 0xC5, 0x88, 0x0D, 0x4A,
  0x90, 0x0F, 0x27, 0x96, 0xB0, 0xD5, 0x03, 0xE0, 0x6A, 0xD3, 0x1F, 0x10, 0x7A, 0x05, 0xFB, 0x05,
  0xD0, 0x0A, 0x70, 0x4F, 0x30, 0x8A, 0x00,
  // "N" (U+004E)
  0x00, 0xAF, 0x00, 0x07, 0xB0, 0x0D, 0xF3, 0x00, 0xA7, 0x01, 0xFA, 0x70, 0x0E, 0x40, 0x5C, 0x6B,
  0x02, 0xF0, 0x09, 0x92, 0xE0, 0x6C, 0x00, 0xC5, 0x0E, 0x39, 0x90, 0x0F, 0x20, 0xA7, 0xC5, 0x03,
  0xE0, 0x07, 0xBF, 0x10, 0x7A, 0x00, 0x3F, 0xD0, 0x0A, 0x70, 0x00, 0xEA, 0x00,
  // "O" (U+004F)
  0x00, 0x06, 0xDE, 0xC2, 0x00, 0x08, 0xD3, 0x19, 0xC0, 0x02, 0xF2, 0x00, 0x3F, 0x10, 0xAA, 0x00,
  0x02, 0xF1, 0x0E, 0x50, 0x00, 0x4F, 0x02, 0xF1, 0x00, 0x07, 0xC0, 0x4F, 0x00, 0x00, 0xC7, 0x03,
  0xF1, 0x00, 0x5E, 0x10, 0x0E, 0x80, 0x4E, 0x60, 0x00, 0x4C, 0xFD, 0x50, 0x00,
  // "P" (U+0050)
  0x20, 0xAA, 0x0C, 0x03, 0x28, 0x95, 0xD5, 0x1A, 0xC0, 0x1F, 0x10, 0x5E, 0x05, 0xD2, 0x89, 0x57,
  0xC0, 0x9A, 0x04, 0xE5, 0x0C, 0xEF, 0xD6, 0x29, 0x04, 0x40, 0x39, 0x50, 0x70, 0xB5, 0x0A, 0x08,
  0x50,
  // "Q" (U+0051)
  0x38, 0x36, 0xDE, 0xB2, 0x38, 0x47, 0xD3, 0x19, 0xC2, 0x81, 0x2F, 0x22, 0x84, 0x3F, 0x10, 0xAA,
  0x38, 0x42, 0xF1, 0x0E, 0x53, 0x84, 0x4F, 0x02, 0xF1, 0x38, 0x27, 0xC0, 0x49, 0x48, 0x4C, 0x70,
  0x3F, 0x12, 0x81, 0x4E, 0x12, 0x84, 0xE8, 0x04, 0xE6, 0x30, 0x40, 0xDA, 0x05, 0x68, 0x13, 0xF2,
  0x70, 0xC0, 0x97, 0x04, 0x07, 0x30,
  // "R" (U+0052)
  0x00, 0xAF, 0xFC, 0x30, 0x0D, 0x51, 0xAC, 0x01, 0xF2, 0x05, 0xE0, 0x5E, 0x00, 0x7C, 0x09, 0xB0,
  0x3E, 0x60, 0xCF, 0xEE, 0x60, 0x0F, 0x57, 0xD0, 0x03, 0xF0, 0x2F, 0x20, 0x7C, 0x00, 0xD6, 0x0A,
  0x80, 0x09, 0xB0,
  // "S" (U+0053)
  0x38, 0x37, 0xDF, 0xD5, 0x28, 0x46, 0xE3, 0x04, 0x22, 0x0A, 0x09, 0x60, 0x90, 0xC6, 0x82, 0x2E,
  0xB1, 0x58, 0x11, 0xDC, 0x68, 0x12, 0xF4, 0x69, 0x04, 0x28, 0x93, 0x51, 0x18, 0xE1, 0x01, 0xCE,
  0xEB, 0x22,
  // "T" (U+0054)
  0x09, 0xC0, 0xE2, 0x0B, 0x08, 0x40, 0xE0, 0x53, 0x81, 0x2F, 0x13, 0x05, 0x0D, 0x40, 0x90, 0xA4,
  0x0D, 0x06, 0x38, 0x11, 0xF3, 0x30, 0x40, 0xE4, 0x07, 0x0B, 0x40,
  // "U" (U+0055)
  0x00, 0xB7, 0x00, 0x0F, 0x30, 0x0E, 0x40, 0x04, 0xE0, 0x03, 0xF0, 0x00, 0x7B, 0x00, 0x6C, 0x00,
  0x0B, 0x70, 0x0A, 0x80, 0x00, 0xE4, 0x00, 0xE5, 0x00, 0x3F, 0x00, 0x2F, 0x10, 0x07, 0xC0, 0x04,
  0xF0, 0x00, 0xC7, 0x00, 0x2F, 0x52, 0x7E, 0x10, 0x00, 0x6D, 0xFC, 0x30, 0x00,
  // "V" (U+0056)
  0xA9, 0x00, 0x09, 0xB9, 0x90, 0x01, 0xF4, 0x99, 0x00, 0x8C, 0x08, 0xA0, 0x0E, 0x40, 0x8A, 0x07,
  0xC0, 0x07, 0xB0, 0xE4, 0x00, 0x6B, 0x6C, 0x00, 0x06, 0xBD, 0x50, 0x00, 0x5E, 0xC0, 0x00, 0x04,
  0xF5, 0x00, 0x00,
  // "W" (U+0057)
  0x99, 0x00, 0x2F, 0x30, 0x09, 0xA9, 0x90, 0x09, 0xF3, 0x00, 0xE3, 0x98, 0x01, 0xED, 0x30, 0x6C,
  0x09, 0x80, 0x79, 0xC3, 0x0D, 0x50, 0x98, 0x0D, 0x2C, 0x34, 0xE0, 0x09, 0x85, 0xB0, 0xD3, 0xB7,
  0x00, 0x98, 0xC4, 0x0D, 0x5E, 0x10, 0x0A, 0xAD, 0x00, 0xDB, 0x90, 0x00, 0xAF, 0x60, 0x0D, 0xF2,
  0x00, 0x0A, 0xE0, 0x00, 0xDB, 0x00, 0x00,
  // "X" (U+0058)
  0x20, 0x39, 0x28, 0x14, 0xE1, 0x39, 0x82, 0x30, 0xD5, 0x48, 0x2C, 0x68, 0xA5, 0x82, 0x8C, 0xE1,
  0x58, 0x15, 0xF5, 0x68, 0x1C, 0xF4, 0x58, 0x27, 0xCB, 0x74, 0x83, 0x2E, 0x28, 0xA4, 0x83, 0xC7,
  0x05, 0xE3, 0x08, 0x0C, 0x28, 0x12, 0xF2, 0x20,
  // "Y" (U+0059)
  0x00, 0x92, 0x83, 0x4E, 0x16, 0xC2, 0x86, 0xD6, 0x04, 0xE0, 0x7C, 0x28, 0x31, 0xF2, 0xE3, 0x38,
  0x1E, 0xC9, 0x48, 0x1C, 0xE1, 0x40, 0xB0, 0x75, 0x90, 0x44, 0x03, 0x95, 0x07, 0x0C, 0x50,
  // "Z" (U+005A)
  0x20, 0x3C, 0x09, 0x58, 0x14, 0xF2, 0x50, 0xD0, 0x75, 0x08, 0x0C, 0x58, 0x13, 0xF2, 0x50, 0xD0,
  0x75, 0x08, 0x0C, 0x58, 0x13, 0xF2, 0x50, 0xD0, 0x75, 0x05, 0xC0, 0xB2,
  // "[" (U+005B)
  0x30, 0x9A, 0x03, 0x30, 0xD0, 0x45, 0x90, 0x14, 0x04, 0x0D, 0x50, 0x70, 0xA5, 0x0A, 0x06, 0x50,
  0xE0, 0x34, 0x01, 0x95, 0x05, 0x0C, 0x50, 0x08, 0x50, 0xB0, 0x55, 0x90, 0x24, 0x82, 0x3F, 0xE9,
  0x40, 0x01, 0x40,
  // "\" (U+005C)
  0x6B, 0x03, 0xD0, 0x1F, 0x00, 0xE2, 0x0C, 0x40, 0xA6, 0x08, 0x90, 0x6B, 0x04, 0xD0, 0x1F,
  // "]" (U+005D)
  0x20, 0x5A, 0x08, 0x40, 0xC0, 0x44, 0x90, 0x13, 0x03, 0x0D, 0x40, 0x70, 0xA4, 0x0A, 0x07, 0x40,
  0xD0, 0x33, 0x01, 0x94, 0x04, 0x0C, 0x40, 0x80, 0x94, 0x0B, 0x05, 0x40, 0xE0, 0x22, 0x81, 0xCE,
  0xE3, 0x0F, 0x13,
  // "^" (U+005E)
  0x00, 0x09, 0x90, 0x00, 0x03, 0xDE, 0x00, 0x00, 0xB5, 0xC5, 0x00, 0x4C, 0x06, 0xA0, 0x0D, 0x40,
  0x1E, 0x06, 0xB0, 0x00, 0xB5,
  // "_" (U+005F)
  0x3E, 0xEE, 0xEA, 0x01, 0x11, 0x10,
  // "`" (U+0060)
  0x33, 0x06, 0xD0, 0x0C, 0x30,
  // "a" (U+0061)
  0x00, 0x6E, 0xD5, 0xC0, 0x5E, 0x33, 0xE9, 0x0D, 0x70, 0x0E, 0x52, 0xF1, 0x01, 0xF2, 0x6D, 0x00,
  0x5E, 0x07, 0xB0, 0x0B, 0xB0, 0x6D, 0x16, 0xE7, 0x01, 0xCE, 0x7B, 0x40,
  // "b" (U+0062)
  0x20, 0x09, 0x50, 0xC0, 0x65, 0x90, 0x24, 0x89, 0x63, 0xE7, 0xEC, 0x10, 0x7E, 0x71, 0xD6, 0x0A,
  0xB2, 0x83, 0xB8, 0x0D, 0x42, 0x89, 0x0C, 0x61, 0xF1, 0x01, 0xF3, 0x59, 0x28, 0x95, 0x6D, 0x08,
  0xF3, 0x3E, 0x50, 0xB5, 0xDE, 0x62,
  // "c" (U+0063)
  0x00, 0x6D, 0xE7, 0x05, 0xE3, 0x11, 0x0D, 0x50, 0x00, 0x3F, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x7B,
  0x00, 0x00, 0x5E, 0x21, 0x20, 0x09, 0xED, 0x30,
  // "d" (U+0064)
  0x60, 0xB0, 0x76, 0x0E, 0x04, 0x50, 0x29, 0x38, 0x36, 0xEC, 0x6C, 0x28, 0x45, 0xE3, 0x2E, 0x92,
  0x0D, 0x06, 0x28, 0x93, 0xE5, 0x02, 0xF1, 0x01, 0xF2, 0x06, 0xC2, 0x05, 0x0E, 0x20, 0x70, 0xB2,
  0x00, 0xB2, 0x84, 0x6D, 0x17, 0xE7, 0x28, 0x41, 0xCE, 0x6B, 0x42,
  // "e" (U+0065)
  0x00, 0x6D, 0xE7, 0x05, 0xD2, 0x5D, 0x0D, 0x31, 0xAA, 0x4F, 0xEE, 0x80, 0x7B, 0x00, 0x00, 0x7B,
  0x00, 0x00, 0x5E, 0x31, 0x40, 0x09, 0xEE, 0x80,
  // "f" (U+0066)
  0x48, 0x21, 0xBE, 0x54, 0x81, 0x8A, 0x15, 0x0D, 0x04, 0x40, 0x10, 0xBA, 0x05, 0x40, 0x50, 0xD6,
  0x00, 0x96, 0x0C, 0x06, 0x69, 0x02, 0x50, 0x40, 0xE6, 0x07, 0x0B, 0x60, 0xB0, 0x76, 0x0E, 0x03,
  0x50, 0x50, 0xE5, 0x81, 0xBE, 0x45,
  // "g" (U+0067)
  0x00, 0x06, 0xED, 0x5C, 0x00, 0x5E, 0x33, 0xE8, 0x00, 0xD6, 0x00, 0xF5, 0x02, 0xF1, 0x01, 0xF1,
  0x06, 0xC0, 0x05, 0xD0, 0x07, 0xB0, 0x0B, 0xA0, 0x06, 0xD1, 0x7F, 0x60, 0x01, 0xCE, 0x7E, 0x30,
  0x00, 0x00, 0x3E, 0x00, 0x03, 0x02, 0xC7, 0x00, 0x1C, 0xED, 0x80, 0x00,
  // "h" (U+0068)
  0x20, 0x09, 0x50, 0xC0, 0x65, 0x90, 0x24, 0x89, 0x63, 0xE7, 0xEC, 0x10, 0x7E, 0x61, 0xE5, 0x0A,
  0xA2, 0x8A, 0x0E, 0x40, 0xD5, 0x02, 0xF1, 0x1F, 0x10, 0x5D, 0x05, 0xD2, 0x83, 0x89, 0x08, 0xA2,
  0x83, 0xC6, 0x0B, 0x62, 0x90, 0x31,
  // "i" (U+0069)
  0x00, 0x96, 0x00, 0x00, 0x00, 0x00, 0x04, 0xE0, 0x07, 0xA0, 0x0B, 0x70, 0x0E, 0x40, 0x2F, 0x10,
  0x5D, 0x00, 0x89, 0x00, 0xB6, 0x00,
  // "j" (U+006A)
  0x40, 0x90, 0x67, 0x71, 0x04, 0x0E, 0x40, 0x70, 0xA4, 0x0B, 0x07, 0x40, 0xE0, 0x33, 0x02, 0x94,
  0x06, 0x0C, 0x40, 0x90, 0x84, 0x0D, 0x05, 0x38, 0x11, 0xF1, 0x30, 0x70, 0xC3, 0x81, 0xDD, 0x33,
  // "k" (U+006B)
  0x20, 0x80, 0x95, 0x0C, 0x06, 0x59, 0x02, 0x48, 0x92, 0x3E, 0x02, 0xE3, 0x06, 0xB1, 0xD5, 0x28,
  0x2A, 0x7B, 0x83, 0x0D, 0x0C, 0x93, 0x83, 0x1F, 0x9F, 0x32, 0x83, 0x5D, 0x0C, 0x72, 0x83, 0x89,
  0x08, 0xB2, 0x83, 0xB6, 0x04, 0xE2,
  // "l" (U+006C)
  0x00, 0x89, 0x00, 0xC6, 0x00, 0xF3, 0x03, 0xE0, 0x06, 0xB0, 0x0A, 0x80, 0x0D, 0x40, 0x1F, 0x10,
  0x5D, 0x00, 0x89, 0x00, 0xB6, 0x00,
  // "m" (U+006D)
  0x04, 0xB7, 0xEB, 0x2C, 0xE6, 0x07, 0xE5, 0x2F, 0xC2, 0x8C, 0x0B, 0xA0, 0x0F, 0x40, 0x7B, 0x0E,
  0x50, 0x4E, 0x00, 0xA8, 0x2F, 0x10, 0x7B, 0x00, 0xD4, 0x5D, 0x00, 0xA7, 0x01, 0xF1, 0x8A, 0x00,
  0xE4, 0x05, 0xD0, 0xB6, 0x01, 0xF1, 0x08, 0xA0,
  // "n" (U+006E)
  0x04, 0xB7, 0xEC, 0x10, 0x7E, 0x61, 0xE5, 0x0B, 0xA0, 0x0E, 0x40, 0xE5, 0x02, 0xF1, 0x2F, 0x10,
  0x5D, 0x05, 0xD0, 0x09, 0xA0, 0x8A, 0x00, 0xC6, 0x0C, 0x60, 0x0F, 0x30,
  // "o" (U+006F)
  0x00, 0x6E, 0xE7, 0x00, 0x5D, 0x23, 0xF2, 0x0D, 0x50, 0x0E, 0x43, 0xE0, 0x00, 0xF3, 0x6C, 0x00,
  0x3F, 0x17, 0xB0, 0x08, 0xA0, 0x5E, 0x14, 0xE3, 0x00, 0x9E, 0xD4, 0x00,
  // "p" (U+0070)
  0x28, 0x44, 0xB6, 0xEC, 0x12, 0x84, 0x7E, 0x71, 0xD6, 0x20, 0x0B, 0x20, 0xB0, 0x72, 0x0E, 0x05,
  0x28, 0x92, 0xC6, 0x02, 0xF1, 0x01, 0xF3, 0x05, 0x92, 0x06, 0x0D, 0x28, 0x49, 0xF3, 0x3E, 0x52,
  0x83, 0xC7, 0xDE, 0x63, 0x90, 0x25, 0x04, 0x0E, 0x60, 0x70, 0xA6,
  // "q" (U+0071)
  0x00, 0x7E, 0xD5, 0xC0, 0x5E, 0x33, 0xE8, 0x0D, 0x60, 0x0F, 0x52, 0xF1, 0x01, 0xF1, 0x6C, 0x00,
  0x5D, 0x07, 0xB0, 0x0B, 0xA0, 0x6D, 0x17, 0xE6, 0x01, 0xCE, 0x7E, 0x30, 0x00, 0x03, 0xE0, 0x00,
  0x00, 0x6B, 0x00, 0x00, 0x0A, 0x80, 0x00,
  // "r" (U+0072)
  0x18, 0x90, 0x4B, 0x8F, 0x20, 0x7E, 0x61, 0x20, 0xB0, 0xA4, 0x0E, 0x05, 0x38, 0x12, 0xF1, 0x30,
  0x50, 0xD4, 0x08, 0x0A, 0x40, 0xB0, 0x64,
  // "s" (U+0073)
  0x04, 0xDE, 0xC1, 0x0E, 0x61, 0x40, 0x0F, 0x30, 0x00, 0x09, 0xD2, 0x00, 0x00, 0x9D, 0x10, 0x00,
  0x0E, 0x40, 0x40, 0x4F, 0x20, 0xCF, 0xD6, 0x00,
  // "t" (U+0074)
  0x00, 0x85, 0x00, 0x0E, 0x20, 0x1E, 0xFF, 0x50, 0x7B, 0x00, 0x0A, 0x70, 0x00, 0xE4, 0x00, 0x2F,
  0x10, 0x05, 0xD0, 0x00, 0x7C, 0x10, 0x03, 0xEE, 0x00,
  // "u" (U+0075)
  0x05, 0xD0, 0x08, 0xA0, 0x8A, 0x00, 0xB6, 0x0B, 0x70, 0x0F, 0x30, 0xE3, 0x03, 0xF0, 0x3F, 0x00,
  0x7C, 0x06, 0xC0, 0x0C, 0x90, 0x7D, 0x28, 0xE5, 0x02, 0xDE, 0x5D, 0x20,
  // "v" (U+0076)
  0x2F, 0x00, 0x2F, 0x21, 0xF1, 0x08, 0xA0, 0x0F, 0x11, 0xE3, 0x00, 0xF2, 0x7B, 0x00, 0x0E, 0x2D,
  0x30, 0x00, 0xE8, 0xC0, 0x00, 0x0D, 0xE4, 0x00, 0x00, 0xCD, 0x00, 0x00,
  // "w" (U+0077)
  0x1F, 0x10, 0x9E, 0x00, 0xC6, 0x1F, 0x11, 0xEE, 0x03, 0xE0, 0x1F, 0x17, 0x9E, 0x09, 0x80, 0x1F,
  0x1D, 0x3D, 0x0E, 0x20, 0x1F, 0x5B, 0x1D, 0x6B, 0x00, 0x1F, 0xA5, 0x2D, 0xC4, 0x00, 0x1F, 0xD0,
  0x2E, 0xD0, 0x00, 0x1F, 0x70, 0x2F, 0x70, 0x00,
  // "x" (U+0078)
  0x28, 0x4B, 0x80, 0x5D, 0x12, 0x83, 0x7B, 0x1E, 0x43, 0x82, 0x2F, 0xA8, 0x50, 0xE0, 0xC5, 0x81,
  0x3F, 0xB5, 0x0D, 0x07, 0x94, 0x83, 0x9A, 0x0E, 0x42, 0x84, 0x4E, 0x10, 0xA8, 0x20,
  // "y" (U+0079)
  0x28, 0x51, 0xF1, 0x01, 0xF2, 0x39, 0x82, 0x20, 0x8A, 0x48, 0x3E, 0x31, 0xE3, 0x48, 0x2D, 0x37,
  0xA5, 0x82, 0xC4, 0xE3, 0x58, 0x1B, 0xAA, 0x68, 0x1A, 0xF3, 0x60, 0x0A, 0x68, 0x11, 0xE3, 0x60,
  0xA0, 0x95, 0x81, 0x5F, 0xB6,
  // "z" (U+007A)
  0x20, 0xAB, 0x02, 0x40, 0x90, 0xA4, 0x81, 0x3E, 0x14, 0x0D, 0x05, 0x40, 0x80, 0xB4, 0x81, 0x2E,
  0x24, 0x0C, 0x07, 0x40, 0x5B, 0x0C, 0x20,
  // "{" (U+007B)
  0x38, 0x13, 0xCB, 0x30, 0xD0, 0x73, 0x02, 0x94, 0x05, 0x0C, 0x40, 0x09, 0x38, 0x12, 0xE3, 0x28,
  0x18, 0xE5, 0x38, 0x11, 0x9A, 0x40, 0x60, 0xB4, 0x09, 0x08, 0x40, 0xD0, 0x54, 0x0E, 0x05, 0x48,
  0x17, 0xF4, 0x20,
  // "|" (U+007C)
  0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B,
  // "}" (U+007D)
  0x28, 0x13, 0xE7, 0x40, 0x60, 0xE4, 0x04, 0x0D, 0x40, 0x70, 0xA4, 0x0A, 0x07, 0x40, 0xB0, 0x84,
  0x81, 0x4E, 0x92, 0x81, 0x2E, 0x53, 0x08, 0x09, 0x40, 0xB0, 0x64, 0x90, 0x23, 0x06, 0x0E, 0x38,
  0x1B, 0xE5, 0x30,
  // "~" (U+007E)
  0x0A, 0xD9, 0x20, 0x64, 0x62, 0x8E, 0xE6,
  // "¡" (U+00A1)
  0x28, 0x11, 0xD4, 0x28, 0x12, 0xC2, 0x70, 0x06, 0x30, 0xA0, 0x53, 0x0E, 0x02, 0x20, 0x20, 0xE3,
  0x06, 0x0C, 0x30, 0xA0, 0x93, 0x0E, 0x06, 0x28, 0x12, 0xD3, 0x20,
  // "¢" (U+00A2)
  0x30, 0x70, 0x53, 0x89, 0x38, 0xEB, 0x20, 0x9C, 0x34, 0x03, 0xE1, 0x30, 0x09, 0x40, 0xB0, 0x64,
  0x82, 0xC9, 0x01, 0x28, 0x29, 0xFE, 0xD3, 0x0A, 0x07, 0x40, 0x80, 0x43,
  // "£" (U+00A3)
  0x48, 0x26, 0xDE, 0xB3, 0x83, 0x3E, 0x31, 0x33, 0x09, 0x0A, 0x60, 0xD0, 0x54, 0x84, 0x3E, 0xFE,
  0xE1, 0x38, 0x25, 0xE1, 0x14, 0x07, 0x0B, 0x60, 0xC0, 0x75, 0x81, 0x6C, 0x14, 0x02, 0xD0, 0x31,
  // "¤" (U+00A4)
  0x20, 0x00, 0x02, 0x0C, 0x8D, 0xE8, 0xD1, 0x4D, 0x21, 0xB7, 0x09, 0x50, 0x01, 0xB0, 0x94, 0x00,
  0x1C, 0x05, 0xC1, 0x0A, 0x70, 0xBA, 0xEE, 0xBD, 0x13, 0x00, 0x00, 0x30,
  // "¥" (U+00A5)
  0x10, 0x29, 0x28, 0x13, 0xE1, 0x29, 0x82, 0x20, 0xB6, 0x38, 0x2D, 0x45, 0xC4, 0x82, 0xB6, 0xD3,
  0x48, 0x19, 0xE9, 0x48, 0x3D, 0xEF, 0xE8, 0x38, 0x21, 0x9A, 0x13, 0x84, 0x6E, 0xFE, 0xE1, 0x38,
  0x21, 0xE4, 0x14, 0x02, 0x95,
  // "¦" (U+00A6)
  0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x00, 0x00, 0x00, 0x00, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B,
  // "§" (U+00A7)
  0x00, 0x5D, 0xEB, 0x01, 0xF3, 0x14, 0x02, 0xE1, 0x00, 0x00, 0xCD, 0x40, 0x0A, 0x75, 0xE2, 0x0F,
  0x10, 0xB4, 0x0B, 0xA4, 0xC0, 0x00, 0x8F, 0x20, 0x00, 0x0A, 0x70, 0x41, 0x2D, 0x50, 0xAE, 0xE8,
  0x00,
  // "¨" (U+00A8)
  0x1C, 0x09, 0x50,
  // "©" (U+00A9)
  0x38, 0x43, 0x9D, 0xDB, 0x65, 0x87, 0x8D, 0x62, 0x24, 0xAC, 0x12, 0x89, 0x05, 0xB0, 0x2B, 0xDB,
  0x25, 0xC2, 0x85, 0xD1, 0x0E, 0x72, 0x42, 0x85, 0xA5, 0x2B, 0x05, 0xC5, 0x85, 0x49, 0x49, 0x07,
  0x95, 0x85, 0x2B, 0x2A, 0x06, 0xB5, 0x89, 0x03, 0xA0, 0xD0, 0x1E, 0x30, 0x12, 0x89, 0x38, 0x60,
  0x79, 0x05, 0xEE, 0xE1, 0x3D, 0x38, 0x1A, 0xB3, 0x28, 0x21, 0x7E, 0x34, 0x85, 0x6C, 0xFE, 0xE9,
  0x27, 0x10, 0x15,
  // "ª" (U+00AA)
  0x1B, 0xBB, 0x2A, 0x41, 0xD0, 0xE0, 0x59, 0x09, 0xBA, 0x60,
  // "«" (U+00AB)
  0x00, 0x58, 0x09, 0x30, 0x4D, 0x28, 0xB0, 0x3E, 0x36, 0xD1, 0x04, 0xE0, 0x9A, 0x00, 0x0C, 0x52,
  0xE1, 0x00, 0x5A, 0x0A, 0x50,
  // "¬" (U+00AC)
  0x03, 0x80, 0x1E, 0x86, 0x90, 0x11, 0x11, 0x79, 0x50, 0x60, 0x95, 0x06, 0x09,
  // "®" (U+00AE)
  0x00, 0x03, 0x9D, 0xDB, 0x60, 0x00, 0x00, 0x8D, 0x62, 0x24, 0xAC, 0x10, 0x05, 0xB0, 0xAE, 0xD8,
  0x05, 0xC0, 0x0D, 0x10, 0xB5, 0x2D, 0x40, 0xA5, 0x2B, 0x00, 0xB4, 0x1D, 0x40, 0x49, 0x49, 0x00,
  0xBE, 0xFA, 0x00, 0x2B, 0x2A, 0x00, 0xB5, 0x8A, 0x00, 0x3A, 0x0D, 0x00, 0xB4, 0x0E, 0x30, 0x86,
  0x07, 0x90, 0x73, 0x05, 0x63, 0xD0, 0x00, 0xAB, 0x30, 0x01, 0x7E, 0x30, 0x00, 0x06, 0xCF, 0xEE,
  0x92, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00,
  // "¯" (U+00AF)
  0x6E, 0xEE, 0xEE, 0x70, 0x11, 0x11, 0x10,
  // "°" (U+00B0)
  0x06, 0xDC, 0x42, 0xD2, 0x3D, 0x3C, 0x01, 0xE0, 0x9E, 0xE6,
  // "±" (U+00B1)
  0x30, 0xC0, 0x45, 0x0C, 0x04, 0x50, 0xC0, 0x42, 0x89, 0x43, 0xEE, 0xFE, 0xEA, 0x01, 0x1C, 0x51,
  0x13, 0x0C, 0x04, 0x50, 0xC0, 0x47, 0x20, 0x4D, 0x0B,
  // "²" (U+00B2)
  0x00, 0x9D, 0x90, 0x00, 0x40, 0xE1, 0x00, 0x01, 0xD0, 0x00, 0x0B, 0x50, 0x00, 0x97, 0x00, 0x09,
  0x80, 0x00, 0x3E, 0xDD, 0x40,
  // "³" (U+00B3)
  0x00, 0xAD, 0x90, 0x00, 0x30, 0xE1, 0x00, 0x02, 0xC0, 0x00, 0xBE, 0x20, 0x00, 0x07, 0x80, 0x01,
  0x09, 0x70, 0x1C, 0xD9, 0x00,
  // "´" (U+00B4)
  0x00, 0x65, 0x04, 0xE2, 0x1C, 0x20,
  // "µ" (U+00B5)
  0x00, 0x4E, 0x00, 0x8A, 0x00, 0x8A, 0x00, 0xB7, 0x00, 0xB7, 0x00, 0xE3, 0x00, 0xE4, 0x02, 0xF0,
  0x03, 0xF1, 0x06, 0xC0, 0x06, 0xD0, 0x0B, 0x90, 0x09, 0xD0, 0x6F, 0x60, 0x0D, 0xCE, 0x8D, 0x20,
  0x1F, 0x20, 0x00, 0x00, 0x4E, 0x00, 0x00, 0x00, 0x8A, 0x00, 0x00, 0x00,
  // "¶" (U+00B6)
  0x08, 0xEF, 0xFE, 0x5F, 0xFE, 0x0C, 0x9F, 0xFE, 0x0C, 0xAF, 0xFE, 0x0C, 0x9F, 0xFE, 0x0C, 0x6F,
  0xFE, 0x0C, 0x0A, 0xEE, 0x0C, 0x00, 0x0C, 0x0C, 0x00, 0x0C, 0x0C, 0x00, 0x0C, 0x0C, 0x00, 0x0C,
  0x0C, 0x00, 0x0C, 0x0C, 0x00, 0x0C, 0x0C,
  // "·" (U+00B7)
  0x69, 0xA9,
  // "¸" (U+00B8)
  0x00, 0x60, 0x01, 0xC4, 0x00, 0x69, 0x1B, 0xB2,
  // "¹" (U+00B9)
  0x03, 0x57, 0xE7, 0x6A, 0x40, 0xD1, 0x1D, 0x04, 0xA0, 0x77, 0x00,
  // "º" (U+00BA)
  0x1B, 0xC8, 0x94, 0x0D, 0xD0, 0x3A, 0x8C, 0xB1,
  // "»" (U+00BB)
  0x0B, 0x12, 0xB0, 0x09, 0x80, 0xD4, 0x03, 0xF1, 0x8B, 0x05, 0xD1, 0x9B, 0x3E, 0x27, 0xC0, 0xB4,
  0x1C, 0x10,
  // "¼" (U+00BC)
  0x30, 0x30, 0x57, 0x81, 0x7E, 0x72, 0x81, 0x1C, 0x12, 0x81, 0x6A, 0x42, 0x0B, 0x04, 0x48, 0x4D,
  0x10, 0x97, 0x13, 0x86, 0x1D, 0x05, 0xA4, 0xF1, 0x28, 0x54, 0xA3, 0xC2, 0xCD, 0x38, 0x57, 0x8C,
  0x2A, 0x79, 0x48, 0x4B, 0x47, 0x58, 0x63, 0x85, 0x88, 0x1D, 0xCE, 0xC2, 0x05, 0x0B, 0x40, 0xE2,
  0x81, 0x2C, 0x14, 0x05, 0x20,
  // "½" (U+00BD)
  0x30, 0x30, 0x57, 0x18, 0x17, 0xE7, 0x28, 0x11, 0xC1, 0x38, 0x16, 0xA4, 0x20, 0xB0, 0x45, 0x83,
  0xD1, 0x09, 0x75, 0x86, 0x1D, 0x05, 0xA9, 0xD9, 0x38, 0x74, 0xA3, 0xC0, 0x40, 0xE1, 0x28, 0x27,
  0x8C, 0x22, 0x01, 0x0D, 0x40, 0xB0, 0x43, 0x0B, 0x05, 0x30, 0x08, 0x30, 0x90, 0x73, 0x05, 0x0B,
  0x30, 0x90, 0x83, 0x81, 0x2C, 0x12, 0x83, 0x3E, 0xDD, 0x41,
  // "¾" (U+00BE)
  0x28, 0x1A, 0xD9, 0x71, 0x82, 0x30, 0xE1, 0x28, 0x11, 0xC1, 0x30, 0x20, 0xC3, 0x0B, 0x04, 0x38,
  0x1B, 0xE2, 0x28, 0x19, 0x71, 0x48, 0xB3, 0x78, 0x05, 0xA4, 0xF1, 0x01, 0x09, 0x73, 0xC2, 0xCD,
  0x01, 0xCD, 0x91, 0xC2, 0xA7, 0x95, 0x84, 0xB4, 0x75, 0x86, 0x48, 0x58, 0x81, 0xDC, 0xEC, 0x30,
  0x50, 0xB4, 0x0E, 0x38, 0x12, 0xC1, 0x40, 0x52,
  // "¿" (U+00BF)
  0x40, 0xD0, 0x54, 0x0C, 0x03, 0x72, 0x05, 0x09, 0x38, 0x11, 0xD3, 0x28, 0x11, 0xC6, 0x30, 0xC0,
  0x63, 0x05, 0x0C, 0x48, 0x91, 0x7D, 0x12, 0x30, 0x1C, 0xFC, 0x51,
  // "À" (U+00C0)
  0x40, 0x03, 0x50, 0x60, 0xD6, 0x0C, 0x03, 0x77, 0x48, 0x14, 0xF7, 0x48, 0x1C, 0xD7, 0x38, 0x24,
  0xD9, 0x83, 0x82, 0xB7, 0x89, 0x28, 0x34, 0xF1, 0x89, 0x28, 0x5B, 0x90, 0x8A, 0x03, 0xA8, 0x93,
  0xEF, 0xB0, 0xBB, 0x22, 0x8B, 0x3F, 0x32, 0x82, 0x7C, 0xAA, 0x30, 0x60, 0xD0,
  // "Á" (U+00C1)
  0x60, 0x60, 0x55, 0x81, 0x4E, 0x24, 0x81, 0x1C, 0x27, 0x77, 0x81, 0x4F, 0x75, 0x81, 0xCD, 0x74,
  0x82, 0x4D, 0x98, 0x48, 0x2B, 0x78, 0x93, 0x83, 0x4F, 0x18, 0x93, 0x83, 0xB9, 0x08, 0xA2, 0x03,
  0xA8, 0x1E, 0xFB, 0x28, 0x90, 0xBB, 0x22, 0x8B, 0x03, 0xF3, 0x28, 0x37, 0xC0, 0xAA, 0x30, 0x60,
  0xD1,
  // "Â" (U+00C2)
  0x50, 0x40, 0x55, 0x82, 0x2D, 0xE1, 0x38, 0x31, 0xB2, 0x67, 0x77, 0x68, 0x14, 0xF7, 0x58, 0x1C,
  0xD7, 0x48, 0x24, 0xD9, 0x84, 0x82, 0xB7, 0x89, 0x38, 0x34, 0xF1, 0x89, 0x38, 0x3B, 0x90, 0x8A,
  0x20, 0x3A, 0x81, 0xEF, 0xB2, 0x89, 0x0B, 0xB2, 0x28, 0xB0, 0x3F, 0x32, 0x83, 0x7C, 0x0A, 0xA3,
  0x06, 0x0D, 0x10,
  // "Ã" (U+00C3)
  0x48, 0x38, 0xC3, 0x64, 0x38, 0x32, 0xB4, 0xDC, 0x77, 0x72, 0x81, 0x4F, 0x76, 0x81, 0xCD, 0x75,
  0x82, 0x4D, 0x98, 0x58, 0x2B, 0x78, 0x94, 0x83, 0x4F, 0x18, 0x94, 0x83, 0xB9, 0x08, 0xA3, 0x03,
  0xA8, 0x1E, 0xFB, 0x38, 0x4B, 0xB2, 0x28, 0xB2, 0x81, 0x3F, 0x32, 0x07, 0x0C, 0x20, 0x0A, 0x30,
  0x60, 0xD2,
  // "Ä" (U+00C4)
  0x38, 0x31, 0xC0, 0x95, 0x77, 0x77, 0x81, 0x4F, 0x75, 0x81, 0xCD, 0x74, 0x82, 0x4D, 0x98, 0x48,
  0x2B, 0x78, 0x93, 0x83, 0x4F, 0x18, 0x93, 0x83, 0xB9, 0x08, 0xA2, 0x03, 0xA8, 0x1E, 0xFB, 0x28,
  0x90, 0xBB, 0x22, 0x8B, 0x03, 0xF3, 0x28, 0x37, 0xC0, 0xAA, 0x30, 0x60, 0xD1,
  // "Å" (U+00C5)
  0x48, 0x16, 0xD9, 0x58, 0x2C, 0x2B, 0x14, 0x81, 0x9F, 0xC7, 0x77, 0x81, 0x4F, 0x75, 0x81, 0xCD,
  0x74, 0x82, 0x4D, 0x98, 0x48, 0x2B, 0x78, 0x93, 0x83, 0x4F, 0x18, 0x93, 0x83, 0xB9, 0x08, 0xA2,
  0x03, 0xA8, 0x1E, 0xFB, 0x28, 0x90, 0xBB, 0x22, 0x8B, 0x03, 0xF3, 0x28, 0x37, 0xC0, 0xAA, 0x30,
  0x60, 0xD1,
  // "Æ" (U+00C6)
  0x50, 0x9D, 0x01, 0x48, 0x23, 0xE9, 0xB7, 0x18, 0x2B, 0x8B, 0x77, 0x83, 0x4E, 0x1E, 0x37, 0x85,
  0xD7, 0x2F, 0xEE, 0xD4, 0x83, 0x6E, 0x05, 0xC0, 0xF1, 0x38, 0x41, 0xEF, 0xEE, 0x86, 0x84, 0x8D,
  0x11, 0xC5, 0x58, 0x52, 0xF4, 0x01, 0xF2, 0x50, 0x0A, 0x20, 0x4C, 0x30,
  // "Ç" (U+00C7)
  0x38, 0x35, 0xCF, 0xD5, 0x28, 0x90, 0x6E, 0x50, 0x31, 0x02, 0xF4, 0x50, 0x90, 0xB6, 0x0E, 0x05,
  0x58, 0x12, 0xF1, 0x50, 0x49, 0x68, 0x13, 0xF1, 0x68, 0x3D, 0x91, 0x12, 0x38, 0x33, 0xCF, 0xD5,
  0x50, 0x66, 0x81, 0x1C, 0x46, 0x06, 0x09, 0x48, 0x21, 0xBB, 0x23,
  // "È" (U+00C8)
  0x30, 0x03, 0x50, 0x60, 0xD6, 0x0C, 0x03, 0x77, 0x30, 0xAB, 0x0A, 0x20, 0xD0, 0x54, 0x81, 0x1F,
  0x14, 0x05, 0x0D, 0x58, 0x39, 0xFE, 0xE7, 0x28, 0x2C, 0x61, 0x13, 0x90, 0x24, 0x03, 0x0E, 0x50,
  0x70, 0xB5, 0x0A, 0xB0, 0xA2,
  // "É" (U+00C9)
  0x50, 0x60, 0x54, 0x81, 0x4E, 0x23, 0x81, 0x1C, 0x27, 0x73, 0x0A, 0xB0, 0xA2, 0x0D, 0x05, 0x48,
  0x11, 0xF1, 0x40, 0x50, 0xD5, 0x83, 0x9F, 0xEE, 0x72, 0x82, 0xC6, 0x11, 0x39, 0x02, 0x40, 0x30,
  0xE5, 0x07, 0x0B, 0x50, 0xAB, 0x0A, 0x20,
  // "Ê" (U+00CA)
  0x40, 0x40, 0x54, 0x82, 0x2D, 0xE1, 0x28, 0x31, 0xB2, 0x67, 0x77, 0x20, 0xAB, 0x0A, 0x20, 0xD0,
  0x54, 0x81, 0x1F, 0x14, 0x05, 0x0D, 0x58, 0x39, 0xFE, 0xE7, 0x28, 0x2C, 0x61, 0x13, 0x90, 0x24,
  0x03, 0x0E, 0x50, 0x70, 0xB5, 0x0A, 0xB0, 0xA2,
  // "Ë" (U+00CB)
  0x28, 0x31, 0xC0, 0x95, 0x77, 0x72, 0x0A, 0xB0, 0xA2, 0x0D, 0x05, 0x48, 0x11, 0xF1, 0x40, 0x50,
  0xD5, 0x83, 0x9F, 0xEE, 0x72, 0x82, 0xC6, 0x11, 0x39, 0x02, 0x40, 0x30, 0xE5, 0x07, 0x0B, 0x50,
  0xAB, 0x0A, 0x20,
  // "Ì" (U+00CC)
  0x30, 0x03, 0x50, 0x60, 0xD6, 0x0C, 0x03, 0x77, 0x38, 0x34, 0xEF, 0xB1, 0x30, 0x80, 0xA5, 0x0B,
  0x07, 0x59, 0x03, 0x40, 0x39, 0x50, 0x70, 0xC5, 0x0A, 0x08, 0x50, 0xD0, 0x54, 0x81, 0x1F, 0x13,
  0x82, 0x5D, 0xFB, 0x30,
  // "Í" (U+00CD)
  0x50, 0x60, 0x54, 0x81, 0x4E, 0x23, 0x81, 0x1C, 0x27, 0x73, 0x83, 0x4E, 0xFB, 0x13, 0x08, 0x0A,
  0x50, 0xB0, 0x75, 0x90, 0x34, 0x03, 0x95, 0x07, 0x0C, 0x50, 0xA0, 0x85, 0x0D, 0x05, 0x48, 0x11,
  0xF1, 0x38, 0x25, 0xDF, 0xB3,
  // "Î" (U+00CE)
  0x40, 0x40, 0x54, 0x82, 0x2D, 0xE1, 0x28, 0x31, 0xB2, 0x67, 0x77, 0x28, 0x34, 0xEF, 0xB1, 0x30,
  0x80, 0xA5, 0x0B, 0x07, 0x59, 0x03, 0x40, 0x39, 0x50, 0x70, 0xC5, 0x0A, 0x08, 0x50, 0xD0, 0x54,
  0x81, 0x1F, 0x13, 0x82, 0x5D, 0xFB, 0x30,
  // "Ï" (U+00CF)
  0x28, 0x31, 0xC0, 0x95, 0x77, 0x72, 0x83, 0x4E, 0xFB, 0x13, 0x08, 0x0A, 0x50, 0xB0, 0x75, 0x90,
  0x34, 0x03, 0x95, 0x07, 0x0C, 0x50, 0xA0, 0x85, 0x0D, 0x05, 0x48, 0x11, 0xF1, 0x38, 0x25, 0xDF,
  0xB3,
  // "Ð" (U+00D0)
  0x00, 0xAF, 0xFC, 0x50, 0x00, 0xE5, 0x06, 0xF2, 0x02, 0xF1, 0x00, 0xD7, 0x06, 0xC0, 0x00, 0xB8,
  0x7F, 0xFE, 0x20, 0xD7, 0x0D, 0x61, 0x01, 0xF4, 0x1F, 0x20, 0x06, 0xE0, 0x4E, 0x00, 0x1E, 0x60,
  0x7B, 0x03, 0xDB, 0x00, 0xBF, 0xFC, 0x70, 0x00,
  // "Ñ" (U+00D1)
  0x48, 0x38, 0xC3, 0x64, 0x38, 0x32, 0xB4, 0xDC, 0x77, 0x70, 0xA9, 0x30, 0x70, 0xB2, 0x81, 0xDF,
  0x32, 0x85, 0xA7, 0x01, 0xFA, 0x72, 0x87, 0xE4, 0x05, 0xC6, 0xB0, 0x29, 0x28, 0x59, 0x92, 0xE0,
  0x6C, 0x28, 0x5C, 0x50, 0xE3, 0x99, 0x29, 0x87, 0x20, 0xA7, 0xC5, 0x03, 0xE2, 0x85, 0x7B, 0xF1,
  0x07, 0xA2, 0x81, 0x3F, 0xD2, 0x0A, 0x07, 0x30, 0xE0, 0xA2,
  // "Ò" (U+00D2)
  0x40, 0x03, 0x70, 0x60, 0xD7, 0x10, 0xC0, 0x37, 0x77, 0x28, 0x36, 0xDE, 0xC2, 0x38, 0x48, 0xD3,
  0x19, 0xC2, 0x81, 0x2F, 0x22, 0x84, 0x3F, 0x10, 0xAA, 0x38, 0x42, 0xF1, 0x0E, 0x53, 0x84, 0x4F,
  0x02, 0xF1, 0x38, 0x27, 0xC0, 0x49, 0x48, 0x4C, 0x70, 0x3F, 0x12, 0x81, 0x5E, 0x12, 0x84, 0xE8,
  0x04, 0xE6, 0x38, 0x34, 0xCF, 0xD5, 0x30,
  // "Ó" (U+00D3)
  0x60, 0x60, 0x56, 0x81, 0x4E, 0x25, 0x81, 0x1C, 0x27, 0x77, 0x28, 0x36, 0xDE, 0xC2, 0x38, 0x48,
  0xD3, 0x19, 0xC2, 0x81, 0x2F, 0x22, 0x84, 0x3F, 0x10, 0xAA, 0x38, 0x42, 0xF1, 0x0E, 0x53, 0x84,
  0x4F, 0x02, 0xF1, 0x38, 0x27, 0xC0, 0x49, 0x48, 0x4C, 0x70, 0x3F, 0x12, 0x81, 0x5E, 0x12, 0x84,
  0xE8, 0x04, 0xE6, 0x38, 0x34, 0xCF, 0xD5, 0x30,
  // "Ô" (U+00D4)
  0x50, 0x40, 0x56, 0x82, 0x2D, 0xE1, 0x48, 0x31, 0xB2, 0x67, 0x77, 0x71, 0x83, 0x6D, 0xEC, 0x23,
  0x84, 0x8D, 0x31, 0x9C, 0x28, 0x12, 0xF2, 0x28, 0x43, 0xF1, 0x0A, 0xA3, 0x84, 0x2F, 0x10, 0xE5,
  0x38, 0x44, 0xF0, 0x2F, 0x13, 0x82, 0x7C, 0x04, 0x94, 0x84, 0xC7, 0x03, 0xF1, 0x28, 0x15, 0xE1,
  0x28, 0x4E, 0x80, 0x4E, 0x63, 0x83, 0x4C, 0xFD, 0x53,
  // "Õ" (U+00D5)
  0x48, 0x38, 0xC3, 0x64, 0x38, 0x32, 0xB4, 0xDC, 0x77, 0x71, 0x83, 0x6D, 0xEC, 0x23, 0x84, 0x8D,
  0x31, 0x9C, 0x28, 0x12, 0xF2, 0x28, 0x43, 0xF1, 0x0A, 0xA3, 0x84, 0x2F, 0x10, 0xE5, 0x38, 0x44,
  0xF0, 0x2F, 0x13, 0x82, 0x7C, 0x04, 0x94, 0x84, 0xC7, 0x03, 0xF1, 0x28, 0x15, 0xE1, 0x28, 0x4E,
  0x80, 0x4E, 0x63, 0x83, 0x4C, 0xFD, 0x53,
  // "Ö" (U+00D6)
  0x38, 0x31, 0xC0, 0x95, 0x77, 0x77, 0x38, 0x36, 0xDE, 0xC2, 0x38, 0x48, 0xD3, 0x19, 0xC2, 0x81,
  0x2F, 0x22, 0x84, 0x3F, 0x10, 0xAA, 0x38, 0x42, 0xF1, 0x0E, 0x53, 0x84, 0x4F, 0x02, 0xF1, 0x38,
  0x27, 0xC0, 0x49, 0x48, 0x4C, 0x70, 0x3F, 0x12, 0x81, 0x5E, 0x12, 0x84, 0xE8, 0x04, 0xE6, 0x38,
  0x34, 0xCF, 0xD5, 0x30,
  // "×" (U+00D7)
  0xD4, 0x00, 0xB6, 0x3E, 0x4B, 0x90, 0x04, 0xFB, 0x00, 0x0B, 0xBE, 0x40, 0xB9, 0x03, 0xE4, 0x50,
  0x00, 0x32,
  // "Ø" (U+00D8)
  0x71, 0x02, 0x38, 0x46, 0xDE, 0xBB, 0x62, 0x84, 0x8D, 0x31, 0xBD, 0x28, 0x91, 0x2F, 0x20, 0x2E,
  0xF1, 0x0A, 0xA2, 0x8B, 0x0C, 0x5F, 0x10, 0xE5, 0x0A, 0x54, 0xF0, 0x2F, 0x26, 0x90, 0x7C, 0x04,
  0xF3, 0xC2, 0x89, 0x1C, 0x70, 0x3F, 0xD2, 0x04, 0xE1, 0x29, 0x83, 0xA1, 0x4E, 0x62, 0x84, 0x6A,
  0xCF, 0xD5, 0x30, 0x47, 0x10,
  // "Ù" (U+00D9)
  0x40, 0x03, 0x70, 0x60, 0xD7, 0x10, 0xC0, 0x37, 0x77, 0x10, 0xB0, 0x73, 0x90, 0x32, 0x0E, 0x04,
  0x20, 0x40, 0xE2, 0x03, 0x93, 0x07, 0x0B, 0x20, 0x60, 0xC3, 0x0B, 0x07, 0x20, 0xA0, 0x83, 0x0E,
  0x04, 0x20, 0xE0, 0x52, 0x03, 0x92, 0x81, 0x2F, 0x12, 0x07, 0x0C, 0x20, 0x49, 0x30, 0xC0, 0x72,
  0x85, 0x2F, 0x52, 0x7E, 0x13, 0x83, 0x6D, 0xFC, 0x33,
  // "Ú" (U+00DA)
  0x60, 0x60, 0x56, 0x81, 0x4E, 0x25, 0x81, 0x1C, 0x27, 0x77, 0x10, 0xB0, 0x73, 0x90, 0x32, 0x0E,
  0x04, 0x20, 0x40, 0xE2, 0x03, 0x93, 0x07, 0x0B, 0x20, 0x60, 0xC3, 0x0B, 0x07, 0x20, 0xA0, 0x83,
  0x0E, 0x04, 0x20, 0xE0, 0x52, 0x03, 0x92, 0x81, 0x2F, 0x12, 0x07, 0x0C, 0x20, 0x49, 0x30, 0xC0,
  0x72, 0x85, 0x2F, 0x52, 0x7E, 0x13, 0x83, 0x6D, 0xFC, 0x33,
  // "Û" (U+00DB)
  0x50, 0x40, 0x56, 0x82, 0x2D, 0xE1, 0x48, 0x31, 0xB2, 0x67, 0x77, 0x70, 0xB0, 0x73, 0x90, 0x32,
  0x0E, 0x04, 0x20, 0x40, 0xE2, 0x03, 0x93, 0x07, 0x0B, 0x20, 0x60, 0xC3, 0x0B, 0x07, 0x20, 0xA0,
  0x83, 0x0E, 0x04, 0x20, 0xE0, 0x52, 0x03, 0x92, 0x81, 0x2F, 0x12, 0x07, 0x0C, 0x20, 0x49, 0x30,
  0xC0, 0x72, 0x85, 0x2F, 0x52, 0x7E, 0x13, 0x83, 0x6D, 0xFC, 0x33,
  // "Ü" (U+00DC)
  0x38, 0x31, 0xC0, 0x95, 0x77, 0x77, 0x20, 0xB0, 0x73, 0x90, 0x32, 0x0E, 0x04, 0x20, 0x40, 0xE2,
  0x03, 0x93, 0x07, 0x0B, 0x20, 0x60, 0xC3, 0x0B, 0x07, 0x20, 0xA0, 0x83, 0x0E, 0x04, 0x20, 0xE0,
  0x52, 0x03, 0x92, 0x81, 0x2F, 0x12, 0x07, 0x0C, 0x20, 0x49, 0x30, 0xC0, 0x72, 0x85, 0x2F, 0x52,
  0x7E, 0x13, 0x83, 0x6D, 0xFC, 0x33,
  // "Ý" (U+00DD)
  0x40, 0x60, 0x54, 0x81, 0x4E, 0x23, 0x81, 0x1C, 0x27, 0x72, 0x00, 0x92, 0x83, 0x4E, 0x16, 0xC2,
  0x86, 0xD6, 0x04, 0xE0, 0x7C, 0x28, 0x31, 0xF2, 0xE3, 0x38, 0x1E, 0xC9, 0x48, 0x1C, 0xE1, 0x40,
  0xB0, 0x75, 0x90, 0x44, 0x03, 0x95, 0x07, 0x0C, 0x50,
  // "Þ" (U+00DE)
  0x20, 0xA0, 0x75, 0x82, 0xDE, 0xC7, 0x28, 0x71, 0xF1, 0x4F, 0x40, 0x5C, 0x28, 0x3B, 0x80, 0x99,
  0x28, 0xB0, 0xC8, 0x0C, 0x60, 0x1E, 0x40, 0xF3, 0x1A, 0xC0, 0x3F, 0xEF, 0xA1, 0x07, 0xC1, 0x40,
  0xA0, 0x85,
  // "ß" (U+00DF)
  0x48, 0x31, 0xAE, 0xD4, 0x48, 0x3A, 0xA1, 0x8C, 0x38, 0x41, 0xF2, 0x08, 0xA3, 0x84, 0x4E, 0x06,
  0xD1, 0x38, 0x38, 0xA4, 0xE2, 0x48, 0x2C, 0x68, 0xB5, 0x98, 0x23, 0x3F, 0x33, 0x03, 0x0E, 0x20,
  0x80, 0xC3, 0x07, 0x0B, 0x20, 0x39, 0x38, 0x4A, 0x83, 0x08, 0xD3, 0x84, 0xE4, 0xCF, 0xC3, 0x28,
  0x12, 0xF1, 0x60, 0x80, 0xB6, 0x81, 0xED, 0x26,
  // "à" (U+00E0)
  0x30, 0x03, 0x50, 0x60, 0xD6, 0x0C, 0x03, 0x73, 0x89, 0x56, 0xED, 0x5C, 0x05, 0xE3, 0x3E, 0x90,
  0xD7, 0x28, 0x91, 0xE5, 0x2F, 0x10, 0x1F, 0x26, 0xD2, 0x83, 0x5E, 0x07, 0xB2, 0x89, 0x6B, 0xB0,
  0x6D, 0x16, 0xE7, 0x01, 0xCE, 0x7B, 0x41,
  // "á" (U+00E1)
  0x50, 0x60, 0x54, 0x81, 0x4E, 0x23, 0x81, 0x1C, 0x27, 0x38, 0x95, 0x6E, 0xD5, 0xC0, 0x5E, 0x33,
  0xE9, 0x0D, 0x72, 0x89, 0x1E, 0x52, 0xF1, 0x01, 0xF2, 0x6D, 0x28, 0x35, 0xE0, 0x7B, 0x28, 0x96,
  0xBB, 0x06, 0xD1, 0x6E, 0x70, 0x1C, 0xE7, 0xB4, 0x10,
  // "â" (U+00E2)
  0x00, 0x00, 0x45, 0x00, 0x00, 0x2D, 0xE1, 0x00, 0x1B, 0x26, 0x70, 0x00, 0x00, 0x00, 0x00, 0x6E,
  0xD5, 0xC0, 0x5E, 0x33, 0xE9, 0x0D, 0x70, 0x0E, 0x52, 0xF1, 0x01, 0xF2, 0x6D, 0x00, 0x5E, 0x07,
  0xB0, 0x0B, 0xB0, 0x6D, 0x16, 0xE7, 0x01, 0xCE, 0x7B, 0x40,
  // "ã" (U+00E3)
  0x00, 0x08, 0xC3, 0x64, 0x00, 0x2B, 0x4D, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6E, 0xD5, 0xC0,
  0x05, 0xE3, 0x3E, 0x90, 0x0D, 0x70, 0x0E, 0x50, 0x2F, 0x10, 0x1F, 0x20, 0x6D, 0x00, 0x5E, 0x00,
  0x7B, 0x00, 0xBB, 0x00, 0x6D, 0x16, 0xE7, 0x00, 0x1C, 0xE7, 0xB4, 0x00,
  // "ä" (U+00E4)
  0x28, 0x31, 0xC0, 0x95, 0x77, 0x28, 0x95, 0x6E, 0xD5, 0xC0, 0x5E, 0x33, 0xE9, 0x0D, 0x72, 0x89,
  0x1E, 0x52, 0xF1, 0x01, 0xF2, 0x6D, 0x28, 0x35, 0xE0, 0x7B, 0x28, 0x96, 0xBB, 0x06, 0xD1, 0x6E,
  0x70, 0x1C, 0xE7, 0xB4, 0x10,
  // "å" (U+00E5)
  0x00, 0x06, 0xD9, 0x00, 0x00, 0xC2, 0xB1, 0x00, 0x09, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6E,
  0xD5, 0xC0, 0x5E, 0x33, 0xE9, 0x0D, 0x70, 0x0E, 0x52, 0xF1, 0x01, 0xF2, 0x6D, 0x00, 0x5E, 0x07,
  0xB0, 0x0B, 0xB0, 0x6D, 0x16, 0xE7, 0x01, 0xCE, 0x7B, 0x40,
  // "æ" (U+00E6)
  0x00, 0x6E, 0xC7, 0x9C, 0xE7, 0x05, 0xE3, 0x5F, 0xC2, 0x5D, 0x0D, 0x60, 0x1F, 0x21, 0xAA, 0x3F,
  0x10, 0x3F, 0xEE, 0x81, 0x5C, 0x00, 0x7B, 0x00, 0x00, 0x7B, 0x00, 0xDA, 0x00, 0x00, 0x6D, 0x18,
  0xEE, 0x21, 0x40, 0x1C, 0xE5, 0xD7, 0xEE, 0x80,
  // "ç" (U+00E7)
  0x28, 0x93, 0x6D, 0xE7, 0x05, 0xE3, 0x11, 0x0D, 0x53, 0x03, 0x94, 0x06, 0x0C, 0x40, 0x70, 0xB4,
  0x83, 0x5E, 0x21, 0x22, 0x82, 0x9E, 0xD3, 0x30, 0x64, 0x81, 0x1C, 0x44, 0x06, 0x09, 0x28, 0x21,
  0xBB, 0x22,
  // "è" (U+00E8)
  0x30, 0x03, 0x40, 0x60, 0xD5, 0x0C, 0x03, 0x71, 0x8A, 0x66, 0xDE, 0x70, 0x5D, 0x25, 0xD0, 0xD3,
  0x1A, 0xA4, 0xFE, 0xE8, 0x07, 0xB4, 0x07, 0x0B, 0x48, 0x35, 0xE3, 0x14, 0x28, 0x29, 0xEE, 0x81,
  // "é" (U+00E9)
  0x50, 0x60, 0x54, 0x81, 0x4E, 0x23, 0x81, 0x1C, 0x27, 0x38, 0x26, 0xDE, 0x72, 0x83, 0x5D, 0x25,
  0xD2, 0x89, 0x1D, 0x31, 0xAA, 0x04, 0xFE, 0xE8, 0x20, 0x70, 0xB5, 0x07, 0x0B, 0x58, 0x35, 0xE3,
  0x14, 0x38, 0x29, 0xEE, 0x82,
  // "ê" (U+00EA)
  0x40, 0x40, 0x54, 0x82, 0x2D, 0xE1, 0x28, 0x31, 0xB2, 0x67, 0x72, 0x82, 0x6D, 0xE7, 0x28, 0x35,
  0xD2, 0x5D, 0x28, 0x91, 0xD3, 0x1A, 0xA0, 0x4F, 0xEE, 0x82, 0x07, 0x0B, 0x50, 0x70, 0xB5, 0x83,
  0x5E, 0x31, 0x43, 0x82, 0x9E, 0xE8, 0x20,
  // "ë" (U+00EB)
  0x28, 0x31, 0xC0, 0x95, 0x77, 0x28, 0x26, 0xDE, 0x72, 0x83, 0x5D, 0x25, 0xD2, 0x89, 0x1D, 0x31,
  0xAA, 0x04, 0xFE, 0xE8, 0x20, 0x70, 0xB5, 0x07, 0x0B, 0x58, 0x35, 0xE3, 0x14, 0x38, 0x29, 0xEE,
  0x82,
  // "ì" (U+00EC)
  0x03, 0x30, 0x06, 0xD0, 0x00, 0xC3, 0x00, 0x00, 0x04, 0xE0, 0x07, 0xA0, 0x0B, 0x70, 0x0E, 0x40,
  0x2F, 0x10, 0x5D, 0x00, 0x89, 0x00, 0xB6, 0x00,
  // "í" (U+00ED)
  0x30, 0x60, 0x52, 0x85, 0x4E, 0x20, 0x1C, 0x27, 0x04, 0x0E, 0x30, 0x70, 0xA3, 0x0B, 0x07, 0x30,
  0xE0, 0x42, 0x81, 0x2F, 0x12, 0x05, 0x0D, 0x30, 0x80, 0x93, 0x0B, 0x06, 0x30,
  // "î" (U+00EE)
  0x00, 0x45, 0x00, 0x2D, 0xE1, 0x1B, 0x26, 0x70, 0x00, 0x00, 0x04, 0xE0, 0x00, 0x7A, 0x00, 0x0B,
  0x70, 0x00, 0xE4, 0x00, 0x2F, 0x10, 0x05, 0xD0, 0x00, 0x89, 0x00, 0x0B, 0x60, 0x00,
  // "ï" (U+00EF)
  0x83, 0x1C, 0x09, 0x57, 0x40, 0x40, 0xE3, 0x07, 0x0A, 0x30, 0xB0, 0x73, 0x0E, 0x04, 0x28, 0x12,
  0xF1, 0x20, 0x50, 0xD3, 0x08, 0x09, 0x30, 0xB0, 0x63,
  // "ð" (U+00F0)
  0x00, 0x1D, 0x6A, 0x60, 0x00, 0x9F, 0x60, 0x00, 0x76, 0x6B, 0x00, 0x00, 0x00, 0xF1, 0x01, 0x9D,
  0x8E, 0x30, 0xBA, 0x28, 0xF3, 0x3E, 0x00, 0x2F, 0x18, 0xA0, 0x04, 0xE0, 0xA8, 0x00, 0x99, 0x08,
  0xC1, 0x5E, 0x20, 0x1B, 0xEC, 0x30, 0x00,
  // "ñ" (U+00F1)
  0x00, 0x08, 0xC3, 0x64, 0x00, 0x2B, 0x4D, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x04, 0xB7, 0xEC, 0x10,
  0x07, 0xE6, 0x1E, 0x50, 0x0B, 0xA0, 0x0E, 0x40, 0x0E, 0x50, 0x2F, 0x10, 0x2F, 0x10, 0x5D, 0x00,
  0x5D, 0x00, 0x9A, 0x00, 0x8A, 0x00, 0xC6, 0x00, 0xC6, 0x00, 0xF3, 0x00,
  // "ò" (U+00F2)
  0x30, 0x03, 0x50, 0x60, 0xD6, 0x0C, 0x03, 0x73, 0x82, 0x6E, 0xE7, 0x28, 0x75, 0xD2, 0x3F, 0x20,
  0xD5, 0x28, 0x2E, 0x43, 0xE3, 0x98, 0x13, 0x6C, 0x28, 0x33, 0xF1, 0x7B, 0x28, 0x78, 0xA0, 0x5E,
  0x14, 0xE3, 0x28, 0x29, 0xED, 0x42,
  // "ó" (U+00F3)
  0x50, 0x60, 0x54, 0x81, 0x4E, 0x23, 0x81, 0x1C, 0x27, 0x38, 0x26, 0xEE, 0x72, 0x87, 0x5D, 0x23,
  0xF2, 0x0D, 0x52, 0x82, 0xE4, 0x3E, 0x39, 0x81, 0x36, 0xC2, 0x83, 0x3F, 0x17, 0xB2, 0x87, 0x8A,
  0x05, 0xE1, 0x4E, 0x32, 0x82, 0x9E, 0xD4, 0x20,
  // "ô" (U+00F4)
  0x40, 0x40, 0x54, 0x82, 0x2D, 0xE1, 0x28, 0x31, 0xB2, 0x67, 0x72, 0x82, 0x6E, 0xE7, 0x28, 0x75,
  0xD2, 0x3F, 0x20, 0xD5, 0x28, 0x2E, 0x43, 0xE3, 0x98, 0x13, 0x6C, 0x28, 0x33, 0xF1, 0x7B, 0x28,
  0x78, 0xA0, 0x5E, 0x14, 0xE3, 0x28, 0x29, 0xED, 0x42,
  // "õ" (U+00F5)
  0x00, 0x8C, 0x36, 0x40, 0x2B, 0x4D, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x06, 0xEE, 0x70, 0x05, 0xD2,
  0x3F, 0x20, 0xD5, 0x00, 0xE4, 0x3E, 0x00, 0x0F, 0x36, 0xC0, 0x03, 0xF1, 0x7B, 0x00, 0x8A, 0x05,
  0xE1, 0x4E, 0x30, 0x09, 0xED, 0x40, 0x00,
  // "ö" (U+00F6)
  0x28, 0x31, 0xC0, 0x95, 0x77, 0x28, 0x26, 0xEE, 0x72, 0x87, 0x5D, 0x23, 0xF2, 0x0D, 0x52, 0x82,
  0xE4, 0x3E, 0x39, 0x81, 0x36, 0xC2, 0x83, 0x3F, 0x17, 0xB2, 0x87, 0x8A, 0x05, 0xE1, 0x4E, 0x32,
  0x82, 0x9E, 0xD4, 0x20,
  // "÷" (U+00F7)
  0x30, 0xD0, 0x55, 0x0A, 0x04, 0x72, 0x03, 0x80, 0x1E, 0x0A, 0x18, 0x02, 0x13, 0x0A, 0x03, 0x50,
  0xD0, 0x52,
  // "ø" (U+00F8)
  0x60, 0x42, 0x8E, 0x26, 0xEE, 0xB7, 0x05, 0xE2, 0x6F, 0x20, 0xD5, 0x09, 0xE4, 0x3F, 0x07, 0x2F,
  0x36, 0xC3, 0x63, 0xF0, 0x7B, 0x90, 0x8B, 0x05, 0xF4, 0x4E, 0x30, 0x8C, 0xED, 0x42, 0x06, 0x60,
  // "ù" (U+00F9)
  0x30, 0x03, 0x50, 0x60, 0xD6, 0x0C, 0x03, 0x72, 0x05, 0x0D, 0x28, 0x38, 0xA0, 0x8A, 0x28, 0x3B,
  0x60, 0xB7, 0x29, 0x87, 0x30, 0xE3, 0x03, 0xF0, 0x39, 0x28, 0x37, 0xC0, 0x6C, 0x28, 0x96, 0xC9,
  0x07, 0xD2, 0x8E, 0x50, 0x2D, 0xE5, 0xD2, 0x10,
  // "ú" (U+00FA)
  0x50, 0x60, 0x54, 0x81, 0x4E, 0x23, 0x81, 0x1C, 0x27, 0x20, 0x50, 0xD2, 0x83, 0x8A, 0x08, 0xA2,
  0x83, 0xB6, 0x0B, 0x72, 0x98, 0x73, 0x0E, 0x30, 0x3F, 0x03, 0x92, 0x83, 0x7C, 0x06, 0xC2, 0x89,
  0x6C, 0x90, 0x7D, 0x28, 0xE5, 0x02, 0xDE, 0x5D, 0x21,
  // "û" (U+00FB)
  0x00, 0x00, 0x45, 0x00, 0x00, 0x2D, 0xE1, 0x00, 0x1B, 0x26, 0x70, 0x00, 0x00, 0x00, 0x05, 0xD0,
  0x08, 0xA0, 0x8A, 0x00, 0xB6, 0x0B, 0x70, 0x0F, 0x30, 0xE3, 0x03, 0xF0, 0x3F, 0x00, 0x7C, 0x06,
  0xC0, 0x0C, 0x90, 0x7D, 0x28, 0xE5, 0x02, 0xDE, 0x5D, 0x20,
  // "ü" (U+00FC)
  0x28, 0x31, 0xC0, 0x95, 0x77, 0x10, 0x50, 0xD2, 0x83, 0x8A, 0x08, 0xA2, 0x83, 0xB6, 0x0B, 0x72,
  0x98, 0x73, 0x0E, 0x30, 0x3F, 0x03, 0x92, 0x83, 0x7C, 0x06, 0xC2, 0x89, 0x6C, 0x90, 0x7D, 0x28,
  0xE5, 0x02, 0xDE, 0x5D, 0x21,
  // "ý" (U+00FD)
  0x60, 0x60, 0x56, 0x81, 0x4E, 0x25, 0x81, 0x1C, 0x27, 0x68, 0x51, 0xF1, 0x01, 0xF2, 0x39, 0x82,
  0x20, 0x8A, 0x48, 0x3E, 0x31, 0xE3, 0x48, 0x2D, 0x37, 0xA5, 0x82, 0xC4, 0xE3, 0x58, 0x1B, 0xAA,
  0x68, 0x1A, 0xF3, 0x60, 0x0A, 0x68, 0x11, 0xE3, 0x60, 0xA0, 0x95, 0x81, 0x5F, 0xB6,
  // "þ" (U+00FE)
  0x30, 0x80, 0x96, 0x0C, 0x06, 0x69, 0x02, 0x58, 0x43, 0xE6, 0xEC, 0x12, 0x84, 0x7E, 0x71, 0xD6,
  0x20, 0xA0, 0xB2, 0x0B, 0x07, 0x20, 0xE0, 0x52, 0x84, 0xC6, 0x02, 0xF1, 0x29, 0x82, 0x30, 0x5E,
  0x20, 0x60, 0xD2, 0x84, 0x9F, 0x33, 0xE5, 0x28, 0x3C, 0x7D, 0xE6, 0x39, 0x02, 0x50, 0x40, 0xE6,
  0x07, 0x0A, 0x60,
  // "ÿ" (U+00FF)
  0x38, 0x31, 0xC0, 0x95, 0x77, 0x78, 0x51, 0xF1, 0x01, 0xF2, 0x39, 0x82, 0x20, 0x8A, 0x48, 0x3E,
  0x31, 0xE3, 0x48, 0x2D, 0x37, 0xA5, 0x82, 0xC4, 0xE3, 0x58, 0x1B, 0xAA, 0x68, 0x1A, 0xF3, 0x60,
  0x0A, 0x68, 0x11, 0xE3, 0x60, 0xA0, 0x95, 0x81, 0x5F, 0xB6,
  // "Ā" (U+0100)
  0x38, 0x32, 0xEE, 0xE7, 0x40, 0xF1, 0x76, 0x81, 0x4F, 0x75, 0x81, 0xCD, 0x74, 0x82, 0x4D, 0x98,
  0x48, 0x2B, 0x78, 0x93, 0x83, 0x4F, 0x18, 0x93, 0x83, 0xB9, 0x08, 0xA2, 0x03, 0xA8, 0x1E, 0xFB,
  0x28, 0x90, 0xBB, 0x22, 0x8B, 0x03, 0xF3, 0x28, 0x37, 0xC0, 0xAA, 0x30, 0x60, 0xD1,
  // "ā" (U+0101)
  0x00, 0x2E, 0xEE, 0x70, 0x00, 0x11, 0x10, 0x00, 0x6E, 0xD5, 0xC0, 0x5E, 0x33, 0xE9, 0x0D, 0x70,
  0x0E, 0x52, 0xF1, 0x01, 0xF2, 0x6D, 0x00, 0x5E, 0x07, 0xB0, 0x0B, 0xB0, 0x6D, 0x16, 0xE7, 0x01,
  0xCE, 0x7B, 0x40,
  // "Ă" (U+0102)
  0x48, 0x2D, 0x15, 0x94, 0x82, 0x7E, 0xB1, 0x77, 0x68, 0x14, 0xF7, 0x58, 0x1C, 0xD7, 0x48, 0x24,
  0xD9, 0x84, 0x82, 0xB7, 0x89, 0x38, 0x34, 0xF1, 0x89, 0x38, 0x3B, 0x90, 0x8A, 0x20, 0x3A, 0x81,
  0xEF, 0xB2, 0x89, 0x0B, 0xB2, 0x28, 0xB0, 0x3F, 0x32, 0x83, 0x7C, 0x0A, 0xA3, 0x06, 0x0D, 0x10,
  // "ă" (U+0103)
  0x00, 0x0D, 0x15, 0x90, 0x00, 0x7E, 0xB1, 0x00, 0x00, 0x00, 0x00, 0x06, 0xED, 0x5C, 0x05, 0xE3,
  0x3E, 0x90, 0xD7, 0x00, 0xE5, 0x2F, 0x10, 0x1F, 0x26, 0xD0, 0x05, 0xE0, 0x7B, 0x00, 0xBB, 0x06,
  0xD1, 0x6E, 0x70, 0x1C, 0xE7, 0xB4, 0x00,
  // "Ą" (U+0104)
  0x48, 0x14, 0xF7, 0x48, 0x1C, 0xD7, 0x38, 0x24, 0xD9, 0x83, 0x82, 0xB7, 0x89, 0x28, 0x34, 0xF1,
  0x89, 0x28, 0x5B, 0x90, 0x8A, 0x03, 0xA8, 0x93, 0xEF, 0xB0, 0xBB, 0x22, 0x8B, 0x3F, 0x32, 0x82,
  0x7C, 0xAA, 0x30, 0x89, 0x40, 0x20, 0xB5, 0x09, 0x07, 0x58, 0x17, 0xF5, 0x50, 0x11,
  // "ą" (U+0105)
  0x28, 0x95, 0x6E, 0xD5, 0xC0, 0x5E, 0x33, 0xE9, 0x0D, 0x72, 0x89, 0x1E, 0x52, 0xF1, 0x01, 0xF2,
  0x6D, 0x28, 0x35, 0xE0, 0x7B, 0x28, 0x96, 0xBB, 0x06, 0xD1, 0x6E, 0x70, 0x1C, 0xE9, 0xE4, 0x30,
  0x20, 0xB5, 0x09, 0x07, 0x58, 0x17, 0xF5, 0x50, 0x13,
  // "Ć" (U+0106)
  0x60, 0x60, 0x55, 0x81, 0x4E, 0x24, 0x81, 0x1C, 0x27, 0x76, 0x83, 0x5C, 0xFD, 0x52, 0x89, 0x06,
  0xE5, 0x03, 0x10, 0x2F, 0x45, 0x09, 0x0B, 0x60, 0xE0, 0x55, 0x81, 0x2F, 0x15, 0x04, 0x96, 0x81,
  0x3F, 0x16, 0x83, 0xD9, 0x11, 0x23, 0x83, 0x3C, 0xFD, 0x52,
  // "ć" (U+0107)
  0x40, 0x60, 0x53, 0x81, 0x4E, 0x22, 0x81, 0x1C, 0x27, 0x28, 0x93, 0x6D, 0xE7, 0x05, 0xE3, 0x11,
  0x0D, 0x53, 0x03, 0x94, 0x06, 0x0C, 0x40, 0x70, 0xB4, 0x83, 0x5E, 0x21, 0x22, 0x82, 0x9E, 0xD3,
  0x10,
  // "Ĉ" (U+0108)
  0x50, 0x40, 0x55, 0x82, 0x2D, 0xE1, 0x38, 0x31, 0xB2, 0x67, 0x77, 0x58, 0x35, 0xCF, 0xD5, 0x28,
  0x90, 0x6E, 0x50, 0x31, 0x02, 0xF4, 0x50, 0x90, 0xB6, 0x0E, 0x05, 0x58, 0x12, 0xF1, 0x50, 0x49,
  0x68, 0x13, 0xF1, 0x68, 0x3D, 0x91, 0x12, 0x38, 0x33, 0xCF, 0xD5, 0x20,
  // "ĉ" (U+0109)
  0x30, 0x40, 0x53, 0x89, 0x02, 0xDE, 0x10, 0x1B, 0x26, 0x77, 0x18, 0x93, 0x6D, 0xE7, 0x05, 0xE3,
  0x11, 0x0D, 0x53, 0x03, 0x94, 0x06, 0x0C, 0x40, 0x70, 0xB4, 0x83, 0x5E, 0x21, 0x22, 0x82, 0x9E,
  0xD3, 0x10,
  // "Ċ" (U+010A)
  0x50, 0xC0, 0x37, 0x77, 0x78, 0x35, 0xCF, 0xD5, 0x28, 0x90, 0x6E, 0x50, 0x31, 0x02, 0xF4, 0x50,
  0x90, 0xB6, 0x0E, 0x05, 0x58, 0x12, 0xF1, 0x50, 0x49, 0x68, 0x13, 0xF1, 0x68, 0x3D, 0x91, 0x12,
  0x38, 0x33, 0xCF, 0xD5, 0x20,
  // "ċ" (U+010B)
  0x40, 0xC0, 0x37, 0x78, 0x93, 0x6D, 0xE7, 0x05, 0xE3, 0x11, 0x0D, 0x53, 0x03, 0x94, 0x06, 0x0C,
  0x40, 0x70, 0xB4, 0x83, 0x5E, 0x21, 0x22, 0x82, 0x9E, 0xD3, 0x10,
  // "Č" (U+010C)
  0x40, 0x52, 0x06, 0x48, 0x27, 0x9A, 0x54, 0x81, 0x1F, 0x97, 0x76, 0x83, 0x5C, 0xFD, 0x52, 0x89,
  0x06, 0xE5, 0x03, 0x10, 0x2F, 0x45, 0x09, 0x0B, 0x60, 0xE0, 0x55, 0x81, 0x2F, 0x15, 0x04, 0x96,
  0x81, 0x3F, 0x16, 0x83, 0xD9, 0x11, 0x23, 0x83, 0x3C, 0xFD, 0x52,
  // "č" (U+010D)
  0x30, 0x52, 0x06, 0x38, 0x27, 0x9A, 0x53, 0x81, 0x1F, 0x97, 0x38, 0x26, 0xDE, 0x72, 0x83, 0x5E,
  0x31, 0x12, 0x0D, 0x05, 0x40, 0x39, 0x50, 0x60, 0xC5, 0x07, 0x0B, 0x58, 0x35, 0xE2, 0x12, 0x38,
  0x29, 0xED, 0x32,
  // "Ď" (U+010E)
  0x30, 0x52, 0x06, 0x48, 0x27, 0x9A, 0x54, 0x81, 0x1F, 0x97, 0x76, 0x0A, 0xA0, 0xC0, 0x53, 0x89,
  0x0D, 0x50, 0x6F, 0x20, 0x1F, 0x22, 0x83, 0xD7, 0x05, 0xE3, 0x83, 0xB8, 0x09, 0xA3, 0x83, 0xD7,
  0x0C, 0x63, 0x98, 0x24, 0x0F, 0x32, 0x82, 0x5E, 0x03, 0x92, 0x89, 0x01, 0xD6, 0x07, 0xB0, 0x3C,
  0xA2, 0x0A, 0xA0, 0xC0, 0x63,
  // "ď" (U+010F)
  0x68, 0x2B, 0x79, 0x96, 0x82, 0xE5, 0xD1, 0x58, 0x22, 0xF1, 0x23, 0x83, 0x6E, 0xC6, 0xC4, 0x84,
  0x5E, 0x32, 0xE9, 0x40, 0xD0, 0x62, 0x0E, 0x05, 0x38, 0x52, 0xF1, 0x01, 0xF2, 0x30, 0x60, 0xC2,
  0x05, 0x0E, 0x40, 0x70, 0xB2, 0x00, 0xB4, 0x84, 0x6D, 0x17, 0xE7, 0x48, 0x41, 0xCE, 0x6B, 0x44,
  // "Đ" (U+0110)
  0x00, 0xAF, 0xFC, 0x50, 0x00, 0xE5, 0x06, 0xF2, 0x02, 0xF1, 0x00, 0xD7, 0x06, 0xC0, 0x00, 0xB8,
  0x7F, 0xFE, 0x20, 0xD7, 0x0D, 0x61, 0x01, 0xF4, 0x1F, 0x20, 0x06, 0xE0, 0x4E, 0x00, 0x1E, 0x60,
  0x7B, 0x03, 0xDB, 0x00, 0xBF, 0xFC, 0x70, 0x00,
  // "đ" (U+0111)
  0x60, 0xB0, 0x75, 0x83, 0xBE, 0xFE, 0x25, 0x02, 0x94, 0x83, 0x6E, 0xD7, 0xC3, 0x84, 0x5E, 0x32,
  0xF8, 0x30, 0xD0, 0x62, 0x0E, 0x05, 0x28, 0x53, 0xF1, 0x01, 0xF2, 0x20, 0x60, 0xC2, 0x05, 0x0E,
  0x30, 0x70, 0xB2, 0x0B, 0x0A, 0x38, 0x46, 0xD1, 0x7E, 0x73, 0x84, 0x1C, 0xE6, 0xB4, 0x30,
  // "Ē" (U+0112)
  0x28, 0x32, 0xEE, 0xE7, 0x30, 0xF1, 0x73, 0x0A, 0xB0, 0xA2, 0x0D, 0x05, 0x48, 0x11, 0xF1, 0x40,
  0x50, 0xD5, 0x83, 0x9F, 0xEE, 0x72, 0x82, 0xC6, 0x11, 0x39, 0x02, 0x40, 0x30, 0xE5, 0x07, 0x0B,
  0x50, 0xAB, 0x0A, 0x20,
  // "ē" (U+0113)
  0x28, 0x32, 0xEE, 0xE7, 0x30, 0xF1, 0x38, 0x26, 0xDE, 0x72, 0x83, 0x5D, 0x25, 0xD2, 0x89, 0x1D,
  0x31, 0xAA, 0x04, 0xFE, 0xE8, 0x20, 0x70, 0xB5, 0x07, 0x0B, 0x58, 0x35, 0xE3, 0x14, 0x38, 0x29,
  0xEE, 0x82,
  // "Ĕ" (U+0114)
  0x38, 0x2D, 0x15, 0x93, 0x82, 0x7E, 0xB1, 0x77, 0x20, 0xAB, 0x0A, 0x20, 0xD0, 0x54, 0x81, 0x1F,
  0x14, 0x05, 0x0D, 0x58, 0x39, 0xFE, 0xE7, 0x28, 0x2C, 0x61, 0x13, 0x90, 0x24, 0x03, 0x0E, 0x50,
  0x70, 0xB5, 0x0A, 0xB0, 0xA2,
  // "ĕ" (U+0115)
  0x38, 0x2D, 0x15, 0x93, 0x82, 0x7E, 0xB1, 0x72, 0x82, 0x6D, 0xE7, 0x28, 0x35, 0xD2, 0x5D, 0x28,
  0x91, 0xD3, 0x1A, 0xA0, 0x4F, 0xEE, 0x82, 0x07, 0x0B, 0x50, 0x70, 0xB5, 0x83, 0x5E, 0x31, 0x43,
  0x82, 0x9E, 0xE8, 0x20,
  // "Ė" (U+0116)
  0x40, 0xC0, 0x37, 0x73, 0x0A, 0xB0, 0xA2, 0x0D, 0x05, 0x48, 0x11, 0xF1, 0x40, 0x50, 0xD5, 0x83,
  0x9F, 0xEE, 0x72, 0x82, 0xC6, 0x11, 0x39, 0x02, 0x40, 0x30, 0xE5, 0x07, 0x0B, 0x50, 0xAB, 0x0A,
  0x20,
  // "ė" (U+0117)
  0x40, 0xC0, 0x37, 0x78, 0xA6, 0x6D, 0xE7, 0x05, 0xD2, 0x5D, 0x0D, 0x31, 0xAA, 0x4F, 0xEE, 0x80,
  0x7B, 0x40, 0x70, 0xB4, 0x83, 0x5E, 0x31, 0x42, 0x82, 0x9E, 0xE8, 0x10,
  // "Ę" (U+0118)
  0x20, 0xAB, 0x0A, 0x20, 0xD0, 0x54, 0x81, 0x1F, 0x14, 0x05, 0x0D, 0x58, 0x39, 0xFE, 0xE7, 0x28,
  0x2C, 0x61, 0x13, 0x90, 0x24, 0x03, 0x0E, 0x50, 0x70, 0xB5, 0x0A, 0xB0, 0xA3, 0x02, 0x0B, 0x50,
  0x90, 0x75, 0x81, 0x7F, 0x55, 0x01, 0x40,
  // "ę" (U+0119)
  0x00, 0x6D, 0xE7, 0x05, 0xD2, 0x5D, 0x0D, 0x31, 0xAA, 0x4F, 0xEE, 0x80, 0x7B, 0x00, 0x00, 0x7B,
  0x00, 0x00, 0x5E, 0x31, 0x40, 0x09, 0xEF, 0x90, 0x00, 0x49, 0x00, 0x00, 0xD3, 0x00, 0x00, 0xAE,
  0x10,
  // "Ě" (U+011A)
  0x30, 0x52, 0x06, 0x38, 0x27, 0x9A, 0x53, 0x81, 0x1F, 0x97, 0x73, 0x0A, 0xB0, 0xA2, 0x0D, 0x05,
  0x48, 0x11, 0xF1, 0x40, 0x50, 0xD5, 0x83, 0x9F, 0xEE, 0x72, 0x82, 0xC6, 0x11, 0x39, 0x02, 0x40,
  0x30, 0xE5, 0x07, 0x0B, 0x50, 0xAB, 0x0A, 0x20,
  // "ě" (U+011B)
  0x30, 0x52, 0x06, 0x38, 0x27, 0x9A, 0x53, 0x81, 0x1F, 0x97, 0x38, 0x26, 0xDE, 0x72, 0x83, 0x5D,
  0x25, 0xD2, 0x89, 0x1D, 0x31, 0xAA, 0x04, 0xFE, 0xE8, 0x20, 0x70, 0xB5, 0x07, 0x0B, 0x58, 0x35,
  0xE3, 0x14, 0x38, 0x29, 0xEE, 0x82,
  // "Ĝ" (U+011C)
  0x50, 0x40, 0x56, 0x82, 0x2D, 0xE1, 0x48, 0x31, 0xB2, 0x67, 0x77, 0x71, 0x84, 0x4B, 0xEE, 0xB2,
  0x28, 0x46, 0xE6, 0x11, 0x52, 0x81, 0x3F, 0x46, 0x0A, 0x0B, 0x79, 0x89, 0x05, 0x03, 0xEE, 0x70,
  0x3F, 0x12, 0x83, 0x1E, 0x50, 0x49, 0x38, 0x51, 0xF1, 0x02, 0xF1, 0x20, 0x40, 0xE3, 0x84, 0xDA,
  0x10, 0x9A, 0x38, 0x42, 0xBE, 0xEC, 0x42,
  // "ĝ" (U+011D)
  0x50, 0x40, 0x55, 0x82, 0x2D, 0xE1, 0x38, 0x31, 0xB2, 0x67, 0x74, 0x83, 0x6E, 0xD5, 0xC2, 0x84,
  0x5E, 0x33, 0xE8, 0x20, 0xD0, 0x62, 0x98, 0x92, 0x50, 0x2F, 0x10, 0x1F, 0x10, 0x6C, 0x20, 0x50,
  0xD2, 0x07, 0x0B, 0x20, 0xB0, 0xA2, 0x84, 0x6D, 0x17, 0xF6, 0x28, 0x41, 0xCE, 0x7E, 0x35, 0x03,
  0x0E, 0x38, 0x33, 0x02, 0xC7, 0x28, 0x31, 0xCE, 0xD8, 0x30,
  // "Ğ" (U+011E)
  0x48, 0x2D, 0x15, 0x95, 0x82, 0x7E, 0xB1, 0x77, 0x71, 0x84, 0x4B, 0xEE, 0xB2, 0x28, 0x46, 0xE6,
  0x11, 0x52, 0x81, 0x3F, 0x46, 0x0A, 0x0B, 0x79, 0x89, 0x05, 0x03, 0xEE, 0x70, 0x3F, 0x12, 0x83,
  0x1E, 0x50, 0x49, 0x38, 0x51, 0xF1, 0x02, 0xF1, 0x20, 0x40, 0xE3, 0x84, 0xDA, 0x10, 0x9A, 0x38,
  0x42, 0xBE, 0xEC, 0x42,
  // "ğ" (U+011F)
  0x48, 0x2D, 0x15, 0x94, 0x82, 0x7E, 0xB1, 0x74, 0x83, 0x6E, 0xD5, 0xC2, 0x84, 0x5E, 0x33, 0xE8,
  0x20, 0xD0, 0x62, 0x98, 0x92, 0x50, 0x2F, 0x10, 0x1F, 0x10, 0x6C, 0x20, 0x50, 0xD2, 0x07, 0x0B,
  0x20, 0xB0, 0xA2, 0x84, 0x6D, 0x17, 0xF6, 0x28, 0x41, 0xCE, 0x7E, 0x35, 0x03, 0x0E, 0x38, 0x33,
  0x02, 0xC7, 0x28, 0x31, 0xCE, 0xD8, 0x30,
  // "Ġ" (U+0120)
  0x60, 0xC0, 0x37, 0x77, 0x73, 0x84, 0x4B, 0xEE, 0xB2, 0x28, 0x46, 0xE6, 0x11, 0x52, 0x81, 0x3F,
  0x46, 0x0A, 0x0B, 0x79, 0x89, 0x05, 0x03, 0xEE, 0x70, 0x3F, 0x12, 0x83, 0x1E, 0x50, 0x49, 0x38,
  0x51, 0xF1, 0x02, 0xF1, 0x20, 0x40, 0xE3, 0x84, 0xDA, 0x10, 0x9A, 0x38, 0x42, 0xBE, 0xEC, 0x42,
  // "ġ" (U+0121)
  0x50, 0xC0, 0x37, 0x76, 0x83, 0x6E, 0xD5, 0xC2, 0x84, 0x5E, 0x33, 0xE8, 0x20, 0xD0, 0x62, 0x98,
  0x92, 0x50, 0x2F, 0x10, 0x1F, 0x10, 0x6C, 0x20, 0x50, 0xD2, 0x07, 0x0B, 0x20, 0xB0, 0xA2, 0x84,
  0x6D, 0x17, 0xF6, 0x28, 0x41, 0xCE, 0x7E, 0x35, 0x03, 0x0E, 0x38, 0x33, 0x02, 0xC7, 0x28, 0x31,
  0xCE, 0xD8, 0x30,
  // "Ģ" (U+0122)
  0x38, 0x44, 0xBE, 0xEB, 0x22, 0x84, 0x6E, 0x61, 0x15, 0x28, 0x13, 0xF4, 0x60, 0xA0, 0xB7, 0x98,
  0x90, 0x50, 0x3E, 0xE7, 0x03, 0xF1, 0x28, 0x31, 0xE5, 0x04, 0x93, 0x85, 0x1F, 0x10, 0x2F, 0x12,
  0x04, 0x0E, 0x38, 0x4D, 0xA1, 0x09, 0xA3, 0x84, 0x2B, 0xEE, 0xC4, 0x50, 0x70, 0x26, 0x03, 0x0D,
  0x70, 0xA0, 0x35,
  // "ģ" (U+0123)
  0x50, 0x40, 0xA5, 0x81, 0x1E, 0x26, 0x02, 0x58, 0x36, 0xED, 0x5C, 0x28, 0x45, 0xE3, 0x3E, 0x82,
  0x0D, 0x06, 0x29, 0x89, 0x25, 0x02, 0xF1, 0x01, 0xF1, 0x06, 0xC2, 0x05, 0x0D, 0x20, 0x70, 0xB2,
  0x0B, 0x0A, 0x28, 0x46, 0xD1, 0x7F, 0x62, 0x84, 0x1C, 0xE7, 0xE3, 0x50, 0x30, 0xE3, 0x83, 0x30,
  0x2C, 0x72, 0x83, 0x1C, 0xED, 0x83,
  // "Ĥ" (U+0124)
  0x50, 0x40, 0x56, 0x82, 0x2D, 0xE1, 0x48, 0x31, 0xB2, 0x67, 0x77, 0x70, 0xA0, 0x83, 0x0E, 0x04,
  0x20, 0xD0, 0x52, 0x03, 0x92, 0x81, 0x1F, 0x12, 0x07, 0x0C, 0x20, 0x50, 0xD3, 0x0A, 0x09, 0x28,
  0x58, 0xFE, 0xEE, 0xF5, 0x28, 0x5C, 0x72, 0x24, 0xF2, 0x29, 0x02, 0x20, 0x50, 0xE2, 0x03, 0x0E,
  0x30, 0x90, 0xA2, 0x07, 0x0B, 0x30, 0xC0, 0x72, 0x0A, 0x08, 0x39, 0x03, 0x20,
  // "ĥ" (U+0125)
  0x30, 0x40, 0x54, 0x82, 0x2D, 0xE1, 0x28, 0x31, 0xB2, 0x67, 0x73, 0x00, 0x95, 0x0C, 0x06, 0x59,
  0x02, 0x48, 0x96, 0x3E, 0x7E, 0xC1, 0x07, 0xE6, 0x1E, 0x50, 0xAA, 0x28, 0xA0, 0xE4, 0x0D, 0x50,
  0x2F, 0x11, 0xF1, 0x05, 0xD0, 0x5D, 0x28, 0x38, 0x90, 0x8A, 0x28, 0x3C, 0x60, 0xB6, 0x29, 0x03,
  0x10,
  // "Ħ" (U+0126)
  0x00, 0xB7, 0x00, 0x1F, 0x31, 0xEF, 0xEE, 0xEE, 0xFD, 0x03, 0xF0, 0x00, 0x8A, 0x00, 0x7C, 0x00,
  0x0B, 0x70, 0x0A, 0xFE, 0xEE, 0xF3, 0x00, 0xD6, 0x11, 0x3F, 0x00, 0x1F, 0x20, 0x05, 0xD0, 0x04,
  0xE0, 0x00, 0x99, 0x00, 0x7B, 0x00, 0x0C, 0x60, 0x0B, 0x80, 0x00, 0xF3, 0x00,
  // "ħ" (U+0127)
  0x00, 0x99, 0x00, 0x00, 0xBF, 0xEE, 0x10, 0x00, 0xF1, 0x00, 0x00, 0x4D, 0x7E, 0xC0, 0x07, 0xE5,
  0x1F, 0x40, 0xAA, 0x00, 0xE3, 0x0E, 0x50, 0x2F, 0x11, 0xF1, 0x05, 0xD0, 0x5D, 0x00, 0x89, 0x08,
  0xA0, 0x0C, 0x60, 0xB6, 0x00, 0xF3, 0x00,
  // "Ĩ" (U+0128)
  0x38, 0x38, 0xC3, 0x64, 0x28, 0x32, 0xB4, 0xDC, 0x77, 0x58, 0x34, 0xEF, 0xB1, 0x40, 0x80, 0xA6,
  0x0B, 0x07, 0x69, 0x03, 0x50, 0x39, 0x60, 0x70, 0xC6, 0x0A, 0x08, 0x60, 0xD0, 0x55, 0x81, 0x1F,
  0x14, 0x82, 0x5D, 0xFB, 0x40,
  // "ĩ" (U+0129)
  0x18, 0x90, 0x8C, 0x36, 0x42, 0xB4, 0xDC, 0x71, 0x04, 0x0E, 0x40, 0x70, 0xA4, 0x0B, 0x07, 0x40,
  0xE0, 0x43, 0x81, 0x2F, 0x13, 0x05, 0x0D, 0x40, 0x80, 0x94, 0x0B, 0x06, 0x40,
  // "Ī" (U+012A)
  0x28, 0x32, 0xEE, 0xE7, 0x30, 0xF1, 0x73, 0x83, 0x4E, 0xFB, 0x13, 0x08, 0x0A, 0x50, 0xB0, 0x75,
  0x90, 0x34, 0x03, 0x95, 0x07, 0x0C, 0x50, 0xA0, 0x85, 0x0D, 0x05, 0x48, 0x11, 0xF1, 0x38, 0x25,
  0xDF, 0xB3,
  // "ī" (U+012B)
  0x2E, 0xEE, 0x70, 0x11, 0x10, 0x04, 0xE0, 0x00, 0x7A, 0x00, 0x0B, 0x70, 0x00, 0xE4, 0x00, 0x2F,
  0x10, 0x05, 0xD0, 0x00, 0x89, 0x00, 0x0B, 0x60, 0x00,
  // "Ĭ" (U+012C)
  0x38, 0x2D, 0x15, 0x93, 0x82, 0x7E, 0xB1, 0x77, 0x28, 0x34, 0xEF, 0xB1, 0x30, 0x80, 0xA5, 0x0B,
  0x07, 0x59, 0x03, 0x40, 0x39, 0x50, 0x70, 0xC5, 0x0A, 0x08, 0x50, 0xD0, 0x54, 0x81, 0x1F, 0x13,
  0x82, 0x5D, 0xFB, 0x30,
  // "ĭ" (U+012D)
  0x18, 0x7D, 0x15, 0x90, 0x7E, 0xB1, 0x60, 0x40, 0xE3, 0x07, 0x0A, 0x30, 0xB0, 0x73, 0x0E, 0x04,
  0x28, 0x12, 0xF1, 0x20, 0x50, 0xD3, 0x08, 0x09, 0x30, 0xB0, 0x63,
  // "Į" (U+012E)
  0x28, 0x34, 0xEF, 0xB1, 0x30, 0x80, 0xA5, 0x0B, 0x07, 0x59, 0x03, 0x40, 0x39, 0x50, 0x70, 0xC5,
  0x0A, 0x08, 0x50, 0xD0, 0x54, 0x81, 0x1F, 0x13, 0x05, 0xA0, 0xB3, 0x02, 0x0B, 0x50, 0x90, 0x75,
  0x81, 0x7F, 0x55, 0x01, 0x50,
  // "į" (U+012F)
  0x30, 0x90, 0x67, 0x50, 0x40, 0xE3, 0x07, 0x0A, 0x30, 0xB0, 0x73, 0x0E, 0x04, 0x28, 0x12, 0xF1,
  0x20, 0x50, 0xD3, 0x08, 0x09, 0x30, 0xE0, 0x92, 0x02, 0x0B, 0x30, 0x90, 0x73, 0x81, 0x7F, 0x53,
  0x01, 0x30,
  // "İ" (U+0130)
  0x40, 0xC0, 0x37, 0x77, 0x38, 0x34, 0xEF, 0xB1, 0x30, 0x80, 0xA5, 0x0B, 0x07, 0x59, 0x03, 0x40,
  0x39, 0x50, 0x70, 0xC5, 0x0A, 0x08, 0x50, 0xD0, 0x54, 0x81, 0x1F, 0x13, 0x82, 0x5D, 0xFB, 0x30,
  // "ı" (U+0131)
  0x04, 0xE0, 0x7A, 0x0B, 0x70, 0xE4, 0x2F, 0x15, 0xD0, 0x89, 0x0B, 0x60,
  // "Ĳ" (U+0132)
  0x28, 0x54, 0xEF, 0xB1, 0xA9, 0x30, 0x80, 0xA2, 0x0D, 0x05, 0x38, 0x4B, 0x70, 0x1F, 0x23, 0x98,
  0x23, 0x04, 0xE3, 0x03, 0x92, 0x08, 0x0B, 0x30, 0x70, 0xC2, 0x0B, 0x07, 0x30, 0xA0, 0x82, 0x0E,
  0x04, 0x38, 0x4D, 0x50, 0x2F, 0x12, 0x84, 0x1F, 0x10, 0x6D, 0x28, 0x55, 0xDF, 0xB0, 0x99, 0x70,
  0xD0, 0x56, 0x81, 0x4F, 0x14, 0x82, 0x2E, 0xE5, 0x60, 0x15,
  // "ĳ" (U+0133)
  0x28, 0x39, 0x60, 0x96, 0x77, 0x18, 0x34, 0xE0, 0x4E, 0x28, 0x37, 0xA0, 0x7A, 0x28, 0x3B, 0x70,
  0xB7, 0x28, 0x90, 0xE4, 0x0E, 0x30, 0x2F, 0x12, 0x92, 0x83, 0x5D, 0x06, 0xC2, 0x83, 0x89, 0x09,
  0x82, 0x83, 0xB6, 0x0D, 0x54, 0x81, 0x1F, 0x14, 0x07, 0x0C, 0x48, 0x1D, 0xD3, 0x30,
  // "Ĵ" (U+0134)
  0x50, 0x40, 0x55, 0x82, 0x2D, 0xE1, 0x38, 0x31, 0xB2, 0x67, 0x77, 0x70, 0xA0, 0x96, 0x0D, 0x05,
  0x58, 0x11, 0xF2, 0x50, 0x40, 0xE6, 0x08, 0x0B, 0x60, 0xB0, 0x76, 0x0E, 0x04, 0x58, 0x12, 0xF1,
  0x50, 0x60, 0xD6, 0x00, 0x96, 0x0D, 0x05, 0x58, 0x14, 0xF1, 0x38, 0x22, 0xEE, 0x55, 0x01, 0x60,
  // "ĵ" (U+0135)
  0x40, 0x40, 0x54, 0x82, 0x2D, 0xE1, 0x28, 0x31, 0xB2, 0x67, 0x73, 0x04, 0x0E, 0x50, 0x70, 0xA5,
  0x0B, 0x07, 0x50, 0xE0, 0x34, 0x02, 0x95, 0x06, 0x0C, 0x50, 0x90, 0x85, 0x0D, 0x05, 0x48, 0x11,
  0xF1, 0x40, 0x70, 0xC4, 0x81, 0xDD, 0x34,
  // "Ķ" (U+0136)
  0x20, 0xA0, 0x82, 0x0B, 0x09, 0x28, 0x3D, 0x50, 0x9B, 0x28, 0x41, 0xF1, 0x7D, 0x12, 0x83, 0x5D,
  0x5E, 0x23, 0x82, 0x9C, 0xE6, 0x48, 0x2C, 0xDC, 0x84, 0x98, 0x13, 0x6D, 0x38, 0x43, 0xF0, 0x2F,
  0x22, 0x07, 0x0B, 0x20, 0xD0, 0x62, 0x0A, 0x08, 0x20, 0x90, 0xB4, 0x07, 0x02, 0x50, 0x30, 0xD6,
  0x0A, 0x03, 0x50,
  // "ķ" (U+0137)
  0x20, 0x80, 0x95, 0x0C, 0x06, 0x59, 0x02, 0x48, 0x92, 0x3E, 0x02, 0xE3, 0x06, 0xB1, 0xD5, 0x28,
  0x2A, 0x7B, 0x83, 0x0D, 0x0C, 0x93, 0x83, 0x1F, 0x9F, 0x32, 0x83, 0x5D, 0x0C, 0x72, 0x83, 0x89,
  0x08, 0xB2, 0x83, 0xB6, 0x04, 0xE4, 0x07, 0x02, 0x40, 0x30, 0xD5, 0x0A, 0x03, 0x40,
  // "ĸ" (U+0138)
  0x04, 0xE0, 0x2E, 0x30, 0x7B, 0x1D, 0x50, 0x0A, 0x7B, 0x80, 0x00, 0xEC, 0xF0, 0x00, 0x1F, 0x9F,
  0x30, 0x05, 0xD0, 0xC7, 0x00, 0x89, 0x08, 0xB0, 0x0B, 0x60, 0x4E, 0x00,
  // "Ĺ" (U+0139)
  0x50, 0x60, 0x54, 0x81, 0x4E, 0x23, 0x81, 0x1C, 0x27, 0x73, 0x0A, 0x08, 0x50, 0xD0, 0x54, 0x81,
  0x1F, 0x14, 0x05, 0x0D, 0x50, 0x90, 0xA5, 0x0C, 0x06, 0x59, 0x03, 0x40, 0x30, 0xE5, 0x07, 0x0C,
  0x0F, 0x12, 0x0A, 0xB0, 0x92,
  // "ĺ" (U+013A)
  0x40, 0x60, 0x53, 0x81, 0x4E, 0x22, 0x81, 0x1C, 0x27, 0x20, 0x80, 0x94, 0x0C, 0x06, 0x49, 0x03,
  0x30, 0x30, 0xE4, 0x06, 0x0B, 0x40, 0xA0, 0x84, 0x0D, 0x04, 0x38, 0x11, 0xF1, 0x30, 0x50, 0xD4,
  0x08, 0x09, 0x40, 0xB0, 0x64,
  // "Ļ" (U+013B)
  0x00, 0xA8, 0x00, 0x0D, 0x50, 0x01, 0xF1, 0x00, 0x5D, 0x00, 0x09, 0xA0, 0x00, 0xC6, 0x00, 0x0F,
  0x30, 0x03, 0xE0, 0x00, 0x7C, 0x11, 0x1A, 0xFF, 0xF9, 0x00, 0x72, 0x00, 0x3D, 0x00, 0x0A, 0x30,
  0x00,
  // "ļ" (U+013C)
  0x00, 0x08, 0x90, 0x00, 0xC6, 0x00, 0x0F, 0x30, 0x03, 0xE0, 0x00, 0x6B, 0x00, 0x0A, 0x80, 0x00,
  0xD4, 0x00, 0x1F, 0x10, 0x05, 0xD0, 0x00, 0x89, 0x00, 0x0B, 0x60, 0x00, 0x72, 0x00, 0x3D, 0x00,
  0x0A, 0x30, 0x00,
  // "Ľ" (U+013D)
  0x28, 0x3A, 0x80, 0xD4, 0x28, 0x2D, 0x54, 0xA2, 0x82, 0x1F, 0x12, 0x30, 0x50, 0xD5, 0x09, 0x0A,
  0x50, 0xC0, 0x65, 0x90, 0x34, 0x03, 0x0E, 0x50, 0x70, 0xC0, 0xF1, 0x20, 0xAB, 0x09, 0x20,
  // "ľ" (U+013E)
  0x28, 0x28, 0x95, 0xC2, 0x82, 0xC6, 0xB3, 0x29, 0x00, 0x32, 0x03, 0x0E, 0x40, 0x60, 0xB4, 0x0A,
  0x08, 0x40, 0xD0, 0x43, 0x81, 0x1F, 0x13, 0x05, 0x0D, 0x40, 0x80, 0x94, 0x0B, 0x06, 0x40,
  // "Ŀ" (U+013F)
  0x20, 0xA0, 0x84, 0x0D, 0x05, 0x38, 0x11, 0xF1, 0x30, 0x50, 0xD4, 0x86, 0x9A, 0x0C, 0x30, 0xC6,
  0x49, 0x03, 0x30, 0x30, 0xE4, 0x85, 0x7C, 0x11, 0x10, 0xAB, 0x09, 0x10,
  // "ŀ" (U+0140)
  0x00, 0x89, 0x00, 0x0C, 0x60, 0x00, 0xF3, 0x00, 0x3E, 0x00, 0x06, 0xB0, 0x00, 0xA8, 0xC3, 0x0D,
  0x40, 0x01, 0xF1, 0x00, 0x5D, 0x00, 0x08, 0x90, 0x00, 0xB6, 0x00, 0x00,
  // "Ł" (U+0141)
  0x00, 0x9A, 0x00, 0x0C, 0x60, 0x01, 0xF3, 0x00, 0x4E, 0x12, 0x07, 0xED, 0x55, 0xEA, 0x00, 0x8F,
  0x40, 0x02, 0xF0, 0x00, 0x6D, 0x11, 0x19, 0xFF, 0xFA,
  // "ł" (U+0142)
  0x00, 0x7B, 0x00, 0xB7, 0x00, 0xE4, 0x02, 0xF1, 0x05, 0xE9, 0x1B, 0xD5, 0xBE, 0x60, 0x0F, 0x20,
  0x3E, 0x00, 0x7B, 0x00, 0xA7, 0x00,
  // "Ń" (U+0143)
  0x60, 0x60, 0x56, 0x81, 0x4E, 0x25, 0x81, 0x1C, 0x27, 0x77, 0x10, 0xA9, 0x30, 0x70, 0xB2, 0x81,
  0xDF, 0x32, 0x85, 0xA7, 0x01, 0xFA, 0x72, 0x87, 0xE4, 0x05, 0xC6, 0xB0, 0x29, 0x28, 0x59, 0x92,
  0xE0, 0x6C, 0x28, 0x5C, 0x50, 0xE3, 0x99, 0x29, 0x87, 0x20, 0xA7, 0xC5, 0x03, 0xE2, 0x85, 0x7B,
  0xF1, 0x07, 0xA2, 0x81, 0x3F, 0xD2, 0x0A, 0x07, 0x30, 0xE0, 0xA2,
  // "ń" (U+0144)
  0x50, 0x60, 0x54, 0x81, 0x4E, 0x23, 0x81, 0x1C, 0x27, 0x28, 0x96, 0x4B, 0x7E, 0xC1, 0x07, 0xE6,
  0x1E, 0x50, 0xBA, 0x28, 0xA0, 0xE4, 0x0E, 0x50, 0x2F, 0x12, 0xF1, 0x05, 0xD0, 0x5D, 0x28, 0x39,
  0xA0, 0x8A, 0x28, 0x3C, 0x60, 0xC6, 0x29, 0x03, 0x10,
  // "Ņ" (U+0145)
  0x20, 0xA9, 0x30, 0x70, 0xB2, 0x81, 0xDF, 0x32, 0x85, 0xA7, 0x01, 0xFA, 0x72, 0x87, 0xE4, 0x05,
  0xC6, 0xB0, 0x29, 0x28, 0x59, 0x92, 0xE0, 0x6C, 0x28, 0x5C, 0x50, 0xE3, 0x99, 0x29, 0x87, 0x20,
  0xA7, 0xC5, 0x03, 0xE2, 0x85, 0x7B, 0xF1, 0x07, 0xA2, 0x81, 0x3F, 0xD2, 0x0A, 0x07, 0x30, 0xE0,
  0xA5, 0x07, 0x02, 0x60, 0x30, 0xD7, 0x0A, 0x03, 0x50,
  // "ņ" (U+0146)
  0x04, 0xB7, 0xEC, 0x10, 0x7E, 0x61, 0xE5, 0x0B, 0xA0, 0x0E, 0x40, 0xE5, 0x02, 0xF1, 0x2F, 0x10,
  0x5D, 0x05, 0xD0, 0x09, 0xA0, 0x8A, 0x00, 0xC6, 0x0C, 0x60, 0x0F, 0x30, 0x00, 0x72, 0x00, 0x00,
  0x3D, 0x00, 0x00, 0x0A, 0x30, 0x00, 0x00,
  // "Ň" (U+0147)
  0x40, 0x52, 0x06, 0x58, 0x27, 0x9A, 0x55, 0x81, 0x1F, 0x97, 0x77, 0x10, 0xA9, 0x30, 0x70, 0xB2,
  0x81, 0xDF, 0x32, 0x85, 0xA7, 0x01, 0xFA, 0x72, 0x87, 0xE4, 0x05, 0xC6, 0xB0, 0x29, 0x28, 0x59,
  0x92, 0xE0, 0x6C, 0x28, 0x5C, 0x50, 0xE3, 0x99, 0x29, 0x87, 0x20, 0xA7, 0xC5, 0x03, 0xE2, 0x85,
  0x7B, 0xF1, 0x07, 0xA2, 0x81, 0x3F, 0xD2, 0x0A, 0x07, 0x30, 0xE0, 0xA2,
  // "ň" (U+0148)
  0x00, 0x05, 0x00, 0x60, 0x00, 0x79, 0xA5, 0x00, 0x01, 0xF9, 0x00, 0x00, 0x00, 0x00, 0x04, 0xB7,
  0xEC, 0x10, 0x7E, 0x61, 0xE5, 0x0B, 0xA0, 0x0E, 0x40, 0xE5, 0x02, 0xF1, 0x2F, 0x10, 0x5D, 0x05,
  0xD0, 0x09, 0xA0, 0x8A, 0x00, 0xC6, 0x0C, 0x60, 0x0F, 0x30,
  // "ŉ" (U+0149)
  0x0E, 0x50, 0x00, 0x00, 0x4D, 0x00, 0x00, 0x00, 0xB5, 0x4B, 0x7E, 0xC1, 0x60, 0x7E, 0x61, 0xE5,
  0x00, 0xBA, 0x00, 0xE4, 0x00, 0xE5, 0x02, 0xF1, 0x02, 0xF1, 0x05, 0xD0, 0x05, 0xD0, 0x09, 0xA0,
  0x08, 0xA0, 0x0C, 0x60, 0x0C, 0x60, 0x0F, 0x30,
  // "Ŋ" (U+014A)
  0x20, 0xA9, 0x30, 0x70, 0xB2, 0x81, 0xDF, 0x42, 0x85, 0xB7, 0x01, 0xFA, 0x72, 0x8A, 0x1E, 0x40,
  0x5C, 0x5B, 0x02, 0xF1, 0x09, 0x91, 0xF0, 0x6D, 0x28, 0x5C, 0x50, 0xD4, 0x99, 0x29, 0x87, 0x20,
  0x97, 0xC6, 0x03, 0xE2, 0x85, 0x5C, 0xF2, 0x07, 0xA2, 0x81, 0x1F, 0xE2, 0x0A, 0x07, 0x30, 0xD0,
  0xB7, 0x0C, 0x07, 0x68, 0x13, 0xF2, 0x58, 0x1E, 0xE7, 0x30,
  // "ŋ" (U+014B)
  0x04, 0xB7, 0xEC, 0x10, 0x7E, 0x61, 0xE5, 0x0B, 0xA0, 0x0E, 0x30, 0xE5, 0x02, 0xF0, 0x2F, 0x10,
  0x6C, 0x05, 0xD0, 0x09, 0x90, 0x8A, 0x00, 0xD5, 0x0B, 0x60, 0x1F, 0x10, 0x00, 0x04, 0xD0, 0x00,
  0x00, 0xA8, 0x00, 0x02, 0xFC, 0x10, 0x00,
  // "Ō" (U+014C)
  0x38, 0x32, 0xEE, 0xE7, 0x50, 0xF1, 0x77, 0x83, 0x6D, 0xEC, 0x23, 0x84, 0x8D, 0x31, 0x9C, 0x28,
  0x12, 0xF2, 0x28, 0x43, 0xF1, 0x0A, 0xA3, 0x84, 0x2F, 0x10, 0xE5, 0x38, 0x44, 0xF0, 0x2F, 0x13,
  0x82, 0x7C, 0x04, 0x94, 0x84, 0xC7, 0x03, 0xF1, 0x28, 0x15, 0xE1, 0x28, 0x4E, 0x80, 0x4E, 0x63,
  0x83, 0x4C, 0xFD, 0x53,
  // "ō" (U+014D)
  0x00, 0x2E, 0xEE, 0x70, 0x00, 0x11, 0x10, 0x00, 0x6E, 0xE7, 0x00, 0x5D, 0x23, 0xF2, 0x0D, 0x50,
  0x0E, 0x43, 0xE0, 0x00, 0xF3, 0x6C, 0x00, 0x3F, 0x17, 0xB0, 0x08, 0xA0, 0x5E, 0x14, 0xE3, 0x00,
  0x9E, 0xD4, 0x00,
  // "Ŏ" (U+014E)
  0x48, 0x2D, 0x15, 0x95, 0x82, 0x7E, 0xB1, 0x77, 0x71, 0x83, 0x6D, 0xEC, 0x23, 0x84, 0x8D, 0x31,
  0x9C, 0x28, 0x12, 0xF2, 0x28, 0x43, 0xF1, 0x0A, 0xA3, 0x84, 0x2F, 0x10, 0xE5, 0x38, 0x44, 0xF0,
  0x2F, 0x13, 0x82, 0x7C, 0x04, 0x94, 0x84, 0xC7, 0x03, 0xF1, 0x28, 0x15, 0xE1, 0x28, 0x4E, 0x80,
  0x4E, 0x63, 0x83, 0x4C, 0xFD, 0x53,
  // "ŏ" (U+014F)
  0x38, 0x2D, 0x15, 0x93, 0x82, 0x7E, 0xB1, 0x72, 0x82, 0x6E, 0xE7, 0x28, 0x75, 0xD2, 0x3F, 0x20,
  0xD5, 0x28, 0x2E, 0x43, 0xE3, 0x98, 0x13, 0x6C, 0x28, 0x33, 0xF1, 0x7B, 0x28, 0x78, 0xA0, 0x5E,
  0x14, 0xE3, 0x28, 0x29, 0xED, 0x42,
  // "Ő" (U+0150)
  0x50, 0xF1, 0x02, 0x48, 0x32, 0xD3, 0xC6, 0x38, 0x31, 0xB2, 0x95, 0x77, 0x71, 0x83, 0x6D, 0xEC,
  0x23, 0x84, 0x8D, 0x31, 0x9C, 0x28, 0x12, 0xF2, 0x28, 0x43, 0xF1, 0x0A, 0xA3, 0x84, 0x2F, 0x10,
  0xE5, 0x38, 0x44, 0xF0, 0x2F, 0x13, 0x82, 0x7C, 0x04, 0x94, 0x84, 0xC7, 0x03, 0xF1, 0x28, 0x15,
  0xE1, 0x28, 0x4E, 0x80, 0x4E, 0x63, 0x83, 0x4C, 0xFD, 0x53,
  // "ő" (U+0151)
  0x40, 0xF1, 0x02, 0x38, 0x32, 0xD3, 0xC6, 0x28, 0x31, 0xB2, 0x95, 0x74, 0x82, 0x6E, 0xE7, 0x38,
  0x45, 0xD2, 0x3F, 0x22, 0x0D, 0x05, 0x28, 0x3E, 0x40, 0x3E, 0x39, 0x82, 0x30, 0x6C, 0x28, 0x43,
  0xF1, 0x07, 0xB2, 0x08, 0x0A, 0x28, 0x45, 0xE1, 0x4E, 0x33, 0x82, 0x9E, 0xD4, 0x30,
  // "Œ" (U+0152)
  0x30, 0x70, 0xDD, 0x07, 0x28, 0x49, 0xD3, 0x1F, 0x24, 0x84, 0x3F, 0x20, 0x4E, 0x50, 0x0A, 0x20,
  0x70, 0xA5, 0x0E, 0x05, 0x28, 0x7B, 0xFE, 0xE5, 0x02, 0xF1, 0x28, 0x2E, 0x41, 0x12, 0x04, 0x92,
  0x03, 0x95, 0x84, 0x3F, 0x10, 0x6C, 0x68, 0x3E, 0x81, 0xA9, 0x60, 0x30, 0xCD, 0x07, 0x20,
  // "œ" (U+0153)
  0x00, 0x6E, 0xE5, 0x2B, 0xEA, 0x00, 0x5E, 0x23, 0xED, 0x51, 0xF3, 0x0D, 0x50, 0x0E, 0x70, 0x6E,
  0x03, 0xF0, 0x00, 0xFE, 0xEA, 0x20, 0x6C, 0x00, 0x3F, 0x10, 0x00, 0x07, 0xB0, 0x08, 0xF0, 0x00,
  0x00, 0x5D, 0x14, 0xDD, 0x60, 0x41, 0x00, 0x9E, 0xC2, 0x4D, 0xEB, 0x10,
  // "Ŕ" (U+0154)
  0x60, 0x60, 0x55, 0x81, 0x4E, 0x24, 0x81, 0x1C, 0x27, 0x75, 0x0A, 0xA0, 0xC0, 0x33, 0x83, 0xD5,
  0x1A, 0xC2, 0x84, 0x1F, 0x20, 0x5E, 0x20, 0x50, 0xE2, 0x07, 0x0C, 0x28, 0x49, 0xB0, 0x3E, 0x62,
  0x83, 0xCF, 0xEE, 0x63, 0x98, 0x15, 0x7D, 0x38, 0x43, 0xF0, 0x2F, 0x22, 0x07, 0x0C, 0x20, 0xD0,
  0x62, 0x0A, 0x08, 0x20, 0x90, 0xB2,
  // "ŕ" (U+0155)
  0x40, 0x60, 0x53, 0x81, 0x4E, 0x22, 0x81, 0x1C, 0x27, 0x18, 0x90, 0x4B, 0x8F, 0x20, 0x7E, 0x61,
  0x20, 0xB0, 0xA4, 0x0E, 0x05, 0x38, 0x12, 0xF1, 0x30, 0x50, 0xD4, 0x08, 0x0A, 0x40, 0xB0, 0x64,
  // "Ŗ" (U+0156)
  0x00, 0xAF, 0xFC, 0x30, 0x0D, 0x51, 0xAC, 0x01, 0xF2, 0x05, 0xE0, 0x5E, 0x00, 0x7C, 0x09, 0xB0,
  0x3E, 0x60, 0xCF, 0xEE, 0x60, 0x0F, 0x57, 0xD0, 0x03, 0xF0, 0x2F, 0x20, 0x7C, 0x00, 0xD6, 0x0A,
  0x80, 0x09, 0xB0, 0x00, 0x72, 0x00, 0x00, 0x3D, 0x00, 0x00, 0x0A, 0x30, 0x00, 0x00,
  // "ŗ" (U+0157)
  0x18, 0x90, 0x4B, 0x8F, 0x20, 0x7E, 0x61, 0x20, 0xB0, 0xA4, 0x0E, 0x05, 0x38, 0x12, 0xF1, 0x30,
  0x50, 0xD4, 0x08, 0x0A, 0x40, 0xB0, 0x65, 0x07, 0x02, 0x30, 0x30, 0xD4, 0x0A, 0x03, 0x40,
  // "Ř" (U+0158)
  0x30, 0x52, 0x06, 0x38, 0x27, 0x9A, 0x53, 0x81, 0x1F, 0x97, 0x73, 0x0A, 0xA0, 0xC0, 0x32, 0x89,
  0x5D, 0x51, 0xAC, 0x01, 0xF2, 0x05, 0xE0, 0x5E, 0x28, 0x95, 0x7C, 0x09, 0xB0, 0x3E, 0x60, 0xCF,
  0xEE, 0x62, 0x98, 0x15, 0x7D, 0x28, 0x73, 0xF0, 0x2F, 0x20, 0x7C, 0x28, 0x3D, 0x60, 0xA8, 0x20,
  0x90, 0xB1,
  // "ř" (U+0159)
  0x20, 0x52, 0x06, 0x28, 0x27, 0x9A, 0x52, 0x81, 0x1F, 0x97, 0x18, 0x90, 0x4B, 0x8F, 0x20, 0x7E,
  0x61, 0x20, 0xB0, 0xA4, 0x0E, 0x05, 0x38, 0x12, 0xF1, 0x30, 0x50, 0xD4, 0x08, 0x0A, 0x40, 0xB0,
  0x64,
  // "Ś" (U+015A)
  0x60, 0x60, 0x55, 0x81, 0x4E, 0x24, 0x81, 0x1C, 0x27, 0x76, 0x83, 0x7D, 0xFD, 0x52, 0x84, 0x6E,
  0x30, 0x42, 0x20, 0xA0, 0x96, 0x09, 0x0C, 0x68, 0x22, 0xEB, 0x15, 0x81, 0x1D, 0xC6, 0x81, 0x2F,
  0x46, 0x90, 0x42, 0x89, 0x35, 0x11, 0x8E, 0x10, 0x1C, 0xEE, 0xB2, 0x20,
  // "ś" (U+015B)
  0x40, 0x60, 0x53, 0x81, 0x4E, 0x22, 0x81, 0x1C, 0x27, 0x18, 0x90, 0x4D, 0xEC, 0x10, 0xE6, 0x14,
  0x29, 0x03, 0x48, 0x19, 0xD2, 0x48, 0x19, 0xD1, 0x48, 0x93, 0xE4, 0x04, 0x04, 0xF2, 0x0C, 0xFD,
  0x62,
  // "Ŝ" (U+015C)
  0x50, 0x40, 0x55, 0x82, 0x2D, 0xE1, 0x38, 0x31, 0xB2, 0x67, 0x77, 0x58, 0x37, 0xDF, 0xD5, 0x28,
  0x46, 0xE3, 0x04, 0x22, 0x0A, 0x09, 0x60, 0x90, 0xC6, 0x82, 0x2E, 0xB1, 0x58, 0x11, 0xDC, 0x68,
  0x12, 0xF4, 0x69, 0x04, 0x28, 0x93, 0x51, 0x18, 0xE1, 0x01, 0xCE, 0xEB, 0x22,
  // "ŝ" (U+015D)
  0x30, 0x40, 0x53, 0x89, 0x02, 0xDE, 0x10, 0x1B, 0x26, 0x77, 0x89, 0x04, 0xDE, 0xC1, 0x0E, 0x61,
  0x42, 0x90, 0x34, 0x81, 0x9D, 0x24, 0x81, 0x9D, 0x14, 0x89, 0x3E, 0x40, 0x40, 0x4F, 0x20, 0xCF,
  0xD6, 0x20,
  // "Ş" (U+015E)
  0x38, 0x37, 0xDF, 0xD5, 0x28, 0x46, 0xE3, 0x04, 0x22, 0x0A, 0x09, 0x60, 0x90, 0xC6, 0x82, 0x2E,
  0xB1, 0x58, 0x11, 0xDC, 0x68, 0x12, 0xF4, 0x69, 0x04, 0x28, 0x93, 0x51, 0x18, 0xE1, 0x01, 0xCE,
  0xEB, 0x24, 0x06, 0x68, 0x11, 0xC4, 0x60, 0x60, 0x94, 0x82, 0x1B, 0xB2, 0x40,
  // "ş" (U+015F)
  0x28, 0x34, 0xDE, 0xC1, 0x28, 0x2E, 0x61, 0x43, 0x90, 0x35, 0x81, 0x9D, 0x25, 0x81, 0x9D, 0x15,
  0x0E, 0x04, 0x28, 0x34, 0x04, 0xF2, 0x28, 0x2C, 0xFD, 0x64, 0x06, 0x58, 0x11, 0xC4, 0x50, 0x60,
  0x93, 0x82, 0x1B, 0xB2, 0x30,
  // "Š" (U+0160)
  0x40, 0x52, 0x06, 0x48, 0x27, 0x9A, 0x54, 0x81, 0x1F, 0x97, 0x76, 0x83, 0x7D, 0xFD, 0x52, 0x84,
  0x6E, 0x30, 0x42, 0x20, 0xA0, 0x96, 0x09, 0x0C, 0x68, 0x22, 0xEB, 0x15, 0x81, 0x1D, 0xC6, 0x81,
  0x2F, 0x46, 0x90, 0x42, 0x89, 0x35, 0x11, 0x8E, 0x10, 0x1C, 0xEE, 0xB2, 0x20,
  // "š" (U+0161)
  0x20, 0x52, 0x06, 0x28, 0x27, 0x9A, 0x52, 0x81, 0x1F, 0x97, 0x18, 0x90, 0x4D, 0xEC, 0x10, 0xE6,
  0x14, 0x29, 0x03, 0x48, 0x19, 0xD2, 0x48, 0x19, 0xD1, 0x48, 0x93, 0xE4, 0x04, 0x04, 0xF2, 0x0C,
  0xFD, 0x62,
  // "Ţ" (U+0162)
  0x20, 0x9C, 0x0E, 0x40, 0xB0, 0x86, 0x0E, 0x05, 0x58, 0x12, 0xF1, 0x50, 0x50, 0xD6, 0x09, 0x0A,
  0x60, 0xD0, 0x65, 0x81, 0x1F, 0x35, 0x04, 0x0E, 0x60, 0x70, 0xB6, 0x06, 0x68, 0x11, 0xC4, 0x60,
  0x60, 0x94, 0x82, 0x1B, 0xB2, 0x40,
  // "ţ" (U+0163)
  0x30, 0x80, 0x54, 0x0E, 0x02, 0x20, 0x10, 0xEA, 0x05, 0x20, 0x70, 0xB4, 0x0A, 0x07, 0x40, 0xE0,
  0x43, 0x81, 0x2F, 0x13, 0x05, 0x0D, 0x48, 0x17, 0xC1, 0x38, 0x13, 0xEE, 0x40, 0x64, 0x81, 0x1C,
  0x44, 0x06, 0x09, 0x28, 0x21, 0xBB, 0x22,
  // "Ť" (U+0164)
  0x20, 0x52, 0x06, 0x28, 0x27, 0x9A, 0x52, 0x81, 0x1F, 0x97, 0x60, 0x9C, 0x0E, 0x20, 0xB0, 0x84,
  0x0E, 0x05, 0x38, 0x12, 0xF1, 0x30, 0x50, 0xD4, 0x09, 0x0A, 0x40, 0xD0, 0x63, 0x81, 0x1F, 0x33,
  0x04, 0x0E, 0x40, 0x70, 0xB4,
  // "ť" (U+0165)
  0x40, 0x70, 0xA2, 0x82, 0x54, 0xC2, 0x28, 0x4D, 0x32, 0x01, 0xDA, 0x05, 0x20, 0x70, 0xB4, 0x0A,
  0x07, 0x40, 0xE0, 0x43, 0x81, 0x2F, 0x13, 0x05, 0x0D, 0x48, 0x17, 0xC1, 0x38, 0x13, 0xEE, 0x30,
  // "Ŧ" (U+0166)
  0x09, 0xC0, 0xE2, 0x0B, 0x08, 0x40, 0xE0, 0x43, 0x03, 0x93, 0x89, 0x0D, 0xEF, 0xE5, 0x01, 0xA9,
  0x13, 0x0D, 0x05, 0x38, 0x11, 0xF2, 0x30, 0x40, 0xE4, 0x08, 0x0B, 0x40,
  // "ŧ" (U+0167)
  0x00, 0x85, 0x00, 0x0E, 0x20, 0x1E, 0xFF, 0x50, 0x7B, 0x00, 0x0A, 0x80, 0x0A, 0xFE, 0xA0, 0x2F,
  0x30, 0x04, 0xD0, 0x00, 0x7C, 0x10, 0x03, 0xEE, 0x00,
  // "Ũ" (U+0168)
  0x48, 0x38, 0xC3, 0x64, 0x38, 0x32, 0xB4, 0xDC, 0x77, 0x70, 0xB0, 0x73, 0x90, 0x32, 0x0E, 0x04,
  0x20, 0x40, 0xE2, 0x03, 0x93, 0x07, 0x0B, 0x20, 0x60, 0xC3, 0x0B, 0x07, 0x20, 0xA0, 0x83, 0x0E,
  0x04, 0x20, 0xE0, 0x52, 0x03, 0x92, 0x81, 0x2F, 0x12, 0x07, 0x0C, 0x20, 0x49, 0x30, 0xC0, 0x72,
  0x85, 0x2F, 0x52, 0x7E, 0x13, 0x83, 0x6D, 0xFC, 0x33,
  // "ũ" (U+0169)
  0x00, 0x08, 0xC3, 0x64, 0x00, 0x2B, 0x4D, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x05, 0xD0, 0x08, 0xA0,
  0x08, 0xA0, 0x0B, 0x60, 0x0B, 0x70, 0x0F, 0x30, 0x0E, 0x30, 0x3F, 0x00, 0x3F, 0x00, 0x7C, 0x00,
  0x6C, 0x00, 0xC9, 0x00, 0x7D, 0x28, 0xE5, 0x00, 0x2D, 0xE5, 0xD2, 0x00,
  // "Ū" (U+016A)
  0x38, 0x32, 0xEE, 0xE7, 0x50, 0xF1, 0x76, 0x0B, 0x07, 0x39, 0x03, 0x20, 0xE0, 0x42, 0x04, 0x0E,
  0x20, 0x39, 0x30, 0x70, 0xB2, 0x06, 0x0C, 0x30, 0xB0, 0x72, 0x0A, 0x08, 0x30, 0xE0, 0x42, 0x0E,
  0x05, 0x20, 0x39, 0x28, 0x12, 0xF1, 0x20, 0x70, 0xC2, 0x04, 0x93, 0x0C, 0x07, 0x28, 0x52, 0xF5,
  0x27, 0xE1, 0x38, 0x36, 0xDF, 0xC3, 0x30,
  // "ū" (U+016B)
  0x00, 0x2E, 0xEE, 0x70, 0x00, 0x11, 0x10, 0x05, 0xD0, 0x08, 0xA0, 0x8A, 0x00, 0xB6, 0x0B, 0x70,
  0x0F, 0x30, 0xE3, 0x03, 0xF0, 0x3F, 0x00, 0x7C, 0x06, 0xC0, 0x0C, 0x90, 0x7D, 0x28, 0xE5, 0x02,
  0xDE, 0x5D, 0x20,
  // "Ŭ" (U+016C)
  0x48, 0x2D, 0x15, 0x95, 0x82, 0x7E, 0xB1, 0x77, 0x70, 0xB0, 0x73, 0x90, 0x32, 0x0E, 0x04, 0x20,
  0x40, 0xE2, 0x03, 0x93, 0x07, 0x0B, 0x20, 0x60, 0xC3, 0x0B, 0x07, 0x20, 0xA0, 0x83, 0x0E, 0x04,
  0x20, 0xE0, 0x52, 0x03, 0x92, 0x81, 0x2F, 0x12, 0x07, 0x0C, 0x20, 0x49, 0x30, 0xC0, 0x72, 0x85,
  0x2F, 0x52, 0x7E, 0x13, 0x83, 0x6D, 0xFC, 0x33,
  // "ŭ" (U+016D)
  0x00, 0x0D, 0x15, 0x90, 0x00, 0x7E, 0xB1, 0x00, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x8A, 0x08, 0xA0,
  0x0B, 0x60, 0xB7, 0x00, 0xF3, 0x0E, 0x30, 0x3F, 0x03, 0xF0, 0x07, 0xC0, 0x6C, 0x00, 0xC9, 0x07,
  0xD2, 0x8E, 0x50, 0x2D, 0xE5, 0xD2, 0x00,
  // "Ů" (U+016E)
  0x48, 0x16, 0xD9, 0x68, 0x2C, 0x2B, 0x15, 0x81, 0x9F, 0xC7, 0x77, 0x10, 0xB0, 0x73, 0x90, 0x32,
  0x0E, 0x04, 0x20, 0x40, 0xE2, 0x03, 0x93, 0x07, 0x0B, 0x20, 0x60, 0xC3, 0x0B, 0x07, 0x20, 0xA0,
  0x83, 0x0E, 0x04, 0x20, 0xE0, 0x52, 0x03, 0x92, 0x81, 0x2F, 0x12, 0x07, 0x0C, 0x20, 0x49, 0x30,
  0xC0, 0x72, 0x85, 0x2F, 0x52, 0x7E, 0x13, 0x83, 0x6D, 0xFC, 0x33,
  // "ů" (U+016F)
  0x00, 0x06, 0xD9, 0x00, 0x00, 0xC2, 0xB1, 0x00, 0x09, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x05, 0xD0,
  0x08, 0xA0, 0x8A, 0x00, 0xB6, 0x0B, 0x70, 0x0F, 0x30, 0xE3, 0x03, 0xF0, 0x3F, 0x00, 0x7C, 0x06,
  0xC0, 0x0C, 0x90, 0x7D, 0x28, 0xE5, 0x02, 0xDE, 0x5D, 0x20,
  // "Ű" (U+0170)
  0x50, 0xF1, 0x02, 0x48, 0x32, 0xD3, 0xC6, 0x38, 0x31, 0xB2, 0x95, 0x77, 0x70, 0xB0, 0x73, 0x90,
  0x32, 0x0E, 0x04, 0x20, 0x40, 0xE2, 0x03, 0x93, 0x07, 0x0B, 0x20, 0x60, 0xC3, 0x0B, 0x07, 0x20,
  0xA0, 0x83, 0x0E, 0x04, 0x20, 0xE0, 0x52, 0x03, 0x92, 0x81, 0x2F, 0x12, 0x07, 0x0C, 0x20, 0x49,
  0x30, 0xC0, 0x72, 0x85, 0x2F, 0x52, 0x7E, 0x13, 0x83, 0x6D, 0xFC, 0x33,
  // "ű" (U+0171)
  0x00, 0x00, 0x11, 0x12, 0x00, 0x02, 0xD3, 0xC6, 0x00, 0x1B, 0x29, 0x50, 0x00, 0x00, 0x00, 0x00,
  0x05, 0xD0, 0x08, 0xA0, 0x08, 0xA0, 0x0B, 0x60, 0x0B, 0x70, 0x0F, 0x30, 0x0E, 0x30, 0x3F, 0x00,
  0x3F, 0x00, 0x7C, 0x00, 0x6C, 0x00, 0xC9, 0x00, 0x7D, 0x28, 0xE5, 0x00, 0x2D, 0xE5, 0xD2, 0x00,
  // "Ų" (U+0172)
  0x20, 0xB0, 0x73, 0x90, 0x32, 0x0E, 0x04, 0x20, 0x40, 0xE2, 0x03, 0x93, 0x07, 0x0B, 0x20, 0x60,
  0xC3, 0x0B, 0x07, 0x20, 0xA0, 0x83, 0x0E, 0x04, 0x20, 0xE0, 0x52, 0x03, 0x92, 0x81, 0x2F, 0x12,
  0x07, 0x0C, 0x20, 0x49, 0x30, 0xC0, 0x72, 0x85, 0x2F, 0x52, 0x7E, 0x13, 0x06, 0xA0, 0xC0, 0x34,
  0x02, 0x0B, 0x70, 0x90, 0x77, 0x81, 0x7F, 0x57, 0x01, 0x60,
  // "ų" (U+0173)
  0x05, 0xD0, 0x08, 0xA0, 0x8A, 0x00, 0xB6, 0x0B, 0x70, 0x0F, 0x30, 0xE3, 0x03, 0xF0, 0x3F, 0x00,
  0x7C, 0x06, 0xC0, 0x0C, 0x90, 0x7D, 0x28, 0xE5, 0x02, 0xDE, 0x8F, 0x20, 0x00, 0x2B, 0x00, 0x00,
  0x09, 0x70, 0x00, 0x00, 0x7F, 0x50, 0x00, 0x00, 0x10, 0x00,
  // "Ŵ" (U+0174)
  0x50, 0x40, 0x57, 0x18, 0x22, 0xDE, 0x16, 0x83, 0x1B, 0x26, 0x77, 0x77, 0x40, 0x09, 0x28, 0x12,
  0xF3, 0x28, 0x29, 0xA9, 0x92, 0x81, 0x9F, 0x32, 0x8B, 0x7E, 0x39, 0x80, 0x1E, 0xD3, 0x06, 0xC0,
  0x98, 0x07, 0x9C, 0x30, 0xD5, 0x09, 0x80, 0xD2, 0xC3, 0x4E, 0x28, 0x79, 0x85, 0xB0, 0xD3, 0xB7,
  0x28, 0x79, 0x8C, 0x40, 0xD5, 0xE1, 0x28, 0x1A, 0xAD, 0x28, 0x1D, 0xB9, 0x38, 0x1A, 0xF6, 0x28,
  0x1D, 0xF2, 0x30, 0xA0, 0xE3, 0x0D, 0x0B, 0x40,
  // "ŵ" (U+0175)
  0x50, 0x40, 0x57, 0x82, 0x2D, 0xE1, 0x58, 0x31, 0xB2, 0x67, 0x75, 0x84, 0x1F, 0x10, 0x9E, 0x28,
  0xC6, 0xC6, 0x1F, 0x11, 0xEE, 0x03, 0xE0, 0x1F, 0x17, 0x9E, 0x09, 0x80, 0x1F, 0x1D, 0x3D, 0x0E,
  0x20, 0x1F, 0x5B, 0x1D, 0x6B, 0x28, 0x61, 0xFA, 0x52, 0xDC, 0x42, 0x85, 0x1F, 0xD0, 0x2E, 0xD3,
  0x85, 0x1F, 0x70, 0x2F, 0x73,
  // "Ŷ" (U+0176)
  0x30, 0x40, 0x54, 0x82, 0x2D, 0xE1, 0x28, 0x31, 0xB2, 0x67, 0x77, 0x10, 0x09, 0x28, 0x34, 0xE1,
  0x6C, 0x28, 0x6D, 0x60, 0x4E, 0x07, 0xC2, 0x83, 0x1F, 0x2E, 0x33, 0x81, 0xEC, 0x94, 0x81, 0xCE,
  0x14, 0x0B, 0x07, 0x59, 0x04, 0x40, 0x39, 0x50, 0x70, 0xC5,
  // "ŷ" (U+0177)
  0x50, 0x40, 0x56, 0x82, 0x2D, 0xE1, 0x48, 0x31, 0xB2, 0x67, 0x75, 0x85, 0x1F, 0x10, 0x1F, 0x23,
  0x98, 0x22, 0x08, 0xA4, 0x83, 0xE3, 0x1E, 0x34, 0x82, 0xD3, 0x7A, 0x58, 0x2C, 0x4E, 0x35, 0x81,
  0xBA, 0xA6, 0x81, 0xAF, 0x36, 0x00, 0xA6, 0x81, 0x1E, 0x36, 0x0A, 0x09, 0x58, 0x15, 0xFB, 0x60,
  // "Ÿ" (U+0178)
  0x18, 0x31, 0xC0, 0x95, 0x77, 0x71, 0x00, 0x92, 0x83, 0x4E, 0x16, 0xC2, 0x86, 0xD6, 0x04, 0xE0,
  0x7C, 0x28, 0x31, 0xF2, 0xE3, 0x38, 0x1E, 0xC9, 0x48, 0x1C, 0xE1, 0x40, 0xB0, 0x75, 0x90, 0x44,
  0x03, 0x95, 0x07, 0x0C, 0x50,
  // "Ź" (U+0179)
  0x60, 0x60, 0x55, 0x81, 0x4E, 0x24, 0x81, 0x1C, 0x27, 0x75, 0x03, 0xC0, 0x95, 0x81, 0x4F, 0x25,
  0x0D, 0x07, 0x50, 0x80, 0xC5, 0x81, 0x3F, 0x25, 0x0D, 0x07, 0x50, 0x80, 0xC5, 0x81, 0x3F, 0x25,
  0x0D, 0x07, 0x50, 0x5C, 0x0B, 0x20,
  // "ź" (U+017A)
  0x50, 0x60, 0x54, 0x81, 0x4E, 0x23, 0x81, 0x1C, 0x27, 0x30, 0xAB, 0x02, 0x40, 0x90, 0xA4, 0x81,
  0x3E, 0x14, 0x0D, 0x05, 0x40, 0x80, 0xB4, 0x81, 0x2E, 0x24, 0x0C, 0x07, 0x40, 0x5B, 0x0C, 0x20,
  // "Ż" (U+017B)
  0x50, 0xC0, 0x37, 0x77, 0x60, 0x3C, 0x09, 0x58, 0x14, 0xF2, 0x50, 0xD0, 0x75, 0x08, 0x0C, 0x58,
  0x13, 0xF2, 0x50, 0xD0, 0x75, 0x08, 0x0C, 0x58, 0x13, 0xF2, 0x50, 0xD0, 0x75, 0x05, 0xC0, 0xB2,
  // "ż" (U+017C)
  0x40, 0xC0, 0x37, 0x73, 0x0A, 0xB0, 0x24, 0x09, 0x0A, 0x48, 0x13, 0xE1, 0x40, 0xD0, 0x54, 0x08,
  0x0B, 0x48, 0x12, 0xE2, 0x40, 0xC0, 0x74, 0x05, 0xB0, 0xC2,
  // "Ž" (U+017D)
  0x40, 0x52, 0x06, 0x48, 0x27, 0x9A, 0x54, 0x81, 0x1F, 0x97, 0x75, 0x03, 0xC0, 0x95, 0x81, 0x4F,
  0x25, 0x0D, 0x07, 0x50, 0x80, 0xC5, 0x81, 0x3F, 0x25, 0x0D, 0x07, 0x50, 0x80, 0xC5, 0x81, 0x3F,
  0x25, 0x0D, 0x07, 0x50, 0x5C, 0x0B, 0x20,
  // "ž" (U+017E)
  0x30, 0x52, 0x06, 0x38, 0x27, 0x9A, 0x53, 0x81, 0x1F, 0x97, 0x30, 0xAB, 0x02, 0x40, 0x90, 0xA4,
  0x81, 0x3E, 0x14, 0x0D, 0x05, 0x40, 0x80, 0xB4, 0x81, 0x2E, 0x24, 0x0C, 0x07, 0x40, 0x5B, 0x0C,
  0x20,
  // "ſ" (U+017F)
  0x48, 0x22, 0xCE, 0x44, 0x81, 0xB9, 0x15, 0x90, 0x35, 0x04, 0x0E, 0x60, 0x70, 0xB6, 0x0B, 0x07,
  0x60, 0xE0, 0x45, 0x02, 0x96, 0x06, 0x0C, 0x60, 0xA0, 0x86, 0x0D, 0x05, 0x58, 0x11, 0xF1, 0x50,
  0x80, 0xC5, 0x81, 0xDD, 0x25,
  // "Ω" (U+03A9)
  0x00, 0x00, 0x7D, 0xFC, 0x30, 0x00, 0x09, 0xD3, 0x19, 0xE0, 0x00, 0x4F, 0x10, 0x02, 0xF3, 0x00,
  0xB9, 0x00, 0x01, 0xF3, 0x00, 0xF4, 0x00, 0x03, 0xF1, 0x02, 0xF2, 0x00, 0x07, 0xC0, 0x02, 0xF1,
  0x00, 0x0D, 0x60, 0x00, 0xE3, 0x00, 0x7C, 0x00, 0x00, 0x8A, 0x05, 0xC1, 0x00, 0x5F, 0xFE, 0x0F,
  0xFF, 0x50,
  // "μ" (U+03BC)
  0x00, 0x4E, 0x00, 0x8A, 0x00, 0x8A, 0x00, 0xB7, 0x00, 0xB7, 0x00, 0xE3, 0x00, 0xE4, 0x02, 0xF0,
  0x03, 0xF1, 0x06, 0xC0, 0x06, 0xD0, 0x0B, 0x90, 0x09, 0xD0, 0x6F, 0x60, 0x0D, 0xCE, 0x8D, 0x20,
  0x1F, 0x20, 0x00, 0x00, 0x4E, 0x00, 0x00, 0x00, 0x8A, 0x00, 0x00, 0x00,
  // "π" (U+03C0)
  0x2D, 0xFF, 0xFF, 0xF9, 0x04, 0xE0, 0x0F, 0x30, 0x07, 0xB0, 0x3F, 0x00, 0x0A, 0x70, 0x6C, 0x00,
  0x0E, 0x40, 0xA8, 0x00, 0x2F, 0x10, 0xD5, 0x00, 0x5D, 0x00, 0xF4, 0x00, 0x89, 0x00, 0xBE, 0x10,
  // "–" (U+2013)
  0x7E, 0xEE, 0xEE, 0x50, 0x11, 0x11, 0x10,
  // "—" (U+2014)
  0x07, 0x80, 0x90, 0xE0, 0x31, 0x80, 0x90, 0x11,
  // "€" (U+20AC)
  0x38, 0x35, 0xCF, 0xD3, 0x28, 0x35, 0xE5, 0x03, 0x28, 0x11, 0xE3, 0x48, 0x44, 0xEF, 0xEE, 0x43,
  0x82, 0xB9, 0x11, 0x38, 0x3A, 0xFE, 0xE8, 0x38, 0x21, 0xD6, 0x15, 0x0B, 0x07, 0x68, 0x37, 0xC1,
  0x21, 0x48, 0x2A, 0xED, 0x42,
  // "₿" (U+20BF)
  0x00, 0x03, 0x7A, 0x00, 0x00, 0x64, 0xA0, 0x00, 0xAF, 0xFD, 0x10, 0x0D, 0x51, 0xC9, 0x01, 0xF1,
  0x0A, 0x90, 0x5D, 0x03, 0xE3, 0x09, 0xFE, 0xE3, 0x00, 0xC7, 0x2C, 0x90, 0x0F, 0x30, 0x6D, 0x03,
  0xE0, 0x08, 0xB0, 0x7B, 0x04, 0xE5, 0x0A, 0xFF, 0xE6, 0x00, 0x0A, 0x55, 0x00, 0x00, 0x53, 0x10,
  0x00,
  // "‘" (U+2018)
  0x09, 0x53, 0xD0, 0xB8, 0x07, 0x10,
  // "’" (U+2019)
  0x0E, 0x54, 0xD0, 0xB5, 0x06, 0x00,
  // "‚" (U+201A)
  0x03, 0x70, 0xA9, 0x1E, 0x27, 0x80,
  // "‛" (U+201B)
  0x7C, 0x6B, 0x3C,
  // "“" (U+201C)
  0x0A, 0x53, 0xC4, 0xD0, 0xD4, 0xD6, 0x6D, 0x00,
  // "”" (U+201D)
  0x0E, 0x58, 0xC6, 0xB0, 0xE3, 0xD2, 0x78, 0x00,
  // "„" (U+201E)
  0x0A, 0xA3, 0xF2, 0x0E, 0x38, 0xB0, 0x5C, 0x0D, 0x30, 0xB4, 0x4B, 0x00,
  // "‟" (U+201F)
  0x7C, 0x1F, 0x25, 0xC0, 0xF2, 0x2D, 0x0C, 0x20,
  // "†" (U+2020)
  0x28, 0x12, 0xF1, 0x30, 0x40, 0xC3, 0x89, 0x11, 0x67, 0x10, 0x7D, 0xEC, 0xD3, 0x20, 0xC4, 0x01,
  0x0C, 0x40, 0x50, 0xA4, 0x09, 0x07, 0x40, 0xD0, 0x43, 0x81, 0x1F, 0x13, 0x05, 0x0E, 0x40,
  // "‡" (U+2021)
  0x38, 0x12, 0xF1, 0x40, 0x30, 0xC3, 0x89, 0x32, 0x58, 0x95, 0x20, 0x59, 0xD9, 0x93, 0x30, 0xD0,
  0x14, 0x02, 0x0E, 0x50, 0x50, 0xA3, 0x89, 0x34, 0x8B, 0xB8, 0x30, 0x35, 0xC6, 0x61, 0x30, 0xE5,
  0x05, 0x0D, 0x40,
  // "•" (U+2022)
  0x4E, 0xD3, 0xCF, 0xF9, 0xCF, 0xF9, 0x4E, 0xD2,
  // "…" (U+2026)
  0x69, 0x06, 0x90, 0x06, 0x9A, 0x90, 0xA9, 0x00, 0xA9,
  // "‰" (U+2030)
  0x00, 0x9E, 0x70, 0x08, 0x70, 0x00, 0x00, 0x06, 0xA3, 0xC0, 0x3C, 0x00, 0x00, 0x00, 0x0C, 0x23,
  0xB0, 0xC3, 0x00, 0x00, 0x00, 0x0E, 0x06, 0x86, 0xAC, 0xC1, 0x09, 0xD3, 0x1D, 0x1D, 0x4D, 0xC6,
  0xB5, 0x79, 0x79, 0x0C, 0xF7, 0xA7, 0xD0, 0x96, 0xD2, 0x59, 0x00, 0x05, 0xA5, 0x90, 0xB5, 0xD0,
  0x77, 0x00, 0x0D, 0x18, 0x70, 0xE4, 0xB0, 0xB3, 0x00, 0x96, 0x07, 0x87, 0x93, 0xC3, 0xC0, 0x03,
  0xC0, 0x02, 0xEC, 0x00, 0xCD, 0x30,
  // "‹" (U+2039)
  0x00, 0x58, 0x04, 0xD2, 0x3E, 0x30, 0x4E, 0x00, 0x0C, 0x50, 0x05, 0xA0,
  // "›" (U+203A)
  0x0B, 0x10, 0x09, 0x90, 0x02, 0xF1, 0x05, 0xE2, 0x2E, 0x30, 0xB4, 0x00,
  // "⁄" (U+2044)
  0x78, 0x11, 0xC1, 0x70, 0xB0, 0x47, 0x09, 0x07, 0x70, 0x50, 0xA7, 0x03, 0x0C, 0x78, 0x11, 0xC2,
  0x70, 0xB0, 0x47, 0x00, 0x87, 0x05, 0x0B, 0x78, 0x12, 0xC1, 0x70,
  // "™" (U+2122)
  0x9C, 0xC8, 0xA7, 0x01, 0xD2, 0x06, 0x50, 0xBC, 0x06, 0xD2, 0x06, 0x50, 0xB9, 0x2A, 0x92, 0x06,
  0x50, 0xB4, 0x89, 0x92, 0x06, 0x50, 0xB0, 0xE4, 0x92, 0x02, 0x20, 0x40, 0x40, 0x31,
  // "⅒" (U+2152)
  0x30, 0x30, 0x57, 0x58, 0x17, 0xE7, 0x28, 0x11, 0xC1, 0x78, 0x16, 0xA4, 0x20, 0xB0, 0x47, 0x28,
  0x3D, 0x10, 0x97, 0x72, 0x89, 0x21, 0xD0, 0x5A, 0x03, 0x50, 0x5D, 0xB3, 0x89, 0x34, 0xA3, 0xC0,
  0x7E, 0x71, 0xD1, 0xB3, 0x28, 0x93, 0x78, 0xC2, 0x06, 0xA4, 0x78, 0x0B, 0x43, 0x0B, 0x04, 0x38,
  0x5D, 0x1A, 0x40, 0xD2, 0x20, 0x08, 0x38, 0x51, 0xD0, 0xC2, 0x1D, 0x20, 0x50, 0xB4, 0x89, 0x14,
  0xA0, 0xC3, 0x88, 0x02, 0xC1, 0x48, 0x47, 0x70, 0x5D, 0xA2,
  // "ﬁ" (U+FB01)
  0x48, 0x41, 0xBE, 0x59, 0x64, 0x81, 0x8A, 0x17, 0x0D, 0x04, 0x60, 0x10, 0xBA, 0x81, 0x54, 0xE4,
  0x05, 0x0D, 0x20, 0x70, 0xA4, 0x00, 0x92, 0x0B, 0x07, 0x40, 0xC0, 0x62, 0x0E, 0x04, 0x49, 0x83,
  0x20, 0x2F, 0x13, 0x04, 0x0E, 0x20, 0x50, 0xD4, 0x07, 0x0B, 0x20, 0x80, 0x94, 0x0B, 0x07, 0x20,
  0xB0, 0x64, 0x0E, 0x03, 0x70, 0x50, 0xE7, 0x81, 0xBE, 0x47,
  // "ﬂ" (U+FB02)
  0x48, 0x41, 0xBE, 0x58, 0x94, 0x84, 0x8A, 0x10, 0xC6, 0x40, 0xD0, 0x42, 0x90, 0x32, 0x01, 0x0B,
  0xA8, 0x15, 0x3E, 0x40, 0x50, 0xD2, 0x06, 0x0B, 0x40, 0x09, 0x20, 0xA0, 0x84, 0x0C, 0x06, 0x20,
  0xD0, 0x44, 0x98, 0x32, 0x01, 0xF1, 0x30, 0x40, 0xE2, 0x05, 0x0D, 0x40, 0x70, 0xB2, 0x08, 0x09,
  0x40, 0xB0, 0x72, 0x0B, 0x06, 0x40, 0xE0, 0x37, 0x05, 0x0E, 0x78, 0x1B, 0xE4, 0x70,
};

const Font& font_NotoSans_CondensedItalic_15() {
  static SmoothFont font(font_NotoSans_CondensedItalic_15_data);
  return font;
}

}  // namespace roo_display
