#include "12.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSans-CondensedItalic (Noto Sans Condensed Italic)
// Generated on Wed Nov 19 19:11:24 CET 2025
static const uint8_t font_NotoSans_CondensedItalic_12_data[] PROGMEM = {
  
  // Header
  0x01, 0x02, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x03, 0x02,
  0xFD, 0xFE, 0x0B, 0x0D, 0x0A, 0xFD, 0x03, 0x01, 0x0B, 0x04, 0x03, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x40, 0x01, 0x02, 0x09, 0x03, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x41, 0x07, 0x04, 0x09, 0x04, 0x00, 0x0E, // """ (U+0022)
  0x00, 0x23, 0x40, 0x01, 0x05, 0x09, 0x06, 0x00, 0x14, // "#" (U+0023)
  0x00, 0x24, 0x00, 0x00, 0x05, 0x0A, 0x05, 0x00, 0x2F, // "$" (U+0024)
  0x00, 0x25, 0x40, 0x01, 0x07, 0x09, 0x08, 0x00, 0x4E, // "%" (U+0025)
  0x00, 0x26, 0x40, 0x01, 0x05, 0x09, 0x06, 0x00, 0x72, // "&" (U+0026)
  0x00, 0x27, 0x41, 0x07, 0x02, 0x09, 0x02, 0x00, 0x8D, // "'" (U+0027)
  0x00, 0x28, 0x40, 0xFF, 0x03, 0x09, 0x03, 0x00, 0x90, // "(" (U+0028)
  0x00, 0x29, 0xBF, 0xFF, 0x02, 0x09, 0x03, 0x00, 0xA6, // ")" (U+0029)
  0x00, 0x2A, 0x41, 0x06, 0x05, 0x0A, 0x05, 0x00, 0xBC, // "*" (U+002A)
  0x00, 0x2B, 0x00, 0x03, 0x05, 0x08, 0x06, 0x00, 0xC9, // "+" (U+002B)
  0x00, 0x2C, 0xBF, 0xFF, 0x01, 0x01, 0x03, 0x00, 0xD8, // "," (U+002C)
  0x00, 0x2D, 0x40, 0x04, 0x02, 0x04, 0x03, 0x00, 0xDD, // "-" (U+002D)
  0x00, 0x2E, 0x40, 0x01, 0x01, 0x02, 0x03, 0x00, 0xDF, // "." (U+002E)
  0x00, 0x2F, 0xFF, 0x01, 0x04, 0x09, 0x04, 0x00, 0xE1, // "/" (U+002F)
  0x00, 0x30, 0x40, 0x01, 0x05, 0x09, 0x05, 0x00, 0xF8, // "0" (U+0030)
  0x00, 0x31, 0x41, 0x01, 0x04, 0x09, 0x05, 0x01, 0x13, // "1" (U+0031)
  0x00, 0x32, 0xFF, 0x01, 0x05, 0x09, 0x05, 0x01, 0x25, // "2" (U+0032)
  0x00, 0x33, 0x40, 0x01, 0x05, 0x09, 0x05, 0x01, 0x40, // "3" (U+0033)
  0x00, 0x34, 0x40, 0x01, 0x05, 0x09, 0x05, 0x01, 0x5B, // "4" (U+0034)
  0x00, 0x35, 0x00, 0x01, 0x05, 0x09, 0x05, 0x01, 0x76, // "5" (U+0035)
  0x00, 0x36, 0x40, 0x01, 0x05, 0x09, 0x05, 0x01, 0x90, // "6" (U+0036)
  0x00, 0x37, 0x00, 0x01, 0x05, 0x09, 0x05, 0x01, 0xAB, // "7" (U+0037)
  0x00, 0x38, 0x40, 0x01, 0x05, 0x09, 0x05, 0x01, 0xC4, // "8" (U+0038)
  0x00, 0x39, 0x40, 0x01, 0x05, 0x09, 0x05, 0x01, 0xDF, // "9" (U+0039)
  0x00, 0x3A, 0x00, 0x01, 0x02, 0x07, 0x03, 0x01, 0xFA, // ":" (U+003A)
  0x00, 0x3B, 0xFF, 0xFF, 0x02, 0x07, 0x03, 0x02, 0x03, // ";" (U+003B)
  0x00, 0x3C, 0x40, 0x02, 0x05, 0x07, 0x06, 0x02, 0x12, // "<" (U+003C)
  0x00, 0x3D, 0x00, 0x04, 0x05, 0x07, 0x06, 0x02, 0x24, // "=" (U+003D)
  0x00, 0x3E, 0x40, 0x02, 0x05, 0x07, 0x06, 0x02, 0x2D, // ">" (U+003E)
  0x00, 0x3F, 0x00, 0x01, 0x04, 0x09, 0x04, 0x02, 0x3F, // "?" (U+003F)
  0x00, 0x40, 0x40, 0x00, 0x07, 0x09, 0x08, 0x02, 0x55, // "@" (U+0040)
  0x00, 0x41, 0xBF, 0x01, 0x04, 0x09, 0x05, 0x02, 0x7D, // "A" (U+0041)
  0x00, 0x42, 0x40, 0x01, 0x05, 0x09, 0x06, 0x02, 0x98, // "B" (U+0042)
  0x00, 0x43, 0x00, 0x01, 0x05, 0x09, 0x05, 0x02, 0xB3, // "C" (U+0043)
  0x00, 0x44, 0x40, 0x01, 0x05, 0x09, 0x06, 0x02, 0xCC, // "D" (U+0044)
  0x00, 0x45, 0x00, 0x01, 0x05, 0x09, 0x05, 0x02, 0xE7, // "E" (U+0045)
  0x00, 0x46, 0x00, 0x01, 0x05, 0x09, 0x05, 0x03, 0x00, // "F" (U+0046)
  0x00, 0x47, 0x40, 0x01, 0x06, 0x09, 0x07, 0x03, 0x18, // "G" (U+0047)
  0x00, 0x48, 0x40, 0x01, 0x06, 0x09, 0x07, 0x03, 0x38, // "H" (U+0048)
  0x00, 0x49, 0xBF, 0x01, 0x03, 0x09, 0x03, 0x03, 0x58, // "I" (U+0049)
  0x00, 0x4A, 0xBE, 0xFE, 0x02, 0x09, 0x03, 0x03, 0x6F, // "J" (U+004A)
  0x00, 0x4B, 0x40, 0x01, 0x06, 0x09, 0x05, 0x03, 0x8D, // "K" (U+004B)
  0x00, 0x4C, 0x40, 0x01, 0x03, 0x09, 0x05, 0x03, 0xAD, // "L" (U+004C)
  0x00, 0x4D, 0x40, 0x01, 0x08, 0x09, 0x08, 0x03, 0xBF, // "M" (U+004D)
  0x00, 0x4E, 0x40, 0x01, 0x06, 0x09, 0x07, 0x03, 0xE8, // "N" (U+004E)
  0x00, 0x4F, 0x40, 0x01, 0x06, 0x09, 0x07, 0x04, 0x08, // "O" (U+004F)
  0x00, 0x50, 0x00, 0x01, 0x05, 0x09, 0x05, 0x04, 0x28, // "P" (U+0050)
  0x00, 0x51, 0x40, 0xFF, 0x06, 0x09, 0x07, 0x04, 0x42, // "Q" (U+0051)
  0x00, 0x52, 0x40, 0x01, 0x05, 0x09, 0x06, 0x04, 0x69, // "R" (U+0052)
  0x00, 0x53, 0xFF, 0x01, 0x05, 0x09, 0x05, 0x04, 0x84, // "S" (U+0053)
  0x00, 0x54, 0x01, 0x01, 0x05, 0x09, 0x05, 0x04, 0xA1, // "T" (U+0054)
  0x00, 0x55, 0x40, 0x01, 0x06, 0x09, 0x06, 0x04, 0xB7, // "U" (U+0055)
  0x00, 0x56, 0x41, 0x01, 0x06, 0x09, 0x05, 0x04, 0xD7, // "V" (U+0056)
  0x00, 0x57, 0x41, 0x01, 0x09, 0x09, 0x09, 0x04, 0xF2, // "W" (U+0057)
  0x00, 0x58, 0xBF, 0x01, 0x05, 0x09, 0x05, 0x05, 0x1B, // "X" (U+0058)
  0x00, 0x59, 0x41, 0x01, 0x05, 0x09, 0x05, 0x05, 0x3B, // "Y" (U+0059)
  0x00, 0x5A, 0xFF, 0x01, 0x05, 0x09, 0x05, 0x05, 0x52, // "Z" (U+005A)
  0x00, 0x5B, 0xFF, 0xFF, 0x04, 0x09, 0x03, 0x05, 0x6D, // "[" (U+005B)
  0x00, 0x5C, 0x41, 0x01, 0x03, 0x09, 0x04, 0x05, 0x89, // "\" (U+005C)
  0x00, 0x5D, 0xFF, 0xFF, 0x03, 0x09, 0x03, 0x05, 0x97, // "]" (U+005D)
  0x00, 0x5E, 0x40, 0x05, 0x05, 0x09, 0x05, 0x05, 0xB2, // "^" (U+005E)
  0x00, 0x5F, 0xBF, 0xFF, 0x02, 0xFF, 0x04, 0x05, 0xC1, // "_" (U+005F)
  0x00, 0x60, 0x41, 0x09, 0x03, 0x0A, 0x03, 0x05, 0xC3, // "`" (U+0060)
  0x00, 0x61, 0x40, 0x01, 0x05, 0x07, 0x06, 0x05, 0xC6, // "a" (U+0061)
  0x00, 0x62, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x05, 0xDB, // "b" (U+0062)
  0x00, 0x63, 0x40, 0x01, 0x04, 0x07, 0x04, 0x05, 0xF9, // "c" (U+0063)
  0x00, 0x64, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x06, 0x0B, // "d" (U+0064)
  0x00, 0x65, 0x40, 0x01, 0x04, 0x07, 0x05, 0x06, 0x28, // "e" (U+0065)
  0x00, 0x66, 0xFE, 0xFE, 0x04, 0x0A, 0x03, 0x06, 0x3A, // "f" (U+0066)
  0x00, 0x67, 0x40, 0xFE, 0x05, 0x07, 0x06, 0x06, 0x5B, // "g" (U+0067)
  0x00, 0x68, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x06, 0x79, // "h" (U+0068)
  0x00, 0x69, 0x40, 0x01, 0x02, 0x0A, 0x03, 0x06, 0x97, // "i" (U+0069)
  0x00, 0x6A, 0xFE, 0xFE, 0x02, 0x0A, 0x03, 0x06, 0xA6, // "j" (U+006A)
  0x00, 0x6B, 0x40, 0x01, 0x04, 0x0A, 0x05, 0x06, 0xC1, // "k" (U+006B)
  0x00, 0x6C, 0x40, 0x01, 0x02, 0x0A, 0x03, 0x06, 0xDA, // "l" (U+006C)
  0x00, 0x6D, 0x40, 0x01, 0x07, 0x07, 0x08, 0x06, 0xE9, // "m" (U+006D)
  0x00, 0x6E, 0x40, 0x01, 0x05, 0x07, 0x06, 0x07, 0x05, // "n" (U+006E)
  0x00, 0x6F, 0x40, 0x01, 0x04, 0x07, 0x05, 0x07, 0x1A, // "o" (U+006F)
  0x00, 0x70, 0xFF, 0xFE, 0x05, 0x07, 0x06, 0x07, 0x2C, // "p" (U+0070)
  0x00, 0x71, 0x40, 0xFE, 0x05, 0x07, 0x06, 0x07, 0x4D, // "q" (U+0071)
  0x00, 0x72, 0x00, 0x01, 0x04, 0x07, 0x04, 0x07, 0x6B, // "r" (U+0072)
  0x00, 0x73, 0x40, 0x01, 0x04, 0x07, 0x04, 0x07, 0x7C, // "s" (U+0073)
  0x00, 0x74, 0x40, 0x01, 0x03, 0x09, 0x03, 0x07, 0x8E, // "t" (U+0074)
  0x00, 0x75, 0x40, 0x01, 0x05, 0x07, 0x06, 0x07, 0xA0, // "u" (U+0075)
  0x00, 0x76, 0x40, 0x01, 0x04, 0x07, 0x05, 0x07, 0xB5, // "v" (U+0076)
  0x00, 0x77, 0x40, 0x01, 0x07, 0x07, 0x07, 0x07, 0xC7, // "w" (U+0077)
  0x00, 0x78, 0xBF, 0x01, 0x04, 0x07, 0x05, 0x07, 0xE3, // "x" (U+0078)
  0x00, 0x79, 0xFE, 0xFE, 0x04, 0x07, 0x05, 0x07, 0xF8, // "y" (U+0079)
  0x00, 0x7A, 0xBF, 0x01, 0x04, 0x07, 0x04, 0x08, 0x18, // "z" (U+007A)
  0x00, 0x7B, 0x00, 0xFF, 0x04, 0x09, 0x04, 0x08, 0x2D, // "{" (U+007B)
  0x00, 0x7C, 0x02, 0xFE, 0x02, 0x0A, 0x05, 0x08, 0x48, // "|" (U+007C)
  0x00, 0x7D, 0xFF, 0xFF, 0x03, 0x09, 0x04, 0x08, 0x4B, // "}" (U+007D)
  0x00, 0x7E, 0x40, 0x05, 0x05, 0x06, 0x06, 0x08, 0x66, // "~" (U+007E)
  0x00, 0xA1, 0x40, 0xFE, 0x02, 0x07, 0x03, 0x08, 0x6C, // "¡" (U+00A1)
  0x00, 0xA2, 0x00, 0x01, 0x04, 0x09, 0x05, 0x08, 0x7B, // "¢" (U+00A2)
  0x00, 0xA3, 0xFF, 0x01, 0x05, 0x09, 0x05, 0x08, 0x91, // "£" (U+00A3)
  0x00, 0xA4, 0x40, 0x02, 0x05, 0x08, 0x06, 0x08, 0xAE, // "¤" (U+00A4)
  0x00, 0xA5, 0x40, 0x01, 0x05, 0x09, 0x05, 0x08, 0xC3, // "¥" (U+00A5)
  0x00, 0xA6, 0x02, 0xFE, 0x02, 0x0A, 0x05, 0x08, 0xDE, // "¦" (U+00A6)
  0x00, 0xA7, 0x40, 0x01, 0x04, 0x0A, 0x05, 0x08, 0xE3, // "§" (U+00A7)
  0x00, 0xA8, 0x42, 0x09, 0x05, 0x09, 0x06, 0x08, 0xFC, // "¨" (U+00A8)
  0x00, 0xA9, 0x40, 0x01, 0x09, 0x0A, 0x0A, 0x08, 0xFE, // "©" (U+00A9)
  0x00, 0xAA, 0x40, 0x06, 0x04, 0x09, 0x03, 0x09, 0x30, // "ª" (U+00AA)
  0x00, 0xAB, 0x40, 0x01, 0x04, 0x06, 0x05, 0x09, 0x3A, // "«" (U+00AB)
  0x00, 0xAC, 0x40, 0x02, 0x05, 0x05, 0x06, 0x09, 0x49, // "¬" (U+00AC)
  0x00, 0xAE, 0x40, 0x01, 0x09, 0x0A, 0x0A, 0x09, 0x55, // "®" (U+00AE)
  0x00, 0xAF, 0x41, 0x0B, 0x05, 0x0B, 0x05, 0x09, 0x87, // "¯" (U+00AF)
  0x00, 0xB0, 0x40, 0x07, 0x03, 0x0A, 0x05, 0x09, 0x8A, // "°" (U+00B0)
  0x00, 0xB1, 0x00, 0x01, 0x05, 0x08, 0x06, 0x09, 0x92, // "±" (U+00B1)
  0x00, 0xB2, 0x40, 0x06, 0x04, 0x0B, 0x04, 0x09, 0xA6, // "²" (U+00B2)
  0x00, 0xB3, 0x40, 0x06, 0x04, 0x0B, 0x04, 0x09, 0xB5, // "³" (U+00B3)
  0x00, 0xB4, 0x41, 0x09, 0x03, 0x0A, 0x03, 0x09, 0xC4, // "´" (U+00B4)
  0x00, 0xB5, 0xFF, 0xFE, 0x05, 0x07, 0x06, 0x09, 0xC7, // "µ" (U+00B5)
  0x00, 0xB6, 0x41, 0xFF, 0x05, 0x0A, 0x06, 0x09, 0xE9, // "¶" (U+00B6)
  0x00, 0xB7, 0x41, 0x05, 0x02, 0x06, 0x03, 0x0A, 0x07, // "·" (U+00B7)
  0x00, 0xB8, 0xBF, 0xFE, 0x01, 0x01, 0x02, 0x0A, 0x09, // "¸" (U+00B8)
  0x00, 0xB9, 0x41, 0x06, 0x03, 0x0A, 0x04, 0x0A, 0x0F, // "¹" (U+00B9)
  0x00, 0xBA, 0x40, 0x06, 0x03, 0x09, 0x04, 0x0A, 0x17, // "º" (U+00BA)
  0x00, 0xBB, 0x40, 0x01, 0x04, 0x06, 0x05, 0x0A, 0x1F, // "»" (U+00BB)
  0x00, 0xBC, 0x40, 0x01, 0x07, 0x09, 0x08, 0x0A, 0x2E, // "¼" (U+00BC)
  0x00, 0xBD, 0x40, 0x01, 0x08, 0x09, 0x09, 0x0A, 0x52, // "½" (U+00BD)
  0x00, 0xBE, 0x40, 0x01, 0x08, 0x09, 0x08, 0x0A, 0x7B, // "¾" (U+00BE)
  0x00, 0xBF, 0xFF, 0xFE, 0x03, 0x06, 0x04, 0x0A, 0xA4, // "¿" (U+00BF)
  0x00, 0xC0, 0xFF, 0x01, 0x04, 0x0C, 0x05, 0x0A, 0xBA, // "À" (U+00C0)
  0x00, 0xC1, 0xFF, 0x01, 0x05, 0x0C, 0x05, 0x0A, 0xDD, // "Á" (U+00C1)
  0x00, 0xC2, 0xFF, 0x01, 0x05, 0x0C, 0x05, 0x0B, 0x03, // "Â" (U+00C2)
  0x00, 0xC3, 0xFF, 0x01, 0x05, 0x0C, 0x05, 0x0B, 0x2A, // "Ã" (U+00C3)
  0x00, 0xC4, 0xFF, 0x01, 0x05, 0x0B, 0x05, 0x0B, 0x52, // "Ä" (U+00C4)
  0x00, 0xC5, 0xFF, 0x01, 0x05, 0x0D, 0x05, 0x0B, 0x77, // "Å" (U+00C5)
  0x00, 0xC6, 0xFF, 0x01, 0x07, 0x09, 0x08, 0x0B, 0xA2, // "Æ" (U+00C6)
  0x00, 0xC7, 0x00, 0xFE, 0x05, 0x09, 0x05, 0x0B, 0xC8, // "Ç" (U+00C7)
  0x00, 0xC8, 0x00, 0x01, 0x05, 0x0C, 0x05, 0x0B, 0xE8, // "È" (U+00C8)
  0x00, 0xC9, 0x00, 0x01, 0x05, 0x0C, 0x05, 0x0C, 0x06, // "É" (U+00C9)
  0x00, 0xCA, 0x00, 0x01, 0x05, 0x0C, 0x05, 0x0C, 0x24, // "Ê" (U+00CA)
  0x00, 0xCB, 0x00, 0x01, 0x05, 0x0B, 0x05, 0x0C, 0x43, // "Ë" (U+00CB)
  0x00, 0xCC, 0xBF, 0x01, 0x03, 0x0C, 0x03, 0x0C, 0x5F, // "Ì" (U+00CC)
  0x00, 0xCD, 0xFF, 0x01, 0x04, 0x0C, 0x03, 0x0C, 0x7D, // "Í" (U+00CD)
  0x00, 0xCE, 0xFF, 0x01, 0x04, 0x0C, 0x03, 0x0C, 0x9B, // "Î" (U+00CE)
  0x00, 0xCF, 0xFF, 0x01, 0x04, 0x0B, 0x03, 0x0C, 0xBA, // "Ï" (U+00CF)
  0x00, 0xD0, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0C, 0xD7, // "Ð" (U+00D0)
  0x00, 0xD1, 0x40, 0x01, 0x06, 0x0C, 0x07, 0x0C, 0xF2, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x0D, 0x1C, // "Ò" (U+00D2)
  0x00, 0xD3, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x0D, 0x43, // "Ó" (U+00D3)
  0x00, 0xD4, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x0D, 0x6A, // "Ô" (U+00D4)
  0x00, 0xD5, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x0D, 0x92, // "Õ" (U+00D5)
  0x00, 0xD6, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x0D, 0xBB, // "Ö" (U+00D6)
  0x00, 0xD7, 0x40, 0x03, 0x05, 0x07, 0x06, 0x0D, 0xE1, // "×" (U+00D7)
  0x00, 0xD8, 0x00, 0x00, 0x06, 0x0A, 0x07, 0x0D, 0xF0, // "Ø" (U+00D8)
  0x00, 0xD9, 0x00, 0x01, 0x06, 0x0C, 0x06, 0x0E, 0x13, // "Ù" (U+00D9)
  0x00, 0xDA, 0x00, 0x01, 0x06, 0x0C, 0x06, 0x0E, 0x3C, // "Ú" (U+00DA)
  0x00, 0xDB, 0x40, 0x01, 0x06, 0x0C, 0x06, 0x0E, 0x65, // "Û" (U+00DB)
  0x00, 0xDC, 0x40, 0x01, 0x06, 0x0B, 0x06, 0x0E, 0x8F, // "Ü" (U+00DC)
  0x00, 0xDD, 0x41, 0x01, 0x05, 0x0C, 0x05, 0x0E, 0xB6, // "Ý" (U+00DD)
  0x00, 0xDE, 0x40, 0x01, 0x05, 0x09, 0x05, 0x0E, 0xD4, // "Þ" (U+00DE)
  0x00, 0xDF, 0xFE, 0xFE, 0x05, 0x0A, 0x06, 0x0E, 0xEF, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x0F, 0x1D, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x0F, 0x3A, // "á" (U+00E1)
  0x00, 0xE2, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x0F, 0x57, // "â" (U+00E2)
  0x00, 0xE3, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x0F, 0x75, // "ã" (U+00E3)
  0x00, 0xE4, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0F, 0x93, // "ä" (U+00E4)
  0x00, 0xE5, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x0F, 0xAE, // "å" (U+00E5)
  0x00, 0xE6, 0x40, 0x01, 0x07, 0x07, 0x08, 0x0F, 0xCF, // "æ" (U+00E6)
  0x00, 0xE7, 0x00, 0xFE, 0x04, 0x07, 0x04, 0x0F, 0xEB, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x10, 0x03, // "è" (U+00E8)
  0x00, 0xE9, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x10, 0x1B, // "é" (U+00E9)
  0x00, 0xEA, 0x40, 0x01, 0x04, 0x0A, 0x05, 0x10, 0x33, // "ê" (U+00EA)
  0x00, 0xEB, 0x40, 0x01, 0x05, 0x09, 0x05, 0x10, 0x4C, // "ë" (U+00EB)
  0x00, 0xEC, 0x40, 0x01, 0x02, 0x0A, 0x03, 0x10, 0x67, // "ì" (U+00EC)
  0x00, 0xED, 0x40, 0x01, 0x03, 0x0A, 0x03, 0x10, 0x76, // "í" (U+00ED)
  0x00, 0xEE, 0x40, 0x01, 0x03, 0x0A, 0x03, 0x10, 0x8A, // "î" (U+00EE)
  0x00, 0xEF, 0x00, 0x01, 0x04, 0x09, 0x03, 0x10, 0x9E, // "ï" (U+00EF)
  0x00, 0xF0, 0x40, 0x01, 0x05, 0x0A, 0x05, 0x10, 0xB3, // "ð" (U+00F0)
  0x00, 0xF1, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x10, 0xD1, // "ñ" (U+00F1)
  0x00, 0xF2, 0x40, 0x01, 0x04, 0x0A, 0x05, 0x10, 0xEF, // "ò" (U+00F2)
  0x00, 0xF3, 0x40, 0x01, 0x04, 0x0A, 0x05, 0x11, 0x08, // "ó" (U+00F3)
  0x00, 0xF4, 0x40, 0x01, 0x04, 0x0A, 0x05, 0x11, 0x21, // "ô" (U+00F4)
  0x00, 0xF5, 0x40, 0x01, 0x04, 0x0A, 0x05, 0x11, 0x3A, // "õ" (U+00F5)
  0x00, 0xF6, 0x40, 0x01, 0x05, 0x09, 0x05, 0x11, 0x53, // "ö" (U+00F6)
  0x00, 0xF7, 0x00, 0x02, 0x05, 0x07, 0x06, 0x11, 0x6E, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x00, 0x05, 0x08, 0x05, 0x11, 0x7D, // "ø" (U+00F8)
  0x00, 0xF9, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x11, 0x96, // "ù" (U+00F9)
  0x00, 0xFA, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x11, 0xB3, // "ú" (U+00FA)
  0x00, 0xFB, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x11, 0xD0, // "û" (U+00FB)
  0x00, 0xFC, 0x40, 0x01, 0x05, 0x09, 0x06, 0x11, 0xEE, // "ü" (U+00FC)
  0x00, 0xFD, 0xFE, 0xFE, 0x04, 0x0A, 0x05, 0x12, 0x09, // "ý" (U+00FD)
  0x00, 0xFE, 0xFF, 0xFE, 0x05, 0x0A, 0x06, 0x12, 0x2F, // "þ" (U+00FE)
  0x00, 0xFF, 0xFE, 0xFE, 0x04, 0x09, 0x05, 0x12, 0x57, // "ÿ" (U+00FF)
  0x01, 0x00, 0xFF, 0x01, 0x05, 0x0B, 0x05, 0x12, 0x7B, // "Ā" (U+0100)
  0x01, 0x01, 0x40, 0x01, 0x05, 0x09, 0x06, 0x12, 0xA0, // "ā" (U+0101)
  0x01, 0x02, 0xFF, 0x01, 0x05, 0x0C, 0x05, 0x12, 0xBB, // "Ă" (U+0102)
  0x01, 0x03, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x12, 0xE3, // "ă" (U+0103)
  0x01, 0x04, 0xBF, 0xFE, 0x04, 0x09, 0x05, 0x13, 0x01, // "Ą" (U+0104)
  0x01, 0x05, 0x40, 0xFE, 0x05, 0x07, 0x06, 0x13, 0x25, // "ą" (U+0105)
  0x01, 0x06, 0x00, 0x01, 0x05, 0x0C, 0x05, 0x13, 0x43, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x01, 0x04, 0x0A, 0x04, 0x13, 0x61, // "ć" (U+0107)
  0x01, 0x08, 0x00, 0x01, 0x06, 0x0C, 0x05, 0x13, 0x78, // "Ĉ" (U+0108)
  0x01, 0x09, 0x00, 0x01, 0x04, 0x0A, 0x04, 0x13, 0x99, // "ĉ" (U+0109)
  0x01, 0x0A, 0x00, 0x01, 0x05, 0x0B, 0x05, 0x13, 0xB1, // "Ċ" (U+010A)
  0x01, 0x0B, 0x00, 0x01, 0x04, 0x09, 0x04, 0x13, 0xCD, // "ċ" (U+010B)
  0x01, 0x0C, 0x00, 0x01, 0x06, 0x0C, 0x05, 0x13, 0xE2, // "Č" (U+010C)
  0x01, 0x0D, 0x00, 0x01, 0x04, 0x0A, 0x04, 0x14, 0x03, // "č" (U+010D)
  0x01, 0x0E, 0x40, 0x01, 0x05, 0x0C, 0x06, 0x14, 0x1B, // "Ď" (U+010E)
  0x01, 0x0F, 0x00, 0x01, 0x07, 0x0A, 0x06, 0x14, 0x3F, // "ď" (U+010F)
  0x01, 0x10, 0x40, 0x01, 0x05, 0x09, 0x06, 0x14, 0x65, // "Đ" (U+0110)
  0x01, 0x11, 0x40, 0x01, 0x06, 0x0A, 0x06, 0x14, 0x80, // "đ" (U+0111)
  0x01, 0x12, 0x00, 0x01, 0x05, 0x0B, 0x05, 0x14, 0xA3, // "Ē" (U+0112)
  0x01, 0x13, 0x40, 0x01, 0x05, 0x09, 0x05, 0x14, 0xBF, // "ē" (U+0113)
  0x01, 0x14, 0x00, 0x01, 0x05, 0x0C, 0x05, 0x14, 0xDA, // "Ĕ" (U+0114)
  0x01, 0x15, 0x40, 0x01, 0x05, 0x0A, 0x05, 0x14, 0xFA, // "ĕ" (U+0115)
  0x01, 0x16, 0x00, 0x01, 0x05, 0x0B, 0x05, 0x15, 0x18, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x01, 0x04, 0x09, 0x05, 0x15, 0x34, // "ė" (U+0117)
  0x01, 0x18, 0x00, 0xFE, 0x05, 0x09, 0x05, 0x15, 0x4A, // "Ę" (U+0118)
  0x01, 0x19, 0x40, 0xFE, 0x04, 0x07, 0x05, 0x15, 0x6B, // "ę" (U+0119)
  0x01, 0x1A, 0x00, 0x01, 0x05, 0x0C, 0x05, 0x15, 0x84, // "Ě" (U+011A)
  0x01, 0x1B, 0x40, 0x01, 0x04, 0x0A, 0x05, 0x15, 0xA3, // "ě" (U+011B)
  0x01, 0x1C, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x15, 0xBC, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x40, 0xFE, 0x05, 0x0A, 0x06, 0x15, 0xE4, // "ĝ" (U+011D)
  0x01, 0x1E, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x16, 0x0B, // "Ğ" (U+011E)
  0x01, 0x1F, 0x40, 0xFE, 0x05, 0x0A, 0x06, 0x16, 0x34, // "ğ" (U+011F)
  0x01, 0x20, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x16, 0x5B, // "Ġ" (U+0120)
  0x01, 0x21, 0x00, 0xFE, 0x05, 0x09, 0x06, 0x16, 0x7F, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0xFE, 0x06, 0x09, 0x07, 0x16, 0xA2, // "Ģ" (U+0122)
  0x01, 0x23, 0x40, 0xFE, 0x05, 0x0A, 0x06, 0x16, 0xC7, // "ģ" (U+0123)
  0x01, 0x24, 0x40, 0x01, 0x06, 0x0C, 0x07, 0x16, 0xEE, // "Ĥ" (U+0124)
  0x01, 0x25, 0x00, 0x01, 0x05, 0x0D, 0x06, 0x17, 0x18, // "ĥ" (U+0125)
  0x01, 0x26, 0x40, 0x01, 0x07, 0x09, 0x06, 0x17, 0x3E, // "Ħ" (U+0126)
  0x01, 0x27, 0x40, 0x01, 0x04, 0x0A, 0x06, 0x17, 0x62, // "ħ" (U+0127)
  0x01, 0x28, 0xFF, 0x01, 0x04, 0x0C, 0x03, 0x17, 0x7B, // "Ĩ" (U+0128)
  0x01, 0x29, 0x40, 0x01, 0x03, 0x0A, 0x03, 0x17, 0x9B, // "ĩ" (U+0129)
  0x01, 0x2A, 0xFF, 0x01, 0x04, 0x0B, 0x03, 0x17, 0xAF, // "Ī" (U+012A)
  0x01, 0x2B, 0x40, 0x01, 0x03, 0x09, 0x03, 0x17, 0xCC, // "ī" (U+012B)
  0x01, 0x2C, 0xFF, 0x01, 0x04, 0x0C, 0x03, 0x17, 0xDE, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x40, 0x01, 0x03, 0x0A, 0x03, 0x17, 0xFE, // "ĭ" (U+012D)
  0x01, 0x2E, 0xBF, 0xFE, 0x03, 0x09, 0x03, 0x18, 0x12, // "Į" (U+012E)
  0x01, 0x2F, 0xBF, 0xFE, 0x02, 0x0A, 0x03, 0x18, 0x30, // "į" (U+012F)
  0x01, 0x30, 0xFF, 0x01, 0x03, 0x0B, 0x03, 0x18, 0x4A, // "İ" (U+0130)
  0x01, 0x31, 0x40, 0x01, 0x02, 0x07, 0x03, 0x18, 0x65, // "ı" (U+0131)
  0x01, 0x32, 0xBF, 0xFE, 0x05, 0x09, 0x06, 0x18, 0x70, // "Ĳ" (U+0132)
  0x01, 0x33, 0x00, 0xFE, 0x05, 0x0A, 0x05, 0x18, 0x9A, // "ĳ" (U+0133)
  0x01, 0x34, 0xFE, 0xFE, 0x04, 0x0C, 0x03, 0x18, 0xBD, // "Ĵ" (U+0134)
  0x01, 0x35, 0xFE, 0xFE, 0x03, 0x0A, 0x03, 0x18, 0xE2, // "ĵ" (U+0135)
  0x01, 0x36, 0x00, 0xFE, 0x06, 0x09, 0x05, 0x19, 0x01, // "Ķ" (U+0136)
  0x01, 0x37, 0x00, 0xFE, 0x04, 0x0A, 0x05, 0x19, 0x27, // "ķ" (U+0137)
  0x01, 0x38, 0x40, 0x01, 0x04, 0x07, 0x05, 0x19, 0x44, // "ĸ" (U+0138)
  0x01, 0x39, 0x00, 0x01, 0x04, 0x0C, 0x05, 0x19, 0x56, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x00, 0x01, 0x04, 0x0D, 0x03, 0x19, 0x72, // "ĺ" (U+013A)
  0x01, 0x3B, 0x40, 0xFE, 0x03, 0x09, 0x05, 0x19, 0x8F, // "Ļ" (U+013B)
  0x01, 0x3C, 0xBF, 0xFE, 0x02, 0x0A, 0x03, 0x19, 0xA7, // "ļ" (U+013C)
  0x01, 0x3D, 0x00, 0x01, 0x05, 0x09, 0x05, 0x19, 0xC1, // "Ľ" (U+013D)
  0x01, 0x3E, 0x40, 0x01, 0x04, 0x0A, 0x03, 0x19, 0xDA, // "ľ" (U+013E)
  0x01, 0x3F, 0x40, 0x01, 0x04, 0x09, 0x05, 0x19, 0xF3, // "Ŀ" (U+013F)
  0x01, 0x40, 0x40, 0x01, 0x03, 0x0A, 0x03, 0x1A, 0x0A, // "ŀ" (U+0140)
  0x01, 0x41, 0x40, 0x01, 0x03, 0x09, 0x05, 0x1A, 0x1E, // "Ł" (U+0141)
  0x01, 0x42, 0x40, 0x01, 0x03, 0x0A, 0x03, 0x1A, 0x30, // "ł" (U+0142)
  0x01, 0x43, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x1A, 0x44, // "Ń" (U+0143)
  0x01, 0x44, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x1A, 0x6C, // "ń" (U+0144)
  0x01, 0x45, 0x00, 0xFE, 0x06, 0x09, 0x07, 0x1A, 0x89, // "Ņ" (U+0145)
  0x01, 0x46, 0x00, 0xFE, 0x05, 0x07, 0x06, 0x1A, 0xAF, // "ņ" (U+0146)
  0x01, 0x47, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x1A, 0xCA, // "Ň" (U+0147)
  0x01, 0x48, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x1A, 0xF3, // "ň" (U+0148)
  0x01, 0x49, 0x40, 0x01, 0x06, 0x09, 0x06, 0x1B, 0x11, // "ŉ" (U+0149)
  0x01, 0x4A, 0x40, 0xFF, 0x06, 0x09, 0x07, 0x1B, 0x31, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x40, 0xFE, 0x05, 0x07, 0x06, 0x1B, 0x58, // "ŋ" (U+014B)
  0x01, 0x4C, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x1B, 0x76, // "Ō" (U+014C)
  0x01, 0x4D, 0x40, 0x01, 0x05, 0x09, 0x05, 0x1B, 0x9C, // "ō" (U+014D)
  0x01, 0x4E, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x1B, 0xB7, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x40, 0x01, 0x05, 0x0A, 0x05, 0x1B, 0xE0, // "ŏ" (U+014F)
  0x01, 0x50, 0x00, 0x01, 0x07, 0x0C, 0x07, 0x1B, 0xFE, // "Ő" (U+0150)
  0x01, 0x51, 0x40, 0x01, 0x06, 0x0A, 0x05, 0x1C, 0x2B, // "ő" (U+0151)
  0x01, 0x52, 0x00, 0x01, 0x08, 0x09, 0x08, 0x1C, 0x4E, // "Œ" (U+0152)
  0x01, 0x53, 0x40, 0x01, 0x08, 0x07, 0x08, 0x1C, 0x75, // "œ" (U+0153)
  0x01, 0x54, 0x00, 0x01, 0x05, 0x0C, 0x06, 0x1C, 0x95, // "Ŕ" (U+0154)
  0x01, 0x55, 0x00, 0x01, 0x04, 0x0A, 0x04, 0x1C, 0xB8, // "ŕ" (U+0155)
  0x01, 0x56, 0x00, 0xFE, 0x05, 0x09, 0x06, 0x1C, 0xCE, // "Ŗ" (U+0156)
  0x01, 0x57, 0x00, 0xFE, 0x04, 0x07, 0x04, 0x1C, 0xF0, // "ŗ" (U+0157)
  0x01, 0x58, 0x40, 0x01, 0x05, 0x0C, 0x06, 0x1D, 0x05, // "Ř" (U+0158)
  0x01, 0x59, 0x00, 0x01, 0x04, 0x0A, 0x04, 0x1D, 0x29, // "ř" (U+0159)
  0x01, 0x5A, 0xFF, 0x01, 0x05, 0x0C, 0x05, 0x1D, 0x40, // "Ś" (U+015A)
  0x01, 0x5B, 0x00, 0x01, 0x04, 0x0A, 0x04, 0x1D, 0x63, // "ś" (U+015B)
  0x01, 0x5C, 0xFF, 0x01, 0x05, 0x0C, 0x05, 0x1D, 0x7B, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x40, 0x01, 0x04, 0x0A, 0x04, 0x1D, 0x9F, // "ŝ" (U+015D)
  0x01, 0x5E, 0xFF, 0xFE, 0x05, 0x09, 0x05, 0x1D, 0xB8, // "Ş" (U+015E)
  0x01, 0x5F, 0x40, 0xFE, 0x04, 0x07, 0x04, 0x1D, 0xDC, // "ş" (U+015F)
  0x01, 0x60, 0xFF, 0x01, 0x05, 0x0C, 0x05, 0x1D, 0xF5, // "Š" (U+0160)
  0x01, 0x61, 0x40, 0x01, 0x04, 0x0A, 0x04, 0x1E, 0x19, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFE, 0x05, 0x09, 0x05, 0x1E, 0x32, // "Ţ" (U+0162)
  0x01, 0x63, 0x40, 0xFE, 0x03, 0x09, 0x03, 0x1E, 0x51, // "ţ" (U+0163)
  0x01, 0x64, 0x01, 0x01, 0x05, 0x0C, 0x05, 0x1E, 0x69, // "Ť" (U+0164)
  0x01, 0x65, 0x40, 0x01, 0x04, 0x0A, 0x03, 0x1E, 0x86, // "ť" (U+0165)
  0x01, 0x66, 0x00, 0x01, 0x05, 0x09, 0x05, 0x1E, 0x9F, // "Ŧ" (U+0166)
  0x01, 0x67, 0x40, 0x01, 0x03, 0x09, 0x03, 0x1E, 0xB9, // "ŧ" (U+0167)
  0x01, 0x68, 0x40, 0x01, 0x06, 0x0C, 0x06, 0x1E, 0xCB, // "Ũ" (U+0168)
  0x01, 0x69, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x1E, 0xF5, // "ũ" (U+0169)
  0x01, 0x6A, 0x40, 0x01, 0x06, 0x0B, 0x06, 0x1F, 0x13, // "Ū" (U+016A)
  0x01, 0x6B, 0x40, 0x01, 0x05, 0x09, 0x06, 0x1F, 0x3A, // "ū" (U+016B)
  0x01, 0x6C, 0x40, 0x01, 0x06, 0x0C, 0x06, 0x1F, 0x55, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x1F, 0x7F, // "ŭ" (U+016D)
  0x01, 0x6E, 0x00, 0x01, 0x06, 0x0D, 0x06, 0x1F, 0x9D, // "Ů" (U+016E)
  0x01, 0x6F, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x1F, 0xCA, // "ů" (U+016F)
  0x01, 0x70, 0x40, 0x01, 0x07, 0x0C, 0x06, 0x1F, 0xEB, // "Ű" (U+0170)
  0x01, 0x71, 0x40, 0x01, 0x06, 0x0A, 0x06, 0x20, 0x1B, // "ű" (U+0171)
  0x01, 0x72, 0x40, 0xFE, 0x06, 0x09, 0x06, 0x20, 0x3E, // "Ų" (U+0172)
  0x01, 0x73, 0x40, 0xFE, 0x05, 0x07, 0x06, 0x20, 0x68, // "ų" (U+0173)
  0x01, 0x74, 0x01, 0x01, 0x09, 0x0C, 0x09, 0x20, 0x86, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x07, 0x0A, 0x07, 0x20, 0xB8, // "ŵ" (U+0175)
  0x01, 0x76, 0x41, 0x01, 0x05, 0x0C, 0x05, 0x20, 0xDD, // "Ŷ" (U+0176)
  0x01, 0x77, 0xFE, 0xFE, 0x04, 0x0A, 0x05, 0x20, 0xFB, // "ŷ" (U+0177)
  0x01, 0x78, 0x41, 0x01, 0x05, 0x0B, 0x05, 0x21, 0x22, // "Ÿ" (U+0178)
  0x01, 0x79, 0xFF, 0x01, 0x05, 0x0C, 0x05, 0x21, 0x3E, // "Ź" (U+0179)
  0x01, 0x7A, 0xFF, 0x01, 0x04, 0x0A, 0x04, 0x21, 0x5E, // "ź" (U+017A)
  0x01, 0x7B, 0xFF, 0x01, 0x05, 0x0B, 0x05, 0x21, 0x78, // "Ż" (U+017B)
  0x01, 0x7C, 0xFF, 0x01, 0x04, 0x09, 0x04, 0x21, 0x96, // "ż" (U+017C)
  0x01, 0x7D, 0xFF, 0x01, 0x05, 0x0C, 0x05, 0x21, 0xAE, // "Ž" (U+017D)
  0x01, 0x7E, 0xFF, 0x01, 0x04, 0x0A, 0x04, 0x21, 0xCF, // "ž" (U+017E)
  0x01, 0x7F, 0xFE, 0xFE, 0x04, 0x0A, 0x03, 0x21, 0xEA, // "ſ" (U+017F)
  0x03, 0xA9, 0xBF, 0x01, 0x06, 0x09, 0x07, 0x22, 0x0A, // "Ω" (U+03A9)
  0x03, 0xBC, 0xFF, 0xFE, 0x05, 0x07, 0x06, 0x22, 0x2E, // "μ" (U+03BC)
  0x03, 0xC0, 0x40, 0x01, 0x05, 0x07, 0x06, 0x22, 0x50, // "π" (U+03C0)
  0x20, 0x13, 0x40, 0x04, 0x05, 0x04, 0x06, 0x22, 0x65, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x04, 0x0A, 0x04, 0x0B, 0x22, 0x68, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x01, 0x05, 0x09, 0x05, 0x22, 0x6C, // "€" (U+20AC)
  0x20, 0xBF, 0x40, 0x00, 0x05, 0x0B, 0x05, 0x22, 0x86, // "₿" (U+20BF)
  0x20, 0x18, 0x40, 0x07, 0x02, 0x09, 0x02, 0x22, 0xAA, // "‘" (U+2018)
  0x20, 0x19, 0x40, 0x07, 0x02, 0x09, 0x02, 0x22, 0xAF, // "’" (U+2019)
  0x20, 0x1A, 0xBF, 0xFF, 0x01, 0x01, 0x03, 0x22, 0xB4, // "‚" (U+201A)
  0x20, 0x1B, 0x41, 0x07, 0x02, 0x09, 0x02, 0x22, 0xB9, // "‛" (U+201B)
  0x20, 0x1C, 0x40, 0x07, 0x04, 0x09, 0x04, 0x22, 0xBC, // "“" (U+201C)
  0x20, 0x1D, 0x40, 0x07, 0x04, 0x09, 0x04, 0x22, 0xC4, // "”" (U+201D)
  0x20, 0x1E, 0xBF, 0xFF, 0x03, 0x01, 0x04, 0x22, 0xCC, // "„" (U+201E)
  0x20, 0x1F, 0x41, 0x07, 0x04, 0x09, 0x04, 0x22, 0xD4, // "‟" (U+201F)
  0x20, 0x20, 0x41, 0x01, 0x04, 0x0A, 0x05, 0x22, 0xDA, // "†" (U+2020)
  0x20, 0x21, 0x00, 0x01, 0x05, 0x0A, 0x05, 0x22, 0xEE, // "‡" (U+2021)
  0x20, 0x22, 0x41, 0x04, 0x03, 0x06, 0x04, 0x23, 0x0B, // "•" (U+2022)
  0x20, 0x26, 0x40, 0x01, 0x06, 0x02, 0x08, 0x23, 0x10, // "…" (U+2026)
  0x20, 0x30, 0x40, 0x01, 0x0A, 0x09, 0x0B, 0x23, 0x17, // "‰" (U+2030)
  0x20, 0x39, 0x40, 0x01, 0x02, 0x06, 0x03, 0x23, 0x49, // "‹" (U+2039)
  0x20, 0x3A, 0x40, 0x01, 0x02, 0x06, 0x03, 0x23, 0x52, // "›" (U+203A)
  0x20, 0x44, 0xFD, 0x01, 0x04, 0x09, 0x01, 0x23, 0x5B, // "⁄" (U+2044)
  0x21, 0x22, 0x40, 0x05, 0x07, 0x09, 0x08, 0x23, 0x72, // "™" (U+2122)
  0x21, 0x52, 0x01, 0x01, 0x0B, 0x09, 0x0B, 0x23, 0x86, // "⅒" (U+2152)
  0xFB, 0x01, 0xFE, 0xFE, 0x05, 0x0A, 0x06, 0x23, 0xB7, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0xFE, 0xFE, 0x05, 0x0A, 0x06, 0x23, 0xE3, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x01, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0x63, 0x01, // "c (U+0022 U+0063)
  0x00, 0x22, 0x00, 0x64, 0x01, // "d (U+0022 U+0064)
  0x00, 0x22, 0x00, 0x65, 0x01, // "e (U+0022 U+0065)
  0x00, 0x22, 0x00, 0x6F, 0x01, // "o (U+0022 U+006F)
  0x00, 0x22, 0x00, 0x71, 0x01, // "q (U+0022 U+0071)
  0x00, 0x22, 0x00, 0xC0, 0x01, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x01, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x01, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x01, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x01, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x01, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xE0, 0x01, // "à (U+0022 U+00E0)
  0x00, 0x22, 0x00, 0xE7, 0x01, // "ç (U+0022 U+00E7)
  0x00, 0x22, 0x00, 0xE8, 0x01, // "è (U+0022 U+00E8)
  0x00, 0x22, 0x00, 0xE9, 0x01, // "é (U+0022 U+00E9)
  0x00, 0x22, 0x00, 0xEA, 0x01, // "ê (U+0022 U+00EA)
  0x00, 0x22, 0x00, 0xEB, 0x01, // "ë (U+0022 U+00EB)
  0x00, 0x22, 0x00, 0xF2, 0x01, // "ò (U+0022 U+00F2)
  0x00, 0x22, 0x00, 0xF3, 0x01, // "ó (U+0022 U+00F3)
  0x00, 0x22, 0x00, 0xF4, 0x01, // "ô (U+0022 U+00F4)
  0x00, 0x22, 0x00, 0xF5, 0x01, // "õ (U+0022 U+00F5)
  0x00, 0x22, 0x00, 0xF6, 0x01, // "ö (U+0022 U+00F6)
  0x00, 0x22, 0x00, 0xF8, 0x01, // "ø (U+0022 U+00F8)
  0x00, 0x22, 0x01, 0x00, 0x01, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x02, 0x01, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x04, 0x01, // "Ą (U+0022 U+0104)
  0x00, 0x22, 0x01, 0x07, 0x01, // "ć (U+0022 U+0107)
  0x00, 0x22, 0x01, 0x09, 0x01, // "ĉ (U+0022 U+0109)
  0x00, 0x22, 0x01, 0x0B, 0x01, // "ċ (U+0022 U+010B)
  0x00, 0x22, 0x01, 0x0D, 0x01, // "č (U+0022 U+010D)
  0x00, 0x22, 0x01, 0x0F, 0x01, // "ď (U+0022 U+010F)
  0x00, 0x22, 0x01, 0x11, 0x01, // "đ (U+0022 U+0111)
  0x00, 0x22, 0x01, 0x13, 0x01, // "ē (U+0022 U+0113)
  0x00, 0x22, 0x01, 0x15, 0x01, // "ĕ (U+0022 U+0115)
  0x00, 0x22, 0x01, 0x17, 0x01, // "ė (U+0022 U+0117)
  0x00, 0x22, 0x01, 0x19, 0x01, // "ę (U+0022 U+0119)
  0x00, 0x22, 0x01, 0x1B, 0x01, // "ě (U+0022 U+011B)
  0x00, 0x22, 0x01, 0x4D, 0x01, // "ō (U+0022 U+014D)
  0x00, 0x22, 0x01, 0x4F, 0x01, // "ŏ (U+0022 U+014F)
  0x00, 0x22, 0x01, 0x51, 0x01, // "ő (U+0022 U+0151)
  0x00, 0x22, 0x01, 0x53, 0x01, // "œ (U+0022 U+0153)
  0x00, 0x26, 0x00, 0x59, 0x01, // &Y (U+0026 U+0059)
  0x00, 0x26, 0x00, 0xDD, 0x01, // &Ý (U+0026 U+00DD)
  0x00, 0x26, 0x01, 0x76, 0x01, // &Ŷ (U+0026 U+0176)
  0x00, 0x26, 0x01, 0x78, 0x01, // &Ÿ (U+0026 U+0178)
  0x00, 0x27, 0x00, 0x41, 0x01, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0x63, 0x01, // 'c (U+0027 U+0063)
  0x00, 0x27, 0x00, 0x64, 0x01, // 'd (U+0027 U+0064)
  0x00, 0x27, 0x00, 0x65, 0x01, // 'e (U+0027 U+0065)
  0x00, 0x27, 0x00, 0x6F, 0x01, // 'o (U+0027 U+006F)
  0x00, 0x27, 0x00, 0x71, 0x01, // 'q (U+0027 U+0071)
  0x00, 0x27, 0x00, 0xC0, 0x01, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x01, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x01, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x01, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x01, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x01, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xE0, 0x01, // 'à (U+0027 U+00E0)
  0x00, 0x27, 0x00, 0xE7, 0x01, // 'ç (U+0027 U+00E7)
  0x00, 0x27, 0x00, 0xE8, 0x01, // 'è (U+0027 U+00E8)
  0x00, 0x27, 0x00, 0xE9, 0x01, // 'é (U+0027 U+00E9)
  0x00, 0x27, 0x00, 0xEA, 0x01, // 'ê (U+0027 U+00EA)
  0x00, 0x27, 0x00, 0xEB, 0x01, // 'ë (U+0027 U+00EB)
  0x00, 0x27, 0x00, 0xF2, 0x01, // 'ò (U+0027 U+00F2)
  0x00, 0x27, 0x00, 0xF3, 0x01, // 'ó (U+0027 U+00F3)
  0x00, 0x27, 0x00, 0xF4, 0x01, // 'ô (U+0027 U+00F4)
  0x00, 0x27, 0x00, 0xF5, 0x01, // 'õ (U+0027 U+00F5)
  0x00, 0x27, 0x00, 0xF6, 0x01, // 'ö (U+0027 U+00F6)
  0x00, 0x27, 0x00, 0xF8, 0x01, // 'ø (U+0027 U+00F8)
  0x00, 0x27, 0x01, 0x00, 0x01, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x02, 0x01, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x04, 0x01, // 'Ą (U+0027 U+0104)
  0x00, 0x27, 0x01, 0x07, 0x01, // 'ć (U+0027 U+0107)
  0x00, 0x27, 0x01, 0x09, 0x01, // 'ĉ (U+0027 U+0109)
  0x00, 0x27, 0x01, 0x0B, 0x01, // 'ċ (U+0027 U+010B)
  0x00, 0x27, 0x01, 0x0D, 0x01, // 'č (U+0027 U+010D)
  0x00, 0x27, 0x01, 0x0F, 0x01, // 'ď (U+0027 U+010F)
  0x00, 0x27, 0x01, 0x11, 0x01, // 'đ (U+0027 U+0111)
  0x00, 0x27, 0x01, 0x13, 0x01, // 'ē (U+0027 U+0113)
  0x00, 0x27, 0x01, 0x15, 0x01, // 'ĕ (U+0027 U+0115)
  0x00, 0x27, 0x01, 0x17, 0x01, // 'ė (U+0027 U+0117)
  0x00, 0x27, 0x01, 0x19, 0x01, // 'ę (U+0027 U+0119)
  0x00, 0x27, 0x01, 0x1B, 0x01, // 'ě (U+0027 U+011B)
  0x00, 0x27, 0x01, 0x4D, 0x01, // 'ō (U+0027 U+014D)
  0x00, 0x27, 0x01, 0x4F, 0x01, // 'ŏ (U+0027 U+014F)
  0x00, 0x27, 0x01, 0x51, 0x01, // 'ő (U+0027 U+0151)
  0x00, 0x27, 0x01, 0x53, 0x01, // 'œ (U+0027 U+0153)
  0x00, 0x2C, 0x00, 0x54, 0x01, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x56, 0x01, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x01, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x01, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0xDD, 0x01, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x01, 0x62, 0x01, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x01, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x01, // ,Ŧ (U+002C U+0166)
  0x00, 0x2C, 0x01, 0x74, 0x01, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x76, 0x01, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x78, 0x01, // ,Ÿ (U+002C U+0178)
  0x00, 0x2E, 0x00, 0x54, 0x01, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x56, 0x01, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x01, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x01, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0xDD, 0x01, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x01, 0x62, 0x01, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x01, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x01, // .Ŧ (U+002E U+0166)
  0x00, 0x2E, 0x01, 0x74, 0x01, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x76, 0x01, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x78, 0x01, // .Ÿ (U+002E U+0178)
  0x00, 0x41, 0x00, 0x22, 0x01, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x01, // A' (U+0041 U+0027)
  0x00, 0x41, 0x20, 0x19, 0x01, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1D, 0x01, // A” (U+0041 U+201D)
  0x00, 0x46, 0x00, 0x2C, 0x01, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x01, // F. (U+0046 U+002E)
  0x00, 0x46, 0x20, 0x1A, 0x01, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x01, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x01, // F… (U+0046 U+2026)
  0x00, 0x4C, 0x00, 0x22, 0x01, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x01, // L' (U+004C U+0027)
  0x00, 0x4C, 0x20, 0x19, 0x01, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1D, 0x01, // L” (U+004C U+201D)
  0x00, 0x50, 0x00, 0x2C, 0x02, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x02, // P. (U+0050 U+002E)
  0x00, 0x50, 0x20, 0x1A, 0x02, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x02, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x02, // P… (U+0050 U+2026)
  0x00, 0x54, 0x00, 0x2C, 0x01, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2E, 0x01, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0x61, 0x01, // Ta (U+0054 U+0061)
  0x00, 0x54, 0x00, 0x63, 0x01, // Tc (U+0054 U+0063)
  0x00, 0x54, 0x00, 0x64, 0x01, // Td (U+0054 U+0064)
  0x00, 0x54, 0x00, 0x65, 0x01, // Te (U+0054 U+0065)
  0x00, 0x54, 0x00, 0x67, 0x01, // Tg (U+0054 U+0067)
  0x00, 0x54, 0x00, 0x6D, 0x01, // Tm (U+0054 U+006D)
  0x00, 0x54, 0x00, 0x6E, 0x01, // Tn (U+0054 U+006E)
  0x00, 0x54, 0x00, 0x6F, 0x01, // To (U+0054 U+006F)
  0x00, 0x54, 0x00, 0x70, 0x01, // Tp (U+0054 U+0070)
  0x00, 0x54, 0x00, 0x71, 0x01, // Tq (U+0054 U+0071)
  0x00, 0x54, 0x00, 0x72, 0x01, // Tr (U+0054 U+0072)
  0x00, 0x54, 0x00, 0x73, 0x01, // Ts (U+0054 U+0073)
  0x00, 0x54, 0x00, 0x75, 0x01, // Tu (U+0054 U+0075)
  0x00, 0x54, 0x00, 0xAB, 0x01, // T« (U+0054 U+00AB)
  0x00, 0x54, 0x00, 0xE0, 0x01, // Tà (U+0054 U+00E0)
  0x00, 0x54, 0x00, 0xE1, 0x01, // Tá (U+0054 U+00E1)
  0x00, 0x54, 0x00, 0xE2, 0x01, // Tâ (U+0054 U+00E2)
  0x00, 0x54, 0x00, 0xE3, 0x01, // Tã (U+0054 U+00E3)
  0x00, 0x54, 0x00, 0xE4, 0x01, // Tä (U+0054 U+00E4)
  0x00, 0x54, 0x00, 0xE5, 0x01, // Tå (U+0054 U+00E5)
  0x00, 0x54, 0x00, 0xE6, 0x01, // Tæ (U+0054 U+00E6)
  0x00, 0x54, 0x00, 0xE7, 0x01, // Tç (U+0054 U+00E7)
  0x00, 0x54, 0x00, 0xE8, 0x01, // Tè (U+0054 U+00E8)
  0x00, 0x54, 0x00, 0xE9, 0x01, // Té (U+0054 U+00E9)
  0x00, 0x54, 0x00, 0xEA, 0x01, // Tê (U+0054 U+00EA)
  0x00, 0x54, 0x00, 0xEB, 0x01, // Të (U+0054 U+00EB)
  0x00, 0x54, 0x00, 0xF1, 0x01, // Tñ (U+0054 U+00F1)
  0x00, 0x54, 0x00, 0xF2, 0x01, // Tò (U+0054 U+00F2)
  0x00, 0x54, 0x00, 0xF3, 0x01, // Tó (U+0054 U+00F3)
  0x00, 0x54, 0x00, 0xF4, 0x01, // Tô (U+0054 U+00F4)
  0x00, 0x54, 0x00, 0xF5, 0x01, // Tõ (U+0054 U+00F5)
  0x00, 0x54, 0x00, 0xF6, 0x01, // Tö (U+0054 U+00F6)
  0x00, 0x54, 0x00, 0xF8, 0x01, // Tø (U+0054 U+00F8)
  0x00, 0x54, 0x00, 0xF9, 0x01, // Tù (U+0054 U+00F9)
  0x00, 0x54, 0x00, 0xFA, 0x01, // Tú (U+0054 U+00FA)
  0x00, 0x54, 0x00, 0xFB, 0x01, // Tû (U+0054 U+00FB)
  0x00, 0x54, 0x00, 0xFC, 0x01, // Tü (U+0054 U+00FC)
  0x00, 0x54, 0x01, 0x01, 0x01, // Tā (U+0054 U+0101)
  0x00, 0x54, 0x01, 0x03, 0x01, // Tă (U+0054 U+0103)
  0x00, 0x54, 0x01, 0x05, 0x01, // Tą (U+0054 U+0105)
  0x00, 0x54, 0x01, 0x07, 0x01, // Tć (U+0054 U+0107)
  0x00, 0x54, 0x01, 0x09, 0x01, // Tĉ (U+0054 U+0109)
  0x00, 0x54, 0x01, 0x0B, 0x01, // Tċ (U+0054 U+010B)
  0x00, 0x54, 0x01, 0x0D, 0x01, // Tč (U+0054 U+010D)
  0x00, 0x54, 0x01, 0x0F, 0x01, // Tď (U+0054 U+010F)
  0x00, 0x54, 0x01, 0x11, 0x01, // Tđ (U+0054 U+0111)
  0x00, 0x54, 0x01, 0x13, 0x01, // Tē (U+0054 U+0113)
  0x00, 0x54, 0x01, 0x15, 0x01, // Tĕ (U+0054 U+0115)
  0x00, 0x54, 0x01, 0x17, 0x01, // Tė (U+0054 U+0117)
  0x00, 0x54, 0x01, 0x19, 0x01, // Tę (U+0054 U+0119)
  0x00, 0x54, 0x01, 0x1B, 0x01, // Tě (U+0054 U+011B)
  0x00, 0x54, 0x01, 0x1D, 0x01, // Tĝ (U+0054 U+011D)
  0x00, 0x54, 0x01, 0x1F, 0x01, // Tğ (U+0054 U+011F)
  0x00, 0x54, 0x01, 0x21, 0x01, // Tġ (U+0054 U+0121)
  0x00, 0x54, 0x01, 0x23, 0x01, // Tģ (U+0054 U+0123)
  0x00, 0x54, 0x01, 0x38, 0x01, // Tĸ (U+0054 U+0138)
  0x00, 0x54, 0x01, 0x44, 0x01, // Tń (U+0054 U+0144)
  0x00, 0x54, 0x01, 0x46, 0x01, // Tņ (U+0054 U+0146)
  0x00, 0x54, 0x01, 0x48, 0x01, // Tň (U+0054 U+0148)
  0x00, 0x54, 0x01, 0x4B, 0x01, // Tŋ (U+0054 U+014B)
  0x00, 0x54, 0x01, 0x4D, 0x01, // Tō (U+0054 U+014D)
  0x00, 0x54, 0x01, 0x4F, 0x01, // Tŏ (U+0054 U+014F)
  0x00, 0x54, 0x01, 0x51, 0x01, // Tő (U+0054 U+0151)
  0x00, 0x54, 0x01, 0x53, 0x01, // Tœ (U+0054 U+0153)
  0x00, 0x54, 0x01, 0x55, 0x01, // Tŕ (U+0054 U+0155)
  0x00, 0x54, 0x01, 0x57, 0x01, // Tŗ (U+0054 U+0157)
  0x00, 0x54, 0x01, 0x5B, 0x01, // Tś (U+0054 U+015B)
  0x00, 0x54, 0x01, 0x5D, 0x01, // Tŝ (U+0054 U+015D)
  0x00, 0x54, 0x01, 0x5F, 0x01, // Tş (U+0054 U+015F)
  0x00, 0x54, 0x01, 0x61, 0x01, // Tš (U+0054 U+0161)
  0x00, 0x54, 0x01, 0x69, 0x01, // Tũ (U+0054 U+0169)
  0x00, 0x54, 0x01, 0x6B, 0x01, // Tū (U+0054 U+016B)
  0x00, 0x54, 0x01, 0x6D, 0x01, // Tŭ (U+0054 U+016D)
  0x00, 0x54, 0x01, 0x6F, 0x01, // Tů (U+0054 U+016F)
  0x00, 0x54, 0x01, 0x71, 0x01, // Tű (U+0054 U+0171)
  0x00, 0x54, 0x01, 0x73, 0x01, // Tų (U+0054 U+0173)
  0x00, 0x54, 0x20, 0x1A, 0x01, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x01, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x01, // T… (U+0054 U+2026)
  0x00, 0x54, 0x20, 0x39, 0x01, // T‹ (U+0054 U+2039)
  0x00, 0x56, 0x00, 0x2C, 0x01, // V, (U+0056 U+002C)
  0x00, 0x56, 0x00, 0x2E, 0x01, // V. (U+0056 U+002E)
  0x00, 0x56, 0x20, 0x1A, 0x01, // V‚ (U+0056 U+201A)
  0x00, 0x56, 0x20, 0x1E, 0x01, // V„ (U+0056 U+201E)
  0x00, 0x56, 0x20, 0x26, 0x01, // V… (U+0056 U+2026)
  0x00, 0x57, 0x00, 0x2C, 0x01, // W, (U+0057 U+002C)
  0x00, 0x57, 0x00, 0x2E, 0x01, // W. (U+0057 U+002E)
  0x00, 0x57, 0x20, 0x1A, 0x01, // W‚ (U+0057 U+201A)
  0x00, 0x57, 0x20, 0x1E, 0x01, // W„ (U+0057 U+201E)
  0x00, 0x57, 0x20, 0x26, 0x01, // W… (U+0057 U+2026)
  0x00, 0x59, 0x00, 0x2C, 0x01, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x01, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x20, 0x1A, 0x01, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x01, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x01, // Y… (U+0059 U+2026)
  0x00, 0x72, 0x00, 0x2C, 0x01, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x01, // r. (U+0072 U+002E)
  0x00, 0x72, 0x20, 0x1A, 0x01, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x01, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x01, // r… (U+0072 U+2026)
  0x00, 0xBB, 0x00, 0x54, 0x01, // »T (U+00BB U+0054)
  0x00, 0xBB, 0x01, 0x62, 0x01, // »Ţ (U+00BB U+0162)
  0x00, 0xBB, 0x01, 0x64, 0x01, // »Ť (U+00BB U+0164)
  0x00, 0xBB, 0x01, 0x66, 0x01, // »Ŧ (U+00BB U+0166)
  0x00, 0xC0, 0x00, 0x22, 0x01, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x01, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x20, 0x19, 0x01, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1D, 0x01, // À” (U+00C0 U+201D)
  0x00, 0xC1, 0x00, 0x22, 0x01, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x01, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x20, 0x19, 0x01, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1D, 0x01, // Á” (U+00C1 U+201D)
  0x00, 0xC2, 0x00, 0x22, 0x01, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x01, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x20, 0x19, 0x01, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1D, 0x01, // Â” (U+00C2 U+201D)
  0x00, 0xC3, 0x00, 0x22, 0x01, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x01, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x20, 0x19, 0x01, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1D, 0x01, // Ã” (U+00C3 U+201D)
  0x00, 0xC4, 0x00, 0x22, 0x01, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x01, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x20, 0x19, 0x01, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1D, 0x01, // Ä” (U+00C4 U+201D)
  0x00, 0xC5, 0x00, 0x22, 0x01, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x01, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x20, 0x19, 0x01, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1D, 0x01, // Å” (U+00C5 U+201D)
  0x00, 0xDD, 0x00, 0x2C, 0x01, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x01, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x20, 0x1A, 0x01, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x01, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x01, // Ý… (U+00DD U+2026)
  0x00, 0xDE, 0x00, 0x2C, 0x02, // Þ, (U+00DE U+002C)
  0x00, 0xDE, 0x00, 0x2E, 0x02, // Þ. (U+00DE U+002E)
  0x00, 0xDE, 0x20, 0x1A, 0x02, // Þ‚ (U+00DE U+201A)
  0x00, 0xDE, 0x20, 0x1E, 0x02, // Þ„ (U+00DE U+201E)
  0x00, 0xDE, 0x20, 0x26, 0x02, // Þ… (U+00DE U+2026)
  0x01, 0x00, 0x00, 0x22, 0x01, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x01, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x20, 0x19, 0x01, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1D, 0x01, // Ā” (U+0100 U+201D)
  0x01, 0x02, 0x00, 0x22, 0x01, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x01, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x20, 0x19, 0x01, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1D, 0x01, // Ă” (U+0102 U+201D)
  0x01, 0x04, 0x00, 0x22, 0x01, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x01, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x20, 0x19, 0x01, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1D, 0x01, // Ą” (U+0104 U+201D)
  0x01, 0x39, 0x00, 0x22, 0x01, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x01, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x20, 0x19, 0x01, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1D, 0x01, // Ĺ” (U+0139 U+201D)
  0x01, 0x3B, 0x00, 0x22, 0x01, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x01, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x20, 0x19, 0x01, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1D, 0x01, // Ļ” (U+013B U+201D)
  0x01, 0x3D, 0x00, 0x22, 0x01, // Ľ" (U+013D U+0022)
  0x01, 0x3D, 0x00, 0x27, 0x01, // Ľ' (U+013D U+0027)
  0x01, 0x3D, 0x20, 0x19, 0x01, // Ľ’ (U+013D U+2019)
  0x01, 0x3D, 0x20, 0x1D, 0x01, // Ľ” (U+013D U+201D)
  0x01, 0x3F, 0x00, 0x22, 0x01, // Ŀ" (U+013F U+0022)
  0x01, 0x3F, 0x00, 0x27, 0x01, // Ŀ' (U+013F U+0027)
  0x01, 0x3F, 0x20, 0x19, 0x01, // Ŀ’ (U+013F U+2019)
  0x01, 0x3F, 0x20, 0x1D, 0x01, // Ŀ” (U+013F U+201D)
  0x01, 0x41, 0x00, 0x22, 0x01, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x01, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x20, 0x19, 0x01, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1D, 0x01, // Ł” (U+0141 U+201D)
  0x01, 0x55, 0x00, 0x2C, 0x01, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x01, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x20, 0x1A, 0x01, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x01, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x01, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x01, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x01, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x20, 0x1A, 0x01, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x01, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x01, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x01, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x01, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x20, 0x1A, 0x01, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x01, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x01, // ř… (U+0159 U+2026)
  0x01, 0x62, 0x00, 0x2C, 0x01, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2E, 0x01, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0x61, 0x01, // Ţa (U+0162 U+0061)
  0x01, 0x62, 0x00, 0x63, 0x01, // Ţc (U+0162 U+0063)
  0x01, 0x62, 0x00, 0x64, 0x01, // Ţd (U+0162 U+0064)
  0x01, 0x62, 0x00, 0x65, 0x01, // Ţe (U+0162 U+0065)
  0x01, 0x62, 0x00, 0x67, 0x01, // Ţg (U+0162 U+0067)
  0x01, 0x62, 0x00, 0x6D, 0x01, // Ţm (U+0162 U+006D)
  0x01, 0x62, 0x00, 0x6E, 0x01, // Ţn (U+0162 U+006E)
  0x01, 0x62, 0x00, 0x6F, 0x01, // Ţo (U+0162 U+006F)
  0x01, 0x62, 0x00, 0x70, 0x01, // Ţp (U+0162 U+0070)
  0x01, 0x62, 0x00, 0x71, 0x01, // Ţq (U+0162 U+0071)
  0x01, 0x62, 0x00, 0x72, 0x01, // Ţr (U+0162 U+0072)
  0x01, 0x62, 0x00, 0x73, 0x01, // Ţs (U+0162 U+0073)
  0x01, 0x62, 0x00, 0x75, 0x01, // Ţu (U+0162 U+0075)
  0x01, 0x62, 0x00, 0xAB, 0x01, // Ţ« (U+0162 U+00AB)
  0x01, 0x62, 0x00, 0xE0, 0x01, // Ţà (U+0162 U+00E0)
  0x01, 0x62, 0x00, 0xE1, 0x01, // Ţá (U+0162 U+00E1)
  0x01, 0x62, 0x00, 0xE2, 0x01, // Ţâ (U+0162 U+00E2)
  0x01, 0x62, 0x00, 0xE3, 0x01, // Ţã (U+0162 U+00E3)
  0x01, 0x62, 0x00, 0xE4, 0x01, // Ţä (U+0162 U+00E4)
  0x01, 0x62, 0x00, 0xE5, 0x01, // Ţå (U+0162 U+00E5)
  0x01, 0x62, 0x00, 0xE6, 0x01, // Ţæ (U+0162 U+00E6)
  0x01, 0x62, 0x00, 0xE7, 0x01, // Ţç (U+0162 U+00E7)
  0x01, 0x62, 0x00, 0xE8, 0x01, // Ţè (U+0162 U+00E8)
  0x01, 0x62, 0x00, 0xE9, 0x01, // Ţé (U+0162 U+00E9)
  0x01, 0x62, 0x00, 0xEA, 0x01, // Ţê (U+0162 U+00EA)
  0x01, 0x62, 0x00, 0xEB, 0x01, // Ţë (U+0162 U+00EB)
  0x01, 0x62, 0x00, 0xF1, 0x01, // Ţñ (U+0162 U+00F1)
  0x01, 0x62, 0x00, 0xF2, 0x01, // Ţò (U+0162 U+00F2)
  0x01, 0x62, 0x00, 0xF3, 0x01, // Ţó (U+0162 U+00F3)
  0x01, 0x62, 0x00, 0xF4, 0x01, // Ţô (U+0162 U+00F4)
  0x01, 0x62, 0x00, 0xF5, 0x01, // Ţõ (U+0162 U+00F5)
  0x01, 0x62, 0x00, 0xF6, 0x01, // Ţö (U+0162 U+00F6)
  0x01, 0x62, 0x00, 0xF8, 0x01, // Ţø (U+0162 U+00F8)
  0x01, 0x62, 0x00, 0xF9, 0x01, // Ţù (U+0162 U+00F9)
  0x01, 0x62, 0x00, 0xFA, 0x01, // Ţú (U+0162 U+00FA)
  0x01, 0x62, 0x00, 0xFB, 0x01, // Ţû (U+0162 U+00FB)
  0x01, 0x62, 0x00, 0xFC, 0x01, // Ţü (U+0162 U+00FC)
  0x01, 0x62, 0x01, 0x01, 0x01, // Ţā (U+0162 U+0101)
  0x01, 0x62, 0x01, 0x03, 0x01, // Ţă (U+0162 U+0103)
  0x01, 0x62, 0x01, 0x05, 0x01, // Ţą (U+0162 U+0105)
  0x01, 0x62, 0x01, 0x07, 0x01, // Ţć (U+0162 U+0107)
  0x01, 0x62, 0x01, 0x09, 0x01, // Ţĉ (U+0162 U+0109)
  0x01, 0x62, 0x01, 0x0B, 0x01, // Ţċ (U+0162 U+010B)
  0x01, 0x62, 0x01, 0x0D, 0x01, // Ţč (U+0162 U+010D)
  0x01, 0x62, 0x01, 0x0F, 0x01, // Ţď (U+0162 U+010F)
  0x01, 0x62, 0x01, 0x11, 0x01, // Ţđ (U+0162 U+0111)
  0x01, 0x62, 0x01, 0x13, 0x01, // Ţē (U+0162 U+0113)
  0x01, 0x62, 0x01, 0x15, 0x01, // Ţĕ (U+0162 U+0115)
  0x01, 0x62, 0x01, 0x17, 0x01, // Ţė (U+0162 U+0117)
  0x01, 0x62, 0x01, 0x19, 0x01, // Ţę (U+0162 U+0119)
  0x01, 0x62, 0x01, 0x1B, 0x01, // Ţě (U+0162 U+011B)
  0x01, 0x62, 0x01, 0x1D, 0x01, // Ţĝ (U+0162 U+011D)
  0x01, 0x62, 0x01, 0x1F, 0x01, // Ţğ (U+0162 U+011F)
  0x01, 0x62, 0x01, 0x21, 0x01, // Ţġ (U+0162 U+0121)
  0x01, 0x62, 0x01, 0x23, 0x01, // Ţģ (U+0162 U+0123)
  0x01, 0x62, 0x01, 0x38, 0x01, // Ţĸ (U+0162 U+0138)
  0x01, 0x62, 0x01, 0x44, 0x01, // Ţń (U+0162 U+0144)
  0x01, 0x62, 0x01, 0x46, 0x01, // Ţņ (U+0162 U+0146)
  0x01, 0x62, 0x01, 0x48, 0x01, // Ţň (U+0162 U+0148)
  0x01, 0x62, 0x01, 0x4B, 0x01, // Ţŋ (U+0162 U+014B)
  0x01, 0x62, 0x01, 0x4D, 0x01, // Ţō (U+0162 U+014D)
  0x01, 0x62, 0x01, 0x4F, 0x01, // Ţŏ (U+0162 U+014F)
  0x01, 0x62, 0x01, 0x51, 0x01, // Ţő (U+0162 U+0151)
  0x01, 0x62, 0x01, 0x53, 0x01, // Ţœ (U+0162 U+0153)
  0x01, 0x62, 0x01, 0x55, 0x01, // Ţŕ (U+0162 U+0155)
  0x01, 0x62, 0x01, 0x57, 0x01, // Ţŗ (U+0162 U+0157)
  0x01, 0x62, 0x01, 0x5B, 0x01, // Ţś (U+0162 U+015B)
  0x01, 0x62, 0x01, 0x5D, 0x01, // Ţŝ (U+0162 U+015D)
  0x01, 0x62, 0x01, 0x5F, 0x01, // Ţş (U+0162 U+015F)
  0x01, 0x62, 0x01, 0x61, 0x01, // Ţš (U+0162 U+0161)
  0x01, 0x62, 0x01, 0x69, 0x01, // Ţũ (U+0162 U+0169)
  0x01, 0x62, 0x01, 0x6B, 0x01, // Ţū (U+0162 U+016B)
  0x01, 0x62, 0x01, 0x6D, 0x01, // Ţŭ (U+0162 U+016D)
  0x01, 0x62, 0x01, 0x6F, 0x01, // Ţů (U+0162 U+016F)
  0x01, 0x62, 0x01, 0x71, 0x01, // Ţű (U+0162 U+0171)
  0x01, 0x62, 0x01, 0x73, 0x01, // Ţų (U+0162 U+0173)
  0x01, 0x62, 0x20, 0x1A, 0x01, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x01, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x01, // Ţ… (U+0162 U+2026)
  0x01, 0x62, 0x20, 0x39, 0x01, // Ţ‹ (U+0162 U+2039)
  0x01, 0x64, 0x00, 0x2C, 0x01, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2E, 0x01, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0x61, 0x01, // Ťa (U+0164 U+0061)
  0x01, 0x64, 0x00, 0x63, 0x01, // Ťc (U+0164 U+0063)
  0x01, 0x64, 0x00, 0x64, 0x01, // Ťd (U+0164 U+0064)
  0x01, 0x64, 0x00, 0x65, 0x01, // Ťe (U+0164 U+0065)
  0x01, 0x64, 0x00, 0x67, 0x01, // Ťg (U+0164 U+0067)
  0x01, 0x64, 0x00, 0x6D, 0x01, // Ťm (U+0164 U+006D)
  0x01, 0x64, 0x00, 0x6E, 0x01, // Ťn (U+0164 U+006E)
  0x01, 0x64, 0x00, 0x6F, 0x01, // Ťo (U+0164 U+006F)
  0x01, 0x64, 0x00, 0x70, 0x01, // Ťp (U+0164 U+0070)
  0x01, 0x64, 0x00, 0x71, 0x01, // Ťq (U+0164 U+0071)
  0x01, 0x64, 0x00, 0x72, 0x01, // Ťr (U+0164 U+0072)
  0x01, 0x64, 0x00, 0x73, 0x01, // Ťs (U+0164 U+0073)
  0x01, 0x64, 0x00, 0x75, 0x01, // Ťu (U+0164 U+0075)
  0x01, 0x64, 0x00, 0xAB, 0x01, // Ť« (U+0164 U+00AB)
  0x01, 0x64, 0x00, 0xE0, 0x01, // Ťà (U+0164 U+00E0)
  0x01, 0x64, 0x00, 0xE1, 0x01, // Ťá (U+0164 U+00E1)
  0x01, 0x64, 0x00, 0xE2, 0x01, // Ťâ (U+0164 U+00E2)
  0x01, 0x64, 0x00, 0xE3, 0x01, // Ťã (U+0164 U+00E3)
  0x01, 0x64, 0x00, 0xE4, 0x01, // Ťä (U+0164 U+00E4)
  0x01, 0x64, 0x00, 0xE5, 0x01, // Ťå (U+0164 U+00E5)
  0x01, 0x64, 0x00, 0xE6, 0x01, // Ťæ (U+0164 U+00E6)
  0x01, 0x64, 0x00, 0xE7, 0x01, // Ťç (U+0164 U+00E7)
  0x01, 0x64, 0x00, 0xE8, 0x01, // Ťè (U+0164 U+00E8)
  0x01, 0x64, 0x00, 0xE9, 0x01, // Ťé (U+0164 U+00E9)
  0x01, 0x64, 0x00, 0xEA, 0x01, // Ťê (U+0164 U+00EA)
  0x01, 0x64, 0x00, 0xEB, 0x01, // Ťë (U+0164 U+00EB)
  0x01, 0x64, 0x00, 0xF1, 0x01, // Ťñ (U+0164 U+00F1)
  0x01, 0x64, 0x00, 0xF2, 0x01, // Ťò (U+0164 U+00F2)
  0x01, 0x64, 0x00, 0xF3, 0x01, // Ťó (U+0164 U+00F3)
  0x01, 0x64, 0x00, 0xF4, 0x01, // Ťô (U+0164 U+00F4)
  0x01, 0x64, 0x00, 0xF5, 0x01, // Ťõ (U+0164 U+00F5)
  0x01, 0x64, 0x00, 0xF6, 0x01, // Ťö (U+0164 U+00F6)
  0x01, 0x64, 0x00, 0xF8, 0x01, // Ťø (U+0164 U+00F8)
  0x01, 0x64, 0x00, 0xF9, 0x01, // Ťù (U+0164 U+00F9)
  0x01, 0x64, 0x00, 0xFA, 0x01, // Ťú (U+0164 U+00FA)
  0x01, 0x64, 0x00, 0xFB, 0x01, // Ťû (U+0164 U+00FB)
  0x01, 0x64, 0x00, 0xFC, 0x01, // Ťü (U+0164 U+00FC)
  0x01, 0x64, 0x01, 0x01, 0x01, // Ťā (U+0164 U+0101)
  0x01, 0x64, 0x01, 0x03, 0x01, // Ťă (U+0164 U+0103)
  0x01, 0x64, 0x01, 0x05, 0x01, // Ťą (U+0164 U+0105)
  0x01, 0x64, 0x01, 0x07, 0x01, // Ťć (U+0164 U+0107)
  0x01, 0x64, 0x01, 0x09, 0x01, // Ťĉ (U+0164 U+0109)
  0x01, 0x64, 0x01, 0x0B, 0x01, // Ťċ (U+0164 U+010B)
  0x01, 0x64, 0x01, 0x0D, 0x01, // Ťč (U+0164 U+010D)
  0x01, 0x64, 0x01, 0x0F, 0x01, // Ťď (U+0164 U+010F)
  0x01, 0x64, 0x01, 0x11, 0x01, // Ťđ (U+0164 U+0111)
  0x01, 0x64, 0x01, 0x13, 0x01, // Ťē (U+0164 U+0113)
  0x01, 0x64, 0x01, 0x15, 0x01, // Ťĕ (U+0164 U+0115)
  0x01, 0x64, 0x01, 0x17, 0x01, // Ťė (U+0164 U+0117)
  0x01, 0x64, 0x01, 0x19, 0x01, // Ťę (U+0164 U+0119)
  0x01, 0x64, 0x01, 0x1B, 0x01, // Ťě (U+0164 U+011B)
  0x01, 0x64, 0x01, 0x1D, 0x01, // Ťĝ (U+0164 U+011D)
  0x01, 0x64, 0x01, 0x1F, 0x01, // Ťğ (U+0164 U+011F)
  0x01, 0x64, 0x01, 0x21, 0x01, // Ťġ (U+0164 U+0121)
  0x01, 0x64, 0x01, 0x23, 0x01, // Ťģ (U+0164 U+0123)
  0x01, 0x64, 0x01, 0x38, 0x01, // Ťĸ (U+0164 U+0138)
  0x01, 0x64, 0x01, 0x44, 0x01, // Ťń (U+0164 U+0144)
  0x01, 0x64, 0x01, 0x46, 0x01, // Ťņ (U+0164 U+0146)
  0x01, 0x64, 0x01, 0x48, 0x01, // Ťň (U+0164 U+0148)
  0x01, 0x64, 0x01, 0x4B, 0x01, // Ťŋ (U+0164 U+014B)
  0x01, 0x64, 0x01, 0x4D, 0x01, // Ťō (U+0164 U+014D)
  0x01, 0x64, 0x01, 0x4F, 0x01, // Ťŏ (U+0164 U+014F)
  0x01, 0x64, 0x01, 0x51, 0x01, // Ťő (U+0164 U+0151)
  0x01, 0x64, 0x01, 0x53, 0x01, // Ťœ (U+0164 U+0153)
  0x01, 0x64, 0x01, 0x55, 0x01, // Ťŕ (U+0164 U+0155)
  0x01, 0x64, 0x01, 0x57, 0x01, // Ťŗ (U+0164 U+0157)
  0x01, 0x64, 0x01, 0x5B, 0x01, // Ťś (U+0164 U+015B)
  0x01, 0x64, 0x01, 0x5D, 0x01, // Ťŝ (U+0164 U+015D)
  0x01, 0x64, 0x01, 0x5F, 0x01, // Ťş (U+0164 U+015F)
  0x01, 0x64, 0x01, 0x61, 0x01, // Ťš (U+0164 U+0161)
  0x01, 0x64, 0x01, 0x69, 0x01, // Ťũ (U+0164 U+0169)
  0x01, 0x64, 0x01, 0x6B, 0x01, // Ťū (U+0164 U+016B)
  0x01, 0x64, 0x01, 0x6D, 0x01, // Ťŭ (U+0164 U+016D)
  0x01, 0x64, 0x01, 0x6F, 0x01, // Ťů (U+0164 U+016F)
  0x01, 0x64, 0x01, 0x71, 0x01, // Ťű (U+0164 U+0171)
  0x01, 0x64, 0x01, 0x73, 0x01, // Ťų (U+0164 U+0173)
  0x01, 0x64, 0x20, 0x1A, 0x01, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x01, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x01, // Ť… (U+0164 U+2026)
  0x01, 0x64, 0x20, 0x39, 0x01, // Ť‹ (U+0164 U+2039)
  0x01, 0x66, 0x00, 0x2C, 0x01, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2E, 0x01, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0x61, 0x01, // Ŧa (U+0166 U+0061)
  0x01, 0x66, 0x00, 0x63, 0x01, // Ŧc (U+0166 U+0063)
  0x01, 0x66, 0x00, 0x64, 0x01, // Ŧd (U+0166 U+0064)
  0x01, 0x66, 0x00, 0x65, 0x01, // Ŧe (U+0166 U+0065)
  0x01, 0x66, 0x00, 0x67, 0x01, // Ŧg (U+0166 U+0067)
  0x01, 0x66, 0x00, 0x6D, 0x01, // Ŧm (U+0166 U+006D)
  0x01, 0x66, 0x00, 0x6E, 0x01, // Ŧn (U+0166 U+006E)
  0x01, 0x66, 0x00, 0x6F, 0x01, // Ŧo (U+0166 U+006F)
  0x01, 0x66, 0x00, 0x70, 0x01, // Ŧp (U+0166 U+0070)
  0x01, 0x66, 0x00, 0x71, 0x01, // Ŧq (U+0166 U+0071)
  0x01, 0x66, 0x00, 0x72, 0x01, // Ŧr (U+0166 U+0072)
  0x01, 0x66, 0x00, 0x73, 0x01, // Ŧs (U+0166 U+0073)
  0x01, 0x66, 0x00, 0x75, 0x01, // Ŧu (U+0166 U+0075)
  0x01, 0x66, 0x00, 0xAB, 0x01, // Ŧ« (U+0166 U+00AB)
  0x01, 0x66, 0x00, 0xE0, 0x01, // Ŧà (U+0166 U+00E0)
  0x01, 0x66, 0x00, 0xE1, 0x01, // Ŧá (U+0166 U+00E1)
  0x01, 0x66, 0x00, 0xE2, 0x01, // Ŧâ (U+0166 U+00E2)
  0x01, 0x66, 0x00, 0xE3, 0x01, // Ŧã (U+0166 U+00E3)
  0x01, 0x66, 0x00, 0xE4, 0x01, // Ŧä (U+0166 U+00E4)
  0x01, 0x66, 0x00, 0xE5, 0x01, // Ŧå (U+0166 U+00E5)
  0x01, 0x66, 0x00, 0xE6, 0x01, // Ŧæ (U+0166 U+00E6)
  0x01, 0x66, 0x00, 0xE7, 0x01, // Ŧç (U+0166 U+00E7)
  0x01, 0x66, 0x00, 0xE8, 0x01, // Ŧè (U+0166 U+00E8)
  0x01, 0x66, 0x00, 0xE9, 0x01, // Ŧé (U+0166 U+00E9)
  0x01, 0x66, 0x00, 0xEA, 0x01, // Ŧê (U+0166 U+00EA)
  0x01, 0x66, 0x00, 0xEB, 0x01, // Ŧë (U+0166 U+00EB)
  0x01, 0x66, 0x00, 0xF1, 0x01, // Ŧñ (U+0166 U+00F1)
  0x01, 0x66, 0x00, 0xF2, 0x01, // Ŧò (U+0166 U+00F2)
  0x01, 0x66, 0x00, 0xF3, 0x01, // Ŧó (U+0166 U+00F3)
  0x01, 0x66, 0x00, 0xF4, 0x01, // Ŧô (U+0166 U+00F4)
  0x01, 0x66, 0x00, 0xF5, 0x01, // Ŧõ (U+0166 U+00F5)
  0x01, 0x66, 0x00, 0xF6, 0x01, // Ŧö (U+0166 U+00F6)
  0x01, 0x66, 0x00, 0xF8, 0x01, // Ŧø (U+0166 U+00F8)
  0x01, 0x66, 0x00, 0xF9, 0x01, // Ŧù (U+0166 U+00F9)
  0x01, 0x66, 0x00, 0xFA, 0x01, // Ŧú (U+0166 U+00FA)
  0x01, 0x66, 0x00, 0xFB, 0x01, // Ŧû (U+0166 U+00FB)
  0x01, 0x66, 0x00, 0xFC, 0x01, // Ŧü (U+0166 U+00FC)
  0x01, 0x66, 0x01, 0x01, 0x01, // Ŧā (U+0166 U+0101)
  0x01, 0x66, 0x01, 0x03, 0x01, // Ŧă (U+0166 U+0103)
  0x01, 0x66, 0x01, 0x05, 0x01, // Ŧą (U+0166 U+0105)
  0x01, 0x66, 0x01, 0x07, 0x01, // Ŧć (U+0166 U+0107)
  0x01, 0x66, 0x01, 0x09, 0x01, // Ŧĉ (U+0166 U+0109)
  0x01, 0x66, 0x01, 0x0B, 0x01, // Ŧċ (U+0166 U+010B)
  0x01, 0x66, 0x01, 0x0D, 0x01, // Ŧč (U+0166 U+010D)
  0x01, 0x66, 0x01, 0x0F, 0x01, // Ŧď (U+0166 U+010F)
  0x01, 0x66, 0x01, 0x11, 0x01, // Ŧđ (U+0166 U+0111)
  0x01, 0x66, 0x01, 0x13, 0x01, // Ŧē (U+0166 U+0113)
  0x01, 0x66, 0x01, 0x15, 0x01, // Ŧĕ (U+0166 U+0115)
  0x01, 0x66, 0x01, 0x17, 0x01, // Ŧė (U+0166 U+0117)
  0x01, 0x66, 0x01, 0x19, 0x01, // Ŧę (U+0166 U+0119)
  0x01, 0x66, 0x01, 0x1B, 0x01, // Ŧě (U+0166 U+011B)
  0x01, 0x66, 0x01, 0x1D, 0x01, // Ŧĝ (U+0166 U+011D)
  0x01, 0x66, 0x01, 0x1F, 0x01, // Ŧğ (U+0166 U+011F)
  0x01, 0x66, 0x01, 0x21, 0x01, // Ŧġ (U+0166 U+0121)
  0x01, 0x66, 0x01, 0x23, 0x01, // Ŧģ (U+0166 U+0123)
  0x01, 0x66, 0x01, 0x38, 0x01, // Ŧĸ (U+0166 U+0138)
  0x01, 0x66, 0x01, 0x44, 0x01, // Ŧń (U+0166 U+0144)
  0x01, 0x66, 0x01, 0x46, 0x01, // Ŧņ (U+0166 U+0146)
  0x01, 0x66, 0x01, 0x48, 0x01, // Ŧň (U+0166 U+0148)
  0x01, 0x66, 0x01, 0x4B, 0x01, // Ŧŋ (U+0166 U+014B)
  0x01, 0x66, 0x01, 0x4D, 0x01, // Ŧō (U+0166 U+014D)
  0x01, 0x66, 0x01, 0x4F, 0x01, // Ŧŏ (U+0166 U+014F)
  0x01, 0x66, 0x01, 0x51, 0x01, // Ŧő (U+0166 U+0151)
  0x01, 0x66, 0x01, 0x53, 0x01, // Ŧœ (U+0166 U+0153)
  0x01, 0x66, 0x01, 0x55, 0x01, // Ŧŕ (U+0166 U+0155)
  0x01, 0x66, 0x01, 0x57, 0x01, // Ŧŗ (U+0166 U+0157)
  0x01, 0x66, 0x01, 0x5B, 0x01, // Ŧś (U+0166 U+015B)
  0x01, 0x66, 0x01, 0x5D, 0x01, // Ŧŝ (U+0166 U+015D)
  0x01, 0x66, 0x01, 0x5F, 0x01, // Ŧş (U+0166 U+015F)
  0x01, 0x66, 0x01, 0x61, 0x01, // Ŧš (U+0166 U+0161)
  0x01, 0x66, 0x01, 0x69, 0x01, // Ŧũ (U+0166 U+0169)
  0x01, 0x66, 0x01, 0x6B, 0x01, // Ŧū (U+0166 U+016B)
  0x01, 0x66, 0x01, 0x6D, 0x01, // Ŧŭ (U+0166 U+016D)
  0x01, 0x66, 0x01, 0x6F, 0x01, // Ŧů (U+0166 U+016F)
  0x01, 0x66, 0x01, 0x71, 0x01, // Ŧű (U+0166 U+0171)
  0x01, 0x66, 0x01, 0x73, 0x01, // Ŧų (U+0166 U+0173)
  0x01, 0x66, 0x20, 0x1A, 0x01, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x01, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x01, // Ŧ… (U+0166 U+2026)
  0x01, 0x66, 0x20, 0x39, 0x01, // Ŧ‹ (U+0166 U+2039)
  0x01, 0x74, 0x00, 0x2C, 0x01, // Ŵ, (U+0174 U+002C)
  0x01, 0x74, 0x00, 0x2E, 0x01, // Ŵ. (U+0174 U+002E)
  0x01, 0x74, 0x20, 0x1A, 0x01, // Ŵ‚ (U+0174 U+201A)
  0x01, 0x74, 0x20, 0x1E, 0x01, // Ŵ„ (U+0174 U+201E)
  0x01, 0x74, 0x20, 0x26, 0x01, // Ŵ… (U+0174 U+2026)
  0x01, 0x76, 0x00, 0x2C, 0x01, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x01, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x20, 0x1A, 0x01, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x01, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x01, // Ŷ… (U+0176 U+2026)
  0x01, 0x78, 0x00, 0x2C, 0x01, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x01, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x20, 0x1A, 0x01, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x01, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x01, // Ÿ… (U+0178 U+2026)
  0x20, 0x18, 0x00, 0x41, 0x01, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0x63, 0x01, // ‘c (U+2018 U+0063)
  0x20, 0x18, 0x00, 0x64, 0x01, // ‘d (U+2018 U+0064)
  0x20, 0x18, 0x00, 0x65, 0x01, // ‘e (U+2018 U+0065)
  0x20, 0x18, 0x00, 0x6F, 0x01, // ‘o (U+2018 U+006F)
  0x20, 0x18, 0x00, 0x71, 0x01, // ‘q (U+2018 U+0071)
  0x20, 0x18, 0x00, 0xC0, 0x01, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x01, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x01, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x01, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x01, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x01, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xE0, 0x01, // ‘à (U+2018 U+00E0)
  0x20, 0x18, 0x00, 0xE7, 0x01, // ‘ç (U+2018 U+00E7)
  0x20, 0x18, 0x00, 0xE8, 0x01, // ‘è (U+2018 U+00E8)
  0x20, 0x18, 0x00, 0xE9, 0x01, // ‘é (U+2018 U+00E9)
  0x20, 0x18, 0x00, 0xEA, 0x01, // ‘ê (U+2018 U+00EA)
  0x20, 0x18, 0x00, 0xEB, 0x01, // ‘ë (U+2018 U+00EB)
  0x20, 0x18, 0x00, 0xF2, 0x01, // ‘ò (U+2018 U+00F2)
  0x20, 0x18, 0x00, 0xF3, 0x01, // ‘ó (U+2018 U+00F3)
  0x20, 0x18, 0x00, 0xF4, 0x01, // ‘ô (U+2018 U+00F4)
  0x20, 0x18, 0x00, 0xF5, 0x01, // ‘õ (U+2018 U+00F5)
  0x20, 0x18, 0x00, 0xF6, 0x01, // ‘ö (U+2018 U+00F6)
  0x20, 0x18, 0x00, 0xF8, 0x01, // ‘ø (U+2018 U+00F8)
  0x20, 0x18, 0x01, 0x00, 0x01, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x02, 0x01, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x04, 0x01, // ‘Ą (U+2018 U+0104)
  0x20, 0x18, 0x01, 0x07, 0x01, // ‘ć (U+2018 U+0107)
  0x20, 0x18, 0x01, 0x09, 0x01, // ‘ĉ (U+2018 U+0109)
  0x20, 0x18, 0x01, 0x0B, 0x01, // ‘ċ (U+2018 U+010B)
  0x20, 0x18, 0x01, 0x0D, 0x01, // ‘č (U+2018 U+010D)
  0x20, 0x18, 0x01, 0x0F, 0x01, // ‘ď (U+2018 U+010F)
  0x20, 0x18, 0x01, 0x11, 0x01, // ‘đ (U+2018 U+0111)
  0x20, 0x18, 0x01, 0x13, 0x01, // ‘ē (U+2018 U+0113)
  0x20, 0x18, 0x01, 0x15, 0x01, // ‘ĕ (U+2018 U+0115)
  0x20, 0x18, 0x01, 0x17, 0x01, // ‘ė (U+2018 U+0117)
  0x20, 0x18, 0x01, 0x19, 0x01, // ‘ę (U+2018 U+0119)
  0x20, 0x18, 0x01, 0x1B, 0x01, // ‘ě (U+2018 U+011B)
  0x20, 0x18, 0x01, 0x4D, 0x01, // ‘ō (U+2018 U+014D)
  0x20, 0x18, 0x01, 0x4F, 0x01, // ‘ŏ (U+2018 U+014F)
  0x20, 0x18, 0x01, 0x51, 0x01, // ‘ő (U+2018 U+0151)
  0x20, 0x18, 0x01, 0x53, 0x01, // ‘œ (U+2018 U+0153)
  0x20, 0x19, 0x00, 0x41, 0x01, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0x63, 0x01, // ’c (U+2019 U+0063)
  0x20, 0x19, 0x00, 0x64, 0x01, // ’d (U+2019 U+0064)
  0x20, 0x19, 0x00, 0x65, 0x01, // ’e (U+2019 U+0065)
  0x20, 0x19, 0x00, 0x6F, 0x01, // ’o (U+2019 U+006F)
  0x20, 0x19, 0x00, 0x71, 0x01, // ’q (U+2019 U+0071)
  0x20, 0x19, 0x00, 0xC0, 0x01, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x01, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x01, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x01, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x01, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x01, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xE0, 0x01, // ’à (U+2019 U+00E0)
  0x20, 0x19, 0x00, 0xE7, 0x01, // ’ç (U+2019 U+00E7)
  0x20, 0x19, 0x00, 0xE8, 0x01, // ’è (U+2019 U+00E8)
  0x20, 0x19, 0x00, 0xE9, 0x01, // ’é (U+2019 U+00E9)
  0x20, 0x19, 0x00, 0xEA, 0x01, // ’ê (U+2019 U+00EA)
  0x20, 0x19, 0x00, 0xEB, 0x01, // ’ë (U+2019 U+00EB)
  0x20, 0x19, 0x00, 0xF2, 0x01, // ’ò (U+2019 U+00F2)
  0x20, 0x19, 0x00, 0xF3, 0x01, // ’ó (U+2019 U+00F3)
  0x20, 0x19, 0x00, 0xF4, 0x01, // ’ô (U+2019 U+00F4)
  0x20, 0x19, 0x00, 0xF5, 0x01, // ’õ (U+2019 U+00F5)
  0x20, 0x19, 0x00, 0xF6, 0x01, // ’ö (U+2019 U+00F6)
  0x20, 0x19, 0x00, 0xF8, 0x01, // ’ø (U+2019 U+00F8)
  0x20, 0x19, 0x01, 0x00, 0x01, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x02, 0x01, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x04, 0x01, // ’Ą (U+2019 U+0104)
  0x20, 0x19, 0x01, 0x07, 0x01, // ’ć (U+2019 U+0107)
  0x20, 0x19, 0x01, 0x09, 0x01, // ’ĉ (U+2019 U+0109)
  0x20, 0x19, 0x01, 0x0B, 0x01, // ’ċ (U+2019 U+010B)
  0x20, 0x19, 0x01, 0x0D, 0x01, // ’č (U+2019 U+010D)
  0x20, 0x19, 0x01, 0x0F, 0x01, // ’ď (U+2019 U+010F)
  0x20, 0x19, 0x01, 0x11, 0x01, // ’đ (U+2019 U+0111)
  0x20, 0x19, 0x01, 0x13, 0x01, // ’ē (U+2019 U+0113)
  0x20, 0x19, 0x01, 0x15, 0x01, // ’ĕ (U+2019 U+0115)
  0x20, 0x19, 0x01, 0x17, 0x01, // ’ė (U+2019 U+0117)
  0x20, 0x19, 0x01, 0x19, 0x01, // ’ę (U+2019 U+0119)
  0x20, 0x19, 0x01, 0x1B, 0x01, // ’ě (U+2019 U+011B)
  0x20, 0x19, 0x01, 0x4D, 0x01, // ’ō (U+2019 U+014D)
  0x20, 0x19, 0x01, 0x4F, 0x01, // ’ŏ (U+2019 U+014F)
  0x20, 0x19, 0x01, 0x51, 0x01, // ’ő (U+2019 U+0151)
  0x20, 0x19, 0x01, 0x53, 0x01, // ’œ (U+2019 U+0153)
  0x20, 0x1A, 0x00, 0x54, 0x01, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x56, 0x01, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x01, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x01, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0xDD, 0x01, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x01, 0x62, 0x01, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x01, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x01, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1A, 0x01, 0x74, 0x01, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x76, 0x01, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x78, 0x01, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x01, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0x63, 0x01, // “c (U+201C U+0063)
  0x20, 0x1C, 0x00, 0x64, 0x01, // “d (U+201C U+0064)
  0x20, 0x1C, 0x00, 0x65, 0x01, // “e (U+201C U+0065)
  0x20, 0x1C, 0x00, 0x6F, 0x01, // “o (U+201C U+006F)
  0x20, 0x1C, 0x00, 0x71, 0x01, // “q (U+201C U+0071)
  0x20, 0x1C, 0x00, 0xC0, 0x01, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x01, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x01, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x01, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x01, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x01, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xE0, 0x01, // “à (U+201C U+00E0)
  0x20, 0x1C, 0x00, 0xE7, 0x01, // “ç (U+201C U+00E7)
  0x20, 0x1C, 0x00, 0xE8, 0x01, // “è (U+201C U+00E8)
  0x20, 0x1C, 0x00, 0xE9, 0x01, // “é (U+201C U+00E9)
  0x20, 0x1C, 0x00, 0xEA, 0x01, // “ê (U+201C U+00EA)
  0x20, 0x1C, 0x00, 0xEB, 0x01, // “ë (U+201C U+00EB)
  0x20, 0x1C, 0x00, 0xF2, 0x01, // “ò (U+201C U+00F2)
  0x20, 0x1C, 0x00, 0xF3, 0x01, // “ó (U+201C U+00F3)
  0x20, 0x1C, 0x00, 0xF4, 0x01, // “ô (U+201C U+00F4)
  0x20, 0x1C, 0x00, 0xF5, 0x01, // “õ (U+201C U+00F5)
  0x20, 0x1C, 0x00, 0xF6, 0x01, // “ö (U+201C U+00F6)
  0x20, 0x1C, 0x00, 0xF8, 0x01, // “ø (U+201C U+00F8)
  0x20, 0x1C, 0x01, 0x00, 0x01, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x02, 0x01, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x04, 0x01, // “Ą (U+201C U+0104)
  0x20, 0x1C, 0x01, 0x07, 0x01, // “ć (U+201C U+0107)
  0x20, 0x1C, 0x01, 0x09, 0x01, // “ĉ (U+201C U+0109)
  0x20, 0x1C, 0x01, 0x0B, 0x01, // “ċ (U+201C U+010B)
  0x20, 0x1C, 0x01, 0x0D, 0x01, // “č (U+201C U+010D)
  0x20, 0x1C, 0x01, 0x0F, 0x01, // “ď (U+201C U+010F)
  0x20, 0x1C, 0x01, 0x11, 0x01, // “đ (U+201C U+0111)
  0x20, 0x1C, 0x01, 0x13, 0x01, // “ē (U+201C U+0113)
  0x20, 0x1C, 0x01, 0x15, 0x01, // “ĕ (U+201C U+0115)
  0x20, 0x1C, 0x01, 0x17, 0x01, // “ė (U+201C U+0117)
  0x20, 0x1C, 0x01, 0x19, 0x01, // “ę (U+201C U+0119)
  0x20, 0x1C, 0x01, 0x1B, 0x01, // “ě (U+201C U+011B)
  0x20, 0x1C, 0x01, 0x4D, 0x01, // “ō (U+201C U+014D)
  0x20, 0x1C, 0x01, 0x4F, 0x01, // “ŏ (U+201C U+014F)
  0x20, 0x1C, 0x01, 0x51, 0x01, // “ő (U+201C U+0151)
  0x20, 0x1C, 0x01, 0x53, 0x01, // “œ (U+201C U+0153)
  0x20, 0x1D, 0x00, 0x41, 0x01, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0x63, 0x01, // ”c (U+201D U+0063)
  0x20, 0x1D, 0x00, 0x64, 0x01, // ”d (U+201D U+0064)
  0x20, 0x1D, 0x00, 0x65, 0x01, // ”e (U+201D U+0065)
  0x20, 0x1D, 0x00, 0x6F, 0x01, // ”o (U+201D U+006F)
  0x20, 0x1D, 0x00, 0x71, 0x01, // ”q (U+201D U+0071)
  0x20, 0x1D, 0x00, 0xC0, 0x01, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x01, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x01, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x01, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x01, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x01, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xE0, 0x01, // ”à (U+201D U+00E0)
  0x20, 0x1D, 0x00, 0xE7, 0x01, // ”ç (U+201D U+00E7)
  0x20, 0x1D, 0x00, 0xE8, 0x01, // ”è (U+201D U+00E8)
  0x20, 0x1D, 0x00, 0xE9, 0x01, // ”é (U+201D U+00E9)
  0x20, 0x1D, 0x00, 0xEA, 0x01, // ”ê (U+201D U+00EA)
  0x20, 0x1D, 0x00, 0xEB, 0x01, // ”ë (U+201D U+00EB)
  0x20, 0x1D, 0x00, 0xF2, 0x01, // ”ò (U+201D U+00F2)
  0x20, 0x1D, 0x00, 0xF3, 0x01, // ”ó (U+201D U+00F3)
  0x20, 0x1D, 0x00, 0xF4, 0x01, // ”ô (U+201D U+00F4)
  0x20, 0x1D, 0x00, 0xF5, 0x01, // ”õ (U+201D U+00F5)
  0x20, 0x1D, 0x00, 0xF6, 0x01, // ”ö (U+201D U+00F6)
  0x20, 0x1D, 0x00, 0xF8, 0x01, // ”ø (U+201D U+00F8)
  0x20, 0x1D, 0x01, 0x00, 0x01, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x02, 0x01, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x04, 0x01, // ”Ą (U+201D U+0104)
  0x20, 0x1D, 0x01, 0x07, 0x01, // ”ć (U+201D U+0107)
  0x20, 0x1D, 0x01, 0x09, 0x01, // ”ĉ (U+201D U+0109)
  0x20, 0x1D, 0x01, 0x0B, 0x01, // ”ċ (U+201D U+010B)
  0x20, 0x1D, 0x01, 0x0D, 0x01, // ”č (U+201D U+010D)
  0x20, 0x1D, 0x01, 0x0F, 0x01, // ”ď (U+201D U+010F)
  0x20, 0x1D, 0x01, 0x11, 0x01, // ”đ (U+201D U+0111)
  0x20, 0x1D, 0x01, 0x13, 0x01, // ”ē (U+201D U+0113)
  0x20, 0x1D, 0x01, 0x15, 0x01, // ”ĕ (U+201D U+0115)
  0x20, 0x1D, 0x01, 0x17, 0x01, // ”ė (U+201D U+0117)
  0x20, 0x1D, 0x01, 0x19, 0x01, // ”ę (U+201D U+0119)
  0x20, 0x1D, 0x01, 0x1B, 0x01, // ”ě (U+201D U+011B)
  0x20, 0x1D, 0x01, 0x4D, 0x01, // ”ō (U+201D U+014D)
  0x20, 0x1D, 0x01, 0x4F, 0x01, // ”ŏ (U+201D U+014F)
  0x20, 0x1D, 0x01, 0x51, 0x01, // ”ő (U+201D U+0151)
  0x20, 0x1D, 0x01, 0x53, 0x01, // ”œ (U+201D U+0153)
  0x20, 0x1E, 0x00, 0x54, 0x01, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x56, 0x01, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x01, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x01, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0xDD, 0x01, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x01, 0x62, 0x01, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x01, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x01, // „Ŧ (U+201E U+0166)
  0x20, 0x1E, 0x01, 0x74, 0x01, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x76, 0x01, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x78, 0x01, // „Ÿ (U+201E U+0178)
  0x20, 0x3A, 0x00, 0x54, 0x01, // ›T (U+203A U+0054)
  0x20, 0x3A, 0x01, 0x62, 0x01, // ›Ţ (U+203A U+0162)
  0x20, 0x3A, 0x01, 0x64, 0x01, // ›Ť (U+203A U+0164)
  0x20, 0x3A, 0x01, 0x66, 0x01, // ›Ŧ (U+203A U+0166)
  
  // Glyph data
  // "!" (U+0021)
  0x02, 0xE0, 0x5B, 0x08, 0x70, 0xB3, 0x0D, 0x01, 0xB0, 0x01, 0x07, 0x40, 0xB4, 0x00,
  // """ (U+0022)
  0x69, 0x77, 0x85, 0xA3, 0xA1, 0xB0,
  // "#" (U+0023)
  0x00, 0x39, 0x29, 0x00, 0x83, 0x83, 0x0D, 0xFD, 0xFD, 0x02, 0x91, 0x90, 0x06, 0x46, 0x50, 0xBE,
  0xDE, 0xD3, 0x0B, 0x0B, 0x00, 0x38, 0x38, 0x00, 0x74, 0x74, 0x00,
  // "$" (U+0024)
  0x30, 0x83, 0x89, 0x01, 0xBE, 0xC1, 0x0A, 0x68, 0x32, 0x81, 0xC4, 0x63, 0x81, 0x6E, 0x44, 0x81,
  0x9D, 0x13, 0x89, 0x48, 0x76, 0x03, 0x09, 0xB5, 0x09, 0xEF, 0x93, 0x06, 0x03, 0x40, 0x34,
  // "%" (U+0025)
  0x03, 0xD8, 0x01, 0xA0, 0x0B, 0x1C, 0x09, 0x20, 0x1B, 0x0B, 0x39, 0x00, 0x38, 0x29, 0xA8, 0xD3,
  0x48, 0x89, 0x9B, 0x48, 0x1C, 0x9B, 0x66, 0x47, 0x00, 0x66, 0x93, 0x74, 0x01, 0xB0, 0x92, 0xB0,
  0x08, 0x40, 0x5E, 0x50,
  // "&" (U+0026)
  0x00, 0x8E, 0x80, 0x02, 0xB0, 0xD0, 0x04, 0x93, 0xB0, 0x03, 0xDD, 0x30, 0x04, 0xF5, 0x00, 0x4C,
  0x89, 0x59, 0xC2, 0x0D, 0xC2, 0xD2, 0x1C, 0xA0, 0x6E, 0xD5, 0xE1,
  // "'" (U+0027)
  0x5A, 0x75, 0xA1,
  // "(" (U+0028)
  0x00, 0x3A, 0x00, 0xC1, 0x07, 0x70, 0x0D, 0x10, 0x3B, 0x00, 0x76, 0x00, 0x95, 0x00, 0xA3, 0x00,
  0x94, 0x00, 0x76, 0x00, 0x29, 0x00,
  // ")" (U+0029)
  0x00, 0x84, 0x00, 0x49, 0x00, 0x2B, 0x00, 0x2C, 0x00, 0x3B, 0x00, 0x59, 0x00, 0x95, 0x00, 0xD1,
  0x05, 0x90, 0x0C, 0x10, 0x85, 0x00,
  // "*" (U+002A)
  0x00, 0x80, 0x04, 0x1C, 0x00, 0x5B, 0xDC, 0x51, 0xBB, 0x00, 0x35, 0x65, 0x00,
  // "+" (U+002B)
  0x20, 0x06, 0x40, 0x06, 0x28, 0x45, 0xDE, 0xED, 0x52, 0x00, 0x64, 0x00, 0x64, 0x00, 0x62,
  // "," (U+002C)
  0x08, 0x70, 0xD1, 0x57, 0x00,
  // "-" (U+002D)
  0x9D, 0xC0,
  // "." (U+002E)
  0x75, 0xB4,
  // "/" (U+002F)
  0x40, 0x20, 0xB4, 0x0A, 0x03, 0x30, 0x30, 0xB4, 0x0B, 0x03, 0x30, 0x30, 0xA4, 0x0B, 0x02, 0x30,
  0x40, 0xA4, 0x0C, 0x02, 0x30, 0x50, 0x94,
  // "0" (U+0030)
  0x00, 0x8D, 0x90, 0x05, 0xA0, 0xD1, 0x0C, 0x20, 0xC2, 0x2D, 0x00, 0xD1, 0x59, 0x00, 0xE0, 0x86,
  0x03, 0xB0, 0x95, 0x08, 0x60, 0x77, 0x1D, 0x00, 0x2D, 0xD3, 0x00,
  // "1" (U+0031)
  0x01, 0xC7, 0x3C, 0xD4, 0x32, 0xE1, 0x01, 0xD0, 0x05, 0xA0, 0x08, 0x70, 0x0B, 0x30, 0x0E, 0x00,
  0x2D, 0x00,
  // "2" (U+0032)
  0x28, 0x23, 0xCD, 0x93, 0x83, 0x32, 0x0E, 0x25, 0x0D, 0x01, 0x40, 0x40, 0xC4, 0x81, 0x1D, 0x34,
  0x0B, 0x06, 0x40, 0x90, 0x84, 0x07, 0x0A, 0x40, 0x29, 0x0F, 0xD2,
  // "3" (U+0033)
  0x04, 0xCD, 0x90, 0x02, 0x10, 0xE2, 0x00, 0x00, 0xE1, 0x00, 0x07, 0x90, 0x05, 0xEA, 0x00, 0x00,
  0x0C, 0x40, 0x00, 0x09, 0x60, 0x10, 0x2D, 0x20, 0xCD, 0xD5, 0x00,
  // "4" (U+0034)
  0x00, 0x03, 0xF2, 0x00, 0x0B, 0xE0, 0x00, 0x88, 0xB0, 0x03, 0xA6, 0x80, 0x0B, 0x1A, 0x40, 0x84,
  0x0D, 0x10, 0xEE, 0xEF, 0xC0, 0x00, 0x3A, 0x00, 0x00, 0x77, 0x00,
  // "5" (U+0035)
  0x18, 0x61, 0xED, 0xD2, 0x06, 0x74, 0x0B, 0x03, 0x48, 0x2E, 0xDB, 0x14, 0x0B, 0x07, 0x40, 0x60,
  0x94, 0x89, 0x38, 0x70, 0x20, 0x2E, 0x10, 0xCD, 0xD3, 0x20,
  // "6" (U+0036)
  0x00, 0x2C, 0xD5, 0x01, 0xC2, 0x00, 0x09, 0x40, 0x00, 0x0D, 0x9D, 0x40, 0x4E, 0x15, 0xB0, 0x78,
  0x03, 0xB0, 0x86, 0x05, 0x90, 0x68, 0x0C, 0x30, 0x1C, 0xD7, 0x00,
  // "7" (U+0037)
  0x18, 0x39, 0xDD, 0xE8, 0x40, 0xC0, 0x33, 0x04, 0x0B, 0x40, 0xC0, 0x33, 0x04, 0x0B, 0x40, 0xB0,
  0x43, 0x03, 0x0C, 0x40, 0xB0, 0x43, 0x03, 0x0C, 0x40,
  // "8" (U+0038)
  0x00, 0xBD, 0xB0, 0x08, 0x70, 0xB4, 0x0A, 0x40, 0xC3, 0x05, 0xB9, 0x90, 0x05, 0xEC, 0x00, 0x5B,
  0x1B, 0x50, 0xC2, 0x06, 0x80, 0xC4, 0x0A, 0x60, 0x4D, 0xE9, 0x00,
  // "9" (U+0039)
  0x01, 0xBD, 0x70, 0x0A, 0x60, 0xE0, 0x0E, 0x00, 0xD1, 0x2C, 0x00, 0xE0, 0x2D, 0x07, 0xD0, 0x09,
  0xD9, 0x90, 0x00, 0x09, 0x30, 0x00, 0x5A, 0x00, 0xBD, 0xA0, 0x00,
  // ":" (U+003A)
  0x18, 0x39, 0x50, 0x93, 0x72, 0x83, 0x83, 0x0C, 0x31,
  // ";" (U+003B)
  0x20, 0x90, 0x62, 0x09, 0x03, 0x76, 0x00, 0x22, 0x83, 0xB4, 0x01, 0xC2, 0x05, 0x04, 0x20,
  // "<" (U+003C)
  0x00, 0x01, 0x95, 0x01, 0x8C, 0x50, 0x4D, 0x50, 0x00, 0x17, 0xC5, 0x00, 0x00, 0x18, 0xC3, 0x00,
  0x00, 0x12,
  // "=" (U+003D)
  0x84, 0x5D, 0xDD, 0xD4, 0x75, 0x84, 0x5D, 0xDD, 0xD4,
  // ">" (U+003E)
  0x58, 0x10, 0x00, 0x05, 0xC8, 0x10, 0x00, 0x05, 0xE4, 0x00, 0x6C, 0x70, 0x3C, 0x71, 0x00, 0x21,
  0x00, 0x00,
  // "?" (U+003F)
  0x18, 0x79, 0xDC, 0x10, 0x20, 0xA5, 0x30, 0xC0, 0x32, 0x08, 0x07, 0x20, 0x50, 0x93, 0x0C, 0x40,
  0x23, 0x04, 0x07, 0x30, 0x07, 0x30,
  // "@" (U+0040)
  0x00, 0x08, 0xDD, 0x90, 0x00, 0xB5, 0x00, 0x86, 0x07, 0x54, 0xDC, 0x1A, 0x0C, 0x1B, 0x0B, 0x0B,
  0x47, 0x65, 0x38, 0x1A, 0x73, 0x92, 0x75, 0x46, 0x92, 0xB2, 0xC4, 0xA1, 0x74, 0x6D, 0x4D, 0x50,
  0x2C, 0x10, 0x10, 0x00, 0x05, 0xCD, 0xA0, 0x00,
  // "A" (U+0041)
  0x00, 0x01, 0xF5, 0x00, 0x07, 0xC6, 0x00, 0x0C, 0x76, 0x00, 0x58, 0x67, 0x00, 0xC2, 0x68, 0x03,
  0xFE, 0xE8, 0x0A, 0x50, 0x69, 0x1D, 0x00, 0x59, 0x88, 0x00, 0x5A,
  // "B" (U+0042)
  0x02, 0xFD, 0xD3, 0x05, 0xA0, 0x6B, 0x08, 0x70, 0x5B, 0x0B, 0x40, 0xB5, 0x0E, 0xDF, 0x80, 0x2D,
  0x02, 0xE0, 0x5A, 0x00, 0xE1, 0x86, 0x05, 0xC0, 0xBE, 0xDB, 0x20,
  // "C" (U+0043)
  0x28, 0x93, 0x3B, 0xDC, 0x01, 0xE4, 0x01, 0x09, 0x74, 0x0E, 0x40, 0x40, 0xB4, 0x06, 0x09, 0x40,
  0x50, 0x94, 0x81, 0x2D, 0x14, 0x82, 0x7D, 0xD4, 0x10,
  // "D" (U+0044)
  0x02, 0xFD, 0xC3, 0x05, 0x90, 0x6C, 0x08, 0x60, 0x0F, 0x0B, 0x30, 0x0F, 0x0E, 0x00, 0x2E, 0x2D,
  0x00, 0x6A, 0x59, 0x00, 0xC4, 0x86, 0x09, 0xA0, 0xBE, 0xD8, 0x00,
  // "E" (U+0045)
  0x18, 0x62, 0xFD, 0xD4, 0x05, 0xA4, 0x08, 0x07, 0x40, 0xB0, 0x44, 0x85, 0xED, 0xD5, 0x02, 0xD4,
  0x05, 0x0A, 0x40, 0x80, 0x64, 0x82, 0xBE, 0xD9, 0x20,
  // "F" (U+0046)
  0x18, 0x62, 0xFD, 0xD4, 0x05, 0x94, 0x08, 0x06, 0x40, 0xB0, 0x34, 0x85, 0xED, 0xD4, 0x02, 0xC4,
  0x05, 0x09, 0x40, 0x80, 0x64, 0x0B, 0x03, 0x40,
  // "G" (U+0047)
  0x00, 0x2B, 0xDD, 0x50, 0x1D, 0x40, 0x11, 0x0A, 0x70, 0x00, 0x01, 0xE1, 0x00, 0x00, 0x4B, 0x03,
  0xDE, 0x06, 0xA0, 0x02, 0xC0, 0x5A, 0x00, 0x59, 0x02, 0xE1, 0x09, 0x60, 0x06, 0xDD, 0xC2, 0x00,
  // "H" (U+0048)
  0x02, 0xD0, 0x05, 0x90, 0x5A, 0x00, 0x86, 0x08, 0x70, 0x0B, 0x30, 0xB4, 0x00, 0xE0, 0x0E, 0xFF,
  0xFC, 0x02, 0xD0, 0x05, 0x90, 0x5A, 0x00, 0x96, 0x08, 0x70, 0x0C, 0x30, 0xB3, 0x00, 0xE0, 0x00,
  // "I" (U+0049)
  0x00, 0x7F, 0xB0, 0x01, 0xE0, 0x00, 0x4B, 0x00, 0x07, 0x80, 0x00, 0xA5, 0x00, 0x0D, 0x10, 0x01,
  0xE0, 0x00, 0x4B, 0x00, 0x4D, 0xD3, 0x00,
  // "J" (U+004A)
  0x00, 0x02, 0xD0, 0x00, 0x4A, 0x00, 0x07, 0x70, 0x00, 0xA4, 0x00, 0x0D, 0x10, 0x01, 0xE0, 0x00,
  0x4B, 0x00, 0x07, 0x80, 0x00, 0xA5, 0x00, 0x0D, 0x10, 0x03, 0xC0, 0x09, 0xC3, 0x00,
  // "K" (U+004B)
  0x02, 0xD0, 0x2D, 0x10, 0x5A, 0x0C, 0x50, 0x08, 0x68, 0x90, 0x00, 0xB8, 0xC0, 0x00, 0x0E, 0xE8,
  0x00, 0x02, 0xD4, 0xC0, 0x00, 0x5A, 0x0E, 0x10, 0x08, 0x60, 0xB5, 0x00, 0xB3, 0x07, 0x90, 0x00,
  // "L" (U+004C)
  0x02, 0xD0, 0x05, 0xA0, 0x08, 0x60, 0x0B, 0x30, 0x0E, 0x00, 0x2C, 0x00, 0x59, 0x00, 0x86, 0x00,
  0xBE, 0xEA,
  // "M" (U+004D)
  0x02, 0xF5, 0x00, 0x1F, 0x80, 0x5E, 0x60, 0x08, 0xE5, 0x08, 0xB7, 0x00, 0xDD, 0x20, 0xB8, 0x80,
  0x67, 0xE0, 0x0E, 0x49, 0x0C, 0x4B, 0x02, 0xC3, 0xA5, 0x86, 0x80, 0x59, 0x2B, 0xC1, 0x95, 0x08,
  0x51, 0xE9, 0x0D, 0x20, 0xB2, 0x0F, 0x20, 0xE0, 0x00,
  // "N" (U+004E)
  0x02, 0xF3, 0x00, 0xE0, 0x5F, 0x60, 0x3B, 0x08, 0xA9, 0x06, 0x80, 0xB4, 0xD0, 0x95, 0x0E, 0x0D,
  0x1C, 0x22, 0xC0, 0x94, 0xE0, 0x59, 0x06, 0xAB, 0x08, 0x60, 0x3F, 0x80, 0xB3, 0x00, 0xE5, 0x00,
  // "O" (U+004F)
  0x00, 0x4C, 0xD9, 0x00, 0x2D, 0x20, 0xC5, 0x0A, 0x60, 0x08, 0x70, 0xE0, 0x00, 0x87, 0x4C, 0x00,
  0x0A, 0x56, 0x90, 0x00, 0xE1, 0x69, 0x00, 0x5B, 0x03, 0xD0, 0x1D, 0x30, 0x08, 0xDD, 0x50, 0x00,
  // "P" (U+0050)
  0x18, 0xB5, 0x2F, 0xDC, 0x10, 0x59, 0x09, 0x80, 0x86, 0x08, 0x70, 0xB2, 0x2D, 0x20, 0xED, 0xC4,
  0x02, 0xB4, 0x05, 0x08, 0x40, 0x80, 0x64, 0x0B, 0x03, 0x40,
  // "Q" (U+0051)
  0x00, 0x4C, 0xD9, 0x00, 0x2D, 0x20, 0xC4, 0x0A, 0x60, 0x08, 0x70, 0xE0, 0x00, 0x87, 0x4C, 0x00,
  0x0A, 0x56, 0x90, 0x00, 0xE1, 0x69, 0x00, 0x4B, 0x03, 0xD0, 0x1D, 0x30, 0x09, 0xEE, 0x60, 0x00,
  0x00, 0xE2, 0x00, 0x00, 0x08, 0x90, 0x00,
  // "R" (U+0052)
  0x02, 0xFD, 0xB1, 0x05, 0x90, 0x98, 0x08, 0x60, 0x88, 0x0B, 0x32, 0xD3, 0x0E, 0xDE, 0x50, 0x2C,
  0x1E, 0x00, 0x59, 0x0E, 0x10, 0x86, 0x0B, 0x50, 0xB3, 0x07, 0x80,
  // "S" (U+0053)
  0x28, 0x31, 0xBD, 0xD1, 0x28, 0x2B, 0x60, 0x23, 0x0E, 0x01, 0x50, 0xB0, 0x85, 0x81, 0x1D, 0x85,
  0x81, 0x2E, 0x25, 0x0C, 0x04, 0x28, 0x91, 0x20, 0x2E, 0x10, 0x1C, 0xDC, 0x42,
  // "T" (U+0054)
  0x86, 0xCE, 0xFD, 0x70, 0x69, 0x30, 0x90, 0x63, 0x0C, 0x03, 0x30, 0xE3, 0x03, 0x0C, 0x30, 0x60,
  0x93, 0x09, 0x06, 0x30, 0xC0, 0x33,
  // "U" (U+0055)
  0x03, 0xC0, 0x07, 0x80, 0x69, 0x00, 0xA5, 0x09, 0x50, 0x0D, 0x20, 0xC2, 0x01, 0xE0, 0x0E, 0x00,
  0x4B, 0x03, 0xB0, 0x07, 0x70, 0x69, 0x00, 0xB3, 0x05, 0xB0, 0x4D, 0x00, 0x0B, 0xEC, 0x30, 0x00,
  // "V" (U+0056)
  0xE1, 0x00, 0xD2, 0xD1, 0x04, 0xB0, 0xD1, 0x0B, 0x40, 0xC2, 0x2D, 0x00, 0xC2, 0x86, 0x00, 0xB3,
  0xD0, 0x00, 0xB9, 0x80, 0x00, 0xAE, 0x20, 0x00, 0x9A, 0x00, 0x00,
  // "W" (U+0057)
  0xD1, 0x05, 0xC0, 0x0A, 0x5D, 0x10, 0xBC, 0x01, 0xE0, 0xD1, 0x1B, 0xC0, 0x68, 0x0E, 0x07, 0x6B,
  0x0C, 0x20, 0xE0, 0xC1, 0xB3, 0xB0, 0x0E, 0x58, 0x1B, 0x95, 0x00, 0xEA, 0x21, 0xBD, 0x00, 0x0D,
  0xB0, 0x1E, 0x90, 0x00, 0xE6, 0x01, 0xF3, 0x00, 0x00,
  // "X" (U+0058)
  0x00, 0x96, 0x06, 0x90, 0x06, 0x91, 0xD1, 0x00, 0x2B, 0x96, 0x00, 0x00, 0xEC, 0x00, 0x00, 0x1E,
  0x50, 0x00, 0x09, 0xC8, 0x00, 0x03, 0xC4, 0xB0, 0x00, 0xC4, 0x1E, 0x00, 0x6A, 0x00, 0xE1, 0x00,
  // "Y" (U+0059)
  0xD1, 0x07, 0x9B, 0x30, 0xD1, 0x95, 0x77, 0x07, 0x8D, 0x00, 0x4F, 0x60, 0x03, 0xD0, 0x00, 0x5A,
  0x00, 0x08, 0x60, 0x00, 0xB3, 0x00, 0x00,
  // "Z" (U+005A)
  0x28, 0x37, 0xDD, 0xF4, 0x40, 0x40, 0xC5, 0x0D, 0x04, 0x40, 0x70, 0xA4, 0x81, 0x1E, 0x14, 0x0A,
  0x07, 0x40, 0x30, 0xD5, 0x0C, 0x04, 0x48, 0x34, 0xFD, 0xDA, 0x20,
  // "[" (U+005B)
  0x28, 0x21, 0xED, 0x22, 0x05, 0x09, 0x40, 0x80, 0x54, 0x0B, 0x02, 0x40, 0xD4, 0x02, 0x0B, 0x40,
  0x50, 0x84, 0x08, 0x05, 0x40, 0xB0, 0x24, 0x0D, 0x48, 0x22, 0xED, 0x12,
  // "\" (U+005C)
  0xB2, 0x09, 0x40, 0x76, 0x05, 0x80, 0x3A, 0x01, 0xC0, 0x0D, 0x00, 0xC1, 0x0A, 0x30,
  // "]" (U+005D)
  0x28, 0x19, 0xE9, 0x30, 0x70, 0x63, 0x0B, 0x02, 0x30, 0xD3, 0x01, 0x0C, 0x30, 0x50, 0x83, 0x08,
  0x05, 0x30, 0xB0, 0x23, 0x0D, 0x30, 0x20, 0xB2, 0x81, 0x9D, 0x72,
  // "^" (U+005E)
  0x00, 0x5B, 0x00, 0x00, 0xCD, 0x10, 0x06, 0x77, 0x60, 0x0C, 0x02, 0xB0, 0x76, 0x00, 0xC1,
  // "_" (U+005F)
  0xDD, 0xDD,
  // "`" (U+0060)
  0x1E, 0x00, 0x75,
  // "a" (U+0061)
  0x01, 0xCC, 0x76, 0x0B, 0x51, 0xF3, 0x3D, 0x00, 0xE0, 0x68, 0x02, 0xC0, 0x86, 0x06, 0x90, 0x87,
  0x1D, 0x60, 0x3D, 0xA9, 0x30,
  // "b" (U+0062)
  0x01, 0xD0, 0x00, 0x04, 0xA0, 0x00, 0x07, 0x80, 0x00, 0x0A, 0x8D, 0xB0, 0x0D, 0x90, 0xD2, 0x0E,
  0x10, 0xC2, 0x3B, 0x00, 0xE1, 0x69, 0x03, 0xC0, 0x9A, 0x0B, 0x50, 0xC7, 0xD9, 0x00,
  // "c" (U+0063)
  0x02, 0xCD, 0x50, 0xC5, 0x00, 0x3C, 0x00, 0x07, 0x70, 0x00, 0x86, 0x00, 0x08, 0x80, 0x00, 0x1C,
  0xD5, 0x00,
  // "d" (U+0064)
  0x50, 0xE4, 0x02, 0x0C, 0x48, 0x96, 0x59, 0x01, 0xCC, 0x96, 0x0C, 0x51, 0xF3, 0x3C, 0x28, 0xA7,
  0xE0, 0x78, 0x02, 0xC0, 0x96, 0x07, 0x90, 0x87, 0x1D, 0x60, 0x3E, 0xAA, 0x31,
  // "e" (U+0065)
  0x02, 0xCE, 0x50, 0xC4, 0x3A, 0x3B, 0x19, 0x77, 0xEC, 0x70, 0x95, 0x00, 0x08, 0x80, 0x10, 0x1C,
  0xD9, 0x00,
  // "f" (U+0066)
  0x48, 0x18, 0xD4, 0x30, 0x10, 0xD5, 0x05, 0x09, 0x48, 0x23, 0xDE, 0x64, 0x0B, 0x03, 0x50, 0xE5,
  0x01, 0x0D, 0x50, 0x40, 0xA5, 0x08, 0x07, 0x50, 0xB0, 0x35, 0x0E, 0x50, 0x30, 0xC4, 0x81, 0x5D,
  0x44,
  // "g" (U+0067)
  0x01, 0xCD, 0x86, 0x0B, 0x51, 0xF3, 0x3C, 0x00, 0xF0, 0x78, 0x02, 0xC0, 0x96, 0x07, 0x90, 0x87,
  0x1E, 0x60, 0x3E, 0xAB, 0x30, 0x00, 0x0D, 0x00, 0x10, 0x6A, 0x00, 0xCD, 0xB1, 0x00,
  // "h" (U+0068)
  0x01, 0xD0, 0x00, 0x04, 0xB0, 0x00, 0x07, 0x80, 0x00, 0x0A, 0x9D, 0xB0, 0x0D, 0x80, 0xE1, 0x0F,
  0x00, 0xE0, 0x3B, 0x03, 0xC0, 0x68, 0x06, 0x90, 0x95, 0x09, 0x50, 0xC2, 0x0C, 0x20,
  // "i" (U+0069)
  0x01, 0x90, 0x00, 0x00, 0x00, 0x95, 0x0C, 0x20, 0xE0, 0x3B, 0x06, 0x80, 0x95, 0x0C, 0x20,
  // "j" (U+006A)
  0x30, 0x10, 0x97, 0x60, 0x90, 0x53, 0x0C, 0x01, 0x30, 0xE3, 0x03, 0x0B, 0x30, 0x60, 0x83, 0x09,
  0x05, 0x30, 0xC0, 0x23, 0x0E, 0x30, 0x40, 0xA2, 0x81, 0x7D, 0x22,
  // "k" (U+006B)
  0x00, 0xD0, 0x00, 0x3B, 0x00, 0x06, 0x70, 0x00, 0x95, 0x2C, 0x0D, 0x2C, 0x30, 0xDA, 0x60, 0x3F,
  0xE3, 0x06, 0x98, 0x70, 0x95, 0x4B, 0x0C, 0x20, 0xE0,
  // "l" (U+006C)
  0x00, 0xD0, 0x3B, 0x06, 0x70, 0x95, 0x0D, 0x10, 0xE0, 0x3B, 0x06, 0x80, 0x95, 0x0C, 0x20,
  // "m" (U+006D)
  0x09, 0x7D, 0xA6, 0xE8, 0x0C, 0x70, 0xF5, 0x2D, 0x0E, 0x01, 0xD0, 0x3B, 0x3B, 0x04, 0xA0, 0x68,
  0x68, 0x07, 0x70, 0x95, 0x95, 0x0A, 0x40, 0xC2, 0xC2, 0x0D, 0x10, 0xE0,
  // "n" (U+006E)
  0x0A, 0x7D, 0xB0, 0x0D, 0x80, 0xE1, 0x0F, 0x10, 0xE0, 0x3B, 0x03, 0xC0, 0x68, 0x06, 0x90, 0x95,
  0x09, 0x50, 0xC2, 0x0C, 0x20,
  // "o" (U+006F)
  0x01, 0xCD, 0x60, 0xC4, 0x1E, 0x3B, 0x00, 0xE7, 0x70, 0x1E, 0x96, 0x05, 0xA7, 0x70, 0xC4, 0x1C,
  0xD7, 0x00,
  // "p" (U+0070)
  0x28, 0x29, 0x6D, 0xB3, 0x83, 0xC9, 0x0D, 0x22, 0x86, 0xE1, 0x0C, 0x20, 0x3B, 0x28, 0x6E, 0x10,
  0x69, 0x03, 0xC2, 0x83, 0x9A, 0x0B, 0x62, 0x82, 0xC8, 0xD9, 0x30, 0xE5, 0x03, 0x0B, 0x50, 0x60,
  0x85,
  // "q" (U+0071)
  0x01, 0xCD, 0x86, 0x0B, 0x51, 0xF3, 0x3C, 0x00, 0xF0, 0x78, 0x02, 0xC0, 0x96, 0x07, 0x90, 0x87,
  0x1E, 0x60, 0x3E, 0xAB, 0x30, 0x00, 0x0E, 0x00, 0x00, 0x2D, 0x00, 0x00, 0x5A, 0x00,
  // "r" (U+0072)
  0x18, 0x59, 0x7D, 0x10, 0xC8, 0x30, 0xE3, 0x03, 0x0B, 0x30, 0x60, 0x83, 0x09, 0x05, 0x30, 0xC0,
  0x23,
  // "s" (U+0073)
  0x09, 0xDD, 0x13, 0xC0, 0x10, 0x2D, 0x10, 0x00, 0x7C, 0x00, 0x00, 0xA6, 0x01, 0x0A, 0x50, 0xDD,
  0xA0, 0x00,
  // "t" (U+0074)
  0x00, 0x50, 0x04, 0x80, 0x3E, 0xE6, 0x0C, 0x20, 0x0E, 0x00, 0x3B, 0x00, 0x68, 0x00, 0x86, 0x00,
  0x5E, 0x50,
  // "u" (U+0075)
  0x0A, 0x40, 0xA4, 0x0D, 0x10, 0xD1, 0x1E, 0x00, 0xE0, 0x4B, 0x04, 0xB0, 0x78, 0x08, 0x80, 0x87,
  0x2E, 0x50, 0x4E, 0xAB, 0x20,
  // "v" (U+0076)
  0x49, 0x02, 0xD4, 0xA0, 0x97, 0x3A, 0x1E, 0x12, 0xB7, 0x90, 0x2B, 0xE2, 0x01, 0xFB, 0x00, 0x1F,
  0x40, 0x00,
  // "w" (U+0077)
  0x4A, 0x08, 0xB0, 0x77, 0x4A, 0x0C, 0xB0, 0xC2, 0x4A, 0x49, 0xB3, 0xB0, 0x49, 0xA3, 0xB8, 0x50,
  0x4A, 0xB1, 0xBD, 0x00, 0x4E, 0x61, 0xE8, 0x00, 0x4F, 0x12, 0xF3, 0x00,
  // "x" (U+0078)
  0x00, 0xE0, 0x5B, 0x00, 0xB4, 0xD2, 0x00, 0x7D, 0x70, 0x00, 0x5E, 0x00, 0x00, 0xCD, 0x10, 0x08,
  0x69, 0x60, 0x3C, 0x05, 0xA0,
  // "y" (U+0079)
  0x28, 0x34, 0xA0, 0x1D, 0x28, 0x33, 0xB0, 0x77, 0x28, 0x32, 0xB0, 0xD1, 0x28, 0x21, 0xC5, 0x94,
  0x81, 0xCB, 0x24, 0x0D, 0x0B, 0x50, 0xE0, 0x44, 0x01, 0x0D, 0x50, 0x90, 0x63, 0x81, 0x1D, 0xA4,
  // "z" (U+007A)
  0x00, 0xCD, 0xF1, 0x00, 0x06, 0x90, 0x00, 0x1D, 0x10, 0x00, 0x87, 0x00, 0x02, 0xC0, 0x00, 0x0B,
  0x40, 0x00, 0x3F, 0xDD, 0x00,
  // "{" (U+007B)
  0x28, 0x11, 0xC8, 0x20, 0x80, 0x63, 0x0C, 0x01, 0x30, 0xE3, 0x06, 0x09, 0x20, 0xA0, 0xC4, 0x0C,
  0x02, 0x30, 0xC0, 0x13, 0x0D, 0x30, 0x20, 0xD4, 0x0A, 0x08, 0x20,
  // "|" (U+007C)
  0x80, 0x91, 0xD0,
  // "}" (U+007D)
  0x20, 0x80, 0xB4, 0x0D, 0x02, 0x30, 0xD3, 0x01, 0x0C, 0x30, 0x20, 0xC4, 0x0C, 0x0A, 0x20, 0x90,
  0x63, 0x0E, 0x30, 0x20, 0xC3, 0x07, 0x08, 0x28, 0x18, 0xB1, 0x20,
  // "~" (U+007E)
  0x2C, 0xB4, 0x34, 0x41, 0x3B, 0xC1,
  // "¡" (U+00A1)
  0x05, 0x90, 0x66, 0x01, 0x00, 0xB0, 0x1B, 0x04, 0x90, 0x86, 0x0C, 0x30, 0xF1, 0x04, 0x00,
  // "¢" (U+00A2)
  0x30, 0x50, 0x42, 0x85, 0x6E, 0xC0, 0x3D, 0x12, 0x0A, 0x05, 0x30, 0xE3, 0x01, 0x0E, 0x48, 0x1E,
  0x11, 0x28, 0x15, 0xEC, 0x30, 0xA2,
  // "£" (U+00A3)
  0x38, 0x23, 0xCD, 0x63, 0x82, 0xC3, 0x01, 0x20, 0x10, 0xD5, 0x04, 0x0A, 0x48, 0x35, 0xEE, 0xD1,
  0x30, 0xA0, 0x45, 0x0D, 0x01, 0x40, 0x50, 0xA4, 0x84, 0x2F, 0xDD, 0xD2, 0x10,
  // "¤" (U+00A4)
  0x01, 0x00, 0x01, 0x1C, 0xBD, 0xA8, 0x0A, 0x30, 0x93, 0x0B, 0x00, 0x46, 0x0A, 0x30, 0xA3, 0x1B,
  0xBD, 0xA8, 0x01, 0x00, 0x01,
  // "¥" (U+00A5)
  0x08, 0x60, 0x5A, 0x06, 0x80, 0xC2, 0x04, 0x94, 0xA0, 0x03, 0xBB, 0x20, 0x01, 0xEA, 0x00, 0x2D,
  0xFD, 0x60, 0x7D, 0xFD, 0x10, 0x06, 0x80, 0x00, 0x08, 0x60, 0x00,
  // "¦" (U+00A6)
  0x80, 0x1D, 0x38, 0x01, 0xD0,
  // "§" (U+00A7)
  0x01, 0xBD, 0x90, 0x76, 0x01, 0x07, 0x90, 0x00, 0x5C, 0xA0, 0x2B, 0x0B, 0x32, 0xD3, 0xC1, 0x07,
  0xF6, 0x00, 0x07, 0x80, 0x20, 0x68, 0x0B, 0xDB, 0x10,
  // "¨" (U+00A8)
  0x72, 0x91,
  // "©" (U+00A9)
  0x00, 0x2A, 0xDD, 0x92, 0x00, 0x03, 0xC4, 0x00, 0x4C, 0x20, 0x0B, 0x13, 0xCD, 0x62, 0xB0, 0x37,
  0x0D, 0x30, 0x10, 0x82, 0x54, 0x2B, 0x00, 0x00, 0x55, 0x54, 0x2B, 0x00, 0x00, 0x55, 0x37, 0x0D,
  0x20, 0x10, 0x82, 0x0B, 0x13, 0xCD, 0x51, 0xB0, 0x03, 0xC4, 0x00, 0x4C, 0x30, 0x00, 0x2A, 0xDD,
  0xA2, 0x00,
  // "ª" (U+00AA)
  0x05, 0xBB, 0x10, 0xB0, 0xB0, 0x19, 0x1A, 0x00, 0xB9, 0x70,
  // "«" (U+00AB)
  0x00, 0x50, 0x40, 0x78, 0x5A, 0x5A, 0x3C, 0x04, 0xA2, 0xC0, 0x0C, 0x1A, 0x30, 0x10, 0x10,
  // "¬" (U+00AC)
  0x5D, 0xDD, 0xE4, 0x00, 0x00, 0x84, 0x00, 0x00, 0x84, 0x00, 0x00, 0x32,
  // "®" (U+00AE)
  0x00, 0x2A, 0xDD, 0x92, 0x00, 0x03, 0xC4, 0x00, 0x4C, 0x20, 0x0B, 0x18, 0xDC, 0x22, 0xB0, 0x37,
  0x09, 0x35, 0x90, 0x82, 0x54, 0x09, 0x35, 0x90, 0x55, 0x54, 0x09, 0xEE, 0x10, 0x55, 0x37, 0x09,
  0x3A, 0x40, 0x82, 0x0B, 0x18, 0x32, 0xB2, 0xB0, 0x03, 0xC4, 0x00, 0x4C, 0x30, 0x00, 0x2A, 0xDD,
  0xA2, 0x00,
  // "¯" (U+00AF)
  0xAD, 0xDD, 0xD0,
  // "°" (U+00B0)
  0x0A, 0xD5, 0x57, 0x0B, 0x57, 0x0B, 0x0A, 0xD5,
  // "±" (U+00B1)
  0x20, 0x06, 0x40, 0x06, 0x40, 0x06, 0x28, 0x45, 0xDE, 0xED, 0x52, 0x00, 0x64, 0x00, 0x67, 0x18,
  0x45, 0xDD, 0xDD, 0x50,
  // "²" (U+00B2)
  0x03, 0xBA, 0x00, 0x10, 0xB1, 0x00, 0x1B, 0x00, 0x0A, 0x20, 0x0A, 0x30, 0x04, 0xCB, 0x50,
  // "³" (U+00B3)
  0x03, 0xB9, 0x00, 0x10, 0xB1, 0x00, 0x0B, 0x00, 0x3D, 0x40, 0x00, 0x39, 0x03, 0xBB, 0x30,
  // "´" (U+00B4)
  0x09, 0x75, 0x80,
  // "µ" (U+00B5)
  0x28, 0x3A, 0x40, 0x95, 0x28, 0x3D, 0x10, 0xC2, 0x20, 0xE2, 0x0E, 0x28, 0x33, 0xB0, 0x3B, 0x28,
  0x36, 0x80, 0x78, 0x28, 0x39, 0x71, 0xD5, 0x28, 0x3C, 0xDA, 0xB2, 0x20, 0xE5, 0x03, 0x0B, 0x50,
  0x60, 0x85,
  // "¶" (U+00B6)
  0x3D, 0xFD, 0x8B, 0xFE, 0x28, 0xEF, 0xE2, 0x8E, 0xFE, 0x28, 0xCF, 0xE2, 0x85, 0xFE, 0x28, 0x00,
  0xA2, 0x80, 0x0A, 0x28, 0x00, 0xA2, 0x80, 0x0A, 0x28, 0x00, 0xA2, 0x80, 0x03, 0x02,
  // "·" (U+00B7)
  0x75, 0xB4,
  // "¸" (U+00B8)
  0x01, 0x01, 0xB0, 0x09, 0x49, 0x90,
  // "¹" (U+00B9)
  0x09, 0xA3, 0x76, 0x08, 0x30, 0xB0, 0x0B, 0x00,
  // "º" (U+00BA)
  0x05, 0xB9, 0x0B, 0x0B, 0x19, 0x0A, 0x0B, 0xA3,
  // "»" (U+00BB)
  0x04, 0x05, 0x00, 0xD1, 0xB2, 0x08, 0x75, 0xA1, 0xC3, 0xB5, 0xB4, 0x86, 0x01, 0x01, 0x00,
  // "¼" (U+00BC)
  0x00, 0x00, 0x00, 0xB1, 0x00, 0x9A, 0x08, 0x40, 0x03, 0x76, 0x39, 0x00, 0x00, 0x84, 0xB0, 0x01,
  0x00, 0xBA, 0x30, 0x2E, 0x00, 0xF7, 0x00, 0x9B, 0x01, 0xB0, 0x08, 0x48, 0x0A, 0x20, 0x2B, 0xCB,
  0x75, 0x00, 0x00, 0x92,
  // "½" (U+00BD)
  0x00, 0x00, 0x00, 0xB1, 0x00, 0x09, 0xA0, 0x84, 0x00, 0x03, 0x76, 0x39, 0x00, 0x00, 0x08, 0x4B,
  0x3B, 0xA0, 0x00, 0xBA, 0x31, 0x0B, 0x10, 0x0F, 0x70, 0x01, 0xB0, 0x01, 0xB0, 0x00, 0xA2, 0x00,
  0xA2, 0x00, 0xA3, 0x00, 0x75, 0x00, 0x4C, 0xB5, 0x00,
  // "¾" (U+00BE)
  0x03, 0xB9, 0x00, 0x0B, 0x10, 0x10, 0xB1, 0x08, 0x40, 0x00, 0x0B, 0x03, 0x90, 0x00, 0x3D, 0x41,
  0xB0, 0x10, 0x00, 0x39, 0x93, 0x2E, 0x03, 0xBB, 0x87, 0x09, 0xB0, 0x00, 0x1B, 0x08, 0x48, 0x00,
  0x0A, 0x22, 0xBC, 0xB0, 0x07, 0x50, 0x00, 0x92, 0x00,
  // "¿" (U+00BF)
  0x30, 0x07, 0x30, 0x80, 0x43, 0x02, 0x40, 0xC3, 0x09, 0x05, 0x20, 0x70, 0x82, 0x03, 0x0C, 0x38,
  0x75, 0xA0, 0x20, 0x1D, 0xD9, 0x10,
  // "À" (U+00C0)
  0x30, 0x10, 0xE5, 0x07, 0x05, 0x72, 0x81, 0x1F, 0x53, 0x81, 0x7C, 0x63, 0x81, 0xC7, 0x62, 0x82,
  0x58, 0x67, 0x28, 0xA0, 0xC2, 0x68, 0x03, 0xFE, 0xE8, 0x0A, 0x50, 0x69, 0x1D, 0x28, 0x25, 0x98,
  0x82, 0x05, 0x0A,
  // "Á" (U+00C1)
  0x50, 0x90, 0x74, 0x05, 0x08, 0x74, 0x81, 0x1F, 0x54, 0x81, 0x7C, 0x64, 0x81, 0xC7, 0x63, 0x82,
  0x58, 0x67, 0x38, 0x2C, 0x26, 0x82, 0x83, 0x3F, 0xEE, 0x82, 0x86, 0xA5, 0x06, 0x90, 0x1D, 0x28,
  0x35, 0x90, 0x88, 0x20, 0x50, 0xA1,
  // "Â" (U+00C2)
  0x40, 0x70, 0xD4, 0x82, 0x47, 0x65, 0x73, 0x81, 0x1F, 0x54, 0x81, 0x7C, 0x64, 0x81, 0xC7, 0x63,
  0x82, 0x58, 0x67, 0x38, 0x2C, 0x26, 0x82, 0x83, 0x3F, 0xEE, 0x82, 0x86, 0xA5, 0x06, 0x90, 0x1D,
  0x28, 0x35, 0x90, 0x88, 0x20, 0x50, 0xA1,
  // "Ã" (U+00C3)
  0x38, 0x22, 0xD6, 0x93, 0x82, 0x72, 0xA9, 0x73, 0x81, 0x1F, 0x54, 0x81, 0x7C, 0x64, 0x81, 0xC7,
  0x63, 0x82, 0x58, 0x67, 0x38, 0x2C, 0x26, 0x82, 0x83, 0x3F, 0xEE, 0x82, 0x86, 0xA5, 0x06, 0x90,
  0x1D, 0x28, 0x35, 0x90, 0x88, 0x20, 0x50, 0xA1,
  // "Ä" (U+00C4)
  0x38, 0x27, 0x29, 0x17, 0x38, 0x11, 0xF5, 0x48, 0x17, 0xC6, 0x48, 0x1C, 0x76, 0x38, 0x25, 0x86,
  0x73, 0x82, 0xC2, 0x68, 0x28, 0x33, 0xFE, 0xE8, 0x28, 0x6A, 0x50, 0x69, 0x01, 0xD2, 0x83, 0x59,
  0x08, 0x82, 0x05, 0x0A, 0x10,
  // "Å" (U+00C5)
  0x38, 0x11, 0x98, 0x48, 0x25, 0x48, 0x13, 0x81, 0x19, 0x87, 0x48, 0x11, 0xF5, 0x48, 0x17, 0xC6,
  0x48, 0x1C, 0x76, 0x38, 0x25, 0x86, 0x73, 0x82, 0xC2, 0x68, 0x28, 0x33, 0xFE, 0xE8, 0x28, 0x6A,
  0x50, 0x69, 0x01, 0xD2, 0x83, 0x59, 0x08, 0x82, 0x05, 0x0A, 0x10,
  // "Æ" (U+00C6)
  0x48, 0x38, 0xFE, 0xDD, 0x38, 0x21, 0xDA, 0x55, 0x82, 0x86, 0xD2, 0x48, 0x11, 0xD1, 0x95, 0x89,
  0x38, 0x64, 0xFD, 0xD1, 0x01, 0xED, 0xE8, 0x48, 0x38, 0x60, 0xA5, 0x30, 0x10, 0xD2, 0x0D, 0x02,
  0x38, 0x68, 0x80, 0x1F, 0xDD, 0x51,
  // "Ç" (U+00C7)
  0x28, 0x93, 0x3B, 0xDC, 0x01, 0xE4, 0x01, 0x09, 0x74, 0x0E, 0x40, 0x40, 0xB4, 0x06, 0x09, 0x40,
  0x50, 0x94, 0x81, 0x2D, 0x14, 0x82, 0x7F, 0xD4, 0x20, 0x10, 0xB5, 0x09, 0x04, 0x30, 0x09, 0x30,
  // "È" (U+00C8)
  0x20, 0x10, 0xE5, 0x07, 0x05, 0x71, 0x86, 0x2F, 0xDD, 0x40, 0x5A, 0x40, 0x80, 0x74, 0x0B, 0x04,
  0x48, 0x5E, 0xDD, 0x50, 0x2D, 0x40, 0x50, 0xA4, 0x08, 0x06, 0x48, 0x2B, 0xED, 0x92,
  // "É" (U+00C9)
  0x40, 0x90, 0x73, 0x05, 0x08, 0x71, 0x86, 0x2F, 0xDD, 0x40, 0x5A, 0x40, 0x80, 0x74, 0x0B, 0x04,
  0x48, 0x5E, 0xDD, 0x50, 0x2D, 0x40, 0x50, 0xA4, 0x08, 0x06, 0x48, 0x2B, 0xED, 0x92,
  // "Ê" (U+00CA)
  0x30, 0x70, 0xD3, 0x82, 0x47, 0x65, 0x78, 0x62, 0xFD, 0xD4, 0x05, 0xA4, 0x08, 0x07, 0x40, 0xB0,
  0x44, 0x85, 0xED, 0xD5, 0x02, 0xD4, 0x05, 0x0A, 0x40, 0x80, 0x64, 0x82, 0xBE, 0xD9, 0x20,
  // "Ë" (U+00CB)
  0x28, 0x27, 0x29, 0x17, 0x86, 0x2F, 0xDD, 0x40, 0x5A, 0x40, 0x80, 0x74, 0x0B, 0x04, 0x48, 0x5E,
  0xDD, 0x50, 0x2D, 0x40, 0x50, 0xA4, 0x08, 0x06, 0x48, 0x2B, 0xED, 0x92,
  // "Ì" (U+00CC)
  0x00, 0x1E, 0x00, 0x00, 0x75, 0x00, 0x00, 0x00, 0x07, 0xFB, 0x00, 0x1E, 0x00, 0x04, 0xB0, 0x00,
  0x78, 0x00, 0x0A, 0x50, 0x00, 0xD1, 0x00, 0x1E, 0x00, 0x04, 0xB0, 0x04, 0xDD, 0x30,
  // "Í" (U+00CD)
  0x40, 0x90, 0x73, 0x05, 0x08, 0x72, 0x81, 0x7F, 0xB3, 0x01, 0x0E, 0x40, 0x40, 0xB4, 0x07, 0x08,
  0x40, 0xA0, 0x54, 0x0D, 0x01, 0x30, 0x10, 0xE4, 0x04, 0x0B, 0x38, 0x24, 0xDD, 0x32,
  // "Î" (U+00CE)
  0x30, 0x70, 0xD3, 0x82, 0x47, 0x65, 0x71, 0x81, 0x7F, 0xB3, 0x01, 0x0E, 0x40, 0x40, 0xB4, 0x07,
  0x08, 0x40, 0xA0, 0x54, 0x0D, 0x01, 0x30, 0x10, 0xE4, 0x04, 0x0B, 0x38, 0x24, 0xDD, 0x32,
  // "Ï" (U+00CF)
  0x28, 0x27, 0x29, 0x17, 0x18, 0x17, 0xFB, 0x30, 0x10, 0xE4, 0x04, 0x0B, 0x40, 0x70, 0x84, 0x0A,
  0x05, 0x40, 0xD0, 0x13, 0x01, 0x0E, 0x40, 0x40, 0xB3, 0x82, 0x4D, 0xD3, 0x20,
  // "Ð" (U+00D0)
  0x02, 0xFD, 0xC3, 0x05, 0x90, 0x6C, 0x08, 0x60, 0x0F, 0x0B, 0x30, 0x0F, 0x8F, 0xD4, 0x2E, 0x2D,
  0x00, 0x6A, 0x5A, 0x00, 0xC4, 0x86, 0x09, 0xA0, 0xBE, 0xD8, 0x00,
  // "Ñ" (U+00D1)
  0x00, 0x2D, 0x69, 0x00, 0x07, 0x2A, 0x90, 0x00, 0x00, 0x00, 0x00, 0x2F, 0x30, 0x0E, 0x05, 0xF6,
  0x03, 0xB0, 0x8A, 0x90, 0x68, 0x0B, 0x4D, 0x09, 0x50, 0xE0, 0xD1, 0xC2, 0x2C, 0x09, 0x4E, 0x05,
  0x90, 0x6A, 0xB0, 0x86, 0x03, 0xF8, 0x0B, 0x30, 0x0E, 0x50,
  // "Ò" (U+00D2)
  0x30, 0x10, 0xE6, 0x07, 0x05, 0x73, 0x82, 0x4C, 0xD9, 0x28, 0x72, 0xD2, 0x0C, 0x50, 0xA6, 0x28,
  0x28, 0x70, 0xE3, 0x82, 0x87, 0x4C, 0x38, 0x2A, 0x56, 0x93, 0x82, 0xE1, 0x69, 0x28, 0x75, 0xB0,
  0x3D, 0x01, 0xD3, 0x28, 0x28, 0xDD, 0x52,
  // "Ó" (U+00D3)
  0x50, 0x90, 0x74, 0x05, 0x08, 0x73, 0x82, 0x4C, 0xD9, 0x28, 0x72, 0xD2, 0x0C, 0x50, 0xA6, 0x28,
  0x28, 0x70, 0xE3, 0x82, 0x87, 0x4C, 0x38, 0x2A, 0x56, 0x93, 0x82, 0xE1, 0x69, 0x28, 0x75, 0xB0,
  0x3D, 0x01, 0xD3, 0x28, 0x28, 0xDD, 0x52,
  // "Ô" (U+00D4)
  0x40, 0x70, 0xD4, 0x82, 0x47, 0x65, 0x72, 0x82, 0x4C, 0xD9, 0x28, 0x72, 0xD2, 0x0C, 0x50, 0xA6,
  0x28, 0x28, 0x70, 0xE3, 0x82, 0x87, 0x4C, 0x38, 0x2A, 0x56, 0x93, 0x82, 0xE1, 0x69, 0x28, 0x75,
  0xB0, 0x3D, 0x01, 0xD3, 0x28, 0x28, 0xDD, 0x52,
  // "Õ" (U+00D5)
  0x28, 0x22, 0xD6, 0x93, 0x82, 0x72, 0xA9, 0x73, 0x82, 0x4C, 0xD9, 0x28, 0x72, 0xD2, 0x0C, 0x50,
  0xA6, 0x28, 0x28, 0x70, 0xE3, 0x82, 0x87, 0x4C, 0x38, 0x2A, 0x56, 0x93, 0x82, 0xE1, 0x69, 0x28,
  0x75, 0xB0, 0x3D, 0x01, 0xD3, 0x28, 0x28, 0xDD, 0x52,
  // "Ö" (U+00D6)
  0x38, 0x27, 0x29, 0x17, 0x28, 0x24, 0xCD, 0x92, 0x87, 0x2D, 0x20, 0xC5, 0x0A, 0x62, 0x82, 0x87,
  0x0E, 0x38, 0x28, 0x74, 0xC3, 0x82, 0xA5, 0x69, 0x38, 0x2E, 0x16, 0x92, 0x87, 0x5B, 0x03, 0xD0,
  0x1D, 0x32, 0x82, 0x8D, 0xD5, 0x20,
  // "×" (U+00D7)
  0x03, 0x00, 0x40, 0x1B, 0x45, 0xB0, 0x01, 0xCC, 0x00, 0x05, 0xBC, 0x40, 0x1B, 0x01, 0xB1,
  // "Ø" (U+00D8)
  0x60, 0x22, 0x8F, 0x14, 0xCD, 0xAA, 0x02, 0xD2, 0x0E, 0x50, 0xA6, 0x07, 0xD7, 0x0E, 0x02, 0xA8,
  0x74, 0xC0, 0xB1, 0xA5, 0x6A, 0x75, 0x0E, 0x16, 0xCA, 0x04, 0xB0, 0x3F, 0x21, 0xD3, 0x07, 0xBD,
  0xD4, 0x20, 0x36,
  // "Ù" (U+00D9)
  0x30, 0x10, 0xE6, 0x07, 0x05, 0x72, 0x03, 0x0C, 0x28, 0x37, 0x80, 0x69, 0x28, 0x3A, 0x50, 0x95,
  0x28, 0x6D, 0x20, 0xC2, 0x01, 0xE2, 0x0E, 0x28, 0x34, 0xB0, 0x3B, 0x28, 0x37, 0x70, 0x69, 0x28,
  0x6B, 0x30, 0x5B, 0x04, 0xD3, 0x82, 0xBE, 0xC3, 0x20,
  // "Ú" (U+00DA)
  0x40, 0x90, 0x74, 0x05, 0x08, 0x73, 0x03, 0x0C, 0x28, 0x37, 0x80, 0x69, 0x28, 0x3A, 0x50, 0x95,
  0x28, 0x6D, 0x20, 0xC2, 0x01, 0xE2, 0x0E, 0x28, 0x34, 0xB0, 0x3B, 0x28, 0x37, 0x70, 0x69, 0x28,
  0x6B, 0x30, 0x5B, 0x04, 0xD3, 0x82, 0xBE, 0xC3, 0x20,
  // "Û" (U+00DB)
  0x00, 0x07, 0xD0, 0x00, 0x04, 0x76, 0x50, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x78, 0x06, 0x90,
  0x0A, 0x50, 0x95, 0x00, 0xD2, 0x0C, 0x20, 0x1E, 0x00, 0xE0, 0x04, 0xB0, 0x3B, 0x00, 0x77, 0x06,
  0x90, 0x0B, 0x30, 0x5B, 0x04, 0xD0, 0x00, 0xBE, 0xC3, 0x00,
  // "Ü" (U+00DC)
  0x00, 0x07, 0x29, 0x10, 0x00, 0x00, 0x00, 0x03, 0xC0, 0x07, 0x80, 0x69, 0x00, 0xA5, 0x09, 0x50,
  0x0D, 0x20, 0xC2, 0x01, 0xE0, 0x0E, 0x00, 0x4B, 0x03, 0xB0, 0x07, 0x70, 0x69, 0x00, 0xB3, 0x05,
  0xB0, 0x4D, 0x00, 0x0B, 0xEC, 0x30, 0x00,
  // "Ý" (U+00DD)
  0x00, 0x09, 0x70, 0x05, 0x80, 0x00, 0x00, 0x0D, 0x10, 0x79, 0xB3, 0x0D, 0x19, 0x57, 0x70, 0x78,
  0xD0, 0x04, 0xF6, 0x00, 0x3D, 0x00, 0x05, 0xA0, 0x00, 0x86, 0x00, 0x0B, 0x30, 0x00,
  // "Þ" (U+00DE)
  0x02, 0xC0, 0x00, 0x05, 0xED, 0x70, 0x08, 0x51, 0xE2, 0x0B, 0x20, 0xC3, 0x0E, 0x00, 0xE1, 0x2C,
  0x08, 0xA0, 0x5E, 0xD9, 0x00, 0x86, 0x00, 0x00, 0xB3, 0x00, 0x00,
  // "ß" (U+00DF)
  0x48, 0x27, 0xDD, 0x23, 0x83, 0x2C, 0x09, 0x63, 0x83, 0x77, 0x0C, 0x33, 0x82, 0xA4, 0x98, 0x48,
  0x1D, 0x3D, 0x48, 0x21, 0xD2, 0xD4, 0x83, 0x4A, 0x0A, 0x83, 0x83, 0x77, 0x03, 0xC3, 0x83, 0xA5,
  0x04, 0xB3, 0x83, 0xD6, 0xDC, 0x32, 0x01, 0x0D, 0x60, 0x50, 0x95, 0x81, 0x7D, 0x25,
  // "à" (U+00E0)
  0x20, 0x10, 0xE5, 0x07, 0x05, 0x71, 0x89, 0x31, 0xCC, 0x76, 0x0B, 0x51, 0xF3, 0x3D, 0x28, 0xA7,
  0xE0, 0x68, 0x02, 0xC0, 0x86, 0x06, 0x90, 0x87, 0x1D, 0x60, 0x3D, 0xA9, 0x31,
  // "á" (U+00E1)
  0x40, 0x90, 0x73, 0x05, 0x08, 0x71, 0x89, 0x31, 0xCC, 0x76, 0x0B, 0x51, 0xF3, 0x3D, 0x28, 0xA7,
  0xE0, 0x68, 0x02, 0xC0, 0x86, 0x06, 0x90, 0x87, 0x1D, 0x60, 0x3D, 0xA9, 0x31,
  // "â" (U+00E2)
  0x00, 0x07, 0xD0, 0x00, 0x47, 0x65, 0x00, 0x00, 0x00, 0x01, 0xCC, 0x76, 0x0B, 0x51, 0xF3, 0x3D,
  0x00, 0xE0, 0x68, 0x02, 0xC0, 0x86, 0x06, 0x90, 0x87, 0x1D, 0x60, 0x3D, 0xA9, 0x30,
  // "ã" (U+00E3)
  0x00, 0x2D, 0x69, 0x00, 0x72, 0xA9, 0x00, 0x00, 0x00, 0x01, 0xCC, 0x76, 0x0B, 0x51, 0xF3, 0x3D,
  0x00, 0xE0, 0x68, 0x02, 0xC0, 0x86, 0x06, 0x90, 0x87, 0x1D, 0x60, 0x3D, 0xA9, 0x30,
  // "ä" (U+00E4)
  0x00, 0x72, 0x91, 0x00, 0x00, 0x00, 0x01, 0xCC, 0x76, 0x0B, 0x51, 0xF3, 0x3D, 0x00, 0xE0, 0x68,
  0x02, 0xC0, 0x86, 0x06, 0x90, 0x87, 0x1D, 0x60, 0x3D, 0xA9, 0x30,
  // "å" (U+00E5)
  0x00, 0x19, 0x80, 0x00, 0x54, 0x81, 0x00, 0x19, 0x80, 0x00, 0x00, 0x00, 0x01, 0xCC, 0x76, 0x0B,
  0x51, 0xF3, 0x3D, 0x00, 0xE0, 0x68, 0x02, 0xC0, 0x86, 0x06, 0x90, 0x87, 0x1D, 0x60, 0x3D, 0xA9,
  0x30,
  // "æ" (U+00E6)
  0x02, 0xCC, 0x99, 0xE8, 0x0C, 0x53, 0xF7, 0x0D, 0x2C, 0x01, 0xE0, 0x7A, 0x78, 0x04, 0xED, 0x80,
  0x86, 0x08, 0x80, 0x00, 0x87, 0x2E, 0xB0, 0x10, 0x3E, 0xAB, 0x8D, 0xC0,
  // "ç" (U+00E7)
  0x18, 0x52, 0xCD, 0x50, 0xC5, 0x20, 0x30, 0xC3, 0x00, 0x73, 0x08, 0x06, 0x30, 0x08, 0x38, 0x51,
  0xED, 0x50, 0x1B, 0x40, 0x90, 0x42, 0x00, 0x93,
  // "è" (U+00E8)
  0x10, 0x10, 0xE4, 0x07, 0x05, 0x78, 0xA3, 0x2C, 0xE5, 0x0C, 0x43, 0xA3, 0xB1, 0x97, 0x7E, 0xC7,
  0x09, 0x53, 0x87, 0x88, 0x01, 0x01, 0xCD, 0x91,
  // "é" (U+00E9)
  0x30, 0x90, 0x72, 0x05, 0x08, 0x78, 0xA3, 0x2C, 0xE5, 0x0C, 0x43, 0xA3, 0xB1, 0x97, 0x7E, 0xC7,
  0x09, 0x53, 0x87, 0x88, 0x01, 0x01, 0xCD, 0x91,
  // "ê" (U+00EA)
  0x00, 0x7D, 0x00, 0x47, 0x65, 0x00, 0x00, 0x00, 0x2C, 0xE5, 0x0C, 0x43, 0xA3, 0xB1, 0x97, 0x7E,
  0xC7, 0x09, 0x50, 0x00, 0x88, 0x01, 0x01, 0xCD, 0x90,
  // "ë" (U+00EB)
  0x00, 0x72, 0x91, 0x00, 0x00, 0x00, 0x02, 0xCE, 0x50, 0x0C, 0x43, 0xA0, 0x3B, 0x19, 0x70, 0x7E,
  0xC7, 0x00, 0x95, 0x00, 0x00, 0x88, 0x01, 0x00, 0x1C, 0xD9, 0x00,
  // "ì" (U+00EC)
  0x1E, 0x00, 0x75, 0x00, 0x00, 0x95, 0x0C, 0x20, 0xE0, 0x3B, 0x06, 0x80, 0x95, 0x0C, 0x20,
  // "í" (U+00ED)
  0x00, 0x97, 0x05, 0x80, 0x00, 0x00, 0x09, 0x50, 0x0C, 0x20, 0x0E, 0x00, 0x3B, 0x00, 0x68, 0x00,
  0x95, 0x00, 0xC2, 0x00,
  // "î" (U+00EE)
  0x07, 0xD0, 0x47, 0x65, 0x00, 0x00, 0x09, 0x50, 0x0C, 0x20, 0x0E, 0x00, 0x3B, 0x00, 0x68, 0x00,
  0x95, 0x00, 0xC2, 0x00,
  // "ï" (U+00EF)
  0x18, 0x27, 0x29, 0x16, 0x09, 0x05, 0x30, 0xC0, 0x23, 0x0E, 0x30, 0x30, 0xB3, 0x06, 0x08, 0x30,
  0x90, 0x53, 0x0C, 0x02, 0x30,
  // "ð" (U+00F0)
  0x00, 0x51, 0x42, 0x00, 0x5E, 0x80, 0x00, 0xA8, 0x70, 0x00, 0x00, 0xC0, 0x04, 0xDA, 0xD0, 0x2D,
  0x15, 0xE0, 0x87, 0x02, 0xC0, 0xB4, 0x05, 0x90, 0xA5, 0x0C, 0x20, 0x3D, 0xD5, 0x00,
  // "ñ" (U+00F1)
  0x02, 0xD6, 0x90, 0x07, 0x2A, 0x90, 0x00, 0x00, 0x00, 0x0A, 0x7D, 0xB0, 0x0D, 0x80, 0xE1, 0x0F,
  0x10, 0xE0, 0x3B, 0x03, 0xC0, 0x68, 0x06, 0x90, 0x95, 0x09, 0x50, 0xC2, 0x0C, 0x20,
  // "ò" (U+00F2)
  0x00, 0x1E, 0x00, 0x00, 0x75, 0x00, 0x00, 0x00, 0x1C, 0xD6, 0x0C, 0x41, 0xE3, 0xB0, 0x0E, 0x77,
  0x01, 0xE9, 0x60, 0x5A, 0x77, 0x0C, 0x41, 0xCD, 0x70,
  // "ó" (U+00F3)
  0x00, 0x09, 0x70, 0x05, 0x80, 0x00, 0x00, 0x00, 0x1C, 0xD6, 0x0C, 0x41, 0xE3, 0xB0, 0x0E, 0x77,
  0x01, 0xE9, 0x60, 0x5A, 0x77, 0x0C, 0x41, 0xCD, 0x70,
  // "ô" (U+00F4)
  0x00, 0x7D, 0x00, 0x47, 0x65, 0x00, 0x00, 0x00, 0x1C, 0xD6, 0x0C, 0x41, 0xE3, 0xB0, 0x0E, 0x77,
  0x01, 0xE9, 0x60, 0x5A, 0x77, 0x0C, 0x41, 0xCD, 0x70,
  // "õ" (U+00F5)
  0x02, 0xD6, 0x90, 0x72, 0xA9, 0x00, 0x00, 0x00, 0x1C, 0xD6, 0x0C, 0x41, 0xE3, 0xB0, 0x0E, 0x77,
  0x01, 0xE9, 0x60, 0x5A, 0x77, 0x0C, 0x41, 0xCD, 0x70,
  // "ö" (U+00F6)
  0x00, 0x72, 0x91, 0x00, 0x00, 0x00, 0x01, 0xCD, 0x60, 0x0C, 0x41, 0xE0, 0x3B, 0x00, 0xE0, 0x77,
  0x01, 0xE0, 0x96, 0x05, 0xA0, 0x77, 0x0C, 0x40, 0x1C, 0xD7, 0x00,
  // "÷" (U+00F7)
  0x20, 0x07, 0x40, 0x60, 0x52, 0x84, 0x5D, 0xDD, 0xD5, 0x71, 0x06, 0x05, 0x40, 0x07, 0x20,
  // "ø" (U+00F8)
  0x48, 0xD0, 0x11, 0x01, 0xCD, 0xC2, 0x0C, 0x45, 0xE0, 0x3B, 0x1B, 0xE0, 0x77, 0xA3, 0xE0, 0x9B,
  0x74, 0xA0, 0x7D, 0x0C, 0x30, 0x8C, 0xD6, 0x20, 0x45,
  // "ù" (U+00F9)
  0x20, 0x10, 0xE5, 0x07, 0x05, 0x71, 0x89, 0x3A, 0x40, 0xA4, 0x0D, 0x10, 0xD1, 0x1E, 0x28, 0xA7,
  0xE0, 0x4B, 0x04, 0xB0, 0x78, 0x08, 0x80, 0x87, 0x2E, 0x50, 0x4E, 0xAB, 0x21,
  // "ú" (U+00FA)
  0x40, 0x90, 0x73, 0x05, 0x08, 0x71, 0x89, 0x3A, 0x40, 0xA4, 0x0D, 0x10, 0xD1, 0x1E, 0x28, 0xA7,
  0xE0, 0x4B, 0x04, 0xB0, 0x78, 0x08, 0x80, 0x87, 0x2E, 0x50, 0x4E, 0xAB, 0x21,
  // "û" (U+00FB)
  0x00, 0x07, 0xD0, 0x00, 0x47, 0x65, 0x00, 0x00, 0x00, 0x0A, 0x40, 0xA4, 0x0D, 0x10, 0xD1, 0x1E,
  0x00, 0xE0, 0x4B, 0x04, 0xB0, 0x78, 0x08, 0x80, 0x87, 0x2E, 0x50, 0x4E, 0xAB, 0x20,
  // "ü" (U+00FC)
  0x00, 0x72, 0x91, 0x00, 0x00, 0x00, 0x0A, 0x40, 0xA4, 0x0D, 0x10, 0xD1, 0x1E, 0x00, 0xE0, 0x4B,
  0x04, 0xB0, 0x78, 0x08, 0x80, 0x87, 0x2E, 0x50, 0x4E, 0xAB, 0x20,
  // "ý" (U+00FD)
  0x50, 0x90, 0x74, 0x05, 0x08, 0x73, 0x83, 0x4A, 0x01, 0xD2, 0x83, 0x3B, 0x07, 0x72, 0x83, 0x2B,
  0x0D, 0x12, 0x82, 0x1C, 0x59, 0x48, 0x1C, 0xB2, 0x40, 0xD0, 0xB5, 0x0E, 0x04, 0x40, 0x10, 0xD5,
  0x09, 0x06, 0x38, 0x11, 0xDA, 0x40,
  // "þ" (U+00FE)
  0x30, 0xD5, 0x03, 0x0B, 0x50, 0x60, 0x85, 0x82, 0x98, 0xDB, 0x38, 0x3C, 0x90, 0xD2, 0x28, 0x6E,
  0x10, 0xC2, 0x03, 0xB2, 0x86, 0xE1, 0x06, 0x90, 0x3C, 0x28, 0x39, 0xA0, 0xB5, 0x28, 0x2C, 0x8D,
  0x93, 0x0E, 0x50, 0x30, 0xB5, 0x06, 0x08, 0x50,
  // "ÿ" (U+00FF)
  0x38, 0x27, 0x29, 0x17, 0x28, 0x34, 0xA0, 0x1D, 0x28, 0x33, 0xB0, 0x77, 0x28, 0x32, 0xB0, 0xD1,
  0x28, 0x21, 0xC5, 0x94, 0x81, 0xCB, 0x24, 0x0D, 0x0B, 0x50, 0xE0, 0x44, 0x01, 0x0D, 0x50, 0x90,
  0x63, 0x81, 0x1D, 0xA4,
  // "Ā" (U+0100)
  0x38, 0x27, 0xDD, 0x57, 0x38, 0x11, 0xF5, 0x48, 0x17, 0xC6, 0x48, 0x1C, 0x76, 0x38, 0x25, 0x86,
  0x73, 0x82, 0xC2, 0x68, 0x28, 0x33, 0xFE, 0xE8, 0x28, 0x6A, 0x50, 0x69, 0x01, 0xD2, 0x83, 0x59,
  0x08, 0x82, 0x05, 0x0A, 0x10,
  // "ā" (U+0101)
  0x00, 0x7D, 0xD5, 0x00, 0x00, 0x00, 0x01, 0xCC, 0x76, 0x0B, 0x51, 0xF3, 0x3D, 0x00, 0xE0, 0x68,
  0x02, 0xC0, 0x86, 0x06, 0x90, 0x87, 0x1D, 0x60, 0x3D, 0xA9, 0x30,
  // "Ă" (U+0102)
  0x38, 0x24, 0x53, 0x63, 0x82, 0x1C, 0xB1, 0x73, 0x81, 0x1F, 0x54, 0x81, 0x7C, 0x64, 0x81, 0xC7,
  0x63, 0x82, 0x58, 0x67, 0x38, 0x2C, 0x26, 0x82, 0x83, 0x3F, 0xEE, 0x82, 0x86, 0xA5, 0x06, 0x90,
  0x1D, 0x28, 0x35, 0x90, 0x88, 0x20, 0x50, 0xA1,
  // "ă" (U+0103)
  0x00, 0x45, 0x36, 0x00, 0x1C, 0xB1, 0x00, 0x00, 0x00, 0x01, 0xCC, 0x76, 0x0B, 0x51, 0xF3, 0x3D,
  0x00, 0xE0, 0x68, 0x02, 0xC0, 0x86, 0x06, 0x90, 0x87, 0x1D, 0x60, 0x3D, 0xA9, 0x30,
  // "Ą" (U+0104)
  0x00, 0x01, 0xF5, 0x00, 0x07, 0xC6, 0x00, 0x0C, 0x76, 0x00, 0x58, 0x67, 0x00, 0xC2, 0x68, 0x03,
  0xFE, 0xE8, 0x0A, 0x50, 0x69, 0x1D, 0x00, 0x59, 0x88, 0x00, 0x5A, 0x00, 0x01, 0x90, 0x00, 0x07,
  0x50, 0x00, 0x04, 0xD1,
  // "ą" (U+0105)
  0x01, 0xCC, 0x76, 0x0B, 0x51, 0xF3, 0x3D, 0x00, 0xE0, 0x68, 0x02, 0xC0, 0x86, 0x06, 0x90, 0x87,
  0x1D, 0x60, 0x3D, 0xAA, 0x40, 0x00, 0x19, 0x00, 0x00, 0x75, 0x00, 0x00, 0x4D, 0x10,
  // "Ć" (U+0106)
  0x40, 0x90, 0x73, 0x05, 0x08, 0x72, 0x89, 0x33, 0xBD, 0xC0, 0x1E, 0x40, 0x10, 0x97, 0x40, 0xE4,
  0x04, 0x0B, 0x40, 0x60, 0x94, 0x05, 0x09, 0x48, 0x12, 0xD1, 0x48, 0x27, 0xDD, 0x41,
  // "ć" (U+0107)
  0x30, 0x90, 0x72, 0x05, 0x08, 0x78, 0x52, 0xCD, 0x50, 0xC5, 0x20, 0x30, 0xC3, 0x00, 0x73, 0x08,
  0x06, 0x30, 0x08, 0x38, 0x21, 0xCD, 0x51,
  // "Ĉ" (U+0108)
  0x40, 0x70, 0xD4, 0x82, 0x47, 0x65, 0x72, 0x82, 0x3B, 0xDC, 0x28, 0x31, 0xE4, 0x01, 0x20, 0x90,
  0x75, 0x0E, 0x50, 0x40, 0xB5, 0x06, 0x09, 0x50, 0x50, 0x95, 0x81, 0x2D, 0x15, 0x82, 0x7D, 0xD4,
  0x20,
  // "ĉ" (U+0109)
  0x20, 0x70, 0xD2, 0x82, 0x47, 0x65, 0x68, 0x52, 0xCD, 0x50, 0xC5, 0x20, 0x30, 0xC3, 0x00, 0x73,
  0x08, 0x06, 0x30, 0x08, 0x38, 0x21, 0xCD, 0x51,
  // "Ċ" (U+010A)
  0x40, 0x40, 0x77, 0x18, 0x93, 0x3B, 0xDC, 0x01, 0xE4, 0x01, 0x09, 0x74, 0x0E, 0x40, 0x40, 0xB4,
  0x06, 0x09, 0x40, 0x50, 0x94, 0x81, 0x2D, 0x14, 0x82, 0x7D, 0xD4, 0x10,
  // "ċ" (U+010B)
  0x20, 0x40, 0x77, 0x85, 0x2C, 0xD5, 0x0C, 0x52, 0x03, 0x0C, 0x30, 0x07, 0x30, 0x80, 0x63, 0x00,
  0x83, 0x82, 0x1C, 0xD5, 0x10,
  // "Č" (U+010C)
  0x38, 0x21, 0x94, 0x74, 0x0A, 0x0B, 0x73, 0x82, 0x3B, 0xDC, 0x28, 0x31, 0xE4, 0x01, 0x20, 0x90,
  0x75, 0x0E, 0x50, 0x40, 0xB5, 0x06, 0x09, 0x50, 0x50, 0x95, 0x81, 0x2D, 0x15, 0x82, 0x7D, 0xD4,
  0x20,
  // "č" (U+010D)
  0x18, 0x21, 0x94, 0x72, 0x0A, 0x0B, 0x78, 0x52, 0xCD, 0x50, 0xC5, 0x20, 0x30, 0xC3, 0x00, 0x73,
  0x08, 0x06, 0x30, 0x08, 0x38, 0x21, 0xCD, 0x51,
  // "Ď" (U+010E)
  0x00, 0x19, 0x47, 0x00, 0x0A, 0xB0, 0x00, 0x00, 0x00, 0x02, 0xFD, 0xC3, 0x05, 0x90, 0x6C, 0x08,
  0x60, 0x0F, 0x0B, 0x30, 0x0F, 0x0E, 0x00, 0x2E, 0x2D, 0x00, 0x6A, 0x59, 0x00, 0xC4, 0x86, 0x09,
  0xA0, 0xBE, 0xD8, 0x00,
  // "ď" (U+010F)
  0x58, 0x1E, 0x4A, 0x48, 0x22, 0xC9, 0x34, 0x81, 0x59, 0x22, 0x83, 0x1C, 0xC9, 0x63, 0x83, 0xC5,
  0x1F, 0x32, 0x03, 0x0C, 0x20, 0xE3, 0x83, 0x78, 0x02, 0xC3, 0x83, 0x96, 0x07, 0x93, 0x83, 0x87,
  0x1D, 0x63, 0x83, 0x3E, 0xAA, 0x33,
  // "Đ" (U+0110)
  0x02, 0xFD, 0xC3, 0x05, 0x90, 0x6C, 0x08, 0x60, 0x0F, 0x0B, 0x30, 0x0F, 0x8F, 0xD4, 0x2E, 0x2D,
  0x00, 0x6A, 0x5A, 0x00, 0xC4, 0x86, 0x09, 0xA0, 0xBE, 0xD8, 0x00,
  // "đ" (U+0111)
  0x00, 0x00, 0x0E, 0x00, 0x00, 0x7C, 0xE6, 0x00, 0x00, 0x58, 0x00, 0x2C, 0xC9, 0x50, 0x0C, 0x51,
  0xF2, 0x03, 0xC0, 0x0E, 0x00, 0x78, 0x02, 0xC0, 0x09, 0x60, 0x79, 0x00, 0x87, 0x1D, 0x60, 0x03,
  0xDA, 0xA3, 0x00,
  // "Ē" (U+0112)
  0x28, 0x27, 0xDD, 0x57, 0x86, 0x2F, 0xDD, 0x40, 0x5A, 0x40, 0x80, 0x74, 0x0B, 0x04, 0x48, 0x5E,
  0xDD, 0x50, 0x2D, 0x40, 0x50, 0xA4, 0x08, 0x06, 0x48, 0x2B, 0xED, 0x92,
  // "ē" (U+0113)
  0x00, 0x7D, 0xD5, 0x00, 0x00, 0x00, 0x02, 0xCE, 0x50, 0x0C, 0x43, 0xA0, 0x3B, 0x19, 0x70, 0x7E,
  0xC7, 0x00, 0x95, 0x00, 0x00, 0x88, 0x01, 0x00, 0x1C, 0xD9, 0x00,
  // "Ĕ" (U+0114)
  0x28, 0x24, 0x53, 0x62, 0x82, 0x1C, 0xB1, 0x78, 0x62, 0xFD, 0xD4, 0x05, 0xA4, 0x08, 0x07, 0x40,
  0xB0, 0x44, 0x85, 0xED, 0xD5, 0x02, 0xD4, 0x05, 0x0A, 0x40, 0x80, 0x64, 0x82, 0xBE, 0xD9, 0x20,
  // "ĕ" (U+0115)
  0x00, 0x45, 0x36, 0x00, 0x1C, 0xB1, 0x00, 0x00, 0x00, 0x02, 0xCE, 0x50, 0x0C, 0x43, 0xA0, 0x3B,
  0x19, 0x70, 0x7E, 0xC7, 0x00, 0x95, 0x00, 0x00, 0x88, 0x01, 0x00, 0x1C, 0xD9, 0x00,
  // "Ė" (U+0116)
  0x30, 0x40, 0x77, 0x18, 0x62, 0xFD, 0xD4, 0x05, 0xA4, 0x08, 0x07, 0x40, 0xB0, 0x44, 0x85, 0xED,
  0xD5, 0x02, 0xD4, 0x05, 0x0A, 0x40, 0x80, 0x64, 0x82, 0xBE, 0xD9, 0x20,
  // "ė" (U+0117)
  0x30, 0x40, 0x76, 0x8A, 0x32, 0xCE, 0x50, 0xC4, 0x3A, 0x3B, 0x19, 0x77, 0xEC, 0x70, 0x95, 0x38,
  0x78, 0x80, 0x10, 0x1C, 0xD9, 0x10,
  // "Ę" (U+0118)
  0x18, 0x62, 0xFD, 0xD4, 0x05, 0xA4, 0x08, 0x07, 0x40, 0xB0, 0x44, 0x85, 0xED, 0xD5, 0x02, 0xD4,
  0x05, 0x0A, 0x40, 0x80, 0x64, 0x82, 0xBE, 0xDA, 0x30, 0x10, 0x94, 0x07, 0x05, 0x48, 0x14, 0xD1,
  0x20,
  // "ę" (U+0119)
  0x02, 0xCE, 0x50, 0xC4, 0x3A, 0x3B, 0x19, 0x77, 0xEC, 0x70, 0x95, 0x00, 0x08, 0x80, 0x10, 0x1C,
  0xEB, 0x00, 0x0A, 0x10, 0x03, 0x80, 0x00, 0x2E, 0x30,
  // "Ě" (U+011A)
  0x28, 0x21, 0x94, 0x73, 0x0A, 0x0B, 0x71, 0x86, 0x2F, 0xDD, 0x40, 0x5A, 0x40, 0x80, 0x74, 0x0B,
  0x04, 0x48, 0x5E, 0xDD, 0x50, 0x2D, 0x40, 0x50, 0xA4, 0x08, 0x06, 0x48, 0x2B, 0xED, 0x92,
  // "ě" (U+011B)
  0x01, 0x94, 0x70, 0x0A, 0xB0, 0x00, 0x00, 0x00, 0x2C, 0xE5, 0x0C, 0x43, 0xA3, 0xB1, 0x97, 0x7E,
  0xC7, 0x09, 0x50, 0x00, 0x88, 0x01, 0x01, 0xCD, 0x90,
  // "Ĝ" (U+011C)
  0x40, 0x70, 0xD4, 0x82, 0x47, 0x65, 0x72, 0x89, 0x52, 0xBD, 0xD5, 0x01, 0xD4, 0x01, 0x10, 0xA7,
  0x48, 0x11, 0xE1, 0x48, 0x74, 0xB0, 0x3D, 0xE0, 0x6A, 0x28, 0x32, 0xC0, 0x5A, 0x28, 0x75, 0x90,
  0x2E, 0x10, 0x96, 0x28, 0x36, 0xDD, 0xC2, 0x10,
  // "ĝ" (U+011D)
  0x00, 0x7D, 0x00, 0x04, 0x76, 0x50, 0x00, 0x00, 0x00, 0x01, 0xCD, 0x86, 0x0B, 0x51, 0xF3, 0x3C,
  0x00, 0xF0, 0x78, 0x02, 0xC0, 0x96, 0x07, 0x90, 0x87, 0x1E, 0x60, 0x3E, 0xAB, 0x30, 0x00, 0x0D,
  0x00, 0x10, 0x6A, 0x00, 0xCD, 0xB1, 0x00,
  // "Ğ" (U+011E)
  0x38, 0x24, 0x53, 0x63, 0x82, 0x1C, 0xB1, 0x72, 0x89, 0x52, 0xBD, 0xD5, 0x01, 0xD4, 0x01, 0x10,
  0xA7, 0x48, 0x11, 0xE1, 0x48, 0x74, 0xB0, 0x3D, 0xE0, 0x6A, 0x28, 0x32, 0xC0, 0x5A, 0x28, 0x75,
  0x90, 0x2E, 0x10, 0x96, 0x28, 0x36, 0xDD, 0xC2, 0x10,
  // "ğ" (U+011F)
  0x00, 0x45, 0x36, 0x00, 0x1C, 0xB1, 0x00, 0x00, 0x00, 0x01, 0xCD, 0x86, 0x0B, 0x51, 0xF3, 0x3C,
  0x00, 0xF0, 0x78, 0x02, 0xC0, 0x96, 0x07, 0x90, 0x87, 0x1E, 0x60, 0x3E, 0xAB, 0x30, 0x00, 0x0D,
  0x00, 0x10, 0x6A, 0x00, 0xCD, 0xB1, 0x00,
  // "Ġ" (U+0120)
  0x40, 0x40, 0x77, 0x38, 0x95, 0x2B, 0xDD, 0x50, 0x1D, 0x40, 0x11, 0x0A, 0x74, 0x81, 0x1E, 0x14,
  0x87, 0x4B, 0x03, 0xDE, 0x06, 0xA2, 0x83, 0x2C, 0x05, 0xA2, 0x87, 0x59, 0x02, 0xE1, 0x09, 0x62,
  0x83, 0x6D, 0xDC, 0x21,
  // "ġ" (U+0121)
  0x30, 0x40, 0x77, 0x18, 0x93, 0x1C, 0xD8, 0x60, 0xB5, 0x1F, 0x33, 0xC2, 0x91, 0x8A, 0x57, 0x80,
  0x2C, 0x09, 0x60, 0x79, 0x08, 0x71, 0xE6, 0x03, 0xEA, 0xB3, 0x40, 0xD2, 0x82, 0x10, 0x6A, 0x28,
  0x2C, 0xDB, 0x12,
  // "Ģ" (U+0122)
  0x28, 0x95, 0x2B, 0xDD, 0x50, 0x1D, 0x40, 0x11, 0x0A, 0x74, 0x81, 0x1E, 0x14, 0x87, 0x4B, 0x03,
  0xDE, 0x06, 0xA2, 0x83, 0x2C, 0x05, 0xA2, 0x87, 0x59, 0x02, 0xE1, 0x09, 0x62, 0x83, 0x6D, 0xDC,
  0x27, 0x30, 0x07, 0x50, 0xB4,
  // "ģ" (U+0123)
  0x00, 0x03, 0x80, 0x00, 0x0C, 0x20, 0x00, 0x02, 0x00, 0x01, 0xCD, 0x86, 0x0B, 0x51, 0xF3, 0x3C,
  0x00, 0xF0, 0x78, 0x02, 0xC0, 0x96, 0x07, 0x90, 0x87, 0x1E, 0x60, 0x3E, 0xAB, 0x30, 0x00, 0x0D,
  0x00, 0x10, 0x6A, 0x00, 0xCD, 0xB1, 0x00,
  // "Ĥ" (U+0124)
  0x00, 0x07, 0xD0, 0x00, 0x04, 0x76, 0x50, 0x00, 0x00, 0x00, 0x00, 0x2D, 0x00, 0x59, 0x05, 0xA0,
  0x08, 0x60, 0x87, 0x00, 0xB3, 0x0B, 0x40, 0x0E, 0x00, 0xEF, 0xFF, 0xC0, 0x2D, 0x00, 0x59, 0x05,
  0xA0, 0x09, 0x60, 0x87, 0x00, 0xC3, 0x0B, 0x30, 0x0E, 0x00,
  // "ĥ" (U+0125)
  0x20, 0x70, 0xD3, 0x82, 0x47, 0x65, 0x71, 0x01, 0x0D, 0x40, 0x40, 0xB4, 0x07, 0x08, 0x48, 0x2A,
  0x9D, 0xB2, 0x83, 0xD8, 0x0E, 0x11, 0x92, 0x8A, 0x7E, 0x03, 0xB0, 0x3C, 0x06, 0x80, 0x69, 0x09,
  0x50, 0x95, 0x0C, 0x20, 0xC2, 0x10,
  // "Ħ" (U+0126)
  0x03, 0xC0, 0x06, 0x80, 0x3D, 0xEC, 0xCE, 0xD2, 0x09, 0x50, 0x0D, 0x10, 0x0C, 0x30, 0x0E, 0x00,
  0x0F, 0xDD, 0xDB, 0x00, 0x3D, 0x00, 0x58, 0x00, 0x6A, 0x00, 0x95, 0x00, 0x97, 0x00, 0xC2, 0x00,
  0xB3, 0x00, 0xE0, 0x00,
  // "ħ" (U+0127)
  0x01, 0xD0, 0x00, 0xDE, 0xC0, 0x07, 0x70, 0x00, 0xA8, 0xDB, 0x0D, 0x70, 0xE0, 0xE0, 0x0E, 0x3B,
  0x03, 0xB6, 0x80, 0x68, 0x95, 0x09, 0x5C, 0x20, 0xC2,
  // "Ĩ" (U+0128)
  0x28, 0x22, 0xD6, 0x92, 0x82, 0x72, 0xA9, 0x71, 0x81, 0x7F, 0xB3, 0x01, 0x0E, 0x40, 0x40, 0xB4,
  0x07, 0x08, 0x40, 0xA0, 0x54, 0x0D, 0x01, 0x30, 0x10, 0xE4, 0x04, 0x0B, 0x38, 0x24, 0xDD, 0x32,
  // "ĩ" (U+0129)
  0x2D, 0x69, 0x72, 0xA9, 0x00, 0x00, 0x09, 0x50, 0x0C, 0x20, 0x0E, 0x00, 0x3B, 0x00, 0x68, 0x00,
  0x95, 0x00, 0xC2, 0x00,
  // "Ī" (U+012A)
  0x28, 0x27, 0xDD, 0x57, 0x18, 0x17, 0xFB, 0x30, 0x10, 0xE4, 0x04, 0x0B, 0x40, 0x70, 0x84, 0x0A,
  0x05, 0x40, 0xD0, 0x13, 0x01, 0x0E, 0x40, 0x40, 0xB3, 0x82, 0x4D, 0xD3, 0x20,
  // "ī" (U+012B)
  0x7D, 0xD5, 0x00, 0x00, 0x09, 0x50, 0x0C, 0x20, 0x0E, 0x00, 0x3B, 0x00, 0x68, 0x00, 0x95, 0x00,
  0xC2, 0x00,
  // "Ĭ" (U+012C)
  0x28, 0x24, 0x53, 0x62, 0x82, 0x1C, 0xB1, 0x71, 0x81, 0x7F, 0xB3, 0x01, 0x0E, 0x40, 0x40, 0xB4,
  0x07, 0x08, 0x40, 0xA0, 0x54, 0x0D, 0x01, 0x30, 0x10, 0xE4, 0x04, 0x0B, 0x38, 0x24, 0xDD, 0x32,
  // "ĭ" (U+012D)
  0x45, 0x36, 0x1C, 0xB1, 0x00, 0x00, 0x09, 0x50, 0x0C, 0x20, 0x0E, 0x00, 0x3B, 0x00, 0x68, 0x00,
  0x95, 0x00, 0xC2, 0x00,
  // "Į" (U+012E)
  0x00, 0x7F, 0xB0, 0x01, 0xE0, 0x00, 0x4B, 0x00, 0x07, 0x80, 0x00, 0xA5, 0x00, 0x0D, 0x10, 0x01,
  0xE0, 0x00, 0x4B, 0x00, 0x4D, 0xE3, 0x01, 0x90, 0x00, 0x75, 0x00, 0x04, 0xD1, 0x00,
  // "į" (U+012F)
  0x00, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x95, 0x00, 0xC2, 0x00, 0xE0, 0x03, 0xB0, 0x06, 0x80,
  0x09, 0x50, 0x0C, 0x20, 0x19, 0x00, 0x75, 0x00, 0x4D, 0x10,
  // "İ" (U+0130)
  0x30, 0x40, 0x77, 0x81, 0x7F, 0xB2, 0x01, 0x0E, 0x30, 0x40, 0xB3, 0x07, 0x08, 0x30, 0xA0, 0x53,
  0x0D, 0x01, 0x20, 0x10, 0xE3, 0x04, 0x0B, 0x28, 0x24, 0xDD, 0x31,
  // "ı" (U+0131)
  0x09, 0x50, 0xC2, 0x0E, 0x03, 0xB0, 0x68, 0x09, 0x50, 0xC2, 0x00,
  // "Ĳ" (U+0132)
  0x00, 0x7F, 0xB2, 0xD0, 0x01, 0xE0, 0x4A, 0x00, 0x4B, 0x07, 0x70, 0x07, 0x80, 0xA4, 0x00, 0xA5,
  0x0D, 0x10, 0x0D, 0x11, 0xE0, 0x01, 0xE0, 0x4B, 0x00, 0x4B, 0x07, 0x80, 0x4D, 0xD3, 0xA5, 0x00,
  0x00, 0x0D, 0x10, 0x00, 0x03, 0xC0, 0x00, 0x09, 0xC3, 0x00,
  // "ĳ" (U+0133)
  0x18, 0x31, 0x90, 0x19, 0x76, 0x89, 0x39, 0x50, 0x95, 0x0C, 0x20, 0xC1, 0x0E, 0x28, 0xA7, 0xE0,
  0x3B, 0x03, 0xB0, 0x68, 0x06, 0x80, 0x95, 0x09, 0x50, 0xC2, 0x0C, 0x24, 0x0E, 0x40, 0x40, 0xA3,
  0x81, 0x7D, 0x22,
  // "Ĵ" (U+0134)
  0x40, 0x70, 0xD4, 0x82, 0x47, 0x65, 0x73, 0x02, 0x0D, 0x50, 0x40, 0xA5, 0x00, 0x75, 0x0A, 0x04,
  0x50, 0xD0, 0x14, 0x01, 0x0E, 0x50, 0x40, 0xB5, 0x07, 0x08, 0x50, 0xA0, 0x55, 0x0D, 0x01, 0x40,
  0x30, 0xC4, 0x81, 0x9C, 0x34,
  // "ĵ" (U+0135)
  0x30, 0x70, 0xD3, 0x82, 0x47, 0x65, 0x72, 0x09, 0x05, 0x40, 0xC0, 0x14, 0x0E, 0x40, 0x30, 0xB4,
  0x06, 0x08, 0x40, 0x90, 0x54, 0x0C, 0x02, 0x40, 0xE4, 0x04, 0x0A, 0x38, 0x17, 0xD2, 0x30,
  // "Ķ" (U+0136)
  0x18, 0x92, 0x2D, 0x02, 0xD1, 0x05, 0xA0, 0xC5, 0x28, 0x28, 0x68, 0x93, 0x81, 0xB8, 0xC4, 0x81,
  0xEE, 0x83, 0x82, 0x2D, 0x4C, 0x38, 0x35, 0xA0, 0xE1, 0x28, 0x38, 0x60, 0xB5, 0x28, 0x3B, 0x30,
  0x79, 0x73, 0x00, 0x75, 0x0B, 0x50,
  // "ķ" (U+0137)
  0x20, 0xD3, 0x03, 0x0B, 0x30, 0x60, 0x73, 0x8B, 0x79, 0x52, 0xC0, 0xD2, 0xC3, 0x0D, 0xA6, 0x03,
  0xFE, 0x30, 0x69, 0x87, 0x09, 0x54, 0xB0, 0xC2, 0x0E, 0x70, 0x07, 0x30, 0xB3,
  // "ĸ" (U+0138)
  0x09, 0x52, 0xC0, 0xC2, 0xC3, 0x0D, 0xA6, 0x03, 0xFE, 0x30, 0x69, 0x87, 0x09, 0x54, 0xB0, 0xC2,
  0x0E, 0x00,
  // "Ĺ" (U+0139)
  0x30, 0x90, 0x72, 0x05, 0x08, 0x70, 0x20, 0xD3, 0x05, 0x0A, 0x30, 0x80, 0x63, 0x0B, 0x03, 0x30,
  0xE3, 0x02, 0x0C, 0x30, 0x50, 0x93, 0x08, 0x06, 0x38, 0x2B, 0xEE, 0xA1,
  // "ĺ" (U+013A)
  0x30, 0x90, 0x72, 0x05, 0x08, 0x71, 0x0D, 0x30, 0x30, 0xB3, 0x06, 0x07, 0x30, 0x90, 0x53, 0x0D,
  0x01, 0x30, 0xE3, 0x03, 0x0B, 0x30, 0x60, 0x83, 0x09, 0x05, 0x30, 0xC0, 0x23,
  // "Ļ" (U+013B)
  0x02, 0xD0, 0x05, 0xA0, 0x08, 0x60, 0x0B, 0x30, 0x0E, 0x00, 0x2C, 0x00, 0x59, 0x00, 0x86, 0x00,
  0xBE, 0xEA, 0x00, 0x00, 0x07, 0x70, 0x0B, 0x00,
  // "ļ" (U+013C)
  0x00, 0x0D, 0x00, 0x3B, 0x00, 0x67, 0x00, 0x95, 0x00, 0xD1, 0x00, 0xE0, 0x03, 0xB0, 0x06, 0x80,
  0x09, 0x50, 0x0C, 0x20, 0x00, 0x00, 0x77, 0x00, 0xB0, 0x00,
  // "Ľ" (U+013D)
  0x18, 0x90, 0x2D, 0x0D, 0x10, 0x5A, 0x46, 0x20, 0x80, 0x64, 0x0B, 0x03, 0x40, 0xE4, 0x02, 0x0C,
  0x40, 0x50, 0x94, 0x08, 0x06, 0x48, 0x2B, 0xEE, 0xA2,
  // "ľ" (U+013E)
  0x00, 0xD4, 0x90, 0x3B, 0x92, 0x06, 0x71, 0x00, 0x95, 0x00, 0x0D, 0x10, 0x00, 0xE0, 0x00, 0x3B,
  0x00, 0x06, 0x80, 0x00, 0x95, 0x00, 0x0C, 0x20, 0x00,
  // "Ŀ" (U+013F)
  0x02, 0xD0, 0x00, 0x5A, 0x00, 0x08, 0x60, 0x00, 0xB3, 0x00, 0x0E, 0x04, 0x72, 0xC0, 0x00, 0x59,
  0x00, 0x08, 0x60, 0x00, 0xBE, 0xEA, 0x00,
  // "ŀ" (U+0140)
  0x00, 0xD0, 0x03, 0xB0, 0x06, 0x70, 0x09, 0x50, 0x0D, 0x10, 0x0E, 0x47, 0x3B, 0x00, 0x68, 0x00,
  0x95, 0x00, 0xC2, 0x00,
  // "Ł" (U+0141)
  0x01, 0xE0, 0x04, 0xB0, 0x07, 0x80, 0x0A, 0x86, 0x1E, 0xA1, 0xCD, 0x00, 0x4A, 0x00, 0x77, 0x00,
  0xAE, 0xEA,
  // "ł" (U+0142)
  0x00, 0xE0, 0x03, 0xC0, 0x06, 0x90, 0x09, 0x60, 0x0C, 0xD2, 0x9F, 0x10, 0x4C, 0x00, 0x59, 0x00,
  0x86, 0x00, 0xB3, 0x00,
  // "Ń" (U+0143)
  0x50, 0x90, 0x74, 0x05, 0x08, 0x72, 0x81, 0x2F, 0x32, 0x8E, 0x2E, 0x05, 0xF6, 0x03, 0xB0, 0x8A,
  0x90, 0x68, 0x0B, 0x4D, 0x09, 0x50, 0xE0, 0xD1, 0xC2, 0x2C, 0x09, 0x4E, 0x05, 0x90, 0x6A, 0xB0,
  0x86, 0x03, 0xF8, 0x0B, 0x32, 0x0E, 0x05, 0x10,
  // "ń" (U+0144)
  0x40, 0x90, 0x73, 0x05, 0x08, 0x71, 0x82, 0xA7, 0xDB, 0x28, 0xC0, 0xD8, 0x0E, 0x10, 0xF1, 0x0E,
  0x03, 0xB0, 0x3C, 0x06, 0x80, 0x69, 0x09, 0x50, 0x95, 0x0C, 0x20, 0xC2, 0x10,
  // "Ņ" (U+0145)
  0x18, 0x12, 0xF3, 0x28, 0xE2, 0xE0, 0x5F, 0x60, 0x3B, 0x08, 0xA9, 0x06, 0x80, 0xB4, 0xD0, 0x95,
  0x0E, 0x0D, 0x1C, 0x22, 0xC0, 0x94, 0xE0, 0x59, 0x06, 0xAB, 0x08, 0x60, 0x3F, 0x80, 0xB3, 0x20,
  0xE0, 0x57, 0x30, 0x07, 0x50, 0xB4,
  // "ņ" (U+0146)
  0x18, 0x2A, 0x7D, 0xB2, 0x8C, 0x0D, 0x80, 0xE1, 0x0F, 0x10, 0xE0, 0x3B, 0x03, 0xC0, 0x68, 0x06,
  0x90, 0x95, 0x09, 0x50, 0xC2, 0x0C, 0x27, 0x10, 0x07, 0x40, 0xB4,
  // "Ň" (U+0147)
  0x38, 0x21, 0x94, 0x74, 0x0A, 0x0B, 0x72, 0x81, 0x2F, 0x32, 0x8E, 0x2E, 0x05, 0xF6, 0x03, 0xB0,
  0x8A, 0x90, 0x68, 0x0B, 0x4D, 0x09, 0x50, 0xE0, 0xD1, 0xC2, 0x2C, 0x09, 0x4E, 0x05, 0x90, 0x6A,
  0xB0, 0x86, 0x03, 0xF8, 0x0B, 0x32, 0x0E, 0x05, 0x10,
  // "ň" (U+0148)
  0x00, 0x19, 0x47, 0x00, 0x0A, 0xB0, 0x00, 0x00, 0x00, 0x0A, 0x7D, 0xB0, 0x0D, 0x80, 0xE1, 0x0F,
  0x10, 0xE0, 0x3B, 0x03, 0xC0, 0x68, 0x06, 0x90, 0x95, 0x09, 0x50, 0xC2, 0x0C, 0x20,
  // "ŉ" (U+0149)
  0x05, 0xA0, 0x00, 0x00, 0xB3, 0x00, 0x00, 0x2A, 0xA7, 0xDB, 0x00, 0x0D, 0x80, 0xE1, 0x00, 0xF1,
  0x0E, 0x00, 0x3B, 0x03, 0xC0, 0x06, 0x80, 0x69, 0x00, 0x95, 0x09, 0x50, 0x0C, 0x20, 0xC2, 0x00,
  // "Ŋ" (U+014A)
  0x02, 0xF3, 0x00, 0xE0, 0x5E, 0x60, 0x3B, 0x08, 0x9A, 0x06, 0x80, 0xB3, 0xD0, 0x95, 0x0E, 0x0C,
  0x1C, 0x12, 0xC0, 0x85, 0xD0, 0x59, 0x05, 0xBA, 0x08, 0x60, 0x1F, 0x70, 0xB3, 0x00, 0xD4, 0x00,
  0x00, 0x1D, 0x00, 0x00, 0x8D, 0x50, 0x00,
  // "ŋ" (U+014B)
  0x09, 0x7D, 0xB0, 0x0C, 0x80, 0xE1, 0x0E, 0x00, 0xE0, 0x3B, 0x03, 0xB0, 0x68, 0x06, 0x80, 0x95,
  0x09, 0x50, 0xC2, 0x0C, 0x20, 0x00, 0x0E, 0x00, 0x00, 0x4A, 0x00, 0x07, 0xD3, 0x00,
  // "Ō" (U+014C)
  0x38, 0x27, 0xDD, 0x57, 0x28, 0x24, 0xCD, 0x92, 0x87, 0x2D, 0x20, 0xC5, 0x0A, 0x62, 0x82, 0x87,
  0x0E, 0x38, 0x28, 0x74, 0xC3, 0x82, 0xA5, 0x69, 0x38, 0x2E, 0x16, 0x92, 0x87, 0x5B, 0x03, 0xD0,
  0x1D, 0x32, 0x82, 0x8D, 0xD5, 0x20,
  // "ō" (U+014D)
  0x00, 0x7D, 0xD5, 0x00, 0x00, 0x00, 0x01, 0xCD, 0x60, 0x0C, 0x41, 0xE0, 0x3B, 0x00, 0xE0, 0x77,
  0x01, 0xE0, 0x96, 0x05, 0xA0, 0x77, 0x0C, 0x40, 0x1C, 0xD7, 0x00,
  // "Ŏ" (U+014E)
  0x38, 0x24, 0x53, 0x63, 0x82, 0x1C, 0xB1, 0x72, 0x82, 0x4C, 0xD9, 0x28, 0x72, 0xD2, 0x0C, 0x50,
  0xA6, 0x28, 0x28, 0x70, 0xE3, 0x82, 0x87, 0x4C, 0x38, 0x2A, 0x56, 0x93, 0x82, 0xE1, 0x69, 0x28,
  0x75, 0xB0, 0x3D, 0x01, 0xD3, 0x28, 0x28, 0xDD, 0x52,
  // "ŏ" (U+014F)
  0x00, 0x45, 0x36, 0x00, 0x1C, 0xB1, 0x00, 0x00, 0x00, 0x01, 0xCD, 0x60, 0x0C, 0x41, 0xE0, 0x3B,
  0x00, 0xE0, 0x77, 0x01, 0xE0, 0x96, 0x05, 0xA0, 0x77, 0x0C, 0x40, 0x1C, 0xD7, 0x00,
  // "Ő" (U+0150)
  0x48, 0x2A, 0x5C, 0x33, 0x82, 0x56, 0x74, 0x74, 0x82, 0x4C, 0xD9, 0x38, 0x42, 0xD2, 0x0C, 0x52,
  0x0A, 0x06, 0x20, 0x80, 0x72, 0x0E, 0x38, 0x38, 0x70, 0x4C, 0x38, 0x3A, 0x50, 0x69, 0x38, 0x3E,
  0x10, 0x69, 0x20, 0x50, 0xB2, 0x84, 0x3D, 0x01, 0xD3, 0x38, 0x28, 0xDD, 0x53,
  // "ő" (U+0151)
  0x00, 0x0A, 0x5C, 0x30, 0x05, 0x67, 0x40, 0x00, 0x00, 0x00, 0x00, 0x1C, 0xD6, 0x00, 0x0C, 0x41,
  0xE0, 0x03, 0xB0, 0x0E, 0x00, 0x77, 0x01, 0xE0, 0x09, 0x60, 0x5A, 0x00, 0x77, 0x0C, 0x40, 0x01,
  0xCD, 0x70, 0x00,
  // "Œ" (U+0152)
  0x28, 0x93, 0x4C, 0xDF, 0xDD, 0x50, 0x2D, 0x24, 0xB4, 0x83, 0xA6, 0x07, 0x84, 0x0E, 0x20, 0xA0,
  0x53, 0x04, 0x0C, 0x20, 0xFD, 0x85, 0x60, 0x6A, 0x01, 0xE4, 0x83, 0x69, 0x04, 0xB4, 0x83, 0x3D,
  0x07, 0x85, 0x84, 0x8D, 0xEE, 0xDA, 0x20,
  // "œ" (U+0153)
  0x01, 0xCD, 0x46, 0xDB, 0x00, 0xC4, 0x1D, 0xA0, 0xC2, 0x3B, 0x00, 0xE2, 0x4D, 0x07, 0x70, 0x1F,
  0xDA, 0x20, 0x96, 0x05, 0xC0, 0x00, 0x07, 0x70, 0xCD, 0x00, 0x00, 0x1C, 0xD5, 0x6E, 0xC3, 0x00,
  // "Ŕ" (U+0154)
  0x40, 0x90, 0x73, 0x05, 0x08, 0x71, 0x8B, 0x72, 0xFD, 0xB1, 0x05, 0x90, 0x98, 0x08, 0x60, 0x88,
  0x0B, 0x32, 0xD3, 0x0E, 0xDE, 0x50, 0x2C, 0x1E, 0x28, 0x97, 0x59, 0x0E, 0x10, 0x86, 0x0B, 0x50,
  0xB3, 0x07, 0x81,
  // "ŕ" (U+0155)
  0x30, 0x90, 0x72, 0x05, 0x08, 0x78, 0x59, 0x7D, 0x10, 0xC8, 0x30, 0xE3, 0x03, 0x0B, 0x30, 0x60,
  0x83, 0x09, 0x05, 0x30, 0xC0, 0x23,
  // "Ŗ" (U+0156)
  0x18, 0xB7, 0x2F, 0xDB, 0x10, 0x59, 0x09, 0x80, 0x86, 0x08, 0x80, 0xB3, 0x2D, 0x30, 0xED, 0xE5,
  0x02, 0xC1, 0xE2, 0x89, 0x75, 0x90, 0xE1, 0x08, 0x60, 0xB5, 0x0B, 0x30, 0x78, 0x71, 0x00, 0x74,
  0x0B, 0x40,
  // "ŗ" (U+0157)
  0x18, 0x59, 0x7D, 0x10, 0xC8, 0x30, 0xE3, 0x03, 0x0B, 0x30, 0x60, 0x83, 0x09, 0x05, 0x30, 0xC0,
  0x27, 0x10, 0x07, 0x30, 0xB4,
  // "Ř" (U+0158)
  0x00, 0x19, 0x47, 0x00, 0x0A, 0xB0, 0x00, 0x00, 0x00, 0x02, 0xFD, 0xB1, 0x05, 0x90, 0x98, 0x08,
  0x60, 0x88, 0x0B, 0x32, 0xD3, 0x0E, 0xDE, 0x50, 0x2C, 0x1E, 0x00, 0x59, 0x0E, 0x10, 0x86, 0x0B,
  0x50, 0xB3, 0x07, 0x80,
  // "ř" (U+0159)
  0x18, 0x21, 0x94, 0x72, 0x0A, 0x0B, 0x78, 0x59, 0x7D, 0x10, 0xC8, 0x30, 0xE3, 0x03, 0x0B, 0x30,
  0x60, 0x83, 0x09, 0x05, 0x30, 0xC0, 0x23,
  // "Ś" (U+015A)
  0x50, 0x90, 0x74, 0x05, 0x08, 0x73, 0x83, 0x1B, 0xDD, 0x12, 0x82, 0xB6, 0x02, 0x30, 0xE0, 0x15,
  0x0B, 0x08, 0x58, 0x11, 0xD8, 0x58, 0x12, 0xE2, 0x50, 0xC0, 0x42, 0x89, 0x12, 0x02, 0xE1, 0x01,
  0xCD, 0xC4, 0x20,
  // "ś" (U+015B)
  0x30, 0x90, 0x72, 0x05, 0x08, 0x78, 0x92, 0x9D, 0xD1, 0x3C, 0x01, 0x02, 0xD1, 0x30, 0x70, 0xC4,
  0x89, 0x1A, 0x60, 0x10, 0xA5, 0x0D, 0xDA, 0x20,
  // "Ŝ" (U+015C)
  0x40, 0x70, 0xD4, 0x82, 0x47, 0x65, 0x72, 0x83, 0x1B, 0xDD, 0x12, 0x82, 0xB6, 0x02, 0x30, 0xE0,
  0x15, 0x0B, 0x08, 0x58, 0x11, 0xD8, 0x58, 0x12, 0xE2, 0x50, 0xC0, 0x42, 0x89, 0x12, 0x02, 0xE1,
  0x01, 0xCD, 0xC4, 0x20,
  // "ŝ" (U+015D)
  0x00, 0x7D, 0x00, 0x47, 0x65, 0x00, 0x00, 0x00, 0x9D, 0xD1, 0x3C, 0x01, 0x02, 0xD1, 0x00, 0x07,
  0xC0, 0x00, 0x0A, 0x60, 0x10, 0xA5, 0x0D, 0xDA, 0x00,
  // "Ş" (U+015E)
  0x28, 0x31, 0xBD, 0xD1, 0x28, 0x2B, 0x60, 0x23, 0x0E, 0x01, 0x50, 0xB0, 0x85, 0x81, 0x1D, 0x85,
  0x81, 0x2E, 0x25, 0x0C, 0x04, 0x28, 0x91, 0x20, 0x2E, 0x10, 0x1C, 0xFC, 0x43, 0x01, 0x0B, 0x60,
  0x90, 0x44, 0x00, 0x94,
  // "ş" (U+015F)
  0x09, 0xDD, 0x13, 0xC0, 0x10, 0x2D, 0x10, 0x00, 0x7C, 0x00, 0x00, 0xA6, 0x01, 0x0A, 0x50, 0xDF,
  0xA0, 0x01, 0xB0, 0x00, 0x09, 0x40, 0x09, 0x90, 0x00,
  // "Š" (U+0160)
  0x38, 0x21, 0x94, 0x74, 0x0A, 0x0B, 0x73, 0x83, 0x1B, 0xDD, 0x12, 0x82, 0xB6, 0x02, 0x30, 0xE0,
  0x15, 0x0B, 0x08, 0x58, 0x11, 0xD8, 0x58, 0x12, 0xE2, 0x50, 0xC0, 0x42, 0x89, 0x12, 0x02, 0xE1,
  0x01, 0xCD, 0xC4, 0x20,
  // "š" (U+0161)
  0x01, 0x94, 0x70, 0x0A, 0xB0, 0x00, 0x00, 0x00, 0x9D, 0xD1, 0x3C, 0x01, 0x02, 0xD1, 0x00, 0x07,
  0xC0, 0x00, 0x0A, 0x60, 0x10, 0xA5, 0x0D, 0xDA, 0x00,
  // "Ţ" (U+0162)
  0x18, 0x3C, 0xEF, 0xD7, 0x20, 0x60, 0x94, 0x09, 0x06, 0x40, 0xC0, 0x34, 0x0E, 0x40, 0x30, 0xC4,
  0x06, 0x09, 0x40, 0x90, 0x64, 0x0D, 0x03, 0x30, 0x10, 0xB5, 0x09, 0x04, 0x30, 0x09, 0x40,
  // "ţ" (U+0163)
  0x00, 0x50, 0x04, 0x80, 0x3E, 0xE6, 0x0C, 0x20, 0x0E, 0x00, 0x3B, 0x00, 0x68, 0x00, 0x86, 0x00,
  0x5F, 0x50, 0x1B, 0x00, 0x09, 0x40, 0x99, 0x00,
  // "Ť" (U+0164)
  0x18, 0x21, 0x94, 0x72, 0x0A, 0x0B, 0x68, 0x6C, 0xEF, 0xD7, 0x06, 0x93, 0x09, 0x06, 0x30, 0xC0,
  0x33, 0x0E, 0x30, 0x30, 0xC3, 0x06, 0x09, 0x30, 0x90, 0x63, 0x0C, 0x03, 0x30,
  // "ť" (U+0165)
  0x00, 0x06, 0x80, 0x06, 0xA1, 0x05, 0x82, 0x03, 0xEE, 0x60, 0x0C, 0x20, 0x00, 0xE0, 0x00, 0x3B,
  0x00, 0x06, 0x80, 0x00, 0x86, 0x00, 0x05, 0xE5, 0x00,
  // "Ŧ" (U+0166)
  0x18, 0x3C, 0xEF, 0xD7, 0x20, 0x60, 0x94, 0x09, 0x06, 0x40, 0xC0, 0x32, 0x83, 0x2D, 0xFD, 0x42,
  0x02, 0x0C, 0x40, 0x50, 0x94, 0x09, 0x06, 0x40, 0xC0, 0x33,
  // "ŧ" (U+0167)
  0x00, 0x50, 0x04, 0x80, 0x3E, 0xE6, 0x0D, 0x10, 0xAF, 0xC0, 0x4A, 0x00, 0x77, 0x00, 0x96, 0x00,
  0x5E, 0x50,
  // "Ũ" (U+0168)
  0x00, 0x2D, 0x69, 0x00, 0x07, 0x2A, 0x90, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x78, 0x06, 0x90,
  0x0A, 0x50, 0x95, 0x00, 0xD2, 0x0C, 0x20, 0x1E, 0x00, 0xE0, 0x04, 0xB0, 0x3B, 0x00, 0x77, 0x06,
  0x90, 0x0B, 0x30, 0x5B, 0x04, 0xD0, 0x00, 0xBE, 0xC3, 0x00,
  // "ũ" (U+0169)
  0x00, 0x2D, 0x69, 0x00, 0x72, 0xA9, 0x00, 0x00, 0x00, 0x0A, 0x40, 0xA4, 0x0D, 0x10, 0xD1, 0x1E,
  0x00, 0xE0, 0x4B, 0x04, 0xB0, 0x78, 0x08, 0x80, 0x87, 0x2E, 0x50, 0x4E, 0xAB, 0x20,
  // "Ū" (U+016A)
  0x00, 0x07, 0xDD, 0x50, 0x00, 0x00, 0x00, 0x03, 0xC0, 0x07, 0x80, 0x69, 0x00, 0xA5, 0x09, 0x50,
  0x0D, 0x20, 0xC2, 0x01, 0xE0, 0x0E, 0x00, 0x4B, 0x03, 0xB0, 0x07, 0x70, 0x69, 0x00, 0xB3, 0x05,
  0xB0, 0x4D, 0x00, 0x0B, 0xEC, 0x30, 0x00,
  // "ū" (U+016B)
  0x00, 0x7D, 0xD5, 0x00, 0x00, 0x00, 0x0A, 0x40, 0xA4, 0x0D, 0x10, 0xD1, 0x1E, 0x00, 0xE0, 0x4B,
  0x04, 0xB0, 0x78, 0x08, 0x80, 0x87, 0x2E, 0x50, 0x4E, 0xAB, 0x20,
  // "Ŭ" (U+016C)
  0x00, 0x45, 0x36, 0x00, 0x01, 0xCB, 0x10, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x78, 0x06, 0x90,
  0x0A, 0x50, 0x95, 0x00, 0xD2, 0x0C, 0x20, 0x1E, 0x00, 0xE0, 0x04, 0xB0, 0x3B, 0x00, 0x77, 0x06,
  0x90, 0x0B, 0x30, 0x5B, 0x04, 0xD0, 0x00, 0xBE, 0xC3, 0x00,
  // "ŭ" (U+016D)
  0x00, 0x45, 0x36, 0x00, 0x1C, 0xB1, 0x00, 0x00, 0x00, 0x0A, 0x40, 0xA4, 0x0D, 0x10, 0xD1, 0x1E,
  0x00, 0xE0, 0x4B, 0x04, 0xB0, 0x78, 0x08, 0x80, 0x87, 0x2E, 0x50, 0x4E, 0xAB, 0x20,
  // "Ů" (U+016E)
  0x38, 0x11, 0x98, 0x48, 0x25, 0x48, 0x13, 0x81, 0x19, 0x87, 0x20, 0x30, 0xC2, 0x83, 0x78, 0x06,
  0x92, 0x83, 0xA5, 0x09, 0x52, 0x86, 0xD2, 0x0C, 0x20, 0x1E, 0x20, 0xE2, 0x83, 0x4B, 0x03, 0xB2,
  0x83, 0x77, 0x06, 0x92, 0x86, 0xB3, 0x05, 0xB0, 0x4D, 0x38, 0x2B, 0xEC, 0x32,
  // "ů" (U+016F)
  0x00, 0x19, 0x80, 0x00, 0x54, 0x81, 0x00, 0x19, 0x80, 0x00, 0x00, 0x00, 0x0A, 0x40, 0xA4, 0x0D,
  0x10, 0xD1, 0x1E, 0x00, 0xE0, 0x4B, 0x04, 0xB0, 0x78, 0x08, 0x80, 0x87, 0x2E, 0x50, 0x4E, 0xAB,
  0x20,
  // "Ű" (U+0170)
  0x00, 0x00, 0xA5, 0xC3, 0x00, 0x05, 0x67, 0x40, 0x00, 0x00, 0x00, 0x00, 0x03, 0xC0, 0x07, 0x80,
  0x06, 0x90, 0x0A, 0x50, 0x09, 0x50, 0x0D, 0x20, 0x0C, 0x20, 0x1E, 0x00, 0x0E, 0x00, 0x4B, 0x00,
  0x3B, 0x00, 0x77, 0x00, 0x69, 0x00, 0xB3, 0x00, 0x5B, 0x04, 0xD0, 0x00, 0x0B, 0xEC, 0x30, 0x00,
  // "ű" (U+0171)
  0x00, 0x0A, 0x5C, 0x30, 0x05, 0x67, 0x40, 0x00, 0x00, 0x00, 0x00, 0xA4, 0x0A, 0x40, 0x0D, 0x10,
  0xD1, 0x01, 0xE0, 0x0E, 0x00, 0x4B, 0x04, 0xB0, 0x07, 0x80, 0x88, 0x00, 0x87, 0x2E, 0x50, 0x04,
  0xEA, 0xB2, 0x00,
  // "Ų" (U+0172)
  0x03, 0xC0, 0x07, 0x80, 0x69, 0x00, 0xA5, 0x09, 0x50, 0x0D, 0x20, 0xC2, 0x01, 0xE0, 0x0E, 0x00,
  0x4B, 0x03, 0xB0, 0x07, 0x70, 0x69, 0x00, 0xB3, 0x05, 0xB0, 0x4D, 0x00, 0x0B, 0xFD, 0x30, 0x00,
  0x19, 0x00, 0x00, 0x07, 0x50, 0x00, 0x00, 0x4D, 0x10, 0x00,
  // "ų" (U+0173)
  0x0A, 0x40, 0xA4, 0x0D, 0x10, 0xD1, 0x1E, 0x00, 0xE0, 0x4B, 0x04, 0xB0, 0x78, 0x08, 0x80, 0x87,
  0x2E, 0x50, 0x4E, 0xAB, 0x20, 0x00, 0x19, 0x00, 0x00, 0x75, 0x00, 0x00, 0x4D, 0x10,
  // "Ŵ" (U+0174)
  0x30, 0x70, 0xD6, 0x82, 0x47, 0x65, 0x75, 0x83, 0xD1, 0x05, 0xC2, 0x8C, 0x2A, 0x5D, 0x10, 0xBC,
  0x01, 0xE0, 0xD1, 0x1B, 0xC0, 0x68, 0x0E, 0x07, 0x6B, 0x0C, 0x20, 0xE0, 0xC1, 0xB3, 0xB2, 0x85,
  0xE5, 0x81, 0xB9, 0x52, 0x84, 0xEA, 0x21, 0xBD, 0x38, 0x4D, 0xB0, 0x1E, 0x93, 0x84, 0xE6, 0x01,
  0xF3, 0x30,
  // "ŵ" (U+0175)
  0x30, 0x70, 0xD5, 0x82, 0x47, 0x65, 0x73, 0x8C, 0x44, 0xA0, 0x8B, 0x07, 0x74, 0xA0, 0xCB, 0x0C,
  0x24, 0xA4, 0x9B, 0x3B, 0x04, 0x9A, 0x3B, 0x85, 0x04, 0xAB, 0x1B, 0xD2, 0x84, 0x4E, 0x61, 0xE8,
  0x28, 0x44, 0xF1, 0x2F, 0x32,
  // "Ŷ" (U+0176)
  0x00, 0x7D, 0x00, 0x47, 0x65, 0x00, 0x00, 0x0D, 0x10, 0x79, 0xB3, 0x0D, 0x19, 0x57, 0x70, 0x78,
  0xD0, 0x04, 0xF6, 0x00, 0x3D, 0x00, 0x05, 0xA0, 0x00, 0x86, 0x00, 0x0B, 0x30, 0x00,
  // "ŷ" (U+0177)
  0x40, 0x70, 0xD4, 0x82, 0x47, 0x65, 0x72, 0x83, 0x4A, 0x01, 0xD2, 0x83, 0x3B, 0x07, 0x72, 0x83,
  0x2B, 0x0D, 0x12, 0x82, 0x1C, 0x59, 0x48, 0x1C, 0xB2, 0x40, 0xD0, 0xB5, 0x0E, 0x04, 0x40, 0x10,
  0xD5, 0x09, 0x06, 0x38, 0x11, 0xDA, 0x40,
  // "Ÿ" (U+0178)
  0x07, 0x29, 0x10, 0x00, 0x00, 0xD1, 0x07, 0x9B, 0x30, 0xD1, 0x95, 0x77, 0x07, 0x8D, 0x00, 0x4F,
  0x60, 0x03, 0xD0, 0x00, 0x5A, 0x00, 0x08, 0x60, 0x00, 0xB3, 0x00, 0x00,
  // "Ź" (U+0179)
  0x50, 0x90, 0x74, 0x05, 0x08, 0x73, 0x83, 0x7D, 0xDF, 0x44, 0x04, 0x0C, 0x50, 0xD0, 0x44, 0x07,
  0x0A, 0x48, 0x11, 0xE1, 0x40, 0xA0, 0x74, 0x03, 0x0D, 0x50, 0xC0, 0x44, 0x83, 0x4F, 0xDD, 0xA2,
  // "ź" (U+017A)
  0x40, 0x90, 0x73, 0x05, 0x08, 0x72, 0x82, 0xCD, 0xF1, 0x30, 0x60, 0x93, 0x81, 0x1D, 0x13, 0x08,
  0x07, 0x30, 0x20, 0xC4, 0x0B, 0x04, 0x38, 0x23, 0xFD, 0xD2,
  // "Ż" (U+017B)
  0x40, 0x40, 0x77, 0x38, 0x37, 0xDD, 0xF4, 0x40, 0x40, 0xC5, 0x0D, 0x04, 0x40, 0x70, 0xA4, 0x81,
  0x1E, 0x14, 0x0A, 0x07, 0x40, 0x30, 0xD5, 0x0C, 0x04, 0x48, 0x34, 0xFD, 0xDA, 0x20,
  // "ż" (U+017C)
  0x30, 0x40, 0x77, 0x28, 0x2C, 0xDF, 0x13, 0x06, 0x09, 0x38, 0x11, 0xD1, 0x30, 0x80, 0x73, 0x02,
  0x0C, 0x40, 0xB0, 0x43, 0x82, 0x3F, 0xDD, 0x20,
  // "Ž" (U+017D)
  0x38, 0x21, 0x94, 0x74, 0x0A, 0x0B, 0x73, 0x83, 0x7D, 0xDF, 0x44, 0x04, 0x0C, 0x50, 0xD0, 0x44,
  0x07, 0x0A, 0x48, 0x11, 0xE1, 0x40, 0xA0, 0x74, 0x03, 0x0D, 0x50, 0xC0, 0x44, 0x83, 0x4F, 0xDD,
  0xA2,
  // "ž" (U+017E)
  0x28, 0x21, 0x94, 0x73, 0x0A, 0x0B, 0x72, 0x82, 0xCD, 0xF1, 0x30, 0x60, 0x93, 0x81, 0x1D, 0x13,
  0x08, 0x07, 0x30, 0x20, 0xC4, 0x0B, 0x04, 0x38, 0x23, 0xFD, 0xD2,
  // "ſ" (U+017F)
  0x48, 0x19, 0xD2, 0x30, 0x30, 0xC5, 0x00, 0x75, 0x0A, 0x04, 0x50, 0xD0, 0x15, 0x0E, 0x50, 0x30,
  0xB5, 0x07, 0x08, 0x50, 0xA0, 0x55, 0x0D, 0x01, 0x50, 0xE5, 0x05, 0x0A, 0x48, 0x17, 0xD2, 0x40,
  // "Ω" (U+03A9)
  0x00, 0x04, 0xCD, 0xA0, 0x00, 0x3D, 0x20, 0xB5, 0x00, 0xA5, 0x00, 0x78, 0x01, 0xE0, 0x00, 0x78,
  0x03, 0xB0, 0x00, 0xA5, 0x04, 0xA0, 0x00, 0xE1, 0x03, 0xB0, 0x07, 0x80, 0x00, 0xC1, 0x2B, 0x00,
  0x3D, 0xE5, 0xCE, 0xB0,
  // "μ" (U+03BC)
  0x28, 0x3A, 0x40, 0x95, 0x28, 0x3D, 0x10, 0xC2, 0x20, 0xE2, 0x0E, 0x28, 0x33, 0xB0, 0x3B, 0x28,
  0x36, 0x80, 0x78, 0x28, 0x39, 0x71, 0xD5, 0x28, 0x3C, 0xDA, 0xB2, 0x20, 0xE5, 0x03, 0x0B, 0x50,
  0x60, 0x85,
  // "π" (U+03C0)
  0x3E, 0xED, 0xFD, 0x0A, 0x40, 0xE0, 0x0D, 0x13, 0xB0, 0x0D, 0x06, 0x80, 0x3B, 0x09, 0x50, 0x67,
  0x0C, 0x20, 0x94, 0x09, 0xC0,
  // "–" (U+2013)
  0x8D, 0xDD, 0xD1,
  // "—" (U+2014)
  0x08, 0x80, 0x5D, 0x08,
  // "€" (U+20AC)
  0x28, 0x22, 0xBD, 0xA2, 0x85, 0xD4, 0x01, 0x06, 0x83, 0x83, 0x6F, 0xED, 0x32, 0x0E, 0x48, 0x2B,
  0xFD, 0x83, 0x0E, 0x50, 0xD0, 0x24, 0x82, 0x5D, 0xD3, 0x10,
  // "₿" (U+20BF)
  0x00, 0x04, 0x40, 0x00, 0x17, 0x80, 0x02, 0xFE, 0xC0, 0x05, 0xA0, 0xC4, 0x08, 0x70, 0xB4, 0x0B,
  0x43, 0xD0, 0x0E, 0xEE, 0x30, 0x2D, 0x08, 0x80, 0x5A, 0x05, 0xA0, 0x86, 0x0B, 0x50, 0xBE, 0xD6,
  0x00, 0x26, 0x80, 0x00,
  // "‘" (U+2018)
  0x02, 0xA0, 0xA3, 0x2D, 0x00,
  // "’" (U+2019)
  0x05, 0xA0, 0xB3, 0x2A, 0x00,
  // "‚" (U+201A)
  0x09, 0x70, 0xD0, 0x57, 0x00,
  // "‛" (U+201B)
  0xC3, 0xB3, 0x93,
  // "“" (U+201C)
  0x02, 0xA2, 0x90, 0xA4, 0xA3, 0x2E, 0x2D, 0x00,
  // "”" (U+201D)
  0x06, 0xA6, 0x90, 0xB3, 0xC2, 0x2A, 0x29, 0x00,
  // "„" (U+201E)
  0x0C, 0x4C, 0x32, 0xC2, 0xC0, 0x84, 0x83, 0x00,
  // "‟" (U+201F)
  0xC3, 0xD2, 0xA3, 0xC1, 0x84, 0xA2,
  // "†" (U+2020)
  0x00, 0xE1, 0x00, 0xC0, 0x35, 0xA4, 0x7A, 0xA9, 0x08, 0x20, 0x0B, 0x00, 0x0C, 0x00, 0x3A, 0x00,
  0x77, 0x00, 0xA5, 0x00,
  // "‡" (U+2021)
  0x30, 0xD0, 0x14, 0x0C, 0x38, 0x90, 0x68, 0xC8, 0x10, 0x48, 0x85, 0x30, 0x90, 0x34, 0x0C, 0x01,
  0x28, 0x91, 0x23, 0xB3, 0x10, 0x6A, 0xC9, 0x22, 0x05, 0x06, 0x40, 0x90, 0x43,
  // "•" (U+2022)
  0xAE, 0x6F, 0xFB, 0xAE, 0x50,
  // "…" (U+2026)
  0x75, 0x07, 0x57, 0x5B, 0x40, 0xB4, 0xB4,
  // "‰" (U+2030)
  0x03, 0xD8, 0x01, 0xA0, 0x00, 0x00, 0xB1, 0xC0, 0x92, 0x00, 0x00, 0x1B, 0x0B, 0x39, 0x00, 0x00,
  0x03, 0x82, 0x9A, 0x8D, 0x31, 0xC8, 0x48, 0x89, 0x9B, 0x48, 0xA2, 0xC1, 0xC9, 0xB6, 0x64, 0x7B,
  0x0C, 0x00, 0x66, 0x93, 0x77, 0x91, 0xA0, 0x1B, 0x09, 0x2B, 0x39, 0x65, 0x08, 0x40, 0x5E, 0x50,
  0xDA, 0x00,
  // "‹" (U+2039)
  0x00, 0x50, 0x78, 0x5B, 0x04, 0xA0, 0x0C, 0x10, 0x10,
  // "›" (U+203A)
  0x05, 0x00, 0xD1, 0x08, 0x70, 0xC3, 0xA4, 0x01, 0x00,
  // "⁄" (U+2044)
  0x60, 0xB0, 0x15, 0x08, 0x04, 0x50, 0x30, 0x95, 0x01, 0x0B, 0x60, 0x90, 0x35, 0x05, 0x07, 0x50,
  0x10, 0xB6, 0x0A, 0x02, 0x50, 0x70, 0x56,
  // "™" (U+2122)
  0xCF, 0xF9, 0x70, 0xA5, 0x09, 0x09, 0xA0, 0xD5, 0x09, 0x09, 0x95, 0x95, 0x09, 0x09, 0x4C, 0x45,
  0x04, 0x04, 0x04, 0x22,
  // "⅒" (U+2152)
  0x60, 0xB0, 0x14, 0x09, 0x0A, 0x20, 0x80, 0x44, 0x84, 0x37, 0x60, 0x39, 0x68, 0x28, 0x31, 0xB3,
  0x0A, 0x0B, 0x28, 0xA6, 0xB0, 0x93, 0x9A, 0x84, 0x93, 0x0B, 0x57, 0x37, 0x6C, 0x09, 0x20, 0x1B,
  0x28, 0x38, 0x3B, 0x0B, 0x20, 0xA0, 0x22, 0x86, 0xB1, 0xB2, 0xA0, 0x75, 0x38, 0x3B, 0x09, 0xB1,
  0x10,
  // "ﬁ" (U+FB01)
  0x48, 0x28, 0xD6, 0x93, 0x01, 0x0D, 0x60, 0x50, 0x95, 0x84, 0x3D, 0xE6, 0x95, 0x38, 0x3B, 0x30,
  0xC2, 0x30, 0xE2, 0x0E, 0x38, 0x31, 0xD0, 0x3B, 0x38, 0x34, 0xA0, 0x68, 0x38, 0x38, 0x70, 0x95,
  0x38, 0x3B, 0x30, 0xC2, 0x30, 0xE6, 0x03, 0x0C, 0x58, 0x15, 0xD4, 0x50,
  // "ﬂ" (U+FB02)
  0x48, 0x28, 0xD5, 0xD3, 0x83, 0x1D, 0x03, 0xB3, 0x83, 0x59, 0x06, 0x72, 0x84, 0x3D, 0xE6, 0x95,
  0x38, 0x3B, 0x30, 0xD1, 0x30, 0xE2, 0x0E, 0x38, 0x31, 0xD0, 0x3B, 0x38, 0x34, 0xA0, 0x68, 0x38,
  0x38, 0x70, 0x95, 0x38, 0x3B, 0x30, 0xC2, 0x30, 0xE6, 0x03, 0x0C, 0x58, 0x15, 0xD4, 0x50,
};

const Font& font_NotoSans_CondensedItalic_12() {
  static SmoothFont font(font_NotoSans_CondensedItalic_12_data);
  return font;
}

}  // namespace roo_display
