#include "10.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSans-CondensedItalic (Noto Sans Condensed Italic)
// Generated on Wed Nov 19 19:11:24 CET 2025
static const uint8_t font_NotoSans_CondensedItalic_10_data[] PROGMEM = {
  
  // Header
  0x01, 0x02, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x01, 0xEA,
  0xFD, 0xFE, 0x09, 0x0B, 0x08, 0xFD, 0x03, 0x01, 0x0A, 0x03, 0x02, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x40, 0x01, 0x02, 0x08, 0x02, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x41, 0x06, 0x03, 0x08, 0x04, 0x00, 0x0C, // """ (U+0022)
  0x00, 0x23, 0x40, 0x01, 0x04, 0x08, 0x05, 0x00, 0x11, // "#" (U+0023)
  0x00, 0x24, 0x40, 0x00, 0x04, 0x08, 0x04, 0x00, 0x25, // "$" (U+0024)
  0x00, 0x25, 0x40, 0x01, 0x06, 0x08, 0x07, 0x00, 0x3C, // "%" (U+0025)
  0x00, 0x26, 0x40, 0x01, 0x04, 0x08, 0x05, 0x00, 0x58, // "&" (U+0026)
  0x00, 0x27, 0x41, 0x06, 0x02, 0x08, 0x02, 0x00, 0x6C, // "'" (U+0027)
  0x00, 0x28, 0x40, 0xFF, 0x03, 0x08, 0x03, 0x00, 0x6F, // "(" (U+0028)
  0x00, 0x29, 0xBF, 0xFF, 0x02, 0x08, 0x03, 0x00, 0x83, // ")" (U+0029)
  0x00, 0x2A, 0x41, 0x05, 0x04, 0x09, 0x04, 0x00, 0x97, // "*" (U+002A)
  0x00, 0x2B, 0x00, 0x02, 0x04, 0x06, 0x05, 0x00, 0xA1, // "+" (U+002B)
  0x00, 0x2C, 0xBF, 0x00, 0x01, 0x02, 0x02, 0x00, 0xAC, // "," (U+002C)
  0x00, 0x2D, 0x40, 0x03, 0x02, 0x03, 0x03, 0x00, 0xB1, // "-" (U+002D)
  0x00, 0x2E, 0x40, 0x01, 0x01, 0x01, 0x02, 0x00, 0xB3, // "." (U+002E)
  0x00, 0x2F, 0xFF, 0x01, 0x03, 0x08, 0x03, 0x00, 0xB4, // "/" (U+002F)
  0x00, 0x30, 0x40, 0x01, 0x04, 0x08, 0x04, 0x00, 0xC6, // "0" (U+0030)
  0x00, 0x31, 0x41, 0x01, 0x03, 0x08, 0x04, 0x00, 0xDA, // "1" (U+0031)
  0x00, 0x32, 0xBF, 0x01, 0x04, 0x08, 0x04, 0x00, 0xE6, // "2" (U+0032)
  0x00, 0x33, 0x40, 0x01, 0x04, 0x08, 0x04, 0x00, 0xFE, // "3" (U+0033)
  0x00, 0x34, 0x40, 0x01, 0x04, 0x08, 0x04, 0x01, 0x12, // "4" (U+0034)
  0x00, 0x35, 0x00, 0x01, 0x04, 0x08, 0x04, 0x01, 0x26, // "5" (U+0035)
  0x00, 0x36, 0x40, 0x01, 0x04, 0x08, 0x04, 0x01, 0x39, // "6" (U+0036)
  0x00, 0x37, 0x00, 0x01, 0x04, 0x08, 0x04, 0x01, 0x4D, // "7" (U+0037)
  0x00, 0x38, 0x40, 0x01, 0x04, 0x08, 0x04, 0x01, 0x60, // "8" (U+0038)
  0x00, 0x39, 0x40, 0x01, 0x04, 0x08, 0x04, 0x01, 0x74, // "9" (U+0039)
  0x00, 0x3A, 0x00, 0x01, 0x01, 0x06, 0x02, 0x01, 0x88, // ":" (U+003A)
  0x00, 0x3B, 0xFF, 0xFF, 0x01, 0x06, 0x02, 0x01, 0x8C, // ";" (U+003B)
  0x00, 0x3C, 0x40, 0x02, 0x04, 0x06, 0x05, 0x01, 0x95, // "<" (U+003C)
  0x00, 0x3D, 0x40, 0x03, 0x04, 0x05, 0x05, 0x01, 0xA2, // "=" (U+003D)
  0x00, 0x3E, 0x00, 0x02, 0x04, 0x06, 0x05, 0x01, 0xAA, // ">" (U+003E)
  0x00, 0x3F, 0x40, 0x01, 0x03, 0x08, 0x03, 0x01, 0xB6, // "?" (U+003F)
  0x00, 0x40, 0x40, 0x00, 0x06, 0x08, 0x07, 0x01, 0xC6, // "@" (U+0040)
  0x00, 0x41, 0xBF, 0x01, 0x03, 0x08, 0x05, 0x01, 0xE6, // "A" (U+0041)
  0x00, 0x42, 0x40, 0x01, 0x04, 0x08, 0x05, 0x01, 0xFA, // "B" (U+0042)
  0x00, 0x43, 0x40, 0x01, 0x04, 0x08, 0x04, 0x02, 0x0E, // "C" (U+0043)
  0x00, 0x44, 0x40, 0x01, 0x04, 0x08, 0x05, 0x02, 0x22, // "D" (U+0044)
  0x00, 0x45, 0x40, 0x01, 0x04, 0x08, 0x04, 0x02, 0x36, // "E" (U+0045)
  0x00, 0x46, 0x00, 0x01, 0x04, 0x08, 0x04, 0x02, 0x4A, // "F" (U+0046)
  0x00, 0x47, 0x40, 0x01, 0x05, 0x08, 0x05, 0x02, 0x5C, // "G" (U+0047)
  0x00, 0x48, 0x40, 0x01, 0x05, 0x08, 0x05, 0x02, 0x74, // "H" (U+0048)
  0x00, 0x49, 0xFF, 0x01, 0x03, 0x08, 0x03, 0x02, 0x8C, // "I" (U+0049)
  0x00, 0x4A, 0xFE, 0xFF, 0x02, 0x08, 0x02, 0x02, 0x9F, // "J" (U+004A)
  0x00, 0x4B, 0x40, 0x01, 0x05, 0x08, 0x05, 0x02, 0xB6, // "K" (U+004B)
  0x00, 0x4C, 0x40, 0x01, 0x02, 0x08, 0x04, 0x02, 0xCE, // "L" (U+004C)
  0x00, 0x4D, 0x40, 0x01, 0x07, 0x08, 0x07, 0x02, 0xDA, // "M" (U+004D)
  0x00, 0x4E, 0x40, 0x01, 0x05, 0x08, 0x06, 0x02, 0xFA, // "N" (U+004E)
  0x00, 0x4F, 0x40, 0x01, 0x05, 0x08, 0x06, 0x03, 0x12, // "O" (U+004F)
  0x00, 0x50, 0x40, 0x01, 0x04, 0x08, 0x05, 0x03, 0x2A, // "P" (U+0050)
  0x00, 0x51, 0x40, 0xFF, 0x05, 0x08, 0x06, 0x03, 0x3E, // "Q" (U+0051)
  0x00, 0x52, 0x40, 0x01, 0x04, 0x08, 0x05, 0x03, 0x5C, // "R" (U+0052)
  0x00, 0x53, 0x40, 0x01, 0x04, 0x08, 0x04, 0x03, 0x70, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x04, 0x08, 0x04, 0x03, 0x84, // "T" (U+0054)
  0x00, 0x55, 0x40, 0x01, 0x05, 0x08, 0x05, 0x03, 0x95, // "U" (U+0055)
  0x00, 0x56, 0x40, 0x01, 0x05, 0x08, 0x04, 0x03, 0xAD, // "V" (U+0056)
  0x00, 0x57, 0x40, 0x01, 0x07, 0x08, 0x07, 0x03, 0xC5, // "W" (U+0057)
  0x00, 0x58, 0xBF, 0x01, 0x04, 0x08, 0x04, 0x03, 0xE5, // "X" (U+0058)
  0x00, 0x59, 0x41, 0x01, 0x04, 0x08, 0x04, 0x03, 0xFD, // "Y" (U+0059)
  0x00, 0x5A, 0xFF, 0x01, 0x04, 0x08, 0x04, 0x04, 0x0D, // "Z" (U+005A)
  0x00, 0x5B, 0xFF, 0xFF, 0x03, 0x08, 0x03, 0x04, 0x24, // "[" (U+005B)
  0x00, 0x5C, 0x41, 0x01, 0x02, 0x08, 0x03, 0x04, 0x3B, // "\" (U+005C)
  0x00, 0x5D, 0xBF, 0xFF, 0x02, 0x08, 0x03, 0x04, 0x43, // "]" (U+005D)
  0x00, 0x5E, 0x40, 0x04, 0x04, 0x08, 0x05, 0x04, 0x57, // "^" (U+005E)
  0x00, 0x5F, 0xBF, 0xFF, 0x02, 0xFF, 0x03, 0x04, 0x64, // "_" (U+005F)
  0x00, 0x60, 0x41, 0x08, 0x02, 0x09, 0x03, 0x04, 0x66, // "`" (U+0060)
  0x00, 0x61, 0x40, 0x01, 0x04, 0x06, 0x05, 0x04, 0x68, // "a" (U+0061)
  0x00, 0x62, 0x40, 0x01, 0x04, 0x08, 0x05, 0x04, 0x77, // "b" (U+0062)
  0x00, 0x63, 0x40, 0x01, 0x03, 0x06, 0x04, 0x04, 0x8B, // "c" (U+0063)
  0x00, 0x64, 0x00, 0x01, 0x04, 0x08, 0x05, 0x04, 0x97, // "d" (U+0064)
  0x00, 0x65, 0x40, 0x01, 0x03, 0x06, 0x04, 0x04, 0xAA, // "e" (U+0065)
  0x00, 0x66, 0xFE, 0xFE, 0x03, 0x08, 0x03, 0x04, 0xB6, // "f" (U+0066)
  0x00, 0x67, 0x40, 0xFE, 0x04, 0x06, 0x05, 0x04, 0xD2, // "g" (U+0067)
  0x00, 0x68, 0x40, 0x01, 0x04, 0x08, 0x05, 0x04, 0xE9, // "h" (U+0068)
  0x00, 0x69, 0x40, 0x01, 0x02, 0x08, 0x02, 0x04, 0xFD, // "i" (U+0069)
  0x00, 0x6A, 0xFE, 0xFE, 0x02, 0x08, 0x02, 0x05, 0x09, // "j" (U+006A)
  0x00, 0x6B, 0x40, 0x01, 0x04, 0x08, 0x04, 0x05, 0x20, // "k" (U+006B)
  0x00, 0x6C, 0x40, 0x01, 0x02, 0x08, 0x02, 0x05, 0x34, // "l" (U+006C)
  0x00, 0x6D, 0x40, 0x01, 0x06, 0x06, 0x07, 0x05, 0x40, // "m" (U+006D)
  0x00, 0x6E, 0x40, 0x01, 0x04, 0x06, 0x05, 0x05, 0x55, // "n" (U+006E)
  0x00, 0x6F, 0x40, 0x01, 0x04, 0x06, 0x05, 0x05, 0x64, // "o" (U+006F)
  0x00, 0x70, 0xBF, 0xFE, 0x04, 0x06, 0x05, 0x05, 0x73, // "p" (U+0070)
  0x00, 0x71, 0x40, 0xFE, 0x04, 0x06, 0x05, 0x05, 0x8E, // "q" (U+0071)
  0x00, 0x72, 0x40, 0x01, 0x03, 0x06, 0x03, 0x05, 0xA5, // "r" (U+0072)
  0x00, 0x73, 0x40, 0x01, 0x03, 0x06, 0x04, 0x05, 0xB1, // "s" (U+0073)
  0x00, 0x74, 0x40, 0x01, 0x02, 0x08, 0x03, 0x05, 0xBD, // "t" (U+0074)
  0x00, 0x75, 0x40, 0x01, 0x04, 0x06, 0x05, 0x05, 0xC9, // "u" (U+0075)
  0x00, 0x76, 0x40, 0x01, 0x04, 0x06, 0x04, 0x05, 0xD8, // "v" (U+0076)
  0x00, 0x77, 0x40, 0x01, 0x06, 0x06, 0x06, 0x05, 0xE7, // "w" (U+0077)
  0x00, 0x78, 0xBF, 0x01, 0x03, 0x06, 0x04, 0x05, 0xFC, // "x" (U+0078)
  0x00, 0x79, 0xBF, 0xFE, 0x04, 0x06, 0x04, 0x06, 0x0B, // "y" (U+0079)
  0x00, 0x7A, 0xBF, 0x01, 0x03, 0x06, 0x03, 0x06, 0x26, // "z" (U+007A)
  0x00, 0x7B, 0x40, 0xFF, 0x03, 0x08, 0x03, 0x06, 0x35, // "{" (U+007B)
  0x00, 0x7C, 0x41, 0xFE, 0x02, 0x08, 0x04, 0x06, 0x49, // "|" (U+007C)
  0x00, 0x7D, 0xBF, 0xFF, 0x02, 0x08, 0x03, 0x06, 0x54, // "}" (U+007D)
  0x00, 0x7E, 0x40, 0x04, 0x04, 0x05, 0x05, 0x06, 0x68, // "~" (U+007E)
  0x00, 0xA1, 0xBF, 0xFF, 0x02, 0x06, 0x02, 0x06, 0x6D, // "¡" (U+00A1)
  0x00, 0xA2, 0x00, 0x01, 0x04, 0x08, 0x04, 0x06, 0x7D, // "¢" (U+00A2)
  0x00, 0xA3, 0xFF, 0x01, 0x04, 0x08, 0x04, 0x06, 0x90, // "£" (U+00A3)
  0x00, 0xA4, 0x40, 0x03, 0x04, 0x07, 0x05, 0x06, 0xA7, // "¤" (U+00A4)
  0x00, 0xA5, 0x40, 0x01, 0x04, 0x08, 0x04, 0x06, 0xB4, // "¥" (U+00A5)
  0x00, 0xA6, 0x41, 0xFE, 0x02, 0x08, 0x04, 0x06, 0xC8, // "¦" (U+00A6)
  0x00, 0xA7, 0x40, 0x01, 0x03, 0x08, 0x04, 0x06, 0xD3, // "§" (U+00A7)
  0x00, 0xA8, 0x42, 0x08, 0x04, 0x08, 0x05, 0x06, 0xE3, // "¨" (U+00A8)
  0x00, 0xA9, 0x40, 0x01, 0x07, 0x08, 0x08, 0x06, 0xE5, // "©" (U+00A9)
  0x00, 0xAA, 0x40, 0x05, 0x03, 0x07, 0x03, 0x07, 0x05, // "ª" (U+00AA)
  0x00, 0xAB, 0x40, 0x01, 0x04, 0x05, 0x04, 0x07, 0x0B, // "«" (U+00AB)
  0x00, 0xAC, 0x40, 0x02, 0x04, 0x04, 0x05, 0x07, 0x18, // "¬" (U+00AC)
  0x00, 0xAE, 0x40, 0x01, 0x07, 0x08, 0x08, 0x07, 0x20, // "®" (U+00AE)
  0x00, 0xAF, 0x41, 0x09, 0x04, 0x09, 0x04, 0x07, 0x40, // "¯" (U+00AF)
  0x00, 0xB0, 0x40, 0x06, 0x03, 0x08, 0x04, 0x07, 0x42, // "°" (U+00B0)
  0x00, 0xB1, 0x00, 0x01, 0x04, 0x07, 0x05, 0x07, 0x48, // "±" (U+00B1)
  0x00, 0xB2, 0x40, 0x05, 0x03, 0x09, 0x03, 0x07, 0x56, // "²" (U+00B2)
  0x00, 0xB3, 0x40, 0x05, 0x03, 0x09, 0x03, 0x07, 0x60, // "³" (U+00B3)
  0x00, 0xB4, 0x41, 0x08, 0x02, 0x09, 0x03, 0x07, 0x6A, // "´" (U+00B4)
  0x00, 0xB5, 0xBF, 0xFE, 0x04, 0x06, 0x05, 0x07, 0x6C, // "µ" (U+00B5)
  0x00, 0xB6, 0x40, 0xFF, 0x04, 0x08, 0x05, 0x07, 0x87, // "¶" (U+00B6)
  0x00, 0xB7, 0x41, 0x04, 0x02, 0x04, 0x02, 0x07, 0xA0, // "·" (U+00B7)
  0x00, 0xB8, 0xBF, 0xFE, 0x00, 0x00, 0x02, 0x07, 0xA1, // "¸" (U+00B8)
  0x00, 0xB9, 0x41, 0x05, 0x02, 0x09, 0x03, 0x07, 0xA4, // "¹" (U+00B9)
  0x00, 0xBA, 0x40, 0x05, 0x03, 0x07, 0x03, 0x07, 0xA9, // "º" (U+00BA)
  0x00, 0xBB, 0x40, 0x01, 0x03, 0x05, 0x04, 0x07, 0xAF, // "»" (U+00BB)
  0x00, 0xBC, 0x40, 0x01, 0x06, 0x08, 0x07, 0x07, 0xB9, // "¼" (U+00BC)
  0x00, 0xBD, 0x40, 0x01, 0x06, 0x08, 0x07, 0x07, 0xD5, // "½" (U+00BD)
  0x00, 0xBE, 0x40, 0x01, 0x06, 0x08, 0x07, 0x07, 0xF1, // "¾" (U+00BE)
  0x00, 0xBF, 0xBF, 0xFE, 0x02, 0x05, 0x03, 0x08, 0x0D, // "¿" (U+00BF)
  0x00, 0xC0, 0xFF, 0x01, 0x03, 0x0B, 0x05, 0x08, 0x1D, // "À" (U+00C0)
  0x00, 0xC1, 0xFF, 0x01, 0x04, 0x0B, 0x05, 0x08, 0x37, // "Á" (U+00C1)
  0x00, 0xC2, 0xFF, 0x01, 0x04, 0x0B, 0x05, 0x08, 0x55, // "Â" (U+00C2)
  0x00, 0xC3, 0xFF, 0x01, 0x05, 0x0B, 0x05, 0x08, 0x74, // "Ã" (U+00C3)
  0x00, 0xC4, 0xFF, 0x01, 0x04, 0x0A, 0x05, 0x08, 0x94, // "Ä" (U+00C4)
  0x00, 0xC5, 0xBF, 0x01, 0x04, 0x0B, 0x05, 0x08, 0xB0, // "Å" (U+00C5)
  0x00, 0xC6, 0xFF, 0x01, 0x06, 0x08, 0x06, 0x08, 0xD1, // "Æ" (U+00C6)
  0x00, 0xC7, 0x00, 0xFE, 0x04, 0x08, 0x04, 0x08, 0xEF, // "Ç" (U+00C7)
  0x00, 0xC8, 0x00, 0x01, 0x04, 0x0B, 0x04, 0x09, 0x08, // "È" (U+00C8)
  0x00, 0xC9, 0x00, 0x01, 0x04, 0x0B, 0x04, 0x09, 0x20, // "É" (U+00C9)
  0x00, 0xCA, 0x00, 0x01, 0x04, 0x0B, 0x04, 0x09, 0x39, // "Ê" (U+00CA)
  0x00, 0xCB, 0x00, 0x01, 0x04, 0x0A, 0x04, 0x09, 0x53, // "Ë" (U+00CB)
  0x00, 0xCC, 0xFF, 0x01, 0x03, 0x0B, 0x03, 0x09, 0x6A, // "Ì" (U+00CC)
  0x00, 0xCD, 0xFF, 0x01, 0x03, 0x0B, 0x03, 0x09, 0x82, // "Í" (U+00CD)
  0x00, 0xCE, 0xFF, 0x01, 0x03, 0x0B, 0x03, 0x09, 0x9A, // "Î" (U+00CE)
  0x00, 0xCF, 0xFF, 0x01, 0x03, 0x0A, 0x03, 0x09, 0xB3, // "Ï" (U+00CF)
  0x00, 0xD0, 0x40, 0x01, 0x04, 0x08, 0x05, 0x09, 0xC9, // "Ð" (U+00D0)
  0x00, 0xD1, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x09, 0xDD, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x09, 0xFE, // "Ò" (U+00D2)
  0x00, 0xD3, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x0A, 0x1E, // "Ó" (U+00D3)
  0x00, 0xD4, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x0A, 0x3F, // "Ô" (U+00D4)
  0x00, 0xD5, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x0A, 0x60, // "Õ" (U+00D5)
  0x00, 0xD6, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x0A, 0x81, // "Ö" (U+00D6)
  0x00, 0xD7, 0x40, 0x02, 0x04, 0x06, 0x05, 0x0A, 0x9F, // "×" (U+00D7)
  0x00, 0xD8, 0x00, 0x00, 0x05, 0x09, 0x06, 0x0A, 0xAC, // "Ø" (U+00D8)
  0x00, 0xD9, 0x00, 0x01, 0x05, 0x0B, 0x05, 0x0A, 0xC8, // "Ù" (U+00D9)
  0x00, 0xDA, 0x00, 0x01, 0x05, 0x0B, 0x05, 0x0A, 0xE7, // "Ú" (U+00DA)
  0x00, 0xDB, 0x40, 0x01, 0x05, 0x0B, 0x05, 0x0B, 0x07, // "Û" (U+00DB)
  0x00, 0xDC, 0x40, 0x01, 0x05, 0x0A, 0x05, 0x0B, 0x28, // "Ü" (U+00DC)
  0x00, 0xDD, 0x41, 0x01, 0x04, 0x0B, 0x04, 0x0B, 0x46, // "Ý" (U+00DD)
  0x00, 0xDE, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0B, 0x5C, // "Þ" (U+00DE)
  0x00, 0xDF, 0xFE, 0xFE, 0x04, 0x08, 0x05, 0x0B, 0x70, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0B, 0x93, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0B, 0xA8, // "á" (U+00E1)
  0x00, 0xE2, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0B, 0xBE, // "â" (U+00E2)
  0x00, 0xE3, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0B, 0xD4, // "ã" (U+00E3)
  0x00, 0xE4, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0B, 0xEA, // "ä" (U+00E4)
  0x00, 0xE5, 0x40, 0x01, 0x04, 0x09, 0x05, 0x0B, 0xFE, // "å" (U+00E5)
  0x00, 0xE6, 0x40, 0x01, 0x06, 0x06, 0x07, 0x0C, 0x15, // "æ" (U+00E6)
  0x00, 0xE7, 0x40, 0xFE, 0x03, 0x06, 0x04, 0x0C, 0x2A, // "ç" (U+00E7)
  0x00, 0xE8, 0x40, 0x01, 0x03, 0x09, 0x04, 0x0C, 0x3C, // "è" (U+00E8)
  0x00, 0xE9, 0x40, 0x01, 0x03, 0x09, 0x04, 0x0C, 0x4E, // "é" (U+00E9)
  0x00, 0xEA, 0x40, 0x01, 0x03, 0x09, 0x04, 0x0C, 0x60, // "ê" (U+00EA)
  0x00, 0xEB, 0x40, 0x01, 0x04, 0x08, 0x04, 0x0C, 0x72, // "ë" (U+00EB)
  0x00, 0xEC, 0x40, 0x01, 0x01, 0x09, 0x02, 0x0C, 0x86, // "ì" (U+00EC)
  0x00, 0xED, 0x40, 0x01, 0x02, 0x09, 0x02, 0x0C, 0x8F, // "í" (U+00ED)
  0x00, 0xEE, 0x40, 0x01, 0x02, 0x09, 0x02, 0x0C, 0x9D, // "î" (U+00EE)
  0x00, 0xEF, 0x40, 0x01, 0x03, 0x08, 0x02, 0x0C, 0xAB, // "ï" (U+00EF)
  0x00, 0xF0, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0C, 0xBB, // "ð" (U+00F0)
  0x00, 0xF1, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0C, 0xCF, // "ñ" (U+00F1)
  0x00, 0xF2, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0C, 0xE5, // "ò" (U+00F2)
  0x00, 0xF3, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0C, 0xFA, // "ó" (U+00F3)
  0x00, 0xF4, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0D, 0x10, // "ô" (U+00F4)
  0x00, 0xF5, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0D, 0x26, // "õ" (U+00F5)
  0x00, 0xF6, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0D, 0x3C, // "ö" (U+00F6)
  0x00, 0xF7, 0x00, 0x02, 0x04, 0x06, 0x05, 0x0D, 0x50, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x00, 0x04, 0x07, 0x05, 0x0D, 0x58, // "ø" (U+00F8)
  0x00, 0xF9, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0D, 0x6B, // "ù" (U+00F9)
  0x00, 0xFA, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0D, 0x80, // "ú" (U+00FA)
  0x00, 0xFB, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0D, 0x96, // "û" (U+00FB)
  0x00, 0xFC, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0D, 0xAC, // "ü" (U+00FC)
  0x00, 0xFD, 0xFF, 0xFE, 0x04, 0x09, 0x04, 0x0D, 0xC0, // "ý" (U+00FD)
  0x00, 0xFE, 0xFF, 0xFE, 0x04, 0x08, 0x05, 0x0D, 0xE1, // "þ" (U+00FE)
  0x00, 0xFF, 0xFF, 0xFE, 0x04, 0x08, 0x04, 0x0E, 0x00, // "ÿ" (U+00FF)
  0x01, 0x00, 0xFF, 0x01, 0x04, 0x0A, 0x05, 0x0E, 0x1F, // "Ā" (U+0100)
  0x01, 0x01, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0E, 0x3B, // "ā" (U+0101)
  0x01, 0x02, 0xFF, 0x01, 0x04, 0x0B, 0x05, 0x0E, 0x4F, // "Ă" (U+0102)
  0x01, 0x03, 0x40, 0x01, 0x04, 0x09, 0x05, 0x0E, 0x6E, // "ă" (U+0103)
  0x01, 0x04, 0xBF, 0xFE, 0x03, 0x08, 0x05, 0x0E, 0x85, // "Ą" (U+0104)
  0x01, 0x05, 0x40, 0xFE, 0x04, 0x06, 0x05, 0x0E, 0xA1, // "ą" (U+0105)
  0x01, 0x06, 0x00, 0x01, 0x04, 0x0B, 0x04, 0x0E, 0xB8, // "Ć" (U+0106)
  0x01, 0x07, 0x40, 0x01, 0x03, 0x09, 0x04, 0x0E, 0xD1, // "ć" (U+0107)
  0x01, 0x08, 0x00, 0x01, 0x04, 0x0B, 0x04, 0x0E, 0xE3, // "Ĉ" (U+0108)
  0x01, 0x09, 0x40, 0x01, 0x03, 0x09, 0x04, 0x0E, 0xFC, // "ĉ" (U+0109)
  0x01, 0x0A, 0x00, 0x01, 0x04, 0x0A, 0x04, 0x0F, 0x0E, // "Ċ" (U+010A)
  0x01, 0x0B, 0x40, 0x01, 0x03, 0x08, 0x04, 0x0F, 0x24, // "ċ" (U+010B)
  0x01, 0x0C, 0x00, 0x01, 0x04, 0x0B, 0x04, 0x0F, 0x34, // "Č" (U+010C)
  0x01, 0x0D, 0x40, 0x01, 0x03, 0x09, 0x04, 0x0F, 0x4E, // "č" (U+010D)
  0x01, 0x0E, 0x40, 0x01, 0x04, 0x0B, 0x05, 0x0F, 0x60, // "Ď" (U+010E)
  0x01, 0x0F, 0x40, 0x01, 0x06, 0x08, 0x05, 0x0F, 0x7C, // "ď" (U+010F)
  0x01, 0x10, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0F, 0x98, // "Đ" (U+0110)
  0x01, 0x11, 0x40, 0x01, 0x05, 0x08, 0x05, 0x0F, 0xAC, // "đ" (U+0111)
  0x01, 0x12, 0x00, 0x01, 0x04, 0x0A, 0x04, 0x0F, 0xC4, // "Ē" (U+0112)
  0x01, 0x13, 0x40, 0x01, 0x04, 0x08, 0x04, 0x0F, 0xDB, // "ē" (U+0113)
  0x01, 0x14, 0x00, 0x01, 0x04, 0x0B, 0x04, 0x0F, 0xEF, // "Ĕ" (U+0114)
  0x01, 0x15, 0x40, 0x01, 0x04, 0x09, 0x04, 0x10, 0x09, // "ĕ" (U+0115)
  0x01, 0x16, 0x00, 0x01, 0x04, 0x0A, 0x04, 0x10, 0x20, // "Ė" (U+0116)
  0x01, 0x17, 0x40, 0x01, 0x03, 0x08, 0x04, 0x10, 0x37, // "ė" (U+0117)
  0x01, 0x18, 0x00, 0xFE, 0x04, 0x08, 0x04, 0x10, 0x47, // "Ę" (U+0118)
  0x01, 0x19, 0x40, 0xFE, 0x03, 0x06, 0x04, 0x10, 0x62, // "ę" (U+0119)
  0x01, 0x1A, 0x00, 0x01, 0x04, 0x0B, 0x04, 0x10, 0x74, // "Ě" (U+011A)
  0x01, 0x1B, 0x40, 0x01, 0x03, 0x09, 0x04, 0x10, 0x8E, // "ě" (U+011B)
  0x01, 0x1C, 0x00, 0x01, 0x05, 0x0B, 0x05, 0x10, 0xA0, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x00, 0xFE, 0x04, 0x09, 0x05, 0x10, 0xBE, // "ĝ" (U+011D)
  0x01, 0x1E, 0x00, 0x01, 0x05, 0x0B, 0x05, 0x10, 0xDB, // "Ğ" (U+011E)
  0x01, 0x1F, 0x00, 0xFE, 0x04, 0x09, 0x05, 0x10, 0xF9, // "ğ" (U+011F)
  0x01, 0x20, 0x00, 0x01, 0x05, 0x0A, 0x05, 0x11, 0x16, // "Ġ" (U+0120)
  0x01, 0x21, 0x00, 0xFE, 0x04, 0x08, 0x05, 0x11, 0x31, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0xFF, 0x05, 0x08, 0x05, 0x11, 0x4B, // "Ģ" (U+0122)
  0x01, 0x23, 0x40, 0xFE, 0x04, 0x08, 0x05, 0x11, 0x68, // "ģ" (U+0123)
  0x01, 0x24, 0x40, 0x01, 0x05, 0x0B, 0x05, 0x11, 0x84, // "Ĥ" (U+0124)
  0x01, 0x25, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x11, 0xA5, // "ĥ" (U+0125)
  0x01, 0x26, 0x40, 0x01, 0x05, 0x08, 0x05, 0x11, 0xC0, // "Ħ" (U+0126)
  0x01, 0x27, 0x40, 0x01, 0x04, 0x08, 0x05, 0x11, 0xD8, // "ħ" (U+0127)
  0x01, 0x28, 0xFF, 0x01, 0x04, 0x0B, 0x03, 0x11, 0xEC, // "Ĩ" (U+0128)
  0x01, 0x29, 0x40, 0x01, 0x03, 0x09, 0x02, 0x12, 0x06, // "ĩ" (U+0129)
  0x01, 0x2A, 0xFF, 0x01, 0x03, 0x0A, 0x03, 0x12, 0x18, // "Ī" (U+012A)
  0x01, 0x2B, 0x40, 0x01, 0x02, 0x08, 0x02, 0x12, 0x2E, // "ī" (U+012B)
  0x01, 0x2C, 0xFF, 0x01, 0x03, 0x0B, 0x03, 0x12, 0x3A, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x40, 0x01, 0x02, 0x09, 0x02, 0x12, 0x53, // "ĭ" (U+012D)
  0x01, 0x2E, 0xFF, 0xFE, 0x03, 0x08, 0x03, 0x12, 0x61, // "Į" (U+012E)
  0x01, 0x2F, 0xBF, 0xFE, 0x02, 0x08, 0x02, 0x12, 0x7B, // "į" (U+012F)
  0x01, 0x30, 0xFF, 0x01, 0x03, 0x0A, 0x03, 0x12, 0x91, // "İ" (U+0130)
  0x01, 0x31, 0x40, 0x01, 0x01, 0x06, 0x02, 0x12, 0xA7, // "ı" (U+0131)
  0x01, 0x32, 0xBF, 0xFF, 0x05, 0x08, 0x05, 0x12, 0xAD, // "Ĳ" (U+0132)
  0x01, 0x33, 0x00, 0xFE, 0x04, 0x08, 0x04, 0x12, 0xD0, // "ĳ" (U+0133)
  0x01, 0x34, 0xFE, 0xFF, 0x03, 0x0B, 0x02, 0x12, 0xEB, // "Ĵ" (U+0134)
  0x01, 0x35, 0xFE, 0xFE, 0x02, 0x09, 0x02, 0x13, 0x08, // "ĵ" (U+0135)
  0x01, 0x36, 0x40, 0xFF, 0x05, 0x08, 0x05, 0x13, 0x22, // "Ķ" (U+0136)
  0x01, 0x37, 0x40, 0xFF, 0x04, 0x08, 0x04, 0x13, 0x40, // "ķ" (U+0137)
  0x01, 0x38, 0x40, 0x01, 0x04, 0x06, 0x04, 0x13, 0x59, // "ĸ" (U+0138)
  0x01, 0x39, 0x40, 0x01, 0x03, 0x0B, 0x04, 0x13, 0x68, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x40, 0x01, 0x03, 0x0B, 0x02, 0x13, 0x7E, // "ĺ" (U+013A)
  0x01, 0x3B, 0x40, 0xFF, 0x02, 0x08, 0x04, 0x13, 0x94, // "Ļ" (U+013B)
  0x01, 0x3C, 0xBF, 0xFF, 0x02, 0x08, 0x02, 0x13, 0xA3, // "ļ" (U+013C)
  0x01, 0x3D, 0x00, 0x01, 0x04, 0x08, 0x04, 0x13, 0xB7, // "Ľ" (U+013D)
  0x01, 0x3E, 0x40, 0x01, 0x03, 0x08, 0x03, 0x13, 0xC9, // "ľ" (U+013E)
  0x01, 0x3F, 0x40, 0x01, 0x03, 0x08, 0x04, 0x13, 0xD9, // "Ŀ" (U+013F)
  0x01, 0x40, 0x40, 0x01, 0x03, 0x08, 0x03, 0x13, 0xE9, // "ŀ" (U+0140)
  0x01, 0x41, 0x40, 0x01, 0x03, 0x08, 0x04, 0x13, 0xF9, // "Ł" (U+0141)
  0x01, 0x42, 0x40, 0x01, 0x02, 0x08, 0x02, 0x14, 0x09, // "ł" (U+0142)
  0x01, 0x43, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x14, 0x15, // "Ń" (U+0143)
  0x01, 0x44, 0x00, 0x01, 0x04, 0x09, 0x05, 0x14, 0x35, // "ń" (U+0144)
  0x01, 0x45, 0x40, 0xFF, 0x05, 0x08, 0x06, 0x14, 0x4B, // "Ņ" (U+0145)
  0x01, 0x46, 0x40, 0xFF, 0x04, 0x06, 0x05, 0x14, 0x69, // "ņ" (U+0146)
  0x01, 0x47, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x14, 0x7D, // "Ň" (U+0147)
  0x01, 0x48, 0x40, 0x01, 0x04, 0x09, 0x05, 0x14, 0x9E, // "ň" (U+0148)
  0x01, 0x49, 0x40, 0x01, 0x05, 0x08, 0x05, 0x14, 0xB5, // "ŉ" (U+0149)
  0x01, 0x4A, 0x40, 0xFF, 0x05, 0x08, 0x06, 0x14, 0xCD, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x40, 0xFE, 0x04, 0x06, 0x05, 0x14, 0xEB, // "ŋ" (U+014B)
  0x01, 0x4C, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x15, 0x02, // "Ō" (U+014C)
  0x01, 0x4D, 0x40, 0x01, 0x04, 0x08, 0x05, 0x15, 0x20, // "ō" (U+014D)
  0x01, 0x4E, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x15, 0x34, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x40, 0x01, 0x04, 0x09, 0x05, 0x15, 0x55, // "ŏ" (U+014F)
  0x01, 0x50, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x15, 0x6C, // "Ő" (U+0150)
  0x01, 0x51, 0x40, 0x01, 0x05, 0x09, 0x05, 0x15, 0x8D, // "ő" (U+0151)
  0x01, 0x52, 0x40, 0x01, 0x06, 0x08, 0x07, 0x15, 0xA8, // "Œ" (U+0152)
  0x01, 0x53, 0x40, 0x01, 0x06, 0x06, 0x07, 0x15, 0xC4, // "œ" (U+0153)
  0x01, 0x54, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x15, 0xD9, // "Ŕ" (U+0154)
  0x01, 0x55, 0x40, 0x01, 0x03, 0x09, 0x03, 0x15, 0xF4, // "ŕ" (U+0155)
  0x01, 0x56, 0x40, 0xFF, 0x04, 0x08, 0x05, 0x16, 0x06, // "Ŗ" (U+0156)
  0x01, 0x57, 0xBF, 0xFF, 0x03, 0x06, 0x03, 0x16, 0x1F, // "ŗ" (U+0157)
  0x01, 0x58, 0x40, 0x01, 0x04, 0x0B, 0x05, 0x16, 0x33, // "Ř" (U+0158)
  0x01, 0x59, 0x40, 0x01, 0x03, 0x09, 0x03, 0x16, 0x4F, // "ř" (U+0159)
  0x01, 0x5A, 0x00, 0x01, 0x04, 0x0B, 0x04, 0x16, 0x61, // "Ś" (U+015A)
  0x01, 0x5B, 0x40, 0x01, 0x03, 0x09, 0x04, 0x16, 0x7A, // "ś" (U+015B)
  0x01, 0x5C, 0x00, 0x01, 0x04, 0x0B, 0x04, 0x16, 0x8C, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x40, 0x01, 0x03, 0x09, 0x04, 0x16, 0xA6, // "ŝ" (U+015D)
  0x01, 0x5E, 0x00, 0xFE, 0x04, 0x08, 0x04, 0x16, 0xB8, // "Ş" (U+015E)
  0x01, 0x5F, 0x40, 0xFE, 0x03, 0x06, 0x04, 0x16, 0xD2, // "ş" (U+015F)
  0x01, 0x60, 0x00, 0x01, 0x04, 0x0B, 0x04, 0x16, 0xE4, // "Š" (U+0160)
  0x01, 0x61, 0x40, 0x01, 0x03, 0x09, 0x04, 0x16, 0xFE, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFE, 0x04, 0x08, 0x04, 0x17, 0x10, // "Ţ" (U+0162)
  0x01, 0x63, 0x40, 0xFE, 0x02, 0x08, 0x03, 0x17, 0x27, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x04, 0x0B, 0x04, 0x17, 0x38, // "Ť" (U+0164)
  0x01, 0x65, 0x40, 0x01, 0x03, 0x08, 0x03, 0x17, 0x50, // "ť" (U+0165)
  0x01, 0x66, 0x40, 0x01, 0x04, 0x08, 0x04, 0x17, 0x60, // "Ŧ" (U+0166)
  0x01, 0x67, 0x40, 0x01, 0x02, 0x08, 0x03, 0x17, 0x74, // "ŧ" (U+0167)
  0x01, 0x68, 0x40, 0x01, 0x05, 0x0B, 0x05, 0x17, 0x80, // "Ũ" (U+0168)
  0x01, 0x69, 0x00, 0x01, 0x04, 0x09, 0x05, 0x17, 0xA1, // "ũ" (U+0169)
  0x01, 0x6A, 0x40, 0x01, 0x05, 0x0A, 0x05, 0x17, 0xB7, // "Ū" (U+016A)
  0x01, 0x6B, 0x40, 0x01, 0x04, 0x08, 0x05, 0x17, 0xD5, // "ū" (U+016B)
  0x01, 0x6C, 0x40, 0x01, 0x05, 0x0B, 0x05, 0x17, 0xE9, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x40, 0x01, 0x04, 0x09, 0x05, 0x18, 0x0A, // "ŭ" (U+016D)
  0x01, 0x6E, 0x40, 0x01, 0x05, 0x0B, 0x05, 0x18, 0x21, // "Ů" (U+016E)
  0x01, 0x6F, 0x40, 0x01, 0x04, 0x09, 0x05, 0x18, 0x42, // "ů" (U+016F)
  0x01, 0x70, 0x40, 0x01, 0x05, 0x0B, 0x05, 0x18, 0x59, // "Ű" (U+0170)
  0x01, 0x71, 0x40, 0x01, 0x05, 0x09, 0x05, 0x18, 0x7A, // "ű" (U+0171)
  0x01, 0x72, 0x40, 0xFE, 0x05, 0x08, 0x05, 0x18, 0x95, // "Ų" (U+0172)
  0x01, 0x73, 0x40, 0xFE, 0x04, 0x06, 0x05, 0x18, 0xB6, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x07, 0x0B, 0x07, 0x18, 0xCD, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x06, 0x09, 0x06, 0x18, 0xF6, // "ŵ" (U+0175)
  0x01, 0x76, 0x41, 0x01, 0x04, 0x0B, 0x04, 0x19, 0x13, // "Ŷ" (U+0176)
  0x01, 0x77, 0xFF, 0xFE, 0x04, 0x09, 0x04, 0x19, 0x29, // "ŷ" (U+0177)
  0x01, 0x78, 0x41, 0x01, 0x04, 0x0A, 0x04, 0x19, 0x4B, // "Ÿ" (U+0178)
  0x01, 0x79, 0xFF, 0x01, 0x04, 0x0B, 0x04, 0x19, 0x5F, // "Ź" (U+0179)
  0x01, 0x7A, 0xFF, 0x01, 0x03, 0x09, 0x03, 0x19, 0x7C, // "ź" (U+017A)
  0x01, 0x7B, 0xFF, 0x01, 0x04, 0x0A, 0x04, 0x19, 0x92, // "Ż" (U+017B)
  0x01, 0x7C, 0xFF, 0x01, 0x03, 0x08, 0x03, 0x19, 0xAC, // "ż" (U+017C)
  0x01, 0x7D, 0xFF, 0x01, 0x04, 0x0B, 0x04, 0x19, 0xBF, // "Ž" (U+017D)
  0x01, 0x7E, 0xBF, 0x01, 0x03, 0x09, 0x03, 0x19, 0xDD, // "ž" (U+017E)
  0x01, 0x7F, 0xFE, 0xFE, 0x03, 0x08, 0x02, 0x19, 0xF4, // "ſ" (U+017F)
  0x03, 0xA9, 0xBF, 0x01, 0x05, 0x08, 0x06, 0x1A, 0x0D, // "Ω" (U+03A9)
  0x03, 0xBC, 0xBF, 0xFE, 0x04, 0x06, 0x05, 0x1A, 0x29, // "μ" (U+03BC)
  0x03, 0xC0, 0x40, 0x01, 0x04, 0x06, 0x05, 0x1A, 0x44, // "π" (U+03C0)
  0x20, 0x13, 0x40, 0x03, 0x04, 0x03, 0x05, 0x1A, 0x53, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x03, 0x08, 0x03, 0x09, 0x1A, 0x56, // "—" (U+2014)
  0x20, 0xAC, 0x40, 0x01, 0x04, 0x08, 0x04, 0x1A, 0x5A, // "€" (U+20AC)
  0x20, 0xBF, 0x40, 0x00, 0x04, 0x09, 0x04, 0x1A, 0x6E, // "₿" (U+20BF)
  0x20, 0x18, 0x40, 0x06, 0x02, 0x08, 0x02, 0x1A, 0x87, // "‘" (U+2018)
  0x20, 0x19, 0x40, 0x06, 0x02, 0x08, 0x02, 0x1A, 0x8C, // "’" (U+2019)
  0x20, 0x1A, 0xBF, 0x00, 0x01, 0x02, 0x02, 0x1A, 0x91, // "‚" (U+201A)
  0x20, 0x1B, 0x41, 0x06, 0x01, 0x08, 0x02, 0x1A, 0x96, // "‛" (U+201B)
  0x20, 0x1C, 0x40, 0x06, 0x03, 0x08, 0x03, 0x1A, 0x98, // "“" (U+201C)
  0x20, 0x1D, 0x40, 0x06, 0x03, 0x08, 0x03, 0x1A, 0x9E, // "”" (U+201D)
  0x20, 0x1E, 0xBF, 0x00, 0x02, 0x02, 0x04, 0x1A, 0xA4, // "„" (U+201E)
  0x20, 0x1F, 0x41, 0x06, 0x03, 0x08, 0x03, 0x1A, 0xAA, // "‟" (U+201F)
  0x20, 0x20, 0x41, 0x01, 0x04, 0x08, 0x04, 0x1A, 0xAF, // "†" (U+2020)
  0x20, 0x21, 0x40, 0x01, 0x04, 0x08, 0x04, 0x1A, 0xBF, // "‡" (U+2021)
  0x20, 0x22, 0x40, 0x04, 0x03, 0x06, 0x04, 0x1A, 0xD3, // "•" (U+2022)
  0x20, 0x26, 0x40, 0x01, 0x05, 0x01, 0x07, 0x1A, 0xD9, // "…" (U+2026)
  0x20, 0x30, 0x40, 0x01, 0x09, 0x08, 0x0A, 0x1A, 0xDC, // "‰" (U+2030)
  0x20, 0x39, 0x40, 0x01, 0x02, 0x05, 0x03, 0x1B, 0x04, // "‹" (U+2039)
  0x20, 0x3A, 0x40, 0x01, 0x02, 0x05, 0x03, 0x1B, 0x0C, // "›" (U+203A)
  0x20, 0x44, 0xFD, 0x01, 0x03, 0x08, 0x01, 0x1B, 0x14, // "⁄" (U+2044)
  0x21, 0x22, 0x40, 0x04, 0x06, 0x07, 0x07, 0x1B, 0x28, // "™" (U+2122)
  0x21, 0x52, 0x40, 0x01, 0x08, 0x08, 0x0A, 0x1B, 0x36, // "⅒" (U+2152)
  0xFB, 0x01, 0xFE, 0xFE, 0x05, 0x08, 0x05, 0x1B, 0x5A, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0xFE, 0xFE, 0x05, 0x08, 0x05, 0x1B, 0x7F, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x01, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0x63, 0x01, // "c (U+0022 U+0063)
  0x00, 0x22, 0x00, 0x64, 0x01, // "d (U+0022 U+0064)
  0x00, 0x22, 0x00, 0x65, 0x01, // "e (U+0022 U+0065)
  0x00, 0x22, 0x00, 0x6F, 0x01, // "o (U+0022 U+006F)
  0x00, 0x22, 0x00, 0x71, 0x01, // "q (U+0022 U+0071)
  0x00, 0x22, 0x00, 0xC0, 0x01, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x01, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x01, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x01, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x01, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x01, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xE0, 0x01, // "à (U+0022 U+00E0)
  0x00, 0x22, 0x00, 0xE7, 0x01, // "ç (U+0022 U+00E7)
  0x00, 0x22, 0x00, 0xE8, 0x01, // "è (U+0022 U+00E8)
  0x00, 0x22, 0x00, 0xE9, 0x01, // "é (U+0022 U+00E9)
  0x00, 0x22, 0x00, 0xEA, 0x01, // "ê (U+0022 U+00EA)
  0x00, 0x22, 0x00, 0xEB, 0x01, // "ë (U+0022 U+00EB)
  0x00, 0x22, 0x00, 0xF2, 0x01, // "ò (U+0022 U+00F2)
  0x00, 0x22, 0x00, 0xF3, 0x01, // "ó (U+0022 U+00F3)
  0x00, 0x22, 0x00, 0xF4, 0x01, // "ô (U+0022 U+00F4)
  0x00, 0x22, 0x00, 0xF5, 0x01, // "õ (U+0022 U+00F5)
  0x00, 0x22, 0x00, 0xF6, 0x01, // "ö (U+0022 U+00F6)
  0x00, 0x22, 0x00, 0xF8, 0x01, // "ø (U+0022 U+00F8)
  0x00, 0x22, 0x01, 0x00, 0x01, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x02, 0x01, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x04, 0x01, // "Ą (U+0022 U+0104)
  0x00, 0x22, 0x01, 0x07, 0x01, // "ć (U+0022 U+0107)
  0x00, 0x22, 0x01, 0x09, 0x01, // "ĉ (U+0022 U+0109)
  0x00, 0x22, 0x01, 0x0B, 0x01, // "ċ (U+0022 U+010B)
  0x00, 0x22, 0x01, 0x0D, 0x01, // "č (U+0022 U+010D)
  0x00, 0x22, 0x01, 0x0F, 0x01, // "ď (U+0022 U+010F)
  0x00, 0x22, 0x01, 0x11, 0x01, // "đ (U+0022 U+0111)
  0x00, 0x22, 0x01, 0x13, 0x01, // "ē (U+0022 U+0113)
  0x00, 0x22, 0x01, 0x15, 0x01, // "ĕ (U+0022 U+0115)
  0x00, 0x22, 0x01, 0x17, 0x01, // "ė (U+0022 U+0117)
  0x00, 0x22, 0x01, 0x19, 0x01, // "ę (U+0022 U+0119)
  0x00, 0x22, 0x01, 0x1B, 0x01, // "ě (U+0022 U+011B)
  0x00, 0x22, 0x01, 0x4D, 0x01, // "ō (U+0022 U+014D)
  0x00, 0x22, 0x01, 0x4F, 0x01, // "ŏ (U+0022 U+014F)
  0x00, 0x22, 0x01, 0x51, 0x01, // "ő (U+0022 U+0151)
  0x00, 0x22, 0x01, 0x53, 0x01, // "œ (U+0022 U+0153)
  0x00, 0x27, 0x00, 0x41, 0x01, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0x63, 0x01, // 'c (U+0027 U+0063)
  0x00, 0x27, 0x00, 0x64, 0x01, // 'd (U+0027 U+0064)
  0x00, 0x27, 0x00, 0x65, 0x01, // 'e (U+0027 U+0065)
  0x00, 0x27, 0x00, 0x6F, 0x01, // 'o (U+0027 U+006F)
  0x00, 0x27, 0x00, 0x71, 0x01, // 'q (U+0027 U+0071)
  0x00, 0x27, 0x00, 0xC0, 0x01, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x01, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x01, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x01, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x01, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x01, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xE0, 0x01, // 'à (U+0027 U+00E0)
  0x00, 0x27, 0x00, 0xE7, 0x01, // 'ç (U+0027 U+00E7)
  0x00, 0x27, 0x00, 0xE8, 0x01, // 'è (U+0027 U+00E8)
  0x00, 0x27, 0x00, 0xE9, 0x01, // 'é (U+0027 U+00E9)
  0x00, 0x27, 0x00, 0xEA, 0x01, // 'ê (U+0027 U+00EA)
  0x00, 0x27, 0x00, 0xEB, 0x01, // 'ë (U+0027 U+00EB)
  0x00, 0x27, 0x00, 0xF2, 0x01, // 'ò (U+0027 U+00F2)
  0x00, 0x27, 0x00, 0xF3, 0x01, // 'ó (U+0027 U+00F3)
  0x00, 0x27, 0x00, 0xF4, 0x01, // 'ô (U+0027 U+00F4)
  0x00, 0x27, 0x00, 0xF5, 0x01, // 'õ (U+0027 U+00F5)
  0x00, 0x27, 0x00, 0xF6, 0x01, // 'ö (U+0027 U+00F6)
  0x00, 0x27, 0x00, 0xF8, 0x01, // 'ø (U+0027 U+00F8)
  0x00, 0x27, 0x01, 0x00, 0x01, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x02, 0x01, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x04, 0x01, // 'Ą (U+0027 U+0104)
  0x00, 0x27, 0x01, 0x07, 0x01, // 'ć (U+0027 U+0107)
  0x00, 0x27, 0x01, 0x09, 0x01, // 'ĉ (U+0027 U+0109)
  0x00, 0x27, 0x01, 0x0B, 0x01, // 'ċ (U+0027 U+010B)
  0x00, 0x27, 0x01, 0x0D, 0x01, // 'č (U+0027 U+010D)
  0x00, 0x27, 0x01, 0x0F, 0x01, // 'ď (U+0027 U+010F)
  0x00, 0x27, 0x01, 0x11, 0x01, // 'đ (U+0027 U+0111)
  0x00, 0x27, 0x01, 0x13, 0x01, // 'ē (U+0027 U+0113)
  0x00, 0x27, 0x01, 0x15, 0x01, // 'ĕ (U+0027 U+0115)
  0x00, 0x27, 0x01, 0x17, 0x01, // 'ė (U+0027 U+0117)
  0x00, 0x27, 0x01, 0x19, 0x01, // 'ę (U+0027 U+0119)
  0x00, 0x27, 0x01, 0x1B, 0x01, // 'ě (U+0027 U+011B)
  0x00, 0x27, 0x01, 0x4D, 0x01, // 'ō (U+0027 U+014D)
  0x00, 0x27, 0x01, 0x4F, 0x01, // 'ŏ (U+0027 U+014F)
  0x00, 0x27, 0x01, 0x51, 0x01, // 'ő (U+0027 U+0151)
  0x00, 0x27, 0x01, 0x53, 0x01, // 'œ (U+0027 U+0153)
  0x00, 0x2C, 0x00, 0x54, 0x01, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x56, 0x01, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x01, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x01, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0xDD, 0x01, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x01, 0x62, 0x01, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x01, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x01, // ,Ŧ (U+002C U+0166)
  0x00, 0x2C, 0x01, 0x74, 0x01, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x76, 0x01, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x78, 0x01, // ,Ÿ (U+002C U+0178)
  0x00, 0x2E, 0x00, 0x54, 0x01, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x56, 0x01, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x01, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x01, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0xDD, 0x01, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x01, 0x62, 0x01, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x01, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x01, // .Ŧ (U+002E U+0166)
  0x00, 0x2E, 0x01, 0x74, 0x01, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x76, 0x01, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x78, 0x01, // .Ÿ (U+002E U+0178)
  0x00, 0x41, 0x00, 0x22, 0x01, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x01, // A' (U+0041 U+0027)
  0x00, 0x41, 0x20, 0x19, 0x01, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1D, 0x01, // A” (U+0041 U+201D)
  0x00, 0x46, 0x00, 0x2C, 0x01, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x01, // F. (U+0046 U+002E)
  0x00, 0x46, 0x20, 0x1A, 0x01, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x01, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x01, // F… (U+0046 U+2026)
  0x00, 0x4C, 0x00, 0x22, 0x01, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x01, // L' (U+004C U+0027)
  0x00, 0x4C, 0x20, 0x19, 0x01, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1D, 0x01, // L” (U+004C U+201D)
  0x00, 0x50, 0x00, 0x2C, 0x01, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x01, // P. (U+0050 U+002E)
  0x00, 0x50, 0x20, 0x1A, 0x01, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x01, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x01, // P… (U+0050 U+2026)
  0x00, 0x54, 0x00, 0x2C, 0x01, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2E, 0x01, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0x61, 0x01, // Ta (U+0054 U+0061)
  0x00, 0x54, 0x00, 0xE1, 0x01, // Tá (U+0054 U+00E1)
  0x00, 0x54, 0x00, 0xE2, 0x01, // Tâ (U+0054 U+00E2)
  0x00, 0x54, 0x00, 0xE3, 0x01, // Tã (U+0054 U+00E3)
  0x00, 0x54, 0x00, 0xE4, 0x01, // Tä (U+0054 U+00E4)
  0x00, 0x54, 0x00, 0xE5, 0x01, // Tå (U+0054 U+00E5)
  0x00, 0x54, 0x00, 0xE6, 0x01, // Tæ (U+0054 U+00E6)
  0x00, 0x54, 0x01, 0x01, 0x01, // Tā (U+0054 U+0101)
  0x00, 0x54, 0x01, 0x03, 0x01, // Tă (U+0054 U+0103)
  0x00, 0x54, 0x01, 0x05, 0x01, // Tą (U+0054 U+0105)
  0x00, 0x54, 0x20, 0x1A, 0x01, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x01, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x01, // T… (U+0054 U+2026)
  0x00, 0x56, 0x00, 0x2C, 0x01, // V, (U+0056 U+002C)
  0x00, 0x56, 0x00, 0x2E, 0x01, // V. (U+0056 U+002E)
  0x00, 0x56, 0x20, 0x1A, 0x01, // V‚ (U+0056 U+201A)
  0x00, 0x56, 0x20, 0x1E, 0x01, // V„ (U+0056 U+201E)
  0x00, 0x56, 0x20, 0x26, 0x01, // V… (U+0056 U+2026)
  0x00, 0x57, 0x00, 0x2C, 0x01, // W, (U+0057 U+002C)
  0x00, 0x57, 0x00, 0x2E, 0x01, // W. (U+0057 U+002E)
  0x00, 0x57, 0x20, 0x1A, 0x01, // W‚ (U+0057 U+201A)
  0x00, 0x57, 0x20, 0x1E, 0x01, // W„ (U+0057 U+201E)
  0x00, 0x57, 0x20, 0x26, 0x01, // W… (U+0057 U+2026)
  0x00, 0x59, 0x00, 0x2C, 0x01, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x01, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x20, 0x1A, 0x01, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x01, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x01, // Y… (U+0059 U+2026)
  0x00, 0x72, 0x00, 0x2C, 0x01, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x01, // r. (U+0072 U+002E)
  0x00, 0x72, 0x20, 0x1A, 0x01, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x01, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x01, // r… (U+0072 U+2026)
  0x00, 0xC0, 0x00, 0x22, 0x01, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x01, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x20, 0x19, 0x01, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1D, 0x01, // À” (U+00C0 U+201D)
  0x00, 0xC1, 0x00, 0x22, 0x01, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x01, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x20, 0x19, 0x01, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1D, 0x01, // Á” (U+00C1 U+201D)
  0x00, 0xC2, 0x00, 0x22, 0x01, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x01, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x20, 0x19, 0x01, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1D, 0x01, // Â” (U+00C2 U+201D)
  0x00, 0xC3, 0x00, 0x22, 0x01, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x01, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x20, 0x19, 0x01, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1D, 0x01, // Ã” (U+00C3 U+201D)
  0x00, 0xC4, 0x00, 0x22, 0x01, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x01, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x20, 0x19, 0x01, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1D, 0x01, // Ä” (U+00C4 U+201D)
  0x00, 0xC5, 0x00, 0x22, 0x01, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x01, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x20, 0x19, 0x01, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1D, 0x01, // Å” (U+00C5 U+201D)
  0x00, 0xDD, 0x00, 0x2C, 0x01, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x01, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x20, 0x1A, 0x01, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x01, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x01, // Ý… (U+00DD U+2026)
  0x00, 0xDE, 0x00, 0x2C, 0x01, // Þ, (U+00DE U+002C)
  0x00, 0xDE, 0x00, 0x2E, 0x01, // Þ. (U+00DE U+002E)
  0x00, 0xDE, 0x20, 0x1A, 0x01, // Þ‚ (U+00DE U+201A)
  0x00, 0xDE, 0x20, 0x1E, 0x01, // Þ„ (U+00DE U+201E)
  0x00, 0xDE, 0x20, 0x26, 0x01, // Þ… (U+00DE U+2026)
  0x01, 0x00, 0x00, 0x22, 0x01, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x01, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x20, 0x19, 0x01, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1D, 0x01, // Ā” (U+0100 U+201D)
  0x01, 0x02, 0x00, 0x22, 0x01, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x01, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x20, 0x19, 0x01, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1D, 0x01, // Ă” (U+0102 U+201D)
  0x01, 0x04, 0x00, 0x22, 0x01, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x01, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x20, 0x19, 0x01, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1D, 0x01, // Ą” (U+0104 U+201D)
  0x01, 0x39, 0x00, 0x22, 0x01, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x01, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x20, 0x19, 0x01, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1D, 0x01, // Ĺ” (U+0139 U+201D)
  0x01, 0x3B, 0x00, 0x22, 0x01, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x01, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x20, 0x19, 0x01, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1D, 0x01, // Ļ” (U+013B U+201D)
  0x01, 0x3D, 0x00, 0x22, 0x01, // Ľ" (U+013D U+0022)
  0x01, 0x3D, 0x00, 0x27, 0x01, // Ľ' (U+013D U+0027)
  0x01, 0x3D, 0x20, 0x19, 0x01, // Ľ’ (U+013D U+2019)
  0x01, 0x3D, 0x20, 0x1D, 0x01, // Ľ” (U+013D U+201D)
  0x01, 0x3F, 0x00, 0x22, 0x01, // Ŀ" (U+013F U+0022)
  0x01, 0x3F, 0x00, 0x27, 0x01, // Ŀ' (U+013F U+0027)
  0x01, 0x3F, 0x20, 0x19, 0x01, // Ŀ’ (U+013F U+2019)
  0x01, 0x3F, 0x20, 0x1D, 0x01, // Ŀ” (U+013F U+201D)
  0x01, 0x41, 0x00, 0x22, 0x01, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x01, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x20, 0x19, 0x01, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1D, 0x01, // Ł” (U+0141 U+201D)
  0x01, 0x55, 0x00, 0x2C, 0x01, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x01, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x20, 0x1A, 0x01, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x01, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x01, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x01, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x01, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x20, 0x1A, 0x01, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x01, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x01, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x01, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x01, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x20, 0x1A, 0x01, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x01, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x01, // ř… (U+0159 U+2026)
  0x01, 0x62, 0x00, 0x2C, 0x01, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2E, 0x01, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0x61, 0x01, // Ţa (U+0162 U+0061)
  0x01, 0x62, 0x00, 0xE1, 0x01, // Ţá (U+0162 U+00E1)
  0x01, 0x62, 0x00, 0xE2, 0x01, // Ţâ (U+0162 U+00E2)
  0x01, 0x62, 0x00, 0xE3, 0x01, // Ţã (U+0162 U+00E3)
  0x01, 0x62, 0x00, 0xE4, 0x01, // Ţä (U+0162 U+00E4)
  0x01, 0x62, 0x00, 0xE5, 0x01, // Ţå (U+0162 U+00E5)
  0x01, 0x62, 0x00, 0xE6, 0x01, // Ţæ (U+0162 U+00E6)
  0x01, 0x62, 0x01, 0x01, 0x01, // Ţā (U+0162 U+0101)
  0x01, 0x62, 0x01, 0x03, 0x01, // Ţă (U+0162 U+0103)
  0x01, 0x62, 0x01, 0x05, 0x01, // Ţą (U+0162 U+0105)
  0x01, 0x62, 0x20, 0x1A, 0x01, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x01, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x01, // Ţ… (U+0162 U+2026)
  0x01, 0x64, 0x00, 0x2C, 0x01, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2E, 0x01, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0x61, 0x01, // Ťa (U+0164 U+0061)
  0x01, 0x64, 0x00, 0xE1, 0x01, // Ťá (U+0164 U+00E1)
  0x01, 0x64, 0x00, 0xE2, 0x01, // Ťâ (U+0164 U+00E2)
  0x01, 0x64, 0x00, 0xE3, 0x01, // Ťã (U+0164 U+00E3)
  0x01, 0x64, 0x00, 0xE4, 0x01, // Ťä (U+0164 U+00E4)
  0x01, 0x64, 0x00, 0xE5, 0x01, // Ťå (U+0164 U+00E5)
  0x01, 0x64, 0x00, 0xE6, 0x01, // Ťæ (U+0164 U+00E6)
  0x01, 0x64, 0x01, 0x01, 0x01, // Ťā (U+0164 U+0101)
  0x01, 0x64, 0x01, 0x03, 0x01, // Ťă (U+0164 U+0103)
  0x01, 0x64, 0x01, 0x05, 0x01, // Ťą (U+0164 U+0105)
  0x01, 0x64, 0x20, 0x1A, 0x01, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x01, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x01, // Ť… (U+0164 U+2026)
  0x01, 0x66, 0x00, 0x2C, 0x01, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2E, 0x01, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0x61, 0x01, // Ŧa (U+0166 U+0061)
  0x01, 0x66, 0x00, 0xE1, 0x01, // Ŧá (U+0166 U+00E1)
  0x01, 0x66, 0x00, 0xE2, 0x01, // Ŧâ (U+0166 U+00E2)
  0x01, 0x66, 0x00, 0xE3, 0x01, // Ŧã (U+0166 U+00E3)
  0x01, 0x66, 0x00, 0xE4, 0x01, // Ŧä (U+0166 U+00E4)
  0x01, 0x66, 0x00, 0xE5, 0x01, // Ŧå (U+0166 U+00E5)
  0x01, 0x66, 0x00, 0xE6, 0x01, // Ŧæ (U+0166 U+00E6)
  0x01, 0x66, 0x01, 0x01, 0x01, // Ŧā (U+0166 U+0101)
  0x01, 0x66, 0x01, 0x03, 0x01, // Ŧă (U+0166 U+0103)
  0x01, 0x66, 0x01, 0x05, 0x01, // Ŧą (U+0166 U+0105)
  0x01, 0x66, 0x20, 0x1A, 0x01, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x01, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x01, // Ŧ… (U+0166 U+2026)
  0x01, 0x74, 0x00, 0x2C, 0x01, // Ŵ, (U+0174 U+002C)
  0x01, 0x74, 0x00, 0x2E, 0x01, // Ŵ. (U+0174 U+002E)
  0x01, 0x74, 0x20, 0x1A, 0x01, // Ŵ‚ (U+0174 U+201A)
  0x01, 0x74, 0x20, 0x1E, 0x01, // Ŵ„ (U+0174 U+201E)
  0x01, 0x74, 0x20, 0x26, 0x01, // Ŵ… (U+0174 U+2026)
  0x01, 0x76, 0x00, 0x2C, 0x01, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x01, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x20, 0x1A, 0x01, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x01, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x01, // Ŷ… (U+0176 U+2026)
  0x01, 0x78, 0x00, 0x2C, 0x01, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x01, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x20, 0x1A, 0x01, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x01, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x01, // Ÿ… (U+0178 U+2026)
  0x20, 0x18, 0x00, 0x41, 0x01, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0x63, 0x01, // ‘c (U+2018 U+0063)
  0x20, 0x18, 0x00, 0x64, 0x01, // ‘d (U+2018 U+0064)
  0x20, 0x18, 0x00, 0x65, 0x01, // ‘e (U+2018 U+0065)
  0x20, 0x18, 0x00, 0x6F, 0x01, // ‘o (U+2018 U+006F)
  0x20, 0x18, 0x00, 0x71, 0x01, // ‘q (U+2018 U+0071)
  0x20, 0x18, 0x00, 0xC0, 0x01, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x01, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x01, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x01, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x01, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x01, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xE0, 0x01, // ‘à (U+2018 U+00E0)
  0x20, 0x18, 0x00, 0xE7, 0x01, // ‘ç (U+2018 U+00E7)
  0x20, 0x18, 0x00, 0xE8, 0x01, // ‘è (U+2018 U+00E8)
  0x20, 0x18, 0x00, 0xE9, 0x01, // ‘é (U+2018 U+00E9)
  0x20, 0x18, 0x00, 0xEA, 0x01, // ‘ê (U+2018 U+00EA)
  0x20, 0x18, 0x00, 0xEB, 0x01, // ‘ë (U+2018 U+00EB)
  0x20, 0x18, 0x00, 0xF2, 0x01, // ‘ò (U+2018 U+00F2)
  0x20, 0x18, 0x00, 0xF3, 0x01, // ‘ó (U+2018 U+00F3)
  0x20, 0x18, 0x00, 0xF4, 0x01, // ‘ô (U+2018 U+00F4)
  0x20, 0x18, 0x00, 0xF5, 0x01, // ‘õ (U+2018 U+00F5)
  0x20, 0x18, 0x00, 0xF6, 0x01, // ‘ö (U+2018 U+00F6)
  0x20, 0x18, 0x00, 0xF8, 0x01, // ‘ø (U+2018 U+00F8)
  0x20, 0x18, 0x01, 0x00, 0x01, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x02, 0x01, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x04, 0x01, // ‘Ą (U+2018 U+0104)
  0x20, 0x18, 0x01, 0x07, 0x01, // ‘ć (U+2018 U+0107)
  0x20, 0x18, 0x01, 0x09, 0x01, // ‘ĉ (U+2018 U+0109)
  0x20, 0x18, 0x01, 0x0B, 0x01, // ‘ċ (U+2018 U+010B)
  0x20, 0x18, 0x01, 0x0D, 0x01, // ‘č (U+2018 U+010D)
  0x20, 0x18, 0x01, 0x0F, 0x01, // ‘ď (U+2018 U+010F)
  0x20, 0x18, 0x01, 0x11, 0x01, // ‘đ (U+2018 U+0111)
  0x20, 0x18, 0x01, 0x13, 0x01, // ‘ē (U+2018 U+0113)
  0x20, 0x18, 0x01, 0x15, 0x01, // ‘ĕ (U+2018 U+0115)
  0x20, 0x18, 0x01, 0x17, 0x01, // ‘ė (U+2018 U+0117)
  0x20, 0x18, 0x01, 0x19, 0x01, // ‘ę (U+2018 U+0119)
  0x20, 0x18, 0x01, 0x1B, 0x01, // ‘ě (U+2018 U+011B)
  0x20, 0x18, 0x01, 0x4D, 0x01, // ‘ō (U+2018 U+014D)
  0x20, 0x18, 0x01, 0x4F, 0x01, // ‘ŏ (U+2018 U+014F)
  0x20, 0x18, 0x01, 0x51, 0x01, // ‘ő (U+2018 U+0151)
  0x20, 0x18, 0x01, 0x53, 0x01, // ‘œ (U+2018 U+0153)
  0x20, 0x19, 0x00, 0x41, 0x01, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0x63, 0x01, // ’c (U+2019 U+0063)
  0x20, 0x19, 0x00, 0x64, 0x01, // ’d (U+2019 U+0064)
  0x20, 0x19, 0x00, 0x65, 0x01, // ’e (U+2019 U+0065)
  0x20, 0x19, 0x00, 0x6F, 0x01, // ’o (U+2019 U+006F)
  0x20, 0x19, 0x00, 0x71, 0x01, // ’q (U+2019 U+0071)
  0x20, 0x19, 0x00, 0xC0, 0x01, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x01, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x01, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x01, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x01, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x01, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xE0, 0x01, // ’à (U+2019 U+00E0)
  0x20, 0x19, 0x00, 0xE7, 0x01, // ’ç (U+2019 U+00E7)
  0x20, 0x19, 0x00, 0xE8, 0x01, // ’è (U+2019 U+00E8)
  0x20, 0x19, 0x00, 0xE9, 0x01, // ’é (U+2019 U+00E9)
  0x20, 0x19, 0x00, 0xEA, 0x01, // ’ê (U+2019 U+00EA)
  0x20, 0x19, 0x00, 0xEB, 0x01, // ’ë (U+2019 U+00EB)
  0x20, 0x19, 0x00, 0xF2, 0x01, // ’ò (U+2019 U+00F2)
  0x20, 0x19, 0x00, 0xF3, 0x01, // ’ó (U+2019 U+00F3)
  0x20, 0x19, 0x00, 0xF4, 0x01, // ’ô (U+2019 U+00F4)
  0x20, 0x19, 0x00, 0xF5, 0x01, // ’õ (U+2019 U+00F5)
  0x20, 0x19, 0x00, 0xF6, 0x01, // ’ö (U+2019 U+00F6)
  0x20, 0x19, 0x00, 0xF8, 0x01, // ’ø (U+2019 U+00F8)
  0x20, 0x19, 0x01, 0x00, 0x01, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x02, 0x01, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x04, 0x01, // ’Ą (U+2019 U+0104)
  0x20, 0x19, 0x01, 0x07, 0x01, // ’ć (U+2019 U+0107)
  0x20, 0x19, 0x01, 0x09, 0x01, // ’ĉ (U+2019 U+0109)
  0x20, 0x19, 0x01, 0x0B, 0x01, // ’ċ (U+2019 U+010B)
  0x20, 0x19, 0x01, 0x0D, 0x01, // ’č (U+2019 U+010D)
  0x20, 0x19, 0x01, 0x0F, 0x01, // ’ď (U+2019 U+010F)
  0x20, 0x19, 0x01, 0x11, 0x01, // ’đ (U+2019 U+0111)
  0x20, 0x19, 0x01, 0x13, 0x01, // ’ē (U+2019 U+0113)
  0x20, 0x19, 0x01, 0x15, 0x01, // ’ĕ (U+2019 U+0115)
  0x20, 0x19, 0x01, 0x17, 0x01, // ’ė (U+2019 U+0117)
  0x20, 0x19, 0x01, 0x19, 0x01, // ’ę (U+2019 U+0119)
  0x20, 0x19, 0x01, 0x1B, 0x01, // ’ě (U+2019 U+011B)
  0x20, 0x19, 0x01, 0x4D, 0x01, // ’ō (U+2019 U+014D)
  0x20, 0x19, 0x01, 0x4F, 0x01, // ’ŏ (U+2019 U+014F)
  0x20, 0x19, 0x01, 0x51, 0x01, // ’ő (U+2019 U+0151)
  0x20, 0x19, 0x01, 0x53, 0x01, // ’œ (U+2019 U+0153)
  0x20, 0x1A, 0x00, 0x54, 0x01, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x56, 0x01, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x01, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x01, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0xDD, 0x01, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x01, 0x62, 0x01, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x01, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x01, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1A, 0x01, 0x74, 0x01, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x76, 0x01, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x78, 0x01, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x01, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0x63, 0x01, // “c (U+201C U+0063)
  0x20, 0x1C, 0x00, 0x64, 0x01, // “d (U+201C U+0064)
  0x20, 0x1C, 0x00, 0x65, 0x01, // “e (U+201C U+0065)
  0x20, 0x1C, 0x00, 0x6F, 0x01, // “o (U+201C U+006F)
  0x20, 0x1C, 0x00, 0x71, 0x01, // “q (U+201C U+0071)
  0x20, 0x1C, 0x00, 0xC0, 0x01, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x01, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x01, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x01, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x01, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x01, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xE0, 0x01, // “à (U+201C U+00E0)
  0x20, 0x1C, 0x00, 0xE7, 0x01, // “ç (U+201C U+00E7)
  0x20, 0x1C, 0x00, 0xE8, 0x01, // “è (U+201C U+00E8)
  0x20, 0x1C, 0x00, 0xE9, 0x01, // “é (U+201C U+00E9)
  0x20, 0x1C, 0x00, 0xEA, 0x01, // “ê (U+201C U+00EA)
  0x20, 0x1C, 0x00, 0xEB, 0x01, // “ë (U+201C U+00EB)
  0x20, 0x1C, 0x00, 0xF2, 0x01, // “ò (U+201C U+00F2)
  0x20, 0x1C, 0x00, 0xF3, 0x01, // “ó (U+201C U+00F3)
  0x20, 0x1C, 0x00, 0xF4, 0x01, // “ô (U+201C U+00F4)
  0x20, 0x1C, 0x00, 0xF5, 0x01, // “õ (U+201C U+00F5)
  0x20, 0x1C, 0x00, 0xF6, 0x01, // “ö (U+201C U+00F6)
  0x20, 0x1C, 0x00, 0xF8, 0x01, // “ø (U+201C U+00F8)
  0x20, 0x1C, 0x01, 0x00, 0x01, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x02, 0x01, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x04, 0x01, // “Ą (U+201C U+0104)
  0x20, 0x1C, 0x01, 0x07, 0x01, // “ć (U+201C U+0107)
  0x20, 0x1C, 0x01, 0x09, 0x01, // “ĉ (U+201C U+0109)
  0x20, 0x1C, 0x01, 0x0B, 0x01, // “ċ (U+201C U+010B)
  0x20, 0x1C, 0x01, 0x0D, 0x01, // “č (U+201C U+010D)
  0x20, 0x1C, 0x01, 0x0F, 0x01, // “ď (U+201C U+010F)
  0x20, 0x1C, 0x01, 0x11, 0x01, // “đ (U+201C U+0111)
  0x20, 0x1C, 0x01, 0x13, 0x01, // “ē (U+201C U+0113)
  0x20, 0x1C, 0x01, 0x15, 0x01, // “ĕ (U+201C U+0115)
  0x20, 0x1C, 0x01, 0x17, 0x01, // “ė (U+201C U+0117)
  0x20, 0x1C, 0x01, 0x19, 0x01, // “ę (U+201C U+0119)
  0x20, 0x1C, 0x01, 0x1B, 0x01, // “ě (U+201C U+011B)
  0x20, 0x1C, 0x01, 0x4D, 0x01, // “ō (U+201C U+014D)
  0x20, 0x1C, 0x01, 0x4F, 0x01, // “ŏ (U+201C U+014F)
  0x20, 0x1C, 0x01, 0x51, 0x01, // “ő (U+201C U+0151)
  0x20, 0x1C, 0x01, 0x53, 0x01, // “œ (U+201C U+0153)
  0x20, 0x1D, 0x00, 0x41, 0x01, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0x63, 0x01, // ”c (U+201D U+0063)
  0x20, 0x1D, 0x00, 0x64, 0x01, // ”d (U+201D U+0064)
  0x20, 0x1D, 0x00, 0x65, 0x01, // ”e (U+201D U+0065)
  0x20, 0x1D, 0x00, 0x6F, 0x01, // ”o (U+201D U+006F)
  0x20, 0x1D, 0x00, 0x71, 0x01, // ”q (U+201D U+0071)
  0x20, 0x1D, 0x00, 0xC0, 0x01, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x01, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x01, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x01, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x01, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x01, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xE0, 0x01, // ”à (U+201D U+00E0)
  0x20, 0x1D, 0x00, 0xE7, 0x01, // ”ç (U+201D U+00E7)
  0x20, 0x1D, 0x00, 0xE8, 0x01, // ”è (U+201D U+00E8)
  0x20, 0x1D, 0x00, 0xE9, 0x01, // ”é (U+201D U+00E9)
  0x20, 0x1D, 0x00, 0xEA, 0x01, // ”ê (U+201D U+00EA)
  0x20, 0x1D, 0x00, 0xEB, 0x01, // ”ë (U+201D U+00EB)
  0x20, 0x1D, 0x00, 0xF2, 0x01, // ”ò (U+201D U+00F2)
  0x20, 0x1D, 0x00, 0xF3, 0x01, // ”ó (U+201D U+00F3)
  0x20, 0x1D, 0x00, 0xF4, 0x01, // ”ô (U+201D U+00F4)
  0x20, 0x1D, 0x00, 0xF5, 0x01, // ”õ (U+201D U+00F5)
  0x20, 0x1D, 0x00, 0xF6, 0x01, // ”ö (U+201D U+00F6)
  0x20, 0x1D, 0x00, 0xF8, 0x01, // ”ø (U+201D U+00F8)
  0x20, 0x1D, 0x01, 0x00, 0x01, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x02, 0x01, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x04, 0x01, // ”Ą (U+201D U+0104)
  0x20, 0x1D, 0x01, 0x07, 0x01, // ”ć (U+201D U+0107)
  0x20, 0x1D, 0x01, 0x09, 0x01, // ”ĉ (U+201D U+0109)
  0x20, 0x1D, 0x01, 0x0B, 0x01, // ”ċ (U+201D U+010B)
  0x20, 0x1D, 0x01, 0x0D, 0x01, // ”č (U+201D U+010D)
  0x20, 0x1D, 0x01, 0x0F, 0x01, // ”ď (U+201D U+010F)
  0x20, 0x1D, 0x01, 0x11, 0x01, // ”đ (U+201D U+0111)
  0x20, 0x1D, 0x01, 0x13, 0x01, // ”ē (U+201D U+0113)
  0x20, 0x1D, 0x01, 0x15, 0x01, // ”ĕ (U+201D U+0115)
  0x20, 0x1D, 0x01, 0x17, 0x01, // ”ė (U+201D U+0117)
  0x20, 0x1D, 0x01, 0x19, 0x01, // ”ę (U+201D U+0119)
  0x20, 0x1D, 0x01, 0x1B, 0x01, // ”ě (U+201D U+011B)
  0x20, 0x1D, 0x01, 0x4D, 0x01, // ”ō (U+201D U+014D)
  0x20, 0x1D, 0x01, 0x4F, 0x01, // ”ŏ (U+201D U+014F)
  0x20, 0x1D, 0x01, 0x51, 0x01, // ”ő (U+201D U+0151)
  0x20, 0x1D, 0x01, 0x53, 0x01, // ”œ (U+201D U+0153)
  0x20, 0x1E, 0x00, 0x54, 0x01, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x56, 0x01, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x01, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x01, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0xDD, 0x01, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x01, 0x62, 0x01, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x01, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x01, // „Ŧ (U+201E U+0166)
  0x20, 0x1E, 0x01, 0x74, 0x01, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x76, 0x01, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x78, 0x01, // „Ÿ (U+201E U+0178)
  
  // Glyph data
  // "!" (U+0021)
  0x07, 0x70, 0x94, 0x0B, 0x10, 0xC0, 0x1A, 0x03, 0x70, 0x11, 0x07, 0x10,
  // """ (U+0022)
  0xA4, 0xBB, 0x37, 0x84, 0x30,
  // "#" (U+0023)
  0x00, 0x90, 0x90, 0x09, 0x35, 0x2C, 0xDD, 0xC0, 0x72, 0x90, 0x09, 0x09, 0x0A, 0xEC, 0xD4, 0x36,
  0x81, 0x08, 0x19, 0x00,
  // "$" (U+0024)
  0x00, 0x24, 0x00, 0x6F, 0xD3, 0x0C, 0x80, 0x00, 0xC8, 0x00, 0x04, 0xD2, 0x00, 0x18, 0xA0, 0x14,
  0x79, 0x09, 0xDA, 0x10, 0x07, 0x00, 0x00,
  // "%" (U+0025)
  0x07, 0xC1, 0x18, 0x01, 0x96, 0x38, 0x10, 0x55, 0x83, 0x80, 0x06, 0x4A, 0x96, 0xB1, 0x2B, 0x68,
  0xA6, 0x40, 0x09, 0x46, 0x72, 0x03, 0x75, 0x4A, 0x00, 0xA0, 0x2C, 0x50,
  // "&" (U+0026)
  0x01, 0xCC, 0x00, 0x83, 0xB1, 0x08, 0x79, 0x00, 0x8C, 0x00, 0x58, 0xC2, 0xAC, 0x07, 0xD3, 0xD0,
  0x5D, 0x08, 0xC9, 0xB2,
  // "'" (U+0027)
  0x93, 0xB0, 0x80,
  // "(" (U+0028)
  0x00, 0x91, 0x05, 0x60, 0x0B, 0x00, 0x38, 0x00, 0x84, 0x00, 0xA1, 0x00, 0xB0, 0x00, 0xA1, 0x00,
  0x73, 0x00, 0x13, 0x00,
  // ")" (U+0029)
  0x00, 0xA0, 0x00, 0x83, 0x00, 0x74, 0x00, 0x74, 0x00, 0x93, 0x00, 0xB0, 0x01, 0xA0, 0x08, 0x30,
  0x29, 0x00, 0x41, 0x00,
  // "*" (U+002A)
  0x01, 0x10, 0x26, 0x40, 0x8D, 0xA5, 0x5A, 0x50, 0x40, 0x70,
  // "+" (U+002B)
  0x20, 0xA4, 0x0A, 0x28, 0x36, 0xBE, 0xB5, 0x20, 0xA4, 0x0A, 0x20,
  // "," (U+002C)
  0x04, 0x20, 0xC0, 0x37, 0x00,
  // "-" (U+002D)
  0x8B, 0x50,
  // "." (U+002E)
  0x71,
  // "/" (U+002F)
  0x40, 0xB3, 0x05, 0x07, 0x30, 0xB3, 0x04, 0x07, 0x30, 0xB3, 0x04, 0x07, 0x30, 0xB0, 0x12, 0x03,
  0x08, 0x30,
  // "0" (U+0030)
  0x02, 0xBB, 0x00, 0xB2, 0x84, 0x1B, 0x07, 0x45, 0x60, 0x93, 0x83, 0x0C, 0x0A, 0x21, 0xB0, 0x92,
  0x76, 0x04, 0xC9, 0x00,
  // "1" (U+0031)
  0x07, 0xB8, 0xB8, 0x17, 0x50, 0xA2, 0x0C, 0x00, 0xB0, 0x39, 0x06, 0x60,
  // "2" (U+0032)
  0x00, 0x7B, 0xB0, 0x00, 0x20, 0x94, 0x00, 0x00, 0xA2, 0x00, 0x02, 0xB0, 0x00, 0x0B, 0x20, 0x00,
  0x95, 0x00, 0x07, 0x80, 0x00, 0x1F, 0xBB, 0x40,
  // "3" (U+0033)
  0x07, 0xBC, 0x10, 0x00, 0x94, 0x00, 0x1B, 0x10, 0x7E, 0x30, 0x00, 0x58, 0x00, 0x02, 0xA0, 0x00,
  0x76, 0x0C, 0xCA, 0x00,
  // "4" (U+0034)
  0x00, 0x0D, 0x30, 0x08, 0xD0, 0x03, 0x8B, 0x00, 0xA2, 0xA0, 0x73, 0x57, 0x0D, 0xCD, 0xC0, 0x00,
  0xB1, 0x00, 0x0C, 0x00,
  // "5" (U+0035)
  0x18, 0x56, 0xCB, 0x30, 0xA1, 0x30, 0xB3, 0x82, 0x2D, 0xC4, 0x30, 0x20, 0xB4, 0x0C, 0x38, 0x46,
  0x80, 0xBB, 0x92,
  // "6" (U+0036)
  0x00, 0x8C, 0x50, 0x76, 0x00, 0x0C, 0x00, 0x04, 0xBA, 0x70, 0x78, 0x0D, 0x09, 0x30, 0xC0, 0x83,
  0x39, 0x03, 0xCB, 0x10,
  // "7" (U+0037)
  0x18, 0x2B, 0xBC, 0x93, 0x09, 0x03, 0x20, 0x10, 0xB3, 0x07, 0x05, 0x30, 0xC3, 0x00, 0x63, 0x0C,
  0x30, 0x50, 0x83,
  // "8" (U+0038)
  0x04, 0xCC, 0x10, 0xB0, 0x66, 0x0C, 0x1B, 0x30, 0x7F, 0x50, 0x3B, 0x96, 0x0B, 0x11, 0xB0, 0xC0,
  0x2A, 0x06, 0xCC, 0x20,
  // "9" (U+0039)
  0x05, 0xCB, 0x00, 0xC0, 0x93, 0x48, 0x09, 0x34, 0x81, 0xD2, 0x0B, 0x9D, 0x00, 0x02, 0x90, 0x00,
  0xA3, 0x0A, 0xC6, 0x00,
  // ":" (U+003A)
  0x10, 0x87, 0x10, 0x81,
  // ";" (U+003B)
  0x20, 0xC7, 0x38, 0x75, 0x20, 0xC0, 0x37, 0x01, 0x20,
  // "<" (U+003C)
  0x00, 0x05, 0x50, 0x4A, 0x60, 0x5C, 0x10, 0x00, 0x3A, 0x81, 0x00, 0x03, 0x40,
  // "=" (U+003D)
  0x5B, 0xBB, 0x50, 0x00, 0x00, 0x5B, 0xBB, 0x50,
  // ">" (U+003E)
  0x00, 0x54, 0x81, 0x6A, 0x43, 0x89, 0x01, 0xD5, 0x18, 0xA3, 0x04, 0x33,
  // "?" (U+003F)
  0x0B, 0xD4, 0x00, 0x3A, 0x00, 0x57, 0x01, 0xB1, 0x09, 0x30, 0x0A, 0x00, 0x01, 0x00, 0x53, 0x00,
  // "@" (U+0040)
  0x00, 0x5B, 0xB8, 0x00, 0x48, 0x00, 0x73, 0x0A, 0x1B, 0xC2, 0x64, 0x69, 0x19, 0x26, 0x82, 0x91,
  0x85, 0x39, 0x19, 0x75, 0x90, 0x91, 0xB6, 0xB4, 0x05, 0x70, 0x00, 0x00, 0x07, 0xBA, 0x10, 0x00,
  // "A" (U+0041)
  0x00, 0x09, 0x90, 0x00, 0xCA, 0x00, 0x67, 0xB0, 0x0C, 0x2B, 0x03, 0xC0, 0xC0, 0x9D, 0xCC, 0x0D,
  0x00, 0xD6, 0x80, 0x0D,
  // "B" (U+0042)
  0x07, 0xCC, 0x60, 0xA2, 0x2C, 0x0C, 0x05, 0x80, 0xEC, 0xC0, 0x38, 0x0B, 0x26, 0x60, 0x94, 0x93,
  0x0C, 0x1C, 0xCC, 0x50,
  // "C" (U+0043)
  0x00, 0x8C, 0xB0, 0x78, 0x00, 0x0D, 0x00, 0x04, 0x90, 0x00, 0x76, 0x00, 0x07, 0x50, 0x00, 0x58,
  0x00, 0x00, 0xBB, 0x70,
  // "D" (U+0044)
  0x07, 0xCC, 0x40, 0xA2, 0x1D, 0x0C, 0x00, 0xD0, 0xC0, 0x0D, 0x39, 0x01, 0xC6, 0x60, 0x68, 0x93,
  0x1D, 0x1C, 0xCB, 0x20,
  // "E" (U+0045)
  0x07, 0xCB, 0x50, 0xA2, 0x00, 0x0C, 0x00, 0x00, 0xEB, 0x70, 0x38, 0x00, 0x06, 0x50, 0x00, 0x93,
  0x00, 0x0C, 0xCB, 0x10,
  // "F" (U+0046)
  0x18, 0x57, 0xCB, 0x50, 0xA2, 0x30, 0xD4, 0x0D, 0x38, 0x53, 0xEB, 0x70, 0x67, 0x30, 0x90, 0x43,
  0x0C, 0x40,
  // "G" (U+0047)
  0x00, 0x7B, 0xC5, 0x07, 0x80, 0x00, 0x0C, 0x00, 0x00, 0x49, 0x00, 0x00, 0x66, 0x0A, 0xD0, 0x75,
  0x00, 0xB0, 0x58, 0x03, 0x80, 0x0A, 0xBB, 0x40,
  // "H" (U+0048)
  0x07, 0x50, 0x57, 0x0A, 0x20, 0x84, 0x0B, 0x00, 0xB1, 0x0E, 0xCC, 0xE0, 0x38, 0x02, 0xB0, 0x65,
  0x05, 0x80, 0x93, 0x07, 0x50, 0xC0, 0x0A, 0x20,
  // "I" (U+0049)
  0x28, 0x1B, 0xD3, 0x20, 0x06, 0x30, 0x90, 0x33, 0x0C, 0x40, 0xC3, 0x02, 0x0A, 0x30, 0x50, 0x72,
  0x81, 0x3C, 0xB2,
  // "J" (U+004A)
  0x30, 0x70, 0x53, 0x0A, 0x02, 0x30, 0xC4, 0x0C, 0x30, 0x30, 0x93, 0x00, 0x63, 0x09, 0x03, 0x30,
  0xC3, 0x01, 0x0B, 0x28, 0x15, 0xB3, 0x20,
  // "K" (U+004B)
  0x07, 0x50, 0xC1, 0x0A, 0x29, 0x50, 0x0C, 0x59, 0x00, 0x0D, 0xD0, 0x00, 0x3D, 0xD1, 0x00, 0x66,
  0x84, 0x00, 0x93, 0x58, 0x00, 0xC0, 0x1C, 0x00,
  // "L" (U+004C)
  0x07, 0x50, 0xA2, 0x0C, 0x00, 0xC0, 0x39, 0x06, 0x60, 0x93, 0x0C, 0xCC,
  // "M" (U+004D)
  0x07, 0xC0, 0x04, 0xF1, 0x0A, 0xC0, 0x0A, 0xD0, 0x0C, 0xB0, 0x1B, 0xB0, 0x0B, 0xB0, 0x87, 0x80,
  0x38, 0xA1, 0xB7, 0x50, 0x65, 0x97, 0x5A, 0x20, 0x92, 0x8C, 0x0C, 0x00, 0xB0, 0x87, 0x0C, 0x00,
  // "N" (U+004E)
  0x07, 0xA0, 0x0B, 0x0A, 0xC0, 0x39, 0x0C, 0xA1, 0x56, 0x0B, 0x74, 0x83, 0x38, 0x47, 0xB0, 0x65,
  0x1A, 0xC0, 0x93, 0x0C, 0xA0, 0xB0, 0x0A, 0x70,
  // "O" (U+004F)
  0x00, 0x9B, 0xA0, 0x08, 0x60, 0x94, 0x0C, 0x00, 0x66, 0x49, 0x00, 0x75, 0x76, 0x00, 0xA2, 0x85,
  0x00, 0xC0, 0x67, 0x07, 0x60, 0x0B, 0xB8, 0x00,
  // "P" (U+0050)
  0x07, 0xCC, 0x20, 0xA2, 0x49, 0x0C, 0x04, 0x90, 0xC0, 0xA4, 0x3E, 0xB6, 0x06, 0x60, 0x00, 0x93,
  0x00, 0x0C, 0x00, 0x00,
  // "Q" (U+0051)
  0x00, 0x9B, 0xA0, 0x07, 0x60, 0x94, 0x0C, 0x00, 0x66, 0x49, 0x00, 0x75, 0x76, 0x00, 0xA2, 0x85,
  0x00, 0xD0, 0x67, 0x07, 0x70, 0x1B, 0xCA, 0x00, 0x00, 0x67, 0x00, 0x00, 0x1C, 0x00,
  // "R" (U+0052)
  0x07, 0xCC, 0x20, 0xA2, 0x49, 0x0C, 0x04, 0x90, 0xC0, 0xA4, 0x3E, 0xD7, 0x06, 0x78, 0x40, 0x93,
  0x58, 0x0C, 0x01, 0xC0,
  // "S" (U+0053)
  0x05, 0xCC, 0x30, 0xC0, 0x00, 0x1C, 0x00, 0x00, 0xB7, 0x00, 0x01, 0xD4, 0x00, 0x05, 0x80, 0x00,
  0x76, 0x0C, 0xBA, 0x00,
  // "T" (U+0054)
  0x83, 0x1B, 0xEB, 0x72, 0x0C, 0x40, 0xC3, 0x03, 0x09, 0x30, 0x06, 0x30, 0x90, 0x33, 0x0C, 0x40,
  0xC3,
  // "U" (U+0055)
  0x08, 0x40, 0x56, 0x0B, 0x10, 0x83, 0x0C, 0x00, 0xB1, 0x1B, 0x00, 0xC0, 0x48, 0x02, 0xA0, 0x75,
  0x05, 0x70, 0x75, 0x0B, 0x20, 0x2C, 0xC7, 0x00,
  // "V" (U+0056)
  0x1B, 0x00, 0xB2, 0x1B, 0x02, 0xB0, 0x0B, 0x08, 0x40, 0x0C, 0x0C, 0x00, 0x0C, 0x57, 0x00, 0x0B,
  0xA1, 0x00, 0x0C, 0xA0, 0x00, 0x0D, 0x40, 0x00,
  // "W" (U+0057)
  0x1B, 0x02, 0xC0, 0x1B, 0x1B, 0x07, 0xC0, 0x66, 0x1B, 0x0B, 0xA0, 0xB0, 0x1A, 0x37, 0xA2, 0xA0,
  0x1A, 0x91, 0xA8, 0x40, 0x1A, 0xA0, 0xAB, 0x00, 0x1E, 0x60, 0xD8, 0x00, 0x1F, 0x00, 0xE2, 0x00,
  // "X" (U+0058)
  0x00, 0xC0, 0x39, 0x00, 0x92, 0xB1, 0x00, 0x6A, 0x80, 0x00, 0x4E, 0x00, 0x00, 0x9C, 0x00, 0x02,
  0xAB, 0x00, 0x0A, 0x29, 0x30, 0x49, 0x07, 0x60,
  // "Y" (U+0059)
  0xB0, 0x3A, 0xC0, 0xB2, 0xC3, 0x90, 0xAC, 0x20, 0x89, 0x00, 0x84, 0x00, 0xB1, 0x00, 0xC0, 0x00,
  // "Z" (U+005A)
  0x28, 0x29, 0xBE, 0x63, 0x01, 0x0D, 0x40, 0x80, 0x63, 0x02, 0x0C, 0x40, 0xA0, 0x43, 0x03, 0x0B,
  0x40, 0xB0, 0x33, 0x83, 0x3E, 0xBB, 0x11,
  // "[" (U+005B)
  0x28, 0x16, 0xC5, 0x20, 0x90, 0x13, 0x0B, 0x40, 0xB3, 0x03, 0x08, 0x30, 0x60, 0x53, 0x09, 0x02,
  0x30, 0xB4, 0x0B, 0x38, 0x11, 0xD8, 0x20,
  // "\" (U+005C)
  0xB0, 0xB0, 0xA0, 0x82, 0x64, 0x56, 0x38, 0x1A,
  // "]" (U+005D)
  0x00, 0xAE, 0x00, 0x0B, 0x00, 0x29, 0x00, 0x56, 0x00, 0x83, 0x00, 0xA0, 0x00, 0xB0, 0x01, 0xA0,
  0x04, 0x70, 0x7C, 0x30,
  // "^" (U+005E)
  0x00, 0x50, 0x00, 0x1E, 0x40, 0x08, 0x59, 0x01, 0xA0, 0xB0, 0x83, 0x08, 0x30,
  // "_" (U+005F)
  0x9B, 0xB5,
  // "`" (U+0060)
  0x45, 0x0A,
  // "a" (U+0061)
  0x06, 0xC8, 0x71, 0xC0, 0xA4, 0x66, 0x0A, 0x19, 0x30, 0xC0, 0xA3, 0x5B, 0x05, 0xD8, 0x80,
  // "b" (U+0062)
  0x06, 0x50, 0x00, 0x92, 0x00, 0x0B, 0x9D, 0x10, 0xE1, 0x85, 0x39, 0x08, 0x46, 0x50, 0xB1, 0x95,
  0x2B, 0x0A, 0x9C, 0x20,
  // "c" (U+0063)
  0x05, 0xC8, 0x1B, 0x00, 0x65, 0x00, 0x93, 0x00, 0x93, 0x00, 0x4C, 0xA0,
  // "d" (U+0064)
  0x40, 0xC4, 0x8B, 0x4B, 0x06, 0xC9, 0x81, 0xC0, 0xA5, 0x66, 0x0A, 0x29, 0x30, 0xD0, 0xA3, 0x5B,
  0x05, 0xD8, 0x81,
  // "e" (U+0065)
  0x05, 0xCA, 0x19, 0x1B, 0x7C, 0xA2, 0x92, 0x00, 0x93, 0x00, 0x3C, 0xB2,
  // "f" (U+0066)
  0x38, 0x12, 0xC7, 0x30, 0x80, 0x43, 0x81, 0x3D, 0xA4, 0x0C, 0x40, 0x20, 0xA4, 0x05, 0x07, 0x40,
  0x80, 0x44, 0x0A, 0x01, 0x40, 0xC4, 0x01, 0x0A, 0x38, 0x12, 0xC3, 0x30,
  // "g" (U+0067)
  0x05, 0xC9, 0x71, 0xC0, 0xA4, 0x66, 0x0B, 0x29, 0x30, 0xD0, 0xA3, 0x5B, 0x05, 0xC9, 0x90, 0x00,
  0x66, 0x00, 0x0B, 0x10, 0xCC, 0x70, 0x00,
  // "h" (U+0068)
  0x06, 0x50, 0x00, 0x92, 0x00, 0x0B, 0x9D, 0x10, 0xD0, 0x93, 0x39, 0x0B, 0x16, 0x50, 0xC0, 0x92,
  0x1A, 0x0C, 0x04, 0x70,
  // "i" (U+0069)
  0x04, 0x30, 0x00, 0x0C, 0x01, 0xB0, 0x48, 0x07, 0x50, 0x92, 0x0C, 0x00,
  // "j" (U+006A)
  0x30, 0x40, 0x37, 0x10, 0xC4, 0x0B, 0x30, 0x30, 0x83, 0x06, 0x05, 0x30, 0x90, 0x33, 0x0B, 0x40,
  0xC3, 0x02, 0x09, 0x28, 0x13, 0xC2, 0x20,
  // "k" (U+006B)
  0x06, 0x60, 0x00, 0x92, 0x00, 0x0B, 0x0B, 0x10, 0xB8, 0x40, 0x3C, 0xB0, 0x06, 0x9C, 0x00, 0x92,
  0xB1, 0x0C, 0x08, 0x40,
  // "l" (U+006C)
  0x06, 0x60, 0x93, 0x0C, 0x00, 0xB0, 0x39, 0x06, 0x50, 0x92, 0x0C, 0x00,
  // "m" (U+006D)
  0x0B, 0x9C, 0x6D, 0x51, 0xE0, 0xA5, 0x48, 0x49, 0x0C, 0x06, 0x57, 0x50, 0xB0, 0x92, 0x92, 0x39,
  0x0C, 0x0C, 0x06, 0x60, 0xB0,
  // "n" (U+006E)
  0x0B, 0x9D, 0x11, 0xE1, 0x93, 0x49, 0x0B, 0x17, 0x50, 0xC0, 0xA2, 0x2A, 0x0C, 0x05, 0x70,
  // "o" (U+006F)
  0x06, 0xCA, 0x02, 0xB0, 0xA2, 0x75, 0x0A, 0x29, 0x20, 0xC0, 0x93, 0x39, 0x03, 0xCB, 0x10,
  // "p" (U+0070)
  0x00, 0xB8, 0xC1, 0x00, 0xE1, 0x75, 0x03, 0x90, 0x84, 0x06, 0x50, 0xB1, 0x09, 0x52, 0xB0, 0x0B,
  0x9C, 0x20, 0x0B, 0x00, 0x00, 0x2A, 0x00, 0x00, 0x47, 0x00, 0x00,
  // "q" (U+0071)
  0x06, 0xC8, 0x71, 0xC0, 0xA4, 0x66, 0x0B, 0x29, 0x30, 0xD0, 0xA3, 0x5B, 0x05, 0xD9, 0x90, 0x00,
  0x66, 0x00, 0x09, 0x30, 0x00, 0xB0, 0x00,
  // "r" (U+0072)
  0x0A, 0x95, 0x1E, 0x10, 0x48, 0x00, 0x75, 0x00, 0x92, 0x00, 0xC0, 0x00,
  // "s" (U+0073)
  0x1B, 0xC4, 0x57, 0x00, 0x2C, 0x10, 0x05, 0xA0, 0x00, 0xD0, 0xCC, 0x50,
  // "t" (U+0074)
  0x02, 0x10, 0x91, 0x4E, 0xA0, 0xB0, 0x38, 0x06, 0x50, 0x93, 0x07, 0xC0,
  // "u" (U+0075)
  0x0C, 0x06, 0x61, 0xB0, 0x93, 0x47, 0x0B, 0x07, 0x50, 0xC0, 0x93, 0x6A, 0x06, 0xC9, 0x70,
  // "v" (U+0076)
  0x65, 0x0C, 0x15, 0x64, 0x90, 0x56, 0xB3, 0x04, 0x9C, 0x00, 0x4E, 0x50, 0x03, 0xE0, 0x00,
  // "w" (U+0077)
  0x66, 0x2E, 0x09, 0x36, 0x57, 0xC0, 0xC0, 0x65, 0xAA, 0x47, 0x06, 0x97, 0xAA, 0x10, 0x6D, 0x1A,
  0xA0, 0x06, 0xB0, 0xC5, 0x00,
  // "x" (U+0078)
  0x01, 0xA1, 0xC0, 0x0C, 0x84, 0x00, 0x9A, 0x00, 0x0C, 0x70, 0x08, 0x5B, 0x02, 0xB0, 0xC0,
  // "y" (U+0079)
  0x05, 0x60, 0xB1, 0x05, 0x72, 0xA0, 0x04, 0x78, 0x40, 0x03, 0x8B, 0x00, 0x02, 0xC7, 0x00, 0x01,
  0xF1, 0x00, 0x02, 0xA0, 0x00, 0x09, 0x30, 0x00, 0xA9, 0x00, 0x00,
  // "z" (U+007A)
  0x01, 0xBD, 0x60, 0x00, 0xB0, 0x00, 0x85, 0x00, 0x2B, 0x00, 0x0A, 0x30, 0x02, 0xEB, 0x60,
  // "{" (U+007B)
  0x00, 0x8A, 0x01, 0xB0, 0x04, 0x80, 0x09, 0x30, 0xA8, 0x00, 0x0B, 0x00, 0x0B, 0x00, 0x29, 0x00,
  0x48, 0x00, 0x1B, 0x20,
  // "|" (U+007C)
  0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38,
  // "}" (U+007D)
  0x00, 0xB6, 0x00, 0x29, 0x00, 0x56, 0x00, 0x75, 0x00, 0x3D, 0x00, 0xB1, 0x01, 0xA0, 0x04, 0x70,
  0x08, 0x40, 0x69, 0x00,
  // "~" (U+007E)
  0x3B, 0x83, 0x44, 0x06, 0xC2,
  // "¡" (U+00A1)
  0x00, 0xA2, 0x00, 0x00, 0x00, 0x90, 0x03, 0x70, 0x07, 0x40, 0x0A, 0x20, 0x0D, 0x00, 0x18, 0x00,
  // "¢" (U+00A2)
  0x30, 0x82, 0x85, 0x1D, 0xD1, 0x0A, 0x43, 0x0C, 0x30, 0x20, 0xA3, 0x02, 0x0A, 0x48, 0x1B, 0xC3,
  0x20, 0x50, 0x32,
  // "£" (U+00A3)
  0x38, 0x18, 0xB7, 0x20, 0x20, 0xA4, 0x05, 0x06, 0x40, 0x80, 0x33, 0x82, 0x5E, 0xB4, 0x30, 0xC4,
  0x03, 0x08, 0x38, 0x31, 0xEB, 0xB5, 0x10,
  // "¤" (U+00A4)
  0x00, 0x00, 0x12, 0xBB, 0xB8, 0x09, 0x03, 0x60, 0xA0, 0x46, 0x2A, 0xBA, 0x80,
  // "¥" (U+00A5)
  0x0B, 0x02, 0xA0, 0xA1, 0xA2, 0x08, 0x59, 0x00, 0x6D, 0x20, 0x3C, 0xE8, 0x00, 0x56, 0x00, 0x7D,
  0xC4, 0x00, 0xB1, 0x00,
  // "¦" (U+00A6)
  0x38, 0x38, 0x38, 0x38, 0x00, 0x00, 0x00, 0x38, 0x38, 0x38, 0x38,
  // "§" (U+00A7)
  0x05, 0xCB, 0x0B, 0x00, 0x09, 0xA0, 0x38, 0x67, 0x4A, 0x65, 0x06, 0xC0, 0x00, 0xB0, 0xBC, 0x70,
  // "¨" (U+00A8)
  0x64, 0x20,
  // "©" (U+00A9)
  0x00, 0x58, 0x87, 0x00, 0x07, 0x59, 0xB6, 0x90, 0x36, 0x75, 0x00, 0x17, 0x71, 0xA1, 0x00, 0x08,
  0x61, 0x75, 0x00, 0x08, 0x36, 0x1A, 0xB4, 0x27, 0x07, 0x40, 0x01, 0x90, 0x00, 0x58, 0x87, 0x00,
  // "ª" (U+00AA)
  0x08, 0x96, 0x35, 0x62, 0x29, 0xB0,
  // "«" (U+00AB)
  0x02, 0x34, 0x11, 0xB4, 0xA0, 0x85, 0xB1, 0x02, 0x95, 0x60, 0x03, 0x02, 0x00,
  // "¬" (U+00AC)
  0x6B, 0xBC, 0x50, 0x00, 0x46, 0x00, 0x03, 0x50,
  // "®" (U+00AE)
  0x00, 0x58, 0x87, 0x00, 0x07, 0x6B, 0xA4, 0x90, 0x36, 0x28, 0x48, 0x17, 0x71, 0x2C, 0xD2, 0x08,
  0x61, 0x28, 0x83, 0x08, 0x36, 0x28, 0x19, 0x27, 0x07, 0x40, 0x01, 0x90, 0x00, 0x58, 0x87, 0x00,
  // "¯" (U+00AF)
  0xBB, 0xBB,
  // "°" (U+00B0)
  0x19, 0x90, 0x72, 0x54, 0x29, 0x90,
  // "±" (U+00B1)
  0x20, 0xA4, 0x0A, 0x28, 0x36, 0xBE, 0xB5, 0x20, 0xA4, 0x0A, 0x78, 0x36, 0xBB, 0xB5,
  // "²" (U+00B2)
  0x05, 0x92, 0x00, 0x55, 0x00, 0x90, 0x09, 0x10, 0x5A, 0x80,
  // "³" (U+00B3)
  0x05, 0x92, 0x00, 0x55, 0x05, 0xB0, 0x00, 0xA0, 0x49, 0x60,
  // "´" (U+00B4)
  0x1C, 0x82,
  // "µ" (U+00B5)
  0x00, 0xC0, 0x56, 0x01, 0xB0, 0x83, 0x03, 0x80, 0xB0, 0x06, 0x50, 0xC0, 0x09, 0x35, 0xA0, 0x0B,
  0xB9, 0x70, 0x0B, 0x00, 0x00, 0x29, 0x00, 0x00, 0x56, 0x00, 0x00,
  // "¶" (U+00B6)
  0x07, 0xEC, 0x90, 0xFF, 0x48, 0x2F, 0xF4, 0x80, 0xFF, 0x48, 0x0B, 0xF4, 0x80, 0x06, 0x48, 0x00,
  0x44, 0x80, 0x04, 0x48, 0x00, 0x44, 0x80, 0x03, 0x36,
  // "·" (U+00B7)
  0x71,
  // "¸" (U+00B8)
  0x05, 0x0B, 0x78,
  // "¹" (U+00B9)
  0x05, 0x6C, 0x0A, 0x18, 0x45,
  // "º" (U+00BA)
  0x08, 0xA2, 0x25, 0x53, 0x1A, 0x80,
  // "»" (U+00BB)
  0x23, 0x41, 0x0B, 0x39, 0x0C, 0x2C, 0x84, 0xA2, 0x20, 0x20,
  // "¼" (U+00BC)
  0x00, 0x50, 0x06, 0x40, 0x6C, 0x01, 0x80, 0x00, 0xA0, 0x91, 0x00, 0x18, 0x55, 0x54, 0x04, 0x69,
  0x2C, 0x30, 0x09, 0x18, 0x90, 0x05, 0x54, 0x9C, 0x21, 0x90, 0x00, 0x60,
  // "½" (U+00BD)
  0x00, 0x50, 0x06, 0x40, 0x6C, 0x01, 0x80, 0x00, 0xA0, 0x91, 0x00, 0x18, 0x5A, 0x92, 0x04, 0x69,
  0x05, 0x50, 0x09, 0x10, 0x90, 0x05, 0x50, 0x91, 0x01, 0x90, 0x5A, 0x80,
  // "¾" (U+00BE)
  0x05, 0x92, 0x06, 0x40, 0x05, 0x51, 0x80, 0x05, 0xB0, 0x91, 0x00, 0x0A, 0x65, 0x54, 0x49, 0x89,
  0x2C, 0x30, 0x09, 0x18, 0x90, 0x05, 0x54, 0x9C, 0x21, 0x90, 0x00, 0x60,
  // "¿" (U+00BF)
  0x00, 0x35, 0x00, 0x10, 0x00, 0x90, 0x03, 0x90, 0x1B, 0x10, 0x75, 0x00, 0xA3, 0x00, 0x5C, 0xB0,
  // "À" (U+00C0)
  0x30, 0x40, 0x54, 0x0A, 0x71, 0x00, 0x93, 0x0C, 0x0A, 0x28, 0x16, 0x7B, 0x28, 0x95, 0xC2, 0xB0,
  0x3C, 0x0C, 0x09, 0xDC, 0xC0, 0xD2, 0x81, 0xD6, 0x82, 0x0D,
  // "Á" (U+00C1)
  0x40, 0x10, 0xC4, 0x08, 0x02, 0x72, 0x00, 0x94, 0x0C, 0x0A, 0x38, 0x16, 0x7B, 0x38, 0x1C, 0x2B,
  0x28, 0x23, 0xC0, 0xC2, 0x82, 0x9D, 0xCC, 0x20, 0xD2, 0x82, 0xD0, 0x68, 0x20, 0xD1,
  // "Â" (U+00C2)
  0x40, 0xD0, 0x43, 0x81, 0x73, 0x87, 0x20, 0x09, 0x40, 0xC0, 0xA3, 0x81, 0x67, 0xB3, 0x81, 0xC2,
  0xB2, 0x82, 0x3C, 0x0C, 0x28, 0x29, 0xDC, 0xC2, 0x0D, 0x28, 0x2D, 0x06, 0x82, 0x0D, 0x10,
  // "Ã" (U+00C3)
  0x38, 0x25, 0xA6, 0x23, 0x81, 0x73, 0xB7, 0x40, 0x09, 0x50, 0xC0, 0xA4, 0x81, 0x67, 0xB4, 0x81,
  0xC2, 0xB3, 0x82, 0x3C, 0x0C, 0x38, 0x29, 0xDC, 0xC3, 0x0D, 0x20, 0xD2, 0x06, 0x08, 0x20, 0xD2,
  // "Ä" (U+00C4)
  0x38, 0x16, 0x42, 0x72, 0x00, 0x94, 0x0C, 0x0A, 0x38, 0x16, 0x7B, 0x38, 0x1C, 0x2B, 0x28, 0x23,
  0xC0, 0xC2, 0x82, 0x9D, 0xCC, 0x20, 0xD2, 0x82, 0xD0, 0x68, 0x20, 0xD1,
  // "Å" (U+00C5)
  0x00, 0x03, 0x91, 0x00, 0x08, 0x16, 0x00, 0x03, 0x91, 0x00, 0x09, 0x90, 0x00, 0x0C, 0xA0, 0x00,
  0x67, 0xB0, 0x00, 0xC2, 0xB0, 0x03, 0xC0, 0xC0, 0x09, 0xDC, 0xC0, 0x0D, 0x00, 0xD0, 0x68, 0x00,
  0xD0,
  // "Æ" (U+00C6)
  0x38, 0x32, 0xED, 0xB8, 0x38, 0x19, 0x96, 0x48, 0x21, 0xC8, 0x34, 0x83, 0x86, 0xAB, 0xA3, 0x81,
  0xE1, 0xA4, 0x82, 0x7D, 0xB9, 0x48, 0x2D, 0x14, 0x73, 0x85, 0x68, 0x07, 0xDB, 0x41,
  // "Ç" (U+00C7)
  0x28, 0x48, 0xCB, 0x07, 0x83, 0x0D, 0x30, 0x40, 0x93, 0x07, 0x06, 0x30, 0x70, 0x53, 0x05, 0x08,
  0x48, 0x1B, 0xB7, 0x30, 0x54, 0x0B, 0x30, 0x70, 0x82,
  // "È" (U+00C8)
  0x20, 0x40, 0x54, 0x0A, 0x78, 0x57, 0xCB, 0x50, 0xA2, 0x30, 0xC4, 0x84, 0xEB, 0x70, 0x38, 0x30,
  0x60, 0x53, 0x09, 0x03, 0x38, 0x2C, 0xCB, 0x11,
  // "É" (U+00C9)
  0x20, 0x10, 0xC3, 0x08, 0x02, 0x78, 0x57, 0xCB, 0x50, 0xA2, 0x30, 0xC4, 0x84, 0xEB, 0x70, 0x38,
  0x30, 0x60, 0x53, 0x09, 0x03, 0x38, 0x2C, 0xCB, 0x11,
  // "Ê" (U+00CA)
  0x30, 0xD0, 0x42, 0x81, 0x73, 0x86, 0x85, 0x7C, 0xB5, 0x0A, 0x23, 0x0C, 0x48, 0x4E, 0xB7, 0x03,
  0x83, 0x06, 0x05, 0x30, 0x90, 0x33, 0x82, 0xCC, 0xB1, 0x10,
  // "Ë" (U+00CB)
  0x28, 0x16, 0x42, 0x68, 0x57, 0xCB, 0x50, 0xA2, 0x30, 0xC4, 0x84, 0xEB, 0x70, 0x38, 0x30, 0x60,
  0x53, 0x09, 0x03, 0x38, 0x2C, 0xCB, 0x11,
  // "Ì" (U+00CC)
  0x20, 0x40, 0x54, 0x0A, 0x71, 0x81, 0xBD, 0x32, 0x00, 0x63, 0x09, 0x03, 0x30, 0xC4, 0x0C, 0x30,
  0x20, 0xA3, 0x05, 0x07, 0x28, 0x13, 0xCB, 0x20,
  // "Í" (U+00CD)
  0x30, 0x10, 0xC3, 0x08, 0x02, 0x78, 0x1B, 0xD3, 0x20, 0x06, 0x30, 0x90, 0x33, 0x0C, 0x40, 0xC3,
  0x02, 0x0A, 0x30, 0x50, 0x72, 0x81, 0x3C, 0xB2,
  // "Î" (U+00CE)
  0x30, 0xD0, 0x42, 0x81, 0x73, 0x87, 0x81, 0xBD, 0x32, 0x00, 0x63, 0x09, 0x03, 0x30, 0xC4, 0x0C,
  0x30, 0x20, 0xA3, 0x05, 0x07, 0x28, 0x13, 0xCB, 0x20,
  // "Ï" (U+00CF)
  0x28, 0x16, 0x42, 0x78, 0x1B, 0xD3, 0x20, 0x06, 0x30, 0x90, 0x33, 0x0C, 0x40, 0xC3, 0x02, 0x0A,
  0x30, 0x50, 0x72, 0x81, 0x3C, 0xB2,
  // "Ð" (U+00D0)
  0x07, 0xCC, 0x40, 0xA2, 0x1D, 0x0D, 0x00, 0xD8, 0xE9, 0x0D, 0x48, 0x01, 0xC7, 0x50, 0x68, 0x93,
  0x1C, 0x1C, 0xCB, 0x20,
  // "Ñ" (U+00D1)
  0x00, 0x5A, 0x62, 0x00, 0x73, 0xB0, 0x00, 0x00, 0x00, 0x07, 0xA0, 0x0B, 0x0A, 0xC0, 0x39, 0x0C,
  0xA1, 0x56, 0x0B, 0x74, 0x83, 0x38, 0x47, 0xB0, 0x65, 0x1A, 0xC0, 0x93, 0x0C, 0xA0, 0xB0, 0x0A,
  0x70,
  // "Ò" (U+00D2)
  0x20, 0x40, 0x55, 0x0A, 0x73, 0x81, 0x9B, 0xA2, 0x85, 0x86, 0x09, 0x40, 0xC2, 0x82, 0x66, 0x49,
  0x28, 0x27, 0x57, 0x62, 0x82, 0xA2, 0x85, 0x28, 0x5C, 0x06, 0x70, 0x76, 0x28, 0x1B, 0xB8, 0x20,
  // "Ó" (U+00D3)
  0x00, 0x01, 0xC0, 0x00, 0x08, 0x20, 0x00, 0x00, 0x00, 0x00, 0x9B, 0xA0, 0x08, 0x60, 0x94, 0x0C,
  0x00, 0x66, 0x49, 0x00, 0x75, 0x76, 0x00, 0xA2, 0x85, 0x00, 0xC0, 0x67, 0x07, 0x60, 0x0B, 0xB8,
  0x00,
  // "Ô" (U+00D4)
  0x00, 0x0D, 0x40, 0x00, 0x73, 0x80, 0x00, 0x00, 0x00, 0x00, 0x9B, 0xA0, 0x08, 0x60, 0x94, 0x0C,
  0x00, 0x66, 0x49, 0x00, 0x75, 0x76, 0x00, 0xA2, 0x85, 0x00, 0xC0, 0x67, 0x07, 0x60, 0x0B, 0xB8,
  0x00,
  // "Õ" (U+00D5)
  0x00, 0x5A, 0x62, 0x00, 0x73, 0xB0, 0x00, 0x00, 0x00, 0x00, 0x9B, 0xA0, 0x08, 0x60, 0x94, 0x0C,
  0x00, 0x66, 0x49, 0x00, 0x75, 0x76, 0x00, 0xA2, 0x85, 0x00, 0xC0, 0x67, 0x07, 0x60, 0x0B, 0xB8,
  0x00,
  // "Ö" (U+00D6)
  0x00, 0x06, 0x42, 0x00, 0x00, 0x00, 0x00, 0x9B, 0xA0, 0x08, 0x60, 0x94, 0x0C, 0x00, 0x66, 0x49,
  0x00, 0x75, 0x76, 0x00, 0xA2, 0x85, 0x00, 0xC0, 0x67, 0x07, 0x60, 0x0B, 0xB8, 0x00,
  // "×" (U+00D7)
  0x11, 0x02, 0x11, 0xB4, 0xB1, 0x03, 0xF3, 0x02, 0xB3, 0xB1, 0x11, 0x01, 0x00,
  // "Ø" (U+00D8)
  0x50, 0x22, 0x8D, 0x29, 0xBB, 0x80, 0x76, 0x0D, 0x40, 0xC0, 0x6B, 0x64, 0x91, 0x97, 0x57, 0x69,
  0x1A, 0x28, 0x96, 0x0C, 0x06, 0xC0, 0x76, 0x07, 0xBB, 0x82, 0x02, 0x50,
  // "Ù" (U+00D9)
  0x20, 0x40, 0x55, 0x0A, 0x72, 0x89, 0x38, 0x40, 0x56, 0x0B, 0x10, 0x83, 0x0C, 0x28, 0x2B, 0x11,
  0xB2, 0x8A, 0x6C, 0x04, 0x80, 0x2A, 0x07, 0x50, 0x57, 0x07, 0x50, 0xB2, 0x02, 0xCC, 0x72,
  // "Ú" (U+00DA)
  0x30, 0x10, 0xC4, 0x08, 0x02, 0x71, 0x89, 0x38, 0x40, 0x56, 0x0B, 0x10, 0x83, 0x0C, 0x28, 0x2B,
  0x11, 0xB2, 0x8A, 0x6C, 0x04, 0x80, 0x2A, 0x07, 0x50, 0x57, 0x07, 0x50, 0xB2, 0x02, 0xCC, 0x72,
  // "Û" (U+00DB)
  0x00, 0x0D, 0x40, 0x00, 0x73, 0x80, 0x00, 0x00, 0x00, 0x08, 0x40, 0x56, 0x0B, 0x10, 0x83, 0x0C,
  0x00, 0xB1, 0x1B, 0x00, 0xC0, 0x48, 0x02, 0xA0, 0x75, 0x05, 0x70, 0x75, 0x0B, 0x20, 0x2C, 0xC7,
  0x00,
  // "Ü" (U+00DC)
  0x00, 0x06, 0x42, 0x00, 0x00, 0x00, 0x08, 0x40, 0x56, 0x0B, 0x10, 0x83, 0x0C, 0x00, 0xB1, 0x1B,
  0x00, 0xC0, 0x48, 0x02, 0xA0, 0x75, 0x05, 0x70, 0x75, 0x0B, 0x20, 0x2C, 0xC7, 0x00,
  // "Ý" (U+00DD)
  0x01, 0xC0, 0x08, 0x20, 0x00, 0x00, 0xB0, 0x3A, 0xC0, 0xB2, 0xC3, 0x90, 0xAC, 0x20, 0x89, 0x00,
  0x84, 0x00, 0xB1, 0x00, 0xC0, 0x00,
  // "Þ" (U+00DE)
  0x07, 0x50, 0x00, 0xAC, 0x90, 0x0C, 0x09, 0x50, 0xB0, 0x85, 0x38, 0x1C, 0x16, 0xDB, 0x30, 0x92,
  0x00, 0x0C, 0x00, 0x00,
  // "ß" (U+00DF)
  0x38, 0x21, 0xBC, 0x43, 0x82, 0x83, 0x57, 0x38, 0x2C, 0x1B, 0x13, 0x81, 0xB8, 0x43, 0x82, 0x39,
  0x85, 0x38, 0x26, 0x61, 0xC3, 0x82, 0x93, 0x0D, 0x38, 0x2B, 0x8C, 0x73, 0x0C, 0x50, 0x30, 0x84,
  0x81, 0x3C, 0x24,
  // "à" (U+00E0)
  0x20, 0x40, 0x54, 0x0A, 0x78, 0xB2, 0x6C, 0x87, 0x1C, 0x0A, 0x46, 0x60, 0xA1, 0x93, 0x0C, 0x0A,
  0x35, 0xB0, 0x5D, 0x88, 0x10,
  // "á" (U+00E1)
  0x20, 0x10, 0xC3, 0x08, 0x02, 0x78, 0xB2, 0x6C, 0x87, 0x1C, 0x0A, 0x46, 0x60, 0xA1, 0x93, 0x0C,
  0x0A, 0x35, 0xB0, 0x5D, 0x88, 0x10,
  // "â" (U+00E2)
  0x30, 0xD0, 0x42, 0x81, 0x73, 0x86, 0x8B, 0x26, 0xC8, 0x71, 0xC0, 0xA4, 0x66, 0x0A, 0x19, 0x30,
  0xC0, 0xA3, 0x5B, 0x05, 0xD8, 0x81,
  // "ã" (U+00E3)
  0x18, 0x65, 0xA6, 0x20, 0x73, 0xB7, 0x8B, 0x26, 0xC8, 0x71, 0xC0, 0xA4, 0x66, 0x0A, 0x19, 0x30,
  0xC0, 0xA3, 0x5B, 0x05, 0xD8, 0x81,
  // "ä" (U+00E4)
  0x00, 0x64, 0x20, 0x00, 0x00, 0x06, 0xC8, 0x71, 0xC0, 0xA4, 0x66, 0x0A, 0x19, 0x30, 0xC0, 0xA3,
  0x5B, 0x05, 0xD8, 0x80,
  // "å" (U+00E5)
  0x00, 0x39, 0x10, 0x08, 0x16, 0x00, 0x39, 0x10, 0x6C, 0x87, 0x1C, 0x0A, 0x46, 0x60, 0xA1, 0x93,
  0x0C, 0x0A, 0x35, 0xB0, 0x5D, 0x88, 0x00,
  // "æ" (U+00E6)
  0x06, 0xCA, 0xAC, 0x61, 0xC0, 0xC4, 0x57, 0x66, 0x0C, 0xB8, 0x09, 0x30, 0xB0, 0x00, 0xA3, 0x6D,
  0x00, 0x05, 0xC8, 0xAC, 0x90,
  // "ç" (U+00E7)
  0x05, 0xC8, 0x1B, 0x00, 0x65, 0x00, 0x93, 0x00, 0x93, 0x00, 0x4C, 0xA0, 0x05, 0x00, 0x0B, 0x00,
  0x78, 0x00,
  // "è" (U+00E8)
  0x04, 0x50, 0x00, 0xA0, 0x00, 0x00, 0x05, 0xCA, 0x19, 0x1B, 0x7C, 0xA2, 0x92, 0x00, 0x93, 0x00,
  0x3C, 0xB2,
  // "é" (U+00E9)
  0x00, 0x1C, 0x00, 0x82, 0x00, 0x00, 0x05, 0xCA, 0x19, 0x1B, 0x7C, 0xA2, 0x92, 0x00, 0x93, 0x00,
  0x3C, 0xB2,
  // "ê" (U+00EA)
  0x00, 0xD4, 0x07, 0x38, 0x00, 0x00, 0x05, 0xCA, 0x19, 0x1B, 0x7C, 0xA2, 0x92, 0x00, 0x93, 0x00,
  0x3C, 0xB2,
  // "ë" (U+00EB)
  0x00, 0x64, 0x20, 0x00, 0x00, 0x05, 0xCA, 0x01, 0x91, 0xB0, 0x7C, 0xA2, 0x09, 0x20, 0x00, 0x93,
  0x00, 0x03, 0xCB, 0x20,
  // "ì" (U+00EC)
  0x45, 0x0A, 0x00, 0x0C, 0x1B, 0x48, 0x75, 0x92, 0xC0,
  // "í" (U+00ED)
  0x01, 0xC0, 0x82, 0x00, 0x00, 0xC0, 0x1B, 0x04, 0x80, 0x75, 0x09, 0x20, 0xC0, 0x00,
  // "î" (U+00EE)
  0x0D, 0x47, 0x38, 0x00, 0x00, 0xC0, 0x1B, 0x04, 0x80, 0x75, 0x09, 0x20, 0xC0, 0x00,
  // "ï" (U+00EF)
  0x06, 0x42, 0x00, 0x00, 0x0C, 0x00, 0x1B, 0x00, 0x48, 0x00, 0x75, 0x00, 0x92, 0x00, 0xC0, 0x00,
  // "ð" (U+00F0)
  0x00, 0xB8, 0x30, 0x3A, 0xA0, 0x00, 0x0B, 0x00, 0x8B, 0xB2, 0x58, 0x0D, 0x1A, 0x10, 0xC0, 0xB1,
  0x39, 0x05, 0xCB, 0x10,
  // "ñ" (U+00F1)
  0x18, 0x65, 0xA6, 0x20, 0x73, 0xB7, 0x8B, 0x2B, 0x9D, 0x11, 0xE1, 0x93, 0x49, 0x0B, 0x17, 0x50,
  0xC0, 0xA2, 0x2A, 0x0C, 0x05, 0x71,
  // "ò" (U+00F2)
  0x10, 0x40, 0x54, 0x0A, 0x71, 0x8B, 0x26, 0xCA, 0x02, 0xB0, 0xA2, 0x75, 0x0A, 0x29, 0x20, 0xC0,
  0x93, 0x39, 0x03, 0xCB, 0x11,
  // "ó" (U+00F3)
  0x20, 0x10, 0xC3, 0x08, 0x02, 0x78, 0xB2, 0x6C, 0xA0, 0x2B, 0x0A, 0x27, 0x50, 0xA2, 0x92, 0x0C,
  0x09, 0x33, 0x90, 0x3C, 0xB1, 0x10,
  // "ô" (U+00F4)
  0x20, 0xD0, 0x42, 0x81, 0x73, 0x87, 0x8B, 0x26, 0xCA, 0x02, 0xB0, 0xA2, 0x75, 0x0A, 0x29, 0x20,
  0xC0, 0x93, 0x39, 0x03, 0xCB, 0x11,
  // "õ" (U+00F5)
  0x18, 0x65, 0xA6, 0x20, 0x73, 0xB7, 0x8B, 0x26, 0xCA, 0x02, 0xB0, 0xA2, 0x75, 0x0A, 0x29, 0x20,
  0xC0, 0x93, 0x39, 0x03, 0xCB, 0x11,
  // "ö" (U+00F6)
  0x00, 0x64, 0x20, 0x00, 0x00, 0x06, 0xCA, 0x02, 0xB0, 0xA2, 0x75, 0x0A, 0x29, 0x20, 0xC0, 0x93,
  0x39, 0x03, 0xCB, 0x10,
  // "÷" (U+00F7)
  0x20, 0x87, 0x83, 0x6B, 0xBB, 0x57, 0x08, 0x20,
  // "ø" (U+00F8)
  0x48, 0xB6, 0x20, 0x5C, 0xC3, 0x1B, 0x1E, 0x27, 0x5A, 0xB2, 0x99, 0x5B, 0x09, 0xA3, 0x90, 0x9C,
  0xB1, 0x03, 0x40,
  // "ù" (U+00F9)
  0x20, 0x40, 0x54, 0x0A, 0x78, 0xB2, 0xC0, 0x66, 0x1B, 0x09, 0x34, 0x70, 0xB0, 0x75, 0x0C, 0x09,
  0x36, 0xA0, 0x6C, 0x97, 0x10,
  // "ú" (U+00FA)
  0x20, 0x10, 0xC3, 0x08, 0x02, 0x78, 0xB2, 0xC0, 0x66, 0x1B, 0x09, 0x34, 0x70, 0xB0, 0x75, 0x0C,
  0x09, 0x36, 0xA0, 0x6C, 0x97, 0x10,
  // "û" (U+00FB)
  0x30, 0xD0, 0x42, 0x81, 0x73, 0x86, 0x8B, 0x2C, 0x06, 0x61, 0xB0, 0x93, 0x47, 0x0B, 0x07, 0x50,
  0xC0, 0x93, 0x6A, 0x06, 0xC9, 0x71,
  // "ü" (U+00FC)
  0x00, 0x64, 0x20, 0x00, 0x00, 0x0C, 0x06, 0x61, 0xB0, 0x93, 0x47, 0x0B, 0x07, 0x50, 0xC0, 0x93,
  0x6A, 0x06, 0xC9, 0x70,
  // "ý" (U+00FD)
  0x30, 0x10, 0xC4, 0x08, 0x02, 0x71, 0x89, 0x05, 0x60, 0xB1, 0x05, 0x72, 0xA2, 0x82, 0x47, 0x84,
  0x28, 0x13, 0x8B, 0x38, 0x12, 0xC7, 0x38, 0x11, 0xF1, 0x30, 0x20, 0xA4, 0x09, 0x03, 0x30, 0xA0,
  0x94,
  // "þ" (U+00FE)
  0x20, 0x06, 0x40, 0x90, 0x24, 0x82, 0xB8, 0xC1, 0x28, 0xA3, 0xD1, 0x75, 0x02, 0x90, 0x84, 0x05,
  0x50, 0xB1, 0x08, 0x52, 0xB2, 0x82, 0xA9, 0xC2, 0x20, 0xB4, 0x01, 0x09, 0x40, 0x40, 0x74,
  // "ÿ" (U+00FF)
  0x28, 0x16, 0x42, 0x71, 0x89, 0x05, 0x60, 0xB1, 0x05, 0x72, 0xA2, 0x82, 0x47, 0x84, 0x28, 0x13,
  0x8B, 0x38, 0x12, 0xC7, 0x38, 0x11, 0xF1, 0x30, 0x20, 0xA4, 0x09, 0x03, 0x30, 0xA0, 0x94,
  // "Ā" (U+0100)
  0x38, 0x19, 0xB7, 0x72, 0x00, 0x94, 0x0C, 0x0A, 0x38, 0x16, 0x7B, 0x38, 0x1C, 0x2B, 0x28, 0x23,
  0xC0, 0xC2, 0x82, 0x9D, 0xCC, 0x20, 0xD2, 0x82, 0xD0, 0x68, 0x20, 0xD1,
  // "ā" (U+0101)
  0x00, 0x9B, 0x70, 0x00, 0x00, 0x06, 0xC8, 0x71, 0xC0, 0xA4, 0x66, 0x0A, 0x19, 0x30, 0xC0, 0xA3,
  0x5B, 0x05, 0xD8, 0x80,
  // "Ă" (U+0102)
  0x38, 0x15, 0x05, 0x38, 0x15, 0xB4, 0x72, 0x00, 0x94, 0x0C, 0x0A, 0x38, 0x16, 0x7B, 0x38, 0x1C,
  0x2B, 0x28, 0x23, 0xC0, 0xC2, 0x82, 0x9D, 0xCC, 0x20, 0xD2, 0x82, 0xD0, 0x68, 0x20, 0xD1,
  // "ă" (U+0103)
  0x00, 0x50, 0x50, 0x05, 0xB4, 0x00, 0x00, 0x00, 0x6C, 0x87, 0x1C, 0x0A, 0x46, 0x60, 0xA1, 0x93,
  0x0C, 0x0A, 0x35, 0xB0, 0x5D, 0x88, 0x00,
  // "Ą" (U+0104)
  0x00, 0x09, 0x90, 0x00, 0xCA, 0x00, 0x67, 0xB0, 0x0C, 0x2B, 0x03, 0xC0, 0xC0, 0x9D, 0xCC, 0x0D,
  0x00, 0xD6, 0x80, 0x0D, 0x00, 0x00, 0x50, 0x00, 0x45, 0x00, 0x03, 0xA0,
  // "ą" (U+0105)
  0x06, 0xC8, 0x71, 0xC0, 0xA4, 0x66, 0x0A, 0x19, 0x30, 0xC0, 0xA3, 0x5B, 0x05, 0xD8, 0x80, 0x00,
  0x50, 0x00, 0x45, 0x00, 0x03, 0xA0, 0x00,
  // "Ć" (U+0106)
  0x30, 0x10, 0xC3, 0x08, 0x02, 0x78, 0x48, 0xCB, 0x07, 0x83, 0x0D, 0x30, 0x40, 0x93, 0x07, 0x06,
  0x30, 0x70, 0x53, 0x05, 0x08, 0x48, 0x1B, 0xB7, 0x10,
  // "ć" (U+0107)
  0x00, 0x1C, 0x00, 0x82, 0x00, 0x00, 0x05, 0xC8, 0x1B, 0x00, 0x65, 0x00, 0x93, 0x00, 0x93, 0x00,
  0x4C, 0xA0,
  // "Ĉ" (U+0108)
  0x30, 0xD0, 0x42, 0x81, 0x73, 0x87, 0x84, 0x8C, 0xB0, 0x78, 0x30, 0xD3, 0x04, 0x09, 0x30, 0x70,
  0x63, 0x07, 0x05, 0x30, 0x50, 0x84, 0x81, 0xBB, 0x71,
  // "ĉ" (U+0109)
  0x00, 0xD4, 0x07, 0x38, 0x00, 0x00, 0x05, 0xC8, 0x1B, 0x00, 0x65, 0x00, 0x93, 0x00, 0x93, 0x00,
  0x4C, 0xA0,
  // "Ċ" (U+010A)
  0x30, 0x60, 0x17, 0x84, 0x8C, 0xB0, 0x78, 0x30, 0xD3, 0x04, 0x09, 0x30, 0x70, 0x63, 0x07, 0x05,
  0x30, 0x50, 0x84, 0x81, 0xBB, 0x71,
  // "ċ" (U+010B)
  0x00, 0x61, 0x00, 0x00, 0x05, 0xC8, 0x1B, 0x00, 0x65, 0x00, 0x93, 0x00, 0x93, 0x00, 0x4C, 0xA0,
  // "Č" (U+010C)
  0x28, 0x16, 0x49, 0x28, 0x11, 0xE2, 0x78, 0x48, 0xCB, 0x07, 0x83, 0x0D, 0x30, 0x40, 0x93, 0x07,
  0x06, 0x30, 0x70, 0x53, 0x05, 0x08, 0x48, 0x1B, 0xB7, 0x10,
  // "č" (U+010D)
  0x06, 0x49, 0x01, 0xE2, 0x00, 0x00, 0x05, 0xC8, 0x1B, 0x00, 0x65, 0x00, 0x93, 0x00, 0x93, 0x00,
  0x4C, 0xA0,
  // "Ď" (U+010E)
  0x00, 0x64, 0x90, 0x01, 0xE2, 0x00, 0x00, 0x00, 0x7C, 0xC4, 0x0A, 0x21, 0xD0, 0xC0, 0x0D, 0x0C,
  0x00, 0xD3, 0x90, 0x1C, 0x66, 0x06, 0x89, 0x31, 0xD1, 0xCC, 0xB2, 0x00,
  // "ď" (U+010F)
  0x00, 0x00, 0xC7, 0x40, 0x00, 0x0B, 0x40, 0x06, 0xC9, 0x80, 0x01, 0xC0, 0xA5, 0x00, 0x66, 0x0A,
  0x20, 0x09, 0x30, 0xD0, 0x00, 0xA3, 0x5B, 0x00, 0x05, 0xD8, 0x80, 0x00,
  // "Đ" (U+0110)
  0x07, 0xCC, 0x40, 0xA2, 0x1D, 0x0D, 0x00, 0xD8, 0xE9, 0x0D, 0x48, 0x01, 0xC7, 0x50, 0x68, 0x93,
  0x1C, 0x1C, 0xCB, 0x20,
  // "đ" (U+0111)
  0x00, 0x2B, 0xE5, 0x00, 0x02, 0x90, 0x06, 0xC9, 0x60, 0x1C, 0x0A, 0x40, 0x66, 0x0A, 0x10, 0x93,
  0x0C, 0x00, 0xA3, 0x5B, 0x00, 0x5D, 0x88, 0x00,
  // "Ē" (U+0112)
  0x28, 0x19, 0xB7, 0x68, 0x57, 0xCB, 0x50, 0xA2, 0x30, 0xC4, 0x84, 0xEB, 0x70, 0x38, 0x30, 0x60,
  0x53, 0x09, 0x03, 0x38, 0x2C, 0xCB, 0x11,
  // "ē" (U+0113)
  0x00, 0x9B, 0x70, 0x00, 0x00, 0x05, 0xCA, 0x01, 0x91, 0xB0, 0x7C, 0xA2, 0x09, 0x20, 0x00, 0x93,
  0x00, 0x03, 0xCB, 0x20,
  // "Ĕ" (U+0114)
  0x28, 0x15, 0x05, 0x28, 0x15, 0xB4, 0x68, 0x57, 0xCB, 0x50, 0xA2, 0x30, 0xC4, 0x84, 0xEB, 0x70,
  0x38, 0x30, 0x60, 0x53, 0x09, 0x03, 0x38, 0x2C, 0xCB, 0x11,
  // "ĕ" (U+0115)
  0x00, 0x50, 0x50, 0x05, 0xB4, 0x00, 0x00, 0x00, 0x5C, 0xA0, 0x19, 0x1B, 0x07, 0xCA, 0x20, 0x92,
  0x00, 0x09, 0x30, 0x00, 0x3C, 0xB2, 0x00,
  // "Ė" (U+0116)
  0x30, 0x60, 0x16, 0x85, 0x7C, 0xB5, 0x0A, 0x23, 0x0C, 0x48, 0x4E, 0xB7, 0x03, 0x83, 0x06, 0x05,
  0x30, 0x90, 0x33, 0x82, 0xCC, 0xB1, 0x10,
  // "ė" (U+0117)
  0x00, 0x61, 0x00, 0x00, 0x05, 0xCA, 0x19, 0x1B, 0x7C, 0xA2, 0x92, 0x00, 0x93, 0x00, 0x3C, 0xB2,
  // "Ę" (U+0118)
  0x18, 0x57, 0xCB, 0x50, 0xA2, 0x30, 0xC4, 0x84, 0xEB, 0x70, 0x38, 0x30, 0x60, 0x53, 0x09, 0x03,
  0x38, 0x2C, 0xCB, 0x13, 0x05, 0x30, 0x40, 0x53, 0x03, 0x0A, 0x20,
  // "ę" (U+0119)
  0x05, 0xC9, 0x1C, 0x0C, 0x77, 0x3A, 0x9C, 0x91, 0x93, 0x00, 0x3C, 0xC2, 0x02, 0x80, 0x08, 0x20,
  0x06, 0x90,
  // "Ě" (U+011A)
  0x28, 0x16, 0x49, 0x28, 0x11, 0xE2, 0x68, 0x57, 0xCB, 0x50, 0xA2, 0x30, 0xC4, 0x84, 0xEB, 0x70,
  0x38, 0x30, 0x60, 0x53, 0x09, 0x03, 0x38, 0x2C, 0xCB, 0x11,
  // "ě" (U+011B)
  0x06, 0x49, 0x01, 0xE2, 0x00, 0x00, 0x05, 0xCA, 0x19, 0x1B, 0x7C, 0xA2, 0x92, 0x00, 0x93, 0x00,
  0x3C, 0xB2,
  // "Ĝ" (U+011C)
  0x40, 0xD0, 0x43, 0x81, 0x73, 0x87, 0x18, 0x57, 0xBC, 0x50, 0x78, 0x40, 0xC4, 0x04, 0x09, 0x48,
  0x66, 0x60, 0xAD, 0x07, 0x52, 0x85, 0xB0, 0x58, 0x03, 0x82, 0x82, 0xAB, 0xB4, 0x10,
  // "ĝ" (U+011D)
  0x20, 0xD0, 0x42, 0x81, 0x73, 0x87, 0x8B, 0x25, 0xC9, 0x71, 0xC0, 0xA4, 0x66, 0x0B, 0x29, 0x30,
  0xD0, 0xA3, 0x5B, 0x05, 0xC9, 0x93, 0x00, 0x63, 0x84, 0xB1, 0x0C, 0xC7, 0x20,
  // "Ğ" (U+011E)
  0x38, 0x15, 0x05, 0x38, 0x15, 0xB4, 0x71, 0x85, 0x7B, 0xC5, 0x07, 0x84, 0x0C, 0x40, 0x40, 0x94,
  0x86, 0x66, 0x0A, 0xD0, 0x75, 0x28, 0x5B, 0x05, 0x80, 0x38, 0x28, 0x2A, 0xBB, 0x41,
  // "ğ" (U+011F)
  0x18, 0x15, 0x05, 0x28, 0x15, 0xB4, 0x78, 0xB2, 0x5C, 0x97, 0x1C, 0x0A, 0x46, 0x60, 0xB2, 0x93,
  0x0D, 0x0A, 0x35, 0xB0, 0x5C, 0x99, 0x30, 0x06, 0x38, 0x4B, 0x10, 0xCC, 0x72,
  // "Ġ" (U+0120)
  0x30, 0x60, 0x17, 0x28, 0x57, 0xBC, 0x50, 0x78, 0x40, 0xC4, 0x04, 0x09, 0x48, 0x66, 0x60, 0xAD,
  0x07, 0x52, 0x85, 0xB0, 0x58, 0x03, 0x82, 0x82, 0xAB, 0xB4, 0x10,
  // "ġ" (U+0121)
  0x20, 0x60, 0x17, 0x8B, 0x25, 0xC9, 0x71, 0xC0, 0xA4, 0x66, 0x0B, 0x29, 0x30, 0xD0, 0xA3, 0x5B,
  0x05, 0xC9, 0x93, 0x00, 0x63, 0x84, 0xB1, 0x0C, 0xC7, 0x20,
  // "Ģ" (U+0122)
  0x28, 0x57, 0xBC, 0x50, 0x78, 0x40, 0xC4, 0x04, 0x09, 0x48, 0x66, 0x60, 0xAD, 0x07, 0x52, 0x85,
  0xB0, 0x58, 0x03, 0x82, 0x82, 0xAB, 0xB4, 0x30, 0xA0, 0x13, 0x01, 0x08, 0x30,
  // "ģ" (U+0123)
  0x00, 0x19, 0x00, 0x03, 0x20, 0x05, 0xC9, 0x71, 0xC0, 0xA4, 0x66, 0x0B, 0x29, 0x30, 0xD0, 0xA3,
  0x5B, 0x05, 0xC9, 0x90, 0x00, 0x66, 0x00, 0x0B, 0x10, 0xCC, 0x70, 0x00,
  // "Ĥ" (U+0124)
  0x00, 0x0D, 0x40, 0x00, 0x73, 0x80, 0x00, 0x00, 0x00, 0x07, 0x50, 0x57, 0x0A, 0x20, 0x84, 0x0B,
  0x00, 0xB1, 0x0E, 0xCC, 0xE0, 0x38, 0x02, 0xB0, 0x65, 0x05, 0x80, 0x93, 0x07, 0x50, 0xC0, 0x0A,
  0x20,
  // "ĥ" (U+0125)
  0x20, 0xD0, 0x42, 0x81, 0x73, 0x87, 0x06, 0x05, 0x30, 0x90, 0x23, 0x8B, 0x2B, 0x9D, 0x10, 0xD0,
  0x93, 0x39, 0x0B, 0x16, 0x50, 0xC0, 0x92, 0x1A, 0x0C, 0x04, 0x71,
  // "Ħ" (U+0126)
  0x07, 0x50, 0x57, 0x4E, 0xBB, 0xDC, 0x0C, 0x00, 0xB1, 0x1E, 0xBB, 0xD0, 0x38, 0x02, 0xA0, 0x65,
  0x05, 0x80, 0x93, 0x07, 0x50, 0xC0, 0x0A, 0x20,
  // "ħ" (U+0127)
  0x2D, 0xB4, 0x00, 0xB0, 0x00, 0x0D, 0x9D, 0x11, 0xE0, 0x93, 0x48, 0x0B, 0x17, 0x50, 0xC0, 0xA2,
  0x1A, 0x0C, 0x04, 0x70,
  // "Ĩ" (U+0128)
  0x28, 0x25, 0xA6, 0x22, 0x81, 0x73, 0xB7, 0x28, 0x1B, 0xD3, 0x30, 0x06, 0x40, 0x90, 0x34, 0x0C,
  0x50, 0xC4, 0x02, 0x0A, 0x40, 0x50, 0x73, 0x81, 0x3C, 0xB3,
  // "ĩ" (U+0129)
  0x5A, 0x62, 0x73, 0xB0, 0x00, 0x00, 0x0C, 0x00, 0x1B, 0x00, 0x48, 0x00, 0x75, 0x00, 0x92, 0x00,
  0xC0, 0x00,
  // "Ī" (U+012A)
  0x28, 0x19, 0xB7, 0x78, 0x1B, 0xD3, 0x20, 0x06, 0x30, 0x90, 0x33, 0x0C, 0x40, 0xC3, 0x02, 0x0A,
  0x30, 0x50, 0x72, 0x81, 0x3C, 0xB2,
  // "ī" (U+012B)
  0x9B, 0x70, 0x00, 0x0C, 0x01, 0xB0, 0x48, 0x07, 0x50, 0x92, 0x0C, 0x00,
  // "Ĭ" (U+012C)
  0x28, 0x15, 0x05, 0x28, 0x15, 0xB4, 0x78, 0x1B, 0xD3, 0x20, 0x06, 0x30, 0x90, 0x33, 0x0C, 0x40,
  0xC3, 0x02, 0x0A, 0x30, 0x50, 0x72, 0x81, 0x3C, 0xB2,
  // "ĭ" (U+012D)
  0x50, 0x55, 0xB4, 0x00, 0x00, 0xC0, 0x1B, 0x04, 0x80, 0x75, 0x09, 0x20, 0xC0, 0x00,
  // "Į" (U+012E)
  0x28, 0x1B, 0xD3, 0x20, 0x06, 0x30, 0x90, 0x33, 0x0C, 0x40, 0xC3, 0x02, 0x0A, 0x30, 0x50, 0x72,
  0x81, 0x3C, 0xB3, 0x05, 0x30, 0x40, 0x53, 0x03, 0x0A, 0x30,
  // "į" (U+012F)
  0x00, 0x43, 0x00, 0x00, 0x00, 0xC0, 0x01, 0xB0, 0x04, 0x80, 0x07, 0x50, 0x09, 0x20, 0x0C, 0x00,
  0x05, 0x00, 0x45, 0x00, 0x3A, 0x00,
  // "İ" (U+0130)
  0x30, 0x60, 0x17, 0x81, 0xBD, 0x32, 0x00, 0x63, 0x09, 0x03, 0x30, 0xC4, 0x0C, 0x30, 0x20, 0xA3,
  0x05, 0x07, 0x28, 0x13, 0xCB, 0x20,
  // "ı" (U+0131)
  0x0C, 0x1B, 0x48, 0x75, 0x92, 0xC0,
  // "Ĳ" (U+0132)
  0x00, 0xBD, 0x37, 0x50, 0x06, 0x60, 0xA2, 0x00, 0x93, 0x0C, 0x00, 0x0C, 0x00, 0xC0, 0x00, 0xC0,
  0x39, 0x00, 0x2A, 0x06, 0x60, 0x05, 0x70, 0x93, 0x03, 0xCB, 0x0C, 0x00, 0x00, 0x01, 0xB0, 0x00,
  0x05, 0xB3, 0x00,
  // "ĳ" (U+0133)
  0x18, 0x24, 0x34, 0x36, 0x8B, 0x1C, 0x0C, 0x01, 0xB0, 0xB0, 0x48, 0x38, 0x07, 0x56, 0x50, 0x92,
  0x93, 0x0C, 0x0B, 0x40, 0xC3, 0x02, 0x09, 0x28, 0x13, 0xC2, 0x20,
  // "Ĵ" (U+0134)
  0x40, 0xD0, 0x43, 0x81, 0x73, 0x87, 0x20, 0x70, 0x54, 0x0A, 0x02, 0x40, 0xC5, 0x0C, 0x40, 0x30,
  0x94, 0x00, 0x64, 0x09, 0x03, 0x40, 0xC4, 0x01, 0x0B, 0x38, 0x15, 0xB3, 0x30,
  // "ĵ" (U+0135)
  0x30, 0xD0, 0x42, 0x81, 0x73, 0x87, 0x10, 0xC4, 0x0B, 0x30, 0x30, 0x83, 0x06, 0x05, 0x30, 0x90,
  0x33, 0x0B, 0x40, 0xC3, 0x02, 0x09, 0x28, 0x13, 0xC2, 0x20,
  // "Ķ" (U+0136)
  0x07, 0x50, 0xC1, 0x0A, 0x29, 0x50, 0x0C, 0x59, 0x00, 0x0D, 0xD0, 0x00, 0x3D, 0xD1, 0x00, 0x66,
  0x84, 0x00, 0x93, 0x58, 0x00, 0xC0, 0x1C, 0x00, 0x0A, 0x10, 0x00, 0x18, 0x00, 0x00,
  // "ķ" (U+0137)
  0x06, 0x60, 0x00, 0x92, 0x00, 0x0B, 0x0B, 0x10, 0xB8, 0x40, 0x3C, 0xB0, 0x06, 0x9C, 0x00, 0x92,
  0xB1, 0x0C, 0x08, 0x40, 0x0A, 0x10, 0x01, 0x80, 0x00,
  // "ĸ" (U+0138)
  0x0C, 0x0B, 0x10, 0xB8, 0x40, 0x3C, 0xB0, 0x06, 0x9C, 0x00, 0x92, 0xB1, 0x0C, 0x08, 0x40,
  // "Ĺ" (U+0139)
  0x00, 0x1C, 0x00, 0x82, 0x00, 0x00, 0x07, 0x50, 0x0A, 0x20, 0x0C, 0x00, 0x0C, 0x00, 0x39, 0x00,
  0x66, 0x00, 0x93, 0x00, 0xCC, 0xC0,
  // "ĺ" (U+013A)
  0x00, 0x1C, 0x00, 0x82, 0x00, 0x00, 0x06, 0x60, 0x09, 0x30, 0x0C, 0x00, 0x0B, 0x00, 0x39, 0x00,
  0x65, 0x00, 0x92, 0x00, 0xC0, 0x00,
  // "Ļ" (U+013B)
  0x07, 0x50, 0xA2, 0x0C, 0x00, 0xC0, 0x39, 0x06, 0x60, 0x93, 0x0C, 0xCC, 0x0A, 0x11, 0x80,
  // "ļ" (U+013C)
  0x00, 0x66, 0x00, 0x93, 0x00, 0xC0, 0x00, 0xB0, 0x03, 0x90, 0x06, 0x50, 0x09, 0x20, 0x0C, 0x00,
  0x0A, 0x10, 0x18, 0x00,
  // "Ľ" (U+013D)
  0x18, 0x67, 0x59, 0x20, 0xA2, 0x72, 0x0C, 0x40, 0xC3, 0x03, 0x09, 0x30, 0x06, 0x30, 0x90, 0x33,
  0x0F, 0xC2,
  // "ľ" (U+013E)
  0x06, 0x6B, 0x09, 0x63, 0x0C, 0x00, 0x0B, 0x00, 0x39, 0x00, 0x65, 0x00, 0x92, 0x00, 0xC0, 0x00,
  // "Ŀ" (U+013F)
  0x07, 0x50, 0x0A, 0x20, 0x0C, 0x00, 0x0C, 0x61, 0x39, 0x00, 0x66, 0x00, 0x93, 0x00, 0xCC, 0xC0,
  // "ŀ" (U+0140)
  0x06, 0x60, 0x09, 0x30, 0x0C, 0x00, 0x0B, 0x61, 0x39, 0x00, 0x65, 0x00, 0x92, 0x00, 0xC0, 0x00,
  // "Ł" (U+0141)
  0x06, 0x60, 0x09, 0x30, 0x0C, 0x10, 0x0E, 0xB0, 0x9B, 0x00, 0x87, 0x00, 0x84, 0x00, 0xBC, 0xC1,
  // "ł" (U+0142)
  0x05, 0x60, 0x83, 0x0B, 0x00, 0xE7, 0xAA, 0x05, 0x60, 0x83, 0x0B, 0x00,
  // "Ń" (U+0143)
  0x30, 0x10, 0xC4, 0x08, 0x02, 0x71, 0x07, 0x0A, 0x28, 0xC4, 0xB0, 0xAC, 0x03, 0x90, 0xCA, 0x15,
  0x60, 0xB7, 0x48, 0x33, 0x84, 0x7B, 0x06, 0x51, 0xAC, 0x09, 0x30, 0xCA, 0x0B, 0x20, 0xA0, 0x71,
  // "ń" (U+0144)
  0x20, 0x10, 0xC3, 0x08, 0x02, 0x78, 0xB2, 0xB9, 0xD1, 0x1E, 0x19, 0x34, 0x90, 0xB1, 0x75, 0x0C,
  0x0A, 0x22, 0xA0, 0xC0, 0x57, 0x10,
  // "Ņ" (U+0145)
  0x07, 0xA0, 0x0B, 0x0A, 0xC0, 0x39, 0x0C, 0xA1, 0x56, 0x0B, 0x74, 0x83, 0x38, 0x47, 0xB0, 0x65,
  0x1A, 0xC0, 0x93, 0x0C, 0xA0, 0xB0, 0x0A, 0x70, 0x00, 0xA1, 0x00, 0x01, 0x80, 0x00,
  // "ņ" (U+0146)
  0x0B, 0x9D, 0x11, 0xE1, 0x93, 0x49, 0x0B, 0x17, 0x50, 0xC0, 0xA2, 0x2A, 0x0C, 0x05, 0x70, 0x0A,
  0x10, 0x01, 0x80, 0x00,
  // "Ň" (U+0147)
  0x00, 0x64, 0x90, 0x00, 0x1E, 0x20, 0x00, 0x00, 0x00, 0x07, 0xA0, 0x0B, 0x0A, 0xC0, 0x39, 0x0C,
  0xA1, 0x56, 0x0B, 0x74, 0x83, 0x38, 0x47, 0xB0, 0x65, 0x1A, 0xC0, 0x93, 0x0C, 0xA0, 0xB0, 0x0A,
  0x70,
  // "ň" (U+0148)
  0x06, 0x49, 0x00, 0x1E, 0x20, 0x00, 0x00, 0x00, 0xB9, 0xD1, 0x1E, 0x19, 0x34, 0x90, 0xB1, 0x75,
  0x0C, 0x0A, 0x22, 0xA0, 0xC0, 0x57, 0x00,
  // "ŉ" (U+0149)
  0x0A, 0x30, 0x00, 0x1A, 0x00, 0x00, 0x22, 0xB9, 0xD1, 0x01, 0xE1, 0x93, 0x04, 0x90, 0xB1, 0x07,
  0x50, 0xC0, 0x0A, 0x22, 0xA0, 0x0C, 0x05, 0x70,
  // "Ŋ" (U+014A)
  0x07, 0xA0, 0x0C, 0x0A, 0xC0, 0x39, 0x0C, 0xA1, 0x66, 0x0B, 0x64, 0x83, 0x38, 0x38, 0xB0, 0x65,
  0x0B, 0xB0, 0x92, 0x0C, 0x90, 0xB0, 0x09, 0x60, 0x00, 0x09, 0x20, 0x00, 0xB8, 0x00,
  // "ŋ" (U+014B)
  0x0B, 0x9D, 0x11, 0xE1, 0x93, 0x49, 0x0B, 0x17, 0x50, 0xC0, 0x92, 0x1B, 0x0C, 0x04, 0x80, 0x00,
  0x75, 0x00, 0x0A, 0x10, 0x09, 0xA0, 0x00,
  // "Ō" (U+014C)
  0x00, 0x9B, 0x70, 0x00, 0x00, 0x00, 0x00, 0x9B, 0xA0, 0x08, 0x60, 0x94, 0x0C, 0x00, 0x66, 0x49,
  0x00, 0x75, 0x76, 0x00, 0xA2, 0x85, 0x00, 0xC0, 0x67, 0x07, 0x60, 0x0B, 0xB8, 0x00,
  // "ō" (U+014D)
  0x09, 0xB7, 0x00, 0x00, 0x00, 0x06, 0xCA, 0x02, 0xB0, 0xA2, 0x75, 0x0A, 0x29, 0x20, 0xC0, 0x93,
  0x39, 0x03, 0xCB, 0x10,
  // "Ŏ" (U+014E)
  0x00, 0x50, 0x50, 0x00, 0x5B, 0x40, 0x00, 0x00, 0x00, 0x00, 0x9B, 0xA0, 0x08, 0x60, 0x94, 0x0C,
  0x00, 0x66, 0x49, 0x00, 0x75, 0x76, 0x00, 0xA2, 0x85, 0x00, 0xC0, 0x67, 0x07, 0x60, 0x0B, 0xB8,
  0x00,
  // "ŏ" (U+014F)
  0x05, 0x05, 0x00, 0x5B, 0x40, 0x00, 0x00, 0x00, 0x6C, 0xA0, 0x2B, 0x0A, 0x27, 0x50, 0xA2, 0x92,
  0x0C, 0x09, 0x33, 0x90, 0x3C, 0xB1, 0x00,
  // "Ő" (U+0150)
  0x00, 0x1A, 0x65, 0x00, 0x74, 0x80, 0x00, 0x00, 0x00, 0x00, 0x9B, 0xA0, 0x08, 0x60, 0x94, 0x0C,
  0x00, 0x66, 0x49, 0x00, 0x75, 0x76, 0x00, 0xA2, 0x85, 0x00, 0xC0, 0x67, 0x07, 0x60, 0x0B, 0xB8,
  0x00,
  // "ő" (U+0151)
  0x00, 0x1A, 0x65, 0x00, 0x74, 0x80, 0x00, 0x00, 0x00, 0x06, 0xCA, 0x00, 0x2B, 0x0A, 0x20, 0x75,
  0x0A, 0x20, 0x92, 0x0C, 0x00, 0x93, 0x39, 0x00, 0x3C, 0xB1, 0x00,
  // "Œ" (U+0152)
  0x00, 0x9B, 0xEB, 0xB0, 0x86, 0x1A, 0x00, 0x0C, 0x04, 0x70, 0x04, 0x90, 0x7C, 0xB2, 0x76, 0x0A,
  0x10, 0x08, 0x50, 0xC0, 0x00, 0x67, 0x0B, 0x00, 0x00, 0xBC, 0xEB, 0x70,
  // "œ" (U+0153)
  0x06, 0xC9, 0x6C, 0x81, 0xB0, 0x97, 0x2A, 0x75, 0x0A, 0xB9, 0x19, 0x20, 0xD0, 0x00, 0x92, 0x3E,
  0x10, 0x03, 0xCA, 0x4C, 0xB0,
  // "Ŕ" (U+0154)
  0x30, 0x10, 0xC3, 0x08, 0x02, 0x68, 0xC4, 0x7C, 0xC2, 0x0A, 0x24, 0x90, 0xC0, 0x49, 0x0C, 0x0A,
  0x43, 0xED, 0x70, 0x67, 0x84, 0x09, 0x35, 0x80, 0xC0, 0x1C, 0x10,
  // "ŕ" (U+0155)
  0x00, 0x1C, 0x00, 0x82, 0x00, 0x00, 0x0A, 0x95, 0x1E, 0x10, 0x48, 0x00, 0x75, 0x00, 0x92, 0x00,
  0xC0, 0x00,
  // "Ŗ" (U+0156)
  0x07, 0xCC, 0x20, 0xA2, 0x49, 0x0C, 0x04, 0x90, 0xC0, 0xA4, 0x3E, 0xD7, 0x06, 0x78, 0x40, 0x93,
  0x58, 0x0C, 0x01, 0xC0, 0x0A, 0x10, 0x01, 0x80, 0x00,
  // "ŗ" (U+0157)
  0x00, 0xA9, 0x50, 0x1E, 0x10, 0x04, 0x80, 0x00, 0x75, 0x00, 0x09, 0x20, 0x00, 0xC0, 0x00, 0x0A,
  0x10, 0x01, 0x80, 0x00,
  // "Ř" (U+0158)
  0x00, 0x64, 0x90, 0x01, 0xE2, 0x00, 0x00, 0x00, 0x7C, 0xC2, 0x0A, 0x24, 0x90, 0xC0, 0x49, 0x0C,
  0x0A, 0x43, 0xED, 0x70, 0x67, 0x84, 0x09, 0x35, 0x80, 0xC0, 0x1C, 0x00,
  // "ř" (U+0159)
  0x06, 0x49, 0x01, 0xE2, 0x00, 0x00, 0x0A, 0x95, 0x1E, 0x10, 0x48, 0x00, 0x75, 0x00, 0x92, 0x00,
  0xC0, 0x00,
  // "Ś" (U+015A)
  0x20, 0x10, 0xC3, 0x08, 0x02, 0x78, 0x45, 0xCC, 0x30, 0xC3, 0x01, 0x0C, 0x40, 0xB0, 0x73, 0x81,
  0x1D, 0x43, 0x05, 0x08, 0x38, 0x47, 0x60, 0xCB, 0xA2,
  // "ś" (U+015B)
  0x00, 0x1C, 0x00, 0x82, 0x00, 0x00, 0x1B, 0xC4, 0x57, 0x00, 0x2C, 0x10, 0x05, 0xA0, 0x00, 0xD0,
  0xCC, 0x50,
  // "Ŝ" (U+015C)
  0x30, 0xD0, 0x42, 0x81, 0x73, 0x86, 0x84, 0x5C, 0xC3, 0x0C, 0x30, 0x10, 0xC4, 0x0B, 0x07, 0x38,
  0x11, 0xD4, 0x30, 0x50, 0x83, 0x84, 0x76, 0x0C, 0xBA, 0x20,
  // "ŝ" (U+015D)
  0x00, 0xD4, 0x07, 0x38, 0x00, 0x00, 0x1B, 0xC4, 0x57, 0x00, 0x2C, 0x10, 0x05, 0xA0, 0x00, 0xD0,
  0xCC, 0x50,
  // "Ş" (U+015E)
  0x18, 0x45, 0xCC, 0x30, 0xC3, 0x01, 0x0C, 0x40, 0xB0, 0x73, 0x81, 0x1D, 0x43, 0x05, 0x08, 0x38,
  0x47, 0x60, 0xCB, 0xA3, 0x05, 0x40, 0xB3, 0x07, 0x08, 0x30,
  // "ş" (U+015F)
  0x1B, 0xC4, 0x57, 0x00, 0x2C, 0x10, 0x05, 0xA0, 0x00, 0xD0, 0xCC, 0x50, 0x05, 0x00, 0x0B, 0x00,
  0x78, 0x00,
  // "Š" (U+0160)
  0x28, 0x16, 0x49, 0x28, 0x11, 0xE2, 0x68, 0x45, 0xCC, 0x30, 0xC3, 0x01, 0x0C, 0x40, 0xB0, 0x73,
  0x81, 0x1D, 0x43, 0x05, 0x08, 0x38, 0x47, 0x60, 0xCB, 0xA2,
  // "š" (U+0161)
  0x06, 0x49, 0x01, 0xE2, 0x00, 0x00, 0x1B, 0xC4, 0x57, 0x00, 0x2C, 0x10, 0x05, 0xA0, 0x00, 0xD0,
  0xCC, 0x50,
  // "Ţ" (U+0162)
  0x83, 0x1B, 0xEB, 0x72, 0x0C, 0x40, 0xC3, 0x03, 0x09, 0x30, 0x06, 0x30, 0x90, 0x33, 0x0C, 0x40,
  0xC4, 0x05, 0x40, 0xB3, 0x07, 0x08, 0x30,
  // "ţ" (U+0163)
  0x02, 0x10, 0x91, 0x4E, 0xA0, 0xB0, 0x38, 0x06, 0x50, 0x93, 0x07, 0xC0, 0x05, 0x00, 0xB0, 0x78,
  0x00,
  // "Ť" (U+0164)
  0x18, 0x16, 0x49, 0x28, 0x11, 0xE2, 0x68, 0x31, 0xBE, 0xB7, 0x20, 0xC4, 0x0C, 0x30, 0x30, 0x93,
  0x00, 0x63, 0x09, 0x03, 0x30, 0xC4, 0x0C, 0x30,
  // "ť" (U+0165)
  0x00, 0x1A, 0x07, 0x51, 0x3E, 0xA0, 0x0B, 0x00, 0x38, 0x00, 0x65, 0x00, 0x93, 0x00, 0x7C, 0x00,
  // "Ŧ" (U+0166)
  0x1B, 0xEB, 0x70, 0x0C, 0x00, 0x01, 0xB0, 0x03, 0xCD, 0x60, 0x07, 0x50, 0x00, 0xA2, 0x00, 0x0C,
  0x00, 0x00, 0xC0, 0x00,
  // "ŧ" (U+0167)
  0x02, 0x10, 0x91, 0x4E, 0xA1, 0xB0, 0xAD, 0x56, 0x50, 0x92, 0x07, 0xC0,
  // "Ũ" (U+0168)
  0x00, 0x5A, 0x62, 0x00, 0x73, 0xB0, 0x00, 0x00, 0x00, 0x08, 0x40, 0x56, 0x0B, 0x10, 0x83, 0x0C,
  0x00, 0xB1, 0x1B, 0x00, 0xC0, 0x48, 0x02, 0xA0, 0x75, 0x05, 0x70, 0x75, 0x0B, 0x20, 0x2C, 0xC7,
  0x00,
  // "ũ" (U+0169)
  0x18, 0x65, 0xA6, 0x20, 0x73, 0xB7, 0x8B, 0x2C, 0x06, 0x61, 0xB0, 0x93, 0x47, 0x0B, 0x07, 0x50,
  0xC0, 0x93, 0x6A, 0x06, 0xC9, 0x71,
  // "Ū" (U+016A)
  0x00, 0x9B, 0x70, 0x00, 0x00, 0x00, 0x08, 0x40, 0x56, 0x0B, 0x10, 0x83, 0x0C, 0x00, 0xB1, 0x1B,
  0x00, 0xC0, 0x48, 0x02, 0xA0, 0x75, 0x05, 0x70, 0x75, 0x0B, 0x20, 0x2C, 0xC7, 0x00,
  // "ū" (U+016B)
  0x00, 0x9B, 0x70, 0x00, 0x00, 0x0C, 0x06, 0x61, 0xB0, 0x93, 0x47, 0x0B, 0x07, 0x50, 0xC0, 0x93,
  0x6A, 0x06, 0xC9, 0x70,
  // "Ŭ" (U+016C)
  0x00, 0x50, 0x50, 0x00, 0x5B, 0x40, 0x00, 0x00, 0x00, 0x08, 0x40, 0x56, 0x0B, 0x10, 0x83, 0x0C,
  0x00, 0xB1, 0x1B, 0x00, 0xC0, 0x48, 0x02, 0xA0, 0x75, 0x05, 0x70, 0x75, 0x0B, 0x20, 0x2C, 0xC7,
  0x00,
  // "ŭ" (U+016D)
  0x00, 0x50, 0x50, 0x05, 0xB4, 0x00, 0x00, 0x00, 0xC0, 0x66, 0x1B, 0x09, 0x34, 0x70, 0xB0, 0x75,
  0x0C, 0x09, 0x36, 0xA0, 0x6C, 0x97, 0x00,
  // "Ů" (U+016E)
  0x00, 0x39, 0x10, 0x00, 0x81, 0x60, 0x00, 0x39, 0x10, 0x08, 0x40, 0x56, 0x0B, 0x10, 0x83, 0x0C,
  0x00, 0xB1, 0x1B, 0x00, 0xC0, 0x48, 0x02, 0xA0, 0x75, 0x05, 0x70, 0x75, 0x0B, 0x20, 0x2C, 0xC7,
  0x00,
  // "ů" (U+016F)
  0x00, 0x39, 0x10, 0x08, 0x16, 0x00, 0x39, 0x10, 0xC0, 0x66, 0x1B, 0x09, 0x34, 0x70, 0xB0, 0x75,
  0x0C, 0x09, 0x36, 0xA0, 0x6C, 0x97, 0x00,
  // "Ű" (U+0170)
  0x00, 0x1A, 0x65, 0x00, 0x74, 0x80, 0x00, 0x00, 0x00, 0x08, 0x40, 0x56, 0x0B, 0x10, 0x83, 0x0C,
  0x00, 0xB1, 0x1B, 0x00, 0xC0, 0x48, 0x02, 0xA0, 0x75, 0x05, 0x70, 0x75, 0x0B, 0x20, 0x2C, 0xC7,
  0x00,
  // "ű" (U+0171)
  0x00, 0x1A, 0x65, 0x00, 0x74, 0x80, 0x00, 0x00, 0x00, 0x0C, 0x06, 0x60, 0x1B, 0x09, 0x30, 0x47,
  0x0B, 0x00, 0x75, 0x0C, 0x00, 0x93, 0x6A, 0x00, 0x6C, 0x97, 0x00,
  // "Ų" (U+0172)
  0x08, 0x40, 0x56, 0x0B, 0x10, 0x83, 0x0C, 0x00, 0xB1, 0x1B, 0x00, 0xC0, 0x48, 0x02, 0xA0, 0x75,
  0x05, 0x70, 0x75, 0x0B, 0x20, 0x2C, 0xC7, 0x00, 0x00, 0x50, 0x00, 0x04, 0x50, 0x00, 0x03, 0xA0,
  0x00,
  // "ų" (U+0173)
  0x0C, 0x06, 0x61, 0xB0, 0x93, 0x47, 0x0B, 0x07, 0x50, 0xC0, 0x93, 0x6A, 0x06, 0xC9, 0x70, 0x00,
  0x50, 0x00, 0x45, 0x00, 0x03, 0xA0, 0x00,
  // "Ŵ" (U+0174)
  0x40, 0xD0, 0x45, 0x81, 0x73, 0x87, 0x38, 0xD4, 0x1B, 0x02, 0xC0, 0x1B, 0x1B, 0x07, 0xC0, 0x66,
  0x1B, 0x0B, 0xA0, 0xB0, 0x1A, 0x37, 0xA2, 0xA0, 0x1A, 0x91, 0xA8, 0x40, 0x1A, 0xA0, 0xAB, 0x28,
  0x41, 0xE6, 0x0D, 0x82, 0x01, 0x92, 0x0E, 0x02, 0x20,
  // "ŵ" (U+0175)
  0x30, 0xD0, 0x44, 0x81, 0x73, 0x87, 0x28, 0xB7, 0x66, 0x2E, 0x09, 0x36, 0x57, 0xC0, 0xC0, 0x65,
  0xAA, 0x47, 0x06, 0x97, 0xAA, 0x10, 0x6D, 0x1A, 0xA2, 0x83, 0x6B, 0x0C, 0x52,
  // "Ŷ" (U+0176)
  0x0D, 0x40, 0x73, 0x80, 0x00, 0x00, 0xB0, 0x3A, 0xC0, 0xB2, 0xC3, 0x90, 0xAC, 0x20, 0x89, 0x00,
  0x84, 0x00, 0xB1, 0x00, 0xC0, 0x00,
  // "ŷ" (U+0177)
  0x30, 0xD0, 0x43, 0x81, 0x73, 0x87, 0x18, 0x90, 0x56, 0x0B, 0x10, 0x57, 0x2A, 0x28, 0x24, 0x78,
  0x42, 0x81, 0x38, 0xB3, 0x81, 0x2C, 0x73, 0x81, 0x1F, 0x13, 0x02, 0x0A, 0x40, 0x90, 0x33, 0x0A,
  0x09, 0x40,
  // "Ÿ" (U+0178)
  0x06, 0x42, 0x00, 0x00, 0xB0, 0x3A, 0xC0, 0xB2, 0xC3, 0x90, 0xAC, 0x20, 0x89, 0x00, 0x84, 0x00,
  0xB1, 0x00, 0xC0, 0x00,
  // "Ź" (U+0179)
  0x30, 0x10, 0xC4, 0x08, 0x02, 0x72, 0x82, 0x9B, 0xE6, 0x30, 0x10, 0xD4, 0x08, 0x06, 0x30, 0x20,
  0xC4, 0x0A, 0x04, 0x30, 0x30, 0xB4, 0x0B, 0x03, 0x38, 0x33, 0xEB, 0xB1, 0x10,
  // "ź" (U+017A)
  0x30, 0x10, 0xC3, 0x08, 0x02, 0x68, 0x21, 0xBD, 0x63, 0x0B, 0x30, 0x80, 0x52, 0x02, 0x0B, 0x30,
  0xA0, 0x32, 0x82, 0x2E, 0xB6, 0x10,
  // "Ż" (U+017B)
  0x30, 0x60, 0x17, 0x28, 0x29, 0xBE, 0x63, 0x01, 0x0D, 0x40, 0x80, 0x63, 0x02, 0x0C, 0x40, 0xA0,
  0x43, 0x03, 0x0B, 0x40, 0xB0, 0x33, 0x83, 0x3E, 0xBB, 0x11,
  // "ż" (U+017C)
  0x30, 0x60, 0x16, 0x82, 0x1B, 0xD6, 0x30, 0xB3, 0x08, 0x05, 0x20, 0x20, 0xB3, 0x0A, 0x03, 0x28,
  0x22, 0xEB, 0x61,
  // "Ž" (U+017D)
  0x28, 0x16, 0x49, 0x38, 0x11, 0xE2, 0x72, 0x82, 0x9B, 0xE6, 0x30, 0x10, 0xD4, 0x08, 0x06, 0x30,
  0x20, 0xC4, 0x0A, 0x04, 0x30, 0x30, 0xB4, 0x0B, 0x03, 0x38, 0x33, 0xEB, 0xB1, 0x10,
  // "ž" (U+017E)
  0x00, 0x64, 0x90, 0x01, 0xE2, 0x00, 0x00, 0x00, 0x1B, 0xD6, 0x00, 0x0B, 0x00, 0x08, 0x50, 0x02,
  0xB0, 0x00, 0xA3, 0x00, 0x2E, 0xB6, 0x00,
  // "ſ" (U+017F)
  0x38, 0x12, 0xC6, 0x30, 0x80, 0x44, 0x0C, 0x50, 0xC4, 0x02, 0x09, 0x40, 0x50, 0x64, 0x08, 0x03,
  0x40, 0xB5, 0x0C, 0x40, 0x20, 0x93, 0x81, 0x3C, 0x23,
  // "Ω" (U+03A9)
  0x00, 0x0A, 0xBA, 0x00, 0x09, 0x50, 0x85, 0x00, 0xC0, 0x06, 0x70, 0x48, 0x00, 0x75, 0x06, 0x60,
  0x0B, 0x20, 0x56, 0x01, 0xB0, 0x02, 0x90, 0x93, 0x02, 0xBD, 0x5E, 0xA0,
  // "μ" (U+03BC)
  0x00, 0xC0, 0x56, 0x01, 0xB0, 0x83, 0x03, 0x80, 0xB0, 0x06, 0x50, 0xC0, 0x09, 0x35, 0xA0, 0x0B,
  0xB9, 0x70, 0x0B, 0x00, 0x00, 0x29, 0x00, 0x00, 0x56, 0x00, 0x00,
  // "π" (U+03C0)
  0x4E, 0xBE, 0xC0, 0xC0, 0xB1, 0x1A, 0x0C, 0x04, 0x71, 0xA0, 0x74, 0x47, 0x0A, 0x13, 0xC0,
  // "–" (U+2013)
  0x7B, 0xBB, 0x20,
  // "—" (U+2014)
  0x07, 0x80, 0x3B, 0x09,
  // "€" (U+20AC)
  0x00, 0x7C, 0xA0, 0x3A, 0x00, 0x0A, 0x20, 0x06, 0xEB, 0x60, 0xAD, 0xB0, 0x03, 0x90, 0x00, 0x1B,
  0x00, 0x00, 0x8C, 0x70,
  // "₿" (U+20BF)
  0x00, 0x77, 0x00, 0x7D, 0xD1, 0x0A, 0x27, 0x60, 0xC0, 0xA3, 0x0E, 0xD7, 0x03, 0x81, 0xC0, 0x66,
  0x0D, 0x09, 0x34, 0x90, 0xCC, 0xA1, 0x04, 0x72, 0x00,
  // "‘" (U+2018)
  0x07, 0x21, 0xB0, 0x23, 0x00,
  // "’" (U+2019)
  0x0A, 0x31, 0xA0, 0x22, 0x00,
  // "‚" (U+201A)
  0x04, 0x20, 0xC0, 0x46, 0x00,
  // "‛" (U+201B)
  0xCB, 0x80,
  // "“" (U+201C)
  0x07, 0x3A, 0x0C, 0x47, 0x37, 0x83,
  // "”" (U+201D)
  0x0A, 0x3C, 0x0B, 0x56, 0x34, 0x80,
  // "„" (U+201E)
  0x0A, 0x39, 0x1A, 0x65, 0x63, 0xA0,
  // "‟" (U+201F)
  0xD6, 0x6B, 0x56, 0x82, 0x60,
  // "†" (U+2020)
  0x06, 0x50, 0x08, 0x10, 0xAC, 0xA2, 0x08, 0x00, 0x27, 0x00, 0x64, 0x00, 0xA2, 0x00, 0xD0, 0x00,
  // "‡" (U+2021)
  0x00, 0x65, 0x00, 0x08, 0x10, 0x09, 0xC9, 0x20, 0x0A, 0x00, 0x03, 0x70, 0x06, 0xAA, 0x50, 0x18,
  0x10, 0x00, 0xC0, 0x00,
  // "•" (U+2022)
  0x0B, 0xA0, 0x3F, 0xF1, 0x0D, 0xC0,
  // "…" (U+2026)
  0x71, 0x71, 0x71,
  // "‰" (U+2030)
  0x07, 0xC1, 0x18, 0x00, 0x00, 0x19, 0x63, 0x81, 0x00, 0x00, 0x55, 0x83, 0x80, 0x00, 0x00, 0x64,
  0xA9, 0x6B, 0x17, 0xB0, 0x2B, 0x68, 0xA6, 0x68, 0x81, 0x00, 0x94, 0x67, 0x83, 0x90, 0x03, 0x75,
  0x4A, 0x82, 0x90, 0x0A, 0x02, 0xC5, 0x4C, 0x30,
  // "‹" (U+2039)
  0x02, 0x31, 0xB0, 0x85, 0x02, 0x90, 0x03, 0x00,
  // "›" (U+203A)
  0x23, 0x00, 0xB0, 0x0C, 0x18, 0x40, 0x20, 0x00,
  // "⁄" (U+2044)
  0x50, 0x60, 0x44, 0x01, 0x08, 0x50, 0x90, 0x14, 0x00, 0x54, 0x01, 0x09, 0x50, 0x90, 0x14, 0x00,
  0x54, 0x01, 0x09, 0x50,
  // "™" (U+2122)
  0x6A, 0x68, 0x08, 0x10, 0x82, 0xC1, 0xC1, 0x08, 0x27, 0xA7, 0x10, 0x62, 0x37, 0x41,
  // "⅒" (U+2152)
  0x00, 0x50, 0x06, 0x40, 0x00, 0x6C, 0x01, 0x80, 0x00, 0x00, 0xA0, 0x91, 0x00, 0x00, 0x18, 0x55,
  0x54, 0xA3, 0x04, 0x69, 0x6C, 0xA2, 0x80, 0x09, 0x10, 0xC8, 0x36, 0x05, 0x50, 0x1B, 0x68, 0x21,
  0x90, 0x04, 0x59, 0x60,
  // "ﬁ" (U+FB01)
  0x38, 0x32, 0xC7, 0x43, 0x30, 0x80, 0x45, 0x83, 0x3D, 0xA0, 0xC4, 0x82, 0xC0, 0x1B, 0x38, 0x32,
  0xA0, 0x48, 0x38, 0x35, 0x70, 0x75, 0x38, 0x38, 0x40, 0x92, 0x38, 0x2A, 0x10, 0xC4, 0x0C, 0x60,
  0x10, 0xA5, 0x81, 0x2C, 0x35,
  // "ﬂ" (U+FB02)
  0x38, 0x32, 0xC7, 0x66, 0x38, 0x38, 0x40, 0x93, 0x28, 0x33, 0xDA, 0x0C, 0x40, 0xC2, 0x0B, 0x38,
  0x32, 0xA0, 0x39, 0x38, 0x35, 0x70, 0x65, 0x38, 0x38, 0x40, 0x92, 0x38, 0x2A, 0x10, 0xC4, 0x0C,
  0x60, 0x10, 0xA5, 0x81, 0x2C, 0x35,
};

const Font& font_NotoSans_CondensedItalic_10() {
  static SmoothFont font(font_NotoSans_CondensedItalic_10_data);
  return font;
}

}  // namespace roo_display
