#include "8.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSans-CondensedBold (Noto Sans Condensed Bold)
// Generated on Wed Nov 19 19:11:20 CET 2025
static const uint8_t font_NotoSans_CondensedBold_8_data[] PROGMEM = {
  
  // Header
  0x01, 0x02, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x00, 0x24,
  0xFE, 0xFE, 0x08, 0x09, 0x07, 0xFE, 0x03, 0x01, 0x09, 0x03, 0x02, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x40, 0x01, 0x01, 0x06, 0x02, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x40, 0x04, 0x03, 0x06, 0x04, 0x00, 0x06, // """ (U+0022)
  0x00, 0x23, 0x40, 0x01, 0x04, 0x06, 0x04, 0x00, 0x0C, // "#" (U+0023)
  0x00, 0x24, 0x40, 0x01, 0x03, 0x07, 0x04, 0x00, 0x1B, // "$" (U+0024)
  0x00, 0x25, 0x40, 0x01, 0x06, 0x06, 0x06, 0x00, 0x29, // "%" (U+0025)
  0x00, 0x26, 0x40, 0x01, 0x04, 0x06, 0x05, 0x00, 0x3E, // "&" (U+0026)
  0x00, 0x27, 0x40, 0x04, 0x01, 0x06, 0x02, 0x00, 0x4D, // "'" (U+0027)
  0x00, 0x28, 0x40, 0x00, 0x02, 0x06, 0x03, 0x00, 0x50, // "(" (U+0028)
  0x00, 0x29, 0x40, 0x00, 0x02, 0x06, 0x03, 0x00, 0x5B, // ")" (U+0029)
  0x00, 0x2A, 0x40, 0x04, 0x03, 0x07, 0x04, 0x00, 0x66, // "*" (U+002A)
  0x00, 0x2B, 0x40, 0x02, 0x03, 0x05, 0x04, 0x00, 0x6E, // "+" (U+002B)
  0x00, 0x2C, 0x40, 0x00, 0x01, 0x02, 0x02, 0x00, 0x76, // "," (U+002C)
  0x00, 0x2D, 0x40, 0x02, 0x02, 0x03, 0x02, 0x00, 0x79, // "-" (U+002D)
  0x00, 0x2E, 0x40, 0x01, 0x01, 0x01, 0x02, 0x00, 0x7C, // "." (U+002E)
  0x00, 0x2F, 0x40, 0x01, 0x02, 0x06, 0x03, 0x00, 0x7D, // "/" (U+002F)
  0x00, 0x30, 0x40, 0x01, 0x03, 0x06, 0x04, 0x00, 0x86, // "0" (U+0030)
  0x00, 0x31, 0x40, 0x01, 0x02, 0x06, 0x04, 0x00, 0x92, // "1" (U+0031)
  0x00, 0x32, 0x40, 0x01, 0x03, 0x06, 0x04, 0x00, 0x9B, // "2" (U+0032)
  0x00, 0x33, 0x40, 0x01, 0x03, 0x06, 0x04, 0x00, 0xA7, // "3" (U+0033)
  0x00, 0x34, 0x40, 0x01, 0x03, 0x06, 0x04, 0x00, 0xB3, // "4" (U+0034)
  0x00, 0x35, 0x40, 0x01, 0x03, 0x06, 0x04, 0x00, 0xBF, // "5" (U+0035)
  0x00, 0x36, 0x40, 0x01, 0x03, 0x06, 0x04, 0x00, 0xCB, // "6" (U+0036)
  0x00, 0x37, 0x40, 0x01, 0x03, 0x06, 0x04, 0x00, 0xD7, // "7" (U+0037)
  0x00, 0x38, 0x40, 0x01, 0x03, 0x06, 0x04, 0x00, 0xE3, // "8" (U+0038)
  0x00, 0x39, 0x40, 0x01, 0x03, 0x06, 0x04, 0x00, 0xEF, // "9" (U+0039)
  0x00, 0x3A, 0x40, 0x01, 0x01, 0x05, 0x02, 0x00, 0xFB, // ":" (U+003A)
  0x00, 0x3B, 0x40, 0x00, 0x01, 0x05, 0x02, 0x01, 0x00, // ";" (U+003B)
  0x00, 0x3C, 0x40, 0x02, 0x03, 0x05, 0x04, 0x01, 0x06, // "<" (U+003C)
  0x00, 0x3D, 0x40, 0x02, 0x03, 0x05, 0x04, 0x01, 0x0E, // "=" (U+003D)
  0x00, 0x3E, 0x40, 0x02, 0x03, 0x05, 0x04, 0x01, 0x16, // ">" (U+003E)
  0x00, 0x3F, 0x40, 0x01, 0x02, 0x06, 0x03, 0x01, 0x1E, // "?" (U+003F)
  0x00, 0x40, 0x40, 0x00, 0x05, 0x06, 0x06, 0x01, 0x27, // "@" (U+0040)
  0x00, 0x41, 0x40, 0x01, 0x04, 0x06, 0x05, 0x01, 0x3C, // "A" (U+0041)
  0x00, 0x42, 0x40, 0x01, 0x04, 0x06, 0x05, 0x01, 0x4B, // "B" (U+0042)
  0x00, 0x43, 0x40, 0x01, 0x03, 0x06, 0x04, 0x01, 0x5A, // "C" (U+0043)
  0x00, 0x44, 0x40, 0x01, 0x04, 0x06, 0x05, 0x01, 0x66, // "D" (U+0044)
  0x00, 0x45, 0x40, 0x01, 0x03, 0x06, 0x04, 0x01, 0x75, // "E" (U+0045)
  0x00, 0x46, 0x40, 0x01, 0x03, 0x06, 0x04, 0x01, 0x81, // "F" (U+0046)
  0x00, 0x47, 0x40, 0x01, 0x04, 0x06, 0x05, 0x01, 0x8D, // "G" (U+0047)
  0x00, 0x48, 0x40, 0x01, 0x04, 0x06, 0x05, 0x01, 0x9C, // "H" (U+0048)
  0x00, 0x49, 0x40, 0x01, 0x02, 0x06, 0x03, 0x01, 0xAB, // "I" (U+0049)
  0x00, 0x4A, 0xBF, 0xFF, 0x01, 0x06, 0x02, 0x01, 0xB4, // "J" (U+004A)
  0x00, 0x4B, 0x40, 0x01, 0x04, 0x06, 0x04, 0x01, 0xC0, // "K" (U+004B)
  0x00, 0x4C, 0x40, 0x01, 0x03, 0x06, 0x04, 0x01, 0xCF, // "L" (U+004C)
  0x00, 0x4D, 0x40, 0x01, 0x05, 0x06, 0x07, 0x01, 0xDB, // "M" (U+004D)
  0x00, 0x4E, 0x40, 0x01, 0x04, 0x06, 0x05, 0x01, 0xED, // "N" (U+004E)
  0x00, 0x4F, 0x40, 0x01, 0x04, 0x06, 0x05, 0x01, 0xFC, // "O" (U+004F)
  0x00, 0x50, 0x40, 0x01, 0x03, 0x06, 0x04, 0x02, 0x0B, // "P" (U+0050)
  0x00, 0x51, 0x40, 0xFF, 0x04, 0x06, 0x05, 0x02, 0x17, // "Q" (U+0051)
  0x00, 0x52, 0x40, 0x01, 0x04, 0x06, 0x04, 0x02, 0x2B, // "R" (U+0052)
  0x00, 0x53, 0x40, 0x01, 0x03, 0x06, 0x04, 0x02, 0x3A, // "S" (U+0053)
  0x00, 0x54, 0x40, 0x01, 0x03, 0x06, 0x04, 0x02, 0x46, // "T" (U+0054)
  0x00, 0x55, 0x40, 0x01, 0x04, 0x06, 0x05, 0x02, 0x52, // "U" (U+0055)
  0x00, 0x56, 0x40, 0x01, 0x04, 0x06, 0x04, 0x02, 0x61, // "V" (U+0056)
  0x00, 0x57, 0x40, 0x01, 0x06, 0x06, 0x07, 0x02, 0x70, // "W" (U+0057)
  0x00, 0x58, 0x40, 0x01, 0x04, 0x06, 0x04, 0x02, 0x85, // "X" (U+0058)
  0x00, 0x59, 0x40, 0x01, 0x03, 0x06, 0x04, 0x02, 0x94, // "Y" (U+0059)
  0x00, 0x5A, 0x40, 0x01, 0x03, 0x06, 0x04, 0x02, 0xA0, // "Z" (U+005A)
  0x00, 0x5B, 0x40, 0xFE, 0x02, 0x06, 0x03, 0x02, 0xAC, // "[" (U+005B)
  0x00, 0x5C, 0x40, 0x01, 0x02, 0x06, 0x03, 0x02, 0xBA, // "\" (U+005C)
  0x00, 0x5D, 0x40, 0xFE, 0x01, 0x06, 0x03, 0x02, 0xC3, // "]" (U+005D)
  0x00, 0x5E, 0x40, 0x03, 0x03, 0x06, 0x04, 0x02, 0xCC, // "^" (U+005E)
  0x00, 0x5F, 0x40, 0xFF, 0x03, 0x00, 0x04, 0x02, 0xD4, // "_" (U+005F)
  0x00, 0x60, 0x40, 0x06, 0x02, 0x07, 0x03, 0x02, 0xD8, // "`" (U+0060)
  0x00, 0x61, 0x40, 0x01, 0x03, 0x05, 0x04, 0x02, 0xDB, // "a" (U+0061)
  0x00, 0x62, 0x40, 0x01, 0x03, 0x07, 0x04, 0x02, 0xE5, // "b" (U+0062)
  0x00, 0x63, 0x40, 0x01, 0x03, 0x05, 0x03, 0x02, 0xF3, // "c" (U+0063)
  0x00, 0x64, 0x40, 0x01, 0x03, 0x07, 0x04, 0x02, 0xFD, // "d" (U+0064)
  0x00, 0x65, 0x40, 0x01, 0x03, 0x05, 0x04, 0x03, 0x0B, // "e" (U+0065)
  0x00, 0x66, 0x40, 0x01, 0x02, 0x07, 0x03, 0x03, 0x15, // "f" (U+0066)
  0x00, 0x67, 0x40, 0xFF, 0x03, 0x05, 0x04, 0x03, 0x20, // "g" (U+0067)
  0x00, 0x68, 0x40, 0x01, 0x03, 0x07, 0x04, 0x03, 0x2E, // "h" (U+0068)
  0x00, 0x69, 0x40, 0x01, 0x01, 0x07, 0x02, 0x03, 0x3C, // "i" (U+0069)
  0x00, 0x6A, 0xBF, 0xFF, 0x01, 0x07, 0x02, 0x03, 0x43, // "j" (U+006A)
  0x00, 0x6B, 0x40, 0x01, 0x03, 0x07, 0x04, 0x03, 0x51, // "k" (U+006B)
  0x00, 0x6C, 0x40, 0x01, 0x01, 0x07, 0x02, 0x03, 0x5F, // "l" (U+006C)
  0x00, 0x6D, 0x40, 0x01, 0x06, 0x05, 0x07, 0x03, 0x66, // "m" (U+006D)
  0x00, 0x6E, 0x40, 0x01, 0x03, 0x05, 0x04, 0x03, 0x78, // "n" (U+006E)
  0x00, 0x6F, 0x40, 0x01, 0x03, 0x05, 0x04, 0x03, 0x82, // "o" (U+006F)
  0x00, 0x70, 0x40, 0xFF, 0x03, 0x05, 0x04, 0x03, 0x8C, // "p" (U+0070)
  0x00, 0x71, 0x40, 0xFF, 0x03, 0x05, 0x04, 0x03, 0x9A, // "q" (U+0071)
  0x00, 0x72, 0x40, 0x01, 0x02, 0x05, 0x03, 0x03, 0xA8, // "r" (U+0072)
  0x00, 0x73, 0x40, 0x01, 0x02, 0x05, 0x03, 0x03, 0xB0, // "s" (U+0073)
  0x00, 0x74, 0x40, 0x01, 0x02, 0x06, 0x03, 0x03, 0xB8, // "t" (U+0074)
  0x00, 0x75, 0x40, 0x01, 0x03, 0x05, 0x04, 0x03, 0xC1, // "u" (U+0075)
  0x00, 0x76, 0x40, 0x01, 0x03, 0x05, 0x04, 0x03, 0xCB, // "v" (U+0076)
  0x00, 0x77, 0x40, 0x01, 0x05, 0x05, 0x06, 0x03, 0xD5, // "w" (U+0077)
  0x00, 0x78, 0x40, 0x01, 0x03, 0x05, 0x04, 0x03, 0xE4, // "x" (U+0078)
  0x00, 0x79, 0x40, 0xFF, 0x03, 0x05, 0x04, 0x03, 0xEE, // "y" (U+0079)
  0x00, 0x7A, 0x40, 0x01, 0x02, 0x05, 0x03, 0x03, 0xFC, // "z" (U+007A)
  0x00, 0x7B, 0x40, 0xFF, 0x02, 0x06, 0x03, 0x04, 0x04, // "{" (U+007B)
  0x00, 0x7C, 0x41, 0xFF, 0x02, 0x07, 0x04, 0x04, 0x10, // "|" (U+007C)
  0x00, 0x7D, 0x40, 0xFF, 0x02, 0x06, 0x03, 0x04, 0x19, // "}" (U+007D)
  0x00, 0x7E, 0x40, 0x03, 0x03, 0x04, 0x04, 0x04, 0x25, // "~" (U+007E)
  0x00, 0xA1, 0x40, 0x00, 0x01, 0x05, 0x02, 0x04, 0x29, // "¡" (U+00A1)
  0x00, 0xA2, 0x40, 0x01, 0x03, 0x06, 0x04, 0x04, 0x2F, // "¢" (U+00A2)
  0x00, 0xA3, 0x40, 0x01, 0x03, 0x06, 0x04, 0x04, 0x3B, // "£" (U+00A3)
  0x00, 0xA4, 0x40, 0x01, 0x03, 0x06, 0x04, 0x04, 0x47, // "¤" (U+00A4)
  0x00, 0xA5, 0x40, 0x01, 0x03, 0x06, 0x04, 0x04, 0x53, // "¥" (U+00A5)
  0x00, 0xA6, 0x41, 0xFF, 0x02, 0x07, 0x04, 0x04, 0x5F, // "¦" (U+00A6)
  0x00, 0xA7, 0x40, 0x01, 0x02, 0x07, 0x03, 0x04, 0x68, // "§" (U+00A7)
  0x00, 0xA8, 0x40, 0x07, 0x03, 0x07, 0x04, 0x04, 0x73, // "¨" (U+00A8)
  0x00, 0xA9, 0x40, 0x01, 0x06, 0x07, 0x07, 0x04, 0x75, // "©" (U+00A9)
  0x00, 0xAA, 0x40, 0x04, 0x02, 0x06, 0x03, 0x04, 0x8E, // "ª" (U+00AA)
  0x00, 0xAB, 0x40, 0x01, 0x03, 0x04, 0x04, 0x04, 0x93, // "«" (U+00AB)
  0x00, 0xAC, 0x40, 0x02, 0x03, 0x04, 0x04, 0x04, 0x9B, // "¬" (U+00AC)
  0x00, 0xAE, 0x40, 0x01, 0x06, 0x07, 0x07, 0x04, 0xA1, // "®" (U+00AE)
  0x00, 0xAF, 0x40, 0x07, 0x03, 0x08, 0x04, 0x04, 0xBA, // "¯" (U+00AF)
  0x00, 0xB0, 0x40, 0x05, 0x02, 0x07, 0x03, 0x04, 0xBE, // "°" (U+00B0)
  0x00, 0xB1, 0x40, 0x01, 0x03, 0x06, 0x04, 0x04, 0xC3, // "±" (U+00B1)
  0x00, 0xB2, 0x40, 0x04, 0x02, 0x07, 0x03, 0x04, 0xCF, // "²" (U+00B2)
  0x00, 0xB3, 0x40, 0x04, 0x02, 0x07, 0x03, 0x04, 0xD5, // "³" (U+00B3)
  0x00, 0xB4, 0x40, 0x06, 0x01, 0x07, 0x03, 0x04, 0xDB, // "´" (U+00B4)
  0x00, 0xB5, 0x40, 0xFF, 0x03, 0x05, 0x04, 0x04, 0xDD, // "µ" (U+00B5)
  0x00, 0xB6, 0x40, 0x00, 0x03, 0x07, 0x04, 0x04, 0xEB, // "¶" (U+00B6)
  0x00, 0xB7, 0x40, 0x03, 0x01, 0x03, 0x02, 0x04, 0xFB, // "·" (U+00B7)
  0x00, 0xB8, 0xBF, 0xFF, 0x01, 0x01, 0x01, 0x04, 0xFC, // "¸" (U+00B8)
  0x00, 0xB9, 0x40, 0x04, 0x02, 0x06, 0x03, 0x05, 0x01, // "¹" (U+00B9)
  0x00, 0xBA, 0x40, 0x04, 0x02, 0x06, 0x03, 0x05, 0x06, // "º" (U+00BA)
  0x00, 0xBB, 0x40, 0x01, 0x03, 0x04, 0x04, 0x05, 0x0B, // "»" (U+00BB)
  0x00, 0xBC, 0x40, 0x01, 0x06, 0x07, 0x06, 0x05, 0x13, // "¼" (U+00BC)
  0x00, 0xBD, 0x40, 0x00, 0x06, 0x06, 0x07, 0x05, 0x2C, // "½" (U+00BD)
  0x00, 0xBE, 0x40, 0x01, 0x06, 0x07, 0x07, 0x05, 0x45, // "¾" (U+00BE)
  0x00, 0xBF, 0x40, 0xFF, 0x02, 0x04, 0x03, 0x05, 0x5E, // "¿" (U+00BF)
  0x00, 0xC0, 0x40, 0x01, 0x04, 0x08, 0x05, 0x05, 0x67, // "À" (U+00C0)
  0x00, 0xC1, 0x40, 0x01, 0x04, 0x08, 0x05, 0x05, 0x7B, // "Á" (U+00C1)
  0x00, 0xC2, 0x40, 0x01, 0x04, 0x08, 0x05, 0x05, 0x8F, // "Â" (U+00C2)
  0x00, 0xC3, 0x40, 0x01, 0x04, 0x07, 0x05, 0x05, 0xA3, // "Ã" (U+00C3)
  0x00, 0xC4, 0x40, 0x01, 0x04, 0x08, 0x05, 0x05, 0xB5, // "Ä" (U+00C4)
  0x00, 0xC5, 0x40, 0x01, 0x04, 0x07, 0x05, 0x05, 0xC9, // "Å" (U+00C5)
  0x00, 0xC6, 0x40, 0x01, 0x05, 0x06, 0x06, 0x05, 0xDB, // "Æ" (U+00C6)
  0x00, 0xC7, 0x40, 0xFF, 0x03, 0x06, 0x04, 0x05, 0xED, // "Ç" (U+00C7)
  0x00, 0xC8, 0x40, 0x01, 0x03, 0x08, 0x04, 0x05, 0xFD, // "È" (U+00C8)
  0x00, 0xC9, 0x40, 0x01, 0x03, 0x08, 0x04, 0x06, 0x0D, // "É" (U+00C9)
  0x00, 0xCA, 0x40, 0x01, 0x03, 0x08, 0x04, 0x06, 0x1D, // "Ê" (U+00CA)
  0x00, 0xCB, 0x40, 0x01, 0x03, 0x08, 0x04, 0x06, 0x2D, // "Ë" (U+00CB)
  0x00, 0xCC, 0x40, 0x01, 0x02, 0x08, 0x03, 0x06, 0x3D, // "Ì" (U+00CC)
  0x00, 0xCD, 0x40, 0x01, 0x02, 0x08, 0x03, 0x06, 0x49, // "Í" (U+00CD)
  0x00, 0xCE, 0x40, 0x01, 0x02, 0x08, 0x03, 0x06, 0x55, // "Î" (U+00CE)
  0x00, 0xCF, 0xBF, 0x01, 0x02, 0x08, 0x03, 0x06, 0x61, // "Ï" (U+00CF)
  0x00, 0xD0, 0x40, 0x01, 0x04, 0x06, 0x05, 0x06, 0x71, // "Ð" (U+00D0)
  0x00, 0xD1, 0x40, 0x01, 0x04, 0x07, 0x05, 0x06, 0x80, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x40, 0x01, 0x04, 0x08, 0x05, 0x06, 0x92, // "Ò" (U+00D2)
  0x00, 0xD3, 0x40, 0x01, 0x04, 0x08, 0x05, 0x06, 0xA6, // "Ó" (U+00D3)
  0x00, 0xD4, 0x40, 0x01, 0x04, 0x08, 0x05, 0x06, 0xBA, // "Ô" (U+00D4)
  0x00, 0xD5, 0x40, 0x01, 0x04, 0x07, 0x05, 0x06, 0xCE, // "Õ" (U+00D5)
  0x00, 0xD6, 0x40, 0x01, 0x04, 0x08, 0x05, 0x06, 0xE0, // "Ö" (U+00D6)
  0x00, 0xD7, 0x40, 0x02, 0x03, 0x05, 0x04, 0x06, 0xF4, // "×" (U+00D7)
  0x00, 0xD8, 0x00, 0x00, 0x04, 0x07, 0x05, 0x06, 0xFC, // "Ø" (U+00D8)
  0x00, 0xD9, 0x40, 0x01, 0x04, 0x08, 0x05, 0x07, 0x0F, // "Ù" (U+00D9)
  0x00, 0xDA, 0x40, 0x01, 0x04, 0x08, 0x05, 0x07, 0x23, // "Ú" (U+00DA)
  0x00, 0xDB, 0x40, 0x01, 0x04, 0x08, 0x05, 0x07, 0x37, // "Û" (U+00DB)
  0x00, 0xDC, 0x40, 0x01, 0x04, 0x08, 0x05, 0x07, 0x4B, // "Ü" (U+00DC)
  0x00, 0xDD, 0x40, 0x01, 0x03, 0x08, 0x04, 0x07, 0x5F, // "Ý" (U+00DD)
  0x00, 0xDE, 0x40, 0x01, 0x03, 0x06, 0x04, 0x07, 0x6F, // "Þ" (U+00DE)
  0x00, 0xDF, 0x40, 0x01, 0x04, 0x07, 0x05, 0x07, 0x7B, // "ß" (U+00DF)
  0x00, 0xE0, 0x40, 0x01, 0x03, 0x07, 0x04, 0x07, 0x8D, // "à" (U+00E0)
  0x00, 0xE1, 0x40, 0x01, 0x03, 0x07, 0x04, 0x07, 0x9B, // "á" (U+00E1)
  0x00, 0xE2, 0x40, 0x01, 0x03, 0x07, 0x04, 0x07, 0xA9, // "â" (U+00E2)
  0x00, 0xE3, 0x40, 0x01, 0x03, 0x06, 0x04, 0x07, 0xB7, // "ã" (U+00E3)
  0x00, 0xE4, 0x40, 0x01, 0x03, 0x07, 0x04, 0x07, 0xC3, // "ä" (U+00E4)
  0x00, 0xE5, 0x40, 0x01, 0x03, 0x07, 0x04, 0x07, 0xD1, // "å" (U+00E5)
  0x00, 0xE6, 0x40, 0x01, 0x05, 0x05, 0x06, 0x07, 0xDF, // "æ" (U+00E6)
  0x00, 0xE7, 0x40, 0xFF, 0x03, 0x05, 0x03, 0x07, 0xEE, // "ç" (U+00E7)
  0x00, 0xE8, 0x40, 0x01, 0x03, 0x07, 0x04, 0x07, 0xFC, // "è" (U+00E8)
  0x00, 0xE9, 0x40, 0x01, 0x03, 0x07, 0x04, 0x08, 0x0A, // "é" (U+00E9)
  0x00, 0xEA, 0x40, 0x01, 0x03, 0x07, 0x04, 0x08, 0x18, // "ê" (U+00EA)
  0x00, 0xEB, 0x40, 0x01, 0x03, 0x07, 0x04, 0x08, 0x26, // "ë" (U+00EB)
  0x00, 0xEC, 0xBF, 0x01, 0x01, 0x07, 0x02, 0x08, 0x34, // "ì" (U+00EC)
  0x00, 0xED, 0x40, 0x01, 0x01, 0x07, 0x02, 0x08, 0x3F, // "í" (U+00ED)
  0x00, 0xEE, 0xBF, 0x01, 0x01, 0x07, 0x02, 0x08, 0x46, // "î" (U+00EE)
  0x00, 0xEF, 0xBF, 0x01, 0x02, 0x07, 0x02, 0x08, 0x51, // "ï" (U+00EF)
  0x00, 0xF0, 0x40, 0x01, 0x03, 0x08, 0x04, 0x08, 0x5F, // "ð" (U+00F0)
  0x00, 0xF1, 0x40, 0x01, 0x03, 0x06, 0x04, 0x08, 0x6F, // "ñ" (U+00F1)
  0x00, 0xF2, 0x40, 0x01, 0x03, 0x07, 0x04, 0x08, 0x7B, // "ò" (U+00F2)
  0x00, 0xF3, 0x40, 0x01, 0x03, 0x07, 0x04, 0x08, 0x89, // "ó" (U+00F3)
  0x00, 0xF4, 0x40, 0x01, 0x03, 0x07, 0x04, 0x08, 0x97, // "ô" (U+00F4)
  0x00, 0xF5, 0x40, 0x01, 0x03, 0x06, 0x04, 0x08, 0xA5, // "õ" (U+00F5)
  0x00, 0xF6, 0x40, 0x01, 0x03, 0x07, 0x04, 0x08, 0xB1, // "ö" (U+00F6)
  0x00, 0xF7, 0x40, 0x02, 0x03, 0x05, 0x04, 0x08, 0xBF, // "÷" (U+00F7)
  0x00, 0xF8, 0x40, 0x00, 0x03, 0x06, 0x04, 0x08, 0xC7, // "ø" (U+00F8)
  0x00, 0xF9, 0x40, 0x01, 0x03, 0x07, 0x04, 0x08, 0xD5, // "ù" (U+00F9)
  0x00, 0xFA, 0x40, 0x01, 0x03, 0x07, 0x04, 0x08, 0xE3, // "ú" (U+00FA)
  0x00, 0xFB, 0x40, 0x01, 0x03, 0x07, 0x04, 0x08, 0xF1, // "û" (U+00FB)
  0x00, 0xFC, 0x40, 0x01, 0x03, 0x07, 0x04, 0x08, 0xFF, // "ü" (U+00FC)
  0x00, 0xFD, 0x40, 0xFF, 0x03, 0x07, 0x04, 0x09, 0x0D, // "ý" (U+00FD)
  0x00, 0xFE, 0x40, 0xFF, 0x03, 0x07, 0x04, 0x09, 0x1F, // "þ" (U+00FE)
  0x00, 0xFF, 0x40, 0xFF, 0x03, 0x07, 0x04, 0x09, 0x31, // "ÿ" (U+00FF)
  0x01, 0x00, 0x40, 0x01, 0x04, 0x08, 0x05, 0x09, 0x43, // "Ā" (U+0100)
  0x01, 0x01, 0x40, 0x01, 0x03, 0x07, 0x04, 0x09, 0x57, // "ā" (U+0101)
  0x01, 0x02, 0x40, 0x01, 0x04, 0x08, 0x05, 0x09, 0x65, // "Ă" (U+0102)
  0x01, 0x03, 0x40, 0x01, 0x03, 0x07, 0x04, 0x09, 0x79, // "ă" (U+0103)
  0x01, 0x04, 0x40, 0xFF, 0x04, 0x06, 0x05, 0x09, 0x87, // "Ą" (U+0104)
  0x01, 0x05, 0x40, 0xFF, 0x03, 0x05, 0x04, 0x09, 0x9B, // "ą" (U+0105)
  0x01, 0x06, 0x40, 0x01, 0x03, 0x08, 0x04, 0x09, 0xA9, // "Ć" (U+0106)
  0x01, 0x07, 0x40, 0x01, 0x03, 0x07, 0x03, 0x09, 0xB9, // "ć" (U+0107)
  0x01, 0x08, 0x40, 0x01, 0x03, 0x08, 0x04, 0x09, 0xC7, // "Ĉ" (U+0108)
  0x01, 0x09, 0x40, 0x01, 0x03, 0x07, 0x03, 0x09, 0xD7, // "ĉ" (U+0109)
  0x01, 0x0A, 0x40, 0x01, 0x03, 0x08, 0x04, 0x09, 0xE5, // "Ċ" (U+010A)
  0x01, 0x0B, 0x40, 0x01, 0x03, 0x07, 0x03, 0x09, 0xF5, // "ċ" (U+010B)
  0x01, 0x0C, 0x40, 0x01, 0x03, 0x08, 0x04, 0x0A, 0x03, // "Č" (U+010C)
  0x01, 0x0D, 0x40, 0x01, 0x03, 0x07, 0x03, 0x0A, 0x13, // "č" (U+010D)
  0x01, 0x0E, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0A, 0x21, // "Ď" (U+010E)
  0x01, 0x0F, 0x40, 0x01, 0x05, 0x07, 0x04, 0x0A, 0x35, // "ď" (U+010F)
  0x01, 0x10, 0x40, 0x01, 0x04, 0x06, 0x05, 0x0A, 0x4A, // "Đ" (U+0110)
  0x01, 0x11, 0x40, 0x01, 0x04, 0x07, 0x04, 0x0A, 0x59, // "đ" (U+0111)
  0x01, 0x12, 0x40, 0x01, 0x03, 0x08, 0x04, 0x0A, 0x6B, // "Ē" (U+0112)
  0x01, 0x13, 0x40, 0x01, 0x03, 0x07, 0x04, 0x0A, 0x7B, // "ē" (U+0113)
  0x01, 0x14, 0x40, 0x01, 0x03, 0x08, 0x04, 0x0A, 0x89, // "Ĕ" (U+0114)
  0x01, 0x15, 0x40, 0x01, 0x03, 0x07, 0x04, 0x0A, 0x99, // "ĕ" (U+0115)
  0x01, 0x16, 0x40, 0x01, 0x03, 0x08, 0x04, 0x0A, 0xA7, // "Ė" (U+0116)
  0x01, 0x17, 0x40, 0x01, 0x03, 0x07, 0x04, 0x0A, 0xB7, // "ė" (U+0117)
  0x01, 0x18, 0x40, 0xFF, 0x03, 0x06, 0x04, 0x0A, 0xC5, // "Ę" (U+0118)
  0x01, 0x19, 0x40, 0xFF, 0x03, 0x05, 0x04, 0x0A, 0xD5, // "ę" (U+0119)
  0x01, 0x1A, 0x40, 0x01, 0x03, 0x08, 0x04, 0x0A, 0xE3, // "Ě" (U+011A)
  0x01, 0x1B, 0x40, 0x01, 0x03, 0x07, 0x04, 0x0A, 0xF3, // "ě" (U+011B)
  0x01, 0x1C, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0B, 0x01, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x40, 0xFF, 0x03, 0x07, 0x04, 0x0B, 0x15, // "ĝ" (U+011D)
  0x01, 0x1E, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0B, 0x27, // "Ğ" (U+011E)
  0x01, 0x1F, 0x40, 0xFF, 0x03, 0x07, 0x04, 0x0B, 0x3B, // "ğ" (U+011F)
  0x01, 0x20, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0B, 0x4D, // "Ġ" (U+0120)
  0x01, 0x21, 0x40, 0xFF, 0x03, 0x07, 0x04, 0x0B, 0x60, // "ġ" (U+0121)
  0x01, 0x22, 0x40, 0xFF, 0x04, 0x06, 0x05, 0x0B, 0x72, // "Ģ" (U+0122)
  0x01, 0x23, 0x40, 0xFF, 0x03, 0x07, 0x04, 0x0B, 0x86, // "ģ" (U+0123)
  0x01, 0x24, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0B, 0x98, // "Ĥ" (U+0124)
  0x01, 0x25, 0xBF, 0x01, 0x03, 0x09, 0x04, 0x0B, 0xAC, // "ĥ" (U+0125)
  0x01, 0x26, 0x40, 0x01, 0x05, 0x06, 0x05, 0x0B, 0xC3, // "Ħ" (U+0126)
  0x01, 0x27, 0x40, 0x01, 0x03, 0x07, 0x04, 0x0B, 0xD5, // "ħ" (U+0127)
  0x01, 0x28, 0x40, 0x01, 0x02, 0x07, 0x03, 0x0B, 0xE3, // "Ĩ" (U+0128)
  0x01, 0x29, 0xBF, 0x01, 0x01, 0x06, 0x02, 0x0B, 0xEE, // "ĩ" (U+0129)
  0x01, 0x2A, 0x40, 0x01, 0x02, 0x08, 0x03, 0x0B, 0xF7, // "Ī" (U+012A)
  0x01, 0x2B, 0x40, 0x01, 0x02, 0x07, 0x02, 0x0C, 0x03, // "ī" (U+012B)
  0x01, 0x2C, 0x40, 0x01, 0x02, 0x08, 0x03, 0x0C, 0x0E, // "Ĭ" (U+012C)
  0x01, 0x2D, 0xBF, 0x01, 0x01, 0x07, 0x02, 0x0C, 0x1A, // "ĭ" (U+012D)
  0x01, 0x2E, 0x40, 0xFF, 0x02, 0x06, 0x03, 0x0C, 0x25, // "Į" (U+012E)
  0x01, 0x2F, 0x40, 0xFF, 0x01, 0x07, 0x02, 0x0C, 0x31, // "į" (U+012F)
  0x01, 0x30, 0x40, 0x01, 0x02, 0x08, 0x03, 0x0C, 0x3A, // "İ" (U+0130)
  0x01, 0x31, 0x40, 0x01, 0x01, 0x05, 0x02, 0x0C, 0x46, // "ı" (U+0131)
  0x01, 0x32, 0x40, 0xFF, 0x04, 0x06, 0x05, 0x0C, 0x4B, // "Ĳ" (U+0132)
  0x01, 0x33, 0x40, 0xFF, 0x03, 0x07, 0x04, 0x0C, 0x5F, // "ĳ" (U+0133)
  0x01, 0x34, 0xBF, 0xFF, 0x01, 0x08, 0x02, 0x0C, 0x71, // "Ĵ" (U+0134)
  0x01, 0x35, 0xBF, 0xFF, 0x01, 0x07, 0x02, 0x0C, 0x80, // "ĵ" (U+0135)
  0x01, 0x36, 0x40, 0xFF, 0x04, 0x06, 0x04, 0x0C, 0x8E, // "Ķ" (U+0136)
  0x01, 0x37, 0x40, 0xFF, 0x03, 0x07, 0x04, 0x0C, 0xA2, // "ķ" (U+0137)
  0x01, 0x38, 0x40, 0x01, 0x03, 0x05, 0x04, 0x0C, 0xB4, // "ĸ" (U+0138)
  0x01, 0x39, 0x40, 0x01, 0x03, 0x08, 0x04, 0x0C, 0xBE, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x40, 0x01, 0x01, 0x09, 0x02, 0x0C, 0xCE, // "ĺ" (U+013A)
  0x01, 0x3B, 0x40, 0xFF, 0x03, 0x06, 0x04, 0x0C, 0xD7, // "Ļ" (U+013B)
  0x01, 0x3C, 0x40, 0xFF, 0x01, 0x07, 0x02, 0x0C, 0xE7, // "ļ" (U+013C)
  0x01, 0x3D, 0x40, 0x01, 0x03, 0x06, 0x04, 0x0C, 0xF0, // "Ľ" (U+013D)
  0x01, 0x3E, 0x40, 0x01, 0x02, 0x07, 0x02, 0x0C, 0xFC, // "ľ" (U+013E)
  0x01, 0x3F, 0x40, 0x01, 0x03, 0x06, 0x04, 0x0D, 0x07, // "Ŀ" (U+013F)
  0x01, 0x40, 0x40, 0x01, 0x03, 0x07, 0x03, 0x0D, 0x13, // "ŀ" (U+0140)
  0x01, 0x41, 0x40, 0x01, 0x03, 0x06, 0x04, 0x0D, 0x21, // "Ł" (U+0141)
  0x01, 0x42, 0x40, 0x01, 0x02, 0x07, 0x02, 0x0D, 0x2D, // "ł" (U+0142)
  0x01, 0x43, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0D, 0x38, // "Ń" (U+0143)
  0x01, 0x44, 0x40, 0x01, 0x03, 0x07, 0x04, 0x0D, 0x4C, // "ń" (U+0144)
  0x01, 0x45, 0x40, 0xFF, 0x04, 0x06, 0x05, 0x0D, 0x5A, // "Ņ" (U+0145)
  0x01, 0x46, 0x40, 0xFF, 0x03, 0x05, 0x04, 0x0D, 0x6E, // "ņ" (U+0146)
  0x01, 0x47, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0D, 0x7C, // "Ň" (U+0147)
  0x01, 0x48, 0x40, 0x01, 0x03, 0x07, 0x04, 0x0D, 0x90, // "ň" (U+0148)
  0x01, 0x49, 0x40, 0x01, 0x04, 0x06, 0x05, 0x0D, 0x9E, // "ŉ" (U+0149)
  0x01, 0x4A, 0x40, 0xFE, 0x04, 0x06, 0x05, 0x0D, 0xAD, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x40, 0xFF, 0x03, 0x05, 0x04, 0x0D, 0xC4, // "ŋ" (U+014B)
  0x01, 0x4C, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0D, 0xD2, // "Ō" (U+014C)
  0x01, 0x4D, 0x40, 0x01, 0x03, 0x07, 0x04, 0x0D, 0xE6, // "ō" (U+014D)
  0x01, 0x4E, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0D, 0xF4, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x40, 0x01, 0x03, 0x07, 0x04, 0x0E, 0x08, // "ŏ" (U+014F)
  0x01, 0x50, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0E, 0x16, // "Ő" (U+0150)
  0x01, 0x51, 0x40, 0x01, 0x04, 0x07, 0x04, 0x0E, 0x2A, // "ő" (U+0151)
  0x01, 0x52, 0x40, 0x01, 0x05, 0x06, 0x06, 0x0E, 0x3C, // "Œ" (U+0152)
  0x01, 0x53, 0x40, 0x01, 0x06, 0x05, 0x06, 0x0E, 0x4E, // "œ" (U+0153)
  0x01, 0x54, 0x40, 0x01, 0x04, 0x08, 0x04, 0x0E, 0x60, // "Ŕ" (U+0154)
  0x01, 0x55, 0x40, 0x01, 0x02, 0x07, 0x03, 0x0E, 0x74, // "ŕ" (U+0155)
  0x01, 0x56, 0x40, 0xFF, 0x04, 0x06, 0x04, 0x0E, 0x7F, // "Ŗ" (U+0156)
  0x01, 0x57, 0x40, 0xFF, 0x02, 0x05, 0x03, 0x0E, 0x93, // "ŗ" (U+0157)
  0x01, 0x58, 0x40, 0x01, 0x04, 0x08, 0x04, 0x0E, 0x9E, // "Ř" (U+0158)
  0x01, 0x59, 0x40, 0x01, 0x02, 0x07, 0x03, 0x0E, 0xB2, // "ř" (U+0159)
  0x01, 0x5A, 0x40, 0x01, 0x03, 0x08, 0x04, 0x0E, 0xBD, // "Ś" (U+015A)
  0x01, 0x5B, 0x40, 0x01, 0x02, 0x07, 0x03, 0x0E, 0xCD, // "ś" (U+015B)
  0x01, 0x5C, 0x40, 0x01, 0x03, 0x08, 0x04, 0x0E, 0xD8, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x40, 0x01, 0x02, 0x07, 0x03, 0x0E, 0xE8, // "ŝ" (U+015D)
  0x01, 0x5E, 0x40, 0xFF, 0x03, 0x06, 0x04, 0x0E, 0xF3, // "Ş" (U+015E)
  0x01, 0x5F, 0x40, 0xFF, 0x02, 0x05, 0x03, 0x0F, 0x03, // "ş" (U+015F)
  0x01, 0x60, 0x40, 0x01, 0x03, 0x08, 0x04, 0x0F, 0x0E, // "Š" (U+0160)
  0x01, 0x61, 0x40, 0x01, 0x02, 0x07, 0x03, 0x0F, 0x1E, // "š" (U+0161)
  0x01, 0x62, 0x40, 0xFF, 0x03, 0x06, 0x04, 0x0F, 0x29, // "Ţ" (U+0162)
  0x01, 0x63, 0x40, 0xFF, 0x02, 0x06, 0x03, 0x0F, 0x39, // "ţ" (U+0163)
  0x01, 0x64, 0x40, 0x01, 0x03, 0x08, 0x04, 0x0F, 0x45, // "Ť" (U+0164)
  0x01, 0x65, 0x40, 0x01, 0x03, 0x07, 0x03, 0x0F, 0x55, // "ť" (U+0165)
  0x01, 0x66, 0x40, 0x01, 0x03, 0x06, 0x04, 0x0F, 0x63, // "Ŧ" (U+0166)
  0x01, 0x67, 0x40, 0x01, 0x02, 0x06, 0x03, 0x0F, 0x6F, // "ŧ" (U+0167)
  0x01, 0x68, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0F, 0x78, // "Ũ" (U+0168)
  0x01, 0x69, 0x40, 0x01, 0x03, 0x06, 0x04, 0x0F, 0x8A, // "ũ" (U+0169)
  0x01, 0x6A, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0F, 0x96, // "Ū" (U+016A)
  0x01, 0x6B, 0x40, 0x01, 0x03, 0x07, 0x04, 0x0F, 0xAA, // "ū" (U+016B)
  0x01, 0x6C, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0F, 0xB8, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x40, 0x01, 0x03, 0x07, 0x04, 0x0F, 0xCC, // "ŭ" (U+016D)
  0x01, 0x6E, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0F, 0xDA, // "Ů" (U+016E)
  0x01, 0x6F, 0x40, 0x01, 0x03, 0x07, 0x04, 0x0F, 0xEE, // "ů" (U+016F)
  0x01, 0x70, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0F, 0xFC, // "Ű" (U+0170)
  0x01, 0x71, 0x40, 0x01, 0x04, 0x07, 0x04, 0x10, 0x10, // "ű" (U+0171)
  0x01, 0x72, 0x40, 0xFF, 0x04, 0x06, 0x05, 0x10, 0x22, // "Ų" (U+0172)
  0x01, 0x73, 0x40, 0xFF, 0x03, 0x05, 0x04, 0x10, 0x36, // "ų" (U+0173)
  0x01, 0x74, 0x40, 0x01, 0x06, 0x08, 0x07, 0x10, 0x44, // "Ŵ" (U+0174)
  0x01, 0x75, 0x40, 0x01, 0x05, 0x07, 0x06, 0x10, 0x60, // "ŵ" (U+0175)
  0x01, 0x76, 0x40, 0x01, 0x03, 0x08, 0x04, 0x10, 0x75, // "Ŷ" (U+0176)
  0x01, 0x77, 0x40, 0xFF, 0x03, 0x07, 0x04, 0x10, 0x85, // "ŷ" (U+0177)
  0x01, 0x78, 0x40, 0x01, 0x03, 0x08, 0x04, 0x10, 0x97, // "Ÿ" (U+0178)
  0x01, 0x79, 0x40, 0x01, 0x03, 0x08, 0x04, 0x10, 0xA7, // "Ź" (U+0179)
  0x01, 0x7A, 0x40, 0x01, 0x02, 0x07, 0x03, 0x10, 0xB7, // "ź" (U+017A)
  0x01, 0x7B, 0x40, 0x01, 0x03, 0x08, 0x04, 0x10, 0xC2, // "Ż" (U+017B)
  0x01, 0x7C, 0x40, 0x01, 0x02, 0x07, 0x03, 0x10, 0xD2, // "ż" (U+017C)
  0x01, 0x7D, 0x40, 0x01, 0x03, 0x08, 0x04, 0x10, 0xDD, // "Ž" (U+017D)
  0x01, 0x7E, 0x40, 0x01, 0x02, 0x07, 0x03, 0x10, 0xED, // "ž" (U+017E)
  0x01, 0x7F, 0x40, 0x01, 0x02, 0x07, 0x03, 0x10, 0xF8, // "ſ" (U+017F)
  0x03, 0xA9, 0x40, 0x01, 0x04, 0x06, 0x05, 0x11, 0x03, // "Ω" (U+03A9)
  0x03, 0xBC, 0x40, 0xFF, 0x03, 0x05, 0x04, 0x11, 0x12, // "μ" (U+03BC)
  0x03, 0xC0, 0x40, 0x01, 0x04, 0x05, 0x05, 0x11, 0x20, // "π" (U+03C0)
  0x20, 0x13, 0x40, 0x02, 0x03, 0x03, 0x04, 0x11, 0x2D, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x02, 0x07, 0x03, 0x08, 0x11, 0x31, // "—" (U+2014)
  0x20, 0xAC, 0x40, 0x01, 0x03, 0x06, 0x04, 0x11, 0x37, // "€" (U+20AC)
  0x20, 0xBF, 0x40, 0x00, 0x03, 0x07, 0x04, 0x11, 0x43, // "₿" (U+20BF)
  0x20, 0x18, 0x40, 0x04, 0x01, 0x06, 0x02, 0x11, 0x53, // "‘" (U+2018)
  0x20, 0x19, 0x40, 0x04, 0x01, 0x06, 0x02, 0x11, 0x56, // "’" (U+2019)
  0x20, 0x1A, 0x40, 0xFF, 0x01, 0x01, 0x02, 0x11, 0x59, // "‚" (U+201A)
  0x20, 0x1B, 0x40, 0x04, 0x01, 0x06, 0x02, 0x11, 0x5C, // "‛" (U+201B)
  0x20, 0x1C, 0x40, 0x04, 0x03, 0x06, 0x04, 0x11, 0x5F, // "“" (U+201C)
  0x20, 0x1D, 0x40, 0x04, 0x03, 0x06, 0x04, 0x11, 0x65, // "”" (U+201D)
  0x20, 0x1E, 0x40, 0xFF, 0x03, 0x01, 0x04, 0x11, 0x6B, // "„" (U+201E)
  0x20, 0x1F, 0x40, 0x04, 0x03, 0x06, 0x04, 0x11, 0x71, // "‟" (U+201F)
  0x20, 0x20, 0x40, 0x01, 0x03, 0x07, 0x04, 0x11, 0x77, // "†" (U+2020)
  0x20, 0x21, 0x40, 0x01, 0x03, 0x07, 0x04, 0x11, 0x85, // "‡" (U+2021)
  0x20, 0x22, 0x40, 0x03, 0x02, 0x05, 0x03, 0x11, 0x93, // "•" (U+2022)
  0x20, 0x26, 0x40, 0x01, 0x05, 0x01, 0x06, 0x11, 0x98, // "…" (U+2026)
  0x20, 0x30, 0x40, 0x01, 0x08, 0x06, 0x09, 0x11, 0x9B, // "‰" (U+2030)
  0x20, 0x39, 0x40, 0x01, 0x02, 0x04, 0x03, 0x11, 0xB6, // "‹" (U+2039)
  0x20, 0x3A, 0x40, 0x01, 0x02, 0x04, 0x03, 0x11, 0xBC, // "›" (U+203A)
  0x20, 0x44, 0xBE, 0x01, 0x02, 0x06, 0x01, 0x11, 0xC2, // "⁄" (U+2044)
  0x21, 0x22, 0x40, 0x04, 0x05, 0x06, 0x06, 0x11, 0xD1, // "™" (U+2122)
  0x21, 0x52, 0x40, 0x01, 0x08, 0x06, 0x09, 0x11, 0xDA, // "⅒" (U+2152)
  0xFB, 0x01, 0x40, 0x01, 0x04, 0x07, 0x05, 0x11, 0xF5, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0x40, 0x01, 0x04, 0x07, 0x05, 0x12, 0x07, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0xC6, 0x01, // "Æ (U+0022 U+00C6)
  0x00, 0x27, 0x00, 0xC6, 0x01, // 'Æ (U+0027 U+00C6)
  0x00, 0x50, 0x00, 0x2C, 0x01, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x01, // P. (U+0050 U+002E)
  0x00, 0x50, 0x20, 0x1A, 0x01, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x01, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x01, // P… (U+0050 U+2026)
  0x00, 0x72, 0x00, 0x2C, 0x01, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x01, // r. (U+0072 U+002E)
  0x00, 0x72, 0x20, 0x1A, 0x01, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x01, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x01, // r… (U+0072 U+2026)
  0x00, 0xDE, 0x00, 0x2C, 0x01, // Þ, (U+00DE U+002C)
  0x00, 0xDE, 0x00, 0x2E, 0x01, // Þ. (U+00DE U+002E)
  0x00, 0xDE, 0x20, 0x1A, 0x01, // Þ‚ (U+00DE U+201A)
  0x00, 0xDE, 0x20, 0x1E, 0x01, // Þ„ (U+00DE U+201E)
  0x00, 0xDE, 0x20, 0x26, 0x01, // Þ… (U+00DE U+2026)
  0x01, 0x55, 0x00, 0x2C, 0x01, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x01, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x20, 0x1A, 0x01, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x01, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x01, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x01, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x01, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x20, 0x1A, 0x01, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x01, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x01, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x01, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x01, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x20, 0x1A, 0x01, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x01, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x01, // ř… (U+0159 U+2026)
  0x20, 0x18, 0x00, 0xC6, 0x01, // ‘Æ (U+2018 U+00C6)
  0x20, 0x19, 0x00, 0xC6, 0x01, // ’Æ (U+2019 U+00C6)
  0x20, 0x1C, 0x00, 0xC6, 0x01, // “Æ (U+201C U+00C6)
  0x20, 0x1D, 0x00, 0xC6, 0x01, // ”Æ (U+201D U+00C6)
  
  // Glyph data
  // "!" (U+0021)
  0x8A, 0x79, 0x78, 0x68, 0x00, 0x68,
  // """ (U+0022)
  0x87, 0xD2, 0x76, 0xC1, 0x10, 0x10,
  // "#" (U+0023)
  0x09, 0x5A, 0x08, 0xFE, 0xE4, 0x0C, 0x76, 0x0B, 0xFE, 0xE0, 0x3A, 0xB2, 0x03, 0x8C, 0x00,
  // "$" (U+0024)
  0x07, 0x71, 0x7D, 0xA5, 0x8C, 0x40, 0x09, 0xE3, 0x23, 0xA9, 0x8F, 0xE4, 0x04, 0x40,
  // "%" (U+0025)
  0x5E, 0x32, 0xA0, 0x0B, 0x79, 0x84, 0x00, 0xB6, 0x9C, 0xAB, 0x06, 0xFA, 0x8C, 0xB2, 0x00, 0xB2,
  0xCB, 0x20, 0x39, 0x0B, 0xC0,
  // "&" (U+0026)
  0x1C, 0xE3, 0x04, 0xC9, 0x70, 0x1E, 0xD2, 0x06, 0xBD, 0x8A, 0xB7, 0x8F, 0x45, 0xED, 0xBA,
  // "'" (U+0027)
  0x87, 0x76, 0x10,
  // "(" (U+0028)
  0x0B, 0x24, 0xA0, 0x87, 0x09, 0x60, 0x87, 0x04, 0xB0, 0x0C, 0x20,
  // ")" (U+0029)
  0x85, 0x02, 0xD0, 0x0E, 0x10, 0xC3, 0x0E, 0x12, 0xD0, 0x95, 0x00,
  // "*" (U+002A)
  0x08, 0x50, 0xAD, 0xC7, 0x1D, 0xC0, 0x25, 0x71,
  // "+" (U+002B)
  0x06, 0x60, 0xAE, 0xEA, 0x17, 0x71, 0x06, 0x60,
  // "," (U+002C)
  0x11, 0x78, 0xA4,
  // "-" (U+002D)
  0xAE, 0x31, 0x10,
  // "." (U+002E)
  0x68,
  // "/" (U+002F)
  0x00, 0xD0, 0x4A, 0x0A, 0x41, 0xD0, 0x69, 0x0B, 0x30,
  // "0" (U+0030)
  0x2D, 0xD1, 0x89, 0x98, 0xA6, 0x6A, 0xA6, 0x6A, 0x89, 0x98, 0x2D, 0xD2,
  // "1" (U+0031)
  0x06, 0xF5, 0xDF, 0x03, 0xF0, 0x1F, 0x01, 0xF0, 0x1F,
  // "2" (U+0032)
  0x5E, 0xD2, 0x32, 0xB7, 0x00, 0xC5, 0x07, 0xB0, 0x3D, 0x10, 0xBF, 0xF9,
  // "3" (U+0033)
  0x6E, 0xD3, 0x11, 0xB7, 0x0E, 0xD1, 0x01, 0xB8, 0x20, 0xA9, 0x9F, 0xC2,
  // "4" (U+0034)
  0x01, 0xE4, 0x08, 0xF4, 0x1D, 0xC4, 0x85, 0xC4, 0xDE, 0xFD, 0x11, 0xC5,
  // "5" (U+0035)
  0x5F, 0xF4, 0x68, 0x00, 0x7E, 0xC2, 0x12, 0xB8, 0x21, 0xA8, 0x7F, 0xC2,
  // "6" (U+0036)
  0x0A, 0xF6, 0x6B, 0x10, 0x9B, 0xD3, 0xA9, 0x8A, 0x89, 0x8A, 0x2D, 0xD3,
  // "7" (U+0037)
  0xBF, 0xFB, 0x00, 0x97, 0x00, 0xE2, 0x05, 0xC0, 0x0A, 0x60, 0x1F, 0x10,
  // "8" (U+0038)
  0x3D, 0xD3, 0x89, 0x97, 0x3D, 0xD2, 0x5C, 0xC5, 0xA7, 0x7A, 0x5E, 0xE4,
  // "9" (U+0039)
  0x3D, 0xC1, 0xA7, 0x98, 0xA7, 0x8A, 0x5F, 0xD9, 0x01, 0xB5, 0x6F, 0x90,
  // ":" (U+003A)
  0x68, 0x00, 0x00, 0x00, 0x68,
  // ";" (U+003B)
  0x68, 0x00, 0x00, 0x11, 0x78, 0xA4,
  // "<" (U+003C)
  0x00, 0x37, 0x3B, 0xA3, 0x7D, 0x60, 0x01, 0x79,
  // "=" (U+003D)
  0xAE, 0xEA, 0x11, 0x11, 0xAE, 0xEA, 0x11, 0x11,
  // ">" (U+003E)
  0x73, 0x00, 0x3A, 0xB3, 0x06, 0xD7, 0x97, 0x10,
  // "?" (U+003F)
  0xAE, 0x92, 0x1F, 0x06, 0xC0, 0xE1, 0x03, 0x02, 0xC0,
  // "@" (U+0040)
  0x04, 0xDE, 0x90, 0x2D, 0xDF, 0xD8, 0x78, 0xB7, 0x6C, 0x96, 0x99, 0x5B, 0x84, 0xDA, 0xE6, 0x4B,
  0x10, 0x20, 0x08, 0xEF, 0x80,
  // "A" (U+0041)
  0x08, 0xF2, 0x00, 0xCA, 0x60, 0x1D, 0x4A, 0x05, 0xFE, 0xE0, 0x98, 0x2D, 0x3D, 0x40, 0xA7,
  // "B" (U+0042)
  0x6F, 0xFA, 0x06, 0xB3, 0xF0, 0x6F, 0xF9, 0x06, 0xB3, 0xF1, 0x6B, 0x2F, 0x26, 0xFF, 0x90,
  // "C" (U+0043)
  0x09, 0xEB, 0x5D, 0x12, 0x89, 0x00, 0x89, 0x00, 0x5D, 0x12, 0x0A, 0xEB,
  // "D" (U+0044)
  0x6F, 0xE8, 0x06, 0xB2, 0xE4, 0x6A, 0x0A, 0x76, 0xA0, 0xA7, 0x6B, 0x2E, 0x36, 0xFE, 0x70,
  // "E" (U+0045)
  0x6F, 0xF5, 0x6B, 0x00, 0x6F, 0xE3, 0x6B, 0x10, 0x6B, 0x00, 0x6F, 0xF5,
  // "F" (U+0046)
  0x6F, 0xF5, 0x6B, 0x00, 0x6F, 0xE3, 0x6B, 0x10, 0x6A, 0x00, 0x6A, 0x00,
  // "G" (U+0047)
  0x08, 0xEE, 0x35, 0xE2, 0x10, 0x89, 0x6E, 0x68, 0x90, 0xA7, 0x5D, 0x1A, 0x70, 0x9E, 0xE5,
  // "H" (U+0048)
  0x6A, 0x09, 0x76, 0xA0, 0x97, 0x6F, 0xEF, 0x76, 0xB1, 0xA7, 0x6A, 0x09, 0x76, 0xA0, 0x97,
  // "I" (U+0049)
  0xAF, 0x72, 0xE0, 0x2E, 0x02, 0xE0, 0x2E, 0x09, 0xF6,
  // "J" (U+004A)
  0x06, 0xA0, 0x6A, 0x06, 0xA0, 0x6A, 0x06, 0xA0, 0x6A, 0x08, 0xA7, 0xF5,
  // "K" (U+004B)
  0x6A, 0x1E, 0x36, 0xA9, 0x90, 0x6D, 0xF1, 0x06, 0xEE, 0x40, 0x6A, 0x7B, 0x06, 0xA0, 0xE3,
  // "L" (U+004C)
  0x6A, 0x00, 0x6A, 0x00, 0x6A, 0x00, 0x6A, 0x00, 0x6B, 0x10, 0x6F, 0xF7,
  // "M" (U+004D)
  0x6F, 0x30, 0xAF, 0x6F, 0x80, 0xDF, 0x6B, 0xC3, 0xBF, 0x69, 0xD8, 0x7F, 0x69, 0x9F, 0x3F, 0x69,
  0x5D, 0x1F,
  // "N" (U+004E)
  0x6F, 0x22, 0xD6, 0xF9, 0x2D, 0x6A, 0xE4, 0xD6, 0x99, 0xAD, 0x69, 0x2F, 0xD6, 0x90, 0xBD,
  // "O" (U+004F)
  0x0A, 0xEC, 0x15, 0xD1, 0xA9, 0x89, 0x05, 0xB8, 0x90, 0x5B, 0x5D, 0x1A, 0x90, 0xAF, 0xC1,
  // "P" (U+0050)
  0x6F, 0xE6, 0x6B, 0x5D, 0x6A, 0x4D, 0x6F, 0xF6, 0x6B, 0x00, 0x6A, 0x00,
  // "Q" (U+0051)
  0x0A, 0xEB, 0x15, 0xD1, 0xA9, 0x89, 0x05, 0xC8, 0x90, 0x5C, 0x5D, 0x1A, 0x90, 0xAF, 0xE1, 0x00,
  0x1E, 0x20, 0x00, 0x54,
  // "R" (U+0052)
  0x6F, 0xE8, 0x06, 0xB5, 0xE0, 0x6F, 0xF7, 0x06, 0xBB, 0x60, 0x6A, 0x5C, 0x06, 0xA0, 0xE3,
  // "S" (U+0053)
  0x3D, 0xE4, 0x99, 0x11, 0x6E, 0x50, 0x05, 0xE4, 0x31, 0xB6, 0x9F, 0xC1,
  // "T" (U+0054)
  0xDF, 0xFA, 0x0A, 0x70, 0x0A, 0x70, 0x0A, 0x70, 0x0A, 0x70, 0x0A, 0x70,
  // "U" (U+0055)
  0x7A, 0x0A, 0x67, 0xA0, 0xA6, 0x7A, 0x0A, 0x67, 0xA0, 0xA6, 0x5C, 0x2D, 0x50, 0xBE, 0xB0,
  // "V" (U+0056)
  0xD4, 0x0D, 0x49, 0x71, 0xF0, 0x5B, 0x5C, 0x01, 0xE8, 0x70, 0x0C, 0xD3, 0x00, 0x8E, 0x00,
  // "W" (U+0057)
  0xD3, 0x4E, 0x08, 0x8A, 0x67, 0xF1, 0xB5, 0x79, 0xAC, 0x5E, 0x24, 0xBD, 0x69, 0xE0, 0x1E, 0xC2,
  0xEB, 0x00, 0xD9, 0x0E, 0x80,
  // "X" (U+0058)
  0xA7, 0x4D, 0x03, 0xDA, 0x60, 0x0B, 0xE0, 0x00, 0xCE, 0x10, 0x4D, 0xA7, 0x0B, 0x63, 0xE1,
  // "Y" (U+0059)
  0xC5, 0x3E, 0x6B, 0x98, 0x0E, 0xE2, 0x09, 0xB0, 0x07, 0x90, 0x07, 0x90,
  // "Z" (U+005A)
  0xBF, 0xF8, 0x00, 0xE3, 0x07, 0xB0, 0x0E, 0x30, 0x7A, 0x00, 0xCF, 0xF9,
  // "[" (U+005B)
  0x8F, 0x58, 0x70, 0x87, 0x08, 0x70, 0x87, 0x08, 0x70, 0x87, 0x08, 0xE4, 0x01, 0x00,
  // "\" (U+005C)
  0xB3, 0x06, 0x80, 0x1D, 0x00, 0xA4, 0x05, 0xA0, 0x0D,
  // "]" (U+005D)
  0xCF, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0xBF, 0x11,
  // "^" (U+005E)
  0x06, 0x80, 0x0C, 0xD0, 0x4A, 0x76, 0xA4, 0x1C,
  // "_" (U+005F)
  0xEE, 0xE9, 0x11, 0x10,
  // "`" (U+0060)
  0x45, 0x01, 0xC1,
  // "a" (U+0061)
  0x3D, 0xE3, 0x02, 0x98, 0x4D, 0xE8, 0xA9, 0xA8, 0x6E, 0xA8,
  // "b" (U+0062)
  0x79, 0x00, 0x78, 0x00, 0x7C, 0xE7, 0x7B, 0x4D, 0x79, 0x1F, 0x7B, 0x4D, 0x7B, 0xE7,
  // "c" (U+0063)
  0x1C, 0xE1, 0x89, 0x10, 0xA6, 0x00, 0x89, 0x10, 0x2D, 0xE1,
  // "d" (U+0064)
  0x00, 0x4C, 0x00, 0x4C, 0x2E, 0xBC, 0x89, 0x6C, 0xA6, 0x3C, 0x99, 0x6C, 0x3E, 0xAC,
  // "e" (U+0065)
  0x2D, 0xD2, 0x88, 0x78, 0xAE, 0xEA, 0x8A, 0x22, 0x1C, 0xE5,
  // "f" (U+0066)
  0x1D, 0xA5, 0xC0, 0xCF, 0x85, 0xB0, 0x5B, 0x05, 0xB0, 0x5B, 0x00,
  // "g" (U+0067)
  0x2E, 0xAC, 0x89, 0x6C, 0xA6, 0x3C, 0x99, 0x6C, 0x3E, 0xBC, 0x11, 0x7A, 0x5E, 0xD3,
  // "h" (U+0068)
  0x79, 0x00, 0x78, 0x00, 0x7C, 0xE7, 0x7B, 0x4D, 0x79, 0x2D, 0x79, 0x2D, 0x79, 0x2D,
  // "i" (U+0069)
  0x67, 0x00, 0x79, 0x79, 0x79, 0x79, 0x79,
  // "j" (U+006A)
  0x06, 0x70, 0x00, 0x07, 0x90, 0x79, 0x07, 0x90, 0x79, 0x07, 0x90, 0x98, 0x4E, 0x40,
  // "k" (U+006B)
  0x79, 0x00, 0x79, 0x00, 0x79, 0x6B, 0x7A, 0xE2, 0x7F, 0xE0, 0x7A, 0xB6, 0x79, 0x4D,
  // "l" (U+006C)
  0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79,
  // "m" (U+006D)
  0x79, 0xE6, 0xCA, 0x07, 0xB5, 0xE3, 0xF0, 0x79, 0x4C, 0x0F, 0x17, 0x94, 0xC0, 0xF1, 0x79, 0x4C,
  0x0F, 0x10,
  // "n" (U+006E)
  0x7B, 0xE7, 0x7B, 0x5D, 0x79, 0x2D, 0x79, 0x2D, 0x79, 0x2D,
  // "o" (U+006F)
  0x1D, 0xE3, 0x89, 0x6B, 0xA6, 0x3D, 0x89, 0x6B, 0x1D, 0xE3,
  // "p" (U+0070)
  0x7A, 0xE7, 0x7B, 0x4D, 0x79, 0x1F, 0x7B, 0x4D, 0x7C, 0xE6, 0x78, 0x00, 0x79, 0x00,
  // "q" (U+0071)
  0x2E, 0xAC, 0x89, 0x6C, 0xA6, 0x3C, 0x99, 0x6C, 0x3E, 0xBC, 0x00, 0x4C, 0x00, 0x4C,
  // "r" (U+0072)
  0x7A, 0xC7, 0xC0, 0x79, 0x07, 0x90, 0x79, 0x00,
  // "s" (U+0073)
  0x5E, 0xBA, 0x82, 0x3E, 0x82, 0x3F, 0x9F, 0x90,
  // "t" (U+0074)
  0x2A, 0x0B, 0xF9, 0x6A, 0x06, 0xA0, 0x6B, 0x02, 0xE9,
  // "u" (U+0075)
  0x89, 0x3D, 0x89, 0x3D, 0x89, 0x3D, 0x7A, 0x5D, 0x2E, 0xAD,
  // "v" (U+0076)
  0xD3, 0x6A, 0x97, 0x96, 0x5A, 0xD2, 0x1D, 0xD0, 0x0C, 0x90,
  // "w" (U+0077)
  0xD3, 0xBA, 0x5B, 0x96, 0xCC, 0x88, 0x6A, 0xBC, 0xA4, 0x3E, 0x8A, 0xE1, 0x0F, 0x58, 0xD0,
  // "x" (U+0078)
  0xA7, 0xA7, 0x3D, 0xE1, 0x0D, 0xB0, 0x4D, 0xE1, 0xB6, 0x98,
  // "y" (U+0079)
  0xD4, 0x6A, 0x88, 0x96, 0x4B, 0xD2, 0x0E, 0xD0, 0x0A, 0x90, 0x1C, 0x50, 0xAB, 0x00,
  // "z" (U+007A)
  0xBF, 0xE0, 0x79, 0x0E, 0x27, 0xA0, 0xCF, 0xF0,
  // "{" (U+007B)
  0x09, 0xB0, 0xE2, 0x1F, 0x0C, 0x90, 0x3E, 0x00, 0xE0, 0x0E, 0x10, 0xAB,
  // "|" (U+007C)
  0x94, 0x94, 0x94, 0x94, 0x94, 0x94, 0x94, 0x94, 0x94,
  // "}" (U+007D)
  0xB9, 0x02, 0xE0, 0x0F, 0x10, 0xAC, 0x0E, 0x30, 0xE0, 0x1E, 0x0B, 0x90,
  // "~" (U+007E)
  0xAE, 0xEA, 0x11, 0x11,
  // "¡" (U+00A1)
  0x68, 0x00, 0x68, 0x78, 0x79, 0x8A,
  // "¢" (U+00A2)
  0x0C, 0xF4, 0x5C, 0x10, 0x79, 0x00, 0x6B, 0x00, 0x1E, 0xD5, 0x01, 0x80,
  // "£" (U+00A3)
  0x0A, 0xE6, 0x1F, 0x10, 0x9F, 0xE2, 0x2F, 0x10, 0x4C, 0x00, 0x9F, 0xFB,
  // "¤" (U+00A4)
  0x00, 0x01, 0x6D, 0xDC, 0x39, 0x39, 0x38, 0x1A, 0x6E, 0xEB, 0x10, 0x01,
  // "¥" (U+00A5)
  0xB6, 0x6B, 0x5B, 0xB5, 0x0E, 0xE0, 0x7F, 0xF7, 0x7F, 0xF7, 0x09, 0x80,
  // "¦" (U+00A6)
  0x94, 0x94, 0x94, 0x00, 0x00, 0x00, 0x94, 0x94, 0x94,
  // "§" (U+00A7)
  0x4E, 0xC8, 0x82, 0x4E, 0x88, 0x5D, 0x2C, 0xC2, 0x1E, 0x7E, 0xA0,
  // "¨" (U+00A8)
  0x1A, 0x83,
  // "©" (U+00A9)
  0x02, 0x88, 0x60, 0x01, 0x97, 0xD7, 0x80, 0x72, 0xC2, 0x17, 0x18, 0x39, 0x00, 0x53, 0x73, 0xB0,
  0x07, 0x11, 0xAA, 0xF8, 0x80, 0x02, 0x88, 0x60, 0x00,
  // "ª" (U+00AA)
  0x5B, 0x48, 0xA6, 0x78, 0x50,
  // "«" (U+00AB)
  0x0B, 0x2B, 0x89, 0xB7, 0x4C, 0x7A, 0x05, 0x16,
  // "¬" (U+00AC)
  0xAE, 0xEA, 0x11, 0x3A, 0x00, 0x16,
  // "®" (U+00AE)
  0x02, 0x88, 0x60, 0x01, 0x9C, 0xD5, 0x80, 0x71, 0xC6, 0x77, 0x18, 0x0D, 0xF3, 0x53, 0x71, 0xC8,
  0x47, 0x11, 0xA5, 0x17, 0x80, 0x02, 0x88, 0x60, 0x00,
  // "¯" (U+00AF)
  0xEE, 0xEC, 0x11, 0x11,
  // "°" (U+00B0)
  0x4D, 0x5A, 0x3A, 0x6F, 0x70,
  // "±" (U+00B1)
  0x06, 0x60, 0x06, 0x60, 0xAE, 0xEA, 0x17, 0x71, 0x00, 0x00, 0xBF, 0xFB,
  // "²" (U+00B2)
  0x7C, 0x20, 0x84, 0x3A, 0x0A, 0xC5,
  // "³" (U+00B3)
  0x7B, 0x21, 0x74, 0x2D, 0x27, 0xB3,
  // "´" (U+00B4)
  0x4A, 0x10,
  // "µ" (U+00B5)
  0x79, 0x3D, 0x79, 0x3D, 0x79, 0x3D, 0x7A, 0x6D, 0x7E, 0xBD, 0x78, 0x00, 0x79, 0x00,
  // "¶" (U+00B6)
  0x2E, 0xFC, 0x8F, 0xA9, 0x9F, 0xA9, 0x7F, 0xA9, 0x18, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99,
  // "·" (U+00B7)
  0x68,
  // "¸" (U+00B8)
  0x01, 0x00, 0x94, 0x1B, 0x40,
  // "¹" (U+00B9)
  0x4E, 0x11, 0xB1, 0x0B, 0x10,
  // "º" (U+00BA)
  0x7B, 0x4B, 0x38, 0x5A, 0x30,
  // "»" (U+00BB)
  0x76, 0x93, 0x1E, 0x6D, 0x4C, 0x7A, 0x42, 0x51,
  // "¼" (U+00BC)
  0x3E, 0x00, 0xC0, 0x05, 0xD0, 0x57, 0x00, 0x0C, 0x0C, 0x15, 0x00, 0xC4, 0x85, 0xD0, 0x00, 0xB2,
  0x9C, 0x00, 0x39, 0x2C, 0xE4, 0x02, 0x10, 0x04, 0x00,
  // "½" (U+00BD)
  0x5E, 0x01, 0xC0, 0x02, 0xC0, 0x75, 0x00, 0x0C, 0x0C, 0x9C, 0x10, 0xC7, 0x64, 0xB1, 0x00, 0xC0,
  0x57, 0x00, 0x67, 0x0E, 0xE4, 0x01, 0x00, 0x11, 0x00,
  // "¾" (U+00BE)
  0x5B, 0x30, 0xA1, 0x02, 0xD2, 0x39, 0x00, 0x15, 0x6A, 0x3A, 0x08, 0xB5, 0xA6, 0xE0, 0x00, 0xA3,
  0x9C, 0x00, 0x2B, 0x2C, 0xE4, 0x02, 0x20, 0x04, 0x00,
  // "¿" (U+00BF)
  0x0C, 0x20, 0x30, 0x1E, 0x0C, 0x60, 0xF1, 0x29, 0xEA,
  // "À" (U+00C0)
  0x04, 0x50, 0x00, 0x1C, 0x10, 0x08, 0xF2, 0x00, 0xCA, 0x60, 0x1D, 0x4A, 0x05, 0xFE, 0xE0, 0x98,
  0x2D, 0x3D, 0x40, 0xA7,
  // "Á" (U+00C1)
  0x04, 0xA0, 0x00, 0x10, 0x00, 0x08, 0xF2, 0x00, 0xCA, 0x60, 0x1D, 0x4A, 0x05, 0xFE, 0xE0, 0x98,
  0x2D, 0x3D, 0x40, 0xA7,
  // "Â" (U+00C2)
  0x00, 0x72, 0x00, 0x68, 0xB0, 0x08, 0xF2, 0x00, 0xCA, 0x60, 0x1D, 0x4A, 0x05, 0xFE, 0xE0, 0x98,
  0x2D, 0x3D, 0x40, 0xA7,
  // "Ã" (U+00C3)
  0x06, 0xDB, 0x00, 0x8F, 0x20, 0x0C, 0xA6, 0x01, 0xD4, 0xA0, 0x5F, 0xEE, 0x09, 0x82, 0xD3, 0xD4,
  0x0A, 0x70,
  // "Ä" (U+00C4)
  0x1A, 0x83, 0x00, 0x00, 0x00, 0x08, 0xF2, 0x00, 0xCA, 0x60, 0x1D, 0x4A, 0x05, 0xFE, 0xE0, 0x98,
  0x2D, 0x3D, 0x40, 0xA7,
  // "Å" (U+00C5)
  0x06, 0xC1, 0x00, 0xFF, 0x30, 0x0C, 0xB6, 0x01, 0xD4, 0xA0, 0x5F, 0xEE, 0x09, 0x82, 0xD3, 0xD4,
  0x0A, 0x70,
  // "Æ" (U+00C6)
  0x03, 0xFF, 0xFC, 0x08, 0x8F, 0x10, 0x0D, 0x2F, 0xE9, 0x3F, 0xEF, 0x20, 0x88, 0x1F, 0x10, 0xD4,
  0x0F, 0xFC,
  // "Ç" (U+00C7)
  0x09, 0xEB, 0x5D, 0x12, 0x89, 0x00, 0x89, 0x00, 0x5D, 0x12, 0x0A, 0xFB, 0x00, 0x94, 0x01, 0xB4,
  // "È" (U+00C8)
  0x45, 0x00, 0x1C, 0x10, 0x6F, 0xF5, 0x6B, 0x00, 0x6F, 0xE3, 0x6B, 0x10, 0x6B, 0x00, 0x6F, 0xF5,
  // "É" (U+00C9)
  0x04, 0xA0, 0x01, 0x00, 0x6F, 0xF5, 0x6B, 0x00, 0x6F, 0xE3, 0x6B, 0x10, 0x6B, 0x00, 0x6F, 0xF5,
  // "Ê" (U+00CA)
  0x07, 0x20, 0x68, 0xB0, 0x6F, 0xF5, 0x6B, 0x00, 0x6F, 0xE3, 0x6B, 0x10, 0x6B, 0x00, 0x6F, 0xF5,
  // "Ë" (U+00CB)
  0x1A, 0x83, 0x00, 0x00, 0x6F, 0xF5, 0x6B, 0x00, 0x6F, 0xE3, 0x6B, 0x10, 0x6B, 0x00, 0x6F, 0xF5,
  // "Ì" (U+00CC)
  0x45, 0x01, 0xC1, 0xAF, 0x72, 0xE0, 0x2E, 0x02, 0xE0, 0x2E, 0x09, 0xF6,
  // "Í" (U+00CD)
  0x04, 0xA0, 0x10, 0xAF, 0x72, 0xE0, 0x2E, 0x02, 0xE0, 0x2E, 0x09, 0xF6,
  // "Î" (U+00CE)
  0x07, 0x26, 0x8B, 0xAF, 0x72, 0xE0, 0x2E, 0x02, 0xE0, 0x2E, 0x09, 0xF6,
  // "Ï" (U+00CF)
  0x1A, 0x83, 0x00, 0x00, 0x0A, 0xF7, 0x02, 0xE0, 0x02, 0xE0, 0x02, 0xE0, 0x02, 0xE0, 0x09, 0xF6,
  // "Ð" (U+00D0)
  0x6F, 0xE8, 0x06, 0xB2, 0xE4, 0xDF, 0x6A, 0x77, 0xB0, 0xA7, 0x6B, 0x2E, 0x36, 0xFE, 0x70,
  // "Ñ" (U+00D1)
  0x06, 0xDB, 0x06, 0xF2, 0x2D, 0x6F, 0x92, 0xD6, 0xAE, 0x4D, 0x69, 0x9A, 0xD6, 0x92, 0xFD, 0x69,
  0x0B, 0xD0,
  // "Ò" (U+00D2)
  0x04, 0x50, 0x00, 0x1C, 0x10, 0x0A, 0xEC, 0x15, 0xD1, 0xA9, 0x89, 0x05, 0xB8, 0x90, 0x5B, 0x5D,
  0x1A, 0x90, 0xAF, 0xC1,
  // "Ó" (U+00D3)
  0x00, 0x4A, 0x00, 0x01, 0x00, 0x0A, 0xEC, 0x15, 0xD1, 0xA9, 0x89, 0x05, 0xB8, 0x90, 0x5B, 0x5D,
  0x1A, 0x90, 0xAF, 0xC1,
  // "Ô" (U+00D4)
  0x00, 0x72, 0x00, 0x68, 0xB0, 0x0A, 0xEC, 0x15, 0xD1, 0xA9, 0x89, 0x05, 0xB8, 0x90, 0x5B, 0x5D,
  0x1A, 0x90, 0xAF, 0xC1,
  // "Õ" (U+00D5)
  0x06, 0xDB, 0x00, 0xAE, 0xC1, 0x5D, 0x1A, 0x98, 0x90, 0x5B, 0x89, 0x05, 0xB5, 0xD1, 0xA9, 0x0A,
  0xFC, 0x10,
  // "Ö" (U+00D6)
  0x01, 0xA8, 0x30, 0x00, 0x00, 0x0A, 0xEC, 0x15, 0xD1, 0xA9, 0x89, 0x05, 0xB8, 0x90, 0x5B, 0x5D,
  0x1A, 0x90, 0xAF, 0xC1,
  // "×" (U+00D7)
  0x21, 0x12, 0x4C, 0xC4, 0x1C, 0xC1, 0x54, 0x45,
  // "Ø" (U+00D8)
  0x48, 0xB7, 0x10, 0xAE, 0xD5, 0x5D, 0x1E, 0x88, 0x96, 0xAC, 0x89, 0xA5, 0xC5, 0xF4, 0xA9, 0x1E,
  0xEB, 0x10, 0x13,
  // "Ù" (U+00D9)
  0x04, 0x50, 0x00, 0x1C, 0x10, 0x7A, 0x0A, 0x67, 0xA0, 0xA6, 0x7A, 0x0A, 0x67, 0xA0, 0xA6, 0x5C,
  0x2D, 0x50, 0xBE, 0xB0,
  // "Ú" (U+00DA)
  0x00, 0x4A, 0x00, 0x01, 0x00, 0x7A, 0x0A, 0x67, 0xA0, 0xA6, 0x7A, 0x0A, 0x67, 0xA0, 0xA6, 0x5C,
  0x2D, 0x50, 0xBE, 0xB0,
  // "Û" (U+00DB)
  0x00, 0x72, 0x00, 0x68, 0xB0, 0x7A, 0x0A, 0x67, 0xA0, 0xA6, 0x7A, 0x0A, 0x67, 0xA0, 0xA6, 0x5C,
  0x2D, 0x50, 0xBE, 0xB0,
  // "Ü" (U+00DC)
  0x1A, 0x83, 0x00, 0x00, 0x00, 0x7A, 0x0A, 0x67, 0xA0, 0xA6, 0x7A, 0x0A, 0x67, 0xA0, 0xA6, 0x5C,
  0x2D, 0x50, 0xBE, 0xB0,
  // "Ý" (U+00DD)
  0x04, 0xA0, 0x01, 0x00, 0xC5, 0x3E, 0x6B, 0x98, 0x0E, 0xE2, 0x09, 0xB0, 0x07, 0x90, 0x07, 0x90,
  // "Þ" (U+00DE)
  0x6A, 0x00, 0x6F, 0xD5, 0x6B, 0x6D, 0x6A, 0x4D, 0x6F, 0xF6, 0x6B, 0x00,
  // "ß" (U+00DF)
  0x1C, 0xE8, 0x06, 0xB3, 0xF0, 0x79, 0x7A, 0x07, 0x9D, 0x50, 0x79, 0x5E, 0x27, 0x91, 0xB6, 0x79,
  0xED, 0x20,
  // "à" (U+00E0)
  0x45, 0x00, 0x1C, 0x10, 0x3D, 0xE3, 0x02, 0x98, 0x4D, 0xE8, 0xA9, 0xA8, 0x6E, 0xA8,
  // "á" (U+00E1)
  0x04, 0xA0, 0x01, 0x00, 0x3D, 0xE3, 0x02, 0x98, 0x4D, 0xE8, 0xA9, 0xA8, 0x6E, 0xA8,
  // "â" (U+00E2)
  0x07, 0x20, 0x68, 0xB0, 0x3D, 0xE3, 0x02, 0x98, 0x4D, 0xE8, 0xA9, 0xA8, 0x6E, 0xA8,
  // "ã" (U+00E3)
  0x6D, 0xB0, 0x3D, 0xE3, 0x02, 0x98, 0x4D, 0xE8, 0xA9, 0xA8, 0x6E, 0xA8,
  // "ä" (U+00E4)
  0x1A, 0x83, 0x00, 0x00, 0x3D, 0xE3, 0x02, 0x98, 0x4D, 0xE8, 0xA9, 0xA8, 0x6E, 0xA8,
  // "å" (U+00E5)
  0x06, 0xC1, 0x08, 0xE1, 0x3E, 0xE3, 0x02, 0x98, 0x4D, 0xE8, 0xA9, 0xA8, 0x6E, 0xA8,
  // "æ" (U+00E6)
  0x3D, 0xDB, 0xE3, 0x02, 0xAA, 0x5A, 0x4D, 0xEE, 0xEC, 0xA9, 0xAB, 0x22, 0x6E, 0x7A, 0xE7,
  // "ç" (U+00E7)
  0x1C, 0xE1, 0x89, 0x10, 0xA6, 0x00, 0x89, 0x10, 0x2E, 0xE1, 0x09, 0x40, 0x1B, 0x40,
  // "è" (U+00E8)
  0x45, 0x00, 0x1C, 0x10, 0x2D, 0xD2, 0x88, 0x78, 0xAE, 0xEA, 0x8A, 0x22, 0x1C, 0xE5,
  // "é" (U+00E9)
  0x04, 0xA0, 0x01, 0x00, 0x2D, 0xD2, 0x88, 0x78, 0xAE, 0xEA, 0x8A, 0x22, 0x1C, 0xE5,
  // "ê" (U+00EA)
  0x07, 0x20, 0x68, 0xB0, 0x2D, 0xD2, 0x88, 0x78, 0xAE, 0xEA, 0x8A, 0x22, 0x1C, 0xE5,
  // "ë" (U+00EB)
  0x1A, 0x83, 0x00, 0x00, 0x2D, 0xD2, 0x88, 0x78, 0xAE, 0xEA, 0x8A, 0x22, 0x1C, 0xE5,
  // "ì" (U+00EC)
  0x45, 0x01, 0xC1, 0x07, 0x90, 0x79, 0x07, 0x90, 0x79, 0x07, 0x90,
  // "í" (U+00ED)
  0x4A, 0x10, 0x79, 0x79, 0x79, 0x79, 0x79,
  // "î" (U+00EE)
  0x07, 0x26, 0x8B, 0x07, 0x90, 0x79, 0x07, 0x90, 0x79, 0x07, 0x90,
  // "ï" (U+00EF)
  0x1A, 0x83, 0x00, 0x00, 0x07, 0x90, 0x07, 0x90, 0x07, 0x90, 0x07, 0x90, 0x07, 0x90,
  // "ð" (U+00F0)
  0x02, 0x21, 0x09, 0xE1, 0x06, 0xB4, 0x1C, 0xDA, 0x8A, 0x7D, 0xA6, 0x3D, 0x89, 0x6B, 0x1D, 0xD3,
  // "ñ" (U+00F1)
  0x06, 0xDB, 0x7B, 0xE7, 0x7B, 0x5D, 0x79, 0x2D, 0x79, 0x2D, 0x79, 0x2D,
  // "ò" (U+00F2)
  0x04, 0x50, 0x01, 0xC1, 0x1D, 0xE3, 0x89, 0x6B, 0xA6, 0x3D, 0x89, 0x6B, 0x1D, 0xE3,
  // "ó" (U+00F3)
  0x04, 0xA0, 0x01, 0x00, 0x1D, 0xE3, 0x89, 0x6B, 0xA6, 0x3D, 0x89, 0x6B, 0x1D, 0xE3,
  // "ô" (U+00F4)
  0x07, 0x20, 0x68, 0xB0, 0x1D, 0xE3, 0x89, 0x6B, 0xA6, 0x3D, 0x89, 0x6B, 0x1D, 0xE3,
  // "õ" (U+00F5)
  0x6D, 0xB0, 0x1D, 0xE3, 0x89, 0x6B, 0xA6, 0x3D, 0x89, 0x6B, 0x1D, 0xE3,
  // "ö" (U+00F6)
  0x1A, 0x83, 0x00, 0x00, 0x1D, 0xE3, 0x89, 0x6B, 0xA6, 0x3D, 0x89, 0x6B, 0x1D, 0xE3,
  // "÷" (U+00F7)
  0x05, 0x60, 0xAE, 0xEA, 0x11, 0x11, 0x05, 0x60,
  // "ø" (U+00F8)
  0x00, 0x01, 0x1C, 0xD8, 0x88, 0xBB, 0xA9, 0x9D, 0x8E, 0x6B, 0x4E, 0xE3, 0x11, 0x00,
  // "ù" (U+00F9)
  0x04, 0x50, 0x01, 0xC1, 0x89, 0x3D, 0x89, 0x3D, 0x89, 0x3D, 0x7A, 0x5D, 0x2E, 0xAD,
  // "ú" (U+00FA)
  0x04, 0xA0, 0x01, 0x00, 0x89, 0x3D, 0x89, 0x3D, 0x89, 0x3D, 0x7A, 0x5D, 0x2E, 0xAD,
  // "û" (U+00FB)
  0x00, 0x72, 0x06, 0x8B, 0x89, 0x3D, 0x89, 0x3D, 0x89, 0x3D, 0x7A, 0x5D, 0x2E, 0xAD,
  // "ü" (U+00FC)
  0x1A, 0x83, 0x00, 0x00, 0x89, 0x3D, 0x89, 0x3D, 0x89, 0x3D, 0x7A, 0x5D, 0x2E, 0xAD,
  // "ý" (U+00FD)
  0x04, 0xA0, 0x01, 0x00, 0xD4, 0x6A, 0x88, 0x96, 0x4B, 0xD2, 0x0E, 0xD0, 0x0A, 0x90, 0x1C, 0x50,
  0xAB, 0x00,
  // "þ" (U+00FE)
  0x79, 0x00, 0x78, 0x00, 0x7C, 0xE7, 0x7B, 0x4D, 0x79, 0x1F, 0x7B, 0x4D, 0x7C, 0xE7, 0x79, 0x00,
  0x79, 0x00,
  // "ÿ" (U+00FF)
  0x1A, 0x83, 0x00, 0x00, 0xD4, 0x6A, 0x88, 0x96, 0x4B, 0xD2, 0x0E, 0xD0, 0x0A, 0x90, 0x1C, 0x50,
  0xAB, 0x00,
  // "Ā" (U+0100)
  0x09, 0xE9, 0x00, 0x11, 0x00, 0x08, 0xF2, 0x00, 0xCA, 0x60, 0x1D, 0x4A, 0x05, 0xFE, 0xE0, 0x98,
  0x2D, 0x3D, 0x40, 0xA7,
  // "ā" (U+0101)
  0x09, 0xE9, 0x01, 0x10, 0x3D, 0xE3, 0x02, 0x98, 0x4D, 0xE8, 0xA9, 0xA8, 0x6E, 0xA8,
  // "Ă" (U+0102)
  0x04, 0x04, 0x00, 0x6F, 0x80, 0x08, 0xF2, 0x00, 0xCA, 0x60, 0x1D, 0x4A, 0x05, 0xFE, 0xE0, 0x98,
  0x2D, 0x3D, 0x40, 0xA7,
  // "ă" (U+0103)
  0x40, 0x40, 0x6F, 0x80, 0x3E, 0xE3, 0x02, 0x98, 0x4D, 0xE8, 0xA9, 0xA8, 0x6E, 0xA8,
  // "Ą" (U+0104)
  0x08, 0xF2, 0x00, 0xCA, 0x60, 0x1D, 0x4A, 0x05, 0xFE, 0xE0, 0x98, 0x2D, 0x3D, 0x40, 0xB9, 0x00,
  0x07, 0x30, 0x00, 0x8B,
  // "ą" (U+0105)
  0x3D, 0xE3, 0x02, 0x98, 0x4D, 0xE8, 0xA9, 0xA8, 0x6E, 0xAB, 0x00, 0x73, 0x00, 0x8B,
  // "Ć" (U+0106)
  0x00, 0x4A, 0x00, 0x10, 0x09, 0xEB, 0x5D, 0x12, 0x89, 0x00, 0x89, 0x00, 0x5D, 0x12, 0x0A, 0xEB,
  // "ć" (U+0107)
  0x04, 0xA0, 0x01, 0x00, 0x1C, 0xE1, 0x89, 0x10, 0xA6, 0x00, 0x89, 0x10, 0x2D, 0xE1,
  // "Ĉ" (U+0108)
  0x00, 0x72, 0x06, 0x8B, 0x09, 0xEB, 0x5D, 0x12, 0x89, 0x00, 0x89, 0x00, 0x5D, 0x12, 0x0A, 0xEB,
  // "ĉ" (U+0109)
  0x07, 0x20, 0x68, 0xB0, 0x1C, 0xE1, 0x89, 0x10, 0xA6, 0x00, 0x89, 0x10, 0x2D, 0xE1,
  // "Ċ" (U+010A)
  0x00, 0x85, 0x00, 0x00, 0x09, 0xEB, 0x5D, 0x12, 0x89, 0x00, 0x89, 0x00, 0x5D, 0x12, 0x0A, 0xEB,
  // "ċ" (U+010B)
  0x08, 0x50, 0x00, 0x00, 0x1C, 0xE1, 0x89, 0x10, 0xA6, 0x00, 0x89, 0x10, 0x2D, 0xE1,
  // "Č" (U+010C)
  0x04, 0x16, 0x02, 0xE7, 0x09, 0xEB, 0x5D, 0x12, 0x89, 0x00, 0x89, 0x00, 0x5D, 0x12, 0x0A, 0xEB,
  // "č" (U+010D)
  0x41, 0x60, 0x2E, 0x70, 0x1C, 0xE1, 0x89, 0x10, 0xA6, 0x00, 0x89, 0x10, 0x2D, 0xE1,
  // "Ď" (U+010E)
  0x04, 0x16, 0x00, 0x2E, 0x70, 0x6F, 0xE8, 0x06, 0xB2, 0xE4, 0x6A, 0x0A, 0x76, 0xA0, 0xA7, 0x6B,
  0x2E, 0x36, 0xFE, 0x70,
  // "ď" (U+010F)
  0x00, 0x4C, 0xC1, 0x00, 0x4C, 0x00, 0x2E, 0xBC, 0x00, 0x89, 0x6C, 0x00, 0xA6, 0x3C, 0x00, 0x99,
  0x6C, 0x00, 0x3E, 0xAC, 0x00,
  // "Đ" (U+0110)
  0x6F, 0xE8, 0x06, 0xB2, 0xE4, 0xDF, 0x6A, 0x77, 0xB0, 0xA7, 0x6B, 0x2E, 0x36, 0xFE, 0x70,
  // "đ" (U+0111)
  0x00, 0x4C, 0x00, 0x2E, 0xF4, 0x2E, 0xBC, 0x08, 0x96, 0xC0, 0xA6, 0x3C, 0x08, 0x96, 0xC0, 0x3E,
  0xBC, 0x00,
  // "Ē" (U+0112)
  0x9E, 0x90, 0x11, 0x00, 0x6F, 0xF5, 0x6B, 0x00, 0x6F, 0xE3, 0x6B, 0x10, 0x6B, 0x00, 0x6F, 0xF5,
  // "ē" (U+0113)
  0x09, 0xE9, 0x01, 0x10, 0x2D, 0xD2, 0x88, 0x78, 0xAE, 0xEA, 0x8A, 0x22, 0x1C, 0xE5,
  // "Ĕ" (U+0114)
  0x40, 0x40, 0x6F, 0x80, 0x6F, 0xF5, 0x6B, 0x00, 0x6F, 0xE3, 0x6B, 0x10, 0x6B, 0x00, 0x6F, 0xF5,
  // "ĕ" (U+0115)
  0x40, 0x40, 0x6F, 0x80, 0x2D, 0xD2, 0x88, 0x78, 0xAE, 0xEA, 0x8A, 0x22, 0x1C, 0xE5,
  // "Ė" (U+0116)
  0x08, 0x50, 0x00, 0x00, 0x6F, 0xF5, 0x6B, 0x00, 0x6F, 0xE3, 0x6B, 0x10, 0x6B, 0x00, 0x6F, 0xF5,
  // "ė" (U+0117)
  0x08, 0x50, 0x00, 0x00, 0x2D, 0xD2, 0x88, 0x78, 0xAE, 0xEA, 0x8A, 0x22, 0x1C, 0xE5,
  // "Ę" (U+0118)
  0x6F, 0xF5, 0x6B, 0x00, 0x6F, 0xE3, 0x6B, 0x10, 0x6B, 0x00, 0x6F, 0xF7, 0x00, 0x73, 0x00, 0x8B,
  // "ę" (U+0119)
  0x2D, 0xD2, 0x88, 0x78, 0xAE, 0xEA, 0x8A, 0x22, 0x1C, 0xF6, 0x00, 0xB0, 0x00, 0xC7,
  // "Ě" (U+011A)
  0x41, 0x60, 0x2E, 0x70, 0x6F, 0xF5, 0x6B, 0x00, 0x6F, 0xE3, 0x6B, 0x10, 0x6B, 0x00, 0x6F, 0xF5,
  // "ě" (U+011B)
  0x41, 0x60, 0x2E, 0x70, 0x2D, 0xD2, 0x88, 0x78, 0xAE, 0xEA, 0x8A, 0x22, 0x1C, 0xE5,
  // "Ĝ" (U+011C)
  0x00, 0x72, 0x00, 0x68, 0xB0, 0x08, 0xEE, 0x35, 0xE2, 0x10, 0x89, 0x6E, 0x68, 0x90, 0xA7, 0x5D,
  0x1A, 0x70, 0x9E, 0xE5,
  // "ĝ" (U+011D)
  0x00, 0x72, 0x06, 0x8B, 0x2E, 0xAC, 0x89, 0x6C, 0xA6, 0x3C, 0x99, 0x6C, 0x3E, 0xBC, 0x11, 0x7A,
  0x5E, 0xD3,
  // "Ğ" (U+011E)
  0x04, 0x04, 0x00, 0x6F, 0x80, 0x08, 0xFE, 0x35, 0xE2, 0x10, 0x89, 0x6E, 0x68, 0x90, 0xA7, 0x5D,
  0x1A, 0x70, 0x9E, 0xE5,
  // "ğ" (U+011F)
  0x04, 0x04, 0x06, 0xF8, 0x2E, 0xBC, 0x89, 0x6C, 0xA6, 0x3C, 0x99, 0x6C, 0x3E, 0xBC, 0x11, 0x7A,
  0x5E, 0xD3,
  // "Ġ" (U+0120)
  0x20, 0x80, 0x57, 0x8B, 0x38, 0xEE, 0x35, 0xE2, 0x10, 0x89, 0x6E, 0x68, 0x90, 0xA7, 0x5D, 0x1A,
  0x70, 0x9E, 0xE5,
  // "ġ" (U+0121)
  0x08, 0x50, 0x00, 0x00, 0x2E, 0xAC, 0x89, 0x6C, 0xA6, 0x3C, 0x99, 0x6C, 0x3E, 0xBC, 0x11, 0x7A,
  0x5E, 0xD3,
  // "Ģ" (U+0122)
  0x08, 0xEE, 0x35, 0xE2, 0x10, 0x89, 0x6E, 0x68, 0x90, 0xA7, 0x5D, 0x1A, 0x70, 0x9E, 0xE5, 0x00,
  0x00, 0x00, 0x0C, 0x10,
  // "ģ" (U+0123)
  0x03, 0xA0, 0x00, 0x00, 0x2E, 0xAC, 0x89, 0x6C, 0xA6, 0x3C, 0x99, 0x6C, 0x3E, 0xBC, 0x11, 0x7A,
  0x5E, 0xD3,
  // "Ĥ" (U+0124)
  0x00, 0x72, 0x00, 0x68, 0xB0, 0x6A, 0x09, 0x76, 0xA0, 0x97, 0x6F, 0xEF, 0x76, 0xB1, 0xA7, 0x6A,
  0x09, 0x76, 0xA0, 0x97,
  // "ĥ" (U+0125)
  0x07, 0x20, 0x06, 0x8B, 0x00, 0x07, 0x90, 0x00, 0x78, 0x00, 0x07, 0xCE, 0x70, 0x7B, 0x4D, 0x07,
  0x92, 0xD0, 0x79, 0x2D, 0x07, 0x92, 0xD0,
  // "Ħ" (U+0126)
  0xEF, 0xEF, 0xE1, 0x7B, 0x1A, 0x80, 0x6F, 0xEF, 0x80, 0x6B, 0x1A, 0x80, 0x6A, 0x09, 0x80, 0x6A,
  0x09, 0x80,
  // "ħ" (U+0127)
  0x79, 0x00, 0xEF, 0x70, 0x7C, 0xE7, 0x7B, 0x5D, 0x79, 0x3D, 0x79, 0x3D, 0x79, 0x3D,
  // "Ĩ" (U+0128)
  0x6D, 0xBA, 0xF7, 0x2E, 0x02, 0xE0, 0x2E, 0x02, 0xE0, 0x9F, 0x60,
  // "ĩ" (U+0129)
  0x6D, 0xB0, 0x79, 0x07, 0x90, 0x79, 0x07, 0x90, 0x79,
  // "Ī" (U+012A)
  0x9E, 0x91, 0x10, 0xAF, 0x72, 0xE0, 0x2E, 0x02, 0xE0, 0x2E, 0x09, 0xF6,
  // "ī" (U+012B)
  0x9E, 0x91, 0x10, 0x79, 0x07, 0x90, 0x79, 0x07, 0x90, 0x79, 0x00,
  // "Ĭ" (U+012C)
  0x40, 0x46, 0xF8, 0xAF, 0x72, 0xE0, 0x2E, 0x02, 0xE0, 0x2E, 0x09, 0xF6,
  // "ĭ" (U+012D)
  0x40, 0x46, 0xF8, 0x08, 0x90, 0x79, 0x07, 0x90, 0x79, 0x07, 0x90,
  // "Į" (U+012E)
  0xAF, 0x72, 0xE0, 0x2E, 0x02, 0xE0, 0x2E, 0x09, 0xF8, 0x07, 0x30, 0x8B,
  // "į" (U+012F)
  0x67, 0x00, 0x79, 0x79, 0x79, 0x79, 0x8B, 0x73, 0x8B,
  // "İ" (U+0130)
  0x08, 0x50, 0x00, 0xAF, 0x72, 0xE0, 0x2E, 0x02, 0xE0, 0x2E, 0x09, 0xF6,
  // "ı" (U+0131)
  0x79, 0x79, 0x79, 0x79, 0x79,
  // "Ĳ" (U+0132)
  0xAF, 0x76, 0xA2, 0xE0, 0x6A, 0x2E, 0x06, 0xA2, 0xE0, 0x6A, 0x2E, 0x06, 0xA9, 0xF6, 0x6A, 0x00,
  0x08, 0xA0, 0x07, 0xF5,
  // "ĳ" (U+0133)
  0x67, 0x67, 0x00, 0x00, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x00, 0x98,
  0x04, 0xE4,
  // "Ĵ" (U+0134)
  0x07, 0x26, 0x8B, 0x06, 0xA0, 0x6A, 0x06, 0xA0, 0x6A, 0x06, 0xA0, 0x6A, 0x08, 0xA7, 0xF5,
  // "ĵ" (U+0135)
  0x07, 0x26, 0x8B, 0x07, 0x90, 0x79, 0x07, 0x90, 0x79, 0x07, 0x90, 0x98, 0x4E, 0x30,
  // "Ķ" (U+0136)
  0x6A, 0x1E, 0x36, 0xA9, 0x90, 0x6D, 0xF1, 0x06, 0xEE, 0x40, 0x6A, 0x7B, 0x06, 0xA0, 0xE3, 0x00,
  0x00, 0x00, 0x2B, 0x00,
  // "ķ" (U+0137)
  0x79, 0x00, 0x79, 0x00, 0x79, 0x6B, 0x7A, 0xE2, 0x7F, 0xE0, 0x7A, 0xB6, 0x79, 0x4D, 0x00, 0x00,
  0x06, 0x70,
  // "ĸ" (U+0138)
  0x79, 0x6B, 0x79, 0xD2, 0x7F, 0xE0, 0x7A, 0xB6, 0x79, 0x4D,
  // "Ĺ" (U+0139)
  0x4A, 0x00, 0x10, 0x00, 0x6A, 0x00, 0x6A, 0x00, 0x6A, 0x00, 0x6A, 0x00, 0x6B, 0x10, 0x6F, 0xF7,
  // "ĺ" (U+013A)
  0x4A, 0x10, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79,
  // "Ļ" (U+013B)
  0x6A, 0x00, 0x6A, 0x00, 0x6A, 0x00, 0x6A, 0x00, 0x6B, 0x10, 0x6F, 0xF7, 0x00, 0x00, 0x08, 0x50,
  // "ļ" (U+013C)
  0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x00, 0x76,
  // "Ľ" (U+013D)
  0x6A, 0x58, 0x6A, 0x00, 0x6A, 0x00, 0x6A, 0x00, 0x6B, 0x10, 0x6F, 0xF7,
  // "ľ" (U+013E)
  0x79, 0xC7, 0x90, 0x79, 0x07, 0x90, 0x79, 0x07, 0x90, 0x79, 0x00,
  // "Ŀ" (U+013F)
  0x6A, 0x00, 0x6A, 0x85, 0x6A, 0x00, 0x6A, 0x00, 0x6B, 0x10, 0x6F, 0xF7,
  // "ŀ" (U+0140)
  0x79, 0x00, 0x79, 0x00, 0x79, 0x85, 0x79, 0x00, 0x79, 0x00, 0x79, 0x00, 0x79, 0x00,
  // "Ł" (U+0141)
  0x5C, 0x00, 0x5C, 0x20, 0x5F, 0x80, 0xDC, 0x00, 0x5C, 0x10, 0x5F, 0xF8,
  // "ł" (U+0142)
  0x5B, 0x05, 0xB0, 0x5D, 0x28, 0xE2, 0xDB, 0x05, 0xB0, 0x5B, 0x00,
  // "Ń" (U+0143)
  0x00, 0x4A, 0x00, 0x01, 0x00, 0x6F, 0x22, 0xD6, 0xF9, 0x2D, 0x6A, 0xE4, 0xD6, 0x99, 0xAD, 0x69,
  0x2F, 0xD6, 0x90, 0xBD,
  // "ń" (U+0144)
  0x04, 0xA0, 0x01, 0x00, 0x7B, 0xE7, 0x7B, 0x5D, 0x79, 0x2D, 0x79, 0x2D, 0x79, 0x2D,
  // "Ņ" (U+0145)
  0x6F, 0x22, 0xD6, 0xF9, 0x2D, 0x6A, 0xE4, 0xD6, 0x99, 0xAD, 0x69, 0x2F, 0xD6, 0x90, 0xBD, 0x00,
  0x00, 0x00, 0x0B, 0x10,
  // "ņ" (U+0146)
  0x7B, 0xE7, 0x7B, 0x5D, 0x79, 0x2D, 0x79, 0x2D, 0x79, 0x2D, 0x00, 0x00, 0x05, 0x80,
  // "Ň" (U+0147)
  0x04, 0x16, 0x00, 0x2E, 0x70, 0x6F, 0x22, 0xD6, 0xF9, 0x2D, 0x6A, 0xE4, 0xD6, 0x99, 0xAD, 0x69,
  0x2F, 0xD6, 0x90, 0xBD,
  // "ň" (U+0148)
  0x04, 0x16, 0x02, 0xE7, 0x7B, 0xE7, 0x7B, 0x5D, 0x79, 0x2D, 0x79, 0x2D, 0x79, 0x2D,
  // "ŉ" (U+0149)
  0x78, 0x00, 0x0A, 0xCB, 0xE7, 0x17, 0xB5, 0xD0, 0x79, 0x2D, 0x07, 0x92, 0xD0, 0x79, 0x2D,
  // "Ŋ" (U+014A)
  0x6F, 0x22, 0xD6, 0xEA, 0x2D, 0x6A, 0xE6, 0xD6, 0x97, 0xDD, 0x69, 0x0E, 0xD6, 0x90, 0x6D, 0x00,
  0x04, 0xC0, 0x04, 0xF7, 0x00, 0x01, 0x00,
  // "ŋ" (U+014B)
  0x7B, 0xE7, 0x7B, 0x5D, 0x79, 0x2D, 0x79, 0x2D, 0x79, 0x2D, 0x00, 0x4D, 0x00, 0xE7,
  // "Ō" (U+014C)
  0x09, 0xE9, 0x00, 0x11, 0x00, 0x0A, 0xEC, 0x15, 0xD1, 0xA9, 0x89, 0x05, 0xB8, 0x90, 0x5B, 0x5D,
  0x1A, 0x90, 0xAF, 0xC1,
  // "ō" (U+014D)
  0x09, 0xE9, 0x01, 0x10, 0x1D, 0xE3, 0x89, 0x6B, 0xA6, 0x3D, 0x89, 0x6B, 0x1D, 0xE3,
  // "Ŏ" (U+014E)
  0x04, 0x04, 0x00, 0x6F, 0x80, 0x0A, 0xFC, 0x15, 0xD1, 0xA9, 0x89, 0x05, 0xB8, 0x90, 0x5B, 0x5D,
  0x1A, 0x90, 0xAF, 0xC1,
  // "ŏ" (U+014F)
  0x04, 0x04, 0x06, 0xF8, 0x1D, 0xE3, 0x89, 0x6B, 0xA6, 0x3D, 0x89, 0x6B, 0x1D, 0xE3,
  // "Ő" (U+0150)
  0x05, 0x9A, 0x10, 0x00, 0x00, 0x0A, 0xEC, 0x15, 0xD1, 0xA9, 0x89, 0x05, 0xB8, 0x90, 0x5B, 0x5D,
  0x1A, 0x90, 0xAF, 0xC1,
  // "ő" (U+0151)
  0x05, 0x9A, 0x10, 0x00, 0x00, 0x1D, 0xE3, 0x08, 0x96, 0xB0, 0xA6, 0x3D, 0x08, 0x96, 0xB0, 0x1D,
  0xE3, 0x00,
  // "Œ" (U+0152)
  0x0A, 0xFF, 0xFE, 0x5D, 0x1D, 0x30, 0x89, 0x0D, 0xEB, 0x89, 0x0D, 0x41, 0x5D, 0x1D, 0x30, 0x0A,
  0xFF, 0xFE,
  // "œ" (U+0153)
  0x1C, 0xD8, 0xE8, 0x08, 0x96, 0xE2, 0xE1, 0xA6, 0x3F, 0xEF, 0x28, 0x96, 0xF3, 0x30, 0x1D, 0xD8,
  0xEC, 0x00,
  // "Ŕ" (U+0154)
  0x04, 0xA0, 0x00, 0x10, 0x00, 0x6F, 0xE8, 0x06, 0xB5, 0xE0, 0x6F, 0xF7, 0x06, 0xBB, 0x60, 0x6A,
  0x5C, 0x06, 0xA0, 0xE3,
  // "ŕ" (U+0155)
  0x04, 0xA0, 0x10, 0x7A, 0xC7, 0xC0, 0x79, 0x07, 0x90, 0x79, 0x00,
  // "Ŗ" (U+0156)
  0x6F, 0xE8, 0x06, 0xB5, 0xE0, 0x6F, 0xF7, 0x06, 0xBB, 0x60, 0x6A, 0x5C, 0x06, 0xA0, 0xE3, 0x00,
  0x00, 0x00, 0x2B, 0x00,
  // "ŗ" (U+0157)
  0x7A, 0xC7, 0xC0, 0x79, 0x07, 0x90, 0x79, 0x00, 0x00, 0x76, 0x00,
  // "Ř" (U+0158)
  0x04, 0x16, 0x00, 0x2E, 0x70, 0x6F, 0xE8, 0x06, 0xB5, 0xE0, 0x6F, 0xF7, 0x06, 0xBB, 0x60, 0x6A,
  0x5C, 0x06, 0xA0, 0xE3,
  // "ř" (U+0159)
  0x41, 0x62, 0xE7, 0x7A, 0xC7, 0xC0, 0x79, 0x07, 0x90, 0x79, 0x00,
  // "Ś" (U+015A)
  0x04, 0xA0, 0x01, 0x00, 0x3D, 0xE4, 0x99, 0x11, 0x6E, 0x50, 0x05, 0xE4, 0x31, 0xB6, 0x9F, 0xC1,
  // "ś" (U+015B)
  0x04, 0xA0, 0x10, 0x5E, 0xBA, 0x82, 0x3E, 0x82, 0x3F, 0x9F, 0x90,
  // "Ŝ" (U+015C)
  0x07, 0x20, 0x68, 0xB0, 0x3D, 0xE4, 0x99, 0x11, 0x6E, 0x50, 0x05, 0xE4, 0x31, 0xB6, 0x9F, 0xC1,
  // "ŝ" (U+015D)
  0x07, 0x26, 0x8B, 0x5E, 0xBA, 0x82, 0x3E, 0x82, 0x3F, 0x9F, 0x90,
  // "Ş" (U+015E)
  0x3D, 0xE4, 0x99, 0x11, 0x6E, 0x50, 0x05, 0xE4, 0x31, 0xB6, 0x9F, 0xC1, 0x09, 0x40, 0x1B, 0x40,
  // "ş" (U+015F)
  0x5E, 0xBA, 0x82, 0x3E, 0x82, 0x3F, 0x9F, 0x90, 0x94, 0x1B, 0x40,
  // "Š" (U+0160)
  0x41, 0x60, 0x2E, 0x70, 0x3D, 0xE4, 0x99, 0x11, 0x6E, 0x50, 0x05, 0xE4, 0x31, 0xB6, 0x9F, 0xC1,
  // "š" (U+0161)
  0x41, 0x62, 0xE7, 0x5E, 0xBA, 0x82, 0x3E, 0x82, 0x3F, 0x9F, 0x90,
  // "Ţ" (U+0162)
  0xDF, 0xFA, 0x0A, 0x70, 0x0A, 0x70, 0x0A, 0x70, 0x0A, 0x70, 0x0B, 0x70, 0x09, 0x40, 0x1B, 0x40,
  // "ţ" (U+0163)
  0x2A, 0x0B, 0xF9, 0x6A, 0x06, 0xA0, 0x6B, 0x02, 0xF9, 0x09, 0x41, 0xB4,
  // "Ť" (U+0164)
  0x41, 0x60, 0x2E, 0x70, 0xDF, 0xFA, 0x0A, 0x70, 0x0A, 0x70, 0x0A, 0x70, 0x0A, 0x70, 0x0A, 0x70,
  // "ť" (U+0165)
  0x04, 0x3A, 0x3A, 0x00, 0xCF, 0x90, 0x6A, 0x00, 0x6A, 0x00, 0x6B, 0x00, 0x2E, 0x90,
  // "Ŧ" (U+0166)
  0xDF, 0xFA, 0x0A, 0x70, 0x6F, 0xE3, 0x0A, 0x70, 0x0A, 0x70, 0x0A, 0x70,
  // "ŧ" (U+0167)
  0x2A, 0x0B, 0xF9, 0x6A, 0x0C, 0xF7, 0x6B, 0x13, 0xE9,
  // "Ũ" (U+0168)
  0x06, 0xDB, 0x07, 0xA0, 0xA6, 0x7A, 0x0A, 0x67, 0xA0, 0xA6, 0x7A, 0x0A, 0x65, 0xC2, 0xD5, 0x0B,
  0xEB, 0x00,
  // "ũ" (U+0169)
  0x6D, 0xB0, 0x89, 0x3D, 0x89, 0x3D, 0x89, 0x3D, 0x7A, 0x5D, 0x2E, 0xAD,
  // "Ū" (U+016A)
  0x09, 0xE9, 0x00, 0x11, 0x00, 0x7A, 0x0A, 0x67, 0xA0, 0xA6, 0x7A, 0x0A, 0x67, 0xA0, 0xA6, 0x5C,
  0x2D, 0x50, 0xBE, 0xB0,
  // "ū" (U+016B)
  0x09, 0xE9, 0x01, 0x10, 0x89, 0x3D, 0x89, 0x3D, 0x89, 0x3D, 0x7A, 0x5D, 0x2E, 0xAD,
  // "Ŭ" (U+016C)
  0x04, 0x04, 0x00, 0x6F, 0x80, 0x7A, 0x0A, 0x67, 0xA0, 0xA6, 0x7A, 0x0A, 0x67, 0xA0, 0xA6, 0x5C,
  0x2D, 0x50, 0xBE, 0xB0,
  // "ŭ" (U+016D)
  0x04, 0x04, 0x06, 0xF8, 0x89, 0x3D, 0x89, 0x3D, 0x89, 0x3D, 0x7A, 0x5D, 0x2E, 0xAD,
  // "Ů" (U+016E)
  0x06, 0xC1, 0x00, 0x8E, 0x10, 0x7A, 0x0A, 0x67, 0xA0, 0xA6, 0x7A, 0x0A, 0x67, 0xA0, 0xA6, 0x5C,
  0x2D, 0x50, 0xBE, 0xB0,
  // "ů" (U+016F)
  0x06, 0xC1, 0x08, 0xE1, 0x89, 0x3D, 0x89, 0x3D, 0x89, 0x3D, 0x7A, 0x5D, 0x2E, 0xAD,
  // "Ű" (U+0170)
  0x05, 0x9A, 0x10, 0x00, 0x00, 0x7A, 0x0A, 0x67, 0xA0, 0xA6, 0x7A, 0x0A, 0x67, 0xA0, 0xA6, 0x5C,
  0x2D, 0x50, 0xBE, 0xB0,
  // "ű" (U+0171)
  0x05, 0x9A, 0x10, 0x00, 0x00, 0x89, 0x3D, 0x08, 0x93, 0xD0, 0x89, 0x3D, 0x07, 0xA5, 0xD0, 0x2E,
  0xAD, 0x00,
  // "Ų" (U+0172)
  0x7A, 0x0A, 0x67, 0xA0, 0xA6, 0x7A, 0x0A, 0x67, 0xA0, 0xA6, 0x5C, 0x2D, 0x40, 0xBF, 0xB0, 0x00,
  0x83, 0x00, 0x08, 0xB0,
  // "ų" (U+0173)
  0x89, 0x3D, 0x89, 0x3D, 0x89, 0x3D, 0x7A, 0x5D, 0x2E, 0xBF, 0x00, 0x73, 0x00, 0x8B,
  // "Ŵ" (U+0174)
  0x00, 0x07, 0x20, 0x00, 0x06, 0x8B, 0x00, 0xD3, 0x4E, 0x08, 0x8A, 0x67, 0xF1, 0xB5, 0x79, 0xAC,
  0x5E, 0x24, 0xBD, 0x69, 0xE0, 0x1E, 0xC2, 0xEB, 0x00, 0xD9, 0x0E, 0x80,
  // "ŵ" (U+0175)
  0x00, 0x72, 0x00, 0x06, 0x8B, 0x00, 0xD3, 0xBA, 0x5B, 0x96, 0xCC, 0x88, 0x6A, 0xBC, 0xA4, 0x3E,
  0x8A, 0xE1, 0x0F, 0x58, 0xD0,
  // "Ŷ" (U+0176)
  0x07, 0x20, 0x68, 0xB0, 0xC5, 0x3E, 0x6B, 0x98, 0x0E, 0xE2, 0x09, 0xB0, 0x07, 0x90, 0x07, 0x90,
  // "ŷ" (U+0177)
  0x07, 0x20, 0x68, 0xB0, 0xD4, 0x6A, 0x88, 0x96, 0x4B, 0xD2, 0x0E, 0xD0, 0x0A, 0x90, 0x1C, 0x50,
  0xAB, 0x00,
  // "Ÿ" (U+0178)
  0x1A, 0x83, 0x00, 0x00, 0xC5, 0x3E, 0x6B, 0x98, 0x0E, 0xE2, 0x09, 0xB0, 0x07, 0x90, 0x07, 0x90,
  // "Ź" (U+0179)
  0x04, 0xA0, 0x01, 0x00, 0xBF, 0xF8, 0x00, 0xE3, 0x07, 0xB0, 0x0E, 0x30, 0x7A, 0x00, 0xCF, 0xF9,
  // "ź" (U+017A)
  0x04, 0xA0, 0x10, 0xBF, 0xE0, 0x79, 0x0E, 0x27, 0xA0, 0xCF, 0xF0,
  // "Ż" (U+017B)
  0x08, 0x50, 0x00, 0x00, 0xBF, 0xF8, 0x00, 0xE3, 0x07, 0xB0, 0x0E, 0x30, 0x7A, 0x00, 0xCF, 0xF9,
  // "ż" (U+017C)
  0x08, 0x50, 0x00, 0xBF, 0xE0, 0x79, 0x0E, 0x27, 0xA0, 0xCF, 0xF0,
  // "Ž" (U+017D)
  0x41, 0x60, 0x2E, 0x70, 0xBF, 0xF8, 0x00, 0xE3, 0x07, 0xB0, 0x0E, 0x30, 0x7A, 0x00, 0xCF, 0xF9,
  // "ž" (U+017E)
  0x41, 0x62, 0xE7, 0xBF, 0xE0, 0x79, 0x0E, 0x27, 0xA0, 0xCF, 0xF0,
  // "ſ" (U+017F)
  0x2E, 0x96, 0xB0, 0x6A, 0x06, 0xA0, 0x6A, 0x06, 0xA0, 0x6A, 0x00,
  // "Ω" (U+03A9)
  0x0A, 0xEC, 0x26, 0xC1, 0x9A, 0x98, 0x04, 0xC7, 0x90, 0x6B, 0x1D, 0x1B, 0x3C, 0xF5, 0xFF,
  // "μ" (U+03BC)
  0x79, 0x3D, 0x79, 0x3D, 0x79, 0x3D, 0x7A, 0x6D, 0x7E, 0xBD, 0x78, 0x00, 0x79, 0x00,
  // "π" (U+03C0)
  0xCF, 0xFF, 0xB3, 0xD1, 0xF0, 0x3D, 0x1F, 0x03, 0xD1, 0xF1, 0x3D, 0x0C, 0x90,
  // "–" (U+2013)
  0xAE, 0xEA, 0x11, 0x11,
  // "—" (U+2014)
  0x0A, 0x80, 0x2E, 0x0A, 0x80, 0x41,
  // "€" (U+20AC)
  0x08, 0xE9, 0x2E, 0x11, 0xBE, 0xB0, 0xBE, 0x90, 0x2E, 0x12, 0x08, 0xE9,
  // "₿" (U+20BF)
  0x07, 0x70, 0x6F, 0xE4, 0x6A, 0x89, 0x6F, 0xF3, 0x6A, 0x8A, 0x6A, 0x7B, 0x6F, 0xE4, 0x06, 0x60,
  // "‘" (U+2018)
  0x58, 0xA6, 0x10,
  // "’" (U+2019)
  0x78, 0xA4, 0x10,
  // "‚" (U+201A)
  0x78, 0xA4, 0x10,
  // "‛" (U+201B)
  0xA5, 0x68, 0x01,
  // "“" (U+201C)
  0x58, 0xA3, 0xA6, 0xE1, 0x10, 0x20,
  // "”" (U+201D)
  0x88, 0xC3, 0xA4, 0xE0, 0x10, 0x10,
  // "„" (U+201E)
  0x88, 0xC3, 0xA4, 0xE0, 0x10, 0x10,
  // "‟" (U+201F)
  0xA6, 0xE1, 0x68, 0xA3, 0x01, 0x10,
  // "†" (U+2020)
  0x08, 0x60, 0x17, 0x51, 0x7D, 0xD6, 0x06, 0x40, 0x07, 0x50, 0x07, 0x60, 0x08, 0x70,
  // "‡" (U+2021)
  0x07, 0x70, 0x38, 0x82, 0x6B, 0xB5, 0x07, 0x60, 0x5A, 0xA4, 0x39, 0x93, 0x07, 0x70,
  // "•" (U+2022)
  0x5E, 0x69, 0xFA, 0x3C, 0x40,
  // "…" (U+2026)
  0x68, 0x68, 0x68,
  // "‰" (U+2030)
  0x5E, 0x32, 0xA0, 0x00, 0x0B, 0x79, 0x84, 0x00, 0x00, 0xB6, 0x9C, 0xAB, 0x1C, 0x76, 0xFA, 0x8C,
  0xB8, 0x9D, 0x00, 0xB2, 0xCB, 0x88, 0xD0, 0x39, 0x0B, 0xC1, 0xD8,
  // "‹" (U+2039)
  0x0B, 0x18, 0x90, 0x4C, 0x00, 0x51,
  // "›" (U+203A)
  0x76, 0x01, 0xE2, 0x4C, 0x04, 0x20,
  // "⁄" (U+2044)
  0x00, 0x0B, 0x10, 0x04, 0x90, 0x00, 0xB1, 0x00, 0x49, 0x00, 0x0B, 0x20, 0x03, 0x90, 0x00,
  // "™" (U+2122)
  0x9A, 0x93, 0x92, 0x36, 0x99, 0xC3, 0x34, 0x77, 0x52,
  // "⅒" (U+2152)
  0x00, 0x00, 0xB1, 0x00, 0x04, 0xE1, 0x49, 0x00, 0x00, 0x1B, 0x1B, 0x10, 0x5C, 0x20, 0xB5, 0x94,
  0xED, 0x48, 0x00, 0xB2, 0x1B, 0xD4, 0x80, 0x39, 0x00, 0xB6, 0xC3,
  // "ﬁ" (U+FB01)
  0x1D, 0xA6, 0x75, 0xC0, 0x00, 0xCF, 0x87, 0x95, 0xB0, 0x79, 0x5B, 0x07, 0x95, 0xB0, 0x79, 0x5B,
  0x07, 0x90,
  // "ﬂ" (U+FB02)
  0x1D, 0xA7, 0x95, 0xC0, 0x79, 0xCF, 0x87, 0x95, 0xB0, 0x79, 0x5B, 0x07, 0x95, 0xB0, 0x79, 0x5B,
  0x07, 0x90,
};

const Font& font_NotoSans_CondensedBold_8() {
  static SmoothFont font(font_NotoSans_CondensedBold_8_data);
  return font;
}

}  // namespace roo_display
