#include "12.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSans-CondensedBold (Noto Sans Condensed Bold)
// Generated on Wed Nov 19 19:11:20 CET 2025
static const uint8_t font_NotoSans_CondensedBold_12_data[] PROGMEM = {
  
  // Header
  0x01, 0x02, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x02, 0xA1,
  0xFE, 0xFD, 0x0D, 0x0D, 0x0A, 0xFD, 0x04, 0x01, 0x0E, 0x03, 0x03, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x40, 0x01, 0x02, 0x09, 0x03, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x40, 0x07, 0x04, 0x09, 0x05, 0x00, 0x0E, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x06, 0x09, 0x07, 0x00, 0x16, // "#" (U+0023)
  0x00, 0x24, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x00, 0x35, // "$" (U+0024)
  0x00, 0x25, 0x40, 0x01, 0x09, 0x09, 0x0A, 0x00, 0x53, // "%" (U+0025)
  0x00, 0x26, 0x40, 0x01, 0x07, 0x09, 0x08, 0x00, 0x80, // "&" (U+0026)
  0x00, 0x27, 0x40, 0x07, 0x02, 0x09, 0x03, 0x00, 0xA4, // "'" (U+0027)
  0x00, 0x28, 0x40, 0xFF, 0x03, 0x09, 0x04, 0x00, 0xA9, // "(" (U+0028)
  0x00, 0x29, 0x40, 0xFF, 0x03, 0x09, 0x04, 0x00, 0xBF, // ")" (U+0029)
  0x00, 0x2A, 0x40, 0x05, 0x05, 0x0A, 0x06, 0x00, 0xD5, // "*" (U+002A)
  0x00, 0x2B, 0x40, 0x02, 0x05, 0x07, 0x06, 0x00, 0xE7, // "+" (U+002B)
  0x00, 0x2C, 0x40, 0xFF, 0x02, 0x01, 0x03, 0x00, 0xF9, // "," (U+002C)
  0x00, 0x2D, 0x40, 0x03, 0x03, 0x05, 0x04, 0x00, 0xFE, // "-" (U+002D)
  0x00, 0x2E, 0x40, 0x01, 0x02, 0x02, 0x03, 0x01, 0x04, // "." (U+002E)
  0x00, 0x2F, 0x40, 0x01, 0x04, 0x09, 0x05, 0x01, 0x07, // "/" (U+002F)
  0x00, 0x30, 0x40, 0x01, 0x05, 0x09, 0x06, 0x01, 0x1E, // "0" (U+0030)
  0x00, 0x31, 0x40, 0x01, 0x04, 0x09, 0x06, 0x01, 0x39, // "1" (U+0031)
  0x00, 0x32, 0x40, 0x01, 0x05, 0x09, 0x06, 0x01, 0x50, // "2" (U+0032)
  0x00, 0x33, 0x40, 0x01, 0x05, 0x09, 0x06, 0x01, 0x6B, // "3" (U+0033)
  0x00, 0x34, 0x40, 0x01, 0x05, 0x09, 0x06, 0x01, 0x86, // "4" (U+0034)
  0x00, 0x35, 0x40, 0x01, 0x05, 0x09, 0x06, 0x01, 0xA1, // "5" (U+0035)
  0x00, 0x36, 0x40, 0x01, 0x05, 0x09, 0x06, 0x01, 0xBC, // "6" (U+0036)
  0x00, 0x37, 0x40, 0x01, 0x05, 0x09, 0x06, 0x01, 0xD7, // "7" (U+0037)
  0x00, 0x38, 0x40, 0x01, 0x05, 0x09, 0x06, 0x01, 0xF2, // "8" (U+0038)
  0x00, 0x39, 0x40, 0x01, 0x05, 0x09, 0x06, 0x02, 0x0D, // "9" (U+0039)
  0x00, 0x3A, 0x00, 0x01, 0x02, 0x07, 0x03, 0x02, 0x28, // ":" (U+003A)
  0x00, 0x3B, 0x00, 0x00, 0x02, 0x07, 0x03, 0x02, 0x31, // ";" (U+003B)
  0x00, 0x3C, 0x00, 0x02, 0x05, 0x08, 0x06, 0x02, 0x3C, // "<" (U+003C)
  0x00, 0x3D, 0x00, 0x03, 0x05, 0x08, 0x06, 0x02, 0x50, // "=" (U+003D)
  0x00, 0x3E, 0x00, 0x02, 0x05, 0x08, 0x06, 0x02, 0x60, // ">" (U+003E)
  0x00, 0x3F, 0x40, 0x01, 0x04, 0x09, 0x05, 0x02, 0x74, // "?" (U+003F)
  0x00, 0x40, 0x00, 0xFF, 0x08, 0x09, 0x09, 0x02, 0x8B, // "@" (U+0040)
  0x00, 0x41, 0x40, 0x01, 0x06, 0x09, 0x07, 0x02, 0xBC, // "A" (U+0041)
  0x00, 0x42, 0x40, 0x01, 0x06, 0x09, 0x07, 0x02, 0xDC, // "B" (U+0042)
  0x00, 0x43, 0x40, 0x01, 0x05, 0x09, 0x06, 0x02, 0xFC, // "C" (U+0043)
  0x00, 0x44, 0x40, 0x01, 0x06, 0x09, 0x07, 0x03, 0x17, // "D" (U+0044)
  0x00, 0x45, 0x00, 0x01, 0x04, 0x09, 0x06, 0x03, 0x37, // "E" (U+0045)
  0x00, 0x46, 0x40, 0x01, 0x04, 0x09, 0x05, 0x03, 0x4D, // "F" (U+0046)
  0x00, 0x47, 0x40, 0x01, 0x06, 0x09, 0x07, 0x03, 0x64, // "G" (U+0047)
  0x00, 0x48, 0x40, 0x01, 0x06, 0x09, 0x08, 0x03, 0x84, // "H" (U+0048)
  0x00, 0x49, 0x40, 0x01, 0x03, 0x09, 0x04, 0x03, 0xA4, // "I" (U+0049)
  0x00, 0x4A, 0xBF, 0xFE, 0x02, 0x09, 0x03, 0x03, 0xB6, // "J" (U+004A)
  0x00, 0x4B, 0x40, 0x01, 0x06, 0x09, 0x07, 0x03, 0xCE, // "K" (U+004B)
  0x00, 0x4C, 0x40, 0x01, 0x05, 0x09, 0x05, 0x03, 0xEE, // "L" (U+004C)
  0x00, 0x4D, 0x40, 0x01, 0x08, 0x09, 0x0A, 0x04, 0x09, // "M" (U+004D)
  0x00, 0x4E, 0x40, 0x01, 0x07, 0x09, 0x08, 0x04, 0x32, // "N" (U+004E)
  0x00, 0x4F, 0x40, 0x01, 0x07, 0x09, 0x08, 0x04, 0x56, // "O" (U+004F)
  0x00, 0x50, 0x40, 0x01, 0x05, 0x09, 0x06, 0x04, 0x7A, // "P" (U+0050)
  0x00, 0x51, 0x40, 0xFF, 0x07, 0x09, 0x08, 0x04, 0x95, // "Q" (U+0051)
  0x00, 0x52, 0x40, 0x01, 0x06, 0x09, 0x07, 0x04, 0xC1, // "R" (U+0052)
  0x00, 0x53, 0x40, 0x01, 0x05, 0x09, 0x06, 0x04, 0xE1, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x05, 0x09, 0x06, 0x04, 0xFC, // "T" (U+0054)
  0x00, 0x55, 0x40, 0x01, 0x06, 0x09, 0x07, 0x05, 0x11, // "U" (U+0055)
  0x00, 0x56, 0x40, 0x01, 0x06, 0x09, 0x07, 0x05, 0x31, // "V" (U+0056)
  0x00, 0x57, 0x40, 0x01, 0x09, 0x09, 0x0A, 0x05, 0x51, // "W" (U+0057)
  0x00, 0x58, 0x40, 0x01, 0x06, 0x09, 0x06, 0x05, 0x7E, // "X" (U+0058)
  0x00, 0x59, 0x00, 0x01, 0x06, 0x09, 0x06, 0x05, 0x9E, // "Y" (U+0059)
  0x00, 0x5A, 0x40, 0x01, 0x05, 0x09, 0x06, 0x05, 0xBB, // "Z" (U+005A)
  0x00, 0x5B, 0x40, 0xFE, 0x03, 0x09, 0x04, 0x05, 0xD6, // "[" (U+005B)
  0x00, 0x5C, 0x40, 0x01, 0x04, 0x09, 0x05, 0x05, 0xEE, // "\" (U+005C)
  0x00, 0x5D, 0x40, 0xFE, 0x03, 0x09, 0x04, 0x06, 0x05, // "]" (U+005D)
  0x00, 0x5E, 0x40, 0x04, 0x05, 0x09, 0x06, 0x06, 0x1D, // "^" (U+005E)
  0x00, 0x5F, 0x00, 0xFE, 0x05, 0x00, 0x05, 0x06, 0x2F, // "_" (U+005F)
  0x00, 0x60, 0x40, 0x09, 0x03, 0x0A, 0x04, 0x06, 0x36, // "`" (U+0060)
  0x00, 0x61, 0x40, 0x01, 0x05, 0x07, 0x06, 0x06, 0x3A, // "a" (U+0061)
  0x00, 0x62, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x06, 0x4F, // "b" (U+0062)
  0x00, 0x63, 0x40, 0x01, 0x04, 0x07, 0x05, 0x06, 0x6D, // "c" (U+0063)
  0x00, 0x64, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x06, 0x7F, // "d" (U+0064)
  0x00, 0x65, 0x40, 0x01, 0x05, 0x07, 0x06, 0x06, 0x9C, // "e" (U+0065)
  0x00, 0x66, 0x00, 0x01, 0x04, 0x0A, 0x04, 0x06, 0xB1, // "f" (U+0066)
  0x00, 0x67, 0x40, 0xFE, 0x05, 0x07, 0x06, 0x06, 0xC9, // "g" (U+0067)
  0x00, 0x68, 0x40, 0x01, 0x05, 0x0A, 0x07, 0x06, 0xE7, // "h" (U+0068)
  0x00, 0x69, 0x40, 0x01, 0x02, 0x0A, 0x03, 0x07, 0x05, // "i" (U+0069)
  0x00, 0x6A, 0xBF, 0xFE, 0x02, 0x0A, 0x03, 0x07, 0x14, // "j" (U+006A)
  0x00, 0x6B, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x07, 0x2E, // "k" (U+006B)
  0x00, 0x6C, 0x40, 0x01, 0x02, 0x0A, 0x03, 0x07, 0x4C, // "l" (U+006C)
  0x00, 0x6D, 0x40, 0x01, 0x09, 0x07, 0x0A, 0x07, 0x5B, // "m" (U+006D)
  0x00, 0x6E, 0x40, 0x01, 0x05, 0x07, 0x07, 0x07, 0x7E, // "n" (U+006E)
  0x00, 0x6F, 0x40, 0x01, 0x05, 0x07, 0x06, 0x07, 0x93, // "o" (U+006F)
  0x00, 0x70, 0x40, 0xFE, 0x05, 0x07, 0x06, 0x07, 0xA8, // "p" (U+0070)
  0x00, 0x71, 0x40, 0xFE, 0x05, 0x07, 0x06, 0x07, 0xC6, // "q" (U+0071)
  0x00, 0x72, 0x40, 0x01, 0x04, 0x07, 0x05, 0x07, 0xE4, // "r" (U+0072)
  0x00, 0x73, 0x40, 0x01, 0x04, 0x07, 0x05, 0x07, 0xF6, // "s" (U+0073)
  0x00, 0x74, 0x40, 0x01, 0x03, 0x09, 0x04, 0x08, 0x08, // "t" (U+0074)
  0x00, 0x75, 0x40, 0x01, 0x05, 0x07, 0x07, 0x08, 0x1A, // "u" (U+0075)
  0x00, 0x76, 0x40, 0x01, 0x05, 0x07, 0x06, 0x08, 0x2F, // "v" (U+0076)
  0x00, 0x77, 0x40, 0x01, 0x08, 0x07, 0x09, 0x08, 0x44, // "w" (U+0077)
  0x00, 0x78, 0x40, 0x01, 0x05, 0x07, 0x06, 0x08, 0x64, // "x" (U+0078)
  0x00, 0x79, 0x40, 0xFE, 0x05, 0x07, 0x06, 0x08, 0x79, // "y" (U+0079)
  0x00, 0x7A, 0x40, 0x01, 0x04, 0x07, 0x05, 0x08, 0x97, // "z" (U+007A)
  0x00, 0x7B, 0x40, 0xFE, 0x04, 0x09, 0x04, 0x08, 0xA9, // "{" (U+007B)
  0x00, 0x7C, 0x42, 0xFE, 0x03, 0x0A, 0x05, 0x08, 0xC7, // "|" (U+007C)
  0x00, 0x7D, 0x40, 0xFE, 0x04, 0x09, 0x04, 0x08, 0xD4, // "}" (U+007D)
  0x00, 0x7E, 0x40, 0x04, 0x05, 0x06, 0x06, 0x08, 0xF2, // "~" (U+007E)
  0x00, 0xA1, 0x40, 0xFF, 0x02, 0x07, 0x03, 0x08, 0xFB, // "¡" (U+00A1)
  0x00, 0xA2, 0x40, 0x01, 0x05, 0x09, 0x06, 0x09, 0x09, // "¢" (U+00A2)
  0x00, 0xA3, 0x40, 0x01, 0x05, 0x09, 0x06, 0x09, 0x24, // "£" (U+00A3)
  0x00, 0xA4, 0x40, 0x02, 0x05, 0x08, 0x07, 0x09, 0x3F, // "¤" (U+00A4)
  0x00, 0xA5, 0x40, 0x01, 0x05, 0x09, 0x06, 0x09, 0x54, // "¥" (U+00A5)
  0x00, 0xA6, 0x42, 0xFE, 0x03, 0x0A, 0x05, 0x09, 0x6F, // "¦" (U+00A6)
  0x00, 0xA7, 0x40, 0x01, 0x04, 0x0A, 0x05, 0x09, 0x7C, // "§" (U+00A7)
  0x00, 0xA8, 0x41, 0x08, 0x04, 0x09, 0x06, 0x09, 0x95, // "¨" (U+00A8)
  0x00, 0xA9, 0x00, 0x00, 0x09, 0x0A, 0x0A, 0x09, 0x99, // "©" (U+00A9)
  0x00, 0xAA, 0x40, 0x06, 0x03, 0x09, 0x04, 0x09, 0xCE, // "ª" (U+00AA)
  0x00, 0xAB, 0x40, 0x01, 0x05, 0x06, 0x07, 0x09, 0xD6, // "«" (U+00AB)
  0x00, 0xAC, 0x00, 0x02, 0x05, 0x06, 0x06, 0x09, 0xE8, // "¬" (U+00AC)
  0x00, 0xAE, 0x00, 0x00, 0x09, 0x0A, 0x0A, 0x09, 0xF5, // "®" (U+00AE)
  0x00, 0xAF, 0x00, 0x0A, 0x05, 0x0C, 0x06, 0x0A, 0x2A, // "¯" (U+00AF)
  0x00, 0xB0, 0x40, 0x05, 0x04, 0x0A, 0x05, 0x0A, 0x31, // "°" (U+00B0)
  0x00, 0xB1, 0x40, 0x01, 0x05, 0x08, 0x06, 0x0A, 0x40, // "±" (U+00B1)
  0x00, 0xB2, 0x40, 0x05, 0x03, 0x0A, 0x04, 0x0A, 0x58, // "²" (U+00B2)
  0x00, 0xB3, 0x40, 0x05, 0x03, 0x0A, 0x04, 0x0A, 0x64, // "³" (U+00B3)
  0x00, 0xB4, 0x40, 0x08, 0x02, 0x0A, 0x04, 0x0A, 0x70, // "´" (U+00B4)
  0x00, 0xB5, 0x40, 0xFE, 0x05, 0x07, 0x07, 0x0A, 0x75, // "µ" (U+00B5)
  0x00, 0xB6, 0x40, 0xFF, 0x05, 0x0A, 0x07, 0x0A, 0x93, // "¶" (U+00B6)
  0x00, 0xB7, 0x40, 0x04, 0x02, 0x05, 0x03, 0x0A, 0xB7, // "·" (U+00B7)
  0x00, 0xB8, 0xBF, 0xFE, 0x02, 0x00, 0x02, 0x0A, 0xBA, // "¸" (U+00B8)
  0x00, 0xB9, 0x40, 0x06, 0x03, 0x0A, 0x04, 0x0A, 0xC0, // "¹" (U+00B9)
  0x00, 0xBA, 0x40, 0x06, 0x03, 0x09, 0x04, 0x0A, 0xCA, // "º" (U+00BA)
  0x00, 0xBB, 0x40, 0x01, 0x06, 0x06, 0x07, 0x0A, 0xD2, // "»" (U+00BB)
  0x00, 0xBC, 0x40, 0x00, 0x09, 0x09, 0x0A, 0x0A, 0xE7, // "¼" (U+00BC)
  0x00, 0xBD, 0x40, 0x00, 0x09, 0x08, 0x0A, 0x0B, 0x19, // "½" (U+00BD)
  0x00, 0xBE, 0x40, 0x00, 0x09, 0x09, 0x0A, 0x0B, 0x46, // "¾" (U+00BE)
  0x00, 0xBF, 0x40, 0xFE, 0x04, 0x06, 0x05, 0x0B, 0x78, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x0B, 0x8F, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x0B, 0xB5, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x0B, 0xDC, // "Â" (U+00C2)
  0x00, 0xC3, 0x40, 0x01, 0x06, 0x0C, 0x07, 0x0C, 0x03, // "Ã" (U+00C3)
  0x00, 0xC4, 0x40, 0x01, 0x06, 0x0B, 0x07, 0x0C, 0x2D, // "Ä" (U+00C4)
  0x00, 0xC5, 0x40, 0x01, 0x06, 0x0C, 0x07, 0x0C, 0x54, // "Å" (U+00C5)
  0x00, 0xC6, 0x40, 0x01, 0x08, 0x09, 0x09, 0x0C, 0x7E, // "Æ" (U+00C6)
  0x00, 0xC7, 0x40, 0xFE, 0x05, 0x09, 0x06, 0x0C, 0xA7, // "Ç" (U+00C7)
  0x00, 0xC8, 0x00, 0x01, 0x04, 0x0C, 0x06, 0x0C, 0xCB, // "È" (U+00C8)
  0x00, 0xC9, 0x00, 0x01, 0x04, 0x0C, 0x06, 0x0C, 0xE7, // "É" (U+00C9)
  0x00, 0xCA, 0x00, 0x01, 0x04, 0x0C, 0x06, 0x0D, 0x04, // "Ê" (U+00CA)
  0x00, 0xCB, 0x40, 0x01, 0x04, 0x0B, 0x06, 0x0D, 0x21, // "Ë" (U+00CB)
  0x00, 0xCC, 0x40, 0x01, 0x03, 0x0C, 0x04, 0x0D, 0x3D, // "Ì" (U+00CC)
  0x00, 0xCD, 0x40, 0x01, 0x03, 0x0C, 0x04, 0x0D, 0x55, // "Í" (U+00CD)
  0x00, 0xCE, 0x40, 0x01, 0x04, 0x0C, 0x04, 0x0D, 0x6D, // "Î" (U+00CE)
  0x00, 0xCF, 0x40, 0x01, 0x03, 0x0B, 0x04, 0x0D, 0x8B, // "Ï" (U+00CF)
  0x00, 0xD0, 0x40, 0x01, 0x06, 0x09, 0x07, 0x0D, 0xA1, // "Ð" (U+00D0)
  0x00, 0xD1, 0x40, 0x01, 0x07, 0x0C, 0x08, 0x0D, 0xC1, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x0D, 0xF1, // "Ò" (U+00D2)
  0x00, 0xD3, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x0E, 0x20, // "Ó" (U+00D3)
  0x00, 0xD4, 0x40, 0x01, 0x07, 0x0C, 0x08, 0x0E, 0x4F, // "Ô" (U+00D4)
  0x00, 0xD5, 0x40, 0x01, 0x07, 0x0C, 0x08, 0x0E, 0x7F, // "Õ" (U+00D5)
  0x00, 0xD6, 0x40, 0x01, 0x07, 0x0B, 0x08, 0x0E, 0xAF, // "Ö" (U+00D6)
  0x00, 0xD7, 0x40, 0x02, 0x05, 0x07, 0x06, 0x0E, 0xDB, // "×" (U+00D7)
  0x00, 0xD8, 0x00, 0x00, 0x07, 0x0A, 0x08, 0x0E, 0xED, // "Ø" (U+00D8)
  0x00, 0xD9, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x0F, 0x18, // "Ù" (U+00D9)
  0x00, 0xDA, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x0F, 0x40, // "Ú" (U+00DA)
  0x00, 0xDB, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x0F, 0x69, // "Û" (U+00DB)
  0x00, 0xDC, 0x40, 0x01, 0x06, 0x0B, 0x07, 0x0F, 0x92, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x01, 0x06, 0x0C, 0x06, 0x0F, 0xB9, // "Ý" (U+00DD)
  0x00, 0xDE, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0F, 0xDD, // "Þ" (U+00DE)
  0x00, 0xDF, 0x40, 0x01, 0x06, 0x0A, 0x07, 0x0F, 0xF8, // "ß" (U+00DF)
  0x00, 0xE0, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x10, 0x1B, // "à" (U+00E0)
  0x00, 0xE1, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x10, 0x39, // "á" (U+00E1)
  0x00, 0xE2, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x10, 0x57, // "â" (U+00E2)
  0x00, 0xE3, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x10, 0x75, // "ã" (U+00E3)
  0x00, 0xE4, 0x40, 0x01, 0x05, 0x09, 0x06, 0x10, 0x93, // "ä" (U+00E4)
  0x00, 0xE5, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x10, 0xAE, // "å" (U+00E5)
  0x00, 0xE6, 0x40, 0x01, 0x08, 0x07, 0x09, 0x10, 0xCF, // "æ" (U+00E6)
  0x00, 0xE7, 0x40, 0xFE, 0x04, 0x07, 0x05, 0x10, 0xEF, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x11, 0x08, // "è" (U+00E8)
  0x00, 0xE9, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x11, 0x25, // "é" (U+00E9)
  0x00, 0xEA, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x11, 0x43, // "ê" (U+00EA)
  0x00, 0xEB, 0x40, 0x01, 0x05, 0x09, 0x06, 0x11, 0x61, // "ë" (U+00EB)
  0x00, 0xEC, 0xBF, 0x01, 0x02, 0x0A, 0x03, 0x11, 0x7C, // "ì" (U+00EC)
  0x00, 0xED, 0x40, 0x01, 0x02, 0x0A, 0x03, 0x11, 0x90, // "í" (U+00ED)
  0x00, 0xEE, 0xBF, 0x01, 0x03, 0x0A, 0x03, 0x11, 0x9F, // "î" (U+00EE)
  0x00, 0xEF, 0xBF, 0x01, 0x02, 0x09, 0x03, 0x11, 0xB8, // "ï" (U+00EF)
  0x00, 0xF0, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x11, 0xCA, // "ð" (U+00F0)
  0x00, 0xF1, 0x40, 0x01, 0x05, 0x0A, 0x07, 0x11, 0xE8, // "ñ" (U+00F1)
  0x00, 0xF2, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x12, 0x06, // "ò" (U+00F2)
  0x00, 0xF3, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x12, 0x23, // "ó" (U+00F3)
  0x00, 0xF4, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x12, 0x41, // "ô" (U+00F4)
  0x00, 0xF5, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x12, 0x5F, // "õ" (U+00F5)
  0x00, 0xF6, 0x40, 0x01, 0x05, 0x09, 0x06, 0x12, 0x7D, // "ö" (U+00F6)
  0x00, 0xF7, 0x00, 0x02, 0x05, 0x08, 0x06, 0x12, 0x98, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x00, 0x05, 0x08, 0x06, 0x12, 0xAA, // "ø" (U+00F8)
  0x00, 0xF9, 0x00, 0x01, 0x05, 0x0A, 0x07, 0x12, 0xC4, // "ù" (U+00F9)
  0x00, 0xFA, 0x40, 0x01, 0x05, 0x0A, 0x07, 0x12, 0xE1, // "ú" (U+00FA)
  0x00, 0xFB, 0x40, 0x01, 0x05, 0x0A, 0x07, 0x12, 0xFF, // "û" (U+00FB)
  0x00, 0xFC, 0x40, 0x01, 0x05, 0x09, 0x07, 0x13, 0x1D, // "ü" (U+00FC)
  0x00, 0xFD, 0x40, 0xFE, 0x05, 0x0A, 0x06, 0x13, 0x38, // "ý" (U+00FD)
  0x00, 0xFE, 0x40, 0xFE, 0x05, 0x0A, 0x06, 0x13, 0x5F, // "þ" (U+00FE)
  0x00, 0xFF, 0x40, 0xFE, 0x05, 0x09, 0x06, 0x13, 0x86, // "ÿ" (U+00FF)
  0x01, 0x00, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x13, 0xAA, // "Ā" (U+0100)
  0x01, 0x01, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x13, 0xD1, // "ā" (U+0101)
  0x01, 0x02, 0x40, 0x01, 0x06, 0x0C, 0x07, 0x13, 0xEF, // "Ă" (U+0102)
  0x01, 0x03, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x14, 0x19, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0xFD, 0x06, 0x09, 0x07, 0x14, 0x37, // "Ą" (U+0104)
  0x01, 0x05, 0x40, 0xFD, 0x05, 0x07, 0x06, 0x14, 0x62, // "ą" (U+0105)
  0x01, 0x06, 0x00, 0x01, 0x05, 0x0C, 0x06, 0x14, 0x83, // "Ć" (U+0106)
  0x01, 0x07, 0x40, 0x01, 0x04, 0x0A, 0x05, 0x14, 0xA6, // "ć" (U+0107)
  0x01, 0x08, 0x40, 0x01, 0x05, 0x0C, 0x06, 0x14, 0xBF, // "Ĉ" (U+0108)
  0x01, 0x09, 0x40, 0x01, 0x04, 0x0A, 0x05, 0x14, 0xE3, // "ĉ" (U+0109)
  0x01, 0x0A, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x14, 0xFC, // "Ċ" (U+010A)
  0x01, 0x0B, 0x40, 0x01, 0x04, 0x09, 0x05, 0x15, 0x1D, // "ċ" (U+010B)
  0x01, 0x0C, 0x40, 0x01, 0x05, 0x0C, 0x06, 0x15, 0x34, // "Č" (U+010C)
  0x01, 0x0D, 0x40, 0x01, 0x04, 0x0A, 0x05, 0x15, 0x58, // "č" (U+010D)
  0x01, 0x0E, 0x40, 0x01, 0x06, 0x0C, 0x07, 0x15, 0x71, // "Ď" (U+010E)
  0x01, 0x0F, 0x40, 0x01, 0x07, 0x0A, 0x06, 0x15, 0x9B, // "ď" (U+010F)
  0x01, 0x10, 0x40, 0x01, 0x06, 0x09, 0x07, 0x15, 0xC3, // "Đ" (U+0110)
  0x01, 0x11, 0x40, 0x01, 0x06, 0x0A, 0x07, 0x15, 0xE3, // "đ" (U+0111)
  0x01, 0x12, 0x40, 0x01, 0x04, 0x0C, 0x06, 0x16, 0x06, // "Ē" (U+0112)
  0x01, 0x13, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x16, 0x24, // "ē" (U+0113)
  0x01, 0x14, 0x40, 0x01, 0x05, 0x0C, 0x06, 0x16, 0x42, // "Ĕ" (U+0114)
  0x01, 0x15, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x16, 0x66, // "ĕ" (U+0115)
  0x01, 0x16, 0x00, 0x01, 0x04, 0x0B, 0x06, 0x16, 0x84, // "Ė" (U+0116)
  0x01, 0x17, 0x40, 0x01, 0x05, 0x09, 0x06, 0x16, 0x9F, // "ė" (U+0117)
  0x01, 0x18, 0x40, 0xFD, 0x04, 0x09, 0x06, 0x16, 0xBA, // "Ę" (U+0118)
  0x01, 0x19, 0x40, 0xFE, 0x05, 0x07, 0x06, 0x16, 0xDB, // "ę" (U+0119)
  0x01, 0x1A, 0x00, 0x01, 0x04, 0x0C, 0x06, 0x16, 0xF9, // "Ě" (U+011A)
  0x01, 0x1B, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x17, 0x15, // "ě" (U+011B)
  0x01, 0x1C, 0x40, 0x01, 0x06, 0x0C, 0x07, 0x17, 0x33, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x40, 0xFE, 0x05, 0x0A, 0x06, 0x17, 0x5D, // "ĝ" (U+011D)
  0x01, 0x1E, 0x40, 0x01, 0x06, 0x0C, 0x07, 0x17, 0x84, // "Ğ" (U+011E)
  0x01, 0x1F, 0x40, 0xFE, 0x05, 0x0A, 0x06, 0x17, 0xAE, // "ğ" (U+011F)
  0x01, 0x20, 0x40, 0x01, 0x06, 0x0B, 0x07, 0x17, 0xD5, // "Ġ" (U+0120)
  0x01, 0x21, 0x40, 0xFE, 0x05, 0x09, 0x06, 0x17, 0xFC, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0xFE, 0x06, 0x09, 0x07, 0x18, 0x20, // "Ģ" (U+0122)
  0x01, 0x23, 0x00, 0xFE, 0x05, 0x0A, 0x06, 0x18, 0x49, // "ģ" (U+0123)
  0x01, 0x24, 0x40, 0x01, 0x06, 0x0C, 0x08, 0x18, 0x6E, // "Ĥ" (U+0124)
  0x01, 0x25, 0xFF, 0x01, 0x05, 0x0D, 0x07, 0x18, 0x98, // "ĥ" (U+0125)
  0x01, 0x26, 0x40, 0x01, 0x07, 0x09, 0x08, 0x18, 0xC3, // "Ħ" (U+0126)
  0x01, 0x27, 0x40, 0x01, 0x05, 0x0A, 0x07, 0x18, 0xE7, // "ħ" (U+0127)
  0x01, 0x28, 0xBF, 0x01, 0x03, 0x0C, 0x04, 0x19, 0x05, // "Ĩ" (U+0128)
  0x01, 0x29, 0xBF, 0x01, 0x03, 0x0A, 0x03, 0x19, 0x23, // "ĩ" (U+0129)
  0x01, 0x2A, 0x40, 0x01, 0x03, 0x0C, 0x04, 0x19, 0x3C, // "Ī" (U+012A)
  0x01, 0x2B, 0xBF, 0x01, 0x02, 0x0A, 0x03, 0x19, 0x54, // "ī" (U+012B)
  0x01, 0x2C, 0x40, 0x01, 0x04, 0x0C, 0x04, 0x19, 0x68, // "Ĭ" (U+012C)
  0x01, 0x2D, 0xBF, 0x01, 0x03, 0x0A, 0x03, 0x19, 0x86, // "ĭ" (U+012D)
  0x01, 0x2E, 0x40, 0xFD, 0x03, 0x09, 0x04, 0x19, 0x9F, // "Į" (U+012E)
  0x01, 0x2F, 0x40, 0xFD, 0x02, 0x0A, 0x03, 0x19, 0xB9, // "į" (U+012F)
  0x01, 0x30, 0x40, 0x01, 0x03, 0x0B, 0x04, 0x19, 0xCE, // "İ" (U+0130)
  0x01, 0x31, 0x40, 0x01, 0x02, 0x07, 0x03, 0x19, 0xE4, // "ı" (U+0131)
  0x01, 0x32, 0x40, 0xFE, 0x06, 0x09, 0x08, 0x19, 0xEF, // "Ĳ" (U+0132)
  0x01, 0x33, 0x40, 0xFE, 0x05, 0x0A, 0x06, 0x1A, 0x19, // "ĳ" (U+0133)
  0x01, 0x34, 0xBF, 0xFE, 0x03, 0x0C, 0x03, 0x1A, 0x40, // "Ĵ" (U+0134)
  0x01, 0x35, 0xBF, 0xFE, 0x03, 0x0A, 0x03, 0x1A, 0x66, // "ĵ" (U+0135)
  0x01, 0x36, 0x00, 0xFE, 0x06, 0x09, 0x07, 0x1A, 0x87, // "Ķ" (U+0136)
  0x01, 0x37, 0x00, 0xFE, 0x05, 0x0A, 0x06, 0x1A, 0xAF, // "ķ" (U+0137)
  0x01, 0x38, 0x40, 0x01, 0x05, 0x07, 0x06, 0x1A, 0xD5, // "ĸ" (U+0138)
  0x01, 0x39, 0x00, 0x01, 0x05, 0x0C, 0x05, 0x1A, 0xEA, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x40, 0x01, 0x02, 0x0D, 0x03, 0x1B, 0x0D, // "ĺ" (U+013A)
  0x01, 0x3B, 0x00, 0xFE, 0x05, 0x09, 0x05, 0x1B, 0x21, // "Ļ" (U+013B)
  0x01, 0x3C, 0x40, 0xFE, 0x02, 0x0A, 0x03, 0x1B, 0x42, // "ļ" (U+013C)
  0x01, 0x3D, 0x40, 0x01, 0x05, 0x09, 0x05, 0x1B, 0x56, // "Ľ" (U+013D)
  0x01, 0x3E, 0x40, 0x01, 0x04, 0x0A, 0x03, 0x1B, 0x71, // "ľ" (U+013E)
  0x01, 0x3F, 0x40, 0x01, 0x05, 0x09, 0x05, 0x1B, 0x8A, // "Ŀ" (U+013F)
  0x01, 0x40, 0x40, 0x01, 0x04, 0x0A, 0x04, 0x1B, 0xA5, // "ŀ" (U+0140)
  0x01, 0x41, 0x00, 0x01, 0x05, 0x09, 0x06, 0x1B, 0xBE, // "Ł" (U+0141)
  0x01, 0x42, 0x40, 0x01, 0x03, 0x0A, 0x03, 0x1B, 0xD6, // "ł" (U+0142)
  0x01, 0x43, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x1B, 0xEA, // "Ń" (U+0143)
  0x01, 0x44, 0x40, 0x01, 0x05, 0x0A, 0x07, 0x1C, 0x19, // "ń" (U+0144)
  0x01, 0x45, 0x00, 0xFE, 0x07, 0x09, 0x08, 0x1C, 0x37, // "Ņ" (U+0145)
  0x01, 0x46, 0x00, 0xFE, 0x05, 0x07, 0x07, 0x1C, 0x65, // "ņ" (U+0146)
  0x01, 0x47, 0x40, 0x01, 0x07, 0x0C, 0x08, 0x1C, 0x82, // "Ň" (U+0147)
  0x01, 0x48, 0x40, 0x01, 0x05, 0x0A, 0x07, 0x1C, 0xB2, // "ň" (U+0148)
  0x01, 0x49, 0x40, 0x01, 0x06, 0x09, 0x08, 0x1C, 0xD0, // "ŉ" (U+0149)
  0x01, 0x4A, 0x40, 0xFE, 0x07, 0x09, 0x08, 0x1C, 0xF0, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x40, 0xFE, 0x05, 0x07, 0x07, 0x1D, 0x20, // "ŋ" (U+014B)
  0x01, 0x4C, 0x40, 0x01, 0x07, 0x0C, 0x08, 0x1D, 0x3E, // "Ō" (U+014C)
  0x01, 0x4D, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x1D, 0x6E, // "ō" (U+014D)
  0x01, 0x4E, 0x40, 0x01, 0x07, 0x0C, 0x08, 0x1D, 0x8C, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x1D, 0xBC, // "ŏ" (U+014F)
  0x01, 0x50, 0x40, 0x01, 0x07, 0x0C, 0x08, 0x1D, 0xDA, // "Ő" (U+0150)
  0x01, 0x51, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x1E, 0x0A, // "ő" (U+0151)
  0x01, 0x52, 0x40, 0x01, 0x08, 0x09, 0x09, 0x1E, 0x28, // "Œ" (U+0152)
  0x01, 0x53, 0x40, 0x01, 0x09, 0x07, 0x0A, 0x1E, 0x51, // "œ" (U+0153)
  0x01, 0x54, 0x40, 0x01, 0x06, 0x0C, 0x07, 0x1E, 0x74, // "Ŕ" (U+0154)
  0x01, 0x55, 0x40, 0x01, 0x04, 0x0A, 0x05, 0x1E, 0x9E, // "ŕ" (U+0155)
  0x01, 0x56, 0x00, 0xFE, 0x06, 0x09, 0x07, 0x1E, 0xB7, // "Ŗ" (U+0156)
  0x01, 0x57, 0x40, 0xFE, 0x04, 0x07, 0x05, 0x1E, 0xE0, // "ŗ" (U+0157)
  0x01, 0x58, 0x40, 0x01, 0x06, 0x0C, 0x07, 0x1E, 0xF9, // "Ř" (U+0158)
  0x01, 0x59, 0x40, 0x01, 0x04, 0x0A, 0x05, 0x1F, 0x23, // "ř" (U+0159)
  0x01, 0x5A, 0x40, 0x01, 0x05, 0x0C, 0x06, 0x1F, 0x3C, // "Ś" (U+015A)
  0x01, 0x5B, 0x40, 0x01, 0x04, 0x0A, 0x05, 0x1F, 0x60, // "ś" (U+015B)
  0x01, 0x5C, 0x40, 0x01, 0x05, 0x0C, 0x06, 0x1F, 0x79, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x40, 0x01, 0x04, 0x0A, 0x05, 0x1F, 0x9D, // "ŝ" (U+015D)
  0x01, 0x5E, 0x40, 0xFE, 0x05, 0x09, 0x06, 0x1F, 0xB6, // "Ş" (U+015E)
  0x01, 0x5F, 0x40, 0xFE, 0x04, 0x07, 0x05, 0x1F, 0xDA, // "ş" (U+015F)
  0x01, 0x60, 0x40, 0x01, 0x05, 0x0C, 0x06, 0x1F, 0xF3, // "Š" (U+0160)
  0x01, 0x61, 0x40, 0x01, 0x04, 0x0A, 0x05, 0x20, 0x17, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFE, 0x05, 0x09, 0x06, 0x20, 0x30, // "Ţ" (U+0162)
  0x01, 0x63, 0x40, 0xFE, 0x03, 0x09, 0x04, 0x20, 0x4D, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x05, 0x0C, 0x06, 0x20, 0x65, // "Ť" (U+0164)
  0x01, 0x65, 0x40, 0x01, 0x05, 0x0A, 0x04, 0x20, 0x81, // "ť" (U+0165)
  0x01, 0x66, 0x00, 0x01, 0x05, 0x09, 0x06, 0x20, 0x9F, // "Ŧ" (U+0166)
  0x01, 0x67, 0x40, 0x01, 0x03, 0x09, 0x04, 0x20, 0xB7, // "ŧ" (U+0167)
  0x01, 0x68, 0x40, 0x01, 0x06, 0x0C, 0x07, 0x20, 0xC9, // "Ũ" (U+0168)
  0x01, 0x69, 0x40, 0x01, 0x05, 0x0A, 0x07, 0x20, 0xF3, // "ũ" (U+0169)
  0x01, 0x6A, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x21, 0x11, // "Ū" (U+016A)
  0x01, 0x6B, 0x40, 0x01, 0x05, 0x0A, 0x07, 0x21, 0x3A, // "ū" (U+016B)
  0x01, 0x6C, 0x40, 0x01, 0x06, 0x0C, 0x07, 0x21, 0x58, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x40, 0x01, 0x05, 0x0A, 0x07, 0x21, 0x82, // "ŭ" (U+016D)
  0x01, 0x6E, 0x40, 0x01, 0x06, 0x0D, 0x07, 0x21, 0xA0, // "Ů" (U+016E)
  0x01, 0x6F, 0x40, 0x01, 0x05, 0x0B, 0x07, 0x21, 0xCE, // "ů" (U+016F)
  0x01, 0x70, 0x40, 0x01, 0x06, 0x0C, 0x07, 0x21, 0xEF, // "Ű" (U+0170)
  0x01, 0x71, 0x40, 0x01, 0x05, 0x0A, 0x07, 0x22, 0x19, // "ű" (U+0171)
  0x01, 0x72, 0x40, 0xFE, 0x06, 0x09, 0x07, 0x22, 0x37, // "Ų" (U+0172)
  0x01, 0x73, 0x40, 0xFD, 0x05, 0x07, 0x07, 0x22, 0x61, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x09, 0x0C, 0x0A, 0x22, 0x82, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x08, 0x0A, 0x09, 0x22, 0xBC, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x01, 0x06, 0x0C, 0x06, 0x22, 0xE7, // "Ŷ" (U+0176)
  0x01, 0x77, 0x40, 0xFE, 0x05, 0x0A, 0x06, 0x23, 0x0C, // "ŷ" (U+0177)
  0x01, 0x78, 0x00, 0x01, 0x06, 0x0B, 0x06, 0x23, 0x33, // "Ÿ" (U+0178)
  0x01, 0x79, 0x00, 0x01, 0x05, 0x0C, 0x06, 0x23, 0x57, // "Ź" (U+0179)
  0x01, 0x7A, 0x40, 0x01, 0x04, 0x0A, 0x05, 0x23, 0x7A, // "ź" (U+017A)
  0x01, 0x7B, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x23, 0x93, // "Ż" (U+017B)
  0x01, 0x7C, 0x40, 0x01, 0x04, 0x09, 0x05, 0x23, 0xB4, // "ż" (U+017C)
  0x01, 0x7D, 0x00, 0x01, 0x05, 0x0C, 0x06, 0x23, 0xCB, // "Ž" (U+017D)
  0x01, 0x7E, 0x40, 0x01, 0x04, 0x0A, 0x05, 0x23, 0xEE, // "ž" (U+017E)
  0x01, 0x7F, 0x40, 0x01, 0x03, 0x0A, 0x04, 0x24, 0x07, // "ſ" (U+017F)
  0x03, 0xA9, 0x40, 0x01, 0x07, 0x09, 0x08, 0x24, 0x1B, // "Ω" (U+03A9)
  0x03, 0xBC, 0x40, 0xFE, 0x05, 0x07, 0x07, 0x24, 0x3F, // "μ" (U+03BC)
  0x03, 0xC0, 0x40, 0x01, 0x07, 0x07, 0x07, 0x24, 0x5D, // "π" (U+03C0)
  0x20, 0x13, 0x00, 0x03, 0x05, 0x05, 0x06, 0x24, 0x79, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x03, 0x0B, 0x05, 0x0C, 0x24, 0x81, // "—" (U+2014)
  0x20, 0xAC, 0x40, 0x01, 0x05, 0x09, 0x06, 0x24, 0x8B, // "€" (U+20AC)
  0x20, 0xBF, 0x40, 0xFF, 0x05, 0x0A, 0x06, 0x24, 0xA6, // "₿" (U+20BF)
  0x20, 0x18, 0x40, 0x07, 0x02, 0x09, 0x03, 0x24, 0xCA, // "‘" (U+2018)
  0x20, 0x19, 0x40, 0x07, 0x02, 0x09, 0x03, 0x24, 0xCF, // "’" (U+2019)
  0x20, 0x1A, 0x40, 0x00, 0x02, 0x02, 0x03, 0x24, 0xD4, // "‚" (U+201A)
  0x20, 0x1B, 0x40, 0x07, 0x02, 0x09, 0x03, 0x24, 0xD9, // "‛" (U+201B)
  0x20, 0x1C, 0x40, 0x07, 0x04, 0x09, 0x05, 0x24, 0xDE, // "“" (U+201C)
  0x20, 0x1D, 0x40, 0x07, 0x04, 0x09, 0x05, 0x24, 0xE6, // "”" (U+201D)
  0x20, 0x1E, 0x40, 0x00, 0x04, 0x02, 0x06, 0x24, 0xEE, // "„" (U+201E)
  0x20, 0x1F, 0x40, 0x07, 0x04, 0x09, 0x05, 0x24, 0xF6, // "‟" (U+201F)
  0x20, 0x20, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x24, 0xFE, // "†" (U+2020)
  0x20, 0x21, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x25, 0x1B, // "‡" (U+2021)
  0x20, 0x22, 0x40, 0x04, 0x03, 0x07, 0x05, 0x25, 0x39, // "•" (U+2022)
  0x20, 0x26, 0x40, 0x01, 0x08, 0x02, 0x0A, 0x25, 0x41, // "…" (U+2026)
  0x20, 0x30, 0x00, 0x01, 0x0D, 0x09, 0x0E, 0x25, 0x4A, // "‰" (U+2030)
  0x20, 0x39, 0x40, 0x01, 0x03, 0x06, 0x04, 0x25, 0x88, // "‹" (U+2039)
  0x20, 0x3A, 0x40, 0x01, 0x03, 0x06, 0x04, 0x25, 0x94, // "›" (U+203A)
  0x20, 0x44, 0xFE, 0x01, 0x03, 0x09, 0x01, 0x25, 0xA0, // "⁄" (U+2044)
  0x21, 0x22, 0x40, 0x05, 0x07, 0x0A, 0x09, 0x25, 0xB9, // "™" (U+2122)
  0x21, 0x52, 0x00, 0x01, 0x0C, 0x09, 0x0D, 0x25, 0xD1, // "⅒" (U+2152)
  0xFB, 0x01, 0x40, 0x01, 0x06, 0x0A, 0x07, 0x26, 0x07, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0x40, 0x01, 0x06, 0x0A, 0x07, 0x26, 0x2A, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x01, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0x63, 0x01, // "c (U+0022 U+0063)
  0x00, 0x22, 0x00, 0x64, 0x01, // "d (U+0022 U+0064)
  0x00, 0x22, 0x00, 0x65, 0x01, // "e (U+0022 U+0065)
  0x00, 0x22, 0x00, 0x6F, 0x01, // "o (U+0022 U+006F)
  0x00, 0x22, 0x00, 0x71, 0x01, // "q (U+0022 U+0071)
  0x00, 0x22, 0x00, 0xC0, 0x01, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x01, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x01, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x01, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x01, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x01, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xC6, 0x01, // "Æ (U+0022 U+00C6)
  0x00, 0x22, 0x00, 0xE0, 0x01, // "à (U+0022 U+00E0)
  0x00, 0x22, 0x00, 0xE7, 0x01, // "ç (U+0022 U+00E7)
  0x00, 0x22, 0x00, 0xE8, 0x01, // "è (U+0022 U+00E8)
  0x00, 0x22, 0x00, 0xE9, 0x01, // "é (U+0022 U+00E9)
  0x00, 0x22, 0x00, 0xEA, 0x01, // "ê (U+0022 U+00EA)
  0x00, 0x22, 0x00, 0xEB, 0x01, // "ë (U+0022 U+00EB)
  0x00, 0x22, 0x00, 0xF2, 0x01, // "ò (U+0022 U+00F2)
  0x00, 0x22, 0x00, 0xF3, 0x01, // "ó (U+0022 U+00F3)
  0x00, 0x22, 0x00, 0xF4, 0x01, // "ô (U+0022 U+00F4)
  0x00, 0x22, 0x00, 0xF5, 0x01, // "õ (U+0022 U+00F5)
  0x00, 0x22, 0x00, 0xF6, 0x01, // "ö (U+0022 U+00F6)
  0x00, 0x22, 0x00, 0xF8, 0x01, // "ø (U+0022 U+00F8)
  0x00, 0x22, 0x01, 0x00, 0x01, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x02, 0x01, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x04, 0x01, // "Ą (U+0022 U+0104)
  0x00, 0x22, 0x01, 0x07, 0x01, // "ć (U+0022 U+0107)
  0x00, 0x22, 0x01, 0x09, 0x01, // "ĉ (U+0022 U+0109)
  0x00, 0x22, 0x01, 0x0B, 0x01, // "ċ (U+0022 U+010B)
  0x00, 0x22, 0x01, 0x0D, 0x01, // "č (U+0022 U+010D)
  0x00, 0x22, 0x01, 0x0F, 0x01, // "ď (U+0022 U+010F)
  0x00, 0x22, 0x01, 0x11, 0x01, // "đ (U+0022 U+0111)
  0x00, 0x22, 0x01, 0x13, 0x01, // "ē (U+0022 U+0113)
  0x00, 0x22, 0x01, 0x15, 0x01, // "ĕ (U+0022 U+0115)
  0x00, 0x22, 0x01, 0x17, 0x01, // "ė (U+0022 U+0117)
  0x00, 0x22, 0x01, 0x19, 0x01, // "ę (U+0022 U+0119)
  0x00, 0x22, 0x01, 0x1B, 0x01, // "ě (U+0022 U+011B)
  0x00, 0x22, 0x01, 0x4D, 0x01, // "ō (U+0022 U+014D)
  0x00, 0x22, 0x01, 0x4F, 0x01, // "ŏ (U+0022 U+014F)
  0x00, 0x22, 0x01, 0x51, 0x01, // "ő (U+0022 U+0151)
  0x00, 0x22, 0x01, 0x53, 0x01, // "œ (U+0022 U+0153)
  0x00, 0x27, 0x00, 0x41, 0x01, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0x63, 0x01, // 'c (U+0027 U+0063)
  0x00, 0x27, 0x00, 0x64, 0x01, // 'd (U+0027 U+0064)
  0x00, 0x27, 0x00, 0x65, 0x01, // 'e (U+0027 U+0065)
  0x00, 0x27, 0x00, 0x6F, 0x01, // 'o (U+0027 U+006F)
  0x00, 0x27, 0x00, 0x71, 0x01, // 'q (U+0027 U+0071)
  0x00, 0x27, 0x00, 0xC0, 0x01, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x01, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x01, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x01, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x01, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x01, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xC6, 0x01, // 'Æ (U+0027 U+00C6)
  0x00, 0x27, 0x00, 0xE0, 0x01, // 'à (U+0027 U+00E0)
  0x00, 0x27, 0x00, 0xE7, 0x01, // 'ç (U+0027 U+00E7)
  0x00, 0x27, 0x00, 0xE8, 0x01, // 'è (U+0027 U+00E8)
  0x00, 0x27, 0x00, 0xE9, 0x01, // 'é (U+0027 U+00E9)
  0x00, 0x27, 0x00, 0xEA, 0x01, // 'ê (U+0027 U+00EA)
  0x00, 0x27, 0x00, 0xEB, 0x01, // 'ë (U+0027 U+00EB)
  0x00, 0x27, 0x00, 0xF2, 0x01, // 'ò (U+0027 U+00F2)
  0x00, 0x27, 0x00, 0xF3, 0x01, // 'ó (U+0027 U+00F3)
  0x00, 0x27, 0x00, 0xF4, 0x01, // 'ô (U+0027 U+00F4)
  0x00, 0x27, 0x00, 0xF5, 0x01, // 'õ (U+0027 U+00F5)
  0x00, 0x27, 0x00, 0xF6, 0x01, // 'ö (U+0027 U+00F6)
  0x00, 0x27, 0x00, 0xF8, 0x01, // 'ø (U+0027 U+00F8)
  0x00, 0x27, 0x01, 0x00, 0x01, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x02, 0x01, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x04, 0x01, // 'Ą (U+0027 U+0104)
  0x00, 0x27, 0x01, 0x07, 0x01, // 'ć (U+0027 U+0107)
  0x00, 0x27, 0x01, 0x09, 0x01, // 'ĉ (U+0027 U+0109)
  0x00, 0x27, 0x01, 0x0B, 0x01, // 'ċ (U+0027 U+010B)
  0x00, 0x27, 0x01, 0x0D, 0x01, // 'č (U+0027 U+010D)
  0x00, 0x27, 0x01, 0x0F, 0x01, // 'ď (U+0027 U+010F)
  0x00, 0x27, 0x01, 0x11, 0x01, // 'đ (U+0027 U+0111)
  0x00, 0x27, 0x01, 0x13, 0x01, // 'ē (U+0027 U+0113)
  0x00, 0x27, 0x01, 0x15, 0x01, // 'ĕ (U+0027 U+0115)
  0x00, 0x27, 0x01, 0x17, 0x01, // 'ė (U+0027 U+0117)
  0x00, 0x27, 0x01, 0x19, 0x01, // 'ę (U+0027 U+0119)
  0x00, 0x27, 0x01, 0x1B, 0x01, // 'ě (U+0027 U+011B)
  0x00, 0x27, 0x01, 0x4D, 0x01, // 'ō (U+0027 U+014D)
  0x00, 0x27, 0x01, 0x4F, 0x01, // 'ŏ (U+0027 U+014F)
  0x00, 0x27, 0x01, 0x51, 0x01, // 'ő (U+0027 U+0151)
  0x00, 0x27, 0x01, 0x53, 0x01, // 'œ (U+0027 U+0153)
  0x00, 0x2C, 0x00, 0x54, 0x01, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x56, 0x01, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x01, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x01, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0xDD, 0x01, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x01, 0x62, 0x01, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x01, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x01, // ,Ŧ (U+002C U+0166)
  0x00, 0x2C, 0x01, 0x74, 0x01, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x76, 0x01, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x78, 0x01, // ,Ÿ (U+002C U+0178)
  0x00, 0x2E, 0x00, 0x54, 0x01, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x56, 0x01, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x01, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x01, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0xDD, 0x01, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x01, 0x62, 0x01, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x01, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x01, // .Ŧ (U+002E U+0166)
  0x00, 0x2E, 0x01, 0x74, 0x01, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x76, 0x01, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x78, 0x01, // .Ÿ (U+002E U+0178)
  0x00, 0x41, 0x00, 0x22, 0x01, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x01, // A' (U+0041 U+0027)
  0x00, 0x41, 0x20, 0x19, 0x01, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1D, 0x01, // A” (U+0041 U+201D)
  0x00, 0x46, 0x00, 0x2C, 0x01, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x01, // F. (U+0046 U+002E)
  0x00, 0x46, 0x20, 0x1A, 0x01, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x01, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x01, // F… (U+0046 U+2026)
  0x00, 0x4C, 0x00, 0x22, 0x01, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x01, // L' (U+004C U+0027)
  0x00, 0x4C, 0x20, 0x19, 0x01, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1D, 0x01, // L” (U+004C U+201D)
  0x00, 0x50, 0x00, 0x2C, 0x01, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x01, // P. (U+0050 U+002E)
  0x00, 0x50, 0x20, 0x1A, 0x01, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x01, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x01, // P… (U+0050 U+2026)
  0x00, 0x54, 0x00, 0x2C, 0x01, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2E, 0x01, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0x61, 0x01, // Ta (U+0054 U+0061)
  0x00, 0x54, 0x00, 0x63, 0x01, // Tc (U+0054 U+0063)
  0x00, 0x54, 0x00, 0x64, 0x01, // Td (U+0054 U+0064)
  0x00, 0x54, 0x00, 0x65, 0x01, // Te (U+0054 U+0065)
  0x00, 0x54, 0x00, 0x67, 0x01, // Tg (U+0054 U+0067)
  0x00, 0x54, 0x00, 0x6F, 0x01, // To (U+0054 U+006F)
  0x00, 0x54, 0x00, 0x71, 0x01, // Tq (U+0054 U+0071)
  0x00, 0x54, 0x00, 0x73, 0x01, // Ts (U+0054 U+0073)
  0x00, 0x54, 0x00, 0xAB, 0x01, // T« (U+0054 U+00AB)
  0x00, 0x54, 0x00, 0xE0, 0x01, // Tà (U+0054 U+00E0)
  0x00, 0x54, 0x00, 0xE1, 0x01, // Tá (U+0054 U+00E1)
  0x00, 0x54, 0x00, 0xE2, 0x01, // Tâ (U+0054 U+00E2)
  0x00, 0x54, 0x00, 0xE3, 0x01, // Tã (U+0054 U+00E3)
  0x00, 0x54, 0x00, 0xE4, 0x01, // Tä (U+0054 U+00E4)
  0x00, 0x54, 0x00, 0xE5, 0x01, // Tå (U+0054 U+00E5)
  0x00, 0x54, 0x00, 0xE6, 0x01, // Tæ (U+0054 U+00E6)
  0x00, 0x54, 0x00, 0xE7, 0x01, // Tç (U+0054 U+00E7)
  0x00, 0x54, 0x00, 0xE8, 0x01, // Tè (U+0054 U+00E8)
  0x00, 0x54, 0x00, 0xE9, 0x01, // Té (U+0054 U+00E9)
  0x00, 0x54, 0x00, 0xEA, 0x01, // Tê (U+0054 U+00EA)
  0x00, 0x54, 0x00, 0xEB, 0x01, // Të (U+0054 U+00EB)
  0x00, 0x54, 0x00, 0xF2, 0x01, // Tò (U+0054 U+00F2)
  0x00, 0x54, 0x00, 0xF3, 0x01, // Tó (U+0054 U+00F3)
  0x00, 0x54, 0x00, 0xF4, 0x01, // Tô (U+0054 U+00F4)
  0x00, 0x54, 0x00, 0xF5, 0x01, // Tõ (U+0054 U+00F5)
  0x00, 0x54, 0x00, 0xF6, 0x01, // Tö (U+0054 U+00F6)
  0x00, 0x54, 0x00, 0xF8, 0x01, // Tø (U+0054 U+00F8)
  0x00, 0x54, 0x01, 0x01, 0x01, // Tā (U+0054 U+0101)
  0x00, 0x54, 0x01, 0x03, 0x01, // Tă (U+0054 U+0103)
  0x00, 0x54, 0x01, 0x05, 0x01, // Tą (U+0054 U+0105)
  0x00, 0x54, 0x01, 0x07, 0x01, // Tć (U+0054 U+0107)
  0x00, 0x54, 0x01, 0x09, 0x01, // Tĉ (U+0054 U+0109)
  0x00, 0x54, 0x01, 0x0B, 0x01, // Tċ (U+0054 U+010B)
  0x00, 0x54, 0x01, 0x0D, 0x01, // Tč (U+0054 U+010D)
  0x00, 0x54, 0x01, 0x0F, 0x01, // Tď (U+0054 U+010F)
  0x00, 0x54, 0x01, 0x11, 0x01, // Tđ (U+0054 U+0111)
  0x00, 0x54, 0x01, 0x13, 0x01, // Tē (U+0054 U+0113)
  0x00, 0x54, 0x01, 0x15, 0x01, // Tĕ (U+0054 U+0115)
  0x00, 0x54, 0x01, 0x17, 0x01, // Tė (U+0054 U+0117)
  0x00, 0x54, 0x01, 0x19, 0x01, // Tę (U+0054 U+0119)
  0x00, 0x54, 0x01, 0x1B, 0x01, // Tě (U+0054 U+011B)
  0x00, 0x54, 0x01, 0x1D, 0x01, // Tĝ (U+0054 U+011D)
  0x00, 0x54, 0x01, 0x1F, 0x01, // Tğ (U+0054 U+011F)
  0x00, 0x54, 0x01, 0x21, 0x01, // Tġ (U+0054 U+0121)
  0x00, 0x54, 0x01, 0x23, 0x01, // Tģ (U+0054 U+0123)
  0x00, 0x54, 0x01, 0x4D, 0x01, // Tō (U+0054 U+014D)
  0x00, 0x54, 0x01, 0x4F, 0x01, // Tŏ (U+0054 U+014F)
  0x00, 0x54, 0x01, 0x51, 0x01, // Tő (U+0054 U+0151)
  0x00, 0x54, 0x01, 0x53, 0x01, // Tœ (U+0054 U+0153)
  0x00, 0x54, 0x01, 0x5B, 0x01, // Tś (U+0054 U+015B)
  0x00, 0x54, 0x01, 0x5F, 0x01, // Tş (U+0054 U+015F)
  0x00, 0x54, 0x20, 0x1A, 0x01, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x01, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x01, // T… (U+0054 U+2026)
  0x00, 0x54, 0x20, 0x39, 0x01, // T‹ (U+0054 U+2039)
  0x00, 0x59, 0x00, 0x2C, 0x01, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x01, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x00, 0xAB, 0x01, // Y« (U+0059 U+00AB)
  0x00, 0x59, 0x20, 0x1A, 0x01, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x01, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x01, // Y… (U+0059 U+2026)
  0x00, 0x59, 0x20, 0x39, 0x01, // Y‹ (U+0059 U+2039)
  0x00, 0x72, 0x00, 0x2C, 0x01, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x01, // r. (U+0072 U+002E)
  0x00, 0x72, 0x20, 0x1A, 0x01, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x01, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x01, // r… (U+0072 U+2026)
  0x00, 0xBB, 0x00, 0x54, 0x01, // »T (U+00BB U+0054)
  0x00, 0xBB, 0x00, 0x59, 0x01, // »Y (U+00BB U+0059)
  0x00, 0xBB, 0x00, 0xDD, 0x01, // »Ý (U+00BB U+00DD)
  0x00, 0xBB, 0x01, 0x62, 0x01, // »Ţ (U+00BB U+0162)
  0x00, 0xBB, 0x01, 0x64, 0x01, // »Ť (U+00BB U+0164)
  0x00, 0xBB, 0x01, 0x66, 0x01, // »Ŧ (U+00BB U+0166)
  0x00, 0xBB, 0x01, 0x76, 0x01, // »Ŷ (U+00BB U+0176)
  0x00, 0xBB, 0x01, 0x78, 0x01, // »Ÿ (U+00BB U+0178)
  0x00, 0xC0, 0x00, 0x22, 0x01, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x01, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x20, 0x19, 0x01, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1D, 0x01, // À” (U+00C0 U+201D)
  0x00, 0xC1, 0x00, 0x22, 0x01, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x01, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x20, 0x19, 0x01, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1D, 0x01, // Á” (U+00C1 U+201D)
  0x00, 0xC2, 0x00, 0x22, 0x01, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x01, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x20, 0x19, 0x01, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1D, 0x01, // Â” (U+00C2 U+201D)
  0x00, 0xC3, 0x00, 0x22, 0x01, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x01, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x20, 0x19, 0x01, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1D, 0x01, // Ã” (U+00C3 U+201D)
  0x00, 0xC4, 0x00, 0x22, 0x01, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x01, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x20, 0x19, 0x01, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1D, 0x01, // Ä” (U+00C4 U+201D)
  0x00, 0xC5, 0x00, 0x22, 0x01, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x01, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x20, 0x19, 0x01, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1D, 0x01, // Å” (U+00C5 U+201D)
  0x00, 0xDD, 0x00, 0x2C, 0x01, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x01, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x00, 0xAB, 0x01, // Ý« (U+00DD U+00AB)
  0x00, 0xDD, 0x20, 0x1A, 0x01, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x01, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x01, // Ý… (U+00DD U+2026)
  0x00, 0xDD, 0x20, 0x39, 0x01, // Ý‹ (U+00DD U+2039)
  0x00, 0xDE, 0x00, 0x2C, 0x01, // Þ, (U+00DE U+002C)
  0x00, 0xDE, 0x00, 0x2E, 0x01, // Þ. (U+00DE U+002E)
  0x00, 0xDE, 0x20, 0x1A, 0x01, // Þ‚ (U+00DE U+201A)
  0x00, 0xDE, 0x20, 0x1E, 0x01, // Þ„ (U+00DE U+201E)
  0x00, 0xDE, 0x20, 0x26, 0x01, // Þ… (U+00DE U+2026)
  0x01, 0x00, 0x00, 0x22, 0x01, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x01, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x20, 0x19, 0x01, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1D, 0x01, // Ā” (U+0100 U+201D)
  0x01, 0x02, 0x00, 0x22, 0x01, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x01, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x20, 0x19, 0x01, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1D, 0x01, // Ă” (U+0102 U+201D)
  0x01, 0x04, 0x00, 0x22, 0x01, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x01, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x20, 0x19, 0x01, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1D, 0x01, // Ą” (U+0104 U+201D)
  0x01, 0x39, 0x00, 0x22, 0x01, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x01, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x20, 0x19, 0x01, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1D, 0x01, // Ĺ” (U+0139 U+201D)
  0x01, 0x3B, 0x00, 0x22, 0x01, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x01, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x20, 0x19, 0x01, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1D, 0x01, // Ļ” (U+013B U+201D)
  0x01, 0x3D, 0x00, 0x22, 0x01, // Ľ" (U+013D U+0022)
  0x01, 0x3D, 0x00, 0x27, 0x01, // Ľ' (U+013D U+0027)
  0x01, 0x3D, 0x20, 0x19, 0x01, // Ľ’ (U+013D U+2019)
  0x01, 0x3D, 0x20, 0x1D, 0x01, // Ľ” (U+013D U+201D)
  0x01, 0x3F, 0x00, 0x22, 0x01, // Ŀ" (U+013F U+0022)
  0x01, 0x3F, 0x00, 0x27, 0x01, // Ŀ' (U+013F U+0027)
  0x01, 0x3F, 0x20, 0x19, 0x01, // Ŀ’ (U+013F U+2019)
  0x01, 0x3F, 0x20, 0x1D, 0x01, // Ŀ” (U+013F U+201D)
  0x01, 0x41, 0x00, 0x22, 0x01, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x01, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x20, 0x19, 0x01, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1D, 0x01, // Ł” (U+0141 U+201D)
  0x01, 0x55, 0x00, 0x2C, 0x01, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x01, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x20, 0x1A, 0x01, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x01, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x01, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x01, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x01, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x20, 0x1A, 0x01, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x01, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x01, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x01, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x01, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x20, 0x1A, 0x01, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x01, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x01, // ř… (U+0159 U+2026)
  0x01, 0x62, 0x00, 0x2C, 0x01, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2E, 0x01, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0x61, 0x01, // Ţa (U+0162 U+0061)
  0x01, 0x62, 0x00, 0x63, 0x01, // Ţc (U+0162 U+0063)
  0x01, 0x62, 0x00, 0x64, 0x01, // Ţd (U+0162 U+0064)
  0x01, 0x62, 0x00, 0x65, 0x01, // Ţe (U+0162 U+0065)
  0x01, 0x62, 0x00, 0x67, 0x01, // Ţg (U+0162 U+0067)
  0x01, 0x62, 0x00, 0x6F, 0x01, // Ţo (U+0162 U+006F)
  0x01, 0x62, 0x00, 0x71, 0x01, // Ţq (U+0162 U+0071)
  0x01, 0x62, 0x00, 0x73, 0x01, // Ţs (U+0162 U+0073)
  0x01, 0x62, 0x00, 0xAB, 0x01, // Ţ« (U+0162 U+00AB)
  0x01, 0x62, 0x00, 0xE0, 0x01, // Ţà (U+0162 U+00E0)
  0x01, 0x62, 0x00, 0xE1, 0x01, // Ţá (U+0162 U+00E1)
  0x01, 0x62, 0x00, 0xE2, 0x01, // Ţâ (U+0162 U+00E2)
  0x01, 0x62, 0x00, 0xE3, 0x01, // Ţã (U+0162 U+00E3)
  0x01, 0x62, 0x00, 0xE4, 0x01, // Ţä (U+0162 U+00E4)
  0x01, 0x62, 0x00, 0xE5, 0x01, // Ţå (U+0162 U+00E5)
  0x01, 0x62, 0x00, 0xE6, 0x01, // Ţæ (U+0162 U+00E6)
  0x01, 0x62, 0x00, 0xE7, 0x01, // Ţç (U+0162 U+00E7)
  0x01, 0x62, 0x00, 0xE8, 0x01, // Ţè (U+0162 U+00E8)
  0x01, 0x62, 0x00, 0xE9, 0x01, // Ţé (U+0162 U+00E9)
  0x01, 0x62, 0x00, 0xEA, 0x01, // Ţê (U+0162 U+00EA)
  0x01, 0x62, 0x00, 0xEB, 0x01, // Ţë (U+0162 U+00EB)
  0x01, 0x62, 0x00, 0xF2, 0x01, // Ţò (U+0162 U+00F2)
  0x01, 0x62, 0x00, 0xF3, 0x01, // Ţó (U+0162 U+00F3)
  0x01, 0x62, 0x00, 0xF4, 0x01, // Ţô (U+0162 U+00F4)
  0x01, 0x62, 0x00, 0xF5, 0x01, // Ţõ (U+0162 U+00F5)
  0x01, 0x62, 0x00, 0xF6, 0x01, // Ţö (U+0162 U+00F6)
  0x01, 0x62, 0x00, 0xF8, 0x01, // Ţø (U+0162 U+00F8)
  0x01, 0x62, 0x01, 0x01, 0x01, // Ţā (U+0162 U+0101)
  0x01, 0x62, 0x01, 0x03, 0x01, // Ţă (U+0162 U+0103)
  0x01, 0x62, 0x01, 0x05, 0x01, // Ţą (U+0162 U+0105)
  0x01, 0x62, 0x01, 0x07, 0x01, // Ţć (U+0162 U+0107)
  0x01, 0x62, 0x01, 0x09, 0x01, // Ţĉ (U+0162 U+0109)
  0x01, 0x62, 0x01, 0x0B, 0x01, // Ţċ (U+0162 U+010B)
  0x01, 0x62, 0x01, 0x0D, 0x01, // Ţč (U+0162 U+010D)
  0x01, 0x62, 0x01, 0x0F, 0x01, // Ţď (U+0162 U+010F)
  0x01, 0x62, 0x01, 0x11, 0x01, // Ţđ (U+0162 U+0111)
  0x01, 0x62, 0x01, 0x13, 0x01, // Ţē (U+0162 U+0113)
  0x01, 0x62, 0x01, 0x15, 0x01, // Ţĕ (U+0162 U+0115)
  0x01, 0x62, 0x01, 0x17, 0x01, // Ţė (U+0162 U+0117)
  0x01, 0x62, 0x01, 0x19, 0x01, // Ţę (U+0162 U+0119)
  0x01, 0x62, 0x01, 0x1B, 0x01, // Ţě (U+0162 U+011B)
  0x01, 0x62, 0x01, 0x1D, 0x01, // Ţĝ (U+0162 U+011D)
  0x01, 0x62, 0x01, 0x1F, 0x01, // Ţğ (U+0162 U+011F)
  0x01, 0x62, 0x01, 0x21, 0x01, // Ţġ (U+0162 U+0121)
  0x01, 0x62, 0x01, 0x23, 0x01, // Ţģ (U+0162 U+0123)
  0x01, 0x62, 0x01, 0x4D, 0x01, // Ţō (U+0162 U+014D)
  0x01, 0x62, 0x01, 0x4F, 0x01, // Ţŏ (U+0162 U+014F)
  0x01, 0x62, 0x01, 0x51, 0x01, // Ţő (U+0162 U+0151)
  0x01, 0x62, 0x01, 0x53, 0x01, // Ţœ (U+0162 U+0153)
  0x01, 0x62, 0x01, 0x5B, 0x01, // Ţś (U+0162 U+015B)
  0x01, 0x62, 0x01, 0x5F, 0x01, // Ţş (U+0162 U+015F)
  0x01, 0x62, 0x20, 0x1A, 0x01, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x01, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x01, // Ţ… (U+0162 U+2026)
  0x01, 0x62, 0x20, 0x39, 0x01, // Ţ‹ (U+0162 U+2039)
  0x01, 0x64, 0x00, 0x2C, 0x01, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2E, 0x01, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0x61, 0x01, // Ťa (U+0164 U+0061)
  0x01, 0x64, 0x00, 0x63, 0x01, // Ťc (U+0164 U+0063)
  0x01, 0x64, 0x00, 0x64, 0x01, // Ťd (U+0164 U+0064)
  0x01, 0x64, 0x00, 0x65, 0x01, // Ťe (U+0164 U+0065)
  0x01, 0x64, 0x00, 0x67, 0x01, // Ťg (U+0164 U+0067)
  0x01, 0x64, 0x00, 0x6F, 0x01, // Ťo (U+0164 U+006F)
  0x01, 0x64, 0x00, 0x71, 0x01, // Ťq (U+0164 U+0071)
  0x01, 0x64, 0x00, 0x73, 0x01, // Ťs (U+0164 U+0073)
  0x01, 0x64, 0x00, 0xAB, 0x01, // Ť« (U+0164 U+00AB)
  0x01, 0x64, 0x00, 0xE0, 0x01, // Ťà (U+0164 U+00E0)
  0x01, 0x64, 0x00, 0xE1, 0x01, // Ťá (U+0164 U+00E1)
  0x01, 0x64, 0x00, 0xE2, 0x01, // Ťâ (U+0164 U+00E2)
  0x01, 0x64, 0x00, 0xE3, 0x01, // Ťã (U+0164 U+00E3)
  0x01, 0x64, 0x00, 0xE4, 0x01, // Ťä (U+0164 U+00E4)
  0x01, 0x64, 0x00, 0xE5, 0x01, // Ťå (U+0164 U+00E5)
  0x01, 0x64, 0x00, 0xE6, 0x01, // Ťæ (U+0164 U+00E6)
  0x01, 0x64, 0x00, 0xE7, 0x01, // Ťç (U+0164 U+00E7)
  0x01, 0x64, 0x00, 0xE8, 0x01, // Ťè (U+0164 U+00E8)
  0x01, 0x64, 0x00, 0xE9, 0x01, // Ťé (U+0164 U+00E9)
  0x01, 0x64, 0x00, 0xEA, 0x01, // Ťê (U+0164 U+00EA)
  0x01, 0x64, 0x00, 0xEB, 0x01, // Ťë (U+0164 U+00EB)
  0x01, 0x64, 0x00, 0xF2, 0x01, // Ťò (U+0164 U+00F2)
  0x01, 0x64, 0x00, 0xF3, 0x01, // Ťó (U+0164 U+00F3)
  0x01, 0x64, 0x00, 0xF4, 0x01, // Ťô (U+0164 U+00F4)
  0x01, 0x64, 0x00, 0xF5, 0x01, // Ťõ (U+0164 U+00F5)
  0x01, 0x64, 0x00, 0xF6, 0x01, // Ťö (U+0164 U+00F6)
  0x01, 0x64, 0x00, 0xF8, 0x01, // Ťø (U+0164 U+00F8)
  0x01, 0x64, 0x01, 0x01, 0x01, // Ťā (U+0164 U+0101)
  0x01, 0x64, 0x01, 0x03, 0x01, // Ťă (U+0164 U+0103)
  0x01, 0x64, 0x01, 0x05, 0x01, // Ťą (U+0164 U+0105)
  0x01, 0x64, 0x01, 0x07, 0x01, // Ťć (U+0164 U+0107)
  0x01, 0x64, 0x01, 0x09, 0x01, // Ťĉ (U+0164 U+0109)
  0x01, 0x64, 0x01, 0x0B, 0x01, // Ťċ (U+0164 U+010B)
  0x01, 0x64, 0x01, 0x0D, 0x01, // Ťč (U+0164 U+010D)
  0x01, 0x64, 0x01, 0x0F, 0x01, // Ťď (U+0164 U+010F)
  0x01, 0x64, 0x01, 0x11, 0x01, // Ťđ (U+0164 U+0111)
  0x01, 0x64, 0x01, 0x13, 0x01, // Ťē (U+0164 U+0113)
  0x01, 0x64, 0x01, 0x15, 0x01, // Ťĕ (U+0164 U+0115)
  0x01, 0x64, 0x01, 0x17, 0x01, // Ťė (U+0164 U+0117)
  0x01, 0x64, 0x01, 0x19, 0x01, // Ťę (U+0164 U+0119)
  0x01, 0x64, 0x01, 0x1B, 0x01, // Ťě (U+0164 U+011B)
  0x01, 0x64, 0x01, 0x1D, 0x01, // Ťĝ (U+0164 U+011D)
  0x01, 0x64, 0x01, 0x1F, 0x01, // Ťğ (U+0164 U+011F)
  0x01, 0x64, 0x01, 0x21, 0x01, // Ťġ (U+0164 U+0121)
  0x01, 0x64, 0x01, 0x23, 0x01, // Ťģ (U+0164 U+0123)
  0x01, 0x64, 0x01, 0x4D, 0x01, // Ťō (U+0164 U+014D)
  0x01, 0x64, 0x01, 0x4F, 0x01, // Ťŏ (U+0164 U+014F)
  0x01, 0x64, 0x01, 0x51, 0x01, // Ťő (U+0164 U+0151)
  0x01, 0x64, 0x01, 0x53, 0x01, // Ťœ (U+0164 U+0153)
  0x01, 0x64, 0x01, 0x5B, 0x01, // Ťś (U+0164 U+015B)
  0x01, 0x64, 0x01, 0x5F, 0x01, // Ťş (U+0164 U+015F)
  0x01, 0x64, 0x20, 0x1A, 0x01, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x01, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x01, // Ť… (U+0164 U+2026)
  0x01, 0x64, 0x20, 0x39, 0x01, // Ť‹ (U+0164 U+2039)
  0x01, 0x66, 0x00, 0x2C, 0x01, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2E, 0x01, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0x61, 0x01, // Ŧa (U+0166 U+0061)
  0x01, 0x66, 0x00, 0x63, 0x01, // Ŧc (U+0166 U+0063)
  0x01, 0x66, 0x00, 0x64, 0x01, // Ŧd (U+0166 U+0064)
  0x01, 0x66, 0x00, 0x65, 0x01, // Ŧe (U+0166 U+0065)
  0x01, 0x66, 0x00, 0x67, 0x01, // Ŧg (U+0166 U+0067)
  0x01, 0x66, 0x00, 0x6F, 0x01, // Ŧo (U+0166 U+006F)
  0x01, 0x66, 0x00, 0x71, 0x01, // Ŧq (U+0166 U+0071)
  0x01, 0x66, 0x00, 0x73, 0x01, // Ŧs (U+0166 U+0073)
  0x01, 0x66, 0x00, 0xAB, 0x01, // Ŧ« (U+0166 U+00AB)
  0x01, 0x66, 0x00, 0xE0, 0x01, // Ŧà (U+0166 U+00E0)
  0x01, 0x66, 0x00, 0xE1, 0x01, // Ŧá (U+0166 U+00E1)
  0x01, 0x66, 0x00, 0xE2, 0x01, // Ŧâ (U+0166 U+00E2)
  0x01, 0x66, 0x00, 0xE3, 0x01, // Ŧã (U+0166 U+00E3)
  0x01, 0x66, 0x00, 0xE4, 0x01, // Ŧä (U+0166 U+00E4)
  0x01, 0x66, 0x00, 0xE5, 0x01, // Ŧå (U+0166 U+00E5)
  0x01, 0x66, 0x00, 0xE6, 0x01, // Ŧæ (U+0166 U+00E6)
  0x01, 0x66, 0x00, 0xE7, 0x01, // Ŧç (U+0166 U+00E7)
  0x01, 0x66, 0x00, 0xE8, 0x01, // Ŧè (U+0166 U+00E8)
  0x01, 0x66, 0x00, 0xE9, 0x01, // Ŧé (U+0166 U+00E9)
  0x01, 0x66, 0x00, 0xEA, 0x01, // Ŧê (U+0166 U+00EA)
  0x01, 0x66, 0x00, 0xEB, 0x01, // Ŧë (U+0166 U+00EB)
  0x01, 0x66, 0x00, 0xF2, 0x01, // Ŧò (U+0166 U+00F2)
  0x01, 0x66, 0x00, 0xF3, 0x01, // Ŧó (U+0166 U+00F3)
  0x01, 0x66, 0x00, 0xF4, 0x01, // Ŧô (U+0166 U+00F4)
  0x01, 0x66, 0x00, 0xF5, 0x01, // Ŧõ (U+0166 U+00F5)
  0x01, 0x66, 0x00, 0xF6, 0x01, // Ŧö (U+0166 U+00F6)
  0x01, 0x66, 0x00, 0xF8, 0x01, // Ŧø (U+0166 U+00F8)
  0x01, 0x66, 0x01, 0x01, 0x01, // Ŧā (U+0166 U+0101)
  0x01, 0x66, 0x01, 0x03, 0x01, // Ŧă (U+0166 U+0103)
  0x01, 0x66, 0x01, 0x05, 0x01, // Ŧą (U+0166 U+0105)
  0x01, 0x66, 0x01, 0x07, 0x01, // Ŧć (U+0166 U+0107)
  0x01, 0x66, 0x01, 0x09, 0x01, // Ŧĉ (U+0166 U+0109)
  0x01, 0x66, 0x01, 0x0B, 0x01, // Ŧċ (U+0166 U+010B)
  0x01, 0x66, 0x01, 0x0D, 0x01, // Ŧč (U+0166 U+010D)
  0x01, 0x66, 0x01, 0x0F, 0x01, // Ŧď (U+0166 U+010F)
  0x01, 0x66, 0x01, 0x11, 0x01, // Ŧđ (U+0166 U+0111)
  0x01, 0x66, 0x01, 0x13, 0x01, // Ŧē (U+0166 U+0113)
  0x01, 0x66, 0x01, 0x15, 0x01, // Ŧĕ (U+0166 U+0115)
  0x01, 0x66, 0x01, 0x17, 0x01, // Ŧė (U+0166 U+0117)
  0x01, 0x66, 0x01, 0x19, 0x01, // Ŧę (U+0166 U+0119)
  0x01, 0x66, 0x01, 0x1B, 0x01, // Ŧě (U+0166 U+011B)
  0x01, 0x66, 0x01, 0x1D, 0x01, // Ŧĝ (U+0166 U+011D)
  0x01, 0x66, 0x01, 0x1F, 0x01, // Ŧğ (U+0166 U+011F)
  0x01, 0x66, 0x01, 0x21, 0x01, // Ŧġ (U+0166 U+0121)
  0x01, 0x66, 0x01, 0x23, 0x01, // Ŧģ (U+0166 U+0123)
  0x01, 0x66, 0x01, 0x4D, 0x01, // Ŧō (U+0166 U+014D)
  0x01, 0x66, 0x01, 0x4F, 0x01, // Ŧŏ (U+0166 U+014F)
  0x01, 0x66, 0x01, 0x51, 0x01, // Ŧő (U+0166 U+0151)
  0x01, 0x66, 0x01, 0x53, 0x01, // Ŧœ (U+0166 U+0153)
  0x01, 0x66, 0x01, 0x5B, 0x01, // Ŧś (U+0166 U+015B)
  0x01, 0x66, 0x01, 0x5F, 0x01, // Ŧş (U+0166 U+015F)
  0x01, 0x66, 0x20, 0x1A, 0x01, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x01, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x01, // Ŧ… (U+0166 U+2026)
  0x01, 0x66, 0x20, 0x39, 0x01, // Ŧ‹ (U+0166 U+2039)
  0x01, 0x76, 0x00, 0x2C, 0x01, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x01, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x00, 0xAB, 0x01, // Ŷ« (U+0176 U+00AB)
  0x01, 0x76, 0x20, 0x1A, 0x01, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x01, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x01, // Ŷ… (U+0176 U+2026)
  0x01, 0x76, 0x20, 0x39, 0x01, // Ŷ‹ (U+0176 U+2039)
  0x01, 0x78, 0x00, 0x2C, 0x01, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x01, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x00, 0xAB, 0x01, // Ÿ« (U+0178 U+00AB)
  0x01, 0x78, 0x20, 0x1A, 0x01, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x01, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x01, // Ÿ… (U+0178 U+2026)
  0x01, 0x78, 0x20, 0x39, 0x01, // Ÿ‹ (U+0178 U+2039)
  0x20, 0x18, 0x00, 0x41, 0x01, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0x63, 0x01, // ‘c (U+2018 U+0063)
  0x20, 0x18, 0x00, 0x64, 0x01, // ‘d (U+2018 U+0064)
  0x20, 0x18, 0x00, 0x65, 0x01, // ‘e (U+2018 U+0065)
  0x20, 0x18, 0x00, 0x6F, 0x01, // ‘o (U+2018 U+006F)
  0x20, 0x18, 0x00, 0x71, 0x01, // ‘q (U+2018 U+0071)
  0x20, 0x18, 0x00, 0xC0, 0x01, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x01, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x01, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x01, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x01, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x01, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xC6, 0x01, // ‘Æ (U+2018 U+00C6)
  0x20, 0x18, 0x00, 0xE0, 0x01, // ‘à (U+2018 U+00E0)
  0x20, 0x18, 0x00, 0xE7, 0x01, // ‘ç (U+2018 U+00E7)
  0x20, 0x18, 0x00, 0xE8, 0x01, // ‘è (U+2018 U+00E8)
  0x20, 0x18, 0x00, 0xE9, 0x01, // ‘é (U+2018 U+00E9)
  0x20, 0x18, 0x00, 0xEA, 0x01, // ‘ê (U+2018 U+00EA)
  0x20, 0x18, 0x00, 0xEB, 0x01, // ‘ë (U+2018 U+00EB)
  0x20, 0x18, 0x00, 0xF2, 0x01, // ‘ò (U+2018 U+00F2)
  0x20, 0x18, 0x00, 0xF3, 0x01, // ‘ó (U+2018 U+00F3)
  0x20, 0x18, 0x00, 0xF4, 0x01, // ‘ô (U+2018 U+00F4)
  0x20, 0x18, 0x00, 0xF5, 0x01, // ‘õ (U+2018 U+00F5)
  0x20, 0x18, 0x00, 0xF6, 0x01, // ‘ö (U+2018 U+00F6)
  0x20, 0x18, 0x00, 0xF8, 0x01, // ‘ø (U+2018 U+00F8)
  0x20, 0x18, 0x01, 0x00, 0x01, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x02, 0x01, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x04, 0x01, // ‘Ą (U+2018 U+0104)
  0x20, 0x18, 0x01, 0x07, 0x01, // ‘ć (U+2018 U+0107)
  0x20, 0x18, 0x01, 0x09, 0x01, // ‘ĉ (U+2018 U+0109)
  0x20, 0x18, 0x01, 0x0B, 0x01, // ‘ċ (U+2018 U+010B)
  0x20, 0x18, 0x01, 0x0D, 0x01, // ‘č (U+2018 U+010D)
  0x20, 0x18, 0x01, 0x0F, 0x01, // ‘ď (U+2018 U+010F)
  0x20, 0x18, 0x01, 0x11, 0x01, // ‘đ (U+2018 U+0111)
  0x20, 0x18, 0x01, 0x13, 0x01, // ‘ē (U+2018 U+0113)
  0x20, 0x18, 0x01, 0x15, 0x01, // ‘ĕ (U+2018 U+0115)
  0x20, 0x18, 0x01, 0x17, 0x01, // ‘ė (U+2018 U+0117)
  0x20, 0x18, 0x01, 0x19, 0x01, // ‘ę (U+2018 U+0119)
  0x20, 0x18, 0x01, 0x1B, 0x01, // ‘ě (U+2018 U+011B)
  0x20, 0x18, 0x01, 0x4D, 0x01, // ‘ō (U+2018 U+014D)
  0x20, 0x18, 0x01, 0x4F, 0x01, // ‘ŏ (U+2018 U+014F)
  0x20, 0x18, 0x01, 0x51, 0x01, // ‘ő (U+2018 U+0151)
  0x20, 0x18, 0x01, 0x53, 0x01, // ‘œ (U+2018 U+0153)
  0x20, 0x19, 0x00, 0x41, 0x01, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0x63, 0x01, // ’c (U+2019 U+0063)
  0x20, 0x19, 0x00, 0x64, 0x01, // ’d (U+2019 U+0064)
  0x20, 0x19, 0x00, 0x65, 0x01, // ’e (U+2019 U+0065)
  0x20, 0x19, 0x00, 0x6F, 0x01, // ’o (U+2019 U+006F)
  0x20, 0x19, 0x00, 0x71, 0x01, // ’q (U+2019 U+0071)
  0x20, 0x19, 0x00, 0xC0, 0x01, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x01, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x01, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x01, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x01, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x01, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xC6, 0x01, // ’Æ (U+2019 U+00C6)
  0x20, 0x19, 0x00, 0xE0, 0x01, // ’à (U+2019 U+00E0)
  0x20, 0x19, 0x00, 0xE7, 0x01, // ’ç (U+2019 U+00E7)
  0x20, 0x19, 0x00, 0xE8, 0x01, // ’è (U+2019 U+00E8)
  0x20, 0x19, 0x00, 0xE9, 0x01, // ’é (U+2019 U+00E9)
  0x20, 0x19, 0x00, 0xEA, 0x01, // ’ê (U+2019 U+00EA)
  0x20, 0x19, 0x00, 0xEB, 0x01, // ’ë (U+2019 U+00EB)
  0x20, 0x19, 0x00, 0xF2, 0x01, // ’ò (U+2019 U+00F2)
  0x20, 0x19, 0x00, 0xF3, 0x01, // ’ó (U+2019 U+00F3)
  0x20, 0x19, 0x00, 0xF4, 0x01, // ’ô (U+2019 U+00F4)
  0x20, 0x19, 0x00, 0xF5, 0x01, // ’õ (U+2019 U+00F5)
  0x20, 0x19, 0x00, 0xF6, 0x01, // ’ö (U+2019 U+00F6)
  0x20, 0x19, 0x00, 0xF8, 0x01, // ’ø (U+2019 U+00F8)
  0x20, 0x19, 0x01, 0x00, 0x01, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x02, 0x01, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x04, 0x01, // ’Ą (U+2019 U+0104)
  0x20, 0x19, 0x01, 0x07, 0x01, // ’ć (U+2019 U+0107)
  0x20, 0x19, 0x01, 0x09, 0x01, // ’ĉ (U+2019 U+0109)
  0x20, 0x19, 0x01, 0x0B, 0x01, // ’ċ (U+2019 U+010B)
  0x20, 0x19, 0x01, 0x0D, 0x01, // ’č (U+2019 U+010D)
  0x20, 0x19, 0x01, 0x0F, 0x01, // ’ď (U+2019 U+010F)
  0x20, 0x19, 0x01, 0x11, 0x01, // ’đ (U+2019 U+0111)
  0x20, 0x19, 0x01, 0x13, 0x01, // ’ē (U+2019 U+0113)
  0x20, 0x19, 0x01, 0x15, 0x01, // ’ĕ (U+2019 U+0115)
  0x20, 0x19, 0x01, 0x17, 0x01, // ’ė (U+2019 U+0117)
  0x20, 0x19, 0x01, 0x19, 0x01, // ’ę (U+2019 U+0119)
  0x20, 0x19, 0x01, 0x1B, 0x01, // ’ě (U+2019 U+011B)
  0x20, 0x19, 0x01, 0x4D, 0x01, // ’ō (U+2019 U+014D)
  0x20, 0x19, 0x01, 0x4F, 0x01, // ’ŏ (U+2019 U+014F)
  0x20, 0x19, 0x01, 0x51, 0x01, // ’ő (U+2019 U+0151)
  0x20, 0x19, 0x01, 0x53, 0x01, // ’œ (U+2019 U+0153)
  0x20, 0x1A, 0x00, 0x54, 0x01, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x56, 0x01, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x01, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x01, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0xDD, 0x01, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x01, 0x62, 0x01, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x01, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x01, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1A, 0x01, 0x74, 0x01, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x76, 0x01, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x78, 0x01, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x01, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0x63, 0x01, // “c (U+201C U+0063)
  0x20, 0x1C, 0x00, 0x64, 0x01, // “d (U+201C U+0064)
  0x20, 0x1C, 0x00, 0x65, 0x01, // “e (U+201C U+0065)
  0x20, 0x1C, 0x00, 0x6F, 0x01, // “o (U+201C U+006F)
  0x20, 0x1C, 0x00, 0x71, 0x01, // “q (U+201C U+0071)
  0x20, 0x1C, 0x00, 0xC0, 0x01, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x01, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x01, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x01, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x01, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x01, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xC6, 0x01, // “Æ (U+201C U+00C6)
  0x20, 0x1C, 0x00, 0xE0, 0x01, // “à (U+201C U+00E0)
  0x20, 0x1C, 0x00, 0xE7, 0x01, // “ç (U+201C U+00E7)
  0x20, 0x1C, 0x00, 0xE8, 0x01, // “è (U+201C U+00E8)
  0x20, 0x1C, 0x00, 0xE9, 0x01, // “é (U+201C U+00E9)
  0x20, 0x1C, 0x00, 0xEA, 0x01, // “ê (U+201C U+00EA)
  0x20, 0x1C, 0x00, 0xEB, 0x01, // “ë (U+201C U+00EB)
  0x20, 0x1C, 0x00, 0xF2, 0x01, // “ò (U+201C U+00F2)
  0x20, 0x1C, 0x00, 0xF3, 0x01, // “ó (U+201C U+00F3)
  0x20, 0x1C, 0x00, 0xF4, 0x01, // “ô (U+201C U+00F4)
  0x20, 0x1C, 0x00, 0xF5, 0x01, // “õ (U+201C U+00F5)
  0x20, 0x1C, 0x00, 0xF6, 0x01, // “ö (U+201C U+00F6)
  0x20, 0x1C, 0x00, 0xF8, 0x01, // “ø (U+201C U+00F8)
  0x20, 0x1C, 0x01, 0x00, 0x01, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x02, 0x01, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x04, 0x01, // “Ą (U+201C U+0104)
  0x20, 0x1C, 0x01, 0x07, 0x01, // “ć (U+201C U+0107)
  0x20, 0x1C, 0x01, 0x09, 0x01, // “ĉ (U+201C U+0109)
  0x20, 0x1C, 0x01, 0x0B, 0x01, // “ċ (U+201C U+010B)
  0x20, 0x1C, 0x01, 0x0D, 0x01, // “č (U+201C U+010D)
  0x20, 0x1C, 0x01, 0x0F, 0x01, // “ď (U+201C U+010F)
  0x20, 0x1C, 0x01, 0x11, 0x01, // “đ (U+201C U+0111)
  0x20, 0x1C, 0x01, 0x13, 0x01, // “ē (U+201C U+0113)
  0x20, 0x1C, 0x01, 0x15, 0x01, // “ĕ (U+201C U+0115)
  0x20, 0x1C, 0x01, 0x17, 0x01, // “ė (U+201C U+0117)
  0x20, 0x1C, 0x01, 0x19, 0x01, // “ę (U+201C U+0119)
  0x20, 0x1C, 0x01, 0x1B, 0x01, // “ě (U+201C U+011B)
  0x20, 0x1C, 0x01, 0x4D, 0x01, // “ō (U+201C U+014D)
  0x20, 0x1C, 0x01, 0x4F, 0x01, // “ŏ (U+201C U+014F)
  0x20, 0x1C, 0x01, 0x51, 0x01, // “ő (U+201C U+0151)
  0x20, 0x1C, 0x01, 0x53, 0x01, // “œ (U+201C U+0153)
  0x20, 0x1D, 0x00, 0x41, 0x01, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0x63, 0x01, // ”c (U+201D U+0063)
  0x20, 0x1D, 0x00, 0x64, 0x01, // ”d (U+201D U+0064)
  0x20, 0x1D, 0x00, 0x65, 0x01, // ”e (U+201D U+0065)
  0x20, 0x1D, 0x00, 0x6F, 0x01, // ”o (U+201D U+006F)
  0x20, 0x1D, 0x00, 0x71, 0x01, // ”q (U+201D U+0071)
  0x20, 0x1D, 0x00, 0xC0, 0x01, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x01, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x01, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x01, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x01, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x01, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xC6, 0x01, // ”Æ (U+201D U+00C6)
  0x20, 0x1D, 0x00, 0xE0, 0x01, // ”à (U+201D U+00E0)
  0x20, 0x1D, 0x00, 0xE7, 0x01, // ”ç (U+201D U+00E7)
  0x20, 0x1D, 0x00, 0xE8, 0x01, // ”è (U+201D U+00E8)
  0x20, 0x1D, 0x00, 0xE9, 0x01, // ”é (U+201D U+00E9)
  0x20, 0x1D, 0x00, 0xEA, 0x01, // ”ê (U+201D U+00EA)
  0x20, 0x1D, 0x00, 0xEB, 0x01, // ”ë (U+201D U+00EB)
  0x20, 0x1D, 0x00, 0xF2, 0x01, // ”ò (U+201D U+00F2)
  0x20, 0x1D, 0x00, 0xF3, 0x01, // ”ó (U+201D U+00F3)
  0x20, 0x1D, 0x00, 0xF4, 0x01, // ”ô (U+201D U+00F4)
  0x20, 0x1D, 0x00, 0xF5, 0x01, // ”õ (U+201D U+00F5)
  0x20, 0x1D, 0x00, 0xF6, 0x01, // ”ö (U+201D U+00F6)
  0x20, 0x1D, 0x00, 0xF8, 0x01, // ”ø (U+201D U+00F8)
  0x20, 0x1D, 0x01, 0x00, 0x01, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x02, 0x01, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x04, 0x01, // ”Ą (U+201D U+0104)
  0x20, 0x1D, 0x01, 0x07, 0x01, // ”ć (U+201D U+0107)
  0x20, 0x1D, 0x01, 0x09, 0x01, // ”ĉ (U+201D U+0109)
  0x20, 0x1D, 0x01, 0x0B, 0x01, // ”ċ (U+201D U+010B)
  0x20, 0x1D, 0x01, 0x0D, 0x01, // ”č (U+201D U+010D)
  0x20, 0x1D, 0x01, 0x0F, 0x01, // ”ď (U+201D U+010F)
  0x20, 0x1D, 0x01, 0x11, 0x01, // ”đ (U+201D U+0111)
  0x20, 0x1D, 0x01, 0x13, 0x01, // ”ē (U+201D U+0113)
  0x20, 0x1D, 0x01, 0x15, 0x01, // ”ĕ (U+201D U+0115)
  0x20, 0x1D, 0x01, 0x17, 0x01, // ”ė (U+201D U+0117)
  0x20, 0x1D, 0x01, 0x19, 0x01, // ”ę (U+201D U+0119)
  0x20, 0x1D, 0x01, 0x1B, 0x01, // ”ě (U+201D U+011B)
  0x20, 0x1D, 0x01, 0x4D, 0x01, // ”ō (U+201D U+014D)
  0x20, 0x1D, 0x01, 0x4F, 0x01, // ”ŏ (U+201D U+014F)
  0x20, 0x1D, 0x01, 0x51, 0x01, // ”ő (U+201D U+0151)
  0x20, 0x1D, 0x01, 0x53, 0x01, // ”œ (U+201D U+0153)
  0x20, 0x1E, 0x00, 0x54, 0x01, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x56, 0x01, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x01, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x01, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0xDD, 0x01, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x01, 0x62, 0x01, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x01, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x01, // „Ŧ (U+201E U+0166)
  0x20, 0x1E, 0x01, 0x74, 0x01, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x76, 0x01, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x78, 0x01, // „Ÿ (U+201E U+0178)
  0x20, 0x3A, 0x00, 0x54, 0x01, // ›T (U+203A U+0054)
  0x20, 0x3A, 0x00, 0x59, 0x01, // ›Y (U+203A U+0059)
  0x20, 0x3A, 0x00, 0xDD, 0x01, // ›Ý (U+203A U+00DD)
  0x20, 0x3A, 0x01, 0x62, 0x01, // ›Ţ (U+203A U+0162)
  0x20, 0x3A, 0x01, 0x64, 0x01, // ›Ť (U+203A U+0164)
  0x20, 0x3A, 0x01, 0x66, 0x01, // ›Ŧ (U+203A U+0166)
  0x20, 0x3A, 0x01, 0x76, 0x01, // ›Ŷ (U+203A U+0176)
  0x20, 0x3A, 0x01, 0x78, 0x01, // ›Ÿ (U+203A U+0178)
  
  // Glyph data
  // "!" (U+0021)
  0x5F, 0x74, 0xF7, 0x3F, 0x63, 0xF5, 0x2F, 0x51, 0xF4, 0x00, 0x02, 0xF5, 0x2E, 0x50,
  // """ (U+0022)
  0x5F, 0x4D, 0xB4, 0xF3, 0xCA, 0x2F, 0x1A, 0x90,
  // "#" (U+0023)
  0x28, 0x2B, 0x69, 0x93, 0x82, 0xD4, 0xB7, 0x28, 0x52, 0xF4, 0xD6, 0x06, 0xD8, 0x76, 0x39, 0xE8,
  0xF6, 0x2B, 0xD8, 0x51, 0x3B, 0xAA, 0xC4, 0x28, 0x2C, 0x69, 0x83, 0x82, 0xE4, 0xC6, 0x20,
  // "$" (U+0024)
  0x00, 0x56, 0x00, 0x09, 0xEF, 0xC2, 0x5F, 0xBA, 0xA1, 0x6F, 0x66, 0x00, 0x1E, 0xF9, 0x00, 0x01,
  0xAF, 0xD1, 0x00, 0x58, 0xF7, 0x56, 0x79, 0xF6, 0x6F, 0xFF, 0xC0, 0x01, 0x87, 0x00,
  // "%" (U+0025)
  0x1C, 0xE4, 0x01, 0xF2, 0x00, 0x7E, 0xBC, 0x08, 0xB0, 0x00, 0x9A, 0x5E, 0x0E, 0x40, 0x00, 0x8C,
  0x8D, 0x5D, 0x9F, 0xA0, 0x2F, 0xF7, 0xC8, 0xF8, 0xF2, 0x01, 0x33, 0xF4, 0xF1, 0xF4, 0x00, 0x09,
  0x93, 0xF1, 0xF4, 0x00, 0x0E, 0x30, 0xFA, 0xF2, 0x00, 0x6C, 0x00, 0x7E, 0x80,
  // "&" (U+0026)
  0x04, 0xDE, 0x90, 0x00, 0x0D, 0xDA, 0xF3, 0x00, 0x0C, 0xB6, 0xF2, 0x00, 0x06, 0xFF, 0x80, 0x00,
  0x1C, 0xFF, 0x38, 0xF1, 0x7F, 0x7E, 0xDD, 0xD0, 0x9F, 0x14, 0xFF, 0x60, 0x6F, 0xA8, 0xFF, 0x70,
  0x09, 0xEE, 0x9C, 0xF3,
  // "'" (U+0027)
  0x5F, 0x44, 0xF3, 0x2F, 0x10,
  // "(" (U+0028)
  0x02, 0xF5, 0x09, 0xD0, 0x0E, 0x70, 0x3F, 0x30, 0x6F, 0x10, 0x7F, 0x10, 0x6F, 0x10, 0x4F, 0x30,
  0x0F, 0x70, 0x0A, 0xD0, 0x02, 0xF5,
  // ")" (U+0029)
  0x7D, 0x00, 0x0E, 0x70, 0x0A, 0xD0, 0x06, 0xF1, 0x04, 0xF3, 0x03, 0xF4, 0x04, 0xF4, 0x06, 0xF1,
  0x0A, 0xD0, 0x1F, 0x70, 0x8D, 0x00,
  // "*" (U+002A)
  0x00, 0xD8, 0x00, 0x45, 0xC8, 0x71, 0x8E, 0xFF, 0xD4, 0x06, 0xEE, 0x20, 0x0D, 0x6B, 0x90, 0x00,
  0x01, 0x00,
  // "+" (U+002B)
  0x00, 0x9A, 0x00, 0x11, 0xAA, 0x11, 0x8F, 0xFF, 0xF9, 0x24, 0xBB, 0x42, 0x00, 0x9A, 0x00, 0x00,
  0x9A, 0x00,
  // "," (U+002C)
  0x2F, 0x74, 0xF3, 0x7D, 0x00,
  // "-" (U+002D)
  0x11, 0x10, 0xAF, 0xF6, 0x34, 0x41,
  // "." (U+002E)
  0x2F, 0x52, 0xE5,
  // "/" (U+002F)
  0x00, 0x0D, 0x90, 0x03, 0xF3, 0x00, 0x8D, 0x00, 0x0E, 0x80, 0x04, 0xF2, 0x00, 0xAC, 0x00, 0x0E,
  0x70, 0x05, 0xF1, 0x00, 0xBB, 0x00, 0x00,
  // "0" (U+0030)
  0x06, 0xEE, 0x50, 0x1F, 0xBC, 0xF1, 0x6F, 0x34, 0xF5, 0x8F, 0x22, 0xF7, 0x8F, 0x12, 0xF8, 0x8F,
  0x22, 0xF7, 0x6F, 0x34, 0xF5, 0x1F, 0xBB, 0xF1, 0x06, 0xEE, 0x50,
  // "1" (U+0031)
  0x00, 0x6F, 0x70, 0x6F, 0xF7, 0x2F, 0xAF, 0x70, 0x32, 0xF7, 0x00, 0x2F, 0x70, 0x02, 0xF7, 0x00,
  0x2F, 0x70, 0x02, 0xF7, 0x00, 0x2F, 0x70,
  // "2" (U+0032)
  0x1A, 0xED, 0x50, 0x5E, 0x7C, 0xF1, 0x01, 0x06, 0xF4, 0x00, 0x09, 0xF1, 0x00, 0x2F, 0xA0, 0x00,
  0xCE, 0x10, 0x09, 0xF4, 0x00, 0x5F, 0xC6, 0x62, 0x9F, 0xFF, 0xF7,
  // "3" (U+0033)
  0x3B, 0xEE, 0x60, 0x3C, 0x7C, 0xF2, 0x00, 0x06, 0xF3, 0x01, 0x3B, 0xD0, 0x07, 0xFE, 0x40, 0x02,
  0x5B, 0xF3, 0x00, 0x04, 0xF6, 0x78, 0x7C, 0xF3, 0x6D, 0xFD, 0x60,
  // "4" (U+0034)
  0x00, 0x0E, 0xE0, 0x00, 0x7F, 0xE0, 0x01, 0xEE, 0xE0, 0x08, 0xDB, 0xE0, 0x1E, 0x5B, 0xE0, 0x8D,
  0x2B, 0xE1, 0xCF, 0xFF, 0xFC, 0x34, 0x4C, 0xE3, 0x00, 0x0B, 0xE0,
  // "5" (U+0035)
  0x0F, 0xFF, 0xF0, 0x1F, 0x96, 0x60, 0x2F, 0x51, 0x00, 0x4F, 0xFF, 0x90, 0x16, 0x5C, 0xF3, 0x00,
  0x04, 0xF6, 0x00, 0x05, 0xF5, 0x59, 0x7D, 0xE1, 0x4D, 0xFC, 0x40,
  // "6" (U+0036)
  0x01, 0xAE, 0xF1, 0x0C, 0xE8, 0x71, 0x2F, 0x41, 0x00, 0x6F, 0xAF, 0xC0, 0x7F, 0xA8, 0xF5, 0x8F,
  0x21, 0xF8, 0x6F, 0x31, 0xF7, 0x1F, 0xBA, 0xF3, 0x05, 0xDE, 0x70,
  // "7" (U+0037)
  0x9F, 0xFF, 0xF9, 0x36, 0x68, 0xF6, 0x00, 0x08, 0xF1, 0x00, 0x0D, 0xB0, 0x00, 0x3F, 0x60, 0x00,
  0x9F, 0x10, 0x00, 0xEB, 0x00, 0x05, 0xF6, 0x00, 0x0A, 0xF1, 0x00,
  // "8" (U+0038)
  0x08, 0xEE, 0x80, 0x4F, 0xBB, 0xF3, 0x5F, 0x44, 0xF4, 0x0D, 0xCD, 0xD0, 0x08, 0xFF, 0x60, 0x4F,
  0x89, 0xF4, 0x8F, 0x10, 0xF8, 0x6F, 0x99, 0xF6, 0x09, 0xEE, 0x90,
  // "9" (U+0039)
  0x08, 0xED, 0x40, 0x5F, 0x9B, 0xF1, 0x8F, 0x13, 0xF6, 0x7F, 0x57, 0xF8, 0x2E, 0xFC, 0xF7, 0x01,
  0x33, 0xF6, 0x00, 0x07, 0xF2, 0x17, 0x8F, 0xB0, 0x2F, 0xEA, 0x10,
  // ":" (U+003A)
  0x84, 0x3E, 0x53, 0xE6, 0x72, 0x84, 0x2F, 0x63, 0xE5,
  // ";" (U+003B)
  0x84, 0x2E, 0x53, 0xE6, 0x72, 0x86, 0x2F, 0x74, 0xF3, 0x7D, 0x10,
  // "<" (U+003C)
  0x50, 0x13, 0x89, 0x33, 0xB9, 0x03, 0xBF, 0xA2, 0x8F, 0xB2, 0x28, 0x32, 0xAF, 0xB4, 0x38, 0x22,
  0x9F, 0x84, 0x01, 0x04,
  // "=" (U+003D)
  0x80, 0x21, 0x08, 0xC8, 0x59, 0x24, 0x44, 0x42, 0x80, 0x21, 0x08, 0xC8, 0x59, 0x24, 0x44, 0x42,
  // ">" (U+003E)
  0x01, 0x58, 0x18, 0xB3, 0x38, 0x32, 0xAF, 0xB3, 0x38, 0x94, 0x1B, 0xF8, 0x04, 0xBF, 0xA2, 0x8F,
  0x92, 0x20, 0x40, 0x14,
  // "?" (U+003F)
  0x7D, 0xEA, 0x08, 0x99, 0xF7, 0x00, 0x1F, 0x80, 0x09, 0xF2, 0x06, 0xF5, 0x00, 0x9B, 0x00, 0x00,
  0x00, 0x00, 0xAD, 0x00, 0x0A, 0xC0, 0x00,
  // "@" (U+0040)
  0x28, 0x33, 0xBE, 0xE9, 0x38, 0x53, 0xFB, 0x78, 0xEB, 0x28, 0xF3, 0xC9, 0x5D, 0xE7, 0xE5, 0x3F,
  0x2E, 0x9C, 0x88, 0x96, 0xC4, 0xE0, 0xA8, 0x6B, 0x7B, 0x6D, 0x0C, 0x76, 0xA6, 0xD4, 0xE3, 0xE9,
  0xA8, 0x3F, 0x3D, 0xF8, 0xFE, 0x20, 0xBE, 0x66, 0x27, 0x22, 0x01, 0x0B, 0xB0, 0xD5, 0x81, 0x24,
  0x33,
  // "A" (U+0041)
  0x00, 0xCF, 0xA0, 0x00, 0x0F, 0xEE, 0x00, 0x04, 0xF9, 0xF2, 0x00, 0x8F, 0x3F, 0x60, 0x0C, 0xC0,
  0xEB, 0x01, 0xFD, 0x8D, 0xE0, 0x5F, 0xFF, 0xFF, 0x39, 0xF2, 0x04, 0xF7, 0xDE, 0x00, 0x0F, 0xB0,
  // "B" (U+0042)
  0x2F, 0xFF, 0xC4, 0x02, 0xFB, 0x7E, 0xE0, 0x2F, 0x80, 0x9F, 0x12, 0xF9, 0x2D, 0xD0, 0x2F, 0xFF,
  0xF5, 0x02, 0xFA, 0x5C, 0xE1, 0x2F, 0x80, 0x7F, 0x42, 0xFB, 0x6D, 0xF1, 0x2F, 0xFF, 0xD5, 0x00,
  // "C" (U+0043)
  0x00, 0x9E, 0xE9, 0x0A, 0xF9, 0x89, 0x1F, 0xA0, 0x00, 0x5F, 0x60, 0x00, 0x6F, 0x50, 0x00, 0x4F,
  0x60, 0x00, 0x2F, 0xA0, 0x00, 0x0B, 0xF9, 0x78, 0x01, 0xAE, 0xE8,
  // "D" (U+0044)
  0x2F, 0xFF, 0xB3, 0x02, 0xFB, 0x7E, 0xE1, 0x2F, 0x80, 0x4F, 0x82, 0xF8, 0x00, 0xFB, 0x2F, 0x80,
  0x0F, 0xC2, 0xF8, 0x00, 0xFA, 0x2F, 0x80, 0x5F, 0x72, 0xFB, 0x8E, 0xE1, 0x2F, 0xFE, 0xB2, 0x00,
  // "E" (U+0045)
  0x02, 0xC8, 0x62, 0xFB, 0x66, 0x2F, 0x82, 0x84, 0x2F, 0x91, 0x12, 0xB8, 0x7D, 0x2F, 0xA4, 0x32,
  0xF8, 0x28, 0x42, 0xFB, 0x66, 0x2C,
  // "F" (U+0046)
  0x2F, 0xFF, 0xF2, 0xFB, 0x66, 0x2F, 0x80, 0x02, 0xF9, 0x11, 0x2F, 0xFF, 0xD2, 0xFA, 0x43, 0x2F,
  0x80, 0x02, 0xF8, 0x00, 0x2F, 0x80, 0x00,
  // "G" (U+0047)
  0x00, 0x7D, 0xFC, 0x40, 0x9F, 0xB7, 0xA3, 0x1F, 0xB0, 0x00, 0x05, 0xF6, 0x01, 0x11, 0x6F, 0x52,
  0xFF, 0xA4, 0xF6, 0x04, 0xFA, 0x1F, 0xA0, 0x0E, 0xA0, 0xAF, 0x97, 0xFA, 0x01, 0xAE, 0xED, 0x60,
  // "H" (U+0048)
  0x2F, 0x80, 0x0E, 0xB2, 0xF8, 0x00, 0xEB, 0x2F, 0x80, 0x0E, 0xB2, 0xF9, 0x11, 0xEB, 0x2F, 0xFF,
  0xFF, 0xB2, 0xFA, 0x44, 0xEB, 0x2F, 0x80, 0x0E, 0xB2, 0xF8, 0x00, 0xEB, 0x2F, 0x80, 0x0E, 0xB0,
  // "I" (U+0049)
  0x9F, 0xFC, 0x1D, 0xE2, 0x0C, 0xE0, 0x0C, 0xE0, 0x0C, 0xE0, 0x0C, 0xE0, 0x0C, 0xE0, 0x1D, 0xE1,
  0x9F, 0xFC,
  // "J" (U+004A)
  0x01, 0xF8, 0x01, 0xF8, 0x01, 0xF8, 0x01, 0xF8, 0x01, 0xF8, 0x01, 0xF8, 0x01, 0xF8, 0x01, 0xF8,
  0x02, 0xF8, 0x05, 0xF7, 0xBF, 0xF2, 0x47, 0x20,
  // "K" (U+004B)
  0x2F, 0x80, 0x6F, 0x62, 0xF8, 0x1E, 0xC0, 0x2F, 0x89, 0xF3, 0x02, 0xFA, 0xFA, 0x00, 0x2F, 0xFF,
  0x90, 0x02, 0xFD, 0xCF, 0x10, 0x2F, 0x84, 0xF8, 0x02, 0xF8, 0x0D, 0xE1, 0x2F, 0x80, 0x6F, 0x70,
  // "L" (U+004C)
  0x2F, 0x80, 0x00, 0x2F, 0x80, 0x00, 0x2F, 0x80, 0x00, 0x2F, 0x80, 0x00, 0x2F, 0x80, 0x00, 0x2F,
  0x80, 0x00, 0x2F, 0x80, 0x00, 0x2F, 0xC8, 0x81, 0x2F, 0xFF, 0xF3,
  // "M" (U+004D)
  0x2F, 0xF4, 0x00, 0x6F, 0xF2, 0xFF, 0x90, 0x0B, 0xFF, 0x2F, 0xED, 0x00, 0xEE, 0xF2, 0xFA, 0xF1,
  0x4F, 0xAF, 0x2F, 0x7F, 0x68, 0xC8, 0xF2, 0xF6, 0xBA, 0xC8, 0x9F, 0x2F, 0x67, 0xEF, 0x49, 0xF2,
  0xF6, 0x3F, 0xE0, 0x9F, 0x2F, 0x60, 0xEB, 0x09, 0xF0,
  // "N" (U+004E)
  0x2F, 0xF2, 0x04, 0xF4, 0x2F, 0xF8, 0x04, 0xF4, 0x2F, 0xEE, 0x14, 0xF4, 0x2F, 0x9F, 0x74, 0xF4,
  0x2F, 0x6B, 0xE4, 0xF4, 0x2F, 0x65, 0xF9, 0xF4, 0x2F, 0x60, 0xDF, 0xF4, 0x2F, 0x60, 0x6F, 0xF4,
  0x2F, 0x60, 0x0E, 0xF4,
  // "O" (U+004F)
  0x01, 0xAE, 0xE9, 0x00, 0x0B, 0xF8, 0x9F, 0x90, 0x2F, 0xA0, 0x0C, 0xF0, 0x4F, 0x60, 0x08, 0xF3,
  0x6F, 0x50, 0x07, 0xF3, 0x5F, 0x60, 0x08, 0xF2, 0x2F, 0xA0, 0x0C, 0xF0, 0x0B, 0xF8, 0x9F, 0x90,
  0x01, 0xAE, 0xE9, 0x00,
  // "P" (U+0050)
  0x2F, 0xFE, 0xB2, 0x2F, 0xB7, 0xFB, 0x2F, 0x80, 0xBE, 0x2F, 0x93, 0xEC, 0x2F, 0xFF, 0xE4, 0x2F,
  0xA4, 0x00, 0x2F, 0x80, 0x00, 0x2F, 0x80, 0x00, 0x2F, 0x80, 0x00,
  // "Q" (U+0051)
  0x01, 0xAE, 0xE9, 0x00, 0x0B, 0xF8, 0x9F, 0x80, 0x2F, 0xA0, 0x0C, 0xE0, 0x4F, 0x60, 0x08, 0xF2,
  0x6F, 0x50, 0x07, 0xF3, 0x5F, 0x60, 0x08, 0xF2, 0x2F, 0xA0, 0x0C, 0xF0, 0x0B, 0xF8, 0x9F, 0x90,
  0x01, 0xAE, 0xFC, 0x00, 0x00, 0x00, 0xBF, 0x20, 0x00, 0x00, 0x2E, 0xC0,
  // "R" (U+0052)
  0x2F, 0xFE, 0xB2, 0x02, 0xFB, 0x8F, 0xC0, 0x2F, 0x80, 0xBE, 0x02, 0xF9, 0x3E, 0xC0, 0x2F, 0xFF,
  0xE3, 0x02, 0xFA, 0xBE, 0x00, 0x2F, 0x84, 0xF7, 0x02, 0xF8, 0x0D, 0xE0, 0x2F, 0x80, 0x6F, 0x60,
  // "S" (U+0053)
  0x07, 0xEE, 0xB1, 0x4F, 0xB7, 0xC0, 0x7F, 0x40, 0x00, 0x4F, 0xD3, 0x00, 0x09, 0xFF, 0x70, 0x00,
  0x4E, 0xF1, 0x00, 0x07, 0xF3, 0x8A, 0x7D, 0xE0, 0x5D, 0xFD, 0x40,
  // "T" (U+0054)
  0x0C, 0xC8, 0x57, 0x56, 0xFC, 0x63, 0x29, 0x0A, 0x49, 0x0A, 0x49, 0x0A, 0x49, 0x0A, 0x49, 0x0A,
  0x49, 0x0A, 0x49, 0x0A, 0x20,
  // "U" (U+0055)
  0x2F, 0x80, 0x1F, 0x92, 0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F, 0x92, 0xF8, 0x01, 0xF9, 0x2F, 0x80,
  0x1F, 0x92, 0xF8, 0x01, 0xF9, 0x1F, 0x90, 0x2F, 0x80, 0xDF, 0x9C, 0xF4, 0x02, 0xBE, 0xD6, 0x00,
  // "V" (U+0056)
  0xDD, 0x00, 0x3F, 0x79, 0xF1, 0x07, 0xF3, 0x5F, 0x50, 0xAE, 0x01, 0xF8, 0x0E, 0xB0, 0x0C, 0xC2,
  0xF7, 0x00, 0x8F, 0x6F, 0x30, 0x04, 0xFC, 0xE0, 0x00, 0x0F, 0xFA, 0x00, 0x00, 0xCF, 0x60, 0x00,
  // "W" (U+0057)
  0xDB, 0x00, 0xDC, 0x00, 0xCD, 0xAE, 0x00, 0xFF, 0x00, 0xFA, 0x7F, 0x24, 0xFF, 0x32, 0xF7, 0x4F,
  0x57, 0xDD, 0x65, 0xF3, 0x1F, 0x7A, 0xAB, 0x98, 0xF0, 0x0D, 0xAD, 0x78, 0xCB, 0xD0, 0x0A, 0xDF,
  0x44, 0xFD, 0xA0, 0x07, 0xFF, 0x11, 0xFF, 0x60, 0x04, 0xFD, 0x00, 0xDF, 0x30,
  // "X" (U+0058)
  0x9F, 0x20, 0xCE, 0x02, 0xF9, 0x3F, 0x70, 0x0A, 0xEA, 0xE1, 0x00, 0x3F, 0xF9, 0x00, 0x00, 0xEF,
  0x40, 0x00, 0x5F, 0xFA, 0x00, 0x0C, 0xD9, 0xF2, 0x04, 0xF7, 0x2F, 0xA0, 0xBE, 0x00, 0xAF, 0x20,
  // "Y" (U+0059)
  0x0C, 0x0E, 0x28, 0x7B, 0xE1, 0x6F, 0x51, 0xF9, 0x28, 0x3E, 0xB7, 0xF3, 0x28, 0x29, 0xFE, 0xC3,
  0x02, 0xA0, 0x54, 0x0C, 0x95, 0x0B, 0x0E, 0x50, 0xB0, 0xE5, 0x0B, 0x0E, 0x30,
  // "Z" (U+005A)
  0xAF, 0xFF, 0xF5, 0x46, 0x6C, 0xF2, 0x00, 0x1F, 0xA0, 0x00, 0x8F, 0x20, 0x01, 0xFA, 0x00, 0x08,
  0xF2, 0x00, 0x1E, 0xA0, 0x00, 0x8F, 0x96, 0x62, 0xBF, 0xFF, 0xF6,
  // "[" (U+005B)
  0x4F, 0xF7, 0x4F, 0x83, 0x4F, 0x20, 0x4F, 0x20, 0x4F, 0x20, 0x4F, 0x20, 0x4F, 0x20, 0x4F, 0x20,
  0x4F, 0x20, 0x4F, 0x40, 0x4F, 0xF7, 0x14, 0x42,
  // "\" (U+005C)
  0xBB, 0x00, 0x05, 0xF1, 0x00, 0x0E, 0x60, 0x00, 0xAC, 0x00, 0x04, 0xF2, 0x00, 0x0E, 0x80, 0x00,
  0x8D, 0x00, 0x03, 0xF3, 0x00, 0x0D, 0x90,
  // "]" (U+005D)
  0xBF, 0xF1, 0x4A, 0xF1, 0x06, 0xF1, 0x06, 0xF1, 0x06, 0xF1, 0x06, 0xF1, 0x06, 0xF1, 0x06, 0xF1,
  0x06, 0xF1, 0x17, 0xF1, 0xBF, 0xF1, 0x34, 0x40,
  // "^" (U+005E)
  0x00, 0x34, 0x00, 0x00, 0xCE, 0x00, 0x03, 0xFE, 0x70, 0x0B, 0xA7, 0xD0, 0x2F, 0x31, 0xE6, 0x9C,
  0x00, 0x8D,
  // "_" (U+005F)
  0x80, 0x21, 0xD0, 0x78, 0x01, 0x40, 0x20,
  // "`" (U+0060)
  0x3F, 0x90, 0x04, 0xE3,
  // "a" (U+0061)
  0x09, 0xEE, 0x80, 0x09, 0x7B, 0xF2, 0x00, 0x16, 0xF5, 0x2D, 0xFF, 0xF5, 0x8F, 0x77, 0xF5, 0x8F,
  0x8C, 0xF5, 0x2D, 0xE5, 0xE5,
  // "b" (U+0062)
  0x3F, 0x50, 0x00, 0x3F, 0x50, 0x00, 0x3F, 0x50, 0x00, 0x3F, 0x8D, 0xD2, 0x3F, 0xD7, 0xFA, 0x3F,
  0x70, 0xBE, 0x3F, 0x50, 0xAF, 0x3F, 0x70, 0xBE, 0x3F, 0xD7, 0xFA, 0x3F, 0x7E, 0xC2,
  // "c" (U+0063)
  0x05, 0xDE, 0x91, 0xFC, 0x76, 0x6F, 0x30, 0x07, 0xF2, 0x00, 0x6F, 0x30, 0x02, 0xFC, 0x78, 0x06,
  0xDE, 0x80,
  // "d" (U+0064)
  0x40, 0xD0, 0xB4, 0x0D, 0x0B, 0x48, 0xD2, 0xDB, 0x08, 0xE9, 0xDB, 0x3F, 0xB9, 0xFB, 0x6F, 0x30,
  0xEB, 0x7F, 0x10, 0xDB, 0x6F, 0x30, 0xEB, 0x3F, 0xB9, 0xFB, 0x08, 0xE9, 0xBB,
  // "e" (U+0065)
  0x06, 0xDE, 0x60, 0x2F, 0xB9, 0xF2, 0x6F, 0x42, 0xF7, 0x7F, 0xFF, 0xF8, 0x6F, 0x64, 0x42, 0x2F,
  0xB6, 0x82, 0x05, 0xDE, 0xC1,
  // "f" (U+0066)
  0x18, 0x65, 0xEE, 0x10, 0xDD, 0x72, 0x90, 0x92, 0x0A, 0xA8, 0x4C, 0x06, 0xFB, 0x52, 0x90, 0x93,
  0x90, 0x93, 0x90, 0x93, 0x90, 0x93, 0x90, 0x92,
  // "g" (U+0067)
  0x08, 0xEA, 0xBB, 0x3F, 0xB9, 0xFB, 0x6F, 0x30, 0xEB, 0x7F, 0x20, 0xDB, 0x6F, 0x30, 0xEB, 0x3F,
  0xB9, 0xFB, 0x08, 0xE9, 0xDB, 0x00, 0x00, 0xE9, 0x2A, 0x7A, 0xF5, 0x1C, 0xFD, 0x70,
  // "h" (U+0068)
  0x3F, 0x50, 0x00, 0x3F, 0x50, 0x00, 0x3F, 0x50, 0x00, 0x3F, 0x8D, 0xD3, 0x3F, 0xD7, 0xFA, 0x3F,
  0x70, 0xCC, 0x3F, 0x60, 0xCD, 0x3F, 0x50, 0xCD, 0x3F, 0x50, 0xCD, 0x3F, 0x50, 0xCD,
  // "i" (U+0069)
  0x2E, 0x40, 0x51, 0x00, 0x03, 0xF6, 0x3F, 0x63, 0xF6, 0x3F, 0x63, 0xF6, 0x3F, 0x63, 0xF6,
  // "j" (U+006A)
  0x02, 0xE4, 0x00, 0x51, 0x00, 0x00, 0x03, 0xF6, 0x03, 0xF6, 0x03, 0xF6, 0x03, 0xF6, 0x03, 0xF6,
  0x03, 0xF6, 0x03, 0xF6, 0x04, 0xF5, 0x3B, 0xF4, 0x6F, 0xA0,
  // "k" (U+006B)
  0x3F, 0x50, 0x00, 0x3F, 0x50, 0x00, 0x3F, 0x50, 0x00, 0x3F, 0x51, 0xEC, 0x3F, 0x59, 0xE2, 0x3F,
  0x9F, 0x60, 0x3F, 0xFF, 0x60, 0x3F, 0xAC, 0xE0, 0x3F, 0x54, 0xF7, 0x3F, 0x50, 0xCE,
  // "l" (U+006C)
  0x3F, 0x53, 0xF5, 0x3F, 0x53, 0xF5, 0x3F, 0x53, 0xF5, 0x3F, 0x53, 0xF5, 0x3F, 0x53, 0xF5,
  // "m" (U+006D)
  0x3F, 0x6D, 0xD3, 0xBE, 0x60, 0x3F, 0xD8, 0xFF, 0x8D, 0xE0, 0x3F, 0x70, 0xEC, 0x08, 0xF1, 0x3F,
  0x60, 0xDB, 0x08, 0xF1, 0x3F, 0x50, 0xDB, 0x08, 0xF1, 0x3F, 0x50, 0xDB, 0x08, 0xF1, 0x3F, 0x50,
  0xDB, 0x08, 0xF1,
  // "n" (U+006E)
  0x3F, 0x6D, 0xD3, 0x3F, 0xD7, 0xFA, 0x3F, 0x70, 0xCC, 0x3F, 0x60, 0xCD, 0x3F, 0x50, 0xCD, 0x3F,
  0x50, 0xCD, 0x3F, 0x50, 0xCD,
  // "o" (U+006F)
  0x05, 0xDE, 0x80, 0x2F, 0xB9, 0xF6, 0x6F, 0x30, 0xDB, 0x7F, 0x20, 0xCD, 0x6F, 0x30, 0xEB, 0x2F,
  0xB9, 0xF7, 0x05, 0xDE, 0x90,
  // "p" (U+0070)
  0x3F, 0x6D, 0xC2, 0x3F, 0xD8, 0xFA, 0x3F, 0x70, 0xBE, 0x3F, 0x50, 0xAF, 0x3F, 0x70, 0xBE, 0x3F,
  0xD7, 0xFA, 0x3F, 0x9D, 0xC2, 0x3F, 0x50, 0x00, 0x3F, 0x50, 0x00, 0x3F, 0x50, 0x00,
  // "q" (U+0071)
  0x08, 0xEA, 0xBB, 0x2F, 0xB9, 0xFB, 0x6F, 0x30, 0xEB, 0x7F, 0x20, 0xDB, 0x6F, 0x30, 0xEB, 0x3F,
  0xB9, 0xFB, 0x08, 0xE9, 0xDB, 0x00, 0x00, 0xDB, 0x00, 0x00, 0xDB, 0x00, 0x00, 0xDB,
  // "r" (U+0072)
  0x3F, 0x5E, 0x53, 0xFE, 0x72, 0x3F, 0x80, 0x03, 0xF6, 0x00, 0x3F, 0x60, 0x03, 0xF6, 0x00, 0x3F,
  0x60, 0x00,
  // "s" (U+0073)
  0x1B, 0xEC, 0x38, 0xF7, 0xA2, 0x7F, 0x70, 0x01, 0xBF, 0xC1, 0x00, 0x6F, 0x77, 0x88, 0xF7, 0x6E,
  0xEB, 0x10,
  // "t" (U+0074)
  0x05, 0x40, 0x0D, 0x80, 0x9F, 0xFD, 0x6F, 0xB5, 0x1F, 0x80, 0x1F, 0x80, 0x1F, 0x80, 0x0F, 0xC7,
  0x08, 0xEC,
  // "u" (U+0075)
  0x4F, 0x50, 0xCC, 0x4F, 0x50, 0xCC, 0x4F, 0x50, 0xCC, 0x4F, 0x50, 0xCC, 0x3F, 0x60, 0xDC, 0x1F,
  0xB7, 0xFC, 0x08, 0xEB, 0x9C,
  // "v" (U+0076)
  0xCC, 0x01, 0xF9, 0x8F, 0x14, 0xF4, 0x4F, 0x48, 0xF0, 0x0E, 0x8C, 0xB0, 0x0A, 0xBF, 0x70, 0x06,
  0xFF, 0x20, 0x01, 0xFD, 0x00,
  // "w" (U+0077)
  0xCC, 0x09, 0xF6, 0x0E, 0x99, 0xF0, 0xCF, 0x92, 0xF6, 0x5F, 0x3F, 0xAC, 0x5F, 0x22, 0xF8, 0xF5,
  0xF8, 0xE0, 0x0E, 0xCD, 0x1F, 0xCB, 0x00, 0xBF, 0xB0, 0xEF, 0x80, 0x07, 0xF8, 0x0B, 0xF4, 0x00,
  // "x" (U+0078)
  0x9F, 0x26, 0xF5, 0x2F, 0x9D, 0xD0, 0x09, 0xFF, 0x50, 0x04, 0xFF, 0x00, 0x0A, 0xFF, 0x60, 0x2F,
  0x7C, 0xD0, 0xAF, 0x15, 0xF6,
  // "y" (U+0079)
  0xCD, 0x01, 0xF9, 0x8F, 0x24, 0xF4, 0x3F, 0x68, 0xF0, 0x0E, 0x9C, 0xB0, 0x09, 0xDF, 0x70, 0x04,
  0xFF, 0x20, 0x00, 0xFD, 0x00, 0x01, 0xF9, 0x00, 0x4B, 0xF3, 0x00, 0x8E, 0x70, 0x00,
  // "z" (U+007A)
  0x9F, 0xFF, 0x63, 0x6B, 0xF3, 0x00, 0xEB, 0x00, 0x7F, 0x30, 0x0E, 0xB0, 0x07, 0xF9, 0x63, 0xBF,
  0xFF, 0x80,
  // "{" (U+007B)
  0x01, 0xBE, 0x10, 0x6F, 0x90, 0x06, 0xF1, 0x00, 0x6F, 0x10, 0x2B, 0xF0, 0x0B, 0xF6, 0x00, 0x4C,
  0xE0, 0x00, 0x7F, 0x00, 0x06, 0xF1, 0x00, 0x6F, 0x50, 0x02, 0xEF, 0x10, 0x01, 0x40,
  // "|" (U+007C)
  0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0xE6,
  // "}" (U+007D)
  0x9D, 0x50, 0x04, 0xDD, 0x00, 0x09, 0xE0, 0x00, 0x9E, 0x00, 0x07, 0xF4, 0x00, 0x1D, 0xF3, 0x06,
  0xF7, 0x10, 0x8E, 0x00, 0x09, 0xE0, 0x01, 0xBD, 0x00, 0x9F, 0x90, 0x02, 0x20, 0x00,
  // "~" (U+007E)
  0x5F, 0xE6, 0x37, 0x85, 0x9F, 0xF7, 0x00, 0x01, 0x30,
  // "¡" (U+00A1)
  0x2E, 0x53, 0xF6, 0x00, 0x01, 0xF4, 0x2F, 0x43, 0xF5, 0x3F, 0x64, 0xF7, 0x5F, 0x70,
  // "¢" (U+00A2)
  0x00, 0x2C, 0x00, 0x04, 0xEF, 0xE1, 0x0E, 0xD5, 0x60, 0x2F, 0x70, 0x00, 0x3F, 0x70, 0x00, 0x1F,
  0xA0, 0x10, 0x0C, 0xFD, 0xF0, 0x01, 0x9E, 0x80, 0x00, 0x1C, 0x00,
  // "£" (U+00A3)
  0x00, 0xAE, 0xD3, 0x06, 0xF8, 0x91, 0x09, 0xF0, 0x00, 0x1A, 0xF2, 0x10, 0x7F, 0xFF, 0xB0, 0x2B,
  0xF4, 0x30, 0x0A, 0xE0, 0x00, 0x3F, 0xB6, 0x64, 0x7F, 0xFF, 0xF9,
  // "¤" (U+00A4)
  0x02, 0x00, 0x02, 0x3E, 0xBE, 0xBD, 0x0C, 0xB7, 0xE7, 0x0F, 0x10, 0x79, 0x0C, 0x72, 0xC7, 0x2F,
  0xFF, 0xFB, 0x05, 0x13, 0x15,
  // "¥" (U+00A5)
  0xAF, 0x01, 0xFA, 0x5F, 0x55, 0xF4, 0x0E, 0xAB, 0xE0, 0x09, 0xFF, 0x80, 0x05, 0xFF, 0x40, 0x3F,
  0xFF, 0xF3, 0x3F, 0xFF, 0xF3, 0x14, 0xDD, 0x41, 0x00, 0xCC, 0x00,
  // "¦" (U+00A6)
  0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0x00, 0x00, 0x00, 0xE6, 0xE6, 0xE6, 0xE6, 0xE6,
  // "§" (U+00A7)
  0x09, 0xED, 0x44, 0xF8, 0xA4, 0x3F, 0x60, 0x00, 0xDF, 0xC1, 0x5D, 0x2D, 0x95, 0xF5, 0xB8, 0x07,
  0xEF, 0x20, 0x01, 0xD7, 0x69, 0x7E, 0x73, 0xDE, 0xB1,
  // "¨" (U+00A8)
  0x9A, 0x6D, 0x11, 0x02,
  // "©" (U+00A9)
  0x40, 0x01, 0x60, 0x50, 0xDA, 0x0C, 0x04, 0x38, 0x65, 0xF9, 0x56, 0x9F, 0x52, 0x81, 0xD3, 0x7A,
  0x8A, 0x08, 0x4E, 0x05, 0x92, 0xF7, 0x54, 0x0A, 0x46, 0x64, 0xD4, 0x89, 0x68, 0x55, 0x83, 0xF4,
  0x22, 0x09, 0x41, 0xE1, 0xAA, 0x89, 0x38, 0x2E, 0x10, 0x9E, 0x65, 0x67, 0xE7, 0x30, 0x8B, 0x0E,
  0x07, 0x58, 0x11, 0x43, 0x40,
  // "ª" (U+00AA)
  0x3D, 0xE4, 0x16, 0xC9, 0xA9, 0xA9, 0x6D, 0x99,
  // "«" (U+00AB)
  0x01, 0xC2, 0x5B, 0x0C, 0xD2, 0xE9, 0x7F, 0x4B, 0xE1, 0x2E, 0x95, 0xF5, 0x05, 0xF3, 0x9E, 0x00,
  0x30, 0x02,
  // "¬" (U+00AC)
  0x80, 0x21, 0x08, 0xC8, 0x58, 0x24, 0x44, 0xC8, 0x40, 0xB0, 0x84, 0x08, 0x06,
  // "®" (U+00AE)
  0x40, 0x01, 0x60, 0x50, 0xDA, 0x0C, 0x04, 0x38, 0x65, 0xFA, 0x76, 0x9F, 0x52, 0x81, 0xD3, 0xCA,
  0x8A, 0x06, 0x4E, 0x05, 0x90, 0xC9, 0xBB, 0x0A, 0x46, 0x60, 0xCA, 0x8B, 0x75, 0x08, 0x55, 0x80,
  0xC8, 0xE4, 0x09, 0x41, 0xE1, 0xB5, 0x5C, 0x3E, 0x10, 0x9E, 0x62, 0x26, 0xE7, 0x30, 0x8B, 0x0E,
  0x07, 0x58, 0x11, 0x43, 0x40,
  // "¯" (U+00AF)
  0x80, 0x21, 0xD0, 0xC8, 0x01, 0x40, 0x30,
  // "°" (U+00B0)
  0x00, 0x10, 0x01, 0xDF, 0x80, 0x7C, 0x6F, 0x08, 0xA3, 0xF1, 0x2E, 0xFA, 0x00, 0x13, 0x00,
  // "±" (U+00B1)
  0x00, 0x9A, 0x00, 0x11, 0xAA, 0x11, 0x8F, 0xFF, 0xF9, 0x24, 0xBB, 0x42, 0x00, 0x9A, 0x00, 0x00,
  0x9A, 0x00, 0x36, 0x66, 0x63, 0x8F, 0xFF, 0xF9,
  // "²" (U+00B2)
  0x4C, 0xD3, 0x33, 0xC8, 0x02, 0xE3, 0x2D, 0x50, 0xAF, 0xEA, 0x11, 0x11,
  // "³" (U+00B3)
  0x4D, 0xC3, 0x23, 0xB7, 0x0C, 0xE2, 0x11, 0xA9, 0x8F, 0xF5, 0x01, 0x00,
  // "´" (U+00B4)
  0x00, 0x11, 0xDA, 0x23, 0x00,
  // "µ" (U+00B5)
  0x3F, 0x50, 0xCC, 0x3F, 0x50, 0xCC, 0x3F, 0x50, 0xCC, 0x3F, 0x50, 0xCC, 0x3F, 0x60, 0xEC, 0x3F,
  0xC9, 0xFC, 0x3F, 0xDD, 0x9C, 0x3F, 0x50, 0x00, 0x3F, 0x50, 0x00, 0x3F, 0x50, 0x00,
  // "¶" (U+00B6)
  0x08, 0xEF, 0xFB, 0x2F, 0xFF, 0x8B, 0x5F, 0xFF, 0x3B, 0x6F, 0xFF, 0x3B, 0x5F, 0xFF, 0x3B, 0x1F,
  0xFF, 0x3B, 0x03, 0x8E, 0x3B, 0x00, 0x0D, 0x3B, 0x00, 0x0D, 0x3B, 0x00, 0x0D, 0x3B, 0x00, 0x0D,
  0x3B, 0x00, 0x05, 0x14,
  // "·" (U+00B7)
  0x2F, 0x52, 0xE5,
  // "¸" (U+00B8)
  0x0A, 0x80, 0x03, 0xF3, 0x3F, 0xC0,
  // "¹" (U+00B9)
  0x07, 0xF1, 0x4B, 0xF1, 0x01, 0xF1, 0x01, 0xF1, 0x01, 0xF1,
  // "º" (U+00BA)
  0x2D, 0xD4, 0x98, 0x5C, 0x98, 0x5B, 0x2C, 0xC4,
  // "»" (U+00BB)
  0x4C, 0x07, 0x90, 0x01, 0xEA, 0x4F, 0x60, 0x06, 0xF5, 0xBE, 0x10, 0xBD, 0x2E, 0xA0, 0x5F, 0x39,
  0xD1, 0x00, 0x30, 0x02, 0x00,
  // "¼" (U+00BC)
  0x09, 0xF0, 0x00, 0xB8, 0x00, 0x6B, 0xF0, 0x03, 0xE1, 0x00, 0x03, 0xF0, 0x0B, 0x80, 0x00, 0x03,
  0xF0, 0x3F, 0x16, 0x90, 0x03, 0xF0, 0xA9, 0x1E, 0xD0, 0x00, 0x02, 0xF1, 0x7A, 0xD0, 0x00, 0x0A,
  0x91, 0xC5, 0xD0, 0x00, 0x2F, 0x25, 0xFE, 0xF7, 0x00, 0x9A, 0x00, 0x16, 0xD0, 0x00, 0x10, 0x00,
  0x00, 0x10,
  // "½" (U+00BD)
  0x09, 0xF0, 0x00, 0xD6, 0x00, 0x59, 0xF0, 0x07, 0xD0, 0x00, 0x03, 0xF0, 0x0E, 0x51, 0x00, 0x03,
  0xF0, 0x7C, 0x8F, 0xE1, 0x03, 0xF1, 0xE4, 0x65, 0xF4, 0x00, 0x08, 0xB0, 0x05, 0xC0, 0x00, 0x1F,
  0x30, 0x5D, 0x30, 0x00, 0x9A, 0x00, 0xDF, 0xF7, 0x00, 0x41, 0x00, 0x44, 0x42,
  // "¾" (U+00BE)
  0x3C, 0xD3, 0x00, 0x89, 0x00, 0x14, 0xB8, 0x01, 0xF3, 0x00, 0x0C, 0xE2, 0x08, 0xB0, 0x00, 0x26,
  0xBA, 0x1F, 0x33, 0x70, 0x8F, 0xF7, 0x8B, 0x0C, 0xF0, 0x03, 0x21, 0xE4, 0x5A, 0xF0, 0x00, 0x08,
  0xC0, 0xC4, 0xF0, 0x00, 0x1E, 0x43, 0xFE, 0xF9, 0x00, 0x7C, 0x00, 0x14, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x10,
  // "¿" (U+00BF)
  0x00, 0xCA, 0x00, 0x0D, 0xB0, 0x00, 0x00, 0x00, 0x0B, 0x90, 0x05, 0xF6, 0x03, 0xFA, 0x00, 0x8F,
  0x10, 0x07, 0xF8, 0x88, 0x1B, 0xED, 0x70,
  // "À" (U+00C0)
  0x18, 0x13, 0xF9, 0x58, 0x14, 0xE3, 0x74, 0x81, 0xCF, 0xA4, 0x90, 0x0E, 0x38, 0x34, 0xF9, 0xF2,
  0x28, 0x38, 0xF3, 0xF6, 0x28, 0x94, 0xCC, 0x0E, 0xB0, 0x1F, 0xD8, 0xDE, 0x05, 0xD8, 0x90, 0x39,
  0xF2, 0x04, 0xF7, 0xDE, 0x39, 0x0B,
  // "Á" (U+00C1)
  0x40, 0x14, 0x81, 0x1D, 0xA4, 0x02, 0x03, 0x58, 0x1C, 0xFA, 0x49, 0x00, 0xE3, 0x83, 0x4F, 0x9F,
  0x22, 0x83, 0x8F, 0x3F, 0x62, 0x89, 0x4C, 0xC0, 0xEB, 0x01, 0xFD, 0x8D, 0xE0, 0x5D, 0x89, 0x03,
  0x9F, 0x20, 0x4F, 0x7D, 0xE3, 0x90, 0xB0,
  // "Â" (U+00C2)
  0x28, 0x18, 0xFA, 0x38, 0x34, 0xD3, 0xD5, 0x73, 0x81, 0xCF, 0xA4, 0x90, 0x0E, 0x38, 0x34, 0xF9,
  0xF2, 0x28, 0x38, 0xF3, 0xF6, 0x28, 0x94, 0xCC, 0x0E, 0xB0, 0x1F, 0xD8, 0xDE, 0x05, 0xD8, 0x90,
  0x39, 0xF2, 0x04, 0xF7, 0xDE, 0x39, 0x0B,
  // "Ã" (U+00C3)
  0x01, 0xE9, 0x59, 0x00, 0x69, 0xAF, 0x50, 0x01, 0x10, 0x20, 0x00, 0x0C, 0xFA, 0x00, 0x00, 0xFE,
  0xE0, 0x00, 0x4F, 0x9F, 0x20, 0x08, 0xF3, 0xF6, 0x00, 0xCC, 0x0E, 0xB0, 0x1F, 0xD8, 0xDE, 0x05,
  0xFF, 0xFF, 0xF3, 0x9F, 0x20, 0x4F, 0x7D, 0xE0, 0x00, 0xFB,
  // "Ä" (U+00C4)
  0x09, 0xA6, 0xD0, 0x00, 0x11, 0x02, 0x00, 0x00, 0xCF, 0xA0, 0x00, 0x0F, 0xEE, 0x00, 0x04, 0xF9,
  0xF2, 0x00, 0x8F, 0x3F, 0x60, 0x0C, 0xC0, 0xEB, 0x01, 0xFD, 0x8D, 0xE0, 0x5F, 0xFF, 0xFF, 0x39,
  0xF2, 0x04, 0xF7, 0xDE, 0x00, 0x0F, 0xB0,
  // "Å" (U+00C5)
  0x00, 0x3E, 0xD1, 0x00, 0x07, 0xBC, 0x40, 0x00, 0x4F, 0xE1, 0x00, 0x0C, 0xFB, 0x00, 0x00, 0xFE,
  0xE0, 0x00, 0x4F, 0x9F, 0x20, 0x08, 0xF3, 0xF6, 0x00, 0xCC, 0x0E, 0xB0, 0x1F, 0xD8, 0xDE, 0x05,
  0xFF, 0xFF, 0xF3, 0x9F, 0x20, 0x4F, 0x7D, 0xE0, 0x00, 0xFB,
  // "Æ" (U+00C6)
  0x00, 0x3F, 0xFF, 0xFF, 0xA0, 0x08, 0xFB, 0xF7, 0x64, 0x00, 0xDA, 0x8F, 0x20, 0x00, 0x3F, 0x58,
  0xF3, 0x11, 0x08, 0xF2, 0x9F, 0xDD, 0x60, 0xDF, 0xFF, 0xF2, 0x00, 0x3F, 0x84, 0xAF, 0x20, 0x08,
  0xF2, 0x08, 0xF7, 0x64, 0xDE, 0x00, 0x8F, 0xFF, 0xA0,
  // "Ç" (U+00C7)
  0x00, 0x9E, 0xE9, 0x0A, 0xF9, 0x89, 0x1F, 0xA0, 0x00, 0x5F, 0x60, 0x00, 0x6F, 0x50, 0x00, 0x4F,
  0x60, 0x00, 0x2F, 0xA0, 0x00, 0x0B, 0xF9, 0x78, 0x01, 0xAF, 0xE8, 0x00, 0x0A, 0x80, 0x00, 0x03,
  0xF3, 0x00, 0x3F, 0xC0,
  // "È" (U+00C8)
  0x81, 0x3F, 0x93, 0x81, 0x4E, 0x36, 0x02, 0xC8, 0x62, 0xFB, 0x66, 0x2F, 0x82, 0x84, 0x2F, 0x91,
  0x12, 0xB8, 0x7D, 0x2F, 0xA4, 0x32, 0xF8, 0x28, 0x42, 0xFB, 0x66, 0x2C,
  // "É" (U+00C9)
  0x40, 0x12, 0x81, 0x1D, 0xA2, 0x82, 0x23, 0x02, 0xC8, 0x62, 0xFB, 0x66, 0x2F, 0x82, 0x84, 0x2F,
  0x91, 0x12, 0xB8, 0x7D, 0x2F, 0xA4, 0x32, 0xF8, 0x28, 0x42, 0xFB, 0x66, 0x2C,
  // "Ê" (U+00CA)
  0x18, 0x78, 0xFA, 0x04, 0xD3, 0xD5, 0x50, 0x2C, 0x86, 0x2F, 0xB6, 0x62, 0xF8, 0x28, 0x42, 0xF9,
  0x11, 0x2B, 0x87, 0xD2, 0xFA, 0x43, 0x2F, 0x82, 0x84, 0x2F, 0xB6, 0x62, 0xC0,
  // "Ë" (U+00CB)
  0x09, 0xA6, 0xD0, 0x11, 0x02, 0x2F, 0xFF, 0xF2, 0xFB, 0x66, 0x2F, 0x80, 0x02, 0xF9, 0x11, 0x2F,
  0xFF, 0xD2, 0xFA, 0x43, 0x2F, 0x80, 0x02, 0xFB, 0x66, 0x2F, 0xFF, 0xF0,
  // "Ì" (U+00CC)
  0x3F, 0x90, 0x04, 0xE3, 0x00, 0x00, 0x9F, 0xFC, 0x1D, 0xE2, 0x0C, 0xE0, 0x0C, 0xE0, 0x0C, 0xE0,
  0x0C, 0xE0, 0x0C, 0xE0, 0x1D, 0xE1, 0x9F, 0xFC,
  // "Í" (U+00CD)
  0x00, 0x01, 0x01, 0xDA, 0x02, 0x30, 0x9F, 0xFC, 0x1D, 0xE2, 0x0C, 0xE0, 0x0C, 0xE0, 0x0C, 0xE0,
  0x0C, 0xE0, 0x0C, 0xE0, 0x1D, 0xE1, 0x9F, 0xFC,
  // "Î" (U+00CE)
  0x08, 0xFA, 0x04, 0xD3, 0xD5, 0x00, 0x00, 0x09, 0xFF, 0xC0, 0x1D, 0xE2, 0x00, 0xCE, 0x00, 0x0C,
  0xE0, 0x00, 0xCE, 0x00, 0x0C, 0xE0, 0x00, 0xCE, 0x00, 0x1D, 0xE1, 0x09, 0xFF, 0xC0,
  // "Ï" (U+00CF)
  0x9A, 0x6D, 0x11, 0x02, 0x9F, 0xFC, 0x1D, 0xE2, 0x0C, 0xE0, 0x0C, 0xE0, 0x0C, 0xE0, 0x0C, 0xE0,
  0x0C, 0xE0, 0x1D, 0xE1, 0x9F, 0xFC,
  // "Ð" (U+00D0)
  0x2F, 0xFF, 0xB3, 0x02, 0xFB, 0x7E, 0xE1, 0x2F, 0x80, 0x4F, 0x83, 0xF9, 0x10, 0xFB, 0xDF, 0xF9,
  0x0F, 0xC5, 0xFA, 0x20, 0xFA, 0x2F, 0x80, 0x5F, 0x72, 0xFB, 0x8E, 0xE1, 0x2F, 0xFE, 0xB2, 0x00,
  // "Ñ" (U+00D1)
  0x00, 0x1E, 0x95, 0x90, 0x00, 0x69, 0xAF, 0x50, 0x00, 0x11, 0x02, 0x00, 0x2F, 0xF2, 0x04, 0xF4,
  0x2F, 0xF8, 0x04, 0xF4, 0x2F, 0xEE, 0x14, 0xF4, 0x2F, 0x9F, 0x74, 0xF4, 0x2F, 0x6B, 0xE4, 0xF4,
  0x2F, 0x65, 0xF9, 0xF4, 0x2F, 0x60, 0xDF, 0xF4, 0x2F, 0x60, 0x6F, 0xF4, 0x2F, 0x60, 0x0E, 0xF4,
  // "Ò" (U+00D2)
  0x18, 0x13, 0xF9, 0x68, 0x14, 0xE3, 0x75, 0x83, 0x1A, 0xEE, 0x93, 0x89, 0x0B, 0xF8, 0x9F, 0x90,
  0x2F, 0xA2, 0x84, 0xCF, 0x04, 0xF6, 0x28, 0x48, 0xF3, 0x6F, 0x52, 0x84, 0x7F, 0x35, 0xF6, 0x28,
  0x48, 0xF2, 0x2F, 0xA2, 0x0C, 0x92, 0x84, 0xBF, 0x89, 0xF9, 0x28, 0x31, 0xAE, 0xE9, 0x20,
  // "Ó" (U+00D3)
  0x50, 0x15, 0x81, 0x1D, 0xA5, 0x02, 0x03, 0x48, 0x31, 0xAE, 0xE9, 0x38, 0x90, 0xBF, 0x89, 0xF9,
  0x02, 0xFA, 0x28, 0x4C, 0xF0, 0x4F, 0x62, 0x84, 0x8F, 0x36, 0xF5, 0x28, 0x47, 0xF3, 0x5F, 0x62,
  0x84, 0x8F, 0x22, 0xFA, 0x20, 0xC9, 0x28, 0x4B, 0xF8, 0x9F, 0x92, 0x83, 0x1A, 0xEE, 0x92,
  // "Ô" (U+00D4)
  0x00, 0x8F, 0xA0, 0x00, 0x04, 0xD3, 0xD5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xAE, 0xE9, 0x00,
  0x0B, 0xF8, 0x9F, 0x90, 0x2F, 0xA0, 0x0C, 0xF0, 0x4F, 0x60, 0x08, 0xF3, 0x6F, 0x50, 0x07, 0xF3,
  0x5F, 0x60, 0x08, 0xF2, 0x2F, 0xA0, 0x0C, 0xF0, 0x0B, 0xF8, 0x9F, 0x90, 0x01, 0xAE, 0xE9, 0x00,
  // "Õ" (U+00D5)
  0x01, 0xE9, 0x59, 0x00, 0x06, 0x9A, 0xF5, 0x00, 0x01, 0x10, 0x20, 0x00, 0x01, 0xAE, 0xE9, 0x00,
  0x0B, 0xF8, 0x9F, 0x90, 0x2F, 0xA0, 0x0C, 0xF0, 0x4F, 0x60, 0x08, 0xF3, 0x6F, 0x50, 0x07, 0xF3,
  0x5F, 0x60, 0x08, 0xF2, 0x2F, 0xA0, 0x0C, 0xF0, 0x0B, 0xF8, 0x9F, 0x90, 0x01, 0xAE, 0xE9, 0x00,
  // "Ö" (U+00D6)
  0x00, 0x9A, 0x6D, 0x00, 0x00, 0x11, 0x02, 0x00, 0x01, 0xAE, 0xE9, 0x00, 0x0B, 0xF8, 0x9F, 0x90,
  0x2F, 0xA0, 0x0C, 0xF0, 0x4F, 0x60, 0x08, 0xF3, 0x6F, 0x50, 0x07, 0xF3, 0x5F, 0x60, 0x08, 0xF2,
  0x2F, 0xA0, 0x0C, 0xF0, 0x0B, 0xF8, 0x9F, 0x90, 0x01, 0xAE, 0xE9, 0x00,
  // "×" (U+00D7)
  0x07, 0x00, 0x71, 0x2E, 0x99, 0xE3, 0x03, 0xFF, 0x30, 0x09, 0xEE, 0x90, 0x3E, 0x33, 0xE3, 0x00,
  0x00, 0x10,
  // "Ø" (U+00D8)
  0x60, 0x12, 0x84, 0x1A, 0xEE, 0xB9, 0x28, 0x92, 0xBF, 0x89, 0xF9, 0x02, 0xF9, 0x07, 0xA1, 0x8A,
  0x74, 0xF6, 0x1D, 0x9F, 0x36, 0xF5, 0x87, 0x7F, 0x34, 0xF7, 0xD0, 0x8F, 0x22, 0xA8, 0x26, 0x0C,
  0xE2, 0x84, 0xBF, 0x89, 0xF8, 0x28, 0x3B, 0xCE, 0xE9, 0x30, 0x46,
  // "Ù" (U+00D9)
  0x18, 0x13, 0xF9, 0x58, 0x14, 0xE3, 0x72, 0x8F, 0x42, 0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F, 0x92,
  0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F, 0x92, 0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F, 0x91, 0xF9, 0x02,
  0xF8, 0x0D, 0xF9, 0xCF, 0x40, 0x2B, 0xED, 0x61,
  // "Ú" (U+00DA)
  0x40, 0x14, 0x81, 0x1D, 0xA4, 0x02, 0x03, 0x38, 0xF4, 0x2F, 0x80, 0x1F, 0x92, 0xF8, 0x01, 0xF9,
  0x2F, 0x80, 0x1F, 0x92, 0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F, 0x92, 0xF8, 0x01, 0xF9, 0x1F, 0x90,
  0x2F, 0x80, 0xDF, 0x9C, 0xF4, 0x02, 0xBE, 0xD6, 0x10,
  // "Û" (U+00DB)
  0x28, 0x18, 0xFA, 0x38, 0x34, 0xD3, 0xD5, 0x71, 0x8F, 0x42, 0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F,
  0x92, 0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F, 0x92, 0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F, 0x91, 0xF9,
  0x02, 0xF8, 0x0D, 0xF9, 0xCF, 0x40, 0x2B, 0xED, 0x61,
  // "Ü" (U+00DC)
  0x00, 0x9A, 0x6D, 0x00, 0x01, 0x10, 0x20, 0x2F, 0x80, 0x1F, 0x92, 0xF8, 0x01, 0xF9, 0x2F, 0x80,
  0x1F, 0x92, 0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F, 0x92, 0xF8, 0x01, 0xF9, 0x1F, 0x90, 0x2F, 0x80,
  0xDF, 0x9C, 0xF4, 0x02, 0xBE, 0xD6, 0x00,
  // "Ý" (U+00DD)
  0x40, 0x14, 0x81, 0x1D, 0xA4, 0x02, 0x03, 0x30, 0xC0, 0xE2, 0x87, 0xBE, 0x16, 0xF5, 0x1F, 0x92,
  0x83, 0xEB, 0x7F, 0x32, 0x82, 0x9F, 0xEC, 0x30, 0x2A, 0x05, 0x40, 0xC9, 0x50, 0xB0, 0xE5, 0x0B,
  0x0E, 0x50, 0xB0, 0xE3,
  // "Þ" (U+00DE)
  0x2F, 0x80, 0x00, 0x2F, 0x91, 0x00, 0x2F, 0xFF, 0xD2, 0x2F, 0xA6, 0xFB, 0x2F, 0x80, 0xCD, 0x2F,
  0x94, 0xEB, 0x2F, 0xFF, 0xE3, 0x2F, 0xA4, 0x00, 0x2F, 0x80, 0x00,
  // "ß" (U+00DF)
  0x03, 0xCE, 0xC4, 0x00, 0xED, 0x7E, 0xE0, 0x3F, 0x60, 0xAF, 0x03, 0xF5, 0x3F, 0x80, 0x3F, 0x5C,
  0xD0, 0x03, 0xF5, 0xBF, 0x60, 0x3F, 0x52, 0xDF, 0x43, 0xF5, 0x01, 0xFA, 0x3F, 0x6A, 0x8F, 0x83,
  0xF5, 0xCF, 0xC1,
  // "à" (U+00E0)
  0x03, 0xF9, 0x00, 0x00, 0x4E, 0x30, 0x00, 0x00, 0x00, 0x09, 0xEE, 0x80, 0x09, 0x7B, 0xF2, 0x00,
  0x16, 0xF5, 0x2D, 0xFF, 0xF5, 0x8F, 0x77, 0xF5, 0x8F, 0x8C, 0xF5, 0x2D, 0xE5, 0xE5,
  // "á" (U+00E1)
  0x00, 0x00, 0x10, 0x00, 0x1D, 0xA0, 0x00, 0x23, 0x00, 0x09, 0xEE, 0x80, 0x09, 0x7B, 0xF2, 0x00,
  0x16, 0xF5, 0x2D, 0xFF, 0xF5, 0x8F, 0x77, 0xF5, 0x8F, 0x8C, 0xF5, 0x2D, 0xE5, 0xE5,
  // "â" (U+00E2)
  0x00, 0x8F, 0xA0, 0x04, 0xD3, 0xD5, 0x00, 0x00, 0x00, 0x09, 0xEE, 0x80, 0x09, 0x7B, 0xF2, 0x00,
  0x16, 0xF5, 0x2D, 0xFF, 0xF5, 0x8F, 0x77, 0xF5, 0x8F, 0x8C, 0xF5, 0x2D, 0xE5, 0xE5,
  // "ã" (U+00E3)
  0x01, 0xE9, 0x59, 0x06, 0x9A, 0xF5, 0x01, 0x10, 0x20, 0x09, 0xEE, 0x80, 0x09, 0x7B, 0xF2, 0x00,
  0x16, 0xF5, 0x2D, 0xFF, 0xF5, 0x8F, 0x77, 0xF5, 0x8F, 0x8C, 0xF5, 0x2D, 0xE5, 0xE5,
  // "ä" (U+00E4)
  0x09, 0xA6, 0xD0, 0x01, 0x10, 0x20, 0x09, 0xEE, 0x80, 0x09, 0x7B, 0xF2, 0x00, 0x16, 0xF5, 0x2D,
  0xFF, 0xF5, 0x8F, 0x77, 0xF5, 0x8F, 0x8C, 0xF5, 0x2D, 0xE5, 0xE5,
  // "å" (U+00E5)
  0x03, 0xED, 0x10, 0x07, 0xBC, 0x40, 0x04, 0xFE, 0x10, 0x00, 0x21, 0x00, 0x09, 0xEE, 0x80, 0x09,
  0x7B, 0xF2, 0x00, 0x16, 0xF5, 0x2D, 0xFF, 0xF5, 0x8F, 0x77, 0xF5, 0x8F, 0x8C, 0xF5, 0x2D, 0xE5,
  0xE5,
  // "æ" (U+00E6)
  0x09, 0xED, 0x6C, 0xE9, 0x00, 0x97, 0xBF, 0xC8, 0xF5, 0x00, 0x16, 0xF6, 0x1D, 0x92, 0xDF, 0xFF,
  0xFF, 0xFB, 0x8F, 0x78, 0xF8, 0x44, 0x38, 0xF8, 0xCE, 0xC7, 0x84, 0x1C, 0xE8, 0x2C, 0xFD, 0x30,
  // "ç" (U+00E7)
  0x05, 0xDE, 0x91, 0xFC, 0x76, 0x6F, 0x30, 0x07, 0xF2, 0x00, 0x6F, 0x30, 0x02, 0xFC, 0x78, 0x06,
  0xDE, 0x80, 0x0A, 0x80, 0x00, 0x3F, 0x30, 0x3F, 0xC0,
  // "è" (U+00E8)
  0x18, 0x13, 0xF9, 0x48, 0x14, 0xE3, 0x71, 0x8A, 0x06, 0xDE, 0x60, 0x2F, 0xB9, 0xF2, 0x6F, 0x42,
  0xF7, 0x7C, 0x8A, 0x18, 0x6F, 0x64, 0x42, 0x2F, 0xB6, 0x82, 0x05, 0xDE, 0xC1,
  // "é" (U+00E9)
  0x00, 0x00, 0x10, 0x00, 0x1D, 0xA0, 0x00, 0x23, 0x00, 0x06, 0xDE, 0x60, 0x2F, 0xB9, 0xF2, 0x6F,
  0x42, 0xF7, 0x7F, 0xFF, 0xF8, 0x6F, 0x64, 0x42, 0x2F, 0xB6, 0x82, 0x05, 0xDE, 0xC1,
  // "ê" (U+00EA)
  0x08, 0xFA, 0x00, 0x4D, 0x3D, 0x50, 0x00, 0x00, 0x00, 0x06, 0xDE, 0x60, 0x2F, 0xB9, 0xF2, 0x6F,
  0x42, 0xF7, 0x7F, 0xFF, 0xF8, 0x6F, 0x64, 0x42, 0x2F, 0xB6, 0x82, 0x05, 0xDE, 0xC1,
  // "ë" (U+00EB)
  0x09, 0xA6, 0xD0, 0x01, 0x10, 0x20, 0x06, 0xDE, 0x60, 0x2F, 0xB9, 0xF2, 0x6F, 0x42, 0xF7, 0x7F,
  0xFF, 0xF8, 0x6F, 0x64, 0x42, 0x2F, 0xB6, 0x82, 0x05, 0xDE, 0xC1,
  // "ì" (U+00EC)
  0x3F, 0x90, 0x04, 0xE3, 0x00, 0x00, 0x03, 0xF6, 0x03, 0xF6, 0x03, 0xF6, 0x03, 0xF6, 0x03, 0xF6,
  0x03, 0xF6, 0x03, 0xF6,
  // "í" (U+00ED)
  0x00, 0x11, 0xDA, 0x23, 0x03, 0xF6, 0x3F, 0x63, 0xF6, 0x3F, 0x63, 0xF6, 0x3F, 0x63, 0xF6,
  // "î" (U+00EE)
  0x08, 0xFA, 0x04, 0xD3, 0xD5, 0x00, 0x00, 0x00, 0x3F, 0x60, 0x03, 0xF6, 0x00, 0x3F, 0x60, 0x03,
  0xF6, 0x00, 0x3F, 0x60, 0x03, 0xF6, 0x00, 0x3F, 0x60,
  // "ï" (U+00EF)
  0x9A, 0x6D, 0x11, 0x02, 0x03, 0xF6, 0x03, 0xF6, 0x03, 0xF6, 0x03, 0xF6, 0x03, 0xF6, 0x03, 0xF6,
  0x03, 0xF6,
  // "ð" (U+00F0)
  0x00, 0x51, 0x50, 0x01, 0xDF, 0xA0, 0x02, 0xEE, 0xB0, 0x00, 0x35, 0xF4, 0x09, 0xFE, 0xF9, 0x4F,
  0xA6, 0xFC, 0x7F, 0x20, 0xDD, 0x7F, 0x20, 0xDB, 0x3F, 0xB8, 0xF6, 0x06, 0xDE, 0x90,
  // "ñ" (U+00F1)
  0x01, 0xE9, 0x59, 0x06, 0x9A, 0xF5, 0x01, 0x10, 0x20, 0x3F, 0x6D, 0xD3, 0x3F, 0xD7, 0xFA, 0x3F,
  0x70, 0xCC, 0x3F, 0x60, 0xCD, 0x3F, 0x50, 0xCD, 0x3F, 0x50, 0xCD, 0x3F, 0x50, 0xCD,
  // "ò" (U+00F2)
  0x18, 0x13, 0xF9, 0x48, 0x14, 0xE3, 0x71, 0x8C, 0x65, 0xDE, 0x80, 0x2F, 0xB9, 0xF6, 0x6F, 0x30,
  0xDB, 0x7F, 0x20, 0xCD, 0x6F, 0x30, 0xEB, 0x2F, 0xB9, 0xF7, 0x05, 0xDE, 0x91,
  // "ó" (U+00F3)
  0x00, 0x00, 0x10, 0x00, 0x1D, 0xA0, 0x00, 0x23, 0x00, 0x05, 0xDE, 0x80, 0x2F, 0xB9, 0xF6, 0x6F,
  0x30, 0xDB, 0x7F, 0x20, 0xCD, 0x6F, 0x30, 0xEB, 0x2F, 0xB9, 0xF7, 0x05, 0xDE, 0x90,
  // "ô" (U+00F4)
  0x00, 0x8F, 0xA0, 0x04, 0xD3, 0xD5, 0x00, 0x00, 0x00, 0x05, 0xDE, 0x80, 0x2F, 0xB9, 0xF6, 0x6F,
  0x30, 0xDB, 0x7F, 0x20, 0xCD, 0x6F, 0x30, 0xEB, 0x2F, 0xB9, 0xF7, 0x05, 0xDE, 0x90,
  // "õ" (U+00F5)
  0x01, 0xE9, 0x59, 0x06, 0x9A, 0xF5, 0x01, 0x10, 0x20, 0x05, 0xDE, 0x80, 0x2F, 0xB9, 0xF6, 0x6F,
  0x30, 0xDB, 0x7F, 0x20, 0xCD, 0x6F, 0x30, 0xEB, 0x2F, 0xB9, 0xF7, 0x05, 0xDE, 0x90,
  // "ö" (U+00F6)
  0x09, 0xA6, 0xD0, 0x01, 0x10, 0x20, 0x05, 0xDE, 0x80, 0x2F, 0xB9, 0xF6, 0x6F, 0x30, 0xDB, 0x7F,
  0x20, 0xCD, 0x6F, 0x30, 0xEB, 0x2F, 0xB9, 0xF7, 0x05, 0xDE, 0x90,
  // "÷" (U+00F7)
  0x20, 0x0A, 0x28, 0x51, 0x13, 0x31, 0x18, 0xC8, 0x59, 0x24, 0x44, 0x42, 0x71, 0x00, 0xA4, 0x01,
  0x02, 0x20,
  // "ø" (U+00F8)
  0x40, 0x12, 0x8C, 0x65, 0xDE, 0xD5, 0x2F, 0xBA, 0xF5, 0x6F, 0x2B, 0xEB, 0x7F, 0x5A, 0xBD, 0x6F,
  0xE2, 0xDB, 0x1E, 0xD8, 0xF6, 0x0D, 0xDE, 0x92, 0x04, 0x40,
  // "ù" (U+00F9)
  0x18, 0x13, 0xF9, 0x48, 0x14, 0xE3, 0x78, 0xD0, 0x4F, 0x50, 0xCC, 0x4F, 0x50, 0xCC, 0x4F, 0x50,
  0xCC, 0x4F, 0x50, 0xCC, 0x3F, 0x60, 0xDC, 0x1F, 0xB7, 0xFC, 0x08, 0xEB, 0x9C,
  // "ú" (U+00FA)
  0x00, 0x00, 0x10, 0x00, 0x1D, 0xA0, 0x00, 0x23, 0x00, 0x4F, 0x50, 0xCC, 0x4F, 0x50, 0xCC, 0x4F,
  0x50, 0xCC, 0x4F, 0x50, 0xCC, 0x3F, 0x60, 0xDC, 0x1F, 0xB7, 0xFC, 0x08, 0xEB, 0x9C,
  // "û" (U+00FB)
  0x00, 0x8F, 0xA0, 0x04, 0xD3, 0xD5, 0x00, 0x00, 0x00, 0x4F, 0x50, 0xCC, 0x4F, 0x50, 0xCC, 0x4F,
  0x50, 0xCC, 0x4F, 0x50, 0xCC, 0x3F, 0x60, 0xDC, 0x1F, 0xB7, 0xFC, 0x08, 0xEB, 0x9C,
  // "ü" (U+00FC)
  0x09, 0xA6, 0xD0, 0x01, 0x10, 0x20, 0x4F, 0x50, 0xCC, 0x4F, 0x50, 0xCC, 0x4F, 0x50, 0xCC, 0x4F,
  0x50, 0xCC, 0x3F, 0x60, 0xDC, 0x1F, 0xB7, 0xFC, 0x08, 0xEB, 0x9C,
  // "ý" (U+00FD)
  0x00, 0x00, 0x10, 0x00, 0x1D, 0xA0, 0x00, 0x23, 0x00, 0xCD, 0x01, 0xF9, 0x8F, 0x24, 0xF4, 0x3F,
  0x68, 0xF0, 0x0E, 0x9C, 0xB0, 0x09, 0xDF, 0x70, 0x04, 0xFF, 0x20, 0x00, 0xFD, 0x00, 0x01, 0xF9,
  0x00, 0x4B, 0xF3, 0x00, 0x8E, 0x70, 0x00,
  // "þ" (U+00FE)
  0x3F, 0x50, 0x00, 0x3F, 0x50, 0x00, 0x3F, 0x50, 0x00, 0x3F, 0x9D, 0xC2, 0x3F, 0xD8, 0xFA, 0x3F,
  0x70, 0xBE, 0x3F, 0x50, 0xAF, 0x3F, 0x70, 0xBE, 0x3F, 0xD7, 0xFA, 0x3F, 0x9D, 0xD2, 0x3F, 0x60,
  0x00, 0x3F, 0x60, 0x00, 0x3F, 0x60, 0x00,
  // "ÿ" (U+00FF)
  0x09, 0xA6, 0xD0, 0x01, 0x10, 0x20, 0xCD, 0x01, 0xF9, 0x8F, 0x24, 0xF4, 0x3F, 0x68, 0xF0, 0x0E,
  0x9C, 0xB0, 0x09, 0xDF, 0x70, 0x04, 0xFF, 0x20, 0x00, 0xFD, 0x00, 0x01, 0xF9, 0x00, 0x4B, 0xF3,
  0x00, 0x8E, 0x70, 0x00,
  // "Ā" (U+0100)
  0x18, 0x00, 0x13, 0x08, 0xB3, 0x02, 0x0F, 0x44, 0x81, 0xCF, 0xA4, 0x90, 0x0E, 0x38, 0x34, 0xF9,
  0xF2, 0x28, 0x38, 0xF3, 0xF6, 0x28, 0x94, 0xCC, 0x0E, 0xB0, 0x1F, 0xD8, 0xDE, 0x05, 0xD8, 0x90,
  0x39, 0xF2, 0x04, 0xF7, 0xDE, 0x39, 0x0B,
  // "ā" (U+0101)
  0x01, 0x11, 0x10, 0x08, 0xFF, 0xF0, 0x02, 0x44, 0x40, 0x09, 0xEE, 0x80, 0x09, 0x7B, 0xF2, 0x00,
  0x16, 0xF5, 0x2D, 0xFF, 0xF5, 0x8F, 0x77, 0xF5, 0x8F, 0x8C, 0xF5, 0x2D, 0xE5, 0xE5,
  // "Ă" (U+0102)
  0x05, 0x72, 0x92, 0x00, 0x2E, 0xFC, 0x00, 0x00, 0x13, 0x00, 0x00, 0x0C, 0xFA, 0x00, 0x00, 0xFE,
  0xE0, 0x00, 0x4F, 0x9F, 0x20, 0x08, 0xF3, 0xF6, 0x00, 0xCC, 0x0E, 0xB0, 0x1F, 0xD8, 0xDE, 0x05,
  0xFF, 0xFF, 0xF3, 0x9F, 0x20, 0x4F, 0x7D, 0xE0, 0x00, 0xFB,
  // "ă" (U+0103)
  0x05, 0x72, 0x92, 0x02, 0xEF, 0xC0, 0x00, 0x13, 0x00, 0x09, 0xEE, 0x80, 0x09, 0x7B, 0xF2, 0x00,
  0x16, 0xF5, 0x2D, 0xFF, 0xF5, 0x8F, 0x77, 0xF5, 0x8F, 0x8C, 0xF5, 0x2D, 0xE5, 0xE5,
  // "Ą" (U+0104)
  0x28, 0x1C, 0xFA, 0x49, 0x00, 0xE3, 0x83, 0x4F, 0x9F, 0x22, 0x83, 0x8F, 0x3F, 0x62, 0x89, 0x4C,
  0xC0, 0xEB, 0x01, 0xFD, 0x8D, 0xE0, 0x5D, 0x89, 0x03, 0x9F, 0x20, 0x4F, 0x7D, 0xE3, 0x90, 0xC4,
  0x81, 0x1D, 0x14, 0x81, 0x7C, 0x14, 0x81, 0x5F, 0xA5, 0x03, 0x02,
  // "ą" (U+0105)
  0x09, 0xEE, 0x80, 0x09, 0x7B, 0xF2, 0x00, 0x16, 0xF5, 0x2D, 0xFF, 0xF5, 0x8F, 0x77, 0xF5, 0x8F,
  0x8C, 0xF5, 0x2D, 0xE5, 0xF5, 0x00, 0x01, 0xD1, 0x00, 0x07, 0xC1, 0x00, 0x05, 0xFA, 0x00, 0x00,
  0x32,
  // "Ć" (U+0106)
  0x40, 0x13, 0x81, 0x1D, 0xA3, 0x02, 0x03, 0x48, 0x93, 0x9E, 0xE9, 0x0A, 0xF9, 0x89, 0x1F, 0xA3,
  0x81, 0x5F, 0x63, 0x81, 0x6F, 0x53, 0x81, 0x4F, 0x63, 0x81, 0x2F, 0xA4, 0x89, 0x1B, 0xF9, 0x78,
  0x01, 0xAE, 0xE8,
  // "ć" (U+0107)
  0x00, 0x00, 0x10, 0x01, 0xDA, 0x00, 0x23, 0x00, 0x5D, 0xE9, 0x1F, 0xC7, 0x66, 0xF3, 0x00, 0x7F,
  0x20, 0x06, 0xF3, 0x00, 0x2F, 0xC7, 0x80, 0x6D, 0xE8,
  // "Ĉ" (U+0108)
  0x00, 0x8F, 0xA0, 0x04, 0xD3, 0xD5, 0x00, 0x00, 0x00, 0x00, 0x9E, 0xE9, 0x0A, 0xF9, 0x89, 0x1F,
  0xA0, 0x00, 0x5F, 0x60, 0x00, 0x6F, 0x50, 0x00, 0x4F, 0x60, 0x00, 0x2F, 0xA0, 0x00, 0x0B, 0xF9,
  0x78, 0x01, 0xAE, 0xE8,
  // "ĉ" (U+0109)
  0x08, 0xFA, 0x04, 0xD3, 0xD5, 0x00, 0x00, 0x00, 0x5D, 0xE9, 0x1F, 0xC7, 0x66, 0xF3, 0x00, 0x7F,
  0x20, 0x06, 0xF3, 0x00, 0x2F, 0xC7, 0x80, 0x6D, 0xE8,
  // "Ċ" (U+010A)
  0x00, 0x06, 0xF2, 0x00, 0x00, 0x30, 0x00, 0x9E, 0xE9, 0x0A, 0xF9, 0x89, 0x1F, 0xA0, 0x00, 0x5F,
  0x60, 0x00, 0x6F, 0x50, 0x00, 0x4F, 0x60, 0x00, 0x2F, 0xA0, 0x00, 0x0B, 0xF9, 0x78, 0x01, 0xAE,
  0xE8,
  // "ċ" (U+010B)
  0x00, 0x6F, 0x20, 0x00, 0x30, 0x05, 0xDE, 0x91, 0xFC, 0x76, 0x6F, 0x30, 0x07, 0xF2, 0x00, 0x6F,
  0x30, 0x02, 0xFC, 0x78, 0x06, 0xDE, 0x80,
  // "Č" (U+010C)
  0x04, 0xD3, 0xD5, 0x00, 0x8F, 0xA0, 0x00, 0x00, 0x00, 0x00, 0x9E, 0xE9, 0x0A, 0xF9, 0x89, 0x1F,
  0xA0, 0x00, 0x5F, 0x60, 0x00, 0x6F, 0x50, 0x00, 0x4F, 0x60, 0x00, 0x2F, 0xA0, 0x00, 0x0B, 0xF9,
  0x78, 0x01, 0xAE, 0xE8,
  // "č" (U+010D)
  0x4D, 0x3D, 0x50, 0x8F, 0xA0, 0x00, 0x00, 0x00, 0x5D, 0xE9, 0x1F, 0xC7, 0x66, 0xF3, 0x00, 0x7F,
  0x20, 0x06, 0xF3, 0x00, 0x2F, 0xC7, 0x80, 0x6D, 0xE8,
  // "Ď" (U+010E)
  0x04, 0xD3, 0xD5, 0x00, 0x08, 0xFA, 0x00, 0x00, 0x00, 0x00, 0x02, 0xFF, 0xFB, 0x30, 0x2F, 0xB7,
  0xEE, 0x12, 0xF8, 0x04, 0xF8, 0x2F, 0x80, 0x0F, 0xB2, 0xF8, 0x00, 0xFC, 0x2F, 0x80, 0x0F, 0xA2,
  0xF8, 0x05, 0xF7, 0x2F, 0xB8, 0xEE, 0x12, 0xFF, 0xEB, 0x20,
  // "ď" (U+010F)
  0x00, 0x00, 0xDB, 0xAB, 0x00, 0x00, 0xDB, 0x52, 0x00, 0x00, 0xDB, 0x00, 0x08, 0xE9, 0xDB, 0x00,
  0x3F, 0xB9, 0xFB, 0x00, 0x6F, 0x30, 0xEB, 0x00, 0x7F, 0x10, 0xDB, 0x00, 0x6F, 0x30, 0xEB, 0x00,
  0x3F, 0xB9, 0xFB, 0x00, 0x08, 0xE9, 0xBB, 0x00,
  // "Đ" (U+0110)
  0x2F, 0xFF, 0xB3, 0x02, 0xFB, 0x7E, 0xE1, 0x2F, 0x80, 0x4F, 0x83, 0xF9, 0x10, 0xFB, 0xDF, 0xF9,
  0x0F, 0xC5, 0xFA, 0x20, 0xFA, 0x2F, 0x80, 0x5F, 0x72, 0xFB, 0x8E, 0xE1, 0x2F, 0xFE, 0xB2, 0x00,
  // "đ" (U+0111)
  0x00, 0x01, 0xEB, 0x10, 0x03, 0xFF, 0xF7, 0x00, 0x14, 0xEC, 0x20, 0x8E, 0x9D, 0xB0, 0x3F, 0xB9,
  0xFB, 0x06, 0xF3, 0x0E, 0xB0, 0x7F, 0x10, 0xDB, 0x06, 0xF3, 0x0E, 0xB0, 0x3F, 0xB9, 0xFB, 0x00,
  0x8E, 0x9B, 0xB0,
  // "Ē" (U+0112)
  0x01, 0x11, 0x10, 0x8F, 0xFF, 0x02, 0x44, 0x42, 0xFF, 0xFF, 0x2F, 0xB6, 0x62, 0xF8, 0x00, 0x2F,
  0x91, 0x12, 0xFF, 0xFD, 0x2F, 0xA4, 0x32, 0xF8, 0x00, 0x2F, 0xB6, 0x62, 0xFF, 0xFF,
  // "ē" (U+0113)
  0x01, 0x11, 0x10, 0x08, 0xFF, 0xF0, 0x02, 0x44, 0x40, 0x06, 0xDE, 0x60, 0x2F, 0xB9, 0xF2, 0x6F,
  0x42, 0xF7, 0x7F, 0xFF, 0xF8, 0x6F, 0x64, 0x42, 0x2F, 0xB6, 0x82, 0x05, 0xDE, 0xC1,
  // "Ĕ" (U+0114)
  0x05, 0x72, 0x92, 0x02, 0xEF, 0xC0, 0x00, 0x13, 0x00, 0x2F, 0xFF, 0xF0, 0x2F, 0xB6, 0x60, 0x2F,
  0x80, 0x00, 0x2F, 0x91, 0x10, 0x2F, 0xFF, 0xD0, 0x2F, 0xA4, 0x30, 0x2F, 0x80, 0x00, 0x2F, 0xB6,
  0x60, 0x2F, 0xFF, 0xF0,
  // "ĕ" (U+0115)
  0x05, 0x72, 0x92, 0x02, 0xEF, 0xC0, 0x00, 0x13, 0x00, 0x06, 0xDE, 0x60, 0x2F, 0xB9, 0xF2, 0x6F,
  0x42, 0xF7, 0x7F, 0xFF, 0xF8, 0x6F, 0x64, 0x42, 0x2F, 0xB6, 0x82, 0x05, 0xDE, 0xC1,
  // "Ė" (U+0116)
  0x28, 0x16, 0xF2, 0x38, 0x13, 0x02, 0xC8, 0x62, 0xFB, 0x66, 0x2F, 0x82, 0x84, 0x2F, 0x91, 0x12,
  0xB8, 0x7D, 0x2F, 0xA4, 0x32, 0xF8, 0x28, 0x42, 0xFB, 0x66, 0x2C,
  // "ė" (U+0117)
  0x00, 0x6F, 0x20, 0x00, 0x03, 0x00, 0x06, 0xDE, 0x60, 0x2F, 0xB9, 0xF2, 0x6F, 0x42, 0xF7, 0x7F,
  0xFF, 0xF8, 0x6F, 0x64, 0x42, 0x2F, 0xB6, 0x82, 0x05, 0xDE, 0xC1,
  // "Ę" (U+0118)
  0x2F, 0xFF, 0xF2, 0xFB, 0x66, 0x2F, 0x80, 0x02, 0xF9, 0x11, 0x2F, 0xFF, 0xD2, 0xFA, 0x43, 0x2F,
  0x80, 0x02, 0xFB, 0x66, 0x2F, 0xFF, 0xF0, 0x01, 0xD1, 0x00, 0x7C, 0x10, 0x05, 0xFA, 0x00, 0x03,
  0x20,
  // "ę" (U+0119)
  0x06, 0xDE, 0x60, 0x2F, 0xB9, 0xF2, 0x6F, 0x42, 0xF7, 0x7F, 0xFF, 0xF8, 0x6F, 0x64, 0x42, 0x2F,
  0xB6, 0x82, 0x05, 0xDF, 0xE2, 0x00, 0x09, 0x60, 0x00, 0x0F, 0x91, 0x00, 0x0A, 0xF3,
  // "Ě" (U+011A)
  0x87, 0x4D, 0x3D, 0x50, 0x8F, 0xA6, 0x02, 0xC8, 0x62, 0xFB, 0x66, 0x2F, 0x82, 0x84, 0x2F, 0x91,
  0x12, 0xB8, 0x7D, 0x2F, 0xA4, 0x32, 0xF8, 0x28, 0x42, 0xFB, 0x66, 0x2C,
  // "ě" (U+011B)
  0x4D, 0x3D, 0x50, 0x08, 0xFA, 0x00, 0x00, 0x00, 0x00, 0x06, 0xDE, 0x60, 0x2F, 0xB9, 0xF2, 0x6F,
  0x42, 0xF7, 0x7F, 0xFF, 0xF8, 0x6F, 0x64, 0x42, 0x2F, 0xB6, 0x82, 0x05, 0xDE, 0xC1,
  // "Ĝ" (U+011C)
  0x00, 0x08, 0xFA, 0x00, 0x04, 0xD3, 0xD5, 0x00, 0x00, 0x00, 0x00, 0x07, 0xDF, 0xC4, 0x09, 0xFB,
  0x7A, 0x31, 0xFB, 0x00, 0x00, 0x5F, 0x60, 0x11, 0x16, 0xF5, 0x2F, 0xFA, 0x4F, 0x60, 0x4F, 0xA1,
  0xFA, 0x00, 0xEA, 0x0A, 0xF9, 0x7F, 0xA0, 0x1A, 0xEE, 0xD6,
  // "ĝ" (U+011D)
  0x00, 0x8F, 0xA0, 0x04, 0xD3, 0xD5, 0x00, 0x00, 0x00, 0x08, 0xEA, 0xBB, 0x3F, 0xB9, 0xFB, 0x6F,
  0x30, 0xEB, 0x7F, 0x20, 0xDB, 0x6F, 0x30, 0xEB, 0x3F, 0xB9, 0xFB, 0x08, 0xE9, 0xDB, 0x00, 0x00,
  0xE9, 0x2A, 0x7A, 0xF5, 0x1C, 0xFD, 0x70,
  // "Ğ" (U+011E)
  0x00, 0x57, 0x29, 0x20, 0x02, 0xEF, 0xC0, 0x00, 0x01, 0x30, 0x00, 0x07, 0xDF, 0xC4, 0x09, 0xFB,
  0x7A, 0x31, 0xFB, 0x00, 0x00, 0x5F, 0x60, 0x11, 0x16, 0xF5, 0x2F, 0xFA, 0x4F, 0x60, 0x4F, 0xA1,
  0xFA, 0x00, 0xEA, 0x0A, 0xF9, 0x7F, 0xA0, 0x1A, 0xEE, 0xD6,
  // "ğ" (U+011F)
  0x05, 0x72, 0x92, 0x02, 0xEF, 0xC0, 0x00, 0x13, 0x00, 0x08, 0xEA, 0xBB, 0x3F, 0xB9, 0xFB, 0x6F,
  0x30, 0xEB, 0x7F, 0x20, 0xDB, 0x6F, 0x30, 0xEB, 0x3F, 0xB9, 0xFB, 0x08, 0xE9, 0xDB, 0x00, 0x00,
  0xE9, 0x2A, 0x7A, 0xF5, 0x1C, 0xFD, 0x70,
  // "Ġ" (U+0120)
  0x00, 0x06, 0xF2, 0x00, 0x00, 0x03, 0x00, 0x00, 0x7D, 0xFC, 0x40, 0x9F, 0xB7, 0xA3, 0x1F, 0xB0,
  0x00, 0x05, 0xF6, 0x01, 0x11, 0x6F, 0x52, 0xFF, 0xA4, 0xF6, 0x04, 0xFA, 0x1F, 0xA0, 0x0E, 0xA0,
  0xAF, 0x97, 0xFA, 0x01, 0xAE, 0xED, 0x60,
  // "ġ" (U+0121)
  0x00, 0x6F, 0x20, 0x00, 0x03, 0x00, 0x08, 0xEA, 0xBB, 0x3F, 0xB9, 0xFB, 0x6F, 0x30, 0xEB, 0x7F,
  0x20, 0xDB, 0x6F, 0x30, 0xEB, 0x3F, 0xB9, 0xFB, 0x08, 0xE9, 0xDB, 0x00, 0x00, 0xE9, 0x2A, 0x7A,
  0xF5, 0x1C, 0xFD, 0x70,
  // "Ģ" (U+0122)
  0x28, 0x95, 0x7D, 0xFC, 0x40, 0x9F, 0xB7, 0xA3, 0x1F, 0xB4, 0x89, 0x15, 0xF6, 0x01, 0x11, 0x6F,
  0x52, 0xA8, 0x91, 0xA4, 0xF6, 0x04, 0xFA, 0x1F, 0xA2, 0x89, 0x6E, 0xA0, 0xAF, 0x97, 0xFA, 0x01,
  0xAE, 0xED, 0x67, 0x30, 0x40, 0x65, 0x0B, 0x07, 0x20,
  // "ģ" (U+0123)
  0x20, 0x39, 0x40, 0x40, 0x57, 0x28, 0xC7, 0x8E, 0xAB, 0xB3, 0xFB, 0x9F, 0xB6, 0xF3, 0x0E, 0xB7,
  0xF2, 0x0D, 0xB6, 0xF3, 0x0E, 0xB3, 0xFB, 0x9F, 0xB0, 0x8E, 0x9D, 0xB4, 0x89, 0x3E, 0x92, 0xA7,
  0xAF, 0x51, 0xCF, 0xD7, 0x10,
  // "Ĥ" (U+0124)
  0x00, 0x8F, 0xA0, 0x00, 0x4D, 0x3D, 0x50, 0x00, 0x00, 0x00, 0x02, 0xF8, 0x00, 0xEB, 0x2F, 0x80,
  0x0E, 0xB2, 0xF8, 0x00, 0xEB, 0x2F, 0x91, 0x1E, 0xB2, 0xFF, 0xFF, 0xFB, 0x2F, 0xA4, 0x4E, 0xB2,
  0xF8, 0x00, 0xEB, 0x2F, 0x80, 0x0E, 0xB2, 0xF8, 0x00, 0xEB,
  // "ĥ" (U+0125)
  0x18, 0x18, 0xFA, 0x38, 0x34, 0xD3, 0xD5, 0x73, 0x81, 0x3F, 0x54, 0x81, 0x3F, 0x54, 0x81, 0x3F,
  0x54, 0x8D, 0x63, 0xF8, 0xDD, 0x30, 0x3F, 0xD7, 0xFA, 0x03, 0xF7, 0x0C, 0xC0, 0x3F, 0x60, 0xCD,
  0x03, 0xF5, 0x0C, 0xD0, 0x3F, 0x50, 0xCD, 0x03, 0xF5, 0x0C, 0xD0,
  // "Ħ" (U+0126)
  0x3F, 0x91, 0x1E, 0xC1, 0xFF, 0xFF, 0xFF, 0xFA, 0x5F, 0xA4, 0x4E, 0xC3, 0x1F, 0x91, 0x1E, 0xB0,
  0x1F, 0xFF, 0xFF, 0xB0, 0x1F, 0xA4, 0x4E, 0xB0, 0x1F, 0x80, 0x0E, 0xB0, 0x1F, 0x80, 0x0E, 0xB0,
  0x1F, 0x80, 0x0E, 0xB0,
  // "ħ" (U+0127)
  0x5F, 0x71, 0x00, 0xFF, 0xFB, 0x00, 0x7F, 0x83, 0x00, 0x3F, 0x9D, 0xD3, 0x3F, 0xD8, 0xFA, 0x3F,
  0x70, 0xDC, 0x3F, 0x60, 0xCD, 0x3F, 0x50, 0xCD, 0x3F, 0x50, 0xCD, 0x3F, 0x50, 0xCD,
  // "Ĩ" (U+0128)
  0x1E, 0x95, 0x96, 0x9A, 0xF5, 0x11, 0x02, 0x00, 0x9F, 0xFC, 0x01, 0xDE, 0x20, 0x0C, 0xE0, 0x00,
  0xCE, 0x00, 0x0C, 0xE0, 0x00, 0xCE, 0x00, 0x0C, 0xE0, 0x01, 0xDE, 0x10, 0x9F, 0xFC,
  // "ĩ" (U+0129)
  0x1E, 0x95, 0x96, 0x9A, 0xF5, 0x11, 0x02, 0x00, 0x3F, 0x60, 0x03, 0xF6, 0x00, 0x3F, 0x60, 0x03,
  0xF6, 0x00, 0x3F, 0x60, 0x03, 0xF6, 0x00, 0x3F, 0x60,
  // "Ī" (U+012A)
  0x11, 0x11, 0x8F, 0xFF, 0x24, 0x44, 0x9F, 0xFC, 0x1D, 0xE2, 0x0C, 0xE0, 0x0C, 0xE0, 0x0C, 0xE0,
  0x0C, 0xE0, 0x0C, 0xE0, 0x1D, 0xE1, 0x9F, 0xFC,
  // "ī" (U+012B)
  0x11, 0x11, 0x8F, 0xFF, 0x24, 0x44, 0x03, 0xF6, 0x03, 0xF6, 0x03, 0xF6, 0x03, 0xF6, 0x03, 0xF6,
  0x03, 0xF6, 0x03, 0xF6,
  // "Ĭ" (U+012C)
  0x57, 0x29, 0x22, 0xEF, 0xC0, 0x01, 0x30, 0x09, 0xFF, 0xC0, 0x1D, 0xE2, 0x00, 0xCE, 0x00, 0x0C,
  0xE0, 0x00, 0xCE, 0x00, 0x0C, 0xE0, 0x00, 0xCE, 0x00, 0x1D, 0xE1, 0x09, 0xFF, 0xC0,
  // "ĭ" (U+012D)
  0x57, 0x29, 0x22, 0xEF, 0xC0, 0x01, 0x30, 0x00, 0x3F, 0x60, 0x03, 0xF6, 0x00, 0x3F, 0x60, 0x03,
  0xF6, 0x00, 0x3F, 0x60, 0x03, 0xF6, 0x00, 0x3F, 0x60,
  // "Į" (U+012E)
  0x9F, 0xFC, 0x1D, 0xE2, 0x0C, 0xE0, 0x0C, 0xE0, 0x0C, 0xE0, 0x0C, 0xE0, 0x0C, 0xE0, 0x1D, 0xE1,
  0x9F, 0xFC, 0x01, 0xD1, 0x07, 0xC1, 0x05, 0xFA, 0x00, 0x32,
  // "į" (U+012F)
  0x2E, 0x40, 0x51, 0x00, 0x03, 0xF6, 0x3F, 0x63, 0xF6, 0x3F, 0x63, 0xF6, 0x3F, 0x63, 0xF6, 0x1D,
  0x17, 0xC1, 0x5F, 0xA0, 0x32,
  // "İ" (U+0130)
  0x06, 0xF2, 0x00, 0x30, 0x9F, 0xFC, 0x1D, 0xE2, 0x0C, 0xE0, 0x0C, 0xE0, 0x0C, 0xE0, 0x0C, 0xE0,
  0x0C, 0xE0, 0x1D, 0xE1, 0x9F, 0xFC,
  // "ı" (U+0131)
  0x3F, 0x63, 0xF6, 0x3F, 0x63, 0xF6, 0x3F, 0x63, 0xF6, 0x3F, 0x60,
  // "Ĳ" (U+0132)
  0x9F, 0xFC, 0x1F, 0x81, 0xDE, 0x21, 0xF8, 0x0C, 0xE0, 0x1F, 0x80, 0xCE, 0x01, 0xF8, 0x0C, 0xE0,
  0x1F, 0x80, 0xCE, 0x01, 0xF8, 0x0C, 0xE0, 0x1F, 0x81, 0xDE, 0x11, 0xF8, 0x9F, 0xFC, 0x2F, 0x80,
  0x00, 0x05, 0xF7, 0x00, 0x0B, 0xFF, 0x20, 0x00, 0x47, 0x20,
  // "ĳ" (U+0133)
  0x2E, 0x42, 0xE4, 0x05, 0x10, 0x51, 0x00, 0x00, 0x00, 0x3F, 0x63, 0xF6, 0x3F, 0x63, 0xF6, 0x3F,
  0x63, 0xF6, 0x3F, 0x63, 0xF6, 0x3F, 0x63, 0xF6, 0x3F, 0x63, 0xF6, 0x3F, 0x63, 0xF6, 0x00, 0x04,
  0xF5, 0x00, 0x3B, 0xF4, 0x00, 0x6F, 0xA0,
  // "Ĵ" (U+0134)
  0x08, 0xFA, 0x04, 0xD3, 0xD5, 0x00, 0x00, 0x00, 0x1F, 0x80, 0x01, 0xF8, 0x00, 0x1F, 0x80, 0x01,
  0xF8, 0x00, 0x1F, 0x80, 0x01, 0xF8, 0x00, 0x1F, 0x80, 0x01, 0xF8, 0x00, 0x2F, 0x80, 0x05, 0xF7,
  0x0B, 0xFF, 0x20, 0x47, 0x20, 0x00,
  // "ĵ" (U+0135)
  0x08, 0xFA, 0x04, 0xD3, 0xD5, 0x00, 0x00, 0x00, 0x3F, 0x60, 0x03, 0xF6, 0x00, 0x3F, 0x60, 0x03,
  0xF6, 0x00, 0x3F, 0x60, 0x03, 0xF6, 0x00, 0x3F, 0x60, 0x03, 0xF5, 0x03, 0xAF, 0x40, 0x6F, 0xA0,
  0x00,
  // "Ķ" (U+0136)
  0x8B, 0x02, 0xF8, 0x06, 0xF6, 0x2F, 0x81, 0xEC, 0x02, 0xF8, 0x9F, 0x30, 0x2F, 0xAF, 0xA2, 0x02,
  0xB0, 0x92, 0x8B, 0x22, 0xFD, 0xCF, 0x10, 0x2F, 0x84, 0xF8, 0x02, 0xF8, 0x0D, 0xE1, 0x2F, 0x80,
  0x6F, 0x77, 0x30, 0x60, 0x24, 0x81, 0x3E, 0x12,
  // "ķ" (U+0137)
  0x81, 0x3F, 0x53, 0x81, 0x3F, 0x53, 0x81, 0x3F, 0x53, 0x8A, 0x13, 0xF5, 0x1E, 0xC3, 0xF5, 0x9E,
  0x23, 0xF9, 0xF6, 0x03, 0xB8, 0xA2, 0x60, 0x3F, 0xAC, 0xE0, 0x3F, 0x54, 0xF7, 0x3F, 0x50, 0xCE,
  0x71, 0x03, 0x06, 0x40, 0x09, 0x20,
  // "ĸ" (U+0138)
  0x3F, 0x50, 0xDC, 0x3F, 0x58, 0xF2, 0x3F, 0x8F, 0x70, 0x3F, 0xFF, 0x60, 0x3F, 0xAC, 0xD0, 0x3F,
  0x54, 0xF7, 0x3F, 0x50, 0xCE,
  // "Ĺ" (U+0139)
  0x20, 0x13, 0x81, 0x1D, 0xA3, 0x02, 0x03, 0x48, 0x12, 0xF8, 0x38, 0x12, 0xF8, 0x38, 0x12, 0xF8,
  0x38, 0x12, 0xF8, 0x38, 0x12, 0xF8, 0x38, 0x12, 0xF8, 0x38, 0x12, 0xF8, 0x38, 0x52, 0xFC, 0x88,
  0x12, 0xC0, 0x30,
  // "ĺ" (U+013A)
  0x00, 0x11, 0xDA, 0x23, 0x03, 0xF5, 0x3F, 0x53, 0xF5, 0x3F, 0x53, 0xF5, 0x3F, 0x53, 0xF5, 0x3F,
  0x53, 0xF5, 0x3F, 0x50,
  // "Ļ" (U+013B)
  0x81, 0x2F, 0x83, 0x81, 0x2F, 0x83, 0x81, 0x2F, 0x83, 0x81, 0x2F, 0x83, 0x81, 0x2F, 0x83, 0x81,
  0x2F, 0x83, 0x81, 0x2F, 0x83, 0x85, 0x2F, 0xC8, 0x81, 0x2C, 0x03, 0x71, 0x04, 0x05, 0x40, 0xC0,
  0x62,
  // "ļ" (U+013C)
  0x3F, 0x53, 0xF5, 0x3F, 0x53, 0xF5, 0x3F, 0x53, 0xF5, 0x3F, 0x53, 0xF5, 0x3F, 0x53, 0xF5, 0x00,
  0x00, 0x62, 0x4E, 0x10,
  // "Ľ" (U+013D)
  0x2F, 0x80, 0xF6, 0x2F, 0x81, 0x60, 0x2F, 0x80, 0x00, 0x2F, 0x80, 0x00, 0x2F, 0x80, 0x00, 0x2F,
  0x80, 0x00, 0x2F, 0x80, 0x00, 0x2F, 0xC8, 0x81, 0x2F, 0xFF, 0xF3,
  // "ľ" (U+013E)
  0x3F, 0x6F, 0x53, 0xF7, 0x60, 0x3F, 0x50, 0x03, 0xF5, 0x00, 0x3F, 0x50, 0x03, 0xF5, 0x00, 0x3F,
  0x50, 0x03, 0xF5, 0x00, 0x3F, 0x50, 0x03, 0xF5, 0x00,
  // "Ŀ" (U+013F)
  0x2F, 0x80, 0x00, 0x2F, 0x80, 0x00, 0x2F, 0x80, 0x00, 0x2F, 0x80, 0x00, 0x2F, 0x86, 0xF2, 0x2F,
  0x80, 0x30, 0x2F, 0x80, 0x00, 0x2F, 0xC8, 0x81, 0x2F, 0xFF, 0xF3,
  // "ŀ" (U+0140)
  0x3F, 0x50, 0x03, 0xF5, 0x00, 0x3F, 0x50, 0x03, 0xF5, 0x00, 0x3F, 0x50, 0x03, 0xFC, 0xF2, 0x3F,
  0x63, 0x03, 0xF5, 0x00, 0x3F, 0x50, 0x03, 0xF5, 0x00,
  // "Ł" (U+0141)
  0x19, 0x0A, 0x49, 0x0A, 0x49, 0x0B, 0x04, 0x3B, 0x84, 0x20, 0x4F, 0xD3, 0x28, 0x1D, 0xFA, 0x38,
  0x11, 0xFA, 0x49, 0x82, 0xD8, 0x82, 0x1C, 0x05,
  // "ł" (U+0142)
  0x1F, 0x80, 0x1F, 0x80, 0x1F, 0x80, 0x1F, 0xB2, 0x1F, 0xF7, 0xAF, 0xA0, 0xCF, 0x80, 0x1F, 0x80,
  0x1F, 0x80, 0x1F, 0x80,
  // "Ń" (U+0143)
  0x50, 0x15, 0x81, 0x1D, 0xA5, 0x02, 0x03, 0x30, 0x2A, 0x84, 0x20, 0x4F, 0x42, 0xA8, 0xD0, 0x80,
  0x4F, 0x42, 0xFE, 0xE1, 0x4F, 0x42, 0xF9, 0xF7, 0x4F, 0x42, 0xF6, 0xBE, 0x4F, 0x42, 0xF6, 0x5F,
  0x9F, 0x42, 0xF6, 0x0D, 0xA8, 0x44, 0x2F, 0x60, 0x6A, 0x82, 0x42, 0xF6, 0x28, 0x1E, 0xF4,
  // "ń" (U+0144)
  0x00, 0x00, 0x10, 0x00, 0x1D, 0xA0, 0x00, 0x23, 0x00, 0x3F, 0x6D, 0xD3, 0x3F, 0xD7, 0xFA, 0x3F,
  0x70, 0xCC, 0x3F, 0x60, 0xCD, 0x3F, 0x50, 0xCD, 0x3F, 0x50, 0xCD, 0x3F, 0x50, 0xCD,
  // "Ņ" (U+0145)
  0x02, 0xA8, 0x42, 0x04, 0xF4, 0x2A, 0x8D, 0x08, 0x04, 0xF4, 0x2F, 0xEE, 0x14, 0xF4, 0x2F, 0x9F,
  0x74, 0xF4, 0x2F, 0x6B, 0xE4, 0xF4, 0x2F, 0x65, 0xF9, 0xF4, 0x2F, 0x60, 0xDA, 0x84, 0x42, 0xF6,
  0x06, 0xA8, 0x24, 0x2F, 0x62, 0x81, 0xEF, 0x47, 0x40, 0x40, 0x66, 0x0B, 0x07, 0x30,
  // "ņ" (U+0146)
  0x8D, 0x03, 0xF6, 0xDD, 0x33, 0xFD, 0x7F, 0xA3, 0xF7, 0x0C, 0xC3, 0xF6, 0x0C, 0xD3, 0xF5, 0x0C,
  0xD3, 0xF5, 0x0C, 0xD3, 0xF5, 0x0C, 0xD7, 0x10, 0x20, 0x64, 0x08, 0x0A, 0x20,
  // "Ň" (U+0147)
  0x00, 0x4D, 0x3D, 0x50, 0x00, 0x08, 0xFA, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xF2, 0x04, 0xF4,
  0x2F, 0xF8, 0x04, 0xF4, 0x2F, 0xEE, 0x14, 0xF4, 0x2F, 0x9F, 0x74, 0xF4, 0x2F, 0x6B, 0xE4, 0xF4,
  0x2F, 0x65, 0xF9, 0xF4, 0x2F, 0x60, 0xDF, 0xF4, 0x2F, 0x60, 0x6F, 0xF4, 0x2F, 0x60, 0x0E, 0xF4,
  // "ň" (U+0148)
  0x04, 0xD3, 0xD5, 0x00, 0x8F, 0xA0, 0x00, 0x00, 0x00, 0x3F, 0x6D, 0xD3, 0x3F, 0xD7, 0xFA, 0x3F,
  0x70, 0xCC, 0x3F, 0x60, 0xCD, 0x3F, 0x50, 0xCD, 0x3F, 0x50, 0xCD, 0x3F, 0x50, 0xCD,
  // "ŉ" (U+0149)
  0x3F, 0x50, 0x00, 0x06, 0xF1, 0x00, 0x00, 0x9F, 0xF6, 0xDD, 0x30, 0x3F, 0xD7, 0xFA, 0x03, 0xF7,
  0x0C, 0xC0, 0x3F, 0x60, 0xCD, 0x03, 0xF5, 0x0C, 0xD0, 0x3F, 0x50, 0xCD, 0x03, 0xF5, 0x0C, 0xD0,
  // "Ŋ" (U+014A)
  0x2F, 0xF2, 0x04, 0xF4, 0x2F, 0xFA, 0x04, 0xF4, 0x2F, 0xEF, 0x24, 0xF4, 0x2F, 0x7F, 0xA4, 0xF4,
  0x2F, 0x69, 0xF7, 0xF4, 0x2F, 0x61, 0xEE, 0xF4, 0x2F, 0x60, 0x8F, 0xF4, 0x2F, 0x60, 0x1E, 0xF4,
  0x2F, 0x60, 0x07, 0xF4, 0x00, 0x00, 0x28, 0xF2, 0x00, 0x00, 0xFF, 0xB0, 0x00, 0x00, 0x43, 0x00,
  // "ŋ" (U+014B)
  0x3F, 0x6D, 0xD3, 0x3F, 0xD7, 0xFA, 0x3F, 0x70, 0xCC, 0x3F, 0x60, 0xCD, 0x3F, 0x50, 0xCD, 0x3F,
  0x50, 0xCD, 0x3F, 0x50, 0xCD, 0x00, 0x00, 0xCD, 0x00, 0x06, 0xEA, 0x00, 0x0D, 0xE3,
  // "Ō" (U+014C)
  0x00, 0x11, 0x11, 0x00, 0x00, 0x8F, 0xFF, 0x00, 0x00, 0x24, 0x44, 0x00, 0x01, 0xAE, 0xE9, 0x00,
  0x0B, 0xF8, 0x9F, 0x90, 0x2F, 0xA0, 0x0C, 0xF0, 0x4F, 0x60, 0x08, 0xF3, 0x6F, 0x50, 0x07, 0xF3,
  0x5F, 0x60, 0x08, 0xF2, 0x2F, 0xA0, 0x0C, 0xF0, 0x0B, 0xF8, 0x9F, 0x90, 0x01, 0xAE, 0xE9, 0x00,
  // "ō" (U+014D)
  0x01, 0x11, 0x10, 0x08, 0xFF, 0xF0, 0x02, 0x44, 0x40, 0x05, 0xDE, 0x80, 0x2F, 0xB9, 0xF6, 0x6F,
  0x30, 0xDB, 0x7F, 0x20, 0xCD, 0x6F, 0x30, 0xEB, 0x2F, 0xB9, 0xF7, 0x05, 0xDE, 0x90,
  // "Ŏ" (U+014E)
  0x00, 0x57, 0x29, 0x20, 0x00, 0x2E, 0xFC, 0x00, 0x00, 0x01, 0x30, 0x00, 0x01, 0xAE, 0xE9, 0x00,
  0x0B, 0xF8, 0x9F, 0x90, 0x2F, 0xA0, 0x0C, 0xF0, 0x4F, 0x60, 0x08, 0xF3, 0x6F, 0x50, 0x07, 0xF3,
  0x5F, 0x60, 0x08, 0xF2, 0x2F, 0xA0, 0x0C, 0xF0, 0x0B, 0xF8, 0x9F, 0x90, 0x01, 0xAE, 0xE9, 0x00,
  // "ŏ" (U+014F)
  0x05, 0x72, 0x92, 0x02, 0xEF, 0xC0, 0x00, 0x13, 0x00, 0x05, 0xDE, 0x80, 0x2F, 0xB9, 0xF6, 0x6F,
  0x30, 0xDB, 0x7F, 0x20, 0xCD, 0x6F, 0x30, 0xEB, 0x2F, 0xB9, 0xF7, 0x05, 0xDE, 0x90,
  // "Ő" (U+0150)
  0x00, 0x01, 0x11, 0x10, 0x00, 0x1D, 0x7D, 0x70, 0x00, 0x22, 0x12, 0x00, 0x01, 0xAE, 0xE9, 0x00,
  0x0B, 0xF8, 0x9F, 0x90, 0x2F, 0xA0, 0x0C, 0xF0, 0x4F, 0x60, 0x08, 0xF3, 0x6F, 0x50, 0x07, 0xF3,
  0x5F, 0x60, 0x08, 0xF2, 0x2F, 0xA0, 0x0C, 0xF0, 0x0B, 0xF8, 0x9F, 0x90, 0x01, 0xAE, 0xE9, 0x00,
  // "ő" (U+0151)
  0x00, 0x11, 0x11, 0x01, 0xD7, 0xD7, 0x02, 0x21, 0x20, 0x05, 0xDE, 0x80, 0x2F, 0xB9, 0xF6, 0x6F,
  0x30, 0xDB, 0x7F, 0x20, 0xCD, 0x6F, 0x30, 0xEB, 0x2F, 0xB9, 0xF7, 0x05, 0xDE, 0x90,
  // "Œ" (U+0152)
  0x01, 0xAE, 0xFF, 0xFF, 0xD0, 0xBF, 0x89, 0xF9, 0x65, 0x2F, 0x90, 0x4F, 0x50, 0x05, 0xF6, 0x04,
  0xF6, 0x11, 0x6F, 0x50, 0x4F, 0xFF, 0xB5, 0xF6, 0x04, 0xF8, 0x43, 0x2F, 0x90, 0x4F, 0x50, 0x00,
  0xBF, 0x89, 0xF9, 0x65, 0x01, 0xAE, 0xFF, 0xFF, 0xD0,
  // "œ" (U+0153)
  0x05, 0xDE, 0x77, 0xED, 0x30, 0x2F, 0xB9, 0xFF, 0x8C, 0xD0, 0x6F, 0x30, 0xDD, 0x15, 0xF2, 0x7F,
  0x20, 0xCF, 0xFF, 0xF4, 0x6F, 0x30, 0xDD, 0x44, 0x41, 0x2F, 0xB9, 0xFF, 0x97, 0x90, 0x05, 0xDE,
  0x76, 0xDE, 0xA0,
  // "Ŕ" (U+0154)
  0x00, 0x00, 0x10, 0x00, 0x01, 0xDA, 0x00, 0x00, 0x23, 0x00, 0x02, 0xFF, 0xEB, 0x20, 0x2F, 0xB8,
  0xFC, 0x02, 0xF8, 0x0B, 0xE0, 0x2F, 0x93, 0xEC, 0x02, 0xFF, 0xFE, 0x30, 0x2F, 0xAB, 0xE0, 0x02,
  0xF8, 0x4F, 0x70, 0x2F, 0x80, 0xDE, 0x02, 0xF8, 0x06, 0xF6,
  // "ŕ" (U+0155)
  0x00, 0x01, 0x00, 0x1D, 0xA0, 0x02, 0x30, 0x03, 0xF5, 0xE5, 0x3F, 0xE7, 0x23, 0xF8, 0x00, 0x3F,
  0x60, 0x03, 0xF6, 0x00, 0x3F, 0x60, 0x03, 0xF6, 0x00,
  // "Ŗ" (U+0156)
  0x02, 0xA8, 0xB0, 0xEB, 0x20, 0x2F, 0xB8, 0xFC, 0x02, 0xF8, 0x0B, 0xE0, 0x2F, 0x93, 0xEC, 0x02,
  0xB8, 0x6E, 0x30, 0x2F, 0xAB, 0xE2, 0x8A, 0x32, 0xF8, 0x4F, 0x70, 0x2F, 0x80, 0xDE, 0x02, 0xF8,
  0x06, 0xF6, 0x72, 0x81, 0x16, 0x24, 0x04, 0x0D, 0x30,
  // "ŗ" (U+0157)
  0x3F, 0x5E, 0x53, 0xFE, 0x72, 0x3F, 0x80, 0x03, 0xF6, 0x00, 0x3F, 0x60, 0x03, 0xF6, 0x00, 0x3F,
  0x60, 0x00, 0x00, 0x00, 0x06, 0x30, 0x03, 0xE1, 0x00,
  // "Ř" (U+0158)
  0x04, 0xD3, 0xD5, 0x00, 0x08, 0xFA, 0x00, 0x00, 0x00, 0x00, 0x02, 0xFF, 0xEB, 0x20, 0x2F, 0xB8,
  0xFC, 0x02, 0xF8, 0x0B, 0xE0, 0x2F, 0x93, 0xEC, 0x02, 0xFF, 0xFE, 0x30, 0x2F, 0xAB, 0xE0, 0x02,
  0xF8, 0x4F, 0x70, 0x2F, 0x80, 0xDE, 0x02, 0xF8, 0x06, 0xF6,
  // "ř" (U+0159)
  0x4D, 0x3D, 0x50, 0x8F, 0xA0, 0x00, 0x00, 0x03, 0xF5, 0xE5, 0x3F, 0xE7, 0x23, 0xF8, 0x00, 0x3F,
  0x60, 0x03, 0xF6, 0x00, 0x3F, 0x60, 0x03, 0xF6, 0x00,
  // "Ś" (U+015A)
  0x00, 0x00, 0x10, 0x00, 0x1D, 0xA0, 0x00, 0x23, 0x00, 0x07, 0xEE, 0xB1, 0x4F, 0xB7, 0xC0, 0x7F,
  0x40, 0x00, 0x4F, 0xD3, 0x00, 0x09, 0xFF, 0x70, 0x00, 0x4E, 0xF1, 0x00, 0x07, 0xF3, 0x8A, 0x7D,
  0xE0, 0x5D, 0xFD, 0x40,
  // "ś" (U+015B)
  0x00, 0x01, 0x00, 0x1D, 0xA0, 0x02, 0x30, 0x01, 0xBE, 0xC3, 0x8F, 0x7A, 0x27, 0xF7, 0x00, 0x1B,
  0xFC, 0x10, 0x06, 0xF7, 0x78, 0x8F, 0x76, 0xEE, 0xB1,
  // "Ŝ" (U+015C)
  0x08, 0xFA, 0x00, 0x4D, 0x3D, 0x50, 0x00, 0x00, 0x00, 0x07, 0xEE, 0xB1, 0x4F, 0xB7, 0xC0, 0x7F,
  0x40, 0x00, 0x4F, 0xD3, 0x00, 0x09, 0xFF, 0x70, 0x00, 0x4E, 0xF1, 0x00, 0x07, 0xF3, 0x8A, 0x7D,
  0xE0, 0x5D, 0xFD, 0x40,
  // "ŝ" (U+015D)
  0x08, 0xFA, 0x04, 0xD3, 0xD5, 0x00, 0x00, 0x01, 0xBE, 0xC3, 0x8F, 0x7A, 0x27, 0xF7, 0x00, 0x1B,
  0xFC, 0x10, 0x06, 0xF7, 0x78, 0x8F, 0x76, 0xEE, 0xB1,
  // "Ş" (U+015E)
  0x07, 0xEE, 0xB1, 0x4F, 0xB7, 0xC0, 0x7F, 0x40, 0x00, 0x4F, 0xD3, 0x00, 0x09, 0xFF, 0x70, 0x00,
  0x4E, 0xF1, 0x00, 0x07, 0xF3, 0x8A, 0x7D, 0xE0, 0x5D, 0xFD, 0x40, 0x00, 0xA8, 0x00, 0x00, 0x3F,
  0x30, 0x03, 0xFC, 0x00,
  // "ş" (U+015F)
  0x1B, 0xEC, 0x38, 0xF7, 0xA2, 0x7F, 0x70, 0x01, 0xBF, 0xC1, 0x00, 0x6F, 0x77, 0x88, 0xF7, 0x6E,
  0xFB, 0x10, 0xA8, 0x00, 0x03, 0xF3, 0x03, 0xFC, 0x00,
  // "Š" (U+0160)
  0x4D, 0x3D, 0x50, 0x08, 0xFA, 0x00, 0x00, 0x00, 0x00, 0x07, 0xEE, 0xB1, 0x4F, 0xB7, 0xC0, 0x7F,
  0x40, 0x00, 0x4F, 0xD3, 0x00, 0x09, 0xFF, 0x70, 0x00, 0x4E, 0xF1, 0x00, 0x07, 0xF3, 0x8A, 0x7D,
  0xE0, 0x5D, 0xFD, 0x40,
  // "š" (U+0161)
  0x4D, 0x3D, 0x50, 0x8F, 0xA0, 0x00, 0x00, 0x01, 0xBE, 0xC3, 0x8F, 0x7A, 0x27, 0xF7, 0x00, 0x1B,
  0xFC, 0x10, 0x06, 0xF7, 0x78, 0x8F, 0x76, 0xEE, 0xB1,
  // "Ţ" (U+0162)
  0x0C, 0xC8, 0x57, 0x56, 0xFC, 0x63, 0x29, 0x0A, 0x49, 0x0A, 0x49, 0x0A, 0x49, 0x0A, 0x49, 0x0A,
  0x49, 0x0A, 0x49, 0x0A, 0x40, 0xA0, 0x84, 0x81, 0x3F, 0x32, 0x81, 0x3F, 0xC2,
  // "ţ" (U+0163)
  0x05, 0x40, 0x0D, 0x80, 0x9F, 0xFD, 0x6F, 0xB5, 0x1F, 0x80, 0x1F, 0x80, 0x1F, 0x80, 0x0F, 0xC7,
  0x08, 0xFC, 0x0A, 0x80, 0x03, 0xF3, 0x3F, 0xC0,
  // "Ť" (U+0164)
  0x83, 0x4D, 0x3D, 0x52, 0x81, 0x8F, 0xA7, 0x10, 0xCC, 0x85, 0x75, 0x6F, 0xC6, 0x32, 0x90, 0xA4,
  0x90, 0xA4, 0x90, 0xA4, 0x90, 0xA4, 0x90, 0xA4, 0x90, 0xA4, 0x90, 0xA2,
  // "ť" (U+0165)
  0x01, 0x10, 0xC9, 0x0B, 0x80, 0x61, 0x0E, 0x80, 0x00, 0x9F, 0xFD, 0x00, 0x6F, 0xB5, 0x00, 0x1F,
  0x80, 0x00, 0x1F, 0x80, 0x00, 0x1F, 0x80, 0x00, 0x0F, 0xC7, 0x00, 0x08, 0xEC, 0x00,
  // "Ŧ" (U+0166)
  0x0C, 0xC8, 0x57, 0x56, 0xFC, 0x63, 0x29, 0x0A, 0x38, 0x41, 0xFB, 0x10, 0x2B, 0x0D, 0x28, 0x24,
  0xFC, 0x43, 0x90, 0xA4, 0x90, 0xA4, 0x90, 0xA2,
  // "ŧ" (U+0167)
  0x05, 0x40, 0x0D, 0x80, 0x9F, 0xFD, 0x6F, 0xB5, 0x3F, 0x81, 0xBF, 0xFB, 0x4F, 0xA3, 0x0F, 0xC7,
  0x09, 0xFC,
  // "Ũ" (U+0168)
  0x01, 0xE9, 0x59, 0x00, 0x69, 0xAF, 0x50, 0x01, 0x10, 0x20, 0x02, 0xF8, 0x01, 0xF9, 0x2F, 0x80,
  0x1F, 0x92, 0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F, 0x92, 0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F, 0x91,
  0xF9, 0x02, 0xF8, 0x0D, 0xF9, 0xCF, 0x40, 0x2B, 0xED, 0x60,
  // "ũ" (U+0169)
  0x01, 0xE9, 0x59, 0x06, 0x9A, 0xF5, 0x01, 0x10, 0x20, 0x4F, 0x50, 0xCC, 0x4F, 0x50, 0xCC, 0x4F,
  0x50, 0xCC, 0x4F, 0x50, 0xCC, 0x3F, 0x60, 0xDC, 0x1F, 0xB7, 0xFC, 0x08, 0xEB, 0x9C,
  // "Ū" (U+016A)
  0x18, 0x00, 0x13, 0x08, 0xB3, 0x02, 0x0F, 0x42, 0x8F, 0x42, 0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F,
  0x92, 0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F, 0x92, 0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F, 0x91, 0xF9,
  0x02, 0xF8, 0x0D, 0xF9, 0xCF, 0x40, 0x2B, 0xED, 0x61,
  // "ū" (U+016B)
  0x01, 0x11, 0x10, 0x08, 0xFF, 0xF0, 0x02, 0x44, 0x40, 0x4F, 0x50, 0xCC, 0x4F, 0x50, 0xCC, 0x4F,
  0x50, 0xCC, 0x4F, 0x50, 0xCC, 0x3F, 0x60, 0xDC, 0x1F, 0xB7, 0xFC, 0x08, 0xEB, 0x9C,
  // "Ŭ" (U+016C)
  0x05, 0x72, 0x92, 0x00, 0x2E, 0xFC, 0x00, 0x00, 0x13, 0x00, 0x02, 0xF8, 0x01, 0xF9, 0x2F, 0x80,
  0x1F, 0x92, 0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F, 0x92, 0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F, 0x91,
  0xF9, 0x02, 0xF8, 0x0D, 0xF9, 0xCF, 0x40, 0x2B, 0xED, 0x60,
  // "ŭ" (U+016D)
  0x05, 0x72, 0x92, 0x02, 0xEF, 0xC0, 0x00, 0x13, 0x00, 0x4F, 0x50, 0xCC, 0x4F, 0x50, 0xCC, 0x4F,
  0x50, 0xCC, 0x4F, 0x50, 0xCC, 0x3F, 0x60, 0xDC, 0x1F, 0xB7, 0xFC, 0x08, 0xEB, 0x9C,
  // "Ů" (U+016E)
  0x00, 0x3E, 0xD1, 0x00, 0x07, 0xBC, 0x40, 0x00, 0x4F, 0xE1, 0x00, 0x00, 0x21, 0x00, 0x2F, 0x80,
  0x1F, 0x92, 0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F, 0x92, 0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F, 0x92,
  0xF8, 0x01, 0xF9, 0x1F, 0x90, 0x2F, 0x80, 0xDF, 0x9C, 0xF4, 0x02, 0xBE, 0xD6, 0x00,
  // "ů" (U+016F)
  0x03, 0xED, 0x10, 0x07, 0xBC, 0x40, 0x04, 0xFE, 0x10, 0x00, 0x21, 0x00, 0x4F, 0x50, 0xCC, 0x4F,
  0x50, 0xCC, 0x4F, 0x50, 0xCC, 0x4F, 0x50, 0xCC, 0x3F, 0x60, 0xDC, 0x1F, 0xB7, 0xFC, 0x08, 0xEB,
  0x9C,
  // "Ű" (U+0170)
  0x00, 0x01, 0x11, 0x10, 0x01, 0xD7, 0xD7, 0x00, 0x22, 0x12, 0x02, 0xF8, 0x01, 0xF9, 0x2F, 0x80,
  0x1F, 0x92, 0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F, 0x92, 0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F, 0x91,
  0xF9, 0x02, 0xF8, 0x0D, 0xF9, 0xCF, 0x40, 0x2B, 0xED, 0x60,
  // "ű" (U+0171)
  0x00, 0x11, 0x11, 0x01, 0xD7, 0xD7, 0x02, 0x21, 0x20, 0x4F, 0x50, 0xCC, 0x4F, 0x50, 0xCC, 0x4F,
  0x50, 0xCC, 0x4F, 0x50, 0xCC, 0x3F, 0x60, 0xDC, 0x1F, 0xB7, 0xFC, 0x08, 0xEB, 0x9C,
  // "Ų" (U+0172)
  0x2F, 0x80, 0x1F, 0x92, 0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F, 0x92, 0xF8, 0x01, 0xF9, 0x2F, 0x80,
  0x1F, 0x92, 0xF8, 0x01, 0xF9, 0x1F, 0x90, 0x2F, 0x80, 0xDF, 0x9C, 0xF3, 0x02, 0xBE, 0xF7, 0x00,
  0x00, 0x3C, 0x00, 0x00, 0x08, 0xC4, 0x00, 0x00, 0x4E, 0x80,
  // "ų" (U+0173)
  0x4F, 0x50, 0xCC, 0x4F, 0x50, 0xCC, 0x4F, 0x50, 0xCC, 0x4F, 0x50, 0xCC, 0x3F, 0x60, 0xDC, 0x1F,
  0xB7, 0xFC, 0x08, 0xEB, 0xAC, 0x00, 0x01, 0xD1, 0x00, 0x07, 0xC1, 0x00, 0x05, 0xFA, 0x00, 0x00,
  0x32,
  // "Ŵ" (U+0174)
  0x38, 0x18, 0xFA, 0x68, 0x34, 0xD3, 0xD5, 0x76, 0x0D, 0x0B, 0x20, 0xD0, 0xC2, 0x82, 0xCD, 0xAE,
  0x2A, 0x29, 0x83, 0xA7, 0xF2, 0x4A, 0x8A, 0x43, 0x2F, 0x74, 0xF5, 0x7D, 0xD6, 0x5F, 0x31, 0xF7,
  0xAA, 0xB9, 0x89, 0x28, 0x6D, 0xAD, 0x78, 0xCB, 0xD2, 0x86, 0xAD, 0xF4, 0x4F, 0xDA, 0x20, 0x7A,
  0x00, 0x1A, 0x06, 0x28, 0x14, 0xFD, 0x28, 0x1D, 0xF3, 0x10,
  // "ŵ" (U+0175)
  0x38, 0x18, 0xFA, 0x58, 0x34, 0xD3, 0xD5, 0x74, 0x8C, 0x1C, 0xC0, 0x9F, 0x60, 0xE9, 0x9F, 0x0C,
  0xF9, 0x2F, 0x65, 0xF3, 0xFA, 0xC5, 0xF2, 0x2F, 0x8F, 0x5F, 0x8E, 0x28, 0x5E, 0xCD, 0x1F, 0xCB,
  0x28, 0x5B, 0xFB, 0x0E, 0xF8, 0x28, 0x57, 0xF8, 0x0B, 0xF4, 0x10,
  // "Ŷ" (U+0176)
  0x28, 0x18, 0xFA, 0x38, 0x34, 0xD3, 0xD5, 0x71, 0x0C, 0x0E, 0x28, 0x7B, 0xE1, 0x6F, 0x51, 0xF9,
  0x28, 0x3E, 0xB7, 0xF3, 0x28, 0x29, 0xFE, 0xC3, 0x02, 0xA0, 0x54, 0x0C, 0x95, 0x0B, 0x0E, 0x50,
  0xB0, 0xE5, 0x0B, 0x0E, 0x30,
  // "ŷ" (U+0177)
  0x08, 0xFA, 0x00, 0x4D, 0x3D, 0x50, 0x00, 0x00, 0x00, 0xCD, 0x01, 0xF9, 0x8F, 0x24, 0xF4, 0x3F,
  0x68, 0xF0, 0x0E, 0x9C, 0xB0, 0x09, 0xDF, 0x70, 0x04, 0xFF, 0x20, 0x00, 0xFD, 0x00, 0x01, 0xF9,
  0x00, 0x4B, 0xF3, 0x00, 0x8E, 0x70, 0x00,
  // "Ÿ" (U+0178)
  0x18, 0x29, 0xA6, 0xD3, 0x82, 0x11, 0x02, 0x20, 0xC0, 0xE2, 0x87, 0xBE, 0x16, 0xF5, 0x1F, 0x92,
  0x83, 0xEB, 0x7F, 0x32, 0x82, 0x9F, 0xEC, 0x30, 0x2A, 0x05, 0x40, 0xC9, 0x50, 0xB0, 0xE5, 0x0B,
  0x0E, 0x50, 0xB0, 0xE3,
  // "Ź" (U+0179)
  0x30, 0x13, 0x81, 0x1D, 0xA3, 0x02, 0x03, 0x30, 0xAC, 0x85, 0x54, 0x66, 0xCF, 0x22, 0x81, 0x1F,
  0xA3, 0x81, 0x8F, 0x22, 0x81, 0x1F, 0xA3, 0x81, 0x8F, 0x22, 0x81, 0x1E, 0xA3, 0x85, 0x8F, 0x96,
  0x62, 0xBC, 0x06,
  // "ź" (U+017A)
  0x00, 0x01, 0x00, 0x1D, 0xA0, 0x02, 0x30, 0x09, 0xFF, 0xF6, 0x36, 0xBF, 0x30, 0x0E, 0xB0, 0x07,
  0xF3, 0x00, 0xEB, 0x00, 0x7F, 0x96, 0x3B, 0xFF, 0xF8,
  // "Ż" (U+017B)
  0x00, 0x6F, 0x20, 0x00, 0x03, 0x00, 0xAF, 0xFF, 0xF5, 0x46, 0x6C, 0xF2, 0x00, 0x1F, 0xA0, 0x00,
  0x8F, 0x20, 0x01, 0xFA, 0x00, 0x08, 0xF2, 0x00, 0x1E, 0xA0, 0x00, 0x8F, 0x96, 0x62, 0xBF, 0xFF,
  0xF6,
  // "ż" (U+017C)
  0x06, 0xF2, 0x00, 0x03, 0x00, 0x9F, 0xFF, 0x63, 0x6B, 0xF3, 0x00, 0xEB, 0x00, 0x7F, 0x30, 0x0E,
  0xB0, 0x07, 0xF9, 0x63, 0xBF, 0xFF, 0x80,
  // "Ž" (U+017D)
  0x83, 0x4D, 0x3D, 0x52, 0x81, 0x8F, 0xA7, 0x10, 0xAC, 0x85, 0x54, 0x66, 0xCF, 0x22, 0x81, 0x1F,
  0xA3, 0x81, 0x8F, 0x22, 0x81, 0x1F, 0xA3, 0x81, 0x8F, 0x22, 0x81, 0x1E, 0xA3, 0x85, 0x8F, 0x96,
  0x62, 0xBC, 0x06,
  // "ž" (U+017E)
  0x4D, 0x3D, 0x50, 0x8F, 0xA0, 0x00, 0x00, 0x09, 0xFF, 0xF6, 0x36, 0xBF, 0x30, 0x0E, 0xB0, 0x07,
  0xF3, 0x00, 0xEB, 0x00, 0x7F, 0x96, 0x3B, 0xFF, 0xF8,
  // "ſ" (U+017F)
  0x07, 0xED, 0x0F, 0xC7, 0x2F, 0x70, 0x2F, 0x70, 0x2F, 0x70, 0x2F, 0x70, 0x2F, 0x70, 0x2F, 0x70,
  0x2F, 0x70, 0x2F, 0x70,
  // "Ω" (U+03A9)
  0x01, 0xAE, 0xD9, 0x00, 0x0C, 0xF8, 0x9F, 0x90, 0x3F, 0x80, 0x0B, 0xF1, 0x6F, 0x50, 0x07, 0xF3,
  0x5F, 0x40, 0x07, 0xF3, 0x3F, 0x60, 0x08, 0xF0, 0x0C, 0xB0, 0x0D, 0x90, 0x48, 0xF5, 0x8F, 0x73,
  0xBF, 0xF6, 0x9F, 0xF8,
  // "μ" (U+03BC)
  0x3F, 0x50, 0xCC, 0x3F, 0x50, 0xCC, 0x3F, 0x50, 0xCC, 0x3F, 0x50, 0xCC, 0x3F, 0x60, 0xEC, 0x3F,
  0xC9, 0xFC, 0x3F, 0xDD, 0x9C, 0x3F, 0x50, 0x00, 0x3F, 0x50, 0x00, 0x3F, 0x50, 0x00,
  // "π" (U+03C0)
  0x9F, 0xFF, 0xFF, 0xF1, 0x5D, 0xD6, 0xCF, 0x60, 0x0C, 0xC0, 0xAF, 0x00, 0x0C, 0xC0, 0xAF, 0x00,
  0x0C, 0xC0, 0xAF, 0x00, 0x0C, 0xC0, 0x9F, 0x80, 0x0C, 0xC0, 0x3E, 0xD0,
  // "–" (U+2013)
  0x80, 0x21, 0x09, 0xC8, 0x59, 0x24, 0x44, 0x42,
  // "—" (U+2014)
  0x80, 0x90, 0x10, 0x9F, 0xB0, 0x90, 0x28, 0x06, 0x40, 0x20,
  // "€" (U+20AC)
  0x00, 0x9E, 0xE7, 0x07, 0xF9, 0x85, 0x0D, 0xC0, 0x00, 0xBF, 0xFE, 0x70, 0x2F, 0x91, 0x00, 0xBF,
  0xFE, 0x30, 0x1D, 0xC1, 0x00, 0x07, 0xF8, 0x76, 0x00, 0x9E, 0xE6,
  // "₿" (U+20BF)
  0x01, 0xAA, 0x10, 0x2F, 0xFF, 0x90, 0x2F, 0xAA, 0xF5, 0x2F, 0x72, 0xF7, 0x2F, 0x87, 0xF4, 0x2F,
  0xFF, 0xC0, 0x2F, 0x97, 0xF6, 0x2F, 0x70, 0xF9, 0x2F, 0xA9, 0xF7, 0x2F, 0xFF, 0xA0, 0x01, 0xAA,
  0x10, 0x00, 0x22, 0x00,
  // "‘" (U+2018)
  0x0E, 0x65, 0xF3, 0x8F, 0x00,
  // "’" (U+2019)
  0x3F, 0x56, 0xF1, 0x9B, 0x00,
  // "‚" (U+201A)
  0x3F, 0x56, 0xF1, 0x9B, 0x00,
  // "‛" (U+201B)
  0x8F, 0x05, 0xF3, 0x0E, 0x60,
  // "“" (U+201C)
  0x0E, 0x66, 0xE5, 0xF3, 0xCB, 0x8F, 0x1F, 0x90,
  // "”" (U+201D)
  0x3F, 0x5B, 0xE6, 0xF1, 0xDA, 0x9B, 0x1F, 0x40,
  // "„" (U+201E)
  0x3F, 0x5B, 0xE6, 0xF1, 0xDA, 0x9B, 0x1F, 0x40,
  // "‟" (U+201F)
  0x8F, 0x1F, 0x95, 0xF3, 0xBB, 0x0E, 0x66, 0xE0,
  // "†" (U+2020)
  0x20, 0xC0, 0xA4, 0x0B, 0x08, 0x28, 0x92, 0x25, 0xB9, 0x51, 0x5E, 0xEE, 0xE4, 0x20, 0x90, 0x74,
  0x0A, 0x08, 0x40, 0xB0, 0x84, 0x0B, 0x09, 0x40, 0xC0, 0xA4, 0x0D, 0x0B, 0x20,
  // "‡" (U+2021)
  0x00, 0xBB, 0x00, 0x00, 0x99, 0x00, 0x4A, 0xCC, 0xA3, 0x4A, 0xCC, 0xA3, 0x00, 0xA9, 0x00, 0x00,
  0xA9, 0x00, 0x4A, 0xCC, 0xA3, 0x4A, 0xCC, 0xA3, 0x00, 0x99, 0x00, 0x00, 0xBB, 0x00,
  // "•" (U+2022)
  0x0B, 0xE7, 0x5F, 0xFE, 0x5F, 0xFE, 0x0B, 0xE6,
  // "…" (U+2026)
  0x2F, 0x52, 0xF5, 0x2F, 0x52, 0xE5, 0x2E, 0x52, 0xE5,
  // "‰" (U+2030)
  0x86, 0x1C, 0xE4, 0x01, 0xF2, 0x68, 0x57, 0xEB, 0xC0, 0x8B, 0x78, 0x59, 0xA5, 0xE0, 0xE4, 0x78,
  0x95, 0x8C, 0x8D, 0x5D, 0x9F, 0xA0, 0x7F, 0xB0, 0x2A, 0x8A, 0x77, 0xC8, 0xF8, 0xF2, 0xE9, 0xF4,
  0x01, 0x33, 0xF4, 0xF1, 0xF6, 0xF2, 0xD6, 0x38, 0x91, 0x99, 0x3F, 0x1F, 0x6F, 0x2D, 0x63, 0x89,
  0x1E, 0x30, 0xFA, 0xF2, 0xDA, 0xF3, 0x20, 0x60, 0xC2, 0x85, 0x7E, 0x80, 0x5E, 0xA1,
  // "‹" (U+2039)
  0x01, 0xC2, 0x0C, 0xD0, 0x7F, 0x40, 0x2E, 0x90, 0x05, 0xF3, 0x00, 0x30,
  // "›" (U+203A)
  0x4C, 0x00, 0x1E, 0xA0, 0x06, 0xF5, 0x0B, 0xD1, 0x5F, 0x30, 0x03, 0x00,
  // "⁄" (U+2044)
  0x38, 0x11, 0xE3, 0x30, 0x80, 0xB3, 0x81, 0x1E, 0x43, 0x08, 0x0C, 0x38, 0x11, 0xE4, 0x30, 0x70,
  0xC4, 0x0E, 0x04, 0x30, 0x70, 0xC4, 0x0E, 0x05, 0x40,
  // "™" (U+2122)
  0x11, 0x10, 0x00, 0x01, 0xDF, 0xF9, 0xE0, 0x8D, 0x3E, 0x58, 0xF2, 0xCD, 0x0D, 0x18, 0xB8, 0xBD,
  0x0D, 0x18, 0x6E, 0x6D, 0x0A, 0x06, 0x49, 0x19,
  // "⅒" (U+2152)
  0x58, 0x11, 0xE3, 0x68, 0x47, 0xF1, 0x08, 0xB6, 0x85, 0x4B, 0xF1, 0x1E, 0x47, 0x83, 0x1F, 0x18,
  0xC7, 0x18, 0xA7, 0x1F, 0x3E, 0x47, 0xF1, 0x2C, 0xD3, 0x01, 0xF9, 0xC4, 0xBF, 0x19, 0xA8, 0xB3,
  0x89, 0x0E, 0x40, 0x1F, 0x1B, 0x75, 0xE2, 0x07, 0x0C, 0x28, 0x51, 0xF1, 0x99, 0x7C, 0x20, 0xE0,
  0x52, 0x85, 0x1F, 0x13, 0xEF, 0x50,
  // "ﬁ" (U+FB01)
  0x05, 0xEE, 0x4E, 0x40, 0xDD, 0x70, 0x51, 0x0F, 0x90, 0x00, 0x0A, 0xFF, 0xC3, 0xF6, 0x6F, 0xB5,
  0x3F, 0x60, 0xF9, 0x03, 0xF6, 0x0F, 0x90, 0x3F, 0x60, 0xF9, 0x03, 0xF6, 0x0F, 0x90, 0x3F, 0x60,
  0xF9, 0x03, 0xF6,
  // "ﬂ" (U+FB02)
  0x05, 0xEE, 0x5F, 0x50, 0xDD, 0x73, 0xF5, 0x0F, 0x90, 0x3F, 0x5A, 0xFF, 0xC3, 0xF5, 0x6F, 0xB5,
  0x3F, 0x50, 0xF9, 0x03, 0xF5, 0x0F, 0x90, 0x3F, 0x50, 0xF9, 0x03, 0xF5, 0x0F, 0x90, 0x3F, 0x50,
  0xF9, 0x03, 0xF5,
};

const Font& font_NotoSans_CondensedBold_12() {
  static SmoothFont font(font_NotoSans_CondensedBold_12_data);
  return font;
}

}  // namespace roo_display
