#include "10.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSans-CondensedBold (Noto Sans Condensed Bold)
// Generated on Wed Nov 19 19:11:20 CET 2025
static const uint8_t font_NotoSans_CondensedBold_10_data[] PROGMEM = {
  
  // Header
  0x01, 0x02, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x01, 0x81,
  0xFE, 0xFE, 0x0B, 0x0B, 0x08, 0xFD, 0x03, 0x01, 0x0C, 0x04, 0x03, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x40, 0x01, 0x02, 0x08, 0x03, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x40, 0x06, 0x03, 0x08, 0x05, 0x00, 0x0C, // """ (U+0022)
  0x00, 0x23, 0x40, 0x01, 0x05, 0x08, 0x06, 0x00, 0x12, // "#" (U+0023)
  0x00, 0x24, 0x40, 0x00, 0x04, 0x08, 0x05, 0x00, 0x2A, // "$" (U+0024)
  0x00, 0x25, 0x40, 0x01, 0x07, 0x08, 0x08, 0x00, 0x41, // "%" (U+0025)
  0x00, 0x26, 0x40, 0x01, 0x06, 0x08, 0x06, 0x00, 0x61, // "&" (U+0026)
  0x00, 0x27, 0x40, 0x06, 0x01, 0x08, 0x02, 0x00, 0x7D, // "'" (U+0027)
  0x00, 0x28, 0x40, 0x00, 0x02, 0x08, 0x03, 0x00, 0x80, // "(" (U+0028)
  0x00, 0x29, 0x40, 0x00, 0x02, 0x08, 0x03, 0x00, 0x8E, // ")" (U+0029)
  0x00, 0x2A, 0x40, 0x04, 0x04, 0x08, 0x05, 0x00, 0x9C, // "*" (U+002A)
  0x00, 0x2B, 0x00, 0x02, 0x04, 0x06, 0x05, 0x00, 0xA9, // "+" (U+002B)
  0x00, 0x2C, 0x40, 0x00, 0x01, 0x02, 0x03, 0x00, 0xB3, // "," (U+002C)
  0x00, 0x2D, 0x40, 0x02, 0x02, 0x03, 0x03, 0x00, 0xB6, // "-" (U+002D)
  0x00, 0x2E, 0x40, 0x01, 0x01, 0x02, 0x03, 0x00, 0xB9, // "." (U+002E)
  0x00, 0x2F, 0x40, 0x01, 0x03, 0x08, 0x04, 0x00, 0xBB, // "/" (U+002F)
  0x00, 0x30, 0x40, 0x01, 0x04, 0x08, 0x05, 0x00, 0xCB, // "0" (U+0030)
  0x00, 0x31, 0x40, 0x01, 0x03, 0x08, 0x05, 0x00, 0xDF, // "1" (U+0031)
  0x00, 0x32, 0x40, 0x01, 0x04, 0x08, 0x05, 0x00, 0xEF, // "2" (U+0032)
  0x00, 0x33, 0x40, 0x01, 0x04, 0x08, 0x05, 0x01, 0x03, // "3" (U+0033)
  0x00, 0x34, 0x40, 0x01, 0x04, 0x08, 0x05, 0x01, 0x17, // "4" (U+0034)
  0x00, 0x35, 0x40, 0x01, 0x04, 0x08, 0x05, 0x01, 0x2B, // "5" (U+0035)
  0x00, 0x36, 0x40, 0x01, 0x04, 0x08, 0x05, 0x01, 0x3F, // "6" (U+0036)
  0x00, 0x37, 0x40, 0x01, 0x04, 0x08, 0x05, 0x01, 0x53, // "7" (U+0037)
  0x00, 0x38, 0x40, 0x01, 0x04, 0x08, 0x05, 0x01, 0x67, // "8" (U+0038)
  0x00, 0x39, 0x40, 0x01, 0x04, 0x08, 0x05, 0x01, 0x7B, // "9" (U+0039)
  0x00, 0x3A, 0x40, 0x01, 0x01, 0x06, 0x03, 0x01, 0x8F, // ":" (U+003A)
  0x00, 0x3B, 0x40, 0x00, 0x01, 0x06, 0x03, 0x01, 0x95, // ";" (U+003B)
  0x00, 0x3C, 0x40, 0x02, 0x04, 0x06, 0x05, 0x01, 0x9C, // "<" (U+003C)
  0x00, 0x3D, 0x40, 0x02, 0x04, 0x05, 0x05, 0x01, 0xA9, // "=" (U+003D)
  0x00, 0x3E, 0x40, 0x02, 0x04, 0x06, 0x05, 0x01, 0xB3, // ">" (U+003E)
  0x00, 0x3F, 0x40, 0x01, 0x03, 0x08, 0x04, 0x01, 0xC0, // "?" (U+003F)
  0x00, 0x40, 0x40, 0xFF, 0x07, 0x08, 0x08, 0x01, 0xD0, // "@" (U+0040)
  0x00, 0x41, 0x40, 0x01, 0x05, 0x08, 0x06, 0x01, 0xF8, // "A" (U+0041)
  0x00, 0x42, 0x40, 0x01, 0x05, 0x08, 0x06, 0x02, 0x10, // "B" (U+0042)
  0x00, 0x43, 0x40, 0x01, 0x04, 0x08, 0x05, 0x02, 0x28, // "C" (U+0043)
  0x00, 0x44, 0x40, 0x01, 0x05, 0x08, 0x06, 0x02, 0x3C, // "D" (U+0044)
  0x00, 0x45, 0x40, 0x01, 0x04, 0x08, 0x05, 0x02, 0x54, // "E" (U+0045)
  0x00, 0x46, 0x40, 0x01, 0x04, 0x08, 0x05, 0x02, 0x68, // "F" (U+0046)
  0x00, 0x47, 0x40, 0x01, 0x05, 0x08, 0x06, 0x02, 0x7C, // "G" (U+0047)
  0x00, 0x48, 0x40, 0x01, 0x05, 0x08, 0x06, 0x02, 0x94, // "H" (U+0048)
  0x00, 0x49, 0x40, 0x01, 0x03, 0x08, 0x03, 0x02, 0xAC, // "I" (U+0049)
  0x00, 0x4A, 0xBF, 0xFE, 0x02, 0x08, 0x03, 0x02, 0xBC, // "J" (U+004A)
  0x00, 0x4B, 0x40, 0x01, 0x05, 0x08, 0x06, 0x02, 0xD2, // "K" (U+004B)
  0x00, 0x4C, 0x40, 0x01, 0x04, 0x08, 0x05, 0x02, 0xEA, // "L" (U+004C)
  0x00, 0x4D, 0x40, 0x01, 0x07, 0x08, 0x08, 0x02, 0xFE, // "M" (U+004D)
  0x00, 0x4E, 0x40, 0x01, 0x06, 0x08, 0x07, 0x03, 0x1E, // "N" (U+004E)
  0x00, 0x4F, 0x40, 0x01, 0x05, 0x08, 0x07, 0x03, 0x3A, // "O" (U+004F)
  0x00, 0x50, 0x40, 0x01, 0x04, 0x08, 0x05, 0x03, 0x52, // "P" (U+0050)
  0x00, 0x51, 0x40, 0xFF, 0x05, 0x08, 0x07, 0x03, 0x66, // "Q" (U+0051)
  0x00, 0x52, 0x40, 0x01, 0x05, 0x08, 0x06, 0x03, 0x84, // "R" (U+0052)
  0x00, 0x53, 0x40, 0x01, 0x04, 0x08, 0x05, 0x03, 0x9C, // "S" (U+0053)
  0x00, 0x54, 0x40, 0x01, 0x04, 0x08, 0x05, 0x03, 0xB0, // "T" (U+0054)
  0x00, 0x55, 0x40, 0x01, 0x05, 0x08, 0x06, 0x03, 0xC4, // "U" (U+0055)
  0x00, 0x56, 0x40, 0x01, 0x05, 0x08, 0x06, 0x03, 0xDC, // "V" (U+0056)
  0x00, 0x57, 0x40, 0x01, 0x08, 0x08, 0x08, 0x03, 0xF4, // "W" (U+0057)
  0x00, 0x58, 0x40, 0x01, 0x05, 0x08, 0x05, 0x04, 0x18, // "X" (U+0058)
  0x00, 0x59, 0x40, 0x01, 0x04, 0x08, 0x05, 0x04, 0x30, // "Y" (U+0059)
  0x00, 0x5A, 0x40, 0x01, 0x04, 0x08, 0x05, 0x04, 0x44, // "Z" (U+005A)
  0x00, 0x5B, 0x40, 0xFF, 0x02, 0x08, 0x03, 0x04, 0x58, // "[" (U+005B)
  0x00, 0x5C, 0x40, 0x01, 0x03, 0x08, 0x04, 0x04, 0x67, // "\" (U+005C)
  0x00, 0x5D, 0x40, 0xFF, 0x02, 0x08, 0x03, 0x04, 0x77, // "]" (U+005D)
  0x00, 0x5E, 0x40, 0x04, 0x04, 0x08, 0x05, 0x04, 0x86, // "^" (U+005E)
  0x00, 0x5F, 0x40, 0xFE, 0x04, 0xFF, 0x05, 0x04, 0x93, // "_" (U+005F)
  0x00, 0x60, 0x40, 0x08, 0x02, 0x09, 0x03, 0x04, 0x98, // "`" (U+0060)
  0x00, 0x61, 0x40, 0x01, 0x04, 0x06, 0x05, 0x04, 0x9B, // "a" (U+0061)
  0x00, 0x62, 0x40, 0x01, 0x04, 0x08, 0x05, 0x04, 0xAA, // "b" (U+0062)
  0x00, 0x63, 0x40, 0x01, 0x03, 0x06, 0x04, 0x04, 0xBE, // "c" (U+0063)
  0x00, 0x64, 0x40, 0x01, 0x04, 0x08, 0x05, 0x04, 0xCA, // "d" (U+0064)
  0x00, 0x65, 0x40, 0x01, 0x04, 0x06, 0x05, 0x04, 0xDE, // "e" (U+0065)
  0x00, 0x66, 0x40, 0x01, 0x03, 0x08, 0x03, 0x04, 0xED, // "f" (U+0066)
  0x00, 0x67, 0x40, 0xFE, 0x04, 0x06, 0x05, 0x04, 0xFD, // "g" (U+0067)
  0x00, 0x68, 0x40, 0x01, 0x04, 0x08, 0x05, 0x05, 0x14, // "h" (U+0068)
  0x00, 0x69, 0x40, 0x01, 0x01, 0x08, 0x03, 0x05, 0x28, // "i" (U+0069)
  0x00, 0x6A, 0xBF, 0xFE, 0x01, 0x08, 0x03, 0x05, 0x30, // "j" (U+006A)
  0x00, 0x6B, 0x40, 0x01, 0x04, 0x08, 0x05, 0x05, 0x41, // "k" (U+006B)
  0x00, 0x6C, 0x40, 0x01, 0x01, 0x08, 0x03, 0x05, 0x55, // "l" (U+006C)
  0x00, 0x6D, 0x40, 0x01, 0x07, 0x06, 0x08, 0x05, 0x5D, // "m" (U+006D)
  0x00, 0x6E, 0x40, 0x01, 0x04, 0x06, 0x05, 0x05, 0x75, // "n" (U+006E)
  0x00, 0x6F, 0x40, 0x01, 0x04, 0x06, 0x05, 0x05, 0x84, // "o" (U+006F)
  0x00, 0x70, 0x00, 0xFE, 0x04, 0x06, 0x05, 0x05, 0x93, // "p" (U+0070)
  0x00, 0x71, 0x40, 0xFE, 0x04, 0x06, 0x05, 0x05, 0xA9, // "q" (U+0071)
  0x00, 0x72, 0x40, 0x01, 0x03, 0x06, 0x04, 0x05, 0xC0, // "r" (U+0072)
  0x00, 0x73, 0x40, 0x01, 0x03, 0x06, 0x04, 0x05, 0xCC, // "s" (U+0073)
  0x00, 0x74, 0x40, 0x01, 0x03, 0x07, 0x04, 0x05, 0xD8, // "t" (U+0074)
  0x00, 0x75, 0x40, 0x01, 0x04, 0x06, 0x05, 0x05, 0xE6, // "u" (U+0075)
  0x00, 0x76, 0x40, 0x01, 0x04, 0x06, 0x05, 0x05, 0xF5, // "v" (U+0076)
  0x00, 0x77, 0x40, 0x01, 0x07, 0x06, 0x07, 0x06, 0x04, // "w" (U+0077)
  0x00, 0x78, 0x40, 0x01, 0x04, 0x06, 0x05, 0x06, 0x1C, // "x" (U+0078)
  0x00, 0x79, 0x40, 0xFE, 0x04, 0x06, 0x05, 0x06, 0x2B, // "y" (U+0079)
  0x00, 0x7A, 0x40, 0x01, 0x03, 0x06, 0x04, 0x06, 0x42, // "z" (U+007A)
  0x00, 0x7B, 0x40, 0xFF, 0x03, 0x08, 0x04, 0x06, 0x4E, // "{" (U+007B)
  0x00, 0x7C, 0x41, 0xFE, 0x02, 0x08, 0x05, 0x06, 0x62, // "|" (U+007C)
  0x00, 0x7D, 0x40, 0xFF, 0x03, 0x08, 0x04, 0x06, 0x6D, // "}" (U+007D)
  0x00, 0x7E, 0x40, 0x03, 0x04, 0x05, 0x05, 0x06, 0x81, // "~" (U+007E)
  0x00, 0xA1, 0x40, 0x00, 0x02, 0x06, 0x03, 0x06, 0x89, // "¡" (U+00A1)
  0x00, 0xA2, 0x40, 0x01, 0x04, 0x08, 0x05, 0x06, 0x94, // "¢" (U+00A2)
  0x00, 0xA3, 0x40, 0x01, 0x04, 0x08, 0x05, 0x06, 0xA8, // "£" (U+00A3)
  0x00, 0xA4, 0x40, 0x02, 0x04, 0x07, 0x06, 0x06, 0xBC, // "¤" (U+00A4)
  0x00, 0xA5, 0x40, 0x01, 0x04, 0x08, 0x05, 0x06, 0xCB, // "¥" (U+00A5)
  0x00, 0xA6, 0x41, 0xFE, 0x02, 0x08, 0x05, 0x06, 0xDF, // "¦" (U+00A6)
  0x00, 0xA7, 0x40, 0x01, 0x03, 0x08, 0x04, 0x06, 0xEA, // "§" (U+00A7)
  0x00, 0xA8, 0x41, 0x07, 0x04, 0x08, 0x05, 0x06, 0xFA, // "¨" (U+00A8)
  0x00, 0xA9, 0x40, 0x00, 0x07, 0x08, 0x08, 0x06, 0xFE, // "©" (U+00A9)
  0x00, 0xAA, 0x40, 0x05, 0x02, 0x08, 0x03, 0x07, 0x22, // "ª" (U+00AA)
  0x00, 0xAB, 0x40, 0x01, 0x04, 0x05, 0x05, 0x07, 0x28, // "«" (U+00AB)
  0x00, 0xAC, 0x40, 0x01, 0x04, 0x04, 0x05, 0x07, 0x35, // "¬" (U+00AC)
  0x00, 0xAE, 0x40, 0x00, 0x07, 0x08, 0x08, 0x07, 0x3F, // "®" (U+00AE)
  0x00, 0xAF, 0x00, 0x08, 0x04, 0x09, 0x05, 0x07, 0x63, // "¯" (U+00AF)
  0x00, 0xB0, 0x40, 0x05, 0x03, 0x08, 0x04, 0x07, 0x67, // "°" (U+00B0)
  0x00, 0xB1, 0x00, 0x01, 0x04, 0x07, 0x05, 0x07, 0x6F, // "±" (U+00B1)
  0x00, 0xB2, 0x40, 0x05, 0x03, 0x09, 0x03, 0x07, 0x7E, // "²" (U+00B2)
  0x00, 0xB3, 0x40, 0x05, 0x02, 0x09, 0x03, 0x07, 0x88, // "³" (U+00B3)
  0x00, 0xB4, 0x40, 0x07, 0x02, 0x08, 0x03, 0x07, 0x90, // "´" (U+00B4)
  0x00, 0xB5, 0x00, 0xFE, 0x04, 0x06, 0x05, 0x07, 0x93, // "µ" (U+00B5)
  0x00, 0xB6, 0x40, 0xFF, 0x04, 0x08, 0x05, 0x07, 0xA9, // "¶" (U+00B6)
  0x00, 0xB7, 0x40, 0x04, 0x01, 0x05, 0x03, 0x07, 0xC2, // "·" (U+00B7)
  0x00, 0xB8, 0xBF, 0xFE, 0x01, 0x00, 0x02, 0x07, 0xC4, // "¸" (U+00B8)
  0x00, 0xB9, 0x40, 0x05, 0x02, 0x08, 0x03, 0x07, 0xC9, // "¹" (U+00B9)
  0x00, 0xBA, 0x40, 0x05, 0x03, 0x08, 0x03, 0x07, 0xCF, // "º" (U+00BA)
  0x00, 0xBB, 0x40, 0x01, 0x05, 0x05, 0x05, 0x07, 0xD7, // "»" (U+00BB)
  0x00, 0xBC, 0x40, 0x01, 0x07, 0x08, 0x08, 0x07, 0xE6, // "¼" (U+00BC)
  0x00, 0xBD, 0x40, 0x00, 0x07, 0x08, 0x08, 0x08, 0x06, // "½" (U+00BD)
  0x00, 0xBE, 0x40, 0x01, 0x07, 0x08, 0x08, 0x08, 0x2A, // "¾" (U+00BE)
  0x00, 0xBF, 0x40, 0xFE, 0x03, 0x05, 0x04, 0x08, 0x4A, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x08, 0x5A, // "À" (U+00C0)
  0x00, 0xC1, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x08, 0x7A, // "Á" (U+00C1)
  0x00, 0xC2, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x08, 0x98, // "Â" (U+00C2)
  0x00, 0xC3, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x08, 0xB9, // "Ã" (U+00C3)
  0x00, 0xC4, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x08, 0xDA, // "Ä" (U+00C4)
  0x00, 0xC5, 0x40, 0x01, 0x05, 0x09, 0x06, 0x08, 0xF8, // "Å" (U+00C5)
  0x00, 0xC6, 0x40, 0x01, 0x07, 0x08, 0x08, 0x09, 0x13, // "Æ" (U+00C6)
  0x00, 0xC7, 0x40, 0xFE, 0x04, 0x08, 0x05, 0x09, 0x33, // "Ç" (U+00C7)
  0x00, 0xC8, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x09, 0x4F, // "È" (U+00C8)
  0x00, 0xC9, 0x40, 0x01, 0x04, 0x0A, 0x05, 0x09, 0x69, // "É" (U+00C9)
  0x00, 0xCA, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x09, 0x82, // "Ê" (U+00CA)
  0x00, 0xCB, 0x40, 0x01, 0x04, 0x0A, 0x05, 0x09, 0x9D, // "Ë" (U+00CB)
  0x00, 0xCC, 0x40, 0x01, 0x03, 0x0B, 0x03, 0x09, 0xB6, // "Ì" (U+00CC)
  0x00, 0xCD, 0x40, 0x01, 0x03, 0x0A, 0x03, 0x09, 0xCC, // "Í" (U+00CD)
  0x00, 0xCE, 0x40, 0x01, 0x03, 0x0B, 0x03, 0x09, 0xE0, // "Î" (U+00CE)
  0x00, 0xCF, 0x40, 0x01, 0x03, 0x0A, 0x03, 0x09, 0xF6, // "Ï" (U+00CF)
  0x00, 0xD0, 0x40, 0x01, 0x05, 0x08, 0x06, 0x0A, 0x0A, // "Ð" (U+00D0)
  0x00, 0xD1, 0x40, 0x01, 0x06, 0x0B, 0x07, 0x0A, 0x22, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x40, 0x01, 0x05, 0x0B, 0x07, 0x0A, 0x49, // "Ò" (U+00D2)
  0x00, 0xD3, 0x40, 0x01, 0x05, 0x0A, 0x07, 0x0A, 0x6A, // "Ó" (U+00D3)
  0x00, 0xD4, 0x40, 0x01, 0x05, 0x0B, 0x07, 0x0A, 0x88, // "Ô" (U+00D4)
  0x00, 0xD5, 0x40, 0x01, 0x05, 0x0B, 0x07, 0x0A, 0xA9, // "Õ" (U+00D5)
  0x00, 0xD6, 0x40, 0x01, 0x05, 0x0A, 0x07, 0x0A, 0xCA, // "Ö" (U+00D6)
  0x00, 0xD7, 0x40, 0x02, 0x04, 0x06, 0x05, 0x0A, 0xE8, // "×" (U+00D7)
  0x00, 0xD8, 0x00, 0x00, 0x05, 0x09, 0x07, 0x0A, 0xF5, // "Ø" (U+00D8)
  0x00, 0xD9, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x0B, 0x11, // "Ù" (U+00D9)
  0x00, 0xDA, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x0B, 0x31, // "Ú" (U+00DA)
  0x00, 0xDB, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x0B, 0x4F, // "Û" (U+00DB)
  0x00, 0xDC, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x0B, 0x6F, // "Ü" (U+00DC)
  0x00, 0xDD, 0x40, 0x01, 0x04, 0x0A, 0x05, 0x0B, 0x8D, // "Ý" (U+00DD)
  0x00, 0xDE, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0B, 0xA6, // "Þ" (U+00DE)
  0x00, 0xDF, 0x40, 0x01, 0x05, 0x08, 0x06, 0x0B, 0xBA, // "ß" (U+00DF)
  0x00, 0xE0, 0x40, 0x01, 0x04, 0x09, 0x05, 0x0B, 0xD2, // "à" (U+00E0)
  0x00, 0xE1, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0B, 0xE9, // "á" (U+00E1)
  0x00, 0xE2, 0x40, 0x01, 0x04, 0x09, 0x05, 0x0B, 0xFD, // "â" (U+00E2)
  0x00, 0xE3, 0x40, 0x01, 0x04, 0x09, 0x05, 0x0C, 0x14, // "ã" (U+00E3)
  0x00, 0xE4, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0C, 0x2B, // "ä" (U+00E4)
  0x00, 0xE5, 0x40, 0x01, 0x04, 0x09, 0x05, 0x0C, 0x3F, // "å" (U+00E5)
  0x00, 0xE6, 0x40, 0x01, 0x07, 0x06, 0x08, 0x0C, 0x56, // "æ" (U+00E6)
  0x00, 0xE7, 0x40, 0xFE, 0x03, 0x06, 0x04, 0x0C, 0x6E, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0C, 0x80, // "è" (U+00E8)
  0x00, 0xE9, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0C, 0x96, // "é" (U+00E9)
  0x00, 0xEA, 0x40, 0x01, 0x04, 0x09, 0x05, 0x0C, 0xAA, // "ê" (U+00EA)
  0x00, 0xEB, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0C, 0xC1, // "ë" (U+00EB)
  0x00, 0xEC, 0xBF, 0x01, 0x01, 0x09, 0x03, 0x0C, 0xD5, // "ì" (U+00EC)
  0x00, 0xED, 0x40, 0x01, 0x02, 0x08, 0x03, 0x0C, 0xE3, // "í" (U+00ED)
  0x00, 0xEE, 0xBF, 0x01, 0x02, 0x09, 0x03, 0x0C, 0xEF, // "î" (U+00EE)
  0x00, 0xEF, 0x40, 0x01, 0x03, 0x08, 0x03, 0x0D, 0x01, // "ï" (U+00EF)
  0x00, 0xF0, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0D, 0x11, // "ð" (U+00F0)
  0x00, 0xF1, 0x40, 0x01, 0x04, 0x09, 0x05, 0x0D, 0x25, // "ñ" (U+00F1)
  0x00, 0xF2, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0D, 0x3C, // "ò" (U+00F2)
  0x00, 0xF3, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0D, 0x52, // "ó" (U+00F3)
  0x00, 0xF4, 0x40, 0x01, 0x04, 0x09, 0x05, 0x0D, 0x66, // "ô" (U+00F4)
  0x00, 0xF5, 0x40, 0x01, 0x04, 0x09, 0x05, 0x0D, 0x7D, // "õ" (U+00F5)
  0x00, 0xF6, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0D, 0x94, // "ö" (U+00F6)
  0x00, 0xF7, 0x40, 0x01, 0x04, 0x06, 0x05, 0x0D, 0xA8, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x00, 0x04, 0x07, 0x05, 0x0D, 0xB7, // "ø" (U+00F8)
  0x00, 0xF9, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0D, 0xCA, // "ù" (U+00F9)
  0x00, 0xFA, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0D, 0xE0, // "ú" (U+00FA)
  0x00, 0xFB, 0x40, 0x01, 0x04, 0x09, 0x05, 0x0D, 0xF4, // "û" (U+00FB)
  0x00, 0xFC, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0E, 0x0B, // "ü" (U+00FC)
  0x00, 0xFD, 0x40, 0xFE, 0x04, 0x08, 0x05, 0x0E, 0x1F, // "ý" (U+00FD)
  0x00, 0xFE, 0x00, 0xFE, 0x04, 0x08, 0x05, 0x0E, 0x3B, // "þ" (U+00FE)
  0x00, 0xFF, 0x40, 0xFE, 0x04, 0x08, 0x05, 0x0E, 0x55, // "ÿ" (U+00FF)
  0x01, 0x00, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x0E, 0x71, // "Ā" (U+0100)
  0x01, 0x01, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0E, 0x8F, // "ā" (U+0101)
  0x01, 0x02, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x0E, 0xA3, // "Ă" (U+0102)
  0x01, 0x03, 0x40, 0x01, 0x04, 0x09, 0x05, 0x0E, 0xC4, // "ă" (U+0103)
  0x01, 0x04, 0x40, 0xFE, 0x05, 0x08, 0x06, 0x0E, 0xDB, // "Ą" (U+0104)
  0x01, 0x05, 0x40, 0xFE, 0x04, 0x06, 0x05, 0x0E, 0xFC, // "ą" (U+0105)
  0x01, 0x06, 0x40, 0x01, 0x04, 0x0A, 0x05, 0x0F, 0x13, // "Ć" (U+0106)
  0x01, 0x07, 0x40, 0x01, 0x03, 0x08, 0x04, 0x0F, 0x2C, // "ć" (U+0107)
  0x01, 0x08, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x0F, 0x3C, // "Ĉ" (U+0108)
  0x01, 0x09, 0x40, 0x01, 0x03, 0x09, 0x04, 0x0F, 0x57, // "ĉ" (U+0109)
  0x01, 0x0A, 0x40, 0x01, 0x04, 0x0A, 0x05, 0x0F, 0x69, // "Ċ" (U+010A)
  0x01, 0x0B, 0x40, 0x01, 0x03, 0x08, 0x04, 0x0F, 0x82, // "ċ" (U+010B)
  0x01, 0x0C, 0x40, 0x01, 0x04, 0x0B, 0x05, 0x0F, 0x92, // "Č" (U+010C)
  0x01, 0x0D, 0x40, 0x01, 0x03, 0x09, 0x04, 0x0F, 0xAE, // "č" (U+010D)
  0x01, 0x0E, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x0F, 0xC0, // "Ď" (U+010E)
  0x01, 0x0F, 0x40, 0x01, 0x06, 0x08, 0x05, 0x0F, 0xE1, // "ď" (U+010F)
  0x01, 0x10, 0x40, 0x01, 0x05, 0x08, 0x06, 0x0F, 0xFD, // "Đ" (U+0110)
  0x01, 0x11, 0x40, 0x01, 0x05, 0x08, 0x05, 0x10, 0x15, // "đ" (U+0111)
  0x01, 0x12, 0x40, 0x01, 0x04, 0x0A, 0x05, 0x10, 0x2D, // "Ē" (U+0112)
  0x01, 0x13, 0x40, 0x01, 0x04, 0x08, 0x05, 0x10, 0x46, // "ē" (U+0113)
  0x01, 0x14, 0x40, 0x01, 0x04, 0x0B, 0x05, 0x10, 0x5A, // "Ĕ" (U+0114)
  0x01, 0x15, 0x40, 0x01, 0x04, 0x09, 0x05, 0x10, 0x76, // "ĕ" (U+0115)
  0x01, 0x16, 0x40, 0x01, 0x04, 0x0A, 0x05, 0x10, 0x8D, // "Ė" (U+0116)
  0x01, 0x17, 0x40, 0x01, 0x04, 0x08, 0x05, 0x10, 0xA6, // "ė" (U+0117)
  0x01, 0x18, 0x40, 0xFE, 0x04, 0x08, 0x05, 0x10, 0xBA, // "Ę" (U+0118)
  0x01, 0x19, 0x40, 0xFE, 0x04, 0x06, 0x05, 0x10, 0xD6, // "ę" (U+0119)
  0x01, 0x1A, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x10, 0xED, // "Ě" (U+011A)
  0x01, 0x1B, 0x40, 0x01, 0x04, 0x09, 0x05, 0x11, 0x08, // "ě" (U+011B)
  0x01, 0x1C, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x11, 0x1F, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x40, 0xFE, 0x04, 0x09, 0x05, 0x11, 0x3F, // "ĝ" (U+011D)
  0x01, 0x1E, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x11, 0x5D, // "Ğ" (U+011E)
  0x01, 0x1F, 0x40, 0xFE, 0x04, 0x09, 0x05, 0x11, 0x7E, // "ğ" (U+011F)
  0x01, 0x20, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x11, 0x9C, // "Ġ" (U+0120)
  0x01, 0x21, 0x40, 0xFE, 0x04, 0x08, 0x05, 0x11, 0xB9, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x11, 0xD5, // "Ģ" (U+0122)
  0x01, 0x23, 0x40, 0xFE, 0x04, 0x08, 0x05, 0x11, 0xF3, // "ģ" (U+0123)
  0x01, 0x24, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x12, 0x0F, // "Ĥ" (U+0124)
  0x01, 0x25, 0xFF, 0x01, 0x04, 0x0B, 0x05, 0x12, 0x2F, // "ĥ" (U+0125)
  0x01, 0x26, 0x40, 0x01, 0x06, 0x08, 0x06, 0x12, 0x4D, // "Ħ" (U+0126)
  0x01, 0x27, 0x40, 0x01, 0x04, 0x08, 0x05, 0x12, 0x69, // "ħ" (U+0127)
  0x01, 0x28, 0x40, 0x01, 0x03, 0x0B, 0x03, 0x12, 0x7D, // "Ĩ" (U+0128)
  0x01, 0x29, 0xBF, 0x01, 0x02, 0x09, 0x03, 0x12, 0x93, // "ĩ" (U+0129)
  0x01, 0x2A, 0x40, 0x01, 0x03, 0x0A, 0x03, 0x12, 0xA5, // "Ī" (U+012A)
  0x01, 0x2B, 0xBF, 0x01, 0x02, 0x08, 0x03, 0x12, 0xB9, // "ī" (U+012B)
  0x01, 0x2C, 0x40, 0x01, 0x03, 0x0B, 0x03, 0x12, 0xC9, // "Ĭ" (U+012C)
  0x01, 0x2D, 0xBF, 0x01, 0x02, 0x09, 0x03, 0x12, 0xDF, // "ĭ" (U+012D)
  0x01, 0x2E, 0x40, 0xFE, 0x03, 0x08, 0x03, 0x12, 0xF1, // "Į" (U+012E)
  0x01, 0x2F, 0x40, 0xFE, 0x02, 0x08, 0x03, 0x13, 0x07, // "į" (U+012F)
  0x01, 0x30, 0x40, 0x01, 0x03, 0x0A, 0x03, 0x13, 0x18, // "İ" (U+0130)
  0x01, 0x31, 0x40, 0x01, 0x01, 0x06, 0x03, 0x13, 0x2C, // "ı" (U+0131)
  0x01, 0x32, 0x40, 0xFE, 0x05, 0x08, 0x06, 0x13, 0x32, // "Ĳ" (U+0132)
  0x01, 0x33, 0x40, 0xFE, 0x04, 0x08, 0x05, 0x13, 0x53, // "ĳ" (U+0133)
  0x01, 0x34, 0xBF, 0xFE, 0x02, 0x0B, 0x03, 0x13, 0x6F, // "Ĵ" (U+0134)
  0x01, 0x35, 0xBF, 0xFE, 0x02, 0x09, 0x03, 0x13, 0x8B, // "ĵ" (U+0135)
  0x01, 0x36, 0x40, 0xFE, 0x05, 0x08, 0x06, 0x13, 0xA3, // "Ķ" (U+0136)
  0x01, 0x37, 0x00, 0xFE, 0x04, 0x08, 0x05, 0x13, 0xC4, // "ķ" (U+0137)
  0x01, 0x38, 0x40, 0x01, 0x04, 0x06, 0x05, 0x13, 0xDE, // "ĸ" (U+0138)
  0x01, 0x39, 0x40, 0x01, 0x04, 0x0A, 0x05, 0x13, 0xED, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x40, 0x01, 0x02, 0x0A, 0x03, 0x14, 0x06, // "ĺ" (U+013A)
  0x01, 0x3B, 0x40, 0xFE, 0x04, 0x08, 0x05, 0x14, 0x15, // "Ļ" (U+013B)
  0x01, 0x3C, 0x40, 0xFE, 0x01, 0x08, 0x03, 0x14, 0x31, // "ļ" (U+013C)
  0x01, 0x3D, 0x40, 0x01, 0x04, 0x08, 0x05, 0x14, 0x3C, // "Ľ" (U+013D)
  0x01, 0x3E, 0x40, 0x01, 0x03, 0x08, 0x03, 0x14, 0x50, // "ľ" (U+013E)
  0x01, 0x3F, 0x40, 0x01, 0x04, 0x08, 0x05, 0x14, 0x60, // "Ŀ" (U+013F)
  0x01, 0x40, 0x40, 0x01, 0x03, 0x08, 0x03, 0x14, 0x74, // "ŀ" (U+0140)
  0x01, 0x41, 0x40, 0x01, 0x04, 0x08, 0x05, 0x14, 0x84, // "Ł" (U+0141)
  0x01, 0x42, 0x40, 0x01, 0x02, 0x08, 0x03, 0x14, 0x98, // "ł" (U+0142)
  0x01, 0x43, 0x40, 0x01, 0x06, 0x0A, 0x07, 0x14, 0xA4, // "Ń" (U+0143)
  0x01, 0x44, 0x40, 0x01, 0x04, 0x08, 0x05, 0x14, 0xC7, // "ń" (U+0144)
  0x01, 0x45, 0x00, 0xFE, 0x06, 0x08, 0x07, 0x14, 0xDB, // "Ņ" (U+0145)
  0x01, 0x46, 0x00, 0xFE, 0x04, 0x06, 0x05, 0x14, 0xFF, // "ņ" (U+0146)
  0x01, 0x47, 0x40, 0x01, 0x06, 0x0B, 0x07, 0x15, 0x15, // "Ň" (U+0147)
  0x01, 0x48, 0x40, 0x01, 0x04, 0x09, 0x05, 0x15, 0x3C, // "ň" (U+0148)
  0x01, 0x49, 0x40, 0x01, 0x05, 0x08, 0x07, 0x15, 0x53, // "ŉ" (U+0149)
  0x01, 0x4A, 0x40, 0xFE, 0x06, 0x08, 0x07, 0x15, 0x6B, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x40, 0xFE, 0x04, 0x06, 0x05, 0x15, 0x92, // "ŋ" (U+014B)
  0x01, 0x4C, 0x40, 0x01, 0x05, 0x0A, 0x07, 0x15, 0xA9, // "Ō" (U+014C)
  0x01, 0x4D, 0x40, 0x01, 0x04, 0x08, 0x05, 0x15, 0xC7, // "ō" (U+014D)
  0x01, 0x4E, 0x40, 0x01, 0x05, 0x0B, 0x07, 0x15, 0xDB, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x40, 0x01, 0x04, 0x09, 0x05, 0x15, 0xFC, // "ŏ" (U+014F)
  0x01, 0x50, 0x40, 0x01, 0x05, 0x0A, 0x07, 0x16, 0x13, // "Ő" (U+0150)
  0x01, 0x51, 0x40, 0x01, 0x04, 0x08, 0x05, 0x16, 0x31, // "ő" (U+0151)
  0x01, 0x52, 0x40, 0x01, 0x07, 0x08, 0x08, 0x16, 0x45, // "Œ" (U+0152)
  0x01, 0x53, 0x40, 0x01, 0x07, 0x06, 0x08, 0x16, 0x65, // "œ" (U+0153)
  0x01, 0x54, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x16, 0x7D, // "Ŕ" (U+0154)
  0x01, 0x55, 0x40, 0x01, 0x03, 0x08, 0x04, 0x16, 0x9B, // "ŕ" (U+0155)
  0x01, 0x56, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x16, 0xAB, // "Ŗ" (U+0156)
  0x01, 0x57, 0x00, 0xFE, 0x03, 0x06, 0x04, 0x16, 0xCB, // "ŗ" (U+0157)
  0x01, 0x58, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x16, 0xDC, // "Ř" (U+0158)
  0x01, 0x59, 0x40, 0x01, 0x03, 0x09, 0x04, 0x16, 0xFD, // "ř" (U+0159)
  0x01, 0x5A, 0x40, 0x01, 0x04, 0x0A, 0x05, 0x17, 0x0F, // "Ś" (U+015A)
  0x01, 0x5B, 0x40, 0x01, 0x03, 0x08, 0x04, 0x17, 0x28, // "ś" (U+015B)
  0x01, 0x5C, 0x40, 0x01, 0x04, 0x0B, 0x05, 0x17, 0x38, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x40, 0x01, 0x03, 0x09, 0x04, 0x17, 0x54, // "ŝ" (U+015D)
  0x01, 0x5E, 0x40, 0xFE, 0x04, 0x08, 0x05, 0x17, 0x66, // "Ş" (U+015E)
  0x01, 0x5F, 0x40, 0xFE, 0x03, 0x06, 0x04, 0x17, 0x82, // "ş" (U+015F)
  0x01, 0x60, 0x40, 0x01, 0x04, 0x0B, 0x05, 0x17, 0x94, // "Š" (U+0160)
  0x01, 0x61, 0x40, 0x01, 0x03, 0x09, 0x04, 0x17, 0xB0, // "š" (U+0161)
  0x01, 0x62, 0x40, 0xFE, 0x04, 0x08, 0x05, 0x17, 0xC2, // "Ţ" (U+0162)
  0x01, 0x63, 0x40, 0xFE, 0x03, 0x07, 0x04, 0x17, 0xDE, // "ţ" (U+0163)
  0x01, 0x64, 0x40, 0x01, 0x04, 0x0B, 0x05, 0x17, 0xF2, // "Ť" (U+0164)
  0x01, 0x65, 0x40, 0x01, 0x04, 0x08, 0x04, 0x18, 0x0E, // "ť" (U+0165)
  0x01, 0x66, 0x40, 0x01, 0x04, 0x08, 0x05, 0x18, 0x22, // "Ŧ" (U+0166)
  0x01, 0x67, 0x40, 0x01, 0x03, 0x07, 0x04, 0x18, 0x36, // "ŧ" (U+0167)
  0x01, 0x68, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x18, 0x44, // "Ũ" (U+0168)
  0x01, 0x69, 0x40, 0x01, 0x04, 0x09, 0x05, 0x18, 0x65, // "ũ" (U+0169)
  0x01, 0x6A, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x18, 0x7C, // "Ū" (U+016A)
  0x01, 0x6B, 0x40, 0x01, 0x04, 0x08, 0x05, 0x18, 0x9A, // "ū" (U+016B)
  0x01, 0x6C, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x18, 0xAE, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x40, 0x01, 0x04, 0x09, 0x05, 0x18, 0xCF, // "ŭ" (U+016D)
  0x01, 0x6E, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x18, 0xE6, // "Ů" (U+016E)
  0x01, 0x6F, 0x40, 0x01, 0x04, 0x09, 0x05, 0x19, 0x07, // "ů" (U+016F)
  0x01, 0x70, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x19, 0x1E, // "Ű" (U+0170)
  0x01, 0x71, 0x40, 0x01, 0x04, 0x08, 0x05, 0x19, 0x3C, // "ű" (U+0171)
  0x01, 0x72, 0x40, 0xFE, 0x05, 0x08, 0x06, 0x19, 0x50, // "Ų" (U+0172)
  0x01, 0x73, 0x40, 0xFE, 0x05, 0x06, 0x05, 0x19, 0x71, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x08, 0x0B, 0x08, 0x19, 0x8C, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x07, 0x09, 0x07, 0x19, 0xBA, // "ŵ" (U+0175)
  0x01, 0x76, 0x40, 0x01, 0x04, 0x0B, 0x05, 0x19, 0xDC, // "Ŷ" (U+0176)
  0x01, 0x77, 0x40, 0xFE, 0x04, 0x09, 0x05, 0x19, 0xF8, // "ŷ" (U+0177)
  0x01, 0x78, 0x40, 0x01, 0x04, 0x0A, 0x05, 0x1A, 0x16, // "Ÿ" (U+0178)
  0x01, 0x79, 0x40, 0x01, 0x04, 0x0A, 0x05, 0x1A, 0x2F, // "Ź" (U+0179)
  0x01, 0x7A, 0x40, 0x01, 0x03, 0x08, 0x04, 0x1A, 0x48, // "ź" (U+017A)
  0x01, 0x7B, 0x40, 0x01, 0x04, 0x0A, 0x05, 0x1A, 0x58, // "Ż" (U+017B)
  0x01, 0x7C, 0x40, 0x01, 0x03, 0x08, 0x04, 0x1A, 0x71, // "ż" (U+017C)
  0x01, 0x7D, 0x40, 0x01, 0x04, 0x0B, 0x05, 0x1A, 0x81, // "Ž" (U+017D)
  0x01, 0x7E, 0x40, 0x01, 0x03, 0x09, 0x04, 0x1A, 0x9D, // "ž" (U+017E)
  0x01, 0x7F, 0x40, 0x01, 0x03, 0x08, 0x03, 0x1A, 0xAF, // "ſ" (U+017F)
  0x03, 0xA9, 0x40, 0x01, 0x06, 0x08, 0x07, 0x1A, 0xBF, // "Ω" (U+03A9)
  0x03, 0xBC, 0x00, 0xFE, 0x04, 0x06, 0x05, 0x1A, 0xDB, // "μ" (U+03BC)
  0x03, 0xC0, 0x40, 0x01, 0x05, 0x06, 0x06, 0x1A, 0xF1, // "π" (U+03C0)
  0x20, 0x13, 0x40, 0x02, 0x04, 0x03, 0x05, 0x1B, 0x03, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x02, 0x09, 0x03, 0x0A, 0x1B, 0x08, // "—" (U+2014)
  0x20, 0xAC, 0x40, 0x01, 0x04, 0x08, 0x05, 0x1B, 0x0F, // "€" (U+20AC)
  0x20, 0xBF, 0x40, 0x00, 0x04, 0x09, 0x05, 0x1B, 0x23, // "₿" (U+20BF)
  0x20, 0x18, 0x40, 0x06, 0x01, 0x08, 0x02, 0x1B, 0x3C, // "‘" (U+2018)
  0x20, 0x19, 0x40, 0x06, 0x01, 0x08, 0x02, 0x1B, 0x3F, // "’" (U+2019)
  0x20, 0x1A, 0x40, 0x00, 0x01, 0x02, 0x03, 0x1B, 0x42, // "‚" (U+201A)
  0x20, 0x1B, 0x40, 0x06, 0x01, 0x08, 0x02, 0x1B, 0x45, // "‛" (U+201B)
  0x20, 0x1C, 0x40, 0x06, 0x04, 0x08, 0x04, 0x1B, 0x48, // "“" (U+201C)
  0x20, 0x1D, 0x40, 0x06, 0x04, 0x08, 0x04, 0x1B, 0x50, // "”" (U+201D)
  0x20, 0x1E, 0x40, 0x00, 0x04, 0x02, 0x05, 0x1B, 0x58, // "„" (U+201E)
  0x20, 0x1F, 0x40, 0x06, 0x04, 0x08, 0x04, 0x1B, 0x60, // "‟" (U+201F)
  0x20, 0x20, 0x40, 0x01, 0x04, 0x08, 0x05, 0x1B, 0x68, // "†" (U+2020)
  0x20, 0x21, 0x40, 0x01, 0x04, 0x08, 0x05, 0x1B, 0x7C, // "‡" (U+2021)
  0x20, 0x22, 0x40, 0x04, 0x03, 0x06, 0x04, 0x1B, 0x90, // "•" (U+2022)
  0x20, 0x26, 0x40, 0x01, 0x06, 0x02, 0x08, 0x1B, 0x96, // "…" (U+2026)
  0x20, 0x30, 0x00, 0x01, 0x0B, 0x08, 0x0C, 0x1B, 0x9D, // "‰" (U+2030)
  0x20, 0x39, 0x40, 0x01, 0x02, 0x05, 0x03, 0x1B, 0xCC, // "‹" (U+2039)
  0x20, 0x3A, 0x40, 0x01, 0x02, 0x05, 0x03, 0x1B, 0xD4, // "›" (U+203A)
  0x20, 0x44, 0xBE, 0x01, 0x02, 0x08, 0x01, 0x1B, 0xDC, // "⁄" (U+2044)
  0x21, 0x22, 0x40, 0x04, 0x06, 0x07, 0x07, 0x1B, 0xF0, // "™" (U+2122)
  0x21, 0x52, 0x00, 0x01, 0x0B, 0x08, 0x0B, 0x1B, 0xFE, // "⅒" (U+2152)
  0xFB, 0x01, 0x40, 0x01, 0x04, 0x08, 0x06, 0x1C, 0x2D, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0x40, 0x01, 0x04, 0x08, 0x06, 0x1C, 0x41, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x01, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0xC0, 0x01, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x01, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x01, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x01, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x01, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x01, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xC6, 0x01, // "Æ (U+0022 U+00C6)
  0x00, 0x22, 0x01, 0x00, 0x01, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x02, 0x01, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x04, 0x01, // "Ą (U+0022 U+0104)
  0x00, 0x27, 0x00, 0x41, 0x01, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0xC0, 0x01, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x01, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x01, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x01, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x01, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x01, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xC6, 0x01, // 'Æ (U+0027 U+00C6)
  0x00, 0x27, 0x01, 0x00, 0x01, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x02, 0x01, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x04, 0x01, // 'Ą (U+0027 U+0104)
  0x00, 0x2C, 0x00, 0x54, 0x01, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x01, 0x62, 0x01, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x01, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x01, // ,Ŧ (U+002C U+0166)
  0x00, 0x2E, 0x00, 0x54, 0x01, // .T (U+002E U+0054)
  0x00, 0x2E, 0x01, 0x62, 0x01, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x01, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x01, // .Ŧ (U+002E U+0166)
  0x00, 0x41, 0x00, 0x22, 0x01, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x01, // A' (U+0041 U+0027)
  0x00, 0x41, 0x20, 0x19, 0x01, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1D, 0x01, // A” (U+0041 U+201D)
  0x00, 0x46, 0x00, 0x2C, 0x01, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x01, // F. (U+0046 U+002E)
  0x00, 0x46, 0x20, 0x1A, 0x01, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x01, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x01, // F… (U+0046 U+2026)
  0x00, 0x4C, 0x00, 0x22, 0x01, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x01, // L' (U+004C U+0027)
  0x00, 0x4C, 0x20, 0x19, 0x01, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1D, 0x01, // L” (U+004C U+201D)
  0x00, 0x50, 0x00, 0x2C, 0x01, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x01, // P. (U+0050 U+002E)
  0x00, 0x50, 0x20, 0x1A, 0x01, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x01, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x01, // P… (U+0050 U+2026)
  0x00, 0x54, 0x00, 0x61, 0x01, // Ta (U+0054 U+0061)
  0x00, 0x54, 0x00, 0x63, 0x01, // Tc (U+0054 U+0063)
  0x00, 0x54, 0x00, 0x64, 0x01, // Td (U+0054 U+0064)
  0x00, 0x54, 0x00, 0x65, 0x01, // Te (U+0054 U+0065)
  0x00, 0x54, 0x00, 0x67, 0x01, // Tg (U+0054 U+0067)
  0x00, 0x54, 0x00, 0x6F, 0x01, // To (U+0054 U+006F)
  0x00, 0x54, 0x00, 0x71, 0x01, // Tq (U+0054 U+0071)
  0x00, 0x54, 0x00, 0xE0, 0x01, // Tà (U+0054 U+00E0)
  0x00, 0x54, 0x00, 0xE1, 0x01, // Tá (U+0054 U+00E1)
  0x00, 0x54, 0x00, 0xE2, 0x01, // Tâ (U+0054 U+00E2)
  0x00, 0x54, 0x00, 0xE3, 0x01, // Tã (U+0054 U+00E3)
  0x00, 0x54, 0x00, 0xE4, 0x01, // Tä (U+0054 U+00E4)
  0x00, 0x54, 0x00, 0xE5, 0x01, // Tå (U+0054 U+00E5)
  0x00, 0x54, 0x00, 0xE6, 0x01, // Tæ (U+0054 U+00E6)
  0x00, 0x54, 0x00, 0xE7, 0x01, // Tç (U+0054 U+00E7)
  0x00, 0x54, 0x00, 0xE8, 0x01, // Tè (U+0054 U+00E8)
  0x00, 0x54, 0x00, 0xE9, 0x01, // Té (U+0054 U+00E9)
  0x00, 0x54, 0x00, 0xEA, 0x01, // Tê (U+0054 U+00EA)
  0x00, 0x54, 0x00, 0xEB, 0x01, // Të (U+0054 U+00EB)
  0x00, 0x54, 0x00, 0xF2, 0x01, // Tò (U+0054 U+00F2)
  0x00, 0x54, 0x00, 0xF3, 0x01, // Tó (U+0054 U+00F3)
  0x00, 0x54, 0x00, 0xF4, 0x01, // Tô (U+0054 U+00F4)
  0x00, 0x54, 0x00, 0xF5, 0x01, // Tõ (U+0054 U+00F5)
  0x00, 0x54, 0x00, 0xF6, 0x01, // Tö (U+0054 U+00F6)
  0x00, 0x54, 0x00, 0xF8, 0x01, // Tø (U+0054 U+00F8)
  0x00, 0x54, 0x01, 0x01, 0x01, // Tā (U+0054 U+0101)
  0x00, 0x54, 0x01, 0x03, 0x01, // Tă (U+0054 U+0103)
  0x00, 0x54, 0x01, 0x05, 0x01, // Tą (U+0054 U+0105)
  0x00, 0x54, 0x01, 0x07, 0x01, // Tć (U+0054 U+0107)
  0x00, 0x54, 0x01, 0x09, 0x01, // Tĉ (U+0054 U+0109)
  0x00, 0x54, 0x01, 0x0B, 0x01, // Tċ (U+0054 U+010B)
  0x00, 0x54, 0x01, 0x0D, 0x01, // Tč (U+0054 U+010D)
  0x00, 0x54, 0x01, 0x0F, 0x01, // Tď (U+0054 U+010F)
  0x00, 0x54, 0x01, 0x11, 0x01, // Tđ (U+0054 U+0111)
  0x00, 0x54, 0x01, 0x13, 0x01, // Tē (U+0054 U+0113)
  0x00, 0x54, 0x01, 0x15, 0x01, // Tĕ (U+0054 U+0115)
  0x00, 0x54, 0x01, 0x17, 0x01, // Tė (U+0054 U+0117)
  0x00, 0x54, 0x01, 0x19, 0x01, // Tę (U+0054 U+0119)
  0x00, 0x54, 0x01, 0x1B, 0x01, // Tě (U+0054 U+011B)
  0x00, 0x54, 0x01, 0x1D, 0x01, // Tĝ (U+0054 U+011D)
  0x00, 0x54, 0x01, 0x1F, 0x01, // Tğ (U+0054 U+011F)
  0x00, 0x54, 0x01, 0x21, 0x01, // Tġ (U+0054 U+0121)
  0x00, 0x54, 0x01, 0x23, 0x01, // Tģ (U+0054 U+0123)
  0x00, 0x54, 0x01, 0x4D, 0x01, // Tō (U+0054 U+014D)
  0x00, 0x54, 0x01, 0x4F, 0x01, // Tŏ (U+0054 U+014F)
  0x00, 0x54, 0x01, 0x51, 0x01, // Tő (U+0054 U+0151)
  0x00, 0x54, 0x01, 0x53, 0x01, // Tœ (U+0054 U+0153)
  0x00, 0x59, 0x00, 0xAB, 0x01, // Y« (U+0059 U+00AB)
  0x00, 0x59, 0x20, 0x39, 0x01, // Y‹ (U+0059 U+2039)
  0x00, 0x72, 0x00, 0x2C, 0x01, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x01, // r. (U+0072 U+002E)
  0x00, 0x72, 0x20, 0x1A, 0x01, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x01, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x01, // r… (U+0072 U+2026)
  0x00, 0xBB, 0x00, 0x59, 0x01, // »Y (U+00BB U+0059)
  0x00, 0xBB, 0x00, 0xDD, 0x01, // »Ý (U+00BB U+00DD)
  0x00, 0xBB, 0x01, 0x76, 0x01, // »Ŷ (U+00BB U+0176)
  0x00, 0xBB, 0x01, 0x78, 0x01, // »Ÿ (U+00BB U+0178)
  0x00, 0xC0, 0x00, 0x22, 0x01, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x01, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x20, 0x19, 0x01, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1D, 0x01, // À” (U+00C0 U+201D)
  0x00, 0xC1, 0x00, 0x22, 0x01, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x01, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x20, 0x19, 0x01, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1D, 0x01, // Á” (U+00C1 U+201D)
  0x00, 0xC2, 0x00, 0x22, 0x01, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x01, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x20, 0x19, 0x01, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1D, 0x01, // Â” (U+00C2 U+201D)
  0x00, 0xC3, 0x00, 0x22, 0x01, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x01, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x20, 0x19, 0x01, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1D, 0x01, // Ã” (U+00C3 U+201D)
  0x00, 0xC4, 0x00, 0x22, 0x01, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x01, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x20, 0x19, 0x01, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1D, 0x01, // Ä” (U+00C4 U+201D)
  0x00, 0xC5, 0x00, 0x22, 0x01, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x01, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x20, 0x19, 0x01, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1D, 0x01, // Å” (U+00C5 U+201D)
  0x00, 0xDD, 0x00, 0xAB, 0x01, // Ý« (U+00DD U+00AB)
  0x00, 0xDD, 0x20, 0x39, 0x01, // Ý‹ (U+00DD U+2039)
  0x00, 0xDE, 0x00, 0x2C, 0x01, // Þ, (U+00DE U+002C)
  0x00, 0xDE, 0x00, 0x2E, 0x01, // Þ. (U+00DE U+002E)
  0x00, 0xDE, 0x20, 0x1A, 0x01, // Þ‚ (U+00DE U+201A)
  0x00, 0xDE, 0x20, 0x1E, 0x01, // Þ„ (U+00DE U+201E)
  0x00, 0xDE, 0x20, 0x26, 0x01, // Þ… (U+00DE U+2026)
  0x01, 0x00, 0x00, 0x22, 0x01, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x01, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x20, 0x19, 0x01, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1D, 0x01, // Ā” (U+0100 U+201D)
  0x01, 0x02, 0x00, 0x22, 0x01, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x01, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x20, 0x19, 0x01, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1D, 0x01, // Ă” (U+0102 U+201D)
  0x01, 0x04, 0x00, 0x22, 0x01, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x01, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x20, 0x19, 0x01, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1D, 0x01, // Ą” (U+0104 U+201D)
  0x01, 0x39, 0x00, 0x22, 0x01, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x01, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x20, 0x19, 0x01, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1D, 0x01, // Ĺ” (U+0139 U+201D)
  0x01, 0x3B, 0x00, 0x22, 0x01, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x01, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x20, 0x19, 0x01, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1D, 0x01, // Ļ” (U+013B U+201D)
  0x01, 0x3D, 0x00, 0x22, 0x01, // Ľ" (U+013D U+0022)
  0x01, 0x3D, 0x00, 0x27, 0x01, // Ľ' (U+013D U+0027)
  0x01, 0x3D, 0x20, 0x19, 0x01, // Ľ’ (U+013D U+2019)
  0x01, 0x3D, 0x20, 0x1D, 0x01, // Ľ” (U+013D U+201D)
  0x01, 0x3F, 0x00, 0x22, 0x01, // Ŀ" (U+013F U+0022)
  0x01, 0x3F, 0x00, 0x27, 0x01, // Ŀ' (U+013F U+0027)
  0x01, 0x3F, 0x20, 0x19, 0x01, // Ŀ’ (U+013F U+2019)
  0x01, 0x3F, 0x20, 0x1D, 0x01, // Ŀ” (U+013F U+201D)
  0x01, 0x41, 0x00, 0x22, 0x01, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x01, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x20, 0x19, 0x01, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1D, 0x01, // Ł” (U+0141 U+201D)
  0x01, 0x55, 0x00, 0x2C, 0x01, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x01, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x20, 0x1A, 0x01, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x01, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x01, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x01, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x01, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x20, 0x1A, 0x01, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x01, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x01, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x01, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x01, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x20, 0x1A, 0x01, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x01, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x01, // ř… (U+0159 U+2026)
  0x01, 0x62, 0x00, 0x61, 0x01, // Ţa (U+0162 U+0061)
  0x01, 0x62, 0x00, 0x63, 0x01, // Ţc (U+0162 U+0063)
  0x01, 0x62, 0x00, 0x64, 0x01, // Ţd (U+0162 U+0064)
  0x01, 0x62, 0x00, 0x65, 0x01, // Ţe (U+0162 U+0065)
  0x01, 0x62, 0x00, 0x67, 0x01, // Ţg (U+0162 U+0067)
  0x01, 0x62, 0x00, 0x6F, 0x01, // Ţo (U+0162 U+006F)
  0x01, 0x62, 0x00, 0x71, 0x01, // Ţq (U+0162 U+0071)
  0x01, 0x62, 0x00, 0xE0, 0x01, // Ţà (U+0162 U+00E0)
  0x01, 0x62, 0x00, 0xE1, 0x01, // Ţá (U+0162 U+00E1)
  0x01, 0x62, 0x00, 0xE2, 0x01, // Ţâ (U+0162 U+00E2)
  0x01, 0x62, 0x00, 0xE3, 0x01, // Ţã (U+0162 U+00E3)
  0x01, 0x62, 0x00, 0xE4, 0x01, // Ţä (U+0162 U+00E4)
  0x01, 0x62, 0x00, 0xE5, 0x01, // Ţå (U+0162 U+00E5)
  0x01, 0x62, 0x00, 0xE6, 0x01, // Ţæ (U+0162 U+00E6)
  0x01, 0x62, 0x00, 0xE7, 0x01, // Ţç (U+0162 U+00E7)
  0x01, 0x62, 0x00, 0xE8, 0x01, // Ţè (U+0162 U+00E8)
  0x01, 0x62, 0x00, 0xE9, 0x01, // Ţé (U+0162 U+00E9)
  0x01, 0x62, 0x00, 0xEA, 0x01, // Ţê (U+0162 U+00EA)
  0x01, 0x62, 0x00, 0xEB, 0x01, // Ţë (U+0162 U+00EB)
  0x01, 0x62, 0x00, 0xF2, 0x01, // Ţò (U+0162 U+00F2)
  0x01, 0x62, 0x00, 0xF3, 0x01, // Ţó (U+0162 U+00F3)
  0x01, 0x62, 0x00, 0xF4, 0x01, // Ţô (U+0162 U+00F4)
  0x01, 0x62, 0x00, 0xF5, 0x01, // Ţõ (U+0162 U+00F5)
  0x01, 0x62, 0x00, 0xF6, 0x01, // Ţö (U+0162 U+00F6)
  0x01, 0x62, 0x00, 0xF8, 0x01, // Ţø (U+0162 U+00F8)
  0x01, 0x62, 0x01, 0x01, 0x01, // Ţā (U+0162 U+0101)
  0x01, 0x62, 0x01, 0x03, 0x01, // Ţă (U+0162 U+0103)
  0x01, 0x62, 0x01, 0x05, 0x01, // Ţą (U+0162 U+0105)
  0x01, 0x62, 0x01, 0x07, 0x01, // Ţć (U+0162 U+0107)
  0x01, 0x62, 0x01, 0x09, 0x01, // Ţĉ (U+0162 U+0109)
  0x01, 0x62, 0x01, 0x0B, 0x01, // Ţċ (U+0162 U+010B)
  0x01, 0x62, 0x01, 0x0D, 0x01, // Ţč (U+0162 U+010D)
  0x01, 0x62, 0x01, 0x0F, 0x01, // Ţď (U+0162 U+010F)
  0x01, 0x62, 0x01, 0x11, 0x01, // Ţđ (U+0162 U+0111)
  0x01, 0x62, 0x01, 0x13, 0x01, // Ţē (U+0162 U+0113)
  0x01, 0x62, 0x01, 0x15, 0x01, // Ţĕ (U+0162 U+0115)
  0x01, 0x62, 0x01, 0x17, 0x01, // Ţė (U+0162 U+0117)
  0x01, 0x62, 0x01, 0x19, 0x01, // Ţę (U+0162 U+0119)
  0x01, 0x62, 0x01, 0x1B, 0x01, // Ţě (U+0162 U+011B)
  0x01, 0x62, 0x01, 0x1D, 0x01, // Ţĝ (U+0162 U+011D)
  0x01, 0x62, 0x01, 0x1F, 0x01, // Ţğ (U+0162 U+011F)
  0x01, 0x62, 0x01, 0x21, 0x01, // Ţġ (U+0162 U+0121)
  0x01, 0x62, 0x01, 0x23, 0x01, // Ţģ (U+0162 U+0123)
  0x01, 0x62, 0x01, 0x4D, 0x01, // Ţō (U+0162 U+014D)
  0x01, 0x62, 0x01, 0x4F, 0x01, // Ţŏ (U+0162 U+014F)
  0x01, 0x62, 0x01, 0x51, 0x01, // Ţő (U+0162 U+0151)
  0x01, 0x62, 0x01, 0x53, 0x01, // Ţœ (U+0162 U+0153)
  0x01, 0x64, 0x00, 0x61, 0x01, // Ťa (U+0164 U+0061)
  0x01, 0x64, 0x00, 0x63, 0x01, // Ťc (U+0164 U+0063)
  0x01, 0x64, 0x00, 0x64, 0x01, // Ťd (U+0164 U+0064)
  0x01, 0x64, 0x00, 0x65, 0x01, // Ťe (U+0164 U+0065)
  0x01, 0x64, 0x00, 0x67, 0x01, // Ťg (U+0164 U+0067)
  0x01, 0x64, 0x00, 0x6F, 0x01, // Ťo (U+0164 U+006F)
  0x01, 0x64, 0x00, 0x71, 0x01, // Ťq (U+0164 U+0071)
  0x01, 0x64, 0x00, 0xE0, 0x01, // Ťà (U+0164 U+00E0)
  0x01, 0x64, 0x00, 0xE1, 0x01, // Ťá (U+0164 U+00E1)
  0x01, 0x64, 0x00, 0xE2, 0x01, // Ťâ (U+0164 U+00E2)
  0x01, 0x64, 0x00, 0xE3, 0x01, // Ťã (U+0164 U+00E3)
  0x01, 0x64, 0x00, 0xE4, 0x01, // Ťä (U+0164 U+00E4)
  0x01, 0x64, 0x00, 0xE5, 0x01, // Ťå (U+0164 U+00E5)
  0x01, 0x64, 0x00, 0xE6, 0x01, // Ťæ (U+0164 U+00E6)
  0x01, 0x64, 0x00, 0xE7, 0x01, // Ťç (U+0164 U+00E7)
  0x01, 0x64, 0x00, 0xE8, 0x01, // Ťè (U+0164 U+00E8)
  0x01, 0x64, 0x00, 0xE9, 0x01, // Ťé (U+0164 U+00E9)
  0x01, 0x64, 0x00, 0xEA, 0x01, // Ťê (U+0164 U+00EA)
  0x01, 0x64, 0x00, 0xEB, 0x01, // Ťë (U+0164 U+00EB)
  0x01, 0x64, 0x00, 0xF2, 0x01, // Ťò (U+0164 U+00F2)
  0x01, 0x64, 0x00, 0xF3, 0x01, // Ťó (U+0164 U+00F3)
  0x01, 0x64, 0x00, 0xF4, 0x01, // Ťô (U+0164 U+00F4)
  0x01, 0x64, 0x00, 0xF5, 0x01, // Ťõ (U+0164 U+00F5)
  0x01, 0x64, 0x00, 0xF6, 0x01, // Ťö (U+0164 U+00F6)
  0x01, 0x64, 0x00, 0xF8, 0x01, // Ťø (U+0164 U+00F8)
  0x01, 0x64, 0x01, 0x01, 0x01, // Ťā (U+0164 U+0101)
  0x01, 0x64, 0x01, 0x03, 0x01, // Ťă (U+0164 U+0103)
  0x01, 0x64, 0x01, 0x05, 0x01, // Ťą (U+0164 U+0105)
  0x01, 0x64, 0x01, 0x07, 0x01, // Ťć (U+0164 U+0107)
  0x01, 0x64, 0x01, 0x09, 0x01, // Ťĉ (U+0164 U+0109)
  0x01, 0x64, 0x01, 0x0B, 0x01, // Ťċ (U+0164 U+010B)
  0x01, 0x64, 0x01, 0x0D, 0x01, // Ťč (U+0164 U+010D)
  0x01, 0x64, 0x01, 0x0F, 0x01, // Ťď (U+0164 U+010F)
  0x01, 0x64, 0x01, 0x11, 0x01, // Ťđ (U+0164 U+0111)
  0x01, 0x64, 0x01, 0x13, 0x01, // Ťē (U+0164 U+0113)
  0x01, 0x64, 0x01, 0x15, 0x01, // Ťĕ (U+0164 U+0115)
  0x01, 0x64, 0x01, 0x17, 0x01, // Ťė (U+0164 U+0117)
  0x01, 0x64, 0x01, 0x19, 0x01, // Ťę (U+0164 U+0119)
  0x01, 0x64, 0x01, 0x1B, 0x01, // Ťě (U+0164 U+011B)
  0x01, 0x64, 0x01, 0x1D, 0x01, // Ťĝ (U+0164 U+011D)
  0x01, 0x64, 0x01, 0x1F, 0x01, // Ťğ (U+0164 U+011F)
  0x01, 0x64, 0x01, 0x21, 0x01, // Ťġ (U+0164 U+0121)
  0x01, 0x64, 0x01, 0x23, 0x01, // Ťģ (U+0164 U+0123)
  0x01, 0x64, 0x01, 0x4D, 0x01, // Ťō (U+0164 U+014D)
  0x01, 0x64, 0x01, 0x4F, 0x01, // Ťŏ (U+0164 U+014F)
  0x01, 0x64, 0x01, 0x51, 0x01, // Ťő (U+0164 U+0151)
  0x01, 0x64, 0x01, 0x53, 0x01, // Ťœ (U+0164 U+0153)
  0x01, 0x66, 0x00, 0x61, 0x01, // Ŧa (U+0166 U+0061)
  0x01, 0x66, 0x00, 0x63, 0x01, // Ŧc (U+0166 U+0063)
  0x01, 0x66, 0x00, 0x64, 0x01, // Ŧd (U+0166 U+0064)
  0x01, 0x66, 0x00, 0x65, 0x01, // Ŧe (U+0166 U+0065)
  0x01, 0x66, 0x00, 0x67, 0x01, // Ŧg (U+0166 U+0067)
  0x01, 0x66, 0x00, 0x6F, 0x01, // Ŧo (U+0166 U+006F)
  0x01, 0x66, 0x00, 0x71, 0x01, // Ŧq (U+0166 U+0071)
  0x01, 0x66, 0x00, 0xE0, 0x01, // Ŧà (U+0166 U+00E0)
  0x01, 0x66, 0x00, 0xE1, 0x01, // Ŧá (U+0166 U+00E1)
  0x01, 0x66, 0x00, 0xE2, 0x01, // Ŧâ (U+0166 U+00E2)
  0x01, 0x66, 0x00, 0xE3, 0x01, // Ŧã (U+0166 U+00E3)
  0x01, 0x66, 0x00, 0xE4, 0x01, // Ŧä (U+0166 U+00E4)
  0x01, 0x66, 0x00, 0xE5, 0x01, // Ŧå (U+0166 U+00E5)
  0x01, 0x66, 0x00, 0xE6, 0x01, // Ŧæ (U+0166 U+00E6)
  0x01, 0x66, 0x00, 0xE7, 0x01, // Ŧç (U+0166 U+00E7)
  0x01, 0x66, 0x00, 0xE8, 0x01, // Ŧè (U+0166 U+00E8)
  0x01, 0x66, 0x00, 0xE9, 0x01, // Ŧé (U+0166 U+00E9)
  0x01, 0x66, 0x00, 0xEA, 0x01, // Ŧê (U+0166 U+00EA)
  0x01, 0x66, 0x00, 0xEB, 0x01, // Ŧë (U+0166 U+00EB)
  0x01, 0x66, 0x00, 0xF2, 0x01, // Ŧò (U+0166 U+00F2)
  0x01, 0x66, 0x00, 0xF3, 0x01, // Ŧó (U+0166 U+00F3)
  0x01, 0x66, 0x00, 0xF4, 0x01, // Ŧô (U+0166 U+00F4)
  0x01, 0x66, 0x00, 0xF5, 0x01, // Ŧõ (U+0166 U+00F5)
  0x01, 0x66, 0x00, 0xF6, 0x01, // Ŧö (U+0166 U+00F6)
  0x01, 0x66, 0x00, 0xF8, 0x01, // Ŧø (U+0166 U+00F8)
  0x01, 0x66, 0x01, 0x01, 0x01, // Ŧā (U+0166 U+0101)
  0x01, 0x66, 0x01, 0x03, 0x01, // Ŧă (U+0166 U+0103)
  0x01, 0x66, 0x01, 0x05, 0x01, // Ŧą (U+0166 U+0105)
  0x01, 0x66, 0x01, 0x07, 0x01, // Ŧć (U+0166 U+0107)
  0x01, 0x66, 0x01, 0x09, 0x01, // Ŧĉ (U+0166 U+0109)
  0x01, 0x66, 0x01, 0x0B, 0x01, // Ŧċ (U+0166 U+010B)
  0x01, 0x66, 0x01, 0x0D, 0x01, // Ŧč (U+0166 U+010D)
  0x01, 0x66, 0x01, 0x0F, 0x01, // Ŧď (U+0166 U+010F)
  0x01, 0x66, 0x01, 0x11, 0x01, // Ŧđ (U+0166 U+0111)
  0x01, 0x66, 0x01, 0x13, 0x01, // Ŧē (U+0166 U+0113)
  0x01, 0x66, 0x01, 0x15, 0x01, // Ŧĕ (U+0166 U+0115)
  0x01, 0x66, 0x01, 0x17, 0x01, // Ŧė (U+0166 U+0117)
  0x01, 0x66, 0x01, 0x19, 0x01, // Ŧę (U+0166 U+0119)
  0x01, 0x66, 0x01, 0x1B, 0x01, // Ŧě (U+0166 U+011B)
  0x01, 0x66, 0x01, 0x1D, 0x01, // Ŧĝ (U+0166 U+011D)
  0x01, 0x66, 0x01, 0x1F, 0x01, // Ŧğ (U+0166 U+011F)
  0x01, 0x66, 0x01, 0x21, 0x01, // Ŧġ (U+0166 U+0121)
  0x01, 0x66, 0x01, 0x23, 0x01, // Ŧģ (U+0166 U+0123)
  0x01, 0x66, 0x01, 0x4D, 0x01, // Ŧō (U+0166 U+014D)
  0x01, 0x66, 0x01, 0x4F, 0x01, // Ŧŏ (U+0166 U+014F)
  0x01, 0x66, 0x01, 0x51, 0x01, // Ŧő (U+0166 U+0151)
  0x01, 0x66, 0x01, 0x53, 0x01, // Ŧœ (U+0166 U+0153)
  0x01, 0x76, 0x00, 0xAB, 0x01, // Ŷ« (U+0176 U+00AB)
  0x01, 0x76, 0x20, 0x39, 0x01, // Ŷ‹ (U+0176 U+2039)
  0x01, 0x78, 0x00, 0xAB, 0x01, // Ÿ« (U+0178 U+00AB)
  0x01, 0x78, 0x20, 0x39, 0x01, // Ÿ‹ (U+0178 U+2039)
  0x20, 0x18, 0x00, 0x41, 0x01, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0xC0, 0x01, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x01, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x01, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x01, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x01, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x01, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xC6, 0x01, // ‘Æ (U+2018 U+00C6)
  0x20, 0x18, 0x01, 0x00, 0x01, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x02, 0x01, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x04, 0x01, // ‘Ą (U+2018 U+0104)
  0x20, 0x19, 0x00, 0x41, 0x01, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0xC0, 0x01, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x01, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x01, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x01, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x01, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x01, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xC6, 0x01, // ’Æ (U+2019 U+00C6)
  0x20, 0x19, 0x01, 0x00, 0x01, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x02, 0x01, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x04, 0x01, // ’Ą (U+2019 U+0104)
  0x20, 0x1A, 0x00, 0x54, 0x01, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x01, 0x62, 0x01, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x01, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x01, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1C, 0x00, 0x41, 0x01, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0xC0, 0x01, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x01, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x01, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x01, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x01, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x01, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xC6, 0x01, // “Æ (U+201C U+00C6)
  0x20, 0x1C, 0x01, 0x00, 0x01, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x02, 0x01, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x04, 0x01, // “Ą (U+201C U+0104)
  0x20, 0x1D, 0x00, 0x41, 0x01, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0xC0, 0x01, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x01, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x01, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x01, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x01, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x01, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xC6, 0x01, // ”Æ (U+201D U+00C6)
  0x20, 0x1D, 0x01, 0x00, 0x01, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x02, 0x01, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x04, 0x01, // ”Ą (U+201D U+0104)
  0x20, 0x1E, 0x00, 0x54, 0x01, // „T (U+201E U+0054)
  0x20, 0x1E, 0x01, 0x62, 0x01, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x01, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x01, // „Ŧ (U+201E U+0166)
  0x20, 0x3A, 0x00, 0x59, 0x01, // ›Y (U+203A U+0059)
  0x20, 0x3A, 0x00, 0xDD, 0x01, // ›Ý (U+203A U+00DD)
  0x20, 0x3A, 0x01, 0x76, 0x01, // ›Ŷ (U+203A U+0176)
  0x20, 0x3A, 0x01, 0x78, 0x01, // ›Ÿ (U+203A U+0178)
  
  // Glyph data
  // "!" (U+0021)
  0x6F, 0x16, 0xF0, 0x5F, 0x04, 0xE0, 0x4E, 0x00, 0x00, 0x01, 0x04, 0xE0,
  // """ (U+0022)
  0x7D, 0x5F, 0x6C, 0x4D, 0x49, 0x3B,
  // "#" (U+0023)
  0x02, 0xC5, 0x90, 0x04, 0xA7, 0x70, 0x8F, 0xFF, 0xF5, 0x1A, 0x8C, 0x51, 0x0A, 0x5D, 0x20, 0xCF,
  0xFF, 0xF1, 0x2E, 0x5D, 0x20, 0x1E, 0x4B, 0x00,
  // "$" (U+0024)
  0x00, 0xA0, 0x01, 0xDF, 0xF4, 0x7C, 0xA4, 0x16, 0xDB, 0x00, 0x0A, 0xFA, 0x00, 0x0B, 0xD7, 0x42,
  0xAB, 0x87, 0xFF, 0xD1, 0x01, 0xA0, 0x00,
  // "%" (U+0025)
  0x2E, 0xA0, 0x1D, 0x00, 0x99, 0xE2, 0x78, 0x00, 0xA6, 0xC4, 0xD2, 0x00, 0x97, 0xD7, 0xB9, 0xE3,
  0x3F, 0xDA, 0x7F, 0x8A, 0x01, 0x1E, 0x3D, 0x4B, 0x00, 0x79, 0x1E, 0x8A, 0x00, 0xD3, 0x09, 0xE3,
  // "&" (U+0026)
  0x08, 0xEB, 0x00, 0x01, 0xF7, 0xE5, 0x00, 0x0F, 0x5F, 0x40, 0x00, 0xAF, 0xB0, 0x00, 0x3E, 0xF9,
  0x7E, 0x09, 0xC4, 0xFE, 0x80, 0x9E, 0x4C, 0xF4, 0x02, 0xCE, 0xBB, 0xD1,
  // "'" (U+0027)
  0x7D, 0x6C, 0x49,
  // "(" (U+0028)
  0x07, 0xB0, 0xE4, 0x4E, 0x07, 0xC0, 0x8B, 0x07, 0xC0, 0x4E, 0x00, 0xE4, 0x07, 0xB0,
  // ")" (U+0029)
  0x8A, 0x01, 0xF2, 0x0B, 0x70, 0x9A, 0x08, 0xB0, 0x9A, 0x0C, 0x81, 0xF3, 0x8A, 0x00,
  // "*" (U+002A)
  0x03, 0xE0, 0x07, 0x8E, 0x94, 0x5B, 0xF9, 0x31, 0xE9, 0xC0, 0x04, 0x03, 0x00,
  // "+" (U+002B)
  0x29, 0x49, 0x20, 0x9B, 0x84, 0xA1, 0x3F, 0x31, 0x29, 0x20,
  // "," (U+002C)
  0x3D, 0x6D, 0x98,
  // "-" (U+002D)
  0xAF, 0xC2, 0x22,
  // "." (U+002E)
  0x01, 0x4E,
  // "/" (U+002F)
  0x00, 0x5C, 0x00, 0xB7, 0x01, 0xF2, 0x06, 0xC0, 0x0B, 0x70, 0x1F, 0x20, 0x6C, 0x00, 0xB7, 0x00,
  // "0" (U+0030)
  0x09, 0xE9, 0x04, 0xF5, 0xF3, 0x7D, 0x0D, 0x79, 0xC0, 0xC9, 0x9C, 0x0C, 0x98, 0xC0, 0xD7, 0x4F,
  0x5F, 0x40, 0x9E, 0xA0,
  // "1" (U+0031)
  0x01, 0xCB, 0x0C, 0xFB, 0x3C, 0xAB, 0x00, 0xAB, 0x00, 0xAB, 0x00, 0xAB, 0x00, 0xAB, 0x00, 0xAB,
  // "2" (U+0032)
  0x3C, 0xE9, 0x05, 0x95, 0xF3, 0x00, 0x0F, 0x50, 0x05, 0xF2, 0x00, 0xD9, 0x00, 0x9D, 0x10, 0x4F,
  0x63, 0x1A, 0xFF, 0xF8,
  // "3" (U+0033)
  0x4D, 0xEB, 0x03, 0x65, 0xF5, 0x00, 0x3F, 0x30, 0xBF, 0x80, 0x02, 0x6F, 0x50, 0x00, 0xE8, 0x64,
  0x6F, 0x57, 0xEE, 0x90,
  // "4" (U+0034)
  0x00, 0x7F, 0x10, 0x1E, 0xF1, 0x08, 0xDF, 0x11, 0xE6, 0xF1, 0x89, 0x4F, 0x1C, 0xFF, 0xFD, 0x22,
  0x6F, 0x30, 0x04, 0xF1,
  // "5" (U+0035)
  0x3F, 0xFF, 0x24, 0xF3, 0x30, 0x5E, 0x00, 0x05, 0xFF, 0xB0, 0x14, 0x5F, 0x50, 0x00, 0xD7, 0x44,
  0x5F, 0x56, 0xEE, 0x90,
  // "6" (U+0036)
  0x04, 0xDF, 0x31, 0xF8, 0x31, 0x6D, 0x00, 0x08, 0xCD, 0xD1, 0x9E, 0x4D, 0x88, 0xC0, 0xB9, 0x4F,
  0x5E, 0x70, 0x9E, 0xB0,
  // "7" (U+0037)
  0xAF, 0xFF, 0xA2, 0x33, 0xE7, 0x00, 0x3F, 0x20, 0x08, 0xC0, 0x00, 0xD8, 0x00, 0x3F, 0x30, 0x08,
  0xD0, 0x00, 0xD8, 0x00,
  // "8" (U+0038)
  0x0B, 0xEB, 0x06, 0xE4, 0xE6, 0x5E, 0x2E, 0x50, 0xCF, 0xB0, 0x3E, 0xBE, 0x29, 0xB0, 0xC9, 0x9D,
  0x4D, 0x81, 0xCE, 0xB1,
  // "9" (U+0039)
  0x0B, 0xE8, 0x07, 0xE5, 0xF4, 0x9B, 0x0C, 0x88, 0xD1, 0xE9, 0x3E, 0xED, 0x80, 0x11, 0xD5, 0x13,
  0x8E, 0x14, 0xFD, 0x40,
  // ":" (U+003A)
  0x4E, 0x02, 0x00, 0x00, 0x01, 0x4E,
  // ";" (U+003B)
  0x4E, 0x02, 0x00, 0x00, 0x4F, 0x7C, 0x86,
  // "<" (U+003C)
  0x00, 0x07, 0x80, 0x7E, 0xA2, 0x9F, 0x60, 0x00, 0x5C, 0xC4, 0x00, 0x04, 0x70,
  // "=" (U+003D)
  0x9F, 0xFF, 0xA2, 0x33, 0x32, 0x9F, 0xFF, 0xA1, 0x22, 0x21,
  // ">" (U+003E)
  0x97, 0x00, 0x02, 0xAE, 0x70, 0x00, 0x6F, 0x94, 0xCC, 0x50, 0x74, 0x00, 0x00,
  // "?" (U+003F)
  0x8E, 0xD3, 0x64, 0xBB, 0x00, 0x9B, 0x03, 0xF6, 0x0B, 0xA0, 0x0A, 0x30, 0x01, 0x00, 0x0D, 0x50,
  // "@" (U+0040)
  0x00, 0x8E, 0xE9, 0x00, 0x09, 0xC4, 0x4B, 0x90, 0x2E, 0x3C, 0xE6, 0xE1, 0x69, 0x99, 0xA7, 0xB3,
  0x87, 0xC3, 0x96, 0xA4, 0x77, 0xC5, 0xC7, 0xD2, 0x5B, 0x6F, 0x9F, 0xB0, 0x0E, 0x73, 0x14, 0x00,
  0x04, 0xDF, 0xFB, 0x00, 0x00, 0x02, 0x10, 0x00,
  // "A" (U+0041)
  0x02, 0xFD, 0x00, 0x06, 0xEF, 0x20, 0x0A, 0xAE, 0x50, 0x0D, 0x7B, 0x90, 0x2F, 0x58, 0xD0, 0x6F,
  0xFF, 0xF1, 0x9D, 0x34, 0xF5, 0xD9, 0x00, 0xD9,
  // "B" (U+0042)
  0x4F, 0xFD, 0x70, 0x4F, 0x4A, 0xF0, 0x4F, 0x27, 0xE0, 0x4F, 0xFF, 0x70, 0x4F, 0x49, 0xF1, 0x4F,
  0x13, 0xF3, 0x4F, 0x49, 0xF1, 0x4F, 0xFE, 0x60,
  // "C" (U+0043)
  0x03, 0xDE, 0xA0, 0xEA, 0x46, 0x5F, 0x20, 0x07, 0xF0, 0x00, 0x7F, 0x00, 0x05, 0xF1, 0x00, 0x0E,
  0xA3, 0x50, 0x5D, 0xF9,
  // "D" (U+0044)
  0x4F, 0xFC, 0x40, 0x4F, 0x49, 0xF1, 0x4F, 0x10, 0xE7, 0x4F, 0x10, 0xC9, 0x4F, 0x10, 0xD9, 0x4F,
  0x10, 0xE6, 0x4F, 0x59, 0xE1, 0x4F, 0xFD, 0x40,
  // "E" (U+0045)
  0x4F, 0xFF, 0x34, 0xF4, 0x30, 0x4F, 0x20, 0x04, 0xFF, 0xF0, 0x4F, 0x42, 0x04, 0xF1, 0x00, 0x4F,
  0x43, 0x04, 0xFF, 0xF3,
  // "F" (U+0046)
  0x4F, 0xFF, 0x24, 0xF4, 0x30, 0x4F, 0x10, 0x04, 0xF2, 0x00, 0x4F, 0xFF, 0x04, 0xF4, 0x20, 0x4F,
  0x10, 0x04, 0xF1, 0x00,
  // "G" (U+0047)
  0x02, 0xBE, 0xD4, 0x0D, 0xC4, 0x62, 0x5F, 0x20, 0x00, 0x7F, 0x00, 0x00, 0x7F, 0x0C, 0xF9, 0x5F,
  0x22, 0xC9, 0x0E, 0xA3, 0xD9, 0x04, 0xDF, 0xD6,
  // "H" (U+0048)
  0x4F, 0x10, 0xC9, 0x4F, 0x10, 0xC9, 0x4F, 0x20, 0xC9, 0x4F, 0xFF, 0xF9, 0x4F, 0x42, 0xC9, 0x4F,
  0x10, 0xC9, 0x4F, 0x10, 0xC9, 0x4F, 0x10, 0xC9,
  // "I" (U+0049)
  0xAF, 0xF2, 0x1F, 0x80, 0x0F, 0x60, 0x0F, 0x60, 0x0F, 0x60, 0x0F, 0x60, 0x0F, 0x70, 0xAF, 0xF2,
  // "J" (U+004A)
  0x04, 0xF1, 0x04, 0xF1, 0x04, 0xF1, 0x04, 0xF1, 0x04, 0xF1, 0x04, 0xF1, 0x04, 0xF1, 0x04, 0xF1,
  0x07, 0xF0, 0x9F, 0x90, 0x12, 0x00,
  // "K" (U+004B)
  0x4F, 0x13, 0xF4, 0x4F, 0x1B, 0xB0, 0x4F, 0x6F, 0x30, 0x4F, 0xDB, 0x00, 0x4F, 0xEE, 0x10, 0x4F,
  0x3F, 0x70, 0x4F, 0x19, 0xE0, 0x4F, 0x12, 0xF6,
  // "L" (U+004C)
  0x4F, 0x10, 0x04, 0xF1, 0x00, 0x4F, 0x10, 0x04, 0xF1, 0x00, 0x4F, 0x10, 0x04, 0xF1, 0x00, 0x4F,
  0x54, 0x14, 0xFF, 0xF5,
  // "M" (U+004D)
  0x4F, 0xC0, 0x08, 0xF8, 0x4F, 0xF0, 0x0C, 0xF8, 0x4E, 0xD4, 0x1F, 0xD8, 0x4F, 0xA8, 0x4C, 0xC8,
  0x4F, 0x6C, 0x88, 0xC8, 0x4F, 0x2F, 0xD4, 0xC8, 0x4F, 0x0D, 0xF0, 0xC8, 0x4F, 0x09, 0xC0, 0xC8,
  // "N" (U+004E)
  0x4F, 0x90, 0x3F, 0x14, 0xFF, 0x13, 0xF1, 0x4F, 0xE7, 0x3F, 0x14, 0xF8, 0xD3, 0xF1, 0x4F, 0x2F,
  0x8F, 0x14, 0xF0, 0xAE, 0xF1, 0x4F, 0x04, 0xFF, 0x14, 0xF0, 0x0C, 0xF1,
  // "O" (U+004F)
  0x05, 0xDE, 0xA0, 0x0E, 0x94, 0xE8, 0x5F, 0x10, 0x8D, 0x7F, 0x00, 0x6F, 0x7F, 0x00, 0x6F, 0x5F,
  0x10, 0x8D, 0x1E, 0x94, 0xE8, 0x04, 0xDE, 0xA0,
  // "P" (U+0050)
  0x4F, 0xFD, 0x34, 0xF4, 0xBC, 0x4F, 0x17, 0xE4, 0xF2, 0xBC, 0x4F, 0xFE, 0x44, 0xF4, 0x00, 0x4F,
  0x10, 0x04, 0xF1, 0x00,
  // "Q" (U+0051)
  0x04, 0xDF, 0xA0, 0x0E, 0x94, 0xE8, 0x5F, 0x10, 0x8D, 0x7F, 0x00, 0x6F, 0x7F, 0x00, 0x6F, 0x5F,
  0x10, 0x8E, 0x1E, 0x94, 0xE9, 0x04, 0xDF, 0xD1, 0x00, 0x05, 0xF4, 0x00, 0x00, 0x66,
  // "R" (U+0052)
  0x4F, 0xFC, 0x30, 0x4F, 0x5C, 0xC0, 0x4F, 0x17, 0xF0, 0x4F, 0x2A, 0xC0, 0x4F, 0xFF, 0x30, 0x4F,
  0x6F, 0x30, 0x4F, 0x1B, 0xB0, 0x4F, 0x13, 0xF4,
  // "S" (U+0053)
  0x0A, 0xED, 0x26, 0xE4, 0x70, 0x8E, 0x10, 0x03, 0xFE, 0x40, 0x05, 0xEF, 0x20, 0x03, 0xF5, 0x65,
  0x6F, 0x37, 0xEE, 0x70,
  // "T" (U+0054)
  0xDF, 0xFF, 0x92, 0x7F, 0x31, 0x05, 0xF1, 0x00, 0x5F, 0x10, 0x05, 0xF1, 0x00, 0x5F, 0x10, 0x05,
  0xF1, 0x00, 0x5F, 0x10,
  // "U" (U+0055)
  0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xD8, 0x4F,
  0x10, 0xE7, 0x1F, 0x96, 0xF4, 0x06, 0xDE, 0x80,
  // "V" (U+0056)
  0xD8, 0x00, 0xF6, 0x9C, 0x03, 0xF2, 0x6F, 0x07, 0xE0, 0x2F, 0x3A, 0xA0, 0x0D, 0x6E, 0x60, 0x0A,
  0xBF, 0x20, 0x06, 0xFE, 0x00, 0x02, 0xFA, 0x00,
  // "W" (U+0057)
  0xD7, 0x08, 0xD0, 0x2F, 0x3A, 0xA0, 0xBF, 0x05, 0xF0, 0x7C, 0x0E, 0xE3, 0x8D, 0x04, 0xF2, 0xFA,
  0x6B, 0xA0, 0x1F, 0x7C, 0x79, 0xD7, 0x00, 0xEC, 0x94, 0xCF, 0x40, 0x0B, 0xF6, 0x1F, 0xF1, 0x00,
  0x8F, 0x30, 0xED, 0x00,
  // "X" (U+0058)
  0xAC, 0x08, 0xE0, 0x3F, 0x3D, 0x70, 0x0C, 0xCF, 0x10, 0x05, 0xFA, 0x00, 0x06, 0xFA, 0x00, 0x0D,
  0xBF, 0x20, 0x5F, 0x2D, 0x90, 0xBA, 0x06, 0xF1,
  // "Y" (U+0059)
  0xCA, 0x07, 0xE6, 0xF1, 0xD9, 0x1F, 0xAF, 0x30, 0xAF, 0xD0, 0x04, 0xF7, 0x00, 0x1F, 0x40, 0x01,
  0xF4, 0x00, 0x1F, 0x40,
  // "Z" (U+005A)
  0xAF, 0xFF, 0x72, 0x36, 0xF3, 0x00, 0xBB, 0x00, 0x2F, 0x40, 0x09, 0xD0, 0x01, 0xF6, 0x00, 0x8E,
  0x33, 0x1B, 0xFF, 0xF8,
  // "[" (U+005B)
  0x6F, 0xE6, 0xD2, 0x6C, 0x06, 0xC0, 0x6C, 0x06, 0xC0, 0x6C, 0x06, 0xC0, 0x6F, 0xE1, 0x22,
  // "\" (U+005C)
  0xB7, 0x00, 0x6C, 0x00, 0x1F, 0x20, 0x0B, 0x70, 0x06, 0xC0, 0x01, 0xF2, 0x00, 0xB7, 0x00, 0x6C,
  // "]" (U+005D)
  0xBF, 0x82, 0xB8, 0x0A, 0x80, 0xA8, 0x0A, 0x80, 0xA8, 0x0A, 0x80, 0xA8, 0xBF, 0x82, 0x21,
  // "^" (U+005E)
  0x00, 0xE2, 0x00, 0x6F, 0x80, 0x0C, 0x7E, 0x03, 0xE0, 0xB6, 0xA8, 0x04, 0xD0,
  // "_" (U+005F)
  0xFF, 0xFF, 0x92, 0x22, 0x21,
  // "`" (U+0060)
  0x37, 0x00, 0xA9,
  // "a" (U+0061)
  0x1C, 0xEB, 0x00, 0x54, 0xF5, 0x2D, 0xFF, 0x79, 0xD3, 0xE7, 0x9D, 0x5F, 0x73, 0xEB, 0xA7,
  // "b" (U+0062)
  0x5F, 0x00, 0x05, 0xF0, 0x00, 0x5E, 0xAE, 0x45, 0xF6, 0xBC, 0x5F, 0x06, 0xF5, 0xF0, 0x6F, 0x5F,
  0x6B, 0xC5, 0xDB, 0xE4,
  // "c" (U+0063)
  0x09, 0xEC, 0x5F, 0x44, 0x8C, 0x00, 0x8C, 0x00, 0x6F, 0x46, 0x0A, 0xEB,
  // "d" (U+0064)
  0x00, 0x09, 0xB0, 0x00, 0x8B, 0x0B, 0xDB, 0xB6, 0xF4, 0xDB, 0x8C, 0x08, 0xB8, 0xC0, 0x8B, 0x6F,
  0x4D, 0xB0, 0xBD, 0x9B,
  // "e" (U+0065)
  0x0A, 0xEB, 0x05, 0xE4, 0xD7, 0x8F, 0xFF, 0x98, 0xC2, 0x21, 0x5F, 0x54, 0x30, 0x9E, 0xD3,
  // "f" (U+0066)
  0x0B, 0xF5, 0x2F, 0x61, 0xBF, 0xF2, 0x5F, 0x50, 0x3F, 0x20, 0x3F, 0x20, 0x3F, 0x20, 0x3F, 0x20,
  // "g" (U+0067)
  0x0B, 0xDA, 0xB6, 0xF4, 0xDB, 0x8C, 0x09, 0xB8, 0xC0, 0x8B, 0x6F, 0x4D, 0xB0, 0xCD, 0xBB, 0x00,
  0x09, 0xB3, 0x64, 0xD7, 0x3E, 0xEA, 0x10,
  // "h" (U+0068)
  0x5F, 0x00, 0x05, 0xF0, 0x00, 0x5E, 0xAE, 0x55, 0xF6, 0xBC, 0x5F, 0x07, 0xD5, 0xF0, 0x7D, 0x5F,
  0x07, 0xD5, 0xF0, 0x7D,
  // "i" (U+0069)
  0x4D, 0x01, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F,
  // "j" (U+006A)
  0x04, 0xD0, 0x01, 0x05, 0xF0, 0x5F, 0x05, 0xF0, 0x5F, 0x05, 0xF0, 0x5F, 0x05, 0xF1, 0x9E, 0x5E,
  0x70,
  // "k" (U+006B)
  0x5F, 0x00, 0x05, 0xF0, 0x00, 0x5F, 0x0A, 0xB5, 0xF5, 0xF2, 0x5E, 0xD9, 0x05, 0xFD, 0xE0, 0x5F,
  0x1E, 0x65, 0xF0, 0x8E,
  // "l" (U+006C)
  0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F,
  // "m" (U+006D)
  0x5B, 0xAE, 0x4C, 0xD2, 0x5F, 0x6C, 0xF4, 0xE7, 0x5F, 0x09, 0xC0, 0xC8, 0x5F, 0x09, 0xC0, 0xC8,
  0x5F, 0x09, 0xC0, 0xC8, 0x5F, 0x09, 0xC0, 0xC8,
  // "n" (U+006E)
  0x5C, 0xAE, 0x55, 0xF6, 0xBC, 0x5F, 0x07, 0xD5, 0xF0, 0x7D, 0x5F, 0x07, 0xD5, 0xF0, 0x7D,
  // "o" (U+006F)
  0x0A, 0xEB, 0x15, 0xF4, 0xC9, 0x8C, 0x08, 0xC8, 0xC0, 0x8C, 0x5F, 0x4C, 0x90, 0x9E, 0xC1,
  // "p" (U+0070)
  0x8B, 0x55, 0xDA, 0xE4, 0x5F, 0x6B, 0xC5, 0xF0, 0x6F, 0x5F, 0x06, 0xF5, 0xF6, 0xBC, 0x5F, 0xAE,
  0x45, 0x93, 0x05, 0x93, 0x05, 0x93,
  // "q" (U+0071)
  0x0B, 0xDA, 0xB6, 0xF4, 0xDB, 0x8C, 0x09, 0xB8, 0xC0, 0x8B, 0x6F, 0x4D, 0xB0, 0xCD, 0xBB, 0x00,
  0x09, 0xB0, 0x00, 0x9B, 0x00, 0x09, 0xB0,
  // "r" (U+0072)
  0x5C, 0xA9, 0x5F, 0x82, 0x5F, 0x00, 0x5F, 0x00, 0x5F, 0x00, 0x5F, 0x00,
  // "s" (U+0073)
  0x3D, 0xE7, 0x9C, 0x43, 0x6F, 0x80, 0x05, 0xE9, 0x54, 0xBB, 0x8E, 0xD4,
  // "t" (U+0074)
  0x0E, 0x10, 0x9F, 0xF3, 0x6F, 0x40, 0x4F, 0x10, 0x4F, 0x10, 0x3F, 0x61, 0x0C, 0xE3,
  // "u" (U+0075)
  0x6F, 0x07, 0xD6, 0xF0, 0x7D, 0x6F, 0x07, 0xD6, 0xF0, 0x8D, 0x4F, 0x4C, 0xD0, 0xCE, 0x9D,
  // "v" (U+0076)
  0xD8, 0x0B, 0xA8, 0xC0, 0xE5, 0x4F, 0x3F, 0x10, 0xFA, 0xC0, 0x0B, 0xE8, 0x00, 0x7F, 0x40,
  // "w" (U+0077)
  0xC8, 0x2F, 0x82, 0xF2, 0x9B, 0x5E, 0xB5, 0xE0, 0x6D, 0x89, 0xE8, 0xB0, 0x3F, 0xB4, 0xFB, 0x80,
  0x0E, 0xF1, 0xCF, 0x40, 0x0B, 0xE0, 0x9F, 0x10,
  // "x" (U+0078)
  0x9C, 0x1F, 0x62, 0xFA, 0xE0, 0x0A, 0xF7, 0x00, 0xBF, 0x80, 0x3F, 0x9E, 0x0A, 0xB0, 0xE7,
  // "y" (U+0079)
  0xD8, 0x0B, 0xA8, 0xC0, 0xE6, 0x4F, 0x3F, 0x20, 0xFA, 0xD0, 0x0B, 0xE9, 0x00, 0x7F, 0x50, 0x04,
  0xF1, 0x02, 0xBB, 0x00, 0x9D, 0x30, 0x00,
  // "z" (U+007A)
  0xAF, 0xFA, 0x23, 0xF6, 0x07, 0xE0, 0x0E, 0x70, 0x7E, 0x32, 0xCF, 0xFB,
  // "{" (U+007B)
  0x04, 0xE6, 0x0A, 0xB1, 0x0A, 0x80, 0x1C, 0x70, 0xCE, 0x20, 0x3D, 0x70, 0x0A, 0x80, 0x0A, 0xA0,
  0x06, 0xF6, 0x00, 0x11,
  // "|" (U+007C)
  0x4D, 0x4D, 0x4D, 0x4D, 0x4D, 0x4D, 0x4D, 0x4D, 0x4D, 0x4D, 0x4D,
  // "}" (U+007D)
  0xAC, 0x10, 0x3E, 0x60, 0x0C, 0x60, 0x0B, 0x90, 0x05, 0xF8, 0x0B, 0xB1, 0x0C, 0x60, 0x1D, 0x60,
  0xAF, 0x20, 0x10, 0x00,
  // "~" (U+007E)
  0x5E, 0x91, 0x57, 0x4B, 0xF7, 0x00, 0x01, 0x00,
  // "¡" (U+00A1)
  0x4E, 0x00, 0x20, 0x4D, 0x04, 0xE0, 0x5F, 0x06, 0xF0, 0x6F, 0x10,
  // "¢" (U+00A2)
  0x00, 0x92, 0x00, 0x7F, 0xE2, 0x2F, 0x74, 0x04, 0xF1, 0x00, 0x4F, 0x10, 0x02, 0xF6, 0x41, 0x08,
  0xFD, 0x20, 0x09, 0x20,
  // "£" (U+00A3)
  0x04, 0xDE, 0x50, 0xBB, 0x42, 0x0D, 0x80, 0x09, 0xFF, 0xE0, 0x1D, 0x92, 0x00, 0xD7, 0x00, 0x4F,
  0x53, 0x28, 0xFF, 0xFA,
  // "¤" (U+00A4)
  0x01, 0x00, 0x15, 0xDE, 0xCD, 0x0D, 0x49, 0x81, 0xD1, 0x69, 0x4E, 0xFE, 0xC1, 0x21, 0x04,
  // "¥" (U+00A5)
  0xBB, 0x0B, 0xA5, 0xF2, 0xF4, 0x0E, 0xBE, 0x00, 0x9F, 0x90, 0x5F, 0xFF, 0x51, 0x5F, 0x51, 0x5F,
  0xFF, 0x51, 0x5F, 0x51,
  // "¦" (U+00A6)
  0x4D, 0x4D, 0x4D, 0x4D, 0x00, 0x00, 0x00, 0x4D, 0x4D, 0x4D, 0x4D,
  // "§" (U+00A7)
  0x2C, 0xE8, 0x6C, 0x44, 0x2E, 0x91, 0x6A, 0x9B, 0x5D, 0x8A, 0x04, 0xD8, 0x44, 0x8C, 0x5E, 0xE5,
  // "¨" (U+00A8)
  0xC3, 0xE1, 0x10, 0x10,
  // "©" (U+00A9)
  0x00, 0x8E, 0xFB, 0x20, 0x0A, 0xA4, 0x38, 0xD1, 0x4A, 0x1C, 0xE6, 0x68, 0x73, 0x99, 0x32, 0x0B,
  0x83, 0xB3, 0x00, 0x0B, 0x58, 0x97, 0x11, 0x49, 0x0C, 0x9D, 0xFB, 0xD2, 0x01, 0xCF, 0xFD, 0x30,
  0x00, 0x01, 0x20, 0x00,
  // "ª" (U+00AA)
  0x5C, 0xA2, 0x7F, 0xB6, 0xF6, 0xBB,
  // "«" (U+00AB)
  0x06, 0x83, 0xB3, 0xF4, 0xD8, 0x7E, 0x4F, 0x30, 0xC8, 0x8C, 0x02, 0x30, 0x40,
  // "¬" (U+00AC)
  0x9F, 0xFF, 0x91, 0x22, 0x89, 0x00, 0x07, 0x90, 0x00, 0x11,
  // "®" (U+00AE)
  0x00, 0x8E, 0xFB, 0x20, 0x0A, 0xA4, 0x38, 0xD1, 0x4A, 0x5F, 0xE4, 0x68, 0x73, 0x5A, 0x99, 0x0B,
  0x83, 0x5F, 0xF4, 0x0B, 0x58, 0x5A, 0xA6, 0x49, 0x0C, 0x94, 0x19, 0xD2, 0x01, 0xCF, 0xFD, 0x30,
  0x00, 0x01, 0x20, 0x00,
  // "¯" (U+00AF)
  0xC0, 0xC8, 0x01, 0x20,
  // "°" (U+00B0)
  0x3E, 0xC1, 0x98, 0xA6, 0x5F, 0xE2, 0x01, 0x00,
  // "±" (U+00B1)
  0x29, 0x49, 0x20, 0x9B, 0x84, 0xA1, 0x3F, 0x31, 0x29, 0x28, 0x42, 0x33, 0x32, 0x9B, 0x0A,
  // "²" (U+00B2)
  0x6D, 0x90, 0x22, 0xE0, 0x08, 0x90, 0x4D, 0x10, 0xAE, 0xD1,
  // "³" (U+00B3)
  0x6D, 0x91, 0x1D, 0x0E, 0x91, 0x0E, 0x8D, 0x90,
  // "´" (U+00B4)
  0x2D, 0x51, 0x10,
  // "µ" (U+00B5)
  0x8B, 0x55, 0xF0, 0x7D, 0x5F, 0x07, 0xD5, 0xF0, 0x7D, 0x5F, 0x08, 0xD5, 0xF5, 0xCD, 0x5F, 0xEA,
  0xD5, 0x93, 0x05, 0x93, 0x05, 0x93,
  // "¶" (U+00B6)
  0x0B, 0xFF, 0xB5, 0xFF, 0x7B, 0x7F, 0xF5, 0xB7, 0xFF, 0x5B, 0x4F, 0xF5, 0xB0, 0x6B, 0x5B, 0x00,
  0x65, 0xB0, 0x06, 0x5B, 0x00, 0x65, 0xB0, 0x04, 0x38,
  // "·" (U+00B7)
  0x01, 0x4E,
  // "¸" (U+00B8)
  0x06, 0x10, 0x7B, 0x2D, 0x80,
  // "¹" (U+00B9)
  0x1B, 0x94, 0x99, 0x06, 0x90, 0x69,
  // "º" (U+00BA)
  0x4C, 0xA0, 0xA3, 0xC2, 0xA4, 0xC2, 0x3B, 0x80,
  // "»" (U+00BB)
  0x59, 0x2C, 0x00, 0x1E, 0x6B, 0xA0, 0x0B, 0xB7, 0xE1, 0x5E, 0x3E, 0x50, 0x13, 0x04, 0x00,
  // "¼" (U+00BC)
  0x0C, 0x70, 0x0D, 0x30, 0x7C, 0x70, 0x4C, 0x00, 0x08, 0x70, 0xB5, 0x00, 0x08, 0x73, 0xD0, 0x94,
  0x08, 0x7A, 0x65, 0xE6, 0x00, 0x2D, 0x1B, 0x96, 0x00, 0x97, 0x4D, 0xED, 0x01, 0xD0, 0x00, 0x85,
  // "½" (U+00BD)
  0x1C, 0x70, 0x0D, 0x20, 0x7B, 0x70, 0x5A, 0x00, 0x08, 0x70, 0xC3, 0x00, 0x08, 0x74, 0xC8, 0xE7,
  0x08, 0x7B, 0x55, 0x7B, 0x00, 0x2D, 0x00, 0x96, 0x00, 0x97, 0x06, 0xA0, 0x01, 0xE0, 0x0E, 0xFE,
  0x01, 0x20, 0x02, 0x22,
  // "¾" (U+00BE)
  0x5D, 0x90, 0x0A, 0x50, 0x11, 0xE0, 0x2D, 0x00, 0x0E, 0x90, 0x97, 0x00, 0x21, 0xE2, 0xE0, 0x85,
  0x9F, 0xD8, 0x84, 0xE7, 0x02, 0x1E, 0x1B, 0x97, 0x00, 0x79, 0x2D, 0xEE, 0x00, 0xC2, 0x00, 0x76,
  // "¿" (U+00BF)
  0x05, 0xD0, 0x00, 0x10, 0x03, 0xA0, 0x0A, 0xB0, 0x6F, 0x30, 0xB9, 0x00, 0xBB, 0x46, 0x3D, 0xE8,
  // "À" (U+00C0)
  0x10, 0x30, 0x75, 0x0A, 0x09, 0x72, 0x81, 0x2F, 0xD3, 0x82, 0x6E, 0xF2, 0x28, 0x2A, 0xAE, 0x52,
  0x89, 0x2D, 0x7B, 0x90, 0x2F, 0x58, 0xD0, 0x6C, 0x87, 0x19, 0xD3, 0x4F, 0x5D, 0x92, 0x0D, 0x09,
  // "Á" (U+00C1)
  0x00, 0x2D, 0x50, 0x00, 0x11, 0x00, 0x02, 0xFD, 0x00, 0x06, 0xEF, 0x20, 0x0A, 0xAE, 0x50, 0x0D,
  0x7B, 0x90, 0x2F, 0x58, 0xD0, 0x6F, 0xFF, 0xF1, 0x9D, 0x34, 0xF5, 0xD9, 0x00, 0xD9,
  // "Â" (U+00C2)
  0x00, 0x57, 0x00, 0x04, 0xB9, 0x70, 0x00, 0x00, 0x00, 0x02, 0xFD, 0x00, 0x06, 0xEF, 0x20, 0x0A,
  0xAE, 0x50, 0x0D, 0x7B, 0x90, 0x2F, 0x58, 0xD0, 0x6F, 0xFF, 0xF1, 0x9D, 0x34, 0xF5, 0xD9, 0x00,
  0xD9,
  // "Ã" (U+00C3)
  0x03, 0xC2, 0xB0, 0x08, 0x6D, 0x90, 0x01, 0x00, 0x00, 0x02, 0xFD, 0x00, 0x06, 0xEF, 0x20, 0x0A,
  0xAE, 0x50, 0x0D, 0x7B, 0x90, 0x2F, 0x58, 0xD0, 0x6F, 0xFF, 0xF1, 0x9D, 0x34, 0xF5, 0xD9, 0x00,
  0xD9,
  // "Ä" (U+00C4)
  0x0C, 0x3E, 0x10, 0x01, 0x01, 0x00, 0x02, 0xFD, 0x00, 0x06, 0xEF, 0x20, 0x0A, 0xAE, 0x50, 0x0D,
  0x7B, 0x90, 0x2F, 0x58, 0xD0, 0x6F, 0xFF, 0xF1, 0x9D, 0x34, 0xF5, 0xD9, 0x00, 0xD9,
  // "Å" (U+00C5)
  0x04, 0xE6, 0x00, 0x0B, 0xFF, 0x00, 0x0B, 0xFF, 0x20, 0x0A, 0xCE, 0x50, 0x0D, 0x7B, 0x90, 0x2F,
  0x58, 0xD0, 0x6F, 0xFF, 0xF1, 0x9D, 0x34, 0xF5, 0xD9, 0x00, 0xD9,
  // "Æ" (U+00C6)
  0x00, 0xAF, 0xFF, 0xF3, 0x00, 0xEA, 0xF4, 0x30, 0x04, 0xF5, 0xF2, 0x00, 0x09, 0xC4, 0xFF, 0xF1,
  0x0E, 0x84, 0xF4, 0x20, 0x3F, 0xFF, 0xF1, 0x00, 0x8E, 0x26, 0xF4, 0x30, 0xD9, 0x04, 0xFF, 0xF3,
  // "Ç" (U+00C7)
  0x03, 0xDE, 0xA0, 0xEA, 0x46, 0x5F, 0x20, 0x07, 0xF0, 0x00, 0x7F, 0x00, 0x05, 0xF1, 0x00, 0x0E,
  0xA3, 0x50, 0x5D, 0xF9, 0x00, 0x61, 0x00, 0x07, 0xB0, 0x02, 0xD8, 0x00,
  // "È" (U+00C8)
  0x03, 0x07, 0x40, 0xA0, 0x97, 0x04, 0xB8, 0x73, 0x4F, 0x43, 0x04, 0xF2, 0x20, 0x4B, 0x18, 0x64,
  0xF4, 0x20, 0x4F, 0x12, 0x84, 0x4F, 0x43, 0x04, 0xB0, 0x30,
  // "É" (U+00C9)
  0x02, 0xD5, 0x00, 0x11, 0x00, 0x4F, 0xFF, 0x34, 0xF4, 0x30, 0x4F, 0x20, 0x04, 0xFF, 0xF0, 0x4F,
  0x42, 0x04, 0xF1, 0x00, 0x4F, 0x43, 0x04, 0xFF, 0xF3,
  // "Ê" (U+00CA)
  0x10, 0x50, 0x72, 0x82, 0x4B, 0x97, 0x60, 0x4B, 0x87, 0x34, 0xF4, 0x30, 0x4F, 0x22, 0x04, 0xB1,
  0x86, 0x4F, 0x42, 0x04, 0xF1, 0x28, 0x44, 0xF4, 0x30, 0x4B, 0x03,
  // "Ë" (U+00CB)
  0x0C, 0x3E, 0x10, 0x10, 0x10, 0x4F, 0xFF, 0x34, 0xF4, 0x30, 0x4F, 0x20, 0x04, 0xFF, 0xF0, 0x4F,
  0x42, 0x04, 0xF1, 0x00, 0x4F, 0x43, 0x04, 0xFF, 0xF3,
  // "Ì" (U+00CC)
  0x37, 0x00, 0x0A, 0x90, 0x00, 0x00, 0xAF, 0xF2, 0x1F, 0x80, 0x0F, 0x60, 0x0F, 0x60, 0x0F, 0x60,
  0x0F, 0x60, 0x0F, 0x70, 0xAF, 0xF2,
  // "Í" (U+00CD)
  0x02, 0xD5, 0x01, 0x10, 0xAF, 0xF2, 0x1F, 0x80, 0x0F, 0x60, 0x0F, 0x60, 0x0F, 0x60, 0x0F, 0x60,
  0x0F, 0x70, 0xAF, 0xF2,
  // "Î" (U+00CE)
  0x05, 0x70, 0x4B, 0x97, 0x00, 0x00, 0xAF, 0xF2, 0x1F, 0x80, 0x0F, 0x60, 0x0F, 0x60, 0x0F, 0x60,
  0x0F, 0x60, 0x0F, 0x70, 0xAF, 0xF2,
  // "Ï" (U+00CF)
  0xC3, 0xE1, 0x10, 0x10, 0xAF, 0xF2, 0x1F, 0x80, 0x0F, 0x60, 0x0F, 0x60, 0x0F, 0x60, 0x0F, 0x60,
  0x0F, 0x70, 0xAF, 0xF2,
  // "Ð" (U+00D0)
  0x4F, 0xFC, 0x40, 0x4F, 0x49, 0xF1, 0x4F, 0x20, 0xE7, 0xDF, 0xF0, 0xC9, 0x6F, 0x40, 0xD9, 0x4F,
  0x10, 0xF6, 0x4F, 0x59, 0xE1, 0x4F, 0xFD, 0x40,
  // "Ñ" (U+00D1)
  0x03, 0xC2, 0xB0, 0x00, 0x86, 0xD9, 0x00, 0x01, 0x00, 0x00, 0x04, 0xF9, 0x03, 0xF1, 0x4F, 0xF1,
  0x3F, 0x14, 0xFE, 0x73, 0xF1, 0x4F, 0x8D, 0x3F, 0x14, 0xF2, 0xF8, 0xF1, 0x4F, 0x0A, 0xEF, 0x14,
  0xF0, 0x4F, 0xF1, 0x4F, 0x00, 0xCF, 0x10,
  // "Ò" (U+00D2)
  0x03, 0x70, 0x00, 0x00, 0xA9, 0x00, 0x00, 0x00, 0x00, 0x05, 0xDE, 0xA0, 0x0E, 0x94, 0xE8, 0x5F,
  0x10, 0x8D, 0x7F, 0x00, 0x6F, 0x7F, 0x00, 0x6F, 0x5F, 0x10, 0x8D, 0x1E, 0x94, 0xE8, 0x04, 0xDE,
  0xA0,
  // "Ó" (U+00D3)
  0x00, 0x2D, 0x50, 0x00, 0x11, 0x00, 0x05, 0xDE, 0xA0, 0x0E, 0x94, 0xE8, 0x5F, 0x10, 0x8D, 0x7F,
  0x00, 0x6F, 0x7F, 0x00, 0x6F, 0x5F, 0x10, 0x8D, 0x1E, 0x94, 0xE8, 0x04, 0xDE, 0xA0,
  // "Ô" (U+00D4)
  0x00, 0x57, 0x00, 0x04, 0xB9, 0x70, 0x00, 0x00, 0x00, 0x05, 0xDE, 0xA0, 0x0E, 0x94, 0xE8, 0x5F,
  0x10, 0x8D, 0x7F, 0x00, 0x6F, 0x7F, 0x00, 0x6F, 0x5F, 0x10, 0x8D, 0x1E, 0x94, 0xE8, 0x04, 0xDE,
  0xA0,
  // "Õ" (U+00D5)
  0x03, 0xC2, 0xB0, 0x08, 0x6D, 0x90, 0x01, 0x00, 0x00, 0x05, 0xDE, 0xA0, 0x0E, 0x94, 0xE8, 0x5F,
  0x10, 0x8D, 0x7F, 0x00, 0x6F, 0x7F, 0x00, 0x6F, 0x5F, 0x10, 0x8D, 0x1E, 0x94, 0xE8, 0x04, 0xDE,
  0xA0,
  // "Ö" (U+00D6)
  0x00, 0xC3, 0xE1, 0x00, 0x10, 0x10, 0x05, 0xDE, 0xA0, 0x0E, 0x94, 0xE8, 0x5F, 0x10, 0x8D, 0x7F,
  0x00, 0x6F, 0x7F, 0x00, 0x6F, 0x5F, 0x10, 0x8D, 0x1E, 0x94, 0xE8, 0x04, 0xDE, 0xA0,
  // "×" (U+00D7)
  0x14, 0x04, 0x13, 0xE8, 0xE3, 0x07, 0xF7, 0x03, 0xE7, 0xE3, 0x13, 0x03, 0x10,
  // "Ø" (U+00D8)
  0x58, 0xD6, 0x10, 0x4D, 0xEC, 0x70, 0xE9, 0x5F, 0x95, 0xF1, 0x5E, 0xE7, 0xF0, 0xC7, 0xF7, 0xE5,
  0x86, 0xF5, 0xFD, 0x18, 0xD1, 0xFB, 0x4E, 0x80, 0xCD, 0xFA, 0x20, 0x34,
  // "Ù" (U+00D9)
  0x10, 0x30, 0x75, 0x0A, 0x09, 0x71, 0x8D, 0x54, 0xF1, 0x0D, 0x84, 0xF1, 0x0D, 0x84, 0xF1, 0x0D,
  0x84, 0xF1, 0x0D, 0x84, 0xF1, 0x0D, 0x84, 0xF1, 0x0E, 0x71, 0xF9, 0x6F, 0x40, 0x6D, 0xE8, 0x10,
  // "Ú" (U+00DA)
  0x00, 0x2D, 0x50, 0x00, 0x11, 0x00, 0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xD8, 0x4F,
  0x10, 0xD8, 0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xE7, 0x1F, 0x96, 0xF4, 0x06, 0xDE, 0x80,
  // "Û" (U+00DB)
  0x20, 0x50, 0x73, 0x82, 0x4B, 0x97, 0x78, 0xD5, 0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xD8, 0x4F, 0x10,
  0xD8, 0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xE7, 0x1F, 0x96, 0xF4, 0x06, 0xDE, 0x81,
  // "Ü" (U+00DC)
  0x00, 0xC3, 0xE1, 0x00, 0x10, 0x10, 0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xD8, 0x4F,
  0x10, 0xD8, 0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xE7, 0x1F, 0x96, 0xF4, 0x06, 0xDE, 0x80,
  // "Ý" (U+00DD)
  0x00, 0x2D, 0x50, 0x01, 0x10, 0xCA, 0x07, 0xE6, 0xF1, 0xD9, 0x1F, 0xAF, 0x30, 0xAF, 0xD0, 0x04,
  0xF7, 0x00, 0x1F, 0x40, 0x01, 0xF4, 0x00, 0x1F, 0x40,
  // "Þ" (U+00DE)
  0x4F, 0x10, 0x04, 0xF2, 0x00, 0x4F, 0xFD, 0x44, 0xF4, 0xBD, 0x4F, 0x2A, 0xC4, 0xFF, 0xF5, 0x4F,
  0x41, 0x04, 0xF1, 0x00,
  // "ß" (U+00DF)
  0x08, 0xED, 0x60, 0x3F, 0x69, 0xF0, 0x5F, 0x09, 0xC0, 0x5F, 0x4F, 0x20, 0x5F, 0x3F, 0x80, 0x5F,
  0x05, 0xF5, 0x5F, 0x34, 0xE8, 0x5F, 0x6F, 0xD2,
  // "à" (U+00E0)
  0x03, 0x70, 0x00, 0x0A, 0x90, 0x00, 0x00, 0x01, 0xCE, 0xB0, 0x05, 0x4F, 0x52, 0xDF, 0xF7, 0x9D,
  0x3E, 0x79, 0xD5, 0xF7, 0x3E, 0xBA, 0x70,
  // "á" (U+00E1)
  0x02, 0xD5, 0x00, 0x11, 0x00, 0x1C, 0xEB, 0x00, 0x54, 0xF5, 0x2D, 0xFF, 0x79, 0xD3, 0xE7, 0x9D,
  0x5F, 0x73, 0xEB, 0xA7,
  // "â" (U+00E2)
  0x05, 0x70, 0x04, 0xB9, 0x70, 0x00, 0x00, 0x01, 0xCE, 0xB0, 0x05, 0x4F, 0x52, 0xDF, 0xF7, 0x9D,
  0x3E, 0x79, 0xD5, 0xF7, 0x3E, 0xBA, 0x70,
  // "ã" (U+00E3)
  0x3C, 0x2B, 0x08, 0x6D, 0x90, 0x10, 0x00, 0x01, 0xCE, 0xB0, 0x05, 0x4F, 0x52, 0xDF, 0xF7, 0x9D,
  0x3E, 0x79, 0xD5, 0xF7, 0x3E, 0xBA, 0x70,
  // "ä" (U+00E4)
  0x0C, 0x3E, 0x10, 0x10, 0x10, 0x1C, 0xEB, 0x00, 0x54, 0xF5, 0x2D, 0xFF, 0x79, 0xD3, 0xE7, 0x9D,
  0x5F, 0x73, 0xEB, 0xA7,
  // "å" (U+00E5)
  0x04, 0xE6, 0x00, 0x87, 0xB0, 0x05, 0xF8, 0x01, 0xCF, 0xB0, 0x05, 0x4F, 0x52, 0xDF, 0xF7, 0x9D,
  0x3E, 0x79, 0xD5, 0xF7, 0x3E, 0xBA, 0x70,
  // "æ" (U+00E6)
  0x1C, 0xE9, 0xCE, 0x70, 0x05, 0x4F, 0xA6, 0xF1, 0x2D, 0xFF, 0xFF, 0xF3, 0x9D, 0x3E, 0x82, 0x20,
  0x9D, 0x5F, 0xC3, 0x60, 0x3E, 0xD3, 0xCF, 0xC0,
  // "ç" (U+00E7)
  0x09, 0xEC, 0x5F, 0x44, 0x8C, 0x00, 0x8C, 0x00, 0x6F, 0x46, 0x0A, 0xEB, 0x00, 0x61, 0x00, 0x7B,
  0x02, 0xD8,
  // "è" (U+00E8)
  0x10, 0x30, 0x74, 0x0A, 0x09, 0x78, 0x90, 0xAE, 0xB0, 0x5E, 0x4D, 0x78, 0xB8, 0x96, 0x98, 0xC2,
  0x21, 0x5F, 0x54, 0x30, 0x9E, 0xD3,
  // "é" (U+00E9)
  0x02, 0xD5, 0x00, 0x11, 0x00, 0x0A, 0xEB, 0x05, 0xE4, 0xD7, 0x8F, 0xFF, 0x98, 0xC2, 0x21, 0x5F,
  0x54, 0x30, 0x9E, 0xD3,
  // "ê" (U+00EA)
  0x05, 0x70, 0x04, 0xB9, 0x70, 0x00, 0x00, 0x00, 0xAE, 0xB0, 0x5E, 0x4D, 0x78, 0xFF, 0xF9, 0x8C,
  0x22, 0x15, 0xF5, 0x43, 0x09, 0xED, 0x30,
  // "ë" (U+00EB)
  0x0C, 0x3E, 0x10, 0x10, 0x10, 0x0A, 0xEB, 0x05, 0xE4, 0xD7, 0x8F, 0xFF, 0x98, 0xC2, 0x21, 0x5F,
  0x54, 0x30, 0x9E, 0xD3,
  // "ì" (U+00EC)
  0x37, 0x00, 0xA9, 0x00, 0x00, 0x5F, 0x05, 0xF0, 0x5F, 0x05, 0xF0, 0x5F, 0x05, 0xF0,
  // "í" (U+00ED)
  0x2D, 0x51, 0x10, 0x5F, 0x05, 0xF0, 0x5F, 0x05, 0xF0, 0x5F, 0x05, 0xF0,
  // "î" (U+00EE)
  0x05, 0x70, 0x4B, 0x97, 0x00, 0x00, 0x05, 0xF0, 0x05, 0xF0, 0x05, 0xF0, 0x05, 0xF0, 0x05, 0xF0,
  0x05, 0xF0,
  // "ï" (U+00EF)
  0xC3, 0xE1, 0x10, 0x10, 0x5F, 0x00, 0x5F, 0x00, 0x5F, 0x00, 0x5F, 0x00, 0x5F, 0x00, 0x5F, 0x00,
  // "ð" (U+00F0)
  0x04, 0xAB, 0x10, 0x4F, 0xC0, 0x02, 0x3E, 0x50, 0xBF, 0xEA, 0x7E, 0x4C, 0xD9, 0xC0, 0x8D, 0x6E,
  0x4C, 0x90, 0xAE, 0xC1,
  // "ñ" (U+00F1)
  0x03, 0xC2, 0xB0, 0x86, 0xD9, 0x01, 0x00, 0x05, 0xCA, 0xE5, 0x5F, 0x6B, 0xC5, 0xF0, 0x7D, 0x5F,
  0x07, 0xD5, 0xF0, 0x7D, 0x5F, 0x07, 0xD0,
  // "ò" (U+00F2)
  0x10, 0x30, 0x74, 0x0A, 0x09, 0x78, 0xB3, 0xAE, 0xB1, 0x5F, 0x4C, 0x98, 0xC0, 0x8C, 0x8C, 0x08,
  0xC5, 0xF4, 0xC9, 0x09, 0xEC, 0x10,
  // "ó" (U+00F3)
  0x02, 0xD5, 0x00, 0x11, 0x00, 0x0A, 0xEB, 0x15, 0xF4, 0xC9, 0x8C, 0x08, 0xC8, 0xC0, 0x8C, 0x5F,
  0x4C, 0x90, 0x9E, 0xC1,
  // "ô" (U+00F4)
  0x00, 0x57, 0x00, 0x4B, 0x97, 0x00, 0x00, 0x00, 0xAE, 0xB1, 0x5F, 0x4C, 0x98, 0xC0, 0x8C, 0x8C,
  0x08, 0xC5, 0xF4, 0xC9, 0x09, 0xEC, 0x10,
  // "õ" (U+00F5)
  0x3C, 0x2B, 0x08, 0x6D, 0x90, 0x10, 0x00, 0x00, 0xAE, 0xB1, 0x5F, 0x4C, 0x98, 0xC0, 0x8C, 0x8C,
  0x08, 0xC5, 0xF4, 0xC9, 0x09, 0xEC, 0x10,
  // "ö" (U+00F6)
  0x0C, 0x3E, 0x10, 0x10, 0x10, 0x0A, 0xEB, 0x15, 0xF4, 0xC9, 0x8C, 0x08, 0xC8, 0xC0, 0x8C, 0x5F,
  0x4C, 0x90, 0x9E, 0xC1,
  // "÷" (U+00F7)
  0x01, 0xE1, 0x00, 0x02, 0x00, 0x9F, 0xFF, 0xA1, 0x22, 0x21, 0x01, 0xE1, 0x00, 0x01, 0x00,
  // "ø" (U+00F8)
  0x48, 0xB7, 0x10, 0x9E, 0xD6, 0x5E, 0x5F, 0x98, 0xB7, 0xCC, 0x8C, 0xB7, 0xC4, 0xF8, 0xC9, 0x1E,
  0xEB, 0x11, 0x23,
  // "ù" (U+00F9)
  0x10, 0x30, 0x74, 0x0A, 0x09, 0x68, 0xB4, 0x6F, 0x07, 0xD6, 0xF0, 0x7D, 0x6F, 0x07, 0xD6, 0xF0,
  0x8D, 0x4F, 0x4C, 0xD0, 0xCE, 0x9D,
  // "ú" (U+00FA)
  0x00, 0x2D, 0x50, 0x01, 0x10, 0x6F, 0x07, 0xD6, 0xF0, 0x7D, 0x6F, 0x07, 0xD6, 0xF0, 0x8D, 0x4F,
  0x4C, 0xD0, 0xCE, 0x9D,
  // "û" (U+00FB)
  0x00, 0x57, 0x00, 0x4B, 0x97, 0x00, 0x00, 0x06, 0xF0, 0x7D, 0x6F, 0x07, 0xD6, 0xF0, 0x7D, 0x6F,
  0x08, 0xD4, 0xF4, 0xCD, 0x0C, 0xE9, 0xD0,
  // "ü" (U+00FC)
  0x0C, 0x3E, 0x10, 0x10, 0x10, 0x6F, 0x07, 0xD6, 0xF0, 0x7D, 0x6F, 0x07, 0xD6, 0xF0, 0x8D, 0x4F,
  0x4C, 0xD0, 0xCE, 0x9D,
  // "ý" (U+00FD)
  0x02, 0xD5, 0x00, 0x11, 0x00, 0xD8, 0x0B, 0xA8, 0xC0, 0xE6, 0x4F, 0x3F, 0x20, 0xFA, 0xD0, 0x0B,
  0xE9, 0x00, 0x7F, 0x50, 0x04, 0xF1, 0x02, 0xBB, 0x00, 0x9D, 0x30, 0x00,
  // "þ" (U+00FE)
  0x05, 0x93, 0x05, 0x93, 0x8B, 0x55, 0xFA, 0xE4, 0x5F, 0x6B, 0xC5, 0xF0, 0x6F, 0x5F, 0x06, 0xF5,
  0xF6, 0xBC, 0x5F, 0xAE, 0x45, 0x93, 0x05, 0x93, 0x05, 0x93,
  // "ÿ" (U+00FF)
  0x0C, 0x3E, 0x10, 0x10, 0x10, 0xD8, 0x0B, 0xA8, 0xC0, 0xE6, 0x4F, 0x3F, 0x20, 0xFA, 0xD0, 0x0B,
  0xE9, 0x00, 0x7F, 0x50, 0x04, 0xF1, 0x02, 0xBB, 0x00, 0x9D, 0x30, 0x00,
  // "Ā" (U+0100)
  0x09, 0xFF, 0x50, 0x01, 0x22, 0x00, 0x02, 0xFD, 0x00, 0x06, 0xEF, 0x20, 0x0A, 0xAE, 0x50, 0x0D,
  0x7B, 0x90, 0x2F, 0x58, 0xD0, 0x6F, 0xFF, 0xF1, 0x9D, 0x34, 0xF5, 0xD9, 0x00, 0xD9,
  // "ā" (U+0101)
  0x09, 0xFF, 0x50, 0x12, 0x20, 0x1C, 0xEB, 0x00, 0x54, 0xF5, 0x2D, 0xFF, 0x79, 0xD3, 0xE7, 0x9D,
  0x5F, 0x73, 0xEB, 0xA7,
  // "Ă" (U+0102)
  0x06, 0x55, 0x60, 0x03, 0xFE, 0x30, 0x00, 0x11, 0x00, 0x02, 0xFD, 0x00, 0x06, 0xEF, 0x20, 0x0A,
  0xAE, 0x50, 0x0D, 0x7B, 0x90, 0x2F, 0x58, 0xD0, 0x6F, 0xFF, 0xF1, 0x9D, 0x34, 0xF5, 0xD9, 0x00,
  0xD9,
  // "ă" (U+0103)
  0x06, 0x55, 0x60, 0x3F, 0xE3, 0x00, 0x11, 0x01, 0xCE, 0xB0, 0x05, 0x4F, 0x52, 0xDF, 0xF7, 0x9D,
  0x3E, 0x79, 0xD5, 0xF7, 0x3E, 0xBA, 0x70,
  // "Ą" (U+0104)
  0x02, 0xFD, 0x00, 0x06, 0xEF, 0x20, 0x0A, 0xAE, 0x50, 0x0D, 0x7B, 0x90, 0x2F, 0x58, 0xD0, 0x6F,
  0xFF, 0xF1, 0x9D, 0x34, 0xF5, 0xD9, 0x00, 0xF9, 0x00, 0x07, 0x70, 0x00, 0x06, 0xF3, 0x00, 0x00,
  0x20,
  // "ą" (U+0105)
  0x1C, 0xEB, 0x00, 0x54, 0xF5, 0x2D, 0xFF, 0x79, 0xD3, 0xE7, 0x9D, 0x5F, 0x73, 0xEC, 0xF7, 0x00,
  0x77, 0x00, 0x06, 0xF3, 0x00, 0x02, 0x00,
  // "Ć" (U+0106)
  0x00, 0x2D, 0x50, 0x01, 0x10, 0x03, 0xDE, 0xA0, 0xEA, 0x46, 0x5F, 0x20, 0x07, 0xF0, 0x00, 0x7F,
  0x00, 0x05, 0xF1, 0x00, 0x0E, 0xA3, 0x50, 0x5D, 0xF9,
  // "ć" (U+0107)
  0x02, 0xD5, 0x01, 0x10, 0x09, 0xEC, 0x5F, 0x44, 0x8C, 0x00, 0x8C, 0x00, 0x6F, 0x46, 0x0A, 0xEB,
  // "Ĉ" (U+0108)
  0x20, 0x50, 0x72, 0x82, 0x4B, 0x97, 0x68, 0x92, 0x3D, 0xEA, 0x0E, 0xA4, 0x65, 0xF2, 0x20, 0x79,
  0x30, 0x79, 0x38, 0x15, 0xF1, 0x38, 0x7E, 0xA3, 0x50, 0x5D, 0xF9,
  // "ĉ" (U+0109)
  0x05, 0x70, 0x4B, 0x97, 0x00, 0x00, 0x09, 0xEC, 0x5F, 0x44, 0x8C, 0x00, 0x8C, 0x00, 0x6F, 0x46,
  0x0A, 0xEB,
  // "Ċ" (U+010A)
  0x00, 0x7B, 0x00, 0x00, 0x10, 0x03, 0xDE, 0xA0, 0xEA, 0x46, 0x5F, 0x20, 0x07, 0xF0, 0x00, 0x7F,
  0x00, 0x05, 0xF1, 0x00, 0x0E, 0xA3, 0x50, 0x5D, 0xF9,
  // "ċ" (U+010B)
  0x07, 0xB0, 0x00, 0x10, 0x09, 0xEC, 0x5F, 0x44, 0x8C, 0x00, 0x8C, 0x00, 0x6F, 0x46, 0x0A, 0xEB,
  // "Č" (U+010C)
  0x03, 0x42, 0x50, 0x0D, 0xE2, 0x00, 0x00, 0x00, 0x3D, 0xEA, 0x0E, 0xA4, 0x65, 0xF2, 0x00, 0x7F,
  0x00, 0x07, 0xF0, 0x00, 0x5F, 0x10, 0x00, 0xEA, 0x35, 0x05, 0xDF, 0x90,
  // "č" (U+010D)
  0x34, 0x25, 0x0D, 0xE2, 0x00, 0x00, 0x09, 0xEC, 0x5F, 0x44, 0x8C, 0x00, 0x8C, 0x00, 0x6F, 0x46,
  0x0A, 0xEB,
  // "Ď" (U+010E)
  0x03, 0x42, 0x50, 0x00, 0xDE, 0x20, 0x00, 0x00, 0x00, 0x4F, 0xFC, 0x40, 0x4F, 0x49, 0xF1, 0x4F,
  0x10, 0xE7, 0x4F, 0x10, 0xC9, 0x4F, 0x10, 0xD9, 0x4F, 0x10, 0xE6, 0x4F, 0x59, 0xE1, 0x4F, 0xFD,
  0x40,
  // "ď" (U+010F)
  0x00, 0x09, 0xBB, 0x60, 0x00, 0x8B, 0x20, 0x0B, 0xDB, 0xB0, 0x06, 0xF4, 0xDB, 0x00, 0x8C, 0x08,
  0xB0, 0x08, 0xC0, 0x8B, 0x00, 0x6F, 0x4D, 0xB0, 0x00, 0xBD, 0x9B, 0x00,
  // "Đ" (U+0110)
  0x4F, 0xFC, 0x40, 0x4F, 0x49, 0xF1, 0x4F, 0x20, 0xE7, 0xDF, 0xF0, 0xC9, 0x6F, 0x40, 0xD9, 0x4F,
  0x10, 0xF6, 0x4F, 0x59, 0xE1, 0x4F, 0xFD, 0x40,
  // "đ" (U+0111)
  0x00, 0xAF, 0xF6, 0x00, 0x2A, 0xC1, 0x0B, 0xDB, 0xB0, 0x6F, 0x4D, 0xB0, 0x8C, 0x08, 0xB0, 0x8C,
  0x09, 0xB0, 0x6F, 0x4D, 0xB0, 0x0B, 0xD9, 0xB0,
  // "Ē" (U+0112)
  0x09, 0xFF, 0x50, 0x12, 0x20, 0x4F, 0xFF, 0x34, 0xF4, 0x30, 0x4F, 0x20, 0x04, 0xFF, 0xF0, 0x4F,
  0x42, 0x04, 0xF1, 0x00, 0x4F, 0x43, 0x04, 0xFF, 0xF3,
  // "ē" (U+0113)
  0x09, 0xFF, 0x50, 0x12, 0x20, 0x0A, 0xEB, 0x05, 0xE4, 0xD7, 0x8F, 0xFF, 0x98, 0xC2, 0x21, 0x5F,
  0x54, 0x30, 0x9E, 0xD3,
  // "Ĕ" (U+0114)
  0x65, 0x56, 0x03, 0xFE, 0x30, 0x01, 0x10, 0x04, 0xFF, 0xF3, 0x4F, 0x43, 0x04, 0xF2, 0x00, 0x4F,
  0xFF, 0x04, 0xF4, 0x20, 0x4F, 0x10, 0x04, 0xF4, 0x30, 0x4F, 0xFF, 0x30,
  // "ĕ" (U+0115)
  0x06, 0x55, 0x60, 0x3F, 0xE3, 0x00, 0x11, 0x00, 0xAE, 0xB0, 0x5E, 0x4D, 0x78, 0xFF, 0xF9, 0x8C,
  0x22, 0x15, 0xF5, 0x43, 0x09, 0xED, 0x30,
  // "Ė" (U+0116)
  0x07, 0xB0, 0x00, 0x01, 0x00, 0x4F, 0xFF, 0x34, 0xF4, 0x30, 0x4F, 0x20, 0x04, 0xFF, 0xF0, 0x4F,
  0x42, 0x04, 0xF1, 0x00, 0x4F, 0x43, 0x04, 0xFF, 0xF3,
  // "ė" (U+0117)
  0x00, 0x7B, 0x00, 0x00, 0x10, 0x0A, 0xEB, 0x05, 0xE4, 0xD7, 0x8F, 0xFF, 0x98, 0xC2, 0x21, 0x5F,
  0x54, 0x30, 0x9E, 0xD3,
  // "Ę" (U+0118)
  0x4F, 0xFF, 0x34, 0xF4, 0x30, 0x4F, 0x20, 0x04, 0xFF, 0xF0, 0x4F, 0x42, 0x04, 0xF1, 0x00, 0x4F,
  0x43, 0x04, 0xFF, 0xF3, 0x00, 0x77, 0x00, 0x06, 0xF3, 0x00, 0x02, 0x00,
  // "ę" (U+0119)
  0x0A, 0xE9, 0x05, 0xF5, 0xE5, 0x8C, 0x0A, 0x88, 0xFF, 0xF9, 0x5E, 0x66, 0x30, 0x9E, 0xF4, 0x00,
  0x2B, 0x00, 0x07, 0xA1, 0x00, 0x3E, 0x40,
  // "Ě" (U+011A)
  0x82, 0x34, 0x25, 0x28, 0x1D, 0xE2, 0x60, 0x4B, 0x87, 0x34, 0xF4, 0x30, 0x4F, 0x22, 0x04, 0xB1,
  0x86, 0x4F, 0x42, 0x04, 0xF1, 0x28, 0x44, 0xF4, 0x30, 0x4B, 0x03,
  // "ě" (U+011B)
  0x34, 0x25, 0x00, 0xDE, 0x20, 0x00, 0x00, 0x00, 0xAE, 0xB0, 0x5E, 0x4D, 0x78, 0xFF, 0xF9, 0x8C,
  0x22, 0x15, 0xF5, 0x43, 0x09, 0xED, 0x30,
  // "Ĝ" (U+011C)
  0x20, 0x50, 0x73, 0x82, 0x4B, 0x97, 0x71, 0x89, 0x42, 0xBE, 0xD4, 0x0D, 0xC4, 0x62, 0x5F, 0x23,
  0x07, 0x94, 0x8A, 0x67, 0xF0, 0xCF, 0x95, 0xF2, 0x2C, 0x90, 0xEA, 0x3D, 0x90, 0x4D, 0xFD, 0x60,
  // "ĝ" (U+011D)
  0x00, 0x57, 0x00, 0x4B, 0x97, 0x00, 0x00, 0x00, 0xBD, 0xAB, 0x6F, 0x4D, 0xB8, 0xC0, 0x9B, 0x8C,
  0x08, 0xB6, 0xF4, 0xDB, 0x0C, 0xDB, 0xB0, 0x00, 0x9B, 0x36, 0x4D, 0x73, 0xEE, 0xA1,
  // "Ğ" (U+011E)
  0x06, 0x55, 0x60, 0x03, 0xFE, 0x30, 0x00, 0x11, 0x00, 0x02, 0xBE, 0xD4, 0x0D, 0xC4, 0x62, 0x5F,
  0x20, 0x00, 0x7F, 0x00, 0x00, 0x7F, 0x0C, 0xF9, 0x5F, 0x22, 0xC9, 0x0E, 0xA3, 0xD9, 0x04, 0xDF,
  0xD6,
  // "ğ" (U+011F)
  0x06, 0x55, 0x60, 0x3F, 0xE3, 0x00, 0x11, 0x00, 0xBD, 0xAB, 0x6F, 0x4D, 0xB8, 0xC0, 0x9B, 0x8C,
  0x08, 0xB6, 0xF4, 0xDB, 0x0C, 0xDB, 0xB0, 0x00, 0x9B, 0x36, 0x4D, 0x73, 0xEE, 0xA1,
  // "Ġ" (U+0120)
  0x20, 0x70, 0xB5, 0x01, 0x38, 0x94, 0x2B, 0xED, 0x40, 0xDC, 0x46, 0x25, 0xF2, 0x30, 0x79, 0x48,
  0xA6, 0x7F, 0x0C, 0xF9, 0x5F, 0x22, 0xC9, 0x0E, 0xA3, 0xD9, 0x04, 0xDF, 0xD6,
  // "ġ" (U+0121)
  0x00, 0x7B, 0x00, 0x00, 0x10, 0x0B, 0xDA, 0xB6, 0xF4, 0xDB, 0x8C, 0x09, 0xB8, 0xC0, 0x8B, 0x6F,
  0x4D, 0xB0, 0xCD, 0xBB, 0x00, 0x09, 0xB3, 0x64, 0xD7, 0x3E, 0xEA, 0x10,
  // "Ģ" (U+0122)
  0x18, 0x94, 0x2B, 0xED, 0x40, 0xDC, 0x46, 0x25, 0xF2, 0x30, 0x79, 0x48, 0xA6, 0x7F, 0x0C, 0xF9,
  0x5F, 0x22, 0xC9, 0x0E, 0xA3, 0xD9, 0x04, 0xDF, 0xD6, 0x72, 0x03, 0x40, 0x40, 0xC2,
  // "ģ" (U+0123)
  0x00, 0xB5, 0x00, 0x03, 0x00, 0x0B, 0xDA, 0xB6, 0xF4, 0xDB, 0x8C, 0x09, 0xB8, 0xC0, 0x8B, 0x6F,
  0x4D, 0xB0, 0xCD, 0xBB, 0x00, 0x09, 0xB3, 0x64, 0xD7, 0x3E, 0xEA, 0x10,
  // "Ĥ" (U+0124)
  0x20, 0x50, 0x73, 0x82, 0x4B, 0x97, 0x78, 0xA1, 0x4F, 0x10, 0xC9, 0x4F, 0x10, 0xC9, 0x4F, 0x20,
  0xC9, 0x4C, 0x8A, 0x79, 0x4F, 0x42, 0xC9, 0x4F, 0x10, 0xC9, 0x4F, 0x10, 0xC9, 0x4F, 0x10, 0xC9,
  // "ĥ" (U+0125)
  0x10, 0x50, 0x73, 0x82, 0x4B, 0x97, 0x72, 0x05, 0x94, 0x05, 0x94, 0x8C, 0x15, 0xEA, 0xE5, 0x05,
  0xF6, 0xBC, 0x05, 0xF0, 0x7D, 0x05, 0xF0, 0x7D, 0x05, 0xF0, 0x7D, 0x05, 0xF0, 0x7D,
  // "Ħ" (U+0126)
  0x4F, 0x20, 0xBA, 0x0F, 0xFF, 0xFF, 0xF5, 0x6F, 0x43, 0xCB, 0x14, 0xFF, 0xFF, 0x90, 0x4F, 0x42,
  0xC9, 0x04, 0xF1, 0x0B, 0x90, 0x4F, 0x10, 0xB9, 0x04, 0xF1, 0x0B, 0x90,
  // "ħ" (U+0127)
  0x5F, 0x00, 0x0F, 0xFF, 0x20, 0x5E, 0xAE, 0x55, 0xF6, 0xBC, 0x5F, 0x07, 0xD5, 0xF0, 0x7D, 0x5F,
  0x07, 0xD5, 0xF0, 0x7D,
  // "Ĩ" (U+0128)
  0x3C, 0x2B, 0x86, 0xD9, 0x10, 0x00, 0xAF, 0xF2, 0x1F, 0x80, 0x0F, 0x60, 0x0F, 0x60, 0x0F, 0x60,
  0x0F, 0x60, 0x0F, 0x70, 0xAF, 0xF2,
  // "ĩ" (U+0129)
  0x3C, 0x2B, 0x86, 0xD9, 0x10, 0x00, 0x05, 0xF0, 0x05, 0xF0, 0x05, 0xF0, 0x05, 0xF0, 0x05, 0xF0,
  0x05, 0xF0,
  // "Ī" (U+012A)
  0x9F, 0xF5, 0x12, 0x20, 0xAF, 0xF2, 0x1F, 0x80, 0x0F, 0x60, 0x0F, 0x60, 0x0F, 0x60, 0x0F, 0x60,
  0x0F, 0x70, 0xAF, 0xF2,
  // "ī" (U+012B)
  0x9F, 0xF5, 0x12, 0x20, 0x05, 0xF0, 0x05, 0xF0, 0x05, 0xF0, 0x05, 0xF0, 0x05, 0xF0, 0x05, 0xF0,
  // "Ĭ" (U+012C)
  0x65, 0x56, 0x3F, 0xE3, 0x01, 0x10, 0xAF, 0xF2, 0x1F, 0x80, 0x0F, 0x60, 0x0F, 0x60, 0x0F, 0x60,
  0x0F, 0x60, 0x0F, 0x70, 0xAF, 0xF2,
  // "ĭ" (U+012D)
  0x65, 0x56, 0x3F, 0xE3, 0x01, 0x10, 0x05, 0xF0, 0x05, 0xF0, 0x05, 0xF0, 0x05, 0xF0, 0x05, 0xF0,
  0x05, 0xF0,
  // "Į" (U+012E)
  0xAF, 0xF2, 0x1F, 0x80, 0x0F, 0x60, 0x0F, 0x60, 0x0F, 0x60, 0x0F, 0x60, 0x0F, 0x70, 0xAF, 0xF2,
  0x07, 0x70, 0x06, 0xF3, 0x00, 0x20,
  // "į" (U+012F)
  0x4D, 0x00, 0x10, 0x5F, 0x05, 0xF0, 0x5F, 0x05, 0xF0, 0x5F, 0x06, 0xF0, 0x77, 0x06, 0xF3, 0x02,
  0x00,
  // "İ" (U+0130)
  0x07, 0xB0, 0x00, 0x10, 0xAF, 0xF2, 0x1F, 0x80, 0x0F, 0x60, 0x0F, 0x60, 0x0F, 0x60, 0x0F, 0x60,
  0x0F, 0x70, 0xAF, 0xF2,
  // "ı" (U+0131)
  0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F,
  // "Ĳ" (U+0132)
  0xAF, 0xF6, 0xF1, 0x1F, 0x84, 0xF1, 0x0F, 0x64, 0xF1, 0x0F, 0x64, 0xF1, 0x0F, 0x64, 0xF1, 0x0F,
  0x64, 0xF1, 0x0F, 0x74, 0xF1, 0xAF, 0xF6, 0xF1, 0x00, 0x07, 0xF0, 0x00, 0x9F, 0x90, 0x00, 0x12,
  0x00,
  // "ĳ" (U+0133)
  0x4D, 0x04, 0xD0, 0x10, 0x01, 0x5F, 0x05, 0xF5, 0xF0, 0x5F, 0x5F, 0x05, 0xF5, 0xF0, 0x5F, 0x5F,
  0x05, 0xF5, 0xF0, 0x5F, 0x00, 0x05, 0xF0, 0x01, 0x9E, 0x00, 0x5E, 0x70,
  // "Ĵ" (U+0134)
  0x05, 0x70, 0x4B, 0x97, 0x00, 0x00, 0x04, 0xF1, 0x04, 0xF1, 0x04, 0xF1, 0x04, 0xF1, 0x04, 0xF1,
  0x04, 0xF1, 0x04, 0xF1, 0x04, 0xF1, 0x07, 0xF0, 0x9F, 0x90, 0x12, 0x00,
  // "ĵ" (U+0135)
  0x05, 0x70, 0x4B, 0x97, 0x00, 0x00, 0x05, 0xF0, 0x05, 0xF0, 0x05, 0xF0, 0x05, 0xF0, 0x05, 0xF0,
  0x05, 0xF0, 0x05, 0xF0, 0x19, 0xE0, 0x5E, 0x70,
  // "Ķ" (U+0136)
  0x4F, 0x13, 0xF4, 0x4F, 0x1B, 0xB0, 0x4F, 0x6F, 0x30, 0x4F, 0xDB, 0x00, 0x4F, 0xEE, 0x10, 0x4F,
  0x3F, 0x70, 0x4F, 0x19, 0xE0, 0x4F, 0x12, 0xF6, 0x00, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0xA6,
  0x00,
  // "ķ" (U+0137)
  0x05, 0x93, 0x05, 0x93, 0x8B, 0x45, 0xF0, 0xAB, 0x5F, 0x5F, 0x25, 0xED, 0x90, 0x5F, 0xDE, 0x05,
  0xF1, 0xE6, 0x5F, 0x08, 0xE7, 0x02, 0x01, 0x30, 0xE0, 0x21,
  // "ĸ" (U+0138)
  0x5F, 0x0A, 0xB5, 0xF4, 0xF2, 0x5E, 0xD9, 0x05, 0xFD, 0xD0, 0x5F, 0x1E, 0x65, 0xF0, 0x8D,
  // "Ĺ" (U+0139)
  0x2D, 0x50, 0x01, 0x10, 0x00, 0x4F, 0x10, 0x04, 0xF1, 0x00, 0x4F, 0x10, 0x04, 0xF1, 0x00, 0x4F,
  0x10, 0x04, 0xF1, 0x00, 0x4F, 0x54, 0x14, 0xFF, 0xF5,
  // "ĺ" (U+013A)
  0x2D, 0x51, 0x10, 0x5F, 0x05, 0xF0, 0x5F, 0x05, 0xF0, 0x5F, 0x05, 0xF0, 0x5F, 0x05, 0xF0,
  // "Ļ" (U+013B)
  0x4F, 0x10, 0x04, 0xF1, 0x00, 0x4F, 0x10, 0x04, 0xF1, 0x00, 0x4F, 0x10, 0x04, 0xF1, 0x00, 0x4F,
  0x54, 0x14, 0xFF, 0xF5, 0x00, 0x00, 0x00, 0x03, 0x00, 0x02, 0xD0, 0x00,
  // "ļ" (U+013C)
  0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x00, 0x03, 0x5B,
  // "Ľ" (U+013D)
  0x4F, 0x1A, 0x74, 0xF1, 0x20, 0x4F, 0x10, 0x04, 0xF1, 0x00, 0x4F, 0x10, 0x04, 0xF1, 0x00, 0x4F,
  0x54, 0x14, 0xFF, 0xF5,
  // "ľ" (U+013E)
  0x5F, 0x89, 0x5F, 0x20, 0x5F, 0x00, 0x5F, 0x00, 0x5F, 0x00, 0x5F, 0x00, 0x5F, 0x00, 0x5F, 0x00,
  // "Ŀ" (U+013F)
  0x4F, 0x10, 0x04, 0xF1, 0x00, 0x4F, 0x10, 0x04, 0xF1, 0x7B, 0x4F, 0x10, 0x14, 0xF1, 0x00, 0x4F,
  0x54, 0x14, 0xFF, 0xF5,
  // "ŀ" (U+0140)
  0x5F, 0x00, 0x5F, 0x00, 0x5F, 0x00, 0x5F, 0x7B, 0x5F, 0x01, 0x5F, 0x00, 0x5F, 0x00, 0x5F, 0x00,
  // "Ł" (U+0141)
  0x2F, 0x30, 0x02, 0xF3, 0x00, 0x2F, 0x93, 0x02, 0xFE, 0x40, 0xCF, 0x40, 0x07, 0xF3, 0x00, 0x2F,
  0x74, 0x22, 0xFF, 0xF7,
  // "ł" (U+0142)
  0x3F, 0x23, 0xF2, 0x3F, 0x33, 0xFD, 0xBF, 0x38, 0xF2, 0x3F, 0x23, 0xF2,
  // "Ń" (U+0143)
  0x00, 0x2D, 0x50, 0x00, 0x01, 0x10, 0x00, 0x4F, 0x90, 0x3F, 0x14, 0xFF, 0x13, 0xF1, 0x4F, 0xE7,
  0x3F, 0x14, 0xF8, 0xD3, 0xF1, 0x4F, 0x2F, 0x8F, 0x14, 0xF0, 0xAE, 0xF1, 0x4F, 0x04, 0xFF, 0x14,
  0xF0, 0x0C, 0xF1,
  // "ń" (U+0144)
  0x00, 0x2D, 0x50, 0x01, 0x10, 0x5C, 0xAE, 0x55, 0xF6, 0xBC, 0x5F, 0x07, 0xD5, 0xF0, 0x7D, 0x5F,
  0x07, 0xD5, 0xF0, 0x7D,
  // "Ņ" (U+0145)
  0x86, 0x4F, 0x90, 0x3F, 0x14, 0xA8, 0xC2, 0x13, 0xF1, 0x4F, 0xE7, 0x3F, 0x14, 0xF8, 0xD3, 0xF1,
  0x4F, 0x2F, 0x8F, 0x14, 0xF0, 0xAE, 0xF1, 0x4F, 0x04, 0xA0, 0x10, 0x49, 0x28, 0x1C, 0xF1, 0x73,
  0x03, 0x50, 0x40, 0xC3,
  // "ņ" (U+0146)
  0x8B, 0x45, 0xCA, 0xE5, 0x5F, 0x6B, 0xC5, 0xF0, 0x7D, 0x5F, 0x07, 0xD5, 0xF0, 0x7D, 0x5F, 0x07,
  0xD7, 0x02, 0x01, 0x30, 0xE0, 0x21,
  // "Ň" (U+0147)
  0x03, 0x42, 0x50, 0x00, 0x0D, 0xE2, 0x00, 0x00, 0x00, 0x00, 0x04, 0xF9, 0x03, 0xF1, 0x4F, 0xF1,
  0x3F, 0x14, 0xFE, 0x73, 0xF1, 0x4F, 0x8D, 0x3F, 0x14, 0xF2, 0xF8, 0xF1, 0x4F, 0x0A, 0xEF, 0x14,
  0xF0, 0x4F, 0xF1, 0x4F, 0x00, 0xCF, 0x10,
  // "ň" (U+0148)
  0x03, 0x42, 0x50, 0x0D, 0xE2, 0x00, 0x00, 0x05, 0xCA, 0xE5, 0x5F, 0x6B, 0xC5, 0xF0, 0x7D, 0x5F,
  0x07, 0xD5, 0xF0, 0x7D, 0x5F, 0x07, 0xD0,
  // "ŉ" (U+0149)
  0x5E, 0x00, 0x00, 0x8B, 0x00, 0x00, 0x8B, 0xCA, 0xE5, 0x05, 0xF6, 0xBC, 0x05, 0xF0, 0x7D, 0x05,
  0xF0, 0x7D, 0x05, 0xF0, 0x7D, 0x05, 0xF0, 0x7D,
  // "Ŋ" (U+014A)
  0x4F, 0xA0, 0x3F, 0x14, 0xFF, 0x23, 0xF1, 0x4E, 0xD9, 0x3F, 0x14, 0xF6, 0xF5, 0xF1, 0x4F, 0x0D,
  0xBF, 0x14, 0xF0, 0x6F, 0xF1, 0x4F, 0x00, 0xDF, 0x14, 0xF0, 0x06, 0xF1, 0x00, 0x00, 0x6F, 0x00,
  0x00, 0x9F, 0x90, 0x00, 0x01, 0x20, 0x00,
  // "ŋ" (U+014B)
  0x5C, 0xBE, 0x45, 0xF6, 0xBC, 0x5F, 0x07, 0xD5, 0xF0, 0x7D, 0x5F, 0x07, 0xD5, 0xF0, 0x7D, 0x00,
  0x07, 0xD0, 0x01, 0xAC, 0x00, 0x6E, 0x50,
  // "Ō" (U+014C)
  0x09, 0xFF, 0x50, 0x01, 0x22, 0x00, 0x05, 0xDE, 0xA0, 0x0E, 0x94, 0xE8, 0x5F, 0x10, 0x8D, 0x7F,
  0x00, 0x6F, 0x7F, 0x00, 0x6F, 0x5F, 0x10, 0x8D, 0x1E, 0x94, 0xE8, 0x04, 0xDE, 0xA0,
  // "ō" (U+014D)
  0x09, 0xFF, 0x50, 0x12, 0x20, 0x0A, 0xEB, 0x15, 0xF4, 0xC9, 0x8C, 0x08, 0xC8, 0xC0, 0x8C, 0x5F,
  0x4C, 0x90, 0x9E, 0xC1,
  // "Ŏ" (U+014E)
  0x06, 0x55, 0x60, 0x03, 0xFE, 0x30, 0x00, 0x11, 0x00, 0x05, 0xDE, 0xA0, 0x0E, 0x94, 0xE8, 0x5F,
  0x10, 0x8D, 0x7F, 0x00, 0x6F, 0x7F, 0x00, 0x6F, 0x5F, 0x10, 0x8D, 0x1E, 0x94, 0xE8, 0x04, 0xDE,
  0xA0,
  // "ŏ" (U+014F)
  0x06, 0x55, 0x60, 0x3F, 0xE3, 0x00, 0x11, 0x00, 0xAE, 0xB1, 0x5F, 0x4C, 0x98, 0xC0, 0x8C, 0x8C,
  0x08, 0xC5, 0xF4, 0xC9, 0x09, 0xEC, 0x10,
  // "Ő" (U+0150)
  0x00, 0x2C, 0x9A, 0x00, 0x10, 0x20, 0x05, 0xDE, 0xA0, 0x0E, 0x94, 0xE8, 0x5F, 0x10, 0x8D, 0x7F,
  0x00, 0x6F, 0x7F, 0x00, 0x6F, 0x5F, 0x10, 0x8D, 0x1E, 0x94, 0xE8, 0x04, 0xDE, 0xA0,
  // "ő" (U+0151)
  0x02, 0xC9, 0xA0, 0x10, 0x20, 0x0A, 0xEB, 0x15, 0xF4, 0xC9, 0x8C, 0x08, 0xC8, 0xC0, 0x8C, 0x5F,
  0x4C, 0x90, 0x9E, 0xC1,
  // "Œ" (U+0152)
  0x04, 0xDF, 0xFF, 0xF6, 0x1E, 0x94, 0xF6, 0x31, 0x5F, 0x11, 0xF4, 0x00, 0x7F, 0x01, 0xFF, 0xF4,
  0x7F, 0x01, 0xF6, 0x20, 0x5F, 0x11, 0xF4, 0x00, 0x1E, 0x94, 0xF6, 0x31, 0x04, 0xDF, 0xFF, 0xF6,
  // "œ" (U+0153)
  0x09, 0xEA, 0x7E, 0xC1, 0x5F, 0x4C, 0xF4, 0xC8, 0x8C, 0x08, 0xFF, 0xFB, 0x8C, 0x08, 0xD2, 0x22,
  0x5F, 0x4C, 0xF5, 0x44, 0x09, 0xEB, 0x7E, 0xE5,
  // "Ŕ" (U+0154)
  0x00, 0x2D, 0x50, 0x00, 0x11, 0x00, 0x4F, 0xFC, 0x30, 0x4F, 0x5C, 0xC0, 0x4F, 0x17, 0xF0, 0x4F,
  0x2A, 0xC0, 0x4F, 0xFF, 0x30, 0x4F, 0x6F, 0x30, 0x4F, 0x1B, 0xB0, 0x4F, 0x13, 0xF4,
  // "ŕ" (U+0155)
  0x02, 0xD5, 0x01, 0x10, 0x5C, 0xA9, 0x5F, 0x82, 0x5F, 0x00, 0x5F, 0x00, 0x5F, 0x00, 0x5F, 0x00,
  // "Ŗ" (U+0156)
  0x04, 0xA8, 0xA4, 0xC3, 0x04, 0xF5, 0xCC, 0x04, 0xF1, 0x7F, 0x04, 0xF2, 0xAC, 0x04, 0xB8, 0xA2,
  0x30, 0x4F, 0x6F, 0x30, 0x4F, 0x1B, 0xB0, 0x4F, 0x13, 0xF4, 0x71, 0x01, 0x02, 0x40, 0xB0, 0x52,
  // "ŗ" (U+0157)
  0x87, 0x5C, 0xA9, 0x5F, 0x82, 0x59, 0x20, 0x59, 0x20, 0x59, 0x20, 0x59, 0x70, 0x32, 0x05, 0x0B,
  0x20,
  // "Ř" (U+0158)
  0x03, 0x42, 0x50, 0x00, 0xDE, 0x20, 0x00, 0x00, 0x00, 0x4F, 0xFC, 0x30, 0x4F, 0x5C, 0xC0, 0x4F,
  0x17, 0xF0, 0x4F, 0x2A, 0xC0, 0x4F, 0xFF, 0x30, 0x4F, 0x6F, 0x30, 0x4F, 0x1B, 0xB0, 0x4F, 0x13,
  0xF4,
  // "ř" (U+0159)
  0x34, 0x25, 0x0D, 0xE2, 0x00, 0x00, 0x5C, 0xA9, 0x5F, 0x82, 0x5F, 0x00, 0x5F, 0x00, 0x5F, 0x00,
  0x5F, 0x00,
  // "Ś" (U+015A)
  0x02, 0xD5, 0x00, 0x11, 0x00, 0x0A, 0xED, 0x26, 0xE4, 0x70, 0x8E, 0x10, 0x03, 0xFE, 0x40, 0x05,
  0xEF, 0x20, 0x03, 0xF5, 0x65, 0x6F, 0x37, 0xEE, 0x70,
  // "ś" (U+015B)
  0x02, 0xD5, 0x01, 0x10, 0x3D, 0xE7, 0x9C, 0x43, 0x6F, 0x80, 0x05, 0xE9, 0x54, 0xBB, 0x8E, 0xD4,
  // "Ŝ" (U+015C)
  0x05, 0x70, 0x04, 0xB9, 0x70, 0x00, 0x00, 0x00, 0xAE, 0xD2, 0x6E, 0x47, 0x08, 0xE1, 0x00, 0x3F,
  0xE4, 0x00, 0x5E, 0xF2, 0x00, 0x3F, 0x56, 0x56, 0xF3, 0x7E, 0xE7, 0x00,
  // "ŝ" (U+015D)
  0x05, 0x70, 0x4B, 0x97, 0x00, 0x00, 0x3D, 0xE7, 0x9C, 0x43, 0x6F, 0x80, 0x05, 0xE9, 0x54, 0xBB,
  0x8E, 0xD4,
  // "Ş" (U+015E)
  0x0A, 0xED, 0x26, 0xE4, 0x70, 0x8E, 0x10, 0x03, 0xFE, 0x40, 0x05, 0xEF, 0x20, 0x03, 0xF5, 0x65,
  0x6F, 0x37, 0xEE, 0x70, 0x06, 0x10, 0x00, 0x7B, 0x00, 0x2D, 0x80, 0x00,
  // "ş" (U+015F)
  0x3D, 0xE7, 0x9C, 0x43, 0x6F, 0x80, 0x05, 0xE9, 0x54, 0xBB, 0x8E, 0xD4, 0x06, 0x10, 0x07, 0xB0,
  0x2D, 0x80,
  // "Š" (U+0160)
  0x34, 0x25, 0x00, 0xDE, 0x20, 0x00, 0x00, 0x00, 0xAE, 0xD2, 0x6E, 0x47, 0x08, 0xE1, 0x00, 0x3F,
  0xE4, 0x00, 0x5E, 0xF2, 0x00, 0x3F, 0x56, 0x56, 0xF3, 0x7E, 0xE7, 0x00,
  // "š" (U+0161)
  0x34, 0x25, 0x0D, 0xE2, 0x00, 0x00, 0x3D, 0xE7, 0x9C, 0x43, 0x6F, 0x80, 0x05, 0xE9, 0x54, 0xBB,
  0x8E, 0xD4,
  // "Ţ" (U+0162)
  0xDF, 0xFF, 0x92, 0x7F, 0x31, 0x05, 0xF1, 0x00, 0x5F, 0x10, 0x05, 0xF1, 0x00, 0x5F, 0x10, 0x05,
  0xF1, 0x00, 0x5F, 0x10, 0x00, 0x61, 0x00, 0x07, 0xB0, 0x02, 0xD8, 0x00,
  // "ţ" (U+0163)
  0x0E, 0x10, 0x9F, 0xF3, 0x6F, 0x40, 0x4F, 0x10, 0x4F, 0x10, 0x3F, 0x61, 0x0C, 0xE3, 0x06, 0x10,
  0x07, 0xB0, 0x2D, 0x80,
  // "Ť" (U+0164)
  0x34, 0x25, 0x00, 0xDE, 0x20, 0x00, 0x00, 0x0D, 0xFF, 0xF9, 0x27, 0xF3, 0x10, 0x5F, 0x10, 0x05,
  0xF1, 0x00, 0x5F, 0x10, 0x05, 0xF1, 0x00, 0x5F, 0x10, 0x05, 0xF1, 0x00,
  // "ť" (U+0165)
  0x03, 0x08, 0x90, 0xF1, 0x20, 0xAF, 0xF3, 0x06, 0xF4, 0x00, 0x4F, 0x10, 0x04, 0xF1, 0x00, 0x3F,
  0x61, 0x00, 0xCE, 0x30,
  // "Ŧ" (U+0166)
  0xDF, 0xFF, 0x92, 0x7F, 0x31, 0x05, 0xF1, 0x00, 0x5F, 0x10, 0x4F, 0xFF, 0x10, 0x7F, 0x30, 0x05,
  0xF1, 0x00, 0x5F, 0x10,
  // "ŧ" (U+0167)
  0x0E, 0x10, 0x9F, 0xF3, 0x6F, 0x40, 0xCF, 0xF2, 0x5F, 0x40, 0x3F, 0x61, 0x0C, 0xE3,
  // "Ũ" (U+0168)
  0x03, 0xC2, 0xB0, 0x08, 0x6D, 0x90, 0x01, 0x00, 0x00, 0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xD8, 0x4F,
  0x10, 0xD8, 0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xE7, 0x1F, 0x96, 0xF4, 0x06, 0xDE,
  0x80,
  // "ũ" (U+0169)
  0x03, 0xC2, 0xB0, 0x86, 0xD9, 0x01, 0x00, 0x06, 0xF0, 0x7D, 0x6F, 0x07, 0xD6, 0xF0, 0x7D, 0x6F,
  0x08, 0xD4, 0xF4, 0xCD, 0x0C, 0xE9, 0xD0,
  // "Ū" (U+016A)
  0x09, 0xFF, 0x50, 0x01, 0x22, 0x00, 0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xD8, 0x4F,
  0x10, 0xD8, 0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xE7, 0x1F, 0x96, 0xF4, 0x06, 0xDE, 0x80,
  // "ū" (U+016B)
  0x09, 0xFF, 0x50, 0x12, 0x20, 0x6F, 0x07, 0xD6, 0xF0, 0x7D, 0x6F, 0x07, 0xD6, 0xF0, 0x8D, 0x4F,
  0x4C, 0xD0, 0xCE, 0x9D,
  // "Ŭ" (U+016C)
  0x06, 0x55, 0x60, 0x03, 0xFE, 0x30, 0x00, 0x11, 0x00, 0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xD8, 0x4F,
  0x10, 0xD8, 0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xE7, 0x1F, 0x96, 0xF4, 0x06, 0xDE,
  0x80,
  // "ŭ" (U+016D)
  0x06, 0x55, 0x60, 0x3F, 0xE3, 0x00, 0x11, 0x06, 0xF0, 0x7D, 0x6F, 0x07, 0xD6, 0xF0, 0x7D, 0x6F,
  0x08, 0xD4, 0xF4, 0xCD, 0x0C, 0xE9, 0xD0,
  // "Ů" (U+016E)
  0x00, 0x4E, 0x60, 0x00, 0x87, 0xB0, 0x00, 0x5F, 0x80, 0x4F, 0x11, 0xD8, 0x4F, 0x10, 0xD8, 0x4F,
  0x10, 0xD8, 0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xE7, 0x1F, 0x96, 0xF4, 0x06, 0xDE,
  0x80,
  // "ů" (U+016F)
  0x04, 0xE6, 0x00, 0x87, 0xB0, 0x05, 0xF8, 0x06, 0xF1, 0x7D, 0x6F, 0x07, 0xD6, 0xF0, 0x7D, 0x6F,
  0x08, 0xD4, 0xF4, 0xCD, 0x0C, 0xE9, 0xD0,
  // "Ű" (U+0170)
  0x02, 0xC9, 0xA0, 0x01, 0x02, 0x00, 0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xD8, 0x4F,
  0x10, 0xD8, 0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xE7, 0x1F, 0x96, 0xF4, 0x06, 0xDE, 0x80,
  // "ű" (U+0171)
  0x02, 0xC9, 0xA0, 0x10, 0x20, 0x6F, 0x07, 0xD6, 0xF0, 0x7D, 0x6F, 0x07, 0xD6, 0xF0, 0x8D, 0x4F,
  0x4C, 0xD0, 0xCE, 0x9D,
  // "Ų" (U+0172)
  0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xD8, 0x4F,
  0x10, 0xE7, 0x1F, 0x96, 0xF5, 0x06, 0xDF, 0xC0, 0x00, 0x0D, 0x20, 0x00, 0x2E, 0x20, 0x00, 0x0C,
  0xA0,
  // "ų" (U+0173)
  0x6F, 0x07, 0xD0, 0x6F, 0x07, 0xD0, 0x6F, 0x07, 0xD0, 0x6F, 0x08, 0xD0, 0x4F, 0x4C, 0xD0, 0x0C,
  0xEA, 0xF0, 0x00, 0x07, 0x70, 0x00, 0x06, 0xF3, 0x00, 0x00, 0x20,
  // "Ŵ" (U+0174)
  0x30, 0x50, 0x76, 0x82, 0x4B, 0x97, 0x75, 0x8D, 0x2D, 0x70, 0x8D, 0x02, 0xF3, 0xAA, 0x0B, 0xF0,
  0x5F, 0x07, 0xC0, 0xEE, 0x38, 0xD0, 0x4F, 0x2F, 0xA6, 0xBA, 0x01, 0xF7, 0xC7, 0x9D, 0x72, 0x85,
  0xEC, 0x94, 0xCF, 0x42, 0x82, 0xBF, 0x61, 0xA0, 0x12, 0x84, 0x8F, 0x30, 0xED, 0x20,
  // "ŵ" (U+0175)
  0x30, 0x50, 0x75, 0x82, 0x4B, 0x97, 0x73, 0x8B, 0x5C, 0x82, 0xF8, 0x2F, 0x29, 0xB5, 0xEB, 0x5E,
  0x06, 0xD8, 0x9E, 0x8B, 0x03, 0xFB, 0x4F, 0xB8, 0x28, 0x4E, 0xF1, 0xCF, 0x42, 0x84, 0xBE, 0x09,
  0xF1, 0x10,
  // "Ŷ" (U+0176)
  0x05, 0x70, 0x04, 0xB9, 0x70, 0x00, 0x00, 0x0C, 0xA0, 0x7E, 0x6F, 0x1D, 0x91, 0xFA, 0xF3, 0x0A,
  0xFD, 0x00, 0x4F, 0x70, 0x01, 0xF4, 0x00, 0x1F, 0x40, 0x01, 0xF4, 0x00,
  // "ŷ" (U+0177)
  0x05, 0x70, 0x04, 0xB9, 0x70, 0x00, 0x00, 0x0D, 0x80, 0xBA, 0x8C, 0x0E, 0x64, 0xF3, 0xF2, 0x0F,
  0xAD, 0x00, 0xBE, 0x90, 0x07, 0xF5, 0x00, 0x4F, 0x10, 0x2B, 0xB0, 0x09, 0xD3, 0x00,
  // "Ÿ" (U+0178)
  0x0C, 0x3E, 0x10, 0x10, 0x10, 0xCA, 0x07, 0xE6, 0xF1, 0xD9, 0x1F, 0xAF, 0x30, 0xAF, 0xD0, 0x04,
  0xF7, 0x00, 0x1F, 0x40, 0x01, 0xF4, 0x00, 0x1F, 0x40,
  // "Ź" (U+0179)
  0x02, 0xD5, 0x00, 0x11, 0x00, 0xAF, 0xFF, 0x72, 0x36, 0xF3, 0x00, 0xBB, 0x00, 0x2F, 0x40, 0x09,
  0xD0, 0x01, 0xF6, 0x00, 0x8E, 0x33, 0x1B, 0xFF, 0xF8,
  // "ź" (U+017A)
  0x02, 0xD5, 0x01, 0x10, 0xAF, 0xFA, 0x23, 0xF6, 0x07, 0xE0, 0x0E, 0x70, 0x7E, 0x32, 0xCF, 0xFB,
  // "Ż" (U+017B)
  0x07, 0xB0, 0x00, 0x01, 0x00, 0xAF, 0xFF, 0x72, 0x36, 0xF3, 0x00, 0xBB, 0x00, 0x2F, 0x40, 0x09,
  0xD0, 0x01, 0xF6, 0x00, 0x8E, 0x33, 0x1B, 0xFF, 0xF8,
  // "ż" (U+017C)
  0x07, 0xB0, 0x00, 0x10, 0xAF, 0xFA, 0x23, 0xF6, 0x07, 0xE0, 0x0E, 0x70, 0x7E, 0x32, 0xCF, 0xFB,
  // "Ž" (U+017D)
  0x34, 0x25, 0x00, 0xDE, 0x20, 0x00, 0x00, 0x0A, 0xFF, 0xF7, 0x23, 0x6F, 0x30, 0x0B, 0xB0, 0x02,
  0xF4, 0x00, 0x9D, 0x00, 0x1F, 0x60, 0x08, 0xE3, 0x31, 0xBF, 0xFF, 0x80,
  // "ž" (U+017E)
  0x34, 0x25, 0x0D, 0xE2, 0x00, 0x00, 0xAF, 0xFA, 0x23, 0xF6, 0x07, 0xE0, 0x0E, 0x70, 0x7E, 0x32,
  0xCF, 0xFB,
  // "ſ" (U+017F)
  0x0B, 0xE4, 0x3F, 0x51, 0x4F, 0x10, 0x4F, 0x10, 0x4F, 0x10, 0x4F, 0x10, 0x4F, 0x10, 0x4F, 0x10,
  // "Ω" (U+03A9)
  0x04, 0xDE, 0xA1, 0x01, 0xF9, 0x4D, 0x90, 0x6F, 0x00, 0x7E, 0x07, 0xE0, 0x05, 0xF0, 0x6E, 0x00,
  0x6E, 0x02, 0xF2, 0x09, 0xA0, 0x2A, 0xA2, 0xE5, 0x0B, 0xFD, 0x5F, 0xF4,
  // "μ" (U+03BC)
  0x8B, 0x55, 0xF0, 0x7D, 0x5F, 0x07, 0xD5, 0xF0, 0x7D, 0x5F, 0x08, 0xD5, 0xF5, 0xCD, 0x5F, 0xEA,
  0xD5, 0x93, 0x05, 0x93, 0x05, 0x93,
  // "π" (U+03C0)
  0xBF, 0xFF, 0xFE, 0x3F, 0x77, 0xF2, 0x0F, 0x55, 0xF0, 0x0F, 0x55, 0xF0, 0x0F, 0x55, 0xF4, 0x0F,
  0x51, 0xDC,
  // "–" (U+2013)
  0xAF, 0xFF, 0xA1, 0x22, 0x21,
  // "—" (U+2014)
  0x0A, 0xF9, 0x0A, 0x01, 0x80, 0x42, 0x01,
  // "€" (U+20AC)
  0x02, 0xCE, 0x80, 0xBB, 0x45, 0x0F, 0x40, 0x0B, 0xFE, 0xA0, 0xBF, 0xE7, 0x00, 0xF4, 0x00, 0x0B,
  0xB4, 0x50, 0x2C, 0xE7,
  // "₿" (U+20BF)
  0x06, 0x66, 0x04, 0xFF, 0xD2, 0x4F, 0x4E, 0x84, 0xF2, 0xE6, 0x4F, 0xFE, 0x14, 0xF4, 0xD8, 0x4F,
  0x1A, 0xA4, 0xF4, 0xD8, 0x4F, 0xFC, 0x10, 0x66, 0x60,
  // "‘" (U+2018)
  0x2E, 0x7C, 0x89,
  // "’" (U+2019)
  0x5E, 0x8B, 0x85,
  // "‚" (U+201A)
  0x5E, 0x8B, 0x85,
  // "‛" (U+201B)
  0x9A, 0x6C, 0x1C,
  // "“" (U+201C)
  0x2E, 0x1F, 0x17, 0xC5, 0xE0, 0x89, 0x7A, 0x00,
  // "”" (U+201D)
  0x5E, 0x4F, 0x18, 0xB6, 0xD0, 0x85, 0x77, 0x00,
  // "„" (U+201E)
  0x5E, 0x4F, 0x18, 0xB6, 0xD0, 0x85, 0x77, 0x00,
  // "‟" (U+201F)
  0x9B, 0x7C, 0x06, 0xC3, 0xE0, 0x1C, 0x0C, 0x10,
  // "†" (U+2020)
  0x02, 0xF0, 0x00, 0x1E, 0x00, 0x6C, 0xFD, 0x51, 0x2D, 0x21, 0x00, 0xE0, 0x00, 0x1F, 0x00, 0x02,
  0xF0, 0x00, 0x3F, 0x10,
  // "‡" (U+2021)
  0x02, 0xF1, 0x01, 0x1E, 0x00, 0x7E, 0xFF, 0x60, 0x0F, 0x00, 0x00, 0xF0, 0x07, 0xDF, 0xD6, 0x12,
  0xE2, 0x10, 0x1F, 0x10,
  // "•" (U+2022)
  0x3E, 0xD1, 0x7F, 0xF5, 0x3E, 0xD1,
  // "…" (U+2026)
  0x01, 0x00, 0x10, 0x14, 0xE0, 0x4E, 0x5E,
  // "‰" (U+2030)
  0x84, 0x2E, 0xA0, 0x1D, 0x68, 0x49, 0x9E, 0x27, 0x86, 0x84, 0xA6, 0xC4, 0xD2, 0x68, 0xC2, 0x97,
  0xD7, 0xB9, 0xE3, 0x3E, 0x90, 0x3F, 0xDA, 0x7F, 0x8A, 0xA8, 0xE1, 0x01, 0x1E, 0x3D, 0x4B, 0xB4,
  0xD3, 0x28, 0x90, 0x79, 0x1E, 0x8A, 0xA8, 0xE1, 0x28, 0x7D, 0x30, 0x9E, 0x33, 0xE9, 0x10,
  // "‹" (U+2039)
  0x06, 0x83, 0xF3, 0x7E, 0x00, 0xC8, 0x02, 0x30,
  // "›" (U+203A)
  0x59, 0x01, 0xE6, 0x0B, 0xB5, 0xE1, 0x13, 0x00,
  // "⁄" (U+2044)
  0x00, 0x06, 0xA0, 0x00, 0xD3, 0x00, 0x5B, 0x00, 0x0C, 0x40, 0x03, 0xC0, 0x00, 0xA5, 0x00, 0x2D,
  0x00, 0x09, 0x70, 0x00,
  // "™" (U+2122)
  0xAC, 0x7D, 0x18, 0x71, 0xB1, 0xE6, 0xC8, 0x1B, 0x1A, 0xC9, 0x80, 0x91, 0x88, 0x36,
  // "⅒" (U+2152)
  0x50, 0x60, 0xA5, 0x81, 0x1B, 0x92, 0x0D, 0x03, 0x58, 0x44, 0x99, 0x05, 0xB7, 0x83, 0x69, 0x0C,
  0x42, 0x81, 0x3D, 0x92, 0x89, 0x16, 0x93, 0xC1, 0xB9, 0xA5, 0xD2, 0x38, 0x7A, 0x54, 0x99, 0xC4,
  0xC3, 0x20, 0x20, 0xD2, 0x84, 0x69, 0xA5, 0xD2, 0x20, 0x90, 0x72, 0x83, 0x69, 0x3D, 0x91,
  // "ﬁ" (U+FB01)
  0x0B, 0xFA, 0xD2, 0xF6, 0x11, 0xBF, 0xF8, 0xF5, 0xF5, 0x6F, 0x3F, 0x25, 0xF3, 0xF2, 0x5F, 0x3F,
  0x25, 0xF3, 0xF2, 0x5F,
  // "ﬂ" (U+FB02)
  0x0B, 0xFB, 0xF2, 0xF6, 0x6F, 0xBF, 0xF8, 0xF5, 0xF5, 0x6F, 0x3F, 0x25, 0xF3, 0xF2, 0x5F, 0x3F,
  0x25, 0xF3, 0xF2, 0x5F,
};

const Font& font_NotoSans_CondensedBold_10() {
  static SmoothFont font(font_NotoSans_CondensedBold_10_data);
  return font;
}

}  // namespace roo_display
