#include "8.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSans-Bold (Noto Sans Bold)
// Generated on Wed Nov 19 19:11:08 CET 2025
static const uint8_t font_NotoSans_Bold_8_data[] PROGMEM = {
  
  // Header
  0x01, 0x02, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x01, 0xCC,
  0xFE, 0xFE, 0x09, 0x09, 0x07, 0xFE, 0x03, 0x01, 0x0A, 0x03, 0x02, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x40, 0x01, 0x01, 0x06, 0x02, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x40, 0x04, 0x03, 0x06, 0x04, 0x00, 0x06, // """ (U+0022)
  0x00, 0x23, 0x40, 0x01, 0x04, 0x06, 0x05, 0x00, 0x0C, // "#" (U+0023)
  0x00, 0x24, 0x40, 0x01, 0x04, 0x07, 0x05, 0x00, 0x1B, // "$" (U+0024)
  0x00, 0x25, 0x40, 0x01, 0x06, 0x06, 0x07, 0x00, 0x2D, // "%" (U+0025)
  0x00, 0x26, 0x40, 0x01, 0x05, 0x06, 0x06, 0x00, 0x42, // "&" (U+0026)
  0x00, 0x27, 0x40, 0x04, 0x01, 0x06, 0x02, 0x00, 0x54, // "'" (U+0027)
  0x00, 0x28, 0x40, 0x00, 0x02, 0x06, 0x03, 0x00, 0x57, // "(" (U+0028)
  0x00, 0x29, 0x40, 0x00, 0x02, 0x06, 0x03, 0x00, 0x62, // ")" (U+0029)
  0x00, 0x2A, 0x40, 0x04, 0x03, 0x07, 0x04, 0x00, 0x6D, // "*" (U+002A)
  0x00, 0x2B, 0x40, 0x02, 0x04, 0x05, 0x05, 0x00, 0x75, // "+" (U+002B)
  0x00, 0x2C, 0x40, 0x00, 0x01, 0x02, 0x02, 0x00, 0x7F, // "," (U+002C)
  0x00, 0x2D, 0x40, 0x02, 0x02, 0x03, 0x03, 0x00, 0x82, // "-" (U+002D)
  0x00, 0x2E, 0x40, 0x01, 0x01, 0x01, 0x02, 0x00, 0x85, // "." (U+002E)
  0x00, 0x2F, 0x40, 0x01, 0x03, 0x06, 0x03, 0x00, 0x86, // "/" (U+002F)
  0x00, 0x30, 0x40, 0x01, 0x04, 0x06, 0x05, 0x00, 0x92, // "0" (U+0030)
  0x00, 0x31, 0x40, 0x01, 0x03, 0x06, 0x05, 0x00, 0xA1, // "1" (U+0031)
  0x00, 0x32, 0x40, 0x01, 0x04, 0x06, 0x05, 0x00, 0xAD, // "2" (U+0032)
  0x00, 0x33, 0x40, 0x01, 0x04, 0x06, 0x05, 0x00, 0xBC, // "3" (U+0033)
  0x00, 0x34, 0x40, 0x01, 0x04, 0x06, 0x05, 0x00, 0xCB, // "4" (U+0034)
  0x00, 0x35, 0x40, 0x01, 0x04, 0x06, 0x05, 0x00, 0xDA, // "5" (U+0035)
  0x00, 0x36, 0x40, 0x01, 0x04, 0x06, 0x05, 0x00, 0xE9, // "6" (U+0036)
  0x00, 0x37, 0x40, 0x01, 0x04, 0x06, 0x05, 0x00, 0xF8, // "7" (U+0037)
  0x00, 0x38, 0x40, 0x01, 0x04, 0x06, 0x05, 0x01, 0x07, // "8" (U+0038)
  0x00, 0x39, 0x40, 0x01, 0x04, 0x06, 0x05, 0x01, 0x16, // "9" (U+0039)
  0x00, 0x3A, 0x40, 0x01, 0x01, 0x05, 0x02, 0x01, 0x25, // ":" (U+003A)
  0x00, 0x3B, 0x40, 0x00, 0x01, 0x05, 0x02, 0x01, 0x2A, // ";" (U+003B)
  0x00, 0x3C, 0x40, 0x02, 0x04, 0x05, 0x05, 0x01, 0x30, // "<" (U+003C)
  0x00, 0x3D, 0x40, 0x02, 0x04, 0x05, 0x05, 0x01, 0x3A, // "=" (U+003D)
  0x00, 0x3E, 0x40, 0x02, 0x04, 0x05, 0x05, 0x01, 0x44, // ">" (U+003E)
  0x00, 0x3F, 0x40, 0x01, 0x03, 0x06, 0x04, 0x01, 0x4E, // "?" (U+003F)
  0x00, 0x40, 0x40, 0xFF, 0x06, 0x06, 0x07, 0x01, 0x5A, // "@" (U+0040)
  0x00, 0x41, 0x40, 0x01, 0x05, 0x06, 0x06, 0x01, 0x76, // "A" (U+0041)
  0x00, 0x42, 0x40, 0x01, 0x04, 0x06, 0x05, 0x01, 0x88, // "B" (U+0042)
  0x00, 0x43, 0x40, 0x01, 0x04, 0x06, 0x05, 0x01, 0x97, // "C" (U+0043)
  0x00, 0x44, 0x40, 0x01, 0x05, 0x06, 0x06, 0x01, 0xA6, // "D" (U+0044)
  0x00, 0x45, 0x40, 0x01, 0x03, 0x06, 0x04, 0x01, 0xB8, // "E" (U+0045)
  0x00, 0x46, 0x40, 0x01, 0x03, 0x06, 0x04, 0x01, 0xC4, // "F" (U+0046)
  0x00, 0x47, 0x40, 0x01, 0x05, 0x06, 0x06, 0x01, 0xD0, // "G" (U+0047)
  0x00, 0x48, 0x40, 0x01, 0x05, 0x06, 0x06, 0x01, 0xE2, // "H" (U+0048)
  0x00, 0x49, 0x40, 0x01, 0x02, 0x06, 0x03, 0x01, 0xF4, // "I" (U+0049)
  0x00, 0x4A, 0xBF, 0xFF, 0x01, 0x06, 0x03, 0x01, 0xFD, // "J" (U+004A)
  0x00, 0x4B, 0x40, 0x01, 0x05, 0x06, 0x05, 0x02, 0x09, // "K" (U+004B)
  0x00, 0x4C, 0x40, 0x01, 0x04, 0x06, 0x05, 0x02, 0x1B, // "L" (U+004C)
  0x00, 0x4D, 0x40, 0x01, 0x06, 0x06, 0x08, 0x02, 0x2A, // "M" (U+004D)
  0x00, 0x4E, 0x40, 0x01, 0x05, 0x06, 0x07, 0x02, 0x3F, // "N" (U+004E)
  0x00, 0x4F, 0x40, 0x01, 0x05, 0x06, 0x06, 0x02, 0x51, // "O" (U+004F)
  0x00, 0x50, 0x40, 0x01, 0x04, 0x06, 0x05, 0x02, 0x63, // "P" (U+0050)
  0x00, 0x51, 0x40, 0xFF, 0x05, 0x06, 0x06, 0x02, 0x72, // "Q" (U+0051)
  0x00, 0x52, 0x40, 0x01, 0x05, 0x06, 0x05, 0x02, 0x8A, // "R" (U+0052)
  0x00, 0x53, 0x40, 0x01, 0x03, 0x06, 0x04, 0x02, 0x9C, // "S" (U+0053)
  0x00, 0x54, 0x40, 0x01, 0x04, 0x06, 0x05, 0x02, 0xA8, // "T" (U+0054)
  0x00, 0x55, 0x40, 0x01, 0x05, 0x06, 0x06, 0x02, 0xB7, // "U" (U+0055)
  0x00, 0x56, 0x40, 0x01, 0x04, 0x06, 0x05, 0x02, 0xC9, // "V" (U+0056)
  0x00, 0x57, 0x40, 0x01, 0x07, 0x06, 0x08, 0x02, 0xD8, // "W" (U+0057)
  0x00, 0x58, 0x40, 0x01, 0x05, 0x06, 0x05, 0x02, 0xF0, // "X" (U+0058)
  0x00, 0x59, 0x40, 0x01, 0x04, 0x06, 0x05, 0x03, 0x02, // "Y" (U+0059)
  0x00, 0x5A, 0x40, 0x01, 0x04, 0x06, 0x05, 0x03, 0x11, // "Z" (U+005A)
  0x00, 0x5B, 0x40, 0xFE, 0x02, 0x06, 0x03, 0x03, 0x20, // "[" (U+005B)
  0x00, 0x5C, 0x40, 0x01, 0x03, 0x06, 0x03, 0x03, 0x2E, // "\" (U+005C)
  0x00, 0x5D, 0x40, 0xFE, 0x02, 0x06, 0x03, 0x03, 0x3A, // "]" (U+005D)
  0x00, 0x5E, 0x40, 0x03, 0x04, 0x06, 0x05, 0x03, 0x48, // "^" (U+005E)
  0x00, 0x5F, 0x40, 0xFF, 0x03, 0xFF, 0x03, 0x03, 0x52, // "_" (U+005F)
  0x00, 0x60, 0x40, 0x06, 0x02, 0x07, 0x03, 0x03, 0x54, // "`" (U+0060)
  0x00, 0x61, 0x40, 0x01, 0x04, 0x05, 0x05, 0x03, 0x57, // "a" (U+0061)
  0x00, 0x62, 0x40, 0x01, 0x04, 0x07, 0x05, 0x03, 0x64, // "b" (U+0062)
  0x00, 0x63, 0x40, 0x01, 0x03, 0x05, 0x04, 0x03, 0x76, // "c" (U+0063)
  0x00, 0x64, 0x40, 0x01, 0x04, 0x07, 0x05, 0x03, 0x80, // "d" (U+0064)
  0x00, 0x65, 0x40, 0x01, 0x04, 0x05, 0x05, 0x03, 0x92, // "e" (U+0065)
  0x00, 0x66, 0x40, 0x01, 0x03, 0x07, 0x03, 0x03, 0x9F, // "f" (U+0066)
  0x00, 0x67, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x03, 0xAD, // "g" (U+0067)
  0x00, 0x68, 0x40, 0x01, 0x04, 0x07, 0x05, 0x03, 0xBF, // "h" (U+0068)
  0x00, 0x69, 0x40, 0x01, 0x01, 0x07, 0x02, 0x03, 0xD1, // "i" (U+0069)
  0x00, 0x6A, 0xBF, 0xFF, 0x01, 0x07, 0x02, 0x03, 0xD8, // "j" (U+006A)
  0x00, 0x6B, 0x40, 0x01, 0x04, 0x07, 0x05, 0x03, 0xE6, // "k" (U+006B)
  0x00, 0x6C, 0x40, 0x01, 0x01, 0x07, 0x02, 0x03, 0xF8, // "l" (U+006C)
  0x00, 0x6D, 0x40, 0x01, 0x07, 0x05, 0x08, 0x03, 0xFF, // "m" (U+006D)
  0x00, 0x6E, 0x40, 0x01, 0x04, 0x05, 0x05, 0x04, 0x13, // "n" (U+006E)
  0x00, 0x6F, 0x40, 0x01, 0x04, 0x05, 0x05, 0x04, 0x20, // "o" (U+006F)
  0x00, 0x70, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x04, 0x2D, // "p" (U+0070)
  0x00, 0x71, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x04, 0x3F, // "q" (U+0071)
  0x00, 0x72, 0x40, 0x01, 0x03, 0x05, 0x04, 0x04, 0x51, // "r" (U+0072)
  0x00, 0x73, 0x40, 0x01, 0x03, 0x05, 0x04, 0x04, 0x5B, // "s" (U+0073)
  0x00, 0x74, 0x40, 0x01, 0x03, 0x06, 0x03, 0x04, 0x65, // "t" (U+0074)
  0x00, 0x75, 0x40, 0x01, 0x04, 0x05, 0x05, 0x04, 0x71, // "u" (U+0075)
  0x00, 0x76, 0x40, 0x01, 0x04, 0x05, 0x05, 0x04, 0x7E, // "v" (U+0076)
  0x00, 0x77, 0x40, 0x01, 0x06, 0x05, 0x07, 0x04, 0x8B, // "w" (U+0077)
  0x00, 0x78, 0x40, 0x01, 0x04, 0x05, 0x05, 0x04, 0x9D, // "x" (U+0078)
  0x00, 0x79, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x04, 0xAA, // "y" (U+0079)
  0x00, 0x7A, 0x40, 0x01, 0x03, 0x05, 0x04, 0x04, 0xBC, // "z" (U+007A)
  0x00, 0x7B, 0x40, 0xFE, 0x02, 0x06, 0x03, 0x04, 0xC6, // "{" (U+007B)
  0x00, 0x7C, 0x41, 0xFF, 0x02, 0x07, 0x04, 0x04, 0xD4, // "|" (U+007C)
  0x00, 0x7D, 0x40, 0xFE, 0x02, 0x06, 0x03, 0x04, 0xDD, // "}" (U+007D)
  0x00, 0x7E, 0x40, 0x02, 0x04, 0x03, 0x05, 0x04, 0xEB, // "~" (U+007E)
  0x00, 0xA1, 0x40, 0x00, 0x01, 0x05, 0x02, 0x04, 0xF0, // "¡" (U+00A1)
  0x00, 0xA2, 0x40, 0x01, 0x03, 0x06, 0x05, 0x04, 0xF6, // "¢" (U+00A2)
  0x00, 0xA3, 0x40, 0x01, 0x04, 0x06, 0x05, 0x05, 0x02, // "£" (U+00A3)
  0x00, 0xA4, 0x40, 0x01, 0x03, 0x06, 0x05, 0x05, 0x11, // "¤" (U+00A4)
  0x00, 0xA5, 0x40, 0x01, 0x04, 0x06, 0x05, 0x05, 0x1D, // "¥" (U+00A5)
  0x00, 0xA6, 0x41, 0xFF, 0x02, 0x07, 0x04, 0x05, 0x2C, // "¦" (U+00A6)
  0x00, 0xA7, 0x40, 0x01, 0x03, 0x07, 0x04, 0x05, 0x35, // "§" (U+00A7)
  0x00, 0xA8, 0x41, 0x07, 0x03, 0x07, 0x05, 0x05, 0x43, // "¨" (U+00A8)
  0x00, 0xA9, 0x40, 0x01, 0x06, 0x07, 0x07, 0x05, 0x45, // "©" (U+00A9)
  0x00, 0xAA, 0x40, 0x04, 0x02, 0x06, 0x03, 0x05, 0x5E, // "ª" (U+00AA)
  0x00, 0xAB, 0x40, 0x01, 0x04, 0x04, 0x05, 0x05, 0x63, // "«" (U+00AB)
  0x00, 0xAC, 0x40, 0x02, 0x04, 0x04, 0x05, 0x05, 0x6D, // "¬" (U+00AC)
  0x00, 0xAE, 0x40, 0x01, 0x06, 0x07, 0x07, 0x05, 0x75, // "®" (U+00AE)
  0x00, 0xAF, 0x40, 0x07, 0x03, 0x08, 0x04, 0x05, 0x8E, // "¯" (U+00AF)
  0x00, 0xB0, 0x40, 0x04, 0x02, 0x06, 0x03, 0x05, 0x92, // "°" (U+00B0)
  0x00, 0xB1, 0x40, 0x01, 0x04, 0x05, 0x05, 0x05, 0x97, // "±" (U+00B1)
  0x00, 0xB2, 0x40, 0x04, 0x02, 0x07, 0x03, 0x05, 0xA4, // "²" (U+00B2)
  0x00, 0xB3, 0x40, 0x04, 0x02, 0x07, 0x03, 0x05, 0xAA, // "³" (U+00B3)
  0x00, 0xB4, 0x40, 0x06, 0x02, 0x07, 0x03, 0x05, 0xB0, // "´" (U+00B4)
  0x00, 0xB5, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x05, 0xB3, // "µ" (U+00B5)
  0x00, 0xB6, 0x40, 0x00, 0x04, 0x07, 0x05, 0x05, 0xC5, // "¶" (U+00B6)
  0x00, 0xB7, 0x40, 0x03, 0x01, 0x03, 0x02, 0x05, 0xD9, // "·" (U+00B7)
  0x00, 0xB8, 0xBF, 0xFF, 0x01, 0x01, 0x02, 0x05, 0xDA, // "¸" (U+00B8)
  0x00, 0xB9, 0x40, 0x04, 0x02, 0x06, 0x03, 0x05, 0xDF, // "¹" (U+00B9)
  0x00, 0xBA, 0x40, 0x04, 0x02, 0x06, 0x03, 0x05, 0xE4, // "º" (U+00BA)
  0x00, 0xBB, 0x40, 0x01, 0x04, 0x04, 0x05, 0x05, 0xE9, // "»" (U+00BB)
  0x00, 0xBC, 0x40, 0x01, 0x06, 0x06, 0x07, 0x05, 0xF3, // "¼" (U+00BC)
  0x00, 0xBD, 0x40, 0x00, 0x06, 0x06, 0x07, 0x06, 0x08, // "½" (U+00BD)
  0x00, 0xBE, 0x40, 0x01, 0x06, 0x07, 0x07, 0x06, 0x21, // "¾" (U+00BE)
  0x00, 0xBF, 0x40, 0xFF, 0x03, 0x04, 0x04, 0x06, 0x3A, // "¿" (U+00BF)
  0x00, 0xC0, 0x40, 0x01, 0x05, 0x08, 0x06, 0x06, 0x46, // "À" (U+00C0)
  0x00, 0xC1, 0x40, 0x01, 0x05, 0x08, 0x06, 0x06, 0x5E, // "Á" (U+00C1)
  0x00, 0xC2, 0x40, 0x01, 0x05, 0x08, 0x06, 0x06, 0x76, // "Â" (U+00C2)
  0x00, 0xC3, 0x40, 0x01, 0x05, 0x07, 0x06, 0x06, 0x8E, // "Ã" (U+00C3)
  0x00, 0xC4, 0x40, 0x01, 0x05, 0x08, 0x06, 0x06, 0xA3, // "Ä" (U+00C4)
  0x00, 0xC5, 0x40, 0x01, 0x05, 0x07, 0x06, 0x06, 0xBB, // "Å" (U+00C5)
  0x00, 0xC6, 0x40, 0x01, 0x07, 0x06, 0x08, 0x06, 0xD0, // "Æ" (U+00C6)
  0x00, 0xC7, 0x40, 0xFF, 0x04, 0x06, 0x05, 0x06, 0xE8, // "Ç" (U+00C7)
  0x00, 0xC8, 0x40, 0x01, 0x03, 0x08, 0x04, 0x06, 0xFC, // "È" (U+00C8)
  0x00, 0xC9, 0x40, 0x01, 0x03, 0x08, 0x04, 0x07, 0x0C, // "É" (U+00C9)
  0x00, 0xCA, 0x40, 0x01, 0x03, 0x08, 0x04, 0x07, 0x1C, // "Ê" (U+00CA)
  0x00, 0xCB, 0x40, 0x01, 0x03, 0x08, 0x04, 0x07, 0x2C, // "Ë" (U+00CB)
  0x00, 0xCC, 0x40, 0x01, 0x02, 0x08, 0x03, 0x07, 0x3C, // "Ì" (U+00CC)
  0x00, 0xCD, 0x40, 0x01, 0x03, 0x08, 0x03, 0x07, 0x48, // "Í" (U+00CD)
  0x00, 0xCE, 0x40, 0x01, 0x03, 0x08, 0x03, 0x07, 0x58, // "Î" (U+00CE)
  0x00, 0xCF, 0x40, 0x01, 0x02, 0x08, 0x03, 0x07, 0x68, // "Ï" (U+00CF)
  0x00, 0xD0, 0x40, 0x01, 0x05, 0x06, 0x06, 0x07, 0x74, // "Ð" (U+00D0)
  0x00, 0xD1, 0x40, 0x01, 0x05, 0x07, 0x07, 0x07, 0x86, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x40, 0x01, 0x05, 0x08, 0x06, 0x07, 0x9B, // "Ò" (U+00D2)
  0x00, 0xD3, 0x40, 0x01, 0x05, 0x08, 0x06, 0x07, 0xB3, // "Ó" (U+00D3)
  0x00, 0xD4, 0x40, 0x01, 0x05, 0x08, 0x06, 0x07, 0xCB, // "Ô" (U+00D4)
  0x00, 0xD5, 0x40, 0x01, 0x05, 0x07, 0x06, 0x07, 0xE3, // "Õ" (U+00D5)
  0x00, 0xD6, 0x40, 0x01, 0x05, 0x08, 0x06, 0x07, 0xF8, // "Ö" (U+00D6)
  0x00, 0xD7, 0x40, 0x02, 0x03, 0x05, 0x05, 0x08, 0x10, // "×" (U+00D7)
  0x00, 0xD8, 0x40, 0x00, 0x05, 0x06, 0x06, 0x08, 0x18, // "Ø" (U+00D8)
  0x00, 0xD9, 0x40, 0x01, 0x05, 0x08, 0x06, 0x08, 0x2D, // "Ù" (U+00D9)
  0x00, 0xDA, 0x40, 0x01, 0x05, 0x08, 0x06, 0x08, 0x45, // "Ú" (U+00DA)
  0x00, 0xDB, 0x40, 0x01, 0x05, 0x08, 0x06, 0x08, 0x5D, // "Û" (U+00DB)
  0x00, 0xDC, 0x40, 0x01, 0x05, 0x08, 0x06, 0x08, 0x75, // "Ü" (U+00DC)
  0x00, 0xDD, 0x40, 0x01, 0x04, 0x08, 0x05, 0x08, 0x8D, // "Ý" (U+00DD)
  0x00, 0xDE, 0x40, 0x01, 0x04, 0x06, 0x05, 0x08, 0xA1, // "Þ" (U+00DE)
  0x00, 0xDF, 0x40, 0x01, 0x05, 0x07, 0x06, 0x08, 0xB0, // "ß" (U+00DF)
  0x00, 0xE0, 0x40, 0x01, 0x04, 0x07, 0x05, 0x08, 0xC5, // "à" (U+00E0)
  0x00, 0xE1, 0x40, 0x01, 0x04, 0x07, 0x05, 0x08, 0xD7, // "á" (U+00E1)
  0x00, 0xE2, 0x40, 0x01, 0x04, 0x07, 0x05, 0x08, 0xE9, // "â" (U+00E2)
  0x00, 0xE3, 0x40, 0x01, 0x04, 0x06, 0x05, 0x08, 0xFB, // "ã" (U+00E3)
  0x00, 0xE4, 0x40, 0x01, 0x04, 0x07, 0x05, 0x09, 0x0A, // "ä" (U+00E4)
  0x00, 0xE5, 0x40, 0x01, 0x04, 0x07, 0x05, 0x09, 0x1C, // "å" (U+00E5)
  0x00, 0xE6, 0x40, 0x01, 0x06, 0x05, 0x07, 0x09, 0x2E, // "æ" (U+00E6)
  0x00, 0xE7, 0x40, 0xFF, 0x03, 0x05, 0x04, 0x09, 0x40, // "ç" (U+00E7)
  0x00, 0xE8, 0x40, 0x01, 0x04, 0x07, 0x05, 0x09, 0x4E, // "è" (U+00E8)
  0x00, 0xE9, 0x40, 0x01, 0x04, 0x07, 0x05, 0x09, 0x60, // "é" (U+00E9)
  0x00, 0xEA, 0x40, 0x01, 0x04, 0x07, 0x05, 0x09, 0x72, // "ê" (U+00EA)
  0x00, 0xEB, 0x40, 0x01, 0x04, 0x07, 0x05, 0x09, 0x84, // "ë" (U+00EB)
  0x00, 0xEC, 0xBF, 0x01, 0x01, 0x07, 0x02, 0x09, 0x96, // "ì" (U+00EC)
  0x00, 0xED, 0x40, 0x01, 0x02, 0x07, 0x02, 0x09, 0xA1, // "í" (U+00ED)
  0x00, 0xEE, 0xBF, 0x01, 0x02, 0x07, 0x02, 0x09, 0xAC, // "î" (U+00EE)
  0x00, 0xEF, 0x40, 0x01, 0x02, 0x07, 0x02, 0x09, 0xBA, // "ï" (U+00EF)
  0x00, 0xF0, 0x40, 0x01, 0x04, 0x08, 0x05, 0x09, 0xC5, // "ð" (U+00F0)
  0x00, 0xF1, 0x40, 0x01, 0x04, 0x06, 0x05, 0x09, 0xD9, // "ñ" (U+00F1)
  0x00, 0xF2, 0x40, 0x01, 0x04, 0x07, 0x05, 0x09, 0xE8, // "ò" (U+00F2)
  0x00, 0xF3, 0x40, 0x01, 0x04, 0x07, 0x05, 0x09, 0xFA, // "ó" (U+00F3)
  0x00, 0xF4, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x0C, // "ô" (U+00F4)
  0x00, 0xF5, 0x40, 0x01, 0x04, 0x06, 0x05, 0x0A, 0x1E, // "õ" (U+00F5)
  0x00, 0xF6, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x2D, // "ö" (U+00F6)
  0x00, 0xF7, 0x40, 0x02, 0x04, 0x05, 0x05, 0x0A, 0x3E, // "÷" (U+00F7)
  0x00, 0xF8, 0x40, 0x00, 0x04, 0x05, 0x05, 0x0A, 0x48, // "ø" (U+00F8)
  0x00, 0xF9, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x57, // "ù" (U+00F9)
  0x00, 0xFA, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x69, // "ú" (U+00FA)
  0x00, 0xFB, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x7B, // "û" (U+00FB)
  0x00, 0xFC, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x8D, // "ü" (U+00FC)
  0x00, 0xFD, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x0A, 0x9F, // "ý" (U+00FD)
  0x00, 0xFE, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x0A, 0xB6, // "þ" (U+00FE)
  0x00, 0xFF, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x0A, 0xCD, // "ÿ" (U+00FF)
  0x01, 0x00, 0x40, 0x01, 0x05, 0x07, 0x06, 0x0A, 0xE4, // "Ā" (U+0100)
  0x01, 0x01, 0x40, 0x01, 0x04, 0x06, 0x05, 0x0A, 0xF9, // "ā" (U+0101)
  0x01, 0x02, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0B, 0x08, // "Ă" (U+0102)
  0x01, 0x03, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0B, 0x23, // "ă" (U+0103)
  0x01, 0x04, 0x40, 0xFE, 0x05, 0x06, 0x06, 0x0B, 0x37, // "Ą" (U+0104)
  0x01, 0x05, 0x40, 0xFE, 0x04, 0x05, 0x05, 0x0B, 0x52, // "ą" (U+0105)
  0x01, 0x06, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0B, 0x66, // "Ć" (U+0106)
  0x01, 0x07, 0x40, 0x01, 0x03, 0x07, 0x04, 0x0B, 0x7A, // "ć" (U+0107)
  0x01, 0x08, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0B, 0x88, // "Ĉ" (U+0108)
  0x01, 0x09, 0x40, 0x01, 0x03, 0x07, 0x04, 0x0B, 0x9C, // "ĉ" (U+0109)
  0x01, 0x0A, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0B, 0xAA, // "Ċ" (U+010A)
  0x01, 0x0B, 0x40, 0x01, 0x03, 0x07, 0x04, 0x0B, 0xBE, // "ċ" (U+010B)
  0x01, 0x0C, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0B, 0xCC, // "Č" (U+010C)
  0x01, 0x0D, 0x40, 0x01, 0x03, 0x07, 0x04, 0x0B, 0xE0, // "č" (U+010D)
  0x01, 0x0E, 0x40, 0x01, 0x05, 0x08, 0x06, 0x0B, 0xEE, // "Ď" (U+010E)
  0x01, 0x0F, 0x40, 0x01, 0x05, 0x07, 0x05, 0x0C, 0x06, // "ď" (U+010F)
  0x01, 0x10, 0x40, 0x01, 0x05, 0x06, 0x06, 0x0C, 0x1B, // "Đ" (U+0110)
  0x01, 0x11, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0C, 0x2D, // "đ" (U+0111)
  0x01, 0x12, 0x40, 0x01, 0x03, 0x07, 0x04, 0x0C, 0x3F, // "Ē" (U+0112)
  0x01, 0x13, 0x40, 0x01, 0x04, 0x06, 0x05, 0x0C, 0x4D, // "ē" (U+0113)
  0x01, 0x14, 0x40, 0x01, 0x04, 0x09, 0x04, 0x0C, 0x5C, // "Ĕ" (U+0114)
  0x01, 0x15, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0C, 0x73, // "ĕ" (U+0115)
  0x01, 0x16, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0C, 0x87, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0C, 0x96, // "ė" (U+0117)
  0x01, 0x18, 0x40, 0xFE, 0x03, 0x06, 0x04, 0x0C, 0xA7, // "Ę" (U+0118)
  0x01, 0x19, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x0C, 0xB9, // "ę" (U+0119)
  0x01, 0x1A, 0x40, 0x01, 0x03, 0x08, 0x04, 0x0C, 0xCB, // "Ě" (U+011A)
  0x01, 0x1B, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0C, 0xDB, // "ě" (U+011B)
  0x01, 0x1C, 0x40, 0x01, 0x05, 0x08, 0x06, 0x0C, 0xED, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x0D, 0x05, // "ĝ" (U+011D)
  0x01, 0x1E, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0D, 0x1C, // "Ğ" (U+011E)
  0x01, 0x1F, 0x40, 0xFF, 0x04, 0x08, 0x05, 0x0D, 0x37, // "ğ" (U+011F)
  0x01, 0x20, 0x00, 0x01, 0x05, 0x08, 0x06, 0x0D, 0x50, // "Ġ" (U+0120)
  0x01, 0x21, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0D, 0x67, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0xFF, 0x05, 0x06, 0x06, 0x0D, 0x7D, // "Ģ" (U+0122)
  0x01, 0x23, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0D, 0x94, // "ģ" (U+0123)
  0x01, 0x24, 0x40, 0x01, 0x05, 0x08, 0x06, 0x0D, 0xA9, // "Ĥ" (U+0124)
  0x01, 0x25, 0xBF, 0x01, 0x04, 0x09, 0x05, 0x0D, 0xC1, // "ĥ" (U+0125)
  0x01, 0x26, 0x40, 0x01, 0x06, 0x06, 0x06, 0x0D, 0xDC, // "Ħ" (U+0126)
  0x01, 0x27, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0D, 0xF1, // "ħ" (U+0127)
  0x01, 0x28, 0x40, 0x01, 0x03, 0x07, 0x03, 0x0E, 0x03, // "Ĩ" (U+0128)
  0x01, 0x29, 0xBF, 0x01, 0x02, 0x06, 0x02, 0x0E, 0x11, // "ĩ" (U+0129)
  0x01, 0x2A, 0x40, 0x01, 0x02, 0x07, 0x03, 0x0E, 0x1D, // "Ī" (U+012A)
  0x01, 0x2B, 0x40, 0x01, 0x02, 0x06, 0x02, 0x0E, 0x28, // "ī" (U+012B)
  0x01, 0x2C, 0x40, 0x01, 0x03, 0x09, 0x03, 0x0E, 0x31, // "Ĭ" (U+012C)
  0x01, 0x2D, 0xBF, 0x01, 0x02, 0x08, 0x02, 0x0E, 0x43, // "ĭ" (U+012D)
  0x01, 0x2E, 0x40, 0xFE, 0x02, 0x06, 0x03, 0x0E, 0x53, // "Į" (U+012E)
  0x01, 0x2F, 0x40, 0xFE, 0x01, 0x07, 0x02, 0x0E, 0x61, // "į" (U+012F)
  0x01, 0x30, 0x40, 0x01, 0x02, 0x08, 0x03, 0x0E, 0x6B, // "İ" (U+0130)
  0x01, 0x31, 0x40, 0x01, 0x01, 0x05, 0x02, 0x0E, 0x77, // "ı" (U+0131)
  0x01, 0x32, 0x40, 0xFF, 0x04, 0x06, 0x06, 0x0E, 0x7C, // "Ĳ" (U+0132)
  0x01, 0x33, 0x40, 0xFF, 0x03, 0x07, 0x05, 0x0E, 0x90, // "ĳ" (U+0133)
  0x01, 0x34, 0xBF, 0xFF, 0x02, 0x08, 0x03, 0x0E, 0xA2, // "Ĵ" (U+0134)
  0x01, 0x35, 0xBF, 0xFF, 0x02, 0x07, 0x02, 0x0E, 0xB6, // "ĵ" (U+0135)
  0x01, 0x36, 0x40, 0xFF, 0x05, 0x06, 0x05, 0x0E, 0xC8, // "Ķ" (U+0136)
  0x01, 0x37, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x0E, 0xE0, // "ķ" (U+0137)
  0x01, 0x38, 0x40, 0x01, 0x04, 0x05, 0x05, 0x0E, 0xF7, // "ĸ" (U+0138)
  0x01, 0x39, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0F, 0x04, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x40, 0x01, 0x02, 0x09, 0x02, 0x0F, 0x18, // "ĺ" (U+013A)
  0x01, 0x3B, 0x00, 0xFF, 0x04, 0x06, 0x05, 0x0F, 0x26, // "Ļ" (U+013B)
  0x01, 0x3C, 0x40, 0xFF, 0x01, 0x07, 0x02, 0x0F, 0x39, // "ļ" (U+013C)
  0x01, 0x3D, 0x40, 0x01, 0x04, 0x06, 0x05, 0x0F, 0x42, // "Ľ" (U+013D)
  0x01, 0x3E, 0x40, 0x01, 0x03, 0x07, 0x02, 0x0F, 0x51, // "ľ" (U+013E)
  0x01, 0x3F, 0x40, 0x01, 0x04, 0x06, 0x05, 0x0F, 0x5F, // "Ŀ" (U+013F)
  0x01, 0x40, 0x40, 0x01, 0x03, 0x07, 0x03, 0x0F, 0x6E, // "ŀ" (U+0140)
  0x01, 0x41, 0x40, 0x01, 0x04, 0x06, 0x05, 0x0F, 0x7C, // "Ł" (U+0141)
  0x01, 0x42, 0x40, 0x01, 0x02, 0x07, 0x02, 0x0F, 0x8B, // "ł" (U+0142)
  0x01, 0x43, 0x40, 0x01, 0x05, 0x08, 0x07, 0x0F, 0x96, // "Ń" (U+0143)
  0x01, 0x44, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0F, 0xAE, // "ń" (U+0144)
  0x01, 0x45, 0x00, 0xFF, 0x05, 0x06, 0x07, 0x0F, 0xC0, // "Ņ" (U+0145)
  0x01, 0x46, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x0F, 0xD7, // "ņ" (U+0146)
  0x01, 0x47, 0x40, 0x01, 0x05, 0x08, 0x07, 0x0F, 0xE8, // "Ň" (U+0147)
  0x01, 0x48, 0x40, 0x01, 0x04, 0x07, 0x05, 0x10, 0x00, // "ň" (U+0148)
  0x01, 0x49, 0x40, 0x01, 0x05, 0x06, 0x06, 0x10, 0x12, // "ŉ" (U+0149)
  0x01, 0x4A, 0x40, 0xFE, 0x05, 0x06, 0x07, 0x10, 0x24, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x10, 0x3F, // "ŋ" (U+014B)
  0x01, 0x4C, 0x40, 0x01, 0x05, 0x07, 0x06, 0x10, 0x51, // "Ō" (U+014C)
  0x01, 0x4D, 0x40, 0x01, 0x04, 0x06, 0x05, 0x10, 0x66, // "ō" (U+014D)
  0x01, 0x4E, 0x40, 0x01, 0x05, 0x09, 0x06, 0x10, 0x75, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x40, 0x01, 0x04, 0x08, 0x05, 0x10, 0x90, // "ŏ" (U+014F)
  0x01, 0x50, 0x40, 0x01, 0x05, 0x08, 0x06, 0x10, 0xA4, // "Ő" (U+0150)
  0x01, 0x51, 0x40, 0x01, 0x04, 0x07, 0x05, 0x10, 0xBC, // "ő" (U+0151)
  0x01, 0x52, 0x40, 0x01, 0x07, 0x06, 0x08, 0x10, 0xCE, // "Œ" (U+0152)
  0x01, 0x53, 0x40, 0x01, 0x07, 0x05, 0x08, 0x10, 0xE6, // "œ" (U+0153)
  0x01, 0x54, 0x40, 0x01, 0x05, 0x08, 0x05, 0x10, 0xFA, // "Ŕ" (U+0154)
  0x01, 0x55, 0x40, 0x01, 0x03, 0x07, 0x04, 0x11, 0x12, // "ŕ" (U+0155)
  0x01, 0x56, 0x40, 0xFF, 0x05, 0x06, 0x05, 0x11, 0x20, // "Ŗ" (U+0156)
  0x01, 0x57, 0x40, 0xFF, 0x03, 0x05, 0x04, 0x11, 0x38, // "ŗ" (U+0157)
  0x01, 0x58, 0x40, 0x01, 0x05, 0x08, 0x05, 0x11, 0x46, // "Ř" (U+0158)
  0x01, 0x59, 0x40, 0x01, 0x03, 0x07, 0x04, 0x11, 0x5E, // "ř" (U+0159)
  0x01, 0x5A, 0x40, 0x01, 0x03, 0x08, 0x04, 0x11, 0x6C, // "Ś" (U+015A)
  0x01, 0x5B, 0x40, 0x01, 0x03, 0x07, 0x04, 0x11, 0x7C, // "ś" (U+015B)
  0x01, 0x5C, 0x40, 0x01, 0x03, 0x08, 0x04, 0x11, 0x8A, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x40, 0x01, 0x03, 0x07, 0x04, 0x11, 0x9A, // "ŝ" (U+015D)
  0x01, 0x5E, 0x40, 0xFF, 0x03, 0x06, 0x04, 0x11, 0xA8, // "Ş" (U+015E)
  0x01, 0x5F, 0x40, 0xFF, 0x03, 0x05, 0x04, 0x11, 0xB8, // "ş" (U+015F)
  0x01, 0x60, 0x40, 0x01, 0x03, 0x08, 0x04, 0x11, 0xC6, // "Š" (U+0160)
  0x01, 0x61, 0x40, 0x01, 0x03, 0x07, 0x04, 0x11, 0xD6, // "š" (U+0161)
  0x01, 0x62, 0x40, 0xFF, 0x04, 0x06, 0x05, 0x11, 0xE4, // "Ţ" (U+0162)
  0x01, 0x63, 0x40, 0xFF, 0x03, 0x06, 0x03, 0x11, 0xF8, // "ţ" (U+0163)
  0x01, 0x64, 0x40, 0x01, 0x04, 0x08, 0x05, 0x12, 0x08, // "Ť" (U+0164)
  0x01, 0x65, 0x40, 0x01, 0x04, 0x07, 0x03, 0x12, 0x1C, // "ť" (U+0165)
  0x01, 0x66, 0x40, 0x01, 0x04, 0x06, 0x05, 0x12, 0x2E, // "Ŧ" (U+0166)
  0x01, 0x67, 0x40, 0x01, 0x03, 0x06, 0x03, 0x12, 0x3D, // "ŧ" (U+0167)
  0x01, 0x68, 0x40, 0x01, 0x05, 0x07, 0x06, 0x12, 0x49, // "Ũ" (U+0168)
  0x01, 0x69, 0x40, 0x01, 0x04, 0x06, 0x05, 0x12, 0x5E, // "ũ" (U+0169)
  0x01, 0x6A, 0x40, 0x01, 0x05, 0x07, 0x06, 0x12, 0x6D, // "Ū" (U+016A)
  0x01, 0x6B, 0x40, 0x01, 0x04, 0x06, 0x05, 0x12, 0x82, // "ū" (U+016B)
  0x01, 0x6C, 0x40, 0x01, 0x05, 0x09, 0x06, 0x12, 0x91, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x40, 0x01, 0x04, 0x08, 0x05, 0x12, 0xAC, // "ŭ" (U+016D)
  0x01, 0x6E, 0x40, 0x01, 0x05, 0x08, 0x06, 0x12, 0xC0, // "Ů" (U+016E)
  0x01, 0x6F, 0x40, 0x01, 0x04, 0x07, 0x05, 0x12, 0xD8, // "ů" (U+016F)
  0x01, 0x70, 0x40, 0x01, 0x05, 0x08, 0x06, 0x12, 0xEA, // "Ű" (U+0170)
  0x01, 0x71, 0x40, 0x01, 0x04, 0x07, 0x05, 0x13, 0x02, // "ű" (U+0171)
  0x01, 0x72, 0x40, 0xFF, 0x05, 0x06, 0x06, 0x13, 0x14, // "Ų" (U+0172)
  0x01, 0x73, 0x40, 0xFE, 0x04, 0x05, 0x05, 0x13, 0x2C, // "ų" (U+0173)
  0x01, 0x74, 0x40, 0x01, 0x07, 0x08, 0x08, 0x13, 0x40, // "Ŵ" (U+0174)
  0x01, 0x75, 0x40, 0x01, 0x06, 0x07, 0x07, 0x13, 0x60, // "ŵ" (U+0175)
  0x01, 0x76, 0x40, 0x01, 0x04, 0x08, 0x05, 0x13, 0x79, // "Ŷ" (U+0176)
  0x01, 0x77, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x13, 0x8D, // "ŷ" (U+0177)
  0x01, 0x78, 0x40, 0x01, 0x04, 0x08, 0x05, 0x13, 0xA4, // "Ÿ" (U+0178)
  0x01, 0x79, 0x40, 0x01, 0x04, 0x08, 0x05, 0x13, 0xB8, // "Ź" (U+0179)
  0x01, 0x7A, 0x40, 0x01, 0x03, 0x07, 0x04, 0x13, 0xCC, // "ź" (U+017A)
  0x01, 0x7B, 0x40, 0x01, 0x04, 0x08, 0x05, 0x13, 0xDA, // "Ż" (U+017B)
  0x01, 0x7C, 0x40, 0x01, 0x03, 0x07, 0x04, 0x13, 0xEE, // "ż" (U+017C)
  0x01, 0x7D, 0x40, 0x01, 0x04, 0x08, 0x05, 0x13, 0xFC, // "Ž" (U+017D)
  0x01, 0x7E, 0x40, 0x01, 0x03, 0x07, 0x04, 0x14, 0x10, // "ž" (U+017E)
  0x01, 0x7F, 0x40, 0x01, 0x03, 0x07, 0x03, 0x14, 0x1E, // "ſ" (U+017F)
  0x03, 0xA9, 0x40, 0x01, 0x06, 0x06, 0x06, 0x14, 0x2C, // "Ω" (U+03A9)
  0x03, 0xBC, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x14, 0x41, // "μ" (U+03BC)
  0x03, 0xC0, 0x40, 0x01, 0x05, 0x05, 0x06, 0x14, 0x53, // "π" (U+03C0)
  0x20, 0x13, 0x40, 0x02, 0x03, 0x03, 0x04, 0x14, 0x62, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x02, 0x07, 0x03, 0x08, 0x14, 0x66, // "—" (U+2014)
  0x20, 0xAC, 0x40, 0x01, 0x04, 0x06, 0x05, 0x14, 0x6C, // "€" (U+20AC)
  0x20, 0xBF, 0x40, 0x00, 0x04, 0x07, 0x05, 0x14, 0x7B, // "₿" (U+20BF)
  0x20, 0x18, 0x40, 0x04, 0x01, 0x06, 0x02, 0x14, 0x8F, // "‘" (U+2018)
  0x20, 0x19, 0x40, 0x04, 0x01, 0x06, 0x02, 0x14, 0x92, // "’" (U+2019)
  0x20, 0x1A, 0x40, 0xFF, 0x01, 0x01, 0x02, 0x14, 0x95, // "‚" (U+201A)
  0x20, 0x1B, 0x40, 0x04, 0x01, 0x06, 0x02, 0x14, 0x98, // "‛" (U+201B)
  0x20, 0x1C, 0x40, 0x04, 0x03, 0x06, 0x04, 0x14, 0x9B, // "“" (U+201C)
  0x20, 0x1D, 0x40, 0x04, 0x03, 0x06, 0x04, 0x14, 0xA1, // "”" (U+201D)
  0x20, 0x1E, 0x40, 0xFF, 0x03, 0x01, 0x04, 0x14, 0xA7, // "„" (U+201E)
  0x20, 0x1F, 0x40, 0x04, 0x03, 0x06, 0x04, 0x14, 0xAD, // "‟" (U+201F)
  0x20, 0x20, 0x40, 0x01, 0x03, 0x07, 0x04, 0x14, 0xB3, // "†" (U+2020)
  0x20, 0x21, 0x40, 0x01, 0x03, 0x07, 0x04, 0x14, 0xC1, // "‡" (U+2021)
  0x20, 0x22, 0x40, 0x03, 0x02, 0x05, 0x03, 0x14, 0xCF, // "•" (U+2022)
  0x20, 0x26, 0x40, 0x01, 0x06, 0x01, 0x07, 0x14, 0xD4, // "…" (U+2026)
  0x20, 0x30, 0x40, 0x01, 0x09, 0x06, 0x0A, 0x14, 0xD8, // "‰" (U+2030)
  0x20, 0x39, 0x40, 0x01, 0x02, 0x04, 0x03, 0x14, 0xF6, // "‹" (U+2039)
  0x20, 0x3A, 0x40, 0x01, 0x02, 0x04, 0x03, 0x14, 0xFC, // "›" (U+203A)
  0x20, 0x44, 0xBE, 0x01, 0x02, 0x06, 0x01, 0x15, 0x02, // "⁄" (U+2044)
  0x21, 0x22, 0x40, 0x03, 0x05, 0x06, 0x06, 0x15, 0x11, // "™" (U+2122)
  0x21, 0x52, 0x40, 0x01, 0x08, 0x06, 0x09, 0x15, 0x1D, // "⅒" (U+2152)
  0xFB, 0x01, 0x40, 0x01, 0x04, 0x07, 0x06, 0x15, 0x38, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0x40, 0x01, 0x04, 0x07, 0x06, 0x15, 0x4A, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x01, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0xC0, 0x01, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x01, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x01, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x01, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x01, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x01, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xC6, 0x01, // "Æ (U+0022 U+00C6)
  0x00, 0x22, 0x01, 0x00, 0x01, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x02, 0x01, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x04, 0x01, // "Ą (U+0022 U+0104)
  0x00, 0x27, 0x00, 0x41, 0x01, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0xC0, 0x01, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x01, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x01, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x01, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x01, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x01, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xC6, 0x01, // 'Æ (U+0027 U+00C6)
  0x00, 0x27, 0x01, 0x00, 0x01, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x02, 0x01, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x04, 0x01, // 'Ą (U+0027 U+0104)
  0x00, 0x2C, 0x00, 0x54, 0x01, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x01, 0x62, 0x01, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x01, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x01, // ,Ŧ (U+002C U+0166)
  0x00, 0x2E, 0x00, 0x54, 0x01, // .T (U+002E U+0054)
  0x00, 0x2E, 0x01, 0x62, 0x01, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x01, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x01, // .Ŧ (U+002E U+0166)
  0x00, 0x41, 0x00, 0x22, 0x01, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x01, // A' (U+0041 U+0027)
  0x00, 0x41, 0x00, 0x54, 0x01, // AT (U+0041 U+0054)
  0x00, 0x41, 0x01, 0x62, 0x01, // AŢ (U+0041 U+0162)
  0x00, 0x41, 0x01, 0x64, 0x01, // AŤ (U+0041 U+0164)
  0x00, 0x41, 0x01, 0x66, 0x01, // AŦ (U+0041 U+0166)
  0x00, 0x41, 0x20, 0x19, 0x01, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1D, 0x01, // A” (U+0041 U+201D)
  0x00, 0x4C, 0x00, 0x22, 0x01, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x01, // L' (U+004C U+0027)
  0x00, 0x4C, 0x20, 0x19, 0x01, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1D, 0x01, // L” (U+004C U+201D)
  0x00, 0x50, 0x00, 0x2C, 0x01, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x01, // P. (U+0050 U+002E)
  0x00, 0x50, 0x20, 0x1A, 0x01, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x01, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x01, // P… (U+0050 U+2026)
  0x00, 0x54, 0x00, 0x41, 0x01, // TA (U+0054 U+0041)
  0x00, 0x54, 0x00, 0x61, 0x01, // Ta (U+0054 U+0061)
  0x00, 0x54, 0x00, 0x63, 0x01, // Tc (U+0054 U+0063)
  0x00, 0x54, 0x00, 0x64, 0x01, // Td (U+0054 U+0064)
  0x00, 0x54, 0x00, 0x65, 0x01, // Te (U+0054 U+0065)
  0x00, 0x54, 0x00, 0x67, 0x01, // Tg (U+0054 U+0067)
  0x00, 0x54, 0x00, 0x6F, 0x01, // To (U+0054 U+006F)
  0x00, 0x54, 0x00, 0x71, 0x01, // Tq (U+0054 U+0071)
  0x00, 0x54, 0x00, 0xC0, 0x01, // TÀ (U+0054 U+00C0)
  0x00, 0x54, 0x00, 0xC1, 0x01, // TÁ (U+0054 U+00C1)
  0x00, 0x54, 0x00, 0xC2, 0x01, // TÂ (U+0054 U+00C2)
  0x00, 0x54, 0x00, 0xC3, 0x01, // TÃ (U+0054 U+00C3)
  0x00, 0x54, 0x00, 0xC4, 0x01, // TÄ (U+0054 U+00C4)
  0x00, 0x54, 0x00, 0xC5, 0x01, // TÅ (U+0054 U+00C5)
  0x00, 0x54, 0x00, 0xE0, 0x01, // Tà (U+0054 U+00E0)
  0x00, 0x54, 0x00, 0xE1, 0x01, // Tá (U+0054 U+00E1)
  0x00, 0x54, 0x00, 0xE2, 0x01, // Tâ (U+0054 U+00E2)
  0x00, 0x54, 0x00, 0xE3, 0x01, // Tã (U+0054 U+00E3)
  0x00, 0x54, 0x00, 0xE4, 0x01, // Tä (U+0054 U+00E4)
  0x00, 0x54, 0x00, 0xE5, 0x01, // Tå (U+0054 U+00E5)
  0x00, 0x54, 0x00, 0xE6, 0x01, // Tæ (U+0054 U+00E6)
  0x00, 0x54, 0x00, 0xE7, 0x01, // Tç (U+0054 U+00E7)
  0x00, 0x54, 0x00, 0xE8, 0x01, // Tè (U+0054 U+00E8)
  0x00, 0x54, 0x00, 0xE9, 0x01, // Té (U+0054 U+00E9)
  0x00, 0x54, 0x00, 0xEA, 0x01, // Tê (U+0054 U+00EA)
  0x00, 0x54, 0x00, 0xEB, 0x01, // Të (U+0054 U+00EB)
  0x00, 0x54, 0x00, 0xF2, 0x01, // Tò (U+0054 U+00F2)
  0x00, 0x54, 0x00, 0xF3, 0x01, // Tó (U+0054 U+00F3)
  0x00, 0x54, 0x00, 0xF4, 0x01, // Tô (U+0054 U+00F4)
  0x00, 0x54, 0x00, 0xF5, 0x01, // Tõ (U+0054 U+00F5)
  0x00, 0x54, 0x00, 0xF6, 0x01, // Tö (U+0054 U+00F6)
  0x00, 0x54, 0x00, 0xF8, 0x01, // Tø (U+0054 U+00F8)
  0x00, 0x54, 0x01, 0x00, 0x01, // TĀ (U+0054 U+0100)
  0x00, 0x54, 0x01, 0x01, 0x01, // Tā (U+0054 U+0101)
  0x00, 0x54, 0x01, 0x02, 0x01, // TĂ (U+0054 U+0102)
  0x00, 0x54, 0x01, 0x03, 0x01, // Tă (U+0054 U+0103)
  0x00, 0x54, 0x01, 0x04, 0x01, // TĄ (U+0054 U+0104)
  0x00, 0x54, 0x01, 0x05, 0x01, // Tą (U+0054 U+0105)
  0x00, 0x54, 0x01, 0x07, 0x01, // Tć (U+0054 U+0107)
  0x00, 0x54, 0x01, 0x09, 0x01, // Tĉ (U+0054 U+0109)
  0x00, 0x54, 0x01, 0x0B, 0x01, // Tċ (U+0054 U+010B)
  0x00, 0x54, 0x01, 0x0D, 0x01, // Tč (U+0054 U+010D)
  0x00, 0x54, 0x01, 0x0F, 0x01, // Tď (U+0054 U+010F)
  0x00, 0x54, 0x01, 0x11, 0x01, // Tđ (U+0054 U+0111)
  0x00, 0x54, 0x01, 0x13, 0x01, // Tē (U+0054 U+0113)
  0x00, 0x54, 0x01, 0x15, 0x01, // Tĕ (U+0054 U+0115)
  0x00, 0x54, 0x01, 0x17, 0x01, // Tė (U+0054 U+0117)
  0x00, 0x54, 0x01, 0x19, 0x01, // Tę (U+0054 U+0119)
  0x00, 0x54, 0x01, 0x1B, 0x01, // Tě (U+0054 U+011B)
  0x00, 0x54, 0x01, 0x1D, 0x01, // Tĝ (U+0054 U+011D)
  0x00, 0x54, 0x01, 0x1F, 0x01, // Tğ (U+0054 U+011F)
  0x00, 0x54, 0x01, 0x21, 0x01, // Tġ (U+0054 U+0121)
  0x00, 0x54, 0x01, 0x23, 0x01, // Tģ (U+0054 U+0123)
  0x00, 0x54, 0x01, 0x4D, 0x01, // Tō (U+0054 U+014D)
  0x00, 0x54, 0x01, 0x4F, 0x01, // Tŏ (U+0054 U+014F)
  0x00, 0x54, 0x01, 0x51, 0x01, // Tő (U+0054 U+0151)
  0x00, 0x54, 0x01, 0x53, 0x01, // Tœ (U+0054 U+0153)
  0x00, 0x59, 0x00, 0xAB, 0x01, // Y« (U+0059 U+00AB)
  0x00, 0x59, 0x20, 0x39, 0x01, // Y‹ (U+0059 U+2039)
  0x00, 0x72, 0x00, 0x2C, 0x01, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x01, // r. (U+0072 U+002E)
  0x00, 0x72, 0x20, 0x1A, 0x01, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x01, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x01, // r… (U+0072 U+2026)
  0x00, 0xBB, 0x00, 0x59, 0x01, // »Y (U+00BB U+0059)
  0x00, 0xBB, 0x00, 0xDD, 0x01, // »Ý (U+00BB U+00DD)
  0x00, 0xBB, 0x01, 0x76, 0x01, // »Ŷ (U+00BB U+0176)
  0x00, 0xBB, 0x01, 0x78, 0x01, // »Ÿ (U+00BB U+0178)
  0x00, 0xC0, 0x00, 0x22, 0x01, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x01, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x00, 0x54, 0x01, // ÀT (U+00C0 U+0054)
  0x00, 0xC0, 0x01, 0x62, 0x01, // ÀŢ (U+00C0 U+0162)
  0x00, 0xC0, 0x01, 0x64, 0x01, // ÀŤ (U+00C0 U+0164)
  0x00, 0xC0, 0x01, 0x66, 0x01, // ÀŦ (U+00C0 U+0166)
  0x00, 0xC0, 0x20, 0x19, 0x01, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1D, 0x01, // À” (U+00C0 U+201D)
  0x00, 0xC1, 0x00, 0x22, 0x01, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x01, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x00, 0x54, 0x01, // ÁT (U+00C1 U+0054)
  0x00, 0xC1, 0x01, 0x62, 0x01, // ÁŢ (U+00C1 U+0162)
  0x00, 0xC1, 0x01, 0x64, 0x01, // ÁŤ (U+00C1 U+0164)
  0x00, 0xC1, 0x01, 0x66, 0x01, // ÁŦ (U+00C1 U+0166)
  0x00, 0xC1, 0x20, 0x19, 0x01, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1D, 0x01, // Á” (U+00C1 U+201D)
  0x00, 0xC2, 0x00, 0x22, 0x01, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x01, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x00, 0x54, 0x01, // ÂT (U+00C2 U+0054)
  0x00, 0xC2, 0x01, 0x62, 0x01, // ÂŢ (U+00C2 U+0162)
  0x00, 0xC2, 0x01, 0x64, 0x01, // ÂŤ (U+00C2 U+0164)
  0x00, 0xC2, 0x01, 0x66, 0x01, // ÂŦ (U+00C2 U+0166)
  0x00, 0xC2, 0x20, 0x19, 0x01, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1D, 0x01, // Â” (U+00C2 U+201D)
  0x00, 0xC3, 0x00, 0x22, 0x01, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x01, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x00, 0x54, 0x01, // ÃT (U+00C3 U+0054)
  0x00, 0xC3, 0x01, 0x62, 0x01, // ÃŢ (U+00C3 U+0162)
  0x00, 0xC3, 0x01, 0x64, 0x01, // ÃŤ (U+00C3 U+0164)
  0x00, 0xC3, 0x01, 0x66, 0x01, // ÃŦ (U+00C3 U+0166)
  0x00, 0xC3, 0x20, 0x19, 0x01, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1D, 0x01, // Ã” (U+00C3 U+201D)
  0x00, 0xC4, 0x00, 0x22, 0x01, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x01, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x00, 0x54, 0x01, // ÄT (U+00C4 U+0054)
  0x00, 0xC4, 0x01, 0x62, 0x01, // ÄŢ (U+00C4 U+0162)
  0x00, 0xC4, 0x01, 0x64, 0x01, // ÄŤ (U+00C4 U+0164)
  0x00, 0xC4, 0x01, 0x66, 0x01, // ÄŦ (U+00C4 U+0166)
  0x00, 0xC4, 0x20, 0x19, 0x01, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1D, 0x01, // Ä” (U+00C4 U+201D)
  0x00, 0xC5, 0x00, 0x22, 0x01, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x01, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x00, 0x54, 0x01, // ÅT (U+00C5 U+0054)
  0x00, 0xC5, 0x01, 0x62, 0x01, // ÅŢ (U+00C5 U+0162)
  0x00, 0xC5, 0x01, 0x64, 0x01, // ÅŤ (U+00C5 U+0164)
  0x00, 0xC5, 0x01, 0x66, 0x01, // ÅŦ (U+00C5 U+0166)
  0x00, 0xC5, 0x20, 0x19, 0x01, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1D, 0x01, // Å” (U+00C5 U+201D)
  0x00, 0xDD, 0x00, 0xAB, 0x01, // Ý« (U+00DD U+00AB)
  0x00, 0xDD, 0x20, 0x39, 0x01, // Ý‹ (U+00DD U+2039)
  0x00, 0xDE, 0x00, 0x2C, 0x01, // Þ, (U+00DE U+002C)
  0x00, 0xDE, 0x00, 0x2E, 0x01, // Þ. (U+00DE U+002E)
  0x00, 0xDE, 0x20, 0x1A, 0x01, // Þ‚ (U+00DE U+201A)
  0x00, 0xDE, 0x20, 0x1E, 0x01, // Þ„ (U+00DE U+201E)
  0x00, 0xDE, 0x20, 0x26, 0x01, // Þ… (U+00DE U+2026)
  0x01, 0x00, 0x00, 0x22, 0x01, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x01, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x00, 0x54, 0x01, // ĀT (U+0100 U+0054)
  0x01, 0x00, 0x01, 0x62, 0x01, // ĀŢ (U+0100 U+0162)
  0x01, 0x00, 0x01, 0x64, 0x01, // ĀŤ (U+0100 U+0164)
  0x01, 0x00, 0x01, 0x66, 0x01, // ĀŦ (U+0100 U+0166)
  0x01, 0x00, 0x20, 0x19, 0x01, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1D, 0x01, // Ā” (U+0100 U+201D)
  0x01, 0x02, 0x00, 0x22, 0x01, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x01, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x00, 0x54, 0x01, // ĂT (U+0102 U+0054)
  0x01, 0x02, 0x01, 0x62, 0x01, // ĂŢ (U+0102 U+0162)
  0x01, 0x02, 0x01, 0x64, 0x01, // ĂŤ (U+0102 U+0164)
  0x01, 0x02, 0x01, 0x66, 0x01, // ĂŦ (U+0102 U+0166)
  0x01, 0x02, 0x20, 0x19, 0x01, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1D, 0x01, // Ă” (U+0102 U+201D)
  0x01, 0x04, 0x00, 0x22, 0x01, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x01, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x00, 0x54, 0x01, // ĄT (U+0104 U+0054)
  0x01, 0x04, 0x01, 0x62, 0x01, // ĄŢ (U+0104 U+0162)
  0x01, 0x04, 0x01, 0x64, 0x01, // ĄŤ (U+0104 U+0164)
  0x01, 0x04, 0x01, 0x66, 0x01, // ĄŦ (U+0104 U+0166)
  0x01, 0x04, 0x20, 0x19, 0x01, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1D, 0x01, // Ą” (U+0104 U+201D)
  0x01, 0x39, 0x00, 0x22, 0x01, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x01, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x20, 0x19, 0x01, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1D, 0x01, // Ĺ” (U+0139 U+201D)
  0x01, 0x3B, 0x00, 0x22, 0x01, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x01, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x20, 0x19, 0x01, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1D, 0x01, // Ļ” (U+013B U+201D)
  0x01, 0x3D, 0x00, 0x22, 0x01, // Ľ" (U+013D U+0022)
  0x01, 0x3D, 0x00, 0x27, 0x01, // Ľ' (U+013D U+0027)
  0x01, 0x3D, 0x20, 0x19, 0x01, // Ľ’ (U+013D U+2019)
  0x01, 0x3D, 0x20, 0x1D, 0x01, // Ľ” (U+013D U+201D)
  0x01, 0x3F, 0x00, 0x22, 0x01, // Ŀ" (U+013F U+0022)
  0x01, 0x3F, 0x00, 0x27, 0x01, // Ŀ' (U+013F U+0027)
  0x01, 0x3F, 0x20, 0x19, 0x01, // Ŀ’ (U+013F U+2019)
  0x01, 0x3F, 0x20, 0x1D, 0x01, // Ŀ” (U+013F U+201D)
  0x01, 0x41, 0x00, 0x22, 0x01, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x01, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x20, 0x19, 0x01, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1D, 0x01, // Ł” (U+0141 U+201D)
  0x01, 0x55, 0x00, 0x2C, 0x01, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x01, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x20, 0x1A, 0x01, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x01, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x01, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x01, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x01, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x20, 0x1A, 0x01, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x01, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x01, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x01, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x01, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x20, 0x1A, 0x01, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x01, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x01, // ř… (U+0159 U+2026)
  0x01, 0x62, 0x00, 0x41, 0x01, // ŢA (U+0162 U+0041)
  0x01, 0x62, 0x00, 0x61, 0x01, // Ţa (U+0162 U+0061)
  0x01, 0x62, 0x00, 0x63, 0x01, // Ţc (U+0162 U+0063)
  0x01, 0x62, 0x00, 0x64, 0x01, // Ţd (U+0162 U+0064)
  0x01, 0x62, 0x00, 0x65, 0x01, // Ţe (U+0162 U+0065)
  0x01, 0x62, 0x00, 0x67, 0x01, // Ţg (U+0162 U+0067)
  0x01, 0x62, 0x00, 0x6F, 0x01, // Ţo (U+0162 U+006F)
  0x01, 0x62, 0x00, 0x71, 0x01, // Ţq (U+0162 U+0071)
  0x01, 0x62, 0x00, 0xC0, 0x01, // ŢÀ (U+0162 U+00C0)
  0x01, 0x62, 0x00, 0xC1, 0x01, // ŢÁ (U+0162 U+00C1)
  0x01, 0x62, 0x00, 0xC2, 0x01, // ŢÂ (U+0162 U+00C2)
  0x01, 0x62, 0x00, 0xC3, 0x01, // ŢÃ (U+0162 U+00C3)
  0x01, 0x62, 0x00, 0xC4, 0x01, // ŢÄ (U+0162 U+00C4)
  0x01, 0x62, 0x00, 0xC5, 0x01, // ŢÅ (U+0162 U+00C5)
  0x01, 0x62, 0x00, 0xE0, 0x01, // Ţà (U+0162 U+00E0)
  0x01, 0x62, 0x00, 0xE1, 0x01, // Ţá (U+0162 U+00E1)
  0x01, 0x62, 0x00, 0xE2, 0x01, // Ţâ (U+0162 U+00E2)
  0x01, 0x62, 0x00, 0xE3, 0x01, // Ţã (U+0162 U+00E3)
  0x01, 0x62, 0x00, 0xE4, 0x01, // Ţä (U+0162 U+00E4)
  0x01, 0x62, 0x00, 0xE5, 0x01, // Ţå (U+0162 U+00E5)
  0x01, 0x62, 0x00, 0xE6, 0x01, // Ţæ (U+0162 U+00E6)
  0x01, 0x62, 0x00, 0xE7, 0x01, // Ţç (U+0162 U+00E7)
  0x01, 0x62, 0x00, 0xE8, 0x01, // Ţè (U+0162 U+00E8)
  0x01, 0x62, 0x00, 0xE9, 0x01, // Ţé (U+0162 U+00E9)
  0x01, 0x62, 0x00, 0xEA, 0x01, // Ţê (U+0162 U+00EA)
  0x01, 0x62, 0x00, 0xEB, 0x01, // Ţë (U+0162 U+00EB)
  0x01, 0x62, 0x00, 0xF2, 0x01, // Ţò (U+0162 U+00F2)
  0x01, 0x62, 0x00, 0xF3, 0x01, // Ţó (U+0162 U+00F3)
  0x01, 0x62, 0x00, 0xF4, 0x01, // Ţô (U+0162 U+00F4)
  0x01, 0x62, 0x00, 0xF5, 0x01, // Ţõ (U+0162 U+00F5)
  0x01, 0x62, 0x00, 0xF6, 0x01, // Ţö (U+0162 U+00F6)
  0x01, 0x62, 0x00, 0xF8, 0x01, // Ţø (U+0162 U+00F8)
  0x01, 0x62, 0x01, 0x00, 0x01, // ŢĀ (U+0162 U+0100)
  0x01, 0x62, 0x01, 0x01, 0x01, // Ţā (U+0162 U+0101)
  0x01, 0x62, 0x01, 0x02, 0x01, // ŢĂ (U+0162 U+0102)
  0x01, 0x62, 0x01, 0x03, 0x01, // Ţă (U+0162 U+0103)
  0x01, 0x62, 0x01, 0x04, 0x01, // ŢĄ (U+0162 U+0104)
  0x01, 0x62, 0x01, 0x05, 0x01, // Ţą (U+0162 U+0105)
  0x01, 0x62, 0x01, 0x07, 0x01, // Ţć (U+0162 U+0107)
  0x01, 0x62, 0x01, 0x09, 0x01, // Ţĉ (U+0162 U+0109)
  0x01, 0x62, 0x01, 0x0B, 0x01, // Ţċ (U+0162 U+010B)
  0x01, 0x62, 0x01, 0x0D, 0x01, // Ţč (U+0162 U+010D)
  0x01, 0x62, 0x01, 0x0F, 0x01, // Ţď (U+0162 U+010F)
  0x01, 0x62, 0x01, 0x11, 0x01, // Ţđ (U+0162 U+0111)
  0x01, 0x62, 0x01, 0x13, 0x01, // Ţē (U+0162 U+0113)
  0x01, 0x62, 0x01, 0x15, 0x01, // Ţĕ (U+0162 U+0115)
  0x01, 0x62, 0x01, 0x17, 0x01, // Ţė (U+0162 U+0117)
  0x01, 0x62, 0x01, 0x19, 0x01, // Ţę (U+0162 U+0119)
  0x01, 0x62, 0x01, 0x1B, 0x01, // Ţě (U+0162 U+011B)
  0x01, 0x62, 0x01, 0x1D, 0x01, // Ţĝ (U+0162 U+011D)
  0x01, 0x62, 0x01, 0x1F, 0x01, // Ţğ (U+0162 U+011F)
  0x01, 0x62, 0x01, 0x21, 0x01, // Ţġ (U+0162 U+0121)
  0x01, 0x62, 0x01, 0x23, 0x01, // Ţģ (U+0162 U+0123)
  0x01, 0x62, 0x01, 0x4D, 0x01, // Ţō (U+0162 U+014D)
  0x01, 0x62, 0x01, 0x4F, 0x01, // Ţŏ (U+0162 U+014F)
  0x01, 0x62, 0x01, 0x51, 0x01, // Ţő (U+0162 U+0151)
  0x01, 0x62, 0x01, 0x53, 0x01, // Ţœ (U+0162 U+0153)
  0x01, 0x64, 0x00, 0x41, 0x01, // ŤA (U+0164 U+0041)
  0x01, 0x64, 0x00, 0x61, 0x01, // Ťa (U+0164 U+0061)
  0x01, 0x64, 0x00, 0x63, 0x01, // Ťc (U+0164 U+0063)
  0x01, 0x64, 0x00, 0x64, 0x01, // Ťd (U+0164 U+0064)
  0x01, 0x64, 0x00, 0x65, 0x01, // Ťe (U+0164 U+0065)
  0x01, 0x64, 0x00, 0x67, 0x01, // Ťg (U+0164 U+0067)
  0x01, 0x64, 0x00, 0x6F, 0x01, // Ťo (U+0164 U+006F)
  0x01, 0x64, 0x00, 0x71, 0x01, // Ťq (U+0164 U+0071)
  0x01, 0x64, 0x00, 0xC0, 0x01, // ŤÀ (U+0164 U+00C0)
  0x01, 0x64, 0x00, 0xC1, 0x01, // ŤÁ (U+0164 U+00C1)
  0x01, 0x64, 0x00, 0xC2, 0x01, // ŤÂ (U+0164 U+00C2)
  0x01, 0x64, 0x00, 0xC3, 0x01, // ŤÃ (U+0164 U+00C3)
  0x01, 0x64, 0x00, 0xC4, 0x01, // ŤÄ (U+0164 U+00C4)
  0x01, 0x64, 0x00, 0xC5, 0x01, // ŤÅ (U+0164 U+00C5)
  0x01, 0x64, 0x00, 0xE0, 0x01, // Ťà (U+0164 U+00E0)
  0x01, 0x64, 0x00, 0xE1, 0x01, // Ťá (U+0164 U+00E1)
  0x01, 0x64, 0x00, 0xE2, 0x01, // Ťâ (U+0164 U+00E2)
  0x01, 0x64, 0x00, 0xE3, 0x01, // Ťã (U+0164 U+00E3)
  0x01, 0x64, 0x00, 0xE4, 0x01, // Ťä (U+0164 U+00E4)
  0x01, 0x64, 0x00, 0xE5, 0x01, // Ťå (U+0164 U+00E5)
  0x01, 0x64, 0x00, 0xE6, 0x01, // Ťæ (U+0164 U+00E6)
  0x01, 0x64, 0x00, 0xE7, 0x01, // Ťç (U+0164 U+00E7)
  0x01, 0x64, 0x00, 0xE8, 0x01, // Ťè (U+0164 U+00E8)
  0x01, 0x64, 0x00, 0xE9, 0x01, // Ťé (U+0164 U+00E9)
  0x01, 0x64, 0x00, 0xEA, 0x01, // Ťê (U+0164 U+00EA)
  0x01, 0x64, 0x00, 0xEB, 0x01, // Ťë (U+0164 U+00EB)
  0x01, 0x64, 0x00, 0xF2, 0x01, // Ťò (U+0164 U+00F2)
  0x01, 0x64, 0x00, 0xF3, 0x01, // Ťó (U+0164 U+00F3)
  0x01, 0x64, 0x00, 0xF4, 0x01, // Ťô (U+0164 U+00F4)
  0x01, 0x64, 0x00, 0xF5, 0x01, // Ťõ (U+0164 U+00F5)
  0x01, 0x64, 0x00, 0xF6, 0x01, // Ťö (U+0164 U+00F6)
  0x01, 0x64, 0x00, 0xF8, 0x01, // Ťø (U+0164 U+00F8)
  0x01, 0x64, 0x01, 0x00, 0x01, // ŤĀ (U+0164 U+0100)
  0x01, 0x64, 0x01, 0x01, 0x01, // Ťā (U+0164 U+0101)
  0x01, 0x64, 0x01, 0x02, 0x01, // ŤĂ (U+0164 U+0102)
  0x01, 0x64, 0x01, 0x03, 0x01, // Ťă (U+0164 U+0103)
  0x01, 0x64, 0x01, 0x04, 0x01, // ŤĄ (U+0164 U+0104)
  0x01, 0x64, 0x01, 0x05, 0x01, // Ťą (U+0164 U+0105)
  0x01, 0x64, 0x01, 0x07, 0x01, // Ťć (U+0164 U+0107)
  0x01, 0x64, 0x01, 0x09, 0x01, // Ťĉ (U+0164 U+0109)
  0x01, 0x64, 0x01, 0x0B, 0x01, // Ťċ (U+0164 U+010B)
  0x01, 0x64, 0x01, 0x0D, 0x01, // Ťč (U+0164 U+010D)
  0x01, 0x64, 0x01, 0x0F, 0x01, // Ťď (U+0164 U+010F)
  0x01, 0x64, 0x01, 0x11, 0x01, // Ťđ (U+0164 U+0111)
  0x01, 0x64, 0x01, 0x13, 0x01, // Ťē (U+0164 U+0113)
  0x01, 0x64, 0x01, 0x15, 0x01, // Ťĕ (U+0164 U+0115)
  0x01, 0x64, 0x01, 0x17, 0x01, // Ťė (U+0164 U+0117)
  0x01, 0x64, 0x01, 0x19, 0x01, // Ťę (U+0164 U+0119)
  0x01, 0x64, 0x01, 0x1B, 0x01, // Ťě (U+0164 U+011B)
  0x01, 0x64, 0x01, 0x1D, 0x01, // Ťĝ (U+0164 U+011D)
  0x01, 0x64, 0x01, 0x1F, 0x01, // Ťğ (U+0164 U+011F)
  0x01, 0x64, 0x01, 0x21, 0x01, // Ťġ (U+0164 U+0121)
  0x01, 0x64, 0x01, 0x23, 0x01, // Ťģ (U+0164 U+0123)
  0x01, 0x64, 0x01, 0x4D, 0x01, // Ťō (U+0164 U+014D)
  0x01, 0x64, 0x01, 0x4F, 0x01, // Ťŏ (U+0164 U+014F)
  0x01, 0x64, 0x01, 0x51, 0x01, // Ťő (U+0164 U+0151)
  0x01, 0x64, 0x01, 0x53, 0x01, // Ťœ (U+0164 U+0153)
  0x01, 0x66, 0x00, 0x41, 0x01, // ŦA (U+0166 U+0041)
  0x01, 0x66, 0x00, 0x61, 0x01, // Ŧa (U+0166 U+0061)
  0x01, 0x66, 0x00, 0x63, 0x01, // Ŧc (U+0166 U+0063)
  0x01, 0x66, 0x00, 0x64, 0x01, // Ŧd (U+0166 U+0064)
  0x01, 0x66, 0x00, 0x65, 0x01, // Ŧe (U+0166 U+0065)
  0x01, 0x66, 0x00, 0x67, 0x01, // Ŧg (U+0166 U+0067)
  0x01, 0x66, 0x00, 0x6F, 0x01, // Ŧo (U+0166 U+006F)
  0x01, 0x66, 0x00, 0x71, 0x01, // Ŧq (U+0166 U+0071)
  0x01, 0x66, 0x00, 0xC0, 0x01, // ŦÀ (U+0166 U+00C0)
  0x01, 0x66, 0x00, 0xC1, 0x01, // ŦÁ (U+0166 U+00C1)
  0x01, 0x66, 0x00, 0xC2, 0x01, // ŦÂ (U+0166 U+00C2)
  0x01, 0x66, 0x00, 0xC3, 0x01, // ŦÃ (U+0166 U+00C3)
  0x01, 0x66, 0x00, 0xC4, 0x01, // ŦÄ (U+0166 U+00C4)
  0x01, 0x66, 0x00, 0xC5, 0x01, // ŦÅ (U+0166 U+00C5)
  0x01, 0x66, 0x00, 0xE0, 0x01, // Ŧà (U+0166 U+00E0)
  0x01, 0x66, 0x00, 0xE1, 0x01, // Ŧá (U+0166 U+00E1)
  0x01, 0x66, 0x00, 0xE2, 0x01, // Ŧâ (U+0166 U+00E2)
  0x01, 0x66, 0x00, 0xE3, 0x01, // Ŧã (U+0166 U+00E3)
  0x01, 0x66, 0x00, 0xE4, 0x01, // Ŧä (U+0166 U+00E4)
  0x01, 0x66, 0x00, 0xE5, 0x01, // Ŧå (U+0166 U+00E5)
  0x01, 0x66, 0x00, 0xE6, 0x01, // Ŧæ (U+0166 U+00E6)
  0x01, 0x66, 0x00, 0xE7, 0x01, // Ŧç (U+0166 U+00E7)
  0x01, 0x66, 0x00, 0xE8, 0x01, // Ŧè (U+0166 U+00E8)
  0x01, 0x66, 0x00, 0xE9, 0x01, // Ŧé (U+0166 U+00E9)
  0x01, 0x66, 0x00, 0xEA, 0x01, // Ŧê (U+0166 U+00EA)
  0x01, 0x66, 0x00, 0xEB, 0x01, // Ŧë (U+0166 U+00EB)
  0x01, 0x66, 0x00, 0xF2, 0x01, // Ŧò (U+0166 U+00F2)
  0x01, 0x66, 0x00, 0xF3, 0x01, // Ŧó (U+0166 U+00F3)
  0x01, 0x66, 0x00, 0xF4, 0x01, // Ŧô (U+0166 U+00F4)
  0x01, 0x66, 0x00, 0xF5, 0x01, // Ŧõ (U+0166 U+00F5)
  0x01, 0x66, 0x00, 0xF6, 0x01, // Ŧö (U+0166 U+00F6)
  0x01, 0x66, 0x00, 0xF8, 0x01, // Ŧø (U+0166 U+00F8)
  0x01, 0x66, 0x01, 0x00, 0x01, // ŦĀ (U+0166 U+0100)
  0x01, 0x66, 0x01, 0x01, 0x01, // Ŧā (U+0166 U+0101)
  0x01, 0x66, 0x01, 0x02, 0x01, // ŦĂ (U+0166 U+0102)
  0x01, 0x66, 0x01, 0x03, 0x01, // Ŧă (U+0166 U+0103)
  0x01, 0x66, 0x01, 0x04, 0x01, // ŦĄ (U+0166 U+0104)
  0x01, 0x66, 0x01, 0x05, 0x01, // Ŧą (U+0166 U+0105)
  0x01, 0x66, 0x01, 0x07, 0x01, // Ŧć (U+0166 U+0107)
  0x01, 0x66, 0x01, 0x09, 0x01, // Ŧĉ (U+0166 U+0109)
  0x01, 0x66, 0x01, 0x0B, 0x01, // Ŧċ (U+0166 U+010B)
  0x01, 0x66, 0x01, 0x0D, 0x01, // Ŧč (U+0166 U+010D)
  0x01, 0x66, 0x01, 0x0F, 0x01, // Ŧď (U+0166 U+010F)
  0x01, 0x66, 0x01, 0x11, 0x01, // Ŧđ (U+0166 U+0111)
  0x01, 0x66, 0x01, 0x13, 0x01, // Ŧē (U+0166 U+0113)
  0x01, 0x66, 0x01, 0x15, 0x01, // Ŧĕ (U+0166 U+0115)
  0x01, 0x66, 0x01, 0x17, 0x01, // Ŧė (U+0166 U+0117)
  0x01, 0x66, 0x01, 0x19, 0x01, // Ŧę (U+0166 U+0119)
  0x01, 0x66, 0x01, 0x1B, 0x01, // Ŧě (U+0166 U+011B)
  0x01, 0x66, 0x01, 0x1D, 0x01, // Ŧĝ (U+0166 U+011D)
  0x01, 0x66, 0x01, 0x1F, 0x01, // Ŧğ (U+0166 U+011F)
  0x01, 0x66, 0x01, 0x21, 0x01, // Ŧġ (U+0166 U+0121)
  0x01, 0x66, 0x01, 0x23, 0x01, // Ŧģ (U+0166 U+0123)
  0x01, 0x66, 0x01, 0x4D, 0x01, // Ŧō (U+0166 U+014D)
  0x01, 0x66, 0x01, 0x4F, 0x01, // Ŧŏ (U+0166 U+014F)
  0x01, 0x66, 0x01, 0x51, 0x01, // Ŧő (U+0166 U+0151)
  0x01, 0x66, 0x01, 0x53, 0x01, // Ŧœ (U+0166 U+0153)
  0x01, 0x76, 0x00, 0xAB, 0x01, // Ŷ« (U+0176 U+00AB)
  0x01, 0x76, 0x20, 0x39, 0x01, // Ŷ‹ (U+0176 U+2039)
  0x01, 0x78, 0x00, 0xAB, 0x01, // Ÿ« (U+0178 U+00AB)
  0x01, 0x78, 0x20, 0x39, 0x01, // Ÿ‹ (U+0178 U+2039)
  0x20, 0x18, 0x00, 0x41, 0x01, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0xC0, 0x01, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x01, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x01, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x01, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x01, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x01, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xC6, 0x01, // ‘Æ (U+2018 U+00C6)
  0x20, 0x18, 0x01, 0x00, 0x01, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x02, 0x01, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x04, 0x01, // ‘Ą (U+2018 U+0104)
  0x20, 0x19, 0x00, 0x41, 0x01, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0xC0, 0x01, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x01, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x01, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x01, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x01, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x01, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xC6, 0x01, // ’Æ (U+2019 U+00C6)
  0x20, 0x19, 0x01, 0x00, 0x01, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x02, 0x01, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x04, 0x01, // ’Ą (U+2019 U+0104)
  0x20, 0x1A, 0x00, 0x54, 0x01, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x01, 0x62, 0x01, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x01, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x01, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1C, 0x00, 0x41, 0x01, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0xC0, 0x01, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x01, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x01, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x01, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x01, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x01, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xC6, 0x01, // “Æ (U+201C U+00C6)
  0x20, 0x1C, 0x01, 0x00, 0x01, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x02, 0x01, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x04, 0x01, // “Ą (U+201C U+0104)
  0x20, 0x1D, 0x00, 0x41, 0x01, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0xC0, 0x01, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x01, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x01, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x01, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x01, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x01, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xC6, 0x01, // ”Æ (U+201D U+00C6)
  0x20, 0x1D, 0x01, 0x00, 0x01, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x02, 0x01, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x04, 0x01, // ”Ą (U+201D U+0104)
  0x20, 0x1E, 0x00, 0x54, 0x01, // „T (U+201E U+0054)
  0x20, 0x1E, 0x01, 0x62, 0x01, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x01, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x01, // „Ŧ (U+201E U+0166)
  0x20, 0x3A, 0x00, 0x59, 0x01, // ›Y (U+203A U+0059)
  0x20, 0x3A, 0x00, 0xDD, 0x01, // ›Ý (U+203A U+00DD)
  0x20, 0x3A, 0x01, 0x76, 0x01, // ›Ŷ (U+203A U+0176)
  0x20, 0x3A, 0x01, 0x78, 0x01, // ›Ÿ (U+203A U+0178)
  
  // Glyph data
  // "!" (U+0021)
  0x7C, 0x7B, 0x6A, 0x5A, 0x00, 0x6A,
  // """ (U+0022)
  0x68, 0xC3, 0x57, 0xB2, 0x01, 0x10,
  // "#" (U+0023)
  0x04, 0x99, 0x37, 0xEF, 0xFE, 0x1A, 0x5C, 0x1C, 0xFE, 0xFA, 0x1D, 0x68, 0x11, 0xB7, 0x50,
  // "$" (U+0024)
  0x03, 0xA3, 0x07, 0xED, 0xD0, 0x8C, 0x80, 0x00, 0x8F, 0x90, 0x20, 0x9F, 0x38, 0xFF, 0xC0, 0x01,
  0x80, 0x00,
  // "%" (U+0025)
  0x6E, 0x80, 0x85, 0x0B, 0x7E, 0x1C, 0x00, 0x7F, 0xA9, 0x9D, 0x70, 0x12, 0xCA, 0x8D, 0x00, 0xA4,
  0xA7, 0xD0, 0x3B, 0x05, 0xE7,
  // "&" (U+0026)
  0x0A, 0xE9, 0x00, 0x2F, 0x3F, 0x00, 0x0D, 0xD9, 0x00, 0x4D, 0xC6, 0xA8, 0x9B, 0x2E, 0xE1, 0x3D,
  0xFB, 0xD8,
  // "'" (U+0027)
  0x68, 0x57, 0x01,
  // "(" (U+0028)
  0x0C, 0x25, 0xB0, 0x97, 0x0A, 0x50, 0x97, 0x05, 0xB0, 0x0C, 0x20,
  // ")" (U+0029)
  0x78, 0x00, 0xE1, 0x0B, 0x40, 0xA5, 0x0B, 0x40, 0xE1, 0x68, 0x00,
  // "*" (U+002A)
  0x04, 0x90, 0x79, 0xBA, 0x3B, 0xE5, 0x1D, 0x86,
  // "+" (U+002B)
  0x02, 0xB0, 0x09, 0xEF, 0xE3, 0x13, 0xB1, 0x00, 0x2B, 0x00,
  // "," (U+002C)
  0x01, 0x79, 0xA4,
  // "-" (U+002D)
  0xBE, 0x51, 0x10,
  // "." (U+002E)
  0x6A,
  // "/" (U+002F)
  0x00, 0xE1, 0x05, 0xB0, 0x0A, 0x50, 0x1E, 0x00, 0x6A, 0x00, 0xB4, 0x00,
  // "0" (U+0030)
  0x1C, 0xE7, 0x08, 0xB3, 0xF1, 0xA7, 0x0E, 0x3A, 0x70, 0xE3, 0x7B, 0x3F, 0x11, 0xBE, 0x70,
  // "1" (U+0031)
  0x04, 0xE4, 0x4D, 0xE4, 0x01, 0xD4, 0x00, 0xE4, 0x00, 0xE4, 0x00, 0xE4,
  // "2" (U+0032)
  0x4D, 0xE8, 0x03, 0x53, 0xF1, 0x00, 0x5E, 0x00, 0x2E, 0x40, 0x2D, 0x51, 0x0A, 0xFF, 0xF4,
  // "3" (U+0033)
  0x5D, 0xEA, 0x01, 0x24, 0xF0, 0x0B, 0xF6, 0x00, 0x15, 0xF2, 0x31, 0x4F, 0x28, 0xEE, 0x80,
  // "4" (U+0034)
  0x00, 0xAB, 0x00, 0x3F, 0xB0, 0x0C, 0xAB, 0x07, 0x86, 0xB0, 0xDE, 0xEF, 0x61, 0x17, 0xC0,
  // "5" (U+0035)
  0x5F, 0xFC, 0x06, 0xB1, 0x00, 0x7E, 0xD7, 0x01, 0x25, 0xF1, 0x21, 0x4F, 0x17, 0xEE, 0x70,
  // "6" (U+0036)
  0x07, 0xDD, 0x05, 0xD2, 0x10, 0x9B, 0xDA, 0x0A, 0xA3, 0xF3, 0x8B, 0x2F, 0x31, 0xCE, 0x90,
  // "7" (U+0037)
  0xCF, 0xFF, 0x40, 0x13, 0xE1, 0x00, 0x99, 0x00, 0x1E, 0x30, 0x07, 0xC0, 0x00, 0xD5, 0x00,
  // "8" (U+0038)
  0x2C, 0xE9, 0x07, 0xB3, 0xF0, 0x2D, 0xB8, 0x05, 0xC9, 0xC0, 0xA9, 0x2E, 0x34, 0xDE, 0xA0,
  // "9" (U+0039)
  0x2C, 0xE7, 0x09, 0x93, 0xF1, 0xA8, 0x1F, 0x45, 0xFD, 0xE2, 0x02, 0x6D, 0x05, 0xFC, 0x30,
  // ":" (U+003A)
  0x6A, 0x00, 0x00, 0x00, 0x6A,
  // ";" (U+003B)
  0x6A, 0x00, 0x00, 0x01, 0x79, 0xA4,
  // "<" (U+003C)
  0x00, 0x29, 0x32, 0x9B, 0x40, 0x6D, 0x61, 0x00, 0x07, 0xC2,
  // "=" (U+003D)
  0x9E, 0xEE, 0x31, 0x11, 0x10, 0x9E, 0xEE, 0x31, 0x11, 0x10,
  // ">" (U+003E)
  0x86, 0x00, 0x01, 0x7C, 0x60, 0x03, 0xAC, 0x18, 0xA4, 0x00,
  // "?" (U+003F)
  0x9E, 0xD3, 0x32, 0xA8, 0x02, 0xD4, 0x0C, 0x50, 0x03, 0x00, 0x0D, 0x20,
  // "@" (U+0040)
  0x01, 0xAE, 0xE7, 0x00, 0xDC, 0xFF, 0xD6, 0x58, 0xD2, 0xC4, 0xB8, 0x5D, 0x0E, 0x4B, 0x85, 0xBF,
  0xAF, 0x43, 0xD2, 0x01, 0x20, 0x07, 0xEF, 0xE4, 0x00, 0x00, 0x10, 0x00,
  // "A" (U+0041)
  0x02, 0xFA, 0x00, 0x07, 0x9E, 0x00, 0x0C, 0x3A, 0x50, 0x2F, 0xFF, 0xA0, 0x7A, 0x23, 0xE0, 0xC6,
  0x00, 0xD5,
  // "B" (U+0042)
  0x4F, 0xFD, 0x54, 0xE1, 0x9B, 0x4F, 0xEF, 0x54, 0xE2, 0x8C, 0x4E, 0x18, 0xD4, 0xFF, 0xD5,
  // "C" (U+0043)
  0x06, 0xDE, 0x83, 0xF4, 0x23, 0x7C, 0x00, 0x07, 0xB0, 0x00, 0x4F, 0x41, 0x20, 0x7E, 0xE7,
  // "D" (U+0044)
  0x4F, 0xFD, 0x50, 0x4E, 0x15, 0xF2, 0x4E, 0x00, 0xD6, 0x4E, 0x00, 0xD5, 0x4E, 0x16, 0xE1, 0x4F,
  0xFC, 0x40,
  // "E" (U+0045)
  0x4F, 0xFF, 0x4E, 0x11, 0x4F, 0xEC, 0x4E, 0x11, 0x4E, 0x11, 0x4F, 0xFF,
  // "F" (U+0046)
  0x4F, 0xFF, 0x4E, 0x10, 0x4F, 0xEC, 0x4E, 0x11, 0x4E, 0x00, 0x4E, 0x00,
  // "G" (U+0047)
  0x05, 0xDF, 0xC0, 0x3F, 0x61, 0x20, 0x7C, 0x1E, 0xE2, 0x7C, 0x02, 0xF2, 0x3F, 0x52, 0xF2, 0x07,
  0xDF, 0xD1,
  // "H" (U+0048)
  0x4E, 0x00, 0xC6, 0x4E, 0x00, 0xC6, 0x4F, 0xEE, 0xF6, 0x4E, 0x11, 0xD6, 0x4E, 0x00, 0xC6, 0x4E,
  0x00, 0xC6,
  // "I" (U+0049)
  0xBF, 0xC1, 0xF2, 0x0F, 0x20, 0xF2, 0x0F, 0x2A, 0xFB,
  // "J" (U+004A)
  0x04, 0xE0, 0x4E, 0x04, 0xE0, 0x4E, 0x04, 0xE0, 0x4E, 0x06, 0xD8, 0xF6,
  // "K" (U+004B)
  0x4E, 0x06, 0xD0, 0x4E, 0x3E, 0x30, 0x4E, 0xD7, 0x00, 0x4F, 0xCC, 0x00, 0x4E, 0x0E, 0x60, 0x4E,
  0x05, 0xE1,
  // "L" (U+004C)
  0x4E, 0x00, 0x04, 0xE0, 0x00, 0x4E, 0x00, 0x04, 0xE0, 0x00, 0x4E, 0x11, 0x04, 0xFF, 0xF3,
  // "M" (U+004D)
  0x4F, 0x80, 0x0E, 0xC4, 0xEC, 0x04, 0xEC, 0x4C, 0xE1, 0x9A, 0xC4, 0xC9, 0x6D, 0x5C, 0x4C, 0x5D,
  0xB4, 0xC4, 0xC0, 0xF6, 0x4C,
  // "N" (U+004E)
  0x4F, 0x80, 0x4C, 0x4E, 0xE1, 0x4C, 0x4B, 0xA9, 0x4C, 0x4C, 0x2F, 0x7C, 0x4C, 0x09, 0xEC, 0x4C,
  0x01, 0xEC,
  // "O" (U+004F)
  0x07, 0xEE, 0xA1, 0x3F, 0x42, 0xC9, 0x7C, 0x00, 0x6D, 0x7C, 0x00, 0x6D, 0x3F, 0x42, 0xC9, 0x07,
  0xEE, 0xA1,
  // "P" (U+0050)
  0x4F, 0xFC, 0x24, 0xE1, 0xC8, 0x4E, 0x0B, 0x84, 0xFF, 0xD2, 0x4E, 0x10, 0x04, 0xE0, 0x00,
  // "Q" (U+0051)
  0x07, 0xEE, 0xA1, 0x3F, 0x42, 0xC9, 0x7C, 0x00, 0x6D, 0x7C, 0x00, 0x6D, 0x3F, 0x42, 0xC9, 0x07,
  0xEF, 0xC1, 0x00, 0x05, 0xE2, 0x00, 0x00, 0x65,
  // "R" (U+0052)
  0x4F, 0xFD, 0x30, 0x4E, 0x1B, 0x90, 0x4F, 0xED, 0x30, 0x4E, 0x4E, 0x00, 0x4E, 0x0C, 0x70, 0x4E,
  0x04, 0xE1,
  // "S" (U+0053)
  0x2C, 0xEB, 0x7B, 0x13, 0x4E, 0x80, 0x03, 0xCC, 0x32, 0x4F, 0x7E, 0xE7,
  // "T" (U+0054)
  0xDF, 0xFF, 0x70, 0x5E, 0x10, 0x04, 0xE0, 0x00, 0x4E, 0x00, 0x04, 0xE0, 0x00, 0x4E, 0x00,
  // "U" (U+0055)
  0x4D, 0x00, 0xD5, 0x4D, 0x00, 0xD5, 0x4D, 0x00, 0xD5, 0x4D, 0x00, 0xD5, 0x2F, 0x43, 0xF3, 0x07,
  0xEE, 0x80,
  // "V" (U+0056)
  0xD5, 0x02, 0xF8, 0xA0, 0x7B, 0x3E, 0x0C, 0x60, 0xD5, 0xF1, 0x08, 0xCB, 0x00, 0x3F, 0x60,
  // "W" (U+0057)
  0xD4, 0x0C, 0x80, 0x89, 0x98, 0x1E, 0xC0, 0xC5, 0x6B, 0x4A, 0xE1, 0xF1, 0x2E, 0x86, 0xB8, 0xD0,
  0x0E, 0xD3, 0x7D, 0x90, 0x0A, 0xE0, 0x3F, 0x60,
  // "X" (U+0058)
  0x9B, 0x05, 0xD0, 0x1E, 0x4D, 0x40, 0x05, 0xFB, 0x00, 0x07, 0xFB, 0x00, 0x1E, 0x3D, 0x50, 0xA9,
  0x05, 0xE1,
  // "Y" (U+0059)
  0xB8, 0x08, 0xB3, 0xF3, 0xF3, 0x0B, 0xEA, 0x00, 0x3F, 0x30, 0x01, 0xF1, 0x00, 0x1F, 0x10,
  // "Z" (U+005A)
  0xBF, 0xFF, 0x50, 0x16, 0xD0, 0x01, 0xE4, 0x00, 0xA9, 0x00, 0x5D, 0x11, 0x0C, 0xFF, 0xF6,
  // "[" (U+005B)
  0x6F, 0x76, 0x90, 0x69, 0x06, 0x90, 0x69, 0x06, 0x90, 0x69, 0x06, 0xF6, 0x01, 0x00,
  // "\" (U+005C)
  0xC4, 0x00, 0x6A, 0x00, 0x1E, 0x00, 0x0B, 0x50, 0x05, 0xB0, 0x00, 0xE1,
  // "]" (U+005D)
  0xCF, 0x10, 0xE1, 0x0E, 0x10, 0xE1, 0x0E, 0x10, 0xE1, 0x0E, 0x1B, 0xF1, 0x11, 0x00,
  // "^" (U+005E)
  0x05, 0xA0, 0x00, 0xBC, 0x20, 0x2B, 0x3A, 0x09, 0x40, 0xB2,
  // "_" (U+005F)
  0x99, 0x92,
  // "`" (U+0060)
  0x46, 0x00, 0xB4,
  // "a" (U+0061)
  0x1C, 0xEA, 0x00, 0x42, 0xF3, 0x3C, 0xEF, 0x39, 0xC4, 0xF3, 0x5E, 0xBC, 0x30,
  // "b" (U+0062)
  0x5C, 0x00, 0x05, 0xC0, 0x00, 0x5D, 0xCD, 0x25, 0xE2, 0xB8, 0x5C, 0x08, 0xA5, 0xE2, 0xB8, 0x5A,
  0xCD, 0x20,
  // "c" (U+0063)
  0x1B, 0xF9, 0x7C, 0x12, 0x99, 0x00, 0x7C, 0x13, 0x1B, 0xF9,
  // "d" (U+0064)
  0x00, 0x0B, 0x60, 0x00, 0xB6, 0x1C, 0xDC, 0x67, 0xC2, 0xD6, 0x99, 0x0A, 0x67, 0xC1, 0xD6, 0x1D,
  0xDB, 0x60,
  // "e" (U+0065)
  0x1B, 0xE9, 0x07, 0xC2, 0xE3, 0x9F, 0xEF, 0x57, 0xC3, 0x41, 0x1B, 0xFD, 0x10,
  // "f" (U+0066)
  0x0B, 0xE4, 0x2F, 0x20, 0xBF, 0xF0, 0x3F, 0x10, 0x2F, 0x00, 0x2F, 0x00, 0x2F, 0x00,
  // "g" (U+0067)
  0x1C, 0xDB, 0x67, 0xC2, 0xD6, 0x99, 0x0A, 0x67, 0xC1, 0xD6, 0x1D, 0xDD, 0x61, 0x22, 0xE5, 0x4E,
  0xEA, 0x00,
  // "h" (U+0068)
  0x5C, 0x00, 0x05, 0xC0, 0x00, 0x5D, 0xCE, 0x35, 0xF2, 0xA9, 0x5C, 0x08, 0xA5, 0xC0, 0x8A, 0x5C,
  0x08, 0xA0,
  // "i" (U+0069)
  0x4B, 0x00, 0x5C, 0x5C, 0x5C, 0x5C, 0x5C,
  // "j" (U+006A)
  0x04, 0xB0, 0x00, 0x05, 0xC0, 0x5C, 0x05, 0xC0, 0x5C, 0x05, 0xC0, 0x7C, 0x7E, 0x50,
  // "k" (U+006B)
  0x5C, 0x00, 0x05, 0xC0, 0x00, 0x5C, 0x0D, 0x75, 0xCA, 0xA0, 0x5F, 0xF5, 0x05, 0xD6, 0xE1, 0x5C,
  0x0B, 0x90,
  // "l" (U+006C)
  0x5C, 0x5C, 0x5C, 0x5C, 0x5C, 0x5C, 0x5C,
  // "m" (U+006D)
  0x5A, 0xCD, 0x5E, 0xB0, 0x5E, 0x2C, 0xB2, 0xF3, 0x5C, 0x0A, 0x80, 0xE3, 0x5C, 0x0A, 0x80, 0xE3,
  0x5C, 0x0A, 0x80, 0xE3,
  // "n" (U+006E)
  0x5B, 0xCE, 0x35, 0xF2, 0xA9, 0x5C, 0x08, 0xA5, 0xC0, 0x8A, 0x5C, 0x08, 0xA0,
  // "o" (U+006F)
  0x0B, 0xEA, 0x07, 0xC1, 0xD6, 0x99, 0x0A, 0x87, 0xC1, 0xD6, 0x0B, 0xEA, 0x00,
  // "p" (U+0070)
  0x5C, 0xCD, 0x25, 0xE2, 0xB8, 0x5C, 0x08, 0xA5, 0xE2, 0xB8, 0x5D, 0xDD, 0x25, 0xC0, 0x00, 0x5C,
  0x00, 0x00,
  // "q" (U+0071)
  0x1C, 0xDC, 0x67, 0xC2, 0xD6, 0x99, 0x0A, 0x67, 0xC1, 0xD6, 0x1D, 0xDD, 0x60, 0x00, 0xB6, 0x00,
  0x0B, 0x60,
  // "r" (U+0072)
  0x5B, 0xC6, 0x5F, 0x30, 0x5C, 0x00, 0x5C, 0x00, 0x5C, 0x00,
  // "s" (U+0073)
  0x4E, 0xE6, 0x9B, 0x21, 0x2B, 0xD3, 0x31, 0xA9, 0x7F, 0xD4,
  // "t" (U+0074)
  0x0D, 0x00, 0xAF, 0xF2, 0x4E, 0x00, 0x3E, 0x00, 0x3F, 0x10, 0x0C, 0xE2,
  // "u" (U+0075)
  0x6C, 0x08, 0x96, 0xC0, 0x89, 0x6C, 0x08, 0x95, 0xD0, 0xB9, 0x1C, 0xEA, 0x90,
  // "v" (U+0076)
  0xD6, 0x0D, 0x57, 0xA2, 0xF1, 0x2E, 0x7B, 0x00, 0xDD, 0x50, 0x07, 0xF1, 0x00,
  // "w" (U+0077)
  0xC5, 0x5F, 0x38, 0x98, 0x98, 0xC6, 0xB6, 0x4C, 0xC5, 0x9E, 0x21, 0xEC, 0x1D, 0xD0, 0x0C, 0xA0,
  0xD9, 0x00,
  // "x" (U+0078)
  0x9B, 0x1F, 0x31, 0xEC, 0xA0, 0x09, 0xF3, 0x01, 0xEB, 0xA0, 0xAA, 0x1E, 0x40,
  // "y" (U+0079)
  0xC6, 0x0D, 0x57, 0xB2, 0xF1, 0x1F, 0x8A, 0x00, 0xBE, 0x50, 0x06, 0xF0, 0x01, 0x9A, 0x00, 0xBD,
  0x20, 0x00,
  // "z" (U+007A)
  0xAF, 0xF9, 0x02, 0xE3, 0x0A, 0x80, 0x5D, 0x10, 0xBF, 0xFA,
  // "{" (U+007B)
  0x09, 0xC0, 0xD4, 0x0E, 0x2D, 0xA0, 0x3E, 0x10, 0xD2, 0x0D, 0x30, 0x9C, 0x00, 0x10,
  // "|" (U+007C)
  0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39,
  // "}" (U+007D)
  0xAB, 0x02, 0xF0, 0x0F, 0x20, 0x8F, 0x0E, 0x50, 0xF0, 0x0F, 0x0A, 0xC0, 0x10, 0x00,
  // "~" (U+007E)
  0x9E, 0xEE, 0x31, 0x11, 0x10,
  // "¡" (U+00A1)
  0x6A, 0x00, 0x59, 0x6A, 0x7B, 0x8C,
  // "¢" (U+00A2)
  0x00, 0xB2, 0x1E, 0xED, 0x6D, 0x00, 0x5D, 0x00, 0x0C, 0xFD, 0x00, 0xB0,
  // "£" (U+00A3)
  0x08, 0xED, 0x10, 0xE5, 0x20, 0x9F, 0xE9, 0x01, 0xF4, 0x10, 0x3E, 0x11, 0x0A, 0xFF, 0xF6,
  // "¤" (U+00A4)
  0x00, 0x01, 0x5D, 0xED, 0x2B, 0x3B, 0x2A, 0x1B, 0x4F, 0xFD, 0x11, 0x12,
  // "¥" (U+00A5)
  0xB7, 0x0D, 0x43, 0xD5, 0xC0, 0x0B, 0xE4, 0x03, 0xFF, 0xB0, 0x3F, 0xFC, 0x00, 0x5D, 0x10,
  // "¦" (U+00A6)
  0x39, 0x39, 0x39, 0x39, 0x00, 0x39, 0x39, 0x39, 0x39,
  // "§" (U+00A7)
  0x3D, 0xE4, 0x79, 0x21, 0x3E, 0xB1, 0x77, 0x76, 0x1A, 0xE3, 0x31, 0x96, 0x6E, 0xD2,
  // "¨" (U+00A8)
  0xB4, 0x90,
  // "©" (U+00A9)
  0x01, 0x88, 0x60, 0x00, 0x96, 0x96, 0x80, 0x62, 0xA0, 0x07, 0x18, 0x28, 0x00, 0x53, 0x62, 0x90,
  0x07, 0x11, 0x96, 0x96, 0x90, 0x01, 0x88, 0x70, 0x00,
  // "ª" (U+00AA)
  0x5A, 0x76, 0x8B, 0x68, 0x70,
  // "«" (U+00AB)
  0x09, 0x5A, 0x46, 0xC7, 0xB0, 0x3E, 0x5D, 0x20, 0x43, 0x42,
  // "¬" (U+00AC)
  0x9E, 0xEE, 0x31, 0x11, 0xA3, 0x00, 0x05, 0x20,
  // "®" (U+00AE)
  0x01, 0x88, 0x60, 0x00, 0x9A, 0xA5, 0x80, 0x61, 0xA3, 0x77, 0x18, 0x0B, 0xC1, 0x53, 0x61, 0xA5,
  0x57, 0x11, 0x94, 0x07, 0x90, 0x01, 0x88, 0x70, 0x00,
  // "¯" (U+00AF)
  0xEE, 0xEE, 0x11, 0x11,
  // "°" (U+00B0)
  0x3D, 0x99, 0x5D, 0x5F, 0xB0,
  // "±" (U+00B1)
  0x02, 0xB0, 0x09, 0xEF, 0xE3, 0x13, 0xB1, 0x00, 0x3B, 0x10, 0xAF, 0xFF, 0x30,
  // "²" (U+00B2)
  0x7C, 0x51, 0x68, 0x2C, 0x1A, 0xD9,
  // "³" (U+00B3)
  0x6C, 0x41, 0x48, 0x2D, 0x48, 0xC7,
  // "´" (U+00B4)
  0x07, 0x36, 0xA0,
  // "µ" (U+00B5)
  0x5C, 0x08, 0xA5, 0xC0, 0x8A, 0x5C, 0x08, 0xA5, 0xE2, 0xCA, 0x5E, 0xEB, 0xA5, 0xC0, 0x00, 0x5C,
  0x00, 0x00,
  // "¶" (U+00B6)
  0x1C, 0xFF, 0x87, 0xFF, 0x68, 0x8F, 0xF5, 0x86, 0xFF, 0x58, 0x06, 0xB5, 0x80, 0x05, 0x58, 0x00,
  0x55, 0x80, 0x05, 0x58,
  // "·" (U+00B7)
  0x6A,
  // "¸" (U+00B8)
  0x01, 0x00, 0x96, 0x1B, 0x50,
  // "¹" (U+00B9)
  0x3D, 0x41, 0x94, 0x09, 0x40,
  // "º" (U+00BA)
  0x6B, 0x7B, 0x1C, 0x4B, 0x50,
  // "»" (U+00BB)
  0x59, 0x68, 0x00, 0xC6, 0xD5, 0x3E, 0x5D, 0x23, 0x43, 0x30,
  // "¼" (U+00BC)
  0x5E, 0x10, 0xC1, 0x01, 0xC1, 0x58, 0x00, 0x0C, 0x1C, 0x4F, 0x10, 0xC8, 0x8B, 0xE1, 0x00, 0xC5,
  0xCE, 0x60, 0x77, 0x00, 0xD1,
  // "½" (U+00BD)
  0x5E, 0x10, 0xC1, 0x01, 0xC1, 0x59, 0x00, 0x0C, 0x1C, 0x9D, 0x50, 0xC7, 0x85, 0x87, 0x00, 0xC1,
  0x2B, 0x00, 0x67, 0x0C, 0xEA, 0x01, 0x00, 0x11, 0x10,
  // "¾" (U+00BE)
  0x5C, 0x50, 0x65, 0x01, 0x3A, 0x0D, 0x00, 0x1D, 0x56, 0x80, 0x02, 0x1C, 0xC3, 0xE3, 0x6C, 0xB9,
  0xAD, 0x30, 0x0B, 0x5C, 0xE8, 0x03, 0xA0, 0x0B, 0x30,
  // "¿" (U+00BF)
  0x02, 0xD0, 0x00, 0x30, 0x05, 0xC0, 0x4D, 0x20, 0x9A, 0x13, 0x3D, 0xE9,
  // "À" (U+00C0)
  0x04, 0x60, 0x00, 0x00, 0xB4, 0x00, 0x02, 0xFA, 0x00, 0x07, 0x9E, 0x00, 0x0C, 0x3A, 0x50, 0x2F,
  0xFF, 0xA0, 0x7A, 0x23, 0xE0, 0xC6, 0x00, 0xD5,
  // "Á" (U+00C1)
  0x00, 0x07, 0x30, 0x00, 0x6A, 0x00, 0x02, 0xFA, 0x00, 0x07, 0x9E, 0x00, 0x0C, 0x3A, 0x50, 0x2F,
  0xFF, 0xA0, 0x7A, 0x23, 0xE0, 0xC6, 0x00, 0xD5,
  // "Â" (U+00C2)
  0x00, 0x66, 0x00, 0x05, 0xAA, 0x60, 0x02, 0xFA, 0x00, 0x07, 0x9E, 0x00, 0x0C, 0x3A, 0x50, 0x2F,
  0xFF, 0xA0, 0x7A, 0x23, 0xE0, 0xC6, 0x00, 0xD5,
  // "Ã" (U+00C3)
  0x06, 0xEE, 0x50, 0x03, 0xFB, 0x00, 0x07, 0x9E, 0x00, 0x0C, 0x3A, 0x50, 0x2F, 0xFF, 0xA0, 0x7A,
  0x23, 0xE0, 0xC6, 0x00, 0xD5,
  // "Ä" (U+00C4)
  0x0B, 0x49, 0x00, 0x00, 0x00, 0x00, 0x02, 0xFA, 0x00, 0x07, 0x9E, 0x00, 0x0C, 0x3A, 0x50, 0x2F,
  0xFF, 0xA0, 0x7A, 0x23, 0xE0, 0xC6, 0x00, 0xD5,
  // "Å" (U+00C5)
  0x05, 0x91, 0x00, 0x08, 0xFB, 0x00, 0x07, 0x9E, 0x00, 0x0C, 0x3A, 0x50, 0x2F, 0xFF, 0xA0, 0x7A,
  0x23, 0xE0, 0xC6, 0x00, 0xD5,
  // "Æ" (U+00C6)
  0x00, 0xAF, 0xFF, 0xF2, 0x01, 0xE5, 0xE1, 0x10, 0x07, 0x84, 0xFE, 0xE0, 0x0E, 0xEE, 0xE1, 0x10,
  0x5B, 0x15, 0xE1, 0x10, 0xC6, 0x04, 0xFF, 0xF2,
  // "Ç" (U+00C7)
  0x06, 0xDE, 0x83, 0xF4, 0x23, 0x7C, 0x00, 0x07, 0xB0, 0x00, 0x4F, 0x41, 0x20, 0x7F, 0xF7, 0x00,
  0x96, 0x00, 0x1B, 0x50,
  // "È" (U+00C8)
  0x04, 0x60, 0x00, 0xB4, 0x4F, 0xFF, 0x4E, 0x11, 0x4F, 0xEC, 0x4E, 0x11, 0x4E, 0x11, 0x4F, 0xFF,
  // "É" (U+00C9)
  0x00, 0x73, 0x06, 0xA0, 0x4F, 0xFF, 0x4E, 0x11, 0x4F, 0xEC, 0x4E, 0x11, 0x4E, 0x11, 0x4F, 0xFF,
  // "Ê" (U+00CA)
  0x06, 0x60, 0x5A, 0xA6, 0x4F, 0xFF, 0x4E, 0x11, 0x4F, 0xEC, 0x4E, 0x11, 0x4E, 0x11, 0x4F, 0xFF,
  // "Ë" (U+00CB)
  0x0B, 0x49, 0x00, 0x00, 0x4F, 0xFF, 0x4E, 0x11, 0x4F, 0xEC, 0x4E, 0x11, 0x4E, 0x11, 0x4F, 0xFF,
  // "Ì" (U+00CC)
  0x46, 0x00, 0xB4, 0xBF, 0xC1, 0xF2, 0x0F, 0x20, 0xF2, 0x0F, 0x2A, 0xFB,
  // "Í" (U+00CD)
  0x00, 0x73, 0x06, 0xA0, 0xBF, 0xC0, 0x1F, 0x20, 0x0F, 0x20, 0x0F, 0x20, 0x0F, 0x20, 0xAF, 0xB0,
  // "Î" (U+00CE)
  0x06, 0x60, 0x5A, 0xA6, 0xBF, 0xC0, 0x1F, 0x20, 0x0F, 0x20, 0x0F, 0x20, 0x0F, 0x20, 0xAF, 0xB0,
  // "Ï" (U+00CF)
  0xB4, 0x90, 0x00, 0xBF, 0xC1, 0xF2, 0x0F, 0x20, 0xF2, 0x0F, 0x2A, 0xFB,
  // "Ð" (U+00D0)
  0x4F, 0xFD, 0x50, 0x4E, 0x15, 0xF2, 0xCF, 0xC0, 0xD6, 0x5E, 0x10, 0xD5, 0x4E, 0x16, 0xE1, 0x4F,
  0xFC, 0x40,
  // "Ñ" (U+00D1)
  0x06, 0xEE, 0x50, 0x4F, 0xA1, 0x4C, 0x4E, 0xE1, 0x4C, 0x4B, 0xA9, 0x4C, 0x4C, 0x2F, 0x7C, 0x4C,
  0x09, 0xEC, 0x4C, 0x01, 0xEC,
  // "Ò" (U+00D2)
  0x04, 0x60, 0x00, 0x00, 0xB4, 0x00, 0x07, 0xEE, 0xA1, 0x3F, 0x42, 0xC9, 0x7C, 0x00, 0x6D, 0x7C,
  0x00, 0x6D, 0x3F, 0x42, 0xC9, 0x07, 0xEE, 0xA1,
  // "Ó" (U+00D3)
  0x00, 0x07, 0x30, 0x00, 0x6A, 0x00, 0x07, 0xEE, 0xA1, 0x3F, 0x42, 0xC9, 0x7C, 0x00, 0x6D, 0x7C,
  0x00, 0x6D, 0x3F, 0x42, 0xC9, 0x07, 0xEE, 0xA1,
  // "Ô" (U+00D4)
  0x00, 0x66, 0x00, 0x05, 0xAA, 0x60, 0x07, 0xEE, 0xA1, 0x3F, 0x42, 0xC9, 0x7C, 0x00, 0x6D, 0x7C,
  0x00, 0x6D, 0x3F, 0x42, 0xC9, 0x07, 0xEE, 0xA1,
  // "Õ" (U+00D5)
  0x06, 0xEE, 0x50, 0x08, 0xFF, 0xA1, 0x3F, 0x42, 0xC9, 0x7C, 0x00, 0x6D, 0x7C, 0x00, 0x6D, 0x3F,
  0x42, 0xC9, 0x07, 0xEE, 0xA1,
  // "Ö" (U+00D6)
  0x00, 0xB4, 0x90, 0x00, 0x00, 0x00, 0x07, 0xEE, 0xA1, 0x3F, 0x42, 0xC9, 0x7C, 0x00, 0x6D, 0x7C,
  0x00, 0x6D, 0x3F, 0x42, 0xC9, 0x07, 0xEE, 0xA1,
  // "×" (U+00D7)
  0x13, 0x05, 0x1C, 0xB8, 0x0A, 0xE3, 0x38, 0x2A,
  // "Ø" (U+00D8)
  0x07, 0xEE, 0xD4, 0x3F, 0x46, 0xF8, 0x7C, 0x0C, 0x8C, 0x7C, 0x85, 0x6D, 0x3F, 0xB2, 0xC9, 0x0D,
  0xDE, 0xA1, 0x01, 0x00, 0x00,
  // "Ù" (U+00D9)
  0x04, 0x60, 0x00, 0x00, 0xB4, 0x00, 0x4D, 0x00, 0xD5, 0x4D, 0x00, 0xD5, 0x4D, 0x00, 0xD5, 0x4D,
  0x00, 0xD5, 0x2F, 0x43, 0xF3, 0x07, 0xEE, 0x80,
  // "Ú" (U+00DA)
  0x00, 0x07, 0x30, 0x00, 0x6A, 0x00, 0x4D, 0x00, 0xD5, 0x4D, 0x00, 0xD5, 0x4D, 0x00, 0xD5, 0x4D,
  0x00, 0xD5, 0x2F, 0x43, 0xF3, 0x07, 0xEE, 0x80,
  // "Û" (U+00DB)
  0x00, 0x66, 0x00, 0x05, 0xAA, 0x60, 0x4D, 0x00, 0xD5, 0x4D, 0x00, 0xD5, 0x4D, 0x00, 0xD5, 0x4D,
  0x00, 0xD5, 0x2F, 0x43, 0xF3, 0x07, 0xEE, 0x80,
  // "Ü" (U+00DC)
  0x00, 0xB4, 0x90, 0x00, 0x00, 0x00, 0x4D, 0x00, 0xD5, 0x4D, 0x00, 0xD5, 0x4D, 0x00, 0xD5, 0x4D,
  0x00, 0xD5, 0x2F, 0x43, 0xF3, 0x07, 0xEE, 0x80,
  // "Ý" (U+00DD)
  0x00, 0x73, 0x00, 0x6A, 0x00, 0xB8, 0x08, 0xB3, 0xF3, 0xF3, 0x0B, 0xEA, 0x00, 0x3F, 0x30, 0x01,
  0xF1, 0x00, 0x1F, 0x10,
  // "Þ" (U+00DE)
  0x4E, 0x00, 0x04, 0xFE, 0xB1, 0x4E, 0x2B, 0x84, 0xE0, 0xA8, 0x4F, 0xEE, 0x24, 0xE1, 0x00,
  // "ß" (U+00DF)
  0x09, 0xED, 0x50, 0x4E, 0x28, 0xC0, 0x5C, 0x1C, 0x60, 0x5C, 0x5E, 0x10, 0x5C, 0x09, 0xE1, 0x5C,
  0x21, 0xE5, 0x5C, 0x7F, 0xC1,
  // "à" (U+00E0)
  0x04, 0x60, 0x00, 0x0B, 0x40, 0x1C, 0xEA, 0x00, 0x42, 0xF3, 0x3C, 0xEF, 0x39, 0xC4, 0xF3, 0x5E,
  0xBC, 0x30,
  // "á" (U+00E1)
  0x00, 0x73, 0x00, 0x6A, 0x00, 0x1C, 0xEA, 0x00, 0x42, 0xF3, 0x3C, 0xEF, 0x39, 0xC4, 0xF3, 0x5E,
  0xBC, 0x30,
  // "â" (U+00E2)
  0x06, 0x60, 0x05, 0xAA, 0x60, 0x1C, 0xEA, 0x00, 0x42, 0xF3, 0x3C, 0xEF, 0x39, 0xC4, 0xF3, 0x5E,
  0xBC, 0x30,
  // "ã" (U+00E3)
  0x6E, 0xE5, 0x02, 0xEF, 0xA0, 0x04, 0x2F, 0x33, 0xCE, 0xF3, 0x9C, 0x4F, 0x35, 0xEB, 0xC3,
  // "ä" (U+00E4)
  0x0B, 0x49, 0x00, 0x00, 0x00, 0x1C, 0xEA, 0x00, 0x42, 0xF3, 0x3C, 0xEF, 0x39, 0xC4, 0xF3, 0x5E,
  0xBC, 0x30,
  // "å" (U+00E5)
  0x05, 0x91, 0x00, 0x59, 0x10, 0x1C, 0xEA, 0x00, 0x42, 0xF3, 0x3C, 0xEF, 0x39, 0xC4, 0xF3, 0x5E,
  0xBC, 0x30,
  // "æ" (U+00E6)
  0x1C, 0xE9, 0xDE, 0x40, 0x33, 0xF7, 0x5C, 0x3C, 0xEF, 0xEE, 0xF9, 0xC5, 0xF8, 0x34, 0x4E, 0xD4,
  0xCF, 0x90,
  // "ç" (U+00E7)
  0x1B, 0xF9, 0x7C, 0x12, 0x99, 0x00, 0x7C, 0x13, 0x1B, 0xF9, 0x00, 0x96, 0x01, 0xB5,
  // "è" (U+00E8)
  0x04, 0x60, 0x00, 0x0B, 0x40, 0x1B, 0xE9, 0x07, 0xC2, 0xE3, 0x9F, 0xEF, 0x57, 0xC3, 0x41, 0x1B,
  0xFD, 0x10,
  // "é" (U+00E9)
  0x00, 0x73, 0x00, 0x6A, 0x00, 0x1B, 0xE9, 0x07, 0xC2, 0xE3, 0x9F, 0xEF, 0x57, 0xC3, 0x41, 0x1B,
  0xFD, 0x10,
  // "ê" (U+00EA)
  0x06, 0x60, 0x05, 0xAA, 0x60, 0x1B, 0xE9, 0x07, 0xC2, 0xE3, 0x9F, 0xEF, 0x57, 0xC3, 0x41, 0x1B,
  0xFD, 0x10,
  // "ë" (U+00EB)
  0x0B, 0x49, 0x00, 0x00, 0x00, 0x1B, 0xE9, 0x07, 0xC2, 0xE3, 0x9F, 0xEF, 0x57, 0xC3, 0x41, 0x1B,
  0xFD, 0x10,
  // "ì" (U+00EC)
  0x46, 0x00, 0xB4, 0x05, 0xC0, 0x5C, 0x05, 0xC0, 0x5C, 0x05, 0xC0,
  // "í" (U+00ED)
  0x07, 0x36, 0xA0, 0x5C, 0x05, 0xC0, 0x5C, 0x05, 0xC0, 0x5C, 0x00,
  // "î" (U+00EE)
  0x06, 0x60, 0x5A, 0xA6, 0x05, 0xC0, 0x05, 0xC0, 0x05, 0xC0, 0x05, 0xC0, 0x05, 0xC0,
  // "ï" (U+00EF)
  0xB4, 0x90, 0x00, 0x5C, 0x05, 0xC0, 0x5C, 0x05, 0xC0, 0x5C, 0x00,
  // "ð" (U+00F0)
  0x01, 0x13, 0x00, 0x5E, 0xB0, 0x06, 0x7D, 0x01, 0xBD, 0xE5, 0x7C, 0x2D, 0x89, 0x90, 0xA8, 0x7C,
  0x2D, 0x50, 0xBE, 0xA0,
  // "ñ" (U+00F1)
  0x06, 0xEE, 0x55, 0xCE, 0xF3, 0x5F, 0x2A, 0x95, 0xC0, 0x8A, 0x5C, 0x08, 0xA5, 0xC0, 0x8A,
  // "ò" (U+00F2)
  0x04, 0x60, 0x00, 0x0B, 0x40, 0x0B, 0xEA, 0x07, 0xC1, 0xD6, 0x99, 0x0A, 0x87, 0xC1, 0xD6, 0x0B,
  0xEA, 0x00,
  // "ó" (U+00F3)
  0x00, 0x73, 0x00, 0x6A, 0x00, 0x0B, 0xEA, 0x07, 0xC1, 0xD6, 0x99, 0x0A, 0x87, 0xC1, 0xD6, 0x0B,
  0xEA, 0x00,
  // "ô" (U+00F4)
  0x06, 0x60, 0x05, 0xAA, 0x60, 0x0B, 0xEA, 0x07, 0xC1, 0xD6, 0x99, 0x0A, 0x87, 0xC1, 0xD6, 0x0B,
  0xEA, 0x00,
  // "õ" (U+00F5)
  0x06, 0xEE, 0x50, 0xCF, 0xC0, 0x7C, 0x1D, 0x69, 0x90, 0xA8, 0x7C, 0x1D, 0x60, 0xBE, 0xA0,
  // "ö" (U+00F6)
  0x18, 0x1B, 0x49, 0x78, 0xA5, 0xBE, 0xA0, 0x7C, 0x1D, 0x69, 0x90, 0xA8, 0x7C, 0x1D, 0x60, 0xBE,
  0xA1,
  // "÷" (U+00F7)
  0x02, 0xA0, 0x09, 0xEE, 0xE3, 0x11, 0x11, 0x00, 0x2A, 0x00,
  // "ø" (U+00F8)
  0x0B, 0xED, 0x17, 0xC6, 0xF6, 0x99, 0xCA, 0x87, 0xF7, 0xD6, 0x2E, 0xFA, 0x00, 0x10, 0x00,
  // "ù" (U+00F9)
  0x04, 0x60, 0x00, 0x0B, 0x40, 0x6C, 0x08, 0x96, 0xC0, 0x89, 0x6C, 0x08, 0x95, 0xD0, 0xB9, 0x1C,
  0xEA, 0x90,
  // "ú" (U+00FA)
  0x00, 0x07, 0x30, 0x06, 0xA0, 0x6C, 0x08, 0x96, 0xC0, 0x89, 0x6C, 0x08, 0x95, 0xD0, 0xB9, 0x1C,
  0xEA, 0x90,
  // "û" (U+00FB)
  0x00, 0x66, 0x00, 0x5A, 0xA6, 0x6C, 0x08, 0x96, 0xC0, 0x89, 0x6C, 0x08, 0x95, 0xD0, 0xB9, 0x1C,
  0xEA, 0x90,
  // "ü" (U+00FC)
  0x0B, 0x49, 0x00, 0x00, 0x00, 0x6C, 0x08, 0x96, 0xC0, 0x89, 0x6C, 0x08, 0x95, 0xD0, 0xB9, 0x1C,
  0xEA, 0x90,
  // "ý" (U+00FD)
  0x00, 0x73, 0x00, 0x6A, 0x00, 0xC6, 0x0D, 0x57, 0xB2, 0xF1, 0x1F, 0x8A, 0x00, 0xBE, 0x50, 0x06,
  0xF0, 0x01, 0x9A, 0x00, 0xBD, 0x20, 0x00,
  // "þ" (U+00FE)
  0x5C, 0x00, 0x05, 0xC0, 0x00, 0x5D, 0xCD, 0x25, 0xE2, 0xB8, 0x5C, 0x08, 0xA5, 0xE2, 0xB8, 0x5D,
  0xDD, 0x25, 0xC0, 0x00, 0x5C, 0x00, 0x00,
  // "ÿ" (U+00FF)
  0x0B, 0x49, 0x00, 0x00, 0x00, 0xC6, 0x0D, 0x57, 0xB2, 0xF1, 0x1F, 0x8A, 0x00, 0xBE, 0x50, 0x06,
  0xF0, 0x01, 0x9A, 0x00, 0xBD, 0x20, 0x00,
  // "Ā" (U+0100)
  0x0A, 0xEE, 0x00, 0x03, 0xFC, 0x00, 0x07, 0x9E, 0x00, 0x0C, 0x3A, 0x50, 0x2F, 0xFF, 0xA0, 0x7A,
  0x23, 0xE0, 0xC6, 0x00, 0xD5,
  // "ā" (U+0101)
  0x0A, 0xEE, 0x01, 0xEF, 0xC0, 0x04, 0x2F, 0x33, 0xCE, 0xF3, 0x9C, 0x4F, 0x35, 0xEB, 0xC3,
  // "Ă" (U+0102)
  0x03, 0x02, 0x20, 0x05, 0xED, 0x10, 0x00, 0x10, 0x00, 0x02, 0xFA, 0x00, 0x07, 0x9E, 0x00, 0x0C,
  0x3A, 0x50, 0x2F, 0xFF, 0xA0, 0x7A, 0x23, 0xE0, 0xC6, 0x00, 0xD5,
  // "ă" (U+0103)
  0x03, 0x02, 0x20, 0x5E, 0xD1, 0x00, 0x10, 0x01, 0xCE, 0xA0, 0x04, 0x2F, 0x33, 0xCE, 0xF3, 0x9C,
  0x4F, 0x35, 0xEB, 0xC3,
  // "Ą" (U+0104)
  0x02, 0xFA, 0x00, 0x07, 0x9E, 0x00, 0x0C, 0x3A, 0x50, 0x2F, 0xFF, 0xA0, 0x7A, 0x23, 0xE0, 0xC6,
  0x00, 0xF5, 0x00, 0x07, 0x30, 0x00, 0x08, 0xD0, 0x00, 0x00, 0x10,
  // "ą" (U+0105)
  0x1C, 0xEA, 0x00, 0x42, 0xF3, 0x3C, 0xEF, 0x39, 0xC4, 0xF3, 0x5E, 0xBF, 0x30, 0x07, 0x30, 0x00,
  0x8D, 0x00, 0x00, 0x10,
  // "Ć" (U+0106)
  0x00, 0x07, 0x30, 0x06, 0xA0, 0x06, 0xDE, 0x83, 0xF4, 0x23, 0x7C, 0x00, 0x07, 0xB0, 0x00, 0x4F,
  0x41, 0x20, 0x7E, 0xE7,
  // "ć" (U+0107)
  0x00, 0x73, 0x06, 0xA0, 0x1B, 0xF9, 0x7C, 0x12, 0x99, 0x00, 0x7C, 0x13, 0x1B, 0xF9,
  // "Ĉ" (U+0108)
  0x00, 0x66, 0x00, 0x5A, 0xA6, 0x06, 0xDE, 0x83, 0xF4, 0x23, 0x7C, 0x00, 0x07, 0xB0, 0x00, 0x4F,
  0x41, 0x20, 0x7E, 0xE7,
  // "ĉ" (U+0109)
  0x06, 0x60, 0x5A, 0xA6, 0x1B, 0xF9, 0x7C, 0x12, 0x99, 0x00, 0x7C, 0x13, 0x1B, 0xF9,
  // "Ċ" (U+010A)
  0x00, 0x87, 0x00, 0x00, 0x00, 0x06, 0xDE, 0x83, 0xF4, 0x23, 0x7C, 0x00, 0x07, 0xB0, 0x00, 0x4F,
  0x41, 0x20, 0x7E, 0xE7,
  // "ċ" (U+010B)
  0x08, 0x70, 0x00, 0x00, 0x1B, 0xF9, 0x7C, 0x12, 0x99, 0x00, 0x7C, 0x13, 0x1B, 0xF9,
  // "Č" (U+010C)
  0x04, 0x33, 0x40, 0x1D, 0xD1, 0x06, 0xDE, 0x83, 0xF4, 0x23, 0x7C, 0x00, 0x07, 0xB0, 0x00, 0x4F,
  0x41, 0x20, 0x7E, 0xE7,
  // "č" (U+010D)
  0x43, 0x34, 0x1D, 0xD1, 0x1B, 0xF9, 0x7C, 0x12, 0x99, 0x00, 0x7C, 0x13, 0x1B, 0xF9,
  // "Ď" (U+010E)
  0x04, 0x33, 0x40, 0x01, 0xDD, 0x10, 0x4F, 0xFD, 0x50, 0x4E, 0x15, 0xF2, 0x4E, 0x00, 0xD6, 0x4E,
  0x00, 0xD5, 0x4E, 0x16, 0xE1, 0x4F, 0xFC, 0x40,
  // "ď" (U+010F)
  0x00, 0x0B, 0x9C, 0x00, 0x0B, 0x70, 0x1C, 0xDC, 0x60, 0x7C, 0x2D, 0x60, 0x99, 0x0A, 0x60, 0x7C,
  0x1D, 0x60, 0x1D, 0xDB, 0x60,
  // "Đ" (U+0110)
  0x4F, 0xFD, 0x50, 0x4E, 0x15, 0xF2, 0xCF, 0xC0, 0xD6, 0x5E, 0x10, 0xD5, 0x4E, 0x16, 0xE1, 0x4F,
  0xFC, 0x40,
  // "đ" (U+0111)
  0x00, 0x0B, 0x60, 0x0E, 0xFF, 0x1C, 0xDD, 0x67, 0xC2, 0xD6, 0x99, 0x0A, 0x67, 0xC1, 0xD6, 0x1D,
  0xDB, 0x60,
  // "Ē" (U+0112)
  0x0A, 0xEE, 0x4F, 0xFF, 0x4E, 0x11, 0x4F, 0xEC, 0x4E, 0x11, 0x4E, 0x11, 0x4F, 0xFF,
  // "ē" (U+0113)
  0x0A, 0xEE, 0x01, 0xDF, 0xB0, 0x7C, 0x2E, 0x39, 0xFE, 0xF5, 0x7C, 0x34, 0x11, 0xBF, 0xD1,
  // "Ĕ" (U+0114)
  0x03, 0x02, 0x20, 0x5E, 0xD1, 0x00, 0x10, 0x04, 0xFF, 0xF0, 0x4E, 0x11, 0x04, 0xFE, 0xC0, 0x4E,
  0x11, 0x04, 0xE1, 0x10, 0x4F, 0xFF, 0x00,
  // "ĕ" (U+0115)
  0x03, 0x02, 0x20, 0x5E, 0xD1, 0x00, 0x10, 0x01, 0xBE, 0x90, 0x7C, 0x2E, 0x39, 0xFE, 0xF5, 0x7C,
  0x34, 0x11, 0xBF, 0xD1,
  // "Ė" (U+0116)
  0x10, 0x80, 0x75, 0x04, 0xB8, 0x97, 0x4E, 0x11, 0x4F, 0xEC, 0x4E, 0x11, 0x4E, 0x11, 0x4B,
  // "ė" (U+0117)
  0x10, 0x80, 0x77, 0x8A, 0x71, 0xBE, 0x90, 0x7C, 0x2E, 0x39, 0xFE, 0xF5, 0x7C, 0x34, 0x11, 0xBF,
  0xD1,
  // "Ę" (U+0118)
  0x4F, 0xFF, 0x4E, 0x11, 0x4F, 0xEC, 0x4E, 0x11, 0x4E, 0x11, 0x4F, 0xFF, 0x00, 0x73, 0x00, 0x8D,
  0x00, 0x01,
  // "ę" (U+0119)
  0x1B, 0xE9, 0x07, 0xC2, 0xE3, 0x9F, 0xEF, 0x57, 0xC3, 0x41, 0x1B, 0xFF, 0x10, 0x04, 0x70, 0x00,
  0x5E, 0x00,
  // "Ě" (U+011A)
  0x43, 0x34, 0x1D, 0xD1, 0x4F, 0xFF, 0x4E, 0x11, 0x4F, 0xEC, 0x4E, 0x11, 0x4E, 0x11, 0x4F, 0xFF,
  // "ě" (U+011B)
  0x43, 0x34, 0x01, 0xDD, 0x10, 0x1B, 0xE9, 0x07, 0xC2, 0xE3, 0x9F, 0xEF, 0x57, 0xC3, 0x41, 0x1B,
  0xFD, 0x10,
  // "Ĝ" (U+011C)
  0x00, 0x66, 0x00, 0x05, 0xAA, 0x60, 0x05, 0xDF, 0xC0, 0x3F, 0x61, 0x20, 0x7C, 0x1E, 0xE2, 0x7C,
  0x02, 0xF2, 0x3F, 0x52, 0xF2, 0x07, 0xDF, 0xD1,
  // "ĝ" (U+011D)
  0x00, 0x66, 0x00, 0x5A, 0xA6, 0x1C, 0xDB, 0x67, 0xC2, 0xD6, 0x99, 0x0A, 0x67, 0xC1, 0xD6, 0x1D,
  0xDD, 0x61, 0x22, 0xE5, 0x4E, 0xEA, 0x00,
  // "Ğ" (U+011E)
  0x03, 0x02, 0x20, 0x05, 0xED, 0x10, 0x00, 0x10, 0x00, 0x05, 0xDF, 0xC0, 0x3F, 0x61, 0x20, 0x7C,
  0x1E, 0xE2, 0x7C, 0x02, 0xF2, 0x3F, 0x52, 0xF2, 0x07, 0xDF, 0xD1,
  // "ğ" (U+011F)
  0x03, 0x02, 0x20, 0x5E, 0xD1, 0x00, 0x10, 0x01, 0xCD, 0xB6, 0x7C, 0x2D, 0x69, 0x90, 0xA6, 0x7C,
  0x1D, 0x61, 0xDD, 0xD6, 0x12, 0x2E, 0x54, 0xEE, 0xA0,
  // "Ġ" (U+0120)
  0x20, 0x80, 0x77, 0x28, 0xC1, 0x5D, 0xFC, 0x03, 0xF6, 0x12, 0x07, 0xC1, 0xEE, 0x27, 0xC0, 0x2F,
  0x23, 0xF5, 0x2F, 0x20, 0x7D, 0xFD, 0x10,
  // "ġ" (U+0121)
  0x20, 0x80, 0x76, 0x8C, 0x01, 0xCD, 0xB6, 0x7C, 0x2D, 0x69, 0x90, 0xA6, 0x7C, 0x1D, 0x61, 0xDD,
  0xD6, 0x12, 0x2E, 0x54, 0xEE, 0xA1,
  // "Ģ" (U+0122)
  0x18, 0xC1, 0x5D, 0xFC, 0x03, 0xF6, 0x12, 0x07, 0xC1, 0xEE, 0x27, 0xC0, 0x2F, 0x23, 0xF5, 0x2F,
  0x20, 0x7D, 0xFD, 0x17, 0x10, 0x60, 0x72,
  // "ģ" (U+0123)
  0x20, 0xD7, 0x8C, 0x01, 0xCD, 0xB6, 0x7C, 0x2D, 0x69, 0x90, 0xA6, 0x7C, 0x1D, 0x61, 0xDD, 0xD6,
  0x12, 0x2E, 0x54, 0xEE, 0xA1,
  // "Ĥ" (U+0124)
  0x00, 0x66, 0x00, 0x05, 0xAA, 0x60, 0x4E, 0x00, 0xC6, 0x4E, 0x00, 0xC6, 0x4F, 0xEE, 0xF6, 0x4E,
  0x11, 0xD6, 0x4E, 0x00, 0xC6, 0x4E, 0x00, 0xC6,
  // "ĥ" (U+0125)
  0x06, 0x60, 0x00, 0x5A, 0xA6, 0x00, 0x05, 0xC0, 0x00, 0x05, 0xC0, 0x00, 0x05, 0xDC, 0xE3, 0x05,
  0xF2, 0xA9, 0x05, 0xC0, 0x8A, 0x05, 0xC0, 0x8A, 0x05, 0xC0, 0x8A,
  // "Ħ" (U+0126)
  0xEF, 0xEE, 0xFE, 0x15, 0xE1, 0x1D, 0x70, 0x4F, 0xEE, 0xF6, 0x04, 0xE1, 0x1D, 0x60, 0x4E, 0x00,
  0xC6, 0x04, 0xE0, 0x0C, 0x60,
  // "ħ" (U+0127)
  0x5C, 0x00, 0x0E, 0xFE, 0x00, 0x5C, 0xBE, 0x35, 0xF2, 0xA9, 0x5C, 0x08, 0xA5, 0xC0, 0x8A, 0x5C,
  0x08, 0xA0,
  // "Ĩ" (U+0128)
  0x6E, 0xE5, 0xCF, 0xD0, 0x1F, 0x20, 0x0F, 0x20, 0x0F, 0x20, 0x0F, 0x20, 0xAF, 0xB0,
  // "ĩ" (U+0129)
  0x6E, 0xE5, 0x17, 0xD0, 0x05, 0xC0, 0x05, 0xC0, 0x05, 0xC0, 0x05, 0xC0,
  // "Ī" (U+012A)
  0xAE, 0xEC, 0xFE, 0x1F, 0x20, 0xF2, 0x0F, 0x20, 0xF2, 0xAF, 0xB0,
  // "ī" (U+012B)
  0xAE, 0xE7, 0xE1, 0x5C, 0x05, 0xC0, 0x5C, 0x05, 0xC0,
  // "Ĭ" (U+012C)
  0x30, 0x22, 0x5E, 0xD1, 0x01, 0x00, 0xBF, 0xC0, 0x1F, 0x20, 0x0F, 0x20, 0x0F, 0x20, 0x0F, 0x20,
  0xAF, 0xB0,
  // "ĭ" (U+012D)
  0x30, 0x22, 0x5E, 0xD1, 0x01, 0x00, 0x05, 0xC0, 0x05, 0xC0, 0x05, 0xC0, 0x05, 0xC0, 0x05, 0xC0,
  // "Į" (U+012E)
  0xBF, 0xC1, 0xF2, 0x0F, 0x20, 0xF2, 0x0F, 0x2A, 0xFF, 0x07, 0x30, 0x8D, 0x00, 0x10,
  // "į" (U+012F)
  0x4B, 0x00, 0x5C, 0x5C, 0x5C, 0x5C, 0x6F, 0x73, 0x8D, 0x01,
  // "İ" (U+0130)
  0x08, 0x70, 0x00, 0xBF, 0xC1, 0xF2, 0x0F, 0x20, 0xF2, 0x0F, 0x2A, 0xFB,
  // "ı" (U+0131)
  0x5C, 0x5C, 0x5C, 0x5C, 0x5C,
  // "Ĳ" (U+0132)
  0xBF, 0xC4, 0xE1, 0xF2, 0x4E, 0x0F, 0x24, 0xE0, 0xF2, 0x4E, 0x0F, 0x24, 0xEA, 0xFB, 0x4E, 0x00,
  0x06, 0xD0, 0x08, 0xF6,
  // "ĳ" (U+0133)
  0x4B, 0x4B, 0x00, 0x00, 0x5C, 0x5C, 0x5C, 0x5C, 0x5C, 0x5C, 0x5C, 0x5C, 0x5C, 0x5C, 0x00, 0x7C,
  0x07, 0xE5,
  // "Ĵ" (U+0134)
  0x06, 0x60, 0x5A, 0xA6, 0x04, 0xE0, 0x04, 0xE0, 0x04, 0xE0, 0x04, 0xE0, 0x04, 0xE0, 0x04, 0xE0,
  0x06, 0xD0, 0x8F, 0x60,
  // "ĵ" (U+0135)
  0x06, 0x60, 0x5A, 0xA6, 0x05, 0xC0, 0x05, 0xC0, 0x05, 0xC0, 0x05, 0xC0, 0x05, 0xC0, 0x07, 0xC0,
  0x7E, 0x50,
  // "Ķ" (U+0136)
  0x4E, 0x06, 0xD0, 0x4E, 0x3E, 0x30, 0x4E, 0xD7, 0x00, 0x4F, 0xCC, 0x00, 0x4E, 0x0E, 0x60, 0x4E,
  0x05, 0xE1, 0x00, 0x00, 0x00, 0x00, 0xB2, 0x00,
  // "ķ" (U+0137)
  0x5C, 0x00, 0x05, 0xC0, 0x00, 0x5C, 0x0D, 0x75, 0xCA, 0xA0, 0x5F, 0xF5, 0x05, 0xD6, 0xE1, 0x5C,
  0x0B, 0x90, 0x00, 0x00, 0x01, 0xC0, 0x00,
  // "ĸ" (U+0138)
  0x5C, 0x0C, 0x75, 0xC8, 0xB0, 0x5E, 0xF5, 0x05, 0xD7, 0xD0, 0x5C, 0x0B, 0x90,
  // "Ĺ" (U+0139)
  0x07, 0x30, 0x06, 0xA0, 0x00, 0x4E, 0x00, 0x04, 0xE0, 0x00, 0x4E, 0x00, 0x04, 0xE0, 0x00, 0x4E,
  0x11, 0x04, 0xFF, 0xF3,
  // "ĺ" (U+013A)
  0x07, 0x36, 0xA0, 0x5C, 0x05, 0xC0, 0x5C, 0x05, 0xC0, 0x5C, 0x05, 0xC0, 0x5C, 0x00,
  // "Ļ" (U+013B)
  0x04, 0x0E, 0x30, 0x40, 0xE3, 0x04, 0x0E, 0x30, 0x40, 0xE3, 0x84, 0x4E, 0x11, 0x04, 0xB0, 0x36,
  0x01, 0x0C, 0x20,
  // "ļ" (U+013C)
  0x5C, 0x5C, 0x5C, 0x5C, 0x5C, 0x5C, 0x5C, 0x00, 0x59,
  // "Ľ" (U+013D)
  0x4E, 0x0B, 0x34, 0xE0, 0x00, 0x4E, 0x00, 0x04, 0xE0, 0x00, 0x4E, 0x11, 0x04, 0xFF, 0xF3,
  // "ľ" (U+013E)
  0x5C, 0xC2, 0x5C, 0x00, 0x5C, 0x00, 0x5C, 0x00, 0x5C, 0x00, 0x5C, 0x00, 0x5C, 0x00,
  // "Ŀ" (U+013F)
  0x4E, 0x00, 0x04, 0xE0, 0x87, 0x4E, 0x00, 0x04, 0xE0, 0x00, 0x4E, 0x11, 0x04, 0xFF, 0xF3,
  // "ŀ" (U+0140)
  0x5C, 0x00, 0x5C, 0x00, 0x5C, 0x87, 0x5C, 0x00, 0x5C, 0x00, 0x5C, 0x00, 0x5C, 0x00,
  // "Ł" (U+0141)
  0x4E, 0x00, 0x04, 0xE1, 0x00, 0x4F, 0xA0, 0x0B, 0xE0, 0x00, 0x4E, 0x11, 0x04, 0xFF, 0xF3,
  // "ł" (U+0142)
  0x5C, 0x05, 0xC0, 0x5D, 0x06, 0xF5, 0xDC, 0x05, 0xC0, 0x5C, 0x00,
  // "Ń" (U+0143)
  0x00, 0x07, 0x30, 0x00, 0x6A, 0x00, 0x4F, 0x80, 0x4C, 0x4E, 0xE1, 0x4C, 0x4B, 0xA9, 0x4C, 0x4C,
  0x2F, 0x7C, 0x4C, 0x09, 0xEC, 0x4C, 0x01, 0xEC,
  // "ń" (U+0144)
  0x00, 0x07, 0x30, 0x06, 0xA0, 0x5B, 0xCE, 0x35, 0xF2, 0xA9, 0x5C, 0x08, 0xA5, 0xC0, 0x8A, 0x5C,
  0x08, 0xA0,
  // "Ņ" (U+0145)
  0x8C, 0x24, 0xF8, 0x04, 0xC4, 0xEE, 0x14, 0xC4, 0xBA, 0x94, 0xC4, 0xC2, 0xF7, 0xC4, 0xC0, 0x9E,
  0xC4, 0xC0, 0x1E, 0xC7, 0x10, 0x40, 0x92,
  // "ņ" (U+0146)
  0x8A, 0x75, 0xBC, 0xE3, 0x5F, 0x2A, 0x95, 0xC0, 0x8A, 0x5C, 0x08, 0xA5, 0xC0, 0x8A, 0x70, 0xD0,
  0x11,
  // "Ň" (U+0147)
  0x04, 0x33, 0x40, 0x01, 0xDD, 0x10, 0x4F, 0x80, 0x4C, 0x4E, 0xE1, 0x4C, 0x4B, 0xA9, 0x4C, 0x4C,
  0x2F, 0x7C, 0x4C, 0x09, 0xEC, 0x4C, 0x01, 0xEC,
  // "ň" (U+0148)
  0x04, 0x33, 0x40, 0x1D, 0xD1, 0x5B, 0xCE, 0x35, 0xF2, 0xA9, 0x5C, 0x08, 0xA5, 0xC0, 0x8A, 0x5C,
  0x08, 0xA0,
  // "ŉ" (U+0149)
  0x98, 0x00, 0x00, 0xC8, 0xBC, 0xE3, 0x25, 0xF2, 0xA9, 0x05, 0xC0, 0x8A, 0x05, 0xC0, 0x8A, 0x05,
  0xC0, 0x8A,
  // "Ŋ" (U+014A)
  0x4F, 0x90, 0x4C, 0x4E, 0xF3, 0x4C, 0x4C, 0x9D, 0x5C, 0x4C, 0x0D, 0xCC, 0x4C, 0x04, 0xFC, 0x4C,
  0x00, 0x9C, 0x00, 0x00, 0x6B, 0x00, 0x0C, 0xF5, 0x00, 0x01, 0x00,
  // "ŋ" (U+014B)
  0x5A, 0xCE, 0x35, 0xF2, 0xB9, 0x5C, 0x08, 0xA5, 0xC0, 0x8A, 0x5C, 0x08, 0xA0, 0x00, 0x99, 0x00,
  0x7E, 0x40,
  // "Ō" (U+014C)
  0x00, 0xAE, 0xE0, 0x07, 0xFF, 0xC1, 0x3F, 0x42, 0xC9, 0x7C, 0x00, 0x6D, 0x7C, 0x00, 0x6D, 0x3F,
  0x42, 0xC9, 0x07, 0xEE, 0xA1,
  // "ō" (U+014D)
  0x0A, 0xEE, 0x00, 0xCF, 0xC0, 0x7C, 0x1D, 0x69, 0x90, 0xA8, 0x7C, 0x1D, 0x60, 0xBE, 0xA0,
  // "Ŏ" (U+014E)
  0x03, 0x02, 0x20, 0x05, 0xED, 0x10, 0x00, 0x10, 0x00, 0x07, 0xEE, 0xA1, 0x3F, 0x42, 0xC9, 0x7C,
  0x00, 0x6D, 0x7C, 0x00, 0x6D, 0x3F, 0x42, 0xC9, 0x07, 0xEE, 0xA1,
  // "ŏ" (U+014F)
  0x03, 0x02, 0x20, 0x5E, 0xD1, 0x00, 0x10, 0x00, 0xBE, 0xA0, 0x7C, 0x1D, 0x69, 0x90, 0xA8, 0x7C,
  0x1D, 0x60, 0xBE, 0xA0,
  // "Ő" (U+0150)
  0x00, 0x3A, 0xA5, 0x00, 0x10, 0x10, 0x07, 0xEE, 0xA1, 0x3F, 0x42, 0xC9, 0x7C, 0x00, 0x6D, 0x7C,
  0x00, 0x6D, 0x3F, 0x42, 0xC9, 0x07, 0xEE, 0xA1,
  // "ő" (U+0151)
  0x03, 0xAA, 0x50, 0x10, 0x10, 0x0B, 0xEA, 0x07, 0xC1, 0xD6, 0x99, 0x0A, 0x87, 0xC1, 0xD6, 0x0B,
  0xEA, 0x00,
  // "Œ" (U+0152)
  0x07, 0xEF, 0xFF, 0xF4, 0x4F, 0x32, 0xF2, 0x10, 0x7B, 0x01, 0xFE, 0xE2, 0x7B, 0x01, 0xF3, 0x10,
  0x4F, 0x32, 0xF2, 0x10, 0x07, 0xEF, 0xFF, 0xF4,
  // "œ" (U+0153)
  0x1B, 0xE9, 0xAE, 0xA0, 0x7C, 0x1D, 0xC2, 0xC5, 0x99, 0x0A, 0xFE, 0xF7, 0x7C, 0x1D, 0xC3, 0x42,
  0x0B, 0xEA, 0x9E, 0xD2,
  // "Ŕ" (U+0154)
  0x00, 0x07, 0x30, 0x00, 0x6A, 0x00, 0x4F, 0xFD, 0x30, 0x4E, 0x1B, 0x90, 0x4F, 0xED, 0x30, 0x4E,
  0x4E, 0x00, 0x4E, 0x0C, 0x70, 0x4E, 0x04, 0xE1,
  // "ŕ" (U+0155)
  0x00, 0x73, 0x06, 0xA0, 0x5B, 0xC6, 0x5F, 0x30, 0x5C, 0x00, 0x5C, 0x00, 0x5C, 0x00,
  // "Ŗ" (U+0156)
  0x4F, 0xFD, 0x30, 0x4E, 0x1B, 0x90, 0x4F, 0xED, 0x30, 0x4E, 0x4E, 0x00, 0x4E, 0x0C, 0x70, 0x4E,
  0x04, 0xE1, 0x00, 0x00, 0x00, 0x00, 0xA3, 0x00,
  // "ŗ" (U+0157)
  0x5B, 0xC6, 0x5F, 0x30, 0x5C, 0x00, 0x5C, 0x00, 0x5C, 0x00, 0x00, 0x00, 0x49, 0x00,
  // "Ř" (U+0158)
  0x04, 0x33, 0x40, 0x01, 0xDD, 0x10, 0x4F, 0xFD, 0x30, 0x4E, 0x1B, 0x90, 0x4F, 0xED, 0x30, 0x4E,
  0x4E, 0x00, 0x4E, 0x0C, 0x70, 0x4E, 0x04, 0xE1,
  // "ř" (U+0159)
  0x43, 0x34, 0x1D, 0xD1, 0x5B, 0xC6, 0x5F, 0x30, 0x5C, 0x00, 0x5C, 0x00, 0x5C, 0x00,
  // "Ś" (U+015A)
  0x00, 0x73, 0x06, 0xA0, 0x2C, 0xEB, 0x7B, 0x13, 0x4E, 0x80, 0x03, 0xCC, 0x32, 0x4F, 0x7E, 0xE7,
  // "ś" (U+015B)
  0x00, 0x73, 0x06, 0xA0, 0x4E, 0xE6, 0x9B, 0x21, 0x2B, 0xD3, 0x31, 0xA9, 0x7F, 0xD4,
  // "Ŝ" (U+015C)
  0x06, 0x60, 0x5A, 0xA6, 0x2C, 0xEB, 0x7B, 0x13, 0x4E, 0x80, 0x03, 0xCC, 0x32, 0x4F, 0x7E, 0xE7,
  // "ŝ" (U+015D)
  0x06, 0x60, 0x5A, 0xA6, 0x4E, 0xE6, 0x9B, 0x21, 0x2B, 0xD3, 0x31, 0xA9, 0x7F, 0xD4,
  // "Ş" (U+015E)
  0x2C, 0xEB, 0x7B, 0x13, 0x4E, 0x80, 0x03, 0xCC, 0x32, 0x4F, 0x7F, 0xE7, 0x09, 0x60, 0x1B, 0x50,
  // "ş" (U+015F)
  0x4E, 0xE6, 0x9B, 0x21, 0x2B, 0xD3, 0x31, 0xA9, 0x7F, 0xE4, 0x09, 0x60, 0x1B, 0x50,
  // "Š" (U+0160)
  0x43, 0x34, 0x1D, 0xD1, 0x2C, 0xEB, 0x7B, 0x13, 0x4E, 0x80, 0x03, 0xCC, 0x32, 0x4F, 0x7E, 0xE7,
  // "š" (U+0161)
  0x43, 0x34, 0x1D, 0xD1, 0x4E, 0xE6, 0x9B, 0x21, 0x2B, 0xD3, 0x31, 0xA9, 0x7F, 0xD4,
  // "Ţ" (U+0162)
  0xDF, 0xFF, 0x70, 0x5E, 0x10, 0x04, 0xE0, 0x00, 0x4E, 0x00, 0x04, 0xE0, 0x00, 0x4F, 0x00, 0x00,
  0x96, 0x00, 0x1B, 0x50,
  // "ţ" (U+0163)
  0x0D, 0x00, 0xAF, 0xF2, 0x4E, 0x00, 0x3E, 0x00, 0x3F, 0x10, 0x0E, 0xF2, 0x09, 0x60, 0x1B, 0x50,
  // "Ť" (U+0164)
  0x43, 0x34, 0x01, 0xDD, 0x10, 0xDF, 0xFF, 0x70, 0x5E, 0x10, 0x04, 0xE0, 0x00, 0x4E, 0x00, 0x04,
  0xE0, 0x00, 0x4E, 0x00,
  // "ť" (U+0165)
  0x04, 0x0A, 0x40, 0xE0, 0x00, 0xAF, 0xF2, 0x04, 0xE0, 0x00, 0x3E, 0x00, 0x03, 0xF1, 0x00, 0x0C,
  0xE2, 0x00,
  // "Ŧ" (U+0166)
  0xDF, 0xFF, 0x70, 0x5E, 0x10, 0x3E, 0xFC, 0x00, 0x5E, 0x10, 0x04, 0xE0, 0x00, 0x4E, 0x00,
  // "ŧ" (U+0167)
  0x0D, 0x00, 0xAF, 0xF2, 0x4E, 0x00, 0xBF, 0xE0, 0x4F, 0x30, 0x1D, 0xE2,
  // "Ũ" (U+0168)
  0x06, 0xEE, 0x50, 0x4F, 0x11, 0xD5, 0x4D, 0x00, 0xD5, 0x4D, 0x00, 0xD5, 0x4D, 0x00, 0xD5, 0x2F,
  0x43, 0xF3, 0x07, 0xEE, 0x80,
  // "ũ" (U+0169)
  0x06, 0xEE, 0x56, 0xD1, 0xA9, 0x6C, 0x08, 0x96, 0xC0, 0x89, 0x5D, 0x0B, 0x91, 0xCE, 0xA9,
  // "Ū" (U+016A)
  0x0A, 0xEE, 0x00, 0x4F, 0x11, 0xD5, 0x4D, 0x00, 0xD5, 0x4D, 0x00, 0xD5, 0x4D, 0x00, 0xD5, 0x2F,
  0x43, 0xF3, 0x07, 0xEE, 0x80,
  // "ū" (U+016B)
  0x0A, 0xEE, 0x06, 0xD1, 0xA9, 0x6C, 0x08, 0x96, 0xC0, 0x89, 0x5D, 0x0B, 0x91, 0xCE, 0xA9,
  // "Ŭ" (U+016C)
  0x03, 0x02, 0x20, 0x05, 0xED, 0x10, 0x00, 0x10, 0x00, 0x4D, 0x00, 0xD5, 0x4D, 0x00, 0xD5, 0x4D,
  0x00, 0xD5, 0x4D, 0x00, 0xD5, 0x2F, 0x43, 0xF3, 0x07, 0xEE, 0x80,
  // "ŭ" (U+016D)
  0x03, 0x02, 0x20, 0x5E, 0xD1, 0x00, 0x10, 0x06, 0xC0, 0x89, 0x6C, 0x08, 0x96, 0xC0, 0x89, 0x5D,
  0x0B, 0x91, 0xCE, 0xA9,
  // "Ů" (U+016E)
  0x00, 0x59, 0x10, 0x00, 0x59, 0x10, 0x4D, 0x00, 0xD5, 0x4D, 0x00, 0xD5, 0x4D, 0x00, 0xD5, 0x4D,
  0x00, 0xD5, 0x2F, 0x43, 0xF3, 0x07, 0xEE, 0x80,
  // "ů" (U+016F)
  0x05, 0x91, 0x00, 0x59, 0x10, 0x6C, 0x08, 0x96, 0xC0, 0x89, 0x6C, 0x08, 0x95, 0xD0, 0xB9, 0x1C,
  0xEA, 0x90,
  // "Ű" (U+0170)
  0x00, 0x3A, 0xA5, 0x00, 0x10, 0x10, 0x4D, 0x00, 0xD5, 0x4D, 0x00, 0xD5, 0x4D, 0x00, 0xD5, 0x4D,
  0x00, 0xD5, 0x2F, 0x43, 0xF3, 0x07, 0xEE, 0x80,
  // "ű" (U+0171)
  0x03, 0xAA, 0x50, 0x10, 0x10, 0x6C, 0x08, 0x96, 0xC0, 0x89, 0x6C, 0x08, 0x95, 0xD0, 0xB9, 0x1C,
  0xEA, 0x90,
  // "Ų" (U+0172)
  0x4D, 0x00, 0xD5, 0x4D, 0x00, 0xD5, 0x4D, 0x00, 0xD5, 0x4D, 0x00, 0xD5, 0x2F, 0x43, 0xF2, 0x07,
  0xEF, 0x70, 0x00, 0x0B, 0x00, 0x00, 0x0B, 0x90,
  // "ų" (U+0173)
  0x6C, 0x08, 0x96, 0xC0, 0x89, 0x6C, 0x08, 0x95, 0xD0, 0xB9, 0x1C, 0xEB, 0xD0, 0x00, 0x73, 0x00,
  0x08, 0xD0, 0x00, 0x01,
  // "Ŵ" (U+0174)
  0x00, 0x06, 0x60, 0x00, 0x00, 0x5A, 0xA6, 0x00, 0xD4, 0x0C, 0x80, 0x89, 0x98, 0x1E, 0xC0, 0xC5,
  0x6B, 0x4A, 0xE1, 0xF1, 0x2E, 0x86, 0xB8, 0xD0, 0x0E, 0xD3, 0x7D, 0x90, 0x0A, 0xE0, 0x3F, 0x60,
  // "ŵ" (U+0175)
  0x00, 0x66, 0x00, 0x00, 0x5A, 0xA6, 0x00, 0xC5, 0x5F, 0x38, 0x98, 0x98, 0xC6, 0xB6, 0x4C, 0xC5,
  0x9E, 0x21, 0xEC, 0x1D, 0xD0, 0x0C, 0xA0, 0xD9, 0x00,
  // "Ŷ" (U+0176)
  0x06, 0x60, 0x05, 0xAA, 0x60, 0xB8, 0x08, 0xB3, 0xF3, 0xF3, 0x0B, 0xEA, 0x00, 0x3F, 0x30, 0x01,
  0xF1, 0x00, 0x1F, 0x10,
  // "ŷ" (U+0177)
  0x06, 0x60, 0x05, 0xAA, 0x60, 0xC6, 0x0D, 0x57, 0xB2, 0xF1, 0x1F, 0x8A, 0x00, 0xBE, 0x50, 0x06,
  0xF0, 0x01, 0x9A, 0x00, 0xBD, 0x20, 0x00,
  // "Ÿ" (U+0178)
  0x0B, 0x49, 0x00, 0x00, 0x00, 0xB8, 0x08, 0xB3, 0xF3, 0xF3, 0x0B, 0xEA, 0x00, 0x3F, 0x30, 0x01,
  0xF1, 0x00, 0x1F, 0x10,
  // "Ź" (U+0179)
  0x00, 0x73, 0x00, 0x6A, 0x00, 0xBF, 0xFF, 0x50, 0x16, 0xD0, 0x01, 0xE4, 0x00, 0xA9, 0x00, 0x5D,
  0x11, 0x0C, 0xFF, 0xF6,
  // "ź" (U+017A)
  0x00, 0x73, 0x06, 0xA0, 0xAF, 0xF9, 0x02, 0xE3, 0x0A, 0x80, 0x5D, 0x10, 0xBF, 0xFA,
  // "Ż" (U+017B)
  0x08, 0x70, 0x00, 0x00, 0x00, 0xBF, 0xFF, 0x50, 0x16, 0xD0, 0x01, 0xE4, 0x00, 0xA9, 0x00, 0x5D,
  0x11, 0x0C, 0xFF, 0xF6,
  // "ż" (U+017C)
  0x08, 0x70, 0x00, 0x00, 0xAF, 0xF9, 0x02, 0xE3, 0x0A, 0x80, 0x5D, 0x10, 0xBF, 0xFA,
  // "Ž" (U+017D)
  0x43, 0x34, 0x01, 0xDD, 0x10, 0xBF, 0xFF, 0x50, 0x16, 0xD0, 0x01, 0xE4, 0x00, 0xA9, 0x00, 0x5D,
  0x11, 0x0C, 0xFF, 0xF6,
  // "ž" (U+017E)
  0x43, 0x34, 0x1D, 0xD1, 0xAF, 0xF9, 0x02, 0xE3, 0x0A, 0x80, 0x5D, 0x10, 0xBF, 0xFA,
  // "ſ" (U+017F)
  0x1C, 0xE1, 0x5D, 0x20, 0x5C, 0x00, 0x5C, 0x00, 0x5C, 0x00, 0x5C, 0x00, 0x5C, 0x00,
  // "Ω" (U+03A9)
  0x08, 0xEE, 0xA1, 0x05, 0xE3, 0x2C, 0xA0, 0x8B, 0x00, 0x6C, 0x06, 0xC0, 0x08, 0xA0, 0x1C, 0x42,
  0xC3, 0x0C, 0xFB, 0x6F, 0xF1,
  // "μ" (U+03BC)
  0x5C, 0x08, 0xA5, 0xC0, 0x8A, 0x5C, 0x08, 0xA5, 0xE2, 0xCA, 0x5E, 0xEB, 0xA5, 0xC0, 0x00, 0x5C,
  0x00, 0x00,
  // "π" (U+03C0)
  0xBF, 0xFF, 0xF9, 0x0F, 0x38, 0xB0, 0x0F, 0x37, 0xB0, 0x0F, 0x37, 0xC0, 0x0F, 0x33, 0xE7,
  // "–" (U+2013)
  0xAE, 0xEA, 0x11, 0x11,
  // "—" (U+2014)
  0x0A, 0x80, 0x2E, 0x0A, 0x80, 0x41,
  // "€" (U+20AC)
  0x04, 0xDE, 0x40, 0xE5, 0x20, 0xAF, 0xC6, 0x0A, 0xFC, 0x30, 0x0E, 0x51, 0x10, 0x5D, 0xE3,
  // "₿" (U+20BF)
  0x06, 0x61, 0x04, 0xFF, 0xA0, 0x4E, 0x3F, 0x14, 0xFF, 0xC0, 0x4E, 0x3F, 0x34, 0xE2, 0xF3, 0x4F,
  0xFA, 0x00, 0x66, 0x10,
  // "‘" (U+2018)
  0x68, 0xB5, 0x20,
  // "’" (U+2019)
  0x98, 0xC3, 0x20,
  // "‚" (U+201A)
  0x98, 0xC3, 0x20,
  // "‛" (U+201B)
  0xC5, 0x77, 0x01,
  // "“" (U+201C)
  0x68, 0x95, 0xB5, 0xE2, 0x20, 0x20,
  // "”" (U+201D)
  0x98, 0xC5, 0xC3, 0xE0, 0x20, 0x10,
  // "„" (U+201E)
  0x98, 0xC5, 0xC3, 0xE0, 0x20, 0x10,
  // "‟" (U+201F)
  0xC5, 0xE2, 0x77, 0x95, 0x01, 0x11,
  // "†" (U+2020)
  0x07, 0x70, 0x16, 0x71, 0x6D, 0xD8, 0x05, 0x60, 0x06, 0x60, 0x06, 0x70, 0x07, 0x80,
  // "‡" (U+2021)
  0x06, 0x80, 0x37, 0x93, 0x5B, 0xB7, 0x06, 0x80, 0x5A, 0xB6, 0x38, 0x94, 0x06, 0x80,
  // "•" (U+2022)
  0x3C, 0x39, 0xF9, 0x5E, 0x50,
  // "…" (U+2026)
  0x6A, 0x6A, 0x06, 0xA0,
  // "‰" (U+2030)
  0x6E, 0x80, 0x85, 0x00, 0x00, 0xB7, 0xE1, 0xC0, 0x00, 0x00, 0x7F, 0xA9, 0x9D, 0x74, 0xD7, 0x01,
  0x2C, 0xA8, 0xDA, 0x7E, 0x00, 0xA4, 0xA7, 0xDA, 0x7E, 0x03, 0xB0, 0x5E, 0x74, 0xE8,
  // "‹" (U+2039)
  0x09, 0x56, 0xC0, 0x3E, 0x20, 0x43,
  // "›" (U+203A)
  0x59, 0x00, 0xC5, 0x3E, 0x23, 0x40,
  // "⁄" (U+2044)
  0x00, 0x09, 0x40, 0x02, 0xB0, 0x00, 0xA3, 0x00, 0x3B, 0x00, 0x0B, 0x30, 0x04, 0xA0, 0x00,
  // "™" (U+2122)
  0x68, 0x65, 0x26, 0x17, 0x68, 0x68, 0x17, 0x67, 0x68, 0x01, 0x10, 0x11,
  // "⅒" (U+2152)
  0x00, 0x00, 0x94, 0x00, 0x03, 0xD4, 0x2B, 0x00, 0x00, 0x19, 0x4A, 0x30, 0x5C, 0x50, 0x97, 0xB3,
  0xDF, 0x5C, 0x00, 0xB3, 0x19, 0xF5, 0xC0, 0x4A, 0x00, 0x99, 0xC5,
  // "ﬁ" (U+FB01)
  0x0B, 0xE9, 0xB2, 0xF2, 0x00, 0xBF, 0xF6, 0xC3, 0xF1, 0x5C, 0x2F, 0x05, 0xC2, 0xF0, 0x5C, 0x2F,
  0x05, 0xC0,
  // "ﬂ" (U+FB02)
  0x0B, 0xEA, 0xC2, 0xF2, 0x6C, 0xBF, 0xF6, 0xC3, 0xF1, 0x5C, 0x2F, 0x05, 0xC2, 0xF0, 0x5C, 0x2F,
  0x05, 0xC0,
};

const Font& font_NotoSans_Bold_8() {
  static SmoothFont font(font_NotoSans_Bold_8_data);
  return font;
}

}  // namespace roo_display
