#include "90.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSansMono-Regular (Noto Sans Mono Regular)
// Generated on Wed Nov 19 19:10:53 CET 2025
static const uint8_t font_NotoSansMono_Regular_90_data[] PROGMEM = {
  
  // Header
  0x01, 0x02, 0x04, 0x02, 0x02, 0x03, 0x01, 0x01, 0x5D, 0x00, 0x00,
  0xFF, 0xEF, 0xFF, 0xEB, 0x00, 0x8C, 0x00, 0x59, 0x00, 0x44, 0xFF, 0xEA, 0x00, 0x15, 0x00, 0x00, 0x00, 0xA2, 0x00, 0x19, 0x00, 0x36, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x00, 0x15, 0x00, 0x00, 0x00, 0x20, 0x00, 0x40, 0x00, 0x36, 0x00, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x00, 0x0E, 0x00, 0x2A, 0x00, 0x27, 0x00, 0x40, 0x00, 0x36, 0x00, 0x00, 0xC2, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x00, 0x01, 0x00, 0x34, 0x00, 0x40, 0x00, 0x36, 0x00, 0x01, 0x4D, // "#" (U+0023)
  0x00, 0x24, 0x00, 0x07, 0xFF, 0xFB, 0x00, 0x2E, 0x00, 0x44, 0x00, 0x36, 0x00, 0x03, 0x24, // "$" (U+0024)
  0x00, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x35, 0x00, 0x41, 0x00, 0x36, 0x00, 0x05, 0x34, // "%" (U+0025)
  0x00, 0x26, 0x00, 0x03, 0x00, 0x00, 0x00, 0x33, 0x00, 0x41, 0x00, 0x36, 0x00, 0x07, 0xB3, // "&" (U+0026)
  0x00, 0x27, 0x00, 0x16, 0x00, 0x2A, 0x00, 0x1F, 0x00, 0x40, 0x00, 0x36, 0x00, 0x09, 0xEC, // "'" (U+0027)
  0x00, 0x28, 0x00, 0x12, 0xFF, 0xF2, 0x00, 0x26, 0x00, 0x40, 0x00, 0x36, 0x00, 0x0A, 0x2D, // "(" (U+0028)
  0x00, 0x29, 0x00, 0x0F, 0xFF, 0xF3, 0x00, 0x23, 0x00, 0x41, 0x00, 0x36, 0x00, 0x0B, 0x43, // ")" (U+0029)
  0x00, 0x2A, 0x00, 0x08, 0x00, 0x1F, 0x00, 0x2E, 0x00, 0x43, 0x00, 0x36, 0x00, 0x0C, 0x5A, // "*" (U+002A)
  0x00, 0x2B, 0x00, 0x07, 0x00, 0x0C, 0x00, 0x2E, 0x00, 0x35, 0x00, 0x36, 0x00, 0x0D, 0x66, // "+" (U+002B)
  0x00, 0x2C, 0x00, 0x13, 0xFF, 0xF4, 0x00, 0x22, 0x00, 0x0B, 0x00, 0x36, 0x00, 0x0E, 0x38, // "," (U+002C)
  0x00, 0x2D, 0x00, 0x0D, 0x00, 0x16, 0x00, 0x28, 0x00, 0x1C, 0x00, 0x36, 0x00, 0x0E, 0x88, // "-" (U+002D)
  0x00, 0x2E, 0x00, 0x15, 0x00, 0x00, 0x00, 0x20, 0x00, 0x0B, 0x00, 0x36, 0x00, 0x0E, 0xA1, // "." (U+002E)
  0x00, 0x2F, 0x00, 0x0B, 0x00, 0x01, 0x00, 0x2A, 0x00, 0x40, 0x00, 0x36, 0x00, 0x0E, 0xCF, // "/" (U+002F)
  0x00, 0x30, 0x00, 0x05, 0x00, 0x00, 0x00, 0x30, 0x00, 0x41, 0x00, 0x36, 0x00, 0x0F, 0xF1, // "0" (U+0030)
  0x00, 0x31, 0x00, 0x08, 0x00, 0x01, 0x00, 0x2E, 0x00, 0x40, 0x00, 0x36, 0x00, 0x12, 0x2A, // "1" (U+0031)
  0x00, 0x32, 0x00, 0x06, 0x00, 0x01, 0x00, 0x30, 0x00, 0x41, 0x00, 0x36, 0x00, 0x13, 0x83, // "2" (U+0032)
  0x00, 0x33, 0x00, 0x06, 0x00, 0x00, 0x00, 0x2F, 0x00, 0x41, 0x00, 0x36, 0x00, 0x15, 0x0B, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x04, 0x00, 0x01, 0x00, 0x31, 0x00, 0x40, 0x00, 0x36, 0x00, 0x16, 0xC4, // "4" (U+0034)
  0x00, 0x35, 0x00, 0x07, 0x00, 0x00, 0x00, 0x2E, 0x00, 0x40, 0x00, 0x36, 0x00, 0x18, 0x64, // "5" (U+0035)
  0x00, 0x36, 0x00, 0x05, 0x00, 0x00, 0x00, 0x30, 0x00, 0x41, 0x00, 0x36, 0x00, 0x19, 0xEA, // "6" (U+0036)
  0x00, 0x37, 0x00, 0x05, 0x00, 0x01, 0x00, 0x30, 0x00, 0x40, 0x00, 0x36, 0x00, 0x1B, 0xE1, // "7" (U+0037)
  0x00, 0x38, 0x00, 0x06, 0x00, 0x00, 0x00, 0x2F, 0x00, 0x41, 0x00, 0x36, 0x00, 0x1D, 0x24, // "8" (U+0038)
  0x00, 0x39, 0x00, 0x05, 0x00, 0x00, 0x00, 0x30, 0x00, 0x41, 0x00, 0x36, 0x00, 0x1F, 0x35, // "9" (U+0039)
  0x00, 0x3A, 0x00, 0x15, 0x00, 0x00, 0x00, 0x20, 0x00, 0x31, 0x00, 0x36, 0x00, 0x21, 0x27, // ":" (U+003A)
  0x00, 0x3B, 0x00, 0x13, 0xFF, 0xF5, 0x00, 0x22, 0x00, 0x31, 0x00, 0x36, 0x00, 0x21, 0x85, // ";" (U+003B)
  0x00, 0x3C, 0x00, 0x08, 0x00, 0x0B, 0x00, 0x2D, 0x00, 0x37, 0x00, 0x36, 0x00, 0x22, 0x08, // "<" (U+003C)
  0x00, 0x3D, 0x00, 0x06, 0x00, 0x14, 0x00, 0x2F, 0x00, 0x2B, 0x00, 0x36, 0x00, 0x23, 0x2A, // "=" (U+003D)
  0x00, 0x3E, 0x00, 0x08, 0x00, 0x0B, 0x00, 0x2D, 0x00, 0x37, 0x00, 0x36, 0x00, 0x23, 0x66, // ">" (U+003E)
  0x00, 0x3F, 0x00, 0x08, 0x00, 0x00, 0x00, 0x2D, 0x00, 0x41, 0x00, 0x36, 0x00, 0x24, 0x82, // "?" (U+003F)
  0x00, 0x40, 0x00, 0x01, 0xFF, 0xF8, 0x00, 0x34, 0x00, 0x40, 0x00, 0x36, 0x00, 0x25, 0xD6, // "@" (U+0040)
  0x00, 0x41, 0x00, 0x01, 0x00, 0x01, 0x00, 0x34, 0x00, 0x40, 0x00, 0x36, 0x00, 0x28, 0xC5, // "A" (U+0041)
  0x00, 0x42, 0x00, 0x08, 0x00, 0x01, 0x00, 0x30, 0x00, 0x40, 0x00, 0x36, 0x00, 0x2A, 0x98, // "B" (U+0042)
  0x00, 0x43, 0x00, 0x06, 0x00, 0x00, 0x00, 0x31, 0x00, 0x41, 0x00, 0x36, 0x00, 0x2C, 0x6F, // "C" (U+0043)
  0x00, 0x44, 0x00, 0x06, 0x00, 0x01, 0x00, 0x31, 0x00, 0x40, 0x00, 0x36, 0x00, 0x2E, 0x0E, // "D" (U+0044)
  0x00, 0x45, 0x00, 0x08, 0x00, 0x01, 0x00, 0x2E, 0x00, 0x40, 0x00, 0x36, 0x00, 0x2F, 0xF3, // "E" (U+0045)
  0x00, 0x46, 0x00, 0x08, 0x00, 0x01, 0x00, 0x2E, 0x00, 0x40, 0x00, 0x36, 0x00, 0x31, 0x2C, // "F" (U+0046)
  0x00, 0x47, 0x00, 0x04, 0x00, 0x00, 0x00, 0x2F, 0x00, 0x41, 0x00, 0x36, 0x00, 0x32, 0x69, // "G" (U+0047)
  0x00, 0x48, 0x00, 0x06, 0x00, 0x01, 0x00, 0x2F, 0x00, 0x40, 0x00, 0x36, 0x00, 0x34, 0x3F, // "H" (U+0048)
  0x00, 0x49, 0x00, 0x09, 0x00, 0x01, 0x00, 0x2C, 0x00, 0x40, 0x00, 0x36, 0x00, 0x35, 0xCE, // "I" (U+0049)
  0x00, 0x4A, 0x00, 0x09, 0x00, 0x00, 0x00, 0x29, 0x00, 0x40, 0x00, 0x36, 0x00, 0x37, 0x00, // "J" (U+004A)
  0x00, 0x4B, 0x00, 0x06, 0x00, 0x01, 0x00, 0x31, 0x00, 0x40, 0x00, 0x36, 0x00, 0x38, 0x3F, // "K" (U+004B)
  0x00, 0x4C, 0x00, 0x0A, 0x00, 0x01, 0x00, 0x2E, 0x00, 0x40, 0x00, 0x36, 0x00, 0x3A, 0x42, // "L" (U+004C)
  0x00, 0x4D, 0x00, 0x04, 0x00, 0x01, 0x00, 0x31, 0x00, 0x40, 0x00, 0x36, 0x00, 0x3B, 0x62, // "M" (U+004D)
  0x00, 0x4E, 0x00, 0x06, 0x00, 0x01, 0x00, 0x2F, 0x00, 0x40, 0x00, 0x36, 0x00, 0x3D, 0x99, // "N" (U+004E)
  0x00, 0x4F, 0x00, 0x04, 0x00, 0x00, 0x00, 0x31, 0x00, 0x41, 0x00, 0x36, 0x00, 0x3F, 0x96, // "O" (U+004F)
  0x00, 0x50, 0x00, 0x08, 0x00, 0x01, 0x00, 0x30, 0x00, 0x40, 0x00, 0x36, 0x00, 0x41, 0x99, // "P" (U+0050)
  0x00, 0x51, 0x00, 0x04, 0xFF, 0xF0, 0x00, 0x31, 0x00, 0x41, 0x00, 0x36, 0x00, 0x43, 0x35, // "Q" (U+0051)
  0x00, 0x52, 0x00, 0x08, 0x00, 0x01, 0x00, 0x32, 0x00, 0x40, 0x00, 0x36, 0x00, 0x45, 0x8C, // "R" (U+0052)
  0x00, 0x53, 0x00, 0x07, 0x00, 0x00, 0x00, 0x2F, 0x00, 0x41, 0x00, 0x36, 0x00, 0x47, 0x68, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x04, 0x00, 0x01, 0x00, 0x31, 0x00, 0x40, 0x00, 0x36, 0x00, 0x49, 0x1D, // "T" (U+0054)
  0x00, 0x55, 0x00, 0x06, 0x00, 0x00, 0x00, 0x2F, 0x00, 0x40, 0x00, 0x36, 0x00, 0x4A, 0x02, // "U" (U+0055)
  0x00, 0x56, 0x00, 0x02, 0x00, 0x01, 0x00, 0x33, 0x00, 0x40, 0x00, 0x36, 0x00, 0x4B, 0xC7, // "V" (U+0056)
  0x00, 0x57, 0x00, 0x02, 0x00, 0x01, 0x00, 0x33, 0x00, 0x40, 0x00, 0x36, 0x00, 0x4D, 0xA5, // "W" (U+0057)
  0x00, 0x58, 0x00, 0x03, 0x00, 0x01, 0x00, 0x32, 0x00, 0x40, 0x00, 0x36, 0x00, 0x50, 0x1C, // "X" (U+0058)
  0x00, 0x59, 0x00, 0x03, 0x00, 0x01, 0x00, 0x32, 0x00, 0x40, 0x00, 0x36, 0x00, 0x52, 0x05, // "Y" (U+0059)
  0x00, 0x5A, 0x00, 0x08, 0x00, 0x01, 0x00, 0x2D, 0x00, 0x40, 0x00, 0x36, 0x00, 0x53, 0xAF, // "Z" (U+005A)
  0x00, 0x5B, 0x00, 0x15, 0xFF, 0xF2, 0x00, 0x29, 0x00, 0x40, 0x00, 0x36, 0x00, 0x54, 0xE3, // "[" (U+005B)
  0x00, 0x5C, 0x00, 0x0B, 0x00, 0x01, 0x00, 0x2A, 0x00, 0x40, 0x00, 0x36, 0x00, 0x55, 0xFB, // "\" (U+005C)
  0x00, 0x5D, 0x00, 0x0C, 0xFF, 0xF4, 0x00, 0x20, 0x00, 0x42, 0x00, 0x36, 0x00, 0x57, 0x19, // "]" (U+005D)
  0x00, 0x5E, 0x00, 0x04, 0x00, 0x19, 0x00, 0x31, 0x00, 0x41, 0x00, 0x36, 0x00, 0x58, 0x31, // "^" (U+005E)
  0x00, 0x5F, 0x00, 0x00, 0xFF, 0xF3, 0x00, 0x35, 0xFF, 0xF9, 0x00, 0x36, 0x00, 0x59, 0x5E, // "_" (U+005F)
  0x00, 0x60, 0x00, 0x11, 0x00, 0x37, 0x00, 0x23, 0x00, 0x45, 0x00, 0x36, 0x00, 0x59, 0x61, // "`" (U+0060)
  0x00, 0x61, 0x00, 0x06, 0x00, 0x00, 0x00, 0x2D, 0x00, 0x31, 0x00, 0x36, 0x00, 0x59, 0xA3, // "a" (U+0061)
  0x00, 0x62, 0x00, 0x07, 0x00, 0x00, 0x00, 0x30, 0x00, 0x44, 0x00, 0x36, 0x00, 0x5B, 0x17, // "b" (U+0062)
  0x00, 0x63, 0x00, 0x07, 0x00, 0x00, 0x00, 0x2D, 0x00, 0x31, 0x00, 0x36, 0x00, 0x5C, 0xF4, // "c" (U+0063)
  0x00, 0x64, 0x00, 0x05, 0x00, 0x00, 0x00, 0x2E, 0x00, 0x44, 0x00, 0x36, 0x00, 0x5E, 0x2F, // "d" (U+0064)
  0x00, 0x65, 0x00, 0x05, 0x00, 0x00, 0x00, 0x30, 0x00, 0x31, 0x00, 0x36, 0x00, 0x60, 0x27, // "e" (U+0065)
  0x00, 0x66, 0x00, 0x05, 0x00, 0x01, 0x00, 0x33, 0x00, 0x44, 0x00, 0x36, 0x00, 0x61, 0x87, // "f" (U+0066)
  0x00, 0x67, 0x00, 0x05, 0xFF, 0xEB, 0x00, 0x2E, 0x00, 0x31, 0x00, 0x36, 0x00, 0x62, 0xFE, // "g" (U+0067)
  0x00, 0x68, 0x00, 0x07, 0x00, 0x01, 0x00, 0x2F, 0x00, 0x44, 0x00, 0x36, 0x00, 0x65, 0x23, // "h" (U+0068)
  0x00, 0x69, 0x00, 0x07, 0x00, 0x01, 0x00, 0x30, 0x00, 0x44, 0x00, 0x36, 0x00, 0x66, 0xF7, // "i" (U+0069)
  0x00, 0x6A, 0x00, 0x05, 0xFF, 0xEB, 0x00, 0x24, 0x00, 0x44, 0x00, 0x36, 0x00, 0x68, 0x3B, // "j" (U+006A)
  0x00, 0x6B, 0x00, 0x09, 0x00, 0x01, 0x00, 0x32, 0x00, 0x44, 0x00, 0x36, 0x00, 0x69, 0xD2, // "k" (U+006B)
  0x00, 0x6C, 0x00, 0x07, 0x00, 0x01, 0x00, 0x30, 0x00, 0x44, 0x00, 0x36, 0x00, 0x6B, 0xB9, // "l" (U+006C)
  0x00, 0x6D, 0x00, 0x04, 0x00, 0x01, 0x00, 0x31, 0x00, 0x31, 0x00, 0x36, 0x00, 0x6D, 0x1E, // "m" (U+006D)
  0x00, 0x6E, 0x00, 0x07, 0x00, 0x01, 0x00, 0x2F, 0x00, 0x31, 0x00, 0x36, 0x00, 0x6F, 0x04, // "n" (U+006E)
  0x00, 0x6F, 0x00, 0x05, 0x00, 0x00, 0x00, 0x30, 0x00, 0x31, 0x00, 0x36, 0x00, 0x70, 0x79, // "o" (U+006F)
  0x00, 0x70, 0x00, 0x07, 0xFF, 0xEB, 0x00, 0x30, 0x00, 0x31, 0x00, 0x36, 0x00, 0x71, 0xFE, // "p" (U+0070)
  0x00, 0x71, 0x00, 0x05, 0xFF, 0xEB, 0x00, 0x2E, 0x00, 0x31, 0x00, 0x36, 0x00, 0x73, 0xFF, // "q" (U+0071)
  0x00, 0x72, 0x00, 0x05, 0x00, 0x01, 0x00, 0x33, 0x00, 0x31, 0x00, 0x36, 0x00, 0x76, 0x02, // "r" (U+0072)
  0x00, 0x73, 0x00, 0x09, 0x00, 0x00, 0x00, 0x2C, 0x00, 0x31, 0x00, 0x36, 0x00, 0x77, 0x37, // "s" (U+0073)
  0x00, 0x74, 0x00, 0x05, 0x00, 0x00, 0x00, 0x2E, 0x00, 0x3D, 0x00, 0x36, 0x00, 0x78, 0x7F, // "t" (U+0074)
  0x00, 0x75, 0x00, 0x06, 0x00, 0x00, 0x00, 0x2E, 0x00, 0x30, 0x00, 0x36, 0x00, 0x79, 0xD8, // "u" (U+0075)
  0x00, 0x76, 0x00, 0x04, 0x00, 0x01, 0x00, 0x31, 0x00, 0x30, 0x00, 0x36, 0x00, 0x7B, 0x4B, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x01, 0x00, 0x01, 0x00, 0x34, 0x00, 0x30, 0x00, 0x36, 0x00, 0x7C, 0xA5, // "w" (U+0077)
  0x00, 0x78, 0x00, 0x04, 0x00, 0x01, 0x00, 0x31, 0x00, 0x30, 0x00, 0x36, 0x00, 0x7E, 0x8E, // "x" (U+0078)
  0x00, 0x79, 0x00, 0x04, 0xFF, 0xEB, 0x00, 0x31, 0x00, 0x30, 0x00, 0x36, 0x00, 0x80, 0x12, // "y" (U+0079)
  0x00, 0x7A, 0x00, 0x08, 0x00, 0x01, 0x00, 0x2D, 0x00, 0x30, 0x00, 0x36, 0x00, 0x81, 0xED, // "z" (U+007A)
  0x00, 0x7B, 0x00, 0x0C, 0xFF, 0xF2, 0x00, 0x29, 0x00, 0x40, 0x00, 0x36, 0x00, 0x82, 0xE4, // "{" (U+007B)
  0x00, 0x7C, 0x00, 0x17, 0xFF, 0xEB, 0x00, 0x1E, 0x00, 0x44, 0x00, 0x36, 0x00, 0x84, 0x4F, // "|" (U+007C)
  0x00, 0x7D, 0x00, 0x0C, 0xFF, 0xF3, 0x00, 0x29, 0x00, 0x41, 0x00, 0x36, 0x00, 0x85, 0x30, // "}" (U+007D)
  0x00, 0x7E, 0x00, 0x06, 0x00, 0x1B, 0x00, 0x2F, 0x00, 0x2A, 0x00, 0x36, 0x00, 0x86, 0x9C, // "~" (U+007E)
  0x00, 0xA1, 0x00, 0x15, 0xFF, 0xF1, 0x00, 0x20, 0x00, 0x31, 0x00, 0x36, 0x00, 0x87, 0x33, // "¡" (U+00A1)
  0x00, 0xA2, 0x00, 0x08, 0x00, 0x00, 0x00, 0x2D, 0x00, 0x41, 0x00, 0x36, 0x00, 0x87, 0xF5, // "¢" (U+00A2)
  0x00, 0xA3, 0x00, 0x08, 0x00, 0x01, 0x00, 0x2F, 0x00, 0x41, 0x00, 0x36, 0x00, 0x89, 0x75, // "£" (U+00A3)
  0x00, 0xA4, 0x00, 0x06, 0x00, 0x0C, 0x00, 0x2F, 0x00, 0x35, 0x00, 0x36, 0x00, 0x8A, 0xD9, // "¤" (U+00A4)
  0x00, 0xA5, 0x00, 0x03, 0x00, 0x01, 0x00, 0x32, 0x00, 0x40, 0x00, 0x36, 0x00, 0x8C, 0x3F, // "¥" (U+00A5)
  0x00, 0xA6, 0x00, 0x17, 0xFF, 0xEB, 0x00, 0x1E, 0x00, 0x44, 0x00, 0x36, 0x00, 0x8D, 0xDE, // "¦" (U+00A6)
  0x00, 0xA7, 0x00, 0x09, 0x00, 0x00, 0x00, 0x2C, 0x00, 0x44, 0x00, 0x36, 0x00, 0x8E, 0x8B, // "§" (U+00A7)
  0x00, 0xA8, 0x00, 0x0B, 0x00, 0x39, 0x00, 0x2A, 0x00, 0x42, 0x00, 0x36, 0x00, 0x90, 0x63, // "¨" (U+00A8)
  0x00, 0xA9, 0x00, 0x04, 0x00, 0x0A, 0x00, 0x31, 0x00, 0x37, 0x00, 0x36, 0x00, 0x90, 0xB5, // "©" (U+00A9)
  0x00, 0xAA, 0x00, 0x0D, 0x00, 0x23, 0x00, 0x26, 0x00, 0x40, 0x00, 0x36, 0x00, 0x92, 0x8B, // "ª" (U+00AA)
  0x00, 0xAB, 0x00, 0x08, 0x00, 0x05, 0x00, 0x2D, 0x00, 0x2B, 0x00, 0x36, 0x00, 0x93, 0x4C, // "«" (U+00AB)
  0x00, 0xAC, 0x00, 0x06, 0x00, 0x0C, 0x00, 0x2E, 0x00, 0x23, 0x00, 0x36, 0x00, 0x94, 0x88, // "¬" (U+00AC)
  0x00, 0xAE, 0x00, 0x04, 0x00, 0x0A, 0x00, 0x31, 0x00, 0x37, 0x00, 0x36, 0x00, 0x94, 0xEC, // "®" (U+00AE)
  0x00, 0xAF, 0x00, 0x0D, 0x00, 0x38, 0x00, 0x28, 0x00, 0x3E, 0x00, 0x36, 0x00, 0x96, 0xE3, // "¯" (U+00AF)
  0x00, 0xB0, 0x00, 0x0D, 0x00, 0x27, 0x00, 0x28, 0x00, 0x41, 0x00, 0x36, 0x00, 0x97, 0x00, // "°" (U+00B0)
  0x00, 0xB1, 0x00, 0x06, 0x00, 0x01, 0x00, 0x2E, 0x00, 0x35, 0x00, 0x36, 0x00, 0x97, 0xB2, // "±" (U+00B1)
  0x00, 0xB2, 0x00, 0x0E, 0x00, 0x26, 0x00, 0x28, 0x00, 0x4D, 0x00, 0x36, 0x00, 0x98, 0xAA, // "²" (U+00B2)
  0x00, 0xB3, 0x00, 0x0E, 0x00, 0x26, 0x00, 0x27, 0x00, 0x4D, 0x00, 0x36, 0x00, 0x99, 0x7B, // "³" (U+00B3)
  0x00, 0xB4, 0x00, 0x16, 0x00, 0x37, 0x00, 0x28, 0x00, 0x45, 0x00, 0x36, 0x00, 0x9A, 0x53, // "´" (U+00B4)
  0x00, 0xB5, 0x00, 0x06, 0xFF, 0xEB, 0x00, 0x2E, 0x00, 0x30, 0x00, 0x36, 0x00, 0x9A, 0x93, // "µ" (U+00B5)
  0x00, 0xB6, 0x00, 0x04, 0xFF, 0xF5, 0x00, 0x30, 0x00, 0x44, 0x00, 0x36, 0x00, 0x9C, 0x6E, // "¶" (U+00B6)
  0x00, 0xB7, 0x00, 0x15, 0x00, 0x19, 0x00, 0x20, 0x00, 0x24, 0x00, 0x36, 0x00, 0x9E, 0xF2, // "·" (U+00B7)
  0x00, 0xB8, 0x00, 0x11, 0xFF, 0xEB, 0x00, 0x23, 0x00, 0x00, 0x00, 0x36, 0x00, 0x9F, 0x20, // "¸" (U+00B8)
  0x00, 0xB9, 0x00, 0x0D, 0x00, 0x26, 0x00, 0x28, 0x00, 0x4C, 0x00, 0x36, 0x00, 0x9F, 0x83, // "¹" (U+00B9)
  0x00, 0xBA, 0x00, 0x0D, 0x00, 0x23, 0x00, 0x28, 0x00, 0x40, 0x00, 0x36, 0x00, 0xA0, 0x41, // "º" (U+00BA)
  0x00, 0xBB, 0x00, 0x08, 0x00, 0x06, 0x00, 0x2D, 0x00, 0x2C, 0x00, 0x36, 0x00, 0xA1, 0x01, // "»" (U+00BB)
  0x00, 0xBC, 0x00, 0x00, 0x00, 0x01, 0x00, 0x33, 0x00, 0x40, 0x00, 0x36, 0x00, 0xA2, 0x3C, // "¼" (U+00BC)
  0x00, 0xBD, 0x00, 0x00, 0x00, 0x01, 0x00, 0x33, 0x00, 0x40, 0x00, 0x36, 0x00, 0xA4, 0x5F, // "½" (U+00BD)
  0x00, 0xBE, 0x00, 0x01, 0x00, 0x01, 0x00, 0x33, 0x00, 0x41, 0x00, 0x36, 0x00, 0xA6, 0x96, // "¾" (U+00BE)
  0x00, 0xBF, 0x00, 0x06, 0xFF, 0xF0, 0x00, 0x2B, 0x00, 0x31, 0x00, 0x36, 0x00, 0xA8, 0xD8, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x00, 0x01, 0x00, 0x34, 0x00, 0x55, 0x00, 0x36, 0x00, 0xAA, 0x2A, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x00, 0x01, 0x00, 0x34, 0x00, 0x55, 0x00, 0x36, 0x00, 0xAC, 0x56, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x01, 0x00, 0x01, 0x00, 0x34, 0x00, 0x55, 0x00, 0x36, 0x00, 0xAE, 0x81, // "Â" (U+00C2)
  0x00, 0xC3, 0x00, 0x01, 0x00, 0x01, 0x00, 0x34, 0x00, 0x52, 0x00, 0x36, 0x00, 0xB0, 0xC9, // "Ã" (U+00C3)
  0x00, 0xC4, 0x00, 0x01, 0x00, 0x01, 0x00, 0x34, 0x00, 0x52, 0x00, 0x36, 0x00, 0xB3, 0x11, // "Ä" (U+00C4)
  0x00, 0xC5, 0x00, 0x01, 0x00, 0x01, 0x00, 0x34, 0x00, 0x59, 0x00, 0x36, 0x00, 0xB5, 0x44, // "Å" (U+00C5)
  0x00, 0xC6, 0x00, 0x01, 0x00, 0x01, 0x00, 0x30, 0x00, 0x40, 0x00, 0x36, 0x00, 0xB7, 0xAF, // "Æ" (U+00C6)
  0x00, 0xC7, 0x00, 0x06, 0xFF, 0xEB, 0x00, 0x31, 0x00, 0x41, 0x00, 0x36, 0x00, 0xB9, 0x7B, // "Ç" (U+00C7)
  0x00, 0xC8, 0x00, 0x08, 0x00, 0x01, 0x00, 0x2E, 0x00, 0x55, 0x00, 0x36, 0x00, 0xBB, 0x98, // "È" (U+00C8)
  0x00, 0xC9, 0x00, 0x08, 0x00, 0x01, 0x00, 0x2E, 0x00, 0x55, 0x00, 0x36, 0x00, 0xBD, 0x2C, // "É" (U+00C9)
  0x00, 0xCA, 0x00, 0x08, 0x00, 0x01, 0x00, 0x2E, 0x00, 0x55, 0x00, 0x36, 0x00, 0xBE, 0xBA, // "Ê" (U+00CA)
  0x00, 0xCB, 0x00, 0x08, 0x00, 0x01, 0x00, 0x2E, 0x00, 0x52, 0x00, 0x36, 0x00, 0xC0, 0x60, // "Ë" (U+00CB)
  0x00, 0xCC, 0x00, 0x09, 0x00, 0x01, 0x00, 0x2C, 0x00, 0x55, 0x00, 0x36, 0x00, 0xC1, 0xF2, // "Ì" (U+00CC)
  0x00, 0xCD, 0x00, 0x09, 0x00, 0x01, 0x00, 0x2C, 0x00, 0x55, 0x00, 0x36, 0x00, 0xC3, 0x78, // "Í" (U+00CD)
  0x00, 0xCE, 0x00, 0x09, 0x00, 0x01, 0x00, 0x2C, 0x00, 0x55, 0x00, 0x36, 0x00, 0xC4, 0xFC, // "Î" (U+00CE)
  0x00, 0xCF, 0x00, 0x09, 0x00, 0x01, 0x00, 0x2C, 0x00, 0x52, 0x00, 0x36, 0x00, 0xC6, 0x97, // "Ï" (U+00CF)
  0x00, 0xD0, 0x00, 0x00, 0x00, 0x01, 0x00, 0x32, 0x00, 0x40, 0x00, 0x36, 0x00, 0xC8, 0x1F, // "Ð" (U+00D0)
  0x00, 0xD1, 0x00, 0x06, 0x00, 0x01, 0x00, 0x2F, 0x00, 0x52, 0x00, 0x36, 0x00, 0xCA, 0x29, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x00, 0x04, 0x00, 0x00, 0x00, 0x31, 0x00, 0x55, 0x00, 0x36, 0x00, 0xCC, 0x92, // "Ò" (U+00D2)
  0x00, 0xD3, 0x00, 0x04, 0x00, 0x00, 0x00, 0x31, 0x00, 0x55, 0x00, 0x36, 0x00, 0xCE, 0xEE, // "Ó" (U+00D3)
  0x00, 0xD4, 0x00, 0x04, 0x00, 0x00, 0x00, 0x31, 0x00, 0x55, 0x00, 0x36, 0x00, 0xD1, 0x49, // "Ô" (U+00D4)
  0x00, 0xD5, 0x00, 0x04, 0x00, 0x00, 0x00, 0x31, 0x00, 0x52, 0x00, 0x36, 0x00, 0xD3, 0xBE, // "Õ" (U+00D5)
  0x00, 0xD6, 0x00, 0x04, 0x00, 0x00, 0x00, 0x31, 0x00, 0x52, 0x00, 0x36, 0x00, 0xD6, 0x32, // "Ö" (U+00D6)
  0x00, 0xD7, 0x00, 0x07, 0x00, 0x0D, 0x00, 0x2E, 0x00, 0x33, 0x00, 0x36, 0x00, 0xD8, 0x91, // "×" (U+00D7)
  0x00, 0xD8, 0x00, 0x04, 0xFF, 0xFD, 0x00, 0x31, 0x00, 0x43, 0x00, 0x36, 0x00, 0xD9, 0xC0, // "Ø" (U+00D8)
  0x00, 0xD9, 0x00, 0x06, 0x00, 0x00, 0x00, 0x2F, 0x00, 0x55, 0x00, 0x36, 0x00, 0xDC, 0x34, // "Ù" (U+00D9)
  0x00, 0xDA, 0x00, 0x06, 0x00, 0x00, 0x00, 0x2F, 0x00, 0x55, 0x00, 0x36, 0x00, 0xDE, 0x54, // "Ú" (U+00DA)
  0x00, 0xDB, 0x00, 0x06, 0x00, 0x00, 0x00, 0x2F, 0x00, 0x55, 0x00, 0x36, 0x00, 0xE0, 0x72, // "Û" (U+00DB)
  0x00, 0xDC, 0x00, 0x06, 0x00, 0x00, 0x00, 0x2F, 0x00, 0x52, 0x00, 0x36, 0x00, 0xE2, 0xA7, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x03, 0x00, 0x01, 0x00, 0x32, 0x00, 0x55, 0x00, 0x36, 0x00, 0xE4, 0xC6, // "Ý" (U+00DD)
  0x00, 0xDE, 0x00, 0x08, 0x00, 0x01, 0x00, 0x30, 0x00, 0x40, 0x00, 0x36, 0x00, 0xE6, 0xC9, // "Þ" (U+00DE)
  0x00, 0xDF, 0x00, 0x06, 0x00, 0x00, 0x00, 0x33, 0x00, 0x44, 0x00, 0x36, 0x00, 0xE8, 0x60, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x06, 0x00, 0x00, 0x00, 0x2D, 0x00, 0x45, 0x00, 0x36, 0x00, 0xEA, 0x9C, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x06, 0x00, 0x00, 0x00, 0x2D, 0x00, 0x45, 0x00, 0x36, 0x00, 0xEC, 0x6A, // "á" (U+00E1)
  0x00, 0xE2, 0x00, 0x06, 0x00, 0x00, 0x00, 0x2D, 0x00, 0x45, 0x00, 0x36, 0x00, 0xEE, 0x35, // "â" (U+00E2)
  0x00, 0xE3, 0x00, 0x06, 0x00, 0x00, 0x00, 0x2D, 0x00, 0x42, 0x00, 0x36, 0x00, 0xF0, 0x16, // "ã" (U+00E3)
  0x00, 0xE4, 0x00, 0x06, 0x00, 0x00, 0x00, 0x2D, 0x00, 0x42, 0x00, 0x36, 0x00, 0xF1, 0xF6, // "ä" (U+00E4)
  0x00, 0xE5, 0x00, 0x06, 0x00, 0x00, 0x00, 0x2D, 0x00, 0x49, 0x00, 0x36, 0x00, 0xF3, 0xC3, // "å" (U+00E5)
  0x00, 0xE6, 0x00, 0x01, 0x00, 0x00, 0x00, 0x34, 0x00, 0x31, 0x00, 0x36, 0x00, 0xF5, 0xC2, // "æ" (U+00E6)
  0x00, 0xE7, 0x00, 0x07, 0xFF, 0xEB, 0x00, 0x2D, 0x00, 0x31, 0x00, 0x36, 0x00, 0xF7, 0x94, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x05, 0x00, 0x00, 0x00, 0x30, 0x00, 0x45, 0x00, 0x36, 0x00, 0xF9, 0x49, // "è" (U+00E8)
  0x00, 0xE9, 0x00, 0x05, 0x00, 0x00, 0x00, 0x30, 0x00, 0x45, 0x00, 0x36, 0x00, 0xFB, 0x02, // "é" (U+00E9)
  0x00, 0xEA, 0x00, 0x05, 0x00, 0x00, 0x00, 0x30, 0x00, 0x45, 0x00, 0x36, 0x00, 0xFC, 0xBA, // "ê" (U+00EA)
  0x00, 0xEB, 0x00, 0x05, 0x00, 0x00, 0x00, 0x30, 0x00, 0x42, 0x00, 0x36, 0x00, 0xFE, 0x8A, // "ë" (U+00EB)
  0x00, 0xEC, 0x00, 0x07, 0x00, 0x01, 0x00, 0x30, 0x00, 0x45, 0x00, 0x36, 0x01, 0x00, 0x44, // "ì" (U+00EC)
  0x00, 0xED, 0x00, 0x07, 0x00, 0x01, 0x00, 0x30, 0x00, 0x45, 0x00, 0x36, 0x01, 0x01, 0xA4, // "í" (U+00ED)
  0x00, 0xEE, 0x00, 0x07, 0x00, 0x01, 0x00, 0x30, 0x00, 0x45, 0x00, 0x36, 0x01, 0x03, 0x02, // "î" (U+00EE)
  0x00, 0xEF, 0x00, 0x07, 0x00, 0x01, 0x00, 0x30, 0x00, 0x42, 0x00, 0x36, 0x01, 0x04, 0x77, // "ï" (U+00EF)
  0x00, 0xF0, 0x00, 0x05, 0x00, 0x00, 0x00, 0x30, 0x00, 0x45, 0x00, 0x36, 0x01, 0x05, 0xD6, // "ð" (U+00F0)
  0x00, 0xF1, 0x00, 0x07, 0x00, 0x01, 0x00, 0x2F, 0x00, 0x42, 0x00, 0x36, 0x01, 0x07, 0xFA, // "ñ" (U+00F1)
  0x00, 0xF2, 0x00, 0x05, 0x00, 0x00, 0x00, 0x30, 0x00, 0x45, 0x00, 0x36, 0x01, 0x09, 0xDA, // "ò" (U+00F2)
  0x00, 0xF3, 0x00, 0x05, 0x00, 0x00, 0x00, 0x30, 0x00, 0x45, 0x00, 0x36, 0x01, 0x0B, 0xB8, // "ó" (U+00F3)
  0x00, 0xF4, 0x00, 0x05, 0x00, 0x00, 0x00, 0x30, 0x00, 0x45, 0x00, 0x36, 0x01, 0x0D, 0x94, // "ô" (U+00F4)
  0x00, 0xF5, 0x00, 0x05, 0x00, 0x00, 0x00, 0x30, 0x00, 0x42, 0x00, 0x36, 0x01, 0x0F, 0x89, // "õ" (U+00F5)
  0x00, 0xF6, 0x00, 0x05, 0x00, 0x00, 0x00, 0x30, 0x00, 0x42, 0x00, 0x36, 0x01, 0x11, 0x7B, // "ö" (U+00F6)
  0x00, 0xF7, 0x00, 0x07, 0x00, 0x0C, 0x00, 0x2E, 0x00, 0x35, 0x00, 0x36, 0x01, 0x13, 0x59, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x05, 0xFF, 0xFE, 0x00, 0x30, 0x00, 0x33, 0x00, 0x36, 0x01, 0x13, 0xF5, // "ø" (U+00F8)
  0x00, 0xF9, 0x00, 0x06, 0x00, 0x00, 0x00, 0x2E, 0x00, 0x45, 0x00, 0x36, 0x01, 0x15, 0xD1, // "ù" (U+00F9)
  0x00, 0xFA, 0x00, 0x06, 0x00, 0x00, 0x00, 0x2E, 0x00, 0x45, 0x00, 0x36, 0x01, 0x17, 0x9E, // "ú" (U+00FA)
  0x00, 0xFB, 0x00, 0x06, 0x00, 0x00, 0x00, 0x2E, 0x00, 0x45, 0x00, 0x36, 0x01, 0x19, 0x6A, // "û" (U+00FB)
  0x00, 0xFC, 0x00, 0x06, 0x00, 0x00, 0x00, 0x2E, 0x00, 0x42, 0x00, 0x36, 0x01, 0x1B, 0x4B, // "ü" (U+00FC)
  0x00, 0xFD, 0x00, 0x04, 0xFF, 0xEB, 0x00, 0x31, 0x00, 0x45, 0x00, 0x36, 0x01, 0x1D, 0x17, // "ý" (U+00FD)
  0x00, 0xFE, 0x00, 0x07, 0xFF, 0xEB, 0x00, 0x30, 0x00, 0x44, 0x00, 0x36, 0x01, 0x1F, 0x4B, // "þ" (U+00FE)
  0x00, 0xFF, 0x00, 0x04, 0xFF, 0xEB, 0x00, 0x31, 0x00, 0x42, 0x00, 0x36, 0x01, 0x21, 0xAA, // "ÿ" (U+00FF)
  0x01, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x34, 0x00, 0x4E, 0x00, 0x36, 0x01, 0x23, 0xE3, // "Ā" (U+0100)
  0x01, 0x01, 0x00, 0x06, 0x00, 0x00, 0x00, 0x2D, 0x00, 0x3E, 0x00, 0x36, 0x01, 0x25, 0xE1, // "ā" (U+0101)
  0x01, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00, 0x34, 0x00, 0x52, 0x00, 0x36, 0x01, 0x27, 0x7A, // "Ă" (U+0102)
  0x01, 0x03, 0x00, 0x06, 0x00, 0x00, 0x00, 0x2D, 0x00, 0x42, 0x00, 0x36, 0x01, 0x29, 0xB4, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0x01, 0xFF, 0xED, 0x00, 0x36, 0x00, 0x40, 0x00, 0x36, 0x01, 0x2B, 0x86, // "Ą" (U+0104)
  0x01, 0x05, 0x00, 0x06, 0xFF, 0xED, 0x00, 0x2F, 0x00, 0x31, 0x00, 0x36, 0x01, 0x2D, 0xD1, // "ą" (U+0105)
  0x01, 0x06, 0x00, 0x06, 0x00, 0x00, 0x00, 0x31, 0x00, 0x55, 0x00, 0x36, 0x01, 0x2F, 0xBD, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x07, 0x00, 0x00, 0x00, 0x2D, 0x00, 0x45, 0x00, 0x36, 0x01, 0x31, 0xB4, // "ć" (U+0107)
  0x01, 0x08, 0x00, 0x06, 0x00, 0x00, 0x00, 0x31, 0x00, 0x55, 0x00, 0x36, 0x01, 0x33, 0x42, // "Ĉ" (U+0108)
  0x01, 0x09, 0x00, 0x07, 0x00, 0x00, 0x00, 0x2D, 0x00, 0x45, 0x00, 0x36, 0x01, 0x35, 0x51, // "ĉ" (U+0109)
  0x01, 0x0A, 0x00, 0x06, 0x00, 0x00, 0x00, 0x31, 0x00, 0x54, 0x00, 0x36, 0x01, 0x36, 0xF7, // "Ċ" (U+010A)
  0x01, 0x0B, 0x00, 0x07, 0x00, 0x00, 0x00, 0x2D, 0x00, 0x44, 0x00, 0x36, 0x01, 0x38, 0xDA, // "ċ" (U+010B)
  0x01, 0x0C, 0x00, 0x06, 0x00, 0x00, 0x00, 0x31, 0x00, 0x55, 0x00, 0x36, 0x01, 0x3A, 0x56, // "Č" (U+010C)
  0x01, 0x0D, 0x00, 0x07, 0x00, 0x00, 0x00, 0x2D, 0x00, 0x45, 0x00, 0x36, 0x01, 0x3C, 0x66, // "č" (U+010D)
  0x01, 0x0E, 0x00, 0x06, 0x00, 0x01, 0x00, 0x31, 0x00, 0x55, 0x00, 0x36, 0x01, 0x3E, 0x0D, // "Ď" (U+010E)
  0x01, 0x0F, 0x00, 0x04, 0x00, 0x00, 0x00, 0x39, 0x00, 0x44, 0x00, 0x36, 0x01, 0x40, 0x64, // "ď" (U+010F)
  0x01, 0x10, 0x00, 0x00, 0x00, 0x01, 0x00, 0x32, 0x00, 0x40, 0x00, 0x36, 0x01, 0x42, 0xB0, // "Đ" (U+0110)
  0x01, 0x11, 0x00, 0x05, 0x00, 0x00, 0x00, 0x35, 0x00, 0x44, 0x00, 0x36, 0x01, 0x44, 0xBA, // "đ" (U+0111)
  0x01, 0x12, 0x00, 0x08, 0x00, 0x01, 0x00, 0x2E, 0x00, 0x4E, 0x00, 0x36, 0x01, 0x46, 0xCD, // "Ē" (U+0112)
  0x01, 0x13, 0x00, 0x05, 0x00, 0x00, 0x00, 0x30, 0x00, 0x3E, 0x00, 0x36, 0x01, 0x48, 0x2C, // "ē" (U+0113)
  0x01, 0x14, 0x00, 0x08, 0x00, 0x01, 0x00, 0x2E, 0x00, 0x52, 0x00, 0x36, 0x01, 0x49, 0xB4, // "Ĕ" (U+0114)
  0x01, 0x15, 0x00, 0x05, 0x00, 0x00, 0x00, 0x30, 0x00, 0x42, 0x00, 0x36, 0x01, 0x4B, 0x4B, // "ĕ" (U+0115)
  0x01, 0x16, 0x00, 0x08, 0x00, 0x01, 0x00, 0x2E, 0x00, 0x54, 0x00, 0x36, 0x01, 0x4D, 0x0D, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x05, 0x00, 0x00, 0x00, 0x30, 0x00, 0x44, 0x00, 0x36, 0x01, 0x4E, 0x89, // "ė" (U+0117)
  0x01, 0x18, 0x00, 0x08, 0xFF, 0xED, 0x00, 0x2E, 0x00, 0x40, 0x00, 0x36, 0x01, 0x50, 0x2D, // "Ę" (U+0118)
  0x01, 0x19, 0x00, 0x05, 0xFF, 0xED, 0x00, 0x30, 0x00, 0x31, 0x00, 0x36, 0x01, 0x51, 0xD6, // "ę" (U+0119)
  0x01, 0x1A, 0x00, 0x08, 0x00, 0x01, 0x00, 0x2E, 0x00, 0x55, 0x00, 0x36, 0x01, 0x53, 0xA4, // "Ě" (U+011A)
  0x01, 0x1B, 0x00, 0x05, 0x00, 0x00, 0x00, 0x30, 0x00, 0x45, 0x00, 0x36, 0x01, 0x55, 0x4B, // "ě" (U+011B)
  0x01, 0x1C, 0x00, 0x04, 0x00, 0x00, 0x00, 0x2F, 0x00, 0x55, 0x00, 0x36, 0x01, 0x57, 0x1C, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x00, 0x05, 0xFF, 0xEB, 0x00, 0x2E, 0x00, 0x45, 0x00, 0x36, 0x01, 0x59, 0x62, // "ĝ" (U+011D)
  0x01, 0x1E, 0x00, 0x04, 0x00, 0x00, 0x00, 0x2F, 0x00, 0x52, 0x00, 0x36, 0x01, 0x5B, 0xF5, // "Ğ" (U+011E)
  0x01, 0x1F, 0x00, 0x05, 0xFF, 0xEB, 0x00, 0x2E, 0x00, 0x42, 0x00, 0x36, 0x01, 0x5E, 0x2D, // "ğ" (U+011F)
  0x01, 0x20, 0x00, 0x04, 0x00, 0x00, 0x00, 0x2F, 0x00, 0x54, 0x00, 0x36, 0x01, 0x60, 0xB1, // "Ġ" (U+0120)
  0x01, 0x21, 0x00, 0x05, 0xFF, 0xEB, 0x00, 0x2E, 0x00, 0x44, 0x00, 0x36, 0x01, 0x62, 0xCB, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0x04, 0xFF, 0xED, 0x00, 0x2F, 0x00, 0x41, 0x00, 0x36, 0x01, 0x65, 0x34, // "Ģ" (U+0122)
  0x01, 0x23, 0x00, 0x05, 0xFF, 0xEB, 0x00, 0x2E, 0x00, 0x44, 0x00, 0x36, 0x01, 0x67, 0x51, // "ģ" (U+0123)
  0x01, 0x24, 0x00, 0x06, 0x00, 0x01, 0x00, 0x2F, 0x00, 0x55, 0x00, 0x36, 0x01, 0x69, 0xBE, // "Ĥ" (U+0124)
  0x01, 0x25, 0xFF, 0xFB, 0x00, 0x01, 0x00, 0x2F, 0x00, 0x59, 0x00, 0x36, 0x01, 0x6B, 0xBD, // "ĥ" (U+0125)
  0x01, 0x26, 0x00, 0x00, 0x00, 0x01, 0x00, 0x35, 0x00, 0x40, 0x00, 0x36, 0x01, 0x6E, 0x34, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x00, 0x00, 0x01, 0x00, 0x2F, 0x00, 0x44, 0x00, 0x36, 0x01, 0x6F, 0xF9, // "ħ" (U+0127)
  0x01, 0x28, 0x00, 0x09, 0x00, 0x01, 0x00, 0x2C, 0x00, 0x52, 0x00, 0x36, 0x01, 0x71, 0xE6, // "Ĩ" (U+0128)
  0x01, 0x29, 0x00, 0x07, 0x00, 0x01, 0x00, 0x30, 0x00, 0x42, 0x00, 0x36, 0x01, 0x73, 0x80, // "ĩ" (U+0129)
  0x01, 0x2A, 0x00, 0x09, 0x00, 0x01, 0x00, 0x2C, 0x00, 0x4E, 0x00, 0x36, 0x01, 0x74, 0xF2, // "Ī" (U+012A)
  0x01, 0x2B, 0x00, 0x07, 0x00, 0x01, 0x00, 0x30, 0x00, 0x3E, 0x00, 0x36, 0x01, 0x76, 0x4A, // "ī" (U+012B)
  0x01, 0x2C, 0x00, 0x09, 0x00, 0x01, 0x00, 0x2C, 0x00, 0x52, 0x00, 0x36, 0x01, 0x77, 0x75, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x00, 0x07, 0x00, 0x01, 0x00, 0x30, 0x00, 0x42, 0x00, 0x36, 0x01, 0x79, 0x04, // "ĭ" (U+012D)
  0x01, 0x2E, 0x00, 0x09, 0xFF, 0xED, 0x00, 0x2C, 0x00, 0x40, 0x00, 0x36, 0x01, 0x7A, 0x69, // "Į" (U+012E)
  0x01, 0x2F, 0x00, 0x07, 0xFF, 0xED, 0x00, 0x30, 0x00, 0x44, 0x00, 0x36, 0x01, 0x7C, 0x05, // "į" (U+012F)
  0x01, 0x30, 0x00, 0x09, 0x00, 0x01, 0x00, 0x2C, 0x00, 0x54, 0x00, 0x36, 0x01, 0x7D, 0xB9, // "İ" (U+0130)
  0x01, 0x31, 0x00, 0x07, 0x00, 0x01, 0x00, 0x30, 0x00, 0x30, 0x00, 0x36, 0x01, 0x7F, 0x2B, // "ı" (U+0131)
  0x01, 0x32, 0x00, 0x09, 0x00, 0x00, 0x00, 0x2C, 0x00, 0x40, 0x00, 0x36, 0x01, 0x80, 0x31, // "Ĳ" (U+0132)
  0x01, 0x33, 0x00, 0x09, 0xFF, 0xEB, 0x00, 0x2C, 0x00, 0x44, 0x00, 0x36, 0x01, 0x81, 0x8E, // "ĳ" (U+0133)
  0x01, 0x34, 0x00, 0x09, 0x00, 0x00, 0x00, 0x35, 0x00, 0x55, 0x00, 0x36, 0x01, 0x83, 0xB5, // "Ĵ" (U+0134)
  0x01, 0x35, 0x00, 0x05, 0xFF, 0xEB, 0x00, 0x2E, 0x00, 0x45, 0x00, 0x36, 0x01, 0x85, 0x89, // "ĵ" (U+0135)
  0x01, 0x36, 0x00, 0x06, 0xFF, 0xED, 0x00, 0x31, 0x00, 0x40, 0x00, 0x36, 0x01, 0x87, 0x7C, // "Ķ" (U+0136)
  0x01, 0x37, 0x00, 0x09, 0xFF, 0xED, 0x00, 0x32, 0x00, 0x44, 0x00, 0x36, 0x01, 0x89, 0xC7, // "ķ" (U+0137)
  0x01, 0x38, 0x00, 0x09, 0x00, 0x01, 0x00, 0x32, 0x00, 0x30, 0x00, 0x36, 0x01, 0x8B, 0xF6, // "ĸ" (U+0138)
  0x01, 0x39, 0x00, 0x0A, 0x00, 0x01, 0x00, 0x2E, 0x00, 0x55, 0x00, 0x36, 0x01, 0x8D, 0x79, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x00, 0x07, 0x00, 0x01, 0x00, 0x30, 0x00, 0x59, 0x00, 0x36, 0x01, 0x8E, 0xEB, // "ĺ" (U+013A)
  0x01, 0x3B, 0x00, 0x0A, 0xFF, 0xED, 0x00, 0x2E, 0x00, 0x40, 0x00, 0x36, 0x01, 0x90, 0xA9, // "Ļ" (U+013B)
  0x01, 0x3C, 0x00, 0x07, 0xFF, 0xED, 0x00, 0x30, 0x00, 0x44, 0x00, 0x36, 0x01, 0x92, 0x0F, // "ļ" (U+013C)
  0x01, 0x3D, 0x00, 0x0A, 0x00, 0x01, 0x00, 0x2E, 0x00, 0x40, 0x00, 0x36, 0x01, 0x93, 0xBD, // "Ľ" (U+013D)
  0x01, 0x3E, 0x00, 0x07, 0x00, 0x01, 0x00, 0x32, 0x00, 0x44, 0x00, 0x36, 0x01, 0x95, 0x00, // "ľ" (U+013E)
  0x01, 0x3F, 0x00, 0x0A, 0x00, 0x01, 0x00, 0x2E, 0x00, 0x40, 0x00, 0x36, 0x01, 0x96, 0x89, // "Ŀ" (U+013F)
  0x01, 0x40, 0x00, 0x07, 0x00, 0x01, 0x00, 0x3B, 0x00, 0x44, 0x00, 0x36, 0x01, 0x97, 0xCF, // "ŀ" (U+0140)
  0x01, 0x41, 0x00, 0x05, 0x00, 0x01, 0x00, 0x31, 0x00, 0x40, 0x00, 0x36, 0x01, 0x99, 0x6F, // "Ł" (U+0141)
  0x01, 0x42, 0x00, 0x07, 0x00, 0x01, 0x00, 0x30, 0x00, 0x44, 0x00, 0x36, 0x01, 0x9A, 0x98, // "ł" (U+0142)
  0x01, 0x43, 0x00, 0x06, 0x00, 0x01, 0x00, 0x2F, 0x00, 0x55, 0x00, 0x36, 0x01, 0x9C, 0x27, // "Ń" (U+0143)
  0x01, 0x44, 0x00, 0x07, 0x00, 0x01, 0x00, 0x2F, 0x00, 0x45, 0x00, 0x36, 0x01, 0x9E, 0x7D, // "ń" (U+0144)
  0x01, 0x45, 0x00, 0x06, 0xFF, 0xED, 0x00, 0x2F, 0x00, 0x40, 0x00, 0x36, 0x01, 0xA0, 0x49, // "Ņ" (U+0145)
  0x01, 0x46, 0x00, 0x07, 0xFF, 0xED, 0x00, 0x2F, 0x00, 0x31, 0x00, 0x36, 0x01, 0xA2, 0x8E, // "ņ" (U+0146)
  0x01, 0x47, 0x00, 0x06, 0x00, 0x01, 0x00, 0x2F, 0x00, 0x55, 0x00, 0x36, 0x01, 0xA4, 0x4B, // "Ň" (U+0147)
  0x01, 0x48, 0x00, 0x07, 0x00, 0x01, 0x00, 0x2F, 0x00, 0x45, 0x00, 0x36, 0x01, 0xA6, 0xB9, // "ň" (U+0148)
  0x01, 0x49, 0xFF, 0xFB, 0x00, 0x01, 0x00, 0x2F, 0x00, 0x40, 0x00, 0x36, 0x01, 0xA8, 0x9C, // "ŉ" (U+0149)
  0x01, 0x4A, 0x00, 0x06, 0xFF, 0xF0, 0x00, 0x2F, 0x00, 0x40, 0x00, 0x36, 0x01, 0xAA, 0x99, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x00, 0x07, 0xFF, 0xEB, 0x00, 0x2F, 0x00, 0x31, 0x00, 0x36, 0x01, 0xAC, 0xFC, // "ŋ" (U+014B)
  0x01, 0x4C, 0x00, 0x04, 0x00, 0x00, 0x00, 0x31, 0x00, 0x4E, 0x00, 0x36, 0x01, 0xAE, 0xEE, // "Ō" (U+014C)
  0x01, 0x4D, 0x00, 0x05, 0x00, 0x00, 0x00, 0x30, 0x00, 0x3E, 0x00, 0x36, 0x01, 0xB1, 0x19, // "ō" (U+014D)
  0x01, 0x4E, 0x00, 0x04, 0x00, 0x00, 0x00, 0x31, 0x00, 0x52, 0x00, 0x36, 0x01, 0xB2, 0xC6, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x00, 0x05, 0x00, 0x00, 0x00, 0x30, 0x00, 0x42, 0x00, 0x36, 0x01, 0xB5, 0x2B, // "ŏ" (U+014F)
  0x01, 0x50, 0x00, 0x04, 0x00, 0x00, 0x00, 0x31, 0x00, 0x54, 0x00, 0x36, 0x01, 0xB7, 0x11, // "Ő" (U+0150)
  0x01, 0x51, 0x00, 0x05, 0x00, 0x00, 0x00, 0x30, 0x00, 0x44, 0x00, 0x36, 0x01, 0xB9, 0x8E, // "ő" (U+0151)
  0x01, 0x52, 0x00, 0x03, 0x00, 0x00, 0x00, 0x33, 0x00, 0x41, 0x00, 0x36, 0x01, 0xBB, 0x8C, // "Œ" (U+0152)
  0x01, 0x53, 0x00, 0x02, 0x00, 0x00, 0x00, 0x34, 0x00, 0x31, 0x00, 0x36, 0x01, 0xBD, 0x84, // "œ" (U+0153)
  0x01, 0x54, 0x00, 0x08, 0x00, 0x01, 0x00, 0x32, 0x00, 0x55, 0x00, 0x36, 0x01, 0xBF, 0x6C, // "Ŕ" (U+0154)
  0x01, 0x55, 0x00, 0x05, 0x00, 0x01, 0x00, 0x33, 0x00, 0x45, 0x00, 0x36, 0x01, 0xC1, 0xA1, // "ŕ" (U+0155)
  0x01, 0x56, 0x00, 0x08, 0xFF, 0xED, 0x00, 0x32, 0x00, 0x40, 0x00, 0x36, 0x01, 0xC3, 0x2D, // "Ŗ" (U+0156)
  0x01, 0x57, 0x00, 0x05, 0xFF, 0xED, 0x00, 0x33, 0x00, 0x31, 0x00, 0x36, 0x01, 0xC5, 0x51, // "ŗ" (U+0157)
  0x01, 0x58, 0x00, 0x08, 0x00, 0x01, 0x00, 0x32, 0x00, 0x55, 0x00, 0x36, 0x01, 0xC6, 0xCE, // "Ř" (U+0158)
  0x01, 0x59, 0x00, 0x05, 0x00, 0x01, 0x00, 0x33, 0x00, 0x45, 0x00, 0x36, 0x01, 0xC9, 0x1B, // "ř" (U+0159)
  0x01, 0x5A, 0x00, 0x07, 0x00, 0x00, 0x00, 0x2F, 0x00, 0x55, 0x00, 0x36, 0x01, 0xCA, 0xC3, // "Ś" (U+015A)
  0x01, 0x5B, 0x00, 0x09, 0x00, 0x00, 0x00, 0x2C, 0x00, 0x45, 0x00, 0x36, 0x01, 0xCC, 0xCF, // "ś" (U+015B)
  0x01, 0x5C, 0x00, 0x07, 0x00, 0x00, 0x00, 0x2F, 0x00, 0x55, 0x00, 0x36, 0x01, 0xCE, 0x68, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x00, 0x09, 0x00, 0x00, 0x00, 0x2C, 0x00, 0x45, 0x00, 0x36, 0x01, 0xD0, 0x8A, // "ŝ" (U+015D)
  0x01, 0x5E, 0x00, 0x07, 0xFF, 0xEB, 0x00, 0x2F, 0x00, 0x41, 0x00, 0x36, 0x01, 0xD2, 0x3A, // "Ş" (U+015E)
  0x01, 0x5F, 0x00, 0x09, 0xFF, 0xEB, 0x00, 0x2C, 0x00, 0x31, 0x00, 0x36, 0x01, 0xD4, 0x6C, // "ş" (U+015F)
  0x01, 0x60, 0x00, 0x07, 0x00, 0x00, 0x00, 0x2F, 0x00, 0x55, 0x00, 0x36, 0x01, 0xD6, 0x2B, // "Š" (U+0160)
  0x01, 0x61, 0x00, 0x09, 0x00, 0x00, 0x00, 0x2C, 0x00, 0x45, 0x00, 0x36, 0x01, 0xD8, 0x4E, // "š" (U+0161)
  0x01, 0x62, 0x00, 0x04, 0xFF, 0xEB, 0x00, 0x31, 0x00, 0x40, 0x00, 0x36, 0x01, 0xD9, 0xFF, // "Ţ" (U+0162)
  0x01, 0x63, 0x00, 0x05, 0xFF, 0xEB, 0x00, 0x2E, 0x00, 0x3D, 0x00, 0x36, 0x01, 0xDB, 0x6A, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x04, 0x00, 0x01, 0x00, 0x31, 0x00, 0x55, 0x00, 0x36, 0x01, 0xDD, 0x40, // "Ť" (U+0164)
  0x01, 0x65, 0x00, 0x05, 0x00, 0x00, 0x00, 0x2E, 0x00, 0x45, 0x00, 0x36, 0x01, 0xDE, 0x99, // "ť" (U+0165)
  0x01, 0x66, 0x00, 0x04, 0x00, 0x01, 0x00, 0x31, 0x00, 0x40, 0x00, 0x36, 0x01, 0xE0, 0x2B, // "Ŧ" (U+0166)
  0x01, 0x67, 0x00, 0x05, 0x00, 0x00, 0x00, 0x2E, 0x00, 0x3D, 0x00, 0x36, 0x01, 0xE1, 0x22, // "ŧ" (U+0167)
  0x01, 0x68, 0x00, 0x06, 0x00, 0x00, 0x00, 0x2F, 0x00, 0x52, 0x00, 0x36, 0x01, 0xE2, 0x78, // "Ũ" (U+0168)
  0x01, 0x69, 0x00, 0x06, 0x00, 0x00, 0x00, 0x2E, 0x00, 0x42, 0x00, 0x36, 0x01, 0xE4, 0xAA, // "ũ" (U+0169)
  0x01, 0x6A, 0x00, 0x06, 0x00, 0x00, 0x00, 0x2F, 0x00, 0x4E, 0x00, 0x36, 0x01, 0xE6, 0x89, // "Ū" (U+016A)
  0x01, 0x6B, 0x00, 0x06, 0x00, 0x00, 0x00, 0x2E, 0x00, 0x3E, 0x00, 0x36, 0x01, 0xE8, 0x74, // "ū" (U+016B)
  0x01, 0x6C, 0x00, 0x06, 0x00, 0x00, 0x00, 0x2F, 0x00, 0x52, 0x00, 0x36, 0x01, 0xEA, 0x0D, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x00, 0x06, 0x00, 0x00, 0x00, 0x2E, 0x00, 0x42, 0x00, 0x36, 0x01, 0xEC, 0x32, // "ŭ" (U+016D)
  0x01, 0x6E, 0x00, 0x06, 0x00, 0x00, 0x00, 0x2F, 0x00, 0x59, 0x00, 0x36, 0x01, 0xEE, 0x04, // "Ů" (U+016E)
  0x01, 0x6F, 0x00, 0x06, 0x00, 0x00, 0x00, 0x2E, 0x00, 0x49, 0x00, 0x36, 0x01, 0xF0, 0x5B, // "ů" (U+016F)
  0x01, 0x70, 0x00, 0x06, 0x00, 0x00, 0x00, 0x2F, 0x00, 0x54, 0x00, 0x36, 0x01, 0xF2, 0x5B, // "Ű" (U+0170)
  0x01, 0x71, 0x00, 0x06, 0x00, 0x00, 0x00, 0x2E, 0x00, 0x44, 0x00, 0x36, 0x01, 0xF4, 0x9A, // "ű" (U+0171)
  0x01, 0x72, 0x00, 0x06, 0xFF, 0xED, 0x00, 0x2F, 0x00, 0x40, 0x00, 0x36, 0x01, 0xF6, 0x86, // "Ų" (U+0172)
  0x01, 0x73, 0x00, 0x06, 0xFF, 0xED, 0x00, 0x30, 0x00, 0x30, 0x00, 0x36, 0x01, 0xF8, 0xB1, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x02, 0x00, 0x01, 0x00, 0x33, 0x00, 0x55, 0x00, 0x36, 0x01, 0xFA, 0xA4, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x00, 0x01, 0x00, 0x34, 0x00, 0x45, 0x00, 0x36, 0x01, 0xFD, 0x90, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x03, 0x00, 0x01, 0x00, 0x32, 0x00, 0x55, 0x00, 0x36, 0x01, 0xFF, 0xF0, // "Ŷ" (U+0176)
  0x01, 0x77, 0x00, 0x04, 0xFF, 0xEB, 0x00, 0x31, 0x00, 0x45, 0x00, 0x36, 0x02, 0x02, 0x0E, // "ŷ" (U+0177)
  0x01, 0x78, 0x00, 0x03, 0x00, 0x01, 0x00, 0x32, 0x00, 0x52, 0x00, 0x36, 0x02, 0x04, 0x5C, // "Ÿ" (U+0178)
  0x01, 0x79, 0x00, 0x08, 0x00, 0x01, 0x00, 0x2D, 0x00, 0x55, 0x00, 0x36, 0x02, 0x06, 0x64, // "Ź" (U+0179)
  0x01, 0x7A, 0x00, 0x08, 0x00, 0x01, 0x00, 0x2D, 0x00, 0x45, 0x00, 0x36, 0x02, 0x07, 0xEB, // "ź" (U+017A)
  0x01, 0x7B, 0x00, 0x08, 0x00, 0x01, 0x00, 0x2D, 0x00, 0x54, 0x00, 0x36, 0x02, 0x09, 0x35, // "Ż" (U+017B)
  0x01, 0x7C, 0x00, 0x08, 0x00, 0x01, 0x00, 0x2D, 0x00, 0x44, 0x00, 0x36, 0x02, 0x0A, 0xAA, // "ż" (U+017C)
  0x01, 0x7D, 0x00, 0x08, 0x00, 0x01, 0x00, 0x2D, 0x00, 0x55, 0x00, 0x36, 0x02, 0x0B, 0xE2, // "Ž" (U+017D)
  0x01, 0x7E, 0x00, 0x08, 0x00, 0x01, 0x00, 0x2D, 0x00, 0x45, 0x00, 0x36, 0x02, 0x0D, 0x82, // "ž" (U+017E)
  0x01, 0x7F, 0x00, 0x13, 0x00, 0x01, 0x00, 0x31, 0x00, 0x44, 0x00, 0x36, 0x02, 0x0E, 0xE5, // "ſ" (U+017F)
  0x03, 0xA9, 0x00, 0x01, 0x00, 0x01, 0x00, 0x34, 0x00, 0x41, 0x00, 0x36, 0x02, 0x10, 0x2C, // "Ω" (U+03A9)
  0x03, 0xBC, 0x00, 0x06, 0xFF, 0xEB, 0x00, 0x2E, 0x00, 0x30, 0x00, 0x36, 0x02, 0x12, 0x3F, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x03, 0x00, 0x00, 0x00, 0x32, 0x00, 0x30, 0x00, 0x36, 0x02, 0x14, 0x1A, // "π" (U+03C0)
  0x20, 0x13, 0x00, 0x09, 0x00, 0x16, 0x00, 0x2C, 0x00, 0x1C, 0x00, 0x36, 0x02, 0x15, 0x64, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x00, 0x00, 0x16, 0x00, 0x35, 0x00, 0x1C, 0x00, 0x36, 0x02, 0x15, 0x67, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x03, 0x00, 0x00, 0x00, 0x33, 0x00, 0x41, 0x00, 0x36, 0x02, 0x15, 0x6A, // "€" (U+20AC)
  0x20, 0xBF, 0x00, 0x08, 0xFF, 0xF8, 0x00, 0x30, 0x00, 0x49, 0x00, 0x36, 0x02, 0x17, 0x12, // "₿" (U+20BF)
  0x20, 0x18, 0x00, 0x14, 0x00, 0x2B, 0x00, 0x21, 0x00, 0x40, 0x00, 0x36, 0x02, 0x19, 0x62, // "‘" (U+2018)
  0x20, 0x19, 0x00, 0x13, 0x00, 0x2B, 0x00, 0x21, 0x00, 0x40, 0x00, 0x36, 0x02, 0x19, 0xA7, // "’" (U+2019)
  0x20, 0x1A, 0x00, 0x13, 0xFF, 0xF4, 0x00, 0x22, 0x00, 0x0B, 0x00, 0x36, 0x02, 0x19, 0xEF, // "‚" (U+201A)
  0x20, 0x1B, 0x00, 0x14, 0x00, 0x2B, 0x00, 0x21, 0x00, 0x40, 0x00, 0x36, 0x02, 0x1A, 0x3F, // "‛" (U+201B)
  0x20, 0x1C, 0x00, 0x0C, 0x00, 0x2B, 0x00, 0x29, 0x00, 0x40, 0x00, 0x36, 0x02, 0x1A, 0x84, // "“" (U+201C)
  0x20, 0x1D, 0x00, 0x0C, 0x00, 0x2B, 0x00, 0x29, 0x00, 0x40, 0x00, 0x36, 0x02, 0x1B, 0x13, // "”" (U+201D)
  0x20, 0x1E, 0x00, 0x0C, 0xFF, 0xF4, 0x00, 0x2C, 0x00, 0x0B, 0x00, 0x36, 0x02, 0x1B, 0xA3, // "„" (U+201E)
  0x20, 0x1F, 0x00, 0x0C, 0x00, 0x2B, 0x00, 0x29, 0x00, 0x40, 0x00, 0x36, 0x02, 0x1C, 0x45, // "‟" (U+201F)
  0x20, 0x20, 0x00, 0x09, 0x00, 0x01, 0x00, 0x2C, 0x00, 0x44, 0x00, 0x36, 0x02, 0x1C, 0xD2, // "†" (U+2020)
  0x20, 0x21, 0x00, 0x09, 0x00, 0x01, 0x00, 0x2C, 0x00, 0x44, 0x00, 0x36, 0x02, 0x1E, 0x2E, // "‡" (U+2021)
  0x20, 0x22, 0x00, 0x11, 0x00, 0x17, 0x00, 0x24, 0x00, 0x2C, 0x00, 0x36, 0x02, 0x1F, 0xA5, // "•" (U+2022)
  0x20, 0x26, 0x00, 0x03, 0x00, 0x00, 0x00, 0x32, 0x00, 0x0B, 0x00, 0x36, 0x02, 0x20, 0x05, // "…" (U+2026)
  0x20, 0x30, 0x00, 0x01, 0x00, 0x00, 0x00, 0x34, 0x00, 0x41, 0x00, 0x36, 0x02, 0x20, 0x99, // "‰" (U+2030)
  0x20, 0x39, 0x00, 0x10, 0x00, 0x06, 0x00, 0x25, 0x00, 0x2B, 0x00, 0x36, 0x02, 0x23, 0x27, // "‹" (U+2039)
  0x20, 0x3A, 0x00, 0x10, 0x00, 0x08, 0x00, 0x25, 0x00, 0x2D, 0x00, 0x36, 0x02, 0x23, 0xC5, // "›" (U+203A)
  0x20, 0x44, 0xFF, 0xEF, 0x00, 0x01, 0x00, 0x10, 0x00, 0x40, 0x00, 0x00, 0x02, 0x24, 0x63, // "⁄" (U+2044)
  0x21, 0x22, 0xFF, 0xFF, 0x00, 0x21, 0x00, 0x35, 0x00, 0x40, 0x00, 0x36, 0x02, 0x25, 0x89, // "™" (U+2122)
  0x21, 0x52, 0x00, 0x16, 0x00, 0x01, 0x00, 0x8C, 0x00, 0x40, 0x00, 0xA2, 0x02, 0x27, 0x43, // "⅒" (U+2152)
  0x22, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00, 0x2F, 0x00, 0x41, 0x00, 0x36, 0x02, 0x2B, 0x46, // "∂" (U+2202)
  0x22, 0x06, 0x00, 0x01, 0x00, 0x01, 0x00, 0x34, 0x00, 0x40, 0x00, 0x36, 0x02, 0x2D, 0x46, // "∆" (U+2206)
  0x22, 0x1A, 0x00, 0x01, 0x00, 0x01, 0x00, 0x35, 0x00, 0x4B, 0x00, 0x36, 0x02, 0x2F, 0x12, // "√" (U+221A)
  0x22, 0x1E, 0x00, 0x00, 0x00, 0x13, 0x00, 0x35, 0x00, 0x2E, 0x00, 0x36, 0x02, 0x30, 0xE7, // "∞" (U+221E)
  0x22, 0x48, 0x00, 0x05, 0x00, 0x12, 0x00, 0x30, 0x00, 0x2F, 0x00, 0x36, 0x02, 0x32, 0x35, // "≈" (U+2248)
  0x22, 0x60, 0x00, 0x06, 0x00, 0x08, 0x00, 0x2F, 0x00, 0x39, 0x00, 0x36, 0x02, 0x33, 0x2F, // "≠" (U+2260)
  0x22, 0x64, 0x00, 0x05, 0x00, 0x01, 0x00, 0x30, 0x00, 0x37, 0x00, 0x36, 0x02, 0x34, 0x2B, // "≤" (U+2264)
  0x22, 0x65, 0x00, 0x05, 0x00, 0x01, 0x00, 0x30, 0x00, 0x37, 0x00, 0x36, 0x02, 0x35, 0x7E, // "≥" (U+2265)
  
  // Kerning pairs
  
  // Glyph data
  // "!" (U+0021)
  0x10, 0xDF, 0x90, 0xE2, 0x0C, 0xF9, 0x0E, 0x20, 0xCF, 0x90, 0xD2, 0x0B, 0xF9, 0x0D, 0x20, 0xBF,
  0x90, 0xC2, 0x0A, 0xF9, 0x0C, 0x20, 0xAF, 0x90, 0xB2, 0x09, 0xF9, 0x0B, 0x20, 0x9F, 0x90, 0xA2,
  0x08, 0xF9, 0x0A, 0x20, 0x8F, 0x90, 0x92, 0x07, 0xF9, 0x09, 0x20, 0x7F, 0x90, 0x82, 0x06, 0xF9,
  0x08, 0x20, 0x6F, 0x90, 0x72, 0x05, 0xF9, 0x07, 0x20, 0x5F, 0x90, 0x62, 0x04, 0xF9, 0x06, 0x20,
  0x4F, 0x90, 0x52, 0x03, 0xF9, 0x05, 0x20, 0x3F, 0x90, 0x42, 0x03, 0xF9, 0x04, 0x20, 0x2F, 0x90,
  0x32, 0x02, 0xF9, 0x03, 0x20, 0x1F, 0x90, 0x22, 0x01, 0xF9, 0x02, 0x3F, 0x90, 0x13, 0xF9, 0x01,
  0x3F, 0x94, 0x0E, 0xF4, 0x0E, 0xF4, 0x0D, 0xF4, 0x0D, 0xE0, 0xE4, 0x0C, 0xE0, 0xE4, 0x0C, 0xE0,
  0xD4, 0x0B, 0xE0, 0xD4, 0x0B, 0xE0, 0xC4, 0x0A, 0xE0, 0xC4, 0x0A, 0xE0, 0xB4, 0x09, 0xE0, 0xB4,
  0x09, 0xE0, 0xA4, 0x08, 0xE0, 0xA4, 0x08, 0xE0, 0x94, 0x07, 0xE0, 0x94, 0x07, 0xE0, 0x84, 0x06,
  0xE0, 0x88, 0x09, 0xA4, 0x08, 0x61, 0x8C, 0xEE, 0xC7, 0x13, 0x02, 0x0E, 0xE0, 0xE0, 0x22, 0x0D,
  0xF9, 0x81, 0xD0, 0x3F, 0xB0, 0x30, 0x7F, 0xB0, 0x70, 0x8F, 0xB0, 0x08, 0xFB, 0x08, 0x07, 0xFB,
  0x07, 0x03, 0xFB, 0x81, 0x30, 0xCF, 0x90, 0xC2, 0x02, 0x0D, 0xE0, 0xD0, 0x14, 0x84, 0x7C, 0xEE,
  0xC7, 0x30,
  // """ (U+0022)
  0x08, 0xF0, 0xE7, 0x10, 0xEF, 0x08, 0x07, 0xF0, 0xC7, 0x10, 0xDF, 0x07, 0x06, 0xF0, 0xB7, 0x10,
  0xBF, 0x06, 0x05, 0xF0, 0xA7, 0x10, 0xAF, 0x04, 0x03, 0xF0, 0x97, 0x10, 0x9F, 0x03, 0x02, 0xF0,
  0x87, 0x10, 0x8F, 0x02, 0x01, 0xF0, 0x67, 0x10, 0x7F, 0x01, 0x1F, 0x05, 0x71, 0x05, 0xF2, 0x0E,
  0xE0, 0x47, 0x10, 0x4E, 0x0E, 0x20, 0xDE, 0x03, 0x71, 0x03, 0xE0, 0xD2, 0x0C, 0xE0, 0x27, 0x10,
  0x2E, 0x0B, 0x20, 0xAE, 0x73, 0xE0, 0xA2, 0x09, 0xE7, 0x3E, 0x09, 0x20, 0x8D, 0x0D, 0x73, 0x0E,
  0xD0, 0x82, 0x07, 0xD0, 0xC7, 0x30, 0xCD, 0x07, 0x20, 0x6D, 0x0B, 0x73, 0x0B, 0xD0, 0x52, 0x04,
  0xD0, 0xA7, 0x30, 0xAD, 0x04, 0x20, 0x3D, 0x09, 0x73, 0x09, 0xD0, 0x32, 0x02, 0xD0, 0x77, 0x30,
  0x7D, 0x02, 0x20, 0x1D, 0x06, 0x73, 0x06, 0xD0, 0x13, 0xD0, 0x57, 0x30, 0x5D, 0x40, 0xEC, 0x04,
  0x73, 0x04, 0xC0, 0xE4, 0x0D, 0xC0, 0x37, 0x30, 0x3C, 0x0C, 0x20,
  // "#" (U+0023)
  0x77, 0x60, 0xDD, 0x09, 0x73, 0x03, 0xE7, 0x77, 0x7E, 0x06, 0x73, 0x06, 0xD0, 0xC7, 0x77, 0x60,
  0x3E, 0x03, 0x73, 0x09, 0xD0, 0x97, 0x77, 0x60, 0x7E, 0x74, 0x0C, 0xD0, 0x67, 0x77, 0x60, 0xAD,
  0x0D, 0x74, 0xE0, 0x37, 0x77, 0x60, 0xDD, 0x0A, 0x73, 0x03, 0xE7, 0x77, 0x7E, 0x07, 0x73, 0x06,
  0xD0, 0xC7, 0x77, 0x60, 0x3E, 0x04, 0x73, 0x09, 0xD0, 0x97, 0x77, 0x60, 0x6E, 0x01, 0x73, 0x0C,
  0xD0, 0x67, 0x77, 0x60, 0x9D, 0x0D, 0x74, 0x0E, 0xD0, 0x37, 0x77, 0x60, 0xCD, 0x0A, 0x73, 0x02,
  0xE7, 0x77, 0x7E, 0x07, 0x73, 0x05, 0xD0, 0xD7, 0x77, 0x60, 0x3E, 0x04, 0x73, 0x08, 0xD0, 0xA7,
  0x77, 0x60, 0x6E, 0x01, 0x73, 0x0B, 0xD0, 0x77, 0x77, 0x60, 0x9D, 0x0D, 0x74, 0x0E, 0xD0, 0x37,
  0x77, 0x60, 0xCD, 0x0A, 0x73, 0x02, 0xE0, 0x17, 0x77, 0x60, 0xED, 0x07, 0x73, 0x05, 0xD0, 0xD7,
  0x77, 0x60, 0x2E, 0x04, 0x73, 0x08, 0xD0, 0xA7, 0x71, 0x07, 0x80, 0x78, 0x0A, 0xE0, 0x98, 0x06,
  0x80, 0xDD, 0x0C, 0x80, 0x68, 0x01, 0x40, 0xD8, 0x0D, 0x2F, 0x03, 0x40, 0xD8, 0x0D, 0x2F, 0x03,
  0x40, 0xD8, 0x0D, 0x2F, 0x03, 0x40, 0xD8, 0x0D, 0x2F, 0x03, 0x40, 0xD8, 0x0D, 0x2F, 0x03, 0x40,
  0xD8, 0x0D, 0x2F, 0x03, 0x77, 0x10, 0x8D, 0x0B, 0x73, 0x02, 0xE0, 0x37, 0x77, 0x60, 0xBD, 0x08,
  0x73, 0x05, 0xE7, 0x77, 0x70, 0xED, 0x05, 0x73, 0x08, 0xD0, 0xC7, 0x77, 0x60, 0x2E, 0x02, 0x73,
  0x0B, 0xD0, 0x97, 0x77, 0x60, 0x5D, 0x0E, 0x74, 0x0E, 0xD0, 0x67, 0x77, 0x60, 0x8D, 0x0B, 0x73,
  0x02, 0xE0, 0x37, 0x77, 0x60, 0xCD, 0x08, 0x73, 0x05, 0xE7, 0x77, 0x70, 0xED, 0x05, 0x73, 0x08,
  0xD0, 0xC7, 0x77, 0x60, 0x2E, 0x02, 0x73, 0x0B, 0xD0, 0x97, 0x77, 0x60, 0x6D, 0x0E, 0x74, 0x0E,
  0xD0, 0x67, 0x77, 0x60, 0x9D, 0x0B, 0x73, 0x02, 0xE0, 0x37, 0x77, 0x60, 0xCD, 0x08, 0x73, 0x05,
  0xE7, 0x77, 0x7E, 0x05, 0x73, 0x08, 0xD0, 0xC7, 0x77, 0x60, 0x3E, 0x02, 0x73, 0x0B, 0xD0, 0x97,
  0x71, 0x03, 0x80, 0xD3, 0xF0, 0x23, 0x03, 0x80, 0xD3, 0xF0, 0x23, 0x03, 0x80, 0xD3, 0xF0, 0x23,
  0x03, 0x80, 0xD3, 0xF0, 0x23, 0x03, 0x80, 0xD3, 0xF0, 0x23, 0x03, 0x80, 0xD3, 0xF0, 0x23, 0x01,
  0x80, 0x68, 0x0C, 0xD0, 0xE8, 0x06, 0x80, 0x9E, 0x0A, 0x80, 0x90, 0x80, 0x17, 0x70, 0xAD, 0x0B,
  0x73, 0x03, 0xE0, 0x27, 0x77, 0x60, 0xDD, 0x08, 0x73, 0x06, 0xD0, 0xE7, 0x77, 0x7E, 0x05, 0x73,
  0x09, 0xD0, 0xB7, 0x77, 0x60, 0x3E, 0x02, 0x73, 0x0C, 0xD0, 0x87, 0x77, 0x60, 0x6D, 0x0E, 0x74,
  0xE0, 0x57, 0x77, 0x60, 0x9D, 0x0B, 0x73, 0x03, 0xE0, 0x27, 0x77, 0x60, 0xCD, 0x09, 0x73, 0x06,
  0xD0, 0xE7, 0x77, 0x70, 0xED, 0x06, 0x73, 0x09, 0xD0, 0xB7, 0x77, 0x60, 0x2E, 0x03, 0x73, 0x0C,
  0xD0, 0x87, 0x77, 0x60, 0x5E, 0x74, 0xE0, 0x57, 0x77, 0x60, 0x8D, 0x0C, 0x73, 0x03, 0xE0, 0x27,
  0x77, 0x60, 0xAD, 0x09, 0x73, 0x06, 0xD0, 0xE7, 0x77, 0x70, 0xDD, 0x06, 0x73, 0x09, 0xD0, 0xB7,
  0x77, 0x60, 0x1E, 0x03, 0x73, 0x0C, 0xD0, 0x87, 0x77, 0x60, 0x4E, 0x74, 0xE0, 0x57, 0x77, 0x60,
  0x6D, 0x0D, 0x73, 0x03, 0xE0, 0x27, 0x77, 0x60, 0x9D, 0x0A, 0x73, 0x06, 0xD0, 0xE7, 0x77, 0x70,
  0xCD, 0x07, 0x73, 0x09, 0xD0, 0xB7, 0x76,
  // "$" (U+0024)
  0x77, 0x20, 0x5D, 0x06, 0x77, 0x77, 0x50, 0x5D, 0x06, 0x77, 0x77, 0x50, 0x5D, 0x06, 0x77, 0x77,
  0x50, 0x5D, 0x06, 0x77, 0x77, 0x50, 0x5D, 0x06, 0x77, 0x77, 0x50, 0x5D, 0x06, 0x77, 0x77, 0x38,
  0x12, 0x49, 0xD8, 0x3A, 0x65, 0x43, 0x77, 0x72, 0x81, 0x27, 0xBF, 0xF9, 0x82, 0xD9, 0x61, 0x77,
  0x20, 0x50, 0xCF, 0xFF, 0x98, 0x1B, 0x61, 0x74, 0x03, 0x0C, 0xFF, 0xFE, 0x09, 0x03, 0x71, 0x06,
  0xFF, 0xFF, 0xB0, 0x36, 0x09, 0xFF, 0xFF, 0xB0, 0xD6, 0x09, 0xFF, 0xFF, 0xC0, 0x75, 0x05, 0xFD,
  0x0E, 0x0D, 0xD8, 0x1C, 0xCE, 0xFC, 0x02, 0x50, 0xEF, 0xA8, 0x3C, 0x62, 0x05, 0xD0, 0x63, 0x82,
  0x37, 0xAE, 0xD0, 0xB5, 0x07, 0xF9, 0x0E, 0x04, 0x40, 0x5D, 0x06, 0x78, 0x13, 0x8D, 0xA0, 0x65,
  0x0D, 0xF0, 0xE0, 0x25, 0x05, 0xD0, 0x67, 0x38, 0x13, 0x91, 0x40, 0x3F, 0x90, 0x46, 0x05, 0xD0,
  0x67, 0x73, 0x06, 0xF0, 0xB7, 0x05, 0xD0, 0x67, 0x73, 0x09, 0xF0, 0x57, 0x05, 0xD0, 0x67, 0x73,
  0x0B, 0xF0, 0x17, 0x05, 0xD0, 0x67, 0x73, 0x0C, 0xF7, 0x10, 0x5D, 0x06, 0x77, 0x30, 0xCE, 0x0E,
  0x71, 0x05, 0xD0, 0x67, 0x73, 0x0B, 0xF7, 0x10, 0x5D, 0x06, 0x77, 0x30, 0xAF, 0x03, 0x70, 0x5D,
  0x06, 0x77, 0x30, 0x7F, 0x07, 0x70, 0x5D, 0x06, 0x77, 0x30, 0x4F, 0x0E, 0x01, 0x60, 0x5D, 0x06,
  0x77, 0x40, 0xEF, 0x0A, 0x60, 0x5D, 0x06, 0x77, 0x40, 0x9F, 0x90, 0xB0, 0x14, 0x05, 0xD0, 0x67,
  0x74, 0x02, 0xFA, 0x81, 0xE7, 0x12, 0x05, 0xD0, 0x67, 0x75, 0x08, 0xFC, 0x81, 0xA5, 0x5D, 0x06,
  0x77, 0x60, 0xBF, 0xFC, 0x06, 0x77, 0x70, 0xBF, 0xFB, 0x06, 0x77, 0x71, 0x09, 0xFF, 0xA8, 0x1E,
  0xA5, 0x77, 0x70, 0x50, 0xEF, 0xFB, 0x81, 0xEA, 0x47, 0x76, 0x08, 0xFF, 0xD8, 0x1E, 0x81, 0x77,
  0x48, 0x12, 0x9E, 0xFF, 0xD0, 0xA0, 0x27, 0x74, 0x81, 0x17, 0xDF, 0xFD, 0x08, 0x77, 0x68, 0x13,
  0x9E, 0xFF, 0xB0, 0xD0, 0x37, 0x76, 0x05, 0xFF, 0xC0, 0xE0, 0x37, 0x75, 0x05, 0xFF, 0xD0, 0xE0,
  0x27, 0x74, 0x05, 0xD8, 0x27, 0x38, 0xDF, 0xC0, 0xC7, 0x74, 0x05, 0xD0, 0x63, 0x03, 0x09, 0xFB,
  0x06, 0x77, 0x30, 0x5D, 0x06, 0x50, 0x20, 0xBF, 0x90, 0xD7, 0x73, 0x05, 0xD0, 0x67, 0x09, 0xF9,
  0x02, 0x77, 0x20, 0x5D, 0x06, 0x71, 0x0D, 0xF0, 0x67, 0x72, 0x05, 0xD0, 0x67, 0x10, 0x6F, 0x09,
  0x77, 0x20, 0x5D, 0x06, 0x71, 0x01, 0xF0, 0xA7, 0x72, 0x05, 0xD0, 0x67, 0x2F, 0x0B, 0x77, 0x20,
  0x5D, 0x06, 0x72, 0x0E, 0xE0, 0xC7, 0x72, 0x05, 0xD0, 0x67, 0x2F, 0x0B, 0x77, 0x20, 0x5D, 0x06,
  0x71, 0x03, 0xF0, 0x97, 0x72, 0x05, 0xD0, 0x67, 0x10, 0x8F, 0x06, 0x77, 0x20, 0x5D, 0x06, 0x70,
  0x10, 0xEF, 0x02, 0x77, 0x20, 0x5D, 0x06, 0x70, 0xAF, 0x0C, 0x28, 0x1D, 0x82, 0x75, 0x05, 0xD0,
  0x66, 0x0A, 0xF9, 0x05, 0x20, 0xEA, 0x81, 0xC7, 0x27, 0x20, 0x5D, 0x06, 0x40, 0x50, 0xDF, 0x90,
  0xC3, 0x0E, 0xD8, 0x2D, 0x95, 0x25, 0x05, 0xD8, 0x36, 0x24, 0x9D, 0xFA, 0x0E, 0x02, 0x30, 0xEF,
  0xB8, 0x3C, 0xB9, 0x9A, 0xFF, 0xD0, 0x54, 0x0E, 0xFF, 0xFF, 0xD0, 0x55, 0x0E, 0xFF, 0xFF, 0xB0,
  0xD0, 0x36, 0x0E, 0xFF, 0xFF, 0xA0, 0x97, 0x10, 0x60, 0xDF, 0xFF, 0xE0, 0x90, 0x17, 0x48, 0x22,
  0x7B, 0xEF, 0xFD, 0x81, 0xEA, 0x57, 0x74, 0x87, 0x25, 0x79, 0xBC, 0xDE, 0xEE, 0x82, 0xC8, 0x52,
  0x77, 0x77, 0x20, 0x5D, 0x06, 0x77, 0x77, 0x50, 0x5D, 0x06, 0x77, 0x77, 0x50, 0x5D, 0x06, 0x77,
  0x77, 0x50, 0x5D, 0x06, 0x77, 0x77, 0x50, 0x5D, 0x06, 0x77, 0x77, 0x50, 0x5D, 0x06, 0x77, 0x77,
  0x50, 0x5D, 0x06, 0x77, 0x77, 0x50, 0x5D, 0x06, 0x77, 0x77, 0x50, 0x28, 0x01, 0x70, 0x37, 0x73,
  // "%" (U+0025)
  0x71, 0x89, 0x04, 0x8C, 0xDE, 0xED, 0xB7, 0x28, 0x0C, 0x60, 0x05, 0x0D, 0xFB, 0x0A, 0x02, 0x77,
  0x50, 0xBE, 0x02, 0x74, 0x01, 0x0C, 0xFF, 0x06, 0x77, 0x30, 0x3E, 0x0A, 0x74, 0x01, 0x0D, 0xFF,
  0xA0, 0x77, 0x72, 0x0B, 0xE0, 0x27, 0x40, 0xCF, 0xFC, 0x06, 0x77, 0x03, 0xE0, 0xA7, 0x40, 0x8E,
  0x85, 0xE7, 0x20, 0x13, 0x9F, 0x02, 0x76, 0x0B, 0xE0, 0x27, 0x30, 0x2E, 0x0D, 0x02, 0x60, 0x5E,
  0x0C, 0x75, 0x03, 0xE0, 0xA7, 0x40, 0x8E, 0x03, 0x71, 0x08, 0xE0, 0x37, 0x40, 0xBE, 0x02, 0x74,
  0x0E, 0xD0, 0xA7, 0x20, 0x10, 0xED, 0x0A, 0x73, 0x03, 0xE0, 0xA7, 0x40, 0x4E, 0x05, 0x73, 0x0A,
  0xD0, 0xE7, 0x30, 0xBE, 0x02, 0x74, 0x07, 0xE0, 0x17, 0x30, 0x6E, 0x02, 0x71, 0x03, 0xE0, 0xA7,
  0x50, 0xAD, 0x0E, 0x74, 0x04, 0xE0, 0x67, 0x10, 0xBE, 0x02, 0x75, 0x0C, 0xD0, 0xC7, 0x40, 0x2E,
  0x08, 0x70, 0x3E, 0x0A, 0x76, 0x0D, 0xD0, 0xB7, 0x40, 0x1E, 0x09, 0x70, 0xBE, 0x02, 0x76, 0x0E,
  0xD0, 0xA7, 0x5E, 0x0A, 0x60, 0x3E, 0x0A, 0x77, 0xE0, 0xA7, 0x5E, 0x0B, 0x60, 0xBE, 0x02, 0x77,
  0x0E, 0xD0, 0xA7, 0x5E, 0x0A, 0x50, 0x3E, 0x0A, 0x77, 0x10, 0xDD, 0x0B, 0x74, 0x01, 0xE0, 0x95,
  0x0B, 0xE0, 0x27, 0x71, 0x0C, 0xD0, 0xC7, 0x40, 0x2E, 0x08, 0x40, 0x3E, 0x0A, 0x77, 0x20, 0xAD,
  0x0E, 0x74, 0x04, 0xE0, 0x64, 0x0B, 0xE0, 0x27, 0x72, 0x06, 0xE0, 0x27, 0x30, 0x7E, 0x02, 0x30,
  0x3E, 0x0A, 0x77, 0x30, 0x3E, 0x06, 0x73, 0x0B, 0xD0, 0xE4, 0x0B, 0xE0, 0x27, 0x74, 0x0D, 0xD0,
  0xC7, 0x20, 0x1E, 0x0A, 0x30, 0x3E, 0x0A, 0x77, 0x50, 0x7E, 0x04, 0x71, 0x09, 0xE0, 0x33, 0x0B,
  0xE0, 0x27, 0x75, 0x01, 0x0E, 0xD0, 0xE0, 0x26, 0x06, 0xE0, 0xC3, 0x03, 0xE0, 0xA7, 0x77, 0x05,
  0xE8, 0x5E, 0x82, 0x01, 0x3A, 0xF0, 0x33, 0x0B, 0xE0, 0x27, 0x77, 0x10, 0xAF, 0xFC, 0x08, 0x30,
  0x3E, 0x0A, 0x77, 0x73, 0x0B, 0xFF, 0xA0, 0xA4, 0x0B, 0xE0, 0x27, 0x77, 0x40, 0x9F, 0xF0, 0x84,
  0x04, 0xE0, 0xA7, 0x77, 0x60, 0x40, 0xDF, 0xB0, 0xC0, 0x35, 0x0B, 0xE0, 0x27, 0x77, 0x71, 0x82,
  0x49, 0xCE, 0xA8, 0x2D, 0xB8, 0x36, 0x04, 0xE0, 0xA8, 0x0D, 0x20, 0x0B, 0xE0, 0x28, 0x0D, 0x10,
  0x04, 0xE0, 0xA8, 0x0D, 0x20, 0x0B, 0xE0, 0x28, 0x0D, 0x10, 0x04, 0xE0, 0xA8, 0x0D, 0x20, 0x0B,
  0xE0, 0x28, 0x0D, 0x10, 0x04, 0xE0, 0xA7, 0x89, 0x03, 0x7B, 0xDE, 0xFD, 0xC8, 0x37, 0x77, 0x71,
  0x0B, 0xE0, 0x25, 0x04, 0x0C, 0xFB, 0x0D, 0x04, 0x77, 0x75, 0x04, 0xE0, 0xA5, 0x0A, 0xFF, 0x0A,
  0x77, 0x74, 0x0B, 0xE0, 0x23, 0x01, 0x0B, 0xFF, 0xA0, 0xC0, 0x17, 0x77, 0x10, 0x4E, 0x0A, 0x40,
  0xBF, 0xFC, 0x0C, 0x77, 0x71, 0x0B, 0xE0, 0x23, 0x06, 0xF8, 0x59, 0x31, 0x02, 0x7E, 0xE0, 0x87,
  0x76, 0x04, 0xE0, 0xA4, 0x0E, 0xD0, 0xE0, 0x36, 0x01, 0x0D, 0xE0, 0x27, 0x75, 0x0B, 0xE0, 0x23,
  0x06, 0xE0, 0x67, 0x10, 0x3E, 0x09, 0x77, 0x40, 0x4E, 0x0A, 0x40, 0xCD, 0x0D, 0x73, 0x0A, 0xD0,
  0xE7, 0x74, 0x0B, 0xE0, 0x23, 0x01, 0xE0, 0x87, 0x30, 0x5E, 0x04, 0x77, 0x20, 0x4E, 0x0A, 0x40,
  0x4E, 0x04, 0x73, 0x01, 0xE0, 0x87, 0x72, 0x0B, 0xE0, 0x24, 0x07, 0xE0, 0x27, 0x4E, 0x0B, 0x77,
  0x10, 0x4E, 0x0A, 0x50, 0x9E, 0x75, 0x0D, 0xD0, 0xC7, 0x71, 0x0B, 0xE0, 0x25, 0x0A, 0xE7, 0x50,
  0xCD, 0x0D, 0x77, 0x04, 0xE0, 0xA6, 0x0A, 0xD0, 0xE7, 0x50, 0xBE, 0x77, 0x0B, 0xE0, 0x26, 0x0A,
  0xD0, 0xE7, 0x50, 0xCD, 0x0E, 0x76, 0x04, 0xE0, 0xA7, 0x09, 0xE7, 0x50, 0xCD, 0x0D, 0x76, 0x0B,
  0xE0, 0x27, 0x08, 0xE7, 0x50, 0xDD, 0x0C, 0x75, 0x04, 0xE0, 0xA7, 0x10, 0x7E, 0x02, 0x74, 0xE0,
  0xB7, 0x50, 0xCE, 0x02, 0x71, 0x03, 0xE0, 0x57, 0x30, 0x2E, 0x08, 0x74, 0x04, 0xE0, 0xA7, 0x3E,
  0x09, 0x73, 0x06, 0xE0, 0x47, 0x40, 0xCE, 0x02, 0x73, 0x0B, 0xD0, 0xE7, 0x30, 0xBE, 0x01, 0x73,
  0x04, 0xE0, 0xA7, 0x40, 0x4E, 0x07, 0x71, 0x04, 0xE0, 0x97, 0x40, 0xCE, 0x02, 0x75, 0x0D, 0xE0,
  0x46, 0x02, 0x0E, 0xE0, 0x27, 0x30, 0x4E, 0x0A, 0x76, 0x03, 0xF8, 0x59, 0x31, 0x02, 0x7E, 0xE0,
  0x97, 0x40, 0xCE, 0x02, 0x77, 0x07, 0xFF, 0xC0, 0xD7, 0x40, 0x4E, 0x0A, 0x77, 0x20, 0x9F, 0xFA,
  0x0D, 0x02, 0x74, 0x0C, 0xE0, 0x27, 0x73, 0x07, 0xFF, 0x0C, 0x01, 0x74, 0x04, 0xE0, 0xA7, 0x75,
  0x02, 0x0B, 0xFB, 0x0D, 0x06, 0x80, 0xC6, 0x08, 0x90, 0x27, 0xBD, 0xEE, 0xDC, 0x84, 0x71,
  // "&" (U+0026)
  0x77, 0x89, 0x14, 0x8B, 0xDE, 0xFE, 0xDB, 0x73, 0x80, 0xC0, 0x00, 0x60, 0xEF, 0xC0, 0xC0, 0x57,
  0x77, 0x74, 0x02, 0x0D, 0xFF, 0x90, 0xB0, 0x17, 0x77, 0x71, 0x04, 0x0E, 0xFF, 0xB0, 0xD0, 0x27,
  0x77, 0x60, 0x30, 0xEF, 0xFD, 0x0D, 0x01, 0x77, 0x75, 0x0D, 0xFF, 0xF0, 0xB7, 0x77, 0x40, 0x7F,
  0xA8, 0x3D, 0x98, 0xAD, 0xFA, 0x04, 0x77, 0x73, 0x0E, 0xF0, 0xD0, 0x35, 0x04, 0x0D, 0xF0, 0xC7,
  0x77, 0x20, 0x5F, 0x0D, 0x01, 0x70, 0x10, 0xDF, 0x02, 0x77, 0x71, 0x09, 0xF0, 0x37, 0x20, 0x4F,
  0x06, 0x77, 0x71, 0x0D, 0xE0, 0xC7, 0x40, 0xCE, 0x0A, 0x77, 0x71, 0x0E, 0xE0, 0x87, 0x40, 0x8E,
  0x0B, 0x77, 0x71, 0xF0, 0x57, 0x40, 0x6E, 0x0D, 0x77, 0x70, 0x1F, 0x04, 0x74, 0x06, 0xE0, 0xD7,
  0x77, 0x1F, 0x05, 0x74, 0x07, 0xE0, 0xC7, 0x77, 0x1F, 0x06, 0x74, 0x09, 0xE0, 0xB7, 0x77, 0x10,
  0xCE, 0x08, 0x74, 0x0C, 0xE0, 0x87, 0x77, 0x10, 0xAE, 0x0B, 0x73, 0x01, 0xF0, 0x57, 0x77, 0x10,
  0x6F, 0x73, 0x08, 0xF7, 0x77, 0x20, 0x2F, 0x05, 0x71, 0x02, 0xF0, 0x97, 0x77, 0x30, 0xCE, 0x0B,
  0x71, 0x0C, 0xF0, 0x27, 0x77, 0x30, 0x6F, 0x03, 0x60, 0xAF, 0x09, 0x77, 0x75, 0x0E, 0xE0, 0xA5,
  0x08, 0xF0, 0xE0, 0x17, 0x77, 0x50, 0x7F, 0x02, 0x30, 0x7F, 0x90, 0x57, 0x77, 0x70, 0xEE, 0x0B,
  0x20, 0x8F, 0x90, 0x87, 0x77, 0x71, 0x07, 0xF0, 0x60, 0xAF, 0x90, 0xA7, 0x77, 0x73, 0x0D, 0xFF,
  0x90, 0xC7, 0x77, 0x74, 0x04, 0xFF, 0x0B, 0x77, 0x77, 0x60, 0xAF, 0xD0, 0xB7, 0x77, 0x77, 0x01,
  0x0E, 0xFB, 0x0A, 0x80, 0xC0, 0x00, 0x50, 0xEF, 0xA0, 0x88, 0x0C, 0x00, 0x07, 0xFB, 0x0E, 0x01,
  0x77, 0x77, 0x70, 0xAF, 0xD0, 0xC7, 0x77, 0x76, 0x0B, 0xFF, 0x09, 0x77, 0x77, 0x30, 0x10, 0xCF,
  0xFA, 0x06, 0x76, 0x05, 0xF0, 0x17, 0x10, 0xCF, 0xA0, 0xCF, 0x90, 0x37, 0x50, 0x8E, 0x0D, 0x71,
  0x0B, 0xFA, 0x81, 0x60, 0xCF, 0x0E, 0x01, 0x74, 0x0B, 0xE0, 0xA7, 0x08, 0xFA, 0x05, 0x20, 0x20,
  0xEF, 0x0C, 0x74, 0x0E, 0xE0, 0x76, 0x03, 0xFA, 0x05, 0x40, 0x4F, 0x90, 0x97, 0x20, 0x3F, 0x03,
  0x60, 0xCF, 0x90, 0x66, 0x07, 0xF9, 0x06, 0x71, 0x08, 0xE0, 0xE6, 0x06, 0xF9, 0x09, 0x71, 0x0B,
  0xF9, 0x03, 0x70, 0xDE, 0x0A, 0x60, 0xDF, 0x0B, 0x72, 0x01, 0x0D, 0xF0, 0xE0, 0x15, 0x03, 0xF0,
  0x55, 0x04, 0xF0, 0xE0, 0x17, 0x30, 0x3F, 0x90, 0xC5, 0x09, 0xE0, 0xE6, 0x0A, 0xF0, 0x77, 0x50,
  0x6F, 0x90, 0x94, 0x0E, 0xE0, 0xA6, 0x0E, 0xF0, 0x17, 0x60, 0x9F, 0x90, 0x62, 0x07, 0xF0, 0x45,
  0x02, 0xF0, 0xB7, 0x71, 0x0C, 0xF9, 0x81, 0x30, 0xEE, 0x0D, 0x60, 0x4F, 0x08, 0x77, 0x10, 0x20,
  0xEF, 0x0E, 0x08, 0xF0, 0x76, 0x06, 0xF0, 0x57, 0x72, 0x04, 0xFF, 0x90, 0xE0, 0x16, 0x06, 0xF0,
  0x47, 0x73, 0x07, 0xFF, 0x09, 0x70, 0x7F, 0x04, 0x77, 0x40, 0xBF, 0xD0, 0xE0, 0x17, 0x06, 0xF0,
  0x57, 0x74, 0x01, 0x0D, 0xFC, 0x08, 0x71, 0x05, 0xF0, 0x77, 0x75, 0x03, 0xFB, 0x0E, 0x72, 0x03,
  0xF0, 0xB7, 0x76, 0x06, 0xFA, 0x06, 0x72, 0x01, 0xF9, 0x01, 0x77, 0x50, 0x3F, 0xA0, 0xA7, 0x30,
  0xDF, 0x07, 0x77, 0x40, 0x30, 0xEF, 0xB0, 0x87, 0x20, 0x8F, 0x0E, 0x02, 0x77, 0x20, 0x5F, 0xE0,
  0x57, 0x10, 0x2F, 0x90, 0xC0, 0x17, 0x70, 0x8F, 0xF9, 0x03, 0x71, 0x0B, 0xF9, 0x0D, 0x02, 0x74,
  0x04, 0x0D, 0xFF, 0xA0, 0xE0, 0x17, 0x03, 0xFB, 0x08, 0x02, 0x70, 0x50, 0xBF, 0xFD, 0x0C, 0x71,
  0x08, 0xFC, 0x84, 0xDA, 0x98, 0x9C, 0xFD, 0x81, 0x91, 0xDF, 0x90, 0xA7, 0x10, 0xCF, 0xFF, 0xE0,
  0x72, 0x03, 0x0E, 0xF9, 0x08, 0x70, 0x10, 0xDF, 0xFF, 0xB0, 0xD0, 0x34, 0x04, 0xFA, 0x05, 0x70,
  0x10, 0xCF, 0xFF, 0x90, 0x87, 0x07, 0xFA, 0x03, 0x71, 0x07, 0xFF, 0xD0, 0x90, 0x27, 0x20, 0x9F,
  0x90, 0xE0, 0x17, 0x18, 0x11, 0x8E, 0xFE, 0x81, 0xD7, 0x17, 0x50, 0xBF, 0x90, 0xC7, 0x48, 0x34,
  0x8B, 0xDE, 0xA8, 0x4E, 0xDB, 0x96, 0x27, 0x77, 0x40,
  // "'" (U+0027)
  0x04, 0xF9, 0x00, 0x3F, 0x90, 0x01, 0xF9, 0x2F, 0x0E, 0x20, 0xEE, 0x0D, 0x20, 0xDE, 0x0C, 0x20,
  0xCE, 0x0B, 0x20, 0xBE, 0x0A, 0x20, 0xAE, 0x08, 0x20, 0x8E, 0x07, 0x20, 0x7E, 0x06, 0x20, 0x6E,
  0x05, 0x20, 0x5E, 0x03, 0x20, 0x4E, 0x02, 0x20, 0x2E, 0x01, 0x20, 0x1E, 0x4D, 0x0E, 0x40, 0xEC,
  0x0D, 0x40, 0xDC, 0x0C, 0x40, 0xCC, 0x0B, 0x40, 0xBC, 0x09, 0x40, 0x9C, 0x08, 0x40, 0x8C, 0x07,
  0x20,
  // "(" (U+0028)
  0x75, 0x02, 0x0E, 0xE0, 0x57, 0x50, 0xDE, 0x0A, 0x75, 0x0A, 0xE0, 0xE0, 0x17, 0x40, 0x6F, 0x04,
  0x74, 0x02, 0xF0, 0xA7, 0x50, 0xBF, 0x01, 0x74, 0x05, 0xF0, 0x87, 0x50, 0xEE, 0x0E, 0x75, 0x08,
  0xF0, 0x67, 0x40, 0x1F, 0x0D, 0x75, 0x08, 0xF0, 0x67, 0x40, 0x10, 0xEE, 0x0E, 0x75, 0x08, 0xF0,
  0x87, 0x50, 0xEF, 0x01, 0x74, 0x05, 0xF0, 0xA7, 0x50, 0xBF, 0x05, 0x74, 0x01, 0xF0, 0xE7, 0x50,
  0x7F, 0x09, 0x75, 0x0C, 0xF0, 0x37, 0x40, 0x1F, 0x0E, 0x75, 0x05, 0xF0, 0xA7, 0x50, 0xAF, 0x06,
  0x75, 0x0E, 0xF0, 0x27, 0x40, 0x2F, 0x0D, 0x75, 0x06, 0xF0, 0xA7, 0x50, 0x8F, 0x07, 0x75, 0x0B,
  0xF0, 0x47, 0x50, 0xEF, 0x01, 0x74, 0x02, 0xF0, 0xD7, 0x50, 0x4F, 0x0B, 0x75, 0x06, 0xF0, 0x97,
  0x50, 0x7F, 0x08, 0x75, 0x09, 0xF0, 0x67, 0x50, 0xBF, 0x04, 0x75, 0x0C, 0xF0, 0x37, 0x50, 0xDF,
  0x02, 0x75, 0x0D, 0xF0, 0x17, 0x50, 0xEF, 0x01, 0x75, 0x0E, 0xF7, 0x6F, 0x97, 0x6F, 0x97, 0x60,
  0xEF, 0x01, 0x75, 0x0D, 0xF0, 0x27, 0x50, 0xDF, 0x02, 0x75, 0x0C, 0xF0, 0x37, 0x50, 0xBF, 0x04,
  0x75, 0x09, 0xF0, 0x67, 0x50, 0x8F, 0x08, 0x75, 0x06, 0xF0, 0xA7, 0x50, 0x4F, 0x0B, 0x75, 0x02,
  0xF0, 0xE7, 0x60, 0xEF, 0x02, 0x75, 0x0C, 0xF0, 0x57, 0x50, 0x9F, 0x08, 0x75, 0x06, 0xF0, 0xB7,
  0x50, 0x2F, 0x0E, 0x76, 0x0E, 0xF0, 0x37, 0x50, 0xAF, 0x07, 0x75, 0x05, 0xF0, 0xC7, 0x50, 0x1F,
  0x90, 0x17, 0x50, 0xCF, 0x05, 0x75, 0x07, 0xF0, 0xB7, 0x50, 0x1F, 0x90, 0x17, 0x50, 0xAF, 0x07,
  0x75, 0x05, 0xF0, 0xD7, 0x60, 0xEF, 0x04, 0x75, 0x07, 0xF0, 0xB7, 0x60, 0xEF, 0x02, 0x75, 0x07,
  0xF0, 0x97, 0x60, 0xEF, 0x01, 0x75, 0x06, 0xF0, 0x97, 0x60, 0xCF, 0x03, 0x75, 0x02, 0xF0, 0xB7,
  0x60, 0x8F, 0x05, 0x76, 0x0C, 0xE0, 0xD7, 0x60, 0x20, 0xEE, 0x09, 0x76, 0x05, 0xF0, 0x47, 0x60,
  0x8E, 0x0D, 0x77, 0x80, 0x37, 0x03,
  // ")" (U+0029)
  0x03, 0x80, 0x27, 0x06, 0x77, 0x0D, 0xE0, 0x87, 0x60, 0x4F, 0x04, 0x76, 0x09, 0xE0, 0xE0, 0x27,
  0x60, 0xDE, 0x0C, 0x76, 0x05, 0xF0, 0x77, 0x60, 0xBF, 0x02, 0x75, 0x03, 0xF0, 0xB7, 0x60, 0xAF,
  0x06, 0x75, 0x01, 0xF0, 0xE7, 0x60, 0xAF, 0x07, 0x75, 0x02, 0xF0, 0xE7, 0x60, 0xBF, 0x06, 0x75,
  0x04, 0xF0, 0xD7, 0x60, 0xDF, 0x04, 0x75, 0x07, 0xF0, 0xA7, 0x50, 0x2F, 0x90, 0x17, 0x50, 0xBF,
  0x06, 0x75, 0x06, 0xF0, 0xC7, 0x50, 0x1F, 0x90, 0x17, 0x50, 0xCF, 0x05, 0x75, 0x08, 0xF0, 0x97,
  0x50, 0x3F, 0x0E, 0x76, 0x0E, 0xF0, 0x27, 0x50, 0xBF, 0x05, 0x75, 0x08, 0xF0, 0x87, 0x50, 0x5F,
  0x0B, 0x75, 0x02, 0xF0, 0xE7, 0x60, 0xEF, 0x02, 0x75, 0x0C, 0xF0, 0x47, 0x50, 0xAF, 0x06, 0x75,
  0x08, 0xF0, 0x77, 0x50, 0x6F, 0x09, 0x75, 0x04, 0xF0, 0xB7, 0x50, 0x3F, 0x0C, 0x75, 0x02, 0xF0,
  0xD7, 0x50, 0x2F, 0x0D, 0x75, 0x01, 0xF0, 0xE7, 0x6F, 0x97, 0x6F, 0x97, 0x6F, 0x0E, 0x75, 0x01,
  0xF0, 0xE7, 0x50, 0x2F, 0x0D, 0x75, 0x02, 0xF0, 0xD7, 0x50, 0x3F, 0x0C, 0x75, 0x04, 0xF0, 0xB7,
  0x50, 0x6F, 0x09, 0x75, 0x08, 0xF0, 0x77, 0x50, 0x9F, 0x05, 0x75, 0x0B, 0xF0, 0x47, 0x50, 0xDF,
  0x02, 0x74, 0x01, 0xF0, 0xE7, 0x50, 0x4F, 0x0B, 0x75, 0x07, 0xF0, 0x87, 0x50, 0xAF, 0x05, 0x75,
  0x0D, 0xF0, 0x27, 0x40, 0x2F, 0x0E, 0x75, 0x06, 0xF0, 0x97, 0x50, 0xBF, 0x05, 0x75, 0x0E, 0xF0,
  0x17, 0x40, 0x4F, 0x0C, 0x75, 0x09, 0xF0, 0x77, 0x50, 0xEF, 0x01, 0x74, 0x05, 0xF0, 0xB7, 0x50,
  0xAF, 0x05, 0x74, 0x01, 0xF0, 0xE7, 0x50, 0x8F, 0x08, 0x75, 0x0E, 0xE0, 0xE0, 0x17, 0x40, 0x6F,
  0x08, 0x75, 0x0D, 0xF0, 0x17, 0x40, 0x6F, 0x08, 0x75, 0x0E, 0xE0, 0xE7, 0x50, 0x8F, 0x05, 0x74,
  0x01, 0xF0, 0xB7, 0x50, 0xAF, 0x02, 0x74, 0x04, 0xF0, 0x67, 0x40, 0x10, 0xEE, 0x0A, 0x75, 0x0A,
  0xE0, 0xD7, 0x50, 0x5E, 0x0E, 0x02, 0x75,
  // "*" (U+002A)
  0x77, 0x10, 0x8E, 0x07, 0x77, 0x77, 0x30, 0x7E, 0x06, 0x77, 0x77, 0x30, 0x6E, 0x05, 0x77, 0x77,
  0x30, 0x5E, 0x04, 0x77, 0x77, 0x30, 0x3E, 0x03, 0x77, 0x77, 0x30, 0x2E, 0x02, 0x77, 0x77, 0x30,
  0x1E, 0x01, 0x77, 0x77, 0x4E, 0x77, 0x77, 0x50, 0xEC, 0x0E, 0x77, 0x77, 0x50, 0xDC, 0x0D, 0x77,
  0x77, 0x50, 0xBC, 0x0C, 0x77, 0x77, 0x50, 0xAC, 0x0B, 0x77, 0x02, 0x38, 0x2A, 0xA6, 0x27, 0x40,
  0x9C, 0x0A, 0x73, 0x83, 0x26, 0xAE, 0xE3, 0x0E, 0xB8, 0x2E, 0xA6, 0x27, 0x08, 0xC0, 0x97, 0x81,
  0x59, 0xDD, 0x81, 0x20, 0x1F, 0x98, 0x2E, 0xA6, 0x23, 0x07, 0xC0, 0x83, 0x81, 0x37, 0xBF, 0xA8,
  0x15, 0x04, 0xFD, 0x82, 0xEA, 0x67, 0xC8, 0x28, 0x6A, 0xEF, 0xD8, 0x18, 0x07, 0x80, 0xC0, 0xF8,
  0x1A, 0x0A, 0x80, 0xC0, 0xF8, 0x2D, 0x0A, 0xE8, 0x0C, 0x0F, 0x01, 0x28, 0x51, 0x35, 0x79, 0xBD,
  0xFF, 0xF8, 0x6E, 0xDB, 0x97, 0x53, 0x17, 0x48, 0x31, 0x35, 0x7C, 0xF9, 0x85, 0xEB, 0x97, 0x53,
  0x17, 0x77, 0x10, 0x10, 0xDF, 0xA0, 0x37, 0x77, 0x60, 0xBF, 0xB0, 0xE0, 0x17, 0x77, 0x40, 0x9D,
  0x00, 0xBD, 0x0C, 0x77, 0x73, 0x05, 0xE0, 0x03, 0xE0, 0x97, 0x77, 0x10, 0x3E, 0x0B, 0x20, 0xBE,
  0x06, 0x77, 0x60, 0x10, 0xDE, 0x03, 0x20, 0x3F, 0x03, 0x77, 0x50, 0xBE, 0x0A, 0x40, 0xAE, 0x0E,
  0x01, 0x77, 0x30, 0x8F, 0x02, 0x40, 0x2F, 0x0C, 0x77, 0x20, 0x5F, 0x09, 0x60, 0x9F, 0x09, 0x77,
  0x02, 0x0E, 0xF0, 0x26, 0x01, 0xF9, 0x06, 0x75, 0x01, 0x0D, 0xF0, 0x97, 0x10, 0x9F, 0x90, 0x37,
  0x40, 0x9F, 0x90, 0x17, 0x10, 0x10, 0xEF, 0x0D, 0x75, 0x08, 0xE0, 0x87, 0x30, 0x8E, 0x0C, 0x03,
  0x76, 0x02, 0x0C, 0xB0, 0xE0, 0x17, 0x30, 0x10, 0xEB, 0x0E, 0x06, 0x77, 0x38, 0x26, 0xEF, 0x77,
  0x50, 0x7A, 0x09, 0x01, 0x77, 0x50, 0x10, 0x97, 0x70, 0xB0, 0x37, 0x40,
  // "+" (U+002B)
  0x77, 0x20, 0x2E, 0x05, 0x77, 0x77, 0x40, 0x2E, 0x05, 0x77, 0x77, 0x40, 0x2E, 0x05, 0x77, 0x77,
  0x40, 0x2E, 0x05, 0x77, 0x77, 0x40, 0x2E, 0x05, 0x77, 0x77, 0x40, 0x2E, 0x05, 0x77, 0x77, 0x40,
  0x2E, 0x05, 0x77, 0x77, 0x40, 0x2E, 0x05, 0x77, 0x77, 0x40, 0x2E, 0x05, 0x77, 0x77, 0x40, 0x2E,
  0x05, 0x77, 0x77, 0x40, 0x2E, 0x05, 0x77, 0x77, 0x40, 0x2E, 0x05, 0x77, 0x77, 0x40, 0x2E, 0x05,
  0x77, 0x77, 0x40, 0x2E, 0x05, 0x77, 0x77, 0x40, 0x2E, 0x05, 0x77, 0x77, 0x40, 0x2E, 0x05, 0x77,
  0x77, 0x40, 0x2E, 0x05, 0x77, 0x77, 0x40, 0x2E, 0x05, 0x77, 0x20, 0xC8, 0x0C, 0x2F, 0x00, 0xC8,
  0x0C, 0x2F, 0x00, 0xC8, 0x0C, 0x2F, 0x00, 0xC8, 0x0C, 0x2F, 0x00, 0xC8, 0x0C, 0x2F, 0x00, 0xC8,
  0x0C, 0x2F, 0x0C, 0x06, 0x80, 0x93, 0x80, 0x9E, 0x0A, 0x80, 0x93, 0x80, 0x67, 0x72, 0x02, 0xE0,
  0x57, 0x77, 0x74, 0x02, 0xE0, 0x57, 0x77, 0x74, 0x02, 0xE0, 0x57, 0x77, 0x74, 0x02, 0xE0, 0x57,
  0x77, 0x74, 0x02, 0xE0, 0x57, 0x77, 0x74, 0x02, 0xE0, 0x57, 0x77, 0x74, 0x02, 0xE0, 0x57, 0x77,
  0x74, 0x02, 0xE0, 0x57, 0x77, 0x74, 0x02, 0xE0, 0x57, 0x77, 0x74, 0x02, 0xE0, 0x57, 0x77, 0x74,
  0x02, 0xE0, 0x57, 0x77, 0x74, 0x02, 0xE0, 0x57, 0x77, 0x74, 0x02, 0xE0, 0x57, 0x77, 0x74, 0x02,
  0xE0, 0x57, 0x77, 0x74, 0x02, 0xE0, 0x57, 0x77, 0x74, 0x02, 0xE0, 0x57, 0x77, 0x74, 0x02, 0xE0,
  0x57, 0x72,
  // "," (U+002C)
  0x40, 0x3F, 0xA0, 0xC5, 0x05, 0xFB, 0x01, 0x40, 0x8F, 0xA0, 0xC5, 0x0A, 0xFA, 0x08, 0x50, 0xDF,
  0xA0, 0x35, 0xFA, 0x0D, 0x50, 0x3F, 0xA0, 0x95, 0x06, 0xFA, 0x03, 0x50, 0x9F, 0x90, 0xD6, 0x0C,
  0xF9, 0x08, 0x6F, 0xA0, 0x25, 0x03, 0xF9, 0x0C, 0x60, 0x6F, 0x90, 0x66, 0x09, 0xF9, 0x01, 0x60,
  0xDF, 0x09, 0x7F, 0x90, 0x36, 0x04, 0xF0, 0xD7, 0x07, 0xF0, 0x67, 0x0B, 0xE0, 0xE0, 0x17, 0x0E,
  0xE0, 0x97, 0x02, 0xF0, 0x27, 0x06, 0xE0, 0xB7, 0x10, 0xAE, 0x04, 0x71, 0x0D, 0xD0, 0xD7, 0x20,
  // "-" (U+002D)
  0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF,
  0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x07,
  // "." (U+002E)
  0x28, 0x61, 0x8C, 0xEE, 0xC7, 0x13, 0x02, 0x0E, 0xE0, 0xE0, 0x22, 0x0D, 0xF9, 0x81, 0xD0, 0x3F,
  0xB0, 0x30, 0x7F, 0xB0, 0x70, 0x8F, 0xB0, 0x08, 0xFB, 0x08, 0x07, 0xFB, 0x07, 0x03, 0xFB, 0x81,
  0x30, 0xCF, 0x90, 0xC2, 0x02, 0x0D, 0xE0, 0xD0, 0x14, 0x84, 0x7C, 0xEE, 0xC7, 0x30,
  // "/" (U+002F)
  0x77, 0x73, 0x0B, 0xE0, 0xE7, 0x77, 0x20, 0x2F, 0x09, 0x77, 0x72, 0x07, 0xF0, 0x37, 0x77, 0x20,
  0xDE, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0x77, 0x77, 0x20, 0xAF, 0x01, 0x77, 0x71, 0x01, 0xF0, 0xA7,
  0x77, 0x20, 0x6F, 0x04, 0x77, 0x72, 0x0C, 0xE0, 0xE7, 0x77, 0x20, 0x3F, 0x08, 0x77, 0x72, 0x09,
  0xF0, 0x27, 0x77, 0x20, 0xEE, 0x0B, 0x77, 0x72, 0x05, 0xF0, 0x57, 0x77, 0x20, 0xBE, 0x0E, 0x77,
  0x72, 0x02, 0xF0, 0x97, 0x77, 0x20, 0x8F, 0x03, 0x77, 0x72, 0x0D, 0xE0, 0xD7, 0x77, 0x20, 0x4F,
  0x07, 0x77, 0x72, 0x0A, 0xF0, 0x17, 0x77, 0x10, 0x1F, 0x0A, 0x77, 0x72, 0x06, 0xF0, 0x47, 0x77,
  0x20, 0xCE, 0x0E, 0x77, 0x72, 0x03, 0xF0, 0x87, 0x77, 0x20, 0x9F, 0x02, 0x77, 0x72, 0x0E, 0xE0,
  0xB7, 0x77, 0x20, 0x5F, 0x05, 0x77, 0x72, 0x0B, 0xE0, 0xE7, 0x77, 0x20, 0x2F, 0x09, 0x77, 0x72,
  0x08, 0xF0, 0x37, 0x77, 0x20, 0xDE, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0x77, 0x77, 0x20, 0xAF, 0x01,
  0x77, 0x71, 0x01, 0xF0, 0xA7, 0x77, 0x20, 0x7F, 0x04, 0x77, 0x72, 0x0D, 0xE0, 0xD7, 0x77, 0x20,
  0x3F, 0x08, 0x77, 0x72, 0x09, 0xF0, 0x27, 0x77, 0x20, 0xEE, 0x0B, 0x77, 0x72, 0x05, 0xF0, 0x57,
  0x77, 0x20, 0xBE, 0x0E, 0x77, 0x72, 0x02, 0xF0, 0x97, 0x77, 0x20, 0x8F, 0x03, 0x77, 0x72, 0x0E,
  0xE0, 0xC7, 0x77, 0x20, 0x4F, 0x06, 0x77, 0x72, 0x0A, 0xF0, 0x17, 0x77, 0x10, 0x1F, 0x0A, 0x77,
  0x72, 0x07, 0xF0, 0x47, 0x77, 0x20, 0xDE, 0x0D, 0x77, 0x72, 0x03, 0xF0, 0x87, 0x77, 0x20, 0x9F,
  0x02, 0x77, 0x72, 0x0E, 0xE0, 0xB7, 0x77, 0x20, 0x6F, 0x05, 0x77, 0x72, 0x0C, 0xE0, 0xE7, 0x77,
  0x20, 0x2F, 0x09, 0x77, 0x72, 0x08, 0xF0, 0x37, 0x77, 0x20, 0xEE, 0x0C, 0x77, 0x72, 0x04, 0xF0,
  0x67, 0x77, 0x20, 0xAF, 0x01, 0x77, 0x71, 0x01, 0xF0, 0xA7, 0x77, 0x20, 0x7F, 0x04, 0x77, 0x72,
  0x0D, 0xE0, 0xD7, 0x77, 0x20, 0x3F, 0x07, 0x77, 0x72, 0x09, 0xF0, 0x27, 0x77, 0x20, 0xEE, 0x0B,
  0x77, 0x73,
  // "0" (U+0030)
  0x77, 0x18, 0x42, 0x59, 0xBD, 0xEA, 0x84, 0xED, 0xB8, 0x51, 0x77, 0x77, 0x06, 0x0D, 0xFF, 0x0C,
  0x05, 0x77, 0x73, 0x07, 0x0E, 0xFF, 0xC0, 0xD0, 0x57, 0x76, 0x02, 0x0C, 0xFF, 0xF9, 0x0B, 0x01,
  0x77, 0x30, 0x30, 0xEF, 0xFF, 0xB0, 0xD0, 0x27, 0x71, 0x03, 0x0E, 0xFF, 0xFD, 0x0D, 0x01, 0x76,
  0x01, 0x0E, 0xFB, 0x85, 0xEB, 0x98, 0x9A, 0xCF, 0xC0, 0xD0, 0x17, 0x50, 0xBF, 0xA0, 0xB0, 0x47,
  0x81, 0x17, 0xEF, 0xA0, 0x97, 0x40, 0x7F, 0x90, 0xD0, 0x47, 0x50, 0x8F, 0xA0, 0x47, 0x20, 0x10,
  0xEF, 0x0C, 0x01, 0x77, 0x06, 0xF9, 0x0D, 0x72, 0x09, 0xF0, 0xD0, 0x17, 0x72, 0x09, 0xF9, 0x06,
  0x70, 0x1F, 0x90, 0x37, 0x72, 0x01, 0xFA, 0x0D, 0x70, 0x7F, 0x09, 0x77, 0x30, 0xAF, 0xB0, 0x46,
  0x0D, 0xF0, 0x17, 0x72, 0x04, 0xFC, 0x0B, 0x50, 0x3F, 0x09, 0x77, 0x30, 0xCF, 0xD0, 0x14, 0x08,
  0xF0, 0x37, 0x72, 0x06, 0xFE, 0x05, 0x40, 0xBE, 0x0D, 0x77, 0x20, 0x10, 0xEF, 0xE0, 0xA4, 0xF0,
  0x97, 0x72, 0x09, 0xF0, 0xEE, 0x0E, 0x30, 0x4F, 0x05, 0x77, 0x10, 0x2F, 0x0E, 0x05, 0xF0, 0x22,
  0x07, 0xF0, 0x27, 0x71, 0x0B, 0xF0, 0x61, 0xF0, 0x52, 0x09, 0xE0, 0xE7, 0x71, 0x05, 0xF0, 0xC2,
  0x0C, 0xE0, 0x82, 0x0C, 0xE0, 0xB7, 0x71, 0x0D, 0xF0, 0x32, 0x09, 0xE0, 0xB2, 0x0E, 0xE0, 0x97,
  0x70, 0x7F, 0x0A, 0x30, 0x6E, 0x81, 0xD0, 0x1F, 0x07, 0x76, 0x01, 0xF0, 0xE0, 0x13, 0x04, 0xF1,
  0x02, 0xF0, 0x57, 0x60, 0xAF, 0x07, 0x40, 0x2F, 0x02, 0x03, 0xF0, 0x47, 0x50, 0x4F, 0x0D, 0x6F,
  0x04, 0x05, 0xF0, 0x27, 0x50, 0xCF, 0x04, 0x6F, 0x05, 0x06, 0xF0, 0x17, 0x40, 0x6F, 0x0B, 0x70,
  0xDE, 0x06, 0x07, 0xF0, 0x17, 0x30, 0x10, 0xEF, 0x02, 0x70, 0xCE, 0x00, 0x7F, 0x74, 0x09, 0xF0,
  0x87, 0x10, 0xCE, 0x00, 0x8F, 0x73, 0x02, 0xF0, 0xE7, 0x20, 0xBE, 0x00, 0x8F, 0x73, 0x0B, 0xF0,
  0x57, 0x20, 0xBE, 0x08, 0x09, 0xE0, 0xE7, 0x20, 0x5F, 0x0C, 0x73, 0x0A, 0xE0, 0x09, 0xE0, 0xE7,
  0x20, 0xDF, 0x03, 0x73, 0x0A, 0xE0, 0x08, 0xF7, 0x10, 0x8F, 0x09, 0x74, 0x0B, 0xE0, 0x08, 0xF7,
  0x02, 0xF0, 0xE0, 0x17, 0x40, 0xBE, 0x00, 0x8F, 0x70, 0xAF, 0x07, 0x75, 0x0B, 0xE0, 0x07, 0xF0,
  0x15, 0x04, 0xF0, 0xD7, 0x60, 0xCE, 0x07, 0x06, 0xF0, 0x25, 0x0C, 0xF0, 0x47, 0x60, 0xDE, 0x06,
  0x05, 0xF0, 0x34, 0x06, 0xF0, 0xA7, 0x70, 0xEE, 0x04, 0x03, 0xF0, 0x43, 0x01, 0x0E, 0xF0, 0x27,
  0x7F, 0x03, 0x02, 0xF0, 0x53, 0x09, 0xF0, 0x87, 0x70, 0x1F, 0x02, 0x1F, 0x07, 0x20, 0x3F, 0x0D,
  0x77, 0x10, 0x3F, 0x20, 0xDE, 0x09, 0x20, 0xBF, 0x05, 0x77, 0x10, 0x5E, 0x0D, 0x20, 0xBE, 0x81,
  0xB0, 0x5F, 0x0B, 0x77, 0x20, 0x8E, 0x0B, 0x20, 0x8E, 0x81, 0xE0, 0xDF, 0x03, 0x77, 0x20, 0xBE,
  0x09, 0x20, 0x5F, 0x0A, 0xF0, 0x97, 0x73, 0x0E, 0xE0, 0x62, 0x02, 0xFF, 0x0E, 0x01, 0x77, 0x20,
  0x2F, 0x03, 0x30, 0xDF, 0xE0, 0x67, 0x73, 0x06, 0xE0, 0xE4, 0x09, 0xFD, 0x0C, 0x77, 0x40, 0xBE,
  0x0B, 0x40, 0x5F, 0xD0, 0x37, 0x73, 0x01, 0xF0, 0x75, 0xFC, 0x0A, 0x77, 0x40, 0x7F, 0x02, 0x50,
  0xAF, 0xA0, 0xE0, 0x17, 0x74, 0x0E, 0xE0, 0xC6, 0x04, 0xFA, 0x07, 0x77, 0x40, 0x7F, 0x06, 0x70,
  0xDF, 0x0D, 0x77, 0x40, 0x2F, 0x0E, 0x01, 0x70, 0x5F, 0x0E, 0x02, 0x77, 0x20, 0x10, 0xDF, 0x07,
  0x72, 0x0D, 0xF0, 0xD0, 0x27, 0x70, 0x10, 0xCF, 0x0E, 0x01, 0x72, 0x04, 0xF9, 0x0E, 0x04, 0x75,
  0x04, 0x0D, 0xF9, 0x06, 0x74, 0x09, 0xFA, 0x0B, 0x04, 0x71, 0x04, 0x0B, 0xFA, 0x0A, 0x76, 0x0D,
  0xFB, 0x86, 0xEB, 0x98, 0x99, 0xCE, 0xFB, 0x0D, 0x01, 0x76, 0x01, 0x0E, 0xFF, 0xFD, 0x0E, 0x02,
  0x77, 0x10, 0x20, 0xDF, 0xFF, 0xB0, 0xD0, 0x27, 0x73, 0x01, 0x0B, 0xFF, 0xF9, 0x0B, 0x01, 0x77,
  0x60, 0x50, 0xEF, 0xFC, 0x0E, 0x06, 0x77, 0x73, 0x06, 0x0C, 0xFF, 0x0C, 0x05, 0x77, 0x77, 0x89,
  0x41, 0x69, 0xBD, 0xEF, 0xED, 0xCB, 0x85, 0x17, 0x71,
  // "1" (U+0031)
  0x77, 0x30, 0x60, 0xDE, 0x03, 0x77, 0x77, 0x04, 0x0D, 0xF9, 0x03, 0x77, 0x75, 0x03, 0x0C, 0xFB,
  0x03, 0x77, 0x73, 0x02, 0x0B, 0xFD, 0x03, 0x77, 0x71, 0x02, 0x09, 0xFF, 0x03, 0x77, 0x60, 0x10,
  0x8F, 0xFA, 0x03, 0x77, 0x50, 0x70, 0xEF, 0xFB, 0x03, 0x77, 0x30, 0x60, 0xEF, 0xFD, 0x03, 0x77,
  0x10, 0x50, 0xDF, 0xE0, 0xEF, 0x03, 0x76, 0x01, 0x0C, 0xFE, 0x81, 0xE7, 0x3F, 0x03, 0x77, 0x0B,
  0xFC, 0x0D, 0x06, 0x20, 0x3F, 0x03, 0x77, 0x02, 0xFA, 0x0D, 0x06, 0x40, 0x4F, 0x03, 0x77, 0x10,
  0x8E, 0x0D, 0x06, 0x60, 0x4F, 0x03, 0x77, 0x10, 0x10, 0xEB, 0x0D, 0x06, 0x71, 0x05, 0xF0, 0x37,
  0x72, 0x82, 0x6F, 0xD6, 0x73, 0x05, 0xF0, 0x37, 0x73, 0x05, 0x75, 0x06, 0xF0, 0x37, 0x77, 0x72,
  0x06, 0xF0, 0x37, 0x77, 0x72, 0x06, 0xF0, 0x37, 0x77, 0x72, 0x07, 0xF0, 0x37, 0x77, 0x72, 0x07,
  0xF0, 0x37, 0x77, 0x72, 0x07, 0xF0, 0x37, 0x77, 0x72, 0x07, 0xF0, 0x37, 0x77, 0x72, 0x08, 0xF0,
  0x37, 0x77, 0x72, 0x08, 0xF0, 0x37, 0x77, 0x72, 0x08, 0xF0, 0x37, 0x77, 0x72, 0x08, 0xF0, 0x37,
  0x77, 0x72, 0x08, 0xF0, 0x37, 0x77, 0x72, 0x08, 0xF0, 0x37, 0x77, 0x72, 0x08, 0xF0, 0x37, 0x77,
  0x72, 0x08, 0xF0, 0x37, 0x77, 0x72, 0x08, 0xF0, 0x37, 0x77, 0x72, 0x08, 0xF0, 0x37, 0x77, 0x72,
  0x08, 0xF0, 0x37, 0x77, 0x72, 0x08, 0xF0, 0x37, 0x77, 0x72, 0x08, 0xF0, 0x37, 0x77, 0x72, 0x08,
  0xF0, 0x37, 0x77, 0x72, 0x08, 0xF0, 0x37, 0x77, 0x72, 0x08, 0xF0, 0x37, 0x77, 0x72, 0x08, 0xF0,
  0x37, 0x77, 0x72, 0x08, 0xF0, 0x37, 0x77, 0x72, 0x08, 0xF0, 0x37, 0x77, 0x72, 0x08, 0xF0, 0x37,
  0x77, 0x72, 0x08, 0xF0, 0x37, 0x77, 0x72, 0x08, 0xF0, 0x37, 0x77, 0x72, 0x08, 0xF0, 0x37, 0x77,
  0x72, 0x08, 0xF0, 0x37, 0x77, 0x72, 0x08, 0xF0, 0x37, 0x77, 0x72, 0x08, 0xF0, 0x37, 0x77, 0x72,
  0x08, 0xF0, 0x37, 0x77, 0x72, 0x08, 0xF0, 0x37, 0x77, 0x72, 0x08, 0xF0, 0x37, 0x77, 0x72, 0x08,
  0xF0, 0x37, 0x77, 0x72, 0x08, 0xF0, 0x37, 0x77, 0x72, 0x08, 0xF0, 0x37, 0x77, 0x72, 0x08, 0xF0,
  0x37, 0x77, 0x72, 0x08, 0xF0, 0x37, 0x77, 0x72, 0x08, 0xF0, 0x37, 0x77, 0x72, 0x08, 0xF0, 0x37,
  0x73, 0xFF, 0xFF, 0xE0, 0xC4, 0xFF, 0xFF, 0xE0, 0xC4, 0xFF, 0xFF, 0xE0, 0xC4, 0xFF, 0xFF, 0xE0,
  0xC4, 0xFF, 0xFF, 0xE0, 0xC4, 0xFF, 0xFF, 0xE0, 0xC0,
  // "2" (U+0032)
  0x76, 0x85, 0x26, 0x9B, 0xDE, 0xEA, 0x84, 0xED, 0xB8, 0x51, 0x77, 0x74, 0x81, 0x49, 0xEF, 0xF9,
  0x0C, 0x06, 0x77, 0x70, 0x60, 0xDF, 0xFE, 0x0E, 0x07, 0x77, 0x30, 0x70, 0xEF, 0xFF, 0xB0, 0xC0,
  0x27, 0x60, 0x50, 0xDF, 0xFF, 0xE0, 0xE0, 0x57, 0x30, 0x10, 0xAF, 0xFF, 0xFB, 0x05, 0x71, 0x04,
  0x0E, 0xFE, 0x86, 0xEC, 0xA9, 0x89, 0xAD, 0xFD, 0x03, 0x70, 0xBF, 0xC8, 0x1D, 0x73, 0x71, 0x81,
  0x27, 0xEF, 0xA0, 0xD7, 0x01, 0x0D, 0xF9, 0x0C, 0x04, 0x77, 0x08, 0xFA, 0x07, 0x70, 0x3E, 0x0D,
  0x05, 0x77, 0x30, 0x5F, 0x90, 0xE7, 0x10, 0x5C, 0x08, 0x77, 0x60, 0x6F, 0x90, 0x67, 0x18, 0x29,
  0xFE, 0x47, 0x77, 0x10, 0xCF, 0x0B, 0x72, 0x08, 0x01, 0x77, 0x72, 0x05, 0xF9, 0x77, 0x77, 0x7F,
  0x90, 0x37, 0x77, 0x76, 0x0B, 0xF0, 0x57, 0x77, 0x76, 0x09, 0xF0, 0x77, 0x77, 0x76, 0x08, 0xF0,
  0x87, 0x77, 0x76, 0x07, 0xF0, 0x97, 0x77, 0x76, 0x08, 0xF0, 0x97, 0x77, 0x76, 0x09, 0xF0, 0x77,
  0x77, 0x76, 0x0A, 0xF0, 0x67, 0x77, 0x76, 0x0E, 0xF0, 0x57, 0x77, 0x75, 0x02, 0xF9, 0x02, 0x77,
  0x77, 0x50, 0x6F, 0x0E, 0x77, 0x77, 0x60, 0xCF, 0x0B, 0x77, 0x77, 0x50, 0x2F, 0x90, 0x77, 0x77,
  0x75, 0x09, 0xF9, 0x01, 0x77, 0x77, 0x40, 0x3F, 0x90, 0xB7, 0x77, 0x75, 0x0B, 0xF9, 0x05, 0x77,
  0x77, 0x40, 0x6F, 0x90, 0xC7, 0x77, 0x74, 0x02, 0x0E, 0xF9, 0x04, 0x77, 0x77, 0x40, 0xCF, 0x90,
  0xB7, 0x77, 0x74, 0x09, 0xF9, 0x0E, 0x01, 0x77, 0x77, 0x30, 0x6F, 0xA0, 0x67, 0x77, 0x73, 0x03,
  0xFA, 0x0B, 0x77, 0x77, 0x30, 0x20, 0xEF, 0x90, 0xD0, 0x17, 0x77, 0x72, 0x01, 0x0D, 0xFA, 0x03,
  0x77, 0x77, 0x30, 0xCF, 0xA0, 0x67, 0x77, 0x73, 0x0B, 0xFA, 0x09, 0x77, 0x77, 0x30, 0xAF, 0xA0,
  0xA7, 0x77, 0x73, 0x0A, 0xFA, 0x0C, 0x77, 0x77, 0x30, 0x9F, 0xA0, 0xC0, 0x17, 0x77, 0x72, 0x09,
  0xFA, 0x0C, 0x01, 0x77, 0x77, 0x20, 0x9F, 0xA0, 0xD0, 0x17, 0x77, 0x72, 0x09, 0xFA, 0x0D, 0x01,
  0x77, 0x77, 0x20, 0x9F, 0xA0, 0xD0, 0x17, 0x77, 0x72, 0x09, 0xFA, 0x0C, 0x01, 0x77, 0x77, 0x20,
  0x9F, 0xA0, 0xC0, 0x17, 0x77, 0x72, 0x09, 0xFA, 0x0C, 0x01, 0x77, 0x77, 0x20, 0x9F, 0xA0, 0xC0,
  0x17, 0x77, 0x72, 0x09, 0xFA, 0x0C, 0x77, 0x77, 0x30, 0x9F, 0xA0, 0xB7, 0x77, 0x73, 0x09, 0xFA,
  0x0B, 0x77, 0x77, 0x30, 0x9F, 0xA0, 0xB7, 0x77, 0x73, 0x09, 0xFA, 0x0B, 0x77, 0x77, 0x30, 0x9F,
  0xA0, 0xA7, 0x77, 0x73, 0x09, 0xFA, 0x0A, 0x77, 0x77, 0x30, 0x9F, 0xA0, 0xA7, 0x77, 0x73, 0x08,
  0x80, 0xC6, 0xF0, 0xA8, 0x0C, 0x6F, 0x0A, 0x80, 0xC6, 0xF0, 0xA8, 0x0C, 0x6F, 0x0A, 0x80, 0xC6,
  0xF0, 0xA8, 0x0C, 0x6F, 0x0A, 0x80, 0xC6, 0xF0,
  // "3" (U+0033)
  0x75, 0x86, 0x15, 0x8A, 0xCD, 0xEE, 0xA8, 0x4E, 0xDB, 0x96, 0x37, 0x77, 0x28, 0x14, 0x9D, 0xFF,
  0xA8, 0x1E, 0x82, 0x77, 0x38, 0x11, 0x7D, 0xFF, 0xF9, 0x0A, 0x02, 0x76, 0x02, 0x09, 0xFF, 0xFD,
  0x0E, 0x06, 0x73, 0x01, 0x08, 0xFF, 0xFF, 0xA0, 0x87, 0x10, 0x50, 0xEF, 0xFF, 0xFC, 0x08, 0x70,
  0xBF, 0xE8, 0x7E, 0xCA, 0x98, 0x9A, 0xBE, 0xFD, 0x05, 0x60, 0x10, 0xEF, 0xA8, 0x1D, 0x73, 0x72,
  0x81, 0x27, 0xDF, 0xA0, 0xE0, 0x16, 0x05, 0xF0, 0xA0, 0x37, 0x71, 0x09, 0xFA, 0x09, 0x70, 0x9C,
  0x0A, 0x02, 0x77, 0x40, 0x6F, 0xA0, 0x17, 0x82, 0xDF, 0xC3, 0x77, 0x70, 0x8F, 0x90, 0x67, 0x03,
  0x06, 0x77, 0x73, 0x0E, 0xF0, 0xB7, 0x77, 0x75, 0x08, 0xF0, 0xE7, 0x77, 0x75, 0x03, 0xF9, 0x01,
  0x77, 0x77, 0x40, 0x1F, 0x90, 0x37, 0x77, 0x75, 0xF9, 0x03, 0x77, 0x77, 0x50, 0xEF, 0x03, 0x77,
  0x77, 0x5F, 0x90, 0x27, 0x77, 0x74, 0x02, 0xF9, 0x77, 0x77, 0x50, 0x6F, 0x0D, 0x77, 0x77, 0x50,
  0xAF, 0x09, 0x77, 0x77, 0x40, 0x2F, 0x90, 0x47, 0x77, 0x74, 0x0B, 0xF0, 0xD7, 0x77, 0x74, 0x07,
  0xF9, 0x05, 0x77, 0x77, 0x30, 0x6F, 0x90, 0xB7, 0x77, 0x73, 0x09, 0xF9, 0x0D, 0x01, 0x77, 0x77,
  0x81, 0x17, 0xDF, 0x90, 0xD0, 0x27, 0x77, 0x38, 0x31, 0x24, 0x8B, 0xFB, 0x0C, 0x01, 0x77, 0x30,
  0xDF, 0xFE, 0x0E, 0x07, 0x77, 0x50, 0xDF, 0xFC, 0x81, 0xE8, 0x17, 0x76, 0x0D, 0xFF, 0x98, 0x1B,
  0x84, 0x77, 0x72, 0x0D, 0xFF, 0x98, 0x2A, 0x74, 0x17, 0x77, 0x10, 0xDF, 0xFD, 0x81, 0xB6, 0x17,
  0x75, 0x0D, 0xFF, 0xF9, 0x08, 0x01, 0x77, 0x30, 0xDF, 0xFF, 0xA0, 0xE0, 0x57, 0x77, 0x38, 0x51,
  0x23, 0x57, 0xAE, 0xFC, 0x08, 0x77, 0x77, 0x20, 0x30, 0x9F, 0xB0, 0x97, 0x77, 0x73, 0x01, 0x09,
  0xFA, 0x06, 0x77, 0x77, 0x40, 0x40, 0xEF, 0x90, 0x27, 0x77, 0x74, 0x03, 0xF9, 0x09, 0x77, 0x77,
  0x50, 0x7F, 0x90, 0x17, 0x77, 0x75, 0x0E, 0xF0, 0x67, 0x77, 0x75, 0x09, 0xF0, 0xA7, 0x77, 0x75,
  0x04, 0xF0, 0xE7, 0x77, 0x75, 0x01, 0xF9, 0x77, 0x77, 0x6F, 0x90, 0x27, 0x77, 0x75, 0x0E, 0xF0,
  0x37, 0x77, 0x75, 0xF9, 0x03, 0x77, 0x77, 0x40, 0x1F, 0x90, 0x27, 0x77, 0x74, 0x02, 0xF9, 0x01,
  0x77, 0x77, 0x40, 0x6F, 0x0E, 0x77, 0x77, 0x50, 0xBF, 0x0B, 0x77, 0x77, 0x40, 0x2F, 0x90, 0x87,
  0x77, 0x74, 0x0A, 0xF9, 0x03, 0x77, 0x77, 0x30, 0x4F, 0x90, 0xD2, 0x03, 0x06, 0x77, 0x76, 0x02,
  0x0E, 0xF9, 0x05, 0x28, 0x35, 0xFE, 0x81, 0x77, 0x72, 0x03, 0x0E, 0xF9, 0x0D, 0x30, 0x5C, 0x81,
  0xB6, 0x27, 0x74, 0x01, 0x08, 0xFB, 0x03, 0x30, 0x5F, 0x82, 0xD8, 0x52, 0x74, 0x81, 0x15, 0xAF,
  0xC0, 0x84, 0x05, 0xFD, 0x89, 0x0D, 0xBA, 0x98, 0x89, 0xAB, 0xDF, 0xE0, 0x95, 0x05, 0xFF, 0xFF,
  0xE0, 0x96, 0x05, 0xFF, 0xFF, 0xD0, 0x67, 0x04, 0xFF, 0xFF, 0xB0, 0xB0, 0x27, 0x28, 0x12, 0x8D,
  0xFF, 0xFD, 0x0B, 0x04, 0x77, 0x81, 0x37, 0xBF, 0xFE, 0x81, 0xC7, 0x17, 0x76, 0x8A, 0x02, 0x57,
  0x9B, 0xCD, 0xEE, 0xFE, 0xED, 0xCB, 0x97, 0x47, 0x72,
  // "4" (U+0034)
  0x77, 0x75, 0x05, 0xFA, 0x02, 0x77, 0x77, 0x70, 0xEF, 0xA0, 0x27, 0x77, 0x76, 0x08, 0xFB, 0x02,
  0x77, 0x77, 0x50, 0x3F, 0xC0, 0x27, 0x77, 0x75, 0x0C, 0xFC, 0x02, 0x77, 0x77, 0x40, 0x6F, 0xD0,
  0x27, 0x77, 0x73, 0x01, 0x0E, 0xFD, 0x02, 0x77, 0x77, 0x30, 0x9F, 0xE0, 0x27, 0x77, 0x72, 0x03,
  0xE0, 0xDF, 0x02, 0x77, 0x77, 0x20, 0xCE, 0x04, 0xF0, 0x27, 0x77, 0x71, 0x07, 0xE0, 0xC0, 0x2F,
  0x02, 0x77, 0x77, 0x01, 0x0E, 0xE0, 0x40, 0x3F, 0x02, 0x77, 0x77, 0x0A, 0xE8, 0x1C, 0x03, 0xF0,
  0x27, 0x77, 0x60, 0x4F, 0x81, 0x30, 0x4F, 0x02, 0x77, 0x76, 0x0D, 0xE0, 0xB2, 0x05, 0xF0, 0x27,
  0x77, 0x50, 0x7F, 0x02, 0x20, 0x5F, 0x02, 0x77, 0x74, 0x02, 0xF0, 0x83, 0x06, 0xF0, 0x27, 0x77,
  0x40, 0xBE, 0x0D, 0x40, 0x6F, 0x02, 0x77, 0x73, 0x05, 0xF0, 0x54, 0x07, 0xF0, 0x27, 0x77, 0x30,
  0xDE, 0x0B, 0x50, 0x7F, 0x02, 0x77, 0x72, 0x08, 0xF0, 0x25, 0x08, 0xF0, 0x27, 0x77, 0x10, 0x2F,
  0x07, 0x60, 0x8F, 0x02, 0x77, 0x71, 0x0C, 0xE0, 0xD7, 0x08, 0xF0, 0x27, 0x77, 0x06, 0xF0, 0x47,
  0x08, 0xF0, 0x27, 0x76, 0x01, 0x0E, 0xE0, 0xA7, 0x10, 0x9F, 0x02, 0x77, 0x60, 0x9E, 0x0E, 0x01,
  0x71, 0x09, 0xF0, 0x27, 0x75, 0x03, 0xF0, 0x67, 0x20, 0x9F, 0x02, 0x77, 0x50, 0xCE, 0x0C, 0x73,
  0x09, 0xF0, 0x27, 0x74, 0x07, 0xF0, 0x37, 0x30, 0x9F, 0x02, 0x77, 0x30, 0x10, 0xEE, 0x09, 0x74,
  0x09, 0xF0, 0x27, 0x73, 0x0A, 0xE0, 0xE0, 0x17, 0x40, 0x9F, 0x02, 0x77, 0x20, 0x4F, 0x05, 0x75,
  0x09, 0xF0, 0x27, 0x72, 0x0D, 0xE0, 0xB7, 0x60, 0x9F, 0x02, 0x77, 0x10, 0x7F, 0x02, 0x76, 0x09,
  0xF0, 0x27, 0x70, 0x2F, 0x08, 0x77, 0x09, 0xF0, 0x27, 0x70, 0xBE, 0x0D, 0x77, 0x10, 0x9F, 0x02,
  0x76, 0x05, 0xF0, 0x47, 0x71, 0x09, 0xF0, 0x27, 0x60, 0xDE, 0x0A, 0x77, 0x20, 0x9F, 0x02, 0x75,
  0x08, 0xE0, 0xE0, 0x17, 0x72, 0x09, 0xF0, 0x27, 0x40, 0x2F, 0x07, 0x77, 0x30, 0x9F, 0x02, 0x74,
  0x0B, 0xE0, 0xD7, 0x74, 0x09, 0xF0, 0x27, 0x30, 0x6F, 0x03, 0x77, 0x40, 0x9F, 0x02, 0x72, 0x01,
  0x0E, 0xE0, 0x97, 0x75, 0x09, 0xF0, 0x27, 0x20, 0x78, 0x0D, 0x0F, 0x00, 0x78, 0x0D, 0x0F, 0x00,
  0x78, 0x0D, 0x0F, 0x00, 0x78, 0x0D, 0x0F, 0x00, 0x78, 0x0D, 0x0F, 0x00, 0x78, 0x0D, 0x0F, 0x07,
  0x04, 0x80, 0xA7, 0x80, 0xCF, 0x09, 0x80, 0x48, 0x04, 0x77, 0x77, 0x09, 0xF0, 0x28, 0x0C, 0x10,
  0x09, 0xF0, 0x28, 0x0C, 0x10, 0x09, 0xF0, 0x28, 0x0C, 0x10, 0x09, 0xF0, 0x28, 0x0C, 0x10, 0x09,
  0xF0, 0x28, 0x0C, 0x10, 0x09, 0xF0, 0x28, 0x0C, 0x10, 0x09, 0xF0, 0x28, 0x0C, 0x10, 0x09, 0xF0,
  0x28, 0x0C, 0x10, 0x09, 0xF0, 0x28, 0x0C, 0x10, 0x09, 0xF0, 0x28, 0x0C, 0x10, 0x09, 0xF0, 0x28,
  0x0C, 0x10, 0x09, 0xF0, 0x28, 0x0C, 0x10, 0x09, 0xF0, 0x28, 0x0C, 0x10, 0x09, 0xF0, 0x27, 0x20,
  // "5" (U+0035)
  0x4F, 0xFF, 0xFC, 0x70, 0x2F, 0xFF, 0xFC, 0x70, 0x3F, 0xFF, 0xFC, 0x70, 0x4F, 0xFF, 0xFC, 0x70,
  0x5F, 0xFF, 0xFC, 0x70, 0x7F, 0xFF, 0xFC, 0x70, 0x8F, 0xFF, 0xFC, 0x70, 0x9E, 0x0D, 0x77, 0x77,
  0x40, 0xAE, 0x0B, 0x77, 0x77, 0x40, 0xCE, 0x0A, 0x77, 0x77, 0x40, 0xDE, 0x09, 0x77, 0x77, 0x40,
  0xEE, 0x07, 0x77, 0x77, 0x4F, 0x06, 0x77, 0x77, 0x30, 0x1F, 0x04, 0x77, 0x77, 0x30, 0x2F, 0x03,
  0x77, 0x77, 0x30, 0x4F, 0x02, 0x77, 0x77, 0x30, 0x5F, 0x77, 0x77, 0x40, 0x6E, 0x0E, 0x77, 0x77,
  0x40, 0x7E, 0x0D, 0x77, 0x77, 0x40, 0x9E, 0x0C, 0x77, 0x77, 0x40, 0xAE, 0x0A, 0x77, 0x77, 0x40,
  0xBE, 0x09, 0x77, 0x77, 0x40, 0xCE, 0x07, 0x77, 0x77, 0x40, 0xEE, 0x06, 0x77, 0x77, 0x4F, 0x05,
  0x77, 0x77, 0x30, 0x1F, 0x86, 0x55, 0x79, 0xBC, 0xDE, 0xA8, 0x5E, 0xED, 0xB8, 0x62, 0x77, 0x10,
  0x2F, 0xFF, 0xB8, 0x1D, 0x82, 0x75, 0x03, 0xFF, 0xFE, 0x0B, 0x03, 0x73, 0x04, 0xFF, 0xFF, 0x90,
  0x90, 0x17, 0x10, 0x5F, 0xFF, 0xFA, 0x0D, 0x03, 0x70, 0x30, 0xEF, 0xFF, 0xFA, 0x0E, 0x04, 0x70,
  0x20, 0xBF, 0x87, 0xEC, 0xA9, 0x89, 0xAB, 0xCF, 0xF9, 0x03, 0x71, 0x85, 0x7F, 0xEA, 0x74, 0x17,
  0x38, 0x13, 0x7D, 0xFC, 0x0E, 0x01, 0x71, 0x01, 0x77, 0x40, 0x40, 0xCF, 0xB0, 0xB7, 0x77, 0x71,
  0x07, 0xFB, 0x05, 0x77, 0x77, 0x10, 0x40, 0xEF, 0x90, 0xD7, 0x77, 0x72, 0x04, 0xFA, 0x04, 0x77,
  0x77, 0x20, 0x8F, 0x90, 0xA7, 0x77, 0x73, 0x0E, 0xF0, 0xE7, 0x77, 0x73, 0x08, 0xF9, 0x02, 0x77,
  0x77, 0x20, 0x3F, 0x90, 0x57, 0x77, 0x73, 0x0E, 0xF0, 0x87, 0x77, 0x73, 0x0B, 0xF0, 0x97, 0x77,
  0x73, 0x0A, 0xF0, 0xA7, 0x77, 0x73, 0x09, 0xF0, 0xA7, 0x77, 0x73, 0x08, 0xF0, 0xA7, 0x77, 0x73,
  0x09, 0xF0, 0x97, 0x77, 0x73, 0x0B, 0xF0, 0x77, 0x77, 0x73, 0x0D, 0xF0, 0x57, 0x77, 0x72, 0x01,
  0xF9, 0x02, 0x77, 0x77, 0x20, 0x6F, 0x0E, 0x77, 0x77, 0x30, 0xCF, 0x0A, 0x77, 0x77, 0x20, 0x5F,
  0x90, 0x47, 0x77, 0x71, 0x02, 0x0E, 0xF0, 0xD2, 0x04, 0x77, 0x75, 0x01, 0x0D, 0xF9, 0x05, 0x28,
  0x1C, 0xD5, 0x77, 0x72, 0x05, 0x0E, 0xF9, 0x0C, 0x30, 0xCA, 0x81, 0xD7, 0x27, 0x74, 0x03, 0x0B,
  0xFA, 0x0E, 0x02, 0x30, 0xCD, 0x82, 0xC8, 0x41, 0x74, 0x81, 0x37, 0xDF, 0xC0, 0x54, 0x0C, 0xFA,
  0x89, 0x0E, 0xCA, 0x98, 0x89, 0xAB, 0xDF, 0xF0, 0x75, 0x0C, 0xFF, 0xFF, 0xC0, 0x66, 0x0C, 0xFF,
  0xFF, 0xA0, 0xE0, 0x47, 0x0B, 0xFF, 0xFF, 0x90, 0x90, 0x17, 0x20, 0x50, 0xBF, 0xFF, 0xC0, 0xA0,
  0x27, 0x68, 0x21, 0x6A, 0xEF, 0xFC, 0x81, 0xB7, 0x17, 0x75, 0x86, 0x24, 0x79, 0xBC, 0xDE, 0xA8,
  0x5E, 0xED, 0xB9, 0x74, 0x77, 0x20,
  // "6" (U+0036)
  0x77, 0x78, 0x71, 0x46, 0x9B, 0xCD, 0xEE, 0xA8, 0x5E, 0xDC, 0xA8, 0x51, 0x77, 0x72, 0x81, 0x38,
  0xCF, 0xFB, 0x04, 0x77, 0x70, 0x60, 0xDF, 0xFE, 0x04, 0x77, 0x50, 0x50, 0xEF, 0xFF, 0x90, 0x47,
  0x73, 0x02, 0x0B, 0xFF, 0xFB, 0x04, 0x77, 0x20, 0x50, 0xEF, 0xFF, 0xC0, 0x47, 0x71, 0x07, 0xFF,
  0x89, 0x0E, 0xCA, 0x99, 0x89, 0x9B, 0xCB, 0x04, 0x77, 0x08, 0xFC, 0x82, 0xE9, 0x51, 0x74, 0x81,
  0x27, 0x27, 0x60, 0x7F, 0xB0, 0xC0, 0x57, 0x77, 0x72, 0x05, 0xFA, 0x0D, 0x05, 0x77, 0x77, 0x30,
  0x10, 0xEF, 0x90, 0xB0, 0x17, 0x77, 0x74, 0x0B, 0xF9, 0x09, 0x77, 0x77, 0x50, 0x5F, 0x90, 0x97,
  0x77, 0x76, 0x0D, 0xF0, 0xB7, 0x77, 0x76, 0x06, 0xF0, 0xE0, 0x17, 0x77, 0x76, 0x0C, 0xF0, 0x67,
  0x77, 0x76, 0x03, 0xF0, 0xD7, 0x77, 0x77, 0x0A, 0xF0, 0x57, 0x77, 0x77, 0x0E, 0xE0, 0xE7, 0x77,
  0x77, 0x04, 0xF0, 0x87, 0x77, 0x77, 0x09, 0xF0, 0x37, 0x77, 0x77, 0x0D, 0xE0, 0xE7, 0x77, 0x77,
  0x01, 0xF0, 0xA7, 0x77, 0x77, 0x04, 0xF0, 0x77, 0x77, 0x77, 0x07, 0xF0, 0x57, 0x28, 0x90, 0x14,
  0x67, 0x88, 0x76, 0x42, 0x77, 0x20, 0xAF, 0x02, 0x68, 0x13, 0x8D, 0xFB, 0x82, 0xEB, 0x61, 0x75,
  0x0C, 0xF5, 0x03, 0x0B, 0xFF, 0xB0, 0x90, 0x27, 0x30, 0xEE, 0x0C, 0x40, 0x8F, 0xFF, 0x08, 0x71,
  0x01, 0xF0, 0xB3, 0x0B, 0xFF, 0xFA, 0x0C, 0x01, 0x60, 0x2F, 0x0A, 0x20, 0xCF, 0xFF, 0xC0, 0xD0,
  0x25, 0x04, 0xF8, 0x18, 0x0A, 0xFF, 0xFE, 0x0D, 0x01, 0x40, 0x5F, 0x07, 0x05, 0xF8, 0x3D, 0x85,
  0x21, 0x28, 0x31, 0x35, 0x9D, 0xFB, 0x0C, 0x40, 0x6F, 0x0A, 0x0E, 0xD0, 0xB0, 0x37, 0x50, 0x50,
  0xDF, 0xA0, 0x83, 0x07, 0xFD, 0x0D, 0x04, 0x77, 0x20, 0x9F, 0xA0, 0x22, 0x08, 0xFC, 0x0B, 0x01,
  0x77, 0x40, 0x7F, 0x90, 0x92, 0x08, 0xFB, 0x0B, 0x77, 0x70, 0xAF, 0x98, 0x11, 0x08, 0xFA, 0x0C,
  0x77, 0x71, 0x01, 0x0E, 0xF8, 0x16, 0x09, 0xFA, 0x02, 0x77, 0x72, 0x08, 0xF8, 0x1B, 0x08, 0xF9,
  0x08, 0x77, 0x73, 0x01, 0xF8, 0x1E, 0x08, 0xF9, 0x02, 0x77, 0x74, 0x0C, 0xF0, 0x20, 0x7F, 0x0C,
  0x77, 0x75, 0x09, 0xF0, 0x50, 0x7F, 0x08, 0x77, 0x75, 0x05, 0xF0, 0x60, 0x5F, 0x07, 0x77, 0x75,
  0x04, 0xF0, 0x80, 0x4F, 0x06, 0x77, 0x75, 0x03, 0xF0, 0x80, 0x2F, 0x07, 0x77, 0x75, 0x02, 0xF0,
  0x91, 0xF0, 0x87, 0x77, 0x50, 0x2F, 0x81, 0x80, 0xDE, 0x0B, 0x77, 0x75, 0x03, 0xF8, 0x18, 0x0A,
  0xE0, 0xE7, 0x77, 0x50, 0x4F, 0x81, 0x60, 0x6F, 0x03, 0x77, 0x74, 0x06, 0xF8, 0x14, 0x03, 0xF0,
  0x87, 0x77, 0x40, 0x9F, 0x02, 0x20, 0xEE, 0x0D, 0x77, 0x74, 0x0C, 0xE0, 0xE3, 0x09, 0xF0, 0x57,
  0x77, 0x20, 0x1F, 0x0B, 0x30, 0x3F, 0x0D, 0x77, 0x72, 0x07, 0xF0, 0x74, 0x0C, 0xF0, 0x77, 0x77,
  0x10, 0xEF, 0x02, 0x40, 0x6F, 0x90, 0x37, 0x76, 0x08, 0xF0, 0xB6, 0x0D, 0xF0, 0xE0, 0x27, 0x74,
  0x05, 0xF9, 0x04, 0x60, 0x4F, 0x90, 0xE0, 0x47, 0x72, 0x07, 0xF9, 0x0B, 0x71, 0x09, 0xFA, 0x08,
  0x76, 0x02, 0x0B, 0xFA, 0x02, 0x72, 0x0D, 0xFA, 0x81, 0xD7, 0x27, 0x10, 0x40, 0xAF, 0xB0, 0x67,
  0x30, 0x10, 0xDF, 0xC8, 0x5D, 0xA9, 0x89, 0xAC, 0xFD, 0x09, 0x75, 0x02, 0x0D, 0xFF, 0xFF, 0x0A,
  0x77, 0x01, 0x0C, 0xFF, 0xFD, 0x08, 0x77, 0x30, 0x8F, 0xFF, 0xA0, 0xE0, 0x57, 0x75, 0x03, 0x0B,
  0xFF, 0xE0, 0x80, 0x17, 0x77, 0x18, 0x13, 0x9E, 0xFF, 0x81, 0xC7, 0x17, 0x77, 0x68, 0x43, 0x7A,
  0xCD, 0xEA, 0x84, 0xED, 0xB9, 0x52, 0x77,
  // "7" (U+0037)
  0x09, 0x80, 0xC6, 0xF0, 0x09, 0x80, 0xC6, 0xF0, 0x09, 0x80, 0xC6, 0xF0, 0x09, 0x80, 0xC6, 0xF0,
  0x09, 0x80, 0xC6, 0xF0, 0x09, 0x80, 0xC6, 0xF0, 0x09, 0x80, 0xC6, 0xF0, 0x77, 0x77, 0x77, 0x0C,
  0xF0, 0x17, 0x77, 0x76, 0x03, 0xF0, 0x97, 0x77, 0x77, 0x0A, 0xF0, 0x37, 0x77, 0x76, 0x01, 0xF0,
  0xC7, 0x77, 0x77, 0x08, 0xF0, 0x57, 0x77, 0x77, 0x0E, 0xE0, 0xE7, 0x77, 0x77, 0x06, 0xF0, 0x87,
  0x77, 0x77, 0x0D, 0xF0, 0x17, 0x77, 0x76, 0x04, 0xF0, 0xA7, 0x77, 0x77, 0x0B, 0xF0, 0x37, 0x77,
  0x76, 0x02, 0xF0, 0xC7, 0x77, 0x77, 0x09, 0xF0, 0x67, 0x77, 0x76, 0x01, 0x0E, 0xE0, 0xE7, 0x77,
  0x77, 0x07, 0xF0, 0x87, 0x77, 0x77, 0x0D, 0xF0, 0x27, 0x77, 0x76, 0x05, 0xF0, 0xB7, 0x77, 0x77,
  0x0B, 0xF0, 0x47, 0x77, 0x76, 0x03, 0xF0, 0xD7, 0x77, 0x77, 0x09, 0xF0, 0x77, 0x77, 0x76, 0x01,
  0xF0, 0xE0, 0x17, 0x77, 0x76, 0x07, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x27, 0x77, 0x76, 0x05,
  0xF0, 0xB7, 0x77, 0x77, 0x0C, 0xF0, 0x57, 0x77, 0x76, 0x03, 0xF0, 0xD7, 0x77, 0x77, 0x0A, 0xF0,
  0x77, 0x77, 0x76, 0x01, 0xF9, 0x01, 0x77, 0x77, 0x60, 0x8F, 0x0A, 0x77, 0x77, 0x70, 0xEF, 0x03,
  0x77, 0x77, 0x60, 0x6F, 0x0C, 0x77, 0x77, 0x70, 0xCF, 0x06, 0x77, 0x77, 0x60, 0x4F, 0x0E, 0x77,
  0x77, 0x70, 0xBF, 0x08, 0x77, 0x77, 0x60, 0x2F, 0x90, 0x27, 0x77, 0x76, 0x08, 0xF0, 0xA7, 0x77,
  0x77, 0x0E, 0xF0, 0x47, 0x77, 0x76, 0x06, 0xF0, 0xD7, 0x77, 0x77, 0x0D, 0xF0, 0x67, 0x77, 0x76,
  0x04, 0xF0, 0xE7, 0x77, 0x77, 0x0B, 0xF0, 0x97, 0x77, 0x76, 0x02, 0xF9, 0x02, 0x77, 0x77, 0x60,
  0x9F, 0x0B, 0x77, 0x77, 0x60, 0x1F, 0x90, 0x57, 0x77, 0x76, 0x07, 0xF0, 0xD7, 0x77, 0x77, 0x0D,
  0xF0, 0x77, 0x77, 0x76, 0x05, 0xF9, 0x01, 0x77, 0x77, 0x60, 0xCF, 0x09, 0x77, 0x77, 0x60, 0x3F,
  0x90, 0x37, 0x77, 0x76, 0x0A, 0xF0, 0xC7, 0x77, 0x76, 0x01, 0xF9, 0x05, 0x77, 0x77, 0x60, 0x8F,
  0x0E, 0x77, 0x77, 0x70, 0xEF, 0x08, 0x77, 0x77, 0x60, 0x6F, 0x90, 0x17, 0x77, 0x76, 0x0C, 0xF0,
  0xA7, 0x77, 0x76, 0x04, 0xF9, 0x04, 0x77, 0x77, 0x60, 0xAF, 0x0C, 0x77, 0x77, 0x60, 0x2F, 0x90,
  0x67, 0x77, 0x30,
  // "8" (U+0038)
  0x77, 0x84, 0x26, 0x9B, 0xDE, 0xA8, 0x4E, 0xDB, 0x96, 0x37, 0x77, 0x48, 0x12, 0x8D, 0xFF, 0x81,
  0xE8, 0x37, 0x76, 0x03, 0x0B, 0xFF, 0xE0, 0xB0, 0x37, 0x73, 0x08, 0xFF, 0xFB, 0x09, 0x77, 0x01,
  0x0C, 0xFF, 0xFD, 0x0C, 0x01, 0x74, 0x01, 0x0D, 0xFF, 0xFF, 0x0D, 0x01, 0x73, 0x0C, 0xFC, 0x86,
  0xDB, 0x98, 0x9A, 0xBE, 0xFC, 0x0C, 0x72, 0x09, 0xFA, 0x81, 0xD7, 0x17, 0x18, 0x12, 0x8E, 0xFA,
  0x08, 0x70, 0x3F, 0xA0, 0x77, 0x70, 0x9F, 0xA0, 0x26, 0x0A, 0xF9, 0x04, 0x77, 0x20, 0x6F, 0x90,
  0x95, 0x01, 0xF9, 0x06, 0x77, 0x40, 0x8F, 0x0E, 0x50, 0x5F, 0x0C, 0x77, 0x60, 0xEF, 0x03, 0x40,
  0x8F, 0x07, 0x77, 0x60, 0x9F, 0x07, 0x40, 0xAF, 0x03, 0x77, 0x60, 0x4F, 0x09, 0x40, 0xBF, 0x01,
  0x77, 0x60, 0x3F, 0x0A, 0x40, 0xCF, 0x77, 0x70, 0x2F, 0x0A, 0x40, 0xBF, 0x01, 0x77, 0x60, 0x3F,
  0x09, 0x40, 0xAF, 0x03, 0x77, 0x60, 0x4F, 0x08, 0x40, 0x7F, 0x06, 0x77, 0x60, 0x8F, 0x06, 0x40,
  0x4F, 0x0B, 0x77, 0x60, 0xCF, 0x02, 0x50, 0xEF, 0x04, 0x77, 0x40, 0x5F, 0x0D, 0x60, 0x9F, 0x0D,
  0x01, 0x77, 0x20, 0x10, 0xDF, 0x07, 0x60, 0x2F, 0x90, 0xC7, 0x72, 0x0C, 0xF0, 0xE7, 0x10, 0x8F,
  0x90, 0xC0, 0x17, 0x50, 0x10, 0xCF, 0x90, 0x67, 0x20, 0xCF, 0x90, 0xE0, 0x47, 0x30, 0x40, 0xEF,
  0x90, 0x97, 0x30, 0x20, 0xEF, 0xA0, 0xA0, 0x26, 0x01, 0x0A, 0xFA, 0x0B, 0x75, 0x02, 0x0E, 0xFB,
  0x08, 0x01, 0x30, 0x70, 0xEF, 0xA0, 0xA7, 0x70, 0x20, 0xEF, 0xC8, 0x19, 0x7E, 0xFB, 0x08, 0x77,
  0x20, 0x20, 0xDF, 0xFF, 0x0E, 0x04, 0x77, 0x50, 0xAF, 0xFD, 0x09, 0x01, 0x77, 0x70, 0x60, 0xEF,
  0xF9, 0x0A, 0x02, 0x77, 0x73, 0x03, 0x0E, 0xFE, 0x0D, 0x04, 0x77, 0x72, 0x81, 0x18, 0xEF, 0xFA,
  0x0B, 0x03, 0x77, 0x60, 0x60, 0xEF, 0xFE, 0x09, 0x77, 0x30, 0x10, 0xBF, 0xB0, 0xB0, 0xDF, 0xC0,
  0xD0, 0x37, 0x70, 0x40, 0xEF, 0xA0, 0xB0, 0x32, 0x06, 0x0D, 0xFC, 0x08, 0x75, 0x06, 0xFA, 0x0D,
  0x04, 0x60, 0x60, 0xEF, 0xB0, 0xB0, 0x17, 0x20, 0x6F, 0xA0, 0x97, 0x30, 0x8F, 0xB0, 0xC0, 0x17,
  0x04, 0xF9, 0x0E, 0x05, 0x75, 0x02, 0x0B, 0xFA, 0x0C, 0x60, 0x10, 0xEF, 0x0E, 0x03, 0x77, 0x10,
  0x60, 0xEF, 0x90, 0xA5, 0x0A, 0xF0, 0xE0, 0x37, 0x73, 0x02, 0x0D, 0xF9, 0x05, 0x30, 0x3F, 0x90,
  0x57, 0x75, 0x01, 0x0D, 0xF0, 0xE3, 0x0A, 0xF0, 0xA7, 0x77, 0x01, 0x0E, 0xF0, 0x72, 0xF9, 0x03,
  0x77, 0x71, 0x05, 0xF8, 0x1D, 0x05, 0xF0, 0xC7, 0x77, 0x30, 0xDF, 0x03, 0x08, 0xF0, 0x77, 0x77,
  0x30, 0x7F, 0x06, 0x0B, 0xF0, 0x47, 0x77, 0x30, 0x3F, 0x09, 0x0C, 0xF0, 0x27, 0x77, 0x30, 0x2F,
  0x0B, 0x0D, 0xF0, 0x17, 0x77, 0x30, 0x1F, 0x0B, 0x0D, 0xF0, 0x17, 0x77, 0x30, 0x2F, 0x0B, 0x0C,
  0xF0, 0x27, 0x77, 0x30, 0x3F, 0x0A, 0x0B, 0xF0, 0x57, 0x77, 0x30, 0x7F, 0x09, 0x08, 0xF0, 0x97,
  0x77, 0x30, 0xCF, 0x00, 0x5F, 0x0E, 0x01, 0x77, 0x71, 0x04, 0xF9, 0x02, 0x01, 0xF9, 0x08, 0x77,
  0x71, 0x0C, 0xF0, 0xC2, 0x0B, 0xF9, 0x04, 0x77, 0x60, 0xAF, 0x90, 0x62, 0x04, 0xF9, 0x0E, 0x03,
  0x77, 0x40, 0x9F, 0x90, 0xD4, 0x0B, 0xFA, 0x07, 0x77, 0x10, 0x30, 0xCF, 0xA0, 0x44, 0x02, 0x0E,
  0xFA, 0x81, 0xE7, 0x37, 0x28, 0x11, 0x5B, 0xFB, 0x09, 0x60, 0x4F, 0xD8, 0x7E, 0xCA, 0x98, 0x9A,
  0xBD, 0xFD, 0x0B, 0x71, 0x05, 0xFF, 0xFF, 0xB0, 0xB7, 0x30, 0x40, 0xEF, 0xFF, 0xF0, 0x97, 0x50,
  0x10, 0xBF, 0xFF, 0xC0, 0xD0, 0x47, 0x71, 0x04, 0x0C, 0xFF, 0xF0, 0xE0, 0x77, 0x75, 0x81, 0x39,
  0xEF, 0xF9, 0x81, 0xEB, 0x57, 0x77, 0x38, 0x43, 0x69, 0xBD, 0xEA, 0x85, 0xEE, 0xDB, 0x97, 0x37,
  0x70,
  // "9" (U+0039)
  0x77, 0x89, 0x41, 0x58, 0xBD, 0xEE, 0xFE, 0xDC, 0xA7, 0x37, 0x77, 0x68, 0x11, 0x7C, 0xFF, 0x81,
  0xE9, 0x37, 0x77, 0x20, 0x80, 0xEF, 0xFD, 0x0B, 0x02, 0x77, 0x50, 0x40, 0xEF, 0xFF, 0xA0, 0x87,
  0x73, 0x08, 0xFF, 0xFD, 0x0C, 0x01, 0x77, 0x0A, 0xFF, 0xFF, 0x0D, 0x01, 0x75, 0x09, 0xFD, 0x85,
  0xCA, 0x98, 0x9A, 0xDF, 0xC0, 0xD0, 0x17, 0x30, 0x7F, 0xB0, 0xA0, 0x47, 0x18, 0x12, 0x7E, 0xFA,
  0x0B, 0x72, 0x03, 0xFA, 0x0B, 0x02, 0x76, 0x09, 0xFA, 0x06, 0x71, 0x0C, 0xF9, 0x08, 0x77, 0x20,
  0x40, 0xEF, 0x90, 0x26, 0x05, 0xF9, 0x07, 0x77, 0x40, 0x30, 0xEF, 0x0A, 0x60, 0xCF, 0x0A, 0x77,
  0x60, 0x4F, 0x90, 0x24, 0x02, 0xF0, 0xE0, 0x17, 0x77, 0x08, 0xF0, 0xA4, 0x07, 0xF0, 0x87, 0x77,
  0x20, 0xDF, 0x01, 0x30, 0xCF, 0x02, 0x77, 0x72, 0x05, 0xF0, 0x63, 0xF0, 0xD7, 0x77, 0x40, 0xDE,
  0x0B, 0x20, 0x3F, 0x09, 0x77, 0x74, 0x07, 0xF8, 0x11, 0x05, 0xF0, 0x67, 0x77, 0x40, 0x2F, 0x81,
  0x40, 0x7F, 0x04, 0x77, 0x75, 0x0D, 0xE8, 0x17, 0x08, 0xF0, 0x37, 0x77, 0x50, 0xAE, 0x81, 0xB0,
  0x8F, 0x02, 0x77, 0x75, 0x08, 0xE8, 0x1E, 0x09, 0xF0, 0x27, 0x77, 0x50, 0x7F, 0x10, 0x8F, 0x03,
  0x77, 0x75, 0x06, 0xF0, 0x20, 0x7F, 0x04, 0x77, 0x75, 0x07, 0xF0, 0x30, 0x6F, 0x05, 0x77, 0x75,
  0x0A, 0xF0, 0x50, 0x4F, 0x08, 0x77, 0x75, 0x0D, 0xF0, 0x60, 0x2F, 0x0C, 0x77, 0x74, 0x03, 0xF9,
  0x81, 0x70, 0xEF, 0x01, 0x77, 0x73, 0x0A, 0xF9, 0x81, 0x70, 0xAF, 0x07, 0x77, 0x72, 0x03, 0xFA,
  0x81, 0x80, 0x6F, 0x0D, 0x77, 0x71, 0x01, 0x0D, 0xFA, 0x82, 0x80, 0x1E, 0xF0, 0x97, 0x77, 0x0B,
  0xFB, 0x08, 0x20, 0x9F, 0x90, 0x67, 0x74, 0x01, 0x0B, 0xFC, 0x08, 0x20, 0x1F, 0xA0, 0x87, 0x72,
  0x04, 0x0D, 0xFD, 0x07, 0x30, 0x8F, 0xA0, 0xC0, 0x47, 0x50, 0x40, 0xBD, 0x0E, 0x0A, 0xF0, 0x74,
  0x0C, 0xFB, 0x83, 0xD9, 0x52, 0x12, 0x83, 0x13, 0x59, 0xDF, 0x05, 0x07, 0xF0, 0x64, 0x01, 0x0D,
  0xFF, 0xFE, 0x81, 0x90, 0x9F, 0x05, 0x50, 0x20, 0xDF, 0xFF, 0xC0, 0xB2, 0x0A, 0xF0, 0x36, 0x01,
  0x0C, 0xFF, 0xFA, 0x0A, 0x30, 0xBF, 0x01, 0x71, 0x08, 0xFF, 0xF0, 0x64, 0x0D, 0xF7, 0x30, 0x20,
  0x9F, 0xFB, 0x0A, 0x02, 0x5F, 0x0E, 0x75, 0x82, 0x16, 0xBE, 0xFB, 0x81, 0xD8, 0x26, 0x02, 0xF0,
  0xB7, 0x72, 0x89, 0x02, 0x46, 0x78, 0x87, 0x64, 0x17, 0x20, 0x5F, 0x09, 0x77, 0x77, 0x70, 0x8F,
  0x06, 0x77, 0x77, 0x70, 0xBF, 0x02, 0x77, 0x77, 0x7F, 0x0E, 0x77, 0x77, 0x70, 0x5F, 0x0A, 0x77,
  0x77, 0x70, 0xAF, 0x06, 0x77, 0x77, 0x60, 0x1F, 0x90, 0x17, 0x77, 0x76, 0x07, 0xF0, 0xB7, 0x77,
  0x77, 0x0E, 0xF0, 0x57, 0x77, 0x76, 0x08, 0xF0, 0xE7, 0x77, 0x76, 0x02, 0xF9, 0x07, 0x77, 0x77,
  0x60, 0xCF, 0x0E, 0x77, 0x77, 0x60, 0x9F, 0x90, 0x67, 0x77, 0x75, 0x09, 0xF9, 0x0C, 0x77, 0x77,
  0x50, 0xAF, 0xA0, 0x27, 0x77, 0x73, 0x04, 0x0D, 0xFA, 0x06, 0x77, 0x77, 0x20, 0x30, 0xBF, 0xB0,
  0x97, 0x78, 0x13, 0x51, 0x74, 0x81, 0x38, 0xDF, 0xC0, 0xA7, 0x71, 0x06, 0xA8, 0x90, 0xEC, 0xA9,
  0x88, 0x9A, 0xBD, 0xFF, 0x0A, 0x77, 0x20, 0x6F, 0xFF, 0xC0, 0x77, 0x73, 0x06, 0xFF, 0xFA, 0x0D,
  0x04, 0x77, 0x40, 0x6F, 0xFF, 0x0E, 0x07, 0x77, 0x60, 0x6F, 0xFD, 0x81, 0xE7, 0x17, 0x77, 0x06,
  0xFF, 0xA8, 0x1E, 0xA4, 0x77, 0x73, 0x86, 0x16, 0x8A, 0xCD, 0xEE, 0xA8, 0x5E, 0xDC, 0xA8, 0x62,
  0x77, 0x70,
  // ":" (U+003A)
  0x38, 0x57, 0xCE, 0xFD, 0x81, 0x30, 0x10, 0xDE, 0x0E, 0x03, 0x20, 0xBF, 0x98, 0x1D, 0x02, 0xFB,
  0x04, 0x05, 0xFB, 0x00, 0x7F, 0xB0, 0x80, 0x7F, 0xB0, 0x80, 0x5F, 0xB0, 0x70, 0x2F, 0xB8, 0x13,
  0x0A, 0xF9, 0x0C, 0x20, 0x10, 0xCE, 0x0D, 0x02, 0x48, 0x57, 0xCE, 0xFD, 0x81, 0x80, 0xCF, 0x00,
  0x86, 0x18, 0xCE, 0xEC, 0x71, 0x30, 0x20, 0xEE, 0x0D, 0x02, 0x20, 0xDF, 0x98, 0x1C, 0x03, 0xFB,
  0x02, 0x07, 0xFB, 0x05, 0x08, 0xFB, 0x07, 0x08, 0xFB, 0x06, 0x07, 0xFB, 0x05, 0x03, 0xFB, 0x81,
  0x20, 0xCF, 0x90, 0xB2, 0x02, 0x0D, 0xE0, 0xD0, 0x14, 0x84, 0x7C, 0xEE, 0xC7, 0x30,
  // ";" (U+003B)
  0x78, 0x57, 0xCE, 0xEC, 0x81, 0x70, 0x20, 0xDE, 0x0E, 0x03, 0x60, 0xCF, 0x90, 0xD5, 0x02, 0xFB,
  0x05, 0x40, 0x6F, 0xB0, 0x84, 0x07, 0xFB, 0x09, 0x40, 0x7F, 0xB0, 0x94, 0x06, 0xFB, 0x08, 0x40,
  0x2F, 0xB0, 0x45, 0x0B, 0xF9, 0x0D, 0x60, 0x10, 0xCE, 0x0D, 0x02, 0x71, 0x85, 0x7C, 0xEF, 0xC8,
  0x18, 0x0E, 0xA2, 0x00, 0x3F, 0xA0, 0xC5, 0x05, 0xFB, 0x01, 0x40, 0x8F, 0xA0, 0xC5, 0x0A, 0xFA,
  0x08, 0x50, 0xDF, 0xA0, 0x35, 0xFA, 0x0D, 0x50, 0x3F, 0xA0, 0x95, 0x06, 0xFA, 0x03, 0x50, 0x9F,
  0x90, 0xD6, 0x0C, 0xF9, 0x08, 0x6F, 0xA0, 0x25, 0x03, 0xF9, 0x0C, 0x60, 0x6F, 0x90, 0x66, 0x09,
  0xF9, 0x01, 0x60, 0xDF, 0x09, 0x7F, 0x90, 0x36, 0x04, 0xF0, 0xD7, 0x07, 0xF0, 0x67, 0x0B, 0xE0,
  0xE0, 0x17, 0x0E, 0xE0, 0x97, 0x02, 0xF0, 0x27, 0x06, 0xE0, 0xB7, 0x10, 0xAE, 0x04, 0x71, 0x0D,
  0xD0, 0xD7, 0x20,
  // "<" (U+003C)
  0x80, 0xC1, 0x00, 0x67, 0x77, 0x77, 0x81, 0x5D, 0xE7, 0x77, 0x75, 0x03, 0x0C, 0xA0, 0xE7, 0x77,
  0x73, 0x02, 0x0A, 0xC0, 0xE7, 0x77, 0x71, 0x01, 0x08, 0xE0, 0xE7, 0x77, 0x70, 0x70, 0xEF, 0x0E,
  0x77, 0x75, 0x05, 0x0D, 0xFA, 0x0E, 0x77, 0x73, 0x03, 0x0C, 0xFB, 0x0E, 0x07, 0x77, 0x71, 0x01,
  0x0A, 0xFC, 0x09, 0x01, 0x77, 0x71, 0x08, 0xFC, 0x0B, 0x02, 0x77, 0x71, 0x06, 0x0E, 0xFB, 0x0C,
  0x04, 0x77, 0x71, 0x04, 0x0D, 0xFB, 0x0D, 0x05, 0x77, 0x71, 0x02, 0x0B, 0xFB, 0x0E, 0x07, 0x77,
  0x71, 0x01, 0x09, 0xFC, 0x08, 0x01, 0x77, 0x71, 0x07, 0x0E, 0xFB, 0x0A, 0x02, 0x77, 0x71, 0x05,
  0x0D, 0xFB, 0x0B, 0x03, 0x77, 0x71, 0x04, 0x0C, 0xFB, 0x0D, 0x04, 0x77, 0x71, 0x02, 0x0A, 0xFB,
  0x0E, 0x06, 0x77, 0x71, 0x01, 0x09, 0xFB, 0x0E, 0x07, 0x77, 0x72, 0x07, 0x0E, 0xFB, 0x09, 0x01,
  0x77, 0x71, 0x05, 0x0D, 0xFB, 0x0A, 0x02, 0x77, 0x72, 0x0B, 0xFB, 0x0C, 0x03, 0x77, 0x74, 0x0E,
  0xF9, 0x0D, 0x05, 0x77, 0x76, 0x0E, 0xF0, 0xD0, 0x27, 0x77, 0x70, 0xEF, 0xA0, 0xA0, 0x27, 0x77,
  0x50, 0xDF, 0xC0, 0xA0, 0x37, 0x77, 0x30, 0x20, 0x9F, 0xD0, 0xB0, 0x37, 0x77, 0x30, 0x20, 0x9F,
  0xD0, 0xB0, 0x47, 0x77, 0x30, 0x10, 0x9F, 0xD0, 0xC0, 0x57, 0x77, 0x30, 0x10, 0x9F, 0xD0, 0xC0,
  0x57, 0x77, 0x30, 0x10, 0x8F, 0xD0, 0xD0, 0x67, 0x77, 0x38, 0x11, 0x8E, 0xFC, 0x0D, 0x06, 0x77,
  0x73, 0x81, 0x18, 0xEF, 0xC0, 0xE0, 0x77, 0x77, 0x38, 0x11, 0x8E, 0xFC, 0x81, 0xE7, 0x17, 0x77,
  0x28, 0x11, 0x7E, 0xFC, 0x81, 0xE8, 0x17, 0x77, 0x28, 0x11, 0x7E, 0xFD, 0x08, 0x01, 0x77, 0x73,
  0x07, 0x0E, 0xFD, 0x09, 0x02, 0x77, 0x73, 0x07, 0x0E, 0xFD, 0x09, 0x77, 0x74, 0x07, 0x0E, 0xFB,
  0x0E, 0x77, 0x76, 0x06, 0x0D, 0xF9, 0x0E, 0x77, 0x77, 0x10, 0x60, 0xDE, 0x0E, 0x77, 0x77, 0x30,
  0x60, 0xDC, 0x0E, 0x77, 0x77, 0x50, 0x60, 0xDA, 0x0E, 0x77, 0x77, 0x78, 0x15, 0xDE, 0x80, 0xC1,
  0x00, 0x40,
  // "=" (U+003D)
  0x0A, 0x80, 0xC4, 0xF0, 0x0A, 0x80, 0xC4, 0xF0, 0x0A, 0x80, 0xC4, 0xF0, 0x0A, 0x80, 0xC4, 0xF0,
  0x0A, 0x80, 0xC4, 0xF0, 0x0A, 0x80, 0xC4, 0xF0, 0x0A, 0x80, 0xC4, 0xF0, 0xA8, 0x0E, 0xC0, 0x00,
  0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x00,
  0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x0A,
  // ">" (U+003E)
  0x06, 0x80, 0xC1, 0x08, 0x1E, 0xD5, 0x77, 0x77, 0x70, 0xEA, 0x0C, 0x03, 0x77, 0x77, 0x50, 0xEC,
  0x0A, 0x02, 0x77, 0x77, 0x30, 0xEE, 0x08, 0x01, 0x77, 0x77, 0x10, 0xEF, 0x0E, 0x07, 0x77, 0x77,
  0x0E, 0xFA, 0x0D, 0x05, 0x77, 0x75, 0x07, 0x0E, 0xFB, 0x0C, 0x03, 0x77, 0x74, 0x01, 0x09, 0xFC,
  0x0A, 0x01, 0x77, 0x74, 0x02, 0x0B, 0xFC, 0x08, 0x77, 0x75, 0x04, 0x0C, 0xFB, 0x0E, 0x06, 0x77,
  0x75, 0x05, 0x0D, 0xFB, 0x0D, 0x04, 0x77, 0x75, 0x07, 0x0E, 0xFB, 0x0B, 0x02, 0x77, 0x74, 0x01,
  0x08, 0xFC, 0x09, 0x01, 0x77, 0x74, 0x02, 0x0A, 0xFB, 0x0E, 0x07, 0x77, 0x75, 0x03, 0x0B, 0xFB,
  0x0D, 0x05, 0x77, 0x75, 0x04, 0x0D, 0xFB, 0x0C, 0x04, 0x77, 0x75, 0x06, 0x0E, 0xFB, 0x0A, 0x02,
  0x77, 0x75, 0x07, 0x0E, 0xFB, 0x09, 0x01, 0x77, 0x74, 0x01, 0x09, 0xFB, 0x0E, 0x07, 0x77, 0x75,
  0x02, 0x0A, 0xFB, 0x0D, 0x05, 0x77, 0x75, 0x03, 0x0C, 0xFB, 0x0B, 0x77, 0x76, 0x05, 0x0D, 0xF9,
  0x0E, 0x77, 0x77, 0x02, 0x0D, 0xF0, 0xE7, 0x77, 0x50, 0x20, 0xAF, 0xA0, 0xE7, 0x77, 0x30, 0x30,
  0xAF, 0xC0, 0xD7, 0x77, 0x10, 0x30, 0xBF, 0xD0, 0x90, 0x27, 0x76, 0x04, 0x0B, 0xFD, 0x09, 0x02,
  0x77, 0x60, 0x50, 0xCF, 0xD0, 0x90, 0x17, 0x76, 0x05, 0x0C, 0xFD, 0x09, 0x01, 0x77, 0x60, 0x60,
  0xDF, 0xD0, 0x80, 0x17, 0x76, 0x06, 0x0D, 0xFC, 0x81, 0xE8, 0x17, 0x76, 0x07, 0x0E, 0xFC, 0x81,
  0xE8, 0x17, 0x75, 0x81, 0x17, 0xEF, 0xC8, 0x1E, 0x81, 0x77, 0x58, 0x11, 0x8E, 0xFC, 0x81, 0xE7,
  0x17, 0x75, 0x01, 0x08, 0xFD, 0x81, 0xE7, 0x17, 0x75, 0x02, 0x09, 0xFD, 0x0E, 0x07, 0x77, 0x70,
  0x9F, 0xD0, 0xE0, 0x77, 0x77, 0x20, 0xEF, 0xB0, 0xE0, 0x77, 0x77, 0x40, 0xEF, 0x90, 0xD0, 0x67,
  0x77, 0x60, 0xEE, 0x0D, 0x06, 0x77, 0x77, 0x10, 0xEC, 0x0D, 0x06, 0x77, 0x77, 0x30, 0xEA, 0x0D,
  0x06, 0x77, 0x77, 0x58, 0x1E, 0xD5, 0x77, 0x77, 0x70, 0x48, 0x0C, 0x10,
  // "?" (U+003F)
  0x72, 0x86, 0x15, 0x79, 0xBD, 0xEE, 0xA8, 0x5E, 0xED, 0xB9, 0x62, 0x77, 0x48, 0x14, 0x9D, 0xFF,
  0xB8, 0x1E, 0x83, 0x75, 0x81, 0x4A, 0xEF, 0xFF, 0xA0, 0xB0, 0x37, 0x81, 0x28, 0xEF, 0xFF, 0xF0,
  0x86, 0x0A, 0xFF, 0xFF, 0xB0, 0xC0, 0x14, 0x03, 0xFF, 0xFF, 0xC0, 0xD0, 0x14, 0x0C, 0xFD, 0x87,
  0xCB, 0x99, 0x89, 0xAB, 0xEF, 0xC0, 0xC4, 0x05, 0xF9, 0x81, 0xA6, 0x27, 0x38, 0x12, 0x8E, 0xFA,
  0x08, 0x40, 0xEC, 0x0B, 0x05, 0x77, 0x30, 0x9F, 0xA0, 0x23, 0x83, 0x7F, 0xE7, 0x17, 0x76, 0x05,
  0xF9, 0x0A, 0x30, 0x10, 0x57, 0x77, 0x30, 0x7F, 0x90, 0x17, 0x77, 0x71, 0x0C, 0xF0, 0x57, 0x77,
  0x71, 0x05, 0xF0, 0x97, 0x77, 0x71, 0x01, 0xF0, 0xB7, 0x77, 0x72, 0x0D, 0xE0, 0xD7, 0x77, 0x72,
  0x0C, 0xE0, 0xD7, 0x77, 0x72, 0x0C, 0xE0, 0xD7, 0x77, 0x72, 0x0C, 0xE0, 0xD7, 0x77, 0x72, 0x0E,
  0xE0, 0xB7, 0x77, 0x71, 0x01, 0xF0, 0xA7, 0x77, 0x71, 0x05, 0xF0, 0x77, 0x77, 0x71, 0x0A, 0xF0,
  0x47, 0x77, 0x70, 0x1F, 0x0E, 0x77, 0x77, 0x10, 0xAF, 0x09, 0x77, 0x77, 0x05, 0xF9, 0x03, 0x77,
  0x76, 0x03, 0xF9, 0x0B, 0x77, 0x76, 0x04, 0x0E, 0xF9, 0x02, 0x77, 0x75, 0x05, 0xFA, 0x06, 0x77,
  0x75, 0x08, 0xFA, 0x09, 0x77, 0x74, 0x01, 0x0C, 0xFA, 0x0A, 0x77, 0x74, 0x04, 0x0E, 0xFA, 0x0A,
  0x77, 0x74, 0x07, 0xFB, 0x08, 0x77, 0x74, 0x09, 0xFB, 0x06, 0x77, 0x74, 0x0A, 0xFA, 0x0D, 0x03,
  0x77, 0x74, 0x09, 0xFA, 0x0B, 0x01, 0x77, 0x74, 0x06, 0xFA, 0x08, 0x77, 0x75, 0x02, 0xFA, 0x05,
  0x77, 0x76, 0x0A, 0xF9, 0x04, 0x77, 0x76, 0x02, 0xF9, 0x04, 0x77, 0x77, 0x07, 0xF0, 0x77, 0x77,
  0x71, 0x0B, 0xE0, 0xC7, 0x77, 0x72, 0x0E, 0xE0, 0x57, 0x77, 0x71, 0x01, 0xF0, 0x17, 0x77, 0x71,
  0x02, 0xE0, 0xE7, 0x77, 0x72, 0x03, 0xE0, 0xC7, 0x77, 0x72, 0x04, 0xE0, 0xB7, 0x77, 0x72, 0x04,
  0xE0, 0xB7, 0x77, 0x73, 0x80, 0x21, 0x80, 0xC8, 0x00, 0x85, 0x3A, 0xDF, 0xEB, 0x47, 0x77, 0x72,
  0x08, 0xF0, 0x97, 0x77, 0x70, 0x4F, 0xA0, 0x67, 0x77, 0x60, 0xAF, 0xA0, 0xC7, 0x77, 0x60, 0xDF,
  0xB7, 0x77, 0x6F, 0xC0, 0x17, 0x77, 0x5F, 0xC0, 0x17, 0x77, 0x50, 0xDF, 0xB7, 0x77, 0x60, 0xAF,
  0xA0, 0xC7, 0x77, 0x60, 0x3F, 0xA0, 0x57, 0x77, 0x70, 0x6F, 0x08, 0x77, 0x77, 0x28, 0x53, 0xAD,
  0xFE, 0xA4, 0x77, 0x40,
  // "@" (U+0040)
  0x77, 0x68, 0x94, 0x14, 0x7A, 0xCE, 0xEF, 0xED, 0xCA, 0x73, 0x80, 0xC0, 0x00, 0x60, 0xBF, 0xF8,
  0x1E, 0x93, 0x77, 0x77, 0x28, 0x11, 0x7E, 0xFF, 0xD0, 0xC0, 0x37, 0x77, 0x60, 0x50, 0xEF, 0xFF,
  0xA0, 0x90, 0x17, 0x77, 0x30, 0xAF, 0xFF, 0xD0, 0xD0, 0x27, 0x77, 0x01, 0x0C, 0xFF, 0xFF, 0x0E,
  0x04, 0x77, 0x50, 0x10, 0xDF, 0xD8, 0x5C, 0xB9, 0x89, 0xAC, 0xFD, 0x04, 0x77, 0x30, 0x20, 0xDF,
  0xA8, 0x1D, 0x73, 0x72, 0x04, 0x09, 0xFA, 0x0E, 0x02, 0x77, 0x20, 0xCF, 0x90, 0xC0, 0x57, 0x70,
  0x10, 0x9F, 0x90, 0xD0, 0x17, 0x70, 0x9F, 0x90, 0x77, 0x74, 0x03, 0x0D, 0xF0, 0xA7, 0x60, 0x6F,
  0x0D, 0x03, 0x77, 0x60, 0x10, 0xCF, 0x04, 0x74, 0x01, 0x0E, 0xE0, 0xD0, 0x27, 0x77, 0x10, 0x10,
  0xCE, 0x0D, 0x74, 0x0A, 0xE0, 0xD0, 0x17, 0x77, 0x30, 0x10, 0xDE, 0x06, 0x72, 0x03, 0xF0, 0x37,
  0x77, 0x50, 0x3E, 0x0D, 0x72, 0x0C, 0xE0, 0x67, 0x77, 0x70, 0x8E, 0x06, 0x70, 0x3E, 0x0B, 0x77,
  0x77, 0x20, 0xED, 0x0C, 0x70, 0xAE, 0x02, 0x77, 0x77, 0x20, 0x6E, 0x02, 0x50, 0x1E, 0x09, 0x77,
  0x77, 0x40, 0xED, 0x07, 0x50, 0x8E, 0x02, 0x75, 0x89, 0x25, 0x9C, 0xEF, 0xEE, 0xDB, 0x86, 0x37,
  0x10, 0x8D, 0x0D, 0x50, 0xDD, 0x0B, 0x74, 0x08, 0x0E, 0xFD, 0x82, 0xEA, 0x51, 0x40, 0x3E, 0x01,
  0x30, 0x2E, 0x04, 0x72, 0x04, 0x0D, 0xFF, 0xB0, 0xE0, 0x14, 0x0D, 0xD0, 0x53, 0x07, 0xD0, 0xE7,
  0x20, 0x6F, 0xFE, 0x01, 0x40, 0x9D, 0x08, 0x30, 0xBD, 0x09, 0x71, 0x06, 0xFF, 0xF5, 0x05, 0xD0,
  0xC3, 0xE0, 0x57, 0x04, 0xFF, 0xF0, 0xE5, 0x02, 0xD0, 0xE2, 0x03, 0xE0, 0x16, 0x01, 0x0E, 0xF8,
  0x6B, 0x51, 0x01, 0x37, 0xCE, 0x0E, 0x6E, 0x81, 0x10, 0x6D, 0x0C, 0x70, 0x9F, 0x06, 0x71, 0xE0,
  0xD6, 0x0D, 0xD8, 0x13, 0x09, 0xD0, 0x96, 0x02, 0xF0, 0x77, 0x2E, 0x0C, 0x60, 0xAD, 0x81, 0x50,
  0xCD, 0x07, 0x60, 0x9E, 0x0C, 0x72, 0x01, 0xE0, 0xB6, 0x09, 0xD8, 0x17, 0x0E, 0xD0, 0x46, 0x0E,
  0xE0, 0x47, 0x20, 0x2E, 0x0A, 0x60, 0x8D, 0x07, 0x01, 0xE0, 0x15, 0x05, 0xE0, 0xD7, 0x30, 0x3E,
  0x09, 0x60, 0x7D, 0x08, 0x03, 0xE6, 0x0A, 0xE0, 0x77, 0x30, 0x4E, 0x09, 0x60, 0x6D, 0x09, 0x04,
  0xD0, 0xD6, 0x0D, 0xE0, 0x37, 0x30, 0x5E, 0x08, 0x60, 0x6D, 0x09, 0x06, 0xD0, 0xC5, 0x01, 0xF7,
  0x40, 0x6E, 0x07, 0x60, 0x5D, 0x0A, 0x07, 0xD0, 0xB5, 0x03, 0xE0, 0xD7, 0x40, 0x7E, 0x06, 0x60,
  0x6D, 0x09, 0x08, 0xD0, 0xA5, 0x05, 0xE0, 0xA7, 0x40, 0x8E, 0x05, 0x60, 0x6D, 0x09, 0x08, 0xD0,
  0x95, 0x07, 0xE0, 0x97, 0x40, 0x9E, 0x04, 0x60, 0x7D, 0x08, 0x09, 0xD0, 0x95, 0x08, 0xE0, 0x87,
  0x40, 0xAE, 0x03, 0x60, 0x7D, 0x07, 0x09, 0xD0, 0x85, 0x08, 0xE0, 0x77, 0x40, 0xBE, 0x03, 0x60,
  0x8D, 0x06, 0x09, 0xD0, 0x85, 0x08, 0xE0, 0x67, 0x40, 0xCE, 0x02, 0x60, 0x9D, 0x04, 0x09, 0xD0,
  0x95, 0x08, 0xE0, 0x77, 0x40, 0xEE, 0x01, 0x60, 0xAD, 0x02, 0x08, 0xD0, 0x95, 0x07, 0xE0, 0x87,
  0x30, 0x1F, 0x01, 0x60, 0xBD, 0x01, 0x08, 0xD0, 0xA5, 0x06, 0xE0, 0x97, 0x30, 0x4F, 0x01, 0x60,
  0xDC, 0x81, 0xD0, 0x7D, 0x0B, 0x50, 0x4E, 0x0B, 0x73, 0x08, 0xF0, 0x16, 0xD8, 0x1A, 0x06, 0xD0,
  0xD5, 0x01, 0xE0, 0xE7, 0x30, 0xBF, 0x01, 0x50, 0x3D, 0x81, 0x70, 0x4D, 0x0E, 0x60, 0xEE, 0x02,
  0x71, 0x01, 0xF9, 0x03, 0x50, 0x7D, 0x81, 0x40, 0x2E, 0x01, 0x50, 0xAE, 0x07, 0x71, 0x06, 0xF9,
  0x05, 0x50, 0xBC, 0x0E, 0x3E, 0x03, 0x50, 0x5E, 0x0E, 0x01, 0x70, 0xDF, 0x90, 0x94, 0x01, 0xD0,
  0xA3, 0x0E, 0xD0, 0x66, 0xF0, 0xB6, 0x09, 0xC0, 0x90, 0xCB, 0x0E, 0x01, 0x30, 0x9D, 0x05, 0x30,
  0xBD, 0x0A, 0x60, 0x8F, 0x84, 0xC4, 0x11, 0x4B, 0xD0, 0x20, 0x8C, 0x82, 0xC2, 0x07, 0xD0, 0xE4,
  0x08, 0xD0, 0xD6, 0x01, 0x0E, 0xFF, 0xA8, 0x19, 0x03, 0xFE, 0x08, 0x40, 0x4E, 0x02, 0x60, 0x7F,
  0xF9, 0x0D, 0x01, 0x20, 0xCF, 0xC0, 0xE0, 0x14, 0x01, 0xE0, 0x77, 0x0B, 0xFF, 0x03, 0x30, 0x5F,
  0xC0, 0x56, 0x0D, 0xD0, 0xC7, 0x10, 0xBF, 0xC0, 0xE0, 0x45, 0x0B, 0xFA, 0x07, 0x70, 0x8E, 0x02,
  0x71, 0x08, 0xFA, 0x0C, 0x02, 0x70, 0xCF, 0x07, 0x71, 0x02, 0xE0, 0x97, 0x28, 0x71, 0x7B, 0xEF,
  0xED, 0x94, 0x73, 0x85, 0x6C, 0xEE, 0xD9, 0x27, 0x30, 0xDE, 0x01, 0x80, 0xD0, 0x00, 0x7E, 0x09,
  0x80, 0xD0, 0x00, 0x10, 0xEE, 0x03, 0x80, 0xD0, 0x00, 0x8E, 0x0C, 0x80, 0xD0, 0x00, 0x1F, 0x09,
  0x80, 0xD0, 0x00, 0x8F, 0x06, 0x80, 0xD0, 0x00, 0xDF, 0x06, 0x80, 0xC7, 0x00, 0x3F, 0x90, 0x88,
  0x0C, 0x70, 0x08, 0xF9, 0x0C, 0x03, 0x77, 0x73, 0x06, 0x07, 0x77, 0x20, 0xAF, 0xA0, 0xA0, 0x37,
  0x75, 0x83, 0x49, 0xEF, 0x97, 0x73, 0x0B, 0xFB, 0x81, 0xC7, 0x37, 0x48, 0x21, 0x47, 0xBD, 0x09,
  0x77, 0x40, 0xBF, 0xE8, 0x90, 0xDB, 0x99, 0x89, 0xAB, 0xCE, 0xFA, 0x09, 0x77, 0x50, 0x8F, 0xFF,
  0xFB, 0x09, 0x77, 0x60, 0x50, 0xEF, 0xFF, 0xF9, 0x09, 0x77, 0x70, 0x10, 0xAF, 0xFF, 0xE0, 0xA0,
  0x27, 0x77, 0x20, 0x30, 0xBF, 0xFF, 0x98, 0x1E, 0x92, 0x77, 0x76, 0x81, 0x27, 0xCF, 0xFA, 0x81,
  0xEA, 0x57, 0x77, 0x75, 0x85, 0x15, 0x8A, 0xCD, 0xEA, 0x85, 0xEE, 0xDB, 0x96, 0x37, 0x72,
  // "A" (U+0041)
  0x77, 0x70, 0x7F, 0x90, 0x68, 0x0C, 0x60, 0x0C, 0xF9, 0x0B, 0x80, 0xC5, 0x00, 0x2F, 0xB0, 0x18,
  0x0C, 0x40, 0x07, 0xFB, 0x05, 0x80, 0xC4, 0x00, 0xCF, 0xB0, 0xB8, 0x0C, 0x30, 0x01, 0xFD, 0x80,
  0xC3, 0x00, 0x6F, 0xD0, 0x58, 0x0C, 0x20, 0x0B, 0xFD, 0x0A, 0x80, 0xC1, 0x00, 0x1E, 0x0E, 0xF8,
  0x0C, 0x10, 0x06, 0xE0, 0xA0, 0xCE, 0x05, 0x80, 0xC0, 0x00, 0xBE, 0x07, 0x08, 0xE0, 0xA7, 0x77,
  0x77, 0x01, 0xF0, 0x30, 0x4E, 0x0E, 0x77, 0x77, 0x70, 0x6E, 0x0E, 0x2F, 0x05, 0x77, 0x77, 0x60,
  0xBE, 0x0A, 0x20, 0xCE, 0x0A, 0x77, 0x77, 0x50, 0x1F, 0x06, 0x20, 0x7E, 0x0E, 0x77, 0x77, 0x50,
  0x5F, 0x01, 0x20, 0x3F, 0x04, 0x77, 0x77, 0x40, 0xAE, 0x0C, 0x40, 0xDE, 0x09, 0x77, 0x77, 0x4F,
  0x07, 0x40, 0x9E, 0x0E, 0x77, 0x77, 0x30, 0x5F, 0x03, 0x40, 0x4F, 0x04, 0x77, 0x77, 0x20, 0xAE,
  0x0D, 0x60, 0xEE, 0x09, 0x77, 0x77, 0x20, 0xEE, 0x08, 0x60, 0xAE, 0x0E, 0x77, 0x77, 0x10, 0x5F,
  0x03, 0x60, 0x5F, 0x04, 0x77, 0x77, 0x0A, 0xE0, 0xE7, 0x1F, 0x09, 0x77, 0x77, 0x0E, 0xE0, 0x97,
  0x10, 0xBE, 0x0E, 0x77, 0x76, 0x04, 0xF0, 0x47, 0x10, 0x6F, 0x04, 0x77, 0x75, 0x09, 0xE0, 0xE7,
  0x20, 0x1F, 0x09, 0x77, 0x75, 0x0E, 0xE0, 0xA7, 0x30, 0xBE, 0x0E, 0x77, 0x74, 0x04, 0xF0, 0x57,
  0x30, 0x7F, 0x03, 0x77, 0x73, 0x09, 0xF0, 0x17, 0x30, 0x2F, 0x08, 0x77, 0x73, 0x0E, 0xE0, 0xB7,
  0x50, 0xCE, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0x67, 0x50, 0x7F, 0x03, 0x77, 0x71, 0x09, 0xF0, 0x17,
  0x50, 0x2F, 0x08, 0x77, 0x71, 0x0E, 0xE0, 0xC7, 0x70, 0xDE, 0x0D, 0x77, 0x70, 0x3F, 0x07, 0x77,
  0x08, 0xF0, 0x37, 0x76, 0x08, 0xF0, 0x27, 0x70, 0x3F, 0x08, 0x77, 0x60, 0xDE, 0x0C, 0x77, 0x20,
  0xEE, 0x0D, 0x77, 0x50, 0x3F, 0x08, 0x77, 0x20, 0x9F, 0x03, 0x77, 0x40, 0x8F, 0xFF, 0xFC, 0x08,
  0x77, 0x40, 0xDF, 0xFF, 0xFC, 0x0D, 0x77, 0x30, 0x3F, 0xFF, 0xFE, 0x02, 0x77, 0x20, 0x8F, 0xFF,
  0xFE, 0x07, 0x77, 0x20, 0xDF, 0xFF, 0xFE, 0x0C, 0x77, 0x10, 0x28, 0x0C, 0x0F, 0x02, 0x77, 0x07,
  0x80, 0xC0, 0xF0, 0x77, 0x70, 0xDE, 0x0E, 0x77, 0x70, 0x1F, 0x0C, 0x76, 0x02, 0xF0, 0xA7, 0x77,
  0x10, 0xBF, 0x02, 0x75, 0x07, 0xF0, 0x57, 0x77, 0x10, 0x6F, 0x07, 0x75, 0x0C, 0xF7, 0x77, 0x20,
  0x2F, 0x0C, 0x74, 0x02, 0xF0, 0xB7, 0x77, 0x30, 0xCF, 0x01, 0x73, 0x07, 0xF0, 0x67, 0x77, 0x30,
  0x8F, 0x07, 0x73, 0x0C, 0xF0, 0x17, 0x77, 0x30, 0x3F, 0x0C, 0x72, 0x01, 0xF0, 0xC7, 0x77, 0x50,
  0xDF, 0x01, 0x71, 0x07, 0xF0, 0x77, 0x77, 0x50, 0x9F, 0x06, 0x71, 0x0C, 0xF0, 0x37, 0x77, 0x50,
  0x4F, 0x0B, 0x70, 0x1F, 0x0D, 0x77, 0x77, 0x0E, 0xF0, 0x16, 0x06, 0xF0, 0x97, 0x77, 0x70, 0xAF,
  0x06, 0x60, 0xBF, 0x04, 0x77, 0x77, 0x05, 0xF0, 0xB5, 0x01, 0xF0, 0xE7, 0x77, 0x71, 0x01, 0xF9,
  0x01, 0x40, 0x6F, 0x0A, 0x77, 0x77, 0x20, 0xBF, 0x06, 0x40, 0xBF, 0x05, 0x77, 0x77, 0x20, 0x7F,
  0x0B, 0x30, 0x1F, 0x90, 0x17, 0x77, 0x72, 0x02, 0xF9, 0x01, 0x20, 0x6F, 0x0B, 0x77, 0x77, 0x40,
  0xDF, 0x05, 0x20, 0xBF, 0x06, 0x77, 0x77, 0x40, 0x8F, 0x81, 0xB0, 0x1F, 0x90, 0x27, 0x77, 0x74,
  0x03, 0xF9, 0x01,
  // "B" (U+0042)
  0x07, 0xFF, 0xC8, 0x6E, 0xED, 0xBA, 0x75, 0x27, 0x70, 0x7F, 0xFF, 0xD8, 0x1D, 0x94, 0x74, 0x07,
  0xFF, 0xFF, 0x90, 0xD0, 0x77, 0x20, 0x7F, 0xFF, 0xFB, 0x0E, 0x06, 0x70, 0x7F, 0xFF, 0xFD, 0x0A,
  0x60, 0x7F, 0xFF, 0xFE, 0x0B, 0x50, 0x7F, 0x09, 0x80, 0x68, 0x82, 0x9A, 0xCE, 0xFE, 0x09, 0x40,
  0x7F, 0x03, 0x77, 0x82, 0x15, 0xAE, 0xFB, 0x04, 0x30, 0x7F, 0x03, 0x77, 0x30, 0x10, 0x9F, 0xA0,
  0xC3, 0x07, 0xF0, 0x37, 0x75, 0x06, 0xFA, 0x03, 0x20, 0x7F, 0x03, 0x77, 0x60, 0x8F, 0x90, 0x82,
  0x07, 0xF0, 0x37, 0x76, 0x01, 0x0E, 0xF0, 0xC2, 0x07, 0xF0, 0x37, 0x77, 0x09, 0xF9, 0x20, 0x7F,
  0x03, 0x77, 0x70, 0x4F, 0x98, 0x11, 0x07, 0xF0, 0x37, 0x77, 0x01, 0xF9, 0x81, 0x20, 0x7F, 0x03,
  0x77, 0x71, 0xF9, 0x81, 0x30, 0x7F, 0x03, 0x77, 0x71, 0x0E, 0xF8, 0x13, 0x07, 0xF0, 0x37, 0x77,
  0x1F, 0x98, 0x12, 0x07, 0xF0, 0x37, 0x77, 0x01, 0xF9, 0x81, 0x10, 0x7F, 0x03, 0x77, 0x70, 0x2F,
  0x0E, 0x20, 0x7F, 0x03, 0x77, 0x70, 0x6F, 0x0A, 0x20, 0x7F, 0x03, 0x77, 0x70, 0xBF, 0x06, 0x20,
  0x7F, 0x03, 0x77, 0x60, 0x2F, 0x90, 0x12, 0x07, 0xF0, 0x37, 0x76, 0x0B, 0xF0, 0x93, 0x07, 0xF0,
  0x37, 0x75, 0x09, 0xF0, 0xE0, 0x13, 0x07, 0xF0, 0x37, 0x73, 0x01, 0x0B, 0xF9, 0x05, 0x40, 0x7F,
  0x03, 0x77, 0x10, 0x40, 0xAF, 0xA0, 0x65, 0x07, 0xF0, 0x98, 0x06, 0x88, 0x29, 0xAB, 0xDF, 0xB0,
  0xE0, 0x56, 0x07, 0xFF, 0xFF, 0xB0, 0xA0, 0x17, 0x07, 0xFF, 0xFF, 0x81, 0xD8, 0x27, 0x20, 0x7F,
  0xFF, 0xD0, 0xD0, 0x27, 0x50, 0x7F, 0xFF, 0xF8, 0x1D, 0x94, 0x72, 0x07, 0xFF, 0xFF, 0xB0, 0xD0,
  0x67, 0x07, 0xFF, 0xFF, 0xD0, 0xE0, 0x55, 0x07, 0xF0, 0x37, 0x58, 0x32, 0x36, 0x9D, 0xFB, 0x09,
  0x40, 0x7F, 0x03, 0x77, 0x30, 0x30, 0xAF, 0xA0, 0xA3, 0x07, 0xF0, 0x37, 0x75, 0x03, 0x0E, 0xF9,
  0x07, 0x20, 0x7F, 0x03, 0x77, 0x60, 0x20, 0xEF, 0x98, 0x13, 0x07, 0xF0, 0x37, 0x77, 0x04, 0xF9,
  0x81, 0xA0, 0x7F, 0x03, 0x77, 0x71, 0x0A, 0xF9, 0x01, 0x07, 0xF0, 0x37, 0x77, 0x10, 0x3F, 0x90,
  0x60, 0x7F, 0x03, 0x77, 0x72, 0x0D, 0xF0, 0xA0, 0x7F, 0x03, 0x77, 0x72, 0x09, 0xF0, 0xC0, 0x7F,
  0x03, 0x77, 0x72, 0x06, 0xF0, 0xE0, 0x7F, 0x03, 0x77, 0x72, 0x05, 0xF9, 0x07, 0xF0, 0x37, 0x77,
  0x20, 0x3F, 0x90, 0x7F, 0x03, 0x77, 0x72, 0x04, 0xF9, 0x07, 0xF0, 0x37, 0x77, 0x20, 0x5F, 0x0E,
  0x07, 0xF0, 0x37, 0x77, 0x20, 0x7F, 0x0D, 0x07, 0xF0, 0x37, 0x77, 0x20, 0xBF, 0x0B, 0x07, 0xF0,
  0x37, 0x77, 0x10, 0x1F, 0x90, 0x07, 0xF0, 0x37, 0x77, 0x10, 0x7F, 0x90, 0x40, 0x7F, 0x03, 0x77,
  0x70, 0x10, 0xEF, 0x81, 0xE0, 0x7F, 0x03, 0x77, 0x70, 0xBF, 0x98, 0x18, 0x07, 0xF0, 0x37, 0x76,
  0x08, 0xFA, 0x81, 0x10, 0x7F, 0x03, 0x77, 0x40, 0x20, 0xBF, 0xA0, 0x82, 0x07, 0xF0, 0x37, 0x71,
  0x81, 0x15, 0xAF, 0xB0, 0xD3, 0x07, 0xF0, 0x98, 0x07, 0x88, 0x29, 0xAB, 0xDF, 0xD0, 0xE0, 0x23,
  0x07, 0xFF, 0xFF, 0xE0, 0xE0, 0x34, 0x07, 0xFF, 0xFF, 0xD0, 0xD0, 0x25, 0x07, 0xFF, 0xFF, 0xC0,
  0xA0, 0x16, 0x07, 0xFF, 0xFF, 0xA0, 0xC0, 0x47, 0x10, 0x7F, 0xFF, 0xE8, 0x1E, 0x93, 0x73, 0x07,
  0xFF, 0xF8, 0x4E, 0xDB, 0x96, 0x37, 0x60,
  // "C" (U+0043)
  0x77, 0x58, 0x97, 0x14, 0x7A, 0xCD, 0xDE, 0xFE, 0xDC, 0xB9, 0x74, 0x17, 0x77, 0x38, 0x11, 0x6B,
  0xFF, 0xB8, 0x1D, 0x94, 0x77, 0x50, 0x20, 0xAF, 0xFF, 0xA8, 0x1E, 0x92, 0x77, 0x01, 0x09, 0xFF,
  0xFF, 0x0B, 0x02, 0x74, 0x04, 0x0E, 0xFF, 0xFF, 0xA0, 0x27, 0x30, 0x8F, 0xFF, 0xFB, 0x0B, 0x73,
  0x0A, 0xFF, 0xFF, 0xC0, 0x47, 0x20, 0xAF, 0xD8, 0x3C, 0x85, 0x21, 0x28, 0x41, 0x23, 0x6A, 0xDF,
  0x0D, 0x72, 0x09, 0xFB, 0x81, 0xE8, 0x17, 0x68, 0x12, 0x7D, 0xC0, 0x77, 0x10, 0x6F, 0xB0, 0x90,
  0x17, 0x74, 0x83, 0x4C, 0xFE, 0x17, 0x02, 0x0E, 0xF9, 0x0E, 0x04, 0x77, 0x71, 0x05, 0x07, 0x71,
  0x0C, 0xF9, 0x0E, 0x03, 0x77, 0x77, 0x40, 0x6F, 0x90, 0xE0, 0x37, 0x77, 0x75, 0x0D, 0xF9, 0x05,
  0x77, 0x77, 0x50, 0x6F, 0x90, 0x97, 0x77, 0x76, 0x0D, 0xF0, 0xE0, 0x17, 0x77, 0x75, 0x04, 0xF9,
  0x07, 0x77, 0x77, 0x60, 0x9F, 0x0E, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x60, 0x4F, 0x90,
  0x37, 0x77, 0x76, 0x08, 0xF0, 0xD7, 0x77, 0x77, 0x0C, 0xF0, 0x97, 0x77, 0x77, 0xF9, 0x05, 0x77,
  0x77, 0x60, 0x3F, 0x90, 0x17, 0x77, 0x76, 0x06, 0xF0, 0xE7, 0x77, 0x77, 0x08, 0xF0, 0xB7, 0x77,
  0x77, 0x0A, 0xF0, 0x97, 0x77, 0x77, 0x0C, 0xF0, 0x77, 0x77, 0x77, 0x0D, 0xF0, 0x67, 0x77, 0x77,
  0x0E, 0xF0, 0x57, 0x77, 0x77, 0x0E, 0xF0, 0x47, 0x77, 0x77, 0xF9, 0x04, 0x77, 0x77, 0x7F, 0x90,
  0x37, 0x77, 0x77, 0xF9, 0x03, 0x77, 0x77, 0x7F, 0x90, 0x37, 0x77, 0x77, 0xF9, 0x04, 0x77, 0x77,
  0x70, 0xEF, 0x04, 0x77, 0x77, 0x70, 0xDF, 0x06, 0x77, 0x77, 0x70, 0xCF, 0x07, 0x77, 0x77, 0x70,
  0xAF, 0x08, 0x77, 0x77, 0x70, 0x8F, 0x0A, 0x77, 0x77, 0x70, 0x6F, 0x0D, 0x77, 0x77, 0x70, 0x4F,
  0x97, 0x77, 0x77, 0x01, 0xF9, 0x03, 0x77, 0x77, 0x70, 0xDF, 0x07, 0x77, 0x77, 0x70, 0xAF, 0x0B,
  0x77, 0x77, 0x70, 0x6F, 0x97, 0x77, 0x77, 0x01, 0xF9, 0x05, 0x77, 0x77, 0x70, 0xCF, 0x0B, 0x77,
  0x77, 0x70, 0x7F, 0x90, 0x37, 0x77, 0x76, 0x02, 0xF9, 0x0A, 0x77, 0x77, 0x70, 0xAF, 0x90, 0x47,
  0x77, 0x76, 0x03, 0xF9, 0x0D, 0x77, 0x77, 0x70, 0xBF, 0x90, 0xA7, 0x77, 0x76, 0x02, 0xFA, 0x08,
  0x77, 0x77, 0x60, 0x7F, 0xA0, 0x97, 0x77, 0x76, 0x0C, 0xFA, 0x0C, 0x03, 0x77, 0x70, 0x50, 0x77,
  0x20, 0x20, 0xEF, 0xB0, 0xB0, 0x47, 0x71, 0x84, 0x25, 0xAE, 0xFA, 0x73, 0x03, 0x0E, 0xFC, 0x84,
  0xEA, 0x64, 0x21, 0x28, 0x51, 0x23, 0x57, 0xAD, 0xD0, 0xA7, 0x40, 0x40, 0xEF, 0xFF, 0xFA, 0x0A,
  0x75, 0x03, 0x0D, 0xFF, 0xFF, 0x90, 0xA7, 0x60, 0x10, 0xCF, 0xFF, 0xF0, 0xA7, 0x71, 0x07, 0x0E,
  0xFF, 0xFD, 0x0A, 0x77, 0x28, 0x11, 0x8E, 0xFF, 0xFA, 0x0E, 0x07, 0x77, 0x50, 0x50, 0xAF, 0xFC,
  0x81, 0xC8, 0x37, 0x77, 0x38, 0x43, 0x69, 0xBD, 0xEB, 0x85, 0xED, 0xDB, 0x97, 0x47, 0x20,
  // "D" (U+0044)
  0x0A, 0xFF, 0xA8, 0x5E, 0xDC, 0xA7, 0x52, 0x77, 0x60, 0xAF, 0xFF, 0xA8, 0x1D, 0x94, 0x77, 0x30,
  0xAF, 0xFF, 0xD0, 0xE0, 0x77, 0x71, 0x0A, 0xFF, 0xFF, 0x0E, 0x07, 0x76, 0x0A, 0xFF, 0xFF, 0xA0,
  0xD0, 0x37, 0x40, 0xAF, 0xFF, 0xFC, 0x08, 0x73, 0x0A, 0xF0, 0xB8, 0x03, 0x88, 0x29, 0xAC, 0xEF,
  0xF0, 0xA7, 0x20, 0xAF, 0x06, 0x74, 0x81, 0x25, 0xAF, 0xD0, 0xB7, 0x10, 0xAF, 0x06, 0x77, 0x81,
  0x17, 0xEF, 0xB0, 0xA7, 0x0A, 0xF0, 0x67, 0x72, 0x01, 0x09, 0xFB, 0x07, 0x60, 0xAF, 0x06, 0x77,
  0x40, 0x40, 0xEF, 0xA0, 0x45, 0x0A, 0xF0, 0x67, 0x75, 0x02, 0x0D, 0xF9, 0x0D, 0x50, 0xAF, 0x06,
  0x77, 0x60, 0x20, 0xDF, 0x90, 0x84, 0x0A, 0xF0, 0x67, 0x77, 0x03, 0xFA, 0x02, 0x30, 0xAF, 0x06,
  0x77, 0x71, 0x06, 0xF9, 0x09, 0x30, 0xAF, 0x06, 0x77, 0x72, 0x0C, 0xF9, 0x01, 0x20, 0xAF, 0x06,
  0x77, 0x72, 0x04, 0xF9, 0x07, 0x20, 0xAF, 0x06, 0x77, 0x73, 0x0C, 0xF0, 0xD2, 0x0A, 0xF0, 0x67,
  0x77, 0x30, 0x5F, 0x98, 0x12, 0x0A, 0xF0, 0x67, 0x77, 0x4F, 0x98, 0x16, 0x0A, 0xF0, 0x67, 0x77,
  0x40, 0xAF, 0x81, 0xB0, 0xAF, 0x06, 0x77, 0x74, 0x07, 0xF8, 0x1E, 0x0A, 0xF0, 0x67, 0x77, 0x40,
  0x3F, 0x90, 0x20, 0xAF, 0x06, 0x77, 0x75, 0xF9, 0x04, 0x0A, 0xF0, 0x67, 0x77, 0x50, 0xDF, 0x07,
  0x0A, 0xF0, 0x67, 0x77, 0x50, 0xAF, 0x09, 0x0A, 0xF0, 0x67, 0x77, 0x50, 0x9F, 0x0B, 0x0A, 0xF0,
  0x67, 0x77, 0x50, 0x7F, 0x0C, 0x0A, 0xF0, 0x67, 0x77, 0x50, 0x6F, 0x0C, 0x0A, 0xF0, 0x67, 0x77,
  0x50, 0x6F, 0x0D, 0x0A, 0xF0, 0x67, 0x77, 0x50, 0x5F, 0x0E, 0x0A, 0xF0, 0x67, 0x77, 0x50, 0x5F,
  0x0E, 0x0A, 0xF0, 0x67, 0x77, 0x50, 0x5F, 0x0E, 0x0A, 0xF0, 0x67, 0x77, 0x50, 0x5F, 0x0D, 0x0A,
  0xF0, 0x67, 0x77, 0x50, 0x6F, 0x0D, 0x0A, 0xF0, 0x67, 0x77, 0x50, 0x7F, 0x0C, 0x0A, 0xF0, 0x67,
  0x77, 0x50, 0x8F, 0x0B, 0x0A, 0xF0, 0x67, 0x77, 0x50, 0xAF, 0x09, 0x0A, 0xF0, 0x67, 0x77, 0x50,
  0xCF, 0x07, 0x0A, 0xF0, 0x67, 0x77, 0x50, 0xEF, 0x05, 0x0A, 0xF0, 0x67, 0x77, 0x40, 0x2F, 0x90,
  0x20, 0xAF, 0x06, 0x77, 0x74, 0x06, 0xF9, 0x10, 0xAF, 0x06, 0x77, 0x74, 0x09, 0xF8, 0x1C, 0x0A,
  0xF0, 0x67, 0x77, 0x40, 0xEF, 0x81, 0x80, 0xAF, 0x06, 0x77, 0x73, 0x04, 0xF9, 0x81, 0x40, 0xAF,
  0x06, 0x77, 0x73, 0x09, 0xF0, 0xE2, 0x0A, 0xF0, 0x67, 0x77, 0x20, 0x1F, 0x90, 0x92, 0x0A, 0xF0,
  0x67, 0x77, 0x20, 0x8F, 0x90, 0x42, 0x0A, 0xF0, 0x67, 0x77, 0x10, 0x2F, 0x90, 0xD3, 0x0A, 0xF0,
  0x67, 0x77, 0x10, 0xBF, 0x90, 0x53, 0x0A, 0xF0, 0x67, 0x77, 0x07, 0xF9, 0x0D, 0x40, 0xAF, 0x06,
  0x77, 0x60, 0x5F, 0xA0, 0x44, 0x0A, 0xF0, 0x67, 0x75, 0x05, 0xFA, 0x0A, 0x50, 0xAF, 0x06, 0x77,
  0x40, 0x8F, 0xA0, 0xE0, 0x15, 0x0A, 0xF0, 0x67, 0x72, 0x03, 0x0C, 0xFA, 0x0E, 0x03, 0x60, 0xAF,
  0x06, 0x77, 0x04, 0x0B, 0xFC, 0x05, 0x70, 0xAF, 0x06, 0x73, 0x82, 0x25, 0x9E, 0xFD, 0x05, 0x71,
  0x0A, 0xF0, 0xB8, 0x01, 0x88, 0x39, 0x9A, 0xCE, 0xFF, 0x0E, 0x04, 0x72, 0x0A, 0xFF, 0xFF, 0xB0,
  0xC0, 0x27, 0x30, 0xAF, 0xFF, 0xFA, 0x08, 0x75, 0x0A, 0xFF, 0xFF, 0x0A, 0x02, 0x76, 0x0A, 0xFF,
  0xFC, 0x81, 0xE8, 0x27, 0x71, 0x0A, 0xFF, 0xF9, 0x81, 0xE9, 0x47, 0x74, 0x0A, 0xFF, 0x86, 0xEE,
  0xDB, 0x97, 0x51, 0x77, 0x70,
  // "E" (U+0045)
  0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05, 0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C,
  0x1F, 0x05, 0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05, 0x07, 0x80, 0xC1, 0xF0, 0x50,
  0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F,
  0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A,
  0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77,
  0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77,
  0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20,
  0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F,
  0x0A, 0x77, 0x77, 0x20, 0x7F, 0xFF, 0xFF, 0x09, 0x20, 0x7F, 0xFF, 0xFF, 0x09, 0x20, 0x7F, 0xFF,
  0xFF, 0x09, 0x20, 0x7F, 0xFF, 0xFF, 0x09, 0x20, 0x7F, 0xFF, 0xFF, 0x09, 0x20, 0x7F, 0xFF, 0xFF,
  0x09, 0x20, 0x7F, 0xFF, 0xFF, 0x09, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77,
  0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20,
  0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F,
  0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A,
  0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77,
  0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77,
  0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20,
  0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x78, 0x0C, 0x1F, 0x05, 0x07, 0x80,
  0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05, 0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05,
  0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05,
  // "F" (U+0046)
  0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05, 0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C,
  0x1F, 0x05, 0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05, 0x07, 0x80, 0xC1, 0xF0, 0x50,
  0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F,
  0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A,
  0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77,
  0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77,
  0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20,
  0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F,
  0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A,
  0x77, 0x77, 0x20, 0x7F, 0xFF, 0xFF, 0x09, 0x20, 0x7F, 0xFF, 0xFF, 0x09, 0x20, 0x7F, 0xFF, 0xFF,
  0x09, 0x20, 0x7F, 0xFF, 0xFF, 0x09, 0x20, 0x7F, 0xFF, 0xFF, 0x09, 0x20, 0x7F, 0xFF, 0xFF, 0x09,
  0x20, 0x7F, 0xFF, 0xFF, 0x09, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20,
  0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F,
  0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A,
  0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77,
  0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77,
  0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20,
  0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F,
  0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A,
  0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20,
  // "G" (U+0047)
  0x77, 0x68, 0x96, 0x37, 0x9B, 0xDE, 0xEF, 0xED, 0xDC, 0xA7, 0x41, 0x77, 0x73, 0x81, 0x16, 0xBF,
  0xFB, 0x81, 0xD8, 0x37, 0x75, 0x02, 0x09, 0xFF, 0xFA, 0x0D, 0x07, 0x77, 0x10, 0x10, 0x9F, 0xFF,
  0xE0, 0xE0, 0x87, 0x50, 0x40, 0xEF, 0xFF, 0xF9, 0x09, 0x74, 0x08, 0xFF, 0xFF, 0xB0, 0x37, 0x30,
  0xAF, 0xFF, 0xFB, 0x0B, 0x73, 0x09, 0xFD, 0x84, 0xD9, 0x64, 0x11, 0x28, 0x41, 0x23, 0x6A, 0xDE,
  0x05, 0x72, 0x08, 0xFC, 0x0A, 0x04, 0x77, 0x81, 0x39, 0xEA, 0x0D, 0x72, 0x05, 0xFB, 0x0B, 0x02,
  0x77, 0x58, 0x17, 0xE7, 0x71, 0x01, 0x0E, 0xFA, 0x07, 0x77, 0x71, 0x01, 0x72, 0x0A, 0xFA, 0x05,
  0x77, 0x77, 0x40, 0x3F, 0xA0, 0x57, 0x77, 0x75, 0x0C, 0xF9, 0x08, 0x77, 0x77, 0x50, 0x4F, 0x90,
  0xC7, 0x77, 0x76, 0x0B, 0xF9, 0x03, 0x77, 0x77, 0x50, 0x2F, 0x90, 0xA7, 0x77, 0x76, 0x07, 0xF9,
  0x03, 0x77, 0x77, 0x60, 0xCF, 0x0C, 0x77, 0x77, 0x60, 0x2F, 0x90, 0x67, 0x77, 0x76, 0x06, 0xF9,
  0x01, 0x77, 0x77, 0x60, 0x9F, 0x0C, 0x77, 0x77, 0x70, 0xDF, 0x07, 0x77, 0x77, 0x7F, 0x90, 0x47,
  0x77, 0x76, 0x03, 0xF9, 0x01, 0x77, 0x77, 0x60, 0x5F, 0x0E, 0x77, 0x77, 0x70, 0x8F, 0x0C, 0x77,
  0x77, 0x70, 0x9F, 0x0A, 0x77, 0x77, 0x70, 0xAF, 0x08, 0x77, 0x77, 0x70, 0xCF, 0x07, 0x77, 0x77,
  0x70, 0xDF, 0x06, 0x77, 0x77, 0x70, 0xDF, 0x05, 0x77, 0x10, 0xCF, 0xFC, 0x0A, 0x0E, 0xF0, 0x57,
  0x71, 0x0C, 0xFF, 0xC0, 0xA0, 0xEF, 0x05, 0x77, 0x10, 0xCF, 0xFC, 0x0A, 0x0E, 0xF0, 0x57, 0x71,
  0x0C, 0xFF, 0xC0, 0xA0, 0xEF, 0x06, 0x77, 0x10, 0xCF, 0xFC, 0x0A, 0x0D, 0xF0, 0x67, 0x71, 0x0C,
  0xFF, 0xC0, 0xA0, 0xDF, 0x07, 0x77, 0x10, 0xCF, 0xFC, 0x0A, 0x0C, 0xF0, 0x87, 0x77, 0x50, 0x1F,
  0x00, 0xAF, 0x0A, 0x77, 0x75, 0x01, 0xF0, 0xA0, 0x9F, 0x0C, 0x77, 0x75, 0x01, 0xF0, 0xA0, 0x7F,
  0x0E, 0x77, 0x75, 0x01, 0xF0, 0xA0, 0x5F, 0x90, 0x17, 0x77, 0x40, 0x1F, 0x0A, 0x03, 0xF9, 0x04,
  0x77, 0x74, 0x01, 0xF0, 0xA1, 0xF9, 0x08, 0x77, 0x74, 0x01, 0xF8, 0x1A, 0x0C, 0xF0, 0xC7, 0x77,
  0x40, 0x1F, 0x81, 0xA0, 0x9F, 0x90, 0x17, 0x77, 0x30, 0x1F, 0x81, 0xA0, 0x5F, 0x90, 0x67, 0x77,
  0x30, 0x1F, 0x81, 0xA0, 0x1F, 0x90, 0xC7, 0x77, 0x30, 0x1F, 0x0A, 0x20, 0xBF, 0x90, 0x37, 0x77,
  0x20, 0x1F, 0x0A, 0x20, 0x5F, 0x90, 0xB7, 0x77, 0x20, 0x1F, 0x0A, 0x30, 0xEF, 0x90, 0x47, 0x77,
  0x10, 0x1F, 0x0A, 0x30, 0x8F, 0x90, 0xD0, 0x17, 0x77, 0x01, 0xF0, 0xA3, 0x01, 0x0E, 0xF9, 0x0B,
  0x77, 0x70, 0x1F, 0x0A, 0x40, 0x7F, 0xA0, 0xA7, 0x76, 0x01, 0xF0, 0xA5, 0x0D, 0xFA, 0x0A, 0x77,
  0x50, 0x1F, 0x0A, 0x50, 0x3F, 0xB0, 0xD0, 0x47, 0x73, 0x01, 0xF0, 0xA6, 0x07, 0xFC, 0x0B, 0x05,
  0x77, 0x10, 0x5F, 0x0A, 0x70, 0x9F, 0xD8, 0x4E, 0xA7, 0x32, 0x12, 0x84, 0x11, 0x35, 0x8C, 0xFA,
  0x0A, 0x71, 0x0A, 0xFF, 0xFF, 0xE0, 0xA7, 0x20, 0x8F, 0xFF, 0xFD, 0x0A, 0x73, 0x05, 0x0E, 0xFF,
  0xFF, 0xB0, 0xA7, 0x40, 0x10, 0xAF, 0xFF, 0xFA, 0x09, 0x76, 0x03, 0x0A, 0xFF, 0xFC, 0x81, 0xD8,
  0x37, 0x72, 0x81, 0x17, 0xCF, 0xFC, 0x82, 0xEA, 0x62, 0x77, 0x72, 0x89, 0x74, 0x79, 0xBD, 0xEE,
  0xFE, 0xED, 0xCB, 0x96, 0x42, 0x71,
  // "H" (U+0048)
  0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67,
  0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F,
  0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06,
  0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06,
  0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0,
  0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30,
  0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF,
  0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73,
  0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A,
  0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77,
  0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00,
  0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x00,
  0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x00, 0xAF, 0x06, 0x77, 0x73,
  0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A,
  0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77,
  0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00,
  0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77,
  0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0,
  0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67,
  0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F,
  0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06,
  0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06,
  0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0,
  0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30,
  0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x0A,
  // "I" (U+0049)
  0x01, 0xFF, 0xFF, 0xE0, 0x01, 0xFF, 0xFF, 0xE0, 0x01, 0xFF, 0xFF, 0xE0, 0x01, 0xFF, 0xFF, 0xE0,
  0x01, 0xFF, 0xFF, 0xE0, 0x01, 0xFF, 0xFF, 0xE8, 0x61, 0x06, 0x89, 0xBC, 0xDF, 0xFF, 0x85, 0xED,
  0xCA, 0x98, 0x67, 0x38, 0x32, 0x35, 0x68, 0xF9, 0x83, 0x76, 0x43, 0x27, 0x77, 0x10, 0x2F, 0x0E,
  0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60,
  0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7,
  0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02,
  0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77,
  0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F,
  0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77,
  0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0,
  0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76,
  0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E,
  0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60,
  0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7,
  0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02,
  0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77,
  0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x71, 0x84, 0x23, 0x56, 0x79, 0xF9, 0x84,
  0x87, 0x64, 0x32, 0x72, 0x83, 0x89, 0xAC, 0xDF, 0xFF, 0xA8, 0x6E, 0xDC, 0xA9, 0x80, 0x1F, 0xFF,
  0xFE, 0x00, 0x1F, 0xFF, 0xFE, 0x00, 0x1F, 0xFF, 0xFE, 0x00, 0x1F, 0xFF, 0xFE, 0x00, 0x1F, 0xFF,
  0xFE, 0x01,
  // "J" (U+004A)
  0x77, 0x73, 0x03, 0xF0, 0xD7, 0x77, 0x30, 0x3F, 0x0D, 0x77, 0x73, 0x03, 0xF0, 0xD7, 0x77, 0x30,
  0x3F, 0x0D, 0x77, 0x73, 0x03, 0xF0, 0xD7, 0x77, 0x30, 0x3F, 0x0D, 0x77, 0x73, 0x03, 0xF0, 0xD7,
  0x77, 0x30, 0x3F, 0x0D, 0x77, 0x73, 0x03, 0xF0, 0xD7, 0x77, 0x30, 0x3F, 0x0D, 0x77, 0x73, 0x03,
  0xF0, 0xD7, 0x77, 0x30, 0x3F, 0x0D, 0x77, 0x73, 0x03, 0xF0, 0xD7, 0x77, 0x30, 0x3F, 0x0D, 0x77,
  0x73, 0x03, 0xF0, 0xD7, 0x77, 0x30, 0x3F, 0x0D, 0x77, 0x73, 0x03, 0xF0, 0xD7, 0x77, 0x30, 0x3F,
  0x0D, 0x77, 0x73, 0x03, 0xF0, 0xD7, 0x77, 0x30, 0x3F, 0x0D, 0x77, 0x73, 0x03, 0xF0, 0xD7, 0x77,
  0x30, 0x3F, 0x0D, 0x77, 0x73, 0x03, 0xF0, 0xD7, 0x77, 0x30, 0x3F, 0x0D, 0x77, 0x73, 0x03, 0xF0,
  0xD7, 0x77, 0x30, 0x3F, 0x0D, 0x77, 0x73, 0x03, 0xF0, 0xD7, 0x77, 0x30, 0x3F, 0x0D, 0x77, 0x73,
  0x03, 0xF0, 0xD7, 0x77, 0x30, 0x3F, 0x0D, 0x77, 0x73, 0x03, 0xF0, 0xD7, 0x77, 0x30, 0x3F, 0x0D,
  0x77, 0x73, 0x03, 0xF0, 0xD7, 0x77, 0x30, 0x3F, 0x0D, 0x77, 0x73, 0x03, 0xF0, 0xD7, 0x77, 0x30,
  0x3F, 0x0D, 0x77, 0x73, 0x03, 0xF0, 0xD7, 0x77, 0x30, 0x3F, 0x0D, 0x77, 0x73, 0x03, 0xF0, 0xD7,
  0x77, 0x30, 0x3F, 0x0D, 0x77, 0x73, 0x03, 0xF0, 0xD7, 0x77, 0x30, 0x3F, 0x0D, 0x77, 0x73, 0x03,
  0xF0, 0xD7, 0x77, 0x30, 0x3F, 0x0D, 0x77, 0x73, 0x04, 0xF0, 0xD7, 0x77, 0x30, 0x4F, 0x0C, 0x77,
  0x73, 0x05, 0xF0, 0xC7, 0x77, 0x30, 0x7F, 0x0B, 0x77, 0x73, 0x09, 0xF0, 0x97, 0x77, 0x30, 0xCF,
  0x07, 0x77, 0x72, 0x01, 0xF9, 0x04, 0x77, 0x72, 0x06, 0xF9, 0x01, 0x77, 0x72, 0x0D, 0xF0, 0xD7,
  0x77, 0x20, 0x6F, 0x90, 0x87, 0x77, 0x10, 0x3F, 0xA8, 0x22, 0x09, 0x37, 0x74, 0x05, 0x0E, 0xF9,
  0x0B, 0x2A, 0x81, 0xD8, 0x47, 0x60, 0x20, 0x9F, 0xB0, 0x32, 0xE8, 0x4C, 0x96, 0x32, 0x12, 0x82,
  0x13, 0x6B, 0xFC, 0x09, 0x3F, 0xFF, 0xF0, 0xD0, 0x13, 0xFF, 0xFE, 0x0E, 0x03, 0x4F, 0xFF, 0xD0,
  0xE0, 0x35, 0xFF, 0xFC, 0x0C, 0x02, 0x60, 0xBF, 0xFF, 0x90, 0xE0, 0x77, 0x28, 0x22, 0x6B, 0xEF,
  0xFA, 0x81, 0xC7, 0x17, 0x78, 0x62, 0x57, 0x9B, 0xDD, 0xEA, 0x84, 0xED, 0xB9, 0x62, 0x75,
  // "K" (U+004B)
  0x0A, 0xF0, 0x67, 0x77, 0x20, 0x10, 0xDF, 0x98, 0x15, 0x0A, 0xF0, 0x67, 0x77, 0x20, 0xAF, 0x90,
  0x92, 0x0A, 0xF0, 0x67, 0x77, 0x10, 0x6F, 0x90, 0xC3, 0x0A, 0xF0, 0x67, 0x77, 0x03, 0xF9, 0x0E,
  0x02, 0x30, 0xAF, 0x06, 0x77, 0x70, 0xDF, 0x90, 0x64, 0x0A, 0xF0, 0x67, 0x76, 0x0A, 0xF9, 0x0A,
  0x50, 0xAF, 0x06, 0x77, 0x50, 0x6F, 0x90, 0xD0, 0x15, 0x0A, 0xF0, 0x67, 0x74, 0x02, 0x0E, 0xF9,
  0x03, 0x60, 0xAF, 0x06, 0x77, 0x40, 0xDF, 0x90, 0x77, 0x0A, 0xF0, 0x67, 0x73, 0x09, 0xF9, 0x0B,
  0x71, 0x0A, 0xF0, 0x67, 0x72, 0x05, 0xF9, 0x0E, 0x01, 0x71, 0x0A, 0xF0, 0x67, 0x71, 0x02, 0x0E,
  0xF9, 0x04, 0x72, 0x0A, 0xF0, 0x67, 0x71, 0x0C, 0xF9, 0x08, 0x73, 0x0A, 0xF0, 0x67, 0x70, 0x9F,
  0x90, 0xC7, 0x40, 0xAF, 0x06, 0x76, 0x05, 0xF9, 0x0E, 0x02, 0x74, 0x0A, 0xF0, 0x67, 0x50, 0x20,
  0xEF, 0x90, 0x57, 0x50, 0xAF, 0x06, 0x75, 0x0C, 0xF9, 0x09, 0x76, 0x0A, 0xF0, 0x67, 0x40, 0x8F,
  0x90, 0xD7, 0x70, 0xAF, 0x06, 0x73, 0x04, 0xFA, 0x03, 0x77, 0x0A, 0xF0, 0x67, 0x20, 0x10, 0xEF,
  0x90, 0x77, 0x71, 0x0A, 0xF0, 0x67, 0x20, 0xBF, 0x90, 0xB7, 0x72, 0x0A, 0xF0, 0x67, 0x10, 0x8F,
  0x90, 0xE0, 0x17, 0x72, 0x0A, 0xF0, 0x67, 0x04, 0xFA, 0x04, 0x77, 0x30, 0xAF, 0x06, 0x60, 0x10,
  0xEF, 0x90, 0x87, 0x74, 0x0A, 0xF0, 0x66, 0x0B, 0xF9, 0x0C, 0x77, 0x50, 0xAF, 0x06, 0x50, 0x7F,
  0x90, 0xE0, 0x27, 0x75, 0x0A, 0xF0, 0x64, 0x03, 0xFA, 0x05, 0x77, 0x60, 0xAF, 0x06, 0x40, 0xDF,
  0x90, 0x97, 0x77, 0x0A, 0xF0, 0x63, 0x08, 0xF9, 0x0D, 0x77, 0x71, 0x0A, 0xF0, 0x62, 0x03, 0xFA,
  0x05, 0x77, 0x71, 0x0A, 0xF0, 0x62, 0x0C, 0xFA, 0x0C, 0x77, 0x71, 0x0A, 0xF8, 0x16, 0x07, 0xFC,
  0x07, 0x77, 0x70, 0xAF, 0x06, 0x02, 0xFE, 0x02, 0x77, 0x60, 0xAF, 0x06, 0x0B, 0xFE, 0x0C, 0x77,
  0x60, 0xAF, 0x0C, 0xFF, 0x90, 0x67, 0x75, 0x0A, 0xFE, 0x81, 0xE3, 0xDF, 0x0E, 0x02, 0x77, 0x40,
  0xAF, 0xE8, 0x13, 0x04, 0xF9, 0x0B, 0x77, 0x40, 0xAF, 0xD0, 0x53, 0x09, 0xF9, 0x05, 0x77, 0x30,
  0xAF, 0xC0, 0x64, 0x01, 0x0E, 0xF0, 0xE0, 0x17, 0x72, 0x0A, 0xFB, 0x08, 0x60, 0x5F, 0x90, 0xA7,
  0x72, 0x0A, 0xFA, 0x0A, 0x71, 0x0B, 0xF9, 0x05, 0x77, 0x10, 0xAF, 0x90, 0xB7, 0x20, 0x10, 0xEF,
  0x0D, 0x01, 0x77, 0x0A, 0xF0, 0xC0, 0x17, 0x30, 0x6F, 0x90, 0x97, 0x70, 0xAF, 0x06, 0x75, 0x0C,
  0xF9, 0x04, 0x76, 0x0A, 0xF0, 0x67, 0x50, 0x2F, 0x90, 0xD7, 0x60, 0xAF, 0x06, 0x76, 0x08, 0xF9,
  0x08, 0x75, 0x0A, 0xF0, 0x67, 0x70, 0xDF, 0x90, 0x37, 0x40, 0xAF, 0x06, 0x77, 0x04, 0xF9, 0x0C,
  0x74, 0x0A, 0xF0, 0x67, 0x71, 0x09, 0xF9, 0x07, 0x73, 0x0A, 0xF0, 0x67, 0x71, 0x01, 0x0E, 0xF9,
  0x02, 0x72, 0x0A, 0xF0, 0x67, 0x72, 0x05, 0xF9, 0x0B, 0x72, 0x0A, 0xF0, 0x67, 0x73, 0x0B, 0xF9,
  0x06, 0x71, 0x0A, 0xF0, 0x67, 0x73, 0x01, 0x0E, 0xF0, 0xE0, 0x17, 0x0A, 0xF0, 0x67, 0x74, 0x06,
  0xF9, 0x0B, 0x70, 0xAF, 0x06, 0x77, 0x50, 0xCF, 0x90, 0x56, 0x0A, 0xF0, 0x67, 0x75, 0x02, 0xF9,
  0x0E, 0x01, 0x50, 0xAF, 0x06, 0x77, 0x60, 0x8F, 0x90, 0xA5, 0x0A, 0xF0, 0x67, 0x77, 0x0D, 0xF9,
  0x04, 0x40, 0xAF, 0x06, 0x77, 0x70, 0x4F, 0x90, 0xD4, 0x0A, 0xF0, 0x67, 0x77, 0x10, 0x9F, 0x90,
  0x93, 0x0A, 0xF0, 0x67, 0x77, 0x10, 0x10, 0xEF, 0x90, 0x32, 0x0A, 0xF0, 0x67, 0x77, 0x20, 0x5F,
  0x90, 0xD2, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0xBF, 0x98, 0x18, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x10,
  0xEF, 0x90, 0x30,
  // "L" (U+004C)
  0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07,
  0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70,
  0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77,
  0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A,
  0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77,
  0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF,
  0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77,
  0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0,
  0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77,
  0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07,
  0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70,
  0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77,
  0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A,
  0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77,
  0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF,
  0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77,
  0x70, 0xAF, 0xFF, 0xFF, 0x05, 0x0A, 0xFF, 0xFF, 0xF0, 0x50, 0xAF, 0xFF, 0xFF, 0x05, 0x0A, 0xFF,
  0xFF, 0xF0, 0x50, 0xAF, 0xFF, 0xFF, 0x05, 0x0A, 0xFF, 0xFF, 0xF0, 0x50, 0xAF, 0xFF, 0xFF, 0x05,
  // "M" (U+004D)
  0x07, 0xFC, 0x03, 0x77, 0x60, 0x5F, 0xC0, 0x07, 0xFC, 0x08, 0x77, 0x60, 0x9F, 0xC0, 0x07, 0xFC,
  0x0C, 0x77, 0x60, 0xEF, 0xC0, 0x07, 0xFD, 0x01, 0x77, 0x40, 0x3F, 0xD0, 0x07, 0xFD, 0x05, 0x77,
  0x40, 0x7F, 0xD0, 0x07, 0xFD, 0x0A, 0x77, 0x40, 0xBF, 0xD0, 0x07, 0xFD, 0x0E, 0x77, 0x30, 0x1F,
  0xE0, 0x07, 0xFE, 0x03, 0x77, 0x20, 0x5F, 0xE0, 0x07, 0xE0, 0xDE, 0x08, 0x77, 0x20, 0x9E, 0x0D,
  0xE0, 0x07, 0xE0, 0x7E, 0x0C, 0x77, 0x20, 0xDE, 0x07, 0xE0, 0x07, 0xE0, 0x5F, 0x01, 0x77, 0x02,
  0xE0, 0xE0, 0x4E, 0x00, 0x7E, 0x04, 0x0D, 0xE0, 0x57, 0x70, 0x7E, 0x0A, 0x05, 0xE0, 0x07, 0xE0,
  0x60, 0x8E, 0x0A, 0x77, 0x0B, 0xE0, 0x60, 0x7E, 0x00, 0x7E, 0x07, 0x03, 0xE0, 0xE7, 0x7F, 0x01,
  0x09, 0xE0, 0x07, 0xE8, 0x19, 0x0E, 0xE0, 0x37, 0x50, 0x5E, 0x81, 0xC0, 0xAE, 0x00, 0x7E, 0x81,
  0xA0, 0xAE, 0x07, 0x75, 0x09, 0xE8, 0x17, 0x0B, 0xE0, 0x07, 0xE8, 0x1A, 0x05, 0xE0, 0xC7, 0x50,
  0xDE, 0x81, 0x30, 0xCE, 0x00, 0x7E, 0x0B, 0x2F, 0x01, 0x73, 0x02, 0xE0, 0xD2, 0x0D, 0xE0, 0x07,
  0xE0, 0xC2, 0x0B, 0xE0, 0x57, 0x30, 0x7E, 0x09, 0x20, 0xEE, 0x00, 0x7E, 0x0D, 0x20, 0x6E, 0x0A,
  0x73, 0x0B, 0xE0, 0x42, 0x0E, 0xE0, 0x07, 0xE0, 0xE2, 0x02, 0xE0, 0xE7, 0x3E, 0x0E, 0x3F, 0x00,
  0x7F, 0x30, 0xCE, 0x03, 0x71, 0x04, 0xE0, 0xA3, 0xF0, 0x07, 0xF3, 0x08, 0xE0, 0x77, 0x10, 0x9E,
  0x05, 0x3F, 0x00, 0x7F, 0x30, 0x3E, 0x0C, 0x71, 0x0D, 0xE0, 0x12, 0x01, 0xF0, 0x07, 0xF0, 0x13,
  0x0E, 0xE0, 0x16, 0x02, 0xE0, 0xC3, 0x01, 0xF0, 0x07, 0xF0, 0x13, 0x09, 0xE0, 0x56, 0x06, 0xE0,
  0x73, 0x01, 0xF0, 0x07, 0xF0, 0x13, 0x04, 0xE0, 0x96, 0x0B, 0xE0, 0x23, 0x01, 0xF0, 0x07, 0xF0,
  0x24, 0xE0, 0xE6, 0xE0, 0xD4, 0x02, 0xF0, 0x07, 0xF0, 0x24, 0x0A, 0xE0, 0x34, 0x04, 0xE0, 0x84,
  0x02, 0xF0, 0x07, 0xF0, 0x24, 0x06, 0xE0, 0x74, 0x09, 0xE0, 0x44, 0x02, 0xF0, 0x07, 0xF0, 0x24,
  0x01, 0xE0, 0xB4, 0x0D, 0xD0, 0xE5, 0x02, 0xF0, 0x07, 0xF0, 0x25, 0x0C, 0xE0, 0x12, 0x02, 0xE0,
  0xA5, 0x02, 0xF0, 0x07, 0xF0, 0x25, 0x07, 0xE0, 0x52, 0x06, 0xE0, 0x55, 0x02, 0xF0, 0x07, 0xF0,
  0x25, 0x02, 0xE0, 0x92, 0x0B, 0xE0, 0x15, 0x02, 0xF0, 0x07, 0xF0, 0x26, 0x0D, 0xD0, 0xD2, 0xE0,
  0xB6, 0x02, 0xF0, 0x07, 0xF0, 0x26, 0x09, 0xE0, 0x20, 0x4E, 0x07, 0x60, 0x2F, 0x00, 0x7F, 0x02,
  0x60, 0x4E, 0x07, 0x08, 0xE0, 0x26, 0x02, 0xF0, 0x07, 0xF0, 0x27, 0x0E, 0xD0, 0xC0, 0xDD, 0x0D,
  0x70, 0x2F, 0x00, 0x7F, 0x02, 0x70, 0xAF, 0xD0, 0x87, 0x02, 0xF0, 0x07, 0xF0, 0x27, 0x05, 0xFD,
  0x03, 0x70, 0x2F, 0x00, 0x7F, 0x02, 0x70, 0x1F, 0xC0, 0xE7, 0x10, 0x2F, 0x00, 0x7F, 0x02, 0x71,
  0x0B, 0xFB, 0x0A, 0x71, 0x02, 0xF0, 0x07, 0xF0, 0x27, 0x10, 0x7F, 0xB0, 0x57, 0x10, 0x2F, 0x00,
  0x7F, 0x02, 0x71, 0x02, 0xFB, 0x01, 0x71, 0x02, 0xF0, 0x07, 0xF0, 0x27, 0x20, 0xDF, 0x90, 0xB7,
  0x20, 0x2F, 0x00, 0x7F, 0x02, 0x72, 0x08, 0xF9, 0x06, 0x72, 0x02, 0xF0, 0x07, 0xF0, 0x27, 0x20,
  0x3F, 0x90, 0x27, 0x20, 0x2F, 0x00, 0x7F, 0x02, 0x73, 0x0E, 0xE0, 0xD7, 0x30, 0x2F, 0x00, 0x7F,
  0x02, 0x77, 0x77, 0x02, 0xF0, 0x07, 0xF0, 0x27, 0x77, 0x70, 0x2F, 0x00, 0x7F, 0x02, 0x77, 0x77,
  0x02, 0xF0, 0x07, 0xF0, 0x27, 0x77, 0x70, 0x2F, 0x00, 0x7F, 0x02, 0x77, 0x77, 0x02, 0xF0, 0x07,
  0xF0, 0x27, 0x77, 0x70, 0x2F, 0x00, 0x7F, 0x02, 0x77, 0x77, 0x02, 0xF0, 0x07, 0xF0, 0x27, 0x77,
  0x70, 0x2F, 0x00, 0x7F, 0x02, 0x77, 0x77, 0x02, 0xF0, 0x07, 0xF0, 0x27, 0x77, 0x70, 0x2F, 0x00,
  0x7F, 0x02, 0x77, 0x77, 0x02, 0xF0, 0x07, 0xF0, 0x27, 0x77, 0x70, 0x2F, 0x00, 0x7F, 0x02, 0x77,
  0x77, 0x02, 0xF0, 0x07, 0xF0, 0x27, 0x77, 0x70, 0x2F, 0x00, 0x7F, 0x02, 0x77, 0x77, 0x02, 0xF0,
  0x07, 0xF0, 0x27, 0x77, 0x70, 0x2F, 0x07,
  // "N" (U+004E)
  0x0A, 0xFB, 0x03, 0x77, 0x70, 0x1F, 0x00, 0xAF, 0xB0, 0xA7, 0x77, 0x01, 0xF0, 0x0A, 0xFC, 0x01,
  0x77, 0x60, 0x1F, 0x00, 0xAF, 0xC0, 0x87, 0x76, 0x01, 0xF0, 0x0A, 0xFC, 0x0E, 0x77, 0x60, 0x1F,
  0x00, 0xAF, 0xD0, 0x67, 0x75, 0x01, 0xF0, 0x0A, 0xFD, 0x0D, 0x77, 0x50, 0x1F, 0x00, 0xAF, 0xE0,
  0x47, 0x74, 0x01, 0xF0, 0x0A, 0xFE, 0x0B, 0x77, 0x40, 0x1F, 0x00, 0xAE, 0x07, 0xF0, 0x27, 0x73,
  0x01, 0xF0, 0x0A, 0xE0, 0x20, 0xEE, 0x09, 0x77, 0x30, 0x1F, 0x00, 0xAE, 0x02, 0x09, 0xF0, 0x17,
  0x72, 0x01, 0xF0, 0x0A, 0xE0, 0x30, 0x2F, 0x07, 0x77, 0x20, 0x1F, 0x00, 0xAE, 0x81, 0x40, 0xAE,
  0x0D, 0x77, 0x20, 0x1F, 0x00, 0xAE, 0x81, 0x60, 0x3F, 0x05, 0x77, 0x10, 0x1F, 0x00, 0xAE, 0x07,
  0x20, 0xCE, 0x0C, 0x77, 0x10, 0x1F, 0x00, 0xAE, 0x08, 0x20, 0x5F, 0x03, 0x77, 0x01, 0xF0, 0x0A,
  0xE0, 0x93, 0x0D, 0xE0, 0xA7, 0x70, 0x1F, 0x00, 0xAE, 0x0B, 0x30, 0x7F, 0x01, 0x76, 0x01, 0xF0,
  0x0A, 0xE0, 0xC3, 0x01, 0x0E, 0xE0, 0x87, 0x60, 0x1F, 0x00, 0xAE, 0x0D, 0x40, 0x8E, 0x0E, 0x76,
  0x01, 0xF0, 0x0A, 0xE0, 0xE4, 0x02, 0xF0, 0x67, 0x50, 0x1F, 0x00, 0xAE, 0x0E, 0x50, 0xAE, 0x0D,
  0x75, 0x01, 0xF0, 0x0A, 0xF5, 0x03, 0xF0, 0x47, 0x40, 0x1F, 0x00, 0xAF, 0x60, 0xCE, 0x0B, 0x74,
  0x01, 0xF0, 0x0A, 0xF0, 0x15, 0x05, 0xF0, 0x27, 0x30, 0x1F, 0x00, 0xAF, 0x01, 0x60, 0xDE, 0x09,
  0x73, 0x01, 0xF0, 0x0A, 0xF0, 0x16, 0x06, 0xE0, 0xE0, 0x17, 0x20, 0x1F, 0x00, 0xAF, 0x01, 0x70,
  0xEE, 0x07, 0x72, 0x01, 0xF0, 0x0A, 0xF0, 0x17, 0x08, 0xE0, 0xD7, 0x20, 0x1F, 0x00, 0xAF, 0x01,
  0x70, 0x1F, 0x05, 0x71, 0x01, 0xF0, 0x0A, 0xF0, 0x17, 0x10, 0xAE, 0x0C, 0x71, 0x01, 0xF0, 0x0A,
  0xF0, 0x17, 0x10, 0x3F, 0x03, 0x70, 0x1F, 0x00, 0xAF, 0x01, 0x72, 0x0B, 0xE0, 0xA7, 0x01, 0xF0,
  0x0A, 0xF0, 0x17, 0x20, 0x4F, 0x01, 0x60, 0x1F, 0x00, 0xAF, 0x01, 0x73, 0x0D, 0xE0, 0x86, 0x01,
  0xF0, 0x0A, 0xF0, 0x17, 0x30, 0x6E, 0x0E, 0x60, 0x1F, 0x00, 0xAF, 0x01, 0x74, 0x0E, 0xE0, 0x65,
  0x01, 0xF0, 0x0A, 0xF0, 0x17, 0x40, 0x8E, 0x0D, 0x50, 0x1F, 0x00, 0xAF, 0x01, 0x74, 0x01, 0xF0,
  0x44, 0x01, 0xF0, 0x0A, 0xF0, 0x17, 0x50, 0x9E, 0x0B, 0x5F, 0x00, 0xAF, 0x01, 0x75, 0x02, 0xF0,
  0x24, 0xF0, 0x0A, 0xF0, 0x17, 0x60, 0xBE, 0x09, 0x4F, 0x00, 0xAF, 0x01, 0x76, 0x04, 0xE0, 0xE0,
  0x13, 0xF0, 0x0A, 0xF0, 0x17, 0x70, 0xCE, 0x07, 0x30, 0xEE, 0x00, 0xAF, 0x01, 0x77, 0x05, 0xE0,
  0xD3, 0x0D, 0xE0, 0x0A, 0xF0, 0x17, 0x71, 0x0E, 0xE0, 0x52, 0x0C, 0xE0, 0x0A, 0xF0, 0x17, 0x71,
  0x07, 0xE0, 0xC2, 0x0B, 0xE0, 0x0A, 0xF0, 0x17, 0x71, 0x01, 0x0E, 0xE8, 0x13, 0x0A, 0xE0, 0x0A,
  0xF0, 0x17, 0x72, 0x09, 0xE8, 0x1A, 0x09, 0xE0, 0x0A, 0xF0, 0x17, 0x72, 0x02, 0xF0, 0x10, 0x8E,
  0x00, 0xAF, 0x01, 0x77, 0x30, 0xAE, 0x08, 0x07, 0xE0, 0x0A, 0xF0, 0x17, 0x73, 0x03, 0xE0, 0xE0,
  0x6E, 0x00, 0xAF, 0x01, 0x77, 0x40, 0xCE, 0x0C, 0xE0, 0x0A, 0xF0, 0x17, 0x74, 0x05, 0xFE, 0x00,
  0xAF, 0x01, 0x77, 0x50, 0xDF, 0xD0, 0x0A, 0xF0, 0x17, 0x75, 0x07, 0xFD, 0x00, 0xAF, 0x01, 0x77,
  0x50, 0x10, 0xEF, 0xC0, 0x0A, 0xF0, 0x17, 0x76, 0x08, 0xFC, 0x00, 0xAF, 0x01, 0x77, 0x60, 0x2F,
  0xC0, 0x0A, 0xF0, 0x17, 0x77, 0x0A, 0xFB, 0x00, 0xAF, 0x01, 0x77, 0x70, 0x3F, 0xB0, 0x0A, 0xF0,
  0x17, 0x77, 0x10, 0xCF, 0xA0, 0x0A, 0xF0, 0x17, 0x77, 0x10, 0x5F, 0xA0, 0xA0,
  // "O" (U+004F)
  0x77, 0x28, 0x42, 0x69, 0xBD, 0xEA, 0x84, 0xED, 0xB9, 0x62, 0x77, 0x77, 0x18, 0x11, 0x7D, 0xFF,
  0x81, 0xD8, 0x17, 0x77, 0x30, 0x10, 0x8F, 0xFE, 0x09, 0x01, 0x77, 0x70, 0x40, 0xEF, 0xFF, 0x90,
  0xE0, 0x47, 0x75, 0x07, 0xFF, 0xFD, 0x07, 0x77, 0x30, 0x7F, 0xFF, 0xF0, 0x87, 0x71, 0x07, 0xFF,
  0xFF, 0xA0, 0x87, 0x60, 0x4F, 0xC8, 0x2B, 0x63, 0x12, 0x83, 0x12, 0x59, 0xEF, 0xB0, 0x47, 0x40,
  0x10, 0xEF, 0xA0, 0x90, 0x17, 0x40, 0x70, 0xEF, 0x90, 0xE0, 0x27, 0x30, 0xAF, 0x90, 0xE0, 0x37,
  0x70, 0x20, 0xCF, 0x90, 0xB7, 0x20, 0x3F, 0x90, 0xD0, 0x27, 0x72, 0x01, 0x0C, 0xF9, 0x04, 0x71,
  0x0C, 0xF9, 0x03, 0x77, 0x40, 0x10, 0xEF, 0x0C, 0x70, 0x4F, 0x90, 0x77, 0x76, 0x05, 0xF9, 0x05,
  0x60, 0xAF, 0x0D, 0x77, 0x71, 0x0C, 0xF0, 0xB5, 0x01, 0xF9, 0x06, 0x77, 0x71, 0x04, 0xF9, 0x01,
  0x40, 0x7F, 0x0E, 0x77, 0x73, 0x0D, 0xF0, 0x74, 0x0C, 0xF0, 0x97, 0x77, 0x30, 0x8F, 0x0C, 0x4F,
  0x90, 0x47, 0x77, 0x30, 0x3F, 0x90, 0x12, 0x04, 0xF9, 0x77, 0x75, 0x0E, 0xF0, 0x52, 0x08, 0xF0,
  0xB7, 0x77, 0x50, 0xAF, 0x09, 0x20, 0xBF, 0x07, 0x77, 0x75, 0x07, 0xF0, 0xC2, 0x0E, 0xF0, 0x47,
  0x77, 0x50, 0x3F, 0x81, 0xE0, 0x1F, 0x90, 0x17, 0x77, 0x50, 0x1F, 0x90, 0x20, 0x4F, 0x0E, 0x77,
  0x77, 0x0E, 0xF0, 0x50, 0x6F, 0x0C, 0x77, 0x77, 0x0C, 0xF0, 0x60, 0x8F, 0x0B, 0x77, 0x77, 0x0A,
  0xF0, 0x80, 0x9F, 0x09, 0x77, 0x77, 0x09, 0xF0, 0x90, 0xBF, 0x08, 0x77, 0x77, 0x08, 0xF0, 0xB0,
  0xCF, 0x07, 0x77, 0x77, 0x07, 0xF0, 0xC0, 0xDF, 0x06, 0x77, 0x77, 0x06, 0xF0, 0x0D, 0xF0, 0x57,
  0x77, 0x70, 0x5F, 0x0D, 0x0E, 0xF0, 0x57, 0x77, 0x70, 0x5F, 0x00, 0xEF, 0x05, 0x77, 0x77, 0x05,
  0xF0, 0x0E, 0xF0, 0x57, 0x77, 0x70, 0x5F, 0x00, 0xEF, 0x05, 0x77, 0x77, 0x05, 0xF0, 0xE0, 0xDF,
  0x05, 0x77, 0x77, 0x05, 0xF0, 0x0D, 0xF0, 0x67, 0x77, 0x70, 0x6F, 0x0D, 0x0C, 0xF0, 0x77, 0x77,
  0x70, 0x7F, 0x0C, 0x0B, 0xF0, 0x87, 0x77, 0x70, 0x8F, 0x0B, 0x09, 0xF0, 0x97, 0x77, 0x70, 0x9F,
  0x09, 0x08, 0xF0, 0xA7, 0x77, 0x70, 0xAF, 0x08, 0x06, 0xF0, 0xC7, 0x77, 0x70, 0xCF, 0x06, 0x04,
  0xF0, 0xE7, 0x77, 0x70, 0xEF, 0x04, 0x02, 0xF9, 0x01, 0x77, 0x75, 0x01, 0xF9, 0x81, 0x10, 0xEF,
  0x04, 0x77, 0x75, 0x04, 0xF0, 0xE2, 0x0C, 0xF0, 0x77, 0x77, 0x50, 0x7F, 0x0B, 0x20, 0x9F, 0x0B,
  0x77, 0x75, 0x0A, 0xF0, 0x82, 0x05, 0xF0, 0xE7, 0x77, 0x50, 0xEF, 0x04, 0x20, 0x1F, 0x90, 0x47,
  0x77, 0x30, 0x3F, 0x94, 0x0C, 0xF0, 0x97, 0x77, 0x30, 0x8F, 0x0B, 0x40, 0x7F, 0x0E, 0x77, 0x73,
  0x0D, 0xF0, 0x64, 0x01, 0xF9, 0x06, 0x77, 0x71, 0x05, 0xF9, 0x01, 0x50, 0xBF, 0x0D, 0x77, 0x71,
  0x0C, 0xF0, 0xA6, 0x05, 0xF9, 0x06, 0x77, 0x60, 0x5F, 0x90, 0x47, 0x0D, 0xF9, 0x02, 0x77, 0x40,
  0x10, 0xEF, 0x0B, 0x71, 0x04, 0xF9, 0x0D, 0x02, 0x77, 0x20, 0x10, 0xCF, 0x90, 0x37, 0x20, 0xBF,
  0x90, 0xD0, 0x37, 0x70, 0x20, 0xCF, 0x90, 0xA7, 0x30, 0x20, 0xEF, 0xA0, 0x80, 0x17, 0x40, 0x70,
  0xEF, 0x90, 0xD0, 0x17, 0x40, 0x5F, 0xC8, 0x2A, 0x63, 0x12, 0x83, 0x12, 0x5A, 0xEF, 0xB0, 0x37,
  0x60, 0x8F, 0xFF, 0xFA, 0x06, 0x77, 0x10, 0x8F, 0xFF, 0xF0, 0x67, 0x73, 0x08, 0xFF, 0xFD, 0x06,
  0x77, 0x50, 0x50, 0xEF, 0xFF, 0x90, 0xD0, 0x37, 0x77, 0x01, 0x09, 0xFF, 0xD0, 0xE0, 0x87, 0x77,
  0x48, 0x12, 0x8E, 0xFF, 0x81, 0xD7, 0x17, 0x77, 0x71, 0x84, 0x37, 0x9C, 0xDE, 0xA8, 0x4E, 0xDB,
  0x96, 0x27, 0x72,
  // "P" (U+0050)
  0x07, 0xFF, 0xD8, 0x6E, 0xED, 0xBA, 0x75, 0x17, 0x60, 0x7F, 0xFF, 0xE8, 0x1D, 0x83, 0x73, 0x07,
  0xFF, 0xFF, 0xA0, 0xC0, 0x57, 0x10, 0x7F, 0xFF, 0xFC, 0x0C, 0x02, 0x60, 0x7F, 0xFF, 0xFD, 0x0E,
  0x05, 0x50, 0x7F, 0xFF, 0xFF, 0x05, 0x40, 0x7F, 0x0D, 0x80, 0x68, 0x82, 0x9A, 0xBD, 0xFF, 0x04,
  0x30, 0x7F, 0x0A, 0x77, 0x18, 0x13, 0x8D, 0xFB, 0x0E, 0x01, 0x20, 0x7F, 0x0A, 0x77, 0x40, 0x50,
  0xDF, 0xA0, 0x92, 0x07, 0xF0, 0xA7, 0x76, 0x0A, 0xFA, 0x81, 0x20, 0x7F, 0x0A, 0x77, 0x70, 0xBF,
  0x98, 0x19, 0x07, 0xF0, 0xA7, 0x77, 0x01, 0x0E, 0xF8, 0x1E, 0x07, 0xF0, 0xA7, 0x77, 0x10, 0x7F,
  0x90, 0x40, 0x7F, 0x0A, 0x77, 0x71, 0x01, 0xF9, 0x08, 0x07, 0xF0, 0xA7, 0x77, 0x20, 0xCF, 0x0B,
  0x07, 0xF0, 0xA7, 0x77, 0x20, 0x8F, 0x0D, 0x07, 0xF0, 0xA7, 0x77, 0x20, 0x6F, 0x0E, 0x07, 0xF0,
  0xA7, 0x77, 0x20, 0x5F, 0x90, 0x7F, 0x0A, 0x77, 0x72, 0x04, 0xF9, 0x07, 0xF0, 0xA7, 0x77, 0x20,
  0x3F, 0x90, 0x7F, 0x0A, 0x77, 0x72, 0x04, 0xF0, 0xE0, 0x7F, 0x0A, 0x77, 0x72, 0x06, 0xF0, 0xD0,
  0x7F, 0x0A, 0x77, 0x72, 0x08, 0xF0, 0xA0, 0x7F, 0x0A, 0x77, 0x72, 0x0B, 0xF0, 0x80, 0x7F, 0x0A,
  0x77, 0x72, 0x0E, 0xF0, 0x40, 0x7F, 0x0A, 0x77, 0x71, 0x05, 0xF8, 0x1E, 0x07, 0xF0, 0xA7, 0x77,
  0x10, 0xCF, 0x81, 0xA0, 0x7F, 0x0A, 0x77, 0x70, 0x7F, 0x98, 0x13, 0x07, 0xF0, 0xA7, 0x76, 0x04,
  0xF9, 0x0C, 0x20, 0x7F, 0x0A, 0x77, 0x50, 0x7F, 0xA0, 0x42, 0x07, 0xF0, 0xA7, 0x73, 0x04, 0x0D,
  0xFA, 0x0A, 0x30, 0x7F, 0x0A, 0x76, 0x82, 0x14, 0x8D, 0xFB, 0x0D, 0x01, 0x30, 0x7F, 0x0D, 0x80,
  0x48, 0x83, 0x99, 0xAB, 0xDF, 0xE0, 0xE0, 0x24, 0x07, 0xFF, 0xFF, 0xD0, 0xD0, 0x25, 0x07, 0xFF,
  0xFF, 0xC0, 0xC0, 0x16, 0x07, 0xFF, 0xFF, 0xB0, 0x77, 0x10, 0x7F, 0xFF, 0xF8, 0x1E, 0x92, 0x72,
  0x07, 0xFF, 0xFD, 0x81, 0xB6, 0x17, 0x40, 0x7F, 0xFC, 0x85, 0xED, 0xDB, 0x96, 0x47, 0x71, 0x07,
  0xF0, 0xA7, 0x77, 0x74, 0x07, 0xF0, 0xA7, 0x77, 0x74, 0x07, 0xF0, 0xA7, 0x77, 0x74, 0x07, 0xF0,
  0xA7, 0x77, 0x74, 0x07, 0xF0, 0xA7, 0x77, 0x74, 0x07, 0xF0, 0xA7, 0x77, 0x74, 0x07, 0xF0, 0xA7,
  0x77, 0x74, 0x07, 0xF0, 0xA7, 0x77, 0x74, 0x07, 0xF0, 0xA7, 0x77, 0x74, 0x07, 0xF0, 0xA7, 0x77,
  0x74, 0x07, 0xF0, 0xA7, 0x77, 0x74, 0x07, 0xF0, 0xA7, 0x77, 0x74, 0x07, 0xF0, 0xA7, 0x77, 0x74,
  0x07, 0xF0, 0xA7, 0x77, 0x74, 0x07, 0xF0, 0xA7, 0x77, 0x74, 0x07, 0xF0, 0xA7, 0x77, 0x74, 0x07,
  0xF0, 0xA7, 0x77, 0x74, 0x07, 0xF0, 0xA7, 0x77, 0x74, 0x07, 0xF0, 0xA7, 0x77, 0x74, 0x07, 0xF0,
  0xA7, 0x77, 0x74, 0x07, 0xF0, 0xA7, 0x77, 0x74, 0x07, 0xF0, 0xA7, 0x77, 0x74, 0x07, 0xF0, 0xA7,
  0x77, 0x74, 0x07, 0xF0, 0xA7, 0x77, 0x74, 0x07, 0xF0, 0xA7, 0x77, 0x74,
  // "Q" (U+0051)
  0x77, 0x28, 0x42, 0x69, 0xBD, 0xEA, 0x84, 0xED, 0xB9, 0x62, 0x77, 0x77, 0x18, 0x11, 0x7D, 0xFF,
  0x81, 0xD7, 0x17, 0x77, 0x30, 0x10, 0x8F, 0xFE, 0x09, 0x01, 0x77, 0x70, 0x40, 0xEF, 0xFF, 0x90,
  0xE0, 0x47, 0x75, 0x07, 0xFF, 0xFD, 0x07, 0x77, 0x30, 0x7F, 0xFF, 0xF0, 0x77, 0x71, 0x07, 0xFF,
  0xFF, 0xA0, 0x77, 0x60, 0x4F, 0xC8, 0x2B, 0x63, 0x12, 0x83, 0x12, 0x59, 0xEF, 0xB0, 0x47, 0x40,
  0x10, 0xEF, 0xA0, 0x90, 0x17, 0x40, 0x70, 0xEF, 0x90, 0xE0, 0x17, 0x30, 0xAF, 0x90, 0xE0, 0x37,
  0x70, 0x20, 0xCF, 0x90, 0xB7, 0x20, 0x3F, 0x90, 0xD0, 0x27, 0x72, 0x01, 0x0C, 0xF9, 0x04, 0x71,
  0x0C, 0xF9, 0x03, 0x77, 0x40, 0x10, 0xEF, 0x0C, 0x70, 0x4F, 0x90, 0x77, 0x76, 0x05, 0xF9, 0x05,
  0x60, 0xAF, 0x0D, 0x77, 0x71, 0x0C, 0xF0, 0xB5, 0x01, 0xF9, 0x06, 0x77, 0x71, 0x04, 0xF9, 0x01,
  0x40, 0x7F, 0x0E, 0x77, 0x73, 0x0D, 0xF0, 0x74, 0x0C, 0xF0, 0x97, 0x77, 0x30, 0x8F, 0x0C, 0x4F,
  0x90, 0x47, 0x77, 0x30, 0x3F, 0x90, 0x12, 0x04, 0xF9, 0x77, 0x75, 0x0E, 0xF0, 0x52, 0x08, 0xF0,
  0xB7, 0x77, 0x50, 0xAF, 0x09, 0x20, 0xBF, 0x07, 0x77, 0x75, 0x07, 0xF0, 0xC2, 0x0E, 0xF0, 0x47,
  0x77, 0x50, 0x3F, 0x81, 0xE0, 0x1F, 0x90, 0x17, 0x77, 0x50, 0x1F, 0x90, 0x20, 0x4F, 0x0E, 0x77,
  0x77, 0x0E, 0xF0, 0x40, 0x6F, 0x0C, 0x77, 0x77, 0x0C, 0xF0, 0x60, 0x8F, 0x0B, 0x77, 0x77, 0x0A,
  0xF0, 0x80, 0x9F, 0x09, 0x77, 0x77, 0x09, 0xF0, 0x90, 0xBF, 0x08, 0x77, 0x77, 0x08, 0xF0, 0xB0,
  0xCF, 0x07, 0x77, 0x77, 0x07, 0xF0, 0xC0, 0xDF, 0x06, 0x77, 0x77, 0x06, 0xF0, 0x0D, 0xF0, 0x57,
  0x77, 0x70, 0x5F, 0x0D, 0x0E, 0xF0, 0x57, 0x77, 0x70, 0x5F, 0x00, 0xEF, 0x05, 0x77, 0x77, 0x05,
  0xF0, 0x0E, 0xF0, 0x57, 0x77, 0x70, 0x5F, 0x00, 0xEF, 0x05, 0x77, 0x77, 0x05, 0xF0, 0x0D, 0xF0,
  0x57, 0x77, 0x70, 0x5F, 0x00, 0xDF, 0x06, 0x77, 0x77, 0x06, 0xF0, 0x0C, 0xF0, 0x77, 0x77, 0x70,
  0x7F, 0x0C, 0x0B, 0xF0, 0x87, 0x77, 0x70, 0x8F, 0x0B, 0x09, 0xF0, 0x97, 0x77, 0x70, 0x9F, 0x09,
  0x08, 0xF0, 0xA7, 0x77, 0x70, 0xAF, 0x08, 0x06, 0xF0, 0xC7, 0x77, 0x70, 0xCF, 0x06, 0x04, 0xF0,
  0xE7, 0x77, 0x70, 0xEF, 0x04, 0x02, 0xF9, 0x01, 0x77, 0x75, 0x01, 0xF9, 0x81, 0x20, 0xEF, 0x04,
  0x77, 0x75, 0x04, 0xF0, 0xE2, 0x0C, 0xF0, 0x77, 0x77, 0x50, 0x7F, 0x0B, 0x20, 0x9F, 0x0B, 0x77,
  0x75, 0x0A, 0xF0, 0x82, 0x05, 0xF0, 0xE7, 0x77, 0x50, 0xEF, 0x05, 0x20, 0x1F, 0x90, 0x47, 0x77,
  0x30, 0x3F, 0x94, 0x0C, 0xF0, 0x97, 0x77, 0x30, 0x8F, 0x0B, 0x40, 0x7F, 0x0E, 0x77, 0x73, 0x0D,
  0xF0, 0x74, 0x01, 0xF9, 0x06, 0x77, 0x71, 0x05, 0xF9, 0x02, 0x50, 0xBF, 0x0D, 0x77, 0x71, 0x0C,
  0xF0, 0xA6, 0x05, 0xF9, 0x06, 0x77, 0x60, 0x5F, 0x90, 0x47, 0x0D, 0xF9, 0x02, 0x77, 0x40, 0x10,
  0xEF, 0x0D, 0x71, 0x04, 0xF9, 0x0D, 0x02, 0x77, 0x20, 0x10, 0xCF, 0x90, 0x47, 0x20, 0xBF, 0x90,
  0xD0, 0x37, 0x70, 0x20, 0xCF, 0x90, 0xA7, 0x30, 0x20, 0xEF, 0xA0, 0x80, 0x17, 0x40, 0x70, 0xEF,
  0x90, 0xE0, 0x17, 0x40, 0x5F, 0xC8, 0x2A, 0x63, 0x12, 0x83, 0x12, 0x5A, 0xEF, 0xB0, 0x57, 0x60,
  0x8F, 0xFF, 0xFA, 0x07, 0x77, 0x10, 0x8F, 0xFF, 0xF0, 0x97, 0x73, 0x08, 0xFF, 0xFD, 0x07, 0x77,
  0x50, 0x50, 0xEF, 0xFF, 0xA0, 0x47, 0x77, 0x01, 0x09, 0xFF, 0xF9, 0x03, 0x77, 0x72, 0x81, 0x28,
  0xEF, 0xFD, 0x0C, 0x77, 0x75, 0x84, 0x37, 0x9C, 0xDE, 0xA8, 0x2E, 0xDB, 0xAF, 0x90, 0x48, 0x0C,
  0x10, 0x0B, 0xF0, 0xC8, 0x0C, 0x10, 0x04, 0xF9, 0x05, 0x80, 0xC1, 0x00, 0xBF, 0x0D, 0x80, 0xC1,
  0x00, 0x4F, 0x90, 0x68, 0x0C, 0x10, 0x0C, 0xF0, 0xD8, 0x0C, 0x10, 0x04, 0xF9, 0x06, 0x80, 0xC1,
  0x00, 0xCF, 0x0E, 0x80, 0xC1, 0x00, 0x4F, 0x90, 0x78, 0x0C, 0x10, 0x0C, 0xF0, 0xE0, 0x18, 0x0C,
  0x00, 0x04, 0xF9, 0x08, 0x80, 0xC1, 0x00, 0xCF, 0x90, 0x18, 0x0C, 0x00, 0x04, 0xF9, 0x09, 0x80,
  0xC1, 0x00, 0xCF, 0x90, 0x28, 0x0C, 0x00, 0x04, 0xF9, 0x0A, 0x80, 0xC1, 0x00, 0xCF, 0x90, 0x28,
  0x0C, 0x00, 0x03, 0x80, 0x47, 0x04, 0x10,
  // "R" (U+0052)
  0x07, 0xFF, 0xA8, 0x6E, 0xEC, 0xB9, 0x74, 0x17, 0x74, 0x07, 0xFF, 0xFB, 0x81, 0xD8, 0x37, 0x71,
  0x07, 0xFF, 0xFE, 0x0C, 0x06, 0x76, 0x07, 0xFF, 0xFF, 0x90, 0xD0, 0x37, 0x40, 0x7F, 0xFF, 0xFB,
  0x08, 0x73, 0x07, 0xFF, 0xFF, 0xC0, 0x97, 0x20, 0x7F, 0x0D, 0x80, 0x38, 0x83, 0x99, 0xAC, 0xEF,
  0xE0, 0x87, 0x10, 0x7F, 0x0A, 0x75, 0x81, 0x26, 0xBF, 0xC0, 0x57, 0x07, 0xF0, 0xA7, 0x71, 0x02,
  0x0B, 0xFA, 0x0E, 0x70, 0x7F, 0x0A, 0x77, 0x30, 0x7F, 0xA0, 0x76, 0x07, 0xF0, 0xA7, 0x74, 0x07,
  0xF9, 0x0E, 0x60, 0x7F, 0x0A, 0x77, 0x50, 0xCF, 0x90, 0x45, 0x07, 0xF0, 0xA7, 0x75, 0x04, 0xF9,
  0x08, 0x50, 0x7F, 0x0A, 0x77, 0x60, 0xEF, 0x0B, 0x50, 0x7F, 0x0A, 0x77, 0x60, 0xAF, 0x0E, 0x50,
  0x7F, 0x0A, 0x77, 0x60, 0x6F, 0x95, 0x07, 0xF0, 0xA7, 0x76, 0x05, 0xF9, 0x01, 0x40, 0x7F, 0x0A,
  0x77, 0x60, 0x4F, 0x90, 0x24, 0x07, 0xF0, 0xA7, 0x76, 0x03, 0xF9, 0x02, 0x40, 0x7F, 0x0A, 0x77,
  0x60, 0x4F, 0x90, 0x14, 0x07, 0xF0, 0xA7, 0x76, 0x05, 0xF9, 0x50, 0x7F, 0x0A, 0x77, 0x60, 0x7F,
  0x0D, 0x50, 0x7F, 0x0A, 0x77, 0x60, 0xAF, 0x0B, 0x50, 0x7F, 0x0A, 0x77, 0x60, 0xEF, 0x07, 0x50,
  0x7F, 0x0A, 0x77, 0x50, 0x4F, 0x90, 0x35, 0x07, 0xF0, 0xA7, 0x75, 0x0C, 0xF0, 0xD6, 0x07, 0xF0,
  0xA7, 0x74, 0x06, 0xF9, 0x06, 0x60, 0x7F, 0x0A, 0x77, 0x30, 0x3F, 0x90, 0xD7, 0x07, 0xF0, 0xA7,
  0x72, 0x05, 0x0E, 0xF9, 0x04, 0x70, 0x7F, 0x0A, 0x77, 0x04, 0x0B, 0xFA, 0x09, 0x71, 0x07, 0xF0,
  0xA7, 0x18, 0x41, 0x24, 0x6A, 0xEF, 0xB0, 0xB7, 0x20, 0x7F, 0xFF, 0xFB, 0x0A, 0x73, 0x07, 0xFF,
  0xFF, 0x90, 0xE0, 0x67, 0x40, 0x7F, 0xFF, 0xF0, 0xB0, 0x27, 0x50, 0x7F, 0xFF, 0xD0, 0xB0, 0x47,
  0x70, 0x7F, 0xFF, 0xC0, 0x47, 0x72, 0x07, 0xFF, 0xFC, 0x0A, 0x77, 0x20, 0x7F, 0x0D, 0x80, 0x58,
  0x09, 0xF9, 0x04, 0x77, 0x10, 0x7F, 0x0A, 0x73, 0x0B, 0xF0, 0xD7, 0x71, 0x07, 0xF0, 0xA7, 0x30,
  0x2F, 0x90, 0x77, 0x70, 0x7F, 0x0A, 0x74, 0x08, 0xF0, 0xE0, 0x17, 0x60, 0x7F, 0x0A, 0x75, 0x0E,
  0xF0, 0xA7, 0x60, 0x7F, 0x0A, 0x75, 0x05, 0xF9, 0x04, 0x75, 0x07, 0xF0, 0xA7, 0x60, 0xCF, 0x0D,
  0x75, 0x07, 0xF0, 0xA7, 0x60, 0x3F, 0x90, 0x77, 0x40, 0x7F, 0x0A, 0x77, 0x09, 0xF0, 0xE0, 0x17,
  0x30, 0x7F, 0x0A, 0x77, 0x01, 0x0E, 0xF0, 0xA7, 0x30, 0x7F, 0x0A, 0x77, 0x10, 0x6F, 0x90, 0x47,
  0x20, 0x7F, 0x0A, 0x77, 0x20, 0xDF, 0x0D, 0x72, 0x07, 0xF0, 0xA7, 0x72, 0x04, 0xF9, 0x07, 0x71,
  0x07, 0xF0, 0xA7, 0x73, 0x0A, 0xF0, 0xE0, 0x17, 0x07, 0xF0, 0xA7, 0x73, 0x02, 0xF9, 0x0A, 0x70,
  0x7F, 0x0A, 0x77, 0x40, 0x8F, 0x90, 0x46, 0x07, 0xF0, 0xA7, 0x75, 0x0D, 0xF0, 0xD6, 0x07, 0xF0,
  0xA7, 0x75, 0x05, 0xF9, 0x07, 0x50, 0x7F, 0x0A, 0x77, 0x60, 0xBF, 0x0E, 0x01, 0x40, 0x7F, 0x0A,
  0x77, 0x60, 0x3F, 0x90, 0xA4, 0x07, 0xF0, 0xA7, 0x77, 0x09, 0xF9, 0x04, 0x30, 0x7F, 0x0A, 0x77,
  0x70, 0x10, 0xEF, 0x0D, 0x30, 0x7F, 0x0A, 0x77, 0x71, 0x06, 0xF9, 0x07, 0x20, 0x7F, 0x0A, 0x77,
  0x72, 0x0C, 0xF9, 0x81, 0x20, 0x7F, 0x0A, 0x77, 0x72, 0x04, 0xF9, 0x81, 0xA0, 0x7F, 0x0A, 0x77,
  0x73, 0x0A, 0xF9, 0x04, 0x07, 0xF0, 0xA7, 0x77, 0x30, 0x1F, 0x90, 0xD0,
  // "S" (U+0053)
  0x77, 0x18, 0x43, 0x79, 0xBD, 0xEB, 0x85, 0xED, 0xCB, 0x96, 0x37, 0x77, 0x10, 0x50, 0xAF, 0xFC,
  0x81, 0xC8, 0x47, 0x72, 0x07, 0x0D, 0xFF, 0xFA, 0x81, 0xE9, 0x37, 0x40, 0x30, 0xDF, 0xFF, 0xF0,
  0xD0, 0x27, 0x10, 0x7F, 0xFF, 0xFA, 0x0E, 0x71, 0x08, 0xFF, 0xFF, 0xB0, 0x97, 0x07, 0xFF, 0xFF,
  0xC0, 0x46, 0x03, 0xFC, 0x83, 0xE9, 0x63, 0x13, 0x84, 0x13, 0x47, 0xAE, 0xF0, 0xE7, 0x0D, 0xFA,
  0x0D, 0x05, 0x77, 0x81, 0x38, 0xDC, 0x08, 0x60, 0x5F, 0xA0, 0x87, 0x75, 0x03, 0x0B, 0xA0, 0x36,
  0x0C, 0xF9, 0x06, 0x77, 0x71, 0x03, 0x08, 0x60, 0x1F, 0x90, 0xB7, 0x77, 0x73, 0x05, 0xF9, 0x03,
  0x77, 0x77, 0x30, 0x9F, 0x0D, 0x77, 0x77, 0x40, 0xBF, 0x09, 0x77, 0x77, 0x40, 0xDF, 0x07, 0x77,
  0x77, 0x40, 0xDF, 0x06, 0x77, 0x77, 0x40, 0xDF, 0x06, 0x77, 0x77, 0x40, 0xDF, 0x07, 0x77, 0x77,
  0x40, 0xCF, 0x09, 0x77, 0x77, 0x40, 0xAF, 0x0D, 0x77, 0x77, 0x40, 0x7F, 0x90, 0x47, 0x77, 0x73,
  0x03, 0xF9, 0x0C, 0x77, 0x77, 0x40, 0xEF, 0x90, 0xA7, 0x77, 0x73, 0x08, 0xFA, 0x0C, 0x02, 0x77,
  0x77, 0x10, 0x10, 0xEF, 0xA0, 0xE0, 0x77, 0x77, 0x71, 0x06, 0xFC, 0x0E, 0x07, 0x77, 0x77, 0x0A,
  0xFD, 0x81, 0xE7, 0x17, 0x77, 0x50, 0xBF, 0xE8, 0x1E, 0x92, 0x77, 0x74, 0x0B, 0xFF, 0x90, 0xA0,
  0x47, 0x77, 0x30, 0x8F, 0xFA, 0x0C, 0x05, 0x77, 0x72, 0x04, 0x0D, 0xFF, 0xA0, 0xD0, 0x67, 0x77,
  0x20, 0x60, 0xEF, 0xFA, 0x0D, 0x06, 0x77, 0x72, 0x08, 0x0E, 0xFF, 0xA0, 0xC0, 0x47, 0x77, 0x18,
  0x11, 0x8E, 0xFF, 0xA0, 0xA0, 0x17, 0x77, 0x20, 0x70, 0xEF, 0xF9, 0x0D, 0x03, 0x77, 0x73, 0x06,
  0x0C, 0xFF, 0x0E, 0x04, 0x77, 0x74, 0x04, 0x0B, 0xFE, 0x0E, 0x03, 0x77, 0x75, 0x03, 0x0B, 0xFD,
  0x0D, 0x01, 0x77, 0x76, 0x03, 0x0B, 0xFC, 0x0A, 0x77, 0x77, 0x10, 0x40, 0xDF, 0xB0, 0x37, 0x77,
  0x72, 0x09, 0xFA, 0x09, 0x77, 0x77, 0x30, 0x9F, 0x90, 0xE7, 0x77, 0x74, 0x0C, 0xF9, 0x02, 0x77,
  0x77, 0x30, 0x4F, 0x90, 0x57, 0x77, 0x74, 0x0E, 0xF0, 0x77, 0x77, 0x74, 0x0C, 0xF0, 0x87, 0x77,
  0x74, 0x0B, 0xF0, 0x97, 0x77, 0x74, 0x0A, 0xF0, 0x97, 0x77, 0x74, 0x0C, 0xF0, 0x87, 0x77, 0x74,
  0x0D, 0xF0, 0x67, 0x77, 0x73, 0x01, 0xF9, 0x04, 0x77, 0x77, 0x30, 0x5F, 0x90, 0x17, 0x77, 0x73,
  0x0B, 0xF0, 0xD7, 0x77, 0x73, 0x05, 0xF9, 0x82, 0x80, 0x11, 0x77, 0x76, 0x02, 0x0E, 0xF9, 0x84,
  0x20, 0x5F, 0xA5, 0x77, 0x73, 0x02, 0x0D, 0xF9, 0x0A, 0x20, 0x5B, 0x82, 0xEA, 0x51, 0x77, 0x50,
  0x7F, 0xB0, 0x22, 0x05, 0xF8, 0x2C, 0x95, 0x27, 0x58, 0x14, 0x9E, 0xFB, 0x07, 0x30, 0x5F, 0xD8,
  0x90, 0xDB, 0xA9, 0x88, 0x9A, 0xBD, 0xFE, 0x0A, 0x40, 0x5F, 0xFF, 0xFE, 0x0A, 0x50, 0x5F, 0xFF,
  0xFD, 0x09, 0x60, 0x5F, 0xFF, 0xFB, 0x0D, 0x04, 0x71, 0x81, 0x39, 0xEF, 0xFF, 0xD0, 0xD0, 0x77,
  0x68, 0x23, 0x7B, 0xEF, 0xFD, 0x81, 0xE9, 0x47, 0x75, 0x87, 0x14, 0x68, 0xAC, 0xCD, 0xEB, 0x85,
  0xED, 0xCA, 0x85, 0x27, 0x70,
  // "T" (U+0054)
  0x0E, 0x80, 0xD0, 0xF0, 0x0E, 0x80, 0xD0, 0xF0, 0x0E, 0x80, 0xD0, 0xF0, 0x0E, 0x80, 0xD0, 0xF0,
  0x0E, 0x80, 0xD0, 0xF0, 0x0E, 0x80, 0xD0, 0xF0, 0x0E, 0x80, 0xD0, 0xF0, 0xE7, 0x75, 0xF9, 0x80,
  0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F,
  0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C,
  0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9,
  0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2,
  0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98,
  0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20,
  0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80,
  0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F,
  0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C,
  0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9,
  0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2,
  0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98,
  0x0C, 0x20, 0xF9, 0x77, 0x50,
  // "U" (U+0055)
  0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67,
  0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F,
  0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06,
  0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06,
  0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0,
  0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30,
  0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF,
  0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73,
  0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A,
  0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77,
  0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00,
  0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77,
  0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0,
  0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67,
  0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F,
  0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06,
  0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06,
  0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x7F, 0x0A, 0x09, 0xF0, 0x77, 0x77, 0x30, 0x8F, 0x00, 0x9F,
  0x08, 0x77, 0x73, 0x09, 0xF0, 0x90, 0x7F, 0x0A, 0x77, 0x73, 0x0A, 0xF0, 0x70, 0x5F, 0x0C, 0x77,
  0x73, 0x0D, 0xF0, 0x50, 0x4F, 0x97, 0x77, 0x3F, 0x90, 0x30, 0x1F, 0x90, 0x27, 0x77, 0x10, 0x3F,
  0x98, 0x11, 0x0D, 0xF0, 0x67, 0x77, 0x10, 0x6F, 0x0D, 0x20, 0xAF, 0x0B, 0x77, 0x71, 0x0A, 0xF0,
  0x92, 0x06, 0xF9, 0x01, 0x77, 0x60, 0x1F, 0x90, 0x52, 0x01, 0xF9, 0x09, 0x77, 0x60, 0x8F, 0x94,
  0x0C, 0xF9, 0x03, 0x77, 0x40, 0x20, 0xEF, 0x0A, 0x40, 0x5F, 0x90, 0xD0, 0x17, 0x73, 0x0C, 0xF9,
  0x03, 0x50, 0xDF, 0x90, 0xD0, 0x17, 0x70, 0x10, 0xCF, 0x90, 0xC6, 0x06, 0xFA, 0x0E, 0x06, 0x75,
  0x05, 0x0E, 0xFA, 0x03, 0x70, 0xBF, 0xB8, 0x3E, 0x95, 0x21, 0x28, 0x31, 0x25, 0x8E, 0xFB, 0x08,
  0x71, 0x01, 0x0E, 0xFF, 0xFF, 0xA0, 0xC7, 0x30, 0x30, 0xEF, 0xFF, 0xF0, 0xD0, 0x17, 0x40, 0x30,
  0xEF, 0xFF, 0xD0, 0xC0, 0x17, 0x60, 0x10, 0xCF, 0xFF, 0xB0, 0x97, 0x73, 0x06, 0x0D, 0xFF, 0xE0,
  0xC0, 0x37, 0x76, 0x06, 0x0B, 0xFF, 0x98, 0x1E, 0xA4, 0x77, 0x73, 0x85, 0x15, 0x7A, 0xCD, 0xEA,
  0x84, 0xED, 0xC9, 0x74, 0x77,
  // "V" (U+0056)
  0x09, 0xF0, 0xD7, 0x77, 0x74, 0x0E, 0xF0, 0x90, 0x4F, 0x90, 0x27, 0x77, 0x72, 0x03, 0xF9, 0x81,
  0x40, 0xEF, 0x07, 0x77, 0x77, 0x20, 0x8F, 0x0E, 0x20, 0x9F, 0x0B, 0x77, 0x77, 0x20, 0xCF, 0x09,
  0x20, 0x4F, 0x90, 0x17, 0x77, 0x70, 0x1F, 0x90, 0x43, 0x0E, 0xF0, 0x57, 0x77, 0x70, 0x6F, 0x0E,
  0x40, 0xAF, 0x0A, 0x77, 0x77, 0x0A, 0xF0, 0xA4, 0x05, 0xF0, 0xE7, 0x77, 0x70, 0xEF, 0x05, 0x50,
  0xEF, 0x03, 0x77, 0x75, 0x04, 0xF9, 0x01, 0x50, 0xAF, 0x08, 0x77, 0x75, 0x08, 0xF0, 0xB6, 0x05,
  0xF0, 0xD7, 0x77, 0x50, 0xDF, 0x06, 0x7F, 0x90, 0x27, 0x77, 0x30, 0x2F, 0x90, 0x17, 0x0B, 0xF0,
  0x77, 0x77, 0x30, 0x6F, 0x0C, 0x71, 0x05, 0xF0, 0xB7, 0x77, 0x30, 0xBF, 0x07, 0x71, 0x01, 0xF9,
  0x01, 0x77, 0x72, 0xF9, 0x02, 0x72, 0x0B, 0xF0, 0x57, 0x77, 0x10, 0x4F, 0x0C, 0x73, 0x06, 0xF0,
  0xA7, 0x77, 0x10, 0x9F, 0x07, 0x73, 0x01, 0xF0, 0xE7, 0x77, 0x10, 0xDF, 0x02, 0x74, 0x0B, 0xF0,
  0x37, 0x76, 0x02, 0xF0, 0xD7, 0x50, 0x6F, 0x08, 0x77, 0x60, 0x7F, 0x08, 0x75, 0x01, 0xF0, 0xD7,
  0x76, 0x0B, 0xF0, 0x37, 0x60, 0xCF, 0x02, 0x77, 0x40, 0x1F, 0x0E, 0x77, 0x07, 0xF0, 0x77, 0x74,
  0x05, 0xF0, 0x97, 0x70, 0x2F, 0x0B, 0x77, 0x40, 0xAF, 0x04, 0x77, 0x10, 0xCF, 0x01, 0x77, 0x30,
  0xEE, 0x0E, 0x77, 0x20, 0x7F, 0x05, 0x77, 0x20, 0x3F, 0x09, 0x77, 0x20, 0x2F, 0x0A, 0x77, 0x20,
  0x8F, 0x05, 0x77, 0x30, 0xDE, 0x0E, 0x77, 0x20, 0xCE, 0x0E, 0x77, 0x40, 0x8F, 0x04, 0x77, 0x01,
  0xF0, 0xA7, 0x74, 0x03, 0xF0, 0x87, 0x70, 0x6F, 0x05, 0x77, 0x50, 0xDE, 0x0D, 0x77, 0x0A, 0xF0,
  0x17, 0x75, 0x08, 0xF0, 0x27, 0x60, 0xEE, 0x0B, 0x77, 0x60, 0x3F, 0x07, 0x75, 0x04, 0xF0, 0x67,
  0x77, 0x0E, 0xE0, 0xB7, 0x50, 0x8F, 0x01, 0x77, 0x70, 0x9F, 0x01, 0x74, 0x0D, 0xE0, 0xC7, 0x77,
  0x10, 0x4F, 0x05, 0x73, 0x02, 0xF0, 0x77, 0x77, 0x20, 0xEE, 0x0A, 0x73, 0x06, 0xF0, 0x27, 0x77,
  0x20, 0x9E, 0x0E, 0x73, 0x0B, 0xE0, 0xC7, 0x77, 0x30, 0x4F, 0x04, 0x72, 0xF0, 0x77, 0x77, 0x40,
  0xEE, 0x08, 0x71, 0x04, 0xF0, 0x37, 0x77, 0x40, 0xAE, 0x0D, 0x71, 0x09, 0xE0, 0xD7, 0x77, 0x50,
  0x5F, 0x02, 0x70, 0xDE, 0x08, 0x77, 0x76, 0x0E, 0xE0, 0x76, 0x02, 0xF0, 0x37, 0x77, 0x60, 0xAE,
  0x0B, 0x60, 0x6E, 0x0E, 0x77, 0x77, 0x05, 0xF0, 0x15, 0x0B, 0xE0, 0x97, 0x77, 0x71, 0xF0, 0x55,
  0x0E, 0xE0, 0x47, 0x77, 0x71, 0x0B, 0xE0, 0xA4, 0x03, 0xE0, 0xE7, 0x77, 0x72, 0x06, 0xE0, 0xE4,
  0x07, 0xE0, 0xA7, 0x77, 0x72, 0x01, 0xF0, 0x23, 0x0B, 0xE0, 0x57, 0x77, 0x73, 0x0B, 0xE0, 0x73,
  0xF7, 0x77, 0x74, 0x06, 0xE0, 0xA2, 0x04, 0xE0, 0xA7, 0x77, 0x74, 0x01, 0xE0, 0xE2, 0x07, 0xE0,
  0x57, 0x77, 0x75, 0x0B, 0xE8, 0x13, 0x0B, 0xE0, 0x17, 0x77, 0x75, 0x06, 0xE8, 0x16, 0x0E, 0xD0,
  0xB7, 0x77, 0x76, 0x01, 0xE0, 0xA0, 0x3E, 0x06, 0x77, 0x77, 0x70, 0xCD, 0x0E, 0x07, 0xE0, 0x17,
  0x77, 0x77, 0x07, 0xE0, 0xDD, 0x0C, 0x80, 0xC0, 0x00, 0x2F, 0xD0, 0x78, 0x0C, 0x10, 0x0C, 0xFC,
  0x02, 0x80, 0xC1, 0x00, 0x7F, 0xB0, 0xC8, 0x0C, 0x20, 0x02, 0xFB, 0x08, 0x80, 0xC3, 0x00, 0xDF,
  0xA0, 0x38, 0x0C, 0x30, 0x08, 0xF9, 0x0D, 0x80, 0xC4, 0x00, 0x3F, 0x90, 0x87, 0x76,
  // "W" (U+0057)
  0x0A, 0xE0, 0xB7, 0x77, 0x76, 0x0B, 0xE0, 0xA0, 0x9E, 0x0D, 0x77, 0x77, 0x60, 0xDE, 0x09, 0x07,
  0xE0, 0xE7, 0x77, 0x76, 0x0E, 0xE0, 0x70, 0x5F, 0x77, 0x77, 0x6F, 0x06, 0x03, 0xF0, 0x27, 0x77,
  0x74, 0x01, 0xF0, 0x40, 0x2F, 0x03, 0x77, 0x77, 0x40, 0x3F, 0x03, 0x1F, 0x05, 0x77, 0x77, 0x40,
  0x4F, 0x81, 0x10, 0xEE, 0x07, 0x77, 0x77, 0x40, 0x5F, 0x20, 0xCE, 0x08, 0x77, 0x77, 0x40, 0x7E,
  0x0D, 0x20, 0xAE, 0x0A, 0x77, 0x77, 0x40, 0x8E, 0x0C, 0x20, 0x8E, 0x0B, 0x77, 0x77, 0x40, 0x9E,
  0x0A, 0x20, 0x7E, 0x0D, 0x77, 0x77, 0x40, 0xBE, 0x09, 0x20, 0x5E, 0x0E, 0x77, 0x77, 0x40, 0xCE,
  0x07, 0x20, 0x3F, 0x77, 0x77, 0x40, 0xDE, 0x05, 0x20, 0x1F, 0x02, 0x77, 0x77, 0x3F, 0x04, 0x3F,
  0x03, 0x77, 0x77, 0x20, 0x1F, 0x02, 0x30, 0xDE, 0x05, 0x74, 0x0D, 0xF0, 0x17, 0x30, 0x2F, 0x01,
  0x30, 0xCE, 0x06, 0x73, 0x02, 0xF9, 0x04, 0x73, 0x03, 0xF4, 0x0A, 0xE0, 0x77, 0x30, 0x5F, 0x90,
  0x87, 0x30, 0x5E, 0x0D, 0x40, 0x8E, 0x09, 0x73, 0x09, 0xF9, 0x0C, 0x73, 0x06, 0xE0, 0xC4, 0x06,
  0xE0, 0xA7, 0x30, 0xCF, 0xA7, 0x30, 0x7E, 0x0A, 0x40, 0x5E, 0x0C, 0x72, 0x01, 0xFB, 0x04, 0x72,
  0x09, 0xE0, 0x84, 0x03, 0xE0, 0xD7, 0x20, 0x4F, 0xB0, 0x77, 0x20, 0xAE, 0x07, 0x40, 0x1F, 0x72,
  0x08, 0xFB, 0x0B, 0x72, 0x0B, 0xE0, 0x55, 0xF0, 0x17, 0x10, 0xBD, 0x0C, 0xD7, 0x20, 0xDE, 0x04,
  0x50, 0xDE, 0x02, 0x71, 0xD0, 0xD0, 0x9D, 0x03, 0x71, 0x0E, 0xE0, 0x25, 0x0B, 0xE0, 0x37, 0x03,
  0xD0, 0xA0, 0x6D, 0x07, 0x71, 0xF0, 0x15, 0x0A, 0xE0, 0x57, 0x07, 0xD0, 0x70, 0x3D, 0x0B, 0x70,
  0x1E, 0x0E, 0x60, 0x8E, 0x06, 0x70, 0xAD, 0x05, 0x1D, 0x0E, 0x70, 0x3E, 0x0D, 0x60, 0x6E, 0x08,
  0x70, 0xED, 0x81, 0x20, 0xCD, 0x03, 0x60, 0x4E, 0x0B, 0x60, 0x4E, 0x09, 0x60, 0x2D, 0x0E, 0x20,
  0x8D, 0x06, 0x60, 0x5E, 0x0A, 0x60, 0x3E, 0x0B, 0x60, 0x6D, 0x0B, 0x20, 0x5D, 0x0A, 0x60, 0x6E,
  0x08, 0x60, 0x1E, 0x0C, 0x60, 0x9D, 0x08, 0x20, 0x2D, 0x0E, 0x60, 0x7E, 0x07, 0x7E, 0x0E, 0x60,
  0xDD, 0x04, 0x30, 0xED, 0x02, 0x50, 0x8E, 0x05, 0x70, 0xDE, 0x50, 0x1E, 0x01, 0x30, 0xAD, 0x06,
  0x50, 0x9E, 0x03, 0x70, 0xBE, 0x01, 0x40, 0x5D, 0x0C, 0x40, 0x6D, 0x09, 0x50, 0xAE, 0x02, 0x70,
  0x9E, 0x02, 0x40, 0x8D, 0x09, 0x40, 0x3D, 0x0D, 0x50, 0xBE, 0x71, 0x08, 0xE0, 0x34, 0x0C, 0xD0,
  0x55, 0x0E, 0xD0, 0x14, 0x0C, 0xD0, 0xE7, 0x10, 0x6E, 0x04, 0x4E, 0x01, 0x50, 0xBD, 0x05, 0x40,
  0xED, 0x0D, 0x71, 0x04, 0xE0, 0x53, 0x03, 0xD0, 0xD6, 0x07, 0xD0, 0x94, 0xE0, 0xB7, 0x10, 0x3E,
  0x06, 0x30, 0x7D, 0x09, 0x60, 0x3D, 0x0D, 0x4E, 0x0A, 0x71, 0x01, 0xE0, 0x73, 0x0A, 0xD0, 0x67,
  0x0E, 0xD0, 0x12, 0x01, 0xE0, 0x87, 0x2E, 0x09, 0x30, 0xDD, 0x02, 0x70, 0xBD, 0x05, 0x20, 0x2E,
  0x06, 0x72, 0x0D, 0xD0, 0xA2, 0x01, 0xD0, 0xE7, 0x10, 0x7D, 0x08, 0x20, 0x3E, 0x05, 0x72, 0x0B,
  0xD0, 0xB2, 0x04, 0xD0, 0xA7, 0x10, 0x3D, 0x0C, 0x20, 0x4E, 0x03, 0x72, 0x09, 0xD0, 0xC2, 0x08,
  0xD0, 0x77, 0x2E, 0x20, 0x5E, 0x02, 0x72, 0x08, 0xD0, 0xD2, 0x0B, 0xD0, 0x37, 0x20, 0xBD, 0x81,
  0x30, 0x6E, 0x73, 0x06, 0xD0, 0xE2, 0x0E, 0xD7, 0x30, 0x7D, 0x81, 0x60, 0x7D, 0x0E, 0x73, 0x04,
  0xE1, 0x02, 0xD0, 0xB7, 0x30, 0x3D, 0x81, 0xA0, 0x8D, 0x0C, 0x73, 0x02, 0xE1, 0x05, 0xD0, 0x87,
  0x4D, 0x81, 0xD0, 0x8D, 0x0B, 0x73, 0x01, 0xE0, 0x10, 0x9D, 0x04, 0x74, 0x0B, 0xD0, 0x10, 0x9D,
  0x09, 0x74, 0x0E, 0xD0, 0x20, 0xCD, 0x75, 0x08, 0xD0, 0x40, 0xAD, 0x08, 0x74, 0x0D, 0xD0, 0x3D,
  0x0C, 0x75, 0x04, 0xD0, 0x70, 0xBD, 0x06, 0x74, 0x0B, 0xD0, 0x6D, 0x08, 0x76, 0xD0, 0xA0, 0xCD,
  0x05, 0x74, 0x09, 0xD0, 0xAD, 0x05, 0x76, 0x0C, 0xC0, 0x0C, 0xD0, 0x37, 0x40, 0x7D, 0x0E, 0xD0,
  0x17, 0x60, 0x8D, 0x0E, 0xD0, 0x17, 0x40, 0x6F, 0xB0, 0xD7, 0x70, 0x4F, 0xC7, 0x50, 0x4F, 0xB0,
  0x97, 0x71, 0xFB, 0x0E, 0x75, 0x02, 0xFB, 0x06, 0x77, 0x10, 0xCF, 0xA0, 0xC7, 0x6F, 0xB0, 0x27,
  0x71, 0x08, 0xFA, 0x0B, 0x76, 0x0E, 0xF9, 0x0E, 0x77, 0x20, 0x4F, 0xA0, 0x97, 0x60, 0xCF, 0x90,
  0xA7, 0x72, 0x01, 0xFA, 0x08, 0x76, 0x0B, 0xF9, 0x06, 0x77, 0x30, 0xCF, 0x90, 0x67, 0x60, 0x9F,
  0x90, 0x37, 0x73, 0x08, 0xF9, 0x04, 0x60,
  // "X" (U+0058)
  0x10, 0x3F, 0x90, 0x77, 0x77, 0x50, 0x5F, 0x90, 0x33, 0x09, 0xF0, 0xE0, 0x17, 0x77, 0x40, 0xDF,
  0x09, 0x40, 0x10, 0xEF, 0x09, 0x77, 0x73, 0x06, 0xF0, 0xE0, 0x15, 0x06, 0xF9, 0x02, 0x77, 0x71,
  0x01, 0x0E, 0xF0, 0x67, 0x0C, 0xF0, 0xA7, 0x77, 0x10, 0x8F, 0x0C, 0x71, 0x03, 0xF9, 0x03, 0x77,
  0x60, 0x2F, 0x90, 0x37, 0x20, 0x9F, 0x0C, 0x77, 0x60, 0xAF, 0x0A, 0x73, 0x01, 0x0E, 0xF0, 0x57,
  0x74, 0x03, 0xF0, 0xE0, 0x17, 0x40, 0x6F, 0x0D, 0x77, 0x40, 0xCF, 0x07, 0x76, 0x0C, 0xF0, 0x77,
  0x72, 0x05, 0xF0, 0xD7, 0x70, 0x3F, 0x0E, 0x01, 0x77, 0x10, 0xDF, 0x04, 0x77, 0x10, 0xAF, 0x08,
  0x77, 0x07, 0xF0, 0xA7, 0x72, 0x01, 0x0E, 0xF0, 0x27, 0x50, 0x10, 0xEF, 0x02, 0x77, 0x30, 0x7F,
  0x0A, 0x75, 0x08, 0xF0, 0x77, 0x75, 0x0D, 0xF0, 0x37, 0x30, 0x2F, 0x0D, 0x77, 0x60, 0x4F, 0x0B,
  0x73, 0x0A, 0xF0, 0x57, 0x77, 0x0A, 0xF0, 0x47, 0x10, 0x3F, 0x0B, 0x77, 0x71, 0x01, 0x0E, 0xE0,
  0xD7, 0x10, 0xCF, 0x02, 0x77, 0x72, 0x07, 0xF0, 0x66, 0x05, 0xF0, 0x87, 0x77, 0x40, 0xDE, 0x0E,
  0x60, 0xDE, 0x0E, 0x77, 0x75, 0x04, 0xF0, 0x74, 0x07, 0xF0, 0x57, 0x77, 0x60, 0xAE, 0x0E, 0x01,
  0x20, 0x10, 0xEE, 0x0C, 0x77, 0x77, 0x01, 0x0E, 0xE0, 0x92, 0x09, 0xF0, 0x37, 0x77, 0x71, 0x07,
  0xF0, 0x02, 0xF0, 0x97, 0x77, 0x73, 0x0D, 0xE0, 0x0A, 0xE0, 0xE0, 0x17, 0x77, 0x73, 0x04, 0xFF,
  0x06, 0x77, 0x77, 0x50, 0xBF, 0xD0, 0xC7, 0x77, 0x76, 0x02, 0xFD, 0x03, 0x77, 0x77, 0x70, 0x8F,
  0xB0, 0x98, 0x0C, 0x10, 0x0D, 0xF9, 0x0E, 0x01, 0x80, 0xC1, 0x00, 0x5F, 0x90, 0x78, 0x0C, 0x30,
  0x0E, 0xF8, 0x0C, 0x30, 0x07, 0xF9, 0x07, 0x80, 0xC1, 0x00, 0x10, 0xEF, 0xA0, 0x28, 0x0C, 0x00,
  0x0A, 0xFB, 0x0B, 0x77, 0x77, 0x70, 0x4F, 0xD0, 0x57, 0x77, 0x76, 0x0D, 0xFD, 0x0D, 0x77, 0x77,
  0x50, 0x8F, 0xF0, 0x87, 0x77, 0x73, 0x02, 0xF0, 0xB0, 0x8F, 0x03, 0x77, 0x77, 0x20, 0xBF, 0x81,
  0x20, 0xDE, 0x0C, 0x77, 0x77, 0x10, 0x5F, 0x08, 0x20, 0x5F, 0x06, 0x77, 0x76, 0x01, 0x0E, 0xE0,
  0xE4, 0x0B, 0xE0, 0xE0, 0x17, 0x77, 0x50, 0x9F, 0x05, 0x40, 0x2F, 0x09, 0x77, 0x74, 0x03, 0xF0,
  0xC6, 0x09, 0xF0, 0x37, 0x77, 0x30, 0xCF, 0x03, 0x60, 0x10, 0xEE, 0x0D, 0x77, 0x72, 0x07, 0xF0,
  0x97, 0x10, 0x6F, 0x07, 0x77, 0x70, 0x10, 0xEE, 0x0E, 0x01, 0x72, 0x0C, 0xE0, 0xE0, 0x27, 0x76,
  0x0A, 0xF0, 0x67, 0x30, 0x3F, 0x0B, 0x77, 0x50, 0x4F, 0x0D, 0x75, 0x09, 0xF0, 0x57, 0x74, 0x0D,
  0xF0, 0x47, 0x50, 0x10, 0xEE, 0x0D, 0x77, 0x30, 0x8F, 0x0A, 0x77, 0x07, 0xF0, 0x87, 0x71, 0x02,
  0xF9, 0x02, 0x77, 0x10, 0xDF, 0x02, 0x77, 0x0B, 0xF0, 0x87, 0x72, 0x04, 0xF0, 0xB7, 0x60, 0x5F,
  0x0D, 0x77, 0x40, 0xAF, 0x06, 0x74, 0x01, 0x0E, 0xF0, 0x57, 0x74, 0x02, 0xF0, 0xE0, 0x17, 0x30,
  0x9F, 0x0B, 0x77, 0x60, 0x8F, 0x09, 0x72, 0x03, 0xF9, 0x03, 0x77, 0x70, 0xDF, 0x03, 0x71, 0x0C,
  0xF0, 0x97, 0x77, 0x10, 0x5F, 0x0C, 0x70, 0x7F, 0x0E, 0x01, 0x77, 0x72, 0x0B, 0xF0, 0x75, 0x01,
  0x0E, 0xF0, 0x67, 0x77, 0x30, 0x2F, 0x0E, 0x01, 0x40, 0xAF, 0x0C, 0x77, 0x75, 0x08, 0xF0, 0xA3,
  0x04, 0xF9, 0x04, 0x77, 0x75, 0x01, 0x0E, 0xF0, 0x42, 0x0D, 0xF0, 0xA7, 0x77, 0x70, 0x6F, 0x81,
  0xD0, 0x8F, 0x90, 0x17, 0x77, 0x71, 0x0C, 0xF0, 0x80,
  // "Y" (U+0059)
  0x09, 0xF9, 0x04, 0x77, 0x77, 0x01, 0x0E, 0xF0, 0x90, 0x1F, 0x90, 0xB7, 0x77, 0x70, 0x7F, 0x98,
  0x11, 0x09, 0xF9, 0x03, 0x77, 0x76, 0x0E, 0xF0, 0x82, 0x01, 0xF9, 0x0A, 0x77, 0x75, 0x06, 0xF9,
  0x01, 0x30, 0x8F, 0x90, 0x27, 0x77, 0x40, 0xDF, 0x08, 0x40, 0x10, 0xEF, 0x09, 0x77, 0x73, 0x05,
  0xF0, 0xE0, 0x15, 0x08, 0xF0, 0xE0, 0x17, 0x77, 0x20, 0xCF, 0x08, 0x60, 0x10, 0xEF, 0x07, 0x77,
  0x71, 0x03, 0xF0, 0xE0, 0x17, 0x08, 0xF0, 0xE7, 0x77, 0x10, 0xBF, 0x08, 0x71, 0x01, 0x0E, 0xF0,
  0x67, 0x76, 0x02, 0xF0, 0xE0, 0x17, 0x20, 0x8F, 0x0D, 0x77, 0x60, 0x9F, 0x08, 0x73, 0x01, 0x0E,
  0xF0, 0x57, 0x74, 0x01, 0xF0, 0xE0, 0x17, 0x40, 0x8F, 0x0C, 0x77, 0x40, 0x8F, 0x07, 0x75, 0x01,
  0x0E, 0xF0, 0x37, 0x72, 0x01, 0x0E, 0xE0, 0xE0, 0x17, 0x60, 0x7F, 0x0A, 0x77, 0x20, 0x7F, 0x07,
  0x77, 0x10, 0xEF, 0x02, 0x77, 0x10, 0xEE, 0x0E, 0x77, 0x20, 0x7F, 0x09, 0x77, 0x06, 0xF0, 0x77,
  0x73, 0x0E, 0xF0, 0x17, 0x60, 0xDE, 0x0E, 0x77, 0x40, 0x7F, 0x08, 0x75, 0x04, 0xF0, 0x77, 0x75,
  0x0E, 0xE0, 0xE7, 0x50, 0xCE, 0x0E, 0x77, 0x60, 0x7F, 0x07, 0x73, 0x03, 0xF0, 0x77, 0x77, 0x0E,
  0xE0, 0xD7, 0x30, 0xAE, 0x0E, 0x77, 0x71, 0x07, 0xF0, 0x57, 0x10, 0x2F, 0x07, 0x77, 0x72, 0x0E,
  0xE0, 0xC7, 0x10, 0x9E, 0x0E, 0x77, 0x73, 0x06, 0xF0, 0x46, 0x01, 0xF0, 0x67, 0x77, 0x40, 0xDE,
  0x0B, 0x60, 0x8E, 0x0D, 0x77, 0x75, 0x06, 0xF0, 0x35, 0x0E, 0xE0, 0x67, 0x77, 0x60, 0xDE, 0x0A,
  0x40, 0x7E, 0x0D, 0x77, 0x77, 0x06, 0xF0, 0x23, 0x0D, 0xE0, 0x67, 0x77, 0x71, 0x0D, 0xE0, 0x82,
  0x05, 0xE0, 0xD7, 0x77, 0x72, 0x06, 0xE8, 0x2E, 0x10, 0xDE, 0x06, 0x77, 0x77, 0x30, 0xDE, 0x07,
  0x04, 0xE0, 0xD7, 0x77, 0x74, 0x06, 0xE0, 0xE0, 0xCE, 0x06, 0x77, 0x77, 0x50, 0xDF, 0xD0, 0xD7,
  0x77, 0x76, 0x05, 0xFD, 0x05, 0x77, 0x77, 0x70, 0xDF, 0xB0, 0xD8, 0x0C, 0x00, 0x05, 0xFB, 0x05,
  0x80, 0xC1, 0x00, 0xDF, 0x90, 0xD8, 0x0C, 0x20, 0x05, 0xF9, 0x05, 0x80, 0xC3, 0x00, 0xEE, 0x0E,
  0x80, 0xC4, 0x00, 0xDE, 0x0D, 0x80, 0xC4, 0x00, 0xDE, 0x0D, 0x80, 0xC4, 0x00, 0xDE, 0x0D, 0x80,
  0xC4, 0x00, 0xDE, 0x0D, 0x80, 0xC4, 0x00, 0xDE, 0x0D, 0x80, 0xC4, 0x00, 0xDE, 0x0D, 0x80, 0xC4,
  0x00, 0xDE, 0x0D, 0x80, 0xC4, 0x00, 0xDE, 0x0D, 0x80, 0xC4, 0x00, 0xDE, 0x0D, 0x80, 0xC4, 0x00,
  0xDE, 0x0D, 0x80, 0xC4, 0x00, 0xDE, 0x0D, 0x80, 0xC4, 0x00, 0xDE, 0x0D, 0x80, 0xC4, 0x00, 0xDE,
  0x0D, 0x80, 0xC4, 0x00, 0xDE, 0x0D, 0x80, 0xC4, 0x00, 0xDE, 0x0D, 0x80, 0xC4, 0x00, 0xDE, 0x0D,
  0x80, 0xC4, 0x00, 0xDE, 0x0D, 0x80, 0xC4, 0x00, 0xDE, 0x0D, 0x80, 0xC4, 0x00, 0xDE, 0x0D, 0x80,
  0xC4, 0x00, 0xDE, 0x0D, 0x80, 0xC4, 0x00, 0xDE, 0x0D, 0x80, 0xC4, 0x00, 0xDE, 0x0D, 0x80, 0xC4,
  0x00, 0xDE, 0x0D, 0x80, 0xC4, 0x00, 0xDE, 0x0D, 0x77, 0x60,
  // "Z" (U+005A)
  0x20, 0xAF, 0xFF, 0xFE, 0x07, 0x20, 0xAF, 0xFF, 0xFE, 0x07, 0x20, 0xAF, 0xFF, 0xFE, 0x07, 0x20,
  0xAF, 0xFF, 0xFE, 0x07, 0x20, 0xAF, 0xFF, 0xFE, 0x07, 0x20, 0xAF, 0xFF, 0xFE, 0x07, 0x20, 0x58,
  0x0A, 0x68, 0xF9, 0x02, 0x77, 0x77, 0x07, 0xF0, 0x97, 0x77, 0x70, 0x10, 0xEE, 0x0E, 0x01, 0x77,
  0x77, 0x08, 0xF0, 0x77, 0x77, 0x70, 0x2F, 0x0D, 0x77, 0x77, 0x10, 0xAF, 0x06, 0x77, 0x77, 0x03,
  0xF0, 0xC7, 0x77, 0x71, 0x0C, 0xF0, 0x47, 0x77, 0x70, 0x5F, 0x0B, 0x77, 0x77, 0x10, 0xDF, 0x02,
  0x77, 0x77, 0x07, 0xF0, 0x97, 0x77, 0x70, 0x10, 0xEF, 0x01, 0x77, 0x77, 0x08, 0xF0, 0x87, 0x77,
  0x70, 0x2F, 0x0E, 0x77, 0x77, 0x10, 0xAF, 0x06, 0x77, 0x77, 0x03, 0xF0, 0xD7, 0x77, 0x71, 0x0C,
  0xF0, 0x47, 0x77, 0x70, 0x5F, 0x0B, 0x77, 0x77, 0x10, 0xDF, 0x03, 0x77, 0x77, 0x07, 0xF0, 0xA7,
  0x77, 0x70, 0x10, 0xEF, 0x02, 0x77, 0x77, 0x09, 0xF0, 0x87, 0x77, 0x70, 0x2F, 0x0E, 0x01, 0x77,
  0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0x3F, 0x0D, 0x77, 0x77, 0x10, 0xCF, 0x05, 0x77, 0x77, 0x05,
  0xF0, 0xC7, 0x77, 0x71, 0x0D, 0xF0, 0x37, 0x77, 0x70, 0x7F, 0x0A, 0x77, 0x77, 0x01, 0x0E, 0xF0,
  0x27, 0x77, 0x70, 0x9F, 0x09, 0x77, 0x77, 0x02, 0xF0, 0xE0, 0x17, 0x77, 0x70, 0xAF, 0x07, 0x77,
  0x77, 0x03, 0xF0, 0xD7, 0x77, 0x71, 0x0C, 0xF0, 0x57, 0x77, 0x70, 0x5F, 0x0C, 0x77, 0x77, 0x10,
  0xDF, 0x04, 0x77, 0x77, 0x07, 0xF0, 0xB7, 0x77, 0x70, 0x10, 0xEF, 0x02, 0x77, 0x77, 0x09, 0xF0,
  0x97, 0x77, 0x70, 0x2F, 0x0E, 0x01, 0x77, 0x77, 0x0B, 0xF0, 0x87, 0x77, 0x70, 0x4F, 0x0E, 0x77,
  0x77, 0x10, 0xCF, 0x06, 0x77, 0x77, 0x05, 0xF0, 0xD7, 0x77, 0x71, 0x0D, 0xF0, 0x47, 0x77, 0x70,
  0x7F, 0x0B, 0x77, 0x77, 0x01, 0x0E, 0xF0, 0x37, 0x77, 0x70, 0x9F, 0x0A, 0x77, 0x77, 0x02, 0xF9,
  0x02, 0x77, 0x77, 0x0B, 0xF0, 0x87, 0x77, 0x70, 0x48, 0x0C, 0x0F, 0x00, 0x78, 0x0C, 0x0F, 0x00,
  0x78, 0x0C, 0x0F, 0x00, 0x78, 0x0C, 0x0F, 0x00, 0x78, 0x0C, 0x0F, 0x00, 0x78, 0x0C, 0x0F, 0x00,
  0x78, 0x0C, 0x0F, 0x07,
  // "[" (U+005B)
  0x06, 0xFF, 0xD0, 0xD0, 0x6F, 0xFD, 0x0D, 0x06, 0xFF, 0xD0, 0xD0, 0x6F, 0xFD, 0x0D, 0x06, 0xFF,
  0xD0, 0xD0, 0x6F, 0xFD, 0x0D, 0x06, 0xF0, 0xA8, 0x07, 0x80, 0x70, 0x6F, 0x05, 0x75, 0x06, 0xF0,
  0x57, 0x50, 0x6F, 0x05, 0x75, 0x06, 0xF0, 0x57, 0x50, 0x6F, 0x05, 0x75, 0x06, 0xF0, 0x57, 0x50,
  0x6F, 0x05, 0x75, 0x06, 0xF0, 0x57, 0x50, 0x6F, 0x05, 0x75, 0x06, 0xF0, 0x57, 0x50, 0x6F, 0x05,
  0x75, 0x06, 0xF0, 0x57, 0x50, 0x6F, 0x05, 0x75, 0x06, 0xF0, 0x57, 0x50, 0x6F, 0x05, 0x75, 0x06,
  0xF0, 0x57, 0x50, 0x6F, 0x05, 0x75, 0x06, 0xF0, 0x57, 0x50, 0x6F, 0x05, 0x75, 0x06, 0xF0, 0x57,
  0x50, 0x6F, 0x05, 0x75, 0x06, 0xF0, 0x57, 0x50, 0x6F, 0x05, 0x75, 0x06, 0xF0, 0x57, 0x50, 0x6F,
  0x05, 0x75, 0x06, 0xF0, 0x57, 0x50, 0x6F, 0x05, 0x75, 0x06, 0xF0, 0x57, 0x50, 0x6F, 0x05, 0x75,
  0x06, 0xF0, 0x57, 0x50, 0x6F, 0x05, 0x75, 0x06, 0xF0, 0x57, 0x50, 0x6F, 0x05, 0x75, 0x06, 0xF0,
  0x57, 0x50, 0x6F, 0x05, 0x75, 0x06, 0xF0, 0x57, 0x50, 0x6F, 0x05, 0x75, 0x06, 0xF0, 0x57, 0x50,
  0x6F, 0x05, 0x75, 0x06, 0xF0, 0x57, 0x50, 0x6F, 0x05, 0x75, 0x06, 0xF0, 0x57, 0x50, 0x6F, 0x05,
  0x75, 0x06, 0xF0, 0x57, 0x50, 0x6F, 0x05, 0x75, 0x06, 0xF0, 0x57, 0x50, 0x6F, 0x05, 0x75, 0x06,
  0xF0, 0x57, 0x50, 0x6F, 0x05, 0x75, 0x06, 0xF0, 0x57, 0x50, 0x6F, 0x05, 0x75, 0x06, 0xF0, 0x57,
  0x50, 0x6F, 0x05, 0x75, 0x06, 0xF0, 0x57, 0x50, 0x6F, 0x05, 0x75, 0x06, 0xF0, 0x57, 0x50, 0x6F,
  0x05, 0x75, 0x06, 0xF0, 0x57, 0x50, 0x6F, 0x05, 0x75, 0x06, 0xF0, 0x57, 0x50, 0x6F, 0x05, 0x75,
  0x06, 0xF0, 0x57, 0x50, 0x6F, 0x05, 0x75, 0x06, 0xF0, 0x57, 0x50, 0x6F, 0x05, 0x75, 0x06, 0xFF,
  0xD0, 0xD0, 0x6F, 0xFD, 0x0D, 0x06, 0xFF, 0xD0, 0xD0, 0x6F, 0xFD, 0x0D, 0x06, 0xFF, 0xD0, 0xD0,
  0x6F, 0xFD, 0x0D, 0x03, 0x80, 0x97, 0x80, 0x70,
  // "\" (U+005C)
  0x0E, 0xE0, 0xB7, 0x77, 0x30, 0x9F, 0x02, 0x77, 0x72, 0x03, 0xF0, 0x77, 0x77, 0x30, 0xDE, 0x0D,
  0x77, 0x73, 0x07, 0xF0, 0x47, 0x77, 0x20, 0x1F, 0x0A, 0x77, 0x73, 0x0A, 0xF0, 0x17, 0x77, 0x20,
  0x4F, 0x06, 0x77, 0x73, 0x0E, 0xE0, 0xC7, 0x77, 0x30, 0x8F, 0x03, 0x77, 0x72, 0x02, 0xF0, 0x97,
  0x77, 0x30, 0xCE, 0x0E, 0x77, 0x73, 0x06, 0xF0, 0x57, 0x77, 0x30, 0xEE, 0x0B, 0x77, 0x73, 0x09,
  0xF0, 0x27, 0x77, 0x20, 0x3F, 0x07, 0x77, 0x73, 0x0D, 0xE0, 0xD7, 0x77, 0x30, 0x7F, 0x04, 0x77,
  0x72, 0x01, 0xF0, 0xA7, 0x77, 0x30, 0xAF, 0x01, 0x77, 0x72, 0x04, 0xF0, 0x67, 0x77, 0x30, 0xEE,
  0x0C, 0x77, 0x73, 0x08, 0xF0, 0x37, 0x77, 0x20, 0x2F, 0x09, 0x77, 0x73, 0x0B, 0xE0, 0xE7, 0x77,
  0x30, 0x5F, 0x05, 0x77, 0x73, 0x0E, 0xE0, 0xB7, 0x77, 0x30, 0x9F, 0x02, 0x77, 0x72, 0x03, 0xF0,
  0x87, 0x77, 0x30, 0xDE, 0x0D, 0x77, 0x73, 0x07, 0xF0, 0x47, 0x77, 0x20, 0x1F, 0x0A, 0x77, 0x73,
  0x0A, 0xF0, 0x17, 0x77, 0x20, 0x4F, 0x07, 0x77, 0x73, 0x0D, 0xE0, 0xD7, 0x77, 0x30, 0x8F, 0x03,
  0x77, 0x72, 0x02, 0xF0, 0x97, 0x77, 0x30, 0xBE, 0x0E, 0x77, 0x73, 0x05, 0xF0, 0x57, 0x77, 0x30,
  0xEE, 0x0B, 0x77, 0x73, 0x09, 0xF0, 0x27, 0x77, 0x20, 0x3F, 0x08, 0x77, 0x73, 0x0C, 0xE0, 0xE7,
  0x77, 0x30, 0x6F, 0x04, 0x77, 0x72, 0x01, 0xF0, 0xA7, 0x77, 0x30, 0xAF, 0x01, 0x77, 0x72, 0x04,
  0xF0, 0x77, 0x77, 0x30, 0xDE, 0x0D, 0x77, 0x73, 0x08, 0xF0, 0x37, 0x77, 0x20, 0x2F, 0x09, 0x77,
  0x73, 0x0B, 0xE0, 0xE7, 0x77, 0x30, 0x5F, 0x05, 0x77, 0x73, 0x0E, 0xE0, 0xB7, 0x77, 0x30, 0x9F,
  0x02, 0x77, 0x72, 0x03, 0xF0, 0x87, 0x77, 0x30, 0xCE, 0x0E, 0x77, 0x73, 0x06, 0xF0, 0x47, 0x77,
  0x20, 0x1F, 0x0A, 0x77, 0x73, 0x0A, 0xF0, 0x17, 0x77, 0x20, 0x4F, 0x07, 0x77, 0x73, 0x0D, 0xE0,
  0xD7, 0x77, 0x30, 0x7F, 0x03, 0x77, 0x72, 0x02, 0xF0, 0x97, 0x77, 0x30, 0xBE, 0x0E,
  // "]" (U+005D)
  0x07, 0x80, 0x97, 0x80, 0x30, 0xDF, 0xFD, 0x06, 0x0D, 0xFF, 0xD0, 0x60, 0xDF, 0xFD, 0x06, 0x0D,
  0xFF, 0xD0, 0x60, 0xDF, 0xFD, 0x06, 0x0D, 0xFF, 0xD0, 0x67, 0x50, 0x5F, 0x06, 0x75, 0x05, 0xF0,
  0x67, 0x50, 0x5F, 0x06, 0x75, 0x05, 0xF0, 0x67, 0x50, 0x5F, 0x06, 0x75, 0x05, 0xF0, 0x67, 0x50,
  0x5F, 0x06, 0x75, 0x05, 0xF0, 0x67, 0x50, 0x5F, 0x06, 0x75, 0x05, 0xF0, 0x67, 0x50, 0x5F, 0x06,
  0x75, 0x05, 0xF0, 0x67, 0x50, 0x5F, 0x06, 0x75, 0x05, 0xF0, 0x67, 0x50, 0x5F, 0x06, 0x75, 0x05,
  0xF0, 0x67, 0x50, 0x5F, 0x06, 0x75, 0x05, 0xF0, 0x67, 0x50, 0x5F, 0x06, 0x75, 0x05, 0xF0, 0x67,
  0x50, 0x5F, 0x06, 0x75, 0x05, 0xF0, 0x67, 0x50, 0x5F, 0x06, 0x75, 0x05, 0xF0, 0x67, 0x50, 0x5F,
  0x06, 0x75, 0x05, 0xF0, 0x67, 0x50, 0x5F, 0x06, 0x75, 0x05, 0xF0, 0x67, 0x50, 0x5F, 0x06, 0x75,
  0x05, 0xF0, 0x67, 0x50, 0x5F, 0x06, 0x75, 0x05, 0xF0, 0x67, 0x50, 0x5F, 0x06, 0x75, 0x05, 0xF0,
  0x67, 0x50, 0x5F, 0x06, 0x75, 0x05, 0xF0, 0x67, 0x50, 0x5F, 0x06, 0x75, 0x05, 0xF0, 0x67, 0x50,
  0x5F, 0x06, 0x75, 0x05, 0xF0, 0x67, 0x50, 0x5F, 0x06, 0x75, 0x05, 0xF0, 0x67, 0x50, 0x5F, 0x06,
  0x75, 0x05, 0xF0, 0x67, 0x50, 0x5F, 0x06, 0x75, 0x05, 0xF0, 0x67, 0x50, 0x5F, 0x06, 0x75, 0x05,
  0xF0, 0x67, 0x50, 0x5F, 0x06, 0x75, 0x05, 0xF0, 0x67, 0x50, 0x5F, 0x06, 0x75, 0x05, 0xF0, 0x67,
  0x50, 0x5F, 0x06, 0x75, 0x05, 0xF0, 0x67, 0x50, 0x5F, 0x06, 0x75, 0x05, 0xF0, 0x67, 0x50, 0x5F,
  0x06, 0x75, 0x05, 0xF0, 0x67, 0x50, 0x5F, 0x06, 0x75, 0x05, 0xF0, 0x67, 0x50, 0x5F, 0x06, 0x75,
  0x05, 0xF0, 0x67, 0x50, 0x5F, 0x06, 0x75, 0x05, 0xF0, 0x67, 0x50, 0x5F, 0x06, 0x07, 0x80, 0x78,
  0x0A, 0xF0, 0x60, 0xDF, 0xFD, 0x06, 0x0D, 0xFF, 0xD0, 0x60, 0xDF, 0xFD, 0x06, 0x0D, 0xFF, 0xD0,
  0x60, 0xDF, 0xFD, 0x06, 0x0D, 0xFF, 0xD0, 0x60,
  // "^" (U+005E)
  0x77, 0x58, 0x42, 0x77, 0x77, 0x38, 0x0C, 0x40, 0x0B, 0xC0, 0xC8, 0x0C, 0x30, 0x02, 0xE0, 0x48,
  0x0C, 0x20, 0x0A, 0xE0, 0xC8, 0x0C, 0x10, 0x02, 0xF9, 0x05, 0x80, 0xC0, 0x00, 0x9F, 0x90, 0xD7,
  0x77, 0x77, 0x01, 0xFB, 0x06, 0x77, 0x77, 0x60, 0x8F, 0xB0, 0xD7, 0x77, 0x75, 0x01, 0x0E, 0xFC,
  0x07, 0x77, 0x77, 0x40, 0x8D, 0x0E, 0x0C, 0xD0, 0xE7, 0x77, 0x74, 0x0E, 0xD0, 0x80, 0x4E, 0x07,
  0x77, 0x77, 0x20, 0x7E, 0x81, 0x10, 0xBD, 0x0E, 0x01, 0x77, 0x77, 0x10, 0xED, 0x09, 0x20, 0x3E,
  0x08, 0x77, 0x77, 0x06, 0xE0, 0x23, 0x0B, 0xE0, 0x17, 0x77, 0x60, 0xDD, 0x0A, 0x40, 0x3E, 0x09,
  0x77, 0x75, 0x05, 0xE0, 0x35, 0x0A, 0xE0, 0x27, 0x77, 0x40, 0xDD, 0x0C, 0x60, 0x2E, 0x0A, 0x77,
  0x73, 0x05, 0xE0, 0x47, 0x0A, 0xE0, 0x27, 0x77, 0x20, 0xCD, 0x0D, 0x71, 0x02, 0xE0, 0xA7, 0x77,
  0x10, 0x4E, 0x06, 0x72, 0x09, 0xE0, 0x37, 0x77, 0x0B, 0xD0, 0xE7, 0x30, 0x2E, 0x0B, 0x77, 0x60,
  0x3E, 0x07, 0x74, 0x09, 0xE0, 0x47, 0x75, 0x0A, 0xD0, 0xE0, 0x17, 0x40, 0x1E, 0x0C, 0x77, 0x40,
  0x2E, 0x08, 0x76, 0x08, 0xE0, 0x57, 0x73, 0x0A, 0xE0, 0x17, 0x60, 0x10, 0xED, 0x0D, 0x77, 0x20,
  0x2E, 0x09, 0x77, 0x10, 0x8E, 0x05, 0x77, 0x10, 0x9E, 0x02, 0x77, 0x10, 0x10, 0xED, 0x0D, 0x77,
  0x01, 0xE0, 0xB7, 0x73, 0x07, 0xE0, 0x67, 0x60, 0x8E, 0x04, 0x77, 0x40, 0xED, 0x0E, 0x75, 0x01,
  0x0E, 0xD0, 0xC7, 0x75, 0x07, 0xE0, 0x77, 0x40, 0x7E, 0x05, 0x77, 0x60, 0xED, 0x0E, 0x74, 0x0E,
  0xD0, 0xD7, 0x77, 0x06, 0xE0, 0x87, 0x20, 0x7E, 0x06, 0x77, 0x71, 0x0D, 0xD0, 0xE0, 0x17, 0x10,
  0xDD, 0x0E, 0x77, 0x72, 0x06, 0xE0, 0x87, 0x06, 0xE0, 0x77, 0x77, 0x30, 0xDE, 0x01, 0x60, 0xDD,
  0x0E, 0x01, 0x77, 0x73, 0x05, 0xE0, 0x95, 0x05, 0xE0, 0x97, 0x77, 0x50, 0xCE, 0x02, 0x40, 0xCE,
  0x02, 0x77, 0x75, 0x05, 0xE0, 0xA3, 0x04, 0xE0, 0xA7, 0x77, 0x70, 0xCE, 0x03, 0x20, 0xCE, 0x03,
  0x77, 0x77, 0x04, 0xE8, 0x1B, 0x04, 0xE0, 0xB7, 0x77, 0x72, 0x0C, 0xE0, 0x30,
  // "_" (U+005F)
  0x80, 0xDE, 0x6F,
  // "`" (U+0060)
  0x80, 0x57, 0x04, 0x72, 0x0E, 0xF9, 0x0E, 0x72, 0x04, 0xFA, 0x07, 0x72, 0x08, 0xF9, 0x0E, 0x01,
  0x72, 0x0B, 0xF9, 0x0A, 0x73, 0x0C, 0xF9, 0x04, 0x72, 0x01, 0x0D, 0xF0, 0xD7, 0x30, 0x20, 0xEF,
  0x08, 0x73, 0x03, 0x0E, 0xF0, 0x37, 0x30, 0x30, 0xEE, 0x0C, 0x74, 0x03, 0x0E, 0xE0, 0x87, 0x40,
  0x30, 0xEE, 0x04, 0x74, 0x03, 0x0E, 0xD0, 0xE0, 0x17, 0x40, 0x20, 0xDD, 0x0B, 0x75, 0x01, 0x0B,
  0xD0, 0x10,
  // "a" (U+0061)
  0x76, 0x85, 0x47, 0x9B, 0xDE, 0xEA, 0x85, 0xEE, 0xCA, 0x85, 0x17, 0x76, 0x81, 0x16, 0xBF, 0xFB,
  0x81, 0xC7, 0x17, 0x71, 0x06, 0x0B, 0xFF, 0xFA, 0x08, 0x01, 0x73, 0x81, 0x18, 0xEF, 0xFF, 0xD0,
  0xE0, 0x47, 0x10, 0x1F, 0xFF, 0xFB, 0x06, 0x71, 0x0B, 0xFF, 0xFF, 0xB0, 0x67, 0x04, 0xFC, 0x87,
  0xDB, 0x99, 0x89, 0xAB, 0xEF, 0xD0, 0x37, 0x0C, 0xE8, 0x1C, 0x73, 0x73, 0x81, 0x28, 0xDF, 0xA0,
  0xC7, 0x05, 0xB8, 0x1E, 0x82, 0x77, 0x20, 0x7F, 0xA0, 0x47, 0x81, 0xDE, 0x67, 0x76, 0x03, 0x0E,
  0xF0, 0xB7, 0x03, 0x77, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x77, 0x30, 0xBF, 0x05, 0x77, 0x77, 0x30,
  0x4F, 0x08, 0x77, 0x77, 0x40, 0xEE, 0x0A, 0x77, 0x77, 0x40, 0xCE, 0x0C, 0x77, 0x77, 0x40, 0x9E,
  0x0D, 0x77, 0x77, 0x40, 0x8E, 0x0D, 0x77, 0x77, 0x40, 0x7E, 0x0E, 0x77, 0x77, 0x40, 0x7E, 0x0E,
  0x77, 0x77, 0x40, 0x7E, 0x0E, 0x76, 0x86, 0x25, 0x8A, 0xCD, 0xEE, 0xFF, 0xC0, 0xE7, 0x38, 0x15,
  0xAE, 0xFF, 0xFD, 0x0E, 0x78, 0x11, 0x8E, 0xFF, 0xFF, 0x90, 0xE6, 0x06, 0x0E, 0xFF, 0xFF, 0xB0,
  0xE4, 0x01, 0x0B, 0xFF, 0xFF, 0xD0, 0xE3, 0x01, 0x0D, 0xFF, 0xFF, 0xE0, 0xE3, 0x0C, 0xFC, 0x85,
  0xD9, 0x74, 0x31, 0x17, 0x30, 0x7E, 0x0E, 0x20, 0x8F, 0xA8, 0x1E, 0x82, 0x77, 0x30, 0x7E, 0x81,
  0xE0, 0x2F, 0xA0, 0x90, 0x17, 0x75, 0x07, 0xE8, 0x1E, 0x08, 0xF9, 0x07, 0x77, 0x70, 0x7E, 0x81,
  0xE0, 0xEF, 0x09, 0x77, 0x71, 0x07, 0xE0, 0xE0, 0x3F, 0x0D, 0x77, 0x72, 0x08, 0xE0, 0xE0, 0x6F,
  0x08, 0x77, 0x72, 0x0A, 0xE0, 0xE0, 0x8F, 0x03, 0x77, 0x72, 0x0D, 0xE0, 0xE0, 0xAF, 0x01, 0x77,
  0x71, 0x01, 0xF0, 0xE0, 0xAF, 0x77, 0x72, 0x07, 0xF0, 0xE0, 0xAF, 0x77, 0x72, 0x0D, 0xF0, 0xE0,
  0x9F, 0x02, 0x77, 0x70, 0x7F, 0x90, 0xE0, 0x7F, 0x06, 0x77, 0x60, 0x4F, 0xA0, 0xE0, 0x5F, 0x0C,
  0x77, 0x50, 0x40, 0xEF, 0xA0, 0xE0, 0x1F, 0x90, 0x67, 0x73, 0x06, 0xFC, 0x81, 0xE0, 0xCF, 0x90,
  0x77, 0x70, 0x40, 0xBF, 0xD8, 0x1E, 0x05, 0xFA, 0x81, 0xC6, 0x17, 0x18, 0x12, 0x7C, 0xE0, 0xE0,
  0xBE, 0x0E, 0x20, 0xDF, 0xC8, 0x6D, 0xA9, 0x89, 0xAC, 0xEF, 0xA0, 0x40, 0x5E, 0x0E, 0x20, 0x3F,
  0xFF, 0xE8, 0x15, 0x03, 0xE0, 0xE3, 0x05, 0xFF, 0xFB, 0x0E, 0x04, 0x20, 0x1E, 0x0E, 0x40, 0x40,
  0xEF, 0xFF, 0x0C, 0x02, 0x40, 0xED, 0x0E, 0x50, 0x10, 0xAF, 0xFC, 0x0E, 0x07, 0x60, 0xCD, 0x0E,
  0x78, 0x13, 0x9E, 0xFE, 0x81, 0xD7, 0x17, 0x0A, 0xD0, 0xE7, 0x38, 0x93, 0x47, 0xBC, 0xDE, 0xFE,
  0xDB, 0x96, 0x27, 0x73,
  // "b" (U+0062)
  0x0C, 0xF7, 0x77, 0x76, 0x0C, 0xF7, 0x77, 0x76, 0x0C, 0xF7, 0x77, 0x76, 0x0C, 0xF7, 0x77, 0x76,
  0x0C, 0xF7, 0x77, 0x76, 0x0C, 0xF7, 0x77, 0x76, 0x0C, 0xF7, 0x77, 0x76, 0x0C, 0xF7, 0x77, 0x76,
  0x0C, 0xF7, 0x77, 0x76, 0x0C, 0xF7, 0x77, 0x76, 0x0C, 0xF7, 0x77, 0x76, 0x0C, 0xF7, 0x77, 0x76,
  0x0C, 0xF7, 0x77, 0x76, 0x0C, 0xF7, 0x77, 0x76, 0x0C, 0xF7, 0x77, 0x76, 0x0C, 0xF7, 0x77, 0x76,
  0x0C, 0xF7, 0x77, 0x76, 0x0C, 0xF7, 0x77, 0x76, 0x0C, 0xF7, 0x77, 0x76, 0x0C, 0xF7, 0x18, 0x93,
  0x16, 0x9C, 0xDE, 0xFE, 0xEC, 0x96, 0x27, 0x60, 0xCF, 0x60, 0x40, 0xBF, 0xE0, 0xC0, 0x67, 0x40,
  0xCF, 0x40, 0x20, 0xCF, 0xFB, 0x0D, 0x05, 0x72, 0x0C, 0xE0, 0xE3, 0x06, 0xFF, 0xF0, 0xA7, 0x10,
  0xCE, 0x0D, 0x20, 0x8F, 0xFF, 0xA0, 0xC0, 0x16, 0x0C, 0xE8, 0x1C, 0x08, 0xFF, 0xFC, 0x0D, 0x01,
  0x50, 0xCE, 0x0B, 0x06, 0xFA, 0x85, 0xC9, 0x88, 0x9B, 0xEF, 0xC0, 0xC5, 0x0C, 0xE0, 0x0E, 0xE0,
  0xB0, 0x47, 0x10, 0x30, 0xAF, 0xB0, 0x94, 0x0C, 0xFD, 0x0E, 0x04, 0x75, 0x03, 0x0C, 0xFA, 0x03,
  0x30, 0xCF, 0xC0, 0xD0, 0x17, 0x71, 0x0B, 0xF9, 0x0C, 0x30, 0xCF, 0xB0, 0xE0, 0x17, 0x73, 0x0D,
  0xF9, 0x05, 0x20, 0xCF, 0xB0, 0x47, 0x74, 0x03, 0xF9, 0x0C, 0x20, 0xCF, 0xA0, 0xB7, 0x76, 0x0A,
  0xF9, 0x81, 0x20, 0xCF, 0xA0, 0x27, 0x76, 0x03, 0xF9, 0x81, 0x70, 0xCF, 0x90, 0xB7, 0x77, 0x10,
  0xCF, 0x81, 0xC0, 0xCF, 0x90, 0x57, 0x77, 0x10, 0x7F, 0x91, 0x0C, 0xF9, 0x01, 0x77, 0x71, 0x02,
  0xF9, 0x04, 0x0C, 0xF0, 0xC7, 0x77, 0x30, 0xEF, 0x06, 0x0C, 0xF0, 0x97, 0x77, 0x30, 0xCF, 0x09,
  0x0C, 0xF0, 0x67, 0x77, 0x30, 0x9F, 0x0B, 0x0C, 0xF0, 0x47, 0x77, 0x30, 0x7F, 0x00, 0xCF, 0x03,
  0x77, 0x73, 0x06, 0xF0, 0xE0, 0xCF, 0x02, 0x77, 0x73, 0x05, 0xF9, 0x0C, 0xF0, 0x17, 0x77, 0x30,
  0x4F, 0x90, 0xCF, 0x77, 0x74, 0x03, 0xF9, 0x0C, 0xF7, 0x77, 0x40, 0x3F, 0x90, 0xCF, 0x01, 0x77,
  0x73, 0x04, 0xF9, 0x0C, 0xF0, 0x17, 0x77, 0x30, 0x4F, 0x90, 0xCF, 0x02, 0x77, 0x73, 0x05, 0xF0,
  0xE0, 0xCF, 0x04, 0x77, 0x73, 0x07, 0xF0, 0x0C, 0xF0, 0x67, 0x77, 0x30, 0x9F, 0x0B, 0x0C, 0xF0,
  0x97, 0x77, 0x30, 0xBF, 0x09, 0x0C, 0xF0, 0xC7, 0x77, 0x30, 0xEF, 0x06, 0x0C, 0xF9, 0x77, 0x72,
  0x02, 0xF9, 0x03, 0x0C, 0xF9, 0x04, 0x77, 0x71, 0x06, 0xF9, 0x10, 0xCF, 0x90, 0xA7, 0x77, 0x10,
  0xCF, 0x81, 0xB0, 0xCF, 0xA0, 0x17, 0x76, 0x02, 0xF9, 0x81, 0x70, 0xCF, 0xA0, 0x87, 0x76, 0x09,
  0xF9, 0x81, 0x10, 0xCF, 0xB0, 0x27, 0x74, 0x03, 0xF9, 0x0B, 0x20, 0xCF, 0xB0, 0xC7, 0x74, 0x0D,
  0xF9, 0x04, 0x20, 0xCF, 0xC0, 0xB7, 0x72, 0x0B, 0xF9, 0x0B, 0x30, 0xCF, 0xD0, 0xD0, 0x37, 0x50,
  0x20, 0xCF, 0xA0, 0x33, 0x0C, 0xFF, 0x0A, 0x04, 0x71, 0x03, 0x09, 0xFB, 0x07, 0x40, 0xCE, 0x05,
  0x09, 0xF9, 0x86, 0xEB, 0x98, 0x89, 0xBE, 0xFC, 0x0B, 0x50, 0xCE, 0x81, 0x30, 0xBF, 0xFF, 0xC0,
  0xC6, 0x0C, 0xE0, 0x12, 0x0A, 0xFF, 0xFA, 0x0B, 0x01, 0x60, 0xCE, 0x40, 0x7F, 0xFF, 0x09, 0x71,
  0x0C, 0xD0, 0xD5, 0x02, 0x0C, 0xFF, 0xB0, 0xD0, 0x47, 0x20, 0xCD, 0x0B, 0x70, 0x40, 0xBF, 0xE0,
  0xC0, 0x57, 0x77, 0x68, 0x93, 0x16, 0x9C, 0xDE, 0xFE, 0xEC, 0x96, 0x27, 0x60,
  // "c" (U+0063)
  0x77, 0x38, 0x44, 0x79, 0xCD, 0xEA, 0x85, 0xED, 0xCB, 0x96, 0x37, 0x76, 0x81, 0x17, 0xCF, 0xFB,
  0x81, 0xB6, 0x17, 0x70, 0x30, 0xAF, 0xFF, 0xA0, 0xA0, 0x37, 0x30, 0x10, 0xAF, 0xFF, 0xE0, 0x47,
  0x10, 0x40, 0xEF, 0xFF, 0xE0, 0xE7, 0x10, 0x6F, 0xFF, 0xF9, 0x09, 0x70, 0x6F, 0xE8, 0x7D, 0xB9,
  0x98, 0x9A, 0xBE, 0xF9, 0x03, 0x60, 0x4F, 0xC8, 0x1B, 0x51, 0x72, 0x81, 0x15, 0xBC, 0x0D, 0x60,
  0x10, 0xEF, 0xA0, 0xA0, 0x27, 0x71, 0x83, 0x17, 0xEF, 0x76, 0x0A, 0xFA, 0x05, 0x77, 0x58, 0x11,
  0x82, 0x50, 0x4F, 0xA0, 0x47, 0x77, 0x70, 0xBF, 0x90, 0x67, 0x77, 0x70, 0x3F, 0x90, 0xB7, 0x77,
  0x71, 0x09, 0xF9, 0x02, 0x77, 0x77, 0x10, 0xEF, 0x0B, 0x77, 0x77, 0x10, 0x2F, 0x90, 0x57, 0x77,
  0x71, 0x07, 0xF9, 0x77, 0x77, 0x20, 0xAF, 0x0B, 0x77, 0x77, 0x20, 0xCF, 0x08, 0x77, 0x77, 0x20,
  0xEF, 0x05, 0x77, 0x77, 0x10, 0x1F, 0x90, 0x37, 0x77, 0x71, 0x02, 0xF9, 0x01, 0x77, 0x77, 0x10,
  0x3F, 0x97, 0x77, 0x72, 0x04, 0xF9, 0x77, 0x77, 0x20, 0x4F, 0x0E, 0x77, 0x77, 0x20, 0x5F, 0x0E,
  0x77, 0x77, 0x20, 0x4F, 0x97, 0x77, 0x72, 0x04, 0xF9, 0x77, 0x77, 0x20, 0x3F, 0x90, 0x17, 0x77,
  0x71, 0x02, 0xF9, 0x02, 0x77, 0x77, 0x2F, 0x90, 0x47, 0x77, 0x72, 0x0E, 0xF0, 0x67, 0x77, 0x72,
  0x0C, 0xF0, 0xA7, 0x77, 0x72, 0x09, 0xF0, 0xD7, 0x77, 0x72, 0x06, 0xF9, 0x03, 0x77, 0x77, 0x10,
  0x1F, 0x90, 0x87, 0x77, 0x72, 0x0D, 0xF0, 0xE7, 0x77, 0x72, 0x07, 0xF9, 0x08, 0x77, 0x77, 0x10,
  0x1F, 0xA0, 0x37, 0x77, 0x71, 0x09, 0xF9, 0x0E, 0x02, 0x77, 0x77, 0x02, 0xFA, 0x0E, 0x04, 0x77,
  0x71, 0x04, 0x50, 0x7F, 0xB0, 0x90, 0x17, 0x73, 0x82, 0x38, 0xDE, 0x60, 0xBF, 0xC8, 0x1A, 0x51,
  0x73, 0x82, 0x25, 0x9D, 0xB0, 0xE6, 0x01, 0x0D, 0xFE, 0x87, 0xDB, 0x98, 0x89, 0xAB, 0xCF, 0x90,
  0xE7, 0x01, 0x0C, 0xFF, 0xFF, 0x90, 0xE7, 0x20, 0xAF, 0xFF, 0xF0, 0xE7, 0x30, 0x50, 0xEF, 0xFF,
  0xD0, 0xE7, 0x50, 0x80, 0xEF, 0xFF, 0xB0, 0x97, 0x70, 0x50, 0xBF, 0xFC, 0x81, 0xD9, 0x57, 0x75,
  0x84, 0x47, 0xAB, 0xDE, 0xA8, 0x7E, 0xED, 0xCA, 0x86, 0x41, 0x60,
  // "d" (U+0064)
  0x77, 0x77, 0x50, 0x3F, 0x0C, 0x77, 0x77, 0x50, 0x3F, 0x0C, 0x77, 0x77, 0x50, 0x3F, 0x0C, 0x77,
  0x77, 0x50, 0x3F, 0x0C, 0x77, 0x77, 0x50, 0x3F, 0x0C, 0x77, 0x77, 0x50, 0x3F, 0x0C, 0x77, 0x77,
  0x50, 0x3F, 0x0C, 0x77, 0x77, 0x50, 0x3F, 0x0C, 0x77, 0x77, 0x50, 0x3F, 0x0C, 0x77, 0x77, 0x50,
  0x3F, 0x0C, 0x77, 0x77, 0x50, 0x3F, 0x0C, 0x77, 0x77, 0x50, 0x3F, 0x0C, 0x77, 0x77, 0x50, 0x3F,
  0x0C, 0x77, 0x77, 0x50, 0x3F, 0x0C, 0x77, 0x77, 0x50, 0x3F, 0x0C, 0x77, 0x77, 0x50, 0x3F, 0x0C,
  0x77, 0x77, 0x50, 0x3F, 0x0C, 0x77, 0x77, 0x50, 0x3F, 0x0C, 0x77, 0x77, 0x50, 0x3F, 0x0C, 0x76,
  0x89, 0x41, 0x58, 0xAC, 0xEE, 0xFE, 0xDC, 0x95, 0x16, 0x03, 0xF0, 0xC7, 0x40, 0x60, 0xBF, 0xF0,
  0xA0, 0x24, 0x02, 0xF0, 0xC7, 0x20, 0x60, 0xDF, 0xFC, 0x08, 0x30, 0x1F, 0x0C, 0x70, 0x10, 0xBF,
  0xFF, 0x0B, 0x01, 0x2F, 0x0C, 0x60, 0x30, 0xEF, 0xFF, 0xA0, 0xC2, 0x0E, 0xE0, 0xC5, 0x03, 0x0E,
  0xFF, 0xFC, 0x81, 0xB0, 0xDE, 0x0C, 0x40, 0x10, 0xEF, 0xD8, 0x5D, 0xA9, 0x89, 0xAE, 0xF9, 0x06,
  0x0B, 0xE0, 0xC4, 0x0B, 0xFB, 0x81, 0xD7, 0x17, 0x81, 0x28, 0xEF, 0xE0, 0xC3, 0x06, 0xFB, 0x08,
  0x75, 0x02, 0x0C, 0xFD, 0x0C, 0x30, 0xEF, 0xA0, 0x47, 0x71, 0x0B, 0xFC, 0x0C, 0x20, 0x6F, 0xA0,
  0x47, 0x73, 0x0C, 0xFB, 0x0C, 0x20, 0xDF, 0x90, 0x87, 0x74, 0x03, 0xFB, 0x81, 0xC0, 0x3F, 0x90,
  0xD7, 0x76, 0x09, 0xFA, 0x81, 0xC0, 0x8F, 0x90, 0x57, 0x76, 0x02, 0xFA, 0x81, 0xC0, 0xDF, 0x0E,
  0x77, 0x71, 0x0B, 0xF9, 0x0C, 0x01, 0xF9, 0x08, 0x77, 0x71, 0x06, 0xF9, 0x0C, 0x04, 0xF9, 0x04,
  0x77, 0x71, 0x02, 0xF9, 0x0C, 0x07, 0xF9, 0x77, 0x73, 0x0E, 0xF0, 0xC0, 0x9F, 0x0C, 0x77, 0x73,
  0x0B, 0xF0, 0xC0, 0xBF, 0x0A, 0x77, 0x73, 0x09, 0xF0, 0xC0, 0xDF, 0x08, 0x77, 0x73, 0x07, 0xF0,
  0xC0, 0xEF, 0x06, 0x77, 0x73, 0x05, 0xF0, 0xCF, 0x90, 0x57, 0x77, 0x30, 0x4F, 0x0C, 0xF9, 0x04,
  0x77, 0x73, 0x03, 0xF0, 0xCF, 0x90, 0x37, 0x77, 0x30, 0x3F, 0x0C, 0xF9, 0x03, 0x77, 0x73, 0x03,
  0xF0, 0xCF, 0x90, 0x37, 0x77, 0x30, 0x3F, 0x0C, 0xF9, 0x04, 0x77, 0x73, 0x03, 0xF0, 0xC0, 0xEF,
  0x05, 0x77, 0x73, 0x04, 0xF0, 0x0C, 0xF0, 0x67, 0x77, 0x30, 0x5F, 0x0C, 0x0B, 0xF0, 0x87, 0x77,
  0x30, 0x6F, 0x0C, 0x09, 0xF0, 0xA7, 0x77, 0x30, 0x9F, 0x0C, 0x06, 0xF0, 0xD7, 0x77, 0x30, 0xBF,
  0x0C, 0x04, 0xF9, 0x01, 0x77, 0x72, 0x0E, 0xF0, 0xC1, 0xF9, 0x05, 0x77, 0x71, 0x03, 0xF9, 0x81,
  0xC0, 0xCF, 0x0A, 0x77, 0x71, 0x09, 0xF9, 0x81, 0xC0, 0x7F, 0x90, 0x17, 0x77, 0x0E, 0xF9, 0x81,
  0xC0, 0x2F, 0x90, 0x87, 0x76, 0x07, 0xFA, 0x0C, 0x20, 0xCF, 0x90, 0x27, 0x74, 0x01, 0x0E, 0xFA,
  0x0C, 0x20, 0x5F, 0x90, 0xD7, 0x74, 0x0A, 0xFB, 0x0C, 0x30, 0xCF, 0x90, 0xB7, 0x72, 0x09, 0xFC,
  0x0C, 0x30, 0x4F, 0xA0, 0xD0, 0x37, 0x50, 0x10, 0xBF, 0xD0, 0xC4, 0x09, 0xFB, 0x0A, 0x04, 0x71,
  0x81, 0x28, 0xED, 0x00, 0xEE, 0x0C, 0x50, 0xCF, 0xC8, 0x6E, 0xC9, 0x88, 0x9B, 0xEF, 0x90, 0x40,
  0xAE, 0x0C, 0x50, 0x10, 0xDF, 0xFF, 0xC8, 0x18, 0x07, 0xE0, 0xC6, 0x01, 0x0C, 0xFF, 0xFA, 0x09,
  0x20, 0x5E, 0x0C, 0x71, 0x09, 0xFF, 0xF0, 0x73, 0x03, 0xE0, 0xC7, 0x20, 0x40, 0xDF, 0xFB, 0x0D,
  0x04, 0x40, 0x1E, 0x0C, 0x74, 0x05, 0x0B, 0xFE, 0x0D, 0x07, 0x70, 0xED, 0x0C, 0x76, 0x89, 0x31,
  0x59, 0xBD, 0xEF, 0xEE, 0xCA, 0x73, 0x77, 0x20,
  // "e" (U+0065)
  0x77, 0x28, 0x94, 0x25, 0x8B, 0xDD, 0xEF, 0xED, 0xC9, 0x63, 0x77, 0x76, 0x81, 0x17, 0xCF, 0xF8,
  0x1D, 0x81, 0x77, 0x71, 0x01, 0x09, 0xFF, 0xE0, 0x90, 0x17, 0x75, 0x06, 0xFF, 0xFA, 0x0E, 0x04,
  0x77, 0x20, 0x10, 0xBF, 0xFF, 0xD0, 0x77, 0x70, 0x20, 0xDF, 0xFF, 0xF0, 0x87, 0x50, 0x20, 0xEF,
  0xD8, 0x5C, 0xA9, 0x8A, 0xBE, 0xFC, 0x06, 0x73, 0x01, 0x0D, 0xFB, 0x09, 0x04, 0x71, 0x81, 0x38,
  0xEF, 0xA0, 0x37, 0x20, 0xBF, 0xA0, 0x90, 0x17, 0x50, 0x10, 0xAF, 0x90, 0xD7, 0x10, 0x6F, 0xA0,
  0x67, 0x72, 0x08, 0xF9, 0x08, 0x60, 0x10, 0xEF, 0x90, 0x47, 0x74, 0x09, 0xF0, 0xE0, 0x15, 0x09,
  0xF9, 0x05, 0x77, 0x60, 0xDF, 0x07, 0x40, 0x1F, 0x90, 0x97, 0x77, 0x05, 0xF0, 0xD4, 0x07, 0xF0,
  0xE0, 0x17, 0x77, 0x10, 0xDF, 0x04, 0x30, 0xEF, 0x07, 0x77, 0x72, 0x07, 0xF0, 0x82, 0x03, 0xF9,
  0x01, 0x77, 0x72, 0x03, 0xF0, 0xC2, 0x07, 0xF0, 0xA7, 0x77, 0x40, 0xEF, 0x20, 0xCF, 0x05, 0x77,
  0x74, 0x0B, 0xF0, 0x21, 0xF9, 0x01, 0x77, 0x74, 0x0A, 0xF0, 0x40, 0x2F, 0x0D, 0x77, 0x75, 0x08,
  0xF0, 0x60, 0x48, 0x0C, 0x6F, 0x07, 0x06, 0x80, 0xC6, 0xF0, 0x80, 0x78, 0x0C, 0x6F, 0x09, 0x08,
  0x80, 0xC6, 0xF0, 0x90, 0x88, 0x0C, 0x6F, 0x00, 0x98, 0x0C, 0x6F, 0x09, 0x08, 0xF0, 0xC8, 0x0B,
  0x68, 0x05, 0x07, 0xF0, 0xA7, 0x77, 0x77, 0x06, 0xF0, 0xB7, 0x77, 0x77, 0x05, 0xF0, 0xC7, 0x77,
  0x77, 0x03, 0xF0, 0xE8, 0x0C, 0x00, 0xF9, 0x02, 0x77, 0x77, 0x70, 0xDF, 0x05, 0x77, 0x77, 0x70,
  0x9F, 0x0A, 0x77, 0x77, 0x70, 0x4F, 0x0E, 0x80, 0xC0, 0x00, 0xEF, 0x06, 0x77, 0x77, 0x70, 0x9F,
  0x0D, 0x77, 0x77, 0x70, 0x3F, 0x90, 0x97, 0x77, 0x77, 0x0A, 0xF9, 0x05, 0x77, 0x77, 0x60, 0x2F,
  0xA0, 0x57, 0x77, 0x50, 0x10, 0x26, 0x07, 0xFA, 0x08, 0x77, 0x72, 0x82, 0x4A, 0xF6, 0x70, 0xBF,
  0xA0, 0xD0, 0x57, 0x74, 0x81, 0x38, 0xDB, 0x06, 0x70, 0x10, 0xDF, 0xB8, 0x2E, 0x94, 0x17, 0x38,
  0x21, 0x59, 0xDE, 0x06, 0x71, 0x01, 0x0D, 0xFE, 0x89, 0x0D, 0xBA, 0x98, 0x89, 0xAC, 0xEF, 0xB0,
  0x67, 0x20, 0x10, 0xCF, 0xFF, 0xFC, 0x06, 0x74, 0x08, 0xFF, 0xFF, 0xB0, 0x67, 0x50, 0x30, 0xCF,
  0xFF, 0xF0, 0xE0, 0x47, 0x70, 0x50, 0xCF, 0xFF, 0xB0, 0xB0, 0x57, 0x74, 0x81, 0x38, 0xDF, 0xFB,
  0x82, 0xD9, 0x51, 0x77, 0x72, 0x85, 0x25, 0x8A, 0xCD, 0xEA, 0x86, 0xED, 0xDB, 0x97, 0x41, 0x73,
  // "f" (U+0066)
  0x77, 0x75, 0x85, 0x14, 0x7A, 0xCD, 0xEA, 0x86, 0xEE, 0xDC, 0xA8, 0x62, 0x77, 0x77, 0x06, 0x0B,
  0xFF, 0xB8, 0x2E, 0xB6, 0x17, 0x77, 0x10, 0x60, 0xEF, 0xFF, 0x90, 0x17, 0x76, 0x01, 0x0B, 0xFF,
  0xFA, 0x0C, 0x77, 0x60, 0x10, 0xDF, 0xFF, 0xB0, 0x77, 0x76, 0x0B, 0xFF, 0xFC, 0x03, 0x77, 0x50,
  0x6F, 0xD8, 0x7D, 0xA9, 0x89, 0x9A, 0xCE, 0xC0, 0xE7, 0x76, 0x0E, 0xFA, 0x81, 0xC6, 0x17, 0x28,
  0x31, 0x47, 0xB9, 0x77, 0x50, 0x5F, 0xA0, 0x68, 0x0C, 0x00, 0x0A, 0xF9, 0x06, 0x80, 0xC1, 0x00,
  0xEF, 0x0C, 0x80, 0xC1, 0x00, 0x1F, 0x90, 0x68, 0x0C, 0x10, 0x03, 0xF9, 0x02, 0x80, 0xC1, 0x00,
  0x3F, 0x0E, 0x80, 0xC2, 0x00, 0x4F, 0x0D, 0x80, 0xC2, 0x00, 0x4F, 0x0C, 0x80, 0xC2, 0x00, 0x4F,
  0x0C, 0x80, 0xC2, 0x00, 0x4F, 0x0C, 0x80, 0xC2, 0x00, 0x4F, 0x0C, 0x80, 0xC2, 0x00, 0x4F, 0x0C,
  0x77, 0x75, 0x89, 0x21, 0x23, 0x56, 0x78, 0x9A, 0xBD, 0xEF, 0xFF, 0xE5, 0x0D, 0x0E, 0x80, 0xC4,
  0xF4, 0x01, 0x80, 0xC6, 0xF4, 0x01, 0x80, 0xC6, 0xF4, 0x01, 0x80, 0xC6, 0xF4, 0x01, 0x80, 0xC6,
  0xF5, 0x80, 0x93, 0x80, 0xAF, 0x0E, 0x80, 0x96, 0x87, 0x76, 0x04, 0xF0, 0xC8, 0x0C, 0x20, 0x04,
  0xF0, 0xC8, 0x0C, 0x20, 0x04, 0xF0, 0xC8, 0x0C, 0x20, 0x04, 0xF0, 0xC8, 0x0C, 0x20, 0x04, 0xF0,
  0xC8, 0x0C, 0x20, 0x04, 0xF0, 0xC8, 0x0C, 0x20, 0x04, 0xF0, 0xC8, 0x0C, 0x20, 0x04, 0xF0, 0xC8,
  0x0C, 0x20, 0x04, 0xF0, 0xC8, 0x0C, 0x20, 0x04, 0xF0, 0xC8, 0x0C, 0x20, 0x04, 0xF0, 0xC8, 0x0C,
  0x20, 0x04, 0xF0, 0xC8, 0x0C, 0x20, 0x04, 0xF0, 0xC8, 0x0C, 0x20, 0x04, 0xF0, 0xC8, 0x0C, 0x20,
  0x04, 0xF0, 0xC8, 0x0C, 0x20, 0x04, 0xF0, 0xC8, 0x0C, 0x20, 0x04, 0xF0, 0xC8, 0x0C, 0x20, 0x04,
  0xF0, 0xC8, 0x0C, 0x20, 0x04, 0xF0, 0xC8, 0x0C, 0x20, 0x04, 0xF0, 0xC8, 0x0C, 0x20, 0x04, 0xF0,
  0xC8, 0x0C, 0x20, 0x04, 0xF0, 0xC8, 0x0C, 0x20, 0x04, 0xF0, 0xC8, 0x0C, 0x20, 0x04, 0xF0, 0xC8,
  0x0C, 0x20, 0x04, 0xF0, 0xC8, 0x0C, 0x20, 0x04, 0xF0, 0xC8, 0x0C, 0x20, 0x04, 0xF0, 0xC8, 0x0C,
  0x20, 0x04, 0xF0, 0xC8, 0x0C, 0x20, 0x04, 0xF0, 0xC8, 0x0C, 0x20, 0x04, 0xF0, 0xC8, 0x0C, 0x20,
  0x04, 0xF0, 0xC8, 0x0C, 0x20, 0x04, 0xF0, 0xC8, 0x0C, 0x20, 0x04, 0xF0, 0xC8, 0x0C, 0x20, 0x04,
  0xF0, 0xC8, 0x0C, 0x20, 0x04, 0xF0, 0xC8, 0x0C, 0x20, 0x04, 0xF0, 0xC8, 0x0C, 0x20, 0x04, 0xF0,
  0xC8, 0x0C, 0x20, 0x04, 0xF0, 0xC8, 0x0C, 0x20, 0x04, 0xF0, 0xC8, 0x0C, 0x20, 0x04, 0xF0, 0xC8,
  0x0C, 0x20, 0x04, 0xF0, 0xC7, 0x77, 0x10,
  // "g" (U+0067)
  0x76, 0x89, 0x31, 0x59, 0xBD, 0xEF, 0xEE, 0xCA, 0x73, 0x77, 0x76, 0x04, 0x0B, 0xFE, 0x81, 0xE8,
  0x16, 0x0C, 0xD0, 0xC7, 0x20, 0x30, 0xCF, 0xFB, 0x0E, 0x06, 0x50, 0xED, 0x0C, 0x71, 0x07, 0xFF,
  0xF0, 0xA3, 0x02, 0xE0, 0xC7, 0x0A, 0xFF, 0xFA, 0x0B, 0x20, 0x5E, 0x0C, 0x60, 0xAF, 0xFF, 0xC8,
  0x1A, 0x07, 0xE0, 0xC5, 0x08, 0xFD, 0x85, 0xCA, 0x98, 0x9B, 0xDF, 0x90, 0x70, 0xBE, 0x0C, 0x40,
  0x4F, 0xB0, 0xB0, 0x57, 0x18, 0x12, 0x7E, 0xFE, 0x0C, 0x30, 0x10, 0xEF, 0x90, 0xE0, 0x47, 0x60,
  0x9F, 0xD0, 0xC3, 0x08, 0xF9, 0x0D, 0x01, 0x77, 0x10, 0x5F, 0xC0, 0xC2, 0x01, 0xF9, 0x0E, 0x01,
  0x77, 0x30, 0x5F, 0xB0, 0xC2, 0x08, 0xF9, 0x04, 0x77, 0x50, 0x8F, 0xA0, 0xC2, 0x0E, 0xF0, 0xC7,
  0x77, 0x0D, 0xF9, 0x81, 0xC0, 0x5F, 0x90, 0x47, 0x77, 0x06, 0xF9, 0x81, 0xC0, 0xAF, 0x0D, 0x77,
  0x72, 0x0E, 0xF8, 0x1C, 0x0E, 0xF0, 0x87, 0x77, 0x20, 0xAF, 0x0C, 0x02, 0xF9, 0x03, 0x77, 0x72,
  0x06, 0xF0, 0xC0, 0x5F, 0x0E, 0x77, 0x73, 0x02, 0xF0, 0xC0, 0x8F, 0x0C, 0x77, 0x74, 0xF0, 0xC0,
  0xAF, 0x09, 0x77, 0x74, 0x0D, 0xE0, 0x0C, 0xF0, 0x77, 0x77, 0x40, 0xBE, 0x0C, 0x0D, 0xF0, 0x67,
  0x77, 0x40, 0x9E, 0x0C, 0x0E, 0xF0, 0x57, 0x77, 0x40, 0x8E, 0x0C, 0xF9, 0x04, 0x77, 0x74, 0x08,
  0xE0, 0xCF, 0x90, 0x47, 0x77, 0x40, 0x7E, 0x0C, 0xF9, 0x03, 0x77, 0x74, 0x07, 0xE0, 0xCF, 0x90,
  0x47, 0x77, 0x40, 0x7E, 0x0C, 0xF9, 0x04, 0x77, 0x74, 0x07, 0xE0, 0xC0, 0xEF, 0x05, 0x77, 0x74,
  0x08, 0xE0, 0xC0, 0xDF, 0x07, 0x77, 0x74, 0x08, 0xE0, 0xC0, 0xBF, 0x09, 0x77, 0x74, 0x0A, 0xE0,
  0xC0, 0x9F, 0x0B, 0x77, 0x74, 0x0C, 0xE0, 0xC0, 0x6F, 0x0E, 0x77, 0x74, 0x0E, 0xE0, 0xC0, 0x3F,
  0x90, 0x37, 0x77, 0x20, 0x2F, 0x0C, 0x1F, 0x90, 0x77, 0x77, 0x20, 0x5F, 0x81, 0xC0, 0xBF, 0x0D,
  0x77, 0x72, 0x0A, 0xF8, 0x1C, 0x06, 0xF9, 0x04, 0x77, 0x70, 0x1F, 0x98, 0x1C, 0x01, 0xF9, 0x0B,
  0x77, 0x70, 0x8F, 0x90, 0xC2, 0x0A, 0xF9, 0x05, 0x77, 0x50, 0x2F, 0xA0, 0xC2, 0x03, 0xF9, 0x0E,
  0x02, 0x77, 0x30, 0x10, 0xCF, 0xA0, 0xC3, 0x0B, 0xF9, 0x0D, 0x02, 0x77, 0x10, 0x10, 0xDF, 0xB0,
  0xC3, 0x02, 0xFA, 0x0E, 0x06, 0x76, 0x05, 0x0D, 0xFC, 0x0C, 0x40, 0x7F, 0xB8, 0x1C, 0x61, 0x78,
  0x11, 0x5C, 0xFE, 0x0C, 0x50, 0xBF, 0xD8, 0x5D, 0xA9, 0x89, 0xAC, 0xFA, 0x0C, 0xE0, 0xC6, 0x0C,
  0xFF, 0xFD, 0x06, 0x08, 0xE0, 0xC7, 0x0B, 0xFF, 0xFB, 0x81, 0x80, 0xAE, 0x0C, 0x71, 0x08, 0xFF,
  0xF9, 0x08, 0x20, 0xBE, 0x0C, 0x72, 0x03, 0x0C, 0xFF, 0xC0, 0xE0, 0x53, 0x0B, 0xE0, 0xC7, 0x40,
  0x40, 0xAF, 0xF0, 0xD0, 0x75, 0x0B, 0xE0, 0xC7, 0x68, 0x41, 0x58, 0xBD, 0xEA, 0x84, 0xED, 0xCA,
  0x63, 0x70, 0xBE, 0x0C, 0x77, 0x77, 0x60, 0xCE, 0x0C, 0x77, 0x77, 0x60, 0xDE, 0x0B, 0x77, 0x77,
  0x60, 0xEE, 0x0B, 0x77, 0x77, 0x6F, 0x09, 0x77, 0x77, 0x50, 0x3F, 0x08, 0x77, 0x77, 0x50, 0x6F,
  0x06, 0x77, 0x77, 0x50, 0xBF, 0x03, 0x77, 0x77, 0x40, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x8F, 0x0A,
  0x77, 0x77, 0x40, 0x3F, 0x90, 0x63, 0x03, 0x01, 0x77, 0x76, 0x0D, 0xF0, 0xE4, 0x82, 0x8E, 0x82,
  0x77, 0x72, 0x01, 0x0C, 0xF9, 0x08, 0x40, 0x8B, 0x81, 0xB6, 0x17, 0x75, 0x05, 0x0E, 0xF9, 0x0E,
  0x01, 0x40, 0x8E, 0x83, 0xD9, 0x64, 0x17, 0x48, 0x13, 0x7D, 0xFB, 0x05, 0x50, 0x8F, 0xC8, 0x90,
  0xEC, 0xBA, 0x98, 0x89, 0xAC, 0xFE, 0x0A, 0x60, 0x8F, 0xFF, 0xFD, 0x0B, 0x70, 0x8F, 0xFF, 0xFC,
  0x0A, 0x71, 0x05, 0x0E, 0xFF, 0xFF, 0x90, 0xE0, 0x67, 0x40, 0x50, 0xAF, 0xFF, 0xC8, 0x1E, 0x81,
  0x77, 0x18, 0x14, 0x8C, 0xFF, 0xD8, 0x1B, 0x61, 0x77, 0x78, 0x63, 0x58, 0xAC, 0xDD, 0xEA, 0x85,
  0xEE, 0xDB, 0x96, 0x47, 0x70,
  // "h" (U+0068)
  0x0C, 0xF0, 0x47, 0x77, 0x74, 0x0C, 0xF0, 0x47, 0x77, 0x74, 0x0C, 0xF0, 0x47, 0x77, 0x74, 0x0C,
  0xF0, 0x47, 0x77, 0x74, 0x0C, 0xF0, 0x47, 0x77, 0x74, 0x0C, 0xF0, 0x47, 0x77, 0x74, 0x0C, 0xF0,
  0x47, 0x77, 0x74, 0x0C, 0xF0, 0x47, 0x77, 0x74, 0x0C, 0xF0, 0x47, 0x77, 0x74, 0x0C, 0xF0, 0x47,
  0x77, 0x74, 0x0C, 0xF0, 0x47, 0x77, 0x74, 0x0C, 0xF0, 0x47, 0x77, 0x74, 0x0C, 0xF0, 0x47, 0x77,
  0x74, 0x0C, 0xF0, 0x47, 0x77, 0x74, 0x0C, 0xF0, 0x47, 0x77, 0x74, 0x0C, 0xF0, 0x47, 0x77, 0x74,
  0x0C, 0xF0, 0x47, 0x77, 0x74, 0x0C, 0xF0, 0x47, 0x77, 0x74, 0x0C, 0xF0, 0x47, 0x77, 0x74, 0x0C,
  0xF0, 0x47, 0x18, 0x93, 0x15, 0x9B, 0xDE, 0xFE, 0xEC, 0xA6, 0x27, 0x40, 0xCF, 0x04, 0x60, 0x50,
  0xBF, 0xE0, 0xD0, 0x77, 0x20, 0xCF, 0x03, 0x40, 0x30, 0xCF, 0xFB, 0x0E, 0x06, 0x70, 0xCF, 0x03,
  0x30, 0x7F, 0xFF, 0x0B, 0x01, 0x50, 0xCF, 0x02, 0x20, 0x9F, 0xFF, 0xA0, 0xC0, 0x14, 0x0C, 0xF8,
  0x11, 0x07, 0xFF, 0xFC, 0x0C, 0x40, 0xCF, 0x10, 0x4F, 0x98, 0x5D, 0xA9, 0x89, 0xBE, 0xFD, 0x08,
  0x30, 0xCF, 0x10, 0xDD, 0x81, 0xE7, 0x27, 0x02, 0x09, 0xFC, 0x02, 0x20, 0xCF, 0x0A, 0xD0, 0x90,
  0x17, 0x40, 0x20, 0xCF, 0xA0, 0x92, 0x0C, 0xFD, 0x06, 0x77, 0x10, 0xBF, 0xA8, 0x11, 0x0C, 0xFC,
  0x06, 0x77, 0x20, 0x10, 0xEF, 0x98, 0x15, 0x0C, 0xFB, 0x0A, 0x77, 0x40, 0x5F, 0x98, 0x19, 0x0C,
  0xFA, 0x0E, 0x01, 0x77, 0x50, 0xEF, 0x81, 0xC0, 0xCF, 0xA0, 0x67, 0x76, 0x09, 0xF9, 0x10, 0xCF,
  0x90, 0xE7, 0x77, 0x05, 0xF9, 0x01, 0x0C, 0xF9, 0x09, 0x77, 0x70, 0x2F, 0x90, 0x20, 0xCF, 0x90,
  0x47, 0x77, 0x1F, 0x90, 0x30, 0xCF, 0x97, 0x77, 0x20, 0xEF, 0x03, 0x0C, 0xF0, 0xC7, 0x77, 0x20,
  0xDF, 0x03, 0x0C, 0xF0, 0x97, 0x77, 0x20, 0xDF, 0x03, 0x0C, 0xF0, 0x77, 0x77, 0x20, 0xDF, 0x03,
  0x0C, 0xF0, 0x67, 0x77, 0x20, 0xDF, 0x03, 0x0C, 0xF0, 0x57, 0x77, 0x20, 0xDF, 0x03, 0x0C, 0xF0,
  0x57, 0x77, 0x20, 0xDF, 0x03, 0x0C, 0xF0, 0x47, 0x77, 0x20, 0xDF, 0x03, 0x0C, 0xF0, 0x47, 0x77,
  0x20, 0xDF, 0x03, 0x0C, 0xF0, 0x47, 0x77, 0x20, 0xDF, 0x03, 0x0C, 0xF0, 0x47, 0x77, 0x20, 0xDF,
  0x03, 0x0C, 0xF0, 0x47, 0x77, 0x20, 0xDF, 0x03, 0x0C, 0xF0, 0x47, 0x77, 0x20, 0xDF, 0x03, 0x0C,
  0xF0, 0x47, 0x77, 0x20, 0xDF, 0x03, 0x0C, 0xF0, 0x47, 0x77, 0x20, 0xDF, 0x03, 0x0C, 0xF0, 0x47,
  0x77, 0x20, 0xDF, 0x03, 0x0C, 0xF0, 0x47, 0x77, 0x20, 0xDF, 0x03, 0x0C, 0xF0, 0x47, 0x77, 0x20,
  0xDF, 0x03, 0x0C, 0xF0, 0x47, 0x77, 0x20, 0xDF, 0x03, 0x0C, 0xF0, 0x47, 0x77, 0x20, 0xDF, 0x03,
  0x0C, 0xF0, 0x47, 0x77, 0x20, 0xDF, 0x03, 0x0C, 0xF0, 0x47, 0x77, 0x20, 0xDF, 0x03, 0x0C, 0xF0,
  0x47, 0x77, 0x20, 0xDF, 0x03, 0x0C, 0xF0, 0x47, 0x77, 0x20, 0xDF, 0x03, 0x0C, 0xF0, 0x47, 0x77,
  0x20, 0xDF, 0x03, 0x0C, 0xF0, 0x47, 0x77, 0x20, 0xDF, 0x03, 0x0C, 0xF0, 0x47, 0x77, 0x20, 0xDF,
  0x03, 0x0C, 0xF0, 0x47, 0x77, 0x20, 0xDF, 0x03, 0x0C, 0xF0, 0x47, 0x77, 0x20, 0xDF, 0x03, 0x0C,
  0xF0, 0x47, 0x77, 0x20, 0xDF, 0x03, 0x0C, 0xF0, 0x47, 0x77, 0x20, 0xDF, 0x03, 0x0C, 0xF0, 0x47,
  0x77, 0x20, 0xDF, 0x03,
  // "i" (U+0069)
  0x77, 0x38, 0x53, 0xAD, 0xFE, 0xB5, 0x77, 0x77, 0x60, 0x7F, 0x0B, 0x77, 0x77, 0x40, 0x4F, 0xA0,
  0x87, 0x77, 0x73, 0x0B, 0xFA, 0x0E, 0x77, 0x77, 0x30, 0xEF, 0xB0, 0x37, 0x77, 0x72, 0xFC, 0x04,
  0x77, 0x77, 0x2F, 0xC0, 0x37, 0x77, 0x72, 0x0B, 0xFA, 0x0E, 0x77, 0x77, 0x30, 0x4F, 0xA0, 0x87,
  0x77, 0x74, 0x07, 0xF0, 0xA7, 0x77, 0x76, 0x85, 0x3A, 0xDF, 0xEB, 0x58, 0x0E, 0x91, 0x00, 0x5F,
  0xFF, 0xA0, 0x77, 0x73, 0x05, 0xFF, 0xFA, 0x07, 0x77, 0x30, 0x5F, 0xFF, 0xA0, 0x77, 0x73, 0x05,
  0xFF, 0xFA, 0x07, 0x77, 0x30, 0x5F, 0xFF, 0xA0, 0x77, 0x73, 0x05, 0xFF, 0xFA, 0x07, 0x77, 0x48,
  0x91, 0x24, 0x56, 0x78, 0x9A, 0xBD, 0xEF, 0xD0, 0x77, 0x77, 0x73, 0x81, 0x23, 0xBF, 0x07, 0x77,
  0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77,
  0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50,
  0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F,
  0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07,
  0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77,
  0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77,
  0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50,
  0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F,
  0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07,
  0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77,
  0x77, 0x50, 0x9F, 0x07, 0x77, 0x75, 0x86, 0x12, 0x35, 0x67, 0x8D, 0xF8, 0x5C, 0x87, 0x54, 0x32,
  0x73, 0x87, 0x46, 0x78, 0xAB, 0xCD, 0xEF, 0xFF, 0xC8, 0x7D, 0xCB, 0xA8, 0x76, 0x3C, 0x80, 0xC4,
  0xF0, 0x90, 0xC8, 0x0C, 0x4F, 0x09, 0x0C, 0x80, 0xC4, 0xF0, 0x90, 0xC8, 0x0C, 0x4F, 0x09, 0x0C,
  0x80, 0xC4, 0xF0, 0x90,
  // "j" (U+006A)
  0x77, 0x71, 0x85, 0x29, 0xDF, 0xEB, 0x67, 0x77, 0x30, 0x5F, 0x0C, 0x01, 0x77, 0x70, 0x2F, 0xA0,
  0xB7, 0x77, 0x08, 0xFB, 0x02, 0x77, 0x60, 0xBF, 0xB0, 0x57, 0x76, 0x0C, 0xFB, 0x06, 0x77, 0x60,
  0xBF, 0xB0, 0x57, 0x76, 0x07, 0xFB, 0x02, 0x77, 0x60, 0x10, 0xEF, 0x90, 0xA7, 0x77, 0x10, 0x40,
  0xEE, 0x0C, 0x01, 0x77, 0x72, 0x85, 0x29, 0xDF, 0xEB, 0x68, 0x0C, 0xC5, 0x00, 0x1F, 0xFF, 0xA0,
  0xB7, 0x01, 0xFF, 0xFA, 0x0B, 0x70, 0x1F, 0xFF, 0xA0, 0xB7, 0x01, 0xFF, 0xFA, 0x0B, 0x70, 0x1F,
  0xFF, 0xA0, 0xB7, 0x83, 0x1A, 0xCD, 0xEF, 0xFD, 0x0B, 0x76, 0x89, 0x11, 0x23, 0x45, 0x68, 0x9A,
  0xBD, 0xF0, 0xB7, 0x77, 0x20, 0x5F, 0x0B, 0x77, 0x72, 0x05, 0xF0, 0xB7, 0x77, 0x20, 0x5F, 0x0B,
  0x77, 0x72, 0x05, 0xF0, 0xB7, 0x77, 0x20, 0x5F, 0x0B, 0x77, 0x72, 0x05, 0xF0, 0xB7, 0x77, 0x20,
  0x5F, 0x0B, 0x77, 0x72, 0x05, 0xF0, 0xB7, 0x77, 0x20, 0x5F, 0x0B, 0x77, 0x72, 0x05, 0xF0, 0xB7,
  0x77, 0x20, 0x5F, 0x0B, 0x77, 0x72, 0x05, 0xF0, 0xB7, 0x77, 0x20, 0x5F, 0x0B, 0x77, 0x72, 0x05,
  0xF0, 0xB7, 0x77, 0x20, 0x5F, 0x0B, 0x77, 0x72, 0x05, 0xF0, 0xB7, 0x77, 0x20, 0x5F, 0x0B, 0x77,
  0x72, 0x05, 0xF0, 0xB7, 0x77, 0x20, 0x5F, 0x0B, 0x77, 0x72, 0x05, 0xF0, 0xB7, 0x77, 0x20, 0x5F,
  0x0B, 0x77, 0x72, 0x05, 0xF0, 0xB7, 0x77, 0x20, 0x5F, 0x0B, 0x77, 0x72, 0x05, 0xF0, 0xB7, 0x77,
  0x20, 0x5F, 0x0B, 0x77, 0x72, 0x05, 0xF0, 0xB7, 0x77, 0x20, 0x5F, 0x0B, 0x77, 0x72, 0x05, 0xF0,
  0xB7, 0x77, 0x20, 0x5F, 0x0B, 0x77, 0x72, 0x05, 0xF0, 0xB7, 0x77, 0x20, 0x5F, 0x0B, 0x77, 0x72,
  0x05, 0xF0, 0xB7, 0x77, 0x20, 0x5F, 0x0B, 0x77, 0x72, 0x05, 0xF0, 0xB7, 0x77, 0x20, 0x5F, 0x0B,
  0x77, 0x72, 0x05, 0xF0, 0xB7, 0x77, 0x20, 0x5F, 0x0B, 0x77, 0x72, 0x05, 0xF0, 0xB7, 0x77, 0x20,
  0x5F, 0x0B, 0x77, 0x72, 0x05, 0xF0, 0xB7, 0x77, 0x20, 0x5F, 0x0B, 0x77, 0x72, 0x05, 0xF0, 0xB7,
  0x77, 0x20, 0x5F, 0x0B, 0x77, 0x72, 0x05, 0xF0, 0xB7, 0x77, 0x20, 0x5F, 0x0B, 0x77, 0x72, 0x06,
  0xF0, 0xB7, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x72, 0x09, 0xF0, 0xA7, 0x77, 0x20, 0xCF, 0x08, 0x77,
  0x72, 0x0E, 0xF0, 0x67, 0x77, 0x10, 0x4F, 0x90, 0x37, 0x77, 0x10, 0xBF, 0x97, 0x77, 0x10, 0x4F,
  0x90, 0xB7, 0x77, 0x02, 0x0E, 0xF9, 0x05, 0x20, 0x30, 0x17, 0x72, 0x03, 0x0E, 0xF9, 0x0D, 0x38,
  0x49, 0xFC, 0x85, 0x17, 0x30, 0x40, 0xBF, 0xB0, 0x53, 0x09, 0xD8, 0x7E, 0xCA, 0x99, 0x89, 0xAC,
  0xFD, 0x0A, 0x40, 0x9F, 0xFF, 0xC0, 0xC5, 0x09, 0xFF, 0xFB, 0x0C, 0x01, 0x50, 0x9F, 0xFF, 0xA0,
  0xA7, 0x09, 0xFF, 0xF0, 0xD0, 0x47, 0x10, 0x50, 0xCF, 0xFC, 0x0B, 0x05, 0x76, 0x86, 0x25, 0x79,
  0xBC, 0xDE, 0xB8, 0x3E, 0xCA, 0x84, 0x76,
  // "k" (U+006B)
  0x08, 0xF0, 0x87, 0x77, 0x75, 0x08, 0xF0, 0x87, 0x77, 0x75, 0x08, 0xF0, 0x87, 0x77, 0x75, 0x08,
  0xF0, 0x87, 0x77, 0x75, 0x08, 0xF0, 0x87, 0x77, 0x75, 0x08, 0xF0, 0x87, 0x77, 0x75, 0x08, 0xF0,
  0x87, 0x77, 0x75, 0x08, 0xF0, 0x87, 0x77, 0x75, 0x08, 0xF0, 0x87, 0x77, 0x75, 0x08, 0xF0, 0x87,
  0x77, 0x75, 0x08, 0xF0, 0x87, 0x77, 0x75, 0x08, 0xF0, 0x87, 0x77, 0x75, 0x08, 0xF0, 0x87, 0x77,
  0x75, 0x08, 0xF0, 0x87, 0x77, 0x75, 0x08, 0xF0, 0x87, 0x77, 0x75, 0x08, 0xF0, 0x87, 0x77, 0x75,
  0x08, 0xF0, 0x87, 0x77, 0x75, 0x08, 0xF0, 0x87, 0x77, 0x75, 0x08, 0xF0, 0x87, 0x77, 0x75, 0x08,
  0xF0, 0x87, 0x77, 0x75, 0x08, 0xF0, 0x87, 0x77, 0x02, 0x0E, 0xF9, 0x81, 0x90, 0x8F, 0x08, 0x77,
  0x60, 0x20, 0xEF, 0x90, 0xA2, 0x08, 0xF0, 0x87, 0x75, 0x01, 0x0D, 0xF9, 0x0B, 0x30, 0x8F, 0x08,
  0x77, 0x50, 0xCF, 0x90, 0xC4, 0x08, 0xF0, 0x87, 0x74, 0x0B, 0xF9, 0x0D, 0x01, 0x40, 0x8F, 0x08,
  0x77, 0x30, 0x9F, 0x90, 0xD0, 0x25, 0x08, 0xF0, 0x87, 0x72, 0x08, 0xF9, 0x0E, 0x02, 0x60, 0x8F,
  0x08, 0x77, 0x10, 0x6F, 0xA0, 0x37, 0x08, 0xF0, 0x87, 0x70, 0x5F, 0xA0, 0x47, 0x10, 0x8F, 0x08,
  0x76, 0x03, 0xFA, 0x06, 0x72, 0x08, 0xF0, 0x87, 0x50, 0x20, 0xEF, 0x90, 0x77, 0x30, 0x8F, 0x08,
  0x74, 0x01, 0x0D, 0xF9, 0x08, 0x74, 0x08, 0xF0, 0x87, 0x30, 0x10, 0xCF, 0x90, 0xA7, 0x50, 0x8F,
  0x08, 0x73, 0x0B, 0xF9, 0x0B, 0x76, 0x08, 0xF0, 0x87, 0x20, 0xAF, 0x90, 0xC7, 0x70, 0x8F, 0x07,
  0x71, 0x09, 0xF9, 0x0D, 0x01, 0x77, 0x08, 0xF0, 0x77, 0x07, 0xF9, 0x0D, 0x01, 0x77, 0x10, 0x8F,
  0x06, 0x60, 0x6F, 0x90, 0xE0, 0x27, 0x72, 0x08, 0xF0, 0x55, 0x04, 0xF9, 0x0E, 0x03, 0x77, 0x30,
  0x8F, 0x04, 0x40, 0x20, 0xEF, 0x90, 0x47, 0x74, 0x08, 0xF0, 0x33, 0x01, 0x0D, 0xF9, 0x05, 0x77,
  0x50, 0x8F, 0x03, 0x30, 0xCF, 0xA0, 0x37, 0x75, 0x08, 0xF0, 0x22, 0x0A, 0xFB, 0x0D, 0x01, 0x77,
  0x40, 0x8F, 0x81, 0x10, 0x8F, 0xD0, 0xB7, 0x74, 0x08, 0xF1, 0x05, 0xFF, 0x07, 0x77, 0x30, 0x8F,
  0x02, 0x0E, 0xE0, 0xEF, 0x90, 0x47, 0x72, 0x08, 0xF0, 0xDE, 0x81, 0x91, 0xDF, 0x0E, 0x01, 0x77,
  0x10, 0x8F, 0xE0, 0x92, 0x03, 0xF9, 0x0B, 0x77, 0x10, 0x8F, 0xD0, 0x84, 0x07, 0xF9, 0x08, 0x77,
  0x08, 0xFC, 0x07, 0x60, 0xBF, 0x90, 0x47, 0x60, 0x8F, 0xB0, 0x67, 0x01, 0x0E, 0xF0, 0xE0, 0x17,
  0x50, 0x8F, 0xA0, 0x67, 0x20, 0x4F, 0x90, 0xC7, 0x50, 0x8F, 0x90, 0x57, 0x40, 0x8F, 0x90, 0x87,
  0x40, 0x8F, 0x08, 0x76, 0x0B, 0xF9, 0x04, 0x73, 0x08, 0xF0, 0x87, 0x60, 0x10, 0xEF, 0x0E, 0x02,
  0x72, 0x08, 0xF0, 0x87, 0x70, 0x4F, 0x90, 0xC7, 0x20, 0x8F, 0x08, 0x77, 0x10, 0x8F, 0x90, 0x97,
  0x10, 0x8F, 0x08, 0x77, 0x20, 0xCF, 0x90, 0x57, 0x08, 0xF0, 0x87, 0x72, 0x02, 0x0E, 0xF0, 0xE0,
  0x26, 0x08, 0xF0, 0x87, 0x73, 0x05, 0xF9, 0x0C, 0x60, 0x8F, 0x08, 0x77, 0x40, 0x9F, 0x90, 0x95,
  0x08, 0xF0, 0x87, 0x75, 0x0C, 0xF9, 0x05, 0x40, 0x8F, 0x08, 0x77, 0x50, 0x20, 0xEF, 0x0E, 0x02,
  0x30, 0x8F, 0x08, 0x77, 0x60, 0x6F, 0x90, 0xD3, 0x08, 0xF0, 0x87, 0x77, 0x0A, 0xF9, 0x09, 0x20,
  0x8F, 0x08, 0x77, 0x71, 0x0D, 0xF9, 0x81, 0x60, 0x8F, 0x08, 0x77, 0x71, 0x03, 0xFA, 0x03, 0x08,
  0xF0, 0x87, 0x77, 0x20, 0x6F, 0x90, 0xD0,
  // "l" (U+006C)
  0x04, 0xFF, 0xFB, 0x0E, 0x77, 0x20, 0x4F, 0xFF, 0xB0, 0xE7, 0x72, 0x04, 0xFF, 0xFB, 0x0E, 0x77,
  0x20, 0x4F, 0xFF, 0xB0, 0xE7, 0x72, 0x04, 0xFF, 0xFB, 0x0E, 0x77, 0x20, 0x4F, 0xFF, 0xB0, 0xE7,
  0x72, 0x02, 0x80, 0x94, 0x80, 0x9F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F,
  0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E,
  0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77,
  0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77,
  0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50,
  0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F,
  0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E,
  0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77,
  0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77,
  0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50,
  0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F,
  0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E,
  0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77,
  0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77,
  0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50,
  0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F,
  0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E,
  0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x75, 0x86, 0x12, 0x34, 0x57, 0x8A, 0xF9, 0x85, 0x87, 0x65,
  0x32, 0x17, 0x28, 0x74, 0x67, 0x89, 0xBC, 0xDE, 0xFF, 0xFC, 0x87, 0xEC, 0xBA, 0x97, 0x63, 0xC8,
  0x0C, 0x4F, 0x09, 0x0C, 0x80, 0xC4, 0xF0, 0x90, 0xC8, 0x0C, 0x4F, 0x09, 0x0C, 0x80, 0xC4, 0xF0,
  0x90, 0xC8, 0x0C, 0x4F, 0x09,
  // "m" (U+006D)
  0x75, 0x87, 0x28, 0xCE, 0xFE, 0xDA, 0x57, 0x38, 0x75, 0x9C, 0xEF, 0xED, 0x94, 0x60, 0x7D, 0x03,
  0x30, 0x10, 0xAF, 0xA0, 0xD0, 0x36, 0x04, 0x0D, 0xFA, 0x0C, 0x02, 0x40, 0x7D, 0x06, 0x20, 0x10,
  0xDF, 0xC0, 0xE0, 0x34, 0x06, 0xFD, 0x0E, 0x03, 0x30, 0x7D, 0x0A, 0x20, 0xCF, 0xE0, 0xD0, 0x12,
  0x05, 0xFF, 0x0D, 0x30, 0x7D, 0x81, 0xE0, 0x7F, 0xF9, 0x82, 0x80, 0x2E, 0xFF, 0x90, 0x72, 0x07,
  0xE0, 0x5F, 0xFB, 0x01, 0x0B, 0xFF, 0xA0, 0xE2, 0x07, 0xFC, 0x82, 0xD9, 0x9B, 0xFA, 0x0B, 0xD8,
  0x3E, 0xA8, 0xAE, 0xF9, 0x81, 0x40, 0x7F, 0xB0, 0x64, 0x02, 0x0D, 0xFD, 0x0B, 0x01, 0x40, 0xAF,
  0x81, 0x80, 0x7F, 0xA0, 0x66, 0x02, 0xFC, 0x0C, 0x70, 0xDE, 0x81, 0xC0, 0x7F, 0x90, 0xC7, 0x10,
  0xAF, 0xB0, 0x27, 0x07, 0xF1, 0x07, 0xF9, 0x06, 0x71, 0x05, 0xFA, 0x0A, 0x71, 0x03, 0xF0, 0x20,
  0x7F, 0x90, 0x17, 0x10, 0x1F, 0xA0, 0x47, 0x2F, 0x04, 0x07, 0xF0, 0xD7, 0x30, 0xEF, 0x0E, 0x73,
  0x0E, 0xE0, 0x50, 0x7F, 0x09, 0x73, 0x0C, 0xF0, 0xA7, 0x30, 0xCE, 0x00, 0x7F, 0x06, 0x73, 0x0A,
  0xF0, 0x77, 0x30, 0xBE, 0x00, 0x7F, 0x04, 0x73, 0x09, 0xF0, 0x47, 0x30, 0xAE, 0x08, 0x07, 0xF0,
  0x27, 0x30, 0x8F, 0x02, 0x73, 0x0A, 0xE0, 0x80, 0x7F, 0x74, 0x08, 0xF7, 0x40, 0x9E, 0x09, 0x07,
  0xE0, 0xE7, 0x40, 0x8E, 0x0E, 0x74, 0x09, 0xE0, 0x90, 0x7E, 0x0D, 0x74, 0x08, 0xE0, 0xD7, 0x40,
  0x9E, 0x09, 0x07, 0xE0, 0xC7, 0x40, 0x8E, 0x0C, 0x74, 0x09, 0xE0, 0x90, 0x7E, 0x0B, 0x74, 0x08,
  0xE0, 0xB7, 0x40, 0x9E, 0x09, 0x07, 0xE0, 0xB7, 0x40, 0x8E, 0x0B, 0x74, 0x09, 0xE0, 0x90, 0x7E,
  0x0B, 0x74, 0x08, 0xE0, 0xA7, 0x40, 0x9E, 0x09, 0x07, 0xE0, 0xB7, 0x40, 0x8E, 0x0A, 0x74, 0x09,
  0xE0, 0x90, 0x7E, 0x0A, 0x74, 0x08, 0xE0, 0xA7, 0x40, 0x9E, 0x09, 0x07, 0xE0, 0xA7, 0x40, 0x8E,
  0x0A, 0x74, 0x09, 0xE0, 0x90, 0x7E, 0x0A, 0x74, 0x08, 0xE0, 0xA7, 0x40, 0x9E, 0x09, 0x07, 0xE0,
  0xA7, 0x40, 0x8E, 0x0A, 0x74, 0x09, 0xE0, 0x90, 0x7E, 0x0A, 0x74, 0x08, 0xE0, 0xA7, 0x40, 0x9E,
  0x09, 0x07, 0xE0, 0xA7, 0x40, 0x8E, 0x0A, 0x74, 0x09, 0xE0, 0x90, 0x7E, 0x0A, 0x74, 0x08, 0xE0,
  0xA7, 0x40, 0x9E, 0x09, 0x07, 0xE0, 0xA7, 0x40, 0x8E, 0x0A, 0x74, 0x09, 0xE0, 0x90, 0x7E, 0x0A,
  0x74, 0x08, 0xE0, 0xA7, 0x40, 0x9E, 0x09, 0x07, 0xE0, 0xA7, 0x40, 0x8E, 0x0A, 0x74, 0x09, 0xE0,
  0x90, 0x7E, 0x0A, 0x74, 0x08, 0xE0, 0xA7, 0x40, 0x9E, 0x09, 0x07, 0xE0, 0xA7, 0x40, 0x8E, 0x0A,
  0x74, 0x09, 0xE0, 0x90, 0x7E, 0x0A, 0x74, 0x08, 0xE0, 0xA7, 0x40, 0x9E, 0x09, 0x07, 0xE0, 0xA7,
  0x40, 0x8E, 0x0A, 0x74, 0x09, 0xE0, 0x90, 0x7E, 0x0A, 0x74, 0x08, 0xE0, 0xA7, 0x40, 0x9E, 0x09,
  0x07, 0xE0, 0xA7, 0x40, 0x8E, 0x0A, 0x74, 0x09, 0xE0, 0x90, 0x7E, 0x0A, 0x74, 0x08, 0xE0, 0xA7,
  0x40, 0x9E, 0x09, 0x07, 0xE0, 0xA7, 0x40, 0x8E, 0x0A, 0x74, 0x09, 0xE0, 0x90, 0x7E, 0x0A, 0x74,
  0x08, 0xE0, 0xA7, 0x40, 0x9E, 0x09, 0x07, 0xE0, 0xA7, 0x40, 0x8E, 0x0A, 0x74, 0x09, 0xE0, 0x90,
  0x7E, 0x0A, 0x74, 0x08, 0xE0, 0xA7, 0x40, 0x9E, 0x09, 0x07, 0xE0, 0xA7, 0x40, 0x8E, 0x0A, 0x74,
  0x09, 0xE0, 0x90, 0x7E, 0x0A, 0x74, 0x08, 0xE0, 0xA7, 0x40, 0x9E, 0x09, 0x07, 0xE0, 0xA7, 0x40,
  0x8E, 0x0A, 0x74, 0x09, 0xE0, 0x90,
  // "n" (U+006E)
  0x77, 0x38, 0x42, 0x69, 0xBD, 0xEA, 0x83, 0xED, 0xB8, 0x47, 0x40, 0xCD, 0x0B, 0x78, 0x11, 0x7D,
  0xFE, 0x81, 0xE9, 0x27, 0x10, 0xCD, 0x0E, 0x60, 0x70, 0xEF, 0xFC, 0x09, 0x70, 0xCE, 0x01, 0x30,
  0x20, 0xDF, 0xFF, 0x0D, 0x02, 0x50, 0xCE, 0x04, 0x20, 0x30, 0xEF, 0xFF, 0xA0, 0xE0, 0x34, 0x0C,
  0xE8, 0x26, 0x02, 0xEF, 0xFF, 0xC0, 0xE0, 0x13, 0x0C, 0xE8, 0x19, 0x0C, 0xF9, 0x85, 0xCA, 0x98,
  0x9A, 0xCF, 0xD0, 0xB3, 0x0C, 0xE0, 0xB0, 0x6E, 0x0A, 0x04, 0x72, 0x04, 0x0C, 0xFB, 0x05, 0x20,
  0xCF, 0xD0, 0xD0, 0x37, 0x60, 0x5F, 0xA0, 0xC2, 0x0C, 0xFC, 0x0B, 0x77, 0x20, 0x4F, 0xA8, 0x12,
  0x0C, 0xFB, 0x0C, 0x77, 0x40, 0x8F, 0x98, 0x17, 0x0C, 0xFB, 0x02, 0x77, 0x40, 0x1F, 0x98, 0x1B,
  0x0C, 0xFA, 0x0A, 0x77, 0x60, 0xAF, 0x81, 0xE0, 0xCF, 0xA0, 0x27, 0x76, 0x05, 0xF9, 0x10, 0xCF,
  0x90, 0xB7, 0x77, 0x02, 0xF9, 0x02, 0x0C, 0xF9, 0x07, 0x77, 0x71, 0xF9, 0x03, 0x0C, 0xF9, 0x02,
  0x77, 0x71, 0x0E, 0xF0, 0x30, 0xCF, 0x0E, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x0C, 0x77, 0x72,
  0x0D, 0xF0, 0x30, 0xCF, 0x09, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x07, 0x77, 0x72, 0x0D, 0xF0,
  0x30, 0xCF, 0x06, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x05, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF,
  0x05, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77,
  0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D,
  0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30,
  0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04,
  0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72,
  0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0,
  0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF,
  0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77,
  0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D,
  0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30,
  0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04,
  0x77, 0x72, 0x0D, 0xF0, 0x30,
  // "o" (U+006F)
  0x77, 0x18, 0x94, 0x36, 0x9C, 0xDE, 0xFE, 0xED, 0xB8, 0x51, 0x77, 0x76, 0x81, 0x28, 0xDF, 0xF8,
  0x1C, 0x71, 0x77, 0x71, 0x03, 0x0A, 0xFF, 0xD8, 0x1E, 0x81, 0x77, 0x50, 0x8F, 0xFF, 0xA0, 0xE0,
  0x57, 0x72, 0x02, 0x0D, 0xFF, 0xFD, 0x0B, 0x77, 0x03, 0x0E, 0xFF, 0xFF, 0x0C, 0x01, 0x74, 0x02,
  0x0E, 0xFC, 0x86, 0xDB, 0x98, 0x89, 0xBE, 0xFC, 0x0D, 0x01, 0x72, 0x01, 0x0D, 0xFA, 0x81, 0xD7,
  0x27, 0x18, 0x13, 0x8E, 0xFA, 0x0B, 0x72, 0x0B, 0xFA, 0x07, 0x76, 0x01, 0x09, 0xFA, 0x08, 0x70,
  0x5F, 0x90, 0xE0, 0x37, 0x72, 0x06, 0xFA, 0x03, 0x60, 0xDF, 0x90, 0x37, 0x74, 0x05, 0xF9, 0x0C,
  0x50, 0x6F, 0x90, 0x67, 0x76, 0x09, 0xF9, 0x05, 0x40, 0xDF, 0x0C, 0x77, 0x70, 0x10, 0xEF, 0x0B,
  0x30, 0x4F, 0x90, 0x47, 0x77, 0x10, 0x7F, 0x90, 0x32, 0x09, 0xF0, 0xC7, 0x77, 0x30, 0xEF, 0x08,
  0x20, 0xDF, 0x06, 0x77, 0x73, 0x09, 0xF8, 0x1C, 0x02, 0xF9, 0x01, 0x77, 0x73, 0x04, 0xF9, 0x01,
  0x05, 0xF0, 0xC7, 0x77, 0x50, 0xEF, 0x05, 0x08, 0xF0, 0x97, 0x77, 0x50, 0xCF, 0x07, 0x0A, 0xF0,
  0x67, 0x77, 0x50, 0x9F, 0x09, 0x0C, 0xF0, 0x37, 0x77, 0x50, 0x6F, 0x0C, 0x0E, 0xF0, 0x27, 0x77,
  0x50, 0x5F, 0x0D, 0x0E, 0xF0, 0x17, 0x77, 0x50, 0x4F, 0x0E, 0xF9, 0x77, 0x76, 0x03, 0xFF, 0xA7,
  0x77, 0x60, 0x2F, 0xFA, 0x77, 0x76, 0x02, 0xFF, 0xA7, 0x77, 0x60, 0x3F, 0x90, 0xEF, 0x01, 0x77,
  0x75, 0x04, 0xF0, 0xE0, 0xDF, 0x02, 0x77, 0x75, 0x05, 0xF0, 0xD0, 0xCF, 0x04, 0x77, 0x75, 0x07,
  0xF0, 0xC0, 0x9F, 0x07, 0x77, 0x75, 0x09, 0xF0, 0xA0, 0x7F, 0x09, 0x77, 0x75, 0x0C, 0xF0, 0x70,
  0x4F, 0x0C, 0x77, 0x75, 0xF9, 0x05, 0x01, 0xF9, 0x02, 0x77, 0x73, 0x04, 0xF9, 0x81, 0x10, 0xCF,
  0x07, 0x77, 0x73, 0x0A, 0xF0, 0xD2, 0x07, 0xF0, 0xD7, 0x77, 0x30, 0xEF, 0x08, 0x20, 0x2F, 0x90,
  0x57, 0x77, 0x10, 0x7F, 0x90, 0x33, 0x0B, 0xF0, 0xD7, 0x77, 0x01, 0x0E, 0xF0, 0xC4, 0x04, 0xF9,
  0x08, 0x77, 0x60, 0x9F, 0x90, 0x55, 0x0B, 0xF9, 0x04, 0x77, 0x40, 0x5F, 0x90, 0xD6, 0x02, 0xFA,
  0x05, 0x77, 0x20, 0x5F, 0xA0, 0x37, 0x08, 0xFA, 0x09, 0x01, 0x75, 0x01, 0x09, 0xFA, 0x09, 0x72,
  0x0B, 0xFA, 0x81, 0xE8, 0x27, 0x18, 0x12, 0x8E, 0xFA, 0x0C, 0x73, 0x01, 0x0D, 0xFC, 0x86, 0xEB,
  0x98, 0x89, 0xBE, 0xFC, 0x0E, 0x01, 0x74, 0x01, 0x0C, 0xFF, 0xFF, 0x0D, 0x02, 0x77, 0x0B, 0xFF,
  0xFD, 0x0C, 0x01, 0x77, 0x20, 0x60, 0xEF, 0xFF, 0xA0, 0x77, 0x75, 0x01, 0x09, 0xFF, 0xE0, 0xA0,
  0x27, 0x77, 0x18, 0x11, 0x7C, 0xFF, 0x81, 0xD8, 0x27, 0x77, 0x68, 0x41, 0x58, 0xBD, 0xEA, 0x84,
  0xED, 0xB9, 0x62, 0x77, 0x10,
  // "p" (U+0070)
  0x77, 0x28, 0x93, 0x26, 0x9C, 0xDE, 0xFE, 0xEC, 0xA6, 0x27, 0x60, 0xCD, 0x0E, 0x70, 0x50, 0xCF,
  0xE0, 0xC0, 0x67, 0x40, 0xCE, 0x01, 0x40, 0x30, 0xCF, 0xFB, 0x0D, 0x05, 0x72, 0x0C, 0xE0, 0x33,
  0x05, 0xFF, 0xF0, 0xA0, 0x17, 0x0C, 0xE0, 0x52, 0x07, 0xFF, 0xFA, 0x0D, 0x02, 0x60, 0xCE, 0x81,
  0x80, 0x5F, 0xFF, 0xC0, 0xD0, 0x15, 0x0C, 0xE8, 0x1A, 0x2E, 0xF8, 0x6D, 0xB9, 0x89, 0x9B, 0xEF,
  0xC0, 0xC5, 0x0C, 0xE0, 0xD0, 0xCD, 0x81, 0xE7, 0x27, 0x18, 0x13, 0x8E, 0xFA, 0x09, 0x40, 0xCF,
  0xD0, 0x87, 0x60, 0x10, 0xAF, 0xA0, 0x43, 0x0C, 0xFC, 0x05, 0x77, 0x20, 0x8F, 0x90, 0xD3, 0x0C,
  0xFB, 0x07, 0x77, 0x40, 0x9F, 0x90, 0x52, 0x0C, 0xFA, 0x0C, 0x77, 0x60, 0xEF, 0x0C, 0x20, 0xCF,
  0xA0, 0x47, 0x76, 0x06, 0xF9, 0x81, 0x20, 0xCF, 0x90, 0xC7, 0x77, 0x10, 0xEF, 0x81, 0x80, 0xCF,
  0x90, 0x77, 0x77, 0x10, 0x9F, 0x81, 0xC0, 0xCF, 0x90, 0x27, 0x77, 0x10, 0x4F, 0x91, 0x0C, 0xF0,
  0xD7, 0x77, 0x3F, 0x90, 0x40, 0xCF, 0x0A, 0x77, 0x73, 0x0D, 0xF0, 0x70, 0xCF, 0x08, 0x77, 0x73,
  0x0A, 0xF0, 0x90, 0xCF, 0x06, 0x77, 0x73, 0x08, 0xF0, 0xB0, 0xCF, 0x05, 0x77, 0x73, 0x06, 0xF0,
  0x0C, 0xF0, 0x47, 0x77, 0x30, 0x5F, 0x0E, 0x0C, 0xF0, 0x37, 0x77, 0x30, 0x4F, 0x90, 0xCF, 0x03,
  0x77, 0x73, 0x04, 0xF9, 0x0C, 0xF0, 0x37, 0x77, 0x30, 0x3F, 0x90, 0xCF, 0x03, 0x77, 0x73, 0x03,
  0xF9, 0x0C, 0xF0, 0x47, 0x77, 0x30, 0x4F, 0x90, 0xCF, 0x04, 0x77, 0x73, 0x04, 0xF9, 0x0C, 0xF0,
  0x57, 0x77, 0x30, 0x5F, 0x0E, 0x0C, 0xF0, 0x77, 0x77, 0x30, 0x7F, 0x00, 0xCF, 0x09, 0x77, 0x73,
  0x09, 0xF0, 0xB0, 0xCF, 0x0B, 0x77, 0x73, 0x0B, 0xF0, 0x90, 0xCF, 0x0D, 0x77, 0x73, 0x0E, 0xF0,
  0x60, 0xCF, 0x90, 0x27, 0x77, 0x10, 0x2F, 0x90, 0x30, 0xCF, 0x90, 0x67, 0x77, 0x10, 0x6F, 0x91,
  0x0C, 0xF9, 0x0A, 0x77, 0x71, 0x0B, 0xF8, 0x1C, 0x0C, 0xFA, 0x01, 0x77, 0x60, 0x1F, 0x98, 0x17,
  0x0C, 0xFA, 0x08, 0x77, 0x60, 0x8F, 0x98, 0x12, 0x0C, 0xFA, 0x0E, 0x01, 0x77, 0x40, 0x2F, 0x90,
  0xB2, 0x0C, 0xFB, 0x09, 0x77, 0x40, 0xCF, 0x90, 0x42, 0x0C, 0xFC, 0x07, 0x77, 0x20, 0xAF, 0x90,
  0xC3, 0x0C, 0xFD, 0x09, 0x01, 0x75, 0x02, 0x0C, 0xFA, 0x03, 0x30, 0xCF, 0xE8, 0x1E, 0x72, 0x71,
  0x03, 0x09, 0xFB, 0x08, 0x40, 0xCE, 0x0B, 0x05, 0xF9, 0x86, 0xDB, 0x98, 0x89, 0xBE, 0xFC, 0x0C,
  0x50, 0xCE, 0x81, 0xD0, 0x6F, 0xFF, 0xC0, 0xD0, 0x15, 0x0C, 0xE0, 0xE2, 0x06, 0xFF, 0xFA, 0x0C,
  0x01, 0x60, 0xCF, 0x30, 0x40, 0xEF, 0xFE, 0x0A, 0x71, 0x0C, 0xF0, 0x13, 0x01, 0x0A, 0xFF, 0xB0,
  0xD0, 0x57, 0x20, 0xCF, 0x02, 0x50, 0x30, 0xBF, 0xE0, 0xC0, 0x67, 0x40, 0xCF, 0x02, 0x78, 0x93,
  0x15, 0x9B, 0xDE, 0xFE, 0xEC, 0xA6, 0x27, 0x60, 0xCF, 0x03, 0x77, 0x77, 0x50, 0xCF, 0x03, 0x77,
  0x77, 0x50, 0xCF, 0x03, 0x77, 0x77, 0x50, 0xCF, 0x03, 0x77, 0x77, 0x50, 0xCF, 0x03, 0x77, 0x77,
  0x50, 0xCF, 0x03, 0x77, 0x77, 0x50, 0xCF, 0x03, 0x77, 0x77, 0x50, 0xCF, 0x03, 0x77, 0x77, 0x50,
  0xCF, 0x03, 0x77, 0x77, 0x50, 0xCF, 0x03, 0x77, 0x77, 0x50, 0xCF, 0x03, 0x77, 0x77, 0x50, 0xCF,
  0x03, 0x77, 0x77, 0x50, 0xCF, 0x03, 0x77, 0x77, 0x50, 0xCF, 0x03, 0x77, 0x77, 0x50, 0xCF, 0x03,
  0x77, 0x77, 0x50, 0xCF, 0x03, 0x77, 0x77, 0x50, 0xCF, 0x03, 0x77, 0x77, 0x50, 0xCF, 0x03, 0x77,
  0x77, 0x50, 0xCF, 0x03, 0x77, 0x77, 0x50, 0xCF, 0x03, 0x77, 0x77, 0x50, 0xCF, 0x03, 0x77, 0x77,
  0x50,
  // "q" (U+0071)
  0x77, 0x89, 0x24, 0x8B, 0xDE, 0xFE, 0xEC, 0xA7, 0x27, 0x77, 0x68, 0x13, 0x9E, 0xFD, 0x0C, 0x04,
  0x70, 0xCD, 0x0C, 0x72, 0x02, 0x0A, 0xFF, 0xB0, 0xB0, 0x15, 0x0E, 0xD0, 0xC7, 0x10, 0x50, 0xEF,
  0xFD, 0x0E, 0x04, 0x30, 0x2E, 0x0C, 0x70, 0x9F, 0xFF, 0xA0, 0x52, 0x04, 0xE0, 0xC6, 0x09, 0xFF,
  0xFC, 0x81, 0x40, 0x7E, 0x0C, 0x50, 0x8F, 0xC8, 0x6E, 0xB9, 0x88, 0x9B, 0xEF, 0x81, 0xE2, 0xAE,
  0x0C, 0x40, 0x4F, 0xB0, 0x90, 0x37, 0x18, 0x12, 0x8E, 0xD0, 0xC0, 0xEE, 0x0C, 0x30, 0x10, 0xEF,
  0x90, 0xC0, 0x27, 0x50, 0x10, 0xAF, 0xD0, 0xC3, 0x08, 0xF9, 0x0B, 0x77, 0x20, 0x8F, 0xC0, 0xC2,
  0x01, 0xF9, 0x0D, 0x77, 0x40, 0xAF, 0xB0, 0xC2, 0x08, 0xF9, 0x03, 0x77, 0x40, 0x10, 0xEF, 0xA0,
  0xC2, 0x0E, 0xF0, 0x97, 0x76, 0x08, 0xFA, 0x81, 0xC0, 0x5F, 0x90, 0x27, 0x76, 0x01, 0xFA, 0x81,
  0xC0, 0xAF, 0x0B, 0x77, 0x71, 0x0B, 0xF9, 0x81, 0xC0, 0xEF, 0x06, 0x77, 0x71, 0x06, 0xF9, 0x0C,
  0x02, 0xF9, 0x02, 0x77, 0x71, 0x02, 0xF9, 0x0C, 0x06, 0xF0, 0xE7, 0x77, 0x30, 0xDF, 0x0C, 0x08,
  0xF0, 0xB7, 0x77, 0x30, 0xBF, 0x0C, 0x0A, 0xF0, 0x97, 0x77, 0x30, 0x9F, 0x00, 0xCF, 0x07, 0x77,
  0x73, 0x07, 0xF0, 0xC0, 0xEF, 0x05, 0x77, 0x73, 0x05, 0xF0, 0xC0, 0xEF, 0x04, 0x77, 0x73, 0x04,
  0xF0, 0xCF, 0x90, 0x47, 0x77, 0x30, 0x4F, 0x0C, 0xF9, 0x03, 0x77, 0x73, 0x03, 0xF0, 0xCF, 0x90,
  0x37, 0x77, 0x30, 0x3F, 0x0C, 0xF9, 0x04, 0x77, 0x73, 0x03, 0xF0, 0xCF, 0x90, 0x57, 0x77, 0x30,
  0x3F, 0x0C, 0x0E, 0xF0, 0x67, 0x77, 0x30, 0x3F, 0x00, 0xCF, 0x07, 0x77, 0x73, 0x04, 0xF0, 0xC0,
  0xBF, 0x0A, 0x77, 0x73, 0x05, 0xF0, 0xC0, 0x9F, 0x0C, 0x77, 0x73, 0x07, 0xF0, 0xC0, 0x6F, 0x97,
  0x77, 0x30, 0xAF, 0x0C, 0x03, 0xF9, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0xC1, 0xF9, 0x09, 0x77, 0x71,
  0x01, 0xF9, 0x81, 0xC0, 0xBF, 0x0D, 0x77, 0x71, 0x06, 0xF9, 0x81, 0xC0, 0x7F, 0x90, 0x57, 0x77,
  0x0C, 0xF9, 0x81, 0xC0, 0x1F, 0x90, 0xC7, 0x76, 0x04, 0xFA, 0x0C, 0x20, 0xBF, 0x90, 0x57, 0x75,
  0x0C, 0xFA, 0x0C, 0x20, 0x3F, 0x90, 0xE0, 0x27, 0x73, 0x08, 0xFB, 0x0C, 0x30, 0xBF, 0x90, 0xD0,
  0x17, 0x71, 0x07, 0xFC, 0x0C, 0x30, 0x2F, 0xA0, 0xE0, 0x47, 0x50, 0x10, 0xAF, 0xD0, 0xC4, 0x07,
  0xFB, 0x0B, 0x04, 0x71, 0x81, 0x28, 0xED, 0x0D, 0xF0, 0xC5, 0x0A, 0xFC, 0x86, 0xEC, 0x98, 0x89,
  0xBE, 0xF9, 0x03, 0xF0, 0xC6, 0x0B, 0xFF, 0xFC, 0x05, 0x1F, 0x0C, 0x70, 0xAF, 0xFF, 0xA8, 0x16,
  0x01, 0xF0, 0xC7, 0x10, 0x7F, 0xFE, 0x0E, 0x04, 0x20, 0x1F, 0x0C, 0x72, 0x03, 0x0C, 0xFF, 0xB0,
  0xC0, 0x23, 0x02, 0xF0, 0xC7, 0x40, 0x40, 0xAF, 0xE0, 0xC0, 0x55, 0x02, 0xF0, 0xC7, 0x68, 0x93,
  0x15, 0x9B, 0xDE, 0xFE, 0xEC, 0xA7, 0x27, 0x02, 0xF0, 0xC7, 0x77, 0x75, 0x03, 0xF0, 0xC7, 0x77,
  0x75, 0x03, 0xF0, 0xC7, 0x77, 0x75, 0x03, 0xF0, 0xC7, 0x77, 0x75, 0x03, 0xF0, 0xC7, 0x77, 0x75,
  0x03, 0xF0, 0xC7, 0x77, 0x75, 0x03, 0xF0, 0xC7, 0x77, 0x75, 0x03, 0xF0, 0xC7, 0x77, 0x75, 0x03,
  0xF0, 0xC7, 0x77, 0x75, 0x03, 0xF0, 0xC7, 0x77, 0x75, 0x03, 0xF0, 0xC7, 0x77, 0x75, 0x03, 0xF0,
  0xC7, 0x77, 0x75, 0x03, 0xF0, 0xC7, 0x77, 0x75, 0x03, 0xF0, 0xC7, 0x77, 0x75, 0x03, 0xF0, 0xC7,
  0x77, 0x75, 0x03, 0xF0, 0xC7, 0x77, 0x75, 0x03, 0xF0, 0xC7, 0x77, 0x75, 0x03, 0xF0, 0xC7, 0x77,
  0x75, 0x03, 0xF0, 0xC7, 0x77, 0x75, 0x03, 0xF0, 0xC7, 0x77, 0x75, 0x03, 0xF0, 0xC7, 0x77, 0x75,
  0x03, 0xF0, 0xC0,
  // "r" (U+0072)
  0x77, 0x77, 0x38, 0x93, 0x16, 0xAD, 0xEF, 0xEE, 0xDB, 0x85, 0x15, 0xFF, 0xD0, 0xC7, 0x01, 0x0A,
  0xFE, 0x0B, 0x05, 0x3F, 0xFD, 0x0E, 0x60, 0x50, 0xEF, 0xFA, 0x05, 0x2F, 0xFE, 0x50, 0x6F, 0xFC,
  0x3F, 0xFE, 0x02, 0x30, 0x5F, 0xFC, 0x0B, 0x3F, 0xFE, 0x04, 0x20, 0x3F, 0xFD, 0x06, 0x48, 0x52,
  0x46, 0x8A, 0xCE, 0xFD, 0x06, 0x20, 0xDF, 0x98, 0x4C, 0xA8, 0x9B, 0xED, 0x01, 0x75, 0x83, 0x24,
  0x68, 0xEE, 0x81, 0x80, 0x8E, 0x0D, 0x06, 0x78, 0x33, 0x8E, 0xFC, 0x77, 0x30, 0xBE, 0x0A, 0x02,
  0xE0, 0x87, 0x50, 0x80, 0x77, 0x73, 0x0B, 0xE0, 0xD0, 0xBD, 0x05, 0x77, 0x77, 0x40, 0xBF, 0xD0,
  0x47, 0x77, 0x75, 0x0B, 0xFC, 0x07, 0x77, 0x77, 0x60, 0xBF, 0xB0, 0xC7, 0x77, 0x77, 0x0B, 0xFB,
  0x02, 0x77, 0x77, 0x70, 0xBF, 0xA0, 0xA8, 0x0C, 0x00, 0x0B, 0xFA, 0x02, 0x80, 0xC0, 0x00, 0xBF,
  0x90, 0xC8, 0x0C, 0x10, 0x0B, 0xF9, 0x07, 0x80, 0xC1, 0x00, 0xBF, 0x90, 0x38, 0x0C, 0x10, 0x0B,
  0xF0, 0xE8, 0x0C, 0x20, 0x0B, 0xF0, 0xC8, 0x0C, 0x20, 0x0B, 0xF0, 0x98, 0x0C, 0x20, 0x0B, 0xF0,
  0x88, 0x0C, 0x20, 0x0B, 0xF0, 0x78, 0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x68,
  0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C,
  0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20,
  0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B,
  0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0,
  0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x67,
  0x77, 0x73, 0x86, 0x13, 0x46, 0x78, 0xAE, 0xF8, 0x6C, 0x98, 0x65, 0x32, 0x17, 0x72, 0x85, 0x27,
  0x9A, 0xBD, 0xEF, 0xFF, 0xC8, 0x4D, 0xCA, 0x97, 0x37, 0x20, 0x68, 0x0C, 0x0F, 0x07, 0x72, 0x06,
  0x80, 0xC0, 0xF0, 0x77, 0x20, 0x68, 0x0C, 0x0F, 0x07, 0x72, 0x06, 0x80, 0xC0, 0xF0, 0x77, 0x20,
  0x68, 0x0C, 0x0F, 0x07, 0x72,
  // "s" (U+0073)
  0x75, 0x85, 0x46, 0x9B, 0xDD, 0xEA, 0x85, 0xED, 0xCA, 0x86, 0x37, 0x73, 0x05, 0x0A, 0xFF, 0xC8,
  0x1B, 0x73, 0x74, 0x07, 0x0E, 0xFF, 0xFA, 0x81, 0xD7, 0x26, 0x04, 0x0D, 0xFF, 0xFE, 0x09, 0x50,
  0x6F, 0xFF, 0xF9, 0x04, 0x40, 0x5F, 0xFF, 0xF9, 0x0D, 0x40, 0x10, 0xEF, 0xC8, 0x90, 0xDB, 0x99,
  0x89, 0x9A, 0xCE, 0xF9, 0x08, 0x40, 0x9F, 0xA0, 0x90, 0x47, 0x48, 0x22, 0x59, 0xEC, 0x02, 0x40,
  0xEF, 0x0C, 0x02, 0x77, 0x38, 0x24, 0xAF, 0xC4, 0x04, 0xF0, 0xE0, 0x17, 0x76, 0x02, 0x03, 0x40,
  0x8F, 0x07, 0x77, 0x76, 0x0A, 0xF0, 0x37, 0x77, 0x60, 0xBF, 0x01, 0x77, 0x76, 0x0A, 0xF0, 0x27,
  0x77, 0x60, 0x9F, 0x07, 0x77, 0x76, 0x07, 0xF0, 0xD0, 0x17, 0x77, 0x50, 0x3F, 0x90, 0xC0, 0x17,
  0x77, 0x50, 0xDF, 0x90, 0xD0, 0x47, 0x77, 0x40, 0x6F, 0xB0, 0xB0, 0x37, 0x77, 0x30, 0xBF, 0xC0,
  0xB0, 0x47, 0x77, 0x20, 0xCF, 0xD0, 0xD0, 0x67, 0x77, 0x10, 0xBF, 0xE8, 0x1E, 0x81, 0x77, 0x60,
  0x7F, 0xF9, 0x0A, 0x03, 0x77, 0x50, 0x20, 0xAF, 0xF9, 0x0C, 0x05, 0x77, 0x50, 0x30, 0xBF, 0xF9,
  0x0D, 0x06, 0x77, 0x50, 0x30, 0xAF, 0xF9, 0x0D, 0x05, 0x77, 0x50, 0x20, 0x9F, 0xF9, 0x0B, 0x01,
  0x77, 0x58, 0x11, 0x8E, 0xFE, 0x0E, 0x03, 0x77, 0x70, 0x60, 0xDF, 0xD0, 0xE0, 0x27, 0x77, 0x10,
  0x40, 0xBF, 0xC0, 0xD7, 0x77, 0x30, 0x40, 0xBF, 0xB0, 0x77, 0x77, 0x40, 0x50, 0xEF, 0x90, 0xD7,
  0x77, 0x50, 0x10, 0xDF, 0x90, 0x27, 0x77, 0x50, 0x3F, 0x90, 0x57, 0x77, 0x60, 0xCF, 0x07, 0x77,
  0x76, 0x09, 0xF0, 0x87, 0x77, 0x60, 0x9F, 0x08, 0x77, 0x76, 0x0A, 0xF0, 0x77, 0x77, 0x60, 0xDF,
  0x05, 0x02, 0x77, 0x74, 0x04, 0xF9, 0x83, 0x28, 0xE8, 0x27, 0x77, 0x01, 0x0D, 0xF8, 0x1D, 0x08,
  0xB8, 0x1B, 0x61, 0x77, 0x30, 0x20, 0xCF, 0x98, 0x17, 0x08, 0xE8, 0x1B, 0x73, 0x75, 0x04, 0x09,
  0xFA, 0x82, 0xE1, 0x08, 0xFB, 0x89, 0x0D, 0xBA, 0x98, 0x89, 0x9A, 0xDF, 0xD0, 0x62, 0x08, 0xFF,
  0xFF, 0xB0, 0xA3, 0x08, 0xFF, 0xFF, 0xA0, 0xA4, 0x08, 0xFF, 0xFF, 0x90, 0x75, 0x81, 0x17, 0xDF,
  0xFF, 0xC0, 0xA0, 0x27, 0x28, 0x22, 0x7B, 0xEF, 0xFC, 0x81, 0xC7, 0x27, 0x71, 0x86, 0x35, 0x79,
  0xBD, 0xDE, 0xB8, 0x5E, 0xDC, 0xA7, 0x51, 0x74,
  // "t" (U+0074)
  0x77, 0x04, 0xE0, 0x47, 0x77, 0x76, 0x06, 0xE0, 0x47, 0x77, 0x76, 0x08, 0xE0, 0x47, 0x77, 0x76,
  0x0A, 0xE0, 0x47, 0x77, 0x76, 0x0C, 0xE0, 0x47, 0x77, 0x76, 0x0E, 0xE0, 0x47, 0x77, 0x76, 0xF0,
  0x47, 0x77, 0x75, 0x02, 0xF0, 0x47, 0x77, 0x75, 0x04, 0xF0, 0x47, 0x77, 0x75, 0x06, 0xF0, 0x47,
  0x77, 0x75, 0x08, 0xF0, 0x47, 0x77, 0x75, 0x0A, 0xF0, 0x47, 0x77, 0x73, 0x81, 0x13, 0xCF, 0x04,
  0x77, 0x71, 0x86, 0x13, 0x56, 0x8A, 0xCD, 0xFF, 0xFF, 0xA8, 0x11, 0x0D, 0x80, 0xC3, 0xF8, 0x11,
  0x0E, 0x80, 0xC3, 0xF8, 0x11, 0x0E, 0x80, 0xC3, 0xF8, 0x11, 0x0E, 0x80, 0xC3, 0xF8, 0x11, 0x0E,
  0x80, 0xC3, 0xF0, 0x11, 0x80, 0x91, 0x80, 0xEF, 0x0A, 0x80, 0x96, 0x87, 0x71, 0x0C, 0xF0, 0x47,
  0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77,
  0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75,
  0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C,
  0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0,
  0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47,
  0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77,
  0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75,
  0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C,
  0xF0, 0x57, 0x77, 0x75, 0x0B, 0xF0, 0x77, 0x77, 0x75, 0x0A, 0xF0, 0x97, 0x77, 0x75, 0x09, 0xF0,
  0xD7, 0x77, 0x75, 0x06, 0xF9, 0x03, 0x77, 0x77, 0x40, 0x4F, 0x90, 0xA7, 0x77, 0x75, 0x0E, 0xF9,
  0x05, 0x77, 0x77, 0x40, 0xAF, 0xA0, 0x67, 0x77, 0x73, 0x03, 0xFB, 0x0C, 0x05, 0x73, 0x83, 0x14,
  0x7A, 0x57, 0x71, 0x0A, 0xFD, 0x87, 0xCA, 0x98, 0x99, 0xAC, 0xEC, 0x06, 0x77, 0x10, 0x10, 0xDF,
  0xFF, 0xB0, 0x67, 0x72, 0x02, 0x0D, 0xFF, 0xFA, 0x06, 0x77, 0x30, 0x10, 0xCF, 0xFF, 0x90, 0x67,
  0x75, 0x07, 0x0E, 0xFF, 0xE0, 0x67, 0x76, 0x81, 0x17, 0xCF, 0xFB, 0x0C, 0x04, 0x77, 0x72, 0x85,
  0x15, 0x7A, 0xCD, 0xEA, 0x85, 0xEE, 0xCA, 0x86, 0x33,
  // "u" (U+0075)
  0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0,
  0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77,
  0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F,
  0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03,
  0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7,
  0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20,
  0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C,
  0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0,
  0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77,
  0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F,
  0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03,
  0xF0, 0xD7, 0x77, 0x20, 0x5F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x5F, 0x0C, 0x03, 0xF0, 0xD7,
  0x77, 0x20, 0x6F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x7F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20,
  0x9F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0xBF, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0xEF, 0x0C,
  0x03, 0xF0, 0xE7, 0x77, 0x10, 0x1F, 0x90, 0xC0, 0x3F, 0x97, 0x77, 0x10, 0x6F, 0x90, 0xC0, 0x2F,
  0x90, 0x27, 0x77, 0x0B, 0xF9, 0x0C, 0x1F, 0x90, 0x57, 0x76, 0x01, 0xFA, 0x81, 0xC0, 0xEF, 0x0A,
  0x77, 0x60, 0x8F, 0xA8, 0x1C, 0x0B, 0xF9, 0x01, 0x77, 0x40, 0x10, 0xEF, 0xA8, 0x1C, 0x07, 0xF9,
  0x09, 0x77, 0x40, 0xAF, 0xB8, 0x1C, 0x02, 0xFA, 0x04, 0x77, 0x20, 0x9F, 0xC0, 0xC2, 0x0C, 0xFA,
  0x05, 0x76, 0x01, 0x0B, 0xFD, 0x0C, 0x20, 0x5F, 0xB0, 0xC0, 0x47, 0x20, 0x30, 0x9E, 0x0D, 0x0E,
  0xE0, 0xC3, 0x0C, 0xFD, 0x86, 0xCA, 0x98, 0x9A, 0xCE, 0xF8, 0x1E, 0x2A, 0xE0, 0xC3, 0x03, 0xFF,
  0xFE, 0x81, 0x50, 0x7E, 0x0C, 0x40, 0x5F, 0xFF, 0xC0, 0x62, 0x05, 0xE0, 0xC5, 0x05, 0xFF, 0xF9,
  0x0E, 0x05, 0x30, 0x2E, 0x0C, 0x60, 0x20, 0xCF, 0xFD, 0x0B, 0x02, 0x50, 0xED, 0x0C, 0x71, 0x04,
  0x0B, 0xFF, 0x81, 0xEA, 0x47, 0x0C, 0xD0, 0xC7, 0x38, 0x41, 0x58, 0xBD, 0xEA, 0x84, 0xEE, 0xCA,
  0x84, 0x77, 0x30,
  // "v" (U+0076)
  0x0B, 0xF0, 0x77, 0x77, 0x70, 0xBF, 0x0A, 0x06, 0xF0, 0xD7, 0x77, 0x60, 0x1F, 0x90, 0x41, 0xF9,
  0x03, 0x77, 0x75, 0x07, 0xF0, 0xE2, 0x0A, 0xF0, 0x87, 0x77, 0x50, 0xCF, 0x08, 0x20, 0x4F, 0x0E,
  0x77, 0x74, 0x02, 0xF9, 0x02, 0x30, 0xDF, 0x04, 0x77, 0x73, 0x07, 0xF0, 0xC4, 0x08, 0xF0, 0x97,
  0x77, 0x30, 0xCF, 0x06, 0x40, 0x2F, 0x0E, 0x77, 0x72, 0x02, 0xF9, 0x01, 0x50, 0xCF, 0x05, 0x77,
  0x71, 0x08, 0xF0, 0xA6, 0x06, 0xF0, 0xA7, 0x77, 0x10, 0xDF, 0x04, 0x60, 0x1F, 0x90, 0x17, 0x76,
  0x03, 0xF0, 0xE7, 0x10, 0xAF, 0x06, 0x77, 0x60, 0x8F, 0x08, 0x71, 0x04, 0xF0, 0xB7, 0x76, 0x0D,
  0xF0, 0x27, 0x20, 0xEF, 0x01, 0x77, 0x40, 0x3F, 0x0C, 0x73, 0x08, 0xF0, 0x67, 0x74, 0x09, 0xF0,
  0x67, 0x30, 0x3F, 0x0C, 0x77, 0x40, 0xEF, 0x01, 0x74, 0x0C, 0xF0, 0x27, 0x72, 0x04, 0xF0, 0xA7,
  0x50, 0x7F, 0x07, 0x77, 0x20, 0x9F, 0x04, 0x75, 0x01, 0xF0, 0xD7, 0x72, 0x0E, 0xE0, 0xE7, 0x70,
  0xBF, 0x03, 0x77, 0x04, 0xF0, 0x87, 0x70, 0x5F, 0x08, 0x77, 0x0A, 0xF0, 0x27, 0x71, 0x0E, 0xE0,
  0xE7, 0x70, 0xEE, 0x0C, 0x77, 0x20, 0x9F, 0x04, 0x75, 0x05, 0xF0, 0x67, 0x72, 0x03, 0xF0, 0x97,
  0x50, 0xAF, 0x01, 0x77, 0x30, 0xDE, 0x0E, 0x75, 0xF0, 0xA7, 0x74, 0x07, 0xF0, 0x57, 0x30, 0x5F,
  0x04, 0x77, 0x40, 0x1F, 0x0A, 0x73, 0x0B, 0xE0, 0xE7, 0x76, 0x0B, 0xF0, 0x17, 0x10, 0x1F, 0x08,
  0x77, 0x60, 0x5F, 0x06, 0x71, 0x06, 0xF0, 0x27, 0x77, 0x0E, 0xE0, 0xB7, 0x10, 0xBE, 0x0C, 0x77,
  0x71, 0x09, 0xF0, 0x16, 0x01, 0xF0, 0x67, 0x77, 0x10, 0x3F, 0x06, 0x60, 0x6F, 0x01, 0x77, 0x72,
  0x0D, 0xE0, 0xC6, 0x0C, 0xE0, 0xA7, 0x77, 0x30, 0x7F, 0x02, 0x40, 0x2F, 0x04, 0x77, 0x73, 0x02,
  0xF0, 0x74, 0x08, 0xE0, 0xE7, 0x77, 0x50, 0xBE, 0x0D, 0x40, 0xDE, 0x08, 0x77, 0x75, 0x06, 0xF0,
  0x32, 0x04, 0xF0, 0x27, 0x77, 0x6F, 0x08, 0x20, 0x9E, 0x0C, 0x77, 0x77, 0x0A, 0xE0, 0xD2, 0x0E,
  0xE0, 0x67, 0x77, 0x70, 0x4F, 0x03, 0x04, 0xF0, 0x17, 0x77, 0x71, 0x0D, 0xE0, 0x80, 0xAE, 0x0A,
  0x77, 0x77, 0x20, 0x8E, 0x00, 0xEE, 0x04, 0x77, 0x77, 0x20, 0x2F, 0xE0, 0xE7, 0x77, 0x74, 0x0C,
  0xFD, 0x08, 0x77, 0x77, 0x40, 0x6F, 0xD0, 0x27, 0x77, 0x74, 0x01, 0xFC, 0x0C, 0x77, 0x77, 0x60,
  0xAF, 0xB0, 0x67, 0x77, 0x76, 0x04, 0xFB, 0x01, 0x77, 0x30,
  // "w" (U+0077)
  0x07, 0xF0, 0x17, 0x77, 0x77, 0x0C, 0xE0, 0x80, 0x5F, 0x03, 0x77, 0x77, 0x70, 0xEE, 0x06, 0x02,
  0xF0, 0x57, 0x77, 0x76, 0x02, 0xF0, 0x31, 0xF0, 0x87, 0x77, 0x76, 0x04, 0xF8, 0x11, 0x0D, 0xE0,
  0xA7, 0x77, 0x76, 0x07, 0xE0, 0xE2, 0x0A, 0xE0, 0xC7, 0x77, 0x76, 0x09, 0xE0, 0xB2, 0x08, 0xE0,
  0xE7, 0x77, 0x76, 0x0B, 0xE0, 0x92, 0x05, 0xF0, 0x17, 0x77, 0x75, 0x0E, 0xE0, 0x62, 0x03, 0xF0,
  0x37, 0x77, 0x74, 0x01, 0xF0, 0x33, 0xF0, 0x67, 0x40, 0x9F, 0x90, 0x87, 0x40, 0x3F, 0x01, 0x30,
  0xDE, 0x08, 0x74, 0x0E, 0xF9, 0x0C, 0x74, 0x06, 0xE0, 0xE4, 0x0B, 0xE0, 0xA7, 0x30, 0x3F, 0xB0,
  0x17, 0x30, 0x8E, 0x0B, 0x40, 0x8E, 0x0D, 0x73, 0x07, 0xFB, 0x05, 0x73, 0x0B, 0xE0, 0x94, 0x05,
  0xF7, 0x30, 0xCF, 0xB0, 0x97, 0x30, 0xDE, 0x06, 0x40, 0x3F, 0x02, 0x71, 0x01, 0xFC, 0x0E, 0x73,
  0xF0, 0x44, 0x01, 0xF0, 0x47, 0x10, 0x5F, 0xD0, 0x37, 0x10, 0x3F, 0x01, 0x50, 0xDE, 0x06, 0x71,
  0x0A, 0xFD, 0x07, 0x71, 0x05, 0xE0, 0xE6, 0x0B, 0xE0, 0x97, 0x10, 0xED, 0x0A, 0x0C, 0xD0, 0xB7,
  0x10, 0x8E, 0x0B, 0x60, 0x9E, 0x0B, 0x70, 0x3E, 0x07, 0x08, 0xE7, 0x10, 0xAE, 0x09, 0x60, 0x6E,
  0x0D, 0x70, 0x8E, 0x03, 0x05, 0xE0, 0x47, 0x0D, 0xE0, 0x66, 0x03, 0xF7, 0x0C, 0xE1, 0x01, 0xE0,
  0x87, 0xF0, 0x46, 0x01, 0xF0, 0x25, 0x01, 0xE0, 0xB2, 0x0D, 0xD0, 0xD6, 0x02, 0xF0, 0x17, 0x0E,
  0xE0, 0x55, 0x05, 0xE0, 0x72, 0x09, 0xE0, 0x25, 0x04, 0xE0, 0xE7, 0x10, 0xBE, 0x07, 0x50, 0xAE,
  0x03, 0x20, 0x5E, 0x06, 0x50, 0x7E, 0x0C, 0x71, 0x09, 0xE0, 0x95, 0x0E, 0xD0, 0xE3, 0x01, 0xE0,
  0xA5, 0x09, 0xE0, 0x97, 0x10, 0x6E, 0x0B, 0x40, 0x3E, 0x0A, 0x40, 0xDD, 0x0E, 0x50, 0xBE, 0x06,
  0x71, 0x04, 0xE0, 0xE4, 0x08, 0xE0, 0x64, 0x09, 0xE0, 0x34, 0x0E, 0xE0, 0x47, 0x10, 0x1F, 0x40,
  0xCE, 0x01, 0x40, 0x5E, 0x08, 0x4F, 0x01, 0x72, 0x0E, 0xE0, 0x23, 0xE0, 0xD5, 0x01, 0xE0, 0xC3,
  0x02, 0xE0, 0xE7, 0x30, 0xCE, 0x03, 0x20, 0x4E, 0x08, 0x60, 0xCE, 0x30, 0x4E, 0x0C, 0x73, 0x09,
  0xE0, 0x52, 0x08, 0xE0, 0x46, 0x08, 0xE0, 0x42, 0x05, 0xE0, 0x97, 0x30, 0x7E, 0x06, 0x20, 0xBE,
  0x70, 0x4E, 0x08, 0x20, 0x7E, 0x07, 0x73, 0x04, 0xE0, 0x72, 0x0E, 0xD0, 0xB7, 0x1E, 0x0B, 0x20,
  0x8E, 0x04, 0x73, 0x02, 0xE8, 0x19, 0x02, 0xE0, 0x77, 0x10, 0xBD, 0x0E, 0x20, 0x9E, 0x01, 0x74,
  0xE8, 0x1A, 0x05, 0xE0, 0x37, 0x10, 0x7E, 0x81, 0x30, 0xBD, 0x0E, 0x75, 0x0C, 0xD8, 0x1B, 0x08,
  0xD0, 0xE7, 0x20, 0x3E, 0x81, 0x60, 0xCD, 0x0C, 0x75, 0x0A, 0xD8, 0x1C, 0x0B, 0xD0, 0xA7, 0x30,
  0xED, 0x81, 0x90, 0xDD, 0x09, 0x75, 0x07, 0xD8, 0x1E, 0x0E, 0xD0, 0x67, 0x30, 0xBD, 0x81, 0xD0,
  0xED, 0x07, 0x75, 0x05, 0xE0, 0x1E, 0x02, 0x73, 0x07, 0xE0, 0x1E, 0x04, 0x75, 0x02, 0xE0, 0x4D,
  0x0D, 0x74, 0x03, 0xE0, 0x5E, 0x02, 0x76, 0xE0, 0x8D, 0x09, 0x75, 0x0E, 0xD0, 0x8D, 0x0E, 0x77,
  0x0D, 0xD0, 0xDD, 0x05, 0x75, 0x0A, 0xD0, 0xDD, 0x0C, 0x77, 0x0A, 0xFC, 0x01, 0x75, 0x06, 0xFC,
  0x09, 0x77, 0x08, 0xFB, 0x0C, 0x76, 0x02, 0xFC, 0x07, 0x77, 0x05, 0xFB, 0x08, 0x77, 0x0D, 0xFB,
  0x04, 0x77, 0x03, 0xFB, 0x04, 0x77, 0x09, 0xFB, 0x02, 0x77, 0x1F, 0xB7, 0x71, 0x05, 0xFB, 0x77,
  0x20, 0xDF, 0x90, 0xB7, 0x71, 0x01, 0xFA, 0x0C, 0x71,
  // "x" (U+0078)
  0x10, 0xAF, 0x90, 0x67, 0x77, 0x30, 0x6F, 0x90, 0xA2, 0x01, 0x0D, 0xF0, 0xE0, 0x27, 0x77, 0x10,
  0x20, 0xEF, 0x0D, 0x01, 0x30, 0x3F, 0x90, 0xC7, 0x77, 0x10, 0xCF, 0x90, 0x35, 0x07, 0xF9, 0x07,
  0x77, 0x60, 0x7F, 0x90, 0x77, 0x0B, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0xB7, 0x10, 0x10, 0xEF,
  0x0D, 0x77, 0x40, 0xDF, 0x0E, 0x01, 0x72, 0x04, 0xF9, 0x09, 0x77, 0x20, 0x9F, 0x90, 0x47, 0x40,
  0x9F, 0x90, 0x57, 0x70, 0x5F, 0x90, 0x87, 0x60, 0xCF, 0x0E, 0x01, 0x75, 0x01, 0x0E, 0xF0, 0xC7,
  0x70, 0x20, 0xEF, 0x0B, 0x75, 0x0B, 0xF0, 0xE0, 0x27, 0x71, 0x06, 0xF9, 0x06, 0x73, 0x06, 0xF9,
  0x05, 0x77, 0x30, 0xAF, 0x90, 0x27, 0x10, 0x2F, 0x90, 0x97, 0x75, 0x0D, 0xF0, 0xC7, 0x10, 0xCF,
  0x0D, 0x77, 0x60, 0x3F, 0x90, 0x86, 0x08, 0xF9, 0x02, 0x77, 0x70, 0x7F, 0x90, 0x44, 0x04, 0xF9,
  0x06, 0x77, 0x72, 0x0B, 0xF0, 0xD0, 0x12, 0x01, 0x0D, 0xF0, 0xA7, 0x77, 0x30, 0x10, 0xEF, 0x0A,
  0x20, 0xAF, 0x0D, 0x01, 0x77, 0x74, 0x04, 0xF9, 0x00, 0x5F, 0x90, 0x37, 0x77, 0x60, 0x8F, 0x00,
  0xEF, 0x07, 0x77, 0x77, 0x10, 0xCF, 0xF0, 0xB7, 0x77, 0x72, 0x02, 0x0E, 0xFD, 0x0E, 0x01, 0x77,
  0x77, 0x30, 0x5F, 0xD0, 0x47, 0x77, 0x75, 0x09, 0xFB, 0x08, 0x77, 0x77, 0x70, 0xDF, 0x90, 0xC7,
  0x77, 0x77, 0x03, 0xFA, 0x0E, 0x02, 0x77, 0x77, 0x50, 0x10, 0xDF, 0xB0, 0xC7, 0x77, 0x75, 0x0B,
  0xFD, 0x09, 0x77, 0x77, 0x30, 0x7F, 0xF0, 0x67, 0x77, 0x71, 0x03, 0xFF, 0x90, 0xE0, 0x27, 0x77,
  0x60, 0x10, 0xDF, 0x00, 0xBF, 0x0D, 0x77, 0x76, 0x0B, 0xF8, 0x2E, 0x11, 0xEF, 0x0A, 0x77, 0x74,
  0x07, 0xF9, 0x04, 0x20, 0x4F, 0x90, 0x67, 0x77, 0x20, 0x4F, 0x90, 0x84, 0x08, 0xF9, 0x03, 0x77,
  0x70, 0x10, 0xEF, 0x0C, 0x60, 0xCF, 0x0D, 0x77, 0x70, 0xBF, 0x0E, 0x02, 0x60, 0x20, 0xEF, 0x0A,
  0x77, 0x50, 0x8F, 0x90, 0x57, 0x10, 0x5F, 0x90, 0x67, 0x73, 0x04, 0xF9, 0x09, 0x73, 0x09, 0xF9,
  0x03, 0x77, 0x10, 0x10, 0xEF, 0x0C, 0x75, 0x0D, 0xF0, 0xD0, 0x17, 0x70, 0xBF, 0x0E, 0x02, 0x75,
  0x03, 0xF9, 0x0A, 0x76, 0x08, 0xF9, 0x06, 0x77, 0x07, 0xF9, 0x06, 0x74, 0x04, 0xF9, 0x0A, 0x77,
  0x20, 0xBF, 0x90, 0x37, 0x20, 0x10, 0xEF, 0x0D, 0x77, 0x30, 0x10, 0xEF, 0x0D, 0x01, 0x71, 0x0C,
  0xF9, 0x03, 0x77, 0x40, 0x4F, 0x90, 0xA7, 0x08, 0xF9, 0x07, 0x77, 0x60, 0x8F, 0x90, 0x75, 0x04,
  0xF9, 0x0B, 0x77, 0x71, 0x0C, 0xF9, 0x03, 0x30, 0x20, 0xEF, 0x0D, 0x01, 0x77, 0x71, 0x01, 0x0E,
  0xF0, 0xD0, 0x12, 0x0C, 0xF9, 0x03, 0x77, 0x73, 0x05, 0xF9, 0x81, 0xB0, 0x8F, 0x90, 0x77, 0x77,
  0x50, 0x9F, 0x90, 0x70,
  // "y" (U+0079)
  0x0B, 0xF0, 0x27, 0x77, 0x70, 0x9F, 0x0A, 0x05, 0xF0, 0x97, 0x77, 0x70, 0xEF, 0x81, 0x40, 0xDE,
  0x0E, 0x77, 0x76, 0x04, 0xF0, 0xE2, 0x07, 0xF0, 0x67, 0x77, 0x50, 0x9F, 0x08, 0x20, 0x1F, 0x0C,
  0x77, 0x75, 0x0E, 0xF0, 0x23, 0x0A, 0xF0, 0x37, 0x77, 0x30, 0x4F, 0x0C, 0x40, 0x3F, 0x09, 0x77,
  0x73, 0x09, 0xF0, 0x65, 0x0C, 0xE0, 0xE7, 0x77, 0x30, 0xEF, 0x01, 0x50, 0x6F, 0x06, 0x77, 0x71,
  0x04, 0xF0, 0xA7, 0x0E, 0xE0, 0xC7, 0x77, 0x10, 0x9F, 0x04, 0x70, 0x8F, 0x03, 0x77, 0x70, 0xEE,
  0x0E, 0x71, 0x02, 0xF0, 0x97, 0x76, 0x04, 0xF0, 0x87, 0x20, 0xBF, 0x01, 0x77, 0x50, 0x9F, 0x03,
  0x72, 0x05, 0xF0, 0x77, 0x75, 0x0E, 0xE0, 0xC7, 0x40, 0xDE, 0x0D, 0x77, 0x40, 0x4F, 0x07, 0x74,
  0x07, 0xF0, 0x47, 0x73, 0x09, 0xF0, 0x17, 0x40, 0x1F, 0x0A, 0x77, 0x30, 0xEE, 0x0A, 0x76, 0x0A,
  0xF0, 0x17, 0x71, 0x04, 0xF0, 0x57, 0x60, 0x3F, 0x07, 0x77, 0x10, 0x9E, 0x0E, 0x77, 0x10, 0xCE,
  0x0D, 0x77, 0x10, 0xEE, 0x09, 0x77, 0x10, 0x6F, 0x04, 0x76, 0x04, 0xF0, 0x37, 0x72, 0x0E, 0xE0,
  0xB7, 0x60, 0x9E, 0x0D, 0x77, 0x30, 0x8F, 0x01, 0x75, 0x0E, 0xE0, 0x77, 0x73, 0x02, 0xF0, 0x87,
  0x40, 0x4F, 0x01, 0x77, 0x40, 0xBE, 0x0E, 0x74, 0x09, 0xE0, 0xB7, 0x75, 0x04, 0xF0, 0x57, 0x30,
  0xEE, 0x05, 0x77, 0x60, 0xDE, 0x0B, 0x72, 0x04, 0xE0, 0xE7, 0x77, 0x07, 0xF0, 0x27, 0x10, 0x9E,
  0x09, 0x77, 0x70, 0x1F, 0x08, 0x71, 0x0E, 0xE0, 0x37, 0x77, 0x10, 0xAE, 0x0E, 0x70, 0x4E, 0x0D,
  0x77, 0x72, 0x03, 0xF0, 0x56, 0x09, 0xE0, 0x77, 0x77, 0x30, 0xCE, 0x0B, 0x60, 0xEE, 0x01, 0x77,
  0x73, 0x06, 0xF0, 0x14, 0x03, 0xE0, 0xB7, 0x77, 0x50, 0xEE, 0x06, 0x40, 0x8E, 0x05, 0x77, 0x75,
  0x08, 0xE0, 0xB4, 0x0D, 0xD0, 0xE7, 0x77, 0x60, 0x2F, 0x01, 0x20, 0x3E, 0x09, 0x77, 0x77, 0x0B,
  0xE0, 0x62, 0x07, 0xE0, 0x37, 0x77, 0x70, 0x4E, 0x0B, 0x20, 0xCD, 0x0D, 0x77, 0x77, 0x20, 0xDE,
  0x10, 0x1E, 0x07, 0x77, 0x77, 0x20, 0x7E, 0x05, 0x06, 0xE0, 0x27, 0x77, 0x72, 0x01, 0xE0, 0x90,
  0xBD, 0x0B, 0x77, 0x77, 0x40, 0x9F, 0xD0, 0x57, 0x77, 0x74, 0x03, 0xFC, 0x0E, 0x77, 0x77, 0x60,
  0xCF, 0xB0, 0x97, 0x77, 0x76, 0x06, 0xFB, 0x04, 0x77, 0x77, 0x70, 0xEF, 0x90, 0xD8, 0x0C, 0x00,
  0x08, 0xF9, 0x08, 0x80, 0xC0, 0x00, 0x2F, 0x90, 0x28, 0x0C, 0x10, 0x0C, 0xE0, 0xC8, 0x0C, 0x10,
  0x01, 0xF0, 0x68, 0x0C, 0x10, 0x07, 0xF0, 0x18, 0x0C, 0x10, 0x0D, 0xE0, 0xA8, 0x0C, 0x10, 0x04,
  0xF0, 0x48, 0x0C, 0x10, 0x0B, 0xE0, 0xD8, 0x0C, 0x10, 0x01, 0xF0, 0x88, 0x0C, 0x10, 0x08, 0xF0,
  0x28, 0x0C, 0x10, 0x0E, 0xE0, 0xB8, 0x0C, 0x10, 0x07, 0xF0, 0x58, 0x0C, 0x00, 0x01, 0x0E, 0xE0,
  0xD8, 0x0C, 0x10, 0x0A, 0xF0, 0x68, 0x0C, 0x00, 0x07, 0xF0, 0xE8, 0x0C, 0x00, 0x07, 0xF9, 0x06,
  0x77, 0x77, 0x60, 0x40, 0xBF, 0x90, 0xD7, 0x77, 0x48, 0x90, 0x3E, 0xCA, 0x99, 0x89, 0xBE, 0xFB,
  0x03, 0x77, 0x74, 0x03, 0xFF, 0xC0, 0x87, 0x77, 0x50, 0x3F, 0xFB, 0x0A, 0x77, 0x76, 0x03, 0xFF,
  0xA0, 0x97, 0x77, 0x70, 0x3F, 0xF0, 0xE0, 0x67, 0x77, 0x71, 0x03, 0xFE, 0x09, 0x01, 0x77, 0x77,
  0x28, 0x93, 0x16, 0x9B, 0xCD, 0xEF, 0xED, 0xB9, 0x57, 0x77, 0x74,
  // "z" (U+007A)
  0x10, 0x7F, 0xFF, 0xFF, 0x81, 0x20, 0x7F, 0xFF, 0xFF, 0x81, 0x20, 0x7F, 0xFF, 0xFF, 0x81, 0x20,
  0x7F, 0xFF, 0xFF, 0x81, 0x20, 0x7F, 0xFF, 0xFF, 0x81, 0x20, 0x7F, 0xFF, 0xFF, 0x81, 0x20, 0x38,
  0x0A, 0x68, 0x0D, 0xF9, 0x02, 0x77, 0x76, 0x04, 0xF9, 0x0C, 0x77, 0x76, 0x02, 0x0E, 0xF0, 0xE0,
  0x27, 0x77, 0x60, 0xCF, 0x90, 0x47, 0x77, 0x60, 0x9F, 0x90, 0x77, 0x77, 0x60, 0x6F, 0x90, 0xA7,
  0x77, 0x60, 0x3F, 0x90, 0xC7, 0x77, 0x60, 0x10, 0xDF, 0x0E, 0x02, 0x77, 0x76, 0x0B, 0xF9, 0x04,
  0x77, 0x76, 0x08, 0xF9, 0x07, 0x77, 0x76, 0x05, 0xF9, 0x0A, 0x77, 0x76, 0x02, 0x0E, 0xF0, 0xC7,
  0x77, 0x70, 0xDF, 0x0E, 0x02, 0x77, 0x76, 0x0A, 0xF9, 0x04, 0x77, 0x76, 0x07, 0xF9, 0x07, 0x77,
  0x76, 0x04, 0xF9, 0x0A, 0x77, 0x76, 0x01, 0x0E, 0xF0, 0xC7, 0x77, 0x70, 0xCF, 0x0E, 0x02, 0x77,
  0x76, 0x09, 0xF9, 0x04, 0x77, 0x76, 0x06, 0xF9, 0x07, 0x77, 0x76, 0x03, 0xF9, 0x0A, 0x77, 0x76,
  0x01, 0x0D, 0xF0, 0xC7, 0x77, 0x70, 0xBF, 0x0E, 0x02, 0x77, 0x76, 0x08, 0xF9, 0x04, 0x77, 0x76,
  0x04, 0xF9, 0x07, 0x77, 0x76, 0x02, 0x0E, 0xF0, 0xA7, 0x77, 0x70, 0xCF, 0x0D, 0x77, 0x77, 0x0A,
  0xF0, 0xE0, 0x27, 0x77, 0x60, 0x6F, 0x90, 0x47, 0x77, 0x60, 0x3F, 0x90, 0x77, 0x77, 0x60, 0x10,
  0xEF, 0x0A, 0x77, 0x77, 0x0B, 0xF0, 0xD7, 0x77, 0x70, 0x8F, 0x0E, 0x02, 0x77, 0x76, 0x05, 0xF9,
  0x04, 0x77, 0x76, 0x02, 0x0E, 0xF0, 0x77, 0x77, 0x70, 0xDF, 0x0E, 0x80, 0xA7, 0x80, 0x70, 0xA8,
  0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8,
  0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x0E,
  // "{" (U+007B)
  0x77, 0x71, 0x86, 0x25, 0x8B, 0xCD, 0xE6, 0x77, 0x58, 0x11, 0x7D, 0xF0, 0x67, 0x73, 0x01, 0x09,
  0xFB, 0x06, 0x77, 0x20, 0x60, 0xEF, 0xC0, 0x67, 0x71, 0x09, 0xFE, 0x06, 0x77, 0x09, 0xFF, 0x06,
  0x76, 0x05, 0xFD, 0x82, 0xCA, 0x93, 0x76, 0x0D, 0xFA, 0x0B, 0x04, 0x77, 0x30, 0x5F, 0x90, 0xE0,
  0x47, 0x75, 0x0B, 0xF0, 0xE0, 0x27, 0x76, 0xF9, 0x06, 0x77, 0x60, 0x3F, 0x0E, 0x77, 0x70, 0x5F,
  0x0A, 0x77, 0x70, 0x6F, 0x08, 0x77, 0x70, 0x6F, 0x06, 0x77, 0x70, 0x6F, 0x06, 0x77, 0x70, 0x6F,
  0x06, 0x77, 0x70, 0x6F, 0x06, 0x77, 0x70, 0x6F, 0x06, 0x77, 0x70, 0x6F, 0x06, 0x77, 0x70, 0x6F,
  0x06, 0x77, 0x70, 0x6F, 0x06, 0x77, 0x70, 0x6F, 0x06, 0x77, 0x70, 0x6F, 0x06, 0x77, 0x70, 0x6F,
  0x06, 0x77, 0x70, 0x6F, 0x06, 0x77, 0x70, 0x6F, 0x06, 0x77, 0x70, 0x6F, 0x06, 0x77, 0x70, 0x7F,
  0x05, 0x77, 0x70, 0x9F, 0x04, 0x77, 0x70, 0xCF, 0x02, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x70, 0xBF,
  0x0A, 0x77, 0x60, 0x9F, 0x90, 0x37, 0x74, 0x03, 0x0B, 0xF9, 0x09, 0x77, 0x83, 0x12, 0x58, 0xDF,
  0xA0, 0xC7, 0x60, 0x6F, 0xF0, 0xA7, 0x70, 0x6F, 0xD0, 0xD0, 0x57, 0x71, 0x06, 0xFA, 0x81, 0xC8,
  0x37, 0x73, 0x06, 0xF9, 0x0B, 0x03, 0x77, 0x50, 0x6F, 0xB8, 0x1E, 0xA3, 0x77, 0x20, 0x6F, 0xE0,
  0xB0, 0x27, 0x78, 0x33, 0x99, 0xBE, 0xFB, 0x0E, 0x04, 0x77, 0x48, 0x11, 0x6C, 0xFA, 0x03, 0x77,
  0x60, 0x50, 0xEF, 0x0D, 0x77, 0x70, 0x3F, 0x90, 0x67, 0x77, 0x07, 0xF0, 0xC7, 0x77, 0x1F, 0x97,
  0x77, 0x10, 0xBF, 0x03, 0x77, 0x70, 0x8F, 0x05, 0x77, 0x70, 0x7F, 0x06, 0x77, 0x70, 0x6F, 0x06,
  0x77, 0x70, 0x6F, 0x06, 0x77, 0x70, 0x6F, 0x06, 0x77, 0x70, 0x6F, 0x06, 0x77, 0x70, 0x6F, 0x06,
  0x77, 0x70, 0x6F, 0x06, 0x77, 0x70, 0x6F, 0x06, 0x77, 0x70, 0x6F, 0x06, 0x77, 0x70, 0x6F, 0x06,
  0x77, 0x70, 0x6F, 0x06, 0x77, 0x70, 0x6F, 0x06, 0x77, 0x70, 0x6F, 0x06, 0x77, 0x70, 0x6F, 0x06,
  0x77, 0x70, 0x6F, 0x07, 0x77, 0x70, 0x5F, 0x08, 0x77, 0x70, 0x4F, 0x0B, 0x77, 0x70, 0x2F, 0x90,
  0x17, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x09, 0xF9, 0x06, 0x77, 0x60, 0x3F, 0xA0, 0x90, 0x17, 0x75,
  0x0B, 0xFB, 0x82, 0xB6, 0x31, 0x77, 0x10, 0x20, 0xEF, 0xF0, 0x67, 0x70, 0x5F, 0xF0, 0x67, 0x71,
  0x05, 0x0E, 0xFD, 0x06, 0x77, 0x20, 0x20, 0xBF, 0xC0, 0x67, 0x74, 0x04, 0x0B, 0xFA, 0x06, 0x77,
  0x68, 0x22, 0x7B, 0xED, 0x06, 0x77, 0x73, 0x84, 0x24, 0x66, 0x73,
  // "|" (U+007C)
  0x03, 0xE0, 0x50, 0x3E, 0x05, 0x03, 0xE0, 0x50, 0x3E, 0x05, 0x03, 0xE0, 0x50, 0x3E, 0x05, 0x03,
  0xE0, 0x50, 0x3E, 0x05, 0x03, 0xE0, 0x50, 0x3E, 0x05, 0x03, 0xE0, 0x50, 0x3E, 0x05, 0x03, 0xE0,
  0x50, 0x3E, 0x05, 0x03, 0xE0, 0x50, 0x3E, 0x05, 0x03, 0xE0, 0x50, 0x3E, 0x05, 0x03, 0xE0, 0x50,
  0x3E, 0x05, 0x03, 0xE0, 0x50, 0x3E, 0x05, 0x03, 0xE0, 0x50, 0x3E, 0x05, 0x03, 0xE0, 0x50, 0x3E,
  0x05, 0x03, 0xE0, 0x50, 0x3E, 0x05, 0x03, 0xE0, 0x50, 0x3E, 0x05, 0x03, 0xE0, 0x50, 0x3E, 0x05,
  0x03, 0xE0, 0x50, 0x3E, 0x05, 0x03, 0xE0, 0x50, 0x3E, 0x05, 0x03, 0xE0, 0x50, 0x3E, 0x05, 0x03,
  0xE0, 0x50, 0x3E, 0x05, 0x03, 0xE0, 0x50, 0x3E, 0x05, 0x03, 0xE0, 0x50, 0x3E, 0x05, 0x03, 0xE0,
  0x50, 0x3E, 0x05, 0x03, 0xE0, 0x50, 0x3E, 0x05, 0x03, 0xE0, 0x50, 0x3E, 0x05, 0x03, 0xE0, 0x50,
  0x3E, 0x05, 0x03, 0xE0, 0x50, 0x3E, 0x05, 0x03, 0xE0, 0x50, 0x3E, 0x05, 0x03, 0xE0, 0x50, 0x3E,
  0x05, 0x03, 0xE0, 0x50, 0x3E, 0x05, 0x03, 0xE0, 0x50, 0x3E, 0x05, 0x03, 0xE0, 0x50, 0x3E, 0x05,
  0x03, 0xE0, 0x50, 0x3E, 0x05, 0x03, 0xE0, 0x50, 0x3E, 0x05, 0x03, 0xE0, 0x50, 0x3E, 0x05, 0x03,
  0xE0, 0x50, 0x3E, 0x05, 0x03, 0xE0, 0x50, 0x3E, 0x05, 0x03, 0xE0, 0x50, 0x3E, 0x05, 0x03, 0xE0,
  0x50, 0x3E, 0x05, 0x03, 0xE0, 0x50, 0x3E, 0x05, 0x03, 0xE0, 0x50, 0x3E, 0x05, 0x03, 0xE0, 0x50,
  0x3E, 0x05, 0x03, 0xE0, 0x50, 0x3E, 0x05, 0x03, 0xE0, 0x50, 0x3E, 0x05, 0x03, 0xE0, 0x50, 0x3E,
  0x05,
  // "}" (U+007D)
  0x84, 0x37, 0x65, 0x42, 0x77, 0x73, 0x06, 0xD8, 0x2E, 0xB7, 0x17, 0x76, 0x06, 0xFA, 0x0B, 0x04,
  0x77, 0x40, 0x6F, 0xC0, 0xA0, 0x27, 0x72, 0x06, 0xFD, 0x0E, 0x04, 0x77, 0x10, 0x6F, 0xF0, 0x47,
  0x70, 0x6F, 0xF0, 0xE0, 0x27, 0x71, 0x82, 0x13, 0x6B, 0xFB, 0x0B, 0x77, 0x50, 0x10, 0xAF, 0xA0,
  0x37, 0x76, 0x06, 0xF9, 0x09, 0x77, 0x70, 0x9F, 0x0E, 0x77, 0x70, 0x1F, 0x90, 0x27, 0x77, 0x0C,
  0xF0, 0x47, 0x77, 0x08, 0xF0, 0x57, 0x77, 0x07, 0xF0, 0x67, 0x77, 0x06, 0xF0, 0x67, 0x77, 0x06,
  0xF0, 0x67, 0x77, 0x06, 0xF0, 0x67, 0x77, 0x06, 0xF0, 0x67, 0x77, 0x06, 0xF0, 0x67, 0x77, 0x06,
  0xF0, 0x67, 0x77, 0x06, 0xF0, 0x67, 0x77, 0x06, 0xF0, 0x67, 0x77, 0x06, 0xF0, 0x67, 0x77, 0x06,
  0xF0, 0x67, 0x77, 0x06, 0xF0, 0x67, 0x77, 0x06, 0xF0, 0x67, 0x77, 0x06, 0xF0, 0x67, 0x77, 0x06,
  0xF0, 0x77, 0x77, 0x05, 0xF0, 0x87, 0x77, 0x03, 0xF0, 0xB7, 0x77, 0x01, 0xF9, 0x77, 0x71, 0x0C,
  0xF0, 0x77, 0x77, 0x06, 0xF0, 0xE0, 0x37, 0x77, 0x0D, 0xF0, 0xE0, 0x57, 0x76, 0x03, 0xFA, 0x81,
  0xC6, 0x17, 0x74, 0x04, 0x0E, 0xFB, 0x83, 0xDB, 0x99, 0x37, 0x70, 0x20, 0xBF, 0xE0, 0x67, 0x72,
  0x81, 0x4A, 0xEF, 0xB0, 0x67, 0x75, 0x03, 0x0B, 0xF9, 0x06, 0x77, 0x38, 0x13, 0x8C, 0xFA, 0x06,
  0x77, 0x10, 0x50, 0xDF, 0xD0, 0x67, 0x70, 0xAF, 0xF0, 0x67, 0x60, 0xCF, 0xA8, 0x3D, 0x85, 0x21,
  0x77, 0x09, 0xF9, 0x0C, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x97, 0x76, 0x0A, 0xF0, 0xB7, 0x77, 0x0E,
  0xF0, 0x27, 0x76, 0x02, 0xF0, 0xC7, 0x77, 0x04, 0xF0, 0x97, 0x77, 0x05, 0xF0, 0x77, 0x77, 0x06,
  0xF0, 0x67, 0x77, 0x06, 0xF0, 0x67, 0x77, 0x06, 0xF0, 0x67, 0x77, 0x06, 0xF0, 0x67, 0x77, 0x06,
  0xF0, 0x67, 0x77, 0x06, 0xF0, 0x67, 0x77, 0x06, 0xF0, 0x67, 0x77, 0x06, 0xF0, 0x67, 0x77, 0x06,
  0xF0, 0x67, 0x77, 0x06, 0xF0, 0x67, 0x77, 0x06, 0xF0, 0x67, 0x77, 0x06, 0xF0, 0x67, 0x77, 0x06,
  0xF0, 0x67, 0x77, 0x06, 0xF0, 0x67, 0x77, 0x08, 0xF0, 0x57, 0x77, 0x0A, 0xF0, 0x57, 0x77, 0x0E,
  0xF0, 0x37, 0x76, 0x06, 0xF9, 0x77, 0x60, 0x20, 0xEF, 0x0B, 0x77, 0x50, 0x40, 0xEF, 0x90, 0x57,
  0x73, 0x04, 0x0A, 0xFA, 0x0D, 0x76, 0x82, 0x39, 0xAC, 0xFD, 0x05, 0x76, 0x06, 0xFF, 0x09, 0x77,
  0x06, 0xFE, 0x09, 0x77, 0x10, 0x6F, 0xC0, 0xE0, 0x67, 0x72, 0x06, 0xFB, 0x09, 0x01, 0x77, 0x30,
  0x6F, 0x81, 0xD7, 0x27, 0x75, 0x86, 0x6E, 0xDC, 0xB8, 0x52, 0x77, 0x71,
  // "~" (U+007E)
  0x78, 0x72, 0x8C, 0xEF, 0xEC, 0x94, 0x77, 0x50, 0x4D, 0x01, 0x60, 0x9F, 0xA0, 0xC0, 0x37, 0x73,
  0x07, 0xC0, 0xE6, 0x0A, 0xFD, 0x08, 0x77, 0x20, 0x9C, 0x0C, 0x50, 0xAF, 0xF0, 0xB0, 0x17, 0x70,
  0xCC, 0x09, 0x40, 0x4F, 0xFA, 0x0D, 0x02, 0x76, 0xD0, 0x64, 0x0D, 0xD8, 0x49, 0x20, 0x15, 0xCE,
  0x0D, 0x02, 0x74, 0x03, 0xD0, 0x33, 0x04, 0xD0, 0x86, 0x06, 0xE0, 0xE0, 0x37, 0x30, 0x7C, 0x0E,
  0x40, 0xAC, 0x0D, 0x71, 0x04, 0x0E, 0xD0, 0xE0, 0x47, 0x20, 0xDC, 0x0A, 0x4D, 0x06, 0x72, 0x03,
  0x0E, 0xE0, 0x67, 0x03, 0xD0, 0x43, 0x04, 0xD0, 0x17, 0x30, 0x30, 0xEE, 0x08, 0x60, 0xCC, 0x0D,
  0x40, 0x7C, 0x0C, 0x75, 0x03, 0x0E, 0xE8, 0x4C, 0x51, 0x03, 0xCD, 0x06, 0x40, 0xAC, 0x08, 0x76,
  0x02, 0x0D, 0xFF, 0x90, 0xC5, 0x0C, 0xC0, 0x67, 0x70, 0x10, 0xCF, 0xF0, 0x35, 0x0E, 0xC0, 0x37,
  0x72, 0x08, 0xFD, 0x04, 0x50, 0x1D, 0x01, 0x77, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x46, 0x04, 0xD7,
  0x76, 0x86, 0x49, 0xDE, 0xFE, 0xB6, 0x71,
  // "¡" (U+00A1)
  0x38, 0x47, 0xCE, 0xEC, 0x74, 0x01, 0x0D, 0xE0, 0xD0, 0x12, 0x0C, 0xF9, 0x81, 0xC0, 0x3F, 0xB0,
  0x30, 0x7F, 0xB0, 0x70, 0x8F, 0xB0, 0x08, 0xFB, 0x08, 0x07, 0xFB, 0x07, 0x03, 0xFB, 0x81, 0x30,
  0xDF, 0x90, 0xD2, 0x03, 0x0E, 0xE0, 0xE0, 0x23, 0x81, 0x18, 0xCA, 0x81, 0xC8, 0x18, 0x09, 0xA4,
  0x00, 0x8E, 0x06, 0x40, 0x8E, 0x07, 0x40, 0x9E, 0x07, 0x40, 0x9E, 0x08, 0x40, 0xAE, 0x08, 0x40,
  0xAE, 0x09, 0x40, 0xBE, 0x09, 0x40, 0xBE, 0x0A, 0x40, 0xCE, 0x0A, 0x40, 0xCE, 0x0B, 0x40, 0xDE,
  0x0B, 0x40, 0xDE, 0x0C, 0x40, 0xEE, 0x0C, 0x40, 0xEE, 0x0D, 0x4F, 0x0D, 0x4F, 0x0E, 0x4F, 0x0E,
  0x30, 0x1F, 0x93, 0x01, 0xF9, 0x30, 0x2F, 0x93, 0x02, 0xF9, 0x30, 0x3F, 0x90, 0x12, 0x03, 0xF9,
  0x01, 0x20, 0x3F, 0x90, 0x22, 0x04, 0xF9, 0x02, 0x20, 0x4F, 0x90, 0x32, 0x05, 0xF9, 0x03, 0x20,
  0x5F, 0x90, 0x42, 0x06, 0xF9, 0x04, 0x20, 0x6F, 0x90, 0x52, 0x07, 0xF9, 0x05, 0x20, 0x7F, 0x90,
  0x62, 0x08, 0xF9, 0x06, 0x20, 0x8F, 0x90, 0x72, 0x09, 0xF9, 0x07, 0x20, 0x9F, 0x90, 0x82, 0x0A,
  0xF9, 0x08, 0x20, 0xAF, 0x90, 0x92, 0x0B, 0xF9, 0x09, 0x20, 0xBF, 0x90, 0xA2, 0x0C, 0xF9, 0x0A,
  0x20, 0xCF, 0x90, 0xB2, 0x0D, 0xF9, 0x0B, 0x20, 0xDF, 0x90, 0xC2, 0x0E, 0xF9, 0x0C, 0x20, 0xEF,
  0x90, 0xD1,
  // "¢" (U+00A2)
  0x77, 0x40, 0x7D, 0x0A, 0x77, 0x77, 0x30, 0x7D, 0x0A, 0x77, 0x77, 0x30, 0x7D, 0x0A, 0x77, 0x77,
  0x30, 0x7D, 0x0A, 0x77, 0x77, 0x30, 0x7D, 0x0A, 0x77, 0x77, 0x30, 0x7D, 0x0A, 0x77, 0x77, 0x30,
  0x7D, 0x0A, 0x77, 0x77, 0x30, 0x7D, 0x84, 0xD7, 0x66, 0x42, 0x77, 0x71, 0x82, 0x37, 0xBE, 0xFE,
  0x82, 0xDA, 0x62, 0x77, 0x10, 0x70, 0xDF, 0xFF, 0x81, 0xD8, 0x27, 0x30, 0x70, 0xEF, 0xFF, 0xC0,
  0xB7, 0x10, 0x20, 0xCF, 0xFF, 0xE0, 0x57, 0x05, 0xFF, 0xFF, 0x0E, 0x70, 0x6F, 0xFF, 0xF9, 0x0A,
  0x60, 0x6F, 0xC8, 0x3D, 0x95, 0x31, 0x38, 0x41, 0x24, 0x7A, 0xDD, 0x04, 0x50, 0x3F, 0xB0, 0xA0,
  0x37, 0x78, 0x32, 0x7C, 0xFE, 0x50, 0x10, 0xDF, 0x90, 0xE0, 0x47, 0x75, 0x02, 0x04, 0x50, 0x9F,
  0x90, 0xD0, 0x17, 0x77, 0x50, 0x2F, 0x90, 0xD0, 0x17, 0x77, 0x60, 0x9F, 0x90, 0x47, 0x77, 0x70,
  0xEF, 0x0A, 0x77, 0x77, 0x05, 0xF9, 0x02, 0x77, 0x77, 0x0A, 0xF0, 0xB7, 0x77, 0x71, 0x0E, 0xF0,
  0x67, 0x77, 0x70, 0x2F, 0x90, 0x17, 0x77, 0x70, 0x5F, 0x0D, 0x77, 0x77, 0x10, 0x7F, 0x0A, 0x77,
  0x77, 0x10, 0x9F, 0x08, 0x77, 0x77, 0x10, 0xBF, 0x06, 0x77, 0x77, 0x10, 0xCF, 0x04, 0x77, 0x77,
  0x10, 0xDF, 0x03, 0x77, 0x77, 0x10, 0xDF, 0x03, 0x77, 0x77, 0x10, 0xDF, 0x03, 0x77, 0x77, 0x10,
  0xDF, 0x03, 0x77, 0x77, 0x10, 0xDF, 0x03, 0x77, 0x77, 0x10, 0xCF, 0x05, 0x77, 0x77, 0x10, 0xBF,
  0x06, 0x77, 0x77, 0x10, 0x9F, 0x08, 0x77, 0x77, 0x10, 0x7F, 0x0A, 0x77, 0x77, 0x10, 0x5F, 0x0D,
  0x77, 0x77, 0x10, 0x2F, 0x90, 0x27, 0x77, 0x71, 0x0E, 0xF0, 0x67, 0x77, 0x71, 0x0B, 0xF0, 0xC7,
  0x77, 0x71, 0x06, 0xF9, 0x03, 0x77, 0x77, 0x1F, 0x90, 0xC7, 0x77, 0x71, 0x0A, 0xF9, 0x07, 0x77,
  0x77, 0x02, 0xFA, 0x05, 0x77, 0x77, 0x09, 0xFA, 0x06, 0x77, 0x76, 0x01, 0x0E, 0xFA, 0x0B, 0x02,
  0x77, 0x48, 0x24, 0xAE, 0x14, 0x04, 0xFC, 0x81, 0xA5, 0x17, 0x38, 0x31, 0x37, 0xBE, 0xB0, 0x15,
  0x07, 0xFE, 0x89, 0x0D, 0xB9, 0x88, 0x9A, 0xAC, 0xEF, 0x90, 0x16, 0x07, 0xFF, 0xFF, 0xA0, 0x17,
  0x05, 0x0E, 0xFF, 0xFF, 0x01, 0x71, 0x02, 0x0B, 0xFF, 0xFE, 0x01, 0x73, 0x05, 0x0C, 0xFF, 0xFB,
  0x0C, 0x76, 0x81, 0x39, 0xEF, 0xFC, 0x81, 0xD9, 0x37, 0x73, 0x82, 0x37, 0xAD, 0xE8, 0x6E, 0xED,
  0xCA, 0x85, 0x27, 0x77, 0x20, 0x7D, 0x09, 0x77, 0x77, 0x30, 0x7D, 0x09, 0x77, 0x77, 0x30, 0x7D,
  0x09, 0x77, 0x77, 0x30, 0x7D, 0x09, 0x77, 0x77, 0x30, 0x7D, 0x09, 0x77, 0x77, 0x30, 0x7D, 0x09,
  0x77, 0x77, 0x30, 0x7D, 0x09, 0x77, 0x77, 0x30, 0x7D, 0x09, 0x77, 0x77, 0x30, 0x6D, 0x08, 0x76,
  // "£" (U+00A3)
  0x77, 0x58, 0x34, 0x7B, 0xDE, 0xA8, 0x4E, 0xDC, 0xA6, 0x37, 0x77, 0x38, 0x11, 0x8E, 0xFE, 0x81,
  0xEA, 0x47, 0x76, 0x07, 0x0E, 0xFF, 0xC0, 0xD0, 0x67, 0x72, 0x01, 0x0C, 0xFF, 0xF9, 0x0D, 0x02,
  0x76, 0x01, 0x0D, 0xFF, 0xFA, 0x0E, 0x01, 0x75, 0x01, 0x0D, 0xFF, 0xFB, 0x09, 0x76, 0x0A, 0xFB,
  0x85, 0xEB, 0x98, 0x9A, 0xCF, 0x90, 0x27, 0x50, 0x4F, 0xA0, 0xB0, 0x47, 0x10, 0x40, 0xAC, 0x0A,
  0x76, 0x0D, 0xF9, 0x06, 0x75, 0x01, 0x08, 0xA0, 0x37, 0x50, 0x4F, 0x90, 0x77, 0x71, 0x02, 0x09,
  0x76, 0x09, 0xF0, 0xC7, 0x77, 0x73, 0x0E, 0xF0, 0x57, 0x77, 0x72, 0x02, 0xF0, 0xE7, 0x77, 0x73,
  0x04, 0xF0, 0xC7, 0x77, 0x73, 0x06, 0xF0, 0x97, 0x77, 0x73, 0x07, 0xF0, 0x77, 0x77, 0x73, 0x08,
  0xF0, 0x67, 0x77, 0x73, 0x08, 0xF0, 0x67, 0x77, 0x73, 0x08, 0xF0, 0x67, 0x77, 0x73, 0x08, 0xF0,
  0x67, 0x77, 0x73, 0x08, 0xF0, 0x67, 0x77, 0x73, 0x08, 0xF0, 0x67, 0x77, 0x73, 0x08, 0xF0, 0x67,
  0x77, 0x73, 0x08, 0xF0, 0x67, 0x77, 0x73, 0x08, 0xF0, 0x67, 0x77, 0x73, 0x08, 0xF0, 0x67, 0x77,
  0x73, 0x08, 0xF0, 0x67, 0x77, 0x73, 0x08, 0xF0, 0x67, 0x77, 0x73, 0x08, 0xF0, 0x67, 0x77, 0x73,
  0x08, 0xF0, 0x67, 0x77, 0x20, 0x9F, 0xFF, 0xFB, 0x04, 0x70, 0x9F, 0xFF, 0xFB, 0x04, 0x70, 0x9F,
  0xFF, 0xFB, 0x04, 0x70, 0x9F, 0xFF, 0xFB, 0x04, 0x70, 0x9F, 0xFF, 0xFB, 0x04, 0x70, 0x9F, 0xFF,
  0xFB, 0x04, 0x77, 0x10, 0x8F, 0x06, 0x77, 0x77, 0x30, 0x8F, 0x06, 0x77, 0x77, 0x30, 0x8F, 0x06,
  0x77, 0x77, 0x30, 0x8F, 0x06, 0x77, 0x77, 0x30, 0x8F, 0x06, 0x77, 0x77, 0x30, 0x8F, 0x06, 0x77,
  0x77, 0x30, 0x8F, 0x06, 0x77, 0x77, 0x30, 0x8F, 0x06, 0x77, 0x77, 0x30, 0x8F, 0x06, 0x77, 0x77,
  0x30, 0x8F, 0x05, 0x77, 0x77, 0x30, 0x9F, 0x04, 0x77, 0x77, 0x30, 0x9F, 0x03, 0x77, 0x77, 0x30,
  0xAF, 0x01, 0x77, 0x77, 0x30, 0xDE, 0x0C, 0x77, 0x77, 0x4F, 0x08, 0x77, 0x77, 0x30, 0x5F, 0x03,
  0x77, 0x77, 0x30, 0xAE, 0x0C, 0x77, 0x77, 0x30, 0x3F, 0x05, 0x77, 0x77, 0x30, 0xCE, 0x0C, 0x77,
  0x77, 0x30, 0xAE, 0x0E, 0x02, 0x77, 0x77, 0x10, 0x10, 0xBF, 0x05, 0x77, 0x77, 0x10, 0x60, 0xEF,
  0x05, 0x77, 0x77, 0x08, 0x0E, 0x80, 0xC1, 0xF0, 0x30, 0xE8, 0x0C, 0x2F, 0x03, 0x0E, 0x80, 0xC2,
  0xF0, 0x30, 0xE8, 0x0C, 0x2F, 0x03, 0x0E, 0x80, 0xC2, 0xF0, 0x30, 0xE8, 0x0C, 0x2F, 0x03, 0x0E,
  0x80, 0xC2, 0xF0, 0x30,
  // "¤" (U+00A4)
  0x40, 0x40, 0x17, 0x77, 0x73, 0x04, 0x78, 0x25, 0xFC, 0x17, 0x77, 0x71, 0x81, 0xBF, 0x55, 0x04,
  0xB0, 0xC7, 0x77, 0x70, 0xBB, 0x05, 0x30, 0x4D, 0x0B, 0x71, 0x89, 0x04, 0x8C, 0xDE, 0xED, 0xC9,
  0x47, 0x10, 0xBD, 0x81, 0x50, 0x4F, 0x0B, 0x48, 0x12, 0x8E, 0xFB, 0x81, 0xE8, 0x14, 0x0B, 0xF8,
  0x14, 0x3E, 0xF0, 0xB2, 0x08, 0xFF, 0xA0, 0x72, 0x0B, 0xF9, 0x81, 0x30, 0x4F, 0x90, 0xB0, 0xCF,
  0xFC, 0x0C, 0x0B, 0xF9, 0x05, 0x30, 0x68, 0x0C, 0x0F, 0x06, 0x50, 0x7F, 0xFF, 0xFE, 0x08, 0x70,
  0x9F, 0xE8, 0x4C, 0xA9, 0x9A, 0xBF, 0xE0, 0xA7, 0x20, 0xAF, 0xA8, 0x1C, 0x51, 0x70, 0x40, 0xAF,
  0xA0, 0xB7, 0x40, 0xDE, 0x0E, 0x04, 0x75, 0x02, 0x0C, 0xF0, 0x17, 0x30, 0x3E, 0x0C, 0x01, 0x77,
  0x10, 0x9E, 0x05, 0x73, 0x0C, 0xD0, 0xC7, 0x74, 0x0A, 0xD0, 0xE7, 0x20, 0x4D, 0x0E, 0x01, 0x77,
  0x50, 0xDD, 0x06, 0x71, 0x0B, 0xD0, 0x77, 0x76, 0x04, 0xD0, 0xD7, 0x01, 0xE7, 0x77, 0x10, 0xCD,
  0x03, 0x60, 0x5D, 0x0B, 0x77, 0x71, 0x08, 0xD0, 0x86, 0x09, 0xD0, 0x77, 0x77, 0x10, 0x4D, 0x0C,
  0x60, 0xBD, 0x05, 0x77, 0x71, 0x02, 0xD0, 0xE6, 0x0D, 0xD0, 0x37, 0x77, 0x10, 0x1E, 0x60, 0xDD,
  0x03, 0x77, 0x71, 0x01, 0xE0, 0x15, 0x0C, 0xD0, 0x47, 0x77, 0x10, 0x2E, 0x60, 0xBD, 0x06, 0x77,
  0x71, 0x03, 0xD0, 0xE6, 0x08, 0xD0, 0xA7, 0x77, 0x10, 0x7D, 0x0B, 0x60, 0x3D, 0x0E, 0x77, 0x71,
  0x0C, 0xD0, 0x77, 0x0E, 0xD0, 0x67, 0x76, 0x03, 0xE0, 0x37, 0x08, 0xD0, 0xE7, 0x76, 0x0C, 0xD0,
  0xC7, 0x10, 0x1E, 0x0B, 0x77, 0x40, 0x8E, 0x05, 0x72, 0x08, 0xE0, 0xA7, 0x72, 0x08, 0xE0, 0xC7,
  0x40, 0xDE, 0x0D, 0x03, 0x75, 0x02, 0x0B, 0xF0, 0x27, 0x30, 0x3F, 0xA0, 0xB0, 0x57, 0x10, 0x30,
  0xAF, 0xA0, 0x47, 0x20, 0x30, 0xEF, 0xD8, 0x5C, 0xA9, 0x8A, 0xBE, 0xFD, 0x03, 0x70, 0x20, 0xEF,
  0xFF, 0xFC, 0x0E, 0x02, 0x50, 0x20, 0xEF, 0xFF, 0xFE, 0x0E, 0x02, 0x30, 0x20, 0xDF, 0x0D, 0x0E,
  0xFF, 0xFE, 0x83, 0xD1, 0x01, 0xDF, 0x82, 0xC1, 0x19, 0xFF, 0xA8, 0x2C, 0x33, 0xEF, 0x81, 0xC1,
  0x4F, 0x0C, 0x01, 0x38, 0x12, 0x9E, 0xFC, 0x0B, 0x04, 0x30, 0x20, 0xEF, 0x81, 0x40, 0x4D, 0x0C,
  0x01, 0x78, 0x91, 0x48, 0xCD, 0xEF, 0xDC, 0x96, 0x16, 0x02, 0x0D, 0xD0, 0x63, 0x04, 0xB0, 0xC0,
  0x17, 0x77, 0x50, 0x20, 0xDB, 0x06, 0x58, 0x25, 0xFC, 0x17, 0x77, 0x78, 0x21, 0xDF, 0x77, 0x04,
  0x01, 0x77, 0x77, 0x20, 0x10, 0x64,
  // "¥" (U+00A5)
  0x09, 0xF0, 0xB7, 0x77, 0x72, 0x0A, 0xF8, 0x18, 0x1E, 0xF0, 0x47, 0x77, 0x70, 0x3F, 0x82, 0xE1,
  0x08, 0xF0, 0xB7, 0x77, 0x70, 0xBF, 0x07, 0x20, 0x10, 0xEF, 0x04, 0x77, 0x75, 0x03, 0xF0, 0xE4,
  0x07, 0xF0, 0xB7, 0x77, 0x50, 0xBF, 0x06, 0x50, 0xEF, 0x04, 0x77, 0x73, 0x03, 0xF0, 0xD6, 0x06,
  0xF0, 0xB7, 0x77, 0x30, 0xBF, 0x05, 0x70, 0xDF, 0x04, 0x77, 0x71, 0x04, 0xF0, 0xC7, 0x10, 0x6F,
  0x0B, 0x77, 0x71, 0x0B, 0xF0, 0x47, 0x20, 0xDF, 0x04, 0x77, 0x60, 0x4F, 0x0B, 0x73, 0x05, 0xF0,
  0xB7, 0x76, 0x0C, 0xF0, 0x37, 0x40, 0xCF, 0x04, 0x77, 0x40, 0x4F, 0x0A, 0x75, 0x04, 0xF0, 0xB7,
  0x74, 0x0C, 0xF0, 0x27, 0x60, 0xCF, 0x04, 0x77, 0x20, 0x4F, 0x09, 0x77, 0x03, 0xF0, 0xB7, 0x72,
  0x0C, 0xF0, 0x17, 0x71, 0x0B, 0xF0, 0x47, 0x70, 0x5F, 0x08, 0x77, 0x20, 0x3F, 0x0B, 0x77, 0x0C,
  0xE0, 0xE0, 0x17, 0x73, 0x0A, 0xF0, 0x47, 0x50, 0x5F, 0x07, 0x77, 0x40, 0x2F, 0x0B, 0x75, 0x0D,
  0xE0, 0xE7, 0x76, 0x09, 0xF0, 0x47, 0x30, 0x5F, 0x06, 0x77, 0x60, 0x2F, 0x0C, 0x73, 0x0D, 0xE0,
  0xD7, 0x77, 0x10, 0x9F, 0x04, 0x71, 0x06, 0xF0, 0x57, 0x77, 0x10, 0x10, 0xEE, 0x0C, 0x71, 0x0D,
  0xE0, 0xC7, 0x77, 0x30, 0x8F, 0x04, 0x60, 0x6F, 0x04, 0x77, 0x73, 0x01, 0x0E, 0xE0, 0xC6, 0x0D,
  0xE0, 0xB7, 0x77, 0x50, 0x7F, 0x04, 0x40, 0x6F, 0x03, 0x77, 0x76, 0x0E, 0xE0, 0xC4, 0x0D, 0xE0,
  0xA7, 0x77, 0x70, 0x6F, 0x04, 0x20, 0x6F, 0x02, 0x77, 0x77, 0x10, 0xDE, 0x0C, 0x20, 0xEE, 0x09,
  0x77, 0x77, 0x20, 0x6F, 0x04, 0x07, 0xF0, 0x17, 0x77, 0x73, 0x0D, 0xE0, 0xC0, 0xEE, 0x08, 0x77,
  0x77, 0x40, 0x5F, 0xE0, 0xE0, 0x17, 0x77, 0x75, 0x0C, 0xFD, 0x07, 0x77, 0x73, 0x0E, 0xFF, 0xFF,
  0xC0, 0xE7, 0x70, 0xEF, 0xFF, 0xFC, 0x0E, 0x77, 0x0E, 0xFF, 0xFF, 0xC0, 0xE7, 0x70, 0xEF, 0xFF,
  0xFC, 0x0E, 0x77, 0x0E, 0xFF, 0xFF, 0xC0, 0xE7, 0x70, 0xEF, 0xFF, 0xFC, 0x0E, 0x77, 0x76, 0x0E,
  0xE0, 0xC8, 0x0C, 0x40, 0x0E, 0xE0, 0xC8, 0x0C, 0x40, 0x0E, 0xE0, 0xC8, 0x0C, 0x40, 0x0E, 0xE0,
  0xC8, 0x0C, 0x40, 0x0E, 0xE0, 0xC8, 0x0C, 0x40, 0x0E, 0xE0, 0xC8, 0x0C, 0x40, 0x0E, 0xE0, 0xC8,
  0x0C, 0x40, 0x0E, 0xE0, 0xC7, 0x77, 0x60, 0xEF, 0xFF, 0xFC, 0x0E, 0x77, 0x0E, 0xFF, 0xFF, 0xC0,
  0xE7, 0x70, 0xEF, 0xFF, 0xFC, 0x0E, 0x77, 0x0E, 0xFF, 0xFF, 0xC0, 0xE7, 0x70, 0xEF, 0xFF, 0xFC,
  0x0E, 0x77, 0x0E, 0xFF, 0xFF, 0xC0, 0xE7, 0x77, 0x60, 0xEE, 0x0C, 0x80, 0xC4, 0x00, 0xEE, 0x0C,
  0x80, 0xC4, 0x00, 0xEE, 0x0C, 0x80, 0xC4, 0x00, 0xEE, 0x0C, 0x80, 0xC4, 0x00, 0xEE, 0x0C, 0x80,
  0xC4, 0x00, 0xEE, 0x0C, 0x80, 0xC4, 0x00, 0xEE, 0x0C, 0x80, 0xC4, 0x00, 0xEE, 0x0C, 0x80, 0xC4,
  0x00, 0xEE, 0x0C, 0x80, 0xC4, 0x00, 0xEE, 0x0C, 0x80, 0xC4, 0x00, 0xEE, 0x0C, 0x77, 0x60,
  // "¦" (U+00A6)
  0x05, 0xE0, 0x30, 0x5E, 0x03, 0x05, 0xE0, 0x30, 0x5E, 0x03, 0x05, 0xE0, 0x30, 0x5E, 0x03, 0x05,
  0xE0, 0x30, 0x5E, 0x03, 0x05, 0xE0, 0x30, 0x5E, 0x03, 0x05, 0xE0, 0x30, 0x5E, 0x03, 0x05, 0xE0,
  0x30, 0x5E, 0x03, 0x05, 0xE0, 0x30, 0x5E, 0x03, 0x05, 0xE0, 0x30, 0x5E, 0x03, 0x05, 0xE0, 0x30,
  0x5E, 0x03, 0x05, 0xE0, 0x30, 0x5E, 0x03, 0x05, 0xE0, 0x30, 0x5E, 0x03, 0x05, 0xE0, 0x30, 0x5E,
  0x03, 0x05, 0xE0, 0x30, 0x5E, 0x03, 0x05, 0xE0, 0x30, 0x5E, 0x03, 0x05, 0xE0, 0x30, 0x5E, 0x03,
  0x05, 0xE0, 0x30, 0x5E, 0x03, 0x80, 0xAD, 0x40, 0x05, 0xE0, 0x30, 0x5E, 0x03, 0x05, 0xE0, 0x30,
  0x5E, 0x03, 0x05, 0xE0, 0x30, 0x5E, 0x03, 0x05, 0xE0, 0x30, 0x5E, 0x03, 0x05, 0xE0, 0x30, 0x5E,
  0x03, 0x05, 0xE0, 0x30, 0x5E, 0x03, 0x05, 0xE0, 0x30, 0x5E, 0x03, 0x05, 0xE0, 0x30, 0x5E, 0x03,
  0x05, 0xE0, 0x30, 0x5E, 0x03, 0x05, 0xE0, 0x30, 0x5E, 0x03, 0x05, 0xE0, 0x30, 0x5E, 0x03, 0x05,
  0xE0, 0x30, 0x5E, 0x03, 0x05, 0xE0, 0x30, 0x5E, 0x03, 0x05, 0xE0, 0x30, 0x5E, 0x03, 0x05, 0xE0,
  0x30, 0x5E, 0x03, 0x05, 0xE0, 0x30, 0x5E, 0x03, 0x05, 0xE0, 0x30, 0x5E, 0x03,
  // "§" (U+00A7)
  0x74, 0x85, 0x25, 0x8A, 0xCD, 0xEB, 0x85, 0xED, 0xCA, 0x85, 0x27, 0x72, 0x81, 0x27, 0xCF, 0xFB,
  0x81, 0xD8, 0x47, 0x40, 0x10, 0x8F, 0xFF, 0xA8, 0x1E, 0x83, 0x70, 0x40, 0xEF, 0xFF, 0xE0, 0x25,
  0x05, 0xFF, 0xFF, 0x0C, 0x50, 0x3F, 0xFF, 0xF9, 0x06, 0x50, 0xDF, 0x98, 0x3D, 0x95, 0x31, 0x48,
  0x31, 0x35, 0x7B, 0xF0, 0x14, 0x06, 0xF9, 0x06, 0x77, 0x81, 0x16, 0xCB, 0x0A, 0x50, 0xBF, 0x04,
  0x77, 0x48, 0x24, 0xCF, 0x55, 0xF0, 0x97, 0x77, 0x04, 0x50, 0x2F, 0x04, 0x77, 0x76, 0x02, 0xF0,
  0x37, 0x77, 0x60, 0x2F, 0x05, 0x77, 0x76, 0x01, 0xF0, 0xB7, 0x77, 0x70, 0xDF, 0x05, 0x77, 0x76,
  0x09, 0xF9, 0x05, 0x77, 0x75, 0x03, 0xFA, 0x09, 0x01, 0x77, 0x74, 0x0A, 0xFA, 0x81, 0xE7, 0x17,
  0x77, 0x20, 0x10, 0xEF, 0xB8, 0x1E, 0x82, 0x77, 0x71, 0x03, 0x0E, 0xFD, 0x0B, 0x04, 0x77, 0x70,
  0x30, 0xEF, 0xE8, 0x1D, 0x82, 0x77, 0x50, 0x10, 0xBF, 0xF9, 0x0B, 0x04, 0x77, 0x50, 0x9F, 0xFA,
  0x0C, 0x04, 0x77, 0x10, 0x20, 0xBF, 0xFD, 0x0B, 0x02, 0x75, 0x04, 0x0E, 0xFF, 0xF9, 0x08, 0x73,
  0x05, 0xF8, 0x3E, 0x73, 0x6B, 0xFE, 0x0C, 0x01, 0x70, 0x3F, 0x08, 0x58, 0x11, 0x7C, 0xFC, 0x0D,
  0x01, 0x60, 0xDE, 0x05, 0x72, 0x03, 0x0A, 0xFB, 0x0D, 0x50, 0x7E, 0x06, 0x75, 0x02, 0x0A, 0xFA,
  0x08, 0x40, 0xDD, 0x0B, 0x77, 0x10, 0x40, 0xEF, 0x90, 0x22, 0x02, 0xE0, 0x47, 0x72, 0x01, 0x0C,
  0xF0, 0x72, 0x05, 0xE7, 0x74, 0x01, 0x0D, 0xE0, 0xC2, 0x06, 0xD0, 0xE7, 0x75, 0x05, 0xE0, 0xE2,
  0x07, 0xE7, 0x76, 0x0D, 0xE2, 0x06, 0xE0, 0x27, 0x75, 0x09, 0xE8, 0x11, 0x04, 0xE0, 0x87, 0x75,
  0x07, 0xE2, 0x01, 0xE0, 0xE0, 0x27, 0x74, 0x08, 0xD0, 0xE3, 0x0C, 0xE0, 0xC0, 0x17, 0x73, 0x0A,
  0xD0, 0xB3, 0x05, 0xF0, 0xD0, 0x27, 0x72, 0x0E, 0xD0, 0x74, 0x0B, 0xF9, 0x07, 0x77, 0x06, 0xE0,
  0x14, 0x01, 0x0E, 0xF9, 0x0D, 0x06, 0x74, 0x02, 0x0E, 0xD0, 0x86, 0x02, 0x0D, 0xFA, 0x0D, 0x06,
  0x71, 0x03, 0x0E, 0xD0, 0xD0, 0x17, 0x01, 0x0B, 0xFB, 0x81, 0xE9, 0x24, 0x04, 0x0E, 0xD0, 0xE0,
  0x37, 0x30, 0x60, 0xEF, 0xC8, 0x2C, 0x61, 0x9F, 0x04, 0x75, 0x81, 0x18, 0xEF, 0xFC, 0x0E, 0x03,
  0x77, 0x18, 0x11, 0x7E, 0xFF, 0x90, 0xA0, 0x17, 0x75, 0x05, 0x0C, 0xFE, 0x0D, 0x05, 0x77, 0x78,
  0x12, 0x8E, 0xFD, 0x09, 0x77, 0x72, 0x05, 0x0B, 0xFC, 0x0B, 0x77, 0x73, 0x02, 0x0A, 0xFB, 0x0A,
  0x77, 0x74, 0x02, 0x0A, 0xFA, 0x06, 0x77, 0x75, 0x05, 0x0E, 0xF0, 0xE7, 0x77, 0x60, 0x20, 0xDF,
  0x05, 0x77, 0x76, 0x03, 0xF0, 0xA7, 0x77, 0x70, 0xCE, 0x0D, 0x77, 0x77, 0x08, 0xE0, 0xE7, 0x77,
  0x70, 0x6F, 0x77, 0x77, 0x07, 0xE0, 0xE7, 0x77, 0x70, 0xCE, 0x82, 0xC0, 0x26, 0x77, 0x73, 0x06,
  0xF8, 0x59, 0x02, 0xFE, 0x94, 0x77, 0x60, 0x5F, 0x98, 0x14, 0x02, 0xC8, 0x1E, 0x94, 0x77, 0x10,
  0x10, 0x9F, 0x90, 0xC2, 0x02, 0xF9, 0x83, 0xC8, 0x63, 0x24, 0x83, 0x12, 0x57, 0xCF, 0xB0, 0x32,
  0x02, 0xFF, 0xFF, 0xB0, 0x73, 0x02, 0xFF, 0xFF, 0xA0, 0x74, 0x02, 0xFF, 0xFF, 0x0E, 0x04, 0x60,
  0x40, 0xAF, 0xFF, 0xB0, 0xE0, 0x87, 0x38, 0x12, 0x7B, 0xFF, 0xD0, 0xB0, 0x67, 0x72, 0x85, 0x47,
  0x9B, 0xCD, 0xEC, 0x84, 0xED, 0xB9, 0x73, 0x75,
  // "¨" (U+00A8)
  0x28, 0x51, 0x8D, 0xFE, 0xB4, 0x77, 0x85, 0x3A, 0xEF, 0xD9, 0x13, 0x02, 0x0D, 0xE0, 0x87, 0x50,
  0x6E, 0x0E, 0x03, 0x20, 0xAF, 0x90, 0x37, 0x30, 0x1F, 0x90, 0xC2, 0x0E, 0xF9, 0x08, 0x73, 0x05,
  0xFA, 0x02, 0x01, 0xFA, 0x0A, 0x73, 0x07, 0xFA, 0x04, 0x01, 0xFA, 0x09, 0x73, 0x07, 0xFA, 0x81,
  0x30, 0xEF, 0x90, 0x77, 0x30, 0x5F, 0xA8, 0x11, 0x09, 0xF9, 0x02, 0x74, 0x0E, 0xF0, 0xB2, 0x01,
  0x0C, 0xE0, 0x67, 0x50, 0x4E, 0x0D, 0x02, 0x48, 0x47, 0xDF, 0xEA, 0x37, 0x78, 0x52, 0xAE, 0xFD,
  0x81, 0x20,
  // "©" (U+00A9)
  0x77, 0x28, 0x95, 0x36, 0x9B, 0xDE, 0xEF, 0xED, 0xCA, 0x74, 0x17, 0x77, 0x78, 0x14, 0x9E, 0xFF,
  0x90, 0xB0, 0x67, 0x77, 0x30, 0x50, 0xCF, 0xFE, 0x81, 0xE7, 0x17, 0x75, 0x02, 0x0C, 0xFF, 0xFB,
  0x0E, 0x05, 0x77, 0x30, 0x7F, 0x83, 0xEA, 0x63, 0x23, 0x84, 0x12, 0x47, 0xAE, 0xF0, 0xA7, 0x71,
  0x09, 0xE0, 0xA0, 0x47, 0x70, 0x50, 0xCE, 0x0C, 0x01, 0x75, 0x0B, 0xD0, 0xB0, 0x37, 0x74, 0x04,
  0x0D, 0xD0, 0xD0, 0x17, 0x30, 0xAD, 0x07, 0x77, 0x71, 0x09, 0xD0, 0xB7, 0x20, 0x7C, 0x0E, 0x04,
  0x77, 0x73, 0x07, 0xD0, 0x97, 0x03, 0xD0, 0x47, 0x28, 0x90, 0x48, 0xCD, 0xEE, 0xDC, 0x85, 0x70,
  0x6D, 0x04, 0x60, 0xCC, 0x06, 0x71, 0x06, 0x0E, 0xFB, 0x81, 0xE9, 0x25, 0x09, 0xC0, 0xD5, 0x06,
  0xC0, 0xA7, 0x01, 0x0C, 0xFF, 0x0B, 0x60, 0xCC, 0x07, 0x40, 0xDB, 0x0E, 0x01, 0x60, 0x10, 0xDF,
  0xF9, 0x05, 0x60, 0x3C, 0x0D, 0x30, 0x5C, 0x08, 0x70, 0xCF, 0xF9, 0x0D, 0x71, 0x0A, 0xC0, 0x52,
  0x0A, 0xC0, 0x16, 0x07, 0xE8, 0x1C, 0x62, 0x28, 0x41, 0x49, 0xEF, 0x77, 0x10, 0x3C, 0x0B, 0x20,
  0xEB, 0x0B, 0x60, 0x1E, 0x07, 0x72, 0x06, 0x01, 0x72, 0x0C, 0xC1, 0x04, 0xC0, 0x66, 0x07, 0xD0,
  0x77, 0x77, 0x08, 0xC0, 0x40, 0x7C, 0x03, 0x60, 0xEC, 0x0B, 0x77, 0x71, 0x04, 0xC0, 0x70, 0xAC,
  0x60, 0x2D, 0x04, 0x77, 0x72, 0xC0, 0xA0, 0xCB, 0x0D, 0x60, 0x6C, 0x0E, 0x77, 0x73, 0x0D, 0xB0,
  0xD0, 0xEB, 0x0B, 0x60, 0x9C, 0x0B, 0x77, 0x73, 0x0C, 0xB0, 0x0E, 0xB0, 0xA6, 0x0A, 0xC0, 0x87,
  0x77, 0x30, 0xAF, 0x90, 0xA6, 0x0B, 0xC0, 0x77, 0x77, 0x30, 0xAF, 0x90, 0xA6, 0x0C, 0xC0, 0x77,
  0x77, 0x30, 0xAF, 0x90, 0xB6, 0x0B, 0xC0, 0x77, 0x77, 0x30, 0xAB, 0x00, 0xEB, 0x0C, 0x60, 0xAC,
  0x08, 0x77, 0x73, 0x0B, 0xB0, 0xE0, 0xDB, 0x0E, 0x60, 0x8C, 0x0A, 0x77, 0x73, 0x0D, 0xB0, 0xC0,
  0xAC, 0x01, 0x50, 0x4C, 0x0D, 0x77, 0x73, 0xC0, 0xA0, 0x8C, 0x04, 0x50, 0x1D, 0x03, 0x77, 0x71,
  0x03, 0xC0, 0x70, 0x5C, 0x09, 0x60, 0xBC, 0x09, 0x77, 0x71, 0x07, 0xC0, 0x40, 0x1C, 0x0D, 0x60,
  0x4D, 0x04, 0x77, 0x70, 0xBB, 0x0E, 0x20, 0xBC, 0x04, 0x60, 0xBC, 0x0E, 0x04, 0x73, 0x02, 0x71,
  0x02, 0xC0, 0xA2, 0x06, 0xC0, 0xB6, 0x02, 0x0E, 0xD8, 0x1A, 0x51, 0x28, 0x41, 0x36, 0x9D, 0xB7,
  0x10, 0x8C, 0x05, 0x30, 0xEC, 0x04, 0x60, 0x5F, 0xF9, 0x0B, 0x70, 0x1C, 0x0D, 0x40, 0x8C, 0x0D,
  0x70, 0x40, 0xEF, 0xE0, 0xB7, 0x0A, 0xC0, 0x64, 0x01, 0x0E, 0xC0, 0x97, 0x01, 0x09, 0xFD, 0x0A,
  0x60, 0x6C, 0x0D, 0x60, 0x5D, 0x07, 0x71, 0x89, 0x21, 0x59, 0xCD, 0xEF, 0xED, 0xA6, 0x26, 0x04,
  0xD0, 0x37, 0x0A, 0xD0, 0x77, 0x77, 0x30, 0x5D, 0x08, 0x72, 0x0C, 0xD0, 0xA0, 0x17, 0x77, 0x08,
  0xD0, 0xA7, 0x30, 0x10, 0xDD, 0x0D, 0x05, 0x77, 0x40, 0x30, 0xCD, 0x0C, 0x75, 0x01, 0x0C, 0xE0,
  0xC0, 0x57, 0x70, 0x40, 0xBE, 0x0A, 0x77, 0x10, 0xAF, 0x98, 0x3A, 0x74, 0x21, 0x38, 0x32, 0x46,
  0xAE, 0xF0, 0x87, 0x73, 0x05, 0x0E, 0xFF, 0xFB, 0x0D, 0x03, 0x77, 0x58, 0x11, 0x7E, 0xFF, 0xE0,
  0xD0, 0x67, 0x77, 0x30, 0x60, 0xBF, 0xF9, 0x81, 0xEA, 0x57, 0x77, 0x71, 0x84, 0x47, 0xAC, 0xDE,
  0xA8, 0x4E, 0xDC, 0x97, 0x47, 0x72,
  // "ª" (U+00AA)
  0x78, 0x93, 0x25, 0x8B, 0xDE, 0xFE, 0xED, 0xA7, 0x27, 0x38, 0x12, 0x7C, 0xFE, 0x0C, 0x04, 0x60,
  0x20, 0xAF, 0xFC, 0x09, 0x50, 0x3F, 0xFE, 0x09, 0x50, 0xCF, 0xFE, 0x03, 0x40, 0x5C, 0x83, 0xB7,
  0x42, 0x12, 0x81, 0x36, 0xCE, 0x0B, 0x58, 0x2D, 0xD6, 0x17, 0x30, 0x7E, 0x50, 0x17, 0x70, 0xAD,
  0x04, 0x77, 0x50, 0x4D, 0x06, 0x77, 0x50, 0x1D, 0x07, 0x77, 0x50, 0x1D, 0x08, 0x77, 0x50, 0x1D,
  0x08, 0x78, 0x51, 0x68, 0xBD, 0xDE, 0xFC, 0x08, 0x50, 0x60, 0xCF, 0xFC, 0x08, 0x30, 0x30, 0xDF,
  0xFE, 0x08, 0x20, 0x30, 0xEF, 0xC8, 0x01, 0xED, 0x82, 0x80, 0x1D, 0xE8, 0x2B, 0x63, 0x16, 0x01,
  0xD8, 0x18, 0x08, 0xD0, 0xD0, 0x37, 0x30, 0x1D, 0x81, 0x80, 0xDD, 0x02, 0x74, 0x01, 0xD0, 0x80,
  0x1D, 0x0A, 0x75, 0x03, 0xD0, 0x80, 0x3D, 0x07, 0x75, 0x07, 0xD0, 0x80, 0x4D, 0x07, 0x75, 0x0E,
  0xD0, 0x80, 0x3D, 0x0A, 0x74, 0x09, 0xE0, 0x80, 0x1E, 0x03, 0x72, 0x09, 0xF8, 0x18, 0x0D, 0xE8,
  0x18, 0x31, 0x28, 0x21, 0x48, 0xEF, 0x98, 0x18, 0x07, 0xFF, 0xB0, 0xD0, 0xCC, 0x08, 0x20, 0xDF,
  0xF9, 0x81, 0xC1, 0x7C, 0x08, 0x20, 0x20, 0xEF, 0xE8, 0x2A, 0x10, 0x3C, 0x08, 0x30, 0x10, 0xAF,
  0xB0, 0xD0, 0x44, 0x0E, 0xB0, 0x85, 0x82, 0x28, 0xBE, 0xA8, 0x2E, 0xC8, 0x46, 0x83, 0x46, 0x66,
  0x30,
  // "«" (U+00AB)
  0x77, 0x03, 0x08, 0x77, 0x20, 0x70, 0x47, 0x73, 0x83, 0x1D, 0xFC, 0x27, 0x60, 0x5A, 0x09, 0x77,
  0x20, 0xBB, 0x0E, 0x05, 0x74, 0x03, 0x0E, 0xB0, 0xC0, 0x27, 0x60, 0x9E, 0x09, 0x72, 0x01, 0x0D,
  0xD0, 0xE0, 0x67, 0x40, 0x6F, 0x0E, 0x02, 0x71, 0x0C, 0xF0, 0x87, 0x30, 0x3F, 0x90, 0x47, 0x10,
  0x9F, 0x0B, 0x73, 0x01, 0x0E, 0xF0, 0x77, 0x10, 0x7F, 0x0D, 0x01, 0x73, 0x0C, 0xF0, 0xA7, 0x10,
  0x4F, 0x0E, 0x02, 0x73, 0x0A, 0xF0, 0xC7, 0x10, 0x20, 0xEF, 0x05, 0x73, 0x07, 0xF0, 0xE0, 0x27,
  0x01, 0x0D, 0xF0, 0x87, 0x30, 0x4F, 0x90, 0x47, 0x10, 0xBF, 0x0B, 0x73, 0x02, 0x0E, 0xF0, 0x77,
  0x10, 0x9F, 0x0D, 0x01, 0x72, 0x01, 0x0D, 0xF0, 0xA7, 0x10, 0x6F, 0x0E, 0x02, 0x73, 0x0B, 0xF0,
  0xC7, 0x10, 0x4F, 0x90, 0x57, 0x30, 0x8F, 0x0E, 0x01, 0x70, 0x20, 0xEF, 0x08, 0x73, 0x05, 0xF9,
  0x03, 0x71, 0x0D, 0xF0, 0xB7, 0x30, 0x3F, 0x90, 0x67, 0x10, 0xBF, 0x0D, 0x01, 0x72, 0x01, 0x0D,
  0xF0, 0x97, 0x10, 0x8F, 0x0E, 0x02, 0x73, 0x0C, 0xF0, 0xB7, 0x10, 0x5F, 0x90, 0x57, 0x4F, 0x90,
  0x77, 0x10, 0x8F, 0x0E, 0x01, 0x74, 0x07, 0xF9, 0x03, 0x70, 0x10, 0xDF, 0x0B, 0x75, 0x0A, 0xF0,
  0xD0, 0x17, 0x03, 0x0E, 0xF0, 0x87, 0x50, 0xCF, 0x0B, 0x71, 0x05, 0xF9, 0x05, 0x74, 0x01, 0x0D,
  0xF0, 0x87, 0x10, 0x8F, 0x0E, 0x02, 0x74, 0x03, 0xF9, 0x05, 0x71, 0x0A, 0xF0, 0xD0, 0x17, 0x40,
  0x5F, 0x0E, 0x02, 0x71, 0x0C, 0xF0, 0xB7, 0x50, 0x8F, 0x0D, 0x01, 0x70, 0x10, 0xEF, 0x08, 0x75,
  0x0A, 0xF0, 0xA7, 0x10, 0x3F, 0x90, 0x57, 0x50, 0xCF, 0x07, 0x71, 0x05, 0xF0, 0xE0, 0x27, 0x40,
  0x20, 0xEF, 0x04, 0x71, 0x08, 0xF0, 0xD7, 0x50, 0x4F, 0x0E, 0x02, 0x71, 0x0A, 0xF0, 0xA7, 0x50,
  0x6F, 0x0C, 0x72, 0x0C, 0xF0, 0x77, 0x50, 0x9F, 0x0A, 0x71, 0x02, 0x0E, 0xF0, 0x47, 0x50, 0xBF,
  0x06, 0x71, 0x03, 0xF0, 0xE0, 0x27, 0x40, 0x10, 0xDF, 0x01, 0x71, 0x06, 0xF0, 0xB7, 0x50, 0x20,
  0xEC, 0x0D, 0x03, 0x73, 0x08, 0xD0, 0xA0, 0x17, 0x60, 0x4B, 0x09, 0x76, 0x0B, 0xA0, 0xE0, 0x57,
  0x72, 0x81, 0x7D, 0x47, 0x78, 0x21, 0xDC, 0x27, 0x77, 0x77, 0x01, 0x50,
  // "¬" (U+00AC)
  0x02, 0x80, 0xC3, 0x80, 0x20, 0x38, 0x0C, 0x3F, 0x05, 0x03, 0x80, 0xC3, 0xF0, 0x50, 0x38, 0x0C,
  0x3F, 0x05, 0x03, 0x80, 0xC3, 0xF0, 0x50, 0x38, 0x0C, 0x3F, 0x05, 0x03, 0x80, 0xC3, 0xF0, 0x57,
  0x77, 0x76, 0xE0, 0x57, 0x77, 0x76, 0xE0, 0x57, 0x77, 0x76, 0xE0, 0x57, 0x77, 0x76, 0xE0, 0x57,
  0x77, 0x76, 0xE0, 0x57, 0x77, 0x76, 0xE0, 0x57, 0x77, 0x76, 0xE0, 0x57, 0x77, 0x76, 0xE0, 0x57,
  0x77, 0x76, 0xE0, 0x57, 0x77, 0x76, 0xE0, 0x57, 0x77, 0x76, 0xE0, 0x57, 0x77, 0x76, 0xE0, 0x57,
  0x77, 0x76, 0xE0, 0x57, 0x77, 0x76, 0xE0, 0x57, 0x77, 0x76, 0xE0, 0x57, 0x77, 0x76, 0xE0, 0x57,
  0x77, 0x76, 0xE0, 0x50,
  // "®" (U+00AE)
  0x77, 0x28, 0x95, 0x36, 0x9B, 0xDE, 0xEF, 0xED, 0xCA, 0x74, 0x17, 0x77, 0x78, 0x14, 0x9E, 0xFF,
  0x90, 0xB0, 0x67, 0x77, 0x30, 0x50, 0xCF, 0xFE, 0x81, 0xE7, 0x17, 0x75, 0x02, 0x0C, 0xFF, 0xFB,
  0x0E, 0x05, 0x77, 0x30, 0x7F, 0x83, 0xEA, 0x63, 0x23, 0x84, 0x12, 0x47, 0xAE, 0xF0, 0xA7, 0x71,
  0x09, 0xE0, 0xA0, 0x47, 0x70, 0x50, 0xCE, 0x0C, 0x01, 0x75, 0x0B, 0xD0, 0xB0, 0x37, 0x74, 0x04,
  0x0D, 0xD0, 0xD0, 0x17, 0x30, 0xAD, 0x07, 0x77, 0x71, 0x09, 0xD0, 0xB7, 0x20, 0x7C, 0x0E, 0x04,
  0x77, 0x73, 0x07, 0xD0, 0x97, 0x03, 0xD0, 0x44, 0x01, 0xF9, 0x83, 0xED, 0xC9, 0x57, 0x10, 0x6D,
  0x04, 0x60, 0xCC, 0x06, 0x50, 0x1F, 0xE0, 0xE0, 0x57, 0x09, 0xC0, 0xD5, 0x06, 0xC0, 0xA6, 0x01,
  0xFF, 0x90, 0x87, 0x0C, 0xC0, 0x74, 0x0D, 0xB0, 0xE0, 0x16, 0x01, 0xFF, 0xA0, 0x66, 0x03, 0xC0,
  0xD3, 0x05, 0xC0, 0x87, 0x01, 0xC0, 0x74, 0x81, 0x37, 0xEC, 0x0E, 0x70, 0xAC, 0x05, 0x20, 0xAC,
  0x01, 0x70, 0x1C, 0x07, 0x60, 0x10, 0xDC, 0x05, 0x60, 0x3C, 0x0B, 0x20, 0xEB, 0x0B, 0x71, 0x01,
  0xC0, 0x77, 0x04, 0xC0, 0x87, 0x0C, 0xC1, 0x04, 0xC0, 0x67, 0x10, 0x1C, 0x07, 0x71, 0xC0, 0xA7,
  0x08, 0xC0, 0x40, 0x7C, 0x03, 0x71, 0x01, 0xC0, 0x77, 0x1C, 0x0A, 0x70, 0x4C, 0x07, 0x0A, 0xC7,
  0x20, 0x1C, 0x07, 0x70, 0x1C, 0x09, 0x71, 0xC0, 0xA0, 0xCB, 0x0D, 0x72, 0x01, 0xC0, 0x77, 0x06,
  0xC0, 0x67, 0x10, 0xDB, 0x0D, 0x0E, 0xB0, 0xB7, 0x20, 0x1C, 0x07, 0x60, 0x20, 0xEC, 0x02, 0x71,
  0x0C, 0xB0, 0x0E, 0xB0, 0xA7, 0x20, 0x1C, 0x07, 0x40, 0x30, 0x8D, 0x09, 0x72, 0x0A, 0xF9, 0x0A,
  0x72, 0x01, 0xFF, 0x90, 0xC0, 0x17, 0x20, 0xAF, 0x90, 0xA7, 0x20, 0x1F, 0xF0, 0xC0, 0x17, 0x30,
  0xAF, 0x90, 0xB7, 0x20, 0x1F, 0xD0, 0xE0, 0x77, 0x50, 0xAB, 0x00, 0xEB, 0x0C, 0x72, 0x01, 0xFE,
  0x03, 0x75, 0x0B, 0xB0, 0xE0, 0xDB, 0x0E, 0x72, 0x01, 0xC0, 0x73, 0x05, 0xC0, 0xC7, 0x50, 0xDB,
  0x0C, 0x0A, 0xC0, 0x17, 0x10, 0x1C, 0x07, 0x40, 0xCC, 0x06, 0x74, 0xC0, 0xA0, 0x8C, 0x04, 0x71,
  0x01, 0xC0, 0x74, 0x03, 0xC0, 0xE0, 0x17, 0x20, 0x3C, 0x07, 0x05, 0xC0, 0x97, 0x10, 0x1C, 0x07,
  0x50, 0xAC, 0x09, 0x72, 0x07, 0xC0, 0x40, 0x1C, 0x0D, 0x71, 0x01, 0xC0, 0x75, 0x01, 0x0E, 0xC0,
  0x37, 0x10, 0xBB, 0x0E, 0x20, 0xBC, 0x04, 0x70, 0x1C, 0x07, 0x60, 0x7C, 0x0C, 0x70, 0x2C, 0x0A,
  0x20, 0x6C, 0x0B, 0x70, 0x1C, 0x07, 0x70, 0xDC, 0x06, 0x60, 0x8C, 0x05, 0x30, 0xEC, 0x04, 0x60,
  0x1C, 0x07, 0x70, 0x5C, 0x0E, 0x01, 0x40, 0x1C, 0x0D, 0x40, 0x8C, 0x0D, 0x60, 0x1C, 0x07, 0x71,
  0x0C, 0xC0, 0x94, 0x0A, 0xC0, 0x64, 0x01, 0x0E, 0xC0, 0x95, 0x01, 0xC0, 0x77, 0x10, 0x3D, 0x03,
  0x20, 0x6C, 0x0D, 0x60, 0x5D, 0x07, 0x48, 0x41, 0xDD, 0xDD, 0x67, 0x28, 0x69, 0xDD, 0xDD, 0xA0,
  0x4D, 0x03, 0x70, 0xAD, 0x07, 0x77, 0x73, 0x05, 0xD0, 0x87, 0x20, 0xCD, 0x0A, 0x01, 0x77, 0x70,
  0x8D, 0x0A, 0x73, 0x01, 0x0D, 0xD0, 0xD0, 0x57, 0x74, 0x03, 0x0C, 0xD0, 0xC7, 0x50, 0x10, 0xCE,
  0x0C, 0x05, 0x77, 0x04, 0x0B, 0xE0, 0xA7, 0x71, 0x0A, 0xF9, 0x83, 0xA7, 0x42, 0x13, 0x83, 0x24,
  0x6A, 0xEF, 0x08, 0x77, 0x30, 0x50, 0xEF, 0xFF, 0xB0, 0xD0, 0x37, 0x75, 0x81, 0x17, 0xEF, 0xFE,
  0x0D, 0x06, 0x77, 0x73, 0x06, 0x0B, 0xFF, 0x98, 0x1E, 0xA5, 0x77, 0x77, 0x18, 0x44, 0x7A, 0xCD,
  0xEA, 0x84, 0xED, 0xC9, 0x74, 0x77, 0x20,
  // "¯" (U+00AF)
  0x02, 0x80, 0xA6, 0x80, 0x30, 0x4F, 0xFF, 0xD0, 0x60, 0x4F, 0xFF, 0xD0, 0x60, 0x4F, 0xFF, 0xD0,
  0x60, 0x4F, 0xFF, 0xD0, 0x60, 0x4F, 0xFF, 0xD0, 0x60, 0x4F, 0xFF, 0xD0, 0x60,
  // "°" (U+00B0)
  0x72, 0x89, 0x03, 0x8B, 0xDE, 0xFE, 0xC9, 0x47, 0x72, 0x06, 0x0D, 0xFB, 0x0D, 0x06, 0x75, 0x02,
  0x0C, 0xFF, 0x0C, 0x02, 0x72, 0x04, 0x0E, 0xFF, 0xA0, 0xE0, 0x47, 0x03, 0xFF, 0xE0, 0x35, 0x01,
  0x0E, 0xE8, 0x1B, 0x62, 0x28, 0x11, 0x5A, 0xE0, 0xE0, 0x14, 0x0A, 0xD0, 0xE0, 0x47, 0x10, 0x30,
  0xDD, 0x0A, 0x30, 0x3D, 0x0D, 0x01, 0x73, 0x01, 0x0D, 0xD0, 0x32, 0x0A, 0xD0, 0x37, 0x50, 0x2D,
  0x0A, 0x20, 0xEC, 0x0A, 0x77, 0x09, 0xC8, 0x1E, 0x04, 0xD0, 0x57, 0x70, 0x3D, 0x03, 0x06, 0xD0,
  0x17, 0x71, 0xD0, 0x60, 0x8D, 0x77, 0x20, 0xDC, 0x00, 0x8C, 0x0E, 0x77, 0x20, 0xCC, 0x00, 0x8D,
  0x77, 0x20, 0xDC, 0x08, 0x06, 0xD0, 0x17, 0x71, 0xD0, 0x70, 0x4D, 0x05, 0x77, 0x03, 0xD0, 0x41,
  0xD0, 0xC7, 0x70, 0x9D, 0x81, 0x10, 0xBD, 0x05, 0x75, 0x02, 0xD0, 0xB2, 0x04, 0xE0, 0x47, 0x30,
  0x10, 0xDD, 0x04, 0x30, 0xBE, 0x06, 0x71, 0x03, 0x0D, 0xD0, 0xC4, 0x02, 0x0E, 0xE8, 0x1D, 0x72,
  0x28, 0x11, 0x5A, 0xF0, 0x25, 0x05, 0xFF, 0xE0, 0x57, 0x05, 0xFF, 0xC0, 0x67, 0x20, 0x30, 0xEF,
  0xF0, 0xD0, 0x47, 0x50, 0x70, 0xEF, 0xB0, 0xE0, 0x87, 0x72, 0x89, 0x04, 0x8C, 0xDE, 0xFE, 0xC9,
  0x57, 0x20,
  // "±" (U+00B1)
  0x77, 0x30, 0x6E, 0x01, 0x77, 0x77, 0x50, 0x6E, 0x01, 0x77, 0x77, 0x50, 0x6E, 0x01, 0x77, 0x77,
  0x50, 0x6E, 0x01, 0x77, 0x77, 0x50, 0x6E, 0x01, 0x77, 0x77, 0x50, 0x6E, 0x01, 0x77, 0x77, 0x50,
  0x6E, 0x01, 0x77, 0x77, 0x50, 0x6E, 0x01, 0x77, 0x77, 0x50, 0x6E, 0x01, 0x77, 0x77, 0x50, 0x6E,
  0x01, 0x77, 0x77, 0x50, 0x6E, 0x01, 0x77, 0x77, 0x50, 0x6E, 0x01, 0x77, 0x77, 0x50, 0x6E, 0x01,
  0x77, 0x77, 0x50, 0x6E, 0x01, 0x77, 0x77, 0x50, 0x6E, 0x01, 0x77, 0x77, 0x50, 0x6E, 0x01, 0x77,
  0x77, 0x50, 0x6E, 0x01, 0x77, 0x77, 0x50, 0x6E, 0x01, 0x77, 0x20, 0x28, 0x0C, 0x3F, 0x0C, 0x02,
  0x80, 0xC3, 0xF0, 0xC0, 0x28, 0x0C, 0x3F, 0x0C, 0x02, 0x80, 0xC3, 0xF0, 0xC0, 0x28, 0x0C, 0x3F,
  0x0C, 0x02, 0x80, 0xC3, 0xF0, 0xC0, 0x18, 0x09, 0x48, 0x0B, 0xE8, 0x09, 0x48, 0x06, 0x77, 0x30,
  0x6E, 0x01, 0x77, 0x77, 0x50, 0x6E, 0x01, 0x77, 0x77, 0x50, 0x6E, 0x01, 0x77, 0x77, 0x50, 0x6E,
  0x01, 0x77, 0x77, 0x50, 0x6E, 0x01, 0x77, 0x77, 0x50, 0x6E, 0x01, 0x77, 0x77, 0x50, 0x6E, 0x01,
  0x77, 0x77, 0x50, 0x6E, 0x01, 0x77, 0x77, 0x50, 0x6E, 0x01, 0x77, 0x77, 0x50, 0x6E, 0x01, 0x77,
  0x77, 0x50, 0x6E, 0x01, 0x77, 0x77, 0x50, 0x6E, 0x01, 0x77, 0x77, 0x50, 0x6E, 0x01, 0x77, 0x77,
  0x50, 0x6E, 0x01, 0x77, 0x77, 0x50, 0x6E, 0x01, 0x77, 0x77, 0x50, 0x6E, 0x01, 0x77, 0x77, 0x50,
  0x6E, 0x01, 0x80, 0xAE, 0x10, 0x06, 0x80, 0xC2, 0x88, 0x16, 0x0C, 0x80, 0xC2, 0xF8, 0x1C, 0x0C,
  0x80, 0xC2, 0xF8, 0x1C, 0x0C, 0x80, 0xC2, 0xF8, 0x1C, 0x0C, 0x80, 0xC2, 0xF8, 0x1C, 0x0C, 0x80,
  0xC2, 0xF8, 0x1C, 0x0C, 0x80, 0xC2, 0xF0, 0xC0,
  // "²" (U+00B2)
  0x73, 0x84, 0x13, 0x44, 0x32, 0x77, 0x38, 0x21, 0x7B, 0xEF, 0x81, 0xC7, 0x17, 0x40, 0x10, 0x9F,
  0xF0, 0x90, 0x17, 0x10, 0x80, 0xEF, 0xFA, 0x0D, 0x03, 0x50, 0x20, 0xCF, 0xFD, 0x0E, 0x03, 0x30,
  0x40, 0xEF, 0xFF, 0x0D, 0x30, 0x10, 0xEE, 0x82, 0xD8, 0x41, 0x28, 0x12, 0x5B, 0xF0, 0x73, 0x04,
  0xC0, 0xE0, 0x67, 0x20, 0x5E, 0x0E, 0x40, 0x8A, 0x09, 0x75, 0x06, 0xE0, 0x34, 0x0B, 0x05, 0x77,
  0x0D, 0xD0, 0x67, 0x76, 0x0A, 0xD0, 0x77, 0x76, 0x08, 0xD0, 0x87, 0x76, 0x09, 0xD0, 0x87, 0x76,
  0x0A, 0xD0, 0x67, 0x76, 0x0E, 0xD0, 0x37, 0x75, 0x03, 0xD0, 0xE7, 0x76, 0x0B, 0xD0, 0x87, 0x75,
  0x05, 0xD0, 0xE0, 0x17, 0x74, 0x02, 0x0E, 0xD0, 0x77, 0x74, 0x01, 0x0D, 0xD0, 0xC7, 0x74, 0x01,
  0x0C, 0xD0, 0xE0, 0x17, 0x73, 0x01, 0x0C, 0xE0, 0x37, 0x74, 0x0C, 0xE0, 0x47, 0x73, 0x01, 0x0C,
  0xE0, 0x57, 0x73, 0x01, 0x0C, 0xE0, 0x57, 0x73, 0x01, 0x0C, 0xE0, 0x57, 0x73, 0x01, 0x0C, 0xE0,
  0x57, 0x73, 0x01, 0x0D, 0xE0, 0x47, 0x73, 0x01, 0x0D, 0xD0, 0xE0, 0x47, 0x73, 0x01, 0x0D, 0xD0,
  0xE0, 0x37, 0x73, 0x02, 0x0D, 0xD0, 0xE0, 0x37, 0x73, 0x02, 0x0D, 0xD0, 0xE0, 0x27, 0x73, 0x02,
  0x0D, 0xD0, 0xD0, 0x27, 0x73, 0x02, 0x0E, 0xD0, 0xD0, 0x27, 0x73, 0x02, 0x0E, 0xE0, 0x68, 0x09,
  0x64, 0x0E, 0xFF, 0xFC, 0x0E, 0xFF, 0xFD, 0x0E, 0xFF, 0xFD, 0x0E, 0xFF, 0xFD, 0x0E, 0xFF, 0xFD,
  0x0E,
  // "³" (U+00B3)
  0x78, 0x92, 0x59, 0xBD, 0xEF, 0xED, 0xC9, 0x61, 0x74, 0x02, 0x09, 0xFE, 0x0A, 0x02, 0x70, 0x10,
  0x9F, 0xFB, 0x06, 0x50, 0x50, 0xEF, 0xFD, 0x07, 0x30, 0x8F, 0xFF, 0x90, 0x42, 0x02, 0x0E, 0xF8,
  0x5B, 0x86, 0x56, 0x8D, 0xF0, 0xD3, 0x05, 0xC8, 0x1E, 0x71, 0x70, 0x6F, 0x04, 0x38, 0x28, 0xFE,
  0x67, 0x40, 0x6E, 0x08, 0x40, 0x70, 0x17, 0x60, 0xED, 0x0B, 0x77, 0x50, 0xAD, 0x0C, 0x77, 0x50,
  0x9D, 0x0D, 0x77, 0x50, 0xAD, 0x0B, 0x77, 0x50, 0xDD, 0x09, 0x77, 0x40, 0x5E, 0x05, 0x77, 0x30,
  0x20, 0xED, 0x0E, 0x77, 0x30, 0x50, 0xEE, 0x05, 0x78, 0x01, 0x48, 0x35, 0x57, 0xAE, 0xF0, 0x87,
  0x10, 0xCF, 0xF9, 0x08, 0x72, 0x0C, 0xFE, 0x0C, 0x04, 0x73, 0x0C, 0xFE, 0x08, 0x03, 0x73, 0x0C,
  0xFF, 0x90, 0xC0, 0x37, 0x10, 0xCF, 0xFB, 0x05, 0x77, 0x82, 0x14, 0x7B, 0xF9, 0x04, 0x77, 0x30,
  0x20, 0xBE, 0x0D, 0x77, 0x50, 0xAE, 0x05, 0x77, 0x40, 0x10, 0xED, 0x0A, 0x77, 0x50, 0xAD, 0x0D,
  0x77, 0x50, 0x7E, 0x77, 0x50, 0x7E, 0x77, 0x50, 0x8D, 0x0E, 0x77, 0x50, 0xDD, 0x0D, 0x01, 0x77,
  0x30, 0x4E, 0x82, 0x9F, 0x93, 0x77, 0x02, 0x0E, 0xE0, 0x4B, 0x81, 0xD8, 0x37, 0x30, 0x50, 0xEE,
  0x0C, 0x1E, 0x89, 0x0E, 0xB8, 0x65, 0x55, 0x7A, 0xEF, 0x90, 0x41, 0xFF, 0xFA, 0x07, 0x2F, 0xFF,
  0x90, 0x93, 0x0A, 0xFF, 0xD0, 0xE0, 0x65, 0x81, 0x18, 0xDF, 0xF8, 0x1E, 0x81, 0x72, 0x84, 0x26,
  0x9B, 0xDE, 0xA8, 0x4E, 0xDC, 0xA7, 0x37, 0x10,
  // "´" (U+00B4)
  0x71, 0x03, 0x80, 0x57, 0x01, 0x71, 0x0C, 0xFA, 0x02, 0x70, 0x5F, 0xA0, 0x87, 0x10, 0xDF, 0x90,
  0xB7, 0x10, 0x8F, 0x90, 0xD0, 0x17, 0x02, 0xF9, 0x0E, 0x02, 0x71, 0x0C, 0xF0, 0xE0, 0x37, 0x10,
  0x6F, 0x90, 0x47, 0x10, 0x10, 0xEF, 0x05, 0x72, 0x0B, 0xF0, 0x57, 0x20, 0x5F, 0x06, 0x72, 0x01,
  0x0E, 0xE0, 0x57, 0x30, 0xBE, 0x05, 0x73, 0x08, 0xD0, 0xE0, 0x47, 0x40, 0xDC, 0x0C, 0x02, 0x75,
  // "µ" (U+00B5)
  0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0,
  0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77,
  0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F,
  0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03,
  0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7,
  0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20,
  0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C,
  0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0,
  0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77,
  0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F,
  0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03,
  0xF0, 0xD7, 0x77, 0x20, 0x5F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x5F, 0x0C, 0x03, 0xF0, 0xD7,
  0x77, 0x20, 0x6F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x7F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20,
  0x9F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0xBF, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0xEF, 0x0C,
  0x03, 0xF0, 0xE7, 0x77, 0x10, 0x1F, 0x90, 0xC0, 0x3F, 0x97, 0x77, 0x10, 0x6F, 0x90, 0xC0, 0x3F,
  0x90, 0x27, 0x77, 0x0B, 0xF9, 0x0C, 0x03, 0xF9, 0x05, 0x77, 0x60, 0x1F, 0xA0, 0xC0, 0x3F, 0x90,
  0xA7, 0x76, 0x08, 0xFA, 0x0C, 0x03, 0xFA, 0x01, 0x77, 0x40, 0x10, 0xEF, 0xA0, 0xC0, 0x3F, 0xA0,
  0x97, 0x74, 0x0A, 0xFB, 0x0C, 0x03, 0xFB, 0x04, 0x77, 0x20, 0x9F, 0xC0, 0xC0, 0x3F, 0xC0, 0x57,
  0x60, 0x10, 0xBF, 0xD0, 0xC0, 0x3F, 0xD0, 0xC0, 0x47, 0x20, 0x30, 0x9E, 0x0D, 0x0E, 0xE0, 0xC0,
  0x3F, 0xF9, 0x86, 0xCA, 0x98, 0x9A, 0xCE, 0xF8, 0x1E, 0x2A, 0xE0, 0xC0, 0x3F, 0xFF, 0xFA, 0x81,
  0x50, 0x7E, 0x0C, 0x03, 0xFF, 0xFF, 0x90, 0x62, 0x05, 0xE0, 0xC0, 0x3F, 0xFF, 0xE0, 0xE0, 0x53,
  0x02, 0xE0, 0xC0, 0x3F, 0xFF, 0xD0, 0xB0, 0x25, 0x0E, 0xD0, 0xC0, 0x3F, 0x81, 0xE9, 0xEF, 0xE8,
  0x1E, 0xA4, 0x70, 0xCD, 0x0C, 0x03, 0xF0, 0xD2, 0x89, 0x34, 0x8A, 0xCE, 0xEF, 0xEE, 0xCA, 0x84,
  0x77, 0x30, 0x3F, 0x0D, 0x77, 0x77, 0x40, 0x3F, 0x0D, 0x77, 0x77, 0x40, 0x3F, 0x0D, 0x77, 0x77,
  0x40, 0x3F, 0x0D, 0x77, 0x77, 0x40, 0x3F, 0x0D, 0x77, 0x77, 0x40, 0x3F, 0x0D, 0x77, 0x77, 0x40,
  0x3F, 0x0D, 0x77, 0x77, 0x40, 0x3F, 0x0D, 0x77, 0x77, 0x40, 0x3F, 0x0D, 0x77, 0x77, 0x40, 0x3F,
  0x0D, 0x77, 0x77, 0x40, 0x3F, 0x0D, 0x77, 0x77, 0x40, 0x3F, 0x0D, 0x77, 0x77, 0x40, 0x3F, 0x0D,
  0x77, 0x77, 0x40, 0x3F, 0x0D, 0x77, 0x77, 0x40, 0x3F, 0x0D, 0x77, 0x77, 0x40, 0x3F, 0x0D, 0x77,
  0x77, 0x40, 0x3F, 0x0D, 0x77, 0x77, 0x40, 0x3F, 0x0D, 0x77, 0x77, 0x40, 0x3F, 0x0D, 0x77, 0x77,
  0x40, 0x3F, 0x0D, 0x77, 0x77, 0x40, 0x3F, 0x0D, 0x77, 0x77, 0x40,
  // "¶" (U+00B6)
  0x75, 0x84, 0x16, 0x9B, 0xDE, 0xFF, 0xFD, 0x08, 0x73, 0x06, 0x0C, 0xFF, 0xFF, 0xC0, 0x87, 0x10,
  0x60, 0xEF, 0xFF, 0xFE, 0x08, 0x60, 0x10, 0xC8, 0x0C, 0x0F, 0x08, 0x50, 0x20, 0xD8, 0x0C, 0x1F,
  0x08, 0x50, 0xDF, 0xFF, 0xB0, 0x17, 0x10, 0xAC, 0x08, 0x40, 0xAF, 0xFF, 0xC0, 0x17, 0x10, 0xAC,
  0x08, 0x30, 0x4F, 0xFF, 0xD0, 0x17, 0x10, 0xAC, 0x08, 0x30, 0xDF, 0xFF, 0xD0, 0x17, 0x10, 0xAC,
  0x08, 0x20, 0x5F, 0xFF, 0xE0, 0x17, 0x10, 0xAC, 0x08, 0x20, 0xBF, 0xFF, 0xE0, 0x17, 0x10, 0xAC,
  0x81, 0x80, 0x1F, 0xFF, 0xF0, 0x17, 0x10, 0xAC, 0x81, 0x80, 0x5F, 0xFF, 0xF0, 0x17, 0x10, 0xAC,
  0x81, 0x80, 0x9F, 0xFF, 0xF0, 0x17, 0x10, 0xAC, 0x81, 0x80, 0xDF, 0xFF, 0xF0, 0x17, 0x10, 0xAC,
  0x08, 0x1F, 0xFF, 0xF9, 0x01, 0x71, 0x0A, 0xC0, 0x80, 0x1F, 0xFF, 0xF9, 0x01, 0x71, 0x0A, 0xC0,
  0x80, 0x3F, 0xFF, 0xF9, 0x01, 0x71, 0x0A, 0xC0, 0x80, 0x5F, 0xFF, 0xF9, 0x01, 0x71, 0x0A, 0xC0,
  0x80, 0x6F, 0xFF, 0xF9, 0x01, 0x71, 0x0A, 0xC0, 0x80, 0x6F, 0xFF, 0xF9, 0x01, 0x71, 0x0A, 0xC0,
  0x80, 0x7F, 0xFF, 0xF9, 0x01, 0x71, 0x0A, 0xC0, 0x80, 0x7F, 0xFF, 0xF9, 0x01, 0x71, 0x0A, 0xC0,
  0x80, 0x7F, 0xFF, 0xF9, 0x01, 0x71, 0x0A, 0xC0, 0x80, 0x6F, 0xFF, 0xF9, 0x01, 0x71, 0x0A, 0xC0,
  0x80, 0x6F, 0xFF, 0xF9, 0x01, 0x71, 0x0A, 0xC0, 0x80, 0x5F, 0xFF, 0xF9, 0x01, 0x71, 0x0A, 0xC0,
  0x80, 0x3F, 0xFF, 0xF9, 0x01, 0x71, 0x0A, 0xC0, 0x80, 0x1F, 0xFF, 0xF9, 0x01, 0x71, 0x0A, 0xC0,
  0x81, 0xFF, 0xFF, 0x90, 0x17, 0x10, 0xAC, 0x81, 0x80, 0xCF, 0xFF, 0xF0, 0x17, 0x10, 0xAC, 0x81,
  0x80, 0x9F, 0xFF, 0xF0, 0x17, 0x10, 0xAC, 0x81, 0x80, 0x6F, 0xFF, 0xF0, 0x17, 0x10, 0xAC, 0x81,
  0x80, 0x1F, 0xFF, 0xF0, 0x17, 0x10, 0xAC, 0x08, 0x20, 0xBF, 0xFF, 0xE0, 0x17, 0x10, 0xAC, 0x08,
  0x20, 0x5F, 0xFF, 0xE0, 0x17, 0x10, 0xAC, 0x08, 0x30, 0xDF, 0xFF, 0xD0, 0x17, 0x10, 0xAC, 0x08,
  0x30, 0x5F, 0xFF, 0xD0, 0x17, 0x10, 0xAC, 0x08, 0x40, 0x9F, 0xFF, 0xC0, 0x17, 0x10, 0xAC, 0x08,
  0x50, 0xCF, 0xFF, 0xB0, 0x17, 0x10, 0xAC, 0x08, 0x50, 0x10, 0xCF, 0xFF, 0xA0, 0x17, 0x10, 0xAC,
  0x08, 0x60, 0x10, 0x9F, 0xFF, 0x90, 0x17, 0x10, 0xAC, 0x08, 0x71, 0x04, 0x0B, 0xFF, 0xE0, 0x17,
  0x10, 0xAC, 0x08, 0x73, 0x81, 0x38, 0xCF, 0xB0, 0xE0, 0xBD, 0x01, 0x71, 0x0A, 0xC0, 0x87, 0x78,
  0x63, 0x45, 0x65, 0x44, 0x22, 0x01, 0xD0, 0x17, 0x10, 0xAC, 0x08, 0x77, 0x73, 0x01, 0xD0, 0x17,
  0x10, 0xAC, 0x08, 0x77, 0x73, 0x01, 0xD0, 0x17, 0x10, 0xAC, 0x08, 0x77, 0x73, 0x01, 0xD0, 0x17,
  0x10, 0xAC, 0x08, 0x77, 0x73, 0x01, 0xD0, 0x17, 0x10, 0xAC, 0x08, 0x77, 0x73, 0x01, 0xD0, 0x17,
  0x10, 0xAC, 0x08, 0x77, 0x73, 0x01, 0xD0, 0x17, 0x10, 0xAC, 0x08, 0x77, 0x73, 0x01, 0xD0, 0x17,
  0x10, 0xAC, 0x08, 0x77, 0x73, 0x01, 0xD0, 0x17, 0x10, 0xAC, 0x08, 0x77, 0x73, 0x01, 0xD0, 0x17,
  0x10, 0xAC, 0x08, 0x77, 0x73, 0x01, 0xD0, 0x17, 0x10, 0xAC, 0x08, 0x77, 0x73, 0x01, 0xD0, 0x17,
  0x10, 0xAC, 0x08, 0x77, 0x73, 0x01, 0xD0, 0x17, 0x10, 0xAC, 0x08, 0x77, 0x73, 0x01, 0xD0, 0x17,
  0x10, 0xAC, 0x08, 0x77, 0x73, 0x01, 0xD0, 0x17, 0x10, 0xAC, 0x08, 0x77, 0x73, 0x01, 0xD0, 0x17,
  0x10, 0xAC, 0x08, 0x77, 0x73, 0x01, 0xD0, 0x17, 0x10, 0xAC, 0x08, 0x77, 0x73, 0x01, 0xD0, 0x17,
  0x10, 0xAC, 0x08, 0x77, 0x73, 0x01, 0xD0, 0x17, 0x10, 0xAC, 0x08, 0x77, 0x73, 0x01, 0xD0, 0x17,
  0x10, 0xAC, 0x08, 0x77, 0x73, 0x01, 0xD0, 0x17, 0x10, 0xAC, 0x08, 0x77, 0x73, 0x01, 0xD0, 0x17,
  0x10, 0xAC, 0x08, 0x77, 0x73, 0x01, 0xD0, 0x17, 0x10, 0xAC, 0x08, 0x77, 0x73, 0x01, 0xD0, 0x17,
  0x10, 0xAC, 0x08, 0x77, 0x73, 0x01, 0xD0, 0x17, 0x10, 0xAC, 0x08, 0x77, 0x73, 0x01, 0xD0, 0x17,
  0x10, 0xAC, 0x08, 0x77, 0x73, 0x01, 0xD0, 0x17, 0x10, 0xAC, 0x08, 0x77, 0x73, 0x01, 0xD0, 0x17,
  0x10, 0xAC, 0x08, 0x77, 0x73, 0x01, 0xD0, 0x17, 0x10, 0xAC, 0x08, 0x77, 0x73, 0x01, 0xD0, 0x17,
  0x10, 0xAC, 0x08, 0x77, 0x73, 0x01, 0xD0, 0x17, 0x10, 0xAC, 0x08, 0x77, 0x73, 0x01, 0xD0, 0x17,
  0x10, 0xAC, 0x08, 0x77, 0x73, 0x01, 0xD0, 0x17, 0x10, 0xAC, 0x08, 0x77, 0x73, 0x01, 0xD0, 0x17,
  0x10, 0xAC, 0x08, 0x77, 0x73, 0x01, 0xD0, 0x17, 0x10, 0xAC, 0x08, 0x77, 0x74, 0x80, 0x17, 0x72,
  0x84, 0x57, 0x77, 0x73,
  // "·" (U+00B7)
  0x28, 0x61, 0x8C, 0xEE, 0xC7, 0x13, 0x02, 0x0E, 0xE0, 0xE0, 0x22, 0x0D, 0xF9, 0x81, 0xD0, 0x3F,
  0xB0, 0x30, 0x7F, 0xB0, 0x70, 0x8F, 0xB0, 0x08, 0xFB, 0x08, 0x07, 0xFB, 0x07, 0x03, 0xFB, 0x81,
  0x30, 0xCF, 0x90, 0xC2, 0x02, 0x0D, 0xE0, 0xD0, 0x14, 0x84, 0x7C, 0xEE, 0xC7, 0x30,
  // "¸" (U+00B8)
  0x70, 0x3C, 0x0E, 0x01, 0x75, 0x0A, 0xC0, 0x97, 0x50, 0x2D, 0x02, 0x75, 0x09, 0xC0, 0xB7, 0x50,
  0x1D, 0x04, 0x75, 0x08, 0xD0, 0x70, 0x27, 0x30, 0x10, 0xEF, 0x0C, 0x05, 0x71, 0x07, 0xFB, 0x0C,
  0x02, 0x68, 0x24, 0x7A, 0xDF, 0x90, 0xE0, 0x37, 0x28, 0x13, 0x8E, 0xE0, 0xC7, 0x40, 0x10, 0xCE,
  0x04, 0x74, 0x01, 0xE0, 0x87, 0x50, 0xBD, 0x0A, 0x75, 0x0A, 0xD0, 0xA7, 0x50, 0xDD, 0x09, 0x74,
  0x08, 0xE8, 0x35, 0x04, 0x21, 0x38, 0x21, 0x37, 0xCE, 0x81, 0xE0, 0x1F, 0xFA, 0x81, 0x60, 0x1F,
  0xF9, 0x0A, 0x20, 0x1F, 0xF0, 0x83, 0x01, 0xFC, 0x81, 0xEA, 0x25, 0x81, 0xAD, 0xEA, 0x84, 0xEE,
  0xDA, 0x85, 0x70,
  // "¹" (U+00B9)
  0x74, 0x01, 0x80, 0x27, 0x02, 0x77, 0x50, 0x70, 0xEE, 0x04, 0x77, 0x30, 0x50, 0xDF, 0x90, 0x47,
  0x71, 0x03, 0x0B, 0xFB, 0x04, 0x76, 0x01, 0x09, 0xFD, 0x04, 0x75, 0x07, 0x0E, 0xFE, 0x04, 0x73,
  0x05, 0x0D, 0xFA, 0x0D, 0xD0, 0x47, 0x20, 0x7F, 0xB0, 0x70, 0x5D, 0x04, 0x73, 0x0E, 0xF8, 0x2D,
  0x30, 0x6D, 0x04, 0x73, 0x05, 0xD0, 0xE0, 0x73, 0x07, 0xD0, 0x47, 0x40, 0xBB, 0x09, 0x01, 0x40,
  0x7D, 0x04, 0x74, 0x82, 0x2F, 0xA2, 0x60, 0x7D, 0x04, 0x75, 0x01, 0x71, 0x08, 0xD0, 0x47, 0x77,
  0x08, 0xD0, 0x47, 0x77, 0x08, 0xD0, 0x47, 0x77, 0x08, 0xD0, 0x47, 0x77, 0x08, 0xD0, 0x47, 0x77,
  0x08, 0xD0, 0x47, 0x77, 0x08, 0xD0, 0x47, 0x77, 0x08, 0xD0, 0x47, 0x77, 0x08, 0xD0, 0x47, 0x77,
  0x08, 0xD0, 0x47, 0x77, 0x08, 0xD0, 0x47, 0x77, 0x08, 0xD0, 0x47, 0x77, 0x08, 0xD0, 0x47, 0x77,
  0x08, 0xD0, 0x47, 0x77, 0x08, 0xD0, 0x47, 0x77, 0x08, 0xD0, 0x47, 0x77, 0x08, 0xD0, 0x47, 0x77,
  0x08, 0xD0, 0x47, 0x77, 0x08, 0xD0, 0x47, 0x77, 0x08, 0xD0, 0x47, 0x77, 0x08, 0xD0, 0x47, 0x50,
  0x38, 0x04, 0x40, 0xAD, 0x08, 0x80, 0x54, 0x30, 0xCF, 0xFF, 0xA0, 0xE3, 0x0C, 0xFF, 0xFA, 0x0E,
  0x30, 0xCF, 0xFF, 0xA0, 0xE3, 0x0C, 0xFF, 0xFA, 0x0E, 0x30, 0xCF, 0xFF, 0xA0, 0xE0,
  // "º" (U+00BA)
  0x72, 0x89, 0x04, 0x9C, 0xDE, 0xED, 0xC8, 0x47, 0x72, 0x07, 0x0E, 0xFB, 0x0E, 0x06, 0x75, 0x03,
  0x0D, 0xFF, 0x0D, 0x02, 0x72, 0x04, 0x0E, 0xFF, 0xA0, 0xE0, 0x37, 0x02, 0xFF, 0xD0, 0xE0, 0x16,
  0x0D, 0xE8, 0x1B, 0x52, 0x28, 0x12, 0x5B, 0xE0, 0xB5, 0x07, 0xE0, 0x57, 0x10, 0x5E, 0x05, 0x40,
  0xDD, 0x06, 0x73, 0x06, 0xD0, 0xC3, 0x04, 0xD0, 0xC7, 0x50, 0xCD, 0x03, 0x20, 0x8D, 0x05, 0x75,
  0x06, 0xD0, 0x72, 0x0C, 0xC0, 0xE7, 0x60, 0x1D, 0x0A, 0x2D, 0x0B, 0x77, 0x0E, 0xC8, 0x1D, 0x01,
  0xD0, 0x97, 0x70, 0xBD, 0x10, 0x2D, 0x07, 0x77, 0x0A, 0xD1, 0x03, 0xD0, 0x77, 0x70, 0xAD, 0x01,
  0x03, 0xD0, 0x77, 0x70, 0xAD, 0x01, 0x02, 0xD0, 0x77, 0x70, 0xAD, 0x10, 0x1D, 0x09, 0x77, 0x0C,
  0xD2, 0xD0, 0xB7, 0x70, 0xEC, 0x0D, 0x20, 0xCC, 0x0E, 0x76, 0x01, 0xD0, 0xA2, 0x08, 0xD0, 0x37,
  0x50, 0x6D, 0x07, 0x20, 0x4D, 0x0A, 0x75, 0x0D, 0xD0, 0x33, 0x0D, 0xD0, 0x47, 0x30, 0x6D, 0x0C,
  0x40, 0x7D, 0x0E, 0x03, 0x71, 0x06, 0xE0, 0x55, 0x0D, 0xE8, 0x1A, 0x51, 0x28, 0x12, 0x5B, 0xE0,
  0xB6, 0x03, 0xFF, 0xD0, 0xE0, 0x17, 0x05, 0xFF, 0xB0, 0xE0, 0x37, 0x20, 0x30, 0xEF, 0xF0, 0xD0,
  0x27, 0x50, 0x80, 0xEF, 0xB0, 0xE0, 0x67, 0x71, 0x89, 0x11, 0x59, 0xCD, 0xFE, 0xDC, 0x84, 0x72,
  // "»" (U+00BB)
  0x50, 0x17, 0x77, 0x77, 0x81, 0x2C, 0xD7, 0x71, 0x81, 0x4D, 0x77, 0x72, 0x05, 0x0E, 0xA0, 0xB7,
  0x60, 0x9B, 0x04, 0x76, 0x01, 0x0A, 0xD0, 0x87, 0x30, 0x30, 0xDC, 0x0E, 0x02, 0x75, 0x0B, 0xF0,
  0x67, 0x10, 0x1F, 0x0D, 0x01, 0x74, 0x02, 0x0E, 0xF0, 0x37, 0x10, 0x6F, 0x0B, 0x75, 0x04, 0xF0,
  0xE0, 0x27, 0x10, 0xAF, 0x09, 0x75, 0x07, 0xF0, 0xC7, 0x20, 0xCF, 0x06, 0x75, 0x0A, 0xF0, 0xA7,
  0x10, 0x20, 0xEF, 0x03, 0x75, 0x0D, 0xF0, 0x87, 0x10, 0x4F, 0x0E, 0x02, 0x74, 0x02, 0x0E, 0xF0,
  0x57, 0x10, 0x7F, 0x0C, 0x75, 0x05, 0xF9, 0x03, 0x71, 0x0B, 0xF0, 0xA7, 0x50, 0x8F, 0x0E, 0x01,
  0x70, 0x10, 0xDF, 0x08, 0x75, 0x0B, 0xF0, 0xC7, 0x10, 0x20, 0xEF, 0x05, 0x74, 0x01, 0x0D, 0xF0,
  0xA7, 0x10, 0x5F, 0x90, 0x37, 0x40, 0x20, 0xEF, 0x07, 0x71, 0x08, 0xF0, 0xD0, 0x17, 0x40, 0x5F,
  0x90, 0x57, 0x10, 0xBF, 0x0C, 0x75, 0x08, 0xF0, 0xE0, 0x37, 0x01, 0x0D, 0xF0, 0x97, 0x50, 0xBF,
  0x0D, 0x01, 0x70, 0x3F, 0x90, 0x77, 0x40, 0x10, 0xEF, 0x08, 0x71, 0x07, 0xF9, 0x74, 0x05, 0xF9,
  0x05, 0x71, 0x0B, 0xF0, 0xC7, 0x30, 0x20, 0xEF, 0x08, 0x71, 0x09, 0xF0, 0xD0, 0x17, 0x20, 0x10,
  0xDF, 0x0B, 0x71, 0x06, 0xF9, 0x03, 0x73, 0x0B, 0xF0, 0xD7, 0x10, 0x3F, 0x90, 0x57, 0x30, 0x8F,
  0x0E, 0x02, 0x70, 0x10, 0xEF, 0x08, 0x73, 0x05, 0xF9, 0x04, 0x71, 0x0C, 0xF0, 0xB7, 0x30, 0x20,
  0xEF, 0x06, 0x71, 0x0A, 0xF0, 0xD0, 0x17, 0x20, 0x10, 0xDF, 0x09, 0x71, 0x07, 0xF0, 0xE0, 0x27,
  0x30, 0xBF, 0x0B, 0x71, 0x04, 0xF9, 0x04, 0x73, 0x08, 0xF0, 0xD0, 0x17, 0x02, 0x0E, 0xF0, 0x77,
  0x30, 0x5F, 0x0E, 0x02, 0x71, 0x0C, 0xF0, 0xA7, 0x30, 0x20, 0xEF, 0x04, 0x71, 0x0A, 0xF0, 0xC7,
  0x30, 0x10, 0xDF, 0x07, 0x71, 0x07, 0xF0, 0xE0, 0x17, 0x30, 0xBF, 0x09, 0x71, 0x04, 0xF9, 0x03,
  0x73, 0x08, 0xF0, 0xC7, 0x10, 0x20, 0xEF, 0x06, 0x74, 0x06, 0xE0, 0xD0, 0x17, 0x20, 0x9E, 0x09,
  0x76, 0x02, 0x0C, 0xB0, 0xE0, 0x37, 0x40, 0x50, 0xEB, 0x0B, 0x77, 0x20, 0x9A, 0x05, 0x76, 0x83,
  0x2C, 0xFD, 0x17, 0x73, 0x04, 0x07, 0x77, 0x20, 0x80, 0x37, 0x70,
  // "¼" (U+00BC)
  0x71, 0x05, 0x0D, 0xD0, 0xA7, 0x77, 0x30, 0x7E, 0x05, 0x73, 0x02, 0x0B, 0xF0, 0xA7, 0x77, 0x20,
  0x10, 0xED, 0x0C, 0x73, 0x08, 0xFA, 0x0A, 0x77, 0x72, 0x08, 0xE0, 0x47, 0x10, 0x50, 0xDF, 0xB0,
  0xA7, 0x77, 0x10, 0x10, 0xED, 0x0C, 0x70, 0x20, 0xBF, 0xD0, 0xA7, 0x77, 0x10, 0x9E, 0x04, 0x60,
  0x5F, 0xF0, 0xA7, 0x77, 0x01, 0xE0, 0xB7, 0x01, 0x0E, 0xF0, 0xAD, 0x0A, 0x77, 0x70, 0x9E, 0x03,
  0x71, 0x06, 0xE0, 0x70, 0x1D, 0x0A, 0x77, 0x60, 0x2E, 0x0B, 0x73, 0x0C, 0xB8, 0x2C, 0x20, 0x1D,
  0x0A, 0x77, 0x60, 0xAE, 0x03, 0x73, 0x82, 0x3F, 0xD5, 0x30, 0x2D, 0x0A, 0x77, 0x50, 0x2E, 0x0A,
  0x75, 0x04, 0x50, 0x2D, 0x0A, 0x77, 0x50, 0xAE, 0x02, 0x77, 0x40, 0x2D, 0x0A, 0x77, 0x40, 0x3E,
  0x09, 0x77, 0x50, 0x2D, 0x0A, 0x77, 0x40, 0xBE, 0x02, 0x77, 0x50, 0x2D, 0x0A, 0x77, 0x30, 0x4E,
  0x09, 0x77, 0x60, 0x2D, 0x0A, 0x77, 0x30, 0xCE, 0x01, 0x77, 0x60, 0x2D, 0x0A, 0x77, 0x20, 0x4E,
  0x08, 0x77, 0x70, 0x2D, 0x0A, 0x77, 0x20, 0xCD, 0x0E, 0x01, 0x77, 0x70, 0x2D, 0x0A, 0x77, 0x10,
  0x5E, 0x08, 0x77, 0x71, 0x02, 0xD0, 0xA7, 0x71, 0x0D, 0xD0, 0xE0, 0x17, 0x77, 0x10, 0x2D, 0x0A,
  0x77, 0x05, 0xE0, 0x77, 0x77, 0x20, 0x2D, 0x0A, 0x77, 0x0D, 0xD0, 0xE7, 0x77, 0x30, 0x2D, 0x0A,
  0x76, 0x06, 0xE0, 0x77, 0x77, 0x30, 0x2D, 0x0A, 0x76, 0x0E, 0xD0, 0xD7, 0x77, 0x40, 0x2D, 0x0A,
  0x75, 0x07, 0xE0, 0x67, 0x77, 0x40, 0x2D, 0x0A, 0x75, 0x0E, 0xD0, 0xD7, 0x77, 0x50, 0x4D, 0x0A,
  0x74, 0x07, 0xE0, 0x57, 0x75, 0x84, 0x18, 0xAB, 0xDE, 0xFA, 0x84, 0xED, 0xBA, 0x98, 0x30, 0x10,
  0xED, 0x0D, 0x77, 0x60, 0x1F, 0xFD, 0x0E, 0x30, 0x8E, 0x05, 0x77, 0x60, 0x1F, 0xFD, 0x0E, 0x20,
  0x10, 0xED, 0x0C, 0x77, 0x70, 0x1F, 0xFD, 0x0E, 0x20, 0x9E, 0x04, 0x77, 0x70, 0x1F, 0xFD, 0x81,
  0xE0, 0x2E, 0x0C, 0x80, 0xD0, 0x00, 0x9E, 0x04, 0x80, 0xC7, 0x00, 0x2E, 0x0B, 0x72, 0x01, 0x80,
  0x25, 0x77, 0x77, 0x0A, 0xE0, 0x37, 0x20, 0xAE, 0x77, 0x76, 0x03, 0xE0, 0xA7, 0x20, 0x5F, 0x77,
  0x76, 0x0B, 0xE0, 0x37, 0x10, 0x20, 0xEF, 0x77, 0x75, 0x03, 0xE0, 0xA7, 0x20, 0xBF, 0x97, 0x77,
  0x50, 0xBE, 0x02, 0x71, 0x07, 0xFA, 0x77, 0x74, 0x04, 0xE0, 0x97, 0x10, 0x3F, 0xB7, 0x77, 0x40,
  0xCE, 0x02, 0x71, 0x0D, 0xFB, 0x77, 0x73, 0x04, 0xE0, 0x97, 0x10, 0x9C, 0x0E, 0x0A, 0xD7, 0x77,
  0x30, 0xCE, 0x01, 0x70, 0x4D, 0x06, 0x09, 0xD7, 0x77, 0x20, 0x5E, 0x08, 0x70, 0x10, 0xEC, 0x81,
  0xB0, 0xAD, 0x77, 0x72, 0x0D, 0xD0, 0xE0, 0x17, 0x0B, 0xD8, 0x12, 0x0B, 0xD7, 0x77, 0x10, 0x6E,
  0x07, 0x70, 0x6D, 0x07, 0x20, 0xBD, 0x77, 0x71, 0x0D, 0xD0, 0xE0, 0x16, 0x02, 0x0E, 0xC0, 0xB3,
  0x0C, 0xD7, 0x77, 0x06, 0xE0, 0x77, 0x0C, 0xC0, 0xE0, 0x23, 0x0C, 0xD7, 0x77, 0x0E, 0xD0, 0xE7,
  0x08, 0xD0, 0x64, 0x0C, 0xD7, 0x76, 0x07, 0xE0, 0x66, 0x03, 0xD0, 0xA5, 0x0C, 0xD7, 0x76, 0x0E,
  0xD0, 0xD6, 0x01, 0x0D, 0xC0, 0xE0, 0x15, 0x0C, 0xD7, 0x75, 0x08, 0xE0, 0x66, 0x0A, 0xD0, 0x56,
  0x0C, 0xD7, 0x74, 0x01, 0x0E, 0xD0, 0xD6, 0x05, 0xD0, 0x97, 0x0C, 0xD7, 0x74, 0x08, 0xE0, 0x56,
  0x0E, 0xFF, 0xFA, 0x0A, 0x75, 0x01, 0xE0, 0xC7, 0xFF, 0xFB, 0x0A, 0x75, 0x09, 0xE0, 0x57, 0xFF,
  0xFB, 0x0A, 0x74, 0x02, 0xE0, 0xC7, 0x1F, 0xFF, 0xB0, 0xA7, 0x40, 0x9E, 0x04, 0x71, 0xFF, 0xFB,
  0x0A, 0x73, 0x02, 0xE0, 0xB7, 0x77, 0x20, 0xCD, 0x77, 0x10, 0xAE, 0x03, 0x77, 0x72, 0x0C, 0xD7,
  0x70, 0x3E, 0x0B, 0x77, 0x73, 0x0C, 0xD7, 0x70, 0xBE, 0x03, 0x77, 0x73, 0x0C, 0xD7, 0x60, 0x3E,
  0x0A, 0x77, 0x74, 0x0C, 0xD7, 0x60, 0xBE, 0x02, 0x77, 0x74, 0x0C, 0xD7, 0x50, 0x4E, 0x0A, 0x77,
  0x75, 0x0B, 0xD5,
  // "½" (U+00BD)
  0x71, 0x05, 0x0D, 0xD0, 0xA7, 0x77, 0x30, 0x7E, 0x05, 0x73, 0x02, 0x0B, 0xF0, 0xA7, 0x77, 0x20,
  0x10, 0xED, 0x0C, 0x73, 0x08, 0xFA, 0x0A, 0x77, 0x72, 0x08, 0xE0, 0x47, 0x10, 0x50, 0xDF, 0xB0,
  0xA7, 0x77, 0x10, 0x10, 0xED, 0x0C, 0x70, 0x20, 0xBF, 0xD0, 0xA7, 0x77, 0x10, 0x8E, 0x04, 0x60,
  0x5F, 0xF0, 0xA7, 0x77, 0x01, 0xE0, 0xB7, 0x01, 0x0E, 0xF0, 0xAD, 0x0A, 0x77, 0x70, 0x9E, 0x03,
  0x71, 0x06, 0xE0, 0x70, 0x1D, 0x0A, 0x77, 0x60, 0x2E, 0x0B, 0x73, 0x0C, 0xB8, 0x2C, 0x20, 0x1D,
  0x0A, 0x77, 0x60, 0xAE, 0x03, 0x73, 0x82, 0x3F, 0xD5, 0x30, 0x2D, 0x0A, 0x77, 0x50, 0x2E, 0x0A,
  0x75, 0x04, 0x50, 0x2D, 0x0A, 0x77, 0x50, 0xAE, 0x02, 0x77, 0x40, 0x2D, 0x0A, 0x77, 0x40, 0x3E,
  0x09, 0x77, 0x50, 0x2D, 0x0A, 0x77, 0x40, 0xBE, 0x02, 0x77, 0x50, 0x2D, 0x0A, 0x77, 0x30, 0x3E,
  0x09, 0x77, 0x60, 0x2D, 0x0A, 0x77, 0x30, 0xCE, 0x01, 0x77, 0x60, 0x2D, 0x0A, 0x77, 0x20, 0x4E,
  0x08, 0x77, 0x70, 0x2D, 0x0A, 0x77, 0x20, 0xCD, 0x0E, 0x01, 0x77, 0x70, 0x2D, 0x0A, 0x77, 0x10,
  0x5E, 0x08, 0x77, 0x71, 0x02, 0xD0, 0xA7, 0x71, 0x0D, 0xD0, 0xE0, 0x17, 0x77, 0x10, 0x2D, 0x0A,
  0x77, 0x05, 0xE0, 0x77, 0x77, 0x20, 0x2D, 0x0A, 0x77, 0x0D, 0xD0, 0xE7, 0x77, 0x30, 0x2D, 0x0A,
  0x76, 0x06, 0xE0, 0x77, 0x77, 0x30, 0x2D, 0x0A, 0x76, 0x0E, 0xD0, 0xD7, 0x77, 0x40, 0x2D, 0x0A,
  0x75, 0x07, 0xE0, 0x67, 0x77, 0x40, 0x2D, 0x0A, 0x75, 0x0E, 0xD0, 0xD7, 0x77, 0x50, 0x4D, 0x0A,
  0x74, 0x07, 0xE0, 0x57, 0x75, 0x84, 0x18, 0xAB, 0xDE, 0xFA, 0x84, 0xED, 0xBA, 0x98, 0x30, 0x10,
  0xED, 0x0D, 0x77, 0x60, 0x1F, 0xFD, 0x0E, 0x30, 0x8E, 0x05, 0x77, 0x60, 0x1F, 0xFD, 0x0E, 0x20,
  0x10, 0xED, 0x0C, 0x77, 0x70, 0x1F, 0xFD, 0x0E, 0x20, 0x9E, 0x04, 0x77, 0x70, 0x1F, 0xFD, 0x81,
  0xE0, 0x1E, 0x0C, 0x80, 0xD0, 0x00, 0x9E, 0x04, 0x80, 0xC7, 0x00, 0x2E, 0x0B, 0x48, 0x22, 0x7B,
  0xDA, 0x83, 0xED, 0xA6, 0x17, 0x77, 0x71, 0x0A, 0xE0, 0x32, 0x03, 0x0B, 0xFC, 0x09, 0x01, 0x77,
  0x75, 0x02, 0xE8, 0x2B, 0x01, 0xAF, 0xF0, 0xD0, 0x37, 0x77, 0x40, 0xAE, 0x81, 0x34, 0xEF, 0xFA,
  0x0E, 0x02, 0x77, 0x72, 0x03, 0xE8, 0x1A, 0x07, 0xFF, 0xC0, 0xB7, 0x77, 0x20, 0xBE, 0x02, 0x20,
  0xBC, 0x86, 0xE8, 0x31, 0x02, 0x7E, 0xE0, 0x47, 0x77, 0x04, 0xE0, 0x93, 0x01, 0x0D, 0xA0, 0x97,
  0x03, 0x0E, 0xD0, 0x87, 0x77, 0x0C, 0xE0, 0x24, 0x81, 0x4E, 0x47, 0x20, 0x8D, 0x0C, 0x77, 0x60,
  0x4E, 0x09, 0x77, 0x30, 0x4D, 0x0D, 0x77, 0x60, 0xCE, 0x01, 0x77, 0x30, 0x3D, 0x0E, 0x77, 0x50,
  0x5E, 0x08, 0x77, 0x40, 0x4D, 0x0C, 0x77, 0x50, 0xDD, 0x0E, 0x01, 0x77, 0x40, 0x8D, 0x09, 0x77,
  0x40, 0x6E, 0x08, 0x77, 0x50, 0xED, 0x05, 0x77, 0x40, 0xDD, 0x0E, 0x01, 0x77, 0x40, 0x9D, 0x0D,
  0x77, 0x40, 0x6E, 0x07, 0x77, 0x40, 0x6E, 0x05, 0x77, 0x40, 0xED, 0x0E, 0x77, 0x40, 0x5E, 0x09,
  0x77, 0x40, 0x7E, 0x06, 0x77, 0x30, 0x5E, 0x0B, 0x77, 0x50, 0xED, 0x0D, 0x77, 0x30, 0x5E, 0x0C,
  0x77, 0x50, 0x7E, 0x06, 0x77, 0x20, 0x6E, 0x0C, 0x01, 0x77, 0x40, 0x10, 0xED, 0x0D, 0x77, 0x20,
  0x7E, 0x0C, 0x01, 0x77, 0x50, 0x8E, 0x05, 0x77, 0x10, 0x8E, 0x0B, 0x77, 0x60, 0x10, 0xED, 0x0D,
  0x77, 0x10, 0x9E, 0x0A, 0x77, 0x70, 0x9E, 0x05, 0x77, 0x0A, 0xE0, 0x97, 0x77, 0x02, 0xE0, 0xC7,
  0x70, 0xAE, 0x07, 0x77, 0x71, 0x09, 0xE0, 0x47, 0x60, 0xBE, 0x05, 0x77, 0x71, 0x02, 0xE0, 0xC7,
  0x50, 0x10, 0xCD, 0x0E, 0x03, 0x77, 0x72, 0x0A, 0xE0, 0x47, 0x40, 0x10, 0xCF, 0xFE, 0x0A, 0x72,
  0x03, 0xE0, 0xB7, 0x50, 0x3F, 0xFF, 0x0A, 0x72, 0x0B, 0xE0, 0x37, 0x50, 0x3F, 0xFF, 0x0A, 0x71,
  0x03, 0xE0, 0xA7, 0x60, 0x3F, 0xFF, 0x0A, 0x71, 0x0B, 0xE0, 0x27, 0x60, 0x3F, 0xFF, 0x0A, 0x70,
  0x4E, 0x0A, 0x77, 0x03, 0xFF, 0xF0, 0xA0,
  // "¾" (U+00BE)
  0x58, 0x92, 0x15, 0x9C, 0xDE, 0xFE, 0xC9, 0x61, 0x77, 0x71, 0x01, 0x80, 0x23, 0x01, 0x70, 0x20,
  0x9F, 0xC0, 0xE0, 0x87, 0x77, 0x09, 0xE0, 0x36, 0x08, 0xFF, 0x90, 0xD0, 0x27, 0x74, 0x02, 0xE0,
  0xB5, 0x01, 0x0D, 0xFF, 0xB0, 0xD0, 0x17, 0x73, 0x0A, 0xE0, 0x36, 0x08, 0xFF, 0xC0, 0x97, 0x72,
  0x02, 0xE0, 0xA7, 0x10, 0xCC, 0x81, 0xC6, 0x22, 0x03, 0x0A, 0xF0, 0x17, 0x71, 0x0A, 0xE0, 0x27,
  0x18, 0x32, 0xEF, 0xD4, 0x70, 0x8E, 0x06, 0x77, 0x03, 0xE0, 0x97, 0x30, 0x50, 0x87, 0x30, 0xED,
  0x09, 0x77, 0x0B, 0xE0, 0x27, 0x77, 0x10, 0xBD, 0x0B, 0x76, 0x03, 0xE0, 0x97, 0x77, 0x20, 0xBD,
  0x0B, 0x76, 0x0B, 0xE0, 0x17, 0x77, 0x20, 0xDD, 0x09, 0x75, 0x04, 0xE0, 0x87, 0x77, 0x20, 0x3E,
  0x06, 0x75, 0x0C, 0xD0, 0xE0, 0x17, 0x77, 0x10, 0x10, 0xDE, 0x01, 0x74, 0x05, 0xE0, 0x87, 0x76,
  0x82, 0x13, 0x8E, 0xE0, 0x77, 0x50, 0xCD, 0x0E, 0x01, 0x77, 0x01, 0xFF, 0x09, 0x75, 0x05, 0xE0,
  0x77, 0x71, 0x01, 0xFD, 0x0C, 0x05, 0x76, 0x0D, 0xD0, 0xE7, 0x72, 0x01, 0xFD, 0x0C, 0x05, 0x75,
  0x06, 0xE0, 0x77, 0x72, 0x01, 0xFF, 0x0C, 0x02, 0x73, 0x0D, 0xD0, 0xE7, 0x73, 0x01, 0xFF, 0x90,
  0xE0, 0x27, 0x10, 0x6E, 0x06, 0x77, 0x73, 0x81, 0x25, 0xAF, 0x0B, 0x71, 0x0E, 0xD0, 0xD7, 0x77,
  0x70, 0x20, 0xDE, 0x02, 0x60, 0x7E, 0x06, 0x77, 0x77, 0x10, 0x4E, 0x06, 0x60, 0xED, 0x0D, 0x77,
  0x77, 0x3E, 0x08, 0x50, 0x7E, 0x05, 0x77, 0x77, 0x30, 0xED, 0x08, 0x40, 0x10, 0xED, 0x0D, 0x77,
  0x77, 0x30, 0x1E, 0x07, 0x40, 0x8E, 0x05, 0x77, 0x30, 0x17, 0x60, 0x7E, 0x04, 0x30, 0x10, 0xED,
  0x0C, 0x77, 0x48, 0x18, 0xC5, 0x73, 0x04, 0x0E, 0xD0, 0xE4, 0x09, 0xE0, 0x47, 0x74, 0x08, 0xB8,
  0x2A, 0x63, 0x12, 0x81, 0x14, 0x9F, 0x09, 0x30, 0x1E, 0x0C, 0x77, 0x50, 0x8F, 0xFC, 0x0E, 0x01,
  0x30, 0x9E, 0x04, 0x77, 0x50, 0x8F, 0xFC, 0x03, 0x30, 0x2E, 0x0B, 0x77, 0x60, 0x8F, 0xFA, 0x0D,
  0x04, 0x40, 0xAE, 0x03, 0x77, 0x60, 0x30, 0xBF, 0xE8, 0x1E, 0x81, 0x40, 0x2E, 0x0B, 0x77, 0x72,
  0x89, 0x31, 0x59, 0xBD, 0xEF, 0xEE, 0xDA, 0x74, 0x70, 0xAE, 0x03, 0x80, 0xC6, 0x00, 0x3E, 0x0A,
  0x80, 0xC7, 0x00, 0xBE, 0x02, 0x72, 0x05, 0x80, 0x2E, 0x77, 0x75, 0x03, 0xE0, 0xA7, 0x20, 0x20,
  0xEE, 0x77, 0x75, 0x0B, 0xE0, 0x27, 0x20, 0xCF, 0x77, 0x74, 0x04, 0xE0, 0x97, 0x20, 0x8F, 0x97,
  0x77, 0x40, 0xCE, 0x01, 0x71, 0x04, 0xFA, 0x77, 0x73, 0x04, 0xE0, 0x97, 0x10, 0x10, 0xDF, 0xA7,
  0x77, 0x30, 0xCD, 0x0E, 0x01, 0x71, 0x0A, 0xFB, 0x77, 0x72, 0x05, 0xE0, 0x87, 0x10, 0x6D, 0x0C,
  0xD7, 0x77, 0x20, 0xDD, 0x0E, 0x01, 0x70, 0x2D, 0x00, 0x9D, 0x77, 0x71, 0x06, 0xE0, 0x77, 0x10,
  0xCC, 0x81, 0xD1, 0xAD, 0x77, 0x71, 0x0D, 0xD0, 0xE0, 0x17, 0x09, 0xD8, 0x14, 0x0B, 0xD7, 0x77,
  0x06, 0xE0, 0x77, 0x04, 0xD0, 0x92, 0x0B, 0xD7, 0x77, 0x0E, 0xD0, 0xE7, 0x01, 0x0E, 0xC0, 0xD3,
  0x0C, 0xD7, 0x76, 0x07, 0xE0, 0x67, 0x0B, 0xD0, 0x33, 0x0C, 0xD7, 0x76, 0x0E, 0xD0, 0xD7, 0x07,
  0xD0, 0x74, 0x0C, 0xD7, 0x75, 0x07, 0xE0, 0x66, 0x03, 0xD0, 0xB5, 0x0C, 0xD7, 0x74, 0x01, 0x0E,
  0xD0, 0xD7, 0x0D, 0xC0, 0xE0, 0x15, 0x0C, 0xD7, 0x74, 0x08, 0xE0, 0x56, 0x09, 0xD0, 0x56, 0x0C,
  0xD7, 0x73, 0x01, 0x0E, 0xD0, 0xD6, 0x05, 0xD0, 0xA7, 0x0C, 0xD7, 0x73, 0x09, 0xE0, 0x56, 0x0E,
  0xFF, 0xFA, 0x0A, 0x74, 0x01, 0xE0, 0xC7, 0xFF, 0xFB, 0x0A, 0x74, 0x09, 0xE0, 0x47, 0xFF, 0xFB,
  0x0A, 0x73, 0x02, 0xE0, 0xC7, 0x1F, 0xFF, 0xB0, 0xA7, 0x30, 0xAE, 0x04, 0x71, 0xFF, 0xFB, 0x0A,
  0x72, 0x02, 0xE0, 0xB7, 0x77, 0x20, 0xCD, 0x77, 0x0A, 0xE0, 0x37, 0x77, 0x20, 0xCD, 0x76, 0x03,
  0xE0, 0xB7, 0x77, 0x30, 0xCD, 0x76, 0x0B, 0xE0, 0x37, 0x77, 0x30, 0xCD, 0x75, 0x03, 0xE0, 0xA7,
  0x77, 0x40, 0xCD, 0x75, 0x0B, 0xE0, 0x27, 0x77, 0x40, 0xCD, 0x74, 0x04, 0xE0, 0xA7, 0x77, 0x50,
  0xBD, 0x50,
  // "¿" (U+00BF)
  0x77, 0x48, 0x54, 0xAE, 0xFD, 0xA3, 0x77, 0x77, 0x20, 0x8F, 0x06, 0x77, 0x77, 0x05, 0xFA, 0x03,
  0x77, 0x76, 0x0C, 0xFA, 0x0A, 0x77, 0x76, 0xFB, 0x0D, 0x77, 0x75, 0x01, 0xFC, 0x77, 0x75, 0x01,
  0xFC, 0x77, 0x76, 0xFB, 0x0D, 0x77, 0x76, 0x0C, 0xFA, 0x0A, 0x77, 0x76, 0x06, 0xFA, 0x04, 0x77,
  0x77, 0x0A, 0xF0, 0x87, 0x77, 0x72, 0x85, 0x5B, 0xEF, 0xEA, 0x38, 0x0C, 0x80, 0x08, 0x02, 0x17,
  0x77, 0x73, 0x0B, 0xE0, 0x47, 0x77, 0x72, 0x0B, 0xE0, 0x47, 0x77, 0x72, 0x0C, 0xE0, 0x37, 0x77,
  0x72, 0x0E, 0xE0, 0x27, 0x77, 0x71, 0x02, 0xF0, 0x17, 0x77, 0x71, 0x06, 0xE0, 0xE7, 0x77, 0x72,
  0x0C, 0xE0, 0xB7, 0x77, 0x71, 0x07, 0xF0, 0x77, 0x77, 0x70, 0x4F, 0x90, 0x27, 0x77, 0x60, 0x4F,
  0x90, 0xA7, 0x77, 0x60, 0x5F, 0xA0, 0x27, 0x77, 0x50, 0x8F, 0xA0, 0x67, 0x77, 0x40, 0x10, 0xBF,
  0xA0, 0x97, 0x77, 0x40, 0x30, 0xDF, 0xA0, 0xA7, 0x77, 0x40, 0x6F, 0xB0, 0x97, 0x77, 0x40, 0x8F,
  0xB0, 0x77, 0x77, 0x40, 0xAF, 0xA0, 0xE0, 0x47, 0x77, 0x40, 0xAF, 0xA0, 0xC0, 0x17, 0x77, 0x40,
  0x9F, 0xA0, 0x87, 0x77, 0x50, 0x6F, 0xA0, 0x57, 0x77, 0x50, 0x2F, 0x90, 0xE0, 0x47, 0x77, 0x60,
  0xBF, 0x90, 0x37, 0x77, 0x60, 0x3F, 0x90, 0x67, 0x77, 0x70, 0xAF, 0x0A, 0x77, 0x77, 0x10, 0xEF,
  0x02, 0x77, 0x77, 0x04, 0xF0, 0xA7, 0x77, 0x71, 0x07, 0xF0, 0x47, 0x77, 0x71, 0x0A, 0xF0, 0x17,
  0x77, 0x71, 0x0B, 0xE0, 0xE7, 0x77, 0x72, 0x0D, 0xE0, 0xC7, 0x77, 0x72, 0x0D, 0xE0, 0xB7, 0x77,
  0x72, 0x0D, 0xE0, 0xC7, 0x77, 0x72, 0x0D, 0xE0, 0xD7, 0x77, 0x72, 0x0B, 0xF7, 0x77, 0x72, 0x09,
  0xF0, 0x57, 0x77, 0x71, 0x05, 0xF0, 0xC7, 0x77, 0x71, 0x01, 0xF9, 0x07, 0x77, 0x73, 0x05, 0x01,
  0x30, 0xAF, 0x90, 0x57, 0x76, 0x83, 0x17, 0xEF, 0x73, 0x03, 0xFA, 0x08, 0x77, 0x30, 0x50, 0xAC,
  0x0E, 0x40, 0x9F, 0xA8, 0x1D, 0x72, 0x73, 0x82, 0x26, 0xAE, 0xF0, 0x54, 0x0C, 0xFC, 0x87, 0xEB,
  0xA9, 0x89, 0x9B, 0xCF, 0xD0, 0xC4, 0x01, 0x0D, 0xFF, 0xFF, 0xC0, 0x34, 0x01, 0x0C, 0xFF, 0xFF,
  0xB0, 0xA6, 0x09, 0xFF, 0xFF, 0x81, 0xE8, 0x27, 0x03, 0x0B, 0xFF, 0xFA, 0x81, 0xEA, 0x47, 0x58,
  0x13, 0x9E, 0xFF, 0xB8, 0x1D, 0x94, 0x77, 0x48, 0x42, 0x69, 0xBD, 0xEB, 0x86, 0xEE, 0xDB, 0xA7,
  0x51, 0x72,
  // "À" (U+00C0)
  0x77, 0x80, 0x57, 0x04, 0x80, 0xC6, 0x00, 0xEF, 0x90, 0xE8, 0x0C, 0x60, 0x04, 0xFA, 0x07, 0x80,
  0xC6, 0x00, 0x8F, 0x90, 0xE0, 0x18, 0x0C, 0x60, 0x0B, 0xF9, 0x0A, 0x80, 0xC7, 0x00, 0xCF, 0x90,
  0x48, 0x0C, 0x60, 0x01, 0x0D, 0xF0, 0xD8, 0x0C, 0x70, 0x02, 0x0E, 0xF0, 0x88, 0x0C, 0x70, 0x03,
  0x0E, 0xF0, 0x38, 0x0C, 0x70, 0x03, 0x0E, 0xE0, 0xC8, 0x0D, 0x00, 0x03, 0x0E, 0xE0, 0x88, 0x0D,
  0x00, 0x03, 0x0E, 0xE0, 0x48, 0x0D, 0x00, 0x03, 0x0E, 0xD0, 0xE0, 0x18, 0x0D, 0x00, 0x02, 0x0D,
  0xD0, 0xB8, 0x0D, 0x10, 0x01, 0x0B, 0xD0, 0x18, 0x0D, 0xB4, 0x00, 0x7F, 0x90, 0x68, 0x0C, 0x60,
  0x0C, 0xF9, 0x0B, 0x80, 0xC5, 0x00, 0x2F, 0xB0, 0x18, 0x0C, 0x40, 0x07, 0xFB, 0x05, 0x80, 0xC4,
  0x00, 0xCF, 0xB0, 0xB8, 0x0C, 0x30, 0x01, 0xFD, 0x80, 0xC3, 0x00, 0x6F, 0xD0, 0x58, 0x0C, 0x20,
  0x0B, 0xFD, 0x0A, 0x80, 0xC1, 0x00, 0x1E, 0x0E, 0xF8, 0x0C, 0x10, 0x06, 0xE0, 0xA0, 0xCE, 0x05,
  0x80, 0xC0, 0x00, 0xBE, 0x07, 0x08, 0xE0, 0xA7, 0x77, 0x77, 0x01, 0xF0, 0x30, 0x4E, 0x0E, 0x77,
  0x77, 0x70, 0x6E, 0x0E, 0x2F, 0x05, 0x77, 0x77, 0x60, 0xBE, 0x0A, 0x20, 0xCE, 0x0A, 0x77, 0x77,
  0x50, 0x1F, 0x06, 0x20, 0x7E, 0x0E, 0x77, 0x77, 0x50, 0x5F, 0x01, 0x20, 0x3F, 0x04, 0x77, 0x77,
  0x40, 0xAE, 0x0C, 0x40, 0xDE, 0x09, 0x77, 0x77, 0x4F, 0x07, 0x40, 0x9E, 0x0E, 0x77, 0x77, 0x30,
  0x5F, 0x03, 0x40, 0x4F, 0x04, 0x77, 0x77, 0x20, 0xAE, 0x0D, 0x60, 0xEE, 0x09, 0x77, 0x77, 0x20,
  0xEE, 0x08, 0x60, 0xAE, 0x0E, 0x77, 0x77, 0x10, 0x5F, 0x03, 0x60, 0x5F, 0x04, 0x77, 0x77, 0x0A,
  0xE0, 0xE7, 0x1F, 0x09, 0x77, 0x77, 0x0E, 0xE0, 0x97, 0x10, 0xBE, 0x0E, 0x77, 0x76, 0x04, 0xF0,
  0x47, 0x10, 0x6F, 0x04, 0x77, 0x75, 0x09, 0xE0, 0xE7, 0x20, 0x1F, 0x09, 0x77, 0x75, 0x0E, 0xE0,
  0xA7, 0x30, 0xBE, 0x0E, 0x77, 0x74, 0x04, 0xF0, 0x57, 0x30, 0x7F, 0x03, 0x77, 0x73, 0x09, 0xF0,
  0x17, 0x30, 0x2F, 0x08, 0x77, 0x73, 0x0E, 0xE0, 0xB7, 0x50, 0xCE, 0x0D, 0x77, 0x72, 0x04, 0xF0,
  0x67, 0x50, 0x7F, 0x03, 0x77, 0x71, 0x09, 0xF0, 0x17, 0x50, 0x2F, 0x08, 0x77, 0x71, 0x0E, 0xE0,
  0xC7, 0x70, 0xDE, 0x0D, 0x77, 0x70, 0x3F, 0x07, 0x77, 0x08, 0xF0, 0x37, 0x76, 0x08, 0xF0, 0x27,
  0x70, 0x3F, 0x08, 0x77, 0x60, 0xDE, 0x0C, 0x77, 0x20, 0xEE, 0x0D, 0x77, 0x50, 0x3F, 0x08, 0x77,
  0x20, 0x9F, 0x03, 0x77, 0x40, 0x8F, 0xFF, 0xFC, 0x08, 0x77, 0x40, 0xDF, 0xFF, 0xFC, 0x0D, 0x77,
  0x30, 0x3F, 0xFF, 0xFE, 0x02, 0x77, 0x20, 0x8F, 0xFF, 0xFE, 0x07, 0x77, 0x20, 0xDF, 0xFF, 0xFE,
  0x0C, 0x77, 0x10, 0x28, 0x0C, 0x0F, 0x02, 0x77, 0x07, 0x80, 0xC0, 0xF0, 0x77, 0x70, 0xDE, 0x0E,
  0x77, 0x70, 0x1F, 0x0C, 0x76, 0x02, 0xF0, 0xA7, 0x77, 0x10, 0xBF, 0x02, 0x75, 0x07, 0xF0, 0x57,
  0x77, 0x10, 0x6F, 0x07, 0x75, 0x0C, 0xF7, 0x77, 0x20, 0x2F, 0x0C, 0x74, 0x02, 0xF0, 0xB7, 0x77,
  0x30, 0xCF, 0x01, 0x73, 0x07, 0xF0, 0x67, 0x77, 0x30, 0x8F, 0x07, 0x73, 0x0C, 0xF0, 0x17, 0x77,
  0x30, 0x3F, 0x0C, 0x72, 0x01, 0xF0, 0xC7, 0x77, 0x50, 0xDF, 0x01, 0x71, 0x07, 0xF0, 0x77, 0x77,
  0x50, 0x9F, 0x06, 0x71, 0x0C, 0xF0, 0x37, 0x77, 0x50, 0x4F, 0x0B, 0x70, 0x1F, 0x0D, 0x77, 0x77,
  0x0E, 0xF0, 0x16, 0x06, 0xF0, 0x97, 0x77, 0x70, 0xAF, 0x06, 0x60, 0xBF, 0x04, 0x77, 0x77, 0x05,
  0xF0, 0xB5, 0x01, 0xF0, 0xE7, 0x77, 0x71, 0x01, 0xF9, 0x01, 0x40, 0x6F, 0x0A, 0x77, 0x77, 0x20,
  0xBF, 0x06, 0x40, 0xBF, 0x05, 0x77, 0x77, 0x20, 0x7F, 0x0B, 0x30, 0x1F, 0x90, 0x17, 0x77, 0x72,
  0x02, 0xF9, 0x01, 0x20, 0x6F, 0x0B, 0x77, 0x77, 0x40, 0xDF, 0x05, 0x20, 0xBF, 0x06, 0x77, 0x77,
  0x40, 0x8F, 0x81, 0xB0, 0x1F, 0x90, 0x27, 0x77, 0x74, 0x03, 0xF9, 0x01,
  // "Á" (U+00C1)
  0x77, 0x77, 0x20, 0x38, 0x05, 0x70, 0x18, 0x0C, 0x50, 0x0C, 0xFA, 0x02, 0x80, 0xC4, 0x00, 0x5F,
  0xA0, 0x88, 0x0C, 0x50, 0x0D, 0xF9, 0x0B, 0x80, 0xC5, 0x00, 0x8F, 0x90, 0xD0, 0x18, 0x0C, 0x40,
  0x02, 0xF9, 0x0E, 0x02, 0x80, 0xC5, 0x00, 0xCF, 0x0E, 0x03, 0x80, 0xC5, 0x00, 0x6F, 0x90, 0x48,
  0x0C, 0x50, 0x01, 0x0E, 0xF0, 0x58, 0x0C, 0x60, 0x0B, 0xF0, 0x58, 0x0C, 0x60, 0x05, 0xF0, 0x68,
  0x0C, 0x60, 0x01, 0x0E, 0xE0, 0x58, 0x0C, 0x70, 0x0B, 0xE0, 0x58, 0x0C, 0x70, 0x08, 0xD0, 0xE0,
  0x48, 0x0D, 0x00, 0x0D, 0xC0, 0xC0, 0x28, 0x0D, 0xC0, 0x00, 0x7F, 0x90, 0x68, 0x0C, 0x60, 0x0C,
  0xF9, 0x0B, 0x80, 0xC5, 0x00, 0x2F, 0xB0, 0x18, 0x0C, 0x40, 0x07, 0xFB, 0x05, 0x80, 0xC4, 0x00,
  0xCF, 0xB0, 0xB8, 0x0C, 0x30, 0x01, 0xFD, 0x80, 0xC3, 0x00, 0x6F, 0xD0, 0x58, 0x0C, 0x20, 0x0B,
  0xFD, 0x0A, 0x80, 0xC1, 0x00, 0x1E, 0x0E, 0xF8, 0x0C, 0x10, 0x06, 0xE0, 0xA0, 0xCE, 0x05, 0x80,
  0xC0, 0x00, 0xBE, 0x07, 0x08, 0xE0, 0xA7, 0x77, 0x77, 0x01, 0xF0, 0x30, 0x4E, 0x0E, 0x77, 0x77,
  0x70, 0x6E, 0x0E, 0x2F, 0x05, 0x77, 0x77, 0x60, 0xBE, 0x0A, 0x20, 0xCE, 0x0A, 0x77, 0x77, 0x50,
  0x1F, 0x06, 0x20, 0x7E, 0x0E, 0x77, 0x77, 0x50, 0x5F, 0x01, 0x20, 0x3F, 0x04, 0x77, 0x77, 0x40,
  0xAE, 0x0C, 0x40, 0xDE, 0x09, 0x77, 0x77, 0x4F, 0x07, 0x40, 0x9E, 0x0E, 0x77, 0x77, 0x30, 0x5F,
  0x03, 0x40, 0x4F, 0x04, 0x77, 0x77, 0x20, 0xAE, 0x0D, 0x60, 0xEE, 0x09, 0x77, 0x77, 0x20, 0xEE,
  0x08, 0x60, 0xAE, 0x0E, 0x77, 0x77, 0x10, 0x5F, 0x03, 0x60, 0x5F, 0x04, 0x77, 0x77, 0x0A, 0xE0,
  0xE7, 0x1F, 0x09, 0x77, 0x77, 0x0E, 0xE0, 0x97, 0x10, 0xBE, 0x0E, 0x77, 0x76, 0x04, 0xF0, 0x47,
  0x10, 0x6F, 0x04, 0x77, 0x75, 0x09, 0xE0, 0xE7, 0x20, 0x1F, 0x09, 0x77, 0x75, 0x0E, 0xE0, 0xA7,
  0x30, 0xBE, 0x0E, 0x77, 0x74, 0x04, 0xF0, 0x57, 0x30, 0x7F, 0x03, 0x77, 0x73, 0x09, 0xF0, 0x17,
  0x30, 0x2F, 0x08, 0x77, 0x73, 0x0E, 0xE0, 0xB7, 0x50, 0xCE, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0x67,
  0x50, 0x7F, 0x03, 0x77, 0x71, 0x09, 0xF0, 0x17, 0x50, 0x2F, 0x08, 0x77, 0x71, 0x0E, 0xE0, 0xC7,
  0x70, 0xDE, 0x0D, 0x77, 0x70, 0x3F, 0x07, 0x77, 0x08, 0xF0, 0x37, 0x76, 0x08, 0xF0, 0x27, 0x70,
  0x3F, 0x08, 0x77, 0x60, 0xDE, 0x0C, 0x77, 0x20, 0xEE, 0x0D, 0x77, 0x50, 0x3F, 0x08, 0x77, 0x20,
  0x9F, 0x03, 0x77, 0x40, 0x8F, 0xFF, 0xFC, 0x08, 0x77, 0x40, 0xDF, 0xFF, 0xFC, 0x0D, 0x77, 0x30,
  0x3F, 0xFF, 0xFE, 0x02, 0x77, 0x20, 0x8F, 0xFF, 0xFE, 0x07, 0x77, 0x20, 0xDF, 0xFF, 0xFE, 0x0C,
  0x77, 0x10, 0x28, 0x0C, 0x0F, 0x02, 0x77, 0x07, 0x80, 0xC0, 0xF0, 0x77, 0x70, 0xDE, 0x0E, 0x77,
  0x70, 0x1F, 0x0C, 0x76, 0x02, 0xF0, 0xA7, 0x77, 0x10, 0xBF, 0x02, 0x75, 0x07, 0xF0, 0x57, 0x77,
  0x10, 0x6F, 0x07, 0x75, 0x0C, 0xF7, 0x77, 0x20, 0x2F, 0x0C, 0x74, 0x02, 0xF0, 0xB7, 0x77, 0x30,
  0xCF, 0x01, 0x73, 0x07, 0xF0, 0x67, 0x77, 0x30, 0x8F, 0x07, 0x73, 0x0C, 0xF0, 0x17, 0x77, 0x30,
  0x3F, 0x0C, 0x72, 0x01, 0xF0, 0xC7, 0x77, 0x50, 0xDF, 0x01, 0x71, 0x07, 0xF0, 0x77, 0x77, 0x50,
  0x9F, 0x06, 0x71, 0x0C, 0xF0, 0x37, 0x77, 0x50, 0x4F, 0x0B, 0x70, 0x1F, 0x0D, 0x77, 0x77, 0x0E,
  0xF0, 0x16, 0x06, 0xF0, 0x97, 0x77, 0x70, 0xAF, 0x06, 0x60, 0xBF, 0x04, 0x77, 0x77, 0x05, 0xF0,
  0xB5, 0x01, 0xF0, 0xE7, 0x77, 0x71, 0x01, 0xF9, 0x01, 0x40, 0x6F, 0x0A, 0x77, 0x77, 0x20, 0xBF,
  0x06, 0x40, 0xBF, 0x05, 0x77, 0x77, 0x20, 0x7F, 0x0B, 0x30, 0x1F, 0x90, 0x17, 0x77, 0x72, 0x02,
  0xF9, 0x01, 0x20, 0x6F, 0x0B, 0x77, 0x77, 0x40, 0xDF, 0x05, 0x20, 0xBF, 0x06, 0x77, 0x77, 0x40,
  0x8F, 0x81, 0xB0, 0x1F, 0x90, 0x27, 0x77, 0x74, 0x03, 0xF9, 0x01,
  // "Â" (U+00C2)
  0x77, 0x70, 0x28, 0x04, 0x78, 0x0C, 0x70, 0x0C, 0xF9, 0x08, 0x80, 0xC5, 0x00, 0x6F, 0xB0, 0x38,
  0x0C, 0x30, 0x03, 0xFC, 0x0D, 0x01, 0x80, 0xC2, 0x00, 0xDF, 0xD0, 0xA8, 0x0C, 0x10, 0x0B, 0xFF,
  0x07, 0x77, 0x77, 0x70, 0x8F, 0x0A, 0x0D, 0xF0, 0x57, 0x77, 0x75, 0x06, 0xF8, 0x29, 0x01, 0xDF,
  0x03, 0x77, 0x77, 0x30, 0x4F, 0x09, 0x30, 0x10, 0xDE, 0x0E, 0x02, 0x77, 0x77, 0x10, 0x20, 0xEE,
  0x09, 0x50, 0x10, 0xCE, 0x0D, 0x01, 0x77, 0x76, 0x01, 0x0D, 0xE0, 0x87, 0x01, 0x0C, 0xE0, 0xC7,
  0x77, 0x60, 0xCE, 0x08, 0x72, 0x01, 0x0B, 0xE0, 0xB7, 0x77, 0x40, 0xBE, 0x06, 0x75, 0x0A, 0xE0,
  0xA7, 0x77, 0x20, 0xAD, 0x0E, 0x04, 0x77, 0x07, 0xE0, 0xA7, 0x77, 0x03, 0xD0, 0xB0, 0x17, 0x72,
  0x03, 0x0D, 0xD0, 0x38, 0x0D, 0xA3, 0x00, 0x7F, 0x90, 0x68, 0x0C, 0x60, 0x0C, 0xF9, 0x0B, 0x80,
  0xC5, 0x00, 0x2F, 0xB0, 0x18, 0x0C, 0x40, 0x07, 0xFB, 0x05, 0x80, 0xC4, 0x00, 0xCF, 0xB0, 0xB8,
  0x0C, 0x30, 0x01, 0xFD, 0x80, 0xC3, 0x00, 0x6F, 0xD0, 0x58, 0x0C, 0x20, 0x0B, 0xFD, 0x0A, 0x80,
  0xC1, 0x00, 0x1E, 0x0E, 0xF8, 0x0C, 0x10, 0x06, 0xE0, 0xA0, 0xCE, 0x05, 0x80, 0xC0, 0x00, 0xBE,
  0x07, 0x08, 0xE0, 0xA7, 0x77, 0x77, 0x01, 0xF0, 0x30, 0x4E, 0x0E, 0x77, 0x77, 0x70, 0x6E, 0x0E,
  0x2F, 0x05, 0x77, 0x77, 0x60, 0xBE, 0x0A, 0x20, 0xCE, 0x0A, 0x77, 0x77, 0x50, 0x1F, 0x06, 0x20,
  0x7E, 0x0E, 0x77, 0x77, 0x50, 0x5F, 0x01, 0x20, 0x3F, 0x04, 0x77, 0x77, 0x40, 0xAE, 0x0C, 0x40,
  0xDE, 0x09, 0x77, 0x77, 0x4F, 0x07, 0x40, 0x9E, 0x0E, 0x77, 0x77, 0x30, 0x5F, 0x03, 0x40, 0x4F,
  0x04, 0x77, 0x77, 0x20, 0xAE, 0x0D, 0x60, 0xEE, 0x09, 0x77, 0x77, 0x20, 0xEE, 0x08, 0x60, 0xAE,
  0x0E, 0x77, 0x77, 0x10, 0x5F, 0x03, 0x60, 0x5F, 0x04, 0x77, 0x77, 0x0A, 0xE0, 0xE7, 0x1F, 0x09,
  0x77, 0x77, 0x0E, 0xE0, 0x97, 0x10, 0xBE, 0x0E, 0x77, 0x76, 0x04, 0xF0, 0x47, 0x10, 0x6F, 0x04,
  0x77, 0x75, 0x09, 0xE0, 0xE7, 0x20, 0x1F, 0x09, 0x77, 0x75, 0x0E, 0xE0, 0xA7, 0x30, 0xBE, 0x0E,
  0x77, 0x74, 0x04, 0xF0, 0x57, 0x30, 0x7F, 0x03, 0x77, 0x73, 0x09, 0xF0, 0x17, 0x30, 0x2F, 0x08,
  0x77, 0x73, 0x0E, 0xE0, 0xB7, 0x50, 0xCE, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0x67, 0x50, 0x7F, 0x03,
  0x77, 0x71, 0x09, 0xF0, 0x17, 0x50, 0x2F, 0x08, 0x77, 0x71, 0x0E, 0xE0, 0xC7, 0x70, 0xDE, 0x0D,
  0x77, 0x70, 0x3F, 0x07, 0x77, 0x08, 0xF0, 0x37, 0x76, 0x08, 0xF0, 0x27, 0x70, 0x3F, 0x08, 0x77,
  0x60, 0xDE, 0x0C, 0x77, 0x20, 0xEE, 0x0D, 0x77, 0x50, 0x3F, 0x08, 0x77, 0x20, 0x9F, 0x03, 0x77,
  0x40, 0x8F, 0xFF, 0xFC, 0x08, 0x77, 0x40, 0xDF, 0xFF, 0xFC, 0x0D, 0x77, 0x30, 0x3F, 0xFF, 0xFE,
  0x02, 0x77, 0x20, 0x8F, 0xFF, 0xFE, 0x07, 0x77, 0x20, 0xDF, 0xFF, 0xFE, 0x0C, 0x77, 0x10, 0x28,
  0x0C, 0x0F, 0x02, 0x77, 0x07, 0x80, 0xC0, 0xF0, 0x77, 0x70, 0xDE, 0x0E, 0x77, 0x70, 0x1F, 0x0C,
  0x76, 0x02, 0xF0, 0xA7, 0x77, 0x10, 0xBF, 0x02, 0x75, 0x07, 0xF0, 0x57, 0x77, 0x10, 0x6F, 0x07,
  0x75, 0x0C, 0xF7, 0x77, 0x20, 0x2F, 0x0C, 0x74, 0x02, 0xF0, 0xB7, 0x77, 0x30, 0xCF, 0x01, 0x73,
  0x07, 0xF0, 0x67, 0x77, 0x30, 0x8F, 0x07, 0x73, 0x0C, 0xF0, 0x17, 0x77, 0x30, 0x3F, 0x0C, 0x72,
  0x01, 0xF0, 0xC7, 0x77, 0x50, 0xDF, 0x01, 0x71, 0x07, 0xF0, 0x77, 0x77, 0x50, 0x9F, 0x06, 0x71,
  0x0C, 0xF0, 0x37, 0x77, 0x50, 0x4F, 0x0B, 0x70, 0x1F, 0x0D, 0x77, 0x77, 0x0E, 0xF0, 0x16, 0x06,
  0xF0, 0x97, 0x77, 0x70, 0xAF, 0x06, 0x60, 0xBF, 0x04, 0x77, 0x77, 0x05, 0xF0, 0xB5, 0x01, 0xF0,
  0xE7, 0x77, 0x71, 0x01, 0xF9, 0x01, 0x40, 0x6F, 0x0A, 0x77, 0x77, 0x20, 0xBF, 0x06, 0x40, 0xBF,
  0x05, 0x77, 0x77, 0x20, 0x7F, 0x0B, 0x30, 0x1F, 0x90, 0x17, 0x77, 0x72, 0x02, 0xF9, 0x01, 0x20,
  0x6F, 0x0B, 0x77, 0x77, 0x40, 0xDF, 0x05, 0x20, 0xBF, 0x06, 0x77, 0x77, 0x40, 0x8F, 0x81, 0xB0,
  0x1F, 0x90, 0x27, 0x77, 0x74, 0x03, 0xF9, 0x01,
  // "Ã" (U+00C3)
  0x77, 0x38, 0x44, 0x68, 0x75, 0x17, 0x78, 0x43, 0x88, 0x88, 0x17, 0x77, 0x30, 0x80, 0xEE, 0x0B,
  0x03, 0x75, 0x09, 0xC7, 0x77, 0x20, 0x20, 0xDF, 0xB0, 0xA0, 0x17, 0x30, 0xEB, 0x0D, 0x77, 0x71,
  0x01, 0x0D, 0xFD, 0x0E, 0x07, 0x71, 0x08, 0xC0, 0x97, 0x77, 0x10, 0xBF, 0xF9, 0x0D, 0x06, 0x50,
  0x6D, 0x05, 0x77, 0x70, 0x5F, 0xFC, 0x83, 0xEA, 0x89, 0xDD, 0x0E, 0x77, 0x71, 0x0C, 0xFF, 0xFF,
  0x08, 0x77, 0x70, 0x3D, 0x85, 0xD5, 0x10, 0x15, 0xCF, 0xFA, 0x0E, 0x01, 0x77, 0x70, 0x8C, 0x0D,
  0x01, 0x60, 0x50, 0xDF, 0xF0, 0x57, 0x77, 0x10, 0xCC, 0x04, 0x72, 0x07, 0xFD, 0x07, 0x77, 0x72,
  0x0E, 0xB0, 0xD7, 0x40, 0x20, 0xAF, 0x90, 0xE0, 0x67, 0x77, 0x20, 0x1C, 0x08, 0x76, 0x87, 0x28,
  0xCE, 0xFD, 0xB6, 0x18, 0x0D, 0xB0, 0x00, 0x7F, 0x90, 0x68, 0x0C, 0x60, 0x0C, 0xF9, 0x0B, 0x80,
  0xC5, 0x00, 0x2F, 0xB0, 0x18, 0x0C, 0x40, 0x07, 0xFB, 0x05, 0x80, 0xC4, 0x00, 0xCF, 0xB0, 0xB8,
  0x0C, 0x30, 0x01, 0xFD, 0x80, 0xC3, 0x00, 0x6F, 0xD0, 0x58, 0x0C, 0x20, 0x0B, 0xFD, 0x0A, 0x80,
  0xC1, 0x00, 0x1E, 0x0E, 0xF8, 0x0C, 0x10, 0x06, 0xE0, 0xA0, 0xCE, 0x05, 0x80, 0xC0, 0x00, 0xBE,
  0x07, 0x08, 0xE0, 0xA7, 0x77, 0x77, 0x01, 0xF0, 0x30, 0x4E, 0x0E, 0x77, 0x77, 0x70, 0x6E, 0x0E,
  0x2F, 0x05, 0x77, 0x77, 0x60, 0xBE, 0x0A, 0x20, 0xCE, 0x0A, 0x77, 0x77, 0x50, 0x1F, 0x06, 0x20,
  0x7E, 0x0E, 0x77, 0x77, 0x50, 0x5F, 0x01, 0x20, 0x3F, 0x04, 0x77, 0x77, 0x40, 0xAE, 0x0C, 0x40,
  0xDE, 0x09, 0x77, 0x77, 0x4F, 0x07, 0x40, 0x9E, 0x0E, 0x77, 0x77, 0x30, 0x5F, 0x03, 0x40, 0x4F,
  0x04, 0x77, 0x77, 0x20, 0xAE, 0x0D, 0x60, 0xEE, 0x09, 0x77, 0x77, 0x20, 0xEE, 0x08, 0x60, 0xAE,
  0x0E, 0x77, 0x77, 0x10, 0x5F, 0x03, 0x60, 0x5F, 0x04, 0x77, 0x77, 0x0A, 0xE0, 0xE7, 0x1F, 0x09,
  0x77, 0x77, 0x0E, 0xE0, 0x97, 0x10, 0xBE, 0x0E, 0x77, 0x76, 0x04, 0xF0, 0x47, 0x10, 0x6F, 0x04,
  0x77, 0x75, 0x09, 0xE0, 0xE7, 0x20, 0x1F, 0x09, 0x77, 0x75, 0x0E, 0xE0, 0xA7, 0x30, 0xBE, 0x0E,
  0x77, 0x74, 0x04, 0xF0, 0x57, 0x30, 0x7F, 0x03, 0x77, 0x73, 0x09, 0xF0, 0x17, 0x30, 0x2F, 0x08,
  0x77, 0x73, 0x0E, 0xE0, 0xB7, 0x50, 0xCE, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0x67, 0x50, 0x7F, 0x03,
  0x77, 0x71, 0x09, 0xF0, 0x17, 0x50, 0x2F, 0x08, 0x77, 0x71, 0x0E, 0xE0, 0xC7, 0x70, 0xDE, 0x0D,
  0x77, 0x70, 0x3F, 0x07, 0x77, 0x08, 0xF0, 0x37, 0x76, 0x08, 0xF0, 0x27, 0x70, 0x3F, 0x08, 0x77,
  0x60, 0xDE, 0x0C, 0x77, 0x20, 0xEE, 0x0D, 0x77, 0x50, 0x3F, 0x08, 0x77, 0x20, 0x9F, 0x03, 0x77,
  0x40, 0x8F, 0xFF, 0xFC, 0x08, 0x77, 0x40, 0xDF, 0xFF, 0xFC, 0x0D, 0x77, 0x30, 0x3F, 0xFF, 0xFE,
  0x02, 0x77, 0x20, 0x8F, 0xFF, 0xFE, 0x07, 0x77, 0x20, 0xDF, 0xFF, 0xFE, 0x0C, 0x77, 0x10, 0x28,
  0x0C, 0x0F, 0x02, 0x77, 0x07, 0x80, 0xC0, 0xF0, 0x77, 0x70, 0xDE, 0x0E, 0x77, 0x70, 0x1F, 0x0C,
  0x76, 0x02, 0xF0, 0xA7, 0x77, 0x10, 0xBF, 0x02, 0x75, 0x07, 0xF0, 0x57, 0x77, 0x10, 0x6F, 0x07,
  0x75, 0x0C, 0xF7, 0x77, 0x20, 0x2F, 0x0C, 0x74, 0x02, 0xF0, 0xB7, 0x77, 0x30, 0xCF, 0x01, 0x73,
  0x07, 0xF0, 0x67, 0x77, 0x30, 0x8F, 0x07, 0x73, 0x0C, 0xF0, 0x17, 0x77, 0x30, 0x3F, 0x0C, 0x72,
  0x01, 0xF0, 0xC7, 0x77, 0x50, 0xDF, 0x01, 0x71, 0x07, 0xF0, 0x77, 0x77, 0x50, 0x9F, 0x06, 0x71,
  0x0C, 0xF0, 0x37, 0x77, 0x50, 0x4F, 0x0B, 0x70, 0x1F, 0x0D, 0x77, 0x77, 0x0E, 0xF0, 0x16, 0x06,
  0xF0, 0x97, 0x77, 0x70, 0xAF, 0x06, 0x60, 0xBF, 0x04, 0x77, 0x77, 0x05, 0xF0, 0xB5, 0x01, 0xF0,
  0xE7, 0x77, 0x71, 0x01, 0xF9, 0x01, 0x40, 0x6F, 0x0A, 0x77, 0x77, 0x20, 0xBF, 0x06, 0x40, 0xBF,
  0x05, 0x77, 0x77, 0x20, 0x7F, 0x0B, 0x30, 0x1F, 0x90, 0x17, 0x77, 0x72, 0x02, 0xF9, 0x01, 0x20,
  0x6F, 0x0B, 0x77, 0x77, 0x40, 0xDF, 0x05, 0x20, 0xBF, 0x06, 0x77, 0x77, 0x40, 0x8F, 0x81, 0xB0,
  0x1F, 0x90, 0x27, 0x77, 0x74, 0x03, 0xF9, 0x01,
  // "Ä" (U+00C4)
  0x75, 0x85, 0x18, 0xDF, 0xEB, 0x47, 0x78, 0x53, 0xAE, 0xFD, 0x91, 0x77, 0x72, 0x02, 0x0D, 0xE0,
  0x87, 0x50, 0x6E, 0x0E, 0x03, 0x77, 0x71, 0x0A, 0xF9, 0x03, 0x73, 0x01, 0xF9, 0x0C, 0x77, 0x71,
  0x0E, 0xF9, 0x08, 0x73, 0x05, 0xFA, 0x02, 0x77, 0x60, 0x1F, 0xA0, 0xA7, 0x30, 0x7F, 0xA0, 0x47,
  0x76, 0x01, 0xFA, 0x09, 0x73, 0x07, 0xFA, 0x03, 0x77, 0x70, 0xEF, 0x90, 0x77, 0x30, 0x5F, 0xA0,
  0x17, 0x77, 0x09, 0xF9, 0x02, 0x74, 0x0E, 0xF0, 0xB7, 0x77, 0x10, 0x10, 0xCE, 0x06, 0x75, 0x04,
  0xE0, 0xD0, 0x27, 0x77, 0x38, 0x47, 0xDF, 0xEA, 0x37, 0x78, 0x52, 0xAE, 0xFD, 0x81, 0x80, 0xEF,
  0x50, 0x07, 0xF9, 0x06, 0x80, 0xC6, 0x00, 0xCF, 0x90, 0xB8, 0x0C, 0x50, 0x02, 0xFB, 0x01, 0x80,
  0xC4, 0x00, 0x7F, 0xB0, 0x58, 0x0C, 0x40, 0x0C, 0xFB, 0x0B, 0x80, 0xC3, 0x00, 0x1F, 0xD8, 0x0C,
  0x30, 0x06, 0xFD, 0x05, 0x80, 0xC2, 0x00, 0xBF, 0xD0, 0xA8, 0x0C, 0x10, 0x01, 0xE0, 0xEF, 0x80,
  0xC1, 0x00, 0x6E, 0x0A, 0x0C, 0xE0, 0x58, 0x0C, 0x00, 0x0B, 0xE0, 0x70, 0x8E, 0x0A, 0x77, 0x77,
  0x70, 0x1F, 0x03, 0x04, 0xE0, 0xE7, 0x77, 0x77, 0x06, 0xE0, 0xE2, 0xF0, 0x57, 0x77, 0x76, 0x0B,
  0xE0, 0xA2, 0x0C, 0xE0, 0xA7, 0x77, 0x75, 0x01, 0xF0, 0x62, 0x07, 0xE0, 0xE7, 0x77, 0x75, 0x05,
  0xF0, 0x12, 0x03, 0xF0, 0x47, 0x77, 0x74, 0x0A, 0xE0, 0xC4, 0x0D, 0xE0, 0x97, 0x77, 0x74, 0xF0,
  0x74, 0x09, 0xE0, 0xE7, 0x77, 0x73, 0x05, 0xF0, 0x34, 0x04, 0xF0, 0x47, 0x77, 0x72, 0x0A, 0xE0,
  0xD6, 0x0E, 0xE0, 0x97, 0x77, 0x72, 0x0E, 0xE0, 0x86, 0x0A, 0xE0, 0xE7, 0x77, 0x71, 0x05, 0xF0,
  0x36, 0x05, 0xF0, 0x47, 0x77, 0x70, 0xAE, 0x0E, 0x71, 0xF0, 0x97, 0x77, 0x70, 0xEE, 0x09, 0x71,
  0x0B, 0xE0, 0xE7, 0x77, 0x60, 0x4F, 0x04, 0x71, 0x06, 0xF0, 0x47, 0x77, 0x50, 0x9E, 0x0E, 0x72,
  0x01, 0xF0, 0x97, 0x77, 0x50, 0xEE, 0x0A, 0x73, 0x0B, 0xE0, 0xE7, 0x77, 0x40, 0x4F, 0x05, 0x73,
  0x07, 0xF0, 0x37, 0x77, 0x30, 0x9F, 0x01, 0x73, 0x02, 0xF0, 0x87, 0x77, 0x30, 0xEE, 0x0B, 0x75,
  0x0C, 0xE0, 0xD7, 0x77, 0x20, 0x4F, 0x06, 0x75, 0x07, 0xF0, 0x37, 0x77, 0x10, 0x9F, 0x01, 0x75,
  0x02, 0xF0, 0x87, 0x77, 0x10, 0xEE, 0x0C, 0x77, 0x0D, 0xE0, 0xD7, 0x77, 0x03, 0xF0, 0x77, 0x70,
  0x8F, 0x03, 0x77, 0x60, 0x8F, 0x02, 0x77, 0x03, 0xF0, 0x87, 0x76, 0x0D, 0xE0, 0xC7, 0x72, 0x0E,
  0xE0, 0xD7, 0x75, 0x03, 0xF0, 0x87, 0x72, 0x09, 0xF0, 0x37, 0x74, 0x08, 0xFF, 0xFF, 0xC0, 0x87,
  0x74, 0x0D, 0xFF, 0xFF, 0xC0, 0xD7, 0x73, 0x03, 0xFF, 0xFF, 0xE0, 0x27, 0x72, 0x08, 0xFF, 0xFF,
  0xE0, 0x77, 0x72, 0x0D, 0xFF, 0xFF, 0xE0, 0xC7, 0x71, 0x02, 0x80, 0xC0, 0xF0, 0x27, 0x70, 0x78,
  0x0C, 0x0F, 0x07, 0x77, 0x0D, 0xE0, 0xE7, 0x77, 0x01, 0xF0, 0xC7, 0x60, 0x2F, 0x0A, 0x77, 0x71,
  0x0B, 0xF0, 0x27, 0x50, 0x7F, 0x05, 0x77, 0x71, 0x06, 0xF0, 0x77, 0x50, 0xCF, 0x77, 0x72, 0x02,
  0xF0, 0xC7, 0x40, 0x2F, 0x0B, 0x77, 0x73, 0x0C, 0xF0, 0x17, 0x30, 0x7F, 0x06, 0x77, 0x73, 0x08,
  0xF0, 0x77, 0x30, 0xCF, 0x01, 0x77, 0x73, 0x03, 0xF0, 0xC7, 0x20, 0x1F, 0x0C, 0x77, 0x75, 0x0D,
  0xF0, 0x17, 0x10, 0x7F, 0x07, 0x77, 0x75, 0x09, 0xF0, 0x67, 0x10, 0xCF, 0x03, 0x77, 0x75, 0x04,
  0xF0, 0xB7, 0x01, 0xF0, 0xD7, 0x77, 0x70, 0xEF, 0x01, 0x60, 0x6F, 0x09, 0x77, 0x77, 0x0A, 0xF0,
  0x66, 0x0B, 0xF0, 0x47, 0x77, 0x70, 0x5F, 0x0B, 0x50, 0x1F, 0x0E, 0x77, 0x77, 0x10, 0x1F, 0x90,
  0x14, 0x06, 0xF0, 0xA7, 0x77, 0x72, 0x0B, 0xF0, 0x64, 0x0B, 0xF0, 0x57, 0x77, 0x72, 0x07, 0xF0,
  0xB3, 0x01, 0xF9, 0x01, 0x77, 0x77, 0x20, 0x2F, 0x90, 0x12, 0x06, 0xF0, 0xB7, 0x77, 0x74, 0x0D,
  0xF0, 0x52, 0x0B, 0xF0, 0x67, 0x77, 0x74, 0x08, 0xF8, 0x1B, 0x01, 0xF9, 0x02, 0x77, 0x77, 0x40,
  0x3F, 0x90, 0x10,
  // "Å" (U+00C5)
  0x77, 0x78, 0x90, 0x28, 0xBD, 0xFE, 0xDA, 0x71, 0x80, 0xC4, 0x00, 0x10, 0xAF, 0xB0, 0x88, 0x0C,
  0x20, 0x03, 0x0E, 0xFD, 0x0D, 0x02, 0x77, 0x77, 0x70, 0x20, 0xEF, 0xF0, 0xD0, 0x17, 0x77, 0x76,
  0x0B, 0xFF, 0xA0, 0xA7, 0x77, 0x75, 0x03, 0xE0, 0x80, 0x22, 0x03, 0x09, 0xE0, 0x27, 0x77, 0x74,
  0x07, 0xD0, 0x46, 0x05, 0xD0, 0x77, 0x77, 0x74, 0x0B, 0xC0, 0x87, 0x10, 0xAC, 0x0B, 0x77, 0x77,
  0x40, 0xCC, 0x03, 0x71, 0x05, 0xC0, 0xC7, 0x77, 0x74, 0x0D, 0xC0, 0x27, 0x10, 0x4C, 0x0D, 0x77,
  0x77, 0x40, 0xCC, 0x03, 0x71, 0x05, 0xC0, 0xC7, 0x77, 0x74, 0x0B, 0xC0, 0x87, 0x10, 0xAC, 0x0A,
  0x77, 0x77, 0x40, 0x7D, 0x03, 0x60, 0x5D, 0x07, 0x77, 0x77, 0x40, 0x2E, 0x08, 0x02, 0x20, 0x30,
  0x9E, 0x02, 0x77, 0x77, 0x50, 0xAF, 0xFA, 0x09, 0x77, 0x77, 0x60, 0x10, 0xEF, 0xF0, 0xD0, 0x17,
  0x77, 0x77, 0x03, 0x0E, 0xFD, 0x0D, 0x02, 0x80, 0xC1, 0x00, 0x10, 0xAF, 0xB0, 0x98, 0x0C, 0x50,
  0x89, 0x02, 0x8B, 0xDF, 0xED, 0xB7, 0x18, 0x0D, 0xB6, 0x00, 0x7F, 0x90, 0x68, 0x0C, 0x60, 0x0C,
  0xF9, 0x0B, 0x80, 0xC5, 0x00, 0x2F, 0xB0, 0x18, 0x0C, 0x40, 0x07, 0xFB, 0x05, 0x80, 0xC4, 0x00,
  0xCF, 0xB0, 0xB8, 0x0C, 0x30, 0x01, 0xFD, 0x80, 0xC3, 0x00, 0x6F, 0xD0, 0x58, 0x0C, 0x20, 0x0B,
  0xFD, 0x0A, 0x80, 0xC1, 0x00, 0x1E, 0x0E, 0xF8, 0x0C, 0x10, 0x06, 0xE0, 0xA0, 0xCE, 0x05, 0x80,
  0xC0, 0x00, 0xBE, 0x07, 0x08, 0xE0, 0xA7, 0x77, 0x77, 0x01, 0xF0, 0x30, 0x4E, 0x0E, 0x77, 0x77,
  0x70, 0x6E, 0x0E, 0x2F, 0x05, 0x77, 0x77, 0x60, 0xBE, 0x0A, 0x20, 0xCE, 0x0A, 0x77, 0x77, 0x50,
  0x1F, 0x06, 0x20, 0x7E, 0x0E, 0x77, 0x77, 0x50, 0x5F, 0x01, 0x20, 0x3F, 0x04, 0x77, 0x77, 0x40,
  0xAE, 0x0C, 0x40, 0xDE, 0x09, 0x77, 0x77, 0x4F, 0x07, 0x40, 0x9E, 0x0E, 0x77, 0x77, 0x30, 0x5F,
  0x03, 0x40, 0x4F, 0x04, 0x77, 0x77, 0x20, 0xAE, 0x0D, 0x60, 0xEE, 0x09, 0x77, 0x77, 0x20, 0xEE,
  0x08, 0x60, 0xAE, 0x0E, 0x77, 0x77, 0x10, 0x5F, 0x03, 0x60, 0x5F, 0x04, 0x77, 0x77, 0x0A, 0xE0,
  0xE7, 0x1F, 0x09, 0x77, 0x77, 0x0E, 0xE0, 0x97, 0x10, 0xBE, 0x0E, 0x77, 0x76, 0x04, 0xF0, 0x47,
  0x10, 0x6F, 0x04, 0x77, 0x75, 0x09, 0xE0, 0xE7, 0x20, 0x1F, 0x09, 0x77, 0x75, 0x0E, 0xE0, 0xA7,
  0x30, 0xBE, 0x0E, 0x77, 0x74, 0x04, 0xF0, 0x57, 0x30, 0x7F, 0x03, 0x77, 0x73, 0x09, 0xF0, 0x17,
  0x30, 0x2F, 0x08, 0x77, 0x73, 0x0E, 0xE0, 0xB7, 0x50, 0xCE, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0x67,
  0x50, 0x7F, 0x03, 0x77, 0x71, 0x09, 0xF0, 0x17, 0x50, 0x2F, 0x08, 0x77, 0x71, 0x0E, 0xE0, 0xC7,
  0x70, 0xDE, 0x0D, 0x77, 0x70, 0x3F, 0x07, 0x77, 0x08, 0xF0, 0x37, 0x76, 0x08, 0xF0, 0x27, 0x70,
  0x3F, 0x08, 0x77, 0x60, 0xDE, 0x0C, 0x77, 0x20, 0xEE, 0x0D, 0x77, 0x50, 0x3F, 0x08, 0x77, 0x20,
  0x9F, 0x03, 0x77, 0x40, 0x8F, 0xFF, 0xFC, 0x08, 0x77, 0x40, 0xDF, 0xFF, 0xFC, 0x0D, 0x77, 0x30,
  0x3F, 0xFF, 0xFE, 0x02, 0x77, 0x20, 0x8F, 0xFF, 0xFE, 0x07, 0x77, 0x20, 0xDF, 0xFF, 0xFE, 0x0C,
  0x77, 0x10, 0x28, 0x0C, 0x0F, 0x02, 0x77, 0x07, 0x80, 0xC0, 0xF0, 0x77, 0x70, 0xDE, 0x0E, 0x77,
  0x70, 0x1F, 0x0C, 0x76, 0x02, 0xF0, 0xA7, 0x77, 0x10, 0xBF, 0x02, 0x75, 0x07, 0xF0, 0x57, 0x77,
  0x10, 0x6F, 0x07, 0x75, 0x0C, 0xF7, 0x77, 0x20, 0x2F, 0x0C, 0x74, 0x02, 0xF0, 0xB7, 0x77, 0x30,
  0xCF, 0x01, 0x73, 0x07, 0xF0, 0x67, 0x77, 0x30, 0x8F, 0x07, 0x73, 0x0C, 0xF0, 0x17, 0x77, 0x30,
  0x3F, 0x0C, 0x72, 0x01, 0xF0, 0xC7, 0x77, 0x50, 0xDF, 0x01, 0x71, 0x07, 0xF0, 0x77, 0x77, 0x50,
  0x9F, 0x06, 0x71, 0x0C, 0xF0, 0x37, 0x77, 0x50, 0x4F, 0x0B, 0x70, 0x1F, 0x0D, 0x77, 0x77, 0x0E,
  0xF0, 0x16, 0x06, 0xF0, 0x97, 0x77, 0x70, 0xAF, 0x06, 0x60, 0xBF, 0x04, 0x77, 0x77, 0x05, 0xF0,
  0xB5, 0x01, 0xF0, 0xE7, 0x77, 0x71, 0x01, 0xF9, 0x01, 0x40, 0x6F, 0x0A, 0x77, 0x77, 0x20, 0xBF,
  0x06, 0x40, 0xBF, 0x05, 0x77, 0x77, 0x20, 0x7F, 0x0B, 0x30, 0x1F, 0x90, 0x17, 0x77, 0x72, 0x02,
  0xF9, 0x01, 0x20, 0x6F, 0x0B, 0x77, 0x77, 0x40, 0xDF, 0x05, 0x20, 0xBF, 0x06, 0x77, 0x77, 0x40,
  0x8F, 0x81, 0xB0, 0x1F, 0x90, 0x27, 0x77, 0x74, 0x03, 0xF9, 0x01,
  // "Æ" (U+00C6)
  0x77, 0x10, 0xEF, 0xFF, 0xFB, 0x0D, 0x77, 0x02, 0xFF, 0xFF, 0xC0, 0xD7, 0x70, 0x5F, 0xFF, 0xFC,
  0x0D, 0x77, 0x09, 0xFF, 0xFF, 0xC0, 0xD7, 0x70, 0xCF, 0xFF, 0xFC, 0x0D, 0x77, 0xFF, 0xFF, 0xD0,
  0xD7, 0x60, 0x4F, 0xFF, 0xFD, 0x0D, 0x76, 0x07, 0xE0, 0xA2, 0x01, 0xF0, 0xA7, 0x77, 0x71, 0x0B,
  0xE0, 0x72, 0x01, 0xF0, 0xA7, 0x77, 0x71, 0x0E, 0xE0, 0x32, 0x01, 0xF0, 0xA7, 0x77, 0x70, 0x2F,
  0x30, 0x1F, 0x0A, 0x77, 0x77, 0x06, 0xE0, 0xC3, 0x01, 0xF0, 0xA7, 0x77, 0x70, 0x9E, 0x09, 0x30,
  0x1F, 0x0A, 0x77, 0x77, 0x0D, 0xE0, 0x63, 0x01, 0xF0, 0xA7, 0x77, 0x60, 0x1F, 0x02, 0x30, 0x1F,
  0x0A, 0x77, 0x76, 0x04, 0xE0, 0xE4, 0x01, 0xF0, 0xA7, 0x77, 0x60, 0x7E, 0x0B, 0x40, 0x1F, 0x0A,
  0x77, 0x76, 0x0B, 0xE0, 0x84, 0x01, 0xF0, 0xA7, 0x77, 0x60, 0xEE, 0x05, 0x40, 0x1F, 0x0A, 0x77,
  0x75, 0x02, 0xF0, 0x14, 0x01, 0xF0, 0xA7, 0x77, 0x50, 0x6E, 0x0E, 0x50, 0x1F, 0x0A, 0x77, 0x75,
  0x09, 0xE0, 0xA5, 0x01, 0xF0, 0xA7, 0x77, 0x50, 0xDE, 0x07, 0x50, 0x1F, 0x0A, 0x77, 0x74, 0x01,
  0xF0, 0x45, 0x01, 0xF0, 0xA7, 0x77, 0x40, 0x4F, 0x60, 0x1F, 0x0A, 0x77, 0x74, 0x08, 0xE0, 0xD6,
  0x01, 0xF0, 0xA7, 0x77, 0x40, 0xBE, 0x09, 0x60, 0x1F, 0x0A, 0x77, 0x74, 0xF0, 0x66, 0x01, 0xFF,
  0xF9, 0x02, 0x72, 0x03, 0xF0, 0x36, 0x01, 0xFF, 0xF9, 0x02, 0x72, 0x06, 0xF7, 0x01, 0xFF, 0xF9,
  0x02, 0x72, 0x0A, 0xE0, 0xC7, 0x01, 0xFF, 0xF9, 0x02, 0x72, 0x0D, 0xE0, 0x87, 0x01, 0xFF, 0xF9,
  0x02, 0x71, 0x01, 0xF0, 0x57, 0x01, 0xFF, 0xF9, 0x02, 0x71, 0x05, 0xF0, 0x27, 0x01, 0xF0, 0xD8,
  0x09, 0x28, 0x01, 0x71, 0x08, 0xE0, 0xE7, 0x10, 0x1F, 0x0A, 0x77, 0x72, 0x0C, 0xE0, 0xB7, 0x10,
  0x1F, 0x0A, 0x77, 0x72, 0xF0, 0x77, 0x10, 0x1F, 0x0A, 0x77, 0x71, 0x03, 0xF0, 0xA8, 0x05, 0x8F,
  0x0A, 0x77, 0x71, 0x07, 0xFF, 0xFB, 0x0A, 0x77, 0x71, 0x0A, 0xFF, 0xFB, 0x0A, 0x77, 0x71, 0x0E,
  0xFF, 0xFB, 0x0A, 0x77, 0x70, 0x2F, 0xFF, 0xC0, 0xA7, 0x77, 0x05, 0xFF, 0xFC, 0x0A, 0x77, 0x70,
  0x9F, 0xFF, 0xC0, 0xA7, 0x77, 0x0C, 0xE0, 0xB7, 0x30, 0x1F, 0x0A, 0x77, 0x7F, 0x08, 0x73, 0x01,
  0xF0, 0xA7, 0x76, 0x04, 0xF0, 0x57, 0x30, 0x1F, 0x0A, 0x77, 0x60, 0x7F, 0x01, 0x73, 0x01, 0xF0,
  0xA7, 0x76, 0x0B, 0xE0, 0xE7, 0x40, 0x1F, 0x0A, 0x77, 0x60, 0xEE, 0x0A, 0x74, 0x01, 0xF0, 0xA7,
  0x75, 0x02, 0xF0, 0x77, 0x40, 0x1F, 0x0A, 0x77, 0x50, 0x6F, 0x04, 0x74, 0x01, 0xF0, 0xA7, 0x75,
  0x09, 0xF0, 0x17, 0x40, 0x1F, 0x0A, 0x77, 0x50, 0xDE, 0x0D, 0x75, 0x01, 0xF0, 0xA7, 0x74, 0x01,
  0xF0, 0x97, 0x50, 0x1F, 0x0A, 0x77, 0x40, 0x4F, 0x06, 0x75, 0x01, 0xF0, 0xA7, 0x74, 0x08, 0xF0,
  0x37, 0x50, 0x1F, 0x0A, 0x77, 0x40, 0xBF, 0x76, 0x01, 0xFF, 0xFA, 0x0D, 0x20, 0xEE, 0x0C, 0x76,
  0x01, 0xFF, 0xFA, 0x81, 0xD0, 0x3F, 0x08, 0x76, 0x01, 0xFF, 0xFA, 0x81, 0xD0, 0x6F, 0x05, 0x76,
  0x01, 0xFF, 0xFA, 0x81, 0xD0, 0x9F, 0x02, 0x76, 0x01, 0xFF, 0xFA, 0x81, 0xD0, 0xDE, 0x0E, 0x77,
  0x01, 0xFF, 0xFA, 0x0D, 0x01, 0xF0, 0xB7, 0x70, 0x1F, 0xFF, 0xA0, 0xD0,
  // "Ç" (U+00C7)
  0x77, 0x58, 0x97, 0x14, 0x7A, 0xCD, 0xDE, 0xFE, 0xDC, 0xB9, 0x74, 0x17, 0x77, 0x38, 0x11, 0x6B,
  0xFF, 0xB8, 0x1D, 0x94, 0x77, 0x50, 0x20, 0xAF, 0xFF, 0xA8, 0x1E, 0x92, 0x77, 0x01, 0x09, 0xFF,
  0xFF, 0x0B, 0x02, 0x74, 0x04, 0x0E, 0xFF, 0xFF, 0xA0, 0x27, 0x30, 0x8F, 0xFF, 0xFB, 0x0B, 0x73,
  0x0A, 0xFF, 0xFF, 0xC0, 0x47, 0x20, 0xAF, 0xD8, 0x3C, 0x85, 0x21, 0x28, 0x41, 0x23, 0x6A, 0xDF,
  0x0D, 0x72, 0x09, 0xFB, 0x81, 0xE8, 0x17, 0x68, 0x12, 0x7D, 0xC0, 0x77, 0x10, 0x6F, 0xB0, 0x90,
  0x17, 0x74, 0x83, 0x4C, 0xFE, 0x17, 0x02, 0x0E, 0xF9, 0x0E, 0x04, 0x77, 0x71, 0x05, 0x07, 0x71,
  0x0C, 0xF9, 0x0E, 0x03, 0x77, 0x77, 0x40, 0x6F, 0x90, 0xE0, 0x37, 0x77, 0x75, 0x0D, 0xF9, 0x05,
  0x77, 0x77, 0x50, 0x6F, 0x90, 0x97, 0x77, 0x76, 0x0D, 0xF0, 0xE0, 0x17, 0x77, 0x75, 0x04, 0xF9,
  0x07, 0x77, 0x77, 0x60, 0x9F, 0x0E, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x60, 0x4F, 0x90,
  0x37, 0x77, 0x76, 0x08, 0xF0, 0xD7, 0x77, 0x77, 0x0C, 0xF0, 0x97, 0x77, 0x77, 0xF9, 0x05, 0x77,
  0x77, 0x60, 0x3F, 0x90, 0x17, 0x77, 0x76, 0x06, 0xF0, 0xE7, 0x77, 0x77, 0x08, 0xF0, 0xB7, 0x77,
  0x77, 0x0A, 0xF0, 0x97, 0x77, 0x77, 0x0C, 0xF0, 0x77, 0x77, 0x77, 0x0D, 0xF0, 0x67, 0x77, 0x77,
  0x0E, 0xF0, 0x57, 0x77, 0x77, 0x0E, 0xF0, 0x47, 0x77, 0x77, 0xF9, 0x04, 0x77, 0x77, 0x7F, 0x90,
  0x37, 0x77, 0x77, 0xF9, 0x03, 0x77, 0x77, 0x7F, 0x90, 0x37, 0x77, 0x77, 0xF9, 0x04, 0x77, 0x77,
  0x70, 0xEF, 0x04, 0x77, 0x77, 0x70, 0xDF, 0x06, 0x77, 0x77, 0x70, 0xCF, 0x07, 0x77, 0x77, 0x70,
  0xAF, 0x08, 0x77, 0x77, 0x70, 0x8F, 0x0A, 0x77, 0x77, 0x70, 0x6F, 0x0D, 0x77, 0x77, 0x70, 0x4F,
  0x97, 0x77, 0x77, 0x01, 0xF9, 0x03, 0x77, 0x77, 0x70, 0xDF, 0x07, 0x77, 0x77, 0x70, 0xAF, 0x0B,
  0x77, 0x77, 0x70, 0x6F, 0x97, 0x77, 0x77, 0x01, 0xF9, 0x05, 0x77, 0x77, 0x70, 0xCF, 0x0B, 0x77,
  0x77, 0x70, 0x7F, 0x90, 0x37, 0x77, 0x76, 0x02, 0xF9, 0x0A, 0x77, 0x77, 0x70, 0xAF, 0x90, 0x47,
  0x77, 0x76, 0x03, 0xF9, 0x0D, 0x77, 0x77, 0x70, 0xBF, 0x90, 0xA7, 0x77, 0x76, 0x02, 0xFA, 0x08,
  0x77, 0x77, 0x60, 0x7F, 0xA0, 0x97, 0x77, 0x76, 0x0C, 0xFA, 0x0C, 0x03, 0x77, 0x70, 0x50, 0x77,
  0x20, 0x20, 0xEF, 0xB0, 0xB0, 0x47, 0x71, 0x84, 0x25, 0xAE, 0xFA, 0x73, 0x03, 0x0E, 0xFC, 0x84,
  0xEA, 0x64, 0x21, 0x28, 0x51, 0x23, 0x57, 0xAD, 0xD0, 0xA7, 0x40, 0x40, 0xEF, 0xFF, 0xFA, 0x0A,
  0x75, 0x03, 0x0D, 0xFF, 0xFF, 0x90, 0xA7, 0x60, 0x10, 0xCF, 0xFF, 0xF0, 0xA7, 0x71, 0x07, 0x0E,
  0xFF, 0xFD, 0x0A, 0x77, 0x28, 0x11, 0x8E, 0xFF, 0xFA, 0x0E, 0x07, 0x77, 0x50, 0x50, 0xAF, 0xFC,
  0x81, 0xC8, 0x37, 0x77, 0x38, 0x23, 0x69, 0xBE, 0x84, 0xED, 0xB9, 0x74, 0x77, 0x77, 0x40, 0xAC,
  0x09, 0x80, 0xC1, 0x00, 0x2D, 0x02, 0x80, 0xC1, 0x00, 0x9C, 0x0B, 0x80, 0xC1, 0x00, 0x1D, 0x04,
  0x80, 0xC1, 0x00, 0x8D, 0x07, 0x02, 0x77, 0x77, 0x70, 0x10, 0xEF, 0x0C, 0x05, 0x77, 0x77, 0x50,
  0x7F, 0xB0, 0xC0, 0x27, 0x77, 0x73, 0x82, 0x47, 0xAD, 0xF9, 0x0E, 0x03, 0x77, 0x77, 0x68, 0x13,
  0x8E, 0xE0, 0xC8, 0x0C, 0x00, 0x01, 0x0C, 0xE0, 0x48, 0x0C, 0x00, 0x01, 0xE0, 0x88, 0x0C, 0x10,
  0x0B, 0xD0, 0xA8, 0x0C, 0x10, 0x0A, 0xD0, 0xA8, 0x0C, 0x10, 0x0D, 0xD0, 0x98, 0x0C, 0x00, 0x08,
  0xE0, 0x57, 0x77, 0x58, 0x14, 0x21, 0x38, 0x21, 0x37, 0xCE, 0x0E, 0x77, 0x75, 0x01, 0xFF, 0xA0,
  0x67, 0x77, 0x50, 0x1F, 0xF9, 0x0A, 0x77, 0x76, 0x01, 0xFF, 0x08, 0x77, 0x77, 0x01, 0xFC, 0x81,
  0xEA, 0x27, 0x77, 0x72, 0x81, 0xAD, 0xEA, 0x84, 0xEE, 0xDA, 0x85, 0x77, 0x20,
  // "È" (U+00C8)
  0x71, 0x80, 0x57, 0x04, 0x77, 0x77, 0x10, 0xEF, 0x90, 0xE7, 0x77, 0x71, 0x04, 0xFA, 0x07, 0x77,
  0x77, 0x10, 0x8F, 0x90, 0xE0, 0x17, 0x77, 0x71, 0x0B, 0xF9, 0x0A, 0x77, 0x77, 0x20, 0xCF, 0x90,
  0x47, 0x77, 0x71, 0x01, 0x0D, 0xF0, 0xD7, 0x77, 0x72, 0x02, 0x0E, 0xF0, 0x87, 0x77, 0x72, 0x03,
  0x0E, 0xF0, 0x37, 0x77, 0x72, 0x03, 0x0E, 0xE0, 0xC7, 0x77, 0x73, 0x03, 0x0E, 0xE0, 0x87, 0x77,
  0x73, 0x03, 0x0E, 0xE0, 0x47, 0x77, 0x73, 0x03, 0x0E, 0xD0, 0xE0, 0x17, 0x77, 0x73, 0x02, 0x0D,
  0xD0, 0xB7, 0x77, 0x74, 0x01, 0x0B, 0xD0, 0x18, 0x0B, 0xE2, 0x00, 0x78, 0x0C, 0x1F, 0x05, 0x07,
  0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05, 0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F,
  0x05, 0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07,
  0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0,
  0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7,
  0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77,
  0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72,
  0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07,
  0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xFF,
  0xFF, 0xF0, 0x92, 0x07, 0xFF, 0xFF, 0xF0, 0x92, 0x07, 0xFF, 0xFF, 0xF0, 0x92, 0x07, 0xFF, 0xFF,
  0xF0, 0x92, 0x07, 0xFF, 0xFF, 0xF0, 0x92, 0x07, 0xFF, 0xFF, 0xF0, 0x92, 0x07, 0xFF, 0xFF, 0xF0,
  0x92, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72,
  0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07,
  0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0,
  0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7,
  0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77,
  0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72,
  0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07,
  0xF0, 0xA7, 0x77, 0x72, 0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05, 0x07, 0x80, 0xC1,
  0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05, 0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05, 0x07,
  0x80, 0xC1, 0xF0, 0x50,
  // "É" (U+00C9)
  0x77, 0x73, 0x03, 0x80, 0x57, 0x01, 0x77, 0x77, 0x0C, 0xFA, 0x02, 0x77, 0x76, 0x05, 0xFA, 0x08,
  0x77, 0x77, 0x0D, 0xF9, 0x0B, 0x77, 0x77, 0x08, 0xF9, 0x0D, 0x01, 0x77, 0x76, 0x02, 0xF9, 0x0E,
  0x02, 0x77, 0x77, 0x0C, 0xF0, 0xE0, 0x37, 0x77, 0x70, 0x6F, 0x90, 0x47, 0x77, 0x70, 0x10, 0xEF,
  0x05, 0x77, 0x77, 0x10, 0xBF, 0x05, 0x77, 0x77, 0x10, 0x5F, 0x06, 0x77, 0x77, 0x10, 0x10, 0xEE,
  0x05, 0x77, 0x77, 0x20, 0xBE, 0x05, 0x77, 0x77, 0x20, 0x8D, 0x0E, 0x04, 0x77, 0x77, 0x30, 0xDC,
  0x0C, 0x02, 0x80, 0xBE, 0x60, 0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05, 0x07, 0x80,
  0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05, 0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05,
  0x07, 0x80, 0xC1, 0xF0, 0x50, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F,
  0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A,
  0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77,
  0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77,
  0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20,
  0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F,
  0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0xFF, 0xFF, 0x09, 0x20, 0x7F, 0xFF,
  0xFF, 0x09, 0x20, 0x7F, 0xFF, 0xFF, 0x09, 0x20, 0x7F, 0xFF, 0xFF, 0x09, 0x20, 0x7F, 0xFF, 0xFF,
  0x09, 0x20, 0x7F, 0xFF, 0xFF, 0x09, 0x20, 0x7F, 0xFF, 0xFF, 0x09, 0x20, 0x7F, 0x0A, 0x77, 0x77,
  0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20,
  0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F,
  0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A,
  0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77,
  0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77,
  0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20,
  0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x78,
  0x0C, 0x1F, 0x05, 0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05, 0x07, 0x80, 0xC1, 0xF0,
  0x50, 0x78, 0x0C, 0x1F, 0x05, 0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05,
  // "Ê" (U+00CA)
  0x77, 0x10, 0x28, 0x04, 0x77, 0x77, 0x72, 0x0C, 0xF9, 0x08, 0x77, 0x77, 0x06, 0xFB, 0x03, 0x77,
  0x75, 0x03, 0xFC, 0x0D, 0x01, 0x77, 0x74, 0x0D, 0xFD, 0x0A, 0x77, 0x73, 0x0B, 0xFF, 0x07, 0x77,
  0x71, 0x08, 0xF0, 0xA0, 0xDF, 0x05, 0x77, 0x60, 0x6F, 0x82, 0x90, 0x1D, 0xF0, 0x37, 0x74, 0x04,
  0xF0, 0x93, 0x01, 0x0D, 0xE0, 0xE0, 0x27, 0x72, 0x02, 0x0E, 0xE0, 0x95, 0x01, 0x0C, 0xE0, 0xD0,
  0x17, 0x70, 0x10, 0xDE, 0x08, 0x70, 0x10, 0xCE, 0x0C, 0x77, 0x0C, 0xE0, 0x87, 0x20, 0x10, 0xBE,
  0x0B, 0x75, 0x0B, 0xE0, 0x67, 0x50, 0xAE, 0x0A, 0x73, 0x0A, 0xD0, 0xE0, 0x47, 0x70, 0x7E, 0x0A,
  0x71, 0x03, 0xD0, 0xB0, 0x17, 0x72, 0x03, 0x0D, 0xD0, 0x38, 0x0B, 0xD1, 0x00, 0x78, 0x0C, 0x1F,
  0x05, 0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05, 0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78,
  0x0C, 0x1F, 0x05, 0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05, 0x07, 0xF0, 0xA7, 0x77,
  0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72,
  0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07,
  0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0,
  0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7,
  0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77,
  0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72,
  0x07, 0xFF, 0xFF, 0xF0, 0x92, 0x07, 0xFF, 0xFF, 0xF0, 0x92, 0x07, 0xFF, 0xFF, 0xF0, 0x92, 0x07,
  0xFF, 0xFF, 0xF0, 0x92, 0x07, 0xFF, 0xFF, 0xF0, 0x92, 0x07, 0xFF, 0xFF, 0xF0, 0x92, 0x07, 0xFF,
  0xFF, 0xF0, 0x92, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7,
  0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77,
  0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72,
  0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07,
  0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0,
  0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7,
  0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77,
  0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05, 0x07,
  0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05, 0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F,
  0x05, 0x07, 0x80, 0xC1, 0xF0, 0x50,
  // "Ë" (U+00CB)
  0x68, 0x51, 0x8D, 0xFE, 0xB4, 0x77, 0x85, 0x3A, 0xEF, 0xD9, 0x17, 0x30, 0x20, 0xDE, 0x08, 0x75,
  0x06, 0xE0, 0xE0, 0x37, 0x20, 0xAF, 0x90, 0x37, 0x30, 0x1F, 0x90, 0xC7, 0x20, 0xEF, 0x90, 0x87,
  0x30, 0x5F, 0xA0, 0x27, 0x01, 0xFA, 0x0A, 0x73, 0x07, 0xFA, 0x04, 0x70, 0x1F, 0xA0, 0x97, 0x30,
  0x7F, 0xA0, 0x37, 0x10, 0xEF, 0x90, 0x77, 0x30, 0x5F, 0xA0, 0x17, 0x10, 0x9F, 0x90, 0x27, 0x40,
  0xEF, 0x0B, 0x72, 0x01, 0x0C, 0xE0, 0x67, 0x50, 0x4E, 0x0D, 0x02, 0x74, 0x84, 0x7D, 0xFE, 0xA3,
  0x77, 0x85, 0x2A, 0xEF, 0xD8, 0x18, 0x0C, 0xF1, 0x00, 0x78, 0x0C, 0x1F, 0x05, 0x07, 0x80, 0xC1,
  0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05, 0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05, 0x07,
  0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7,
  0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77,
  0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72,
  0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07,
  0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0,
  0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7,
  0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xFF, 0xFF, 0xF0,
  0x92, 0x07, 0xFF, 0xFF, 0xF0, 0x92, 0x07, 0xFF, 0xFF, 0xF0, 0x92, 0x07, 0xFF, 0xFF, 0xF0, 0x92,
  0x07, 0xFF, 0xFF, 0xF0, 0x92, 0x07, 0xFF, 0xFF, 0xF0, 0x92, 0x07, 0xFF, 0xFF, 0xF0, 0x92, 0x07,
  0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0,
  0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7,
  0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77,
  0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72,
  0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07,
  0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0,
  0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7,
  0x77, 0x72, 0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05, 0x07, 0x80, 0xC1, 0xF0, 0x50,
  0x78, 0x0C, 0x1F, 0x05, 0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05, 0x07, 0x80, 0xC1,
  0xF0, 0x50,
  // "Ì" (U+00CC)
  0x68, 0x05, 0x70, 0x47, 0x77, 0x50, 0xEF, 0x90, 0xE7, 0x77, 0x50, 0x4F, 0xA0, 0x77, 0x77, 0x50,
  0x8F, 0x90, 0xE0, 0x17, 0x77, 0x50, 0xBF, 0x90, 0xA7, 0x77, 0x60, 0xCF, 0x90, 0x47, 0x77, 0x50,
  0x10, 0xDF, 0x0D, 0x77, 0x76, 0x02, 0x0E, 0xF0, 0x87, 0x77, 0x60, 0x30, 0xEF, 0x03, 0x77, 0x76,
  0x03, 0x0E, 0xE0, 0xC7, 0x77, 0x70, 0x30, 0xEE, 0x08, 0x77, 0x77, 0x03, 0x0E, 0xE0, 0x47, 0x77,
  0x70, 0x30, 0xED, 0x0E, 0x01, 0x77, 0x77, 0x02, 0x0D, 0xD0, 0xB7, 0x77, 0x71, 0x01, 0x0B, 0xD0,
  0x18, 0x0B, 0xB7, 0x00, 0x1F, 0xFF, 0xFE, 0x00, 0x1F, 0xFF, 0xFE, 0x00, 0x1F, 0xFF, 0xFE, 0x00,
  0x1F, 0xFF, 0xFE, 0x00, 0x1F, 0xFF, 0xFE, 0x00, 0x1F, 0xFF, 0xFE, 0x86, 0x10, 0x68, 0x9B, 0xCD,
  0xFF, 0xF8, 0x5E, 0xDC, 0xA9, 0x86, 0x73, 0x83, 0x23, 0x56, 0x8F, 0x98, 0x37, 0x64, 0x32, 0x77,
  0x71, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F,
  0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77,
  0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0,
  0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76,
  0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E,
  0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60,
  0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7,
  0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02,
  0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77,
  0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F,
  0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77,
  0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0,
  0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76,
  0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x18, 0x42, 0x35,
  0x67, 0x9F, 0x98, 0x48, 0x76, 0x43, 0x27, 0x28, 0x38, 0x9A, 0xCD, 0xFF, 0xFA, 0x86, 0xED, 0xCA,
  0x98, 0x01, 0xFF, 0xFF, 0xE0, 0x01, 0xFF, 0xFF, 0xE0, 0x01, 0xFF, 0xFF, 0xE0, 0x01, 0xFF, 0xFF,
  0xE0, 0x01, 0xFF, 0xFF, 0xE0, 0x10,
  // "Í" (U+00CD)
  0x77, 0x71, 0x03, 0x80, 0x57, 0x01, 0x77, 0x74, 0x0C, 0xFA, 0x02, 0x77, 0x73, 0x05, 0xFA, 0x08,
  0x77, 0x74, 0x0D, 0xF9, 0x0B, 0x77, 0x74, 0x08, 0xF9, 0x0D, 0x01, 0x77, 0x73, 0x02, 0xF9, 0x0E,
  0x02, 0x77, 0x74, 0x0C, 0xF0, 0xE0, 0x37, 0x77, 0x40, 0x6F, 0x90, 0x47, 0x77, 0x40, 0x10, 0xEF,
  0x05, 0x77, 0x75, 0x0B, 0xF0, 0x57, 0x77, 0x50, 0x5F, 0x06, 0x77, 0x75, 0x01, 0x0E, 0xE0, 0x57,
  0x77, 0x60, 0xBE, 0x05, 0x77, 0x76, 0x08, 0xD0, 0xE0, 0x47, 0x77, 0x70, 0xDC, 0x0C, 0x02, 0x80,
  0xBC, 0x30, 0x01, 0xFF, 0xFF, 0xE0, 0x01, 0xFF, 0xFF, 0xE0, 0x01, 0xFF, 0xFF, 0xE0, 0x01, 0xFF,
  0xFF, 0xE0, 0x01, 0xFF, 0xFF, 0xE0, 0x01, 0xFF, 0xFF, 0xE8, 0x61, 0x06, 0x89, 0xBC, 0xDF, 0xFF,
  0x85, 0xED, 0xCA, 0x98, 0x67, 0x38, 0x32, 0x35, 0x68, 0xF9, 0x83, 0x76, 0x43, 0x27, 0x77, 0x10,
  0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7,
  0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02,
  0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77,
  0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F,
  0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77,
  0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0,
  0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76,
  0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E,
  0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60,
  0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7,
  0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02,
  0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77,
  0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F,
  0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x71, 0x84, 0x23, 0x56, 0x79,
  0xF9, 0x84, 0x87, 0x64, 0x32, 0x72, 0x83, 0x89, 0xAC, 0xDF, 0xFF, 0xA8, 0x6E, 0xDC, 0xA9, 0x80,
  0x1F, 0xFF, 0xFE, 0x00, 0x1F, 0xFF, 0xFE, 0x00, 0x1F, 0xFF, 0xFE, 0x00, 0x1F, 0xFF, 0xFE, 0x00,
  0x1F, 0xFF, 0xFE, 0x01,
  // "Î" (U+00CE)
  0x76, 0x02, 0x80, 0x47, 0x77, 0x76, 0x0C, 0xF9, 0x08, 0x77, 0x74, 0x06, 0xFB, 0x03, 0x77, 0x72,
  0x03, 0xFC, 0x0D, 0x01, 0x77, 0x71, 0x0D, 0xFD, 0x0A, 0x77, 0x70, 0xBF, 0xF0, 0x77, 0x75, 0x08,
  0xF0, 0xA0, 0xDF, 0x05, 0x77, 0x30, 0x6F, 0x82, 0x90, 0x1D, 0xF0, 0x37, 0x71, 0x04, 0xF0, 0x93,
  0x01, 0x0D, 0xE0, 0xE0, 0x27, 0x60, 0x20, 0xEE, 0x09, 0x50, 0x10, 0xCE, 0x0D, 0x01, 0x74, 0x01,
  0x0D, 0xE0, 0x87, 0x01, 0x0C, 0xE0, 0xC7, 0x40, 0xCE, 0x08, 0x72, 0x01, 0x0B, 0xE0, 0xB7, 0x20,
  0xBE, 0x06, 0x75, 0x0A, 0xE0, 0xA7, 0x0A, 0xD0, 0xE0, 0x47, 0x70, 0x7E, 0x0A, 0x50, 0x3D, 0x0B,
  0x01, 0x77, 0x20, 0x30, 0xDD, 0x03, 0x80, 0xBA, 0x60, 0x01, 0xFF, 0xFF, 0xE0, 0x01, 0xFF, 0xFF,
  0xE0, 0x01, 0xFF, 0xFF, 0xE0, 0x01, 0xFF, 0xFF, 0xE0, 0x01, 0xFF, 0xFF, 0xE0, 0x01, 0xFF, 0xFF,
  0xE8, 0x61, 0x06, 0x89, 0xBC, 0xDF, 0xFF, 0x85, 0xED, 0xCA, 0x98, 0x67, 0x38, 0x32, 0x35, 0x68,
  0xF9, 0x83, 0x76, 0x43, 0x27, 0x77, 0x10, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60,
  0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7,
  0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02,
  0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77,
  0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F,
  0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77,
  0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0,
  0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76,
  0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E,
  0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60,
  0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7,
  0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02,
  0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77,
  0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F,
  0x0E, 0x77, 0x71, 0x84, 0x23, 0x56, 0x79, 0xF9, 0x84, 0x87, 0x64, 0x32, 0x72, 0x83, 0x89, 0xAC,
  0xDF, 0xFF, 0xA8, 0x6E, 0xDC, 0xA9, 0x80, 0x1F, 0xFF, 0xFE, 0x00, 0x1F, 0xFF, 0xFE, 0x00, 0x1F,
  0xFF, 0xFE, 0x00, 0x1F, 0xFF, 0xFE, 0x00, 0x1F, 0xFF, 0xFE, 0x01,
  // "Ï" (U+00CF)
  0x48, 0x51, 0x8D, 0xFE, 0xB4, 0x77, 0x85, 0x3A, 0xEF, 0xD9, 0x17, 0x02, 0x0D, 0xE0, 0x87, 0x50,
  0x6E, 0x0E, 0x03, 0x60, 0xAF, 0x90, 0x37, 0x30, 0x1F, 0x90, 0xC6, 0x0E, 0xF9, 0x08, 0x73, 0x05,
  0xFA, 0x02, 0x40, 0x1F, 0xA0, 0xA7, 0x30, 0x7F, 0xA0, 0x44, 0x01, 0xFA, 0x09, 0x73, 0x07, 0xFA,
  0x03, 0x50, 0xEF, 0x90, 0x77, 0x30, 0x5F, 0xA0, 0x15, 0x09, 0xF9, 0x02, 0x74, 0x0E, 0xF0, 0xB6,
  0x01, 0x0C, 0xE0, 0x67, 0x50, 0x4E, 0x0D, 0x02, 0x71, 0x84, 0x7D, 0xFE, 0xA3, 0x77, 0x85, 0x2A,
  0xEF, 0xD8, 0x18, 0x0C, 0xC0, 0x00, 0x1F, 0xFF, 0xFE, 0x00, 0x1F, 0xFF, 0xFE, 0x00, 0x1F, 0xFF,
  0xFE, 0x00, 0x1F, 0xFF, 0xFE, 0x00, 0x1F, 0xFF, 0xFE, 0x00, 0x1F, 0xFF, 0xFE, 0x86, 0x10, 0x68,
  0x9B, 0xCD, 0xFF, 0xF8, 0x5E, 0xDC, 0xA9, 0x86, 0x73, 0x83, 0x23, 0x56, 0x8F, 0x98, 0x37, 0x64,
  0x32, 0x77, 0x71, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77,
  0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0,
  0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76,
  0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E,
  0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60,
  0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7,
  0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02,
  0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77,
  0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F,
  0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77,
  0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0,
  0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76,
  0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E,
  0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x18,
  0x42, 0x35, 0x67, 0x9F, 0x98, 0x48, 0x76, 0x43, 0x27, 0x28, 0x38, 0x9A, 0xCD, 0xFF, 0xFA, 0x86,
  0xED, 0xCA, 0x98, 0x01, 0xFF, 0xFF, 0xE0, 0x01, 0xFF, 0xFF, 0xE0, 0x01, 0xFF, 0xFF, 0xE0, 0x01,
  0xFF, 0xFF, 0xE0, 0x01, 0xFF, 0xFF, 0xE0, 0x10,
  // "Ð" (U+00D0)
  0x70, 0xCF, 0xF9, 0x86, 0xEE, 0xDC, 0xA7, 0x42, 0x77, 0x76, 0x0C, 0xFF, 0xFA, 0x81, 0xD8, 0x37,
  0x77, 0x30, 0xCF, 0xFF, 0xD0, 0xD0, 0x67, 0x77, 0x10, 0xCF, 0xFF, 0xF0, 0xE0, 0x67, 0x76, 0x0C,
  0xFF, 0xFF, 0xA0, 0xC0, 0x27, 0x74, 0x0C, 0xFF, 0xFF, 0xC0, 0x67, 0x73, 0x0C, 0xF0, 0xA8, 0x03,
  0x88, 0x29, 0xAC, 0xEF, 0xF0, 0x87, 0x72, 0x0C, 0xF0, 0x47, 0x48, 0x12, 0x6B, 0xFD, 0x09, 0x77,
  0x10, 0xCF, 0x04, 0x77, 0x81, 0x18, 0xEF, 0xB0, 0x97, 0x70, 0xCF, 0x04, 0x77, 0x20, 0x10, 0xAF,
  0xB0, 0x57, 0x60, 0xCF, 0x04, 0x77, 0x40, 0x50, 0xEF, 0xA0, 0x37, 0x50, 0xCF, 0x04, 0x77, 0x50,
  0x30, 0xEF, 0x90, 0xC7, 0x50, 0xCF, 0x04, 0x77, 0x60, 0x20, 0xEF, 0x90, 0x67, 0x40, 0xCF, 0x04,
  0x77, 0x70, 0x4F, 0x90, 0xE0, 0x17, 0x30, 0xCF, 0x04, 0x77, 0x71, 0x08, 0xF9, 0x08, 0x73, 0x0C,
  0xF0, 0x47, 0x77, 0x20, 0xDF, 0x0E, 0x73, 0x0C, 0xF0, 0x47, 0x77, 0x20, 0x5F, 0x90, 0x57, 0x20,
  0xCF, 0x04, 0x77, 0x73, 0x0D, 0xF0, 0xB7, 0x20, 0xCF, 0x04, 0x77, 0x73, 0x07, 0xF9, 0x01, 0x71,
  0x0C, 0xF0, 0x47, 0x77, 0x30, 0x2F, 0x90, 0x57, 0x10, 0xCF, 0x04, 0x77, 0x74, 0x0C, 0xF0, 0x97,
  0x10, 0xCF, 0x04, 0x77, 0x74, 0x08, 0xF0, 0xD7, 0x10, 0xCF, 0x04, 0x77, 0x74, 0x04, 0xF9, 0x71,
  0x0C, 0xF0, 0x47, 0x77, 0x40, 0x1F, 0x90, 0x37, 0x0C, 0xF0, 0x47, 0x77, 0x50, 0xEF, 0x05, 0x70,
  0xCF, 0x04, 0x77, 0x75, 0x0C, 0xF0, 0x77, 0x0C, 0xF0, 0x47, 0x77, 0x50, 0xBF, 0x09, 0x70, 0xCF,
  0x04, 0x77, 0x75, 0x09, 0xF0, 0xA7, 0x0C, 0xF0, 0x47, 0x77, 0x50, 0x8F, 0x0B, 0xFF, 0xFD, 0x04,
  0x77, 0x10, 0x7F, 0x0B, 0xFF, 0xFD, 0x04, 0x77, 0x10, 0x7F, 0x0C, 0xFF, 0xFD, 0x04, 0x77, 0x10,
  0x6F, 0x0C, 0xFF, 0xFD, 0x04, 0x77, 0x10, 0x7F, 0x0C, 0xFF, 0xFD, 0x04, 0x77, 0x10, 0x7F, 0x0C,
  0xFF, 0xFD, 0x04, 0x77, 0x10, 0x8F, 0x0B, 0x80, 0x38, 0x0E, 0xF0, 0xA8, 0x06, 0x80, 0x27, 0x71,
  0x09, 0xF0, 0xA7, 0x0C, 0xF0, 0x47, 0x77, 0x50, 0xAF, 0x09, 0x70, 0xCF, 0x04, 0x77, 0x75, 0x0C,
  0xF0, 0x77, 0x0C, 0xF0, 0x47, 0x77, 0x50, 0xEF, 0x06, 0x70, 0xCF, 0x04, 0x77, 0x74, 0x01, 0xF9,
  0x04, 0x70, 0xCF, 0x04, 0x77, 0x74, 0x04, 0xF9, 0x01, 0x70, 0xCF, 0x04, 0x77, 0x74, 0x07, 0xF0,
  0xD7, 0x10, 0xCF, 0x04, 0x77, 0x74, 0x0B, 0xF0, 0xA7, 0x10, 0xCF, 0x04, 0x77, 0x74, 0xF9, 0x06,
  0x71, 0x0C, 0xF0, 0x47, 0x77, 0x30, 0x5F, 0x90, 0x27, 0x10, 0xCF, 0x04, 0x77, 0x73, 0x0B, 0xF0,
  0xD7, 0x20, 0xCF, 0x04, 0x77, 0x72, 0x02, 0xF9, 0x08, 0x72, 0x0C, 0xF0, 0x47, 0x77, 0x20, 0xAF,
  0x90, 0x27, 0x20, 0xCF, 0x04, 0x77, 0x71, 0x03, 0xF9, 0x0B, 0x73, 0x0C, 0xF0, 0x47, 0x77, 0x10,
  0xCF, 0x90, 0x47, 0x30, 0xCF, 0x04, 0x77, 0x70, 0x9F, 0x90, 0xB7, 0x40, 0xCF, 0x04, 0x77, 0x60,
  0x7F, 0xA0, 0x37, 0x40, 0xCF, 0x04, 0x77, 0x50, 0x6F, 0xA0, 0x87, 0x50, 0xCF, 0x04, 0x77, 0x40,
  0x9F, 0xA0, 0xD7, 0x60, 0xCF, 0x04, 0x77, 0x20, 0x40, 0xDF, 0xA0, 0xE0, 0x27, 0x60, 0xCF, 0x04,
  0x77, 0x05, 0x0C, 0xFC, 0x03, 0x77, 0x0C, 0xF0, 0x47, 0x38, 0x22, 0x5A, 0xEF, 0xC0, 0xE0, 0x47,
  0x71, 0x0C, 0xF0, 0xA8, 0x01, 0x88, 0x39, 0x9B, 0xCE, 0xFF, 0x0E, 0x03, 0x77, 0x20, 0xCF, 0xFF,
  0xFB, 0x0B, 0x01, 0x77, 0x30, 0xCF, 0xFF, 0xF9, 0x0E, 0x07, 0x77, 0x50, 0xCF, 0xFF, 0xF0, 0x90,
  0x17, 0x76, 0x0C, 0xFF, 0xFC, 0x81, 0xE8, 0x17, 0x77, 0x10, 0xCF, 0xFF, 0x98, 0x1D, 0x94, 0x77,
  0x74, 0x0C, 0xFF, 0x86, 0xEE, 0xDB, 0x97, 0x41, 0x77, 0x70,
  // "Ñ" (U+00D1)
  0x75, 0x84, 0x46, 0x87, 0x51, 0x77, 0x84, 0x38, 0x88, 0x81, 0x77, 0x08, 0x0E, 0xE0, 0xB0, 0x37,
  0x50, 0x9C, 0x76, 0x02, 0x0D, 0xFB, 0x0A, 0x01, 0x73, 0x0E, 0xB0, 0xD7, 0x50, 0x10, 0xDF, 0xD0,
  0xE0, 0x77, 0x10, 0x8C, 0x09, 0x75, 0x0B, 0xFF, 0x90, 0xD0, 0x65, 0x06, 0xD0, 0x57, 0x40, 0x5F,
  0xFC, 0x83, 0xEA, 0x89, 0xDD, 0x0E, 0x75, 0x0C, 0xFF, 0xFF, 0x08, 0x74, 0x03, 0xD8, 0x5D, 0x51,
  0x01, 0x5C, 0xFF, 0xA0, 0xE0, 0x17, 0x40, 0x8C, 0x0D, 0x01, 0x60, 0x50, 0xDF, 0xF0, 0x57, 0x50,
  0xCC, 0x04, 0x72, 0x07, 0xFD, 0x07, 0x76, 0x0E, 0xB0, 0xD7, 0x40, 0x20, 0xAF, 0x90, 0xE0, 0x67,
  0x60, 0x1C, 0x08, 0x76, 0x87, 0x28, 0xCE, 0xFD, 0xB6, 0x18, 0x0C, 0x82, 0x00, 0xAF, 0xB0, 0x37,
  0x77, 0x01, 0xF0, 0x0A, 0xFB, 0x0A, 0x77, 0x70, 0x1F, 0x00, 0xAF, 0xC0, 0x17, 0x76, 0x01, 0xF0,
  0x0A, 0xFC, 0x08, 0x77, 0x60, 0x1F, 0x00, 0xAF, 0xC0, 0xE7, 0x76, 0x01, 0xF0, 0x0A, 0xFD, 0x06,
  0x77, 0x50, 0x1F, 0x00, 0xAF, 0xD0, 0xD7, 0x75, 0x01, 0xF0, 0x0A, 0xFE, 0x04, 0x77, 0x40, 0x1F,
  0x00, 0xAF, 0xE0, 0xB7, 0x74, 0x01, 0xF0, 0x0A, 0xE0, 0x7F, 0x02, 0x77, 0x30, 0x1F, 0x00, 0xAE,
  0x02, 0x0E, 0xE0, 0x97, 0x73, 0x01, 0xF0, 0x0A, 0xE0, 0x20, 0x9F, 0x01, 0x77, 0x20, 0x1F, 0x00,
  0xAE, 0x03, 0x02, 0xF0, 0x77, 0x72, 0x01, 0xF0, 0x0A, 0xE8, 0x14, 0x0A, 0xE0, 0xD7, 0x72, 0x01,
  0xF0, 0x0A, 0xE8, 0x16, 0x03, 0xF0, 0x57, 0x71, 0x01, 0xF0, 0x0A, 0xE0, 0x72, 0x0C, 0xE0, 0xC7,
  0x71, 0x01, 0xF0, 0x0A, 0xE0, 0x82, 0x05, 0xF0, 0x37, 0x70, 0x1F, 0x00, 0xAE, 0x09, 0x30, 0xDE,
  0x0A, 0x77, 0x01, 0xF0, 0x0A, 0xE0, 0xB3, 0x07, 0xF0, 0x17, 0x60, 0x1F, 0x00, 0xAE, 0x0C, 0x30,
  0x10, 0xEE, 0x08, 0x76, 0x01, 0xF0, 0x0A, 0xE0, 0xD4, 0x08, 0xE0, 0xE7, 0x60, 0x1F, 0x00, 0xAE,
  0x0E, 0x40, 0x2F, 0x06, 0x75, 0x01, 0xF0, 0x0A, 0xE0, 0xE5, 0x0A, 0xE0, 0xD7, 0x50, 0x1F, 0x00,
  0xAF, 0x50, 0x3F, 0x04, 0x74, 0x01, 0xF0, 0x0A, 0xF6, 0x0C, 0xE0, 0xB7, 0x40, 0x1F, 0x00, 0xAF,
  0x01, 0x50, 0x5F, 0x02, 0x73, 0x01, 0xF0, 0x0A, 0xF0, 0x16, 0x0D, 0xE0, 0x97, 0x30, 0x1F, 0x00,
  0xAF, 0x01, 0x60, 0x6E, 0x0E, 0x01, 0x72, 0x01, 0xF0, 0x0A, 0xF0, 0x17, 0x0E, 0xE0, 0x77, 0x20,
  0x1F, 0x00, 0xAF, 0x01, 0x70, 0x8E, 0x0D, 0x72, 0x01, 0xF0, 0x0A, 0xF0, 0x17, 0x01, 0xF0, 0x57,
  0x10, 0x1F, 0x00, 0xAF, 0x01, 0x71, 0x0A, 0xE0, 0xC7, 0x10, 0x1F, 0x00, 0xAF, 0x01, 0x71, 0x03,
  0xF0, 0x37, 0x01, 0xF0, 0x0A, 0xF0, 0x17, 0x20, 0xBE, 0x0A, 0x70, 0x1F, 0x00, 0xAF, 0x01, 0x72,
  0x04, 0xF0, 0x16, 0x01, 0xF0, 0x0A, 0xF0, 0x17, 0x30, 0xDE, 0x08, 0x60, 0x1F, 0x00, 0xAF, 0x01,
  0x73, 0x06, 0xE0, 0xE6, 0x01, 0xF0, 0x0A, 0xF0, 0x17, 0x40, 0xEE, 0x06, 0x50, 0x1F, 0x00, 0xAF,
  0x01, 0x74, 0x08, 0xE0, 0xD5, 0x01, 0xF0, 0x0A, 0xF0, 0x17, 0x40, 0x1F, 0x04, 0x40, 0x1F, 0x00,
  0xAF, 0x01, 0x75, 0x09, 0xE0, 0xB5, 0xF0, 0x0A, 0xF0, 0x17, 0x50, 0x2F, 0x02, 0x4F, 0x00, 0xAF,
  0x01, 0x76, 0x0B, 0xE0, 0x94, 0xF0, 0x0A, 0xF0, 0x17, 0x60, 0x4E, 0x0E, 0x01, 0x3F, 0x00, 0xAF,
  0x01, 0x77, 0x0C, 0xE0, 0x73, 0x0E, 0xE0, 0x0A, 0xF0, 0x17, 0x70, 0x5E, 0x0D, 0x30, 0xDE, 0x00,
  0xAF, 0x01, 0x77, 0x10, 0xEE, 0x05, 0x20, 0xCE, 0x00, 0xAF, 0x01, 0x77, 0x10, 0x7E, 0x0C, 0x20,
  0xBE, 0x00, 0xAF, 0x01, 0x77, 0x10, 0x10, 0xEE, 0x81, 0x30, 0xAE, 0x00, 0xAF, 0x01, 0x77, 0x20,
  0x9E, 0x81, 0xA0, 0x9E, 0x00, 0xAF, 0x01, 0x77, 0x20, 0x2F, 0x01, 0x08, 0xE0, 0x0A, 0xF0, 0x17,
  0x73, 0x0A, 0xE0, 0x80, 0x7E, 0x00, 0xAF, 0x01, 0x77, 0x30, 0x3E, 0x0E, 0x06, 0xE0, 0x0A, 0xF0,
  0x17, 0x74, 0x0C, 0xE0, 0xCE, 0x00, 0xAF, 0x01, 0x77, 0x40, 0x5F, 0xE0, 0x0A, 0xF0, 0x17, 0x75,
  0x0D, 0xFD, 0x00, 0xAF, 0x01, 0x77, 0x50, 0x7F, 0xD0, 0x0A, 0xF0, 0x17, 0x75, 0x01, 0x0E, 0xFC,
  0x00, 0xAF, 0x01, 0x77, 0x60, 0x8F, 0xC0, 0x0A, 0xF0, 0x17, 0x76, 0x02, 0xFC, 0x00, 0xAF, 0x01,
  0x77, 0x70, 0xAF, 0xB0, 0x0A, 0xF0, 0x17, 0x77, 0x03, 0xFB, 0x00, 0xAF, 0x01, 0x77, 0x71, 0x0C,
  0xFA, 0x00, 0xAF, 0x01, 0x77, 0x71, 0x05, 0xFA, 0x0A,
  // "Ò" (U+00D2)
  0x74, 0x80, 0x57, 0x04, 0x80, 0xC0, 0x00, 0xEF, 0x90, 0xE8, 0x0C, 0x00, 0x04, 0xFA, 0x07, 0x80,
  0xC0, 0x00, 0x8F, 0x90, 0xE0, 0x18, 0x0C, 0x00, 0x0B, 0xF9, 0x0A, 0x80, 0xC1, 0x00, 0xCF, 0x90,
  0x48, 0x0C, 0x00, 0x01, 0x0D, 0xF0, 0xD8, 0x0C, 0x10, 0x02, 0x0E, 0xF0, 0x88, 0x0C, 0x10, 0x03,
  0x0E, 0xF0, 0x38, 0x0C, 0x10, 0x03, 0x0E, 0xE0, 0xC8, 0x0C, 0x20, 0x03, 0x0E, 0xE0, 0x88, 0x0C,
  0x20, 0x03, 0x0E, 0xE0, 0x48, 0x0C, 0x20, 0x03, 0x0E, 0xD0, 0xE0, 0x18, 0x0C, 0x20, 0x02, 0x0D,
  0xD0, 0xB8, 0x0C, 0x30, 0x01, 0x0B, 0xD0, 0x18, 0x0C, 0x82, 0x08, 0x42, 0x69, 0xBD, 0xEA, 0x84,
  0xED, 0xB9, 0x62, 0x77, 0x77, 0x18, 0x11, 0x7D, 0xFF, 0x81, 0xD8, 0x17, 0x77, 0x30, 0x10, 0x8F,
  0xFE, 0x09, 0x01, 0x77, 0x70, 0x40, 0xEF, 0xFF, 0x90, 0xE0, 0x47, 0x75, 0x07, 0xFF, 0xFD, 0x07,
  0x77, 0x30, 0x7F, 0xFF, 0xF0, 0x87, 0x71, 0x07, 0xFF, 0xFF, 0xA0, 0x87, 0x60, 0x4F, 0xC8, 0x2B,
  0x63, 0x12, 0x83, 0x12, 0x59, 0xEF, 0xB0, 0x47, 0x40, 0x10, 0xEF, 0xA0, 0x90, 0x17, 0x40, 0x70,
  0xEF, 0x90, 0xE0, 0x27, 0x30, 0xAF, 0x90, 0xE0, 0x37, 0x70, 0x20, 0xCF, 0x90, 0xB7, 0x20, 0x3F,
  0x90, 0xD0, 0x27, 0x72, 0x01, 0x0C, 0xF9, 0x04, 0x71, 0x0C, 0xF9, 0x03, 0x77, 0x40, 0x10, 0xEF,
  0x0C, 0x70, 0x4F, 0x90, 0x77, 0x76, 0x05, 0xF9, 0x05, 0x60, 0xAF, 0x0D, 0x77, 0x71, 0x0C, 0xF0,
  0xB5, 0x01, 0xF9, 0x06, 0x77, 0x71, 0x04, 0xF9, 0x01, 0x40, 0x7F, 0x0E, 0x77, 0x73, 0x0D, 0xF0,
  0x74, 0x0C, 0xF0, 0x97, 0x77, 0x30, 0x8F, 0x0C, 0x4F, 0x90, 0x47, 0x77, 0x30, 0x3F, 0x90, 0x12,
  0x04, 0xF9, 0x77, 0x75, 0x0E, 0xF0, 0x52, 0x08, 0xF0, 0xB7, 0x77, 0x50, 0xAF, 0x09, 0x20, 0xBF,
  0x07, 0x77, 0x75, 0x07, 0xF0, 0xC2, 0x0E, 0xF0, 0x47, 0x77, 0x50, 0x3F, 0x81, 0xE0, 0x1F, 0x90,
  0x17, 0x77, 0x50, 0x1F, 0x90, 0x20, 0x4F, 0x0E, 0x77, 0x77, 0x0E, 0xF0, 0x50, 0x6F, 0x0C, 0x77,
  0x77, 0x0C, 0xF0, 0x60, 0x8F, 0x0B, 0x77, 0x77, 0x0A, 0xF0, 0x80, 0x9F, 0x09, 0x77, 0x77, 0x09,
  0xF0, 0x90, 0xBF, 0x08, 0x77, 0x77, 0x08, 0xF0, 0xB0, 0xCF, 0x07, 0x77, 0x77, 0x07, 0xF0, 0xC0,
  0xDF, 0x06, 0x77, 0x77, 0x06, 0xF0, 0x0D, 0xF0, 0x57, 0x77, 0x70, 0x5F, 0x0D, 0x0E, 0xF0, 0x57,
  0x77, 0x70, 0x5F, 0x00, 0xEF, 0x05, 0x77, 0x77, 0x05, 0xF0, 0x0E, 0xF0, 0x57, 0x77, 0x70, 0x5F,
  0x00, 0xEF, 0x05, 0x77, 0x77, 0x05, 0xF0, 0xE0, 0xDF, 0x05, 0x77, 0x77, 0x05, 0xF0, 0x0D, 0xF0,
  0x67, 0x77, 0x70, 0x6F, 0x0D, 0x0C, 0xF0, 0x77, 0x77, 0x70, 0x7F, 0x0C, 0x0B, 0xF0, 0x87, 0x77,
  0x70, 0x8F, 0x0B, 0x09, 0xF0, 0x97, 0x77, 0x70, 0x9F, 0x09, 0x08, 0xF0, 0xA7, 0x77, 0x70, 0xAF,
  0x08, 0x06, 0xF0, 0xC7, 0x77, 0x70, 0xCF, 0x06, 0x04, 0xF0, 0xE7, 0x77, 0x70, 0xEF, 0x04, 0x02,
  0xF9, 0x01, 0x77, 0x75, 0x01, 0xF9, 0x81, 0x10, 0xEF, 0x04, 0x77, 0x75, 0x04, 0xF0, 0xE2, 0x0C,
  0xF0, 0x77, 0x77, 0x50, 0x7F, 0x0B, 0x20, 0x9F, 0x0B, 0x77, 0x75, 0x0A, 0xF0, 0x82, 0x05, 0xF0,
  0xE7, 0x77, 0x50, 0xEF, 0x04, 0x20, 0x1F, 0x90, 0x47, 0x77, 0x30, 0x3F, 0x94, 0x0C, 0xF0, 0x97,
  0x77, 0x30, 0x8F, 0x0B, 0x40, 0x7F, 0x0E, 0x77, 0x73, 0x0D, 0xF0, 0x64, 0x01, 0xF9, 0x06, 0x77,
  0x71, 0x05, 0xF9, 0x01, 0x50, 0xBF, 0x0D, 0x77, 0x71, 0x0C, 0xF0, 0xA6, 0x05, 0xF9, 0x06, 0x77,
  0x60, 0x5F, 0x90, 0x47, 0x0D, 0xF9, 0x02, 0x77, 0x40, 0x10, 0xEF, 0x0B, 0x71, 0x04, 0xF9, 0x0D,
  0x02, 0x77, 0x20, 0x10, 0xCF, 0x90, 0x37, 0x20, 0xBF, 0x90, 0xD0, 0x37, 0x70, 0x20, 0xCF, 0x90,
  0xA7, 0x30, 0x20, 0xEF, 0xA0, 0x80, 0x17, 0x40, 0x70, 0xEF, 0x90, 0xD0, 0x17, 0x40, 0x5F, 0xC8,
  0x2A, 0x63, 0x12, 0x83, 0x12, 0x5A, 0xEF, 0xB0, 0x37, 0x60, 0x8F, 0xFF, 0xFA, 0x06, 0x77, 0x10,
  0x8F, 0xFF, 0xF0, 0x67, 0x73, 0x08, 0xFF, 0xFD, 0x06, 0x77, 0x50, 0x50, 0xEF, 0xFF, 0x90, 0xD0,
  0x37, 0x77, 0x01, 0x09, 0xFF, 0xD0, 0xE0, 0x87, 0x77, 0x48, 0x12, 0x8E, 0xFF, 0x81, 0xD7, 0x17,
  0x77, 0x71, 0x84, 0x37, 0x9C, 0xDE, 0xA8, 0x4E, 0xDB, 0x96, 0x27, 0x72,
  // "Ó" (U+00D3)
  0x77, 0x76, 0x03, 0x80, 0x57, 0x01, 0x77, 0x77, 0x70, 0xCF, 0xA0, 0x27, 0x77, 0x76, 0x05, 0xFA,
  0x08, 0x77, 0x77, 0x70, 0xDF, 0x90, 0xB7, 0x77, 0x77, 0x08, 0xF9, 0x0D, 0x01, 0x77, 0x77, 0x60,
  0x2F, 0x90, 0xE0, 0x27, 0x77, 0x77, 0x0C, 0xF0, 0xE0, 0x37, 0x77, 0x77, 0x06, 0xF9, 0x04, 0x77,
  0x77, 0x70, 0x10, 0xEF, 0x05, 0x80, 0xC0, 0x00, 0xBF, 0x05, 0x80, 0xC0, 0x00, 0x5F, 0x06, 0x80,
  0xC0, 0x00, 0x10, 0xEE, 0x05, 0x80, 0xC1, 0x00, 0xBE, 0x05, 0x80, 0xC1, 0x00, 0x8D, 0x0E, 0x04,
  0x80, 0xC2, 0x00, 0xDC, 0x0C, 0x02, 0x80, 0xC8, 0x60, 0x84, 0x26, 0x9B, 0xDE, 0xA8, 0x4E, 0xDB,
  0x96, 0x27, 0x77, 0x71, 0x81, 0x17, 0xDF, 0xF8, 0x1D, 0x81, 0x77, 0x73, 0x01, 0x08, 0xFF, 0xE0,
  0x90, 0x17, 0x77, 0x04, 0x0E, 0xFF, 0xF9, 0x0E, 0x04, 0x77, 0x50, 0x7F, 0xFF, 0xD0, 0x77, 0x73,
  0x07, 0xFF, 0xFF, 0x08, 0x77, 0x10, 0x7F, 0xFF, 0xFA, 0x08, 0x76, 0x04, 0xFC, 0x82, 0xB6, 0x31,
  0x28, 0x31, 0x25, 0x9E, 0xFB, 0x04, 0x74, 0x01, 0x0E, 0xFA, 0x09, 0x01, 0x74, 0x07, 0x0E, 0xF9,
  0x0E, 0x02, 0x73, 0x0A, 0xF9, 0x0E, 0x03, 0x77, 0x02, 0x0C, 0xF9, 0x0B, 0x72, 0x03, 0xF9, 0x0D,
  0x02, 0x77, 0x20, 0x10, 0xCF, 0x90, 0x47, 0x10, 0xCF, 0x90, 0x37, 0x74, 0x01, 0x0E, 0xF0, 0xC7,
  0x04, 0xF9, 0x07, 0x77, 0x60, 0x5F, 0x90, 0x56, 0x0A, 0xF0, 0xD7, 0x77, 0x10, 0xCF, 0x0B, 0x50,
  0x1F, 0x90, 0x67, 0x77, 0x10, 0x4F, 0x90, 0x14, 0x07, 0xF0, 0xE7, 0x77, 0x30, 0xDF, 0x07, 0x40,
  0xCF, 0x09, 0x77, 0x73, 0x08, 0xF0, 0xC4, 0xF9, 0x04, 0x77, 0x73, 0x03, 0xF9, 0x01, 0x20, 0x4F,
  0x97, 0x77, 0x50, 0xEF, 0x05, 0x20, 0x8F, 0x0B, 0x77, 0x75, 0x0A, 0xF0, 0x92, 0x0B, 0xF0, 0x77,
  0x77, 0x50, 0x7F, 0x0C, 0x20, 0xEF, 0x04, 0x77, 0x75, 0x03, 0xF8, 0x1E, 0x01, 0xF9, 0x01, 0x77,
  0x75, 0x01, 0xF9, 0x02, 0x04, 0xF0, 0xE7, 0x77, 0x70, 0xEF, 0x05, 0x06, 0xF0, 0xC7, 0x77, 0x70,
  0xCF, 0x06, 0x08, 0xF0, 0xB7, 0x77, 0x70, 0xAF, 0x08, 0x09, 0xF0, 0x97, 0x77, 0x70, 0x9F, 0x09,
  0x0B, 0xF0, 0x87, 0x77, 0x70, 0x8F, 0x0B, 0x0C, 0xF0, 0x77, 0x77, 0x70, 0x7F, 0x0C, 0x0D, 0xF0,
  0x67, 0x77, 0x70, 0x6F, 0x00, 0xDF, 0x05, 0x77, 0x77, 0x05, 0xF0, 0xD0, 0xEF, 0x05, 0x77, 0x77,
  0x05, 0xF0, 0x0E, 0xF0, 0x57, 0x77, 0x70, 0x5F, 0x00, 0xEF, 0x05, 0x77, 0x77, 0x05, 0xF0, 0x0E,
  0xF0, 0x57, 0x77, 0x70, 0x5F, 0x0E, 0x0D, 0xF0, 0x57, 0x77, 0x70, 0x5F, 0x00, 0xDF, 0x06, 0x77,
  0x77, 0x06, 0xF0, 0xD0, 0xCF, 0x07, 0x77, 0x77, 0x07, 0xF0, 0xC0, 0xBF, 0x08, 0x77, 0x77, 0x08,
  0xF0, 0xB0, 0x9F, 0x09, 0x77, 0x77, 0x09, 0xF0, 0x90, 0x8F, 0x0A, 0x77, 0x77, 0x0A, 0xF0, 0x80,
  0x6F, 0x0C, 0x77, 0x77, 0x0C, 0xF0, 0x60, 0x4F, 0x0E, 0x77, 0x77, 0x0E, 0xF0, 0x40, 0x2F, 0x90,
  0x17, 0x77, 0x50, 0x1F, 0x98, 0x11, 0x0E, 0xF0, 0x47, 0x77, 0x50, 0x4F, 0x0E, 0x20, 0xCF, 0x07,
  0x77, 0x75, 0x07, 0xF0, 0xB2, 0x09, 0xF0, 0xB7, 0x77, 0x50, 0xAF, 0x08, 0x20, 0x5F, 0x0E, 0x77,
  0x75, 0x0E, 0xF0, 0x42, 0x01, 0xF9, 0x04, 0x77, 0x73, 0x03, 0xF9, 0x40, 0xCF, 0x09, 0x77, 0x73,
  0x08, 0xF0, 0xB4, 0x07, 0xF0, 0xE7, 0x77, 0x30, 0xDF, 0x06, 0x40, 0x1F, 0x90, 0x67, 0x77, 0x10,
  0x5F, 0x90, 0x15, 0x0B, 0xF0, 0xD7, 0x77, 0x10, 0xCF, 0x0A, 0x60, 0x5F, 0x90, 0x67, 0x76, 0x05,
  0xF9, 0x04, 0x70, 0xDF, 0x90, 0x27, 0x74, 0x01, 0x0E, 0xF0, 0xB7, 0x10, 0x4F, 0x90, 0xD0, 0x27,
  0x72, 0x01, 0x0C, 0xF9, 0x03, 0x72, 0x0B, 0xF9, 0x0D, 0x03, 0x77, 0x02, 0x0C, 0xF9, 0x0A, 0x73,
  0x02, 0x0E, 0xFA, 0x08, 0x01, 0x74, 0x07, 0x0E, 0xF9, 0x0D, 0x01, 0x74, 0x05, 0xFC, 0x82, 0xA6,
  0x31, 0x28, 0x31, 0x25, 0xAE, 0xFB, 0x03, 0x76, 0x08, 0xFF, 0xFF, 0xA0, 0x67, 0x71, 0x08, 0xFF,
  0xFF, 0x06, 0x77, 0x30, 0x8F, 0xFF, 0xD0, 0x67, 0x75, 0x05, 0x0E, 0xFF, 0xF9, 0x0D, 0x03, 0x77,
  0x70, 0x10, 0x9F, 0xFD, 0x0E, 0x08, 0x77, 0x74, 0x81, 0x28, 0xEF, 0xF8, 0x1D, 0x71, 0x77, 0x77,
  0x18, 0x43, 0x79, 0xCD, 0xEA, 0x84, 0xED, 0xB9, 0x62, 0x77, 0x20,
  // "Ô" (U+00D4)
  0x77, 0x40, 0x28, 0x04, 0x78, 0x0C, 0x10, 0x0C, 0xF9, 0x08, 0x77, 0x77, 0x70, 0x6F, 0xB0, 0x37,
  0x77, 0x75, 0x03, 0xFC, 0x0D, 0x01, 0x77, 0x77, 0x40, 0xDF, 0xD0, 0xA7, 0x77, 0x73, 0x0B, 0xFF,
  0x07, 0x77, 0x77, 0x10, 0x8F, 0x0A, 0x0D, 0xF0, 0x57, 0x77, 0x60, 0x6F, 0x82, 0x90, 0x1D, 0xF0,
  0x37, 0x77, 0x40, 0x4F, 0x09, 0x30, 0x10, 0xDE, 0x0E, 0x02, 0x77, 0x72, 0x02, 0x0E, 0xE0, 0x95,
  0x01, 0x0C, 0xE0, 0xD0, 0x17, 0x77, 0x01, 0x0D, 0xE0, 0x87, 0x01, 0x0C, 0xE0, 0xC7, 0x77, 0x0C,
  0xE0, 0x87, 0x20, 0x10, 0xBE, 0x0B, 0x77, 0x50, 0xBE, 0x06, 0x75, 0x0A, 0xE0, 0xA7, 0x73, 0x0A,
  0xD0, 0xE0, 0x47, 0x70, 0x7E, 0x0A, 0x77, 0x10, 0x3D, 0x0B, 0x01, 0x77, 0x20, 0x30, 0xDD, 0x03,
  0x80, 0xBF, 0x10, 0x84, 0x26, 0x9B, 0xDE, 0xA8, 0x4E, 0xDB, 0x96, 0x27, 0x77, 0x71, 0x81, 0x17,
  0xDF, 0xF8, 0x1D, 0x81, 0x77, 0x73, 0x01, 0x08, 0xFF, 0xE0, 0x90, 0x17, 0x77, 0x04, 0x0E, 0xFF,
  0xF9, 0x0E, 0x04, 0x77, 0x50, 0x7F, 0xFF, 0xD0, 0x77, 0x73, 0x07, 0xFF, 0xFF, 0x08, 0x77, 0x10,
  0x7F, 0xFF, 0xFA, 0x08, 0x76, 0x04, 0xFC, 0x82, 0xB6, 0x31, 0x28, 0x31, 0x25, 0x9E, 0xFB, 0x04,
  0x74, 0x01, 0x0E, 0xFA, 0x09, 0x01, 0x74, 0x07, 0x0E, 0xF9, 0x0E, 0x02, 0x73, 0x0A, 0xF9, 0x0E,
  0x03, 0x77, 0x02, 0x0C, 0xF9, 0x0B, 0x72, 0x03, 0xF9, 0x0D, 0x02, 0x77, 0x20, 0x10, 0xCF, 0x90,
  0x47, 0x10, 0xCF, 0x90, 0x37, 0x74, 0x01, 0x0E, 0xF0, 0xC7, 0x04, 0xF9, 0x07, 0x77, 0x60, 0x5F,
  0x90, 0x56, 0x0A, 0xF0, 0xD7, 0x77, 0x10, 0xCF, 0x0B, 0x50, 0x1F, 0x90, 0x67, 0x77, 0x10, 0x4F,
  0x90, 0x14, 0x07, 0xF0, 0xE7, 0x77, 0x30, 0xDF, 0x07, 0x40, 0xCF, 0x09, 0x77, 0x73, 0x08, 0xF0,
  0xC4, 0xF9, 0x04, 0x77, 0x73, 0x03, 0xF9, 0x01, 0x20, 0x4F, 0x97, 0x77, 0x50, 0xEF, 0x05, 0x20,
  0x8F, 0x0B, 0x77, 0x75, 0x0A, 0xF0, 0x92, 0x0B, 0xF0, 0x77, 0x77, 0x50, 0x7F, 0x0C, 0x20, 0xEF,
  0x04, 0x77, 0x75, 0x03, 0xF8, 0x1E, 0x01, 0xF9, 0x01, 0x77, 0x75, 0x01, 0xF9, 0x02, 0x04, 0xF0,
  0xE7, 0x77, 0x70, 0xEF, 0x05, 0x06, 0xF0, 0xC7, 0x77, 0x70, 0xCF, 0x06, 0x08, 0xF0, 0xB7, 0x77,
  0x70, 0xAF, 0x08, 0x09, 0xF0, 0x97, 0x77, 0x70, 0x9F, 0x09, 0x0B, 0xF0, 0x87, 0x77, 0x70, 0x8F,
  0x0B, 0x0C, 0xF0, 0x77, 0x77, 0x70, 0x7F, 0x0C, 0x0D, 0xF0, 0x67, 0x77, 0x70, 0x6F, 0x00, 0xDF,
  0x05, 0x77, 0x77, 0x05, 0xF0, 0xD0, 0xEF, 0x05, 0x77, 0x77, 0x05, 0xF0, 0x0E, 0xF0, 0x57, 0x77,
  0x70, 0x5F, 0x00, 0xEF, 0x05, 0x77, 0x77, 0x05, 0xF0, 0x0E, 0xF0, 0x57, 0x77, 0x70, 0x5F, 0x0E,
  0x0D, 0xF0, 0x57, 0x77, 0x70, 0x5F, 0x00, 0xDF, 0x06, 0x77, 0x77, 0x06, 0xF0, 0xD0, 0xCF, 0x07,
  0x77, 0x77, 0x07, 0xF0, 0xC0, 0xBF, 0x08, 0x77, 0x77, 0x08, 0xF0, 0xB0, 0x9F, 0x09, 0x77, 0x77,
  0x09, 0xF0, 0x90, 0x8F, 0x0A, 0x77, 0x77, 0x0A, 0xF0, 0x80, 0x6F, 0x0C, 0x77, 0x77, 0x0C, 0xF0,
  0x60, 0x4F, 0x0E, 0x77, 0x77, 0x0E, 0xF0, 0x40, 0x2F, 0x90, 0x17, 0x77, 0x50, 0x1F, 0x98, 0x11,
  0x0E, 0xF0, 0x47, 0x77, 0x50, 0x4F, 0x0E, 0x20, 0xCF, 0x07, 0x77, 0x75, 0x07, 0xF0, 0xB2, 0x09,
  0xF0, 0xB7, 0x77, 0x50, 0xAF, 0x08, 0x20, 0x5F, 0x0E, 0x77, 0x75, 0x0E, 0xF0, 0x42, 0x01, 0xF9,
  0x04, 0x77, 0x73, 0x03, 0xF9, 0x40, 0xCF, 0x09, 0x77, 0x73, 0x08, 0xF0, 0xB4, 0x07, 0xF0, 0xE7,
  0x77, 0x30, 0xDF, 0x06, 0x40, 0x1F, 0x90, 0x67, 0x77, 0x10, 0x5F, 0x90, 0x15, 0x0B, 0xF0, 0xD7,
  0x77, 0x10, 0xCF, 0x0A, 0x60, 0x5F, 0x90, 0x67, 0x76, 0x05, 0xF9, 0x04, 0x70, 0xDF, 0x90, 0x27,
  0x74, 0x01, 0x0E, 0xF0, 0xB7, 0x10, 0x4F, 0x90, 0xD0, 0x27, 0x72, 0x01, 0x0C, 0xF9, 0x03, 0x72,
  0x0B, 0xF9, 0x0D, 0x03, 0x77, 0x02, 0x0C, 0xF9, 0x0A, 0x73, 0x02, 0x0E, 0xFA, 0x08, 0x01, 0x74,
  0x07, 0x0E, 0xF9, 0x0D, 0x01, 0x74, 0x05, 0xFC, 0x82, 0xA6, 0x31, 0x28, 0x31, 0x25, 0xAE, 0xFB,
  0x03, 0x76, 0x08, 0xFF, 0xFF, 0xA0, 0x67, 0x71, 0x08, 0xFF, 0xFF, 0x06, 0x77, 0x30, 0x8F, 0xFF,
  0xD0, 0x67, 0x75, 0x05, 0x0E, 0xFF, 0xF9, 0x0D, 0x03, 0x77, 0x70, 0x10, 0x9F, 0xFD, 0x0E, 0x08,
  0x77, 0x74, 0x81, 0x28, 0xEF, 0xF8, 0x1D, 0x71, 0x77, 0x77, 0x18, 0x43, 0x79, 0xCD, 0xEA, 0x84,
  0xED, 0xB9, 0x62, 0x77, 0x20,
  // "Õ" (U+00D5)
  0x77, 0x84, 0x46, 0x87, 0x51, 0x77, 0x84, 0x38, 0x88, 0x81, 0x77, 0x40, 0x80, 0xEE, 0x0B, 0x03,
  0x75, 0x09, 0xC7, 0x73, 0x02, 0x0D, 0xFB, 0x0A, 0x01, 0x73, 0x0E, 0xB0, 0xD7, 0x72, 0x01, 0x0D,
  0xFD, 0x0E, 0x07, 0x71, 0x08, 0xC0, 0x97, 0x72, 0x0B, 0xFF, 0x90, 0xD0, 0x65, 0x06, 0xD0, 0x57,
  0x71, 0x05, 0xFF, 0xC8, 0x3E, 0xA8, 0x9D, 0xD0, 0xE7, 0x72, 0x0C, 0xFF, 0xFF, 0x08, 0x77, 0x10,
  0x3D, 0x85, 0xD5, 0x10, 0x15, 0xCF, 0xFA, 0x0E, 0x01, 0x77, 0x10, 0x8C, 0x0D, 0x01, 0x60, 0x50,
  0xDF, 0xF0, 0x57, 0x72, 0x0C, 0xC0, 0x47, 0x20, 0x7F, 0xD0, 0x77, 0x73, 0x0E, 0xB0, 0xD7, 0x40,
  0x20, 0xAF, 0x90, 0xE0, 0x67, 0x73, 0x01, 0xC0, 0x87, 0x68, 0x72, 0x8C, 0xEF, 0xDB, 0x61, 0x80,
  0xBF, 0x60, 0x84, 0x26, 0x9B, 0xDE, 0xA8, 0x4E, 0xDB, 0x96, 0x27, 0x77, 0x71, 0x81, 0x17, 0xDF,
  0xF8, 0x1D, 0x81, 0x77, 0x73, 0x01, 0x08, 0xFF, 0xE0, 0x90, 0x17, 0x77, 0x04, 0x0E, 0xFF, 0xF9,
  0x0E, 0x04, 0x77, 0x50, 0x7F, 0xFF, 0xD0, 0x77, 0x73, 0x07, 0xFF, 0xFF, 0x08, 0x77, 0x10, 0x7F,
  0xFF, 0xFA, 0x08, 0x76, 0x04, 0xFC, 0x82, 0xB6, 0x31, 0x28, 0x31, 0x25, 0x9E, 0xFB, 0x04, 0x74,
  0x01, 0x0E, 0xFA, 0x09, 0x01, 0x74, 0x07, 0x0E, 0xF9, 0x0E, 0x02, 0x73, 0x0A, 0xF9, 0x0E, 0x03,
  0x77, 0x02, 0x0C, 0xF9, 0x0B, 0x72, 0x03, 0xF9, 0x0D, 0x02, 0x77, 0x20, 0x10, 0xCF, 0x90, 0x47,
  0x10, 0xCF, 0x90, 0x37, 0x74, 0x01, 0x0E, 0xF0, 0xC7, 0x04, 0xF9, 0x07, 0x77, 0x60, 0x5F, 0x90,
  0x56, 0x0A, 0xF0, 0xD7, 0x77, 0x10, 0xCF, 0x0B, 0x50, 0x1F, 0x90, 0x67, 0x77, 0x10, 0x4F, 0x90,
  0x14, 0x07, 0xF0, 0xE7, 0x77, 0x30, 0xDF, 0x07, 0x40, 0xCF, 0x09, 0x77, 0x73, 0x08, 0xF0, 0xC4,
  0xF9, 0x04, 0x77, 0x73, 0x03, 0xF9, 0x01, 0x20, 0x4F, 0x97, 0x77, 0x50, 0xEF, 0x05, 0x20, 0x8F,
  0x0B, 0x77, 0x75, 0x0A, 0xF0, 0x92, 0x0B, 0xF0, 0x77, 0x77, 0x50, 0x7F, 0x0C, 0x20, 0xEF, 0x04,
  0x77, 0x75, 0x03, 0xF8, 0x1E, 0x01, 0xF9, 0x01, 0x77, 0x75, 0x01, 0xF9, 0x02, 0x04, 0xF0, 0xE7,
  0x77, 0x70, 0xEF, 0x05, 0x06, 0xF0, 0xC7, 0x77, 0x70, 0xCF, 0x06, 0x08, 0xF0, 0xB7, 0x77, 0x70,
  0xAF, 0x08, 0x09, 0xF0, 0x97, 0x77, 0x70, 0x9F, 0x09, 0x0B, 0xF0, 0x87, 0x77, 0x70, 0x8F, 0x0B,
  0x0C, 0xF0, 0x77, 0x77, 0x70, 0x7F, 0x0C, 0x0D, 0xF0, 0x67, 0x77, 0x70, 0x6F, 0x00, 0xDF, 0x05,
  0x77, 0x77, 0x05, 0xF0, 0xD0, 0xEF, 0x05, 0x77, 0x77, 0x05, 0xF0, 0x0E, 0xF0, 0x57, 0x77, 0x70,
  0x5F, 0x00, 0xEF, 0x05, 0x77, 0x77, 0x05, 0xF0, 0x0E, 0xF0, 0x57, 0x77, 0x70, 0x5F, 0x0E, 0x0D,
  0xF0, 0x57, 0x77, 0x70, 0x5F, 0x00, 0xDF, 0x06, 0x77, 0x77, 0x06, 0xF0, 0xD0, 0xCF, 0x07, 0x77,
  0x77, 0x07, 0xF0, 0xC0, 0xBF, 0x08, 0x77, 0x77, 0x08, 0xF0, 0xB0, 0x9F, 0x09, 0x77, 0x77, 0x09,
  0xF0, 0x90, 0x8F, 0x0A, 0x77, 0x77, 0x0A, 0xF0, 0x80, 0x6F, 0x0C, 0x77, 0x77, 0x0C, 0xF0, 0x60,
  0x4F, 0x0E, 0x77, 0x77, 0x0E, 0xF0, 0x40, 0x2F, 0x90, 0x17, 0x77, 0x50, 0x1F, 0x98, 0x11, 0x0E,
  0xF0, 0x47, 0x77, 0x50, 0x4F, 0x0E, 0x20, 0xCF, 0x07, 0x77, 0x75, 0x07, 0xF0, 0xB2, 0x09, 0xF0,
  0xB7, 0x77, 0x50, 0xAF, 0x08, 0x20, 0x5F, 0x0E, 0x77, 0x75, 0x0E, 0xF0, 0x42, 0x01, 0xF9, 0x04,
  0x77, 0x73, 0x03, 0xF9, 0x40, 0xCF, 0x09, 0x77, 0x73, 0x08, 0xF0, 0xB4, 0x07, 0xF0, 0xE7, 0x77,
  0x30, 0xDF, 0x06, 0x40, 0x1F, 0x90, 0x67, 0x77, 0x10, 0x5F, 0x90, 0x15, 0x0B, 0xF0, 0xD7, 0x77,
  0x10, 0xCF, 0x0A, 0x60, 0x5F, 0x90, 0x67, 0x76, 0x05, 0xF9, 0x04, 0x70, 0xDF, 0x90, 0x27, 0x74,
  0x01, 0x0E, 0xF0, 0xB7, 0x10, 0x4F, 0x90, 0xD0, 0x27, 0x72, 0x01, 0x0C, 0xF9, 0x03, 0x72, 0x0B,
  0xF9, 0x0D, 0x03, 0x77, 0x02, 0x0C, 0xF9, 0x0A, 0x73, 0x02, 0x0E, 0xFA, 0x08, 0x01, 0x74, 0x07,
  0x0E, 0xF9, 0x0D, 0x01, 0x74, 0x05, 0xFC, 0x82, 0xA6, 0x31, 0x28, 0x31, 0x25, 0xAE, 0xFB, 0x03,
  0x76, 0x08, 0xFF, 0xFF, 0xA0, 0x67, 0x71, 0x08, 0xFF, 0xFF, 0x06, 0x77, 0x30, 0x8F, 0xFF, 0xD0,
  0x67, 0x75, 0x05, 0x0E, 0xFF, 0xF9, 0x0D, 0x03, 0x77, 0x70, 0x10, 0x9F, 0xFD, 0x0E, 0x08, 0x77,
  0x74, 0x81, 0x28, 0xEF, 0xF8, 0x1D, 0x71, 0x77, 0x77, 0x18, 0x43, 0x79, 0xCD, 0xEA, 0x84, 0xED,
  0xB9, 0x62, 0x77, 0x20,
  // "Ö" (U+00D6)
  0x72, 0x85, 0x18, 0xDF, 0xEB, 0x47, 0x78, 0x53, 0xAE, 0xFD, 0x91, 0x77, 0x30, 0x20, 0xDE, 0x08,
  0x75, 0x06, 0xE0, 0xE0, 0x37, 0x72, 0x0A, 0xF9, 0x03, 0x73, 0x01, 0xF9, 0x0C, 0x77, 0x20, 0xEF,
  0x90, 0x87, 0x30, 0x5F, 0xA0, 0x27, 0x70, 0x1F, 0xA0, 0xA7, 0x30, 0x7F, 0xA0, 0x47, 0x70, 0x1F,
  0xA0, 0x97, 0x30, 0x7F, 0xA0, 0x37, 0x71, 0x0E, 0xF9, 0x07, 0x73, 0x05, 0xFA, 0x01, 0x77, 0x10,
  0x9F, 0x90, 0x27, 0x40, 0xEF, 0x0B, 0x77, 0x20, 0x10, 0xCE, 0x06, 0x75, 0x04, 0xE0, 0xD0, 0x27,
  0x74, 0x84, 0x7D, 0xFE, 0xA3, 0x77, 0x85, 0x2A, 0xEF, 0xD8, 0x18, 0x0D, 0xA7, 0x08, 0x42, 0x69,
  0xBD, 0xEA, 0x84, 0xED, 0xB9, 0x62, 0x77, 0x77, 0x18, 0x11, 0x7D, 0xFF, 0x81, 0xD8, 0x17, 0x77,
  0x30, 0x10, 0x8F, 0xFE, 0x09, 0x01, 0x77, 0x70, 0x40, 0xEF, 0xFF, 0x90, 0xE0, 0x47, 0x75, 0x07,
  0xFF, 0xFD, 0x07, 0x77, 0x30, 0x7F, 0xFF, 0xF0, 0x87, 0x71, 0x07, 0xFF, 0xFF, 0xA0, 0x87, 0x60,
  0x4F, 0xC8, 0x2B, 0x63, 0x12, 0x83, 0x12, 0x59, 0xEF, 0xB0, 0x47, 0x40, 0x10, 0xEF, 0xA0, 0x90,
  0x17, 0x40, 0x70, 0xEF, 0x90, 0xE0, 0x27, 0x30, 0xAF, 0x90, 0xE0, 0x37, 0x70, 0x20, 0xCF, 0x90,
  0xB7, 0x20, 0x3F, 0x90, 0xD0, 0x27, 0x72, 0x01, 0x0C, 0xF9, 0x04, 0x71, 0x0C, 0xF9, 0x03, 0x77,
  0x40, 0x10, 0xEF, 0x0C, 0x70, 0x4F, 0x90, 0x77, 0x76, 0x05, 0xF9, 0x05, 0x60, 0xAF, 0x0D, 0x77,
  0x71, 0x0C, 0xF0, 0xB5, 0x01, 0xF9, 0x06, 0x77, 0x71, 0x04, 0xF9, 0x01, 0x40, 0x7F, 0x0E, 0x77,
  0x73, 0x0D, 0xF0, 0x74, 0x0C, 0xF0, 0x97, 0x77, 0x30, 0x8F, 0x0C, 0x4F, 0x90, 0x47, 0x77, 0x30,
  0x3F, 0x90, 0x12, 0x04, 0xF9, 0x77, 0x75, 0x0E, 0xF0, 0x52, 0x08, 0xF0, 0xB7, 0x77, 0x50, 0xAF,
  0x09, 0x20, 0xBF, 0x07, 0x77, 0x75, 0x07, 0xF0, 0xC2, 0x0E, 0xF0, 0x47, 0x77, 0x50, 0x3F, 0x81,
  0xE0, 0x1F, 0x90, 0x17, 0x77, 0x50, 0x1F, 0x90, 0x20, 0x4F, 0x0E, 0x77, 0x77, 0x0E, 0xF0, 0x50,
  0x6F, 0x0C, 0x77, 0x77, 0x0C, 0xF0, 0x60, 0x8F, 0x0B, 0x77, 0x77, 0x0A, 0xF0, 0x80, 0x9F, 0x09,
  0x77, 0x77, 0x09, 0xF0, 0x90, 0xBF, 0x08, 0x77, 0x77, 0x08, 0xF0, 0xB0, 0xCF, 0x07, 0x77, 0x77,
  0x07, 0xF0, 0xC0, 0xDF, 0x06, 0x77, 0x77, 0x06, 0xF0, 0x0D, 0xF0, 0x57, 0x77, 0x70, 0x5F, 0x0D,
  0x0E, 0xF0, 0x57, 0x77, 0x70, 0x5F, 0x00, 0xEF, 0x05, 0x77, 0x77, 0x05, 0xF0, 0x0E, 0xF0, 0x57,
  0x77, 0x70, 0x5F, 0x00, 0xEF, 0x05, 0x77, 0x77, 0x05, 0xF0, 0xE0, 0xDF, 0x05, 0x77, 0x77, 0x05,
  0xF0, 0x0D, 0xF0, 0x67, 0x77, 0x70, 0x6F, 0x0D, 0x0C, 0xF0, 0x77, 0x77, 0x70, 0x7F, 0x0C, 0x0B,
  0xF0, 0x87, 0x77, 0x70, 0x8F, 0x0B, 0x09, 0xF0, 0x97, 0x77, 0x70, 0x9F, 0x09, 0x08, 0xF0, 0xA7,
  0x77, 0x70, 0xAF, 0x08, 0x06, 0xF0, 0xC7, 0x77, 0x70, 0xCF, 0x06, 0x04, 0xF0, 0xE7, 0x77, 0x70,
  0xEF, 0x04, 0x02, 0xF9, 0x01, 0x77, 0x75, 0x01, 0xF9, 0x81, 0x10, 0xEF, 0x04, 0x77, 0x75, 0x04,
  0xF0, 0xE2, 0x0C, 0xF0, 0x77, 0x77, 0x50, 0x7F, 0x0B, 0x20, 0x9F, 0x0B, 0x77, 0x75, 0x0A, 0xF0,
  0x82, 0x05, 0xF0, 0xE7, 0x77, 0x50, 0xEF, 0x04, 0x20, 0x1F, 0x90, 0x47, 0x77, 0x30, 0x3F, 0x94,
  0x0C, 0xF0, 0x97, 0x77, 0x30, 0x8F, 0x0B, 0x40, 0x7F, 0x0E, 0x77, 0x73, 0x0D, 0xF0, 0x64, 0x01,
  0xF9, 0x06, 0x77, 0x71, 0x05, 0xF9, 0x01, 0x50, 0xBF, 0x0D, 0x77, 0x71, 0x0C, 0xF0, 0xA6, 0x05,
  0xF9, 0x06, 0x77, 0x60, 0x5F, 0x90, 0x47, 0x0D, 0xF9, 0x02, 0x77, 0x40, 0x10, 0xEF, 0x0B, 0x71,
  0x04, 0xF9, 0x0D, 0x02, 0x77, 0x20, 0x10, 0xCF, 0x90, 0x37, 0x20, 0xBF, 0x90, 0xD0, 0x37, 0x70,
  0x20, 0xCF, 0x90, 0xA7, 0x30, 0x20, 0xEF, 0xA0, 0x80, 0x17, 0x40, 0x70, 0xEF, 0x90, 0xD0, 0x17,
  0x40, 0x5F, 0xC8, 0x2A, 0x63, 0x12, 0x83, 0x12, 0x5A, 0xEF, 0xB0, 0x37, 0x60, 0x8F, 0xFF, 0xFA,
  0x06, 0x77, 0x10, 0x8F, 0xFF, 0xF0, 0x67, 0x73, 0x08, 0xFF, 0xFD, 0x06, 0x77, 0x50, 0x50, 0xEF,
  0xFF, 0x90, 0xD0, 0x37, 0x77, 0x01, 0x09, 0xFF, 0xD0, 0xE0, 0x87, 0x77, 0x48, 0x12, 0x8E, 0xFF,
  0x81, 0xD7, 0x17, 0x77, 0x71, 0x84, 0x37, 0x9C, 0xDE, 0xA8, 0x4E, 0xDB, 0x96, 0x27, 0x72,
  // "×" (U+00D7)
  0x40, 0x70, 0xB7, 0x77, 0x70, 0x09, 0x70, 0x7A, 0x0B, 0x77, 0x75, 0x09, 0xA0, 0x95, 0x07, 0xC0,
  0xB7, 0x77, 0x30, 0x9C, 0x09, 0x30, 0x7E, 0x0B, 0x77, 0x71, 0x09, 0xE8, 0x29, 0x01, 0xEF, 0x0B,
  0x77, 0x60, 0x9F, 0x83, 0xE2, 0x04, 0xEF, 0x0B, 0x77, 0x40, 0x9F, 0x0E, 0x04, 0x30, 0x40, 0xEF,
  0x0B, 0x77, 0x20, 0x9F, 0x0E, 0x04, 0x50, 0x40, 0xEF, 0x0A, 0x77, 0x09, 0xF0, 0xE0, 0x47, 0x04,
  0x0E, 0xF0, 0xA7, 0x50, 0x9F, 0x0E, 0x04, 0x72, 0x04, 0x0E, 0xF0, 0xA7, 0x30, 0x9F, 0x0E, 0x04,
  0x74, 0x04, 0x0E, 0xF0, 0xA7, 0x10, 0xAF, 0x0E, 0x04, 0x76, 0x04, 0x0E, 0xF0, 0xA6, 0x0A, 0xF0,
  0xE0, 0x47, 0x71, 0x04, 0x0E, 0xF0, 0xA4, 0x0A, 0xF0, 0xE0, 0x47, 0x73, 0x04, 0x0E, 0xF0, 0xA2,
  0x0A, 0xF0, 0xE0, 0x47, 0x75, 0x04, 0x0E, 0xF0, 0x0A, 0xF0, 0xE0, 0x47, 0x77, 0x04, 0x0E, 0xFF,
  0x0E, 0x04, 0x77, 0x72, 0x04, 0x0E, 0xFD, 0x0E, 0x04, 0x77, 0x74, 0x04, 0x0E, 0xFB, 0x0E, 0x04,
  0x77, 0x76, 0x04, 0x0E, 0xF9, 0x0E, 0x04, 0x77, 0x77, 0x10, 0xCF, 0x90, 0xC7, 0x77, 0x71, 0x0B,
  0xFB, 0x0B, 0x77, 0x76, 0x0B, 0xFD, 0x0B, 0x77, 0x74, 0x0B, 0xFF, 0x0B, 0x77, 0x72, 0x0A, 0xFF,
  0xA0, 0xB7, 0x77, 0x0A, 0xF8, 0x1E, 0x46, 0xF9, 0x0B, 0x77, 0x50, 0xAF, 0x0E, 0x04, 0x20, 0x5F,
  0x90, 0xA7, 0x73, 0x0A, 0xF9, 0x04, 0x40, 0x5F, 0x90, 0xA7, 0x71, 0x0A, 0xF9, 0x04, 0x60, 0x5F,
  0x90, 0xA7, 0x60, 0xAF, 0x90, 0x47, 0x10, 0x5F, 0x90, 0xA7, 0x40, 0x9F, 0x90, 0x47, 0x30, 0x5F,
  0x90, 0xA7, 0x20, 0x9F, 0x90, 0x47, 0x50, 0x4F, 0x90, 0xA7, 0x09, 0xF9, 0x04, 0x77, 0x04, 0xF9,
  0x0A, 0x50, 0x9F, 0x90, 0x47, 0x72, 0x04, 0xF9, 0x0A, 0x30, 0x9F, 0x90, 0x47, 0x74, 0x04, 0x0E,
  0xF8, 0x2A, 0x01, 0xDF, 0x04, 0x77, 0x60, 0x40, 0xEE, 0x83, 0xD1, 0x01, 0xCD, 0x04, 0x77, 0x71,
  0x03, 0x0E, 0xC0, 0xD0, 0x23, 0x01, 0x0C, 0xB0, 0x47, 0x77, 0x30, 0x30, 0xEA, 0x0D, 0x02, 0x58,
  0x21, 0xCF, 0x57, 0x77, 0x58, 0x23, 0xED, 0x27, 0x01, 0x04, 0x77, 0x77, 0x03, 0x02, 0x40,
  // "Ø" (U+00D8)
  0x80, 0xC3, 0x08, 0x18, 0x91, 0x80, 0xC6, 0x00, 0x2B, 0x08, 0x01, 0x77, 0x48, 0x42, 0x69, 0xBD,
  0xEA, 0x84, 0xED, 0xB9, 0x62, 0x71, 0x0B, 0xC0, 0xE0, 0x77, 0x78, 0x11, 0x7D, 0xFF, 0x81, 0xD6,
  0x14, 0x05, 0xF0, 0x37, 0x50, 0x8F, 0xFD, 0x0E, 0x08, 0x30, 0xDE, 0x0A, 0x74, 0x04, 0x0E, 0xFF,
  0xF9, 0x81, 0xD4, 0x7F, 0x02, 0x73, 0x06, 0xFF, 0xFF, 0xD0, 0x87, 0x30, 0x7F, 0xFF, 0xFD, 0x0E,
  0x01, 0x72, 0x07, 0xFF, 0xFF, 0xE0, 0x67, 0x20, 0x4F, 0xC8, 0x2B, 0x63, 0x12, 0x82, 0x13, 0x6B,
  0xFE, 0x0D, 0x72, 0x01, 0x0E, 0xFA, 0x09, 0x01, 0x73, 0x01, 0x0A, 0xFC, 0x05, 0x72, 0x0A, 0xF9,
  0x0E, 0x03, 0x77, 0x05, 0xFA, 0x0D, 0x72, 0x03, 0xF9, 0x0D, 0x02, 0x77, 0x20, 0x40, 0xEF, 0x90,
  0x47, 0x10, 0xCF, 0x90, 0x37, 0x73, 0x01, 0x0E, 0xF9, 0x0C, 0x70, 0x4F, 0x90, 0x77, 0x74, 0x09,
  0xFB, 0x04, 0x60, 0xAF, 0x0D, 0x77, 0x40, 0x2F, 0xC0, 0xB5, 0x01, 0xF9, 0x06, 0x77, 0x40, 0xBF,
  0xD0, 0x24, 0x07, 0xF0, 0xE7, 0x74, 0x05, 0xFE, 0x07, 0x40, 0xBF, 0x09, 0x77, 0x40, 0xDF, 0xE0,
  0xC4, 0xF9, 0x04, 0x77, 0x30, 0x7F, 0xF9, 0x01, 0x20, 0x4F, 0x97, 0x73, 0x01, 0x0E, 0xE0, 0x90,
  0xDF, 0x05, 0x20, 0x8F, 0x0B, 0x77, 0x30, 0x9E, 0x81, 0xE1, 0xAF, 0x09, 0x20, 0xBF, 0x07, 0x77,
  0x20, 0x3F, 0x81, 0x70, 0x6F, 0x0C, 0x20, 0xEF, 0x04, 0x77, 0x20, 0xBE, 0x0D, 0x20, 0x3F, 0x91,
  0x01, 0xF9, 0x01, 0x77, 0x10, 0x5F, 0x04, 0x20, 0x1F, 0x90, 0x20, 0x4F, 0x0E, 0x77, 0x20, 0xDE,
  0x0B, 0x40, 0xEF, 0x04, 0x06, 0xF0, 0xC7, 0x71, 0x07, 0xF0, 0x24, 0x0C, 0xF0, 0x60, 0x8F, 0x0B,
  0x77, 0x01, 0x0E, 0xE0, 0x95, 0x0A, 0xF0, 0x80, 0x9F, 0x09, 0x77, 0x09, 0xE0, 0xE0, 0x15, 0x09,
  0xF0, 0xA0, 0xBF, 0x08, 0x76, 0x03, 0xF0, 0x66, 0x08, 0xF0, 0xB0, 0xCF, 0x07, 0x76, 0x0B, 0xE0,
  0xD7, 0x07, 0xF0, 0xC0, 0xDF, 0x06, 0x75, 0x05, 0xF0, 0x47, 0x06, 0xF0, 0x0D, 0xF0, 0x57, 0x50,
  0xDE, 0x0B, 0x71, 0x06, 0xF0, 0xD0, 0xEF, 0x05, 0x74, 0x07, 0xF0, 0x27, 0x10, 0x5F, 0x00, 0xEF,
  0x05, 0x73, 0x01, 0x0E, 0xE0, 0x97, 0x20, 0x5F, 0x00, 0xEF, 0x05, 0x73, 0x09, 0xE0, 0xE0, 0x17,
  0x20, 0x5F, 0x00, 0xEF, 0x05, 0x72, 0x03, 0xF0, 0x67, 0x30, 0x5F, 0x00, 0xEF, 0x06, 0x72, 0x0B,
  0xE0, 0xD7, 0x40, 0x5F, 0x00, 0xDF, 0x06, 0x71, 0x05, 0xF0, 0x47, 0x40, 0x6F, 0x0D, 0x0C, 0xF0,
  0x67, 0x10, 0xDE, 0x0B, 0x75, 0x07, 0xF0, 0xC0, 0xBF, 0x08, 0x70, 0x7F, 0x02, 0x75, 0x07, 0xF0,
  0xB0, 0xAF, 0x09, 0x60, 0x10, 0xEE, 0x08, 0x76, 0x09, 0xF0, 0x09, 0xF0, 0xA6, 0x09, 0xE0, 0xE0,
  0x17, 0x60, 0xAF, 0x08, 0x07, 0xF0, 0xB5, 0x03, 0xF0, 0x67, 0x70, 0xCF, 0x06, 0x05, 0xF0, 0xD5,
  0x0B, 0xE0, 0xD7, 0x71, 0x0E, 0xF0, 0x40, 0x3F, 0x90, 0x13, 0x05, 0xF0, 0x47, 0x70, 0x1F, 0x90,
  0x11, 0xF9, 0x03, 0x30, 0xDE, 0x0B, 0x77, 0x10, 0x3F, 0x0E, 0x20, 0xCF, 0x06, 0x20, 0x7F, 0x02,
  0x77, 0x10, 0x7F, 0x0B, 0x20, 0x9F, 0x82, 0xA0, 0x1E, 0xE0, 0x87, 0x72, 0x0A, 0xF0, 0x82, 0x06,
  0xF8, 0x1E, 0x09, 0xE0, 0xE0, 0x17, 0x72, 0x0E, 0xF0, 0x42, 0x02, 0xF9, 0x06, 0xF0, 0x67, 0x72,
  0x03, 0xF9, 0x40, 0xDF, 0xF0, 0xC7, 0x73, 0x08, 0xF0, 0xB4, 0x08, 0xFF, 0x04, 0x77, 0x30, 0xDF,
  0x06, 0x40, 0x2F, 0xE0, 0xA7, 0x73, 0x04, 0xF9, 0x01, 0x50, 0xCF, 0xD0, 0x27, 0x73, 0x0C, 0xF0,
  0xA6, 0x05, 0xFC, 0x08, 0x77, 0x30, 0x5F, 0x90, 0x47, 0x0D, 0xFA, 0x0E, 0x77, 0x30, 0x10, 0xEF,
  0x0C, 0x71, 0x06, 0xFA, 0x07, 0x77, 0x20, 0x10, 0xCF, 0x90, 0x37, 0x20, 0xCF, 0x90, 0xE0, 0x47,
  0x70, 0x20, 0xCF, 0x90, 0xA7, 0x30, 0x6F, 0xB0, 0x90, 0x27, 0x40, 0x70, 0xEF, 0x90, 0xE0, 0x17,
  0x30, 0xDF, 0xD8, 0x2B, 0x73, 0x12, 0x83, 0x12, 0x59, 0xEF, 0xB0, 0x37, 0x30, 0x8F, 0xFF, 0xFD,
  0x07, 0x73, 0x02, 0xFF, 0xFF, 0xD0, 0x77, 0x40, 0xAF, 0xFF, 0xFC, 0x06, 0x74, 0x04, 0xF0, 0xA0,
  0xEF, 0xFF, 0x90, 0xD0, 0x47, 0x50, 0xCE, 0x82, 0xC0, 0x19, 0xFF, 0xE0, 0x87, 0x60, 0x6F, 0x04,
  0x38, 0x11, 0x7D, 0xFF, 0x81, 0xD7, 0x17, 0x70, 0x8E, 0x0A, 0x78, 0x42, 0x69, 0xCD, 0xEA, 0x84,
  0xED, 0xB9, 0x62, 0x77, 0x40, 0x20, 0xBC, 0x01, 0x80, 0xC5, 0x08, 0x23, 0xCF, 0x78, 0x0D, 0x00,
  0x05, 0x80, 0xC3, 0x00,
  // "Ù" (U+00D9)
  0x72, 0x80, 0x57, 0x04, 0x77, 0x77, 0x40, 0xEF, 0x90, 0xE7, 0x77, 0x74, 0x04, 0xFA, 0x07, 0x77,
  0x77, 0x40, 0x8F, 0x90, 0xE0, 0x17, 0x77, 0x74, 0x0B, 0xF9, 0x0A, 0x77, 0x77, 0x50, 0xCF, 0x90,
  0x47, 0x77, 0x74, 0x01, 0x0D, 0xF0, 0xD7, 0x77, 0x75, 0x02, 0x0E, 0xF0, 0x87, 0x77, 0x75, 0x03,
  0x0E, 0xF0, 0x37, 0x77, 0x75, 0x03, 0x0E, 0xE0, 0xC7, 0x77, 0x76, 0x03, 0x0E, 0xE0, 0x87, 0x77,
  0x76, 0x03, 0x0E, 0xE0, 0x47, 0x77, 0x76, 0x03, 0x0E, 0xD0, 0xE0, 0x17, 0x77, 0x76, 0x02, 0x0D,
  0xD0, 0xB7, 0x77, 0x77, 0x01, 0x0B, 0xD0, 0x18, 0x0C, 0x86, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06,
  0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0,
  0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30,
  0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF,
  0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73,
  0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A,
  0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77,
  0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00,
  0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77,
  0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0,
  0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67,
  0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F,
  0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06,
  0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06,
  0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0,
  0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30,
  0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF,
  0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73,
  0x07, 0xF0, 0xA0, 0x9F, 0x07, 0x77, 0x73, 0x08, 0xF0, 0x09, 0xF0, 0x87, 0x77, 0x30, 0x9F, 0x09,
  0x07, 0xF0, 0xA7, 0x77, 0x30, 0xAF, 0x07, 0x05, 0xF0, 0xC7, 0x77, 0x30, 0xDF, 0x05, 0x04, 0xF9,
  0x77, 0x73, 0xF9, 0x03, 0x01, 0xF9, 0x02, 0x77, 0x71, 0x03, 0xF9, 0x81, 0x10, 0xDF, 0x06, 0x77,
  0x71, 0x06, 0xF0, 0xD2, 0x0A, 0xF0, 0xB7, 0x77, 0x10, 0xAF, 0x09, 0x20, 0x6F, 0x90, 0x17, 0x76,
  0x01, 0xF9, 0x05, 0x20, 0x1F, 0x90, 0x97, 0x76, 0x08, 0xF9, 0x40, 0xCF, 0x90, 0x37, 0x74, 0x02,
  0x0E, 0xF0, 0xA4, 0x05, 0xF9, 0x0D, 0x01, 0x77, 0x30, 0xCF, 0x90, 0x35, 0x0D, 0xF9, 0x0D, 0x01,
  0x77, 0x01, 0x0C, 0xF9, 0x0C, 0x60, 0x6F, 0xA0, 0xE0, 0x67, 0x50, 0x50, 0xEF, 0xA0, 0x37, 0x0B,
  0xFB, 0x83, 0xE9, 0x52, 0x12, 0x83, 0x12, 0x58, 0xEF, 0xB0, 0x87, 0x10, 0x10, 0xEF, 0xFF, 0xFA,
  0x0C, 0x73, 0x03, 0x0E, 0xFF, 0xFF, 0x0D, 0x01, 0x74, 0x03, 0x0E, 0xFF, 0xFD, 0x0C, 0x01, 0x76,
  0x01, 0x0C, 0xFF, 0xFB, 0x09, 0x77, 0x30, 0x60, 0xDF, 0xFE, 0x0C, 0x03, 0x77, 0x60, 0x60, 0xBF,
  0xF9, 0x81, 0xEA, 0x47, 0x77, 0x38, 0x51, 0x57, 0xAC, 0xDE, 0xA8, 0x4E, 0xDC, 0x97, 0x47, 0x70,
  // "Ú" (U+00DA)
  0x77, 0x74, 0x03, 0x80, 0x57, 0x01, 0x77, 0x77, 0x30, 0xCF, 0xA0, 0x27, 0x77, 0x72, 0x05, 0xFA,
  0x08, 0x77, 0x77, 0x30, 0xDF, 0x90, 0xB7, 0x77, 0x73, 0x08, 0xF9, 0x0D, 0x01, 0x77, 0x77, 0x20,
  0x2F, 0x90, 0xE0, 0x27, 0x77, 0x73, 0x0C, 0xF0, 0xE0, 0x37, 0x77, 0x73, 0x06, 0xF9, 0x04, 0x77,
  0x77, 0x30, 0x10, 0xEF, 0x05, 0x77, 0x77, 0x40, 0xBF, 0x05, 0x77, 0x77, 0x40, 0x5F, 0x06, 0x77,
  0x77, 0x40, 0x10, 0xEE, 0x05, 0x77, 0x77, 0x50, 0xBE, 0x05, 0x77, 0x77, 0x50, 0x8D, 0x0E, 0x04,
  0x77, 0x77, 0x60, 0xDC, 0x0C, 0x02, 0x80, 0xC9, 0x20, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00,
  0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77,
  0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0,
  0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67,
  0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F,
  0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06,
  0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06,
  0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0,
  0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30,
  0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF,
  0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73,
  0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A,
  0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77,
  0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00,
  0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77,
  0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0,
  0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67,
  0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x7F,
  0x0A, 0x09, 0xF0, 0x77, 0x77, 0x30, 0x8F, 0x00, 0x9F, 0x08, 0x77, 0x73, 0x09, 0xF0, 0x90, 0x7F,
  0x0A, 0x77, 0x73, 0x0A, 0xF0, 0x70, 0x5F, 0x0C, 0x77, 0x73, 0x0D, 0xF0, 0x50, 0x4F, 0x97, 0x77,
  0x3F, 0x90, 0x30, 0x1F, 0x90, 0x27, 0x77, 0x10, 0x3F, 0x98, 0x11, 0x0D, 0xF0, 0x67, 0x77, 0x10,
  0x6F, 0x0D, 0x20, 0xAF, 0x0B, 0x77, 0x71, 0x0A, 0xF0, 0x92, 0x06, 0xF9, 0x01, 0x77, 0x60, 0x1F,
  0x90, 0x52, 0x01, 0xF9, 0x09, 0x77, 0x60, 0x8F, 0x94, 0x0C, 0xF9, 0x03, 0x77, 0x40, 0x20, 0xEF,
  0x0A, 0x40, 0x5F, 0x90, 0xD0, 0x17, 0x73, 0x0C, 0xF9, 0x03, 0x50, 0xDF, 0x90, 0xD0, 0x17, 0x70,
  0x10, 0xCF, 0x90, 0xC6, 0x06, 0xFA, 0x0E, 0x06, 0x75, 0x05, 0x0E, 0xFA, 0x03, 0x70, 0xBF, 0xB8,
  0x3E, 0x95, 0x21, 0x28, 0x31, 0x25, 0x8E, 0xFB, 0x08, 0x71, 0x01, 0x0E, 0xFF, 0xFF, 0xA0, 0xC7,
  0x30, 0x30, 0xEF, 0xFF, 0xF0, 0xD0, 0x17, 0x40, 0x30, 0xEF, 0xFF, 0xD0, 0xC0, 0x17, 0x60, 0x10,
  0xCF, 0xFF, 0xB0, 0x97, 0x73, 0x06, 0x0D, 0xFF, 0xE0, 0xC0, 0x37, 0x76, 0x06, 0x0B, 0xFF, 0x98,
  0x1E, 0xA4, 0x77, 0x73, 0x85, 0x15, 0x7A, 0xCD, 0xEA, 0x84, 0xED, 0xC9, 0x74, 0x77,
  // "Û" (U+00DB)
  0x77, 0x20, 0x28, 0x04, 0x77, 0x77, 0x75, 0x0C, 0xF9, 0x08, 0x77, 0x77, 0x30, 0x6F, 0xB0, 0x37,
  0x77, 0x71, 0x03, 0xFC, 0x0D, 0x01, 0x77, 0x77, 0x0D, 0xFD, 0x0A, 0x77, 0x76, 0x0B, 0xFF, 0x07,
  0x77, 0x74, 0x08, 0xF0, 0xA0, 0xDF, 0x05, 0x77, 0x72, 0x06, 0xF8, 0x29, 0x01, 0xDF, 0x03, 0x77,
  0x70, 0x4F, 0x09, 0x30, 0x10, 0xDE, 0x0E, 0x02, 0x77, 0x50, 0x20, 0xEE, 0x09, 0x50, 0x10, 0xCE,
  0x0D, 0x01, 0x77, 0x30, 0x10, 0xDE, 0x08, 0x70, 0x10, 0xCE, 0x0C, 0x77, 0x30, 0xCE, 0x08, 0x72,
  0x01, 0x0B, 0xE0, 0xB7, 0x71, 0x0B, 0xE0, 0x67, 0x50, 0xAE, 0x0A, 0x76, 0x0A, 0xD0, 0xE0, 0x47,
  0x70, 0x7E, 0x0A, 0x74, 0x03, 0xD0, 0xB0, 0x17, 0x72, 0x03, 0x0D, 0xD0, 0x38, 0x0B, 0xF5, 0x00,
  0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77,
  0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0,
  0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67,
  0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F,
  0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06,
  0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06,
  0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0,
  0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30,
  0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF,
  0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73,
  0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A,
  0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77,
  0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00,
  0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77,
  0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0,
  0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67,
  0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F,
  0x00, 0xAF, 0x06, 0x77, 0x73, 0x07, 0xF0, 0xA0, 0x9F, 0x07, 0x77, 0x73, 0x08, 0xF0, 0x09, 0xF0,
  0x87, 0x77, 0x30, 0x9F, 0x09, 0x07, 0xF0, 0xA7, 0x77, 0x30, 0xAF, 0x07, 0x05, 0xF0, 0xC7, 0x77,
  0x30, 0xDF, 0x05, 0x04, 0xF9, 0x77, 0x73, 0xF9, 0x03, 0x01, 0xF9, 0x02, 0x77, 0x71, 0x03, 0xF9,
  0x81, 0x10, 0xDF, 0x06, 0x77, 0x71, 0x06, 0xF0, 0xD2, 0x0A, 0xF0, 0xB7, 0x77, 0x10, 0xAF, 0x09,
  0x20, 0x6F, 0x90, 0x17, 0x76, 0x01, 0xF9, 0x05, 0x20, 0x1F, 0x90, 0x97, 0x76, 0x08, 0xF9, 0x40,
  0xCF, 0x90, 0x37, 0x74, 0x02, 0x0E, 0xF0, 0xA4, 0x05, 0xF9, 0x0D, 0x01, 0x77, 0x30, 0xCF, 0x90,
  0x35, 0x0D, 0xF9, 0x0D, 0x01, 0x77, 0x01, 0x0C, 0xF9, 0x0C, 0x60, 0x6F, 0xA0, 0xE0, 0x67, 0x50,
  0x50, 0xEF, 0xA0, 0x37, 0x0B, 0xFB, 0x83, 0xE9, 0x52, 0x12, 0x83, 0x12, 0x58, 0xEF, 0xB0, 0x87,
  0x10, 0x10, 0xEF, 0xFF, 0xFA, 0x0C, 0x73, 0x03, 0x0E, 0xFF, 0xFF, 0x0D, 0x01, 0x74, 0x03, 0x0E,
  0xFF, 0xFD, 0x0C, 0x01, 0x76, 0x01, 0x0C, 0xFF, 0xFB, 0x09, 0x77, 0x30, 0x60, 0xDF, 0xFE, 0x0C,
  0x03, 0x77, 0x60, 0x60, 0xBF, 0xF9, 0x81, 0xEA, 0x47, 0x77, 0x38, 0x51, 0x57, 0xAC, 0xDE, 0xA8,
  0x4E, 0xDC, 0x97, 0x47, 0x70,
  // "Ü" (U+00DC)
  0x78, 0x51, 0x8D, 0xFE, 0xB4, 0x77, 0x85, 0x3A, 0xEF, 0xD9, 0x17, 0x60, 0x20, 0xDE, 0x08, 0x75,
  0x06, 0xE0, 0xE0, 0x37, 0x50, 0xAF, 0x90, 0x37, 0x30, 0x1F, 0x90, 0xC7, 0x50, 0xEF, 0x90, 0x87,
  0x30, 0x5F, 0xA0, 0x27, 0x30, 0x1F, 0xA0, 0xA7, 0x30, 0x7F, 0xA0, 0x47, 0x30, 0x1F, 0xA0, 0x97,
  0x30, 0x7F, 0xA0, 0x37, 0x40, 0xEF, 0x90, 0x77, 0x30, 0x5F, 0xA0, 0x17, 0x40, 0x9F, 0x90, 0x27,
  0x40, 0xEF, 0x0B, 0x75, 0x01, 0x0C, 0xE0, 0x67, 0x50, 0x4E, 0x0D, 0x02, 0x77, 0x84, 0x7D, 0xFE,
  0xA3, 0x77, 0x85, 0x2A, 0xEF, 0xD8, 0x18, 0x0D, 0xA3, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0,
  0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67,
  0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F,
  0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06,
  0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06,
  0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0,
  0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30,
  0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF,
  0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73,
  0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A,
  0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77,
  0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00,
  0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77,
  0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0,
  0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67,
  0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F,
  0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06,
  0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x07,
  0xF0, 0xA0, 0x9F, 0x07, 0x77, 0x73, 0x08, 0xF0, 0x09, 0xF0, 0x87, 0x77, 0x30, 0x9F, 0x09, 0x07,
  0xF0, 0xA7, 0x77, 0x30, 0xAF, 0x07, 0x05, 0xF0, 0xC7, 0x77, 0x30, 0xDF, 0x05, 0x04, 0xF9, 0x77,
  0x73, 0xF9, 0x03, 0x01, 0xF9, 0x02, 0x77, 0x71, 0x03, 0xF9, 0x81, 0x10, 0xDF, 0x06, 0x77, 0x71,
  0x06, 0xF0, 0xD2, 0x0A, 0xF0, 0xB7, 0x77, 0x10, 0xAF, 0x09, 0x20, 0x6F, 0x90, 0x17, 0x76, 0x01,
  0xF9, 0x05, 0x20, 0x1F, 0x90, 0x97, 0x76, 0x08, 0xF9, 0x40, 0xCF, 0x90, 0x37, 0x74, 0x02, 0x0E,
  0xF0, 0xA4, 0x05, 0xF9, 0x0D, 0x01, 0x77, 0x30, 0xCF, 0x90, 0x35, 0x0D, 0xF9, 0x0D, 0x01, 0x77,
  0x01, 0x0C, 0xF9, 0x0C, 0x60, 0x6F, 0xA0, 0xE0, 0x67, 0x50, 0x50, 0xEF, 0xA0, 0x37, 0x0B, 0xFB,
  0x83, 0xE9, 0x52, 0x12, 0x83, 0x12, 0x58, 0xEF, 0xB0, 0x87, 0x10, 0x10, 0xEF, 0xFF, 0xFA, 0x0C,
  0x73, 0x03, 0x0E, 0xFF, 0xFF, 0x0D, 0x01, 0x74, 0x03, 0x0E, 0xFF, 0xFD, 0x0C, 0x01, 0x76, 0x01,
  0x0C, 0xFF, 0xFB, 0x09, 0x77, 0x30, 0x60, 0xDF, 0xFE, 0x0C, 0x03, 0x77, 0x60, 0x60, 0xBF, 0xF9,
  0x81, 0xEA, 0x47, 0x77, 0x38, 0x51, 0x57, 0xAC, 0xDE, 0xA8, 0x4E, 0xDC, 0x97, 0x47, 0x70,
  // "Ý" (U+00DD)
  0x77, 0x77, 0x03, 0x80, 0x57, 0x01, 0x80, 0xC1, 0x00, 0xCF, 0xA0, 0x28, 0x0C, 0x00, 0x05, 0xFA,
  0x08, 0x80, 0xC1, 0x00, 0xDF, 0x90, 0xB8, 0x0C, 0x10, 0x08, 0xF9, 0x0D, 0x01, 0x80, 0xC0, 0x00,
  0x2F, 0x90, 0xE0, 0x28, 0x0C, 0x10, 0x0C, 0xF0, 0xE0, 0x38, 0x0C, 0x10, 0x06, 0xF9, 0x04, 0x80,
  0xC1, 0x00, 0x10, 0xEF, 0x05, 0x80, 0xC2, 0x00, 0xBF, 0x05, 0x80, 0xC2, 0x00, 0x5F, 0x06, 0x80,
  0xC2, 0x00, 0x10, 0xEE, 0x05, 0x80, 0xC3, 0x00, 0xBE, 0x05, 0x80, 0xC3, 0x00, 0x8D, 0x0E, 0x04,
  0x80, 0xC4, 0x00, 0xDC, 0x0C, 0x02, 0x80, 0xCE, 0x10, 0x09, 0xF9, 0x04, 0x77, 0x77, 0x01, 0x0E,
  0xF0, 0x90, 0x1F, 0x90, 0xB7, 0x77, 0x70, 0x7F, 0x98, 0x11, 0x09, 0xF9, 0x03, 0x77, 0x76, 0x0E,
  0xF0, 0x82, 0x01, 0xF9, 0x0A, 0x77, 0x75, 0x06, 0xF9, 0x01, 0x30, 0x8F, 0x90, 0x27, 0x77, 0x40,
  0xDF, 0x08, 0x40, 0x10, 0xEF, 0x09, 0x77, 0x73, 0x05, 0xF0, 0xE0, 0x15, 0x08, 0xF0, 0xE0, 0x17,
  0x77, 0x20, 0xCF, 0x08, 0x60, 0x10, 0xEF, 0x07, 0x77, 0x71, 0x03, 0xF0, 0xE0, 0x17, 0x08, 0xF0,
  0xE7, 0x77, 0x10, 0xBF, 0x08, 0x71, 0x01, 0x0E, 0xF0, 0x67, 0x76, 0x02, 0xF0, 0xE0, 0x17, 0x20,
  0x8F, 0x0D, 0x77, 0x60, 0x9F, 0x08, 0x73, 0x01, 0x0E, 0xF0, 0x57, 0x74, 0x01, 0xF0, 0xE0, 0x17,
  0x40, 0x8F, 0x0C, 0x77, 0x40, 0x8F, 0x07, 0x75, 0x01, 0x0E, 0xF0, 0x37, 0x72, 0x01, 0x0E, 0xE0,
  0xE0, 0x17, 0x60, 0x7F, 0x0A, 0x77, 0x20, 0x7F, 0x07, 0x77, 0x10, 0xEF, 0x02, 0x77, 0x10, 0xEE,
  0x0E, 0x77, 0x20, 0x7F, 0x09, 0x77, 0x06, 0xF0, 0x77, 0x73, 0x0E, 0xF0, 0x17, 0x60, 0xDE, 0x0E,
  0x77, 0x40, 0x7F, 0x08, 0x75, 0x04, 0xF0, 0x77, 0x75, 0x0E, 0xE0, 0xE7, 0x50, 0xCE, 0x0E, 0x77,
  0x60, 0x7F, 0x07, 0x73, 0x03, 0xF0, 0x77, 0x77, 0x0E, 0xE0, 0xD7, 0x30, 0xAE, 0x0E, 0x77, 0x71,
  0x07, 0xF0, 0x57, 0x10, 0x2F, 0x07, 0x77, 0x72, 0x0E, 0xE0, 0xC7, 0x10, 0x9E, 0x0E, 0x77, 0x73,
  0x06, 0xF0, 0x46, 0x01, 0xF0, 0x67, 0x77, 0x40, 0xDE, 0x0B, 0x60, 0x8E, 0x0D, 0x77, 0x75, 0x06,
  0xF0, 0x35, 0x0E, 0xE0, 0x67, 0x77, 0x60, 0xDE, 0x0A, 0x40, 0x7E, 0x0D, 0x77, 0x77, 0x06, 0xF0,
  0x23, 0x0D, 0xE0, 0x67, 0x77, 0x71, 0x0D, 0xE0, 0x82, 0x05, 0xE0, 0xD7, 0x77, 0x72, 0x06, 0xE8,
  0x2E, 0x10, 0xDE, 0x06, 0x77, 0x77, 0x30, 0xDE, 0x07, 0x04, 0xE0, 0xD7, 0x77, 0x74, 0x06, 0xE0,
  0xE0, 0xCE, 0x06, 0x77, 0x77, 0x50, 0xDF, 0xD0, 0xD7, 0x77, 0x76, 0x05, 0xFD, 0x05, 0x77, 0x77,
  0x70, 0xDF, 0xB0, 0xD8, 0x0C, 0x00, 0x05, 0xFB, 0x05, 0x80, 0xC1, 0x00, 0xDF, 0x90, 0xD8, 0x0C,
  0x20, 0x05, 0xF9, 0x05, 0x80, 0xC3, 0x00, 0xEE, 0x0E, 0x80, 0xC4, 0x00, 0xDE, 0x0D, 0x80, 0xC4,
  0x00, 0xDE, 0x0D, 0x80, 0xC4, 0x00, 0xDE, 0x0D, 0x80, 0xC4, 0x00, 0xDE, 0x0D, 0x80, 0xC4, 0x00,
  0xDE, 0x0D, 0x80, 0xC4, 0x00, 0xDE, 0x0D, 0x80, 0xC4, 0x00, 0xDE, 0x0D, 0x80, 0xC4, 0x00, 0xDE,
  0x0D, 0x80, 0xC4, 0x00, 0xDE, 0x0D, 0x80, 0xC4, 0x00, 0xDE, 0x0D, 0x80, 0xC4, 0x00, 0xDE, 0x0D,
  0x80, 0xC4, 0x00, 0xDE, 0x0D, 0x80, 0xC4, 0x00, 0xDE, 0x0D, 0x80, 0xC4, 0x00, 0xDE, 0x0D, 0x80,
  0xC4, 0x00, 0xDE, 0x0D, 0x80, 0xC4, 0x00, 0xDE, 0x0D, 0x80, 0xC4, 0x00, 0xDE, 0x0D, 0x80, 0xC4,
  0x00, 0xDE, 0x0D, 0x80, 0xC4, 0x00, 0xDE, 0x0D, 0x80, 0xC4, 0x00, 0xDE, 0x0D, 0x80, 0xC4, 0x00,
  0xDE, 0x0D, 0x80, 0xC4, 0x00, 0xDE, 0x0D, 0x80, 0xC4, 0x00, 0xDE, 0x0D, 0x80, 0xC4, 0x00, 0xDE,
  0x0D, 0x77, 0x60,
  // "Þ" (U+00DE)
  0x07, 0xF0, 0xA7, 0x77, 0x74, 0x07, 0xF0, 0xA7, 0x77, 0x74, 0x07, 0xF0, 0xA7, 0x77, 0x74, 0x07,
  0xF0, 0xA7, 0x77, 0x74, 0x07, 0xF0, 0xA7, 0x77, 0x74, 0x07, 0xF0, 0xA7, 0x77, 0x74, 0x07, 0xF0,
  0xA7, 0x77, 0x74, 0x07, 0xF0, 0xA7, 0x77, 0x74, 0x07, 0xF0, 0xA7, 0x77, 0x74, 0x07, 0xF0, 0xA7,
  0x77, 0x74, 0x07, 0xF0, 0xA7, 0x77, 0x74, 0x07, 0xF0, 0xA7, 0x77, 0x74, 0x07, 0xFF, 0xD8, 0x6E,
  0xED, 0xBA, 0x75, 0x17, 0x60, 0x7F, 0xFF, 0xE8, 0x1D, 0x93, 0x73, 0x07, 0xFF, 0xFF, 0xA0, 0xD0,
  0x57, 0x10, 0x7F, 0xFF, 0xFC, 0x0C, 0x03, 0x60, 0x7F, 0xFF, 0xFE, 0x05, 0x50, 0x7F, 0xFF, 0xFF,
  0x06, 0x40, 0x7F, 0x0D, 0x80, 0x68, 0x82, 0x9A, 0xBE, 0xFF, 0x05, 0x30, 0x7F, 0x0A, 0x77, 0x81,
  0x14, 0xAF, 0xC0, 0xE0, 0x22, 0x07, 0xF0, 0xA7, 0x73, 0x01, 0x08, 0xFB, 0x0A, 0x20, 0x7F, 0x0A,
  0x77, 0x50, 0x30, 0xDF, 0xA8, 0x13, 0x07, 0xF0, 0xA7, 0x76, 0x02, 0x0E, 0xF9, 0x81, 0xA0, 0x7F,
  0x0A, 0x77, 0x70, 0x3F, 0xA1, 0x07, 0xF0, 0xA7, 0x77, 0x10, 0xAF, 0x90, 0x50, 0x7F, 0x0A, 0x77,
  0x71, 0x02, 0xF9, 0x08, 0x07, 0xF0, 0xA7, 0x77, 0x20, 0xDF, 0x0B, 0x07, 0xF0, 0xA7, 0x77, 0x20,
  0x9F, 0x0D, 0x07, 0xF0, 0xA7, 0x77, 0x20, 0x6F, 0x90, 0x7F, 0x0A, 0x77, 0x72, 0x05, 0xF9, 0x07,
  0xF0, 0xA7, 0x77, 0x20, 0x4F, 0x90, 0x7F, 0x0A, 0x77, 0x72, 0x04, 0xF9, 0x07, 0xF0, 0xA7, 0x77,
  0x20, 0x5F, 0x0E, 0x07, 0xF0, 0xA7, 0x77, 0x20, 0x6F, 0x0C, 0x07, 0xF0, 0xA7, 0x77, 0x20, 0x9F,
  0x09, 0x07, 0xF0, 0xA7, 0x77, 0x20, 0xDF, 0x00, 0x7F, 0x0A, 0x77, 0x71, 0x01, 0xF9, 0x02, 0x07,
  0xF0, 0xA7, 0x77, 0x10, 0x8F, 0x81, 0xD0, 0x7F, 0x0A, 0x77, 0x70, 0x2F, 0x98, 0x18, 0x07, 0xF0,
  0xA7, 0x77, 0x0B, 0xF9, 0x81, 0x20, 0x7F, 0x0A, 0x77, 0x60, 0xBF, 0x90, 0xA2, 0x07, 0xF0, 0xA7,
  0x74, 0x04, 0x0D, 0xF9, 0x0E, 0x01, 0x20, 0x7F, 0x0A, 0x77, 0x20, 0x50, 0xBF, 0xB0, 0x73, 0x07,
  0xF0, 0xA7, 0x28, 0x51, 0x23, 0x58, 0xAE, 0xFC, 0x0A, 0x40, 0x7F, 0xFF, 0xFE, 0x0B, 0x50, 0x7F,
  0xFF, 0xFD, 0x09, 0x60, 0x7F, 0xFF, 0xFB, 0x0E, 0x06, 0x70, 0x7F, 0xFF, 0xFA, 0x0A, 0x01, 0x71,
  0x07, 0xFF, 0xFF, 0x09, 0x02, 0x73, 0x07, 0xFF, 0xFB, 0x81, 0xC9, 0x47, 0x60, 0x7F, 0x0D, 0x80,
  0x68, 0x83, 0x76, 0x64, 0x27, 0x73, 0x07, 0xF0, 0xA7, 0x77, 0x74, 0x07, 0xF0, 0xA7, 0x77, 0x74,
  0x07, 0xF0, 0xA7, 0x77, 0x74, 0x07, 0xF0, 0xA7, 0x77, 0x74, 0x07, 0xF0, 0xA7, 0x77, 0x74, 0x07,
  0xF0, 0xA7, 0x77, 0x74, 0x07, 0xF0, 0xA7, 0x77, 0x74, 0x07, 0xF0, 0xA7, 0x77, 0x74, 0x07, 0xF0,
  0xA7, 0x77, 0x74, 0x07, 0xF0, 0xA7, 0x77, 0x74, 0x07, 0xF0, 0xA7, 0x77, 0x74, 0x07, 0xF0, 0xA7,
  0x77, 0x74, 0x07, 0xF0, 0xA7, 0x77, 0x74,
  // "ß" (U+00DF)
  0x75, 0x89, 0x71, 0x47, 0x9B, 0xDE, 0xEF, 0xED, 0xDC, 0xA7, 0x52, 0x77, 0x75, 0x81, 0x16, 0xBF,
  0xFB, 0x81, 0xD8, 0x37, 0x77, 0x01, 0x09, 0xFF, 0xFA, 0x0B, 0x04, 0x77, 0x40, 0x60, 0xEF, 0xFF,
  0xD0, 0xB0, 0x27, 0x71, 0x09, 0xFF, 0xFF, 0x90, 0xE0, 0x47, 0x60, 0xAF, 0xFF, 0xFC, 0x04, 0x74,
  0x07, 0xFE, 0x86, 0xCA, 0x98, 0x99, 0xBD, 0xFD, 0x0E, 0x02, 0x72, 0x02, 0xFB, 0x81, 0xD7, 0x37,
  0x28, 0x11, 0x5B, 0xFB, 0x0A, 0x72, 0x0B, 0xF9, 0x0E, 0x06, 0x77, 0x10, 0x20, 0xCF, 0xA0, 0x27,
  0x02, 0xF9, 0x0E, 0x02, 0x77, 0x40, 0xBF, 0x90, 0x77, 0x07, 0xF9, 0x03, 0x77, 0x50, 0x10, 0xEF,
  0x0B, 0x70, 0xBF, 0x09, 0x77, 0x70, 0x8F, 0x0D, 0x70, 0xEF, 0x03, 0x77, 0x70, 0x5F, 0x0E, 0x60,
  0x1F, 0x0E, 0x77, 0x71, 0x03, 0xF0, 0xE6, 0x02, 0xF0, 0xC7, 0x77, 0x10, 0x4F, 0x0D, 0x60, 0x3F,
  0x0B, 0x77, 0x71, 0x07, 0xF0, 0xB6, 0x03, 0xF0, 0xA7, 0x77, 0x10, 0xCF, 0x07, 0x60, 0x3F, 0x0A,
  0x77, 0x70, 0x6F, 0x90, 0x26, 0x03, 0xF0, 0xA7, 0x76, 0x03, 0xF9, 0x0A, 0x70, 0x3F, 0x0A, 0x77,
  0x50, 0x30, 0xEF, 0x0E, 0x01, 0x70, 0x3F, 0x0A, 0x77, 0x40, 0x5F, 0xA0, 0x57, 0x10, 0x3F, 0x0A,
  0x77, 0x30, 0x8F, 0xA0, 0x77, 0x20, 0x3F, 0x0A, 0x77, 0x10, 0x10, 0xBF, 0xA0, 0x87, 0x30, 0x3F,
  0x0A, 0x77, 0x02, 0x0D, 0xFA, 0x06, 0x74, 0x03, 0xF0, 0xA7, 0x60, 0x30, 0xEF, 0x90, 0xE0, 0x47,
  0x50, 0x3F, 0x0A, 0x75, 0x01, 0x0E, 0xF9, 0x0C, 0x02, 0x76, 0x03, 0xF0, 0xA7, 0x50, 0xBF, 0x90,
  0xA7, 0x71, 0x03, 0xF0, 0xA7, 0x40, 0x6F, 0x90, 0x97, 0x72, 0x03, 0xF0, 0xA7, 0x40, 0xCF, 0x0A,
  0x77, 0x30, 0x3F, 0x0A, 0x73, 0x01, 0xF0, 0xE0, 0x17, 0x73, 0x03, 0xF0, 0xA7, 0x30, 0x3F, 0x09,
  0x77, 0x40, 0x3F, 0x0A, 0x73, 0x04, 0xF0, 0x67, 0x74, 0x03, 0xF0, 0xA7, 0x30, 0x4F, 0x07, 0x77,
  0x40, 0x3F, 0x0A, 0x73, 0x03, 0xF0, 0xD7, 0x74, 0x03, 0xF0, 0xA7, 0x4F, 0x90, 0x97, 0x73, 0x03,
  0xF0, 0xA7, 0x40, 0xBF, 0x90, 0xA0, 0x17, 0x71, 0x03, 0xF0, 0xA7, 0x40, 0x4F, 0xA0, 0xE0, 0x47,
  0x70, 0x3F, 0x0A, 0x75, 0x09, 0xFB, 0x09, 0x76, 0x03, 0xF0, 0xA7, 0x60, 0xBF, 0xB0, 0xD0, 0x37,
  0x40, 0x3F, 0x0A, 0x77, 0x0B, 0xFC, 0x07, 0x73, 0x03, 0xF0, 0xA7, 0x71, 0x09, 0xFC, 0x0C, 0x02,
  0x71, 0x03, 0xF0, 0xA7, 0x72, 0x06, 0xFC, 0x0E, 0x05, 0x70, 0x3F, 0x0A, 0x77, 0x30, 0x30, 0xDF,
  0xC0, 0x86, 0x03, 0xF0, 0xA7, 0x75, 0x09, 0xFC, 0x0A, 0x50, 0x3F, 0x0A, 0x77, 0x60, 0x40, 0xEF,
  0xB0, 0xB4, 0x03, 0xF0, 0xA7, 0x77, 0x01, 0x0A, 0xFB, 0x0A, 0x30, 0x3F, 0x0A, 0x77, 0x72, 0x06,
  0x0E, 0xFA, 0x06, 0x20, 0x3F, 0x0A, 0x77, 0x73, 0x02, 0x0D, 0xF9, 0x82, 0xE1, 0x03, 0xF0, 0xA7,
  0x77, 0x40, 0x10, 0xBF, 0x98, 0x18, 0x03, 0xF0, 0xA7, 0x77, 0x60, 0xCF, 0x81, 0xE0, 0x3F, 0x0A,
  0x77, 0x76, 0x02, 0xF9, 0x00, 0x3F, 0x0A, 0x77, 0x77, 0x0A, 0xF0, 0x70, 0x3F, 0x0A, 0x77, 0x77,
  0x05, 0xF0, 0x90, 0x3F, 0x0A, 0x77, 0x77, 0x04, 0xF0, 0xA0, 0x3F, 0x0A, 0x77, 0x77, 0x03, 0xF0,
  0xB0, 0x3F, 0x0A, 0x77, 0x77, 0x03, 0xF0, 0xB0, 0x3F, 0x0A, 0x77, 0x77, 0x05, 0xF0, 0xA0, 0x3F,
  0x0A, 0x77, 0x77, 0x09, 0xF0, 0x80, 0x3F, 0x0A, 0x77, 0x76, 0x01, 0x0E, 0xF0, 0x50, 0x3F, 0x0A,
  0x70, 0xE0, 0x67, 0x74, 0x09, 0xF9, 0x02, 0x03, 0xF0, 0xA7, 0xA8, 0x1E, 0x82, 0x77, 0x07, 0xF9,
  0x81, 0xC0, 0x3F, 0x0A, 0x7D, 0x81, 0xB7, 0x27, 0x20, 0x40, 0xBF, 0xA8, 0x16, 0x03, 0xF0, 0xA7,
  0xF9, 0x87, 0xEC, 0xA9, 0x89, 0x9B, 0xEF, 0xB0, 0xD2, 0x03, 0xF0, 0xA7, 0xFF, 0xFE, 0x03, 0x20,
  0x3F, 0x0A, 0x7F, 0xFF, 0xD0, 0x43, 0x03, 0xF0, 0xA7, 0xFF, 0xFB, 0x0D, 0x03, 0x40, 0x3F, 0x0A,
  0x70, 0x30, 0xBF, 0xFF, 0x07, 0x60, 0x3F, 0x0A, 0x72, 0x81, 0x38, 0xDF, 0xF9, 0x81, 0xC7, 0x17,
  0x77, 0x78, 0x95, 0x36, 0x8B, 0xDD, 0xEF, 0xED, 0xDB, 0x85, 0x27, 0x30,
  // "à" (U+00E0)
  0x72, 0x80, 0x57, 0x04, 0x77, 0x77, 0x20, 0xEF, 0x90, 0xE7, 0x77, 0x72, 0x04, 0xFA, 0x07, 0x77,
  0x77, 0x20, 0x8F, 0x90, 0xE0, 0x17, 0x77, 0x72, 0x0B, 0xF9, 0x0A, 0x77, 0x77, 0x30, 0xCF, 0x90,
  0x47, 0x77, 0x72, 0x01, 0x0D, 0xF0, 0xD7, 0x77, 0x73, 0x02, 0x0E, 0xF0, 0x87, 0x77, 0x73, 0x03,
  0x0E, 0xF0, 0x37, 0x77, 0x73, 0x03, 0x0E, 0xE0, 0xC7, 0x77, 0x74, 0x03, 0x0E, 0xE0, 0x87, 0x77,
  0x74, 0x03, 0x0E, 0xE0, 0x47, 0x77, 0x74, 0x03, 0x0E, 0xD0, 0xE0, 0x17, 0x77, 0x74, 0x02, 0x0D,
  0xD0, 0xB7, 0x77, 0x75, 0x01, 0x0B, 0xD0, 0x18, 0x0B, 0xB5, 0x08, 0x54, 0x79, 0xBD, 0xEE, 0xA8,
  0x5E, 0xEC, 0xA8, 0x51, 0x77, 0x68, 0x11, 0x6B, 0xFF, 0xB8, 0x1C, 0x71, 0x77, 0x10, 0x60, 0xBF,
  0xFF, 0xA0, 0x80, 0x17, 0x38, 0x11, 0x8E, 0xFF, 0xFD, 0x0E, 0x04, 0x71, 0x01, 0xFF, 0xFF, 0xB0,
  0x67, 0x10, 0xBF, 0xFF, 0xFB, 0x06, 0x70, 0x4F, 0xC8, 0x7D, 0xB9, 0x98, 0x9A, 0xBE, 0xFD, 0x03,
  0x70, 0xCE, 0x81, 0xC7, 0x37, 0x38, 0x12, 0x8D, 0xFA, 0x0C, 0x70, 0x5B, 0x81, 0xE8, 0x27, 0x72,
  0x07, 0xFA, 0x04, 0x78, 0x1D, 0xE6, 0x77, 0x60, 0x30, 0xEF, 0x0B, 0x70, 0x37, 0x77, 0x20, 0x4F,
  0x90, 0x17, 0x77, 0x73, 0x0B, 0xF0, 0x57, 0x77, 0x73, 0x04, 0xF0, 0x87, 0x77, 0x74, 0x0E, 0xE0,
  0xA7, 0x77, 0x74, 0x0C, 0xE0, 0xC7, 0x77, 0x74, 0x09, 0xE0, 0xD7, 0x77, 0x74, 0x08, 0xE0, 0xD7,
  0x77, 0x74, 0x07, 0xE0, 0xE7, 0x77, 0x74, 0x07, 0xE0, 0xE7, 0x77, 0x74, 0x07, 0xE0, 0xE7, 0x68,
  0x62, 0x58, 0xAC, 0xDE, 0xEF, 0xFC, 0x0E, 0x73, 0x81, 0x5A, 0xEF, 0xFF, 0xD0, 0xE7, 0x81, 0x18,
  0xEF, 0xFF, 0xF9, 0x0E, 0x60, 0x60, 0xEF, 0xFF, 0xFB, 0x0E, 0x40, 0x10, 0xBF, 0xFF, 0xFD, 0x0E,
  0x30, 0x10, 0xDF, 0xFF, 0xFE, 0x0E, 0x30, 0xCF, 0xC8, 0x5D, 0x97, 0x43, 0x11, 0x73, 0x07, 0xE0,
  0xE2, 0x08, 0xFA, 0x81, 0xE8, 0x27, 0x73, 0x07, 0xE8, 0x1E, 0x02, 0xFA, 0x09, 0x01, 0x77, 0x50,
  0x7E, 0x81, 0xE0, 0x8F, 0x90, 0x77, 0x77, 0x07, 0xE8, 0x1E, 0x0E, 0xF0, 0x97, 0x77, 0x10, 0x7E,
  0x0E, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x8E, 0x0E, 0x06, 0xF0, 0x87, 0x77, 0x20, 0xAE, 0x0E, 0x08,
  0xF0, 0x37, 0x77, 0x20, 0xDE, 0x0E, 0x0A, 0xF0, 0x17, 0x77, 0x10, 0x1F, 0x0E, 0x0A, 0xF7, 0x77,
  0x20, 0x7F, 0x0E, 0x0A, 0xF7, 0x77, 0x20, 0xDF, 0x0E, 0x09, 0xF0, 0x27, 0x77, 0x07, 0xF9, 0x0E,
  0x07, 0xF0, 0x67, 0x76, 0x04, 0xFA, 0x0E, 0x05, 0xF0, 0xC7, 0x75, 0x04, 0x0E, 0xFA, 0x0E, 0x01,
  0xF9, 0x06, 0x77, 0x30, 0x6F, 0xC8, 0x1E, 0x0C, 0xF9, 0x07, 0x77, 0x04, 0x0B, 0xFD, 0x81, 0xE0,
  0x5F, 0xA8, 0x1C, 0x61, 0x71, 0x81, 0x27, 0xCE, 0x0E, 0x0B, 0xE0, 0xE2, 0x0D, 0xFC, 0x86, 0xDA,
  0x98, 0x9A, 0xCE, 0xFA, 0x04, 0x05, 0xE0, 0xE2, 0x03, 0xFF, 0xFE, 0x81, 0x50, 0x3E, 0x0E, 0x30,
  0x5F, 0xFF, 0xB0, 0xE0, 0x42, 0x01, 0xE0, 0xE4, 0x04, 0x0E, 0xFF, 0xF0, 0xC0, 0x24, 0x0E, 0xD0,
  0xE5, 0x01, 0x0A, 0xFF, 0xC0, 0xE0, 0x76, 0x0C, 0xD0, 0xE7, 0x81, 0x39, 0xEF, 0xE8, 0x1D, 0x71,
  0x70, 0xAD, 0x0E, 0x73, 0x89, 0x34, 0x7B, 0xCD, 0xEF, 0xED, 0xB9, 0x62, 0x77, 0x30,
  // "á" (U+00E1)
  0x77, 0x74, 0x03, 0x80, 0x57, 0x01, 0x77, 0x77, 0x10, 0xCF, 0xA0, 0x27, 0x77, 0x70, 0x5F, 0xA0,
  0x87, 0x77, 0x71, 0x0D, 0xF9, 0x0B, 0x77, 0x77, 0x10, 0x8F, 0x90, 0xD0, 0x17, 0x77, 0x70, 0x2F,
  0x90, 0xE0, 0x27, 0x77, 0x71, 0x0C, 0xF0, 0xE0, 0x37, 0x77, 0x71, 0x06, 0xF9, 0x04, 0x77, 0x77,
  0x10, 0x10, 0xEF, 0x05, 0x77, 0x77, 0x20, 0xBF, 0x05, 0x77, 0x77, 0x20, 0x5F, 0x06, 0x77, 0x77,
  0x20, 0x10, 0xEE, 0x05, 0x77, 0x77, 0x30, 0xBE, 0x05, 0x77, 0x77, 0x30, 0x8D, 0x0E, 0x04, 0x77,
  0x77, 0x40, 0xDC, 0x0C, 0x02, 0x80, 0xBC, 0x10, 0x85, 0x47, 0x9B, 0xDE, 0xEA, 0x85, 0xEE, 0xCA,
  0x85, 0x17, 0x76, 0x81, 0x16, 0xBF, 0xFB, 0x81, 0xC7, 0x17, 0x71, 0x06, 0x0B, 0xFF, 0xFA, 0x08,
  0x01, 0x73, 0x81, 0x18, 0xEF, 0xFF, 0xD0, 0xE0, 0x47, 0x10, 0x1F, 0xFF, 0xFB, 0x06, 0x71, 0x0B,
  0xFF, 0xFF, 0xB0, 0x67, 0x04, 0xFC, 0x87, 0xDB, 0x99, 0x89, 0xAB, 0xEF, 0xD0, 0x37, 0x0C, 0xE8,
  0x1C, 0x73, 0x73, 0x81, 0x28, 0xDF, 0xA0, 0xC7, 0x05, 0xB8, 0x1E, 0x82, 0x77, 0x20, 0x7F, 0xA0,
  0x47, 0x81, 0xDE, 0x67, 0x76, 0x03, 0x0E, 0xF0, 0xB7, 0x03, 0x77, 0x72, 0x04, 0xF9, 0x01, 0x77,
  0x77, 0x30, 0xBF, 0x05, 0x77, 0x77, 0x30, 0x4F, 0x08, 0x77, 0x77, 0x40, 0xEE, 0x0A, 0x77, 0x77,
  0x40, 0xCE, 0x0C, 0x77, 0x77, 0x40, 0x9E, 0x0D, 0x77, 0x77, 0x40, 0x8E, 0x0D, 0x77, 0x77, 0x40,
  0x7E, 0x0E, 0x77, 0x77, 0x40, 0x7E, 0x0E, 0x77, 0x77, 0x40, 0x7E, 0x0E, 0x76, 0x86, 0x25, 0x8A,
  0xCD, 0xEE, 0xFF, 0xC0, 0xE7, 0x38, 0x15, 0xAE, 0xFF, 0xFD, 0x0E, 0x78, 0x11, 0x8E, 0xFF, 0xFF,
  0x90, 0xE6, 0x06, 0x0E, 0xFF, 0xFF, 0xB0, 0xE4, 0x01, 0x0B, 0xFF, 0xFF, 0xD0, 0xE3, 0x01, 0x0D,
  0xFF, 0xFF, 0xE0, 0xE3, 0x0C, 0xFC, 0x85, 0xD9, 0x74, 0x31, 0x17, 0x30, 0x7E, 0x0E, 0x20, 0x8F,
  0xA8, 0x1E, 0x82, 0x77, 0x30, 0x7E, 0x81, 0xE0, 0x2F, 0xA0, 0x90, 0x17, 0x75, 0x07, 0xE8, 0x1E,
  0x08, 0xF9, 0x07, 0x77, 0x70, 0x7E, 0x81, 0xE0, 0xEF, 0x09, 0x77, 0x71, 0x07, 0xE0, 0xE0, 0x3F,
  0x0D, 0x77, 0x72, 0x08, 0xE0, 0xE0, 0x6F, 0x08, 0x77, 0x72, 0x0A, 0xE0, 0xE0, 0x8F, 0x03, 0x77,
  0x72, 0x0D, 0xE0, 0xE0, 0xAF, 0x01, 0x77, 0x71, 0x01, 0xF0, 0xE0, 0xAF, 0x77, 0x72, 0x07, 0xF0,
  0xE0, 0xAF, 0x77, 0x72, 0x0D, 0xF0, 0xE0, 0x9F, 0x02, 0x77, 0x70, 0x7F, 0x90, 0xE0, 0x7F, 0x06,
  0x77, 0x60, 0x4F, 0xA0, 0xE0, 0x5F, 0x0C, 0x77, 0x50, 0x40, 0xEF, 0xA0, 0xE0, 0x1F, 0x90, 0x67,
  0x73, 0x06, 0xFC, 0x81, 0xE0, 0xCF, 0x90, 0x77, 0x70, 0x40, 0xBF, 0xD8, 0x1E, 0x05, 0xFA, 0x81,
  0xC6, 0x17, 0x18, 0x12, 0x7C, 0xE0, 0xE0, 0xBE, 0x0E, 0x20, 0xDF, 0xC8, 0x6D, 0xA9, 0x89, 0xAC,
  0xEF, 0xA0, 0x40, 0x5E, 0x0E, 0x20, 0x3F, 0xFF, 0xE8, 0x15, 0x03, 0xE0, 0xE3, 0x05, 0xFF, 0xFB,
  0x0E, 0x04, 0x20, 0x1E, 0x0E, 0x40, 0x40, 0xEF, 0xFF, 0x0C, 0x02, 0x40, 0xED, 0x0E, 0x50, 0x10,
  0xAF, 0xFC, 0x0E, 0x07, 0x60, 0xCD, 0x0E, 0x78, 0x13, 0x9E, 0xFE, 0x81, 0xD7, 0x17, 0x0A, 0xD0,
  0xE7, 0x38, 0x93, 0x47, 0xBC, 0xDE, 0xFE, 0xDB, 0x96, 0x27, 0x73,
  // "â" (U+00E2)
  0x77, 0x20, 0x28, 0x04, 0x77, 0x77, 0x73, 0x0C, 0xF9, 0x08, 0x77, 0x77, 0x10, 0x6F, 0xB0, 0x37,
  0x77, 0x60, 0x3F, 0xC0, 0xD0, 0x17, 0x77, 0x50, 0xDF, 0xD0, 0xA7, 0x77, 0x40, 0xBF, 0xF0, 0x77,
  0x77, 0x20, 0x8F, 0x0A, 0x0D, 0xF0, 0x57, 0x77, 0x06, 0xF8, 0x29, 0x01, 0xDF, 0x03, 0x77, 0x50,
  0x4F, 0x09, 0x30, 0x10, 0xDE, 0x0E, 0x02, 0x77, 0x30, 0x20, 0xEE, 0x09, 0x50, 0x10, 0xCE, 0x0D,
  0x01, 0x77, 0x10, 0x10, 0xDE, 0x08, 0x70, 0x10, 0xCE, 0x0C, 0x77, 0x10, 0xCE, 0x08, 0x72, 0x01,
  0x0B, 0xE0, 0xB7, 0x60, 0xBE, 0x06, 0x75, 0x0A, 0xE0, 0xA7, 0x40, 0xAD, 0x0E, 0x04, 0x77, 0x07,
  0xE0, 0xA7, 0x20, 0x3D, 0x0B, 0x01, 0x77, 0x20, 0x30, 0xDD, 0x03, 0x80, 0xBA, 0x40, 0x85, 0x47,
  0x9B, 0xDE, 0xEA, 0x85, 0xEE, 0xCA, 0x85, 0x17, 0x76, 0x81, 0x16, 0xBF, 0xFB, 0x81, 0xC7, 0x17,
  0x71, 0x06, 0x0B, 0xFF, 0xFA, 0x08, 0x01, 0x73, 0x81, 0x18, 0xEF, 0xFF, 0xD0, 0xE0, 0x47, 0x10,
  0x1F, 0xFF, 0xFB, 0x06, 0x71, 0x0B, 0xFF, 0xFF, 0xB0, 0x67, 0x04, 0xFC, 0x87, 0xDB, 0x99, 0x89,
  0xAB, 0xEF, 0xD0, 0x37, 0x0C, 0xE8, 0x1C, 0x73, 0x73, 0x81, 0x28, 0xDF, 0xA0, 0xC7, 0x05, 0xB8,
  0x1E, 0x82, 0x77, 0x20, 0x7F, 0xA0, 0x47, 0x81, 0xDE, 0x67, 0x76, 0x03, 0x0E, 0xF0, 0xB7, 0x03,
  0x77, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x77, 0x30, 0xBF, 0x05, 0x77, 0x77, 0x30, 0x4F, 0x08, 0x77,
  0x77, 0x40, 0xEE, 0x0A, 0x77, 0x77, 0x40, 0xCE, 0x0C, 0x77, 0x77, 0x40, 0x9E, 0x0D, 0x77, 0x77,
  0x40, 0x8E, 0x0D, 0x77, 0x77, 0x40, 0x7E, 0x0E, 0x77, 0x77, 0x40, 0x7E, 0x0E, 0x77, 0x77, 0x40,
  0x7E, 0x0E, 0x76, 0x86, 0x25, 0x8A, 0xCD, 0xEE, 0xFF, 0xC0, 0xE7, 0x38, 0x15, 0xAE, 0xFF, 0xFD,
  0x0E, 0x78, 0x11, 0x8E, 0xFF, 0xFF, 0x90, 0xE6, 0x06, 0x0E, 0xFF, 0xFF, 0xB0, 0xE4, 0x01, 0x0B,
  0xFF, 0xFF, 0xD0, 0xE3, 0x01, 0x0D, 0xFF, 0xFF, 0xE0, 0xE3, 0x0C, 0xFC, 0x85, 0xD9, 0x74, 0x31,
  0x17, 0x30, 0x7E, 0x0E, 0x20, 0x8F, 0xA8, 0x1E, 0x82, 0x77, 0x30, 0x7E, 0x81, 0xE0, 0x2F, 0xA0,
  0x90, 0x17, 0x75, 0x07, 0xE8, 0x1E, 0x08, 0xF9, 0x07, 0x77, 0x70, 0x7E, 0x81, 0xE0, 0xEF, 0x09,
  0x77, 0x71, 0x07, 0xE0, 0xE0, 0x3F, 0x0D, 0x77, 0x72, 0x08, 0xE0, 0xE0, 0x6F, 0x08, 0x77, 0x72,
  0x0A, 0xE0, 0xE0, 0x8F, 0x03, 0x77, 0x72, 0x0D, 0xE0, 0xE0, 0xAF, 0x01, 0x77, 0x71, 0x01, 0xF0,
  0xE0, 0xAF, 0x77, 0x72, 0x07, 0xF0, 0xE0, 0xAF, 0x77, 0x72, 0x0D, 0xF0, 0xE0, 0x9F, 0x02, 0x77,
  0x70, 0x7F, 0x90, 0xE0, 0x7F, 0x06, 0x77, 0x60, 0x4F, 0xA0, 0xE0, 0x5F, 0x0C, 0x77, 0x50, 0x40,
  0xEF, 0xA0, 0xE0, 0x1F, 0x90, 0x67, 0x73, 0x06, 0xFC, 0x81, 0xE0, 0xCF, 0x90, 0x77, 0x70, 0x40,
  0xBF, 0xD8, 0x1E, 0x05, 0xFA, 0x81, 0xC6, 0x17, 0x18, 0x12, 0x7C, 0xE0, 0xE0, 0xBE, 0x0E, 0x20,
  0xDF, 0xC8, 0x6D, 0xA9, 0x89, 0xAC, 0xEF, 0xA0, 0x40, 0x5E, 0x0E, 0x20, 0x3F, 0xFF, 0xE8, 0x15,
  0x03, 0xE0, 0xE3, 0x05, 0xFF, 0xFB, 0x0E, 0x04, 0x20, 0x1E, 0x0E, 0x40, 0x40, 0xEF, 0xFF, 0x0C,
  0x02, 0x40, 0xED, 0x0E, 0x50, 0x10, 0xAF, 0xFC, 0x0E, 0x07, 0x60, 0xCD, 0x0E, 0x78, 0x13, 0x9E,
  0xFE, 0x81, 0xD7, 0x17, 0x0A, 0xD0, 0xE7, 0x38, 0x93, 0x47, 0xBC, 0xDE, 0xFE, 0xDB, 0x96, 0x27,
  0x73,
  // "ã" (U+00E3)
  0x75, 0x84, 0x46, 0x87, 0x51, 0x77, 0x84, 0x38, 0x88, 0x81, 0x75, 0x08, 0x0E, 0xE0, 0xB0, 0x37,
  0x50, 0x9C, 0x74, 0x02, 0x0D, 0xFB, 0x0A, 0x01, 0x73, 0x0E, 0xB0, 0xD7, 0x30, 0x10, 0xDF, 0xD0,
  0xE0, 0x77, 0x10, 0x8C, 0x09, 0x73, 0x0B, 0xFF, 0x90, 0xD0, 0x65, 0x06, 0xD0, 0x57, 0x20, 0x5F,
  0xFC, 0x83, 0xEA, 0x89, 0xDD, 0x0E, 0x73, 0x0C, 0xFF, 0xFF, 0x08, 0x72, 0x03, 0xD8, 0x5D, 0x51,
  0x01, 0x5C, 0xFF, 0xA0, 0xE0, 0x17, 0x20, 0x8C, 0x0D, 0x01, 0x60, 0x50, 0xDF, 0xF0, 0x57, 0x30,
  0xCC, 0x04, 0x72, 0x07, 0xFD, 0x07, 0x74, 0x0E, 0xB0, 0xD7, 0x40, 0x20, 0xAF, 0x90, 0xE0, 0x67,
  0x40, 0x1C, 0x08, 0x76, 0x87, 0x28, 0xCE, 0xFD, 0xB6, 0x18, 0x0B, 0xB1, 0x08, 0x54, 0x79, 0xBD,
  0xEE, 0xA8, 0x5E, 0xEC, 0xA8, 0x51, 0x77, 0x68, 0x11, 0x6B, 0xFF, 0xB8, 0x1C, 0x71, 0x77, 0x10,
  0x60, 0xBF, 0xFF, 0xA0, 0x80, 0x17, 0x38, 0x11, 0x8E, 0xFF, 0xFD, 0x0E, 0x04, 0x71, 0x01, 0xFF,
  0xFF, 0xB0, 0x67, 0x10, 0xBF, 0xFF, 0xFB, 0x06, 0x70, 0x4F, 0xC8, 0x7D, 0xB9, 0x98, 0x9A, 0xBE,
  0xFD, 0x03, 0x70, 0xCE, 0x81, 0xC7, 0x37, 0x38, 0x12, 0x8D, 0xFA, 0x0C, 0x70, 0x5B, 0x81, 0xE8,
  0x27, 0x72, 0x07, 0xFA, 0x04, 0x78, 0x1D, 0xE6, 0x77, 0x60, 0x30, 0xEF, 0x0B, 0x70, 0x37, 0x77,
  0x20, 0x4F, 0x90, 0x17, 0x77, 0x73, 0x0B, 0xF0, 0x57, 0x77, 0x73, 0x04, 0xF0, 0x87, 0x77, 0x74,
  0x0E, 0xE0, 0xA7, 0x77, 0x74, 0x0C, 0xE0, 0xC7, 0x77, 0x74, 0x09, 0xE0, 0xD7, 0x77, 0x74, 0x08,
  0xE0, 0xD7, 0x77, 0x74, 0x07, 0xE0, 0xE7, 0x77, 0x74, 0x07, 0xE0, 0xE7, 0x77, 0x74, 0x07, 0xE0,
  0xE7, 0x68, 0x62, 0x58, 0xAC, 0xDE, 0xEF, 0xFC, 0x0E, 0x73, 0x81, 0x5A, 0xEF, 0xFF, 0xD0, 0xE7,
  0x81, 0x18, 0xEF, 0xFF, 0xF9, 0x0E, 0x60, 0x60, 0xEF, 0xFF, 0xFB, 0x0E, 0x40, 0x10, 0xBF, 0xFF,
  0xFD, 0x0E, 0x30, 0x10, 0xDF, 0xFF, 0xFE, 0x0E, 0x30, 0xCF, 0xC8, 0x5D, 0x97, 0x43, 0x11, 0x73,
  0x07, 0xE0, 0xE2, 0x08, 0xFA, 0x81, 0xE8, 0x27, 0x73, 0x07, 0xE8, 0x1E, 0x02, 0xFA, 0x09, 0x01,
  0x77, 0x50, 0x7E, 0x81, 0xE0, 0x8F, 0x90, 0x77, 0x77, 0x07, 0xE8, 0x1E, 0x0E, 0xF0, 0x97, 0x77,
  0x10, 0x7E, 0x0E, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x8E, 0x0E, 0x06, 0xF0, 0x87, 0x77, 0x20, 0xAE,
  0x0E, 0x08, 0xF0, 0x37, 0x77, 0x20, 0xDE, 0x0E, 0x0A, 0xF0, 0x17, 0x77, 0x10, 0x1F, 0x0E, 0x0A,
  0xF7, 0x77, 0x20, 0x7F, 0x0E, 0x0A, 0xF7, 0x77, 0x20, 0xDF, 0x0E, 0x09, 0xF0, 0x27, 0x77, 0x07,
  0xF9, 0x0E, 0x07, 0xF0, 0x67, 0x76, 0x04, 0xFA, 0x0E, 0x05, 0xF0, 0xC7, 0x75, 0x04, 0x0E, 0xFA,
  0x0E, 0x01, 0xF9, 0x06, 0x77, 0x30, 0x6F, 0xC8, 0x1E, 0x0C, 0xF9, 0x07, 0x77, 0x04, 0x0B, 0xFD,
  0x81, 0xE0, 0x5F, 0xA8, 0x1C, 0x61, 0x71, 0x81, 0x27, 0xCE, 0x0E, 0x0B, 0xE0, 0xE2, 0x0D, 0xFC,
  0x86, 0xDA, 0x98, 0x9A, 0xCE, 0xFA, 0x04, 0x05, 0xE0, 0xE2, 0x03, 0xFF, 0xFE, 0x81, 0x50, 0x3E,
  0x0E, 0x30, 0x5F, 0xFF, 0xB0, 0xE0, 0x42, 0x01, 0xE0, 0xE4, 0x04, 0x0E, 0xFF, 0xF0, 0xC0, 0x24,
  0x0E, 0xD0, 0xE5, 0x01, 0x0A, 0xFF, 0xC0, 0xE0, 0x76, 0x0C, 0xD0, 0xE7, 0x81, 0x39, 0xEF, 0xE8,
  0x1D, 0x71, 0x70, 0xAD, 0x0E, 0x73, 0x89, 0x34, 0x7B, 0xCD, 0xEF, 0xED, 0xB9, 0x62, 0x77, 0x30,
  // "ä" (U+00E4)
  0x78, 0x51, 0x8D, 0xFE, 0xB4, 0x77, 0x85, 0x3A, 0xEF, 0xD9, 0x17, 0x40, 0x20, 0xDE, 0x08, 0x75,
  0x06, 0xE0, 0xE0, 0x37, 0x30, 0xAF, 0x90, 0x37, 0x30, 0x1F, 0x90, 0xC7, 0x30, 0xEF, 0x90, 0x87,
  0x30, 0x5F, 0xA0, 0x27, 0x10, 0x1F, 0xA0, 0xA7, 0x30, 0x7F, 0xA0, 0x47, 0x10, 0x1F, 0xA0, 0x97,
  0x30, 0x7F, 0xA0, 0x37, 0x20, 0xEF, 0x90, 0x77, 0x30, 0x5F, 0xA0, 0x17, 0x20, 0x9F, 0x90, 0x27,
  0x40, 0xEF, 0x0B, 0x73, 0x01, 0x0C, 0xE0, 0x67, 0x50, 0x4E, 0x0D, 0x02, 0x75, 0x84, 0x7D, 0xFE,
  0xA3, 0x77, 0x85, 0x2A, 0xEF, 0xD8, 0x18, 0x0C, 0xC6, 0x08, 0x54, 0x79, 0xBD, 0xEE, 0xA8, 0x5E,
  0xEC, 0xA8, 0x51, 0x77, 0x68, 0x11, 0x6B, 0xFF, 0xB8, 0x1C, 0x71, 0x77, 0x10, 0x60, 0xBF, 0xFF,
  0xA0, 0x80, 0x17, 0x38, 0x11, 0x8E, 0xFF, 0xFD, 0x0E, 0x04, 0x71, 0x01, 0xFF, 0xFF, 0xB0, 0x67,
  0x10, 0xBF, 0xFF, 0xFB, 0x06, 0x70, 0x4F, 0xC8, 0x7D, 0xB9, 0x98, 0x9A, 0xBE, 0xFD, 0x03, 0x70,
  0xCE, 0x81, 0xC7, 0x37, 0x38, 0x12, 0x8D, 0xFA, 0x0C, 0x70, 0x5B, 0x81, 0xE8, 0x27, 0x72, 0x07,
  0xFA, 0x04, 0x78, 0x1D, 0xE6, 0x77, 0x60, 0x30, 0xEF, 0x0B, 0x70, 0x37, 0x77, 0x20, 0x4F, 0x90,
  0x17, 0x77, 0x73, 0x0B, 0xF0, 0x57, 0x77, 0x73, 0x04, 0xF0, 0x87, 0x77, 0x74, 0x0E, 0xE0, 0xA7,
  0x77, 0x74, 0x0C, 0xE0, 0xC7, 0x77, 0x74, 0x09, 0xE0, 0xD7, 0x77, 0x74, 0x08, 0xE0, 0xD7, 0x77,
  0x74, 0x07, 0xE0, 0xE7, 0x77, 0x74, 0x07, 0xE0, 0xE7, 0x77, 0x74, 0x07, 0xE0, 0xE7, 0x68, 0x62,
  0x58, 0xAC, 0xDE, 0xEF, 0xFC, 0x0E, 0x73, 0x81, 0x5A, 0xEF, 0xFF, 0xD0, 0xE7, 0x81, 0x18, 0xEF,
  0xFF, 0xF9, 0x0E, 0x60, 0x60, 0xEF, 0xFF, 0xFB, 0x0E, 0x40, 0x10, 0xBF, 0xFF, 0xFD, 0x0E, 0x30,
  0x10, 0xDF, 0xFF, 0xFE, 0x0E, 0x30, 0xCF, 0xC8, 0x5D, 0x97, 0x43, 0x11, 0x73, 0x07, 0xE0, 0xE2,
  0x08, 0xFA, 0x81, 0xE8, 0x27, 0x73, 0x07, 0xE8, 0x1E, 0x02, 0xFA, 0x09, 0x01, 0x77, 0x50, 0x7E,
  0x81, 0xE0, 0x8F, 0x90, 0x77, 0x77, 0x07, 0xE8, 0x1E, 0x0E, 0xF0, 0x97, 0x77, 0x10, 0x7E, 0x0E,
  0x03, 0xF0, 0xD7, 0x77, 0x20, 0x8E, 0x0E, 0x06, 0xF0, 0x87, 0x77, 0x20, 0xAE, 0x0E, 0x08, 0xF0,
  0x37, 0x77, 0x20, 0xDE, 0x0E, 0x0A, 0xF0, 0x17, 0x77, 0x10, 0x1F, 0x0E, 0x0A, 0xF7, 0x77, 0x20,
  0x7F, 0x0E, 0x0A, 0xF7, 0x77, 0x20, 0xDF, 0x0E, 0x09, 0xF0, 0x27, 0x77, 0x07, 0xF9, 0x0E, 0x07,
  0xF0, 0x67, 0x76, 0x04, 0xFA, 0x0E, 0x05, 0xF0, 0xC7, 0x75, 0x04, 0x0E, 0xFA, 0x0E, 0x01, 0xF9,
  0x06, 0x77, 0x30, 0x6F, 0xC8, 0x1E, 0x0C, 0xF9, 0x07, 0x77, 0x04, 0x0B, 0xFD, 0x81, 0xE0, 0x5F,
  0xA8, 0x1C, 0x61, 0x71, 0x81, 0x27, 0xCE, 0x0E, 0x0B, 0xE0, 0xE2, 0x0D, 0xFC, 0x86, 0xDA, 0x98,
  0x9A, 0xCE, 0xFA, 0x04, 0x05, 0xE0, 0xE2, 0x03, 0xFF, 0xFE, 0x81, 0x50, 0x3E, 0x0E, 0x30, 0x5F,
  0xFF, 0xB0, 0xE0, 0x42, 0x01, 0xE0, 0xE4, 0x04, 0x0E, 0xFF, 0xF0, 0xC0, 0x24, 0x0E, 0xD0, 0xE5,
  0x01, 0x0A, 0xFF, 0xC0, 0xE0, 0x76, 0x0C, 0xD0, 0xE7, 0x81, 0x39, 0xEF, 0xE8, 0x1D, 0x71, 0x70,
  0xAD, 0x0E, 0x73, 0x89, 0x34, 0x7B, 0xCD, 0xEF, 0xED, 0xB9, 0x62, 0x77, 0x30,
  // "å" (U+00E5)
  0x77, 0x28, 0x90, 0x28, 0xBD, 0xFE, 0xDA, 0x71, 0x77, 0x77, 0x01, 0x0A, 0xFB, 0x08, 0x77, 0x75,
  0x03, 0x0E, 0xFD, 0x0D, 0x02, 0x77, 0x72, 0x02, 0x0E, 0xFF, 0x0D, 0x01, 0x77, 0x71, 0x0B, 0xFF,
  0xA0, 0xA7, 0x77, 0x03, 0xE0, 0x80, 0x22, 0x03, 0x09, 0xE0, 0x27, 0x76, 0x07, 0xD0, 0x46, 0x05,
  0xD0, 0x77, 0x76, 0x0B, 0xC0, 0x87, 0x10, 0xAC, 0x0B, 0x77, 0x60, 0xCC, 0x03, 0x71, 0x05, 0xC0,
  0xC7, 0x76, 0x0D, 0xC0, 0x27, 0x10, 0x4C, 0x0D, 0x77, 0x60, 0xCC, 0x03, 0x71, 0x05, 0xC0, 0xC7,
  0x76, 0x0B, 0xC0, 0x87, 0x10, 0xAC, 0x0A, 0x77, 0x60, 0x7D, 0x03, 0x60, 0x5D, 0x07, 0x77, 0x60,
  0x2E, 0x08, 0x02, 0x20, 0x30, 0x9E, 0x02, 0x77, 0x70, 0xAF, 0xFA, 0x09, 0x77, 0x71, 0x01, 0x0E,
  0xFF, 0x0D, 0x01, 0x77, 0x72, 0x03, 0x0E, 0xFD, 0x0D, 0x02, 0x77, 0x74, 0x01, 0x0A, 0xFB, 0x09,
  0x77, 0x77, 0x18, 0x90, 0x28, 0xBD, 0xFE, 0xDB, 0x71, 0x80, 0xBB, 0x70, 0x85, 0x47, 0x9B, 0xDE,
  0xEA, 0x85, 0xEE, 0xCA, 0x85, 0x17, 0x76, 0x81, 0x16, 0xBF, 0xFB, 0x81, 0xC7, 0x17, 0x71, 0x06,
  0x0B, 0xFF, 0xFA, 0x08, 0x01, 0x73, 0x81, 0x18, 0xEF, 0xFF, 0xD0, 0xE0, 0x47, 0x10, 0x1F, 0xFF,
  0xFB, 0x06, 0x71, 0x0B, 0xFF, 0xFF, 0xB0, 0x67, 0x04, 0xFC, 0x87, 0xDB, 0x99, 0x89, 0xAB, 0xEF,
  0xD0, 0x37, 0x0C, 0xE8, 0x1C, 0x73, 0x73, 0x81, 0x28, 0xDF, 0xA0, 0xC7, 0x05, 0xB8, 0x1E, 0x82,
  0x77, 0x20, 0x7F, 0xA0, 0x47, 0x81, 0xDE, 0x67, 0x76, 0x03, 0x0E, 0xF0, 0xB7, 0x03, 0x77, 0x72,
  0x04, 0xF9, 0x01, 0x77, 0x77, 0x30, 0xBF, 0x05, 0x77, 0x77, 0x30, 0x4F, 0x08, 0x77, 0x77, 0x40,
  0xEE, 0x0A, 0x77, 0x77, 0x40, 0xCE, 0x0C, 0x77, 0x77, 0x40, 0x9E, 0x0D, 0x77, 0x77, 0x40, 0x8E,
  0x0D, 0x77, 0x77, 0x40, 0x7E, 0x0E, 0x77, 0x77, 0x40, 0x7E, 0x0E, 0x77, 0x77, 0x40, 0x7E, 0x0E,
  0x76, 0x86, 0x25, 0x8A, 0xCD, 0xEE, 0xFF, 0xC0, 0xE7, 0x38, 0x15, 0xAE, 0xFF, 0xFD, 0x0E, 0x78,
  0x11, 0x8E, 0xFF, 0xFF, 0x90, 0xE6, 0x06, 0x0E, 0xFF, 0xFF, 0xB0, 0xE4, 0x01, 0x0B, 0xFF, 0xFF,
  0xD0, 0xE3, 0x01, 0x0D, 0xFF, 0xFF, 0xE0, 0xE3, 0x0C, 0xFC, 0x85, 0xD9, 0x74, 0x31, 0x17, 0x30,
  0x7E, 0x0E, 0x20, 0x8F, 0xA8, 0x1E, 0x82, 0x77, 0x30, 0x7E, 0x81, 0xE0, 0x2F, 0xA0, 0x90, 0x17,
  0x75, 0x07, 0xE8, 0x1E, 0x08, 0xF9, 0x07, 0x77, 0x70, 0x7E, 0x81, 0xE0, 0xEF, 0x09, 0x77, 0x71,
  0x07, 0xE0, 0xE0, 0x3F, 0x0D, 0x77, 0x72, 0x08, 0xE0, 0xE0, 0x6F, 0x08, 0x77, 0x72, 0x0A, 0xE0,
  0xE0, 0x8F, 0x03, 0x77, 0x72, 0x0D, 0xE0, 0xE0, 0xAF, 0x01, 0x77, 0x71, 0x01, 0xF0, 0xE0, 0xAF,
  0x77, 0x72, 0x07, 0xF0, 0xE0, 0xAF, 0x77, 0x72, 0x0D, 0xF0, 0xE0, 0x9F, 0x02, 0x77, 0x70, 0x7F,
  0x90, 0xE0, 0x7F, 0x06, 0x77, 0x60, 0x4F, 0xA0, 0xE0, 0x5F, 0x0C, 0x77, 0x50, 0x40, 0xEF, 0xA0,
  0xE0, 0x1F, 0x90, 0x67, 0x73, 0x06, 0xFC, 0x81, 0xE0, 0xCF, 0x90, 0x77, 0x70, 0x40, 0xBF, 0xD8,
  0x1E, 0x05, 0xFA, 0x81, 0xC6, 0x17, 0x18, 0x12, 0x7C, 0xE0, 0xE0, 0xBE, 0x0E, 0x20, 0xDF, 0xC8,
  0x6D, 0xA9, 0x89, 0xAC, 0xEF, 0xA0, 0x40, 0x5E, 0x0E, 0x20, 0x3F, 0xFF, 0xE8, 0x15, 0x03, 0xE0,
  0xE3, 0x05, 0xFF, 0xFB, 0x0E, 0x04, 0x20, 0x1E, 0x0E, 0x40, 0x40, 0xEF, 0xFF, 0x0C, 0x02, 0x40,
  0xED, 0x0E, 0x50, 0x10, 0xAF, 0xFC, 0x0E, 0x07, 0x60, 0xCD, 0x0E, 0x78, 0x13, 0x9E, 0xFE, 0x81,
  0xD7, 0x17, 0x0A, 0xD0, 0xE7, 0x38, 0x93, 0x47, 0xBC, 0xDE, 0xFE, 0xDB, 0x96, 0x27, 0x73,
  // "æ" (U+00E6)
  0x73, 0x89, 0x11, 0x6A, 0xCE, 0xFE, 0xDB, 0x83, 0x75, 0x82, 0x38, 0xBE, 0xA8, 0x2D, 0xB7, 0x17,
  0x73, 0x05, 0x0C, 0xFC, 0x0D, 0x05, 0x71, 0x03, 0x0C, 0xFB, 0x08, 0x77, 0x06, 0x0D, 0xFF, 0x90,
  0xA6, 0x07, 0xFE, 0x0D, 0x02, 0x73, 0x02, 0x0C, 0xFF, 0xC0, 0xB4, 0x08, 0xFF, 0x90, 0xE0, 0x27,
  0x20, 0xDF, 0xFE, 0x08, 0x20, 0x6F, 0xFB, 0x0D, 0x72, 0x06, 0xFF, 0xF8, 0x12, 0x2E, 0xFF, 0xC0,
  0x97, 0x20, 0xEE, 0x84, 0xEB, 0x99, 0xAD, 0xF9, 0x00, 0xAF, 0x82, 0xD9, 0x9B, 0xFA, 0x02, 0x71,
  0x07, 0xC0, 0xA0, 0x46, 0x04, 0x0D, 0xFE, 0x0E, 0x04, 0x40, 0x10, 0xAF, 0x0A, 0x72, 0x82, 0xEF,
  0xB2, 0x72, 0x01, 0x0D, 0xFC, 0x0D, 0x01, 0x70, 0x9F, 0x01, 0x71, 0x07, 0x06, 0x75, 0x03, 0xFC,
  0x03, 0x71, 0x01, 0x0E, 0xE0, 0x77, 0x77, 0x20, 0xBF, 0xA0, 0x87, 0x30, 0x8E, 0x0C, 0x77, 0x72,
  0x06, 0xF9, 0x0E, 0x01, 0x73, 0x02, 0xF0, 0x17, 0x77, 0x10, 0x2F, 0x90, 0x97, 0x50, 0xEE, 0x05,
  0x77, 0x72, 0xF9, 0x04, 0x75, 0x0B, 0xE0, 0x87, 0x77, 0x20, 0xDF, 0x76, 0x08, 0xE0, 0xA7, 0x77,
  0x20, 0xDE, 0x0D, 0x76, 0x06, 0xE0, 0xC7, 0x77, 0x20, 0xCE, 0x0A, 0x76, 0x05, 0xE0, 0xE7, 0x77,
  0x20, 0xCE, 0x08, 0x76, 0x04, 0xF7, 0x77, 0x20, 0xCE, 0x07, 0x76, 0x03, 0xF0, 0x17, 0x77, 0x10,
  0xCE, 0x05, 0x76, 0x03, 0xF0, 0x27, 0x28, 0x41, 0x59, 0xCD, 0xE8, 0x0C, 0x0F, 0x02, 0x70, 0x20,
  0x98, 0x0C, 0x6F, 0x03, 0x60, 0x88, 0x0D, 0x0F, 0x03, 0x50, 0xA8, 0x0D, 0x1F, 0x03, 0x40, 0xB8,
  0x0D, 0x2F, 0x03, 0x30, 0x78, 0x0D, 0x3F, 0x03, 0x20, 0x2F, 0xC8, 0x1E, 0xB9, 0x80, 0x18, 0xF0,
  0x98, 0x0A, 0x18, 0x01, 0x20, 0x9F, 0x98, 0x1E, 0x82, 0x71, 0x0E, 0xE0, 0x27, 0x77, 0x20, 0x1F,
  0x90, 0xC0, 0x27, 0x30, 0xEE, 0x03, 0x77, 0x72, 0x06, 0xF0, 0xD7, 0x50, 0xEE, 0x04, 0x77, 0x72,
  0x09, 0xF0, 0x37, 0x50, 0xEE, 0x05, 0x77, 0x72, 0x0D, 0xE0, 0xB7, 0x6F, 0x07, 0x77, 0x72, 0xF0,
  0x67, 0x6F, 0x09, 0x77, 0x71, 0x01, 0xF0, 0x37, 0x50, 0x1F, 0x0C, 0x77, 0x71, 0x02, 0xF0, 0x17,
  0x50, 0x3F, 0x97, 0x77, 0x10, 0x2F, 0x76, 0x06, 0xF9, 0x04, 0x77, 0x70, 0x2F, 0x76, 0x09, 0xF9,
  0x09, 0x77, 0x70, 0x1F, 0x01, 0x75, 0x0E, 0xF9, 0x0E, 0x77, 0x71, 0xF0, 0x47, 0x40, 0x5F, 0xB0,
  0x77, 0x77, 0x0D, 0xE0, 0x77, 0x40, 0xCF, 0xB0, 0xE0, 0x27, 0x72, 0x01, 0x30, 0xAE, 0x0D, 0x73,
  0x07, 0xD0, 0xCE, 0x0D, 0x01, 0x77, 0x04, 0x0D, 0x30, 0x6F, 0x08, 0x71, 0x06, 0xE0, 0x20, 0xBE,
  0x0D, 0x03, 0x74, 0x01, 0x09, 0xA3, 0x01, 0xF9, 0x09, 0x50, 0x20, 0xAE, 0x81, 0xA0, 0x5F, 0x90,
  0x80, 0x27, 0x04, 0x09, 0xC4, 0x0B, 0xF9, 0x83, 0xEA, 0x89, 0xCF, 0x0E, 0x01, 0x20, 0xBF, 0xA8,
  0x4C, 0xA9, 0x9A, 0xCF, 0x40, 0x3F, 0xFE, 0x06, 0x30, 0x2F, 0xFF, 0x95, 0x08, 0xFF, 0xC0, 0x95,
  0x05, 0xFF, 0xF6, 0x0B, 0xFF, 0xA0, 0xA7, 0x06, 0xFF, 0xD0, 0xE7, 0x0A, 0xFF, 0x07, 0x72, 0x03,
  0x0D, 0xFF, 0xA0, 0xA0, 0x17, 0x10, 0x50, 0xDF, 0xB0, 0xA0, 0x27, 0x50, 0x60, 0xDF, 0xD0, 0xA0,
  0x37, 0x58, 0x90, 0x5A, 0xDE, 0xFE, 0xC9, 0x61, 0x77, 0x28, 0x92, 0x38, 0xBD, 0xEF, 0xED, 0xC9,
  0x51, 0x60,
  // "ç" (U+00E7)
  0x77, 0x38, 0x44, 0x79, 0xCD, 0xEA, 0x85, 0xED, 0xCB, 0x96, 0x37, 0x76, 0x81, 0x17, 0xCF, 0xFB,
  0x81, 0xB6, 0x17, 0x70, 0x30, 0xAF, 0xFF, 0xA0, 0xA0, 0x37, 0x30, 0x10, 0xAF, 0xFF, 0xE0, 0x47,
  0x10, 0x40, 0xEF, 0xFF, 0xE0, 0xE7, 0x10, 0x6F, 0xFF, 0xF9, 0x09, 0x70, 0x6F, 0xE8, 0x7D, 0xB9,
  0x98, 0x9A, 0xBE, 0xF9, 0x03, 0x60, 0x4F, 0xC8, 0x1B, 0x51, 0x72, 0x81, 0x15, 0xBC, 0x0D, 0x60,
  0x10, 0xEF, 0xA0, 0xA0, 0x27, 0x71, 0x83, 0x17, 0xEF, 0x76, 0x0A, 0xFA, 0x05, 0x77, 0x58, 0x11,
  0x82, 0x50, 0x4F, 0xA0, 0x47, 0x77, 0x70, 0xBF, 0x90, 0x67, 0x77, 0x70, 0x3F, 0x90, 0xB7, 0x77,
  0x71, 0x09, 0xF9, 0x02, 0x77, 0x77, 0x10, 0xEF, 0x0B, 0x77, 0x77, 0x10, 0x2F, 0x90, 0x57, 0x77,
  0x71, 0x07, 0xF9, 0x77, 0x77, 0x20, 0xAF, 0x0B, 0x77, 0x77, 0x20, 0xCF, 0x08, 0x77, 0x77, 0x20,
  0xEF, 0x05, 0x77, 0x77, 0x10, 0x1F, 0x90, 0x37, 0x77, 0x71, 0x02, 0xF9, 0x01, 0x77, 0x77, 0x10,
  0x3F, 0x97, 0x77, 0x72, 0x04, 0xF9, 0x77, 0x77, 0x20, 0x4F, 0x0E, 0x77, 0x77, 0x20, 0x5F, 0x0E,
  0x77, 0x77, 0x20, 0x4F, 0x97, 0x77, 0x72, 0x04, 0xF9, 0x77, 0x77, 0x20, 0x3F, 0x90, 0x17, 0x77,
  0x71, 0x02, 0xF9, 0x02, 0x77, 0x77, 0x2F, 0x90, 0x47, 0x77, 0x72, 0x0E, 0xF0, 0x67, 0x77, 0x72,
  0x0C, 0xF0, 0xA7, 0x77, 0x72, 0x09, 0xF0, 0xD7, 0x77, 0x72, 0x06, 0xF9, 0x03, 0x77, 0x77, 0x10,
  0x1F, 0x90, 0x87, 0x77, 0x72, 0x0D, 0xF0, 0xE7, 0x77, 0x72, 0x07, 0xF9, 0x08, 0x77, 0x77, 0x10,
  0x1F, 0xA0, 0x37, 0x77, 0x71, 0x09, 0xF9, 0x0E, 0x02, 0x77, 0x77, 0x02, 0xFA, 0x0E, 0x04, 0x77,
  0x71, 0x04, 0x50, 0x7F, 0xB0, 0x90, 0x17, 0x73, 0x82, 0x38, 0xDE, 0x60, 0xBF, 0xC8, 0x1A, 0x51,
  0x73, 0x82, 0x25, 0x9D, 0xB0, 0xE6, 0x01, 0x0D, 0xFE, 0x87, 0xDB, 0x98, 0x89, 0xAB, 0xCF, 0x90,
  0xE7, 0x01, 0x0C, 0xFF, 0xFF, 0x90, 0xE7, 0x20, 0xAF, 0xFF, 0xF0, 0xE7, 0x30, 0x50, 0xEF, 0xFF,
  0xD0, 0xE7, 0x50, 0x80, 0xEF, 0xFF, 0xB0, 0x97, 0x70, 0x50, 0xBF, 0xFC, 0x81, 0xD9, 0x57, 0x75,
  0x82, 0x47, 0xAB, 0xE8, 0x5E, 0xCA, 0x86, 0x41, 0x77, 0x75, 0x0A, 0xC0, 0x97, 0x77, 0x74, 0x02,
  0xD0, 0x27, 0x77, 0x74, 0x09, 0xC0, 0xB7, 0x77, 0x74, 0x01, 0xD0, 0x47, 0x77, 0x74, 0x08, 0xD0,
  0x70, 0x27, 0x77, 0x72, 0x01, 0x0E, 0xF0, 0xC0, 0x57, 0x77, 0x70, 0x7F, 0xB0, 0xC0, 0x27, 0x77,
  0x58, 0x24, 0x7A, 0xDF, 0x90, 0xE0, 0x37, 0x77, 0x71, 0x81, 0x38, 0xEE, 0x0C, 0x77, 0x77, 0x30,
  0x10, 0xCE, 0x04, 0x77, 0x77, 0x30, 0x1E, 0x08, 0x77, 0x77, 0x40, 0xBD, 0x0A, 0x77, 0x77, 0x40,
  0xAD, 0x0A, 0x77, 0x77, 0x40, 0xDD, 0x09, 0x77, 0x77, 0x30, 0x8E, 0x05, 0x77, 0x78, 0x14, 0x21,
  0x38, 0x21, 0x37, 0xCE, 0x0E, 0x77, 0x70, 0x1F, 0xFA, 0x06, 0x77, 0x70, 0x1F, 0xF9, 0x0A, 0x77,
  0x71, 0x01, 0xFF, 0x08, 0x77, 0x72, 0x01, 0xFC, 0x81, 0xEA, 0x27, 0x77, 0x48, 0x1A, 0xDE, 0xA8,
  0x4E, 0xED, 0xA8, 0x57, 0x70,
  // "è" (U+00E8)
  0x73, 0x80, 0x57, 0x04, 0x77, 0x77, 0x60, 0xEF, 0x90, 0xE7, 0x77, 0x76, 0x04, 0xFA, 0x07, 0x77,
  0x77, 0x60, 0x8F, 0x90, 0xE0, 0x17, 0x77, 0x76, 0x0B, 0xF9, 0x0A, 0x77, 0x77, 0x70, 0xCF, 0x90,
  0x47, 0x77, 0x76, 0x01, 0x0D, 0xF0, 0xD7, 0x77, 0x77, 0x02, 0x0E, 0xF0, 0x87, 0x77, 0x77, 0x03,
  0x0E, 0xF0, 0x37, 0x77, 0x77, 0x03, 0x0E, 0xE0, 0xC8, 0x0C, 0x00, 0x03, 0x0E, 0xE0, 0x88, 0x0C,
  0x00, 0x03, 0x0E, 0xE0, 0x48, 0x0C, 0x00, 0x03, 0x0E, 0xD0, 0xE0, 0x18, 0x0C, 0x00, 0x02, 0x0D,
  0xD0, 0xB8, 0x0C, 0x10, 0x01, 0x0B, 0xD0, 0x18, 0x0B, 0xE7, 0x08, 0x94, 0x25, 0x8B, 0xDD, 0xEF,
  0xED, 0xC9, 0x63, 0x77, 0x76, 0x81, 0x17, 0xCF, 0xF8, 0x1D, 0x81, 0x77, 0x71, 0x01, 0x09, 0xFF,
  0xE0, 0x90, 0x17, 0x75, 0x06, 0xFF, 0xFA, 0x0E, 0x04, 0x77, 0x20, 0x10, 0xBF, 0xFF, 0xD0, 0x77,
  0x70, 0x20, 0xDF, 0xFF, 0xF0, 0x87, 0x50, 0x20, 0xEF, 0xD8, 0x5C, 0xA9, 0x8A, 0xBE, 0xFC, 0x06,
  0x73, 0x01, 0x0D, 0xFB, 0x09, 0x04, 0x71, 0x81, 0x38, 0xEF, 0xA0, 0x37, 0x20, 0xBF, 0xA0, 0x90,
  0x17, 0x50, 0x10, 0xAF, 0x90, 0xD7, 0x10, 0x6F, 0xA0, 0x67, 0x72, 0x08, 0xF9, 0x08, 0x60, 0x10,
  0xEF, 0x90, 0x47, 0x74, 0x09, 0xF0, 0xE0, 0x15, 0x09, 0xF9, 0x05, 0x77, 0x60, 0xDF, 0x07, 0x40,
  0x1F, 0x90, 0x97, 0x77, 0x05, 0xF0, 0xD4, 0x07, 0xF0, 0xE0, 0x17, 0x77, 0x10, 0xDF, 0x04, 0x30,
  0xEF, 0x07, 0x77, 0x72, 0x07, 0xF0, 0x82, 0x03, 0xF9, 0x01, 0x77, 0x72, 0x03, 0xF0, 0xC2, 0x07,
  0xF0, 0xA7, 0x77, 0x40, 0xEF, 0x20, 0xCF, 0x05, 0x77, 0x74, 0x0B, 0xF0, 0x21, 0xF9, 0x01, 0x77,
  0x74, 0x0A, 0xF0, 0x40, 0x2F, 0x0D, 0x77, 0x75, 0x08, 0xF0, 0x60, 0x48, 0x0C, 0x6F, 0x07, 0x06,
  0x80, 0xC6, 0xF0, 0x80, 0x78, 0x0C, 0x6F, 0x09, 0x08, 0x80, 0xC6, 0xF0, 0x90, 0x88, 0x0C, 0x6F,
  0x00, 0x98, 0x0C, 0x6F, 0x09, 0x08, 0xF0, 0xC8, 0x0B, 0x68, 0x05, 0x07, 0xF0, 0xA7, 0x77, 0x77,
  0x06, 0xF0, 0xB7, 0x77, 0x77, 0x05, 0xF0, 0xC7, 0x77, 0x77, 0x03, 0xF0, 0xE8, 0x0C, 0x00, 0xF9,
  0x02, 0x77, 0x77, 0x70, 0xDF, 0x05, 0x77, 0x77, 0x70, 0x9F, 0x0A, 0x77, 0x77, 0x70, 0x4F, 0x0E,
  0x80, 0xC0, 0x00, 0xEF, 0x06, 0x77, 0x77, 0x70, 0x9F, 0x0D, 0x77, 0x77, 0x70, 0x3F, 0x90, 0x97,
  0x77, 0x77, 0x0A, 0xF9, 0x05, 0x77, 0x77, 0x60, 0x2F, 0xA0, 0x57, 0x77, 0x50, 0x10, 0x26, 0x07,
  0xFA, 0x08, 0x77, 0x72, 0x82, 0x4A, 0xF6, 0x70, 0xBF, 0xA0, 0xD0, 0x57, 0x74, 0x81, 0x38, 0xDB,
  0x06, 0x70, 0x10, 0xDF, 0xB8, 0x2E, 0x94, 0x17, 0x38, 0x21, 0x59, 0xDE, 0x06, 0x71, 0x01, 0x0D,
  0xFE, 0x89, 0x0D, 0xBA, 0x98, 0x89, 0xAC, 0xEF, 0xB0, 0x67, 0x20, 0x10, 0xCF, 0xFF, 0xFC, 0x06,
  0x74, 0x08, 0xFF, 0xFF, 0xB0, 0x67, 0x50, 0x30, 0xCF, 0xFF, 0xF0, 0xE0, 0x47, 0x70, 0x50, 0xCF,
  0xFF, 0xB0, 0xB0, 0x57, 0x74, 0x81, 0x38, 0xDF, 0xFB, 0x82, 0xD9, 0x51, 0x77, 0x72, 0x85, 0x25,
  0x8A, 0xCD, 0xEA, 0x86, 0xED, 0xDB, 0x97, 0x41, 0x73,
  // "é" (U+00E9)
  0x77, 0x75, 0x03, 0x80, 0x57, 0x01, 0x77, 0x77, 0x50, 0xCF, 0xA0, 0x27, 0x77, 0x74, 0x05, 0xFA,
  0x08, 0x77, 0x77, 0x50, 0xDF, 0x90, 0xB7, 0x77, 0x75, 0x08, 0xF9, 0x0D, 0x01, 0x77, 0x77, 0x40,
  0x2F, 0x90, 0xE0, 0x27, 0x77, 0x75, 0x0C, 0xF0, 0xE0, 0x37, 0x77, 0x75, 0x06, 0xF9, 0x04, 0x77,
  0x77, 0x50, 0x10, 0xEF, 0x05, 0x77, 0x77, 0x60, 0xBF, 0x05, 0x77, 0x77, 0x60, 0x5F, 0x06, 0x77,
  0x77, 0x60, 0x10, 0xEE, 0x05, 0x77, 0x77, 0x70, 0xBE, 0x05, 0x77, 0x77, 0x70, 0x8D, 0x0E, 0x04,
  0x80, 0xC0, 0x00, 0xDC, 0x0C, 0x02, 0x80, 0xBF, 0x30, 0x89, 0x42, 0x58, 0xBD, 0xDE, 0xFE, 0xDC,
  0x96, 0x37, 0x77, 0x68, 0x11, 0x7C, 0xFF, 0x81, 0xD8, 0x17, 0x77, 0x10, 0x10, 0x9F, 0xFE, 0x09,
  0x01, 0x77, 0x50, 0x6F, 0xFF, 0xA0, 0xE0, 0x47, 0x72, 0x01, 0x0B, 0xFF, 0xFD, 0x07, 0x77, 0x02,
  0x0D, 0xFF, 0xFF, 0x08, 0x75, 0x02, 0x0E, 0xFD, 0x85, 0xCA, 0x98, 0xAB, 0xEF, 0xC0, 0x67, 0x30,
  0x10, 0xDF, 0xB0, 0x90, 0x47, 0x18, 0x13, 0x8E, 0xFA, 0x03, 0x72, 0x0B, 0xFA, 0x09, 0x01, 0x75,
  0x01, 0x0A, 0xF9, 0x0D, 0x71, 0x06, 0xFA, 0x06, 0x77, 0x20, 0x8F, 0x90, 0x86, 0x01, 0x0E, 0xF9,
  0x04, 0x77, 0x40, 0x9F, 0x0E, 0x01, 0x50, 0x9F, 0x90, 0x57, 0x76, 0x0D, 0xF0, 0x74, 0x01, 0xF9,
  0x09, 0x77, 0x70, 0x5F, 0x0D, 0x40, 0x7F, 0x0E, 0x01, 0x77, 0x71, 0x0D, 0xF0, 0x43, 0x0E, 0xF0,
  0x77, 0x77, 0x20, 0x7F, 0x08, 0x20, 0x3F, 0x90, 0x17, 0x77, 0x20, 0x3F, 0x0C, 0x20, 0x7F, 0x0A,
  0x77, 0x74, 0x0E, 0xF2, 0x0C, 0xF0, 0x57, 0x77, 0x40, 0xBF, 0x02, 0x1F, 0x90, 0x17, 0x77, 0x40,
  0xAF, 0x04, 0x02, 0xF0, 0xD7, 0x77, 0x50, 0x8F, 0x06, 0x04, 0x80, 0xC6, 0xF0, 0x70, 0x68, 0x0C,
  0x6F, 0x08, 0x07, 0x80, 0xC6, 0xF0, 0x90, 0x88, 0x0C, 0x6F, 0x09, 0x08, 0x80, 0xC6, 0xF0, 0x09,
  0x80, 0xC6, 0xF0, 0x90, 0x8F, 0x0C, 0x80, 0xB6, 0x80, 0x50, 0x7F, 0x0A, 0x77, 0x77, 0x70, 0x6F,
  0x0B, 0x77, 0x77, 0x70, 0x5F, 0x0C, 0x77, 0x77, 0x70, 0x3F, 0x0E, 0x80, 0xC0, 0x0F, 0x90, 0x27,
  0x77, 0x77, 0x0D, 0xF0, 0x57, 0x77, 0x77, 0x09, 0xF0, 0xA7, 0x77, 0x77, 0x04, 0xF0, 0xE8, 0x0C,
  0x00, 0x0E, 0xF0, 0x67, 0x77, 0x77, 0x09, 0xF0, 0xD7, 0x77, 0x77, 0x03, 0xF9, 0x09, 0x77, 0x77,
  0x70, 0xAF, 0x90, 0x57, 0x77, 0x76, 0x02, 0xFA, 0x05, 0x77, 0x75, 0x01, 0x02, 0x60, 0x7F, 0xA0,
  0x87, 0x77, 0x28, 0x24, 0xAF, 0x67, 0x0B, 0xFA, 0x0D, 0x05, 0x77, 0x48, 0x13, 0x8D, 0xB0, 0x67,
  0x01, 0x0D, 0xFB, 0x82, 0xE9, 0x41, 0x73, 0x82, 0x15, 0x9D, 0xE0, 0x67, 0x10, 0x10, 0xDF, 0xE8,
  0x90, 0xDB, 0xA9, 0x88, 0x9A, 0xCE, 0xFB, 0x06, 0x72, 0x01, 0x0C, 0xFF, 0xFF, 0xC0, 0x67, 0x40,
  0x8F, 0xFF, 0xFB, 0x06, 0x75, 0x03, 0x0C, 0xFF, 0xFF, 0x0E, 0x04, 0x77, 0x05, 0x0C, 0xFF, 0xFB,
  0x0B, 0x05, 0x77, 0x48, 0x13, 0x8D, 0xFF, 0xB8, 0x2D, 0x95, 0x17, 0x77, 0x28, 0x52, 0x58, 0xAC,
  0xDE, 0xA8, 0x6E, 0xDD, 0xB9, 0x74, 0x17, 0x30,
  // "ê" (U+00EA)
  0x77, 0x30, 0x28, 0x04, 0x77, 0x77, 0x77, 0x0C, 0xF9, 0x08, 0x77, 0x77, 0x50, 0x6F, 0xB0, 0x37,
  0x77, 0x73, 0x03, 0xFC, 0x0D, 0x01, 0x77, 0x77, 0x20, 0xDF, 0xD0, 0xA7, 0x77, 0x71, 0x0B, 0xFF,
  0x07, 0x77, 0x76, 0x08, 0xF0, 0xA0, 0xDF, 0x05, 0x77, 0x74, 0x06, 0xF8, 0x29, 0x01, 0xDF, 0x03,
  0x77, 0x72, 0x04, 0xF0, 0x93, 0x01, 0x0D, 0xE0, 0xE0, 0x27, 0x77, 0x02, 0x0E, 0xE0, 0x95, 0x01,
  0x0C, 0xE0, 0xD0, 0x17, 0x75, 0x01, 0x0D, 0xE0, 0x87, 0x01, 0x0C, 0xE0, 0xC7, 0x75, 0x0C, 0xE0,
  0x87, 0x20, 0x10, 0xBE, 0x0B, 0x77, 0x30, 0xBE, 0x06, 0x75, 0x0A, 0xE0, 0xA7, 0x71, 0x0A, 0xD0,
  0xE0, 0x47, 0x70, 0x7E, 0x0A, 0x76, 0x03, 0xD0, 0xB0, 0x17, 0x72, 0x03, 0x0D, 0xD0, 0x38, 0x0B,
  0xD6, 0x08, 0x94, 0x25, 0x8B, 0xDD, 0xEF, 0xED, 0xC9, 0x63, 0x77, 0x76, 0x81, 0x17, 0xCF, 0xF8,
  0x1D, 0x81, 0x77, 0x71, 0x01, 0x09, 0xFF, 0xE0, 0x90, 0x17, 0x75, 0x06, 0xFF, 0xFA, 0x0E, 0x04,
  0x77, 0x20, 0x10, 0xBF, 0xFF, 0xD0, 0x77, 0x70, 0x20, 0xDF, 0xFF, 0xF0, 0x87, 0x50, 0x20, 0xEF,
  0xD8, 0x5C, 0xA9, 0x8A, 0xBE, 0xFC, 0x06, 0x73, 0x01, 0x0D, 0xFB, 0x09, 0x04, 0x71, 0x81, 0x38,
  0xEF, 0xA0, 0x37, 0x20, 0xBF, 0xA0, 0x90, 0x17, 0x50, 0x10, 0xAF, 0x90, 0xD7, 0x10, 0x6F, 0xA0,
  0x67, 0x72, 0x08, 0xF9, 0x08, 0x60, 0x10, 0xEF, 0x90, 0x47, 0x74, 0x09, 0xF0, 0xE0, 0x15, 0x09,
  0xF9, 0x05, 0x77, 0x60, 0xDF, 0x07, 0x40, 0x1F, 0x90, 0x97, 0x77, 0x05, 0xF0, 0xD4, 0x07, 0xF0,
  0xE0, 0x17, 0x77, 0x10, 0xDF, 0x04, 0x30, 0xEF, 0x07, 0x77, 0x72, 0x07, 0xF0, 0x82, 0x03, 0xF9,
  0x01, 0x77, 0x72, 0x03, 0xF0, 0xC2, 0x07, 0xF0, 0xA7, 0x77, 0x40, 0xEF, 0x20, 0xCF, 0x05, 0x77,
  0x74, 0x0B, 0xF0, 0x21, 0xF9, 0x01, 0x77, 0x74, 0x0A, 0xF0, 0x40, 0x2F, 0x0D, 0x77, 0x75, 0x08,
  0xF0, 0x60, 0x48, 0x0C, 0x6F, 0x07, 0x06, 0x80, 0xC6, 0xF0, 0x80, 0x78, 0x0C, 0x6F, 0x09, 0x08,
  0x80, 0xC6, 0xF0, 0x90, 0x88, 0x0C, 0x6F, 0x00, 0x98, 0x0C, 0x6F, 0x09, 0x08, 0xF0, 0xC8, 0x0B,
  0x68, 0x05, 0x07, 0xF0, 0xA7, 0x77, 0x77, 0x06, 0xF0, 0xB7, 0x77, 0x77, 0x05, 0xF0, 0xC7, 0x77,
  0x77, 0x03, 0xF0, 0xE8, 0x0C, 0x00, 0xF9, 0x02, 0x77, 0x77, 0x70, 0xDF, 0x05, 0x77, 0x77, 0x70,
  0x9F, 0x0A, 0x77, 0x77, 0x70, 0x4F, 0x0E, 0x80, 0xC0, 0x00, 0xEF, 0x06, 0x77, 0x77, 0x70, 0x9F,
  0x0D, 0x77, 0x77, 0x70, 0x3F, 0x90, 0x97, 0x77, 0x77, 0x0A, 0xF9, 0x05, 0x77, 0x77, 0x60, 0x2F,
  0xA0, 0x57, 0x77, 0x50, 0x10, 0x26, 0x07, 0xFA, 0x08, 0x77, 0x72, 0x82, 0x4A, 0xF6, 0x70, 0xBF,
  0xA0, 0xD0, 0x57, 0x74, 0x81, 0x38, 0xDB, 0x06, 0x70, 0x10, 0xDF, 0xB8, 0x2E, 0x94, 0x17, 0x38,
  0x21, 0x59, 0xDE, 0x06, 0x71, 0x01, 0x0D, 0xFE, 0x89, 0x0D, 0xBA, 0x98, 0x89, 0xAC, 0xEF, 0xB0,
  0x67, 0x20, 0x10, 0xCF, 0xFF, 0xFC, 0x06, 0x74, 0x08, 0xFF, 0xFF, 0xB0, 0x67, 0x50, 0x30, 0xCF,
  0xFF, 0xF0, 0xE0, 0x47, 0x70, 0x50, 0xCF, 0xFF, 0xB0, 0xB0, 0x57, 0x74, 0x81, 0x38, 0xDF, 0xFB,
  0x82, 0xD9, 0x51, 0x77, 0x72, 0x85, 0x25, 0x8A, 0xCD, 0xEA, 0x86, 0xED, 0xDB, 0x97, 0x41, 0x73,
  // "ë" (U+00EB)
  0x71, 0x85, 0x18, 0xDF, 0xEB, 0x47, 0x78, 0x53, 0xAE, 0xFD, 0x91, 0x77, 0x10, 0x20, 0xDE, 0x08,
  0x75, 0x06, 0xE0, 0xE0, 0x37, 0x70, 0xAF, 0x90, 0x37, 0x30, 0x1F, 0x90, 0xC7, 0x70, 0xEF, 0x90,
  0x87, 0x30, 0x5F, 0xA0, 0x27, 0x50, 0x1F, 0xA0, 0xA7, 0x30, 0x7F, 0xA0, 0x47, 0x50, 0x1F, 0xA0,
  0x97, 0x30, 0x7F, 0xA0, 0x37, 0x60, 0xEF, 0x90, 0x77, 0x30, 0x5F, 0xA0, 0x17, 0x60, 0x9F, 0x90,
  0x27, 0x40, 0xEF, 0x0B, 0x77, 0x01, 0x0C, 0xE0, 0x67, 0x50, 0x4E, 0x0D, 0x02, 0x77, 0x28, 0x47,
  0xDF, 0xEA, 0x37, 0x78, 0x52, 0xAE, 0xFD, 0x81, 0x80, 0xD9, 0x00, 0x89, 0x42, 0x58, 0xBD, 0xDE,
  0xFE, 0xDC, 0x96, 0x37, 0x77, 0x68, 0x11, 0x7C, 0xFF, 0x81, 0xD8, 0x17, 0x77, 0x10, 0x10, 0x9F,
  0xFE, 0x09, 0x01, 0x77, 0x50, 0x6F, 0xFF, 0xA0, 0xE0, 0x47, 0x72, 0x01, 0x0B, 0xFF, 0xFD, 0x07,
  0x77, 0x02, 0x0D, 0xFF, 0xFF, 0x08, 0x75, 0x02, 0x0E, 0xFD, 0x85, 0xCA, 0x98, 0xAB, 0xEF, 0xC0,
  0x67, 0x30, 0x10, 0xDF, 0xB0, 0x90, 0x47, 0x18, 0x13, 0x8E, 0xFA, 0x03, 0x72, 0x0B, 0xFA, 0x09,
  0x01, 0x75, 0x01, 0x0A, 0xF9, 0x0D, 0x71, 0x06, 0xFA, 0x06, 0x77, 0x20, 0x8F, 0x90, 0x86, 0x01,
  0x0E, 0xF9, 0x04, 0x77, 0x40, 0x9F, 0x0E, 0x01, 0x50, 0x9F, 0x90, 0x57, 0x76, 0x0D, 0xF0, 0x74,
  0x01, 0xF9, 0x09, 0x77, 0x70, 0x5F, 0x0D, 0x40, 0x7F, 0x0E, 0x01, 0x77, 0x71, 0x0D, 0xF0, 0x43,
  0x0E, 0xF0, 0x77, 0x77, 0x20, 0x7F, 0x08, 0x20, 0x3F, 0x90, 0x17, 0x77, 0x20, 0x3F, 0x0C, 0x20,
  0x7F, 0x0A, 0x77, 0x74, 0x0E, 0xF2, 0x0C, 0xF0, 0x57, 0x77, 0x40, 0xBF, 0x02, 0x1F, 0x90, 0x17,
  0x77, 0x40, 0xAF, 0x04, 0x02, 0xF0, 0xD7, 0x77, 0x50, 0x8F, 0x06, 0x04, 0x80, 0xC6, 0xF0, 0x70,
  0x68, 0x0C, 0x6F, 0x08, 0x07, 0x80, 0xC6, 0xF0, 0x90, 0x88, 0x0C, 0x6F, 0x09, 0x08, 0x80, 0xC6,
  0xF0, 0x09, 0x80, 0xC6, 0xF0, 0x90, 0x8F, 0x0C, 0x80, 0xB6, 0x80, 0x50, 0x7F, 0x0A, 0x77, 0x77,
  0x70, 0x6F, 0x0B, 0x77, 0x77, 0x70, 0x5F, 0x0C, 0x77, 0x77, 0x70, 0x3F, 0x0E, 0x80, 0xC0, 0x0F,
  0x90, 0x27, 0x77, 0x77, 0x0D, 0xF0, 0x57, 0x77, 0x77, 0x09, 0xF0, 0xA7, 0x77, 0x77, 0x04, 0xF0,
  0xE8, 0x0C, 0x00, 0x0E, 0xF0, 0x67, 0x77, 0x77, 0x09, 0xF0, 0xD7, 0x77, 0x77, 0x03, 0xF9, 0x09,
  0x77, 0x77, 0x70, 0xAF, 0x90, 0x57, 0x77, 0x76, 0x02, 0xFA, 0x05, 0x77, 0x75, 0x01, 0x02, 0x60,
  0x7F, 0xA0, 0x87, 0x77, 0x28, 0x24, 0xAF, 0x67, 0x0B, 0xFA, 0x0D, 0x05, 0x77, 0x48, 0x13, 0x8D,
  0xB0, 0x67, 0x01, 0x0D, 0xFB, 0x82, 0xE9, 0x41, 0x73, 0x82, 0x15, 0x9D, 0xE0, 0x67, 0x10, 0x10,
  0xDF, 0xE8, 0x90, 0xDB, 0xA9, 0x88, 0x9A, 0xCE, 0xFB, 0x06, 0x72, 0x01, 0x0C, 0xFF, 0xFF, 0xC0,
  0x67, 0x40, 0x8F, 0xFF, 0xFB, 0x06, 0x75, 0x03, 0x0C, 0xFF, 0xFF, 0x0E, 0x04, 0x77, 0x05, 0x0C,
  0xFF, 0xFB, 0x0B, 0x05, 0x77, 0x48, 0x13, 0x8D, 0xFF, 0xB8, 0x2D, 0x95, 0x17, 0x77, 0x28, 0x52,
  0x58, 0xAC, 0xDE, 0xA8, 0x6E, 0xDD, 0xB9, 0x74, 0x17, 0x30,
  // "ì" (U+00EC)
  0x71, 0x80, 0x57, 0x04, 0x77, 0x77, 0x40, 0xEF, 0x90, 0xE7, 0x77, 0x74, 0x04, 0xFA, 0x07, 0x77,
  0x77, 0x40, 0x8F, 0x90, 0xE0, 0x17, 0x77, 0x74, 0x0B, 0xF9, 0x0A, 0x77, 0x77, 0x50, 0xCF, 0x90,
  0x47, 0x77, 0x74, 0x01, 0x0D, 0xF0, 0xD7, 0x77, 0x75, 0x02, 0x0E, 0xF0, 0x87, 0x77, 0x75, 0x03,
  0x0E, 0xF0, 0x37, 0x77, 0x75, 0x03, 0x0E, 0xE0, 0xC7, 0x77, 0x76, 0x03, 0x0E, 0xE0, 0x87, 0x77,
  0x76, 0x03, 0x0E, 0xE0, 0x47, 0x77, 0x76, 0x03, 0x0E, 0xD0, 0xE0, 0x17, 0x77, 0x76, 0x02, 0x0D,
  0xD0, 0xB7, 0x77, 0x77, 0x01, 0x0B, 0xD0, 0x18, 0x0C, 0x90, 0x00, 0x5F, 0xFF, 0xA0, 0x77, 0x73,
  0x05, 0xFF, 0xFA, 0x07, 0x77, 0x30, 0x5F, 0xFF, 0xA0, 0x77, 0x73, 0x05, 0xFF, 0xFA, 0x07, 0x77,
  0x30, 0x5F, 0xFF, 0xA0, 0x77, 0x73, 0x05, 0xFF, 0xFA, 0x07, 0x77, 0x48, 0x91, 0x24, 0x56, 0x78,
  0x9A, 0xBD, 0xEF, 0xD0, 0x77, 0x77, 0x73, 0x81, 0x23, 0xBF, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07,
  0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77,
  0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77,
  0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50,
  0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F,
  0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07,
  0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77,
  0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77,
  0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50,
  0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F,
  0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07,
  0x77, 0x75, 0x86, 0x12, 0x35, 0x67, 0x8D, 0xF8, 0x5C, 0x87, 0x54, 0x32, 0x73, 0x87, 0x46, 0x78,
  0xAB, 0xCD, 0xEF, 0xFF, 0xC8, 0x7D, 0xCB, 0xA8, 0x76, 0x3C, 0x80, 0xC4, 0xF0, 0x90, 0xC8, 0x0C,
  0x4F, 0x09, 0x0C, 0x80, 0xC4, 0xF0, 0x90, 0xC8, 0x0C, 0x4F, 0x09, 0x0C, 0x80, 0xC4, 0xF0, 0x90,
  // "í" (U+00ED)
  0x77, 0x73, 0x03, 0x80, 0x57, 0x01, 0x77, 0x77, 0x30, 0xCF, 0xA0, 0x27, 0x77, 0x72, 0x05, 0xFA,
  0x08, 0x77, 0x77, 0x30, 0xDF, 0x90, 0xB7, 0x77, 0x73, 0x08, 0xF9, 0x0D, 0x01, 0x77, 0x77, 0x20,
  0x2F, 0x90, 0xE0, 0x27, 0x77, 0x73, 0x0C, 0xF0, 0xE0, 0x37, 0x77, 0x73, 0x06, 0xF9, 0x04, 0x77,
  0x77, 0x30, 0x10, 0xEF, 0x05, 0x77, 0x77, 0x40, 0xBF, 0x05, 0x77, 0x77, 0x40, 0x5F, 0x06, 0x77,
  0x77, 0x40, 0x10, 0xEE, 0x05, 0x77, 0x77, 0x50, 0xBE, 0x05, 0x77, 0x77, 0x50, 0x8D, 0x0E, 0x04,
  0x77, 0x77, 0x60, 0xDC, 0x0C, 0x02, 0x80, 0xC9, 0x40, 0x05, 0xFF, 0xFA, 0x07, 0x77, 0x30, 0x5F,
  0xFF, 0xA0, 0x77, 0x73, 0x05, 0xFF, 0xFA, 0x07, 0x77, 0x30, 0x5F, 0xFF, 0xA0, 0x77, 0x73, 0x05,
  0xFF, 0xFA, 0x07, 0x77, 0x30, 0x5F, 0xFF, 0xA0, 0x77, 0x74, 0x89, 0x12, 0x45, 0x67, 0x89, 0xAB,
  0xDE, 0xFD, 0x07, 0x77, 0x77, 0x38, 0x12, 0x3B, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77,
  0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75,
  0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09,
  0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0,
  0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77,
  0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77,
  0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75,
  0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09,
  0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0,
  0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77,
  0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77,
  0x58, 0x61, 0x23, 0x56, 0x78, 0xDF, 0x85, 0xC8, 0x75, 0x43, 0x27, 0x38, 0x74, 0x67, 0x8A, 0xBC,
  0xDE, 0xFF, 0xFC, 0x87, 0xDC, 0xBA, 0x87, 0x63, 0xC8, 0x0C, 0x4F, 0x09, 0x0C, 0x80, 0xC4, 0xF0,
  0x90, 0xC8, 0x0C, 0x4F, 0x09, 0x0C, 0x80, 0xC4, 0xF0, 0x90, 0xC8, 0x0C, 0x4F, 0x09,
  // "î" (U+00EE)
  0x77, 0x10, 0x28, 0x04, 0x77, 0x77, 0x75, 0x0C, 0xF9, 0x08, 0x77, 0x77, 0x30, 0x6F, 0xB0, 0x37,
  0x77, 0x71, 0x03, 0xFC, 0x0D, 0x01, 0x77, 0x77, 0x0D, 0xFD, 0x0A, 0x77, 0x76, 0x0B, 0xFF, 0x07,
  0x77, 0x74, 0x08, 0xF0, 0xA0, 0xDF, 0x05, 0x77, 0x72, 0x06, 0xF8, 0x29, 0x01, 0xDF, 0x03, 0x77,
  0x70, 0x4F, 0x09, 0x30, 0x10, 0xDE, 0x0E, 0x02, 0x77, 0x50, 0x20, 0xEE, 0x09, 0x50, 0x10, 0xCE,
  0x0D, 0x01, 0x77, 0x30, 0x10, 0xDE, 0x08, 0x70, 0x10, 0xCE, 0x0C, 0x77, 0x30, 0xCE, 0x08, 0x72,
  0x01, 0x0B, 0xE0, 0xB7, 0x71, 0x0B, 0xE0, 0x67, 0x50, 0xAE, 0x0A, 0x76, 0x0A, 0xD0, 0xE0, 0x47,
  0x70, 0x7E, 0x0A, 0x74, 0x03, 0xD0, 0xB0, 0x17, 0x72, 0x03, 0x0D, 0xD0, 0x38, 0x0B, 0xF7, 0x00,
  0x5F, 0xFF, 0xA0, 0x77, 0x73, 0x05, 0xFF, 0xFA, 0x07, 0x77, 0x30, 0x5F, 0xFF, 0xA0, 0x77, 0x73,
  0x05, 0xFF, 0xFA, 0x07, 0x77, 0x30, 0x5F, 0xFF, 0xA0, 0x77, 0x73, 0x05, 0xFF, 0xFA, 0x07, 0x77,
  0x48, 0x91, 0x24, 0x56, 0x78, 0x9A, 0xBD, 0xEF, 0xD0, 0x77, 0x77, 0x73, 0x81, 0x23, 0xBF, 0x07,
  0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77,
  0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77,
  0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50,
  0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F,
  0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07,
  0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77,
  0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77,
  0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50,
  0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F,
  0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07,
  0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x75, 0x86, 0x12, 0x35, 0x67, 0x8D, 0xF8, 0x5C, 0x87, 0x54,
  0x32, 0x73, 0x87, 0x46, 0x78, 0xAB, 0xCD, 0xEF, 0xFF, 0xC8, 0x7D, 0xCB, 0xA8, 0x76, 0x3C, 0x80,
  0xC4, 0xF0, 0x90, 0xC8, 0x0C, 0x4F, 0x09, 0x0C, 0x80, 0xC4, 0xF0, 0x90, 0xC8, 0x0C, 0x4F, 0x09,
  0x0C, 0x80, 0xC4, 0xF0, 0x90,
  // "ï" (U+00EF)
  0x68, 0x51, 0x8D, 0xFE, 0xB4, 0x77, 0x85, 0x3A, 0xEF, 0xD9, 0x17, 0x60, 0x20, 0xDE, 0x08, 0x75,
  0x06, 0xE0, 0xE0, 0x37, 0x50, 0xAF, 0x90, 0x37, 0x30, 0x1F, 0x90, 0xC7, 0x50, 0xEF, 0x90, 0x87,
  0x30, 0x5F, 0xA0, 0x27, 0x30, 0x1F, 0xA0, 0xA7, 0x30, 0x7F, 0xA0, 0x47, 0x30, 0x1F, 0xA0, 0x97,
  0x30, 0x7F, 0xA0, 0x37, 0x40, 0xEF, 0x90, 0x77, 0x30, 0x5F, 0xA0, 0x17, 0x40, 0x9F, 0x90, 0x27,
  0x40, 0xEF, 0x0B, 0x75, 0x01, 0x0C, 0xE0, 0x67, 0x50, 0x4E, 0x0D, 0x02, 0x77, 0x84, 0x7D, 0xFE,
  0xA3, 0x77, 0x85, 0x2A, 0xEF, 0xD8, 0x18, 0x0D, 0xA5, 0x00, 0x5F, 0xFF, 0xA0, 0x77, 0x73, 0x05,
  0xFF, 0xFA, 0x07, 0x77, 0x30, 0x5F, 0xFF, 0xA0, 0x77, 0x73, 0x05, 0xFF, 0xFA, 0x07, 0x77, 0x30,
  0x5F, 0xFF, 0xA0, 0x77, 0x73, 0x05, 0xFF, 0xFA, 0x07, 0x77, 0x48, 0x91, 0x24, 0x56, 0x78, 0x9A,
  0xBD, 0xEF, 0xD0, 0x77, 0x77, 0x73, 0x81, 0x23, 0xBF, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77,
  0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77,
  0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50,
  0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F,
  0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07,
  0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77,
  0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77,
  0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50,
  0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F,
  0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07,
  0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77,
  0x75, 0x86, 0x12, 0x35, 0x67, 0x8D, 0xF8, 0x5C, 0x87, 0x54, 0x32, 0x73, 0x87, 0x46, 0x78, 0xAB,
  0xCD, 0xEF, 0xFF, 0xC8, 0x7D, 0xCB, 0xA8, 0x76, 0x3C, 0x80, 0xC4, 0xF0, 0x90, 0xC8, 0x0C, 0x4F,
  0x09, 0x0C, 0x80, 0xC4, 0xF0, 0x90, 0xC8, 0x0C, 0x4F, 0x09, 0x0C, 0x80, 0xC4, 0xF0, 0x90,
  // "ð" (U+00F0)
  0x77, 0x07, 0x03, 0x77, 0x60, 0x17, 0x76, 0x04, 0xA0, 0xA0, 0x27, 0x72, 0x81, 0x5E, 0xA7, 0x76,
  0x0D, 0xC0, 0x90, 0x17, 0x50, 0x30, 0xCB, 0x06, 0x77, 0x40, 0x8E, 0x0E, 0x06, 0x72, 0x02, 0x0A,
  0xD0, 0xE0, 0x27, 0x72, 0x02, 0xFA, 0x0B, 0x02, 0x60, 0x8F, 0x90, 0xC7, 0x72, 0x08, 0xFB, 0x0E,
  0x05, 0x30, 0x60, 0xEF, 0xB0, 0x47, 0x72, 0x05, 0x0D, 0xFB, 0x81, 0xA4, 0xCF, 0xB0, 0xB0, 0x27,
  0x75, 0x08, 0xFF, 0xE0, 0xD0, 0x47, 0x77, 0x10, 0x20, 0xBF, 0xFA, 0x0E, 0x07, 0x77, 0x75, 0x06,
  0x0E, 0xFE, 0x09, 0x01, 0x77, 0x77, 0x05, 0xFC, 0x0B, 0x03, 0x77, 0x77, 0x01, 0x0A, 0xFD, 0x04,
  0x77, 0x77, 0x07, 0x0E, 0xFE, 0x0E, 0x03, 0x77, 0x74, 0x05, 0x0D, 0xFF, 0xA0, 0xE0, 0x27, 0x77,
  0x10, 0x30, 0xBF, 0xB0, 0xC0, 0xDF, 0x0D, 0x01, 0x77, 0x50, 0x10, 0x9F, 0xB8, 0x3D, 0x50, 0x2D,
  0xF0, 0xB7, 0x75, 0x07, 0xFB, 0x08, 0x40, 0x20, 0xEF, 0x08, 0x77, 0x50, 0xCF, 0x0A, 0x01, 0x60,
  0x20, 0xEF, 0x04, 0x77, 0x40, 0x2D, 0x0C, 0x03, 0x72, 0x02, 0x0E, 0xE0, 0xE0, 0x17, 0x74, 0x06,
  0xA0, 0xE0, 0x67, 0x50, 0x5F, 0x09, 0x77, 0x58, 0x1B, 0x81, 0x77, 0x08, 0xF0, 0x38, 0x0C, 0x00,
  0x0B, 0xE0, 0xD8, 0x0C, 0x00, 0x01, 0x0E, 0xE0, 0x68, 0x0C, 0x00, 0x05, 0xE0, 0xD8, 0x0C, 0x10,
  0x0B, 0xE0, 0x68, 0x0C, 0x00, 0x03, 0xE0, 0xD7, 0x76, 0x89, 0x02, 0x46, 0x78, 0x87, 0x65, 0x37,
  0x0A, 0xE0, 0x67, 0x71, 0x82, 0x27, 0xBE, 0xFC, 0x81, 0xC8, 0x33, 0x02, 0xE0, 0xB7, 0x60, 0x40,
  0xBF, 0xFC, 0x0C, 0x04, 0x20, 0xBE, 0x02, 0x73, 0x02, 0x0B, 0xFF, 0xF9, 0x81, 0xA0, 0x4E, 0x08,
  0x72, 0x05, 0x0E, 0xFF, 0xFB, 0x81, 0xC1, 0xED, 0x0D, 0x71, 0x08, 0xFF, 0xFE, 0x0C, 0x0A, 0xE0,
  0x26, 0x08, 0x80, 0xC0, 0xF0, 0x65, 0x07, 0xFC, 0x83, 0xB7, 0x42, 0x12, 0x83, 0x12, 0x47, 0xBF,
  0xF0, 0xA4, 0x03, 0xFB, 0x08, 0x01, 0x75, 0x01, 0x09, 0xFD, 0x0E, 0x40, 0xDF, 0x90, 0xC0, 0x27,
  0x72, 0x02, 0x0D, 0xFC, 0x02, 0x20, 0x7F, 0x90, 0xB7, 0x75, 0x01, 0x0C, 0xFB, 0x05, 0x20, 0xEF,
  0x0E, 0x01, 0x77, 0x60, 0x10, 0xDF, 0xA8, 0x17, 0x05, 0xF9, 0x04, 0x77, 0x71, 0x04, 0xFA, 0x81,
  0x90, 0xBF, 0x0B, 0x77, 0x73, 0x0A, 0xF9, 0x0C, 0x01, 0xF9, 0x05, 0x77, 0x73, 0x03, 0xF9, 0x0D,
  0x05, 0xF0, 0xE7, 0x77, 0x50, 0xCF, 0x0E, 0x08, 0xF0, 0xA7, 0x77, 0x50, 0x7F, 0x0E, 0x0B, 0xF0,
  0x77, 0x77, 0x50, 0x3F, 0x90, 0xCF, 0x03, 0x77, 0x75, 0x01, 0xF9, 0x0E, 0xF0, 0x17, 0x77, 0x6F,
  0xFA, 0x01, 0x77, 0x76, 0xFF, 0xA7, 0x77, 0x7F, 0x0E, 0xF9, 0x77, 0x77, 0xF0, 0xDF, 0x97, 0x77,
  0x60, 0x1F, 0x0B, 0x0E, 0xF0, 0x17, 0x77, 0x50, 0x2F, 0x09, 0x0D, 0xF0, 0x27, 0x77, 0x50, 0x5F,
  0x07, 0x0A, 0xF0, 0x57, 0x77, 0x50, 0x8F, 0x04, 0x07, 0xF0, 0x97, 0x77, 0x50, 0xBF, 0x01, 0x04,
  0xF0, 0xD7, 0x77, 0x5F, 0x0D, 0x20, 0xEF, 0x04, 0x77, 0x73, 0x05, 0xF0, 0x82, 0x0A, 0xF0, 0xA7,
  0x77, 0x30, 0xBF, 0x03, 0x20, 0x4F, 0x90, 0x37, 0x77, 0x10, 0x4F, 0x0D, 0x40, 0xCF, 0x0D, 0x77,
  0x71, 0x0D, 0xF0, 0x64, 0x05, 0xF9, 0x0A, 0x77, 0x60, 0x9F, 0x0E, 0x60, 0xBF, 0x90, 0x97, 0x74,
  0x08, 0xF9, 0x05, 0x60, 0x10, 0xEF, 0x90, 0xC0, 0x37, 0x70, 0x20, 0xBF, 0x90, 0xB7, 0x10, 0x4F,
  0xB8, 0x1B, 0x51, 0x72, 0x04, 0x0A, 0xFA, 0x0E, 0x01, 0x72, 0x06, 0xFD, 0x86, 0xDB, 0x98, 0x89,
  0xAC, 0xFC, 0x0E, 0x03, 0x74, 0x06, 0xFF, 0xFF, 0x90, 0xE0, 0x37, 0x60, 0x40, 0xEF, 0xFF, 0xD0,
  0xD0, 0x37, 0x71, 0x01, 0x0A, 0xFF, 0xFB, 0x0A, 0x01, 0x77, 0x40, 0x40, 0xBF, 0xFE, 0x0C, 0x04,
  0x77, 0x71, 0x81, 0x39, 0xDF, 0xF8, 0x1E, 0x93, 0x77, 0x76, 0x84, 0x36, 0x9B, 0xDE, 0xA8, 0x4E,
  0xDC, 0xA7, 0x37, 0x71,
  // "ñ" (U+00F1)
  0x75, 0x84, 0x46, 0x87, 0x51, 0x77, 0x84, 0x38, 0x88, 0x81, 0x76, 0x08, 0x0E, 0xE0, 0xB0, 0x37,
  0x50, 0x9C, 0x75, 0x02, 0x0D, 0xFB, 0x0A, 0x01, 0x73, 0x0E, 0xB0, 0xD7, 0x40, 0x10, 0xDF, 0xD0,
  0xE0, 0x77, 0x10, 0x8C, 0x09, 0x74, 0x0B, 0xFF, 0x90, 0xD0, 0x65, 0x06, 0xD0, 0x57, 0x30, 0x5F,
  0xFC, 0x83, 0xEA, 0x89, 0xDD, 0x0E, 0x74, 0x0C, 0xFF, 0xFF, 0x08, 0x73, 0x03, 0xD8, 0x5D, 0x51,
  0x01, 0x5C, 0xFF, 0xA0, 0xE0, 0x17, 0x30, 0x8C, 0x0D, 0x01, 0x60, 0x50, 0xDF, 0xF0, 0x57, 0x40,
  0xCC, 0x04, 0x72, 0x07, 0xFD, 0x07, 0x75, 0x0E, 0xB0, 0xD7, 0x40, 0x20, 0xAF, 0x90, 0xE0, 0x67,
  0x50, 0x1C, 0x08, 0x76, 0x87, 0x28, 0xCE, 0xFD, 0xB6, 0x18, 0x0B, 0xC3, 0x08, 0x42, 0x69, 0xBD,
  0xEA, 0x83, 0xED, 0xB8, 0x47, 0x40, 0xCD, 0x0B, 0x78, 0x11, 0x7D, 0xFE, 0x81, 0xE9, 0x27, 0x10,
  0xCD, 0x0E, 0x60, 0x70, 0xEF, 0xFC, 0x09, 0x70, 0xCE, 0x01, 0x30, 0x20, 0xDF, 0xFF, 0x0D, 0x02,
  0x50, 0xCE, 0x04, 0x20, 0x30, 0xEF, 0xFF, 0xA0, 0xE0, 0x34, 0x0C, 0xE8, 0x26, 0x02, 0xEF, 0xFF,
  0xC0, 0xE0, 0x13, 0x0C, 0xE8, 0x19, 0x0C, 0xF9, 0x85, 0xCA, 0x98, 0x9A, 0xCF, 0xD0, 0xB3, 0x0C,
  0xE0, 0xB0, 0x6E, 0x0A, 0x04, 0x72, 0x04, 0x0C, 0xFB, 0x05, 0x20, 0xCF, 0xD0, 0xD0, 0x37, 0x60,
  0x5F, 0xA0, 0xC2, 0x0C, 0xFC, 0x0B, 0x77, 0x20, 0x4F, 0xA8, 0x12, 0x0C, 0xFB, 0x0C, 0x77, 0x40,
  0x8F, 0x98, 0x17, 0x0C, 0xFB, 0x02, 0x77, 0x40, 0x1F, 0x98, 0x1B, 0x0C, 0xFA, 0x0A, 0x77, 0x60,
  0xAF, 0x81, 0xE0, 0xCF, 0xA0, 0x27, 0x76, 0x05, 0xF9, 0x10, 0xCF, 0x90, 0xB7, 0x77, 0x02, 0xF9,
  0x02, 0x0C, 0xF9, 0x07, 0x77, 0x71, 0xF9, 0x03, 0x0C, 0xF9, 0x02, 0x77, 0x71, 0x0E, 0xF0, 0x30,
  0xCF, 0x0E, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x0C, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x09,
  0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x07, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x06, 0x77, 0x72,
  0x0D, 0xF0, 0x30, 0xCF, 0x05, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x05, 0x77, 0x72, 0x0D, 0xF0,
  0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF,
  0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77,
  0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D,
  0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30,
  0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04,
  0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72,
  0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0,
  0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF,
  0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77,
  0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D,
  0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30,
  // "ò" (U+00F2)
  0x73, 0x80, 0x57, 0x04, 0x77, 0x77, 0x60, 0xEF, 0x90, 0xE7, 0x77, 0x76, 0x04, 0xFA, 0x07, 0x77,
  0x77, 0x60, 0x8F, 0x90, 0xE0, 0x17, 0x77, 0x76, 0x0B, 0xF9, 0x0A, 0x77, 0x77, 0x70, 0xCF, 0x90,
  0x47, 0x77, 0x76, 0x01, 0x0D, 0xF0, 0xD7, 0x77, 0x77, 0x02, 0x0E, 0xF0, 0x87, 0x77, 0x77, 0x03,
  0x0E, 0xF0, 0x37, 0x77, 0x77, 0x03, 0x0E, 0xE0, 0xC8, 0x0C, 0x00, 0x03, 0x0E, 0xE0, 0x88, 0x0C,
  0x00, 0x03, 0x0E, 0xE0, 0x48, 0x0C, 0x00, 0x03, 0x0E, 0xD0, 0xE0, 0x18, 0x0C, 0x00, 0x02, 0x0D,
  0xD0, 0xB8, 0x0C, 0x10, 0x01, 0x0B, 0xD0, 0x18, 0x0B, 0xE6, 0x08, 0x94, 0x36, 0x9C, 0xDE, 0xFE,
  0xED, 0xB8, 0x51, 0x77, 0x76, 0x81, 0x28, 0xDF, 0xF8, 0x1C, 0x71, 0x77, 0x71, 0x03, 0x0A, 0xFF,
  0xD8, 0x1E, 0x81, 0x77, 0x50, 0x8F, 0xFF, 0xA0, 0xE0, 0x57, 0x72, 0x02, 0x0D, 0xFF, 0xFD, 0x0B,
  0x77, 0x03, 0x0E, 0xFF, 0xFF, 0x0C, 0x01, 0x74, 0x02, 0x0E, 0xFC, 0x86, 0xDB, 0x98, 0x89, 0xBE,
  0xFC, 0x0D, 0x01, 0x72, 0x01, 0x0D, 0xFA, 0x81, 0xD7, 0x27, 0x18, 0x13, 0x8E, 0xFA, 0x0B, 0x72,
  0x0B, 0xFA, 0x07, 0x76, 0x01, 0x09, 0xFA, 0x08, 0x70, 0x5F, 0x90, 0xE0, 0x37, 0x72, 0x06, 0xFA,
  0x03, 0x60, 0xDF, 0x90, 0x37, 0x74, 0x05, 0xF9, 0x0C, 0x50, 0x6F, 0x90, 0x67, 0x76, 0x09, 0xF9,
  0x05, 0x40, 0xDF, 0x0C, 0x77, 0x70, 0x10, 0xEF, 0x0B, 0x30, 0x4F, 0x90, 0x47, 0x77, 0x10, 0x7F,
  0x90, 0x32, 0x09, 0xF0, 0xC7, 0x77, 0x30, 0xEF, 0x08, 0x20, 0xDF, 0x06, 0x77, 0x73, 0x09, 0xF8,
  0x1C, 0x02, 0xF9, 0x01, 0x77, 0x73, 0x04, 0xF9, 0x01, 0x05, 0xF0, 0xC7, 0x77, 0x50, 0xEF, 0x05,
  0x08, 0xF0, 0x97, 0x77, 0x50, 0xCF, 0x07, 0x0A, 0xF0, 0x67, 0x77, 0x50, 0x9F, 0x09, 0x0C, 0xF0,
  0x37, 0x77, 0x50, 0x6F, 0x0C, 0x0E, 0xF0, 0x27, 0x77, 0x50, 0x5F, 0x0D, 0x0E, 0xF0, 0x17, 0x77,
  0x50, 0x4F, 0x0E, 0xF9, 0x77, 0x76, 0x03, 0xFF, 0xA7, 0x77, 0x60, 0x2F, 0xFA, 0x77, 0x76, 0x02,
  0xFF, 0xA7, 0x77, 0x60, 0x3F, 0x90, 0xEF, 0x01, 0x77, 0x75, 0x04, 0xF0, 0xE0, 0xDF, 0x02, 0x77,
  0x75, 0x05, 0xF0, 0xD0, 0xCF, 0x04, 0x77, 0x75, 0x07, 0xF0, 0xC0, 0x9F, 0x07, 0x77, 0x75, 0x09,
  0xF0, 0xA0, 0x7F, 0x09, 0x77, 0x75, 0x0C, 0xF0, 0x70, 0x4F, 0x0C, 0x77, 0x75, 0xF9, 0x05, 0x01,
  0xF9, 0x02, 0x77, 0x73, 0x04, 0xF9, 0x81, 0x10, 0xCF, 0x07, 0x77, 0x73, 0x0A, 0xF0, 0xD2, 0x07,
  0xF0, 0xD7, 0x77, 0x30, 0xEF, 0x08, 0x20, 0x2F, 0x90, 0x57, 0x77, 0x10, 0x7F, 0x90, 0x33, 0x0B,
  0xF0, 0xD7, 0x77, 0x01, 0x0E, 0xF0, 0xC4, 0x04, 0xF9, 0x08, 0x77, 0x60, 0x9F, 0x90, 0x55, 0x0B,
  0xF9, 0x04, 0x77, 0x40, 0x5F, 0x90, 0xD6, 0x02, 0xFA, 0x05, 0x77, 0x20, 0x5F, 0xA0, 0x37, 0x08,
  0xFA, 0x09, 0x01, 0x75, 0x01, 0x09, 0xFA, 0x09, 0x72, 0x0B, 0xFA, 0x81, 0xE8, 0x27, 0x18, 0x12,
  0x8E, 0xFA, 0x0C, 0x73, 0x01, 0x0D, 0xFC, 0x86, 0xEB, 0x98, 0x89, 0xBE, 0xFC, 0x0E, 0x01, 0x74,
  0x01, 0x0C, 0xFF, 0xFF, 0x0D, 0x02, 0x77, 0x0B, 0xFF, 0xFD, 0x0C, 0x01, 0x77, 0x20, 0x60, 0xEF,
  0xFF, 0xA0, 0x77, 0x75, 0x01, 0x09, 0xFF, 0xE0, 0xA0, 0x27, 0x77, 0x18, 0x11, 0x7C, 0xFF, 0x81,
  0xD8, 0x27, 0x77, 0x68, 0x41, 0x58, 0xBD, 0xEA, 0x84, 0xED, 0xB9, 0x62, 0x77, 0x10,
  // "ó" (U+00F3)
  0x77, 0x75, 0x03, 0x80, 0x57, 0x01, 0x77, 0x77, 0x50, 0xCF, 0xA0, 0x27, 0x77, 0x74, 0x05, 0xFA,
  0x08, 0x77, 0x77, 0x50, 0xDF, 0x90, 0xB7, 0x77, 0x75, 0x08, 0xF9, 0x0D, 0x01, 0x77, 0x77, 0x40,
  0x2F, 0x90, 0xE0, 0x27, 0x77, 0x75, 0x0C, 0xF0, 0xE0, 0x37, 0x77, 0x75, 0x06, 0xF9, 0x04, 0x77,
  0x77, 0x50, 0x10, 0xEF, 0x05, 0x77, 0x77, 0x60, 0xBF, 0x05, 0x77, 0x77, 0x60, 0x5F, 0x06, 0x77,
  0x77, 0x60, 0x10, 0xEE, 0x05, 0x77, 0x77, 0x70, 0xBE, 0x05, 0x77, 0x77, 0x70, 0x8D, 0x0E, 0x04,
  0x80, 0xC0, 0x00, 0xDC, 0x0C, 0x02, 0x80, 0xBF, 0x20, 0x89, 0x43, 0x69, 0xCD, 0xEF, 0xEE, 0xDB,
  0x85, 0x17, 0x77, 0x68, 0x12, 0x8D, 0xFF, 0x81, 0xC7, 0x17, 0x77, 0x10, 0x30, 0xAF, 0xFD, 0x81,
  0xE8, 0x17, 0x75, 0x08, 0xFF, 0xFA, 0x0E, 0x05, 0x77, 0x20, 0x20, 0xDF, 0xFF, 0xD0, 0xB7, 0x70,
  0x30, 0xEF, 0xFF, 0xF0, 0xC0, 0x17, 0x40, 0x20, 0xEF, 0xC8, 0x6D, 0xB9, 0x88, 0x9B, 0xEF, 0xC0,
  0xD0, 0x17, 0x20, 0x10, 0xDF, 0xA8, 0x1D, 0x72, 0x71, 0x81, 0x38, 0xEF, 0xA0, 0xB7, 0x20, 0xBF,
  0xA0, 0x77, 0x60, 0x10, 0x9F, 0xA0, 0x87, 0x05, 0xF9, 0x0E, 0x03, 0x77, 0x20, 0x6F, 0xA0, 0x36,
  0x0D, 0xF9, 0x03, 0x77, 0x40, 0x5F, 0x90, 0xC5, 0x06, 0xF9, 0x06, 0x77, 0x60, 0x9F, 0x90, 0x54,
  0x0D, 0xF0, 0xC7, 0x77, 0x01, 0x0E, 0xF0, 0xB3, 0x04, 0xF9, 0x04, 0x77, 0x71, 0x07, 0xF9, 0x03,
  0x20, 0x9F, 0x0C, 0x77, 0x73, 0x0E, 0xF0, 0x82, 0x0D, 0xF0, 0x67, 0x77, 0x30, 0x9F, 0x81, 0xC0,
  0x2F, 0x90, 0x17, 0x77, 0x30, 0x4F, 0x90, 0x10, 0x5F, 0x0C, 0x77, 0x75, 0x0E, 0xF0, 0x50, 0x8F,
  0x09, 0x77, 0x75, 0x0C, 0xF0, 0x70, 0xAF, 0x06, 0x77, 0x75, 0x09, 0xF0, 0x90, 0xCF, 0x03, 0x77,
  0x75, 0x06, 0xF0, 0xC0, 0xEF, 0x02, 0x77, 0x75, 0x05, 0xF0, 0xD0, 0xEF, 0x01, 0x77, 0x75, 0x04,
  0xF0, 0xEF, 0x97, 0x77, 0x60, 0x3F, 0xFA, 0x77, 0x76, 0x02, 0xFF, 0xA7, 0x77, 0x60, 0x2F, 0xFA,
  0x77, 0x76, 0x03, 0xF9, 0x0E, 0xF0, 0x17, 0x77, 0x50, 0x4F, 0x0E, 0x0D, 0xF0, 0x27, 0x77, 0x50,
  0x5F, 0x0D, 0x0C, 0xF0, 0x47, 0x77, 0x50, 0x7F, 0x0C, 0x09, 0xF0, 0x77, 0x77, 0x50, 0x9F, 0x0A,
  0x07, 0xF0, 0x97, 0x77, 0x50, 0xCF, 0x07, 0x04, 0xF0, 0xC7, 0x77, 0x5F, 0x90, 0x50, 0x1F, 0x90,
  0x27, 0x77, 0x30, 0x4F, 0x98, 0x11, 0x0C, 0xF0, 0x77, 0x77, 0x30, 0xAF, 0x0D, 0x20, 0x7F, 0x0D,
  0x77, 0x73, 0x0E, 0xF0, 0x82, 0x02, 0xF9, 0x05, 0x77, 0x71, 0x07, 0xF9, 0x03, 0x30, 0xBF, 0x0D,
  0x77, 0x70, 0x10, 0xEF, 0x0C, 0x40, 0x4F, 0x90, 0x87, 0x76, 0x09, 0xF9, 0x05, 0x50, 0xBF, 0x90,
  0x47, 0x74, 0x05, 0xF9, 0x0D, 0x60, 0x2F, 0xA0, 0x57, 0x72, 0x05, 0xFA, 0x03, 0x70, 0x8F, 0xA0,
  0x90, 0x17, 0x50, 0x10, 0x9F, 0xA0, 0x97, 0x20, 0xBF, 0xA8, 0x1E, 0x82, 0x71, 0x81, 0x28, 0xEF,
  0xA0, 0xC7, 0x30, 0x10, 0xDF, 0xC8, 0x6E, 0xB9, 0x88, 0x9B, 0xEF, 0xC0, 0xE0, 0x17, 0x40, 0x10,
  0xCF, 0xFF, 0xF0, 0xD0, 0x27, 0x70, 0xBF, 0xFF, 0xD0, 0xC0, 0x17, 0x72, 0x06, 0x0E, 0xFF, 0xFA,
  0x07, 0x77, 0x50, 0x10, 0x9F, 0xFE, 0x0A, 0x02, 0x77, 0x71, 0x81, 0x17, 0xCF, 0xF8, 0x1D, 0x82,
  0x77, 0x76, 0x84, 0x15, 0x8B, 0xDE, 0xA8, 0x4E, 0xDB, 0x96, 0x27, 0x71,
  // "ô" (U+00F4)
  0x77, 0x30, 0x28, 0x04, 0x77, 0x77, 0x77, 0x0C, 0xF9, 0x08, 0x77, 0x77, 0x50, 0x6F, 0xB0, 0x37,
  0x77, 0x73, 0x03, 0xFC, 0x0D, 0x01, 0x77, 0x77, 0x20, 0xDF, 0xD0, 0xA7, 0x77, 0x71, 0x0B, 0xFF,
  0x07, 0x77, 0x76, 0x08, 0xF0, 0xA0, 0xDF, 0x05, 0x77, 0x74, 0x06, 0xF8, 0x29, 0x01, 0xDF, 0x03,
  0x77, 0x72, 0x04, 0xF0, 0x93, 0x01, 0x0D, 0xE0, 0xE0, 0x27, 0x77, 0x02, 0x0E, 0xE0, 0x95, 0x01,
  0x0C, 0xE0, 0xD0, 0x17, 0x75, 0x01, 0x0D, 0xE0, 0x87, 0x01, 0x0C, 0xE0, 0xC7, 0x75, 0x0C, 0xE0,
  0x87, 0x20, 0x10, 0xBE, 0x0B, 0x77, 0x30, 0xBE, 0x06, 0x75, 0x0A, 0xE0, 0xA7, 0x71, 0x0A, 0xD0,
  0xE0, 0x47, 0x70, 0x7E, 0x0A, 0x76, 0x03, 0xD0, 0xB0, 0x17, 0x72, 0x03, 0x0D, 0xD0, 0x38, 0x0B,
  0xD5, 0x08, 0x94, 0x36, 0x9C, 0xDE, 0xFE, 0xED, 0xB8, 0x51, 0x77, 0x76, 0x81, 0x28, 0xDF, 0xF8,
  0x1C, 0x71, 0x77, 0x71, 0x03, 0x0A, 0xFF, 0xD8, 0x1E, 0x81, 0x77, 0x50, 0x8F, 0xFF, 0xA0, 0xE0,
  0x57, 0x72, 0x02, 0x0D, 0xFF, 0xFD, 0x0B, 0x77, 0x03, 0x0E, 0xFF, 0xFF, 0x0C, 0x01, 0x74, 0x02,
  0x0E, 0xFC, 0x86, 0xDB, 0x98, 0x89, 0xBE, 0xFC, 0x0D, 0x01, 0x72, 0x01, 0x0D, 0xFA, 0x81, 0xD7,
  0x27, 0x18, 0x13, 0x8E, 0xFA, 0x0B, 0x72, 0x0B, 0xFA, 0x07, 0x76, 0x01, 0x09, 0xFA, 0x08, 0x70,
  0x5F, 0x90, 0xE0, 0x37, 0x72, 0x06, 0xFA, 0x03, 0x60, 0xDF, 0x90, 0x37, 0x74, 0x05, 0xF9, 0x0C,
  0x50, 0x6F, 0x90, 0x67, 0x76, 0x09, 0xF9, 0x05, 0x40, 0xDF, 0x0C, 0x77, 0x70, 0x10, 0xEF, 0x0B,
  0x30, 0x4F, 0x90, 0x47, 0x77, 0x10, 0x7F, 0x90, 0x32, 0x09, 0xF0, 0xC7, 0x77, 0x30, 0xEF, 0x08,
  0x20, 0xDF, 0x06, 0x77, 0x73, 0x09, 0xF8, 0x1C, 0x02, 0xF9, 0x01, 0x77, 0x73, 0x04, 0xF9, 0x01,
  0x05, 0xF0, 0xC7, 0x77, 0x50, 0xEF, 0x05, 0x08, 0xF0, 0x97, 0x77, 0x50, 0xCF, 0x07, 0x0A, 0xF0,
  0x67, 0x77, 0x50, 0x9F, 0x09, 0x0C, 0xF0, 0x37, 0x77, 0x50, 0x6F, 0x0C, 0x0E, 0xF0, 0x27, 0x77,
  0x50, 0x5F, 0x0D, 0x0E, 0xF0, 0x17, 0x77, 0x50, 0x4F, 0x0E, 0xF9, 0x77, 0x76, 0x03, 0xFF, 0xA7,
  0x77, 0x60, 0x2F, 0xFA, 0x77, 0x76, 0x02, 0xFF, 0xA7, 0x77, 0x60, 0x3F, 0x90, 0xEF, 0x01, 0x77,
  0x75, 0x04, 0xF0, 0xE0, 0xDF, 0x02, 0x77, 0x75, 0x05, 0xF0, 0xD0, 0xCF, 0x04, 0x77, 0x75, 0x07,
  0xF0, 0xC0, 0x9F, 0x07, 0x77, 0x75, 0x09, 0xF0, 0xA0, 0x7F, 0x09, 0x77, 0x75, 0x0C, 0xF0, 0x70,
  0x4F, 0x0C, 0x77, 0x75, 0xF9, 0x05, 0x01, 0xF9, 0x02, 0x77, 0x73, 0x04, 0xF9, 0x81, 0x10, 0xCF,
  0x07, 0x77, 0x73, 0x0A, 0xF0, 0xD2, 0x07, 0xF0, 0xD7, 0x77, 0x30, 0xEF, 0x08, 0x20, 0x2F, 0x90,
  0x57, 0x77, 0x10, 0x7F, 0x90, 0x33, 0x0B, 0xF0, 0xD7, 0x77, 0x01, 0x0E, 0xF0, 0xC4, 0x04, 0xF9,
  0x08, 0x77, 0x60, 0x9F, 0x90, 0x55, 0x0B, 0xF9, 0x04, 0x77, 0x40, 0x5F, 0x90, 0xD6, 0x02, 0xFA,
  0x05, 0x77, 0x20, 0x5F, 0xA0, 0x37, 0x08, 0xFA, 0x09, 0x01, 0x75, 0x01, 0x09, 0xFA, 0x09, 0x72,
  0x0B, 0xFA, 0x81, 0xE8, 0x27, 0x18, 0x12, 0x8E, 0xFA, 0x0C, 0x73, 0x01, 0x0D, 0xFC, 0x86, 0xEB,
  0x98, 0x89, 0xBE, 0xFC, 0x0E, 0x01, 0x74, 0x01, 0x0C, 0xFF, 0xFF, 0x0D, 0x02, 0x77, 0x0B, 0xFF,
  0xFD, 0x0C, 0x01, 0x77, 0x20, 0x60, 0xEF, 0xFF, 0xA0, 0x77, 0x75, 0x01, 0x09, 0xFF, 0xE0, 0xA0,
  0x27, 0x77, 0x18, 0x11, 0x7C, 0xFF, 0x81, 0xD8, 0x27, 0x77, 0x68, 0x41, 0x58, 0xBD, 0xEA, 0x84,
  0xED, 0xB9, 0x62, 0x77, 0x10,
  // "õ" (U+00F5)
  0x76, 0x84, 0x46, 0x87, 0x51, 0x77, 0x84, 0x38, 0x88, 0x81, 0x77, 0x20, 0x80, 0xEE, 0x0B, 0x03,
  0x75, 0x09, 0xC7, 0x71, 0x02, 0x0D, 0xFB, 0x0A, 0x01, 0x73, 0x0E, 0xB0, 0xD7, 0x70, 0x10, 0xDF,
  0xD0, 0xE0, 0x77, 0x10, 0x8C, 0x09, 0x77, 0x0B, 0xFF, 0x90, 0xD0, 0x65, 0x06, 0xD0, 0x57, 0x60,
  0x5F, 0xFC, 0x83, 0xEA, 0x89, 0xDD, 0x0E, 0x77, 0x0C, 0xFF, 0xFF, 0x08, 0x76, 0x03, 0xD8, 0x5D,
  0x51, 0x01, 0x5C, 0xFF, 0xA0, 0xE0, 0x17, 0x60, 0x8C, 0x0D, 0x01, 0x60, 0x50, 0xDF, 0xF0, 0x57,
  0x70, 0xCC, 0x04, 0x72, 0x07, 0xFD, 0x07, 0x77, 0x10, 0xEB, 0x0D, 0x74, 0x02, 0x0A, 0xF9, 0x0E,
  0x06, 0x77, 0x10, 0x1C, 0x08, 0x76, 0x87, 0x28, 0xCE, 0xFD, 0xB6, 0x18, 0x0B, 0xE2, 0x08, 0x94,
  0x36, 0x9C, 0xDE, 0xFE, 0xED, 0xB8, 0x51, 0x77, 0x76, 0x81, 0x28, 0xDF, 0xF8, 0x1C, 0x71, 0x77,
  0x71, 0x03, 0x0A, 0xFF, 0xD8, 0x1E, 0x81, 0x77, 0x50, 0x8F, 0xFF, 0xA0, 0xE0, 0x57, 0x72, 0x02,
  0x0D, 0xFF, 0xFD, 0x0B, 0x77, 0x03, 0x0E, 0xFF, 0xFF, 0x0C, 0x01, 0x74, 0x02, 0x0E, 0xFC, 0x86,
  0xDB, 0x98, 0x89, 0xBE, 0xFC, 0x0D, 0x01, 0x72, 0x01, 0x0D, 0xFA, 0x81, 0xD7, 0x27, 0x18, 0x13,
  0x8E, 0xFA, 0x0B, 0x72, 0x0B, 0xFA, 0x07, 0x76, 0x01, 0x09, 0xFA, 0x08, 0x70, 0x5F, 0x90, 0xE0,
  0x37, 0x72, 0x06, 0xFA, 0x03, 0x60, 0xDF, 0x90, 0x37, 0x74, 0x05, 0xF9, 0x0C, 0x50, 0x6F, 0x90,
  0x67, 0x76, 0x09, 0xF9, 0x05, 0x40, 0xDF, 0x0C, 0x77, 0x70, 0x10, 0xEF, 0x0B, 0x30, 0x4F, 0x90,
  0x47, 0x77, 0x10, 0x7F, 0x90, 0x32, 0x09, 0xF0, 0xC7, 0x77, 0x30, 0xEF, 0x08, 0x20, 0xDF, 0x06,
  0x77, 0x73, 0x09, 0xF8, 0x1C, 0x02, 0xF9, 0x01, 0x77, 0x73, 0x04, 0xF9, 0x01, 0x05, 0xF0, 0xC7,
  0x77, 0x50, 0xEF, 0x05, 0x08, 0xF0, 0x97, 0x77, 0x50, 0xCF, 0x07, 0x0A, 0xF0, 0x67, 0x77, 0x50,
  0x9F, 0x09, 0x0C, 0xF0, 0x37, 0x77, 0x50, 0x6F, 0x0C, 0x0E, 0xF0, 0x27, 0x77, 0x50, 0x5F, 0x0D,
  0x0E, 0xF0, 0x17, 0x77, 0x50, 0x4F, 0x0E, 0xF9, 0x77, 0x76, 0x03, 0xFF, 0xA7, 0x77, 0x60, 0x2F,
  0xFA, 0x77, 0x76, 0x02, 0xFF, 0xA7, 0x77, 0x60, 0x3F, 0x90, 0xEF, 0x01, 0x77, 0x75, 0x04, 0xF0,
  0xE0, 0xDF, 0x02, 0x77, 0x75, 0x05, 0xF0, 0xD0, 0xCF, 0x04, 0x77, 0x75, 0x07, 0xF0, 0xC0, 0x9F,
  0x07, 0x77, 0x75, 0x09, 0xF0, 0xA0, 0x7F, 0x09, 0x77, 0x75, 0x0C, 0xF0, 0x70, 0x4F, 0x0C, 0x77,
  0x75, 0xF9, 0x05, 0x01, 0xF9, 0x02, 0x77, 0x73, 0x04, 0xF9, 0x81, 0x10, 0xCF, 0x07, 0x77, 0x73,
  0x0A, 0xF0, 0xD2, 0x07, 0xF0, 0xD7, 0x77, 0x30, 0xEF, 0x08, 0x20, 0x2F, 0x90, 0x57, 0x77, 0x10,
  0x7F, 0x90, 0x33, 0x0B, 0xF0, 0xD7, 0x77, 0x01, 0x0E, 0xF0, 0xC4, 0x04, 0xF9, 0x08, 0x77, 0x60,
  0x9F, 0x90, 0x55, 0x0B, 0xF9, 0x04, 0x77, 0x40, 0x5F, 0x90, 0xD6, 0x02, 0xFA, 0x05, 0x77, 0x20,
  0x5F, 0xA0, 0x37, 0x08, 0xFA, 0x09, 0x01, 0x75, 0x01, 0x09, 0xFA, 0x09, 0x72, 0x0B, 0xFA, 0x81,
  0xE8, 0x27, 0x18, 0x12, 0x8E, 0xFA, 0x0C, 0x73, 0x01, 0x0D, 0xFC, 0x86, 0xEB, 0x98, 0x89, 0xBE,
  0xFC, 0x0E, 0x01, 0x74, 0x01, 0x0C, 0xFF, 0xFF, 0x0D, 0x02, 0x77, 0x0B, 0xFF, 0xFD, 0x0C, 0x01,
  0x77, 0x20, 0x60, 0xEF, 0xFF, 0xA0, 0x77, 0x75, 0x01, 0x09, 0xFF, 0xE0, 0xA0, 0x27, 0x77, 0x18,
  0x11, 0x7C, 0xFF, 0x81, 0xD8, 0x27, 0x77, 0x68, 0x41, 0x58, 0xBD, 0xEA, 0x84, 0xED, 0xB9, 0x62,
  0x77, 0x10,
  // "ö" (U+00F6)
  0x71, 0x85, 0x18, 0xDF, 0xEB, 0x47, 0x78, 0x53, 0xAE, 0xFD, 0x91, 0x77, 0x10, 0x20, 0xDE, 0x08,
  0x75, 0x06, 0xE0, 0xE0, 0x37, 0x70, 0xAF, 0x90, 0x37, 0x30, 0x1F, 0x90, 0xC7, 0x70, 0xEF, 0x90,
  0x87, 0x30, 0x5F, 0xA0, 0x27, 0x50, 0x1F, 0xA0, 0xA7, 0x30, 0x7F, 0xA0, 0x47, 0x50, 0x1F, 0xA0,
  0x97, 0x30, 0x7F, 0xA0, 0x37, 0x60, 0xEF, 0x90, 0x77, 0x30, 0x5F, 0xA0, 0x17, 0x60, 0x9F, 0x90,
  0x27, 0x40, 0xEF, 0x0B, 0x77, 0x01, 0x0C, 0xE0, 0x67, 0x50, 0x4E, 0x0D, 0x02, 0x77, 0x28, 0x47,
  0xDF, 0xEA, 0x37, 0x78, 0x52, 0xAE, 0xFD, 0x81, 0x80, 0xD8, 0x70, 0x89, 0x43, 0x69, 0xCD, 0xEF,
  0xEE, 0xDB, 0x85, 0x17, 0x77, 0x68, 0x12, 0x8D, 0xFF, 0x81, 0xC7, 0x17, 0x77, 0x10, 0x30, 0xAF,
  0xFD, 0x81, 0xE8, 0x17, 0x75, 0x08, 0xFF, 0xFA, 0x0E, 0x05, 0x77, 0x20, 0x20, 0xDF, 0xFF, 0xD0,
  0xB7, 0x70, 0x30, 0xEF, 0xFF, 0xF0, 0xC0, 0x17, 0x40, 0x20, 0xEF, 0xC8, 0x6D, 0xB9, 0x88, 0x9B,
  0xEF, 0xC0, 0xD0, 0x17, 0x20, 0x10, 0xDF, 0xA8, 0x1D, 0x72, 0x71, 0x81, 0x38, 0xEF, 0xA0, 0xB7,
  0x20, 0xBF, 0xA0, 0x77, 0x60, 0x10, 0x9F, 0xA0, 0x87, 0x05, 0xF9, 0x0E, 0x03, 0x77, 0x20, 0x6F,
  0xA0, 0x36, 0x0D, 0xF9, 0x03, 0x77, 0x40, 0x5F, 0x90, 0xC5, 0x06, 0xF9, 0x06, 0x77, 0x60, 0x9F,
  0x90, 0x54, 0x0D, 0xF0, 0xC7, 0x77, 0x01, 0x0E, 0xF0, 0xB3, 0x04, 0xF9, 0x04, 0x77, 0x71, 0x07,
  0xF9, 0x03, 0x20, 0x9F, 0x0C, 0x77, 0x73, 0x0E, 0xF0, 0x82, 0x0D, 0xF0, 0x67, 0x77, 0x30, 0x9F,
  0x81, 0xC0, 0x2F, 0x90, 0x17, 0x77, 0x30, 0x4F, 0x90, 0x10, 0x5F, 0x0C, 0x77, 0x75, 0x0E, 0xF0,
  0x50, 0x8F, 0x09, 0x77, 0x75, 0x0C, 0xF0, 0x70, 0xAF, 0x06, 0x77, 0x75, 0x09, 0xF0, 0x90, 0xCF,
  0x03, 0x77, 0x75, 0x06, 0xF0, 0xC0, 0xEF, 0x02, 0x77, 0x75, 0x05, 0xF0, 0xD0, 0xEF, 0x01, 0x77,
  0x75, 0x04, 0xF0, 0xEF, 0x97, 0x77, 0x60, 0x3F, 0xFA, 0x77, 0x76, 0x02, 0xFF, 0xA7, 0x77, 0x60,
  0x2F, 0xFA, 0x77, 0x76, 0x03, 0xF9, 0x0E, 0xF0, 0x17, 0x77, 0x50, 0x4F, 0x0E, 0x0D, 0xF0, 0x27,
  0x77, 0x50, 0x5F, 0x0D, 0x0C, 0xF0, 0x47, 0x77, 0x50, 0x7F, 0x0C, 0x09, 0xF0, 0x77, 0x77, 0x50,
  0x9F, 0x0A, 0x07, 0xF0, 0x97, 0x77, 0x50, 0xCF, 0x07, 0x04, 0xF0, 0xC7, 0x77, 0x5F, 0x90, 0x50,
  0x1F, 0x90, 0x27, 0x77, 0x30, 0x4F, 0x98, 0x11, 0x0C, 0xF0, 0x77, 0x77, 0x30, 0xAF, 0x0D, 0x20,
  0x7F, 0x0D, 0x77, 0x73, 0x0E, 0xF0, 0x82, 0x02, 0xF9, 0x05, 0x77, 0x71, 0x07, 0xF9, 0x03, 0x30,
  0xBF, 0x0D, 0x77, 0x70, 0x10, 0xEF, 0x0C, 0x40, 0x4F, 0x90, 0x87, 0x76, 0x09, 0xF9, 0x05, 0x50,
  0xBF, 0x90, 0x47, 0x74, 0x05, 0xF9, 0x0D, 0x60, 0x2F, 0xA0, 0x57, 0x72, 0x05, 0xFA, 0x03, 0x70,
  0x8F, 0xA0, 0x90, 0x17, 0x50, 0x10, 0x9F, 0xA0, 0x97, 0x20, 0xBF, 0xA8, 0x1E, 0x82, 0x71, 0x81,
  0x28, 0xEF, 0xA0, 0xC7, 0x30, 0x10, 0xDF, 0xC8, 0x6E, 0xB9, 0x88, 0x9B, 0xEF, 0xC0, 0xE0, 0x17,
  0x40, 0x10, 0xCF, 0xFF, 0xF0, 0xD0, 0x27, 0x70, 0xBF, 0xFF, 0xD0, 0xC0, 0x17, 0x72, 0x06, 0x0E,
  0xFF, 0xFA, 0x07, 0x77, 0x50, 0x10, 0x9F, 0xFE, 0x0A, 0x02, 0x77, 0x71, 0x81, 0x17, 0xCF, 0xF8,
  0x1D, 0x82, 0x77, 0x76, 0x84, 0x15, 0x8B, 0xDE, 0xA8, 0x4E, 0xDB, 0x96, 0x27, 0x71,
  // "÷" (U+00F7)
  0x77, 0x38, 0x47, 0xCF, 0xEC, 0x67, 0x77, 0x74, 0x01, 0x0D, 0xE0, 0xA7, 0x77, 0x73, 0x09, 0xF9,
  0x05, 0x77, 0x77, 0x20, 0xEF, 0x90, 0xA7, 0x77, 0x71, 0x01, 0xFA, 0x0C, 0x77, 0x77, 0x10, 0x1F,
  0xA0, 0xD7, 0x77, 0x72, 0xFA, 0x0C, 0x77, 0x77, 0x20, 0xDF, 0x90, 0x97, 0x77, 0x72, 0x07, 0xF9,
  0x03, 0x77, 0x77, 0x30, 0xBE, 0x08, 0x77, 0x77, 0x58, 0x46, 0xCF, 0xEB, 0x58, 0x0C, 0xC5, 0x00,
  0xC8, 0x0C, 0x2F, 0x00, 0xC8, 0x0C, 0x2F, 0x00, 0xC8, 0x0C, 0x2F, 0x00, 0xC8, 0x0C, 0x2F, 0x00,
  0xC8, 0x0C, 0x2F, 0x00, 0xC8, 0x0C, 0x2F, 0x0C, 0x06, 0x80, 0xC2, 0x80, 0x68, 0x0B, 0xF5, 0x08,
  0x47, 0xCF, 0xEC, 0x67, 0x77, 0x74, 0x01, 0x0D, 0xE0, 0xA7, 0x77, 0x73, 0x09, 0xF9, 0x05, 0x77,
  0x77, 0x20, 0xEF, 0x90, 0xA7, 0x77, 0x71, 0x01, 0xFA, 0x0C, 0x77, 0x77, 0x10, 0x1F, 0xA0, 0xD7,
  0x77, 0x72, 0xFA, 0x0C, 0x77, 0x77, 0x20, 0xDF, 0x90, 0x97, 0x77, 0x72, 0x07, 0xF9, 0x03, 0x77,
  0x77, 0x30, 0xBE, 0x08, 0x77, 0x77, 0x58, 0x46, 0xCF, 0xEB, 0x57, 0x73,
  // "ø" (U+00F8)
  0x80, 0xC1, 0x00, 0x60, 0x38, 0x0C, 0x50, 0x04, 0xA0, 0x87, 0x75, 0x89, 0x43, 0x69, 0xCD, 0xEF,
  0xED, 0xCB, 0x85, 0x26, 0x01, 0x0D, 0xB0, 0xD0, 0x47, 0x78, 0x12, 0x8D, 0xFF, 0x81, 0xC7, 0x13,
  0x0A, 0xE0, 0x87, 0x40, 0x30, 0xAF, 0xFE, 0x81, 0x81, 0x6F, 0x06, 0x73, 0x08, 0xFF, 0xFA, 0x00,
  0xEE, 0x0A, 0x72, 0x02, 0x0D, 0xFF, 0xFF, 0xB0, 0xD0, 0x17, 0x10, 0x30, 0xEF, 0xFF, 0xFC, 0x04,
  0x71, 0x02, 0x0E, 0xFC, 0x85, 0xDB, 0x98, 0x9A, 0xCF, 0xF0, 0x87, 0x10, 0x10, 0xDF, 0xA8, 0x1D,
  0x72, 0x71, 0x04, 0x0A, 0xFB, 0x0E, 0x72, 0x0A, 0xFA, 0x07, 0x76, 0x02, 0x0C, 0xFA, 0x07, 0x70,
  0x5F, 0x90, 0xE0, 0x37, 0x71, 0x06, 0xFB, 0x02, 0x60, 0xDF, 0x90, 0x37, 0x71, 0x02, 0x0E, 0xFB,
  0x0B, 0x50, 0x6F, 0x90, 0x67, 0x72, 0x0C, 0xFD, 0x04, 0x40, 0xDF, 0x0C, 0x77, 0x20, 0x8F, 0xE0,
  0xB3, 0x04, 0xF9, 0x04, 0x77, 0x10, 0x3F, 0xF9, 0x01, 0x20, 0x9F, 0x0C, 0x77, 0x10, 0x10, 0xDE,
  0x0C, 0x0E, 0xF0, 0x72, 0x0D, 0xF0, 0x67, 0x71, 0x0A, 0xE8, 0x1E, 0x29, 0xF8, 0x1C, 0x02, 0xF9,
  0x01, 0x77, 0x05, 0xF8, 0x15, 0x03, 0xF9, 0x01, 0x05, 0xF0, 0xC7, 0x70, 0x20, 0xEE, 0x0A, 0x3F,
  0x90, 0x40, 0x8F, 0x09, 0x77, 0x0C, 0xE0, 0xD0, 0x13, 0x0B, 0xF0, 0x70, 0xAF, 0x06, 0x76, 0x08,
  0xF0, 0x34, 0x08, 0xF0, 0xA0, 0xCF, 0x03, 0x75, 0x03, 0xF0, 0x75, 0x06, 0xF0, 0xB0, 0xEF, 0x02,
  0x74, 0x01, 0x0D, 0xE0, 0xC6, 0x04, 0xF0, 0xD0, 0xEF, 0x01, 0x74, 0x0A, 0xE0, 0xE0, 0x26, 0x03,
  0xF0, 0xEF, 0x97, 0x40, 0x5F, 0x05, 0x70, 0x3F, 0xFA, 0x73, 0x02, 0x0E, 0xE0, 0x97, 0x10, 0x2F,
  0xFA, 0x73, 0x0C, 0xE0, 0xD7, 0x20, 0x2F, 0xFA, 0x72, 0x08, 0xF0, 0x37, 0x20, 0x3F, 0x90, 0xEF,
  0x71, 0x03, 0xF0, 0x77, 0x30, 0x4F, 0x0E, 0x0D, 0xF0, 0x26, 0x01, 0x0D, 0xE0, 0xB7, 0x40, 0x5F,
  0x0D, 0x0C, 0xF0, 0x46, 0x0A, 0xE0, 0xE0, 0x17, 0x40, 0x6F, 0x0C, 0x0A, 0xF0, 0x65, 0x05, 0xF0,
  0x57, 0x50, 0x9F, 0x0A, 0x07, 0xF0, 0x94, 0x02, 0x0E, 0xE0, 0x97, 0x60, 0xCF, 0x08, 0x04, 0xF0,
  0xD4, 0x0C, 0xE0, 0xD7, 0x7F, 0x90, 0x50, 0x1F, 0x90, 0x12, 0x08, 0xF0, 0x37, 0x60, 0x4F, 0x98,
  0x12, 0x0C, 0xF8, 0x16, 0x03, 0xF0, 0x77, 0x70, 0x9F, 0x0D, 0x20, 0x8F, 0x81, 0xD1, 0xDE, 0x0B,
  0x77, 0x10, 0xEF, 0x09, 0x20, 0x2F, 0x90, 0xCE, 0x0E, 0x01, 0x77, 0x07, 0xF9, 0x03, 0x30, 0xBF,
  0xF0, 0x57, 0x70, 0x10, 0xEF, 0x0C, 0x40, 0x4F, 0xE0, 0x97, 0x71, 0x09, 0xF9, 0x06, 0x50, 0xCF,
  0xC0, 0xD7, 0x71, 0x05, 0xF9, 0x0D, 0x60, 0x3F, 0xC0, 0x37, 0x70, 0x5F, 0xA0, 0x47, 0x08, 0xFA,
  0x0C, 0x01, 0x75, 0x01, 0x09, 0xFA, 0x0A, 0x72, 0x0B, 0xFA, 0x81, 0xE9, 0x37, 0x18, 0x12, 0x8E,
  0xFA, 0x0C, 0x73, 0x0B, 0xFD, 0x86, 0xEB, 0x98, 0x89, 0xBE, 0xFC, 0x0E, 0x02, 0x72, 0x06, 0xFF,
  0xFF, 0xB0, 0xD0, 0x27, 0x20, 0x2F, 0xFF, 0xFB, 0x0C, 0x01, 0x73, 0x0C, 0xFF, 0xFF, 0xA0, 0x77,
  0x40, 0x9F, 0x81, 0x48, 0xEF, 0xFD, 0x0A, 0x02, 0x74, 0x01, 0xF0, 0x62, 0x81, 0x17, 0xCF, 0xF8,
  0x1D, 0x82, 0x77, 0x02, 0x0C, 0xC0, 0xB6, 0x84, 0x25, 0x8B, 0xDE, 0xA8, 0x4E, 0xDB, 0x96, 0x27,
  0x75, 0x07, 0xA0, 0xE0, 0x18, 0x0C, 0x40, 0x81, 0x2C, 0x48, 0x0C, 0x00,
  // "ù" (U+00F9)
  0x72, 0x80, 0x57, 0x04, 0x77, 0x77, 0x30, 0xEF, 0x90, 0xE7, 0x77, 0x73, 0x04, 0xFA, 0x07, 0x77,
  0x77, 0x30, 0x8F, 0x90, 0xE0, 0x17, 0x77, 0x73, 0x0B, 0xF9, 0x0A, 0x77, 0x77, 0x40, 0xCF, 0x90,
  0x47, 0x77, 0x73, 0x01, 0x0D, 0xF0, 0xD7, 0x77, 0x74, 0x02, 0x0E, 0xF0, 0x87, 0x77, 0x74, 0x03,
  0x0E, 0xF0, 0x37, 0x77, 0x74, 0x03, 0x0E, 0xE0, 0xC7, 0x77, 0x75, 0x03, 0x0E, 0xE0, 0x87, 0x77,
  0x75, 0x03, 0x0E, 0xE0, 0x47, 0x77, 0x75, 0x03, 0x0E, 0xD0, 0xE0, 0x17, 0x77, 0x75, 0x02, 0x0D,
  0xD0, 0xB7, 0x77, 0x76, 0x01, 0x0B, 0xD0, 0x18, 0x0B, 0xF7, 0x00, 0x3F, 0x0D, 0x77, 0x72, 0x04,
  0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0,
  0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D,
  0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72,
  0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0,
  0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F,
  0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77,
  0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04,
  0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0,
  0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D,
  0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72,
  0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x05, 0xF0,
  0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x05, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x06, 0xF0, 0xC0, 0x3F,
  0x0D, 0x77, 0x72, 0x07, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x09, 0xF0, 0xC0, 0x3F, 0x0D, 0x77,
  0x72, 0x0B, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x0E, 0xF0, 0xC0, 0x3F, 0x0E, 0x77, 0x71, 0x01,
  0xF9, 0x0C, 0x03, 0xF9, 0x77, 0x71, 0x06, 0xF9, 0x0C, 0x02, 0xF9, 0x02, 0x77, 0x70, 0xBF, 0x90,
  0xC1, 0xF9, 0x05, 0x77, 0x60, 0x1F, 0xA8, 0x1C, 0x0E, 0xF0, 0xA7, 0x76, 0x08, 0xFA, 0x81, 0xC0,
  0xBF, 0x90, 0x17, 0x74, 0x01, 0x0E, 0xFA, 0x81, 0xC0, 0x7F, 0x90, 0x97, 0x74, 0x0A, 0xFB, 0x81,
  0xC0, 0x2F, 0xA0, 0x47, 0x72, 0x09, 0xFC, 0x0C, 0x20, 0xCF, 0xA0, 0x57, 0x60, 0x10, 0xBF, 0xD0,
  0xC2, 0x05, 0xFB, 0x0C, 0x04, 0x72, 0x03, 0x09, 0xE0, 0xD0, 0xEE, 0x0C, 0x30, 0xCF, 0xD8, 0x6C,
  0xA9, 0x89, 0xAC, 0xEF, 0x81, 0xE2, 0xAE, 0x0C, 0x30, 0x3F, 0xFF, 0xE8, 0x15, 0x07, 0xE0, 0xC4,
  0x05, 0xFF, 0xFC, 0x06, 0x20, 0x5E, 0x0C, 0x50, 0x5F, 0xFF, 0x90, 0xE0, 0x53, 0x02, 0xE0, 0xC6,
  0x02, 0x0C, 0xFF, 0xD0, 0xB0, 0x25, 0x0E, 0xD0, 0xC7, 0x10, 0x40, 0xBF, 0xF8, 0x1E, 0xA4, 0x70,
  0xCD, 0x0C, 0x73, 0x84, 0x15, 0x8B, 0xDE, 0xA8, 0x4E, 0xEC, 0xA8, 0x47, 0x73,
  // "ú" (U+00FA)
  0x77, 0x74, 0x03, 0x80, 0x57, 0x01, 0x77, 0x77, 0x20, 0xCF, 0xA0, 0x27, 0x77, 0x71, 0x05, 0xFA,
  0x08, 0x77, 0x77, 0x20, 0xDF, 0x90, 0xB7, 0x77, 0x72, 0x08, 0xF9, 0x0D, 0x01, 0x77, 0x77, 0x10,
  0x2F, 0x90, 0xE0, 0x27, 0x77, 0x72, 0x0C, 0xF0, 0xE0, 0x37, 0x77, 0x72, 0x06, 0xF9, 0x04, 0x77,
  0x77, 0x20, 0x10, 0xEF, 0x05, 0x77, 0x77, 0x30, 0xBF, 0x05, 0x77, 0x77, 0x30, 0x5F, 0x06, 0x77,
  0x77, 0x30, 0x10, 0xEE, 0x05, 0x77, 0x77, 0x40, 0xBE, 0x05, 0x77, 0x77, 0x40, 0x8D, 0x0E, 0x04,
  0x77, 0x77, 0x50, 0xDC, 0x0C, 0x02, 0x80, 0xC8, 0x30, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C,
  0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0,
  0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77,
  0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F,
  0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03,
  0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7,
  0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20,
  0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C,
  0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0,
  0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77,
  0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F,
  0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x5F, 0x0C, 0x03,
  0xF0, 0xD7, 0x77, 0x20, 0x5F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x6F, 0x0C, 0x03, 0xF0, 0xD7,
  0x77, 0x20, 0x7F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x9F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20,
  0xBF, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0xEF, 0x0C, 0x03, 0xF0, 0xE7, 0x77, 0x10, 0x1F, 0x90,
  0xC0, 0x3F, 0x97, 0x77, 0x10, 0x6F, 0x90, 0xC0, 0x2F, 0x90, 0x27, 0x77, 0x0B, 0xF9, 0x0C, 0x1F,
  0x90, 0x57, 0x76, 0x01, 0xFA, 0x81, 0xC0, 0xEF, 0x0A, 0x77, 0x60, 0x8F, 0xA8, 0x1C, 0x0B, 0xF9,
  0x01, 0x77, 0x40, 0x10, 0xEF, 0xA8, 0x1C, 0x07, 0xF9, 0x09, 0x77, 0x40, 0xAF, 0xB8, 0x1C, 0x02,
  0xFA, 0x04, 0x77, 0x20, 0x9F, 0xC0, 0xC2, 0x0C, 0xFA, 0x05, 0x76, 0x01, 0x0B, 0xFD, 0x0C, 0x20,
  0x5F, 0xB0, 0xC0, 0x47, 0x20, 0x30, 0x9E, 0x0D, 0x0E, 0xE0, 0xC3, 0x0C, 0xFD, 0x86, 0xCA, 0x98,
  0x9A, 0xCE, 0xF8, 0x1E, 0x2A, 0xE0, 0xC3, 0x03, 0xFF, 0xFE, 0x81, 0x50, 0x7E, 0x0C, 0x40, 0x5F,
  0xFF, 0xC0, 0x62, 0x05, 0xE0, 0xC5, 0x05, 0xFF, 0xF9, 0x0E, 0x05, 0x30, 0x2E, 0x0C, 0x60, 0x20,
  0xCF, 0xFD, 0x0B, 0x02, 0x50, 0xED, 0x0C, 0x71, 0x04, 0x0B, 0xFF, 0x81, 0xEA, 0x47, 0x0C, 0xD0,
  0xC7, 0x38, 0x41, 0x58, 0xBD, 0xEA, 0x84, 0xEE, 0xCA, 0x84, 0x77, 0x30,
  // "û" (U+00FB)
  0x77, 0x20, 0x28, 0x04, 0x77, 0x77, 0x74, 0x0C, 0xF9, 0x08, 0x77, 0x77, 0x20, 0x6F, 0xB0, 0x37,
  0x77, 0x70, 0x3F, 0xC0, 0xD0, 0x17, 0x77, 0x60, 0xDF, 0xD0, 0xA7, 0x77, 0x50, 0xBF, 0xF0, 0x77,
  0x77, 0x30, 0x8F, 0x0A, 0x0D, 0xF0, 0x57, 0x77, 0x10, 0x6F, 0x82, 0x90, 0x1D, 0xF0, 0x37, 0x76,
  0x04, 0xF0, 0x93, 0x01, 0x0D, 0xE0, 0xE0, 0x27, 0x74, 0x02, 0x0E, 0xE0, 0x95, 0x01, 0x0C, 0xE0,
  0xD0, 0x17, 0x72, 0x01, 0x0D, 0xE0, 0x87, 0x01, 0x0C, 0xE0, 0xC7, 0x72, 0x0C, 0xE0, 0x87, 0x20,
  0x10, 0xBE, 0x0B, 0x77, 0x0B, 0xE0, 0x67, 0x50, 0xAE, 0x0A, 0x75, 0x0A, 0xD0, 0xE0, 0x47, 0x70,
  0x7E, 0x0A, 0x73, 0x03, 0xD0, 0xB0, 0x17, 0x72, 0x03, 0x0D, 0xD0, 0x38, 0x0B, 0xE6, 0x00, 0x3F,
  0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77,
  0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04,
  0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0,
  0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D,
  0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72,
  0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0,
  0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F,
  0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77,
  0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04,
  0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0,
  0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D,
  0x77, 0x72, 0x05, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x05, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72,
  0x06, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x07, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x09, 0xF0,
  0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x0B, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x0E, 0xF0, 0xC0, 0x3F,
  0x0E, 0x77, 0x71, 0x01, 0xF9, 0x0C, 0x03, 0xF9, 0x77, 0x71, 0x06, 0xF9, 0x0C, 0x02, 0xF9, 0x02,
  0x77, 0x70, 0xBF, 0x90, 0xC1, 0xF9, 0x05, 0x77, 0x60, 0x1F, 0xA8, 0x1C, 0x0E, 0xF0, 0xA7, 0x76,
  0x08, 0xFA, 0x81, 0xC0, 0xBF, 0x90, 0x17, 0x74, 0x01, 0x0E, 0xFA, 0x81, 0xC0, 0x7F, 0x90, 0x97,
  0x74, 0x0A, 0xFB, 0x81, 0xC0, 0x2F, 0xA0, 0x47, 0x72, 0x09, 0xFC, 0x0C, 0x20, 0xCF, 0xA0, 0x57,
  0x60, 0x10, 0xBF, 0xD0, 0xC2, 0x05, 0xFB, 0x0C, 0x04, 0x72, 0x03, 0x09, 0xE0, 0xD0, 0xEE, 0x0C,
  0x30, 0xCF, 0xD8, 0x6C, 0xA9, 0x89, 0xAC, 0xEF, 0x81, 0xE2, 0xAE, 0x0C, 0x30, 0x3F, 0xFF, 0xE8,
  0x15, 0x07, 0xE0, 0xC4, 0x05, 0xFF, 0xFC, 0x06, 0x20, 0x5E, 0x0C, 0x50, 0x5F, 0xFF, 0x90, 0xE0,
  0x53, 0x02, 0xE0, 0xC6, 0x02, 0x0C, 0xFF, 0xD0, 0xB0, 0x25, 0x0E, 0xD0, 0xC7, 0x10, 0x40, 0xBF,
  0xF8, 0x1E, 0xA4, 0x70, 0xCD, 0x0C, 0x73, 0x84, 0x15, 0x8B, 0xDE, 0xA8, 0x4E, 0xEC, 0xA8, 0x47,
  0x73,
  // "ü" (U+00FC)
  0x78, 0x51, 0x8D, 0xFE, 0xB4, 0x77, 0x85, 0x3A, 0xEF, 0xD9, 0x17, 0x50, 0x20, 0xDE, 0x08, 0x75,
  0x06, 0xE0, 0xE0, 0x37, 0x40, 0xAF, 0x90, 0x37, 0x30, 0x1F, 0x90, 0xC7, 0x40, 0xEF, 0x90, 0x87,
  0x30, 0x5F, 0xA0, 0x27, 0x20, 0x1F, 0xA0, 0xA7, 0x30, 0x7F, 0xA0, 0x47, 0x20, 0x1F, 0xA0, 0x97,
  0x30, 0x7F, 0xA0, 0x37, 0x30, 0xEF, 0x90, 0x77, 0x30, 0x5F, 0xA0, 0x17, 0x30, 0x9F, 0x90, 0x27,
  0x40, 0xEF, 0x0B, 0x74, 0x01, 0x0C, 0xE0, 0x67, 0x50, 0x4E, 0x0D, 0x02, 0x76, 0x84, 0x7D, 0xFE,
  0xA3, 0x77, 0x85, 0x2A, 0xEF, 0xD8, 0x18, 0x0D, 0x92, 0x00, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0,
  0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F,
  0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77,
  0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04,
  0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0,
  0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D,
  0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72,
  0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0,
  0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F,
  0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77,
  0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04,
  0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x05, 0xF0, 0xC0,
  0x3F, 0x0D, 0x77, 0x72, 0x05, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x06, 0xF0, 0xC0, 0x3F, 0x0D,
  0x77, 0x72, 0x07, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x09, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72,
  0x0B, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x0E, 0xF0, 0xC0, 0x3F, 0x0E, 0x77, 0x71, 0x01, 0xF9,
  0x0C, 0x03, 0xF9, 0x77, 0x71, 0x06, 0xF9, 0x0C, 0x02, 0xF9, 0x02, 0x77, 0x70, 0xBF, 0x90, 0xC1,
  0xF9, 0x05, 0x77, 0x60, 0x1F, 0xA8, 0x1C, 0x0E, 0xF0, 0xA7, 0x76, 0x08, 0xFA, 0x81, 0xC0, 0xBF,
  0x90, 0x17, 0x74, 0x01, 0x0E, 0xFA, 0x81, 0xC0, 0x7F, 0x90, 0x97, 0x74, 0x0A, 0xFB, 0x81, 0xC0,
  0x2F, 0xA0, 0x47, 0x72, 0x09, 0xFC, 0x0C, 0x20, 0xCF, 0xA0, 0x57, 0x60, 0x10, 0xBF, 0xD0, 0xC2,
  0x05, 0xFB, 0x0C, 0x04, 0x72, 0x03, 0x09, 0xE0, 0xD0, 0xEE, 0x0C, 0x30, 0xCF, 0xD8, 0x6C, 0xA9,
  0x89, 0xAC, 0xEF, 0x81, 0xE2, 0xAE, 0x0C, 0x30, 0x3F, 0xFF, 0xE8, 0x15, 0x07, 0xE0, 0xC4, 0x05,
  0xFF, 0xFC, 0x06, 0x20, 0x5E, 0x0C, 0x50, 0x5F, 0xFF, 0x90, 0xE0, 0x53, 0x02, 0xE0, 0xC6, 0x02,
  0x0C, 0xFF, 0xD0, 0xB0, 0x25, 0x0E, 0xD0, 0xC7, 0x10, 0x40, 0xBF, 0xF8, 0x1E, 0xA4, 0x70, 0xCD,
  0x0C, 0x73, 0x84, 0x15, 0x8B, 0xDE, 0xA8, 0x4E, 0xEC, 0xA8, 0x47, 0x73,
  // "ý" (U+00FD)
  0x77, 0x76, 0x03, 0x80, 0x57, 0x01, 0x77, 0x77, 0x70, 0xCF, 0xA0, 0x27, 0x77, 0x76, 0x05, 0xFA,
  0x08, 0x77, 0x77, 0x70, 0xDF, 0x90, 0xB7, 0x77, 0x77, 0x08, 0xF9, 0x0D, 0x01, 0x77, 0x77, 0x60,
  0x2F, 0x90, 0xE0, 0x27, 0x77, 0x77, 0x0C, 0xF0, 0xE0, 0x37, 0x77, 0x77, 0x06, 0xF9, 0x04, 0x77,
  0x77, 0x70, 0x10, 0xEF, 0x05, 0x80, 0xC0, 0x00, 0xBF, 0x05, 0x80, 0xC0, 0x00, 0x5F, 0x06, 0x80,
  0xC0, 0x00, 0x10, 0xEE, 0x05, 0x80, 0xC1, 0x00, 0xBE, 0x05, 0x80, 0xC1, 0x00, 0x8D, 0x0E, 0x04,
  0x80, 0xC2, 0x00, 0xDC, 0x0C, 0x02, 0x80, 0xCC, 0x40, 0x0B, 0xF0, 0x27, 0x77, 0x70, 0x9F, 0x0A,
  0x05, 0xF0, 0x97, 0x77, 0x70, 0xEF, 0x81, 0x40, 0xDE, 0x0E, 0x77, 0x76, 0x04, 0xF0, 0xE2, 0x07,
  0xF0, 0x67, 0x77, 0x50, 0x9F, 0x08, 0x20, 0x1F, 0x0C, 0x77, 0x75, 0x0E, 0xF0, 0x23, 0x0A, 0xF0,
  0x37, 0x77, 0x30, 0x4F, 0x0C, 0x40, 0x3F, 0x09, 0x77, 0x73, 0x09, 0xF0, 0x65, 0x0C, 0xE0, 0xE7,
  0x77, 0x30, 0xEF, 0x01, 0x50, 0x6F, 0x06, 0x77, 0x71, 0x04, 0xF0, 0xA7, 0x0E, 0xE0, 0xC7, 0x77,
  0x10, 0x9F, 0x04, 0x70, 0x8F, 0x03, 0x77, 0x70, 0xEE, 0x0E, 0x71, 0x02, 0xF0, 0x97, 0x76, 0x04,
  0xF0, 0x87, 0x20, 0xBF, 0x01, 0x77, 0x50, 0x9F, 0x03, 0x72, 0x05, 0xF0, 0x77, 0x75, 0x0E, 0xE0,
  0xC7, 0x40, 0xDE, 0x0D, 0x77, 0x40, 0x4F, 0x07, 0x74, 0x07, 0xF0, 0x47, 0x73, 0x09, 0xF0, 0x17,
  0x40, 0x1F, 0x0A, 0x77, 0x30, 0xEE, 0x0A, 0x76, 0x0A, 0xF0, 0x17, 0x71, 0x04, 0xF0, 0x57, 0x60,
  0x3F, 0x07, 0x77, 0x10, 0x9E, 0x0E, 0x77, 0x10, 0xCE, 0x0D, 0x77, 0x10, 0xEE, 0x09, 0x77, 0x10,
  0x6F, 0x04, 0x76, 0x04, 0xF0, 0x37, 0x72, 0x0E, 0xE0, 0xB7, 0x60, 0x9E, 0x0D, 0x77, 0x30, 0x8F,
  0x01, 0x75, 0x0E, 0xE0, 0x77, 0x73, 0x02, 0xF0, 0x87, 0x40, 0x4F, 0x01, 0x77, 0x40, 0xBE, 0x0E,
  0x74, 0x09, 0xE0, 0xB7, 0x75, 0x04, 0xF0, 0x57, 0x30, 0xEE, 0x05, 0x77, 0x60, 0xDE, 0x0B, 0x72,
  0x04, 0xE0, 0xE7, 0x77, 0x07, 0xF0, 0x27, 0x10, 0x9E, 0x09, 0x77, 0x70, 0x1F, 0x08, 0x71, 0x0E,
  0xE0, 0x37, 0x77, 0x10, 0xAE, 0x0E, 0x70, 0x4E, 0x0D, 0x77, 0x72, 0x03, 0xF0, 0x56, 0x09, 0xE0,
  0x77, 0x77, 0x30, 0xCE, 0x0B, 0x60, 0xEE, 0x01, 0x77, 0x73, 0x06, 0xF0, 0x14, 0x03, 0xE0, 0xB7,
  0x77, 0x50, 0xEE, 0x06, 0x40, 0x8E, 0x05, 0x77, 0x75, 0x08, 0xE0, 0xB4, 0x0D, 0xD0, 0xE7, 0x77,
  0x60, 0x2F, 0x01, 0x20, 0x3E, 0x09, 0x77, 0x77, 0x0B, 0xE0, 0x62, 0x07, 0xE0, 0x37, 0x77, 0x70,
  0x4E, 0x0B, 0x20, 0xCD, 0x0D, 0x77, 0x77, 0x20, 0xDE, 0x10, 0x1E, 0x07, 0x77, 0x77, 0x20, 0x7E,
  0x05, 0x06, 0xE0, 0x27, 0x77, 0x72, 0x01, 0xE0, 0x90, 0xBD, 0x0B, 0x77, 0x77, 0x40, 0x9F, 0xD0,
  0x57, 0x77, 0x74, 0x03, 0xFC, 0x0E, 0x77, 0x77, 0x60, 0xCF, 0xB0, 0x97, 0x77, 0x76, 0x06, 0xFB,
  0x04, 0x77, 0x77, 0x70, 0xEF, 0x90, 0xD8, 0x0C, 0x00, 0x08, 0xF9, 0x08, 0x80, 0xC0, 0x00, 0x2F,
  0x90, 0x28, 0x0C, 0x10, 0x0C, 0xE0, 0xC8, 0x0C, 0x10, 0x01, 0xF0, 0x68, 0x0C, 0x10, 0x07, 0xF0,
  0x18, 0x0C, 0x10, 0x0D, 0xE0, 0xA8, 0x0C, 0x10, 0x04, 0xF0, 0x48, 0x0C, 0x10, 0x0B, 0xE0, 0xD8,
  0x0C, 0x10, 0x01, 0xF0, 0x88, 0x0C, 0x10, 0x08, 0xF0, 0x28, 0x0C, 0x10, 0x0E, 0xE0, 0xB8, 0x0C,
  0x10, 0x07, 0xF0, 0x58, 0x0C, 0x00, 0x01, 0x0E, 0xE0, 0xD8, 0x0C, 0x10, 0x0A, 0xF0, 0x68, 0x0C,
  0x00, 0x07, 0xF0, 0xE8, 0x0C, 0x00, 0x07, 0xF9, 0x06, 0x77, 0x77, 0x60, 0x40, 0xBF, 0x90, 0xD7,
  0x77, 0x48, 0x90, 0x3E, 0xCA, 0x99, 0x89, 0xBE, 0xFB, 0x03, 0x77, 0x74, 0x03, 0xFF, 0xC0, 0x87,
  0x77, 0x50, 0x3F, 0xFB, 0x0A, 0x77, 0x76, 0x03, 0xFF, 0xA0, 0x97, 0x77, 0x70, 0x3F, 0xF0, 0xE0,
  0x67, 0x77, 0x71, 0x03, 0xFE, 0x09, 0x01, 0x77, 0x77, 0x28, 0x93, 0x16, 0x9B, 0xCD, 0xEF, 0xED,
  0xB9, 0x57, 0x77, 0x74,
  // "þ" (U+00FE)
  0x0C, 0xF0, 0x37, 0x77, 0x75, 0x0C, 0xF0, 0x37, 0x77, 0x75, 0x0C, 0xF0, 0x37, 0x77, 0x75, 0x0C,
  0xF0, 0x37, 0x77, 0x75, 0x0C, 0xF0, 0x37, 0x77, 0x75, 0x0C, 0xF0, 0x37, 0x77, 0x75, 0x0C, 0xF0,
  0x37, 0x77, 0x75, 0x0C, 0xF0, 0x37, 0x77, 0x75, 0x0C, 0xF0, 0x37, 0x77, 0x75, 0x0C, 0xF0, 0x37,
  0x77, 0x75, 0x0C, 0xF0, 0x37, 0x77, 0x75, 0x0C, 0xF0, 0x37, 0x77, 0x75, 0x0C, 0xF0, 0x37, 0x77,
  0x75, 0x0C, 0xF0, 0x37, 0x77, 0x75, 0x0C, 0xF0, 0x37, 0x77, 0x75, 0x0C, 0xF0, 0x37, 0x77, 0x75,
  0x0C, 0xF0, 0x37, 0x77, 0x75, 0x0C, 0xF0, 0x37, 0x77, 0x75, 0x0C, 0xF0, 0x37, 0x77, 0x75, 0x0C,
  0xF0, 0x27, 0x89, 0x32, 0x69, 0xCD, 0xEF, 0xEE, 0xCA, 0x62, 0x76, 0x0C, 0xF0, 0x25, 0x05, 0x0C,
  0xFE, 0x0C, 0x06, 0x74, 0x0C, 0xF0, 0x23, 0x03, 0x0C, 0xFF, 0xB0, 0xD0, 0x57, 0x20, 0xCF, 0x01,
  0x20, 0x5F, 0xFF, 0x0A, 0x01, 0x70, 0xCF, 0x20, 0x7F, 0xFF, 0xA0, 0xD0, 0x26, 0x0C, 0xF1, 0x05,
  0xFF, 0xFC, 0x0D, 0x01, 0x50, 0xCE, 0x81, 0xE2, 0xEF, 0x86, 0xDB, 0x98, 0x99, 0xBE, 0xFC, 0x0C,
  0x50, 0xCE, 0x0E, 0x0C, 0xD8, 0x1E, 0x72, 0x71, 0x81, 0x38, 0xEF, 0xA0, 0x94, 0x0C, 0xFD, 0x08,
  0x76, 0x01, 0x0A, 0xFA, 0x04, 0x30, 0xCF, 0xC0, 0x57, 0x72, 0x08, 0xF9, 0x0D, 0x30, 0xCF, 0xB0,
  0x77, 0x74, 0x09, 0xF9, 0x05, 0x20, 0xCF, 0xA0, 0xC7, 0x76, 0x0E, 0xF0, 0xC2, 0x0C, 0xFA, 0x04,
  0x77, 0x60, 0x6F, 0x98, 0x12, 0x0C, 0xF9, 0x0C, 0x77, 0x71, 0x0E, 0xF8, 0x18, 0x0C, 0xF9, 0x07,
  0x77, 0x71, 0x09, 0xF8, 0x1C, 0x0C, 0xF9, 0x02, 0x77, 0x71, 0x04, 0xF9, 0x10, 0xCF, 0x0D, 0x77,
  0x73, 0xF9, 0x04, 0x0C, 0xF0, 0xA7, 0x77, 0x30, 0xDF, 0x07, 0x0C, 0xF0, 0x87, 0x77, 0x30, 0xAF,
  0x09, 0x0C, 0xF0, 0x67, 0x77, 0x30, 0x8F, 0x0B, 0x0C, 0xF0, 0x57, 0x77, 0x30, 0x6F, 0x00, 0xCF,
  0x04, 0x77, 0x73, 0x05, 0xF0, 0xE0, 0xCF, 0x03, 0x77, 0x73, 0x04, 0xF9, 0x0C, 0xF0, 0x37, 0x77,
  0x30, 0x4F, 0x90, 0xCF, 0x03, 0x77, 0x73, 0x03, 0xF9, 0x0C, 0xF0, 0x37, 0x77, 0x30, 0x3F, 0x90,
  0xCF, 0x04, 0x77, 0x73, 0x04, 0xF9, 0x0C, 0xF0, 0x47, 0x77, 0x30, 0x4F, 0x90, 0xCF, 0x05, 0x77,
  0x73, 0x05, 0xF0, 0xE0, 0xCF, 0x07, 0x77, 0x73, 0x07, 0xF0, 0x0C, 0xF0, 0x97, 0x77, 0x30, 0x9F,
  0x0B, 0x0C, 0xF0, 0xB7, 0x77, 0x30, 0xBF, 0x09, 0x0C, 0xF0, 0xD7, 0x77, 0x30, 0xEF, 0x06, 0x0C,
  0xF9, 0x02, 0x77, 0x71, 0x02, 0xF9, 0x03, 0x0C, 0xF9, 0x06, 0x77, 0x71, 0x06, 0xF9, 0x10, 0xCF,
  0x90, 0xA7, 0x77, 0x10, 0xBF, 0x81, 0xC0, 0xCF, 0xA0, 0x17, 0x76, 0x01, 0xF9, 0x81, 0x70, 0xCF,
  0xA0, 0x87, 0x76, 0x08, 0xF9, 0x81, 0x20, 0xCF, 0xA0, 0xE0, 0x17, 0x74, 0x02, 0xF9, 0x0B, 0x20,
  0xCF, 0xB0, 0x97, 0x74, 0x0C, 0xF9, 0x04, 0x20, 0xCF, 0xC0, 0x77, 0x72, 0x0A, 0xF9, 0x0C, 0x30,
  0xCF, 0xD0, 0x90, 0x17, 0x50, 0x20, 0xCF, 0xA0, 0x33, 0x0C, 0xFE, 0x81, 0xE7, 0x27, 0x10, 0x30,
  0x9F, 0xB0, 0x84, 0x0C, 0xE0, 0xB0, 0x5F, 0x98, 0x6D, 0xB9, 0x88, 0x9B, 0xEF, 0xC0, 0xC5, 0x0C,
  0xE8, 0x1D, 0x06, 0xFF, 0xFC, 0x0D, 0x01, 0x50, 0xCE, 0x0E, 0x20, 0x6F, 0xFF, 0xA0, 0xC0, 0x16,
  0x0C, 0xF3, 0x04, 0x0E, 0xFF, 0xE0, 0xA7, 0x10, 0xCF, 0x01, 0x30, 0x10, 0xAF, 0xFB, 0x0D, 0x05,
  0x72, 0x0C, 0xF0, 0x25, 0x03, 0x0B, 0xFE, 0x0C, 0x06, 0x74, 0x0C, 0xF0, 0x27, 0x89, 0x31, 0x59,
  0xBD, 0xEF, 0xEE, 0xCA, 0x62, 0x76, 0x0C, 0xF0, 0x37, 0x77, 0x75, 0x0C, 0xF0, 0x37, 0x77, 0x75,
  0x0C, 0xF0, 0x37, 0x77, 0x75, 0x0C, 0xF0, 0x37, 0x77, 0x75, 0x0C, 0xF0, 0x37, 0x77, 0x75, 0x0C,
  0xF0, 0x37, 0x77, 0x75, 0x0C, 0xF0, 0x37, 0x77, 0x75, 0x0C, 0xF0, 0x37, 0x77, 0x75, 0x0C, 0xF0,
  0x37, 0x77, 0x75, 0x0C, 0xF0, 0x37, 0x77, 0x75, 0x0C, 0xF0, 0x37, 0x77, 0x75, 0x0C, 0xF0, 0x37,
  0x77, 0x75, 0x0C, 0xF0, 0x37, 0x77, 0x75, 0x0C, 0xF0, 0x37, 0x77, 0x75, 0x0C, 0xF0, 0x37, 0x77,
  0x75, 0x0C, 0xF0, 0x37, 0x77, 0x75, 0x0C, 0xF0, 0x37, 0x77, 0x75, 0x0C, 0xF0, 0x37, 0x77, 0x75,
  0x0C, 0xF0, 0x37, 0x77, 0x75, 0x0C, 0xF0, 0x37, 0x77, 0x75, 0x0C, 0xF0, 0x37, 0x77, 0x75,
  // "ÿ" (U+00FF)
  0x72, 0x85, 0x18, 0xDF, 0xEB, 0x47, 0x78, 0x53, 0xAE, 0xFD, 0x91, 0x77, 0x30, 0x20, 0xDE, 0x08,
  0x75, 0x06, 0xE0, 0xE0, 0x37, 0x72, 0x0A, 0xF9, 0x03, 0x73, 0x01, 0xF9, 0x0C, 0x77, 0x20, 0xEF,
  0x90, 0x87, 0x30, 0x5F, 0xA0, 0x27, 0x70, 0x1F, 0xA0, 0xA7, 0x30, 0x7F, 0xA0, 0x47, 0x70, 0x1F,
  0xA0, 0x97, 0x30, 0x7F, 0xA0, 0x37, 0x71, 0x0E, 0xF9, 0x07, 0x73, 0x05, 0xFA, 0x01, 0x77, 0x10,
  0x9F, 0x90, 0x27, 0x40, 0xEF, 0x0B, 0x77, 0x20, 0x10, 0xCE, 0x06, 0x75, 0x04, 0xE0, 0xD0, 0x27,
  0x74, 0x84, 0x7D, 0xFE, 0xA3, 0x77, 0x85, 0x2A, 0xEF, 0xD8, 0x18, 0x0D, 0xE5, 0x00, 0xBF, 0x02,
  0x77, 0x77, 0x09, 0xF0, 0xA0, 0x5F, 0x09, 0x77, 0x77, 0x0E, 0xF8, 0x14, 0x0D, 0xE0, 0xE7, 0x77,
  0x60, 0x4F, 0x0E, 0x20, 0x7F, 0x06, 0x77, 0x75, 0x09, 0xF0, 0x82, 0x01, 0xF0, 0xC7, 0x77, 0x50,
  0xEF, 0x02, 0x30, 0xAF, 0x03, 0x77, 0x73, 0x04, 0xF0, 0xC4, 0x03, 0xF0, 0x97, 0x77, 0x30, 0x9F,
  0x06, 0x50, 0xCE, 0x0E, 0x77, 0x73, 0x0E, 0xF0, 0x15, 0x06, 0xF0, 0x67, 0x77, 0x10, 0x4F, 0x0A,
  0x70, 0xEE, 0x0C, 0x77, 0x71, 0x09, 0xF0, 0x47, 0x08, 0xF0, 0x37, 0x77, 0x0E, 0xE0, 0xE7, 0x10,
  0x2F, 0x09, 0x77, 0x60, 0x4F, 0x08, 0x72, 0x0B, 0xF0, 0x17, 0x75, 0x09, 0xF0, 0x37, 0x20, 0x5F,
  0x07, 0x77, 0x50, 0xEE, 0x0C, 0x74, 0x0D, 0xE0, 0xD7, 0x74, 0x04, 0xF0, 0x77, 0x40, 0x7F, 0x04,
  0x77, 0x30, 0x9F, 0x01, 0x74, 0x01, 0xF0, 0xA7, 0x73, 0x0E, 0xE0, 0xA7, 0x60, 0xAF, 0x01, 0x77,
  0x10, 0x4F, 0x05, 0x76, 0x03, 0xF0, 0x77, 0x71, 0x09, 0xE0, 0xE7, 0x71, 0x0C, 0xE0, 0xD7, 0x71,
  0x0E, 0xE0, 0x97, 0x71, 0x06, 0xF0, 0x47, 0x60, 0x4F, 0x03, 0x77, 0x20, 0xEE, 0x0B, 0x76, 0x09,
  0xE0, 0xD7, 0x73, 0x08, 0xF0, 0x17, 0x50, 0xEE, 0x07, 0x77, 0x30, 0x2F, 0x08, 0x74, 0x04, 0xF0,
  0x17, 0x74, 0x0B, 0xE0, 0xE7, 0x40, 0x9E, 0x0B, 0x77, 0x50, 0x4F, 0x05, 0x73, 0x0E, 0xE0, 0x57,
  0x76, 0x0D, 0xE0, 0xB7, 0x20, 0x4E, 0x0E, 0x77, 0x70, 0x7F, 0x02, 0x71, 0x09, 0xE0, 0x97, 0x77,
  0x01, 0xF0, 0x87, 0x10, 0xEE, 0x03, 0x77, 0x71, 0x0A, 0xE0, 0xE7, 0x04, 0xE0, 0xD7, 0x77, 0x20,
  0x3F, 0x05, 0x60, 0x9E, 0x07, 0x77, 0x73, 0x0C, 0xE0, 0xB6, 0x0E, 0xE0, 0x17, 0x77, 0x30, 0x6F,
  0x01, 0x40, 0x3E, 0x0B, 0x77, 0x75, 0x0E, 0xE0, 0x64, 0x08, 0xE0, 0x57, 0x77, 0x50, 0x8E, 0x0B,
  0x40, 0xDD, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0x12, 0x03, 0xE0, 0x97, 0x77, 0x70, 0xBE, 0x06, 0x20,
  0x7E, 0x03, 0x77, 0x77, 0x04, 0xE0, 0xB2, 0x0C, 0xD0, 0xD7, 0x77, 0x72, 0x0D, 0xE1, 0x01, 0xE0,
  0x77, 0x77, 0x72, 0x07, 0xE0, 0x50, 0x6E, 0x02, 0x77, 0x77, 0x20, 0x1E, 0x09, 0x0B, 0xD0, 0xB7,
  0x77, 0x74, 0x09, 0xFD, 0x05, 0x77, 0x77, 0x40, 0x3F, 0xC0, 0xE7, 0x77, 0x76, 0x0C, 0xFB, 0x09,
  0x77, 0x77, 0x60, 0x6F, 0xB0, 0x47, 0x77, 0x77, 0x0E, 0xF9, 0x0D, 0x80, 0xC0, 0x00, 0x8F, 0x90,
  0x88, 0x0C, 0x00, 0x02, 0xF9, 0x02, 0x80, 0xC1, 0x00, 0xCE, 0x0C, 0x80, 0xC1, 0x00, 0x1F, 0x06,
  0x80, 0xC1, 0x00, 0x7F, 0x01, 0x80, 0xC1, 0x00, 0xDE, 0x0A, 0x80, 0xC1, 0x00, 0x4F, 0x04, 0x80,
  0xC1, 0x00, 0xBE, 0x0D, 0x80, 0xC1, 0x00, 0x1F, 0x08, 0x80, 0xC1, 0x00, 0x8F, 0x02, 0x80, 0xC1,
  0x00, 0xEE, 0x0B, 0x80, 0xC1, 0x00, 0x7F, 0x05, 0x80, 0xC0, 0x00, 0x10, 0xEE, 0x0D, 0x80, 0xC1,
  0x00, 0xAF, 0x06, 0x80, 0xC0, 0x00, 0x7F, 0x0E, 0x80, 0xC0, 0x00, 0x7F, 0x90, 0x67, 0x77, 0x76,
  0x04, 0x0B, 0xF9, 0x0D, 0x77, 0x74, 0x89, 0x03, 0xEC, 0xA9, 0x98, 0x9B, 0xEF, 0xB0, 0x37, 0x77,
  0x40, 0x3F, 0xFC, 0x08, 0x77, 0x75, 0x03, 0xFF, 0xB0, 0xA7, 0x77, 0x60, 0x3F, 0xFA, 0x09, 0x77,
  0x77, 0x03, 0xFF, 0x0E, 0x06, 0x77, 0x77, 0x10, 0x3F, 0xE0, 0x90, 0x17, 0x77, 0x72, 0x89, 0x31,
  0x69, 0xBC, 0xDE, 0xFE, 0xDB, 0x95, 0x77, 0x77, 0x40,
  // "Ā" (U+0100)
  0x75, 0x02, 0x80, 0xA6, 0x80, 0x37, 0x77, 0x30, 0x4F, 0xFF, 0xD0, 0x67, 0x77, 0x30, 0x4F, 0xFF,
  0xD0, 0x67, 0x77, 0x30, 0x4F, 0xFF, 0xD0, 0x67, 0x77, 0x30, 0x4F, 0xFF, 0xD0, 0x67, 0x77, 0x30,
  0x4F, 0xFF, 0xD0, 0x67, 0x77, 0x30, 0x4F, 0xFF, 0xD0, 0x68, 0x0E, 0x91, 0x00, 0x7F, 0x90, 0x68,
  0x0C, 0x60, 0x0C, 0xF9, 0x0B, 0x80, 0xC5, 0x00, 0x2F, 0xB0, 0x18, 0x0C, 0x40, 0x07, 0xFB, 0x05,
  0x80, 0xC4, 0x00, 0xCF, 0xB0, 0xB8, 0x0C, 0x30, 0x01, 0xFD, 0x80, 0xC3, 0x00, 0x6F, 0xD0, 0x58,
  0x0C, 0x20, 0x0B, 0xFD, 0x0A, 0x80, 0xC1, 0x00, 0x1E, 0x0E, 0xF8, 0x0C, 0x10, 0x06, 0xE0, 0xA0,
  0xCE, 0x05, 0x80, 0xC0, 0x00, 0xBE, 0x07, 0x08, 0xE0, 0xA7, 0x77, 0x77, 0x01, 0xF0, 0x30, 0x4E,
  0x0E, 0x77, 0x77, 0x70, 0x6E, 0x0E, 0x2F, 0x05, 0x77, 0x77, 0x60, 0xBE, 0x0A, 0x20, 0xCE, 0x0A,
  0x77, 0x77, 0x50, 0x1F, 0x06, 0x20, 0x7E, 0x0E, 0x77, 0x77, 0x50, 0x5F, 0x01, 0x20, 0x3F, 0x04,
  0x77, 0x77, 0x40, 0xAE, 0x0C, 0x40, 0xDE, 0x09, 0x77, 0x77, 0x4F, 0x07, 0x40, 0x9E, 0x0E, 0x77,
  0x77, 0x30, 0x5F, 0x03, 0x40, 0x4F, 0x04, 0x77, 0x77, 0x20, 0xAE, 0x0D, 0x60, 0xEE, 0x09, 0x77,
  0x77, 0x20, 0xEE, 0x08, 0x60, 0xAE, 0x0E, 0x77, 0x77, 0x10, 0x5F, 0x03, 0x60, 0x5F, 0x04, 0x77,
  0x77, 0x0A, 0xE0, 0xE7, 0x1F, 0x09, 0x77, 0x77, 0x0E, 0xE0, 0x97, 0x10, 0xBE, 0x0E, 0x77, 0x76,
  0x04, 0xF0, 0x47, 0x10, 0x6F, 0x04, 0x77, 0x75, 0x09, 0xE0, 0xE7, 0x20, 0x1F, 0x09, 0x77, 0x75,
  0x0E, 0xE0, 0xA7, 0x30, 0xBE, 0x0E, 0x77, 0x74, 0x04, 0xF0, 0x57, 0x30, 0x7F, 0x03, 0x77, 0x73,
  0x09, 0xF0, 0x17, 0x30, 0x2F, 0x08, 0x77, 0x73, 0x0E, 0xE0, 0xB7, 0x50, 0xCE, 0x0D, 0x77, 0x72,
  0x04, 0xF0, 0x67, 0x50, 0x7F, 0x03, 0x77, 0x71, 0x09, 0xF0, 0x17, 0x50, 0x2F, 0x08, 0x77, 0x71,
  0x0E, 0xE0, 0xC7, 0x70, 0xDE, 0x0D, 0x77, 0x70, 0x3F, 0x07, 0x77, 0x08, 0xF0, 0x37, 0x76, 0x08,
  0xF0, 0x27, 0x70, 0x3F, 0x08, 0x77, 0x60, 0xDE, 0x0C, 0x77, 0x20, 0xEE, 0x0D, 0x77, 0x50, 0x3F,
  0x08, 0x77, 0x20, 0x9F, 0x03, 0x77, 0x40, 0x8F, 0xFF, 0xFC, 0x08, 0x77, 0x40, 0xDF, 0xFF, 0xFC,
  0x0D, 0x77, 0x30, 0x3F, 0xFF, 0xFE, 0x02, 0x77, 0x20, 0x8F, 0xFF, 0xFE, 0x07, 0x77, 0x20, 0xDF,
  0xFF, 0xFE, 0x0C, 0x77, 0x10, 0x28, 0x0C, 0x0F, 0x02, 0x77, 0x07, 0x80, 0xC0, 0xF0, 0x77, 0x70,
  0xDE, 0x0E, 0x77, 0x70, 0x1F, 0x0C, 0x76, 0x02, 0xF0, 0xA7, 0x77, 0x10, 0xBF, 0x02, 0x75, 0x07,
  0xF0, 0x57, 0x77, 0x10, 0x6F, 0x07, 0x75, 0x0C, 0xF7, 0x77, 0x20, 0x2F, 0x0C, 0x74, 0x02, 0xF0,
  0xB7, 0x77, 0x30, 0xCF, 0x01, 0x73, 0x07, 0xF0, 0x67, 0x77, 0x30, 0x8F, 0x07, 0x73, 0x0C, 0xF0,
  0x17, 0x77, 0x30, 0x3F, 0x0C, 0x72, 0x01, 0xF0, 0xC7, 0x77, 0x50, 0xDF, 0x01, 0x71, 0x07, 0xF0,
  0x77, 0x77, 0x50, 0x9F, 0x06, 0x71, 0x0C, 0xF0, 0x37, 0x77, 0x50, 0x4F, 0x0B, 0x70, 0x1F, 0x0D,
  0x77, 0x77, 0x0E, 0xF0, 0x16, 0x06, 0xF0, 0x97, 0x77, 0x70, 0xAF, 0x06, 0x60, 0xBF, 0x04, 0x77,
  0x77, 0x05, 0xF0, 0xB5, 0x01, 0xF0, 0xE7, 0x77, 0x71, 0x01, 0xF9, 0x01, 0x40, 0x6F, 0x0A, 0x77,
  0x77, 0x20, 0xBF, 0x06, 0x40, 0xBF, 0x05, 0x77, 0x77, 0x20, 0x7F, 0x0B, 0x30, 0x1F, 0x90, 0x17,
  0x77, 0x72, 0x02, 0xF9, 0x01, 0x20, 0x6F, 0x0B, 0x77, 0x77, 0x40, 0xDF, 0x05, 0x20, 0xBF, 0x06,
  0x77, 0x77, 0x40, 0x8F, 0x81, 0xB0, 0x1F, 0x90, 0x27, 0x77, 0x74, 0x03, 0xF9, 0x01,
  // "ā" (U+0101)
  0x70, 0x28, 0x0A, 0x68, 0x03, 0x75, 0x04, 0xFF, 0xFD, 0x06, 0x75, 0x04, 0xFF, 0xFD, 0x06, 0x75,
  0x04, 0xFF, 0xFD, 0x06, 0x75, 0x04, 0xFF, 0xFD, 0x06, 0x75, 0x04, 0xFF, 0xFD, 0x06, 0x75, 0x04,
  0xFF, 0xFD, 0x06, 0x80, 0xBF, 0x60, 0x85, 0x47, 0x9B, 0xDE, 0xEA, 0x85, 0xEE, 0xCA, 0x85, 0x17,
  0x76, 0x81, 0x16, 0xBF, 0xFB, 0x81, 0xC7, 0x17, 0x71, 0x06, 0x0B, 0xFF, 0xFA, 0x08, 0x01, 0x73,
  0x81, 0x18, 0xEF, 0xFF, 0xD0, 0xE0, 0x47, 0x10, 0x1F, 0xFF, 0xFB, 0x06, 0x71, 0x0B, 0xFF, 0xFF,
  0xB0, 0x67, 0x04, 0xFC, 0x87, 0xDB, 0x99, 0x89, 0xAB, 0xEF, 0xD0, 0x37, 0x0C, 0xE8, 0x1C, 0x73,
  0x73, 0x81, 0x28, 0xDF, 0xA0, 0xC7, 0x05, 0xB8, 0x1E, 0x82, 0x77, 0x20, 0x7F, 0xA0, 0x47, 0x81,
  0xDE, 0x67, 0x76, 0x03, 0x0E, 0xF0, 0xB7, 0x03, 0x77, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x77, 0x30,
  0xBF, 0x05, 0x77, 0x77, 0x30, 0x4F, 0x08, 0x77, 0x77, 0x40, 0xEE, 0x0A, 0x77, 0x77, 0x40, 0xCE,
  0x0C, 0x77, 0x77, 0x40, 0x9E, 0x0D, 0x77, 0x77, 0x40, 0x8E, 0x0D, 0x77, 0x77, 0x40, 0x7E, 0x0E,
  0x77, 0x77, 0x40, 0x7E, 0x0E, 0x77, 0x77, 0x40, 0x7E, 0x0E, 0x76, 0x86, 0x25, 0x8A, 0xCD, 0xEE,
  0xFF, 0xC0, 0xE7, 0x38, 0x15, 0xAE, 0xFF, 0xFD, 0x0E, 0x78, 0x11, 0x8E, 0xFF, 0xFF, 0x90, 0xE6,
  0x06, 0x0E, 0xFF, 0xFF, 0xB0, 0xE4, 0x01, 0x0B, 0xFF, 0xFF, 0xD0, 0xE3, 0x01, 0x0D, 0xFF, 0xFF,
  0xE0, 0xE3, 0x0C, 0xFC, 0x85, 0xD9, 0x74, 0x31, 0x17, 0x30, 0x7E, 0x0E, 0x20, 0x8F, 0xA8, 0x1E,
  0x82, 0x77, 0x30, 0x7E, 0x81, 0xE0, 0x2F, 0xA0, 0x90, 0x17, 0x75, 0x07, 0xE8, 0x1E, 0x08, 0xF9,
  0x07, 0x77, 0x70, 0x7E, 0x81, 0xE0, 0xEF, 0x09, 0x77, 0x71, 0x07, 0xE0, 0xE0, 0x3F, 0x0D, 0x77,
  0x72, 0x08, 0xE0, 0xE0, 0x6F, 0x08, 0x77, 0x72, 0x0A, 0xE0, 0xE0, 0x8F, 0x03, 0x77, 0x72, 0x0D,
  0xE0, 0xE0, 0xAF, 0x01, 0x77, 0x71, 0x01, 0xF0, 0xE0, 0xAF, 0x77, 0x72, 0x07, 0xF0, 0xE0, 0xAF,
  0x77, 0x72, 0x0D, 0xF0, 0xE0, 0x9F, 0x02, 0x77, 0x70, 0x7F, 0x90, 0xE0, 0x7F, 0x06, 0x77, 0x60,
  0x4F, 0xA0, 0xE0, 0x5F, 0x0C, 0x77, 0x50, 0x40, 0xEF, 0xA0, 0xE0, 0x1F, 0x90, 0x67, 0x73, 0x06,
  0xFC, 0x81, 0xE0, 0xCF, 0x90, 0x77, 0x70, 0x40, 0xBF, 0xD8, 0x1E, 0x05, 0xFA, 0x81, 0xC6, 0x17,
  0x18, 0x12, 0x7C, 0xE0, 0xE0, 0xBE, 0x0E, 0x20, 0xDF, 0xC8, 0x6D, 0xA9, 0x89, 0xAC, 0xEF, 0xA0,
  0x40, 0x5E, 0x0E, 0x20, 0x3F, 0xFF, 0xE8, 0x15, 0x03, 0xE0, 0xE3, 0x05, 0xFF, 0xFB, 0x0E, 0x04,
  0x20, 0x1E, 0x0E, 0x40, 0x40, 0xEF, 0xFF, 0x0C, 0x02, 0x40, 0xED, 0x0E, 0x50, 0x10, 0xAF, 0xFC,
  0x0E, 0x07, 0x60, 0xCD, 0x0E, 0x78, 0x13, 0x9E, 0xFE, 0x81, 0xD7, 0x17, 0x0A, 0xD0, 0xE7, 0x38,
  0x93, 0x47, 0xBC, 0xDE, 0xFE, 0xDB, 0x96, 0x27, 0x73,
  // "Ă" (U+0102)
  0x75, 0x0D, 0xC0, 0x67, 0x72, 0x06, 0xD7, 0x77, 0x30, 0xCC, 0x0B, 0x77, 0x20, 0xBC, 0x0D, 0x77,
  0x73, 0x09, 0xD0, 0x47, 0x70, 0x3D, 0x0B, 0x77, 0x73, 0x05, 0xD0, 0xD0, 0x27, 0x50, 0x10, 0xCD,
  0x06, 0x77, 0x74, 0x0E, 0xD0, 0xE0, 0x57, 0x30, 0x30, 0xDE, 0x01, 0x77, 0x74, 0x07, 0xF8, 0x2D,
  0x74, 0x12, 0x82, 0x13, 0x7C, 0xF0, 0x97, 0x77, 0x60, 0xDF, 0xFF, 0x90, 0xE0, 0x17, 0x77, 0x60,
  0x30, 0xEF, 0xFF, 0x03, 0x77, 0x77, 0x10, 0x40, 0xEF, 0xFC, 0x0E, 0x04, 0x77, 0x77, 0x30, 0x20,
  0xDF, 0xFA, 0x0C, 0x02, 0x77, 0x77, 0x60, 0x60, 0xDF, 0xD0, 0xC0, 0x58, 0x0C, 0x20, 0x89, 0x23,
  0x7B, 0xDE, 0xFE, 0xDC, 0xA6, 0x38, 0x0D, 0xB5, 0x00, 0x7F, 0x90, 0x68, 0x0C, 0x60, 0x0C, 0xF9,
  0x0B, 0x80, 0xC5, 0x00, 0x2F, 0xB0, 0x18, 0x0C, 0x40, 0x07, 0xFB, 0x05, 0x80, 0xC4, 0x00, 0xCF,
  0xB0, 0xB8, 0x0C, 0x30, 0x01, 0xFD, 0x80, 0xC3, 0x00, 0x6F, 0xD0, 0x58, 0x0C, 0x20, 0x0B, 0xFD,
  0x0A, 0x80, 0xC1, 0x00, 0x1E, 0x0E, 0xF8, 0x0C, 0x10, 0x06, 0xE0, 0xA0, 0xCE, 0x05, 0x80, 0xC0,
  0x00, 0xBE, 0x07, 0x08, 0xE0, 0xA7, 0x77, 0x77, 0x01, 0xF0, 0x30, 0x4E, 0x0E, 0x77, 0x77, 0x70,
  0x6E, 0x0E, 0x2F, 0x05, 0x77, 0x77, 0x60, 0xBE, 0x0A, 0x20, 0xCE, 0x0A, 0x77, 0x77, 0x50, 0x1F,
  0x06, 0x20, 0x7E, 0x0E, 0x77, 0x77, 0x50, 0x5F, 0x01, 0x20, 0x3F, 0x04, 0x77, 0x77, 0x40, 0xAE,
  0x0C, 0x40, 0xDE, 0x09, 0x77, 0x77, 0x4F, 0x07, 0x40, 0x9E, 0x0E, 0x77, 0x77, 0x30, 0x5F, 0x03,
  0x40, 0x4F, 0x04, 0x77, 0x77, 0x20, 0xAE, 0x0D, 0x60, 0xEE, 0x09, 0x77, 0x77, 0x20, 0xEE, 0x08,
  0x60, 0xAE, 0x0E, 0x77, 0x77, 0x10, 0x5F, 0x03, 0x60, 0x5F, 0x04, 0x77, 0x77, 0x0A, 0xE0, 0xE7,
  0x1F, 0x09, 0x77, 0x77, 0x0E, 0xE0, 0x97, 0x10, 0xBE, 0x0E, 0x77, 0x76, 0x04, 0xF0, 0x47, 0x10,
  0x6F, 0x04, 0x77, 0x75, 0x09, 0xE0, 0xE7, 0x20, 0x1F, 0x09, 0x77, 0x75, 0x0E, 0xE0, 0xA7, 0x30,
  0xBE, 0x0E, 0x77, 0x74, 0x04, 0xF0, 0x57, 0x30, 0x7F, 0x03, 0x77, 0x73, 0x09, 0xF0, 0x17, 0x30,
  0x2F, 0x08, 0x77, 0x73, 0x0E, 0xE0, 0xB7, 0x50, 0xCE, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0x67, 0x50,
  0x7F, 0x03, 0x77, 0x71, 0x09, 0xF0, 0x17, 0x50, 0x2F, 0x08, 0x77, 0x71, 0x0E, 0xE0, 0xC7, 0x70,
  0xDE, 0x0D, 0x77, 0x70, 0x3F, 0x07, 0x77, 0x08, 0xF0, 0x37, 0x76, 0x08, 0xF0, 0x27, 0x70, 0x3F,
  0x08, 0x77, 0x60, 0xDE, 0x0C, 0x77, 0x20, 0xEE, 0x0D, 0x77, 0x50, 0x3F, 0x08, 0x77, 0x20, 0x9F,
  0x03, 0x77, 0x40, 0x8F, 0xFF, 0xFC, 0x08, 0x77, 0x40, 0xDF, 0xFF, 0xFC, 0x0D, 0x77, 0x30, 0x3F,
  0xFF, 0xFE, 0x02, 0x77, 0x20, 0x8F, 0xFF, 0xFE, 0x07, 0x77, 0x20, 0xDF, 0xFF, 0xFE, 0x0C, 0x77,
  0x10, 0x28, 0x0C, 0x0F, 0x02, 0x77, 0x07, 0x80, 0xC0, 0xF0, 0x77, 0x70, 0xDE, 0x0E, 0x77, 0x70,
  0x1F, 0x0C, 0x76, 0x02, 0xF0, 0xA7, 0x77, 0x10, 0xBF, 0x02, 0x75, 0x07, 0xF0, 0x57, 0x77, 0x10,
  0x6F, 0x07, 0x75, 0x0C, 0xF7, 0x77, 0x20, 0x2F, 0x0C, 0x74, 0x02, 0xF0, 0xB7, 0x77, 0x30, 0xCF,
  0x01, 0x73, 0x07, 0xF0, 0x67, 0x77, 0x30, 0x8F, 0x07, 0x73, 0x0C, 0xF0, 0x17, 0x77, 0x30, 0x3F,
  0x0C, 0x72, 0x01, 0xF0, 0xC7, 0x77, 0x50, 0xDF, 0x01, 0x71, 0x07, 0xF0, 0x77, 0x77, 0x50, 0x9F,
  0x06, 0x71, 0x0C, 0xF0, 0x37, 0x77, 0x50, 0x4F, 0x0B, 0x70, 0x1F, 0x0D, 0x77, 0x77, 0x0E, 0xF0,
  0x16, 0x06, 0xF0, 0x97, 0x77, 0x70, 0xAF, 0x06, 0x60, 0xBF, 0x04, 0x77, 0x77, 0x05, 0xF0, 0xB5,
  0x01, 0xF0, 0xE7, 0x77, 0x71, 0x01, 0xF9, 0x01, 0x40, 0x6F, 0x0A, 0x77, 0x77, 0x20, 0xBF, 0x06,
  0x40, 0xBF, 0x05, 0x77, 0x77, 0x20, 0x7F, 0x0B, 0x30, 0x1F, 0x90, 0x17, 0x77, 0x72, 0x02, 0xF9,
  0x01, 0x20, 0x6F, 0x0B, 0x77, 0x77, 0x40, 0xDF, 0x05, 0x20, 0xBF, 0x06, 0x77, 0x77, 0x40, 0x8F,
  0x81, 0xB0, 0x1F, 0x90, 0x27, 0x77, 0x74, 0x03, 0xF9, 0x01,
  // "ă" (U+0103)
  0x70, 0xDC, 0x06, 0x77, 0x20, 0x6D, 0x75, 0x0C, 0xC0, 0xB7, 0x72, 0x0B, 0xC0, 0xD7, 0x50, 0x9D,
  0x04, 0x77, 0x03, 0xD0, 0xB7, 0x50, 0x5D, 0x0D, 0x02, 0x75, 0x01, 0x0C, 0xD0, 0x67, 0x60, 0xED,
  0x0E, 0x05, 0x73, 0x03, 0x0D, 0xE0, 0x17, 0x60, 0x7F, 0x82, 0xD7, 0x41, 0x28, 0x21, 0x37, 0xCF,
  0x09, 0x77, 0x10, 0xDF, 0xFF, 0x90, 0xE0, 0x17, 0x71, 0x03, 0x0E, 0xFF, 0xF0, 0x37, 0x73, 0x04,
  0x0E, 0xFF, 0xC0, 0xE0, 0x47, 0x75, 0x02, 0x0D, 0xFF, 0xA0, 0xC0, 0x27, 0x77, 0x10, 0x60, 0xDF,
  0xD0, 0xC0, 0x57, 0x77, 0x58, 0x92, 0x37, 0xBD, 0xEF, 0xED, 0xCA, 0x63, 0x80, 0xBB, 0x60, 0x85,
  0x47, 0x9B, 0xDE, 0xEA, 0x85, 0xEE, 0xCA, 0x85, 0x17, 0x76, 0x81, 0x16, 0xBF, 0xFB, 0x81, 0xC7,
  0x17, 0x71, 0x06, 0x0B, 0xFF, 0xFA, 0x08, 0x01, 0x73, 0x81, 0x18, 0xEF, 0xFF, 0xD0, 0xE0, 0x47,
  0x10, 0x1F, 0xFF, 0xFB, 0x06, 0x71, 0x0B, 0xFF, 0xFF, 0xB0, 0x67, 0x04, 0xFC, 0x87, 0xDB, 0x99,
  0x89, 0xAB, 0xEF, 0xD0, 0x37, 0x0C, 0xE8, 0x1C, 0x73, 0x73, 0x81, 0x28, 0xDF, 0xA0, 0xC7, 0x05,
  0xB8, 0x1E, 0x82, 0x77, 0x20, 0x7F, 0xA0, 0x47, 0x81, 0xDE, 0x67, 0x76, 0x03, 0x0E, 0xF0, 0xB7,
  0x03, 0x77, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x77, 0x30, 0xBF, 0x05, 0x77, 0x77, 0x30, 0x4F, 0x08,
  0x77, 0x77, 0x40, 0xEE, 0x0A, 0x77, 0x77, 0x40, 0xCE, 0x0C, 0x77, 0x77, 0x40, 0x9E, 0x0D, 0x77,
  0x77, 0x40, 0x8E, 0x0D, 0x77, 0x77, 0x40, 0x7E, 0x0E, 0x77, 0x77, 0x40, 0x7E, 0x0E, 0x77, 0x77,
  0x40, 0x7E, 0x0E, 0x76, 0x86, 0x25, 0x8A, 0xCD, 0xEE, 0xFF, 0xC0, 0xE7, 0x38, 0x15, 0xAE, 0xFF,
  0xFD, 0x0E, 0x78, 0x11, 0x8E, 0xFF, 0xFF, 0x90, 0xE6, 0x06, 0x0E, 0xFF, 0xFF, 0xB0, 0xE4, 0x01,
  0x0B, 0xFF, 0xFF, 0xD0, 0xE3, 0x01, 0x0D, 0xFF, 0xFF, 0xE0, 0xE3, 0x0C, 0xFC, 0x85, 0xD9, 0x74,
  0x31, 0x17, 0x30, 0x7E, 0x0E, 0x20, 0x8F, 0xA8, 0x1E, 0x82, 0x77, 0x30, 0x7E, 0x81, 0xE0, 0x2F,
  0xA0, 0x90, 0x17, 0x75, 0x07, 0xE8, 0x1E, 0x08, 0xF9, 0x07, 0x77, 0x70, 0x7E, 0x81, 0xE0, 0xEF,
  0x09, 0x77, 0x71, 0x07, 0xE0, 0xE0, 0x3F, 0x0D, 0x77, 0x72, 0x08, 0xE0, 0xE0, 0x6F, 0x08, 0x77,
  0x72, 0x0A, 0xE0, 0xE0, 0x8F, 0x03, 0x77, 0x72, 0x0D, 0xE0, 0xE0, 0xAF, 0x01, 0x77, 0x71, 0x01,
  0xF0, 0xE0, 0xAF, 0x77, 0x72, 0x07, 0xF0, 0xE0, 0xAF, 0x77, 0x72, 0x0D, 0xF0, 0xE0, 0x9F, 0x02,
  0x77, 0x70, 0x7F, 0x90, 0xE0, 0x7F, 0x06, 0x77, 0x60, 0x4F, 0xA0, 0xE0, 0x5F, 0x0C, 0x77, 0x50,
  0x40, 0xEF, 0xA0, 0xE0, 0x1F, 0x90, 0x67, 0x73, 0x06, 0xFC, 0x81, 0xE0, 0xCF, 0x90, 0x77, 0x70,
  0x40, 0xBF, 0xD8, 0x1E, 0x05, 0xFA, 0x81, 0xC6, 0x17, 0x18, 0x12, 0x7C, 0xE0, 0xE0, 0xBE, 0x0E,
  0x20, 0xDF, 0xC8, 0x6D, 0xA9, 0x89, 0xAC, 0xEF, 0xA0, 0x40, 0x5E, 0x0E, 0x20, 0x3F, 0xFF, 0xE8,
  0x15, 0x03, 0xE0, 0xE3, 0x05, 0xFF, 0xFB, 0x0E, 0x04, 0x20, 0x1E, 0x0E, 0x40, 0x40, 0xEF, 0xFF,
  0x0C, 0x02, 0x40, 0xED, 0x0E, 0x50, 0x10, 0xAF, 0xFC, 0x0E, 0x07, 0x60, 0xCD, 0x0E, 0x78, 0x13,
  0x9E, 0xFE, 0x81, 0xD7, 0x17, 0x0A, 0xD0, 0xE7, 0x38, 0x93, 0x47, 0xBC, 0xDE, 0xFE, 0xDB, 0x96,
  0x27, 0x73,
  // "Ą" (U+0104)
  0x77, 0x70, 0x7F, 0x90, 0x68, 0x0D, 0x00, 0x0C, 0xF9, 0x0B, 0x80, 0xC7, 0x00, 0x2F, 0xB0, 0x18,
  0x0C, 0x60, 0x07, 0xFB, 0x05, 0x80, 0xC6, 0x00, 0xCF, 0xB0, 0xB8, 0x0C, 0x50, 0x01, 0xFD, 0x80,
  0xC5, 0x00, 0x6F, 0xD0, 0x58, 0x0C, 0x40, 0x0B, 0xFD, 0x0A, 0x80, 0xC3, 0x00, 0x1E, 0x0E, 0xF8,
  0x0C, 0x30, 0x06, 0xE0, 0xA0, 0xCE, 0x05, 0x80, 0xC2, 0x00, 0xBE, 0x07, 0x08, 0xE0, 0xA8, 0x0C,
  0x10, 0x01, 0xF0, 0x30, 0x4E, 0x0E, 0x80, 0xC1, 0x00, 0x6E, 0x0E, 0x2F, 0x05, 0x80, 0xC0, 0x00,
  0xBE, 0x0A, 0x20, 0xCE, 0x0A, 0x77, 0x77, 0x70, 0x1F, 0x06, 0x20, 0x7E, 0x0E, 0x77, 0x77, 0x70,
  0x5F, 0x01, 0x20, 0x3F, 0x04, 0x77, 0x77, 0x60, 0xAE, 0x0C, 0x40, 0xDE, 0x09, 0x77, 0x77, 0x6F,
  0x07, 0x40, 0x9E, 0x0E, 0x77, 0x77, 0x50, 0x5F, 0x03, 0x40, 0x4F, 0x04, 0x77, 0x77, 0x40, 0xAE,
  0x0D, 0x60, 0xEE, 0x09, 0x77, 0x77, 0x40, 0xEE, 0x08, 0x60, 0xAE, 0x0E, 0x77, 0x77, 0x30, 0x5F,
  0x03, 0x60, 0x5F, 0x04, 0x77, 0x77, 0x20, 0xAE, 0x0E, 0x71, 0xF0, 0x97, 0x77, 0x72, 0x0E, 0xE0,
  0x97, 0x10, 0xBE, 0x0E, 0x77, 0x77, 0x10, 0x4F, 0x04, 0x71, 0x06, 0xF0, 0x47, 0x77, 0x70, 0x9E,
  0x0E, 0x72, 0x01, 0xF0, 0x97, 0x77, 0x70, 0xEE, 0x0A, 0x73, 0x0B, 0xE0, 0xE7, 0x77, 0x60, 0x4F,
  0x05, 0x73, 0x07, 0xF0, 0x37, 0x77, 0x50, 0x9F, 0x01, 0x73, 0x02, 0xF0, 0x87, 0x77, 0x50, 0xEE,
  0x0B, 0x75, 0x0C, 0xE0, 0xD7, 0x77, 0x40, 0x4F, 0x06, 0x75, 0x07, 0xF0, 0x37, 0x77, 0x30, 0x9F,
  0x01, 0x75, 0x02, 0xF0, 0x87, 0x77, 0x30, 0xEE, 0x0C, 0x77, 0x0D, 0xE0, 0xD7, 0x77, 0x20, 0x3F,
  0x07, 0x77, 0x08, 0xF0, 0x37, 0x77, 0x10, 0x8F, 0x02, 0x77, 0x03, 0xF0, 0x87, 0x77, 0x10, 0xDE,
  0x0C, 0x77, 0x20, 0xEE, 0x0D, 0x77, 0x70, 0x3F, 0x08, 0x77, 0x20, 0x9F, 0x03, 0x77, 0x60, 0x8F,
  0xFF, 0xFC, 0x08, 0x77, 0x60, 0xDF, 0xFF, 0xFC, 0x0D, 0x77, 0x50, 0x3F, 0xFF, 0xFE, 0x02, 0x77,
  0x40, 0x8F, 0xFF, 0xFE, 0x07, 0x77, 0x40, 0xDF, 0xFF, 0xFE, 0x0C, 0x77, 0x30, 0x28, 0x0C, 0x0F,
  0x02, 0x77, 0x20, 0x78, 0x0C, 0x0F, 0x07, 0x77, 0x20, 0xDE, 0x0E, 0x77, 0x70, 0x1F, 0x0C, 0x77,
  0x10, 0x2F, 0x0A, 0x77, 0x71, 0x0B, 0xF0, 0x27, 0x70, 0x7F, 0x05, 0x77, 0x71, 0x06, 0xF0, 0x77,
  0x70, 0xCF, 0x77, 0x72, 0x02, 0xF0, 0xC7, 0x60, 0x2F, 0x0B, 0x77, 0x73, 0x0C, 0xF0, 0x17, 0x50,
  0x7F, 0x06, 0x77, 0x73, 0x08, 0xF0, 0x77, 0x50, 0xCF, 0x01, 0x77, 0x73, 0x03, 0xF0, 0xC7, 0x40,
  0x1F, 0x0C, 0x77, 0x75, 0x0D, 0xF0, 0x17, 0x30, 0x7F, 0x07, 0x77, 0x75, 0x09, 0xF0, 0x67, 0x30,
  0xCF, 0x03, 0x77, 0x75, 0x04, 0xF0, 0xB7, 0x20, 0x1F, 0x0D, 0x77, 0x77, 0x0E, 0xF0, 0x17, 0x10,
  0x6F, 0x09, 0x77, 0x77, 0x0A, 0xF0, 0x67, 0x10, 0xBF, 0x04, 0x77, 0x77, 0x05, 0xF0, 0xB7, 0x01,
  0xF0, 0xE7, 0x77, 0x71, 0x01, 0xF9, 0x01, 0x60, 0x6F, 0x0A, 0x77, 0x77, 0x20, 0xBF, 0x06, 0x60,
  0xBF, 0x05, 0x77, 0x77, 0x20, 0x7F, 0x0B, 0x50, 0x1F, 0x90, 0x17, 0x77, 0x72, 0x02, 0xF9, 0x01,
  0x40, 0x6F, 0x0B, 0x77, 0x77, 0x40, 0xDF, 0x05, 0x40, 0xBF, 0x06, 0x77, 0x77, 0x40, 0x8F, 0x0B,
  0x30, 0x1F, 0x90, 0x27, 0x77, 0x74, 0x03, 0xF9, 0x01, 0x80, 0xD3, 0x00, 0x6C, 0x0B, 0x02, 0x80,
  0xD2, 0x00, 0x8D, 0x08, 0x80, 0xD2, 0x00, 0x9D, 0x08, 0x80, 0xD2, 0x00, 0x7D, 0x0A, 0x80, 0xD2,
  0x00, 0x5D, 0x0C, 0x80, 0xD2, 0x00, 0x10, 0xED, 0x02, 0x80, 0xD2, 0x00, 0x9D, 0x08, 0x80, 0xD2,
  0x00, 0x2E, 0x01, 0x80, 0xD2, 0x00, 0x8D, 0x0B, 0x80, 0xD3, 0x00, 0xCD, 0x07, 0x80, 0xD3, 0x0E,
  0x06, 0x80, 0xD2, 0x00, 0x1E, 0x06, 0x80, 0xD2, 0x00, 0x1E, 0x09, 0x80, 0xD3, 0x0E, 0x0E, 0x01,
  0x80, 0xD2, 0x00, 0xBE, 0x81, 0xD6, 0x22, 0x81, 0x13, 0x48, 0x0C, 0x30, 0x06, 0xFE, 0x0B, 0x80,
  0xC4, 0x00, 0xDF, 0xD0, 0xB8, 0x0C, 0x40, 0x02, 0x0E, 0xFC, 0x0B, 0x80, 0xC5, 0x00, 0x20, 0xBF,
  0xB0, 0xB8, 0x0C, 0x70, 0x89, 0x13, 0x8B, 0xDE, 0xFE, 0xDB, 0x83,
  // "ą" (U+0105)
  0x76, 0x85, 0x47, 0x9B, 0xDE, 0xEA, 0x85, 0xEE, 0xCA, 0x85, 0x17, 0x77, 0x18, 0x11, 0x6B, 0xFF,
  0xB8, 0x1C, 0x71, 0x77, 0x30, 0x60, 0xBF, 0xFF, 0xA0, 0x80, 0x17, 0x58, 0x11, 0x8E, 0xFF, 0xFD,
  0x0E, 0x04, 0x73, 0x01, 0xFF, 0xFF, 0xB0, 0x67, 0x30, 0xBF, 0xFF, 0xFB, 0x06, 0x72, 0x04, 0xFC,
  0x87, 0xDB, 0x99, 0x89, 0xAB, 0xEF, 0xD0, 0x37, 0x20, 0xCE, 0x81, 0xC7, 0x37, 0x38, 0x12, 0x8D,
  0xFA, 0x0C, 0x72, 0x05, 0xB8, 0x1E, 0x82, 0x77, 0x20, 0x7F, 0xA0, 0x47, 0x28, 0x1D, 0xE6, 0x77,
  0x60, 0x30, 0xEF, 0x0B, 0x72, 0x03, 0x77, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x77, 0x50, 0xBF, 0x05,
  0x77, 0x77, 0x50, 0x4F, 0x08, 0x77, 0x77, 0x60, 0xEE, 0x0A, 0x77, 0x77, 0x60, 0xCE, 0x0C, 0x77,
  0x77, 0x60, 0x9E, 0x0D, 0x77, 0x77, 0x60, 0x8E, 0x0D, 0x77, 0x77, 0x60, 0x7E, 0x0E, 0x77, 0x77,
  0x60, 0x7E, 0x0E, 0x77, 0x77, 0x60, 0x7E, 0x0E, 0x77, 0x18, 0x62, 0x58, 0xAC, 0xDE, 0xEF, 0xFC,
  0x0E, 0x75, 0x81, 0x5A, 0xEF, 0xFF, 0xD0, 0xE7, 0x28, 0x11, 0x8E, 0xFF, 0xFF, 0x90, 0xE7, 0x10,
  0x60, 0xEF, 0xFF, 0xFB, 0x0E, 0x60, 0x10, 0xBF, 0xFF, 0xFD, 0x0E, 0x50, 0x10, 0xDF, 0xFF, 0xFE,
  0x0E, 0x50, 0xCF, 0xC8, 0x5D, 0x97, 0x43, 0x11, 0x73, 0x07, 0xE0, 0xE4, 0x08, 0xFA, 0x81, 0xE8,
  0x27, 0x73, 0x07, 0xE0, 0xE3, 0x02, 0xFA, 0x09, 0x01, 0x77, 0x50, 0x7E, 0x0E, 0x30, 0x8F, 0x90,
  0x77, 0x77, 0x07, 0xE0, 0xE3, 0x0E, 0xF0, 0x97, 0x77, 0x10, 0x7E, 0x0E, 0x20, 0x3F, 0x0D, 0x77,
  0x72, 0x08, 0xE0, 0xE2, 0x06, 0xF0, 0x87, 0x77, 0x20, 0xAE, 0x0E, 0x20, 0x8F, 0x03, 0x77, 0x72,
  0x0D, 0xE0, 0xE2, 0x0A, 0xF0, 0x17, 0x77, 0x10, 0x1F, 0x0E, 0x20, 0xAF, 0x77, 0x72, 0x07, 0xF0,
  0xE2, 0x0A, 0xF7, 0x77, 0x20, 0xDF, 0x0E, 0x20, 0x9F, 0x02, 0x77, 0x70, 0x7F, 0x90, 0xE2, 0x07,
  0xF0, 0x67, 0x76, 0x04, 0xFA, 0x0E, 0x20, 0x5F, 0x0C, 0x77, 0x50, 0x40, 0xEF, 0xA0, 0xE2, 0x01,
  0xF9, 0x06, 0x77, 0x30, 0x6F, 0xC0, 0xE3, 0x0C, 0xF9, 0x07, 0x77, 0x04, 0x0B, 0xFD, 0x0E, 0x30,
  0x5F, 0xA8, 0x1C, 0x61, 0x71, 0x81, 0x27, 0xCE, 0x0E, 0x0B, 0xE0, 0xE4, 0x0D, 0xFC, 0x86, 0xDA,
  0x98, 0x9A, 0xCE, 0xFA, 0x04, 0x05, 0xE0, 0xE4, 0x03, 0xFF, 0xFE, 0x81, 0x50, 0x3E, 0x0E, 0x50,
  0x5F, 0xFF, 0xB0, 0xE0, 0x42, 0x01, 0xE0, 0xE6, 0x04, 0x0E, 0xFF, 0xF0, 0xC0, 0x24, 0x0E, 0xD0,
  0xE7, 0x01, 0x0A, 0xFF, 0xC0, 0xE0, 0x76, 0x0C, 0xD0, 0xE7, 0x28, 0x13, 0x9E, 0xFE, 0x81, 0xD7,
  0x17, 0x0A, 0xD0, 0xE7, 0x58, 0x93, 0x47, 0xBC, 0xDE, 0xFE, 0xDB, 0x96, 0x27, 0x30, 0x6C, 0x0B,
  0x02, 0x77, 0x77, 0x60, 0x8D, 0x08, 0x77, 0x77, 0x60, 0x9D, 0x08, 0x77, 0x77, 0x60, 0x7D, 0x0A,
  0x77, 0x77, 0x60, 0x5D, 0x0C, 0x77, 0x77, 0x60, 0x10, 0xED, 0x02, 0x77, 0x77, 0x60, 0x9D, 0x08,
  0x77, 0x77, 0x60, 0x2E, 0x01, 0x77, 0x77, 0x60, 0x8D, 0x0B, 0x77, 0x77, 0x70, 0xCD, 0x07, 0x77,
  0x77, 0x7E, 0x06, 0x77, 0x77, 0x60, 0x1E, 0x06, 0x77, 0x77, 0x60, 0x1E, 0x09, 0x77, 0x77, 0x7E,
  0x0E, 0x01, 0x77, 0x77, 0x60, 0xBE, 0x81, 0xD6, 0x22, 0x81, 0x13, 0x47, 0x77, 0x60, 0x6F, 0xE0,
  0xB7, 0x77, 0x70, 0xDF, 0xD0, 0xB7, 0x77, 0x70, 0x20, 0xEF, 0xC0, 0xB7, 0x77, 0x71, 0x02, 0x0B,
  0xFB, 0x0B, 0x77, 0x77, 0x38, 0x91, 0x38, 0xBD, 0xEF, 0xED, 0xB8, 0x30,
  // "Ć" (U+0106)
  0x77, 0x77, 0x20, 0x38, 0x05, 0x70, 0x17, 0x77, 0x75, 0x0C, 0xFA, 0x02, 0x77, 0x77, 0x40, 0x5F,
  0xA0, 0x87, 0x77, 0x75, 0x0D, 0xF9, 0x0B, 0x77, 0x77, 0x50, 0x8F, 0x90, 0xD0, 0x17, 0x77, 0x74,
  0x02, 0xF9, 0x0E, 0x02, 0x77, 0x77, 0x50, 0xCF, 0x0E, 0x03, 0x77, 0x77, 0x50, 0x6F, 0x90, 0x47,
  0x77, 0x75, 0x01, 0x0E, 0xF0, 0x57, 0x77, 0x76, 0x0B, 0xF0, 0x57, 0x77, 0x76, 0x05, 0xF0, 0x67,
  0x77, 0x76, 0x01, 0x0E, 0xE0, 0x57, 0x77, 0x77, 0x0B, 0xE0, 0x57, 0x77, 0x77, 0x08, 0xD0, 0xE0,
  0x48, 0x0C, 0x00, 0x0D, 0xC0, 0xC0, 0x28, 0x0B, 0xF2, 0x08, 0x97, 0x14, 0x7A, 0xCD, 0xDE, 0xFE,
  0xDC, 0xB9, 0x74, 0x17, 0x77, 0x38, 0x11, 0x6B, 0xFF, 0xB8, 0x1D, 0x94, 0x77, 0x50, 0x20, 0xAF,
  0xFF, 0xA8, 0x1E, 0x92, 0x77, 0x01, 0x09, 0xFF, 0xFF, 0x0B, 0x02, 0x74, 0x04, 0x0E, 0xFF, 0xFF,
  0xA0, 0x27, 0x30, 0x8F, 0xFF, 0xFB, 0x0B, 0x73, 0x0A, 0xFF, 0xFF, 0xC0, 0x47, 0x20, 0xAF, 0xD8,
  0x3C, 0x85, 0x21, 0x28, 0x41, 0x23, 0x6A, 0xDF, 0x0D, 0x72, 0x09, 0xFB, 0x81, 0xE8, 0x17, 0x68,
  0x12, 0x7D, 0xC0, 0x77, 0x10, 0x6F, 0xB0, 0x90, 0x17, 0x74, 0x83, 0x4C, 0xFE, 0x17, 0x02, 0x0E,
  0xF9, 0x0E, 0x04, 0x77, 0x71, 0x05, 0x07, 0x71, 0x0C, 0xF9, 0x0E, 0x03, 0x77, 0x77, 0x40, 0x6F,
  0x90, 0xE0, 0x37, 0x77, 0x75, 0x0D, 0xF9, 0x05, 0x77, 0x77, 0x50, 0x6F, 0x90, 0x97, 0x77, 0x76,
  0x0D, 0xF0, 0xE0, 0x17, 0x77, 0x75, 0x04, 0xF9, 0x07, 0x77, 0x77, 0x60, 0x9F, 0x0E, 0x77, 0x77,
  0x70, 0xEF, 0x09, 0x77, 0x77, 0x60, 0x4F, 0x90, 0x37, 0x77, 0x76, 0x08, 0xF0, 0xD7, 0x77, 0x77,
  0x0C, 0xF0, 0x97, 0x77, 0x77, 0xF9, 0x05, 0x77, 0x77, 0x60, 0x3F, 0x90, 0x17, 0x77, 0x76, 0x06,
  0xF0, 0xE7, 0x77, 0x77, 0x08, 0xF0, 0xB7, 0x77, 0x77, 0x0A, 0xF0, 0x97, 0x77, 0x77, 0x0C, 0xF0,
  0x77, 0x77, 0x77, 0x0D, 0xF0, 0x67, 0x77, 0x77, 0x0E, 0xF0, 0x57, 0x77, 0x77, 0x0E, 0xF0, 0x47,
  0x77, 0x77, 0xF9, 0x04, 0x77, 0x77, 0x7F, 0x90, 0x37, 0x77, 0x77, 0xF9, 0x03, 0x77, 0x77, 0x7F,
  0x90, 0x37, 0x77, 0x77, 0xF9, 0x04, 0x77, 0x77, 0x70, 0xEF, 0x04, 0x77, 0x77, 0x70, 0xDF, 0x06,
  0x77, 0x77, 0x70, 0xCF, 0x07, 0x77, 0x77, 0x70, 0xAF, 0x08, 0x77, 0x77, 0x70, 0x8F, 0x0A, 0x77,
  0x77, 0x70, 0x6F, 0x0D, 0x77, 0x77, 0x70, 0x4F, 0x97, 0x77, 0x77, 0x01, 0xF9, 0x03, 0x77, 0x77,
  0x70, 0xDF, 0x07, 0x77, 0x77, 0x70, 0xAF, 0x0B, 0x77, 0x77, 0x70, 0x6F, 0x97, 0x77, 0x77, 0x01,
  0xF9, 0x05, 0x77, 0x77, 0x70, 0xCF, 0x0B, 0x77, 0x77, 0x70, 0x7F, 0x90, 0x37, 0x77, 0x76, 0x02,
  0xF9, 0x0A, 0x77, 0x77, 0x70, 0xAF, 0x90, 0x47, 0x77, 0x76, 0x03, 0xF9, 0x0D, 0x77, 0x77, 0x70,
  0xBF, 0x90, 0xA7, 0x77, 0x76, 0x02, 0xFA, 0x08, 0x77, 0x77, 0x60, 0x7F, 0xA0, 0x97, 0x77, 0x76,
  0x0C, 0xFA, 0x0C, 0x03, 0x77, 0x70, 0x50, 0x77, 0x20, 0x20, 0xEF, 0xB0, 0xB0, 0x47, 0x71, 0x84,
  0x25, 0xAE, 0xFA, 0x73, 0x03, 0x0E, 0xFC, 0x84, 0xEA, 0x64, 0x21, 0x28, 0x51, 0x23, 0x57, 0xAD,
  0xD0, 0xA7, 0x40, 0x40, 0xEF, 0xFF, 0xFA, 0x0A, 0x75, 0x03, 0x0D, 0xFF, 0xFF, 0x90, 0xA7, 0x60,
  0x10, 0xCF, 0xFF, 0xF0, 0xA7, 0x71, 0x07, 0x0E, 0xFF, 0xFD, 0x0A, 0x77, 0x28, 0x11, 0x8E, 0xFF,
  0xFA, 0x0E, 0x07, 0x77, 0x50, 0x50, 0xAF, 0xFC, 0x81, 0xC8, 0x37, 0x77, 0x38, 0x43, 0x69, 0xBD,
  0xEB, 0x85, 0xED, 0xDB, 0x97, 0x47, 0x20,
  // "ć" (U+0107)
  0x77, 0x76, 0x03, 0x80, 0x57, 0x01, 0x77, 0x77, 0x0C, 0xFA, 0x02, 0x77, 0x76, 0x05, 0xFA, 0x08,
  0x77, 0x77, 0x0D, 0xF9, 0x0B, 0x77, 0x77, 0x08, 0xF9, 0x0D, 0x01, 0x77, 0x76, 0x02, 0xF9, 0x0E,
  0x02, 0x77, 0x77, 0x0C, 0xF0, 0xE0, 0x37, 0x77, 0x70, 0x6F, 0x90, 0x47, 0x77, 0x70, 0x10, 0xEF,
  0x05, 0x77, 0x77, 0x10, 0xBF, 0x05, 0x77, 0x77, 0x10, 0x5F, 0x06, 0x77, 0x77, 0x10, 0x10, 0xEE,
  0x05, 0x77, 0x77, 0x20, 0xBE, 0x05, 0x77, 0x77, 0x20, 0x8D, 0x0E, 0x04, 0x77, 0x77, 0x30, 0xDC,
  0x0C, 0x02, 0x80, 0xBB, 0x50, 0x84, 0x47, 0x9C, 0xDE, 0xA8, 0x5E, 0xDC, 0xB9, 0x63, 0x77, 0x68,
  0x11, 0x7C, 0xFF, 0xB8, 0x1B, 0x61, 0x77, 0x03, 0x0A, 0xFF, 0xFA, 0x0A, 0x03, 0x73, 0x01, 0x0A,
  0xFF, 0xFE, 0x04, 0x71, 0x04, 0x0E, 0xFF, 0xFE, 0x0E, 0x71, 0x06, 0xFF, 0xFF, 0x90, 0x97, 0x06,
  0xFE, 0x87, 0xDB, 0x99, 0x89, 0xAB, 0xEF, 0x90, 0x36, 0x04, 0xFC, 0x81, 0xB5, 0x17, 0x28, 0x11,
  0x5B, 0xC0, 0xD6, 0x01, 0x0E, 0xFA, 0x0A, 0x02, 0x77, 0x18, 0x31, 0x7E, 0xF7, 0x60, 0xAF, 0xA0,
  0x57, 0x75, 0x81, 0x18, 0x25, 0x04, 0xFA, 0x04, 0x77, 0x77, 0x0B, 0xF9, 0x06, 0x77, 0x77, 0x03,
  0xF9, 0x0B, 0x77, 0x77, 0x10, 0x9F, 0x90, 0x27, 0x77, 0x71, 0x0E, 0xF0, 0xB7, 0x77, 0x71, 0x02,
  0xF9, 0x05, 0x77, 0x77, 0x10, 0x7F, 0x97, 0x77, 0x72, 0x0A, 0xF0, 0xB7, 0x77, 0x72, 0x0C, 0xF0,
  0x87, 0x77, 0x72, 0x0E, 0xF0, 0x57, 0x77, 0x71, 0x01, 0xF9, 0x03, 0x77, 0x77, 0x10, 0x2F, 0x90,
  0x17, 0x77, 0x71, 0x03, 0xF9, 0x77, 0x77, 0x20, 0x4F, 0x97, 0x77, 0x72, 0x04, 0xF0, 0xE7, 0x77,
  0x72, 0x05, 0xF0, 0xE7, 0x77, 0x72, 0x04, 0xF9, 0x77, 0x77, 0x20, 0x4F, 0x97, 0x77, 0x72, 0x03,
  0xF9, 0x01, 0x77, 0x77, 0x10, 0x2F, 0x90, 0x27, 0x77, 0x72, 0xF9, 0x04, 0x77, 0x77, 0x20, 0xEF,
  0x06, 0x77, 0x77, 0x20, 0xCF, 0x0A, 0x77, 0x77, 0x20, 0x9F, 0x0D, 0x77, 0x77, 0x20, 0x6F, 0x90,
  0x37, 0x77, 0x71, 0x01, 0xF9, 0x08, 0x77, 0x77, 0x20, 0xDF, 0x0E, 0x77, 0x77, 0x20, 0x7F, 0x90,
  0x87, 0x77, 0x71, 0x01, 0xFA, 0x03, 0x77, 0x77, 0x10, 0x9F, 0x90, 0xE0, 0x27, 0x77, 0x70, 0x2F,
  0xA0, 0xE0, 0x47, 0x77, 0x10, 0x45, 0x07, 0xFB, 0x09, 0x01, 0x77, 0x38, 0x23, 0x8D, 0xE6, 0x0B,
  0xFC, 0x81, 0xA5, 0x17, 0x38, 0x22, 0x59, 0xDB, 0x0E, 0x60, 0x10, 0xDF, 0xE8, 0x7D, 0xB9, 0x88,
  0x9A, 0xBC, 0xF9, 0x0E, 0x70, 0x10, 0xCF, 0xFF, 0xF9, 0x0E, 0x72, 0x0A, 0xFF, 0xFF, 0x0E, 0x73,
  0x05, 0x0E, 0xFF, 0xFD, 0x0E, 0x75, 0x08, 0x0E, 0xFF, 0xFB, 0x09, 0x77, 0x05, 0x0B, 0xFF, 0xC8,
  0x1D, 0x95, 0x77, 0x58, 0x44, 0x7A, 0xBD, 0xEA, 0x87, 0xEE, 0xDC, 0xA8, 0x64, 0x16,
  // "Ĉ" (U+0108)
  0x77, 0x70, 0x28, 0x04, 0x77, 0x77, 0x77, 0x0C, 0xF9, 0x08, 0x77, 0x77, 0x50, 0x6F, 0xB0, 0x37,
  0x77, 0x73, 0x03, 0xFC, 0x0D, 0x01, 0x77, 0x77, 0x20, 0xDF, 0xD0, 0xA7, 0x77, 0x71, 0x0B, 0xFF,
  0x07, 0x77, 0x76, 0x08, 0xF0, 0xA0, 0xDF, 0x05, 0x77, 0x74, 0x06, 0xF8, 0x29, 0x01, 0xDF, 0x03,
  0x77, 0x72, 0x04, 0xF0, 0x93, 0x01, 0x0D, 0xE0, 0xE0, 0x27, 0x77, 0x02, 0x0E, 0xE0, 0x95, 0x01,
  0x0C, 0xE0, 0xD0, 0x17, 0x75, 0x01, 0x0D, 0xE0, 0x87, 0x01, 0x0C, 0xE0, 0xC7, 0x75, 0x0C, 0xE0,
  0x87, 0x20, 0x10, 0xBE, 0x0B, 0x77, 0x30, 0xBE, 0x06, 0x75, 0x0A, 0xE0, 0xA7, 0x71, 0x0A, 0xD0,
  0xE0, 0x47, 0x70, 0x7E, 0x0A, 0x76, 0x03, 0xD0, 0xB0, 0x17, 0x72, 0x03, 0x0D, 0xD0, 0x38, 0x0B,
  0xD5, 0x08, 0x97, 0x14, 0x7A, 0xCD, 0xDE, 0xFE, 0xDC, 0xB9, 0x74, 0x17, 0x77, 0x38, 0x11, 0x6B,
  0xFF, 0xB8, 0x1D, 0x94, 0x77, 0x50, 0x20, 0xAF, 0xFF, 0xA8, 0x1E, 0x92, 0x77, 0x01, 0x09, 0xFF,
  0xFF, 0x0B, 0x02, 0x74, 0x04, 0x0E, 0xFF, 0xFF, 0xA0, 0x27, 0x30, 0x8F, 0xFF, 0xFB, 0x0B, 0x73,
  0x0A, 0xFF, 0xFF, 0xC0, 0x47, 0x20, 0xAF, 0xD8, 0x3C, 0x85, 0x21, 0x28, 0x41, 0x23, 0x6A, 0xDF,
  0x0D, 0x72, 0x09, 0xFB, 0x81, 0xE8, 0x17, 0x68, 0x12, 0x7D, 0xC0, 0x77, 0x10, 0x6F, 0xB0, 0x90,
  0x17, 0x74, 0x83, 0x4C, 0xFE, 0x17, 0x02, 0x0E, 0xF9, 0x0E, 0x04, 0x77, 0x71, 0x05, 0x07, 0x71,
  0x0C, 0xF9, 0x0E, 0x03, 0x77, 0x77, 0x40, 0x6F, 0x90, 0xE0, 0x37, 0x77, 0x75, 0x0D, 0xF9, 0x05,
  0x77, 0x77, 0x50, 0x6F, 0x90, 0x97, 0x77, 0x76, 0x0D, 0xF0, 0xE0, 0x17, 0x77, 0x75, 0x04, 0xF9,
  0x07, 0x77, 0x77, 0x60, 0x9F, 0x0E, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x60, 0x4F, 0x90,
  0x37, 0x77, 0x76, 0x08, 0xF0, 0xD7, 0x77, 0x77, 0x0C, 0xF0, 0x97, 0x77, 0x77, 0xF9, 0x05, 0x77,
  0x77, 0x60, 0x3F, 0x90, 0x17, 0x77, 0x76, 0x06, 0xF0, 0xE7, 0x77, 0x77, 0x08, 0xF0, 0xB7, 0x77,
  0x77, 0x0A, 0xF0, 0x97, 0x77, 0x77, 0x0C, 0xF0, 0x77, 0x77, 0x77, 0x0D, 0xF0, 0x67, 0x77, 0x77,
  0x0E, 0xF0, 0x57, 0x77, 0x77, 0x0E, 0xF0, 0x47, 0x77, 0x77, 0xF9, 0x04, 0x77, 0x77, 0x7F, 0x90,
  0x37, 0x77, 0x77, 0xF9, 0x03, 0x77, 0x77, 0x7F, 0x90, 0x37, 0x77, 0x77, 0xF9, 0x04, 0x77, 0x77,
  0x70, 0xEF, 0x04, 0x77, 0x77, 0x70, 0xDF, 0x06, 0x77, 0x77, 0x70, 0xCF, 0x07, 0x77, 0x77, 0x70,
  0xAF, 0x08, 0x77, 0x77, 0x70, 0x8F, 0x0A, 0x77, 0x77, 0x70, 0x6F, 0x0D, 0x77, 0x77, 0x70, 0x4F,
  0x97, 0x77, 0x77, 0x01, 0xF9, 0x03, 0x77, 0x77, 0x70, 0xDF, 0x07, 0x77, 0x77, 0x70, 0xAF, 0x0B,
  0x77, 0x77, 0x70, 0x6F, 0x97, 0x77, 0x77, 0x01, 0xF9, 0x05, 0x77, 0x77, 0x70, 0xCF, 0x0B, 0x77,
  0x77, 0x70, 0x7F, 0x90, 0x37, 0x77, 0x76, 0x02, 0xF9, 0x0A, 0x77, 0x77, 0x70, 0xAF, 0x90, 0x47,
  0x77, 0x76, 0x03, 0xF9, 0x0D, 0x77, 0x77, 0x70, 0xBF, 0x90, 0xA7, 0x77, 0x76, 0x02, 0xFA, 0x08,
  0x77, 0x77, 0x60, 0x7F, 0xA0, 0x97, 0x77, 0x76, 0x0C, 0xFA, 0x0C, 0x03, 0x77, 0x70, 0x50, 0x77,
  0x20, 0x20, 0xEF, 0xB0, 0xB0, 0x47, 0x71, 0x84, 0x25, 0xAE, 0xFA, 0x73, 0x03, 0x0E, 0xFC, 0x84,
  0xEA, 0x64, 0x21, 0x28, 0x51, 0x23, 0x57, 0xAD, 0xD0, 0xA7, 0x40, 0x40, 0xEF, 0xFF, 0xFA, 0x0A,
  0x75, 0x03, 0x0D, 0xFF, 0xFF, 0x90, 0xA7, 0x60, 0x10, 0xCF, 0xFF, 0xF0, 0xA7, 0x71, 0x07, 0x0E,
  0xFF, 0xFD, 0x0A, 0x77, 0x28, 0x11, 0x8E, 0xFF, 0xFA, 0x0E, 0x07, 0x77, 0x50, 0x50, 0xAF, 0xFC,
  0x81, 0xC8, 0x37, 0x77, 0x38, 0x43, 0x69, 0xBD, 0xEB, 0x85, 0xED, 0xDB, 0x97, 0x47, 0x20,
  // "ĉ" (U+0109)
  0x77, 0x40, 0x28, 0x04, 0x77, 0x77, 0x72, 0x0C, 0xF9, 0x08, 0x77, 0x77, 0x06, 0xFB, 0x03, 0x77,
  0x75, 0x03, 0xFC, 0x0D, 0x01, 0x77, 0x74, 0x0D, 0xFD, 0x0A, 0x77, 0x73, 0x0B, 0xFF, 0x07, 0x77,
  0x71, 0x08, 0xF0, 0xA0, 0xDF, 0x05, 0x77, 0x60, 0x6F, 0x82, 0x90, 0x1D, 0xF0, 0x37, 0x74, 0x04,
  0xF0, 0x93, 0x01, 0x0D, 0xE0, 0xE0, 0x27, 0x72, 0x02, 0x0E, 0xE0, 0x95, 0x01, 0x0C, 0xE0, 0xD0,
  0x17, 0x70, 0x10, 0xDE, 0x08, 0x70, 0x10, 0xCE, 0x0C, 0x77, 0x0C, 0xE0, 0x87, 0x20, 0x10, 0xBE,
  0x0B, 0x75, 0x0B, 0xE0, 0x67, 0x50, 0xAE, 0x0A, 0x73, 0x0A, 0xD0, 0xE0, 0x47, 0x70, 0x7E, 0x0A,
  0x71, 0x03, 0xD0, 0xB0, 0x17, 0x72, 0x03, 0x0D, 0xD0, 0x38, 0x0B, 0xA0, 0x08, 0x44, 0x79, 0xCD,
  0xEA, 0x85, 0xED, 0xCB, 0x96, 0x37, 0x76, 0x81, 0x17, 0xCF, 0xFB, 0x81, 0xB6, 0x17, 0x70, 0x30,
  0xAF, 0xFF, 0xA0, 0xA0, 0x37, 0x30, 0x10, 0xAF, 0xFF, 0xE0, 0x47, 0x10, 0x40, 0xEF, 0xFF, 0xE0,
  0xE7, 0x10, 0x6F, 0xFF, 0xF9, 0x09, 0x70, 0x6F, 0xE8, 0x7D, 0xB9, 0x98, 0x9A, 0xBE, 0xF9, 0x03,
  0x60, 0x4F, 0xC8, 0x1B, 0x51, 0x72, 0x81, 0x15, 0xBC, 0x0D, 0x60, 0x10, 0xEF, 0xA0, 0xA0, 0x27,
  0x71, 0x83, 0x17, 0xEF, 0x76, 0x0A, 0xFA, 0x05, 0x77, 0x58, 0x11, 0x82, 0x50, 0x4F, 0xA0, 0x47,
  0x77, 0x70, 0xBF, 0x90, 0x67, 0x77, 0x70, 0x3F, 0x90, 0xB7, 0x77, 0x71, 0x09, 0xF9, 0x02, 0x77,
  0x77, 0x10, 0xEF, 0x0B, 0x77, 0x77, 0x10, 0x2F, 0x90, 0x57, 0x77, 0x71, 0x07, 0xF9, 0x77, 0x77,
  0x20, 0xAF, 0x0B, 0x77, 0x77, 0x20, 0xCF, 0x08, 0x77, 0x77, 0x20, 0xEF, 0x05, 0x77, 0x77, 0x10,
  0x1F, 0x90, 0x37, 0x77, 0x71, 0x02, 0xF9, 0x01, 0x77, 0x77, 0x10, 0x3F, 0x97, 0x77, 0x72, 0x04,
  0xF9, 0x77, 0x77, 0x20, 0x4F, 0x0E, 0x77, 0x77, 0x20, 0x5F, 0x0E, 0x77, 0x77, 0x20, 0x4F, 0x97,
  0x77, 0x72, 0x04, 0xF9, 0x77, 0x77, 0x20, 0x3F, 0x90, 0x17, 0x77, 0x71, 0x02, 0xF9, 0x02, 0x77,
  0x77, 0x2F, 0x90, 0x47, 0x77, 0x72, 0x0E, 0xF0, 0x67, 0x77, 0x72, 0x0C, 0xF0, 0xA7, 0x77, 0x72,
  0x09, 0xF0, 0xD7, 0x77, 0x72, 0x06, 0xF9, 0x03, 0x77, 0x77, 0x10, 0x1F, 0x90, 0x87, 0x77, 0x72,
  0x0D, 0xF0, 0xE7, 0x77, 0x72, 0x07, 0xF9, 0x08, 0x77, 0x77, 0x10, 0x1F, 0xA0, 0x37, 0x77, 0x71,
  0x09, 0xF9, 0x0E, 0x02, 0x77, 0x77, 0x02, 0xFA, 0x0E, 0x04, 0x77, 0x71, 0x04, 0x50, 0x7F, 0xB0,
  0x90, 0x17, 0x73, 0x82, 0x38, 0xDE, 0x60, 0xBF, 0xC8, 0x1A, 0x51, 0x73, 0x82, 0x25, 0x9D, 0xB0,
  0xE6, 0x01, 0x0D, 0xFE, 0x87, 0xDB, 0x98, 0x89, 0xAB, 0xCF, 0x90, 0xE7, 0x01, 0x0C, 0xFF, 0xFF,
  0x90, 0xE7, 0x20, 0xAF, 0xFF, 0xF0, 0xE7, 0x30, 0x50, 0xEF, 0xFF, 0xD0, 0xE7, 0x50, 0x80, 0xEF,
  0xFF, 0xB0, 0x97, 0x70, 0x50, 0xBF, 0xFC, 0x81, 0xD9, 0x57, 0x75, 0x84, 0x47, 0xAB, 0xDE, 0xA8,
  0x7E, 0xED, 0xCA, 0x86, 0x41, 0x60,
  // "Ċ" (U+010A)
  0x77, 0x71, 0x86, 0x18, 0xCE, 0xEC, 0x71, 0x77, 0x77, 0x70, 0x30, 0xEE, 0x0E, 0x03, 0x77, 0x77,
  0x60, 0xEF, 0x90, 0xD7, 0x77, 0x75, 0x05, 0xFB, 0x05, 0x77, 0x77, 0x40, 0x9F, 0xB0, 0x97, 0x77,
  0x74, 0x0A, 0xFB, 0x0A, 0x77, 0x77, 0x40, 0x9F, 0xB0, 0x97, 0x77, 0x74, 0x05, 0xFB, 0x05, 0x77,
  0x77, 0x50, 0xDF, 0x90, 0xD7, 0x77, 0x76, 0x03, 0x0E, 0xE0, 0xD0, 0x27, 0x77, 0x77, 0x86, 0x17,
  0xCE, 0xEC, 0x71, 0x80, 0xDF, 0x50, 0x89, 0x71, 0x47, 0xAC, 0xDD, 0xEF, 0xED, 0xCB, 0x97, 0x41,
  0x77, 0x73, 0x81, 0x16, 0xBF, 0xFB, 0x81, 0xD9, 0x47, 0x75, 0x02, 0x0A, 0xFF, 0xFA, 0x81, 0xE9,
  0x27, 0x70, 0x10, 0x9F, 0xFF, 0xF0, 0xB0, 0x27, 0x40, 0x40, 0xEF, 0xFF, 0xFA, 0x02, 0x73, 0x08,
  0xFF, 0xFF, 0xB0, 0xB7, 0x30, 0xAF, 0xFF, 0xFC, 0x04, 0x72, 0x0A, 0xFD, 0x83, 0xC8, 0x52, 0x12,
  0x84, 0x12, 0x36, 0xAD, 0xF0, 0xD7, 0x20, 0x9F, 0xB8, 0x1E, 0x81, 0x76, 0x81, 0x27, 0xDC, 0x07,
  0x71, 0x06, 0xFB, 0x09, 0x01, 0x77, 0x48, 0x34, 0xCF, 0xE1, 0x70, 0x20, 0xEF, 0x90, 0xE0, 0x47,
  0x77, 0x10, 0x50, 0x77, 0x10, 0xCF, 0x90, 0xE0, 0x37, 0x77, 0x74, 0x06, 0xF9, 0x0E, 0x03, 0x77,
  0x77, 0x50, 0xDF, 0x90, 0x57, 0x77, 0x75, 0x06, 0xF9, 0x09, 0x77, 0x77, 0x60, 0xDF, 0x0E, 0x01,
  0x77, 0x77, 0x50, 0x4F, 0x90, 0x77, 0x77, 0x76, 0x09, 0xF0, 0xE7, 0x77, 0x77, 0x0E, 0xF0, 0x97,
  0x77, 0x76, 0x04, 0xF9, 0x03, 0x77, 0x77, 0x60, 0x8F, 0x0D, 0x77, 0x77, 0x70, 0xCF, 0x09, 0x77,
  0x77, 0x7F, 0x90, 0x57, 0x77, 0x76, 0x03, 0xF9, 0x01, 0x77, 0x77, 0x60, 0x6F, 0x0E, 0x77, 0x77,
  0x70, 0x8F, 0x0B, 0x77, 0x77, 0x70, 0xAF, 0x09, 0x77, 0x77, 0x70, 0xCF, 0x07, 0x77, 0x77, 0x70,
  0xDF, 0x06, 0x77, 0x77, 0x70, 0xEF, 0x05, 0x77, 0x77, 0x70, 0xEF, 0x04, 0x77, 0x77, 0x7F, 0x90,
  0x47, 0x77, 0x77, 0xF9, 0x03, 0x77, 0x77, 0x7F, 0x90, 0x37, 0x77, 0x77, 0xF9, 0x03, 0x77, 0x77,
  0x7F, 0x90, 0x47, 0x77, 0x77, 0x0E, 0xF0, 0x47, 0x77, 0x77, 0x0D, 0xF0, 0x67, 0x77, 0x77, 0x0C,
  0xF0, 0x77, 0x77, 0x77, 0x0A, 0xF0, 0x87, 0x77, 0x77, 0x08, 0xF0, 0xA7, 0x77, 0x77, 0x06, 0xF0,
  0xD7, 0x77, 0x77, 0x04, 0xF9, 0x77, 0x77, 0x70, 0x1F, 0x90, 0x37, 0x77, 0x77, 0x0D, 0xF0, 0x77,
  0x77, 0x77, 0x0A, 0xF0, 0xB7, 0x77, 0x77, 0x06, 0xF9, 0x77, 0x77, 0x70, 0x1F, 0x90, 0x57, 0x77,
  0x77, 0x0C, 0xF0, 0xB7, 0x77, 0x77, 0x07, 0xF9, 0x03, 0x77, 0x77, 0x60, 0x2F, 0x90, 0xA7, 0x77,
  0x77, 0x0A, 0xF9, 0x04, 0x77, 0x77, 0x60, 0x3F, 0x90, 0xD7, 0x77, 0x77, 0x0B, 0xF9, 0x0A, 0x77,
  0x77, 0x60, 0x2F, 0xA0, 0x87, 0x77, 0x76, 0x07, 0xFA, 0x09, 0x77, 0x77, 0x60, 0xCF, 0xA0, 0xC0,
  0x37, 0x77, 0x05, 0x07, 0x72, 0x02, 0x0E, 0xFB, 0x0B, 0x04, 0x77, 0x18, 0x42, 0x5A, 0xEF, 0xA7,
  0x30, 0x30, 0xEF, 0xC8, 0x4E, 0xA6, 0x42, 0x12, 0x85, 0x12, 0x35, 0x7A, 0xDD, 0x0A, 0x74, 0x04,
  0x0E, 0xFF, 0xFF, 0xA0, 0xA7, 0x50, 0x30, 0xDF, 0xFF, 0xF9, 0x0A, 0x76, 0x01, 0x0C, 0xFF, 0xFF,
  0x0A, 0x77, 0x10, 0x70, 0xEF, 0xFF, 0xD0, 0xA7, 0x72, 0x81, 0x18, 0xEF, 0xFF, 0xA0, 0xE0, 0x77,
  0x75, 0x05, 0x0A, 0xFF, 0xC8, 0x1C, 0x83, 0x77, 0x73, 0x84, 0x36, 0x9B, 0xDE, 0xB8, 0x5E, 0xDD,
  0xB9, 0x74, 0x72,
  // "ċ" (U+010B)
  0x77, 0x58, 0x61, 0x8C, 0xEE, 0xC7, 0x17, 0x77, 0x72, 0x03, 0x0E, 0xE0, 0xE0, 0x37, 0x77, 0x71,
  0x0E, 0xF9, 0x0D, 0x77, 0x77, 0x05, 0xFB, 0x05, 0x77, 0x76, 0x09, 0xFB, 0x09, 0x77, 0x76, 0x0A,
  0xFB, 0x0A, 0x77, 0x76, 0x09, 0xFB, 0x09, 0x77, 0x76, 0x05, 0xFB, 0x05, 0x77, 0x77, 0x0D, 0xF9,
  0x0D, 0x77, 0x77, 0x10, 0x30, 0xEE, 0x0D, 0x02, 0x77, 0x77, 0x28, 0x61, 0x7C, 0xEE, 0xC7, 0x18,
  0x0D, 0xA1, 0x08, 0x44, 0x79, 0xCD, 0xEA, 0x85, 0xED, 0xCB, 0x96, 0x37, 0x76, 0x81, 0x17, 0xCF,
  0xFB, 0x81, 0xB6, 0x17, 0x70, 0x30, 0xAF, 0xFF, 0xA0, 0xA0, 0x37, 0x30, 0x10, 0xAF, 0xFF, 0xE0,
  0x47, 0x10, 0x40, 0xEF, 0xFF, 0xE0, 0xE7, 0x10, 0x6F, 0xFF, 0xF9, 0x09, 0x70, 0x6F, 0xE8, 0x7D,
  0xB9, 0x98, 0x9A, 0xBE, 0xF9, 0x03, 0x60, 0x4F, 0xC8, 0x1B, 0x51, 0x72, 0x81, 0x15, 0xBC, 0x0D,
  0x60, 0x10, 0xEF, 0xA0, 0xA0, 0x27, 0x71, 0x83, 0x17, 0xEF, 0x76, 0x0A, 0xFA, 0x05, 0x77, 0x58,
  0x11, 0x82, 0x50, 0x4F, 0xA0, 0x47, 0x77, 0x70, 0xBF, 0x90, 0x67, 0x77, 0x70, 0x3F, 0x90, 0xB7,
  0x77, 0x71, 0x09, 0xF9, 0x02, 0x77, 0x77, 0x10, 0xEF, 0x0B, 0x77, 0x77, 0x10, 0x2F, 0x90, 0x57,
  0x77, 0x71, 0x07, 0xF9, 0x77, 0x77, 0x20, 0xAF, 0x0B, 0x77, 0x77, 0x20, 0xCF, 0x08, 0x77, 0x77,
  0x20, 0xEF, 0x05, 0x77, 0x77, 0x10, 0x1F, 0x90, 0x37, 0x77, 0x71, 0x02, 0xF9, 0x01, 0x77, 0x77,
  0x10, 0x3F, 0x97, 0x77, 0x72, 0x04, 0xF9, 0x77, 0x77, 0x20, 0x4F, 0x0E, 0x77, 0x77, 0x20, 0x5F,
  0x0E, 0x77, 0x77, 0x20, 0x4F, 0x97, 0x77, 0x72, 0x04, 0xF9, 0x77, 0x77, 0x20, 0x3F, 0x90, 0x17,
  0x77, 0x71, 0x02, 0xF9, 0x02, 0x77, 0x77, 0x2F, 0x90, 0x47, 0x77, 0x72, 0x0E, 0xF0, 0x67, 0x77,
  0x72, 0x0C, 0xF0, 0xA7, 0x77, 0x72, 0x09, 0xF0, 0xD7, 0x77, 0x72, 0x06, 0xF9, 0x03, 0x77, 0x77,
  0x10, 0x1F, 0x90, 0x87, 0x77, 0x72, 0x0D, 0xF0, 0xE7, 0x77, 0x72, 0x07, 0xF9, 0x08, 0x77, 0x77,
  0x10, 0x1F, 0xA0, 0x37, 0x77, 0x71, 0x09, 0xF9, 0x0E, 0x02, 0x77, 0x77, 0x02, 0xFA, 0x0E, 0x04,
  0x77, 0x71, 0x04, 0x50, 0x7F, 0xB0, 0x90, 0x17, 0x73, 0x82, 0x38, 0xDE, 0x60, 0xBF, 0xC8, 0x1A,
  0x51, 0x73, 0x82, 0x25, 0x9D, 0xB0, 0xE6, 0x01, 0x0D, 0xFE, 0x87, 0xDB, 0x98, 0x89, 0xAB, 0xCF,
  0x90, 0xE7, 0x01, 0x0C, 0xFF, 0xFF, 0x90, 0xE7, 0x20, 0xAF, 0xFF, 0xF0, 0xE7, 0x30, 0x50, 0xEF,
  0xFF, 0xD0, 0xE7, 0x50, 0x80, 0xEF, 0xFF, 0xB0, 0x97, 0x70, 0x50, 0xBF, 0xFC, 0x81, 0xD9, 0x57,
  0x75, 0x84, 0x47, 0xAB, 0xDE, 0xA8, 0x7E, 0xED, 0xCA, 0x86, 0x41, 0x60,
  // "Č" (U+010C)
  0x73, 0x01, 0x80, 0x17, 0x04, 0x77, 0x40, 0x58, 0x01, 0x70, 0x17, 0x50, 0x2E, 0x08, 0x77, 0x10,
  0x10, 0xAE, 0x02, 0x76, 0x08, 0xE0, 0xC0, 0x17, 0x50, 0x30, 0xDE, 0x08, 0x77, 0x10, 0x9E, 0x0D,
  0x03, 0x73, 0x05, 0x0E, 0xE0, 0x87, 0x73, 0x0A, 0xF0, 0x57, 0x10, 0x7F, 0x09, 0x77, 0x50, 0xBF,
  0x06, 0x60, 0x9F, 0x09, 0x77, 0x70, 0xCF, 0x07, 0x40, 0xAF, 0x0A, 0x77, 0x71, 0x01, 0x0D, 0xF0,
  0x62, 0x0A, 0xF0, 0xC7, 0x77, 0x30, 0x20, 0xEF, 0x06, 0x0B, 0xF0, 0xD0, 0x17, 0x77, 0x40, 0x4F,
  0xF9, 0x0D, 0x01, 0x77, 0x76, 0x05, 0xFE, 0x0E, 0x02, 0x77, 0x77, 0x10, 0x8F, 0xD0, 0x57, 0x77,
  0x73, 0x0C, 0xFB, 0x08, 0x77, 0x77, 0x40, 0x20, 0xEF, 0x90, 0xD7, 0x77, 0x76, 0x07, 0xF9, 0x04,
  0x80, 0xBF, 0x00, 0x89, 0x71, 0x47, 0xAC, 0xDD, 0xEF, 0xED, 0xCB, 0x97, 0x41, 0x77, 0x73, 0x81,
  0x16, 0xBF, 0xFB, 0x81, 0xD9, 0x47, 0x75, 0x02, 0x0A, 0xFF, 0xFA, 0x81, 0xE9, 0x27, 0x70, 0x10,
  0x9F, 0xFF, 0xF0, 0xB0, 0x27, 0x40, 0x40, 0xEF, 0xFF, 0xFA, 0x02, 0x73, 0x08, 0xFF, 0xFF, 0xB0,
  0xB7, 0x30, 0xAF, 0xFF, 0xFC, 0x04, 0x72, 0x0A, 0xFD, 0x83, 0xC8, 0x52, 0x12, 0x84, 0x12, 0x36,
  0xAD, 0xF0, 0xD7, 0x20, 0x9F, 0xB8, 0x1E, 0x81, 0x76, 0x81, 0x27, 0xDC, 0x07, 0x71, 0x06, 0xFB,
  0x09, 0x01, 0x77, 0x48, 0x34, 0xCF, 0xE1, 0x70, 0x20, 0xEF, 0x90, 0xE0, 0x47, 0x77, 0x10, 0x50,
  0x77, 0x10, 0xCF, 0x90, 0xE0, 0x37, 0x77, 0x74, 0x06, 0xF9, 0x0E, 0x03, 0x77, 0x77, 0x50, 0xDF,
  0x90, 0x57, 0x77, 0x75, 0x06, 0xF9, 0x09, 0x77, 0x77, 0x60, 0xDF, 0x0E, 0x01, 0x77, 0x77, 0x50,
  0x4F, 0x90, 0x77, 0x77, 0x76, 0x09, 0xF0, 0xE7, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x76, 0x04,
  0xF9, 0x03, 0x77, 0x77, 0x60, 0x8F, 0x0D, 0x77, 0x77, 0x70, 0xCF, 0x09, 0x77, 0x77, 0x7F, 0x90,
  0x57, 0x77, 0x76, 0x03, 0xF9, 0x01, 0x77, 0x77, 0x60, 0x6F, 0x0E, 0x77, 0x77, 0x70, 0x8F, 0x0B,
  0x77, 0x77, 0x70, 0xAF, 0x09, 0x77, 0x77, 0x70, 0xCF, 0x07, 0x77, 0x77, 0x70, 0xDF, 0x06, 0x77,
  0x77, 0x70, 0xEF, 0x05, 0x77, 0x77, 0x70, 0xEF, 0x04, 0x77, 0x77, 0x7F, 0x90, 0x47, 0x77, 0x77,
  0xF9, 0x03, 0x77, 0x77, 0x7F, 0x90, 0x37, 0x77, 0x77, 0xF9, 0x03, 0x77, 0x77, 0x7F, 0x90, 0x47,
  0x77, 0x77, 0x0E, 0xF0, 0x47, 0x77, 0x77, 0x0D, 0xF0, 0x67, 0x77, 0x77, 0x0C, 0xF0, 0x77, 0x77,
  0x77, 0x0A, 0xF0, 0x87, 0x77, 0x77, 0x08, 0xF0, 0xA7, 0x77, 0x77, 0x06, 0xF0, 0xD7, 0x77, 0x77,
  0x04, 0xF9, 0x77, 0x77, 0x70, 0x1F, 0x90, 0x37, 0x77, 0x77, 0x0D, 0xF0, 0x77, 0x77, 0x77, 0x0A,
  0xF0, 0xB7, 0x77, 0x77, 0x06, 0xF9, 0x77, 0x77, 0x70, 0x1F, 0x90, 0x57, 0x77, 0x77, 0x0C, 0xF0,
  0xB7, 0x77, 0x77, 0x07, 0xF9, 0x03, 0x77, 0x77, 0x60, 0x2F, 0x90, 0xA7, 0x77, 0x77, 0x0A, 0xF9,
  0x04, 0x77, 0x77, 0x60, 0x3F, 0x90, 0xD7, 0x77, 0x77, 0x0B, 0xF9, 0x0A, 0x77, 0x77, 0x60, 0x2F,
  0xA0, 0x87, 0x77, 0x76, 0x07, 0xFA, 0x09, 0x77, 0x77, 0x60, 0xCF, 0xA0, 0xC0, 0x37, 0x77, 0x05,
  0x07, 0x72, 0x02, 0x0E, 0xFB, 0x0B, 0x04, 0x77, 0x18, 0x42, 0x5A, 0xEF, 0xA7, 0x30, 0x30, 0xEF,
  0xC8, 0x4E, 0xA6, 0x42, 0x12, 0x85, 0x12, 0x35, 0x7A, 0xDD, 0x0A, 0x74, 0x04, 0x0E, 0xFF, 0xFF,
  0xA0, 0xA7, 0x50, 0x30, 0xDF, 0xFF, 0xF9, 0x0A, 0x76, 0x01, 0x0C, 0xFF, 0xFF, 0x0A, 0x77, 0x10,
  0x70, 0xEF, 0xFF, 0xD0, 0xA7, 0x72, 0x81, 0x18, 0xEF, 0xFF, 0xA0, 0xE0, 0x77, 0x75, 0x05, 0x0A,
  0xFF, 0xC8, 0x1C, 0x83, 0x77, 0x73, 0x84, 0x36, 0x9B, 0xDE, 0xB8, 0x5E, 0xDD, 0xB9, 0x74, 0x72,
  // "č" (U+010D)
  0x70, 0x18, 0x01, 0x70, 0x47, 0x74, 0x05, 0x80, 0x17, 0x01, 0x70, 0x2E, 0x08, 0x77, 0x10, 0x10,
  0xAE, 0x02, 0x71, 0x08, 0xE0, 0xC0, 0x17, 0x50, 0x30, 0xDE, 0x08, 0x73, 0x09, 0xE0, 0xD0, 0x37,
  0x30, 0x50, 0xEE, 0x08, 0x75, 0x0A, 0xF0, 0x57, 0x10, 0x7F, 0x09, 0x77, 0x0B, 0xF0, 0x66, 0x09,
  0xF0, 0x97, 0x72, 0x0C, 0xF0, 0x74, 0x0A, 0xF0, 0xA7, 0x73, 0x01, 0x0D, 0xF0, 0x62, 0x0A, 0xF0,
  0xC7, 0x75, 0x02, 0x0E, 0xF0, 0x60, 0xBF, 0x0D, 0x01, 0x77, 0x60, 0x4F, 0xF9, 0x0D, 0x01, 0x77,
  0x71, 0x05, 0xFE, 0x0E, 0x02, 0x77, 0x73, 0x08, 0xFD, 0x05, 0x77, 0x75, 0x0C, 0xFB, 0x08, 0x77,
  0x76, 0x02, 0x0E, 0xF9, 0x0D, 0x77, 0x77, 0x10, 0x7F, 0x90, 0x48, 0x0B, 0xB3, 0x08, 0x44, 0x79,
  0xCD, 0xEA, 0x85, 0xED, 0xCB, 0x96, 0x37, 0x76, 0x81, 0x17, 0xCF, 0xFB, 0x81, 0xB6, 0x17, 0x70,
  0x30, 0xAF, 0xFF, 0xA0, 0xA0, 0x37, 0x30, 0x10, 0xAF, 0xFF, 0xE0, 0x47, 0x10, 0x40, 0xEF, 0xFF,
  0xE0, 0xE7, 0x10, 0x6F, 0xFF, 0xF9, 0x09, 0x70, 0x6F, 0xE8, 0x7D, 0xB9, 0x98, 0x9A, 0xBE, 0xF9,
  0x03, 0x60, 0x4F, 0xC8, 0x1B, 0x51, 0x72, 0x81, 0x15, 0xBC, 0x0D, 0x60, 0x10, 0xEF, 0xA0, 0xA0,
  0x27, 0x71, 0x83, 0x17, 0xEF, 0x76, 0x0A, 0xFA, 0x05, 0x77, 0x58, 0x11, 0x82, 0x50, 0x4F, 0xA0,
  0x47, 0x77, 0x70, 0xBF, 0x90, 0x67, 0x77, 0x70, 0x3F, 0x90, 0xB7, 0x77, 0x71, 0x09, 0xF9, 0x02,
  0x77, 0x77, 0x10, 0xEF, 0x0B, 0x77, 0x77, 0x10, 0x2F, 0x90, 0x57, 0x77, 0x71, 0x07, 0xF9, 0x77,
  0x77, 0x20, 0xAF, 0x0B, 0x77, 0x77, 0x20, 0xCF, 0x08, 0x77, 0x77, 0x20, 0xEF, 0x05, 0x77, 0x77,
  0x10, 0x1F, 0x90, 0x37, 0x77, 0x71, 0x02, 0xF9, 0x01, 0x77, 0x77, 0x10, 0x3F, 0x97, 0x77, 0x72,
  0x04, 0xF9, 0x77, 0x77, 0x20, 0x4F, 0x0E, 0x77, 0x77, 0x20, 0x5F, 0x0E, 0x77, 0x77, 0x20, 0x4F,
  0x97, 0x77, 0x72, 0x04, 0xF9, 0x77, 0x77, 0x20, 0x3F, 0x90, 0x17, 0x77, 0x71, 0x02, 0xF9, 0x02,
  0x77, 0x77, 0x2F, 0x90, 0x47, 0x77, 0x72, 0x0E, 0xF0, 0x67, 0x77, 0x72, 0x0C, 0xF0, 0xA7, 0x77,
  0x72, 0x09, 0xF0, 0xD7, 0x77, 0x72, 0x06, 0xF9, 0x03, 0x77, 0x77, 0x10, 0x1F, 0x90, 0x87, 0x77,
  0x72, 0x0D, 0xF0, 0xE7, 0x77, 0x72, 0x07, 0xF9, 0x08, 0x77, 0x77, 0x10, 0x1F, 0xA0, 0x37, 0x77,
  0x71, 0x09, 0xF9, 0x0E, 0x02, 0x77, 0x77, 0x02, 0xFA, 0x0E, 0x04, 0x77, 0x71, 0x04, 0x50, 0x7F,
  0xB0, 0x90, 0x17, 0x73, 0x82, 0x38, 0xDE, 0x60, 0xBF, 0xC8, 0x1A, 0x51, 0x73, 0x82, 0x25, 0x9D,
  0xB0, 0xE6, 0x01, 0x0D, 0xFE, 0x87, 0xDB, 0x98, 0x89, 0xAB, 0xCF, 0x90, 0xE7, 0x01, 0x0C, 0xFF,
  0xFF, 0x90, 0xE7, 0x20, 0xAF, 0xFF, 0xF0, 0xE7, 0x30, 0x50, 0xEF, 0xFF, 0xD0, 0xE7, 0x50, 0x80,
  0xEF, 0xFF, 0xB0, 0x97, 0x70, 0x50, 0xBF, 0xFC, 0x81, 0xD9, 0x57, 0x75, 0x84, 0x47, 0xAB, 0xDE,
  0xA8, 0x7E, 0xED, 0xCA, 0x86, 0x41, 0x60,
  // "Ď" (U+010E)
  0x30, 0x18, 0x01, 0x70, 0x47, 0x74, 0x05, 0x80, 0x17, 0x01, 0x75, 0x02, 0xE0, 0x87, 0x71, 0x01,
  0x0A, 0xE0, 0x27, 0x60, 0x8E, 0x0C, 0x01, 0x75, 0x03, 0x0D, 0xE0, 0x87, 0x71, 0x09, 0xE0, 0xD0,
  0x37, 0x30, 0x50, 0xEE, 0x08, 0x77, 0x30, 0xAF, 0x05, 0x71, 0x07, 0xF0, 0x97, 0x75, 0x0B, 0xF0,
  0x66, 0x09, 0xF0, 0x97, 0x77, 0x0C, 0xF0, 0x74, 0x0A, 0xF0, 0xA7, 0x77, 0x10, 0x10, 0xDF, 0x06,
  0x20, 0xAF, 0x0C, 0x77, 0x73, 0x02, 0x0E, 0xF0, 0x60, 0xBF, 0x0D, 0x01, 0x77, 0x74, 0x04, 0xFF,
  0x90, 0xD0, 0x17, 0x77, 0x60, 0x5F, 0xE0, 0xE0, 0x27, 0x77, 0x71, 0x08, 0xFD, 0x05, 0x77, 0x77,
  0x30, 0xCF, 0xB0, 0x87, 0x77, 0x74, 0x02, 0x0E, 0xF9, 0x0D, 0x77, 0x77, 0x60, 0x7F, 0x90, 0x48,
  0x0C, 0xB0, 0x00, 0xAF, 0xFA, 0x85, 0xED, 0xCA, 0x75, 0x27, 0x76, 0x0A, 0xFF, 0xFA, 0x81, 0xD9,
  0x47, 0x73, 0x0A, 0xFF, 0xFD, 0x0E, 0x07, 0x77, 0x10, 0xAF, 0xFF, 0xF0, 0xE0, 0x77, 0x60, 0xAF,
  0xFF, 0xFA, 0x0D, 0x03, 0x74, 0x0A, 0xFF, 0xFF, 0xC0, 0x87, 0x30, 0xAF, 0x0B, 0x80, 0x38, 0x82,
  0x9A, 0xCE, 0xFF, 0x0A, 0x72, 0x0A, 0xF0, 0x67, 0x48, 0x12, 0x5A, 0xFD, 0x0B, 0x71, 0x0A, 0xF0,
  0x67, 0x78, 0x11, 0x7E, 0xFB, 0x0A, 0x70, 0xAF, 0x06, 0x77, 0x20, 0x10, 0x9F, 0xB0, 0x76, 0x0A,
  0xF0, 0x67, 0x74, 0x04, 0x0E, 0xFA, 0x04, 0x50, 0xAF, 0x06, 0x77, 0x50, 0x20, 0xDF, 0x90, 0xD5,
  0x0A, 0xF0, 0x67, 0x76, 0x02, 0x0D, 0xF9, 0x08, 0x40, 0xAF, 0x06, 0x77, 0x70, 0x3F, 0xA0, 0x23,
  0x0A, 0xF0, 0x67, 0x77, 0x10, 0x6F, 0x90, 0x93, 0x0A, 0xF0, 0x67, 0x77, 0x20, 0xCF, 0x90, 0x12,
  0x0A, 0xF0, 0x67, 0x77, 0x20, 0x4F, 0x90, 0x72, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0xCF, 0x0D, 0x20,
  0xAF, 0x06, 0x77, 0x73, 0x05, 0xF9, 0x81, 0x20, 0xAF, 0x06, 0x77, 0x74, 0xF9, 0x81, 0x60, 0xAF,
  0x06, 0x77, 0x74, 0x0A, 0xF8, 0x1B, 0x0A, 0xF0, 0x67, 0x77, 0x40, 0x7F, 0x81, 0xE0, 0xAF, 0x06,
  0x77, 0x74, 0x03, 0xF9, 0x02, 0x0A, 0xF0, 0x67, 0x77, 0x5F, 0x90, 0x40, 0xAF, 0x06, 0x77, 0x75,
  0x0D, 0xF0, 0x70, 0xAF, 0x06, 0x77, 0x75, 0x0A, 0xF0, 0x90, 0xAF, 0x06, 0x77, 0x75, 0x09, 0xF0,
  0xB0, 0xAF, 0x06, 0x77, 0x75, 0x07, 0xF0, 0xC0, 0xAF, 0x06, 0x77, 0x75, 0x06, 0xF0, 0xC0, 0xAF,
  0x06, 0x77, 0x75, 0x06, 0xF0, 0xD0, 0xAF, 0x06, 0x77, 0x75, 0x05, 0xF0, 0xE0, 0xAF, 0x06, 0x77,
  0x75, 0x05, 0xF0, 0xE0, 0xAF, 0x06, 0x77, 0x75, 0x05, 0xF0, 0xE0, 0xAF, 0x06, 0x77, 0x75, 0x05,
  0xF0, 0xD0, 0xAF, 0x06, 0x77, 0x75, 0x06, 0xF0, 0xD0, 0xAF, 0x06, 0x77, 0x75, 0x07, 0xF0, 0xC0,
  0xAF, 0x06, 0x77, 0x75, 0x08, 0xF0, 0xB0, 0xAF, 0x06, 0x77, 0x75, 0x0A, 0xF0, 0x90, 0xAF, 0x06,
  0x77, 0x75, 0x0C, 0xF0, 0x70, 0xAF, 0x06, 0x77, 0x75, 0x0E, 0xF0, 0x50, 0xAF, 0x06, 0x77, 0x74,
  0x02, 0xF9, 0x02, 0x0A, 0xF0, 0x67, 0x77, 0x40, 0x6F, 0x91, 0x0A, 0xF0, 0x67, 0x77, 0x40, 0x9F,
  0x81, 0xC0, 0xAF, 0x06, 0x77, 0x74, 0x0E, 0xF8, 0x18, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x4F, 0x98,
  0x14, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x9F, 0x0E, 0x20, 0xAF, 0x06, 0x77, 0x72, 0x01, 0xF9, 0x09,
  0x20, 0xAF, 0x06, 0x77, 0x72, 0x08, 0xF9, 0x04, 0x20, 0xAF, 0x06, 0x77, 0x71, 0x02, 0xF9, 0x0D,
  0x30, 0xAF, 0x06, 0x77, 0x71, 0x0B, 0xF9, 0x05, 0x30, 0xAF, 0x06, 0x77, 0x70, 0x7F, 0x90, 0xD4,
  0x0A, 0xF0, 0x67, 0x76, 0x05, 0xFA, 0x04, 0x40, 0xAF, 0x06, 0x77, 0x50, 0x5F, 0xA0, 0xA5, 0x0A,
  0xF0, 0x67, 0x74, 0x08, 0xFA, 0x0E, 0x01, 0x50, 0xAF, 0x06, 0x77, 0x20, 0x30, 0xCF, 0xA0, 0xE0,
  0x36, 0x0A, 0xF0, 0x67, 0x70, 0x40, 0xBF, 0xC0, 0x57, 0x0A, 0xF0, 0x67, 0x38, 0x22, 0x59, 0xEF,
  0xD0, 0x57, 0x10, 0xAF, 0x0B, 0x80, 0x18, 0x83, 0x99, 0xAC, 0xEF, 0xF0, 0xE0, 0x47, 0x20, 0xAF,
  0xFF, 0xFB, 0x0C, 0x02, 0x73, 0x0A, 0xFF, 0xFF, 0xA0, 0x87, 0x50, 0xAF, 0xFF, 0xF0, 0xA0, 0x27,
  0x60, 0xAF, 0xFF, 0xC8, 0x1E, 0x82, 0x77, 0x10, 0xAF, 0xFF, 0x98, 0x1E, 0x94, 0x77, 0x40, 0xAF,
  0xF8, 0x6E, 0xED, 0xB9, 0x75, 0x17, 0x77,
  // "ď" (U+010F)
  0x77, 0x77, 0x30, 0xCF, 0x03, 0x50, 0x1F, 0x0B, 0x77, 0x77, 0x30, 0xCF, 0x03, 0x50, 0x3F, 0x08,
  0x77, 0x77, 0x30, 0xCF, 0x03, 0x50, 0x6F, 0x03, 0x77, 0x77, 0x30, 0xCF, 0x03, 0x50, 0x9E, 0x0D,
  0x77, 0x77, 0x40, 0xCF, 0x03, 0x50, 0xCE, 0x06, 0x77, 0x77, 0x40, 0xCF, 0x03, 0x5E, 0x0E, 0x77,
  0x77, 0x50, 0xCF, 0x03, 0x40, 0x3E, 0x08, 0x77, 0x77, 0x50, 0xCF, 0x03, 0x40, 0x7E, 0x01, 0x77,
  0x77, 0x50, 0xCF, 0x03, 0x40, 0xAD, 0x08, 0x77, 0x77, 0x60, 0xCF, 0x03, 0x40, 0xEC, 0x0E, 0x01,
  0x77, 0x77, 0x60, 0xCF, 0x03, 0x30, 0x3D, 0x07, 0x77, 0x77, 0x70, 0xCF, 0x03, 0x30, 0x8C, 0x0D,
  0x80, 0xC0, 0x00, 0xCF, 0x03, 0x30, 0xDC, 0x04, 0x80, 0xC0, 0x00, 0xCF, 0x03, 0x3C, 0x09, 0x80,
  0xC1, 0x00, 0xCF, 0x03, 0x80, 0xD1, 0x00, 0xCF, 0x03, 0x80, 0xD1, 0x00, 0xCF, 0x03, 0x80, 0xD1,
  0x00, 0xCF, 0x03, 0x80, 0xD1, 0x00, 0xCF, 0x03, 0x77, 0x75, 0x89, 0x32, 0x69, 0xCE, 0xEF, 0xED,
  0xC9, 0x51, 0x60, 0xCF, 0x03, 0x77, 0x73, 0x06, 0x0C, 0xFE, 0x09, 0x01, 0x40, 0xBF, 0x03, 0x77,
  0x71, 0x04, 0x0D, 0xFF, 0xA0, 0xE0, 0x43, 0x0A, 0xF0, 0x37, 0x77, 0x07, 0xFF, 0xE0, 0x62, 0x0A,
  0xF0, 0x37, 0x76, 0x09, 0xFF, 0xF9, 0x81, 0x50, 0x8F, 0x03, 0x77, 0x50, 0x8F, 0xFF, 0xB0, 0x20,
  0x7F, 0x03, 0x77, 0x40, 0x5F, 0xD8, 0x4C, 0x98, 0x9A, 0xDF, 0x0C, 0x05, 0xF0, 0x37, 0x73, 0x01,
  0x0E, 0xFA, 0x81, 0xE7, 0x16, 0x02, 0x09, 0xE0, 0xEF, 0x03, 0x77, 0x30, 0x9F, 0xA0, 0xB0, 0x17,
  0x30, 0x30, 0xDF, 0xD0, 0x37, 0x72, 0x01, 0xFA, 0x0A, 0x76, 0x02, 0x0E, 0xFC, 0x03, 0x77, 0x20,
  0x8F, 0x90, 0xC7, 0x71, 0x03, 0xFC, 0x03, 0x77, 0x20, 0xEF, 0x90, 0x37, 0x72, 0x09, 0xFB, 0x03,
  0x77, 0x10, 0x4F, 0x90, 0x97, 0x73, 0x01, 0xFB, 0x03, 0x77, 0x10, 0x9F, 0x90, 0x27, 0x74, 0x09,
  0xFA, 0x03, 0x77, 0x10, 0xDF, 0x0C, 0x77, 0x50, 0x4F, 0xA0, 0x37, 0x70, 0x1F, 0x90, 0x77, 0x76,
  0x0E, 0xF9, 0x03, 0x77, 0x04, 0xF9, 0x03, 0x77, 0x60, 0xBF, 0x90, 0x37, 0x70, 0x6F, 0x97, 0x77,
  0x07, 0xF9, 0x03, 0x77, 0x08, 0xF0, 0xD7, 0x77, 0x05, 0xF9, 0x03, 0x77, 0x0A, 0xF0, 0xA7, 0x77,
  0x02, 0xF9, 0x03, 0x77, 0x0C, 0xF0, 0x87, 0x77, 0x1F, 0x90, 0x37, 0x70, 0xDF, 0x07, 0x77, 0x71,
  0xF9, 0x03, 0x77, 0x0D, 0xF0, 0x67, 0x77, 0x10, 0xDF, 0x03, 0x77, 0x0E, 0xF0, 0x57, 0x77, 0x10,
  0xDF, 0x03, 0x77, 0x0E, 0xF0, 0x57, 0x77, 0x10, 0xCF, 0x03, 0x77, 0x0E, 0xF0, 0x57, 0x77, 0x10,
  0xCF, 0x03, 0x77, 0x0E, 0xF0, 0x57, 0x77, 0x10, 0xCF, 0x03, 0x77, 0x0D, 0xF0, 0x57, 0x77, 0x10,
  0xDF, 0x03, 0x77, 0x0C, 0xF0, 0x67, 0x77, 0x10, 0xDF, 0x03, 0x77, 0x0B, 0xF0, 0x77, 0x77, 0x10,
  0xEF, 0x03, 0x77, 0x0A, 0xF0, 0x97, 0x77, 0x1F, 0x90, 0x37, 0x70, 0x8F, 0x0A, 0x77, 0x70, 0x2F,
  0x90, 0x37, 0x70, 0x6F, 0x0D, 0x77, 0x70, 0x5F, 0x90, 0x37, 0x70, 0x3F, 0x97, 0x77, 0x07, 0xF9,
  0x03, 0x77, 0x1F, 0x90, 0x47, 0x76, 0x0B, 0xF9, 0x03, 0x77, 0x10, 0xCF, 0x09, 0x77, 0x50, 0x1F,
  0xA0, 0x37, 0x71, 0x08, 0xF0, 0xE7, 0x75, 0x06, 0xFA, 0x03, 0x77, 0x10, 0x4F, 0x90, 0x57, 0x74,
  0x0D, 0xFA, 0x03, 0x77, 0x20, 0xEF, 0x0D, 0x77, 0x30, 0x6F, 0xB0, 0x37, 0x72, 0x08, 0xF9, 0x07,
  0x77, 0x10, 0x10, 0xEF, 0xB0, 0x37, 0x72, 0x01, 0xFA, 0x04, 0x76, 0x01, 0x0C, 0xFC, 0x03, 0x77,
  0x30, 0x8F, 0xA0, 0x67, 0x40, 0x20, 0xDF, 0xD0, 0x37, 0x73, 0x01, 0x0D, 0xFA, 0x0B, 0x04, 0x70,
  0x20, 0x9E, 0x0C, 0xF0, 0x37, 0x74, 0x04, 0xFC, 0x85, 0xEB, 0x98, 0x9A, 0xDF, 0x0A, 0x03, 0xF0,
  0x37, 0x75, 0x06, 0xFF, 0xFA, 0x81, 0xD1, 0x1F, 0x03, 0x77, 0x60, 0x7F, 0xFF, 0x0E, 0x02, 0x20,
  0xEE, 0x03, 0x77, 0x70, 0x6F, 0xFD, 0x0D, 0x02, 0x30, 0xCE, 0x03, 0x77, 0x71, 0x02, 0x0C, 0xFF,
  0xA0, 0xA0, 0x14, 0x0A, 0xE0, 0x37, 0x77, 0x30, 0x50, 0xCF, 0xD0, 0xC0, 0x46, 0x08, 0xE0, 0x37,
  0x77, 0x58, 0x32, 0x6A, 0xCE, 0xA8, 0x3E, 0xDA, 0x72, 0x77, 0x77, 0x20,
  // "Đ" (U+0110)
  0x70, 0xCF, 0xF9, 0x86, 0xEE, 0xDC, 0xA7, 0x42, 0x77, 0x76, 0x0C, 0xFF, 0xFA, 0x81, 0xD8, 0x37,
  0x77, 0x30, 0xCF, 0xFF, 0xD0, 0xD0, 0x67, 0x77, 0x10, 0xCF, 0xFF, 0xF0, 0xE0, 0x67, 0x76, 0x0C,
  0xFF, 0xFF, 0xA0, 0xC0, 0x27, 0x74, 0x0C, 0xFF, 0xFF, 0xC0, 0x67, 0x73, 0x0C, 0xF0, 0xA8, 0x03,
  0x88, 0x29, 0xAC, 0xEF, 0xF0, 0x87, 0x72, 0x0C, 0xF0, 0x47, 0x48, 0x12, 0x6B, 0xFD, 0x09, 0x77,
  0x10, 0xCF, 0x04, 0x77, 0x81, 0x18, 0xEF, 0xB0, 0x97, 0x70, 0xCF, 0x04, 0x77, 0x20, 0x10, 0xAF,
  0xB0, 0x57, 0x60, 0xCF, 0x04, 0x77, 0x40, 0x50, 0xEF, 0xA0, 0x37, 0x50, 0xCF, 0x04, 0x77, 0x50,
  0x30, 0xEF, 0x90, 0xC7, 0x50, 0xCF, 0x04, 0x77, 0x60, 0x20, 0xEF, 0x90, 0x67, 0x40, 0xCF, 0x04,
  0x77, 0x70, 0x4F, 0x90, 0xE0, 0x17, 0x30, 0xCF, 0x04, 0x77, 0x71, 0x08, 0xF9, 0x08, 0x73, 0x0C,
  0xF0, 0x47, 0x77, 0x20, 0xDF, 0x0E, 0x73, 0x0C, 0xF0, 0x47, 0x77, 0x20, 0x5F, 0x90, 0x57, 0x20,
  0xCF, 0x04, 0x77, 0x73, 0x0D, 0xF0, 0xB7, 0x20, 0xCF, 0x04, 0x77, 0x73, 0x07, 0xF9, 0x01, 0x71,
  0x0C, 0xF0, 0x47, 0x77, 0x30, 0x2F, 0x90, 0x57, 0x10, 0xCF, 0x04, 0x77, 0x74, 0x0C, 0xF0, 0x97,
  0x10, 0xCF, 0x04, 0x77, 0x74, 0x08, 0xF0, 0xD7, 0x10, 0xCF, 0x04, 0x77, 0x74, 0x04, 0xF9, 0x71,
  0x0C, 0xF0, 0x47, 0x77, 0x40, 0x1F, 0x90, 0x37, 0x0C, 0xF0, 0x47, 0x77, 0x50, 0xEF, 0x05, 0x70,
  0xCF, 0x04, 0x77, 0x75, 0x0C, 0xF0, 0x77, 0x0C, 0xF0, 0x47, 0x77, 0x50, 0xBF, 0x09, 0x70, 0xCF,
  0x04, 0x77, 0x75, 0x09, 0xF0, 0xA7, 0x0C, 0xF0, 0x47, 0x77, 0x50, 0x8F, 0x0B, 0xFF, 0xFD, 0x04,
  0x77, 0x10, 0x7F, 0x0B, 0xFF, 0xFD, 0x04, 0x77, 0x10, 0x7F, 0x0C, 0xFF, 0xFD, 0x04, 0x77, 0x10,
  0x6F, 0x0C, 0xFF, 0xFD, 0x04, 0x77, 0x10, 0x7F, 0x0C, 0xFF, 0xFD, 0x04, 0x77, 0x10, 0x7F, 0x0C,
  0xFF, 0xFD, 0x04, 0x77, 0x10, 0x8F, 0x0B, 0x80, 0x38, 0x0E, 0xF0, 0xA8, 0x06, 0x80, 0x27, 0x71,
  0x09, 0xF0, 0xA7, 0x0C, 0xF0, 0x47, 0x77, 0x50, 0xAF, 0x09, 0x70, 0xCF, 0x04, 0x77, 0x75, 0x0C,
  0xF0, 0x77, 0x0C, 0xF0, 0x47, 0x77, 0x50, 0xEF, 0x06, 0x70, 0xCF, 0x04, 0x77, 0x74, 0x01, 0xF9,
  0x04, 0x70, 0xCF, 0x04, 0x77, 0x74, 0x04, 0xF9, 0x01, 0x70, 0xCF, 0x04, 0x77, 0x74, 0x07, 0xF0,
  0xD7, 0x10, 0xCF, 0x04, 0x77, 0x74, 0x0B, 0xF0, 0xA7, 0x10, 0xCF, 0x04, 0x77, 0x74, 0xF9, 0x06,
  0x71, 0x0C, 0xF0, 0x47, 0x77, 0x30, 0x5F, 0x90, 0x27, 0x10, 0xCF, 0x04, 0x77, 0x73, 0x0B, 0xF0,
  0xD7, 0x20, 0xCF, 0x04, 0x77, 0x72, 0x02, 0xF9, 0x08, 0x72, 0x0C, 0xF0, 0x47, 0x77, 0x20, 0xAF,
  0x90, 0x27, 0x20, 0xCF, 0x04, 0x77, 0x71, 0x03, 0xF9, 0x0B, 0x73, 0x0C, 0xF0, 0x47, 0x77, 0x10,
  0xCF, 0x90, 0x47, 0x30, 0xCF, 0x04, 0x77, 0x70, 0x9F, 0x90, 0xB7, 0x40, 0xCF, 0x04, 0x77, 0x60,
  0x7F, 0xA0, 0x37, 0x40, 0xCF, 0x04, 0x77, 0x50, 0x6F, 0xA0, 0x87, 0x50, 0xCF, 0x04, 0x77, 0x40,
  0x9F, 0xA0, 0xD7, 0x60, 0xCF, 0x04, 0x77, 0x20, 0x40, 0xDF, 0xA0, 0xE0, 0x27, 0x60, 0xCF, 0x04,
  0x77, 0x05, 0x0C, 0xFC, 0x03, 0x77, 0x0C, 0xF0, 0x47, 0x38, 0x22, 0x5A, 0xEF, 0xC0, 0xE0, 0x47,
  0x71, 0x0C, 0xF0, 0xA8, 0x01, 0x88, 0x39, 0x9B, 0xCE, 0xFF, 0x0E, 0x03, 0x77, 0x20, 0xCF, 0xFF,
  0xFB, 0x0B, 0x01, 0x77, 0x30, 0xCF, 0xFF, 0xF9, 0x0E, 0x07, 0x77, 0x50, 0xCF, 0xFF, 0xF0, 0x90,
  0x17, 0x76, 0x0C, 0xFF, 0xFC, 0x81, 0xE8, 0x17, 0x77, 0x10, 0xCF, 0xFF, 0x98, 0x1D, 0x94, 0x77,
  0x74, 0x0C, 0xFF, 0x86, 0xEE, 0xDB, 0x97, 0x41, 0x77, 0x70,
  // "đ" (U+0111)
  0x77, 0x77, 0x50, 0x3F, 0x0C, 0x80, 0xC4, 0x00, 0x3F, 0x0C, 0x80, 0xC4, 0x00, 0x3F, 0x0C, 0x80,
  0xC4, 0x00, 0x3F, 0x0C, 0x80, 0xC4, 0x00, 0x3F, 0x0C, 0x80, 0xC4, 0x00, 0x3F, 0x0C, 0x80, 0xC4,
  0x00, 0x3F, 0x0C, 0x80, 0xC4, 0x00, 0x3F, 0x0C, 0x77, 0x73, 0x02, 0xFF, 0xFF, 0xB7, 0x73, 0x02,
  0xFF, 0xFF, 0xB7, 0x73, 0x02, 0xFF, 0xFF, 0xB7, 0x73, 0x02, 0xFF, 0xFF, 0xB7, 0x73, 0x02, 0xFF,
  0xFF, 0xB7, 0x73, 0x02, 0xFF, 0xFF, 0xB7, 0x77, 0x75, 0x03, 0xF0, 0xC8, 0x0C, 0x40, 0x03, 0xF0,
  0xC8, 0x0C, 0x40, 0x03, 0xF0, 0xC8, 0x0C, 0x40, 0x03, 0xF0, 0xC8, 0x0C, 0x40, 0x03, 0xF0, 0xC8,
  0x0C, 0x40, 0x03, 0xF0, 0xC7, 0x76, 0x89, 0x41, 0x58, 0xBC, 0xEE, 0xFE, 0xDC, 0x95, 0x16, 0x02,
  0xF0, 0xC7, 0x74, 0x06, 0x0C, 0xFF, 0x0A, 0x02, 0x40, 0x1F, 0x0C, 0x77, 0x20, 0x70, 0xEF, 0xFC,
  0x07, 0x30, 0x1F, 0x0C, 0x77, 0x02, 0x0C, 0xFF, 0xF0, 0xB3, 0xF0, 0xC7, 0x60, 0x40, 0xEF, 0xFF,
  0xA0, 0xC2, 0x0E, 0xE0, 0xC7, 0x50, 0x4F, 0xFF, 0xD8, 0x1B, 0x0C, 0xE0, 0xC7, 0x40, 0x20, 0xEF,
  0xD8, 0x5D, 0xA9, 0x89, 0xAD, 0xF9, 0x06, 0x0B, 0xE0, 0xC7, 0x40, 0xCF, 0xB8, 0x1D, 0x61, 0x78,
  0x12, 0x8E, 0xE0, 0xEE, 0x0C, 0x73, 0x07, 0xFB, 0x07, 0x75, 0x01, 0x0B, 0xFD, 0x0C, 0x72, 0x01,
  0x0E, 0xF9, 0x0E, 0x03, 0x77, 0x10, 0xAF, 0xC0, 0xC7, 0x20, 0x8F, 0xA0, 0x37, 0x73, 0x0C, 0xFB,
  0x0C, 0x72, 0x0E, 0xF9, 0x06, 0x77, 0x40, 0x20, 0xEF, 0xA0, 0xC7, 0x10, 0x5F, 0x90, 0xB7, 0x76,
  0x08, 0xFA, 0x0C, 0x71, 0x0A, 0xF9, 0x03, 0x77, 0x60, 0x1F, 0xA0, 0xC7, 0x10, 0xEF, 0x0D, 0x77,
  0x71, 0x0A, 0xF9, 0x0C, 0x70, 0x2F, 0x90, 0x77, 0x77, 0x10, 0x5F, 0x90, 0xC7, 0x05, 0xF9, 0x02,
  0x77, 0x71, 0x01, 0xF9, 0x0C, 0x70, 0x8F, 0x0E, 0x77, 0x73, 0x0D, 0xF0, 0xC7, 0x0A, 0xF0, 0xB7,
  0x77, 0x30, 0xAF, 0x0C, 0x70, 0xCF, 0x09, 0x77, 0x73, 0x08, 0xF0, 0xC7, 0x0D, 0xF0, 0x77, 0x77,
  0x30, 0x6F, 0x0C, 0x7F, 0x90, 0x57, 0x77, 0x30, 0x5F, 0x0C, 0x7F, 0x90, 0x47, 0x77, 0x30, 0x4F,
  0x0C, 0x7F, 0x90, 0x47, 0x77, 0x30, 0x3F, 0x0C, 0x7F, 0x90, 0x37, 0x77, 0x30, 0x3F, 0x0C, 0x7F,
  0x90, 0x37, 0x77, 0x30, 0x3F, 0x0C, 0x7F, 0x90, 0x47, 0x77, 0x30, 0x3F, 0x0C, 0x70, 0xEF, 0x04,
  0x77, 0x73, 0x04, 0xF0, 0xC7, 0x0D, 0xF0, 0x67, 0x77, 0x30, 0x5F, 0x0C, 0x70, 0xBF, 0x07, 0x77,
  0x73, 0x05, 0xF0, 0xC7, 0x0A, 0xF0, 0x97, 0x77, 0x30, 0x8F, 0x0C, 0x70, 0x7F, 0x0C, 0x77, 0x73,
  0x0B, 0xF0, 0xC7, 0x05, 0xF9, 0x77, 0x73, 0x0D, 0xF0, 0xC7, 0x01, 0xF9, 0x04, 0x77, 0x71, 0x02,
  0xF9, 0x0C, 0x71, 0x0D, 0xF0, 0x97, 0x77, 0x10, 0x8F, 0x90, 0xC7, 0x10, 0x9F, 0x0E, 0x77, 0x71,
  0x0D, 0xF9, 0x0C, 0x71, 0x03, 0xF9, 0x07, 0x77, 0x60, 0x6F, 0xA0, 0xC7, 0x20, 0xDF, 0x0E, 0x02,
  0x77, 0x50, 0xEF, 0xA0, 0xC7, 0x20, 0x7F, 0x90, 0xC7, 0x74, 0x09, 0xFB, 0x0C, 0x73, 0x0E, 0xF9,
  0x0B, 0x77, 0x20, 0x8F, 0xC0, 0xC7, 0x30, 0x6F, 0xA0, 0xC0, 0x37, 0x50, 0x10, 0xAF, 0xD0, 0xC7,
  0x40, 0xBF, 0xB0, 0xA0, 0x47, 0x18, 0x12, 0x8E, 0xD0, 0x0E, 0xE0, 0xC7, 0x40, 0x10, 0xDF, 0xC8,
  0x6E, 0xB9, 0x88, 0x9B, 0xDF, 0x90, 0x40, 0xAE, 0x0C, 0x75, 0x02, 0x0E, 0xFF, 0xFC, 0x81, 0x80,
  0x7E, 0x0C, 0x76, 0x02, 0x0D, 0xFF, 0xFA, 0x09, 0x20, 0x5E, 0x0C, 0x77, 0x01, 0x0B, 0xFF, 0xF0,
  0x73, 0x03, 0xE0, 0xC7, 0x72, 0x05, 0x0D, 0xFF, 0xB0, 0xD0, 0x44, 0x01, 0xE0, 0xC7, 0x74, 0x06,
  0x0C, 0xFE, 0x0D, 0x07, 0x70, 0xED, 0x0C, 0x77, 0x68, 0x93, 0x26, 0x9B, 0xDE, 0xFE, 0xEC, 0xA7,
  0x37, 0x77, 0x20,
  // "Ē" (U+0112)
  0x60, 0x28, 0x0A, 0x68, 0x03, 0x74, 0x04, 0xFF, 0xFD, 0x06, 0x74, 0x04, 0xFF, 0xFD, 0x06, 0x74,
  0x04, 0xFF, 0xFD, 0x06, 0x74, 0x04, 0xFF, 0xFD, 0x06, 0x74, 0x04, 0xFF, 0xFD, 0x06, 0x74, 0x04,
  0xFF, 0xFD, 0x06, 0x80, 0xCA, 0x20, 0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05, 0x07,
  0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05, 0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F,
  0x05, 0x07, 0x80, 0xC1, 0xF0, 0x50, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20,
  0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F,
  0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A,
  0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77,
  0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77,
  0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20,
  0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0xFF, 0xFF, 0x09, 0x20, 0x7F,
  0xFF, 0xFF, 0x09, 0x20, 0x7F, 0xFF, 0xFF, 0x09, 0x20, 0x7F, 0xFF, 0xFF, 0x09, 0x20, 0x7F, 0xFF,
  0xFF, 0x09, 0x20, 0x7F, 0xFF, 0xFF, 0x09, 0x20, 0x7F, 0xFF, 0xFF, 0x09, 0x20, 0x7F, 0x0A, 0x77,
  0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77,
  0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20,
  0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F,
  0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A,
  0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77,
  0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77,
  0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20,
  0x78, 0x0C, 0x1F, 0x05, 0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05, 0x07, 0x80, 0xC1,
  0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05, 0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05,
  // "ē" (U+0113)
  0x71, 0x02, 0x80, 0xA6, 0x80, 0x37, 0x72, 0x04, 0xFF, 0xFD, 0x06, 0x77, 0x20, 0x4F, 0xFF, 0xD0,
  0x67, 0x72, 0x04, 0xFF, 0xFD, 0x06, 0x77, 0x20, 0x4F, 0xFF, 0xD0, 0x67, 0x72, 0x04, 0xFF, 0xFD,
  0x06, 0x77, 0x20, 0x4F, 0xFF, 0xD0, 0x68, 0x0C, 0xB4, 0x08, 0x94, 0x25, 0x8B, 0xDD, 0xEF, 0xED,
  0xC9, 0x63, 0x77, 0x76, 0x81, 0x17, 0xCF, 0xF8, 0x1D, 0x81, 0x77, 0x71, 0x01, 0x09, 0xFF, 0xE0,
  0x90, 0x17, 0x75, 0x06, 0xFF, 0xFA, 0x0E, 0x04, 0x77, 0x20, 0x10, 0xBF, 0xFF, 0xD0, 0x77, 0x70,
  0x20, 0xDF, 0xFF, 0xF0, 0x87, 0x50, 0x20, 0xEF, 0xD8, 0x5C, 0xA9, 0x8A, 0xBE, 0xFC, 0x06, 0x73,
  0x01, 0x0D, 0xFB, 0x09, 0x04, 0x71, 0x81, 0x38, 0xEF, 0xA0, 0x37, 0x20, 0xBF, 0xA0, 0x90, 0x17,
  0x50, 0x10, 0xAF, 0x90, 0xD7, 0x10, 0x6F, 0xA0, 0x67, 0x72, 0x08, 0xF9, 0x08, 0x60, 0x10, 0xEF,
  0x90, 0x47, 0x74, 0x09, 0xF0, 0xE0, 0x15, 0x09, 0xF9, 0x05, 0x77, 0x60, 0xDF, 0x07, 0x40, 0x1F,
  0x90, 0x97, 0x77, 0x05, 0xF0, 0xD4, 0x07, 0xF0, 0xE0, 0x17, 0x77, 0x10, 0xDF, 0x04, 0x30, 0xEF,
  0x07, 0x77, 0x72, 0x07, 0xF0, 0x82, 0x03, 0xF9, 0x01, 0x77, 0x72, 0x03, 0xF0, 0xC2, 0x07, 0xF0,
  0xA7, 0x77, 0x40, 0xEF, 0x20, 0xCF, 0x05, 0x77, 0x74, 0x0B, 0xF0, 0x21, 0xF9, 0x01, 0x77, 0x74,
  0x0A, 0xF0, 0x40, 0x2F, 0x0D, 0x77, 0x75, 0x08, 0xF0, 0x60, 0x48, 0x0C, 0x6F, 0x07, 0x06, 0x80,
  0xC6, 0xF0, 0x80, 0x78, 0x0C, 0x6F, 0x09, 0x08, 0x80, 0xC6, 0xF0, 0x90, 0x88, 0x0C, 0x6F, 0x00,
  0x98, 0x0C, 0x6F, 0x09, 0x08, 0xF0, 0xC8, 0x0B, 0x68, 0x05, 0x07, 0xF0, 0xA7, 0x77, 0x77, 0x06,
  0xF0, 0xB7, 0x77, 0x77, 0x05, 0xF0, 0xC7, 0x77, 0x77, 0x03, 0xF0, 0xE8, 0x0C, 0x00, 0xF9, 0x02,
  0x77, 0x77, 0x70, 0xDF, 0x05, 0x77, 0x77, 0x70, 0x9F, 0x0A, 0x77, 0x77, 0x70, 0x4F, 0x0E, 0x80,
  0xC0, 0x00, 0xEF, 0x06, 0x77, 0x77, 0x70, 0x9F, 0x0D, 0x77, 0x77, 0x70, 0x3F, 0x90, 0x97, 0x77,
  0x77, 0x0A, 0xF9, 0x05, 0x77, 0x77, 0x60, 0x2F, 0xA0, 0x57, 0x77, 0x50, 0x10, 0x26, 0x07, 0xFA,
  0x08, 0x77, 0x72, 0x82, 0x4A, 0xF6, 0x70, 0xBF, 0xA0, 0xD0, 0x57, 0x74, 0x81, 0x38, 0xDB, 0x06,
  0x70, 0x10, 0xDF, 0xB8, 0x2E, 0x94, 0x17, 0x38, 0x21, 0x59, 0xDE, 0x06, 0x71, 0x01, 0x0D, 0xFE,
  0x89, 0x0D, 0xBA, 0x98, 0x89, 0xAC, 0xEF, 0xB0, 0x67, 0x20, 0x10, 0xCF, 0xFF, 0xFC, 0x06, 0x74,
  0x08, 0xFF, 0xFF, 0xB0, 0x67, 0x50, 0x30, 0xCF, 0xFF, 0xF0, 0xE0, 0x47, 0x70, 0x50, 0xCF, 0xFF,
  0xB0, 0xB0, 0x57, 0x74, 0x81, 0x38, 0xDF, 0xFB, 0x82, 0xD9, 0x51, 0x77, 0x72, 0x85, 0x25, 0x8A,
  0xCD, 0xEA, 0x86, 0xED, 0xDB, 0x97, 0x41, 0x73,
  // "Ĕ" (U+0114)
  0x60, 0xDC, 0x06, 0x77, 0x20, 0x6D, 0x74, 0x0C, 0xC0, 0xB7, 0x72, 0x0B, 0xC0, 0xD7, 0x40, 0x9D,
  0x04, 0x77, 0x03, 0xD0, 0xB7, 0x40, 0x5D, 0x0D, 0x02, 0x75, 0x01, 0x0C, 0xD0, 0x67, 0x50, 0xED,
  0x0E, 0x05, 0x73, 0x03, 0x0D, 0xE0, 0x17, 0x50, 0x7F, 0x82, 0xD7, 0x41, 0x28, 0x21, 0x37, 0xCF,
  0x09, 0x77, 0x0D, 0xFF, 0xF9, 0x0E, 0x01, 0x77, 0x03, 0x0E, 0xFF, 0xF0, 0x37, 0x72, 0x04, 0x0E,
  0xFF, 0xC0, 0xE0, 0x47, 0x74, 0x02, 0x0D, 0xFF, 0xA0, 0xC0, 0x27, 0x77, 0x06, 0x0D, 0xFD, 0x0C,
  0x05, 0x77, 0x74, 0x89, 0x23, 0x7B, 0xDE, 0xFE, 0xDC, 0xA6, 0x38, 0x0B, 0xE3, 0x00, 0x78, 0x0C,
  0x1F, 0x05, 0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05, 0x07, 0x80, 0xC1, 0xF0, 0x50,
  0x78, 0x0C, 0x1F, 0x05, 0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05, 0x07, 0xF0, 0xA7,
  0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77,
  0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72,
  0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07,
  0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0,
  0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7,
  0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77,
  0x72, 0x07, 0xFF, 0xFF, 0xF0, 0x92, 0x07, 0xFF, 0xFF, 0xF0, 0x92, 0x07, 0xFF, 0xFF, 0xF0, 0x92,
  0x07, 0xFF, 0xFF, 0xF0, 0x92, 0x07, 0xFF, 0xFF, 0xF0, 0x92, 0x07, 0xFF, 0xFF, 0xF0, 0x92, 0x07,
  0xFF, 0xFF, 0xF0, 0x92, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0,
  0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7,
  0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77,
  0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72,
  0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07,
  0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0,
  0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7,
  0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05,
  0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05, 0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C,
  0x1F, 0x05, 0x07, 0x80, 0xC1, 0xF0, 0x50,
  // "ĕ" (U+0115)
  0x71, 0x0D, 0xC0, 0x67, 0x72, 0x06, 0xD7, 0x72, 0x0C, 0xC0, 0xB7, 0x72, 0x0B, 0xC0, 0xD7, 0x72,
  0x09, 0xD0, 0x47, 0x70, 0x3D, 0x0B, 0x77, 0x20, 0x5D, 0x0D, 0x02, 0x75, 0x01, 0x0C, 0xD0, 0x67,
  0x73, 0x0E, 0xD0, 0xE0, 0x57, 0x30, 0x30, 0xDE, 0x01, 0x77, 0x30, 0x7F, 0x82, 0xD7, 0x41, 0x28,
  0x21, 0x37, 0xCF, 0x09, 0x77, 0x50, 0xDF, 0xFF, 0x90, 0xE0, 0x17, 0x75, 0x03, 0x0E, 0xFF, 0xF0,
  0x37, 0x77, 0x04, 0x0E, 0xFF, 0xC0, 0xE0, 0x47, 0x77, 0x20, 0x20, 0xDF, 0xFA, 0x0C, 0x02, 0x77,
  0x75, 0x06, 0x0D, 0xFD, 0x0C, 0x05, 0x77, 0x77, 0x28, 0x92, 0x37, 0xBD, 0xEF, 0xED, 0xCA, 0x63,
  0x80, 0xBF, 0x00, 0x89, 0x42, 0x58, 0xBD, 0xDE, 0xFE, 0xDC, 0x96, 0x37, 0x77, 0x68, 0x11, 0x7C,
  0xFF, 0x81, 0xD8, 0x17, 0x77, 0x10, 0x10, 0x9F, 0xFE, 0x09, 0x01, 0x77, 0x50, 0x6F, 0xFF, 0xA0,
  0xE0, 0x47, 0x72, 0x01, 0x0B, 0xFF, 0xFD, 0x07, 0x77, 0x02, 0x0D, 0xFF, 0xFF, 0x08, 0x75, 0x02,
  0x0E, 0xFD, 0x85, 0xCA, 0x98, 0xAB, 0xEF, 0xC0, 0x67, 0x30, 0x10, 0xDF, 0xB0, 0x90, 0x47, 0x18,
  0x13, 0x8E, 0xFA, 0x03, 0x72, 0x0B, 0xFA, 0x09, 0x01, 0x75, 0x01, 0x0A, 0xF9, 0x0D, 0x71, 0x06,
  0xFA, 0x06, 0x77, 0x20, 0x8F, 0x90, 0x86, 0x01, 0x0E, 0xF9, 0x04, 0x77, 0x40, 0x9F, 0x0E, 0x01,
  0x50, 0x9F, 0x90, 0x57, 0x76, 0x0D, 0xF0, 0x74, 0x01, 0xF9, 0x09, 0x77, 0x70, 0x5F, 0x0D, 0x40,
  0x7F, 0x0E, 0x01, 0x77, 0x71, 0x0D, 0xF0, 0x43, 0x0E, 0xF0, 0x77, 0x77, 0x20, 0x7F, 0x08, 0x20,
  0x3F, 0x90, 0x17, 0x77, 0x20, 0x3F, 0x0C, 0x20, 0x7F, 0x0A, 0x77, 0x74, 0x0E, 0xF2, 0x0C, 0xF0,
  0x57, 0x77, 0x40, 0xBF, 0x02, 0x1F, 0x90, 0x17, 0x77, 0x40, 0xAF, 0x04, 0x02, 0xF0, 0xD7, 0x77,
  0x50, 0x8F, 0x06, 0x04, 0x80, 0xC6, 0xF0, 0x70, 0x68, 0x0C, 0x6F, 0x08, 0x07, 0x80, 0xC6, 0xF0,
  0x90, 0x88, 0x0C, 0x6F, 0x09, 0x08, 0x80, 0xC6, 0xF0, 0x09, 0x80, 0xC6, 0xF0, 0x90, 0x8F, 0x0C,
  0x80, 0xB6, 0x80, 0x50, 0x7F, 0x0A, 0x77, 0x77, 0x70, 0x6F, 0x0B, 0x77, 0x77, 0x70, 0x5F, 0x0C,
  0x77, 0x77, 0x70, 0x3F, 0x0E, 0x80, 0xC0, 0x0F, 0x90, 0x27, 0x77, 0x77, 0x0D, 0xF0, 0x57, 0x77,
  0x77, 0x09, 0xF0, 0xA7, 0x77, 0x77, 0x04, 0xF0, 0xE8, 0x0C, 0x00, 0x0E, 0xF0, 0x67, 0x77, 0x77,
  0x09, 0xF0, 0xD7, 0x77, 0x77, 0x03, 0xF9, 0x09, 0x77, 0x77, 0x70, 0xAF, 0x90, 0x57, 0x77, 0x76,
  0x02, 0xFA, 0x05, 0x77, 0x75, 0x01, 0x02, 0x60, 0x7F, 0xA0, 0x87, 0x77, 0x28, 0x24, 0xAF, 0x67,
  0x0B, 0xFA, 0x0D, 0x05, 0x77, 0x48, 0x13, 0x8D, 0xB0, 0x67, 0x01, 0x0D, 0xFB, 0x82, 0xE9, 0x41,
  0x73, 0x82, 0x15, 0x9D, 0xE0, 0x67, 0x10, 0x10, 0xDF, 0xE8, 0x90, 0xDB, 0xA9, 0x88, 0x9A, 0xCE,
  0xFB, 0x06, 0x72, 0x01, 0x0C, 0xFF, 0xFF, 0xC0, 0x67, 0x40, 0x8F, 0xFF, 0xFB, 0x06, 0x75, 0x03,
  0x0C, 0xFF, 0xFF, 0x0E, 0x04, 0x77, 0x05, 0x0C, 0xFF, 0xFB, 0x0B, 0x05, 0x77, 0x48, 0x13, 0x8D,
  0xFF, 0xB8, 0x2D, 0x95, 0x17, 0x77, 0x28, 0x52, 0x58, 0xAC, 0xDE, 0xA8, 0x6E, 0xDD, 0xB9, 0x74,
  0x17, 0x30,
  // "Ė" (U+0116)
  0x77, 0x28, 0x61, 0x8C, 0xEE, 0xC7, 0x17, 0x77, 0x72, 0x03, 0x0E, 0xE0, 0xE0, 0x37, 0x77, 0x71,
  0x0E, 0xF9, 0x0D, 0x77, 0x77, 0x05, 0xFB, 0x05, 0x77, 0x76, 0x09, 0xFB, 0x09, 0x77, 0x76, 0x0A,
  0xFB, 0x0A, 0x77, 0x76, 0x09, 0xFB, 0x09, 0x77, 0x76, 0x05, 0xFB, 0x05, 0x77, 0x77, 0x0D, 0xF9,
  0x0D, 0x77, 0x77, 0x10, 0x30, 0xEE, 0x0D, 0x02, 0x77, 0x77, 0x28, 0x61, 0x7C, 0xEE, 0xC7, 0x18,
  0x0D, 0xD2, 0x00, 0x78, 0x0C, 0x1F, 0x05, 0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05,
  0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05, 0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C,
  0x1F, 0x05, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77,
  0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72,
  0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07,
  0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0,
  0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7,
  0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77,
  0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xFF, 0xFF, 0xF0, 0x92, 0x07, 0xFF, 0xFF, 0xF0, 0x92,
  0x07, 0xFF, 0xFF, 0xF0, 0x92, 0x07, 0xFF, 0xFF, 0xF0, 0x92, 0x07, 0xFF, 0xFF, 0xF0, 0x92, 0x07,
  0xFF, 0xFF, 0xF0, 0x92, 0x07, 0xFF, 0xFF, 0xF0, 0x92, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0,
  0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7,
  0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77,
  0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72,
  0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07,
  0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0,
  0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7,
  0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0x80, 0xC1, 0xF0,
  0x50, 0x78, 0x0C, 0x1F, 0x05, 0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05, 0x07, 0x80,
  0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05, 0x07, 0x80, 0xC1, 0xF0, 0x50,
  // "ė" (U+0117)
  0x77, 0x48, 0x61, 0x8C, 0xEE, 0xC7, 0x17, 0x77, 0x77, 0x03, 0x0E, 0xE0, 0xE0, 0x37, 0x77, 0x76,
  0x0E, 0xF9, 0x0D, 0x77, 0x77, 0x50, 0x5F, 0xB0, 0x57, 0x77, 0x74, 0x09, 0xFB, 0x09, 0x77, 0x77,
  0x40, 0xAF, 0xB0, 0xA7, 0x77, 0x74, 0x09, 0xFB, 0x09, 0x77, 0x77, 0x40, 0x5F, 0xB0, 0x57, 0x77,
  0x75, 0x0D, 0xF9, 0x0D, 0x77, 0x77, 0x60, 0x30, 0xEE, 0x0D, 0x02, 0x77, 0x77, 0x78, 0x61, 0x7C,
  0xEE, 0xC7, 0x18, 0x0D, 0xF6, 0x08, 0x94, 0x25, 0x8B, 0xDD, 0xEF, 0xED, 0xC9, 0x63, 0x77, 0x76,
  0x81, 0x17, 0xCF, 0xF8, 0x1D, 0x81, 0x77, 0x71, 0x01, 0x09, 0xFF, 0xE0, 0x90, 0x17, 0x75, 0x06,
  0xFF, 0xFA, 0x0E, 0x04, 0x77, 0x20, 0x10, 0xBF, 0xFF, 0xD0, 0x77, 0x70, 0x20, 0xDF, 0xFF, 0xF0,
  0x87, 0x50, 0x20, 0xEF, 0xD8, 0x5C, 0xA9, 0x8A, 0xBE, 0xFC, 0x06, 0x73, 0x01, 0x0D, 0xFB, 0x09,
  0x04, 0x71, 0x81, 0x38, 0xEF, 0xA0, 0x37, 0x20, 0xBF, 0xA0, 0x90, 0x17, 0x50, 0x10, 0xAF, 0x90,
  0xD7, 0x10, 0x6F, 0xA0, 0x67, 0x72, 0x08, 0xF9, 0x08, 0x60, 0x10, 0xEF, 0x90, 0x47, 0x74, 0x09,
  0xF0, 0xE0, 0x15, 0x09, 0xF9, 0x05, 0x77, 0x60, 0xDF, 0x07, 0x40, 0x1F, 0x90, 0x97, 0x77, 0x05,
  0xF0, 0xD4, 0x07, 0xF0, 0xE0, 0x17, 0x77, 0x10, 0xDF, 0x04, 0x30, 0xEF, 0x07, 0x77, 0x72, 0x07,
  0xF0, 0x82, 0x03, 0xF9, 0x01, 0x77, 0x72, 0x03, 0xF0, 0xC2, 0x07, 0xF0, 0xA7, 0x77, 0x40, 0xEF,
  0x20, 0xCF, 0x05, 0x77, 0x74, 0x0B, 0xF0, 0x21, 0xF9, 0x01, 0x77, 0x74, 0x0A, 0xF0, 0x40, 0x2F,
  0x0D, 0x77, 0x75, 0x08, 0xF0, 0x60, 0x48, 0x0C, 0x6F, 0x07, 0x06, 0x80, 0xC6, 0xF0, 0x80, 0x78,
  0x0C, 0x6F, 0x09, 0x08, 0x80, 0xC6, 0xF0, 0x90, 0x88, 0x0C, 0x6F, 0x00, 0x98, 0x0C, 0x6F, 0x09,
  0x08, 0xF0, 0xC8, 0x0B, 0x68, 0x05, 0x07, 0xF0, 0xA7, 0x77, 0x77, 0x06, 0xF0, 0xB7, 0x77, 0x77,
  0x05, 0xF0, 0xC7, 0x77, 0x77, 0x03, 0xF0, 0xE8, 0x0C, 0x00, 0xF9, 0x02, 0x77, 0x77, 0x70, 0xDF,
  0x05, 0x77, 0x77, 0x70, 0x9F, 0x0A, 0x77, 0x77, 0x70, 0x4F, 0x0E, 0x80, 0xC0, 0x00, 0xEF, 0x06,
  0x77, 0x77, 0x70, 0x9F, 0x0D, 0x77, 0x77, 0x70, 0x3F, 0x90, 0x97, 0x77, 0x77, 0x0A, 0xF9, 0x05,
  0x77, 0x77, 0x60, 0x2F, 0xA0, 0x57, 0x77, 0x50, 0x10, 0x26, 0x07, 0xFA, 0x08, 0x77, 0x72, 0x82,
  0x4A, 0xF6, 0x70, 0xBF, 0xA0, 0xD0, 0x57, 0x74, 0x81, 0x38, 0xDB, 0x06, 0x70, 0x10, 0xDF, 0xB8,
  0x2E, 0x94, 0x17, 0x38, 0x21, 0x59, 0xDE, 0x06, 0x71, 0x01, 0x0D, 0xFE, 0x89, 0x0D, 0xBA, 0x98,
  0x89, 0xAC, 0xEF, 0xB0, 0x67, 0x20, 0x10, 0xCF, 0xFF, 0xFC, 0x06, 0x74, 0x08, 0xFF, 0xFF, 0xB0,
  0x67, 0x50, 0x30, 0xCF, 0xFF, 0xF0, 0xE0, 0x47, 0x70, 0x50, 0xCF, 0xFF, 0xB0, 0xB0, 0x57, 0x74,
  0x81, 0x38, 0xDF, 0xFB, 0x82, 0xD9, 0x51, 0x77, 0x72, 0x85, 0x25, 0x8A, 0xCD, 0xEA, 0x86, 0xED,
  0xDB, 0x97, 0x41, 0x73,
  // "Ę" (U+0118)
  0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05, 0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C,
  0x1F, 0x05, 0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05, 0x07, 0x80, 0xC1, 0xF0, 0x50,
  0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F,
  0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A,
  0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77,
  0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77,
  0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20,
  0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F,
  0x0A, 0x77, 0x77, 0x20, 0x7F, 0xFF, 0xFF, 0x09, 0x20, 0x7F, 0xFF, 0xFF, 0x09, 0x20, 0x7F, 0xFF,
  0xFF, 0x09, 0x20, 0x7F, 0xFF, 0xFF, 0x09, 0x20, 0x7F, 0xFF, 0xFF, 0x09, 0x20, 0x7F, 0xFF, 0xFF,
  0x09, 0x20, 0x7F, 0xFF, 0xFF, 0x09, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77,
  0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20,
  0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F,
  0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A,
  0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77,
  0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77,
  0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20,
  0x7F, 0x0A, 0x77, 0x77, 0x20, 0x7F, 0x0A, 0x77, 0x77, 0x20, 0x78, 0x0C, 0x1F, 0x05, 0x07, 0x80,
  0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05, 0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05,
  0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05, 0x77, 0x76, 0x06, 0xC0, 0xB0, 0x27, 0x77,
  0x73, 0x08, 0xD0, 0x87, 0x77, 0x73, 0x09, 0xD0, 0x87, 0x77, 0x73, 0x07, 0xD0, 0xA7, 0x77, 0x73,
  0x05, 0xD0, 0xC7, 0x77, 0x73, 0x01, 0x0E, 0xD0, 0x27, 0x77, 0x73, 0x09, 0xD0, 0x87, 0x77, 0x73,
  0x02, 0xE0, 0x17, 0x77, 0x73, 0x08, 0xD0, 0xB7, 0x77, 0x74, 0x0C, 0xD0, 0x77, 0x77, 0x74, 0xE0,
  0x67, 0x77, 0x73, 0x01, 0xE0, 0x67, 0x77, 0x73, 0x01, 0xE0, 0x97, 0x77, 0x74, 0xE0, 0xE0, 0x17,
  0x77, 0x73, 0x0B, 0xE8, 0x1D, 0x62, 0x28, 0x11, 0x34, 0x77, 0x73, 0x06, 0xFE, 0x0B, 0x77, 0x74,
  0x0D, 0xFD, 0x0B, 0x77, 0x74, 0x02, 0x0E, 0xFC, 0x0B, 0x77, 0x75, 0x02, 0x0B, 0xFB, 0x0B, 0x77,
  0x77, 0x89, 0x13, 0x8B, 0xDE, 0xFE, 0xDB, 0x83, 0x30,
  // "ę" (U+0119)
  0x77, 0x28, 0x94, 0x25, 0x8B, 0xDD, 0xEF, 0xED, 0xC9, 0x63, 0x77, 0x76, 0x81, 0x17, 0xCF, 0xF8,
  0x1D, 0x81, 0x77, 0x71, 0x01, 0x09, 0xFF, 0xE0, 0x90, 0x17, 0x75, 0x06, 0xFF, 0xFA, 0x0E, 0x04,
  0x77, 0x20, 0x10, 0xBF, 0xFF, 0xD0, 0x77, 0x70, 0x20, 0xDF, 0xFF, 0xF0, 0x87, 0x50, 0x20, 0xEF,
  0xD8, 0x5C, 0xA9, 0x8A, 0xBE, 0xFC, 0x06, 0x73, 0x01, 0x0D, 0xFB, 0x09, 0x04, 0x71, 0x81, 0x38,
  0xEF, 0xA0, 0x37, 0x20, 0xBF, 0xA0, 0x90, 0x17, 0x50, 0x10, 0xAF, 0x90, 0xD7, 0x10, 0x6F, 0xA0,
  0x67, 0x72, 0x08, 0xF9, 0x08, 0x60, 0x10, 0xEF, 0x90, 0x47, 0x74, 0x09, 0xF0, 0xE0, 0x15, 0x09,
  0xF9, 0x05, 0x77, 0x60, 0xDF, 0x07, 0x40, 0x1F, 0x90, 0x97, 0x77, 0x05, 0xF0, 0xD4, 0x07, 0xF0,
  0xE0, 0x17, 0x77, 0x10, 0xDF, 0x04, 0x30, 0xEF, 0x07, 0x77, 0x72, 0x07, 0xF0, 0x82, 0x03, 0xF9,
  0x01, 0x77, 0x72, 0x03, 0xF0, 0xC2, 0x07, 0xF0, 0xA7, 0x77, 0x40, 0xEF, 0x20, 0xCF, 0x05, 0x77,
  0x74, 0x0B, 0xF0, 0x21, 0xF9, 0x01, 0x77, 0x74, 0x0A, 0xF0, 0x40, 0x2F, 0x0D, 0x77, 0x75, 0x08,
  0xF0, 0x60, 0x48, 0x0C, 0x6F, 0x07, 0x06, 0x80, 0xC6, 0xF0, 0x80, 0x78, 0x0C, 0x6F, 0x09, 0x08,
  0x80, 0xC6, 0xF0, 0x90, 0x88, 0x0C, 0x6F, 0x00, 0x98, 0x0C, 0x6F, 0x09, 0x08, 0xF0, 0xC8, 0x0B,
  0x68, 0x05, 0x07, 0xF0, 0xA7, 0x77, 0x77, 0x06, 0xF0, 0xB7, 0x77, 0x77, 0x05, 0xF0, 0xC7, 0x77,
  0x77, 0x03, 0xF0, 0xE8, 0x0C, 0x00, 0xF9, 0x02, 0x77, 0x77, 0x70, 0xDF, 0x05, 0x77, 0x77, 0x70,
  0x9F, 0x0A, 0x77, 0x77, 0x70, 0x4F, 0x0E, 0x80, 0xC0, 0x00, 0xEF, 0x06, 0x77, 0x77, 0x70, 0x9F,
  0x0D, 0x77, 0x77, 0x70, 0x3F, 0x90, 0x97, 0x77, 0x77, 0x0A, 0xF9, 0x05, 0x77, 0x77, 0x60, 0x2F,
  0xA0, 0x57, 0x77, 0x50, 0x10, 0x26, 0x07, 0xFA, 0x08, 0x77, 0x72, 0x82, 0x4A, 0xF6, 0x70, 0xBF,
  0xA0, 0xD0, 0x57, 0x74, 0x81, 0x38, 0xDB, 0x06, 0x70, 0x10, 0xDF, 0xB8, 0x2E, 0x94, 0x17, 0x38,
  0x21, 0x59, 0xDE, 0x06, 0x71, 0x01, 0x0D, 0xFE, 0x89, 0x0D, 0xBA, 0x98, 0x89, 0xAC, 0xEF, 0xB0,
  0x67, 0x20, 0x10, 0xCF, 0xFF, 0xFC, 0x06, 0x74, 0x08, 0xFF, 0xFF, 0xB0, 0x67, 0x50, 0x30, 0xCF,
  0xFF, 0xF9, 0x05, 0x77, 0x05, 0x0C, 0xFF, 0xFD, 0x06, 0x77, 0x38, 0x13, 0x8D, 0xFF, 0xF0, 0xE0,
  0x47, 0x77, 0x85, 0x25, 0x8A, 0xCD, 0xEA, 0x84, 0xEE, 0xDB, 0x9B, 0xD0, 0xD0, 0x27, 0x77, 0x77,
  0x04, 0xD0, 0xD0, 0x17, 0x77, 0x77, 0x05, 0xD0, 0xD0, 0x17, 0x77, 0x77, 0x03, 0xD0, 0xD0, 0x17,
  0x77, 0x77, 0x01, 0x0D, 0xD0, 0x38, 0x0C, 0x00, 0x09, 0xD0, 0x88, 0x0C, 0x00, 0x02, 0xD0, 0xE0,
  0x18, 0x0C, 0x00, 0x08, 0xD0, 0xA8, 0x0C, 0x10, 0x0D, 0xD0, 0x68, 0x0C, 0x00, 0x01, 0xE0, 0x58,
  0x0C, 0x00, 0x02, 0xE0, 0x48, 0x0C, 0x00, 0x03, 0xE0, 0x58, 0x0C, 0x00, 0x01, 0xE0, 0x98, 0x0C,
  0x10, 0x0E, 0xE0, 0x38, 0x0C, 0x00, 0x0A, 0xE8, 0x1E, 0x72, 0x28, 0x11, 0x34, 0x77, 0x77, 0x10,
  0x4F, 0xE0, 0x97, 0x77, 0x72, 0x0A, 0xFD, 0x09, 0x77, 0x77, 0x20, 0x10, 0xCF, 0xC0, 0x97, 0x77,
  0x74, 0x09, 0xFB, 0x09, 0x77, 0x77, 0x58, 0x91, 0x27, 0xBD, 0xEF, 0xED, 0xA7, 0x33,
  // "Ě" (U+011A)
  0x40, 0x18, 0x01, 0x70, 0x47, 0x74, 0x05, 0x80, 0x17, 0x01, 0x70, 0x2E, 0x08, 0x77, 0x10, 0x10,
  0xAE, 0x02, 0x71, 0x08, 0xE0, 0xC0, 0x17, 0x50, 0x30, 0xDE, 0x08, 0x73, 0x09, 0xE0, 0xD0, 0x37,
  0x30, 0x50, 0xEE, 0x08, 0x75, 0x0A, 0xF0, 0x57, 0x10, 0x7F, 0x09, 0x77, 0x0B, 0xF0, 0x66, 0x09,
  0xF0, 0x97, 0x72, 0x0C, 0xF0, 0x74, 0x0A, 0xF0, 0xA7, 0x73, 0x01, 0x0D, 0xF0, 0x62, 0x0A, 0xF0,
  0xC7, 0x75, 0x02, 0x0E, 0xF0, 0x60, 0xBF, 0x0D, 0x01, 0x77, 0x60, 0x4F, 0xF9, 0x0D, 0x01, 0x77,
  0x71, 0x05, 0xFE, 0x0E, 0x02, 0x77, 0x73, 0x08, 0xFD, 0x05, 0x77, 0x75, 0x0C, 0xFB, 0x08, 0x77,
  0x76, 0x02, 0x0E, 0xF9, 0x0D, 0x77, 0x77, 0x10, 0x7F, 0x90, 0x48, 0x0B, 0xE4, 0x00, 0x78, 0x0C,
  0x1F, 0x05, 0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05, 0x07, 0x80, 0xC1, 0xF0, 0x50,
  0x78, 0x0C, 0x1F, 0x05, 0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05, 0x07, 0xF0, 0xA7,
  0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77,
  0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72,
  0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07,
  0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0,
  0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7,
  0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77,
  0x72, 0x07, 0xFF, 0xFF, 0xF0, 0x92, 0x07, 0xFF, 0xFF, 0xF0, 0x92, 0x07, 0xFF, 0xFF, 0xF0, 0x92,
  0x07, 0xFF, 0xFF, 0xF0, 0x92, 0x07, 0xFF, 0xFF, 0xF0, 0x92, 0x07, 0xFF, 0xFF, 0xF0, 0x92, 0x07,
  0xFF, 0xFF, 0xF0, 0x92, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0,
  0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7,
  0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77,
  0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72,
  0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07,
  0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0,
  0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0xF0, 0xA7,
  0x77, 0x72, 0x07, 0xF0, 0xA7, 0x77, 0x72, 0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05,
  0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C, 0x1F, 0x05, 0x07, 0x80, 0xC1, 0xF0, 0x50, 0x78, 0x0C,
  0x1F, 0x05, 0x07, 0x80, 0xC1, 0xF0, 0x50,
  // "ě" (U+011B)
  0x60, 0x18, 0x01, 0x70, 0x47, 0x74, 0x05, 0x80, 0x17, 0x01, 0x75, 0x02, 0xE0, 0x87, 0x71, 0x01,
  0x0A, 0xE0, 0x27, 0x60, 0x8E, 0x0C, 0x01, 0x75, 0x03, 0x0D, 0xE0, 0x87, 0x71, 0x09, 0xE0, 0xD0,
  0x37, 0x30, 0x50, 0xEE, 0x08, 0x77, 0x30, 0xAF, 0x05, 0x71, 0x07, 0xF0, 0x97, 0x75, 0x0B, 0xF0,
  0x66, 0x09, 0xF0, 0x97, 0x77, 0x0C, 0xF0, 0x74, 0x0A, 0xF0, 0xA7, 0x77, 0x10, 0x10, 0xDF, 0x06,
  0x20, 0xAF, 0x0C, 0x77, 0x73, 0x02, 0x0E, 0xF0, 0x60, 0xBF, 0x0D, 0x01, 0x77, 0x74, 0x04, 0xFF,
  0x90, 0xD0, 0x17, 0x77, 0x60, 0x5F, 0xE0, 0xE0, 0x27, 0x77, 0x71, 0x08, 0xFD, 0x05, 0x77, 0x77,
  0x30, 0xCF, 0xB0, 0x87, 0x77, 0x74, 0x02, 0x0E, 0xF9, 0x0D, 0x77, 0x77, 0x60, 0x7F, 0x90, 0x48,
  0x0B, 0xF1, 0x08, 0x94, 0x25, 0x8B, 0xDD, 0xEF, 0xED, 0xC9, 0x63, 0x77, 0x76, 0x81, 0x17, 0xCF,
  0xF8, 0x1D, 0x81, 0x77, 0x71, 0x01, 0x09, 0xFF, 0xE0, 0x90, 0x17, 0x75, 0x06, 0xFF, 0xFA, 0x0E,
  0x04, 0x77, 0x20, 0x10, 0xBF, 0xFF, 0xD0, 0x77, 0x70, 0x20, 0xDF, 0xFF, 0xF0, 0x87, 0x50, 0x20,
  0xEF, 0xD8, 0x5C, 0xA9, 0x8A, 0xBE, 0xFC, 0x06, 0x73, 0x01, 0x0D, 0xFB, 0x09, 0x04, 0x71, 0x81,
  0x38, 0xEF, 0xA0, 0x37, 0x20, 0xBF, 0xA0, 0x90, 0x17, 0x50, 0x10, 0xAF, 0x90, 0xD7, 0x10, 0x6F,
  0xA0, 0x67, 0x72, 0x08, 0xF9, 0x08, 0x60, 0x10, 0xEF, 0x90, 0x47, 0x74, 0x09, 0xF0, 0xE0, 0x15,
  0x09, 0xF9, 0x05, 0x77, 0x60, 0xDF, 0x07, 0x40, 0x1F, 0x90, 0x97, 0x77, 0x05, 0xF0, 0xD4, 0x07,
  0xF0, 0xE0, 0x17, 0x77, 0x10, 0xDF, 0x04, 0x30, 0xEF, 0x07, 0x77, 0x72, 0x07, 0xF0, 0x82, 0x03,
  0xF9, 0x01, 0x77, 0x72, 0x03, 0xF0, 0xC2, 0x07, 0xF0, 0xA7, 0x77, 0x40, 0xEF, 0x20, 0xCF, 0x05,
  0x77, 0x74, 0x0B, 0xF0, 0x21, 0xF9, 0x01, 0x77, 0x74, 0x0A, 0xF0, 0x40, 0x2F, 0x0D, 0x77, 0x75,
  0x08, 0xF0, 0x60, 0x48, 0x0C, 0x6F, 0x07, 0x06, 0x80, 0xC6, 0xF0, 0x80, 0x78, 0x0C, 0x6F, 0x09,
  0x08, 0x80, 0xC6, 0xF0, 0x90, 0x88, 0x0C, 0x6F, 0x00, 0x98, 0x0C, 0x6F, 0x09, 0x08, 0xF0, 0xC8,
  0x0B, 0x68, 0x05, 0x07, 0xF0, 0xA7, 0x77, 0x77, 0x06, 0xF0, 0xB7, 0x77, 0x77, 0x05, 0xF0, 0xC7,
  0x77, 0x77, 0x03, 0xF0, 0xE8, 0x0C, 0x00, 0xF9, 0x02, 0x77, 0x77, 0x70, 0xDF, 0x05, 0x77, 0x77,
  0x70, 0x9F, 0x0A, 0x77, 0x77, 0x70, 0x4F, 0x0E, 0x80, 0xC0, 0x00, 0xEF, 0x06, 0x77, 0x77, 0x70,
  0x9F, 0x0D, 0x77, 0x77, 0x70, 0x3F, 0x90, 0x97, 0x77, 0x77, 0x0A, 0xF9, 0x05, 0x77, 0x77, 0x60,
  0x2F, 0xA0, 0x57, 0x77, 0x50, 0x10, 0x26, 0x07, 0xFA, 0x08, 0x77, 0x72, 0x82, 0x4A, 0xF6, 0x70,
  0xBF, 0xA0, 0xD0, 0x57, 0x74, 0x81, 0x38, 0xDB, 0x06, 0x70, 0x10, 0xDF, 0xB8, 0x2E, 0x94, 0x17,
  0x38, 0x21, 0x59, 0xDE, 0x06, 0x71, 0x01, 0x0D, 0xFE, 0x89, 0x0D, 0xBA, 0x98, 0x89, 0xAC, 0xEF,
  0xB0, 0x67, 0x20, 0x10, 0xCF, 0xFF, 0xFC, 0x06, 0x74, 0x08, 0xFF, 0xFF, 0xB0, 0x67, 0x50, 0x30,
  0xCF, 0xFF, 0xF0, 0xE0, 0x47, 0x70, 0x50, 0xCF, 0xFF, 0xB0, 0xB0, 0x57, 0x74, 0x81, 0x38, 0xDF,
  0xFB, 0x82, 0xD9, 0x51, 0x77, 0x72, 0x85, 0x25, 0x8A, 0xCD, 0xEA, 0x86, 0xED, 0xDB, 0x97, 0x41,
  0x73,
  // "Ĝ" (U+011C)
  0x77, 0x60, 0x28, 0x04, 0x77, 0x77, 0x77, 0x0C, 0xF9, 0x08, 0x77, 0x77, 0x50, 0x6F, 0xB0, 0x37,
  0x77, 0x73, 0x03, 0xFC, 0x0D, 0x01, 0x77, 0x77, 0x20, 0xDF, 0xD0, 0xA7, 0x77, 0x71, 0x0B, 0xFF,
  0x07, 0x77, 0x76, 0x08, 0xF0, 0xA0, 0xDF, 0x05, 0x77, 0x74, 0x06, 0xF8, 0x29, 0x01, 0xDF, 0x03,
  0x77, 0x72, 0x04, 0xF0, 0x93, 0x01, 0x0D, 0xE0, 0xE0, 0x27, 0x77, 0x02, 0x0E, 0xE0, 0x95, 0x01,
  0x0C, 0xE0, 0xD0, 0x17, 0x75, 0x01, 0x0D, 0xE0, 0x87, 0x01, 0x0C, 0xE0, 0xC7, 0x75, 0x0C, 0xE0,
  0x87, 0x20, 0x10, 0xBE, 0x0B, 0x77, 0x30, 0xBE, 0x06, 0x75, 0x0A, 0xE0, 0xA7, 0x71, 0x0A, 0xD0,
  0xE0, 0x47, 0x70, 0x7E, 0x0A, 0x76, 0x03, 0xD0, 0xB0, 0x17, 0x72, 0x03, 0x0D, 0xD0, 0x38, 0x0B,
  0xD7, 0x08, 0x96, 0x37, 0x9B, 0xDE, 0xEF, 0xED, 0xDC, 0xA7, 0x41, 0x77, 0x73, 0x81, 0x16, 0xBF,
  0xFB, 0x81, 0xD8, 0x37, 0x75, 0x02, 0x09, 0xFF, 0xFA, 0x0D, 0x07, 0x77, 0x10, 0x10, 0x9F, 0xFF,
  0xE0, 0xE0, 0x87, 0x50, 0x40, 0xEF, 0xFF, 0xF9, 0x09, 0x74, 0x08, 0xFF, 0xFF, 0xB0, 0x37, 0x30,
  0xAF, 0xFF, 0xFB, 0x0B, 0x73, 0x09, 0xFD, 0x84, 0xD9, 0x64, 0x11, 0x28, 0x41, 0x23, 0x6A, 0xDE,
  0x05, 0x72, 0x08, 0xFC, 0x0A, 0x04, 0x77, 0x81, 0x39, 0xEA, 0x0D, 0x72, 0x05, 0xFB, 0x0B, 0x02,
  0x77, 0x58, 0x17, 0xE7, 0x71, 0x01, 0x0E, 0xFA, 0x07, 0x77, 0x71, 0x01, 0x72, 0x0A, 0xFA, 0x05,
  0x77, 0x77, 0x40, 0x3F, 0xA0, 0x57, 0x77, 0x75, 0x0C, 0xF9, 0x08, 0x77, 0x77, 0x50, 0x4F, 0x90,
  0xC7, 0x77, 0x76, 0x0B, 0xF9, 0x03, 0x77, 0x77, 0x50, 0x2F, 0x90, 0xA7, 0x77, 0x76, 0x07, 0xF9,
  0x03, 0x77, 0x77, 0x60, 0xCF, 0x0C, 0x77, 0x77, 0x60, 0x2F, 0x90, 0x67, 0x77, 0x76, 0x06, 0xF9,
  0x01, 0x77, 0x77, 0x60, 0x9F, 0x0C, 0x77, 0x77, 0x70, 0xDF, 0x07, 0x77, 0x77, 0x7F, 0x90, 0x47,
  0x77, 0x76, 0x03, 0xF9, 0x01, 0x77, 0x77, 0x60, 0x5F, 0x0E, 0x77, 0x77, 0x70, 0x8F, 0x0C, 0x77,
  0x77, 0x70, 0x9F, 0x0A, 0x77, 0x77, 0x70, 0xAF, 0x08, 0x77, 0x77, 0x70, 0xCF, 0x07, 0x77, 0x77,
  0x70, 0xDF, 0x06, 0x77, 0x77, 0x70, 0xDF, 0x05, 0x77, 0x10, 0xCF, 0xFC, 0x0A, 0x0E, 0xF0, 0x57,
  0x71, 0x0C, 0xFF, 0xC0, 0xA0, 0xEF, 0x05, 0x77, 0x10, 0xCF, 0xFC, 0x0A, 0x0E, 0xF0, 0x57, 0x71,
  0x0C, 0xFF, 0xC0, 0xA0, 0xEF, 0x06, 0x77, 0x10, 0xCF, 0xFC, 0x0A, 0x0D, 0xF0, 0x67, 0x71, 0x0C,
  0xFF, 0xC0, 0xA0, 0xDF, 0x07, 0x77, 0x10, 0xCF, 0xFC, 0x0A, 0x0C, 0xF0, 0x87, 0x77, 0x50, 0x1F,
  0x00, 0xAF, 0x0A, 0x77, 0x75, 0x01, 0xF0, 0xA0, 0x9F, 0x0C, 0x77, 0x75, 0x01, 0xF0, 0xA0, 0x7F,
  0x0E, 0x77, 0x75, 0x01, 0xF0, 0xA0, 0x5F, 0x90, 0x17, 0x77, 0x40, 0x1F, 0x0A, 0x03, 0xF9, 0x04,
  0x77, 0x74, 0x01, 0xF0, 0xA1, 0xF9, 0x08, 0x77, 0x74, 0x01, 0xF8, 0x1A, 0x0C, 0xF0, 0xC7, 0x77,
  0x40, 0x1F, 0x81, 0xA0, 0x9F, 0x90, 0x17, 0x77, 0x30, 0x1F, 0x81, 0xA0, 0x5F, 0x90, 0x67, 0x77,
  0x30, 0x1F, 0x81, 0xA0, 0x1F, 0x90, 0xC7, 0x77, 0x30, 0x1F, 0x0A, 0x20, 0xBF, 0x90, 0x37, 0x77,
  0x20, 0x1F, 0x0A, 0x20, 0x5F, 0x90, 0xB7, 0x77, 0x20, 0x1F, 0x0A, 0x30, 0xEF, 0x90, 0x47, 0x77,
  0x10, 0x1F, 0x0A, 0x30, 0x8F, 0x90, 0xD0, 0x17, 0x77, 0x01, 0xF0, 0xA3, 0x01, 0x0E, 0xF9, 0x0B,
  0x77, 0x70, 0x1F, 0x0A, 0x40, 0x7F, 0xA0, 0xA7, 0x76, 0x01, 0xF0, 0xA5, 0x0D, 0xFA, 0x0A, 0x77,
  0x50, 0x1F, 0x0A, 0x50, 0x3F, 0xB0, 0xD0, 0x47, 0x73, 0x01, 0xF0, 0xA6, 0x07, 0xFC, 0x0B, 0x05,
  0x77, 0x10, 0x5F, 0x0A, 0x70, 0x9F, 0xD8, 0x4E, 0xA7, 0x32, 0x12, 0x84, 0x11, 0x35, 0x8C, 0xFA,
  0x0A, 0x71, 0x0A, 0xFF, 0xFF, 0xE0, 0xA7, 0x20, 0x8F, 0xFF, 0xFD, 0x0A, 0x73, 0x05, 0x0E, 0xFF,
  0xFF, 0xB0, 0xA7, 0x40, 0x10, 0xAF, 0xFF, 0xFA, 0x09, 0x76, 0x03, 0x0A, 0xFF, 0xFC, 0x81, 0xD8,
  0x37, 0x72, 0x81, 0x17, 0xCF, 0xFC, 0x82, 0xEA, 0x62, 0x77, 0x72, 0x89, 0x74, 0x79, 0xBD, 0xEE,
  0xFE, 0xED, 0xCB, 0x96, 0x42, 0x71,
  // "ĝ" (U+011D)
  0x77, 0x30, 0x28, 0x04, 0x77, 0x77, 0x75, 0x0C, 0xF9, 0x08, 0x77, 0x77, 0x30, 0x6F, 0xB0, 0x37,
  0x77, 0x71, 0x03, 0xFC, 0x0D, 0x01, 0x77, 0x77, 0x0D, 0xFD, 0x0A, 0x77, 0x76, 0x0B, 0xFF, 0x07,
  0x77, 0x74, 0x08, 0xF0, 0xA0, 0xDF, 0x05, 0x77, 0x72, 0x06, 0xF8, 0x29, 0x01, 0xDF, 0x03, 0x77,
  0x70, 0x4F, 0x09, 0x30, 0x10, 0xDE, 0x0E, 0x02, 0x77, 0x50, 0x20, 0xEE, 0x09, 0x50, 0x10, 0xCE,
  0x0D, 0x01, 0x77, 0x30, 0x10, 0xDE, 0x08, 0x70, 0x10, 0xCE, 0x0C, 0x77, 0x30, 0xCE, 0x08, 0x72,
  0x01, 0x0B, 0xE0, 0xB7, 0x71, 0x0B, 0xE0, 0x67, 0x50, 0xAE, 0x0A, 0x76, 0x0A, 0xD0, 0xE0, 0x47,
  0x70, 0x7E, 0x0A, 0x74, 0x03, 0xD0, 0xB0, 0x17, 0x72, 0x03, 0x0D, 0xD0, 0x38, 0x0B, 0xB7, 0x08,
  0x93, 0x15, 0x9B, 0xDE, 0xFE, 0xEC, 0xA7, 0x37, 0x77, 0x60, 0x40, 0xBF, 0xE8, 0x1E, 0x81, 0x60,
  0xCD, 0x0C, 0x72, 0x03, 0x0C, 0xFF, 0xB0, 0xE0, 0x65, 0x0E, 0xD0, 0xC7, 0x10, 0x7F, 0xFF, 0x0A,
  0x30, 0x2E, 0x0C, 0x70, 0xAF, 0xFF, 0xA0, 0xB2, 0x05, 0xE0, 0xC6, 0x0A, 0xFF, 0xFC, 0x81, 0xA0,
  0x7E, 0x0C, 0x50, 0x8F, 0xD8, 0x5C, 0xA9, 0x89, 0xBD, 0xF9, 0x07, 0x0B, 0xE0, 0xC4, 0x04, 0xFB,
  0x0B, 0x05, 0x71, 0x81, 0x27, 0xEF, 0xE0, 0xC3, 0x01, 0x0E, 0xF9, 0x0E, 0x04, 0x76, 0x09, 0xFD,
  0x0C, 0x30, 0x8F, 0x90, 0xD0, 0x17, 0x71, 0x05, 0xFC, 0x0C, 0x20, 0x1F, 0x90, 0xE0, 0x17, 0x73,
  0x05, 0xFB, 0x0C, 0x20, 0x8F, 0x90, 0x47, 0x75, 0x08, 0xFA, 0x0C, 0x20, 0xEF, 0x0C, 0x77, 0x70,
  0xDF, 0x98, 0x1C, 0x05, 0xF9, 0x04, 0x77, 0x70, 0x6F, 0x98, 0x1C, 0x0A, 0xF0, 0xD7, 0x77, 0x20,
  0xEF, 0x81, 0xC0, 0xEF, 0x08, 0x77, 0x72, 0x0A, 0xF0, 0xC0, 0x2F, 0x90, 0x37, 0x77, 0x20, 0x6F,
  0x0C, 0x05, 0xF0, 0xE7, 0x77, 0x30, 0x2F, 0x0C, 0x08, 0xF0, 0xC7, 0x77, 0x4F, 0x0C, 0x0A, 0xF0,
  0x97, 0x77, 0x40, 0xDE, 0x00, 0xCF, 0x07, 0x77, 0x74, 0x0B, 0xE0, 0xC0, 0xDF, 0x06, 0x77, 0x74,
  0x09, 0xE0, 0xC0, 0xEF, 0x05, 0x77, 0x74, 0x08, 0xE0, 0xCF, 0x90, 0x47, 0x77, 0x40, 0x8E, 0x0C,
  0xF9, 0x04, 0x77, 0x74, 0x07, 0xE0, 0xCF, 0x90, 0x37, 0x77, 0x40, 0x7E, 0x0C, 0xF9, 0x04, 0x77,
  0x74, 0x07, 0xE0, 0xCF, 0x90, 0x47, 0x77, 0x40, 0x7E, 0x0C, 0x0E, 0xF0, 0x57, 0x77, 0x40, 0x8E,
  0x0C, 0x0D, 0xF0, 0x77, 0x77, 0x40, 0x8E, 0x0C, 0x0B, 0xF0, 0x97, 0x77, 0x40, 0xAE, 0x0C, 0x09,
  0xF0, 0xB7, 0x77, 0x40, 0xCE, 0x0C, 0x06, 0xF0, 0xE7, 0x77, 0x40, 0xEE, 0x0C, 0x03, 0xF9, 0x03,
  0x77, 0x72, 0x02, 0xF0, 0xC1, 0xF9, 0x07, 0x77, 0x72, 0x05, 0xF8, 0x1C, 0x0B, 0xF0, 0xD7, 0x77,
  0x20, 0xAF, 0x81, 0xC0, 0x6F, 0x90, 0x47, 0x77, 0x01, 0xF9, 0x81, 0xC0, 0x1F, 0x90, 0xB7, 0x77,
  0x08, 0xF9, 0x0C, 0x20, 0xAF, 0x90, 0x57, 0x75, 0x02, 0xFA, 0x0C, 0x20, 0x3F, 0x90, 0xE0, 0x27,
  0x73, 0x01, 0x0C, 0xFA, 0x0C, 0x30, 0xBF, 0x90, 0xD0, 0x27, 0x71, 0x01, 0x0D, 0xFB, 0x0C, 0x30,
  0x2F, 0xA0, 0xE0, 0x67, 0x60, 0x50, 0xDF, 0xC0, 0xC4, 0x07, 0xFB, 0x81, 0xC6, 0x17, 0x81, 0x15,
  0xCF, 0xE0, 0xC5, 0x0B, 0xFD, 0x85, 0xDA, 0x98, 0x9A, 0xCF, 0xA0, 0xCE, 0x0C, 0x60, 0xCF, 0xFF,
  0xD0, 0x60, 0x8E, 0x0C, 0x70, 0xBF, 0xFF, 0xB8, 0x18, 0x0A, 0xE0, 0xC7, 0x10, 0x8F, 0xFF, 0x90,
  0x82, 0x0B, 0xE0, 0xC7, 0x20, 0x30, 0xCF, 0xFC, 0x0E, 0x05, 0x30, 0xBE, 0x0C, 0x74, 0x04, 0x0A,
  0xFF, 0x0D, 0x07, 0x50, 0xBE, 0x0C, 0x76, 0x84, 0x15, 0x8B, 0xDE, 0xA8, 0x4E, 0xDC, 0xA6, 0x37,
  0x0B, 0xE0, 0xC7, 0x77, 0x76, 0x0C, 0xE0, 0xC7, 0x77, 0x76, 0x0D, 0xE0, 0xB7, 0x77, 0x76, 0x0E,
  0xE0, 0xB7, 0x77, 0x76, 0xF0, 0x97, 0x77, 0x75, 0x03, 0xF0, 0x87, 0x77, 0x75, 0x06, 0xF0, 0x67,
  0x77, 0x75, 0x0B, 0xF0, 0x37, 0x77, 0x74, 0x02, 0xF0, 0xE7, 0x77, 0x75, 0x08, 0xF0, 0xA7, 0x77,
  0x74, 0x03, 0xF9, 0x06, 0x30, 0x30, 0x17, 0x77, 0x60, 0xDF, 0x0E, 0x48, 0x28, 0xE8, 0x27, 0x77,
  0x20, 0x10, 0xCF, 0x90, 0x84, 0x08, 0xB8, 0x1B, 0x61, 0x77, 0x50, 0x50, 0xEF, 0x90, 0xE0, 0x14,
  0x08, 0xE8, 0x3D, 0x96, 0x41, 0x74, 0x81, 0x37, 0xDF, 0xB0, 0x55, 0x08, 0xFC, 0x89, 0x0E, 0xCB,
  0xA9, 0x88, 0x9A, 0xCF, 0xE0, 0xA6, 0x08, 0xFF, 0xFF, 0xD0, 0xB7, 0x08, 0xFF, 0xFF, 0xC0, 0xA7,
  0x10, 0x50, 0xEF, 0xFF, 0xF9, 0x0E, 0x06, 0x74, 0x05, 0x0A, 0xFF, 0xFC, 0x81, 0xE8, 0x17, 0x71,
  0x81, 0x48, 0xCF, 0xFD, 0x81, 0xB6, 0x17, 0x77, 0x86, 0x35, 0x8A, 0xCD, 0xDE, 0xA8, 0x5E, 0xED,
  0xB9, 0x64, 0x77,
  // "Ğ" (U+011E)
  0x74, 0x0D, 0xC0, 0x67, 0x72, 0x06, 0xD7, 0x72, 0x0C, 0xC0, 0xB7, 0x72, 0x0B, 0xC0, 0xD7, 0x72,
  0x09, 0xD0, 0x47, 0x70, 0x3D, 0x0B, 0x77, 0x20, 0x5D, 0x0D, 0x02, 0x75, 0x01, 0x0C, 0xD0, 0x67,
  0x73, 0x0E, 0xD0, 0xE0, 0x57, 0x30, 0x30, 0xDE, 0x01, 0x77, 0x30, 0x7F, 0x82, 0xD7, 0x41, 0x28,
  0x21, 0x37, 0xCF, 0x09, 0x77, 0x50, 0xDF, 0xFF, 0x90, 0xE0, 0x17, 0x75, 0x03, 0x0E, 0xFF, 0xF0,
  0x37, 0x77, 0x04, 0x0E, 0xFF, 0xC0, 0xE0, 0x47, 0x77, 0x20, 0x20, 0xDF, 0xFA, 0x0C, 0x02, 0x77,
  0x75, 0x06, 0x0D, 0xFD, 0x0C, 0x05, 0x77, 0x77, 0x28, 0x92, 0x37, 0xBD, 0xEF, 0xED, 0xCA, 0x63,
  0x80, 0xBF, 0x10, 0x89, 0x63, 0x79, 0xBD, 0xEE, 0xFE, 0xDD, 0xCA, 0x74, 0x17, 0x77, 0x38, 0x11,
  0x6B, 0xFF, 0xB8, 0x1D, 0x83, 0x77, 0x50, 0x20, 0x9F, 0xFF, 0xA0, 0xD0, 0x77, 0x71, 0x01, 0x09,
  0xFF, 0xFE, 0x0E, 0x08, 0x75, 0x04, 0x0E, 0xFF, 0xFF, 0x90, 0x97, 0x40, 0x8F, 0xFF, 0xFB, 0x03,
  0x73, 0x0A, 0xFF, 0xFF, 0xB0, 0xB7, 0x30, 0x9F, 0xD8, 0x4D, 0x96, 0x41, 0x12, 0x84, 0x12, 0x36,
  0xAD, 0xE0, 0x57, 0x20, 0x8F, 0xC0, 0xA0, 0x47, 0x78, 0x13, 0x9E, 0xA0, 0xD7, 0x20, 0x5F, 0xB0,
  0xB0, 0x27, 0x75, 0x81, 0x7E, 0x77, 0x10, 0x10, 0xEF, 0xA0, 0x77, 0x77, 0x10, 0x17, 0x20, 0xAF,
  0xA0, 0x57, 0x77, 0x74, 0x03, 0xFA, 0x05, 0x77, 0x77, 0x50, 0xCF, 0x90, 0x87, 0x77, 0x75, 0x04,
  0xF9, 0x0C, 0x77, 0x77, 0x60, 0xBF, 0x90, 0x37, 0x77, 0x75, 0x02, 0xF9, 0x0A, 0x77, 0x77, 0x60,
  0x7F, 0x90, 0x37, 0x77, 0x76, 0x0C, 0xF0, 0xC7, 0x77, 0x76, 0x02, 0xF9, 0x06, 0x77, 0x77, 0x60,
  0x6F, 0x90, 0x17, 0x77, 0x76, 0x09, 0xF0, 0xC7, 0x77, 0x77, 0x0D, 0xF0, 0x77, 0x77, 0x77, 0xF9,
  0x04, 0x77, 0x77, 0x60, 0x3F, 0x90, 0x17, 0x77, 0x76, 0x05, 0xF0, 0xE7, 0x77, 0x77, 0x08, 0xF0,
  0xC7, 0x77, 0x77, 0x09, 0xF0, 0xA7, 0x77, 0x77, 0x0A, 0xF0, 0x87, 0x77, 0x77, 0x0C, 0xF0, 0x77,
  0x77, 0x77, 0x0D, 0xF0, 0x67, 0x77, 0x77, 0x0D, 0xF0, 0x57, 0x71, 0x0C, 0xFF, 0xC0, 0xA0, 0xEF,
  0x05, 0x77, 0x10, 0xCF, 0xFC, 0x0A, 0x0E, 0xF0, 0x57, 0x71, 0x0C, 0xFF, 0xC0, 0xA0, 0xEF, 0x05,
  0x77, 0x10, 0xCF, 0xFC, 0x0A, 0x0E, 0xF0, 0x67, 0x71, 0x0C, 0xFF, 0xC0, 0xA0, 0xDF, 0x06, 0x77,
  0x10, 0xCF, 0xFC, 0x0A, 0x0D, 0xF0, 0x77, 0x71, 0x0C, 0xFF, 0xC0, 0xA0, 0xCF, 0x08, 0x77, 0x75,
  0x01, 0xF0, 0x0A, 0xF0, 0xA7, 0x77, 0x50, 0x1F, 0x0A, 0x09, 0xF0, 0xC7, 0x77, 0x50, 0x1F, 0x0A,
  0x07, 0xF0, 0xE7, 0x77, 0x50, 0x1F, 0x0A, 0x05, 0xF9, 0x01, 0x77, 0x74, 0x01, 0xF0, 0xA0, 0x3F,
  0x90, 0x47, 0x77, 0x40, 0x1F, 0x0A, 0x1F, 0x90, 0x87, 0x77, 0x40, 0x1F, 0x81, 0xA0, 0xCF, 0x0C,
  0x77, 0x74, 0x01, 0xF8, 0x1A, 0x09, 0xF9, 0x01, 0x77, 0x73, 0x01, 0xF8, 0x1A, 0x05, 0xF9, 0x06,
  0x77, 0x73, 0x01, 0xF8, 0x1A, 0x01, 0xF9, 0x0C, 0x77, 0x73, 0x01, 0xF0, 0xA2, 0x0B, 0xF9, 0x03,
  0x77, 0x72, 0x01, 0xF0, 0xA2, 0x05, 0xF9, 0x0B, 0x77, 0x72, 0x01, 0xF0, 0xA3, 0x0E, 0xF9, 0x04,
  0x77, 0x71, 0x01, 0xF0, 0xA3, 0x08, 0xF9, 0x0D, 0x01, 0x77, 0x70, 0x1F, 0x0A, 0x30, 0x10, 0xEF,
  0x90, 0xB7, 0x77, 0x01, 0xF0, 0xA4, 0x07, 0xFA, 0x0A, 0x77, 0x60, 0x1F, 0x0A, 0x50, 0xDF, 0xA0,
  0xA7, 0x75, 0x01, 0xF0, 0xA5, 0x03, 0xFB, 0x0D, 0x04, 0x77, 0x30, 0x1F, 0x0A, 0x60, 0x7F, 0xC0,
  0xB0, 0x57, 0x71, 0x05, 0xF0, 0xA7, 0x09, 0xFD, 0x84, 0xEA, 0x73, 0x21, 0x28, 0x41, 0x13, 0x58,
  0xCF, 0xA0, 0xA7, 0x10, 0xAF, 0xFF, 0xFE, 0x0A, 0x72, 0x08, 0xFF, 0xFF, 0xD0, 0xA7, 0x30, 0x50,
  0xEF, 0xFF, 0xFB, 0x0A, 0x74, 0x01, 0x0A, 0xFF, 0xFF, 0xA0, 0x97, 0x60, 0x30, 0xAF, 0xFF, 0xC8,
  0x1D, 0x83, 0x77, 0x28, 0x11, 0x7C, 0xFF, 0xC8, 0x2E, 0xA6, 0x27, 0x77, 0x28, 0x97, 0x47, 0x9B,
  0xDE, 0xEF, 0xEE, 0xDC, 0xB9, 0x64, 0x27, 0x10,
  // "ğ" (U+011F)
  0x71, 0x0D, 0xC0, 0x67, 0x72, 0x06, 0xD7, 0x70, 0xCC, 0x0B, 0x77, 0x20, 0xBC, 0x0D, 0x77, 0x09,
  0xD0, 0x47, 0x70, 0x3D, 0x0B, 0x77, 0x05, 0xD0, 0xD0, 0x27, 0x50, 0x10, 0xCD, 0x06, 0x77, 0x10,
  0xED, 0x0E, 0x05, 0x73, 0x03, 0x0D, 0xE0, 0x17, 0x71, 0x07, 0xF8, 0x2D, 0x74, 0x12, 0x82, 0x13,
  0x7C, 0xF0, 0x97, 0x73, 0x0D, 0xFF, 0xF9, 0x0E, 0x01, 0x77, 0x30, 0x30, 0xEF, 0xFF, 0x03, 0x77,
  0x50, 0x40, 0xEF, 0xFC, 0x0E, 0x04, 0x77, 0x70, 0x20, 0xDF, 0xFA, 0x0C, 0x02, 0x77, 0x73, 0x06,
  0x0D, 0xFD, 0x0C, 0x05, 0x77, 0x77, 0x89, 0x23, 0x7B, 0xDE, 0xFE, 0xDC, 0xA6, 0x38, 0x0B, 0xD1,
  0x08, 0x93, 0x15, 0x9B, 0xDE, 0xFE, 0xEC, 0xA7, 0x37, 0x77, 0x60, 0x40, 0xBF, 0xE8, 0x1E, 0x81,
  0x60, 0xCD, 0x0C, 0x72, 0x03, 0x0C, 0xFF, 0xB0, 0xE0, 0x65, 0x0E, 0xD0, 0xC7, 0x10, 0x7F, 0xFF,
  0x0A, 0x30, 0x2E, 0x0C, 0x70, 0xAF, 0xFF, 0xA0, 0xB2, 0x05, 0xE0, 0xC6, 0x0A, 0xFF, 0xFC, 0x81,
  0xA0, 0x7E, 0x0C, 0x50, 0x8F, 0xD8, 0x5C, 0xA9, 0x89, 0xBD, 0xF9, 0x07, 0x0B, 0xE0, 0xC4, 0x04,
  0xFB, 0x0B, 0x05, 0x71, 0x81, 0x27, 0xEF, 0xE0, 0xC3, 0x01, 0x0E, 0xF9, 0x0E, 0x04, 0x76, 0x09,
  0xFD, 0x0C, 0x30, 0x8F, 0x90, 0xD0, 0x17, 0x71, 0x05, 0xFC, 0x0C, 0x20, 0x1F, 0x90, 0xE0, 0x17,
  0x73, 0x05, 0xFB, 0x0C, 0x20, 0x8F, 0x90, 0x47, 0x75, 0x08, 0xFA, 0x0C, 0x20, 0xEF, 0x0C, 0x77,
  0x70, 0xDF, 0x98, 0x1C, 0x05, 0xF9, 0x04, 0x77, 0x70, 0x6F, 0x98, 0x1C, 0x0A, 0xF0, 0xD7, 0x77,
  0x20, 0xEF, 0x81, 0xC0, 0xEF, 0x08, 0x77, 0x72, 0x0A, 0xF0, 0xC0, 0x2F, 0x90, 0x37, 0x77, 0x20,
  0x6F, 0x0C, 0x05, 0xF0, 0xE7, 0x77, 0x30, 0x2F, 0x0C, 0x08, 0xF0, 0xC7, 0x77, 0x4F, 0x0C, 0x0A,
  0xF0, 0x97, 0x77, 0x40, 0xDE, 0x00, 0xCF, 0x07, 0x77, 0x74, 0x0B, 0xE0, 0xC0, 0xDF, 0x06, 0x77,
  0x74, 0x09, 0xE0, 0xC0, 0xEF, 0x05, 0x77, 0x74, 0x08, 0xE0, 0xCF, 0x90, 0x47, 0x77, 0x40, 0x8E,
  0x0C, 0xF9, 0x04, 0x77, 0x74, 0x07, 0xE0, 0xCF, 0x90, 0x37, 0x77, 0x40, 0x7E, 0x0C, 0xF9, 0x04,
  0x77, 0x74, 0x07, 0xE0, 0xCF, 0x90, 0x47, 0x77, 0x40, 0x7E, 0x0C, 0x0E, 0xF0, 0x57, 0x77, 0x40,
  0x8E, 0x0C, 0x0D, 0xF0, 0x77, 0x77, 0x40, 0x8E, 0x0C, 0x0B, 0xF0, 0x97, 0x77, 0x40, 0xAE, 0x0C,
  0x09, 0xF0, 0xB7, 0x77, 0x40, 0xCE, 0x0C, 0x06, 0xF0, 0xE7, 0x77, 0x40, 0xEE, 0x0C, 0x03, 0xF9,
  0x03, 0x77, 0x72, 0x02, 0xF0, 0xC1, 0xF9, 0x07, 0x77, 0x72, 0x05, 0xF8, 0x1C, 0x0B, 0xF0, 0xD7,
  0x77, 0x20, 0xAF, 0x81, 0xC0, 0x6F, 0x90, 0x47, 0x77, 0x01, 0xF9, 0x81, 0xC0, 0x1F, 0x90, 0xB7,
  0x77, 0x08, 0xF9, 0x0C, 0x20, 0xAF, 0x90, 0x57, 0x75, 0x02, 0xFA, 0x0C, 0x20, 0x3F, 0x90, 0xE0,
  0x27, 0x73, 0x01, 0x0C, 0xFA, 0x0C, 0x30, 0xBF, 0x90, 0xD0, 0x27, 0x71, 0x01, 0x0D, 0xFB, 0x0C,
  0x30, 0x2F, 0xA0, 0xE0, 0x67, 0x60, 0x50, 0xDF, 0xC0, 0xC4, 0x07, 0xFB, 0x81, 0xC6, 0x17, 0x81,
  0x15, 0xCF, 0xE0, 0xC5, 0x0B, 0xFD, 0x85, 0xDA, 0x98, 0x9A, 0xCF, 0xA0, 0xCE, 0x0C, 0x60, 0xCF,
  0xFF, 0xD0, 0x60, 0x8E, 0x0C, 0x70, 0xBF, 0xFF, 0xB8, 0x18, 0x0A, 0xE0, 0xC7, 0x10, 0x8F, 0xFF,
  0x90, 0x82, 0x0B, 0xE0, 0xC7, 0x20, 0x30, 0xCF, 0xFC, 0x0E, 0x05, 0x30, 0xBE, 0x0C, 0x74, 0x04,
  0x0A, 0xFF, 0x0D, 0x07, 0x50, 0xBE, 0x0C, 0x76, 0x84, 0x15, 0x8B, 0xDE, 0xA8, 0x4E, 0xDC, 0xA6,
  0x37, 0x0B, 0xE0, 0xC7, 0x77, 0x76, 0x0C, 0xE0, 0xC7, 0x77, 0x76, 0x0D, 0xE0, 0xB7, 0x77, 0x76,
  0x0E, 0xE0, 0xB7, 0x77, 0x76, 0xF0, 0x97, 0x77, 0x75, 0x03, 0xF0, 0x87, 0x77, 0x75, 0x06, 0xF0,
  0x67, 0x77, 0x75, 0x0B, 0xF0, 0x37, 0x77, 0x74, 0x02, 0xF0, 0xE7, 0x77, 0x75, 0x08, 0xF0, 0xA7,
  0x77, 0x74, 0x03, 0xF9, 0x06, 0x30, 0x30, 0x17, 0x77, 0x60, 0xDF, 0x0E, 0x48, 0x28, 0xE8, 0x27,
  0x77, 0x20, 0x10, 0xCF, 0x90, 0x84, 0x08, 0xB8, 0x1B, 0x61, 0x77, 0x50, 0x50, 0xEF, 0x90, 0xE0,
  0x14, 0x08, 0xE8, 0x3D, 0x96, 0x41, 0x74, 0x81, 0x37, 0xDF, 0xB0, 0x55, 0x08, 0xFC, 0x89, 0x0E,
  0xCB, 0xA9, 0x88, 0x9A, 0xCF, 0xE0, 0xA6, 0x08, 0xFF, 0xFF, 0xD0, 0xB7, 0x08, 0xFF, 0xFF, 0xC0,
  0xA7, 0x10, 0x50, 0xEF, 0xFF, 0xF9, 0x0E, 0x06, 0x74, 0x05, 0x0A, 0xFF, 0xFC, 0x81, 0xE8, 0x17,
  0x71, 0x81, 0x48, 0xCF, 0xFD, 0x81, 0xB6, 0x17, 0x77, 0x86, 0x35, 0x8A, 0xCD, 0xDE, 0xA8, 0x5E,
  0xED, 0xB9, 0x64, 0x77,
  // "Ġ" (U+0120)
  0x77, 0x78, 0x61, 0x8C, 0xEE, 0xC7, 0x17, 0x77, 0x77, 0x03, 0x0E, 0xE0, 0xE0, 0x37, 0x77, 0x76,
  0x0E, 0xF9, 0x0D, 0x77, 0x77, 0x50, 0x5F, 0xB0, 0x57, 0x77, 0x74, 0x09, 0xFB, 0x09, 0x77, 0x77,
  0x40, 0xAF, 0xB0, 0xA7, 0x77, 0x74, 0x09, 0xFB, 0x09, 0x77, 0x77, 0x40, 0x5F, 0xB0, 0x57, 0x77,
  0x75, 0x0D, 0xF9, 0x0D, 0x77, 0x77, 0x60, 0x30, 0xEE, 0x0D, 0x02, 0x77, 0x77, 0x78, 0x61, 0x7C,
  0xEE, 0xC7, 0x18, 0x0D, 0xF7, 0x08, 0x96, 0x37, 0x9B, 0xDE, 0xEF, 0xED, 0xDC, 0xA7, 0x41, 0x77,
  0x73, 0x81, 0x16, 0xBF, 0xFB, 0x81, 0xD8, 0x37, 0x75, 0x02, 0x09, 0xFF, 0xFA, 0x0D, 0x07, 0x77,
  0x10, 0x10, 0x9F, 0xFF, 0xE0, 0xE0, 0x87, 0x50, 0x40, 0xEF, 0xFF, 0xF9, 0x09, 0x74, 0x08, 0xFF,
  0xFF, 0xB0, 0x37, 0x30, 0xAF, 0xFF, 0xFB, 0x0B, 0x73, 0x09, 0xFD, 0x84, 0xD9, 0x64, 0x11, 0x28,
  0x41, 0x23, 0x6A, 0xDE, 0x05, 0x72, 0x08, 0xFC, 0x0A, 0x04, 0x77, 0x81, 0x39, 0xEA, 0x0D, 0x72,
  0x05, 0xFB, 0x0B, 0x02, 0x77, 0x58, 0x17, 0xE7, 0x71, 0x01, 0x0E, 0xFA, 0x07, 0x77, 0x71, 0x01,
  0x72, 0x0A, 0xFA, 0x05, 0x77, 0x77, 0x40, 0x3F, 0xA0, 0x57, 0x77, 0x75, 0x0C, 0xF9, 0x08, 0x77,
  0x77, 0x50, 0x4F, 0x90, 0xC7, 0x77, 0x76, 0x0B, 0xF9, 0x03, 0x77, 0x77, 0x50, 0x2F, 0x90, 0xA7,
  0x77, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x77, 0x60, 0xCF, 0x0C, 0x77, 0x77, 0x60, 0x2F, 0x90, 0x67,
  0x77, 0x76, 0x06, 0xF9, 0x01, 0x77, 0x77, 0x60, 0x9F, 0x0C, 0x77, 0x77, 0x70, 0xDF, 0x07, 0x77,
  0x77, 0x7F, 0x90, 0x47, 0x77, 0x76, 0x03, 0xF9, 0x01, 0x77, 0x77, 0x60, 0x5F, 0x0E, 0x77, 0x77,
  0x70, 0x8F, 0x0C, 0x77, 0x77, 0x70, 0x9F, 0x0A, 0x77, 0x77, 0x70, 0xAF, 0x08, 0x77, 0x77, 0x70,
  0xCF, 0x07, 0x77, 0x77, 0x70, 0xDF, 0x06, 0x77, 0x77, 0x70, 0xDF, 0x05, 0x77, 0x10, 0xCF, 0xFC,
  0x0A, 0x0E, 0xF0, 0x57, 0x71, 0x0C, 0xFF, 0xC0, 0xA0, 0xEF, 0x05, 0x77, 0x10, 0xCF, 0xFC, 0x0A,
  0x0E, 0xF0, 0x57, 0x71, 0x0C, 0xFF, 0xC0, 0xA0, 0xEF, 0x06, 0x77, 0x10, 0xCF, 0xFC, 0x0A, 0x0D,
  0xF0, 0x67, 0x71, 0x0C, 0xFF, 0xC0, 0xA0, 0xDF, 0x07, 0x77, 0x10, 0xCF, 0xFC, 0x0A, 0x0C, 0xF0,
  0x87, 0x77, 0x50, 0x1F, 0x00, 0xAF, 0x0A, 0x77, 0x75, 0x01, 0xF0, 0xA0, 0x9F, 0x0C, 0x77, 0x75,
  0x01, 0xF0, 0xA0, 0x7F, 0x0E, 0x77, 0x75, 0x01, 0xF0, 0xA0, 0x5F, 0x90, 0x17, 0x77, 0x40, 0x1F,
  0x0A, 0x03, 0xF9, 0x04, 0x77, 0x74, 0x01, 0xF0, 0xA1, 0xF9, 0x08, 0x77, 0x74, 0x01, 0xF8, 0x1A,
  0x0C, 0xF0, 0xC7, 0x77, 0x40, 0x1F, 0x81, 0xA0, 0x9F, 0x90, 0x17, 0x77, 0x30, 0x1F, 0x81, 0xA0,
  0x5F, 0x90, 0x67, 0x77, 0x30, 0x1F, 0x81, 0xA0, 0x1F, 0x90, 0xC7, 0x77, 0x30, 0x1F, 0x0A, 0x20,
  0xBF, 0x90, 0x37, 0x77, 0x20, 0x1F, 0x0A, 0x20, 0x5F, 0x90, 0xB7, 0x77, 0x20, 0x1F, 0x0A, 0x30,
  0xEF, 0x90, 0x47, 0x77, 0x10, 0x1F, 0x0A, 0x30, 0x8F, 0x90, 0xD0, 0x17, 0x77, 0x01, 0xF0, 0xA3,
  0x01, 0x0E, 0xF9, 0x0B, 0x77, 0x70, 0x1F, 0x0A, 0x40, 0x7F, 0xA0, 0xA7, 0x76, 0x01, 0xF0, 0xA5,
  0x0D, 0xFA, 0x0A, 0x77, 0x50, 0x1F, 0x0A, 0x50, 0x3F, 0xB0, 0xD0, 0x47, 0x73, 0x01, 0xF0, 0xA6,
  0x07, 0xFC, 0x0B, 0x05, 0x77, 0x10, 0x5F, 0x0A, 0x70, 0x9F, 0xD8, 0x4E, 0xA7, 0x32, 0x12, 0x84,
  0x11, 0x35, 0x8C, 0xFA, 0x0A, 0x71, 0x0A, 0xFF, 0xFF, 0xE0, 0xA7, 0x20, 0x8F, 0xFF, 0xFD, 0x0A,
  0x73, 0x05, 0x0E, 0xFF, 0xFF, 0xB0, 0xA7, 0x40, 0x10, 0xAF, 0xFF, 0xFA, 0x09, 0x76, 0x03, 0x0A,
  0xFF, 0xFC, 0x81, 0xD8, 0x37, 0x72, 0x81, 0x17, 0xCF, 0xFC, 0x82, 0xEA, 0x62, 0x77, 0x72, 0x89,
  0x74, 0x79, 0xBD, 0xEE, 0xFE, 0xED, 0xCB, 0x96, 0x42, 0x71,
  // "ġ" (U+0121)
  0x77, 0x48, 0x61, 0x8C, 0xEE, 0xC7, 0x17, 0x77, 0x75, 0x03, 0x0E, 0xE0, 0xE0, 0x37, 0x77, 0x74,
  0x0E, 0xF9, 0x0D, 0x77, 0x77, 0x30, 0x5F, 0xB0, 0x57, 0x77, 0x72, 0x09, 0xFB, 0x09, 0x77, 0x77,
  0x20, 0xAF, 0xB0, 0xA7, 0x77, 0x72, 0x09, 0xFB, 0x09, 0x77, 0x77, 0x20, 0x5F, 0xB0, 0x57, 0x77,
  0x73, 0x0D, 0xF9, 0x0D, 0x77, 0x77, 0x40, 0x30, 0xEE, 0x0D, 0x02, 0x77, 0x77, 0x58, 0x61, 0x7C,
  0xEE, 0xC7, 0x18, 0x0D, 0xD1, 0x08, 0x93, 0x15, 0x9B, 0xDE, 0xFE, 0xEC, 0xA7, 0x37, 0x77, 0x60,
  0x40, 0xBF, 0xE8, 0x1E, 0x81, 0x60, 0xCD, 0x0C, 0x72, 0x03, 0x0C, 0xFF, 0xB0, 0xE0, 0x65, 0x0E,
  0xD0, 0xC7, 0x10, 0x7F, 0xFF, 0x0A, 0x30, 0x2E, 0x0C, 0x70, 0xAF, 0xFF, 0xA0, 0xB2, 0x05, 0xE0,
  0xC6, 0x0A, 0xFF, 0xFC, 0x81, 0xA0, 0x7E, 0x0C, 0x50, 0x8F, 0xD8, 0x5C, 0xA9, 0x89, 0xBD, 0xF9,
  0x07, 0x0B, 0xE0, 0xC4, 0x04, 0xFB, 0x0B, 0x05, 0x71, 0x81, 0x27, 0xEF, 0xE0, 0xC3, 0x01, 0x0E,
  0xF9, 0x0E, 0x04, 0x76, 0x09, 0xFD, 0x0C, 0x30, 0x8F, 0x90, 0xD0, 0x17, 0x71, 0x05, 0xFC, 0x0C,
  0x20, 0x1F, 0x90, 0xE0, 0x17, 0x73, 0x05, 0xFB, 0x0C, 0x20, 0x8F, 0x90, 0x47, 0x75, 0x08, 0xFA,
  0x0C, 0x20, 0xEF, 0x0C, 0x77, 0x70, 0xDF, 0x98, 0x1C, 0x05, 0xF9, 0x04, 0x77, 0x70, 0x6F, 0x98,
  0x1C, 0x0A, 0xF0, 0xD7, 0x77, 0x20, 0xEF, 0x81, 0xC0, 0xEF, 0x08, 0x77, 0x72, 0x0A, 0xF0, 0xC0,
  0x2F, 0x90, 0x37, 0x77, 0x20, 0x6F, 0x0C, 0x05, 0xF0, 0xE7, 0x77, 0x30, 0x2F, 0x0C, 0x08, 0xF0,
  0xC7, 0x77, 0x4F, 0x0C, 0x0A, 0xF0, 0x97, 0x77, 0x40, 0xDE, 0x00, 0xCF, 0x07, 0x77, 0x74, 0x0B,
  0xE0, 0xC0, 0xDF, 0x06, 0x77, 0x74, 0x09, 0xE0, 0xC0, 0xEF, 0x05, 0x77, 0x74, 0x08, 0xE0, 0xCF,
  0x90, 0x47, 0x77, 0x40, 0x8E, 0x0C, 0xF9, 0x04, 0x77, 0x74, 0x07, 0xE0, 0xCF, 0x90, 0x37, 0x77,
  0x40, 0x7E, 0x0C, 0xF9, 0x04, 0x77, 0x74, 0x07, 0xE0, 0xCF, 0x90, 0x47, 0x77, 0x40, 0x7E, 0x0C,
  0x0E, 0xF0, 0x57, 0x77, 0x40, 0x8E, 0x0C, 0x0D, 0xF0, 0x77, 0x77, 0x40, 0x8E, 0x0C, 0x0B, 0xF0,
  0x97, 0x77, 0x40, 0xAE, 0x0C, 0x09, 0xF0, 0xB7, 0x77, 0x40, 0xCE, 0x0C, 0x06, 0xF0, 0xE7, 0x77,
  0x40, 0xEE, 0x0C, 0x03, 0xF9, 0x03, 0x77, 0x72, 0x02, 0xF0, 0xC1, 0xF9, 0x07, 0x77, 0x72, 0x05,
  0xF8, 0x1C, 0x0B, 0xF0, 0xD7, 0x77, 0x20, 0xAF, 0x81, 0xC0, 0x6F, 0x90, 0x47, 0x77, 0x01, 0xF9,
  0x81, 0xC0, 0x1F, 0x90, 0xB7, 0x77, 0x08, 0xF9, 0x0C, 0x20, 0xAF, 0x90, 0x57, 0x75, 0x02, 0xFA,
  0x0C, 0x20, 0x3F, 0x90, 0xE0, 0x27, 0x73, 0x01, 0x0C, 0xFA, 0x0C, 0x30, 0xBF, 0x90, 0xD0, 0x27,
  0x71, 0x01, 0x0D, 0xFB, 0x0C, 0x30, 0x2F, 0xA0, 0xE0, 0x67, 0x60, 0x50, 0xDF, 0xC0, 0xC4, 0x07,
  0xFB, 0x81, 0xC6, 0x17, 0x81, 0x15, 0xCF, 0xE0, 0xC5, 0x0B, 0xFD, 0x85, 0xDA, 0x98, 0x9A, 0xCF,
  0xA0, 0xCE, 0x0C, 0x60, 0xCF, 0xFF, 0xD0, 0x60, 0x8E, 0x0C, 0x70, 0xBF, 0xFF, 0xB8, 0x18, 0x0A,
  0xE0, 0xC7, 0x10, 0x8F, 0xFF, 0x90, 0x82, 0x0B, 0xE0, 0xC7, 0x20, 0x30, 0xCF, 0xFC, 0x0E, 0x05,
  0x30, 0xBE, 0x0C, 0x74, 0x04, 0x0A, 0xFF, 0x0D, 0x07, 0x50, 0xBE, 0x0C, 0x76, 0x84, 0x15, 0x8B,
  0xDE, 0xA8, 0x4E, 0xDC, 0xA6, 0x37, 0x0B, 0xE0, 0xC7, 0x77, 0x76, 0x0C, 0xE0, 0xC7, 0x77, 0x76,
  0x0D, 0xE0, 0xB7, 0x77, 0x76, 0x0E, 0xE0, 0xB7, 0x77, 0x76, 0xF0, 0x97, 0x77, 0x75, 0x03, 0xF0,
  0x87, 0x77, 0x75, 0x06, 0xF0, 0x67, 0x77, 0x75, 0x0B, 0xF0, 0x37, 0x77, 0x74, 0x02, 0xF0, 0xE7,
  0x77, 0x75, 0x08, 0xF0, 0xA7, 0x77, 0x74, 0x03, 0xF9, 0x06, 0x30, 0x30, 0x17, 0x77, 0x60, 0xDF,
  0x0E, 0x48, 0x28, 0xE8, 0x27, 0x77, 0x20, 0x10, 0xCF, 0x90, 0x84, 0x08, 0xB8, 0x1B, 0x61, 0x77,
  0x50, 0x50, 0xEF, 0x90, 0xE0, 0x14, 0x08, 0xE8, 0x3D, 0x96, 0x41, 0x74, 0x81, 0x37, 0xDF, 0xB0,
  0x55, 0x08, 0xFC, 0x89, 0x0E, 0xCB, 0xA9, 0x88, 0x9A, 0xCF, 0xE0, 0xA6, 0x08, 0xFF, 0xFF, 0xD0,
  0xB7, 0x08, 0xFF, 0xFF, 0xC0, 0xA7, 0x10, 0x50, 0xEF, 0xFF, 0xF9, 0x0E, 0x06, 0x74, 0x05, 0x0A,
  0xFF, 0xFC, 0x81, 0xE8, 0x17, 0x71, 0x81, 0x48, 0xCF, 0xFD, 0x81, 0xB6, 0x17, 0x77, 0x86, 0x35,
  0x8A, 0xCD, 0xDE, 0xA8, 0x5E, 0xED, 0xB9, 0x64, 0x77,
  // "Ģ" (U+0122)
  0x77, 0x68, 0x96, 0x37, 0x9B, 0xDE, 0xEF, 0xED, 0xDC, 0xA7, 0x41, 0x77, 0x73, 0x81, 0x16, 0xBF,
  0xFB, 0x81, 0xD8, 0x37, 0x75, 0x02, 0x09, 0xFF, 0xFA, 0x0D, 0x07, 0x77, 0x10, 0x10, 0x9F, 0xFF,
  0xE0, 0xE0, 0x87, 0x50, 0x40, 0xEF, 0xFF, 0xF9, 0x09, 0x74, 0x08, 0xFF, 0xFF, 0xB0, 0x37, 0x30,
  0xAF, 0xFF, 0xFB, 0x0B, 0x73, 0x09, 0xFD, 0x84, 0xD9, 0x64, 0x11, 0x28, 0x41, 0x23, 0x6A, 0xDE,
  0x05, 0x72, 0x08, 0xFC, 0x0A, 0x04, 0x77, 0x81, 0x39, 0xEA, 0x0D, 0x72, 0x05, 0xFB, 0x0B, 0x02,
  0x77, 0x58, 0x17, 0xE7, 0x71, 0x01, 0x0E, 0xFA, 0x07, 0x77, 0x71, 0x01, 0x72, 0x0A, 0xFA, 0x05,
  0x77, 0x77, 0x40, 0x3F, 0xA0, 0x57, 0x77, 0x75, 0x0C, 0xF9, 0x08, 0x77, 0x77, 0x50, 0x4F, 0x90,
  0xC7, 0x77, 0x76, 0x0B, 0xF9, 0x03, 0x77, 0x77, 0x50, 0x2F, 0x90, 0xA7, 0x77, 0x76, 0x07, 0xF9,
  0x03, 0x77, 0x77, 0x60, 0xCF, 0x0C, 0x77, 0x77, 0x60, 0x2F, 0x90, 0x67, 0x77, 0x76, 0x06, 0xF9,
  0x01, 0x77, 0x77, 0x60, 0x9F, 0x0C, 0x77, 0x77, 0x70, 0xDF, 0x07, 0x77, 0x77, 0x7F, 0x90, 0x47,
  0x77, 0x76, 0x03, 0xF9, 0x01, 0x77, 0x77, 0x60, 0x5F, 0x0E, 0x77, 0x77, 0x70, 0x8F, 0x0C, 0x77,
  0x77, 0x70, 0x9F, 0x0A, 0x77, 0x77, 0x70, 0xAF, 0x08, 0x77, 0x77, 0x70, 0xCF, 0x07, 0x77, 0x77,
  0x70, 0xDF, 0x06, 0x77, 0x77, 0x70, 0xDF, 0x05, 0x77, 0x10, 0xCF, 0xFC, 0x0A, 0x0E, 0xF0, 0x57,
  0x71, 0x0C, 0xFF, 0xC0, 0xA0, 0xEF, 0x05, 0x77, 0x10, 0xCF, 0xFC, 0x0A, 0x0E, 0xF0, 0x57, 0x71,
  0x0C, 0xFF, 0xC0, 0xA0, 0xEF, 0x06, 0x77, 0x10, 0xCF, 0xFC, 0x0A, 0x0D, 0xF0, 0x67, 0x71, 0x0C,
  0xFF, 0xC0, 0xA0, 0xDF, 0x07, 0x77, 0x10, 0xCF, 0xFC, 0x0A, 0x0C, 0xF0, 0x87, 0x77, 0x50, 0x1F,
  0x00, 0xAF, 0x0A, 0x77, 0x75, 0x01, 0xF0, 0xA0, 0x9F, 0x0C, 0x77, 0x75, 0x01, 0xF0, 0xA0, 0x7F,
  0x0E, 0x77, 0x75, 0x01, 0xF0, 0xA0, 0x5F, 0x90, 0x17, 0x77, 0x40, 0x1F, 0x0A, 0x03, 0xF9, 0x04,
  0x77, 0x74, 0x01, 0xF0, 0xA1, 0xF9, 0x08, 0x77, 0x74, 0x01, 0xF8, 0x1A, 0x0C, 0xF0, 0xC7, 0x77,
  0x40, 0x1F, 0x81, 0xA0, 0x9F, 0x90, 0x17, 0x77, 0x30, 0x1F, 0x81, 0xA0, 0x5F, 0x90, 0x67, 0x77,
  0x30, 0x1F, 0x81, 0xA0, 0x1F, 0x90, 0xC7, 0x77, 0x30, 0x1F, 0x0A, 0x20, 0xBF, 0x90, 0x37, 0x77,
  0x20, 0x1F, 0x0A, 0x20, 0x5F, 0x90, 0xB7, 0x77, 0x20, 0x1F, 0x0A, 0x30, 0xEF, 0x90, 0x47, 0x77,
  0x10, 0x1F, 0x0A, 0x30, 0x8F, 0x90, 0xD0, 0x17, 0x77, 0x01, 0xF0, 0xA3, 0x01, 0x0E, 0xF9, 0x0B,
  0x77, 0x70, 0x1F, 0x0A, 0x40, 0x7F, 0xA0, 0xA7, 0x76, 0x01, 0xF0, 0xA5, 0x0D, 0xFA, 0x0A, 0x77,
  0x50, 0x1F, 0x0A, 0x50, 0x3F, 0xB0, 0xD0, 0x47, 0x73, 0x01, 0xF0, 0xA6, 0x07, 0xFC, 0x0B, 0x05,
  0x77, 0x10, 0x5F, 0x0A, 0x70, 0x9F, 0xD8, 0x4E, 0xA7, 0x32, 0x12, 0x84, 0x11, 0x35, 0x8C, 0xFA,
  0x0A, 0x71, 0x0A, 0xFF, 0xFF, 0xE0, 0xA7, 0x20, 0x8F, 0xFF, 0xFD, 0x0A, 0x73, 0x05, 0x0E, 0xFF,
  0xFF, 0xB0, 0xA7, 0x40, 0x10, 0xAF, 0xFF, 0xFA, 0x09, 0x76, 0x03, 0x0A, 0xFF, 0xFC, 0x81, 0xD8,
  0x37, 0x72, 0x81, 0x17, 0xCF, 0xFC, 0x82, 0xEA, 0x62, 0x77, 0x72, 0x89, 0x74, 0x79, 0xBD, 0xEE,
  0xFE, 0xED, 0xCB, 0x96, 0x42, 0x80, 0xBE, 0x60, 0x0D, 0xF8, 0x0C, 0x00, 0xF0, 0xB7, 0x77, 0x77,
  0x02, 0xF0, 0x67, 0x77, 0x77, 0x06, 0xF0, 0x17, 0x77, 0x77, 0x09, 0xE0, 0x98, 0x0C, 0x00, 0x0E,
  0xE0, 0x27, 0x77, 0x77, 0x03, 0xE0, 0xA8, 0x0C, 0x00, 0x07, 0xE0, 0x28, 0x0C, 0x00, 0x0C, 0xD0,
  0x88, 0x0C, 0x00, 0x01, 0xD0, 0xE0, 0x18, 0x0C, 0x00, 0x07, 0xD0, 0x58, 0x0C, 0x10, 0x0C, 0xC0,
  0xB8, 0x0C, 0x10, 0x04, 0xC0, 0xE0, 0x18, 0x0C, 0x10, 0x07, 0xC0, 0x37, 0x76,
  // "ģ" (U+0123)
  0x77, 0x71, 0x01, 0x0E, 0xB0, 0xB8, 0x0C, 0x00, 0x0C, 0xC0, 0x97, 0x77, 0x77, 0x07, 0xD0, 0x27,
  0x77, 0x76, 0x02, 0xD0, 0xC7, 0x77, 0x77, 0x0C, 0xD0, 0x67, 0x77, 0x76, 0x05, 0xE0, 0x17, 0x77,
  0x76, 0x0D, 0xD0, 0xC7, 0x77, 0x76, 0x06, 0xE0, 0x87, 0x77, 0x76, 0x0D, 0xE0, 0x37, 0x77, 0x75,
  0x06, 0xE0, 0xE7, 0x77, 0x76, 0x0C, 0xE0, 0xA7, 0x77, 0x75, 0x03, 0xF0, 0x67, 0x77, 0x75, 0x09,
  0xF0, 0x37, 0x77, 0x75, 0x0C, 0xF0, 0x18, 0x0B, 0xD4, 0x08, 0x93, 0x15, 0x9B, 0xDE, 0xFE, 0xEC,
  0xA7, 0x37, 0x77, 0x60, 0x40, 0xBF, 0xE8, 0x1E, 0x81, 0x60, 0xCD, 0x0C, 0x72, 0x03, 0x0C, 0xFF,
  0xB0, 0xE0, 0x65, 0x0E, 0xD0, 0xC7, 0x10, 0x7F, 0xFF, 0x0A, 0x30, 0x2E, 0x0C, 0x70, 0xAF, 0xFF,
  0xA0, 0xB2, 0x05, 0xE0, 0xC6, 0x0A, 0xFF, 0xFC, 0x81, 0xA0, 0x7E, 0x0C, 0x50, 0x8F, 0xD8, 0x5C,
  0xA9, 0x89, 0xBD, 0xF9, 0x07, 0x0B, 0xE0, 0xC4, 0x04, 0xFB, 0x0B, 0x05, 0x71, 0x81, 0x27, 0xEF,
  0xE0, 0xC3, 0x01, 0x0E, 0xF9, 0x0E, 0x04, 0x76, 0x09, 0xFD, 0x0C, 0x30, 0x8F, 0x90, 0xD0, 0x17,
  0x71, 0x05, 0xFC, 0x0C, 0x20, 0x1F, 0x90, 0xE0, 0x17, 0x73, 0x05, 0xFB, 0x0C, 0x20, 0x8F, 0x90,
  0x47, 0x75, 0x08, 0xFA, 0x0C, 0x20, 0xEF, 0x0C, 0x77, 0x70, 0xDF, 0x98, 0x1C, 0x05, 0xF9, 0x04,
  0x77, 0x70, 0x6F, 0x98, 0x1C, 0x0A, 0xF0, 0xD7, 0x77, 0x20, 0xEF, 0x81, 0xC0, 0xEF, 0x08, 0x77,
  0x72, 0x0A, 0xF0, 0xC0, 0x2F, 0x90, 0x37, 0x77, 0x20, 0x6F, 0x0C, 0x05, 0xF0, 0xE7, 0x77, 0x30,
  0x2F, 0x0C, 0x08, 0xF0, 0xC7, 0x77, 0x4F, 0x0C, 0x0A, 0xF0, 0x97, 0x77, 0x40, 0xDE, 0x00, 0xCF,
  0x07, 0x77, 0x74, 0x0B, 0xE0, 0xC0, 0xDF, 0x06, 0x77, 0x74, 0x09, 0xE0, 0xC0, 0xEF, 0x05, 0x77,
  0x74, 0x08, 0xE0, 0xCF, 0x90, 0x47, 0x77, 0x40, 0x8E, 0x0C, 0xF9, 0x04, 0x77, 0x74, 0x07, 0xE0,
  0xCF, 0x90, 0x37, 0x77, 0x40, 0x7E, 0x0C, 0xF9, 0x04, 0x77, 0x74, 0x07, 0xE0, 0xCF, 0x90, 0x47,
  0x77, 0x40, 0x7E, 0x0C, 0x0E, 0xF0, 0x57, 0x77, 0x40, 0x8E, 0x0C, 0x0D, 0xF0, 0x77, 0x77, 0x40,
  0x8E, 0x0C, 0x0B, 0xF0, 0x97, 0x77, 0x40, 0xAE, 0x0C, 0x09, 0xF0, 0xB7, 0x77, 0x40, 0xCE, 0x0C,
  0x06, 0xF0, 0xE7, 0x77, 0x40, 0xEE, 0x0C, 0x03, 0xF9, 0x03, 0x77, 0x72, 0x02, 0xF0, 0xC1, 0xF9,
  0x07, 0x77, 0x72, 0x05, 0xF8, 0x1C, 0x0B, 0xF0, 0xD7, 0x77, 0x20, 0xAF, 0x81, 0xC0, 0x6F, 0x90,
  0x47, 0x77, 0x01, 0xF9, 0x81, 0xC0, 0x1F, 0x90, 0xB7, 0x77, 0x08, 0xF9, 0x0C, 0x20, 0xAF, 0x90,
  0x57, 0x75, 0x02, 0xFA, 0x0C, 0x20, 0x3F, 0x90, 0xE0, 0x27, 0x73, 0x01, 0x0C, 0xFA, 0x0C, 0x30,
  0xBF, 0x90, 0xD0, 0x27, 0x71, 0x01, 0x0D, 0xFB, 0x0C, 0x30, 0x2F, 0xA0, 0xE0, 0x67, 0x60, 0x50,
  0xDF, 0xC0, 0xC4, 0x07, 0xFB, 0x81, 0xC6, 0x17, 0x81, 0x15, 0xCF, 0xE0, 0xC5, 0x0B, 0xFD, 0x85,
  0xDA, 0x98, 0x9A, 0xCF, 0xA0, 0xCE, 0x0C, 0x60, 0xCF, 0xFF, 0xD0, 0x60, 0x8E, 0x0C, 0x70, 0xBF,
  0xFF, 0xB8, 0x18, 0x0A, 0xE0, 0xC7, 0x10, 0x8F, 0xFF, 0x90, 0x82, 0x0B, 0xE0, 0xC7, 0x20, 0x30,
  0xCF, 0xFC, 0x0E, 0x05, 0x30, 0xBE, 0x0C, 0x74, 0x04, 0x0A, 0xFF, 0x0D, 0x07, 0x50, 0xBE, 0x0C,
  0x76, 0x84, 0x15, 0x8B, 0xDE, 0xA8, 0x4E, 0xDC, 0xA6, 0x37, 0x0B, 0xE0, 0xC7, 0x77, 0x76, 0x0C,
  0xE0, 0xC7, 0x77, 0x76, 0x0D, 0xE0, 0xB7, 0x77, 0x76, 0x0E, 0xE0, 0xB7, 0x77, 0x76, 0xF0, 0x97,
  0x77, 0x75, 0x03, 0xF0, 0x87, 0x77, 0x75, 0x06, 0xF0, 0x67, 0x77, 0x75, 0x0B, 0xF0, 0x37, 0x77,
  0x74, 0x02, 0xF0, 0xE7, 0x77, 0x75, 0x08, 0xF0, 0xA7, 0x77, 0x74, 0x03, 0xF9, 0x06, 0x30, 0x30,
  0x17, 0x77, 0x60, 0xDF, 0x0E, 0x48, 0x28, 0xE8, 0x27, 0x77, 0x20, 0x10, 0xCF, 0x90, 0x84, 0x08,
  0xB8, 0x1B, 0x61, 0x77, 0x50, 0x50, 0xEF, 0x90, 0xE0, 0x14, 0x08, 0xE8, 0x3D, 0x96, 0x41, 0x74,
  0x81, 0x37, 0xDF, 0xB0, 0x55, 0x08, 0xFC, 0x89, 0x0E, 0xCB, 0xA9, 0x88, 0x9A, 0xCF, 0xE0, 0xA6,
  0x08, 0xFF, 0xFF, 0xD0, 0xB7, 0x08, 0xFF, 0xFF, 0xC0, 0xA7, 0x10, 0x50, 0xEF, 0xFF, 0xF9, 0x0E,
  0x06, 0x74, 0x05, 0x0A, 0xFF, 0xFC, 0x81, 0xE8, 0x17, 0x71, 0x81, 0x48, 0xCF, 0xFD, 0x81, 0xB6,
  0x17, 0x77, 0x86, 0x35, 0x8A, 0xCD, 0xDE, 0xA8, 0x5E, 0xED, 0xB9, 0x64, 0x77,
  // "Ĥ" (U+0124)
  0x77, 0x20, 0x28, 0x04, 0x77, 0x77, 0x75, 0x0C, 0xF9, 0x08, 0x77, 0x77, 0x30, 0x6F, 0xB0, 0x37,
  0x77, 0x71, 0x03, 0xFC, 0x0D, 0x01, 0x77, 0x77, 0x0D, 0xFD, 0x0A, 0x77, 0x76, 0x0B, 0xFF, 0x07,
  0x77, 0x74, 0x08, 0xF0, 0xA0, 0xDF, 0x05, 0x77, 0x72, 0x06, 0xF8, 0x29, 0x01, 0xDF, 0x03, 0x77,
  0x70, 0x4F, 0x09, 0x30, 0x10, 0xDE, 0x0E, 0x02, 0x77, 0x50, 0x20, 0xEE, 0x09, 0x50, 0x10, 0xCE,
  0x0D, 0x01, 0x77, 0x30, 0x10, 0xDE, 0x08, 0x70, 0x10, 0xCE, 0x0C, 0x77, 0x30, 0xCE, 0x08, 0x72,
  0x01, 0x0B, 0xE0, 0xB7, 0x71, 0x0B, 0xE0, 0x67, 0x50, 0xAE, 0x0A, 0x76, 0x0A, 0xD0, 0xE0, 0x47,
  0x70, 0x7E, 0x0A, 0x74, 0x03, 0xD0, 0xB0, 0x17, 0x72, 0x03, 0x0D, 0xD0, 0x38, 0x0B, 0xF5, 0x00,
  0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77,
  0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0,
  0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67,
  0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F,
  0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06,
  0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06,
  0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0,
  0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30,
  0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF,
  0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73,
  0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A,
  0x80, 0xC4, 0xF0, 0x0A, 0x80, 0xC4, 0xF0, 0x0A, 0x80, 0xC4, 0xF0, 0x0A, 0x80, 0xC4, 0xF0, 0x0A,
  0x80, 0xC4, 0xF0, 0x0A, 0x80, 0xC4, 0xF0, 0x0A, 0x80, 0xC4, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30,
  0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF,
  0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73,
  0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A,
  0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77,
  0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00,
  0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77,
  0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0,
  0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67,
  0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F,
  0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06,
  0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06,
  0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0xA0,
  // "ĥ" (U+0125)
  0x74, 0x02, 0x80, 0x47, 0x80, 0xD0, 0x00, 0xCF, 0x90, 0x88, 0x0C, 0x60, 0x06, 0xFB, 0x03, 0x80,
  0xC4, 0x00, 0x3F, 0xC0, 0xD0, 0x18, 0x0C, 0x30, 0x0D, 0xFD, 0x0A, 0x80, 0xC2, 0x00, 0xBF, 0xF0,
  0x78, 0x0C, 0x00, 0x08, 0xF0, 0xA0, 0xDF, 0x05, 0x77, 0x77, 0x60, 0x6F, 0x82, 0x90, 0x1D, 0xF0,
  0x37, 0x77, 0x74, 0x04, 0xF0, 0x93, 0x01, 0x0D, 0xE0, 0xE0, 0x27, 0x77, 0x72, 0x02, 0x0E, 0xE0,
  0x95, 0x01, 0x0C, 0xE0, 0xD0, 0x17, 0x77, 0x70, 0x10, 0xDE, 0x08, 0x70, 0x10, 0xCE, 0x0C, 0x77,
  0x77, 0x0C, 0xE0, 0x87, 0x20, 0x10, 0xBE, 0x0B, 0x77, 0x75, 0x0B, 0xE0, 0x67, 0x50, 0xAE, 0x0A,
  0x77, 0x73, 0x0A, 0xD0, 0xE0, 0x47, 0x70, 0x7E, 0x0A, 0x77, 0x71, 0x03, 0xD0, 0xB0, 0x17, 0x72,
  0x03, 0x0D, 0xD0, 0x38, 0x0D, 0xB3, 0x00, 0xCF, 0x04, 0x80, 0xD0, 0x00, 0xCF, 0x04, 0x80, 0xD0,
  0x00, 0xCF, 0x04, 0x80, 0xD0, 0x00, 0xCF, 0x04, 0x80, 0xD0, 0x00, 0xCF, 0x04, 0x80, 0xD0, 0x00,
  0xCF, 0x04, 0x80, 0xD0, 0x00, 0xCF, 0x04, 0x80, 0xD0, 0x00, 0xCF, 0x04, 0x80, 0xD0, 0x00, 0xCF,
  0x04, 0x80, 0xD0, 0x00, 0xCF, 0x04, 0x80, 0xD0, 0x00, 0xCF, 0x04, 0x80, 0xD0, 0x00, 0xCF, 0x04,
  0x80, 0xD0, 0x00, 0xCF, 0x04, 0x80, 0xD0, 0x00, 0xCF, 0x04, 0x80, 0xD0, 0x00, 0xCF, 0x04, 0x80,
  0xD0, 0x00, 0xCF, 0x04, 0x80, 0xD0, 0x00, 0xCF, 0x04, 0x80, 0xD0, 0x00, 0xCF, 0x04, 0x80, 0xD0,
  0x00, 0xCF, 0x04, 0x80, 0xD0, 0x00, 0xCF, 0x04, 0x71, 0x89, 0x31, 0x59, 0xBD, 0xEF, 0xEE, 0xCA,
  0x62, 0x77, 0x72, 0x0C, 0xF0, 0x46, 0x05, 0x0B, 0xFE, 0x0D, 0x07, 0x77, 0x70, 0xCF, 0x03, 0x40,
  0x30, 0xCF, 0xFB, 0x0E, 0x06, 0x77, 0x50, 0xCF, 0x03, 0x30, 0x7F, 0xFF, 0x0B, 0x01, 0x77, 0x30,
  0xCF, 0x02, 0x20, 0x9F, 0xFF, 0xA0, 0xC0, 0x17, 0x72, 0x0C, 0xF8, 0x11, 0x07, 0xFF, 0xFC, 0x0C,
  0x77, 0x20, 0xCF, 0x10, 0x4F, 0x98, 0x5D, 0xA9, 0x89, 0xBE, 0xFD, 0x08, 0x77, 0x10, 0xCF, 0x10,
  0xDD, 0x81, 0xE7, 0x27, 0x02, 0x09, 0xFC, 0x02, 0x77, 0x0C, 0xF0, 0xAD, 0x09, 0x01, 0x74, 0x02,
  0x0C, 0xFA, 0x09, 0x77, 0x0C, 0xFD, 0x06, 0x77, 0x10, 0xBF, 0xA0, 0x17, 0x60, 0xCF, 0xC0, 0x67,
  0x72, 0x01, 0x0E, 0xF9, 0x05, 0x76, 0x0C, 0xFB, 0x0A, 0x77, 0x40, 0x5F, 0x90, 0x97, 0x60, 0xCF,
  0xA0, 0xE0, 0x17, 0x75, 0x0E, 0xF0, 0xC7, 0x60, 0xCF, 0xA0, 0x67, 0x76, 0x09, 0xF9, 0x76, 0x0C,
  0xF9, 0x0E, 0x77, 0x70, 0x5F, 0x90, 0x17, 0x50, 0xCF, 0x90, 0x97, 0x77, 0x02, 0xF9, 0x02, 0x75,
  0x0C, 0xF9, 0x04, 0x77, 0x71, 0xF9, 0x03, 0x75, 0x0C, 0xF9, 0x77, 0x72, 0x0E, 0xF0, 0x37, 0x50,
  0xCF, 0x0C, 0x77, 0x72, 0x0D, 0xF0, 0x37, 0x50, 0xCF, 0x09, 0x77, 0x72, 0x0D, 0xF0, 0x37, 0x50,
  0xCF, 0x07, 0x77, 0x72, 0x0D, 0xF0, 0x37, 0x50, 0xCF, 0x06, 0x77, 0x72, 0x0D, 0xF0, 0x37, 0x50,
  0xCF, 0x05, 0x77, 0x72, 0x0D, 0xF0, 0x37, 0x50, 0xCF, 0x05, 0x77, 0x72, 0x0D, 0xF0, 0x37, 0x50,
  0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x37, 0x50, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x37, 0x50,
  0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x37, 0x50, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x37, 0x50,
  0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x37, 0x50, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x37, 0x50,
  0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x37, 0x50, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x37, 0x50,
  0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x37, 0x50, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x37, 0x50,
  0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x37, 0x50, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x37, 0x50,
  0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x37, 0x50, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x37, 0x50,
  0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x37, 0x50, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x37, 0x50,
  0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x37, 0x50, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x37, 0x50,
  0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x37, 0x50, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x37, 0x50,
  0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x37, 0x50, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x37, 0x50,
  0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x37, 0x50, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x37, 0x50,
  0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30,
  // "Ħ" (U+0126)
  0x60, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0xA7, 0x50, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0xA7,
  0x50, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0xA7, 0x50, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0xA7,
  0x50, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0xA7, 0x50, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0xA7,
  0x50, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0xA7, 0x50, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0xA7,
  0x50, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0xA7, 0x50, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0xA6,
  0x80, 0x28, 0x0D, 0xF0, 0xB8, 0x0A, 0x48, 0x0B, 0xF0, 0xD8, 0x02, 0x88, 0x0D, 0x80, 0xF6, 0x0A,
  0xF0, 0x67, 0x77, 0x30, 0x6F, 0x0A, 0x75, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x0A, 0x75, 0x0A,
  0xF0, 0x67, 0x77, 0x30, 0x6F, 0x0A, 0x75, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x0A, 0x75, 0x0A,
  0xF0, 0x67, 0x77, 0x30, 0x6F, 0x0A, 0x75, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x0A, 0x75, 0x0A,
  0xF0, 0x67, 0x77, 0x30, 0x6F, 0x0A, 0x75, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x0A, 0x75, 0x0A,
  0xF0, 0x67, 0x77, 0x30, 0x6F, 0x0A, 0x75, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x0A, 0x75, 0x0A,
  0x80, 0xC4, 0xF0, 0xA7, 0x50, 0xA8, 0x0C, 0x4F, 0x0A, 0x75, 0x0A, 0x80, 0xC4, 0xF0, 0xA7, 0x50,
  0xA8, 0x0C, 0x4F, 0x0A, 0x75, 0x0A, 0x80, 0xC4, 0xF0, 0xA7, 0x50, 0xA8, 0x0C, 0x4F, 0x0A, 0x75,
  0x0A, 0x80, 0xC4, 0xF0, 0xA7, 0x50, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0xA7, 0x50, 0xAF, 0x06,
  0x77, 0x73, 0x06, 0xF0, 0xA7, 0x50, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0xA7, 0x50, 0xAF, 0x06,
  0x77, 0x73, 0x06, 0xF0, 0xA7, 0x50, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0xA7, 0x50, 0xAF, 0x06,
  0x77, 0x73, 0x06, 0xF0, 0xA7, 0x50, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0xA7, 0x50, 0xAF, 0x06,
  0x77, 0x73, 0x06, 0xF0, 0xA7, 0x50, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0xA7, 0x50, 0xAF, 0x06,
  0x77, 0x73, 0x06, 0xF0, 0xA7, 0x50, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0xA7, 0x50, 0xAF, 0x06,
  0x77, 0x73, 0x06, 0xF0, 0xA7, 0x50, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0xA7, 0x50, 0xAF, 0x06,
  0x77, 0x73, 0x06, 0xF0, 0xA7, 0x50, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0xA7, 0x50, 0xAF, 0x06,
  0x77, 0x73, 0x06, 0xF0, 0xA7, 0x50, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0xA7, 0x50, 0xAF, 0x06,
  0x77, 0x73, 0x06, 0xF0, 0xA7, 0x50, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0xA7, 0x50, 0xAF, 0x06,
  0x77, 0x73, 0x06, 0xF0, 0xA7, 0x50, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0xA7, 0x50, 0xAF, 0x06,
  0x77, 0x73, 0x06, 0xF0, 0xA7, 0x50, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0xA7, 0x50, 0xAF, 0x06,
  0x77, 0x73, 0x06, 0xF0, 0xA7, 0x50, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0xA7, 0x50, 0xAF, 0x06,
  0x77, 0x73, 0x06, 0xF0, 0xA7, 0x50, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0xA7, 0x50, 0xAF, 0x06,
  0x77, 0x73, 0x06, 0xF0, 0xA7, 0x50, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0xA7, 0x50, 0xAF, 0x06,
  0x77, 0x73, 0x06, 0xF0, 0xA6,
  // "ħ" (U+0127)
  0x70, 0xCF, 0x04, 0x80, 0xC3, 0x00, 0xCF, 0x04, 0x80, 0xC3, 0x00, 0xCF, 0x04, 0x80, 0xC3, 0x00,
  0xCF, 0x04, 0x80, 0xC3, 0x00, 0xCF, 0x04, 0x80, 0xC3, 0x00, 0xCF, 0x04, 0x80, 0xC3, 0x00, 0xCF,
  0x04, 0x80, 0xC3, 0x00, 0xCF, 0x04, 0x77, 0x77, 0x4F, 0xFF, 0xFB, 0x02, 0x77, 0x2F, 0xFF, 0xFB,
  0x02, 0x77, 0x2F, 0xFF, 0xFB, 0x02, 0x77, 0x2F, 0xFF, 0xFB, 0x02, 0x77, 0x2F, 0xFF, 0xFB, 0x02,
  0x77, 0x2F, 0xFF, 0xFB, 0x02, 0x77, 0x72, 0x0C, 0xF0, 0x48, 0x0C, 0x30, 0x0C, 0xF0, 0x48, 0x0C,
  0x30, 0x0C, 0xF0, 0x48, 0x0C, 0x30, 0x0C, 0xF0, 0x48, 0x0C, 0x30, 0x0C, 0xF0, 0x48, 0x0C, 0x30,
  0x0C, 0xF0, 0x47, 0x18, 0x93, 0x15, 0x9B, 0xDE, 0xFE, 0xEC, 0xA6, 0x27, 0x74, 0x0C, 0xF0, 0x46,
  0x05, 0x0B, 0xFE, 0x0D, 0x07, 0x77, 0x20, 0xCF, 0x03, 0x40, 0x30, 0xCF, 0xFB, 0x0E, 0x06, 0x77,
  0x0C, 0xF0, 0x33, 0x07, 0xFF, 0xF0, 0xB0, 0x17, 0x50, 0xCF, 0x02, 0x20, 0x9F, 0xFF, 0xA0, 0xC0,
  0x17, 0x40, 0xCF, 0x81, 0x10, 0x7F, 0xFF, 0xC0, 0xC7, 0x40, 0xCF, 0x10, 0x4F, 0x98, 0x5D, 0xA9,
  0x89, 0xBE, 0xFD, 0x08, 0x73, 0x0C, 0xF1, 0x0D, 0xD8, 0x1E, 0x72, 0x70, 0x20, 0x9F, 0xC0, 0x27,
  0x20, 0xCF, 0x0A, 0xD0, 0x90, 0x17, 0x40, 0x20, 0xCF, 0xA0, 0x97, 0x20, 0xCF, 0xD0, 0x67, 0x71,
  0x0B, 0xFA, 0x01, 0x71, 0x0C, 0xFC, 0x06, 0x77, 0x20, 0x10, 0xEF, 0x90, 0x57, 0x10, 0xCF, 0xB0,
  0xA7, 0x74, 0x05, 0xF9, 0x09, 0x71, 0x0C, 0xFA, 0x0E, 0x01, 0x77, 0x50, 0xEF, 0x0C, 0x71, 0x0C,
  0xFA, 0x06, 0x77, 0x60, 0x9F, 0x97, 0x10, 0xCF, 0x90, 0xE7, 0x77, 0x05, 0xF9, 0x01, 0x70, 0xCF,
  0x90, 0x97, 0x77, 0x02, 0xF9, 0x02, 0x70, 0xCF, 0x90, 0x47, 0x77, 0x1F, 0x90, 0x37, 0x0C, 0xF9,
  0x77, 0x72, 0x0E, 0xF0, 0x37, 0x0C, 0xF0, 0xC7, 0x77, 0x20, 0xDF, 0x03, 0x70, 0xCF, 0x09, 0x77,
  0x72, 0x0D, 0xF0, 0x37, 0x0C, 0xF0, 0x77, 0x77, 0x20, 0xDF, 0x03, 0x70, 0xCF, 0x06, 0x77, 0x72,
  0x0D, 0xF0, 0x37, 0x0C, 0xF0, 0x57, 0x77, 0x20, 0xDF, 0x03, 0x70, 0xCF, 0x05, 0x77, 0x72, 0x0D,
  0xF0, 0x37, 0x0C, 0xF0, 0x47, 0x77, 0x20, 0xDF, 0x03, 0x70, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0,
  0x37, 0x0C, 0xF0, 0x47, 0x77, 0x20, 0xDF, 0x03, 0x70, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x37,
  0x0C, 0xF0, 0x47, 0x77, 0x20, 0xDF, 0x03, 0x70, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x37, 0x0C,
  0xF0, 0x47, 0x77, 0x20, 0xDF, 0x03, 0x70, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x37, 0x0C, 0xF0,
  0x47, 0x77, 0x20, 0xDF, 0x03, 0x70, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x37, 0x0C, 0xF0, 0x47,
  0x77, 0x20, 0xDF, 0x03, 0x70, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x37, 0x0C, 0xF0, 0x47, 0x77,
  0x20, 0xDF, 0x03, 0x70, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x37, 0x0C, 0xF0, 0x47, 0x77, 0x20,
  0xDF, 0x03, 0x70, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x37, 0x0C, 0xF0, 0x47, 0x77, 0x20, 0xDF,
  0x03, 0x70, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x37, 0x0C, 0xF0, 0x47, 0x77, 0x20, 0xDF, 0x03,
  0x70, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x37, 0x0C, 0xF0, 0x47, 0x77, 0x20, 0xDF, 0x03, 0x70,
  0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x37, 0x0C, 0xF0, 0x47, 0x77, 0x20, 0xDF, 0x03, 0x70, 0xCF,
  0x04, 0x77, 0x72, 0x0D, 0xF0, 0x37, 0x0C, 0xF0, 0x47, 0x77, 0x20, 0xDF, 0x03,
  // "Ĩ" (U+0128)
  0x72, 0x84, 0x46, 0x87, 0x51, 0x77, 0x84, 0x38, 0x88, 0x81, 0x71, 0x08, 0x0E, 0xE0, 0xB0, 0x37,
  0x50, 0x9C, 0x70, 0x20, 0xDF, 0xB0, 0xA0, 0x17, 0x30, 0xEB, 0x0D, 0x60, 0x10, 0xDF, 0xD0, 0xE0,
  0x77, 0x10, 0x8C, 0x09, 0x60, 0xBF, 0xF9, 0x0D, 0x06, 0x50, 0x6D, 0x05, 0x50, 0x5F, 0xFC, 0x83,
  0xEA, 0x89, 0xDD, 0x0E, 0x60, 0xCF, 0xFF, 0xF0, 0x85, 0x03, 0xD8, 0x5D, 0x51, 0x01, 0x5C, 0xFF,
  0xA0, 0xE0, 0x15, 0x08, 0xC0, 0xD0, 0x16, 0x05, 0x0D, 0xFF, 0x05, 0x60, 0xCC, 0x04, 0x72, 0x07,
  0xFD, 0x07, 0x70, 0xEB, 0x0D, 0x74, 0x02, 0x0A, 0xF9, 0x0E, 0x06, 0x70, 0x1C, 0x08, 0x76, 0x87,
  0x28, 0xCE, 0xFD, 0xB6, 0x18, 0x0B, 0xB3, 0x00, 0x1F, 0xFF, 0xFE, 0x00, 0x1F, 0xFF, 0xFE, 0x00,
  0x1F, 0xFF, 0xFE, 0x00, 0x1F, 0xFF, 0xFE, 0x00, 0x1F, 0xFF, 0xFE, 0x00, 0x1F, 0xFF, 0xFE, 0x86,
  0x10, 0x68, 0x9B, 0xCD, 0xFF, 0xF8, 0x5E, 0xDC, 0xA9, 0x86, 0x73, 0x83, 0x23, 0x56, 0x8F, 0x98,
  0x37, 0x64, 0x32, 0x77, 0x71, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0,
  0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76,
  0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E,
  0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60,
  0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7,
  0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02,
  0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77,
  0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F,
  0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77,
  0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0,
  0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76,
  0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E,
  0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60,
  0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7,
  0x77, 0x18, 0x42, 0x35, 0x67, 0x9F, 0x98, 0x48, 0x76, 0x43, 0x27, 0x28, 0x38, 0x9A, 0xCD, 0xFF,
  0xFA, 0x86, 0xED, 0xCA, 0x98, 0x01, 0xFF, 0xFF, 0xE0, 0x01, 0xFF, 0xFF, 0xE0, 0x01, 0xFF, 0xFF,
  0xE0, 0x01, 0xFF, 0xFF, 0xE0, 0x01, 0xFF, 0xFF, 0xE0, 0x10,
  // "ĩ" (U+0129)
  0x74, 0x84, 0x46, 0x87, 0x51, 0x77, 0x84, 0x38, 0x88, 0x81, 0x77, 0x08, 0x0E, 0xE0, 0xB0, 0x37,
  0x50, 0x9C, 0x76, 0x02, 0x0D, 0xFB, 0x0A, 0x01, 0x73, 0x0E, 0xB0, 0xD7, 0x50, 0x10, 0xDF, 0xD0,
  0xE0, 0x77, 0x10, 0x8C, 0x09, 0x75, 0x0B, 0xFF, 0x90, 0xD0, 0x65, 0x06, 0xD0, 0x57, 0x40, 0x5F,
  0xFC, 0x83, 0xEA, 0x89, 0xDD, 0x0E, 0x75, 0x0C, 0xFF, 0xFF, 0x08, 0x74, 0x03, 0xD8, 0x5D, 0x51,
  0x01, 0x5C, 0xFF, 0xA0, 0xE0, 0x17, 0x40, 0x8C, 0x0D, 0x01, 0x60, 0x50, 0xDF, 0xF0, 0x57, 0x50,
  0xCC, 0x04, 0x72, 0x07, 0xFD, 0x07, 0x76, 0x0E, 0xB0, 0xD7, 0x40, 0x20, 0xAF, 0x90, 0xE0, 0x67,
  0x60, 0x1C, 0x08, 0x76, 0x87, 0x28, 0xCE, 0xFD, 0xB6, 0x18, 0x0C, 0x84, 0x00, 0x5F, 0xFF, 0xA0,
  0x77, 0x73, 0x05, 0xFF, 0xFA, 0x07, 0x77, 0x30, 0x5F, 0xFF, 0xA0, 0x77, 0x73, 0x05, 0xFF, 0xFA,
  0x07, 0x77, 0x30, 0x5F, 0xFF, 0xA0, 0x77, 0x73, 0x05, 0xFF, 0xFA, 0x07, 0x77, 0x48, 0x91, 0x24,
  0x56, 0x78, 0x9A, 0xBD, 0xEF, 0xD0, 0x77, 0x77, 0x73, 0x81, 0x23, 0xBF, 0x07, 0x77, 0x77, 0x50,
  0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F,
  0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07,
  0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77,
  0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77,
  0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50,
  0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F,
  0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07,
  0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77,
  0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77,
  0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50,
  0x9F, 0x07, 0x77, 0x75, 0x86, 0x12, 0x35, 0x67, 0x8D, 0xF8, 0x5C, 0x87, 0x54, 0x32, 0x73, 0x87,
  0x46, 0x78, 0xAB, 0xCD, 0xEF, 0xFF, 0xC8, 0x7D, 0xCB, 0xA8, 0x76, 0x3C, 0x80, 0xC4, 0xF0, 0x90,
  0xC8, 0x0C, 0x4F, 0x09, 0x0C, 0x80, 0xC4, 0xF0, 0x90, 0xC8, 0x0C, 0x4F, 0x09, 0x0C, 0x80, 0xC4,
  0xF0, 0x90,
  // "Ī" (U+012A)
  0x40, 0x28, 0x0A, 0x68, 0x03, 0x71, 0x04, 0xFF, 0xFD, 0x06, 0x71, 0x04, 0xFF, 0xFD, 0x06, 0x71,
  0x04, 0xFF, 0xFD, 0x06, 0x71, 0x04, 0xFF, 0xFD, 0x06, 0x71, 0x04, 0xFF, 0xFD, 0x06, 0x71, 0x04,
  0xFF, 0xFD, 0x06, 0x80, 0xBF, 0x40, 0x01, 0xFF, 0xFF, 0xE0, 0x01, 0xFF, 0xFF, 0xE0, 0x01, 0xFF,
  0xFF, 0xE0, 0x01, 0xFF, 0xFF, 0xE0, 0x01, 0xFF, 0xFF, 0xE0, 0x01, 0xFF, 0xFF, 0xE8, 0x61, 0x06,
  0x89, 0xBC, 0xDF, 0xFF, 0x85, 0xED, 0xCA, 0x98, 0x67, 0x38, 0x32, 0x35, 0x68, 0xF9, 0x83, 0x76,
  0x43, 0x27, 0x77, 0x10, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77,
  0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F,
  0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77,
  0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0,
  0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76,
  0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E,
  0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60,
  0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7,
  0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02,
  0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77,
  0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F,
  0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77,
  0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0,
  0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x71,
  0x84, 0x23, 0x56, 0x79, 0xF9, 0x84, 0x87, 0x64, 0x32, 0x72, 0x83, 0x89, 0xAC, 0xDF, 0xFF, 0xA8,
  0x6E, 0xDC, 0xA9, 0x80, 0x1F, 0xFF, 0xFE, 0x00, 0x1F, 0xFF, 0xFE, 0x00, 0x1F, 0xFF, 0xFE, 0x00,
  0x1F, 0xFF, 0xFE, 0x00, 0x1F, 0xFF, 0xFE, 0x01,
  // "ī" (U+012B)
  0x60, 0x28, 0x0A, 0x68, 0x03, 0x77, 0x04, 0xFF, 0xFD, 0x06, 0x77, 0x04, 0xFF, 0xFD, 0x06, 0x77,
  0x04, 0xFF, 0xFD, 0x06, 0x77, 0x04, 0xFF, 0xFD, 0x06, 0x77, 0x04, 0xFF, 0xFD, 0x06, 0x77, 0x04,
  0xFF, 0xFD, 0x06, 0x80, 0xCD, 0x30, 0x05, 0xFF, 0xFA, 0x07, 0x77, 0x30, 0x5F, 0xFF, 0xA0, 0x77,
  0x73, 0x05, 0xFF, 0xFA, 0x07, 0x77, 0x30, 0x5F, 0xFF, 0xA0, 0x77, 0x73, 0x05, 0xFF, 0xFA, 0x07,
  0x77, 0x30, 0x5F, 0xFF, 0xA0, 0x77, 0x74, 0x89, 0x12, 0x45, 0x67, 0x89, 0xAB, 0xDE, 0xFD, 0x07,
  0x77, 0x77, 0x38, 0x12, 0x3B, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0,
  0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77,
  0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77,
  0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75,
  0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09,
  0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0,
  0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77,
  0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77,
  0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75,
  0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09,
  0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x58, 0x61, 0x23,
  0x56, 0x78, 0xDF, 0x85, 0xC8, 0x75, 0x43, 0x27, 0x38, 0x74, 0x67, 0x8A, 0xBC, 0xDE, 0xFF, 0xFC,
  0x87, 0xDC, 0xBA, 0x87, 0x63, 0xC8, 0x0C, 0x4F, 0x09, 0x0C, 0x80, 0xC4, 0xF0, 0x90, 0xC8, 0x0C,
  0x4F, 0x09, 0x0C, 0x80, 0xC4, 0xF0, 0x90, 0xC8, 0x0C, 0x4F, 0x09,
  // "Ĭ" (U+012C)
  0x40, 0xDC, 0x06, 0x77, 0x20, 0x6D, 0x71, 0x0C, 0xC0, 0xB7, 0x72, 0x0B, 0xC0, 0xD7, 0x10, 0x9D,
  0x04, 0x77, 0x03, 0xD0, 0xB7, 0x10, 0x5D, 0x0D, 0x02, 0x75, 0x01, 0x0C, 0xD0, 0x67, 0x20, 0xED,
  0x0E, 0x05, 0x73, 0x03, 0x0D, 0xE0, 0x17, 0x20, 0x7F, 0x82, 0xD7, 0x41, 0x28, 0x21, 0x37, 0xCF,
  0x09, 0x74, 0x0D, 0xFF, 0xF9, 0x0E, 0x01, 0x74, 0x03, 0x0E, 0xFF, 0xF0, 0x37, 0x60, 0x40, 0xEF,
  0xFC, 0x0E, 0x04, 0x77, 0x10, 0x20, 0xDF, 0xFA, 0x0C, 0x02, 0x77, 0x40, 0x60, 0xDF, 0xD0, 0xC0,
  0x57, 0x77, 0x18, 0x92, 0x37, 0xBD, 0xEF, 0xED, 0xCA, 0x63, 0x80, 0xBC, 0x00, 0x01, 0xFF, 0xFF,
  0xE0, 0x01, 0xFF, 0xFF, 0xE0, 0x01, 0xFF, 0xFF, 0xE0, 0x01, 0xFF, 0xFF, 0xE0, 0x01, 0xFF, 0xFF,
  0xE0, 0x01, 0xFF, 0xFF, 0xE8, 0x61, 0x06, 0x89, 0xBC, 0xDF, 0xFF, 0x85, 0xED, 0xCA, 0x98, 0x67,
  0x38, 0x32, 0x35, 0x68, 0xF9, 0x83, 0x76, 0x43, 0x27, 0x77, 0x10, 0x2F, 0x0E, 0x77, 0x76, 0x02,
  0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77,
  0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F,
  0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77,
  0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0,
  0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76,
  0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E,
  0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60,
  0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7,
  0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02,
  0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77,
  0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F,
  0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77,
  0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0,
  0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x71, 0x84, 0x23, 0x56, 0x79, 0xF9, 0x84, 0x87, 0x64, 0x32,
  0x72, 0x83, 0x89, 0xAC, 0xDF, 0xFF, 0xA8, 0x6E, 0xDC, 0xA9, 0x80, 0x1F, 0xFF, 0xFE, 0x00, 0x1F,
  0xFF, 0xFE, 0x00, 0x1F, 0xFF, 0xFE, 0x00, 0x1F, 0xFF, 0xFE, 0x00, 0x1F, 0xFF, 0xFE, 0x01,
  // "ĭ" (U+012D)
  0x60, 0xDC, 0x06, 0x77, 0x20, 0x6D, 0x77, 0x0C, 0xC0, 0xB7, 0x72, 0x0B, 0xC0, 0xD7, 0x70, 0x9D,
  0x04, 0x77, 0x03, 0xD0, 0xB7, 0x70, 0x5D, 0x0D, 0x02, 0x75, 0x01, 0x0C, 0xD0, 0x67, 0x71, 0x0E,
  0xD0, 0xE0, 0x57, 0x30, 0x30, 0xDE, 0x01, 0x77, 0x10, 0x7F, 0x82, 0xD7, 0x41, 0x28, 0x21, 0x37,
  0xCF, 0x09, 0x77, 0x30, 0xDF, 0xFF, 0x90, 0xE0, 0x17, 0x73, 0x03, 0x0E, 0xFF, 0xF0, 0x37, 0x75,
  0x04, 0x0E, 0xFF, 0xC0, 0xE0, 0x47, 0x77, 0x02, 0x0D, 0xFF, 0xA0, 0xC0, 0x27, 0x77, 0x30, 0x60,
  0xDF, 0xD0, 0xC0, 0x57, 0x77, 0x78, 0x92, 0x37, 0xBD, 0xEF, 0xED, 0xCA, 0x63, 0x80, 0xC9, 0x10,
  0x05, 0xFF, 0xFA, 0x07, 0x77, 0x30, 0x5F, 0xFF, 0xA0, 0x77, 0x73, 0x05, 0xFF, 0xFA, 0x07, 0x77,
  0x30, 0x5F, 0xFF, 0xA0, 0x77, 0x73, 0x05, 0xFF, 0xFA, 0x07, 0x77, 0x30, 0x5F, 0xFF, 0xA0, 0x77,
  0x74, 0x89, 0x12, 0x45, 0x67, 0x89, 0xAB, 0xDE, 0xFD, 0x07, 0x77, 0x77, 0x38, 0x12, 0x3B, 0xF0,
  0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77,
  0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77,
  0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75,
  0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09,
  0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0,
  0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77,
  0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77,
  0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75,
  0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09,
  0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x75, 0x09, 0xF0,
  0x77, 0x77, 0x75, 0x09, 0xF0, 0x77, 0x77, 0x58, 0x61, 0x23, 0x56, 0x78, 0xDF, 0x85, 0xC8, 0x75,
  0x43, 0x27, 0x38, 0x74, 0x67, 0x8A, 0xBC, 0xDE, 0xFF, 0xFC, 0x87, 0xDC, 0xBA, 0x87, 0x63, 0xC8,
  0x0C, 0x4F, 0x09, 0x0C, 0x80, 0xC4, 0xF0, 0x90, 0xC8, 0x0C, 0x4F, 0x09, 0x0C, 0x80, 0xC4, 0xF0,
  0x90, 0xC8, 0x0C, 0x4F, 0x09,
  // "Į" (U+012E)
  0x01, 0xFF, 0xFF, 0xE0, 0x01, 0xFF, 0xFF, 0xE0, 0x01, 0xFF, 0xFF, 0xE0, 0x01, 0xFF, 0xFF, 0xE0,
  0x01, 0xFF, 0xFF, 0xE0, 0x01, 0xFF, 0xFF, 0xE8, 0x61, 0x06, 0x89, 0xBC, 0xDF, 0xFF, 0x85, 0xED,
  0xCA, 0x98, 0x67, 0x38, 0x32, 0x35, 0x68, 0xF9, 0x83, 0x76, 0x43, 0x27, 0x77, 0x10, 0x2F, 0x0E,
  0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60,
  0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7,
  0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02,
  0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77,
  0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F,
  0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77,
  0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0,
  0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76,
  0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E,
  0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60,
  0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7,
  0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02,
  0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77,
  0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x71, 0x84, 0x23, 0x56, 0x79, 0xF9, 0x84,
  0x87, 0x64, 0x32, 0x72, 0x83, 0x89, 0xAC, 0xDF, 0xFF, 0xA8, 0x6E, 0xDC, 0xA9, 0x80, 0x1F, 0xFF,
  0xFE, 0x00, 0x1F, 0xFF, 0xFE, 0x00, 0x1F, 0xFF, 0xFE, 0x00, 0x1F, 0xFF, 0xFE, 0x00, 0x1F, 0xFF,
  0xFE, 0x01, 0x77, 0x73, 0x06, 0xC0, 0xB0, 0x27, 0x77, 0x70, 0x8D, 0x08, 0x77, 0x77, 0x09, 0xD0,
  0x87, 0x77, 0x70, 0x7D, 0x0A, 0x77, 0x77, 0x05, 0xD0, 0xC7, 0x77, 0x70, 0x10, 0xED, 0x02, 0x77,
  0x77, 0x09, 0xD0, 0x87, 0x77, 0x70, 0x2E, 0x01, 0x77, 0x77, 0x08, 0xD0, 0xB7, 0x77, 0x71, 0x0C,
  0xD0, 0x77, 0x77, 0x71, 0xE0, 0x67, 0x77, 0x70, 0x1E, 0x06, 0x77, 0x77, 0x01, 0xE0, 0x97, 0x77,
  0x71, 0xE0, 0xE0, 0x17, 0x77, 0x70, 0xBE, 0x81, 0xD6, 0x22, 0x81, 0x13, 0x47, 0x77, 0x06, 0xFE,
  0x0B, 0x77, 0x71, 0x0D, 0xFD, 0x0B, 0x77, 0x71, 0x02, 0x0E, 0xFC, 0x0B, 0x77, 0x72, 0x02, 0x0B,
  0xFB, 0x0B, 0x77, 0x74, 0x89, 0x13, 0x8B, 0xDE, 0xFE, 0xDB, 0x83, 0x30,
  // "į" (U+012F)
  0x77, 0x38, 0x53, 0xAD, 0xFE, 0xB5, 0x77, 0x77, 0x60, 0x7F, 0x0B, 0x77, 0x77, 0x40, 0x4F, 0xA0,
  0x87, 0x77, 0x73, 0x0B, 0xFA, 0x0E, 0x77, 0x77, 0x30, 0xEF, 0xB0, 0x37, 0x77, 0x72, 0xFC, 0x04,
  0x77, 0x77, 0x2F, 0xC0, 0x37, 0x77, 0x72, 0x0B, 0xFA, 0x0E, 0x77, 0x77, 0x30, 0x4F, 0xA0, 0x87,
  0x77, 0x74, 0x07, 0xF0, 0xA7, 0x77, 0x76, 0x85, 0x3A, 0xDF, 0xEB, 0x58, 0x0E, 0x91, 0x00, 0x5F,
  0xFF, 0xA0, 0x77, 0x73, 0x05, 0xFF, 0xFA, 0x07, 0x77, 0x30, 0x5F, 0xFF, 0xA0, 0x77, 0x73, 0x05,
  0xFF, 0xFA, 0x07, 0x77, 0x30, 0x5F, 0xFF, 0xA0, 0x77, 0x73, 0x05, 0xFF, 0xFA, 0x07, 0x77, 0x48,
  0x91, 0x24, 0x56, 0x78, 0x9A, 0xBD, 0xEF, 0xD0, 0x77, 0x77, 0x73, 0x81, 0x23, 0xBF, 0x07, 0x77,
  0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77,
  0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50,
  0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F,
  0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07,
  0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77,
  0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77,
  0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50,
  0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F,
  0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07,
  0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77,
  0x77, 0x50, 0x9F, 0x07, 0x77, 0x75, 0x86, 0x12, 0x35, 0x67, 0x8D, 0xF8, 0x5C, 0x87, 0x54, 0x32,
  0x73, 0x87, 0x46, 0x78, 0xAB, 0xCD, 0xEF, 0xFF, 0xC8, 0x7D, 0xCB, 0xA8, 0x76, 0x3C, 0x80, 0xC4,
  0xF0, 0x90, 0xC8, 0x0C, 0x4F, 0x09, 0x0C, 0x80, 0xC4, 0xF0, 0x90, 0xC8, 0x0C, 0x4F, 0x09, 0x0C,
  0x80, 0xC4, 0xF0, 0x97, 0x77, 0x70, 0x6C, 0x0B, 0x02, 0x77, 0x77, 0x60, 0x8D, 0x08, 0x77, 0x77,
  0x60, 0x9D, 0x08, 0x77, 0x77, 0x60, 0x7D, 0x0A, 0x77, 0x77, 0x60, 0x5D, 0x0C, 0x77, 0x77, 0x60,
  0x10, 0xED, 0x02, 0x77, 0x77, 0x60, 0x9D, 0x08, 0x77, 0x77, 0x60, 0x2E, 0x01, 0x77, 0x77, 0x60,
  0x8D, 0x0B, 0x77, 0x77, 0x70, 0xCD, 0x07, 0x77, 0x77, 0x7E, 0x06, 0x77, 0x77, 0x60, 0x1E, 0x06,
  0x77, 0x77, 0x60, 0x1E, 0x09, 0x77, 0x77, 0x7E, 0x0E, 0x01, 0x77, 0x77, 0x60, 0xBE, 0x81, 0xD6,
  0x22, 0x81, 0x13, 0x47, 0x77, 0x60, 0x6F, 0xE0, 0xB7, 0x77, 0x70, 0xDF, 0xD0, 0xB7, 0x77, 0x70,
  0x20, 0xEF, 0xC0, 0xB7, 0x77, 0x71, 0x02, 0x0B, 0xFB, 0x0B, 0x77, 0x77, 0x38, 0x91, 0x38, 0xBD,
  0xEF, 0xED, 0xB8, 0x35,
  // "İ" (U+0130)
  0x77, 0x86, 0x18, 0xCE, 0xEC, 0x71, 0x77, 0x76, 0x03, 0x0E, 0xE0, 0xE0, 0x37, 0x77, 0x50, 0xEF,
  0x90, 0xD7, 0x77, 0x40, 0x5F, 0xB0, 0x57, 0x77, 0x30, 0x9F, 0xB0, 0x97, 0x77, 0x30, 0xAF, 0xB0,
  0xA7, 0x77, 0x30, 0x9F, 0xB0, 0x97, 0x77, 0x30, 0x5F, 0xB0, 0x57, 0x77, 0x40, 0xDF, 0x90, 0xD7,
  0x77, 0x50, 0x30, 0xEE, 0x0D, 0x02, 0x77, 0x76, 0x86, 0x17, 0xCE, 0xEC, 0x71, 0x80, 0xD9, 0x60,
  0x01, 0xFF, 0xFF, 0xE0, 0x01, 0xFF, 0xFF, 0xE0, 0x01, 0xFF, 0xFF, 0xE0, 0x01, 0xFF, 0xFF, 0xE0,
  0x01, 0xFF, 0xFF, 0xE0, 0x01, 0xFF, 0xFF, 0xE8, 0x61, 0x06, 0x89, 0xBC, 0xDF, 0xFF, 0x85, 0xED,
  0xCA, 0x98, 0x67, 0x38, 0x32, 0x35, 0x68, 0xF9, 0x83, 0x76, 0x43, 0x27, 0x77, 0x10, 0x2F, 0x0E,
  0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60,
  0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7,
  0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02,
  0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77,
  0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F,
  0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77,
  0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0,
  0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76,
  0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E,
  0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60,
  0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7,
  0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02,
  0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77,
  0x76, 0x02, 0xF0, 0xE7, 0x77, 0x60, 0x2F, 0x0E, 0x77, 0x71, 0x84, 0x23, 0x56, 0x79, 0xF9, 0x84,
  0x87, 0x64, 0x32, 0x72, 0x83, 0x89, 0xAC, 0xDF, 0xFF, 0xA8, 0x6E, 0xDC, 0xA9, 0x80, 0x1F, 0xFF,
  0xFE, 0x00, 0x1F, 0xFF, 0xFE, 0x00, 0x1F, 0xFF, 0xFE, 0x00, 0x1F, 0xFF, 0xFE, 0x00, 0x1F, 0xFF,
  0xFE, 0x01,
  // "ı" (U+0131)
  0x10, 0x5F, 0xFF, 0xA0, 0x77, 0x73, 0x05, 0xFF, 0xFA, 0x07, 0x77, 0x30, 0x5F, 0xFF, 0xA0, 0x77,
  0x73, 0x05, 0xFF, 0xFA, 0x07, 0x77, 0x30, 0x5F, 0xFF, 0xA0, 0x77, 0x73, 0x05, 0xFF, 0xFA, 0x07,
  0x77, 0x48, 0x91, 0x24, 0x56, 0x78, 0x9A, 0xBD, 0xEF, 0xD0, 0x77, 0x77, 0x73, 0x81, 0x23, 0xBF,
  0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07,
  0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77,
  0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77,
  0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50,
  0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F,
  0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07,
  0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77,
  0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77,
  0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50,
  0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0x9F,
  0x07, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x77, 0x75, 0x86, 0x12, 0x35, 0x67, 0x8D, 0xF8, 0x5C, 0x87,
  0x54, 0x32, 0x73, 0x87, 0x46, 0x78, 0xAB, 0xCD, 0xEF, 0xFF, 0xC8, 0x7D, 0xCB, 0xA8, 0x76, 0x3C,
  0x80, 0xC4, 0xF0, 0x90, 0xC8, 0x0C, 0x4F, 0x09, 0x0C, 0x80, 0xC4, 0xF0, 0x90, 0xC8, 0x0C, 0x4F,
  0x09, 0x0C, 0x80, 0xC4, 0xF0, 0x90,
  // "Ĳ" (U+0132)
  0xF9, 0x01, 0x77, 0x40, 0x1F, 0xFA, 0x01, 0x77, 0x40, 0x1F, 0xFA, 0x01, 0x77, 0x40, 0x1F, 0xFA,
  0x01, 0x77, 0x40, 0x1F, 0xFA, 0x01, 0x77, 0x40, 0x1F, 0xFA, 0x01, 0x77, 0x40, 0x1F, 0xFA, 0x01,
  0x77, 0x40, 0x1F, 0xFA, 0x01, 0x77, 0x40, 0x1F, 0xFA, 0x01, 0x77, 0x40, 0x1F, 0xFA, 0x01, 0x77,
  0x40, 0x1F, 0xFA, 0x01, 0x77, 0x40, 0x1F, 0xFA, 0x01, 0x77, 0x40, 0x1F, 0xFA, 0x01, 0x77, 0x40,
  0x1F, 0xFA, 0x01, 0x77, 0x40, 0x1F, 0xFA, 0x01, 0x77, 0x40, 0x1F, 0xFA, 0x01, 0x77, 0x40, 0x1F,
  0xFA, 0x01, 0x77, 0x40, 0x1F, 0xFA, 0x01, 0x77, 0x40, 0x1F, 0xFA, 0x01, 0x77, 0x40, 0x1F, 0xFA,
  0x01, 0x77, 0x40, 0x1F, 0xFA, 0x01, 0x77, 0x40, 0x1F, 0xFA, 0x01, 0x77, 0x40, 0x1F, 0xFA, 0x01,
  0x77, 0x40, 0x1F, 0xFA, 0x01, 0x77, 0x40, 0x1F, 0xFA, 0x01, 0x77, 0x40, 0x1F, 0xFA, 0x01, 0x77,
  0x40, 0x1F, 0xFA, 0x01, 0x77, 0x40, 0x1F, 0xFA, 0x01, 0x77, 0x40, 0x1F, 0xFA, 0x01, 0x77, 0x40,
  0x1F, 0xFA, 0x01, 0x77, 0x40, 0x1F, 0xFA, 0x01, 0x77, 0x40, 0x1F, 0xFA, 0x01, 0x77, 0x40, 0x1F,
  0xFA, 0x01, 0x77, 0x40, 0x1F, 0xFA, 0x01, 0x77, 0x40, 0x1F, 0xFA, 0x01, 0x77, 0x40, 0x1F, 0xFA,
  0x01, 0x77, 0x40, 0x1F, 0xFA, 0x01, 0x77, 0x40, 0x1F, 0xFA, 0x01, 0x77, 0x40, 0x1F, 0xFA, 0x01,
  0x77, 0x40, 0x1F, 0xFA, 0x01, 0x77, 0x40, 0x1F, 0xFA, 0x01, 0x77, 0x40, 0x1F, 0xFA, 0x01, 0x77,
  0x40, 0x1F, 0xFA, 0x01, 0x77, 0x40, 0x1F, 0xFA, 0x01, 0x77, 0x40, 0x1F, 0xFA, 0x01, 0x77, 0x40,
  0x1F, 0xFA, 0x01, 0x77, 0x40, 0x2F, 0x97, 0x77, 0x60, 0x3F, 0x0E, 0x77, 0x76, 0x05, 0xF0, 0xD7,
  0x77, 0x60, 0x8F, 0x0B, 0x77, 0x76, 0x0B, 0xF0, 0x97, 0x77, 0x50, 0x1F, 0x90, 0x67, 0x77, 0x50,
  0x6F, 0x90, 0x37, 0x77, 0x50, 0xEF, 0x0D, 0x77, 0x75, 0x09, 0xF9, 0x08, 0x77, 0x74, 0x07, 0xFA,
  0x83, 0x20, 0x96, 0x17, 0x75, 0x01, 0x0A, 0xFA, 0x0A, 0x20, 0xCA, 0x81, 0xB7, 0x37, 0x78, 0x11,
  0x7E, 0xFB, 0x02, 0x20, 0xCD, 0x85, 0xEB, 0x86, 0x42, 0x13, 0x83, 0x23, 0x6A, 0xEF, 0xC0, 0x73,
  0x0C, 0xFF, 0xFF, 0xA0, 0xB4, 0x0C, 0xFF, 0xFF, 0x90, 0xC5, 0x0C, 0xFF, 0xFF, 0x0B, 0x60, 0xCF,
  0xFF, 0xE0, 0x77, 0x09, 0xFF, 0xFC, 0x0A, 0x02, 0x72, 0x82, 0x16, 0xAD, 0xFF, 0xC8, 0x1D, 0x82,
  0x77, 0x18, 0x71, 0x46, 0x8A, 0xBD, 0xEE, 0xA8, 0x5E, 0xED, 0xB9, 0x62, 0x76,
  // "ĳ" (U+0133)
  0x28, 0x53, 0xAD, 0xFE, 0xB5, 0x77, 0x48, 0x55, 0xBE, 0xFD, 0x93, 0x30, 0x7F, 0x0B, 0x77, 0x20,
  0xBF, 0x81, 0x70, 0x4F, 0xA0, 0x97, 0x70, 0x8F, 0xA0, 0x40, 0xBF, 0xB0, 0x17, 0x60, 0xEF, 0xA0,
  0xB0, 0xEF, 0xB0, 0x47, 0x50, 0x2F, 0xB0, 0xEF, 0xC0, 0x57, 0x50, 0x3F, 0xC0, 0xEF, 0xB0, 0x37,
  0x50, 0x2F, 0xB0, 0xE0, 0xAF, 0xB7, 0x70, 0xEF, 0xA0, 0xA0, 0x3F, 0xA0, 0x97, 0x70, 0x8F, 0xA8,
  0x13, 0x06, 0xF0, 0xB7, 0x72, 0x0A, 0xF0, 0x63, 0x85, 0x39, 0xDF, 0xEB, 0x57, 0x74, 0x85, 0x5B,
  0xEF, 0xD9, 0x28, 0x0D, 0x83, 0x00, 0x7F, 0x09, 0x77, 0x20, 0x4F, 0x0C, 0x20, 0x7F, 0x09, 0x77,
  0x20, 0x4F, 0x0C, 0x20, 0x7F, 0x09, 0x77, 0x20, 0x4F, 0x0C, 0x20, 0x7F, 0x09, 0x77, 0x20, 0x4F,
  0x0C, 0x20, 0x7F, 0x09, 0x77, 0x20, 0x4F, 0x0C, 0x20, 0x7F, 0x09, 0x77, 0x20, 0x4F, 0x0C, 0x20,
  0x7F, 0x09, 0x77, 0x20, 0x4F, 0x0C, 0x20, 0x7F, 0x09, 0x77, 0x20, 0x4F, 0x0C, 0x20, 0x7F, 0x09,
  0x77, 0x20, 0x4F, 0x0C, 0x20, 0x7F, 0x09, 0x77, 0x20, 0x4F, 0x0C, 0x20, 0x7F, 0x09, 0x77, 0x20,
  0x4F, 0x0C, 0x20, 0x7F, 0x09, 0x77, 0x20, 0x4F, 0x0C, 0x20, 0x7F, 0x09, 0x77, 0x20, 0x4F, 0x0C,
  0x20, 0x7F, 0x09, 0x77, 0x20, 0x4F, 0x0C, 0x20, 0x7F, 0x09, 0x77, 0x20, 0x4F, 0x0C, 0x20, 0x7F,
  0x09, 0x77, 0x20, 0x4F, 0x0C, 0x20, 0x7F, 0x09, 0x77, 0x20, 0x4F, 0x0C, 0x20, 0x7F, 0x09, 0x77,
  0x20, 0x4F, 0x0C, 0x20, 0x7F, 0x09, 0x77, 0x20, 0x4F, 0x0C, 0x20, 0x7F, 0x09, 0x77, 0x20, 0x4F,
  0x0C, 0x20, 0x7F, 0x09, 0x77, 0x20, 0x4F, 0x0C, 0x20, 0x7F, 0x09, 0x77, 0x20, 0x4F, 0x0C, 0x20,
  0x7F, 0x09, 0x77, 0x20, 0x4F, 0x0C, 0x20, 0x7F, 0x09, 0x77, 0x20, 0x4F, 0x0C, 0x20, 0x7F, 0x09,
  0x77, 0x20, 0x4F, 0x0C, 0x20, 0x7F, 0x09, 0x77, 0x20, 0x4F, 0x0C, 0x20, 0x7F, 0x09, 0x77, 0x20,
  0x4F, 0x0C, 0x20, 0x7F, 0x09, 0x77, 0x20, 0x4F, 0x0C, 0x20, 0x7F, 0x09, 0x77, 0x20, 0x4F, 0x0C,
  0x20, 0x7F, 0x09, 0x77, 0x20, 0x4F, 0x0C, 0x20, 0x7F, 0x09, 0x77, 0x20, 0x4F, 0x0C, 0x20, 0x7F,
  0x09, 0x77, 0x20, 0x4F, 0x0C, 0x20, 0x7F, 0x09, 0x77, 0x20, 0x4F, 0x0C, 0x20, 0x7F, 0x09, 0x77,
  0x20, 0x4F, 0x0C, 0x20, 0x7F, 0x09, 0x77, 0x20, 0x4F, 0x0C, 0x20, 0x7F, 0x09, 0x77, 0x20, 0x4F,
  0x0C, 0x20, 0x7F, 0x09, 0x77, 0x20, 0x4F, 0x0C, 0x20, 0x7F, 0x09, 0x77, 0x20, 0x4F, 0x0C, 0x20,
  0x7F, 0x09, 0x77, 0x20, 0x4F, 0x0C, 0x20, 0x7F, 0x09, 0x77, 0x20, 0x4F, 0x0C, 0x20, 0x7F, 0x09,
  0x77, 0x20, 0x4F, 0x0C, 0x20, 0x7F, 0x09, 0x77, 0x20, 0x4F, 0x0C, 0x20, 0x7F, 0x09, 0x77, 0x20,
  0x4F, 0x0C, 0x20, 0x7F, 0x09, 0x77, 0x20, 0x4F, 0x0C, 0x20, 0x7F, 0x09, 0x77, 0x20, 0x4F, 0x0C,
  0x20, 0x7F, 0x09, 0x77, 0x20, 0x4F, 0x0C, 0x20, 0x7F, 0x09, 0x77, 0x20, 0x4F, 0x0C, 0x20, 0x7F,
  0x09, 0x77, 0x20, 0x4F, 0x0C, 0x77, 0x76, 0x04, 0xF0, 0xC7, 0x77, 0x60, 0x4F, 0x0C, 0x77, 0x76,
  0x04, 0xF0, 0xC7, 0x77, 0x60, 0x4F, 0x0C, 0x77, 0x76, 0x05, 0xF0, 0xC7, 0x77, 0x60, 0x6F, 0x0C,
  0x77, 0x76, 0x07, 0xF0, 0xB7, 0x77, 0x60, 0xAF, 0x0A, 0x77, 0x76, 0x0E, 0xF0, 0x87, 0x77, 0x50,
  0x4F, 0x90, 0x47, 0x77, 0x50, 0xBF, 0x90, 0x17, 0x77, 0x40, 0x5F, 0x90, 0xB7, 0x77, 0x40, 0x30,
  0xEF, 0x90, 0x54, 0x01, 0x03, 0x77, 0x40, 0x6F, 0xA0, 0xD5, 0x85, 0x4F, 0xEA, 0x74, 0x17, 0x38,
  0x12, 0x6D, 0xFB, 0x04, 0x50, 0x4E, 0x89, 0x0E, 0xCA, 0x99, 0x89, 0xAB, 0xEF, 0xD0, 0x96, 0x04,
  0xFF, 0xFE, 0x0B, 0x70, 0x4F, 0xFF, 0xD0, 0xB7, 0x10, 0x4F, 0xFF, 0xC0, 0x87, 0x20, 0x4F, 0xFF,
  0xA0, 0xB0, 0x27, 0x38, 0x12, 0xBE, 0xFF, 0xC8, 0x1E, 0x93, 0x77, 0x18, 0x71, 0x46, 0x89, 0xBC,
  0xDE, 0xB8, 0x4E, 0xDB, 0x96, 0x27, 0x60,
  // "Ĵ" (U+0134)
  0x77, 0x73, 0x02, 0x80, 0x47, 0x80, 0xC0, 0x00, 0xCF, 0x90, 0x87, 0x77, 0x76, 0x06, 0xFB, 0x03,
  0x77, 0x77, 0x40, 0x3F, 0xC0, 0xD0, 0x17, 0x77, 0x73, 0x0D, 0xFD, 0x0A, 0x77, 0x77, 0x20, 0xBF,
  0xF0, 0x77, 0x77, 0x70, 0x8F, 0x0A, 0x0D, 0xF0, 0x57, 0x77, 0x50, 0x6F, 0x82, 0x90, 0x1D, 0xF0,
  0x37, 0x77, 0x30, 0x4F, 0x09, 0x30, 0x10, 0xDE, 0x0E, 0x02, 0x77, 0x71, 0x02, 0x0E, 0xE0, 0x95,
  0x01, 0x0C, 0xE0, 0xD0, 0x17, 0x76, 0x01, 0x0D, 0xE0, 0x87, 0x01, 0x0C, 0xE0, 0xC7, 0x76, 0x0C,
  0xE0, 0x87, 0x20, 0x10, 0xBE, 0x0B, 0x77, 0x40, 0xBE, 0x06, 0x75, 0x0A, 0xE0, 0xA7, 0x72, 0x0A,
  0xD0, 0xE0, 0x47, 0x70, 0x7E, 0x0A, 0x77, 0x03, 0xD0, 0xB0, 0x17, 0x72, 0x03, 0x0D, 0xD0, 0x38,
  0x0C, 0xC2, 0x00, 0x3F, 0x0D, 0x80, 0xC0, 0x00, 0x3F, 0x0D, 0x80, 0xC0, 0x00, 0x3F, 0x0D, 0x80,
  0xC0, 0x00, 0x3F, 0x0D, 0x80, 0xC0, 0x00, 0x3F, 0x0D, 0x80, 0xC0, 0x00, 0x3F, 0x0D, 0x80, 0xC0,
  0x00, 0x3F, 0x0D, 0x80, 0xC0, 0x00, 0x3F, 0x0D, 0x80, 0xC0, 0x00, 0x3F, 0x0D, 0x80, 0xC0, 0x00,
  0x3F, 0x0D, 0x80, 0xC0, 0x00, 0x3F, 0x0D, 0x80, 0xC0, 0x00, 0x3F, 0x0D, 0x80, 0xC0, 0x00, 0x3F,
  0x0D, 0x80, 0xC0, 0x00, 0x3F, 0x0D, 0x80, 0xC0, 0x00, 0x3F, 0x0D, 0x80, 0xC0, 0x00, 0x3F, 0x0D,
  0x80, 0xC0, 0x00, 0x3F, 0x0D, 0x80, 0xC0, 0x00, 0x3F, 0x0D, 0x80, 0xC0, 0x00, 0x3F, 0x0D, 0x80,
  0xC0, 0x00, 0x3F, 0x0D, 0x80, 0xC0, 0x00, 0x3F, 0x0D, 0x80, 0xC0, 0x00, 0x3F, 0x0D, 0x80, 0xC0,
  0x00, 0x3F, 0x0D, 0x80, 0xC0, 0x00, 0x3F, 0x0D, 0x80, 0xC0, 0x00, 0x3F, 0x0D, 0x80, 0xC0, 0x00,
  0x3F, 0x0D, 0x80, 0xC0, 0x00, 0x3F, 0x0D, 0x80, 0xC0, 0x00, 0x3F, 0x0D, 0x80, 0xC0, 0x00, 0x3F,
  0x0D, 0x80, 0xC0, 0x00, 0x3F, 0x0D, 0x80, 0xC0, 0x00, 0x3F, 0x0D, 0x80, 0xC0, 0x00, 0x3F, 0x0D,
  0x80, 0xC0, 0x00, 0x3F, 0x0D, 0x80, 0xC0, 0x00, 0x3F, 0x0D, 0x80, 0xC0, 0x00, 0x3F, 0x0D, 0x80,
  0xC0, 0x00, 0x3F, 0x0D, 0x80, 0xC0, 0x00, 0x3F, 0x0D, 0x80, 0xC0, 0x00, 0x3F, 0x0D, 0x80, 0xC0,
  0x00, 0x3F, 0x0D, 0x80, 0xC0, 0x00, 0x3F, 0x0D, 0x80, 0xC0, 0x00, 0x3F, 0x0D, 0x80, 0xC0, 0x00,
  0x3F, 0x0D, 0x80, 0xC0, 0x00, 0x3F, 0x0D, 0x80, 0xC0, 0x00, 0x3F, 0x0D, 0x80, 0xC0, 0x00, 0x4F,
  0x0D, 0x80, 0xC0, 0x00, 0x4F, 0x0C, 0x80, 0xC0, 0x00, 0x5F, 0x0C, 0x80, 0xC0, 0x00, 0x7F, 0x0B,
  0x80, 0xC0, 0x00, 0x9F, 0x09, 0x80, 0xC0, 0x00, 0xCF, 0x07, 0x77, 0x77, 0x70, 0x1F, 0x90, 0x47,
  0x77, 0x77, 0x06, 0xF9, 0x01, 0x77, 0x77, 0x70, 0xDF, 0x0D, 0x77, 0x77, 0x70, 0x6F, 0x90, 0x87,
  0x77, 0x76, 0x03, 0xFA, 0x02, 0x76, 0x09, 0x03, 0x77, 0x40, 0x50, 0xEF, 0x90, 0xB7, 0x7A, 0x81,
  0xD8, 0x47, 0x60, 0x20, 0x9F, 0xB0, 0x37, 0x7E, 0x84, 0xC9, 0x63, 0x21, 0x28, 0x21, 0x36, 0xBF,
  0xC0, 0x97, 0x71, 0xFF, 0xFF, 0x0D, 0x01, 0x77, 0x1F, 0xFF, 0xE0, 0xE0, 0x37, 0x72, 0xFF, 0xFD,
  0x0E, 0x03, 0x77, 0x3F, 0xFF, 0xC0, 0xC0, 0x27, 0x74, 0x0B, 0xFF, 0xF9, 0x0E, 0x07, 0x77, 0x78,
  0x22, 0x6B, 0xEF, 0xFA, 0x81, 0xC7, 0x17, 0x77, 0x58, 0x62, 0x57, 0x9B, 0xDD, 0xEA, 0x84, 0xED,
  0xB9, 0x62, 0x77, 0x73,
  // "ĵ" (U+0135)
  0x77, 0x70, 0x28, 0x04, 0x77, 0x77, 0x75, 0x0C, 0xF9, 0x08, 0x77, 0x77, 0x30, 0x6F, 0xB0, 0x37,
  0x77, 0x71, 0x03, 0xFC, 0x0D, 0x01, 0x77, 0x77, 0x0D, 0xFD, 0x0A, 0x77, 0x76, 0x0B, 0xFF, 0x07,
  0x77, 0x74, 0x08, 0xF0, 0xA0, 0xDF, 0x05, 0x77, 0x72, 0x06, 0xF8, 0x29, 0x01, 0xDF, 0x03, 0x77,
  0x70, 0x4F, 0x09, 0x30, 0x10, 0xDE, 0x0E, 0x02, 0x77, 0x50, 0x20, 0xEE, 0x09, 0x50, 0x10, 0xCE,
  0x0D, 0x01, 0x77, 0x30, 0x10, 0xDE, 0x08, 0x70, 0x10, 0xCE, 0x0C, 0x77, 0x30, 0xCE, 0x08, 0x72,
  0x01, 0x0B, 0xE0, 0xB7, 0x71, 0x0B, 0xE0, 0x67, 0x50, 0xAE, 0x0A, 0x76, 0x0A, 0xD0, 0xE0, 0x47,
  0x70, 0x7E, 0x0A, 0x74, 0x03, 0xD0, 0xB0, 0x17, 0x72, 0x03, 0x0D, 0xD0, 0x38, 0x0B, 0xF6, 0x00,
  0x1F, 0xFF, 0xA0, 0xB7, 0x73, 0x01, 0xFF, 0xFA, 0x0B, 0x77, 0x30, 0x1F, 0xFF, 0xA0, 0xB7, 0x73,
  0x01, 0xFF, 0xFA, 0x0B, 0x77, 0x30, 0x1F, 0xFF, 0xA0, 0xB7, 0x73, 0x83, 0x1A, 0xCD, 0xEF, 0xFD,
  0x0B, 0x77, 0x72, 0x89, 0x11, 0x23, 0x45, 0x68, 0x9A, 0xBD, 0xF0, 0xB7, 0x77, 0x75, 0x05, 0xF0,
  0xB7, 0x77, 0x75, 0x05, 0xF0, 0xB7, 0x77, 0x75, 0x05, 0xF0, 0xB7, 0x77, 0x75, 0x05, 0xF0, 0xB7,
  0x77, 0x75, 0x05, 0xF0, 0xB7, 0x77, 0x75, 0x05, 0xF0, 0xB7, 0x77, 0x75, 0x05, 0xF0, 0xB7, 0x77,
  0x75, 0x05, 0xF0, 0xB7, 0x77, 0x75, 0x05, 0xF0, 0xB7, 0x77, 0x75, 0x05, 0xF0, 0xB7, 0x77, 0x75,
  0x05, 0xF0, 0xB7, 0x77, 0x75, 0x05, 0xF0, 0xB7, 0x77, 0x75, 0x05, 0xF0, 0xB7, 0x77, 0x75, 0x05,
  0xF0, 0xB7, 0x77, 0x75, 0x05, 0xF0, 0xB7, 0x77, 0x75, 0x05, 0xF0, 0xB7, 0x77, 0x75, 0x05, 0xF0,
  0xB7, 0x77, 0x75, 0x05, 0xF0, 0xB7, 0x77, 0x75, 0x05, 0xF0, 0xB7, 0x77, 0x75, 0x05, 0xF0, 0xB7,
  0x77, 0x75, 0x05, 0xF0, 0xB7, 0x77, 0x75, 0x05, 0xF0, 0xB7, 0x77, 0x75, 0x05, 0xF0, 0xB7, 0x77,
  0x75, 0x05, 0xF0, 0xB7, 0x77, 0x75, 0x05, 0xF0, 0xB7, 0x77, 0x75, 0x05, 0xF0, 0xB7, 0x77, 0x75,
  0x05, 0xF0, 0xB7, 0x77, 0x75, 0x05, 0xF0, 0xB7, 0x77, 0x75, 0x05, 0xF0, 0xB7, 0x77, 0x75, 0x05,
  0xF0, 0xB7, 0x77, 0x75, 0x05, 0xF0, 0xB7, 0x77, 0x75, 0x05, 0xF0, 0xB7, 0x77, 0x75, 0x05, 0xF0,
  0xB7, 0x77, 0x75, 0x05, 0xF0, 0xB7, 0x77, 0x75, 0x05, 0xF0, 0xB7, 0x77, 0x75, 0x05, 0xF0, 0xB7,
  0x77, 0x75, 0x05, 0xF0, 0xB7, 0x77, 0x75, 0x05, 0xF0, 0xB7, 0x77, 0x75, 0x05, 0xF0, 0xB7, 0x77,
  0x75, 0x05, 0xF0, 0xB7, 0x77, 0x75, 0x05, 0xF0, 0xB7, 0x77, 0x75, 0x05, 0xF0, 0xB7, 0x77, 0x75,
  0x05, 0xF0, 0xB7, 0x77, 0x75, 0x05, 0xF0, 0xB7, 0x77, 0x75, 0x05, 0xF0, 0xB7, 0x77, 0x75, 0x06,
  0xF0, 0xB7, 0x77, 0x75, 0x07, 0xF0, 0xA7, 0x77, 0x75, 0x09, 0xF0, 0xA7, 0x77, 0x75, 0x0C, 0xF0,
  0x87, 0x77, 0x75, 0x0E, 0xF0, 0x67, 0x77, 0x74, 0x04, 0xF9, 0x03, 0x77, 0x77, 0x40, 0xBF, 0x97,
  0x77, 0x74, 0x04, 0xF9, 0x0B, 0x77, 0x77, 0x30, 0x20, 0xEF, 0x90, 0x57, 0x50, 0x30, 0x17, 0x72,
  0x03, 0x0E, 0xF9, 0x0D, 0x76, 0x84, 0x9F, 0xC8, 0x51, 0x73, 0x04, 0x0B, 0xFB, 0x05, 0x76, 0x09,
  0xD8, 0x7E, 0xCA, 0x99, 0x89, 0xAC, 0xFD, 0x0A, 0x77, 0x09, 0xFF, 0xFC, 0x0C, 0x77, 0x10, 0x9F,
  0xFF, 0xB0, 0xC0, 0x17, 0x71, 0x09, 0xFF, 0xFA, 0x0A, 0x77, 0x30, 0x9F, 0xFF, 0x0D, 0x04, 0x77,
  0x40, 0x50, 0xCF, 0xFC, 0x0B, 0x05, 0x77, 0x72, 0x86, 0x25, 0x79, 0xBC, 0xDE, 0xB8, 0x3E, 0xCA,
  0x84, 0x77, 0x72,
  // "Ķ" (U+0136)
  0x0A, 0xF0, 0x67, 0x77, 0x20, 0x10, 0xDF, 0x98, 0x15, 0x0A, 0xF0, 0x67, 0x77, 0x20, 0xAF, 0x90,
  0x92, 0x0A, 0xF0, 0x67, 0x77, 0x10, 0x6F, 0x90, 0xC3, 0x0A, 0xF0, 0x67, 0x77, 0x03, 0xF9, 0x0E,
  0x02, 0x30, 0xAF, 0x06, 0x77, 0x70, 0xDF, 0x90, 0x64, 0x0A, 0xF0, 0x67, 0x76, 0x0A, 0xF9, 0x0A,
  0x50, 0xAF, 0x06, 0x77, 0x50, 0x6F, 0x90, 0xD0, 0x15, 0x0A, 0xF0, 0x67, 0x74, 0x02, 0x0E, 0xF9,
  0x03, 0x60, 0xAF, 0x06, 0x77, 0x40, 0xDF, 0x90, 0x77, 0x0A, 0xF0, 0x67, 0x73, 0x09, 0xF9, 0x0B,
  0x71, 0x0A, 0xF0, 0x67, 0x72, 0x05, 0xF9, 0x0E, 0x01, 0x71, 0x0A, 0xF0, 0x67, 0x71, 0x02, 0x0E,
  0xF9, 0x04, 0x72, 0x0A, 0xF0, 0x67, 0x71, 0x0C, 0xF9, 0x08, 0x73, 0x0A, 0xF0, 0x67, 0x70, 0x9F,
  0x90, 0xC7, 0x40, 0xAF, 0x06, 0x76, 0x05, 0xF9, 0x0E, 0x02, 0x74, 0x0A, 0xF0, 0x67, 0x50, 0x20,
  0xEF, 0x90, 0x57, 0x50, 0xAF, 0x06, 0x75, 0x0C, 0xF9, 0x09, 0x76, 0x0A, 0xF0, 0x67, 0x40, 0x8F,
  0x90, 0xD7, 0x70, 0xAF, 0x06, 0x73, 0x04, 0xFA, 0x03, 0x77, 0x0A, 0xF0, 0x67, 0x20, 0x10, 0xEF,
  0x90, 0x77, 0x71, 0x0A, 0xF0, 0x67, 0x20, 0xBF, 0x90, 0xB7, 0x72, 0x0A, 0xF0, 0x67, 0x10, 0x8F,
  0x90, 0xE0, 0x17, 0x72, 0x0A, 0xF0, 0x67, 0x04, 0xFA, 0x04, 0x77, 0x30, 0xAF, 0x06, 0x60, 0x10,
  0xEF, 0x90, 0x87, 0x74, 0x0A, 0xF0, 0x66, 0x0B, 0xF9, 0x0C, 0x77, 0x50, 0xAF, 0x06, 0x50, 0x7F,
  0x90, 0xE0, 0x27, 0x75, 0x0A, 0xF0, 0x64, 0x03, 0xFA, 0x05, 0x77, 0x60, 0xAF, 0x06, 0x40, 0xDF,
  0x90, 0x97, 0x77, 0x0A, 0xF0, 0x63, 0x08, 0xF9, 0x0D, 0x77, 0x71, 0x0A, 0xF0, 0x62, 0x03, 0xFA,
  0x05, 0x77, 0x71, 0x0A, 0xF0, 0x62, 0x0C, 0xFA, 0x0C, 0x77, 0x71, 0x0A, 0xF8, 0x16, 0x07, 0xFC,
  0x07, 0x77, 0x70, 0xAF, 0x06, 0x02, 0xFE, 0x02, 0x77, 0x60, 0xAF, 0x06, 0x0B, 0xFE, 0x0C, 0x77,
  0x60, 0xAF, 0x0C, 0xFF, 0x90, 0x67, 0x75, 0x0A, 0xFE, 0x81, 0xE3, 0xDF, 0x0E, 0x02, 0x77, 0x40,
  0xAF, 0xE8, 0x13, 0x04, 0xF9, 0x0B, 0x77, 0x40, 0xAF, 0xD0, 0x53, 0x09, 0xF9, 0x05, 0x77, 0x30,
  0xAF, 0xC0, 0x64, 0x01, 0x0E, 0xF0, 0xE0, 0x17, 0x72, 0x0A, 0xFB, 0x08, 0x60, 0x5F, 0x90, 0xA7,
  0x72, 0x0A, 0xFA, 0x0A, 0x71, 0x0B, 0xF9, 0x05, 0x77, 0x10, 0xAF, 0x90, 0xB7, 0x20, 0x10, 0xEF,
  0x0D, 0x01, 0x77, 0x0A, 0xF0, 0xC0, 0x17, 0x30, 0x6F, 0x90, 0x97, 0x70, 0xAF, 0x06, 0x75, 0x0C,
  0xF9, 0x04, 0x76, 0x0A, 0xF0, 0x67, 0x50, 0x2F, 0x90, 0xD7, 0x60, 0xAF, 0x06, 0x76, 0x08, 0xF9,
  0x08, 0x75, 0x0A, 0xF0, 0x67, 0x70, 0xDF, 0x90, 0x37, 0x40, 0xAF, 0x06, 0x77, 0x04, 0xF9, 0x0C,
  0x74, 0x0A, 0xF0, 0x67, 0x71, 0x09, 0xF9, 0x07, 0x73, 0x0A, 0xF0, 0x67, 0x71, 0x01, 0x0E, 0xF9,
  0x02, 0x72, 0x0A, 0xF0, 0x67, 0x72, 0x05, 0xF9, 0x0B, 0x72, 0x0A, 0xF0, 0x67, 0x73, 0x0B, 0xF9,
  0x06, 0x71, 0x0A, 0xF0, 0x67, 0x73, 0x01, 0x0E, 0xF0, 0xE0, 0x17, 0x0A, 0xF0, 0x67, 0x74, 0x06,
  0xF9, 0x0B, 0x70, 0xAF, 0x06, 0x77, 0x50, 0xCF, 0x90, 0x56, 0x0A, 0xF0, 0x67, 0x75, 0x02, 0xF9,
  0x0E, 0x01, 0x50, 0xAF, 0x06, 0x77, 0x60, 0x8F, 0x90, 0xA5, 0x0A, 0xF0, 0x67, 0x77, 0x0D, 0xF9,
  0x04, 0x40, 0xAF, 0x06, 0x77, 0x70, 0x4F, 0x90, 0xD4, 0x0A, 0xF0, 0x67, 0x77, 0x10, 0x9F, 0x90,
  0x93, 0x0A, 0xF0, 0x67, 0x77, 0x10, 0x10, 0xEF, 0x90, 0x32, 0x0A, 0xF0, 0x67, 0x77, 0x20, 0x5F,
  0x90, 0xD2, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0xBF, 0x98, 0x18, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x10,
  0xEF, 0x90, 0x38, 0x0C, 0xA6, 0x00, 0xDF, 0x80, 0xC0, 0x0F, 0x0B, 0x77, 0x77, 0x70, 0x2F, 0x06,
  0x77, 0x77, 0x70, 0x6F, 0x01, 0x77, 0x77, 0x70, 0x9E, 0x09, 0x80, 0xC0, 0x00, 0xEE, 0x02, 0x77,
  0x77, 0x70, 0x3E, 0x0A, 0x80, 0xC0, 0x00, 0x7E, 0x02, 0x80, 0xC0, 0x00, 0xCD, 0x08, 0x80, 0xC0,
  0x00, 0x1D, 0x0E, 0x01, 0x80, 0xC0, 0x00, 0x7D, 0x05, 0x80, 0xC1, 0x00, 0xCC, 0x0B, 0x80, 0xC1,
  0x00, 0x4C, 0x0E, 0x01, 0x80, 0xC1, 0x00, 0x7C, 0x03, 0x77, 0x73,
  // "ķ" (U+0137)
  0x08, 0xF0, 0x87, 0x77, 0x75, 0x08, 0xF0, 0x87, 0x77, 0x75, 0x08, 0xF0, 0x87, 0x77, 0x75, 0x08,
  0xF0, 0x87, 0x77, 0x75, 0x08, 0xF0, 0x87, 0x77, 0x75, 0x08, 0xF0, 0x87, 0x77, 0x75, 0x08, 0xF0,
  0x87, 0x77, 0x75, 0x08, 0xF0, 0x87, 0x77, 0x75, 0x08, 0xF0, 0x87, 0x77, 0x75, 0x08, 0xF0, 0x87,
  0x77, 0x75, 0x08, 0xF0, 0x87, 0x77, 0x75, 0x08, 0xF0, 0x87, 0x77, 0x75, 0x08, 0xF0, 0x87, 0x77,
  0x75, 0x08, 0xF0, 0x87, 0x77, 0x75, 0x08, 0xF0, 0x87, 0x77, 0x75, 0x08, 0xF0, 0x87, 0x77, 0x75,
  0x08, 0xF0, 0x87, 0x77, 0x75, 0x08, 0xF0, 0x87, 0x77, 0x75, 0x08, 0xF0, 0x87, 0x77, 0x75, 0x08,
  0xF0, 0x87, 0x77, 0x75, 0x08, 0xF0, 0x87, 0x77, 0x02, 0x0E, 0xF9, 0x81, 0x90, 0x8F, 0x08, 0x77,
  0x60, 0x20, 0xEF, 0x90, 0xA2, 0x08, 0xF0, 0x87, 0x75, 0x01, 0x0D, 0xF9, 0x0B, 0x30, 0x8F, 0x08,
  0x77, 0x50, 0xCF, 0x90, 0xC4, 0x08, 0xF0, 0x87, 0x74, 0x0B, 0xF9, 0x0D, 0x01, 0x40, 0x8F, 0x08,
  0x77, 0x30, 0x9F, 0x90, 0xD0, 0x25, 0x08, 0xF0, 0x87, 0x72, 0x08, 0xF9, 0x0E, 0x02, 0x60, 0x8F,
  0x08, 0x77, 0x10, 0x6F, 0xA0, 0x37, 0x08, 0xF0, 0x87, 0x70, 0x5F, 0xA0, 0x47, 0x10, 0x8F, 0x08,
  0x76, 0x03, 0xFA, 0x06, 0x72, 0x08, 0xF0, 0x87, 0x50, 0x20, 0xEF, 0x90, 0x77, 0x30, 0x8F, 0x08,
  0x74, 0x01, 0x0D, 0xF9, 0x08, 0x74, 0x08, 0xF0, 0x87, 0x30, 0x10, 0xCF, 0x90, 0xA7, 0x50, 0x8F,
  0x08, 0x73, 0x0B, 0xF9, 0x0B, 0x76, 0x08, 0xF0, 0x87, 0x20, 0xAF, 0x90, 0xC7, 0x70, 0x8F, 0x07,
  0x71, 0x09, 0xF9, 0x0D, 0x01, 0x77, 0x08, 0xF0, 0x77, 0x07, 0xF9, 0x0D, 0x01, 0x77, 0x10, 0x8F,
  0x06, 0x60, 0x6F, 0x90, 0xE0, 0x27, 0x72, 0x08, 0xF0, 0x55, 0x04, 0xF9, 0x0E, 0x03, 0x77, 0x30,
  0x8F, 0x04, 0x40, 0x20, 0xEF, 0x90, 0x47, 0x74, 0x08, 0xF0, 0x33, 0x01, 0x0D, 0xF9, 0x05, 0x77,
  0x50, 0x8F, 0x03, 0x30, 0xCF, 0xA0, 0x37, 0x75, 0x08, 0xF0, 0x22, 0x0A, 0xFB, 0x0D, 0x01, 0x77,
  0x40, 0x8F, 0x81, 0x10, 0x8F, 0xD0, 0xB7, 0x74, 0x08, 0xF1, 0x05, 0xFF, 0x07, 0x77, 0x30, 0x8F,
  0x02, 0x0E, 0xE0, 0xEF, 0x90, 0x47, 0x72, 0x08, 0xF0, 0xDE, 0x81, 0x91, 0xDF, 0x0E, 0x01, 0x77,
  0x10, 0x8F, 0xE0, 0x92, 0x03, 0xF9, 0x0B, 0x77, 0x10, 0x8F, 0xD0, 0x84, 0x07, 0xF9, 0x08, 0x77,
  0x08, 0xFC, 0x07, 0x60, 0xBF, 0x90, 0x47, 0x60, 0x8F, 0xB0, 0x67, 0x01, 0x0E, 0xF0, 0xE0, 0x17,
  0x50, 0x8F, 0xA0, 0x67, 0x20, 0x4F, 0x90, 0xC7, 0x50, 0x8F, 0x90, 0x57, 0x40, 0x8F, 0x90, 0x87,
  0x40, 0x8F, 0x08, 0x76, 0x0B, 0xF9, 0x04, 0x73, 0x08, 0xF0, 0x87, 0x60, 0x10, 0xEF, 0x0E, 0x02,
  0x72, 0x08, 0xF0, 0x87, 0x70, 0x4F, 0x90, 0xC7, 0x20, 0x8F, 0x08, 0x77, 0x10, 0x8F, 0x90, 0x97,
  0x10, 0x8F, 0x08, 0x77, 0x20, 0xCF, 0x90, 0x57, 0x08, 0xF0, 0x87, 0x72, 0x02, 0x0E, 0xF0, 0xE0,
  0x26, 0x08, 0xF0, 0x87, 0x73, 0x05, 0xF9, 0x0C, 0x60, 0x8F, 0x08, 0x77, 0x40, 0x9F, 0x90, 0x95,
  0x08, 0xF0, 0x87, 0x75, 0x0C, 0xF9, 0x05, 0x40, 0x8F, 0x08, 0x77, 0x50, 0x20, 0xEF, 0x0E, 0x02,
  0x30, 0x8F, 0x08, 0x77, 0x60, 0x6F, 0x90, 0xD3, 0x08, 0xF0, 0x87, 0x77, 0x0A, 0xF9, 0x09, 0x20,
  0x8F, 0x08, 0x77, 0x71, 0x0D, 0xF9, 0x81, 0x60, 0x8F, 0x08, 0x77, 0x71, 0x03, 0xFA, 0x03, 0x08,
  0xF0, 0x87, 0x77, 0x20, 0x6F, 0x90, 0xD8, 0x0C, 0x92, 0x00, 0xDF, 0x77, 0x77, 0x6F, 0x0B, 0x77,
  0x77, 0x50, 0x2F, 0x06, 0x77, 0x77, 0x50, 0x6F, 0x01, 0x77, 0x77, 0x50, 0x9E, 0x09, 0x77, 0x77,
  0x60, 0xEE, 0x02, 0x77, 0x77, 0x50, 0x3E, 0x0A, 0x77, 0x77, 0x60, 0x7E, 0x02, 0x77, 0x77, 0x60,
  0xCD, 0x08, 0x77, 0x77, 0x60, 0x1D, 0x0E, 0x01, 0x77, 0x77, 0x60, 0x7D, 0x05, 0x77, 0x77, 0x70,
  0xCC, 0x0B, 0x77, 0x77, 0x70, 0x4C, 0x0E, 0x01, 0x77, 0x77, 0x70, 0x7C, 0x03, 0x77, 0x71,
  // "ĸ" (U+0138)
  0x08, 0xF0, 0x87, 0x77, 0x02, 0x0E, 0xF9, 0x81, 0x90, 0x8F, 0x08, 0x77, 0x60, 0x20, 0xEF, 0x90,
  0xA2, 0x08, 0xF0, 0x87, 0x75, 0x01, 0x0D, 0xF9, 0x0B, 0x30, 0x8F, 0x08, 0x77, 0x50, 0xCF, 0x90,
  0xC4, 0x08, 0xF0, 0x87, 0x74, 0x0B, 0xF9, 0x0D, 0x01, 0x40, 0x8F, 0x08, 0x77, 0x30, 0x9F, 0x90,
  0xD0, 0x25, 0x08, 0xF0, 0x87, 0x72, 0x08, 0xF9, 0x0E, 0x02, 0x60, 0x8F, 0x08, 0x77, 0x10, 0x6F,
  0xA0, 0x37, 0x08, 0xF0, 0x87, 0x70, 0x5F, 0xA0, 0x47, 0x10, 0x8F, 0x08, 0x76, 0x03, 0xFA, 0x06,
  0x72, 0x08, 0xF0, 0x87, 0x50, 0x20, 0xEF, 0x90, 0x77, 0x30, 0x8F, 0x08, 0x74, 0x01, 0x0D, 0xF9,
  0x08, 0x74, 0x08, 0xF0, 0x87, 0x30, 0x10, 0xCF, 0x90, 0xA7, 0x50, 0x8F, 0x08, 0x73, 0x0B, 0xF9,
  0x0B, 0x76, 0x08, 0xF0, 0x87, 0x20, 0xAF, 0x90, 0xC7, 0x70, 0x8F, 0x07, 0x71, 0x09, 0xF9, 0x0D,
  0x01, 0x77, 0x08, 0xF0, 0x77, 0x07, 0xF9, 0x0D, 0x01, 0x77, 0x10, 0x8F, 0x06, 0x60, 0x6F, 0x90,
  0xE0, 0x27, 0x72, 0x08, 0xF0, 0x55, 0x04, 0xF9, 0x0E, 0x03, 0x77, 0x30, 0x8F, 0x04, 0x40, 0x30,
  0xEF, 0x90, 0x47, 0x74, 0x08, 0xF0, 0x33, 0x02, 0x0E, 0xF9, 0x05, 0x77, 0x50, 0x8F, 0x03, 0x30,
  0xCF, 0xA0, 0x37, 0x75, 0x08, 0xF0, 0x22, 0x0B, 0xFB, 0x0D, 0x01, 0x77, 0x40, 0x8F, 0x81, 0x10,
  0x8F, 0xD0, 0xB7, 0x74, 0x08, 0xF1, 0x05, 0xFF, 0x07, 0x77, 0x30, 0x8F, 0x02, 0x0E, 0xE0, 0xEF,
  0x90, 0x47, 0x72, 0x08, 0xF0, 0xDE, 0x81, 0x91, 0xDF, 0x0E, 0x01, 0x77, 0x10, 0x8F, 0xE0, 0x92,
  0x03, 0xF9, 0x0B, 0x77, 0x10, 0x8F, 0xD0, 0x84, 0x07, 0xF9, 0x08, 0x77, 0x08, 0xFC, 0x07, 0x60,
  0xBF, 0x90, 0x47, 0x60, 0x8F, 0xB0, 0x67, 0x01, 0x0E, 0xF0, 0xE0, 0x17, 0x50, 0x8F, 0xA0, 0x67,
  0x20, 0x4F, 0x90, 0xC7, 0x50, 0x8F, 0x90, 0x57, 0x40, 0x8F, 0x90, 0x87, 0x40, 0x8F, 0x08, 0x76,
  0x0B, 0xF9, 0x04, 0x73, 0x08, 0xF0, 0x87, 0x60, 0x10, 0xEF, 0x0E, 0x02, 0x72, 0x08, 0xF0, 0x87,
  0x70, 0x4F, 0x90, 0xC7, 0x20, 0x8F, 0x08, 0x77, 0x10, 0x8F, 0x90, 0x97, 0x10, 0x8F, 0x08, 0x77,
  0x20, 0xCF, 0x90, 0x57, 0x08, 0xF0, 0x87, 0x72, 0x02, 0x0E, 0xF0, 0xE0, 0x26, 0x08, 0xF0, 0x87,
  0x73, 0x05, 0xF9, 0x0C, 0x60, 0x8F, 0x08, 0x77, 0x40, 0x9F, 0x90, 0x95, 0x08, 0xF0, 0x87, 0x75,
  0x0C, 0xF9, 0x05, 0x40, 0x8F, 0x08, 0x77, 0x50, 0x20, 0xEF, 0x0E, 0x02, 0x30, 0x8F, 0x08, 0x77,
  0x60, 0x6F, 0x90, 0xD3, 0x08, 0xF0, 0x87, 0x77, 0x0A, 0xF9, 0x09, 0x20, 0x8F, 0x08, 0x77, 0x71,
  0x0D, 0xF9, 0x81, 0x60, 0x8F, 0x08, 0x77, 0x71, 0x03, 0xFA, 0x03, 0x08, 0xF0, 0x87, 0x77, 0x20,
  0x6F, 0x90, 0xD0,
  // "Ĺ" (U+0139)
  0x71, 0x03, 0x80, 0x57, 0x01, 0x77, 0x75, 0x0C, 0xFA, 0x02, 0x77, 0x74, 0x05, 0xFA, 0x08, 0x77,
  0x75, 0x0D, 0xF9, 0x0B, 0x77, 0x75, 0x08, 0xF9, 0x0D, 0x01, 0x77, 0x74, 0x02, 0xF9, 0x0E, 0x02,
  0x77, 0x75, 0x0C, 0xF0, 0xE0, 0x37, 0x77, 0x50, 0x6F, 0x90, 0x47, 0x77, 0x50, 0x10, 0xEF, 0x05,
  0x77, 0x76, 0x0B, 0xF0, 0x57, 0x77, 0x60, 0x5F, 0x06, 0x77, 0x76, 0x01, 0x0E, 0xE0, 0x57, 0x77,
  0x70, 0xBE, 0x05, 0x77, 0x77, 0x08, 0xD0, 0xE0, 0x47, 0x77, 0x71, 0x0D, 0xC0, 0xC0, 0x28, 0x0B,
  0xF0, 0x00, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A,
  0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77,
  0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF,
  0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77,
  0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0,
  0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77,
  0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07,
  0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70,
  0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77,
  0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A,
  0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77,
  0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF,
  0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77,
  0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0,
  0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77,
  0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07,
  0x77, 0x77, 0x0A, 0xFF, 0xFF, 0xF0, 0x50, 0xAF, 0xFF, 0xFF, 0x05, 0x0A, 0xFF, 0xFF, 0xF0, 0x50,
  0xAF, 0xFF, 0xFF, 0x05, 0x0A, 0xFF, 0xFF, 0xF0, 0x50, 0xAF, 0xFF, 0xFF, 0x05, 0x0A, 0xFF, 0xFF,
  0xF0, 0x50,
  // "ĺ" (U+013A)
  0x77, 0x73, 0x03, 0x80, 0x57, 0x01, 0x77, 0x77, 0x30, 0xCF, 0xA0, 0x27, 0x77, 0x72, 0x05, 0xFA,
  0x08, 0x77, 0x77, 0x30, 0xDF, 0x90, 0xB7, 0x77, 0x73, 0x08, 0xF9, 0x0D, 0x01, 0x77, 0x77, 0x20,
  0x2F, 0x90, 0xE0, 0x27, 0x77, 0x73, 0x0C, 0xF0, 0xE0, 0x37, 0x77, 0x73, 0x06, 0xF9, 0x04, 0x77,
  0x77, 0x30, 0x10, 0xEF, 0x05, 0x77, 0x77, 0x40, 0xBF, 0x05, 0x77, 0x77, 0x40, 0x5F, 0x06, 0x77,
  0x77, 0x40, 0x10, 0xEE, 0x05, 0x77, 0x77, 0x50, 0xBE, 0x05, 0x77, 0x77, 0x50, 0x8D, 0x0E, 0x04,
  0x77, 0x77, 0x60, 0xDC, 0x0C, 0x02, 0x80, 0xC9, 0x30, 0x04, 0xFF, 0xFB, 0x0E, 0x77, 0x20, 0x4F,
  0xFF, 0xB0, 0xE7, 0x72, 0x04, 0xFF, 0xFB, 0x0E, 0x77, 0x20, 0x4F, 0xFF, 0xB0, 0xE7, 0x72, 0x04,
  0xFF, 0xFB, 0x0E, 0x77, 0x20, 0x4F, 0xFF, 0xB0, 0xE7, 0x72, 0x02, 0x80, 0x94, 0x80, 0x9F, 0x0E,
  0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77,
  0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77,
  0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50,
  0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F,
  0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E,
  0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77,
  0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77,
  0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50,
  0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F,
  0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E,
  0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77,
  0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77,
  0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50,
  0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F,
  0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E,
  0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77,
  0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x75,
  0x86, 0x12, 0x34, 0x57, 0x8A, 0xF9, 0x85, 0x87, 0x65, 0x32, 0x17, 0x28, 0x74, 0x67, 0x89, 0xBC,
  0xDE, 0xFF, 0xFC, 0x87, 0xEC, 0xBA, 0x97, 0x63, 0xC8, 0x0C, 0x4F, 0x09, 0x0C, 0x80, 0xC4, 0xF0,
  0x90, 0xC8, 0x0C, 0x4F, 0x09, 0x0C, 0x80, 0xC4, 0xF0, 0x90, 0xC8, 0x0C, 0x4F, 0x09,
  // "Ļ" (U+013B)
  0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07,
  0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70,
  0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77,
  0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A,
  0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77,
  0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF,
  0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77,
  0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0,
  0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77,
  0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07,
  0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70,
  0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77,
  0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A,
  0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77,
  0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF,
  0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77,
  0x70, 0xAF, 0xFF, 0xFF, 0x05, 0x0A, 0xFF, 0xFF, 0xF0, 0x50, 0xAF, 0xFF, 0xFF, 0x05, 0x0A, 0xFF,
  0xFF, 0xF0, 0x50, 0xAF, 0xFF, 0xFF, 0x05, 0x0A, 0xFF, 0xFF, 0xF0, 0x50, 0xAF, 0xFF, 0xFF, 0x05,
  0x80, 0xBD, 0x20, 0x0D, 0xF7, 0x77, 0x71, 0xF0, 0xB7, 0x77, 0x70, 0x2F, 0x06, 0x77, 0x77, 0x06,
  0xF0, 0x17, 0x77, 0x70, 0x9E, 0x09, 0x77, 0x77, 0x10, 0xEE, 0x02, 0x77, 0x77, 0x03, 0xE0, 0xA7,
  0x77, 0x71, 0x07, 0xE0, 0x27, 0x77, 0x71, 0x0C, 0xD0, 0x87, 0x77, 0x71, 0x01, 0xD0, 0xE0, 0x17,
  0x77, 0x71, 0x07, 0xD0, 0x57, 0x77, 0x72, 0x0C, 0xC0, 0xB7, 0x77, 0x72, 0x04, 0xC0, 0xE0, 0x17,
  0x77, 0x72, 0x07, 0xC0, 0x37, 0x75,
  // "ļ" (U+013C)
  0x04, 0xFF, 0xFB, 0x0E, 0x77, 0x20, 0x4F, 0xFF, 0xB0, 0xE7, 0x72, 0x04, 0xFF, 0xFB, 0x0E, 0x77,
  0x20, 0x4F, 0xFF, 0xB0, 0xE7, 0x72, 0x04, 0xFF, 0xFB, 0x0E, 0x77, 0x20, 0x4F, 0xFF, 0xB0, 0xE7,
  0x72, 0x02, 0x80, 0x94, 0x80, 0x9F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F,
  0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E,
  0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77,
  0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77,
  0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50,
  0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F,
  0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E,
  0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77,
  0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77,
  0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50,
  0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F,
  0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E,
  0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77,
  0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77,
  0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50,
  0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F,
  0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E,
  0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x75, 0x86, 0x12, 0x34, 0x57, 0x8A, 0xF9, 0x85, 0x87, 0x65,
  0x32, 0x17, 0x28, 0x74, 0x67, 0x89, 0xBC, 0xDE, 0xFF, 0xFC, 0x87, 0xEC, 0xBA, 0x97, 0x63, 0xC8,
  0x0C, 0x4F, 0x09, 0x0C, 0x80, 0xC4, 0xF0, 0x90, 0xC8, 0x0C, 0x4F, 0x09, 0x0C, 0x80, 0xC4, 0xF0,
  0x90, 0xC8, 0x0C, 0x4F, 0x09, 0x80, 0xC9, 0x20, 0x0D, 0xF7, 0x77, 0x76, 0xF0, 0xB7, 0x77, 0x75,
  0x02, 0xF0, 0x67, 0x77, 0x75, 0x06, 0xF0, 0x17, 0x77, 0x75, 0x09, 0xE0, 0x97, 0x77, 0x76, 0x0E,
  0xE0, 0x27, 0x77, 0x75, 0x03, 0xE0, 0xA7, 0x77, 0x76, 0x07, 0xE0, 0x27, 0x77, 0x76, 0x0C, 0xD0,
  0x87, 0x77, 0x76, 0x01, 0xD0, 0xE0, 0x17, 0x77, 0x76, 0x07, 0xD0, 0x57, 0x77, 0x77, 0x0C, 0xC0,
  0xB7, 0x77, 0x77, 0x04, 0xC0, 0xE0, 0x17, 0x77, 0x77, 0x07, 0xC0, 0x37, 0x77, 0x10,
  // "Ľ" (U+013D)
  0x0A, 0xF0, 0x77, 0x74, 0x08, 0xF8, 0x15, 0x0A, 0xF0, 0x77, 0x74, 0x0A, 0xF8, 0x11, 0x0A, 0xF0,
  0x77, 0x74, 0x0C, 0xE0, 0xC2, 0x0A, 0xF0, 0x77, 0x74, 0xF0, 0x62, 0x0A, 0xF0, 0x77, 0x73, 0x03,
  0xF0, 0x12, 0x0A, 0xF0, 0x77, 0x73, 0x06, 0xE0, 0x93, 0x0A, 0xF0, 0x77, 0x73, 0x0A, 0xE0, 0x23,
  0x0A, 0xF0, 0x77, 0x73, 0x0D, 0xD0, 0xA4, 0x0A, 0xF0, 0x77, 0x72, 0x01, 0xE0, 0x24, 0x0A, 0xF0,
  0x77, 0x72, 0x05, 0xD0, 0x95, 0x0A, 0xF0, 0x77, 0x72, 0x0A, 0xC0, 0xE0, 0x15, 0x0A, 0xF0, 0x77,
  0x72, 0x0E, 0xC0, 0x76, 0x0A, 0xF0, 0x77, 0x71, 0x04, 0xC0, 0xC7, 0x0A, 0xF0, 0x77, 0x71, 0x06,
  0xC0, 0x37, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70,
  0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77,
  0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A,
  0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77,
  0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF,
  0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77,
  0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0,
  0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77,
  0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07,
  0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70,
  0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77,
  0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A,
  0xF0, 0x77, 0x77, 0x70, 0xAF, 0xFF, 0xFF, 0x05, 0x0A, 0xFF, 0xFF, 0xF0, 0x50, 0xAF, 0xFF, 0xFF,
  0x05, 0x0A, 0xFF, 0xFF, 0xF0, 0x50, 0xAF, 0xFF, 0xFF, 0x05, 0x0A, 0xFF, 0xFF, 0xF0, 0x50, 0xAF,
  0xFF, 0xFF, 0x05,
  // "ľ" (U+013E)
  0x04, 0xFF, 0xFB, 0x0E, 0x72, 0x03, 0xF0, 0xA0, 0x4F, 0xFF, 0xB0, 0xE7, 0x20, 0x5F, 0x06, 0x04,
  0xFF, 0xFB, 0x0E, 0x72, 0x08, 0xF0, 0x20, 0x4F, 0xFF, 0xB0, 0xE7, 0x20, 0xAE, 0x81, 0xB0, 0x4F,
  0xFF, 0xB0, 0xE7, 0x20, 0xDE, 0x81, 0x50, 0x4F, 0xFF, 0xB0, 0xE7, 0x10, 0x1E, 0x0D, 0x20, 0x28,
  0x09, 0x48, 0x09, 0xF0, 0xE7, 0x10, 0x5E, 0x06, 0x77, 0x50, 0x2F, 0x0E, 0x71, 0x09, 0xD0, 0xE7,
  0x76, 0x02, 0xF0, 0xE7, 0x10, 0xCD, 0x06, 0x77, 0x60, 0x2F, 0x0E, 0x70, 0x1D, 0x0D, 0x77, 0x70,
  0x2F, 0x0E, 0x70, 0x5D, 0x05, 0x77, 0x70, 0x2F, 0x0E, 0x70, 0x9C, 0x0C, 0x77, 0x71, 0x02, 0xF0,
  0xE7, 0x0E, 0xC0, 0x37, 0x77, 0x10, 0x2F, 0x0E, 0x60, 0x1C, 0x08, 0x77, 0x72, 0x02, 0xF0, 0xE7,
  0x77, 0x77, 0x02, 0xF0, 0xE7, 0x77, 0x77, 0x02, 0xF0, 0xE7, 0x77, 0x77, 0x02, 0xF0, 0xE7, 0x77,
  0x77, 0x02, 0xF0, 0xE7, 0x77, 0x77, 0x02, 0xF0, 0xE7, 0x77, 0x77, 0x02, 0xF0, 0xE7, 0x77, 0x77,
  0x02, 0xF0, 0xE7, 0x77, 0x77, 0x02, 0xF0, 0xE7, 0x77, 0x77, 0x02, 0xF0, 0xE7, 0x77, 0x77, 0x02,
  0xF0, 0xE7, 0x77, 0x77, 0x02, 0xF0, 0xE7, 0x77, 0x77, 0x02, 0xF0, 0xE7, 0x77, 0x77, 0x02, 0xF0,
  0xE7, 0x77, 0x77, 0x02, 0xF0, 0xE7, 0x77, 0x77, 0x02, 0xF0, 0xE7, 0x77, 0x77, 0x02, 0xF0, 0xE7,
  0x77, 0x77, 0x02, 0xF0, 0xE7, 0x77, 0x77, 0x02, 0xF0, 0xE7, 0x77, 0x77, 0x02, 0xF0, 0xE7, 0x77,
  0x77, 0x02, 0xF0, 0xE7, 0x77, 0x77, 0x02, 0xF0, 0xE7, 0x77, 0x77, 0x02, 0xF0, 0xE7, 0x77, 0x77,
  0x02, 0xF0, 0xE7, 0x77, 0x77, 0x02, 0xF0, 0xE7, 0x77, 0x77, 0x02, 0xF0, 0xE7, 0x77, 0x77, 0x02,
  0xF0, 0xE7, 0x77, 0x77, 0x02, 0xF0, 0xE7, 0x77, 0x77, 0x02, 0xF0, 0xE7, 0x77, 0x77, 0x02, 0xF0,
  0xE7, 0x77, 0x77, 0x02, 0xF0, 0xE7, 0x77, 0x77, 0x02, 0xF0, 0xE7, 0x77, 0x77, 0x02, 0xF0, 0xE7,
  0x77, 0x77, 0x02, 0xF0, 0xE7, 0x77, 0x77, 0x02, 0xF0, 0xE7, 0x77, 0x77, 0x02, 0xF0, 0xE7, 0x77,
  0x77, 0x02, 0xF0, 0xE7, 0x77, 0x77, 0x02, 0xF0, 0xE7, 0x77, 0x77, 0x02, 0xF0, 0xE7, 0x77, 0x77,
  0x02, 0xF0, 0xE7, 0x77, 0x77, 0x02, 0xF0, 0xE7, 0x77, 0x77, 0x02, 0xF0, 0xE7, 0x77, 0x77, 0x02,
  0xF0, 0xE7, 0x77, 0x77, 0x02, 0xF0, 0xE7, 0x77, 0x77, 0x02, 0xF0, 0xE7, 0x77, 0x77, 0x02, 0xF0,
  0xE7, 0x77, 0x77, 0x02, 0xF0, 0xE7, 0x77, 0x68, 0x71, 0x23, 0x56, 0x78, 0x9B, 0xF9, 0x86, 0xA9,
  0x86, 0x54, 0x21, 0x73, 0x86, 0x57, 0x8A, 0xBC, 0xDE, 0xFF, 0xFE, 0x85, 0xED, 0xBA, 0x97, 0x32,
  0x0C, 0x80, 0xC4, 0xF0, 0x92, 0x0C, 0x80, 0xC4, 0xF0, 0x92, 0x0C, 0x80, 0xC4, 0xF0, 0x92, 0x0C,
  0x80, 0xC4, 0xF0, 0x92, 0x0C, 0x80, 0xC4, 0xF0, 0x92,
  // "Ŀ" (U+013F)
  0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07,
  0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70,
  0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77,
  0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A,
  0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77,
  0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF,
  0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77,
  0x70, 0xAF, 0x07, 0x77, 0x48, 0x61, 0x8C, 0xEE, 0xC7, 0x12, 0x0A, 0xF0, 0x77, 0x73, 0x02, 0x0E,
  0xE8, 0x2E, 0x20, 0xAF, 0x07, 0x77, 0x30, 0xDF, 0x98, 0x1D, 0x0A, 0xF0, 0x77, 0x72, 0x03, 0xFB,
  0x03, 0x0A, 0xF0, 0x77, 0x72, 0x07, 0xFB, 0x07, 0x0A, 0xF0, 0x77, 0x72, 0x08, 0xFB, 0x08, 0x0A,
  0xF0, 0x77, 0x72, 0x08, 0xFB, 0x08, 0x0A, 0xF0, 0x77, 0x72, 0x07, 0xFB, 0x07, 0x0A, 0xF0, 0x77,
  0x72, 0x03, 0xFB, 0x03, 0x0A, 0xF0, 0x77, 0x73, 0x0C, 0xF9, 0x81, 0xC0, 0xAF, 0x07, 0x77, 0x30,
  0x20, 0xDE, 0x82, 0xD1, 0x0A, 0xF0, 0x77, 0x75, 0x84, 0x7C, 0xEE, 0xC7, 0x30, 0xAF, 0x07, 0x77,
  0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF,
  0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77,
  0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0,
  0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77,
  0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0x07,
  0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0xAF, 0xFF, 0xFF, 0x05, 0x0A, 0xFF, 0xFF, 0xF0, 0x50,
  0xAF, 0xFF, 0xFF, 0x05, 0x0A, 0xFF, 0xFF, 0xF0, 0x50, 0xAF, 0xFF, 0xFF, 0x05, 0x0A, 0xFF, 0xFF,
  0xF0, 0x50, 0xAF, 0xFF, 0xFF, 0x05,
  // "ŀ" (U+0140)
  0x04, 0xFF, 0xFB, 0x0E, 0x77, 0x76, 0x04, 0xFF, 0xFB, 0x0E, 0x77, 0x76, 0x04, 0xFF, 0xFB, 0x0E,
  0x77, 0x76, 0x04, 0xFF, 0xFB, 0x0E, 0x77, 0x76, 0x04, 0xFF, 0xFB, 0x0E, 0x77, 0x76, 0x04, 0xFF,
  0xFB, 0x0E, 0x77, 0x76, 0x02, 0x80, 0x94, 0x80, 0x9F, 0x0E, 0x80, 0xD0, 0x00, 0x2F, 0x0E, 0x80,
  0xD0, 0x00, 0x2F, 0x0E, 0x80, 0xD0, 0x00, 0x2F, 0x0E, 0x80, 0xD0, 0x00, 0x2F, 0x0E, 0x80, 0xD0,
  0x00, 0x2F, 0x0E, 0x80, 0xD0, 0x00, 0x2F, 0x0E, 0x80, 0xD0, 0x00, 0x2F, 0x0E, 0x80, 0xD0, 0x00,
  0x2F, 0x0E, 0x80, 0xD0, 0x00, 0x2F, 0x0E, 0x80, 0xD0, 0x00, 0x2F, 0x0E, 0x80, 0xD0, 0x00, 0x2F,
  0x0E, 0x80, 0xD0, 0x00, 0x2F, 0x0E, 0x80, 0xD0, 0x00, 0x2F, 0x0E, 0x80, 0xD0, 0x00, 0x2F, 0x0E,
  0x80, 0xD0, 0x00, 0x2F, 0x0E, 0x80, 0xD0, 0x00, 0x2F, 0x0E, 0x80, 0xD0, 0x00, 0x2F, 0x0E, 0x80,
  0xD0, 0x00, 0x2F, 0x0E, 0x80, 0xD0, 0x00, 0x2F, 0x0E, 0x80, 0xD0, 0x00, 0x2F, 0x0E, 0x77, 0x38,
  0x61, 0x8C, 0xEE, 0xC7, 0x17, 0x75, 0x02, 0xF0, 0xE7, 0x72, 0x02, 0x0E, 0xE0, 0xE0, 0x27, 0x74,
  0x02, 0xF0, 0xE7, 0x72, 0x0D, 0xF9, 0x0D, 0x77, 0x40, 0x2F, 0x0E, 0x77, 0x10, 0x3F, 0xB0, 0x37,
  0x73, 0x02, 0xF0, 0xE7, 0x71, 0x07, 0xFB, 0x07, 0x77, 0x30, 0x2F, 0x0E, 0x77, 0x10, 0x8F, 0xB0,
  0x87, 0x73, 0x02, 0xF0, 0xE7, 0x71, 0x08, 0xFB, 0x08, 0x77, 0x30, 0x2F, 0x0E, 0x77, 0x10, 0x7F,
  0xB0, 0x77, 0x73, 0x02, 0xF0, 0xE7, 0x71, 0x03, 0xFB, 0x03, 0x77, 0x30, 0x2F, 0x0E, 0x77, 0x20,
  0xCF, 0x90, 0xC7, 0x74, 0x02, 0xF0, 0xE7, 0x72, 0x02, 0x0D, 0xE0, 0xD0, 0x17, 0x74, 0x02, 0xF0,
  0xE7, 0x74, 0x84, 0x7C, 0xEE, 0xC7, 0x77, 0x60, 0x2F, 0x0E, 0x80, 0xD0, 0x00, 0x2F, 0x0E, 0x80,
  0xD0, 0x00, 0x2F, 0x0E, 0x80, 0xD0, 0x00, 0x2F, 0x0E, 0x80, 0xD0, 0x00, 0x2F, 0x0E, 0x80, 0xD0,
  0x00, 0x2F, 0x0E, 0x80, 0xD0, 0x00, 0x2F, 0x0E, 0x80, 0xD0, 0x00, 0x2F, 0x0E, 0x80, 0xD0, 0x00,
  0x2F, 0x0E, 0x80, 0xD0, 0x00, 0x2F, 0x0E, 0x80, 0xD0, 0x00, 0x2F, 0x0E, 0x80, 0xD0, 0x00, 0x2F,
  0x0E, 0x80, 0xD0, 0x00, 0x2F, 0x0E, 0x80, 0xD0, 0x00, 0x2F, 0x0E, 0x80, 0xD0, 0x00, 0x2F, 0x0E,
  0x80, 0xD0, 0x00, 0x2F, 0x0E, 0x80, 0xD0, 0x00, 0x2F, 0x0E, 0x80, 0xD0, 0x00, 0x2F, 0x0E, 0x80,
  0xD0, 0x00, 0x2F, 0x0E, 0x80, 0xD0, 0x00, 0x2F, 0x0E, 0x80, 0xD0, 0x00, 0x2F, 0x0E, 0x80, 0xD0,
  0x00, 0x2F, 0x0E, 0x80, 0xD0, 0x00, 0x2F, 0x0E, 0x80, 0xC1, 0x08, 0x61, 0x23, 0x45, 0x78, 0xAF,
  0x98, 0x58, 0x76, 0x53, 0x21, 0x77, 0x68, 0x74, 0x67, 0x89, 0xBC, 0xDE, 0xFF, 0xFC, 0x86, 0xEC,
  0xBA, 0x97, 0x63, 0x74, 0x0C, 0x80, 0xC4, 0xF0, 0x97, 0x40, 0xC8, 0x0C, 0x4F, 0x09, 0x74, 0x0C,
  0x80, 0xC4, 0xF0, 0x97, 0x40, 0xC8, 0x0C, 0x4F, 0x09, 0x74, 0x0C, 0x80, 0xC4, 0xF0, 0x97, 0x40,
  // "Ł" (U+0141)
  0x72, 0xF9, 0x80, 0xC1, 0x0F, 0x98, 0x0C, 0x10, 0xF9, 0x80, 0xC1, 0x0F, 0x98, 0x0C, 0x10, 0xF9,
  0x80, 0xC1, 0x0F, 0x98, 0x0C, 0x10, 0xF9, 0x80, 0xC1, 0x0F, 0x98, 0x0C, 0x10, 0xF9, 0x80, 0xC1,
  0x0F, 0x98, 0x0C, 0x10, 0xF9, 0x80, 0xC1, 0x0F, 0x98, 0x0C, 0x10, 0xF9, 0x80, 0xC1, 0x0F, 0x98,
  0x0C, 0x10, 0xF9, 0x80, 0xC1, 0x0F, 0x98, 0x0C, 0x10, 0xF9, 0x80, 0xC1, 0x0F, 0x98, 0x0C, 0x10,
  0xF9, 0x80, 0xC1, 0x0F, 0x98, 0x0C, 0x10, 0xF9, 0x80, 0xC1, 0x0F, 0x98, 0x0C, 0x10, 0xF9, 0x80,
  0xC1, 0x0F, 0x97, 0x30, 0x57, 0x77, 0x5F, 0x97, 0x18, 0x22, 0xBF, 0x77, 0x77, 0x4F, 0x96, 0x01,
  0x09, 0xB0, 0xE0, 0x17, 0x77, 0x3F, 0x95, 0x06, 0x0E, 0xD0, 0x97, 0x77, 0x3F, 0x93, 0x03, 0x0C,
  0xF9, 0x02, 0x77, 0x72, 0xF9, 0x10, 0x10, 0x9F, 0xB0, 0xB7, 0x77, 0x2F, 0x90, 0x70, 0xEF, 0xB0,
  0xE0, 0x67, 0x77, 0x2F, 0xFD, 0x09, 0x01, 0x77, 0x73, 0xFF, 0xB0, 0xB0, 0x27, 0x77, 0x5F, 0xF9,
  0x0D, 0x04, 0x77, 0x77, 0xFE, 0x0E, 0x07, 0x77, 0x77, 0x10, 0x3F, 0xD0, 0x90, 0x17, 0x77, 0x70,
  0x10, 0x8F, 0xC0, 0xB0, 0x27, 0x77, 0x71, 0x06, 0x0E, 0xFB, 0x0D, 0x05, 0x77, 0x77, 0x10, 0x30,
  0xCF, 0xD0, 0x17, 0x77, 0x70, 0x10, 0x9F, 0xF7, 0x77, 0x70, 0x60, 0xEF, 0xF9, 0x77, 0x77, 0x0C,
  0xFF, 0xA7, 0x77, 0x70, 0x3F, 0xFA, 0x77, 0x77, 0x10, 0xAD, 0x0B, 0x03, 0xF9, 0x77, 0x77, 0x10,
  0x10, 0xEA, 0x0D, 0x05, 0x2F, 0x97, 0x77, 0x72, 0x81, 0x7E, 0x74, 0xF9, 0x77, 0x77, 0x30, 0x15,
  0xF9, 0x80, 0xC1, 0x0F, 0x98, 0x0C, 0x10, 0xF9, 0x80, 0xC1, 0x0F, 0x98, 0x0C, 0x10, 0xF9, 0x80,
  0xC1, 0x0F, 0x98, 0x0C, 0x10, 0xF9, 0x80, 0xC1, 0x0F, 0x98, 0x0C, 0x10, 0xF9, 0x80, 0xC1, 0x0F,
  0x98, 0x0C, 0x10, 0xF9, 0x80, 0xC1, 0x0F, 0x98, 0x0C, 0x10, 0xFF, 0xFF, 0xF0, 0xE7, 0x2F, 0xFF,
  0xFF, 0x0E, 0x72, 0xFF, 0xFF, 0xF0, 0xE7, 0x2F, 0xFF, 0xFF, 0x0E, 0x72, 0xFF, 0xFF, 0xF0, 0xE7,
  0x2F, 0xFF, 0xFF, 0x0E, 0x72, 0xFF, 0xFF, 0xF0, 0xE0,
  // "ł" (U+0142)
  0x04, 0xFF, 0xFB, 0x0E, 0x77, 0x20, 0x4F, 0xFF, 0xB0, 0xE7, 0x72, 0x04, 0xFF, 0xFB, 0x0E, 0x77,
  0x20, 0x4F, 0xFF, 0xB0, 0xE7, 0x72, 0x04, 0xFF, 0xFB, 0x0E, 0x77, 0x20, 0x4F, 0xFF, 0xB0, 0xE7,
  0x72, 0x02, 0x80, 0x94, 0x80, 0x9F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F,
  0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E,
  0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77,
  0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77,
  0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50,
  0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x77, 0x77, 0x50, 0x2F,
  0x0E, 0x77, 0x77, 0x50, 0x2F, 0x0E, 0x68, 0x14, 0xC1, 0x77, 0x73, 0x02, 0xF0, 0xE4, 0x02, 0x0A,
  0xA0, 0xA7, 0x77, 0x30, 0x2F, 0x0E, 0x30, 0x7D, 0x04, 0x77, 0x72, 0x02, 0xF8, 0x2E, 0x04, 0xDE,
  0x0D, 0x77, 0x72, 0x02, 0xF0, 0xE0, 0xAF, 0xA0, 0x87, 0x77, 0x10, 0x2F, 0xFC, 0x07, 0x77, 0x71,
  0x02, 0xFF, 0xA0, 0xB0, 0x27, 0x77, 0x20, 0x2F, 0xF0, 0xD0, 0x47, 0x77, 0x40, 0x2F, 0xE0, 0x87,
  0x77, 0x60, 0x4F, 0xC0, 0xB0, 0x27, 0x77, 0x60, 0x8F, 0xB0, 0xD0, 0x57, 0x77, 0x60, 0x50, 0xEF,
  0xB0, 0x87, 0x77, 0x60, 0x20, 0xBF, 0xC0, 0xE7, 0x77, 0x60, 0x8F, 0xE0, 0xE7, 0x77, 0x40, 0x40,
  0xDF, 0xF0, 0xE7, 0x77, 0x20, 0x20, 0xAF, 0xFA, 0x0E, 0x77, 0x71, 0x07, 0x0E, 0xFF, 0xB0, 0xE7,
  0x77, 0x10, 0x9F, 0xA0, 0xA0, 0x4F, 0x0E, 0x77, 0x71, 0x01, 0x0E, 0xE8, 0x2D, 0x30, 0x2F, 0x0E,
  0x77, 0x72, 0x06, 0xC0, 0xE0, 0x73, 0x02, 0xF0, 0xE7, 0x77, 0x30, 0xBA, 0x0A, 0x01, 0x40, 0x2F,
  0x0E, 0x77, 0x73, 0x81, 0x2C, 0x46, 0x02, 0xF0, 0xE7, 0x77, 0x75, 0x02, 0xF0, 0xE7, 0x77, 0x75,
  0x02, 0xF0, 0xE7, 0x77, 0x75, 0x02, 0xF0, 0xE7, 0x77, 0x75, 0x02, 0xF0, 0xE7, 0x77, 0x75, 0x02,
  0xF0, 0xE7, 0x77, 0x75, 0x02, 0xF0, 0xE7, 0x77, 0x75, 0x02, 0xF0, 0xE7, 0x77, 0x75, 0x02, 0xF0,
  0xE7, 0x77, 0x75, 0x02, 0xF0, 0xE7, 0x77, 0x75, 0x02, 0xF0, 0xE7, 0x77, 0x75, 0x02, 0xF0, 0xE7,
  0x77, 0x75, 0x02, 0xF0, 0xE7, 0x77, 0x75, 0x02, 0xF0, 0xE7, 0x77, 0x75, 0x02, 0xF0, 0xE7, 0x77,
  0x58, 0x61, 0x23, 0x45, 0x78, 0xAF, 0x98, 0x58, 0x76, 0x53, 0x21, 0x72, 0x87, 0x46, 0x78, 0x9B,
  0xCD, 0xEF, 0xFF, 0xC8, 0x7E, 0xCB, 0xA9, 0x76, 0x3C, 0x80, 0xC4, 0xF0, 0x90, 0xC8, 0x0C, 0x4F,
  0x09, 0x0C, 0x80, 0xC4, 0xF0, 0x90, 0xC8, 0x0C, 0x4F, 0x09, 0x0C, 0x80, 0xC4, 0xF0, 0x90,
  // "Ń" (U+0143)
  0x77, 0x74, 0x03, 0x80, 0x57, 0x01, 0x77, 0x77, 0x30, 0xCF, 0xA0, 0x27, 0x77, 0x72, 0x05, 0xFA,
  0x08, 0x77, 0x77, 0x30, 0xDF, 0x90, 0xB7, 0x77, 0x73, 0x08, 0xF9, 0x0D, 0x01, 0x77, 0x77, 0x20,
  0x2F, 0x90, 0xE0, 0x27, 0x77, 0x73, 0x0C, 0xF0, 0xE0, 0x37, 0x77, 0x73, 0x06, 0xF9, 0x04, 0x77,
  0x77, 0x30, 0x10, 0xEF, 0x05, 0x77, 0x77, 0x40, 0xBF, 0x05, 0x77, 0x77, 0x40, 0x5F, 0x06, 0x77,
  0x77, 0x40, 0x10, 0xEE, 0x05, 0x77, 0x77, 0x50, 0xBE, 0x05, 0x77, 0x77, 0x50, 0x8D, 0x0E, 0x04,
  0x77, 0x77, 0x60, 0xDC, 0x0C, 0x02, 0x80, 0xC9, 0x20, 0x0A, 0xFB, 0x03, 0x77, 0x70, 0x1F, 0x00,
  0xAF, 0xB0, 0xA7, 0x77, 0x01, 0xF0, 0x0A, 0xFC, 0x01, 0x77, 0x60, 0x1F, 0x00, 0xAF, 0xC0, 0x87,
  0x76, 0x01, 0xF0, 0x0A, 0xFC, 0x0E, 0x77, 0x60, 0x1F, 0x00, 0xAF, 0xD0, 0x67, 0x75, 0x01, 0xF0,
  0x0A, 0xFD, 0x0D, 0x77, 0x50, 0x1F, 0x00, 0xAF, 0xE0, 0x47, 0x74, 0x01, 0xF0, 0x0A, 0xFE, 0x0B,
  0x77, 0x40, 0x1F, 0x00, 0xAE, 0x07, 0xF0, 0x27, 0x73, 0x01, 0xF0, 0x0A, 0xE0, 0x20, 0xEE, 0x09,
  0x77, 0x30, 0x1F, 0x00, 0xAE, 0x02, 0x09, 0xF0, 0x17, 0x72, 0x01, 0xF0, 0x0A, 0xE0, 0x30, 0x2F,
  0x07, 0x77, 0x20, 0x1F, 0x00, 0xAE, 0x81, 0x40, 0xAE, 0x0D, 0x77, 0x20, 0x1F, 0x00, 0xAE, 0x81,
  0x60, 0x3F, 0x05, 0x77, 0x10, 0x1F, 0x00, 0xAE, 0x07, 0x20, 0xCE, 0x0C, 0x77, 0x10, 0x1F, 0x00,
  0xAE, 0x08, 0x20, 0x5F, 0x03, 0x77, 0x01, 0xF0, 0x0A, 0xE0, 0x93, 0x0D, 0xE0, 0xA7, 0x70, 0x1F,
  0x00, 0xAE, 0x0B, 0x30, 0x7F, 0x01, 0x76, 0x01, 0xF0, 0x0A, 0xE0, 0xC3, 0x01, 0x0E, 0xE0, 0x87,
  0x60, 0x1F, 0x00, 0xAE, 0x0D, 0x40, 0x8E, 0x0E, 0x76, 0x01, 0xF0, 0x0A, 0xE0, 0xE4, 0x02, 0xF0,
  0x67, 0x50, 0x1F, 0x00, 0xAE, 0x0E, 0x50, 0xAE, 0x0D, 0x75, 0x01, 0xF0, 0x0A, 0xF5, 0x03, 0xF0,
  0x47, 0x40, 0x1F, 0x00, 0xAF, 0x60, 0xCE, 0x0B, 0x74, 0x01, 0xF0, 0x0A, 0xF0, 0x15, 0x05, 0xF0,
  0x27, 0x30, 0x1F, 0x00, 0xAF, 0x01, 0x60, 0xDE, 0x09, 0x73, 0x01, 0xF0, 0x0A, 0xF0, 0x16, 0x06,
  0xE0, 0xE0, 0x17, 0x20, 0x1F, 0x00, 0xAF, 0x01, 0x70, 0xEE, 0x07, 0x72, 0x01, 0xF0, 0x0A, 0xF0,
  0x17, 0x08, 0xE0, 0xD7, 0x20, 0x1F, 0x00, 0xAF, 0x01, 0x70, 0x1F, 0x05, 0x71, 0x01, 0xF0, 0x0A,
  0xF0, 0x17, 0x10, 0xAE, 0x0C, 0x71, 0x01, 0xF0, 0x0A, 0xF0, 0x17, 0x10, 0x3F, 0x03, 0x70, 0x1F,
  0x00, 0xAF, 0x01, 0x72, 0x0B, 0xE0, 0xA7, 0x01, 0xF0, 0x0A, 0xF0, 0x17, 0x20, 0x4F, 0x01, 0x60,
  0x1F, 0x00, 0xAF, 0x01, 0x73, 0x0D, 0xE0, 0x86, 0x01, 0xF0, 0x0A, 0xF0, 0x17, 0x30, 0x6E, 0x0E,
  0x60, 0x1F, 0x00, 0xAF, 0x01, 0x74, 0x0E, 0xE0, 0x65, 0x01, 0xF0, 0x0A, 0xF0, 0x17, 0x40, 0x8E,
  0x0D, 0x50, 0x1F, 0x00, 0xAF, 0x01, 0x74, 0x01, 0xF0, 0x44, 0x01, 0xF0, 0x0A, 0xF0, 0x17, 0x50,
  0x9E, 0x0B, 0x5F, 0x00, 0xAF, 0x01, 0x75, 0x02, 0xF0, 0x24, 0xF0, 0x0A, 0xF0, 0x17, 0x60, 0xBE,
  0x09, 0x4F, 0x00, 0xAF, 0x01, 0x76, 0x04, 0xE0, 0xE0, 0x13, 0xF0, 0x0A, 0xF0, 0x17, 0x70, 0xCE,
  0x07, 0x30, 0xEE, 0x00, 0xAF, 0x01, 0x77, 0x05, 0xE0, 0xD3, 0x0D, 0xE0, 0x0A, 0xF0, 0x17, 0x71,
  0x0E, 0xE0, 0x52, 0x0C, 0xE0, 0x0A, 0xF0, 0x17, 0x71, 0x07, 0xE0, 0xC2, 0x0B, 0xE0, 0x0A, 0xF0,
  0x17, 0x71, 0x01, 0x0E, 0xE8, 0x13, 0x0A, 0xE0, 0x0A, 0xF0, 0x17, 0x72, 0x09, 0xE8, 0x1A, 0x09,
  0xE0, 0x0A, 0xF0, 0x17, 0x72, 0x02, 0xF0, 0x10, 0x8E, 0x00, 0xAF, 0x01, 0x77, 0x30, 0xAE, 0x08,
  0x07, 0xE0, 0x0A, 0xF0, 0x17, 0x73, 0x03, 0xE0, 0xE0, 0x6E, 0x00, 0xAF, 0x01, 0x77, 0x40, 0xCE,
  0x0C, 0xE0, 0x0A, 0xF0, 0x17, 0x74, 0x05, 0xFE, 0x00, 0xAF, 0x01, 0x77, 0x50, 0xDF, 0xD0, 0x0A,
  0xF0, 0x17, 0x75, 0x07, 0xFD, 0x00, 0xAF, 0x01, 0x77, 0x50, 0x10, 0xEF, 0xC0, 0x0A, 0xF0, 0x17,
  0x76, 0x08, 0xFC, 0x00, 0xAF, 0x01, 0x77, 0x60, 0x2F, 0xC0, 0x0A, 0xF0, 0x17, 0x77, 0x0A, 0xFB,
  0x00, 0xAF, 0x01, 0x77, 0x70, 0x3F, 0xB0, 0x0A, 0xF0, 0x17, 0x77, 0x10, 0xCF, 0xA0, 0x0A, 0xF0,
  0x17, 0x77, 0x10, 0x5F, 0xA0, 0xA0,
  // "ń" (U+0144)
  0x77, 0x74, 0x03, 0x80, 0x57, 0x01, 0x77, 0x77, 0x20, 0xCF, 0xA0, 0x27, 0x77, 0x71, 0x05, 0xFA,
  0x08, 0x77, 0x77, 0x20, 0xDF, 0x90, 0xB7, 0x77, 0x72, 0x08, 0xF9, 0x0D, 0x01, 0x77, 0x77, 0x10,
  0x2F, 0x90, 0xE0, 0x27, 0x77, 0x72, 0x0C, 0xF0, 0xE0, 0x37, 0x77, 0x72, 0x06, 0xF9, 0x04, 0x77,
  0x77, 0x20, 0x10, 0xEF, 0x05, 0x77, 0x77, 0x30, 0xBF, 0x05, 0x77, 0x77, 0x30, 0x5F, 0x06, 0x77,
  0x77, 0x30, 0x10, 0xEE, 0x05, 0x77, 0x77, 0x40, 0xBE, 0x05, 0x77, 0x77, 0x40, 0x8D, 0x0E, 0x04,
  0x77, 0x77, 0x50, 0xDC, 0x0C, 0x02, 0x80, 0xBD, 0x30, 0x84, 0x26, 0x9B, 0xDE, 0xA8, 0x3E, 0xDB,
  0x84, 0x74, 0x0C, 0xD0, 0xB7, 0x81, 0x17, 0xDF, 0xE8, 0x1E, 0x92, 0x71, 0x0C, 0xD0, 0xE6, 0x07,
  0x0E, 0xFF, 0xC0, 0x97, 0x0C, 0xE0, 0x13, 0x02, 0x0D, 0xFF, 0xF0, 0xD0, 0x25, 0x0C, 0xE0, 0x42,
  0x03, 0x0E, 0xFF, 0xFA, 0x0E, 0x03, 0x40, 0xCE, 0x82, 0x60, 0x2E, 0xFF, 0xFC, 0x0E, 0x01, 0x30,
  0xCE, 0x81, 0x90, 0xCF, 0x98, 0x5C, 0xA9, 0x89, 0xAC, 0xFD, 0x0B, 0x30, 0xCE, 0x0B, 0x06, 0xE0,
  0xA0, 0x47, 0x20, 0x40, 0xCF, 0xB0, 0x52, 0x0C, 0xFD, 0x0D, 0x03, 0x76, 0x05, 0xFA, 0x0C, 0x20,
  0xCF, 0xC0, 0xB7, 0x72, 0x04, 0xFA, 0x81, 0x20, 0xCF, 0xB0, 0xC7, 0x74, 0x08, 0xF9, 0x81, 0x70,
  0xCF, 0xB0, 0x27, 0x74, 0x01, 0xF9, 0x81, 0xB0, 0xCF, 0xA0, 0xA7, 0x76, 0x0A, 0xF8, 0x1E, 0x0C,
  0xFA, 0x02, 0x77, 0x60, 0x5F, 0x91, 0x0C, 0xF9, 0x0B, 0x77, 0x70, 0x2F, 0x90, 0x20, 0xCF, 0x90,
  0x77, 0x77, 0x1F, 0x90, 0x30, 0xCF, 0x90, 0x27, 0x77, 0x10, 0xEF, 0x03, 0x0C, 0xF0, 0xE7, 0x77,
  0x20, 0xDF, 0x03, 0x0C, 0xF0, 0xC7, 0x77, 0x20, 0xDF, 0x03, 0x0C, 0xF0, 0x97, 0x77, 0x20, 0xDF,
  0x03, 0x0C, 0xF0, 0x77, 0x77, 0x20, 0xDF, 0x03, 0x0C, 0xF0, 0x67, 0x77, 0x20, 0xDF, 0x03, 0x0C,
  0xF0, 0x57, 0x77, 0x20, 0xDF, 0x03, 0x0C, 0xF0, 0x57, 0x77, 0x20, 0xDF, 0x03, 0x0C, 0xF0, 0x47,
  0x77, 0x20, 0xDF, 0x03, 0x0C, 0xF0, 0x47, 0x77, 0x20, 0xDF, 0x03, 0x0C, 0xF0, 0x47, 0x77, 0x20,
  0xDF, 0x03, 0x0C, 0xF0, 0x47, 0x77, 0x20, 0xDF, 0x03, 0x0C, 0xF0, 0x47, 0x77, 0x20, 0xDF, 0x03,
  0x0C, 0xF0, 0x47, 0x77, 0x20, 0xDF, 0x03, 0x0C, 0xF0, 0x47, 0x77, 0x20, 0xDF, 0x03, 0x0C, 0xF0,
  0x47, 0x77, 0x20, 0xDF, 0x03, 0x0C, 0xF0, 0x47, 0x77, 0x20, 0xDF, 0x03, 0x0C, 0xF0, 0x47, 0x77,
  0x20, 0xDF, 0x03, 0x0C, 0xF0, 0x47, 0x77, 0x20, 0xDF, 0x03, 0x0C, 0xF0, 0x47, 0x77, 0x20, 0xDF,
  0x03, 0x0C, 0xF0, 0x47, 0x77, 0x20, 0xDF, 0x03, 0x0C, 0xF0, 0x47, 0x77, 0x20, 0xDF, 0x03, 0x0C,
  0xF0, 0x47, 0x77, 0x20, 0xDF, 0x03, 0x0C, 0xF0, 0x47, 0x77, 0x20, 0xDF, 0x03, 0x0C, 0xF0, 0x47,
  0x77, 0x20, 0xDF, 0x03, 0x0C, 0xF0, 0x47, 0x77, 0x20, 0xDF, 0x03, 0x0C, 0xF0, 0x47, 0x77, 0x20,
  0xDF, 0x03, 0x0C, 0xF0, 0x47, 0x77, 0x20, 0xDF, 0x03, 0x0C, 0xF0, 0x47, 0x77, 0x20, 0xDF, 0x03,
  0x0C, 0xF0, 0x47, 0x77, 0x20, 0xDF, 0x03, 0x0C, 0xF0, 0x47, 0x77, 0x20, 0xDF, 0x03, 0x0C, 0xF0,
  0x47, 0x77, 0x20, 0xDF, 0x03, 0x0C, 0xF0, 0x47, 0x77, 0x20, 0xDF, 0x03,
  // "Ņ" (U+0145)
  0x0A, 0xFB, 0x03, 0x77, 0x70, 0x1F, 0x00, 0xAF, 0xB0, 0xA7, 0x77, 0x01, 0xF0, 0x0A, 0xFC, 0x01,
  0x77, 0x60, 0x1F, 0x00, 0xAF, 0xC0, 0x87, 0x76, 0x01, 0xF0, 0x0A, 0xFC, 0x0E, 0x77, 0x60, 0x1F,
  0x00, 0xAF, 0xD0, 0x67, 0x75, 0x01, 0xF0, 0x0A, 0xFD, 0x0D, 0x77, 0x50, 0x1F, 0x00, 0xAF, 0xE0,
  0x47, 0x74, 0x01, 0xF0, 0x0A, 0xFE, 0x0B, 0x77, 0x40, 0x1F, 0x00, 0xAE, 0x07, 0xF0, 0x27, 0x73,
  0x01, 0xF0, 0x0A, 0xE0, 0x20, 0xEE, 0x09, 0x77, 0x30, 0x1F, 0x00, 0xAE, 0x02, 0x09, 0xF0, 0x17,
  0x72, 0x01, 0xF0, 0x0A, 0xE0, 0x30, 0x2F, 0x07, 0x77, 0x20, 0x1F, 0x00, 0xAE, 0x81, 0x40, 0xAE,
  0x0D, 0x77, 0x20, 0x1F, 0x00, 0xAE, 0x81, 0x60, 0x3F, 0x05, 0x77, 0x10, 0x1F, 0x00, 0xAE, 0x07,
  0x20, 0xCE, 0x0C, 0x77, 0x10, 0x1F, 0x00, 0xAE, 0x08, 0x20, 0x5F, 0x03, 0x77, 0x01, 0xF0, 0x0A,
  0xE0, 0x93, 0x0D, 0xE0, 0xA7, 0x70, 0x1F, 0x00, 0xAE, 0x0B, 0x30, 0x7F, 0x01, 0x76, 0x01, 0xF0,
  0x0A, 0xE0, 0xC3, 0x01, 0x0E, 0xE0, 0x87, 0x60, 0x1F, 0x00, 0xAE, 0x0D, 0x40, 0x8E, 0x0E, 0x76,
  0x01, 0xF0, 0x0A, 0xE0, 0xE4, 0x02, 0xF0, 0x67, 0x50, 0x1F, 0x00, 0xAE, 0x0E, 0x50, 0xAE, 0x0D,
  0x75, 0x01, 0xF0, 0x0A, 0xF5, 0x03, 0xF0, 0x47, 0x40, 0x1F, 0x00, 0xAF, 0x60, 0xCE, 0x0B, 0x74,
  0x01, 0xF0, 0x0A, 0xF0, 0x15, 0x05, 0xF0, 0x27, 0x30, 0x1F, 0x00, 0xAF, 0x01, 0x60, 0xDE, 0x09,
  0x73, 0x01, 0xF0, 0x0A, 0xF0, 0x16, 0x06, 0xE0, 0xE0, 0x17, 0x20, 0x1F, 0x00, 0xAF, 0x01, 0x70,
  0xEE, 0x07, 0x72, 0x01, 0xF0, 0x0A, 0xF0, 0x17, 0x08, 0xE0, 0xD7, 0x20, 0x1F, 0x00, 0xAF, 0x01,
  0x70, 0x1F, 0x05, 0x71, 0x01, 0xF0, 0x0A, 0xF0, 0x17, 0x10, 0xAE, 0x0C, 0x71, 0x01, 0xF0, 0x0A,
  0xF0, 0x17, 0x10, 0x3F, 0x03, 0x70, 0x1F, 0x00, 0xAF, 0x01, 0x72, 0x0B, 0xE0, 0xA7, 0x01, 0xF0,
  0x0A, 0xF0, 0x17, 0x20, 0x4F, 0x01, 0x60, 0x1F, 0x00, 0xAF, 0x01, 0x73, 0x0D, 0xE0, 0x86, 0x01,
  0xF0, 0x0A, 0xF0, 0x17, 0x30, 0x6E, 0x0E, 0x60, 0x1F, 0x00, 0xAF, 0x01, 0x74, 0x0E, 0xE0, 0x65,
  0x01, 0xF0, 0x0A, 0xF0, 0x17, 0x40, 0x8E, 0x0D, 0x50, 0x1F, 0x00, 0xAF, 0x01, 0x74, 0x01, 0xF0,
  0x44, 0x01, 0xF0, 0x0A, 0xF0, 0x17, 0x50, 0x9E, 0x0B, 0x5F, 0x00, 0xAF, 0x01, 0x75, 0x02, 0xF0,
  0x24, 0xF0, 0x0A, 0xF0, 0x17, 0x60, 0xBE, 0x09, 0x4F, 0x00, 0xAF, 0x01, 0x76, 0x04, 0xE0, 0xE0,
  0x13, 0xF0, 0x0A, 0xF0, 0x17, 0x70, 0xCE, 0x07, 0x30, 0xEE, 0x00, 0xAF, 0x01, 0x77, 0x05, 0xE0,
  0xD3, 0x0D, 0xE0, 0x0A, 0xF0, 0x17, 0x71, 0x0E, 0xE0, 0x52, 0x0C, 0xE0, 0x0A, 0xF0, 0x17, 0x71,
  0x07, 0xE0, 0xC2, 0x0B, 0xE0, 0x0A, 0xF0, 0x17, 0x71, 0x01, 0x0E, 0xE8, 0x13, 0x0A, 0xE0, 0x0A,
  0xF0, 0x17, 0x72, 0x09, 0xE8, 0x1A, 0x09, 0xE0, 0x0A, 0xF0, 0x17, 0x72, 0x02, 0xF0, 0x10, 0x8E,
  0x00, 0xAF, 0x01, 0x77, 0x30, 0xAE, 0x08, 0x07, 0xE0, 0x0A, 0xF0, 0x17, 0x73, 0x03, 0xE0, 0xE0,
  0x6E, 0x00, 0xAF, 0x01, 0x77, 0x40, 0xCE, 0x0C, 0xE0, 0x0A, 0xF0, 0x17, 0x74, 0x05, 0xFE, 0x00,
  0xAF, 0x01, 0x77, 0x50, 0xDF, 0xD0, 0x0A, 0xF0, 0x17, 0x75, 0x07, 0xFD, 0x00, 0xAF, 0x01, 0x77,
  0x50, 0x10, 0xEF, 0xC0, 0x0A, 0xF0, 0x17, 0x76, 0x08, 0xFC, 0x00, 0xAF, 0x01, 0x77, 0x60, 0x2F,
  0xC0, 0x0A, 0xF0, 0x17, 0x77, 0x0A, 0xFB, 0x00, 0xAF, 0x01, 0x77, 0x70, 0x3F, 0xB0, 0x0A, 0xF0,
  0x17, 0x77, 0x10, 0xCF, 0xA0, 0x0A, 0xF0, 0x17, 0x77, 0x10, 0x5F, 0xA0, 0xA8, 0x0C, 0x91, 0x00,
  0xDF, 0x77, 0x77, 0x6F, 0x0B, 0x77, 0x77, 0x50, 0x2F, 0x06, 0x77, 0x77, 0x50, 0x6F, 0x01, 0x77,
  0x77, 0x50, 0x9E, 0x09, 0x77, 0x77, 0x60, 0xEE, 0x02, 0x77, 0x77, 0x50, 0x3E, 0x0A, 0x77, 0x77,
  0x60, 0x7E, 0x02, 0x77, 0x77, 0x60, 0xCD, 0x08, 0x77, 0x77, 0x60, 0x1D, 0x0E, 0x01, 0x77, 0x77,
  0x60, 0x7D, 0x05, 0x77, 0x77, 0x70, 0xCC, 0x0B, 0x77, 0x77, 0x70, 0x4C, 0x0E, 0x01, 0x77, 0x77,
  0x70, 0x7C, 0x03, 0x77, 0x72,
  // "ņ" (U+0146)
  0x77, 0x38, 0x42, 0x69, 0xBD, 0xEA, 0x83, 0xED, 0xB8, 0x47, 0x40, 0xCD, 0x0B, 0x78, 0x11, 0x7D,
  0xFE, 0x81, 0xE9, 0x27, 0x10, 0xCD, 0x0E, 0x60, 0x70, 0xEF, 0xFC, 0x09, 0x70, 0xCE, 0x01, 0x30,
  0x20, 0xDF, 0xFF, 0x0D, 0x02, 0x50, 0xCE, 0x04, 0x20, 0x30, 0xEF, 0xFF, 0xA0, 0xE0, 0x34, 0x0C,
  0xE8, 0x26, 0x02, 0xEF, 0xFF, 0xC0, 0xE0, 0x13, 0x0C, 0xE8, 0x19, 0x0C, 0xF9, 0x85, 0xCA, 0x98,
  0x9A, 0xCF, 0xD0, 0xB3, 0x0C, 0xE0, 0xB0, 0x6E, 0x0A, 0x04, 0x72, 0x04, 0x0C, 0xFB, 0x05, 0x20,
  0xCF, 0xD0, 0xD0, 0x37, 0x60, 0x5F, 0xA0, 0xC2, 0x0C, 0xFC, 0x0B, 0x77, 0x20, 0x4F, 0xA8, 0x12,
  0x0C, 0xFB, 0x0C, 0x77, 0x40, 0x8F, 0x98, 0x17, 0x0C, 0xFB, 0x02, 0x77, 0x40, 0x1F, 0x98, 0x1B,
  0x0C, 0xFA, 0x0A, 0x77, 0x60, 0xAF, 0x81, 0xE0, 0xCF, 0xA0, 0x27, 0x76, 0x05, 0xF9, 0x10, 0xCF,
  0x90, 0xB7, 0x77, 0x02, 0xF9, 0x02, 0x0C, 0xF9, 0x07, 0x77, 0x71, 0xF9, 0x03, 0x0C, 0xF9, 0x02,
  0x77, 0x71, 0x0E, 0xF0, 0x30, 0xCF, 0x0E, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x0C, 0x77, 0x72,
  0x0D, 0xF0, 0x30, 0xCF, 0x09, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x07, 0x77, 0x72, 0x0D, 0xF0,
  0x30, 0xCF, 0x06, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x05, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF,
  0x05, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77,
  0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D,
  0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30,
  0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04,
  0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72,
  0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0,
  0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF,
  0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77,
  0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D,
  0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30,
  0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04,
  0x77, 0x72, 0x0D, 0xF0, 0x38, 0x0C, 0x83, 0x00, 0xDF, 0x77, 0x77, 0x5F, 0x0B, 0x77, 0x77, 0x40,
  0x2F, 0x06, 0x77, 0x77, 0x40, 0x6F, 0x01, 0x77, 0x77, 0x40, 0x9E, 0x09, 0x77, 0x77, 0x50, 0xEE,
  0x02, 0x77, 0x77, 0x40, 0x3E, 0x0A, 0x77, 0x77, 0x50, 0x7E, 0x02, 0x77, 0x77, 0x50, 0xCD, 0x08,
  0x77, 0x77, 0x50, 0x1D, 0x0E, 0x01, 0x77, 0x77, 0x50, 0x7D, 0x05, 0x77, 0x77, 0x60, 0xCC, 0x0B,
  0x77, 0x77, 0x60, 0x4C, 0x0E, 0x01, 0x77, 0x77, 0x60, 0x7C, 0x03, 0x77, 0x71,
  // "Ň" (U+0147)
  0x50, 0x18, 0x01, 0x70, 0x47, 0x74, 0x05, 0x80, 0x17, 0x01, 0x73, 0x02, 0xE0, 0x87, 0x71, 0x01,
  0x0A, 0xE0, 0x27, 0x40, 0x8E, 0x0C, 0x01, 0x75, 0x03, 0x0D, 0xE0, 0x87, 0x60, 0x9E, 0x0D, 0x03,
  0x73, 0x05, 0x0E, 0xE0, 0x87, 0x71, 0x0A, 0xF0, 0x57, 0x10, 0x7F, 0x09, 0x77, 0x30, 0xBF, 0x06,
  0x60, 0x9F, 0x09, 0x77, 0x50, 0xCF, 0x07, 0x40, 0xAF, 0x0A, 0x77, 0x60, 0x10, 0xDF, 0x06, 0x20,
  0xAF, 0x0C, 0x77, 0x71, 0x02, 0x0E, 0xF0, 0x60, 0xBF, 0x0D, 0x01, 0x77, 0x72, 0x04, 0xFF, 0x90,
  0xD0, 0x17, 0x77, 0x40, 0x5F, 0xE0, 0xE0, 0x27, 0x77, 0x60, 0x8F, 0xD0, 0x57, 0x77, 0x71, 0x0C,
  0xFB, 0x08, 0x77, 0x77, 0x20, 0x20, 0xEF, 0x90, 0xD7, 0x77, 0x74, 0x07, 0xF9, 0x04, 0x80, 0xC9,
  0x00, 0x0A, 0xFB, 0x03, 0x77, 0x70, 0x1F, 0x00, 0xAF, 0xB0, 0xA7, 0x77, 0x01, 0xF0, 0x0A, 0xFC,
  0x01, 0x77, 0x60, 0x1F, 0x00, 0xAF, 0xC0, 0x87, 0x76, 0x01, 0xF0, 0x0A, 0xFC, 0x0E, 0x77, 0x60,
  0x1F, 0x00, 0xAF, 0xD0, 0x67, 0x75, 0x01, 0xF0, 0x0A, 0xFD, 0x0D, 0x77, 0x50, 0x1F, 0x00, 0xAF,
  0xE0, 0x47, 0x74, 0x01, 0xF0, 0x0A, 0xFE, 0x0B, 0x77, 0x40, 0x1F, 0x00, 0xAE, 0x07, 0xF0, 0x27,
  0x73, 0x01, 0xF0, 0x0A, 0xE0, 0x20, 0xEE, 0x09, 0x77, 0x30, 0x1F, 0x00, 0xAE, 0x02, 0x09, 0xF0,
  0x17, 0x72, 0x01, 0xF0, 0x0A, 0xE0, 0x30, 0x2F, 0x07, 0x77, 0x20, 0x1F, 0x00, 0xAE, 0x81, 0x40,
  0xAE, 0x0D, 0x77, 0x20, 0x1F, 0x00, 0xAE, 0x81, 0x60, 0x3F, 0x05, 0x77, 0x10, 0x1F, 0x00, 0xAE,
  0x07, 0x20, 0xCE, 0x0C, 0x77, 0x10, 0x1F, 0x00, 0xAE, 0x08, 0x20, 0x5F, 0x03, 0x77, 0x01, 0xF0,
  0x0A, 0xE0, 0x93, 0x0D, 0xE0, 0xA7, 0x70, 0x1F, 0x00, 0xAE, 0x0B, 0x30, 0x7F, 0x01, 0x76, 0x01,
  0xF0, 0x0A, 0xE0, 0xC3, 0x01, 0x0E, 0xE0, 0x87, 0x60, 0x1F, 0x00, 0xAE, 0x0D, 0x40, 0x8E, 0x0E,
  0x76, 0x01, 0xF0, 0x0A, 0xE0, 0xE4, 0x02, 0xF0, 0x67, 0x50, 0x1F, 0x00, 0xAE, 0x0E, 0x50, 0xAE,
  0x0D, 0x75, 0x01, 0xF0, 0x0A, 0xF5, 0x03, 0xF0, 0x47, 0x40, 0x1F, 0x00, 0xAF, 0x60, 0xCE, 0x0B,
  0x74, 0x01, 0xF0, 0x0A, 0xF0, 0x15, 0x05, 0xF0, 0x27, 0x30, 0x1F, 0x00, 0xAF, 0x01, 0x60, 0xDE,
  0x09, 0x73, 0x01, 0xF0, 0x0A, 0xF0, 0x16, 0x06, 0xE0, 0xE0, 0x17, 0x20, 0x1F, 0x00, 0xAF, 0x01,
  0x70, 0xEE, 0x07, 0x72, 0x01, 0xF0, 0x0A, 0xF0, 0x17, 0x08, 0xE0, 0xD7, 0x20, 0x1F, 0x00, 0xAF,
  0x01, 0x70, 0x1F, 0x05, 0x71, 0x01, 0xF0, 0x0A, 0xF0, 0x17, 0x10, 0xAE, 0x0C, 0x71, 0x01, 0xF0,
  0x0A, 0xF0, 0x17, 0x10, 0x3F, 0x03, 0x70, 0x1F, 0x00, 0xAF, 0x01, 0x72, 0x0B, 0xE0, 0xA7, 0x01,
  0xF0, 0x0A, 0xF0, 0x17, 0x20, 0x4F, 0x01, 0x60, 0x1F, 0x00, 0xAF, 0x01, 0x73, 0x0D, 0xE0, 0x86,
  0x01, 0xF0, 0x0A, 0xF0, 0x17, 0x30, 0x6E, 0x0E, 0x60, 0x1F, 0x00, 0xAF, 0x01, 0x74, 0x0E, 0xE0,
  0x65, 0x01, 0xF0, 0x0A, 0xF0, 0x17, 0x40, 0x8E, 0x0D, 0x50, 0x1F, 0x00, 0xAF, 0x01, 0x74, 0x01,
  0xF0, 0x44, 0x01, 0xF0, 0x0A, 0xF0, 0x17, 0x50, 0x9E, 0x0B, 0x5F, 0x00, 0xAF, 0x01, 0x75, 0x02,
  0xF0, 0x24, 0xF0, 0x0A, 0xF0, 0x17, 0x60, 0xBE, 0x09, 0x4F, 0x00, 0xAF, 0x01, 0x76, 0x04, 0xE0,
  0xE0, 0x13, 0xF0, 0x0A, 0xF0, 0x17, 0x70, 0xCE, 0x07, 0x30, 0xEE, 0x00, 0xAF, 0x01, 0x77, 0x05,
  0xE0, 0xD3, 0x0D, 0xE0, 0x0A, 0xF0, 0x17, 0x71, 0x0E, 0xE0, 0x52, 0x0C, 0xE0, 0x0A, 0xF0, 0x17,
  0x71, 0x07, 0xE0, 0xC2, 0x0B, 0xE0, 0x0A, 0xF0, 0x17, 0x71, 0x01, 0x0E, 0xE8, 0x13, 0x0A, 0xE0,
  0x0A, 0xF0, 0x17, 0x72, 0x09, 0xE8, 0x1A, 0x09, 0xE0, 0x0A, 0xF0, 0x17, 0x72, 0x02, 0xF0, 0x10,
  0x8E, 0x00, 0xAF, 0x01, 0x77, 0x30, 0xAE, 0x08, 0x07, 0xE0, 0x0A, 0xF0, 0x17, 0x73, 0x03, 0xE0,
  0xE0, 0x6E, 0x00, 0xAF, 0x01, 0x77, 0x40, 0xCE, 0x0C, 0xE0, 0x0A, 0xF0, 0x17, 0x74, 0x05, 0xFE,
  0x00, 0xAF, 0x01, 0x77, 0x50, 0xDF, 0xD0, 0x0A, 0xF0, 0x17, 0x75, 0x07, 0xFD, 0x00, 0xAF, 0x01,
  0x77, 0x50, 0x10, 0xEF, 0xC0, 0x0A, 0xF0, 0x17, 0x76, 0x08, 0xFC, 0x00, 0xAF, 0x01, 0x77, 0x60,
  0x2F, 0xC0, 0x0A, 0xF0, 0x17, 0x77, 0x0A, 0xFB, 0x00, 0xAF, 0x01, 0x77, 0x70, 0x3F, 0xB0, 0x0A,
  0xF0, 0x17, 0x77, 0x10, 0xCF, 0xA0, 0x0A, 0xF0, 0x17, 0x77, 0x10, 0x5F, 0xA0, 0xA0,
  // "ň" (U+0148)
  0x50, 0x18, 0x01, 0x70, 0x47, 0x74, 0x05, 0x80, 0x17, 0x01, 0x72, 0x02, 0xE0, 0x87, 0x71, 0x01,
  0x0A, 0xE0, 0x27, 0x30, 0x8E, 0x0C, 0x01, 0x75, 0x03, 0x0D, 0xE0, 0x87, 0x50, 0x9E, 0x0D, 0x03,
  0x73, 0x05, 0x0E, 0xE0, 0x87, 0x70, 0xAF, 0x05, 0x71, 0x07, 0xF0, 0x97, 0x72, 0x0B, 0xF0, 0x66,
  0x09, 0xF0, 0x97, 0x74, 0x0C, 0xF0, 0x74, 0x0A, 0xF0, 0xA7, 0x75, 0x01, 0x0D, 0xF0, 0x62, 0x0A,
  0xF0, 0xC7, 0x77, 0x02, 0x0E, 0xF0, 0x60, 0xBF, 0x0D, 0x01, 0x77, 0x71, 0x04, 0xFF, 0x90, 0xD0,
  0x17, 0x77, 0x30, 0x5F, 0xE0, 0xE0, 0x27, 0x77, 0x50, 0x8F, 0xD0, 0x57, 0x77, 0x70, 0xCF, 0xB0,
  0x87, 0x77, 0x71, 0x02, 0x0E, 0xF9, 0x0D, 0x77, 0x77, 0x30, 0x7F, 0x90, 0x48, 0x0B, 0xD1, 0x08,
  0x42, 0x69, 0xBD, 0xEA, 0x83, 0xED, 0xB8, 0x47, 0x40, 0xCD, 0x0B, 0x78, 0x11, 0x7D, 0xFE, 0x81,
  0xE9, 0x27, 0x10, 0xCD, 0x0E, 0x60, 0x70, 0xEF, 0xFC, 0x09, 0x70, 0xCE, 0x01, 0x30, 0x20, 0xDF,
  0xFF, 0x0D, 0x02, 0x50, 0xCE, 0x04, 0x20, 0x30, 0xEF, 0xFF, 0xA0, 0xE0, 0x34, 0x0C, 0xE8, 0x26,
  0x02, 0xEF, 0xFF, 0xC0, 0xE0, 0x13, 0x0C, 0xE8, 0x19, 0x0C, 0xF9, 0x85, 0xCA, 0x98, 0x9A, 0xCF,
  0xD0, 0xB3, 0x0C, 0xE0, 0xB0, 0x6E, 0x0A, 0x04, 0x72, 0x04, 0x0C, 0xFB, 0x05, 0x20, 0xCF, 0xD0,
  0xD0, 0x37, 0x60, 0x5F, 0xA0, 0xC2, 0x0C, 0xFC, 0x0B, 0x77, 0x20, 0x4F, 0xA8, 0x12, 0x0C, 0xFB,
  0x0C, 0x77, 0x40, 0x8F, 0x98, 0x17, 0x0C, 0xFB, 0x02, 0x77, 0x40, 0x1F, 0x98, 0x1B, 0x0C, 0xFA,
  0x0A, 0x77, 0x60, 0xAF, 0x81, 0xE0, 0xCF, 0xA0, 0x27, 0x76, 0x05, 0xF9, 0x10, 0xCF, 0x90, 0xB7,
  0x77, 0x02, 0xF9, 0x02, 0x0C, 0xF9, 0x07, 0x77, 0x71, 0xF9, 0x03, 0x0C, 0xF9, 0x02, 0x77, 0x71,
  0x0E, 0xF0, 0x30, 0xCF, 0x0E, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x0C, 0x77, 0x72, 0x0D, 0xF0,
  0x30, 0xCF, 0x09, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x07, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF,
  0x06, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x05, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x05, 0x77,
  0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D,
  0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30,
  0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04,
  0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72,
  0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0,
  0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF,
  0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77,
  0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D,
  0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30,
  0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04,
  0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72,
  0x0D, 0xF0, 0x30,
  // "ŉ" (U+0149)
  0x40, 0x2F, 0xA0, 0x78, 0x0C, 0x60, 0x04, 0xFA, 0x0A, 0x80, 0xC6, 0x00, 0x7F, 0xA0, 0x58, 0x0C,
  0x60, 0x09, 0xFA, 0x01, 0x80, 0xC6, 0x00, 0xCF, 0x90, 0xC8, 0x0C, 0x70, 0x0E, 0xF9, 0x08, 0x80,
  0xC6, 0x00, 0x2F, 0xA0, 0x38, 0x0C, 0x60, 0x05, 0xF9, 0x0D, 0x80, 0xC7, 0x00, 0x8F, 0x90, 0x78,
  0x0C, 0x70, 0x0B, 0xF9, 0x02, 0x80, 0xC7, 0x00, 0xEF, 0x0C, 0x80, 0xC7, 0x00, 0x2F, 0x90, 0x68,
  0x0C, 0x70, 0x05, 0xF9, 0x01, 0x80, 0xC7, 0x00, 0x9F, 0x09, 0x80, 0xD0, 0x00, 0xCF, 0x03, 0x80,
  0xD0, 0x0F, 0x0D, 0x77, 0x68, 0x93, 0x16, 0x9C, 0xDE, 0xFE, 0xDC, 0x96, 0x17, 0x40, 0x3F, 0x06,
  0x30, 0x7E, 0x01, 0x70, 0x50, 0xCF, 0xE0, 0xB0, 0x47, 0x20, 0x7E, 0x0E, 0x01, 0x30, 0x7E, 0x04,
  0x50, 0x30, 0xDF, 0xFB, 0x0B, 0x01, 0x70, 0xAE, 0x09, 0x40, 0x7E, 0x06, 0x40, 0x7F, 0xFE, 0x0E,
  0x04, 0x60, 0xEE, 0x02, 0x40, 0x7E, 0x08, 0x30, 0x8F, 0xFF, 0xA0, 0x44, 0x02, 0xE0, 0xB5, 0x07,
  0xE0, 0xB2, 0x06, 0xFF, 0xFC, 0x02, 0x30, 0x6E, 0x04, 0x50, 0x7E, 0x81, 0xD0, 0x2F, 0xFF, 0xD0,
  0xC7, 0x72, 0x07, 0xF1, 0x0B, 0xE8, 0x2B, 0x63, 0x12, 0x82, 0x13, 0x7B, 0xFC, 0x06, 0x77, 0x10,
  0x7F, 0x09, 0xD0, 0xA0, 0x27, 0x30, 0x40, 0xDF, 0xA0, 0xC7, 0x71, 0x07, 0xFD, 0x06, 0x76, 0x01,
  0x0B, 0xFA, 0x03, 0x77, 0x07, 0xFC, 0x06, 0x77, 0x10, 0x10, 0xDF, 0x90, 0x77, 0x70, 0x7F, 0xB0,
  0xA7, 0x73, 0x04, 0xF9, 0x0B, 0x77, 0x07, 0xFB, 0x02, 0x77, 0x40, 0xDF, 0x0E, 0x77, 0x07, 0xFA,
  0x09, 0x77, 0x50, 0x7F, 0x97, 0x70, 0x7F, 0xA0, 0x37, 0x75, 0x04, 0xF9, 0x02, 0x76, 0x07, 0xF9,
  0x0D, 0x77, 0x60, 0x1F, 0x90, 0x37, 0x60, 0x7F, 0x90, 0x97, 0x77, 0xF9, 0x03, 0x76, 0x07, 0xF9,
  0x05, 0x77, 0x70, 0xEF, 0x03, 0x76, 0x07, 0xF9, 0x02, 0x77, 0x70, 0xDF, 0x03, 0x76, 0x07, 0xF9,
  0x77, 0x71, 0x0D, 0xF0, 0x37, 0x60, 0x7F, 0x0D, 0x77, 0x71, 0x0D, 0xF0, 0x37, 0x60, 0x7F, 0x0C,
  0x77, 0x71, 0x0D, 0xF0, 0x37, 0x60, 0x7F, 0x0B, 0x77, 0x71, 0x0D, 0xF0, 0x37, 0x60, 0x7F, 0x0A,
  0x77, 0x71, 0x0D, 0xF0, 0x37, 0x60, 0x7F, 0x0A, 0x77, 0x71, 0x0D, 0xF0, 0x37, 0x60, 0x7F, 0x0A,
  0x77, 0x71, 0x0D, 0xF0, 0x37, 0x60, 0x7F, 0x0A, 0x77, 0x71, 0x0D, 0xF0, 0x37, 0x60, 0x7F, 0x0A,
  0x77, 0x71, 0x0D, 0xF0, 0x37, 0x60, 0x7F, 0x0A, 0x77, 0x71, 0x0D, 0xF0, 0x37, 0x60, 0x7F, 0x0A,
  0x77, 0x71, 0x0D, 0xF0, 0x37, 0x60, 0x7F, 0x0A, 0x77, 0x71, 0x0D, 0xF0, 0x37, 0x60, 0x7F, 0x0A,
  0x77, 0x71, 0x0D, 0xF0, 0x37, 0x60, 0x7F, 0x0A, 0x77, 0x71, 0x0D, 0xF0, 0x37, 0x60, 0x7F, 0x0A,
  0x77, 0x71, 0x0D, 0xF0, 0x37, 0x60, 0x7F, 0x0A, 0x77, 0x71, 0x0D, 0xF0, 0x37, 0x60, 0x7F, 0x0A,
  0x77, 0x71, 0x0D, 0xF0, 0x37, 0x60, 0x7F, 0x0A, 0x77, 0x71, 0x0D, 0xF0, 0x37, 0x60, 0x7F, 0x0A,
  0x77, 0x71, 0x0D, 0xF0, 0x37, 0x60, 0x7F, 0x0A, 0x77, 0x71, 0x0D, 0xF0, 0x37, 0x60, 0x7F, 0x0A,
  0x77, 0x71, 0x0D, 0xF0, 0x37, 0x60, 0x7F, 0x0A, 0x77, 0x71, 0x0D, 0xF0, 0x37, 0x60, 0x7F, 0x0A,
  0x77, 0x71, 0x0D, 0xF0, 0x37, 0x60, 0x7F, 0x0A, 0x77, 0x71, 0x0D, 0xF0, 0x37, 0x60, 0x7F, 0x0A,
  0x77, 0x71, 0x0D, 0xF0, 0x37, 0x60, 0x7F, 0x0A, 0x77, 0x71, 0x0D, 0xF0, 0x37, 0x60, 0x7F, 0x0A,
  0x77, 0x71, 0x0D, 0xF0, 0x37, 0x60, 0x7F, 0x0A, 0x77, 0x71, 0x0D, 0xF0, 0x37, 0x60, 0x7F, 0x0A,
  0x77, 0x71, 0x0D, 0xF0, 0x37, 0x60, 0x7F, 0x0A, 0x77, 0x71, 0x0D, 0xF0, 0x30,
  // "Ŋ" (U+014A)
  0x0A, 0xFB, 0x03, 0x77, 0x70, 0x1F, 0x00, 0xAF, 0xB0, 0xA7, 0x77, 0x01, 0xF0, 0x0A, 0xFC, 0x01,
  0x77, 0x60, 0x1F, 0x00, 0xAF, 0xC0, 0x87, 0x76, 0x01, 0xF0, 0x0A, 0xFC, 0x0E, 0x77, 0x60, 0x1F,
  0x00, 0xAF, 0xD0, 0x67, 0x75, 0x01, 0xF0, 0x0A, 0xFD, 0x0D, 0x77, 0x50, 0x1F, 0x00, 0xAF, 0xE0,
  0x47, 0x74, 0x01, 0xF0, 0x0A, 0xFE, 0x0B, 0x77, 0x40, 0x1F, 0x00, 0xAE, 0x07, 0xF0, 0x27, 0x73,
  0x01, 0xF0, 0x0A, 0xE0, 0x20, 0xEE, 0x09, 0x77, 0x30, 0x1F, 0x00, 0xAE, 0x02, 0x09, 0xF0, 0x17,
  0x72, 0x01, 0xF0, 0x0A, 0xE0, 0x30, 0x2F, 0x07, 0x77, 0x20, 0x1F, 0x00, 0xAE, 0x81, 0x40, 0xAE,
  0x0D, 0x77, 0x20, 0x1F, 0x00, 0xAE, 0x81, 0x60, 0x3F, 0x05, 0x77, 0x10, 0x1F, 0x00, 0xAE, 0x07,
  0x20, 0xCE, 0x0C, 0x77, 0x10, 0x1F, 0x00, 0xAE, 0x08, 0x20, 0x5F, 0x03, 0x77, 0x01, 0xF0, 0x0A,
  0xE0, 0x93, 0x0D, 0xE0, 0xA7, 0x70, 0x1F, 0x00, 0xAE, 0x0B, 0x30, 0x7F, 0x01, 0x76, 0x01, 0xF0,
  0x0A, 0xE0, 0xC3, 0x01, 0x0E, 0xE0, 0x87, 0x60, 0x1F, 0x00, 0xAE, 0x0D, 0x40, 0x8E, 0x0E, 0x76,
  0x01, 0xF0, 0x0A, 0xE0, 0xE4, 0x02, 0xF0, 0x67, 0x50, 0x1F, 0x00, 0xAE, 0x0E, 0x50, 0xAE, 0x0D,
  0x75, 0x01, 0xF0, 0x0A, 0xF5, 0x03, 0xF0, 0x47, 0x40, 0x1F, 0x00, 0xAF, 0x60, 0xCE, 0x0B, 0x74,
  0x01, 0xF0, 0x0A, 0xF0, 0x15, 0x05, 0xF0, 0x27, 0x30, 0x1F, 0x00, 0xAF, 0x01, 0x60, 0xDE, 0x09,
  0x73, 0x01, 0xF0, 0x0A, 0xF0, 0x16, 0x06, 0xE0, 0xE0, 0x17, 0x20, 0x1F, 0x00, 0xAF, 0x01, 0x70,
  0xEE, 0x07, 0x72, 0x01, 0xF0, 0x0A, 0xF0, 0x17, 0x08, 0xE0, 0xD7, 0x20, 0x1F, 0x00, 0xAF, 0x01,
  0x70, 0x1F, 0x05, 0x71, 0x01, 0xF0, 0x0A, 0xF0, 0x17, 0x10, 0xAE, 0x0C, 0x71, 0x01, 0xF0, 0x0A,
  0xF0, 0x17, 0x10, 0x3F, 0x03, 0x70, 0x1F, 0x00, 0xAF, 0x01, 0x72, 0x0B, 0xE0, 0xA7, 0x01, 0xF0,
  0x0A, 0xF0, 0x17, 0x20, 0x4F, 0x01, 0x60, 0x1F, 0x00, 0xAF, 0x01, 0x73, 0x0D, 0xE0, 0x86, 0x01,
  0xF0, 0x0A, 0xF0, 0x17, 0x30, 0x6E, 0x0E, 0x60, 0x1F, 0x00, 0xAF, 0x01, 0x74, 0x0E, 0xE0, 0x65,
  0x01, 0xF0, 0x0A, 0xF0, 0x17, 0x40, 0x8E, 0x0D, 0x50, 0x1F, 0x00, 0xAF, 0x01, 0x74, 0x01, 0xF0,
  0x44, 0x01, 0xF0, 0x0A, 0xF0, 0x17, 0x50, 0x9E, 0x0B, 0x5F, 0x00, 0xAF, 0x01, 0x75, 0x02, 0xF0,
  0x24, 0xF0, 0x0A, 0xF0, 0x17, 0x60, 0xBE, 0x09, 0x4F, 0x00, 0xAF, 0x01, 0x76, 0x04, 0xE0, 0xE0,
  0x13, 0xF0, 0x0A, 0xF0, 0x17, 0x70, 0xCE, 0x07, 0x30, 0xEE, 0x00, 0xAF, 0x01, 0x77, 0x05, 0xE0,
  0xD3, 0x0D, 0xE0, 0x0A, 0xF0, 0x17, 0x71, 0x0E, 0xE0, 0x52, 0x0C, 0xE0, 0x0A, 0xF0, 0x17, 0x71,
  0x07, 0xE0, 0xC2, 0x0B, 0xE0, 0x0A, 0xF0, 0x17, 0x71, 0x01, 0x0E, 0xE8, 0x13, 0x0A, 0xE0, 0x0A,
  0xF0, 0x17, 0x72, 0x09, 0xE8, 0x1A, 0x09, 0xE0, 0x0A, 0xF0, 0x17, 0x72, 0x02, 0xF0, 0x10, 0x8E,
  0x00, 0xAF, 0x01, 0x77, 0x30, 0xAE, 0x08, 0x07, 0xE0, 0x0A, 0xF0, 0x17, 0x73, 0x03, 0xE0, 0xE0,
  0x6E, 0x00, 0xAF, 0x01, 0x77, 0x40, 0xCE, 0x0C, 0xE0, 0x0A, 0xF0, 0x17, 0x74, 0x05, 0xFE, 0x00,
  0xAF, 0x01, 0x77, 0x50, 0xDF, 0xD0, 0x0A, 0xF0, 0x17, 0x75, 0x07, 0xFD, 0x00, 0xAF, 0x01, 0x77,
  0x50, 0x10, 0xEF, 0xC0, 0x0A, 0xF0, 0x17, 0x76, 0x08, 0xFC, 0x00, 0xAF, 0x01, 0x77, 0x60, 0x2F,
  0xC0, 0x0A, 0xF0, 0x17, 0x77, 0x0A, 0xFB, 0x00, 0xAF, 0x01, 0x77, 0x70, 0x3F, 0xB0, 0x0A, 0xF0,
  0x17, 0x77, 0x10, 0xCF, 0xA0, 0x0A, 0xF0, 0x17, 0x77, 0x10, 0x5F, 0xA0, 0xA7, 0x77, 0x76, 0x0D,
  0xE0, 0xA7, 0x77, 0x76, 0x0E, 0xE0, 0x97, 0x77, 0x76, 0xF0, 0x77, 0x77, 0x75, 0x03, 0xF0, 0x57,
  0x77, 0x75, 0x08, 0xF0, 0x27, 0x77, 0x75, 0x0E, 0xE0, 0xE7, 0x77, 0x75, 0x08, 0xF0, 0x97, 0x77,
  0x74, 0x06, 0xF9, 0x04, 0x77, 0x77, 0x20, 0x10, 0x9F, 0x90, 0xD7, 0x76, 0x83, 0xB8, 0x53, 0x12,
  0x83, 0x12, 0x6A, 0xEF, 0xA0, 0x47, 0x75, 0x01, 0xFF, 0xE0, 0xA7, 0x76, 0x01, 0xFF, 0xD0, 0xC7,
  0x77, 0x01, 0xFF, 0xC0, 0xC0, 0x17, 0x77, 0x01, 0xFF, 0xB0, 0x97, 0x77, 0x20, 0x1F, 0xF9, 0x0B,
  0x03, 0x77, 0x74, 0x0A, 0x0E, 0xFB, 0x81, 0xD8, 0x37, 0x77, 0x71, 0x89, 0x02, 0x57, 0x78, 0x87,
  0x64, 0x17, 0x50,
  // "ŋ" (U+014B)
  0x77, 0x38, 0x42, 0x69, 0xBD, 0xEA, 0x83, 0xED, 0xB8, 0x47, 0x40, 0xCD, 0x0B, 0x78, 0x11, 0x7D,
  0xFE, 0x81, 0xE9, 0x27, 0x10, 0xCD, 0x0E, 0x60, 0x70, 0xEF, 0xFC, 0x09, 0x70, 0xCE, 0x01, 0x30,
  0x20, 0xDF, 0xFF, 0x0D, 0x02, 0x50, 0xCE, 0x04, 0x20, 0x30, 0xEF, 0xFF, 0xA0, 0xE0, 0x34, 0x0C,
  0xE8, 0x26, 0x02, 0xEF, 0xFF, 0xC0, 0xE0, 0x13, 0x0C, 0xE8, 0x19, 0x0C, 0xF9, 0x85, 0xCA, 0x98,
  0x9A, 0xCF, 0xD0, 0xB3, 0x0C, 0xE0, 0xB0, 0x6E, 0x0A, 0x04, 0x72, 0x04, 0x0C, 0xFB, 0x04, 0x20,
  0xCF, 0xD0, 0xD0, 0x37, 0x60, 0x6F, 0xA0, 0xB2, 0x0C, 0xFC, 0x0B, 0x77, 0x20, 0x4F, 0xA8, 0x12,
  0x0C, 0xFB, 0x0C, 0x77, 0x40, 0x9F, 0x98, 0x17, 0x0C, 0xFB, 0x02, 0x77, 0x40, 0x1F, 0x98, 0x1A,
  0x0C, 0xFA, 0x0A, 0x77, 0x60, 0xAF, 0x81, 0xD0, 0xCF, 0xA0, 0x27, 0x76, 0x06, 0xF9, 0x10, 0xCF,
  0x90, 0xB7, 0x77, 0x03, 0xF9, 0x02, 0x0C, 0xF9, 0x07, 0x77, 0x71, 0xF9, 0x03, 0x0C, 0xF9, 0x02,
  0x77, 0x71, 0x0E, 0xF0, 0x30, 0xCF, 0x0E, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x0C, 0x77, 0x72,
  0x0D, 0xF0, 0x30, 0xCF, 0x09, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x07, 0x77, 0x72, 0x0D, 0xF0,
  0x30, 0xCF, 0x06, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x05, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF,
  0x05, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77,
  0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D,
  0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30,
  0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04,
  0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72,
  0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0,
  0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF,
  0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77,
  0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D,
  0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30,
  0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0x30, 0xCF, 0x04,
  0x77, 0x72, 0x0D, 0xF0, 0x37, 0x77, 0x74, 0x0D, 0xF0, 0x37, 0x77, 0x74, 0x0D, 0xF0, 0x37, 0x77,
  0x74, 0x0D, 0xF0, 0x37, 0x77, 0x74, 0x0D, 0xF0, 0x37, 0x77, 0x74, 0x0D, 0xF0, 0x37, 0x77, 0x74,
  0x0D, 0xF0, 0x37, 0x77, 0x74, 0x0D, 0xF0, 0x37, 0x77, 0x74, 0x0D, 0xF0, 0x37, 0x77, 0x74, 0x0D,
  0xF0, 0x27, 0x77, 0x74, 0x0E, 0xF0, 0x17, 0x77, 0x73, 0x01, 0xF9, 0x77, 0x77, 0x40, 0x4F, 0x0D,
  0x77, 0x77, 0x40, 0x9F, 0x0A, 0x77, 0x77, 0x30, 0x3F, 0x90, 0x77, 0x77, 0x01, 0x04, 0x70, 0x60,
  0xEF, 0x90, 0x17, 0x77, 0x02, 0xA8, 0x4C, 0x98, 0x8A, 0xEF, 0xA0, 0xA7, 0x77, 0x10, 0x2F, 0xFB,
  0x02, 0x77, 0x71, 0x02, 0xFF, 0xA0, 0x77, 0x77, 0x20, 0x2F, 0xF9, 0x0A, 0x77, 0x73, 0x02, 0xFF,
  0x09, 0x77, 0x74, 0x02, 0xFD, 0x0B, 0x03, 0x77, 0x76, 0x83, 0x26, 0xAC, 0xEA, 0x83, 0xEC, 0xA6,
  0x27, 0x10,
  // "Ō" (U+014C)
  0x72, 0x02, 0x80, 0xA6, 0x80, 0x37, 0x74, 0x04, 0xFF, 0xFD, 0x06, 0x77, 0x40, 0x4F, 0xFF, 0xD0,
  0x67, 0x74, 0x04, 0xFF, 0xFD, 0x06, 0x77, 0x40, 0x4F, 0xFF, 0xD0, 0x67, 0x74, 0x04, 0xFF, 0xFD,
  0x06, 0x77, 0x40, 0x4F, 0xFF, 0xD0, 0x68, 0x0C, 0xD1, 0x08, 0x42, 0x69, 0xBD, 0xEA, 0x84, 0xED,
  0xB9, 0x62, 0x77, 0x77, 0x18, 0x11, 0x7D, 0xFF, 0x81, 0xD8, 0x17, 0x77, 0x30, 0x10, 0x8F, 0xFE,
  0x09, 0x01, 0x77, 0x70, 0x40, 0xEF, 0xFF, 0x90, 0xE0, 0x47, 0x75, 0x07, 0xFF, 0xFD, 0x07, 0x77,
  0x30, 0x7F, 0xFF, 0xF0, 0x87, 0x71, 0x07, 0xFF, 0xFF, 0xA0, 0x87, 0x60, 0x4F, 0xC8, 0x2B, 0x63,
  0x12, 0x83, 0x12, 0x59, 0xEF, 0xB0, 0x47, 0x40, 0x10, 0xEF, 0xA0, 0x90, 0x17, 0x40, 0x70, 0xEF,
  0x90, 0xE0, 0x27, 0x30, 0xAF, 0x90, 0xE0, 0x37, 0x70, 0x20, 0xCF, 0x90, 0xB7, 0x20, 0x3F, 0x90,
  0xD0, 0x27, 0x72, 0x01, 0x0C, 0xF9, 0x04, 0x71, 0x0C, 0xF9, 0x03, 0x77, 0x40, 0x10, 0xEF, 0x0C,
  0x70, 0x4F, 0x90, 0x77, 0x76, 0x05, 0xF9, 0x05, 0x60, 0xAF, 0x0D, 0x77, 0x71, 0x0C, 0xF0, 0xB5,
  0x01, 0xF9, 0x06, 0x77, 0x71, 0x04, 0xF9, 0x01, 0x40, 0x7F, 0x0E, 0x77, 0x73, 0x0D, 0xF0, 0x74,
  0x0C, 0xF0, 0x97, 0x77, 0x30, 0x8F, 0x0C, 0x4F, 0x90, 0x47, 0x77, 0x30, 0x3F, 0x90, 0x12, 0x04,
  0xF9, 0x77, 0x75, 0x0E, 0xF0, 0x52, 0x08, 0xF0, 0xB7, 0x77, 0x50, 0xAF, 0x09, 0x20, 0xBF, 0x07,
  0x77, 0x75, 0x07, 0xF0, 0xC2, 0x0E, 0xF0, 0x47, 0x77, 0x50, 0x3F, 0x81, 0xE0, 0x1F, 0x90, 0x17,
  0x77, 0x50, 0x1F, 0x90, 0x20, 0x4F, 0x0E, 0x77, 0x77, 0x0E, 0xF0, 0x50, 0x6F, 0x0C, 0x77, 0x77,
  0x0C, 0xF0, 0x60, 0x8F, 0x0B, 0x77, 0x77, 0x0A, 0xF0, 0x80, 0x9F, 0x09, 0x77, 0x77, 0x09, 0xF0,
  0x90, 0xBF, 0x08, 0x77, 0x77, 0x08, 0xF0, 0xB0, 0xCF, 0x07, 0x77, 0x77, 0x07, 0xF0, 0xC0, 0xDF,
  0x06, 0x77, 0x77, 0x06, 0xF0, 0x0D, 0xF0, 0x57, 0x77, 0x70, 0x5F, 0x0D, 0x0E, 0xF0, 0x57, 0x77,
  0x70, 0x5F, 0x00, 0xEF, 0x05, 0x77, 0x77, 0x05, 0xF0, 0x0E, 0xF0, 0x57, 0x77, 0x70, 0x5F, 0x00,
  0xEF, 0x05, 0x77, 0x77, 0x05, 0xF0, 0xE0, 0xDF, 0x05, 0x77, 0x77, 0x05, 0xF0, 0x0D, 0xF0, 0x67,
  0x77, 0x70, 0x6F, 0x0D, 0x0C, 0xF0, 0x77, 0x77, 0x70, 0x7F, 0x0C, 0x0B, 0xF0, 0x87, 0x77, 0x70,
  0x8F, 0x0B, 0x09, 0xF0, 0x97, 0x77, 0x70, 0x9F, 0x09, 0x08, 0xF0, 0xA7, 0x77, 0x70, 0xAF, 0x08,
  0x06, 0xF0, 0xC7, 0x77, 0x70, 0xCF, 0x06, 0x04, 0xF0, 0xE7, 0x77, 0x70, 0xEF, 0x04, 0x02, 0xF9,
  0x01, 0x77, 0x75, 0x01, 0xF9, 0x81, 0x10, 0xEF, 0x04, 0x77, 0x75, 0x04, 0xF0, 0xE2, 0x0C, 0xF0,
  0x77, 0x77, 0x50, 0x7F, 0x0B, 0x20, 0x9F, 0x0B, 0x77, 0x75, 0x0A, 0xF0, 0x82, 0x05, 0xF0, 0xE7,
  0x77, 0x50, 0xEF, 0x04, 0x20, 0x1F, 0x90, 0x47, 0x77, 0x30, 0x3F, 0x94, 0x0C, 0xF0, 0x97, 0x77,
  0x30, 0x8F, 0x0B, 0x40, 0x7F, 0x0E, 0x77, 0x73, 0x0D, 0xF0, 0x64, 0x01, 0xF9, 0x06, 0x77, 0x71,
  0x05, 0xF9, 0x01, 0x50, 0xBF, 0x0D, 0x77, 0x71, 0x0C, 0xF0, 0xA6, 0x05, 0xF9, 0x06, 0x77, 0x60,
  0x5F, 0x90, 0x47, 0x0D, 0xF9, 0x02, 0x77, 0x40, 0x10, 0xEF, 0x0B, 0x71, 0x04, 0xF9, 0x0D, 0x02,
  0x77, 0x20, 0x10, 0xCF, 0x90, 0x37, 0x20, 0xBF, 0x90, 0xD0, 0x37, 0x70, 0x20, 0xCF, 0x90, 0xA7,
  0x30, 0x20, 0xEF, 0xA0, 0x80, 0x17, 0x40, 0x70, 0xEF, 0x90, 0xD0, 0x17, 0x40, 0x5F, 0xC8, 0x2A,
  0x63, 0x12, 0x83, 0x12, 0x5A, 0xEF, 0xB0, 0x37, 0x60, 0x8F, 0xFF, 0xFA, 0x06, 0x77, 0x10, 0x8F,
  0xFF, 0xF0, 0x67, 0x73, 0x08, 0xFF, 0xFD, 0x06, 0x77, 0x50, 0x50, 0xEF, 0xFF, 0x90, 0xD0, 0x37,
  0x77, 0x01, 0x09, 0xFF, 0xD0, 0xE0, 0x87, 0x77, 0x48, 0x12, 0x8E, 0xFF, 0x81, 0xD7, 0x17, 0x77,
  0x71, 0x84, 0x37, 0x9C, 0xDE, 0xA8, 0x4E, 0xDB, 0x96, 0x27, 0x72,
  // "ō" (U+014D)
  0x71, 0x02, 0x80, 0xA6, 0x80, 0x37, 0x72, 0x04, 0xFF, 0xFD, 0x06, 0x77, 0x20, 0x4F, 0xFF, 0xD0,
  0x67, 0x72, 0x04, 0xFF, 0xFD, 0x06, 0x77, 0x20, 0x4F, 0xFF, 0xD0, 0x67, 0x72, 0x04, 0xFF, 0xFD,
  0x06, 0x77, 0x20, 0x4F, 0xFF, 0xD0, 0x68, 0x0C, 0xB3, 0x08, 0x94, 0x36, 0x9C, 0xDE, 0xFE, 0xED,
  0xB8, 0x51, 0x77, 0x76, 0x81, 0x28, 0xDF, 0xF8, 0x1C, 0x71, 0x77, 0x71, 0x03, 0x0A, 0xFF, 0xD8,
  0x1E, 0x81, 0x77, 0x50, 0x8F, 0xFF, 0xA0, 0xE0, 0x57, 0x72, 0x02, 0x0D, 0xFF, 0xFD, 0x0B, 0x77,
  0x03, 0x0E, 0xFF, 0xFF, 0x0C, 0x01, 0x74, 0x02, 0x0E, 0xFC, 0x86, 0xDB, 0x98, 0x89, 0xBE, 0xFC,
  0x0D, 0x01, 0x72, 0x01, 0x0D, 0xFA, 0x81, 0xD7, 0x27, 0x18, 0x13, 0x8E, 0xFA, 0x0B, 0x72, 0x0B,
  0xFA, 0x07, 0x76, 0x01, 0x09, 0xFA, 0x08, 0x70, 0x5F, 0x90, 0xE0, 0x37, 0x72, 0x06, 0xFA, 0x03,
  0x60, 0xDF, 0x90, 0x37, 0x74, 0x05, 0xF9, 0x0C, 0x50, 0x6F, 0x90, 0x67, 0x76, 0x09, 0xF9, 0x05,
  0x40, 0xDF, 0x0C, 0x77, 0x70, 0x10, 0xEF, 0x0B, 0x30, 0x4F, 0x90, 0x47, 0x77, 0x10, 0x7F, 0x90,
  0x32, 0x09, 0xF0, 0xC7, 0x77, 0x30, 0xEF, 0x08, 0x20, 0xDF, 0x06, 0x77, 0x73, 0x09, 0xF8, 0x1C,
  0x02, 0xF9, 0x01, 0x77, 0x73, 0x04, 0xF9, 0x01, 0x05, 0xF0, 0xC7, 0x77, 0x50, 0xEF, 0x05, 0x08,
  0xF0, 0x97, 0x77, 0x50, 0xCF, 0x07, 0x0A, 0xF0, 0x67, 0x77, 0x50, 0x9F, 0x09, 0x0C, 0xF0, 0x37,
  0x77, 0x50, 0x6F, 0x0C, 0x0E, 0xF0, 0x27, 0x77, 0x50, 0x5F, 0x0D, 0x0E, 0xF0, 0x17, 0x77, 0x50,
  0x4F, 0x0E, 0xF9, 0x77, 0x76, 0x03, 0xFF, 0xA7, 0x77, 0x60, 0x2F, 0xFA, 0x77, 0x76, 0x02, 0xFF,
  0xA7, 0x77, 0x60, 0x3F, 0x90, 0xEF, 0x01, 0x77, 0x75, 0x04, 0xF0, 0xE0, 0xDF, 0x02, 0x77, 0x75,
  0x05, 0xF0, 0xD0, 0xCF, 0x04, 0x77, 0x75, 0x07, 0xF0, 0xC0, 0x9F, 0x07, 0x77, 0x75, 0x09, 0xF0,
  0xA0, 0x7F, 0x09, 0x77, 0x75, 0x0C, 0xF0, 0x70, 0x4F, 0x0C, 0x77, 0x75, 0xF9, 0x05, 0x01, 0xF9,
  0x02, 0x77, 0x73, 0x04, 0xF9, 0x81, 0x10, 0xCF, 0x07, 0x77, 0x73, 0x0A, 0xF0, 0xD2, 0x07, 0xF0,
  0xD7, 0x77, 0x30, 0xEF, 0x08, 0x20, 0x2F, 0x90, 0x57, 0x77, 0x10, 0x7F, 0x90, 0x33, 0x0B, 0xF0,
  0xD7, 0x77, 0x01, 0x0E, 0xF0, 0xC4, 0x04, 0xF9, 0x08, 0x77, 0x60, 0x9F, 0x90, 0x55, 0x0B, 0xF9,
  0x04, 0x77, 0x40, 0x5F, 0x90, 0xD6, 0x02, 0xFA, 0x05, 0x77, 0x20, 0x5F, 0xA0, 0x37, 0x08, 0xFA,
  0x09, 0x01, 0x75, 0x01, 0x09, 0xFA, 0x09, 0x72, 0x0B, 0xFA, 0x81, 0xE8, 0x27, 0x18, 0x12, 0x8E,
  0xFA, 0x0C, 0x73, 0x01, 0x0D, 0xFC, 0x86, 0xEB, 0x98, 0x89, 0xBE, 0xFC, 0x0E, 0x01, 0x74, 0x01,
  0x0C, 0xFF, 0xFF, 0x0D, 0x02, 0x77, 0x0B, 0xFF, 0xFD, 0x0C, 0x01, 0x77, 0x20, 0x60, 0xEF, 0xFF,
  0xA0, 0x77, 0x75, 0x01, 0x09, 0xFF, 0xE0, 0xA0, 0x27, 0x77, 0x18, 0x11, 0x7C, 0xFF, 0x81, 0xD8,
  0x27, 0x77, 0x68, 0x41, 0x58, 0xBD, 0xEA, 0x84, 0xED, 0xB9, 0x62, 0x77, 0x10,
  // "Ŏ" (U+014E)
  0x72, 0x0D, 0xC0, 0x67, 0x72, 0x06, 0xD7, 0x74, 0x0C, 0xC0, 0xB7, 0x72, 0x0B, 0xC0, 0xD7, 0x74,
  0x09, 0xD0, 0x47, 0x70, 0x3D, 0x0B, 0x77, 0x40, 0x5D, 0x0D, 0x02, 0x75, 0x01, 0x0C, 0xD0, 0x67,
  0x75, 0x0E, 0xD0, 0xE0, 0x57, 0x30, 0x30, 0xDE, 0x01, 0x77, 0x50, 0x7F, 0x82, 0xD7, 0x41, 0x28,
  0x21, 0x37, 0xCF, 0x09, 0x77, 0x70, 0xDF, 0xFF, 0x90, 0xE0, 0x17, 0x77, 0x03, 0x0E, 0xFF, 0xF0,
  0x37, 0x77, 0x20, 0x40, 0xEF, 0xFC, 0x0E, 0x04, 0x77, 0x74, 0x02, 0x0D, 0xFF, 0xA0, 0xC0, 0x27,
  0x77, 0x70, 0x60, 0xDF, 0xD0, 0xC0, 0x57, 0x77, 0x74, 0x89, 0x23, 0x7B, 0xDE, 0xFE, 0xDC, 0xA6,
  0x38, 0x0C, 0x83, 0x08, 0x42, 0x69, 0xBD, 0xEA, 0x84, 0xED, 0xB9, 0x62, 0x77, 0x77, 0x18, 0x11,
  0x7D, 0xFF, 0x81, 0xD8, 0x17, 0x77, 0x30, 0x10, 0x8F, 0xFE, 0x09, 0x01, 0x77, 0x70, 0x40, 0xEF,
  0xFF, 0x90, 0xE0, 0x47, 0x75, 0x07, 0xFF, 0xFD, 0x07, 0x77, 0x30, 0x7F, 0xFF, 0xF0, 0x87, 0x71,
  0x07, 0xFF, 0xFF, 0xA0, 0x87, 0x60, 0x4F, 0xC8, 0x2B, 0x63, 0x12, 0x83, 0x12, 0x59, 0xEF, 0xB0,
  0x47, 0x40, 0x10, 0xEF, 0xA0, 0x90, 0x17, 0x40, 0x70, 0xEF, 0x90, 0xE0, 0x27, 0x30, 0xAF, 0x90,
  0xE0, 0x37, 0x70, 0x20, 0xCF, 0x90, 0xB7, 0x20, 0x3F, 0x90, 0xD0, 0x27, 0x72, 0x01, 0x0C, 0xF9,
  0x04, 0x71, 0x0C, 0xF9, 0x03, 0x77, 0x40, 0x10, 0xEF, 0x0C, 0x70, 0x4F, 0x90, 0x77, 0x76, 0x05,
  0xF9, 0x05, 0x60, 0xAF, 0x0D, 0x77, 0x71, 0x0C, 0xF0, 0xB5, 0x01, 0xF9, 0x06, 0x77, 0x71, 0x04,
  0xF9, 0x01, 0x40, 0x7F, 0x0E, 0x77, 0x73, 0x0D, 0xF0, 0x74, 0x0C, 0xF0, 0x97, 0x77, 0x30, 0x8F,
  0x0C, 0x4F, 0x90, 0x47, 0x77, 0x30, 0x3F, 0x90, 0x12, 0x04, 0xF9, 0x77, 0x75, 0x0E, 0xF0, 0x52,
  0x08, 0xF0, 0xB7, 0x77, 0x50, 0xAF, 0x09, 0x20, 0xBF, 0x07, 0x77, 0x75, 0x07, 0xF0, 0xC2, 0x0E,
  0xF0, 0x47, 0x77, 0x50, 0x3F, 0x81, 0xE0, 0x1F, 0x90, 0x17, 0x77, 0x50, 0x1F, 0x90, 0x20, 0x4F,
  0x0E, 0x77, 0x77, 0x0E, 0xF0, 0x50, 0x6F, 0x0C, 0x77, 0x77, 0x0C, 0xF0, 0x60, 0x8F, 0x0B, 0x77,
  0x77, 0x0A, 0xF0, 0x80, 0x9F, 0x09, 0x77, 0x77, 0x09, 0xF0, 0x90, 0xBF, 0x08, 0x77, 0x77, 0x08,
  0xF0, 0xB0, 0xCF, 0x07, 0x77, 0x77, 0x07, 0xF0, 0xC0, 0xDF, 0x06, 0x77, 0x77, 0x06, 0xF0, 0x0D,
  0xF0, 0x57, 0x77, 0x70, 0x5F, 0x0D, 0x0E, 0xF0, 0x57, 0x77, 0x70, 0x5F, 0x00, 0xEF, 0x05, 0x77,
  0x77, 0x05, 0xF0, 0x0E, 0xF0, 0x57, 0x77, 0x70, 0x5F, 0x00, 0xEF, 0x05, 0x77, 0x77, 0x05, 0xF0,
  0xE0, 0xDF, 0x05, 0x77, 0x77, 0x05, 0xF0, 0x0D, 0xF0, 0x67, 0x77, 0x70, 0x6F, 0x0D, 0x0C, 0xF0,
  0x77, 0x77, 0x70, 0x7F, 0x0C, 0x0B, 0xF0, 0x87, 0x77, 0x70, 0x8F, 0x0B, 0x09, 0xF0, 0x97, 0x77,
  0x70, 0x9F, 0x09, 0x08, 0xF0, 0xA7, 0x77, 0x70, 0xAF, 0x08, 0x06, 0xF0, 0xC7, 0x77, 0x70, 0xCF,
  0x06, 0x04, 0xF0, 0xE7, 0x77, 0x70, 0xEF, 0x04, 0x02, 0xF9, 0x01, 0x77, 0x75, 0x01, 0xF9, 0x81,
  0x10, 0xEF, 0x04, 0x77, 0x75, 0x04, 0xF0, 0xE2, 0x0C, 0xF0, 0x77, 0x77, 0x50, 0x7F, 0x0B, 0x20,
  0x9F, 0x0B, 0x77, 0x75, 0x0A, 0xF0, 0x82, 0x05, 0xF0, 0xE7, 0x77, 0x50, 0xEF, 0x04, 0x20, 0x1F,
  0x90, 0x47, 0x77, 0x30, 0x3F, 0x94, 0x0C, 0xF0, 0x97, 0x77, 0x30, 0x8F, 0x0B, 0x40, 0x7F, 0x0E,
  0x77, 0x73, 0x0D, 0xF0, 0x64, 0x01, 0xF9, 0x06, 0x77, 0x71, 0x05, 0xF9, 0x01, 0x50, 0xBF, 0x0D,
  0x77, 0x71, 0x0C, 0xF0, 0xA6, 0x05, 0xF9, 0x06, 0x77, 0x60, 0x5F, 0x90, 0x47, 0x0D, 0xF9, 0x02,
  0x77, 0x40, 0x10, 0xEF, 0x0B, 0x71, 0x04, 0xF9, 0x0D, 0x02, 0x77, 0x20, 0x10, 0xCF, 0x90, 0x37,
  0x20, 0xBF, 0x90, 0xD0, 0x37, 0x70, 0x20, 0xCF, 0x90, 0xA7, 0x30, 0x20, 0xEF, 0xA0, 0x80, 0x17,
  0x40, 0x70, 0xEF, 0x90, 0xD0, 0x17, 0x40, 0x5F, 0xC8, 0x2A, 0x63, 0x12, 0x83, 0x12, 0x5A, 0xEF,
  0xB0, 0x37, 0x60, 0x8F, 0xFF, 0xFA, 0x06, 0x77, 0x10, 0x8F, 0xFF, 0xF0, 0x67, 0x73, 0x08, 0xFF,
  0xFD, 0x06, 0x77, 0x50, 0x50, 0xEF, 0xFF, 0x90, 0xD0, 0x37, 0x77, 0x01, 0x09, 0xFF, 0xD0, 0xE0,
  0x87, 0x77, 0x48, 0x12, 0x8E, 0xFF, 0x81, 0xD7, 0x17, 0x77, 0x71, 0x84, 0x37, 0x9C, 0xDE, 0xA8,
  0x4E, 0xDB, 0x96, 0x27, 0x72,
  // "ŏ" (U+014F)
  0x71, 0x0D, 0xC0, 0x67, 0x72, 0x06, 0xD7, 0x72, 0x0C, 0xC0, 0xB7, 0x72, 0x0B, 0xC0, 0xD7, 0x72,
  0x09, 0xD0, 0x47, 0x70, 0x3D, 0x0B, 0x77, 0x20, 0x5D, 0x0D, 0x02, 0x75, 0x01, 0x0C, 0xD0, 0x67,
  0x73, 0x0E, 0xD0, 0xE0, 0x57, 0x30, 0x30, 0xDE, 0x01, 0x77, 0x30, 0x7F, 0x82, 0xD7, 0x41, 0x28,
  0x21, 0x37, 0xCF, 0x09, 0x77, 0x50, 0xDF, 0xFF, 0x90, 0xE0, 0x17, 0x75, 0x03, 0x0E, 0xFF, 0xF0,
  0x37, 0x77, 0x04, 0x0E, 0xFF, 0xC0, 0xE0, 0x47, 0x77, 0x20, 0x20, 0xDF, 0xFA, 0x0C, 0x02, 0x77,
  0x75, 0x06, 0x0D, 0xFD, 0x0C, 0x05, 0x77, 0x77, 0x28, 0x92, 0x37, 0xBD, 0xEF, 0xED, 0xCA, 0x63,
  0x80, 0xBE, 0x70, 0x89, 0x43, 0x69, 0xCD, 0xEF, 0xEE, 0xDB, 0x85, 0x17, 0x77, 0x68, 0x12, 0x8D,
  0xFF, 0x81, 0xC7, 0x17, 0x77, 0x10, 0x30, 0xAF, 0xFD, 0x81, 0xE8, 0x17, 0x75, 0x08, 0xFF, 0xFA,
  0x0E, 0x05, 0x77, 0x20, 0x20, 0xDF, 0xFF, 0xD0, 0xB7, 0x70, 0x30, 0xEF, 0xFF, 0xF0, 0xC0, 0x17,
  0x40, 0x20, 0xEF, 0xC8, 0x6D, 0xB9, 0x88, 0x9B, 0xEF, 0xC0, 0xD0, 0x17, 0x20, 0x10, 0xDF, 0xA8,
  0x1D, 0x72, 0x71, 0x81, 0x38, 0xEF, 0xA0, 0xB7, 0x20, 0xBF, 0xA0, 0x77, 0x60, 0x10, 0x9F, 0xA0,
  0x87, 0x05, 0xF9, 0x0E, 0x03, 0x77, 0x20, 0x6F, 0xA0, 0x36, 0x0D, 0xF9, 0x03, 0x77, 0x40, 0x5F,
  0x90, 0xC5, 0x06, 0xF9, 0x06, 0x77, 0x60, 0x9F, 0x90, 0x54, 0x0D, 0xF0, 0xC7, 0x77, 0x01, 0x0E,
  0xF0, 0xB3, 0x04, 0xF9, 0x04, 0x77, 0x71, 0x07, 0xF9, 0x03, 0x20, 0x9F, 0x0C, 0x77, 0x73, 0x0E,
  0xF0, 0x82, 0x0D, 0xF0, 0x67, 0x77, 0x30, 0x9F, 0x81, 0xC0, 0x2F, 0x90, 0x17, 0x77, 0x30, 0x4F,
  0x90, 0x10, 0x5F, 0x0C, 0x77, 0x75, 0x0E, 0xF0, 0x50, 0x8F, 0x09, 0x77, 0x75, 0x0C, 0xF0, 0x70,
  0xAF, 0x06, 0x77, 0x75, 0x09, 0xF0, 0x90, 0xCF, 0x03, 0x77, 0x75, 0x06, 0xF0, 0xC0, 0xEF, 0x02,
  0x77, 0x75, 0x05, 0xF0, 0xD0, 0xEF, 0x01, 0x77, 0x75, 0x04, 0xF0, 0xEF, 0x97, 0x77, 0x60, 0x3F,
  0xFA, 0x77, 0x76, 0x02, 0xFF, 0xA7, 0x77, 0x60, 0x2F, 0xFA, 0x77, 0x76, 0x03, 0xF9, 0x0E, 0xF0,
  0x17, 0x77, 0x50, 0x4F, 0x0E, 0x0D, 0xF0, 0x27, 0x77, 0x50, 0x5F, 0x0D, 0x0C, 0xF0, 0x47, 0x77,
  0x50, 0x7F, 0x0C, 0x09, 0xF0, 0x77, 0x77, 0x50, 0x9F, 0x0A, 0x07, 0xF0, 0x97, 0x77, 0x50, 0xCF,
  0x07, 0x04, 0xF0, 0xC7, 0x77, 0x5F, 0x90, 0x50, 0x1F, 0x90, 0x27, 0x77, 0x30, 0x4F, 0x98, 0x11,
  0x0C, 0xF0, 0x77, 0x77, 0x30, 0xAF, 0x0D, 0x20, 0x7F, 0x0D, 0x77, 0x73, 0x0E, 0xF0, 0x82, 0x02,
  0xF9, 0x05, 0x77, 0x71, 0x07, 0xF9, 0x03, 0x30, 0xBF, 0x0D, 0x77, 0x70, 0x10, 0xEF, 0x0C, 0x40,
  0x4F, 0x90, 0x87, 0x76, 0x09, 0xF9, 0x05, 0x50, 0xBF, 0x90, 0x47, 0x74, 0x05, 0xF9, 0x0D, 0x60,
  0x2F, 0xA0, 0x57, 0x72, 0x05, 0xFA, 0x03, 0x70, 0x8F, 0xA0, 0x90, 0x17, 0x50, 0x10, 0x9F, 0xA0,
  0x97, 0x20, 0xBF, 0xA8, 0x1E, 0x82, 0x71, 0x81, 0x28, 0xEF, 0xA0, 0xC7, 0x30, 0x10, 0xDF, 0xC8,
  0x6E, 0xB9, 0x88, 0x9B, 0xEF, 0xC0, 0xE0, 0x17, 0x40, 0x10, 0xCF, 0xFF, 0xF0, 0xD0, 0x27, 0x70,
  0xBF, 0xFF, 0xD0, 0xC0, 0x17, 0x72, 0x06, 0x0E, 0xFF, 0xFA, 0x07, 0x77, 0x50, 0x10, 0x9F, 0xFE,
  0x0A, 0x02, 0x77, 0x71, 0x81, 0x17, 0xCF, 0xF8, 0x1D, 0x82, 0x77, 0x76, 0x84, 0x15, 0x8B, 0xDE,
  0xA8, 0x4E, 0xDB, 0x96, 0x27, 0x71,
  // "Ő" (U+0150)
  0x77, 0x20, 0x7F, 0x90, 0x66, 0x09, 0xF9, 0x04, 0x77, 0x50, 0x10, 0xEF, 0x0E, 0x01, 0x50, 0x2F,
  0x90, 0xD7, 0x76, 0x08, 0xF9, 0x05, 0x60, 0xAF, 0x90, 0x37, 0x75, 0x01, 0x0E, 0xF0, 0x96, 0x03,
  0xF9, 0x07, 0x77, 0x60, 0x9F, 0x0C, 0x70, 0xBF, 0x0A, 0x77, 0x60, 0x3F, 0x0D, 0x01, 0x60, 0x5F,
  0x0C, 0x77, 0x70, 0xCE, 0x0E, 0x02, 0x60, 0x10, 0xEE, 0x0D, 0x01, 0x77, 0x60, 0x6F, 0x04, 0x70,
  0x9E, 0x0E, 0x02, 0x77, 0x60, 0x10, 0xEE, 0x05, 0x70, 0x3E, 0x0E, 0x03, 0x77, 0x70, 0xAE, 0x05,
  0x71, 0x0C, 0xE0, 0x37, 0x77, 0x04, 0xE0, 0x67, 0x10, 0x7D, 0x0E, 0x04, 0x77, 0x70, 0x10, 0xED,
  0x05, 0x71, 0x02, 0xD0, 0xE0, 0x37, 0x77, 0x10, 0xAC, 0x0E, 0x04, 0x72, 0x0C, 0xC0, 0xD0, 0x37,
  0x77, 0x2C, 0x0D, 0x02, 0x72, 0x03, 0xC0, 0xC0, 0x18, 0x0C, 0x81, 0x08, 0x42, 0x69, 0xBD, 0xEA,
  0x84, 0xED, 0xB9, 0x62, 0x77, 0x77, 0x18, 0x11, 0x7D, 0xFF, 0x81, 0xD8, 0x17, 0x77, 0x30, 0x10,
  0x8F, 0xFE, 0x09, 0x01, 0x77, 0x70, 0x40, 0xEF, 0xFF, 0x90, 0xE0, 0x47, 0x75, 0x07, 0xFF, 0xFD,
  0x07, 0x77, 0x30, 0x7F, 0xFF, 0xF0, 0x87, 0x71, 0x07, 0xFF, 0xFF, 0xA0, 0x87, 0x60, 0x4F, 0xC8,
  0x2B, 0x63, 0x12, 0x83, 0x12, 0x59, 0xEF, 0xB0, 0x47, 0x40, 0x10, 0xEF, 0xA0, 0x90, 0x17, 0x40,
  0x70, 0xEF, 0x90, 0xE0, 0x27, 0x30, 0xAF, 0x90, 0xE0, 0x37, 0x70, 0x20, 0xCF, 0x90, 0xB7, 0x20,
  0x3F, 0x90, 0xD0, 0x27, 0x72, 0x01, 0x0C, 0xF9, 0x04, 0x71, 0x0C, 0xF9, 0x03, 0x77, 0x40, 0x10,
  0xEF, 0x0C, 0x70, 0x4F, 0x90, 0x77, 0x76, 0x05, 0xF9, 0x05, 0x60, 0xAF, 0x0D, 0x77, 0x71, 0x0C,
  0xF0, 0xB5, 0x01, 0xF9, 0x06, 0x77, 0x71, 0x04, 0xF9, 0x01, 0x40, 0x7F, 0x0E, 0x77, 0x73, 0x0D,
  0xF0, 0x74, 0x0C, 0xF0, 0x97, 0x77, 0x30, 0x8F, 0x0C, 0x4F, 0x90, 0x47, 0x77, 0x30, 0x3F, 0x90,
  0x12, 0x04, 0xF9, 0x77, 0x75, 0x0E, 0xF0, 0x52, 0x08, 0xF0, 0xB7, 0x77, 0x50, 0xAF, 0x09, 0x20,
  0xBF, 0x07, 0x77, 0x75, 0x07, 0xF0, 0xC2, 0x0E, 0xF0, 0x47, 0x77, 0x50, 0x3F, 0x81, 0xE0, 0x1F,
  0x90, 0x17, 0x77, 0x50, 0x1F, 0x90, 0x20, 0x4F, 0x0E, 0x77, 0x77, 0x0E, 0xF0, 0x50, 0x6F, 0x0C,
  0x77, 0x77, 0x0C, 0xF0, 0x60, 0x8F, 0x0B, 0x77, 0x77, 0x0A, 0xF0, 0x80, 0x9F, 0x09, 0x77, 0x77,
  0x09, 0xF0, 0x90, 0xBF, 0x08, 0x77, 0x77, 0x08, 0xF0, 0xB0, 0xCF, 0x07, 0x77, 0x77, 0x07, 0xF0,
  0xC0, 0xDF, 0x06, 0x77, 0x77, 0x06, 0xF0, 0x0D, 0xF0, 0x57, 0x77, 0x70, 0x5F, 0x0D, 0x0E, 0xF0,
  0x57, 0x77, 0x70, 0x5F, 0x00, 0xEF, 0x05, 0x77, 0x77, 0x05, 0xF0, 0x0E, 0xF0, 0x57, 0x77, 0x70,
  0x5F, 0x00, 0xEF, 0x05, 0x77, 0x77, 0x05, 0xF0, 0xE0, 0xDF, 0x05, 0x77, 0x77, 0x05, 0xF0, 0x0D,
  0xF0, 0x67, 0x77, 0x70, 0x6F, 0x0D, 0x0C, 0xF0, 0x77, 0x77, 0x70, 0x7F, 0x0C, 0x0B, 0xF0, 0x87,
  0x77, 0x70, 0x8F, 0x0B, 0x09, 0xF0, 0x97, 0x77, 0x70, 0x9F, 0x09, 0x08, 0xF0, 0xA7, 0x77, 0x70,
  0xAF, 0x08, 0x06, 0xF0, 0xC7, 0x77, 0x70, 0xCF, 0x06, 0x04, 0xF0, 0xE7, 0x77, 0x70, 0xEF, 0x04,
  0x02, 0xF9, 0x01, 0x77, 0x75, 0x01, 0xF9, 0x81, 0x10, 0xEF, 0x04, 0x77, 0x75, 0x04, 0xF0, 0xE2,
  0x0C, 0xF0, 0x77, 0x77, 0x50, 0x7F, 0x0B, 0x20, 0x9F, 0x0B, 0x77, 0x75, 0x0A, 0xF0, 0x82, 0x05,
  0xF0, 0xE7, 0x77, 0x50, 0xEF, 0x04, 0x20, 0x1F, 0x90, 0x47, 0x77, 0x30, 0x3F, 0x94, 0x0C, 0xF0,
  0x97, 0x77, 0x30, 0x8F, 0x0B, 0x40, 0x7F, 0x0E, 0x77, 0x73, 0x0D, 0xF0, 0x64, 0x01, 0xF9, 0x06,
  0x77, 0x71, 0x05, 0xF9, 0x01, 0x50, 0xBF, 0x0D, 0x77, 0x71, 0x0C, 0xF0, 0xA6, 0x05, 0xF9, 0x06,
  0x77, 0x60, 0x5F, 0x90, 0x47, 0x0D, 0xF9, 0x02, 0x77, 0x40, 0x10, 0xEF, 0x0B, 0x71, 0x04, 0xF9,
  0x0D, 0x02, 0x77, 0x20, 0x10, 0xCF, 0x90, 0x37, 0x20, 0xBF, 0x90, 0xD0, 0x37, 0x70, 0x20, 0xCF,
  0x90, 0xA7, 0x30, 0x20, 0xEF, 0xA0, 0x80, 0x17, 0x40, 0x70, 0xEF, 0x90, 0xD0, 0x17, 0x40, 0x5F,
  0xC8, 0x2A, 0x63, 0x12, 0x83, 0x12, 0x5A, 0xEF, 0xB0, 0x37, 0x60, 0x8F, 0xFF, 0xFA, 0x06, 0x77,
  0x10, 0x8F, 0xFF, 0xF0, 0x67, 0x73, 0x08, 0xFF, 0xFD, 0x06, 0x77, 0x50, 0x50, 0xEF, 0xFF, 0x90,
  0xD0, 0x37, 0x77, 0x01, 0x09, 0xFF, 0xD0, 0xE0, 0x87, 0x77, 0x48, 0x12, 0x8E, 0xFF, 0x81, 0xD7,
  0x17, 0x77, 0x71, 0x84, 0x37, 0x9C, 0xDE, 0xA8, 0x4E, 0xDB, 0x96, 0x27, 0x72,
  // "ő" (U+0151)
  0x77, 0x10, 0x7F, 0x90, 0x66, 0x09, 0xF9, 0x04, 0x77, 0x30, 0x10, 0xEF, 0x0E, 0x01, 0x50, 0x2F,
  0x90, 0xD7, 0x74, 0x08, 0xF9, 0x05, 0x60, 0xAF, 0x90, 0x37, 0x73, 0x01, 0x0E, 0xF0, 0x96, 0x03,
  0xF9, 0x07, 0x77, 0x40, 0x9F, 0x0C, 0x70, 0xBF, 0x0A, 0x77, 0x40, 0x3F, 0x0D, 0x01, 0x60, 0x5F,
  0x0C, 0x77, 0x50, 0xCE, 0x0E, 0x02, 0x60, 0x10, 0xEE, 0x0D, 0x01, 0x77, 0x40, 0x6F, 0x04, 0x70,
  0x9E, 0x0E, 0x02, 0x77, 0x40, 0x10, 0xEE, 0x05, 0x70, 0x3E, 0x0E, 0x03, 0x77, 0x50, 0xAE, 0x05,
  0x71, 0x0C, 0xE0, 0x37, 0x75, 0x04, 0xE0, 0x67, 0x10, 0x7D, 0x0E, 0x04, 0x77, 0x50, 0x10, 0xED,
  0x05, 0x71, 0x02, 0xD0, 0xE0, 0x37, 0x76, 0x0A, 0xC0, 0xE0, 0x47, 0x20, 0xCC, 0x0D, 0x03, 0x77,
  0x7C, 0x0D, 0x02, 0x72, 0x03, 0xC0, 0xC0, 0x18, 0x0B, 0xE5, 0x08, 0x94, 0x36, 0x9C, 0xDE, 0xFE,
  0xED, 0xB8, 0x51, 0x77, 0x76, 0x81, 0x28, 0xDF, 0xF8, 0x1C, 0x71, 0x77, 0x71, 0x03, 0x0A, 0xFF,
  0xD8, 0x1E, 0x81, 0x77, 0x50, 0x8F, 0xFF, 0xA0, 0xE0, 0x57, 0x72, 0x02, 0x0D, 0xFF, 0xFD, 0x0B,
  0x77, 0x03, 0x0E, 0xFF, 0xFF, 0x0C, 0x01, 0x74, 0x02, 0x0E, 0xFC, 0x86, 0xDB, 0x98, 0x89, 0xBE,
  0xFC, 0x0D, 0x01, 0x72, 0x01, 0x0D, 0xFA, 0x81, 0xD7, 0x27, 0x18, 0x13, 0x8E, 0xFA, 0x0B, 0x72,
  0x0B, 0xFA, 0x07, 0x76, 0x01, 0x09, 0xFA, 0x08, 0x70, 0x5F, 0x90, 0xE0, 0x37, 0x72, 0x06, 0xFA,
  0x03, 0x60, 0xDF, 0x90, 0x37, 0x74, 0x05, 0xF9, 0x0C, 0x50, 0x6F, 0x90, 0x67, 0x76, 0x09, 0xF9,
  0x05, 0x40, 0xDF, 0x0C, 0x77, 0x70, 0x10, 0xEF, 0x0B, 0x30, 0x4F, 0x90, 0x47, 0x77, 0x10, 0x7F,
  0x90, 0x32, 0x09, 0xF0, 0xC7, 0x77, 0x30, 0xEF, 0x08, 0x20, 0xDF, 0x06, 0x77, 0x73, 0x09, 0xF8,
  0x1C, 0x02, 0xF9, 0x01, 0x77, 0x73, 0x04, 0xF9, 0x01, 0x05, 0xF0, 0xC7, 0x77, 0x50, 0xEF, 0x05,
  0x08, 0xF0, 0x97, 0x77, 0x50, 0xCF, 0x07, 0x0A, 0xF0, 0x67, 0x77, 0x50, 0x9F, 0x09, 0x0C, 0xF0,
  0x37, 0x77, 0x50, 0x6F, 0x0C, 0x0E, 0xF0, 0x27, 0x77, 0x50, 0x5F, 0x0D, 0x0E, 0xF0, 0x17, 0x77,
  0x50, 0x4F, 0x0E, 0xF9, 0x77, 0x76, 0x03, 0xFF, 0xA7, 0x77, 0x60, 0x2F, 0xFA, 0x77, 0x76, 0x02,
  0xFF, 0xA7, 0x77, 0x60, 0x3F, 0x90, 0xEF, 0x01, 0x77, 0x75, 0x04, 0xF0, 0xE0, 0xDF, 0x02, 0x77,
  0x75, 0x05, 0xF0, 0xD0, 0xCF, 0x04, 0x77, 0x75, 0x07, 0xF0, 0xC0, 0x9F, 0x07, 0x77, 0x75, 0x09,
  0xF0, 0xA0, 0x7F, 0x09, 0x77, 0x75, 0x0C, 0xF0, 0x70, 0x4F, 0x0C, 0x77, 0x75, 0xF9, 0x05, 0x01,
  0xF9, 0x02, 0x77, 0x73, 0x04, 0xF9, 0x81, 0x10, 0xCF, 0x07, 0x77, 0x73, 0x0A, 0xF0, 0xD2, 0x07,
  0xF0, 0xD7, 0x77, 0x30, 0xEF, 0x08, 0x20, 0x2F, 0x90, 0x57, 0x77, 0x10, 0x7F, 0x90, 0x33, 0x0B,
  0xF0, 0xD7, 0x77, 0x01, 0x0E, 0xF0, 0xC4, 0x04, 0xF9, 0x08, 0x77, 0x60, 0x9F, 0x90, 0x55, 0x0B,
  0xF9, 0x04, 0x77, 0x40, 0x5F, 0x90, 0xD6, 0x02, 0xFA, 0x05, 0x77, 0x20, 0x5F, 0xA0, 0x37, 0x08,
  0xFA, 0x09, 0x01, 0x75, 0x01, 0x09, 0xFA, 0x09, 0x72, 0x0B, 0xFA, 0x81, 0xE8, 0x27, 0x18, 0x12,
  0x8E, 0xFA, 0x0C, 0x73, 0x01, 0x0D, 0xFC, 0x86, 0xEB, 0x98, 0x89, 0xBE, 0xFC, 0x0E, 0x01, 0x74,
  0x01, 0x0C, 0xFF, 0xFF, 0x0D, 0x02, 0x77, 0x0B, 0xFF, 0xFD, 0x0C, 0x01, 0x77, 0x20, 0x60, 0xEF,
  0xFF, 0xA0, 0x77, 0x75, 0x01, 0x09, 0xFF, 0xE0, 0xA0, 0x27, 0x77, 0x18, 0x11, 0x7C, 0xFF, 0x81,
  0xD8, 0x27, 0x77, 0x68, 0x41, 0x58, 0xBD, 0xEA, 0x84, 0xED, 0xB9, 0x62, 0x77, 0x10,
  // "Œ" (U+0152)
  0x77, 0x89, 0x23, 0x7B, 0xCE, 0xFE, 0xDC, 0xA7, 0x37, 0x77, 0x77, 0x07, 0x0E, 0xFF, 0xFF, 0xE0,
  0x47, 0x30, 0x50, 0xE8, 0x0C, 0x0F, 0x04, 0x72, 0x08, 0x80, 0xC2, 0xF0, 0x47, 0x10, 0xA8, 0x0C,
  0x3F, 0x04, 0x70, 0x98, 0x0C, 0x4F, 0x04, 0x60, 0x6F, 0xB8, 0x3B, 0x98, 0xAD, 0xFF, 0xFD, 0x04,
  0x50, 0x10, 0xEF, 0x90, 0x80, 0x15, 0x02, 0x09, 0xFF, 0xFB, 0x04, 0x50, 0xAF, 0x90, 0x47, 0x20,
  0x4F, 0x0B, 0x77, 0x60, 0x3F, 0x90, 0x57, 0x30, 0x1F, 0x0B, 0x77, 0x60, 0xAF, 0x0A, 0x74, 0x01,
  0xF0, 0xB7, 0x75, 0x02, 0xF9, 0x02, 0x74, 0x01, 0xF0, 0xB7, 0x75, 0x08, 0xF0, 0xA7, 0x50, 0x1F,
  0x0B, 0x77, 0x50, 0xDF, 0x04, 0x75, 0x01, 0xF0, 0xB7, 0x74, 0x02, 0xF0, 0xE7, 0x60, 0x1F, 0x0B,
  0x77, 0x40, 0x7F, 0x0A, 0x76, 0x01, 0xF0, 0xB7, 0x74, 0x0A, 0xF0, 0x67, 0x60, 0x1F, 0x0B, 0x77,
  0x40, 0xEF, 0x03, 0x76, 0x01, 0xF0, 0xB7, 0x73, 0x02, 0xF9, 0x77, 0x01, 0xF0, 0xB7, 0x73, 0x05,
  0xF0, 0xC7, 0x70, 0x1F, 0x0B, 0x77, 0x30, 0x7F, 0x0A, 0x77, 0x01, 0xF0, 0xB7, 0x73, 0x09, 0xF0,
  0x87, 0x70, 0x1F, 0x0B, 0x77, 0x30, 0xCF, 0x06, 0x77, 0x01, 0xF0, 0xB7, 0x73, 0x0E, 0xF0, 0x47,
  0x70, 0x1F, 0x0B, 0x77, 0x3F, 0x90, 0x37, 0x70, 0x1F, 0x0B, 0x77, 0x20, 0x1F, 0x90, 0x17, 0x70,
  0x1F, 0x0B, 0x77, 0x20, 0x2F, 0x97, 0x71, 0x01, 0xF0, 0xB7, 0x72, 0x03, 0xF9, 0x77, 0x10, 0x1F,
  0x0B, 0x77, 0x20, 0x4F, 0x0E, 0x77, 0x10, 0x1F, 0x0D, 0x80, 0x91, 0x80, 0x52, 0x05, 0xF0, 0xE7,
  0x71, 0x01, 0xFF, 0xF0, 0x92, 0x05, 0xF0, 0xD7, 0x71, 0x01, 0xFF, 0xF0, 0x92, 0x05, 0xF0, 0xD7,
  0x71, 0x01, 0xFF, 0xF0, 0x92, 0x06, 0xF0, 0xD7, 0x71, 0x01, 0xFF, 0xF0, 0x92, 0x06, 0xF0, 0xD7,
  0x71, 0x01, 0xFF, 0xF0, 0x92, 0x05, 0xF0, 0xD7, 0x71, 0x01, 0xFF, 0xF0, 0x92, 0x05, 0xF0, 0xE7,
  0x71, 0x01, 0xF0, 0xB7, 0x72, 0x05, 0xF0, 0xE7, 0x71, 0x01, 0xF0, 0xB7, 0x72, 0x04, 0xF9, 0x77,
  0x10, 0x1F, 0x0B, 0x77, 0x20, 0x3F, 0x97, 0x71, 0x01, 0xF0, 0xB7, 0x72, 0x02, 0xF9, 0x01, 0x77,
  0x01, 0xF0, 0xB7, 0x72, 0x01, 0xF9, 0x02, 0x77, 0x01, 0xF0, 0xB7, 0x73, 0xF9, 0x03, 0x77, 0x01,
  0xF0, 0xB7, 0x73, 0x0D, 0xF0, 0x57, 0x70, 0x1F, 0x0B, 0x77, 0x30, 0xBF, 0x07, 0x77, 0x01, 0xF0,
  0xB7, 0x73, 0x09, 0xF0, 0x97, 0x70, 0x1F, 0x0B, 0x77, 0x30, 0x7F, 0x0B, 0x77, 0x01, 0xF0, 0xB7,
  0x73, 0x05, 0xF0, 0xE7, 0x70, 0x1F, 0x0B, 0x77, 0x30, 0x2F, 0x90, 0x17, 0x60, 0x1F, 0x0B, 0x77,
  0x40, 0xEF, 0x04, 0x76, 0x01, 0xF0, 0xB7, 0x74, 0x0B, 0xF0, 0x87, 0x60, 0x1F, 0x0B, 0x77, 0x40,
  0x7F, 0x0C, 0x76, 0x01, 0xF0, 0xB7, 0x74, 0x03, 0xF9, 0x01, 0x75, 0x01, 0xF0, 0xB7, 0x75, 0x0D,
  0xF0, 0x77, 0x50, 0x1F, 0x0B, 0x77, 0x50, 0x9F, 0x0D, 0x75, 0x01, 0xF0, 0xB7, 0x75, 0x03, 0xF9,
  0x05, 0x74, 0x01, 0xF0, 0xB7, 0x76, 0x0C, 0xF0, 0xD0, 0x17, 0x30, 0x1F, 0x0B, 0x77, 0x60, 0x5F,
  0x90, 0xA7, 0x30, 0x1F, 0x0B, 0x77, 0x70, 0xCF, 0x90, 0xA7, 0x20, 0x5F, 0x0B, 0x77, 0x70, 0x3F,
  0xA8, 0x1E, 0x72, 0x28, 0x21, 0x47, 0xDF, 0xFF, 0xB0, 0x46, 0x09, 0x80, 0xC5, 0xF0, 0x47, 0x0C,
  0x80, 0xC4, 0xF0, 0x47, 0x02, 0x0E, 0x80, 0xC3, 0xF0, 0x47, 0x10, 0x20, 0xE8, 0x0C, 0x2F, 0x04,
  0x72, 0x01, 0x0B, 0x80, 0xC1, 0xF0, 0x47, 0x40, 0x50, 0xCF, 0xFF, 0xFF, 0x04, 0x76, 0x89, 0x23,
  0x7B, 0xDE, 0xFE, 0xDB, 0x85, 0x17, 0x77, 0x30,
  // "œ" (U+0153)
  0x73, 0x89, 0x04, 0x8B, 0xEF, 0xED, 0xB7, 0x27, 0x68, 0x73, 0x8C, 0xEF, 0xEC, 0x83, 0x77, 0x30,
  0x50, 0xDF, 0xB0, 0xA0, 0x17, 0x20, 0x20, 0xBF, 0xA0, 0xB0, 0x27, 0x60, 0x10, 0xBF, 0xE0, 0xE0,
  0x37, 0x04, 0x0E, 0xFC, 0x0E, 0x04, 0x74, 0x01, 0x0D, 0xFF, 0x90, 0xE0, 0x25, 0x04, 0xFF, 0x90,
  0x47, 0x30, 0xCF, 0xFB, 0x0D, 0x40, 0x20, 0xEF, 0xF9, 0x0E, 0x01, 0x71, 0x09, 0xFF, 0xD0, 0x93,
  0x0B, 0xFF, 0xB0, 0xA7, 0x04, 0xFA, 0x83, 0xC9, 0x8A, 0xEF, 0x81, 0x20, 0x5F, 0x82, 0xDA, 0x9B,
  0xF9, 0x04, 0x60, 0xCF, 0x0C, 0x03, 0x50, 0x7E, 0x81, 0xA0, 0xCE, 0x06, 0x40, 0x30, 0xEE, 0x0B,
  0x50, 0x4F, 0x0B, 0x71, 0x06, 0xE0, 0x6E, 0x05, 0x60, 0x3F, 0x02, 0x40, 0xAE, 0x0E, 0x01, 0x72,
  0x0A, 0xFC, 0x0A, 0x71, 0x09, 0xE0, 0x73, 0x01, 0xF0, 0x67, 0x30, 0x2F, 0xC0, 0x17, 0x10, 0x2E,
  0x0C, 0x30, 0x6E, 0x0E, 0x75, 0x0B, 0xFA, 0x0A, 0x73, 0x0B, 0xE3, 0x0A, 0xE0, 0xA7, 0x50, 0x6F,
  0xA0, 0x47, 0x30, 0x7E, 0x04, 0x20, 0xEE, 0x05, 0x75, 0x02, 0xFA, 0x74, 0x03, 0xE8, 0x17, 0x02,
  0xF0, 0x17, 0x60, 0xEF, 0x0C, 0x74, 0x01, 0xE8, 0x19, 0x04, 0xE0, 0xE7, 0x70, 0xBF, 0x09, 0x75,
  0x0E, 0xD8, 0x1C, 0x07, 0xE0, 0xB7, 0x70, 0x9F, 0x07, 0x75, 0x0C, 0xD8, 0x1E, 0x09, 0xE0, 0x97,
  0x70, 0x7F, 0x05, 0x75, 0x0A, 0xE1, 0x0B, 0xE0, 0x77, 0x70, 0x5F, 0x04, 0x75, 0x0A, 0xE0, 0x10,
  0xCE, 0x06, 0x77, 0x04, 0xF0, 0x37, 0x50, 0x9E, 0x02, 0x0D, 0xE0, 0x47, 0x70, 0x3F, 0x02, 0x75,
  0x08, 0xE0, 0x20, 0xEE, 0x04, 0x77, 0x02, 0xFF, 0xFE, 0x03, 0xF0, 0x37, 0x70, 0x1F, 0xFF, 0xE0,
  0x3F, 0x03, 0x77, 0x01, 0xFF, 0xFE, 0x03, 0xF0, 0x27, 0x70, 0x1F, 0xFF, 0xE0, 0x3F, 0x03, 0x77,
  0x01, 0xFF, 0xFE, 0x03, 0xF0, 0x37, 0x70, 0x1F, 0xFF, 0xE0, 0x30, 0xEE, 0x03, 0x77, 0x01, 0xF7,
  0x77, 0x0D, 0xE0, 0x47, 0x70, 0x2F, 0x01, 0x77, 0x60, 0xCE, 0x05, 0x77, 0x02, 0xF0, 0x27, 0x76,
  0x0B, 0xE0, 0x67, 0x70, 0x3F, 0x03, 0x77, 0x60, 0x9E, 0x08, 0x77, 0x05, 0xF0, 0x47, 0x76, 0x07,
  0xE0, 0x97, 0x70, 0x6F, 0x06, 0x77, 0x60, 0x5E, 0x0C, 0x77, 0x08, 0xF0, 0x87, 0x76, 0x02, 0xE0,
  0xE7, 0x70, 0xAF, 0x0B, 0x77, 0x70, 0xEE, 0x02, 0x76, 0x0D, 0xF0, 0xE7, 0x77, 0x0B, 0xE0, 0x67,
  0x50, 0x1F, 0xA0, 0x37, 0x76, 0x07, 0xE0, 0xB7, 0x50, 0x5F, 0xA0, 0x77, 0x76, 0x02, 0xF0, 0x27,
  0x40, 0xAF, 0xA0, 0xD7, 0x77, 0x0D, 0xE0, 0x97, 0x30, 0x1F, 0xC0, 0x57, 0x76, 0x07, 0xF0, 0x37,
  0x20, 0x9F, 0xC0, 0xE0, 0x17, 0x60, 0x10, 0x24, 0x01, 0x0E, 0xE0, 0xD0, 0x17, 0x04, 0xE0, 0x8E,
  0x0C, 0x01, 0x73, 0x82, 0x18, 0xF6, 0x50, 0x8F, 0x0D, 0x04, 0x50, 0x6E, 0x81, 0xD0, 0xBE, 0x0D,
  0x05, 0x70, 0x40, 0xAB, 0x06, 0x50, 0x10, 0xEF, 0x98, 0x3D, 0x98, 0xAD, 0xF8, 0x15, 0x03, 0xF9,
  0x84, 0xEB, 0x98, 0xAC, 0xE0, 0x66, 0x05, 0xFF, 0xD0, 0xC3, 0x09, 0xFF, 0xD0, 0x67, 0x08, 0xFF,
  0xB0, 0xE0, 0x23, 0x01, 0x0D, 0xFF, 0xC0, 0x67, 0x10, 0x9F, 0xFA, 0x04, 0x50, 0x20, 0xEF, 0xFB,
  0x05, 0x72, 0x08, 0xFE, 0x0E, 0x04, 0x70, 0x20, 0xDF, 0xF0, 0xD0, 0x47, 0x40, 0x30, 0xBF, 0xB0,
  0xB0, 0x27, 0x30, 0x80, 0xEF, 0xB0, 0xB0, 0x57, 0x71, 0x82, 0x38, 0xBD, 0xA8, 0x2E, 0xB8, 0x27,
  0x78, 0x90, 0x6A, 0xDE, 0xFE, 0xDA, 0x62, 0x70,
  // "Ŕ" (U+0154)
  0x77, 0x72, 0x03, 0x80, 0x57, 0x01, 0x77, 0x77, 0x40, 0xCF, 0xA0, 0x27, 0x77, 0x73, 0x05, 0xFA,
  0x08, 0x77, 0x77, 0x40, 0xDF, 0x90, 0xB7, 0x77, 0x74, 0x08, 0xF9, 0x0D, 0x01, 0x77, 0x77, 0x30,
  0x2F, 0x90, 0xE0, 0x27, 0x77, 0x74, 0x0C, 0xF0, 0xE0, 0x37, 0x77, 0x74, 0x06, 0xF9, 0x04, 0x77,
  0x77, 0x40, 0x10, 0xEF, 0x05, 0x77, 0x77, 0x50, 0xBF, 0x05, 0x77, 0x77, 0x50, 0x5F, 0x06, 0x77,
  0x77, 0x50, 0x10, 0xEE, 0x05, 0x77, 0x77, 0x60, 0xBE, 0x05, 0x77, 0x77, 0x60, 0x8D, 0x0E, 0x04,
  0x77, 0x77, 0x70, 0xDC, 0x0C, 0x02, 0x80, 0xCA, 0x30, 0x07, 0xFF, 0xA8, 0x6E, 0xEC, 0xB9, 0x74,
  0x17, 0x74, 0x07, 0xFF, 0xFB, 0x81, 0xD8, 0x37, 0x71, 0x07, 0xFF, 0xFE, 0x0C, 0x06, 0x76, 0x07,
  0xFF, 0xFF, 0x90, 0xD0, 0x37, 0x40, 0x7F, 0xFF, 0xFB, 0x08, 0x73, 0x07, 0xFF, 0xFF, 0xC0, 0x97,
  0x20, 0x7F, 0x0D, 0x80, 0x38, 0x83, 0x99, 0xAC, 0xEF, 0xE0, 0x87, 0x10, 0x7F, 0x0A, 0x75, 0x81,
  0x26, 0xBF, 0xC0, 0x57, 0x07, 0xF0, 0xA7, 0x71, 0x02, 0x0B, 0xFA, 0x0E, 0x70, 0x7F, 0x0A, 0x77,
  0x30, 0x7F, 0xA0, 0x76, 0x07, 0xF0, 0xA7, 0x74, 0x07, 0xF9, 0x0E, 0x60, 0x7F, 0x0A, 0x77, 0x50,
  0xCF, 0x90, 0x45, 0x07, 0xF0, 0xA7, 0x75, 0x04, 0xF9, 0x08, 0x50, 0x7F, 0x0A, 0x77, 0x60, 0xEF,
  0x0B, 0x50, 0x7F, 0x0A, 0x77, 0x60, 0xAF, 0x0E, 0x50, 0x7F, 0x0A, 0x77, 0x60, 0x6F, 0x95, 0x07,
  0xF0, 0xA7, 0x76, 0x05, 0xF9, 0x01, 0x40, 0x7F, 0x0A, 0x77, 0x60, 0x4F, 0x90, 0x24, 0x07, 0xF0,
  0xA7, 0x76, 0x03, 0xF9, 0x02, 0x40, 0x7F, 0x0A, 0x77, 0x60, 0x4F, 0x90, 0x14, 0x07, 0xF0, 0xA7,
  0x76, 0x05, 0xF9, 0x50, 0x7F, 0x0A, 0x77, 0x60, 0x7F, 0x0D, 0x50, 0x7F, 0x0A, 0x77, 0x60, 0xAF,
  0x0B, 0x50, 0x7F, 0x0A, 0x77, 0x60, 0xEF, 0x07, 0x50, 0x7F, 0x0A, 0x77, 0x50, 0x4F, 0x90, 0x35,
  0x07, 0xF0, 0xA7, 0x75, 0x0C, 0xF0, 0xD6, 0x07, 0xF0, 0xA7, 0x74, 0x06, 0xF9, 0x06, 0x60, 0x7F,
  0x0A, 0x77, 0x30, 0x3F, 0x90, 0xD7, 0x07, 0xF0, 0xA7, 0x72, 0x05, 0x0E, 0xF9, 0x04, 0x70, 0x7F,
  0x0A, 0x77, 0x04, 0x0B, 0xFA, 0x09, 0x71, 0x07, 0xF0, 0xA7, 0x18, 0x41, 0x24, 0x6A, 0xEF, 0xB0,
  0xB7, 0x20, 0x7F, 0xFF, 0xFB, 0x0A, 0x73, 0x07, 0xFF, 0xFF, 0x90, 0xE0, 0x67, 0x40, 0x7F, 0xFF,
  0xF0, 0xB0, 0x27, 0x50, 0x7F, 0xFF, 0xD0, 0xB0, 0x47, 0x70, 0x7F, 0xFF, 0xC0, 0x47, 0x72, 0x07,
  0xFF, 0xFC, 0x0A, 0x77, 0x20, 0x7F, 0x0D, 0x80, 0x58, 0x09, 0xF9, 0x04, 0x77, 0x10, 0x7F, 0x0A,
  0x73, 0x0B, 0xF0, 0xD7, 0x71, 0x07, 0xF0, 0xA7, 0x30, 0x2F, 0x90, 0x77, 0x70, 0x7F, 0x0A, 0x74,
  0x08, 0xF0, 0xE0, 0x17, 0x60, 0x7F, 0x0A, 0x75, 0x0E, 0xF0, 0xA7, 0x60, 0x7F, 0x0A, 0x75, 0x05,
  0xF9, 0x04, 0x75, 0x07, 0xF0, 0xA7, 0x60, 0xCF, 0x0D, 0x75, 0x07, 0xF0, 0xA7, 0x60, 0x3F, 0x90,
  0x77, 0x40, 0x7F, 0x0A, 0x77, 0x09, 0xF0, 0xE0, 0x17, 0x30, 0x7F, 0x0A, 0x77, 0x01, 0x0E, 0xF0,
  0xA7, 0x30, 0x7F, 0x0A, 0x77, 0x10, 0x6F, 0x90, 0x47, 0x20, 0x7F, 0x0A, 0x77, 0x20, 0xDF, 0x0D,
  0x72, 0x07, 0xF0, 0xA7, 0x72, 0x04, 0xF9, 0x07, 0x71, 0x07, 0xF0, 0xA7, 0x73, 0x0A, 0xF0, 0xE0,
  0x17, 0x07, 0xF0, 0xA7, 0x73, 0x02, 0xF9, 0x0A, 0x70, 0x7F, 0x0A, 0x77, 0x40, 0x8F, 0x90, 0x46,
  0x07, 0xF0, 0xA7, 0x75, 0x0D, 0xF0, 0xD6, 0x07, 0xF0, 0xA7, 0x75, 0x05, 0xF9, 0x07, 0x50, 0x7F,
  0x0A, 0x77, 0x60, 0xBF, 0x0E, 0x01, 0x40, 0x7F, 0x0A, 0x77, 0x60, 0x3F, 0x90, 0xA4, 0x07, 0xF0,
  0xA7, 0x77, 0x09, 0xF9, 0x04, 0x30, 0x7F, 0x0A, 0x77, 0x70, 0x10, 0xEF, 0x0D, 0x30, 0x7F, 0x0A,
  0x77, 0x71, 0x06, 0xF9, 0x07, 0x20, 0x7F, 0x0A, 0x77, 0x72, 0x0C, 0xF9, 0x81, 0x20, 0x7F, 0x0A,
  0x77, 0x72, 0x04, 0xF9, 0x81, 0xA0, 0x7F, 0x0A, 0x77, 0x73, 0x0A, 0xF9, 0x04, 0x07, 0xF0, 0xA7,
  0x77, 0x30, 0x1F, 0x90, 0xD0,
  // "ŕ" (U+0155)
  0x77, 0x77, 0x20, 0x38, 0x05, 0x70, 0x18, 0x0C, 0x00, 0x0C, 0xFA, 0x02, 0x77, 0x77, 0x70, 0x5F,
  0xA0, 0x88, 0x0C, 0x00, 0x0D, 0xF9, 0x0B, 0x80, 0xC0, 0x00, 0x8F, 0x90, 0xD0, 0x17, 0x77, 0x77,
  0x02, 0xF9, 0x0E, 0x02, 0x80, 0xC0, 0x00, 0xCF, 0x0E, 0x03, 0x80, 0xC0, 0x00, 0x6F, 0x90, 0x48,
  0x0C, 0x00, 0x01, 0x0E, 0xF0, 0x58, 0x0C, 0x10, 0x0B, 0xF0, 0x58, 0x0C, 0x10, 0x05, 0xF0, 0x68,
  0x0C, 0x10, 0x01, 0x0E, 0xE0, 0x58, 0x0C, 0x20, 0x0B, 0xE0, 0x58, 0x0C, 0x20, 0x08, 0xD0, 0xE0,
  0x48, 0x0C, 0x30, 0x0D, 0xC0, 0xC0, 0x28, 0x0C, 0xB0, 0x08, 0x93, 0x16, 0xAD, 0xEF, 0xEE, 0xDB,
  0x85, 0x15, 0xFF, 0xD0, 0xC7, 0x01, 0x0A, 0xFE, 0x0B, 0x05, 0x3F, 0xFD, 0x0E, 0x60, 0x50, 0xEF,
  0xFA, 0x05, 0x2F, 0xFE, 0x50, 0x6F, 0xFC, 0x3F, 0xFE, 0x02, 0x30, 0x5F, 0xFC, 0x0B, 0x3F, 0xFE,
  0x04, 0x20, 0x3F, 0xFD, 0x06, 0x48, 0x52, 0x46, 0x8A, 0xCE, 0xFD, 0x06, 0x20, 0xDF, 0x98, 0x4C,
  0xA8, 0x9B, 0xED, 0x01, 0x75, 0x83, 0x24, 0x68, 0xEE, 0x81, 0x80, 0x8E, 0x0D, 0x06, 0x78, 0x33,
  0x8E, 0xFC, 0x77, 0x30, 0xBE, 0x0A, 0x02, 0xE0, 0x87, 0x50, 0x80, 0x77, 0x73, 0x0B, 0xE0, 0xD0,
  0xBD, 0x05, 0x77, 0x77, 0x40, 0xBF, 0xD0, 0x47, 0x77, 0x75, 0x0B, 0xFC, 0x07, 0x77, 0x77, 0x60,
  0xBF, 0xB0, 0xC7, 0x77, 0x77, 0x0B, 0xFB, 0x02, 0x77, 0x77, 0x70, 0xBF, 0xA0, 0xA8, 0x0C, 0x00,
  0x0B, 0xFA, 0x02, 0x80, 0xC0, 0x00, 0xBF, 0x90, 0xC8, 0x0C, 0x10, 0x0B, 0xF9, 0x07, 0x80, 0xC1,
  0x00, 0xBF, 0x90, 0x38, 0x0C, 0x10, 0x0B, 0xF0, 0xE8, 0x0C, 0x20, 0x0B, 0xF0, 0xC8, 0x0C, 0x20,
  0x0B, 0xF0, 0x98, 0x0C, 0x20, 0x0B, 0xF0, 0x88, 0x0C, 0x20, 0x0B, 0xF0, 0x78, 0x0C, 0x20, 0x0B,
  0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0,
  0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x68,
  0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C,
  0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20,
  0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B,
  0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x67, 0x77, 0x73, 0x86, 0x13, 0x46, 0x78, 0xAE, 0xF8, 0x6C,
  0x98, 0x65, 0x32, 0x17, 0x72, 0x85, 0x27, 0x9A, 0xBD, 0xEF, 0xFF, 0xC8, 0x4D, 0xCA, 0x97, 0x37,
  0x20, 0x68, 0x0C, 0x0F, 0x07, 0x72, 0x06, 0x80, 0xC0, 0xF0, 0x77, 0x20, 0x68, 0x0C, 0x0F, 0x07,
  0x72, 0x06, 0x80, 0xC0, 0xF0, 0x77, 0x20, 0x68, 0x0C, 0x0F, 0x07, 0x72,
  // "Ŗ" (U+0156)
  0x07, 0xFF, 0xA8, 0x6E, 0xEC, 0xB9, 0x74, 0x17, 0x74, 0x07, 0xFF, 0xFB, 0x81, 0xD8, 0x37, 0x71,
  0x07, 0xFF, 0xFE, 0x0C, 0x06, 0x76, 0x07, 0xFF, 0xFF, 0x90, 0xD0, 0x37, 0x40, 0x7F, 0xFF, 0xFB,
  0x08, 0x73, 0x07, 0xFF, 0xFF, 0xC0, 0x97, 0x20, 0x7F, 0x0D, 0x80, 0x38, 0x83, 0x99, 0xAC, 0xEF,
  0xE0, 0x87, 0x10, 0x7F, 0x0A, 0x75, 0x81, 0x26, 0xBF, 0xC0, 0x57, 0x07, 0xF0, 0xA7, 0x71, 0x02,
  0x0B, 0xFA, 0x0E, 0x70, 0x7F, 0x0A, 0x77, 0x30, 0x7F, 0xA0, 0x76, 0x07, 0xF0, 0xA7, 0x74, 0x07,
  0xF9, 0x0E, 0x60, 0x7F, 0x0A, 0x77, 0x50, 0xCF, 0x90, 0x45, 0x07, 0xF0, 0xA7, 0x75, 0x04, 0xF9,
  0x08, 0x50, 0x7F, 0x0A, 0x77, 0x60, 0xEF, 0x0B, 0x50, 0x7F, 0x0A, 0x77, 0x60, 0xAF, 0x0E, 0x50,
  0x7F, 0x0A, 0x77, 0x60, 0x6F, 0x95, 0x07, 0xF0, 0xA7, 0x76, 0x05, 0xF9, 0x01, 0x40, 0x7F, 0x0A,
  0x77, 0x60, 0x4F, 0x90, 0x24, 0x07, 0xF0, 0xA7, 0x76, 0x03, 0xF9, 0x02, 0x40, 0x7F, 0x0A, 0x77,
  0x60, 0x4F, 0x90, 0x14, 0x07, 0xF0, 0xA7, 0x76, 0x05, 0xF9, 0x50, 0x7F, 0x0A, 0x77, 0x60, 0x7F,
  0x0D, 0x50, 0x7F, 0x0A, 0x77, 0x60, 0xAF, 0x0B, 0x50, 0x7F, 0x0A, 0x77, 0x60, 0xEF, 0x07, 0x50,
  0x7F, 0x0A, 0x77, 0x50, 0x4F, 0x90, 0x35, 0x07, 0xF0, 0xA7, 0x75, 0x0C, 0xF0, 0xD6, 0x07, 0xF0,
  0xA7, 0x74, 0x06, 0xF9, 0x06, 0x60, 0x7F, 0x0A, 0x77, 0x30, 0x3F, 0x90, 0xD7, 0x07, 0xF0, 0xA7,
  0x72, 0x05, 0x0E, 0xF9, 0x04, 0x70, 0x7F, 0x0A, 0x77, 0x04, 0x0B, 0xFA, 0x09, 0x71, 0x07, 0xF0,
  0xA7, 0x18, 0x41, 0x24, 0x6A, 0xEF, 0xB0, 0xB7, 0x20, 0x7F, 0xFF, 0xFB, 0x0A, 0x73, 0x07, 0xFF,
  0xFF, 0x90, 0xE0, 0x67, 0x40, 0x7F, 0xFF, 0xF0, 0xB0, 0x27, 0x50, 0x7F, 0xFF, 0xD0, 0xB0, 0x47,
  0x70, 0x7F, 0xFF, 0xC0, 0x47, 0x72, 0x07, 0xFF, 0xFC, 0x0A, 0x77, 0x20, 0x7F, 0x0D, 0x80, 0x58,
  0x09, 0xF9, 0x04, 0x77, 0x10, 0x7F, 0x0A, 0x73, 0x0B, 0xF0, 0xD7, 0x71, 0x07, 0xF0, 0xA7, 0x30,
  0x2F, 0x90, 0x77, 0x70, 0x7F, 0x0A, 0x74, 0x08, 0xF0, 0xE0, 0x17, 0x60, 0x7F, 0x0A, 0x75, 0x0E,
  0xF0, 0xA7, 0x60, 0x7F, 0x0A, 0x75, 0x05, 0xF9, 0x04, 0x75, 0x07, 0xF0, 0xA7, 0x60, 0xCF, 0x0D,
  0x75, 0x07, 0xF0, 0xA7, 0x60, 0x3F, 0x90, 0x77, 0x40, 0x7F, 0x0A, 0x77, 0x09, 0xF0, 0xE0, 0x17,
  0x30, 0x7F, 0x0A, 0x77, 0x01, 0x0E, 0xF0, 0xA7, 0x30, 0x7F, 0x0A, 0x77, 0x10, 0x6F, 0x90, 0x47,
  0x20, 0x7F, 0x0A, 0x77, 0x20, 0xDF, 0x0D, 0x72, 0x07, 0xF0, 0xA7, 0x72, 0x04, 0xF9, 0x07, 0x71,
  0x07, 0xF0, 0xA7, 0x73, 0x0A, 0xF0, 0xE0, 0x17, 0x07, 0xF0, 0xA7, 0x73, 0x02, 0xF9, 0x0A, 0x70,
  0x7F, 0x0A, 0x77, 0x40, 0x8F, 0x90, 0x46, 0x07, 0xF0, 0xA7, 0x75, 0x0D, 0xF0, 0xD6, 0x07, 0xF0,
  0xA7, 0x75, 0x05, 0xF9, 0x07, 0x50, 0x7F, 0x0A, 0x77, 0x60, 0xBF, 0x0E, 0x01, 0x40, 0x7F, 0x0A,
  0x77, 0x60, 0x3F, 0x90, 0xA4, 0x07, 0xF0, 0xA7, 0x77, 0x09, 0xF9, 0x04, 0x30, 0x7F, 0x0A, 0x77,
  0x70, 0x10, 0xEF, 0x0D, 0x30, 0x7F, 0x0A, 0x77, 0x71, 0x06, 0xF9, 0x07, 0x20, 0x7F, 0x0A, 0x77,
  0x72, 0x0C, 0xF9, 0x81, 0x20, 0x7F, 0x0A, 0x77, 0x72, 0x04, 0xF9, 0x81, 0xA0, 0x7F, 0x0A, 0x77,
  0x73, 0x0A, 0xF9, 0x04, 0x07, 0xF0, 0xA7, 0x77, 0x30, 0x1F, 0x90, 0xD8, 0x0C, 0xA0, 0x00, 0xDF,
  0x77, 0x77, 0x7F, 0x0B, 0x77, 0x77, 0x60, 0x2F, 0x06, 0x77, 0x77, 0x60, 0x6F, 0x01, 0x77, 0x77,
  0x60, 0x9E, 0x09, 0x77, 0x77, 0x70, 0xEE, 0x02, 0x77, 0x77, 0x60, 0x3E, 0x0A, 0x77, 0x77, 0x70,
  0x7E, 0x02, 0x77, 0x77, 0x70, 0xCD, 0x08, 0x77, 0x77, 0x70, 0x1D, 0x0E, 0x01, 0x77, 0x77, 0x70,
  0x7D, 0x05, 0x80, 0xC0, 0x00, 0xCC, 0x0B, 0x80, 0xC0, 0x00, 0x4C, 0x0E, 0x01, 0x80, 0xC0, 0x00,
  0x7C, 0x03, 0x77, 0x72,
  // "ŗ" (U+0157)
  0x77, 0x77, 0x38, 0x93, 0x16, 0xAD, 0xEF, 0xEE, 0xDB, 0x85, 0x15, 0xFF, 0xD0, 0xC7, 0x01, 0x0A,
  0xFE, 0x0B, 0x05, 0x3F, 0xFD, 0x0E, 0x60, 0x50, 0xEF, 0xFA, 0x05, 0x2F, 0xFE, 0x50, 0x6F, 0xFC,
  0x3F, 0xFE, 0x02, 0x30, 0x5F, 0xFC, 0x0B, 0x3F, 0xFE, 0x04, 0x20, 0x3F, 0xFD, 0x06, 0x48, 0x52,
  0x46, 0x8A, 0xCE, 0xFD, 0x06, 0x20, 0xDF, 0x98, 0x4C, 0xA8, 0x9B, 0xED, 0x01, 0x75, 0x83, 0x24,
  0x68, 0xEE, 0x81, 0x80, 0x8E, 0x0D, 0x06, 0x78, 0x33, 0x8E, 0xFC, 0x77, 0x30, 0xBE, 0x0A, 0x02,
  0xE0, 0x87, 0x50, 0x80, 0x77, 0x73, 0x0B, 0xE0, 0xD0, 0xBD, 0x05, 0x77, 0x77, 0x40, 0xBF, 0xD0,
  0x47, 0x77, 0x75, 0x0B, 0xFC, 0x07, 0x77, 0x77, 0x60, 0xBF, 0xB0, 0xC7, 0x77, 0x77, 0x0B, 0xFB,
  0x02, 0x77, 0x77, 0x70, 0xBF, 0xA0, 0xA8, 0x0C, 0x00, 0x0B, 0xFA, 0x02, 0x80, 0xC0, 0x00, 0xBF,
  0x90, 0xC8, 0x0C, 0x10, 0x0B, 0xF9, 0x07, 0x80, 0xC1, 0x00, 0xBF, 0x90, 0x38, 0x0C, 0x10, 0x0B,
  0xF0, 0xE8, 0x0C, 0x20, 0x0B, 0xF0, 0xC8, 0x0C, 0x20, 0x0B, 0xF0, 0x98, 0x0C, 0x20, 0x0B, 0xF0,
  0x88, 0x0C, 0x20, 0x0B, 0xF0, 0x78, 0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x68,
  0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C,
  0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20,
  0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B,
  0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0,
  0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x67,
  0x77, 0x73, 0x86, 0x13, 0x46, 0x78, 0xAE, 0xF8, 0x6C, 0x98, 0x65, 0x32, 0x17, 0x72, 0x85, 0x27,
  0x9A, 0xBD, 0xEF, 0xFF, 0xC8, 0x4D, 0xCA, 0x97, 0x37, 0x20, 0x68, 0x0C, 0x0F, 0x07, 0x72, 0x06,
  0x80, 0xC0, 0xF0, 0x77, 0x20, 0x68, 0x0C, 0x0F, 0x07, 0x72, 0x06, 0x80, 0xC0, 0xF0, 0x77, 0x20,
  0x68, 0x0C, 0x0F, 0x07, 0x80, 0xCD, 0x60, 0x0D, 0xF8, 0x0C, 0x30, 0xF0, 0xB8, 0x0C, 0x20, 0x02,
  0xF0, 0x68, 0x0C, 0x20, 0x06, 0xF0, 0x18, 0x0C, 0x20, 0x09, 0xE0, 0x98, 0x0C, 0x30, 0x0E, 0xE0,
  0x28, 0x0C, 0x20, 0x03, 0xE0, 0xA8, 0x0C, 0x30, 0x07, 0xE0, 0x28, 0x0C, 0x30, 0x0C, 0xD0, 0x88,
  0x0C, 0x30, 0x01, 0xD0, 0xE0, 0x18, 0x0C, 0x30, 0x07, 0xD0, 0x58, 0x0C, 0x40, 0x0C, 0xC0, 0xB8,
  0x0C, 0x40, 0x04, 0xC0, 0xE0, 0x18, 0x0C, 0x40, 0x07, 0xC0, 0x37, 0x77, 0x72,
  // "Ř" (U+0158)
  0x30, 0x18, 0x01, 0x70, 0x47, 0x74, 0x05, 0x80, 0x17, 0x01, 0x74, 0x02, 0xE0, 0x87, 0x71, 0x01,
  0x0A, 0xE0, 0x27, 0x50, 0x8E, 0x0C, 0x01, 0x75, 0x03, 0x0D, 0xE0, 0x87, 0x70, 0x9E, 0x0D, 0x03,
  0x73, 0x05, 0x0E, 0xE0, 0x87, 0x72, 0x0A, 0xF0, 0x57, 0x10, 0x7F, 0x09, 0x77, 0x40, 0xBF, 0x06,
  0x60, 0x9F, 0x09, 0x77, 0x60, 0xCF, 0x07, 0x40, 0xAF, 0x0A, 0x77, 0x70, 0x10, 0xDF, 0x06, 0x20,
  0xAF, 0x0C, 0x77, 0x72, 0x02, 0x0E, 0xF0, 0x60, 0xBF, 0x0D, 0x01, 0x77, 0x73, 0x04, 0xFF, 0x90,
  0xD0, 0x17, 0x77, 0x50, 0x5F, 0xE0, 0xE0, 0x27, 0x77, 0x70, 0x8F, 0xD0, 0x57, 0x77, 0x72, 0x0C,
  0xFB, 0x08, 0x77, 0x77, 0x30, 0x20, 0xEF, 0x90, 0xD7, 0x77, 0x75, 0x07, 0xF9, 0x04, 0x80, 0xCA,
  0x10, 0x07, 0xFF, 0xA8, 0x6E, 0xEC, 0xB9, 0x74, 0x17, 0x74, 0x07, 0xFF, 0xFB, 0x81, 0xD8, 0x37,
  0x71, 0x07, 0xFF, 0xFE, 0x0C, 0x06, 0x76, 0x07, 0xFF, 0xFF, 0x90, 0xD0, 0x37, 0x40, 0x7F, 0xFF,
  0xFB, 0x08, 0x73, 0x07, 0xFF, 0xFF, 0xC0, 0x97, 0x20, 0x7F, 0x0D, 0x80, 0x38, 0x83, 0x99, 0xAC,
  0xEF, 0xE0, 0x87, 0x10, 0x7F, 0x0A, 0x75, 0x81, 0x26, 0xBF, 0xC0, 0x57, 0x07, 0xF0, 0xA7, 0x71,
  0x02, 0x0B, 0xFA, 0x0E, 0x70, 0x7F, 0x0A, 0x77, 0x30, 0x7F, 0xA0, 0x76, 0x07, 0xF0, 0xA7, 0x74,
  0x07, 0xF9, 0x0E, 0x60, 0x7F, 0x0A, 0x77, 0x50, 0xCF, 0x90, 0x45, 0x07, 0xF0, 0xA7, 0x75, 0x04,
  0xF9, 0x08, 0x50, 0x7F, 0x0A, 0x77, 0x60, 0xEF, 0x0B, 0x50, 0x7F, 0x0A, 0x77, 0x60, 0xAF, 0x0E,
  0x50, 0x7F, 0x0A, 0x77, 0x60, 0x6F, 0x95, 0x07, 0xF0, 0xA7, 0x76, 0x05, 0xF9, 0x01, 0x40, 0x7F,
  0x0A, 0x77, 0x60, 0x4F, 0x90, 0x24, 0x07, 0xF0, 0xA7, 0x76, 0x03, 0xF9, 0x02, 0x40, 0x7F, 0x0A,
  0x77, 0x60, 0x4F, 0x90, 0x14, 0x07, 0xF0, 0xA7, 0x76, 0x05, 0xF9, 0x50, 0x7F, 0x0A, 0x77, 0x60,
  0x7F, 0x0D, 0x50, 0x7F, 0x0A, 0x77, 0x60, 0xAF, 0x0B, 0x50, 0x7F, 0x0A, 0x77, 0x60, 0xEF, 0x07,
  0x50, 0x7F, 0x0A, 0x77, 0x50, 0x4F, 0x90, 0x35, 0x07, 0xF0, 0xA7, 0x75, 0x0C, 0xF0, 0xD6, 0x07,
  0xF0, 0xA7, 0x74, 0x06, 0xF9, 0x06, 0x60, 0x7F, 0x0A, 0x77, 0x30, 0x3F, 0x90, 0xD7, 0x07, 0xF0,
  0xA7, 0x72, 0x05, 0x0E, 0xF9, 0x04, 0x70, 0x7F, 0x0A, 0x77, 0x04, 0x0B, 0xFA, 0x09, 0x71, 0x07,
  0xF0, 0xA7, 0x18, 0x41, 0x24, 0x6A, 0xEF, 0xB0, 0xB7, 0x20, 0x7F, 0xFF, 0xFB, 0x0A, 0x73, 0x07,
  0xFF, 0xFF, 0x90, 0xE0, 0x67, 0x40, 0x7F, 0xFF, 0xF0, 0xB0, 0x27, 0x50, 0x7F, 0xFF, 0xD0, 0xB0,
  0x47, 0x70, 0x7F, 0xFF, 0xC0, 0x47, 0x72, 0x07, 0xFF, 0xFC, 0x0A, 0x77, 0x20, 0x7F, 0x0D, 0x80,
  0x58, 0x09, 0xF9, 0x04, 0x77, 0x10, 0x7F, 0x0A, 0x73, 0x0B, 0xF0, 0xD7, 0x71, 0x07, 0xF0, 0xA7,
  0x30, 0x2F, 0x90, 0x77, 0x70, 0x7F, 0x0A, 0x74, 0x08, 0xF0, 0xE0, 0x17, 0x60, 0x7F, 0x0A, 0x75,
  0x0E, 0xF0, 0xA7, 0x60, 0x7F, 0x0A, 0x75, 0x05, 0xF9, 0x04, 0x75, 0x07, 0xF0, 0xA7, 0x60, 0xCF,
  0x0D, 0x75, 0x07, 0xF0, 0xA7, 0x60, 0x3F, 0x90, 0x77, 0x40, 0x7F, 0x0A, 0x77, 0x09, 0xF0, 0xE0,
  0x17, 0x30, 0x7F, 0x0A, 0x77, 0x01, 0x0E, 0xF0, 0xA7, 0x30, 0x7F, 0x0A, 0x77, 0x10, 0x6F, 0x90,
  0x47, 0x20, 0x7F, 0x0A, 0x77, 0x20, 0xDF, 0x0D, 0x72, 0x07, 0xF0, 0xA7, 0x72, 0x04, 0xF9, 0x07,
  0x71, 0x07, 0xF0, 0xA7, 0x73, 0x0A, 0xF0, 0xE0, 0x17, 0x07, 0xF0, 0xA7, 0x73, 0x02, 0xF9, 0x0A,
  0x70, 0x7F, 0x0A, 0x77, 0x40, 0x8F, 0x90, 0x46, 0x07, 0xF0, 0xA7, 0x75, 0x0D, 0xF0, 0xD6, 0x07,
  0xF0, 0xA7, 0x75, 0x05, 0xF9, 0x07, 0x50, 0x7F, 0x0A, 0x77, 0x60, 0xBF, 0x0E, 0x01, 0x40, 0x7F,
  0x0A, 0x77, 0x60, 0x3F, 0x90, 0xA4, 0x07, 0xF0, 0xA7, 0x77, 0x09, 0xF9, 0x04, 0x30, 0x7F, 0x0A,
  0x77, 0x70, 0x10, 0xEF, 0x0D, 0x30, 0x7F, 0x0A, 0x77, 0x71, 0x06, 0xF9, 0x07, 0x20, 0x7F, 0x0A,
  0x77, 0x72, 0x0C, 0xF9, 0x81, 0x20, 0x7F, 0x0A, 0x77, 0x72, 0x04, 0xF9, 0x81, 0xA0, 0x7F, 0x0A,
  0x77, 0x73, 0x0A, 0xF9, 0x04, 0x07, 0xF0, 0xA7, 0x77, 0x30, 0x1F, 0x90, 0xD0,
  // "ř" (U+0159)
  0x73, 0x01, 0x80, 0x17, 0x04, 0x77, 0x40, 0x58, 0x01, 0x70, 0x17, 0x71, 0x02, 0xE0, 0x87, 0x71,
  0x01, 0x0A, 0xE0, 0x27, 0x72, 0x08, 0xE0, 0xC0, 0x17, 0x50, 0x30, 0xDE, 0x08, 0x77, 0x40, 0x9E,
  0x0D, 0x03, 0x73, 0x05, 0x0E, 0xE0, 0x87, 0x76, 0x0A, 0xF0, 0x57, 0x10, 0x7F, 0x09, 0x77, 0x71,
  0x0B, 0xF0, 0x66, 0x09, 0xF0, 0x97, 0x77, 0x30, 0xCF, 0x07, 0x40, 0xAF, 0x0A, 0x77, 0x74, 0x01,
  0x0D, 0xF0, 0x62, 0x0A, 0xF0, 0xC7, 0x77, 0x60, 0x20, 0xEF, 0x06, 0x0B, 0xF0, 0xD0, 0x17, 0x77,
  0x70, 0x4F, 0xF9, 0x0D, 0x01, 0x77, 0x77, 0x20, 0x5F, 0xE0, 0xE0, 0x27, 0x77, 0x74, 0x08, 0xFD,
  0x05, 0x77, 0x77, 0x60, 0xCF, 0xB0, 0x87, 0x77, 0x77, 0x02, 0x0E, 0xF9, 0x0D, 0x80, 0xC1, 0x00,
  0x7F, 0x90, 0x48, 0x0C, 0xA6, 0x08, 0x93, 0x16, 0xAD, 0xEF, 0xEE, 0xDB, 0x85, 0x15, 0xFF, 0xD0,
  0xC7, 0x01, 0x0A, 0xFE, 0x0B, 0x05, 0x3F, 0xFD, 0x0E, 0x60, 0x50, 0xEF, 0xFA, 0x05, 0x2F, 0xFE,
  0x50, 0x6F, 0xFC, 0x3F, 0xFE, 0x02, 0x30, 0x5F, 0xFC, 0x0B, 0x3F, 0xFE, 0x04, 0x20, 0x3F, 0xFD,
  0x06, 0x48, 0x52, 0x46, 0x8A, 0xCE, 0xFD, 0x06, 0x20, 0xDF, 0x98, 0x4C, 0xA8, 0x9B, 0xED, 0x01,
  0x75, 0x83, 0x24, 0x68, 0xEE, 0x81, 0x80, 0x8E, 0x0D, 0x06, 0x78, 0x33, 0x8E, 0xFC, 0x77, 0x30,
  0xBE, 0x0A, 0x02, 0xE0, 0x87, 0x50, 0x80, 0x77, 0x73, 0x0B, 0xE0, 0xD0, 0xBD, 0x05, 0x77, 0x77,
  0x40, 0xBF, 0xD0, 0x47, 0x77, 0x75, 0x0B, 0xFC, 0x07, 0x77, 0x77, 0x60, 0xBF, 0xB0, 0xC7, 0x77,
  0x77, 0x0B, 0xFB, 0x02, 0x77, 0x77, 0x70, 0xBF, 0xA0, 0xA8, 0x0C, 0x00, 0x0B, 0xFA, 0x02, 0x80,
  0xC0, 0x00, 0xBF, 0x90, 0xC8, 0x0C, 0x10, 0x0B, 0xF9, 0x07, 0x80, 0xC1, 0x00, 0xBF, 0x90, 0x38,
  0x0C, 0x10, 0x0B, 0xF0, 0xE8, 0x0C, 0x20, 0x0B, 0xF0, 0xC8, 0x0C, 0x20, 0x0B, 0xF0, 0x98, 0x0C,
  0x20, 0x0B, 0xF0, 0x88, 0x0C, 0x20, 0x0B, 0xF0, 0x78, 0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20,
  0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B,
  0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0,
  0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x68,
  0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C,
  0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20, 0x0B, 0xF0, 0x68, 0x0C, 0x20,
  0x0B, 0xF0, 0x67, 0x77, 0x73, 0x86, 0x13, 0x46, 0x78, 0xAE, 0xF8, 0x6C, 0x98, 0x65, 0x32, 0x17,
  0x72, 0x85, 0x27, 0x9A, 0xBD, 0xEF, 0xFF, 0xC8, 0x4D, 0xCA, 0x97, 0x37, 0x20, 0x68, 0x0C, 0x0F,
  0x07, 0x72, 0x06, 0x80, 0xC0, 0xF0, 0x77, 0x20, 0x68, 0x0C, 0x0F, 0x07, 0x72, 0x06, 0x80, 0xC0,
  0xF0, 0x77, 0x20, 0x68, 0x0C, 0x0F, 0x07, 0x72,
  // "Ś" (U+015A)
  0x77, 0x75, 0x03, 0x80, 0x57, 0x01, 0x77, 0x77, 0x20, 0xCF, 0xA0, 0x27, 0x77, 0x71, 0x05, 0xFA,
  0x08, 0x77, 0x77, 0x20, 0xDF, 0x90, 0xB7, 0x77, 0x72, 0x08, 0xF9, 0x0D, 0x01, 0x77, 0x77, 0x10,
  0x2F, 0x90, 0xE0, 0x27, 0x77, 0x72, 0x0C, 0xF0, 0xE0, 0x37, 0x77, 0x72, 0x06, 0xF9, 0x04, 0x77,
  0x77, 0x20, 0x10, 0xEF, 0x05, 0x77, 0x77, 0x30, 0xBF, 0x05, 0x77, 0x77, 0x30, 0x5F, 0x06, 0x77,
  0x77, 0x30, 0x10, 0xEE, 0x05, 0x77, 0x77, 0x40, 0xBE, 0x05, 0x77, 0x77, 0x40, 0x8D, 0x0E, 0x04,
  0x77, 0x77, 0x50, 0xDC, 0x0C, 0x02, 0x80, 0xBD, 0x00, 0x84, 0x37, 0x9B, 0xDE, 0xB8, 0x5E, 0xDC,
  0xB9, 0x63, 0x77, 0x71, 0x05, 0x0A, 0xFF, 0xC8, 0x1C, 0x84, 0x77, 0x20, 0x70, 0xDF, 0xFF, 0xA8,
  0x1E, 0x93, 0x74, 0x03, 0x0D, 0xFF, 0xFF, 0x0D, 0x02, 0x71, 0x07, 0xFF, 0xFF, 0xA0, 0xE7, 0x10,
  0x8F, 0xFF, 0xFB, 0x09, 0x70, 0x7F, 0xFF, 0xFC, 0x04, 0x60, 0x3F, 0xC8, 0x3E, 0x96, 0x31, 0x38,
  0x41, 0x34, 0x7A, 0xEF, 0x0E, 0x70, 0xDF, 0xA0, 0xD0, 0x57, 0x78, 0x13, 0x8D, 0xC0, 0x86, 0x05,
  0xFA, 0x08, 0x77, 0x50, 0x30, 0xBA, 0x03, 0x60, 0xCF, 0x90, 0x67, 0x77, 0x10, 0x30, 0x86, 0x01,
  0xF9, 0x0B, 0x77, 0x77, 0x30, 0x5F, 0x90, 0x37, 0x77, 0x73, 0x09, 0xF0, 0xD7, 0x77, 0x74, 0x0B,
  0xF0, 0x97, 0x77, 0x74, 0x0D, 0xF0, 0x77, 0x77, 0x74, 0x0D, 0xF0, 0x67, 0x77, 0x74, 0x0D, 0xF0,
  0x67, 0x77, 0x74, 0x0D, 0xF0, 0x77, 0x77, 0x74, 0x0C, 0xF0, 0x97, 0x77, 0x74, 0x0A, 0xF0, 0xD7,
  0x77, 0x74, 0x07, 0xF9, 0x04, 0x77, 0x77, 0x30, 0x3F, 0x90, 0xC7, 0x77, 0x74, 0x0E, 0xF9, 0x0A,
  0x77, 0x77, 0x30, 0x8F, 0xA0, 0xC0, 0x27, 0x77, 0x71, 0x01, 0x0E, 0xFA, 0x0E, 0x07, 0x77, 0x77,
  0x10, 0x6F, 0xC0, 0xE0, 0x77, 0x77, 0x70, 0xAF, 0xD8, 0x1E, 0x71, 0x77, 0x75, 0x0B, 0xFE, 0x81,
  0xE9, 0x27, 0x77, 0x40, 0xBF, 0xF9, 0x0A, 0x04, 0x77, 0x73, 0x08, 0xFF, 0xA0, 0xC0, 0x57, 0x77,
  0x20, 0x40, 0xDF, 0xFA, 0x0D, 0x06, 0x77, 0x72, 0x06, 0x0E, 0xFF, 0xA0, 0xD0, 0x67, 0x77, 0x20,
  0x80, 0xEF, 0xFA, 0x0C, 0x04, 0x77, 0x71, 0x81, 0x18, 0xEF, 0xFA, 0x0A, 0x01, 0x77, 0x72, 0x07,
  0x0E, 0xFF, 0x90, 0xD0, 0x37, 0x77, 0x30, 0x60, 0xCF, 0xF0, 0xE0, 0x47, 0x77, 0x40, 0x40, 0xBF,
  0xE0, 0xE0, 0x37, 0x77, 0x50, 0x30, 0xBF, 0xD0, 0xD0, 0x17, 0x77, 0x60, 0x30, 0xBF, 0xC0, 0xA7,
  0x77, 0x71, 0x04, 0x0D, 0xFB, 0x03, 0x77, 0x77, 0x20, 0x9F, 0xA0, 0x97, 0x77, 0x73, 0x09, 0xF9,
  0x0E, 0x77, 0x77, 0x40, 0xCF, 0x90, 0x27, 0x77, 0x73, 0x04, 0xF9, 0x05, 0x77, 0x77, 0x40, 0xEF,
  0x07, 0x77, 0x77, 0x40, 0xCF, 0x08, 0x77, 0x77, 0x40, 0xBF, 0x09, 0x77, 0x77, 0x40, 0xAF, 0x09,
  0x77, 0x77, 0x40, 0xCF, 0x08, 0x77, 0x77, 0x40, 0xDF, 0x06, 0x77, 0x77, 0x30, 0x1F, 0x90, 0x47,
  0x77, 0x73, 0x05, 0xF9, 0x01, 0x77, 0x77, 0x30, 0xBF, 0x0D, 0x77, 0x77, 0x30, 0x5F, 0x98, 0x28,
  0x01, 0x17, 0x77, 0x60, 0x20, 0xEF, 0x98, 0x42, 0x05, 0xFA, 0x57, 0x77, 0x30, 0x20, 0xDF, 0x90,
  0xA2, 0x05, 0xB8, 0x2E, 0xA5, 0x17, 0x75, 0x07, 0xFB, 0x02, 0x20, 0x5F, 0x82, 0xC9, 0x52, 0x75,
  0x81, 0x49, 0xEF, 0xB0, 0x73, 0x05, 0xFD, 0x89, 0x0D, 0xBA, 0x98, 0x89, 0xAB, 0xDF, 0xE0, 0xA4,
  0x05, 0xFF, 0xFF, 0xE0, 0xA5, 0x05, 0xFF, 0xFF, 0xD0, 0x96, 0x05, 0xFF, 0xFF, 0xB0, 0xD0, 0x47,
  0x18, 0x13, 0x9E, 0xFF, 0xFD, 0x0D, 0x07, 0x76, 0x82, 0x37, 0xBE, 0xFF, 0xD8, 0x1E, 0x94, 0x77,
  0x58, 0x71, 0x46, 0x8A, 0xCC, 0xDE, 0xB8, 0x5E, 0xDC, 0xA8, 0x52, 0x77,
  // "ś" (U+015B)
  0x77, 0x71, 0x03, 0x80, 0x57, 0x01, 0x77, 0x74, 0x0C, 0xFA, 0x02, 0x77, 0x73, 0x05, 0xFA, 0x08,
  0x77, 0x74, 0x0D, 0xF9, 0x0B, 0x77, 0x74, 0x08, 0xF9, 0x0D, 0x01, 0x77, 0x73, 0x02, 0xF9, 0x0E,
  0x02, 0x77, 0x74, 0x0C, 0xF0, 0xE0, 0x37, 0x77, 0x40, 0x6F, 0x90, 0x47, 0x77, 0x40, 0x10, 0xEF,
  0x05, 0x77, 0x75, 0x0B, 0xF0, 0x57, 0x77, 0x50, 0x5F, 0x06, 0x77, 0x75, 0x01, 0x0E, 0xE0, 0x57,
  0x77, 0x60, 0xBE, 0x05, 0x77, 0x76, 0x08, 0xD0, 0xE0, 0x47, 0x77, 0x70, 0xDC, 0x0C, 0x02, 0x80,
  0xB9, 0x30, 0x85, 0x46, 0x9B, 0xDD, 0xEA, 0x85, 0xED, 0xCA, 0x86, 0x37, 0x73, 0x05, 0x0A, 0xFF,
  0xC8, 0x1B, 0x73, 0x74, 0x07, 0x0E, 0xFF, 0xFA, 0x81, 0xD7, 0x26, 0x04, 0x0D, 0xFF, 0xFE, 0x09,
  0x50, 0x6F, 0xFF, 0xF9, 0x04, 0x40, 0x5F, 0xFF, 0xF9, 0x0D, 0x40, 0x10, 0xEF, 0xC8, 0x90, 0xDB,
  0x99, 0x89, 0x9A, 0xCE, 0xF9, 0x08, 0x40, 0x9F, 0xA0, 0x90, 0x47, 0x48, 0x22, 0x59, 0xEC, 0x02,
  0x40, 0xEF, 0x0C, 0x02, 0x77, 0x38, 0x24, 0xAF, 0xC4, 0x04, 0xF0, 0xE0, 0x17, 0x76, 0x02, 0x03,
  0x40, 0x8F, 0x07, 0x77, 0x76, 0x0A, 0xF0, 0x37, 0x77, 0x60, 0xBF, 0x01, 0x77, 0x76, 0x0A, 0xF0,
  0x27, 0x77, 0x60, 0x9F, 0x07, 0x77, 0x76, 0x07, 0xF0, 0xD0, 0x17, 0x77, 0x50, 0x3F, 0x90, 0xC0,
  0x17, 0x77, 0x50, 0xDF, 0x90, 0xD0, 0x47, 0x77, 0x40, 0x6F, 0xB0, 0xB0, 0x37, 0x77, 0x30, 0xBF,
  0xC0, 0xB0, 0x47, 0x77, 0x20, 0xCF, 0xD0, 0xD0, 0x67, 0x77, 0x10, 0xBF, 0xE8, 0x1E, 0x81, 0x77,
  0x60, 0x7F, 0xF9, 0x0A, 0x03, 0x77, 0x50, 0x20, 0xAF, 0xF9, 0x0C, 0x05, 0x77, 0x50, 0x30, 0xBF,
  0xF9, 0x0D, 0x06, 0x77, 0x50, 0x30, 0xAF, 0xF9, 0x0D, 0x05, 0x77, 0x50, 0x20, 0x9F, 0xF9, 0x0B,
  0x01, 0x77, 0x58, 0x11, 0x8E, 0xFE, 0x0E, 0x03, 0x77, 0x70, 0x60, 0xDF, 0xD0, 0xE0, 0x27, 0x77,
  0x10, 0x40, 0xBF, 0xC0, 0xD7, 0x77, 0x30, 0x40, 0xBF, 0xB0, 0x77, 0x77, 0x40, 0x50, 0xEF, 0x90,
  0xD7, 0x77, 0x50, 0x10, 0xDF, 0x90, 0x27, 0x77, 0x50, 0x3F, 0x90, 0x57, 0x77, 0x60, 0xCF, 0x07,
  0x77, 0x76, 0x09, 0xF0, 0x87, 0x77, 0x60, 0x9F, 0x08, 0x77, 0x76, 0x0A, 0xF0, 0x77, 0x77, 0x60,
  0xDF, 0x05, 0x02, 0x77, 0x74, 0x04, 0xF9, 0x83, 0x28, 0xE8, 0x27, 0x77, 0x01, 0x0D, 0xF8, 0x1D,
  0x08, 0xB8, 0x1B, 0x61, 0x77, 0x30, 0x20, 0xCF, 0x98, 0x17, 0x08, 0xE8, 0x1B, 0x73, 0x75, 0x04,
  0x09, 0xFA, 0x82, 0xE1, 0x08, 0xFB, 0x89, 0x0D, 0xBA, 0x98, 0x89, 0x9A, 0xDF, 0xD0, 0x62, 0x08,
  0xFF, 0xFF, 0xB0, 0xA3, 0x08, 0xFF, 0xFF, 0xA0, 0xA4, 0x08, 0xFF, 0xFF, 0x90, 0x75, 0x81, 0x17,
  0xDF, 0xFF, 0xC0, 0xA0, 0x27, 0x28, 0x22, 0x7B, 0xEF, 0xFC, 0x81, 0xC7, 0x27, 0x71, 0x86, 0x35,
  0x79, 0xBD, 0xDE, 0xB8, 0x5E, 0xDC, 0xA7, 0x51, 0x74,
  // "Ŝ" (U+015C)
  0x77, 0x30, 0x28, 0x04, 0x77, 0x77, 0x74, 0x0C, 0xF9, 0x08, 0x77, 0x77, 0x20, 0x6F, 0xB0, 0x37,
  0x77, 0x70, 0x3F, 0xC0, 0xD0, 0x17, 0x77, 0x60, 0xDF, 0xD0, 0xA7, 0x77, 0x50, 0xBF, 0xF0, 0x77,
  0x77, 0x30, 0x8F, 0x0A, 0x0D, 0xF0, 0x57, 0x77, 0x10, 0x6F, 0x82, 0x90, 0x1D, 0xF0, 0x37, 0x76,
  0x04, 0xF0, 0x93, 0x01, 0x0D, 0xE0, 0xE0, 0x27, 0x74, 0x02, 0x0E, 0xE0, 0x95, 0x01, 0x0C, 0xE0,
  0xD0, 0x17, 0x72, 0x01, 0x0D, 0xE0, 0x87, 0x01, 0x0C, 0xE0, 0xC7, 0x72, 0x0C, 0xE0, 0x87, 0x20,
  0x10, 0xBE, 0x0B, 0x77, 0x0B, 0xE0, 0x67, 0x50, 0xAE, 0x0A, 0x75, 0x0A, 0xD0, 0xE0, 0x47, 0x70,
  0x7E, 0x0A, 0x73, 0x03, 0xD0, 0xB0, 0x17, 0x72, 0x03, 0x0D, 0xD0, 0x38, 0x0B, 0xB3, 0x08, 0x43,
  0x79, 0xBD, 0xEB, 0x85, 0xED, 0xCB, 0x96, 0x37, 0x77, 0x10, 0x50, 0xAF, 0xFC, 0x81, 0xC8, 0x47,
  0x72, 0x07, 0x0D, 0xFF, 0xFA, 0x81, 0xE9, 0x37, 0x40, 0x30, 0xDF, 0xFF, 0xF0, 0xD0, 0x27, 0x10,
  0x7F, 0xFF, 0xFA, 0x0E, 0x71, 0x08, 0xFF, 0xFF, 0xB0, 0x97, 0x07, 0xFF, 0xFF, 0xC0, 0x46, 0x03,
  0xFC, 0x83, 0xE9, 0x63, 0x13, 0x84, 0x13, 0x47, 0xAE, 0xF0, 0xE7, 0x0D, 0xFA, 0x0D, 0x05, 0x77,
  0x81, 0x38, 0xDC, 0x08, 0x60, 0x5F, 0xA0, 0x87, 0x75, 0x03, 0x0B, 0xA0, 0x36, 0x0C, 0xF9, 0x06,
  0x77, 0x71, 0x03, 0x08, 0x60, 0x1F, 0x90, 0xB7, 0x77, 0x73, 0x05, 0xF9, 0x03, 0x77, 0x77, 0x30,
  0x9F, 0x0D, 0x77, 0x77, 0x40, 0xBF, 0x09, 0x77, 0x77, 0x40, 0xDF, 0x07, 0x77, 0x77, 0x40, 0xDF,
  0x06, 0x77, 0x77, 0x40, 0xDF, 0x06, 0x77, 0x77, 0x40, 0xDF, 0x07, 0x77, 0x77, 0x40, 0xCF, 0x09,
  0x77, 0x77, 0x40, 0xAF, 0x0D, 0x77, 0x77, 0x40, 0x7F, 0x90, 0x47, 0x77, 0x73, 0x03, 0xF9, 0x0C,
  0x77, 0x77, 0x40, 0xEF, 0x90, 0xA7, 0x77, 0x73, 0x08, 0xFA, 0x0C, 0x02, 0x77, 0x77, 0x10, 0x10,
  0xEF, 0xA0, 0xE0, 0x77, 0x77, 0x71, 0x06, 0xFC, 0x0E, 0x07, 0x77, 0x77, 0x0A, 0xFD, 0x81, 0xE7,
  0x17, 0x77, 0x50, 0xBF, 0xE8, 0x1E, 0x92, 0x77, 0x74, 0x0B, 0xFF, 0x90, 0xA0, 0x47, 0x77, 0x30,
  0x8F, 0xFA, 0x0C, 0x05, 0x77, 0x72, 0x04, 0x0D, 0xFF, 0xA0, 0xD0, 0x67, 0x77, 0x20, 0x60, 0xEF,
  0xFA, 0x0D, 0x06, 0x77, 0x72, 0x08, 0x0E, 0xFF, 0xA0, 0xC0, 0x47, 0x77, 0x18, 0x11, 0x8E, 0xFF,
  0xA0, 0xA0, 0x17, 0x77, 0x20, 0x70, 0xEF, 0xF9, 0x0D, 0x03, 0x77, 0x73, 0x06, 0x0C, 0xFF, 0x0E,
  0x04, 0x77, 0x74, 0x04, 0x0B, 0xFE, 0x0E, 0x03, 0x77, 0x75, 0x03, 0x0B, 0xFD, 0x0D, 0x01, 0x77,
  0x76, 0x03, 0x0B, 0xFC, 0x0A, 0x77, 0x77, 0x10, 0x40, 0xDF, 0xB0, 0x37, 0x77, 0x72, 0x09, 0xFA,
  0x09, 0x77, 0x77, 0x30, 0x9F, 0x90, 0xE7, 0x77, 0x74, 0x0C, 0xF9, 0x02, 0x77, 0x77, 0x30, 0x4F,
  0x90, 0x57, 0x77, 0x74, 0x0E, 0xF0, 0x77, 0x77, 0x74, 0x0C, 0xF0, 0x87, 0x77, 0x74, 0x0B, 0xF0,
  0x97, 0x77, 0x74, 0x0A, 0xF0, 0x97, 0x77, 0x74, 0x0C, 0xF0, 0x87, 0x77, 0x74, 0x0D, 0xF0, 0x67,
  0x77, 0x73, 0x01, 0xF9, 0x04, 0x77, 0x77, 0x30, 0x5F, 0x90, 0x17, 0x77, 0x73, 0x0B, 0xF0, 0xD7,
  0x77, 0x73, 0x05, 0xF9, 0x82, 0x80, 0x11, 0x77, 0x76, 0x02, 0x0E, 0xF9, 0x84, 0x20, 0x5F, 0xA5,
  0x77, 0x73, 0x02, 0x0D, 0xF9, 0x0A, 0x20, 0x5B, 0x82, 0xEA, 0x51, 0x77, 0x50, 0x7F, 0xB0, 0x22,
  0x05, 0xF8, 0x2C, 0x95, 0x27, 0x58, 0x14, 0x9E, 0xFB, 0x07, 0x30, 0x5F, 0xD8, 0x90, 0xDB, 0xA9,
  0x88, 0x9A, 0xBD, 0xFE, 0x0A, 0x40, 0x5F, 0xFF, 0xFE, 0x0A, 0x50, 0x5F, 0xFF, 0xFD, 0x09, 0x60,
  0x5F, 0xFF, 0xFB, 0x0D, 0x04, 0x71, 0x81, 0x39, 0xEF, 0xFF, 0xD0, 0xD0, 0x77, 0x68, 0x23, 0x7B,
  0xEF, 0xFD, 0x81, 0xE9, 0x47, 0x75, 0x87, 0x14, 0x68, 0xAC, 0xCD, 0xEB, 0x85, 0xED, 0xCA, 0x85,
  0x27, 0x70,
  // "ŝ" (U+015D)
  0x76, 0x02, 0x80, 0x47, 0x77, 0x76, 0x0C, 0xF9, 0x08, 0x77, 0x74, 0x06, 0xFB, 0x03, 0x77, 0x72,
  0x03, 0xFC, 0x0D, 0x01, 0x77, 0x71, 0x0D, 0xFD, 0x0A, 0x77, 0x70, 0xBF, 0xF0, 0x77, 0x75, 0x08,
  0xF0, 0xA0, 0xDF, 0x05, 0x77, 0x30, 0x6F, 0x82, 0x90, 0x1D, 0xF0, 0x37, 0x71, 0x04, 0xF0, 0x93,
  0x01, 0x0D, 0xE0, 0xE0, 0x27, 0x60, 0x20, 0xEE, 0x09, 0x50, 0x10, 0xCE, 0x0D, 0x01, 0x74, 0x01,
  0x0D, 0xE0, 0x87, 0x01, 0x0C, 0xE0, 0xC7, 0x40, 0xCE, 0x08, 0x72, 0x01, 0x0B, 0xE0, 0xB7, 0x20,
  0xBE, 0x06, 0x75, 0x0A, 0xE0, 0xA7, 0x0A, 0xD0, 0xE0, 0x47, 0x70, 0x7E, 0x0A, 0x50, 0x3D, 0x0B,
  0x01, 0x77, 0x20, 0x30, 0xDD, 0x03, 0x80, 0xAF, 0x60, 0x85, 0x46, 0x9B, 0xDD, 0xEA, 0x85, 0xED,
  0xCA, 0x86, 0x37, 0x73, 0x05, 0x0A, 0xFF, 0xC8, 0x1B, 0x73, 0x74, 0x07, 0x0E, 0xFF, 0xFA, 0x81,
  0xD7, 0x26, 0x04, 0x0D, 0xFF, 0xFE, 0x09, 0x50, 0x6F, 0xFF, 0xF9, 0x04, 0x40, 0x5F, 0xFF, 0xF9,
  0x0D, 0x40, 0x10, 0xEF, 0xC8, 0x90, 0xDB, 0x99, 0x89, 0x9A, 0xCE, 0xF9, 0x08, 0x40, 0x9F, 0xA0,
  0x90, 0x47, 0x48, 0x22, 0x59, 0xEC, 0x02, 0x40, 0xEF, 0x0C, 0x02, 0x77, 0x38, 0x24, 0xAF, 0xC4,
  0x04, 0xF0, 0xE0, 0x17, 0x76, 0x02, 0x03, 0x40, 0x8F, 0x07, 0x77, 0x76, 0x0A, 0xF0, 0x37, 0x77,
  0x60, 0xBF, 0x01, 0x77, 0x76, 0x0A, 0xF0, 0x27, 0x77, 0x60, 0x9F, 0x07, 0x77, 0x76, 0x07, 0xF0,
  0xD0, 0x17, 0x77, 0x50, 0x3F, 0x90, 0xC0, 0x17, 0x77, 0x50, 0xDF, 0x90, 0xD0, 0x47, 0x77, 0x40,
  0x6F, 0xB0, 0xB0, 0x37, 0x77, 0x30, 0xBF, 0xC0, 0xB0, 0x47, 0x77, 0x20, 0xCF, 0xD0, 0xD0, 0x67,
  0x77, 0x10, 0xBF, 0xE8, 0x1E, 0x81, 0x77, 0x60, 0x7F, 0xF9, 0x0A, 0x03, 0x77, 0x50, 0x20, 0xAF,
  0xF9, 0x0C, 0x05, 0x77, 0x50, 0x30, 0xBF, 0xF9, 0x0D, 0x06, 0x77, 0x50, 0x30, 0xAF, 0xF9, 0x0D,
  0x05, 0x77, 0x50, 0x20, 0x9F, 0xF9, 0x0B, 0x01, 0x77, 0x58, 0x11, 0x8E, 0xFE, 0x0E, 0x03, 0x77,
  0x70, 0x60, 0xDF, 0xD0, 0xE0, 0x27, 0x77, 0x10, 0x40, 0xBF, 0xC0, 0xD7, 0x77, 0x30, 0x40, 0xBF,
  0xB0, 0x77, 0x77, 0x40, 0x50, 0xEF, 0x90, 0xD7, 0x77, 0x50, 0x10, 0xDF, 0x90, 0x27, 0x77, 0x50,
  0x3F, 0x90, 0x57, 0x77, 0x60, 0xCF, 0x07, 0x77, 0x76, 0x09, 0xF0, 0x87, 0x77, 0x60, 0x9F, 0x08,
  0x77, 0x76, 0x0A, 0xF0, 0x77, 0x77, 0x60, 0xDF, 0x05, 0x02, 0x77, 0x74, 0x04, 0xF9, 0x83, 0x28,
  0xE8, 0x27, 0x77, 0x01, 0x0D, 0xF8, 0x1D, 0x08, 0xB8, 0x1B, 0x61, 0x77, 0x30, 0x20, 0xCF, 0x98,
  0x17, 0x08, 0xE8, 0x1B, 0x73, 0x75, 0x04, 0x09, 0xFA, 0x82, 0xE1, 0x08, 0xFB, 0x89, 0x0D, 0xBA,
  0x98, 0x89, 0x9A, 0xDF, 0xD0, 0x62, 0x08, 0xFF, 0xFF, 0xB0, 0xA3, 0x08, 0xFF, 0xFF, 0xA0, 0xA4,
  0x08, 0xFF, 0xFF, 0x90, 0x75, 0x81, 0x17, 0xDF, 0xFF, 0xC0, 0xA0, 0x27, 0x28, 0x22, 0x7B, 0xEF,
  0xFC, 0x81, 0xC7, 0x27, 0x71, 0x86, 0x35, 0x79, 0xBD, 0xDE, 0xB8, 0x5E, 0xDC, 0xA7, 0x51, 0x74,
  // "Ş" (U+015E)
  0x77, 0x18, 0x43, 0x79, 0xBD, 0xEB, 0x85, 0xED, 0xCB, 0x96, 0x37, 0x77, 0x10, 0x50, 0xAF, 0xFC,
  0x81, 0xC8, 0x47, 0x72, 0x07, 0x0D, 0xFF, 0xFA, 0x81, 0xE9, 0x37, 0x40, 0x30, 0xDF, 0xFF, 0xF0,
  0xD0, 0x27, 0x10, 0x7F, 0xFF, 0xFA, 0x0E, 0x71, 0x08, 0xFF, 0xFF, 0xB0, 0x97, 0x07, 0xFF, 0xFF,
  0xC0, 0x46, 0x03, 0xFC, 0x83, 0xE9, 0x63, 0x13, 0x84, 0x13, 0x47, 0xAE, 0xF0, 0xE7, 0x0D, 0xFA,
  0x0D, 0x05, 0x77, 0x81, 0x38, 0xDC, 0x08, 0x60, 0x5F, 0xA0, 0x87, 0x75, 0x03, 0x0B, 0xA0, 0x36,
  0x0C, 0xF9, 0x06, 0x77, 0x71, 0x03, 0x08, 0x60, 0x1F, 0x90, 0xB7, 0x77, 0x73, 0x05, 0xF9, 0x03,
  0x77, 0x77, 0x30, 0x9F, 0x0D, 0x77, 0x77, 0x40, 0xBF, 0x09, 0x77, 0x77, 0x40, 0xDF, 0x07, 0x77,
  0x77, 0x40, 0xDF, 0x06, 0x77, 0x77, 0x40, 0xDF, 0x06, 0x77, 0x77, 0x40, 0xDF, 0x07, 0x77, 0x77,
  0x40, 0xCF, 0x09, 0x77, 0x77, 0x40, 0xAF, 0x0D, 0x77, 0x77, 0x40, 0x7F, 0x90, 0x47, 0x77, 0x73,
  0x03, 0xF9, 0x0C, 0x77, 0x77, 0x40, 0xEF, 0x90, 0xA7, 0x77, 0x73, 0x08, 0xFA, 0x0C, 0x02, 0x77,
  0x77, 0x10, 0x10, 0xEF, 0xA0, 0xE0, 0x77, 0x77, 0x71, 0x06, 0xFC, 0x0E, 0x07, 0x77, 0x77, 0x0A,
  0xFD, 0x81, 0xE7, 0x17, 0x77, 0x50, 0xBF, 0xE8, 0x1E, 0x92, 0x77, 0x74, 0x0B, 0xFF, 0x90, 0xA0,
  0x47, 0x77, 0x30, 0x8F, 0xFA, 0x0C, 0x05, 0x77, 0x72, 0x04, 0x0D, 0xFF, 0xA0, 0xD0, 0x67, 0x77,
  0x20, 0x60, 0xEF, 0xFA, 0x0D, 0x06, 0x77, 0x72, 0x08, 0x0E, 0xFF, 0xA0, 0xC0, 0x47, 0x77, 0x18,
  0x11, 0x8E, 0xFF, 0xA0, 0xA0, 0x17, 0x77, 0x20, 0x70, 0xEF, 0xF9, 0x0D, 0x03, 0x77, 0x73, 0x06,
  0x0C, 0xFF, 0x0E, 0x04, 0x77, 0x74, 0x04, 0x0B, 0xFE, 0x0E, 0x03, 0x77, 0x75, 0x03, 0x0B, 0xFD,
  0x0D, 0x01, 0x77, 0x76, 0x03, 0x0B, 0xFC, 0x0A, 0x77, 0x77, 0x10, 0x40, 0xDF, 0xB0, 0x37, 0x77,
  0x72, 0x09, 0xFA, 0x09, 0x77, 0x77, 0x30, 0x9F, 0x90, 0xE7, 0x77, 0x74, 0x0C, 0xF9, 0x02, 0x77,
  0x77, 0x30, 0x4F, 0x90, 0x57, 0x77, 0x74, 0x0E, 0xF0, 0x77, 0x77, 0x74, 0x0C, 0xF0, 0x87, 0x77,
  0x74, 0x0B, 0xF0, 0x97, 0x77, 0x74, 0x0A, 0xF0, 0x97, 0x77, 0x74, 0x0C, 0xF0, 0x87, 0x77, 0x74,
  0x0D, 0xF0, 0x67, 0x77, 0x73, 0x01, 0xF9, 0x04, 0x77, 0x77, 0x30, 0x5F, 0x90, 0x17, 0x77, 0x73,
  0x0B, 0xF0, 0xD7, 0x77, 0x73, 0x05, 0xF9, 0x82, 0x80, 0x11, 0x77, 0x76, 0x02, 0x0E, 0xF9, 0x84,
  0x20, 0x5F, 0xA5, 0x77, 0x73, 0x02, 0x0D, 0xF9, 0x0A, 0x20, 0x5B, 0x82, 0xEA, 0x51, 0x77, 0x50,
  0x7F, 0xB0, 0x22, 0x05, 0xF8, 0x2C, 0x95, 0x27, 0x58, 0x14, 0x9E, 0xFB, 0x07, 0x30, 0x5F, 0xD8,
  0x90, 0xDB, 0xA9, 0x88, 0x9A, 0xBD, 0xFE, 0x0A, 0x40, 0x5F, 0xFF, 0xFE, 0x0A, 0x50, 0x5F, 0xFF,
  0xFD, 0x09, 0x60, 0x5F, 0xFF, 0xFB, 0x0D, 0x04, 0x71, 0x81, 0x39, 0xEF, 0xFF, 0xD0, 0xD0, 0x77,
  0x68, 0x23, 0x7B, 0xEF, 0xFD, 0x81, 0xE9, 0x47, 0x75, 0x87, 0x14, 0x68, 0xAC, 0xCD, 0xEE, 0x82,
  0xB8, 0x52, 0x77, 0x77, 0x30, 0xAC, 0x09, 0x77, 0x77, 0x60, 0x2D, 0x02, 0x77, 0x77, 0x60, 0x9C,
  0x0B, 0x77, 0x77, 0x60, 0x1D, 0x04, 0x77, 0x77, 0x60, 0x8D, 0x07, 0x02, 0x77, 0x77, 0x40, 0x10,
  0xEF, 0x0C, 0x05, 0x77, 0x77, 0x20, 0x7F, 0xB0, 0xC0, 0x27, 0x77, 0x78, 0x24, 0x7A, 0xDF, 0x90,
  0xE0, 0x37, 0x77, 0x73, 0x81, 0x38, 0xEE, 0x0C, 0x77, 0x77, 0x50, 0x10, 0xCE, 0x04, 0x77, 0x77,
  0x50, 0x1E, 0x08, 0x77, 0x77, 0x60, 0xBD, 0x0A, 0x77, 0x77, 0x60, 0xAD, 0x0A, 0x77, 0x77, 0x60,
  0xDD, 0x09, 0x77, 0x77, 0x50, 0x8E, 0x05, 0x77, 0x72, 0x81, 0x42, 0x13, 0x82, 0x13, 0x7C, 0xE0,
  0xE7, 0x77, 0x20, 0x1F, 0xFA, 0x06, 0x77, 0x72, 0x01, 0xFF, 0x90, 0xA7, 0x77, 0x30, 0x1F, 0xF0,
  0x87, 0x77, 0x40, 0x1F, 0xC8, 0x1E, 0xA2, 0x77, 0x76, 0x81, 0xAD, 0xEA, 0x84, 0xEE, 0xDA, 0x85,
  0x77, 0x50,
  // "ş" (U+015F)
  0x75, 0x85, 0x46, 0x9B, 0xDD, 0xEA, 0x85, 0xED, 0xCA, 0x86, 0x37, 0x73, 0x05, 0x0A, 0xFF, 0xC8,
  0x1B, 0x73, 0x74, 0x07, 0x0E, 0xFF, 0xFA, 0x81, 0xD7, 0x26, 0x04, 0x0D, 0xFF, 0xFE, 0x09, 0x50,
  0x6F, 0xFF, 0xF9, 0x04, 0x40, 0x5F, 0xFF, 0xF9, 0x0D, 0x40, 0x10, 0xEF, 0xC8, 0x90, 0xDB, 0x99,
  0x89, 0x9A, 0xCE, 0xF9, 0x08, 0x40, 0x9F, 0xA0, 0x90, 0x47, 0x48, 0x22, 0x59, 0xEC, 0x02, 0x40,
  0xEF, 0x0C, 0x02, 0x77, 0x38, 0x24, 0xAF, 0xC4, 0x04, 0xF0, 0xE0, 0x17, 0x76, 0x02, 0x03, 0x40,
  0x8F, 0x07, 0x77, 0x76, 0x0A, 0xF0, 0x37, 0x77, 0x60, 0xBF, 0x01, 0x77, 0x76, 0x0A, 0xF0, 0x27,
  0x77, 0x60, 0x9F, 0x07, 0x77, 0x76, 0x07, 0xF0, 0xD0, 0x17, 0x77, 0x50, 0x3F, 0x90, 0xC0, 0x17,
  0x77, 0x50, 0xDF, 0x90, 0xD0, 0x47, 0x77, 0x40, 0x6F, 0xB0, 0xB0, 0x37, 0x77, 0x30, 0xBF, 0xC0,
  0xB0, 0x47, 0x77, 0x20, 0xCF, 0xD0, 0xD0, 0x67, 0x77, 0x10, 0xBF, 0xE8, 0x1E, 0x81, 0x77, 0x60,
  0x7F, 0xF9, 0x0A, 0x03, 0x77, 0x50, 0x20, 0xAF, 0xF9, 0x0C, 0x05, 0x77, 0x50, 0x30, 0xBF, 0xF9,
  0x0D, 0x06, 0x77, 0x50, 0x30, 0xAF, 0xF9, 0x0D, 0x05, 0x77, 0x50, 0x20, 0x9F, 0xF9, 0x0B, 0x01,
  0x77, 0x58, 0x11, 0x8E, 0xFE, 0x0E, 0x03, 0x77, 0x70, 0x60, 0xDF, 0xD0, 0xE0, 0x27, 0x77, 0x10,
  0x40, 0xBF, 0xC0, 0xD7, 0x77, 0x30, 0x40, 0xBF, 0xB0, 0x77, 0x77, 0x40, 0x50, 0xEF, 0x90, 0xD7,
  0x77, 0x50, 0x10, 0xDF, 0x90, 0x27, 0x77, 0x50, 0x3F, 0x90, 0x57, 0x77, 0x60, 0xCF, 0x07, 0x77,
  0x76, 0x09, 0xF0, 0x87, 0x77, 0x60, 0x9F, 0x08, 0x77, 0x76, 0x0A, 0xF0, 0x77, 0x77, 0x60, 0xDF,
  0x05, 0x02, 0x77, 0x74, 0x04, 0xF9, 0x83, 0x28, 0xE8, 0x27, 0x77, 0x01, 0x0D, 0xF8, 0x1D, 0x08,
  0xB8, 0x1B, 0x61, 0x77, 0x30, 0x20, 0xCF, 0x98, 0x17, 0x08, 0xE8, 0x1B, 0x73, 0x75, 0x04, 0x09,
  0xFA, 0x82, 0xE1, 0x08, 0xFB, 0x89, 0x0D, 0xBA, 0x98, 0x89, 0x9A, 0xDF, 0xD0, 0x62, 0x08, 0xFF,
  0xFF, 0xB0, 0xA3, 0x08, 0xFF, 0xFF, 0xA0, 0xA4, 0x08, 0xFF, 0xFF, 0x90, 0x75, 0x81, 0x17, 0xDF,
  0xFF, 0xC0, 0xA0, 0x27, 0x28, 0x22, 0x7B, 0xEF, 0xFC, 0x81, 0xC7, 0x27, 0x71, 0x86, 0x35, 0x79,
  0xBD, 0xDE, 0xE8, 0x2B, 0x75, 0x17, 0x77, 0x50, 0xAC, 0x09, 0x77, 0x77, 0x10, 0x2D, 0x02, 0x77,
  0x77, 0x10, 0x9C, 0x0B, 0x77, 0x77, 0x10, 0x1D, 0x04, 0x77, 0x77, 0x10, 0x8D, 0x07, 0x02, 0x77,
  0x76, 0x01, 0x0E, 0xF0, 0xC0, 0x57, 0x77, 0x40, 0x7F, 0xB0, 0xC0, 0x27, 0x77, 0x28, 0x24, 0x7A,
  0xDF, 0x90, 0xE0, 0x37, 0x77, 0x58, 0x13, 0x8E, 0xE0, 0xC7, 0x77, 0x70, 0x10, 0xCE, 0x04, 0x77,
  0x77, 0x01, 0xE0, 0x87, 0x77, 0x71, 0x0B, 0xD0, 0xA7, 0x77, 0x71, 0x0A, 0xD0, 0xA7, 0x77, 0x71,
  0x0D, 0xD0, 0x97, 0x77, 0x70, 0x8E, 0x05, 0x77, 0x48, 0x14, 0x21, 0x38, 0x21, 0x37, 0xCE, 0x0E,
  0x77, 0x40, 0x1F, 0xFA, 0x06, 0x77, 0x40, 0x1F, 0xF9, 0x0A, 0x77, 0x50, 0x1F, 0xF0, 0x87, 0x76,
  0x01, 0xFC, 0x81, 0xEA, 0x27, 0x77, 0x18, 0x1A, 0xDE, 0xA8, 0x4E, 0xED, 0xA8, 0x57, 0x72,
  // "Š" (U+0160)
  0x60, 0x18, 0x01, 0x70, 0x47, 0x74, 0x05, 0x80, 0x17, 0x01, 0x72, 0x02, 0xE0, 0x87, 0x71, 0x01,
  0x0A, 0xE0, 0x27, 0x30, 0x8E, 0x0C, 0x01, 0x75, 0x03, 0x0D, 0xE0, 0x87, 0x50, 0x9E, 0x0D, 0x03,
  0x73, 0x05, 0x0E, 0xE0, 0x87, 0x70, 0xAF, 0x05, 0x71, 0x07, 0xF0, 0x97, 0x72, 0x0B, 0xF0, 0x66,
  0x09, 0xF0, 0x97, 0x74, 0x0C, 0xF0, 0x74, 0x0A, 0xF0, 0xA7, 0x75, 0x01, 0x0D, 0xF0, 0x62, 0x0A,
  0xF0, 0xC7, 0x77, 0x02, 0x0E, 0xF0, 0x60, 0xBF, 0x0D, 0x01, 0x77, 0x71, 0x04, 0xFF, 0x90, 0xD0,
  0x17, 0x77, 0x30, 0x5F, 0xE0, 0xE0, 0x27, 0x77, 0x50, 0x8F, 0xD0, 0x57, 0x77, 0x70, 0xCF, 0xB0,
  0x87, 0x77, 0x71, 0x02, 0x0E, 0xF9, 0x0D, 0x77, 0x77, 0x30, 0x7F, 0x90, 0x48, 0x0B, 0xC6, 0x08,
  0x43, 0x79, 0xBD, 0xEB, 0x85, 0xED, 0xCB, 0x96, 0x37, 0x77, 0x10, 0x50, 0xAF, 0xFC, 0x81, 0xC8,
  0x47, 0x72, 0x07, 0x0D, 0xFF, 0xFA, 0x81, 0xE9, 0x37, 0x40, 0x30, 0xDF, 0xFF, 0xF0, 0xD0, 0x27,
  0x10, 0x7F, 0xFF, 0xFA, 0x0E, 0x71, 0x08, 0xFF, 0xFF, 0xB0, 0x97, 0x07, 0xFF, 0xFF, 0xC0, 0x46,
  0x03, 0xFC, 0x83, 0xE9, 0x63, 0x13, 0x84, 0x13, 0x47, 0xAE, 0xF0, 0xE7, 0x0D, 0xFA, 0x0D, 0x05,
  0x77, 0x81, 0x38, 0xDC, 0x08, 0x60, 0x5F, 0xA0, 0x87, 0x75, 0x03, 0x0B, 0xA0, 0x36, 0x0C, 0xF9,
  0x06, 0x77, 0x71, 0x03, 0x08, 0x60, 0x1F, 0x90, 0xB7, 0x77, 0x73, 0x05, 0xF9, 0x03, 0x77, 0x77,
  0x30, 0x9F, 0x0D, 0x77, 0x77, 0x40, 0xBF, 0x09, 0x77, 0x77, 0x40, 0xDF, 0x07, 0x77, 0x77, 0x40,
  0xDF, 0x06, 0x77, 0x77, 0x40, 0xDF, 0x06, 0x77, 0x77, 0x40, 0xDF, 0x07, 0x77, 0x77, 0x40, 0xCF,
  0x09, 0x77, 0x77, 0x40, 0xAF, 0x0D, 0x77, 0x77, 0x40, 0x7F, 0x90, 0x47, 0x77, 0x73, 0x03, 0xF9,
  0x0C, 0x77, 0x77, 0x40, 0xEF, 0x90, 0xA7, 0x77, 0x73, 0x08, 0xFA, 0x0C, 0x02, 0x77, 0x77, 0x10,
  0x10, 0xEF, 0xA0, 0xE0, 0x77, 0x77, 0x71, 0x06, 0xFC, 0x0E, 0x07, 0x77, 0x77, 0x0A, 0xFD, 0x81,
  0xE7, 0x17, 0x77, 0x50, 0xBF, 0xE8, 0x1E, 0x92, 0x77, 0x74, 0x0B, 0xFF, 0x90, 0xA0, 0x47, 0x77,
  0x30, 0x8F, 0xFA, 0x0C, 0x05, 0x77, 0x72, 0x04, 0x0D, 0xFF, 0xA0, 0xD0, 0x67, 0x77, 0x20, 0x60,
  0xEF, 0xFA, 0x0D, 0x06, 0x77, 0x72, 0x08, 0x0E, 0xFF, 0xA0, 0xC0, 0x47, 0x77, 0x18, 0x11, 0x8E,
  0xFF, 0xA0, 0xA0, 0x17, 0x77, 0x20, 0x70, 0xEF, 0xF9, 0x0D, 0x03, 0x77, 0x73, 0x06, 0x0C, 0xFF,
  0x0E, 0x04, 0x77, 0x74, 0x04, 0x0B, 0xFE, 0x0E, 0x03, 0x77, 0x75, 0x03, 0x0B, 0xFD, 0x0D, 0x01,
  0x77, 0x76, 0x03, 0x0B, 0xFC, 0x0A, 0x77, 0x77, 0x10, 0x40, 0xDF, 0xB0, 0x37, 0x77, 0x72, 0x09,
  0xFA, 0x09, 0x77, 0x77, 0x30, 0x9F, 0x90, 0xE7, 0x77, 0x74, 0x0C, 0xF9, 0x02, 0x77, 0x77, 0x30,
  0x4F, 0x90, 0x57, 0x77, 0x74, 0x0E, 0xF0, 0x77, 0x77, 0x74, 0x0C, 0xF0, 0x87, 0x77, 0x74, 0x0B,
  0xF0, 0x97, 0x77, 0x74, 0x0A, 0xF0, 0x97, 0x77, 0x74, 0x0C, 0xF0, 0x87, 0x77, 0x74, 0x0D, 0xF0,
  0x67, 0x77, 0x73, 0x01, 0xF9, 0x04, 0x77, 0x77, 0x30, 0x5F, 0x90, 0x17, 0x77, 0x73, 0x0B, 0xF0,
  0xD7, 0x77, 0x73, 0x05, 0xF9, 0x82, 0x80, 0x11, 0x77, 0x76, 0x02, 0x0E, 0xF9, 0x84, 0x20, 0x5F,
  0xA5, 0x77, 0x73, 0x02, 0x0D, 0xF9, 0x0A, 0x20, 0x5B, 0x82, 0xEA, 0x51, 0x77, 0x50, 0x7F, 0xB0,
  0x22, 0x05, 0xF8, 0x2C, 0x95, 0x27, 0x58, 0x14, 0x9E, 0xFB, 0x07, 0x30, 0x5F, 0xD8, 0x90, 0xDB,
  0xA9, 0x88, 0x9A, 0xBD, 0xFE, 0x0A, 0x40, 0x5F, 0xFF, 0xFE, 0x0A, 0x50, 0x5F, 0xFF, 0xFD, 0x09,
  0x60, 0x5F, 0xFF, 0xFB, 0x0D, 0x04, 0x71, 0x81, 0x39, 0xEF, 0xFF, 0xD0, 0xD0, 0x77, 0x68, 0x23,
  0x7B, 0xEF, 0xFD, 0x81, 0xE9, 0x47, 0x75, 0x87, 0x14, 0x68, 0xAC, 0xCD, 0xEB, 0x85, 0xED, 0xCA,
  0x85, 0x27, 0x70,
  // "š" (U+0161)
  0x20, 0x18, 0x01, 0x70, 0x47, 0x74, 0x05, 0x80, 0x17, 0x01, 0x40, 0x2E, 0x08, 0x77, 0x10, 0x10,
  0xAE, 0x02, 0x50, 0x8E, 0x0C, 0x01, 0x75, 0x03, 0x0D, 0xE0, 0x87, 0x09, 0xE0, 0xD0, 0x37, 0x30,
  0x50, 0xEE, 0x08, 0x72, 0x0A, 0xF0, 0x57, 0x10, 0x7F, 0x09, 0x74, 0x0B, 0xF0, 0x66, 0x09, 0xF0,
  0x97, 0x60, 0xCF, 0x07, 0x40, 0xAF, 0x0A, 0x77, 0x01, 0x0D, 0xF0, 0x62, 0x0A, 0xF0, 0xC7, 0x72,
  0x02, 0x0E, 0xF0, 0x60, 0xBF, 0x0D, 0x01, 0x77, 0x30, 0x4F, 0xF9, 0x0D, 0x01, 0x77, 0x50, 0x5F,
  0xE0, 0xE0, 0x27, 0x77, 0x08, 0xFD, 0x05, 0x77, 0x72, 0x0C, 0xFB, 0x08, 0x77, 0x73, 0x02, 0x0E,
  0xF9, 0x0D, 0x77, 0x75, 0x07, 0xF9, 0x04, 0x80, 0xB9, 0x10, 0x85, 0x46, 0x9B, 0xDD, 0xEA, 0x85,
  0xED, 0xCA, 0x86, 0x37, 0x73, 0x05, 0x0A, 0xFF, 0xC8, 0x1B, 0x73, 0x74, 0x07, 0x0E, 0xFF, 0xFA,
  0x81, 0xD7, 0x26, 0x04, 0x0D, 0xFF, 0xFE, 0x09, 0x50, 0x6F, 0xFF, 0xF9, 0x04, 0x40, 0x5F, 0xFF,
  0xF9, 0x0D, 0x40, 0x10, 0xEF, 0xC8, 0x90, 0xDB, 0x99, 0x89, 0x9A, 0xCE, 0xF9, 0x08, 0x40, 0x9F,
  0xA0, 0x90, 0x47, 0x48, 0x22, 0x59, 0xEC, 0x02, 0x40, 0xEF, 0x0C, 0x02, 0x77, 0x38, 0x24, 0xAF,
  0xC4, 0x04, 0xF0, 0xE0, 0x17, 0x76, 0x02, 0x03, 0x40, 0x8F, 0x07, 0x77, 0x76, 0x0A, 0xF0, 0x37,
  0x77, 0x60, 0xBF, 0x01, 0x77, 0x76, 0x0A, 0xF0, 0x27, 0x77, 0x60, 0x9F, 0x07, 0x77, 0x76, 0x07,
  0xF0, 0xD0, 0x17, 0x77, 0x50, 0x3F, 0x90, 0xC0, 0x17, 0x77, 0x50, 0xDF, 0x90, 0xD0, 0x47, 0x77,
  0x40, 0x6F, 0xB0, 0xB0, 0x37, 0x77, 0x30, 0xBF, 0xC0, 0xB0, 0x47, 0x77, 0x20, 0xCF, 0xD0, 0xD0,
  0x67, 0x77, 0x10, 0xBF, 0xE8, 0x1E, 0x81, 0x77, 0x60, 0x7F, 0xF9, 0x0A, 0x03, 0x77, 0x50, 0x20,
  0xAF, 0xF9, 0x0C, 0x05, 0x77, 0x50, 0x30, 0xBF, 0xF9, 0x0D, 0x06, 0x77, 0x50, 0x30, 0xAF, 0xF9,
  0x0D, 0x05, 0x77, 0x50, 0x20, 0x9F, 0xF9, 0x0B, 0x01, 0x77, 0x58, 0x11, 0x8E, 0xFE, 0x0E, 0x03,
  0x77, 0x70, 0x60, 0xDF, 0xD0, 0xE0, 0x27, 0x77, 0x10, 0x40, 0xBF, 0xC0, 0xD7, 0x77, 0x30, 0x40,
  0xBF, 0xB0, 0x77, 0x77, 0x40, 0x50, 0xEF, 0x90, 0xD7, 0x77, 0x50, 0x10, 0xDF, 0x90, 0x27, 0x77,
  0x50, 0x3F, 0x90, 0x57, 0x77, 0x60, 0xCF, 0x07, 0x77, 0x76, 0x09, 0xF0, 0x87, 0x77, 0x60, 0x9F,
  0x08, 0x77, 0x76, 0x0A, 0xF0, 0x77, 0x77, 0x60, 0xDF, 0x05, 0x02, 0x77, 0x74, 0x04, 0xF9, 0x83,
  0x28, 0xE8, 0x27, 0x77, 0x01, 0x0D, 0xF8, 0x1D, 0x08, 0xB8, 0x1B, 0x61, 0x77, 0x30, 0x20, 0xCF,
  0x98, 0x17, 0x08, 0xE8, 0x1B, 0x73, 0x75, 0x04, 0x09, 0xFA, 0x82, 0xE1, 0x08, 0xFB, 0x89, 0x0D,
  0xBA, 0x98, 0x89, 0x9A, 0xDF, 0xD0, 0x62, 0x08, 0xFF, 0xFF, 0xB0, 0xA3, 0x08, 0xFF, 0xFF, 0xA0,
  0xA4, 0x08, 0xFF, 0xFF, 0x90, 0x75, 0x81, 0x17, 0xDF, 0xFF, 0xC0, 0xA0, 0x27, 0x28, 0x22, 0x7B,
  0xEF, 0xFC, 0x81, 0xC7, 0x27, 0x71, 0x86, 0x35, 0x79, 0xBD, 0xDE, 0xB8, 0x5E, 0xDC, 0xA7, 0x51,
  0x74,
  // "Ţ" (U+0162)
  0x0E, 0x80, 0xD0, 0xF0, 0x0E, 0x80, 0xD0, 0xF0, 0x0E, 0x80, 0xD0, 0xF0, 0x0E, 0x80, 0xD0, 0xF0,
  0x0E, 0x80, 0xD0, 0xF0, 0x0E, 0x80, 0xD0, 0xF0, 0x0E, 0x80, 0xD0, 0xF0, 0xE7, 0x75, 0xF9, 0x80,
  0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F,
  0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C,
  0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9,
  0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2,
  0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98,
  0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20,
  0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80,
  0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F,
  0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C,
  0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9,
  0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2,
  0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98,
  0x0C, 0x20, 0xF9, 0x80, 0xC3, 0x00, 0x3C, 0x0E, 0x01, 0x80, 0xC3, 0x00, 0xAC, 0x09, 0x80, 0xC3,
  0x00, 0x2D, 0x02, 0x80, 0xC3, 0x00, 0x9C, 0x0B, 0x80, 0xC3, 0x00, 0x1D, 0x04, 0x80, 0xC3, 0x00,
  0x8D, 0x07, 0x02, 0x80, 0xC1, 0x00, 0x10, 0xEF, 0x0C, 0x05, 0x77, 0x77, 0x70, 0x7F, 0xB0, 0xC0,
  0x27, 0x77, 0x75, 0x82, 0x47, 0xAD, 0xF9, 0x0E, 0x03, 0x80, 0xC0, 0x08, 0x13, 0x8E, 0xE0, 0xC8,
  0x0C, 0x20, 0x01, 0x0C, 0xE0, 0x48, 0x0C, 0x20, 0x01, 0xE0, 0x88, 0x0C, 0x30, 0x0B, 0xD0, 0xA8,
  0x0C, 0x30, 0x0A, 0xD0, 0xA8, 0x0C, 0x30, 0x0D, 0xD0, 0x98, 0x0C, 0x20, 0x08, 0xE0, 0x57, 0x77,
  0x78, 0x14, 0x21, 0x38, 0x21, 0x37, 0xCE, 0x0E, 0x77, 0x77, 0x01, 0xFF, 0xA0, 0x67, 0x77, 0x70,
  0x1F, 0xF9, 0x0A, 0x77, 0x77, 0x10, 0x1F, 0xF0, 0x87, 0x77, 0x72, 0x01, 0xFC, 0x81, 0xEA, 0x27,
  0x77, 0x74, 0x81, 0xAD, 0xEA, 0x84, 0xEE, 0xDA, 0x85, 0x77, 0x70,
  // "ţ" (U+0163)
  0x77, 0x04, 0xE0, 0x47, 0x77, 0x76, 0x06, 0xE0, 0x47, 0x77, 0x76, 0x08, 0xE0, 0x47, 0x77, 0x76,
  0x0A, 0xE0, 0x47, 0x77, 0x76, 0x0C, 0xE0, 0x47, 0x77, 0x76, 0x0E, 0xE0, 0x47, 0x77, 0x76, 0xF0,
  0x47, 0x77, 0x75, 0x02, 0xF0, 0x47, 0x77, 0x75, 0x04, 0xF0, 0x47, 0x77, 0x75, 0x06, 0xF0, 0x47,
  0x77, 0x75, 0x08, 0xF0, 0x47, 0x77, 0x75, 0x0A, 0xF0, 0x47, 0x77, 0x73, 0x81, 0x13, 0xCF, 0x04,
  0x77, 0x71, 0x86, 0x13, 0x56, 0x8A, 0xCD, 0xFF, 0xFF, 0xA8, 0x11, 0x0D, 0x80, 0xC3, 0xF8, 0x11,
  0x0E, 0x80, 0xC3, 0xF8, 0x11, 0x0E, 0x80, 0xC3, 0xF8, 0x11, 0x0E, 0x80, 0xC3, 0xF8, 0x11, 0x0E,
  0x80, 0xC3, 0xF0, 0x11, 0x80, 0x91, 0x80, 0xEF, 0x0A, 0x80, 0x96, 0x87, 0x71, 0x0C, 0xF0, 0x47,
  0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77,
  0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75,
  0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C,
  0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0,
  0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47,
  0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77,
  0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75,
  0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C,
  0xF0, 0x57, 0x77, 0x75, 0x0B, 0xF0, 0x77, 0x77, 0x75, 0x0A, 0xF0, 0x97, 0x77, 0x75, 0x09, 0xF0,
  0xD7, 0x77, 0x75, 0x06, 0xF9, 0x03, 0x77, 0x77, 0x40, 0x4F, 0x90, 0xA7, 0x77, 0x75, 0x0E, 0xF9,
  0x05, 0x77, 0x77, 0x40, 0xAF, 0xA0, 0x67, 0x77, 0x73, 0x03, 0xFB, 0x0C, 0x05, 0x73, 0x83, 0x14,
  0x7A, 0x57, 0x71, 0x0A, 0xFD, 0x87, 0xCA, 0x98, 0x99, 0xAC, 0xEC, 0x06, 0x77, 0x10, 0x10, 0xDF,
  0xFF, 0xB0, 0x67, 0x72, 0x02, 0x0D, 0xFF, 0xFA, 0x06, 0x77, 0x30, 0x10, 0xCF, 0xFF, 0x90, 0x67,
  0x75, 0x07, 0x0E, 0xFF, 0xE0, 0x67, 0x76, 0x81, 0x17, 0xCF, 0xFB, 0x0C, 0x04, 0x77, 0x72, 0x82,
  0x15, 0x7D, 0xE8, 0x4E, 0xCA, 0x86, 0x37, 0x77, 0x71, 0x0A, 0xC0, 0x97, 0x77, 0x77, 0x02, 0xD0,
  0x27, 0x77, 0x77, 0x09, 0xC0, 0xB7, 0x77, 0x77, 0x01, 0xD0, 0x47, 0x77, 0x77, 0x08, 0xD0, 0x70,
  0x27, 0x77, 0x75, 0x01, 0x0E, 0xF0, 0xC0, 0x57, 0x77, 0x73, 0x07, 0xFB, 0x0C, 0x02, 0x77, 0x77,
  0x18, 0x24, 0x7A, 0xDF, 0x90, 0xE0, 0x37, 0x77, 0x74, 0x81, 0x38, 0xEE, 0x0C, 0x77, 0x77, 0x60,
  0x10, 0xCE, 0x04, 0x77, 0x77, 0x60, 0x1E, 0x08, 0x77, 0x77, 0x70, 0xBD, 0x0A, 0x77, 0x77, 0x70,
  0xAD, 0x0A, 0x77, 0x77, 0x70, 0xDD, 0x09, 0x77, 0x77, 0x60, 0x8E, 0x05, 0x77, 0x73, 0x81, 0x42,
  0x13, 0x82, 0x13, 0x7C, 0xE0, 0xE7, 0x77, 0x30, 0x1F, 0xFA, 0x06, 0x77, 0x73, 0x01, 0xFF, 0x90,
  0xA7, 0x77, 0x40, 0x1F, 0xF0, 0x87, 0x77, 0x50, 0x1F, 0xC8, 0x1E, 0xA2, 0x77, 0x77, 0x81, 0xAD,
  0xEA, 0x84, 0xEE, 0xDA, 0x85, 0x74,
  // "Ť" (U+0164)
  0x70, 0x18, 0x01, 0x70, 0x47, 0x74, 0x05, 0x80, 0x17, 0x01, 0x77, 0x02, 0xE0, 0x87, 0x71, 0x01,
  0x0A, 0xE0, 0x27, 0x71, 0x08, 0xE0, 0xC0, 0x17, 0x50, 0x30, 0xDE, 0x08, 0x77, 0x30, 0x9E, 0x0D,
  0x03, 0x73, 0x05, 0x0E, 0xE0, 0x87, 0x75, 0x0A, 0xF0, 0x57, 0x10, 0x7F, 0x09, 0x77, 0x70, 0xBF,
  0x06, 0x60, 0x9F, 0x09, 0x77, 0x72, 0x0C, 0xF0, 0x74, 0x0A, 0xF0, 0xA7, 0x77, 0x30, 0x10, 0xDF,
  0x06, 0x20, 0xAF, 0x0C, 0x77, 0x75, 0x02, 0x0E, 0xF0, 0x60, 0xBF, 0x0D, 0x01, 0x77, 0x76, 0x04,
  0xFF, 0x90, 0xD0, 0x17, 0x77, 0x71, 0x05, 0xFE, 0x0E, 0x02, 0x77, 0x77, 0x30, 0x8F, 0xD0, 0x57,
  0x77, 0x75, 0x0C, 0xFB, 0x08, 0x77, 0x77, 0x60, 0x20, 0xEF, 0x90, 0xD8, 0x0C, 0x00, 0x07, 0xF9,
  0x04, 0x80, 0xCC, 0x20, 0x0E, 0x80, 0xD0, 0xF0, 0x0E, 0x80, 0xD0, 0xF0, 0x0E, 0x80, 0xD0, 0xF0,
  0x0E, 0x80, 0xD0, 0xF0, 0x0E, 0x80, 0xD0, 0xF0, 0x0E, 0x80, 0xD0, 0xF0, 0x0E, 0x80, 0xD0, 0xF0,
  0xE7, 0x75, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20,
  0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80,
  0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F,
  0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C,
  0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9,
  0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2,
  0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98,
  0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20,
  0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80,
  0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F,
  0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C,
  0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9,
  0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x77, 0x50,
  // "ť" (U+0165)
  0x77, 0x77, 0x50, 0xCF, 0x01, 0x77, 0x77, 0x50, 0xEE, 0x0D, 0x77, 0x77, 0x50, 0x1F, 0x08, 0x77,
  0x77, 0x50, 0x4F, 0x02, 0x77, 0x77, 0x50, 0x7E, 0x0B, 0x77, 0x77, 0x60, 0xBE, 0x04, 0x77, 0x77,
  0x60, 0xED, 0x0D, 0x77, 0x77, 0x60, 0x2E, 0x05, 0x77, 0x30, 0x38, 0x02, 0xE0, 0x47, 0x20, 0x6D,
  0x0D, 0x77, 0x40, 0x6E, 0x04, 0x72, 0x0A, 0xD0, 0x57, 0x74, 0x08, 0xE0, 0x47, 0x20, 0xEC, 0x0B,
  0x77, 0x50, 0xAE, 0x04, 0x71, 0x03, 0xD0, 0x37, 0x75, 0x0B, 0xE0, 0x47, 0x10, 0x8C, 0x09, 0x77,
  0x60, 0xDE, 0x04, 0x71, 0x0B, 0xB0, 0xD7, 0x77, 0xF0, 0x47, 0x77, 0x75, 0x02, 0xF0, 0x47, 0x77,
  0x75, 0x04, 0xF0, 0x47, 0x77, 0x75, 0x06, 0xF0, 0x47, 0x77, 0x75, 0x08, 0xF0, 0x47, 0x77, 0x75,
  0x0A, 0xF0, 0x47, 0x77, 0x73, 0x81, 0x13, 0xCF, 0x04, 0x77, 0x71, 0x86, 0x13, 0x56, 0x8A, 0xCD,
  0xFF, 0xFF, 0xA8, 0x11, 0x0D, 0x80, 0xC3, 0xF8, 0x11, 0x0E, 0x80, 0xC3, 0xF8, 0x11, 0x0E, 0x80,
  0xC3, 0xF8, 0x11, 0x0E, 0x80, 0xC3, 0xF8, 0x11, 0x0E, 0x80, 0xC3, 0xF0, 0x11, 0x80, 0x91, 0x80,
  0xEF, 0x0A, 0x80, 0x96, 0x87, 0x71, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75,
  0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C,
  0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0,
  0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47,
  0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77,
  0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75,
  0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C,
  0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0,
  0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x57, 0x77, 0x75, 0x0B, 0xF0, 0x77,
  0x77, 0x75, 0x0A, 0xF0, 0x97, 0x77, 0x75, 0x09, 0xF0, 0xD7, 0x77, 0x75, 0x06, 0xF9, 0x03, 0x77,
  0x77, 0x40, 0x4F, 0x90, 0xA7, 0x77, 0x75, 0x0E, 0xF9, 0x05, 0x77, 0x77, 0x40, 0xAF, 0xA0, 0x67,
  0x77, 0x73, 0x03, 0xFB, 0x0C, 0x05, 0x73, 0x83, 0x14, 0x7A, 0x57, 0x71, 0x0A, 0xFD, 0x87, 0xCA,
  0x98, 0x99, 0xAC, 0xEC, 0x06, 0x77, 0x10, 0x10, 0xDF, 0xFF, 0xB0, 0x67, 0x72, 0x02, 0x0D, 0xFF,
  0xFA, 0x06, 0x77, 0x30, 0x10, 0xCF, 0xFF, 0x90, 0x67, 0x75, 0x07, 0x0E, 0xFF, 0xE0, 0x67, 0x76,
  0x81, 0x17, 0xCF, 0xFB, 0x0C, 0x04, 0x77, 0x72, 0x85, 0x15, 0x7A, 0xCD, 0xEA, 0x85, 0xEE, 0xCA,
  0x86, 0x33,
  // "Ŧ" (U+0166)
  0x0E, 0x80, 0xD0, 0xF0, 0x0E, 0x80, 0xD0, 0xF0, 0x0E, 0x80, 0xD0, 0xF0, 0x0E, 0x80, 0xD0, 0xF0,
  0x0E, 0x80, 0xD0, 0xF0, 0x0E, 0x80, 0xD0, 0xF0, 0x0E, 0x80, 0xD0, 0xF0, 0xE7, 0x75, 0xF9, 0x80,
  0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F,
  0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C,
  0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9,
  0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2,
  0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x77, 0x73, 0x03, 0x80, 0x91, 0x8F, 0x98, 0x09, 0x18, 0x03, 0x73,
  0x05, 0xFF, 0xFF, 0xE0, 0x77, 0x30, 0x5F, 0xFF, 0xFE, 0x07, 0x73, 0x05, 0xFF, 0xFF, 0xE0, 0x77,
  0x30, 0x5F, 0xFF, 0xFE, 0x07, 0x73, 0x05, 0xFF, 0xFF, 0xE0, 0x77, 0x30, 0x5F, 0xFF, 0xFE, 0x07,
  0x77, 0x73, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20,
  0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80,
  0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F,
  0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C,
  0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9,
  0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2, 0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x80, 0xC2,
  0x0F, 0x98, 0x0C, 0x20, 0xF9, 0x77, 0x50,
  // "ŧ" (U+0167)
  0x77, 0x04, 0xE0, 0x47, 0x77, 0x76, 0x06, 0xE0, 0x47, 0x77, 0x76, 0x08, 0xE0, 0x47, 0x77, 0x76,
  0x0A, 0xE0, 0x47, 0x77, 0x76, 0x0C, 0xE0, 0x47, 0x77, 0x76, 0x0E, 0xE0, 0x47, 0x77, 0x76, 0xF0,
  0x47, 0x77, 0x75, 0x02, 0xF0, 0x47, 0x77, 0x75, 0x04, 0xF0, 0x47, 0x77, 0x75, 0x06, 0xF0, 0x47,
  0x77, 0x75, 0x08, 0xF0, 0x47, 0x77, 0x75, 0x0A, 0xF0, 0x47, 0x77, 0x73, 0x81, 0x13, 0xCF, 0x04,
  0x77, 0x71, 0x86, 0x13, 0x56, 0x8A, 0xCD, 0xFF, 0xFF, 0xA8, 0x11, 0x0D, 0x80, 0xC3, 0xF8, 0x11,
  0x0E, 0x80, 0xC3, 0xF8, 0x11, 0x0E, 0x80, 0xC3, 0xF8, 0x11, 0x0E, 0x80, 0xC3, 0xF8, 0x11, 0x0E,
  0x80, 0xC3, 0xF0, 0x11, 0x80, 0x91, 0x80, 0xEF, 0x0A, 0x80, 0x96, 0x87, 0x71, 0x0C, 0xF0, 0x47,
  0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77,
  0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75,
  0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x76, 0x0E, 0x80,
  0xC4, 0xF0, 0x60, 0xE8, 0x0C, 0x4F, 0x06, 0x0E, 0x80, 0xC4, 0xF0, 0x60, 0xE8, 0x0C, 0x4F, 0x06,
  0x0E, 0x80, 0xC4, 0xF0, 0x60, 0xE8, 0x0C, 0x4F, 0x06, 0x76, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C,
  0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0,
  0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47,
  0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x77, 0x75, 0x0C, 0xF0, 0x57, 0x77,
  0x75, 0x0B, 0xF0, 0x67, 0x77, 0x75, 0x0B, 0xF0, 0x97, 0x77, 0x75, 0x09, 0xF0, 0xD7, 0x77, 0x75,
  0x07, 0xF9, 0x03, 0x77, 0x77, 0x40, 0x4F, 0x90, 0xA7, 0x77, 0x75, 0x0E, 0xF9, 0x05, 0x77, 0x77,
  0x40, 0xAF, 0xA0, 0x67, 0x77, 0x73, 0x03, 0xFB, 0x0C, 0x05, 0x73, 0x83, 0x14, 0x7A, 0x57, 0x71,
  0x0A, 0xFD, 0x87, 0xCA, 0x98, 0x99, 0xAC, 0xEC, 0x06, 0x77, 0x10, 0x10, 0xDF, 0xFF, 0xB0, 0x67,
  0x72, 0x02, 0x0E, 0xFF, 0xFA, 0x06, 0x77, 0x30, 0x20, 0xCF, 0xFF, 0x90, 0x67, 0x75, 0x07, 0x0E,
  0xFF, 0xE0, 0x67, 0x76, 0x81, 0x17, 0xCF, 0xFB, 0x0C, 0x04, 0x77, 0x72, 0x85, 0x15, 0x7A, 0xCD,
  0xEA, 0x85, 0xEE, 0xCA, 0x86, 0x33,
  // "Ũ" (U+0168)
  0x75, 0x84, 0x46, 0x87, 0x51, 0x77, 0x84, 0x38, 0x88, 0x81, 0x77, 0x08, 0x0E, 0xE0, 0xB0, 0x37,
  0x50, 0x9C, 0x76, 0x02, 0x0D, 0xFB, 0x0A, 0x01, 0x73, 0x0E, 0xB0, 0xD7, 0x50, 0x10, 0xDF, 0xD0,
  0xE0, 0x77, 0x10, 0x8C, 0x09, 0x75, 0x0B, 0xFF, 0x90, 0xD0, 0x65, 0x06, 0xD0, 0x57, 0x40, 0x5F,
  0xFC, 0x83, 0xEA, 0x89, 0xDD, 0x0E, 0x75, 0x0C, 0xFF, 0xFF, 0x08, 0x74, 0x03, 0xD8, 0x5D, 0x51,
  0x01, 0x5C, 0xFF, 0xA0, 0xE0, 0x17, 0x40, 0x8C, 0x0D, 0x01, 0x60, 0x50, 0xDF, 0xF0, 0x57, 0x50,
  0xCC, 0x04, 0x72, 0x07, 0xFD, 0x07, 0x76, 0x0E, 0xB0, 0xD7, 0x40, 0x20, 0xAF, 0x90, 0xE0, 0x67,
  0x60, 0x1C, 0x08, 0x76, 0x87, 0x28, 0xCE, 0xFD, 0xB6, 0x18, 0x0C, 0x82, 0x00, 0xAF, 0x06, 0x77,
  0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0,
  0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67,
  0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F,
  0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06,
  0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06,
  0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0,
  0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30,
  0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF,
  0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73,
  0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A,
  0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77,
  0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00,
  0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77,
  0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0,
  0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67,
  0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F,
  0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06,
  0x77, 0x73, 0x07, 0xF0, 0xA0, 0x9F, 0x07, 0x77, 0x73, 0x08, 0xF0, 0x09, 0xF0, 0x87, 0x77, 0x30,
  0x9F, 0x09, 0x07, 0xF0, 0xA7, 0x77, 0x30, 0xAF, 0x07, 0x05, 0xF0, 0xC7, 0x77, 0x30, 0xDF, 0x05,
  0x04, 0xF9, 0x77, 0x73, 0xF9, 0x03, 0x01, 0xF9, 0x02, 0x77, 0x71, 0x03, 0xF9, 0x81, 0x10, 0xDF,
  0x06, 0x77, 0x71, 0x06, 0xF0, 0xD2, 0x0A, 0xF0, 0xB7, 0x77, 0x10, 0xAF, 0x09, 0x20, 0x6F, 0x90,
  0x17, 0x76, 0x01, 0xF9, 0x05, 0x20, 0x1F, 0x90, 0x97, 0x76, 0x08, 0xF9, 0x40, 0xCF, 0x90, 0x37,
  0x74, 0x02, 0x0E, 0xF0, 0xA4, 0x05, 0xF9, 0x0D, 0x01, 0x77, 0x30, 0xCF, 0x90, 0x35, 0x0D, 0xF9,
  0x0D, 0x01, 0x77, 0x01, 0x0C, 0xF9, 0x0C, 0x60, 0x6F, 0xA0, 0xE0, 0x67, 0x50, 0x50, 0xEF, 0xA0,
  0x37, 0x0B, 0xFB, 0x83, 0xE9, 0x52, 0x12, 0x83, 0x12, 0x58, 0xEF, 0xB0, 0x87, 0x10, 0x10, 0xEF,
  0xFF, 0xFA, 0x0C, 0x73, 0x03, 0x0E, 0xFF, 0xFF, 0x0D, 0x01, 0x74, 0x03, 0x0E, 0xFF, 0xFD, 0x0C,
  0x01, 0x76, 0x01, 0x0C, 0xFF, 0xFB, 0x09, 0x77, 0x30, 0x60, 0xDF, 0xFE, 0x0C, 0x03, 0x77, 0x60,
  0x60, 0xBF, 0xF9, 0x81, 0xEA, 0x47, 0x77, 0x38, 0x51, 0x57, 0xAC, 0xDE, 0xA8, 0x4E, 0xDC, 0x97,
  0x47, 0x70,
  // "ũ" (U+0169)
  0x75, 0x84, 0x46, 0x87, 0x51, 0x77, 0x84, 0x38, 0x88, 0x81, 0x76, 0x08, 0x0E, 0xE0, 0xB0, 0x37,
  0x50, 0x9C, 0x75, 0x02, 0x0D, 0xFB, 0x0A, 0x01, 0x73, 0x0E, 0xB0, 0xD7, 0x40, 0x10, 0xDF, 0xD0,
  0xE0, 0x77, 0x10, 0x8C, 0x09, 0x74, 0x0B, 0xFF, 0x90, 0xD0, 0x65, 0x06, 0xD0, 0x57, 0x30, 0x5F,
  0xFC, 0x83, 0xEA, 0x89, 0xDD, 0x0E, 0x74, 0x0C, 0xFF, 0xFF, 0x08, 0x73, 0x03, 0xD8, 0x5D, 0x51,
  0x01, 0x5C, 0xFF, 0xA0, 0xE0, 0x17, 0x30, 0x8C, 0x0D, 0x01, 0x60, 0x50, 0xDF, 0xF0, 0x57, 0x40,
  0xCC, 0x04, 0x72, 0x07, 0xFD, 0x07, 0x75, 0x0E, 0xB0, 0xD7, 0x40, 0x20, 0xAF, 0x90, 0xE0, 0x67,
  0x50, 0x1C, 0x08, 0x76, 0x87, 0x28, 0xCE, 0xFD, 0xB6, 0x18, 0x0B, 0xF3, 0x00, 0x3F, 0x0D, 0x77,
  0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04,
  0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0,
  0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D,
  0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72,
  0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0,
  0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F,
  0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77,
  0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04,
  0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0,
  0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D,
  0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72,
  0x05, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x05, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x06, 0xF0,
  0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x07, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x09, 0xF0, 0xC0, 0x3F,
  0x0D, 0x77, 0x72, 0x0B, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x0E, 0xF0, 0xC0, 0x3F, 0x0E, 0x77,
  0x71, 0x01, 0xF9, 0x0C, 0x03, 0xF9, 0x77, 0x71, 0x06, 0xF9, 0x0C, 0x02, 0xF9, 0x02, 0x77, 0x70,
  0xBF, 0x90, 0xC1, 0xF9, 0x05, 0x77, 0x60, 0x1F, 0xA8, 0x1C, 0x0E, 0xF0, 0xA7, 0x76, 0x08, 0xFA,
  0x81, 0xC0, 0xBF, 0x90, 0x17, 0x74, 0x01, 0x0E, 0xFA, 0x81, 0xC0, 0x7F, 0x90, 0x97, 0x74, 0x0A,
  0xFB, 0x81, 0xC0, 0x2F, 0xA0, 0x47, 0x72, 0x09, 0xFC, 0x0C, 0x20, 0xCF, 0xA0, 0x57, 0x60, 0x10,
  0xBF, 0xD0, 0xC2, 0x05, 0xFB, 0x0C, 0x04, 0x72, 0x03, 0x09, 0xE0, 0xD0, 0xEE, 0x0C, 0x30, 0xCF,
  0xD8, 0x6C, 0xA9, 0x89, 0xAC, 0xEF, 0x81, 0xE2, 0xAE, 0x0C, 0x30, 0x3F, 0xFF, 0xE8, 0x15, 0x07,
  0xE0, 0xC4, 0x05, 0xFF, 0xFC, 0x06, 0x20, 0x5E, 0x0C, 0x50, 0x5F, 0xFF, 0x90, 0xE0, 0x53, 0x02,
  0xE0, 0xC6, 0x02, 0x0C, 0xFF, 0xD0, 0xB0, 0x25, 0x0E, 0xD0, 0xC7, 0x10, 0x40, 0xBF, 0xF8, 0x1E,
  0xA4, 0x70, 0xCD, 0x0C, 0x73, 0x84, 0x15, 0x8B, 0xDE, 0xA8, 0x4E, 0xEC, 0xA8, 0x47, 0x73,
  // "Ū" (U+016A)
  0x70, 0x28, 0x0A, 0x68, 0x03, 0x77, 0x04, 0xFF, 0xFD, 0x06, 0x77, 0x04, 0xFF, 0xFD, 0x06, 0x77,
  0x04, 0xFF, 0xFD, 0x06, 0x77, 0x04, 0xFF, 0xFD, 0x06, 0x77, 0x04, 0xFF, 0xFD, 0x06, 0x77, 0x04,
  0xFF, 0xFD, 0x06, 0x80, 0xCD, 0x10, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77,
  0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0,
  0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67,
  0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F,
  0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06,
  0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06,
  0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0,
  0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30,
  0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF,
  0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73,
  0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A,
  0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77,
  0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00,
  0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77,
  0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0,
  0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67,
  0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F,
  0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x7F, 0x0A, 0x09, 0xF0,
  0x77, 0x77, 0x30, 0x8F, 0x00, 0x9F, 0x08, 0x77, 0x73, 0x09, 0xF0, 0x90, 0x7F, 0x0A, 0x77, 0x73,
  0x0A, 0xF0, 0x70, 0x5F, 0x0C, 0x77, 0x73, 0x0D, 0xF0, 0x50, 0x4F, 0x97, 0x77, 0x3F, 0x90, 0x30,
  0x1F, 0x90, 0x27, 0x77, 0x10, 0x3F, 0x98, 0x11, 0x0D, 0xF0, 0x67, 0x77, 0x10, 0x6F, 0x0D, 0x20,
  0xAF, 0x0B, 0x77, 0x71, 0x0A, 0xF0, 0x92, 0x06, 0xF9, 0x01, 0x77, 0x60, 0x1F, 0x90, 0x52, 0x01,
  0xF9, 0x09, 0x77, 0x60, 0x8F, 0x94, 0x0C, 0xF9, 0x03, 0x77, 0x40, 0x20, 0xEF, 0x0A, 0x40, 0x5F,
  0x90, 0xD0, 0x17, 0x73, 0x0C, 0xF9, 0x03, 0x50, 0xDF, 0x90, 0xD0, 0x17, 0x70, 0x10, 0xCF, 0x90,
  0xC6, 0x06, 0xFA, 0x0E, 0x06, 0x75, 0x05, 0x0E, 0xFA, 0x03, 0x70, 0xBF, 0xB8, 0x3E, 0x95, 0x21,
  0x28, 0x31, 0x25, 0x8E, 0xFB, 0x08, 0x71, 0x01, 0x0E, 0xFF, 0xFF, 0xA0, 0xC7, 0x30, 0x30, 0xEF,
  0xFF, 0xF0, 0xD0, 0x17, 0x40, 0x30, 0xEF, 0xFF, 0xD0, 0xC0, 0x17, 0x60, 0x10, 0xCF, 0xFF, 0xB0,
  0x97, 0x73, 0x06, 0x0D, 0xFF, 0xE0, 0xC0, 0x37, 0x76, 0x06, 0x0B, 0xFF, 0x98, 0x1E, 0xA4, 0x77,
  0x73, 0x85, 0x15, 0x7A, 0xCD, 0xEA, 0x84, 0xED, 0xC9, 0x74, 0x77,
  // "ū" (U+016B)
  0x70, 0x28, 0x0A, 0x68, 0x03, 0x76, 0x04, 0xFF, 0xFD, 0x06, 0x76, 0x04, 0xFF, 0xFD, 0x06, 0x76,
  0x04, 0xFF, 0xFD, 0x06, 0x76, 0x04, 0xFF, 0xFD, 0x06, 0x76, 0x04, 0xFF, 0xFD, 0x06, 0x76, 0x04,
  0xFF, 0xFD, 0x06, 0x80, 0xCC, 0x10, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7,
  0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20,
  0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C,
  0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0,
  0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77,
  0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F,
  0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03,
  0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7,
  0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20,
  0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C,
  0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0,
  0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x5F, 0x0C, 0x03, 0xF0, 0xD7, 0x77,
  0x20, 0x5F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x6F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x7F,
  0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x9F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0xBF, 0x0C, 0x03,
  0xF0, 0xD7, 0x77, 0x20, 0xEF, 0x0C, 0x03, 0xF0, 0xE7, 0x77, 0x10, 0x1F, 0x90, 0xC0, 0x3F, 0x97,
  0x77, 0x10, 0x6F, 0x90, 0xC0, 0x2F, 0x90, 0x27, 0x77, 0x0B, 0xF9, 0x0C, 0x1F, 0x90, 0x57, 0x76,
  0x01, 0xFA, 0x81, 0xC0, 0xEF, 0x0A, 0x77, 0x60, 0x8F, 0xA8, 0x1C, 0x0B, 0xF9, 0x01, 0x77, 0x40,
  0x10, 0xEF, 0xA8, 0x1C, 0x07, 0xF9, 0x09, 0x77, 0x40, 0xAF, 0xB8, 0x1C, 0x02, 0xFA, 0x04, 0x77,
  0x20, 0x9F, 0xC0, 0xC2, 0x0C, 0xFA, 0x05, 0x76, 0x01, 0x0B, 0xFD, 0x0C, 0x20, 0x5F, 0xB0, 0xC0,
  0x47, 0x20, 0x30, 0x9E, 0x0D, 0x0E, 0xE0, 0xC3, 0x0C, 0xFD, 0x86, 0xCA, 0x98, 0x9A, 0xCE, 0xF8,
  0x1E, 0x2A, 0xE0, 0xC3, 0x03, 0xFF, 0xFE, 0x81, 0x50, 0x7E, 0x0C, 0x40, 0x5F, 0xFF, 0xC0, 0x62,
  0x05, 0xE0, 0xC5, 0x05, 0xFF, 0xF9, 0x0E, 0x05, 0x30, 0x2E, 0x0C, 0x60, 0x20, 0xCF, 0xFD, 0x0B,
  0x02, 0x50, 0xED, 0x0C, 0x71, 0x04, 0x0B, 0xFF, 0x81, 0xEA, 0x47, 0x0C, 0xD0, 0xC7, 0x38, 0x41,
  0x58, 0xBD, 0xEA, 0x84, 0xEE, 0xCA, 0x84, 0x77, 0x30,
  // "Ŭ" (U+016C)
  0x70, 0xDC, 0x06, 0x77, 0x20, 0x6D, 0x77, 0x0C, 0xC0, 0xB7, 0x72, 0x0B, 0xC0, 0xD7, 0x70, 0x9D,
  0x04, 0x77, 0x03, 0xD0, 0xB7, 0x70, 0x5D, 0x0D, 0x02, 0x75, 0x01, 0x0C, 0xD0, 0x67, 0x71, 0x0E,
  0xD0, 0xE0, 0x57, 0x30, 0x30, 0xDE, 0x01, 0x77, 0x10, 0x7F, 0x82, 0xD7, 0x41, 0x28, 0x21, 0x37,
  0xCF, 0x09, 0x77, 0x30, 0xDF, 0xFF, 0x90, 0xE0, 0x17, 0x73, 0x03, 0x0E, 0xFF, 0xF0, 0x37, 0x75,
  0x04, 0x0E, 0xFF, 0xC0, 0xE0, 0x47, 0x77, 0x02, 0x0D, 0xFF, 0xA0, 0xC0, 0x27, 0x77, 0x30, 0x60,
  0xDF, 0xD0, 0xC0, 0x57, 0x77, 0x78, 0x92, 0x37, 0xBD, 0xEF, 0xED, 0xCA, 0x63, 0x80, 0xC8, 0x70,
  0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67,
  0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F,
  0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06,
  0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06,
  0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0,
  0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30,
  0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF,
  0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73,
  0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A,
  0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77,
  0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00,
  0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77,
  0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0,
  0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67,
  0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F,
  0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06,
  0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06,
  0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x7F, 0x0A, 0x09, 0xF0, 0x77, 0x77, 0x30, 0x8F, 0x00, 0x9F,
  0x08, 0x77, 0x73, 0x09, 0xF0, 0x90, 0x7F, 0x0A, 0x77, 0x73, 0x0A, 0xF0, 0x70, 0x5F, 0x0C, 0x77,
  0x73, 0x0D, 0xF0, 0x50, 0x4F, 0x97, 0x77, 0x3F, 0x90, 0x30, 0x1F, 0x90, 0x27, 0x77, 0x10, 0x3F,
  0x98, 0x11, 0x0D, 0xF0, 0x67, 0x77, 0x10, 0x6F, 0x0D, 0x20, 0xAF, 0x0B, 0x77, 0x71, 0x0A, 0xF0,
  0x92, 0x06, 0xF9, 0x01, 0x77, 0x60, 0x1F, 0x90, 0x52, 0x01, 0xF9, 0x09, 0x77, 0x60, 0x8F, 0x94,
  0x0C, 0xF9, 0x03, 0x77, 0x40, 0x20, 0xEF, 0x0A, 0x40, 0x5F, 0x90, 0xD0, 0x17, 0x73, 0x0C, 0xF9,
  0x03, 0x50, 0xDF, 0x90, 0xD0, 0x17, 0x70, 0x10, 0xCF, 0x90, 0xC6, 0x06, 0xFA, 0x0E, 0x06, 0x75,
  0x05, 0x0E, 0xFA, 0x03, 0x70, 0xBF, 0xB8, 0x3E, 0x95, 0x21, 0x28, 0x31, 0x25, 0x8E, 0xFB, 0x08,
  0x71, 0x01, 0x0E, 0xFF, 0xFF, 0xA0, 0xC7, 0x30, 0x30, 0xEF, 0xFF, 0xF0, 0xD0, 0x17, 0x40, 0x30,
  0xEF, 0xFF, 0xD0, 0xC0, 0x17, 0x60, 0x10, 0xCF, 0xFF, 0xB0, 0x97, 0x73, 0x06, 0x0D, 0xFF, 0xE0,
  0xC0, 0x37, 0x76, 0x06, 0x0B, 0xFF, 0x98, 0x1E, 0xA4, 0x77, 0x73, 0x85, 0x15, 0x7A, 0xCD, 0xEA,
  0x84, 0xED, 0xC9, 0x74, 0x77,
  // "ŭ" (U+016D)
  0x70, 0xDC, 0x06, 0x77, 0x20, 0x6D, 0x76, 0x0C, 0xC0, 0xB7, 0x72, 0x0B, 0xC0, 0xD7, 0x60, 0x9D,
  0x04, 0x77, 0x03, 0xD0, 0xB7, 0x60, 0x5D, 0x0D, 0x02, 0x75, 0x01, 0x0C, 0xD0, 0x67, 0x70, 0xED,
  0x0E, 0x05, 0x73, 0x03, 0x0D, 0xE0, 0x17, 0x70, 0x7F, 0x82, 0xD7, 0x41, 0x28, 0x21, 0x37, 0xCF,
  0x09, 0x77, 0x20, 0xDF, 0xFF, 0x90, 0xE0, 0x17, 0x72, 0x03, 0x0E, 0xFF, 0xF0, 0x37, 0x74, 0x04,
  0x0E, 0xFF, 0xC0, 0xE0, 0x47, 0x76, 0x02, 0x0D, 0xFF, 0xA0, 0xC0, 0x27, 0x77, 0x20, 0x60, 0xDF,
  0xD0, 0xC0, 0x57, 0x77, 0x68, 0x92, 0x37, 0xBD, 0xEF, 0xED, 0xCA, 0x63, 0x80, 0xC8, 0x00, 0x03,
  0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7,
  0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20,
  0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C,
  0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0,
  0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77,
  0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F,
  0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03,
  0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7,
  0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20,
  0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C,
  0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0,
  0xD7, 0x77, 0x20, 0x5F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x5F, 0x0C, 0x03, 0xF0, 0xD7, 0x77,
  0x20, 0x6F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x7F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x9F,
  0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0xBF, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0xEF, 0x0C, 0x03,
  0xF0, 0xE7, 0x77, 0x10, 0x1F, 0x90, 0xC0, 0x3F, 0x97, 0x77, 0x10, 0x6F, 0x90, 0xC0, 0x2F, 0x90,
  0x27, 0x77, 0x0B, 0xF9, 0x0C, 0x1F, 0x90, 0x57, 0x76, 0x01, 0xFA, 0x81, 0xC0, 0xEF, 0x0A, 0x77,
  0x60, 0x8F, 0xA8, 0x1C, 0x0B, 0xF9, 0x01, 0x77, 0x40, 0x10, 0xEF, 0xA8, 0x1C, 0x07, 0xF9, 0x09,
  0x77, 0x40, 0xAF, 0xB8, 0x1C, 0x02, 0xFA, 0x04, 0x77, 0x20, 0x9F, 0xC0, 0xC2, 0x0C, 0xFA, 0x05,
  0x76, 0x01, 0x0B, 0xFD, 0x0C, 0x20, 0x5F, 0xB0, 0xC0, 0x47, 0x20, 0x30, 0x9E, 0x0D, 0x0E, 0xE0,
  0xC3, 0x0C, 0xFD, 0x86, 0xCA, 0x98, 0x9A, 0xCE, 0xF8, 0x1E, 0x2A, 0xE0, 0xC3, 0x03, 0xFF, 0xFE,
  0x81, 0x50, 0x7E, 0x0C, 0x40, 0x5F, 0xFF, 0xC0, 0x62, 0x05, 0xE0, 0xC5, 0x05, 0xFF, 0xF9, 0x0E,
  0x05, 0x30, 0x2E, 0x0C, 0x60, 0x20, 0xCF, 0xFD, 0x0B, 0x02, 0x50, 0xED, 0x0C, 0x71, 0x04, 0x0B,
  0xFF, 0x81, 0xEA, 0x47, 0x0C, 0xD0, 0xC7, 0x38, 0x41, 0x58, 0xBD, 0xEA, 0x84, 0xEE, 0xCA, 0x84,
  0x77, 0x30,
  // "Ů" (U+016E)
  0x77, 0x28, 0x90, 0x28, 0xBD, 0xFE, 0xDA, 0x71, 0x77, 0x77, 0x20, 0x10, 0xAF, 0xB0, 0x87, 0x77,
  0x70, 0x30, 0xEF, 0xD0, 0xD0, 0x27, 0x77, 0x40, 0x20, 0xEF, 0xF0, 0xD0, 0x17, 0x77, 0x30, 0xBF,
  0xFA, 0x0A, 0x77, 0x72, 0x03, 0xE0, 0x80, 0x22, 0x03, 0x09, 0xE0, 0x27, 0x77, 0x10, 0x7D, 0x04,
  0x60, 0x5D, 0x07, 0x77, 0x71, 0x0B, 0xC0, 0x87, 0x10, 0xAC, 0x0B, 0x77, 0x71, 0x0C, 0xC0, 0x37,
  0x10, 0x5C, 0x0C, 0x77, 0x71, 0x0D, 0xC0, 0x27, 0x10, 0x4C, 0x0D, 0x77, 0x71, 0x0C, 0xC0, 0x37,
  0x10, 0x5C, 0x0C, 0x77, 0x71, 0x0B, 0xC0, 0x87, 0x10, 0xAC, 0x0A, 0x77, 0x71, 0x07, 0xD0, 0x36,
  0x05, 0xD0, 0x77, 0x77, 0x10, 0x2E, 0x08, 0x02, 0x20, 0x30, 0x9E, 0x02, 0x77, 0x72, 0x0A, 0xFF,
  0xA0, 0x97, 0x77, 0x30, 0x10, 0xEF, 0xF0, 0xD0, 0x17, 0x77, 0x40, 0x30, 0xEF, 0xD0, 0xD0, 0x27,
  0x77, 0x60, 0x10, 0xAF, 0xB0, 0x97, 0x77, 0x73, 0x89, 0x02, 0x8B, 0xDF, 0xED, 0xB7, 0x18, 0x0C,
  0x90, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF,
  0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73,
  0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A,
  0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77,
  0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00,
  0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77,
  0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0,
  0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67,
  0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F,
  0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06,
  0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06,
  0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0,
  0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30,
  0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF,
  0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73,
  0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A,
  0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77,
  0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x07, 0xF0, 0xA0, 0x9F, 0x07, 0x77, 0x73, 0x08, 0xF0,
  0x09, 0xF0, 0x87, 0x77, 0x30, 0x9F, 0x09, 0x07, 0xF0, 0xA7, 0x77, 0x30, 0xAF, 0x07, 0x05, 0xF0,
  0xC7, 0x77, 0x30, 0xDF, 0x05, 0x04, 0xF9, 0x77, 0x73, 0xF9, 0x03, 0x01, 0xF9, 0x02, 0x77, 0x71,
  0x03, 0xF9, 0x81, 0x10, 0xDF, 0x06, 0x77, 0x71, 0x06, 0xF0, 0xD2, 0x0A, 0xF0, 0xB7, 0x77, 0x10,
  0xAF, 0x09, 0x20, 0x6F, 0x90, 0x17, 0x76, 0x01, 0xF9, 0x05, 0x20, 0x1F, 0x90, 0x97, 0x76, 0x08,
  0xF9, 0x40, 0xCF, 0x90, 0x37, 0x74, 0x02, 0x0E, 0xF0, 0xA4, 0x05, 0xF9, 0x0D, 0x01, 0x77, 0x30,
  0xCF, 0x90, 0x35, 0x0D, 0xF9, 0x0D, 0x01, 0x77, 0x01, 0x0C, 0xF9, 0x0C, 0x60, 0x6F, 0xA0, 0xE0,
  0x67, 0x50, 0x50, 0xEF, 0xA0, 0x37, 0x0B, 0xFB, 0x83, 0xE9, 0x52, 0x12, 0x83, 0x12, 0x58, 0xEF,
  0xB0, 0x87, 0x10, 0x10, 0xEF, 0xFF, 0xFA, 0x0C, 0x73, 0x03, 0x0E, 0xFF, 0xFF, 0x0D, 0x01, 0x74,
  0x03, 0x0E, 0xFF, 0xFD, 0x0C, 0x01, 0x76, 0x01, 0x0C, 0xFF, 0xFB, 0x09, 0x77, 0x30, 0x60, 0xDF,
  0xFE, 0x0C, 0x03, 0x77, 0x60, 0x60, 0xBF, 0xF9, 0x81, 0xEA, 0x47, 0x77, 0x38, 0x51, 0x57, 0xAC,
  0xDE, 0xA8, 0x4E, 0xDC, 0x97, 0x47, 0x70,
  // "ů" (U+016F)
  0x77, 0x28, 0x90, 0x28, 0xBD, 0xFE, 0xDA, 0x71, 0x77, 0x77, 0x10, 0x10, 0xAF, 0xB0, 0x87, 0x77,
  0x60, 0x30, 0xEF, 0xD0, 0xD0, 0x27, 0x77, 0x30, 0x20, 0xEF, 0xF0, 0xD0, 0x17, 0x77, 0x20, 0xBF,
  0xFA, 0x0A, 0x77, 0x71, 0x03, 0xE0, 0x80, 0x22, 0x03, 0x09, 0xE0, 0x27, 0x77, 0x07, 0xD0, 0x46,
  0x05, 0xD0, 0x77, 0x77, 0x0B, 0xC0, 0x87, 0x10, 0xAC, 0x0B, 0x77, 0x70, 0xCC, 0x03, 0x71, 0x05,
  0xC0, 0xC7, 0x77, 0x0D, 0xC0, 0x27, 0x10, 0x4C, 0x0D, 0x77, 0x70, 0xCC, 0x03, 0x71, 0x05, 0xC0,
  0xC7, 0x77, 0x0B, 0xC0, 0x87, 0x10, 0xAC, 0x0A, 0x77, 0x70, 0x7D, 0x03, 0x60, 0x5D, 0x07, 0x77,
  0x70, 0x2E, 0x08, 0x02, 0x20, 0x30, 0x9E, 0x02, 0x77, 0x71, 0x0A, 0xFF, 0xA0, 0x97, 0x77, 0x20,
  0x10, 0xEF, 0xF0, 0xD0, 0x17, 0x77, 0x30, 0x30, 0xEF, 0xD0, 0xD0, 0x27, 0x77, 0x50, 0x10, 0xAF,
  0xB0, 0x97, 0x77, 0x72, 0x89, 0x02, 0x8B, 0xDF, 0xED, 0xB7, 0x18, 0x0C, 0x81, 0x00, 0x3F, 0x0D,
  0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72,
  0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0,
  0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F,
  0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77,
  0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04,
  0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0,
  0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D,
  0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72,
  0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0,
  0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F,
  0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC0, 0x3F, 0x0D, 0x77,
  0x72, 0x05, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x05, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x06,
  0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x07, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x09, 0xF0, 0xC0,
  0x3F, 0x0D, 0x77, 0x72, 0x0B, 0xF0, 0xC0, 0x3F, 0x0D, 0x77, 0x72, 0x0E, 0xF0, 0xC0, 0x3F, 0x0E,
  0x77, 0x71, 0x01, 0xF9, 0x0C, 0x03, 0xF9, 0x77, 0x71, 0x06, 0xF9, 0x0C, 0x02, 0xF9, 0x02, 0x77,
  0x70, 0xBF, 0x90, 0xC1, 0xF9, 0x05, 0x77, 0x60, 0x1F, 0xA8, 0x1C, 0x0E, 0xF0, 0xA7, 0x76, 0x08,
  0xFA, 0x81, 0xC0, 0xBF, 0x90, 0x17, 0x74, 0x01, 0x0E, 0xFA, 0x81, 0xC0, 0x7F, 0x90, 0x97, 0x74,
  0x0A, 0xFB, 0x81, 0xC0, 0x2F, 0xA0, 0x47, 0x72, 0x09, 0xFC, 0x0C, 0x20, 0xCF, 0xA0, 0x57, 0x60,
  0x10, 0xBF, 0xD0, 0xC2, 0x05, 0xFB, 0x0C, 0x04, 0x72, 0x03, 0x09, 0xE0, 0xD0, 0xEE, 0x0C, 0x30,
  0xCF, 0xD8, 0x6C, 0xA9, 0x89, 0xAC, 0xEF, 0x81, 0xE2, 0xAE, 0x0C, 0x30, 0x3F, 0xFF, 0xE8, 0x15,
  0x07, 0xE0, 0xC4, 0x05, 0xFF, 0xFC, 0x06, 0x20, 0x5E, 0x0C, 0x50, 0x5F, 0xFF, 0x90, 0xE0, 0x53,
  0x02, 0xE0, 0xC6, 0x02, 0x0C, 0xFF, 0xD0, 0xB0, 0x25, 0x0E, 0xD0, 0xC7, 0x10, 0x40, 0xBF, 0xF8,
  0x1E, 0xA4, 0x70, 0xCD, 0x0C, 0x73, 0x84, 0x15, 0x8B, 0xDE, 0xA8, 0x4E, 0xEC, 0xA8, 0x47, 0x73,
  // "Ű" (U+0170)
  0x77, 0x07, 0xF9, 0x06, 0x60, 0x9F, 0x90, 0x47, 0x71, 0x01, 0x0E, 0xF0, 0xE0, 0x15, 0x02, 0xF9,
  0x0D, 0x77, 0x20, 0x8F, 0x90, 0x56, 0x0A, 0xF9, 0x03, 0x77, 0x10, 0x10, 0xEF, 0x09, 0x60, 0x3F,
  0x90, 0x77, 0x72, 0x09, 0xF0, 0xC7, 0x0B, 0xF0, 0xA7, 0x72, 0x03, 0xF0, 0xD0, 0x16, 0x05, 0xF0,
  0xC7, 0x73, 0x0C, 0xE0, 0xE0, 0x26, 0x01, 0x0E, 0xE0, 0xD0, 0x17, 0x72, 0x06, 0xF0, 0x47, 0x09,
  0xE0, 0xE0, 0x27, 0x72, 0x01, 0x0E, 0xE0, 0x57, 0x03, 0xE0, 0xE0, 0x37, 0x73, 0x0A, 0xE0, 0x57,
  0x10, 0xCE, 0x03, 0x77, 0x30, 0x4E, 0x06, 0x71, 0x07, 0xD0, 0xE0, 0x47, 0x73, 0x01, 0x0E, 0xD0,
  0x57, 0x10, 0x2D, 0x0E, 0x03, 0x77, 0x40, 0xAC, 0x0E, 0x04, 0x72, 0x0C, 0xC0, 0xD0, 0x37, 0x75,
  0xC0, 0xD0, 0x27, 0x20, 0x3C, 0x0C, 0x01, 0x80, 0xC8, 0x50, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F,
  0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06,
  0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06,
  0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0,
  0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30,
  0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF,
  0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73,
  0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A,
  0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77,
  0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00,
  0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77,
  0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0,
  0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67,
  0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F,
  0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06,
  0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06,
  0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0,
  0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30,
  0x7F, 0x0A, 0x09, 0xF0, 0x77, 0x77, 0x30, 0x8F, 0x00, 0x9F, 0x08, 0x77, 0x73, 0x09, 0xF0, 0x90,
  0x7F, 0x0A, 0x77, 0x73, 0x0A, 0xF0, 0x70, 0x5F, 0x0C, 0x77, 0x73, 0x0D, 0xF0, 0x50, 0x4F, 0x97,
  0x77, 0x3F, 0x90, 0x30, 0x1F, 0x90, 0x27, 0x77, 0x10, 0x3F, 0x98, 0x11, 0x0D, 0xF0, 0x67, 0x77,
  0x10, 0x6F, 0x0D, 0x20, 0xAF, 0x0B, 0x77, 0x71, 0x0A, 0xF0, 0x92, 0x06, 0xF9, 0x01, 0x77, 0x60,
  0x1F, 0x90, 0x52, 0x01, 0xF9, 0x09, 0x77, 0x60, 0x8F, 0x94, 0x0C, 0xF9, 0x03, 0x77, 0x40, 0x20,
  0xEF, 0x0A, 0x40, 0x5F, 0x90, 0xD0, 0x17, 0x73, 0x0C, 0xF9, 0x03, 0x50, 0xDF, 0x90, 0xD0, 0x17,
  0x70, 0x10, 0xCF, 0x90, 0xC6, 0x06, 0xFA, 0x0E, 0x06, 0x75, 0x05, 0x0E, 0xFA, 0x03, 0x70, 0xBF,
  0xB8, 0x3E, 0x95, 0x21, 0x28, 0x31, 0x25, 0x8E, 0xFB, 0x08, 0x71, 0x01, 0x0E, 0xFF, 0xFF, 0xA0,
  0xC7, 0x30, 0x30, 0xEF, 0xFF, 0xF0, 0xD0, 0x17, 0x40, 0x30, 0xEF, 0xFF, 0xD0, 0xC0, 0x17, 0x60,
  0x10, 0xCF, 0xFF, 0xB0, 0x97, 0x73, 0x06, 0x0D, 0xFF, 0xE0, 0xC0, 0x37, 0x76, 0x06, 0x0B, 0xFF,
  0x98, 0x1E, 0xA4, 0x77, 0x73, 0x85, 0x15, 0x7A, 0xCD, 0xEA, 0x84, 0xED, 0xC9, 0x74, 0x77,
  // "ű" (U+0171)
  0x77, 0x07, 0xF9, 0x06, 0x60, 0x9F, 0x90, 0x47, 0x70, 0x10, 0xEF, 0x0E, 0x01, 0x50, 0x2F, 0x90,
  0xD7, 0x71, 0x08, 0xF9, 0x05, 0x60, 0xAF, 0x90, 0x37, 0x70, 0x10, 0xEF, 0x09, 0x60, 0x3F, 0x90,
  0x77, 0x71, 0x09, 0xF0, 0xC7, 0x0B, 0xF0, 0xA7, 0x71, 0x03, 0xF0, 0xD0, 0x16, 0x05, 0xF0, 0xC7,
  0x72, 0x0C, 0xE0, 0xE0, 0x26, 0x01, 0x0E, 0xE0, 0xD0, 0x17, 0x71, 0x06, 0xF0, 0x47, 0x09, 0xE0,
  0xE0, 0x27, 0x71, 0x01, 0x0E, 0xE0, 0x57, 0x03, 0xE0, 0xE0, 0x37, 0x72, 0x0A, 0xE0, 0x57, 0x10,
  0xCE, 0x03, 0x77, 0x20, 0x4E, 0x06, 0x71, 0x07, 0xD0, 0xE0, 0x47, 0x72, 0x01, 0x0E, 0xD0, 0x57,
  0x10, 0x2D, 0x0E, 0x03, 0x77, 0x30, 0xAC, 0x0E, 0x04, 0x72, 0x0C, 0xC0, 0xD0, 0x37, 0x74, 0xC0,
  0xD0, 0x27, 0x20, 0x3C, 0x0C, 0x01, 0x80, 0xBF, 0x60, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C,
  0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0,
  0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77,
  0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F,
  0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03,
  0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7,
  0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20,
  0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C,
  0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0,
  0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77,
  0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F,
  0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x5F, 0x0C, 0x03,
  0xF0, 0xD7, 0x77, 0x20, 0x5F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x6F, 0x0C, 0x03, 0xF0, 0xD7,
  0x77, 0x20, 0x7F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x9F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20,
  0xBF, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0xEF, 0x0C, 0x03, 0xF0, 0xE7, 0x77, 0x10, 0x1F, 0x90,
  0xC0, 0x3F, 0x97, 0x77, 0x10, 0x6F, 0x90, 0xC0, 0x2F, 0x90, 0x27, 0x77, 0x0B, 0xF9, 0x0C, 0x1F,
  0x90, 0x57, 0x76, 0x01, 0xFA, 0x81, 0xC0, 0xEF, 0x0A, 0x77, 0x60, 0x8F, 0xA8, 0x1C, 0x0B, 0xF9,
  0x01, 0x77, 0x40, 0x10, 0xEF, 0xA8, 0x1C, 0x07, 0xF9, 0x09, 0x77, 0x40, 0xAF, 0xB8, 0x1C, 0x02,
  0xFA, 0x04, 0x77, 0x20, 0x9F, 0xC0, 0xC2, 0x0C, 0xFA, 0x05, 0x76, 0x01, 0x0B, 0xFD, 0x0C, 0x20,
  0x5F, 0xB0, 0xC0, 0x47, 0x20, 0x30, 0x9E, 0x0D, 0x0E, 0xE0, 0xC3, 0x0C, 0xFD, 0x86, 0xCA, 0x98,
  0x9A, 0xCE, 0xF8, 0x1E, 0x2A, 0xE0, 0xC3, 0x03, 0xFF, 0xFE, 0x81, 0x50, 0x7E, 0x0C, 0x40, 0x5F,
  0xFF, 0xC0, 0x62, 0x05, 0xE0, 0xC5, 0x05, 0xFF, 0xF9, 0x0E, 0x05, 0x30, 0x2E, 0x0C, 0x60, 0x20,
  0xCF, 0xFD, 0x0B, 0x02, 0x50, 0xED, 0x0C, 0x71, 0x04, 0x0B, 0xFF, 0x81, 0xEA, 0x47, 0x0C, 0xD0,
  0xC7, 0x38, 0x41, 0x58, 0xBD, 0xEA, 0x84, 0xEE, 0xCA, 0x84, 0x77, 0x30,
  // "Ų" (U+0172)
  0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67,
  0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F,
  0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06,
  0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06,
  0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0,
  0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30,
  0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF,
  0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73,
  0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A,
  0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77,
  0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00,
  0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77,
  0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0,
  0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67,
  0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F,
  0x00, 0xAF, 0x06, 0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06,
  0x77, 0x73, 0x06, 0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x6F, 0x00, 0xAF, 0x06, 0x77, 0x73, 0x06,
  0xF0, 0x0A, 0xF0, 0x67, 0x77, 0x30, 0x7F, 0x0A, 0x09, 0xF0, 0x77, 0x77, 0x30, 0x8F, 0x00, 0x9F,
  0x08, 0x77, 0x73, 0x09, 0xF0, 0x90, 0x7F, 0x0A, 0x77, 0x73, 0x0A, 0xF0, 0x80, 0x5F, 0x0C, 0x77,
  0x73, 0x0D, 0xF0, 0x60, 0x4F, 0x97, 0x77, 0x3F, 0x90, 0x40, 0x1F, 0x90, 0x27, 0x77, 0x10, 0x3F,
  0x98, 0x11, 0x0D, 0xF0, 0x67, 0x77, 0x10, 0x6F, 0x0E, 0x20, 0xAF, 0x0B, 0x77, 0x71, 0x0A, 0xF0,
  0xA2, 0x06, 0xF9, 0x01, 0x77, 0x60, 0x1F, 0x90, 0x62, 0x01, 0xF9, 0x09, 0x77, 0x60, 0x8F, 0x90,
  0x23, 0x0C, 0xF9, 0x03, 0x77, 0x40, 0x20, 0xEF, 0x0C, 0x40, 0x5F, 0x90, 0xD0, 0x17, 0x73, 0x0C,
  0xF9, 0x06, 0x50, 0xDF, 0x90, 0xD0, 0x17, 0x70, 0x10, 0xCF, 0x90, 0xE6, 0x06, 0xFA, 0x0E, 0x06,
  0x75, 0x05, 0x0E, 0xFA, 0x06, 0x70, 0xBF, 0xB8, 0x3E, 0x95, 0x21, 0x28, 0x31, 0x25, 0x8E, 0xFB,
  0x0D, 0x71, 0x01, 0x0E, 0xFF, 0xFF, 0xA0, 0xE0, 0x27, 0x20, 0x30, 0xEF, 0xFF, 0xF9, 0x05, 0x74,
  0x03, 0x0E, 0xFF, 0xFE, 0x05, 0x76, 0x01, 0x0C, 0xFF, 0xFB, 0x0D, 0x03, 0x77, 0x20, 0x60, 0xDF,
  0xFF, 0x08, 0x77, 0x60, 0x60, 0xBF, 0xFB, 0x0B, 0x02, 0x77, 0x72, 0x85, 0x15, 0x7A, 0xCD, 0xEF,
  0x90, 0xE0, 0x57, 0x77, 0x74, 0x07, 0xE0, 0xB0, 0x17, 0x77, 0x74, 0x09, 0xE0, 0x77, 0x77, 0x75,
  0x09, 0xE0, 0x57, 0x77, 0x75, 0x07, 0xE0, 0x47, 0x77, 0x75, 0x04, 0xE0, 0x57, 0x77, 0x76, 0x0D,
  0xD0, 0xA7, 0x77, 0x76, 0x05, 0xE0, 0x27, 0x77, 0x76, 0x0A, 0xD0, 0xC7, 0x77, 0x77, 0x0D, 0xD0,
  0x87, 0x77, 0x77, 0xE0, 0x77, 0x77, 0x77, 0xE0, 0x87, 0x77, 0x77, 0x0E, 0xD0, 0xB7, 0x77, 0x77,
  0x0B, 0xE0, 0x47, 0x77, 0x76, 0x07, 0xF0, 0x70, 0x22, 0x81, 0x13, 0x57, 0x77, 0x60, 0x1F, 0xE0,
  0xC7, 0x77, 0x70, 0x7F, 0xD0, 0xC7, 0x77, 0x71, 0x0A, 0xFC, 0x0C, 0x77, 0x77, 0x20, 0x8F, 0xB0,
  0xC7, 0x77, 0x73, 0x89, 0x11, 0x7B, 0xDE, 0xFE, 0xDB, 0x84, 0x75,
  // "ų" (U+0173)
  0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x20, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC2, 0x03,
  0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x20, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC2, 0x03, 0xF0,
  0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x20, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC2, 0x03, 0xF0, 0xD7,
  0x77, 0x20, 0x4F, 0x0C, 0x20, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC2, 0x03, 0xF0, 0xD7, 0x77,
  0x20, 0x4F, 0x0C, 0x20, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC2, 0x03, 0xF0, 0xD7, 0x77, 0x20,
  0x4F, 0x0C, 0x20, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC2, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F,
  0x0C, 0x20, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC2, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C,
  0x20, 0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC2, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x20,
  0x3F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC2, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x20, 0x3F,
  0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC2, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x20, 0x3F, 0x0D,
  0x77, 0x72, 0x04, 0xF0, 0xC2, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x20, 0x3F, 0x0D, 0x77,
  0x72, 0x04, 0xF0, 0xC2, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x20, 0x3F, 0x0D, 0x77, 0x72,
  0x05, 0xF0, 0xC2, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x5F, 0x0C, 0x20, 0x3F, 0x0D, 0x77, 0x72, 0x06,
  0xF0, 0xC2, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x7F, 0x0C, 0x20, 0x3F, 0x0D, 0x77, 0x72, 0x09, 0xF0,
  0xC2, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0xBF, 0x0C, 0x20, 0x3F, 0x0D, 0x77, 0x72, 0x0E, 0xF0, 0xC2,
  0x03, 0xF0, 0xE7, 0x77, 0x10, 0x1F, 0x90, 0xC2, 0x03, 0xF9, 0x77, 0x71, 0x06, 0xF9, 0x0C, 0x20,
  0x2F, 0x90, 0x27, 0x77, 0x0B, 0xF9, 0x0C, 0x3F, 0x90, 0x57, 0x76, 0x01, 0xFA, 0x0C, 0x30, 0xEF,
  0x0A, 0x77, 0x60, 0x8F, 0xA0, 0xC3, 0x0B, 0xF9, 0x01, 0x77, 0x40, 0x10, 0xEF, 0xA0, 0xC3, 0x07,
  0xF9, 0x09, 0x77, 0x40, 0xAF, 0xB0, 0xC3, 0x02, 0xFA, 0x04, 0x77, 0x20, 0x9F, 0xC0, 0xC4, 0x0C,
  0xFA, 0x05, 0x76, 0x01, 0x0B, 0xFD, 0x0C, 0x40, 0x5F, 0xB0, 0xC0, 0x47, 0x20, 0x30, 0x9E, 0x0D,
  0x0E, 0xE0, 0xC5, 0x0C, 0xFD, 0x86, 0xCA, 0x98, 0x9A, 0xCE, 0xF8, 0x1E, 0x2A, 0xE0, 0xC5, 0x03,
  0xFF, 0xFE, 0x81, 0x50, 0x7E, 0x0C, 0x60, 0x5F, 0xFF, 0xC0, 0x62, 0x05, 0xE0, 0xC7, 0x05, 0xFF,
  0xF9, 0x0E, 0x05, 0x30, 0x2E, 0x0C, 0x71, 0x02, 0x0C, 0xFF, 0xD0, 0xB0, 0x25, 0x0E, 0xD0, 0xC7,
  0x30, 0x40, 0xBF, 0xF8, 0x1E, 0xA4, 0x70, 0xCD, 0x0C, 0x75, 0x84, 0x15, 0x8B, 0xDE, 0xA8, 0x4E,
  0xEC, 0xA8, 0x47, 0x30, 0x6C, 0x0B, 0x02, 0x77, 0x77, 0x70, 0x8D, 0x08, 0x77, 0x77, 0x70, 0x9D,
  0x08, 0x77, 0x77, 0x70, 0x7D, 0x0A, 0x77, 0x77, 0x70, 0x5D, 0x0C, 0x77, 0x77, 0x70, 0x10, 0xED,
  0x02, 0x77, 0x77, 0x70, 0x9D, 0x08, 0x77, 0x77, 0x70, 0x2E, 0x01, 0x77, 0x77, 0x70, 0x8D, 0x0B,
  0x80, 0xC0, 0x00, 0xCD, 0x07, 0x80, 0xC0, 0x0E, 0x06, 0x77, 0x77, 0x70, 0x1E, 0x06, 0x77, 0x77,
  0x70, 0x1E, 0x09, 0x80, 0xC0, 0x0E, 0x0E, 0x01, 0x77, 0x77, 0x70, 0xBE, 0x81, 0xD6, 0x22, 0x81,
  0x13, 0x47, 0x77, 0x70, 0x6F, 0xE0, 0xB7, 0x77, 0x71, 0x0D, 0xFD, 0x0B, 0x77, 0x77, 0x10, 0x20,
  0xEF, 0xC0, 0xB7, 0x77, 0x72, 0x02, 0x0B, 0xFB, 0x0B, 0x77, 0x77, 0x48, 0x91, 0x38, 0xBD, 0xEF,
  0xED, 0xB8, 0x30,
  // "Ŵ" (U+0174)
  0x77, 0x60, 0x28, 0x04, 0x78, 0x0C, 0x50, 0x0C, 0xF9, 0x08, 0x80, 0xC3, 0x00, 0x6F, 0xB0, 0x38,
  0x0C, 0x10, 0x03, 0xFC, 0x0D, 0x01, 0x80, 0xC0, 0x00, 0xDF, 0xD0, 0xA7, 0x77, 0x77, 0x0B, 0xFF,
  0x07, 0x77, 0x77, 0x50, 0x8F, 0x0A, 0x0D, 0xF0, 0x57, 0x77, 0x73, 0x06, 0xF8, 0x29, 0x01, 0xDF,
  0x03, 0x77, 0x77, 0x10, 0x4F, 0x09, 0x30, 0x10, 0xDE, 0x0E, 0x02, 0x77, 0x76, 0x02, 0x0E, 0xE0,
  0x95, 0x01, 0x0C, 0xE0, 0xD0, 0x17, 0x77, 0x40, 0x10, 0xDE, 0x08, 0x70, 0x10, 0xCE, 0x0C, 0x77,
  0x74, 0x0C, 0xE0, 0x87, 0x20, 0x10, 0xBE, 0x0B, 0x77, 0x72, 0x0B, 0xE0, 0x67, 0x50, 0xAE, 0x0A,
  0x77, 0x70, 0xAD, 0x0E, 0x04, 0x77, 0x07, 0xE0, 0xA7, 0x75, 0x03, 0xD0, 0xB0, 0x17, 0x72, 0x03,
  0x0D, 0xD0, 0x38, 0x0C, 0xE1, 0x00, 0xAE, 0x0B, 0x77, 0x77, 0x60, 0xBE, 0x0A, 0x09, 0xE0, 0xD7,
  0x77, 0x76, 0x0D, 0xE0, 0x90, 0x7E, 0x0E, 0x77, 0x77, 0x60, 0xEE, 0x07, 0x05, 0xF7, 0x77, 0x76,
  0xF0, 0x60, 0x3F, 0x02, 0x77, 0x77, 0x40, 0x1F, 0x04, 0x02, 0xF0, 0x37, 0x77, 0x74, 0x03, 0xF0,
  0x31, 0xF0, 0x57, 0x77, 0x74, 0x04, 0xF8, 0x11, 0x0E, 0xE0, 0x77, 0x77, 0x74, 0x05, 0xF2, 0x0C,
  0xE0, 0x87, 0x77, 0x74, 0x07, 0xE0, 0xD2, 0x0A, 0xE0, 0xA7, 0x77, 0x74, 0x08, 0xE0, 0xC2, 0x08,
  0xE0, 0xB7, 0x77, 0x74, 0x09, 0xE0, 0xA2, 0x07, 0xE0, 0xD7, 0x77, 0x74, 0x0B, 0xE0, 0x92, 0x05,
  0xE0, 0xE7, 0x77, 0x74, 0x0C, 0xE0, 0x72, 0x03, 0xF7, 0x77, 0x74, 0x0D, 0xE0, 0x52, 0x01, 0xF0,
  0x27, 0x77, 0x73, 0xF0, 0x43, 0xF0, 0x37, 0x77, 0x72, 0x01, 0xF0, 0x23, 0x0D, 0xE0, 0x57, 0x40,
  0xDF, 0x01, 0x73, 0x02, 0xF0, 0x13, 0x0C, 0xE0, 0x67, 0x30, 0x2F, 0x90, 0x47, 0x30, 0x3F, 0x40,
  0xAE, 0x07, 0x73, 0x05, 0xF9, 0x08, 0x73, 0x05, 0xE0, 0xD4, 0x08, 0xE0, 0x97, 0x30, 0x9F, 0x90,
  0xC7, 0x30, 0x6E, 0x0C, 0x40, 0x6E, 0x0A, 0x73, 0x0C, 0xFA, 0x73, 0x07, 0xE0, 0xA4, 0x05, 0xE0,
  0xC7, 0x20, 0x1F, 0xB0, 0x47, 0x20, 0x9E, 0x08, 0x40, 0x3E, 0x0D, 0x72, 0x04, 0xFB, 0x07, 0x72,
  0x0A, 0xE0, 0x74, 0x01, 0xF7, 0x20, 0x8F, 0xB0, 0xB7, 0x20, 0xBE, 0x05, 0x5F, 0x01, 0x71, 0x0B,
  0xD0, 0xCD, 0x72, 0x0D, 0xE0, 0x45, 0x0D, 0xE0, 0x27, 0x1D, 0x0D, 0x09, 0xD0, 0x37, 0x10, 0xEE,
  0x02, 0x50, 0xBE, 0x03, 0x70, 0x3D, 0x0A, 0x06, 0xD0, 0x77, 0x1F, 0x01, 0x50, 0xAE, 0x05, 0x70,
  0x7D, 0x07, 0x03, 0xD0, 0xB7, 0x01, 0xE0, 0xE6, 0x08, 0xE0, 0x67, 0x0A, 0xD0, 0x51, 0xD0, 0xE7,
  0x03, 0xE0, 0xD6, 0x06, 0xE0, 0x87, 0x0E, 0xD8, 0x12, 0x0C, 0xD0, 0x36, 0x04, 0xE0, 0xB6, 0x04,
  0xE0, 0x96, 0x02, 0xD0, 0xE2, 0x08, 0xD0, 0x66, 0x05, 0xE0, 0xA6, 0x03, 0xE0, 0xB6, 0x06, 0xD0,
  0xB2, 0x05, 0xD0, 0xA6, 0x06, 0xE0, 0x86, 0x01, 0xE0, 0xC6, 0x09, 0xD0, 0x82, 0x02, 0xD0, 0xE6,
  0x07, 0xE0, 0x77, 0xE0, 0xE6, 0x0D, 0xD0, 0x43, 0x0E, 0xD0, 0x25, 0x08, 0xE0, 0x57, 0x0D, 0xE5,
  0x01, 0xE0, 0x13, 0x0A, 0xD0, 0x65, 0x09, 0xE0, 0x37, 0x0B, 0xE0, 0x14, 0x05, 0xD0, 0xC4, 0x06,
  0xD0, 0x95, 0x0A, 0xE0, 0x27, 0x09, 0xE0, 0x24, 0x08, 0xD0, 0x94, 0x03, 0xD0, 0xD5, 0x0B, 0xE7,
  0x10, 0x8E, 0x03, 0x40, 0xCD, 0x05, 0x50, 0xED, 0x01, 0x40, 0xCD, 0x0E, 0x71, 0x06, 0xE0, 0x44,
  0xE0, 0x15, 0x0B, 0xD0, 0x54, 0x0E, 0xD0, 0xD7, 0x10, 0x4E, 0x05, 0x30, 0x3D, 0x0D, 0x60, 0x7D,
  0x09, 0x4E, 0x0B, 0x71, 0x03, 0xE0, 0x63, 0x07, 0xD0, 0x96, 0x03, 0xD0, 0xD4, 0xE0, 0xA7, 0x10,
  0x1E, 0x07, 0x30, 0xAD, 0x06, 0x70, 0xED, 0x01, 0x20, 0x1E, 0x08, 0x72, 0xE0, 0x93, 0x0D, 0xD0,
  0x27, 0x0B, 0xD0, 0x52, 0x02, 0xE0, 0x67, 0x20, 0xDD, 0x0A, 0x20, 0x1D, 0x0E, 0x71, 0x07, 0xD0,
  0x82, 0x03, 0xE0, 0x57, 0x20, 0xBD, 0x0B, 0x20, 0x4D, 0x0A, 0x71, 0x03, 0xD0, 0xC2, 0x04, 0xE0,
  0x37, 0x20, 0x9D, 0x0C, 0x20, 0x8D, 0x07, 0x72, 0xE2, 0x05, 0xE0, 0x27, 0x20, 0x8D, 0x0D, 0x20,
  0xBD, 0x03, 0x72, 0x0B, 0xD8, 0x13, 0x06, 0xE7, 0x30, 0x6D, 0x0E, 0x20, 0xED, 0x73, 0x07, 0xD8,
  0x16, 0x07, 0xD0, 0xE7, 0x30, 0x4E, 0x10, 0x2D, 0x0B, 0x73, 0x03, 0xD8, 0x1A, 0x08, 0xD0, 0xC7,
  0x30, 0x2E, 0x10, 0x5D, 0x08, 0x74, 0xD8, 0x1D, 0x08, 0xD0, 0xB7, 0x30, 0x1E, 0x01, 0x09, 0xD0,
  0x47, 0x40, 0xBD, 0x01, 0x09, 0xD0, 0x97, 0x40, 0xED, 0x02, 0x0C, 0xD7, 0x50, 0x8D, 0x04, 0x0A,
  0xD0, 0x87, 0x40, 0xDD, 0x03, 0xD0, 0xC7, 0x50, 0x4D, 0x07, 0x0B, 0xD0, 0x67, 0x40, 0xBD, 0x06,
  0xD0, 0x87, 0x6D, 0x0A, 0x0C, 0xD0, 0x57, 0x40, 0x9D, 0x0A, 0xD0, 0x57, 0x60, 0xCC, 0x00, 0xCD,
  0x03, 0x74, 0x07, 0xD0, 0xED, 0x01, 0x76, 0x08, 0xD0, 0xED, 0x01, 0x74, 0x06, 0xFB, 0x0D, 0x77,
  0x04, 0xFC, 0x75, 0x04, 0xFB, 0x09, 0x77, 0x1F, 0xB0, 0xE7, 0x50, 0x2F, 0xB0, 0x67, 0x71, 0x0C,
  0xFA, 0x0C, 0x76, 0xFB, 0x02, 0x77, 0x10, 0x8F, 0xA0, 0xB7, 0x60, 0xEF, 0x90, 0xE7, 0x72, 0x04,
  0xFA, 0x09, 0x76, 0x0C, 0xF9, 0x0A, 0x77, 0x20, 0x1F, 0xA0, 0x87, 0x60, 0xBF, 0x90, 0x67, 0x73,
  0x0C, 0xF9, 0x06, 0x76, 0x09, 0xF9, 0x03, 0x77, 0x30, 0x8F, 0x90, 0x46,
  // "ŵ" (U+0175)
  0x77, 0x70, 0x28, 0x04, 0x78, 0x0C, 0x70, 0x0C, 0xF9, 0x08, 0x80, 0xC5, 0x00, 0x6F, 0xB0, 0x38,
  0x0C, 0x30, 0x03, 0xFC, 0x0D, 0x01, 0x80, 0xC2, 0x00, 0xDF, 0xD0, 0xA8, 0x0C, 0x10, 0x0B, 0xFF,
  0x07, 0x77, 0x77, 0x70, 0x8F, 0x0A, 0x0D, 0xF0, 0x57, 0x77, 0x75, 0x06, 0xF8, 0x29, 0x01, 0xDF,
  0x03, 0x77, 0x77, 0x30, 0x4F, 0x09, 0x30, 0x10, 0xDE, 0x0E, 0x02, 0x77, 0x77, 0x10, 0x20, 0xEE,
  0x09, 0x50, 0x10, 0xCE, 0x0D, 0x01, 0x77, 0x76, 0x01, 0x0D, 0xE0, 0x87, 0x01, 0x0C, 0xE0, 0xC7,
  0x77, 0x60, 0xCE, 0x08, 0x72, 0x01, 0x0B, 0xE0, 0xB7, 0x77, 0x40, 0xBE, 0x06, 0x75, 0x0A, 0xE0,
  0xA7, 0x77, 0x20, 0xAD, 0x0E, 0x04, 0x77, 0x07, 0xE0, 0xA7, 0x77, 0x03, 0xD0, 0xB0, 0x17, 0x72,
  0x03, 0x0D, 0xD0, 0x38, 0x0C, 0xF6, 0x00, 0x7F, 0x01, 0x77, 0x77, 0x70, 0xCE, 0x08, 0x05, 0xF0,
  0x37, 0x77, 0x77, 0x0E, 0xE0, 0x60, 0x2F, 0x05, 0x77, 0x77, 0x60, 0x2F, 0x03, 0x1F, 0x08, 0x77,
  0x77, 0x60, 0x4F, 0x81, 0x10, 0xDE, 0x0A, 0x77, 0x77, 0x60, 0x7E, 0x0E, 0x20, 0xAE, 0x0C, 0x77,
  0x77, 0x60, 0x9E, 0x0B, 0x20, 0x8E, 0x0E, 0x77, 0x77, 0x60, 0xBE, 0x09, 0x20, 0x5F, 0x01, 0x77,
  0x77, 0x50, 0xEE, 0x06, 0x20, 0x3F, 0x03, 0x77, 0x77, 0x40, 0x1F, 0x03, 0x3F, 0x06, 0x74, 0x09,
  0xF9, 0x08, 0x74, 0x03, 0xF0, 0x13, 0x0D, 0xE0, 0x87, 0x40, 0xEF, 0x90, 0xC7, 0x40, 0x6E, 0x0E,
  0x40, 0xBE, 0x0A, 0x73, 0x03, 0xFB, 0x01, 0x73, 0x08, 0xE0, 0xB4, 0x08, 0xE0, 0xD7, 0x30, 0x7F,
  0xB0, 0x57, 0x30, 0xBE, 0x09, 0x40, 0x5F, 0x73, 0x0C, 0xFB, 0x09, 0x73, 0x0D, 0xE0, 0x64, 0x03,
  0xF0, 0x27, 0x10, 0x1F, 0xC0, 0xE7, 0x3F, 0x04, 0x40, 0x1F, 0x04, 0x71, 0x05, 0xFD, 0x03, 0x71,
  0x03, 0xF0, 0x15, 0x0D, 0xE0, 0x67, 0x10, 0xAF, 0xD0, 0x77, 0x10, 0x5E, 0x0E, 0x60, 0xBE, 0x09,
  0x71, 0x0E, 0xD0, 0xA0, 0xCD, 0x0B, 0x71, 0x08, 0xE0, 0xB6, 0x09, 0xE0, 0xB7, 0x03, 0xE0, 0x70,
  0x8E, 0x71, 0x0A, 0xE0, 0x96, 0x06, 0xE0, 0xD7, 0x08, 0xE0, 0x30, 0x5E, 0x04, 0x70, 0xDE, 0x06,
  0x60, 0x3F, 0x70, 0xCE, 0x10, 0x1E, 0x08, 0x7F, 0x04, 0x60, 0x1F, 0x02, 0x50, 0x1E, 0x0B, 0x20,
  0xDD, 0x0D, 0x60, 0x2F, 0x01, 0x70, 0xEE, 0x05, 0x50, 0x5E, 0x07, 0x20, 0x9E, 0x02, 0x50, 0x4E,
  0x0E, 0x71, 0x0B, 0xE0, 0x75, 0x0A, 0xE0, 0x32, 0x05, 0xE0, 0x65, 0x07, 0xE0, 0xC7, 0x10, 0x9E,
  0x09, 0x50, 0xED, 0x0E, 0x30, 0x1E, 0x0A, 0x50, 0x9E, 0x09, 0x71, 0x06, 0xE0, 0xB4, 0x03, 0xE0,
  0xA4, 0x0D, 0xD0, 0xE5, 0x0B, 0xE0, 0x67, 0x10, 0x4E, 0x0E, 0x40, 0x8E, 0x06, 0x40, 0x9E, 0x03,
  0x40, 0xEE, 0x04, 0x71, 0x01, 0xF4, 0x0C, 0xE0, 0x14, 0x05, 0xE0, 0x84, 0xF0, 0x17, 0x20, 0xEE,
  0x02, 0x3E, 0x0D, 0x50, 0x1E, 0x0C, 0x30, 0x2E, 0x0E, 0x73, 0x0C, 0xE0, 0x32, 0x04, 0xE0, 0x86,
  0x0C, 0xE3, 0x04, 0xE0, 0xC7, 0x30, 0x9E, 0x05, 0x20, 0x8E, 0x04, 0x60, 0x8E, 0x04, 0x20, 0x5E,
  0x09, 0x73, 0x07, 0xE0, 0x62, 0x0B, 0xE7, 0x04, 0xE0, 0x82, 0x07, 0xE0, 0x77, 0x30, 0x4E, 0x07,
  0x20, 0xED, 0x0B, 0x71, 0xE0, 0xB2, 0x08, 0xE0, 0x47, 0x30, 0x2E, 0x81, 0x90, 0x2E, 0x07, 0x71,
  0x0B, 0xD0, 0xE2, 0x09, 0xE0, 0x17, 0x4E, 0x81, 0xA0, 0x5E, 0x03, 0x71, 0x07, 0xE8, 0x13, 0x0B,
  0xD0, 0xE7, 0x50, 0xCD, 0x81, 0xB0, 0x8D, 0x0E, 0x72, 0x03, 0xE8, 0x16, 0x0C, 0xD0, 0xC7, 0x50,
  0xAD, 0x81, 0xC0, 0xBD, 0x0A, 0x73, 0x0E, 0xD8, 0x19, 0x0D, 0xD0, 0x97, 0x50, 0x7D, 0x81, 0xE0,
  0xED, 0x06, 0x73, 0x0B, 0xD8, 0x1D, 0x0E, 0xD0, 0x77, 0x50, 0x5E, 0x01, 0xE0, 0x27, 0x30, 0x7E,
  0x01, 0xE0, 0x47, 0x50, 0x2E, 0x04, 0xD0, 0xD7, 0x40, 0x3E, 0x05, 0xE0, 0x27, 0x6E, 0x08, 0xD0,
  0x97, 0x50, 0xED, 0x08, 0xD0, 0xE7, 0x70, 0xDD, 0x0D, 0xD0, 0x57, 0x50, 0xAD, 0x0D, 0xD0, 0xC7,
  0x70, 0xAF, 0xC0, 0x17, 0x50, 0x6F, 0xC0, 0x97, 0x70, 0x8F, 0xB0, 0xC7, 0x60, 0x2F, 0xC0, 0x77,
  0x70, 0x5F, 0xB0, 0x87, 0x70, 0xDF, 0xB0, 0x47, 0x70, 0x3F, 0xB0, 0x47, 0x70, 0x9F, 0xB0, 0x27,
  0x71, 0xFB, 0x77, 0x10, 0x5F, 0xB7, 0x72, 0x0D, 0xF9, 0x0B, 0x77, 0x10, 0x1F, 0xA0, 0xC7, 0x10,
  // "Ŷ" (U+0176)
  0x77, 0x50, 0x28, 0x04, 0x78, 0x0C, 0x30, 0x0C, 0xF9, 0x08, 0x80, 0xC1, 0x00, 0x6F, 0xB0, 0x37,
  0x77, 0x77, 0x03, 0xFC, 0x0D, 0x01, 0x77, 0x77, 0x60, 0xDF, 0xD0, 0xA7, 0x77, 0x75, 0x0B, 0xFF,
  0x07, 0x77, 0x77, 0x30, 0x8F, 0x0A, 0x0D, 0xF0, 0x57, 0x77, 0x71, 0x06, 0xF8, 0x29, 0x01, 0xDF,
  0x03, 0x77, 0x76, 0x04, 0xF0, 0x93, 0x01, 0x0D, 0xE0, 0xE0, 0x27, 0x77, 0x40, 0x20, 0xEE, 0x09,
  0x50, 0x10, 0xCE, 0x0D, 0x01, 0x77, 0x72, 0x01, 0x0D, 0xE0, 0x87, 0x01, 0x0C, 0xE0, 0xC7, 0x77,
  0x20, 0xCE, 0x08, 0x72, 0x01, 0x0B, 0xE0, 0xB7, 0x77, 0x0B, 0xE0, 0x67, 0x50, 0xAE, 0x0A, 0x77,
  0x50, 0xAD, 0x0E, 0x04, 0x77, 0x07, 0xE0, 0xA7, 0x73, 0x03, 0xD0, 0xB0, 0x17, 0x72, 0x03, 0x0D,
  0xD0, 0x38, 0x0C, 0xC4, 0x00, 0x9F, 0x90, 0x47, 0x77, 0x70, 0x10, 0xEF, 0x09, 0x01, 0xF9, 0x0B,
  0x77, 0x77, 0x07, 0xF9, 0x81, 0x10, 0x9F, 0x90, 0x37, 0x77, 0x60, 0xEF, 0x08, 0x20, 0x1F, 0x90,
  0xA7, 0x77, 0x50, 0x6F, 0x90, 0x13, 0x08, 0xF9, 0x02, 0x77, 0x74, 0x0D, 0xF0, 0x84, 0x01, 0x0E,
  0xF0, 0x97, 0x77, 0x30, 0x5F, 0x0E, 0x01, 0x50, 0x8F, 0x0E, 0x01, 0x77, 0x72, 0x0C, 0xF0, 0x86,
  0x01, 0x0E, 0xF0, 0x77, 0x77, 0x10, 0x3F, 0x0E, 0x01, 0x70, 0x8F, 0x0E, 0x77, 0x71, 0x0B, 0xF0,
  0x87, 0x10, 0x10, 0xEF, 0x06, 0x77, 0x60, 0x2F, 0x0E, 0x01, 0x72, 0x08, 0xF0, 0xD7, 0x76, 0x09,
  0xF0, 0x87, 0x30, 0x10, 0xEF, 0x05, 0x77, 0x40, 0x1F, 0x0E, 0x01, 0x74, 0x08, 0xF0, 0xC7, 0x74,
  0x08, 0xF0, 0x77, 0x50, 0x10, 0xEF, 0x03, 0x77, 0x20, 0x10, 0xEE, 0x0E, 0x01, 0x76, 0x07, 0xF0,
  0xA7, 0x72, 0x07, 0xF0, 0x77, 0x71, 0x0E, 0xF0, 0x27, 0x71, 0x0E, 0xE0, 0xE7, 0x72, 0x07, 0xF0,
  0x97, 0x70, 0x6F, 0x07, 0x77, 0x30, 0xEF, 0x01, 0x76, 0x0D, 0xE0, 0xE7, 0x74, 0x07, 0xF0, 0x87,
  0x50, 0x4F, 0x07, 0x77, 0x50, 0xEE, 0x0E, 0x75, 0x0C, 0xE0, 0xE7, 0x76, 0x07, 0xF0, 0x77, 0x30,
  0x3F, 0x07, 0x77, 0x70, 0xEE, 0x0D, 0x73, 0x0A, 0xE0, 0xE7, 0x77, 0x10, 0x7F, 0x05, 0x71, 0x02,
  0xF0, 0x77, 0x77, 0x20, 0xEE, 0x0C, 0x71, 0x09, 0xE0, 0xE7, 0x77, 0x30, 0x6F, 0x04, 0x60, 0x1F,
  0x06, 0x77, 0x74, 0x0D, 0xE0, 0xB6, 0x08, 0xE0, 0xD7, 0x77, 0x50, 0x6F, 0x03, 0x50, 0xEE, 0x06,
  0x77, 0x76, 0x0D, 0xE0, 0xA4, 0x07, 0xE0, 0xD7, 0x77, 0x70, 0x6F, 0x02, 0x30, 0xDE, 0x06, 0x77,
  0x77, 0x10, 0xDE, 0x08, 0x20, 0x5E, 0x0D, 0x77, 0x77, 0x20, 0x6E, 0x82, 0xE1, 0x0D, 0xE0, 0x67,
  0x77, 0x73, 0x0D, 0xE0, 0x70, 0x4E, 0x0D, 0x77, 0x77, 0x40, 0x6E, 0x0E, 0x0C, 0xE0, 0x67, 0x77,
  0x75, 0x0D, 0xFD, 0x0D, 0x77, 0x77, 0x60, 0x5F, 0xD0, 0x57, 0x77, 0x77, 0x0D, 0xFB, 0x0D, 0x80,
  0xC0, 0x00, 0x5F, 0xB0, 0x58, 0x0C, 0x10, 0x0D, 0xF9, 0x0D, 0x80, 0xC2, 0x00, 0x5F, 0x90, 0x58,
  0x0C, 0x30, 0x0E, 0xE0, 0xE8, 0x0C, 0x40, 0x0D, 0xE0, 0xD8, 0x0C, 0x40, 0x0D, 0xE0, 0xD8, 0x0C,
  0x40, 0x0D, 0xE0, 0xD8, 0x0C, 0x40, 0x0D, 0xE0, 0xD8, 0x0C, 0x40, 0x0D, 0xE0, 0xD8, 0x0C, 0x40,
  0x0D, 0xE0, 0xD8, 0x0C, 0x40, 0x0D, 0xE0, 0xD8, 0x0C, 0x40, 0x0D, 0xE0, 0xD8, 0x0C, 0x40, 0x0D,
  0xE0, 0xD8, 0x0C, 0x40, 0x0D, 0xE0, 0xD8, 0x0C, 0x40, 0x0D, 0xE0, 0xD8, 0x0C, 0x40, 0x0D, 0xE0,
  0xD8, 0x0C, 0x40, 0x0D, 0xE0, 0xD8, 0x0C, 0x40, 0x0D, 0xE0, 0xD8, 0x0C, 0x40, 0x0D, 0xE0, 0xD8,
  0x0C, 0x40, 0x0D, 0xE0, 0xD8, 0x0C, 0x40, 0x0D, 0xE0, 0xD8, 0x0C, 0x40, 0x0D, 0xE0, 0xD8, 0x0C,
  0x40, 0x0D, 0xE0, 0xD8, 0x0C, 0x40, 0x0D, 0xE0, 0xD8, 0x0C, 0x40, 0x0D, 0xE0, 0xD8, 0x0C, 0x40,
  0x0D, 0xE0, 0xD8, 0x0C, 0x40, 0x0D, 0xE0, 0xD8, 0x0C, 0x40, 0x0D, 0xE0, 0xD7, 0x76,
  // "ŷ" (U+0177)
  0x77, 0x40, 0x28, 0x04, 0x78, 0x0C, 0x10, 0x0C, 0xF9, 0x08, 0x77, 0x77, 0x70, 0x6F, 0xB0, 0x37,
  0x77, 0x75, 0x03, 0xFC, 0x0D, 0x01, 0x77, 0x77, 0x40, 0xDF, 0xD0, 0xA7, 0x77, 0x73, 0x0B, 0xFF,
  0x07, 0x77, 0x77, 0x10, 0x8F, 0x0A, 0x0D, 0xF0, 0x57, 0x77, 0x60, 0x6F, 0x82, 0x90, 0x1D, 0xF0,
  0x37, 0x77, 0x40, 0x4F, 0x09, 0x30, 0x10, 0xDE, 0x0E, 0x02, 0x77, 0x72, 0x02, 0x0E, 0xE0, 0x95,
  0x01, 0x0C, 0xE0, 0xD0, 0x17, 0x77, 0x01, 0x0D, 0xE0, 0x87, 0x01, 0x0C, 0xE0, 0xC7, 0x77, 0x0C,
  0xE0, 0x87, 0x20, 0x10, 0xBE, 0x0B, 0x77, 0x50, 0xBE, 0x06, 0x75, 0x0A, 0xE0, 0xA7, 0x73, 0x0A,
  0xD0, 0xE0, 0x47, 0x70, 0x7E, 0x0A, 0x77, 0x10, 0x3D, 0x0B, 0x01, 0x77, 0x20, 0x30, 0xDD, 0x03,
  0x80, 0xCA, 0x70, 0x0B, 0xF0, 0x27, 0x77, 0x70, 0x9F, 0x0A, 0x05, 0xF0, 0x97, 0x77, 0x70, 0xEF,
  0x81, 0x40, 0xDE, 0x0E, 0x77, 0x76, 0x04, 0xF0, 0xE2, 0x07, 0xF0, 0x67, 0x77, 0x50, 0x9F, 0x08,
  0x20, 0x1F, 0x0C, 0x77, 0x75, 0x0E, 0xF0, 0x23, 0x0A, 0xF0, 0x37, 0x77, 0x30, 0x4F, 0x0C, 0x40,
  0x3F, 0x09, 0x77, 0x73, 0x09, 0xF0, 0x65, 0x0C, 0xE0, 0xE7, 0x77, 0x30, 0xEF, 0x01, 0x50, 0x6F,
  0x06, 0x77, 0x71, 0x04, 0xF0, 0xA7, 0x0E, 0xE0, 0xC7, 0x77, 0x10, 0x9F, 0x04, 0x70, 0x8F, 0x03,
  0x77, 0x70, 0xEE, 0x0E, 0x71, 0x02, 0xF0, 0x97, 0x76, 0x04, 0xF0, 0x87, 0x20, 0xBF, 0x01, 0x77,
  0x50, 0x9F, 0x03, 0x72, 0x05, 0xF0, 0x77, 0x75, 0x0E, 0xE0, 0xC7, 0x40, 0xDE, 0x0D, 0x77, 0x40,
  0x4F, 0x07, 0x74, 0x07, 0xF0, 0x47, 0x73, 0x09, 0xF0, 0x17, 0x40, 0x1F, 0x0A, 0x77, 0x30, 0xEE,
  0x0A, 0x76, 0x0A, 0xF0, 0x17, 0x71, 0x04, 0xF0, 0x57, 0x60, 0x3F, 0x07, 0x77, 0x10, 0x9E, 0x0E,
  0x77, 0x10, 0xCE, 0x0D, 0x77, 0x10, 0xEE, 0x09, 0x77, 0x10, 0x6F, 0x04, 0x76, 0x04, 0xF0, 0x37,
  0x72, 0x0E, 0xE0, 0xB7, 0x60, 0x9E, 0x0D, 0x77, 0x30, 0x8F, 0x01, 0x75, 0x0E, 0xE0, 0x77, 0x73,
  0x02, 0xF0, 0x87, 0x40, 0x4F, 0x01, 0x77, 0x40, 0xBE, 0x0E, 0x74, 0x09, 0xE0, 0xB7, 0x75, 0x04,
  0xF0, 0x57, 0x30, 0xEE, 0x05, 0x77, 0x60, 0xDE, 0x0B, 0x72, 0x04, 0xE0, 0xE7, 0x77, 0x07, 0xF0,
  0x27, 0x10, 0x9E, 0x09, 0x77, 0x70, 0x1F, 0x08, 0x71, 0x0E, 0xE0, 0x37, 0x77, 0x10, 0xAE, 0x0E,
  0x70, 0x4E, 0x0D, 0x77, 0x72, 0x03, 0xF0, 0x56, 0x09, 0xE0, 0x77, 0x77, 0x30, 0xCE, 0x0B, 0x60,
  0xEE, 0x01, 0x77, 0x73, 0x06, 0xF0, 0x14, 0x03, 0xE0, 0xB7, 0x77, 0x50, 0xEE, 0x06, 0x40, 0x8E,
  0x05, 0x77, 0x75, 0x08, 0xE0, 0xB4, 0x0D, 0xD0, 0xE7, 0x77, 0x60, 0x2F, 0x01, 0x20, 0x3E, 0x09,
  0x77, 0x77, 0x0B, 0xE0, 0x62, 0x07, 0xE0, 0x37, 0x77, 0x70, 0x4E, 0x0B, 0x20, 0xCD, 0x0D, 0x77,
  0x77, 0x20, 0xDE, 0x10, 0x1E, 0x07, 0x77, 0x77, 0x20, 0x7E, 0x05, 0x06, 0xE0, 0x27, 0x77, 0x72,
  0x01, 0xE0, 0x90, 0xBD, 0x0B, 0x77, 0x77, 0x40, 0x9F, 0xD0, 0x57, 0x77, 0x74, 0x03, 0xFC, 0x0E,
  0x77, 0x77, 0x60, 0xCF, 0xB0, 0x97, 0x77, 0x76, 0x06, 0xFB, 0x04, 0x77, 0x77, 0x70, 0xEF, 0x90,
  0xD8, 0x0C, 0x00, 0x08, 0xF9, 0x08, 0x80, 0xC0, 0x00, 0x2F, 0x90, 0x28, 0x0C, 0x10, 0x0C, 0xE0,
  0xC8, 0x0C, 0x10, 0x01, 0xF0, 0x68, 0x0C, 0x10, 0x07, 0xF0, 0x18, 0x0C, 0x10, 0x0D, 0xE0, 0xA8,
  0x0C, 0x10, 0x04, 0xF0, 0x48, 0x0C, 0x10, 0x0B, 0xE0, 0xD8, 0x0C, 0x10, 0x01, 0xF0, 0x88, 0x0C,
  0x10, 0x08, 0xF0, 0x28, 0x0C, 0x10, 0x0E, 0xE0, 0xB8, 0x0C, 0x10, 0x07, 0xF0, 0x58, 0x0C, 0x00,
  0x01, 0x0E, 0xE0, 0xD8, 0x0C, 0x10, 0x0A, 0xF0, 0x68, 0x0C, 0x00, 0x07, 0xF0, 0xE8, 0x0C, 0x00,
  0x07, 0xF9, 0x06, 0x77, 0x77, 0x60, 0x40, 0xBF, 0x90, 0xD7, 0x77, 0x48, 0x90, 0x3E, 0xCA, 0x99,
  0x89, 0xBE, 0xFB, 0x03, 0x77, 0x74, 0x03, 0xFF, 0xC0, 0x87, 0x77, 0x50, 0x3F, 0xFB, 0x0A, 0x77,
  0x76, 0x03, 0xFF, 0xA0, 0x97, 0x77, 0x70, 0x3F, 0xF0, 0xE0, 0x67, 0x77, 0x71, 0x03, 0xFE, 0x09,
  0x01, 0x77, 0x77, 0x28, 0x93, 0x16, 0x9B, 0xCD, 0xEF, 0xED, 0xB9, 0x57, 0x77, 0x74,
  // "Ÿ" (U+0178)
  0x73, 0x85, 0x18, 0xDF, 0xEB, 0x47, 0x78, 0x53, 0xAE, 0xFD, 0x91, 0x77, 0x50, 0x20, 0xDE, 0x08,
  0x75, 0x06, 0xE0, 0xE0, 0x37, 0x74, 0x0A, 0xF9, 0x03, 0x73, 0x01, 0xF9, 0x0C, 0x77, 0x40, 0xEF,
  0x90, 0x87, 0x30, 0x5F, 0xA0, 0x27, 0x72, 0x01, 0xFA, 0x0A, 0x73, 0x07, 0xFA, 0x04, 0x77, 0x20,
  0x1F, 0xA0, 0x97, 0x30, 0x7F, 0xA0, 0x37, 0x73, 0x0E, 0xF9, 0x07, 0x73, 0x05, 0xFA, 0x01, 0x77,
  0x30, 0x9F, 0x90, 0x27, 0x40, 0xEF, 0x0B, 0x77, 0x40, 0x10, 0xCE, 0x06, 0x75, 0x04, 0xE0, 0xD0,
  0x27, 0x76, 0x84, 0x7D, 0xFE, 0xA3, 0x77, 0x85, 0x2A, 0xEF, 0xD8, 0x18, 0x0E, 0x86, 0x00, 0x9F,
  0x90, 0x47, 0x77, 0x70, 0x10, 0xEF, 0x09, 0x01, 0xF9, 0x0B, 0x77, 0x77, 0x07, 0xF9, 0x81, 0x10,
  0x9F, 0x90, 0x37, 0x77, 0x60, 0xEF, 0x08, 0x20, 0x1F, 0x90, 0xA7, 0x77, 0x50, 0x6F, 0x90, 0x13,
  0x08, 0xF9, 0x02, 0x77, 0x74, 0x0D, 0xF0, 0x84, 0x01, 0x0E, 0xF0, 0x97, 0x77, 0x30, 0x5F, 0x0E,
  0x01, 0x50, 0x8F, 0x0E, 0x01, 0x77, 0x72, 0x0C, 0xF0, 0x86, 0x01, 0x0E, 0xF0, 0x77, 0x77, 0x10,
  0x3F, 0x0E, 0x01, 0x70, 0x8F, 0x0E, 0x77, 0x71, 0x0B, 0xF0, 0x87, 0x10, 0x10, 0xEF, 0x06, 0x77,
  0x60, 0x2F, 0x0E, 0x01, 0x72, 0x08, 0xF0, 0xD7, 0x76, 0x09, 0xF0, 0x87, 0x30, 0x10, 0xEF, 0x05,
  0x77, 0x40, 0x1F, 0x0E, 0x01, 0x74, 0x08, 0xF0, 0xC7, 0x74, 0x08, 0xF0, 0x77, 0x50, 0x10, 0xEF,
  0x03, 0x77, 0x20, 0x10, 0xEE, 0x0E, 0x01, 0x76, 0x07, 0xF0, 0xA7, 0x72, 0x07, 0xF0, 0x77, 0x71,
  0x0E, 0xF0, 0x27, 0x71, 0x0E, 0xE0, 0xE7, 0x72, 0x07, 0xF0, 0x97, 0x70, 0x6F, 0x07, 0x77, 0x30,
  0xEF, 0x01, 0x76, 0x0D, 0xE0, 0xE7, 0x74, 0x07, 0xF0, 0x87, 0x50, 0x4F, 0x07, 0x77, 0x50, 0xEE,
  0x0E, 0x75, 0x0C, 0xE0, 0xE7, 0x76, 0x07, 0xF0, 0x77, 0x30, 0x3F, 0x07, 0x77, 0x70, 0xEE, 0x0D,
  0x73, 0x0A, 0xE0, 0xE7, 0x77, 0x10, 0x7F, 0x05, 0x71, 0x02, 0xF0, 0x77, 0x77, 0x20, 0xEE, 0x0C,
  0x71, 0x09, 0xE0, 0xE7, 0x77, 0x30, 0x6F, 0x04, 0x60, 0x1F, 0x06, 0x77, 0x74, 0x0D, 0xE0, 0xB6,
  0x08, 0xE0, 0xD7, 0x77, 0x50, 0x6F, 0x03, 0x50, 0xEE, 0x06, 0x77, 0x76, 0x0D, 0xE0, 0xA4, 0x07,
  0xE0, 0xD7, 0x77, 0x70, 0x6F, 0x02, 0x30, 0xDE, 0x06, 0x77, 0x77, 0x10, 0xDE, 0x08, 0x20, 0x5E,
  0x0D, 0x77, 0x77, 0x20, 0x6E, 0x82, 0xE1, 0x0D, 0xE0, 0x67, 0x77, 0x73, 0x0D, 0xE0, 0x70, 0x4E,
  0x0D, 0x77, 0x77, 0x40, 0x6E, 0x0E, 0x0C, 0xE0, 0x67, 0x77, 0x75, 0x0D, 0xFD, 0x0D, 0x77, 0x77,
  0x60, 0x5F, 0xD0, 0x57, 0x77, 0x77, 0x0D, 0xFB, 0x0D, 0x80, 0xC0, 0x00, 0x5F, 0xB0, 0x58, 0x0C,
  0x10, 0x0D, 0xF9, 0x0D, 0x80, 0xC2, 0x00, 0x5F, 0x90, 0x58, 0x0C, 0x30, 0x0E, 0xE0, 0xE8, 0x0C,
  0x40, 0x0D, 0xE0, 0xD8, 0x0C, 0x40, 0x0D, 0xE0, 0xD8, 0x0C, 0x40, 0x0D, 0xE0, 0xD8, 0x0C, 0x40,
  0x0D, 0xE0, 0xD8, 0x0C, 0x40, 0x0D, 0xE0, 0xD8, 0x0C, 0x40, 0x0D, 0xE0, 0xD8, 0x0C, 0x40, 0x0D,
  0xE0, 0xD8, 0x0C, 0x40, 0x0D, 0xE0, 0xD8, 0x0C, 0x40, 0x0D, 0xE0, 0xD8, 0x0C, 0x40, 0x0D, 0xE0,
  0xD8, 0x0C, 0x40, 0x0D, 0xE0, 0xD8, 0x0C, 0x40, 0x0D, 0xE0, 0xD8, 0x0C, 0x40, 0x0D, 0xE0, 0xD8,
  0x0C, 0x40, 0x0D, 0xE0, 0xD8, 0x0C, 0x40, 0x0D, 0xE0, 0xD8, 0x0C, 0x40, 0x0D, 0xE0, 0xD8, 0x0C,
  0x40, 0x0D, 0xE0, 0xD8, 0x0C, 0x40, 0x0D, 0xE0, 0xD8, 0x0C, 0x40, 0x0D, 0xE0, 0xD8, 0x0C, 0x40,
  0x0D, 0xE0, 0xD8, 0x0C, 0x40, 0x0D, 0xE0, 0xD8, 0x0C, 0x40, 0x0D, 0xE0, 0xD8, 0x0C, 0x40, 0x0D,
  0xE0, 0xD8, 0x0C, 0x40, 0x0D, 0xE0, 0xD7, 0x76,
  // "Ź" (U+0179)
  0x77, 0x73, 0x03, 0x80, 0x57, 0x01, 0x77, 0x76, 0x0C, 0xFA, 0x02, 0x77, 0x75, 0x05, 0xFA, 0x08,
  0x77, 0x76, 0x0D, 0xF9, 0x0B, 0x77, 0x76, 0x08, 0xF9, 0x0D, 0x01, 0x77, 0x75, 0x02, 0xF9, 0x0E,
  0x02, 0x77, 0x76, 0x0C, 0xF0, 0xE0, 0x37, 0x77, 0x60, 0x6F, 0x90, 0x47, 0x77, 0x60, 0x10, 0xEF,
  0x05, 0x77, 0x77, 0x0B, 0xF0, 0x57, 0x77, 0x70, 0x5F, 0x06, 0x77, 0x77, 0x01, 0x0E, 0xE0, 0x57,
  0x77, 0x71, 0x0B, 0xE0, 0x57, 0x77, 0x71, 0x08, 0xD0, 0xE0, 0x47, 0x77, 0x72, 0x0D, 0xC0, 0xC0,
  0x28, 0x0B, 0xE1, 0x00, 0xAF, 0xFF, 0xFE, 0x07, 0x20, 0xAF, 0xFF, 0xFE, 0x07, 0x20, 0xAF, 0xFF,
  0xFE, 0x07, 0x20, 0xAF, 0xFF, 0xFE, 0x07, 0x20, 0xAF, 0xFF, 0xFE, 0x07, 0x20, 0xAF, 0xFF, 0xFE,
  0x07, 0x20, 0x58, 0x0A, 0x68, 0xF9, 0x02, 0x77, 0x77, 0x07, 0xF0, 0x97, 0x77, 0x70, 0x10, 0xEE,
  0x0E, 0x01, 0x77, 0x77, 0x08, 0xF0, 0x77, 0x77, 0x70, 0x2F, 0x0D, 0x77, 0x77, 0x10, 0xAF, 0x06,
  0x77, 0x77, 0x03, 0xF0, 0xC7, 0x77, 0x71, 0x0C, 0xF0, 0x47, 0x77, 0x70, 0x5F, 0x0B, 0x77, 0x77,
  0x10, 0xDF, 0x02, 0x77, 0x77, 0x07, 0xF0, 0x97, 0x77, 0x70, 0x10, 0xEF, 0x01, 0x77, 0x77, 0x08,
  0xF0, 0x87, 0x77, 0x70, 0x2F, 0x0E, 0x77, 0x77, 0x10, 0xAF, 0x06, 0x77, 0x77, 0x03, 0xF0, 0xD7,
  0x77, 0x71, 0x0C, 0xF0, 0x47, 0x77, 0x70, 0x5F, 0x0B, 0x77, 0x77, 0x10, 0xDF, 0x03, 0x77, 0x77,
  0x07, 0xF0, 0xA7, 0x77, 0x70, 0x10, 0xEF, 0x02, 0x77, 0x77, 0x09, 0xF0, 0x87, 0x77, 0x70, 0x2F,
  0x0E, 0x01, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0x3F, 0x0D, 0x77, 0x77, 0x10, 0xCF, 0x05,
  0x77, 0x77, 0x05, 0xF0, 0xC7, 0x77, 0x71, 0x0D, 0xF0, 0x37, 0x77, 0x70, 0x7F, 0x0A, 0x77, 0x77,
  0x01, 0x0E, 0xF0, 0x27, 0x77, 0x70, 0x9F, 0x09, 0x77, 0x77, 0x02, 0xF0, 0xE0, 0x17, 0x77, 0x70,
  0xAF, 0x07, 0x77, 0x77, 0x03, 0xF0, 0xD7, 0x77, 0x71, 0x0C, 0xF0, 0x57, 0x77, 0x70, 0x5F, 0x0C,
  0x77, 0x77, 0x10, 0xDF, 0x04, 0x77, 0x77, 0x07, 0xF0, 0xB7, 0x77, 0x70, 0x10, 0xEF, 0x02, 0x77,
  0x77, 0x09, 0xF0, 0x97, 0x77, 0x70, 0x2F, 0x0E, 0x01, 0x77, 0x77, 0x0B, 0xF0, 0x87, 0x77, 0x70,
  0x4F, 0x0E, 0x77, 0x77, 0x10, 0xCF, 0x06, 0x77, 0x77, 0x05, 0xF0, 0xD7, 0x77, 0x71, 0x0D, 0xF0,
  0x47, 0x77, 0x70, 0x7F, 0x0B, 0x77, 0x77, 0x01, 0x0E, 0xF0, 0x37, 0x77, 0x70, 0x9F, 0x0A, 0x77,
  0x77, 0x02, 0xF9, 0x02, 0x77, 0x77, 0x0B, 0xF0, 0x87, 0x77, 0x70, 0x48, 0x0C, 0x0F, 0x00, 0x78,
  0x0C, 0x0F, 0x00, 0x78, 0x0C, 0x0F, 0x00, 0x78, 0x0C, 0x0F, 0x00, 0x78, 0x0C, 0x0F, 0x00, 0x78,
  0x0C, 0x0F, 0x00, 0x78, 0x0C, 0x0F, 0x07,
  // "ź" (U+017A)
  0x77, 0x73, 0x03, 0x80, 0x57, 0x01, 0x77, 0x76, 0x0C, 0xFA, 0x02, 0x77, 0x75, 0x05, 0xFA, 0x08,
  0x77, 0x76, 0x0D, 0xF9, 0x0B, 0x77, 0x76, 0x08, 0xF9, 0x0D, 0x01, 0x77, 0x75, 0x02, 0xF9, 0x0E,
  0x02, 0x77, 0x76, 0x0C, 0xF0, 0xE0, 0x37, 0x77, 0x60, 0x6F, 0x90, 0x47, 0x77, 0x60, 0x10, 0xEF,
  0x05, 0x77, 0x77, 0x0B, 0xF0, 0x57, 0x77, 0x70, 0x5F, 0x06, 0x77, 0x77, 0x01, 0x0E, 0xE0, 0x57,
  0x77, 0x71, 0x0B, 0xE0, 0x57, 0x77, 0x71, 0x08, 0xD0, 0xE0, 0x47, 0x77, 0x72, 0x0D, 0xC0, 0xC0,
  0x28, 0x0B, 0xE0, 0x00, 0x7F, 0xFF, 0xFF, 0x81, 0x20, 0x7F, 0xFF, 0xFF, 0x81, 0x20, 0x7F, 0xFF,
  0xFF, 0x81, 0x20, 0x7F, 0xFF, 0xFF, 0x81, 0x20, 0x7F, 0xFF, 0xFF, 0x81, 0x20, 0x7F, 0xFF, 0xFF,
  0x81, 0x20, 0x38, 0x0A, 0x68, 0x0D, 0xF9, 0x02, 0x77, 0x76, 0x04, 0xF9, 0x0C, 0x77, 0x76, 0x02,
  0x0E, 0xF0, 0xE0, 0x27, 0x77, 0x60, 0xCF, 0x90, 0x47, 0x77, 0x60, 0x9F, 0x90, 0x77, 0x77, 0x60,
  0x6F, 0x90, 0xA7, 0x77, 0x60, 0x3F, 0x90, 0xC7, 0x77, 0x60, 0x10, 0xDF, 0x0E, 0x02, 0x77, 0x76,
  0x0B, 0xF9, 0x04, 0x77, 0x76, 0x08, 0xF9, 0x07, 0x77, 0x76, 0x05, 0xF9, 0x0A, 0x77, 0x76, 0x02,
  0x0E, 0xF0, 0xC7, 0x77, 0x70, 0xDF, 0x0E, 0x02, 0x77, 0x76, 0x0A, 0xF9, 0x04, 0x77, 0x76, 0x07,
  0xF9, 0x07, 0x77, 0x76, 0x04, 0xF9, 0x0A, 0x77, 0x76, 0x01, 0x0E, 0xF0, 0xC7, 0x77, 0x70, 0xCF,
  0x0E, 0x02, 0x77, 0x76, 0x09, 0xF9, 0x04, 0x77, 0x76, 0x06, 0xF9, 0x07, 0x77, 0x76, 0x03, 0xF9,
  0x0A, 0x77, 0x76, 0x01, 0x0D, 0xF0, 0xC7, 0x77, 0x70, 0xBF, 0x0E, 0x02, 0x77, 0x76, 0x08, 0xF9,
  0x04, 0x77, 0x76, 0x04, 0xF9, 0x07, 0x77, 0x76, 0x02, 0x0E, 0xF0, 0xA7, 0x77, 0x70, 0xCF, 0x0D,
  0x77, 0x77, 0x0A, 0xF0, 0xE0, 0x27, 0x77, 0x60, 0x6F, 0x90, 0x47, 0x77, 0x60, 0x3F, 0x90, 0x77,
  0x77, 0x60, 0x10, 0xEF, 0x0A, 0x77, 0x77, 0x0B, 0xF0, 0xD7, 0x77, 0x70, 0x8F, 0x0E, 0x02, 0x77,
  0x76, 0x05, 0xF9, 0x04, 0x77, 0x76, 0x02, 0x0E, 0xF0, 0x77, 0x77, 0x70, 0xDF, 0x0E, 0x80, 0xA7,
  0x80, 0x70, 0xA8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C,
  0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x0E,
  // "Ż" (U+017B)
  0x77, 0x28, 0x61, 0x8C, 0xEE, 0xC7, 0x17, 0x77, 0x71, 0x03, 0x0E, 0xE0, 0xE0, 0x37, 0x77, 0x70,
  0xEF, 0x90, 0xD7, 0x77, 0x60, 0x5F, 0xB0, 0x57, 0x77, 0x50, 0x9F, 0xB0, 0x97, 0x77, 0x50, 0xAF,
  0xB0, 0xA7, 0x77, 0x50, 0x9F, 0xB0, 0x97, 0x77, 0x50, 0x5F, 0xB0, 0x57, 0x77, 0x60, 0xDF, 0x90,
  0xD7, 0x77, 0x70, 0x30, 0xEE, 0x0D, 0x02, 0x77, 0x77, 0x18, 0x61, 0x7C, 0xEE, 0xC7, 0x18, 0x0D,
  0xC2, 0x00, 0xAF, 0xFF, 0xFE, 0x07, 0x20, 0xAF, 0xFF, 0xFE, 0x07, 0x20, 0xAF, 0xFF, 0xFE, 0x07,
  0x20, 0xAF, 0xFF, 0xFE, 0x07, 0x20, 0xAF, 0xFF, 0xFE, 0x07, 0x20, 0xAF, 0xFF, 0xFE, 0x07, 0x20,
  0x58, 0x0A, 0x68, 0xF9, 0x02, 0x77, 0x77, 0x07, 0xF0, 0x97, 0x77, 0x70, 0x10, 0xEE, 0x0E, 0x01,
  0x77, 0x77, 0x08, 0xF0, 0x77, 0x77, 0x70, 0x2F, 0x0D, 0x77, 0x77, 0x10, 0xAF, 0x06, 0x77, 0x77,
  0x03, 0xF0, 0xC7, 0x77, 0x71, 0x0C, 0xF0, 0x47, 0x77, 0x70, 0x5F, 0x0B, 0x77, 0x77, 0x10, 0xDF,
  0x02, 0x77, 0x77, 0x07, 0xF0, 0x97, 0x77, 0x70, 0x10, 0xEF, 0x01, 0x77, 0x77, 0x08, 0xF0, 0x87,
  0x77, 0x70, 0x2F, 0x0E, 0x77, 0x77, 0x10, 0xAF, 0x06, 0x77, 0x77, 0x03, 0xF0, 0xD7, 0x77, 0x71,
  0x0C, 0xF0, 0x47, 0x77, 0x70, 0x5F, 0x0B, 0x77, 0x77, 0x10, 0xDF, 0x03, 0x77, 0x77, 0x07, 0xF0,
  0xA7, 0x77, 0x70, 0x10, 0xEF, 0x02, 0x77, 0x77, 0x09, 0xF0, 0x87, 0x77, 0x70, 0x2F, 0x0E, 0x01,
  0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0x3F, 0x0D, 0x77, 0x77, 0x10, 0xCF, 0x05, 0x77, 0x77,
  0x05, 0xF0, 0xC7, 0x77, 0x71, 0x0D, 0xF0, 0x37, 0x77, 0x70, 0x7F, 0x0A, 0x77, 0x77, 0x01, 0x0E,
  0xF0, 0x27, 0x77, 0x70, 0x9F, 0x09, 0x77, 0x77, 0x02, 0xF0, 0xE0, 0x17, 0x77, 0x70, 0xAF, 0x07,
  0x77, 0x77, 0x03, 0xF0, 0xD7, 0x77, 0x71, 0x0C, 0xF0, 0x57, 0x77, 0x70, 0x5F, 0x0C, 0x77, 0x77,
  0x10, 0xDF, 0x04, 0x77, 0x77, 0x07, 0xF0, 0xB7, 0x77, 0x70, 0x10, 0xEF, 0x02, 0x77, 0x77, 0x09,
  0xF0, 0x97, 0x77, 0x70, 0x2F, 0x0E, 0x01, 0x77, 0x77, 0x0B, 0xF0, 0x87, 0x77, 0x70, 0x4F, 0x0E,
  0x77, 0x77, 0x10, 0xCF, 0x06, 0x77, 0x77, 0x05, 0xF0, 0xD7, 0x77, 0x71, 0x0D, 0xF0, 0x47, 0x77,
  0x70, 0x7F, 0x0B, 0x77, 0x77, 0x01, 0x0E, 0xF0, 0x37, 0x77, 0x70, 0x9F, 0x0A, 0x77, 0x77, 0x02,
  0xF9, 0x02, 0x77, 0x77, 0x0B, 0xF0, 0x87, 0x77, 0x70, 0x48, 0x0C, 0x0F, 0x00, 0x78, 0x0C, 0x0F,
  0x00, 0x78, 0x0C, 0x0F, 0x00, 0x78, 0x0C, 0x0F, 0x00, 0x78, 0x0C, 0x0F, 0x00, 0x78, 0x0C, 0x0F,
  0x00, 0x78, 0x0C, 0x0F, 0x07,
  // "ż" (U+017C)
  0x77, 0x28, 0x61, 0x8C, 0xEE, 0xC7, 0x17, 0x77, 0x71, 0x03, 0x0E, 0xE0, 0xE0, 0x37, 0x77, 0x70,
  0xEF, 0x90, 0xD7, 0x77, 0x60, 0x5F, 0xB0, 0x57, 0x77, 0x50, 0x9F, 0xB0, 0x97, 0x77, 0x50, 0xAF,
  0xB0, 0xA7, 0x77, 0x50, 0x9F, 0xB0, 0x97, 0x77, 0x50, 0x5F, 0xB0, 0x57, 0x77, 0x60, 0xDF, 0x90,
  0xD7, 0x77, 0x70, 0x30, 0xEE, 0x0D, 0x02, 0x77, 0x77, 0x18, 0x61, 0x7C, 0xEE, 0xC7, 0x18, 0x0D,
  0xC1, 0x00, 0x7F, 0xFF, 0xFF, 0x81, 0x20, 0x7F, 0xFF, 0xFF, 0x81, 0x20, 0x7F, 0xFF, 0xFF, 0x81,
  0x20, 0x7F, 0xFF, 0xFF, 0x81, 0x20, 0x7F, 0xFF, 0xFF, 0x81, 0x20, 0x7F, 0xFF, 0xFF, 0x81, 0x20,
  0x38, 0x0A, 0x68, 0x0D, 0xF9, 0x02, 0x77, 0x76, 0x04, 0xF9, 0x0C, 0x77, 0x76, 0x02, 0x0E, 0xF0,
  0xE0, 0x27, 0x77, 0x60, 0xCF, 0x90, 0x47, 0x77, 0x60, 0x9F, 0x90, 0x77, 0x77, 0x60, 0x6F, 0x90,
  0xA7, 0x77, 0x60, 0x3F, 0x90, 0xC7, 0x77, 0x60, 0x10, 0xDF, 0x0E, 0x02, 0x77, 0x76, 0x0B, 0xF9,
  0x04, 0x77, 0x76, 0x08, 0xF9, 0x07, 0x77, 0x76, 0x05, 0xF9, 0x0A, 0x77, 0x76, 0x02, 0x0E, 0xF0,
  0xC7, 0x77, 0x70, 0xDF, 0x0E, 0x02, 0x77, 0x76, 0x0A, 0xF9, 0x04, 0x77, 0x76, 0x07, 0xF9, 0x07,
  0x77, 0x76, 0x04, 0xF9, 0x0A, 0x77, 0x76, 0x01, 0x0E, 0xF0, 0xC7, 0x77, 0x70, 0xCF, 0x0E, 0x02,
  0x77, 0x76, 0x09, 0xF9, 0x04, 0x77, 0x76, 0x06, 0xF9, 0x07, 0x77, 0x76, 0x03, 0xF9, 0x0A, 0x77,
  0x76, 0x01, 0x0D, 0xF0, 0xC7, 0x77, 0x70, 0xBF, 0x0E, 0x02, 0x77, 0x76, 0x08, 0xF9, 0x04, 0x77,
  0x76, 0x04, 0xF9, 0x07, 0x77, 0x76, 0x02, 0x0E, 0xF0, 0xA7, 0x77, 0x70, 0xCF, 0x0D, 0x77, 0x77,
  0x0A, 0xF0, 0xE0, 0x27, 0x77, 0x60, 0x6F, 0x90, 0x47, 0x77, 0x60, 0x3F, 0x90, 0x77, 0x77, 0x60,
  0x10, 0xEF, 0x0A, 0x77, 0x77, 0x0B, 0xF0, 0xD7, 0x77, 0x70, 0x8F, 0x0E, 0x02, 0x77, 0x76, 0x05,
  0xF9, 0x04, 0x77, 0x76, 0x02, 0x0E, 0xF0, 0x77, 0x77, 0x70, 0xDF, 0x0E, 0x80, 0xA7, 0x80, 0x70,
  0xA8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x00,
  0xE8, 0x0C, 0x0F, 0x00, 0xE8, 0x0C, 0x0F, 0x0E,
  // "Ž" (U+017D)
  0x40, 0x18, 0x01, 0x70, 0x47, 0x74, 0x05, 0x80, 0x17, 0x01, 0x60, 0x2E, 0x08, 0x77, 0x10, 0x10,
  0xAE, 0x02, 0x70, 0x8E, 0x0C, 0x01, 0x75, 0x03, 0x0D, 0xE0, 0x87, 0x20, 0x9E, 0x0D, 0x03, 0x73,
  0x05, 0x0E, 0xE0, 0x87, 0x40, 0xAF, 0x05, 0x71, 0x07, 0xF0, 0x97, 0x60, 0xBF, 0x06, 0x60, 0x9F,
  0x09, 0x77, 0x10, 0xCF, 0x07, 0x40, 0xAF, 0x0A, 0x77, 0x20, 0x10, 0xDF, 0x06, 0x20, 0xAF, 0x0C,
  0x77, 0x40, 0x20, 0xEF, 0x06, 0x0B, 0xF0, 0xD0, 0x17, 0x75, 0x04, 0xFF, 0x90, 0xD0, 0x17, 0x77,
  0x05, 0xFE, 0x0E, 0x02, 0x77, 0x72, 0x08, 0xFD, 0x05, 0x77, 0x74, 0x0C, 0xFB, 0x08, 0x77, 0x75,
  0x02, 0x0E, 0xF9, 0x0D, 0x77, 0x77, 0x07, 0xF9, 0x04, 0x80, 0xBD, 0x70, 0x0A, 0xFF, 0xFF, 0xE0,
  0x72, 0x0A, 0xFF, 0xFF, 0xE0, 0x72, 0x0A, 0xFF, 0xFF, 0xE0, 0x72, 0x0A, 0xFF, 0xFF, 0xE0, 0x72,
  0x0A, 0xFF, 0xFF, 0xE0, 0x72, 0x0A, 0xFF, 0xFF, 0xE0, 0x72, 0x05, 0x80, 0xA6, 0x8F, 0x90, 0x27,
  0x77, 0x70, 0x7F, 0x09, 0x77, 0x77, 0x01, 0x0E, 0xE0, 0xE0, 0x17, 0x77, 0x70, 0x8F, 0x07, 0x77,
  0x77, 0x02, 0xF0, 0xD7, 0x77, 0x71, 0x0A, 0xF0, 0x67, 0x77, 0x70, 0x3F, 0x0C, 0x77, 0x77, 0x10,
  0xCF, 0x04, 0x77, 0x77, 0x05, 0xF0, 0xB7, 0x77, 0x71, 0x0D, 0xF0, 0x27, 0x77, 0x70, 0x7F, 0x09,
  0x77, 0x77, 0x01, 0x0E, 0xF0, 0x17, 0x77, 0x70, 0x8F, 0x08, 0x77, 0x77, 0x02, 0xF0, 0xE7, 0x77,
  0x71, 0x0A, 0xF0, 0x67, 0x77, 0x70, 0x3F, 0x0D, 0x77, 0x77, 0x10, 0xCF, 0x04, 0x77, 0x77, 0x05,
  0xF0, 0xB7, 0x77, 0x71, 0x0D, 0xF0, 0x37, 0x77, 0x70, 0x7F, 0x0A, 0x77, 0x77, 0x01, 0x0E, 0xF0,
  0x27, 0x77, 0x70, 0x9F, 0x08, 0x77, 0x77, 0x02, 0xF0, 0xE0, 0x17, 0x77, 0x70, 0xAF, 0x07, 0x77,
  0x77, 0x03, 0xF0, 0xD7, 0x77, 0x71, 0x0C, 0xF0, 0x57, 0x77, 0x70, 0x5F, 0x0C, 0x77, 0x77, 0x10,
  0xDF, 0x03, 0x77, 0x77, 0x07, 0xF0, 0xA7, 0x77, 0x70, 0x10, 0xEF, 0x02, 0x77, 0x77, 0x09, 0xF0,
  0x97, 0x77, 0x70, 0x2F, 0x0E, 0x01, 0x77, 0x77, 0x0A, 0xF0, 0x77, 0x77, 0x70, 0x3F, 0x0D, 0x77,
  0x77, 0x10, 0xCF, 0x05, 0x77, 0x77, 0x05, 0xF0, 0xC7, 0x77, 0x71, 0x0D, 0xF0, 0x47, 0x77, 0x70,
  0x7F, 0x0B, 0x77, 0x77, 0x01, 0x0E, 0xF0, 0x27, 0x77, 0x70, 0x9F, 0x09, 0x77, 0x77, 0x02, 0xF0,
  0xE0, 0x17, 0x77, 0x70, 0xBF, 0x08, 0x77, 0x77, 0x04, 0xF0, 0xE7, 0x77, 0x71, 0x0C, 0xF0, 0x67,
  0x77, 0x70, 0x5F, 0x0D, 0x77, 0x77, 0x10, 0xDF, 0x04, 0x77, 0x77, 0x07, 0xF0, 0xB7, 0x77, 0x70,
  0x10, 0xEF, 0x03, 0x77, 0x77, 0x09, 0xF0, 0xA7, 0x77, 0x70, 0x2F, 0x90, 0x27, 0x77, 0x70, 0xBF,
  0x08, 0x77, 0x77, 0x04, 0x80, 0xC0, 0xF0, 0x07, 0x80, 0xC0, 0xF0, 0x07, 0x80, 0xC0, 0xF0, 0x07,
  0x80, 0xC0, 0xF0, 0x07, 0x80, 0xC0, 0xF0, 0x07, 0x80, 0xC0, 0xF0, 0x07, 0x80, 0xC0, 0xF0, 0x70,
  // "ž" (U+017E)
  0x40, 0x18, 0x01, 0x70, 0x47, 0x74, 0x05, 0x80, 0x17, 0x01, 0x60, 0x2E, 0x08, 0x77, 0x10, 0x10,
  0xAE, 0x02, 0x70, 0x8E, 0x0C, 0x01, 0x75, 0x03, 0x0D, 0xE0, 0x87, 0x20, 0x9E, 0x0D, 0x03, 0x73,
  0x05, 0x0E, 0xE0, 0x87, 0x40, 0xAF, 0x05, 0x71, 0x07, 0xF0, 0x97, 0x60, 0xBF, 0x06, 0x60, 0x9F,
  0x09, 0x77, 0x10, 0xCF, 0x07, 0x40, 0xAF, 0x0A, 0x77, 0x20, 0x10, 0xDF, 0x06, 0x20, 0xAF, 0x0C,
  0x77, 0x40, 0x20, 0xEF, 0x06, 0x0B, 0xF0, 0xD0, 0x17, 0x75, 0x04, 0xFF, 0x90, 0xD0, 0x17, 0x77,
  0x05, 0xFE, 0x0E, 0x02, 0x77, 0x72, 0x08, 0xFD, 0x05, 0x77, 0x74, 0x0C, 0xFB, 0x08, 0x77, 0x75,
  0x02, 0x0E, 0xF9, 0x0D, 0x77, 0x77, 0x07, 0xF9, 0x04, 0x80, 0xBD, 0x60, 0x07, 0xFF, 0xFF, 0xF8,
  0x12, 0x07, 0xFF, 0xFF, 0xF8, 0x12, 0x07, 0xFF, 0xFF, 0xF8, 0x12, 0x07, 0xFF, 0xFF, 0xF8, 0x12,
  0x07, 0xFF, 0xFF, 0xF8, 0x12, 0x07, 0xFF, 0xFF, 0xF8, 0x12, 0x03, 0x80, 0xA6, 0x80, 0xDF, 0x90,
  0x27, 0x77, 0x60, 0x4F, 0x90, 0xC7, 0x77, 0x60, 0x20, 0xEF, 0x0E, 0x02, 0x77, 0x76, 0x0C, 0xF9,
  0x04, 0x77, 0x76, 0x09, 0xF9, 0x07, 0x77, 0x76, 0x06, 0xF9, 0x0A, 0x77, 0x76, 0x03, 0xF9, 0x0C,
  0x77, 0x76, 0x01, 0x0D, 0xF0, 0xE0, 0x27, 0x77, 0x60, 0xBF, 0x90, 0x47, 0x77, 0x60, 0x8F, 0x90,
  0x77, 0x77, 0x60, 0x5F, 0x90, 0xA7, 0x77, 0x60, 0x20, 0xEF, 0x0C, 0x77, 0x77, 0x0D, 0xF0, 0xE0,
  0x27, 0x77, 0x60, 0xAF, 0x90, 0x47, 0x77, 0x60, 0x7F, 0x90, 0x77, 0x77, 0x60, 0x4F, 0x90, 0xA7,
  0x77, 0x60, 0x10, 0xEF, 0x0C, 0x77, 0x77, 0x0C, 0xF0, 0xE0, 0x27, 0x77, 0x60, 0x9F, 0x90, 0x47,
  0x77, 0x60, 0x6F, 0x90, 0x77, 0x77, 0x60, 0x3F, 0x90, 0xA7, 0x77, 0x60, 0x10, 0xDF, 0x0C, 0x77,
  0x77, 0x0B, 0xF0, 0xE0, 0x27, 0x77, 0x60, 0x8F, 0x90, 0x47, 0x77, 0x60, 0x4F, 0x90, 0x77, 0x77,
  0x60, 0x20, 0xEF, 0x0A, 0x77, 0x77, 0x0C, 0xF0, 0xD7, 0x77, 0x70, 0xAF, 0x0E, 0x02, 0x77, 0x76,
  0x06, 0xF9, 0x04, 0x77, 0x76, 0x03, 0xF9, 0x07, 0x77, 0x76, 0x01, 0x0E, 0xF0, 0xA7, 0x77, 0x70,
  0xBF, 0x0D, 0x77, 0x77, 0x08, 0xF0, 0xE0, 0x27, 0x77, 0x60, 0x5F, 0x90, 0x47, 0x77, 0x60, 0x20,
  0xEF, 0x07, 0x77, 0x77, 0x0D, 0xF0, 0xE8, 0x0A, 0x78, 0x07, 0x0A, 0x80, 0xC0, 0xF0, 0x0E, 0x80,
  0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80, 0xC0, 0xF0, 0x0E, 0x80,
  0xC0, 0xF0, 0xE0,
  // "ſ" (U+017F)
  0x75, 0x89, 0x63, 0x69, 0xBC, 0xDE, 0xFE, 0xED, 0xB9, 0x75, 0x27, 0x58, 0x13, 0x8E, 0xFF, 0xA8,
  0x1D, 0x91, 0x70, 0x20, 0xBF, 0xFF, 0x01, 0x60, 0x8F, 0xFF, 0x90, 0xB5, 0x01, 0x0C, 0xFF, 0xFA,
  0x06, 0x50, 0xCF, 0xFF, 0xB0, 0x14, 0x09, 0xFD, 0x85, 0xCA, 0x98, 0x9A, 0xCD, 0x0C, 0x40, 0x3F,
  0xB0, 0xB0, 0x47, 0x28, 0x32, 0x59, 0xE7, 0x40, 0xAF, 0x90, 0xE0, 0x47, 0x75, 0x01, 0xF9, 0x0E,
  0x02, 0x77, 0x60, 0x5F, 0x90, 0x57, 0x77, 0x09, 0xF0, 0xD7, 0x77, 0x10, 0xCF, 0x07, 0x77, 0x71,
  0x0E, 0xF0, 0x37, 0x77, 0x1F, 0x90, 0x17, 0x77, 0x01, 0xF0, 0xE7, 0x77, 0x10, 0x1F, 0x0D, 0x77,
  0x71, 0x01, 0xF0, 0xC7, 0x77, 0x10, 0x1F, 0x0C, 0x77, 0x71, 0x01, 0xF0, 0xC7, 0x77, 0x10, 0x1F,
  0x0C, 0x77, 0x71, 0x01, 0xF0, 0xC7, 0x77, 0x10, 0x1F, 0x0C, 0x77, 0x71, 0x01, 0xF0, 0xC7, 0x77,
  0x10, 0x1F, 0x0C, 0x77, 0x71, 0x01, 0xF0, 0xC7, 0x77, 0x10, 0x1F, 0x0C, 0x77, 0x71, 0x01, 0xF0,
  0xC7, 0x77, 0x10, 0x1F, 0x0C, 0x77, 0x71, 0x01, 0xF0, 0xC7, 0x77, 0x10, 0x1F, 0x0C, 0x77, 0x71,
  0x01, 0xF0, 0xC7, 0x77, 0x10, 0x1F, 0x0C, 0x77, 0x71, 0x01, 0xF0, 0xC7, 0x77, 0x10, 0x1F, 0x0C,
  0x77, 0x71, 0x01, 0xF0, 0xC7, 0x77, 0x10, 0x1F, 0x0C, 0x77, 0x71, 0x01, 0xF0, 0xC7, 0x77, 0x10,
  0x1F, 0x0C, 0x77, 0x71, 0x01, 0xF0, 0xC7, 0x77, 0x10, 0x1F, 0x0C, 0x77, 0x71, 0x01, 0xF0, 0xC7,
  0x77, 0x10, 0x1F, 0x0C, 0x77, 0x71, 0x01, 0xF0, 0xC7, 0x77, 0x10, 0x1F, 0x0C, 0x77, 0x71, 0x01,
  0xF0, 0xC7, 0x77, 0x10, 0x1F, 0x0C, 0x77, 0x71, 0x01, 0xF0, 0xC7, 0x77, 0x10, 0x1F, 0x0C, 0x77,
  0x71, 0x01, 0xF0, 0xC7, 0x77, 0x10, 0x1F, 0x0C, 0x77, 0x71, 0x01, 0xF0, 0xC7, 0x77, 0x10, 0x1F,
  0x0C, 0x77, 0x71, 0x01, 0xF0, 0xC7, 0x77, 0x10, 0x1F, 0x0C, 0x77, 0x71, 0x01, 0xF0, 0xC7, 0x77,
  0x10, 0x1F, 0x0C, 0x77, 0x71, 0x01, 0xF0, 0xC7, 0x77, 0x10, 0x1F, 0x0C, 0x77, 0x71, 0x01, 0xF0,
  0xC7, 0x77, 0x10, 0x1F, 0x0C, 0x77, 0x71, 0x01, 0xF0, 0xC7, 0x77, 0x10, 0x1F, 0x0C, 0x77, 0x71,
  0x01, 0xF0, 0xC7, 0x77, 0x10, 0x1F, 0x0C, 0x77, 0x71, 0x01, 0xF0, 0xC7, 0x77, 0x10, 0x1F, 0x0C,
  0x77, 0x71, 0x01, 0xF0, 0xC7, 0x77, 0x10,
  // "Ω" (U+03A9)
  0x77, 0x58, 0x42, 0x69, 0xBD, 0xEA, 0x84, 0xED, 0xC9, 0x73, 0x77, 0x77, 0x78, 0x12, 0x8D, 0xFF,
  0x81, 0xE9, 0x37, 0x77, 0x72, 0x02, 0x0A, 0xFF, 0xE0, 0xB0, 0x37, 0x77, 0x60, 0x7F, 0xFF, 0xB0,
  0x87, 0x77, 0x40, 0xBF, 0xFF, 0xD0, 0xC0, 0x17, 0x77, 0x01, 0x0C, 0xFF, 0xFF, 0x0D, 0x01, 0x77,
  0x60, 0xCF, 0xD8, 0x5C, 0xA9, 0x89, 0xBE, 0xFC, 0x0D, 0x01, 0x77, 0x40, 0xBF, 0xB0, 0xB0, 0x57,
  0x18, 0x13, 0x8E, 0xFA, 0x0B, 0x77, 0x30, 0x7F, 0xA0, 0xD0, 0x47, 0x50, 0x10, 0xAF, 0xA0, 0x67,
  0x71, 0x02, 0xFA, 0x0B, 0x01, 0x77, 0x10, 0x7F, 0xA0, 0x27, 0x70, 0xAF, 0x90, 0xC7, 0x74, 0x08,
  0xF9, 0x0A, 0x76, 0x03, 0xF9, 0x0E, 0x01, 0x77, 0x50, 0xBF, 0x90, 0x37, 0x50, 0xAF, 0x90, 0x57,
  0x76, 0x02, 0xF9, 0x09, 0x74, 0x02, 0xF9, 0x0B, 0x77, 0x71, 0x0A, 0xF9, 0x01, 0x73, 0x07, 0xF9,
  0x04, 0x77, 0x71, 0x02, 0xF9, 0x06, 0x73, 0x0C, 0xF0, 0xD7, 0x77, 0x30, 0xCF, 0x0B, 0x72, 0x01,
  0xF9, 0x07, 0x77, 0x73, 0x07, 0xF9, 0x72, 0x05, 0xF9, 0x02, 0x77, 0x73, 0x02, 0xF9, 0x04, 0x71,
  0x09, 0xF0, 0xE7, 0x77, 0x50, 0xEF, 0x07, 0x71, 0x0C, 0xF0, 0xA7, 0x77, 0x50, 0xAF, 0x0B, 0x71,
  0x0E, 0xF0, 0x77, 0x77, 0x50, 0x7F, 0x0D, 0x70, 0x2F, 0x90, 0x47, 0x77, 0x50, 0x5F, 0x97, 0x04,
  0xF9, 0x02, 0x77, 0x75, 0x02, 0xF9, 0x02, 0x60, 0x5F, 0x97, 0x77, 0x60, 0x1F, 0x90, 0x36, 0x06,
  0xF0, 0xE7, 0x77, 0x70, 0xEF, 0x05, 0x60, 0x7F, 0x0D, 0x77, 0x77, 0x0D, 0xF0, 0x66, 0x08, 0xF0,
  0xC7, 0x77, 0x70, 0xCF, 0x06, 0x60, 0x8F, 0x0B, 0x77, 0x77, 0x0B, 0xF0, 0x76, 0x09, 0xF0, 0xB7,
  0x77, 0x70, 0xBF, 0x07, 0x60, 0x8F, 0x0A, 0x77, 0x77, 0x0B, 0xF0, 0x76, 0x08, 0xF0, 0xA7, 0x77,
  0x70, 0xAF, 0x06, 0x60, 0x7F, 0x0B, 0x77, 0x77, 0x0B, 0xF0, 0x66, 0x07, 0xF0, 0xB7, 0x77, 0x70,
  0xBF, 0x05, 0x60, 0x6F, 0x0C, 0x77, 0x77, 0x0C, 0xF0, 0x46, 0x04, 0xF0, 0xC7, 0x77, 0x70, 0xCF,
  0x03, 0x60, 0x2F, 0x0D, 0x77, 0x77, 0x0D, 0xF0, 0x16, 0x01, 0xF9, 0x77, 0x77, 0xF9, 0x71, 0x0E,
  0xF0, 0x17, 0x77, 0x50, 0x1F, 0x0D, 0x71, 0x0C, 0xF0, 0x37, 0x77, 0x50, 0x2F, 0x0B, 0x71, 0x09,
  0xF0, 0x57, 0x77, 0x50, 0x5F, 0x08, 0x71, 0x06, 0xF0, 0x87, 0x77, 0x50, 0x7F, 0x05, 0x71, 0x02,
  0xF0, 0xB7, 0x77, 0x50, 0xAF, 0x02, 0x72, 0x0E, 0xE0, 0xE7, 0x77, 0x50, 0xDE, 0x0E, 0x73, 0x0A,
  0xF0, 0x27, 0x77, 0x30, 0x1F, 0x09, 0x73, 0x05, 0xF0, 0x67, 0x77, 0x30, 0x5F, 0x05, 0x73, 0x01,
  0xF0, 0xA7, 0x77, 0x30, 0x9F, 0x75, 0x0B, 0xE0, 0xE7, 0x77, 0x30, 0xDE, 0x0B, 0x75, 0x05, 0xF0,
  0x57, 0x77, 0x10, 0x3F, 0x04, 0x76, 0x0E, 0xE0, 0xB7, 0x77, 0x10, 0x8E, 0x0D, 0x77, 0x08, 0xF0,
  0x17, 0x77, 0x0E, 0xE0, 0x87, 0x70, 0x10, 0xEE, 0x08, 0x77, 0x60, 0x5F, 0x01, 0x77, 0x10, 0x8F,
  0x01, 0x77, 0x50, 0xDE, 0x08, 0x77, 0x20, 0x10, 0xEE, 0x09, 0x77, 0x40, 0x6E, 0x0E, 0x01, 0x77,
  0x30, 0x7F, 0x03, 0x77, 0x20, 0x10, 0xEE, 0x07, 0x77, 0x50, 0xCE, 0x0D, 0x77, 0x20, 0xBE, 0x0C,
  0x77, 0x60, 0x3F, 0x08, 0x77, 0x06, 0xF0, 0x37, 0x77, 0x06, 0xF0, 0x57, 0x50, 0x4F, 0x05, 0x77,
  0x72, 0x08, 0xF0, 0x37, 0x30, 0x30, 0xEE, 0x07, 0x75, 0x03, 0xFF, 0xD0, 0xE0, 0x27, 0x10, 0x20,
  0xEF, 0xFD, 0x00, 0x3F, 0xFE, 0x06, 0x71, 0x06, 0xFF, 0xE0, 0x03, 0xFF, 0xE0, 0x67, 0x10, 0x6F,
  0xFE, 0x00, 0x3F, 0xFE, 0x06, 0x71, 0x06, 0xFF, 0xE0, 0x03, 0xFF, 0xE0, 0x67, 0x10, 0x6F, 0xFE,
  0x00, 0x3F, 0xFE, 0x06, 0x71, 0x06, 0xFF, 0xE0, 0x30, 0x18, 0x0A, 0x08, 0x03, 0x71, 0x03, 0x80,
  0xA0, 0x80, 0x10,
  // "μ" (U+03BC)
  0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0,
  0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77,
  0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F,
  0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03,
  0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7,
  0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20,
  0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C,
  0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0,
  0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77,
  0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F,
  0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x0C, 0x03,
  0xF0, 0xD7, 0x77, 0x20, 0x5F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x5F, 0x0C, 0x03, 0xF0, 0xD7,
  0x77, 0x20, 0x6F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0x7F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20,
  0x9F, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0xBF, 0x0C, 0x03, 0xF0, 0xD7, 0x77, 0x20, 0xEF, 0x0C,
  0x03, 0xF0, 0xE7, 0x77, 0x10, 0x1F, 0x90, 0xC0, 0x3F, 0x97, 0x77, 0x10, 0x6F, 0x90, 0xC0, 0x3F,
  0x90, 0x27, 0x77, 0x0B, 0xF9, 0x0C, 0x03, 0xF9, 0x05, 0x77, 0x60, 0x1F, 0xA0, 0xC0, 0x3F, 0x90,
  0xA7, 0x76, 0x08, 0xFA, 0x0C, 0x03, 0xFA, 0x01, 0x77, 0x40, 0x10, 0xEF, 0xA0, 0xC0, 0x3F, 0xA0,
  0x97, 0x74, 0x0A, 0xFB, 0x0C, 0x03, 0xFB, 0x04, 0x77, 0x20, 0x9F, 0xC0, 0xC0, 0x3F, 0xC0, 0x57,
  0x60, 0x10, 0xBF, 0xD0, 0xC0, 0x3F, 0xD0, 0xC0, 0x47, 0x20, 0x30, 0x9E, 0x0D, 0x0E, 0xE0, 0xC0,
  0x3F, 0xF9, 0x86, 0xCA, 0x98, 0x9A, 0xCE, 0xF8, 0x1E, 0x2A, 0xE0, 0xC0, 0x3F, 0xFF, 0xFA, 0x81,
  0x50, 0x7E, 0x0C, 0x03, 0xFF, 0xFF, 0x90, 0x62, 0x05, 0xE0, 0xC0, 0x3F, 0xFF, 0xE0, 0xE0, 0x53,
  0x02, 0xE0, 0xC0, 0x3F, 0xFF, 0xD0, 0xB0, 0x25, 0x0E, 0xD0, 0xC0, 0x3F, 0x81, 0xE9, 0xEF, 0xE8,
  0x1E, 0xA4, 0x70, 0xCD, 0x0C, 0x03, 0xF0, 0xD2, 0x89, 0x34, 0x8A, 0xCE, 0xEF, 0xEE, 0xCA, 0x84,
  0x77, 0x30, 0x3F, 0x0D, 0x77, 0x77, 0x40, 0x3F, 0x0D, 0x77, 0x77, 0x40, 0x3F, 0x0D, 0x77, 0x77,
  0x40, 0x3F, 0x0D, 0x77, 0x77, 0x40, 0x3F, 0x0D, 0x77, 0x77, 0x40, 0x3F, 0x0D, 0x77, 0x77, 0x40,
  0x3F, 0x0D, 0x77, 0x77, 0x40, 0x3F, 0x0D, 0x77, 0x77, 0x40, 0x3F, 0x0D, 0x77, 0x77, 0x40, 0x3F,
  0x0D, 0x77, 0x77, 0x40, 0x3F, 0x0D, 0x77, 0x77, 0x40, 0x3F, 0x0D, 0x77, 0x77, 0x40, 0x3F, 0x0D,
  0x77, 0x77, 0x40, 0x3F, 0x0D, 0x77, 0x77, 0x40, 0x3F, 0x0D, 0x77, 0x77, 0x40, 0x3F, 0x0D, 0x77,
  0x77, 0x40, 0x3F, 0x0D, 0x77, 0x77, 0x40, 0x3F, 0x0D, 0x77, 0x77, 0x40, 0x3F, 0x0D, 0x77, 0x77,
  0x40, 0x3F, 0x0D, 0x77, 0x77, 0x40, 0x3F, 0x0D, 0x77, 0x77, 0x40,
  // "π" (U+03C0)
  0x50, 0x50, 0xD8, 0x0C, 0x4F, 0x09, 0x30, 0x60, 0xD8, 0x0C, 0x6F, 0x82, 0x90, 0x6D, 0x80, 0xD0,
  0xF0, 0x90, 0xA8, 0x0D, 0x2F, 0x09, 0x0A, 0x80, 0xD2, 0xF0, 0x90, 0xA8, 0x0D, 0x2F, 0x09, 0x05,
  0x80, 0x58, 0x0E, 0xF8, 0x09, 0x08, 0x0D, 0xF0, 0x98, 0x04, 0x80, 0x47, 0x30, 0xDF, 0x75, 0x0A,
  0xF0, 0x17, 0x75, 0x0D, 0xF7, 0x50, 0xAF, 0x01, 0x77, 0x50, 0xDF, 0x75, 0x0A, 0xF0, 0x17, 0x75,
  0x0D, 0xF7, 0x50, 0xAF, 0x01, 0x77, 0x50, 0xDF, 0x75, 0x0A, 0xF0, 0x17, 0x75, 0x0D, 0xF7, 0x50,
  0xAF, 0x01, 0x77, 0x50, 0xDF, 0x75, 0x0A, 0xF0, 0x17, 0x75, 0x0D, 0xF7, 0x50, 0xAF, 0x01, 0x77,
  0x50, 0xDF, 0x75, 0x0A, 0xF0, 0x17, 0x75, 0x0D, 0xF7, 0x50, 0xAF, 0x01, 0x77, 0x50, 0xDF, 0x75,
  0x0A, 0xF0, 0x17, 0x75, 0x0D, 0xF7, 0x50, 0xAF, 0x01, 0x77, 0x50, 0xDF, 0x75, 0x0A, 0xF0, 0x17,
  0x75, 0x0D, 0xF7, 0x50, 0xAF, 0x01, 0x77, 0x50, 0xDF, 0x75, 0x0A, 0xF0, 0x17, 0x75, 0x0D, 0xF7,
  0x50, 0xAF, 0x01, 0x77, 0x50, 0xDF, 0x75, 0x0A, 0xF0, 0x17, 0x75, 0x0D, 0xF7, 0x50, 0xAF, 0x01,
  0x77, 0x50, 0xDF, 0x75, 0x0A, 0xF0, 0x17, 0x75, 0x0D, 0xF7, 0x50, 0xAF, 0x01, 0x77, 0x50, 0xDF,
  0x75, 0x0A, 0xF0, 0x17, 0x75, 0x0D, 0xF7, 0x50, 0xAF, 0x01, 0x77, 0x50, 0xDF, 0x75, 0x0A, 0xF0,
  0x17, 0x75, 0x0D, 0xF7, 0x50, 0xAF, 0x01, 0x77, 0x50, 0xDF, 0x75, 0x0A, 0xF0, 0x17, 0x75, 0x0D,
  0xF7, 0x50, 0xAF, 0x01, 0x77, 0x50, 0xDF, 0x75, 0x0A, 0xF0, 0x17, 0x75, 0x0D, 0xF7, 0x50, 0xAF,
  0x01, 0x77, 0x50, 0xDF, 0x75, 0x0A, 0xF0, 0x17, 0x75, 0x0D, 0xF7, 0x50, 0xAF, 0x01, 0x77, 0x50,
  0xDF, 0x75, 0x0A, 0xF0, 0x27, 0x75, 0x0D, 0xF7, 0x50, 0xAF, 0x03, 0x77, 0x50, 0xDF, 0x75, 0x09,
  0xF0, 0x67, 0x75, 0x0D, 0xF7, 0x50, 0x7F, 0x0C, 0x77, 0x50, 0xDF, 0x75, 0x04, 0xF9, 0x09, 0x50,
  0x01, 0x74, 0x0D, 0xF7, 0x50, 0x1F, 0xA8, 0x5D, 0x98, 0x9C, 0xF3, 0x74, 0x0D, 0xF7, 0x60, 0xAF,
  0xF0, 0x37, 0x40, 0xDF, 0x76, 0x04, 0xFF, 0x03, 0x74, 0x0D, 0xF7, 0x70, 0x9F, 0xE0, 0x37, 0x40,
  0xDF, 0x77, 0x10, 0xBF, 0xD0, 0x37, 0x40, 0xDF, 0x77, 0x20, 0x80, 0xEF, 0xB0, 0x37, 0x48, 0x04,
  0x17, 0x73, 0x89, 0x11, 0x6A, 0xDE, 0xFE, 0xDA, 0x72, 0x20,
  // "–" (U+2013)
  0x80, 0xBF, 0x0F,
  // "—" (U+2014)
  0x80, 0xDE, 0x6F,
  // "€" (U+20AC)
  0x77, 0x75, 0x89, 0x54, 0x79, 0xCD, 0xEE, 0xFE, 0xDC, 0xB8, 0x53, 0x77, 0x77, 0x30, 0x60, 0xAF,
  0xFB, 0x81, 0xB6, 0x17, 0x77, 0x38, 0x11, 0x7E, 0xFF, 0xF9, 0x0B, 0x04, 0x77, 0x70, 0x50, 0xEF,
  0xFF, 0xD0, 0xC0, 0x57, 0x73, 0x01, 0x0B, 0xFF, 0xFF, 0x90, 0xB7, 0x72, 0x02, 0x0D, 0xFF, 0xFF,
  0xA0, 0x37, 0x71, 0x03, 0x0E, 0xFD, 0x86, 0xDA, 0x98, 0x99, 0xBD, 0xFB, 0x0A, 0x77, 0x10, 0x20,
  0xEF, 0xB8, 0x1B, 0x51, 0x71, 0x82, 0x15, 0xAE, 0xE0, 0x27, 0x70, 0x10, 0xDF, 0xA0, 0xB0, 0x37,
  0x78, 0x11, 0x6C, 0xB0, 0x97, 0x71, 0x0A, 0xFA, 0x07, 0x77, 0x58, 0x24, 0xBF, 0x27, 0x70, 0x4F,
  0x90, 0xE0, 0x47, 0x77, 0x10, 0x27, 0x71, 0x0D, 0xF9, 0x04, 0x80, 0xC2, 0x00, 0x6F, 0x90, 0x78,
  0x0C, 0x30, 0x0E, 0xF0, 0xB8, 0x0C, 0x30, 0x06, 0xF9, 0x02, 0x80, 0xC3, 0x00, 0xCF, 0x09, 0x80,
  0xC3, 0x00, 0x2F, 0x90, 0x28, 0x0C, 0x30, 0x08, 0xF0, 0xB8, 0x0C, 0x40, 0x0D, 0xF0, 0x58, 0x0C,
  0x30, 0x01, 0xF9, 0x80, 0xC4, 0x00, 0x6F, 0x0B, 0x80, 0xC4, 0x00, 0x9F, 0x07, 0x80, 0xC4, 0x00,
  0xCF, 0x03, 0x80, 0xC4, 0x0F, 0x97, 0x77, 0x75, 0x03, 0x80, 0xC0, 0xF0, 0xD7, 0x40, 0x38, 0x0C,
  0x0F, 0x0D, 0x74, 0x03, 0x80, 0xC0, 0xF0, 0xD7, 0x40, 0x38, 0x0C, 0x0F, 0x0D, 0x74, 0x03, 0x80,
  0xC0, 0xF0, 0xD7, 0x40, 0x38, 0x0C, 0x0F, 0x0D, 0x77, 0x40, 0xBF, 0x03, 0x80, 0xC4, 0x00, 0xCF,
  0x03, 0x80, 0xC4, 0x00, 0xCF, 0x02, 0x80, 0xC4, 0x00, 0xCF, 0x02, 0x80, 0xC4, 0x00, 0xCF, 0x02,
  0x80, 0xC4, 0x00, 0xCF, 0x03, 0x80, 0xC4, 0x00, 0xBF, 0x03, 0x77, 0x77, 0x50, 0x38, 0x0C, 0x0F,
  0x0D, 0x74, 0x03, 0x80, 0xC0, 0xF0, 0xD7, 0x40, 0x38, 0x0C, 0x0F, 0x0D, 0x74, 0x03, 0x80, 0xC0,
  0xF0, 0xD7, 0x40, 0x38, 0x0C, 0x0F, 0x0D, 0x74, 0x03, 0x80, 0xC0, 0xF0, 0xD7, 0x75, 0x0E, 0xF0,
  0x18, 0x0C, 0x40, 0x0A, 0xF0, 0x58, 0x0C, 0x40, 0x07, 0xF0, 0x98, 0x0C, 0x40, 0x03, 0xF0, 0xD8,
  0x0C, 0x50, 0x0E, 0xF0, 0x38, 0x0C, 0x40, 0x09, 0xF0, 0xA8, 0x0C, 0x40, 0x04, 0xF9, 0x01, 0x80,
  0xC4, 0x00, 0xDF, 0x08, 0x80, 0xC4, 0x00, 0x7F, 0x90, 0x28, 0x0C, 0x30, 0x01, 0x0E, 0xF0, 0xB8,
  0x0C, 0x40, 0x07, 0xF9, 0x07, 0x80, 0xC4, 0x00, 0xEF, 0x90, 0x58, 0x0C, 0x30, 0x05, 0xFA, 0x05,
  0x80, 0xC3, 0x00, 0xAF, 0xA0, 0x87, 0x77, 0x10, 0x47, 0x71, 0x01, 0x0D, 0xFA, 0x0D, 0x04, 0x77,
  0x38, 0x13, 0x8D, 0x97, 0x72, 0x02, 0x0E, 0xFB, 0x81, 0xD7, 0x27, 0x38, 0x22, 0x59, 0xEC, 0x77,
  0x30, 0x30, 0xEF, 0xD8, 0x7E, 0xCA, 0x98, 0x9A, 0xBC, 0xFA, 0x77, 0x40, 0x20, 0xDF, 0xFF, 0xF9,
  0x77, 0x50, 0x10, 0xBF, 0xFF, 0xF7, 0x77, 0x06, 0x0E, 0xFF, 0xFD, 0x77, 0x71, 0x81, 0x18, 0xEF,
  0xFF, 0x90, 0xD0, 0x87, 0x77, 0x40, 0x60, 0xBF, 0xFB, 0x81, 0xC8, 0x37, 0x77, 0x72, 0x89, 0x64,
  0x79, 0xCD, 0xEE, 0xFE, 0xDD, 0xB9, 0x64, 0x17,
  // "₿" (U+20BF)
  0x71, 0x08, 0xD0, 0x36, 0x08, 0xD0, 0x27, 0x77, 0x08, 0xD0, 0x36, 0x08, 0xD0, 0x27, 0x77, 0x08,
  0xD0, 0x36, 0x08, 0xD0, 0x27, 0x77, 0x08, 0xD0, 0x36, 0x08, 0xD0, 0x27, 0x77, 0x08, 0xD0, 0x36,
  0x08, 0xD0, 0x27, 0x77, 0x08, 0xD0, 0x36, 0x08, 0xD0, 0x27, 0x77, 0x08, 0xD0, 0x36, 0x08, 0xD0,
  0x27, 0x77, 0x08, 0xD0, 0x36, 0x08, 0xD0, 0x27, 0x77, 0x08, 0xD0, 0x36, 0x08, 0xD0, 0x27, 0x60,
  0x7F, 0xFF, 0xD0, 0x37, 0x60, 0x7F, 0xFF, 0xD8, 0x1E, 0xA5, 0x74, 0x07, 0xFF, 0xFF, 0x98, 0x1E,
  0x81, 0x71, 0x07, 0xFF, 0xFF, 0xB0, 0xE0, 0x57, 0x07, 0xFF, 0xFF, 0xD0, 0x96, 0x07, 0xFF, 0xFF,
  0xE0, 0xA5, 0x07, 0xF0, 0x98, 0x06, 0x88, 0x29, 0xAC, 0xEF, 0xE0, 0x84, 0x07, 0xF0, 0x37, 0x78,
  0x21, 0x5A, 0xEF, 0xB0, 0x43, 0x07, 0xF0, 0x37, 0x73, 0x01, 0x09, 0xFA, 0x0B, 0x30, 0x7F, 0x03,
  0x77, 0x50, 0x6F, 0xA0, 0x32, 0x07, 0xF0, 0x37, 0x76, 0x08, 0xF9, 0x08, 0x20, 0x7F, 0x03, 0x77,
  0x60, 0x10, 0xEF, 0x0B, 0x20, 0x7F, 0x03, 0x77, 0x70, 0x9F, 0x0E, 0x20, 0x7F, 0x03, 0x77, 0x70,
  0x4F, 0x98, 0x11, 0x07, 0xF0, 0x37, 0x77, 0x01, 0xF9, 0x81, 0x20, 0x7F, 0x03, 0x77, 0x71, 0xF9,
  0x81, 0x30, 0x7F, 0x03, 0x77, 0x71, 0x0E, 0xF8, 0x13, 0x07, 0xF0, 0x37, 0x77, 0x1F, 0x98, 0x12,
  0x07, 0xF0, 0x37, 0x77, 0x01, 0xF9, 0x81, 0x10, 0x7F, 0x03, 0x77, 0x70, 0x2F, 0x0E, 0x20, 0x7F,
  0x03, 0x77, 0x70, 0x6F, 0x0A, 0x20, 0x7F, 0x03, 0x77, 0x70, 0xBF, 0x07, 0x20, 0x7F, 0x03, 0x77,
  0x60, 0x2F, 0x90, 0x12, 0x07, 0xF0, 0x37, 0x76, 0x0B, 0xF0, 0x93, 0x07, 0xF0, 0x37, 0x75, 0x09,
  0xF0, 0xE0, 0x13, 0x07, 0xF0, 0x37, 0x73, 0x01, 0x0B, 0xF9, 0x05, 0x40, 0x7F, 0x03, 0x77, 0x10,
  0x40, 0xAF, 0xA0, 0x65, 0x07, 0xF0, 0x98, 0x06, 0x88, 0x29, 0xAB, 0xDF, 0xB0, 0xE0, 0x56, 0x07,
  0xFF, 0xFF, 0xB0, 0xA0, 0x17, 0x07, 0xFF, 0xFF, 0x81, 0xD8, 0x27, 0x20, 0x7F, 0xFF, 0xD0, 0xD0,
  0x27, 0x50, 0x7F, 0xFF, 0xF8, 0x1C, 0x94, 0x72, 0x07, 0xFF, 0xFF, 0xB0, 0xD0, 0x67, 0x07, 0xFF,
  0xFF, 0xD0, 0xE0, 0x55, 0x07, 0xF0, 0x37, 0x58, 0x32, 0x36, 0x9D, 0xFB, 0x09, 0x40, 0x7F, 0x03,
  0x77, 0x30, 0x30, 0xAF, 0xA0, 0xA3, 0x07, 0xF0, 0x37, 0x75, 0x03, 0x0E, 0xF9, 0x07, 0x20, 0x7F,
  0x03, 0x77, 0x60, 0x20, 0xEF, 0x98, 0x12, 0x07, 0xF0, 0x37, 0x77, 0x04, 0xF9, 0x81, 0xA0, 0x7F,
  0x03, 0x77, 0x71, 0x0A, 0xF9, 0x01, 0x07, 0xF0, 0x37, 0x77, 0x10, 0x3F, 0x90, 0x60, 0x7F, 0x03,
  0x77, 0x72, 0x0D, 0xF0, 0xA0, 0x7F, 0x03, 0x77, 0x72, 0x09, 0xF0, 0xC0, 0x7F, 0x03, 0x77, 0x72,
  0x06, 0xF0, 0xE0, 0x7F, 0x03, 0x77, 0x72, 0x05, 0xF9, 0x07, 0xF0, 0x37, 0x77, 0x20, 0x3F, 0x90,
  0x7F, 0x03, 0x77, 0x72, 0x04, 0xF9, 0x07, 0xF0, 0x37, 0x77, 0x20, 0x5F, 0x0E, 0x07, 0xF0, 0x37,
  0x77, 0x20, 0x7F, 0x0D, 0x07, 0xF0, 0x37, 0x77, 0x20, 0xBF, 0x0A, 0x07, 0xF0, 0x37, 0x77, 0x10,
  0x1F, 0x90, 0x07, 0xF0, 0x37, 0x77, 0x10, 0x7F, 0x90, 0x30, 0x7F, 0x03, 0x77, 0x70, 0x10, 0xEF,
  0x81, 0xE0, 0x7F, 0x03, 0x77, 0x70, 0xBF, 0x98, 0x18, 0x07, 0xF0, 0x37, 0x76, 0x08, 0xFA, 0x81,
  0x10, 0x7F, 0x03, 0x77, 0x40, 0x20, 0xBF, 0xA0, 0x82, 0x07, 0xF0, 0x37, 0x71, 0x81, 0x15, 0xAF,
  0xB0, 0xD3, 0x07, 0xF0, 0x98, 0x07, 0x88, 0x29, 0xAB, 0xDF, 0xD0, 0xE0, 0x33, 0x07, 0xFF, 0xFF,
  0xE0, 0xE0, 0x34, 0x07, 0xFF, 0xFF, 0xD0, 0xE0, 0x35, 0x07, 0xFF, 0xFF, 0xC0, 0xB0, 0x16, 0x07,
  0xFF, 0xFF, 0xA0, 0xC0, 0x57, 0x10, 0x7F, 0xFF, 0xE8, 0x1E, 0x94, 0x73, 0x07, 0xFF, 0xFD, 0x05,
  0x77, 0x70, 0x8D, 0x03, 0x60, 0x8D, 0x02, 0x77, 0x70, 0x8D, 0x03, 0x60, 0x8D, 0x02, 0x77, 0x70,
  0x8D, 0x03, 0x60, 0x8D, 0x02, 0x77, 0x70, 0x8D, 0x03, 0x60, 0x8D, 0x02, 0x77, 0x70, 0x8D, 0x03,
  0x60, 0x8D, 0x02, 0x77, 0x70, 0x8D, 0x03, 0x60, 0x8D, 0x02, 0x77, 0x70, 0x8D, 0x03, 0x60, 0x8D,
  0x02, 0x77, 0x70, 0x8D, 0x03, 0x60, 0x8D, 0x02, 0x77, 0x70, 0x8D, 0x03, 0x60, 0x8D, 0x02, 0x76,
  // "‘" (U+2018)
  0x70, 0x4D, 0x09, 0x70, 0xBD, 0x06, 0x60, 0x2E, 0x02, 0x60, 0x9D, 0x0E, 0x60, 0x10, 0xED, 0x0A,
  0x60, 0x7E, 0x07, 0x60, 0xDE, 0x03, 0x50, 0x3F, 0x60, 0x9E, 0x0C, 0x60, 0xEE, 0x08, 0x50, 0x6F,
  0x05, 0x50, 0xBF, 0x02, 0x40, 0x1F, 0x0E, 0x50, 0x7F, 0x0B, 0x50, 0xCF, 0x08, 0x40, 0x2F, 0x90,
  0x54, 0x07, 0xF9, 0x02, 0x40, 0xCF, 0x94, 0x01, 0xF9, 0x0C, 0x40, 0x6F, 0x90, 0x94, 0x0A, 0xF9,
  0x07, 0x40, 0x8F, 0x90, 0x54,
  // "’" (U+2019)
  0x40, 0xBF, 0x90, 0xD5, 0x0E, 0xFA, 0x01, 0x4F, 0xA0, 0xC4, 0x03, 0xFA, 0x08, 0x40, 0x6F, 0xA0,
  0x34, 0x08, 0xF9, 0x0E, 0x50, 0xBF, 0x90, 0x95, 0x0E, 0xF9, 0x04, 0x40, 0x2F, 0x90, 0xE5, 0x05,
  0xF9, 0x08, 0x50, 0x8F, 0x90, 0x35, 0x0B, 0xF0, 0xC6, 0x0E, 0xF0, 0x65, 0x02, 0xF9, 0x01, 0x50,
  0x6F, 0x09, 0x60, 0x9F, 0x03, 0x60, 0xDE, 0x0D, 0x60, 0x1F, 0x06, 0x60, 0x4E, 0x0E, 0x70, 0x8E,
  0x08, 0x70, 0xBE, 0x02, 0x70, 0xED, 0x0A, 0x71,
  // "‚" (U+201A)
  0x40, 0x3F, 0xA0, 0xC5, 0x05, 0xFB, 0x01, 0x40, 0x8F, 0xA0, 0xC5, 0x0A, 0xFA, 0x08, 0x50, 0xDF,
  0xA0, 0x35, 0xFA, 0x0D, 0x50, 0x3F, 0xA0, 0x95, 0x06, 0xFA, 0x03, 0x50, 0x9F, 0x90, 0xD6, 0x0C,
  0xF9, 0x08, 0x6F, 0xA0, 0x25, 0x03, 0xF9, 0x0C, 0x60, 0x6F, 0x90, 0x66, 0x09, 0xF9, 0x01, 0x60,
  0xDF, 0x09, 0x7F, 0x90, 0x36, 0x04, 0xF0, 0xD7, 0x07, 0xF0, 0x67, 0x0B, 0xE0, 0xE0, 0x17, 0x0E,
  0xE0, 0x97, 0x02, 0xF0, 0x27, 0x06, 0xE0, 0xB7, 0x10, 0xAE, 0x04, 0x71, 0x0D, 0xD0, 0xD7, 0x20,
  // "‛" (U+201B)
  0x08, 0xF9, 0x06, 0x40, 0xAF, 0x90, 0x94, 0x06, 0xF9, 0x0B, 0x40, 0x1F, 0x90, 0xD5, 0x0C, 0xF9,
  0x01, 0x40, 0x7F, 0x90, 0x34, 0x02, 0xF9, 0x06, 0x50, 0xCF, 0x09, 0x50, 0x7F, 0x0C, 0x50, 0x2F,
  0x96, 0x0B, 0xF0, 0x35, 0x06, 0xF0, 0x76, 0x0E, 0xE0, 0xA6, 0x09, 0xE0, 0xD6, 0x03, 0xF0, 0x16,
  0x0D, 0xE0, 0x46, 0x06, 0xE0, 0x86, 0x01, 0x0E, 0xD0, 0xC7, 0x09, 0xE7, 0x02, 0xE0, 0x37, 0x0A,
  0xD0, 0x77, 0x03, 0xD0, 0xB0,
  // "“" (U+201C)
  0x70, 0x4D, 0x09, 0x72, 0x04, 0xD0, 0x97, 0x0B, 0xD0, 0x67, 0x20, 0xBD, 0x06, 0x60, 0x2E, 0x02,
  0x71, 0x02, 0xE0, 0x26, 0x09, 0xD0, 0xE7, 0x20, 0x9D, 0x0E, 0x60, 0x10, 0xED, 0x0A, 0x71, 0x01,
  0x0E, 0xD0, 0xA6, 0x07, 0xE0, 0x77, 0x10, 0x7E, 0x07, 0x60, 0xDE, 0x03, 0x71, 0x0D, 0xE0, 0x35,
  0x03, 0xF7, 0x10, 0x3F, 0x60, 0x9E, 0x0C, 0x71, 0x09, 0xE0, 0xC6, 0x0E, 0xE0, 0x87, 0x10, 0xEE,
  0x08, 0x50, 0x6F, 0x05, 0x70, 0x6F, 0x05, 0x50, 0xBF, 0x02, 0x70, 0xBF, 0x02, 0x40, 0x1F, 0x0E,
  0x70, 0x1F, 0x0E, 0x50, 0x7F, 0x0B, 0x70, 0x7F, 0x0B, 0x50, 0xCF, 0x08, 0x70, 0xCF, 0x08, 0x40,
  0x2F, 0x90, 0x56, 0x02, 0xF9, 0x05, 0x40, 0x7F, 0x90, 0x26, 0x07, 0xF9, 0x02, 0x40, 0xCF, 0x97,
  0x0C, 0xF9, 0x40, 0x1F, 0x90, 0xC6, 0x01, 0xF9, 0x0C, 0x40, 0x6F, 0x90, 0x96, 0x06, 0xF9, 0x09,
  0x40, 0xAF, 0x90, 0x76, 0x0A, 0xF9, 0x07, 0x40, 0x8F, 0x90, 0x56, 0x08, 0xF9, 0x05, 0x40,
  // "”" (U+201D)
  0x40, 0x5F, 0x90, 0x86, 0x05, 0xF9, 0x08, 0x40, 0x7F, 0x90, 0xA6, 0x07, 0xF9, 0x0A, 0x40, 0xAF,
  0x90, 0x66, 0x0A, 0xF9, 0x06, 0x40, 0xCF, 0x90, 0x16, 0x0C, 0xF9, 0x01, 0x4F, 0x90, 0xC7, 0xF9,
  0x0C, 0x40, 0x2F, 0x90, 0x76, 0x02, 0xF9, 0x07, 0x40, 0x5F, 0x90, 0x26, 0x05, 0xF9, 0x02, 0x40,
  0x8F, 0x0C, 0x70, 0x8F, 0x0C, 0x50, 0xBF, 0x07, 0x70, 0xBF, 0x07, 0x50, 0xEF, 0x01, 0x70, 0xEF,
  0x01, 0x40, 0x2F, 0x0B, 0x70, 0x2F, 0x0B, 0x50, 0x5F, 0x06, 0x70, 0x5F, 0x06, 0x50, 0x9E, 0x0E,
  0x01, 0x70, 0x9E, 0x0E, 0x01, 0x50, 0xCE, 0x09, 0x71, 0x0C, 0xE0, 0x96, 0xF0, 0x37, 0x1F, 0x03,
  0x50, 0x3E, 0x0D, 0x71, 0x03, 0xE0, 0xD6, 0x07, 0xE0, 0x77, 0x10, 0x7E, 0x07, 0x60, 0xAD, 0x0E,
  0x01, 0x71, 0x0A, 0xD0, 0xE0, 0x16, 0x0E, 0xD0, 0x97, 0x20, 0xED, 0x09, 0x60, 0x2E, 0x02, 0x71,
  0x02, 0xE0, 0x26, 0x06, 0xD0, 0xB7, 0x20, 0x6D, 0x0B, 0x70, 0x9D, 0x04, 0x72, 0x09, 0xD0, 0x47,
  // "„" (U+201E)
  0x40, 0x3F, 0xA0, 0xC6, 0x03, 0xFA, 0x0C, 0x50, 0x5F, 0xB0, 0x15, 0x05, 0xFB, 0x01, 0x40, 0x8F,
  0xA0, 0xC6, 0x08, 0xFA, 0x0C, 0x50, 0xAF, 0xA0, 0x86, 0x0A, 0xFA, 0x08, 0x50, 0xDF, 0xA0, 0x36,
  0x0D, 0xFA, 0x03, 0x5F, 0xA0, 0xD7, 0xFA, 0x0D, 0x50, 0x3F, 0xA0, 0x96, 0x03, 0xFA, 0x09, 0x50,
  0x6F, 0xA0, 0x36, 0x06, 0xFA, 0x03, 0x50, 0x9F, 0x90, 0xD7, 0x09, 0xF9, 0x0D, 0x60, 0xCF, 0x90,
  0x87, 0x0C, 0xF9, 0x08, 0x6F, 0xA0, 0x27, 0xFA, 0x02, 0x50, 0x3F, 0x90, 0xC7, 0x03, 0xF9, 0x0C,
  0x60, 0x6F, 0x90, 0x67, 0x06, 0xF9, 0x06, 0x60, 0x9F, 0x90, 0x17, 0x09, 0xF9, 0x01, 0x60, 0xDF,
  0x09, 0x71, 0x0D, 0xF0, 0x97, 0xF9, 0x03, 0x71, 0xF9, 0x03, 0x60, 0x4F, 0x0D, 0x71, 0x04, 0xF0,
  0xD7, 0x07, 0xF0, 0x67, 0x10, 0x7F, 0x06, 0x70, 0xBE, 0x0E, 0x01, 0x71, 0x0B, 0xE0, 0xE0, 0x17,
  0x0E, 0xE0, 0x97, 0x20, 0xEE, 0x09, 0x70, 0x2F, 0x02, 0x71, 0x02, 0xF0, 0x27, 0x06, 0xE0, 0xB7,
  0x20, 0x6E, 0x0B, 0x71, 0x0A, 0xE0, 0x47, 0x20, 0xAE, 0x04, 0x71, 0x0D, 0xD0, 0xD7, 0x30, 0xDD,
  0x0D, 0x72,
  // "‟" (U+201F)
  0x08, 0xF9, 0x05, 0x60, 0x8F, 0x90, 0x54, 0x0A, 0xF9, 0x07, 0x60, 0xAF, 0x90, 0x74, 0x06, 0xF9,
  0x09, 0x60, 0x6F, 0x90, 0x94, 0x01, 0xF9, 0x0C, 0x60, 0x1F, 0x90, 0xC5, 0x0C, 0xF9, 0x70, 0xCF,
  0x95, 0x07, 0xF9, 0x02, 0x60, 0x7F, 0x90, 0x24, 0x02, 0xF9, 0x05, 0x60, 0x2F, 0x90, 0x55, 0x0C,
  0xF0, 0x87, 0x0C, 0xF0, 0x85, 0x07, 0xF0, 0xB7, 0x07, 0xF0, 0xB5, 0x01, 0xF0, 0xE7, 0x01, 0xF0,
  0xE6, 0x0B, 0xF0, 0x27, 0x0B, 0xF0, 0x25, 0x06, 0xF0, 0x57, 0x06, 0xF0, 0x55, 0x01, 0x0E, 0xE0,
  0x87, 0x01, 0x0E, 0xE0, 0x86, 0x09, 0xE0, 0xC7, 0x10, 0x9E, 0x0C, 0x60, 0x3F, 0x71, 0x03, 0xF7,
  0x0D, 0xE0, 0x37, 0x10, 0xDE, 0x03, 0x60, 0x7E, 0x07, 0x71, 0x07, 0xE0, 0x76, 0x01, 0xE0, 0xA7,
  0x10, 0x1E, 0x0A, 0x70, 0x9D, 0x0E, 0x72, 0x09, 0xD0, 0xE7, 0x02, 0xE0, 0x27, 0x10, 0x2E, 0x02,
  0x70, 0xBD, 0x06, 0x72, 0x0B, 0xD0, 0x67, 0x04, 0xD0, 0x97, 0x20, 0x4D, 0x09,
  // "†" (U+2020)
  0x76, 0x0D, 0xF9, 0x77, 0x76, 0x0C, 0xF0, 0xD7, 0x77, 0x60, 0xAF, 0x0B, 0x77, 0x76, 0x08, 0xF0,
  0x97, 0x77, 0x60, 0x6F, 0x07, 0x77, 0x76, 0x05, 0xF0, 0x67, 0x77, 0x60, 0x3F, 0x04, 0x77, 0x76,
  0x01, 0xF0, 0x27, 0x77, 0x7F, 0x77, 0x77, 0x10, 0xDD, 0x0E, 0x77, 0x77, 0x10, 0xBD, 0x0C, 0x77,
  0x77, 0x10, 0x9D, 0x0A, 0x77, 0x77, 0x10, 0x8D, 0x08, 0x77, 0x77, 0x10, 0x6D, 0x06, 0x77, 0x77,
  0x10, 0x4D, 0x04, 0x77, 0x77, 0x10, 0x2D, 0x03, 0x77, 0x77, 0x10, 0x1D, 0x01, 0x77, 0x18, 0x31,
  0x54, 0x31, 0x73, 0x0E, 0xB0, 0xE7, 0x48, 0x42, 0x34, 0x61, 0x4D, 0x89, 0x0E, 0xCB, 0xA8, 0x75,
  0x42, 0xDB, 0x89, 0x1D, 0x24, 0x56, 0x89, 0xAC, 0xDE, 0xD0, 0x20, 0x4F, 0xFF, 0xFE, 0x02, 0x04,
  0xFF, 0xFF, 0xE0, 0x20, 0x4F, 0xFF, 0xFE, 0x02, 0x04, 0xFF, 0xFF, 0xE0, 0x20, 0x4F, 0xFF, 0xFE,
  0x02, 0x04, 0xB8, 0x92, 0xDC, 0xA9, 0x86, 0x53, 0x21, 0x0C, 0xB8, 0x93, 0xC0, 0x12, 0x35, 0x67,
  0x8A, 0xBC, 0xEB, 0x81, 0x20, 0x27, 0x60, 0xDB, 0x0D, 0x76, 0x01, 0x02, 0x77, 0x20, 0xEB, 0x0E,
  0x77, 0x77, 0x3D, 0x77, 0x77, 0x3D, 0x77, 0x77, 0x20, 0x1D, 0x01, 0x77, 0x77, 0x10, 0x1D, 0x02,
  0x77, 0x77, 0x10, 0x2D, 0x02, 0x77, 0x77, 0x10, 0x3D, 0x03, 0x77, 0x77, 0x10, 0x4D, 0x04, 0x77,
  0x77, 0x10, 0x4D, 0x05, 0x77, 0x77, 0x10, 0x5D, 0x05, 0x77, 0x77, 0x10, 0x6D, 0x06, 0x77, 0x77,
  0x10, 0x7D, 0x07, 0x77, 0x77, 0x10, 0x7D, 0x08, 0x77, 0x77, 0x10, 0x8D, 0x09, 0x77, 0x77, 0x10,
  0x9D, 0x09, 0x77, 0x77, 0x10, 0xAD, 0x0A, 0x77, 0x77, 0x10, 0xBD, 0x0B, 0x77, 0x77, 0x10, 0xBD,
  0x0C, 0x77, 0x77, 0x10, 0xCD, 0x0D, 0x77, 0x77, 0x10, 0xDD, 0x0D, 0x77, 0x77, 0x10, 0xED, 0x0E,
  0x77, 0x77, 0x10, 0xEE, 0x77, 0x77, 0x1F, 0x77, 0x77, 0x1F, 0x01, 0x77, 0x76, 0x01, 0xF0, 0x27,
  0x77, 0x60, 0x2F, 0x03, 0x77, 0x76, 0x03, 0xF0, 0x37, 0x77, 0x60, 0x3F, 0x04, 0x77, 0x76, 0x04,
  0xF0, 0x57, 0x77, 0x60, 0x5F, 0x06, 0x77, 0x76, 0x06, 0xF0, 0x77, 0x77, 0x60, 0x6F, 0x07, 0x77,
  0x76, 0x07, 0xF0, 0x87, 0x77, 0x60, 0x8F, 0x09, 0x77, 0x76, 0x09, 0xF0, 0xA7, 0x77, 0x60, 0x9F,
  0x0B, 0x77, 0x76, 0x0A, 0xF0, 0xB7, 0x77, 0x60, 0xBF, 0x0C, 0x77, 0x76, 0x0C, 0xF0, 0xD7, 0x77,
  0x60, 0xCF, 0x0E, 0x77, 0x76, 0x0D, 0xF9, 0x77, 0x76, 0x0E, 0xF9, 0x77,
  // "‡" (U+2021)
  0x76, 0x09, 0xF9, 0x05, 0x77, 0x75, 0x07, 0xF9, 0x03, 0x77, 0x75, 0x05, 0xF9, 0x01, 0x77, 0x75,
  0x03, 0xF9, 0x77, 0x76, 0x01, 0xF0, 0xD7, 0x77, 0x7F, 0x0B, 0x77, 0x77, 0x0D, 0xE0, 0x97, 0x77,
  0x70, 0xBE, 0x07, 0x77, 0x77, 0x09, 0xE0, 0x57, 0x77, 0x70, 0x7E, 0x03, 0x77, 0x77, 0x05, 0xE0,
  0x17, 0x77, 0x70, 0x3E, 0x77, 0x77, 0x10, 0x1D, 0x0D, 0x77, 0x77, 0x2D, 0x0B, 0x77, 0x77, 0x20,
  0xDC, 0x09, 0x77, 0x77, 0x20, 0xBC, 0x07, 0x77, 0x18, 0x91, 0x9E, 0xDB, 0xA9, 0x76, 0x53, 0x24,
  0x09, 0xC0, 0x53, 0x89, 0x31, 0x23, 0x56, 0x79, 0xAB, 0xDE, 0x99, 0xFD, 0x81, 0xDC, 0xDC, 0x81,
  0xCC, 0xDF, 0xD0, 0x09, 0xFF, 0xFF, 0xE0, 0x09, 0xFF, 0xFF, 0xE0, 0x09, 0xFF, 0xFF, 0xE0, 0x09,
  0xFF, 0xFF, 0xE0, 0x09, 0xD8, 0x90, 0xED, 0xBA, 0x97, 0x65, 0x3A, 0xC8, 0x90, 0x64, 0x56, 0x89,
  0xAC, 0xDE, 0xD8, 0x49, 0x45, 0x43, 0x17, 0x30, 0xBC, 0x07, 0x73, 0x83, 0x13, 0x45, 0x47, 0x71,
  0x0D, 0xC0, 0x97, 0x77, 0x72, 0xD0, 0xC7, 0x77, 0x71, 0x03, 0xD0, 0xE7, 0x77, 0x71, 0x05, 0xE0,
  0x17, 0x77, 0x70, 0x8E, 0x03, 0x77, 0x77, 0x0A, 0xE0, 0x67, 0x77, 0x70, 0xDE, 0x08, 0x77, 0x77,
  0xF0, 0xB7, 0x77, 0x60, 0x2F, 0x0D, 0x77, 0x76, 0x04, 0xF9, 0x77, 0x76, 0x05, 0xF9, 0x01, 0x77,
  0x75, 0x03, 0xF0, 0xE7, 0x77, 0x7F, 0x0C, 0x77, 0x77, 0x0D, 0xE0, 0x97, 0x77, 0x70, 0xBE, 0x07,
  0x77, 0x77, 0x09, 0xE0, 0x57, 0x77, 0x70, 0x6E, 0x02, 0x77, 0x77, 0x04, 0xE7, 0x77, 0x71, 0x02,
  0xD0, 0xD7, 0x77, 0x72, 0xD0, 0xB7, 0x77, 0x72, 0x0D, 0xC0, 0x97, 0x71, 0x85, 0x58, 0x65, 0x42,
  0x17, 0x10, 0xAC, 0x06, 0x71, 0x86, 0x12, 0x45, 0x68, 0x59, 0xF8, 0x6E, 0xCB, 0xA8, 0x75, 0xAC,
  0x86, 0x86, 0x78, 0xAB, 0xDE, 0xF0, 0x09, 0xFF, 0xFF, 0xE0, 0x09, 0xFF, 0xFF, 0xE0, 0x09, 0xFF,
  0xFF, 0xE0, 0x09, 0xFF, 0xFF, 0xE0, 0x09, 0xFC, 0x82, 0xDC, 0xBD, 0xC8, 0x2B, 0xBD, 0xEF, 0xC8,
  0x91, 0x98, 0xCA, 0x98, 0x75, 0x43, 0x25, 0x09, 0xC0, 0x54, 0x89, 0x11, 0x23, 0x46, 0x78, 0x9B,
  0xC8, 0x77, 0x10, 0xBC, 0x07, 0x77, 0x77, 0x20, 0xDC, 0x09, 0x77, 0x77, 0x2D, 0x0B, 0x77, 0x77,
  0x10, 0x2D, 0x0D, 0x77, 0x77, 0x10, 0x4E, 0x77, 0x77, 0x10, 0x6E, 0x02, 0x77, 0x77, 0x08, 0xE0,
  0x47, 0x77, 0x70, 0xAE, 0x06, 0x77, 0x77, 0x0C, 0xE0, 0x87, 0x77, 0x70, 0xEE, 0x0A, 0x77, 0x76,
  0x01, 0xF0, 0xC7, 0x77, 0x60, 0x3F, 0x0E, 0x77, 0x76, 0x05, 0xF9, 0x01, 0x77, 0x75, 0x07, 0xF9,
  0x03, 0x77, 0x75, 0x09, 0xF9, 0x05, 0x76,
  // "•" (U+2022)
  0x58, 0x90, 0x17, 0xBD, 0xEE, 0xDB, 0x71, 0x71, 0x01, 0x09, 0xFB, 0x09, 0x01, 0x50, 0x20, 0xDF,
  0xD0, 0xD0, 0x23, 0x01, 0x0D, 0xFF, 0x0D, 0x01, 0x20, 0x9F, 0xFA, 0x81, 0x90, 0x1F, 0xFC, 0x01,
  0x06, 0xFF, 0xC0, 0x60, 0xAF, 0xFC, 0x09, 0x0C, 0xFF, 0xC0, 0xC0, 0xDF, 0xFC, 0x0D, 0x0E, 0xFF,
  0xC0, 0x0E, 0xFF, 0xC0, 0xE0, 0xDF, 0xFC, 0x0D, 0x0C, 0xFF, 0xC0, 0xC0, 0x9F, 0xFC, 0x09, 0x06,
  0xFF, 0xC8, 0x16, 0x1E, 0xFF, 0xA8, 0x2E, 0x10, 0x9F, 0xFA, 0x08, 0x30, 0xDF, 0xF0, 0xD4, 0x02,
  0x0D, 0xFD, 0x0D, 0x02, 0x60, 0x9F, 0xB0, 0x87, 0x28, 0x90, 0x17, 0xBD, 0xEE, 0xDB, 0x71, 0x50,
  // "…" (U+2026)
  0x28, 0x61, 0x8C, 0xEE, 0xC7, 0x17, 0x38, 0x61, 0x8C, 0xEE, 0xC7, 0x17, 0x38, 0x61, 0x8C, 0xEE,
  0xC7, 0x13, 0x02, 0x0E, 0xE0, 0xE0, 0x27, 0x10, 0x20, 0xEE, 0x0E, 0x02, 0x71, 0x02, 0x0E, 0xE0,
  0xE0, 0x22, 0x0D, 0xF9, 0x0D, 0x71, 0x0D, 0xF9, 0x0D, 0x71, 0x0D, 0xF9, 0x81, 0xD0, 0x3F, 0xB0,
  0x36, 0x03, 0xFB, 0x03, 0x60, 0x3F, 0xB0, 0x30, 0x7F, 0xB0, 0x76, 0x07, 0xFB, 0x07, 0x60, 0x7F,
  0xB0, 0x70, 0x8F, 0xB0, 0x86, 0x08, 0xFB, 0x08, 0x60, 0x8F, 0xB0, 0x08, 0xFB, 0x08, 0x60, 0x8F,
  0xB0, 0x86, 0x08, 0xFB, 0x08, 0x07, 0xFB, 0x07, 0x60, 0x7F, 0xB0, 0x76, 0x07, 0xFB, 0x07, 0x03,
  0xFB, 0x03, 0x60, 0x3F, 0xB0, 0x36, 0x03, 0xFB, 0x81, 0x30, 0xCF, 0x90, 0xC7, 0x10, 0xCF, 0x90,
  0xC7, 0x10, 0xCF, 0x90, 0xC2, 0x02, 0x0D, 0xE0, 0xD0, 0x17, 0x10, 0x20, 0xDE, 0x0D, 0x01, 0x71,
  0x02, 0x0D, 0xE0, 0xD0, 0x14, 0x84, 0x7C, 0xEE, 0xC7, 0x75, 0x84, 0x7C, 0xEE, 0xC7, 0x75, 0x84,
  0x7C, 0xEE, 0xC7, 0x30,
  // "‰" (U+2030)
  0x68, 0x72, 0x7B, 0xDF, 0xEC, 0x72, 0x80, 0xC6, 0x00, 0x8F, 0xA0, 0x88, 0x0C, 0x40, 0x0C, 0xFC,
  0x0B, 0x80, 0xC2, 0x00, 0xBF, 0xE0, 0xB8, 0x0C, 0x00, 0x07, 0xFF, 0x90, 0x67, 0x77, 0x76, 0x01,
  0x0E, 0xD8, 0x3D, 0x30, 0x3D, 0xD0, 0xE0, 0x17, 0x77, 0x75, 0x07, 0xE0, 0x33, 0x03, 0xE0, 0x77,
  0x77, 0x75, 0x0D, 0xD0, 0xB5, 0x0B, 0xD0, 0xD7, 0x77, 0x74, 0x01, 0xE0, 0x65, 0x07, 0xE0, 0x17,
  0x77, 0x73, 0x04, 0xE0, 0x45, 0x04, 0xE0, 0x47, 0x77, 0x73, 0x07, 0xE0, 0x25, 0x03, 0xE0, 0x77,
  0x77, 0x73, 0x08, 0xE0, 0x15, 0x01, 0xE0, 0x87, 0x77, 0x73, 0x09, 0xE6, 0x01, 0xE0, 0x97, 0x77,
  0x73, 0x09, 0xE6, 0x01, 0xE0, 0xA7, 0x77, 0x73, 0x09, 0xE6, 0x01, 0xE0, 0x97, 0x77, 0x73, 0x08,
  0xE0, 0x15, 0x02, 0xE0, 0x87, 0x72, 0x05, 0x80, 0x6A, 0x02, 0x30, 0x7E, 0x02, 0x50, 0x3E, 0x07,
  0x77, 0x02, 0x0B, 0xFA, 0x0B, 0x02, 0x40, 0x4E, 0x04, 0x50, 0x5E, 0x04, 0x76, 0x07, 0xFA, 0x0E,
  0x06, 0x60, 0x1E, 0x07, 0x50, 0x8E, 0x01, 0x74, 0x03, 0x0C, 0xFA, 0x0A, 0x01, 0x71, 0x0C, 0xD0,
  0xC5, 0x0C, 0xD0, 0xD7, 0x40, 0x8F, 0xA0, 0xD0, 0x47, 0x30, 0x6E, 0x03, 0x30, 0x4E, 0x07, 0x72,
  0x04, 0x0D, 0xFA, 0x09, 0x75, 0x01, 0x0E, 0xD8, 0x3D, 0x40, 0x4D, 0xE0, 0x17, 0x01, 0x0A, 0xFA,
  0x0D, 0x03, 0x77, 0x06, 0xFF, 0x90, 0x77, 0x05, 0x0E, 0xFA, 0x08, 0x77, 0x30, 0xBF, 0xE0, 0xC6,
  0x02, 0x0B, 0xFA, 0x0C, 0x02, 0x77, 0x50, 0xBF, 0xC0, 0xD0, 0x15, 0x07, 0x0E, 0xF9, 0x0E, 0x06,
  0x77, 0x71, 0x08, 0xFA, 0x09, 0x50, 0x30, 0xCF, 0xA0, 0xB0, 0x17, 0x77, 0x38, 0x72, 0x7C, 0xEF,
  0xDC, 0x72, 0x50, 0x8F, 0xA0, 0xE0, 0x58, 0x0C, 0x20, 0x04, 0x0D, 0xFA, 0x09, 0x01, 0x80, 0xC1,
  0x00, 0x10, 0x9F, 0xA0, 0xD0, 0x48, 0x0C, 0x20, 0x05, 0x0E, 0xFA, 0x08, 0x80, 0xC2, 0x00, 0x10,
  0xBF, 0xA0, 0xC0, 0x38, 0x0C, 0x20, 0x06, 0x0E, 0xFA, 0x07, 0x80, 0xC2, 0x00, 0x20, 0xCF, 0xA0,
  0xB0, 0x28, 0x0C, 0x20, 0x08, 0xFA, 0x0E, 0x06, 0x80, 0xC2, 0x00, 0x30, 0xDF, 0xA0, 0xA0, 0x18,
  0x0C, 0x10, 0x01, 0x09, 0xFA, 0x0D, 0x04, 0x80, 0xC2, 0x00, 0x50, 0xEF, 0xA0, 0x98, 0x0C, 0x20,
  0x01, 0x0A, 0xFA, 0x0D, 0x03, 0x80, 0xC2, 0x00, 0x50, 0xD8, 0x04, 0xE0, 0xD0, 0x78, 0x0E, 0x20,
  0x87, 0x16, 0xBD, 0xFE, 0xC8, 0x37, 0x68, 0x72, 0x7C, 0xDF, 0xDC, 0x71, 0x77, 0x60, 0x70, 0xEF,
  0x90, 0x90, 0x17, 0x20, 0x10, 0x9F, 0xA0, 0x77, 0x74, 0x0A, 0xFC, 0x0D, 0x01, 0x70, 0x10, 0xDF,
  0xC0, 0xB7, 0x72, 0x0A, 0xFE, 0x0D, 0x01, 0x60, 0xDF, 0xE0, 0xA7, 0x70, 0x5F, 0xF9, 0x09, 0x50,
  0x8F, 0xF9, 0x06, 0x76, 0x0D, 0xD8, 0x3E, 0x50, 0x2B, 0xE0, 0x33, 0x02, 0xE8, 0x3D, 0x30, 0x3D,
  0xD0, 0xE0, 0x17, 0x40, 0x4E, 0x05, 0x30, 0x10, 0xED, 0x0A, 0x30, 0x8E, 0x02, 0x30, 0x3E, 0x06,
  0x74, 0x0A, 0xD0, 0xD5, 0x08, 0xE0, 0x12, 0x0D, 0xD0, 0xA5, 0x0C, 0xD0, 0xC7, 0x40, 0xED, 0x09,
  0x50, 0x4E, 0x81, 0x40, 0x2E, 0x06, 0x50, 0x7E, 0x01, 0x72, 0x01, 0xE0, 0x65, 0x01, 0xE8, 0x17,
  0x05, 0xE0, 0x35, 0x05, 0xE0, 0x47, 0x20, 0x4E, 0x04, 0x6E, 0x81, 0xA0, 0x7E, 0x01, 0x50, 0x3E,
  0x07, 0x72, 0x05, 0xE0, 0x36, 0x0E, 0xD8, 0x1B, 0x09, 0xE6, 0x02, 0xE0, 0x87, 0x20, 0x6E, 0x03,
  0x60, 0xDD, 0x81, 0xC0, 0x9E, 0x60, 0x1E, 0x09, 0x72, 0x07, 0xE0, 0x36, 0x0D, 0xD8, 0x1D, 0x0A,
  0xE6, 0x01, 0xE0, 0x97, 0x20, 0x6E, 0x03, 0x60, 0xED, 0x81, 0xC0, 0x9E, 0x60, 0x1E, 0x09, 0x72,
  0x05, 0xE0, 0x36, 0x0E, 0xD8, 0x1B, 0x08, 0xE6, 0x02, 0xE0, 0x87, 0x20, 0x4E, 0x05, 0x6E, 0x81,
  0xA0, 0x7E, 0x01, 0x50, 0x3E, 0x07, 0x72, 0x01, 0xE0, 0x75, 0x02, 0xE8, 0x17, 0x04, 0xE0, 0x35,
  0x05, 0xE0, 0x47, 0x30, 0xDD, 0x0A, 0x50, 0x5E, 0x81, 0x40, 0x1E, 0x06, 0x50, 0x8E, 0x01, 0x73,
  0x09, 0xD0, 0xE5, 0x09, 0xE0, 0x12, 0x0C, 0xD0, 0xB5, 0x0D, 0xD0, 0xD7, 0x40, 0x3E, 0x06, 0x30,
  0x10, 0xED, 0x0A, 0x30, 0x6E, 0x03, 0x30, 0x4E, 0x07, 0x75, 0x0C, 0xD8, 0x3E, 0x50, 0x2C, 0xE0,
  0x43, 0x01, 0x0E, 0xD8, 0x3D, 0x30, 0x4E, 0xD0, 0xE0, 0x17, 0x50, 0x3F, 0xF9, 0x0A, 0x50, 0x6F,
  0xF9, 0x07, 0x77, 0x07, 0xFE, 0x0E, 0x01, 0x60, 0xBF, 0xE0, 0xC7, 0x72, 0x08, 0xFC, 0x0E, 0x02,
  0x71, 0x0B, 0xFC, 0x0C, 0x01, 0x77, 0x30, 0x50, 0xEF, 0x90, 0xB0, 0x17, 0x30, 0x7F, 0xA0, 0x87,
  0x76, 0x87, 0x16, 0xBD, 0xFE, 0xC8, 0x37, 0x68, 0x72, 0x7C, 0xEF, 0xDC, 0x72, 0x60,
  // "‹" (U+2039)
  0x77, 0x10, 0x27, 0x76, 0x82, 0x2E, 0xD5, 0x77, 0x40, 0xCB, 0x0C, 0x03, 0x77, 0x10, 0xBE, 0x09,
  0x01, 0x75, 0x08, 0xF0, 0xC7, 0x50, 0x6F, 0x0D, 0x01, 0x74, 0x03, 0xF9, 0x03, 0x74, 0x02, 0x0E,
  0xF0, 0x57, 0x40, 0x10, 0xDF, 0x08, 0x75, 0x0B, 0xF0, 0xA7, 0x50, 0x9F, 0x0D, 0x75, 0x06, 0xF0,
  0xE0, 0x27, 0x40, 0x4F, 0x90, 0x47, 0x40, 0x20, 0xEF, 0x06, 0x74, 0x01, 0x0D, 0xF0, 0x97, 0x50,
  0xBF, 0x0C, 0x75, 0x09, 0xF0, 0xD0, 0x17, 0x40, 0x6F, 0x0E, 0x03, 0x74, 0x03, 0xF9, 0x05, 0x75,
  0x06, 0xF0, 0xE0, 0x17, 0x60, 0xDF, 0x0B, 0x76, 0x02, 0x0E, 0xF0, 0x97, 0x60, 0x3F, 0x90, 0x67,
  0x60, 0x6F, 0x90, 0x37, 0x60, 0x8F, 0x0E, 0x02, 0x76, 0x0B, 0xF0, 0xC7, 0x70, 0xCF, 0x0A, 0x76,
  0x02, 0x0E, 0xF0, 0x77, 0x60, 0x3F, 0x90, 0x57, 0x60, 0x5F, 0x0E, 0x02, 0x76, 0x08, 0xF0, 0xD0,
  0x17, 0x60, 0xAF, 0x0B, 0x77, 0x0C, 0xF0, 0x97, 0x60, 0x10, 0xEF, 0x06, 0x76, 0x03, 0xF0, 0xE0,
  0x17, 0x60, 0x5D, 0x0B, 0x02, 0x77, 0x10, 0x8A, 0x0D, 0x04, 0x77, 0x40, 0x90, 0x75,
  // "›" (U+203A)
  0x50, 0x70, 0x97, 0x74, 0x04, 0x0D, 0xA0, 0x87, 0x71, 0x02, 0x0B, 0xD0, 0x57, 0x60, 0x10, 0xEF,
  0x03, 0x76, 0x06, 0xF0, 0xE0, 0x17, 0x60, 0x9F, 0x0C, 0x77, 0x0B, 0xF0, 0xA7, 0x60, 0x10, 0xDF,
  0x08, 0x76, 0x03, 0x0E, 0xF0, 0x57, 0x60, 0x5F, 0x90, 0x37, 0x60, 0x8F, 0x0E, 0x02, 0x76, 0x0A,
  0xF0, 0xC7, 0x70, 0xCF, 0x0B, 0x76, 0x02, 0x0E, 0xF0, 0x87, 0x60, 0x4F, 0x90, 0x67, 0x60, 0x6F,
  0x90, 0x37, 0x60, 0x9F, 0x0E, 0x02, 0x76, 0x0B, 0xF0, 0xD7, 0x60, 0x10, 0xEF, 0x06, 0x75, 0x05,
  0xF9, 0x03, 0x74, 0x03, 0x0E, 0xF0, 0x67, 0x40, 0x10, 0xDF, 0x09, 0x75, 0x0C, 0xF0, 0xB7, 0x50,
  0x9F, 0x0D, 0x01, 0x74, 0x06, 0xF0, 0xE0, 0x27, 0x40, 0x4F, 0x90, 0x47, 0x40, 0x20, 0xEF, 0x06,
  0x75, 0x0D, 0xF0, 0x97, 0x50, 0xAF, 0x0B, 0x75, 0x08, 0xF0, 0xD0, 0x17, 0x40, 0x5F, 0x0E, 0x02,
  0x74, 0x03, 0xF9, 0x03, 0x74, 0x01, 0x0D, 0xF0, 0x67, 0x50, 0xCF, 0x08, 0x75, 0x01, 0x09, 0xE0,
  0xB7, 0x71, 0x03, 0x0C, 0xB0, 0xC7, 0x74, 0x82, 0x5D, 0xE2, 0x77, 0x60, 0x27, 0x71,
  // "⁄" (U+2044)
  0x77, 0x76, 0x0E, 0xD0, 0xD7, 0x77, 0x50, 0x5E, 0x07, 0x77, 0x75, 0x0C, 0xD0, 0xE0, 0x17, 0x77,
  0x40, 0x3E, 0x09, 0x77, 0x75, 0x0A, 0xE0, 0x27, 0x77, 0x40, 0x1E, 0x0B, 0x77, 0x75, 0x08, 0xE0,
  0x57, 0x77, 0x50, 0xED, 0x0D, 0x77, 0x75, 0x05, 0xE0, 0x77, 0x77, 0x50, 0xCE, 0x01, 0x77, 0x74,
  0x03, 0xE0, 0x97, 0x77, 0x50, 0xAE, 0x03, 0x77, 0x74, 0x01, 0xE0, 0xB7, 0x77, 0x50, 0x7E, 0x05,
  0x77, 0x75, 0x0E, 0xD0, 0xD7, 0x77, 0x50, 0x5E, 0x07, 0x77, 0x75, 0x0C, 0xE0, 0x17, 0x77, 0x40,
  0x3E, 0x09, 0x77, 0x75, 0x0A, 0xE0, 0x37, 0x77, 0x40, 0x1E, 0x0C, 0x77, 0x75, 0x07, 0xE0, 0x57,
  0x77, 0x50, 0xED, 0x0E, 0x77, 0x75, 0x05, 0xE0, 0x77, 0x77, 0x50, 0xCE, 0x01, 0x77, 0x74, 0x03,
  0xE0, 0xA7, 0x77, 0x50, 0x9E, 0x03, 0x77, 0x74, 0x01, 0xE0, 0xC7, 0x77, 0x50, 0x7E, 0x05, 0x77,
  0x75, 0x0D, 0xD0, 0xE7, 0x77, 0x50, 0x5E, 0x08, 0x77, 0x75, 0x0C, 0xE0, 0x17, 0x77, 0x40, 0x3E,
  0x0A, 0x77, 0x75, 0x09, 0xE0, 0x37, 0x77, 0x40, 0x1E, 0x0C, 0x77, 0x75, 0x07, 0xE0, 0x67, 0x77,
  0x50, 0xDD, 0x0E, 0x77, 0x75, 0x05, 0xE0, 0x87, 0x77, 0x50, 0xBE, 0x01, 0x77, 0x74, 0x03, 0xE0,
  0xA7, 0x77, 0x50, 0x9E, 0x04, 0x77, 0x74, 0x01, 0xE0, 0xD7, 0x77, 0x50, 0x7E, 0x06, 0x77, 0x75,
  0x0D, 0xD0, 0xE7, 0x77, 0x50, 0x5E, 0x08, 0x77, 0x75, 0x0B, 0xE0, 0x27, 0x77, 0x40, 0x2E, 0x0B,
  0x77, 0x75, 0x09, 0xE0, 0x47, 0x77, 0x40, 0x1E, 0x0D, 0x77, 0x75, 0x07, 0xE0, 0x67, 0x77, 0x50,
  0xDD, 0x0E, 0x77, 0x75, 0x05, 0xE0, 0x87, 0x77, 0x50, 0xBE, 0x02, 0x77, 0x74, 0x02, 0xE0, 0xB7,
  0x77, 0x50, 0x9E, 0x04, 0x77, 0x74, 0x01, 0x0E, 0xD0, 0xD7, 0x77, 0x50, 0x7E, 0x06, 0x77, 0x75,
  0x0D, 0xD0, 0xE0, 0x17, 0x77, 0x40, 0x4E, 0x09, 0x77, 0x75, 0x0B, 0xE0, 0x27, 0x77, 0x40, 0x2E,
  0x0B, 0x77, 0x75, 0x09, 0xE0, 0x47, 0x77, 0x40, 0x10, 0xED, 0x0D, 0x77, 0x75, 0x07, 0xE0, 0x77,
  0x77, 0x50, 0xDE, 0x01, 0x77, 0x75,
  // "™" (U+2122)
  0x0C, 0x80, 0xA1, 0xD0, 0x32, 0x04, 0x80, 0x4D, 0x03, 0x73, 0x02, 0x80, 0x4D, 0x01, 0x0E, 0xFF,
  0xF0, 0x32, 0x05, 0xF9, 0x06, 0x73, 0x06, 0xF9, 0x01, 0x0E, 0xFF, 0xF0, 0x32, 0x05, 0xF9, 0x0A,
  0x73, 0x0A, 0xF9, 0x01, 0x0E, 0xFF, 0xF0, 0x32, 0x05, 0xF9, 0x0E, 0x73, 0x0E, 0xF9, 0x01, 0x0E,
  0xFF, 0xF0, 0x32, 0x05, 0xFA, 0x02, 0x71, 0x02, 0xFA, 0x01, 0x71, 0x05, 0xD0, 0x47, 0x30, 0x5F,
  0xA0, 0x57, 0x10, 0x6F, 0xA0, 0x17, 0x10, 0x5D, 0x04, 0x73, 0x05, 0xFA, 0x09, 0x71, 0x0A, 0xFA,
  0x01, 0x71, 0x05, 0xD0, 0x47, 0x30, 0x5C, 0x00, 0xEB, 0x0D, 0x71, 0x0D, 0xB0, 0xDD, 0x01, 0x71,
  0x05, 0xD0, 0x47, 0x30, 0x5C, 0x0D, 0x09, 0xC0, 0x16, 0x02, 0xC0, 0x7D, 0x01, 0x71, 0x05, 0xD0,
  0x47, 0x30, 0x5C, 0x0D, 0x05, 0xC0, 0x46, 0x06, 0xB0, 0xB0, 0x7D, 0x01, 0x71, 0x05, 0xD0, 0x47,
  0x30, 0x5C, 0x0E, 0x02, 0xC0, 0x86, 0x09, 0xB0, 0x70, 0x8D, 0x01, 0x71, 0x05, 0xD0, 0x47, 0x30,
  0x5D, 0x10, 0xDB, 0x0C, 0x60, 0xDB, 0x03, 0x09, 0xD0, 0x17, 0x10, 0x5D, 0x04, 0x73, 0x05, 0xD1,
  0x0A, 0xC5, 0x02, 0xB8, 0x1E, 0x09, 0xD0, 0x17, 0x10, 0x5D, 0x04, 0x73, 0x05, 0xD1, 0x06, 0xC0,
  0x34, 0x05, 0xB8, 0x1A, 0x0A, 0xD0, 0x17, 0x10, 0x5D, 0x04, 0x73, 0x05, 0xD0, 0x10, 0x2C, 0x07,
  0x40, 0x9B, 0x81, 0x60, 0xAD, 0x01, 0x71, 0x05, 0xD0, 0x47, 0x30, 0x5D, 0x81, 0x10, 0xEB, 0x0B,
  0x40, 0xDB, 0x81, 0x20, 0xAD, 0x01, 0x71, 0x05, 0xD0, 0x47, 0x30, 0x5D, 0x81, 0x10, 0xAB, 0x0E,
  0x30, 0x1B, 0x0E, 0x20, 0xAD, 0x01, 0x71, 0x05, 0xD0, 0x47, 0x30, 0x5D, 0x81, 0x10, 0x6C, 0x02,
  0x20, 0x5B, 0x0A, 0x20, 0xAD, 0x01, 0x71, 0x05, 0xD0, 0x47, 0x30, 0x5D, 0x81, 0x10, 0x3C, 0x06,
  0x20, 0x9B, 0x06, 0x20, 0xAD, 0x01, 0x71, 0x05, 0xD0, 0x47, 0x30, 0x5D, 0x01, 0x20, 0xEB, 0x0A,
  0x20, 0xDB, 0x02, 0x20, 0xAD, 0x01, 0x71, 0x05, 0xD0, 0x47, 0x30, 0x5D, 0x01, 0x20, 0xAB, 0x81,
  0xD0, 0x1B, 0x0D, 0x30, 0xAD, 0x01, 0x71, 0x05, 0xD0, 0x47, 0x30, 0x5D, 0x01, 0x20, 0x7C, 0x01,
  0x05, 0xB0, 0x93, 0x0A, 0xD0, 0x17, 0x10, 0x5D, 0x04, 0x73, 0x05, 0xD0, 0x12, 0x03, 0xC0, 0x50,
  0x9B, 0x05, 0x30, 0xAD, 0x01, 0x71, 0x05, 0xD0, 0x47, 0x30, 0x5D, 0x01, 0x30, 0xEB, 0x09, 0x0C,
  0xB0, 0x13, 0x0A, 0xD0, 0x17, 0x10, 0x5D, 0x04, 0x73, 0x05, 0xD0, 0x13, 0x0B, 0xB0, 0xDB, 0x0C,
  0x40, 0xAD, 0x01, 0x71, 0x05, 0xD0, 0x47, 0x30, 0x5D, 0x01, 0x30, 0x7F, 0x08, 0x40, 0xAD, 0x01,
  0x71, 0x05, 0xD0, 0x47, 0x30, 0x5D, 0x01, 0x30, 0x3F, 0x04, 0x40, 0xAD, 0x01, 0x71, 0x05, 0xD0,
  0x47, 0x30, 0x5D, 0x01, 0x4F, 0x50, 0xAD, 0x01, 0x71, 0x05, 0xD0, 0x47, 0x30, 0x5D, 0x01, 0x40,
  0xBD, 0x0B, 0x50, 0xAD, 0x01, 0x71, 0x05, 0xD0, 0x47, 0x30, 0x5D, 0x01, 0x40, 0x7D, 0x07, 0x50,
  0xAD, 0x01, 0x71, 0x05, 0xD0, 0x47, 0x30, 0x5D, 0x01, 0x40, 0x4D, 0x03, 0x50, 0xAD, 0x01, 0x71,
  0x05, 0xD0, 0x47, 0x30, 0x5D, 0x6C, 0x0E, 0x60, 0xAD, 0x01,
  // "⅒" (U+2152)
  0x74, 0x01, 0x80, 0x27, 0x02, 0x80, 0xC0, 0x00, 0xED, 0x0D, 0x80, 0xF7, 0x00, 0x70, 0xEE, 0x04,
  0x77, 0x77, 0x70, 0x5E, 0x07, 0x80, 0xF5, 0x00, 0x50, 0xDF, 0x90, 0x47, 0x77, 0x77, 0x0C, 0xD0,
  0xE0, 0x18, 0x0F, 0x30, 0x03, 0x0B, 0xFB, 0x04, 0x77, 0x77, 0x60, 0x3E, 0x09, 0x80, 0xF2, 0x00,
  0x10, 0x9F, 0xD0, 0x47, 0x77, 0x76, 0x0A, 0xE0, 0x28, 0x0F, 0x10, 0x07, 0x0E, 0xFE, 0x04, 0x77,
  0x77, 0x50, 0x1E, 0x0B, 0x80, 0xF0, 0x00, 0x50, 0xDF, 0xA0, 0xDD, 0x04, 0x77, 0x77, 0x50, 0x8E,
  0x05, 0x80, 0xE7, 0x00, 0x7F, 0xB0, 0x70, 0x5D, 0x04, 0x77, 0x77, 0x50, 0xED, 0x0D, 0x80, 0xF1,
  0x00, 0xEF, 0x82, 0xD3, 0x06, 0xD0, 0x47, 0x77, 0x74, 0x05, 0xE0, 0x78, 0x0F, 0x10, 0x05, 0xD0,
  0xE0, 0x73, 0x07, 0xD0, 0x47, 0x77, 0x74, 0x0C, 0xE0, 0x18, 0x0F, 0x20, 0x0B, 0xB0, 0x90, 0x14,
  0x07, 0xD0, 0x47, 0x77, 0x73, 0x03, 0xE0, 0x98, 0x0F, 0x30, 0x82, 0x2F, 0xA2, 0x60, 0x7D, 0x04,
  0x77, 0x77, 0x30, 0xAE, 0x03, 0x80, 0xF4, 0x00, 0x17, 0x10, 0x8D, 0x04, 0x77, 0x77, 0x20, 0x1E,
  0x0B, 0x80, 0x98, 0x60, 0x08, 0xD0, 0x47, 0x77, 0x72, 0x07, 0xE0, 0x58, 0x09, 0x86, 0x00, 0x8D,
  0x04, 0x77, 0x77, 0x20, 0xED, 0x0D, 0x80, 0x98, 0x70, 0x08, 0xD0, 0x47, 0x77, 0x71, 0x05, 0xE0,
  0x78, 0x09, 0x87, 0x00, 0x8D, 0x04, 0x77, 0x77, 0x10, 0xCE, 0x01, 0x80, 0x98, 0x70, 0x08, 0xD0,
  0x47, 0x77, 0x70, 0x3E, 0x09, 0x80, 0x99, 0x00, 0x08, 0xD0, 0x47, 0x77, 0x70, 0xAE, 0x03, 0x80,
  0x99, 0x00, 0x08, 0xD0, 0x47, 0x77, 0x60, 0x1E, 0x0C, 0x80, 0x99, 0x10, 0x08, 0xD0, 0x47, 0x77,
  0x60, 0x7E, 0x05, 0x80, 0x99, 0x10, 0x08, 0xD0, 0x47, 0x77, 0x60, 0xED, 0x0E, 0x80, 0x99, 0x20,
  0x08, 0xD0, 0x47, 0x77, 0x50, 0x5E, 0x07, 0x80, 0x99, 0x20, 0x08, 0xD0, 0x47, 0x77, 0x50, 0xCE,
  0x01, 0x80, 0x99, 0x20, 0x08, 0xD0, 0x47, 0x77, 0x40, 0x3E, 0x0A, 0x80, 0xD2, 0x08, 0x32, 0x6A,
  0xCE, 0xA8, 0x3E, 0xCA, 0x61, 0x77, 0x70, 0x8D, 0x04, 0x77, 0x74, 0x09, 0xE0, 0x37, 0x73, 0x01,
  0x80, 0x27, 0x02, 0x77, 0x50, 0x30, 0xBF, 0xD0, 0xA0, 0x27, 0x75, 0x08, 0xD0, 0x47, 0x77, 0x30,
  0x1E, 0x0C, 0x77, 0x30, 0x70, 0xEE, 0x04, 0x77, 0x40, 0x9F, 0xFA, 0x07, 0x77, 0x40, 0x8D, 0x04,
  0x77, 0x73, 0x07, 0xE0, 0x57, 0x71, 0x05, 0x0D, 0xF9, 0x04, 0x77, 0x30, 0xBF, 0xFC, 0x0A, 0x77,
  0x30, 0x8D, 0x04, 0x77, 0x73, 0x0D, 0xD0, 0xE7, 0x70, 0x30, 0xBF, 0xB0, 0x47, 0x72, 0x0A, 0xFF,
  0xE0, 0x97, 0x72, 0x08, 0xD0, 0x47, 0x77, 0x20, 0x5E, 0x08, 0x75, 0x01, 0x09, 0xFD, 0x04, 0x77,
  0x10, 0x6F, 0x98, 0x4A, 0x75, 0x57, 0xBF, 0x90, 0x57, 0x71, 0x08, 0xD0, 0x47, 0x77, 0x20, 0xCE,
  0x01, 0x74, 0x07, 0x0E, 0xFE, 0x04, 0x77, 0x10, 0xEE, 0x0A, 0x01, 0x60, 0x10, 0xBE, 0x0E, 0x77,
  0x10, 0x8D, 0x04, 0x77, 0x71, 0x03, 0xE0, 0xA7, 0x30, 0x50, 0xDF, 0xA0, 0xDD, 0x04, 0x77, 0x07,
  0xE0, 0x87, 0x30, 0x9E, 0x07, 0x77, 0x08, 0xD0, 0x47, 0x77, 0x10, 0x9E, 0x03, 0x72, 0x07, 0xFB,
  0x07, 0x05, 0xD0, 0x47, 0x70, 0xED, 0x0B, 0x75, 0x0B, 0xD0, 0xE5, 0x03, 0x80, 0x44, 0x0A, 0xD0,
  0x88, 0x05, 0x47, 0x50, 0x1E, 0x0C, 0x74, 0x0E, 0xF8, 0x2D, 0x30, 0x6D, 0x04, 0x76, 0x04, 0xE0,
  0x27, 0x50, 0x2E, 0x04, 0x40, 0xCF, 0xFF, 0xA0, 0xE7, 0x50, 0x7E, 0x06, 0x74, 0x05, 0xD0, 0xE0,
  0x73, 0x07, 0xD0, 0x47, 0x60, 0x9D, 0x0B, 0x77, 0x0A, 0xD0, 0x94, 0x0C, 0xFF, 0xFA, 0x0E, 0x75,
  0x0D, 0xD0, 0xE7, 0x60, 0xBB, 0x09, 0x01, 0x40, 0x7D, 0x04, 0x76, 0x0E, 0xD0, 0x57, 0x70, 0x4D,
  0x0D, 0x40, 0xCF, 0xFF, 0xA0, 0xE7, 0x40, 0x5E, 0x08, 0x76, 0x82, 0x2F, 0xA2, 0x60, 0x7D, 0x04,
  0x75, 0x01, 0xE0, 0x17, 0x71, 0xE0, 0x13, 0x0C, 0xFF, 0xFA, 0x0E, 0x74, 0x0B, 0xE0, 0x17, 0x70,
  0x17, 0x10, 0x8D, 0x04, 0x75, 0x04, 0xD0, 0xD7, 0x72, 0x0B, 0xD0, 0x43, 0x0C, 0xFF, 0xFA, 0x0E,
  0x73, 0x03, 0xE0, 0xA7, 0x77, 0x30, 0x8D, 0x04, 0x75, 0x07, 0xD0, 0xB7, 0x72, 0x09, 0xD0, 0x68,
  0x0C, 0x20, 0x09, 0xE0, 0x47, 0x77, 0x30, 0x8D, 0x04, 0x75, 0x09, 0xD0, 0x97, 0x72, 0x07, 0xD0,
  0x88, 0x0C, 0x10, 0x01, 0xE0, 0xD7, 0x77, 0x40, 0x8D, 0x04, 0x75, 0x0A, 0xD0, 0x77, 0x72, 0x05,
  0xD0, 0x98, 0x0C, 0x10, 0x07, 0xE0, 0x67, 0x77, 0x40, 0x8D, 0x04, 0x75, 0x0B, 0xD0, 0x77, 0x72,
  0x04, 0xD0, 0xA8, 0x0C, 0x10, 0x0D, 0xD0, 0xE7, 0x77, 0x50, 0x8D, 0x04, 0x75, 0x0C, 0xD0, 0x67,
  0x72, 0x03, 0xD0, 0xB8, 0x0C, 0x00, 0x05, 0xE0, 0x87, 0x77, 0x50, 0x8D, 0x04, 0x75, 0x0C, 0xD0,
  0x57, 0x72, 0x03, 0xD0, 0xB8, 0x0C, 0x00, 0x0B, 0xE0, 0x27, 0x77, 0x50, 0x8D, 0x04, 0x75, 0x0C,
  0xD0, 0x57, 0x72, 0x03, 0xD0, 0xB7, 0x77, 0x77, 0x02, 0xE0, 0xB7, 0x77, 0x60, 0x8D, 0x04, 0x75,
  0x0C, 0xD0, 0x67, 0x72, 0x03, 0xD0, 0xB7, 0x77, 0x77, 0x09, 0xE0, 0x47, 0x77, 0x60, 0x8D, 0x04,
  0x75, 0x0B, 0xD0, 0x77, 0x72, 0x04, 0xD0, 0xA7, 0x77, 0x76, 0x01, 0xE0, 0xD7, 0x77, 0x70, 0x8D,
  0x04, 0x75, 0x0A, 0xD0, 0x77, 0x72, 0x05, 0xD0, 0x97, 0x77, 0x76, 0x07, 0xE0, 0x67, 0x77, 0x70,
  0x8D, 0x04, 0x75, 0x09, 0xD0, 0x97, 0x72, 0x07, 0xD0, 0x87, 0x77, 0x76, 0x0D, 0xD0, 0xE7, 0x77,
  0x71, 0x08, 0xD0, 0x47, 0x50, 0x7D, 0x0B, 0x77, 0x20, 0x9D, 0x06, 0x77, 0x77, 0x50, 0x5E, 0x08,
  0x77, 0x77, 0x10, 0x8D, 0x04, 0x75, 0x04, 0xD0, 0xD7, 0x72, 0x0B, 0xD0, 0x47, 0x77, 0x75, 0x0B,
  0xE0, 0x27, 0x77, 0x71, 0x08, 0xD0, 0x47, 0x50, 0x1E, 0x02, 0x77, 0x1E, 0x01, 0x77, 0x77, 0x40,
  0x2E, 0x0B, 0x77, 0x77, 0x20, 0x8D, 0x04, 0x76, 0x0D, 0xD0, 0x67, 0x70, 0x4D, 0x0D, 0x77, 0x77,
  0x50, 0x9E, 0x04, 0x77, 0x77, 0x20, 0x8D, 0x04, 0x76, 0x09, 0xD0, 0xB7, 0x70, 0xAD, 0x09, 0x77,
  0x77, 0x40, 0x10, 0xED, 0x0D, 0x77, 0x77, 0x30, 0x8D, 0x04, 0x76, 0x04, 0xE0, 0x27, 0x50, 0x1E,
  0x04, 0x77, 0x77, 0x40, 0x7E, 0x06, 0x77, 0x77, 0x30, 0x8D, 0x04, 0x77, 0x0D, 0xD0, 0xB7, 0x50,
  0xAD, 0x0D, 0x77, 0x77, 0x50, 0xDD, 0x0E, 0x01, 0x77, 0x77, 0x30, 0x8D, 0x04, 0x77, 0x06, 0xE0,
  0x87, 0x30, 0x7E, 0x07, 0x77, 0x77, 0x40, 0x4E, 0x09, 0x77, 0x77, 0x40, 0x8D, 0x04, 0x77, 0x10,
  0xDE, 0x0A, 0x01, 0x60, 0x10, 0x9E, 0x0E, 0x77, 0x77, 0x50, 0xBE, 0x02, 0x77, 0x72, 0x03, 0x80,
  0x44, 0x0A, 0xD0, 0x88, 0x05, 0x46, 0x04, 0xF9, 0x84, 0xA7, 0x55, 0x7A, 0xF9, 0x05, 0x77, 0x77,
  0x40, 0x2E, 0x0B, 0x77, 0x73, 0x0C, 0xFF, 0xFA, 0x0E, 0x70, 0x8F, 0xFE, 0x0A, 0x77, 0x77, 0x50,
  0x9E, 0x04, 0x77, 0x73, 0x0C, 0xFF, 0xFA, 0x0E, 0x71, 0x09, 0xFF, 0xC0, 0xB7, 0x77, 0x75, 0x01,
  0x0E, 0xD0, 0xD7, 0x77, 0x40, 0xCF, 0xFF, 0xA0, 0xE7, 0x20, 0x6F, 0xFA, 0x09, 0x77, 0x77, 0x60,
  0x7E, 0x07, 0x77, 0x74, 0x0C, 0xFF, 0xFA, 0x0E, 0x73, 0x02, 0x09, 0xFD, 0x0B, 0x03, 0x77, 0x77,
  0x70, 0xDE, 0x01, 0x77, 0x74, 0x0C, 0xFF, 0xFA, 0x0E, 0x75, 0x83, 0x16, 0x9C, 0xEA, 0x83, 0xED,
  0xA7, 0x27, 0x20,
  // "∂" (U+2202)
  0x77, 0x38, 0x95, 0x14, 0x7A, 0xCD, 0xEF, 0xED, 0xCB, 0x74, 0x17, 0x77, 0x58, 0x12, 0x8C, 0xFF,
  0x90, 0x90, 0x37, 0x77, 0x10, 0x50, 0xCF, 0xFE, 0x0A, 0x01, 0x77, 0x60, 0xCF, 0xFF, 0x90, 0xE0,
  0x37, 0x75, 0x0C, 0xFF, 0xFA, 0x0E, 0x04, 0x77, 0x40, 0xCF, 0xFF, 0xC0, 0x37, 0x73, 0x0C, 0xF8,
  0x5E, 0xCB, 0xAA, 0xCE, 0xFC, 0x0D, 0x01, 0x77, 0x20, 0xCC, 0x81, 0xC7, 0x37, 0x04, 0x0A, 0xFB,
  0x0A, 0x77, 0x28, 0x3C, 0xFE, 0x93, 0x75, 0x03, 0x0D, 0xFA, 0x03, 0x77, 0x18, 0x1C, 0xA1, 0x77,
  0x10, 0x10, 0xDF, 0x90, 0xB7, 0x71, 0x02, 0x77, 0x40, 0x10, 0xEF, 0x90, 0x27, 0x77, 0x76, 0x05,
  0xF9, 0x08, 0x77, 0x77, 0x70, 0xCF, 0x0D, 0x77, 0x77, 0x70, 0x4F, 0x90, 0x27, 0x77, 0x77, 0x0D,
  0xF0, 0x67, 0x77, 0x77, 0x08, 0xF0, 0x97, 0x77, 0x77, 0x03, 0xF0, 0xC8, 0x0C, 0x00, 0xF9, 0x80,
  0xC0, 0x00, 0xDF, 0x02, 0x77, 0x77, 0x70, 0xAF, 0x03, 0x77, 0x71, 0x00, 0x17, 0x40, 0x8F, 0x05,
  0x77, 0x28, 0x22, 0x7A, 0xDD, 0x82, 0xDB, 0x72, 0x60, 0x8F, 0x06, 0x77, 0x06, 0x0C, 0xFE, 0x0A,
  0x02, 0x40, 0x7F, 0x07, 0x75, 0x05, 0x0D, 0xFF, 0xB0, 0x73, 0x06, 0xF0, 0x77, 0x40, 0xAF, 0xFE,
  0x0A, 0x20, 0x6F, 0x07, 0x72, 0x02, 0x0D, 0xFF, 0xF9, 0x81, 0xA0, 0x6F, 0x07, 0x71, 0x02, 0x0E,
  0xFF, 0xFB, 0x00, 0x7F, 0x06, 0x70, 0x20, 0xEF, 0xB8, 0x2D, 0x73, 0x12, 0x81, 0x25, 0x9F, 0x0C,
  0xF0, 0x56, 0x01, 0x0D, 0xFA, 0x0D, 0x04, 0x72, 0x01, 0x0A, 0xFE, 0x05, 0x60, 0xAF, 0xA0, 0xA7,
  0x60, 0x7F, 0xD0, 0x45, 0x05, 0xFA, 0x08, 0x77, 0x10, 0x9F, 0xC0, 0x24, 0x01, 0x0E, 0xF9, 0x09,
  0x77, 0x30, 0xCF, 0xB5, 0x08, 0xF9, 0x0C, 0x77, 0x40, 0x3F, 0xA0, 0xE4, 0x01, 0xF9, 0x0E, 0x02,
  0x77, 0x50, 0xBF, 0x90, 0xC4, 0x08, 0xF9, 0x07, 0x77, 0x60, 0x5F, 0x90, 0xA4, 0x0E, 0xF0, 0xE7,
  0x77, 0x1F, 0x90, 0x83, 0x06, 0xF9, 0x07, 0x77, 0x70, 0x1F, 0x90, 0x53, 0x0B, 0xF0, 0xE7, 0x77,
  0x10, 0x4F, 0x90, 0x22, 0x01, 0xF9, 0x08, 0x77, 0x71, 0x07, 0xF0, 0xE3, 0x05, 0xF9, 0x03, 0x77,
  0x71, 0x0A, 0xF0, 0xB3, 0x09, 0xF0, 0xE7, 0x77, 0x20, 0xEF, 0x07, 0x30, 0xDF, 0x09, 0x77, 0x71,
  0x03, 0xF9, 0x03, 0x3F, 0x90, 0x57, 0x77, 0x10, 0x8F, 0x0E, 0x30, 0x3F, 0x90, 0x27, 0x77, 0x10,
  0xCF, 0x09, 0x30, 0x5F, 0x0E, 0x77, 0x71, 0x02, 0xF9, 0x04, 0x30, 0x7F, 0x0B, 0x77, 0x71, 0x08,
  0xF0, 0xE4, 0x09, 0xF0, 0xA7, 0x77, 0x10, 0xEF, 0x08, 0x40, 0x9F, 0x09, 0x77, 0x70, 0x6F, 0x90,
  0x24, 0x0A, 0xF0, 0x87, 0x77, 0x0D, 0xF0, 0xB5, 0x0A, 0xF0, 0x87, 0x76, 0x06, 0xF9, 0x05, 0x50,
  0x9F, 0x09, 0x77, 0x50, 0x10, 0xEF, 0x0C, 0x60, 0x8F, 0x0B, 0x77, 0x50, 0x9F, 0x90, 0x56, 0x06,
  0xF0, 0xE7, 0x74, 0x03, 0xF9, 0x0B, 0x70, 0x3F, 0x90, 0x27, 0x72, 0x01, 0x0D, 0xF9, 0x03, 0x71,
  0xF9, 0x07, 0x77, 0x20, 0xCF, 0x90, 0x87, 0x20, 0xBF, 0x0E, 0x77, 0x10, 0xBF, 0x90, 0xD7, 0x30,
  0x7F, 0x90, 0x87, 0x50, 0x10, 0xCF, 0xA0, 0x37, 0x30, 0x1F, 0xA0, 0x67, 0x30, 0x50, 0xEF, 0xA0,
  0x57, 0x50, 0x9F, 0xA0, 0xA0, 0x36, 0x05, 0x0C, 0xFB, 0x07, 0x76, 0x02, 0x0E, 0xFB, 0x83, 0xDB,
  0xAB, 0xCF, 0xD0, 0x87, 0x71, 0x06, 0xFF, 0xFD, 0x07, 0x77, 0x30, 0x9F, 0xFF, 0xA0, 0xE0, 0x47,
  0x75, 0x09, 0xFF, 0xF0, 0xB0, 0x17, 0x77, 0x06, 0x0E, 0xFF, 0xB0, 0xD0, 0x57, 0x77, 0x38, 0x11,
  0x8E, 0xFE, 0x0B, 0x05, 0x77, 0x77, 0x18, 0x34, 0x8B, 0xDE, 0xA8, 0x4E, 0xDB, 0x85, 0x17, 0x77,
  // "∆" (U+2206)
  0x77, 0x70, 0x5F, 0x90, 0x28, 0x0C, 0x60, 0x0A, 0xF9, 0x07, 0x80, 0xC6, 0x0F, 0xA0, 0xD8, 0x0C,
  0x50, 0x05, 0xFB, 0x03, 0x80, 0xC4, 0x00, 0xBF, 0xB0, 0x88, 0x0C, 0x30, 0x01, 0xFC, 0x0E, 0x80,
  0xC3, 0x00, 0x6F, 0xD0, 0x48, 0x0C, 0x20, 0x0C, 0xFD, 0x09, 0x80, 0xC1, 0x00, 0x2F, 0xE0, 0xE8,
  0x0C, 0x10, 0x07, 0xE0, 0xDF, 0x05, 0x80, 0xC0, 0x00, 0xDE, 0x07, 0x0C, 0xE0, 0xA7, 0x77, 0x77,
  0x03, 0xF0, 0x30, 0x8F, 0x01, 0x77, 0x77, 0x60, 0x8E, 0x81, 0xE0, 0x3F, 0x06, 0x77, 0x77, 0x60,
  0xEE, 0x0A, 0x20, 0xDE, 0x0B, 0x77, 0x77, 0x50, 0x4F, 0x05, 0x20, 0x8F, 0x02, 0x77, 0x77, 0x40,
  0x9F, 0x01, 0x20, 0x3F, 0x07, 0x77, 0x77, 0x40, 0xEE, 0x0B, 0x40, 0xDE, 0x0D, 0x77, 0x77, 0x30,
  0x5F, 0x06, 0x40, 0x8F, 0x03, 0x77, 0x77, 0x20, 0xAF, 0x01, 0x40, 0x3F, 0x08, 0x77, 0x77, 0x10,
  0x1F, 0x0B, 0x60, 0xDE, 0x0D, 0x77, 0x77, 0x10, 0x6F, 0x06, 0x60, 0x7F, 0x04, 0x77, 0x77, 0x0B,
  0xF0, 0x16, 0x02, 0xF0, 0x97, 0x77, 0x60, 0x1F, 0x0B, 0x71, 0x0C, 0xE0, 0xE7, 0x77, 0x60, 0x7F,
  0x05, 0x71, 0x06, 0xF0, 0x57, 0x77, 0x50, 0xCF, 0x01, 0x71, 0x01, 0xF0, 0xA7, 0x77, 0x40, 0x2F,
  0x0A, 0x73, 0x0B, 0xF0, 0x17, 0x77, 0x30, 0x8F, 0x05, 0x73, 0x06, 0xF0, 0x67, 0x77, 0x30, 0xDE,
  0x0E, 0x74, 0x01, 0xF0, 0xB7, 0x77, 0x20, 0x3F, 0x09, 0x75, 0x0B, 0xF0, 0x27, 0x77, 0x10, 0x9F,
  0x04, 0x75, 0x05, 0xF0, 0x77, 0x77, 0x10, 0xEE, 0x0E, 0x77, 0x0E, 0xE0, 0xD7, 0x77, 0x04, 0xF0,
  0x87, 0x70, 0xAF, 0x03, 0x77, 0x60, 0xAF, 0x03, 0x77, 0x05, 0xF0, 0x87, 0x76, 0x0E, 0xE0, 0xD7,
  0x72, 0x0E, 0xE0, 0xD7, 0x75, 0x05, 0xF0, 0x87, 0x72, 0x09, 0xF0, 0x47, 0x74, 0x0B, 0xF0, 0x27,
  0x72, 0x04, 0xF0, 0x97, 0x73, 0x01, 0xF0, 0xC7, 0x74, 0x0E, 0xE0, 0xE7, 0x73, 0x06, 0xF0, 0x77,
  0x74, 0x09, 0xF0, 0x57, 0x72, 0x0C, 0xF0, 0x17, 0x74, 0x03, 0xF0, 0xA7, 0x71, 0x02, 0xF0, 0xB7,
  0x76, 0x0D, 0xF0, 0x17, 0x70, 0x7F, 0x06, 0x77, 0x60, 0x8F, 0x06, 0x77, 0x0D, 0xF0, 0x17, 0x76,
  0x03, 0xF0, 0xB7, 0x60, 0x3F, 0x0A, 0x77, 0x71, 0x0D, 0xF0, 0x27, 0x50, 0x8F, 0x05, 0x77, 0x71,
  0x08, 0xF0, 0x77, 0x50, 0xDE, 0x0E, 0x77, 0x72, 0x02, 0xF0, 0xD7, 0x40, 0x4F, 0x0A, 0x77, 0x73,
  0x0C, 0xF0, 0x37, 0x30, 0x9F, 0x04, 0x77, 0x73, 0x07, 0xF0, 0x87, 0x30, 0xEE, 0x0E, 0x77, 0x74,
  0x02, 0xF0, 0xD7, 0x20, 0x5F, 0x09, 0x77, 0x75, 0x0C, 0xF0, 0x47, 0x10, 0xAF, 0x03, 0x77, 0x75,
  0x07, 0xF0, 0x97, 0x01, 0xF0, 0xD7, 0x77, 0x60, 0x1F, 0x0E, 0x70, 0x6F, 0x08, 0x77, 0x77, 0x0B,
  0xF0, 0x56, 0x0B, 0xF0, 0x27, 0x77, 0x70, 0x6F, 0x0A, 0x50, 0x1F, 0x0C, 0x77, 0x77, 0x10, 0x1F,
  0x90, 0x14, 0x07, 0xF0, 0x77, 0x77, 0x72, 0x0B, 0xF0, 0x64, 0x0C, 0xF0, 0x17, 0x77, 0x72, 0x05,
  0xF0, 0xB3, 0x02, 0xF0, 0xB7, 0x77, 0x74, 0xF9, 0x02, 0x20, 0x8F, 0x0C, 0x80, 0xB4, 0x80, 0xDF,
  0x07, 0x20, 0xD8, 0x0D, 0x4F, 0x81, 0xD0, 0x28, 0x0D, 0x6F, 0x02, 0x03, 0x80, 0xD6, 0xF0, 0x03,
  0x80, 0xD6, 0xF0, 0x03, 0x80, 0xD6, 0xF0, 0x03, 0x80, 0xD6, 0xF0, 0x30,
  // "√" (U+221A)
  0x80, 0xD2, 0x0E, 0x0E, 0x80, 0xD1, 0x00, 0x5E, 0x0A, 0x80, 0xD1, 0x00, 0xBE, 0x04, 0x80, 0xD0,
  0x00, 0x1E, 0x0E, 0x80, 0xD1, 0x00, 0x6E, 0x09, 0x80, 0xD1, 0x00, 0xBE, 0x03, 0x80, 0xD0, 0x00,
  0x1E, 0x0D, 0x80, 0xD1, 0x00, 0x7E, 0x08, 0x80, 0xD1, 0x00, 0xCE, 0x02, 0x80, 0xD0, 0x00, 0x2E,
  0x0C, 0x80, 0xD1, 0x00, 0x8E, 0x07, 0x80, 0xD1, 0x00, 0xDE, 0x01, 0x80, 0xD0, 0x00, 0x3E, 0x0B,
  0x80, 0xD1, 0x00, 0x8E, 0x06, 0x80, 0xD1, 0x00, 0xEE, 0x01, 0x80, 0xD0, 0x00, 0x4E, 0x0A, 0x80,
  0xD1, 0x00, 0x9E, 0x05, 0x80, 0xD1, 0x00, 0xED, 0x0E, 0x80, 0xD1, 0x00, 0x4E, 0x09, 0x80, 0xD1,
  0x00, 0xAE, 0x04, 0x80, 0xD1, 0x00, 0xED, 0x0D, 0x80, 0xD1, 0x00, 0x5E, 0x08, 0x80, 0xD1, 0x00,
  0xBE, 0x03, 0x80, 0xD0, 0x00, 0x1E, 0x0D, 0x80, 0xD1, 0x00, 0x6E, 0x07, 0x80, 0xD1, 0x00, 0xBE,
  0x02, 0x80, 0xD0, 0x00, 0x1E, 0x0B, 0x80, 0xD1, 0x00, 0x7E, 0x06, 0x80, 0xD1, 0x00, 0xCE, 0x01,
  0x80, 0xD0, 0x00, 0x2E, 0x0A, 0x80, 0xD1, 0x00, 0x8E, 0x05, 0x80, 0xD1, 0x00, 0xDD, 0x0E, 0x80,
  0xD1, 0x00, 0x3E, 0x09, 0x80, 0xD1, 0x00, 0x8E, 0x04, 0x74, 0x03, 0x80, 0x90, 0x80, 0x47, 0x76,
  0x0E, 0xD0, 0xE7, 0x50, 0x5F, 0xD0, 0xD7, 0x75, 0x04, 0xE0, 0x87, 0x50, 0x5F, 0xE0, 0x27, 0x74,
  0x09, 0xE0, 0x37, 0x50, 0x5F, 0xE0, 0x87, 0x74, 0x0E, 0xD0, 0xD7, 0x60, 0x5F, 0xE0, 0xD7, 0x73,
  0x04, 0xE0, 0x77, 0x60, 0x5F, 0xF0, 0x37, 0x72, 0x0A, 0xE0, 0x27, 0x60, 0x5F, 0xF0, 0x87, 0x72,
  0x0E, 0xD0, 0xC7, 0x77, 0x10, 0x4E, 0x0D, 0x77, 0x10, 0x5E, 0x06, 0x77, 0x72, 0x0E, 0xE0, 0x37,
  0x70, 0xBE, 0x01, 0x77, 0x72, 0x08, 0xE0, 0x87, 0x60, 0x1E, 0x0B, 0x77, 0x73, 0x03, 0xE0, 0xD7,
  0x60, 0x6E, 0x05, 0x77, 0x74, 0x0D, 0xE0, 0x37, 0x50, 0xBE, 0x77, 0x75, 0x07, 0xE0, 0x97, 0x40,
  0x1E, 0x0A, 0x77, 0x75, 0x02, 0xE0, 0xE7, 0x40, 0x7E, 0x04, 0x77, 0x76, 0x0C, 0xE0, 0x47, 0x30,
  0xCD, 0x0E, 0x77, 0x77, 0x06, 0xE0, 0x97, 0x20, 0x2E, 0x09, 0x77, 0x77, 0x01, 0xE0, 0xE7, 0x20,
  0x7E, 0x03, 0x77, 0x77, 0x10, 0xAE, 0x04, 0x71, 0x0D, 0xD0, 0xD7, 0x77, 0x72, 0x05, 0xE0, 0x97,
  0x03, 0xE0, 0x87, 0x77, 0x73, 0x0E, 0xD0, 0xE7, 0x08, 0xE0, 0x27, 0x77, 0x73, 0x09, 0xE0, 0x46,
  0x0D, 0xD0, 0xC7, 0x77, 0x74, 0x04, 0xE0, 0xA5, 0x04, 0xE0, 0x77, 0x77, 0x75, 0x0E, 0xD0, 0xE5,
  0x09, 0xE0, 0x17, 0x77, 0x75, 0x08, 0xE0, 0x54, 0x0E, 0xD0, 0xB7, 0x77, 0x76, 0x03, 0xE0, 0xA3,
  0x04, 0xE0, 0x67, 0x77, 0x77, 0x0D, 0xD0, 0xE3, 0x0A, 0xE0, 0x17, 0x77, 0x77, 0x07, 0xE0, 0x52,
  0x0E, 0xD0, 0xA8, 0x0C, 0x00, 0x02, 0xE8, 0x1A, 0x05, 0xE0, 0x58, 0x0C, 0x10, 0x0C, 0xE0, 0x10,
  0xBD, 0x0E, 0x80, 0xC2, 0x00, 0x6E, 0x07, 0xE0, 0x98, 0x0C, 0x20, 0x01, 0xFE, 0x04, 0x80, 0xC3,
  0x00, 0xBF, 0xC0, 0xE8, 0x0C, 0x40, 0x05, 0xFC, 0x08, 0x80, 0xC5, 0x00, 0xEF, 0xB0, 0x38, 0x0C,
  0x50, 0x09, 0xFA, 0x0D, 0x80, 0xC6, 0x00, 0x4F, 0xA0, 0x78, 0x0C, 0x70, 0x0E, 0xF9, 0x02, 0x80,
  0xC7, 0x00, 0x8F, 0x0C, 0x80, 0xD0, 0x00, 0x3F, 0x06, 0x80, 0xD1, 0x00, 0xDE, 0x01, 0x80, 0xD1,
  0x00, 0x7D, 0x0B, 0x77, 0x75,
  // "∞" (U+221E)
  0x72, 0x87, 0x26, 0x9A, 0xBA, 0x85, 0x17, 0x74, 0x87, 0x15, 0x9A, 0xBA, 0x86, 0x27, 0x72, 0x05,
  0x0C, 0xFA, 0x0A, 0x03, 0x77, 0x04, 0x0B, 0xFA, 0x0D, 0x05, 0x75, 0x01, 0x0B, 0xFE, 0x09, 0x75,
  0x09, 0xFE, 0x0C, 0x02, 0x72, 0x02, 0x0E, 0xFF, 0x90, 0xC0, 0x17, 0x20, 0xCF, 0xF9, 0x0E, 0x03,
  0x70, 0x20, 0xEF, 0xFB, 0x0D, 0x02, 0x70, 0xCF, 0xFB, 0x0E, 0x02, 0x60, 0xCF, 0xFD, 0x0D, 0x02,
  0x50, 0xBF, 0xFD, 0x0D, 0x50, 0x7F, 0x86, 0xB5, 0x10, 0x13, 0x7D, 0xE0, 0xD4, 0x0A, 0xE8, 0x1C,
  0x62, 0x28, 0x12, 0x6C, 0xF0, 0x93, 0x01, 0xF0, 0x57, 0x10, 0x8E, 0x0A, 0x20, 0x6E, 0x07, 0x71,
  0x07, 0xF0, 0x12, 0x07, 0xE0, 0x47, 0x30, 0x6E, 0x06, 0x03, 0xE0, 0x57, 0x30, 0x7E, 0x08, 0x20,
  0xCD, 0x09, 0x75, 0x08, 0xD0, 0xE0, 0xDD, 0x07, 0x75, 0x0B, 0xD8, 0x1C, 0x01, 0xE0, 0x27, 0x60,
  0xAF, 0xB0, 0xA7, 0x60, 0x3E, 0x01, 0x04, 0xD0, 0xC7, 0x71, 0x0D, 0xF9, 0x0D, 0x01, 0x77, 0x0D,
  0xD0, 0x40, 0x6D, 0x09, 0x77, 0x10, 0x3F, 0x90, 0x47, 0x71, 0x09, 0xD0, 0x50, 0x7D, 0x08, 0x77,
  0x20, 0x8E, 0x0A, 0x77, 0x20, 0x8D, 0x06, 0x08, 0xD0, 0x87, 0x72, 0x01, 0xE0, 0x37, 0x72, 0x08,
  0xD0, 0x60, 0x7D, 0x09, 0x77, 0x20, 0x7E, 0x0B, 0x77, 0x20, 0x9D, 0x00, 0x5D, 0x0C, 0x77, 0x10,
  0x3F, 0x90, 0x77, 0x71, 0x0C, 0xD0, 0x03, 0xE0, 0x17, 0x70, 0xDF, 0xA0, 0x37, 0x60, 0x2E, 0x81,
  0x10, 0xED, 0x08, 0x76, 0x0A, 0xFB, 0x0D, 0x01, 0x75, 0x09, 0xD0, 0xC2, 0x0A, 0xE0, 0x37, 0x40,
  0x9D, 0x00, 0xDD, 0x0C, 0x01, 0x73, 0x05, 0xE0, 0x72, 0x04, 0xE0, 0xE0, 0x37, 0x20, 0xAE, 0x00,
  0x3E, 0x0C, 0x02, 0x71, 0x05, 0xF0, 0x13, 0x0C, 0xF0, 0x90, 0x34, 0x81, 0x27, 0xEE, 0x07, 0x20,
  0x6F, 0x08, 0x03, 0x40, 0x40, 0xBF, 0x08, 0x40, 0x3F, 0xB8, 0x1E, 0xDE, 0xF9, 0x0A, 0x40, 0x8F,
  0xA0, 0xD0, 0xEF, 0xA0, 0xD6, 0x06, 0xFF, 0xD0, 0xA6, 0x09, 0xFF, 0xD0, 0x37, 0x07, 0xFF, 0xB0,
  0xA7, 0x10, 0x8F, 0xFB, 0x04, 0x72, 0x05, 0x0E, 0xFF, 0x08, 0x73, 0x06, 0x0E, 0xFE, 0x0D, 0x03,
  0x74, 0x01, 0x09, 0xFC, 0x0C, 0x03, 0x75, 0x02, 0x0A, 0xFC, 0x08, 0x01, 0x77, 0x89, 0x11, 0x5A,
  0xCE, 0xFE, 0xDB, 0x73, 0x77, 0x28, 0x91, 0x17, 0xAD, 0xEF, 0xED, 0xA6, 0x17, 0x10,
  // "≈" (U+2248)
  0x71, 0x86, 0x35, 0x78, 0x76, 0x52, 0x77, 0x75, 0x00, 0x15, 0x81, 0x3A, 0xEF, 0xA8, 0x1B, 0x71,
  0x77, 0x78, 0x11, 0xD2, 0x30, 0x10, 0xAF, 0xF9, 0x0B, 0x05, 0x77, 0x48, 0x23, 0xDF, 0x22, 0x03,
  0x0E, 0xFF, 0xC8, 0x1E, 0x71, 0x77, 0x07, 0xB8, 0x12, 0x05, 0xFF, 0xFA, 0x0B, 0x05, 0x73, 0x03,
  0x0B, 0xC0, 0x02, 0xFF, 0xFD, 0x89, 0x0E, 0xA5, 0x21, 0x01, 0x36, 0xBE, 0x02, 0x03, 0x80, 0xC6,
  0xF0, 0x20, 0x3E, 0x89, 0x0B, 0x63, 0x10, 0x12, 0x69, 0xEF, 0xFF, 0xC8, 0x1E, 0x13, 0xC0, 0xB0,
  0x37, 0x30, 0x50, 0xAF, 0xFF, 0x98, 0x2E, 0x30, 0x3B, 0x06, 0x77, 0x81, 0x28, 0xEF, 0xFC, 0x0C,
  0x02, 0x28, 0x23, 0xFD, 0x27, 0x74, 0x05, 0x0B, 0xFF, 0x90, 0x84, 0x81, 0x3C, 0x17, 0x77, 0x81,
  0x17, 0xCF, 0xA8, 0x1E, 0x92, 0x50, 0x17, 0x77, 0x68, 0x63, 0x57, 0x88, 0x75, 0x38, 0x0B, 0xC6,
  0x08, 0x92, 0x26, 0xAD, 0xEF, 0xED, 0xC9, 0x63, 0x77, 0x73, 0x06, 0x02, 0x40, 0x20, 0xAF, 0xD8,
  0x1E, 0x93, 0x77, 0x68, 0x17, 0xF2, 0x30, 0x7F, 0xFB, 0x0C, 0x06, 0x77, 0x20, 0x10, 0xAA, 0x02,
  0x20, 0xBF, 0xFE, 0x81, 0xE9, 0x47, 0x50, 0x40, 0xEB, 0x81, 0x20, 0xCF, 0xFF, 0xB8, 0x1D, 0x72,
  0x70, 0x40, 0xBD, 0x02, 0x03, 0xFF, 0xFF, 0x85, 0xEB, 0x98, 0x9B, 0xEF, 0x02, 0x03, 0xF8, 0x5E,
  0xB9, 0x89, 0xBE, 0xFF, 0xFF, 0x02, 0x03, 0xD0, 0xB0, 0x47, 0x81, 0x27, 0xDF, 0xFF, 0xB8, 0x1A,
  0x03, 0xB0, 0xD0, 0x47, 0x50, 0x30, 0xAF, 0xFF, 0x09, 0x20, 0x3A, 0x09, 0x77, 0x28, 0x11, 0x7D,
  0xFF, 0xA0, 0xE0, 0x53, 0x81, 0x3F, 0x67, 0x76, 0x81, 0x39, 0xEF, 0xD0, 0x90, 0x14, 0x03, 0x05,
  0x77, 0x73, 0x83, 0x37, 0xAD, 0xEA, 0x83, 0xEC, 0xA6, 0x16,
  // "≠" (U+2260)
  0x77, 0x76, 0x81, 0x2C, 0x68, 0x0C, 0x30, 0x09, 0xA8, 0x1E, 0x81, 0x77, 0x77, 0x70, 0x10, 0xED,
  0x0A, 0x03, 0x77, 0x77, 0x50, 0x7F, 0x08, 0x77, 0x77, 0x50, 0xEF, 0x01, 0x77, 0x77, 0x40, 0x6F,
  0x09, 0x77, 0x77, 0x50, 0xDF, 0x02, 0x77, 0x77, 0x40, 0x5F, 0x0A, 0x77, 0x77, 0x50, 0xCF, 0x03,
  0x77, 0x77, 0x40, 0x4F, 0x0B, 0x77, 0x77, 0x50, 0xBF, 0x04, 0x77, 0x77, 0x40, 0x3F, 0x0C, 0x74,
  0x02, 0x80, 0xA1, 0x30, 0xBF, 0x07, 0x80, 0x63, 0x02, 0x0A, 0x80, 0xC4, 0xF0, 0x0A, 0x80, 0xC4,
  0xF0, 0x0A, 0x80, 0xC4, 0xF0, 0x0A, 0x80, 0xC4, 0xF0, 0x0A, 0x80, 0xC4, 0xF0, 0x0A, 0x80, 0xC4,
  0xF0, 0x0A, 0x80, 0xC4, 0xF0, 0xA7, 0x74, 0x07, 0xF0, 0x97, 0x77, 0x75, 0x0E, 0xF0, 0x27, 0x77,
  0x74, 0x06, 0xF0, 0xA7, 0x77, 0x75, 0x0D, 0xF0, 0x27, 0x77, 0x74, 0x05, 0xF0, 0xA7, 0x77, 0x75,
  0x0C, 0xF0, 0x37, 0x77, 0x74, 0x04, 0xF0, 0xB7, 0x77, 0x75, 0x0B, 0xF0, 0x47, 0x77, 0x74, 0x03,
  0xF0, 0xC7, 0x75, 0x02, 0x80, 0x91, 0x30, 0xBF, 0x07, 0x80, 0x96, 0x30, 0x20, 0xA8, 0x0C, 0x4F,
  0x00, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F,
  0x00, 0xA8, 0x0C, 0x4F, 0x00, 0xA8, 0x0C, 0x4F, 0x0A, 0x73, 0x06, 0xF0, 0x97, 0x77, 0x75, 0x0D,
  0xF0, 0x27, 0x77, 0x74, 0x05, 0xF0, 0xA7, 0x77, 0x75, 0x0C, 0xF0, 0x37, 0x77, 0x74, 0x04, 0xF0,
  0xB7, 0x77, 0x75, 0x0B, 0xF0, 0x37, 0x77, 0x74, 0x03, 0xF0, 0xC7, 0x77, 0x75, 0x0A, 0xF0, 0x47,
  0x77, 0x74, 0x02, 0xF0, 0xC7, 0x77, 0x75, 0x06, 0xF0, 0x57, 0x77, 0x76, 0x81, 0x18, 0xEB, 0x0D,
  0x80, 0xC2, 0x08, 0x25, 0xCF, 0x68, 0x0C, 0x40, 0x03, 0x77, 0x77, 0x10,
  // "≤" (U+2264)
  0x80, 0xC5, 0x08, 0x12, 0x93, 0x80, 0xC3, 0x00, 0x20, 0x9A, 0x03, 0x80, 0xC1, 0x00, 0x20, 0x9C,
  0x03, 0x77, 0x77, 0x70, 0x20, 0x9E, 0x03, 0x77, 0x77, 0x50, 0x20, 0x9F, 0x90, 0x37, 0x77, 0x73,
  0x02, 0x09, 0xFB, 0x03, 0x77, 0x77, 0x10, 0x20, 0x9F, 0xD0, 0x37, 0x77, 0x60, 0x20, 0x9F, 0xD0,
  0xD0, 0x57, 0x77, 0x50, 0x20, 0x9F, 0xD0, 0xC0, 0x57, 0x77, 0x50, 0x20, 0x9F, 0xD0, 0xB0, 0x47,
  0x77, 0x50, 0x20, 0x9F, 0xD0, 0xA0, 0x37, 0x77, 0x50, 0x20, 0x9F, 0xD0, 0xA0, 0x27, 0x77, 0x50,
  0x20, 0xAF, 0xD0, 0x90, 0x27, 0x77, 0x50, 0x20, 0xAF, 0xC8, 0x1E, 0x81, 0x77, 0x75, 0x02, 0x0A,
  0xFC, 0x81, 0xE7, 0x17, 0x77, 0x50, 0x20, 0xAF, 0xC0, 0xD0, 0x77, 0x77, 0x60, 0x20, 0xAF, 0xC0,
  0xD0, 0x67, 0x77, 0x60, 0x20, 0xAF, 0xC0, 0xC0, 0x57, 0x77, 0x60, 0x20, 0xAF, 0xC0, 0xC0, 0x47,
  0x77, 0x60, 0x20, 0xAF, 0xC0, 0xB0, 0x37, 0x77, 0x60, 0x20, 0xAF, 0xC0, 0xA0, 0x37, 0x77, 0x70,
  0x2F, 0xC0, 0x90, 0x27, 0x77, 0x72, 0x02, 0xF9, 0x81, 0xE8, 0x17, 0x77, 0x74, 0x02, 0xF9, 0x0C,
  0x05, 0x77, 0x77, 0x50, 0x2F, 0xB8, 0x1E, 0x81, 0x77, 0x77, 0x20, 0x10, 0xEF, 0xD0, 0xA0, 0x47,
  0x77, 0x72, 0x05, 0x0C, 0xFD, 0x81, 0xD6, 0x17, 0x77, 0x71, 0x04, 0x0A, 0xFD, 0x81, 0xE9, 0x37,
  0x77, 0x71, 0x81, 0x29, 0xEF, 0xD0, 0xC0, 0x57, 0x77, 0x71, 0x81, 0x17, 0xDF, 0xD8, 0x1E, 0x81,
  0x77, 0x77, 0x10, 0x50, 0xCF, 0xE0, 0xA0, 0x47, 0x77, 0x71, 0x03, 0x0A, 0xFE, 0x81, 0xD7, 0x17,
  0x77, 0x78, 0x11, 0x8E, 0xFD, 0x81, 0xE9, 0x37, 0x77, 0x71, 0x06, 0x0D, 0xFE, 0x0C, 0x05, 0x77,
  0x77, 0x10, 0x40, 0xBF, 0xE8, 0x1E, 0x82, 0x77, 0x77, 0x02, 0x09, 0xFF, 0x0A, 0x04, 0x77, 0x77,
  0x81, 0x17, 0xEF, 0xE8, 0x1D, 0x71, 0x77, 0x77, 0x05, 0x0C, 0xFF, 0x02, 0x77, 0x77, 0x10, 0x40,
  0xAF, 0xD0, 0x37, 0x77, 0x73, 0x81, 0x28, 0xEF, 0xA0, 0x37, 0x77, 0x75, 0x81, 0x17, 0xDF, 0x03,
  0x80, 0xC0, 0x00, 0x50, 0xCD, 0x03, 0x80, 0xC2, 0x00, 0x30, 0xAB, 0x03, 0x80, 0xC4, 0x08, 0x21,
  0x8E, 0x38, 0x0A, 0xD5, 0x08, 0x0C, 0x66, 0x01, 0x02, 0x80, 0xC6, 0xF0, 0x30, 0x28, 0x0C, 0x6F,
  0x03, 0x02, 0x80, 0xC6, 0xF0, 0x30, 0x28, 0x0C, 0x6F, 0x03, 0x02, 0x80, 0xC6, 0xF0, 0x30, 0x28,
  0x0C, 0x6F, 0x03,
  // "≥" (U+2265)
  0x81, 0x39, 0x28, 0x0C, 0x50, 0x03, 0xA0, 0x90, 0x28, 0x0C, 0x30, 0x03, 0xC0, 0x90, 0x28, 0x0C,
  0x10, 0x03, 0xE0, 0x90, 0x27, 0x77, 0x77, 0x03, 0xF9, 0x09, 0x02, 0x77, 0x77, 0x50, 0x3F, 0xB0,
  0x90, 0x27, 0x77, 0x73, 0x03, 0xFD, 0x09, 0x02, 0x77, 0x77, 0x20, 0x50, 0xDF, 0xD0, 0x90, 0x27,
  0x77, 0x72, 0x05, 0x0C, 0xFD, 0x09, 0x02, 0x77, 0x77, 0x20, 0x40, 0xBF, 0xD0, 0x90, 0x27, 0x77,
  0x72, 0x03, 0x0B, 0xFD, 0x09, 0x02, 0x77, 0x77, 0x20, 0x20, 0xAF, 0xD0, 0xA0, 0x27, 0x77, 0x72,
  0x02, 0x09, 0xFD, 0x0A, 0x02, 0x77, 0x77, 0x28, 0x11, 0x8E, 0xFC, 0x0A, 0x02, 0x77, 0x77, 0x28,
  0x11, 0x7E, 0xFC, 0x0A, 0x02, 0x77, 0x77, 0x30, 0x70, 0xDF, 0xC0, 0xA0, 0x27, 0x77, 0x73, 0x06,
  0x0D, 0xFC, 0x0A, 0x02, 0x77, 0x77, 0x30, 0x50, 0xCF, 0xC0, 0xA0, 0x27, 0x77, 0x73, 0x04, 0x0C,
  0xFC, 0x0A, 0x02, 0x77, 0x77, 0x30, 0x30, 0xBF, 0xC0, 0xA0, 0x27, 0x77, 0x73, 0x03, 0x0A, 0xFC,
  0x0A, 0x02, 0x77, 0x77, 0x30, 0x20, 0x9F, 0xC0, 0x27, 0x77, 0x74, 0x81, 0x19, 0xEF, 0x90, 0x27,
  0x77, 0x75, 0x05, 0x0C, 0xF9, 0x02, 0x77, 0x77, 0x28, 0x11, 0x8E, 0xFB, 0x02, 0x77, 0x77, 0x04,
  0x0A, 0xFD, 0x0E, 0x01, 0x77, 0x74, 0x81, 0x16, 0xDF, 0xD0, 0xC0, 0x67, 0x77, 0x48, 0x13, 0x9E,
  0xFD, 0x0A, 0x04, 0x77, 0x74, 0x05, 0x0C, 0xFD, 0x81, 0xE9, 0x27, 0x77, 0x38, 0x11, 0x8E, 0xFD,
  0x81, 0xD7, 0x17, 0x77, 0x30, 0x40, 0xAF, 0xE0, 0xC0, 0x57, 0x77, 0x38, 0x11, 0x7D, 0xFE, 0x0A,
  0x03, 0x77, 0x73, 0x81, 0x39, 0xEF, 0xD8, 0x1E, 0x81, 0x77, 0x73, 0x05, 0x0C, 0xFE, 0x0D, 0x06,
  0x77, 0x73, 0x81, 0x28, 0xEF, 0xE0, 0xB0, 0x47, 0x77, 0x30, 0x40, 0xAF, 0xF0, 0x90, 0x27, 0x77,
  0x28, 0x11, 0x7D, 0xFE, 0x81, 0xE7, 0x17, 0x77, 0x30, 0x2F, 0xF0, 0xC0, 0x57, 0x77, 0x60, 0x3F,
  0xD0, 0xA0, 0x47, 0x77, 0x71, 0x03, 0xFA, 0x81, 0xE9, 0x27, 0x77, 0x73, 0x03, 0xF8, 0x1D, 0x71,
  0x77, 0x77, 0x50, 0x3D, 0x0C, 0x05, 0x80, 0xC0, 0x00, 0x3B, 0x0A, 0x03, 0x80, 0xC2, 0x08, 0x23,
  0xE8, 0x18, 0x0B, 0xA4, 0x00, 0x18, 0x0C, 0x66, 0x10, 0x38, 0x0C, 0x6F, 0x02, 0x03, 0x80, 0xC6,
  0xF0, 0x20, 0x38, 0x0C, 0x6F, 0x02, 0x03, 0x80, 0xC6, 0xF0, 0x20, 0x38, 0x0C, 0x6F, 0x02, 0x03,
  0x80, 0xC6, 0xF0, 0x20,
};

const Font& font_NotoSansMono_Regular_90() {
  static SmoothFont font(font_NotoSansMono_Regular_90_data);
  return font;
}

}  // namespace roo_display
