#include "8.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSansMono-Regular (Noto Sans Mono Regular)
// Generated on Wed Nov 19 19:10:52 CET 2025
static const uint8_t font_NotoSansMono_Regular_8_data[] PROGMEM = {
  
  // Header
  0x01, 0x02, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x5D, 0x00, 0x00,
  0xFE, 0xFE, 0x0C, 0x0A, 0x07, 0xFE, 0x04, 0x00, 0x0E, 0x04, 0x05, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x42, 0x01, 0x02, 0x07, 0x05, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x41, 0x05, 0x03, 0x07, 0x05, 0x00, 0x04, // """ (U+0022)
  0x00, 0x23, 0x40, 0x01, 0x04, 0x07, 0x05, 0x00, 0x09, // "#" (U+0023)
  0x00, 0x24, 0x40, 0x00, 0x04, 0x07, 0x05, 0x00, 0x1B, // "$" (U+0024)
  0x00, 0x25, 0x40, 0x01, 0x04, 0x07, 0x05, 0x00, 0x2F, // "%" (U+0025)
  0x00, 0x26, 0x40, 0x01, 0x04, 0x07, 0x05, 0x00, 0x41, // "&" (U+0026)
  0x00, 0x27, 0x42, 0x05, 0x02, 0x07, 0x05, 0x00, 0x53, // "'" (U+0027)
  0x00, 0x28, 0x41, 0x00, 0x03, 0x07, 0x05, 0x00, 0x55, // "(" (U+0028)
  0x00, 0x29, 0x41, 0xFE, 0x03, 0x05, 0x05, 0x00, 0x61, // ")" (U+0029)
  0x00, 0x2A, 0x40, 0x04, 0x03, 0x07, 0x05, 0x00, 0x6D, // "*" (U+002A)
  0x00, 0x2B, 0x00, 0x02, 0x04, 0x05, 0x05, 0x00, 0x75, // "+" (U+002B)
  0x00, 0x2C, 0x41, 0x00, 0x02, 0x02, 0x05, 0x00, 0x7E, // "," (U+002C)
  0x00, 0x2D, 0x41, 0x03, 0x03, 0x03, 0x05, 0x00, 0x81, // "-" (U+002D)
  0x00, 0x2E, 0x42, 0x01, 0x02, 0x01, 0x05, 0x00, 0x83, // "." (U+002E)
  0x00, 0x2F, 0x41, 0x01, 0x03, 0x07, 0x05, 0x00, 0x84, // "/" (U+002F)
  0x00, 0x30, 0x40, 0x01, 0x04, 0x07, 0x05, 0x00, 0x8F, // "0" (U+0030)
  0x00, 0x31, 0x41, 0x01, 0x04, 0x07, 0x05, 0x00, 0xA1, // "1" (U+0031)
  0x00, 0x32, 0x40, 0x01, 0x04, 0x07, 0x05, 0x00, 0xAF, // "2" (U+0032)
  0x00, 0x33, 0x40, 0x01, 0x04, 0x07, 0x05, 0x00, 0xC1, // "3" (U+0033)
  0x00, 0x34, 0x40, 0x01, 0x04, 0x07, 0x05, 0x00, 0xD3, // "4" (U+0034)
  0x00, 0x35, 0x40, 0x01, 0x04, 0x07, 0x05, 0x00, 0xE5, // "5" (U+0035)
  0x00, 0x36, 0x40, 0x01, 0x04, 0x07, 0x05, 0x00, 0xF7, // "6" (U+0036)
  0x00, 0x37, 0x00, 0x01, 0x04, 0x07, 0x05, 0x01, 0x09, // "7" (U+0037)
  0x00, 0x38, 0x40, 0x01, 0x04, 0x07, 0x05, 0x01, 0x19, // "8" (U+0038)
  0x00, 0x39, 0x40, 0x01, 0x04, 0x07, 0x05, 0x01, 0x2B, // "9" (U+0039)
  0x00, 0x3A, 0x42, 0x01, 0x02, 0x05, 0x05, 0x01, 0x3D, // ":" (U+003A)
  0x00, 0x3B, 0x41, 0x00, 0x02, 0x05, 0x05, 0x01, 0x40, // ";" (U+003B)
  0x00, 0x3C, 0x41, 0x02, 0x04, 0x05, 0x05, 0x01, 0x46, // "<" (U+003C)
  0x00, 0x3D, 0x40, 0x03, 0x04, 0x05, 0x05, 0x01, 0x4E, // "=" (U+003D)
  0x00, 0x3E, 0x40, 0x02, 0x03, 0x05, 0x05, 0x01, 0x56, // ">" (U+003E)
  0x00, 0x3F, 0x40, 0x01, 0x03, 0x07, 0x05, 0x01, 0x5E, // "?" (U+003F)
  0x00, 0x40, 0x40, 0x00, 0x04, 0x07, 0x05, 0x01, 0x6C, // "@" (U+0040)
  0x00, 0x41, 0x40, 0x01, 0x04, 0x07, 0x05, 0x01, 0x80, // "A" (U+0041)
  0x00, 0x42, 0x40, 0x01, 0x04, 0x07, 0x05, 0x01, 0x92, // "B" (U+0042)
  0x00, 0x43, 0x00, 0x01, 0x04, 0x07, 0x05, 0x01, 0xA4, // "C" (U+0043)
  0x00, 0x44, 0x40, 0x01, 0x04, 0x07, 0x05, 0x01, 0xB5, // "D" (U+0044)
  0x00, 0x45, 0x40, 0x01, 0x04, 0x07, 0x05, 0x01, 0xC7, // "E" (U+0045)
  0x00, 0x46, 0x40, 0x01, 0x04, 0x07, 0x05, 0x01, 0xD9, // "F" (U+0046)
  0x00, 0x47, 0x40, 0x01, 0x04, 0x07, 0x05, 0x01, 0xEB, // "G" (U+0047)
  0x00, 0x48, 0x40, 0x01, 0x04, 0x07, 0x05, 0x01, 0xFD, // "H" (U+0048)
  0x00, 0x49, 0x40, 0x01, 0x03, 0x07, 0x05, 0x02, 0x0F, // "I" (U+0049)
  0x00, 0x4A, 0x00, 0x01, 0x03, 0x07, 0x05, 0x02, 0x1D, // "J" (U+004A)
  0x00, 0x4B, 0x40, 0x01, 0x04, 0x07, 0x05, 0x02, 0x29, // "K" (U+004B)
  0x00, 0x4C, 0x40, 0x01, 0x04, 0x07, 0x05, 0x02, 0x3B, // "L" (U+004C)
  0x00, 0x4D, 0x40, 0x01, 0x04, 0x07, 0x05, 0x02, 0x4D, // "M" (U+004D)
  0x00, 0x4E, 0x40, 0x01, 0x04, 0x07, 0x05, 0x02, 0x5F, // "N" (U+004E)
  0x00, 0x4F, 0x40, 0x01, 0x04, 0x07, 0x05, 0x02, 0x71, // "O" (U+004F)
  0x00, 0x50, 0x40, 0x01, 0x04, 0x07, 0x05, 0x02, 0x83, // "P" (U+0050)
  0x00, 0x51, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x02, 0x95, // "Q" (U+0051)
  0x00, 0x52, 0x40, 0x01, 0x04, 0x07, 0x05, 0x02, 0xAC, // "R" (U+0052)
  0x00, 0x53, 0x40, 0x01, 0x04, 0x07, 0x05, 0x02, 0xBE, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x04, 0x07, 0x05, 0x02, 0xD0, // "T" (U+0054)
  0x00, 0x55, 0x40, 0x01, 0x04, 0x07, 0x05, 0x02, 0xDD, // "U" (U+0055)
  0x00, 0x56, 0x40, 0x01, 0x04, 0x07, 0x05, 0x02, 0xEF, // "V" (U+0056)
  0x00, 0x57, 0x40, 0x01, 0x04, 0x07, 0x05, 0x03, 0x01, // "W" (U+0057)
  0x00, 0x58, 0x40, 0x01, 0x04, 0x07, 0x05, 0x03, 0x13, // "X" (U+0058)
  0x00, 0x59, 0x00, 0x01, 0x04, 0x07, 0x05, 0x03, 0x25, // "Y" (U+0059)
  0x00, 0x5A, 0x40, 0x01, 0x03, 0x07, 0x05, 0x03, 0x36, // "Z" (U+005A)
  0x00, 0x5B, 0x41, 0x00, 0x03, 0x07, 0x05, 0x03, 0x44, // "[" (U+005B)
  0x00, 0x5C, 0x41, 0x01, 0x03, 0x07, 0x05, 0x03, 0x50, // "\" (U+005C)
  0x00, 0x5D, 0x41, 0xFF, 0x03, 0x06, 0x05, 0x03, 0x5B, // "]" (U+005D)
  0x00, 0x5E, 0x40, 0x03, 0x04, 0x06, 0x05, 0x03, 0x67, // "^" (U+005E)
  0x00, 0x5F, 0x40, 0xFF, 0x04, 0xFF, 0x05, 0x03, 0x71, // "_" (U+005F)
  0x00, 0x60, 0x41, 0x07, 0x02, 0x08, 0x05, 0x03, 0x74, // "`" (U+0060)
  0x00, 0x61, 0x40, 0x01, 0x04, 0x05, 0x05, 0x03, 0x76, // "a" (U+0061)
  0x00, 0x62, 0x40, 0x01, 0x04, 0x07, 0x05, 0x03, 0x83, // "b" (U+0062)
  0x00, 0x63, 0x40, 0x01, 0x03, 0x05, 0x05, 0x03, 0x95, // "c" (U+0063)
  0x00, 0x64, 0x40, 0x01, 0x04, 0x07, 0x05, 0x03, 0x9F, // "d" (U+0064)
  0x00, 0x65, 0x40, 0x01, 0x04, 0x05, 0x05, 0x03, 0xB1, // "e" (U+0065)
  0x00, 0x66, 0x40, 0x01, 0x04, 0x07, 0x05, 0x03, 0xBE, // "f" (U+0066)
  0x00, 0x67, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x03, 0xD0, // "g" (U+0067)
  0x00, 0x68, 0x40, 0x01, 0x04, 0x07, 0x05, 0x03, 0xE2, // "h" (U+0068)
  0x00, 0x69, 0x00, 0x01, 0x04, 0x07, 0x05, 0x03, 0xF4, // "i" (U+0069)
  0x00, 0x6A, 0x40, 0xFF, 0x03, 0x07, 0x05, 0x04, 0x01, // "j" (U+006A)
  0x00, 0x6B, 0x40, 0x01, 0x04, 0x07, 0x05, 0x04, 0x13, // "k" (U+006B)
  0x00, 0x6C, 0x00, 0x01, 0x04, 0x07, 0x05, 0x04, 0x25, // "l" (U+006C)
  0x00, 0x6D, 0x40, 0x01, 0x04, 0x05, 0x05, 0x04, 0x33, // "m" (U+006D)
  0x00, 0x6E, 0x40, 0x01, 0x04, 0x05, 0x05, 0x04, 0x40, // "n" (U+006E)
  0x00, 0x6F, 0x40, 0x01, 0x04, 0x05, 0x05, 0x04, 0x4D, // "o" (U+006F)
  0x00, 0x70, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x04, 0x5A, // "p" (U+0070)
  0x00, 0x71, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x04, 0x6C, // "q" (U+0071)
  0x00, 0x72, 0x40, 0x01, 0x04, 0x05, 0x05, 0x04, 0x7E, // "r" (U+0072)
  0x00, 0x73, 0x40, 0x01, 0x03, 0x05, 0x05, 0x04, 0x8B, // "s" (U+0073)
  0x00, 0x74, 0x40, 0x01, 0x04, 0x07, 0x05, 0x04, 0x95, // "t" (U+0074)
  0x00, 0x75, 0x40, 0x01, 0x04, 0x05, 0x05, 0x04, 0xA7, // "u" (U+0075)
  0x00, 0x76, 0x40, 0x01, 0x04, 0x05, 0x05, 0x04, 0xB4, // "v" (U+0076)
  0x00, 0x77, 0x40, 0x01, 0x04, 0x05, 0x05, 0x04, 0xC1, // "w" (U+0077)
  0x00, 0x78, 0x40, 0x01, 0x04, 0x05, 0x05, 0x04, 0xCE, // "x" (U+0078)
  0x00, 0x79, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x04, 0xDB, // "y" (U+0079)
  0x00, 0x7A, 0x40, 0x01, 0x03, 0x05, 0x05, 0x04, 0xED, // "z" (U+007A)
  0x00, 0x7B, 0x41, 0x00, 0x03, 0x07, 0x05, 0x04, 0xF7, // "{" (U+007B)
  0x00, 0x7C, 0x02, 0xFF, 0x02, 0x07, 0x05, 0x05, 0x03, // "|" (U+007C)
  0x00, 0x7D, 0x41, 0xFE, 0x03, 0x05, 0x05, 0x05, 0x05, // "}" (U+007D)
  0x00, 0x7E, 0x40, 0x03, 0x04, 0x04, 0x05, 0x05, 0x11, // "~" (U+007E)
  0x00, 0xA1, 0x42, 0xFE, 0x02, 0x04, 0x05, 0x05, 0x16, // "¡" (U+00A1)
  0x00, 0xA2, 0x40, 0x01, 0x03, 0x07, 0x05, 0x05, 0x1A, // "¢" (U+00A2)
  0x00, 0xA3, 0x40, 0x01, 0x04, 0x07, 0x05, 0x05, 0x28, // "£" (U+00A3)
  0x00, 0xA4, 0x40, 0x02, 0x04, 0x05, 0x05, 0x05, 0x3A, // "¤" (U+00A4)
  0x00, 0xA5, 0x40, 0x01, 0x04, 0x07, 0x05, 0x05, 0x44, // "¥" (U+00A5)
  0x00, 0xA6, 0x02, 0xFF, 0x02, 0x07, 0x05, 0x05, 0x56, // "¦" (U+00A6)
  0x00, 0xA7, 0x40, 0x01, 0x03, 0x07, 0x05, 0x05, 0x5A, // "§" (U+00A7)
  0x00, 0xA8, 0x41, 0x07, 0x03, 0x07, 0x05, 0x05, 0x68, // "¨" (U+00A8)
  0x00, 0xA9, 0x40, 0x02, 0x04, 0x06, 0x05, 0x05, 0x6A, // "©" (U+00A9)
  0x00, 0xAA, 0x41, 0x04, 0x03, 0x06, 0x05, 0x05, 0x77, // "ª" (U+00AA)
  0x00, 0xAB, 0x40, 0x01, 0x03, 0x04, 0x05, 0x05, 0x7C, // "«" (U+00AB)
  0x00, 0xAC, 0x40, 0x02, 0x04, 0x04, 0x05, 0x05, 0x84, // "¬" (U+00AC)
  0x00, 0xAE, 0x40, 0x02, 0x04, 0x06, 0x05, 0x05, 0x8C, // "®" (U+00AE)
  0x00, 0xAF, 0x41, 0x06, 0x03, 0x06, 0x05, 0x05, 0x99, // "¯" (U+00AF)
  0x00, 0xB0, 0x41, 0x05, 0x03, 0x07, 0x05, 0x05, 0x9B, // "°" (U+00B0)
  0x00, 0xB1, 0x40, 0x01, 0x04, 0x05, 0x05, 0x05, 0xA0, // "±" (U+00B1)
  0x00, 0xB2, 0x41, 0x04, 0x03, 0x07, 0x05, 0x05, 0xAD, // "²" (U+00B2)
  0x00, 0xB3, 0x41, 0x04, 0x03, 0x07, 0x05, 0x05, 0xB3, // "³" (U+00B3)
  0x00, 0xB4, 0x42, 0x07, 0x03, 0x08, 0x05, 0x05, 0xB9, // "´" (U+00B4)
  0x00, 0xB5, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x05, 0xBB, // "µ" (U+00B5)
  0x00, 0xB6, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x05, 0xCD, // "¶" (U+00B6)
  0x00, 0xB7, 0x42, 0x03, 0x02, 0x03, 0x05, 0x05, 0xE4, // "·" (U+00B7)
  0x00, 0xB8, 0x41, 0xFF, 0x02, 0x01, 0x05, 0x05, 0xE5, // "¸" (U+00B8)
  0x00, 0xB9, 0x41, 0x04, 0x03, 0x07, 0x05, 0x05, 0xE8, // "¹" (U+00B9)
  0x00, 0xBA, 0x41, 0x04, 0x03, 0x06, 0x05, 0x05, 0xEE, // "º" (U+00BA)
  0x00, 0xBB, 0x41, 0x01, 0x04, 0x04, 0x05, 0x05, 0xF3, // "»" (U+00BB)
  0x00, 0xBC, 0x40, 0x00, 0x04, 0x06, 0x05, 0x05, 0xFB, // "¼" (U+00BC)
  0x00, 0xBD, 0x40, 0x01, 0x04, 0x07, 0x05, 0x06, 0x0D, // "½" (U+00BD)
  0x00, 0xBE, 0x40, 0x00, 0x04, 0x06, 0x05, 0x06, 0x1F, // "¾" (U+00BE)
  0x00, 0xBF, 0x41, 0xFE, 0x04, 0x04, 0x05, 0x06, 0x31, // "¿" (U+00BF)
  0x00, 0xC0, 0x40, 0x01, 0x04, 0x09, 0x05, 0x06, 0x3F, // "À" (U+00C0)
  0x00, 0xC1, 0x40, 0x01, 0x04, 0x09, 0x05, 0x06, 0x56, // "Á" (U+00C1)
  0x00, 0xC2, 0x40, 0x01, 0x04, 0x09, 0x05, 0x06, 0x6D, // "Â" (U+00C2)
  0x00, 0xC3, 0x40, 0x01, 0x04, 0x07, 0x05, 0x06, 0x84, // "Ã" (U+00C3)
  0x00, 0xC4, 0x40, 0x01, 0x04, 0x08, 0x05, 0x06, 0x96, // "Ä" (U+00C4)
  0x00, 0xC5, 0x40, 0x01, 0x04, 0x08, 0x05, 0x06, 0xAA, // "Å" (U+00C5)
  0x00, 0xC6, 0x40, 0x01, 0x04, 0x07, 0x05, 0x06, 0xBE, // "Æ" (U+00C6)
  0x00, 0xC7, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x06, 0xD0, // "Ç" (U+00C7)
  0x00, 0xC8, 0x40, 0x01, 0x04, 0x09, 0x05, 0x06, 0xE6, // "È" (U+00C8)
  0x00, 0xC9, 0x40, 0x01, 0x04, 0x09, 0x05, 0x06, 0xFD, // "É" (U+00C9)
  0x00, 0xCA, 0x40, 0x01, 0x04, 0x09, 0x05, 0x07, 0x14, // "Ê" (U+00CA)
  0x00, 0xCB, 0x40, 0x01, 0x04, 0x08, 0x05, 0x07, 0x2B, // "Ë" (U+00CB)
  0x00, 0xCC, 0x40, 0x01, 0x03, 0x09, 0x05, 0x07, 0x3F, // "Ì" (U+00CC)
  0x00, 0xCD, 0x00, 0x01, 0x03, 0x09, 0x05, 0x07, 0x51, // "Í" (U+00CD)
  0x00, 0xCE, 0x00, 0x01, 0x03, 0x09, 0x05, 0x07, 0x62, // "Î" (U+00CE)
  0x00, 0xCF, 0x40, 0x01, 0x03, 0x08, 0x05, 0x07, 0x73, // "Ï" (U+00CF)
  0x00, 0xD0, 0x40, 0x01, 0x04, 0x07, 0x05, 0x07, 0x83, // "Ð" (U+00D0)
  0x00, 0xD1, 0x40, 0x01, 0x04, 0x07, 0x05, 0x07, 0x95, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x40, 0x01, 0x04, 0x09, 0x05, 0x07, 0xA7, // "Ò" (U+00D2)
  0x00, 0xD3, 0x40, 0x01, 0x04, 0x09, 0x05, 0x07, 0xBE, // "Ó" (U+00D3)
  0x00, 0xD4, 0x40, 0x01, 0x04, 0x09, 0x05, 0x07, 0xD5, // "Ô" (U+00D4)
  0x00, 0xD5, 0x40, 0x01, 0x04, 0x07, 0x05, 0x07, 0xEC, // "Õ" (U+00D5)
  0x00, 0xD6, 0x40, 0x01, 0x04, 0x08, 0x05, 0x07, 0xFE, // "Ö" (U+00D6)
  0x00, 0xD7, 0x40, 0x02, 0x03, 0x05, 0x05, 0x08, 0x12, // "×" (U+00D7)
  0x00, 0xD8, 0x40, 0x01, 0x04, 0x07, 0x05, 0x08, 0x1A, // "Ø" (U+00D8)
  0x00, 0xD9, 0x40, 0x01, 0x04, 0x09, 0x05, 0x08, 0x2C, // "Ù" (U+00D9)
  0x00, 0xDA, 0x40, 0x01, 0x04, 0x09, 0x05, 0x08, 0x43, // "Ú" (U+00DA)
  0x00, 0xDB, 0x40, 0x01, 0x04, 0x09, 0x05, 0x08, 0x5A, // "Û" (U+00DB)
  0x00, 0xDC, 0x40, 0x01, 0x04, 0x08, 0x05, 0x08, 0x71, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x01, 0x04, 0x09, 0x05, 0x08, 0x85, // "Ý" (U+00DD)
  0x00, 0xDE, 0x40, 0x01, 0x04, 0x07, 0x05, 0x08, 0x9A, // "Þ" (U+00DE)
  0x00, 0xDF, 0x40, 0x01, 0x04, 0x07, 0x05, 0x08, 0xAC, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x01, 0x04, 0x08, 0x05, 0x08, 0xBE, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x04, 0x08, 0x05, 0x08, 0xD0, // "á" (U+00E1)
  0x00, 0xE2, 0x00, 0x01, 0x04, 0x08, 0x05, 0x08, 0xE2, // "â" (U+00E2)
  0x00, 0xE3, 0x40, 0x01, 0x04, 0x06, 0x05, 0x08, 0xF4, // "ã" (U+00E3)
  0x00, 0xE4, 0x00, 0x01, 0x04, 0x07, 0x05, 0x09, 0x03, // "ä" (U+00E4)
  0x00, 0xE5, 0x40, 0x01, 0x04, 0x07, 0x05, 0x09, 0x14, // "å" (U+00E5)
  0x00, 0xE6, 0x40, 0x01, 0x04, 0x05, 0x05, 0x09, 0x26, // "æ" (U+00E6)
  0x00, 0xE7, 0x40, 0xFF, 0x03, 0x05, 0x05, 0x09, 0x33, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x01, 0x04, 0x08, 0x05, 0x09, 0x41, // "è" (U+00E8)
  0x00, 0xE9, 0x00, 0x01, 0x04, 0x08, 0x05, 0x09, 0x53, // "é" (U+00E9)
  0x00, 0xEA, 0x00, 0x01, 0x04, 0x08, 0x05, 0x09, 0x65, // "ê" (U+00EA)
  0x00, 0xEB, 0x00, 0x01, 0x04, 0x07, 0x05, 0x09, 0x77, // "ë" (U+00EB)
  0x00, 0xEC, 0x00, 0x01, 0x04, 0x08, 0x05, 0x09, 0x88, // "ì" (U+00EC)
  0x00, 0xED, 0x00, 0x01, 0x04, 0x08, 0x05, 0x09, 0x98, // "í" (U+00ED)
  0x00, 0xEE, 0x00, 0x01, 0x04, 0x08, 0x05, 0x09, 0xA7, // "î" (U+00EE)
  0x00, 0xEF, 0x00, 0x01, 0x04, 0x07, 0x05, 0x09, 0xB7, // "ï" (U+00EF)
  0x00, 0xF0, 0x40, 0x01, 0x04, 0x08, 0x05, 0x09, 0xC6, // "ð" (U+00F0)
  0x00, 0xF1, 0x40, 0x01, 0x04, 0x06, 0x05, 0x09, 0xDA, // "ñ" (U+00F1)
  0x00, 0xF2, 0x00, 0x01, 0x04, 0x08, 0x05, 0x09, 0xE9, // "ò" (U+00F2)
  0x00, 0xF3, 0x00, 0x01, 0x04, 0x08, 0x05, 0x09, 0xFB, // "ó" (U+00F3)
  0x00, 0xF4, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0A, 0x0D, // "ô" (U+00F4)
  0x00, 0xF5, 0x40, 0x01, 0x04, 0x06, 0x05, 0x0A, 0x20, // "õ" (U+00F5)
  0x00, 0xF6, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x2F, // "ö" (U+00F6)
  0x00, 0xF7, 0x00, 0x02, 0x04, 0x05, 0x05, 0x0A, 0x40, // "÷" (U+00F7)
  0x00, 0xF8, 0x40, 0x01, 0x04, 0x05, 0x05, 0x0A, 0x48, // "ø" (U+00F8)
  0x00, 0xF9, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0A, 0x55, // "ù" (U+00F9)
  0x00, 0xFA, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0A, 0x68, // "ú" (U+00FA)
  0x00, 0xFB, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0A, 0x7A, // "û" (U+00FB)
  0x00, 0xFC, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x8D, // "ü" (U+00FC)
  0x00, 0xFD, 0x00, 0xFF, 0x04, 0x08, 0x05, 0x0A, 0x9F, // "ý" (U+00FD)
  0x00, 0xFE, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0A, 0xB6, // "þ" (U+00FE)
  0x00, 0xFF, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x0A, 0xCC, // "ÿ" (U+00FF)
  0x01, 0x00, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0A, 0xE3, // "Ā" (U+0100)
  0x01, 0x01, 0x40, 0x01, 0x04, 0x06, 0x05, 0x0A, 0xF5, // "ā" (U+0101)
  0x01, 0x02, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0B, 0x04, // "Ă" (U+0102)
  0x01, 0x03, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0B, 0x18, // "ă" (U+0103)
  0x01, 0x04, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x0B, 0x2A, // "Ą" (U+0104)
  0x01, 0x05, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x0B, 0x41, // "ą" (U+0105)
  0x01, 0x06, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0B, 0x53, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0B, 0x68, // "ć" (U+0107)
  0x01, 0x08, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0B, 0x79, // "Ĉ" (U+0108)
  0x01, 0x09, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0B, 0x8E, // "ĉ" (U+0109)
  0x01, 0x0A, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0B, 0xA0, // "Ċ" (U+010A)
  0x01, 0x0B, 0x40, 0x01, 0x03, 0x07, 0x05, 0x0B, 0xB3, // "ċ" (U+010B)
  0x01, 0x0C, 0x40, 0x01, 0x04, 0x09, 0x05, 0x0B, 0xC1, // "Č" (U+010C)
  0x01, 0x0D, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0B, 0xD8, // "č" (U+010D)
  0x01, 0x0E, 0x40, 0x01, 0x04, 0x09, 0x05, 0x0B, 0xEB, // "Ď" (U+010E)
  0x01, 0x0F, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0C, 0x02, // "ď" (U+010F)
  0x01, 0x10, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0C, 0x14, // "Đ" (U+0110)
  0x01, 0x11, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0C, 0x26, // "đ" (U+0111)
  0x01, 0x12, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0C, 0x38, // "Ē" (U+0112)
  0x01, 0x13, 0x40, 0x01, 0x04, 0x06, 0x05, 0x0C, 0x4A, // "ē" (U+0113)
  0x01, 0x14, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0C, 0x59, // "Ĕ" (U+0114)
  0x01, 0x15, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0C, 0x6D, // "ĕ" (U+0115)
  0x01, 0x16, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0C, 0x7F, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0C, 0x93, // "ė" (U+0117)
  0x01, 0x18, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x0C, 0xA3, // "Ę" (U+0118)
  0x01, 0x19, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x0C, 0xBA, // "ę" (U+0119)
  0x01, 0x1A, 0x40, 0x01, 0x04, 0x09, 0x05, 0x0C, 0xCC, // "Ě" (U+011A)
  0x01, 0x1B, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0C, 0xE3, // "ě" (U+011B)
  0x01, 0x1C, 0x40, 0x01, 0x04, 0x09, 0x05, 0x0C, 0xF7, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x00, 0xFF, 0x04, 0x08, 0x05, 0x0D, 0x0E, // "ĝ" (U+011D)
  0x01, 0x1E, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0D, 0x26, // "Ğ" (U+011E)
  0x01, 0x1F, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x0D, 0x3A, // "ğ" (U+011F)
  0x01, 0x20, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0D, 0x51, // "Ġ" (U+0120)
  0x01, 0x21, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0D, 0x65, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0xFE, 0x04, 0x07, 0x05, 0x0D, 0x7A, // "Ģ" (U+0122)
  0x01, 0x23, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0D, 0x92, // "ģ" (U+0123)
  0x01, 0x24, 0x40, 0x01, 0x04, 0x09, 0x05, 0x0D, 0xA8, // "Ĥ" (U+0124)
  0x01, 0x25, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x0D, 0xBF, // "ĥ" (U+0125)
  0x01, 0x26, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0D, 0xD6, // "Ħ" (U+0126)
  0x01, 0x27, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0D, 0xE8, // "ħ" (U+0127)
  0x01, 0x28, 0x00, 0x01, 0x03, 0x07, 0x05, 0x0D, 0xFA, // "Ĩ" (U+0128)
  0x01, 0x29, 0x00, 0x01, 0x04, 0x06, 0x05, 0x0E, 0x06, // "ĩ" (U+0129)
  0x01, 0x2A, 0x00, 0x01, 0x03, 0x07, 0x05, 0x0E, 0x14, // "Ī" (U+012A)
  0x01, 0x2B, 0x00, 0x01, 0x04, 0x06, 0x05, 0x0E, 0x20, // "ī" (U+012B)
  0x01, 0x2C, 0x40, 0x01, 0x03, 0x08, 0x05, 0x0E, 0x2E, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0E, 0x3E, // "ĭ" (U+012D)
  0x01, 0x2E, 0x40, 0xFF, 0x03, 0x07, 0x05, 0x0E, 0x4F, // "Į" (U+012E)
  0x01, 0x2F, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0E, 0x61, // "į" (U+012F)
  0x01, 0x30, 0x00, 0x01, 0x03, 0x08, 0x05, 0x0E, 0x74, // "İ" (U+0130)
  0x01, 0x31, 0x00, 0x01, 0x04, 0x05, 0x05, 0x0E, 0x83, // "ı" (U+0131)
  0x01, 0x32, 0x40, 0x01, 0x03, 0x07, 0x05, 0x0E, 0x8E, // "Ĳ" (U+0132)
  0x01, 0x33, 0x40, 0xFF, 0x03, 0x07, 0x05, 0x0E, 0x9C, // "ĳ" (U+0133)
  0x01, 0x34, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0E, 0xAE, // "Ĵ" (U+0134)
  0x01, 0x35, 0x00, 0xFF, 0x04, 0x08, 0x05, 0x0E, 0xC0, // "ĵ" (U+0135)
  0x01, 0x36, 0x40, 0xFE, 0x04, 0x07, 0x05, 0x0E, 0xD7, // "Ķ" (U+0136)
  0x01, 0x37, 0x40, 0xFE, 0x04, 0x07, 0x05, 0x0E, 0xF0, // "ķ" (U+0137)
  0x01, 0x38, 0x40, 0x01, 0x04, 0x05, 0x05, 0x0F, 0x09, // "ĸ" (U+0138)
  0x01, 0x39, 0x40, 0x01, 0x04, 0x09, 0x05, 0x0F, 0x16, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x0F, 0x2D, // "ĺ" (U+013A)
  0x01, 0x3B, 0x00, 0xFE, 0x04, 0x07, 0x05, 0x0F, 0x3F, // "Ļ" (U+013B)
  0x01, 0x3C, 0x00, 0xFE, 0x04, 0x07, 0x05, 0x0F, 0x56, // "ļ" (U+013C)
  0x01, 0x3D, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0F, 0x69, // "Ľ" (U+013D)
  0x01, 0x3E, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0F, 0x7B, // "ľ" (U+013E)
  0x01, 0x3F, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0F, 0x8B, // "Ŀ" (U+013F)
  0x01, 0x40, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0F, 0x9D, // "ŀ" (U+0140)
  0x01, 0x41, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0F, 0xAD, // "Ł" (U+0141)
  0x01, 0x42, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0F, 0xBC, // "ł" (U+0142)
  0x01, 0x43, 0x40, 0x01, 0x04, 0x09, 0x05, 0x0F, 0xCD, // "Ń" (U+0143)
  0x01, 0x44, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0F, 0xE4, // "ń" (U+0144)
  0x01, 0x45, 0x00, 0xFE, 0x04, 0x07, 0x05, 0x0F, 0xF6, // "Ņ" (U+0145)
  0x01, 0x46, 0x00, 0xFE, 0x04, 0x05, 0x05, 0x10, 0x0E, // "ņ" (U+0146)
  0x01, 0x47, 0x40, 0x01, 0x04, 0x09, 0x05, 0x10, 0x21, // "Ň" (U+0147)
  0x01, 0x48, 0x40, 0x01, 0x04, 0x08, 0x05, 0x10, 0x38, // "ň" (U+0148)
  0x01, 0x49, 0xBF, 0x01, 0x04, 0x07, 0x05, 0x10, 0x4C, // "ŉ" (U+0149)
  0x01, 0x4A, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x10, 0x61, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x10, 0x78, // "ŋ" (U+014B)
  0x01, 0x4C, 0x40, 0x01, 0x04, 0x07, 0x05, 0x10, 0x8A, // "Ō" (U+014C)
  0x01, 0x4D, 0x40, 0x01, 0x04, 0x06, 0x05, 0x10, 0x9C, // "ō" (U+014D)
  0x01, 0x4E, 0x40, 0x01, 0x04, 0x08, 0x05, 0x10, 0xAB, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x40, 0x01, 0x04, 0x07, 0x05, 0x10, 0xBF, // "ŏ" (U+014F)
  0x01, 0x50, 0x40, 0x01, 0x04, 0x08, 0x05, 0x10, 0xD1, // "Ő" (U+0150)
  0x01, 0x51, 0x40, 0x01, 0x04, 0x07, 0x05, 0x10, 0xE5, // "ő" (U+0151)
  0x01, 0x52, 0x40, 0x01, 0x04, 0x07, 0x05, 0x10, 0xF7, // "Œ" (U+0152)
  0x01, 0x53, 0x40, 0x01, 0x04, 0x05, 0x05, 0x11, 0x09, // "œ" (U+0153)
  0x01, 0x54, 0x40, 0x01, 0x04, 0x09, 0x05, 0x11, 0x16, // "Ŕ" (U+0154)
  0x01, 0x55, 0x00, 0x01, 0x04, 0x08, 0x05, 0x11, 0x2D, // "ŕ" (U+0155)
  0x01, 0x56, 0x00, 0xFE, 0x04, 0x07, 0x05, 0x11, 0x3F, // "Ŗ" (U+0156)
  0x01, 0x57, 0x00, 0xFE, 0x04, 0x05, 0x05, 0x11, 0x57, // "ŗ" (U+0157)
  0x01, 0x58, 0x40, 0x01, 0x04, 0x09, 0x05, 0x11, 0x69, // "Ř" (U+0158)
  0x01, 0x59, 0x40, 0x01, 0x04, 0x08, 0x05, 0x11, 0x80, // "ř" (U+0159)
  0x01, 0x5A, 0x00, 0x01, 0x04, 0x09, 0x05, 0x11, 0x94, // "Ś" (U+015A)
  0x01, 0x5B, 0x00, 0x01, 0x03, 0x08, 0x05, 0x11, 0xA9, // "ś" (U+015B)
  0x01, 0x5C, 0x00, 0x01, 0x04, 0x09, 0x05, 0x11, 0xB8, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x40, 0x01, 0x03, 0x08, 0x05, 0x11, 0xCE, // "ŝ" (U+015D)
  0x01, 0x5E, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x11, 0xDE, // "Ş" (U+015E)
  0x01, 0x5F, 0x40, 0xFF, 0x03, 0x05, 0x05, 0x11, 0xF4, // "ş" (U+015F)
  0x01, 0x60, 0x40, 0x01, 0x04, 0x09, 0x05, 0x12, 0x02, // "Š" (U+0160)
  0x01, 0x61, 0x40, 0x01, 0x03, 0x08, 0x05, 0x12, 0x19, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x12, 0x29, // "Ţ" (U+0162)
  0x01, 0x63, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x12, 0x3A, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x04, 0x09, 0x05, 0x12, 0x51, // "Ť" (U+0164)
  0x01, 0x65, 0x40, 0x01, 0x04, 0x07, 0x05, 0x12, 0x64, // "ť" (U+0165)
  0x01, 0x66, 0x00, 0x01, 0x04, 0x07, 0x05, 0x12, 0x76, // "Ŧ" (U+0166)
  0x01, 0x67, 0x40, 0x01, 0x04, 0x07, 0x05, 0x12, 0x85, // "ŧ" (U+0167)
  0x01, 0x68, 0x40, 0x01, 0x04, 0x07, 0x05, 0x12, 0x97, // "Ũ" (U+0168)
  0x01, 0x69, 0x40, 0x01, 0x04, 0x06, 0x05, 0x12, 0xA9, // "ũ" (U+0169)
  0x01, 0x6A, 0x40, 0x01, 0x04, 0x07, 0x05, 0x12, 0xB8, // "Ū" (U+016A)
  0x01, 0x6B, 0x40, 0x01, 0x04, 0x06, 0x05, 0x12, 0xCA, // "ū" (U+016B)
  0x01, 0x6C, 0x40, 0x01, 0x04, 0x08, 0x05, 0x12, 0xD9, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x40, 0x01, 0x04, 0x07, 0x05, 0x12, 0xED, // "ŭ" (U+016D)
  0x01, 0x6E, 0x40, 0x01, 0x04, 0x08, 0x05, 0x12, 0xFF, // "Ů" (U+016E)
  0x01, 0x6F, 0x40, 0x01, 0x04, 0x07, 0x05, 0x13, 0x13, // "ů" (U+016F)
  0x01, 0x70, 0x40, 0x01, 0x04, 0x08, 0x05, 0x13, 0x25, // "Ű" (U+0170)
  0x01, 0x71, 0x40, 0x01, 0x04, 0x07, 0x05, 0x13, 0x39, // "ű" (U+0171)
  0x01, 0x72, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x13, 0x4B, // "Ų" (U+0172)
  0x01, 0x73, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x13, 0x62, // "ų" (U+0173)
  0x01, 0x74, 0x40, 0x01, 0x04, 0x09, 0x05, 0x13, 0x74, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x04, 0x08, 0x05, 0x13, 0x8B, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x01, 0x04, 0x09, 0x05, 0x13, 0x9E, // "Ŷ" (U+0176)
  0x01, 0x77, 0x00, 0xFF, 0x04, 0x08, 0x05, 0x13, 0xB3, // "ŷ" (U+0177)
  0x01, 0x78, 0x40, 0x01, 0x04, 0x08, 0x05, 0x13, 0xCB, // "Ÿ" (U+0178)
  0x01, 0x79, 0x00, 0x01, 0x04, 0x09, 0x05, 0x13, 0xDF, // "Ź" (U+0179)
  0x01, 0x7A, 0x40, 0x01, 0x03, 0x08, 0x05, 0x13, 0xF4, // "ź" (U+017A)
  0x01, 0x7B, 0x40, 0x01, 0x03, 0x08, 0x05, 0x14, 0x04, // "Ż" (U+017B)
  0x01, 0x7C, 0x40, 0x01, 0x03, 0x07, 0x05, 0x14, 0x14, // "ż" (U+017C)
  0x01, 0x7D, 0x40, 0x01, 0x04, 0x09, 0x05, 0x14, 0x22, // "Ž" (U+017D)
  0x01, 0x7E, 0x40, 0x01, 0x03, 0x08, 0x05, 0x14, 0x39, // "ž" (U+017E)
  0x01, 0x7F, 0x41, 0x01, 0x04, 0x07, 0x05, 0x14, 0x49, // "ſ" (U+017F)
  0x03, 0xA9, 0x40, 0x01, 0x04, 0x07, 0x05, 0x14, 0x57, // "Ω" (U+03A9)
  0x03, 0xBC, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x14, 0x69, // "μ" (U+03BC)
  0x03, 0xC0, 0x40, 0x01, 0x04, 0x05, 0x05, 0x14, 0x7B, // "π" (U+03C0)
  0x20, 0x13, 0x40, 0x03, 0x03, 0x03, 0x05, 0x14, 0x88, // "–" (U+2013)
  0x20, 0x14, 0x40, 0x03, 0x04, 0x03, 0x05, 0x14, 0x8A, // "—" (U+2014)
  0x20, 0xAC, 0x40, 0x01, 0x04, 0x07, 0x05, 0x14, 0x8D, // "€" (U+20AC)
  0x20, 0xBF, 0x40, 0x00, 0x04, 0x08, 0x05, 0x14, 0x9F, // "₿" (U+20BF)
  0x20, 0x18, 0x42, 0x05, 0x02, 0x07, 0x05, 0x14, 0xB6, // "‘" (U+2018)
  0x20, 0x19, 0x41, 0x06, 0x02, 0x07, 0x05, 0x14, 0xB8, // "’" (U+2019)
  0x20, 0x1A, 0x41, 0x00, 0x02, 0x02, 0x05, 0x14, 0xBA, // "‚" (U+201A)
  0x20, 0x1B, 0x41, 0x05, 0x02, 0x07, 0x05, 0x14, 0xBD, // "‛" (U+201B)
  0x20, 0x1C, 0x41, 0x05, 0x03, 0x07, 0x05, 0x14, 0xC0, // "“" (U+201C)
  0x20, 0x1D, 0x41, 0x03, 0x03, 0x05, 0x05, 0x14, 0xC5, // "”" (U+201D)
  0x20, 0x1E, 0x40, 0x00, 0x03, 0x02, 0x05, 0x14, 0xCA, // "„" (U+201E)
  0x20, 0x1F, 0x41, 0x03, 0x03, 0x05, 0x05, 0x14, 0xD0, // "‟" (U+201F)
  0x20, 0x20, 0x00, 0x01, 0x03, 0x07, 0x05, 0x14, 0xD5, // "†" (U+2020)
  0x20, 0x21, 0x40, 0x01, 0x03, 0x07, 0x05, 0x14, 0xE2, // "‡" (U+2021)
  0x20, 0x22, 0x41, 0x03, 0x03, 0x04, 0x05, 0x14, 0xF0, // "•" (U+2022)
  0x20, 0x26, 0x40, 0x01, 0x04, 0x01, 0x05, 0x14, 0xF3, // "…" (U+2026)
  0x20, 0x30, 0x40, 0x01, 0x04, 0x07, 0x05, 0x14, 0xF6, // "‰" (U+2030)
  0x20, 0x39, 0x41, 0x01, 0x03, 0x04, 0x05, 0x15, 0x08, // "‹" (U+2039)
  0x20, 0x3A, 0x41, 0x01, 0x03, 0x04, 0x05, 0x15, 0x0E, // "›" (U+203A)
  0x20, 0x44, 0xBE, 0x01, 0x01, 0x07, 0x00, 0x15, 0x14, // "⁄" (U+2044)
  0x21, 0x22, 0xBF, 0x03, 0x04, 0x06, 0x05, 0x15, 0x22, // "™" (U+2122)
  0x21, 0x52, 0x02, 0x01, 0x0C, 0x07, 0x0E, 0x15, 0x2E, // "⅒" (U+2152)
  0x22, 0x02, 0x40, 0x01, 0x04, 0x06, 0x05, 0x15, 0x51, // "∂" (U+2202)
  0x22, 0x06, 0x40, 0x01, 0x04, 0x07, 0x05, 0x15, 0x60, // "∆" (U+2206)
  0x22, 0x1A, 0x40, 0x01, 0x04, 0x08, 0x05, 0x15, 0x72, // "√" (U+221A)
  0x22, 0x1E, 0x40, 0x02, 0x04, 0x04, 0x05, 0x15, 0x86, // "∞" (U+221E)
  0x22, 0x48, 0x40, 0x03, 0x04, 0x05, 0x05, 0x15, 0x8E, // "≈" (U+2248)
  0x22, 0x60, 0x40, 0x02, 0x04, 0x05, 0x05, 0x15, 0x96, // "≠" (U+2260)
  0x22, 0x64, 0x00, 0x01, 0x04, 0x06, 0x05, 0x15, 0xA0, // "≤" (U+2264)
  0x22, 0x65, 0x40, 0x01, 0x04, 0x06, 0x05, 0x15, 0xAE, // "≥" (U+2265)
  
  // Kerning pairs
  
  // Glyph data
  // "!" (U+0021)
  0xCC, 0xBA, 0xA0, 0x80,
  // """ (U+0022)
  0xA3, 0x78, 0x16, 0x10, 0x00,
  // "#" (U+0023)
  0x02, 0x68, 0x00, 0x53, 0x80, 0x6D, 0xBD, 0x70, 0x81, 0x70, 0x9D, 0xCC, 0x40, 0x86, 0x20, 0x16,
  0x80, 0x00,
  // "$" (U+0024)
  0x01, 0x91, 0x02, 0xBB, 0x80, 0x46, 0x70, 0x00, 0xBB, 0x10, 0x00, 0xAB, 0x00, 0x07, 0xA1, 0x2B,
  0xD6, 0x00, 0x03, 0x00,
  // "%" (U+0025)
  0x8B, 0x09, 0x09, 0x55, 0x70, 0x96, 0xB1, 0x07, 0xA9, 0x00, 0x05, 0x7B, 0x50, 0x97, 0x29, 0x27,
  0x3C, 0x70,
  // "&" (U+0026)
  0x0B, 0xB0, 0x02, 0x78, 0x20, 0x09, 0xB0, 0x00, 0xC6, 0x00, 0x67, 0xA7, 0x3A, 0x14, 0xD0, 0x4C,
  0xA9, 0x40,
  // "'" (U+0027)
  0xA8, 0x10,
  // "(" (U+0028)
  0x07, 0x20, 0xA0, 0x37, 0x05, 0x50, 0x55, 0x04, 0x70, 0x0A, 0x00, 0x72,
  // ")" (U+0029)
  0x27, 0x00, 0xA0, 0x07, 0x30, 0x55, 0x05, 0x50, 0x73, 0x0A, 0x02, 0x70,
  // "*" (U+002A)
  0x00, 0x80, 0x28, 0xA9, 0x04, 0xC2, 0x06, 0x14,
  // "+" (U+002B)
  0x20, 0x92, 0x83, 0x4B, 0xDB, 0x12, 0x09, 0x40, 0x92,
  // "," (U+002C)
  0x02, 0x0C, 0x37,
  // "-" (U+002D)
  0x9B, 0x60,
  // "." (U+002E)
  0x80,
  // "/" (U+002F)
  0x00, 0xA0, 0x45, 0x09, 0x10, 0xA0, 0x46, 0x08, 0x10, 0xA0, 0x00,
  // "0" (U+0030)
  0x0A, 0xB7, 0x04, 0x71, 0xE0, 0x73, 0x79, 0x37, 0x3A, 0x54, 0x6B, 0x36, 0x33, 0xB0, 0xA1, 0x09,
  0xB7, 0x00,
  // "1" (U+0031)
  0x6E, 0x00, 0x6A, 0x00, 0x0A, 0x00, 0x0A, 0x00, 0x0A, 0x00, 0x0A, 0x00, 0x8D, 0x91,
  // "2" (U+0032)
  0x1A, 0xB7, 0x00, 0x10, 0xB0, 0x00, 0x0B, 0x00, 0x03, 0x90, 0x01, 0xB1, 0x00, 0xA3, 0x00, 0x6E,
  0xBB, 0x40,
  // "3" (U+0033)
  0x2B, 0xB7, 0x00, 0x10, 0xC0, 0x00, 0x0B, 0x00, 0x6D, 0x60, 0x00, 0x0A, 0x10, 0x00, 0xA1, 0x4B,
  0xB7, 0x00,
  // "4" (U+0034)
  0x00, 0x78, 0x00, 0x0B, 0x80, 0x06, 0x68, 0x00, 0xA2, 0x80, 0x45, 0x18, 0x07, 0xBB, 0xD4, 0x00,
  0x18, 0x00,
  // "5" (U+0035)
  0x0D, 0xB9, 0x01, 0x80, 0x00, 0x27, 0x00, 0x02, 0xDB, 0x50, 0x00, 0x0B, 0x10, 0x00, 0xA1, 0x3B,
  0xC7, 0x00,
  // "6" (U+0036)
  0x05, 0xCA, 0x01, 0xB0, 0x00, 0x55, 0x00, 0x07, 0x8B, 0x90, 0x76, 0x08, 0x34, 0x60, 0x73, 0x09,
  0xB9, 0x00,
  // "7" (U+0037)
  0x83, 0x6B, 0xBD, 0x43, 0x0A, 0x40, 0xA3, 0x00, 0x53, 0x0A, 0x30, 0x10, 0xA3, 0x06, 0x05, 0x20,
  // "8" (U+0038)
  0x0A, 0xB8, 0x03, 0x70, 0xA0, 0x1D, 0x8B, 0x00, 0x9D, 0x50, 0x47, 0x0A, 0x16, 0x50, 0x82, 0x1B,
  0xB8, 0x00,
  // "9" (U+0039)
  0x0A, 0xC7, 0x05, 0x50, 0xA1, 0x73, 0x06, 0x45, 0x60, 0xA4, 0x09, 0xBA, 0x20, 0x00, 0xA0, 0x0B,
  0xB3, 0x00,
  // ":" (U+003A)
  0x80, 0x00, 0x80,
  // ";" (U+003B)
  0x08, 0x00, 0x00, 0x02, 0x0C, 0x37,
  // "<" (U+003C)
  0x00, 0x62, 0x49, 0x30, 0xA6, 0x00, 0x03, 0x92,
  // "=" (U+003D)
  0x5B, 0xBB, 0x20, 0x00, 0x00, 0x5B, 0xBB, 0x20,
  // ">" (U+003E)
  0x26, 0x00, 0x03, 0x94, 0x00, 0x6A, 0x29, 0x30,
  // "?" (U+003F)
  0x1C, 0xB7, 0x00, 0x0A, 0x00, 0x0A, 0x00, 0x68, 0x00, 0xA0, 0x01, 0x30, 0x02, 0x60,
  // "@" (U+0040)
  0x09, 0xB9, 0x06, 0x40, 0x55, 0x84, 0xC7, 0x88, 0x91, 0x78, 0x89, 0x37, 0x89, 0x6A, 0x93, 0x65,
  0x00, 0x00, 0x8B, 0x90,
  // "A" (U+0041)
  0x01, 0xE0, 0x00, 0x6B, 0x20, 0x09, 0x46, 0x00, 0xA0, 0xA0, 0x2D, 0xBD, 0x07, 0x40, 0x73, 0xA0,
  0x03, 0x70,
  // "B" (U+0042)
  0x3D, 0xB9, 0x03, 0x60, 0x92, 0x36, 0x0A, 0x13, 0xDC, 0x90, 0x36, 0x08, 0x33, 0x60, 0x74, 0x3D,
  0xBA, 0x00,
  // "C" (U+0043)
  0x18, 0x46, 0xCC, 0x31, 0xB3, 0x00, 0x53, 0x06, 0x04, 0x30, 0x05, 0x30, 0x20, 0xA4, 0x82, 0x6C,
  0xB1,
  // "D" (U+0044)
  0x6C, 0xC5, 0x06, 0x40, 0xB1, 0x64, 0x06, 0x56, 0x40, 0x56, 0x64, 0x06, 0x46, 0x40, 0xB1, 0x6C,
  0xB4, 0x00,
  // "E" (U+0045)
  0x3D, 0xBB, 0x13, 0x70, 0x00, 0x37, 0x00, 0x03, 0xDB, 0xB0, 0x37, 0x00, 0x03, 0x70, 0x00, 0x3D,
  0xBB, 0x10,
  // "F" (U+0046)
  0x3D, 0xBB, 0x13, 0x70, 0x00, 0x37, 0x00, 0x03, 0xDB, 0xB0, 0x37, 0x00, 0x03, 0x70, 0x00, 0x37,
  0x00, 0x00,
  // "G" (U+0047)
  0x07, 0xBB, 0x03, 0x90, 0x00, 0x83, 0x00, 0x09, 0x15, 0xC3, 0x83, 0x07, 0x34, 0x80, 0x73, 0x09,
  0xBC, 0x20,
  // "H" (U+0048)
  0x64, 0x07, 0x36, 0x40, 0x73, 0x64, 0x07, 0x36, 0xCB, 0xD3, 0x64, 0x07, 0x36, 0x40, 0x73, 0x64,
  0x07, 0x30,
  // "I" (U+0049)
  0x1B, 0xEA, 0x00, 0xB0, 0x00, 0xB0, 0x00, 0xB0, 0x00, 0xB0, 0x00, 0xB0, 0x1A, 0xE9,
  // "J" (U+004A)
  0x30, 0xB3, 0x0B, 0x30, 0xB3, 0x0B, 0x30, 0xB2, 0x84, 0x29, 0x2B, 0xC3,
  // "K" (U+004B)
  0x64, 0x0B, 0x16, 0x46, 0x60, 0x65, 0xB0, 0x06, 0xC9, 0x00, 0x67, 0xA1, 0x06, 0x43, 0x90, 0x64,
  0x0A, 0x20,
  // "L" (U+004C)
  0x19, 0x00, 0x01, 0x90, 0x00, 0x19, 0x00, 0x01, 0x90, 0x00, 0x19, 0x00, 0x01, 0x90, 0x00, 0x1E,
  0xBB, 0x10,
  // "M" (U+004D)
  0x98, 0x0B, 0x69, 0xA0, 0xD6, 0x9A, 0x3A, 0x69, 0x7A, 0x66, 0x93, 0xE4, 0x69, 0x13, 0x46, 0x91,
  0x04, 0x60,
  // "N" (U+004E)
  0x6A, 0x07, 0x36, 0xC1, 0x73, 0x67, 0x67, 0x36, 0x39, 0x73, 0x63, 0x88, 0x36, 0x32, 0xD3, 0x63,
  0x0C, 0x30,
  // "O" (U+004F)
  0x0A, 0xC8, 0x05, 0x60, 0x92, 0x82, 0x05, 0x59, 0x10, 0x46, 0x82, 0x05, 0x55, 0x60, 0x92, 0x0A,
  0xC8, 0x00,
  // "P" (U+0050)
  0x3D, 0xBA, 0x03, 0x70, 0x83, 0x37, 0x06, 0x43, 0x70, 0xA2, 0x3D, 0xB7, 0x03, 0x70, 0x00, 0x37,
  0x00, 0x00,
  // "Q" (U+0051)
  0x0A, 0xC8, 0x05, 0x60, 0x92, 0x82, 0x05, 0x59, 0x10, 0x46, 0x82, 0x05, 0x55, 0x60, 0x92, 0x0A,
  0xCA, 0x00, 0x00, 0xB0, 0x00, 0x04, 0x10,
  // "R" (U+0052)
  0x3D, 0xB8, 0x03, 0x70, 0xB0, 0x37, 0x0B, 0x03, 0xDD, 0x50, 0x37, 0x56, 0x03, 0x70, 0xB0, 0x37,
  0x07, 0x50,
  // "S" (U+0053)
  0x09, 0xCB, 0x02, 0x90, 0x00, 0x0B, 0x10, 0x00, 0x4C, 0x50, 0x00, 0x0B, 0x10, 0x00, 0x92, 0x3C,
  0xB9, 0x00,
  // "T" (U+0054)
  0x83, 0x7B, 0xEB, 0x52, 0x0B, 0x40, 0xB4, 0x0B, 0x40, 0xB4, 0x0B, 0x40, 0xB2,
  // "U" (U+0055)
  0x64, 0x07, 0x36, 0x40, 0x73, 0x64, 0x07, 0x36, 0x40, 0x73, 0x64, 0x07, 0x34, 0x70, 0xA1, 0x0B,
  0xC8, 0x00,
  // "V" (U+0056)
  0xA1, 0x04, 0x76, 0x40, 0x73, 0x28, 0x0A, 0x00, 0xA0, 0xA0, 0x09, 0x46, 0x00, 0x5B, 0x20, 0x01,
  0xE0, 0x00,
  // "W" (U+0057)
  0xA0, 0x01, 0x89, 0x00, 0x27, 0x81, 0xD3, 0x67, 0x5B, 0x54, 0x69, 0x69, 0x34, 0xB1, 0xD2, 0x3A,
  0x0D, 0x10,
  // "X" (U+0058)
  0x56, 0x09, 0x20, 0xA1, 0xA0, 0x06, 0xB3, 0x00, 0x1D, 0x00, 0x07, 0x94, 0x00, 0xA0, 0xA0, 0x74,
  0x07, 0x40,
  // "Y" (U+0059)
  0x87, 0x84, 0x06, 0x41, 0x90, 0xA2, 0x81, 0x93, 0x72, 0x81, 0x4D, 0x13, 0x0B, 0x40, 0xA4, 0x0A,
  0x20,
  // "Z" (U+005A)
  0x0B, 0xBE, 0x00, 0x1A, 0x00, 0x73, 0x00, 0xA0, 0x06, 0x50, 0x0B, 0x00, 0x3D, 0xBB,
  // "[" (U+005B)
  0x1E, 0x81, 0x90, 0x19, 0x01, 0x90, 0x19, 0x01, 0x90, 0x19, 0x01, 0xC8,
  // "\" (U+005C)
  0xA0, 0x05, 0x40, 0x19, 0x00, 0xA0, 0x06, 0x30, 0x18, 0x00, 0xA0,
  // "]" (U+005D)
  0x8C, 0x10, 0x91, 0x09, 0x10, 0x91, 0x09, 0x10, 0x91, 0x09, 0x18, 0xE1,
  // "^" (U+005E)
  0x01, 0xB0, 0x00, 0x77, 0x30, 0x08, 0x09, 0x05, 0x30, 0x62,
  // "_" (U+005F)
  0xBB, 0xBB, 0x90,
  // "`" (U+0060)
  0x23, 0x09,
  // "a" (U+0061)
  0x0B, 0xC9, 0x00, 0x00, 0xA0, 0x1A, 0xBD, 0x16, 0x50, 0xA1, 0x2C, 0xAA, 0x10,
  // "b" (U+0062)
  0x55, 0x00, 0x05, 0x50, 0x00, 0x5A, 0xB9, 0x05, 0x80, 0x83, 0x55, 0x06, 0x55, 0x80, 0x83, 0x59,
  0xB9, 0x00,
  // "c" (U+0063)
  0x08, 0xBB, 0x29, 0x00, 0x46, 0x00, 0x29, 0x00, 0x08, 0xBB,
  // "d" (U+0064)
  0x00, 0x08, 0x20, 0x00, 0x82, 0x1B, 0xBB, 0x26, 0x50, 0xB2, 0x83, 0x08, 0x26, 0x50, 0xB2, 0x1B,
  0xBA, 0x20,
  // "e" (U+0065)
  0x0A, 0xB8, 0x05, 0x70, 0x82, 0x7C, 0xBC, 0x45, 0x60, 0x00, 0x09, 0xBB, 0x10,
  // "f" (U+0066)
  0x00, 0xAB, 0x50, 0x0A, 0x00, 0x4B, 0xEB, 0x30, 0x19, 0x00, 0x01, 0x90, 0x00, 0x19, 0x00, 0x01,
  0x90, 0x00,
  // "g" (U+0067)
  0x0B, 0xBA, 0x26, 0x50, 0xA2, 0x83, 0x07, 0x26, 0x50, 0xA2, 0x1B, 0xBB, 0x20, 0x00, 0xA1, 0x3B,
  0xB8, 0x00,
  // "h" (U+0068)
  0x55, 0x00, 0x05, 0x50, 0x00, 0x5A, 0xBA, 0x05, 0x80, 0x92, 0x55, 0x08, 0x35, 0x50, 0x83, 0x55,
  0x08, 0x30,
  // "i" (U+0069)
  0x20, 0x87, 0x81, 0x2A, 0xD4, 0x0B, 0x40, 0xB4, 0x0B, 0x28, 0x33, 0x9E, 0x92,
  // "j" (U+006A)
  0x00, 0x71, 0x00, 0x00, 0x08, 0xD2, 0x00, 0x82, 0x00, 0x82, 0x00, 0x82, 0x00, 0x82, 0x00, 0x92,
  0x6B, 0xA0,
  // "k" (U+006B)
  0x28, 0x00, 0x02, 0x80, 0x00, 0x28, 0x0B, 0x22, 0x88, 0x40, 0x2C, 0xC0, 0x02, 0xA3, 0x90, 0x28,
  0x08, 0x30,
  // "l" (U+006C)
  0x81, 0x3B, 0xD4, 0x0B, 0x40, 0xB4, 0x0B, 0x40, 0xB4, 0x0B, 0x28, 0x33, 0x9D, 0x92,
  // "m" (U+006D)
  0x8A, 0x9C, 0x29, 0x2C, 0x45, 0x90, 0xA3, 0x69, 0x09, 0x36, 0x90, 0x93, 0x60,
  // "n" (U+006E)
  0x59, 0xBB, 0x05, 0x80, 0x92, 0x55, 0x08, 0x35, 0x50, 0x83, 0x55, 0x08, 0x30,
  // "o" (U+006F)
  0x0B, 0xB8, 0x06, 0x50, 0x93, 0x82, 0x06, 0x56, 0x50, 0x93, 0x0B, 0xC9, 0x00,
  // "p" (U+0070)
  0x59, 0xB9, 0x05, 0x70, 0x83, 0x55, 0x06, 0x55, 0x80, 0x83, 0x5A, 0xBA, 0x05, 0x50, 0x00, 0x55,
  0x00, 0x00,
  // "q" (U+0071)
  0x1B, 0xBA, 0x26, 0x50, 0xB2, 0x83, 0x08, 0x26, 0x50, 0xB2, 0x1B, 0xBB, 0x20, 0x00, 0x82, 0x00,
  0x08, 0x20,
  // "r" (U+0072)
  0x4D, 0x9C, 0x60, 0x3C, 0x00, 0x03, 0x80, 0x00, 0x38, 0x00, 0x4A, 0xC6, 0x00,
  // "s" (U+0073)
  0x0A, 0xB9, 0x0B, 0x00, 0x04, 0xA4, 0x00, 0x0B, 0x1C, 0xB8,
  // "t" (U+0074)
  0x02, 0x20, 0x00, 0x55, 0x00, 0x5D, 0xDB, 0x00, 0x65, 0x00, 0x06, 0x50, 0x00, 0x56, 0x00, 0x01,
  0xBB, 0x10,
  // "u" (U+0075)
  0x64, 0x08, 0x26, 0x40, 0x82, 0x64, 0x08, 0x25, 0x60, 0xB2, 0x1C, 0xBA, 0x20,
  // "v" (U+0076)
  0x73, 0x07, 0x42, 0x80, 0xA0, 0x0A, 0x19, 0x00, 0x87, 0x40, 0x03, 0xE0, 0x00,
  // "w" (U+0077)
  0xA0, 0x00, 0x9A, 0x2D, 0x27, 0x87, 0xA7, 0x56, 0xB3, 0xC2, 0x4B, 0x0E, 0x00,
  // "x" (U+0078)
  0x38, 0x0A, 0x10, 0x98, 0x60, 0x02, 0xE0, 0x00, 0x96, 0x70, 0x47, 0x0A, 0x20,
  // "y" (U+0079)
  0x73, 0x07, 0x41, 0x90, 0xA0, 0x0A, 0x19, 0x00, 0x59, 0x40, 0x00, 0xD0, 0x00, 0x29, 0x00, 0x5C,
  0x20, 0x00,
  // "z" (U+007A)
  0x1B, 0xBE, 0x00, 0x48, 0x01, 0xA0, 0x09, 0x20, 0x3E, 0xBB,
  // "{" (U+007B)
  0x07, 0x80, 0xB0, 0x0A, 0x00, 0xA0, 0xC5, 0x00, 0xB0, 0x0B, 0x00, 0x78,
  // "|" (U+007C)
  0x80, 0x59,
  // "}" (U+007D)
  0x87, 0x00, 0xB0, 0x0B, 0x00, 0x5C, 0x0A, 0x00, 0xA0, 0x0B, 0x08, 0x70,
  // "~" (U+007E)
  0x19, 0x44, 0x14, 0x16, 0x70,
  // "¡" (U+00A1)
  0x80, 0xAA, 0xBC, 0xC0,
  // "¢" (U+00A2)
  0x00, 0x80, 0x06, 0xDB, 0x1A, 0x00, 0x47, 0x00, 0x2A, 0x00, 0x06, 0xDB, 0x00, 0x80,
  // "£" (U+00A3)
  0x02, 0xCB, 0x00, 0x73, 0x00, 0x08, 0x20, 0x02, 0xDC, 0x60, 0x08, 0x20, 0x00, 0x91, 0x00, 0x3E,
  0xBB, 0x20,
  // "¤" (U+00A4)
  0x3C, 0xBB, 0x11, 0x70, 0x80, 0x17, 0x09, 0x03, 0xAB, 0xB1,
  // "¥" (U+00A5)
  0x83, 0x06, 0x52, 0x80, 0xA0, 0x0A, 0x28, 0x00, 0x6B, 0x20, 0x1C, 0xEA, 0x01, 0xBE, 0xA0, 0x00,
  0xA0, 0x00,
  // "¦" (U+00A6)
  0x0F, 0x93, 0x0F, 0x90,
  // "§" (U+00A7)
  0x0A, 0xB8, 0x0B, 0x00, 0x09, 0xA5, 0x0A, 0x09, 0x05, 0xB8, 0x00, 0x0B, 0x1B, 0xB7,
  // "¨" (U+00A8)
  0x70, 0x60,
  // "©" (U+00A9)
  0x06, 0x75, 0x05, 0x47, 0x43, 0x67, 0x00, 0x65, 0x57, 0x43, 0x06, 0x74, 0x00,
  // "ª" (U+00AA)
  0x37, 0x47, 0x66, 0x45, 0x40,
  // "«" (U+00AB)
  0x03, 0x47, 0x1A, 0x74, 0x0A, 0x57, 0x01, 0x34,
  // "¬" (U+00AC)
  0x4B, 0xBC, 0x10, 0x00, 0x71, 0x00, 0x02, 0x00,
  // "®" (U+00AE)
  0x06, 0x75, 0x05, 0x57, 0x53, 0x64, 0xA1, 0x65, 0x53, 0x73, 0x06, 0x74, 0x00,
  // "¯" (U+00AF)
  0x9B, 0x60,
  // "°" (U+00B0)
  0x48, 0x28, 0x07, 0x49, 0x20,
  // "±" (U+00B1)
  0x00, 0x90, 0x04, 0xBD, 0xB1, 0x00, 0x90, 0x00, 0x09, 0x00, 0x4B, 0xBB, 0x10,
  // "²" (U+00B2)
  0x47, 0x30, 0x26, 0x18, 0x08, 0x85,
  // "³" (U+00B3)
  0x37, 0x32, 0xA3, 0x01, 0x76, 0x82,
  // "´" (U+00B4)
  0x33, 0x90,
  // "µ" (U+00B5)
  0x64, 0x08, 0x26, 0x40, 0x82, 0x64, 0x08, 0x26, 0x60, 0xB2, 0x6E, 0xBA, 0x26, 0x40, 0x00, 0x64,
  0x00, 0x00,
  // "¶" (U+00B6)
  0x2D, 0xFC, 0x47, 0xFF, 0x24, 0x9F, 0xF2, 0x47, 0xFF, 0x24, 0x19, 0xC2, 0x40, 0x06, 0x24, 0x00,
  0x62, 0x40, 0x06, 0x24, 0x00, 0x10, 0x10,
  // "·" (U+00B7)
  0x80,
  // "¸" (U+00B8)
  0x01, 0x09, 0x38,
  // "¹" (U+00B9)
  0x48, 0x01, 0x70, 0x08, 0x03, 0x94,
  // "º" (U+00BA)
  0x67, 0x48, 0x07, 0x47, 0x20,
  // "»" (U+00BB)
  0x43, 0x10, 0x75, 0xA0, 0x47, 0xA1, 0x74, 0x30,
  // "¼" (U+00BC)
  0x86, 0x08, 0x01, 0x61, 0x70, 0x59, 0x81, 0x00, 0x18, 0x92, 0x07, 0x4A, 0x20, 0x86, 0xA6, 0x11,
  0x01, 0x00,
  // "½" (U+00BD)
  0x86, 0x08, 0x01, 0x61, 0x80, 0x6A, 0x72, 0x00, 0x0B, 0x93, 0x05, 0x41, 0x60, 0x90, 0x81, 0x25,
  0x3A, 0x50,
  // "¾" (U+00BE)
  0x58, 0x06, 0x03, 0xB1, 0x80, 0x68, 0x72, 0x00, 0x08, 0xA2, 0x07, 0x5A, 0x20, 0x86, 0xA6, 0x11,
  0x01, 0x00,
  // "¿" (U+00BF)
  0x06, 0x20, 0x03, 0x10, 0x0A, 0x00, 0x86, 0x00, 0xA0, 0x00, 0xA0, 0x00, 0x7B, 0xC1,
  // "À" (U+00C0)
  0x23, 0x00, 0x00, 0x90, 0x00, 0x01, 0xE0, 0x00, 0x6B, 0x20, 0x09, 0x46, 0x00, 0xA0, 0xA0, 0x2D,
  0xBD, 0x07, 0x40, 0x73, 0xA0, 0x03, 0x70,
  // "Á" (U+00C1)
  0x00, 0x33, 0x00, 0x09, 0x00, 0x01, 0xE0, 0x00, 0x6B, 0x20, 0x09, 0x46, 0x00, 0xA0, 0xA0, 0x2D,
  0xBD, 0x07, 0x40, 0x73, 0xA0, 0x03, 0x70,
  // "Â" (U+00C2)
  0x00, 0x60, 0x00, 0x86, 0x60, 0x01, 0xE0, 0x00, 0x6B, 0x20, 0x09, 0x46, 0x00, 0xA0, 0xA0, 0x2D,
  0xBD, 0x07, 0x40, 0x73, 0xA0, 0x03, 0x70,
  // "Ã" (U+00C3)
  0x0A, 0xF6, 0x00, 0x6B, 0x20, 0x09, 0x46, 0x00, 0xA0, 0xA0, 0x2D, 0xBD, 0x07, 0x40, 0x73, 0xA0,
  0x03, 0x70,
  // "Ä" (U+00C4)
  0x07, 0x06, 0x00, 0x1E, 0x00, 0x06, 0xB2, 0x00, 0x94, 0x60, 0x0A, 0x0A, 0x02, 0xDB, 0xD0, 0x74,
  0x07, 0x3A, 0x00, 0x37,
  // "Å" (U+00C5)
  0x03, 0x71, 0x00, 0x5F, 0x10, 0x06, 0xB2, 0x00, 0x94, 0x60, 0x0A, 0x0A, 0x02, 0xDB, 0xD0, 0x74,
  0x07, 0x3A, 0x00, 0x37,
  // "Æ" (U+00C6)
  0x09, 0xEB, 0x40, 0xAA, 0x00, 0x09, 0xA0, 0x03, 0x7B, 0xB2, 0x6C, 0xD0, 0x08, 0x1A, 0x00, 0xA0,
  0xBB, 0x40,
  // "Ç" (U+00C7)
  0x18, 0x46, 0xCC, 0x31, 0xB3, 0x00, 0x53, 0x06, 0x04, 0x30, 0x05, 0x30, 0x20, 0xA4, 0x82, 0x6C,
  0xD1, 0x30, 0x93, 0x03, 0x08, 0x10,
  // "È" (U+00C8)
  0x23, 0x00, 0x00, 0x90, 0x00, 0x3D, 0xBB, 0x13, 0x70, 0x00, 0x37, 0x00, 0x03, 0xDB, 0xB0, 0x37,
  0x00, 0x03, 0x70, 0x00, 0x3D, 0xBB, 0x10,
  // "É" (U+00C9)
  0x00, 0x33, 0x00, 0x09, 0x00, 0x3D, 0xBB, 0x13, 0x70, 0x00, 0x37, 0x00, 0x03, 0xDB, 0xB0, 0x37,
  0x00, 0x03, 0x70, 0x00, 0x3D, 0xBB, 0x10,
  // "Ê" (U+00CA)
  0x00, 0x60, 0x00, 0x86, 0x60, 0x3D, 0xBB, 0x13, 0x70, 0x00, 0x37, 0x00, 0x03, 0xDB, 0xB0, 0x37,
  0x00, 0x03, 0x70, 0x00, 0x3D, 0xBB, 0x10,
  // "Ë" (U+00CB)
  0x07, 0x06, 0x03, 0xDB, 0xB1, 0x37, 0x00, 0x03, 0x70, 0x00, 0x3D, 0xBB, 0x03, 0x70, 0x00, 0x37,
  0x00, 0x03, 0xDB, 0xB1,
  // "Ì" (U+00CC)
  0x23, 0x00, 0x09, 0x00, 0x1B, 0xEA, 0x00, 0xB0, 0x00, 0xB0, 0x00, 0xB0, 0x00, 0xB0, 0x00, 0xB0,
  0x1A, 0xE9,
  // "Í" (U+00CD)
  0x20, 0x03, 0x28, 0x49, 0x01, 0xBE, 0xA2, 0x0B, 0x30, 0xB3, 0x0B, 0x30, 0xB3, 0x84, 0xB0, 0x1A,
  0xE9,
  // "Î" (U+00CE)
  0x20, 0x62, 0x85, 0x86, 0x61, 0xBE, 0xA2, 0x0B, 0x30, 0xB3, 0x0B, 0x30, 0xB3, 0x84, 0xB0, 0x1A,
  0xE9,
  // "Ï" (U+00CF)
  0x07, 0x06, 0x1B, 0xEA, 0x00, 0xB0, 0x00, 0xB0, 0x00, 0xB0, 0x00, 0xB0, 0x00, 0xB0, 0x1A, 0xE9,
  // "Ð" (U+00D0)
  0x5D, 0xC6, 0x05, 0x50, 0xB2, 0x55, 0x05, 0x6D, 0xD4, 0x37, 0x55, 0x05, 0x65, 0x50, 0xB1, 0x5D,
  0xB5, 0x00,
  // "Ñ" (U+00D1)
  0x6F, 0xBD, 0x36, 0xC1, 0x73, 0x67, 0x67, 0x36, 0x39, 0x73, 0x63, 0x88, 0x36, 0x32, 0xD3, 0x63,
  0x0C, 0x30,
  // "Ò" (U+00D2)
  0x23, 0x00, 0x00, 0x90, 0x00, 0x0A, 0xC8, 0x05, 0x60, 0x92, 0x82, 0x05, 0x59, 0x10, 0x46, 0x82,
  0x05, 0x55, 0x60, 0x92, 0x0A, 0xC8, 0x00,
  // "Ó" (U+00D3)
  0x00, 0x33, 0x00, 0x09, 0x00, 0x0A, 0xC8, 0x05, 0x60, 0x92, 0x82, 0x05, 0x59, 0x10, 0x46, 0x82,
  0x05, 0x55, 0x60, 0x92, 0x0A, 0xC8, 0x00,
  // "Ô" (U+00D4)
  0x00, 0x60, 0x00, 0x86, 0x60, 0x0A, 0xC8, 0x05, 0x60, 0x92, 0x82, 0x05, 0x59, 0x10, 0x46, 0x82,
  0x05, 0x55, 0x60, 0x92, 0x0A, 0xC8, 0x00,
  // "Õ" (U+00D5)
  0x0F, 0xFF, 0x05, 0x60, 0x92, 0x82, 0x05, 0x59, 0x10, 0x46, 0x82, 0x05, 0x55, 0x60, 0x92, 0x0A,
  0xC8, 0x00,
  // "Ö" (U+00D6)
  0x07, 0x06, 0x00, 0xAC, 0x80, 0x56, 0x09, 0x28, 0x20, 0x55, 0x91, 0x04, 0x68, 0x20, 0x55, 0x56,
  0x09, 0x20, 0xAC, 0x80,
  // "×" (U+00D7)
  0x12, 0x04, 0x09, 0x77, 0x05, 0xC3, 0x17, 0x08,
  // "Ø" (U+00D8)
  0x0A, 0xCC, 0x35, 0x60, 0xE1, 0x82, 0x6A, 0x59, 0x1A, 0x46, 0x88, 0x45, 0x55, 0xC0, 0x92, 0x5C,
  0xC8, 0x00,
  // "Ù" (U+00D9)
  0x23, 0x00, 0x00, 0x90, 0x00, 0x64, 0x07, 0x36, 0x40, 0x73, 0x64, 0x07, 0x36, 0x40, 0x73, 0x64,
  0x07, 0x34, 0x70, 0xA1, 0x0B, 0xC8, 0x00,
  // "Ú" (U+00DA)
  0x00, 0x33, 0x00, 0x09, 0x00, 0x64, 0x07, 0x36, 0x40, 0x73, 0x64, 0x07, 0x36, 0x40, 0x73, 0x64,
  0x07, 0x34, 0x70, 0xA1, 0x0B, 0xC8, 0x00,
  // "Û" (U+00DB)
  0x00, 0x60, 0x00, 0x86, 0x60, 0x64, 0x07, 0x36, 0x40, 0x73, 0x64, 0x07, 0x36, 0x40, 0x73, 0x64,
  0x07, 0x34, 0x70, 0xA1, 0x0B, 0xC8, 0x00,
  // "Ü" (U+00DC)
  0x07, 0x06, 0x06, 0x40, 0x73, 0x64, 0x07, 0x36, 0x40, 0x73, 0x64, 0x07, 0x36, 0x40, 0x73, 0x47,
  0x0A, 0x10, 0xBC, 0x80,
  // "Ý" (U+00DD)
  0x20, 0x03, 0x30, 0x92, 0x87, 0x84, 0x06, 0x41, 0x90, 0xA2, 0x81, 0x93, 0x72, 0x81, 0x4D, 0x13,
  0x0B, 0x40, 0xA4, 0x0A, 0x20,
  // "Þ" (U+00DE)
  0x37, 0x00, 0x03, 0x70, 0x00, 0x3D, 0xB9, 0x03, 0x70, 0x84, 0x37, 0x08, 0x33, 0xDB, 0x80, 0x37,
  0x00, 0x00,
  // "ß" (U+00DF)
  0x1B, 0xCA, 0x05, 0x50, 0xB0, 0x64, 0x57, 0x06, 0x49, 0x20, 0x64, 0x0A, 0x36, 0x40, 0x28, 0x65,
  0xBC, 0x40,
  // "à" (U+00E0)
  0x02, 0x03, 0x40, 0x97, 0x28, 0x1B, 0xC9, 0x48, 0x97, 0xA0, 0x1A, 0xBD, 0x16, 0x50, 0xA1, 0x2C,
  0xAA, 0x10,
  // "á" (U+00E1)
  0x20, 0x03, 0x30, 0x97, 0x18, 0x1B, 0xC9, 0x48, 0x97, 0xA0, 0x1A, 0xBD, 0x16, 0x50, 0xA1, 0x2C,
  0xAA, 0x10,
  // "â" (U+00E2)
  0x20, 0x63, 0x81, 0x86, 0x67, 0x81, 0xBC, 0x94, 0x89, 0x7A, 0x01, 0xAB, 0xD1, 0x65, 0x0A, 0x12,
  0xCA, 0xA1,
  // "ã" (U+00E3)
  0x09, 0xB6, 0x00, 0xBC, 0x90, 0x00, 0x0A, 0x01, 0xAB, 0xD1, 0x65, 0x0A, 0x12, 0xCA, 0xA1,
  // "ä" (U+00E4)
  0x18, 0x17, 0x06, 0x78, 0x1B, 0xC9, 0x48, 0x97, 0xA0, 0x1A, 0xBD, 0x16, 0x50, 0xA1, 0x2C, 0xAA,
  0x10,
  // "å" (U+00E5)
  0x03, 0x71, 0x00, 0x37, 0x10, 0x0B, 0xC9, 0x00, 0x00, 0xA0, 0x1A, 0xBD, 0x16, 0x50, 0xA1, 0x2C,
  0xAA, 0x10,
  // "æ" (U+00E6)
  0x5C, 0x8C, 0x30, 0x0B, 0x18, 0x6C, 0xEB, 0x8A, 0x0C, 0x00, 0x8B, 0x7B, 0x60,
  // "ç" (U+00E7)
  0x08, 0xBB, 0x29, 0x00, 0x46, 0x00, 0x29, 0x00, 0x08, 0xBD, 0x00, 0x09, 0x00, 0x38,
  // "è" (U+00E8)
  0x02, 0x03, 0x40, 0x97, 0x28, 0x96, 0xAB, 0x80, 0x57, 0x08, 0x27, 0xCB, 0xC4, 0x56, 0x48, 0x29,
  0xBB, 0x10,
  // "é" (U+00E9)
  0x20, 0x03, 0x30, 0x97, 0x18, 0x96, 0xAB, 0x80, 0x57, 0x08, 0x27, 0xCB, 0xC4, 0x56, 0x48, 0x29,
  0xBB, 0x10,
  // "ê" (U+00EA)
  0x20, 0x63, 0x81, 0x86, 0x67, 0x89, 0x6A, 0xB8, 0x05, 0x70, 0x82, 0x7C, 0xBC, 0x45, 0x64, 0x82,
  0x9B, 0xB1,
  // "ë" (U+00EB)
  0x18, 0x17, 0x06, 0x78, 0x96, 0xAB, 0x80, 0x57, 0x08, 0x27, 0xCB, 0xC4, 0x56, 0x48, 0x29, 0xBB,
  0x10,
  // "ì" (U+00EC)
  0x02, 0x03, 0x40, 0x97, 0x18, 0x12, 0xAD, 0x40, 0xB4, 0x0B, 0x40, 0xB2, 0x83, 0x39, 0xE9, 0x20,
  // "í" (U+00ED)
  0x20, 0x03, 0x30, 0x97, 0x81, 0x2A, 0xD4, 0x0B, 0x40, 0xB4, 0x0B, 0x28, 0x33, 0x9E, 0x92,
  // "î" (U+00EE)
  0x20, 0x63, 0x81, 0x86, 0x66, 0x81, 0x2A, 0xD4, 0x0B, 0x40, 0xB4, 0x0B, 0x28, 0x33, 0x9E, 0x92,
  // "ï" (U+00EF)
  0x18, 0x17, 0x06, 0x68, 0x12, 0xAD, 0x40, 0xB4, 0x0B, 0x40, 0xB2, 0x83, 0x39, 0xE9, 0x20,
  // "ð" (U+00F0)
  0x03, 0x14, 0x00, 0x3E, 0x60, 0x04, 0x29, 0x00, 0x9B, 0xC1, 0x56, 0x09, 0x48, 0x20, 0x65, 0x55,
  0x08, 0x20, 0xAB, 0x80,
  // "ñ" (U+00F1)
  0x00, 0x9B, 0x65, 0x9B, 0xB0, 0x58, 0x09, 0x25, 0x50, 0x83, 0x55, 0x08, 0x35, 0x50, 0x83,
  // "ò" (U+00F2)
  0x02, 0x03, 0x40, 0x97, 0x28, 0xA5, 0xBB, 0x80, 0x65, 0x09, 0x38, 0x20, 0x65, 0x65, 0x09, 0x30,
  0xBC, 0x91,
  // "ó" (U+00F3)
  0x20, 0x03, 0x30, 0x97, 0x18, 0xA5, 0xBB, 0x80, 0x65, 0x09, 0x38, 0x20, 0x65, 0x65, 0x09, 0x30,
  0xBC, 0x91,
  // "ô" (U+00F4)
  0x20, 0x63, 0x81, 0x86, 0x67, 0x8A, 0x5B, 0xB8, 0x06, 0x50, 0x93, 0x82, 0x06, 0x56, 0x50, 0x93,
  0x0B, 0xC9, 0x10,
  // "õ" (U+00F5)
  0x09, 0xB6, 0x00, 0xBB, 0x80, 0x65, 0x09, 0x38, 0x20, 0x65, 0x65, 0x09, 0x30, 0xBC, 0x90,
  // "ö" (U+00F6)
  0x18, 0x17, 0x06, 0x78, 0xA5, 0xBB, 0x80, 0x65, 0x09, 0x38, 0x20, 0x65, 0x65, 0x09, 0x30, 0xBC,
  0x91,
  // "÷" (U+00F7)
  0x20, 0x72, 0x83, 0x4B, 0xBB, 0x17, 0x07, 0x20,
  // "ø" (U+00F8)
  0x0B, 0xBC, 0x16, 0x53, 0xD2, 0x83, 0x96, 0x55, 0xC2, 0x93, 0x3D, 0xC9, 0x00,
  // "ù" (U+00F9)
  0x02, 0x03, 0x40, 0x97, 0x18, 0xA7, 0x64, 0x08, 0x26, 0x40, 0x82, 0x64, 0x08, 0x25, 0x60, 0xB2,
  0x1C, 0xBA, 0x20,
  // "ú" (U+00FA)
  0x20, 0x03, 0x30, 0x97, 0x8A, 0x76, 0x40, 0x82, 0x64, 0x08, 0x26, 0x40, 0x82, 0x56, 0x0B, 0x21,
  0xCB, 0xA2,
  // "û" (U+00FB)
  0x20, 0x63, 0x81, 0x86, 0x66, 0x8A, 0x76, 0x40, 0x82, 0x64, 0x08, 0x26, 0x40, 0x82, 0x56, 0x0B,
  0x21, 0xCB, 0xA2,
  // "ü" (U+00FC)
  0x07, 0x06, 0x00, 0x00, 0x00, 0x64, 0x08, 0x26, 0x40, 0x82, 0x64, 0x08, 0x25, 0x60, 0xB2, 0x1C,
  0xBA, 0x20,
  // "ý" (U+00FD)
  0x20, 0x03, 0x30, 0x97, 0x87, 0x73, 0x07, 0x41, 0x90, 0xA2, 0x81, 0xA1, 0x92, 0x81, 0x59, 0x43,
  0x0D, 0x30, 0x20, 0x92, 0x81, 0x5C, 0x22,
  // "þ" (U+00FE)
  0x00, 0x53, 0x00, 0x53, 0x8B, 0x15, 0xAB, 0x90, 0x57, 0x08, 0x35, 0x50, 0x65, 0x58, 0x08, 0x35,
  0xAB, 0xA0, 0x55, 0x30, 0x05, 0x30,
  // "ÿ" (U+00FF)
  0x07, 0x06, 0x00, 0x00, 0x00, 0x73, 0x07, 0x41, 0x90, 0xA0, 0x0A, 0x19, 0x00, 0x59, 0x40, 0x00,
  0xD0, 0x00, 0x29, 0x00, 0x5C, 0x20, 0x00,
  // "Ā" (U+0100)
  0x0A, 0xF6, 0x00, 0x6B, 0x20, 0x09, 0x46, 0x00, 0xA0, 0xA0, 0x2D, 0xBD, 0x07, 0x40, 0x73, 0xA0,
  0x03, 0x70,
  // "ā" (U+0101)
  0x09, 0xB6, 0x00, 0xBC, 0x90, 0x00, 0x0A, 0x01, 0xAB, 0xD1, 0x65, 0x0A, 0x12, 0xCA, 0xA1,
  // "Ă" (U+0102)
  0x01, 0x01, 0x00, 0x7F, 0x40, 0x06, 0xB2, 0x00, 0x94, 0x60, 0x0A, 0x0A, 0x02, 0xDB, 0xD0, 0x74,
  0x07, 0x3A, 0x00, 0x37,
  // "ă" (U+0103)
  0x01, 0x01, 0x00, 0x69, 0x40, 0x0B, 0xC9, 0x00, 0x00, 0xA0, 0x1A, 0xBD, 0x16, 0x50, 0xA1, 0x2C,
  0xAA, 0x10,
  // "Ą" (U+0104)
  0x01, 0xE0, 0x00, 0x6B, 0x20, 0x09, 0x46, 0x00, 0xA0, 0xA0, 0x2D, 0xBD, 0x07, 0x40, 0x73, 0xA0,
  0x03, 0xA0, 0x00, 0x16, 0x00, 0x01, 0x90,
  // "ą" (U+0105)
  0x0B, 0xC9, 0x00, 0x00, 0xA0, 0x1A, 0xBD, 0x16, 0x50, 0xA1, 0x2C, 0xAD, 0x10, 0x01, 0x60, 0x00,
  0x19, 0x00,
  // "Ć" (U+0106)
  0x30, 0x03, 0x30, 0x92, 0x84, 0x6C, 0xC3, 0x1B, 0x30, 0x05, 0x30, 0x60, 0x43, 0x00, 0x53, 0x02,
  0x0A, 0x48, 0x26, 0xCB, 0x10,
  // "ć" (U+0107)
  0x30, 0x03, 0x30, 0x97, 0x84, 0x8B, 0xB0, 0x29, 0x30, 0x40, 0x63, 0x02, 0x09, 0x48, 0x18, 0xBB,
  0x10,
  // "Ĉ" (U+0108)
  0x30, 0x63, 0x89, 0x08, 0x66, 0x06, 0xCC, 0x31, 0xB3, 0x00, 0x53, 0x06, 0x04, 0x30, 0x05, 0x30,
  0x20, 0xA4, 0x82, 0x6C, 0xB1,
  // "ĉ" (U+0109)
  0x30, 0x63, 0x81, 0x86, 0x66, 0x84, 0x8B, 0xB0, 0x29, 0x30, 0x40, 0x63, 0x02, 0x09, 0x48, 0x18,
  0xBB, 0x10,
  // "Ċ" (U+010A)
  0x30, 0x82, 0x84, 0x6C, 0xC3, 0x1B, 0x30, 0x05, 0x30, 0x60, 0x43, 0x00, 0x53, 0x02, 0x0A, 0x48,
  0x26, 0xCB, 0x10,
  // "ċ" (U+010B)
  0x00, 0x08, 0x00, 0x00, 0x08, 0xBB, 0x29, 0x00, 0x46, 0x00, 0x29, 0x00, 0x08, 0xBB,
  // "Č" (U+010C)
  0x00, 0x40, 0x40, 0x04, 0xC1, 0x06, 0xCC, 0x31, 0xB0, 0x00, 0x55, 0x00, 0x06, 0x40, 0x00, 0x55,
  0x00, 0x02, 0xA0, 0x00, 0x06, 0xCB, 0x10,
  // "č" (U+010D)
  0x28, 0x14, 0x04, 0x28, 0x14, 0xC1, 0x68, 0x48, 0xBB, 0x02, 0x93, 0x04, 0x06, 0x30, 0x20, 0x94,
  0x81, 0x8B, 0xB1,
  // "Ď" (U+010E)
  0x04, 0x04, 0x00, 0x4C, 0x10, 0x6C, 0xC5, 0x06, 0x40, 0xB1, 0x64, 0x06, 0x56, 0x40, 0x56, 0x64,
  0x06, 0x46, 0x40, 0xB1, 0x6C, 0xB4, 0x00,
  // "ď" (U+010F)
  0x00, 0x0B, 0x80, 0x00, 0xB1, 0x2C, 0xAB, 0x08, 0x41, 0xC0, 0x91, 0x0B, 0x08, 0x31, 0xC0, 0x2C,
  0xAA, 0x00,
  // "Đ" (U+0110)
  0x5D, 0xC6, 0x05, 0x50, 0xB2, 0x55, 0x05, 0x6D, 0xD4, 0x37, 0x55, 0x05, 0x65, 0x50, 0xB1, 0x5D,
  0xB5, 0x00,
  // "đ" (U+0111)
  0x00, 0x08, 0x20, 0x0B, 0xD9, 0x1B, 0xBB, 0x26, 0x50, 0xB2, 0x83, 0x08, 0x26, 0x50, 0xB2, 0x1B,
  0xBA, 0x20,
  // "Ē" (U+0112)
  0x3F, 0xFF, 0x13, 0x70, 0x00, 0x37, 0x00, 0x03, 0xDB, 0xB0, 0x37, 0x00, 0x03, 0x70, 0x00, 0x3D,
  0xBB, 0x10,
  // "ē" (U+0113)
  0x09, 0xB6, 0x00, 0xAB, 0x80, 0x57, 0x08, 0x27, 0xCB, 0xC4, 0x56, 0x00, 0x00, 0x9B, 0xB1,
  // "Ĕ" (U+0114)
  0x01, 0x01, 0x03, 0xFF, 0xF1, 0x37, 0x00, 0x03, 0x70, 0x00, 0x3D, 0xBB, 0x03, 0x70, 0x00, 0x37,
  0x00, 0x03, 0xDB, 0xB1,
  // "ĕ" (U+0115)
  0x01, 0x01, 0x00, 0x69, 0x40, 0x0A, 0xB8, 0x05, 0x70, 0x82, 0x7C, 0xBC, 0x45, 0x60, 0x00, 0x09,
  0xBB, 0x10,
  // "Ė" (U+0116)
  0x00, 0x80, 0x03, 0xDB, 0xB1, 0x37, 0x00, 0x03, 0x70, 0x00, 0x3D, 0xBB, 0x03, 0x70, 0x00, 0x37,
  0x00, 0x03, 0xDB, 0xB1,
  // "ė" (U+0117)
  0x20, 0x87, 0x18, 0x96, 0xAB, 0x80, 0x57, 0x08, 0x27, 0xCB, 0xC4, 0x56, 0x48, 0x29, 0xBB, 0x10,
  // "Ę" (U+0118)
  0x3D, 0xBB, 0x13, 0x70, 0x00, 0x37, 0x00, 0x03, 0xDB, 0xB0, 0x37, 0x00, 0x03, 0x70, 0x00, 0x3D,
  0xBE, 0x10, 0x01, 0x60, 0x00, 0x19, 0x00,
  // "ę" (U+0119)
  0x0A, 0xB8, 0x05, 0x70, 0x82, 0x7C, 0xBC, 0x45, 0x60, 0x00, 0x09, 0xBC, 0x10, 0x01, 0x60, 0x00,
  0x2C, 0x00,
  // "Ě" (U+011A)
  0x04, 0x04, 0x00, 0x4C, 0x10, 0x3D, 0xBB, 0x13, 0x70, 0x00, 0x37, 0x00, 0x03, 0xDB, 0xB0, 0x37,
  0x00, 0x03, 0x70, 0x00, 0x3D, 0xBB, 0x10,
  // "ě" (U+011B)
  0x04, 0x04, 0x00, 0x4C, 0x10, 0x00, 0x00, 0x00, 0xAB, 0x80, 0x57, 0x08, 0x27, 0xCB, 0xC4, 0x56,
  0x00, 0x00, 0x9B, 0xB1,
  // "Ĝ" (U+011C)
  0x00, 0x06, 0x00, 0x08, 0x66, 0x07, 0xBB, 0x03, 0x90, 0x00, 0x83, 0x00, 0x09, 0x15, 0xC3, 0x83,
  0x07, 0x34, 0x80, 0x73, 0x09, 0xBC, 0x20,
  // "ĝ" (U+011D)
  0x20, 0x63, 0x81, 0x86, 0x67, 0x8A, 0x6B, 0xBA, 0x26, 0x50, 0xA2, 0x83, 0x07, 0x26, 0x50, 0xA2,
  0x1B, 0xBB, 0x23, 0x84, 0xA1, 0x3B, 0xB8, 0x10,
  // "Ğ" (U+011E)
  0x00, 0x10, 0x10, 0x7F, 0xF4, 0x39, 0x00, 0x08, 0x30, 0x00, 0x91, 0x5C, 0x38, 0x30, 0x73, 0x48,
  0x07, 0x30, 0x9B, 0xC2,
  // "ğ" (U+011F)
  0x01, 0x01, 0x00, 0x69, 0x40, 0x0B, 0xBA, 0x26, 0x50, 0xA2, 0x83, 0x07, 0x26, 0x50, 0xA2, 0x1B,
  0xBB, 0x20, 0x00, 0xA1, 0x3B, 0xB8, 0x00,
  // "Ġ" (U+0120)
  0x00, 0x08, 0x00, 0x7B, 0xB0, 0x39, 0x00, 0x08, 0x30, 0x00, 0x91, 0x5C, 0x38, 0x30, 0x73, 0x48,
  0x07, 0x30, 0x9B, 0xC2,
  // "ġ" (U+0121)
  0x20, 0x87, 0x18, 0xA6, 0xBB, 0xA2, 0x65, 0x0A, 0x28, 0x30, 0x72, 0x65, 0x0A, 0x21, 0xBB, 0xB2,
  0x38, 0x4A, 0x13, 0xBB, 0x81,
  // "Ģ" (U+0122)
  0x18, 0x47, 0xBB, 0x03, 0x93, 0x08, 0x03, 0x38, 0xA2, 0x91, 0x5C, 0x38, 0x30, 0x73, 0x48, 0x07,
  0x30, 0x9B, 0xC2, 0x70, 0x60, 0x23, 0x01, 0x20,
  // "ģ" (U+0123)
  0x20, 0x84, 0x01, 0x38, 0xA6, 0xBB, 0xA2, 0x65, 0x0A, 0x28, 0x30, 0x72, 0x65, 0x0A, 0x21, 0xBB,
  0xB2, 0x38, 0x4A, 0x13, 0xBB, 0x81,
  // "Ĥ" (U+0124)
  0x00, 0x60, 0x00, 0x86, 0x60, 0x64, 0x07, 0x36, 0x40, 0x73, 0x64, 0x07, 0x36, 0xCB, 0xD3, 0x64,
  0x07, 0x36, 0x40, 0x73, 0x64, 0x07, 0x30,
  // "ĥ" (U+0125)
  0x10, 0x63, 0x81, 0x86, 0x67, 0x00, 0x53, 0x00, 0x53, 0x8A, 0x75, 0xAB, 0xA0, 0x58, 0x09, 0x25,
  0x50, 0x83, 0x55, 0x08, 0x35, 0x50, 0x83,
  // "Ħ" (U+0126)
  0x64, 0x07, 0x3D, 0xCB, 0xDA, 0x64, 0x07, 0x36, 0xCB, 0xD3, 0x64, 0x07, 0x36, 0x40, 0x73, 0x64,
  0x07, 0x30,
  // "ħ" (U+0127)
  0x55, 0x00, 0x0D, 0xD8, 0x00, 0x5A, 0xBA, 0x05, 0x80, 0x92, 0x55, 0x08, 0x35, 0x50, 0x83, 0x55,
  0x08, 0x30,
  // "Ĩ" (U+0128)
  0x01, 0xB2, 0x0B, 0x30, 0xB3, 0x0B, 0x30, 0xB3, 0x84, 0xB0, 0x1A, 0xE9,
  // "ĩ" (U+0129)
  0x18, 0x59, 0xB6, 0x02, 0xAD, 0x40, 0xB4, 0x0B, 0x40, 0xB2, 0x83, 0x39, 0xE9, 0x20,
  // "Ī" (U+012A)
  0x01, 0xB2, 0x0B, 0x30, 0xB3, 0x0B, 0x30, 0xB3, 0x84, 0xB0, 0x1A, 0xE9,
  // "ī" (U+012B)
  0x18, 0x59, 0xB6, 0x02, 0xAD, 0x40, 0xB4, 0x0B, 0x40, 0xB2, 0x83, 0x39, 0xE9, 0x20,
  // "Ĭ" (U+012C)
  0x01, 0x01, 0x1F, 0xFE, 0x00, 0xB0, 0x00, 0xB0, 0x00, 0xB0, 0x00, 0xB0, 0x00, 0xB0, 0x1A, 0xE9,
  // "ĭ" (U+012D)
  0x18, 0x11, 0x01, 0x28, 0x56, 0x94, 0x02, 0xAD, 0x40, 0xB4, 0x0B, 0x40, 0xB2, 0x83, 0x39, 0xE9,
  0x20,
  // "Į" (U+012E)
  0x1B, 0xEA, 0x00, 0xB0, 0x00, 0xB0, 0x00, 0xB0, 0x00, 0xB0, 0x00, 0xB0, 0x1A, 0xEB, 0x00, 0x16,
  0x00, 0x19,
  // "į" (U+012F)
  0x20, 0x87, 0x81, 0x2A, 0xD4, 0x0B, 0x40, 0xB4, 0x0B, 0x28, 0x33, 0x9E, 0xC2, 0x20, 0x10, 0x63,
  0x01, 0x09, 0x10,
  // "İ" (U+0130)
  0x28, 0x48, 0x01, 0xBE, 0xA2, 0x0B, 0x30, 0xB3, 0x0B, 0x30, 0xB3, 0x84, 0xB0, 0x1A, 0xE9,
  // "ı" (U+0131)
  0x81, 0x2A, 0xD4, 0x0B, 0x40, 0xB4, 0x0B, 0x28, 0x33, 0x9E, 0x92,
  // "Ĳ" (U+0132)
  0x38, 0x0B, 0x38, 0x0B, 0x38, 0x0B, 0x38, 0x0B, 0x38, 0x0B, 0x00, 0x0B, 0x2B, 0xC5,
  // "ĳ" (U+0133)
  0x17, 0x08, 0x00, 0x00, 0x1A, 0x0B, 0x1A, 0x0B, 0x1A, 0x0B, 0x1A, 0x0B, 0x1A, 0x0B, 0x00, 0x0B,
  0x0B, 0xC6,
  // "Ĵ" (U+0134)
  0x30, 0x63, 0x81, 0x86, 0x63, 0x0B, 0x40, 0xB4, 0x0B, 0x40, 0xB4, 0x0B, 0x38, 0x52, 0x90, 0x2B,
  0xC3, 0x10,
  // "ĵ" (U+0135)
  0x30, 0x63, 0x81, 0x86, 0x66, 0x81, 0x8D, 0x23, 0x08, 0x02, 0x30, 0x80, 0x23, 0x08, 0x02, 0x30,
  0x80, 0x23, 0x84, 0x92, 0x06, 0xBA, 0x20,
  // "Ķ" (U+0136)
  0x64, 0x0B, 0x16, 0x46, 0x60, 0x65, 0xB0, 0x06, 0xC9, 0x00, 0x67, 0xA1, 0x06, 0x43, 0x90, 0x64,
  0x0A, 0x20, 0x00, 0x00, 0x06, 0x20, 0x00, 0x10, 0x00,
  // "ķ" (U+0137)
  0x28, 0x00, 0x02, 0x80, 0x00, 0x28, 0x0B, 0x22, 0x88, 0x40, 0x2C, 0xC0, 0x02, 0xA3, 0x90, 0x28,
  0x08, 0x30, 0x00, 0x00, 0x00, 0x62, 0x00, 0x01, 0x00,
  // "ĸ" (U+0138)
  0x28, 0x0B, 0x22, 0x88, 0x40, 0x2C, 0xC0, 0x02, 0xA3, 0x90, 0x28, 0x08, 0x30,
  // "Ĺ" (U+0139)
  0x03, 0x30, 0x00, 0x90, 0x00, 0x19, 0x00, 0x01, 0x90, 0x00, 0x19, 0x00, 0x01, 0x90, 0x00, 0x19,
  0x00, 0x01, 0x90, 0x00, 0x1E, 0xBB, 0x10,
  // "ĺ" (U+013A)
  0x20, 0x03, 0x30, 0x97, 0x81, 0x3B, 0xD4, 0x0B, 0x40, 0xB4, 0x0B, 0x40, 0xB4, 0x0B, 0x28, 0x33,
  0x9D, 0x92,
  // "Ļ" (U+013B)
  0x01, 0x09, 0x30, 0x10, 0x93, 0x01, 0x09, 0x30, 0x10, 0x93, 0x01, 0x09, 0x30, 0x10, 0x93, 0x83,
  0x1E, 0xBB, 0x17, 0x06, 0x02, 0x30, 0x12,
  // "ļ" (U+013C)
  0x81, 0x3B, 0xD4, 0x0B, 0x40, 0xB4, 0x0B, 0x40, 0xB4, 0x0B, 0x28, 0x33, 0x9D, 0x92, 0x70, 0x60,
  0x23, 0x01, 0x20,
  // "Ľ" (U+013D)
  0x19, 0x09, 0x01, 0x90, 0x10, 0x19, 0x00, 0x01, 0x90, 0x00, 0x19, 0x00, 0x01, 0x90, 0x00, 0x1E,
  0xBB, 0x10,
  // "ľ" (U+013E)
  0x83, 0x3B, 0xD4, 0x42, 0x0B, 0x01, 0x30, 0xB4, 0x0B, 0x40, 0xB4, 0x0B, 0x28, 0x33, 0xAE, 0xA2,
  // "Ŀ" (U+013F)
  0x19, 0x00, 0x01, 0x90, 0x00, 0x19, 0x00, 0x01, 0x90, 0x00, 0x19, 0x08, 0x01, 0x90, 0x00, 0x1E,
  0xBB, 0x10,
  // "ŀ" (U+0140)
  0x81, 0x3B, 0xD4, 0x0B, 0x40, 0xB4, 0x81, 0xB0, 0x82, 0x0B, 0x40, 0xB2, 0x83, 0x39, 0xD9, 0x20,
  // "Ł" (U+0141)
  0x10, 0xB4, 0x0B, 0x40, 0xB0, 0x23, 0x0C, 0x0A, 0x20, 0x50, 0xD4, 0x0B, 0x40, 0xFB, 0x05,
  // "ł" (U+0142)
  0x81, 0x3B, 0xD4, 0x0B, 0x40, 0xB0, 0x23, 0x0D, 0x06, 0x20, 0x70, 0xC4, 0x0B, 0x28, 0x33, 0x9D,
  0x92,
  // "Ń" (U+0143)
  0x00, 0x33, 0x00, 0x09, 0x00, 0x6A, 0x07, 0x36, 0xC1, 0x73, 0x67, 0x67, 0x36, 0x39, 0x73, 0x63,
  0x88, 0x36, 0x32, 0xD3, 0x63, 0x0C, 0x30,
  // "ń" (U+0144)
  0x30, 0x03, 0x30, 0x96, 0x8A, 0x75, 0x9B, 0xB0, 0x58, 0x09, 0x25, 0x50, 0x83, 0x55, 0x08, 0x35,
  0x50, 0x83,
  // "Ņ" (U+0145)
  0x8C, 0x16, 0xA0, 0x73, 0x6C, 0x17, 0x36, 0x76, 0x73, 0x63, 0x97, 0x36, 0x38, 0x83, 0x63, 0x2D,
  0x36, 0x30, 0xC3, 0x60, 0x60, 0x23, 0x01, 0x30,
  // "ņ" (U+0146)
  0x8A, 0x75, 0x9B, 0xB0, 0x58, 0x09, 0x25, 0x50, 0x83, 0x55, 0x08, 0x35, 0x50, 0x83, 0x60, 0x60,
  0x23, 0x01, 0x30,
  // "Ň" (U+0147)
  0x04, 0x04, 0x00, 0x4C, 0x10, 0x6A, 0x07, 0x36, 0xC1, 0x73, 0x67, 0x67, 0x36, 0x39, 0x73, 0x63,
  0x88, 0x36, 0x32, 0xD3, 0x63, 0x0C, 0x30,
  // "ň" (U+0148)
  0x00, 0x40, 0x40, 0x04, 0xC1, 0x00, 0x00, 0x05, 0x9B, 0xB0, 0x58, 0x09, 0x25, 0x50, 0x83, 0x55,
  0x08, 0x35, 0x50, 0x83,
  // "ŉ" (U+0149)
  0x1B, 0x00, 0x00, 0x46, 0x00, 0x00, 0x04, 0xB2, 0x80, 0x03, 0x80, 0x82, 0x03, 0x70, 0x83, 0x03,
  0x70, 0x83, 0x03, 0x70, 0x83,
  // "Ŋ" (U+014A)
  0x6A, 0x07, 0x36, 0xC1, 0x73, 0x67, 0x67, 0x36, 0x39, 0x73, 0x63, 0x88, 0x36, 0x32, 0xD3, 0x63,
  0x0C, 0x30, 0x00, 0x82, 0x00, 0xA9, 0x00,
  // "ŋ" (U+014B)
  0x59, 0xBB, 0x05, 0x80, 0x92, 0x55, 0x08, 0x35, 0x50, 0x83, 0x55, 0x08, 0x30, 0x00, 0x83, 0x00,
  0x6C, 0x00,
  // "Ō" (U+014C)
  0x0F, 0xFF, 0x05, 0x60, 0x92, 0x82, 0x05, 0x59, 0x10, 0x46, 0x82, 0x05, 0x55, 0x60, 0x92, 0x0A,
  0xC8, 0x00,
  // "ō" (U+014D)
  0x09, 0xB6, 0x00, 0xBB, 0x80, 0x65, 0x09, 0x38, 0x20, 0x65, 0x65, 0x09, 0x30, 0xBC, 0x90,
  // "Ŏ" (U+014E)
  0x01, 0x01, 0x00, 0xFF, 0xC0, 0x56, 0x09, 0x28, 0x20, 0x55, 0x91, 0x04, 0x68, 0x20, 0x55, 0x56,
  0x09, 0x20, 0xAC, 0x80,
  // "ŏ" (U+014F)
  0x01, 0x01, 0x00, 0x69, 0x40, 0x0B, 0xB8, 0x06, 0x50, 0x93, 0x82, 0x06, 0x56, 0x50, 0x93, 0x0B,
  0xC9, 0x00,
  // "Ő" (U+0150)
  0x56, 0x90, 0x01, 0xBC, 0x80, 0x56, 0x09, 0x28, 0x20, 0x55, 0x91, 0x04, 0x68, 0x20, 0x55, 0x56,
  0x09, 0x20, 0xAC, 0x80,
  // "ő" (U+0151)
  0x56, 0x90, 0x01, 0x00, 0x00, 0x0B, 0xB8, 0x06, 0x50, 0x93, 0x82, 0x06, 0x56, 0x50, 0x93, 0x0B,
  0xC9, 0x00,
  // "Œ" (U+0152)
  0x1B, 0xEC, 0x67, 0x48, 0x20, 0x91, 0x82, 0x0A, 0x18, 0xC4, 0x91, 0x82, 0x07, 0x48, 0x20, 0x1C,
  0xDC, 0x60,
  // "œ" (U+0153)
  0x5C, 0x7C, 0x3A, 0x0C, 0x08, 0x90, 0xBB, 0x89, 0x0C, 0x00, 0x4C, 0x7B, 0x50,
  // "Ŕ" (U+0154)
  0x00, 0x33, 0x00, 0x09, 0x00, 0x3D, 0xB8, 0x03, 0x70, 0xB0, 0x37, 0x0B, 0x03, 0xDD, 0x50, 0x37,
  0x56, 0x03, 0x70, 0xB0, 0x37, 0x07, 0x50,
  // "ŕ" (U+0155)
  0x30, 0x03, 0x30, 0x96, 0x86, 0x4D, 0x9C, 0x60, 0x3C, 0x30, 0x30, 0x83, 0x03, 0x08, 0x28, 0x24,
  0xAC, 0x61,
  // "Ŗ" (U+0156)
  0x8C, 0x13, 0xDB, 0x80, 0x37, 0x0B, 0x03, 0x70, 0xB0, 0x3D, 0xD5, 0x03, 0x75, 0x60, 0x37, 0x0B,
  0x03, 0x70, 0x75, 0x70, 0x60, 0x23, 0x01, 0x20,
  // "ŗ" (U+0157)
  0x86, 0x4D, 0x9C, 0x60, 0x3C, 0x30, 0x30, 0x83, 0x03, 0x08, 0x28, 0x24, 0xAC, 0x67, 0x06, 0x02,
  0x30, 0x13,
  // "Ř" (U+0158)
  0x04, 0x04, 0x00, 0x4C, 0x10, 0x3D, 0xB8, 0x03, 0x70, 0xB0, 0x37, 0x0B, 0x03, 0xDD, 0x50, 0x37,
  0x56, 0x03, 0x70, 0xB0, 0x37, 0x07, 0x50,
  // "ř" (U+0159)
  0x00, 0x40, 0x40, 0x04, 0xC1, 0x00, 0x00, 0x04, 0xD9, 0xC6, 0x03, 0xC0, 0x00, 0x38, 0x00, 0x03,
  0x80, 0x04, 0xAC, 0x60,
  // "Ś" (U+015A)
  0x30, 0x03, 0x30, 0x92, 0x84, 0x9C, 0xB0, 0x29, 0x40, 0xB0, 0x13, 0x81, 0x4C, 0x54, 0x0B, 0x01,
  0x38, 0x49, 0x23, 0xCB, 0x91,
  // "ś" (U+015B)
  0x20, 0x03, 0x20, 0x96, 0x83, 0xAB, 0x90, 0xB3, 0x81, 0x4A, 0x43, 0x83, 0xB1, 0xCB, 0x80,
  // "Ŝ" (U+015C)
  0x30, 0x63, 0x89, 0x08, 0x66, 0x09, 0xCB, 0x02, 0x94, 0x0B, 0x01, 0x38, 0x14, 0xC5, 0x40, 0xB0,
  0x13, 0x84, 0x92, 0x3C, 0xB9, 0x10,
  // "ŝ" (U+015D)
  0x00, 0x60, 0x08, 0x66, 0x00, 0x00, 0x0A, 0xB9, 0x0B, 0x00, 0x04, 0xA4, 0x00, 0x0B, 0x1C, 0xB8,
  // "Ş" (U+015E)
  0x18, 0x49, 0xCB, 0x02, 0x94, 0x0B, 0x01, 0x38, 0x14, 0xC5, 0x40, 0xB0, 0x13, 0x84, 0x92, 0x3C,
  0xD9, 0x30, 0x93, 0x03, 0x08, 0x20,
  // "ş" (U+015F)
  0x0A, 0xB9, 0x0B, 0x00, 0x04, 0xA4, 0x00, 0x0B, 0x1C, 0xD8, 0x00, 0x90, 0x03, 0x80,
  // "Š" (U+0160)
  0x00, 0x40, 0x40, 0x04, 0xC1, 0x09, 0xCB, 0x02, 0x90, 0x00, 0x0B, 0x10, 0x00, 0x4C, 0x50, 0x00,
  0x0B, 0x10, 0x00, 0x92, 0x3C, 0xB9, 0x00,
  // "š" (U+0161)
  0x04, 0x04, 0x04, 0xC1, 0x00, 0x00, 0x0A, 0xB9, 0x0B, 0x00, 0x04, 0xA4, 0x00, 0x0B, 0x1C, 0xB8,
  // "Ţ" (U+0162)
  0x83, 0x7B, 0xEB, 0x52, 0x0B, 0x40, 0xB4, 0x0B, 0x40, 0xB4, 0x0B, 0x40, 0xD4, 0x09, 0x30, 0x30,
  0x82,
  // "ţ" (U+0163)
  0x02, 0x20, 0x00, 0x55, 0x00, 0x5D, 0xDB, 0x00, 0x65, 0x00, 0x06, 0x50, 0x00, 0x56, 0x00, 0x01,
  0xBD, 0x10, 0x00, 0x90, 0x00, 0x38, 0x00,
  // "Ť" (U+0164)
  0x18, 0x14, 0x04, 0x28, 0x74, 0xC1, 0x07, 0xBE, 0xB5, 0x20, 0xB4, 0x0B, 0x40, 0xB4, 0x0B, 0x40,
  0xB4, 0x0B, 0x20,
  // "ť" (U+0165)
  0x01, 0x19, 0x00, 0x55, 0x10, 0x5D, 0xDB, 0x00, 0x65, 0x00, 0x06, 0x50, 0x00, 0x56, 0x00, 0x01,
  0xBB, 0x10,
  // "Ŧ" (U+0166)
  0x83, 0x7B, 0xEB, 0x52, 0x0B, 0x40, 0xB2, 0x82, 0x1B, 0xEB, 0x30, 0xB4, 0x0B, 0x40, 0xB2,
  // "ŧ" (U+0167)
  0x02, 0x20, 0x00, 0x55, 0x00, 0x5D, 0xDB, 0x00, 0x65, 0x00, 0x6D, 0xDB, 0x10, 0x55, 0x00, 0x02,
  0xCB, 0x10,
  // "Ũ" (U+0168)
  0x6D, 0xBE, 0x36, 0x40, 0x73, 0x64, 0x07, 0x36, 0x40, 0x73, 0x64, 0x07, 0x34, 0x70, 0xA1, 0x0B,
  0xC8, 0x00,
  // "ũ" (U+0169)
  0x09, 0xB6, 0x06, 0x40, 0x82, 0x64, 0x08, 0x26, 0x40, 0x82, 0x56, 0x0B, 0x21, 0xCB, 0xA2,
  // "Ū" (U+016A)
  0x6D, 0xBE, 0x36, 0x40, 0x73, 0x64, 0x07, 0x36, 0x40, 0x73, 0x64, 0x07, 0x34, 0x70, 0xA1, 0x0B,
  0xC8, 0x00,
  // "ū" (U+016B)
  0x09, 0xB6, 0x06, 0x40, 0x82, 0x64, 0x08, 0x26, 0x40, 0x82, 0x56, 0x0B, 0x21, 0xCB, 0xA2,
  // "Ŭ" (U+016C)
  0x01, 0x01, 0x06, 0xA9, 0xB3, 0x64, 0x07, 0x36, 0x40, 0x73, 0x64, 0x07, 0x36, 0x40, 0x73, 0x47,
  0x0A, 0x10, 0xBC, 0x80,
  // "ŭ" (U+016D)
  0x01, 0x01, 0x00, 0x69, 0x40, 0x64, 0x08, 0x26, 0x40, 0x82, 0x64, 0x08, 0x25, 0x60, 0xB2, 0x1C,
  0xBA, 0x20,
  // "Ů" (U+016E)
  0x03, 0x71, 0x06, 0x77, 0x83, 0x64, 0x07, 0x36, 0x40, 0x73, 0x64, 0x07, 0x36, 0x40, 0x73, 0x47,
  0x0A, 0x10, 0xBC, 0x80,
  // "ů" (U+016F)
  0x03, 0x71, 0x00, 0x37, 0x10, 0x64, 0x08, 0x26, 0x40, 0x82, 0x64, 0x08, 0x25, 0x60, 0xB2, 0x1C,
  0xBA, 0x20,
  // "Ű" (U+0170)
  0x56, 0x90, 0x08, 0x50, 0x73, 0x64, 0x07, 0x36, 0x40, 0x73, 0x64, 0x07, 0x36, 0x40, 0x73, 0x47,
  0x0A, 0x10, 0xBC, 0x80,
  // "ű" (U+0171)
  0x56, 0x90, 0x01, 0x00, 0x00, 0x64, 0x08, 0x26, 0x40, 0x82, 0x64, 0x08, 0x25, 0x60, 0xB2, 0x1C,
  0xBA, 0x20,
  // "Ų" (U+0172)
  0x64, 0x07, 0x36, 0x40, 0x73, 0x64, 0x07, 0x36, 0x40, 0x73, 0x64, 0x07, 0x34, 0x70, 0xA0, 0x0B,
  0xC6, 0x00, 0x07, 0x00, 0x00, 0xC2, 0x00,
  // "ų" (U+0173)
  0x64, 0x08, 0x26, 0x40, 0x82, 0x64, 0x08, 0x25, 0x60, 0xB2, 0x1C, 0xBD, 0x20, 0x01, 0x60, 0x00,
  0x19, 0x00,
  // "Ŵ" (U+0174)
  0x00, 0x60, 0x00, 0x86, 0x60, 0xA0, 0x01, 0x89, 0x00, 0x27, 0x81, 0xD3, 0x67, 0x5B, 0x54, 0x69,
  0x69, 0x34, 0xB1, 0xD2, 0x3A, 0x0D, 0x10,
  // "ŵ" (U+0175)
  0x20, 0x63, 0x81, 0x86, 0x66, 0x0A, 0x38, 0xA2, 0x9A, 0x2D, 0x27, 0x87, 0xA7, 0x56, 0xB3, 0xC2,
  0x4B, 0x0E, 0x10,
  // "Ŷ" (U+0176)
  0x20, 0x63, 0x89, 0x38, 0x66, 0x08, 0x40, 0x64, 0x19, 0x0A, 0x28, 0x19, 0x37, 0x28, 0x14, 0xD1,
  0x30, 0xB4, 0x0A, 0x40, 0xA2,
  // "ŷ" (U+0177)
  0x20, 0x63, 0x81, 0x86, 0x66, 0x87, 0x73, 0x07, 0x41, 0x90, 0xA2, 0x81, 0xA1, 0x92, 0x81, 0x59,
  0x43, 0x0D, 0x30, 0x20, 0x92, 0x81, 0x5C, 0x22,
  // "Ÿ" (U+0178)
  0x07, 0x06, 0x08, 0x40, 0x64, 0x19, 0x0A, 0x00, 0x93, 0x70, 0x04, 0xD1, 0x00, 0x0B, 0x00, 0x00,
  0xA0, 0x00, 0x0A, 0x00,
  // "Ź" (U+0179)
  0x30, 0x03, 0x30, 0x92, 0x81, 0xBB, 0xE3, 0x01, 0x0A, 0x30, 0x70, 0x33, 0x0A, 0x30, 0x60, 0x53,
  0x0B, 0x38, 0x23, 0xDB, 0xB1,
  // "ź" (U+017A)
  0x00, 0x33, 0x00, 0x90, 0x00, 0x00, 0x1B, 0xBE, 0x00, 0x48, 0x01, 0xA0, 0x09, 0x20, 0x3E, 0xBB,
  // "Ż" (U+017B)
  0x00, 0x08, 0x0B, 0xBE, 0x00, 0x1A, 0x00, 0x73, 0x00, 0xA0, 0x06, 0x50, 0x0B, 0x00, 0x3D, 0xBB,
  // "ż" (U+017C)
  0x00, 0x80, 0x00, 0x00, 0x1B, 0xBE, 0x00, 0x48, 0x01, 0xA0, 0x09, 0x20, 0x3E, 0xBB,
  // "Ž" (U+017D)
  0x00, 0x40, 0x40, 0x04, 0xC1, 0x0B, 0xBE, 0x00, 0x01, 0xA0, 0x00, 0x73, 0x00, 0x0A, 0x00, 0x06,
  0x50, 0x00, 0xB0, 0x00, 0x3D, 0xBB, 0x00,
  // "ž" (U+017E)
  0x04, 0x04, 0x04, 0xC1, 0x00, 0x00, 0x1B, 0xBE, 0x00, 0x48, 0x01, 0xA0, 0x09, 0x20, 0x3E, 0xBB,
  // "ſ" (U+017F)
  0x0B, 0xB3, 0x38, 0x00, 0x37, 0x00, 0x37, 0x00, 0x37, 0x00, 0x37, 0x00, 0x37, 0x00,
  // "Ω" (U+03A9)
  0x0A, 0xB8, 0x05, 0x70, 0xA2, 0x82, 0x06, 0x58, 0x20, 0x55, 0x64, 0x07, 0x32, 0x80, 0x90, 0x9E,
  0x2E, 0x70,
  // "μ" (U+03BC)
  0x64, 0x08, 0x26, 0x40, 0x82, 0x64, 0x08, 0x26, 0x60, 0xB2, 0x6E, 0xBA, 0x26, 0x40, 0x00, 0x64,
  0x00, 0x00,
  // "π" (U+03C0)
  0x6E, 0xBE, 0x50, 0xA0, 0xA0, 0x0A, 0x0A, 0x00, 0xA0, 0xA0, 0x0A, 0x0C, 0x40,
  // "–" (U+2013)
  0x2B, 0xBB,
  // "—" (U+2014)
  0xBB, 0xBB, 0x90,
  // "€" (U+20AC)
  0x01, 0xBC, 0x50, 0x92, 0x01, 0x0A, 0x00, 0x06, 0xD9, 0x50, 0x6D, 0x95, 0x00, 0xB1, 0x00, 0x02,
  0xCB, 0x50,
  // "₿" (U+20BF)
  0x07, 0x51, 0x03, 0xDC, 0x90, 0x36, 0x09, 0x23, 0x60, 0xA1, 0x3D, 0xC9, 0x03, 0x60, 0x83, 0x36,
  0x07, 0x43, 0xDC, 0xB0, 0x06, 0x51, 0x00,
  // "‘" (U+2018)
  0x9A, 0x10,
  // "’" (U+2019)
  0x0C, 0x27,
  // "‚" (U+201A)
  0x02, 0x0C, 0x37,
  // "‛" (U+201B)
  0x1A, 0x09, 0x01,
  // "“" (U+201C)
  0x90, 0x9A, 0x0A, 0x10, 0x10,
  // "”" (U+201D)
  0x10, 0x1A, 0x0A, 0x90, 0x90,
  // "„" (U+201E)
  0x02, 0x02, 0x0C, 0x0C, 0x37, 0x37,
  // "‟" (U+201F)
  0x10, 0x1A, 0x0A, 0x90, 0x90,
  // "†" (U+2020)
  0x20, 0xA2, 0x85, 0x28, 0x21, 0x8A, 0x72, 0x07, 0x30, 0x93, 0x0A, 0x30, 0xB1,
  // "‡" (U+2021)
  0x00, 0xA0, 0x14, 0x95, 0x15, 0xA5, 0x00, 0xA0, 0x03, 0x94, 0x15, 0xA5, 0x00, 0xA0,
  // "•" (U+2022)
  0x5F, 0x24, 0xD2,
  // "…" (U+2026)
  0x80, 0x80, 0x80,
  // "‰" (U+2030)
  0x99, 0x00, 0x09, 0x90, 0x00, 0x78, 0x58, 0x02, 0x93, 0x00, 0x0A, 0x6A, 0x50, 0x8B, 0x79, 0x0B,
  0x7B, 0x60,
  // "‹" (U+2039)
  0x05, 0x13, 0x70, 0x29, 0x00, 0x31,
  // "›" (U+203A)
  0x13, 0x00, 0x92, 0x07, 0x31, 0x50,
  // "⁄" (U+2044)
  0x00, 0x45, 0x00, 0x80, 0x00, 0x90, 0x04, 0x40, 0x09, 0x00, 0x08, 0x00, 0x54, 0x00,
  // "™" (U+2122)
  0x1D, 0xCB, 0x2A, 0x04, 0x2B, 0x79, 0x04, 0x28, 0xB8, 0x02, 0x13, 0x33,
  // "⅒" (U+2152)
  0x40, 0x40, 0x55, 0x04, 0x08, 0x20, 0x86, 0x01, 0x07, 0x20, 0x97, 0x8A, 0x38, 0x04, 0x44, 0x80,
  0x47, 0x33, 0x94, 0x90, 0x17, 0x08, 0x08, 0x30, 0x82, 0x83, 0x80, 0x80, 0x82, 0x87, 0x54, 0x03,
  0x94, 0x47, 0x30,
  // "∂" (U+2202)
  0x06, 0xE9, 0x00, 0x10, 0xC1, 0x0A, 0xEB, 0x26, 0x70, 0xB0, 0x83, 0x3A, 0x04, 0xEC, 0x20,
  // "∆" (U+2206)
  0x01, 0xD0, 0x00, 0x6B, 0x20, 0x0A, 0x37, 0x00, 0xA0, 0xA0, 0x46, 0x09, 0x18, 0x20, 0x55, 0xCA,
  0xAB, 0x90,
  // "√" (U+221A)
  0x00, 0x00, 0x40, 0x00, 0x17, 0x00, 0x06, 0x20, 0x00, 0x90, 0xA5, 0x08, 0x00, 0x95, 0x30, 0x08,
  0x90, 0x00, 0x39, 0x00,
  // "∞" (U+221E)
  0x8D, 0x3E, 0x6A, 0x3C, 0x29, 0x9D, 0x4E, 0x60,
  // "≈" (U+2248)
  0x5B, 0xBB, 0x30, 0x00, 0x00, 0x5B, 0xBB, 0x30,
  // "≠" (U+2260)
  0x00, 0x36, 0x05, 0xDE, 0xD3, 0x5E, 0xED, 0x30, 0x90, 0x00,
  // "≤" (U+2264)
  0x40, 0x12, 0x84, 0x49, 0x32, 0xA4, 0x38, 0x15, 0x85, 0x48, 0x53, 0x43, 0xDD, 0xD6,
  // "≥" (U+2265)
  0x10, 0x00, 0x03, 0x94, 0x00, 0x00, 0x4A, 0x20, 0x58, 0x50, 0x43, 0x00, 0x06, 0xDD, 0xD3,
};

const Font& font_NotoSansMono_Regular_8() {
  static SmoothFont font(font_NotoSansMono_Regular_8_data);
  return font;
}

}  // namespace roo_display
