#include "60.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSansMono-Regular (Noto Sans Mono Regular)
// Generated on Wed Nov 19 19:10:53 CET 2025
static const uint8_t font_NotoSansMono_Regular_60_data[] PROGMEM = {
  
  // Header
  0x01, 0x02, 0x04, 0x02, 0x01, 0x03, 0x01, 0x01, 0x5D, 0x00, 0x00,
  0xF4, 0xF3, 0x5D, 0x3D, 0x2E, 0xF2, 0x0F, 0x00, 0x6C, 0x11, 0x24, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x0E, 0x00, 0x15, 0x2B, 0x24, 0x00, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x09, 0x1C, 0x1A, 0x2B, 0x24, 0x00, 0x00, 0x71, // """ (U+0022)
  0x00, 0x23, 0x01, 0x01, 0x22, 0x2B, 0x24, 0x00, 0x00, 0xCB, // "#" (U+0023)
  0x00, 0x24, 0x04, 0xFD, 0x1F, 0x2E, 0x24, 0x00, 0x01, 0xEB, // "$" (U+0024)
  0x00, 0x25, 0x00, 0x00, 0x23, 0x2C, 0x24, 0x00, 0x03, 0x25, // "%" (U+0025)
  0x00, 0x26, 0x02, 0x00, 0x22, 0x2C, 0x24, 0x00, 0x04, 0xB3, // "&" (U+0026)
  0x00, 0x27, 0x0F, 0x1C, 0x14, 0x2B, 0x24, 0x00, 0x06, 0x00, // "'" (U+0027)
  0x00, 0x28, 0x0C, 0xF7, 0x19, 0x2B, 0x24, 0x00, 0x06, 0x24, // "(" (U+0028)
  0x00, 0x29, 0x0A, 0xF7, 0x17, 0x2B, 0x24, 0x00, 0x06, 0xD9, // ")" (U+0029)
  0x00, 0x2A, 0x05, 0x15, 0x1E, 0x2D, 0x24, 0x00, 0x07, 0x90, // "*" (U+002A)
  0x00, 0x2B, 0x04, 0x08, 0x1F, 0x23, 0x24, 0x00, 0x08, 0x29, // "+" (U+002B)
  0x00, 0x2C, 0x0C, 0xF9, 0x16, 0x08, 0x24, 0x00, 0x08, 0xA8, // "," (U+002C)
  0x00, 0x2D, 0x09, 0x0F, 0x1A, 0x13, 0x24, 0x00, 0x08, 0xD9, // "-" (U+002D)
  0x00, 0x2E, 0x0E, 0x00, 0x15, 0x08, 0x24, 0x00, 0x08, 0xDF, // "." (U+002E)
  0x00, 0x2F, 0x07, 0x01, 0x1C, 0x2B, 0x24, 0x00, 0x08, 0xFA, // "/" (U+002F)
  0x00, 0x30, 0x03, 0x00, 0x20, 0x2C, 0x24, 0x00, 0x09, 0xA8, // "0" (U+0030)
  0x00, 0x31, 0x06, 0x01, 0x1F, 0x2B, 0x24, 0x00, 0x0B, 0x07, // "1" (U+0031)
  0x00, 0x32, 0x04, 0x01, 0x20, 0x2C, 0x24, 0x00, 0x0B, 0xB0, // "2" (U+0032)
  0x00, 0x33, 0x04, 0x00, 0x1F, 0x2C, 0x24, 0x00, 0x0C, 0x86, // "3" (U+0033)
  0x00, 0x34, 0x03, 0x01, 0x20, 0x2B, 0x24, 0x00, 0x0D, 0x85, // "4" (U+0034)
  0x00, 0x35, 0x04, 0x00, 0x1F, 0x2B, 0x24, 0x00, 0x0E, 0x6F, // "5" (U+0035)
  0x00, 0x36, 0x03, 0x00, 0x20, 0x2C, 0x24, 0x00, 0x0F, 0x53, // "6" (U+0036)
  0x00, 0x37, 0x03, 0x01, 0x20, 0x2B, 0x24, 0x00, 0x10, 0x7B, // "7" (U+0037)
  0x00, 0x38, 0x04, 0x00, 0x1F, 0x2C, 0x24, 0x00, 0x11, 0x3C, // "8" (U+0038)
  0x00, 0x39, 0x03, 0x00, 0x20, 0x2C, 0x24, 0x00, 0x12, 0x72, // "9" (U+0039)
  0x00, 0x3A, 0x0E, 0x00, 0x15, 0x21, 0x24, 0x00, 0x13, 0x99, // ":" (U+003A)
  0x00, 0x3B, 0x0C, 0xF8, 0x17, 0x21, 0x24, 0x00, 0x13, 0xCF, // ";" (U+003B)
  0x00, 0x3C, 0x05, 0x08, 0x1E, 0x25, 0x24, 0x00, 0x14, 0x20, // "<" (U+003C)
  0x00, 0x3D, 0x04, 0x0E, 0x1F, 0x1D, 0x24, 0x00, 0x14, 0xC4, // "=" (U+003D)
  0x00, 0x3E, 0x05, 0x08, 0x1E, 0x25, 0x24, 0x00, 0x14, 0xED, // ">" (U+003E)
  0x00, 0x3F, 0x05, 0x00, 0x1E, 0x2C, 0x24, 0x00, 0x15, 0x91, // "?" (U+003F)
  0x00, 0x40, 0x00, 0xFB, 0x23, 0x2B, 0x24, 0x00, 0x16, 0x5D, // "@" (U+0040)
  0x00, 0x41, 0x01, 0x01, 0x22, 0x2B, 0x24, 0x00, 0x18, 0x27, // "A" (U+0041)
  0x00, 0x42, 0x05, 0x01, 0x20, 0x2B, 0x24, 0x00, 0x19, 0x38, // "B" (U+0042)
  0x00, 0x43, 0x04, 0x00, 0x20, 0x2C, 0x24, 0x00, 0x1A, 0x55, // "C" (U+0043)
  0x00, 0x44, 0x04, 0x01, 0x21, 0x2B, 0x24, 0x00, 0x1B, 0x3B, // "D" (U+0044)
  0x00, 0x45, 0x05, 0x01, 0x1E, 0x2B, 0x24, 0x00, 0x1C, 0x62, // "E" (U+0045)
  0x00, 0x46, 0x05, 0x01, 0x1E, 0x2B, 0x24, 0x00, 0x1D, 0x17, // "F" (U+0046)
  0x00, 0x47, 0x02, 0x00, 0x1F, 0x2C, 0x24, 0x00, 0x1D, 0xCA, // "G" (U+0047)
  0x00, 0x48, 0x04, 0x01, 0x1F, 0x2B, 0x24, 0x00, 0x1E, 0xE4, // "H" (U+0048)
  0x00, 0x49, 0x06, 0x01, 0x1D, 0x2B, 0x24, 0x00, 0x1F, 0xDE, // "I" (U+0049)
  0x00, 0x4A, 0x06, 0x00, 0x1B, 0x2B, 0x24, 0x00, 0x20, 0x97, // "J" (U+004A)
  0x00, 0x4B, 0x04, 0x01, 0x20, 0x2B, 0x24, 0x00, 0x21, 0x55, // "K" (U+004B)
  0x00, 0x4C, 0x06, 0x01, 0x1E, 0x2B, 0x24, 0x00, 0x22, 0x7D, // "L" (U+004C)
  0x00, 0x4D, 0x03, 0x01, 0x20, 0x2B, 0x24, 0x00, 0x23, 0x2B, // "M" (U+004D)
  0x00, 0x4E, 0x04, 0x01, 0x1F, 0x2B, 0x24, 0x00, 0x24, 0x51, // "N" (U+004E)
  0x00, 0x4F, 0x02, 0x00, 0x21, 0x2C, 0x24, 0x00, 0x25, 0x92, // "O" (U+004F)
  0x00, 0x50, 0x05, 0x01, 0x20, 0x2B, 0x24, 0x00, 0x26, 0xC8, // "P" (U+0050)
  0x00, 0x51, 0x02, 0xF6, 0x21, 0x2C, 0x24, 0x00, 0x27, 0xB7, // "Q" (U+0051)
  0x00, 0x52, 0x05, 0x01, 0x21, 0x2B, 0x24, 0x00, 0x29, 0x1D, // "R" (U+0052)
  0x00, 0x53, 0x05, 0x00, 0x1F, 0x2C, 0x24, 0x00, 0x2A, 0x3A, // "S" (U+0053)
  0x00, 0x54, 0x02, 0x01, 0x21, 0x2B, 0x24, 0x00, 0x2B, 0x2F, // "T" (U+0054)
  0x00, 0x55, 0x04, 0x00, 0x1F, 0x2B, 0x24, 0x00, 0x2B, 0xF4, // "U" (U+0055)
  0x00, 0x56, 0x01, 0x01, 0x22, 0x2B, 0x24, 0x00, 0x2D, 0x05, // "V" (U+0056)
  0x00, 0x57, 0x01, 0x01, 0x22, 0x2B, 0x24, 0x00, 0x2E, 0x1F, // "W" (U+0057)
  0x00, 0x58, 0x02, 0x01, 0x21, 0x2B, 0x24, 0x00, 0x2F, 0xA1, // "X" (U+0058)
  0x00, 0x59, 0x02, 0x01, 0x21, 0x2B, 0x24, 0x00, 0x30, 0xC0, // "Y" (U+0059)
  0x00, 0x5A, 0x05, 0x01, 0x1E, 0x2B, 0x24, 0x00, 0x31, 0xB7, // "Z" (U+005A)
  0x00, 0x5B, 0x0E, 0xF7, 0x1B, 0x2B, 0x24, 0x00, 0x32, 0x6F, // "[" (U+005B)
  0x00, 0x5C, 0x07, 0x01, 0x1C, 0x2B, 0x24, 0x00, 0x33, 0x29, // "\" (U+005C)
  0x00, 0x5D, 0x08, 0xF8, 0x15, 0x2C, 0x24, 0x00, 0x33, 0xD4, // "]" (U+005D)
  0x00, 0x5E, 0x03, 0x11, 0x20, 0x2C, 0x24, 0x00, 0x34, 0x8E, // "^" (U+005E)
  0x00, 0x5F, 0x00, 0xF8, 0x23, 0xFC, 0x24, 0x00, 0x35, 0x42, // "_" (U+005F)
  0x00, 0x60, 0x0B, 0x26, 0x17, 0x2F, 0x24, 0x00, 0x35, 0x48, // "`" (U+0060)
  0x00, 0x61, 0x04, 0x00, 0x1E, 0x21, 0x24, 0x00, 0x35, 0x6F, // "a" (U+0061)
  0x00, 0x62, 0x04, 0x00, 0x20, 0x2E, 0x24, 0x00, 0x36, 0x49, // "b" (U+0062)
  0x00, 0x63, 0x05, 0x00, 0x1E, 0x21, 0x24, 0x00, 0x37, 0x6B, // "c" (U+0063)
  0x00, 0x64, 0x03, 0x00, 0x1F, 0x2E, 0x24, 0x00, 0x38, 0x18, // "d" (U+0064)
  0x00, 0x65, 0x03, 0x00, 0x20, 0x21, 0x24, 0x00, 0x39, 0x48, // "e" (U+0065)
  0x00, 0x66, 0x04, 0x01, 0x22, 0x2E, 0x24, 0x00, 0x3A, 0x14, // "f" (U+0066)
  0x00, 0x67, 0x03, 0xF3, 0x1F, 0x21, 0x24, 0x00, 0x3A, 0xF3, // "g" (U+0067)
  0x00, 0x68, 0x04, 0x01, 0x1F, 0x2E, 0x24, 0x00, 0x3C, 0x32, // "h" (U+0068)
  0x00, 0x69, 0x04, 0x01, 0x20, 0x2E, 0x24, 0x00, 0x3D, 0x4B, // "i" (U+0069)
  0x00, 0x6A, 0x03, 0xF3, 0x18, 0x2E, 0x24, 0x00, 0x3E, 0x0D, // "j" (U+006A)
  0x00, 0x6B, 0x06, 0x01, 0x21, 0x2E, 0x24, 0x00, 0x3E, 0xFA, // "k" (U+006B)
  0x00, 0x6C, 0x04, 0x01, 0x20, 0x2E, 0x24, 0x00, 0x40, 0x18, // "l" (U+006C)
  0x00, 0x6D, 0x03, 0x01, 0x21, 0x21, 0x24, 0x00, 0x40, 0xF0, // "m" (U+006D)
  0x00, 0x6E, 0x04, 0x01, 0x1F, 0x21, 0x24, 0x00, 0x41, 0xF3, // "n" (U+006E)
  0x00, 0x6F, 0x03, 0x00, 0x20, 0x21, 0x24, 0x00, 0x42, 0xD5, // "o" (U+006F)
  0x00, 0x70, 0x04, 0xF3, 0x20, 0x21, 0x24, 0x00, 0x43, 0xBC, // "p" (U+0070)
  0x00, 0x71, 0x03, 0xF3, 0x1F, 0x21, 0x24, 0x00, 0x44, 0xF0, // "q" (U+0071)
  0x00, 0x72, 0x03, 0x01, 0x22, 0x21, 0x24, 0x00, 0x46, 0x1F, // "r" (U+0072)
  0x00, 0x73, 0x06, 0x00, 0x1D, 0x21, 0x24, 0x00, 0x46, 0xD8, // "s" (U+0073)
  0x00, 0x74, 0x03, 0x00, 0x1E, 0x29, 0x24, 0x00, 0x47, 0x96, // "t" (U+0074)
  0x00, 0x75, 0x04, 0x00, 0x1F, 0x20, 0x24, 0x00, 0x48, 0x61, // "u" (U+0075)
  0x00, 0x76, 0x02, 0x01, 0x21, 0x20, 0x24, 0x00, 0x49, 0x42, // "v" (U+0076)
  0x00, 0x77, 0x01, 0x01, 0x22, 0x20, 0x24, 0x00, 0x4A, 0x13, // "w" (U+0077)
  0x00, 0x78, 0x03, 0x01, 0x20, 0x20, 0x24, 0x00, 0x4B, 0x35, // "x" (U+0078)
  0x00, 0x79, 0x02, 0xF3, 0x21, 0x20, 0x24, 0x00, 0x4C, 0x09, // "y" (U+0079)
  0x00, 0x7A, 0x05, 0x01, 0x1E, 0x20, 0x24, 0x00, 0x4D, 0x23, // "z" (U+007A)
  0x00, 0x7B, 0x08, 0xF7, 0x1B, 0x2B, 0x24, 0x00, 0x4D, 0xB5, // "{" (U+007B)
  0x00, 0x7C, 0x0F, 0xF3, 0x14, 0x2E, 0x24, 0x00, 0x4E, 0x8A, // "|" (U+007C)
  0x00, 0x7D, 0x08, 0xF7, 0x1B, 0x2B, 0x24, 0x00, 0x4F, 0x20, // "}" (U+007D)
  0x00, 0x7E, 0x04, 0x12, 0x1F, 0x1C, 0x24, 0x00, 0x4F, 0xF5, // "~" (U+007E)
  0x00, 0xA1, 0x0E, 0xF6, 0x15, 0x21, 0x24, 0x00, 0x50, 0x50, // "¡" (U+00A1)
  0x00, 0xA2, 0x05, 0x00, 0x1E, 0x2C, 0x24, 0x00, 0x50, 0xC1, // "¢" (U+00A2)
  0x00, 0xA3, 0x05, 0x01, 0x1F, 0x2C, 0x24, 0x00, 0x51, 0x9F, // "£" (U+00A3)
  0x00, 0xA4, 0x04, 0x09, 0x1F, 0x24, 0x24, 0x00, 0x52, 0x5B, // "¤" (U+00A4)
  0x00, 0xA5, 0x02, 0x01, 0x21, 0x2B, 0x24, 0x00, 0x53, 0x26, // "¥" (U+00A5)
  0x00, 0xA6, 0x0F, 0xF3, 0x14, 0x2E, 0x24, 0x00, 0x54, 0x2E, // "¦" (U+00A6)
  0x00, 0xA7, 0x06, 0x00, 0x1D, 0x2E, 0x24, 0x00, 0x54, 0xA4, // "§" (U+00A7)
  0x00, 0xA8, 0x08, 0x27, 0x1C, 0x2D, 0x24, 0x00, 0x55, 0xC1, // "¨" (U+00A8)
  0x00, 0xA9, 0x02, 0x07, 0x21, 0x25, 0x24, 0x00, 0x55, 0xEE, // "©" (U+00A9)
  0x00, 0xAA, 0x09, 0x18, 0x19, 0x2B, 0x24, 0x00, 0x57, 0x1D, // "ª" (U+00AA)
  0x00, 0xAB, 0x05, 0x04, 0x1E, 0x1D, 0x24, 0x00, 0x57, 0x93, // "«" (U+00AB)
  0x00, 0xAC, 0x04, 0x08, 0x1E, 0x18, 0x24, 0x00, 0x58, 0x50, // "¬" (U+00AC)
  0x00, 0xAE, 0x02, 0x07, 0x21, 0x25, 0x24, 0x00, 0x58, 0x9C, // "®" (U+00AE)
  0x00, 0xAF, 0x09, 0x26, 0x1A, 0x2A, 0x24, 0x00, 0x59, 0xE8, // "¯" (U+00AF)
  0x00, 0xB0, 0x09, 0x1A, 0x1A, 0x2B, 0x24, 0x00, 0x59, 0xFB, // "°" (U+00B0)
  0x00, 0xB1, 0x04, 0x01, 0x1F, 0x24, 0x24, 0x00, 0x5A, 0x66, // "±" (U+00B1)
  0x00, 0xB2, 0x09, 0x1A, 0x1B, 0x33, 0x24, 0x00, 0x5A, 0xE3, // "²" (U+00B2)
  0x00, 0xB3, 0x09, 0x19, 0x1A, 0x33, 0x24, 0x00, 0x5B, 0x5D, // "³" (U+00B3)
  0x00, 0xB4, 0x0E, 0x26, 0x1A, 0x2F, 0x24, 0x00, 0x5B, 0xE3, // "´" (U+00B4)
  0x00, 0xB5, 0x04, 0xF3, 0x1F, 0x20, 0x24, 0x00, 0x5C, 0x0A, // "µ" (U+00B5)
  0x00, 0xB6, 0x03, 0xFA, 0x20, 0x2E, 0x24, 0x00, 0x5D, 0x26, // "¶" (U+00B6)
  0x00, 0xB7, 0x0E, 0x11, 0x15, 0x19, 0x24, 0x00, 0x5E, 0x90, // "·" (U+00B7)
  0x00, 0xB8, 0x0B, 0xF3, 0x17, 0x01, 0x24, 0x00, 0x5E, 0xAB, // "¸" (U+00B8)
  0x00, 0xB9, 0x09, 0x1A, 0x1B, 0x33, 0x24, 0x00, 0x5E, 0xE8, // "¹" (U+00B9)
  0x00, 0xBA, 0x09, 0x18, 0x1A, 0x2B, 0x24, 0x00, 0x5F, 0x50, // "º" (U+00BA)
  0x00, 0xBB, 0x05, 0x04, 0x1E, 0x1D, 0x24, 0x00, 0x5F, 0xCD, // "»" (U+00BB)
  0x00, 0xBC, 0x00, 0x01, 0x22, 0x2B, 0x24, 0x00, 0x60, 0x8A, // "¼" (U+00BC)
  0x00, 0xBD, 0x00, 0x01, 0x22, 0x2B, 0x24, 0x00, 0x61, 0xE1, // "½" (U+00BD)
  0x00, 0xBE, 0x01, 0x01, 0x22, 0x2C, 0x24, 0x00, 0x63, 0x39, // "¾" (U+00BE)
  0x00, 0xBF, 0x04, 0xF5, 0x1D, 0x21, 0x24, 0x00, 0x64, 0xA8, // "¿" (U+00BF)
  0x00, 0xC0, 0x01, 0x01, 0x22, 0x3A, 0x24, 0x00, 0x65, 0x74, // "À" (U+00C0)
  0x00, 0xC1, 0x01, 0x01, 0x22, 0x3A, 0x24, 0x00, 0x66, 0xBC, // "Á" (U+00C1)
  0x00, 0xC2, 0x01, 0x01, 0x22, 0x3A, 0x24, 0x00, 0x68, 0x04, // "Â" (U+00C2)
  0x00, 0xC3, 0x01, 0x01, 0x22, 0x38, 0x24, 0x00, 0x69, 0x5A, // "Ã" (U+00C3)
  0x00, 0xC4, 0x01, 0x01, 0x22, 0x38, 0x24, 0x00, 0x6A, 0xAF, // "Ä" (U+00C4)
  0x00, 0xC5, 0x01, 0x01, 0x22, 0x3D, 0x24, 0x00, 0x6B, 0xF4, // "Å" (U+00C5)
  0x00, 0xC6, 0x01, 0x01, 0x20, 0x2B, 0x24, 0x00, 0x6D, 0x5D, // "Æ" (U+00C6)
  0x00, 0xC7, 0x04, 0xF3, 0x20, 0x2C, 0x24, 0x00, 0x6E, 0x75, // "Ç" (U+00C7)
  0x00, 0xC8, 0x05, 0x01, 0x1E, 0x3A, 0x24, 0x00, 0x6F, 0x9E, // "È" (U+00C8)
  0x00, 0xC9, 0x05, 0x01, 0x1E, 0x3A, 0x24, 0x00, 0x70, 0x86, // "É" (U+00C9)
  0x00, 0xCA, 0x05, 0x01, 0x1E, 0x3A, 0x24, 0x00, 0x71, 0x6E, // "Ê" (U+00CA)
  0x00, 0xCB, 0x05, 0x01, 0x1E, 0x38, 0x24, 0x00, 0x72, 0x64, // "Ë" (U+00CB)
  0x00, 0xCC, 0x06, 0x01, 0x1D, 0x3A, 0x24, 0x00, 0x73, 0x4A, // "Ì" (U+00CC)
  0x00, 0xCD, 0x06, 0x01, 0x1D, 0x3A, 0x24, 0x00, 0x74, 0x35, // "Í" (U+00CD)
  0x00, 0xCE, 0x06, 0x01, 0x1D, 0x3A, 0x24, 0x00, 0x75, 0x21, // "Î" (U+00CE)
  0x00, 0xCF, 0x06, 0x01, 0x1D, 0x38, 0x24, 0x00, 0x76, 0x19, // "Ï" (U+00CF)
  0x00, 0xD0, 0x00, 0x01, 0x21, 0x2B, 0x24, 0x00, 0x77, 0x03, // "Ð" (U+00D0)
  0x00, 0xD1, 0x04, 0x01, 0x1F, 0x38, 0x24, 0x00, 0x78, 0x2E, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x02, 0x00, 0x21, 0x3A, 0x24, 0x00, 0x79, 0xB2, // "Ò" (U+00D2)
  0x00, 0xD3, 0x02, 0x00, 0x21, 0x3A, 0x24, 0x00, 0x7B, 0x1F, // "Ó" (U+00D3)
  0x00, 0xD4, 0x02, 0x00, 0x21, 0x3A, 0x24, 0x00, 0x7C, 0x8C, // "Ô" (U+00D4)
  0x00, 0xD5, 0x02, 0x00, 0x21, 0x38, 0x24, 0x00, 0x7E, 0x06, // "Õ" (U+00D5)
  0x00, 0xD6, 0x02, 0x00, 0x21, 0x38, 0x24, 0x00, 0x7F, 0x80, // "Ö" (U+00D6)
  0x00, 0xD7, 0x05, 0x09, 0x1E, 0x22, 0x24, 0x00, 0x80, 0xE9, // "×" (U+00D7)
  0x00, 0xD8, 0x02, 0xFF, 0x21, 0x2D, 0x24, 0x00, 0x81, 0x83, // "Ø" (U+00D8)
  0x00, 0xD9, 0x04, 0x00, 0x1F, 0x3A, 0x24, 0x00, 0x83, 0x04, // "Ù" (U+00D9)
  0x00, 0xDA, 0x04, 0x00, 0x1F, 0x3A, 0x24, 0x00, 0x84, 0x4A, // "Ú" (U+00DA)
  0x00, 0xDB, 0x04, 0x00, 0x1F, 0x3A, 0x24, 0x00, 0x85, 0x8F, // "Û" (U+00DB)
  0x00, 0xDC, 0x04, 0x00, 0x1F, 0x38, 0x24, 0x00, 0x86, 0xE2, // "Ü" (U+00DC)
  0x00, 0xDD, 0x02, 0x01, 0x21, 0x3A, 0x24, 0x00, 0x88, 0x26, // "Ý" (U+00DD)
  0x00, 0xDE, 0x05, 0x01, 0x20, 0x2B, 0x24, 0x00, 0x89, 0x55, // "Þ" (U+00DE)
  0x00, 0xDF, 0x04, 0x00, 0x22, 0x2E, 0x24, 0x00, 0x8A, 0x40, // "ß" (U+00DF)
  0x00, 0xE0, 0x04, 0x00, 0x1E, 0x2F, 0x24, 0x00, 0x8B, 0x96, // "à" (U+00E0)
  0x00, 0xE1, 0x04, 0x00, 0x1E, 0x2F, 0x24, 0x00, 0x8C, 0xA2, // "á" (U+00E1)
  0x00, 0xE2, 0x04, 0x00, 0x1E, 0x2F, 0x24, 0x00, 0x8D, 0xAF, // "â" (U+00E2)
  0x00, 0xE3, 0x04, 0x00, 0x1E, 0x2D, 0x24, 0x00, 0x8E, 0xCA, // "ã" (U+00E3)
  0x00, 0xE4, 0x04, 0x00, 0x1E, 0x2D, 0x24, 0x00, 0x8F, 0xE4, // "ä" (U+00E4)
  0x00, 0xE5, 0x04, 0x00, 0x1E, 0x32, 0x24, 0x00, 0x90, 0xEF, // "å" (U+00E5)
  0x00, 0xE6, 0x01, 0x00, 0x22, 0x21, 0x24, 0x00, 0x92, 0x1B, // "æ" (U+00E6)
  0x00, 0xE7, 0x05, 0xF3, 0x1E, 0x21, 0x24, 0x00, 0x93, 0x30, // "ç" (U+00E7)
  0x00, 0xE8, 0x03, 0x00, 0x20, 0x2F, 0x24, 0x00, 0x94, 0x1C, // "è" (U+00E8)
  0x00, 0xE9, 0x03, 0x00, 0x20, 0x2F, 0x24, 0x00, 0x95, 0x1E, // "é" (U+00E9)
  0x00, 0xEA, 0x03, 0x00, 0x20, 0x2F, 0x24, 0x00, 0x96, 0x21, // "ê" (U+00EA)
  0x00, 0xEB, 0x03, 0x00, 0x20, 0x2D, 0x24, 0x00, 0x97, 0x2F, // "ë" (U+00EB)
  0x00, 0xEC, 0x04, 0x01, 0x20, 0x2F, 0x24, 0x00, 0x98, 0x2E, // "ì" (U+00EC)
  0x00, 0xED, 0x04, 0x01, 0x20, 0x2F, 0x24, 0x00, 0x99, 0x01, // "í" (U+00ED)
  0x00, 0xEE, 0x04, 0x01, 0x20, 0x2F, 0x24, 0x00, 0x99, 0xD2, // "î" (U+00EE)
  0x00, 0xEF, 0x04, 0x01, 0x20, 0x2D, 0x24, 0x00, 0x9A, 0xB1, // "ï" (U+00EF)
  0x00, 0xF0, 0x03, 0x00, 0x20, 0x2F, 0x24, 0x00, 0x9B, 0x81, // "ð" (U+00F0)
  0x00, 0xF1, 0x04, 0x01, 0x1F, 0x2D, 0x24, 0x00, 0x9C, 0xC9, // "ñ" (U+00F1)
  0x00, 0xF2, 0x03, 0x00, 0x20, 0x2F, 0x24, 0x00, 0x9D, 0xED, // "ò" (U+00F2)
  0x00, 0xF3, 0x03, 0x00, 0x20, 0x2F, 0x24, 0x00, 0x9F, 0x0A, // "ó" (U+00F3)
  0x00, 0xF4, 0x03, 0x00, 0x20, 0x2F, 0x24, 0x00, 0xA0, 0x28, // "ô" (U+00F4)
  0x00, 0xF5, 0x03, 0x00, 0x20, 0x2D, 0x24, 0x00, 0xA1, 0x51, // "õ" (U+00F5)
  0x00, 0xF6, 0x03, 0x00, 0x20, 0x2D, 0x24, 0x00, 0xA2, 0x7B, // "ö" (U+00F6)
  0x00, 0xF7, 0x04, 0x08, 0x1F, 0x23, 0x24, 0x00, 0xA3, 0x95, // "÷" (U+00F7)
  0x00, 0xF8, 0x03, 0xFF, 0x20, 0x22, 0x24, 0x00, 0xA3, 0xEE, // "ø" (U+00F8)
  0x00, 0xF9, 0x04, 0x00, 0x1F, 0x2F, 0x24, 0x00, 0xA5, 0x0E, // "ù" (U+00F9)
  0x00, 0xFA, 0x04, 0x00, 0x1F, 0x2F, 0x24, 0x00, 0xA6, 0x24, // "ú" (U+00FA)
  0x00, 0xFB, 0x04, 0x00, 0x1F, 0x2F, 0x24, 0x00, 0xA7, 0x38, // "û" (U+00FB)
  0x00, 0xFC, 0x04, 0x00, 0x1F, 0x2D, 0x24, 0x00, 0xA8, 0x5B, // "ü" (U+00FC)
  0x00, 0xFD, 0x02, 0xF3, 0x21, 0x2F, 0x24, 0x00, 0xA9, 0x6F, // "ý" (U+00FD)
  0x00, 0xFE, 0x04, 0xF3, 0x20, 0x2E, 0x24, 0x00, 0xAA, 0xC1, // "þ" (U+00FE)
  0x00, 0xFF, 0x02, 0xF3, 0x21, 0x2D, 0x24, 0x00, 0xAC, 0x30, // "ÿ" (U+00FF)
  0x01, 0x00, 0x01, 0x01, 0x22, 0x35, 0x24, 0x00, 0xAD, 0x7E, // "Ā" (U+0100)
  0x01, 0x01, 0x04, 0x00, 0x1E, 0x2A, 0x24, 0x00, 0xAE, 0xAB, // "ā" (U+0101)
  0x01, 0x02, 0x01, 0x01, 0x22, 0x38, 0x24, 0x00, 0xAF, 0x9E, // "Ă" (U+0102)
  0x01, 0x03, 0x04, 0x00, 0x1E, 0x2D, 0x24, 0x00, 0xB0, 0xEA, // "ă" (U+0103)
  0x01, 0x04, 0x01, 0xF4, 0x24, 0x2B, 0x24, 0x00, 0xB1, 0xFC, // "Ą" (U+0104)
  0x01, 0x05, 0x04, 0xF4, 0x20, 0x21, 0x24, 0x00, 0xB3, 0x59, // "ą" (U+0105)
  0x01, 0x06, 0x04, 0x00, 0x20, 0x3A, 0x24, 0x00, 0xB4, 0x78, // "Ć" (U+0106)
  0x01, 0x07, 0x05, 0x00, 0x1E, 0x2F, 0x24, 0x00, 0xB5, 0x92, // "ć" (U+0107)
  0x01, 0x08, 0x04, 0x00, 0x20, 0x3A, 0x24, 0x00, 0xB6, 0x71, // "Ĉ" (U+0108)
  0x01, 0x09, 0x05, 0x00, 0x1E, 0x2F, 0x24, 0x00, 0xB7, 0x99, // "ĉ" (U+0109)
  0x01, 0x0A, 0x04, 0x00, 0x20, 0x39, 0x24, 0x00, 0xB8, 0x86, // "Ċ" (U+010A)
  0x01, 0x0B, 0x05, 0x00, 0x1E, 0x2E, 0x24, 0x00, 0xB9, 0x96, // "ċ" (U+010B)
  0x01, 0x0C, 0x04, 0x00, 0x20, 0x3A, 0x24, 0x00, 0xBA, 0x6B, // "Č" (U+010C)
  0x01, 0x0D, 0x05, 0x00, 0x1E, 0x2F, 0x24, 0x00, 0xBB, 0x99, // "č" (U+010D)
  0x01, 0x0E, 0x04, 0x01, 0x21, 0x3A, 0x24, 0x00, 0xBC, 0x8D, // "Ď" (U+010E)
  0x01, 0x0F, 0x02, 0x00, 0x26, 0x2E, 0x24, 0x00, 0xBD, 0xFF, // "ď" (U+010F)
  0x01, 0x10, 0x00, 0x01, 0x21, 0x2B, 0x24, 0x00, 0xBF, 0x5D, // "Đ" (U+0110)
  0x01, 0x11, 0x03, 0x00, 0x23, 0x2E, 0x24, 0x00, 0xC0, 0x88, // "đ" (U+0111)
  0x01, 0x12, 0x05, 0x01, 0x1E, 0x35, 0x24, 0x00, 0xC1, 0xC2, // "Ē" (U+0112)
  0x01, 0x13, 0x03, 0x00, 0x20, 0x2A, 0x24, 0x00, 0xC2, 0x91, // "ē" (U+0113)
  0x01, 0x14, 0x05, 0x01, 0x1E, 0x38, 0x24, 0x00, 0xC3, 0x76, // "Ĕ" (U+0114)
  0x01, 0x15, 0x03, 0x00, 0x20, 0x2D, 0x24, 0x00, 0xC4, 0x62, // "ĕ" (U+0115)
  0x01, 0x16, 0x05, 0x01, 0x1E, 0x39, 0x24, 0x00, 0xC5, 0x66, // "Ė" (U+0116)
  0x01, 0x17, 0x03, 0x00, 0x20, 0x2E, 0x24, 0x00, 0xC6, 0x44, // "ė" (U+0117)
  0x01, 0x18, 0x05, 0xF4, 0x1E, 0x2B, 0x24, 0x00, 0xC7, 0x3C, // "Ę" (U+0118)
  0x01, 0x19, 0x03, 0xF4, 0x20, 0x21, 0x24, 0x00, 0xC8, 0x2D, // "ę" (U+0119)
  0x01, 0x1A, 0x05, 0x01, 0x1E, 0x3A, 0x24, 0x00, 0xC9, 0x36, // "Ě" (U+011A)
  0x01, 0x1B, 0x03, 0x00, 0x20, 0x2F, 0x24, 0x00, 0xCA, 0x33, // "ě" (U+011B)
  0x01, 0x1C, 0x02, 0x00, 0x1F, 0x3A, 0x24, 0x00, 0xCB, 0x49, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x03, 0xF3, 0x1F, 0x2F, 0x24, 0x00, 0xCC, 0xA5, // "ĝ" (U+011D)
  0x01, 0x1E, 0x02, 0x00, 0x1F, 0x38, 0x24, 0x00, 0xCE, 0x26, // "Ğ" (U+011E)
  0x01, 0x1F, 0x03, 0xF3, 0x1F, 0x2D, 0x24, 0x00, 0xCF, 0x78, // "ğ" (U+011F)
  0x01, 0x20, 0x02, 0x00, 0x1F, 0x39, 0x24, 0x00, 0xD0, 0xEF, // "Ġ" (U+0120)
  0x01, 0x21, 0x03, 0xF3, 0x1F, 0x2E, 0x24, 0x00, 0xD2, 0x34, // "ġ" (U+0121)
  0x01, 0x22, 0x02, 0xF4, 0x1F, 0x2C, 0x24, 0x00, 0xD3, 0x9D, // "Ģ" (U+0122)
  0x01, 0x23, 0x03, 0xF3, 0x1F, 0x2E, 0x24, 0x00, 0xD4, 0xE5, // "ģ" (U+0123)
  0x01, 0x24, 0x04, 0x01, 0x1F, 0x3A, 0x24, 0x00, 0xD6, 0x52, // "Ĥ" (U+0124)
  0x01, 0x25, 0xFD, 0x01, 0x1F, 0x3C, 0x24, 0x00, 0xD7, 0x8E, // "ĥ" (U+0125)
  0x01, 0x26, 0x00, 0x01, 0x23, 0x2B, 0x24, 0x00, 0xD9, 0x04, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x1F, 0x2E, 0x24, 0x00, 0xDA, 0x27, // "ħ" (U+0127)
  0x01, 0x28, 0x06, 0x01, 0x1D, 0x38, 0x24, 0x00, 0xDB, 0x54, // "Ĩ" (U+0128)
  0x01, 0x29, 0x04, 0x01, 0x20, 0x2D, 0x24, 0x00, 0xDC, 0x4E, // "ĩ" (U+0129)
  0x01, 0x2A, 0x06, 0x01, 0x1D, 0x35, 0x24, 0x00, 0xDD, 0x2F, // "Ī" (U+012A)
  0x01, 0x2B, 0x04, 0x01, 0x20, 0x2A, 0x24, 0x00, 0xDE, 0x00, // "ī" (U+012B)
  0x01, 0x2C, 0x06, 0x01, 0x1D, 0x38, 0x24, 0x00, 0xDE, 0xB6, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x04, 0x01, 0x20, 0x2D, 0x24, 0x00, 0xDF, 0xA5, // "ĭ" (U+012D)
  0x01, 0x2E, 0x06, 0xF4, 0x1D, 0x2B, 0x24, 0x00, 0xE0, 0x7A, // "Į" (U+012E)
  0x01, 0x2F, 0x04, 0xF4, 0x20, 0x2E, 0x24, 0x00, 0xE1, 0x6D, // "į" (U+012F)
  0x01, 0x30, 0x06, 0x01, 0x1D, 0x39, 0x24, 0x00, 0xE2, 0x6F, // "İ" (U+0130)
  0x01, 0x31, 0x04, 0x01, 0x20, 0x20, 0x24, 0x00, 0xE3, 0x51, // "ı" (U+0131)
  0x01, 0x32, 0x06, 0x00, 0x1D, 0x2B, 0x24, 0x00, 0xE3, 0xEE, // "Ĳ" (U+0132)
  0x01, 0x33, 0x06, 0xF3, 0x1D, 0x2E, 0x24, 0x00, 0xE4, 0xAF, // "ĳ" (U+0133)
  0x01, 0x34, 0x06, 0x00, 0x23, 0x3A, 0x24, 0x00, 0xE5, 0xE1, // "Ĵ" (U+0134)
  0x01, 0x35, 0x03, 0xF3, 0x1E, 0x2F, 0x24, 0x00, 0xE6, 0xF8, // "ĵ" (U+0135)
  0x01, 0x36, 0x04, 0xF4, 0x20, 0x2B, 0x24, 0x00, 0xE8, 0x1A, // "Ķ" (U+0136)
  0x01, 0x37, 0x06, 0xF4, 0x21, 0x2E, 0x24, 0x00, 0xE9, 0x72, // "ķ" (U+0137)
  0x01, 0x38, 0x06, 0x01, 0x21, 0x20, 0x24, 0x00, 0xEA, 0xBF, // "ĸ" (U+0138)
  0x01, 0x39, 0x06, 0x01, 0x1E, 0x3A, 0x24, 0x00, 0xEB, 0x9E, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x04, 0x01, 0x20, 0x3C, 0x24, 0x00, 0xEC, 0x7F, // "ĺ" (U+013A)
  0x01, 0x3B, 0x06, 0xF4, 0x1E, 0x2B, 0x24, 0x00, 0xED, 0x8C, // "Ļ" (U+013B)
  0x01, 0x3C, 0x04, 0xF4, 0x20, 0x2E, 0x24, 0x00, 0xEE, 0x65, // "ļ" (U+013C)
  0x01, 0x3D, 0x06, 0x01, 0x1E, 0x2B, 0x24, 0x00, 0xEF, 0x6D, // "Ľ" (U+013D)
  0x01, 0x3E, 0x04, 0x01, 0x21, 0x2E, 0x24, 0x00, 0xF0, 0x33, // "ľ" (U+013E)
  0x01, 0x3F, 0x06, 0x01, 0x1E, 0x2B, 0x24, 0x00, 0xF1, 0x24, // "Ŀ" (U+013F)
  0x01, 0x40, 0x04, 0x01, 0x27, 0x2E, 0x24, 0x00, 0xF1, 0xE7, // "ŀ" (U+0140)
  0x01, 0x41, 0x03, 0x01, 0x21, 0x2B, 0x24, 0x00, 0xF2, 0xEA, // "Ł" (U+0141)
  0x01, 0x42, 0x04, 0x01, 0x20, 0x2E, 0x24, 0x00, 0xF3, 0xC8, // "ł" (U+0142)
  0x01, 0x43, 0x04, 0x01, 0x1F, 0x3A, 0x24, 0x00, 0xF4, 0xBA, // "Ń" (U+0143)
  0x01, 0x44, 0x04, 0x01, 0x1F, 0x2F, 0x24, 0x00, 0xF6, 0x2E, // "ń" (U+0144)
  0x01, 0x45, 0x04, 0xF4, 0x1F, 0x2B, 0x24, 0x00, 0xF7, 0x42, // "Ņ" (U+0145)
  0x01, 0x46, 0x04, 0xF4, 0x1F, 0x21, 0x24, 0x00, 0xF8, 0xB2, // "ņ" (U+0146)
  0x01, 0x47, 0x04, 0x01, 0x1F, 0x3A, 0x24, 0x00, 0xF9, 0xC3, // "Ň" (U+0147)
  0x01, 0x48, 0x04, 0x01, 0x1F, 0x2F, 0x24, 0x00, 0xFB, 0x4D, // "ň" (U+0148)
  0x01, 0x49, 0xFD, 0x01, 0x1F, 0x2B, 0x24, 0x00, 0xFC, 0x77, // "ŉ" (U+0149)
  0x01, 0x4A, 0x04, 0xF5, 0x1F, 0x2B, 0x24, 0x00, 0xFD, 0x9E, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x04, 0xF3, 0x1F, 0x21, 0x24, 0x00, 0xFF, 0x17, // "ŋ" (U+014B)
  0x01, 0x4C, 0x02, 0x00, 0x21, 0x35, 0x24, 0x01, 0x00, 0x3F, // "Ō" (U+014C)
  0x01, 0x4D, 0x03, 0x00, 0x20, 0x2A, 0x24, 0x01, 0x01, 0x8E, // "ō" (U+014D)
  0x01, 0x4E, 0x02, 0x00, 0x21, 0x38, 0x24, 0x01, 0x02, 0x8E, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x03, 0x00, 0x20, 0x2D, 0x24, 0x01, 0x03, 0xFE, // "ŏ" (U+014F)
  0x01, 0x50, 0x02, 0x00, 0x21, 0x3A, 0x24, 0x01, 0x05, 0x1D, // "Ő" (U+0150)
  0x01, 0x51, 0x03, 0x00, 0x20, 0x2F, 0x24, 0x01, 0x06, 0x9F, // "ő" (U+0151)
  0x01, 0x52, 0x02, 0x00, 0x22, 0x2C, 0x24, 0x01, 0x07, 0xCF, // "Œ" (U+0152)
  0x01, 0x53, 0x01, 0x00, 0x22, 0x21, 0x24, 0x01, 0x08, 0xFD, // "œ" (U+0153)
  0x01, 0x54, 0x05, 0x01, 0x21, 0x3A, 0x24, 0x01, 0x0A, 0x29, // "Ŕ" (U+0154)
  0x01, 0x55, 0x03, 0x01, 0x22, 0x2F, 0x24, 0x01, 0x0B, 0x7B, // "ŕ" (U+0155)
  0x01, 0x56, 0x05, 0xF4, 0x21, 0x2B, 0x24, 0x01, 0x0C, 0x6A, // "Ŗ" (U+0156)
  0x01, 0x57, 0x03, 0xF4, 0x22, 0x21, 0x24, 0x01, 0x0D, 0xB7, // "ŗ" (U+0157)
  0x01, 0x58, 0x05, 0x01, 0x21, 0x3A, 0x24, 0x01, 0x0E, 0x9F, // "Ř" (U+0158)
  0x01, 0x59, 0x03, 0x01, 0x22, 0x2F, 0x24, 0x01, 0x10, 0x06, // "ř" (U+0159)
  0x01, 0x5A, 0x05, 0x00, 0x1F, 0x3A, 0x24, 0x01, 0x11, 0x09, // "Ś" (U+015A)
  0x01, 0x5B, 0x06, 0x00, 0x1D, 0x2F, 0x24, 0x01, 0x12, 0x31, // "ś" (U+015B)
  0x01, 0x5C, 0x05, 0x00, 0x1F, 0x3A, 0x24, 0x01, 0x13, 0x21, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x06, 0x00, 0x1D, 0x2F, 0x24, 0x01, 0x14, 0x57, // "ŝ" (U+015D)
  0x01, 0x5E, 0x05, 0xF3, 0x1F, 0x2C, 0x24, 0x01, 0x15, 0x53, // "Ş" (U+015E)
  0x01, 0x5F, 0x06, 0xF3, 0x1D, 0x21, 0x24, 0x01, 0x16, 0x8A, // "ş" (U+015F)
  0x01, 0x60, 0x05, 0x00, 0x1F, 0x3A, 0x24, 0x01, 0x17, 0x86, // "Š" (U+0160)
  0x01, 0x61, 0x06, 0x00, 0x1D, 0x2F, 0x24, 0x01, 0x18, 0xC3, // "š" (U+0161)
  0x01, 0x62, 0x02, 0xF3, 0x21, 0x2B, 0x24, 0x01, 0x19, 0xC7, // "Ţ" (U+0162)
  0x01, 0x63, 0x03, 0xF3, 0x1E, 0x29, 0x24, 0x01, 0x1A, 0xD6, // "ţ" (U+0163)
  0x01, 0x64, 0x02, 0x01, 0x21, 0x3A, 0x24, 0x01, 0x1B, 0xE4, // "Ť" (U+0164)
  0x01, 0x65, 0x03, 0x00, 0x1E, 0x2F, 0x24, 0x01, 0x1C, 0xF5, // "ť" (U+0165)
  0x01, 0x66, 0x02, 0x01, 0x21, 0x2B, 0x24, 0x01, 0x1D, 0xE6, // "Ŧ" (U+0166)
  0x01, 0x67, 0x03, 0x00, 0x1E, 0x29, 0x24, 0x01, 0x1E, 0xB2, // "ŧ" (U+0167)
  0x01, 0x68, 0x04, 0x00, 0x1F, 0x38, 0x24, 0x01, 0x1F, 0x7F, // "Ũ" (U+0168)
  0x01, 0x69, 0x04, 0x00, 0x1F, 0x2D, 0x24, 0x01, 0x20, 0xD3, // "ũ" (U+0169)
  0x01, 0x6A, 0x04, 0x00, 0x1F, 0x35, 0x24, 0x01, 0x21, 0xF7, // "Ū" (U+016A)
  0x01, 0x6B, 0x04, 0x00, 0x1F, 0x2A, 0x24, 0x01, 0x23, 0x22, // "ū" (U+016B)
  0x01, 0x6C, 0x04, 0x00, 0x1F, 0x38, 0x24, 0x01, 0x24, 0x1D, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x04, 0x00, 0x1F, 0x2D, 0x24, 0x01, 0x25, 0x67, // "ŭ" (U+016D)
  0x01, 0x6E, 0x04, 0x00, 0x1F, 0x3D, 0x24, 0x01, 0x26, 0x81, // "Ů" (U+016E)
  0x01, 0x6F, 0x04, 0x00, 0x1F, 0x32, 0x24, 0x01, 0x27, 0xE7, // "ů" (U+016F)
  0x01, 0x70, 0x04, 0x00, 0x1F, 0x3A, 0x24, 0x01, 0x29, 0x1C, // "Ű" (U+0170)
  0x01, 0x71, 0x04, 0x00, 0x1F, 0x2F, 0x24, 0x01, 0x2A, 0x77, // "ű" (U+0171)
  0x01, 0x72, 0x04, 0xF4, 0x1F, 0x2B, 0x24, 0x01, 0x2B, 0xA2, // "Ų" (U+0172)
  0x01, 0x73, 0x04, 0xF4, 0x20, 0x20, 0x24, 0x01, 0x2C, 0xEC, // "ų" (U+0173)
  0x01, 0x74, 0x01, 0x01, 0x22, 0x3A, 0x24, 0x01, 0x2E, 0x17, // "Ŵ" (U+0174)
  0x01, 0x75, 0x01, 0x01, 0x22, 0x2F, 0x24, 0x01, 0x2F, 0xDF, // "ŵ" (U+0175)
  0x01, 0x76, 0x02, 0x01, 0x21, 0x3A, 0x24, 0x01, 0x31, 0x47, // "Ŷ" (U+0176)
  0x01, 0x77, 0x02, 0xF3, 0x21, 0x2F, 0x24, 0x01, 0x32, 0x82, // "ŷ" (U+0177)
  0x01, 0x78, 0x02, 0x01, 0x21, 0x38, 0x24, 0x01, 0x33, 0xE0, // "Ÿ" (U+0178)
  0x01, 0x79, 0x05, 0x01, 0x1E, 0x3A, 0x24, 0x01, 0x35, 0x0B, // "Ź" (U+0179)
  0x01, 0x7A, 0x05, 0x01, 0x1E, 0x2F, 0x24, 0x01, 0x35, 0xF6, // "ź" (U+017A)
  0x01, 0x7B, 0x05, 0x01, 0x1E, 0x39, 0x24, 0x01, 0x36, 0xBB, // "Ż" (U+017B)
  0x01, 0x7C, 0x05, 0x01, 0x1E, 0x2E, 0x24, 0x01, 0x37, 0x9C, // "ż" (U+017C)
  0x01, 0x7D, 0x05, 0x01, 0x1E, 0x3A, 0x24, 0x01, 0x38, 0x57, // "Ž" (U+017D)
  0x01, 0x7E, 0x05, 0x01, 0x1E, 0x2F, 0x24, 0x01, 0x39, 0x56, // "ž" (U+017E)
  0x01, 0x7F, 0x0D, 0x01, 0x20, 0x2E, 0x24, 0x01, 0x3A, 0x2F, // "ſ" (U+017F)
  0x03, 0xA9, 0x01, 0x01, 0x22, 0x2C, 0x24, 0x01, 0x3A, 0xDF, // "Ω" (U+03A9)
  0x03, 0xBC, 0x04, 0xF3, 0x1F, 0x20, 0x24, 0x01, 0x3C, 0x16, // "μ" (U+03BC)
  0x03, 0xC0, 0x02, 0x00, 0x21, 0x20, 0x24, 0x01, 0x3D, 0x30, // "π" (U+03C0)
  0x20, 0x13, 0x06, 0x0F, 0x1D, 0x13, 0x24, 0x01, 0x3D, 0xFE, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x0F, 0x23, 0x13, 0x24, 0x01, 0x3E, 0x04, // "—" (U+2014)
  0x20, 0xAC, 0x02, 0x00, 0x22, 0x2C, 0x24, 0x01, 0x3E, 0x0A, // "€" (U+20AC)
  0x20, 0xBF, 0x05, 0xFB, 0x20, 0x32, 0x24, 0x01, 0x3F, 0x0F, // "₿" (U+20BF)
  0x20, 0x18, 0x0D, 0x1D, 0x16, 0x2B, 0x24, 0x01, 0x40, 0x78, // "‘" (U+2018)
  0x20, 0x19, 0x0C, 0x1D, 0x15, 0x2B, 0x24, 0x01, 0x40, 0xA5, // "’" (U+2019)
  0x20, 0x1A, 0x0C, 0xF9, 0x16, 0x08, 0x24, 0x01, 0x40, 0xD2, // "‚" (U+201A)
  0x20, 0x1B, 0x0D, 0x1D, 0x16, 0x2B, 0x24, 0x01, 0x41, 0x03, // "‛" (U+201B)
  0x20, 0x1C, 0x07, 0x1D, 0x1C, 0x2B, 0x24, 0x01, 0x41, 0x2F, // "“" (U+201C)
  0x20, 0x1D, 0x07, 0x1D, 0x1C, 0x2B, 0x24, 0x01, 0x41, 0x88, // "”" (U+201D)
  0x20, 0x1E, 0x07, 0xF9, 0x1D, 0x08, 0x24, 0x01, 0x41, 0xE1, // "„" (U+201E)
  0x20, 0x1F, 0x07, 0x1D, 0x1C, 0x2B, 0x24, 0x01, 0x42, 0x42, // "‟" (U+201F)
  0x20, 0x20, 0x06, 0x01, 0x1D, 0x2E, 0x24, 0x01, 0x42, 0x98, // "†" (U+2020)
  0x20, 0x21, 0x06, 0x01, 0x1D, 0x2E, 0x24, 0x01, 0x43, 0x61, // "‡" (U+2021)
  0x20, 0x22, 0x0B, 0x10, 0x18, 0x1E, 0x24, 0x01, 0x44, 0x44, // "•" (U+2022)
  0x20, 0x26, 0x02, 0x00, 0x21, 0x08, 0x24, 0x01, 0x44, 0x79, // "…" (U+2026)
  0x20, 0x30, 0x00, 0x00, 0x23, 0x2C, 0x24, 0x01, 0x44, 0xCE, // "‰" (U+2030)
  0x20, 0x39, 0x0B, 0x04, 0x18, 0x1D, 0x24, 0x01, 0x46, 0x5D, // "‹" (U+2039)
  0x20, 0x3A, 0x0B, 0x06, 0x18, 0x1F, 0x24, 0x01, 0x46, 0xBC, // "›" (U+203A)
  0x20, 0x44, 0xF4, 0x01, 0x0B, 0x2B, 0x00, 0x01, 0x47, 0x1B, // "⁄" (U+2044)
  0x21, 0x22, 0xFF, 0x17, 0x23, 0x2C, 0x24, 0x01, 0x47, 0xCA, // "™" (U+2122)
  0x21, 0x52, 0x0F, 0x00, 0x5D, 0x2B, 0x6C, 0x01, 0x48, 0xCD, // "⅒" (U+2152)
  0x22, 0x02, 0x02, 0x00, 0x1F, 0x2B, 0x24, 0x01, 0x4B, 0x1F, // "∂" (U+2202)
  0x22, 0x06, 0x01, 0x01, 0x22, 0x2B, 0x24, 0x01, 0x4C, 0x41, // "∆" (U+2206)
  0x22, 0x1A, 0x01, 0x01, 0x23, 0x33, 0x24, 0x01, 0x4D, 0x51, // "√" (U+221A)
  0x22, 0x1E, 0x00, 0x0D, 0x23, 0x1F, 0x24, 0x01, 0x4E, 0x79, // "∞" (U+221E)
  0x22, 0x48, 0x03, 0x0C, 0x20, 0x1F, 0x24, 0x01, 0x4F, 0x48, // "≈" (U+2248)
  0x22, 0x60, 0x04, 0x05, 0x1F, 0x26, 0x24, 0x01, 0x4F, 0xE0, // "≠" (U+2260)
  0x22, 0x64, 0x03, 0x01, 0x20, 0x25, 0x24, 0x01, 0x50, 0x74, // "≤" (U+2264)
  0x22, 0x65, 0x03, 0x01, 0x20, 0x25, 0x24, 0x01, 0x51, 0x39, // "≥" (U+2265)
  
  // Kerning pairs
  
  // Glyph data
  // "!" (U+0021)
  0x03, 0xE0, 0x40, 0x3E, 0x03, 0x02, 0xE0, 0x30, 0x2E, 0x02, 0x01, 0xE0, 0x20, 0x1E, 0x01, 0x1E,
  0x01, 0x1E, 0x01, 0x1E, 0x20, 0xED, 0x20, 0xED, 0x20, 0xDC, 0x0E, 0x20, 0xDC, 0x0E, 0x20, 0xCC,
  0x0D, 0x20, 0xCC, 0x0D, 0x20, 0xBC, 0x0C, 0x20, 0xBC, 0x0C, 0x20, 0xAC, 0x0B, 0x20, 0xAC, 0x0B,
  0x20, 0x9C, 0x0A, 0x20, 0x9C, 0x0A, 0x20, 0x8C, 0x09, 0x20, 0x8C, 0x09, 0x20, 0x7C, 0x08, 0x20,
  0x7C, 0x08, 0x20, 0x7C, 0x07, 0x20, 0x6C, 0x07, 0x20, 0x6C, 0x07, 0x20, 0x5C, 0x06, 0x20, 0x5C,
  0x06, 0x20, 0x4C, 0x05, 0x77, 0x77, 0x78, 0x23, 0x66, 0x33, 0x0A, 0xC8, 0x1A, 0x05, 0xE0, 0x50,
  0x9E, 0x09, 0x0A, 0xE0, 0xA0, 0x9E, 0x09, 0x05, 0xE8, 0x15, 0x09, 0xC0, 0x93, 0x82, 0x36, 0x63,
  0x20,
  // """ (U+0022)
  0x05, 0xD0, 0x34, 0x04, 0xD0, 0x50, 0x4D, 0x02, 0x40, 0x2D, 0x04, 0x03, 0xD0, 0x14, 0x01, 0xD0,
  0x30, 0x2D, 0x6D, 0x02, 0x01, 0xC0, 0xE6, 0x0E, 0xC0, 0x11, 0xC0, 0xD6, 0x0D, 0xC2, 0x0E, 0xB0,
  0xC6, 0x0C, 0xB0, 0xE2, 0x0D, 0xB0, 0xB6, 0x0B, 0xB0, 0xD2, 0x0B, 0xB0, 0xA6, 0x0A, 0xB0, 0xB2,
  0x0A, 0xB0, 0x96, 0x09, 0xB0, 0xA2, 0x09, 0xB0, 0x76, 0x07, 0xB0, 0x92, 0x08, 0xB0, 0x66, 0x06,
  0xB0, 0x82, 0x07, 0xB0, 0x56, 0x05, 0xB0, 0x72, 0x06, 0xB0, 0x46, 0x04, 0xB0, 0x62, 0x04, 0xB0,
  0x36, 0x03, 0xB0, 0x42, 0x03, 0xB0, 0x26, 0x02, 0xB0, 0x31,
  // "#" (U+0023)
  0x76, 0x0E, 0xB0, 0x66, 0x02, 0xB0, 0xE7, 0x73, 0x02, 0xC0, 0x36, 0x05, 0xB0, 0xC7, 0x73, 0x05,
  0xC7, 0x08, 0xB0, 0x97, 0x73, 0x07, 0xB0, 0xC7, 0x0B, 0xB0, 0x67, 0x73, 0x0A, 0xB0, 0x97, 0x0E,
  0xB0, 0x37, 0x73, 0x0D, 0xB0, 0x66, 0x02, 0xC7, 0x73, 0x01, 0xC0, 0x36, 0x05, 0xB0, 0xC7, 0x73,
  0x04, 0xC7, 0x07, 0xB0, 0x97, 0x73, 0x07, 0xB0, 0xD7, 0x0A, 0xB0, 0x67, 0x73, 0x0A, 0xB0, 0xA7,
  0x0D, 0xB0, 0x37, 0x73, 0x0D, 0xB0, 0x76, 0x01, 0xC7, 0x74, 0xC0, 0x46, 0x04, 0xB0, 0xD7, 0x20,
  0x38, 0x03, 0x60, 0x7C, 0x07, 0x80, 0x26, 0x0A, 0xB0, 0xC8, 0x02, 0x60, 0x52, 0x09, 0xFF, 0xFF,
  0xA0, 0xC2, 0x09, 0xFF, 0xFF, 0xA0, 0xC2, 0x09, 0xFF, 0xFF, 0xA0, 0xC2, 0x09, 0xFF, 0xFF, 0xA0,
  0xC7, 0x20, 0x1C, 0x02, 0x60, 0x7B, 0x0B, 0x77, 0x30, 0x4B, 0x0E, 0x70, 0xAB, 0x08, 0x77, 0x30,
  0x7B, 0x0B, 0x70, 0xDB, 0x05, 0x77, 0x30, 0xAB, 0x07, 0x60, 0x1C, 0x02, 0x77, 0x30, 0xEB, 0x04,
  0x60, 0x4B, 0x0E, 0x77, 0x30, 0x2C, 0x01, 0x60, 0x7B, 0x0B, 0x77, 0x30, 0x5B, 0x0D, 0x70, 0xBB,
  0x08, 0x77, 0x30, 0x8B, 0x0A, 0x70, 0xEB, 0x05, 0x77, 0x30, 0xBB, 0x07, 0x60, 0x2C, 0x01, 0x72,
  0x0C, 0xFF, 0xFF, 0xA0, 0xB2, 0x0C, 0xFF, 0xFF, 0xA0, 0xB2, 0x0C, 0xFF, 0xFF, 0xA0, 0xB2, 0x0C,
  0xFF, 0xFF, 0xA0, 0xB2, 0x05, 0x80, 0x26, 0x0C, 0xB0, 0xB8, 0x02, 0x60, 0x7C, 0x07, 0x80, 0x36,
  0x04, 0x72, 0x0D, 0xB0, 0x66, 0x03, 0xC7, 0x74, 0xC0, 0x36, 0x06, 0xB0, 0xC7, 0x73, 0x03, 0xC7,
  0x09, 0xB0, 0x97, 0x73, 0x06, 0xB0, 0xC7, 0x0C, 0xB0, 0x67, 0x73, 0x09, 0xB0, 0xA7, 0xC0, 0x37,
  0x73, 0x0B, 0xB0, 0x76, 0x03, 0xC7, 0x74, 0x0E, 0xB0, 0x46, 0x06, 0xB0, 0xD7, 0x73, 0x01, 0xC0,
  0x16, 0x09, 0xB0, 0xA7, 0x73, 0x04, 0xB0, 0xE7, 0x0C, 0xB0, 0x77, 0x73, 0x07, 0xB0, 0xB7, 0xC0,
  0x47, 0x73, 0x0A, 0xB0, 0x86, 0x03, 0xC0, 0x17, 0x73, 0x0D, 0xB0, 0x56, 0x06, 0xB0, 0xD7, 0x60,
  // "$" (U+0024)
  0x74, 0x03, 0xB0, 0x97, 0x77, 0x20, 0x3B, 0x09, 0x77, 0x72, 0x03, 0xB0, 0x97, 0x77, 0x20, 0x3B,
  0x09, 0x77, 0x78, 0x14, 0x6A, 0xB8, 0x3D, 0x87, 0x63, 0x77, 0x04, 0x0B, 0xFD, 0x81, 0xEA, 0x57,
  0x20, 0x20, 0xCF, 0xFB, 0x81, 0xE7, 0x15, 0x04, 0x0E, 0xFF, 0xE0, 0x54, 0x02, 0x0E, 0xFF, 0xE0,
  0xE5, 0x0C, 0xE8, 0x1D, 0x99, 0xB8, 0x3B, 0x68, 0xBE, 0xC0, 0xA4, 0x05, 0xD0, 0xE0, 0x42, 0x03,
  0xB0, 0x94, 0x83, 0x38, 0xDF, 0x44, 0x0A, 0xC0, 0xE0, 0x23, 0x03, 0xB0, 0x97, 0x03, 0x50, 0xEC,
  0x07, 0x40, 0x3B, 0x09, 0x75, 0x01, 0xD0, 0x24, 0x03, 0xB0, 0x97, 0x50, 0x2D, 0x50, 0x3B, 0x09,
  0x75, 0x02, 0xD5, 0x03, 0xB0, 0x97, 0x50, 0x1D, 0x02, 0x40, 0x3B, 0x09, 0x76, 0x0D, 0xC0, 0x74,
  0x03, 0xB0, 0x97, 0x60, 0x9C, 0x0E, 0x03, 0x30, 0x3B, 0x09, 0x76, 0x02, 0xD0, 0xE0, 0x72, 0x03,
  0xB0, 0x97, 0x70, 0x9E, 0x81, 0xE8, 0x6B, 0x09, 0x77, 0x10, 0xBF, 0xC0, 0x97, 0x72, 0x09, 0xFB,
  0x81, 0xE9, 0x47, 0x71, 0x04, 0x0D, 0xFC, 0x81, 0xE8, 0x27, 0x70, 0x60, 0xDF, 0xD0, 0xB0, 0x37,
  0x70, 0x40, 0xAF, 0xD0, 0x97, 0x71, 0x03, 0xFD, 0x0C, 0x77, 0x03, 0xB8, 0x1C, 0x9E, 0xF0, 0xA7,
  0x60, 0x3B, 0x09, 0x20, 0x40, 0xBE, 0x04, 0x75, 0x03, 0xB0, 0x94, 0x05, 0xD0, 0xA7, 0x50, 0x3B,
  0x09, 0x50, 0x8C, 0x0E, 0x75, 0x03, 0xB0, 0x95, 0x02, 0xD0, 0x17, 0x40, 0x3B, 0x09, 0x6D, 0x02,
  0x74, 0x03, 0xB0, 0x96, 0xD0, 0x27, 0x40, 0x3B, 0x09, 0x50, 0x2D, 0x75, 0x03, 0xB0, 0x95, 0x08,
  0xC0, 0xC2, 0x02, 0x72, 0x03, 0xB0, 0x94, 0x04, 0xD0, 0x72, 0x82, 0x9E, 0x83, 0x60, 0x3B, 0x09,
  0x30, 0x7D, 0x0E, 0x01, 0x20, 0x9B, 0x85, 0xEA, 0x74, 0x21, 0x3B, 0x82, 0xB6, 0x9E, 0xE0, 0x53,
  0x09, 0xFF, 0xF9, 0x06, 0x40, 0x9F, 0xFE, 0x0E, 0x04, 0x50, 0x60, 0xEF, 0xFB, 0x81, 0xE8, 0x17,
  0x18, 0x14, 0x8C, 0xFC, 0x81, 0xD9, 0x57, 0x71, 0x83, 0x13, 0x45, 0x8B, 0x0A, 0x77, 0x72, 0x03,
  0xB0, 0x97, 0x77, 0x20, 0x3B, 0x09, 0x77, 0x72, 0x03, 0xB0, 0x97, 0x77, 0x20, 0x3B, 0x09, 0x77,
  0x72, 0x03, 0xB0, 0x97, 0x77, 0x28, 0x31, 0x77, 0x74, 0x75,
  // "%" (U+0025)
  0x68, 0x33, 0x67, 0x64, 0x77, 0x77, 0x10, 0x80, 0xED, 0x0E, 0x08, 0x76, 0x0D, 0xB0, 0xA7, 0x01,
  0x0D, 0xFA, 0x0D, 0x01, 0x73, 0x06, 0xC0, 0x37, 0x0D, 0xFC, 0x0D, 0x01, 0x72, 0x0D, 0xB0, 0xB7,
  0x09, 0xC8, 0x3E, 0xA8, 0x9E, 0xC0, 0xA7, 0x10, 0x6C, 0x03, 0x60, 0x1C, 0x0D, 0x02, 0x30, 0x10,
  0xCC, 0x02, 0x70, 0xDB, 0x0B, 0x70, 0x6C, 0x03, 0x50, 0x2C, 0x08, 0x60, 0x6C, 0x03, 0x70, 0xAB,
  0x0D, 0x70, 0xBB, 0x0C, 0x60, 0xDB, 0x0B, 0x71, 0x0D, 0xB0, 0x97, 0x08, 0xC5, 0x05, 0xC0, 0x37,
  0x10, 0xEB, 0x07, 0x70, 0x6C, 0x01, 0x40, 0xDB, 0x0B, 0x72, 0xC0, 0x77, 0x05, 0xC0, 0x23, 0x05,
  0xC0, 0x37, 0x20, 0xEB, 0x06, 0x70, 0x5C, 0x01, 0x30, 0xDB, 0x0B, 0x73, 0x0D, 0xB0, 0x77, 0x06,
  0xC3, 0x05, 0xC0, 0x37, 0x30, 0xBB, 0x09, 0x70, 0x7B, 0x0E, 0x30, 0xDB, 0x0B, 0x74, 0x08, 0xB0,
  0xB7, 0x0A, 0xB0, 0xA2, 0x05, 0xC0, 0x37, 0x40, 0x3C, 0x01, 0x60, 0xEB, 0x06, 0x20, 0xDB, 0x0B,
  0x76, 0x0C, 0xB0, 0x95, 0x07, 0xB0, 0xE2, 0x05, 0xC0, 0x37, 0x60, 0x2C, 0x83, 0x92, 0x01, 0x8C,
  0x05, 0x20, 0xDB, 0x0B, 0x77, 0x10, 0x5F, 0xC0, 0x92, 0x05, 0xC0, 0x47, 0x72, 0x04, 0x0D, 0xF0,
  0xE0, 0x73, 0x0D, 0xB0, 0xB7, 0x75, 0x86, 0x6B, 0xEF, 0xEC, 0x71, 0x30, 0x5C, 0x04, 0x77, 0x77,
  0x20, 0xCB, 0x0B, 0x77, 0x77, 0x20, 0x5C, 0x04, 0x77, 0x77, 0x20, 0xCB, 0x0C, 0x77, 0x77, 0x20,
  0x5C, 0x04, 0x38, 0x62, 0x7C, 0xEF, 0xDB, 0x67, 0x75, 0x0C, 0xB0, 0xC3, 0x08, 0xF9, 0x0D, 0x04,
  0x77, 0x20, 0x5C, 0x04, 0x20, 0xAF, 0xC0, 0x57, 0x71, 0x0C, 0xB0, 0xC2, 0x06, 0xFE, 0x02, 0x76,
  0x04, 0xC0, 0x42, 0x0E, 0xC8, 0x37, 0x10, 0x29, 0xC0, 0xC7, 0x60, 0xCB, 0x0C, 0x20, 0x6C, 0x06,
  0x50, 0x9C, 0x03, 0x74, 0x04, 0xC0, 0x42, 0x0B, 0xB0, 0xD6, 0x01, 0xC0, 0x87, 0x40, 0xCB, 0x0C,
  0x30, 0xEB, 0x09, 0x70, 0xCB, 0x0B, 0x73, 0x04, 0xC0, 0x43, 0xC0, 0x67, 0x09, 0xB0, 0xD7, 0x30,
  0xCB, 0x0C, 0x30, 0x1C, 0x05, 0x70, 0x8B, 0x0E, 0x72, 0x04, 0xC0, 0x43, 0x02, 0xC0, 0x47, 0x07,
  0xC7, 0x20, 0xCB, 0x0C, 0x40, 0x1C, 0x04, 0x70, 0x8B, 0x0E, 0x71, 0x04, 0xC0, 0x45, 0xC0, 0x57,
  0x09, 0xB0, 0xD7, 0x10, 0xCB, 0x0C, 0x60, 0xCB, 0x07, 0x70, 0xBB, 0x09, 0x70, 0x4C, 0x05, 0x60,
  0x8B, 0x0B, 0x70, 0xEB, 0x06, 0x70, 0xCB, 0x0C, 0x70, 0x2C, 0x02, 0x50, 0x5B, 0x0E, 0x01, 0x60,
  0x4C, 0x05, 0x71, 0x0A, 0xB0, 0xC0, 0x13, 0x02, 0x0E, 0xB0, 0x87, 0x0C, 0xB0, 0xC7, 0x20, 0x10,
  0xDB, 0x82, 0xE9, 0x8A, 0xC0, 0xC7, 0x04, 0xC0, 0x57, 0x30, 0x10, 0xDF, 0xA0, 0xC0, 0x17, 0x0B,
  0xB0, 0xC7, 0x60, 0x80, 0xED, 0x0E, 0x07, 0x77, 0x77, 0x18, 0x34, 0x67, 0x63, 0x60,
  // "&" (U+0026)
  0x73, 0x84, 0x36, 0x77, 0x53, 0x77, 0x73, 0x81, 0x18, 0xEE, 0x0E, 0x07, 0x77, 0x70, 0x30, 0xEF,
  0xB0, 0xD0, 0x27, 0x74, 0x02, 0x0E, 0xFD, 0x0D, 0x01, 0x77, 0x30, 0xCE, 0x00, 0xEE, 0x0A, 0x77,
  0x20, 0x5D, 0x0A, 0x02, 0x20, 0x20, 0xBD, 0x03, 0x77, 0x10, 0xAC, 0x0B, 0x60, 0xBC, 0x08, 0x77,
  0x10, 0xEC, 0x03, 0x60, 0x3C, 0x0C, 0x77, 0x1C, 0x0E, 0x71, 0xC0, 0xD7, 0x71, 0xC0, 0xD7, 0x10,
  0xEB, 0x0E, 0x77, 0x1C, 0x0E, 0x71, 0xC0, 0xD7, 0x71, 0x0D, 0xC7, 0x03, 0xC0, 0xA7, 0x71, 0x0A,
  0xC0, 0x46, 0x09, 0xC0, 0x67, 0x71, 0x06, 0xC0, 0x95, 0x02, 0xD0, 0x17, 0x71, 0x01, 0xC0, 0xE0,
  0x13, 0x01, 0x0C, 0xC0, 0x87, 0x73, 0x09, 0xC0, 0x73, 0x0B, 0xC0, 0xD7, 0x74, 0x01, 0xC8, 0x2E,
  0x10, 0xBD, 0x03, 0x77, 0x50, 0x8C, 0x0B, 0x0C, 0xD0, 0x57, 0x76, 0x01, 0x0E, 0xFA, 0x06, 0x77,
  0x71, 0x05, 0xF9, 0x05, 0x77, 0x72, 0x02, 0x0E, 0xD0, 0xE0, 0x47, 0x77, 0x20, 0x40, 0xEE, 0x0C,
  0x77, 0x72, 0x05, 0xFA, 0x09, 0x77, 0x70, 0x6F, 0xC0, 0x67, 0x10, 0x3C, 0x0A, 0x50, 0x4E, 0x06,
  0x0A, 0xD0, 0x37, 0x07, 0xC0, 0x74, 0x02, 0x0E, 0xD0, 0x52, 0x0D, 0xC0, 0xD0, 0x16, 0x0A, 0xC0,
  0x44, 0x0B, 0xD0, 0x63, 0x02, 0x0E, 0xC0, 0xC6, 0x0E, 0xC4, 0x04, 0xD0, 0x85, 0x05, 0xD0, 0x94,
  0x04, 0xC0, 0xB4, 0x0B, 0xC0, 0xC7, 0x09, 0xD0, 0x63, 0x0A, 0xC0, 0x63, 0x01, 0xD0, 0x47, 0x10,
  0xCD, 0x81, 0x30, 0x1D, 0x01, 0x30, 0x5C, 0x0D, 0x72, 0x01, 0x0E, 0xC8, 0x1D, 0x18, 0xC0, 0xA4,
  0x08, 0xC0, 0xA7, 0x30, 0x4D, 0x0C, 0x0E, 0xC0, 0x34, 0x09, 0xC0, 0x87, 0x40, 0x7F, 0xA0, 0xC5,
  0x09, 0xC0, 0x87, 0x50, 0xBF, 0x90, 0x45, 0x08, 0xC0, 0x97, 0x50, 0x10, 0xDE, 0x0C, 0x60, 0x7C,
  0x0D, 0x76, 0x03, 0xE0, 0x46, 0x04, 0xD0, 0x37, 0x50, 0x9E, 0x0C, 0x7D, 0x0C, 0x74, 0x09, 0xF9,
  0x09, 0x60, 0x9D, 0x0A, 0x71, 0x02, 0x0C, 0xFB, 0x06, 0x50, 0x2E, 0x81, 0xD5, 0x13, 0x04, 0x09,
  0xE0, 0xEE, 0x03, 0x50, 0x6F, 0x90, 0x0E, 0xF9, 0x81, 0xC1, 0x5D, 0x0E, 0x01, 0x50, 0x8F, 0xFA,
  0x09, 0x30, 0x8D, 0x0C, 0x60, 0x7F, 0xE0, 0xC0, 0x35, 0x0B, 0xD0, 0xA6, 0x81, 0x19, 0xEF, 0x81,
  0xEA, 0x47, 0x01, 0x0D, 0xD0, 0x77, 0x18, 0x53, 0x56, 0x77, 0x53, 0x77, 0x40,
  // "'" (U+0027)
  0x0D, 0xC0, 0x0B, 0xC0, 0x0A, 0xC0, 0x09, 0xC0, 0x08, 0xC0, 0x07, 0xC0, 0x06, 0xC0, 0x05, 0xC0,
  0x03, 0xC0, 0x02, 0xC0, 0x01, 0xC2, 0xB0, 0xE2, 0x0E, 0xA0, 0xD2, 0x0D, 0xA0, 0xC2, 0x0C, 0xA0,
  0xB2, 0x0B, 0xA0, 0xA1,
  // "(" (U+0028)
  0x71, 0x08, 0xC0, 0x77, 0x04, 0xC0, 0xB7, 0x01, 0x0E, 0xB0, 0xE0, 0x27, 0x0B, 0xC0, 0x77, 0x05,
  0xC0, 0xD7, 0x10, 0xDC, 0x05, 0x70, 0x7C, 0x0D, 0x71, 0x0E, 0xC0, 0x67, 0x06, 0xC0, 0xE7, 0x10,
  0xDC, 0x08, 0x70, 0x3D, 0x02, 0x70, 0x9C, 0x0C, 0x71, 0x0E, 0xC0, 0x77, 0x03, 0xD0, 0x27, 0x07,
  0xC0, 0xE7, 0x10, 0xBC, 0x09, 0x71, 0x0E, 0xC0, 0x67, 0x02, 0xD0, 0x37, 0x05, 0xD7, 0x10, 0x7C,
  0x0D, 0x71, 0x09, 0xC0, 0xB7, 0x10, 0xBC, 0x09, 0x71, 0x0C, 0xC0, 0x87, 0x10, 0xDC, 0x07, 0x71,
  0x0E, 0xC0, 0x67, 0x1D, 0x05, 0x71, 0xD0, 0x57, 0x1D, 0x05, 0x71, 0x0E, 0xC0, 0x67, 0x10, 0xDC,
  0x07, 0x71, 0x0C, 0xC0, 0x87, 0x10, 0xBC, 0x0A, 0x71, 0x09, 0xC0, 0xC7, 0x10, 0x7C, 0x0E, 0x71,
  0x04, 0xD0, 0x17, 0x01, 0xD0, 0x47, 0x10, 0xEC, 0x07, 0x71, 0x0A, 0xC0, 0xB7, 0x10, 0x6D, 0x71,
  0x02, 0xD0, 0x47, 0x10, 0xDC, 0x09, 0x71, 0x07, 0xC0, 0xE7, 0x10, 0x2D, 0x05, 0x71, 0x0B, 0xC0,
  0xA7, 0x10, 0x4D, 0x02, 0x71, 0x0C, 0xC0, 0x97, 0x10, 0x4D, 0x01, 0x71, 0x0B, 0xC0, 0x97, 0x10,
  0x20, 0xEC, 0x02, 0x71, 0x07, 0xC0, 0xB7, 0x20, 0xBC, 0x06, 0x71, 0x01, 0x0D, 0xB0, 0xE0, 0x17,
  0x18, 0x42, 0x77, 0x77, 0x40,
  // ")" (U+0029)
  0x84, 0x47, 0x77, 0x72, 0x71, 0x01, 0x0E, 0xB0, 0xD0, 0x17, 0x10, 0x6C, 0x0B, 0x72, 0x0B, 0xC0,
  0x77, 0x10, 0x3C, 0x0E, 0x01, 0x71, 0x09, 0xC0, 0xB7, 0x10, 0x1D, 0x04, 0x71, 0x09, 0xC0, 0xC7,
  0x10, 0x2D, 0x04, 0x71, 0x0B, 0xC0, 0xB7, 0x10, 0x5D, 0x01, 0x71, 0x0E, 0xC0, 0x77, 0x10, 0x9C,
  0x0D, 0x71, 0x04, 0xD0, 0x17, 0x1D, 0x06, 0x71, 0x0B, 0xC0, 0xA7, 0x10, 0x7C, 0x0E, 0x71, 0x04,
  0xD0, 0x17, 0x01, 0xD0, 0x47, 0x10, 0xEC, 0x07, 0x71, 0x0C, 0xC0, 0x97, 0x10, 0xAC, 0x0A, 0x71,
  0x08, 0xC0, 0xC7, 0x10, 0x7C, 0x0D, 0x71, 0x06, 0xC0, 0xE7, 0x10, 0x6C, 0x0E, 0x71, 0x05, 0xD7,
  0x10, 0x5C, 0x0E, 0x71, 0x06, 0xC0, 0xE7, 0x10, 0x7C, 0x0D, 0x71, 0x08, 0xC0, 0xC7, 0x10, 0x9C,
  0x0B, 0x71, 0x0B, 0xC0, 0x97, 0x10, 0xDC, 0x07, 0x71, 0xD0, 0x47, 0x03, 0xD0, 0x17, 0x06, 0xC0,
  0xE7, 0x10, 0x9C, 0x0B, 0x71, 0x0E, 0xC0, 0x77, 0x02, 0xD0, 0x27, 0x07, 0xC0, 0xD7, 0x10, 0xCC,
  0x08, 0x70, 0x2D, 0x03, 0x70, 0x8C, 0x0C, 0x71, 0x0E, 0xC0, 0x67, 0x06, 0xC0, 0xE7, 0x10, 0xDC,
  0x07, 0x70, 0x5C, 0x0D, 0x71, 0x0D, 0xC0, 0x57, 0x07, 0xC0, 0xB7, 0x02, 0x0E, 0xB0, 0xE0, 0x17,
  0x0B, 0xC0, 0x47, 0x07, 0xC0, 0x87, 0x10,
  // "*" (U+002A)
  0x73, 0x05, 0xC0, 0x47, 0x76, 0x04, 0xC0, 0x37, 0x76, 0x03, 0xC0, 0x27, 0x76, 0x02, 0xC0, 0x17,
  0x77, 0xC7, 0x77, 0x1C, 0x77, 0x71, 0x0D, 0xA0, 0xE7, 0x77, 0x10, 0xCA, 0x0D, 0x75, 0x82, 0xA8,
  0x41, 0x60, 0xBA, 0x0B, 0x68, 0x23, 0x7B, 0xE2, 0xC8, 0x1C, 0x84, 0x30, 0xAA, 0x0A, 0x28, 0x21,
  0x59, 0xEC, 0x02, 0x03, 0xF9, 0x81, 0xC8, 0xBA, 0x81, 0xB8, 0xCF, 0x90, 0x50, 0x6F, 0xFF, 0xB8,
  0x28, 0x5C, 0xEF, 0xFF, 0x90, 0x94, 0x84, 0x24, 0x68, 0xAC, 0xF8, 0x5D, 0xB9, 0x75, 0x31, 0x74,
  0x05, 0xE0, 0x77, 0x73, 0x02, 0x0E, 0xA0, 0x0E, 0xB0, 0x47, 0x72, 0x0D, 0xB0, 0x07, 0xB0, 0xE0,
  0x27, 0x70, 0xAB, 0x0E, 0x20, 0xEB, 0x0C, 0x76, 0x07, 0xC0, 0x72, 0x07, 0xC0, 0xA7, 0x40, 0x4C,
  0x0E, 0x40, 0xDC, 0x07, 0x72, 0x01, 0x0E, 0xC0, 0x64, 0x06, 0xD0, 0x47, 0x10, 0xCC, 0x0D, 0x60,
  0xDC, 0x0E, 0x01, 0x70, 0x7C, 0x06, 0x60, 0x5C, 0x0A, 0x01, 0x71, 0x82, 0x2B, 0xFD, 0x71, 0x82,
  0xDF, 0xD4, 0x75, 0x06, 0x05, 0x71, 0x04, 0x07, 0x70,
  // "+" (U+002B)
  0x74, 0x01, 0xC0, 0x37, 0x77, 0x10, 0x1C, 0x03, 0x77, 0x71, 0x01, 0xC0, 0x37, 0x77, 0x10, 0x1C,
  0x03, 0x77, 0x71, 0x01, 0xC0, 0x37, 0x77, 0x10, 0x1C, 0x03, 0x77, 0x71, 0x01, 0xC0, 0x37, 0x77,
  0x10, 0x1C, 0x03, 0x77, 0x71, 0x01, 0xC0, 0x37, 0x77, 0x10, 0x1C, 0x03, 0x77, 0x71, 0x01, 0xC0,
  0x37, 0x77, 0x10, 0x1C, 0x03, 0x74, 0x03, 0xFF, 0xFD, 0x00, 0x3F, 0xFF, 0xD0, 0x03, 0xFF, 0xFD,
  0x00, 0x3F, 0xFF, 0xD0, 0x30, 0x18, 0x06, 0x60, 0x7C, 0x08, 0x80, 0x66, 0x01, 0x74, 0x01, 0xC0,
  0x37, 0x77, 0x10, 0x1C, 0x03, 0x77, 0x71, 0x01, 0xC0, 0x37, 0x77, 0x10, 0x1C, 0x03, 0x77, 0x71,
  0x01, 0xC0, 0x37, 0x77, 0x10, 0x1C, 0x03, 0x77, 0x71, 0x01, 0xC0, 0x37, 0x77, 0x10, 0x1C, 0x03,
  0x77, 0x71, 0x01, 0xC0, 0x37, 0x77, 0x10, 0x1C, 0x03, 0x77, 0x71, 0x01, 0xC0, 0x37, 0x40,
  // "," (U+002C)
  0x30, 0x2E, 0x09, 0x30, 0x5E, 0x08, 0x30, 0x7E, 0x04, 0x30, 0xAD, 0x0E, 0x40, 0xDD, 0x0A, 0x4E,
  0x04, 0x30, 0x3D, 0x0E, 0x40, 0x6D, 0x09, 0x40, 0x9D, 0x03, 0x40, 0xDC, 0x0C, 0x40, 0x1D, 0x06,
  0x40, 0x4C, 0x0E, 0x01, 0x40, 0x7C, 0x09, 0x50, 0xBC, 0x02, 0x50, 0xEB, 0x0B, 0x50, 0x3C, 0x04,
  0x50,
  // "-" (U+002D)
  0x80, 0x96, 0x68, 0x09, 0x84, 0xF0,
  // "." (U+002E)
  0x28, 0x23, 0x66, 0x33, 0x0A, 0xC8, 0x1A, 0x05, 0xE0, 0x50, 0x9E, 0x09, 0x0A, 0xE0, 0xA0, 0x9E,
  0x09, 0x05, 0xE8, 0x15, 0x09, 0xC0, 0x93, 0x82, 0x36, 0x63, 0x20,
  // "/" (U+002F)
  0x77, 0x20, 0x8C, 0x09, 0x77, 0x20, 0xEC, 0x03, 0x77, 0x10, 0x4C, 0x0D, 0x77, 0x20, 0xAC, 0x07,
  0x77, 0x10, 0x1D, 0x01, 0x77, 0x10, 0x7C, 0x0A, 0x77, 0x20, 0xDC, 0x04, 0x77, 0x10, 0x3C, 0x0E,
  0x77, 0x20, 0x9C, 0x08, 0x77, 0x20, 0xEC, 0x02, 0x77, 0x10, 0x5C, 0x0C, 0x77, 0x20, 0xBC, 0x06,
  0x77, 0x10, 0x2C, 0x0E, 0x77, 0x20, 0x8C, 0x09, 0x77, 0x20, 0xDC, 0x03, 0x77, 0x10, 0x4C, 0x0D,
  0x77, 0x20, 0xAC, 0x07, 0x77, 0x10, 0x1D, 0x01, 0x77, 0x10, 0x6C, 0x0B, 0x77, 0x20, 0xCC, 0x05,
  0x77, 0x10, 0x3C, 0x0E, 0x77, 0x20, 0x9C, 0x08, 0x77, 0x20, 0xEC, 0x03, 0x77, 0x10, 0x5C, 0x0C,
  0x77, 0x20, 0xBC, 0x06, 0x77, 0x10, 0x1D, 0x01, 0x77, 0x10, 0x7C, 0x0A, 0x77, 0x20, 0xDC, 0x04,
  0x77, 0x10, 0x3C, 0x0D, 0x77, 0x20, 0x9C, 0x08, 0x77, 0x20, 0xEC, 0x02, 0x77, 0x10, 0x6C, 0x0B,
  0x77, 0x20, 0xCC, 0x05, 0x77, 0x10, 0x2C, 0x0E, 0x77, 0x20, 0x8C, 0x09, 0x77, 0x20, 0xEC, 0x03,
  0x77, 0x10, 0x4C, 0x0D, 0x77, 0x20, 0xAC, 0x07, 0x77, 0x10, 0x1D, 0x01, 0x77, 0x10, 0x7C, 0x0A,
  0x77, 0x20, 0xDC, 0x04, 0x77, 0x10, 0x3C, 0x0E, 0x77, 0x20, 0x9C, 0x08, 0x77, 0x20,
  // "0" (U+0030)
  0x74, 0x86, 0x14, 0x67, 0x76, 0x41, 0x77, 0x58, 0x11, 0x8D, 0xF9, 0x81, 0xD7, 0x17, 0x71, 0x07,
  0xFE, 0x0E, 0x06, 0x76, 0x0B, 0xFF, 0xA0, 0x97, 0x40, 0xBF, 0x90, 0x0E, 0xF9, 0x09, 0x72, 0x08,
  0xE0, 0x90, 0x33, 0x81, 0x15, 0xCE, 0x06, 0x70, 0x3D, 0x0D, 0x02, 0x71, 0x07, 0xD0, 0xE0, 0x16,
  0x0B, 0xC0, 0xE0, 0x17, 0x30, 0x8D, 0x09, 0x50, 0x3D, 0x04, 0x74, 0x0C, 0xE0, 0x14, 0x08, 0xC0,
  0xB7, 0x40, 0x6F, 0x07, 0x40, 0xEC, 0x04, 0x73, 0x01, 0x0E, 0xF0, 0xC3, 0x02, 0xC0, 0xE7, 0x40,
  0x9F, 0xA0, 0x12, 0x06, 0xC0, 0xA7, 0x30, 0x3D, 0x0C, 0xC0, 0x52, 0x0A, 0xC0, 0x67, 0x30, 0xBC,
  0x0A, 0x05, 0xC0, 0x92, 0x0C, 0xC0, 0x37, 0x20, 0x5C, 0x81, 0xE1, 0x2C, 0x0C, 0x20, 0xEC, 0x01,
  0x72, 0x0D, 0xC0, 0x72, 0xC8, 0x1E, 0x01, 0xC0, 0xE7, 0x20, 0x8C, 0x0D, 0x30, 0xCC, 0x01, 0x02,
  0xC0, 0xD7, 0x10, 0x2D, 0x04, 0x30, 0xBC, 0x02, 0x04, 0xC0, 0xB7, 0x10, 0xBC, 0x0B, 0x40, 0x9C,
  0x03, 0x05, 0xC0, 0xB7, 0x04, 0xD0, 0x24, 0x08, 0xC0, 0x05, 0xC0, 0xA7, 0x0D, 0xC0, 0x85, 0x07,
  0xC0, 0x05, 0xC0, 0xA6, 0x07, 0xC0, 0xE6, 0x07, 0xC0, 0x50, 0x6C, 0x09, 0x50, 0x10, 0xEC, 0x05,
  0x60, 0x7C, 0x00, 0x6C, 0x0A, 0x50, 0x9C, 0x0C, 0x70, 0x7C, 0x00, 0x5C, 0x0A, 0x40, 0x3D, 0x03,
  0x70, 0x7C, 0x00, 0x5C, 0x0B, 0x40, 0xCC, 0x09, 0x71, 0x08, 0xC0, 0x40, 0x3C, 0x0C, 0x30, 0x6C,
  0x0E, 0x01, 0x71, 0x09, 0xC0, 0x30, 0x2C, 0x0D, 0x20, 0x10, 0xEC, 0x06, 0x72, 0x0A, 0xC0, 0x21,
  0xC0, 0xE2, 0x08, 0xC0, 0xC7, 0x30, 0xBC, 0x81, 0x10, 0xEC, 0x01, 0x02, 0xD0, 0x37, 0x30, 0xEB,
  0x0E, 0x20, 0xBC, 0x03, 0x0B, 0xC0, 0xA7, 0x30, 0x1C, 0x0C, 0x20, 0x9C, 0x0B, 0xC0, 0xE0, 0x17,
  0x30, 0x4C, 0x09, 0x20, 0x5F, 0xA0, 0x77, 0x40, 0x8C, 0x05, 0x20, 0x1F, 0x90, 0xD7, 0x50, 0xCC,
  0x02, 0x30, 0xCF, 0x04, 0x74, 0x02, 0xC0, 0xD4, 0x07, 0xE0, 0xB7, 0x50, 0x9C, 0x08, 0x40, 0x1E,
  0x02, 0x74, 0x03, 0xD0, 0x25, 0x09, 0xC0, 0xE0, 0x27, 0x30, 0x10, 0xDC, 0x0A, 0x60, 0x10, 0xEC,
  0x0E, 0x03, 0x71, 0x02, 0x0D, 0xD0, 0x27, 0x06, 0xE0, 0xA0, 0x44, 0x04, 0x09, 0xE0, 0x77, 0x20,
  0xAF, 0x90, 0x0E, 0xF9, 0x0A, 0x74, 0x0A, 0xFF, 0xA0, 0xA7, 0x60, 0x60, 0xEF, 0xD0, 0xE0, 0x67,
  0x71, 0x81, 0x17, 0xDF, 0x98, 0x1D, 0x71, 0x77, 0x58, 0x62, 0x46, 0x77, 0x64, 0x17, 0x40,
  // "1" (U+0031)
  0x73, 0x04, 0x0D, 0xC0, 0x27, 0x73, 0x03, 0x0B, 0xE0, 0x27, 0x71, 0x02, 0x0A, 0xF9, 0x02, 0x76,
  0x01, 0x09, 0xFB, 0x02, 0x75, 0x07, 0x0E, 0xFC, 0x02, 0x73, 0x06, 0x0E, 0xFE, 0x02, 0x72, 0x0D,
  0xF9, 0x81, 0xD5, 0xCC, 0x02, 0x72, 0x09, 0xE0, 0xC0, 0x42, 0x0C, 0xC0, 0x27, 0x20, 0x10, 0xEB,
  0x0C, 0x04, 0x40, 0xDC, 0x02, 0x73, 0x82, 0x6F, 0xC4, 0x60, 0xDC, 0x02, 0x74, 0x04, 0x71, 0x0E,
  0xC0, 0x27, 0x76, 0x0E, 0xC0, 0x27, 0x76, 0xD0, 0x27, 0x76, 0xD0, 0x27, 0x76, 0xD0, 0x27, 0x76,
  0xD0, 0x27, 0x76, 0xD0, 0x27, 0x76, 0xD0, 0x27, 0x76, 0xD0, 0x27, 0x76, 0xD0, 0x27, 0x76, 0xD0,
  0x27, 0x76, 0xD0, 0x27, 0x76, 0xD0, 0x27, 0x76, 0xD0, 0x27, 0x76, 0xD0, 0x27, 0x76, 0xD0, 0x27,
  0x76, 0xD0, 0x27, 0x76, 0xD0, 0x27, 0x76, 0xD0, 0x27, 0x76, 0xD0, 0x27, 0x76, 0xD0, 0x27, 0x76,
  0xD0, 0x27, 0x76, 0xD0, 0x27, 0x76, 0xD0, 0x27, 0x76, 0xD0, 0x27, 0x76, 0xD0, 0x27, 0x76, 0xD0,
  0x27, 0x76, 0xD0, 0x27, 0x48, 0x05, 0x6D, 0x07, 0x80, 0x46, 0x01, 0x2F, 0xFF, 0xA0, 0x32, 0xFF,
  0xFA, 0x03, 0x2F, 0xFF, 0xA0, 0x32, 0xFF, 0xFA, 0x03,
  // "2" (U+0032)
  0x72, 0x87, 0x13, 0x56, 0x76, 0x54, 0x17, 0x73, 0x81, 0x27, 0xCF, 0xA8, 0x1C, 0x71, 0x75, 0x02,
  0x0A, 0xFF, 0x0E, 0x06, 0x72, 0x01, 0x09, 0xFF, 0xC0, 0xB7, 0x04, 0x0D, 0xFB, 0x0E, 0xFA, 0x0B,
  0x50, 0x2F, 0x82, 0xE9, 0x41, 0x38, 0x11, 0x5C, 0xE0, 0x85, 0x07, 0xD0, 0x80, 0x17, 0x20, 0x6E,
  0x01, 0x50, 0xAA, 0x0B, 0x02, 0x75, 0x05, 0xD0, 0x86, 0x0C, 0x07, 0x77, 0x10, 0xBC, 0x0D, 0x77,
  0x72, 0x05, 0xD0, 0x17, 0x77, 0x10, 0x2D, 0x04, 0x77, 0x72, 0xD0, 0x57, 0x77, 0x2D, 0x06, 0x77,
  0x71, 0x01, 0xD0, 0x57, 0x77, 0x10, 0x2D, 0x04, 0x77, 0x71, 0x06, 0xD0, 0x27, 0x77, 0x10, 0xAC,
  0x0E, 0x77, 0x71, 0x01, 0xD0, 0xA7, 0x77, 0x10, 0x7D, 0x05, 0x77, 0x70, 0x10, 0xEC, 0x0E, 0x77,
  0x71, 0x0A, 0xD0, 0x77, 0x77, 0x06, 0xD0, 0xE7, 0x77, 0x03, 0x0E, 0xD0, 0x57, 0x76, 0x01, 0x0D,
  0xD0, 0xA7, 0x77, 0x0B, 0xD0, 0xD0, 0x17, 0x76, 0x0A, 0xE0, 0x37, 0x76, 0x08, 0xE0, 0x57, 0x76,
  0x07, 0xE0, 0x77, 0x76, 0x07, 0xE0, 0x97, 0x76, 0x06, 0xE0, 0x97, 0x76, 0x06, 0xE0, 0x97, 0x76,
  0x06, 0xE0, 0x97, 0x76, 0x06, 0xE0, 0x97, 0x76, 0x06, 0xE0, 0x97, 0x76, 0x05, 0xE0, 0x97, 0x76,
  0x05, 0xE0, 0x97, 0x76, 0x05, 0xE0, 0x87, 0x76, 0x05, 0xE0, 0x87, 0x76, 0x05, 0xE0, 0x87, 0x76,
  0x05, 0xE0, 0xD8, 0x0A, 0x06, 0x04, 0x0C, 0xFF, 0xFE, 0x0A, 0x0C, 0xFF, 0xFE, 0x0A, 0x0C, 0xFF,
  0xFE, 0x0A, 0x0C, 0xFF, 0xFE, 0x0A,
  // "3" (U+0033)
  0x72, 0x87, 0x24, 0x67, 0x76, 0x54, 0x17, 0x72, 0x81, 0x5A, 0xEF, 0xA8, 0x1D, 0x82, 0x73, 0x81,
  0x29, 0xEF, 0xF9, 0x09, 0x70, 0x10, 0x9F, 0xFD, 0x0C, 0x01, 0x40, 0x20, 0xEF, 0xB0, 0x0E, 0xFA,
  0x0C, 0x50, 0xBE, 0x81, 0xB6, 0x24, 0x81, 0x25, 0xCE, 0x09, 0x40, 0x10, 0xEB, 0x09, 0x02, 0x73,
  0x06, 0xE0, 0x24, 0x82, 0x5F, 0xB2, 0x76, 0x07, 0xD0, 0x85, 0x04, 0x77, 0x20, 0xDC, 0x0D, 0x77,
  0x71, 0x08, 0xD7, 0x77, 0x10, 0x5D, 0x01, 0x77, 0x70, 0x4D, 0x02, 0x77, 0x70, 0x5D, 0x01, 0x77,
  0x70, 0x8C, 0x0E, 0x77, 0x71, 0x0C, 0xC0, 0xB7, 0x77, 0x04, 0xD0, 0x57, 0x76, 0x01, 0x0D, 0xC0,
  0xD7, 0x76, 0x02, 0x0C, 0xD0, 0x37, 0x74, 0x81, 0x17, 0xED, 0x05, 0x73, 0x01, 0x80, 0x16, 0x81,
  0x79, 0xCE, 0x0D, 0x03, 0x74, 0x04, 0xFD, 0x0C, 0x06, 0x76, 0x04, 0xFB, 0x0B, 0x04, 0x77, 0x10,
  0x4F, 0xD8, 0x1E, 0xA4, 0x75, 0x04, 0xFF, 0x90, 0xC0, 0x37, 0x72, 0x84, 0x11, 0x36, 0xAE, 0xE0,
  0x77, 0x77, 0x07, 0x0E, 0xD0, 0x67, 0x77, 0x02, 0x0D, 0xD0, 0x27, 0x77, 0x02, 0xD0, 0x97, 0x77,
  0x10, 0x8C, 0x0E, 0x77, 0x71, 0x03, 0xD0, 0x37, 0x77, 0x01, 0xD0, 0x57, 0x77, 0x1D, 0x07, 0x77,
  0x71, 0xD0, 0x77, 0x77, 0x01, 0xD0, 0x67, 0x77, 0x05, 0xD0, 0x47, 0x77, 0x0B, 0xD0, 0x17, 0x76,
  0x04, 0xD8, 0x2B, 0x04, 0x37, 0x73, 0x02, 0x0E, 0xD8, 0x54, 0x08, 0xFC, 0x61, 0x76, 0x05, 0x0E,
  0xD0, 0xB2, 0x08, 0xC8, 0x2C, 0x85, 0x35, 0x82, 0x14, 0x7D, 0xE0, 0xE0, 0x22, 0x08, 0xFB, 0x00,
  0xEF, 0xB0, 0xE0, 0x33, 0x08, 0xFF, 0xF0, 0xC0, 0x24, 0x04, 0x0C, 0xFF, 0xC0, 0xE0, 0x67, 0x18,
  0x22, 0x7A, 0xEF, 0xC8, 0x1D, 0xA5, 0x77, 0x89, 0x11, 0x35, 0x67, 0x77, 0x65, 0x31, 0x74,
  // "4" (U+0034)
  0x77, 0x30, 0xAD, 0x0B, 0x77, 0x71, 0x04, 0xE0, 0xB7, 0x77, 0x10, 0xDE, 0x0B, 0x77, 0x70, 0x7F,
  0x0B, 0x77, 0x60, 0x10, 0xEF, 0x0B, 0x77, 0x60, 0xAB, 0x0E, 0xC0, 0xB7, 0x75, 0x04, 0xC0, 0x8C,
  0x0B, 0x77, 0x50, 0xDB, 0x0E, 0x02, 0xC0, 0xB7, 0x74, 0x07, 0xC0, 0x70, 0x2C, 0x0B, 0x77, 0x30,
  0x2C, 0x81, 0xE0, 0x3C, 0x0B, 0x77, 0x30, 0xAC, 0x81, 0x60, 0x3C, 0x0B, 0x77, 0x20, 0x4C, 0x0C,
  0x20, 0x4C, 0x0B, 0x77, 0x20, 0xDC, 0x03, 0x20, 0x4C, 0x0B, 0x77, 0x10, 0x8C, 0x09, 0x30, 0x5C,
  0x0B, 0x77, 0x02, 0xC0, 0xE0, 0x13, 0x05, 0xC0, 0xB7, 0x70, 0xBC, 0x06, 0x40, 0x5C, 0x0B, 0x76,
  0x05, 0xC0, 0xC5, 0x05, 0xC0, 0xB7, 0x60, 0xDC, 0x03, 0x50, 0x6C, 0x0B, 0x75, 0x08, 0xC0, 0x96,
  0x06, 0xC0, 0xB7, 0x40, 0x2C, 0x0E, 0x01, 0x60, 0x6C, 0x0B, 0x74, 0x0B, 0xC0, 0x57, 0x06, 0xC0,
  0xB7, 0x30, 0x5C, 0x0B, 0x71, 0x06, 0xC0, 0xB7, 0x30, 0xDC, 0x02, 0x71, 0x06, 0xC0, 0xB7, 0x20,
  0x8C, 0x08, 0x72, 0x06, 0xC0, 0xB7, 0x10, 0x2C, 0x0D, 0x73, 0x06, 0xC0, 0xB7, 0x10, 0xBC, 0x05,
  0x73, 0x06, 0xC0, 0xB7, 0x05, 0xC0, 0xB7, 0x40, 0x6C, 0x0B, 0x70, 0xEC, 0x02, 0x74, 0x06, 0xC0,
  0xB6, 0x08, 0xC0, 0x87, 0x50, 0x6C, 0x0B, 0x68, 0x09, 0xE4, 0xF8, 0x09, 0x66, 0x0A, 0xC0, 0xD8,
  0x02, 0x67, 0x74, 0x06, 0xC0, 0xB7, 0x77, 0x30, 0x6C, 0x0B, 0x77, 0x73, 0x06, 0xC0, 0xB7, 0x77,
  0x30, 0x6C, 0x0B, 0x77, 0x73, 0x06, 0xC0, 0xB7, 0x77, 0x30, 0x6C, 0x0B, 0x77, 0x73, 0x06, 0xC0,
  0xB7, 0x77, 0x30, 0x6C, 0x0B, 0x77, 0x73, 0x06, 0xC0, 0xB6,
  // "5" (U+0035)
  0x30, 0xBF, 0xFE, 0x0A, 0x60, 0xCF, 0xFE, 0x0A, 0x60, 0xDF, 0xFE, 0x0A, 0x6F, 0xFF, 0x0A, 0x6C,
  0x0E, 0x80, 0x94, 0x60, 0x45, 0x01, 0xC0, 0xD7, 0x77, 0x10, 0x3C, 0x0B, 0x77, 0x71, 0x04, 0xC0,
  0xA7, 0x77, 0x10, 0x5C, 0x08, 0x77, 0x71, 0x06, 0xC0, 0x77, 0x77, 0x10, 0x8C, 0x06, 0x77, 0x71,
  0x09, 0xC0, 0x47, 0x77, 0x10, 0xAC, 0x03, 0x77, 0x71, 0x0B, 0xC0, 0x17, 0x77, 0x10, 0xDC, 0x77,
  0x72, 0x0E, 0xB0, 0xE7, 0x77, 0x2C, 0x89, 0x1D, 0x01, 0x34, 0x56, 0x55, 0x31, 0x75, 0x01, 0xC0,
  0x0E, 0xFA, 0x81, 0xD9, 0x37, 0x20, 0x2F, 0xFC, 0x0C, 0x03, 0x70, 0x3F, 0xFE, 0x08, 0x60, 0x10,
  0xCF, 0xFE, 0x0A, 0x78, 0x57, 0xFC, 0x96, 0x31, 0x28, 0x31, 0x25, 0x9E, 0xF0, 0x97, 0x76, 0x07,
  0x0E, 0xE0, 0x47, 0x76, 0x02, 0x0D, 0xD0, 0xC7, 0x77, 0x02, 0x0E, 0xD0, 0x47, 0x77, 0x07, 0xD0,
  0x97, 0x77, 0x10, 0xEC, 0x0C, 0x77, 0x71, 0x0B, 0xD7, 0x77, 0x10, 0x8D, 0x01, 0x77, 0x70, 0x6D,
  0x01, 0x77, 0x70, 0x6D, 0x01, 0x77, 0x70, 0x7D, 0x77, 0x71, 0x09, 0xC0, 0xD7, 0x77, 0x10, 0xDC,
  0x0A, 0x77, 0x70, 0x4D, 0x06, 0x77, 0x70, 0xDC, 0x83, 0xE1, 0x01, 0x47, 0x73, 0x0B, 0xD0, 0x82,
  0x82, 0x3F, 0xB4, 0x76, 0x04, 0x0D, 0xD0, 0xD3, 0x03, 0xB8, 0x2E, 0x96, 0x35, 0x82, 0x14, 0x7D,
  0xF0, 0x33, 0x03, 0xFA, 0x00, 0xEF, 0xB0, 0xE0, 0x44, 0x03, 0xFF, 0xE0, 0xC0, 0x25, 0x01, 0x0A,
  0xFF, 0xB0, 0xE0, 0x77, 0x28, 0x21, 0x6A, 0xDF, 0xB8, 0x1E, 0xA5, 0x77, 0x18, 0x90, 0x13, 0x56,
  0x77, 0x65, 0x42, 0x75,
  // "6" (U+0036)
  0x77, 0x28, 0x73, 0x56, 0x77, 0x76, 0x53, 0x77, 0x38, 0x14, 0x8D, 0xFB, 0x0D, 0x77, 0x05, 0x0D,
  0xFE, 0x0D, 0x75, 0x02, 0x0C, 0xFF, 0x90, 0xD7, 0x40, 0x40, 0xEF, 0xB0, 0xFE, 0xB0, 0xD7, 0x30,
  0x5F, 0x82, 0xD8, 0x52, 0x58, 0x11, 0x47, 0x72, 0x04, 0xE0, 0xD0, 0x57, 0x76, 0x01, 0x0E, 0xD0,
  0x97, 0x77, 0x10, 0xAD, 0x06, 0x77, 0x71, 0x03, 0xD0, 0x87, 0x77, 0x20, 0xBC, 0x0D, 0x77, 0x72,
  0x02, 0xD0, 0x57, 0x77, 0x20, 0x8C, 0x0C, 0x77, 0x73, 0x0D, 0xC0, 0x67, 0x77, 0x20, 0x2D, 0x02,
  0x77, 0x72, 0x06, 0xC0, 0xC7, 0x77, 0x30, 0x9C, 0x09, 0x68, 0x51, 0x45, 0x54, 0x31, 0x74, 0x0B,
  0xC0, 0x63, 0x81, 0x18, 0xDF, 0x81, 0xD8, 0x27, 0x10, 0xDC, 0x04, 0x20, 0x60, 0xEF, 0xD0, 0xA0,
  0x16, 0xD8, 0x12, 0x09, 0xFF, 0x90, 0xD0, 0x34, 0x02, 0xD0, 0x10, 0x8F, 0xFC, 0x03, 0x30, 0x3D,
  0x03, 0xC8, 0x7B, 0x63, 0x10, 0x12, 0x5A, 0xE0, 0xD0, 0x12, 0x04, 0xD0, 0xDA, 0x0D, 0x03, 0x72,
  0x02, 0x0D, 0xD0, 0x92, 0x05, 0xF0, 0xA7, 0x60, 0xCD, 0x81, 0x20, 0x5E, 0x0B, 0x77, 0x02, 0xD8,
  0x18, 0x06, 0xD0, 0xE0, 0x17, 0x71, 0x09, 0xC8, 0x1C, 0x05, 0xD0, 0x77, 0x72, 0x04, 0xD0, 0x10,
  0x5D, 0x02, 0x77, 0x3D, 0x03, 0x04, 0xD7, 0x74, 0x0D, 0xC0, 0x40, 0x3C, 0x0E, 0x77, 0x40, 0xCC,
  0x05, 0x01, 0xD7, 0x74, 0x0C, 0xC8, 0x15, 0x0E, 0xC0, 0x27, 0x73, 0x0D, 0xC8, 0x14, 0x0B, 0xC0,
  0x67, 0x73, 0x0E, 0xC8, 0x13, 0x07, 0xC0, 0xB7, 0x72, 0x01, 0xD8, 0x11, 0x02, 0xD0, 0x17, 0x71,
  0x05, 0xC0, 0xD3, 0x0D, 0xC0, 0x97, 0x71, 0x0B, 0xC0, 0x93, 0x06, 0xD0, 0x47, 0x60, 0x3D, 0x03,
  0x40, 0xDC, 0x0E, 0x03, 0x74, 0x01, 0x0E, 0xC0, 0xC5, 0x04, 0xD0, 0xE0, 0x57, 0x20, 0x40, 0xED,
  0x04, 0x60, 0x9E, 0x81, 0xB5, 0x13, 0x81, 0x15, 0xBE, 0x08, 0x71, 0x0A, 0xFA, 0x0E, 0xFA, 0x0B,
  0x73, 0x09, 0xFF, 0xB0, 0x97, 0x50, 0x40, 0xDF, 0xE0, 0xD0, 0x57, 0x71, 0x05, 0x0B, 0xFA, 0x0B,
  0x06, 0x77, 0x68, 0x53, 0x57, 0x76, 0x53, 0x74,
  // "7" (U+0037)
  0x06, 0xFF, 0xFF, 0x00, 0x6F, 0xFF, 0xF0, 0x06, 0xFF, 0xFF, 0x00, 0x6F, 0xFF, 0xF0, 0x60, 0x28,
  0x0A, 0x26, 0x08, 0xD0, 0x27, 0x77, 0x20, 0x8C, 0x0B, 0x77, 0x73, 0x0E, 0xC0, 0x57, 0x77, 0x20,
  0x6C, 0x0D, 0x77, 0x73, 0x0C, 0xC0, 0x77, 0x77, 0x20, 0x3D, 0x01, 0x77, 0x72, 0x0A, 0xC0, 0xA7,
  0x77, 0x20, 0x1D, 0x03, 0x77, 0x72, 0x08, 0xC0, 0xC7, 0x77, 0x30, 0xEC, 0x06, 0x77, 0x72, 0x05,
  0xC0, 0xE7, 0x77, 0x30, 0xCC, 0x09, 0x77, 0x72, 0x03, 0xD0, 0x27, 0x77, 0x20, 0xAC, 0x0B, 0x77,
  0x72, 0x01, 0xD0, 0x57, 0x77, 0x20, 0x8C, 0x0D, 0x77, 0x73, 0x0E, 0xC0, 0x77, 0x77, 0x20, 0x5D,
  0x01, 0x77, 0x72, 0x0C, 0xC0, 0xA7, 0x77, 0x20, 0x3D, 0x03, 0x77, 0x72, 0x0A, 0xC0, 0xD7, 0x77,
  0x20, 0x1D, 0x06, 0x77, 0x72, 0x07, 0xC0, 0xE7, 0x77, 0x30, 0xEC, 0x09, 0x77, 0x72, 0x05, 0xD0,
  0x27, 0x77, 0x20, 0xCC, 0x0B, 0x77, 0x72, 0x03, 0xD0, 0x57, 0x77, 0x20, 0xAC, 0x0E, 0x77, 0x72,
  0x01, 0xD0, 0x77, 0x77, 0x20, 0x7D, 0x01, 0x77, 0x72, 0x0E, 0xC0, 0xA7, 0x77, 0x20, 0x5D, 0x04,
  0x77, 0x72, 0x0C, 0xC0, 0xD7, 0x77, 0x20, 0x3D, 0x06, 0x77, 0x72, 0x09, 0xC0, 0xE7, 0x77, 0x20,
  0x1D, 0x09, 0x77, 0x72, 0x07, 0xD0, 0x27, 0x77, 0x20, 0xDC, 0x0B, 0x77, 0x72, 0x05, 0xD0, 0x57,
  0x72,
  // "8" (U+0038)
  0x73, 0x86, 0x24, 0x67, 0x76, 0x42, 0x77, 0x38, 0x13, 0x9D, 0xF9, 0x81, 0xE9, 0x37, 0x50, 0x20,
  0xBF, 0xF0, 0xB0, 0x27, 0x20, 0x40, 0xEF, 0xFA, 0x0E, 0x04, 0x70, 0x4F, 0xA0, 0x0E, 0xFA, 0x04,
  0x50, 0x10, 0xED, 0x81, 0xD7, 0x24, 0x81, 0x37, 0xED, 0x0E, 0x01, 0x40, 0x9D, 0x09, 0x73, 0x0A,
  0xD0, 0x93, 0x01, 0xD0, 0xA7, 0x50, 0xBC, 0x0E, 0x30, 0x4D, 0x01, 0x75, 0x02, 0xD0, 0x32, 0x07,
  0xC0, 0xC7, 0x70, 0xDC, 0x06, 0x20, 0x8C, 0x0B, 0x77, 0x0C, 0xC0, 0x72, 0x07, 0xC0, 0xB7, 0x70,
  0xCC, 0x06, 0x20, 0x6C, 0x0D, 0x77, 0x0E, 0xC0, 0x52, 0x03, 0xD0, 0x27, 0x50, 0x3D, 0x01, 0x30,
  0xDC, 0x0A, 0x75, 0x0B, 0xC0, 0xC4, 0x07, 0xD0, 0x87, 0x30, 0x7D, 0x05, 0x50, 0xCD, 0x09, 0x71,
  0x0A, 0xD0, 0xB6, 0x02, 0x0E, 0xD0, 0xD0, 0x54, 0x04, 0x0D, 0xD0, 0xC0, 0x17, 0x02, 0x0D, 0xE8,
  0x2C, 0x43, 0xBE, 0x0B, 0x01, 0x72, 0x02, 0x0D, 0xFF, 0x08, 0x76, 0x09, 0xFC, 0x0B, 0x03, 0x77,
  0x10, 0x8F, 0xA0, 0xC0, 0x17, 0x70, 0x20, 0xAF, 0xC0, 0xE0, 0x77, 0x50, 0x7E, 0x0E, 0x0B, 0xF0,
  0xC0, 0x27, 0x20, 0xBD, 0x0E, 0x07, 0x20, 0x30, 0xBF, 0x06, 0x70, 0xBD, 0x0B, 0x01, 0x50, 0x40,
  0xCE, 0x07, 0x50, 0xAD, 0x07, 0x72, 0x07, 0xE0, 0x63, 0x05, 0xD0, 0x77, 0x40, 0x20, 0xDD, 0x02,
  0x20, 0xEC, 0x0A, 0x76, 0x01, 0x0D, 0xC8, 0x1C, 0x05, 0xD0, 0x27, 0x70, 0x3D, 0x03, 0x09, 0xC0,
  0xB7, 0x72, 0x0C, 0xC0, 0x80, 0xCC, 0x07, 0x77, 0x20, 0x7C, 0x0B, 0x0D, 0xC0, 0x67, 0x72, 0x06,
  0xC0, 0xC0, 0xDC, 0x06, 0x77, 0x20, 0x6C, 0x00, 0xCC, 0x07, 0x77, 0x20, 0x8C, 0x0B, 0x0A, 0xC0,
  0xB7, 0x72, 0x0D, 0xC0, 0x90, 0x6D, 0x02, 0x77, 0x05, 0xD0, 0x50, 0x1D, 0x0C, 0x76, 0x02, 0x0E,
  0xC0, 0xE2, 0x09, 0xD0, 0xB0, 0x17, 0x30, 0x40, 0xED, 0x06, 0x20, 0x10, 0xED, 0x82, 0xE9, 0x41,
  0x48, 0x12, 0x6C, 0xE0, 0xB4, 0x03, 0x0E, 0xFA, 0x00, 0xEF, 0xA0, 0xC0, 0x15, 0x03, 0x0D, 0xFF,
  0xC0, 0xA7, 0x20, 0x9F, 0xF9, 0x0D, 0x05, 0x74, 0x81, 0x17, 0xCF, 0xA8, 0x1E, 0xA5, 0x77, 0x38,
  0x63, 0x56, 0x77, 0x64, 0x27, 0x30,
  // "9" (U+0039)
  0x74, 0x85, 0x35, 0x67, 0x65, 0x37, 0x76, 0x81, 0x5B, 0xEF, 0x90, 0xB0, 0x57, 0x71, 0x05, 0x0D,
  0xFE, 0x0D, 0x04, 0x75, 0x09, 0xFF, 0xB0, 0x87, 0x30, 0xBF, 0xA0, 0xEF, 0xA0, 0x97, 0x10, 0x9E,
  0x81, 0xB5, 0x13, 0x81, 0x16, 0xCE, 0x07, 0x60, 0x5D, 0x0D, 0x03, 0x72, 0x05, 0x0E, 0xD0, 0x35,
  0x0D, 0xC0, 0xD0, 0x17, 0x40, 0x20, 0xEC, 0x0C, 0x40, 0x5D, 0x03, 0x76, 0x03, 0xD0, 0x43, 0x0A,
  0xC0, 0xA7, 0x71, 0x09, 0xC0, 0xB3, 0x0E, 0xC0, 0x47, 0x71, 0x01, 0xD8, 0x11, 0x02, 0xD0, 0x17,
  0x72, 0x09, 0xC8, 0x15, 0x03, 0xC0, 0xD7, 0x73, 0x05, 0xC8, 0x19, 0x05, 0xC0, 0xC7, 0x73, 0x01,
  0xC8, 0x1C, 0x06, 0xC0, 0xC7, 0x74, 0xD1, 0x05, 0xC0, 0xC7, 0x74, 0xD0, 0x10, 0x4C, 0x0D, 0x77,
  0x30, 0x1D, 0x03, 0x02, 0xD0, 0x17, 0x72, 0x04, 0xD8, 0x14, 0x0E, 0xC0, 0x57, 0x72, 0x0B, 0xD8,
  0x15, 0x0B, 0xC0, 0xB7, 0x71, 0x04, 0xE8, 0x15, 0x06, 0xD0, 0x47, 0x60, 0x20, 0xEE, 0x06, 0x20,
  0xEC, 0x0E, 0x03, 0x74, 0x04, 0x0E, 0xF0, 0x52, 0x06, 0xE0, 0x70, 0x17, 0x02, 0x0A, 0xB0, 0xCD,
  0x05, 0x30, 0xAF, 0x85, 0xB8, 0x76, 0x79, 0xDC, 0x0E, 0x02, 0xD0, 0x44, 0x0B, 0xFF, 0xB0, 0x40,
  0x1D, 0x03, 0x50, 0x9F, 0xF8, 0x2E, 0x40, 0x2D, 0x01, 0x60, 0x30, 0xBF, 0xC0, 0xA0, 0x12, 0x04,
  0xD7, 0x28, 0x91, 0x26, 0xAD, 0xEF, 0xED, 0xB7, 0x24, 0x07, 0xC0, 0xD7, 0x77, 0x30, 0xAC, 0x09,
  0x77, 0x73, 0x0D, 0xC0, 0x67, 0x77, 0x20, 0x3D, 0x03, 0x77, 0x72, 0x08, 0xC0, 0xD7, 0x77, 0x30,
  0xDC, 0x08, 0x77, 0x72, 0x06, 0xD0, 0x37, 0x77, 0x20, 0xEC, 0x0B, 0x77, 0x72, 0x09, 0xD0, 0x37,
  0x77, 0x10, 0x7D, 0x0B, 0x77, 0x71, 0x08, 0xD0, 0xE0, 0x17, 0x76, 0x04, 0x0C, 0xE0, 0x47, 0x28,
  0x22, 0x73, 0x14, 0x82, 0x14, 0x8D, 0xF0, 0x67, 0x30, 0x4C, 0x00, 0xEF, 0xC0, 0x67, 0x40, 0x4F,
  0xF9, 0x0D, 0x03, 0x75, 0x04, 0xFE, 0x0D, 0x06, 0x77, 0x04, 0xFB, 0x81, 0xDA, 0x47, 0x73, 0x89,
  0x02, 0x45, 0x67, 0x76, 0x54, 0x17, 0x71,
  // ":" (U+003A)
  0x28, 0x22, 0x66, 0x33, 0x09, 0xC8, 0x1A, 0x04, 0xE0, 0x50, 0x8E, 0x00, 0x9E, 0x0A, 0x08, 0xE0,
  0x90, 0x4E, 0x81, 0x50, 0x8C, 0x09, 0x38, 0x22, 0x66, 0x38, 0x0A, 0x80, 0x08, 0x23, 0x66, 0x33,
  0x0A, 0xC8, 0x19, 0x05, 0xE0, 0x50, 0x9E, 0x08, 0x0A, 0xE0, 0x09, 0xE0, 0x80, 0x5E, 0x81, 0x40,
  0x9C, 0x09, 0x38, 0x23, 0x66, 0x22,
  // ";" (U+003B)
  0x58, 0x21, 0x57, 0x47, 0x05, 0x0E, 0xB0, 0xD0, 0x25, 0x0E, 0xD0, 0xB4, 0x04, 0xF4, 0x05, 0xF0,
  0x13, 0x03, 0xF5, 0x0E, 0xD0, 0xB5, 0x04, 0x0E, 0xB0, 0xD0, 0x26, 0x82, 0x15, 0x74, 0x80, 0xB9,
  0x60, 0x02, 0xE0, 0x94, 0x05, 0xE0, 0x84, 0x07, 0xE0, 0x44, 0x0A, 0xD0, 0xE5, 0x0D, 0xD0, 0xA5,
  0xE0, 0x44, 0x03, 0xD0, 0xE5, 0x06, 0xD0, 0x95, 0x09, 0xD0, 0x35, 0x0D, 0xC0, 0xC5, 0x01, 0xD0,
  0x65, 0x04, 0xC0, 0xE0, 0x15, 0x07, 0xC0, 0x96, 0x0B, 0xC0, 0x26, 0x0E, 0xB0, 0xB6, 0x03, 0xC0,
  0x46,
  // "<" (U+003C)
  0x77, 0x74, 0x02, 0x77, 0x72, 0x81, 0x4D, 0x97, 0x77, 0x03, 0x0B, 0xA0, 0x97, 0x75, 0x01, 0x09,
  0xC0, 0x97, 0x74, 0x07, 0x0E, 0xD0, 0x97, 0x72, 0x06, 0x0E, 0xE0, 0xC0, 0x37, 0x70, 0x40, 0xCE,
  0x0D, 0x05, 0x77, 0x02, 0x0A, 0xE0, 0xE0, 0x77, 0x70, 0x10, 0x9F, 0x08, 0x01, 0x77, 0x07, 0x0E,
  0xE0, 0xA0, 0x17, 0x70, 0x50, 0xDE, 0x0B, 0x03, 0x77, 0x03, 0x0C, 0xE0, 0xC0, 0x47, 0x70, 0x20,
  0xAE, 0x0D, 0x06, 0x77, 0x01, 0x08, 0xE0, 0xE0, 0x77, 0x71, 0x05, 0x0E, 0xE0, 0x90, 0x17, 0x72,
  0x09, 0xD0, 0xA0, 0x27, 0x74, 0x09, 0xD0, 0xC0, 0x57, 0x74, 0x07, 0xF0, 0xD0, 0x67, 0x73, 0x02,
  0x0A, 0xF0, 0xD0, 0x67, 0x73, 0x02, 0x09, 0xF0, 0xE0, 0x77, 0x73, 0x02, 0x09, 0xF8, 0x1E, 0x71,
  0x77, 0x20, 0x20, 0x9F, 0x81, 0xE8, 0x17, 0x72, 0x02, 0x09, 0xF9, 0x08, 0x01, 0x77, 0x20, 0x10,
  0x9F, 0x90, 0x90, 0x27, 0x72, 0x01, 0x08, 0xF9, 0x0A, 0x02, 0x77, 0x28, 0x11, 0x8E, 0xF0, 0x77,
  0x73, 0x81, 0x18, 0xED, 0x09, 0x77, 0x58, 0x11, 0x8E, 0xB0, 0x97, 0x77, 0x83, 0x18, 0xEF, 0x97,
  0x77, 0x28, 0x11, 0x78,
  // "=" (U+003D)
  0x0C, 0xFF, 0xFD, 0x00, 0xCF, 0xFF, 0xD0, 0x0C, 0xFF, 0xFD, 0x00, 0xCF, 0xFF, 0xD0, 0xC0, 0x58,
  0x0A, 0x66, 0x05, 0x80, 0xAC, 0x40, 0x05, 0x80, 0xA6, 0x60, 0x50, 0xCF, 0xFF, 0xD0, 0x0C, 0xFF,
  0xFD, 0x00, 0xCF, 0xFF, 0xD0, 0x0C, 0xFF, 0xFD, 0x0C,
  // ">" (U+003E)
  0x02, 0x77, 0x74, 0x81, 0x9D, 0x47, 0x77, 0x20, 0x9A, 0x0B, 0x03, 0x77, 0x70, 0x9C, 0x09, 0x01,
  0x77, 0x50, 0x9D, 0x0E, 0x07, 0x77, 0x40, 0x30, 0xCE, 0x0D, 0x06, 0x77, 0x40, 0x50, 0xDE, 0x0C,
  0x04, 0x77, 0x40, 0x70, 0xEE, 0x0B, 0x02, 0x77, 0x30, 0x10, 0x8F, 0x09, 0x01, 0x77, 0x30, 0x10,
  0xAE, 0x0E, 0x07, 0x77, 0x40, 0x30, 0xBE, 0x0D, 0x05, 0x77, 0x40, 0x40, 0xCE, 0x0C, 0x03, 0x77,
  0x40, 0x60, 0xDE, 0x0A, 0x02, 0x77, 0x40, 0x70, 0xEE, 0x08, 0x01, 0x77, 0x30, 0x10, 0x9E, 0x0E,
  0x05, 0x77, 0x40, 0x20, 0xAD, 0x09, 0x77, 0x40, 0x50, 0xDD, 0x09, 0x77, 0x20, 0x60, 0xDF, 0x07,
  0x77, 0x06, 0x0D, 0xF0, 0xA0, 0x27, 0x60, 0x70, 0xEF, 0x0A, 0x02, 0x75, 0x81, 0x17, 0xEF, 0x09,
  0x02, 0x75, 0x81, 0x18, 0xEF, 0x09, 0x02, 0x75, 0x01, 0x08, 0xF9, 0x09, 0x02, 0x75, 0x02, 0x09,
  0xF9, 0x09, 0x01, 0x75, 0x02, 0x0A, 0xF9, 0x09, 0x01, 0x76, 0x07, 0xF8, 0x1E, 0x81, 0x77, 0x10,
  0x9D, 0x81, 0xE8, 0x17, 0x73, 0x09, 0xB8, 0x1E, 0x81, 0x77, 0x58, 0x39, 0xFE, 0x81, 0x77, 0x78,
  0x18, 0x71, 0x77, 0x72,
  // "?" (U+003F)
  0x78, 0x90, 0x13, 0x56, 0x77, 0x65, 0x41, 0x76, 0x81, 0x49, 0xDF, 0xB8, 0x1D, 0x92, 0x78, 0x13,
  0x9E, 0xFF, 0xA0, 0xA0, 0x14, 0x06, 0xFF, 0xE0, 0xE0, 0x43, 0x01, 0x0E, 0xFB, 0x00, 0xEF, 0x90,
  0xE0, 0x43, 0x09, 0xC8, 0x3E, 0xA6, 0x31, 0x48, 0x13, 0x7D, 0xD0, 0xE0, 0x12, 0x03, 0xA0, 0xB0,
  0x57, 0x50, 0x9D, 0x09, 0x30, 0x70, 0x27, 0x71, 0x0A, 0xC0, 0xE7, 0x76, 0x01, 0xD0, 0x47, 0x76,
  0x0B, 0xC0, 0x67, 0x76, 0x08, 0xC0, 0x87, 0x76, 0x08, 0xC0, 0x87, 0x76, 0x09, 0xC0, 0x77, 0x76,
  0x0B, 0xC0, 0x67, 0x76, 0xD0, 0x37, 0x75, 0x06, 0xC0, 0xE7, 0x75, 0x01, 0x0E, 0xC0, 0x97, 0x75,
  0x0B, 0xD0, 0x27, 0x73, 0x01, 0x0B, 0xD0, 0x77, 0x73, 0x02, 0x0D, 0xD0, 0xB7, 0x73, 0x05, 0x0E,
  0xD0, 0xB7, 0x73, 0x09, 0xE0, 0xA7, 0x73, 0x0B, 0xE0, 0x77, 0x73, 0x0B, 0xD0, 0xE0, 0x47, 0x73,
  0x07, 0xD0, 0xD0, 0x27, 0x73, 0x01, 0xD0, 0xC0, 0x17, 0x74, 0x08, 0xC0, 0xD0, 0x17, 0x75, 0x0C,
  0xC0, 0x47, 0x76, 0xC0, 0xD7, 0x76, 0x01, 0xC0, 0x97, 0x76, 0x02, 0xC0, 0x87, 0x76, 0x84, 0x2D,
  0xDD, 0xD6, 0x80, 0x9F, 0x10, 0x82, 0x15, 0x74, 0x77, 0x70, 0x50, 0xEB, 0x0D, 0x02, 0x77, 0x50,
  0xED, 0x0B, 0x77, 0x40, 0x4F, 0x77, 0x40, 0x5F, 0x01, 0x77, 0x30, 0x3F, 0x77, 0x50, 0xED, 0x0B,
  0x77, 0x50, 0x40, 0xEB, 0x0D, 0x02, 0x77, 0x68, 0x21, 0x57, 0x47, 0x60,
  // "@" (U+0040)
  0x76, 0x89, 0x11, 0x59, 0xCD, 0xEF, 0xDC, 0x95, 0x77, 0x72, 0x03, 0x0A, 0xFC, 0x81, 0xE8, 0x17,
  0x75, 0x09, 0xFF, 0x90, 0xE0, 0x57, 0x72, 0x02, 0x0D, 0xFF, 0xC0, 0x87, 0x70, 0x30, 0xEE, 0x86,
  0xEA, 0x87, 0x67, 0xAE, 0xE0, 0x87, 0x50, 0x20, 0xED, 0x0A, 0x03, 0x71, 0x05, 0x0D, 0xD0, 0x67,
  0x40, 0xCC, 0x0D, 0x04, 0x75, 0x09, 0xD0, 0x27, 0x20, 0x9C, 0x0C, 0x01, 0x77, 0x07, 0xC0, 0xB7,
  0x10, 0x2C, 0x0D, 0x01, 0x77, 0x20, 0x9C, 0x04, 0x70, 0xBB, 0x0E, 0x02, 0x77, 0x40, 0xDB, 0x0B,
  0x60, 0x3C, 0x06, 0x77, 0x50, 0x5C, 0x02, 0x50, 0x9B, 0x0D, 0x77, 0x70, 0xCB, 0x08, 0x40, 0x1C,
  0x06, 0x78, 0x90, 0x39, 0xCE, 0xFE, 0xCA, 0x62, 0x40, 0x6B, 0x0D, 0x40, 0x5B, 0x0E, 0x60, 0x10,
  0xAF, 0xB0, 0xD0, 0x52, 0x01, 0xC0, 0x13, 0x0A, 0xB0, 0x95, 0x02, 0x0D, 0xFD, 0x0B, 0x30, 0xBB,
  0x05, 0x30, 0xEB, 0x04, 0x40, 0x10, 0xDF, 0xE0, 0xA3, 0x08, 0xB0, 0x82, 0x02, 0xC5, 0x0A, 0xD8,
  0x3A, 0x77, 0x9E, 0xC0, 0x93, 0x05, 0xB0, 0xA2, 0x05, 0xB0, 0xC4, 0x04, 0xC0, 0xE0, 0x35, 0xC0,
  0x83, 0x03, 0xB0, 0xC2, 0x08, 0xB0, 0x94, 0x0B, 0xC0, 0x65, 0x01, 0xC0, 0x73, 0x01, 0xB0, 0xE2,
  0x0A, 0xB0, 0x73, 0x01, 0xC0, 0xC6, 0x01, 0xC0, 0x64, 0xC2, 0x0C, 0xB0, 0x53, 0x06, 0xC0, 0x76,
  0x02, 0xC0, 0x64, 0xC2, 0x0E, 0xB0, 0x33, 0x09, 0xC0, 0x26, 0x03, 0xC0, 0x54, 0x0E, 0xB0, 0x11,
  0xC0, 0x23, 0x0C, 0xB0, 0xE7, 0x04, 0xC0, 0x44, 0x0E, 0xB0, 0x11, 0xC0, 0x13, 0x0E, 0xB0, 0xC7,
  0x05, 0xC0, 0x34, 0x0E, 0xB2, 0xC0, 0x13, 0xC0, 0xA7, 0x06, 0xC0, 0x24, 0xC1, 0x01, 0xC4, 0xC0,
  0xA7, 0x08, 0xC0, 0x14, 0xB8, 0x1E, 0x01, 0xC0, 0x13, 0xC0, 0xA7, 0x09, 0xC0, 0x13, 0x01, 0xB0,
  0xC2, 0xC0, 0x23, 0xC0, 0xA7, 0x0C, 0xC4, 0x03, 0xB0, 0xA2, 0xC0, 0x33, 0x0D, 0xB0, 0xC7, 0x0E,
  0xC4, 0x05, 0xB0, 0x82, 0x0E, 0xB0, 0x43, 0x0B, 0xB0, 0xE6, 0x03, 0xD0, 0x13, 0x08, 0xB0, 0x52,
  0x0C, 0xB0, 0x63, 0x08, 0xC0, 0x45, 0x08, 0xD0, 0x33, 0x0C, 0xB0, 0x12, 0x0A, 0xB0, 0x93, 0x04,
  0xC0, 0xB4, 0x01, 0x0E, 0xA0, 0xDA, 0x07, 0x20, 0x2B, 0x0C, 0x30, 0x7B, 0x0C, 0x40, 0xDC, 0x83,
  0xA2, 0x03, 0xCA, 0x0D, 0x05, 0xA8, 0x2E, 0x41, 0xBB, 0x07, 0x30, 0x4C, 0x40, 0x6F, 0xC0, 0x50,
  0x1F, 0x90, 0xE0, 0x13, 0x01, 0xC0, 0x54, 0x0C, 0xFA, 0x0A, 0x20, 0xAF, 0x08, 0x50, 0xCB, 0x0A,
  0x40, 0x20, 0xDF, 0x0D, 0x30, 0x3E, 0x0C, 0x60, 0x7C, 0x01, 0x40, 0x10, 0xAD, 0x0A, 0x01, 0x40,
  0x5C, 0x0B, 0x01, 0x60, 0x2C, 0x08, 0x68, 0x31, 0x45, 0x41, 0x78, 0x21, 0x55, 0x27, 0x20, 0xBC,
  0x02, 0x77, 0x77, 0x20, 0x3C, 0x0B, 0x77, 0x77, 0x30, 0xBC, 0x08, 0x77, 0x77, 0x20, 0x20, 0xEC,
  0x08, 0x77, 0x77, 0x20, 0x6D, 0x0B, 0x02, 0x77, 0x20, 0x37, 0x50, 0x9E, 0x09, 0x03, 0x73, 0x83,
  0x15, 0xAE, 0xB7, 0x60, 0xAF, 0x89, 0x0E, 0xA8, 0x76, 0x77, 0x8B, 0xDC, 0x0B, 0x77, 0x07, 0xFF,
  0xE0, 0xB7, 0x71, 0x03, 0x0C, 0xFF, 0xB0, 0xE0, 0x77, 0x73, 0x05, 0x0B, 0xFE, 0x0C, 0x07, 0x77,
  0x78, 0x93, 0x26, 0x9C, 0xDE, 0xFE, 0xDC, 0x96, 0x27, 0x30,
  // "A" (U+0041)
  0x77, 0xD0, 0xE7, 0x77, 0x60, 0x5E, 0x04, 0x77, 0x75, 0x0A, 0xE0, 0x97, 0x77, 0x50, 0xEE, 0x0E,
  0x77, 0x74, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x0A, 0xF9, 0x09, 0x77, 0x73, 0x0E, 0xB0, 0xB0, 0xDB,
  0x0E, 0x77, 0x72, 0x04, 0xC0, 0x80, 0x9C, 0x03, 0x77, 0x71, 0x09, 0xC0, 0x40, 0x5C, 0x08, 0x77,
  0x71, 0x0E, 0xC1, 0x01, 0xC0, 0xD7, 0x77, 0x04, 0xC0, 0xB2, 0x0C, 0xC0, 0x37, 0x76, 0x09, 0xC0,
  0x62, 0x07, 0xC0, 0x87, 0x76, 0x0E, 0xC0, 0x22, 0x03, 0xC0, 0xD7, 0x75, 0x03, 0xC0, 0xD4, 0x0D,
  0xC0, 0x37, 0x74, 0x08, 0xC0, 0x84, 0x09, 0xC0, 0x87, 0x74, 0x0D, 0xC0, 0x34, 0x04, 0xC0, 0xD7,
  0x73, 0x03, 0xC0, 0xD6, 0x0E, 0xC0, 0x27, 0x72, 0x08, 0xC0, 0x96, 0x0A, 0xC0, 0x77, 0x72, 0x0D,
  0xC0, 0x46, 0x05, 0xC0, 0xC7, 0x71, 0x02, 0xC0, 0xE7, 0x1D, 0x02, 0x77, 0x07, 0xC0, 0xA7, 0x10,
  0xBC, 0x07, 0x77, 0x0D, 0xC0, 0x57, 0x10, 0x6C, 0x0C, 0x76, 0x02, 0xD7, 0x20, 0x1D, 0x02, 0x75,
  0x07, 0xC0, 0xA7, 0x30, 0xBC, 0x07, 0x75, 0x0C, 0xC0, 0x67, 0x30, 0x7C, 0x0C, 0x74, 0x02, 0xFF,
  0xF9, 0x01, 0x73, 0x07, 0xFF, 0xF9, 0x06, 0x73, 0x0C, 0xFF, 0xF9, 0x0B, 0x72, 0x01, 0xFF, 0xFB,
  0x01, 0x71, 0x06, 0xC0, 0xC8, 0x09, 0x26, 0x0C, 0xC0, 0x67, 0x10, 0xBC, 0x06, 0x77, 0x07, 0xC0,
  0xB7, 0x01, 0xD0, 0x17, 0x70, 0x2D, 0x01, 0x60, 0x6C, 0x0C, 0x77, 0x20, 0xDC, 0x05, 0x60, 0xBC,
  0x07, 0x77, 0x20, 0x8C, 0x0A, 0x50, 0x1D, 0x03, 0x77, 0x20, 0x4D, 0x50, 0x5C, 0x0D, 0x77, 0x40,
  0xEC, 0x05, 0x40, 0xAC, 0x09, 0x77, 0x40, 0xAC, 0x0A, 0x4D, 0x04, 0x77, 0x40, 0x5C, 0x0E, 0x30,
  0x5D, 0x77, 0x50, 0x1D, 0x05, 0x20, 0xAC, 0x0A, 0x77, 0x60, 0xBC, 0x0A, 0x20, 0xEC, 0x06, 0x77,
  0x60, 0x7C, 0x81, 0xE0, 0x4D, 0x01, 0x77, 0x60, 0x2D, 0x04, 0x09, 0xC0, 0xC7, 0x77, 0x10, 0xDC,
  0x09,
  // "B" (U+0042)
  0x04, 0xFD, 0x84, 0xED, 0xCA, 0x74, 0x72, 0x04, 0xFF, 0xC8, 0x1E, 0xA3, 0x60, 0x4F, 0xFF, 0x0A,
  0x01, 0x40, 0x4F, 0xFF, 0x90, 0xD0, 0x23, 0x04, 0xC0, 0xD8, 0x03, 0x68, 0x27, 0x8A, 0xDF, 0x0C,
  0x30, 0x4C, 0x0C, 0x74, 0x03, 0x0A, 0xE0, 0x72, 0x04, 0xC0, 0xC7, 0x60, 0x7D, 0x0D, 0x20, 0x4C,
  0x0C, 0x77, 0x0B, 0xD8, 0x12, 0x04, 0xC0, 0xC7, 0x70, 0x5D, 0x81, 0x50, 0x4C, 0x0C, 0x77, 0x01,
  0xD8, 0x16, 0x04, 0xC0, 0xC7, 0x71, 0xD8, 0x17, 0x04, 0xC0, 0xC7, 0x71, 0xD8, 0x16, 0x04, 0xC0,
  0xC7, 0x70, 0x1D, 0x81, 0x50, 0x4C, 0x0C, 0x77, 0x04, 0xD8, 0x11, 0x04, 0xC0, 0xC7, 0x70, 0x9C,
  0x0C, 0x20, 0x4C, 0x0C, 0x76, 0x03, 0xD0, 0x62, 0x04, 0xC0, 0xC7, 0x50, 0x40, 0xEC, 0x0B, 0x30,
  0x4C, 0x0C, 0x71, 0x82, 0x13, 0x6C, 0xD0, 0xC0, 0x13, 0x04, 0xFF, 0xF0, 0x85, 0x04, 0xFF, 0xC8,
  0x1B, 0x71, 0x60, 0x4F, 0xFB, 0x82, 0xE9, 0x51, 0x60, 0x4F, 0xFE, 0x81, 0xE9, 0x24, 0x04, 0xC0,
  0xD8, 0x03, 0x68, 0x27, 0x79, 0xCE, 0x0E, 0x05, 0x30, 0x4C, 0x0C, 0x74, 0x81, 0x17, 0xED, 0x06,
  0x20, 0x4C, 0x0C, 0x76, 0x02, 0x0D, 0xD8, 0x13, 0x04, 0xC0, 0xC7, 0x70, 0x3D, 0x81, 0xB0, 0x4C,
  0x0C, 0x77, 0x10, 0x9D, 0x02, 0x04, 0xC0, 0xC7, 0x71, 0x03, 0xD0, 0x60, 0x4C, 0x0C, 0x77, 0x2D,
  0x09, 0x04, 0xC0, 0xC7, 0x72, 0x0D, 0xC0, 0xA0, 0x4C, 0x0C, 0x77, 0x20, 0xCC, 0x0A, 0x04, 0xC0,
  0xC7, 0x72, 0x0D, 0xC0, 0x90, 0x4C, 0x0C, 0x77, 0x2D, 0x08, 0x04, 0xC0, 0xC7, 0x71, 0x04, 0xD0,
  0x50, 0x4C, 0x0C, 0x77, 0x10, 0xAD, 0x01, 0x04, 0xC0, 0xC7, 0x70, 0x3D, 0x81, 0xC0, 0x4C, 0x0C,
  0x76, 0x02, 0x0D, 0xD8, 0x15, 0x04, 0xC0, 0xC7, 0x50, 0x70, 0xED, 0x0C, 0x20, 0x4C, 0x0D, 0x80,
  0x46, 0x81, 0x78, 0xBF, 0x0E, 0x02, 0x20, 0x4F, 0xFF, 0x90, 0xE0, 0x33, 0x04, 0xFF, 0xF0, 0xB0,
  0x14, 0x04, 0xFF, 0xD0, 0xC0, 0x56, 0x04, 0xFF, 0x83, 0xDC, 0xA7, 0x37, 0x10,
  // "C" (U+0043)
  0x77, 0x87, 0x25, 0x67, 0x76, 0x54, 0x27, 0x73, 0x81, 0x5B, 0xEF, 0xA8, 0x2E, 0xB7, 0x27, 0x40,
  0x70, 0xEF, 0xFA, 0x0C, 0x05, 0x70, 0x30, 0xDF, 0xFD, 0x0A, 0x60, 0x6F, 0xB0, 0x0E, 0xFA, 0x03,
  0x50, 0x7F, 0x81, 0xB6, 0x24, 0x82, 0x14, 0x7B, 0xB0, 0xB5, 0x05, 0xE0, 0xB0, 0x27, 0x48, 0x21,
  0x7E, 0x44, 0x01, 0x0E, 0xD0, 0x87, 0x77, 0x0B, 0xD0, 0x87, 0x77, 0x04, 0xD0, 0xB7, 0x77, 0x10,
  0xCD, 0x02, 0x77, 0x70, 0x2D, 0x09, 0x77, 0x71, 0x08, 0xD0, 0x27, 0x77, 0x10, 0xDC, 0x0C, 0x77,
  0x71, 0x01, 0xD0, 0x77, 0x77, 0x10, 0x5D, 0x03, 0x77, 0x71, 0x08, 0xD7, 0x77, 0x20, 0xAC, 0x0D,
  0x77, 0x72, 0x0C, 0xC0, 0xB7, 0x77, 0x20, 0xEC, 0x09, 0x77, 0x72, 0xD0, 0x97, 0x77, 0x2D, 0x08,
  0x77, 0x72, 0xD0, 0x77, 0x77, 0x2D, 0x08, 0x77, 0x72, 0xD0, 0x87, 0x77, 0x20, 0xEC, 0x09, 0x77,
  0x72, 0x0C, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0C, 0x77, 0x72, 0x09, 0xD7, 0x77, 0x20, 0x6D, 0x02,
  0x77, 0x71, 0x02, 0xD0, 0x67, 0x77, 0x20, 0xEC, 0x0B, 0x77, 0x72, 0x09, 0xD7, 0x77, 0x20, 0x5D,
  0x06, 0x77, 0x72, 0x0D, 0xC0, 0xE7, 0x77, 0x20, 0x7D, 0x07, 0x77, 0x72, 0x0E, 0xD0, 0x37, 0x77,
  0x10, 0x5D, 0x0E, 0x03, 0x77, 0x71, 0x09, 0xE0, 0x87, 0x68, 0x13, 0x81, 0x60, 0xBE, 0x82, 0xE9,
  0x41, 0x48, 0x31, 0x36, 0x9D, 0xA0, 0x27, 0x0B, 0xFB, 0x00, 0xEF, 0x90, 0x27, 0x10, 0x8F, 0xFD,
  0x02, 0x72, 0x03, 0x0B, 0xFF, 0xB0, 0x27, 0x48, 0x12, 0x8D, 0xFB, 0x82, 0xEB, 0x72, 0x77, 0x28,
  0x73, 0x56, 0x77, 0x65, 0x42, 0x60,
  // "D" (U+0044)
  0x0C, 0xFB, 0x84, 0xED, 0xC9, 0x73, 0x76, 0x0C, 0xFF, 0xA8, 0x1D, 0x81, 0x73, 0x0C, 0xFF, 0xD0,
  0x87, 0x20, 0xCF, 0xFE, 0x0D, 0x03, 0x70, 0xCC, 0x0B, 0x80, 0x16, 0x81, 0x79, 0xBF, 0xA0, 0x46,
  0x0C, 0xC0, 0x97, 0x20, 0x50, 0xCF, 0x04, 0x50, 0xCC, 0x09, 0x74, 0x05, 0x0E, 0xD0, 0xE0, 0x24,
  0x0C, 0xC0, 0x97, 0x50, 0x10, 0xCD, 0x0C, 0x40, 0xCC, 0x09, 0x76, 0x01, 0x0D, 0xD0, 0x63, 0x0C,
  0xC0, 0x97, 0x70, 0x20, 0xEC, 0x0E, 0x30, 0xCC, 0x09, 0x77, 0x10, 0x7D, 0x06, 0x20, 0xCC, 0x09,
  0x77, 0x20, 0xEC, 0x0C, 0x20, 0xCC, 0x09, 0x77, 0x20, 0x8D, 0x81, 0x20, 0xCC, 0x09, 0x77, 0x20,
  0x3D, 0x81, 0x60, 0xCC, 0x09, 0x77, 0x30, 0xEC, 0x81, 0xA0, 0xCC, 0x09, 0x77, 0x30, 0xBC, 0x81,
  0xC0, 0xCC, 0x09, 0x77, 0x30, 0x8D, 0x10, 0xCC, 0x09, 0x77, 0x30, 0x6D, 0x01, 0x0C, 0xC0, 0x97,
  0x73, 0x05, 0xD0, 0x20, 0xCC, 0x09, 0x77, 0x30, 0x4D, 0x03, 0x0C, 0xC0, 0x97, 0x73, 0x03, 0xD0,
  0x40, 0xCC, 0x09, 0x77, 0x30, 0x3D, 0x04, 0x0C, 0xC0, 0x97, 0x73, 0x03, 0xD0, 0x30, 0xCC, 0x09,
  0x77, 0x30, 0x4D, 0x03, 0x0C, 0xC0, 0x97, 0x73, 0x05, 0xD0, 0x20, 0xCC, 0x09, 0x77, 0x30, 0x7D,
  0x10, 0xCC, 0x09, 0x77, 0x30, 0xAC, 0x81, 0xE0, 0xCC, 0x09, 0x77, 0x30, 0xDC, 0x81, 0xB0, 0xCC,
  0x09, 0x77, 0x20, 0x1D, 0x81, 0x80, 0xCC, 0x09, 0x77, 0x20, 0x5D, 0x81, 0x40, 0xCC, 0x09, 0x77,
  0x20, 0xBD, 0x20, 0xCC, 0x09, 0x77, 0x10, 0x2D, 0x0A, 0x20, 0xCC, 0x09, 0x77, 0x10, 0xBD, 0x04,
  0x20, 0xCC, 0x09, 0x77, 0x05, 0xD0, 0xC3, 0x0C, 0xC0, 0x97, 0x60, 0x30, 0xED, 0x04, 0x30, 0xCC,
  0x09, 0x75, 0x03, 0x0E, 0xD0, 0x94, 0x0C, 0xC0, 0x97, 0x40, 0x8E, 0x0C, 0x50, 0xCC, 0x09, 0x71,
  0x81, 0x28, 0xEE, 0x0D, 0x02, 0x50, 0xCC, 0x87, 0xB6, 0x66, 0x67, 0x8A, 0xEF, 0x90, 0xD0, 0x16,
  0x0C, 0xFF, 0xE0, 0xA7, 0x10, 0xCF, 0xFC, 0x0D, 0x04, 0x72, 0x0C, 0xFF, 0xA0, 0xA0, 0x47, 0x40,
  0xCF, 0xA8, 0x4E, 0xEC, 0xA8, 0x47, 0x70,
  // "E" (U+0045)
  0x04, 0xFF, 0xFB, 0x0E, 0x04, 0xFF, 0xFB, 0x0E, 0x04, 0xFF, 0xFB, 0x0E, 0x04, 0xFF, 0xFB, 0x0E,
  0x04, 0xD0, 0x78, 0x09, 0x66, 0x05, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0,
  0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0,
  0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0,
  0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xFF, 0xFA, 0x81, 0xB0, 0x4F,
  0xFF, 0xA8, 0x1B, 0x04, 0xFF, 0xFA, 0x81, 0xB0, 0x4F, 0xFF, 0xA8, 0x1B, 0x04, 0xD0, 0x78, 0x09,
  0x56, 0x81, 0x40, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D,
  0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D,
  0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D,
  0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D,
  0x07, 0x80, 0x96, 0x60, 0x50, 0x4F, 0xFF, 0xB0, 0xE0, 0x4F, 0xFF, 0xB0, 0xE0, 0x4F, 0xFF, 0xB0,
  0xE0, 0x4F, 0xFF, 0xB0, 0xE0,
  // "F" (U+0046)
  0x04, 0xFF, 0xFB, 0x0E, 0x04, 0xFF, 0xFB, 0x0E, 0x04, 0xFF, 0xFB, 0x0E, 0x04, 0xFF, 0xFB, 0x0E,
  0x04, 0xD0, 0x78, 0x09, 0x66, 0x05, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0,
  0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0,
  0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0,
  0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0,
  0x17, 0x75, 0x04, 0xFF, 0xFA, 0x81, 0xB0, 0x4F, 0xFF, 0xA8, 0x1B, 0x04, 0xFF, 0xFA, 0x81, 0xB0,
  0x4F, 0xFF, 0xA8, 0x1B, 0x04, 0xD0, 0x78, 0x09, 0x56, 0x81, 0x40, 0x4D, 0x01, 0x77, 0x50, 0x4D,
  0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D,
  0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D,
  0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D,
  0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D,
  0x01, 0x77, 0x50,
  // "G" (U+0047)
  0x77, 0x18, 0x73, 0x56, 0x77, 0x65, 0x41, 0x77, 0x38, 0x12, 0x7C, 0xFB, 0x81, 0xE9, 0x57, 0x50,
  0x20, 0xAF, 0xFA, 0x81, 0xE8, 0x17, 0x10, 0x7F, 0xFD, 0x0E, 0x01, 0x70, 0xAF, 0xB0, 0x0E, 0xF9,
  0x09, 0x70, 0xBF, 0x81, 0xA5, 0x24, 0x82, 0x14, 0x7C, 0xB0, 0x26, 0x09, 0xE0, 0xA0, 0x27, 0x48,
  0x13, 0xBB, 0x60, 0x5E, 0x06, 0x77, 0x10, 0x16, 0x0E, 0xD0, 0x57, 0x77, 0x10, 0x8D, 0x08, 0x77,
  0x72, 0x0E, 0xC0, 0xE7, 0x77, 0x20, 0x6D, 0x06, 0x77, 0x72, 0x0B, 0xC0, 0xE7, 0x77, 0x20, 0x1D,
  0x09, 0x77, 0x72, 0x05, 0xD0, 0x47, 0x77, 0x20, 0x8D, 0x77, 0x73, 0x0B, 0xC0, 0xC7, 0x77, 0x30,
  0xEC, 0x0A, 0x77, 0x73, 0xD0, 0x77, 0x77, 0x20, 0x2D, 0x05, 0x77, 0x72, 0x03, 0xD0, 0x57, 0x77,
  0x20, 0x3D, 0x04, 0x72, 0x01, 0x80, 0x90, 0x60, 0x50, 0x4D, 0x03, 0x72, 0x03, 0xFD, 0x0C, 0x04,
  0xD0, 0x37, 0x20, 0x3F, 0xD0, 0xC0, 0x4D, 0x04, 0x72, 0x03, 0xFD, 0x0C, 0x03, 0xD0, 0x47, 0x20,
  0x3F, 0xD0, 0xC0, 0x2D, 0x06, 0x77, 0x30, 0x6C, 0x0C, 0x01, 0xD0, 0x77, 0x73, 0x06, 0xC8, 0x1C,
  0x0E, 0xC0, 0xA7, 0x73, 0x06, 0xC8, 0x1C, 0x0C, 0xC0, 0xD7, 0x73, 0x06, 0xC8, 0x1C, 0x09, 0xD0,
  0x17, 0x72, 0x06, 0xC8, 0x1C, 0x05, 0xD0, 0x57, 0x72, 0x06, 0xC8, 0x1C, 0x01, 0xD0, 0xA7, 0x72,
  0x06, 0xC0, 0xC2, 0x0C, 0xD0, 0x17, 0x71, 0x06, 0xC0, 0xC2, 0x06, 0xD0, 0x87, 0x71, 0x06, 0xC0,
  0xC3, 0x0E, 0xD0, 0x37, 0x70, 0x6C, 0x0C, 0x30, 0x7D, 0x0D, 0x01, 0x76, 0x06, 0xC0, 0xC4, 0x0D,
  0xD0, 0xC0, 0x17, 0x50, 0x6C, 0x0C, 0x40, 0x3E, 0x0E, 0x05, 0x74, 0x06, 0xC0, 0xC5, 0x06, 0xF8,
  0x1D, 0x73, 0x58, 0x22, 0x48, 0xDC, 0x0C, 0x60, 0x6F, 0xC0, 0x0E, 0xFA, 0x0C, 0x70, 0x40, 0xEF,
  0xFE, 0x0C, 0x71, 0x81, 0x18, 0xEF, 0xFB, 0x0E, 0x07, 0x73, 0x82, 0x16, 0xBE, 0xFB, 0x82, 0xEB,
  0x73, 0x77, 0x28, 0x90, 0x24, 0x67, 0x77, 0x65, 0x31, 0x60,
  // "H" (U+0048)
  0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72,
  0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0,
  0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0,
  0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72,
  0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0,
  0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0,
  0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xFF, 0xFD, 0x00,
  0xCF, 0xFF, 0xD0, 0x0C, 0xFF, 0xFD, 0x00, 0xCF, 0xFF, 0xD0, 0x0C, 0xC0, 0xB8, 0x09, 0x46, 0x0B,
  0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97,
  0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C,
  0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09,
  0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97,
  0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C,
  0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09,
  0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97,
  0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0xC0,
  // "I" (U+0049)
  0x06, 0xFF, 0xF9, 0x00, 0x6F, 0xFF, 0x90, 0x06, 0xFF, 0xF9, 0x00, 0x6F, 0xFF, 0x98, 0x90, 0x61,
  0x46, 0x78, 0xAB, 0xDE, 0xE8, 0x7E, 0xDB, 0xA8, 0x76, 0x41, 0x72, 0x0B, 0xC0, 0x97, 0x74, 0x0B,
  0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B,
  0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B,
  0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B,
  0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B,
  0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B,
  0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B,
  0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B,
  0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x78, 0x31,
  0x34, 0x5D, 0xC8, 0x3C, 0x54, 0x31, 0x58, 0x24, 0xBD, 0xEF, 0xFA, 0x83, 0xED, 0xB4, 0x6F, 0xFF,
  0x90, 0x06, 0xFF, 0xF9, 0x00, 0x6F, 0xFF, 0x90, 0x60,
  // "J" (U+004A)
  0x77, 0x20, 0x7C, 0x0E, 0x77, 0x20, 0x7C, 0x0E, 0x77, 0x20, 0x7C, 0x0E, 0x77, 0x20, 0x7C, 0x0E,
  0x77, 0x20, 0x7C, 0x0E, 0x77, 0x20, 0x7C, 0x0E, 0x77, 0x20, 0x7C, 0x0E, 0x77, 0x20, 0x7C, 0x0E,
  0x77, 0x20, 0x7C, 0x0E, 0x77, 0x20, 0x7C, 0x0E, 0x77, 0x20, 0x7C, 0x0E, 0x77, 0x20, 0x7C, 0x0E,
  0x77, 0x20, 0x7C, 0x0E, 0x77, 0x20, 0x7C, 0x0E, 0x77, 0x20, 0x7C, 0x0E, 0x77, 0x20, 0x7C, 0x0E,
  0x77, 0x20, 0x7C, 0x0E, 0x77, 0x20, 0x7C, 0x0E, 0x77, 0x20, 0x7C, 0x0E, 0x77, 0x20, 0x7C, 0x0E,
  0x77, 0x20, 0x7C, 0x0E, 0x77, 0x20, 0x7C, 0x0E, 0x77, 0x20, 0x7C, 0x0E, 0x77, 0x20, 0x7C, 0x0E,
  0x77, 0x20, 0x7C, 0x0E, 0x77, 0x20, 0x7C, 0x0E, 0x77, 0x20, 0x7C, 0x0E, 0x77, 0x20, 0x7C, 0x0E,
  0x77, 0x20, 0x7C, 0x0E, 0x77, 0x20, 0x7C, 0x0E, 0x77, 0x20, 0x8C, 0x0D, 0x77, 0x20, 0x9C, 0x0C,
  0x77, 0x20, 0xBC, 0x0B, 0x77, 0x20, 0xEC, 0x08, 0x77, 0x10, 0x3D, 0x05, 0x77, 0x10, 0xAD, 0x01,
  0x77, 0x05, 0xD8, 0x2B, 0x08, 0x37, 0x40, 0x5E, 0x04, 0x1A, 0x82, 0xD9, 0x63, 0x48, 0x11, 0x5B,
  0xE0, 0xA2, 0xF9, 0x0E, 0xFA, 0x0D, 0x01, 0x2F, 0xFB, 0x0D, 0x02, 0x3F, 0xFA, 0x0A, 0x01, 0x48,
  0x22, 0x7B, 0xEF, 0xA8, 0x1E, 0x93, 0x73, 0x87, 0x13, 0x56, 0x77, 0x65, 0x27, 0x20,
  // "K" (U+004B)
  0x0C, 0xC0, 0x97, 0x71, 0x02, 0x0E, 0xC8, 0x1E, 0x2C, 0xC0, 0x97, 0x71, 0x0C, 0xD8, 0x15, 0x0C,
  0xC0, 0x97, 0x70, 0x8D, 0x09, 0x20, 0xCC, 0x09, 0x76, 0x04, 0xD0, 0xD3, 0x0C, 0xC0, 0x97, 0x50,
  0x10, 0xED, 0x03, 0x30, 0xCC, 0x09, 0x75, 0x0B, 0xD0, 0x74, 0x0C, 0xC0, 0x97, 0x40, 0x7D, 0x0B,
  0x50, 0xCC, 0x09, 0x73, 0x03, 0xD0, 0xE0, 0x15, 0x0C, 0xC0, 0x97, 0x20, 0x10, 0xDD, 0x04, 0x60,
  0xCC, 0x09, 0x72, 0x0A, 0xD0, 0x87, 0x0C, 0xC0, 0x97, 0x10, 0x6D, 0x0C, 0x71, 0x0C, 0xC0, 0x97,
  0x03, 0xD0, 0xE0, 0x27, 0x10, 0xCC, 0x09, 0x70, 0xDD, 0x06, 0x72, 0x0C, 0xC0, 0x96, 0x0A, 0xD0,
  0xA7, 0x30, 0xCC, 0x09, 0x50, 0x6D, 0x0D, 0x01, 0x73, 0x0C, 0xC0, 0x94, 0x02, 0x0E, 0xD0, 0x37,
  0x40, 0xCC, 0x09, 0x40, 0xCD, 0x07, 0x75, 0x0C, 0xC0, 0x93, 0x08, 0xD0, 0xB7, 0x60, 0xCC, 0x09,
  0x20, 0x3D, 0x0E, 0x01, 0x76, 0x0C, 0xC0, 0x92, 0x0D, 0xD0, 0x57, 0x70, 0xCC, 0x81, 0x90, 0x9E,
  0x09, 0x77, 0x0C, 0xC0, 0x90, 0x3F, 0x90, 0x37, 0x60, 0xCC, 0x09, 0x0C, 0xF9, 0x0D, 0x76, 0x0C,
  0xC0, 0xEC, 0x0B, 0xD0, 0x77, 0x50, 0xCF, 0x98, 0x17, 0x0C, 0xD0, 0x27, 0x40, 0xCF, 0x09, 0x20,
  0x3D, 0x0C, 0x74, 0x0C, 0xE0, 0xA4, 0x09, 0xD0, 0x67, 0x30, 0xCD, 0x0C, 0x60, 0xDC, 0x0E, 0x01,
  0x72, 0x0C, 0xC0, 0xD0, 0x16, 0x05, 0xD0, 0xB7, 0x20, 0xCC, 0x09, 0x71, 0x0A, 0xD0, 0x57, 0x10,
  0xCC, 0x09, 0x71, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x0C, 0xC0, 0x97, 0x20, 0x6D, 0x09, 0x70, 0xCC,
  0x09, 0x73, 0x0C, 0xD0, 0x46, 0x0C, 0xC0, 0x97, 0x30, 0x2D, 0x0D, 0x60, 0xCC, 0x09, 0x74, 0x08,
  0xD0, 0x85, 0x0C, 0xC0, 0x97, 0x50, 0xDD, 0x03, 0x40, 0xCC, 0x09, 0x75, 0x04, 0xD0, 0xC4, 0x0C,
  0xC0, 0x97, 0x60, 0xAD, 0x07, 0x30, 0xCC, 0x09, 0x76, 0x01, 0x0E, 0xD0, 0x22, 0x0C, 0xC0, 0x97,
  0x70, 0x6D, 0x0B, 0x20, 0xCC, 0x09, 0x77, 0x10, 0xBD, 0x81, 0x60, 0xCC, 0x09, 0x77, 0x10, 0x2D,
  0x81, 0xE1, 0xCC, 0x09, 0x77, 0x20, 0x7D, 0x0A,
  // "L" (U+004C)
  0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74,
  0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74,
  0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74,
  0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74,
  0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74,
  0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74,
  0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74,
  0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74,
  0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74,
  0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x98, 0x09, 0x56, 0x05, 0x01, 0xFF,
  0xFA, 0x0E, 0x01, 0xFF, 0xFA, 0x0E, 0x01, 0xFF, 0xFA, 0x0E, 0x01, 0xFF, 0xFA, 0x0E,
  // "M" (U+004D)
  0xF0, 0xD7, 0x70, 0xEF, 0xF9, 0x02, 0x75, 0x03, 0xFF, 0xA0, 0x67, 0x50, 0x7F, 0xFA, 0x0B, 0x75,
  0x0C, 0xFF, 0xB7, 0x40, 0x1F, 0xE0, 0xEC, 0x04, 0x73, 0x05, 0xC0, 0xEF, 0x90, 0x9C, 0x08, 0x73,
  0x09, 0xC0, 0x9F, 0x90, 0x80, 0xEB, 0x0D, 0x73, 0x0E, 0xB0, 0xD0, 0x8F, 0x90, 0x90, 0xAC, 0x02,
  0x71, 0x03, 0xC0, 0x80, 0xAF, 0x90, 0xA0, 0x5C, 0x06, 0x71, 0x07, 0xC0, 0x30, 0xBF, 0x90, 0xB0,
  0x1C, 0x0A, 0x71, 0x0B, 0xB8, 0x1E, 0x0C, 0xF9, 0x81, 0xC0, 0xBB, 0x0E, 0x71, 0xC8, 0x1A, 0x0D,
  0xF9, 0x81, 0xD0, 0x7C, 0x04, 0x60, 0x5C, 0x81, 0x50, 0xEF, 0x98, 0x1E, 0x02, 0xC0, 0x86, 0x09,
  0xC0, 0x11, 0xFB, 0x20, 0xDB, 0x0C, 0x60, 0xDB, 0x0B, 0x2F, 0xB2, 0x08, 0xC0, 0x14, 0x02, 0xC0,
  0x72, 0xFB, 0x20, 0x3C, 0x06, 0x40, 0x7C, 0x02, 0x2F, 0xB0, 0x12, 0x0E, 0xB0, 0xA4, 0x0B, 0xB0,
  0xD3, 0xFB, 0x01, 0x20, 0xAB, 0x0E, 0x4C, 0x08, 0x20, 0x1F, 0xB0, 0x12, 0x05, 0xC0, 0x32, 0x04,
  0xC0, 0x42, 0x01, 0xFB, 0x01, 0x20, 0x1C, 0x08, 0x20, 0x9B, 0x0E, 0x30, 0x1F, 0xB0, 0x13, 0x0B,
  0xB0, 0xC2, 0x0D, 0xB0, 0xA3, 0x01, 0xFB, 0x01, 0x30, 0x7C, 0x01, 0x02, 0xC0, 0x53, 0x01, 0xFB,
  0x01, 0x30, 0x2C, 0x05, 0x06, 0xC0, 0x13, 0x01, 0xFB, 0x01, 0x40, 0xDB, 0x0A, 0x0B, 0xB0, 0xC4,
  0x01, 0xFB, 0x01, 0x40, 0x8B, 0x0E, 0xC0, 0x74, 0x01, 0xFB, 0x01, 0x40, 0x3F, 0x90, 0x24, 0x01,
  0xFB, 0x01, 0x50, 0xEE, 0x0D, 0x50, 0x1F, 0xB0, 0x15, 0x0A, 0xE0, 0x95, 0x01, 0xFB, 0x01, 0x50,
  0x5E, 0x04, 0x50, 0x1F, 0xB0, 0x15, 0x01, 0xD0, 0xE6, 0x01, 0xFB, 0x01, 0x60, 0xBC, 0x0A, 0x60,
  0x1F, 0xB0, 0x16, 0x84, 0x24, 0x44, 0x42, 0x60, 0x1F, 0xB0, 0x17, 0x74, 0x01, 0xFB, 0x01, 0x77,
  0x40, 0x1F, 0xB0, 0x17, 0x74, 0x01, 0xFB, 0x01, 0x77, 0x40, 0x1F, 0xB0, 0x17, 0x74, 0x01, 0xFB,
  0x01, 0x77, 0x40, 0x1F, 0xB0, 0x17, 0x74, 0x01, 0xFB, 0x01, 0x77, 0x40, 0x1F, 0xB0, 0x17, 0x74,
  0x01, 0xFB, 0x01, 0x77, 0x40, 0x1D,
  // "N" (U+004E)
  0x0C, 0xE0, 0x87, 0x70, 0x6C, 0x00, 0xCE, 0x0E, 0x77, 0x06, 0xC0, 0x0C, 0xF0, 0x67, 0x60, 0x6C,
  0x00, 0xCF, 0x0D, 0x76, 0x06, 0xC0, 0x0C, 0xF9, 0x04, 0x75, 0x06, 0xC0, 0x0C, 0xF9, 0x0B, 0x75,
  0x06, 0xC0, 0x0C, 0xB0, 0xA0, 0xDC, 0x02, 0x74, 0x06, 0xC0, 0x0C, 0xB0, 0xB0, 0x7C, 0x09, 0x74,
  0x06, 0xC0, 0x0C, 0xB8, 0x1D, 0x1E, 0xB0, 0xE0, 0x17, 0x30, 0x6C, 0x00, 0xCB, 0x81, 0xE0, 0x9C,
  0x07, 0x73, 0x06, 0xC0, 0x0C, 0xC1, 0x02, 0xC0, 0xD7, 0x30, 0x6C, 0x00, 0xCC, 0x81, 0x10, 0xAC,
  0x05, 0x72, 0x06, 0xC0, 0x0C, 0xC8, 0x12, 0x03, 0xC0, 0xB7, 0x20, 0x6C, 0x00, 0xCC, 0x03, 0x20,
  0xCC, 0x03, 0x71, 0x06, 0xC0, 0x0C, 0xC0, 0x32, 0x05, 0xC0, 0x97, 0x10, 0x6C, 0x00, 0xCC, 0x04,
  0x30, 0xDC, 0x01, 0x70, 0x6C, 0x00, 0xCC, 0x04, 0x30, 0x7C, 0x07, 0x70, 0x6C, 0x00, 0xCC, 0x05,
  0x30, 0x10, 0xEB, 0x0E, 0x70, 0x6C, 0x00, 0xCC, 0x06, 0x40, 0x9C, 0x05, 0x60, 0x6C, 0x00, 0xCC,
  0x06, 0x40, 0x2C, 0x0C, 0x60, 0x6C, 0x00, 0xCC, 0x06, 0x50, 0xBC, 0x03, 0x50, 0x6C, 0x00, 0xCC,
  0x06, 0x50, 0x4C, 0x0A, 0x50, 0x6C, 0x00, 0xCC, 0x06, 0x60, 0xCC, 0x01, 0x40, 0x6C, 0x00, 0xCC,
  0x06, 0x60, 0x5C, 0x08, 0x40, 0x6C, 0x00, 0xCC, 0x06, 0x70, 0xEB, 0x0E, 0x40, 0x6C, 0x00, 0xCC,
  0x06, 0x70, 0x7C, 0x06, 0x30, 0x6C, 0x00, 0xCC, 0x06, 0x70, 0x1C, 0x0D, 0x30, 0x6C, 0x00, 0xCC,
  0x06, 0x71, 0x09, 0xC0, 0x42, 0x05, 0xC0, 0x0C, 0xC0, 0x67, 0x10, 0x2C, 0x0B, 0x20, 0x5C, 0x00,
  0xCC, 0x06, 0x72, 0x0B, 0xC8, 0x12, 0x04, 0xC0, 0x0C, 0xC0, 0x67, 0x20, 0x4C, 0x81, 0x90, 0x3C,
  0x00, 0xCC, 0x06, 0x73, 0x0C, 0xB8, 0x1E, 0x13, 0xC0, 0x0C, 0xC0, 0x67, 0x30, 0x6C, 0x07, 0x02,
  0xC0, 0x0C, 0xC0, 0x67, 0x40, 0xEB, 0x0D, 0x01, 0xC0, 0x0C, 0xC0, 0x67, 0x40, 0x7C, 0x05, 0xC0,
  0x0C, 0xC0, 0x67, 0x40, 0x1C, 0x0B, 0x0E, 0xB0, 0x0C, 0xC0, 0x67, 0x50, 0x9F, 0x90, 0x0C, 0xC0,
  0x67, 0x50, 0x2F, 0x90, 0x0C, 0xC0, 0x67, 0x60, 0xBF, 0x00, 0xCC, 0x06, 0x76, 0x04, 0xF0, 0x0C,
  0xC0, 0x67, 0x70, 0xDE, 0x00, 0xCC, 0x06, 0x77, 0x06, 0xE0, 0x0C, 0xC0, 0x67, 0x71, 0x0E, 0xD0,
  0xC0,
  // "O" (U+004F)
  0x75, 0x86, 0x14, 0x67, 0x76, 0x41, 0x77, 0x78, 0x11, 0x8D, 0xF9, 0x81, 0xD8, 0x27, 0x73, 0x08,
  0xFF, 0x08, 0x77, 0x01, 0x0C, 0xFF, 0xA0, 0xD0, 0x17, 0x40, 0x10, 0xDF, 0x90, 0x0E, 0xF9, 0x0D,
  0x02, 0x73, 0x0C, 0xE0, 0x90, 0x34, 0x81, 0x37, 0xED, 0x0C, 0x72, 0x09, 0xD0, 0xC0, 0x17, 0x10,
  0x10, 0xAD, 0x09, 0x70, 0x2D, 0x0C, 0x75, 0x0A, 0xD0, 0x36, 0x0A, 0xC0, 0xE0, 0x17, 0x50, 0x10,
  0xEC, 0x0B, 0x50, 0x2D, 0x07, 0x77, 0x06, 0xD0, 0x24, 0x08, 0xD0, 0x17, 0x70, 0x1D, 0x08, 0x40,
  0xDC, 0x0B, 0x77, 0x20, 0xAC, 0x0D, 0x30, 0x1D, 0x06, 0x77, 0x20, 0x5D, 0x01, 0x20, 0x5D, 0x02,
  0x77, 0x20, 0x1D, 0x05, 0x20, 0x8C, 0x0E, 0x77, 0x40, 0xDC, 0x08, 0x20, 0xBC, 0x0B, 0x77, 0x40,
  0xBC, 0x0B, 0x20, 0xEC, 0x09, 0x77, 0x40, 0x9C, 0x0E, 0x2D, 0x07, 0x77, 0x40, 0x7D, 0x10, 0x1D,
  0x05, 0x77, 0x40, 0x5D, 0x01, 0x03, 0xD0, 0x57, 0x74, 0x05, 0xD0, 0x03, 0xD0, 0x47, 0x74, 0x04,
  0xD0, 0x30, 0x4D, 0x03, 0x77, 0x40, 0x3D, 0x00, 0x4D, 0x03, 0x77, 0x40, 0x3D, 0x00, 0x4D, 0x03,
  0x77, 0x40, 0x3D, 0x04, 0x03, 0xD0, 0x47, 0x74, 0x04, 0xD0, 0x03, 0xD0, 0x57, 0x74, 0x05, 0xD0,
  0x30, 0x1D, 0x05, 0x77, 0x40, 0x5D, 0x01, 0x1D, 0x07, 0x77, 0x40, 0x7D, 0x20, 0xEC, 0x09, 0x77,
  0x40, 0x9C, 0x0D, 0x20, 0xBC, 0x0B, 0x77, 0x40, 0xBC, 0x0B, 0x20, 0x9C, 0x0E, 0x77, 0x40, 0xEC,
  0x08, 0x20, 0x6D, 0x02, 0x77, 0x20, 0x2D, 0x05, 0x20, 0x2D, 0x05, 0x77, 0x20, 0x5D, 0x01, 0x30,
  0xDC, 0x0A, 0x77, 0x20, 0xAC, 0x0C, 0x40, 0x8D, 0x01, 0x77, 0x01, 0xD0, 0x74, 0x02, 0xD0, 0x77,
  0x70, 0x6D, 0x01, 0x50, 0xBC, 0x0E, 0x01, 0x75, 0x01, 0x0E, 0xC0, 0xA6, 0x03, 0xD0, 0xB7, 0x50,
  0xBD, 0x02, 0x70, 0x9D, 0x0B, 0x01, 0x71, 0x01, 0x0B, 0xD0, 0x87, 0x20, 0xDD, 0x81, 0xE8, 0x34,
  0x81, 0x38, 0xED, 0x0C, 0x73, 0x02, 0x0D, 0xF9, 0x00, 0xEF, 0x90, 0xD0, 0x17, 0x40, 0x20, 0xDF,
  0xFA, 0x0C, 0x01, 0x77, 0x09, 0xFF, 0x08, 0x77, 0x38, 0x12, 0x8E, 0xF9, 0x81, 0xD8, 0x17, 0x77,
  0x86, 0x25, 0x67, 0x76, 0x41, 0x75,
  // "P" (U+0050)
  0x04, 0xFE, 0x84, 0xED, 0xC9, 0x62, 0x71, 0x04, 0xFF, 0xD0, 0xD0, 0x66, 0x04, 0xFF, 0xF0, 0xD0,
  0x44, 0x04, 0xFF, 0xFA, 0x05, 0x30, 0x4D, 0x07, 0x80, 0x26, 0x82, 0x78, 0xAD, 0xF9, 0x03, 0x20,
  0x4D, 0x01, 0x73, 0x02, 0x08, 0xE0, 0xD2, 0x04, 0xD0, 0x17, 0x50, 0x20, 0xED, 0x81, 0x60, 0x4D,
  0x01, 0x76, 0x03, 0xD8, 0x1D, 0x04, 0xD0, 0x17, 0x70, 0x9D, 0x02, 0x04, 0xD0, 0x17, 0x70, 0x4D,
  0x06, 0x04, 0xD0, 0x17, 0x71, 0xD0, 0x80, 0x4D, 0x01, 0x77, 0x10, 0xEC, 0x09, 0x04, 0xD0, 0x17,
  0x71, 0x0D, 0xC0, 0xA0, 0x4D, 0x01, 0x77, 0x10, 0xDC, 0x0A, 0x04, 0xD0, 0x17, 0x71, 0x0E, 0xC0,
  0x80, 0x4D, 0x01, 0x77, 0x01, 0xD0, 0x60, 0x4D, 0x01, 0x77, 0x05, 0xD0, 0x30, 0x4D, 0x01, 0x77,
  0x0A, 0xC8, 0x1E, 0x04, 0xD0, 0x17, 0x60, 0x3D, 0x81, 0x80, 0x4D, 0x01, 0x75, 0x02, 0x0E, 0xD8,
  0x12, 0x04, 0xD0, 0x17, 0x40, 0x70, 0xED, 0x08, 0x20, 0x4D, 0x01, 0x68, 0x31, 0x36, 0x9E, 0xE0,
  0xC3, 0x04, 0xFF, 0xF9, 0x0C, 0x01, 0x30, 0x4F, 0xFF, 0x0A, 0x01, 0x40, 0x4F, 0xFD, 0x0D, 0x05,
  0x60, 0x4F, 0xFA, 0x81, 0xD9, 0x47, 0x10, 0x4D, 0x07, 0x80, 0x26, 0x81, 0x54, 0x37, 0x50, 0x4D,
  0x01, 0x77, 0x70, 0x4D, 0x01, 0x77, 0x70, 0x4D, 0x01, 0x77, 0x70, 0x4D, 0x01, 0x77, 0x70, 0x4D,
  0x01, 0x77, 0x70, 0x4D, 0x01, 0x77, 0x70, 0x4D, 0x01, 0x77, 0x70, 0x4D, 0x01, 0x77, 0x70, 0x4D,
  0x01, 0x77, 0x70, 0x4D, 0x01, 0x77, 0x70, 0x4D, 0x01, 0x77, 0x70, 0x4D, 0x01, 0x77, 0x70, 0x4D,
  0x01, 0x77, 0x70, 0x4D, 0x01, 0x77, 0x70, 0x4D, 0x01, 0x77, 0x70, 0x4D, 0x01, 0x77, 0x70,
  // "Q" (U+0051)
  0x75, 0x86, 0x14, 0x67, 0x76, 0x41, 0x77, 0x78, 0x11, 0x8D, 0xF9, 0x81, 0xD8, 0x17, 0x73, 0x08,
  0xFF, 0x08, 0x77, 0x01, 0x0C, 0xFF, 0xA0, 0xD0, 0x17, 0x40, 0x10, 0xDF, 0x90, 0x0E, 0xF9, 0x0D,
  0x02, 0x73, 0x0C, 0xE0, 0x90, 0x34, 0x81, 0x37, 0xED, 0x0C, 0x72, 0x09, 0xD0, 0xC0, 0x17, 0x10,
  0x10, 0xAD, 0x09, 0x70, 0x2D, 0x0C, 0x75, 0x0A, 0xD0, 0x26, 0x0A, 0xC0, 0xE0, 0x17, 0x50, 0x10,
  0xEC, 0x0B, 0x50, 0x2D, 0x07, 0x77, 0x06, 0xD0, 0x24, 0x08, 0xD0, 0x17, 0x70, 0x1D, 0x07, 0x40,
  0xDC, 0x0B, 0x77, 0x20, 0xAC, 0x0D, 0x30, 0x1D, 0x06, 0x77, 0x20, 0x5D, 0x01, 0x20, 0x5D, 0x02,
  0x77, 0x20, 0x1D, 0x05, 0x20, 0x8C, 0x0E, 0x77, 0x40, 0xDC, 0x08, 0x20, 0xBC, 0x0B, 0x77, 0x40,
  0xBC, 0x0B, 0x20, 0xEC, 0x09, 0x77, 0x40, 0x9C, 0x0E, 0x2D, 0x07, 0x77, 0x40, 0x7D, 0x10, 0x1D,
  0x05, 0x77, 0x40, 0x5D, 0x01, 0x03, 0xD0, 0x57, 0x74, 0x05, 0xD0, 0x03, 0xD0, 0x47, 0x74, 0x04,
  0xD0, 0x30, 0x4D, 0x03, 0x77, 0x40, 0x3D, 0x00, 0x4D, 0x03, 0x77, 0x40, 0x3D, 0x00, 0x4D, 0x03,
  0x77, 0x40, 0x3D, 0x04, 0x03, 0xD0, 0x47, 0x74, 0x04, 0xD0, 0x03, 0xD0, 0x57, 0x74, 0x05, 0xD0,
  0x30, 0x1D, 0x05, 0x77, 0x40, 0x5D, 0x01, 0x1D, 0x07, 0x77, 0x40, 0x7D, 0x20, 0xEC, 0x09, 0x77,
  0x40, 0x9C, 0x0E, 0x20, 0xBC, 0x0B, 0x77, 0x40, 0xBC, 0x0B, 0x20, 0x9C, 0x0E, 0x77, 0x40, 0xEC,
  0x09, 0x20, 0x6D, 0x02, 0x77, 0x20, 0x2D, 0x06, 0x20, 0x2D, 0x05, 0x77, 0x20, 0x5D, 0x02, 0x30,
  0xDC, 0x0A, 0x77, 0x20, 0xAC, 0x0D, 0x40, 0x8D, 0x01, 0x77, 0x01, 0xD0, 0x84, 0x02, 0xD0, 0x77,
  0x70, 0x6D, 0x02, 0x50, 0xBC, 0x0E, 0x01, 0x75, 0x01, 0x0E, 0xC0, 0xB6, 0x03, 0xD0, 0xB7, 0x50,
  0xBD, 0x04, 0x70, 0x9D, 0x0B, 0x01, 0x71, 0x01, 0x0B, 0xD0, 0xA7, 0x20, 0xDD, 0x81, 0xE8, 0x34,
  0x81, 0x38, 0xED, 0x0D, 0x01, 0x72, 0x02, 0x0D, 0xF9, 0x00, 0xEF, 0x90, 0xE0, 0x37, 0x40, 0x20,
  0xDF, 0xFA, 0x0E, 0x03, 0x77, 0x09, 0xFF, 0x90, 0x27, 0x72, 0x81, 0x28, 0xEF, 0xD0, 0x67, 0x75,
  0x86, 0x25, 0x67, 0x76, 0x4A, 0xC0, 0xE7, 0x77, 0x50, 0x2D, 0x07, 0x77, 0x75, 0x0A, 0xC0, 0xE0,
  0x17, 0x77, 0x40, 0x3D, 0x08, 0x77, 0x75, 0x0B, 0xC0, 0xE0, 0x17, 0x77, 0x40, 0x3D, 0x09, 0x77,
  0x75, 0x0B, 0xD0, 0x27, 0x77, 0x40, 0x3D, 0x09, 0x77, 0x75, 0x0B, 0xD0, 0x27, 0x77, 0x40, 0x4D,
  0x0A, 0x77, 0x75, 0x0C, 0xD0, 0x31,
  // "R" (U+0052)
  0x04, 0xFB, 0x85, 0xEE, 0xDB, 0x86, 0x27, 0x40, 0x4F, 0xFB, 0x0C, 0x06, 0x72, 0x04, 0xFF, 0xD0,
  0xD0, 0x47, 0x04, 0xFF, 0xF0, 0x76, 0x04, 0xD8, 0x77, 0x66, 0x66, 0x77, 0x9C, 0xF9, 0x06, 0x50,
  0x4D, 0x01, 0x71, 0x81, 0x17, 0xEE, 0x01, 0x40, 0x4D, 0x01, 0x73, 0x01, 0x0C, 0xD0, 0xA4, 0x04,
  0xD0, 0x17, 0x40, 0x10, 0xED, 0x40, 0x4D, 0x01, 0x75, 0x07, 0xD0, 0x43, 0x04, 0xD0, 0x17, 0x50,
  0x2D, 0x08, 0x30, 0x4D, 0x01, 0x76, 0x0E, 0xC0, 0xA3, 0x04, 0xD0, 0x17, 0x60, 0xDC, 0x0B, 0x30,
  0x4D, 0x01, 0x76, 0x0C, 0xC0, 0xB3, 0x04, 0xD0, 0x17, 0x60, 0xDC, 0x0B, 0x30, 0x4D, 0x01, 0x76,
  0x0E, 0xC0, 0x93, 0x04, 0xD0, 0x17, 0x50, 0x2D, 0x06, 0x30, 0x4D, 0x01, 0x75, 0x07, 0xD0, 0x23,
  0x04, 0xD0, 0x17, 0x40, 0x10, 0xEC, 0x0C, 0x40, 0x4D, 0x01, 0x74, 0x0A, 0xD0, 0x44, 0x04, 0xD0,
  0x17, 0x20, 0x20, 0xBD, 0x0A, 0x50, 0x4D, 0x01, 0x58, 0x21, 0x36, 0xBE, 0x0C, 0x01, 0x50, 0x4F,
  0xFE, 0x0C, 0x01, 0x60, 0x4F, 0xFD, 0x08, 0x71, 0x04, 0xFF, 0xB0, 0x90, 0x27, 0x20, 0x4F, 0xFA,
  0x0E, 0x01, 0x73, 0x04, 0xD0, 0x78, 0x02, 0x6D, 0x09, 0x73, 0x04, 0xD0, 0x16, 0x08, 0xD0, 0x37,
  0x20, 0x4D, 0x01, 0x70, 0xEC, 0x0C, 0x72, 0x04, 0xD0, 0x17, 0x05, 0xD0, 0x67, 0x10, 0x4D, 0x01,
  0x71, 0x0C, 0xC0, 0xE0, 0x17, 0x04, 0xD0, 0x17, 0x10, 0x3D, 0x09, 0x70, 0x4D, 0x01, 0x72, 0x09,
  0xD0, 0x36, 0x04, 0xD0, 0x17, 0x20, 0x10, 0xEC, 0x0C, 0x60, 0x4D, 0x01, 0x73, 0x06, 0xD0, 0x65,
  0x04, 0xD0, 0x17, 0x40, 0xCC, 0x0E, 0x01, 0x40, 0x4D, 0x01, 0x74, 0x04, 0xD0, 0x94, 0x04, 0xD0,
  0x17, 0x50, 0xAD, 0x03, 0x30, 0x4D, 0x01, 0x75, 0x01, 0x0E, 0xC0, 0xC3, 0x04, 0xD0, 0x17, 0x60,
  0x7D, 0x06, 0x20, 0x4D, 0x01, 0x77, 0x0D, 0xC8, 0x2E, 0x10, 0x4D, 0x01, 0x77, 0x05, 0xD8, 0x19,
  0x04, 0xD0, 0x17, 0x71, 0x0B, 0xD0, 0x30, 0x4D, 0x01, 0x77, 0x10, 0x2D, 0x0C,
  // "S" (U+0053)
  0x73, 0x89, 0x01, 0x45, 0x67, 0x76, 0x53, 0x17, 0x78, 0x12, 0x8D, 0xFB, 0x82, 0xEA, 0x62, 0x71,
  0x01, 0x0A, 0xFF, 0xB0, 0xC0, 0x65, 0x05, 0x0E, 0xFF, 0xD0, 0x94, 0x05, 0xFB, 0x0E, 0xFB, 0x03,
  0x30, 0x2E, 0x82, 0xE9, 0x41, 0x48, 0x22, 0x58, 0xDB, 0x0D, 0x40, 0xAD, 0x0B, 0x01, 0x74, 0x82,
  0x28, 0xE7, 0x30, 0x2D, 0x0B, 0x77, 0x10, 0x01, 0x30, 0x7D, 0x02, 0x77, 0x60, 0xBC, 0x0D, 0x77,
  0x70, 0xCC, 0x0A, 0x77, 0x70, 0xDC, 0x09, 0x77, 0x70, 0xEC, 0x0A, 0x77, 0x70, 0xDC, 0x0C, 0x77,
  0x70, 0xBD, 0x02, 0x77, 0x60, 0x7D, 0x0B, 0x77, 0x60, 0x2E, 0x0A, 0x77, 0x60, 0xAE, 0x0E, 0x06,
  0x77, 0x40, 0x10, 0xDF, 0x0D, 0x06, 0x77, 0x30, 0x20, 0xEF, 0x98, 0x1E, 0x71, 0x77, 0x10, 0x30,
  0xDF, 0xA8, 0x1E, 0x92, 0x77, 0x10, 0x9F, 0xC0, 0xA0, 0x27, 0x70, 0x20, 0xAF, 0xC0, 0x90, 0x17,
  0x70, 0x30, 0xBF, 0xB0, 0xE0, 0x67, 0x71, 0x03, 0x0A, 0xFB, 0x09, 0x77, 0x28, 0x11, 0x8E, 0xF9,
  0x08, 0x77, 0x38, 0x11, 0x8E, 0xF0, 0x47, 0x74, 0x01, 0x09, 0xE0, 0xC7, 0x76, 0x05, 0xE0, 0x37,
  0x76, 0x08, 0xD0, 0x77, 0x76, 0x01, 0xD0, 0x97, 0x77, 0x0E, 0xC0, 0xA7, 0x77, 0x0C, 0xC0, 0xB7,
  0x77, 0x0D, 0xC0, 0x97, 0x77, 0x0E, 0xC0, 0x87, 0x76, 0x04, 0xD0, 0x57, 0x76, 0x0B, 0xD0, 0x10,
  0x47, 0x74, 0x06, 0xD8, 0x4B, 0x0E, 0xE9, 0x47, 0x70, 0x8E, 0x81, 0x30, 0xEC, 0x82, 0xB8, 0x52,
  0x58, 0x21, 0x48, 0xEE, 0x09, 0x20, 0xEF, 0xB0, 0x0E, 0xFB, 0x0A, 0x30, 0xEF, 0xFF, 0x09, 0x40,
  0x80, 0xEF, 0xFC, 0x0D, 0x04, 0x78, 0x24, 0x8B, 0xEF, 0xC8, 0x1D, 0x93, 0x76, 0x89, 0x11, 0x35,
  0x66, 0x77, 0x65, 0x41, 0x73,
  // "T" (U+0054)
  0x04, 0xFF, 0xFF, 0xA0, 0x04, 0xFF, 0xFF, 0xA0, 0x04, 0xFF, 0xFF, 0xA0, 0x04, 0xFF, 0xFF, 0xA0,
  0x40, 0x18, 0x09, 0x06, 0x0C, 0xC0, 0xC8, 0x09, 0x06, 0x01, 0x76, 0x0A, 0xC0, 0xA7, 0x77, 0x50,
  0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7,
  0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75, 0x0A,
  0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77,
  0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC,
  0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77,
  0x50, 0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0,
  0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75,
  0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A,
  0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50,
  0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7,
  0x77, 0x50, 0xAC, 0x0A, 0x76,
  // "U" (U+0055)
  0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72,
  0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0,
  0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0,
  0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72,
  0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0,
  0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0,
  0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72,
  0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0,
  0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0,
  0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72,
  0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0xC0, 0xBC, 0x09, 0x77, 0x20, 0xAC, 0x00, 0xBC,
  0x0A, 0x77, 0x20, 0xAC, 0x0B, 0x0A, 0xC0, 0xB7, 0x72, 0x0B, 0xC0, 0x90, 0x8C, 0x0E, 0x77, 0x20,
  0xEC, 0x08, 0x05, 0xD0, 0x17, 0x70, 0x1D, 0x05, 0x02, 0xD0, 0x57, 0x70, 0x4D, 0x81, 0x20, 0xEC,
  0x0A, 0x77, 0x09, 0xC0, 0xD2, 0x09, 0xD0, 0x27, 0x50, 0x1D, 0x08, 0x20, 0x3D, 0x0B, 0x75, 0x0B,
  0xD0, 0x23, 0x0B, 0xD0, 0xA7, 0x30, 0xAD, 0x0A, 0x40, 0x2E, 0x81, 0xE7, 0x24, 0x81, 0x27, 0xDD,
  0x0E, 0x01, 0x50, 0x6F, 0xA0, 0x0E, 0xFA, 0x04, 0x70, 0x6F, 0xFB, 0x0E, 0x04, 0x72, 0x03, 0x0D,
  0xFF, 0x0B, 0x02, 0x75, 0x05, 0x0B, 0xFA, 0x81, 0xEA, 0x47, 0x73, 0x86, 0x35, 0x67, 0x76, 0x52,
  0x73,
  // "V" (U+0056)
  0x05, 0xD0, 0x47, 0x76, 0x05, 0xD0, 0x51, 0xD0, 0x97, 0x76, 0x09, 0xD2, 0x0A, 0xC0, 0xD7, 0x76,
  0x0E, 0xC0, 0xB2, 0x05, 0xD0, 0x27, 0x74, 0x03, 0xD0, 0x62, 0x01, 0xD0, 0x77, 0x74, 0x07, 0xD0,
  0x13, 0x0B, 0xC0, 0xC7, 0x74, 0x0C, 0xC0, 0xB4, 0x06, 0xD0, 0x17, 0x72, 0x01, 0xD0, 0x64, 0x01,
  0xD0, 0x57, 0x72, 0x05, 0xD0, 0x25, 0x0C, 0xC0, 0xA7, 0x72, 0x0A, 0xC0, 0xC6, 0x07, 0xC0, 0xE7,
  0x72, 0x0E, 0xC0, 0x76, 0x02, 0xD0, 0x47, 0x70, 0x3D, 0x02, 0x70, 0xCC, 0x08, 0x77, 0x08, 0xC0,
  0xD7, 0x10, 0x7C, 0x0D, 0x77, 0x0C, 0xC0, 0x87, 0x10, 0x2D, 0x02, 0x75, 0x01, 0xD0, 0x37, 0x20,
  0xDC, 0x07, 0x75, 0x06, 0xC0, 0xE7, 0x30, 0x8C, 0x0B, 0x75, 0x0A, 0xC0, 0x97, 0x30, 0x3D, 0x01,
  0x74, 0x0E, 0xC0, 0x47, 0x40, 0xDC, 0x05, 0x73, 0x04, 0xC0, 0xE7, 0x50, 0x8C, 0x0A, 0x73, 0x08,
  0xC0, 0xA7, 0x50, 0x3C, 0x0E, 0x73, 0x0D, 0xC0, 0x57, 0x60, 0xEC, 0x03, 0x71, 0x01, 0xD7, 0x70,
  0x9C, 0x08, 0x71, 0x06, 0xC0, 0xB7, 0x70, 0x4C, 0x0D, 0x71, 0x0A, 0xC0, 0x67, 0x71, 0x0E, 0xC0,
  0x27, 0x0E, 0xC0, 0x17, 0x71, 0x09, 0xC0, 0x66, 0x04, 0xC0, 0xB7, 0x72, 0x05, 0xC0, 0xB6, 0x08,
  0xC0, 0x77, 0x73, 0x0E, 0xC6, 0x0D, 0xC0, 0x27, 0x73, 0x0A, 0xC0, 0x54, 0x02, 0xC0, 0xC7, 0x74,
  0x05, 0xC0, 0x94, 0x06, 0xC0, 0x77, 0x75, 0xC0, 0xE4, 0x0A, 0xC0, 0x37, 0x75, 0x0B, 0xC0, 0x23,
  0x0E, 0xB0, 0xD7, 0x76, 0x06, 0xC0, 0x72, 0x03, 0xC0, 0x87, 0x76, 0x01, 0xC0, 0xB2, 0x07, 0xC0,
  0x37, 0x77, 0x0B, 0xC2, 0x0B, 0xB0, 0xE7, 0x77, 0x10, 0x6C, 0x81, 0x40, 0xEB, 0x09, 0x77, 0x71,
  0x01, 0xC0, 0x80, 0x3C, 0x04, 0x77, 0x72, 0x0C, 0xB0, 0xB0, 0x7B, 0x0E, 0x77, 0x73, 0x07, 0xB0,
  0xE0, 0xBB, 0x0A, 0x77, 0x73, 0x02, 0xF9, 0x05, 0x77, 0x74, 0x0C, 0xF7, 0x77, 0x50, 0x7E, 0x0B,
  0x77, 0x75, 0x02, 0xE0, 0x67, 0x77, 0x60, 0xDD, 0x01, 0x76,
  // "W" (U+0057)
  0x06, 0xC0, 0x87, 0x77, 0x10, 0x8C, 0x06, 0x05, 0xC0, 0x97, 0x77, 0x10, 0x9C, 0x05, 0x03, 0xC0,
  0xB7, 0x77, 0x10, 0xAC, 0x03, 0x01, 0xC0, 0xC7, 0x77, 0x10, 0xCC, 0x02, 0x1C, 0x0E, 0x77, 0x71,
  0x0D, 0xC2, 0x0D, 0xC7, 0x77, 0x10, 0xEB, 0x0E, 0x20, 0xCC, 0x01, 0x77, 0x7C, 0x0D, 0x20, 0xAC,
  0x03, 0x77, 0x60, 0x2C, 0x0B, 0x20, 0x8C, 0x04, 0x77, 0x60, 0x3C, 0x0A, 0x20, 0x6C, 0x06, 0x77,
  0x60, 0x4C, 0x08, 0x20, 0x5C, 0x07, 0x77, 0x60, 0x6C, 0x06, 0x20, 0x3C, 0x09, 0x70, 0x9C, 0x0B,
  0x70, 0x7C, 0x05, 0x20, 0x1C, 0x0A, 0x70, 0xDD, 0x70, 0x8C, 0x03, 0x3C, 0x0B, 0x60, 0x1E, 0x03,
  0x60, 0xAC, 0x02, 0x30, 0xDB, 0x0D, 0x60, 0x5E, 0x07, 0x60, 0xBC, 0x40, 0xCB, 0x0E, 0x60, 0x8E,
  0x0B, 0x60, 0xCB, 0x0E, 0x40, 0xAC, 0x60, 0xCA, 0x0E, 0x0D, 0xA0, 0xE6, 0x0D, 0xB0, 0xD4, 0x08,
  0xC0, 0x25, 0xB0, 0xC0, 0xAB, 0x03, 0x5C, 0x0B, 0x40, 0x6C, 0x03, 0x40, 0x4B, 0x0A, 0x07, 0xB0,
  0x64, 0x01, 0xC0, 0x94, 0x05, 0xC0, 0x54, 0x07, 0xB0, 0x70, 0x3B, 0x0A, 0x40, 0x2C, 0x08, 0x40,
  0x3C, 0x06, 0x40, 0xBB, 0x04, 0x1B, 0x0E, 0x40, 0x3C, 0x06, 0x40, 0x1C, 0x07, 0x40, 0xEB, 0x81,
  0x10, 0xCB, 0x02, 0x30, 0x4C, 0x05, 0x5C, 0x09, 0x30, 0x3B, 0x0D, 0x20, 0x9B, 0x06, 0x30, 0x5C,
  0x03, 0x50, 0xDB, 0x0A, 0x30, 0x6B, 0x09, 0x20, 0x5B, 0x09, 0x30, 0x6C, 0x02, 0x50, 0xBB, 0x0B,
  0x30, 0xAB, 0x06, 0x20, 0x2B, 0x0D, 0x30, 0x7C, 0x60, 0xAB, 0x0C, 0x30, 0xEB, 0x02, 0x30, 0xDB,
  0x02, 0x20, 0x9B, 0x0E, 0x60, 0x8B, 0x0D, 0x20, 0x2B, 0x0E, 0x40, 0xAB, 0x05, 0x20, 0xAB, 0x0D,
  0x60, 0x6C, 0x20, 0x5B, 0x0A, 0x40, 0x6B, 0x09, 0x20, 0xBB, 0x0B, 0x60, 0x5C, 0x20, 0x8B, 0x07,
  0x40, 0x2B, 0x0D, 0x20, 0xCB, 0x09, 0x60, 0x3C, 0x81, 0x10, 0xCB, 0x03, 0x50, 0xEB, 0x81, 0x10,
  0xCB, 0x08, 0x60, 0x1C, 0x02, 0x1B, 0x0E, 0x60, 0xAB, 0x81, 0x40, 0xDB, 0x06, 0x7C, 0x04, 0x03,
  0xB0, 0xB6, 0x06, 0xB8, 0x17, 0x0E, 0xB0, 0x57, 0x0D, 0xB0, 0x50, 0x6B, 0x08, 0x60, 0x3B, 0x0B,
  0x1C, 0x03, 0x70, 0xBB, 0x06, 0x09, 0xB0, 0x47, 0x0E, 0xA0, 0xE0, 0x1C, 0x02, 0x70, 0xAB, 0x06,
  0x0C, 0xB7, 0x10, 0xAB, 0x04, 0xC7, 0x10, 0x8B, 0x08, 0xB0, 0xC7, 0x10, 0x7B, 0x08, 0xB0, 0xE7,
  0x10, 0x6B, 0x0B, 0xB0, 0x97, 0x10, 0x3B, 0x0B, 0xB0, 0xD7, 0x10, 0x4F, 0x05, 0x72, 0x0E, 0xE0,
  0xB7, 0x10, 0x3F, 0x01, 0x72, 0x0B, 0xE0, 0x97, 0x10, 0x1E, 0x0D, 0x73, 0x07, 0xE0, 0x87, 0x2E,
  0x0A, 0x73, 0x03, 0xE0, 0x67, 0x20, 0xDD, 0x06, 0x74, 0xE0, 0x57, 0x20, 0xBD, 0x02, 0x74, 0x0B,
  0xD0, 0x34,
  // "X" (U+0058)
  0x10, 0xAD, 0x01, 0x77, 0x30, 0xEC, 0x0A, 0x20, 0x2D, 0x09, 0x77, 0x20, 0x8D, 0x02, 0x30, 0x8D,
  0x02, 0x77, 0x01, 0xD0, 0x85, 0x0D, 0xC0, 0xB7, 0x70, 0xAC, 0x0D, 0x60, 0x5D, 0x04, 0x75, 0x03,
  0xD0, 0x57, 0x0B, 0xC0, 0xC7, 0x50, 0xBC, 0x0B, 0x71, 0x02, 0xD0, 0x57, 0x30, 0x4D, 0x02, 0x72,
  0x08, 0xC0, 0xD7, 0x30, 0xDC, 0x09, 0x74, 0x0E, 0xC0, 0x77, 0x10, 0x6C, 0x0E, 0x01, 0x74, 0x05,
  0xC0, 0xE0, 0x17, 0x0E, 0xC0, 0x67, 0x60, 0xBC, 0x08, 0x60, 0x8C, 0x0C, 0x77, 0x03, 0xD0, 0x24,
  0x01, 0x0E, 0xC0, 0x37, 0x71, 0x09, 0xC0, 0xA4, 0x09, 0xC0, 0x97, 0x72, 0x01, 0x0E, 0xC0, 0x32,
  0x02, 0xC0, 0xE0, 0x17, 0x73, 0x06, 0xC0, 0xB2, 0x0B, 0xC0, 0x77, 0x75, 0x0C, 0xC0, 0x04, 0xC0,
  0xD7, 0x76, 0x03, 0xC0, 0x0C, 0xC0, 0x47, 0x77, 0x09, 0xF9, 0x0A, 0x77, 0x71, 0x01, 0x0E, 0xF0,
  0x27, 0x77, 0x20, 0x6E, 0x08, 0x77, 0x74, 0x0C, 0xC0, 0xD7, 0x77, 0x50, 0xCC, 0x0C, 0x77, 0x74,
  0x06, 0xE0, 0x67, 0x77, 0x20, 0x10, 0xEE, 0x0E, 0x01, 0x77, 0x71, 0x09, 0xF9, 0x09, 0x77, 0x70,
  0x3C, 0x0E, 0x0D, 0xC0, 0x37, 0x76, 0x0C, 0xC0, 0x60, 0x4C, 0x0D, 0x77, 0x50, 0x7C, 0x0C, 0x20,
  0xBC, 0x07, 0x77, 0x30, 0x10, 0xEC, 0x04, 0x20, 0x2C, 0x0E, 0x01, 0x77, 0x20, 0xAC, 0x0A, 0x40,
  0x8C, 0x0A, 0x77, 0x10, 0x4D, 0x02, 0x50, 0xEC, 0x04, 0x77, 0x0D, 0xC0, 0x86, 0x05, 0xC0, 0xD7,
  0x60, 0x7C, 0x0D, 0x71, 0x0C, 0xC0, 0x77, 0x40, 0x2D, 0x05, 0x71, 0x03, 0xD0, 0x27, 0x30, 0xBC,
  0x0C, 0x73, 0x09, 0xC0, 0xB7, 0x20, 0x5D, 0x03, 0x73, 0x01, 0x0E, 0xC0, 0x57, 0x10, 0xDC, 0x09,
  0x75, 0x07, 0xC0, 0xD7, 0x08, 0xC0, 0xE0, 0x17, 0x60, 0xDC, 0x08, 0x50, 0x2D, 0x07, 0x77, 0x04,
  0xD0, 0x24, 0x0B, 0xC0, 0xD7, 0x72, 0x0B, 0xC0, 0xB3, 0x05, 0xD0, 0x47, 0x72, 0x02, 0xD8, 0x25,
  0x01, 0xEC, 0x0B, 0x77, 0x40, 0x8C, 0x81, 0xE1, 0x9D, 0x02, 0x77, 0x40, 0x10, 0xEC, 0x09,
  // "Y" (U+0059)
  0x0A, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0xA0, 0x2D, 0x0B, 0x77, 0x40, 0x8D, 0x81, 0x20, 0xAD, 0x02,
  0x77, 0x30, 0xEC, 0x0A, 0x20, 0x2D, 0x09, 0x77, 0x20, 0x7D, 0x02, 0x30, 0x9D, 0x01, 0x77, 0x10,
  0xDC, 0x09, 0x40, 0x2D, 0x08, 0x77, 0x05, 0xD0, 0x25, 0x09, 0xC0, 0xE7, 0x70, 0xCC, 0x09, 0x60,
  0x2D, 0x07, 0x75, 0x04, 0xD0, 0x27, 0x09, 0xC0, 0xD7, 0x50, 0xBC, 0x09, 0x71, 0x02, 0xD0, 0x57,
  0x30, 0x3D, 0x02, 0x72, 0x09, 0xC0, 0xC7, 0x30, 0xAC, 0x09, 0x73, 0x02, 0xD0, 0x47, 0x10, 0x2D,
  0x02, 0x74, 0x09, 0xC0, 0xB7, 0x10, 0x9C, 0x09, 0x75, 0x02, 0xD0, 0x36, 0x01, 0x0E, 0xC0, 0x27,
  0x60, 0x9C, 0x0A, 0x60, 0x7C, 0x09, 0x77, 0x01, 0xD0, 0x15, 0x0E, 0xC0, 0x17, 0x71, 0x09, 0xC0,
  0x84, 0x06, 0xC0, 0x97, 0x72, 0x01, 0xC0, 0xE0, 0x13, 0x0D, 0xC0, 0x17, 0x73, 0x09, 0xC0, 0x72,
  0x05, 0xC0, 0x97, 0x74, 0x01, 0xC0, 0xD2, 0x0C, 0xC0, 0x17, 0x75, 0x09, 0xC0, 0x50, 0x3C, 0x09,
  0x77, 0x60, 0x1C, 0x0C, 0x0B, 0xC0, 0x17, 0x77, 0x09, 0xF9, 0x08, 0x77, 0x71, 0x01, 0xF9, 0x01,
  0x77, 0x72, 0x08, 0xE0, 0x87, 0x77, 0x30, 0x1E, 0x01, 0x77, 0x74, 0x09, 0xC0, 0x97, 0x77, 0x50,
  0x9C, 0x09, 0x77, 0x75, 0x09, 0xC0, 0x97, 0x77, 0x50, 0x9C, 0x09, 0x77, 0x75, 0x09, 0xC0, 0x97,
  0x77, 0x50, 0x9C, 0x09, 0x77, 0x75, 0x09, 0xC0, 0x97, 0x77, 0x50, 0x9C, 0x09, 0x77, 0x75, 0x09,
  0xC0, 0x97, 0x77, 0x50, 0x9C, 0x09, 0x77, 0x75, 0x09, 0xC0, 0x97, 0x77, 0x50, 0x9C, 0x09, 0x77,
  0x75, 0x09, 0xC0, 0x97, 0x77, 0x50, 0x9C, 0x09, 0x77, 0x75, 0x09, 0xC0, 0x97, 0x77, 0x50, 0x9C,
  0x09, 0x77, 0x75, 0x09, 0xC0, 0x97, 0x60,
  // "Z" (U+005A)
  0x10, 0x1F, 0xFF, 0xA8, 0x14, 0x01, 0xFF, 0xFA, 0x81, 0x40, 0x1F, 0xFF, 0xA8, 0x14, 0x01, 0xFF,
  0xFA, 0x04, 0x28, 0x09, 0x56, 0x0A, 0xC0, 0xE0, 0x17, 0x75, 0x0D, 0xC0, 0x77, 0x75, 0x06, 0xC0,
  0xE7, 0x76, 0x0E, 0xC0, 0x67, 0x75, 0x08, 0xC0, 0xD7, 0x75, 0x01, 0x0E, 0xC0, 0x47, 0x75, 0x09,
  0xC0, 0xB7, 0x75, 0x02, 0xD0, 0x37, 0x75, 0x0B, 0xC0, 0xA7, 0x75, 0x04, 0xD0, 0x27, 0x75, 0x0C,
  0xC0, 0x97, 0x75, 0x05, 0xC0, 0xE0, 0x17, 0x75, 0x0D, 0xC0, 0x77, 0x75, 0x07, 0xC0, 0xE7, 0x75,
  0x01, 0x0E, 0xC0, 0x67, 0x75, 0x08, 0xC0, 0xD7, 0x75, 0x01, 0xD0, 0x57, 0x75, 0x0A, 0xC0, 0xC7,
  0x75, 0x03, 0xD0, 0x37, 0x75, 0x0B, 0xC0, 0xB7, 0x75, 0x04, 0xD0, 0x27, 0x75, 0x0C, 0xC0, 0x97,
  0x75, 0x05, 0xD0, 0x17, 0x75, 0x0D, 0xC0, 0x87, 0x75, 0x07, 0xC0, 0xE0, 0x17, 0x74, 0x01, 0x0E,
  0xC0, 0x77, 0x75, 0x08, 0xC0, 0xD7, 0x75, 0x02, 0xD0, 0x57, 0x75, 0x0A, 0xC0, 0xC7, 0x75, 0x03,
  0xD0, 0x47, 0x75, 0x0B, 0xC0, 0xB7, 0x75, 0x04, 0xD0, 0x37, 0x75, 0x0D, 0xC0, 0xA7, 0x75, 0x06,
  0xD0, 0x27, 0x75, 0x0E, 0xC0, 0xC8, 0x09, 0x66, 0x01, 0x04, 0xFF, 0xFB, 0x00, 0x4F, 0xFF, 0xB0,
  0x04, 0xFF, 0xFB, 0x00, 0x4F, 0xFF, 0xB0, 0x40,
  // "[" (U+005B)
  0x09, 0xFD, 0x0E, 0x09, 0xFD, 0x0E, 0x09, 0xFD, 0x0E, 0x09, 0xFD, 0x0E, 0x09, 0xC0, 0xB8, 0x03,
  0x60, 0x50, 0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87, 0x10,
  0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08,
  0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71, 0x09,
  0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87,
  0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C,
  0x08, 0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71,
  0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0,
  0x87, 0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87, 0x10,
  0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08,
  0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0, 0xB8, 0x03, 0x60, 0x50, 0x9F, 0xD0,
  0xE0, 0x9F, 0xD0, 0xE0, 0x9F, 0xD0, 0xE0, 0x9F, 0xD0, 0xE0,
  // "\" (U+005C)
  0x09, 0xC0, 0x87, 0x72, 0x03, 0xC0, 0xE7, 0x73, 0x0D, 0xC0, 0x47, 0x72, 0x07, 0xC0, 0xA7, 0x72,
  0x01, 0xD0, 0x17, 0x72, 0x0A, 0xC0, 0x77, 0x72, 0x04, 0xC0, 0xD7, 0x73, 0x0E, 0xC0, 0x37, 0x72,
  0x08, 0xC0, 0x97, 0x72, 0x02, 0xC0, 0xE7, 0x73, 0x0C, 0xC0, 0x57, 0x72, 0x06, 0xC0, 0xB7, 0x73,
  0x0E, 0xC0, 0x27, 0x72, 0x09, 0xC0, 0x87, 0x72, 0x03, 0xC0, 0xD7, 0x73, 0x0D, 0xC0, 0x47, 0x72,
  0x07, 0xC0, 0xA7, 0x72, 0x01, 0xD0, 0x17, 0x72, 0x0B, 0xC0, 0x67, 0x72, 0x05, 0xC0, 0xC7, 0x73,
  0x0E, 0xC0, 0x37, 0x72, 0x09, 0xC0, 0x87, 0x72, 0x03, 0xC0, 0xE7, 0x73, 0x0C, 0xC0, 0x57, 0x72,
  0x06, 0xC0, 0xB7, 0x72, 0x01, 0xD0, 0x17, 0x72, 0x0A, 0xC0, 0x77, 0x72, 0x04, 0xC0, 0xD7, 0x73,
  0x0D, 0xC0, 0x37, 0x72, 0x08, 0xC0, 0x97, 0x72, 0x02, 0xC0, 0xE7, 0x73, 0x0B, 0xC0, 0x67, 0x72,
  0x05, 0xC0, 0xC7, 0x73, 0x0E, 0xC0, 0x27, 0x72, 0x09, 0xC0, 0x87, 0x72, 0x03, 0xC0, 0xE7, 0x73,
  0x0D, 0xC0, 0x47, 0x72, 0x07, 0xC0, 0xA7, 0x72, 0x01, 0xD0, 0x17, 0x72, 0x0A, 0xC0, 0x77, 0x72,
  0x04, 0xC0, 0xD7, 0x73, 0x0E, 0xC0, 0x37, 0x72, 0x08, 0xC0, 0x90,
  // "]" (U+005D)
  0x0E, 0xFD, 0x09, 0x0E, 0xFD, 0x09, 0x0E, 0xFD, 0x09, 0x0E, 0xFD, 0x09, 0x05, 0x80, 0x36, 0x0B,
  0xC0, 0x97, 0x10, 0x8C, 0x09, 0x71, 0x08, 0xC0, 0x97, 0x10, 0x8C, 0x09, 0x71, 0x08, 0xC0, 0x97,
  0x10, 0x8C, 0x09, 0x71, 0x08, 0xC0, 0x97, 0x10, 0x8C, 0x09, 0x71, 0x08, 0xC0, 0x97, 0x10, 0x8C,
  0x09, 0x71, 0x08, 0xC0, 0x97, 0x10, 0x8C, 0x09, 0x71, 0x08, 0xC0, 0x97, 0x10, 0x8C, 0x09, 0x71,
  0x08, 0xC0, 0x97, 0x10, 0x8C, 0x09, 0x71, 0x08, 0xC0, 0x97, 0x10, 0x8C, 0x09, 0x71, 0x08, 0xC0,
  0x97, 0x10, 0x8C, 0x09, 0x71, 0x08, 0xC0, 0x97, 0x10, 0x8C, 0x09, 0x71, 0x08, 0xC0, 0x97, 0x10,
  0x8C, 0x09, 0x71, 0x08, 0xC0, 0x97, 0x10, 0x8C, 0x09, 0x71, 0x08, 0xC0, 0x97, 0x10, 0x8C, 0x09,
  0x71, 0x08, 0xC0, 0x97, 0x10, 0x8C, 0x09, 0x71, 0x08, 0xC0, 0x97, 0x10, 0x8C, 0x09, 0x71, 0x08,
  0xC0, 0x97, 0x10, 0x8C, 0x09, 0x71, 0x08, 0xC0, 0x97, 0x10, 0x8C, 0x09, 0x71, 0x08, 0xC0, 0x97,
  0x10, 0x8C, 0x09, 0x71, 0x08, 0xC0, 0x97, 0x10, 0x8C, 0x09, 0x71, 0x08, 0xC0, 0x97, 0x10, 0x8C,
  0x09, 0x71, 0x08, 0xC0, 0x97, 0x10, 0x8C, 0x09, 0x05, 0x80, 0x36, 0x0B, 0xC0, 0x90, 0xEF, 0xD0,
  0x90, 0xEF, 0xD0, 0x90, 0xEF, 0xD0, 0x90, 0xEF, 0xD0, 0x90,
  // "^" (U+005E)
  0x75, 0x02, 0x0F, 0x77, 0x77, 0x50, 0x9B, 0x05, 0x77, 0x73, 0x01, 0xC0, 0xD7, 0x77, 0x30, 0x8D,
  0x06, 0x77, 0x71, 0x01, 0x0E, 0xD0, 0xD7, 0x77, 0x10, 0x7F, 0x06, 0x77, 0x70, 0xEB, 0x0B, 0xB0,
  0xD7, 0x76, 0x06, 0xB8, 0x1D, 0x1E, 0xB0, 0x67, 0x75, 0x0D, 0xB8, 0x16, 0x07, 0xB0, 0xE7, 0x74,
  0x05, 0xB0, 0xE3, 0x0E, 0xB0, 0x77, 0x73, 0x0C, 0xB0, 0x83, 0x07, 0xB0, 0xE7, 0x72, 0x04, 0xC0,
  0x14, 0x0E, 0xB0, 0x77, 0x71, 0x0B, 0xB0, 0x95, 0x07, 0xB0, 0xE0, 0x17, 0x60, 0x3C, 0x02, 0x60,
  0xEB, 0x08, 0x76, 0x0A, 0xB0, 0xB7, 0x07, 0xB0, 0xE0, 0x17, 0x40, 0x2C, 0x04, 0x71, 0x0E, 0xB0,
  0x87, 0x40, 0x9B, 0x0C, 0x72, 0x07, 0xC0, 0x17, 0x20, 0x1C, 0x06, 0x73, 0x0E, 0xB0, 0x97, 0x20,
  0x8B, 0x0E, 0x74, 0x07, 0xC0, 0x27, 0x01, 0x0E, 0xB0, 0x77, 0x50, 0xEB, 0x09, 0x70, 0x7B, 0x0E,
  0x01, 0x75, 0x07, 0xC0, 0x26, 0x0E, 0xB0, 0x97, 0x70, 0xEB, 0x0A, 0x50, 0x6C, 0x02, 0x77, 0x07,
  0xC0, 0x24, 0x0D, 0xB0, 0xA7, 0x72, 0x0E, 0xB0, 0xA3, 0x05, 0xC0, 0x37, 0x72, 0x06, 0xC0, 0x32,
  0x0C, 0xB0, 0xC7, 0x74, 0x0E, 0xB8, 0x1B, 0x04, 0xC0, 0x57, 0x74, 0x06, 0xC0, 0x30, 0xBB, 0x0D,
  0x77, 0x60, 0xEB, 0x0B,
  // "_" (U+005F)
  0x80, 0xC0, 0x68, 0x0A, 0x94, 0xF0,
  // "`" (U+0060)
  0x05, 0x80, 0x17, 0x05, 0x60, 0x6E, 0x02, 0x60, 0xAD, 0x0B, 0x70, 0xCD, 0x05, 0x60, 0x10, 0xDC,
  0x0E, 0x01, 0x60, 0x20, 0xDC, 0x09, 0x70, 0x20, 0xDC, 0x04, 0x70, 0x20, 0xDB, 0x0E, 0x01, 0x70,
  0x10, 0xCB, 0x0B, 0x72, 0x0A, 0xB0, 0x50,
  // "a" (U+0061)
  0x72, 0x87, 0x13, 0x56, 0x77, 0x65, 0x37, 0x71, 0x81, 0x49, 0xDF, 0xB0, 0xB0, 0x57, 0x28, 0x11,
  0x8E, 0xFF, 0x90, 0xE0, 0x56, 0x04, 0xFF, 0xE0, 0x86, 0x0E, 0xFA, 0x00, 0xEF, 0xA0, 0x75, 0x07,
  0xB8, 0x2D, 0x95, 0x25, 0x81, 0x27, 0xCE, 0x02, 0x58, 0x1E, 0xA3, 0x75, 0x06, 0xD0, 0xA7, 0x77,
  0x06, 0xD7, 0x77, 0x10, 0xDC, 0x04, 0x77, 0x70, 0x8C, 0x06, 0x77, 0x70, 0x6C, 0x07, 0x77, 0x70,
  0x5C, 0x08, 0x77, 0x70, 0x4C, 0x09, 0x71, 0x84, 0x47, 0xAC, 0xDE, 0xFD, 0x09, 0x58, 0x13, 0xAE,
  0xFF, 0xC0, 0x93, 0x01, 0x09, 0xFF, 0xF0, 0x92, 0x01, 0x0D, 0xFF, 0xF9, 0x09, 0x20, 0xDF, 0x83,
  0xEB, 0x97, 0x78, 0x02, 0x60, 0x9C, 0x81, 0x90, 0x8E, 0x0A, 0x04, 0x74, 0x04, 0xC0, 0x91, 0xD0,
  0xE0, 0x47, 0x60, 0x4C, 0x09, 0x05, 0xD0, 0x57, 0x70, 0x5C, 0x00, 0x9C, 0x0B, 0x77, 0x10, 0x6C,
  0x09, 0x0A, 0xC0, 0x77, 0x71, 0x08, 0xC0, 0x90, 0xBC, 0x05, 0x77, 0x10, 0xDC, 0x09, 0x0B, 0xC0,
  0x57, 0x70, 0x4D, 0x09, 0x0A, 0xC0, 0x77, 0x60, 0x10, 0xDD, 0x09, 0x07, 0xC0, 0xD7, 0x50, 0x10,
  0xDE, 0x09, 0x03, 0xD0, 0x97, 0x30, 0x50, 0xEF, 0x81, 0x90, 0xCD, 0x81, 0xD6, 0x23, 0x82, 0x13,
  0x8D, 0xC0, 0xAC, 0x81, 0x90, 0x4F, 0xA0, 0xEF, 0x90, 0x70, 0x2C, 0x09, 0x20, 0x6F, 0xFA, 0x07,
  0x2C, 0x09, 0x30, 0x50, 0xEF, 0xD0, 0xD0, 0x33, 0x0E, 0xB0, 0x94, 0x81, 0x17, 0xDF, 0x90, 0xC0,
  0x65, 0x0C, 0xB0, 0x97, 0x86, 0x15, 0x67, 0x76, 0x41, 0x75,
  // "b" (U+0062)
  0x03, 0xD7, 0x77, 0x20, 0x3D, 0x77, 0x72, 0x03, 0xD7, 0x77, 0x20, 0x3D, 0x77, 0x72, 0x03, 0xD7,
  0x77, 0x20, 0x3D, 0x77, 0x72, 0x03, 0xD7, 0x77, 0x20, 0x3D, 0x77, 0x72, 0x03, 0xD7, 0x77, 0x20,
  0x3D, 0x77, 0x72, 0x03, 0xD7, 0x77, 0x20, 0x3D, 0x77, 0x72, 0x03, 0xD7, 0x77, 0x20, 0x3D, 0x68,
  0x51, 0x46, 0x77, 0x53, 0x73, 0x03, 0xD4, 0x06, 0x0C, 0xF8, 0x1E, 0xA3, 0x70, 0x3C, 0x0E, 0x20,
  0x20, 0xCF, 0xD0, 0x96, 0x03, 0xC8, 0x2D, 0x04, 0xEF, 0xF0, 0xD0, 0x14, 0x03, 0xC0, 0xD0, 0x3F,
  0x0E, 0xFA, 0x0D, 0x01, 0x30, 0x3C, 0x00, 0xDB, 0x81, 0xE7, 0x23, 0x81, 0x15, 0xBE, 0x0A, 0x30,
  0x3F, 0x90, 0xA0, 0x17, 0x10, 0x50, 0xED, 0x05, 0x20, 0x3F, 0x0B, 0x74, 0x05, 0xD0, 0xD2, 0x03,
  0xE0, 0xE7, 0x60, 0x9D, 0x81, 0x40, 0x3E, 0x06, 0x76, 0x01, 0xD8, 0x1A, 0x03, 0xD0, 0xE7, 0x71,
  0x0B, 0xC8, 0x1E, 0x03, 0xD0, 0xA7, 0x71, 0x06, 0xD0, 0x20, 0x3D, 0x06, 0x77, 0x10, 0x3D, 0x05,
  0x03, 0xD0, 0x47, 0x72, 0xD0, 0x70, 0x3D, 0x02, 0x77, 0x20, 0xEC, 0x08, 0x03, 0xD0, 0x17, 0x72,
  0x0D, 0xC0, 0x90, 0x3D, 0x77, 0x30, 0xCC, 0x0A, 0x03, 0xD7, 0x73, 0x0D, 0xC0, 0xA0, 0x3D, 0x01,
  0x77, 0x20, 0xDC, 0x09, 0x03, 0xD0, 0x27, 0x72, 0x0E, 0xC0, 0x80, 0x3D, 0x04, 0x77, 0x10, 0x1D,
  0x07, 0x03, 0xD0, 0x77, 0x71, 0x03, 0xD0, 0x50, 0x3D, 0x0A, 0x77, 0x10, 0x6D, 0x01, 0x03, 0xD0,
  0xE7, 0x71, 0x0B, 0xC8, 0x1E, 0x03, 0xE0, 0x57, 0x60, 0x1D, 0x81, 0xA0, 0x3E, 0x0D, 0x76, 0x09,
  0xD8, 0x13, 0x03, 0xF0, 0x97, 0x40, 0x5D, 0x0D, 0x20, 0x3F, 0x90, 0x97, 0x20, 0x50, 0xED, 0x04,
  0x20, 0x3C, 0x0E, 0xC8, 0x1D, 0x72, 0x38, 0x11, 0x5B, 0xE0, 0x93, 0x03, 0xC0, 0x07, 0xF0, 0xEF,
  0xA0, 0xD0, 0x13, 0x03, 0xC8, 0x16, 0x07, 0xFF, 0x90, 0xC0, 0x14, 0x03, 0xC0, 0x42, 0x04, 0x0D,
  0xFD, 0x09, 0x60, 0x3C, 0x02, 0x40, 0x60, 0xDF, 0x81, 0xE9, 0x27, 0x75, 0x85, 0x25, 0x67, 0x75,
  0x37, 0x30,
  // "c" (U+0063)
  0x74, 0x87, 0x13, 0x56, 0x77, 0x65, 0x37, 0x78, 0x12, 0x8C, 0xFB, 0x81, 0xC7, 0x27, 0x10, 0x30,
  0xBF, 0xFA, 0x0B, 0x01, 0x50, 0x7F, 0xFC, 0x0E, 0x50, 0xAF, 0xB0, 0x0E, 0xF0, 0x94, 0x08, 0xF8,
  0x19, 0x51, 0x48, 0x22, 0x59, 0xEA, 0x04, 0x30, 0x4E, 0x0A, 0x01, 0x74, 0x07, 0x0D, 0x40, 0xDD,
  0x08, 0x77, 0x40, 0x5D, 0x0B, 0x77, 0x50, 0xCD, 0x02, 0x77, 0x40, 0x1D, 0x0A, 0x77, 0x50, 0x5D,
  0x05, 0x77, 0x50, 0x8D, 0x01, 0x77, 0x50, 0xAC, 0x0E, 0x77, 0x60, 0xCC, 0x0B, 0x77, 0x60, 0xCC,
  0x0B, 0x77, 0x60, 0xDC, 0x0A, 0x77, 0x60, 0xDC, 0x0A, 0x77, 0x60, 0xDC, 0x0A, 0x77, 0x60, 0xCC,
  0x0B, 0x77, 0x60, 0xBC, 0x0D, 0x77, 0x60, 0x9D, 0x77, 0x60, 0x6D, 0x03, 0x77, 0x50, 0x3D, 0x09,
  0x77, 0x60, 0xEC, 0x0E, 0x77, 0x60, 0x8D, 0x09, 0x77, 0x50, 0x2E, 0x06, 0x77, 0x50, 0x9E, 0x09,
  0x01, 0x75, 0x04, 0x09, 0x40, 0xDE, 0x82, 0xE9, 0x51, 0x48, 0x51, 0x36, 0xAE, 0xFE, 0x40, 0x10,
  0xDF, 0xB0, 0x0E, 0xF0, 0xE5, 0x01, 0x0A, 0xFF, 0xC0, 0xE7, 0x06, 0x0D, 0xFF, 0xA0, 0xD7, 0x28,
  0x15, 0xAE, 0xFB, 0x81, 0xC9, 0x47, 0x68, 0x72, 0x45, 0x67, 0x66, 0x42, 0x60,
  // "d" (U+0064)
  0x77, 0x71, 0x02, 0xD0, 0x37, 0x77, 0x10, 0x2D, 0x03, 0x77, 0x71, 0x02, 0xD0, 0x37, 0x77, 0x10,
  0x2D, 0x03, 0x77, 0x71, 0x02, 0xD0, 0x37, 0x77, 0x10, 0x2D, 0x03, 0x77, 0x71, 0x02, 0xD0, 0x37,
  0x77, 0x10, 0x2D, 0x03, 0x77, 0x71, 0x02, 0xD0, 0x37, 0x77, 0x10, 0x2D, 0x03, 0x77, 0x71, 0x02,
  0xD0, 0x37, 0x77, 0x10, 0x2D, 0x03, 0x77, 0x71, 0x02, 0xD0, 0x37, 0x38, 0x52, 0x56, 0x77, 0x64,
  0x50, 0x2D, 0x03, 0x78, 0x13, 0x9E, 0xF9, 0x0A, 0x02, 0x20, 0x1D, 0x03, 0x50, 0x10, 0xAF, 0xE8,
  0x16, 0x01, 0xD0, 0x34, 0x03, 0x0E, 0xFF, 0x90, 0x71, 0xD0, 0x33, 0x02, 0x0E, 0xFA, 0x0E, 0xF0,
  0x40, 0xDC, 0x03, 0x30, 0xCE, 0x81, 0xD7, 0x23, 0x81, 0x15, 0xCB, 0x0D, 0x0E, 0xC0, 0x32, 0x07,
  0xE0, 0x97, 0x20, 0x8F, 0x90, 0x32, 0x0E, 0xD0, 0x97, 0x40, 0x9F, 0x81, 0x30, 0x5D, 0x0C, 0x76,
  0x0D, 0xE8, 0x13, 0x0B, 0xD0, 0x37, 0x60, 0x6E, 0x03, 0x1D, 0x0D, 0x77, 0x01, 0xE0, 0x30, 0x2D,
  0x07, 0x77, 0x10, 0xCD, 0x03, 0x05, 0xD0, 0x47, 0x71, 0x09, 0xD0, 0x30, 0x8D, 0x01, 0x77, 0x10,
  0x6D, 0x03, 0x08, 0xC0, 0xE7, 0x72, 0x04, 0xD0, 0x30, 0x9C, 0x0E, 0x77, 0x20, 0x3D, 0x03, 0x0A,
  0xC0, 0xD7, 0x72, 0x02, 0xD0, 0x30, 0xAC, 0x0C, 0x77, 0x20, 0x2D, 0x03, 0x0A, 0xC0, 0xD7, 0x72,
  0x02, 0xD0, 0x30, 0x9C, 0x0E, 0x77, 0x20, 0x3D, 0x03, 0x07, 0xD7, 0x72, 0x04, 0xD0, 0x30, 0x5D,
  0x02, 0x77, 0x10, 0x6D, 0x00, 0x3D, 0x05, 0x77, 0x10, 0x9D, 0x81, 0x30, 0xEC, 0x0A, 0x77, 0x10,
  0xED, 0x81, 0x30, 0xAD, 0x01, 0x76, 0x04, 0xE8, 0x13, 0x05, 0xD0, 0x97, 0x60, 0xCE, 0x03, 0x20,
  0xED, 0x04, 0x74, 0x08, 0xF0, 0x32, 0x06, 0xE0, 0x57, 0x20, 0x7F, 0x90, 0x33, 0x0B, 0xE8, 0x1B,
  0x51, 0x38, 0x11, 0x6C, 0xB0, 0xD0, 0xEC, 0x03, 0x30, 0x10, 0xDF, 0xA0, 0xEF, 0x03, 0x0B, 0xC0,
  0x34, 0x02, 0x0D, 0xFF, 0x98, 0x15, 0x09, 0xC0, 0x36, 0x09, 0xFD, 0x0E, 0x03, 0x20, 0x6C, 0x03,
  0x78, 0x12, 0x9E, 0xF8, 0x1E, 0x81, 0x30, 0x4C, 0x03, 0x73, 0x85, 0x35, 0x77, 0x75, 0x37, 0x50,
  // "e" (U+0065)
  0x75, 0x86, 0x25, 0x67, 0x65, 0x41, 0x77, 0x58, 0x14, 0xAE, 0xF9, 0x0B, 0x06, 0x77, 0x10, 0x40,
  0xCF, 0xE0, 0xD0, 0x57, 0x50, 0x9F, 0xFB, 0x09, 0x73, 0x0B, 0xFA, 0x00, 0xEF, 0x90, 0xA7, 0x10,
  0xAE, 0x81, 0xC6, 0x24, 0x04, 0x09, 0xE0, 0x76, 0x06, 0xD0, 0xE0, 0x57, 0x20, 0x30, 0xDD, 0x03,
  0x40, 0x10, 0xEC, 0x0E, 0x02, 0x74, 0x02, 0x0E, 0xC0, 0xA4, 0x09, 0xD0, 0x47, 0x60, 0x5D, 0x02,
  0x20, 0x1D, 0x09, 0x77, 0x10, 0xDC, 0x08, 0x20, 0x6D, 0x01, 0x77, 0x10, 0x8C, 0x0B, 0x20, 0xBC,
  0x0B, 0x77, 0x20, 0x4D, 0x20, 0xEC, 0x06, 0x77, 0x20, 0x1D, 0x02, 0x01, 0xD0, 0x88, 0x09, 0x56,
  0xD0, 0x04, 0xFF, 0xFF, 0x00, 0x5F, 0xFF, 0xF0, 0x60, 0x5F, 0xFF, 0xF0, 0x06, 0xFF, 0xFF, 0x06,
  0x05, 0xD0, 0x17, 0x77, 0x20, 0x4D, 0x02, 0x77, 0x72, 0x02, 0xD0, 0x47, 0x77, 0x3D, 0x07, 0x77,
  0x73, 0x0C, 0xC0, 0xB7, 0x77, 0x30, 0x7D, 0x02, 0x77, 0x72, 0x02, 0xD0, 0x97, 0x77, 0x30, 0xAD,
  0x04, 0x77, 0x72, 0x02, 0xD0, 0xE0, 0x47, 0x73, 0x04, 0x50, 0x7E, 0x08, 0x01, 0x75, 0x82, 0x27,
  0xDE, 0x60, 0xAE, 0x82, 0xEA, 0x52, 0x58, 0x22, 0x58, 0xCB, 0x0E, 0x70, 0xAF, 0xB0, 0x0E, 0xFA,
  0x0E, 0x71, 0x07, 0xFF, 0xE0, 0xE7, 0x20, 0x20, 0xAF, 0xFB, 0x0C, 0x06, 0x74, 0x81, 0x17, 0xCF,
  0xB8, 0x2E, 0xA7, 0x27, 0x73, 0x87, 0x35, 0x67, 0x76, 0x54, 0x17, 0x10,
  // "f" (U+0066)
  0x77, 0x28, 0x93, 0x26, 0xAC, 0xDE, 0xFE, 0xEC, 0xA7, 0x37, 0x72, 0x04, 0x0C, 0xFE, 0x0E, 0x01,
  0x76, 0x09, 0xFF, 0x90, 0xD7, 0x60, 0x9F, 0xFA, 0x08, 0x75, 0x04, 0xF8, 0x6C, 0x97, 0x67, 0x8A,
  0xCA, 0x04, 0x75, 0x0B, 0xD0, 0xC0, 0x37, 0x20, 0x47, 0x50, 0x1D, 0x0D, 0x01, 0x77, 0x72, 0x04,
  0xD0, 0x67, 0x77, 0x30, 0x7D, 0x01, 0x77, 0x73, 0x07, 0xC0, 0xE7, 0x77, 0x40, 0x8C, 0x0D, 0x77,
  0x74, 0x08, 0xC0, 0xD7, 0x77, 0x40, 0x8C, 0x0D, 0x77, 0x74, 0x08, 0xC0, 0xD7, 0x71, 0x89, 0x04,
  0x56, 0x78, 0x9B, 0xCD, 0xEF, 0xFC, 0x3F, 0xFF, 0xF3, 0xFF, 0xFF, 0x3F, 0xFF, 0xF3, 0x80, 0x66,
  0x0B, 0xC0, 0xE8, 0x09, 0x06, 0x76, 0x08, 0xC0, 0xD7, 0x77, 0x40, 0x8C, 0x0D, 0x77, 0x74, 0x08,
  0xC0, 0xD7, 0x77, 0x40, 0x8C, 0x0D, 0x77, 0x74, 0x08, 0xC0, 0xD7, 0x77, 0x40, 0x8C, 0x0D, 0x77,
  0x74, 0x08, 0xC0, 0xD7, 0x77, 0x40, 0x8C, 0x0D, 0x77, 0x74, 0x08, 0xC0, 0xD7, 0x77, 0x40, 0x8C,
  0x0D, 0x77, 0x74, 0x08, 0xC0, 0xD7, 0x77, 0x40, 0x8C, 0x0D, 0x77, 0x74, 0x08, 0xC0, 0xD7, 0x77,
  0x40, 0x8C, 0x0D, 0x77, 0x74, 0x08, 0xC0, 0xD7, 0x77, 0x40, 0x8C, 0x0D, 0x77, 0x74, 0x08, 0xC0,
  0xD7, 0x77, 0x40, 0x8C, 0x0D, 0x77, 0x74, 0x08, 0xC0, 0xD7, 0x77, 0x40, 0x8C, 0x0D, 0x77, 0x74,
  0x08, 0xC0, 0xD7, 0x77, 0x40, 0x8C, 0x0D, 0x77, 0x74, 0x08, 0xC0, 0xD7, 0x77, 0x40, 0x8C, 0x0D,
  0x77, 0x74, 0x08, 0xC0, 0xD7, 0x77, 0x40, 0x8C, 0x0D, 0x77, 0x74, 0x08, 0xC0, 0xD7, 0x71,
  // "g" (U+0067)
  0x73, 0x85, 0x35, 0x77, 0x75, 0x37, 0x75, 0x81, 0x29, 0xEF, 0x81, 0xE8, 0x13, 0x03, 0xC0, 0x36,
  0x08, 0xFD, 0x0E, 0x05, 0x20, 0x5C, 0x03, 0x40, 0x10, 0xBF, 0xF9, 0x81, 0x60, 0x8C, 0x03, 0x40,
  0xBF, 0xA0, 0xEF, 0x04, 0x0B, 0xC0, 0x33, 0x08, 0xE8, 0x1C, 0x61, 0x38, 0x11, 0x6C, 0xB0, 0x0E,
  0xC0, 0x32, 0x02, 0xE0, 0x67, 0x20, 0x5F, 0x90, 0x32, 0x0B, 0xD0, 0x67, 0x40, 0x4F, 0x81, 0x30,
  0x2D, 0x0A, 0x76, 0x08, 0xE8, 0x13, 0x08, 0xD0, 0x27, 0x70, 0xED, 0x81, 0x30, 0xDC, 0x0B, 0x77,
  0x10, 0x9D, 0x03, 0x01, 0xD0, 0x77, 0x71, 0x04, 0xD0, 0x30, 0x4D, 0x03, 0x77, 0x10, 0x1D, 0x03,
  0x07, 0xD0, 0x17, 0x72, 0x0D, 0xC0, 0x30, 0x8C, 0x0E, 0x77, 0x30, 0xCC, 0x03, 0x09, 0xC0, 0xD7,
  0x73, 0x0B, 0xC0, 0x30, 0xAC, 0x0D, 0x77, 0x30, 0xAC, 0x03, 0x0A, 0xC0, 0xC7, 0x73, 0x0A, 0xC0,
  0x30, 0x9C, 0x0D, 0x77, 0x30, 0xAC, 0x03, 0x08, 0xC0, 0xE7, 0x73, 0x0B, 0xC0, 0x30, 0x7D, 0x01,
  0x77, 0x20, 0xCC, 0x03, 0x05, 0xD0, 0x37, 0x72, 0x0E, 0xC0, 0x30, 0x2D, 0x07, 0x77, 0x10, 0x1D,
  0x81, 0x30, 0xEC, 0x0C, 0x77, 0x10, 0x5D, 0x81, 0x30, 0x9D, 0x02, 0x77, 0x0B, 0xD8, 0x13, 0x03,
  0xD0, 0xB7, 0x60, 0x3E, 0x03, 0x20, 0xDD, 0x07, 0x74, 0x01, 0x0D, 0xE0, 0x32, 0x04, 0xE0, 0x77,
  0x20, 0x30, 0xDF, 0x03, 0x30, 0x9E, 0x81, 0xD7, 0x23, 0x81, 0x14, 0xAF, 0xA0, 0x33, 0x01, 0x0C,
  0xFA, 0x0E, 0xF0, 0xC0, 0xBC, 0x03, 0x40, 0x10, 0xCF, 0xF9, 0x81, 0xD2, 0xBC, 0x03, 0x60, 0x8F,
  0xE8, 0x2C, 0x20, 0xCC, 0x03, 0x78, 0x12, 0x9E, 0xF9, 0x0B, 0x06, 0x30, 0xDC, 0x03, 0x73, 0x85,
  0x25, 0x67, 0x65, 0x46, 0x0D, 0xC0, 0x27, 0x77, 0x20, 0xEC, 0x01, 0x77, 0x72, 0xD7, 0x77, 0x20,
  0x3D, 0x77, 0x72, 0x07, 0xC0, 0xB7, 0x77, 0x20, 0xDC, 0x08, 0x77, 0x71, 0x08, 0xD0, 0x33, 0x0B,
  0x04, 0x77, 0x20, 0x6D, 0x0B, 0x4A, 0x81, 0xD8, 0x47, 0x40, 0x30, 0xAE, 0x04, 0x4E, 0x89, 0x0D,
  0xB9, 0x77, 0x67, 0x8A, 0xDF, 0x08, 0x5F, 0xFF, 0x90, 0xA6, 0x0D, 0xFF, 0xE0, 0x77, 0x18, 0x14,
  0x9D, 0xFF, 0x81, 0xE8, 0x27, 0x58, 0x94, 0x26, 0x8B, 0xDE, 0xEF, 0xED, 0xCA, 0x74, 0x72,
  // "h" (U+0068)
  0x03, 0xD0, 0x37, 0x77, 0x03, 0xD0, 0x37, 0x77, 0x03, 0xD0, 0x37, 0x77, 0x03, 0xD0, 0x37, 0x77,
  0x03, 0xD0, 0x37, 0x77, 0x03, 0xD0, 0x37, 0x77, 0x03, 0xD0, 0x37, 0x77, 0x03, 0xD0, 0x37, 0x77,
  0x03, 0xD0, 0x37, 0x77, 0x03, 0xD0, 0x37, 0x77, 0x03, 0xD0, 0x37, 0x77, 0x03, 0xD0, 0x37, 0x77,
  0x03, 0xD0, 0x37, 0x77, 0x03, 0xD0, 0x36, 0x85, 0x25, 0x67, 0x65, 0x27, 0x10, 0x3D, 0x02, 0x38,
  0x11, 0x8D, 0xF8, 0x1D, 0x71, 0x50, 0x3D, 0x02, 0x20, 0x50, 0xEF, 0xC0, 0xE0, 0x64, 0x03, 0xD8,
  0x11, 0x07, 0xFF, 0x90, 0x93, 0x03, 0xD0, 0x10, 0x6E, 0x00, 0xEF, 0xA0, 0x62, 0x03, 0xD0, 0x20,
  0xEB, 0x09, 0x04, 0x40, 0x40, 0xAF, 0x81, 0x10, 0x3D, 0x0A, 0xA0, 0xD0, 0x37, 0x10, 0x40, 0xED,
  0x81, 0x80, 0x3F, 0x0D, 0x01, 0x73, 0x05, 0xD8, 0x1D, 0x03, 0xF0, 0x37, 0x50, 0xCD, 0x01, 0x03,
  0xE0, 0x97, 0x60, 0x6D, 0x04, 0x03, 0xE0, 0x37, 0x60, 0x2D, 0x05, 0x03, 0xD0, 0xD7, 0x71, 0xD0,
  0x70, 0x3D, 0x09, 0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0, 0x67, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x04,
  0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0, 0x37, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC,
  0x07, 0x03, 0xD0, 0x37, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0,
  0x37, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0, 0x37, 0x71, 0x0E,
  0xC0, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0, 0x37, 0x71, 0x0E, 0xC0, 0x70, 0x3D,
  0x03, 0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0, 0x37, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x03, 0x77, 0x10,
  0xEC, 0x07, 0x03, 0xD0, 0x37, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x03,
  0xD0, 0x37, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0, 0x37, 0x71,
  0x0E, 0xC0, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07,
  // "i" (U+0069)
  0x75, 0x83, 0x7D, 0xEC, 0x57, 0x77, 0x20, 0xAD, 0x07, 0x77, 0x70, 0x2E, 0x0E, 0x77, 0x70, 0x5F,
  0x02, 0x77, 0x60, 0x5F, 0x02, 0x77, 0x60, 0x2E, 0x0E, 0x77, 0x71, 0x0A, 0xD0, 0x77, 0x77, 0x28,
  0x37, 0xDE, 0xC5, 0x80, 0xAE, 0x70, 0x03, 0xFF, 0x90, 0xA7, 0x50, 0x3F, 0xF9, 0x0A, 0x75, 0x03,
  0xFF, 0x90, 0xA7, 0x58, 0x13, 0xDE, 0xFE, 0x0A, 0x77, 0x28, 0x61, 0x23, 0x56, 0x78, 0xDC, 0x0A,
  0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20,
  0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7,
  0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B,
  0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77,
  0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC,
  0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77,
  0x20, 0xBC, 0x0A, 0x77, 0x48, 0x41, 0x23, 0x46, 0xDC, 0x83, 0xC5, 0x43, 0x17, 0x84, 0x19, 0xAB,
  0xDE, 0xFF, 0xB8, 0x5E, 0xDC, 0xA9, 0x33, 0xFF, 0xFE, 0x06, 0x03, 0xFF, 0xFE, 0x06, 0x03, 0xFF,
  0xFE, 0x06,
  // "j" (U+006A)
  0x77, 0x18, 0x36, 0xCE, 0xC6, 0x77, 0x20, 0x8D, 0x09, 0x77, 0x1F, 0x01, 0x76, 0x02, 0xF0, 0x47,
  0x60, 0x2F, 0x03, 0x77, 0x0E, 0xE0, 0x17, 0x70, 0x7D, 0x09, 0x77, 0x28, 0x36, 0xCE, 0xC6, 0x80,
  0xA8, 0x60, 0x01, 0xFF, 0x90, 0xC5, 0x01, 0xFF, 0x90, 0xC5, 0x01, 0xFF, 0x90, 0xC5, 0x01, 0xFF,
  0x90, 0xC7, 0x18, 0x71, 0x34, 0x56, 0x78, 0x9D, 0xC0, 0xC7, 0x72, 0x09, 0xC0, 0xC7, 0x72, 0x09,
  0xC0, 0xC7, 0x72, 0x09, 0xC0, 0xC7, 0x72, 0x09, 0xC0, 0xC7, 0x72, 0x09, 0xC0, 0xC7, 0x72, 0x09,
  0xC0, 0xC7, 0x72, 0x09, 0xC0, 0xC7, 0x72, 0x09, 0xC0, 0xC7, 0x72, 0x09, 0xC0, 0xC7, 0x72, 0x09,
  0xC0, 0xC7, 0x72, 0x09, 0xC0, 0xC7, 0x72, 0x09, 0xC0, 0xC7, 0x72, 0x09, 0xC0, 0xC7, 0x72, 0x09,
  0xC0, 0xC7, 0x72, 0x09, 0xC0, 0xC7, 0x72, 0x09, 0xC0, 0xC7, 0x72, 0x09, 0xC0, 0xC7, 0x72, 0x09,
  0xC0, 0xC7, 0x72, 0x09, 0xC0, 0xC7, 0x72, 0x09, 0xC0, 0xC7, 0x72, 0x09, 0xC0, 0xC7, 0x72, 0x09,
  0xC0, 0xC7, 0x72, 0x09, 0xC0, 0xC7, 0x72, 0x09, 0xC0, 0xC7, 0x72, 0x09, 0xC0, 0xC7, 0x72, 0x09,
  0xC0, 0xC7, 0x72, 0x09, 0xC0, 0xC7, 0x72, 0x09, 0xC0, 0xC7, 0x72, 0x09, 0xC0, 0xC7, 0x72, 0x09,
  0xC0, 0xC7, 0x72, 0x0A, 0xC0, 0xB7, 0x72, 0x0D, 0xC0, 0xA7, 0x71, 0x02, 0xD0, 0x87, 0x71, 0x08,
  0xD0, 0x47, 0x70, 0x3D, 0x0E, 0x28, 0x13, 0x51, 0x72, 0x06, 0xE0, 0x72, 0x06, 0xA8, 0x7D, 0xA8,
  0x76, 0x67, 0xAE, 0xE0, 0xD3, 0x06, 0xFF, 0xA0, 0xE0, 0x23, 0x06, 0xFF, 0x90, 0xC0, 0x24, 0x06,
  0xFE, 0x0E, 0x07, 0x78, 0x43, 0x69, 0xBC, 0xEA, 0x83, 0xED, 0xB8, 0x47, 0x10,
  // "k" (U+006B)
  0x0A, 0xC0, 0xA7, 0x77, 0x10, 0xAC, 0x0A, 0x77, 0x71, 0x0A, 0xC0, 0xA7, 0x77, 0x10, 0xAC, 0x0A,
  0x77, 0x71, 0x0A, 0xC0, 0xA7, 0x77, 0x10, 0xAC, 0x0A, 0x77, 0x71, 0x0A, 0xC0, 0xA7, 0x77, 0x10,
  0xAC, 0x0A, 0x77, 0x71, 0x0A, 0xC0, 0xA7, 0x77, 0x10, 0xAC, 0x0A, 0x77, 0x71, 0x0A, 0xC0, 0xA7,
  0x77, 0x10, 0xAC, 0x0A, 0x77, 0x71, 0x0A, 0xC0, 0xA7, 0x77, 0x10, 0xAC, 0x0A, 0x77, 0x71, 0x0A,
  0xC0, 0xA7, 0x70, 0x8D, 0x81, 0xC1, 0xAC, 0x0A, 0x76, 0x07, 0xD8, 0x2D, 0x10, 0xAC, 0x0A, 0x75,
  0x05, 0xD0, 0xE0, 0x22, 0x0A, 0xC0, 0xA7, 0x40, 0x4D, 0x0E, 0x02, 0x30, 0xAC, 0x0A, 0x73, 0x03,
  0x0E, 0xD0, 0x34, 0x0A, 0xC0, 0xA7, 0x20, 0x20, 0xED, 0x04, 0x50, 0xAC, 0x0A, 0x71, 0x01, 0x0D,
  0xD0, 0x56, 0x0A, 0xC0, 0xA7, 0x01, 0x0C, 0xD0, 0x67, 0x0A, 0xC0, 0xA7, 0x0B, 0xD0, 0x87, 0x10,
  0xAC, 0x0A, 0x60, 0xAD, 0x09, 0x72, 0x0A, 0xC0, 0xA5, 0x09, 0xD0, 0xA7, 0x30, 0xAC, 0x09, 0x40,
  0x7D, 0x0B, 0x74, 0x0A, 0xC0, 0x83, 0x06, 0xD0, 0xC7, 0x50, 0xAC, 0x07, 0x20, 0x4D, 0x0D, 0x01,
  0x75, 0x0A, 0xC8, 0x27, 0x02, 0xED, 0x0E, 0x01, 0x75, 0x0A, 0xC8, 0x16, 0x1D, 0xF0, 0xC7, 0x50,
  0xAC, 0x05, 0x0B, 0xFA, 0x08, 0x74, 0x0A, 0xC0, 0xCC, 0x07, 0x0A, 0xD0, 0x47, 0x30, 0xAF, 0x90,
  0x62, 0x0D, 0xC0, 0xE0, 0x17, 0x20, 0xAF, 0x06, 0x30, 0x3D, 0x0C, 0x72, 0x0A, 0xE0, 0x55, 0x07,
  0xD0, 0x87, 0x10, 0xAD, 0x05, 0x70, 0xBD, 0x04, 0x70, 0xAC, 0x0A, 0x71, 0x01, 0x0E, 0xC0, 0xE0,
  0x26, 0x0A, 0xC0, 0xA7, 0x20, 0x4D, 0x0C, 0x60, 0xAC, 0x0A, 0x73, 0x08, 0xD0, 0x85, 0x0A, 0xC0,
  0xA7, 0x40, 0xCD, 0x05, 0x40, 0xAC, 0x0A, 0x74, 0x02, 0x0E, 0xC0, 0xE0, 0x23, 0x0A, 0xC0, 0xA7,
  0x50, 0x5D, 0x0C, 0x30, 0xAC, 0x0A, 0x76, 0x09, 0xD0, 0x82, 0x0A, 0xC0, 0xA7, 0x70, 0xDD, 0x81,
  0x50, 0xAC, 0x0A, 0x77, 0x02, 0xD8, 0x1E, 0x2A, 0xC0, 0xA7, 0x71, 0x06, 0xD0, 0xC0,
  // "l" (U+006C)
  0x10, 0xDF, 0xF9, 0x0E, 0x75, 0x0D, 0xFF, 0x90, 0xE7, 0x50, 0xDF, 0xF9, 0x0E, 0x75, 0x0D, 0xFF,
  0x90, 0xE7, 0x50, 0x58, 0x06, 0x60, 0xAC, 0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7, 0x77, 0x20, 0x6C,
  0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7, 0x77,
  0x20, 0x6C, 0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x72, 0x06, 0xC0,
  0xE7, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x72,
  0x06, 0xC0, 0xE7, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7, 0x77, 0x20, 0x6C, 0x0E,
  0x77, 0x72, 0x06, 0xC0, 0xE7, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7, 0x77, 0x20,
  0x6C, 0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7,
  0x77, 0x20, 0x6C, 0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x72, 0x06,
  0xC0, 0xE7, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7, 0x77, 0x20, 0x6C, 0x0E, 0x77,
  0x72, 0x06, 0xC0, 0xE7, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7, 0x77, 0x20, 0x6C,
  0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x48, 0x41, 0x23, 0x45, 0xAD,
  0x82, 0x64, 0x32, 0x78, 0x41, 0x9A, 0xBC, 0xEF, 0xFC, 0x84, 0xDC, 0xB9, 0x33, 0xFF, 0xFE, 0x06,
  0x03, 0xFF, 0xFE, 0x06, 0x03, 0xFF, 0xFE, 0x06,
  // "m" (U+006D)
  0x71, 0x83, 0x15, 0x77, 0x47, 0x18, 0x34, 0x67, 0x52, 0x5B, 0x0C, 0x20, 0x10, 0xAD, 0x0E, 0x06,
  0x40, 0x60, 0xED, 0x0C, 0x02, 0x3C, 0x81, 0x11, 0xDF, 0x90, 0x62, 0x08, 0xF9, 0x0E, 0x01, 0x2C,
  0x04, 0x0A, 0xFA, 0x81, 0xE1, 0x5F, 0xB0, 0xA2, 0xC0, 0xCC, 0x0E, 0xE0, 0x80, 0xEF, 0xC0, 0x11,
  0xF0, 0x62, 0x03, 0x0D, 0xF0, 0xE0, 0x52, 0x04, 0x0E, 0xC0, 0x51, 0xE0, 0x74, 0x04, 0xF0, 0x54,
  0x07, 0xC0, 0x91, 0xD0, 0xE6, 0x0D, 0xD0, 0xC5, 0x02, 0xC0, 0xB1, 0xD0, 0x96, 0x0A, 0xD0, 0x66,
  0xC0, 0xD1, 0xD0, 0x66, 0x08, 0xD0, 0x26, 0x0D, 0xC1, 0xD0, 0x36, 0x06, 0xC0, 0xE7, 0x0C, 0xC1,
  0xD0, 0x16, 0x05, 0xC0, 0xB7, 0x0B, 0xC1, 0xD7, 0x05, 0xC0, 0xA7, 0x0B, 0xC1, 0xC0, 0xE7, 0x05,
  0xC0, 0x87, 0x0B, 0xC0, 0x1C, 0x0D, 0x70, 0x5C, 0x07, 0x70, 0xBC, 0x01, 0xC0, 0xC7, 0x05, 0xC0,
  0x77, 0x0B, 0xC0, 0x1C, 0x0C, 0x70, 0x5C, 0x07, 0x70, 0xBC, 0x01, 0xC0, 0xC7, 0x05, 0xC0, 0x77,
  0x0B, 0xC0, 0x1C, 0x0C, 0x70, 0x5C, 0x07, 0x70, 0xBC, 0x01, 0xC0, 0xC7, 0x05, 0xC0, 0x77, 0x0B,
  0xC0, 0x1C, 0x0C, 0x70, 0x5C, 0x07, 0x70, 0xBC, 0x01, 0xC0, 0xC7, 0x05, 0xC0, 0x77, 0x0B, 0xC0,
  0x1C, 0x0C, 0x70, 0x5C, 0x07, 0x70, 0xBC, 0x01, 0xC0, 0xC7, 0x05, 0xC0, 0x77, 0x0B, 0xC0, 0x1C,
  0x0C, 0x70, 0x5C, 0x07, 0x70, 0xBC, 0x01, 0xC0, 0xC7, 0x05, 0xC0, 0x77, 0x0B, 0xC0, 0x1C, 0x0C,
  0x70, 0x5C, 0x07, 0x70, 0xBC, 0x01, 0xC0, 0xC7, 0x05, 0xC0, 0x77, 0x0B, 0xC0, 0x1C, 0x0C, 0x70,
  0x5C, 0x07, 0x70, 0xBC, 0x01, 0xC0, 0xC7, 0x05, 0xC0, 0x77, 0x0B, 0xC0, 0x1C, 0x0C, 0x70, 0x5C,
  0x07, 0x70, 0xBC, 0x01, 0xC0, 0xC7, 0x05, 0xC0, 0x77, 0x0B, 0xC0, 0x1C, 0x0C, 0x70, 0x5C, 0x07,
  0x70, 0xBC, 0x01,
  // "n" (U+006E)
  0x76, 0x85, 0x25, 0x67, 0x65, 0x37, 0x10, 0x3C, 0x03, 0x48, 0x12, 0x9E, 0xF8, 0x1E, 0x92, 0x50,
  0x3C, 0x05, 0x30, 0x9F, 0xE0, 0x84, 0x03, 0xC8, 0x27, 0x01, 0xCF, 0xF9, 0x0B, 0x30, 0x3C, 0x81,
  0xA0, 0xBE, 0x00, 0xEF, 0xA0, 0x92, 0x03, 0xC0, 0xC0, 0x5B, 0x81, 0xD7, 0x34, 0x81, 0x27, 0xEE,
  0x81, 0x20, 0x3D, 0x0E, 0xA0, 0x97, 0x20, 0x10, 0xCD, 0x81, 0xA0, 0x3F, 0x09, 0x74, 0x01, 0x0E,
  0xC8, 0x1E, 0x03, 0xE0, 0xE7, 0x60, 0x9D, 0x00, 0x3E, 0x06, 0x76, 0x04, 0xD0, 0x50, 0x3E, 0x01,
  0x76, 0x01, 0xD0, 0x60, 0x3D, 0x0B, 0x77, 0x1D, 0x07, 0x03, 0xD0, 0x87, 0x71, 0x0E, 0xC0, 0x70,
  0x3D, 0x06, 0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0, 0x47, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x04, 0x77,
  0x10, 0xEC, 0x07, 0x03, 0xD0, 0x37, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07,
  0x03, 0xD0, 0x37, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0, 0x37,
  0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0, 0x37, 0x71, 0x0E, 0xC0,
  0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0, 0x37, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x03,
  0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0, 0x37, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC,
  0x07, 0x03, 0xD0, 0x37, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0,
  0x37, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0, 0x37, 0x71, 0x0E,
  0xC0, 0x70,
  // "o" (U+006F)
  0x74, 0x86, 0x25, 0x67, 0x76, 0x41, 0x77, 0x58, 0x13, 0x9E, 0xF9, 0x81, 0xD8, 0x27, 0x70, 0x20,
  0xBF, 0xF0, 0x90, 0x17, 0x40, 0x5F, 0xFB, 0x0E, 0x04, 0x72, 0x07, 0xFA, 0x00, 0xEF, 0xA0, 0x57,
  0x05, 0xE8, 0x1D, 0x73, 0x48, 0x13, 0x8E, 0xE0, 0x35, 0x01, 0x0E, 0xD0, 0x97, 0x20, 0x10, 0xAD,
  0x0D, 0x50, 0xAD, 0x08, 0x75, 0x0A, 0xD0, 0x83, 0x02, 0xD0, 0xB7, 0x70, 0xDD, 0x01, 0x20, 0x8D,
  0x02, 0x77, 0x04, 0xD0, 0x72, 0x0D, 0xC0, 0xB7, 0x72, 0x0D, 0xC8, 0x1C, 0x02, 0xD0, 0x57, 0x72,
  0x07, 0xD0, 0x10, 0x5D, 0x01, 0x77, 0x20, 0x3D, 0x04, 0x07, 0xC0, 0xE7, 0x74, 0xD0, 0x70, 0x9C,
  0x0C, 0x77, 0x40, 0xEC, 0x08, 0x0A, 0xC0, 0xB7, 0x74, 0x0D, 0xC0, 0x90, 0xAC, 0x0A, 0x77, 0x40,
  0xCC, 0x00, 0xAC, 0x0A, 0x77, 0x40, 0xCC, 0x0A, 0x09, 0xC0, 0xB7, 0x74, 0x0D, 0xC0, 0x90, 0x8C,
  0x0C, 0x77, 0x40, 0xEC, 0x09, 0x06, 0xC0, 0xE7, 0x73, 0x01, 0xD0, 0x70, 0x4D, 0x02, 0x77, 0x20,
  0x3D, 0x04, 0x01, 0xD0, 0x67, 0x72, 0x08, 0xD8, 0x11, 0x0C, 0xC0, 0xB7, 0x72, 0x0D, 0xC0, 0xD2,
  0x07, 0xD0, 0x37, 0x70, 0x4D, 0x08, 0x20, 0x1D, 0x0C, 0x77, 0x0D, 0xD0, 0x13, 0x08, 0xD0, 0x97,
  0x50, 0xAD, 0x09, 0x50, 0xDD, 0x09, 0x01, 0x71, 0x01, 0x0A, 0xD0, 0xE0, 0x15, 0x03, 0xE8, 0x1E,
  0x83, 0x48, 0x13, 0x8E, 0xE0, 0x47, 0x05, 0xFA, 0x00, 0xEF, 0xA0, 0x67, 0x20, 0x40, 0xEF, 0xFA,
  0x0E, 0x05, 0x74, 0x01, 0x0A, 0xFF, 0x0A, 0x01, 0x77, 0x81, 0x28, 0xDF, 0x98, 0x1D, 0x92, 0x77,
  0x58, 0x61, 0x46, 0x77, 0x64, 0x27, 0x40,
  // "p" (U+0070)
  0x75, 0x85, 0x25, 0x67, 0x75, 0x37, 0x30, 0x3C, 0x04, 0x40, 0x70, 0xDF, 0x81, 0xEA, 0x37, 0x03,
  0xC0, 0x62, 0x03, 0x0D, 0xFD, 0x0A, 0x01, 0x50, 0x3C, 0x82, 0x90, 0x3E, 0xFF, 0x0D, 0x02, 0x40,
  0x3C, 0x81, 0xB2, 0xEE, 0x0E, 0xFA, 0x0D, 0x01, 0x30, 0x3C, 0x0E, 0x0B, 0xB8, 0x1B, 0x51, 0x38,
  0x11, 0x5A, 0xE0, 0xB3, 0x03, 0xF9, 0x06, 0x72, 0x03, 0x0E, 0xD0, 0x52, 0x03, 0xF0, 0x57, 0x40,
  0x20, 0xEC, 0x0D, 0x20, 0x3E, 0x0A, 0x76, 0x07, 0xD8, 0x14, 0x03, 0xE0, 0x37, 0x70, 0xEC, 0x81,
  0xA0, 0x3D, 0x0D, 0x77, 0x10, 0x9C, 0x81, 0xE0, 0x3D, 0x08, 0x77, 0x10, 0x5D, 0x02, 0x03, 0xD0,
  0x67, 0x71, 0x02, 0xD0, 0x50, 0x3D, 0x04, 0x77, 0x2D, 0x07, 0x03, 0xD0, 0x37, 0x72, 0x0E, 0xC0,
  0x80, 0x3D, 0x02, 0x77, 0x20, 0xDC, 0x09, 0x03, 0xD0, 0x27, 0x72, 0x0C, 0xC0, 0xA0, 0x3D, 0x02,
  0x77, 0x20, 0xDC, 0x0A, 0x03, 0xD0, 0x37, 0x72, 0x0D, 0xC0, 0x90, 0x3D, 0x03, 0x77, 0x20, 0xEC,
  0x08, 0x03, 0xD0, 0x57, 0x72, 0xD0, 0x70, 0x3D, 0x08, 0x77, 0x10, 0x3D, 0x05, 0x03, 0xD0, 0xB7,
  0x71, 0x06, 0xD0, 0x20, 0x3E, 0x77, 0x10, 0xBC, 0x81, 0xE0, 0x3E, 0x05, 0x76, 0x01, 0xD8, 0x1A,
  0x03, 0xE0, 0xC7, 0x60, 0x8D, 0x81, 0x40, 0x3F, 0x07, 0x74, 0x04, 0xD0, 0xD2, 0x03, 0xF9, 0x06,
  0x72, 0x04, 0x0E, 0xD0, 0x52, 0x03, 0xC0, 0x0E, 0xB8, 0x1C, 0x61, 0x38, 0x11, 0x5B, 0xE0, 0xA3,
  0x03, 0xC8, 0x1D, 0x3E, 0xE0, 0xEF, 0xA0, 0xD0, 0x13, 0x03, 0xD1, 0x04, 0x0E, 0xFF, 0x0D, 0x01,
  0x40, 0x3D, 0x82, 0x10, 0x1C, 0xFD, 0x09, 0x01, 0x50, 0x3D, 0x01, 0x30, 0x60, 0xCF, 0x81, 0xEA,
  0x37, 0x03, 0xD0, 0x25, 0x85, 0x14, 0x67, 0x76, 0x37, 0x30, 0x3D, 0x02, 0x77, 0x71, 0x03, 0xD0,
  0x27, 0x77, 0x10, 0x3D, 0x02, 0x77, 0x71, 0x03, 0xD0, 0x27, 0x77, 0x10, 0x3D, 0x02, 0x77, 0x71,
  0x03, 0xD0, 0x27, 0x77, 0x10, 0x3D, 0x02, 0x77, 0x71, 0x03, 0xD0, 0x27, 0x77, 0x10, 0x3D, 0x02,
  0x77, 0x71, 0x03, 0xD0, 0x27, 0x77, 0x10, 0x3D, 0x02, 0x77, 0x71, 0x03, 0xD0, 0x27, 0x77, 0x10,
  0x3D, 0x02, 0x77, 0x71,
  // "q" (U+0071)
  0x73, 0x85, 0x25, 0x67, 0x65, 0x27, 0x75, 0x81, 0x18, 0xDF, 0x0D, 0x06, 0x40, 0x3C, 0x03, 0x60,
  0x70, 0xEF, 0xC0, 0xC0, 0x12, 0x05, 0xC0, 0x35, 0x0B, 0xFF, 0x82, 0xE3, 0x08, 0xC0, 0x34, 0x0B,
  0xFA, 0x0E, 0xE8, 0x1D, 0x1B, 0xC0, 0x33, 0x08, 0xE8, 0x1B, 0x51, 0x38, 0x12, 0x6C, 0xB0, 0xB0,
  0xEC, 0x03, 0x20, 0x3D, 0x0E, 0x05, 0x72, 0x07, 0xF9, 0x03, 0x20, 0xBD, 0x04, 0x74, 0x08, 0xF8,
  0x13, 0x03, 0xD0, 0x97, 0x60, 0xDE, 0x81, 0x30, 0x9D, 0x01, 0x76, 0x06, 0xE8, 0x13, 0x0D, 0xC0,
  0xB7, 0x71, 0xE0, 0x30, 0x2D, 0x06, 0x77, 0x10, 0xBD, 0x03, 0x05, 0xD0, 0x37, 0x71, 0x08, 0xD0,
  0x30, 0x7D, 0x01, 0x77, 0x10, 0x6D, 0x03, 0x09, 0xC0, 0xE7, 0x72, 0x04, 0xD0, 0x30, 0x9C, 0x0D,
  0x77, 0x20, 0x3D, 0x03, 0x0A, 0xC0, 0xD7, 0x72, 0x02, 0xD0, 0x30, 0xAC, 0x0C, 0x77, 0x20, 0x2D,
  0x03, 0x09, 0xC0, 0xD7, 0x72, 0x02, 0xD0, 0x30, 0x8C, 0x0E, 0x77, 0x20, 0x3D, 0x03, 0x07, 0xD0,
  0x17, 0x71, 0x04, 0xD0, 0x30, 0x5D, 0x03, 0x77, 0x10, 0x6D, 0x03, 0x02, 0xD0, 0x77, 0x71, 0x09,
  0xD8, 0x13, 0x0E, 0xC0, 0xC7, 0x71, 0x0D, 0xD8, 0x13, 0x0A, 0xD0, 0x37, 0x60, 0x3E, 0x81, 0x30,
  0x3D, 0x0B, 0x76, 0x0B, 0xE0, 0x32, 0x0D, 0xD0, 0x67, 0x40, 0x6F, 0x03, 0x20, 0x4E, 0x06, 0x72,
  0x06, 0xF9, 0x03, 0x30, 0x9E, 0x81, 0xC6, 0x13, 0x81, 0x16, 0xCB, 0x0D, 0xD0, 0x34, 0x0C, 0xFA,
  0x0E, 0xE0, 0xE0, 0x2D, 0x03, 0x40, 0x10, 0xBF, 0xF0, 0xE0, 0x41, 0xD0, 0x36, 0x08, 0xFD, 0x82,
  0xD2, 0x01, 0xD0, 0x37, 0x81, 0x29, 0xEF, 0x0D, 0x07, 0x30, 0x1D, 0x03, 0x73, 0x85, 0x35, 0x77,
  0x65, 0x25, 0x02, 0xD0, 0x37, 0x77, 0x10, 0x2D, 0x03, 0x77, 0x71, 0x02, 0xD0, 0x37, 0x77, 0x10,
  0x2D, 0x03, 0x77, 0x71, 0x02, 0xD0, 0x37, 0x77, 0x10, 0x2D, 0x03, 0x77, 0x71, 0x02, 0xD0, 0x37,
  0x77, 0x10, 0x2D, 0x03, 0x77, 0x71, 0x02, 0xD0, 0x37, 0x77, 0x10, 0x2D, 0x03, 0x77, 0x71, 0x02,
  0xD0, 0x37, 0x77, 0x10, 0x2D, 0x03, 0x77, 0x71, 0x02, 0xD0, 0x37, 0x77, 0x10, 0x2D, 0x03,
  // "r" (U+0072)
  0x77, 0x71, 0x85, 0x36, 0x77, 0x64, 0x14, 0x04, 0xFD, 0x0D, 0x50, 0x70, 0xEF, 0x83, 0xD8, 0x10,
  0x4F, 0xE3, 0x01, 0x0C, 0xFC, 0x81, 0x10, 0x4F, 0xE0, 0x12, 0x0C, 0xFC, 0x0C, 0x28, 0x22, 0x9B,
  0xDF, 0xB8, 0x13, 0x0A, 0xE0, 0xED, 0x07, 0x78, 0x31, 0x35, 0x7C, 0xC0, 0x05, 0xC0, 0xB0, 0x43,
  0x83, 0x15, 0xCF, 0x27, 0x40, 0x7C, 0x08, 0x0E, 0xA0, 0xE0, 0x57, 0x10, 0x47, 0x50, 0x7F, 0x90,
  0x37, 0x77, 0x10, 0x7F, 0x06, 0x77, 0x72, 0x07, 0xE0, 0xC7, 0x77, 0x30, 0x7E, 0x04, 0x77, 0x73,
  0x07, 0xD0, 0xD7, 0x77, 0x40, 0x7D, 0x08, 0x77, 0x74, 0x07, 0xD0, 0x47, 0x77, 0x40, 0x7D, 0x02,
  0x77, 0x74, 0x07, 0xD7, 0x77, 0x50, 0x7D, 0x77, 0x75, 0x07, 0xC0, 0xE7, 0x77, 0x50, 0x7C, 0x0E,
  0x77, 0x75, 0x07, 0xC0, 0xE7, 0x77, 0x50, 0x7C, 0x0E, 0x77, 0x75, 0x07, 0xC0, 0xE7, 0x77, 0x50,
  0x7C, 0x0E, 0x77, 0x75, 0x07, 0xC0, 0xE7, 0x77, 0x50, 0x7C, 0x0E, 0x77, 0x75, 0x07, 0xC0, 0xE7,
  0x77, 0x50, 0x7C, 0x0E, 0x77, 0x75, 0x07, 0xC0, 0xE7, 0x77, 0x18, 0x31, 0x24, 0x5B, 0xD8, 0x26,
  0x43, 0x17, 0x58, 0x32, 0x9B, 0xCD, 0xFF, 0xA8, 0x3E, 0xCB, 0x92, 0x60, 0x4F, 0xFF, 0xB0, 0x46,
  0x04, 0xFF, 0xFB, 0x04, 0x60, 0x4F, 0xFF, 0xB0, 0x46,
  // "s" (U+0073)
  0x72, 0x87, 0x35, 0x67, 0x76, 0x64, 0x27, 0x48, 0x11, 0x7C, 0xFB, 0x82, 0xEB, 0x71, 0x60, 0x8F,
  0xFB, 0x0B, 0x01, 0x20, 0x10, 0xCF, 0xFC, 0x0D, 0x30, 0xBF, 0xA0, 0x0E, 0xF9, 0x07, 0x20, 0x6D,
  0x82, 0xE8, 0x41, 0x48, 0x21, 0x36, 0xBB, 0x02, 0x20, 0xCC, 0x0D, 0x01, 0x74, 0x81, 0x17, 0xA3,
  0xD0, 0x57, 0x73, 0x01, 0xD0, 0x17, 0x73, 0x01, 0xD0, 0x27, 0x74, 0xD0, 0x77, 0x74, 0x0C, 0xD0,
  0x57, 0x73, 0x05, 0xE0, 0xA0, 0x27, 0x72, 0x0A, 0xF0, 0xA0, 0x37, 0x71, 0x0A, 0xF9, 0x0C, 0x05,
  0x77, 0x06, 0x0E, 0xF9, 0x81, 0xD7, 0x17, 0x58, 0x11, 0x7E, 0xFA, 0x09, 0x02, 0x75, 0x81, 0x17,
  0xEF, 0xA0, 0x90, 0x17, 0x60, 0x60, 0xCF, 0x90, 0xE0, 0x37, 0x70, 0x40, 0xBF, 0x90, 0x37, 0x71,
  0x02, 0x0A, 0xE0, 0xD7, 0x73, 0x03, 0x0E, 0xD0, 0x47, 0x73, 0x03, 0xD0, 0x87, 0x74, 0x0C, 0xC0,
  0xA7, 0x74, 0x0B, 0xC0, 0xA7, 0x74, 0x0D, 0xC0, 0x80, 0x37, 0x72, 0x03, 0xD8, 0x36, 0xAE, 0x82,
  0x75, 0x01, 0x0D, 0xD0, 0x10, 0xAB, 0x82, 0xD8, 0x52, 0x58, 0x21, 0x38, 0xED, 0x81, 0xA0, 0xAF,
  0xA0, 0xFE, 0xF9, 0x82, 0xE1, 0x0A, 0xFF, 0xD0, 0xE0, 0x22, 0x07, 0x0E, 0xFF, 0xB0, 0xA0, 0x15,
  0x81, 0x59, 0xDF, 0xC8, 0x1D, 0x82, 0x74, 0x87, 0x35, 0x66, 0x77, 0x65, 0x37, 0x20,
  // "t" (U+0074)
  0x73, 0x0D, 0xB0, 0x87, 0x77, 0x2C, 0x08, 0x77, 0x71, 0x01, 0xC0, 0x87, 0x77, 0x10, 0x3C, 0x08,
  0x77, 0x71, 0x05, 0xC0, 0x87, 0x77, 0x10, 0x7C, 0x08, 0x77, 0x71, 0x09, 0xC0, 0x87, 0x77, 0x10,
  0xBC, 0x08, 0x77, 0x70, 0x20, 0xDC, 0x08, 0x76, 0x85, 0x25, 0x79, 0xAC, 0xEF, 0xFE, 0x01, 0x09,
  0xFF, 0xFD, 0x01, 0x09, 0xFF, 0xFD, 0x01, 0x09, 0xFF, 0xFD, 0x01, 0x04, 0x80, 0x46, 0x0E, 0xC0,
  0xB8, 0x09, 0x06, 0x73, 0x0D, 0xC0, 0x87, 0x77, 0x10, 0xDC, 0x08, 0x77, 0x71, 0x0D, 0xC0, 0x87,
  0x77, 0x10, 0xDC, 0x08, 0x77, 0x71, 0x0D, 0xC0, 0x87, 0x77, 0x10, 0xDC, 0x08, 0x77, 0x71, 0x0D,
  0xC0, 0x87, 0x77, 0x10, 0xDC, 0x08, 0x77, 0x71, 0x0D, 0xC0, 0x87, 0x77, 0x10, 0xDC, 0x08, 0x77,
  0x71, 0x0D, 0xC0, 0x87, 0x77, 0x10, 0xDC, 0x08, 0x77, 0x71, 0x0D, 0xC0, 0x87, 0x77, 0x10, 0xDC,
  0x08, 0x77, 0x71, 0x0D, 0xC0, 0x87, 0x77, 0x10, 0xDC, 0x08, 0x77, 0x71, 0x0D, 0xC0, 0x87, 0x77,
  0x10, 0xDC, 0x09, 0x77, 0x71, 0x0C, 0xC0, 0xB7, 0x77, 0x10, 0xAC, 0x0E, 0x77, 0x71, 0x08, 0xD0,
  0x77, 0x77, 0x03, 0xE0, 0x47, 0x77, 0x0C, 0xE8, 0x1A, 0x41, 0x48, 0x22, 0x57, 0xA7, 0x30, 0x3F,
  0xA0, 0xFE, 0xC0, 0xE7, 0x40, 0x6F, 0xF9, 0x0E, 0x75, 0x04, 0x0D, 0xFE, 0x0E, 0x77, 0x81, 0x6B,
  0xEF, 0xA0, 0xD0, 0x97, 0x73, 0x87, 0x25, 0x67, 0x77, 0x53, 0x12,
  // "u" (U+0075)
  0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7,
  0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0,
  0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E,
  0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D,
  0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0,
  0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03,
  0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C,
  0x0E, 0x77, 0x10, 0x4D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x04, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10,
  0x6D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x08, 0xD0, 0x30, 0x7D, 0x77, 0x10, 0xBD, 0x03, 0x06, 0xD0,
  0x17, 0x7E, 0x03, 0x05, 0xD0, 0x47, 0x60, 0x5E, 0x00, 0x3D, 0x09, 0x76, 0x0D, 0xE8, 0x13, 0x0E,
  0xC0, 0xE0, 0x17, 0x40, 0x8F, 0x81, 0x30, 0xAD, 0x0C, 0x01, 0x72, 0x08, 0xF9, 0x81, 0x30, 0x3E,
  0x81, 0xE7, 0x24, 0x81, 0x27, 0xDB, 0x0D, 0x0E, 0xC0, 0x32, 0x0A, 0xFA, 0x00, 0xEE, 0x81, 0xE2,
  0xBC, 0x03, 0x30, 0xCF, 0xFA, 0x81, 0x40, 0x8C, 0x03, 0x40, 0xAF, 0xE0, 0xD0, 0x32, 0x06, 0xC0,
  0x35, 0x81, 0x3A, 0xEF, 0x90, 0xC0, 0x64, 0x03, 0xC0, 0x37, 0x18, 0x63, 0x56, 0x77, 0x64, 0x17,
  0x50,
  // "v" (U+0076)
  0x01, 0xD0, 0x67, 0x74, 0x09, 0xD8, 0x11, 0x0B, 0xC0, 0xB7, 0x74, 0x0E, 0xC0, 0xA2, 0x05, 0xD0,
  0x17, 0x72, 0x04, 0xD0, 0x43, 0x0E, 0xC0, 0x77, 0x72, 0x09, 0xC0, 0xE4, 0x09, 0xC0, 0xC7, 0x72,
  0x0E, 0xC0, 0x84, 0x04, 0xD0, 0x27, 0x70, 0x4D, 0x02, 0x50, 0xDC, 0x08, 0x77, 0x0A, 0xC0, 0xC6,
  0x08, 0xC0, 0xD7, 0x70, 0xEC, 0x06, 0x60, 0x2D, 0x03, 0x75, 0x05, 0xD0, 0x17, 0x0C, 0xC0, 0x87,
  0x50, 0xAC, 0x0A, 0x71, 0x06, 0xC0, 0xE7, 0x5D, 0x04, 0x71, 0x01, 0xD0, 0x47, 0x30, 0x5C, 0x0E,
  0x73, 0x0A, 0xC0, 0x97, 0x30, 0xBC, 0x08, 0x73, 0x04, 0xC0, 0xE7, 0x20, 0x1D, 0x02, 0x74, 0x0E,
  0xC0, 0x57, 0x10, 0x6C, 0x0C, 0x75, 0x08, 0xC0, 0xA7, 0x10, 0xBC, 0x06, 0x75, 0x02, 0xD0, 0x16,
  0x01, 0xD0, 0x17, 0x60, 0xCC, 0x06, 0x60, 0x6C, 0x0A, 0x77, 0x06, 0xC0, 0xB6, 0x0B, 0xC0, 0x47,
  0x70, 0x1D, 0x01, 0x40, 0x1C, 0x0E, 0x77, 0x20, 0xAC, 0x07, 0x40, 0x7C, 0x08, 0x77, 0x20, 0x5C,
  0x0C, 0x40, 0xCC, 0x02, 0x77, 0x30, 0xEC, 0x02, 0x20, 0x2C, 0x0C, 0x77, 0x40, 0x9C, 0x08, 0x20,
  0x8C, 0x06, 0x77, 0x40, 0x3C, 0x0D, 0x20, 0xDC, 0x01, 0x77, 0x50, 0xCC, 0x03, 0x04, 0xC0, 0xA7,
  0x76, 0x07, 0xC0, 0x80, 0x9C, 0x04, 0x77, 0x60, 0x1C, 0x0D, 0x0E, 0xB0, 0xE7, 0x77, 0x10, 0xBF,
  0x90, 0x87, 0x77, 0x10, 0x5F, 0x90, 0x27, 0x77, 0x20, 0xEE, 0x0C, 0x77, 0x73, 0x09, 0xE0, 0x67,
  0x50,
  // "w" (U+0077)
  0x0E, 0xC0, 0x17, 0x77, 0x20, 0xDC, 0x0C, 0xC0, 0x37, 0x77, 0x2C, 0x0D, 0x0A, 0xC0, 0x57, 0x77,
  0x10, 0x3C, 0x0A, 0x07, 0xC0, 0x87, 0x77, 0x10, 0x5C, 0x07, 0x05, 0xC0, 0xA7, 0x77, 0x10, 0x8C,
  0x05, 0x02, 0xC0, 0xC7, 0x77, 0x10, 0xAC, 0x02, 0x1C, 0x0E, 0x70, 0x2D, 0x0E, 0x01, 0x70, 0xDC,
  0x20, 0xDC, 0x01, 0x60, 0x6E, 0x05, 0x7C, 0x0D, 0x20, 0xAC, 0x04, 0x60, 0xBE, 0x09, 0x60, 0x2C,
  0x0A, 0x20, 0x7C, 0x06, 0x6F, 0x0D, 0x60, 0x5C, 0x08, 0x20, 0x5C, 0x08, 0x50, 0x4F, 0x90, 0x25,
  0x07, 0xC0, 0x52, 0x02, 0xC0, 0xA5, 0x09, 0xB0, 0xC0, 0xDB, 0x07, 0x50, 0xAC, 0x03, 0x3C, 0x0D,
  0x50, 0xDB, 0x08, 0x09, 0xB0, 0xB5, 0x0C, 0xC4, 0x0D, 0xC4, 0x02, 0xC0, 0x40, 0x5C, 0x50, 0xEB,
  0x0D, 0x40, 0xAC, 0x02, 0x30, 0x7C, 0x10, 0x2C, 0x04, 0x30, 0x2C, 0x0A, 0x40, 0x8C, 0x04, 0x30,
  0xBB, 0x0C, 0x20, 0xDB, 0x08, 0x30, 0x4C, 0x08, 0x40, 0x5C, 0x06, 0x3C, 0x08, 0x20, 0xAB, 0x0D,
  0x30, 0x6C, 0x05, 0x40, 0x3C, 0x09, 0x20, 0x4C, 0x04, 0x20, 0x6C, 0x01, 0x20, 0x9C, 0x03, 0x5C,
  0x0A, 0x20, 0x8B, 0x0E, 0x30, 0x2C, 0x06, 0x20, 0xBC, 0x60, 0xDB, 0x0C, 0x20, 0xCB, 0x0B, 0x40,
  0xDB, 0x0A, 0x20, 0xDB, 0x0D, 0x60, 0xBB, 0x0E, 0x2C, 0x06, 0x40, 0x9B, 0x0D, 0x20, 0xEB, 0x0B,
  0x60, 0x8C, 0x10, 0x4C, 0x02, 0x40, 0x5C, 0x02, 0x1C, 0x08, 0x60, 0x6C, 0x01, 0x07, 0xB0, 0xE5,
  0x01, 0xC0, 0x50, 0x1C, 0x05, 0x60, 0x3C, 0x02, 0x0A, 0xB0, 0xA6, 0x0D, 0xB0, 0x90, 0x3C, 0x03,
  0x60, 0x1C, 0x03, 0x0D, 0xB0, 0x66, 0x09, 0xB0, 0xC0, 0x4C, 0x71, 0x0E, 0xB0, 0x5C, 0x01, 0x60,
  0x5C, 0x05, 0xB0, 0xD7, 0x10, 0xBB, 0x08, 0xB0, 0xD7, 0x01, 0xC0, 0x9B, 0x0B, 0x71, 0x09, 0xB0,
  0xDB, 0x09, 0x71, 0x0C, 0xB0, 0xDB, 0x08, 0x71, 0x06, 0xF0, 0x57, 0x10, 0x8F, 0x06, 0x71, 0x04,
  0xF0, 0x17, 0x10, 0x4F, 0x03, 0x71, 0x01, 0xE0, 0xC7, 0x3F, 0x73, 0x0E, 0xD0, 0x87, 0x30, 0xCD,
  0x0D, 0x50,
  // "x" (U+0078)
  0x05, 0xD0, 0xB7, 0x72, 0x0B, 0xD8, 0x15, 0x09, 0xD0, 0x67, 0x70, 0x6D, 0x09, 0x30, 0xCD, 0x02,
  0x75, 0x02, 0xD0, 0xC4, 0x02, 0x0E, 0xC0, 0xC7, 0x50, 0xCC, 0x0E, 0x02, 0x50, 0x6D, 0x08, 0x73,
  0x09, 0xD0, 0x57, 0x0A, 0xD0, 0x47, 0x10, 0x4D, 0x09, 0x72, 0x0D, 0xC0, 0xE0, 0x16, 0x01, 0x0E,
  0xC0, 0xD7, 0x30, 0x3D, 0x0B, 0x60, 0xBD, 0x02, 0x74, 0x06, 0xD0, 0x64, 0x06, 0xD0, 0x67, 0x60,
  0xAD, 0x02, 0x20, 0x2D, 0x0A, 0x77, 0x01, 0x0D, 0xC0, 0xC2, 0x0C, 0xC0, 0xD7, 0x72, 0x03, 0xD0,
  0x09, 0xD0, 0x37, 0x73, 0x07, 0xFB, 0x06, 0x77, 0x50, 0xBF, 0x90, 0xA7, 0x76, 0x01, 0x0E, 0xE0,
  0xD0, 0x17, 0x77, 0x05, 0xE0, 0x47, 0x77, 0x10, 0xAE, 0x09, 0x77, 0x70, 0x7F, 0x90, 0x67, 0x75,
  0x03, 0xFA, 0x0E, 0x02, 0x77, 0x30, 0x10, 0xDC, 0x00, 0xDC, 0x0D, 0x77, 0x30, 0xAD, 0x00, 0x2D,
  0x09, 0x77, 0x10, 0x7D, 0x06, 0x20, 0x6D, 0x05, 0x76, 0x03, 0xD0, 0xA4, 0x0A, 0xC0, 0xE0, 0x27,
  0x40, 0x10, 0xDC, 0x0D, 0x01, 0x40, 0x10, 0xDC, 0x0C, 0x74, 0x0A, 0xD0, 0x36, 0x04, 0xD0, 0x97,
  0x20, 0x6D, 0x07, 0x71, 0x08, 0xD0, 0x57, 0x03, 0xD0, 0xB7, 0x30, 0xCC, 0x0E, 0x02, 0x50, 0x10,
  0xDC, 0x0E, 0x01, 0x73, 0x02, 0x0E, 0xC0, 0xC5, 0x0A, 0xD0, 0x57, 0x50, 0x5D, 0x09, 0x30, 0x6D,
  0x09, 0x77, 0x09, 0xD8, 0x15, 0x03, 0xD0, 0xC7, 0x72, 0x0D, 0xC8, 0x1E, 0x2D, 0xC0, 0xE0, 0x27,
  0x72, 0x03, 0xD0, 0xC0,
  // "y" (U+0079)
  0x01, 0xD0, 0x37, 0x74, 0x07, 0xD8, 0x11, 0x0A, 0xC0, 0x97, 0x74, 0x0C, 0xC0, 0xA2, 0x03, 0xC0,
  0xE7, 0x73, 0x02, 0xD0, 0x43, 0x0C, 0xC0, 0x67, 0x72, 0x07, 0xC0, 0xD4, 0x05, 0xC0, 0xD7, 0x72,
  0x0C, 0xC0, 0x85, 0x0E, 0xC0, 0x47, 0x70, 0x2D, 0x02, 0x50, 0x8C, 0x0A, 0x77, 0x07, 0xC0, 0xC6,
  0x01, 0xD0, 0x17, 0x60, 0xDC, 0x06, 0x70, 0xAC, 0x07, 0x75, 0x02, 0xC0, 0xE7, 0x10, 0x3C, 0x0E,
  0x75, 0x08, 0xC0, 0x97, 0x20, 0xCC, 0x05, 0x74, 0x0D, 0xC0, 0x47, 0x20, 0x6C, 0x0B, 0x73, 0x03,
  0xC0, 0xD7, 0x40, 0xEC, 0x02, 0x72, 0x08, 0xC0, 0x77, 0x40, 0x8C, 0x09, 0x72, 0x0D, 0xC0, 0x27,
  0x40, 0x2C, 0x0E, 0x71, 0x03, 0xC0, 0xB7, 0x60, 0xAC, 0x06, 0x70, 0x9C, 0x05, 0x76, 0x04, 0xC0,
  0xC7, 0x0E, 0xB0, 0xE7, 0x71, 0x0D, 0xC0, 0x35, 0x04, 0xC0, 0x97, 0x71, 0x06, 0xC0, 0xA5, 0x09,
  0xC0, 0x37, 0x72, 0x0E, 0xC0, 0x14, 0x0E, 0xB0, 0xD7, 0x73, 0x08, 0xC0, 0x73, 0x04, 0xC0, 0x77,
  0x73, 0x02, 0xC0, 0xC3, 0x09, 0xC0, 0x17, 0x74, 0x0B, 0xC0, 0x22, 0x0E, 0xB0, 0xB7, 0x75, 0x04,
  0xC8, 0x17, 0x03, 0xC0, 0x57, 0x76, 0x0D, 0xB8, 0x1C, 0x08, 0xB0, 0xE7, 0x77, 0x06, 0xC0, 0x20,
  0xDB, 0x09, 0x77, 0x70, 0x10, 0xEB, 0x0A, 0xC0, 0x37, 0x77, 0x10, 0x9F, 0x0C, 0x77, 0x72, 0x02,
  0xF0, 0x77, 0x77, 0x30, 0xBE, 0x01, 0x77, 0x73, 0x04, 0xD0, 0xA7, 0x77, 0x50, 0xEC, 0x04, 0x77,
  0x74, 0x01, 0xC0, 0xE7, 0x77, 0x50, 0x8C, 0x08, 0x77, 0x75, 0x0E, 0xC0, 0x27, 0x77, 0x40, 0x5C,
  0x0C, 0x77, 0x75, 0x0C, 0xC0, 0x67, 0x77, 0x40, 0x3C, 0x0E, 0x77, 0x75, 0x0C, 0xC0, 0x87, 0x77,
  0x40, 0x8C, 0x0E, 0x01, 0x77, 0x73, 0x08, 0xD0, 0x87, 0x73, 0x86, 0x19, 0x87, 0x67, 0x9E, 0xD0,
  0xE0, 0x17, 0x73, 0x02, 0xFD, 0x04, 0x77, 0x40, 0x2F, 0xC0, 0x57, 0x75, 0x02, 0xFA, 0x0C, 0x03,
  0x77, 0x68, 0x90, 0x1A, 0xCE, 0xEF, 0xEC, 0x94, 0x77, 0x70,
  // "z" (U+007A)
  0x10, 0x9F, 0xFF, 0xA8, 0x11, 0x09, 0xFF, 0xFA, 0x81, 0x10, 0x9F, 0xFF, 0xA8, 0x11, 0x09, 0xFF,
  0xFA, 0x81, 0x10, 0x48, 0x09, 0x56, 0x0E, 0xD0, 0x17, 0x74, 0x08, 0xD0, 0x97, 0x74, 0x05, 0xD0,
  0xB7, 0x74, 0x02, 0x0E, 0xC0, 0xD0, 0x17, 0x74, 0x0D, 0xD0, 0x37, 0x74, 0x0A, 0xD0, 0x57, 0x74,
  0x07, 0xD0, 0x87, 0x74, 0x04, 0xD0, 0xB7, 0x74, 0x01, 0x0E, 0xC0, 0xD0, 0x17, 0x74, 0x0C, 0xC0,
  0xE0, 0x27, 0x74, 0x09, 0xD0, 0x57, 0x74, 0x06, 0xD0, 0x87, 0x74, 0x03, 0xD0, 0xB7, 0x74, 0x01,
  0x0D, 0xC0, 0xD0, 0x17, 0x74, 0x0B, 0xC0, 0xE0, 0x27, 0x74, 0x08, 0xD0, 0x57, 0x74, 0x05, 0xD0,
  0x87, 0x74, 0x02, 0x0E, 0xC0, 0xA7, 0x75, 0x0D, 0xC0, 0xD7, 0x75, 0x0A, 0xC0, 0xE0, 0x27, 0x74,
  0x07, 0xD0, 0x47, 0x74, 0x03, 0xD0, 0x77, 0x74, 0x01, 0x0E, 0xC0, 0xA7, 0x75, 0x0C, 0xD0, 0x78,
  0x09, 0x56, 0x03, 0x07, 0xFF, 0xFB, 0x00, 0x9F, 0xFF, 0xB0, 0x09, 0xFF, 0xFB, 0x00, 0x9F, 0xFF,
  0xB0, 0x90,
  // "{" (U+007B)
  0x77, 0x84, 0x48, 0xBD, 0xE9, 0x75, 0x07, 0x0E, 0xD0, 0x97, 0x30, 0x30, 0xDF, 0x09, 0x72, 0x03,
  0x0E, 0xF9, 0x09, 0x72, 0x0D, 0xE8, 0x2D, 0x97, 0x37, 0x10, 0x7D, 0x0D, 0x04, 0x75, 0x0C, 0xC0,
  0xD0, 0x17, 0x50, 0x1D, 0x06, 0x76, 0x02, 0xD0, 0x17, 0x60, 0x4D, 0x77, 0x04, 0xC0, 0xE7, 0x70,
  0x4C, 0x0E, 0x77, 0x04, 0xC0, 0xE7, 0x70, 0x4C, 0x0E, 0x77, 0x04, 0xC0, 0xE7, 0x70, 0x4C, 0x0E,
  0x77, 0x04, 0xC0, 0xE7, 0x70, 0x4C, 0x0E, 0x77, 0x04, 0xC0, 0xE7, 0x70, 0x5C, 0x0D, 0x77, 0x09,
  0xC0, 0xB7, 0x60, 0x10, 0xEC, 0x07, 0x75, 0x01, 0x0C, 0xC0, 0xE0, 0x17, 0x28, 0x12, 0x59, 0xE0,
  0x57, 0x10, 0x9F, 0x90, 0xE0, 0x57, 0x20, 0x9E, 0x0B, 0x06, 0x74, 0x09, 0xD8, 0x1B, 0x51, 0x74,
  0x09, 0xF9, 0x09, 0x01, 0x72, 0x82, 0x37, 0x8B, 0xE0, 0xD0, 0x17, 0x50, 0x10, 0x8D, 0x0C, 0x77,
  0x05, 0xD0, 0x57, 0x70, 0xBC, 0x0A, 0x77, 0x07, 0xC0, 0xD7, 0x70, 0x5C, 0x0E, 0x77, 0x04, 0xC0,
  0xE7, 0x70, 0x4C, 0x0E, 0x77, 0x04, 0xC0, 0xE7, 0x70, 0x4C, 0x0E, 0x77, 0x04, 0xC0, 0xE7, 0x70,
  0x4C, 0x0E, 0x77, 0x04, 0xC0, 0xE7, 0x70, 0x4C, 0x0E, 0x77, 0x04, 0xC0, 0xE7, 0x70, 0x3D, 0x77,
  0x02, 0xD0, 0x37, 0x70, 0xEC, 0x0A, 0x77, 0x0A, 0xD0, 0x77, 0x60, 0x3E, 0x81, 0xC6, 0x27, 0x40,
  0x9F, 0xA0, 0x97, 0x30, 0xAF, 0x90, 0x97, 0x40, 0x60, 0xEE, 0x09, 0x75, 0x81, 0x16, 0xBC, 0x09,
  0x77, 0x28, 0x22, 0x45, 0x30,
  // "|" (U+007C)
  0x02, 0xC0, 0x30, 0x2C, 0x03, 0x02, 0xC0, 0x30, 0x2C, 0x03, 0x02, 0xC0, 0x30, 0x2C, 0x03, 0x02,
  0xC0, 0x30, 0x2C, 0x03, 0x02, 0xC0, 0x30, 0x2C, 0x03, 0x02, 0xC0, 0x30, 0x2C, 0x03, 0x02, 0xC0,
  0x30, 0x2C, 0x03, 0x02, 0xC0, 0x30, 0x2C, 0x03, 0x02, 0xC0, 0x30, 0x2C, 0x03, 0x02, 0xC0, 0x30,
  0x2C, 0x03, 0x02, 0xC0, 0x30, 0x2C, 0x03, 0x02, 0xC0, 0x30, 0x2C, 0x03, 0x02, 0xC0, 0x30, 0x2C,
  0x03, 0x02, 0xC0, 0x30, 0x2C, 0x03, 0x02, 0xC0, 0x30, 0x2C, 0x03, 0x02, 0xC0, 0x30, 0x2C, 0x03,
  0x02, 0xC0, 0x30, 0x2C, 0x03, 0x02, 0xC0, 0x30, 0x2C, 0x03, 0x02, 0xC0, 0x30, 0x2C, 0x03, 0x02,
  0xC0, 0x30, 0x2C, 0x03, 0x02, 0xC0, 0x30, 0x2C, 0x03, 0x02, 0xC0, 0x30, 0x2C, 0x03, 0x02, 0xC0,
  0x30, 0x2C, 0x03, 0x02, 0xC0, 0x30, 0x2C, 0x03, 0x02, 0xC0, 0x30, 0x2C, 0x03, 0x02, 0xC0, 0x30,
  0x2C, 0x03, 0x02, 0xC0, 0x30, 0x2C, 0x03, 0x02, 0xC0, 0x30, 0x2C, 0x03, 0x02, 0xC0, 0x30, 0x2C,
  0x03, 0x02, 0xC0, 0x30, 0x2C, 0x03,
  // "}" (U+007D)
  0x82, 0x35, 0x42, 0x77, 0x20, 0x9B, 0x81, 0xEB, 0x67, 0x60, 0x9E, 0x0E, 0x06, 0x74, 0x09, 0xF9,
  0x0A, 0x73, 0x09, 0xFA, 0x09, 0x74, 0x81, 0x36, 0xCE, 0x03, 0x76, 0x07, 0xD0, 0xA7, 0x70, 0xAC,
  0x0E, 0x77, 0x03, 0xD0, 0x27, 0x7D, 0x03, 0x77, 0x0E, 0xC0, 0x47, 0x70, 0xEC, 0x04, 0x77, 0x0E,
  0xC0, 0x47, 0x70, 0xEC, 0x04, 0x77, 0x0E, 0xC0, 0x47, 0x70, 0xEC, 0x04, 0x77, 0x0E, 0xC0, 0x47,
  0x70, 0xEC, 0x04, 0x77, 0x0E, 0xC0, 0x47, 0x70, 0xEC, 0x05, 0x77, 0x0D, 0xC0, 0x77, 0x70, 0xAC,
  0x0B, 0x77, 0x05, 0xD0, 0x57, 0x70, 0xCD, 0x08, 0x01, 0x75, 0x02, 0x0D, 0xE8, 0x2B, 0x87, 0x37,
  0x20, 0x10, 0x9F, 0x90, 0x97, 0x48, 0x11, 0x5B, 0xD0, 0x97, 0x40, 0x60, 0xBE, 0x09, 0x72, 0x05,
  0x0E, 0xF9, 0x09, 0x71, 0x05, 0xE8, 0x19, 0x52, 0x72, 0x01, 0x0E, 0xC0, 0xC0, 0x17, 0x50, 0x7C,
  0x0E, 0x01, 0x76, 0x0B, 0xC0, 0x97, 0x70, 0xDC, 0x05, 0x77, 0x0E, 0xC0, 0x47, 0x70, 0xEC, 0x04,
  0x77, 0x0E, 0xC0, 0x47, 0x70, 0xEC, 0x04, 0x77, 0x0E, 0xC0, 0x47, 0x70, 0xEC, 0x04, 0x77, 0x0E,
  0xC0, 0x47, 0x70, 0xEC, 0x04, 0x77, 0x0E, 0xC0, 0x47, 0x7D, 0x04, 0x76, 0x01, 0xD0, 0x27, 0x60,
  0x6D, 0x01, 0x75, 0x01, 0x0D, 0xC0, 0xC7, 0x50, 0x40, 0xDD, 0x07, 0x71, 0x82, 0x37, 0x9D, 0xE0,
  0xD7, 0x20, 0x9F, 0x90, 0xE0, 0x37, 0x20, 0x9F, 0x0D, 0x03, 0x73, 0x09, 0xD0, 0xE0, 0x77, 0x58,
  0x49, 0xED, 0xB8, 0x47, 0x70,
  // "~" (U+007E)
  0x48, 0x52, 0x9D, 0xFE, 0xC7, 0x75, 0x03, 0xB0, 0x53, 0x04, 0xF0, 0xD0, 0x47, 0x30, 0x6B, 0x03,
  0x20, 0x2F, 0xB0, 0x87, 0x20, 0x9B, 0x30, 0xBF, 0xC0, 0xA7, 0x10, 0xCA, 0x0D, 0x20, 0x3B, 0x84,
  0xE5, 0x01, 0x7E, 0xC0, 0xC0, 0x15, 0x01, 0xB0, 0x92, 0x08, 0xB0, 0x44, 0x01, 0x0C, 0xC0, 0xD0,
  0x24, 0x08, 0xB0, 0x52, 0x0C, 0xA0, 0xC7, 0x0B, 0xC8, 0x3E, 0x71, 0x06, 0xB0, 0xE3, 0xB0, 0x87,
  0x10, 0xAF, 0xC0, 0x72, 0x03, 0xB0, 0x47, 0x20, 0x9F, 0xA0, 0xC3, 0x05, 0xB0, 0x27, 0x30, 0x50,
  0xEE, 0x0D, 0x01, 0x30, 0x7B, 0x75, 0x85, 0x17, 0xCE, 0xFD, 0x85,
  // "¡" (U+00A1)
  0x28, 0x23, 0x66, 0x33, 0x09, 0xC8, 0x19, 0x05, 0xE0, 0x50, 0x9E, 0x09, 0x0A, 0xE0, 0xA0, 0x9E,
  0x09, 0x05, 0xE8, 0x15, 0x0A, 0xC0, 0xA3, 0x82, 0x36, 0x63, 0x77, 0x77, 0x70, 0x5C, 0x04, 0x20,
  0x6C, 0x05, 0x20, 0x6C, 0x05, 0x20, 0x7C, 0x06, 0x20, 0x7C, 0x06, 0x20, 0x8C, 0x07, 0x20, 0x8C,
  0x07, 0x20, 0x8C, 0x07, 0x20, 0x9C, 0x08, 0x20, 0x9C, 0x08, 0x20, 0xAC, 0x09, 0x20, 0xAC, 0x09,
  0x20, 0xBC, 0x0A, 0x20, 0xBC, 0x0A, 0x20, 0xCC, 0x0B, 0x20, 0xCC, 0x0B, 0x20, 0xDC, 0x0C, 0x20,
  0xDC, 0x0C, 0x20, 0xEC, 0x0D, 0x20, 0xEC, 0x0D, 0x2D, 0x0E, 0x2D, 0x0E, 0x2E, 0x10, 0x1E, 0x10,
  0x1E, 0x10, 0x2E, 0x01, 0x02, 0xE0, 0x10, 0x3E, 0x01, 0x03, 0xE0, 0x20, 0x3E, 0x02, 0x04, 0xE0,
  0x30,
  // "¢" (U+00A2)
  0x75, 0x83, 0x27, 0x77, 0x67, 0x77, 0x04, 0xB0, 0xC7, 0x77, 0x04, 0xB0, 0xC7, 0x77, 0x04, 0xB0,
  0xC7, 0x77, 0x04, 0xB0, 0xC7, 0x77, 0x05, 0xB8, 0x3D, 0x54, 0x31, 0x77, 0x81, 0x4A, 0xDF, 0xA8,
  0x2E, 0xA6, 0x17, 0x10, 0x60, 0xDF, 0xFA, 0x06, 0x50, 0x10, 0xBF, 0xFC, 0x02, 0x40, 0x20, 0xDF,
  0xFC, 0x0C, 0x40, 0x20, 0xDE, 0x82, 0xC7, 0x31, 0x28, 0x31, 0x35, 0x9D, 0xA0, 0x74, 0x0B, 0xD0,
  0xD0, 0x47, 0x48, 0x12, 0x82, 0x30, 0x6D, 0x0C, 0x01, 0x77, 0x40, 0xDC, 0x0E, 0x01, 0x77, 0x40,
  0x4D, 0x06, 0x77, 0x50, 0xAC, 0x0E, 0x77, 0x60, 0xEC, 0x09, 0x77, 0x50, 0x1D, 0x04, 0x77, 0x50,
  0x4D, 0x02, 0x77, 0x50, 0x6C, 0x0E, 0x77, 0x60, 0x7C, 0x0D, 0x77, 0x60, 0x8C, 0x0D, 0x77, 0x60,
  0x9C, 0x0C, 0x77, 0x60, 0x8C, 0x0D, 0x77, 0x60, 0x8C, 0x0E, 0x77, 0x60, 0x7D, 0x77, 0x60, 0x5D,
  0x02, 0x77, 0x50, 0x2D, 0x05, 0x77, 0x60, 0xEC, 0x09, 0x77, 0x60, 0xBC, 0x0E, 0x77, 0x60, 0x5D,
  0x07, 0x77, 0x60, 0xED, 0x03, 0x77, 0x50, 0x7D, 0x0E, 0x04, 0x77, 0x50, 0xCE, 0x09, 0x02, 0x72,
  0x83, 0x15, 0xAE, 0x13, 0x02, 0x0E, 0xF8, 0x7D, 0x97, 0x66, 0x78, 0xAD, 0xC0, 0x14, 0x03, 0x0E,
  0xFF, 0xD0, 0x15, 0x01, 0x0B, 0xFF, 0xC0, 0x17, 0x04, 0x0B, 0xFF, 0x0E, 0x09, 0x73, 0x82, 0x26,
  0xAD, 0xD8, 0x3E, 0xDB, 0x84, 0x77, 0x10, 0x4B, 0x0B, 0x77, 0x70, 0x4B, 0x0B, 0x77, 0x70, 0x4B,
  0x0B, 0x77, 0x70, 0x4B, 0x0B, 0x77, 0x70, 0x4B, 0x0B, 0x77, 0x70, 0x4B, 0x0B, 0x72,
  // "£" (U+00A3)
  0x77, 0x85, 0x45, 0x77, 0x65, 0x27, 0x73, 0x03, 0x0B, 0xF9, 0x81, 0xEA, 0x47, 0x60, 0xAF, 0xE0,
  0xC0, 0x47, 0x20, 0x10, 0xDF, 0xF9, 0x0A, 0x72, 0x0C, 0xF9, 0x0E, 0xF0, 0x37, 0x10, 0x7D, 0x81,
  0xE7, 0x23, 0x81, 0x15, 0xAA, 0x0C, 0x72, 0x0E, 0xC0, 0xD0, 0x17, 0x18, 0x12, 0xA5, 0x71, 0x05,
  0xD0, 0x37, 0x76, 0x09, 0xC0, 0xC7, 0x77, 0x0D, 0xC0, 0x87, 0x77, 0x0E, 0xC0, 0x57, 0x77, 0xD0,
  0x47, 0x77, 0xD0, 0x47, 0x77, 0xD0, 0x47, 0x77, 0xD0, 0x47, 0x77, 0xD0, 0x47, 0x77, 0xD0, 0x47,
  0x77, 0xD0, 0x47, 0x77, 0xD0, 0x47, 0x77, 0xD0, 0x47, 0x71, 0x02, 0x80, 0x16, 0xD0, 0x88, 0x05,
  0x60, 0x55, 0x06, 0xFF, 0xE0, 0xD5, 0x06, 0xFF, 0xE0, 0xD5, 0x06, 0xFF, 0xE0, 0xD5, 0x06, 0xFF,
  0xE0, 0xD7, 0x4D, 0x04, 0x77, 0x7D, 0x04, 0x77, 0x7D, 0x04, 0x77, 0x7D, 0x04, 0x77, 0x7D, 0x04,
  0x77, 0x7D, 0x04, 0x77, 0x7D, 0x03, 0x77, 0x60, 0x1D, 0x02, 0x77, 0x60, 0x2D, 0x77, 0x70, 0x5C,
  0x0B, 0x77, 0x70, 0x9C, 0x05, 0x77, 0x60, 0x10, 0xEB, 0x0E, 0x77, 0x70, 0xBC, 0x06, 0x77, 0x50,
  0x10, 0xAC, 0x0A, 0x77, 0x48, 0x11, 0x7E, 0xC0, 0xE8, 0x09, 0x66, 0x03, 0x09, 0xFF, 0xFC, 0x07,
  0x09, 0xFF, 0xFC, 0x07, 0x09, 0xFF, 0xFC, 0x07, 0x09, 0xFF, 0xFC, 0x07,
  // "¤" (U+00A4)
  0x20, 0x70, 0xC7, 0x76, 0x0B, 0x07, 0x30, 0x6A, 0x0B, 0x68, 0x41, 0x45, 0x54, 0x16, 0x0B, 0xA8,
  0x17, 0x06, 0xC0, 0xB3, 0x05, 0x0C, 0xE0, 0xC0, 0x53, 0x0B, 0xC0, 0x60, 0x4D, 0x81, 0xA3, 0xCF,
  0xB8, 0x1C, 0x3A, 0xD8, 0x14, 0x05, 0xFF, 0xFB, 0x06, 0x30, 0x7F, 0xFF, 0x90, 0x75, 0x08, 0xE8,
  0x1C, 0x62, 0x28, 0x12, 0x5A, 0xE0, 0x97, 0x0E, 0xB0, 0xE0, 0x57, 0x10, 0x30, 0xDC, 0x01, 0x60,
  0x7B, 0x0E, 0x02, 0x73, 0x01, 0x0D, 0xB0, 0x96, 0x0E, 0xB0, 0x47, 0x50, 0x2C, 0x01, 0x40, 0x5B,
  0x0C, 0x77, 0x0A, 0xB0, 0x64, 0x09, 0xB0, 0x77, 0x70, 0x5B, 0x0B, 0x40, 0xCB, 0x03, 0x77, 0x02,
  0xB0, 0xE4, 0x0E, 0xB0, 0x27, 0x71, 0xC4, 0x0D, 0xB0, 0x27, 0x70, 0x1C, 0x40, 0xCB, 0x04, 0x77,
  0x02, 0xB0, 0xE4, 0x09, 0xB0, 0x87, 0x70, 0x6B, 0x0B, 0x40, 0x4B, 0x0D, 0x77, 0x0C, 0xB0, 0x75,
  0x0D, 0xB0, 0x87, 0x50, 0x5C, 0x01, 0x50, 0x6C, 0x06, 0x73, 0x04, 0xC0, 0x87, 0x0E, 0xC0, 0xA0,
  0x26, 0x01, 0x09, 0xD0, 0x16, 0x0A, 0xF8, 0x4C, 0x87, 0x68, 0xBF, 0x0A, 0x50, 0x9F, 0xFF, 0x90,
  0x93, 0x08, 0xD0, 0xDF, 0xFC, 0x81, 0x70, 0x6D, 0x82, 0x60, 0x7E, 0xFA, 0x81, 0x91, 0x9D, 0x81,
  0x62, 0xDB, 0x06, 0x48, 0x75, 0xAD, 0xEF, 0xDB, 0x71, 0x30, 0x8B, 0x85, 0xE2, 0x02, 0xDF, 0x67,
  0x74, 0x82, 0x7F, 0xE3, 0x30, 0x20, 0x67, 0x76, 0x06, 0x03, 0x20,
  // "¥" (U+00A5)
  0x09, 0xC0, 0xE7, 0x76, 0x0D, 0xC0, 0x90, 0x2D, 0x07, 0x77, 0x40, 0x6D, 0x81, 0x10, 0x8C, 0x0E,
  0x77, 0x40, 0xDC, 0x08, 0x20, 0x10, 0xEC, 0x07, 0x77, 0x20, 0x6C, 0x0E, 0x01, 0x30, 0x7C, 0x0E,
  0x77, 0x20, 0xEC, 0x07, 0x50, 0xEC, 0x07, 0x77, 0x07, 0xC0, 0xD6, 0x06, 0xC0, 0xE0, 0x17, 0x50,
  0x10, 0xEC, 0x05, 0x70, 0xDC, 0x07, 0x75, 0x08, 0xC0, 0xC7, 0x10, 0x5C, 0x0E, 0x01, 0x73, 0x01,
  0x0E, 0xC0, 0x47, 0x20, 0xCC, 0x08, 0x73, 0x08, 0xC0, 0xB7, 0x30, 0x4C, 0x0E, 0x01, 0x71, 0x01,
  0xD0, 0x37, 0x40, 0xBC, 0x08, 0x71, 0x09, 0xC0, 0x97, 0x50, 0x3C, 0x0E, 0x01, 0x60, 0x2D, 0x01,
  0x76, 0x0A, 0xC0, 0x86, 0x09, 0xC0, 0x87, 0x70, 0x2D, 0x01, 0x40, 0x2C, 0x0E, 0x01, 0x77, 0x10,
  0x9C, 0x09, 0x40, 0xAC, 0x07, 0x77, 0x20, 0x1D, 0x01, 0x20, 0x3C, 0x0D, 0x77, 0x40, 0x8C, 0x09,
  0x20, 0xBC, 0x05, 0x77, 0x40, 0x10, 0xEC, 0x02, 0x03, 0xC0, 0xC7, 0x76, 0x07, 0xC0, 0x90, 0xBC,
  0x04, 0x77, 0x70, 0xEF, 0x90, 0xB7, 0x71, 0x01, 0x80, 0x26, 0x0B, 0xF9, 0x09, 0x80, 0x26, 0x01,
  0x71, 0x04, 0xFF, 0xF9, 0x04, 0x71, 0x04, 0xFF, 0xF9, 0x04, 0x71, 0x04, 0xFF, 0xF9, 0x04, 0x71,
  0x04, 0xFF, 0xF9, 0x04, 0x77, 0x30, 0x9C, 0x08, 0x77, 0x75, 0x09, 0xC0, 0x87, 0x77, 0x50, 0x9C,
  0x08, 0x77, 0x75, 0x09, 0xC0, 0x87, 0x77, 0x50, 0x9C, 0x08, 0x77, 0x30, 0x4F, 0xFF, 0x90, 0x47,
  0x10, 0x4F, 0xFF, 0x90, 0x47, 0x10, 0x4F, 0xFF, 0x90, 0x47, 0x10, 0x4F, 0xFF, 0x90, 0x47, 0x10,
  0x18, 0x04, 0x60, 0xCC, 0x0B, 0x80, 0x46, 0x01, 0x77, 0x30, 0x9C, 0x08, 0x77, 0x75, 0x09, 0xC0,
  0x87, 0x77, 0x50, 0x9C, 0x08, 0x77, 0x75, 0x09, 0xC0, 0x87, 0x77, 0x50, 0x9C, 0x08, 0x77, 0x75,
  0x09, 0xC0, 0x87, 0x77, 0x50, 0x9C, 0x08, 0x76,
  // "¦" (U+00A6)
  0x03, 0xC0, 0x20, 0x3C, 0x02, 0x03, 0xC0, 0x20, 0x3C, 0x02, 0x03, 0xC0, 0x20, 0x3C, 0x02, 0x03,
  0xC0, 0x20, 0x3C, 0x02, 0x03, 0xC0, 0x20, 0x3C, 0x02, 0x03, 0xC0, 0x20, 0x3C, 0x02, 0x03, 0xC0,
  0x20, 0x3C, 0x02, 0x03, 0xC0, 0x20, 0x3C, 0x02, 0x03, 0xC0, 0x20, 0x3C, 0x02, 0x03, 0xC0, 0x20,
  0x3C, 0x02, 0x03, 0xC0, 0x20, 0x3C, 0x02, 0x03, 0xC0, 0x28, 0x09, 0xA0, 0x00, 0x3C, 0x02, 0x03,
  0xC0, 0x20, 0x3C, 0x02, 0x03, 0xC0, 0x20, 0x3C, 0x02, 0x03, 0xC0, 0x20, 0x3C, 0x02, 0x03, 0xC0,
  0x20, 0x3C, 0x02, 0x03, 0xC0, 0x20, 0x3C, 0x02, 0x03, 0xC0, 0x20, 0x3C, 0x02, 0x03, 0xC0, 0x20,
  0x3C, 0x02, 0x03, 0xC0, 0x20, 0x3C, 0x02, 0x03, 0xC0, 0x20, 0x3C, 0x02, 0x03, 0xC0, 0x20, 0x3C,
  0x02, 0x03, 0xC0, 0x20, 0x3C, 0x02,
  // "§" (U+00A7)
  0x78, 0x35, 0x9B, 0xDE, 0xA8, 0x3E, 0xDB, 0x84, 0x72, 0x01, 0x09, 0xFE, 0x81, 0xEA, 0x45, 0x04,
  0x0E, 0xFF, 0xB0, 0xA3, 0x04, 0xFF, 0xD0, 0x63, 0x0D, 0xD8, 0x7E, 0xA8, 0x76, 0x78, 0x9C, 0xD0,
  0x12, 0x05, 0xD0, 0x77, 0x38, 0x26, 0xCF, 0xB3, 0x0A, 0xC0, 0x87, 0x60, 0x40, 0x33, 0x0B, 0xC0,
  0x27, 0x74, 0x0B, 0xC0, 0x37, 0x74, 0x09, 0xC0, 0x87, 0x74, 0x06, 0xD0, 0x57, 0x74, 0x0E, 0xD0,
  0xA0, 0x17, 0x72, 0x05, 0xF0, 0x90, 0x27, 0x71, 0x07, 0xF9, 0x0B, 0x05, 0x77, 0x04, 0x0E, 0xF9,
  0x81, 0xE8, 0x27, 0x50, 0x9F, 0xC0, 0xA0, 0x17, 0x10, 0x20, 0xDF, 0xF0, 0x76, 0x02, 0x0E, 0xB8,
  0x4E, 0x71, 0x38, 0xEF, 0x0B, 0x01, 0x40, 0xDB, 0x0D, 0x02, 0x50, 0x50, 0xBE, 0x0C, 0x30, 0x6B,
  0x0E, 0x02, 0x71, 0x04, 0x0D, 0xD0, 0x82, 0x0B, 0xB0, 0x87, 0x40, 0xAC, 0x0E, 0x20, 0xEB, 0x05,
  0x75, 0x0C, 0xC0, 0x31, 0xC0, 0x57, 0x50, 0x4C, 0x81, 0x50, 0xEB, 0x08, 0x75, 0x01, 0xC8, 0x15,
  0x0B, 0xB0, 0xE0, 0x17, 0x5C, 0x81, 0x40, 0x6C, 0x0C, 0x01, 0x73, 0x02, 0xC0, 0x12, 0x0C, 0xC0,
  0xD0, 0x57, 0x20, 0x8B, 0x0B, 0x30, 0x20, 0xDD, 0x0C, 0x04, 0x60, 0x5C, 0x03, 0x40, 0x10, 0xCE,
  0x81, 0xC6, 0x12, 0x06, 0xC0, 0x67, 0x06, 0x0D, 0xE8, 0x1E, 0x9B, 0xC0, 0x77, 0x30, 0x60, 0xDF,
  0xB0, 0x37, 0x60, 0x30, 0xAF, 0x90, 0xB0, 0x27, 0x78, 0x11, 0x7D, 0xE0, 0xE0, 0x27, 0x72, 0x05,
  0x0D, 0xD0, 0xD0, 0x17, 0x73, 0x07, 0xD0, 0x97, 0x74, 0x05, 0xC0, 0xE7, 0x75, 0x0D, 0xC0, 0x37,
  0x74, 0x09, 0xC0, 0x47, 0x74, 0x0A, 0xC0, 0x40, 0x17, 0x72, 0x02, 0xD8, 0x32, 0x7E, 0x93, 0x75,
  0x02, 0x0D, 0xC8, 0x1D, 0x07, 0xB8, 0x3E, 0x96, 0x31, 0x48, 0x11, 0x49, 0xE8, 0x17, 0x07, 0xFA,
  0x00, 0xEF, 0xA0, 0xC2, 0x07, 0xFF, 0xD0, 0xB0, 0x12, 0x02, 0x0B, 0xFF, 0xA0, 0xE0, 0x76, 0x81,
  0x38, 0xCF, 0xC8, 0x1B, 0x61, 0x74, 0x87, 0x35, 0x67, 0x77, 0x65, 0x27, 0x20,
  // "¨" (U+00A8)
  0x18, 0x38, 0xDE, 0xB2, 0x71, 0x86, 0x2A, 0xEE, 0x91, 0x0A, 0xC0, 0xE0, 0x17, 0x0D, 0xC0, 0xB1,
  0xE0, 0x56, 0x03, 0xE0, 0x1E, 0x06, 0x60, 0x4E, 0x02, 0x0E, 0xD0, 0x46, 0x02, 0xE1, 0x08, 0xC0,
  0xD7, 0x10, 0xCC, 0x09, 0x28, 0x37, 0xDE, 0xA2, 0x71, 0x83, 0x1A, 0xED, 0x82,
  // "©" (U+00A9)
  0x73, 0x89, 0x21, 0x59, 0xBD, 0xEE, 0xDC, 0x96, 0x27, 0x74, 0x03, 0x0B, 0xFD, 0x0C, 0x05, 0x77,
  0x01, 0x0A, 0xFF, 0xA0, 0xC0, 0x27, 0x40, 0x30, 0xEC, 0x82, 0xA6, 0x31, 0x28, 0x22, 0x37, 0xBD,
  0x05, 0x72, 0x04, 0xC0, 0x90, 0x17, 0x30, 0x20, 0xAC, 0x05, 0x70, 0x20, 0xEA, 0x0E, 0x03, 0x77,
  0x05, 0x0E, 0xB0, 0x36, 0x0C, 0xA0, 0xD0, 0x14, 0x87, 0x17, 0xBD, 0xFE, 0xC9, 0x53, 0x02, 0x0E,
  0xA0, 0xD5, 0x06, 0xB0, 0x34, 0x05, 0x0E, 0xF9, 0x0B, 0x30, 0x4B, 0x07, 0x40, 0xDA, 0x07, 0x40,
  0x6F, 0xB0, 0x54, 0x09, 0xA0, 0xE3, 0x05, 0xA0, 0xE4, 0x02, 0xB8, 0x6E, 0x72, 0x01, 0x38, 0xC5,
  0x01, 0xB0, 0x52, 0x0A, 0xA0, 0x84, 0x0B, 0xA0, 0xE0, 0x37, 0x60, 0x9A, 0x0A, 0x20, 0xEA, 0x04,
  0x30, 0x2B, 0x07, 0x77, 0x05, 0xA8, 0x1E, 0x01, 0xB4, 0x07, 0xB0, 0x17, 0x70, 0x1B, 0x01, 0x03,
  0xA0, 0xE4, 0x0A, 0xA0, 0xC7, 0x72, 0x0E, 0xA0, 0x30, 0x4A, 0x0D, 0x40, 0xCA, 0x0A, 0x77, 0x20,
  0xDA, 0x04, 0x05, 0xA0, 0xC4, 0x0D, 0xA0, 0x97, 0x72, 0x0C, 0xA0, 0x50, 0x4A, 0x0C, 0x40, 0xCA,
  0x0A, 0x77, 0x20, 0xDA, 0x00, 0x4A, 0x0D, 0x40, 0xBA, 0x0B, 0x77, 0x20, 0xEA, 0x03, 0x02, 0xB4,
  0x08, 0xA0, 0xE7, 0x72, 0xB8, 0x11, 0x0E, 0xA0, 0x43, 0x04, 0xB0, 0x57, 0x70, 0x4A, 0x0E, 0x20,
  0xBA, 0x09, 0x40, 0xDA, 0x0D, 0x01, 0x76, 0x08, 0xA0, 0xA2, 0x06, 0xA0, 0xE4, 0x05, 0xB8, 0x1D,
  0x51, 0x28, 0x22, 0x5A, 0x25, 0x0D, 0xA0, 0x52, 0x01, 0x0E, 0xA0, 0x74, 0x09, 0xFB, 0x02, 0x40,
  0x6A, 0x0E, 0x40, 0x8B, 0x02, 0x40, 0x8F, 0xA0, 0x23, 0x02, 0x0E, 0xA0, 0x74, 0x01, 0x0E, 0xA0,
  0xD0, 0x14, 0x87, 0x28, 0xCE, 0xFE, 0xC9, 0x44, 0x0C, 0xA0, 0xD6, 0x04, 0xB0, 0xD0, 0x27, 0x70,
  0x20, 0xDB, 0x03, 0x70, 0x7C, 0x07, 0x75, 0x07, 0x0E, 0xB0, 0x57, 0x20, 0x6C, 0x82, 0xE9, 0x41,
  0x48, 0x21, 0x48, 0xEB, 0x0E, 0x04, 0x74, 0x03, 0x0D, 0xE8, 0x1E, 0xDD, 0xF0, 0xB0, 0x27, 0x70,
  0x60, 0xDF, 0xD0, 0xC0, 0x57, 0x74, 0x83, 0x37, 0xAD, 0xEA, 0x83, 0xEC, 0xA7, 0x27, 0x30,
  // "ª" (U+00AA)
  0x38, 0x34, 0x7A, 0xDE, 0xA8, 0x2E, 0xB7, 0x24, 0x05, 0x0E, 0xFC, 0x07, 0x30, 0x3C, 0x83, 0xDB,
  0xAB, 0xEC, 0x07, 0x38, 0x2B, 0xE8, 0x25, 0x06, 0xC0, 0x12, 0x01, 0x72, 0x07, 0xB0, 0x67, 0x50,
  0x2B, 0x09, 0x76, 0xB0, 0xA7, 0x6B, 0x0A, 0x48, 0x35, 0x9C, 0xEE, 0xF0, 0xA2, 0x07, 0x0E, 0xFD,
  0x81, 0xA0, 0x9D, 0x84, 0xCB, 0xA9, 0x9A, 0xB0, 0xA0, 0x4C, 0x07, 0x01, 0x6B, 0x0A, 0x09, 0xB0,
  0x77, 0x01, 0xB0, 0xA0, 0xCB, 0x01, 0x70, 0x3B, 0x0A, 0x0D, 0xB7, 0x10, 0x7B, 0x0A, 0x0B, 0xB0,
  0x16, 0x02, 0x0E, 0xB0, 0xA0, 0x8B, 0x0A, 0x01, 0x40, 0x40, 0xDC, 0x81, 0xA1, 0xEB, 0x83, 0xEB,
  0xAB, 0xDA, 0x00, 0xEA, 0x82, 0xA0, 0x4E, 0xF9, 0x81, 0xA1, 0x8A, 0x0A, 0x28, 0x71, 0x8C, 0xEF,
  0xEC, 0x82, 0x28, 0x22, 0xAA, 0x70,
  // "«" (U+00AB)
  0x73, 0x05, 0x74, 0x04, 0x75, 0x82, 0x6F, 0xB1, 0x71, 0x81, 0xAF, 0x97, 0x30, 0x4B, 0x0E, 0x04,
  0x60, 0x8B, 0x0D, 0x02, 0x70, 0x20, 0xEC, 0x09, 0x50, 0x5D, 0x03, 0x70, 0xCC, 0x0C, 0x50, 0x30,
  0xEC, 0x06, 0x70, 0xAC, 0x0D, 0x01, 0x40, 0x10, 0xDC, 0x09, 0x70, 0x8D, 0x03, 0x50, 0xCC, 0x0C,
  0x70, 0x5D, 0x05, 0x50, 0x9C, 0x0E, 0x01, 0x60, 0x30, 0xEC, 0x08, 0x50, 0x7D, 0x03, 0x60, 0x10,
  0xDC, 0x0B, 0x50, 0x4D, 0x06, 0x70, 0xBC, 0x0D, 0x01, 0x40, 0x20, 0xEC, 0x09, 0x70, 0x9C, 0x0E,
  0x02, 0x40, 0x10, 0xDC, 0x0C, 0x70, 0x6D, 0x05, 0x50, 0xBC, 0x0E, 0x01, 0x70, 0x9C, 0x0E, 0x02,
  0x50, 0xEC, 0x0B, 0x72, 0x0D, 0xC0, 0xC5, 0x04, 0xD0, 0x87, 0x10, 0x20, 0xEC, 0x0A, 0x50, 0x6D,
  0x05, 0x71, 0x04, 0xD0, 0x65, 0x09, 0xC0, 0xE0, 0x37, 0x10, 0x6D, 0x03, 0x50, 0xBC, 0x0D, 0x01,
  0x71, 0x09, 0xC0, 0xE0, 0x14, 0x01, 0x0D, 0xC0, 0xB7, 0x20, 0xBC, 0x0C, 0x50, 0x20, 0xEC, 0x08,
  0x71, 0x01, 0x0D, 0xC0, 0x95, 0x04, 0xD0, 0x57, 0x10, 0x20, 0xEC, 0x06, 0x50, 0x6C, 0x0E, 0x02,
  0x71, 0x04, 0xD0, 0x35, 0x09, 0xC0, 0xD0, 0x17, 0x10, 0x7C, 0x09, 0x60, 0xBC, 0x05, 0x72, 0x82,
  0xAF, 0xE5, 0x78, 0x31, 0xDF, 0xD3, 0x74, 0x09, 0x01, 0x72, 0x81, 0x29, 0x12,
  // "¬" (U+00AC)
  0x03, 0x80, 0xA5, 0x60, 0x50, 0x7F, 0xFF, 0xC0, 0xE0, 0x7F, 0xFF, 0xC0, 0xE0, 0x7F, 0xFF, 0xC0,
  0xE0, 0x7F, 0xFF, 0xC0, 0xE7, 0x77, 0x10, 0x5B, 0x0E, 0x77, 0x71, 0x05, 0xB0, 0xE7, 0x77, 0x10,
  0x5B, 0x0E, 0x77, 0x71, 0x05, 0xB0, 0xE7, 0x77, 0x10, 0x5B, 0x0E, 0x77, 0x71, 0x05, 0xB0, 0xE7,
  0x77, 0x10, 0x5B, 0x0E, 0x77, 0x71, 0x05, 0xB0, 0xE7, 0x77, 0x10, 0x5B, 0x0E, 0x77, 0x71, 0x05,
  0xB0, 0xE7, 0x77, 0x10, 0x5B, 0x0E, 0x77, 0x71, 0x83, 0x27, 0x77, 0x60,
  // "®" (U+00AE)
  0x73, 0x89, 0x21, 0x59, 0xBD, 0xEE, 0xDC, 0x96, 0x27, 0x74, 0x03, 0x0B, 0xFD, 0x0C, 0x05, 0x77,
  0x01, 0x0A, 0xFF, 0xA0, 0xC0, 0x27, 0x40, 0x30, 0xEC, 0x82, 0xA6, 0x31, 0x28, 0x22, 0x37, 0xBD,
  0x05, 0x72, 0x04, 0xC0, 0x90, 0x17, 0x30, 0x20, 0xAC, 0x05, 0x70, 0x20, 0xEA, 0x0E, 0x03, 0x77,
  0x05, 0x0E, 0xB0, 0x36, 0x0C, 0xA0, 0xD0, 0x12, 0x06, 0xD8, 0x2E, 0xDA, 0x54, 0x02, 0x0E, 0xA0,
  0xD5, 0x06, 0xB0, 0x33, 0x06, 0xFA, 0x0B, 0x40, 0x4B, 0x07, 0x40, 0xDA, 0x07, 0x40, 0x6A, 0x82,
  0xED, 0xDE, 0xC0, 0x94, 0x09, 0xA0, 0xE3, 0x05, 0xA0, 0xE5, 0x06, 0xA0, 0xA3, 0x02, 0x0B, 0xB0,
  0x13, 0x01, 0xB0, 0x52, 0x0A, 0xA0, 0x85, 0x06, 0xA0, 0xA5, 0x0E, 0xA0, 0x54, 0x09, 0xA0, 0xA2,
  0x0E, 0xA0, 0x45, 0x06, 0xA0, 0xA5, 0x0A, 0xA0, 0x74, 0x05, 0xA8, 0x1E, 0x01, 0xB6, 0x06, 0xA0,
  0xA5, 0x0B, 0xA0, 0x64, 0x01, 0xB0, 0x10, 0x3A, 0x0E, 0x60, 0x6A, 0x0A, 0x40, 0x20, 0xEA, 0x03,
  0x50, 0xEA, 0x03, 0x04, 0xA0, 0xD6, 0x06, 0xA0, 0xA2, 0x81, 0x15, 0xDA, 0x0D, 0x60, 0xDA, 0x04,
  0x05, 0xA0, 0xC6, 0x06, 0xFA, 0x0E, 0x02, 0x60, 0xCA, 0x05, 0x04, 0xA0, 0xC6, 0x06, 0xF9, 0x0C,
  0x02, 0x70, 0xDA, 0x00, 0x4A, 0x0D, 0x60, 0x6A, 0x82, 0xED, 0xDE, 0xA0, 0x77, 0x10, 0xEA, 0x03,
  0x02, 0xB6, 0x06, 0xA0, 0xA2, 0x05, 0xB0, 0x27, 0xB8, 0x11, 0x0E, 0xA0, 0x45, 0x06, 0xA0, 0xA3,
  0x0C, 0xA0, 0xB6, 0x04, 0xA0, 0xE2, 0x0B, 0xA0, 0x95, 0x06, 0xA0, 0xA3, 0x03, 0xB0, 0x55, 0x08,
  0xA0, 0xA2, 0x06, 0xA0, 0xE5, 0x06, 0xA0, 0xA4, 0x09, 0xA0, 0xE0, 0x14, 0x0D, 0xA0, 0x52, 0x01,
  0x0E, 0xA0, 0x74, 0x06, 0xA0, 0xA4, 0x01, 0x0E, 0xA0, 0x93, 0x06, 0xA0, 0xE4, 0x08, 0xB0, 0x23,
  0x06, 0xA0, 0xA5, 0x06, 0xB8, 0x23, 0x02, 0xEA, 0x07, 0x40, 0x10, 0xEA, 0x0D, 0x01, 0x28, 0x25,
  0xCC, 0x86, 0x84, 0xBC, 0xCA, 0x0C, 0xA0, 0xD6, 0x04, 0xB0, 0xD0, 0x27, 0x70, 0x20, 0xDB, 0x03,
  0x70, 0x7C, 0x07, 0x75, 0x07, 0x0E, 0xB0, 0x57, 0x20, 0x6C, 0x82, 0xE9, 0x41, 0x48, 0x21, 0x48,
  0xEB, 0x0E, 0x04, 0x74, 0x03, 0x0D, 0xE8, 0x1E, 0xDD, 0xF0, 0xB0, 0x27, 0x70, 0x60, 0xDF, 0xD0,
  0xC0, 0x57, 0x74, 0x83, 0x37, 0xAD, 0xEA, 0x83, 0xEC, 0xA7, 0x27, 0x30,
  // "¯" (U+00AF)
  0x05, 0x80, 0x94, 0x60, 0x50, 0xDF, 0xFA, 0x0E, 0x0D, 0xFF, 0xA0, 0xE0, 0xDF, 0xFA, 0x0E, 0x0D,
  0xFF, 0xA0, 0xE0,
  // "°" (U+00B0)
  0x58, 0x14, 0xAD, 0xA8, 0x1D, 0xA5, 0x71, 0x02, 0x0C, 0xF9, 0x0C, 0x02, 0x50, 0x40, 0xEF, 0xB0,
  0xE0, 0x53, 0x02, 0x0E, 0xFD, 0x0E, 0x02, 0x20, 0xDB, 0x81, 0xE8, 0x32, 0x81, 0x27, 0xEB, 0x81,
  0xD0, 0x5B, 0x0D, 0x02, 0x60, 0x10, 0xDB, 0x05, 0x0B, 0xB0, 0x37, 0x10, 0x2B, 0x0B, 0x0E, 0xA0,
  0xC7, 0x30, 0xBA, 0x0E, 0xB0, 0x97, 0x30, 0x9E, 0x09, 0x73, 0x09, 0xB0, 0xEA, 0x0C, 0x73, 0x0B,
  0xA0, 0xE0, 0xBB, 0x04, 0x71, 0x02, 0xB0, 0xB0, 0x6B, 0x0E, 0x03, 0x60, 0x10, 0xDB, 0x81, 0x60,
  0xDC, 0x09, 0x03, 0x28, 0x12, 0x7E, 0xB0, 0xE2, 0x04, 0xFF, 0x04, 0x30, 0x6F, 0xD0, 0x65, 0x04,
  0x0D, 0xF9, 0x0D, 0x03, 0x71, 0x86, 0x5A, 0xDE, 0xFD, 0xA5, 0x50,
  // "±" (U+00B1)
  0x74, 0x04, 0xC7, 0x77, 0x20, 0x4C, 0x77, 0x72, 0x04, 0xC7, 0x77, 0x20, 0x4C, 0x77, 0x72, 0x04,
  0xC7, 0x77, 0x20, 0x4C, 0x77, 0x72, 0x04, 0xC7, 0x77, 0x20, 0x4C, 0x77, 0x72, 0x04, 0xC7, 0x77,
  0x20, 0x4C, 0x77, 0x72, 0x04, 0xC7, 0x77, 0x20, 0x4C, 0x75, 0x02, 0x80, 0x66, 0x08, 0xC8, 0x07,
  0x60, 0x10, 0x6F, 0xFF, 0xD0, 0x30, 0x6F, 0xFF, 0xD0, 0x30, 0x6F, 0xFF, 0xD0, 0x30, 0x6F, 0xFF,
  0xD0, 0x37, 0x40, 0x4C, 0x77, 0x72, 0x04, 0xC7, 0x77, 0x20, 0x4C, 0x77, 0x72, 0x04, 0xC7, 0x77,
  0x20, 0x4C, 0x77, 0x72, 0x04, 0xC7, 0x77, 0x20, 0x4C, 0x77, 0x72, 0x04, 0xC7, 0x77, 0x20, 0x4C,
  0x77, 0x72, 0x04, 0xC7, 0x77, 0x20, 0x4C, 0x80, 0x9B, 0x40, 0x01, 0x80, 0xA6, 0x60, 0x10, 0x3F,
  0xFF, 0xD0, 0x03, 0xFF, 0xFD, 0x00, 0x3F, 0xFF, 0xD0, 0x03, 0xFF, 0xFD, 0x03,
  // "²" (U+00B2)
  0x48, 0x90, 0x16, 0xBD, 0xEF, 0xEB, 0x72, 0x70, 0x10, 0x9F, 0xB0, 0x85, 0x04, 0x0E, 0xFD, 0x0B,
  0x30, 0x2D, 0x83, 0xEB, 0x99, 0xBD, 0x07, 0x30, 0x9A, 0x0E, 0x06, 0x50, 0x20, 0xCB, 0x0E, 0x48,
  0x1C, 0xA1, 0x70, 0x2C, 0x03, 0x30, 0x17, 0x30, 0xCB, 0x05, 0x77, 0x0B, 0xB0, 0x57, 0x70, 0xCB,
  0x03, 0x76, 0x01, 0xC7, 0x70, 0x8B, 0x0A, 0x76, 0x03, 0xC0, 0x27, 0x50, 0x20, 0xEB, 0x07, 0x75,
  0x01, 0x0D, 0xB0, 0xA7, 0x50, 0x10, 0xDB, 0x0B, 0x75, 0x02, 0x0D, 0xB0, 0xB7, 0x50, 0x20, 0xDB,
  0x0B, 0x75, 0x02, 0x0E, 0xB0, 0xA7, 0x50, 0x20, 0xEB, 0x0A, 0x75, 0x03, 0x0E, 0xB0, 0x97, 0x50,
  0x30, 0xEB, 0x08, 0x75, 0x03, 0x0E, 0xB0, 0x87, 0x50, 0x40, 0xEB, 0x0D, 0x80, 0x90, 0x80, 0x20,
  0xAF, 0xFB, 0x04, 0x0A, 0xFF, 0xB0, 0x40, 0xAF, 0xFB, 0x04,
  // "³" (U+00B3)
  0x58, 0x51, 0x56, 0x87, 0x63, 0x72, 0x05, 0x0C, 0xF8, 0x1E, 0x91, 0x40, 0x30, 0xDF, 0xC0, 0xD0,
  0x22, 0x04, 0xFF, 0x0D, 0x30, 0xBB, 0x85, 0xA5, 0x10, 0x15, 0xDC, 0x06, 0x28, 0x21, 0xDA, 0x27,
  0x0D, 0xB0, 0xB7, 0x60, 0x8B, 0x0D, 0x76, 0x06, 0xB0, 0xD7, 0x60, 0x8B, 0x0C, 0x75, 0x01, 0x0E,
  0xB0, 0x77, 0x40, 0x20, 0xCB, 0x0E, 0x01, 0x48, 0x51, 0x88, 0x88, 0x9C, 0xC0, 0xE0, 0x35, 0x03,
  0xFA, 0x0B, 0x02, 0x60, 0x3F, 0xA0, 0x90, 0x46, 0x03, 0xFC, 0x0A, 0x73, 0x82, 0x13, 0x6D, 0xC0,
  0x97, 0x60, 0x9C, 0x02, 0x76, 0x0E, 0xB0, 0x77, 0x60, 0xAB, 0x0A, 0x76, 0x0A, 0xB0, 0xA7, 0x60,
  0xDB, 0x09, 0x04, 0x74, 0x05, 0xC8, 0x35, 0xAE, 0x94, 0x70, 0x50, 0xEB, 0x81, 0xE0, 0xAC, 0x84,
  0xCA, 0x89, 0xAD, 0xD8, 0x16, 0x0A, 0xFF, 0x08, 0x20, 0x40, 0xCF, 0xC0, 0xD0, 0x55, 0x89, 0x13,
  0x7B, 0xDE, 0xFE, 0xDC, 0x94, 0x50,
  // "´" (U+00B4)
  0x60, 0x58, 0x01, 0x70, 0x65, 0x01, 0xE0, 0x95, 0x0A, 0xD0, 0xC5, 0x04, 0xD0, 0xD0, 0x15, 0x0D,
  0xC0, 0xE0, 0x25, 0x08, 0xC0, 0xE0, 0x25, 0x03, 0xC0, 0xE0, 0x36, 0x0D, 0xB0, 0xE0, 0x36, 0x09,
  0xB0, 0xD0, 0x26, 0x03, 0xB0, 0xB0, 0x17,
  // "µ" (U+00B5)
  0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7,
  0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0,
  0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E,
  0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D,
  0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0,
  0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03,
  0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C,
  0x0E, 0x77, 0x10, 0x4D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x04, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10,
  0x6D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x08, 0xD0, 0x30, 0x7D, 0x77, 0x10, 0xBD, 0x03, 0x07, 0xD0,
  0x17, 0x7E, 0x03, 0x07, 0xD0, 0x47, 0x60, 0x5E, 0x03, 0x07, 0xD0, 0x97, 0x60, 0xDE, 0x03, 0x07,
  0xD0, 0xE0, 0x17, 0x40, 0x8F, 0x03, 0x07, 0xE0, 0xC0, 0x17, 0x20, 0x8F, 0x90, 0x30, 0x7F, 0x81,
  0xE7, 0x24, 0x81, 0x27, 0xDB, 0x0D, 0x0E, 0xC0, 0x30, 0x7F, 0xC0, 0x0E, 0xE8, 0x1E, 0x2B, 0xC0,
  0x30, 0x7F, 0xFD, 0x81, 0x40, 0x8C, 0x03, 0x07, 0xFF, 0xB0, 0xD0, 0x32, 0x06, 0xC0, 0x30, 0x7C,
  0x0E, 0x0C, 0xFA, 0x0C, 0x06, 0x40, 0x3C, 0x03, 0x07, 0xC8, 0x91, 0xE0, 0x13, 0x67, 0x77, 0x64,
  0x17, 0x50, 0x7C, 0x0E, 0x77, 0x71, 0x07, 0xC0, 0xE7, 0x77, 0x10, 0x7C, 0x0E, 0x77, 0x71, 0x07,
  0xC0, 0xE7, 0x77, 0x10, 0x7C, 0x0E, 0x77, 0x71, 0x07, 0xC0, 0xE7, 0x77, 0x10, 0x7C, 0x0E, 0x77,
  0x71, 0x07, 0xC0, 0xE7, 0x77, 0x10, 0x7C, 0x0E, 0x77, 0x71, 0x07, 0xC0, 0xE7, 0x77, 0x10, 0x7C,
  0x0E, 0x77, 0x71, 0x07, 0xC0, 0xE7, 0x77, 0x10, 0x7C, 0x0E, 0x77, 0x71,
  // "¶" (U+00B6)
  0x78, 0x34, 0x8B, 0xDE, 0xFF, 0xB0, 0x55, 0x06, 0x0D, 0xFF, 0xF9, 0x05, 0x40, 0xBF, 0xFF, 0xB0,
  0x53, 0x0C, 0xFF, 0x90, 0xB5, 0x02, 0xB0, 0x52, 0x08, 0xFF, 0xA0, 0xB5, 0x02, 0xB8, 0x15, 0x02,
  0xFF, 0xB0, 0xB5, 0x02, 0xB8, 0x15, 0x0A, 0xFF, 0xB0, 0xB5, 0x02, 0xB8, 0x15, 0x0E, 0xFF, 0xB0,
  0xB5, 0x02, 0xB0, 0x50, 0x4F, 0xFC, 0x0B, 0x50, 0x2B, 0x05, 0x08, 0xFF, 0xC0, 0xB5, 0x02, 0xB0,
  0x50, 0xAF, 0xFC, 0x0B, 0x50, 0x2B, 0x05, 0x0C, 0xFF, 0xC0, 0xB5, 0x02, 0xB0, 0x50, 0xEF, 0xFC,
  0x0B, 0x50, 0x2B, 0x05, 0x0E, 0xFF, 0xC0, 0xB5, 0x02, 0xB0, 0x5F, 0xFD, 0x0B, 0x50, 0x2B, 0x05,
  0xFF, 0xD0, 0xB5, 0x02, 0xB0, 0x50, 0xEF, 0xFC, 0x0B, 0x50, 0x2B, 0x05, 0x0E, 0xFF, 0xC0, 0xB5,
  0x02, 0xB0, 0x50, 0xCF, 0xFC, 0x0B, 0x50, 0x2B, 0x05, 0x0A, 0xFF, 0xC0, 0xB5, 0x02, 0xB0, 0x50,
  0x7F, 0xFC, 0x0B, 0x50, 0x2B, 0x05, 0x04, 0xFF, 0xC0, 0xB5, 0x02, 0xB8, 0x15, 0x0E, 0xFF, 0xB0,
  0xB5, 0x02, 0xB8, 0x15, 0x09, 0xFF, 0xB0, 0xB5, 0x02, 0xB8, 0x15, 0x01, 0xFF, 0xB0, 0xB5, 0x02,
  0xB0, 0x52, 0x07, 0xFF, 0xA0, 0xB5, 0x02, 0xB0, 0x53, 0x0A, 0xFF, 0x90, 0xB5, 0x02, 0xB0, 0x54,
  0x08, 0xFF, 0x0B, 0x50, 0x2B, 0x05, 0x58, 0x12, 0x9E, 0xFC, 0x0B, 0x50, 0x2B, 0x05, 0x71, 0x87,
  0x25, 0x67, 0x65, 0x31, 0xBA, 0x0B, 0x50, 0x2B, 0x05, 0x77, 0x20, 0xBA, 0x0B, 0x50, 0x2B, 0x05,
  0x77, 0x20, 0xBA, 0x0B, 0x50, 0x2B, 0x05, 0x77, 0x20, 0xBA, 0x0B, 0x50, 0x2B, 0x05, 0x77, 0x20,
  0xBA, 0x0B, 0x50, 0x2B, 0x05, 0x77, 0x20, 0xBA, 0x0B, 0x50, 0x2B, 0x05, 0x77, 0x20, 0xBA, 0x0B,
  0x50, 0x2B, 0x05, 0x77, 0x20, 0xBA, 0x0B, 0x50, 0x2B, 0x05, 0x77, 0x20, 0xBA, 0x0B, 0x50, 0x2B,
  0x05, 0x77, 0x20, 0xBA, 0x0B, 0x50, 0x2B, 0x05, 0x77, 0x20, 0xBA, 0x0B, 0x50, 0x2B, 0x05, 0x77,
  0x20, 0xBA, 0x0B, 0x50, 0x2B, 0x05, 0x77, 0x20, 0xBA, 0x0B, 0x50, 0x2B, 0x05, 0x77, 0x20, 0xBA,
  0x0B, 0x50, 0x2B, 0x05, 0x77, 0x20, 0xBA, 0x0B, 0x50, 0x2B, 0x05, 0x77, 0x20, 0xBA, 0x0B, 0x50,
  0x2B, 0x05, 0x77, 0x20, 0xBA, 0x0B, 0x50, 0x2B, 0x05, 0x77, 0x20, 0xBA, 0x0B, 0x50, 0x2B, 0x05,
  0x77, 0x20, 0xBA, 0x0B, 0x50, 0x2B, 0x05, 0x77, 0x20, 0xBA, 0x0B, 0x50, 0x2B, 0x05, 0x77, 0x20,
  0xBA, 0x0B, 0x50, 0x2B, 0x05, 0x77, 0x20, 0xBA, 0x0B, 0x50, 0x2B, 0x05, 0x77, 0x20, 0xBA, 0x0B,
  0x50, 0x2B, 0x05, 0x77, 0x20, 0xBA, 0x0B, 0x50, 0x2B, 0x05,
  // "·" (U+00B7)
  0x28, 0x23, 0x66, 0x33, 0x0A, 0xC8, 0x1A, 0x05, 0xE0, 0x50, 0x9E, 0x09, 0x0A, 0xE0, 0xA0, 0x9E,
  0x09, 0x05, 0xE8, 0x15, 0x09, 0xC0, 0x93, 0x82, 0x36, 0x63, 0x20,
  // "¸" (U+00B8)
  0x50, 0x8A, 0x0E, 0x72, 0x0E, 0xA0, 0x87, 0x10, 0x6B, 0x01, 0x71, 0x0D, 0xA0, 0xC7, 0x10, 0x5D,
  0x0A, 0x02, 0x50, 0x9F, 0x06, 0x60, 0x40, 0x9D, 0x03, 0x70, 0x20, 0xEB, 0x09, 0x71, 0x08, 0xB0,
  0xB7, 0x10, 0x7B, 0x0B, 0x71, 0x0B, 0xB8, 0x29, 0x03, 0x12, 0x81, 0x14, 0xAC, 0x03, 0x01, 0xFB,
  0x81, 0x80, 0x1F, 0x90, 0xE0, 0x63, 0x0C, 0x0E, 0xA8, 0x3E, 0xCA, 0x61, 0x30,
  // "¹" (U+00B9)
  0x78, 0x34, 0x77, 0x76, 0x75, 0x02, 0x0A, 0xC0, 0xD7, 0x40, 0x8E, 0x0D, 0x72, 0x05, 0x0E, 0xF0,
  0xD7, 0x03, 0x0C, 0xD0, 0xEB, 0x0D, 0x70, 0xDD, 0x81, 0xC2, 0xEA, 0x0D, 0x70, 0x4B, 0x0E, 0x07,
  0x2B, 0x0D, 0x71, 0x82, 0xAF, 0x81, 0x3B, 0x0D, 0x71, 0x00, 0x15, 0xB0, 0xD7, 0x71, 0xB0, 0xD7,
  0x71, 0xB0, 0xD7, 0x71, 0xB0, 0xD7, 0x71, 0xB0, 0xD7, 0x71, 0xB0, 0xD7, 0x71, 0xB0, 0xD7, 0x71,
  0xB0, 0xD7, 0x71, 0xB0, 0xD7, 0x71, 0xB0, 0xD7, 0x71, 0xB0, 0xD7, 0x71, 0xB0, 0xD7, 0x71, 0xB0,
  0xD7, 0x71, 0xB0, 0xD7, 0x10, 0x18, 0x02, 0x8B, 0x0E, 0x80, 0x28, 0x81, 0x20, 0x3F, 0xFA, 0x81,
  0x40, 0x3F, 0xFA, 0x81, 0x40, 0x3F, 0xFA, 0x04,
  // "º" (U+00BA)
  0x58, 0x65, 0xAD, 0xEE, 0xDA, 0x57, 0x10, 0x40, 0xDF, 0x90, 0xD0, 0x35, 0x05, 0xC8, 0x2D, 0xAA,
  0xDC, 0x04, 0x30, 0x20, 0xEA, 0x0E, 0x04, 0x40, 0x40, 0xEA, 0x0E, 0x02, 0x20, 0xBB, 0x04, 0x60,
  0x3B, 0x81, 0xA0, 0x2B, 0x0B, 0x71, 0x0B, 0xB0, 0x10, 0x6B, 0x05, 0x71, 0x06, 0xB0, 0x50, 0x9B,
  0x02, 0x71, 0x04, 0xB0, 0x80, 0xBB, 0x72, 0x02, 0xB0, 0xA0, 0xCB, 0x72, 0x01, 0xB0, 0xB0, 0xCB,
  0x72, 0x01, 0xB0, 0x0B, 0xB7, 0x20, 0x2B, 0x0A, 0x09, 0xB0, 0x27, 0x10, 0x4B, 0x08, 0x06, 0xB0,
  0x57, 0x10, 0x7B, 0x05, 0x02, 0xB0, 0xA7, 0x10, 0xCB, 0x81, 0x10, 0xBB, 0x02, 0x60, 0x4B, 0x0A,
  0x20, 0x20, 0xEA, 0x0D, 0x03, 0x40, 0x40, 0xEA, 0x0E, 0x02, 0x30, 0x5C, 0x82, 0xCA, 0xAD, 0xC0,
  0x45, 0x04, 0x0D, 0xF9, 0x0D, 0x03, 0x71, 0x86, 0x6A, 0xDF, 0xED, 0xA5, 0x50,
  // "»" (U+00BB)
  0x28, 0x11, 0x92, 0x72, 0x01, 0x09, 0x74, 0x83, 0x3D, 0xFD, 0x17, 0x82, 0x5E, 0xFA, 0x72, 0x05,
  0xC0, 0xB6, 0x09, 0xC0, 0x77, 0x10, 0x10, 0xDC, 0x09, 0x50, 0x3D, 0x04, 0x71, 0x02, 0x0E, 0xC0,
  0x65, 0x06, 0xC0, 0xE0, 0x27, 0x10, 0x5D, 0x04, 0x50, 0x9C, 0x0D, 0x01, 0x71, 0x08, 0xC0, 0xE0,
  0x25, 0x0C, 0xC0, 0xB7, 0x20, 0xBC, 0x0D, 0x01, 0x40, 0x10, 0xEC, 0x09, 0x71, 0x01, 0x0D, 0xC0,
  0xB5, 0x03, 0xD0, 0x67, 0x10, 0x30, 0xEC, 0x09, 0x50, 0x6D, 0x04, 0x71, 0x05, 0xD0, 0x65, 0x0A,
  0xC0, 0xE0, 0x27, 0x10, 0x8D, 0x04, 0x50, 0xCC, 0x0D, 0x72, 0x0C, 0xC0, 0xE5, 0x02, 0x0E, 0xC0,
  0x97, 0x01, 0x0E, 0xC0, 0xB5, 0x05, 0xD0, 0x67, 0x0C, 0xC0, 0xD0, 0x14, 0x02, 0x0E, 0xC0, 0x97,
  0x09, 0xC0, 0xE0, 0x24, 0x01, 0x0D, 0xC0, 0xB7, 0x06, 0xD0, 0x45, 0x0B, 0xC0, 0xD0, 0x16, 0x03,
  0xD0, 0x75, 0x08, 0xC0, 0xE0, 0x36, 0x01, 0x0E, 0xC0, 0x95, 0x05, 0xD0, 0x57, 0x0C, 0xC0, 0xC5,
  0x03, 0xD0, 0x87, 0x09, 0xC0, 0xD0, 0x14, 0x01, 0x0D, 0xC0, 0xA7, 0x06, 0xC0, 0xE0, 0x35, 0x0C,
  0xC0, 0xC7, 0x03, 0xD0, 0x55, 0x09, 0xC0, 0xE0, 0x27, 0x02, 0x0D, 0xB0, 0x76, 0x04, 0x0E, 0xB0,
  0x47, 0x38, 0x19, 0xFA, 0x71, 0x82, 0x1B, 0xF6, 0x75, 0x04, 0x74, 0x05, 0x73,
  // "¼" (U+00BC)
  0x50, 0x70, 0xEB, 0x06, 0x77, 0x10, 0x1C, 0x07, 0x60, 0x40, 0xDD, 0x06, 0x77, 0x10, 0x9B, 0x0E,
  0x50, 0x20, 0xBF, 0x06, 0x77, 0x02, 0xC0, 0x64, 0x06, 0xFA, 0x06, 0x77, 0x0A, 0xB0, 0xD5, 0x03,
  0xC0, 0xE0, 0x9B, 0x06, 0x76, 0x02, 0xC0, 0x66, 0x09, 0xA8, 0x1B, 0x16, 0xB0, 0x67, 0x60, 0xAB,
  0x0D, 0x78, 0x11, 0xC4, 0x20, 0x6B, 0x06, 0x75, 0x03, 0xC0, 0x57, 0x50, 0x6B, 0x06, 0x75, 0x0B,
  0xB0, 0xC7, 0x60, 0x7B, 0x06, 0x74, 0x03, 0xC0, 0x47, 0x60, 0x7B, 0x06, 0x74, 0x0C, 0xB0, 0xC7,
  0x70, 0x7B, 0x06, 0x73, 0x04, 0xC0, 0x47, 0x70, 0x7B, 0x06, 0x73, 0x0C, 0xB0, 0xB7, 0x71, 0x07,
  0xB0, 0x67, 0x20, 0x5C, 0x03, 0x77, 0x10, 0x7B, 0x06, 0x72, 0x0D, 0xB0, 0xA7, 0x72, 0x07, 0xB0,
  0x67, 0x10, 0x6C, 0x02, 0x77, 0x20, 0x7B, 0x06, 0x71, 0x0D, 0xB0, 0xA7, 0x73, 0x07, 0xB0, 0x67,
  0x06, 0xC0, 0x27, 0x68, 0x32, 0x34, 0x6B, 0xB8, 0x3A, 0x54, 0x32, 0x30, 0xEB, 0x09, 0x76, 0x01,
  0xFE, 0x81, 0x40, 0x7C, 0x01, 0x76, 0x01, 0xFE, 0x81, 0x41, 0xEB, 0x08, 0x77, 0x01, 0xFE, 0x04,
  0x08, 0xB0, 0xE0, 0x17, 0x77, 0x70, 0x10, 0xEB, 0x08, 0x77, 0x77, 0x10, 0x8B, 0x0E, 0x01, 0x58,
  0x41, 0xDE, 0xEE, 0x47, 0x73, 0x01, 0xC0, 0x76, 0x0A, 0xC0, 0x47, 0x73, 0x09, 0xB0, 0xE6, 0x06,
  0xD0, 0x47, 0x72, 0x02, 0xC0, 0x65, 0x02, 0x0E, 0xD0, 0x47, 0x72, 0x0A, 0xB0, 0xD6, 0x0C, 0xE0,
  0x47, 0x71, 0x02, 0xC0, 0x65, 0x08, 0xB0, 0xAB, 0x04, 0x77, 0x10, 0xBB, 0x0D, 0x50, 0x3B, 0x09,
  0x07, 0xB0, 0x47, 0x70, 0x3C, 0x05, 0x50, 0xDA, 0x81, 0xE1, 0x7B, 0x04, 0x77, 0x0B, 0xB0, 0xC5,
  0x09, 0xB8, 0x14, 0x07, 0xB0, 0x47, 0x60, 0x4C, 0x04, 0x40, 0x5B, 0x09, 0x20, 0x8B, 0x04, 0x76,
  0x0C, 0xB0, 0xC4, 0x01, 0x0E, 0xA0, 0xD3, 0x08, 0xB0, 0x47, 0x50, 0x5C, 0x04, 0x40, 0xBB, 0x03,
  0x30, 0x8B, 0x04, 0x75, 0x0C, 0xB0, 0xB4, 0x07, 0xB0, 0x84, 0x08, 0xB0, 0x47, 0x40, 0x5C, 0x03,
  0x4F, 0xFA, 0x06, 0x71, 0x0D, 0xB0, 0xB5, 0xFF, 0xA0, 0x67, 0x06, 0xC0, 0x35, 0xFF, 0xA0, 0x67,
  0x0D, 0xB0, 0xA7, 0x71, 0x08, 0xB0, 0x47, 0x20, 0x7C, 0x02, 0x77, 0x10, 0x8B, 0x04, 0x72, 0x0E,
  0xB0, 0x97, 0x72, 0x08, 0xB0, 0x47, 0x10, 0x7C, 0x02, 0x77, 0x20, 0x8B, 0x04, 0x71, 0x83, 0x67,
  0x77, 0x57, 0x73, 0x83, 0x37, 0x77, 0x23,
  // "½" (U+00BD)
  0x50, 0x70, 0xEB, 0x06, 0x77, 0x10, 0x1C, 0x07, 0x60, 0x40, 0xDD, 0x06, 0x77, 0x10, 0x9B, 0x0E,
  0x50, 0x20, 0xBF, 0x06, 0x77, 0x01, 0xC0, 0x64, 0x06, 0xFA, 0x06, 0x77, 0x09, 0xB0, 0xD5, 0x03,
  0xC0, 0xE0, 0x9B, 0x06, 0x76, 0x02, 0xC0, 0x66, 0x09, 0xA8, 0x1B, 0x16, 0xB0, 0x67, 0x60, 0xAB,
  0x0D, 0x78, 0x11, 0xC4, 0x20, 0x6B, 0x06, 0x75, 0x02, 0xC0, 0x67, 0x50, 0x6B, 0x06, 0x75, 0x0A,
  0xB0, 0xD7, 0x60, 0x7B, 0x06, 0x74, 0x03, 0xC0, 0x57, 0x60, 0x7B, 0x06, 0x74, 0x0B, 0xB0, 0xC7,
  0x70, 0x7B, 0x06, 0x73, 0x03, 0xC0, 0x57, 0x70, 0x7B, 0x06, 0x73, 0x0B, 0xB0, 0xC7, 0x71, 0x07,
  0xB0, 0x67, 0x20, 0x4C, 0x04, 0x77, 0x10, 0x7B, 0x06, 0x72, 0x0C, 0xB0, 0xC7, 0x72, 0x07, 0xB0,
  0x67, 0x10, 0x4C, 0x04, 0x77, 0x20, 0x7B, 0x06, 0x71, 0x0C, 0xB0, 0xB7, 0x73, 0x07, 0xB0, 0x67,
  0x05, 0xC0, 0x37, 0x68, 0x32, 0x34, 0x6B, 0xB8, 0x3A, 0x54, 0x32, 0x30, 0xDB, 0x0B, 0x76, 0x01,
  0xFE, 0x81, 0x40, 0x5C, 0x03, 0x76, 0x01, 0xFE, 0x81, 0x40, 0xDB, 0x0A, 0x77, 0x01, 0xFE, 0x04,
  0x06, 0xC0, 0x27, 0x77, 0x71, 0x0D, 0xB0, 0xA2, 0x86, 0x39, 0xDE, 0xED, 0x94, 0x77, 0x50, 0x6C,
  0x81, 0x21, 0xBF, 0x90, 0xB0, 0x17, 0x73, 0x0E, 0xB8, 0x19, 0x3E, 0xFB, 0x0B, 0x77, 0x20, 0x7C,
  0x02, 0x09, 0xFD, 0x05, 0x77, 0x10, 0xEB, 0x09, 0x20, 0xDA, 0x83, 0x82, 0x01, 0x7C, 0x0B, 0x77,
  0x07, 0xC0, 0x12, 0x81, 0x3C, 0x25, 0x07, 0xB0, 0xD7, 0x60, 0x10, 0xEB, 0x08, 0x74, 0x03, 0xB0,
  0xE7, 0x60, 0x8B, 0x0E, 0x01, 0x74, 0x02, 0xB0, 0xD7, 0x50, 0x10, 0xEB, 0x08, 0x75, 0x06, 0xB0,
  0x97, 0x50, 0x8B, 0x0E, 0x01, 0x74, 0x01, 0x0D, 0xB0, 0x37, 0x40, 0x1C, 0x07, 0x75, 0x0B, 0xB0,
  0x87, 0x50, 0x9B, 0x0E, 0x01, 0x74, 0x0A, 0xB0, 0xB7, 0x50, 0x2C, 0x07, 0x74, 0x0A, 0xB0, 0xC0,
  0x17, 0x50, 0x9B, 0x0E, 0x74, 0x0B, 0xB0, 0xC0, 0x17, 0x50, 0x2C, 0x07, 0x72, 0x01, 0x0C, 0xB0,
  0xC0, 0x17, 0x60, 0xAB, 0x0D, 0x72, 0x01, 0x0C, 0xB0, 0xB7, 0x70, 0x2C, 0x06, 0x71, 0x01, 0x0D,
  0xB0, 0xA7, 0x71, 0x0A, 0xB0, 0xD7, 0x10, 0x20, 0xDB, 0x09, 0x77, 0x10, 0x3C, 0x06, 0x70, 0x10,
  0xEF, 0xE0, 0x66, 0x0B, 0xB0, 0xD7, 0x10, 0x2F, 0xF0, 0x65, 0x03, 0xC0, 0x57, 0x10, 0x2F, 0xF0,
  0x65, 0x0B, 0xB0, 0xD7, 0x20, 0x2F, 0xF0, 0x60,
  // "¾" (U+00BE)
  0x28, 0x90, 0x17, 0xBD, 0xEF, 0xDB, 0x61, 0x77, 0x83, 0x78, 0x88, 0x53, 0x01, 0x09, 0xFA, 0x0E,
  0x04, 0x75, 0x05, 0xC0, 0x33, 0x08, 0xFD, 0x03, 0x74, 0x0D, 0xB0, 0xA5, 0x0B, 0xA8, 0x49, 0x30,
  0x16, 0xEB, 0x0B, 0x73, 0x06, 0xC0, 0x25, 0x81, 0x1A, 0x25, 0x07, 0xC7, 0x30, 0xDB, 0x0A, 0x77,
  0x03, 0xC0, 0x27, 0x10, 0x6C, 0x02, 0x77, 0x04, 0xC0, 0x17, 0x10, 0xDB, 0x09, 0x77, 0x10, 0xAB,
  0x0D, 0x71, 0x07, 0xC0, 0x27, 0x60, 0x30, 0x9C, 0x05, 0x71, 0x0E, 0xB0, 0x97, 0x3F, 0x90, 0xE0,
  0x67, 0x10, 0x7C, 0x01, 0x73, 0xF9, 0x09, 0x01, 0x70, 0x10, 0xEB, 0x08, 0x74, 0xFA, 0x0E, 0x04,
  0x60, 0x8B, 0x0E, 0x01, 0x77, 0x82, 0x12, 0x7E, 0xB0, 0xE0, 0x14, 0x01, 0x0E, 0xB0, 0x87, 0x74,
  0x02, 0x0E, 0xB0, 0x74, 0x08, 0xB0, 0xE0, 0x17, 0x75, 0x0A, 0xB0, 0x93, 0x01, 0x0E, 0xB0, 0x77,
  0x76, 0x09, 0xB0, 0xA3, 0x09, 0xB0, 0xE7, 0x77, 0x0C, 0xB0, 0x92, 0x01, 0xC0, 0x77, 0x40, 0x30,
  0x47, 0x04, 0xC0, 0x52, 0x09, 0xB0, 0xE7, 0x58, 0x90, 0x5F, 0xD7, 0x31, 0x01, 0x6E, 0xB0, 0xD2,
  0x02, 0xC0, 0x67, 0x50, 0x5F, 0xD0, 0x32, 0x09, 0xB0, 0xD7, 0x60, 0x5F, 0xB0, 0xD0, 0x32, 0x02,
  0xC0, 0x67, 0x78, 0x90, 0x49, 0xCD, 0xEF, 0xEC, 0x95, 0x40, 0xAB, 0x0D, 0x77, 0x77, 0x03, 0xC0,
  0x66, 0x80, 0x03, 0x01, 0x77, 0x30, 0xBB, 0x0D, 0x60, 0x3C, 0x04, 0x77, 0x20, 0x3C, 0x05, 0x60,
  0xDC, 0x04, 0x77, 0x20, 0xBB, 0x0D, 0x60, 0x9D, 0x04, 0x77, 0x10, 0x3C, 0x05, 0x50, 0x4E, 0x04,
  0x77, 0x10, 0xBB, 0x0C, 0x50, 0x10, 0xDA, 0x0E, 0xB0, 0x47, 0x70, 0x4C, 0x04, 0x50, 0xAB, 0x08,
  0xB0, 0x47, 0x70, 0xCB, 0x0C, 0x50, 0x5B, 0x08, 0x07, 0xB0, 0x47, 0x60, 0x4C, 0x04, 0x40, 0x10,
  0xEA, 0x81, 0xD0, 0x7B, 0x04, 0x76, 0x0C, 0xB0, 0xB5, 0x0B, 0xB8, 0x13, 0x07, 0xB0, 0x47, 0x50,
  0x5C, 0x03, 0x40, 0x6B, 0x08, 0x20, 0x8B, 0x04, 0x75, 0x0D, 0xB0, 0xB4, 0x02, 0x0E, 0xA0, 0xD3,
  0x08, 0xB0, 0x47, 0x40, 0x5C, 0x03, 0x40, 0xCB, 0x03, 0x30, 0x8B, 0x04, 0x74, 0x0D, 0xB0, 0xA4,
  0x07, 0xB0, 0x84, 0x08, 0xB0, 0x47, 0x30, 0x6C, 0x02, 0x4F, 0xFA, 0x06, 0x70, 0xDB, 0x0A, 0x5F,
  0xFA, 0x06, 0x60, 0x6C, 0x02, 0x5F, 0xFA, 0x06, 0x60, 0xEB, 0x09, 0x77, 0x10, 0x8B, 0x04, 0x71,
  0x07, 0xC0, 0x27, 0x71, 0x08, 0xB0, 0x47, 0x10, 0xEB, 0x09, 0x77, 0x20, 0x8B, 0x04, 0x70, 0x7C,
  0x01, 0x77, 0x20, 0x8B, 0x04, 0x78, 0x36, 0x77, 0x75, 0x77, 0x38, 0x33, 0x77, 0x72, 0x30,
  // "¿" (U+00BF)
  0x76, 0x82, 0x47, 0x51, 0x77, 0x60, 0x20, 0xDB, 0x0E, 0x04, 0x77, 0x50, 0xBD, 0x0E, 0x77, 0x5F,
  0x03, 0x77, 0x30, 0x1F, 0x05, 0x77, 0x4F, 0x03, 0x77, 0x40, 0xBD, 0x0E, 0x77, 0x50, 0x20, 0xDB,
  0x0E, 0x05, 0x77, 0x78, 0x25, 0x75, 0x18, 0x09, 0xF1, 0x08, 0x46, 0xDD, 0xDD, 0x27, 0x76, 0x08,
  0xC0, 0x27, 0x76, 0x09, 0xC0, 0x17, 0x76, 0x0D, 0xC7, 0x76, 0x04, 0xC0, 0xC7, 0x75, 0x01, 0x0D,
  0xC0, 0x87, 0x74, 0x01, 0x0C, 0xD0, 0x17, 0x73, 0x02, 0x0D, 0xD0, 0x77, 0x73, 0x04, 0x0E, 0xD0,
  0xA7, 0x73, 0x07, 0xE0, 0xA7, 0x73, 0x0A, 0xE0, 0x97, 0x73, 0x0B, 0xD0, 0xE0, 0x57, 0x73, 0x0B,
  0xD0, 0xD0, 0x27, 0x73, 0x07, 0xD0, 0xB0, 0x17, 0x73, 0x02, 0xD0, 0xB7, 0x75, 0x09, 0xC0, 0xE0,
  0x17, 0x75, 0x0E, 0xC0, 0x67, 0x75, 0x03, 0xC0, 0xE7, 0x76, 0x06, 0xC0, 0xB7, 0x76, 0x07, 0xC0,
  0x97, 0x76, 0x08, 0xC0, 0x87, 0x76, 0x08, 0xC0, 0x87, 0x76, 0x07, 0xC0, 0xB7, 0x76, 0x04, 0xD0,
  0x17, 0x76, 0x0E, 0xC0, 0xA7, 0x71, 0x02, 0x07, 0x30, 0x9D, 0x09, 0x75, 0x05, 0x0B, 0xA0, 0x32,
  0x01, 0x0E, 0xD8, 0x1D, 0x73, 0x48, 0x31, 0x36, 0xAE, 0xC0, 0x93, 0x04, 0xFA, 0x00, 0xEF, 0xB0,
  0xE0, 0x13, 0x04, 0x0E, 0xFF, 0xE0, 0x64, 0x01, 0x0A, 0xFF, 0xA8, 0x1E, 0x93, 0x78, 0x12, 0x9D,
  0xFB, 0x81, 0xD9, 0x47, 0x68, 0x90, 0x14, 0x56, 0x77, 0x65, 0x31, 0x70,
  // "À" (U+00C0)
  0x72, 0x05, 0x80, 0x17, 0x05, 0x77, 0x76, 0x06, 0xE0, 0x27, 0x77, 0x60, 0xAD, 0x0B, 0x77, 0x77,
  0x0C, 0xD0, 0x57, 0x77, 0x60, 0x10, 0xDC, 0x0E, 0x01, 0x77, 0x76, 0x02, 0x0D, 0xC0, 0x97, 0x77,
  0x70, 0x20, 0xDC, 0x04, 0x77, 0x77, 0x02, 0x0D, 0xB0, 0xE0, 0x17, 0x77, 0x70, 0x10, 0xCB, 0x0B,
  0x77, 0x77, 0x20, 0xAB, 0x05, 0x80, 0xB8, 0x00, 0xD0, 0xE7, 0x77, 0x60, 0x5E, 0x04, 0x77, 0x75,
  0x0A, 0xE0, 0x97, 0x77, 0x50, 0xEE, 0x0E, 0x77, 0x74, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x0A, 0xF9,
  0x09, 0x77, 0x73, 0x0E, 0xB0, 0xB0, 0xDB, 0x0E, 0x77, 0x72, 0x04, 0xC0, 0x80, 0x9C, 0x03, 0x77,
  0x71, 0x09, 0xC0, 0x40, 0x5C, 0x08, 0x77, 0x71, 0x0E, 0xC1, 0x01, 0xC0, 0xD7, 0x77, 0x04, 0xC0,
  0xB2, 0x0C, 0xC0, 0x37, 0x76, 0x09, 0xC0, 0x62, 0x07, 0xC0, 0x87, 0x76, 0x0E, 0xC0, 0x22, 0x03,
  0xC0, 0xD7, 0x75, 0x03, 0xC0, 0xD4, 0x0D, 0xC0, 0x37, 0x74, 0x08, 0xC0, 0x84, 0x09, 0xC0, 0x87,
  0x74, 0x0D, 0xC0, 0x34, 0x04, 0xC0, 0xD7, 0x73, 0x03, 0xC0, 0xD6, 0x0E, 0xC0, 0x27, 0x72, 0x08,
  0xC0, 0x96, 0x0A, 0xC0, 0x77, 0x72, 0x0D, 0xC0, 0x46, 0x05, 0xC0, 0xC7, 0x71, 0x02, 0xC0, 0xE7,
  0x1D, 0x02, 0x77, 0x07, 0xC0, 0xA7, 0x10, 0xBC, 0x07, 0x77, 0x0D, 0xC0, 0x57, 0x10, 0x6C, 0x0C,
  0x76, 0x02, 0xD7, 0x20, 0x1D, 0x02, 0x75, 0x07, 0xC0, 0xA7, 0x30, 0xBC, 0x07, 0x75, 0x0C, 0xC0,
  0x67, 0x30, 0x7C, 0x0C, 0x74, 0x02, 0xFF, 0xF9, 0x01, 0x73, 0x07, 0xFF, 0xF9, 0x06, 0x73, 0x0C,
  0xFF, 0xF9, 0x0B, 0x72, 0x01, 0xFF, 0xFB, 0x01, 0x71, 0x06, 0xC0, 0xC8, 0x09, 0x26, 0x0C, 0xC0,
  0x67, 0x10, 0xBC, 0x06, 0x77, 0x07, 0xC0, 0xB7, 0x01, 0xD0, 0x17, 0x70, 0x2D, 0x01, 0x60, 0x6C,
  0x0C, 0x77, 0x20, 0xDC, 0x05, 0x60, 0xBC, 0x07, 0x77, 0x20, 0x8C, 0x0A, 0x50, 0x1D, 0x03, 0x77,
  0x20, 0x4D, 0x50, 0x5C, 0x0D, 0x77, 0x40, 0xEC, 0x05, 0x40, 0xAC, 0x09, 0x77, 0x40, 0xAC, 0x0A,
  0x4D, 0x04, 0x77, 0x40, 0x5C, 0x0E, 0x30, 0x5D, 0x77, 0x50, 0x1D, 0x05, 0x20, 0xAC, 0x0A, 0x77,
  0x60, 0xBC, 0x0A, 0x20, 0xEC, 0x06, 0x77, 0x60, 0x7C, 0x81, 0xE0, 0x4D, 0x01, 0x77, 0x60, 0x2D,
  0x04, 0x09, 0xC0, 0xC7, 0x77, 0x10, 0xDC, 0x09,
  // "Á" (U+00C1)
  0x77, 0x60, 0x58, 0x01, 0x70, 0x67, 0x77, 0x50, 0x1E, 0x09, 0x77, 0x75, 0x0A, 0xD0, 0xC7, 0x77,
  0x50, 0x4D, 0x0D, 0x01, 0x77, 0x75, 0x0D, 0xC0, 0xE0, 0x27, 0x77, 0x50, 0x8C, 0x0E, 0x02, 0x77,
  0x75, 0x03, 0xC0, 0xE0, 0x37, 0x77, 0x60, 0xDB, 0x0E, 0x03, 0x77, 0x76, 0x09, 0xB0, 0xD0, 0x27,
  0x77, 0x60, 0x3B, 0x0B, 0x01, 0x80, 0xB8, 0x20, 0xD0, 0xE7, 0x77, 0x60, 0x5E, 0x04, 0x77, 0x75,
  0x0A, 0xE0, 0x97, 0x77, 0x50, 0xEE, 0x0E, 0x77, 0x74, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x0A, 0xF9,
  0x09, 0x77, 0x73, 0x0E, 0xB0, 0xB0, 0xDB, 0x0E, 0x77, 0x72, 0x04, 0xC0, 0x80, 0x9C, 0x03, 0x77,
  0x71, 0x09, 0xC0, 0x40, 0x5C, 0x08, 0x77, 0x71, 0x0E, 0xC1, 0x01, 0xC0, 0xD7, 0x77, 0x04, 0xC0,
  0xB2, 0x0C, 0xC0, 0x37, 0x76, 0x09, 0xC0, 0x62, 0x07, 0xC0, 0x87, 0x76, 0x0E, 0xC0, 0x22, 0x03,
  0xC0, 0xD7, 0x75, 0x03, 0xC0, 0xD4, 0x0D, 0xC0, 0x37, 0x74, 0x08, 0xC0, 0x84, 0x09, 0xC0, 0x87,
  0x74, 0x0D, 0xC0, 0x34, 0x04, 0xC0, 0xD7, 0x73, 0x03, 0xC0, 0xD6, 0x0E, 0xC0, 0x27, 0x72, 0x08,
  0xC0, 0x96, 0x0A, 0xC0, 0x77, 0x72, 0x0D, 0xC0, 0x46, 0x05, 0xC0, 0xC7, 0x71, 0x02, 0xC0, 0xE7,
  0x1D, 0x02, 0x77, 0x07, 0xC0, 0xA7, 0x10, 0xBC, 0x07, 0x77, 0x0D, 0xC0, 0x57, 0x10, 0x6C, 0x0C,
  0x76, 0x02, 0xD7, 0x20, 0x1D, 0x02, 0x75, 0x07, 0xC0, 0xA7, 0x30, 0xBC, 0x07, 0x75, 0x0C, 0xC0,
  0x67, 0x30, 0x7C, 0x0C, 0x74, 0x02, 0xFF, 0xF9, 0x01, 0x73, 0x07, 0xFF, 0xF9, 0x06, 0x73, 0x0C,
  0xFF, 0xF9, 0x0B, 0x72, 0x01, 0xFF, 0xFB, 0x01, 0x71, 0x06, 0xC0, 0xC8, 0x09, 0x26, 0x0C, 0xC0,
  0x67, 0x10, 0xBC, 0x06, 0x77, 0x07, 0xC0, 0xB7, 0x01, 0xD0, 0x17, 0x70, 0x2D, 0x01, 0x60, 0x6C,
  0x0C, 0x77, 0x20, 0xDC, 0x05, 0x60, 0xBC, 0x07, 0x77, 0x20, 0x8C, 0x0A, 0x50, 0x1D, 0x03, 0x77,
  0x20, 0x4D, 0x50, 0x5C, 0x0D, 0x77, 0x40, 0xEC, 0x05, 0x40, 0xAC, 0x09, 0x77, 0x40, 0xAC, 0x0A,
  0x4D, 0x04, 0x77, 0x40, 0x5C, 0x0E, 0x30, 0x5D, 0x77, 0x50, 0x1D, 0x05, 0x20, 0xAC, 0x0A, 0x77,
  0x60, 0xBC, 0x0A, 0x20, 0xEC, 0x06, 0x77, 0x60, 0x7C, 0x81, 0xE0, 0x4D, 0x01, 0x77, 0x60, 0x2D,
  0x04, 0x09, 0xC0, 0xC7, 0x77, 0x10, 0xDC, 0x09,
  // "Â" (U+00C2)
  0x77, 0x80, 0x17, 0x06, 0x77, 0x76, 0x06, 0xE0, 0x47, 0x77, 0x40, 0x20, 0xEE, 0x0D, 0x01, 0x77,
  0x72, 0x01, 0x0D, 0xF9, 0x0B, 0x77, 0x72, 0x0B, 0xC0, 0xA0, 0xCC, 0x09, 0x77, 0x70, 0x9C, 0x82,
  0x90, 0x1C, 0xC0, 0x77, 0x75, 0x07, 0xC0, 0x93, 0x01, 0x0C, 0xC0, 0x67, 0x73, 0x06, 0xC0, 0x86,
  0x0B, 0xC0, 0x57, 0x71, 0x05, 0xC0, 0x77, 0x10, 0x9C, 0x04, 0x76, 0x01, 0xB0, 0xD0, 0x37, 0x30,
  0x50, 0xEB, 0x01, 0x80, 0xAF, 0x20, 0xD0, 0xE7, 0x77, 0x60, 0x5E, 0x04, 0x77, 0x75, 0x0A, 0xE0,
  0x97, 0x77, 0x50, 0xEE, 0x0E, 0x77, 0x74, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x0A, 0xF9, 0x09, 0x77,
  0x73, 0x0E, 0xB0, 0xB0, 0xDB, 0x0E, 0x77, 0x72, 0x04, 0xC0, 0x80, 0x9C, 0x03, 0x77, 0x71, 0x09,
  0xC0, 0x40, 0x5C, 0x08, 0x77, 0x71, 0x0E, 0xC1, 0x01, 0xC0, 0xD7, 0x77, 0x04, 0xC0, 0xB2, 0x0C,
  0xC0, 0x37, 0x76, 0x09, 0xC0, 0x62, 0x07, 0xC0, 0x87, 0x76, 0x0E, 0xC0, 0x22, 0x03, 0xC0, 0xD7,
  0x75, 0x03, 0xC0, 0xD4, 0x0D, 0xC0, 0x37, 0x74, 0x08, 0xC0, 0x84, 0x09, 0xC0, 0x87, 0x74, 0x0D,
  0xC0, 0x34, 0x04, 0xC0, 0xD7, 0x73, 0x03, 0xC0, 0xD6, 0x0E, 0xC0, 0x27, 0x72, 0x08, 0xC0, 0x96,
  0x0A, 0xC0, 0x77, 0x72, 0x0D, 0xC0, 0x46, 0x05, 0xC0, 0xC7, 0x71, 0x02, 0xC0, 0xE7, 0x1D, 0x02,
  0x77, 0x07, 0xC0, 0xA7, 0x10, 0xBC, 0x07, 0x77, 0x0D, 0xC0, 0x57, 0x10, 0x6C, 0x0C, 0x76, 0x02,
  0xD7, 0x20, 0x1D, 0x02, 0x75, 0x07, 0xC0, 0xA7, 0x30, 0xBC, 0x07, 0x75, 0x0C, 0xC0, 0x67, 0x30,
  0x7C, 0x0C, 0x74, 0x02, 0xFF, 0xF9, 0x01, 0x73, 0x07, 0xFF, 0xF9, 0x06, 0x73, 0x0C, 0xFF, 0xF9,
  0x0B, 0x72, 0x01, 0xFF, 0xFB, 0x01, 0x71, 0x06, 0xC0, 0xC8, 0x09, 0x26, 0x0C, 0xC0, 0x67, 0x10,
  0xBC, 0x06, 0x77, 0x07, 0xC0, 0xB7, 0x01, 0xD0, 0x17, 0x70, 0x2D, 0x01, 0x60, 0x6C, 0x0C, 0x77,
  0x20, 0xDC, 0x05, 0x60, 0xBC, 0x07, 0x77, 0x20, 0x8C, 0x0A, 0x50, 0x1D, 0x03, 0x77, 0x20, 0x4D,
  0x50, 0x5C, 0x0D, 0x77, 0x40, 0xEC, 0x05, 0x40, 0xAC, 0x09, 0x77, 0x40, 0xAC, 0x0A, 0x4D, 0x04,
  0x77, 0x40, 0x5C, 0x0E, 0x30, 0x5D, 0x77, 0x50, 0x1D, 0x05, 0x20, 0xAC, 0x0A, 0x77, 0x60, 0xBC,
  0x0A, 0x20, 0xEC, 0x06, 0x77, 0x60, 0x7C, 0x81, 0xE0, 0x4D, 0x01, 0x77, 0x60, 0x2D, 0x04, 0x09,
  0xC0, 0xC7, 0x77, 0x10, 0xDC, 0x09,
  // "Ã" (U+00C3)
  0x72, 0x85, 0x18, 0xDE, 0xDB, 0x47, 0x10, 0x5A, 0x0B, 0x77, 0x02, 0x0E, 0xE0, 0xB0, 0x26, 0x0B,
  0xA0, 0x87, 0x60, 0x10, 0xDF, 0xA0, 0x74, 0x04, 0xB0, 0x47, 0x60, 0x8F, 0xC8, 0x2E, 0x97, 0x9B,
  0x0E, 0x77, 0x0E, 0xB8, 0x29, 0x78, 0xDF, 0xC0, 0x87, 0x60, 0x5B, 0x05, 0x40, 0x70, 0xEF, 0x90,
  0xD7, 0x70, 0x8A, 0x0B, 0x60, 0x20, 0xBE, 0x0E, 0x02, 0x77, 0x0B, 0xA0, 0x67, 0x18, 0x54, 0xAD,
  0xFD, 0x81, 0x80, 0xAF, 0x50, 0xD0, 0xE7, 0x77, 0x60, 0x5E, 0x04, 0x77, 0x75, 0x0A, 0xE0, 0x97,
  0x77, 0x50, 0xEE, 0x0E, 0x77, 0x74, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x0A, 0xF9, 0x09, 0x77, 0x73,
  0x0E, 0xB0, 0xB0, 0xDB, 0x0E, 0x77, 0x72, 0x04, 0xC0, 0x80, 0x9C, 0x03, 0x77, 0x71, 0x09, 0xC0,
  0x40, 0x5C, 0x08, 0x77, 0x71, 0x0E, 0xC1, 0x01, 0xC0, 0xD7, 0x77, 0x04, 0xC0, 0xB2, 0x0C, 0xC0,
  0x37, 0x76, 0x09, 0xC0, 0x62, 0x07, 0xC0, 0x87, 0x76, 0x0E, 0xC0, 0x22, 0x03, 0xC0, 0xD7, 0x75,
  0x03, 0xC0, 0xD4, 0x0D, 0xC0, 0x37, 0x74, 0x08, 0xC0, 0x84, 0x09, 0xC0, 0x87, 0x74, 0x0D, 0xC0,
  0x34, 0x04, 0xC0, 0xD7, 0x73, 0x03, 0xC0, 0xD6, 0x0E, 0xC0, 0x27, 0x72, 0x08, 0xC0, 0x96, 0x0A,
  0xC0, 0x77, 0x72, 0x0D, 0xC0, 0x46, 0x05, 0xC0, 0xC7, 0x71, 0x02, 0xC0, 0xE7, 0x1D, 0x02, 0x77,
  0x07, 0xC0, 0xA7, 0x10, 0xBC, 0x07, 0x77, 0x0D, 0xC0, 0x57, 0x10, 0x6C, 0x0C, 0x76, 0x02, 0xD7,
  0x20, 0x1D, 0x02, 0x75, 0x07, 0xC0, 0xA7, 0x30, 0xBC, 0x07, 0x75, 0x0C, 0xC0, 0x67, 0x30, 0x7C,
  0x0C, 0x74, 0x02, 0xFF, 0xF9, 0x01, 0x73, 0x07, 0xFF, 0xF9, 0x06, 0x73, 0x0C, 0xFF, 0xF9, 0x0B,
  0x72, 0x01, 0xFF, 0xFB, 0x01, 0x71, 0x06, 0xC0, 0xC8, 0x09, 0x26, 0x0C, 0xC0, 0x67, 0x10, 0xBC,
  0x06, 0x77, 0x07, 0xC0, 0xB7, 0x01, 0xD0, 0x17, 0x70, 0x2D, 0x01, 0x60, 0x6C, 0x0C, 0x77, 0x20,
  0xDC, 0x05, 0x60, 0xBC, 0x07, 0x77, 0x20, 0x8C, 0x0A, 0x50, 0x1D, 0x03, 0x77, 0x20, 0x4D, 0x50,
  0x5C, 0x0D, 0x77, 0x40, 0xEC, 0x05, 0x40, 0xAC, 0x09, 0x77, 0x40, 0xAC, 0x0A, 0x4D, 0x04, 0x77,
  0x40, 0x5C, 0x0E, 0x30, 0x5D, 0x77, 0x50, 0x1D, 0x05, 0x20, 0xAC, 0x0A, 0x77, 0x60, 0xBC, 0x0A,
  0x20, 0xEC, 0x06, 0x77, 0x60, 0x7C, 0x81, 0xE0, 0x4D, 0x01, 0x77, 0x60, 0x2D, 0x04, 0x09, 0xC0,
  0xC7, 0x77, 0x10, 0xDC, 0x09,
  // "Ä" (U+00C4)
  0x71, 0x83, 0x8D, 0xEB, 0x27, 0x18, 0x42, 0xAE, 0xE9, 0x17, 0x70, 0xAC, 0x0E, 0x01, 0x70, 0xDC,
  0x0B, 0x77, 0xE0, 0x56, 0x03, 0xE0, 0x17, 0x6E, 0x06, 0x60, 0x4E, 0x02, 0x76, 0x0E, 0xD0, 0x46,
  0x02, 0xE7, 0x70, 0x8C, 0x0D, 0x71, 0x0C, 0xC0, 0x97, 0x71, 0x83, 0x7D, 0xEA, 0x27, 0x18, 0x31,
  0xAE, 0xD8, 0x80, 0xBB, 0x60, 0xD0, 0xE7, 0x77, 0x60, 0x5E, 0x04, 0x77, 0x75, 0x0A, 0xE0, 0x97,
  0x77, 0x50, 0xEE, 0x0E, 0x77, 0x74, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x0A, 0xF9, 0x09, 0x77, 0x73,
  0x0E, 0xB0, 0xB0, 0xDB, 0x0E, 0x77, 0x72, 0x04, 0xC0, 0x80, 0x9C, 0x03, 0x77, 0x71, 0x09, 0xC0,
  0x40, 0x5C, 0x08, 0x77, 0x71, 0x0E, 0xC1, 0x01, 0xC0, 0xD7, 0x77, 0x04, 0xC0, 0xB2, 0x0C, 0xC0,
  0x37, 0x76, 0x09, 0xC0, 0x62, 0x07, 0xC0, 0x87, 0x76, 0x0E, 0xC0, 0x22, 0x03, 0xC0, 0xD7, 0x75,
  0x03, 0xC0, 0xD4, 0x0D, 0xC0, 0x37, 0x74, 0x08, 0xC0, 0x84, 0x09, 0xC0, 0x87, 0x74, 0x0D, 0xC0,
  0x34, 0x04, 0xC0, 0xD7, 0x73, 0x03, 0xC0, 0xD6, 0x0E, 0xC0, 0x27, 0x72, 0x08, 0xC0, 0x96, 0x0A,
  0xC0, 0x77, 0x72, 0x0D, 0xC0, 0x46, 0x05, 0xC0, 0xC7, 0x71, 0x02, 0xC0, 0xE7, 0x1D, 0x02, 0x77,
  0x07, 0xC0, 0xA7, 0x10, 0xBC, 0x07, 0x77, 0x0D, 0xC0, 0x57, 0x10, 0x6C, 0x0C, 0x76, 0x02, 0xD7,
  0x20, 0x1D, 0x02, 0x75, 0x07, 0xC0, 0xA7, 0x30, 0xBC, 0x07, 0x75, 0x0C, 0xC0, 0x67, 0x30, 0x7C,
  0x0C, 0x74, 0x02, 0xFF, 0xF9, 0x01, 0x73, 0x07, 0xFF, 0xF9, 0x06, 0x73, 0x0C, 0xFF, 0xF9, 0x0B,
  0x72, 0x01, 0xFF, 0xFB, 0x01, 0x71, 0x06, 0xC0, 0xC8, 0x09, 0x26, 0x0C, 0xC0, 0x67, 0x10, 0xBC,
  0x06, 0x77, 0x07, 0xC0, 0xB7, 0x01, 0xD0, 0x17, 0x70, 0x2D, 0x01, 0x60, 0x6C, 0x0C, 0x77, 0x20,
  0xDC, 0x05, 0x60, 0xBC, 0x07, 0x77, 0x20, 0x8C, 0x0A, 0x50, 0x1D, 0x03, 0x77, 0x20, 0x4D, 0x50,
  0x5C, 0x0D, 0x77, 0x40, 0xEC, 0x05, 0x40, 0xAC, 0x09, 0x77, 0x40, 0xAC, 0x0A, 0x4D, 0x04, 0x77,
  0x40, 0x5C, 0x0E, 0x30, 0x5D, 0x77, 0x50, 0x1D, 0x05, 0x20, 0xAC, 0x0A, 0x77, 0x60, 0xBC, 0x0A,
  0x20, 0xEC, 0x06, 0x77, 0x60, 0x7C, 0x81, 0xE0, 0x4D, 0x01, 0x77, 0x60, 0x2D, 0x04, 0x09, 0xC0,
  0xC7, 0x77, 0x10, 0xDC, 0x09,
  // "Å" (U+00C5)
  0x76, 0x86, 0x39, 0xDF, 0xEC, 0x82, 0x77, 0x74, 0x07, 0xF9, 0x06, 0x77, 0x72, 0x07, 0xFB, 0x05,
  0x77, 0x70, 0x10, 0xEA, 0x84, 0xE6, 0x11, 0x6E, 0xA0, 0xE7, 0x77, 0x05, 0xB0, 0x44, 0x05, 0xB0,
  0x57, 0x76, 0x08, 0xA0, 0xE6, 0x0E, 0xA0, 0x87, 0x76, 0x08, 0xA0, 0xC6, 0x0D, 0xA0, 0x87, 0x76,
  0x08, 0xA0, 0xE6, 0x0E, 0xA0, 0x77, 0x76, 0x05, 0xB0, 0x44, 0x05, 0xB0, 0x47, 0x77, 0x0E, 0xA8,
  0x4E, 0x51, 0x16, 0xEA, 0x0E, 0x77, 0x71, 0x06, 0xFB, 0x05, 0x77, 0x72, 0x07, 0xF9, 0x06, 0x77,
  0x74, 0x86, 0x39, 0xDF, 0xED, 0x82, 0x80, 0xB8, 0x10, 0xD0, 0xE7, 0x77, 0x60, 0x5E, 0x04, 0x77,
  0x75, 0x0A, 0xE0, 0x97, 0x77, 0x50, 0xEE, 0x0E, 0x77, 0x74, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x0A,
  0xF9, 0x09, 0x77, 0x73, 0x0E, 0xB0, 0xB0, 0xDB, 0x0E, 0x77, 0x72, 0x04, 0xC0, 0x80, 0x9C, 0x03,
  0x77, 0x71, 0x09, 0xC0, 0x40, 0x5C, 0x08, 0x77, 0x71, 0x0E, 0xC1, 0x01, 0xC0, 0xD7, 0x77, 0x04,
  0xC0, 0xB2, 0x0C, 0xC0, 0x37, 0x76, 0x09, 0xC0, 0x62, 0x07, 0xC0, 0x87, 0x76, 0x0E, 0xC0, 0x22,
  0x03, 0xC0, 0xD7, 0x75, 0x03, 0xC0, 0xD4, 0x0D, 0xC0, 0x37, 0x74, 0x08, 0xC0, 0x84, 0x09, 0xC0,
  0x87, 0x74, 0x0D, 0xC0, 0x34, 0x04, 0xC0, 0xD7, 0x73, 0x03, 0xC0, 0xD6, 0x0E, 0xC0, 0x27, 0x72,
  0x08, 0xC0, 0x96, 0x0A, 0xC0, 0x77, 0x72, 0x0D, 0xC0, 0x46, 0x05, 0xC0, 0xC7, 0x71, 0x02, 0xC0,
  0xE7, 0x1D, 0x02, 0x77, 0x07, 0xC0, 0xA7, 0x10, 0xBC, 0x07, 0x77, 0x0D, 0xC0, 0x57, 0x10, 0x6C,
  0x0C, 0x76, 0x02, 0xD7, 0x20, 0x1D, 0x02, 0x75, 0x07, 0xC0, 0xA7, 0x30, 0xBC, 0x07, 0x75, 0x0C,
  0xC0, 0x67, 0x30, 0x7C, 0x0C, 0x74, 0x02, 0xFF, 0xF9, 0x01, 0x73, 0x07, 0xFF, 0xF9, 0x06, 0x73,
  0x0C, 0xFF, 0xF9, 0x0B, 0x72, 0x01, 0xFF, 0xFB, 0x01, 0x71, 0x06, 0xC0, 0xC8, 0x09, 0x26, 0x0C,
  0xC0, 0x67, 0x10, 0xBC, 0x06, 0x77, 0x07, 0xC0, 0xB7, 0x01, 0xD0, 0x17, 0x70, 0x2D, 0x01, 0x60,
  0x6C, 0x0C, 0x77, 0x20, 0xDC, 0x05, 0x60, 0xBC, 0x07, 0x77, 0x20, 0x8C, 0x0A, 0x50, 0x1D, 0x03,
  0x77, 0x20, 0x4D, 0x50, 0x5C, 0x0D, 0x77, 0x40, 0xEC, 0x05, 0x40, 0xAC, 0x09, 0x77, 0x40, 0xAC,
  0x0A, 0x4D, 0x04, 0x77, 0x40, 0x5C, 0x0E, 0x30, 0x5D, 0x77, 0x50, 0x1D, 0x05, 0x20, 0xAC, 0x0A,
  0x77, 0x60, 0xBC, 0x0A, 0x20, 0xEC, 0x06, 0x77, 0x60, 0x7C, 0x81, 0xE0, 0x4D, 0x01, 0x77, 0x60,
  0x2D, 0x04, 0x09, 0xC0, 0xC7, 0x77, 0x10, 0xDC, 0x09,
  // "Æ" (U+00C6)
  0x72, 0x04, 0xFF, 0xF0, 0x97, 0x20, 0x8F, 0xFF, 0x09, 0x72, 0x0B, 0xFF, 0xF0, 0x97, 0x20, 0xEF,
  0xFF, 0x09, 0x71, 0x03, 0xC8, 0x1A, 0x69, 0xC0, 0xD8, 0x06, 0x60, 0x37, 0x10, 0x6C, 0x81, 0x40,
  0x5C, 0x0C, 0x77, 0x50, 0xAC, 0x81, 0x10, 0x5C, 0x0C, 0x77, 0x50, 0xDB, 0x0D, 0x20, 0x5C, 0x0C,
  0x77, 0x40, 0x1C, 0x0A, 0x20, 0x5C, 0x0C, 0x77, 0x40, 0x5C, 0x06, 0x20, 0x5C, 0x0C, 0x77, 0x40,
  0x8C, 0x03, 0x20, 0x5C, 0x0C, 0x77, 0x40, 0xBC, 0x30, 0x5C, 0x0C, 0x77, 0x4C, 0x0C, 0x30, 0x5C,
  0x0C, 0x77, 0x30, 0x3C, 0x09, 0x30, 0x5C, 0x0C, 0x77, 0x30, 0x6C, 0x06, 0x30, 0x5C, 0x0C, 0x77,
  0x30, 0xAC, 0x03, 0x30, 0x5C, 0x0C, 0x77, 0x30, 0xDB, 0x0E, 0x40, 0x5C, 0x0C, 0x77, 0x20, 0x1C,
  0x0B, 0x40, 0x5C, 0x0C, 0x77, 0x20, 0x5C, 0x08, 0x40, 0x5F, 0xF0, 0x66, 0x08, 0xC0, 0x54, 0x05,
  0xFF, 0x06, 0x60, 0xCC, 0x02, 0x40, 0x5F, 0xF0, 0x66, 0xC0, 0xE5, 0x05, 0xFF, 0x06, 0x50, 0x3C,
  0x0B, 0x50, 0x5C, 0x0D, 0x80, 0x56, 0x02, 0x50, 0x6C, 0x08, 0x50, 0x5C, 0x0C, 0x77, 0x10, 0xAC,
  0x04, 0x50, 0x5C, 0x0C, 0x77, 0x10, 0xDF, 0xF9, 0x0C, 0x77, 0x01, 0xFF, 0xA0, 0xC7, 0x70, 0x5F,
  0xFA, 0x0C, 0x77, 0x08, 0xFF, 0xA0, 0xC7, 0x70, 0xCC, 0x07, 0x80, 0x26, 0x09, 0xC0, 0xC7, 0x7D,
  0x70, 0x5C, 0x0C, 0x76, 0x03, 0xC0, 0xC7, 0x05, 0xC0, 0xC7, 0x60, 0x7C, 0x09, 0x70, 0x5C, 0x0C,
  0x76, 0x0A, 0xC0, 0x57, 0x05, 0xC0, 0xC7, 0x60, 0xDC, 0x02, 0x70, 0x5C, 0x0C, 0x75, 0x01, 0xC0,
  0xE7, 0x10, 0x5C, 0x0C, 0x75, 0x05, 0xC0, 0xB7, 0x10, 0x5C, 0x0C, 0x75, 0x08, 0xC0, 0x87, 0x10,
  0x5C, 0x0C, 0x75, 0x0C, 0xC0, 0x57, 0x10, 0x5C, 0x0D, 0x80, 0x66, 0x03, 0x1D, 0x02, 0x71, 0x05,
  0xFF, 0x90, 0x90, 0x3C, 0x0E, 0x72, 0x05, 0xFF, 0x90, 0x90, 0x7C, 0x0B, 0x72, 0x05, 0xFF, 0x90,
  0x90, 0xAC, 0x08, 0x72, 0x05, 0xFF, 0x90, 0x90,
  // "Ç" (U+00C7)
  0x77, 0x87, 0x25, 0x67, 0x76, 0x54, 0x27, 0x73, 0x81, 0x5B, 0xEF, 0xA8, 0x2E, 0xB7, 0x27, 0x40,
  0x70, 0xEF, 0xFA, 0x0C, 0x05, 0x70, 0x30, 0xDF, 0xFD, 0x0A, 0x60, 0x6F, 0xB0, 0x0E, 0xFA, 0x03,
  0x50, 0x7F, 0x81, 0xB6, 0x24, 0x82, 0x14, 0x7B, 0xB0, 0xB5, 0x05, 0xE0, 0xB0, 0x27, 0x48, 0x21,
  0x7E, 0x44, 0x01, 0x0E, 0xD0, 0x87, 0x77, 0x0B, 0xD0, 0x87, 0x77, 0x04, 0xD0, 0xB7, 0x77, 0x10,
  0xCD, 0x02, 0x77, 0x70, 0x2D, 0x09, 0x77, 0x71, 0x08, 0xD0, 0x27, 0x77, 0x10, 0xDC, 0x0C, 0x77,
  0x71, 0x01, 0xD0, 0x77, 0x77, 0x10, 0x5D, 0x03, 0x77, 0x71, 0x08, 0xD7, 0x77, 0x20, 0xAC, 0x0D,
  0x77, 0x72, 0x0C, 0xC0, 0xB7, 0x77, 0x20, 0xEC, 0x09, 0x77, 0x72, 0xD0, 0x97, 0x77, 0x2D, 0x08,
  0x77, 0x72, 0xD0, 0x77, 0x77, 0x2D, 0x08, 0x77, 0x72, 0xD0, 0x87, 0x77, 0x20, 0xEC, 0x09, 0x77,
  0x72, 0x0C, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0C, 0x77, 0x72, 0x09, 0xD7, 0x77, 0x20, 0x6D, 0x02,
  0x77, 0x71, 0x02, 0xD0, 0x67, 0x77, 0x20, 0xEC, 0x0B, 0x77, 0x72, 0x09, 0xD7, 0x77, 0x20, 0x5D,
  0x06, 0x77, 0x72, 0x0D, 0xC0, 0xE7, 0x77, 0x20, 0x7D, 0x07, 0x77, 0x72, 0x0E, 0xD0, 0x37, 0x77,
  0x10, 0x5D, 0x0E, 0x03, 0x77, 0x71, 0x09, 0xE0, 0x87, 0x68, 0x13, 0x81, 0x60, 0xBE, 0x82, 0xE9,
  0x41, 0x48, 0x31, 0x36, 0x9D, 0xA0, 0x27, 0x0B, 0xFB, 0x00, 0xEF, 0x90, 0x27, 0x10, 0x8F, 0xFD,
  0x02, 0x72, 0x03, 0x0B, 0xFF, 0xB0, 0x27, 0x48, 0x12, 0x8D, 0xFB, 0x82, 0xEB, 0x72, 0x77, 0x20,
  0x4C, 0x82, 0x65, 0x42, 0x77, 0x60, 0x6B, 0x01, 0x77, 0x73, 0x0D, 0xA0, 0xC7, 0x77, 0x30, 0x5D,
  0x0A, 0x02, 0x77, 0x70, 0x9F, 0x06, 0x77, 0x71, 0x04, 0x09, 0xD0, 0x37, 0x77, 0x20, 0x20, 0xEB,
  0x09, 0x77, 0x73, 0x08, 0xB0, 0xB7, 0x77, 0x30, 0x7B, 0x0B, 0x77, 0x73, 0x0B, 0xB0, 0x97, 0x73,
  0x03, 0x01, 0x28, 0x11, 0x4A, 0xC0, 0x37, 0x72, 0x01, 0xFB, 0x08, 0x77, 0x30, 0x1F, 0x90, 0xE0,
  0x67, 0x75, 0x0C, 0x0E, 0xA8, 0x3E, 0xCA, 0x61, 0x72,
  // "È" (U+00C8)
  0x50, 0x58, 0x01, 0x70, 0x57, 0x75, 0x06, 0xE0, 0x27, 0x75, 0x0A, 0xD0, 0xB7, 0x76, 0x0C, 0xD0,
  0x57, 0x75, 0x01, 0x0D, 0xC0, 0xE0, 0x17, 0x75, 0x02, 0x0D, 0xC0, 0x97, 0x76, 0x02, 0x0D, 0xC0,
  0x47, 0x76, 0x02, 0x0D, 0xB0, 0xE0, 0x17, 0x76, 0x01, 0x0C, 0xB0, 0xB7, 0x77, 0x10, 0xAB, 0x05,
  0x80, 0xA8, 0x60, 0x04, 0xFF, 0xFB, 0x0E, 0x04, 0xFF, 0xFB, 0x0E, 0x04, 0xFF, 0xFB, 0x0E, 0x04,
  0xFF, 0xFB, 0x0E, 0x04, 0xD0, 0x78, 0x09, 0x66, 0x05, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17,
  0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17,
  0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17,
  0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xFF, 0xFA,
  0x81, 0xB0, 0x4F, 0xFF, 0xA8, 0x1B, 0x04, 0xFF, 0xFA, 0x81, 0xB0, 0x4F, 0xFF, 0xA8, 0x1B, 0x04,
  0xD0, 0x78, 0x09, 0x56, 0x81, 0x40, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01,
  0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01,
  0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01,
  0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01,
  0x77, 0x50, 0x4D, 0x07, 0x80, 0x96, 0x60, 0x50, 0x4F, 0xFF, 0xB0, 0xE0, 0x4F, 0xFF, 0xB0, 0xE0,
  0x4F, 0xFF, 0xB0, 0xE0, 0x4F, 0xFF, 0xB0, 0xE0,
  // "É" (U+00C9)
  0x77, 0x20, 0x58, 0x01, 0x70, 0x67, 0x74, 0x01, 0xE0, 0x97, 0x74, 0x0A, 0xD0, 0xC7, 0x74, 0x04,
  0xD0, 0xD0, 0x17, 0x74, 0x0D, 0xC0, 0xE0, 0x27, 0x74, 0x08, 0xC0, 0xE0, 0x27, 0x74, 0x03, 0xC0,
  0xE0, 0x37, 0x75, 0x0D, 0xB0, 0xE0, 0x37, 0x75, 0x09, 0xB0, 0xD0, 0x27, 0x75, 0x03, 0xB0, 0xB0,
  0x18, 0x0A, 0x90, 0x00, 0x4F, 0xFF, 0xB0, 0xE0, 0x4F, 0xFF, 0xB0, 0xE0, 0x4F, 0xFF, 0xB0, 0xE0,
  0x4F, 0xFF, 0xB0, 0xE0, 0x4D, 0x07, 0x80, 0x96, 0x60, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01,
  0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01,
  0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01,
  0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4F, 0xFF,
  0xA8, 0x1B, 0x04, 0xFF, 0xFA, 0x81, 0xB0, 0x4F, 0xFF, 0xA8, 0x1B, 0x04, 0xFF, 0xFA, 0x81, 0xB0,
  0x4D, 0x07, 0x80, 0x95, 0x68, 0x14, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0,
  0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0,
  0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0,
  0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0,
  0x17, 0x75, 0x04, 0xD0, 0x78, 0x09, 0x66, 0x05, 0x04, 0xFF, 0xFB, 0x0E, 0x04, 0xFF, 0xFB, 0x0E,
  0x04, 0xFF, 0xFB, 0x0E, 0x04, 0xFF, 0xFB, 0x0E,
  // "Ê" (U+00CA)
  0x73, 0x80, 0x17, 0x06, 0x77, 0x50, 0x6E, 0x04, 0x77, 0x30, 0x20, 0xEE, 0x0D, 0x01, 0x77, 0x10,
  0x10, 0xDF, 0x90, 0xB7, 0x71, 0x0B, 0xC0, 0xA0, 0xCC, 0x09, 0x76, 0x09, 0xC8, 0x29, 0x01, 0xCC,
  0x07, 0x74, 0x07, 0xC0, 0x93, 0x01, 0x0C, 0xC0, 0x67, 0x20, 0x6C, 0x08, 0x60, 0xBC, 0x05, 0x70,
  0x5C, 0x07, 0x71, 0x09, 0xC0, 0x45, 0x01, 0xB0, 0xD0, 0x37, 0x30, 0x50, 0xEB, 0x01, 0x80, 0xA8,
  0x00, 0x04, 0xFF, 0xFB, 0x0E, 0x04, 0xFF, 0xFB, 0x0E, 0x04, 0xFF, 0xFB, 0x0E, 0x04, 0xFF, 0xFB,
  0x0E, 0x04, 0xD0, 0x78, 0x09, 0x66, 0x05, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04,
  0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04,
  0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04,
  0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xFF, 0xFA, 0x81, 0xB0,
  0x4F, 0xFF, 0xA8, 0x1B, 0x04, 0xFF, 0xFA, 0x81, 0xB0, 0x4F, 0xFF, 0xA8, 0x1B, 0x04, 0xD0, 0x78,
  0x09, 0x56, 0x81, 0x40, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50,
  0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50,
  0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50,
  0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50,
  0x4D, 0x07, 0x80, 0x96, 0x60, 0x50, 0x4F, 0xFF, 0xB0, 0xE0, 0x4F, 0xFF, 0xB0, 0xE0, 0x4F, 0xFF,
  0xB0, 0xE0, 0x4F, 0xFF, 0xB0, 0xE0,
  // "Ë" (U+00CB)
  0x48, 0x38, 0xDE, 0xB2, 0x71, 0x84, 0x2A, 0xEE, 0x91, 0x60, 0xAC, 0x0E, 0x01, 0x70, 0xDC, 0x0B,
  0x6E, 0x05, 0x60, 0x3E, 0x01, 0x5E, 0x06, 0x60, 0x4E, 0x02, 0x50, 0xED, 0x04, 0x60, 0x2E, 0x60,
  0x8C, 0x0D, 0x71, 0x0C, 0xC0, 0x97, 0x83, 0x7D, 0xEA, 0x27, 0x18, 0x31, 0xAE, 0xD8, 0x80, 0xAB,
  0x40, 0x04, 0xFF, 0xFB, 0x0E, 0x04, 0xFF, 0xFB, 0x0E, 0x04, 0xFF, 0xFB, 0x0E, 0x04, 0xFF, 0xFB,
  0x0E, 0x04, 0xD0, 0x78, 0x09, 0x66, 0x05, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04,
  0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04,
  0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04,
  0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xFF, 0xFA, 0x81, 0xB0,
  0x4F, 0xFF, 0xA8, 0x1B, 0x04, 0xFF, 0xFA, 0x81, 0xB0, 0x4F, 0xFF, 0xA8, 0x1B, 0x04, 0xD0, 0x78,
  0x09, 0x56, 0x81, 0x40, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50,
  0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50,
  0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50,
  0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50,
  0x4D, 0x07, 0x80, 0x96, 0x60, 0x50, 0x4F, 0xFF, 0xB0, 0xE0, 0x4F, 0xFF, 0xB0, 0xE0, 0x4F, 0xFF,
  0xB0, 0xE0, 0x4F, 0xFF, 0xB0, 0xE0,
  // "Ì" (U+00CC)
  0x40, 0x58, 0x01, 0x70, 0x57, 0x73, 0x06, 0xE0, 0x27, 0x73, 0x0A, 0xD0, 0xB7, 0x74, 0x0C, 0xD0,
  0x57, 0x73, 0x01, 0x0D, 0xC0, 0xE0, 0x17, 0x73, 0x02, 0x0D, 0xC0, 0x97, 0x74, 0x02, 0x0D, 0xC0,
  0x47, 0x74, 0x02, 0x0D, 0xB0, 0xE0, 0x17, 0x74, 0x01, 0x0C, 0xB0, 0xB7, 0x76, 0x0A, 0xB0, 0x58,
  0x09, 0xF3, 0x00, 0x6F, 0xFF, 0x90, 0x06, 0xFF, 0xF9, 0x00, 0x6F, 0xFF, 0x90, 0x06, 0xFF, 0xF9,
  0x89, 0x06, 0x14, 0x67, 0x8A, 0xBD, 0xEE, 0x87, 0xED, 0xBA, 0x87, 0x64, 0x17, 0x20, 0xBC, 0x09,
  0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09,
  0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09,
  0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09,
  0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09,
  0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09,
  0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09,
  0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09,
  0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09,
  0x77, 0x83, 0x13, 0x45, 0xDC, 0x83, 0xC5, 0x43, 0x15, 0x82, 0x4B, 0xDE, 0xFF, 0xA8, 0x3E, 0xDB,
  0x46, 0xFF, 0xF9, 0x00, 0x6F, 0xFF, 0x90, 0x06, 0xFF, 0xF9, 0x06,
  // "Í" (U+00CD)
  0x77, 0x10, 0x58, 0x01, 0x70, 0x67, 0x72, 0x01, 0xE0, 0x97, 0x72, 0x0A, 0xD0, 0xC7, 0x72, 0x04,
  0xD0, 0xD0, 0x17, 0x72, 0x0D, 0xC0, 0xE0, 0x27, 0x72, 0x08, 0xC0, 0xE0, 0x27, 0x72, 0x03, 0xC0,
  0xE0, 0x37, 0x73, 0x0D, 0xB0, 0xE0, 0x37, 0x73, 0x09, 0xB0, 0xD0, 0x27, 0x73, 0x03, 0xB0, 0xB0,
  0x18, 0x09, 0xF5, 0x00, 0x6F, 0xFF, 0x90, 0x06, 0xFF, 0xF9, 0x00, 0x6F, 0xFF, 0x90, 0x06, 0xFF,
  0xF9, 0x89, 0x06, 0x14, 0x67, 0x8A, 0xBD, 0xEE, 0x87, 0xED, 0xBA, 0x87, 0x64, 0x17, 0x20, 0xBC,
  0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC,
  0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC,
  0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC,
  0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC,
  0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC,
  0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC,
  0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC,
  0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC,
  0x09, 0x77, 0x83, 0x13, 0x45, 0xDC, 0x83, 0xC5, 0x43, 0x15, 0x82, 0x4B, 0xDE, 0xFF, 0xA8, 0x3E,
  0xDB, 0x46, 0xFF, 0xF9, 0x00, 0x6F, 0xFF, 0x90, 0x06, 0xFF, 0xF9, 0x06,
  // "Î" (U+00CE)
  0x72, 0x80, 0x17, 0x06, 0x77, 0x30, 0x6E, 0x04, 0x77, 0x10, 0x20, 0xEE, 0x0D, 0x01, 0x76, 0x01,
  0x0D, 0xF9, 0x0B, 0x76, 0x0B, 0xC0, 0xA0, 0xCC, 0x09, 0x74, 0x09, 0xC8, 0x29, 0x01, 0xCC, 0x07,
  0x72, 0x07, 0xC0, 0x93, 0x01, 0x0C, 0xC0, 0x67, 0x06, 0xC0, 0x86, 0x0B, 0xC0, 0x55, 0x05, 0xC0,
  0x77, 0x10, 0x9C, 0x04, 0x30, 0x1B, 0x0D, 0x03, 0x73, 0x05, 0x0E, 0xB0, 0x18, 0x09, 0xE5, 0x00,
  0x6F, 0xFF, 0x90, 0x06, 0xFF, 0xF9, 0x00, 0x6F, 0xFF, 0x90, 0x06, 0xFF, 0xF9, 0x89, 0x06, 0x14,
  0x67, 0x8A, 0xBD, 0xEE, 0x87, 0xED, 0xBA, 0x87, 0x64, 0x17, 0x20, 0xBC, 0x09, 0x77, 0x40, 0xBC,
  0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC,
  0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC,
  0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC,
  0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC,
  0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC,
  0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC,
  0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC,
  0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x83, 0x13,
  0x45, 0xDC, 0x83, 0xC5, 0x43, 0x15, 0x82, 0x4B, 0xDE, 0xFF, 0xA8, 0x3E, 0xDB, 0x46, 0xFF, 0xF9,
  0x00, 0x6F, 0xFF, 0x90, 0x06, 0xFF, 0xF9, 0x06,
  // "Ï" (U+00CF)
  0x38, 0x38, 0xDE, 0xB2, 0x71, 0x84, 0x2A, 0xEE, 0x91, 0x40, 0xAC, 0x0E, 0x01, 0x70, 0xDC, 0x0B,
  0x4E, 0x05, 0x60, 0x3E, 0x01, 0x3E, 0x06, 0x60, 0x4E, 0x02, 0x30, 0xED, 0x04, 0x60, 0x2E, 0x40,
  0x8C, 0x0D, 0x71, 0x0C, 0xC0, 0x95, 0x83, 0x7D, 0xEA, 0x27, 0x18, 0x31, 0xAE, 0xD8, 0x80, 0xA9,
  0x70, 0x06, 0xFF, 0xF9, 0x00, 0x6F, 0xFF, 0x90, 0x06, 0xFF, 0xF9, 0x00, 0x6F, 0xFF, 0x98, 0x90,
  0x61, 0x46, 0x78, 0xAB, 0xDE, 0xE8, 0x7E, 0xDB, 0xA8, 0x76, 0x41, 0x72, 0x0B, 0xC0, 0x97, 0x74,
  0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74,
  0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74,
  0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74,
  0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74,
  0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74,
  0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74,
  0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74,
  0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x78,
  0x31, 0x34, 0x5D, 0xC8, 0x3C, 0x54, 0x31, 0x58, 0x24, 0xBD, 0xEF, 0xFA, 0x83, 0xED, 0xB4, 0x6F,
  0xFF, 0x90, 0x06, 0xFF, 0xF9, 0x00, 0x6F, 0xFF, 0x90, 0x60,
  // "Ð" (U+00D0)
  0x40, 0x3F, 0xC8, 0x4E, 0xDB, 0x85, 0x17, 0x72, 0x03, 0xFF, 0xB0, 0xB0, 0x57, 0x70, 0x3F, 0xFD,
  0x0D, 0x04, 0x75, 0x03, 0xFF, 0xF0, 0x97, 0x40, 0x3D, 0x08, 0x80, 0x16, 0x81, 0x8A, 0xDF, 0x90,
  0xC0, 0x17, 0x20, 0x3D, 0x03, 0x71, 0x81, 0x28, 0xEE, 0x0C, 0x72, 0x03, 0xD0, 0x37, 0x30, 0x10,
  0x9E, 0x0A, 0x71, 0x03, 0xD0, 0x37, 0x50, 0x5E, 0x06, 0x70, 0x3D, 0x03, 0x76, 0x05, 0xD0, 0xE0,
  0x16, 0x03, 0xD0, 0x37, 0x70, 0x8D, 0x08, 0x60, 0x3D, 0x03, 0x77, 0x10, 0xDC, 0x0E, 0x60, 0x3D,
  0x03, 0x77, 0x10, 0x5D, 0x06, 0x50, 0x3D, 0x03, 0x77, 0x20, 0xEC, 0x0B, 0x50, 0x3D, 0x03, 0x77,
  0x20, 0x9D, 0x50, 0x3D, 0x03, 0x77, 0x20, 0x5D, 0x04, 0x40, 0x3D, 0x03, 0x77, 0x20, 0x2D, 0x06,
  0x40, 0x3D, 0x03, 0x77, 0x30, 0xEC, 0x09, 0x40, 0x3D, 0x03, 0x77, 0x30, 0xCC, 0x0B, 0x40, 0x3D,
  0x03, 0x77, 0x30, 0xBC, 0x84, 0xC6, 0x66, 0x68, 0xD0, 0x88, 0x02, 0x60, 0x37, 0x30, 0xAC, 0x0C,
  0xFF, 0xB0, 0x87, 0x30, 0xAC, 0x0D, 0xFF, 0xB0, 0x87, 0x30, 0x9C, 0x0D, 0xFF, 0xB0, 0x87, 0x30,
  0xAC, 0x0D, 0xFF, 0xB0, 0x87, 0x30, 0xAC, 0x0C, 0x40, 0x3D, 0x03, 0x77, 0x30, 0xCC, 0x0B, 0x40,
  0x3D, 0x03, 0x77, 0x30, 0xDC, 0x0A, 0x40, 0x3D, 0x03, 0x77, 0x3D, 0x08, 0x40, 0x3D, 0x03, 0x77,
  0x20, 0x3D, 0x05, 0x40, 0x3D, 0x03, 0x77, 0x20, 0x7D, 0x02, 0x40, 0x3D, 0x03, 0x77, 0x20, 0xCC,
  0x0D, 0x50, 0x3D, 0x03, 0x77, 0x10, 0x2D, 0x09, 0x50, 0x3D, 0x03, 0x77, 0x10, 0x8D, 0x04, 0x50,
  0x3D, 0x03, 0x77, 0x02, 0xD0, 0xD6, 0x03, 0xD0, 0x37, 0x70, 0xBD, 0x06, 0x60, 0x3D, 0x03, 0x76,
  0x08, 0xD0, 0xD7, 0x03, 0xD0, 0x37, 0x50, 0x8E, 0x03, 0x70, 0x3D, 0x03, 0x73, 0x02, 0x0B, 0xE0,
  0x77, 0x10, 0x3D, 0x03, 0x71, 0x04, 0x0A, 0xF0, 0x97, 0x20, 0x3D, 0x86, 0x86, 0x66, 0x67, 0x9C,
  0xFA, 0x08, 0x73, 0x03, 0xFF, 0xE0, 0xE0, 0x57, 0x40, 0x3F, 0xFD, 0x09, 0x01, 0x75, 0x03, 0xFF,
  0xA8, 0x1D, 0x82, 0x77, 0x03, 0xFB, 0x84, 0xED, 0xB9, 0x63, 0x76,
  // "Ñ" (U+00D1)
  0x68, 0x51, 0x8D, 0xED, 0xB4, 0x71, 0x05, 0xA0, 0xB7, 0x10, 0x20, 0xEE, 0x0B, 0x02, 0x60, 0xBA,
  0x08, 0x70, 0x10, 0xDF, 0xA0, 0x74, 0x04, 0xB0, 0x47, 0x08, 0xFC, 0x82, 0xE9, 0x79, 0xB0, 0xE7,
  0x10, 0xEB, 0x82, 0x97, 0x8D, 0xFC, 0x08, 0x70, 0x5B, 0x05, 0x40, 0x70, 0xEF, 0x90, 0xD7, 0x10,
  0x8A, 0x0B, 0x60, 0x20, 0xBE, 0x0E, 0x02, 0x71, 0x0B, 0xA0, 0x67, 0x18, 0x54, 0xAD, 0xFD, 0x81,
  0x80, 0xA9, 0x60, 0x0C, 0xE0, 0x87, 0x70, 0x6C, 0x00, 0xCE, 0x0E, 0x77, 0x06, 0xC0, 0x0C, 0xF0,
  0x67, 0x60, 0x6C, 0x00, 0xCF, 0x0D, 0x76, 0x06, 0xC0, 0x0C, 0xF9, 0x04, 0x75, 0x06, 0xC0, 0x0C,
  0xF9, 0x0B, 0x75, 0x06, 0xC0, 0x0C, 0xB0, 0xA0, 0xDC, 0x02, 0x74, 0x06, 0xC0, 0x0C, 0xB0, 0xB0,
  0x7C, 0x09, 0x74, 0x06, 0xC0, 0x0C, 0xB8, 0x1D, 0x1E, 0xB0, 0xE0, 0x17, 0x30, 0x6C, 0x00, 0xCB,
  0x81, 0xE0, 0x9C, 0x07, 0x73, 0x06, 0xC0, 0x0C, 0xC1, 0x02, 0xC0, 0xD7, 0x30, 0x6C, 0x00, 0xCC,
  0x81, 0x10, 0xAC, 0x05, 0x72, 0x06, 0xC0, 0x0C, 0xC8, 0x12, 0x03, 0xC0, 0xB7, 0x20, 0x6C, 0x00,
  0xCC, 0x03, 0x20, 0xCC, 0x03, 0x71, 0x06, 0xC0, 0x0C, 0xC0, 0x32, 0x05, 0xC0, 0x97, 0x10, 0x6C,
  0x00, 0xCC, 0x04, 0x30, 0xDC, 0x01, 0x70, 0x6C, 0x00, 0xCC, 0x04, 0x30, 0x7C, 0x07, 0x70, 0x6C,
  0x00, 0xCC, 0x05, 0x30, 0x10, 0xEB, 0x0E, 0x70, 0x6C, 0x00, 0xCC, 0x06, 0x40, 0x9C, 0x05, 0x60,
  0x6C, 0x00, 0xCC, 0x06, 0x40, 0x2C, 0x0C, 0x60, 0x6C, 0x00, 0xCC, 0x06, 0x50, 0xBC, 0x03, 0x50,
  0x6C, 0x00, 0xCC, 0x06, 0x50, 0x4C, 0x0A, 0x50, 0x6C, 0x00, 0xCC, 0x06, 0x60, 0xCC, 0x01, 0x40,
  0x6C, 0x00, 0xCC, 0x06, 0x60, 0x5C, 0x08, 0x40, 0x6C, 0x00, 0xCC, 0x06, 0x70, 0xEB, 0x0E, 0x40,
  0x6C, 0x00, 0xCC, 0x06, 0x70, 0x7C, 0x06, 0x30, 0x6C, 0x00, 0xCC, 0x06, 0x70, 0x1C, 0x0D, 0x30,
  0x6C, 0x00, 0xCC, 0x06, 0x71, 0x09, 0xC0, 0x42, 0x05, 0xC0, 0x0C, 0xC0, 0x67, 0x10, 0x2C, 0x0B,
  0x20, 0x5C, 0x00, 0xCC, 0x06, 0x72, 0x0B, 0xC8, 0x12, 0x04, 0xC0, 0x0C, 0xC0, 0x67, 0x20, 0x4C,
  0x81, 0x90, 0x3C, 0x00, 0xCC, 0x06, 0x73, 0x0C, 0xB8, 0x1E, 0x13, 0xC0, 0x0C, 0xC0, 0x67, 0x30,
  0x6C, 0x07, 0x02, 0xC0, 0x0C, 0xC0, 0x67, 0x40, 0xEB, 0x0D, 0x01, 0xC0, 0x0C, 0xC0, 0x67, 0x40,
  0x7C, 0x05, 0xC0, 0x0C, 0xC0, 0x67, 0x40, 0x1C, 0x0B, 0x0E, 0xB0, 0x0C, 0xC0, 0x67, 0x50, 0x9F,
  0x90, 0x0C, 0xC0, 0x67, 0x50, 0x2F, 0x90, 0x0C, 0xC0, 0x67, 0x60, 0xBF, 0x00, 0xCC, 0x06, 0x76,
  0x04, 0xF0, 0x0C, 0xC0, 0x67, 0x70, 0xDE, 0x00, 0xCC, 0x06, 0x77, 0x06, 0xE0, 0x0C, 0xC0, 0x67,
  0x71, 0x0E, 0xD0, 0xC0,
  // "Ò" (U+00D2)
  0x71, 0x05, 0x80, 0x17, 0x05, 0x77, 0x74, 0x06, 0xE0, 0x27, 0x77, 0x40, 0xAD, 0x0B, 0x77, 0x75,
  0x0C, 0xD0, 0x57, 0x77, 0x40, 0x10, 0xDC, 0x0E, 0x01, 0x77, 0x74, 0x02, 0x0D, 0xC0, 0x97, 0x77,
  0x50, 0x20, 0xDC, 0x04, 0x77, 0x75, 0x02, 0x0D, 0xB0, 0xE0, 0x17, 0x77, 0x50, 0x10, 0xCB, 0x0B,
  0x77, 0x77, 0x0A, 0xB0, 0x58, 0x0A, 0xA3, 0x08, 0x61, 0x46, 0x77, 0x64, 0x17, 0x77, 0x81, 0x18,
  0xDF, 0x98, 0x1D, 0x82, 0x77, 0x30, 0x8F, 0xF0, 0x87, 0x70, 0x10, 0xCF, 0xFA, 0x0D, 0x01, 0x74,
  0x01, 0x0D, 0xF9, 0x00, 0xEF, 0x90, 0xD0, 0x27, 0x30, 0xCE, 0x09, 0x03, 0x48, 0x13, 0x7E, 0xD0,
  0xC7, 0x20, 0x9D, 0x0C, 0x01, 0x71, 0x01, 0x0A, 0xD0, 0x97, 0x02, 0xD0, 0xC7, 0x50, 0xAD, 0x03,
  0x60, 0xAC, 0x0E, 0x01, 0x75, 0x01, 0x0E, 0xC0, 0xB5, 0x02, 0xD0, 0x77, 0x70, 0x6D, 0x02, 0x40,
  0x8D, 0x01, 0x77, 0x01, 0xD0, 0x84, 0x0D, 0xC0, 0xB7, 0x72, 0x0A, 0xC0, 0xD3, 0x01, 0xD0, 0x67,
  0x72, 0x05, 0xD0, 0x12, 0x05, 0xD0, 0x27, 0x72, 0x01, 0xD0, 0x52, 0x08, 0xC0, 0xE7, 0x74, 0x0D,
  0xC0, 0x82, 0x0B, 0xC0, 0xB7, 0x74, 0x0B, 0xC0, 0xB2, 0x0E, 0xC0, 0x97, 0x74, 0x09, 0xC0, 0xE2,
  0xD0, 0x77, 0x74, 0x07, 0xD1, 0x01, 0xD0, 0x57, 0x74, 0x05, 0xD0, 0x10, 0x3D, 0x05, 0x77, 0x40,
  0x5D, 0x00, 0x3D, 0x04, 0x77, 0x40, 0x4D, 0x03, 0x04, 0xD0, 0x37, 0x74, 0x03, 0xD0, 0x04, 0xD0,
  0x37, 0x74, 0x03, 0xD0, 0x04, 0xD0, 0x37, 0x74, 0x03, 0xD0, 0x40, 0x3D, 0x04, 0x77, 0x40, 0x4D,
  0x00, 0x3D, 0x05, 0x77, 0x40, 0x5D, 0x03, 0x01, 0xD0, 0x57, 0x74, 0x05, 0xD0, 0x11, 0xD0, 0x77,
  0x74, 0x07, 0xD2, 0x0E, 0xC0, 0x97, 0x74, 0x09, 0xC0, 0xD2, 0x0B, 0xC0, 0xB7, 0x74, 0x0B, 0xC0,
  0xB2, 0x09, 0xC0, 0xE7, 0x74, 0x0E, 0xC0, 0x82, 0x06, 0xD0, 0x27, 0x72, 0x02, 0xD0, 0x52, 0x02,
  0xD0, 0x57, 0x72, 0x05, 0xD0, 0x13, 0x0D, 0xC0, 0xA7, 0x72, 0x0A, 0xC0, 0xC4, 0x08, 0xD0, 0x17,
  0x70, 0x1D, 0x07, 0x40, 0x2D, 0x07, 0x77, 0x06, 0xD0, 0x15, 0x0B, 0xC0, 0xE0, 0x17, 0x50, 0x10,
  0xEC, 0x0A, 0x60, 0x3D, 0x0B, 0x75, 0x0B, 0xD0, 0x27, 0x09, 0xD0, 0xB0, 0x17, 0x10, 0x10, 0xBD,
  0x08, 0x72, 0x0D, 0xD8, 0x1E, 0x83, 0x48, 0x13, 0x8E, 0xD0, 0xC7, 0x30, 0x20, 0xDF, 0x90, 0x0E,
  0xF9, 0x0D, 0x01, 0x74, 0x02, 0x0D, 0xFF, 0xA0, 0xC0, 0x17, 0x70, 0x9F, 0xF0, 0x87, 0x73, 0x81,
  0x28, 0xEF, 0x98, 0x1D, 0x81, 0x77, 0x78, 0x62, 0x56, 0x77, 0x64, 0x17, 0x50,
  // "Ó" (U+00D3)
  0x77, 0x50, 0x58, 0x01, 0x70, 0x67, 0x77, 0x30, 0x1E, 0x09, 0x77, 0x73, 0x0A, 0xD0, 0xC7, 0x77,
  0x30, 0x4D, 0x0D, 0x01, 0x77, 0x73, 0x0D, 0xC0, 0xE0, 0x27, 0x77, 0x30, 0x8C, 0x0E, 0x02, 0x77,
  0x73, 0x03, 0xC0, 0xE0, 0x37, 0x77, 0x40, 0xDB, 0x0E, 0x03, 0x77, 0x74, 0x09, 0xB0, 0xD0, 0x27,
  0x77, 0x40, 0x3B, 0x0B, 0x01, 0x80, 0xAA, 0x50, 0x86, 0x14, 0x67, 0x76, 0x41, 0x77, 0x78, 0x11,
  0x8D, 0xF9, 0x81, 0xD8, 0x27, 0x73, 0x08, 0xFF, 0x08, 0x77, 0x01, 0x0C, 0xFF, 0xA0, 0xD0, 0x17,
  0x40, 0x10, 0xDF, 0x90, 0x0E, 0xF9, 0x0D, 0x02, 0x73, 0x0C, 0xE0, 0x90, 0x34, 0x81, 0x37, 0xED,
  0x0C, 0x72, 0x09, 0xD0, 0xC0, 0x17, 0x10, 0x10, 0xAD, 0x09, 0x70, 0x2D, 0x0C, 0x75, 0x0A, 0xD0,
  0x36, 0x0A, 0xC0, 0xE0, 0x17, 0x50, 0x10, 0xEC, 0x0B, 0x50, 0x2D, 0x07, 0x77, 0x06, 0xD0, 0x24,
  0x08, 0xD0, 0x17, 0x70, 0x1D, 0x08, 0x40, 0xDC, 0x0B, 0x77, 0x20, 0xAC, 0x0D, 0x30, 0x1D, 0x06,
  0x77, 0x20, 0x5D, 0x01, 0x20, 0x5D, 0x02, 0x77, 0x20, 0x1D, 0x05, 0x20, 0x8C, 0x0E, 0x77, 0x40,
  0xDC, 0x08, 0x20, 0xBC, 0x0B, 0x77, 0x40, 0xBC, 0x0B, 0x20, 0xEC, 0x09, 0x77, 0x40, 0x9C, 0x0E,
  0x2D, 0x07, 0x77, 0x40, 0x7D, 0x10, 0x1D, 0x05, 0x77, 0x40, 0x5D, 0x01, 0x03, 0xD0, 0x57, 0x74,
  0x05, 0xD0, 0x03, 0xD0, 0x47, 0x74, 0x04, 0xD0, 0x30, 0x4D, 0x03, 0x77, 0x40, 0x3D, 0x00, 0x4D,
  0x03, 0x77, 0x40, 0x3D, 0x00, 0x4D, 0x03, 0x77, 0x40, 0x3D, 0x04, 0x03, 0xD0, 0x47, 0x74, 0x04,
  0xD0, 0x03, 0xD0, 0x57, 0x74, 0x05, 0xD0, 0x30, 0x1D, 0x05, 0x77, 0x40, 0x5D, 0x01, 0x1D, 0x07,
  0x77, 0x40, 0x7D, 0x20, 0xEC, 0x09, 0x77, 0x40, 0x9C, 0x0D, 0x20, 0xBC, 0x0B, 0x77, 0x40, 0xBC,
  0x0B, 0x20, 0x9C, 0x0E, 0x77, 0x40, 0xEC, 0x08, 0x20, 0x6D, 0x02, 0x77, 0x20, 0x2D, 0x05, 0x20,
  0x2D, 0x05, 0x77, 0x20, 0x5D, 0x01, 0x30, 0xDC, 0x0A, 0x77, 0x20, 0xAC, 0x0C, 0x40, 0x8D, 0x01,
  0x77, 0x01, 0xD0, 0x74, 0x02, 0xD0, 0x77, 0x70, 0x6D, 0x01, 0x50, 0xBC, 0x0E, 0x01, 0x75, 0x01,
  0x0E, 0xC0, 0xA6, 0x03, 0xD0, 0xB7, 0x50, 0xBD, 0x02, 0x70, 0x9D, 0x0B, 0x01, 0x71, 0x01, 0x0B,
  0xD0, 0x87, 0x20, 0xDD, 0x81, 0xE8, 0x34, 0x81, 0x38, 0xED, 0x0C, 0x73, 0x02, 0x0D, 0xF9, 0x00,
  0xEF, 0x90, 0xD0, 0x17, 0x40, 0x20, 0xDF, 0xFA, 0x0C, 0x01, 0x77, 0x09, 0xFF, 0x08, 0x77, 0x38,
  0x12, 0x8E, 0xF9, 0x81, 0xD8, 0x17, 0x77, 0x86, 0x25, 0x67, 0x76, 0x41, 0x75,
  // "Ô" (U+00D4)
  0x76, 0x80, 0x17, 0x06, 0x77, 0x74, 0x06, 0xE0, 0x47, 0x77, 0x20, 0x20, 0xEE, 0x0D, 0x01, 0x77,
  0x70, 0x10, 0xDF, 0x90, 0xB7, 0x77, 0x0B, 0xC0, 0xA0, 0xCC, 0x09, 0x77, 0x50, 0x9C, 0x82, 0x90,
  0x1C, 0xC0, 0x77, 0x73, 0x07, 0xC0, 0x93, 0x01, 0x0C, 0xC0, 0x67, 0x71, 0x06, 0xC0, 0x86, 0x0B,
  0xC0, 0x57, 0x60, 0x5C, 0x07, 0x71, 0x09, 0xC0, 0x47, 0x40, 0x1B, 0x0D, 0x03, 0x73, 0x05, 0x0E,
  0xB0, 0x18, 0x0A, 0x95, 0x08, 0x61, 0x46, 0x77, 0x64, 0x17, 0x77, 0x81, 0x18, 0xDF, 0x98, 0x1D,
  0x82, 0x77, 0x30, 0x8F, 0xF0, 0x87, 0x70, 0x10, 0xCF, 0xFA, 0x0D, 0x01, 0x74, 0x01, 0x0D, 0xF9,
  0x00, 0xEF, 0x90, 0xD0, 0x27, 0x30, 0xCE, 0x09, 0x03, 0x48, 0x13, 0x7E, 0xD0, 0xC7, 0x20, 0x9D,
  0x0C, 0x01, 0x71, 0x01, 0x0A, 0xD0, 0x97, 0x02, 0xD0, 0xC7, 0x50, 0xAD, 0x03, 0x60, 0xAC, 0x0E,
  0x01, 0x75, 0x01, 0x0E, 0xC0, 0xB5, 0x02, 0xD0, 0x77, 0x70, 0x6D, 0x02, 0x40, 0x8D, 0x01, 0x77,
  0x01, 0xD0, 0x84, 0x0D, 0xC0, 0xB7, 0x72, 0x0A, 0xC0, 0xD3, 0x01, 0xD0, 0x67, 0x72, 0x05, 0xD0,
  0x12, 0x05, 0xD0, 0x27, 0x72, 0x01, 0xD0, 0x52, 0x08, 0xC0, 0xE7, 0x74, 0x0D, 0xC0, 0x82, 0x0B,
  0xC0, 0xB7, 0x74, 0x0B, 0xC0, 0xB2, 0x0E, 0xC0, 0x97, 0x74, 0x09, 0xC0, 0xE2, 0xD0, 0x77, 0x74,
  0x07, 0xD1, 0x01, 0xD0, 0x57, 0x74, 0x05, 0xD0, 0x10, 0x3D, 0x05, 0x77, 0x40, 0x5D, 0x00, 0x3D,
  0x04, 0x77, 0x40, 0x4D, 0x03, 0x04, 0xD0, 0x37, 0x74, 0x03, 0xD0, 0x04, 0xD0, 0x37, 0x74, 0x03,
  0xD0, 0x04, 0xD0, 0x37, 0x74, 0x03, 0xD0, 0x40, 0x3D, 0x04, 0x77, 0x40, 0x4D, 0x00, 0x3D, 0x05,
  0x77, 0x40, 0x5D, 0x03, 0x01, 0xD0, 0x57, 0x74, 0x05, 0xD0, 0x11, 0xD0, 0x77, 0x74, 0x07, 0xD2,
  0x0E, 0xC0, 0x97, 0x74, 0x09, 0xC0, 0xD2, 0x0B, 0xC0, 0xB7, 0x74, 0x0B, 0xC0, 0xB2, 0x09, 0xC0,
  0xE7, 0x74, 0x0E, 0xC0, 0x82, 0x06, 0xD0, 0x27, 0x72, 0x02, 0xD0, 0x52, 0x02, 0xD0, 0x57, 0x72,
  0x05, 0xD0, 0x13, 0x0D, 0xC0, 0xA7, 0x72, 0x0A, 0xC0, 0xC4, 0x08, 0xD0, 0x17, 0x70, 0x1D, 0x07,
  0x40, 0x2D, 0x07, 0x77, 0x06, 0xD0, 0x15, 0x0B, 0xC0, 0xE0, 0x17, 0x50, 0x10, 0xEC, 0x0A, 0x60,
  0x3D, 0x0B, 0x75, 0x0B, 0xD0, 0x27, 0x09, 0xD0, 0xB0, 0x17, 0x10, 0x10, 0xBD, 0x08, 0x72, 0x0D,
  0xD8, 0x1E, 0x83, 0x48, 0x13, 0x8E, 0xD0, 0xC7, 0x30, 0x20, 0xDF, 0x90, 0x0E, 0xF9, 0x0D, 0x01,
  0x74, 0x02, 0x0D, 0xFF, 0xA0, 0xC0, 0x17, 0x70, 0x9F, 0xF0, 0x87, 0x73, 0x81, 0x28, 0xEF, 0x98,
  0x1D, 0x81, 0x77, 0x78, 0x62, 0x56, 0x77, 0x64, 0x17, 0x50,
  // "Õ" (U+00D5)
  0x71, 0x85, 0x18, 0xDE, 0xDB, 0x47, 0x10, 0x5A, 0x0B, 0x75, 0x02, 0x0E, 0xE0, 0xB0, 0x26, 0x0B,
  0xA0, 0x87, 0x40, 0x10, 0xDF, 0xA0, 0x74, 0x04, 0xB0, 0x47, 0x40, 0x8F, 0xC8, 0x2E, 0x97, 0x9B,
  0x0E, 0x75, 0x0E, 0xB8, 0x29, 0x78, 0xDF, 0xC0, 0x87, 0x40, 0x5B, 0x05, 0x40, 0x70, 0xEF, 0x90,
  0xD7, 0x50, 0x8A, 0x0B, 0x60, 0x20, 0xBE, 0x0E, 0x02, 0x75, 0x0B, 0xA0, 0x67, 0x18, 0x54, 0xAD,
  0xFD, 0x81, 0x80, 0xAA, 0x00, 0x86, 0x14, 0x67, 0x76, 0x41, 0x77, 0x78, 0x11, 0x8D, 0xF9, 0x81,
  0xD8, 0x27, 0x73, 0x08, 0xFF, 0x08, 0x77, 0x01, 0x0C, 0xFF, 0xA0, 0xD0, 0x17, 0x40, 0x10, 0xDF,
  0x90, 0x0E, 0xF9, 0x0D, 0x02, 0x73, 0x0C, 0xE0, 0x90, 0x34, 0x81, 0x37, 0xED, 0x0C, 0x72, 0x09,
  0xD0, 0xC0, 0x17, 0x10, 0x10, 0xAD, 0x09, 0x70, 0x2D, 0x0C, 0x75, 0x0A, 0xD0, 0x36, 0x0A, 0xC0,
  0xE0, 0x17, 0x50, 0x10, 0xEC, 0x0B, 0x50, 0x2D, 0x07, 0x77, 0x06, 0xD0, 0x24, 0x08, 0xD0, 0x17,
  0x70, 0x1D, 0x08, 0x40, 0xDC, 0x0B, 0x77, 0x20, 0xAC, 0x0D, 0x30, 0x1D, 0x06, 0x77, 0x20, 0x5D,
  0x01, 0x20, 0x5D, 0x02, 0x77, 0x20, 0x1D, 0x05, 0x20, 0x8C, 0x0E, 0x77, 0x40, 0xDC, 0x08, 0x20,
  0xBC, 0x0B, 0x77, 0x40, 0xBC, 0x0B, 0x20, 0xEC, 0x09, 0x77, 0x40, 0x9C, 0x0E, 0x2D, 0x07, 0x77,
  0x40, 0x7D, 0x10, 0x1D, 0x05, 0x77, 0x40, 0x5D, 0x01, 0x03, 0xD0, 0x57, 0x74, 0x05, 0xD0, 0x03,
  0xD0, 0x47, 0x74, 0x04, 0xD0, 0x30, 0x4D, 0x03, 0x77, 0x40, 0x3D, 0x00, 0x4D, 0x03, 0x77, 0x40,
  0x3D, 0x00, 0x4D, 0x03, 0x77, 0x40, 0x3D, 0x04, 0x03, 0xD0, 0x47, 0x74, 0x04, 0xD0, 0x03, 0xD0,
  0x57, 0x74, 0x05, 0xD0, 0x30, 0x1D, 0x05, 0x77, 0x40, 0x5D, 0x01, 0x1D, 0x07, 0x77, 0x40, 0x7D,
  0x20, 0xEC, 0x09, 0x77, 0x40, 0x9C, 0x0D, 0x20, 0xBC, 0x0B, 0x77, 0x40, 0xBC, 0x0B, 0x20, 0x9C,
  0x0E, 0x77, 0x40, 0xEC, 0x08, 0x20, 0x6D, 0x02, 0x77, 0x20, 0x2D, 0x05, 0x20, 0x2D, 0x05, 0x77,
  0x20, 0x5D, 0x01, 0x30, 0xDC, 0x0A, 0x77, 0x20, 0xAC, 0x0C, 0x40, 0x8D, 0x01, 0x77, 0x01, 0xD0,
  0x74, 0x02, 0xD0, 0x77, 0x70, 0x6D, 0x01, 0x50, 0xBC, 0x0E, 0x01, 0x75, 0x01, 0x0E, 0xC0, 0xA6,
  0x03, 0xD0, 0xB7, 0x50, 0xBD, 0x02, 0x70, 0x9D, 0x0B, 0x01, 0x71, 0x01, 0x0B, 0xD0, 0x87, 0x20,
  0xDD, 0x81, 0xE8, 0x34, 0x81, 0x38, 0xED, 0x0C, 0x73, 0x02, 0x0D, 0xF9, 0x00, 0xEF, 0x90, 0xD0,
  0x17, 0x40, 0x20, 0xDF, 0xFA, 0x0C, 0x01, 0x77, 0x09, 0xFF, 0x08, 0x77, 0x38, 0x12, 0x8E, 0xF9,
  0x81, 0xD8, 0x17, 0x77, 0x86, 0x25, 0x67, 0x76, 0x41, 0x75,
  // "Ö" (U+00D6)
  0x78, 0x38, 0xDE, 0xB2, 0x71, 0x84, 0x2A, 0xEE, 0x91, 0x75, 0x0A, 0xC0, 0xE0, 0x17, 0x0D, 0xC0,
  0xB7, 0x5E, 0x05, 0x60, 0x3E, 0x01, 0x74, 0xE0, 0x66, 0x04, 0xE0, 0x27, 0x40, 0xED, 0x04, 0x60,
  0x2E, 0x75, 0x08, 0xC0, 0xD7, 0x10, 0xCC, 0x09, 0x76, 0x83, 0x7D, 0xEA, 0x27, 0x18, 0x31, 0xAE,
  0xD8, 0x80, 0xAD, 0x70, 0x86, 0x14, 0x67, 0x76, 0x41, 0x77, 0x78, 0x11, 0x8D, 0xF9, 0x81, 0xD8,
  0x27, 0x73, 0x08, 0xFF, 0x08, 0x77, 0x01, 0x0C, 0xFF, 0xA0, 0xD0, 0x17, 0x40, 0x10, 0xDF, 0x90,
  0x0E, 0xF9, 0x0D, 0x02, 0x73, 0x0C, 0xE0, 0x90, 0x34, 0x81, 0x37, 0xED, 0x0C, 0x72, 0x09, 0xD0,
  0xC0, 0x17, 0x10, 0x10, 0xAD, 0x09, 0x70, 0x2D, 0x0C, 0x75, 0x0A, 0xD0, 0x36, 0x0A, 0xC0, 0xE0,
  0x17, 0x50, 0x10, 0xEC, 0x0B, 0x50, 0x2D, 0x07, 0x77, 0x06, 0xD0, 0x24, 0x08, 0xD0, 0x17, 0x70,
  0x1D, 0x08, 0x40, 0xDC, 0x0B, 0x77, 0x20, 0xAC, 0x0D, 0x30, 0x1D, 0x06, 0x77, 0x20, 0x5D, 0x01,
  0x20, 0x5D, 0x02, 0x77, 0x20, 0x1D, 0x05, 0x20, 0x8C, 0x0E, 0x77, 0x40, 0xDC, 0x08, 0x20, 0xBC,
  0x0B, 0x77, 0x40, 0xBC, 0x0B, 0x20, 0xEC, 0x09, 0x77, 0x40, 0x9C, 0x0E, 0x2D, 0x07, 0x77, 0x40,
  0x7D, 0x10, 0x1D, 0x05, 0x77, 0x40, 0x5D, 0x01, 0x03, 0xD0, 0x57, 0x74, 0x05, 0xD0, 0x03, 0xD0,
  0x47, 0x74, 0x04, 0xD0, 0x30, 0x4D, 0x03, 0x77, 0x40, 0x3D, 0x00, 0x4D, 0x03, 0x77, 0x40, 0x3D,
  0x00, 0x4D, 0x03, 0x77, 0x40, 0x3D, 0x04, 0x03, 0xD0, 0x47, 0x74, 0x04, 0xD0, 0x03, 0xD0, 0x57,
  0x74, 0x05, 0xD0, 0x30, 0x1D, 0x05, 0x77, 0x40, 0x5D, 0x01, 0x1D, 0x07, 0x77, 0x40, 0x7D, 0x20,
  0xEC, 0x09, 0x77, 0x40, 0x9C, 0x0D, 0x20, 0xBC, 0x0B, 0x77, 0x40, 0xBC, 0x0B, 0x20, 0x9C, 0x0E,
  0x77, 0x40, 0xEC, 0x08, 0x20, 0x6D, 0x02, 0x77, 0x20, 0x2D, 0x05, 0x20, 0x2D, 0x05, 0x77, 0x20,
  0x5D, 0x01, 0x30, 0xDC, 0x0A, 0x77, 0x20, 0xAC, 0x0C, 0x40, 0x8D, 0x01, 0x77, 0x01, 0xD0, 0x74,
  0x02, 0xD0, 0x77, 0x70, 0x6D, 0x01, 0x50, 0xBC, 0x0E, 0x01, 0x75, 0x01, 0x0E, 0xC0, 0xA6, 0x03,
  0xD0, 0xB7, 0x50, 0xBD, 0x02, 0x70, 0x9D, 0x0B, 0x01, 0x71, 0x01, 0x0B, 0xD0, 0x87, 0x20, 0xDD,
  0x81, 0xE8, 0x34, 0x81, 0x38, 0xED, 0x0C, 0x73, 0x02, 0x0D, 0xF9, 0x00, 0xEF, 0x90, 0xD0, 0x17,
  0x40, 0x20, 0xDF, 0xFA, 0x0C, 0x01, 0x77, 0x09, 0xFF, 0x08, 0x77, 0x38, 0x12, 0x8E, 0xF9, 0x81,
  0xD8, 0x17, 0x77, 0x86, 0x25, 0x67, 0x76, 0x41, 0x75,
  // "×" (U+00D7)
  0x20, 0x70, 0xA7, 0x74, 0x08, 0x09, 0x30, 0x7A, 0x0A, 0x77, 0x20, 0x8A, 0x81, 0x90, 0x7C, 0x0A,
  0x77, 0x08, 0xC0, 0x80, 0x5D, 0x09, 0x75, 0x09, 0xD8, 0x15, 0x05, 0xD0, 0x97, 0x30, 0x9D, 0x05,
  0x30, 0x5D, 0x09, 0x71, 0x09, 0xD0, 0x55, 0x05, 0xD0, 0x96, 0x09, 0xD0, 0x57, 0x05, 0xD0, 0x94,
  0x09, 0xD0, 0x57, 0x20, 0x5D, 0x09, 0x20, 0x9D, 0x05, 0x74, 0x05, 0xD0, 0x09, 0xD0, 0x57, 0x60,
  0x5F, 0xB0, 0x57, 0x71, 0x05, 0xF9, 0x05, 0x77, 0x30, 0x5E, 0x05, 0x77, 0x40, 0xAE, 0x0A, 0x77,
  0x30, 0xAF, 0x90, 0xA7, 0x71, 0x09, 0xFB, 0x0A, 0x76, 0x09, 0xD0, 0x50, 0x6D, 0x0A, 0x74, 0x09,
  0xD0, 0x52, 0x06, 0xD0, 0x97, 0x20, 0x9D, 0x05, 0x40, 0x6D, 0x09, 0x70, 0x9D, 0x05, 0x60, 0x5D,
  0x09, 0x50, 0x9D, 0x05, 0x71, 0x05, 0xD0, 0x93, 0x08, 0xD0, 0x57, 0x30, 0x5D, 0x81, 0x90, 0x8D,
  0x05, 0x75, 0x05, 0xD8, 0x19, 0x2E, 0xB0, 0x57, 0x70, 0x5B, 0x85, 0xE3, 0x02, 0xEF, 0x57, 0x72,
  0x82, 0x4F, 0xE3, 0x30, 0x20, 0x57, 0x74, 0x04, 0x03, 0x20,
  // "Ø" (U+00D8)
  0x77, 0x75, 0x81, 0x1A, 0x27, 0x71, 0x86, 0x14, 0x67, 0x76, 0x52, 0x60, 0xAA, 0x09, 0x01, 0x73,
  0x81, 0x18, 0xDF, 0x98, 0x1E, 0x93, 0x20, 0x4C, 0x0C, 0x72, 0x08, 0xFF, 0x81, 0xA2, 0xDC, 0x03,
  0x70, 0x10, 0xCF, 0xFF, 0x0A, 0x70, 0x10, 0xDF, 0x90, 0x0E, 0xFD, 0x02, 0x70, 0xCE, 0x09, 0x03,
  0x40, 0x40, 0x9F, 0x90, 0x87, 0x08, 0xD0, 0xC0, 0x17, 0x10, 0x30, 0xDD, 0x0E, 0x70, 0x2D, 0x0C,
  0x74, 0x02, 0x0E, 0xD0, 0x36, 0x0A, 0xC0, 0xE0, 0x17, 0x40, 0x3E, 0x0B, 0x50, 0x1D, 0x08, 0x75,
  0x0C, 0xF0, 0x24, 0x07, 0xD0, 0x17, 0x40, 0x5F, 0x90, 0x84, 0x0C, 0xC0, 0xB7, 0x50, 0xDF, 0x90,
  0xD3, 0x01, 0xD0, 0x67, 0x40, 0x7C, 0x0D, 0xD0, 0x22, 0x05, 0xD0, 0x27, 0x30, 0x10, 0xEB, 0x0E,
  0x02, 0xD0, 0x62, 0x08, 0xC0, 0xE7, 0x40, 0x9C, 0x81, 0x70, 0xDC, 0x09, 0x20, 0xBC, 0x0B, 0x73,
  0x03, 0xC0, 0xD2, 0x0B, 0xC0, 0xB2, 0x0D, 0xC0, 0x97, 0x30, 0xBC, 0x04, 0x20, 0x9C, 0x0D, 0x2D,
  0x07, 0x72, 0x05, 0xC0, 0xB3, 0x07, 0xD1, 0x01, 0xD0, 0x57, 0x20, 0xDC, 0x03, 0x30, 0x6D, 0x01,
  0x02, 0xD0, 0x57, 0x10, 0x7C, 0x09, 0x40, 0x4D, 0x02, 0x03, 0xD0, 0x47, 0x01, 0x0E, 0xB0, 0xE0,
  0x14, 0x04, 0xD0, 0x30, 0x4D, 0x03, 0x70, 0x9C, 0x07, 0x50, 0x3D, 0x03, 0x04, 0xD0, 0x36, 0x02,
  0xC0, 0xD6, 0x03, 0xD0, 0x04, 0xD0, 0x36, 0x0B, 0xC0, 0x56, 0x03, 0xD0, 0x40, 0x3D, 0x04, 0x50,
  0x4C, 0x0C, 0x70, 0x4D, 0x03, 0x02, 0xD0, 0x45, 0x0D, 0xC0, 0x37, 0x05, 0xD0, 0x30, 0x1D, 0x05,
  0x40, 0x6C, 0x0A, 0x71, 0x05, 0xD0, 0x01, 0xD0, 0x73, 0x01, 0x0E, 0xC0, 0x17, 0x10, 0x7D, 0x20,
  0xEC, 0x08, 0x30, 0x8C, 0x08, 0x72, 0x09, 0xC0, 0xD2, 0x0B, 0xC0, 0xA2, 0x02, 0xC0, 0xE7, 0x30,
  0xBC, 0x0B, 0x20, 0x9C, 0x0D, 0x20, 0xAC, 0x06, 0x73, 0x0D, 0xC0, 0x82, 0x07, 0xD1, 0x04, 0xC0,
  0xC7, 0x30, 0x1D, 0x05, 0x20, 0x3D, 0x05, 0x0C, 0xC0, 0x47, 0x30, 0x5D, 0x01, 0x30, 0xEC, 0x0D,
  0xC0, 0xA7, 0x40, 0xAC, 0x0C, 0x40, 0xAF, 0xA0, 0x27, 0x4D, 0x07, 0x40, 0x4F, 0x90, 0x87, 0x40,
  0x6D, 0x01, 0x50, 0xDE, 0x0E, 0x01, 0x73, 0x01, 0x0E, 0xC0, 0xA6, 0x06, 0xE0, 0x67, 0x40, 0xAD,
  0x02, 0x70, 0xCD, 0x0C, 0x02, 0x71, 0x01, 0x0A, 0xD0, 0x87, 0x10, 0xCF, 0x09, 0x04, 0x48, 0x13,
  0x8E, 0xD0, 0xC7, 0x10, 0x6F, 0xC0, 0x0E, 0xF9, 0x0D, 0x01, 0x70, 0x10, 0xEF, 0xFE, 0x0C, 0x01,
  0x71, 0x0A, 0xC0, 0x90, 0xBF, 0xF0, 0x87, 0x20, 0x3C, 0x0D, 0x28, 0x14, 0x9E, 0xF9, 0x81, 0xD8,
  0x17, 0x30, 0x30, 0xBB, 0x04, 0x58, 0x62, 0x56, 0x77, 0x64, 0x17, 0x71, 0x81, 0x4C, 0xB7, 0x77,
  0x50,
  // "Ù" (U+00D9)
  0x60, 0x58, 0x01, 0x70, 0x57, 0x77, 0x06, 0xE0, 0x27, 0x77, 0x0A, 0xD0, 0xB7, 0x77, 0x10, 0xCD,
  0x05, 0x77, 0x70, 0x10, 0xDC, 0x0E, 0x01, 0x77, 0x70, 0x20, 0xDC, 0x09, 0x77, 0x71, 0x02, 0x0D,
  0xC0, 0x47, 0x77, 0x10, 0x20, 0xDB, 0x0E, 0x01, 0x77, 0x71, 0x01, 0x0C, 0xB0, 0xB7, 0x77, 0x30,
  0xAB, 0x05, 0x80, 0xAA, 0x10, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09,
  0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97,
  0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C,
  0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09,
  0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97,
  0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C,
  0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09,
  0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97,
  0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C,
  0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09,
  0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0xC0, 0xBC, 0x09,
  0x77, 0x20, 0xAC, 0x00, 0xBC, 0x0A, 0x77, 0x20, 0xAC, 0x0B, 0x0A, 0xC0, 0xB7, 0x72, 0x0B, 0xC0,
  0x90, 0x8C, 0x0E, 0x77, 0x20, 0xEC, 0x08, 0x05, 0xD0, 0x17, 0x70, 0x1D, 0x05, 0x02, 0xD0, 0x57,
  0x70, 0x4D, 0x81, 0x20, 0xEC, 0x0A, 0x77, 0x09, 0xC0, 0xD2, 0x09, 0xD0, 0x27, 0x50, 0x1D, 0x08,
  0x20, 0x3D, 0x0B, 0x75, 0x0B, 0xD0, 0x23, 0x0B, 0xD0, 0xA7, 0x30, 0xAD, 0x0A, 0x40, 0x2E, 0x81,
  0xE7, 0x24, 0x81, 0x27, 0xDD, 0x0E, 0x01, 0x50, 0x6F, 0xA0, 0x0E, 0xFA, 0x04, 0x70, 0x6F, 0xFB,
  0x0E, 0x04, 0x72, 0x03, 0x0D, 0xFF, 0x0B, 0x02, 0x75, 0x05, 0x0B, 0xFA, 0x81, 0xEA, 0x47, 0x73,
  0x86, 0x35, 0x67, 0x76, 0x52, 0x73,
  // "Ú" (U+00DA)
  0x77, 0x30, 0x58, 0x01, 0x70, 0x67, 0x76, 0x01, 0xE0, 0x97, 0x76, 0x0A, 0xD0, 0xC7, 0x76, 0x04,
  0xD0, 0xD0, 0x17, 0x76, 0x0D, 0xC0, 0xE0, 0x27, 0x76, 0x08, 0xC0, 0xE0, 0x27, 0x76, 0x03, 0xC0,
  0xE0, 0x37, 0x77, 0x0D, 0xB0, 0xE0, 0x37, 0x77, 0x09, 0xB0, 0xD0, 0x27, 0x77, 0x03, 0xB0, 0xB0,
  0x18, 0x0A, 0xA3, 0x00, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x00, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x00,
  0xCC, 0x09, 0x77, 0x20, 0x9C, 0x00, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x00, 0xCC, 0x09, 0x77, 0x20,
  0x9C, 0x00, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x00, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x00, 0xCC, 0x09,
  0x77, 0x20, 0x9C, 0x00, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x00, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x00,
  0xCC, 0x09, 0x77, 0x20, 0x9C, 0x00, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x00, 0xCC, 0x09, 0x77, 0x20,
  0x9C, 0x00, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x00, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x00, 0xCC, 0x09,
  0x77, 0x20, 0x9C, 0x00, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x00, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x00,
  0xCC, 0x09, 0x77, 0x20, 0x9C, 0x00, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x00, 0xCC, 0x09, 0x77, 0x20,
  0x9C, 0x00, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x00, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x00, 0xCC, 0x09,
  0x77, 0x20, 0x9C, 0x00, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x00, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x00,
  0xCC, 0x09, 0x77, 0x20, 0x9C, 0x00, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x0C, 0x0B, 0xC0, 0x97, 0x72,
  0x0A, 0xC0, 0x0B, 0xC0, 0xA7, 0x72, 0x0A, 0xC0, 0xB0, 0xAC, 0x0B, 0x77, 0x20, 0xBC, 0x09, 0x08,
  0xC0, 0xE7, 0x72, 0x0E, 0xC0, 0x80, 0x5D, 0x01, 0x77, 0x01, 0xD0, 0x50, 0x2D, 0x05, 0x77, 0x04,
  0xD8, 0x12, 0x0E, 0xC0, 0xA7, 0x70, 0x9C, 0x0D, 0x20, 0x9D, 0x02, 0x75, 0x01, 0xD0, 0x82, 0x03,
  0xD0, 0xB7, 0x50, 0xBD, 0x02, 0x30, 0xBD, 0x0A, 0x73, 0x0A, 0xD0, 0xA4, 0x02, 0xE8, 0x1E, 0x72,
  0x48, 0x12, 0x7D, 0xD0, 0xE0, 0x15, 0x06, 0xFA, 0x00, 0xEF, 0xA0, 0x47, 0x06, 0xFF, 0xB0, 0xE0,
  0x47, 0x20, 0x30, 0xDF, 0xF0, 0xB0, 0x27, 0x50, 0x50, 0xBF, 0xA8, 0x1E, 0xA4, 0x77, 0x38, 0x63,
  0x56, 0x77, 0x65, 0x27, 0x30,
  // "Û" (U+00DB)
  0x74, 0x80, 0x17, 0x06, 0x77, 0x70, 0x6E, 0x04, 0x77, 0x50, 0x20, 0xEE, 0x0D, 0x01, 0x77, 0x30,
  0x10, 0xDF, 0x90, 0xB7, 0x73, 0x0B, 0xC0, 0xA0, 0xCC, 0x09, 0x77, 0x10, 0x9C, 0x82, 0x90, 0x1C,
  0xC0, 0x77, 0x60, 0x7C, 0x09, 0x30, 0x10, 0xCC, 0x06, 0x74, 0x06, 0xC0, 0x86, 0x0B, 0xC0, 0x57,
  0x20, 0x5C, 0x07, 0x71, 0x09, 0xC0, 0x47, 0x01, 0xB0, 0xD0, 0x37, 0x30, 0x50, 0xEB, 0x01, 0x80,
  0xA9, 0x30, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0,
  0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0,
  0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72,
  0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0,
  0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0,
  0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72,
  0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0,
  0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0,
  0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72,
  0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0,
  0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0xC0, 0xBC, 0x09, 0x77, 0x20, 0xAC,
  0x00, 0xBC, 0x0A, 0x77, 0x20, 0xAC, 0x0B, 0x0A, 0xC0, 0xB7, 0x72, 0x0B, 0xC0, 0x90, 0x8C, 0x0E,
  0x77, 0x20, 0xEC, 0x08, 0x05, 0xD0, 0x17, 0x70, 0x1D, 0x05, 0x02, 0xD0, 0x57, 0x70, 0x4D, 0x81,
  0x20, 0xEC, 0x0A, 0x77, 0x09, 0xC0, 0xD2, 0x09, 0xD0, 0x27, 0x50, 0x1D, 0x08, 0x20, 0x3D, 0x0B,
  0x75, 0x0B, 0xD0, 0x23, 0x0B, 0xD0, 0xA7, 0x30, 0xAD, 0x0A, 0x40, 0x2E, 0x81, 0xE7, 0x24, 0x81,
  0x27, 0xDD, 0x0E, 0x01, 0x50, 0x6F, 0xA0, 0x0E, 0xFA, 0x04, 0x70, 0x6F, 0xFB, 0x0E, 0x04, 0x72,
  0x03, 0x0D, 0xFF, 0x0B, 0x02, 0x75, 0x05, 0x0B, 0xFA, 0x81, 0xEA, 0x47, 0x73, 0x86, 0x35, 0x67,
  0x76, 0x52, 0x73,
  // "Ü" (U+00DC)
  0x58, 0x38, 0xDE, 0xB2, 0x71, 0x84, 0x2A, 0xEE, 0x91, 0x71, 0x0A, 0xC0, 0xE0, 0x17, 0x0D, 0xC0,
  0xB7, 0x1E, 0x05, 0x60, 0x3E, 0x01, 0x7E, 0x06, 0x60, 0x4E, 0x02, 0x70, 0xED, 0x04, 0x60, 0x2E,
  0x71, 0x08, 0xC0, 0xD7, 0x10, 0xCC, 0x09, 0x72, 0x83, 0x7D, 0xEA, 0x27, 0x18, 0x31, 0xAE, 0xD8,
  0x80, 0xAD, 0x10, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C,
  0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09,
  0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97,
  0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C,
  0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09,
  0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97,
  0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C,
  0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09,
  0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97,
  0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C,
  0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0xC0, 0xBC, 0x09, 0x77, 0x20,
  0xAC, 0x00, 0xBC, 0x0A, 0x77, 0x20, 0xAC, 0x0B, 0x0A, 0xC0, 0xB7, 0x72, 0x0B, 0xC0, 0x90, 0x8C,
  0x0E, 0x77, 0x20, 0xEC, 0x08, 0x05, 0xD0, 0x17, 0x70, 0x1D, 0x05, 0x02, 0xD0, 0x57, 0x70, 0x4D,
  0x81, 0x20, 0xEC, 0x0A, 0x77, 0x09, 0xC0, 0xD2, 0x09, 0xD0, 0x27, 0x50, 0x1D, 0x08, 0x20, 0x3D,
  0x0B, 0x75, 0x0B, 0xD0, 0x23, 0x0B, 0xD0, 0xA7, 0x30, 0xAD, 0x0A, 0x40, 0x2E, 0x81, 0xE7, 0x24,
  0x81, 0x27, 0xDD, 0x0E, 0x01, 0x50, 0x6F, 0xA0, 0x0E, 0xFA, 0x04, 0x70, 0x6F, 0xFB, 0x0E, 0x04,
  0x72, 0x03, 0x0D, 0xFF, 0x0B, 0x02, 0x75, 0x05, 0x0B, 0xFA, 0x81, 0xEA, 0x47, 0x73, 0x86, 0x35,
  0x67, 0x76, 0x52, 0x73,
  // "Ý" (U+00DD)
  0x77, 0x50, 0x58, 0x01, 0x70, 0x67, 0x77, 0x30, 0x1E, 0x09, 0x77, 0x73, 0x0A, 0xD0, 0xC7, 0x77,
  0x30, 0x4D, 0x0D, 0x01, 0x77, 0x73, 0x0D, 0xC0, 0xE0, 0x27, 0x77, 0x30, 0x8C, 0x0E, 0x02, 0x77,
  0x73, 0x03, 0xC0, 0xE0, 0x37, 0x77, 0x40, 0xDB, 0x0E, 0x03, 0x77, 0x74, 0x09, 0xB0, 0xD0, 0x27,
  0x77, 0x40, 0x3B, 0x0B, 0x01, 0x80, 0xAD, 0x10, 0x0A, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0xA0, 0x2D,
  0x0B, 0x77, 0x40, 0x8D, 0x81, 0x20, 0xAD, 0x02, 0x77, 0x30, 0xEC, 0x0A, 0x20, 0x2D, 0x09, 0x77,
  0x20, 0x7D, 0x02, 0x30, 0x9D, 0x01, 0x77, 0x10, 0xDC, 0x09, 0x40, 0x2D, 0x08, 0x77, 0x05, 0xD0,
  0x25, 0x09, 0xC0, 0xE7, 0x70, 0xCC, 0x09, 0x60, 0x2D, 0x07, 0x75, 0x04, 0xD0, 0x27, 0x09, 0xC0,
  0xD7, 0x50, 0xBC, 0x09, 0x71, 0x02, 0xD0, 0x57, 0x30, 0x3D, 0x02, 0x72, 0x09, 0xC0, 0xC7, 0x30,
  0xAC, 0x09, 0x73, 0x02, 0xD0, 0x47, 0x10, 0x2D, 0x02, 0x74, 0x09, 0xC0, 0xB7, 0x10, 0x9C, 0x09,
  0x75, 0x02, 0xD0, 0x36, 0x01, 0x0E, 0xC0, 0x27, 0x60, 0x9C, 0x0A, 0x60, 0x7C, 0x09, 0x77, 0x01,
  0xD0, 0x15, 0x0E, 0xC0, 0x17, 0x71, 0x09, 0xC0, 0x84, 0x06, 0xC0, 0x97, 0x72, 0x01, 0xC0, 0xE0,
  0x13, 0x0D, 0xC0, 0x17, 0x73, 0x09, 0xC0, 0x72, 0x05, 0xC0, 0x97, 0x74, 0x01, 0xC0, 0xD2, 0x0C,
  0xC0, 0x17, 0x75, 0x09, 0xC0, 0x50, 0x3C, 0x09, 0x77, 0x60, 0x1C, 0x0C, 0x0B, 0xC0, 0x17, 0x77,
  0x09, 0xF9, 0x08, 0x77, 0x71, 0x01, 0xF9, 0x01, 0x77, 0x72, 0x08, 0xE0, 0x87, 0x77, 0x30, 0x1E,
  0x01, 0x77, 0x74, 0x09, 0xC0, 0x97, 0x77, 0x50, 0x9C, 0x09, 0x77, 0x75, 0x09, 0xC0, 0x97, 0x77,
  0x50, 0x9C, 0x09, 0x77, 0x75, 0x09, 0xC0, 0x97, 0x77, 0x50, 0x9C, 0x09, 0x77, 0x75, 0x09, 0xC0,
  0x97, 0x77, 0x50, 0x9C, 0x09, 0x77, 0x75, 0x09, 0xC0, 0x97, 0x77, 0x50, 0x9C, 0x09, 0x77, 0x75,
  0x09, 0xC0, 0x97, 0x77, 0x50, 0x9C, 0x09, 0x77, 0x75, 0x09, 0xC0, 0x97, 0x77, 0x50, 0x9C, 0x09,
  0x77, 0x75, 0x09, 0xC0, 0x97, 0x77, 0x50, 0x9C, 0x09, 0x77, 0x75, 0x09, 0xC0, 0x97, 0x60,
  // "Þ" (U+00DE)
  0x04, 0xD0, 0x17, 0x77, 0x04, 0xD0, 0x17, 0x77, 0x04, 0xD0, 0x17, 0x77, 0x04, 0xD0, 0x17, 0x77,
  0x04, 0xD0, 0x17, 0x77, 0x04, 0xD0, 0x17, 0x77, 0x04, 0xD0, 0x17, 0x77, 0x04, 0xD0, 0x17, 0x77,
  0x04, 0xFE, 0x84, 0xED, 0xC9, 0x63, 0x71, 0x04, 0xFF, 0xD0, 0xD0, 0x76, 0x04, 0xFF, 0xF0, 0xD0,
  0x44, 0x04, 0xFF, 0xFA, 0x05, 0x30, 0x4D, 0x07, 0x80, 0x26, 0x82, 0x78, 0xAD, 0xF9, 0x04, 0x20,
  0x4D, 0x01, 0x73, 0x03, 0x0A, 0xE0, 0xE2, 0x04, 0xD0, 0x17, 0x50, 0x4E, 0x81, 0x70, 0x4D, 0x01,
  0x76, 0x05, 0xD8, 0x1E, 0x04, 0xD0, 0x17, 0x70, 0xBD, 0x02, 0x04, 0xD0, 0x17, 0x70, 0x4D, 0x06,
  0x04, 0xD0, 0x17, 0x71, 0xD0, 0x80, 0x4D, 0x01, 0x77, 0x10, 0xEC, 0x09, 0x04, 0xD0, 0x17, 0x71,
  0x0C, 0xC0, 0xA0, 0x4D, 0x01, 0x77, 0x10, 0xDC, 0x09, 0x04, 0xD0, 0x17, 0x71, 0x0E, 0xC0, 0x80,
  0x4D, 0x01, 0x77, 0x02, 0xD0, 0x50, 0x4D, 0x01, 0x77, 0x06, 0xD0, 0x20, 0x4D, 0x01, 0x77, 0x0D,
  0xC8, 0x1C, 0x04, 0xD0, 0x17, 0x60, 0x7D, 0x81, 0x60, 0x4D, 0x01, 0x75, 0x07, 0xD0, 0xE2, 0x04,
  0xD0, 0x17, 0x30, 0x50, 0xCE, 0x05, 0x20, 0x4D, 0x07, 0x80, 0x16, 0x82, 0x77, 0x9C, 0xF9, 0x08,
  0x30, 0x4F, 0xFF, 0x90, 0x84, 0x04, 0xFF, 0xE0, 0xE0, 0x55, 0x04, 0xFF, 0xC8, 0x1D, 0x71, 0x60,
  0x4F, 0xD8, 0x4E, 0xDC, 0xA7, 0x37, 0x20, 0x4D, 0x01, 0x77, 0x70, 0x4D, 0x01, 0x77, 0x70, 0x4D,
  0x01, 0x77, 0x70, 0x4D, 0x01, 0x77, 0x70, 0x4D, 0x01, 0x77, 0x70, 0x4D, 0x01, 0x77, 0x70, 0x4D,
  0x01, 0x77, 0x70, 0x4D, 0x01, 0x77, 0x70, 0x4D, 0x01, 0x77, 0x70,
  // "ß" (U+00DF)
  0x78, 0x93, 0x16, 0x9C, 0xDE, 0xFE, 0xED, 0xA8, 0x47, 0x72, 0x04, 0x0B, 0xFE, 0x81, 0xE8, 0x17,
  0x50, 0xAF, 0xFC, 0x06, 0x72, 0x01, 0x0C, 0xFF, 0xE0, 0x97, 0x10, 0xBF, 0x86, 0xC9, 0x76, 0x67,
  0xAE, 0xF0, 0x66, 0x05, 0xE0, 0x90, 0x27, 0x10, 0x40, 0xCD, 0x0E, 0x60, 0xCD, 0x05, 0x75, 0x0B,
  0xD0, 0x54, 0x01, 0xD0, 0x87, 0x60, 0x2D, 0x08, 0x40, 0x4D, 0x01, 0x77, 0x0D, 0xC0, 0x94, 0x06,
  0xC0, 0xD7, 0x71, 0x0D, 0xC0, 0x84, 0x07, 0xC0, 0xC7, 0x71, 0xD0, 0x74, 0x07, 0xC0, 0xC7, 0x70,
  0x6D, 0x02, 0x40, 0x7C, 0x0C, 0x76, 0x03, 0x0E, 0xC0, 0xB5, 0x07, 0xC0, 0xC7, 0x50, 0x30, 0xED,
  0x02, 0x50, 0x7C, 0x0C, 0x74, 0x06, 0xE0, 0x56, 0x07, 0xC0, 0xC7, 0x30, 0x9E, 0x05, 0x70, 0x7C,
  0x0C, 0x72, 0x0B, 0xD0, 0xE0, 0x37, 0x10, 0x7C, 0x0C, 0x71, 0x09, 0xD0, 0xC0, 0x17, 0x20, 0x7C,
  0x0C, 0x70, 0x3D, 0x0B, 0x74, 0x07, 0xC0, 0xC7, 0x09, 0xC0, 0xD7, 0x50, 0x7C, 0x0C, 0x70, 0xCC,
  0x07, 0x75, 0x07, 0xC0, 0xC7, 0x0D, 0xC0, 0x47, 0x50, 0x7C, 0x0C, 0x70, 0xCC, 0x08, 0x75, 0x07,
  0xC0, 0xC7, 0x09, 0xD0, 0x57, 0x40, 0x7C, 0x0C, 0x70, 0x3E, 0x09, 0x73, 0x07, 0xC0, 0xC7, 0x10,
  0x9E, 0x0D, 0x03, 0x71, 0x07, 0xC0, 0xC7, 0x20, 0x9F, 0x08, 0x70, 0x7C, 0x0C, 0x73, 0x07, 0xF0,
  0xC0, 0x15, 0x07, 0xC0, 0xC7, 0x40, 0x40, 0xEE, 0x0E, 0x03, 0x40, 0x7C, 0x0C, 0x75, 0x01, 0x0B,
  0xF0, 0x53, 0x07, 0xC0, 0xC7, 0x70, 0x7F, 0x04, 0x20, 0x7C, 0x0C, 0x77, 0x10, 0x20, 0xDD, 0x82,
  0xE1, 0x07, 0xC0, 0xC7, 0x73, 0x0B, 0xD8, 0x19, 0x07, 0xC0, 0xC7, 0x74, 0x0C, 0xC8, 0x1E, 0x07,
  0xC0, 0xC7, 0x74, 0x03, 0xD0, 0x30, 0x7C, 0x0C, 0x77, 0x50, 0xEC, 0x05, 0x07, 0xC0, 0xC7, 0x75,
  0x0C, 0xC0, 0x07, 0xC0, 0xC7, 0x75, 0x0D, 0xC0, 0x60, 0x7C, 0x0C, 0x77, 0x5D, 0x05, 0x07, 0xC0,
  0xC4, 0x01, 0x76, 0x05, 0xD0, 0x30, 0x7C, 0x0C, 0x48, 0x25, 0xE6, 0x17, 0x20, 0x20, 0xEC, 0x81,
  0xE0, 0x7C, 0x0C, 0x40, 0x5B, 0x81, 0xA6, 0x24, 0x81, 0x27, 0xED, 0x81, 0x80, 0x7C, 0x0C, 0x40,
  0x5F, 0x90, 0xEF, 0x90, 0xD2, 0x07, 0xC0, 0xC4, 0x05, 0xFF, 0xA0, 0xE0, 0x22, 0x07, 0xC0, 0xC4,
  0x03, 0x0E, 0xFF, 0x0B, 0x02, 0x30, 0x7C, 0x0C, 0x60, 0x60, 0xBF, 0xA8, 0x1E, 0xA4, 0x77, 0x68,
  0x63, 0x56, 0x77, 0x65, 0x27, 0x10,
  // "à" (U+00E0)
  0x60, 0x58, 0x01, 0x70, 0x57, 0x76, 0x06, 0xE0, 0x27, 0x76, 0x0A, 0xD0, 0xB7, 0x77, 0x0C, 0xD0,
  0x57, 0x76, 0x01, 0x0D, 0xC0, 0xE0, 0x17, 0x76, 0x02, 0x0D, 0xC0, 0x97, 0x77, 0x02, 0x0D, 0xC0,
  0x47, 0x77, 0x02, 0x0D, 0xB0, 0xE0, 0x17, 0x77, 0x01, 0x0C, 0xB0, 0xB7, 0x77, 0x20, 0xAB, 0x05,
  0x80, 0x9F, 0x10, 0x87, 0x13, 0x56, 0x77, 0x65, 0x37, 0x71, 0x81, 0x49, 0xDF, 0xB0, 0xB0, 0x57,
  0x28, 0x11, 0x8E, 0xFF, 0x90, 0xE0, 0x56, 0x04, 0xFF, 0xE0, 0x86, 0x0E, 0xFA, 0x00, 0xEF, 0xA0,
  0x75, 0x07, 0xB8, 0x2D, 0x95, 0x25, 0x81, 0x27, 0xCE, 0x02, 0x58, 0x1E, 0xA3, 0x75, 0x06, 0xD0,
  0xA7, 0x77, 0x06, 0xD7, 0x77, 0x10, 0xDC, 0x04, 0x77, 0x70, 0x8C, 0x06, 0x77, 0x70, 0x6C, 0x07,
  0x77, 0x70, 0x5C, 0x08, 0x77, 0x70, 0x4C, 0x09, 0x71, 0x84, 0x47, 0xAC, 0xDE, 0xFD, 0x09, 0x58,
  0x13, 0xAE, 0xFF, 0xC0, 0x93, 0x01, 0x09, 0xFF, 0xF0, 0x92, 0x01, 0x0D, 0xFF, 0xF9, 0x09, 0x20,
  0xDF, 0x83, 0xEB, 0x97, 0x78, 0x02, 0x60, 0x9C, 0x81, 0x90, 0x8E, 0x0A, 0x04, 0x74, 0x04, 0xC0,
  0x91, 0xD0, 0xE0, 0x47, 0x60, 0x4C, 0x09, 0x05, 0xD0, 0x57, 0x70, 0x5C, 0x00, 0x9C, 0x0B, 0x77,
  0x10, 0x6C, 0x09, 0x0A, 0xC0, 0x77, 0x71, 0x08, 0xC0, 0x90, 0xBC, 0x05, 0x77, 0x10, 0xDC, 0x09,
  0x0B, 0xC0, 0x57, 0x70, 0x4D, 0x09, 0x0A, 0xC0, 0x77, 0x60, 0x10, 0xDD, 0x09, 0x07, 0xC0, 0xD7,
  0x50, 0x10, 0xDE, 0x09, 0x03, 0xD0, 0x97, 0x30, 0x50, 0xEF, 0x81, 0x90, 0xCD, 0x81, 0xD6, 0x23,
  0x82, 0x13, 0x8D, 0xC0, 0xAC, 0x81, 0x90, 0x4F, 0xA0, 0xEF, 0x90, 0x70, 0x2C, 0x09, 0x20, 0x6F,
  0xFA, 0x07, 0x2C, 0x09, 0x30, 0x50, 0xEF, 0xD0, 0xD0, 0x33, 0x0E, 0xB0, 0x94, 0x81, 0x17, 0xDF,
  0x90, 0xC0, 0x65, 0x0C, 0xB0, 0x97, 0x86, 0x15, 0x67, 0x76, 0x41, 0x75,
  // "á" (U+00E1)
  0x77, 0x30, 0x58, 0x01, 0x70, 0x67, 0x75, 0x01, 0xE0, 0x97, 0x75, 0x0A, 0xD0, 0xC7, 0x75, 0x04,
  0xD0, 0xD0, 0x17, 0x75, 0x0D, 0xC0, 0xE0, 0x27, 0x75, 0x08, 0xC0, 0xE0, 0x27, 0x75, 0x03, 0xC0,
  0xE0, 0x37, 0x76, 0x0D, 0xB0, 0xE0, 0x37, 0x76, 0x09, 0xB0, 0xD0, 0x27, 0x76, 0x03, 0xB0, 0xB0,
  0x18, 0x09, 0xF3, 0x08, 0x71, 0x35, 0x67, 0x76, 0x53, 0x77, 0x18, 0x14, 0x9D, 0xFB, 0x0B, 0x05,
  0x72, 0x81, 0x18, 0xEF, 0xF9, 0x0E, 0x05, 0x60, 0x4F, 0xFE, 0x08, 0x60, 0xEF, 0xA0, 0x0E, 0xFA,
  0x07, 0x50, 0x7B, 0x82, 0xD9, 0x52, 0x58, 0x12, 0x7C, 0xE0, 0x25, 0x81, 0xEA, 0x37, 0x50, 0x6D,
  0x0A, 0x77, 0x70, 0x6D, 0x77, 0x71, 0x0D, 0xC0, 0x47, 0x77, 0x08, 0xC0, 0x67, 0x77, 0x06, 0xC0,
  0x77, 0x77, 0x05, 0xC0, 0x87, 0x77, 0x04, 0xC0, 0x97, 0x18, 0x44, 0x7A, 0xCD, 0xEF, 0xD0, 0x95,
  0x81, 0x3A, 0xEF, 0xFC, 0x09, 0x30, 0x10, 0x9F, 0xFF, 0x09, 0x20, 0x10, 0xDF, 0xFF, 0x90, 0x92,
  0x0D, 0xF8, 0x3E, 0xB9, 0x77, 0x80, 0x26, 0x09, 0xC8, 0x19, 0x08, 0xE0, 0xA0, 0x47, 0x40, 0x4C,
  0x09, 0x1D, 0x0E, 0x04, 0x76, 0x04, 0xC0, 0x90, 0x5D, 0x05, 0x77, 0x05, 0xC0, 0x09, 0xC0, 0xB7,
  0x71, 0x06, 0xC0, 0x90, 0xAC, 0x07, 0x77, 0x10, 0x8C, 0x09, 0x0B, 0xC0, 0x57, 0x71, 0x0D, 0xC0,
  0x90, 0xBC, 0x05, 0x77, 0x04, 0xD0, 0x90, 0xAC, 0x07, 0x76, 0x01, 0x0D, 0xD0, 0x90, 0x7C, 0x0D,
  0x75, 0x01, 0x0D, 0xE0, 0x90, 0x3D, 0x09, 0x73, 0x05, 0x0E, 0xF8, 0x19, 0x0C, 0xD8, 0x1D, 0x62,
  0x38, 0x21, 0x38, 0xDC, 0x0A, 0xC8, 0x19, 0x04, 0xFA, 0x0E, 0xF9, 0x07, 0x02, 0xC0, 0x92, 0x06,
  0xFF, 0xA0, 0x72, 0xC0, 0x93, 0x05, 0x0E, 0xFD, 0x0D, 0x03, 0x30, 0xEB, 0x09, 0x48, 0x11, 0x7D,
  0xF9, 0x0C, 0x06, 0x50, 0xCB, 0x09, 0x78, 0x61, 0x56, 0x77, 0x64, 0x17, 0x50,
  // "â" (U+00E2)
  0x74, 0x80, 0x17, 0x06, 0x77, 0x60, 0x6E, 0x04, 0x77, 0x40, 0x20, 0xEE, 0x0D, 0x01, 0x77, 0x20,
  0x10, 0xDF, 0x90, 0xB7, 0x72, 0x0B, 0xC0, 0xA0, 0xCC, 0x09, 0x77, 0x09, 0xC8, 0x29, 0x01, 0xCC,
  0x07, 0x75, 0x07, 0xC0, 0x93, 0x01, 0x0C, 0xC0, 0x67, 0x30, 0x6C, 0x08, 0x60, 0xBC, 0x05, 0x71,
  0x05, 0xC0, 0x77, 0x10, 0x9C, 0x04, 0x60, 0x1B, 0x0D, 0x03, 0x73, 0x05, 0x0E, 0xB0, 0x18, 0x09,
  0xE3, 0x08, 0x71, 0x35, 0x67, 0x76, 0x53, 0x77, 0x18, 0x14, 0x9D, 0xFB, 0x0B, 0x05, 0x72, 0x81,
  0x18, 0xEF, 0xF9, 0x0E, 0x05, 0x60, 0x4F, 0xFE, 0x08, 0x60, 0xEF, 0xA0, 0x0E, 0xFA, 0x07, 0x50,
  0x7B, 0x82, 0xD9, 0x52, 0x58, 0x12, 0x7C, 0xE0, 0x25, 0x81, 0xEA, 0x37, 0x50, 0x6D, 0x0A, 0x77,
  0x70, 0x6D, 0x77, 0x71, 0x0D, 0xC0, 0x47, 0x77, 0x08, 0xC0, 0x67, 0x77, 0x06, 0xC0, 0x77, 0x77,
  0x05, 0xC0, 0x87, 0x77, 0x04, 0xC0, 0x97, 0x18, 0x44, 0x7A, 0xCD, 0xEF, 0xD0, 0x95, 0x81, 0x3A,
  0xEF, 0xFC, 0x09, 0x30, 0x10, 0x9F, 0xFF, 0x09, 0x20, 0x10, 0xDF, 0xFF, 0x90, 0x92, 0x0D, 0xF8,
  0x3E, 0xB9, 0x77, 0x80, 0x26, 0x09, 0xC8, 0x19, 0x08, 0xE0, 0xA0, 0x47, 0x40, 0x4C, 0x09, 0x1D,
  0x0E, 0x04, 0x76, 0x04, 0xC0, 0x90, 0x5D, 0x05, 0x77, 0x05, 0xC0, 0x09, 0xC0, 0xB7, 0x71, 0x06,
  0xC0, 0x90, 0xAC, 0x07, 0x77, 0x10, 0x8C, 0x09, 0x0B, 0xC0, 0x57, 0x71, 0x0D, 0xC0, 0x90, 0xBC,
  0x05, 0x77, 0x04, 0xD0, 0x90, 0xAC, 0x07, 0x76, 0x01, 0x0D, 0xD0, 0x90, 0x7C, 0x0D, 0x75, 0x01,
  0x0D, 0xE0, 0x90, 0x3D, 0x09, 0x73, 0x05, 0x0E, 0xF8, 0x19, 0x0C, 0xD8, 0x1D, 0x62, 0x38, 0x21,
  0x38, 0xDC, 0x0A, 0xC8, 0x19, 0x04, 0xFA, 0x0E, 0xF9, 0x07, 0x02, 0xC0, 0x92, 0x06, 0xFF, 0xA0,
  0x72, 0xC0, 0x93, 0x05, 0x0E, 0xFD, 0x0D, 0x03, 0x30, 0xEB, 0x09, 0x48, 0x11, 0x7D, 0xF9, 0x0C,
  0x06, 0x50, 0xCB, 0x09, 0x78, 0x61, 0x56, 0x77, 0x64, 0x17, 0x50,
  // "ã" (U+00E3)
  0x68, 0x51, 0x8D, 0xED, 0xB4, 0x71, 0x05, 0xA0, 0xB7, 0x02, 0x0E, 0xE0, 0xB0, 0x26, 0x0B, 0xA0,
  0x86, 0x01, 0x0D, 0xFA, 0x07, 0x40, 0x4B, 0x04, 0x60, 0x8F, 0xC8, 0x2E, 0x97, 0x9B, 0x0E, 0x70,
  0xEB, 0x82, 0x97, 0x8D, 0xFC, 0x08, 0x60, 0x5B, 0x05, 0x40, 0x70, 0xEF, 0x90, 0xD7, 0x08, 0xA0,
  0xB6, 0x02, 0x0B, 0xE0, 0xE0, 0x27, 0x0B, 0xA0, 0x67, 0x18, 0x54, 0xAD, 0xFD, 0x81, 0x80, 0x9E,
  0x60, 0x87, 0x13, 0x56, 0x77, 0x65, 0x37, 0x71, 0x81, 0x49, 0xDF, 0xB0, 0xB0, 0x57, 0x28, 0x11,
  0x8E, 0xFF, 0x90, 0xE0, 0x56, 0x04, 0xFF, 0xE0, 0x86, 0x0E, 0xFA, 0x00, 0xEF, 0xA0, 0x75, 0x07,
  0xB8, 0x2D, 0x95, 0x25, 0x81, 0x27, 0xCE, 0x02, 0x58, 0x1E, 0xA3, 0x75, 0x06, 0xD0, 0xA7, 0x77,
  0x06, 0xD7, 0x77, 0x10, 0xDC, 0x04, 0x77, 0x70, 0x8C, 0x06, 0x77, 0x70, 0x6C, 0x07, 0x77, 0x70,
  0x5C, 0x08, 0x77, 0x70, 0x4C, 0x09, 0x71, 0x84, 0x47, 0xAC, 0xDE, 0xFD, 0x09, 0x58, 0x13, 0xAE,
  0xFF, 0xC0, 0x93, 0x01, 0x09, 0xFF, 0xF0, 0x92, 0x01, 0x0D, 0xFF, 0xF9, 0x09, 0x20, 0xDF, 0x83,
  0xEB, 0x97, 0x78, 0x02, 0x60, 0x9C, 0x81, 0x90, 0x8E, 0x0A, 0x04, 0x74, 0x04, 0xC0, 0x91, 0xD0,
  0xE0, 0x47, 0x60, 0x4C, 0x09, 0x05, 0xD0, 0x57, 0x70, 0x5C, 0x00, 0x9C, 0x0B, 0x77, 0x10, 0x6C,
  0x09, 0x0A, 0xC0, 0x77, 0x71, 0x08, 0xC0, 0x90, 0xBC, 0x05, 0x77, 0x10, 0xDC, 0x09, 0x0B, 0xC0,
  0x57, 0x70, 0x4D, 0x09, 0x0A, 0xC0, 0x77, 0x60, 0x10, 0xDD, 0x09, 0x07, 0xC0, 0xD7, 0x50, 0x10,
  0xDE, 0x09, 0x03, 0xD0, 0x97, 0x30, 0x50, 0xEF, 0x81, 0x90, 0xCD, 0x81, 0xD6, 0x23, 0x82, 0x13,
  0x8D, 0xC0, 0xAC, 0x81, 0x90, 0x4F, 0xA0, 0xEF, 0x90, 0x70, 0x2C, 0x09, 0x20, 0x6F, 0xFA, 0x07,
  0x2C, 0x09, 0x30, 0x50, 0xEF, 0xD0, 0xD0, 0x33, 0x0E, 0xB0, 0x94, 0x81, 0x17, 0xDF, 0x90, 0xC0,
  0x65, 0x0C, 0xB0, 0x97, 0x86, 0x15, 0x67, 0x76, 0x41, 0x75,
  // "ä" (U+00E4)
  0x58, 0x38, 0xDE, 0xB2, 0x71, 0x84, 0x2A, 0xEE, 0x91, 0x70, 0xAC, 0x0E, 0x01, 0x70, 0xDC, 0x0B,
  0x7E, 0x05, 0x60, 0x3E, 0x01, 0x6E, 0x06, 0x60, 0x4E, 0x02, 0x60, 0xED, 0x04, 0x60, 0x2E, 0x70,
  0x8C, 0x0D, 0x71, 0x0C, 0xC0, 0x97, 0x18, 0x37, 0xDE, 0xA2, 0x71, 0x83, 0x1A, 0xED, 0x88, 0x0A,
  0xA0, 0x08, 0x71, 0x35, 0x67, 0x76, 0x53, 0x77, 0x18, 0x14, 0x9D, 0xFB, 0x0B, 0x05, 0x72, 0x81,
  0x18, 0xEF, 0xF9, 0x0E, 0x05, 0x60, 0x4F, 0xFE, 0x08, 0x60, 0xEF, 0xA0, 0x0E, 0xFA, 0x07, 0x50,
  0x7B, 0x82, 0xD9, 0x52, 0x58, 0x12, 0x7C, 0xE0, 0x25, 0x81, 0xEA, 0x37, 0x50, 0x6D, 0x0A, 0x77,
  0x70, 0x6D, 0x77, 0x71, 0x0D, 0xC0, 0x47, 0x77, 0x08, 0xC0, 0x67, 0x77, 0x06, 0xC0, 0x77, 0x77,
  0x05, 0xC0, 0x87, 0x77, 0x04, 0xC0, 0x97, 0x18, 0x44, 0x7A, 0xCD, 0xEF, 0xD0, 0x95, 0x81, 0x3A,
  0xEF, 0xFC, 0x09, 0x30, 0x10, 0x9F, 0xFF, 0x09, 0x20, 0x10, 0xDF, 0xFF, 0x90, 0x92, 0x0D, 0xF8,
  0x3E, 0xB9, 0x77, 0x80, 0x26, 0x09, 0xC8, 0x19, 0x08, 0xE0, 0xA0, 0x47, 0x40, 0x4C, 0x09, 0x1D,
  0x0E, 0x04, 0x76, 0x04, 0xC0, 0x90, 0x5D, 0x05, 0x77, 0x05, 0xC0, 0x09, 0xC0, 0xB7, 0x71, 0x06,
  0xC0, 0x90, 0xAC, 0x07, 0x77, 0x10, 0x8C, 0x09, 0x0B, 0xC0, 0x57, 0x71, 0x0D, 0xC0, 0x90, 0xBC,
  0x05, 0x77, 0x04, 0xD0, 0x90, 0xAC, 0x07, 0x76, 0x01, 0x0D, 0xD0, 0x90, 0x7C, 0x0D, 0x75, 0x01,
  0x0D, 0xE0, 0x90, 0x3D, 0x09, 0x73, 0x05, 0x0E, 0xF8, 0x19, 0x0C, 0xD8, 0x1D, 0x62, 0x38, 0x21,
  0x38, 0xDC, 0x0A, 0xC8, 0x19, 0x04, 0xFA, 0x0E, 0xF9, 0x07, 0x02, 0xC0, 0x92, 0x06, 0xFF, 0xA0,
  0x72, 0xC0, 0x93, 0x05, 0x0E, 0xFD, 0x0D, 0x03, 0x30, 0xEB, 0x09, 0x48, 0x11, 0x7D, 0xF9, 0x0C,
  0x06, 0x50, 0xCB, 0x09, 0x78, 0x61, 0x56, 0x77, 0x64, 0x17, 0x50,
  // "å" (U+00E5)
  0x73, 0x86, 0x39, 0xDF, 0xEC, 0x82, 0x77, 0x40, 0x7F, 0x90, 0x67, 0x72, 0x07, 0xFB, 0x05, 0x77,
  0x01, 0x0E, 0xA8, 0x4E, 0x61, 0x16, 0xEA, 0x0E, 0x77, 0x05, 0xB0, 0x44, 0x05, 0xB0, 0x57, 0x60,
  0x8A, 0x0E, 0x60, 0xEA, 0x08, 0x76, 0x08, 0xA0, 0xC6, 0x0D, 0xA0, 0x87, 0x60, 0x8A, 0x0E, 0x60,
  0xEA, 0x07, 0x76, 0x05, 0xB0, 0x44, 0x05, 0xB0, 0x47, 0x70, 0xEA, 0x84, 0xE5, 0x11, 0x6E, 0xA0,
  0xE7, 0x71, 0x06, 0xFB, 0x05, 0x77, 0x20, 0x7F, 0x90, 0x67, 0x74, 0x86, 0x39, 0xDF, 0xED, 0x82,
  0x80, 0x9F, 0x20, 0x87, 0x13, 0x56, 0x77, 0x65, 0x37, 0x71, 0x81, 0x49, 0xDF, 0xB0, 0xB0, 0x57,
  0x28, 0x11, 0x8E, 0xFF, 0x90, 0xE0, 0x56, 0x04, 0xFF, 0xE0, 0x86, 0x0E, 0xFA, 0x00, 0xEF, 0xA0,
  0x75, 0x07, 0xB8, 0x2D, 0x95, 0x25, 0x81, 0x27, 0xCE, 0x02, 0x58, 0x1E, 0xA3, 0x75, 0x06, 0xD0,
  0xA7, 0x77, 0x06, 0xD7, 0x77, 0x10, 0xDC, 0x04, 0x77, 0x70, 0x8C, 0x06, 0x77, 0x70, 0x6C, 0x07,
  0x77, 0x70, 0x5C, 0x08, 0x77, 0x70, 0x4C, 0x09, 0x71, 0x84, 0x47, 0xAC, 0xDE, 0xFD, 0x09, 0x58,
  0x13, 0xAE, 0xFF, 0xC0, 0x93, 0x01, 0x09, 0xFF, 0xF0, 0x92, 0x01, 0x0D, 0xFF, 0xF9, 0x09, 0x20,
  0xDF, 0x83, 0xEB, 0x97, 0x78, 0x02, 0x60, 0x9C, 0x81, 0x90, 0x8E, 0x0A, 0x04, 0x74, 0x04, 0xC0,
  0x91, 0xD0, 0xE0, 0x47, 0x60, 0x4C, 0x09, 0x05, 0xD0, 0x57, 0x70, 0x5C, 0x00, 0x9C, 0x0B, 0x77,
  0x10, 0x6C, 0x09, 0x0A, 0xC0, 0x77, 0x71, 0x08, 0xC0, 0x90, 0xBC, 0x05, 0x77, 0x10, 0xDC, 0x09,
  0x0B, 0xC0, 0x57, 0x70, 0x4D, 0x09, 0x0A, 0xC0, 0x77, 0x60, 0x10, 0xDD, 0x09, 0x07, 0xC0, 0xD7,
  0x50, 0x10, 0xDE, 0x09, 0x03, 0xD0, 0x97, 0x30, 0x50, 0xEF, 0x81, 0x90, 0xCD, 0x81, 0xD6, 0x23,
  0x82, 0x13, 0x8D, 0xC0, 0xAC, 0x81, 0x90, 0x4F, 0xA0, 0xEF, 0x90, 0x70, 0x2C, 0x09, 0x20, 0x6F,
  0xFA, 0x07, 0x2C, 0x09, 0x30, 0x50, 0xEF, 0xD0, 0xD0, 0x33, 0x0E, 0xB0, 0x94, 0x81, 0x17, 0xDF,
  0x90, 0xC0, 0x65, 0x0C, 0xB0, 0x97, 0x86, 0x15, 0x67, 0x76, 0x41, 0x75,
  // "æ" (U+00E6)
  0x78, 0x41, 0x56, 0x76, 0x37, 0x28, 0x42, 0x57, 0x64, 0x17, 0x40, 0x70, 0xCE, 0x0E, 0x07, 0x50,
  0x30, 0xBE, 0x09, 0x01, 0x70, 0x60, 0xEF, 0xB0, 0xC0, 0x12, 0x06, 0xFA, 0x0D, 0x02, 0x50, 0x7F,
  0xE8, 0x1B, 0x04, 0xFC, 0x0D, 0x50, 0x2E, 0x0E, 0xF0, 0x50, 0xDD, 0x0E, 0xE0, 0x95, 0x09, 0xA0,
  0xA0, 0x53, 0x03, 0x0B, 0xFA, 0x83, 0x71, 0x01, 0x8D, 0x01, 0x48, 0x12, 0xC3, 0x70, 0xAF, 0x06,
  0x50, 0x8C, 0x08, 0x77, 0x02, 0xE0, 0xA7, 0x0E, 0xB0, 0xD7, 0x71, 0x0C, 0xD0, 0x37, 0x0A, 0xC0,
  0x27, 0x70, 0xAC, 0x0D, 0x71, 0x07, 0xC0, 0x57, 0x70, 0x8C, 0x09, 0x71, 0x04, 0xC0, 0x77, 0x70,
  0x8C, 0x06, 0x71, 0x03, 0xC0, 0x97, 0x70, 0x8C, 0x04, 0x71, 0x02, 0xC0, 0xA7, 0x86, 0x24, 0x56,
  0x66, 0x6B, 0xC0, 0x88, 0x04, 0x60, 0x7C, 0x0B, 0x48, 0x11, 0x9E, 0xFF, 0xFD, 0x0C, 0x30, 0x5F,
  0xFF, 0xF9, 0x0C, 0x20, 0x6F, 0xFF, 0xFA, 0x81, 0xC0, 0x3F, 0xFF, 0xFB, 0x81, 0xC0, 0xBD, 0x82,
  0xD7, 0x31, 0x30, 0x9C, 0x01, 0x77, 0x02, 0xD0, 0xA7, 0x09, 0xC0, 0x27, 0x70, 0x6C, 0x0D, 0x71,
  0x09, 0xC0, 0x37, 0x70, 0x9C, 0x06, 0x71, 0x0A, 0xC0, 0x57, 0x70, 0xBC, 0x02, 0x71, 0x0B, 0xC0,
  0x87, 0x70, 0xCC, 0x72, 0x0D, 0xC0, 0xB7, 0x70, 0xBC, 0x71, 0x01, 0xE0, 0x17, 0x60, 0xAC, 0x01,
  0x70, 0x6E, 0x07, 0x76, 0x09, 0xC0, 0x57, 0x0D, 0xE0, 0xE0, 0x27, 0x38, 0x11, 0x05, 0xC0, 0xC6,
  0x09, 0xB0, 0x90, 0xEB, 0x0D, 0x02, 0x71, 0x82, 0x5E, 0x01, 0xD0, 0xB0, 0x22, 0x04, 0x0B, 0xC0,
  0x10, 0x8C, 0x81, 0xE7, 0x23, 0x81, 0x26, 0xDA, 0x20, 0xAE, 0x0E, 0xE8, 0x27, 0x01, 0xEF, 0x0E,
  0xE2, 0x01, 0x0E, 0xFC, 0x0B, 0x30, 0x4F, 0xF3, 0x03, 0x0E, 0xFA, 0x0A, 0x50, 0x40, 0xEF, 0xC0,
  0xA4, 0x02, 0x0A, 0xE0, 0xC0, 0x57, 0x81, 0x18, 0xEF, 0x0A, 0x03, 0x78, 0x41, 0x57, 0x75, 0x27,
  0x58, 0x43, 0x67, 0x76, 0x45,
  // "ç" (U+00E7)
  0x74, 0x87, 0x13, 0x56, 0x77, 0x65, 0x37, 0x78, 0x12, 0x8C, 0xFB, 0x81, 0xC7, 0x27, 0x10, 0x30,
  0xBF, 0xFA, 0x0B, 0x01, 0x50, 0x7F, 0xFC, 0x0E, 0x50, 0xAF, 0xB0, 0x0E, 0xF0, 0x94, 0x08, 0xF8,
  0x19, 0x51, 0x48, 0x22, 0x59, 0xEA, 0x04, 0x30, 0x4E, 0x0A, 0x01, 0x74, 0x07, 0x0D, 0x40, 0xDD,
  0x08, 0x77, 0x40, 0x5D, 0x0B, 0x77, 0x50, 0xCD, 0x02, 0x77, 0x40, 0x1D, 0x0A, 0x77, 0x50, 0x5D,
  0x05, 0x77, 0x50, 0x8D, 0x01, 0x77, 0x50, 0xAC, 0x0E, 0x77, 0x60, 0xCC, 0x0B, 0x77, 0x60, 0xCC,
  0x0B, 0x77, 0x60, 0xDC, 0x0A, 0x77, 0x60, 0xDC, 0x0A, 0x77, 0x60, 0xDC, 0x0A, 0x77, 0x60, 0xCC,
  0x0B, 0x77, 0x60, 0xBC, 0x0D, 0x77, 0x60, 0x9D, 0x77, 0x60, 0x6D, 0x03, 0x77, 0x50, 0x3D, 0x09,
  0x77, 0x60, 0xEC, 0x0E, 0x77, 0x60, 0x8D, 0x09, 0x77, 0x50, 0x2E, 0x06, 0x77, 0x50, 0x9E, 0x09,
  0x01, 0x75, 0x04, 0x09, 0x40, 0xDE, 0x82, 0xE9, 0x51, 0x48, 0x51, 0x36, 0xAE, 0xFE, 0x40, 0x10,
  0xDF, 0xB0, 0x0E, 0xF0, 0xE5, 0x01, 0x0A, 0xFF, 0xC0, 0xE7, 0x06, 0x0D, 0xFF, 0xA0, 0xD7, 0x28,
  0x15, 0xAE, 0xFB, 0x81, 0xC9, 0x47, 0x60, 0x20, 0x5C, 0x81, 0x64, 0x27, 0x74, 0x06, 0xB0, 0x17,
  0x77, 0x0D, 0xA0, 0xC7, 0x77, 0x05, 0xD0, 0xA0, 0x27, 0x74, 0x09, 0xF0, 0x67, 0x75, 0x04, 0x09,
  0xD0, 0x37, 0x76, 0x02, 0x0E, 0xB0, 0x97, 0x77, 0x08, 0xB0, 0xB7, 0x77, 0x07, 0xB0, 0xB7, 0x77,
  0x0B, 0xB0, 0x97, 0x70, 0x30, 0x12, 0x81, 0x14, 0xAC, 0x03, 0x76, 0x01, 0xFB, 0x08, 0x77, 0x01,
  0xF9, 0x0E, 0x06, 0x77, 0x20, 0xC0, 0xEA, 0x83, 0xEC, 0xA6, 0x17, 0x10,
  // "è" (U+00E8)
  0x70, 0x58, 0x01, 0x70, 0x57, 0x77, 0x20, 0x6E, 0x02, 0x77, 0x72, 0x0A, 0xD0, 0xB7, 0x77, 0x30,
  0xCD, 0x05, 0x77, 0x72, 0x01, 0x0D, 0xC0, 0xE0, 0x17, 0x77, 0x20, 0x20, 0xDC, 0x09, 0x77, 0x73,
  0x02, 0x0D, 0xC0, 0x47, 0x77, 0x30, 0x20, 0xDB, 0x0E, 0x01, 0x77, 0x73, 0x01, 0x0C, 0xB0, 0xB7,
  0x77, 0x50, 0xAB, 0x05, 0x80, 0xA9, 0x20, 0x86, 0x25, 0x67, 0x65, 0x41, 0x77, 0x58, 0x14, 0xAE,
  0xF9, 0x0B, 0x06, 0x77, 0x10, 0x40, 0xCF, 0xE0, 0xD0, 0x57, 0x50, 0x9F, 0xFB, 0x09, 0x73, 0x0B,
  0xFA, 0x00, 0xEF, 0x90, 0xA7, 0x10, 0xAE, 0x81, 0xC6, 0x24, 0x04, 0x09, 0xE0, 0x76, 0x06, 0xD0,
  0xE0, 0x57, 0x20, 0x30, 0xDD, 0x03, 0x40, 0x10, 0xEC, 0x0E, 0x02, 0x74, 0x02, 0x0E, 0xC0, 0xA4,
  0x09, 0xD0, 0x47, 0x60, 0x5D, 0x02, 0x20, 0x1D, 0x09, 0x77, 0x10, 0xDC, 0x08, 0x20, 0x6D, 0x01,
  0x77, 0x10, 0x8C, 0x0B, 0x20, 0xBC, 0x0B, 0x77, 0x20, 0x4D, 0x20, 0xEC, 0x06, 0x77, 0x20, 0x1D,
  0x02, 0x01, 0xD0, 0x88, 0x09, 0x56, 0xD0, 0x04, 0xFF, 0xFF, 0x00, 0x5F, 0xFF, 0xF0, 0x60, 0x5F,
  0xFF, 0xF0, 0x06, 0xFF, 0xFF, 0x06, 0x05, 0xD0, 0x17, 0x77, 0x20, 0x4D, 0x02, 0x77, 0x72, 0x02,
  0xD0, 0x47, 0x77, 0x3D, 0x07, 0x77, 0x73, 0x0C, 0xC0, 0xB7, 0x77, 0x30, 0x7D, 0x02, 0x77, 0x72,
  0x02, 0xD0, 0x97, 0x77, 0x30, 0xAD, 0x04, 0x77, 0x72, 0x02, 0xD0, 0xE0, 0x47, 0x73, 0x04, 0x50,
  0x7E, 0x08, 0x01, 0x75, 0x82, 0x27, 0xDE, 0x60, 0xAE, 0x82, 0xEA, 0x52, 0x58, 0x22, 0x58, 0xCB,
  0x0E, 0x70, 0xAF, 0xB0, 0x0E, 0xFA, 0x0E, 0x71, 0x07, 0xFF, 0xE0, 0xE7, 0x20, 0x20, 0xAF, 0xFB,
  0x0C, 0x06, 0x74, 0x81, 0x17, 0xCF, 0xB8, 0x2E, 0xA7, 0x27, 0x73, 0x87, 0x35, 0x67, 0x76, 0x54,
  0x17, 0x10,
  // "é" (U+00E9)
  0x77, 0x40, 0x58, 0x01, 0x70, 0x67, 0x77, 0x10, 0x1E, 0x09, 0x77, 0x71, 0x0A, 0xD0, 0xC7, 0x77,
  0x10, 0x4D, 0x0D, 0x01, 0x77, 0x71, 0x0D, 0xC0, 0xE0, 0x27, 0x77, 0x10, 0x8C, 0x0E, 0x02, 0x77,
  0x71, 0x03, 0xC0, 0xE0, 0x37, 0x77, 0x20, 0xDB, 0x0E, 0x03, 0x77, 0x72, 0x09, 0xB0, 0xD0, 0x27,
  0x77, 0x20, 0x3B, 0x0B, 0x01, 0x80, 0xA9, 0x40, 0x86, 0x25, 0x67, 0x65, 0x41, 0x77, 0x58, 0x14,
  0xAE, 0xF9, 0x0B, 0x06, 0x77, 0x10, 0x40, 0xCF, 0xE0, 0xD0, 0x57, 0x50, 0x9F, 0xFB, 0x09, 0x73,
  0x0B, 0xFA, 0x00, 0xEF, 0x90, 0xA7, 0x10, 0xAE, 0x81, 0xC6, 0x24, 0x04, 0x09, 0xE0, 0x76, 0x06,
  0xD0, 0xE0, 0x57, 0x20, 0x30, 0xDD, 0x03, 0x40, 0x10, 0xEC, 0x0E, 0x02, 0x74, 0x02, 0x0E, 0xC0,
  0xA4, 0x09, 0xD0, 0x47, 0x60, 0x5D, 0x02, 0x20, 0x1D, 0x09, 0x77, 0x10, 0xDC, 0x08, 0x20, 0x6D,
  0x01, 0x77, 0x10, 0x8C, 0x0B, 0x20, 0xBC, 0x0B, 0x77, 0x20, 0x4D, 0x20, 0xEC, 0x06, 0x77, 0x20,
  0x1D, 0x02, 0x01, 0xD0, 0x88, 0x09, 0x56, 0xD0, 0x04, 0xFF, 0xFF, 0x00, 0x5F, 0xFF, 0xF0, 0x60,
  0x5F, 0xFF, 0xF0, 0x06, 0xFF, 0xFF, 0x06, 0x05, 0xD0, 0x17, 0x77, 0x20, 0x4D, 0x02, 0x77, 0x72,
  0x02, 0xD0, 0x47, 0x77, 0x3D, 0x07, 0x77, 0x73, 0x0C, 0xC0, 0xB7, 0x77, 0x30, 0x7D, 0x02, 0x77,
  0x72, 0x02, 0xD0, 0x97, 0x77, 0x30, 0xAD, 0x04, 0x77, 0x72, 0x02, 0xD0, 0xE0, 0x47, 0x73, 0x04,
  0x50, 0x7E, 0x08, 0x01, 0x75, 0x82, 0x27, 0xDE, 0x60, 0xAE, 0x82, 0xEA, 0x52, 0x58, 0x22, 0x58,
  0xCB, 0x0E, 0x70, 0xAF, 0xB0, 0x0E, 0xFA, 0x0E, 0x71, 0x07, 0xFF, 0xE0, 0xE7, 0x20, 0x20, 0xAF,
  0xFB, 0x0C, 0x06, 0x74, 0x81, 0x17, 0xCF, 0xB8, 0x2E, 0xA7, 0x27, 0x73, 0x87, 0x35, 0x67, 0x76,
  0x54, 0x17, 0x10,
  // "ê" (U+00EA)
  0x75, 0x80, 0x17, 0x06, 0x77, 0x72, 0x06, 0xE0, 0x47, 0x77, 0x02, 0x0E, 0xE0, 0xD0, 0x17, 0x75,
  0x01, 0x0D, 0xF9, 0x0B, 0x77, 0x50, 0xBC, 0x0A, 0x0C, 0xC0, 0x97, 0x73, 0x09, 0xC8, 0x29, 0x01,
  0xCC, 0x07, 0x77, 0x10, 0x7C, 0x09, 0x30, 0x10, 0xCC, 0x06, 0x76, 0x06, 0xC0, 0x86, 0x0B, 0xC0,
  0x57, 0x40, 0x5C, 0x07, 0x71, 0x09, 0xC0, 0x47, 0x20, 0x1B, 0x0D, 0x03, 0x73, 0x05, 0x0E, 0xB0,
  0x18, 0x0A, 0x84, 0x08, 0x62, 0x56, 0x76, 0x54, 0x17, 0x75, 0x81, 0x4A, 0xEF, 0x90, 0xB0, 0x67,
  0x71, 0x04, 0x0C, 0xFE, 0x0D, 0x05, 0x75, 0x09, 0xFF, 0xB0, 0x97, 0x30, 0xBF, 0xA0, 0x0E, 0xF9,
  0x0A, 0x71, 0x0A, 0xE8, 0x1C, 0x62, 0x40, 0x40, 0x9E, 0x07, 0x60, 0x6D, 0x0E, 0x05, 0x72, 0x03,
  0x0D, 0xD0, 0x34, 0x01, 0x0E, 0xC0, 0xE0, 0x27, 0x40, 0x20, 0xEC, 0x0A, 0x40, 0x9D, 0x04, 0x76,
  0x05, 0xD0, 0x22, 0x01, 0xD0, 0x97, 0x71, 0x0D, 0xC0, 0x82, 0x06, 0xD0, 0x17, 0x71, 0x08, 0xC0,
  0xB2, 0x0B, 0xC0, 0xB7, 0x72, 0x04, 0xD2, 0x0E, 0xC0, 0x67, 0x72, 0x01, 0xD0, 0x20, 0x1D, 0x08,
  0x80, 0x95, 0x6D, 0x00, 0x4F, 0xFF, 0xF0, 0x05, 0xFF, 0xFF, 0x06, 0x05, 0xFF, 0xFF, 0x00, 0x6F,
  0xFF, 0xF0, 0x60, 0x5D, 0x01, 0x77, 0x72, 0x04, 0xD0, 0x27, 0x77, 0x20, 0x2D, 0x04, 0x77, 0x73,
  0xD0, 0x77, 0x77, 0x30, 0xCC, 0x0B, 0x77, 0x73, 0x07, 0xD0, 0x27, 0x77, 0x20, 0x2D, 0x09, 0x77,
  0x73, 0x0A, 0xD0, 0x47, 0x77, 0x20, 0x2D, 0x0E, 0x04, 0x77, 0x30, 0x45, 0x07, 0xE0, 0x80, 0x17,
  0x58, 0x22, 0x7D, 0xE6, 0x0A, 0xE8, 0x2E, 0xA5, 0x25, 0x82, 0x25, 0x8C, 0xB0, 0xE7, 0x0A, 0xFB,
  0x00, 0xEF, 0xA0, 0xE7, 0x10, 0x7F, 0xFE, 0x0E, 0x72, 0x02, 0x0A, 0xFF, 0xB0, 0xC0, 0x67, 0x48,
  0x11, 0x7C, 0xFB, 0x82, 0xEA, 0x72, 0x77, 0x38, 0x73, 0x56, 0x77, 0x65, 0x41, 0x71,
  // "ë" (U+00EB)
  0x68, 0x38, 0xDE, 0xB2, 0x71, 0x84, 0x2A, 0xEE, 0x91, 0x73, 0x0A, 0xC0, 0xE0, 0x17, 0x0D, 0xC0,
  0xB7, 0x3E, 0x05, 0x60, 0x3E, 0x01, 0x72, 0xE0, 0x66, 0x04, 0xE0, 0x27, 0x20, 0xED, 0x04, 0x60,
  0x2E, 0x73, 0x08, 0xC0, 0xD7, 0x10, 0xCC, 0x09, 0x74, 0x83, 0x7D, 0xEA, 0x27, 0x18, 0x31, 0xAE,
  0xD8, 0x80, 0xAC, 0x40, 0x86, 0x25, 0x67, 0x65, 0x41, 0x77, 0x58, 0x14, 0xAE, 0xF9, 0x0B, 0x06,
  0x77, 0x10, 0x40, 0xCF, 0xE0, 0xD0, 0x57, 0x50, 0x9F, 0xFB, 0x09, 0x73, 0x0B, 0xFA, 0x00, 0xEF,
  0x90, 0xA7, 0x10, 0xAE, 0x81, 0xC6, 0x24, 0x04, 0x09, 0xE0, 0x76, 0x06, 0xD0, 0xE0, 0x57, 0x20,
  0x30, 0xDD, 0x03, 0x40, 0x10, 0xEC, 0x0E, 0x02, 0x74, 0x02, 0x0E, 0xC0, 0xA4, 0x09, 0xD0, 0x47,
  0x60, 0x5D, 0x02, 0x20, 0x1D, 0x09, 0x77, 0x10, 0xDC, 0x08, 0x20, 0x6D, 0x01, 0x77, 0x10, 0x8C,
  0x0B, 0x20, 0xBC, 0x0B, 0x77, 0x20, 0x4D, 0x20, 0xEC, 0x06, 0x77, 0x20, 0x1D, 0x02, 0x01, 0xD0,
  0x88, 0x09, 0x56, 0xD0, 0x04, 0xFF, 0xFF, 0x00, 0x5F, 0xFF, 0xF0, 0x60, 0x5F, 0xFF, 0xF0, 0x06,
  0xFF, 0xFF, 0x06, 0x05, 0xD0, 0x17, 0x77, 0x20, 0x4D, 0x02, 0x77, 0x72, 0x02, 0xD0, 0x47, 0x77,
  0x3D, 0x07, 0x77, 0x73, 0x0C, 0xC0, 0xB7, 0x77, 0x30, 0x7D, 0x02, 0x77, 0x72, 0x02, 0xD0, 0x97,
  0x77, 0x30, 0xAD, 0x04, 0x77, 0x72, 0x02, 0xD0, 0xE0, 0x47, 0x73, 0x04, 0x50, 0x7E, 0x08, 0x01,
  0x75, 0x82, 0x27, 0xDE, 0x60, 0xAE, 0x82, 0xEA, 0x52, 0x58, 0x22, 0x58, 0xCB, 0x0E, 0x70, 0xAF,
  0xB0, 0x0E, 0xFA, 0x0E, 0x71, 0x07, 0xFF, 0xE0, 0xE7, 0x20, 0x20, 0xAF, 0xFB, 0x0C, 0x06, 0x74,
  0x81, 0x17, 0xCF, 0xB8, 0x2E, 0xA7, 0x27, 0x73, 0x87, 0x35, 0x67, 0x76, 0x54, 0x17, 0x10,
  // "ì" (U+00EC)
  0x60, 0x58, 0x01, 0x70, 0x57, 0x77, 0x10, 0x6E, 0x02, 0x77, 0x71, 0x0A, 0xD0, 0xB7, 0x77, 0x20,
  0xCD, 0x05, 0x77, 0x71, 0x01, 0x0D, 0xC0, 0xE0, 0x17, 0x77, 0x10, 0x20, 0xDC, 0x09, 0x77, 0x72,
  0x02, 0x0D, 0xC0, 0x47, 0x77, 0x20, 0x20, 0xDB, 0x0E, 0x01, 0x77, 0x72, 0x01, 0x0C, 0xB0, 0xB7,
  0x77, 0x40, 0xAB, 0x05, 0x80, 0xAB, 0x00, 0x03, 0xFF, 0x90, 0xA7, 0x50, 0x3F, 0xF9, 0x0A, 0x75,
  0x03, 0xFF, 0x90, 0xA7, 0x58, 0x13, 0xDE, 0xFE, 0x0A, 0x77, 0x28, 0x61, 0x23, 0x56, 0x78, 0xDC,
  0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77,
  0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0,
  0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72,
  0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A,
  0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20,
  0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7,
  0x77, 0x20, 0xBC, 0x0A, 0x77, 0x48, 0x41, 0x23, 0x46, 0xDC, 0x83, 0xC5, 0x43, 0x17, 0x84, 0x19,
  0xAB, 0xDE, 0xFF, 0xB8, 0x5E, 0xDC, 0xA9, 0x33, 0xFF, 0xFE, 0x06, 0x03, 0xFF, 0xFE, 0x06, 0x03,
  0xFF, 0xFE, 0x06,
  // "í" (U+00ED)
  0x77, 0x30, 0x58, 0x01, 0x70, 0x67, 0x77, 0x01, 0xE0, 0x97, 0x77, 0x0A, 0xD0, 0xC7, 0x77, 0x04,
  0xD0, 0xD0, 0x17, 0x77, 0x0D, 0xC0, 0xE0, 0x27, 0x77, 0x08, 0xC0, 0xE0, 0x27, 0x77, 0x03, 0xC0,
  0xE0, 0x37, 0x77, 0x10, 0xDB, 0x0E, 0x03, 0x77, 0x71, 0x09, 0xB0, 0xD0, 0x27, 0x77, 0x10, 0x3B,
  0x0B, 0x01, 0x80, 0xAB, 0x20, 0x03, 0xFF, 0x90, 0xA7, 0x50, 0x3F, 0xF9, 0x0A, 0x75, 0x03, 0xFF,
  0x90, 0xA7, 0x58, 0x13, 0xDE, 0xFE, 0x0A, 0x77, 0x28, 0x61, 0x23, 0x56, 0x78, 0xDC, 0x0A, 0x77,
  0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC,
  0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77,
  0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0,
  0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72,
  0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A,
  0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20,
  0xBC, 0x0A, 0x77, 0x48, 0x41, 0x23, 0x46, 0xDC, 0x83, 0xC5, 0x43, 0x17, 0x84, 0x19, 0xAB, 0xDE,
  0xFF, 0xB8, 0x5E, 0xDC, 0xA9, 0x33, 0xFF, 0xFE, 0x06, 0x03, 0xFF, 0xFE, 0x06, 0x03, 0xFF, 0xFE,
  0x06,
  // "î" (U+00EE)
  0x74, 0x80, 0x17, 0x06, 0x77, 0x71, 0x06, 0xE0, 0x47, 0x76, 0x02, 0x0E, 0xE0, 0xD0, 0x17, 0x74,
  0x01, 0x0D, 0xF9, 0x0B, 0x77, 0x40, 0xBC, 0x0A, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC8, 0x29, 0x01,
  0xCC, 0x07, 0x77, 0x07, 0xC0, 0x93, 0x01, 0x0C, 0xC0, 0x67, 0x50, 0x6C, 0x08, 0x60, 0xBC, 0x05,
  0x73, 0x05, 0xC0, 0x77, 0x10, 0x9C, 0x04, 0x71, 0x01, 0xB0, 0xD0, 0x37, 0x30, 0x50, 0xEB, 0x01,
  0x80, 0xAA, 0x20, 0x03, 0xFF, 0x90, 0xA7, 0x50, 0x3F, 0xF9, 0x0A, 0x75, 0x03, 0xFF, 0x90, 0xA7,
  0x58, 0x13, 0xDE, 0xFE, 0x0A, 0x77, 0x28, 0x61, 0x23, 0x56, 0x78, 0xDC, 0x0A, 0x77, 0x72, 0x0B,
  0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77,
  0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC,
  0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77,
  0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0,
  0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72,
  0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A,
  0x77, 0x48, 0x41, 0x23, 0x46, 0xDC, 0x83, 0xC5, 0x43, 0x17, 0x84, 0x19, 0xAB, 0xDE, 0xFF, 0xB8,
  0x5E, 0xDC, 0xA9, 0x33, 0xFF, 0xFE, 0x06, 0x03, 0xFF, 0xFE, 0x06, 0x03, 0xFF, 0xFE, 0x06,
  // "ï" (U+00EF)
  0x58, 0x38, 0xDE, 0xB2, 0x71, 0x84, 0x2A, 0xEE, 0x91, 0x72, 0x0A, 0xC0, 0xE0, 0x17, 0x0D, 0xC0,
  0xB7, 0x2E, 0x05, 0x60, 0x3E, 0x01, 0x71, 0xE0, 0x66, 0x04, 0xE0, 0x27, 0x10, 0xED, 0x04, 0x60,
  0x2E, 0x72, 0x08, 0xC0, 0xD7, 0x10, 0xCC, 0x09, 0x73, 0x83, 0x7D, 0xEA, 0x27, 0x18, 0x31, 0xAE,
  0xD8, 0x80, 0xAE, 0x10, 0x03, 0xFF, 0x90, 0xA7, 0x50, 0x3F, 0xF9, 0x0A, 0x75, 0x03, 0xFF, 0x90,
  0xA7, 0x58, 0x13, 0xDE, 0xFE, 0x0A, 0x77, 0x28, 0x61, 0x23, 0x56, 0x78, 0xDC, 0x0A, 0x77, 0x72,
  0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A,
  0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20,
  0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7,
  0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B,
  0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77,
  0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC,
  0x0A, 0x77, 0x48, 0x41, 0x23, 0x46, 0xDC, 0x83, 0xC5, 0x43, 0x17, 0x84, 0x19, 0xAB, 0xDE, 0xFF,
  0xB8, 0x5E, 0xDC, 0xA9, 0x33, 0xFF, 0xFE, 0x06, 0x03, 0xFF, 0xFE, 0x06, 0x03, 0xFF, 0xFE, 0x06,
  // "ð" (U+00F0)
  0x72, 0x02, 0x05, 0x76, 0x02, 0x77, 0x82, 0xBF, 0xC4, 0x72, 0x82, 0x3C, 0xE1, 0x75, 0x05, 0xC0,
  0xA0, 0x15, 0x01, 0x0A, 0xB0, 0xB7, 0x50, 0xDD, 0x0E, 0x05, 0x30, 0x8E, 0x06, 0x74, 0x05, 0x0E,
  0xE8, 0x19, 0x5D, 0xE0, 0x90, 0x17, 0x60, 0x8F, 0xD0, 0xC0, 0x37, 0x72, 0x03, 0x0D, 0xF9, 0x0D,
  0x05, 0x77, 0x50, 0x7F, 0x0A, 0x77, 0x50, 0x40, 0xDF, 0x90, 0xE0, 0x27, 0x72, 0x02, 0x0B, 0xFC,
  0x0D, 0x01, 0x77, 0x08, 0xE8, 0x2E, 0x63, 0xEC, 0x0B, 0x76, 0x03, 0xE0, 0x90, 0x12, 0x03, 0x0E,
  0xC0, 0x77, 0x60, 0x7B, 0x0B, 0x02, 0x50, 0x3D, 0x03, 0x76, 0x81, 0xCD, 0x57, 0x10, 0x6C, 0x0C,
  0x76, 0x01, 0x74, 0x0A, 0xC0, 0x77, 0x77, 0x40, 0xDB, 0x0E, 0x01, 0x77, 0x73, 0x05, 0xC0, 0x77,
  0x77, 0x40, 0xBB, 0x0E, 0x75, 0x89, 0x14, 0x8B, 0xDE, 0xFE, 0xDB, 0x73, 0x20, 0x3C, 0x06, 0x72,
  0x07, 0x0E, 0xFC, 0x82, 0xC4, 0x0C, 0xB0, 0xC7, 0x04, 0x0E, 0xFF, 0x90, 0x90, 0x6C, 0x02, 0x50,
  0x6F, 0xFC, 0x0B, 0xC0, 0x74, 0x05, 0xF8, 0x6E, 0xA8, 0x76, 0x79, 0xDF, 0xA0, 0xB3, 0x02, 0x0E,
  0xD0, 0xC0, 0x47, 0x10, 0x30, 0xBF, 0x0E, 0x30, 0xCD, 0x08, 0x75, 0x08, 0xF8, 0x12, 0x03, 0xD0,
  0xA7, 0x70, 0x9E, 0x81, 0x50, 0xAC, 0x0E, 0x01, 0x77, 0x10, 0xED, 0x81, 0x70, 0xEC, 0x08, 0x77,
  0x20, 0x7D, 0x08, 0x03, 0xD0, 0x37, 0x72, 0x01, 0xD0, 0x90, 0x7D, 0x77, 0x40, 0xDC, 0x0A, 0x08,
  0xC0, 0xC7, 0x74, 0x0B, 0xC0, 0xA0, 0x9C, 0x0B, 0x77, 0x40, 0xAC, 0x00, 0xAC, 0x0A, 0x77, 0x40,
  0xAC, 0x09, 0x0A, 0xC0, 0xA7, 0x74, 0x0B, 0xC0, 0x80, 0x9C, 0x0B, 0x77, 0x40, 0xCC, 0x06, 0x07,
  0xC0, 0xD7, 0x74, 0xD0, 0x30, 0x4D, 0x01, 0x77, 0x20, 0x3D, 0x10, 0x1D, 0x06, 0x77, 0x20, 0x8C,
  0x0B, 0x20, 0xBC, 0x0D, 0x77, 0x20, 0xDC, 0x06, 0x20, 0x5D, 0x07, 0x77, 0x07, 0xD0, 0x13, 0x0C,
  0xD0, 0x47, 0x50, 0x30, 0xEC, 0x08, 0x40, 0x3E, 0x06, 0x73, 0x05, 0x0E, 0xC0, 0xE0, 0x15, 0x07,
  0xE8, 0x1C, 0x72, 0x48, 0x12, 0x6B, 0xE0, 0x47, 0x08, 0xFA, 0x00, 0xEF, 0xA0, 0x67, 0x20, 0x6F,
  0xFB, 0x0E, 0x05, 0x74, 0x02, 0x0B, 0xFF, 0x0B, 0x02, 0x77, 0x81, 0x39, 0xDF, 0x98, 0x1E, 0x93,
  0x77, 0x58, 0x62, 0x46, 0x77, 0x65, 0x27, 0x40,
  // "ñ" (U+00F1)
  0x78, 0x51, 0x8D, 0xED, 0xB4, 0x71, 0x05, 0xA0, 0xB7, 0x10, 0x20, 0xEE, 0x0B, 0x02, 0x60, 0xBA,
  0x08, 0x70, 0x10, 0xDF, 0xA0, 0x74, 0x04, 0xB0, 0x47, 0x08, 0xFC, 0x82, 0xE9, 0x79, 0xB0, 0xE7,
  0x10, 0xEB, 0x82, 0x97, 0x8D, 0xFC, 0x08, 0x70, 0x5B, 0x05, 0x40, 0x70, 0xEF, 0x90, 0xD7, 0x10,
  0x8A, 0x0B, 0x60, 0x20, 0xBE, 0x0E, 0x02, 0x71, 0x0B, 0xA0, 0x67, 0x18, 0x54, 0xAD, 0xFD, 0x81,
  0x80, 0x9F, 0x60, 0x85, 0x25, 0x67, 0x65, 0x37, 0x10, 0x3C, 0x03, 0x48, 0x12, 0x9E, 0xF8, 0x1E,
  0x92, 0x50, 0x3C, 0x05, 0x30, 0x9F, 0xE0, 0x84, 0x03, 0xC8, 0x27, 0x01, 0xCF, 0xF9, 0x0B, 0x30,
  0x3C, 0x81, 0xA0, 0xBE, 0x00, 0xEF, 0xA0, 0x92, 0x03, 0xC0, 0xC0, 0x5B, 0x81, 0xD7, 0x34, 0x81,
  0x27, 0xEE, 0x81, 0x20, 0x3D, 0x0E, 0xA0, 0x97, 0x20, 0x10, 0xCD, 0x81, 0xA0, 0x3F, 0x09, 0x74,
  0x01, 0x0E, 0xC8, 0x1E, 0x03, 0xE0, 0xE7, 0x60, 0x9D, 0x00, 0x3E, 0x06, 0x76, 0x04, 0xD0, 0x50,
  0x3E, 0x01, 0x76, 0x01, 0xD0, 0x60, 0x3D, 0x0B, 0x77, 0x1D, 0x07, 0x03, 0xD0, 0x87, 0x71, 0x0E,
  0xC0, 0x70, 0x3D, 0x06, 0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0, 0x47, 0x71, 0x0E, 0xC0, 0x70, 0x3D,
  0x04, 0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0, 0x37, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x03, 0x77, 0x10,
  0xEC, 0x07, 0x03, 0xD0, 0x37, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x03,
  0xD0, 0x37, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0, 0x37, 0x71,
  0x0E, 0xC0, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0, 0x37, 0x71, 0x0E, 0xC0, 0x70,
  0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0, 0x37, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x03, 0x77,
  0x10, 0xEC, 0x07, 0x03, 0xD0, 0x37, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07,
  0x03, 0xD0, 0x37, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0, 0x37,
  0x71, 0x0E, 0xC0, 0x70,
  // "ò" (U+00F2)
  0x70, 0x58, 0x01, 0x70, 0x57, 0x77, 0x20, 0x6E, 0x02, 0x77, 0x72, 0x0A, 0xD0, 0xB7, 0x77, 0x30,
  0xCD, 0x05, 0x77, 0x72, 0x01, 0x0D, 0xC0, 0xE0, 0x17, 0x77, 0x20, 0x20, 0xDC, 0x09, 0x77, 0x73,
  0x02, 0x0D, 0xC0, 0x47, 0x77, 0x30, 0x20, 0xDB, 0x0E, 0x01, 0x77, 0x73, 0x01, 0x0C, 0xB0, 0xB7,
  0x77, 0x50, 0xAB, 0x05, 0x80, 0xA9, 0x10, 0x86, 0x25, 0x67, 0x76, 0x41, 0x77, 0x58, 0x13, 0x9E,
  0xF9, 0x81, 0xD8, 0x27, 0x70, 0x20, 0xBF, 0xF0, 0x90, 0x17, 0x40, 0x5F, 0xFB, 0x0E, 0x04, 0x72,
  0x07, 0xFA, 0x00, 0xEF, 0xA0, 0x57, 0x05, 0xE8, 0x1D, 0x73, 0x48, 0x13, 0x8E, 0xE0, 0x35, 0x01,
  0x0E, 0xD0, 0x97, 0x20, 0x10, 0xAD, 0x0D, 0x50, 0xAD, 0x08, 0x75, 0x0A, 0xD0, 0x83, 0x02, 0xD0,
  0xB7, 0x70, 0xDD, 0x01, 0x20, 0x8D, 0x02, 0x77, 0x04, 0xD0, 0x72, 0x0D, 0xC0, 0xB7, 0x72, 0x0D,
  0xC8, 0x1C, 0x02, 0xD0, 0x57, 0x72, 0x07, 0xD0, 0x10, 0x5D, 0x01, 0x77, 0x20, 0x3D, 0x04, 0x07,
  0xC0, 0xE7, 0x74, 0xD0, 0x70, 0x9C, 0x0C, 0x77, 0x40, 0xEC, 0x08, 0x0A, 0xC0, 0xB7, 0x74, 0x0D,
  0xC0, 0x90, 0xAC, 0x0A, 0x77, 0x40, 0xCC, 0x00, 0xAC, 0x0A, 0x77, 0x40, 0xCC, 0x0A, 0x09, 0xC0,
  0xB7, 0x74, 0x0D, 0xC0, 0x90, 0x8C, 0x0C, 0x77, 0x40, 0xEC, 0x09, 0x06, 0xC0, 0xE7, 0x73, 0x01,
  0xD0, 0x70, 0x4D, 0x02, 0x77, 0x20, 0x3D, 0x04, 0x01, 0xD0, 0x67, 0x72, 0x08, 0xD8, 0x11, 0x0C,
  0xC0, 0xB7, 0x72, 0x0D, 0xC0, 0xD2, 0x07, 0xD0, 0x37, 0x70, 0x4D, 0x08, 0x20, 0x1D, 0x0C, 0x77,
  0x0D, 0xD0, 0x13, 0x08, 0xD0, 0x97, 0x50, 0xAD, 0x09, 0x50, 0xDD, 0x09, 0x01, 0x71, 0x01, 0x0A,
  0xD0, 0xE0, 0x15, 0x03, 0xE8, 0x1E, 0x83, 0x48, 0x13, 0x8E, 0xE0, 0x47, 0x05, 0xFA, 0x00, 0xEF,
  0xA0, 0x67, 0x20, 0x40, 0xEF, 0xFA, 0x0E, 0x05, 0x74, 0x01, 0x0A, 0xFF, 0x0A, 0x01, 0x77, 0x81,
  0x28, 0xDF, 0x98, 0x1D, 0x92, 0x77, 0x58, 0x61, 0x46, 0x77, 0x64, 0x27, 0x40,
  // "ó" (U+00F3)
  0x77, 0x40, 0x58, 0x01, 0x70, 0x67, 0x77, 0x10, 0x1E, 0x09, 0x77, 0x71, 0x0A, 0xD0, 0xC7, 0x77,
  0x10, 0x4D, 0x0D, 0x01, 0x77, 0x71, 0x0D, 0xC0, 0xE0, 0x27, 0x77, 0x10, 0x8C, 0x0E, 0x02, 0x77,
  0x71, 0x03, 0xC0, 0xE0, 0x37, 0x77, 0x20, 0xDB, 0x0E, 0x03, 0x77, 0x72, 0x09, 0xB0, 0xD0, 0x27,
  0x77, 0x20, 0x3B, 0x0B, 0x01, 0x80, 0xA9, 0x30, 0x86, 0x25, 0x67, 0x76, 0x41, 0x77, 0x58, 0x13,
  0x9E, 0xF9, 0x81, 0xD8, 0x27, 0x70, 0x20, 0xBF, 0xF0, 0x90, 0x17, 0x40, 0x5F, 0xFB, 0x0E, 0x04,
  0x72, 0x07, 0xFA, 0x00, 0xEF, 0xA0, 0x57, 0x05, 0xE8, 0x1D, 0x73, 0x48, 0x13, 0x8E, 0xE0, 0x35,
  0x01, 0x0E, 0xD0, 0x97, 0x20, 0x10, 0xAD, 0x0D, 0x50, 0xAD, 0x08, 0x75, 0x0A, 0xD0, 0x83, 0x02,
  0xD0, 0xB7, 0x70, 0xDD, 0x01, 0x20, 0x8D, 0x02, 0x77, 0x04, 0xD0, 0x72, 0x0D, 0xC0, 0xB7, 0x72,
  0x0D, 0xC8, 0x1C, 0x02, 0xD0, 0x57, 0x72, 0x07, 0xD0, 0x10, 0x5D, 0x01, 0x77, 0x20, 0x3D, 0x04,
  0x07, 0xC0, 0xE7, 0x74, 0xD0, 0x70, 0x9C, 0x0C, 0x77, 0x40, 0xEC, 0x08, 0x0A, 0xC0, 0xB7, 0x74,
  0x0D, 0xC0, 0x90, 0xAC, 0x0A, 0x77, 0x40, 0xCC, 0x00, 0xAC, 0x0A, 0x77, 0x40, 0xCC, 0x0A, 0x09,
  0xC0, 0xB7, 0x74, 0x0D, 0xC0, 0x90, 0x8C, 0x0C, 0x77, 0x40, 0xEC, 0x09, 0x06, 0xC0, 0xE7, 0x73,
  0x01, 0xD0, 0x70, 0x4D, 0x02, 0x77, 0x20, 0x3D, 0x04, 0x01, 0xD0, 0x67, 0x72, 0x08, 0xD8, 0x11,
  0x0C, 0xC0, 0xB7, 0x72, 0x0D, 0xC0, 0xD2, 0x07, 0xD0, 0x37, 0x70, 0x4D, 0x08, 0x20, 0x1D, 0x0C,
  0x77, 0x0D, 0xD0, 0x13, 0x08, 0xD0, 0x97, 0x50, 0xAD, 0x09, 0x50, 0xDD, 0x09, 0x01, 0x71, 0x01,
  0x0A, 0xD0, 0xE0, 0x15, 0x03, 0xE8, 0x1E, 0x83, 0x48, 0x13, 0x8E, 0xE0, 0x47, 0x05, 0xFA, 0x00,
  0xEF, 0xA0, 0x67, 0x20, 0x40, 0xEF, 0xFA, 0x0E, 0x05, 0x74, 0x01, 0x0A, 0xFF, 0x0A, 0x01, 0x77,
  0x81, 0x28, 0xDF, 0x98, 0x1D, 0x92, 0x77, 0x58, 0x61, 0x46, 0x77, 0x64, 0x27, 0x40,
  // "ô" (U+00F4)
  0x75, 0x80, 0x17, 0x06, 0x77, 0x72, 0x06, 0xE0, 0x47, 0x77, 0x02, 0x0E, 0xE0, 0xD0, 0x17, 0x75,
  0x01, 0x0D, 0xF9, 0x0B, 0x77, 0x50, 0xBC, 0x0A, 0x0C, 0xC0, 0x97, 0x73, 0x09, 0xC8, 0x29, 0x01,
  0xCC, 0x07, 0x77, 0x10, 0x7C, 0x09, 0x30, 0x10, 0xCC, 0x06, 0x76, 0x06, 0xC0, 0x86, 0x0B, 0xC0,
  0x57, 0x40, 0x5C, 0x07, 0x71, 0x09, 0xC0, 0x47, 0x20, 0x1B, 0x0D, 0x03, 0x73, 0x05, 0x0E, 0xB0,
  0x18, 0x0A, 0x83, 0x08, 0x62, 0x56, 0x77, 0x64, 0x17, 0x75, 0x81, 0x39, 0xEF, 0x98, 0x1D, 0x82,
  0x77, 0x02, 0x0B, 0xFF, 0x09, 0x01, 0x74, 0x05, 0xFF, 0xB0, 0xE0, 0x47, 0x20, 0x7F, 0xA0, 0x0E,
  0xFA, 0x05, 0x70, 0x5E, 0x81, 0xD7, 0x34, 0x81, 0x38, 0xEE, 0x03, 0x50, 0x10, 0xED, 0x09, 0x72,
  0x01, 0x0A, 0xD0, 0xD5, 0x0A, 0xD0, 0x87, 0x50, 0xAD, 0x08, 0x30, 0x2D, 0x0B, 0x77, 0x0D, 0xD0,
  0x12, 0x08, 0xD0, 0x27, 0x70, 0x4D, 0x07, 0x20, 0xDC, 0x0B, 0x77, 0x20, 0xDC, 0x81, 0xC0, 0x2D,
  0x05, 0x77, 0x20, 0x7D, 0x01, 0x05, 0xD0, 0x17, 0x72, 0x03, 0xD0, 0x40, 0x7C, 0x0E, 0x77, 0x4D,
  0x07, 0x09, 0xC0, 0xC7, 0x74, 0x0E, 0xC0, 0x80, 0xAC, 0x0B, 0x77, 0x40, 0xDC, 0x09, 0x0A, 0xC0,
  0xA7, 0x74, 0x0C, 0xC0, 0x0A, 0xC0, 0xA7, 0x74, 0x0C, 0xC0, 0xA0, 0x9C, 0x0B, 0x77, 0x40, 0xDC,
  0x09, 0x08, 0xC0, 0xC7, 0x74, 0x0E, 0xC0, 0x90, 0x6C, 0x0E, 0x77, 0x30, 0x1D, 0x07, 0x04, 0xD0,
  0x27, 0x72, 0x03, 0xD0, 0x40, 0x1D, 0x06, 0x77, 0x20, 0x8D, 0x81, 0x10, 0xCC, 0x0B, 0x77, 0x20,
  0xDC, 0x0D, 0x20, 0x7D, 0x03, 0x77, 0x04, 0xD0, 0x82, 0x01, 0xD0, 0xC7, 0x70, 0xDD, 0x01, 0x30,
  0x8D, 0x09, 0x75, 0x0A, 0xD0, 0x95, 0x0D, 0xD0, 0x90, 0x17, 0x10, 0x10, 0xAD, 0x0E, 0x01, 0x50,
  0x3E, 0x81, 0xE8, 0x34, 0x81, 0x38, 0xEE, 0x04, 0x70, 0x5F, 0xA0, 0x0E, 0xFA, 0x06, 0x72, 0x04,
  0x0E, 0xFF, 0xA0, 0xE0, 0x57, 0x40, 0x10, 0xAF, 0xF0, 0xA0, 0x17, 0x78, 0x12, 0x8D, 0xF9, 0x81,
  0xD9, 0x27, 0x75, 0x86, 0x14, 0x67, 0x76, 0x42, 0x74,
  // "õ" (U+00F5)
  0x78, 0x51, 0x8D, 0xED, 0xB4, 0x71, 0x05, 0xA0, 0xB7, 0x30, 0x20, 0xEE, 0x0B, 0x02, 0x60, 0xBA,
  0x08, 0x72, 0x01, 0x0D, 0xFA, 0x07, 0x40, 0x4B, 0x04, 0x72, 0x08, 0xFC, 0x82, 0xE9, 0x79, 0xB0,
  0xE7, 0x30, 0xEB, 0x82, 0x97, 0x8D, 0xFC, 0x08, 0x72, 0x05, 0xB0, 0x54, 0x07, 0x0E, 0xF9, 0x0D,
  0x73, 0x08, 0xA0, 0xB6, 0x02, 0x0B, 0xE0, 0xE0, 0x27, 0x30, 0xBA, 0x06, 0x71, 0x85, 0x4A, 0xDF,
  0xD8, 0x18, 0x0A, 0x86, 0x08, 0x62, 0x56, 0x77, 0x64, 0x17, 0x75, 0x81, 0x39, 0xEF, 0x98, 0x1D,
  0x82, 0x77, 0x02, 0x0B, 0xFF, 0x09, 0x01, 0x74, 0x05, 0xFF, 0xB0, 0xE0, 0x47, 0x20, 0x7F, 0xA0,
  0x0E, 0xFA, 0x05, 0x70, 0x5E, 0x81, 0xD7, 0x34, 0x81, 0x38, 0xEE, 0x03, 0x50, 0x10, 0xED, 0x09,
  0x72, 0x01, 0x0A, 0xD0, 0xD5, 0x0A, 0xD0, 0x87, 0x50, 0xAD, 0x08, 0x30, 0x2D, 0x0B, 0x77, 0x0D,
  0xD0, 0x12, 0x08, 0xD0, 0x27, 0x70, 0x4D, 0x07, 0x20, 0xDC, 0x0B, 0x77, 0x20, 0xDC, 0x81, 0xC0,
  0x2D, 0x05, 0x77, 0x20, 0x7D, 0x01, 0x05, 0xD0, 0x17, 0x72, 0x03, 0xD0, 0x40, 0x7C, 0x0E, 0x77,
  0x4D, 0x07, 0x09, 0xC0, 0xC7, 0x74, 0x0E, 0xC0, 0x80, 0xAC, 0x0B, 0x77, 0x40, 0xDC, 0x09, 0x0A,
  0xC0, 0xA7, 0x74, 0x0C, 0xC0, 0x0A, 0xC0, 0xA7, 0x74, 0x0C, 0xC0, 0xA0, 0x9C, 0x0B, 0x77, 0x40,
  0xDC, 0x09, 0x08, 0xC0, 0xC7, 0x74, 0x0E, 0xC0, 0x90, 0x6C, 0x0E, 0x77, 0x30, 0x1D, 0x07, 0x04,
  0xD0, 0x27, 0x72, 0x03, 0xD0, 0x40, 0x1D, 0x06, 0x77, 0x20, 0x8D, 0x81, 0x10, 0xCC, 0x0B, 0x77,
  0x20, 0xDC, 0x0D, 0x20, 0x7D, 0x03, 0x77, 0x04, 0xD0, 0x82, 0x01, 0xD0, 0xC7, 0x70, 0xDD, 0x01,
  0x30, 0x8D, 0x09, 0x75, 0x0A, 0xD0, 0x95, 0x0D, 0xD0, 0x90, 0x17, 0x10, 0x10, 0xAD, 0x0E, 0x01,
  0x50, 0x3E, 0x81, 0xE8, 0x34, 0x81, 0x38, 0xEE, 0x04, 0x70, 0x5F, 0xA0, 0x0E, 0xFA, 0x06, 0x72,
  0x04, 0x0E, 0xFF, 0xA0, 0xE0, 0x57, 0x40, 0x10, 0xAF, 0xF0, 0xA0, 0x17, 0x78, 0x12, 0x8D, 0xF9,
  0x81, 0xD9, 0x27, 0x75, 0x86, 0x14, 0x67, 0x76, 0x42, 0x74,
  // "ö" (U+00F6)
  0x68, 0x38, 0xDE, 0xB2, 0x71, 0x84, 0x2A, 0xEE, 0x91, 0x73, 0x0A, 0xC0, 0xE0, 0x17, 0x0D, 0xC0,
  0xB7, 0x3E, 0x05, 0x60, 0x3E, 0x01, 0x72, 0xE0, 0x66, 0x04, 0xE0, 0x27, 0x20, 0xED, 0x04, 0x60,
  0x2E, 0x73, 0x08, 0xC0, 0xD7, 0x10, 0xCC, 0x09, 0x74, 0x83, 0x7D, 0xEA, 0x27, 0x18, 0x31, 0xAE,
  0xD8, 0x80, 0xAC, 0x30, 0x86, 0x25, 0x67, 0x76, 0x41, 0x77, 0x58, 0x13, 0x9E, 0xF9, 0x81, 0xD8,
  0x27, 0x70, 0x20, 0xBF, 0xF0, 0x90, 0x17, 0x40, 0x5F, 0xFB, 0x0E, 0x04, 0x72, 0x07, 0xFA, 0x00,
  0xEF, 0xA0, 0x57, 0x05, 0xE8, 0x1D, 0x73, 0x48, 0x13, 0x8E, 0xE0, 0x35, 0x01, 0x0E, 0xD0, 0x97,
  0x20, 0x10, 0xAD, 0x0D, 0x50, 0xAD, 0x08, 0x75, 0x0A, 0xD0, 0x83, 0x02, 0xD0, 0xB7, 0x70, 0xDD,
  0x01, 0x20, 0x8D, 0x02, 0x77, 0x04, 0xD0, 0x72, 0x0D, 0xC0, 0xB7, 0x72, 0x0D, 0xC8, 0x1C, 0x02,
  0xD0, 0x57, 0x72, 0x07, 0xD0, 0x10, 0x5D, 0x01, 0x77, 0x20, 0x3D, 0x04, 0x07, 0xC0, 0xE7, 0x74,
  0xD0, 0x70, 0x9C, 0x0C, 0x77, 0x40, 0xEC, 0x08, 0x0A, 0xC0, 0xB7, 0x74, 0x0D, 0xC0, 0x90, 0xAC,
  0x0A, 0x77, 0x40, 0xCC, 0x00, 0xAC, 0x0A, 0x77, 0x40, 0xCC, 0x0A, 0x09, 0xC0, 0xB7, 0x74, 0x0D,
  0xC0, 0x90, 0x8C, 0x0C, 0x77, 0x40, 0xEC, 0x09, 0x06, 0xC0, 0xE7, 0x73, 0x01, 0xD0, 0x70, 0x4D,
  0x02, 0x77, 0x20, 0x3D, 0x04, 0x01, 0xD0, 0x67, 0x72, 0x08, 0xD8, 0x11, 0x0C, 0xC0, 0xB7, 0x72,
  0x0D, 0xC0, 0xD2, 0x07, 0xD0, 0x37, 0x70, 0x4D, 0x08, 0x20, 0x1D, 0x0C, 0x77, 0x0D, 0xD0, 0x13,
  0x08, 0xD0, 0x97, 0x50, 0xAD, 0x09, 0x50, 0xDD, 0x09, 0x01, 0x71, 0x01, 0x0A, 0xD0, 0xE0, 0x15,
  0x03, 0xE8, 0x1E, 0x83, 0x48, 0x13, 0x8E, 0xE0, 0x47, 0x05, 0xFA, 0x00, 0xEF, 0xA0, 0x67, 0x20,
  0x40, 0xEF, 0xFA, 0x0E, 0x05, 0x74, 0x01, 0x0A, 0xFF, 0x0A, 0x01, 0x77, 0x81, 0x28, 0xDF, 0x98,
  0x1D, 0x92, 0x77, 0x58, 0x61, 0x46, 0x77, 0x64, 0x27, 0x40,
  // "÷" (U+00F7)
  0x74, 0x84, 0x2B, 0xEE, 0xA1, 0x77, 0x70, 0x10, 0xEC, 0x0C, 0x77, 0x70, 0x5E, 0x02, 0x77, 0x60,
  0x6E, 0x03, 0x77, 0x60, 0x4E, 0x01, 0x77, 0x70, 0xDC, 0x0B, 0x77, 0x71, 0x84, 0x2A, 0xEE, 0x91,
  0x80, 0xAA, 0x30, 0x03, 0xFF, 0xFD, 0x00, 0x3F, 0xFF, 0xD0, 0x03, 0xFF, 0xFD, 0x00, 0x3F, 0xFF,
  0xD0, 0x30, 0x18, 0x0A, 0x66, 0x01, 0x80, 0x9E, 0x70, 0x84, 0x2B, 0xEE, 0xA1, 0x77, 0x70, 0x10,
  0xEC, 0x0C, 0x77, 0x70, 0x5E, 0x02, 0x77, 0x60, 0x6E, 0x03, 0x77, 0x60, 0x4E, 0x01, 0x77, 0x70,
  0xDC, 0x0B, 0x77, 0x71, 0x84, 0x2A, 0xEE, 0x91, 0x74,
  // "ø" (U+00F8)
  0x77, 0x74, 0x07, 0x01, 0x77, 0x86, 0x25, 0x67, 0x76, 0x41, 0x58, 0x26, 0xFE, 0x57, 0x38, 0x13,
  0x9E, 0xF9, 0x84, 0xD7, 0x20, 0x2E, 0xB0, 0xA7, 0x02, 0x0B, 0xFF, 0x09, 0x0C, 0xC0, 0x56, 0x06,
  0xFF, 0xF0, 0xA6, 0x07, 0xFA, 0x00, 0xEF, 0xB0, 0xE0, 0x15, 0x05, 0xE8, 0x1D, 0x73, 0x40, 0x40,
  0x9F, 0x06, 0x50, 0x10, 0xED, 0x09, 0x72, 0x02, 0x0E, 0xD0, 0xB5, 0x0A, 0xD0, 0x87, 0x30, 0x5F,
  0x06, 0x30, 0x2D, 0x0B, 0x73, 0x01, 0x0E, 0xF0, 0xD3, 0x08, 0xD0, 0x27, 0x30, 0xCF, 0xA0, 0x52,
  0x0D, 0xC0, 0xB7, 0x30, 0x8C, 0x0A, 0x0D, 0xC8, 0x1B, 0x02, 0xD0, 0x57, 0x20, 0x4C, 0x81, 0xD0,
  0x7C, 0x81, 0xE0, 0x5D, 0x01, 0x71, 0x01, 0x0D, 0xC8, 0x13, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x72,
  0x0B, 0xC0, 0x73, 0xD0, 0x60, 0x9C, 0x0C, 0x71, 0x06, 0xC0, 0xB4, 0x0E, 0xC0, 0x80, 0xAC, 0x0B,
  0x70, 0x3C, 0x0E, 0x01, 0x40, 0xCC, 0x09, 0x0A, 0xC0, 0xA7, 0x0D, 0xC0, 0x45, 0x0C, 0xC0, 0x0A,
  0xC0, 0xA6, 0x09, 0xC0, 0x86, 0x0C, 0xC0, 0xA0, 0x9C, 0x0B, 0x50, 0x5C, 0x0C, 0x70, 0xDC, 0x09,
  0x08, 0xC0, 0xC4, 0x02, 0x0E, 0xB0, 0xE0, 0x17, 0x0E, 0xC0, 0x90, 0x6C, 0x0E, 0x40, 0xCC, 0x05,
  0x70, 0x1D, 0x07, 0x03, 0xD0, 0x12, 0x08, 0xC0, 0x97, 0x10, 0x3D, 0x05, 0x1D, 0x81, 0x60, 0x4C,
  0x0C, 0x72, 0x07, 0xD8, 0x12, 0x0C, 0xC8, 0x1B, 0x1E, 0xB0, 0xE0, 0x27, 0x20, 0xDC, 0x0D, 0x20,
  0x6D, 0x0C, 0xC0, 0x67, 0x20, 0x4D, 0x08, 0x30, 0xEF, 0x90, 0xA7, 0x30, 0xDD, 0x02, 0x30, 0x8F,
  0x0D, 0x73, 0x09, 0xD0, 0xA5, 0x0C, 0xE0, 0x47, 0x10, 0x10, 0xAD, 0x0E, 0x01, 0x50, 0x2E, 0x81,
  0xE8, 0x34, 0x81, 0x38, 0xEE, 0x04, 0x60, 0x6F, 0xB0, 0x0E, 0xFA, 0x06, 0x60, 0x20, 0xEF, 0xFD,
  0x0E, 0x05, 0x70, 0xCC, 0x0B, 0xFF, 0x0B, 0x02, 0x70, 0x4C, 0x83, 0x90, 0x28, 0xDF, 0x98, 0x1E,
  0x93, 0x73, 0x82, 0x4D, 0xFD, 0x58, 0x61, 0x46, 0x77, 0x65, 0x27, 0x71, 0x09, 0x03, 0x77, 0x73,
  // "ù" (U+00F9)
  0x60, 0x58, 0x01, 0x70, 0x57, 0x77, 0x06, 0xE0, 0x27, 0x77, 0x0A, 0xD0, 0xB7, 0x77, 0x10, 0xCD,
  0x05, 0x77, 0x70, 0x10, 0xDC, 0x0E, 0x01, 0x77, 0x70, 0x20, 0xDC, 0x09, 0x77, 0x71, 0x02, 0x0D,
  0xC0, 0x47, 0x77, 0x10, 0x20, 0xDB, 0x0E, 0x01, 0x77, 0x71, 0x01, 0x0C, 0xB0, 0xB7, 0x77, 0x30,
  0xAB, 0x05, 0x80, 0xAA, 0x10, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10,
  0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07,
  0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71,
  0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30,
  0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77,
  0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03,
  0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7,
  0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x4D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x04, 0xD0,
  0x30, 0x7C, 0x0E, 0x77, 0x10, 0x6D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x08, 0xD0, 0x30, 0x7D, 0x77,
  0x10, 0xBD, 0x03, 0x06, 0xD0, 0x17, 0x7E, 0x03, 0x05, 0xD0, 0x47, 0x60, 0x5E, 0x00, 0x3D, 0x09,
  0x76, 0x0D, 0xE8, 0x13, 0x0E, 0xC0, 0xE0, 0x17, 0x40, 0x8F, 0x81, 0x30, 0xAD, 0x0C, 0x01, 0x72,
  0x08, 0xF9, 0x81, 0x30, 0x3E, 0x81, 0xE7, 0x24, 0x81, 0x27, 0xDB, 0x0D, 0x0E, 0xC0, 0x32, 0x0A,
  0xFA, 0x00, 0xEE, 0x81, 0xE2, 0xBC, 0x03, 0x30, 0xCF, 0xFA, 0x81, 0x40, 0x8C, 0x03, 0x40, 0xAF,
  0xE0, 0xD0, 0x32, 0x06, 0xC0, 0x35, 0x81, 0x3A, 0xEF, 0x90, 0xC0, 0x64, 0x03, 0xC0, 0x37, 0x18,
  0x63, 0x56, 0x77, 0x64, 0x17, 0x50,
  // "ú" (U+00FA)
  0x77, 0x30, 0x58, 0x01, 0x70, 0x67, 0x76, 0x01, 0xE0, 0x97, 0x76, 0x0A, 0xD0, 0xC7, 0x76, 0x04,
  0xD0, 0xD0, 0x17, 0x76, 0x0D, 0xC0, 0xE0, 0x27, 0x76, 0x08, 0xC0, 0xE0, 0x27, 0x76, 0x03, 0xC0,
  0xE0, 0x37, 0x77, 0x0D, 0xB0, 0xE0, 0x37, 0x77, 0x09, 0xB0, 0xD0, 0x27, 0x77, 0x03, 0xB0, 0xB0,
  0x18, 0x0A, 0xA3, 0x00, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0,
  0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E,
  0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D,
  0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0,
  0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03,
  0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C,
  0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10,
  0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x04, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x4D, 0x03, 0x07,
  0xC0, 0xE7, 0x71, 0x06, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x8D, 0x03, 0x07, 0xD7, 0x71, 0x0B,
  0xD0, 0x30, 0x6D, 0x01, 0x77, 0xE0, 0x30, 0x5D, 0x04, 0x76, 0x05, 0xE0, 0x03, 0xD0, 0x97, 0x60,
  0xDE, 0x81, 0x30, 0xEC, 0x0E, 0x01, 0x74, 0x08, 0xF8, 0x13, 0x0A, 0xD0, 0xC0, 0x17, 0x20, 0x8F,
  0x98, 0x13, 0x03, 0xE8, 0x1E, 0x72, 0x48, 0x12, 0x7D, 0xB0, 0xD0, 0xEC, 0x03, 0x20, 0xAF, 0xA0,
  0x0E, 0xE8, 0x1E, 0x2B, 0xC0, 0x33, 0x0C, 0xFF, 0xA8, 0x14, 0x08, 0xC0, 0x34, 0x0A, 0xFE, 0x0D,
  0x03, 0x20, 0x6C, 0x03, 0x58, 0x13, 0xAE, 0xF9, 0x0C, 0x06, 0x40, 0x3C, 0x03, 0x71, 0x86, 0x35,
  0x67, 0x76, 0x41, 0x75,
  // "û" (U+00FB)
  0x74, 0x80, 0x17, 0x06, 0x77, 0x70, 0x6E, 0x04, 0x77, 0x50, 0x20, 0xEE, 0x0D, 0x01, 0x77, 0x30,
  0x10, 0xDF, 0x90, 0xB7, 0x73, 0x0B, 0xC0, 0xA0, 0xCC, 0x09, 0x77, 0x10, 0x9C, 0x82, 0x90, 0x1C,
  0xC0, 0x77, 0x60, 0x7C, 0x09, 0x30, 0x10, 0xCC, 0x06, 0x74, 0x06, 0xC0, 0x86, 0x0B, 0xC0, 0x57,
  0x20, 0x5C, 0x07, 0x71, 0x09, 0xC0, 0x47, 0x01, 0xB0, 0xD0, 0x37, 0x30, 0x50, 0xEB, 0x01, 0x80,
  0xA9, 0x30, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07,
  0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71,
  0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30,
  0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77,
  0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03,
  0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7,
  0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0,
  0x30, 0x7C, 0x0E, 0x77, 0x10, 0x4D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x04, 0xD0, 0x30, 0x7C, 0x0E,
  0x77, 0x10, 0x6D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x08, 0xD0, 0x30, 0x7D, 0x77, 0x10, 0xBD, 0x03,
  0x06, 0xD0, 0x17, 0x7E, 0x03, 0x05, 0xD0, 0x47, 0x60, 0x5E, 0x00, 0x3D, 0x09, 0x76, 0x0D, 0xE8,
  0x13, 0x0E, 0xC0, 0xE0, 0x17, 0x40, 0x8F, 0x81, 0x30, 0xAD, 0x0C, 0x01, 0x72, 0x08, 0xF9, 0x81,
  0x30, 0x3E, 0x81, 0xE7, 0x24, 0x81, 0x27, 0xDB, 0x0D, 0x0E, 0xC0, 0x32, 0x0A, 0xFA, 0x00, 0xEE,
  0x81, 0xE2, 0xBC, 0x03, 0x30, 0xCF, 0xFA, 0x81, 0x40, 0x8C, 0x03, 0x40, 0xAF, 0xE0, 0xD0, 0x32,
  0x06, 0xC0, 0x35, 0x81, 0x3A, 0xEF, 0x90, 0xC0, 0x64, 0x03, 0xC0, 0x37, 0x18, 0x63, 0x56, 0x77,
  0x64, 0x17, 0x50,
  // "ü" (U+00FC)
  0x58, 0x38, 0xDE, 0xB2, 0x71, 0x84, 0x2A, 0xEE, 0x91, 0x71, 0x0A, 0xC0, 0xE0, 0x17, 0x0D, 0xC0,
  0xB7, 0x1E, 0x05, 0x60, 0x3E, 0x01, 0x7E, 0x06, 0x60, 0x4E, 0x02, 0x70, 0xED, 0x04, 0x60, 0x2E,
  0x71, 0x08, 0xC0, 0xD7, 0x10, 0xCC, 0x09, 0x72, 0x83, 0x7D, 0xEA, 0x27, 0x18, 0x31, 0xAE, 0xD8,
  0x80, 0xAD, 0x10, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03,
  0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7,
  0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0,
  0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E,
  0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D,
  0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0,
  0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03,
  0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x4D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x04, 0xD0, 0x30, 0x7C,
  0x0E, 0x77, 0x10, 0x6D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x08, 0xD0, 0x30, 0x7D, 0x77, 0x10, 0xBD,
  0x03, 0x06, 0xD0, 0x17, 0x7E, 0x03, 0x05, 0xD0, 0x47, 0x60, 0x5E, 0x00, 0x3D, 0x09, 0x76, 0x0D,
  0xE8, 0x13, 0x0E, 0xC0, 0xE0, 0x17, 0x40, 0x8F, 0x81, 0x30, 0xAD, 0x0C, 0x01, 0x72, 0x08, 0xF9,
  0x81, 0x30, 0x3E, 0x81, 0xE7, 0x24, 0x81, 0x27, 0xDB, 0x0D, 0x0E, 0xC0, 0x32, 0x0A, 0xFA, 0x00,
  0xEE, 0x81, 0xE2, 0xBC, 0x03, 0x30, 0xCF, 0xFA, 0x81, 0x40, 0x8C, 0x03, 0x40, 0xAF, 0xE0, 0xD0,
  0x32, 0x06, 0xC0, 0x35, 0x81, 0x3A, 0xEF, 0x90, 0xC0, 0x64, 0x03, 0xC0, 0x37, 0x18, 0x63, 0x56,
  0x77, 0x64, 0x17, 0x50,
  // "ý" (U+00FD)
  0x77, 0x50, 0x58, 0x01, 0x70, 0x67, 0x77, 0x30, 0x1E, 0x09, 0x77, 0x73, 0x0A, 0xD0, 0xC7, 0x77,
  0x30, 0x4D, 0x0D, 0x01, 0x77, 0x73, 0x0D, 0xC0, 0xE0, 0x27, 0x77, 0x30, 0x8C, 0x0E, 0x02, 0x77,
  0x73, 0x03, 0xC0, 0xE0, 0x37, 0x77, 0x40, 0xDB, 0x0E, 0x03, 0x77, 0x74, 0x09, 0xB0, 0xD0, 0x27,
  0x77, 0x40, 0x3B, 0x0B, 0x01, 0x80, 0xAD, 0x10, 0x01, 0xD0, 0x37, 0x74, 0x07, 0xD8, 0x11, 0x0A,
  0xC0, 0x97, 0x74, 0x0C, 0xC0, 0xA2, 0x03, 0xC0, 0xE7, 0x73, 0x02, 0xD0, 0x43, 0x0C, 0xC0, 0x67,
  0x72, 0x07, 0xC0, 0xD4, 0x05, 0xC0, 0xD7, 0x72, 0x0C, 0xC0, 0x85, 0x0E, 0xC0, 0x47, 0x70, 0x2D,
  0x02, 0x50, 0x8C, 0x0A, 0x77, 0x07, 0xC0, 0xC6, 0x01, 0xD0, 0x17, 0x60, 0xDC, 0x06, 0x70, 0xAC,
  0x07, 0x75, 0x02, 0xC0, 0xE7, 0x10, 0x3C, 0x0E, 0x75, 0x08, 0xC0, 0x97, 0x20, 0xCC, 0x05, 0x74,
  0x0D, 0xC0, 0x47, 0x20, 0x6C, 0x0B, 0x73, 0x03, 0xC0, 0xD7, 0x40, 0xEC, 0x02, 0x72, 0x08, 0xC0,
  0x77, 0x40, 0x8C, 0x09, 0x72, 0x0D, 0xC0, 0x27, 0x40, 0x2C, 0x0E, 0x71, 0x03, 0xC0, 0xB7, 0x60,
  0xAC, 0x06, 0x70, 0x9C, 0x05, 0x76, 0x04, 0xC0, 0xC7, 0x0E, 0xB0, 0xE7, 0x71, 0x0D, 0xC0, 0x35,
  0x04, 0xC0, 0x97, 0x71, 0x06, 0xC0, 0xA5, 0x09, 0xC0, 0x37, 0x72, 0x0E, 0xC0, 0x14, 0x0E, 0xB0,
  0xD7, 0x73, 0x08, 0xC0, 0x73, 0x04, 0xC0, 0x77, 0x73, 0x02, 0xC0, 0xC3, 0x09, 0xC0, 0x17, 0x74,
  0x0B, 0xC0, 0x22, 0x0E, 0xB0, 0xB7, 0x75, 0x04, 0xC8, 0x17, 0x03, 0xC0, 0x57, 0x76, 0x0D, 0xB8,
  0x1C, 0x08, 0xB0, 0xE7, 0x77, 0x06, 0xC0, 0x20, 0xDB, 0x09, 0x77, 0x70, 0x10, 0xEB, 0x0A, 0xC0,
  0x37, 0x77, 0x10, 0x9F, 0x0C, 0x77, 0x72, 0x02, 0xF0, 0x77, 0x77, 0x30, 0xBE, 0x01, 0x77, 0x73,
  0x04, 0xD0, 0xA7, 0x77, 0x50, 0xEC, 0x04, 0x77, 0x74, 0x01, 0xC0, 0xE7, 0x77, 0x50, 0x8C, 0x08,
  0x77, 0x75, 0x0E, 0xC0, 0x27, 0x77, 0x40, 0x5C, 0x0C, 0x77, 0x75, 0x0C, 0xC0, 0x67, 0x77, 0x40,
  0x3C, 0x0E, 0x77, 0x75, 0x0C, 0xC0, 0x87, 0x77, 0x40, 0x8C, 0x0E, 0x01, 0x77, 0x73, 0x08, 0xD0,
  0x87, 0x73, 0x86, 0x19, 0x87, 0x67, 0x9E, 0xD0, 0xE0, 0x17, 0x73, 0x02, 0xFD, 0x04, 0x77, 0x40,
  0x2F, 0xC0, 0x57, 0x75, 0x02, 0xFA, 0x0C, 0x03, 0x77, 0x68, 0x90, 0x1A, 0xCE, 0xEF, 0xEC, 0x94,
  0x77, 0x70,
  // "þ" (U+00FE)
  0x03, 0xD0, 0x27, 0x77, 0x10, 0x3D, 0x02, 0x77, 0x71, 0x03, 0xD0, 0x27, 0x77, 0x10, 0x3D, 0x02,
  0x77, 0x71, 0x03, 0xD0, 0x27, 0x77, 0x10, 0x3D, 0x02, 0x77, 0x71, 0x03, 0xD0, 0x27, 0x77, 0x10,
  0x3D, 0x02, 0x77, 0x71, 0x03, 0xD0, 0x27, 0x77, 0x10, 0x3D, 0x02, 0x77, 0x71, 0x03, 0xD0, 0x27,
  0x77, 0x10, 0x3D, 0x02, 0x77, 0x71, 0x03, 0xD0, 0x27, 0x77, 0x10, 0x3D, 0x02, 0x58, 0x52, 0x56,
  0x77, 0x53, 0x73, 0x03, 0xD0, 0x13, 0x07, 0x0D, 0xF8, 0x1E, 0xA3, 0x70, 0x3D, 0x82, 0x10, 0x3D,
  0xFD, 0x0A, 0x01, 0x50, 0x3D, 0x10, 0x30, 0xEF, 0xF0, 0xD0, 0x24, 0x03, 0xD0, 0x20, 0xEE, 0x0E,
  0xFA, 0x0D, 0x01, 0x30, 0x3C, 0x0E, 0x0B, 0xB8, 0x1B, 0x51, 0x38, 0x11, 0x5A, 0xE0, 0xB3, 0x03,
  0xF9, 0x06, 0x72, 0x03, 0x0E, 0xD0, 0x52, 0x03, 0xF0, 0x57, 0x40, 0x20, 0xEC, 0x0D, 0x20, 0x3E,
  0x0A, 0x76, 0x07, 0xD8, 0x14, 0x03, 0xE0, 0x37, 0x70, 0xEC, 0x81, 0xA0, 0x3D, 0x0D, 0x77, 0x10,
  0x9C, 0x81, 0xE0, 0x3D, 0x08, 0x77, 0x10, 0x5D, 0x02, 0x03, 0xD0, 0x67, 0x71, 0x02, 0xD0, 0x50,
  0x3D, 0x04, 0x77, 0x2D, 0x07, 0x03, 0xD0, 0x37, 0x72, 0x0E, 0xC0, 0x80, 0x3D, 0x02, 0x77, 0x20,
  0xDC, 0x09, 0x03, 0xD0, 0x27, 0x72, 0x0C, 0xC0, 0xA0, 0x3D, 0x02, 0x77, 0x20, 0xDC, 0x0A, 0x03,
  0xD0, 0x37, 0x72, 0x0D, 0xC0, 0x90, 0x3D, 0x03, 0x77, 0x20, 0xEC, 0x08, 0x03, 0xD0, 0x57, 0x72,
  0xD0, 0x70, 0x3D, 0x08, 0x77, 0x10, 0x3D, 0x05, 0x03, 0xD0, 0xB7, 0x71, 0x06, 0xD0, 0x20, 0x3E,
  0x77, 0x10, 0xBC, 0x81, 0xE0, 0x3E, 0x05, 0x76, 0x01, 0xD8, 0x1A, 0x03, 0xE0, 0xC7, 0x60, 0x8D,
  0x81, 0x40, 0x3F, 0x07, 0x74, 0x04, 0xD0, 0xD2, 0x03, 0xF9, 0x06, 0x72, 0x04, 0x0E, 0xD0, 0x52,
  0x03, 0xC0, 0x0E, 0xB8, 0x1C, 0x61, 0x38, 0x11, 0x5B, 0xE0, 0xA3, 0x03, 0xC8, 0x1D, 0x3E, 0xE0,
  0xEF, 0xA0, 0xD0, 0x13, 0x03, 0xD1, 0x04, 0x0E, 0xFF, 0x0D, 0x01, 0x40, 0x3D, 0x82, 0x10, 0x1C,
  0xFD, 0x09, 0x01, 0x50, 0x3D, 0x01, 0x30, 0x60, 0xCF, 0x81, 0xEA, 0x37, 0x03, 0xD0, 0x25, 0x85,
  0x14, 0x67, 0x76, 0x37, 0x30, 0x3D, 0x02, 0x77, 0x71, 0x03, 0xD0, 0x27, 0x77, 0x10, 0x3D, 0x02,
  0x77, 0x71, 0x03, 0xD0, 0x27, 0x77, 0x10, 0x3D, 0x02, 0x77, 0x71, 0x03, 0xD0, 0x27, 0x77, 0x10,
  0x3D, 0x02, 0x77, 0x71, 0x03, 0xD0, 0x27, 0x77, 0x10, 0x3D, 0x02, 0x77, 0x71, 0x03, 0xD0, 0x27,
  0x77, 0x10, 0x3D, 0x02, 0x77, 0x71, 0x03, 0xD0, 0x27, 0x77, 0x10, 0x3D, 0x02, 0x77, 0x71,
  // "ÿ" (U+00FF)
  0x78, 0x38, 0xDE, 0xB2, 0x71, 0x84, 0x2A, 0xEE, 0x91, 0x75, 0x0A, 0xC0, 0xE0, 0x17, 0x0D, 0xC0,
  0xB7, 0x5E, 0x05, 0x60, 0x3E, 0x01, 0x74, 0xE0, 0x66, 0x04, 0xE0, 0x27, 0x40, 0xED, 0x04, 0x60,
  0x2E, 0x75, 0x08, 0xC0, 0xD7, 0x10, 0xCC, 0x09, 0x76, 0x83, 0x7D, 0xEA, 0x27, 0x18, 0x31, 0xAE,
  0xD8, 0x80, 0xB8, 0x30, 0x01, 0xD0, 0x37, 0x74, 0x07, 0xD8, 0x11, 0x0A, 0xC0, 0x97, 0x74, 0x0C,
  0xC0, 0xA2, 0x03, 0xC0, 0xE7, 0x73, 0x02, 0xD0, 0x43, 0x0C, 0xC0, 0x67, 0x72, 0x07, 0xC0, 0xD4,
  0x05, 0xC0, 0xD7, 0x72, 0x0C, 0xC0, 0x85, 0x0E, 0xC0, 0x47, 0x70, 0x2D, 0x02, 0x50, 0x8C, 0x0A,
  0x77, 0x07, 0xC0, 0xC6, 0x01, 0xD0, 0x17, 0x60, 0xDC, 0x06, 0x70, 0xAC, 0x07, 0x75, 0x02, 0xC0,
  0xE7, 0x10, 0x3C, 0x0E, 0x75, 0x08, 0xC0, 0x97, 0x20, 0xCC, 0x05, 0x74, 0x0D, 0xC0, 0x47, 0x20,
  0x6C, 0x0B, 0x73, 0x03, 0xC0, 0xD7, 0x40, 0xEC, 0x02, 0x72, 0x08, 0xC0, 0x77, 0x40, 0x8C, 0x09,
  0x72, 0x0D, 0xC0, 0x27, 0x40, 0x2C, 0x0E, 0x71, 0x03, 0xC0, 0xB7, 0x60, 0xAC, 0x06, 0x70, 0x9C,
  0x05, 0x76, 0x04, 0xC0, 0xC7, 0x0E, 0xB0, 0xE7, 0x71, 0x0D, 0xC0, 0x35, 0x04, 0xC0, 0x97, 0x71,
  0x06, 0xC0, 0xA5, 0x09, 0xC0, 0x37, 0x72, 0x0E, 0xC0, 0x14, 0x0E, 0xB0, 0xD7, 0x73, 0x08, 0xC0,
  0x73, 0x04, 0xC0, 0x77, 0x73, 0x02, 0xC0, 0xC3, 0x09, 0xC0, 0x17, 0x74, 0x0B, 0xC0, 0x22, 0x0E,
  0xB0, 0xB7, 0x75, 0x04, 0xC8, 0x17, 0x03, 0xC0, 0x57, 0x76, 0x0D, 0xB8, 0x1C, 0x08, 0xB0, 0xE7,
  0x77, 0x06, 0xC0, 0x20, 0xDB, 0x09, 0x77, 0x70, 0x10, 0xEB, 0x0A, 0xC0, 0x37, 0x77, 0x10, 0x9F,
  0x0C, 0x77, 0x72, 0x02, 0xF0, 0x77, 0x77, 0x30, 0xBE, 0x01, 0x77, 0x73, 0x04, 0xD0, 0xA7, 0x77,
  0x50, 0xEC, 0x04, 0x77, 0x74, 0x01, 0xC0, 0xE7, 0x77, 0x50, 0x8C, 0x08, 0x77, 0x75, 0x0E, 0xC0,
  0x27, 0x77, 0x40, 0x5C, 0x0C, 0x77, 0x75, 0x0C, 0xC0, 0x67, 0x77, 0x40, 0x3C, 0x0E, 0x77, 0x75,
  0x0C, 0xC0, 0x87, 0x77, 0x40, 0x8C, 0x0E, 0x01, 0x77, 0x73, 0x08, 0xD0, 0x87, 0x73, 0x86, 0x19,
  0x87, 0x67, 0x9E, 0xD0, 0xE0, 0x17, 0x73, 0x02, 0xFD, 0x04, 0x77, 0x40, 0x2F, 0xC0, 0x57, 0x75,
  0x02, 0xFA, 0x0C, 0x03, 0x77, 0x68, 0x90, 0x1A, 0xCE, 0xEF, 0xEC, 0x94, 0x77, 0x70,
  // "Ā" (U+0100)
  0x71, 0x05, 0x80, 0x94, 0x60, 0x57, 0x72, 0x0D, 0xFF, 0xA0, 0xE7, 0x72, 0x0D, 0xFF, 0xA0, 0xE7,
  0x72, 0x0D, 0xFF, 0xA0, 0xE7, 0x72, 0x0D, 0xFF, 0xA0, 0xE8, 0x0A, 0xF4, 0x0D, 0x0E, 0x77, 0x76,
  0x05, 0xE0, 0x47, 0x77, 0x50, 0xAE, 0x09, 0x77, 0x75, 0x0E, 0xE0, 0xE7, 0x77, 0x40, 0x5F, 0x90,
  0x47, 0x77, 0x30, 0xAF, 0x90, 0x97, 0x77, 0x30, 0xEB, 0x0B, 0x0D, 0xB0, 0xE7, 0x77, 0x20, 0x4C,
  0x08, 0x09, 0xC0, 0x37, 0x77, 0x10, 0x9C, 0x04, 0x05, 0xC0, 0x87, 0x77, 0x10, 0xEC, 0x10, 0x1C,
  0x0D, 0x77, 0x70, 0x4C, 0x0B, 0x20, 0xCC, 0x03, 0x77, 0x60, 0x9C, 0x06, 0x20, 0x7C, 0x08, 0x77,
  0x60, 0xEC, 0x02, 0x20, 0x3C, 0x0D, 0x77, 0x50, 0x3C, 0x0D, 0x40, 0xDC, 0x03, 0x77, 0x40, 0x8C,
  0x08, 0x40, 0x9C, 0x08, 0x77, 0x40, 0xDC, 0x03, 0x40, 0x4C, 0x0D, 0x77, 0x30, 0x3C, 0x0D, 0x60,
  0xEC, 0x02, 0x77, 0x20, 0x8C, 0x09, 0x60, 0xAC, 0x07, 0x77, 0x20, 0xDC, 0x04, 0x60, 0x5C, 0x0C,
  0x77, 0x10, 0x2C, 0x0E, 0x71, 0xD0, 0x27, 0x70, 0x7C, 0x0A, 0x71, 0x0B, 0xC0, 0x77, 0x70, 0xDC,
  0x05, 0x71, 0x06, 0xC0, 0xC7, 0x60, 0x2D, 0x72, 0x01, 0xD0, 0x27, 0x50, 0x7C, 0x0A, 0x73, 0x0B,
  0xC0, 0x77, 0x50, 0xCC, 0x06, 0x73, 0x07, 0xC0, 0xC7, 0x40, 0x2F, 0xFF, 0x90, 0x17, 0x30, 0x7F,
  0xFF, 0x90, 0x67, 0x30, 0xCF, 0xFF, 0x90, 0xB7, 0x20, 0x1F, 0xFF, 0xB0, 0x17, 0x10, 0x6C, 0x0C,
  0x80, 0x92, 0x60, 0xCC, 0x06, 0x71, 0x0B, 0xC0, 0x67, 0x70, 0x7C, 0x0B, 0x70, 0x1D, 0x01, 0x77,
  0x02, 0xD0, 0x16, 0x06, 0xC0, 0xC7, 0x72, 0x0D, 0xC0, 0x56, 0x0B, 0xC0, 0x77, 0x72, 0x08, 0xC0,
  0xA5, 0x01, 0xD0, 0x37, 0x72, 0x04, 0xD5, 0x05, 0xC0, 0xD7, 0x74, 0x0E, 0xC0, 0x54, 0x0A, 0xC0,
  0x97, 0x74, 0x0A, 0xC0, 0xA4, 0xD0, 0x47, 0x74, 0x05, 0xC0, 0xE3, 0x05, 0xD7, 0x75, 0x01, 0xD0,
  0x52, 0x0A, 0xC0, 0xA7, 0x76, 0x0B, 0xC0, 0xA2, 0x0E, 0xC0, 0x67, 0x76, 0x07, 0xC8, 0x1E, 0x04,
  0xD0, 0x17, 0x76, 0x02, 0xD0, 0x40, 0x9C, 0x0C, 0x77, 0x71, 0x0D, 0xC0, 0x90,
  // "ā" (U+0101)
  0x50, 0x58, 0x09, 0x46, 0x05, 0x72, 0x0D, 0xFF, 0xA0, 0xE7, 0x20, 0xDF, 0xFA, 0x0E, 0x72, 0x0D,
  0xFF, 0xA0, 0xE7, 0x20, 0xDF, 0xFA, 0x0E, 0x80, 0x9E, 0x50, 0x87, 0x13, 0x56, 0x77, 0x65, 0x37,
  0x71, 0x81, 0x49, 0xDF, 0xB0, 0xB0, 0x57, 0x28, 0x11, 0x8E, 0xFF, 0x90, 0xE0, 0x56, 0x04, 0xFF,
  0xE0, 0x86, 0x0E, 0xFA, 0x00, 0xEF, 0xA0, 0x75, 0x07, 0xB8, 0x2D, 0x95, 0x25, 0x81, 0x27, 0xCE,
  0x02, 0x58, 0x1E, 0xA3, 0x75, 0x06, 0xD0, 0xA7, 0x77, 0x06, 0xD7, 0x77, 0x10, 0xDC, 0x04, 0x77,
  0x70, 0x8C, 0x06, 0x77, 0x70, 0x6C, 0x07, 0x77, 0x70, 0x5C, 0x08, 0x77, 0x70, 0x4C, 0x09, 0x71,
  0x84, 0x47, 0xAC, 0xDE, 0xFD, 0x09, 0x58, 0x13, 0xAE, 0xFF, 0xC0, 0x93, 0x01, 0x09, 0xFF, 0xF0,
  0x92, 0x01, 0x0D, 0xFF, 0xF9, 0x09, 0x20, 0xDF, 0x83, 0xEB, 0x97, 0x78, 0x02, 0x60, 0x9C, 0x81,
  0x90, 0x8E, 0x0A, 0x04, 0x74, 0x04, 0xC0, 0x91, 0xD0, 0xE0, 0x47, 0x60, 0x4C, 0x09, 0x05, 0xD0,
  0x57, 0x70, 0x5C, 0x00, 0x9C, 0x0B, 0x77, 0x10, 0x6C, 0x09, 0x0A, 0xC0, 0x77, 0x71, 0x08, 0xC0,
  0x90, 0xBC, 0x05, 0x77, 0x10, 0xDC, 0x09, 0x0B, 0xC0, 0x57, 0x70, 0x4D, 0x09, 0x0A, 0xC0, 0x77,
  0x60, 0x10, 0xDD, 0x09, 0x07, 0xC0, 0xD7, 0x50, 0x10, 0xDE, 0x09, 0x03, 0xD0, 0x97, 0x30, 0x50,
  0xEF, 0x81, 0x90, 0xCD, 0x81, 0xD6, 0x23, 0x82, 0x13, 0x8D, 0xC0, 0xAC, 0x81, 0x90, 0x4F, 0xA0,
  0xEF, 0x90, 0x70, 0x2C, 0x09, 0x20, 0x6F, 0xFA, 0x07, 0x2C, 0x09, 0x30, 0x50, 0xEF, 0xD0, 0xD0,
  0x33, 0x0E, 0xB0, 0x94, 0x81, 0x17, 0xDF, 0x90, 0xC0, 0x65, 0x0C, 0xB0, 0x97, 0x86, 0x15, 0x67,
  0x76, 0x41, 0x75,
  // "Ă" (U+0102)
  0x70, 0x3B, 0x06, 0x73, 0x05, 0xB0, 0x47, 0x70, 0x1B, 0x0D, 0x73, 0x0C, 0xB0, 0x27, 0x71, 0x0D,
  0xB0, 0xB0, 0x26, 0x01, 0x0A, 0xB0, 0xD7, 0x72, 0x06, 0xD8, 0x4B, 0x86, 0x78, 0xBD, 0x07, 0x77,
  0x30, 0xCF, 0xF0, 0xD7, 0x74, 0x01, 0x0D, 0xFD, 0x0D, 0x01, 0x77, 0x50, 0x10, 0xAF, 0xB0, 0xA0,
  0x17, 0x77, 0x18, 0x90, 0x38, 0xCE, 0xFE, 0xDB, 0x72, 0x80, 0xB8, 0x00, 0xD0, 0xE7, 0x77, 0x60,
  0x5E, 0x04, 0x77, 0x75, 0x0A, 0xE0, 0x97, 0x77, 0x50, 0xEE, 0x0E, 0x77, 0x74, 0x05, 0xF9, 0x04,
  0x77, 0x73, 0x0A, 0xF9, 0x09, 0x77, 0x73, 0x0E, 0xB0, 0xB0, 0xDB, 0x0E, 0x77, 0x72, 0x04, 0xC0,
  0x80, 0x9C, 0x03, 0x77, 0x71, 0x09, 0xC0, 0x40, 0x5C, 0x08, 0x77, 0x71, 0x0E, 0xC1, 0x01, 0xC0,
  0xD7, 0x77, 0x04, 0xC0, 0xB2, 0x0C, 0xC0, 0x37, 0x76, 0x09, 0xC0, 0x62, 0x07, 0xC0, 0x87, 0x76,
  0x0E, 0xC0, 0x22, 0x03, 0xC0, 0xD7, 0x75, 0x03, 0xC0, 0xD4, 0x0D, 0xC0, 0x37, 0x74, 0x08, 0xC0,
  0x84, 0x09, 0xC0, 0x87, 0x74, 0x0D, 0xC0, 0x34, 0x04, 0xC0, 0xD7, 0x73, 0x03, 0xC0, 0xD6, 0x0E,
  0xC0, 0x27, 0x72, 0x08, 0xC0, 0x96, 0x0A, 0xC0, 0x77, 0x72, 0x0D, 0xC0, 0x46, 0x05, 0xC0, 0xC7,
  0x71, 0x02, 0xC0, 0xE7, 0x1D, 0x02, 0x77, 0x07, 0xC0, 0xA7, 0x10, 0xBC, 0x07, 0x77, 0x0D, 0xC0,
  0x57, 0x10, 0x6C, 0x0C, 0x76, 0x02, 0xD7, 0x20, 0x1D, 0x02, 0x75, 0x07, 0xC0, 0xA7, 0x30, 0xBC,
  0x07, 0x75, 0x0C, 0xC0, 0x67, 0x30, 0x7C, 0x0C, 0x74, 0x02, 0xFF, 0xF9, 0x01, 0x73, 0x07, 0xFF,
  0xF9, 0x06, 0x73, 0x0C, 0xFF, 0xF9, 0x0B, 0x72, 0x01, 0xFF, 0xFB, 0x01, 0x71, 0x06, 0xC0, 0xC8,
  0x09, 0x26, 0x0C, 0xC0, 0x67, 0x10, 0xBC, 0x06, 0x77, 0x07, 0xC0, 0xB7, 0x01, 0xD0, 0x17, 0x70,
  0x2D, 0x01, 0x60, 0x6C, 0x0C, 0x77, 0x20, 0xDC, 0x05, 0x60, 0xBC, 0x07, 0x77, 0x20, 0x8C, 0x0A,
  0x50, 0x1D, 0x03, 0x77, 0x20, 0x4D, 0x50, 0x5C, 0x0D, 0x77, 0x40, 0xEC, 0x05, 0x40, 0xAC, 0x09,
  0x77, 0x40, 0xAC, 0x0A, 0x4D, 0x04, 0x77, 0x40, 0x5C, 0x0E, 0x30, 0x5D, 0x77, 0x50, 0x1D, 0x05,
  0x20, 0xAC, 0x0A, 0x77, 0x60, 0xBC, 0x0A, 0x20, 0xEC, 0x06, 0x77, 0x60, 0x7C, 0x81, 0xE0, 0x4D,
  0x01, 0x77, 0x60, 0x2D, 0x04, 0x09, 0xC0, 0xC7, 0x77, 0x10, 0xDC, 0x09,
  // "ă" (U+0103)
  0x40, 0x3B, 0x06, 0x73, 0x05, 0xB0, 0x47, 0x01, 0xB0, 0xD7, 0x30, 0xCB, 0x02, 0x71, 0x0D, 0xB0,
  0xB0, 0x26, 0x01, 0x0A, 0xB0, 0xD7, 0x20, 0x6D, 0x84, 0xB8, 0x67, 0x8B, 0xD0, 0x77, 0x30, 0xCF,
  0xF0, 0xD7, 0x40, 0x10, 0xDF, 0xD0, 0xD0, 0x17, 0x50, 0x10, 0xAF, 0xB0, 0xA0, 0x17, 0x71, 0x89,
  0x03, 0x8C, 0xEF, 0xED, 0xB7, 0x28, 0x09, 0xF1, 0x08, 0x71, 0x35, 0x67, 0x76, 0x53, 0x77, 0x18,
  0x14, 0x9D, 0xFB, 0x0B, 0x05, 0x72, 0x81, 0x18, 0xEF, 0xF9, 0x0E, 0x05, 0x60, 0x4F, 0xFE, 0x08,
  0x60, 0xEF, 0xA0, 0x0E, 0xFA, 0x07, 0x50, 0x7B, 0x82, 0xD9, 0x52, 0x58, 0x12, 0x7C, 0xE0, 0x25,
  0x81, 0xEA, 0x37, 0x50, 0x6D, 0x0A, 0x77, 0x70, 0x6D, 0x77, 0x71, 0x0D, 0xC0, 0x47, 0x77, 0x08,
  0xC0, 0x67, 0x77, 0x06, 0xC0, 0x77, 0x77, 0x05, 0xC0, 0x87, 0x77, 0x04, 0xC0, 0x97, 0x18, 0x44,
  0x7A, 0xCD, 0xEF, 0xD0, 0x95, 0x81, 0x3A, 0xEF, 0xFC, 0x09, 0x30, 0x10, 0x9F, 0xFF, 0x09, 0x20,
  0x10, 0xDF, 0xFF, 0x90, 0x92, 0x0D, 0xF8, 0x3E, 0xB9, 0x77, 0x80, 0x26, 0x09, 0xC8, 0x19, 0x08,
  0xE0, 0xA0, 0x47, 0x40, 0x4C, 0x09, 0x1D, 0x0E, 0x04, 0x76, 0x04, 0xC0, 0x90, 0x5D, 0x05, 0x77,
  0x05, 0xC0, 0x09, 0xC0, 0xB7, 0x71, 0x06, 0xC0, 0x90, 0xAC, 0x07, 0x77, 0x10, 0x8C, 0x09, 0x0B,
  0xC0, 0x57, 0x71, 0x0D, 0xC0, 0x90, 0xBC, 0x05, 0x77, 0x04, 0xD0, 0x90, 0xAC, 0x07, 0x76, 0x01,
  0x0D, 0xD0, 0x90, 0x7C, 0x0D, 0x75, 0x01, 0x0D, 0xE0, 0x90, 0x3D, 0x09, 0x73, 0x05, 0x0E, 0xF8,
  0x19, 0x0C, 0xD8, 0x1D, 0x62, 0x38, 0x21, 0x38, 0xDC, 0x0A, 0xC8, 0x19, 0x04, 0xFA, 0x0E, 0xF9,
  0x07, 0x02, 0xC0, 0x92, 0x06, 0xFF, 0xA0, 0x72, 0xC0, 0x93, 0x05, 0x0E, 0xFD, 0x0D, 0x03, 0x30,
  0xEB, 0x09, 0x48, 0x11, 0x7D, 0xF9, 0x0C, 0x06, 0x50, 0xCB, 0x09, 0x78, 0x61, 0x56, 0x77, 0x64,
  0x17, 0x50,
  // "Ą" (U+0104)
  0x77, 0xD0, 0xE7, 0x77, 0x71, 0x05, 0xE0, 0x47, 0x77, 0x70, 0xAE, 0x09, 0x77, 0x77, 0x0E, 0xE0,
  0xE7, 0x77, 0x60, 0x5F, 0x90, 0x47, 0x77, 0x50, 0xAF, 0x90, 0x97, 0x77, 0x50, 0xEB, 0x0B, 0x0D,
  0xB0, 0xE7, 0x77, 0x40, 0x4C, 0x08, 0x09, 0xC0, 0x37, 0x77, 0x30, 0x9C, 0x04, 0x05, 0xC0, 0x87,
  0x77, 0x30, 0xEC, 0x10, 0x1C, 0x0D, 0x77, 0x72, 0x04, 0xC0, 0xB2, 0x0C, 0xC0, 0x37, 0x77, 0x10,
  0x9C, 0x06, 0x20, 0x7C, 0x08, 0x77, 0x71, 0x0E, 0xC0, 0x22, 0x03, 0xC0, 0xD7, 0x77, 0x03, 0xC0,
  0xD4, 0x0D, 0xC0, 0x37, 0x76, 0x08, 0xC0, 0x84, 0x09, 0xC0, 0x87, 0x76, 0x0D, 0xC0, 0x34, 0x04,
  0xC0, 0xD7, 0x75, 0x03, 0xC0, 0xD6, 0x0E, 0xC0, 0x27, 0x74, 0x08, 0xC0, 0x96, 0x0A, 0xC0, 0x77,
  0x74, 0x0D, 0xC0, 0x46, 0x05, 0xC0, 0xC7, 0x73, 0x02, 0xC0, 0xE7, 0x1D, 0x02, 0x77, 0x20, 0x7C,
  0x0A, 0x71, 0x0B, 0xC0, 0x77, 0x72, 0x0D, 0xC0, 0x57, 0x10, 0x6C, 0x0C, 0x77, 0x10, 0x2D, 0x72,
  0x01, 0xD0, 0x27, 0x70, 0x7C, 0x0A, 0x73, 0x0B, 0xC0, 0x77, 0x70, 0xCC, 0x06, 0x73, 0x07, 0xC0,
  0xC7, 0x60, 0x2F, 0xFF, 0x90, 0x17, 0x50, 0x7F, 0xFF, 0x90, 0x67, 0x50, 0xCF, 0xFF, 0x90, 0xB7,
  0x40, 0x1F, 0xFF, 0xB0, 0x17, 0x30, 0x6C, 0x0C, 0x80, 0x92, 0x60, 0xCC, 0x06, 0x73, 0x0B, 0xC0,
  0x67, 0x70, 0x7C, 0x0B, 0x72, 0x01, 0xD0, 0x17, 0x70, 0x2D, 0x01, 0x71, 0x06, 0xC0, 0xC7, 0x72,
  0x0D, 0xC0, 0x57, 0x10, 0xBC, 0x07, 0x77, 0x20, 0x8C, 0x0A, 0x70, 0x1D, 0x03, 0x77, 0x20, 0x4D,
  0x70, 0x5C, 0x0D, 0x77, 0x40, 0xEC, 0x05, 0x60, 0xAC, 0x09, 0x77, 0x40, 0xAC, 0x0A, 0x6D, 0x04,
  0x77, 0x40, 0x5C, 0x0E, 0x50, 0x5D, 0x77, 0x50, 0x1D, 0x05, 0x40, 0xAC, 0x0A, 0x77, 0x60, 0xBC,
  0x0A, 0x40, 0xEC, 0x06, 0x77, 0x60, 0x7C, 0x0E, 0x30, 0x4D, 0x01, 0x77, 0x60, 0x2D, 0x04, 0x20,
  0x9C, 0x0C, 0x77, 0x71, 0x0D, 0xC0, 0xE7, 0x77, 0x72, 0x08, 0xB0, 0x77, 0x77, 0x72, 0x06, 0xB0,
  0x97, 0x77, 0x72, 0x02, 0xB0, 0xC7, 0x77, 0x73, 0x0B, 0xB0, 0x37, 0x77, 0x72, 0x02, 0xB0, 0xD7,
  0x77, 0x73, 0x07, 0xB0, 0x97, 0x77, 0x73, 0x09, 0xB0, 0x97, 0x77, 0x73, 0x0B, 0xB0, 0xC7, 0x77,
  0x73, 0x09, 0xC0, 0x90, 0x22, 0x03, 0x77, 0x75, 0x06, 0xFA, 0x02, 0x77, 0x75, 0x0D, 0xF9, 0x02,
  0x77, 0x75, 0x03, 0x0E, 0xF0, 0x27, 0x77, 0x68, 0x71, 0x8C, 0xEF, 0xEC, 0x81,
  // "ą" (U+0105)
  0x72, 0x87, 0x13, 0x56, 0x77, 0x65, 0x37, 0x73, 0x81, 0x49, 0xDF, 0xB0, 0xB0, 0x57, 0x48, 0x11,
  0x8E, 0xFF, 0x90, 0xE0, 0x57, 0x10, 0x4F, 0xFE, 0x08, 0x71, 0x0E, 0xFA, 0x00, 0xEF, 0xA0, 0x77,
  0x07, 0xB8, 0x2D, 0x95, 0x25, 0x81, 0x27, 0xCE, 0x02, 0x78, 0x1E, 0xA3, 0x75, 0x06, 0xD0, 0xA7,
  0x77, 0x20, 0x6D, 0x77, 0x73, 0x0D, 0xC0, 0x47, 0x77, 0x20, 0x8C, 0x06, 0x77, 0x72, 0x06, 0xC0,
  0x77, 0x77, 0x20, 0x5C, 0x08, 0x77, 0x72, 0x04, 0xC0, 0x97, 0x38, 0x44, 0x7A, 0xCD, 0xEF, 0xD0,
  0x97, 0x81, 0x3A, 0xEF, 0xFC, 0x09, 0x50, 0x10, 0x9F, 0xFF, 0x09, 0x40, 0x10, 0xDF, 0xFF, 0x90,
  0x94, 0x0D, 0xF8, 0x3E, 0xB9, 0x77, 0x80, 0x26, 0x09, 0xC0, 0x93, 0x08, 0xE0, 0xA0, 0x47, 0x40,
  0x4C, 0x09, 0x3D, 0x0E, 0x04, 0x76, 0x04, 0xC0, 0x92, 0x05, 0xD0, 0x57, 0x70, 0x5C, 0x09, 0x20,
  0x9C, 0x0B, 0x77, 0x10, 0x6C, 0x09, 0x20, 0xAC, 0x07, 0x77, 0x10, 0x8C, 0x09, 0x20, 0xBC, 0x05,
  0x77, 0x10, 0xDC, 0x09, 0x20, 0xBC, 0x05, 0x77, 0x04, 0xD0, 0x92, 0x0A, 0xC0, 0x77, 0x60, 0x10,
  0xDD, 0x09, 0x20, 0x7C, 0x0D, 0x75, 0x01, 0x0D, 0xE0, 0x92, 0x03, 0xD0, 0x97, 0x30, 0x50, 0xEF,
  0x09, 0x30, 0xCD, 0x81, 0xD6, 0x23, 0x82, 0x13, 0x8D, 0xC0, 0xAC, 0x09, 0x30, 0x4F, 0xA0, 0xEF,
  0x90, 0x70, 0x2C, 0x09, 0x40, 0x6F, 0xFA, 0x07, 0x2C, 0x09, 0x50, 0x50, 0xEF, 0xD0, 0xD0, 0x33,
  0x0E, 0xB0, 0x96, 0x81, 0x17, 0xDF, 0x90, 0xC0, 0x65, 0xC0, 0xD7, 0x28, 0x61, 0x56, 0x77, 0x64,
  0x16, 0x08, 0xB0, 0x77, 0x77, 0x20, 0x6B, 0x09, 0x77, 0x72, 0x02, 0xB0, 0xC7, 0x77, 0x30, 0xBB,
  0x03, 0x77, 0x72, 0x02, 0xB0, 0xD7, 0x77, 0x30, 0x7B, 0x09, 0x77, 0x73, 0x09, 0xB0, 0x97, 0x77,
  0x30, 0xBB, 0x0C, 0x77, 0x73, 0x09, 0xC0, 0x90, 0x22, 0x03, 0x77, 0x50, 0x6F, 0xA0, 0x27, 0x75,
  0x0D, 0xF9, 0x02, 0x77, 0x50, 0x30, 0xEF, 0x02, 0x77, 0x68, 0x71, 0x8C, 0xEF, 0xEC, 0x81,
  // "Ć" (U+0106)
  0x77, 0x70, 0x58, 0x01, 0x70, 0x67, 0x77, 0x01, 0xE0, 0x97, 0x77, 0x0A, 0xD0, 0xC7, 0x77, 0x04,
  0xD0, 0xD0, 0x17, 0x77, 0x0D, 0xC0, 0xE0, 0x27, 0x77, 0x08, 0xC0, 0xE0, 0x27, 0x77, 0x03, 0xC0,
  0xE0, 0x37, 0x77, 0x10, 0xDB, 0x0E, 0x03, 0x77, 0x71, 0x09, 0xB0, 0xD0, 0x27, 0x77, 0x10, 0x3B,
  0x0B, 0x01, 0x80, 0xA8, 0x60, 0x87, 0x25, 0x67, 0x76, 0x54, 0x27, 0x73, 0x81, 0x5B, 0xEF, 0xA8,
  0x2E, 0xB7, 0x27, 0x40, 0x70, 0xEF, 0xFA, 0x0C, 0x05, 0x70, 0x30, 0xDF, 0xFD, 0x0A, 0x60, 0x6F,
  0xB0, 0x0E, 0xFA, 0x03, 0x50, 0x7F, 0x81, 0xB6, 0x24, 0x82, 0x14, 0x7B, 0xB0, 0xB5, 0x05, 0xE0,
  0xB0, 0x27, 0x48, 0x21, 0x7E, 0x44, 0x01, 0x0E, 0xD0, 0x87, 0x77, 0x0B, 0xD0, 0x87, 0x77, 0x04,
  0xD0, 0xB7, 0x77, 0x10, 0xCD, 0x02, 0x77, 0x70, 0x2D, 0x09, 0x77, 0x71, 0x08, 0xD0, 0x27, 0x77,
  0x10, 0xDC, 0x0C, 0x77, 0x71, 0x01, 0xD0, 0x77, 0x77, 0x10, 0x5D, 0x03, 0x77, 0x71, 0x08, 0xD7,
  0x77, 0x20, 0xAC, 0x0D, 0x77, 0x72, 0x0C, 0xC0, 0xB7, 0x77, 0x20, 0xEC, 0x09, 0x77, 0x72, 0xD0,
  0x97, 0x77, 0x2D, 0x08, 0x77, 0x72, 0xD0, 0x77, 0x77, 0x2D, 0x08, 0x77, 0x72, 0xD0, 0x87, 0x77,
  0x20, 0xEC, 0x09, 0x77, 0x72, 0x0C, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0C, 0x77, 0x72, 0x09, 0xD7,
  0x77, 0x20, 0x6D, 0x02, 0x77, 0x71, 0x02, 0xD0, 0x67, 0x77, 0x20, 0xEC, 0x0B, 0x77, 0x72, 0x09,
  0xD7, 0x77, 0x20, 0x5D, 0x06, 0x77, 0x72, 0x0D, 0xC0, 0xE7, 0x77, 0x20, 0x7D, 0x07, 0x77, 0x72,
  0x0E, 0xD0, 0x37, 0x77, 0x10, 0x5D, 0x0E, 0x03, 0x77, 0x71, 0x09, 0xE0, 0x87, 0x68, 0x13, 0x81,
  0x60, 0xBE, 0x82, 0xE9, 0x41, 0x48, 0x31, 0x36, 0x9D, 0xA0, 0x27, 0x0B, 0xFB, 0x00, 0xEF, 0x90,
  0x27, 0x10, 0x8F, 0xFD, 0x02, 0x72, 0x03, 0x0B, 0xFF, 0xB0, 0x27, 0x48, 0x12, 0x8D, 0xFB, 0x82,
  0xEB, 0x72, 0x77, 0x28, 0x73, 0x56, 0x77, 0x65, 0x42, 0x60,
  // "ć" (U+0107)
  0x77, 0x40, 0x58, 0x01, 0x70, 0x67, 0x74, 0x01, 0xE0, 0x97, 0x74, 0x0A, 0xD0, 0xC7, 0x74, 0x04,
  0xD0, 0xD0, 0x17, 0x74, 0x0D, 0xC0, 0xE0, 0x27, 0x74, 0x08, 0xC0, 0xE0, 0x27, 0x74, 0x03, 0xC0,
  0xE0, 0x37, 0x75, 0x0D, 0xB0, 0xE0, 0x37, 0x75, 0x09, 0xB0, 0xD0, 0x27, 0x75, 0x03, 0xB0, 0xB0,
  0x18, 0x09, 0xE7, 0x08, 0x71, 0x35, 0x67, 0x76, 0x53, 0x77, 0x81, 0x28, 0xCF, 0xB8, 0x1C, 0x72,
  0x71, 0x03, 0x0B, 0xFF, 0xA0, 0xB0, 0x15, 0x07, 0xFF, 0xC0, 0xE5, 0x0A, 0xFB, 0x00, 0xEF, 0x09,
  0x40, 0x8F, 0x81, 0x95, 0x14, 0x82, 0x25, 0x9E, 0xA0, 0x43, 0x04, 0xE0, 0xA0, 0x17, 0x40, 0x70,
  0xD4, 0x0D, 0xD0, 0x87, 0x74, 0x05, 0xD0, 0xB7, 0x75, 0x0C, 0xD0, 0x27, 0x74, 0x01, 0xD0, 0xA7,
  0x75, 0x05, 0xD0, 0x57, 0x75, 0x08, 0xD0, 0x17, 0x75, 0x0A, 0xC0, 0xE7, 0x76, 0x0C, 0xC0, 0xB7,
  0x76, 0x0C, 0xC0, 0xB7, 0x76, 0x0D, 0xC0, 0xA7, 0x76, 0x0D, 0xC0, 0xA7, 0x76, 0x0D, 0xC0, 0xA7,
  0x76, 0x0C, 0xC0, 0xB7, 0x76, 0x0B, 0xC0, 0xD7, 0x76, 0x09, 0xD7, 0x76, 0x06, 0xD0, 0x37, 0x75,
  0x03, 0xD0, 0x97, 0x76, 0x0E, 0xC0, 0xE7, 0x76, 0x08, 0xD0, 0x97, 0x75, 0x02, 0xE0, 0x67, 0x75,
  0x09, 0xE0, 0x90, 0x17, 0x50, 0x40, 0x94, 0x0D, 0xE8, 0x2E, 0x95, 0x14, 0x85, 0x13, 0x6A, 0xEF,
  0xE4, 0x01, 0x0D, 0xFB, 0x00, 0xEF, 0x0E, 0x50, 0x10, 0xAF, 0xFC, 0x0E, 0x70, 0x60, 0xDF, 0xFA,
  0x0D, 0x72, 0x81, 0x5A, 0xEF, 0xB8, 0x1C, 0x94, 0x76, 0x87, 0x24, 0x56, 0x76, 0x64, 0x26,
  // "Ĉ" (U+0108)
  0x77, 0x18, 0x01, 0x70, 0x67, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x60, 0x20, 0xEE, 0x0D, 0x01, 0x77,
  0x40, 0x10, 0xDF, 0x90, 0xB7, 0x74, 0x0B, 0xC0, 0xA0, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x82, 0x90,
  0x1C, 0xC0, 0x77, 0x70, 0x7C, 0x09, 0x30, 0x10, 0xCC, 0x06, 0x75, 0x06, 0xC0, 0x86, 0x0B, 0xC0,
  0x57, 0x30, 0x5C, 0x07, 0x71, 0x09, 0xC0, 0x47, 0x10, 0x1B, 0x0D, 0x03, 0x73, 0x05, 0x0E, 0xB0,
  0x18, 0x09, 0xF6, 0x08, 0x72, 0x56, 0x77, 0x65, 0x42, 0x77, 0x38, 0x15, 0xBE, 0xFA, 0x82, 0xEB,
  0x72, 0x74, 0x07, 0x0E, 0xFF, 0xA0, 0xC0, 0x57, 0x03, 0x0D, 0xFF, 0xD0, 0xA6, 0x06, 0xFB, 0x00,
  0xEF, 0xA0, 0x35, 0x07, 0xF8, 0x1B, 0x62, 0x48, 0x21, 0x47, 0xBB, 0x0B, 0x50, 0x5E, 0x0B, 0x02,
  0x74, 0x82, 0x17, 0xE4, 0x40, 0x10, 0xED, 0x08, 0x77, 0x70, 0xBD, 0x08, 0x77, 0x70, 0x4D, 0x0B,
  0x77, 0x71, 0x0C, 0xD0, 0x27, 0x77, 0x02, 0xD0, 0x97, 0x77, 0x10, 0x8D, 0x02, 0x77, 0x71, 0x0D,
  0xC0, 0xC7, 0x77, 0x10, 0x1D, 0x07, 0x77, 0x71, 0x05, 0xD0, 0x37, 0x77, 0x10, 0x8D, 0x77, 0x72,
  0x0A, 0xC0, 0xD7, 0x77, 0x20, 0xCC, 0x0B, 0x77, 0x72, 0x0E, 0xC0, 0x97, 0x77, 0x2D, 0x09, 0x77,
  0x72, 0xD0, 0x87, 0x77, 0x2D, 0x07, 0x77, 0x72, 0xD0, 0x87, 0x77, 0x2D, 0x08, 0x77, 0x72, 0x0E,
  0xC0, 0x97, 0x77, 0x20, 0xCC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xC7, 0x77, 0x20, 0x9D, 0x77, 0x72,
  0x06, 0xD0, 0x27, 0x77, 0x10, 0x2D, 0x06, 0x77, 0x72, 0x0E, 0xC0, 0xB7, 0x77, 0x20, 0x9D, 0x77,
  0x72, 0x05, 0xD0, 0x67, 0x77, 0x20, 0xDC, 0x0E, 0x77, 0x72, 0x07, 0xD0, 0x77, 0x77, 0x20, 0xED,
  0x03, 0x77, 0x71, 0x05, 0xD0, 0xE0, 0x37, 0x77, 0x10, 0x9E, 0x08, 0x76, 0x81, 0x38, 0x16, 0x0B,
  0xE8, 0x2E, 0x94, 0x14, 0x83, 0x13, 0x69, 0xDA, 0x02, 0x70, 0xBF, 0xB0, 0x0E, 0xF9, 0x02, 0x71,
  0x08, 0xFF, 0xD0, 0x27, 0x20, 0x30, 0xBF, 0xFB, 0x02, 0x74, 0x81, 0x28, 0xDF, 0xB8, 0x2E, 0xB7,
  0x27, 0x72, 0x87, 0x35, 0x67, 0x76, 0x54, 0x26,
  // "ĉ" (U+0109)
  0x75, 0x80, 0x17, 0x06, 0x77, 0x50, 0x6E, 0x04, 0x77, 0x30, 0x20, 0xEE, 0x0D, 0x01, 0x77, 0x10,
  0x10, 0xDF, 0x90, 0xB7, 0x71, 0x0B, 0xC0, 0xA0, 0xCC, 0x09, 0x76, 0x09, 0xC8, 0x29, 0x01, 0xCC,
  0x07, 0x74, 0x07, 0xC0, 0x93, 0x01, 0x0C, 0xC0, 0x67, 0x20, 0x6C, 0x08, 0x60, 0xBC, 0x05, 0x70,
  0x5C, 0x07, 0x71, 0x09, 0xC0, 0x45, 0x01, 0xB0, 0xD0, 0x37, 0x30, 0x50, 0xEB, 0x01, 0x80, 0x9D,
  0x70, 0x87, 0x13, 0x56, 0x77, 0x65, 0x37, 0x78, 0x12, 0x8C, 0xFB, 0x81, 0xC7, 0x27, 0x10, 0x30,
  0xBF, 0xFA, 0x0B, 0x01, 0x50, 0x7F, 0xFC, 0x0E, 0x50, 0xAF, 0xB0, 0x0E, 0xF0, 0x94, 0x08, 0xF8,
  0x19, 0x51, 0x48, 0x22, 0x59, 0xEA, 0x04, 0x30, 0x4E, 0x0A, 0x01, 0x74, 0x07, 0x0D, 0x40, 0xDD,
  0x08, 0x77, 0x40, 0x5D, 0x0B, 0x77, 0x50, 0xCD, 0x02, 0x77, 0x40, 0x1D, 0x0A, 0x77, 0x50, 0x5D,
  0x05, 0x77, 0x50, 0x8D, 0x01, 0x77, 0x50, 0xAC, 0x0E, 0x77, 0x60, 0xCC, 0x0B, 0x77, 0x60, 0xCC,
  0x0B, 0x77, 0x60, 0xDC, 0x0A, 0x77, 0x60, 0xDC, 0x0A, 0x77, 0x60, 0xDC, 0x0A, 0x77, 0x60, 0xCC,
  0x0B, 0x77, 0x60, 0xBC, 0x0D, 0x77, 0x60, 0x9D, 0x77, 0x60, 0x6D, 0x03, 0x77, 0x50, 0x3D, 0x09,
  0x77, 0x60, 0xEC, 0x0E, 0x77, 0x60, 0x8D, 0x09, 0x77, 0x50, 0x2E, 0x06, 0x77, 0x50, 0x9E, 0x09,
  0x01, 0x75, 0x04, 0x09, 0x40, 0xDE, 0x82, 0xE9, 0x51, 0x48, 0x51, 0x36, 0xAE, 0xFE, 0x40, 0x10,
  0xDF, 0xB0, 0x0E, 0xF0, 0xE5, 0x01, 0x0A, 0xFF, 0xC0, 0xE7, 0x06, 0x0D, 0xFF, 0xA0, 0xD7, 0x28,
  0x15, 0xAE, 0xFB, 0x81, 0xC9, 0x47, 0x68, 0x72, 0x45, 0x67, 0x66, 0x42, 0x60,
  // "Ċ" (U+010A)
  0x77, 0x18, 0x42, 0xAE, 0xEA, 0x27, 0x77, 0x10, 0x20, 0xEC, 0x0E, 0x02, 0x77, 0x70, 0x8E, 0x08,
  0x77, 0x70, 0xBE, 0x0B, 0x77, 0x70, 0xBE, 0x0B, 0x77, 0x70, 0x8E, 0x08, 0x77, 0x70, 0x20, 0xEC,
  0x0E, 0x02, 0x77, 0x71, 0x84, 0x2A, 0xEE, 0xA2, 0x80, 0xAC, 0x30, 0x87, 0x25, 0x67, 0x76, 0x54,
  0x27, 0x73, 0x81, 0x5B, 0xEF, 0xA8, 0x2E, 0xB7, 0x27, 0x40, 0x70, 0xEF, 0xFA, 0x0C, 0x05, 0x70,
  0x30, 0xDF, 0xFD, 0x0A, 0x60, 0x6F, 0xB0, 0x0E, 0xFA, 0x03, 0x50, 0x7F, 0x81, 0xB6, 0x24, 0x82,
  0x14, 0x7B, 0xB0, 0xB5, 0x05, 0xE0, 0xB0, 0x27, 0x48, 0x21, 0x7E, 0x44, 0x01, 0x0E, 0xD0, 0x87,
  0x77, 0x0B, 0xD0, 0x87, 0x77, 0x04, 0xD0, 0xB7, 0x77, 0x10, 0xCD, 0x02, 0x77, 0x70, 0x2D, 0x09,
  0x77, 0x71, 0x08, 0xD0, 0x27, 0x77, 0x10, 0xDC, 0x0C, 0x77, 0x71, 0x01, 0xD0, 0x77, 0x77, 0x10,
  0x5D, 0x03, 0x77, 0x71, 0x08, 0xD7, 0x77, 0x20, 0xAC, 0x0D, 0x77, 0x72, 0x0C, 0xC0, 0xB7, 0x77,
  0x20, 0xEC, 0x09, 0x77, 0x72, 0xD0, 0x97, 0x77, 0x2D, 0x08, 0x77, 0x72, 0xD0, 0x77, 0x77, 0x2D,
  0x08, 0x77, 0x72, 0xD0, 0x87, 0x77, 0x20, 0xEC, 0x09, 0x77, 0x72, 0x0C, 0xC0, 0xA7, 0x77, 0x20,
  0xBC, 0x0C, 0x77, 0x72, 0x09, 0xD7, 0x77, 0x20, 0x6D, 0x02, 0x77, 0x71, 0x02, 0xD0, 0x67, 0x77,
  0x20, 0xEC, 0x0B, 0x77, 0x72, 0x09, 0xD7, 0x77, 0x20, 0x5D, 0x06, 0x77, 0x72, 0x0D, 0xC0, 0xE7,
  0x77, 0x20, 0x7D, 0x07, 0x77, 0x72, 0x0E, 0xD0, 0x37, 0x77, 0x10, 0x5D, 0x0E, 0x03, 0x77, 0x71,
  0x09, 0xE0, 0x87, 0x68, 0x13, 0x81, 0x60, 0xBE, 0x82, 0xE9, 0x41, 0x48, 0x31, 0x36, 0x9D, 0xA0,
  0x27, 0x0B, 0xFB, 0x00, 0xEF, 0x90, 0x27, 0x10, 0x8F, 0xFD, 0x02, 0x72, 0x03, 0x0B, 0xFF, 0xB0,
  0x27, 0x48, 0x12, 0x8D, 0xFB, 0x82, 0xEB, 0x72, 0x77, 0x28, 0x73, 0x56, 0x77, 0x65, 0x42, 0x60,
  // "ċ" (U+010B)
  0x75, 0x84, 0x2A, 0xEE, 0xA2, 0x77, 0x50, 0x20, 0xEC, 0x0E, 0x02, 0x77, 0x40, 0x8E, 0x08, 0x77,
  0x40, 0xBE, 0x0B, 0x77, 0x40, 0xBE, 0x0B, 0x77, 0x40, 0x8E, 0x08, 0x77, 0x40, 0x20, 0xEC, 0x0E,
  0x02, 0x77, 0x58, 0x42, 0xAE, 0xEA, 0x28, 0x0A, 0xA1, 0x08, 0x71, 0x35, 0x67, 0x76, 0x53, 0x77,
  0x81, 0x28, 0xCF, 0xB8, 0x1C, 0x72, 0x71, 0x03, 0x0B, 0xFF, 0xA0, 0xB0, 0x15, 0x07, 0xFF, 0xC0,
  0xE5, 0x0A, 0xFB, 0x00, 0xEF, 0x09, 0x40, 0x8F, 0x81, 0x95, 0x14, 0x82, 0x25, 0x9E, 0xA0, 0x43,
  0x04, 0xE0, 0xA0, 0x17, 0x40, 0x70, 0xD4, 0x0D, 0xD0, 0x87, 0x74, 0x05, 0xD0, 0xB7, 0x75, 0x0C,
  0xD0, 0x27, 0x74, 0x01, 0xD0, 0xA7, 0x75, 0x05, 0xD0, 0x57, 0x75, 0x08, 0xD0, 0x17, 0x75, 0x0A,
  0xC0, 0xE7, 0x76, 0x0C, 0xC0, 0xB7, 0x76, 0x0C, 0xC0, 0xB7, 0x76, 0x0D, 0xC0, 0xA7, 0x76, 0x0D,
  0xC0, 0xA7, 0x76, 0x0D, 0xC0, 0xA7, 0x76, 0x0C, 0xC0, 0xB7, 0x76, 0x0B, 0xC0, 0xD7, 0x76, 0x09,
  0xD7, 0x76, 0x06, 0xD0, 0x37, 0x75, 0x03, 0xD0, 0x97, 0x76, 0x0E, 0xC0, 0xE7, 0x76, 0x08, 0xD0,
  0x97, 0x75, 0x02, 0xE0, 0x67, 0x75, 0x09, 0xE0, 0x90, 0x17, 0x50, 0x40, 0x94, 0x0D, 0xE8, 0x2E,
  0x95, 0x14, 0x85, 0x13, 0x6A, 0xEF, 0xE4, 0x01, 0x0D, 0xFB, 0x00, 0xEF, 0x0E, 0x50, 0x10, 0xAF,
  0xFC, 0x0E, 0x70, 0x60, 0xDF, 0xFA, 0x0D, 0x72, 0x81, 0x5A, 0xEF, 0xB8, 0x1C, 0x94, 0x76, 0x87,
  0x24, 0x56, 0x76, 0x64, 0x26,
  // "Č" (U+010C)
  0x78, 0x31, 0x77, 0x76, 0x75, 0x83, 0x67, 0x77, 0x17, 0x01, 0x0D, 0xB0, 0xB0, 0x17, 0x10, 0x20,
  0xCB, 0x0D, 0x01, 0x71, 0x02, 0x0E, 0xB0, 0xD0, 0x36, 0x04, 0x0E, 0xB0, 0xD0, 0x27, 0x30, 0x30,
  0xEC, 0x04, 0x40, 0x6C, 0x0D, 0x02, 0x75, 0x03, 0xD0, 0x52, 0x07, 0xC0, 0xE0, 0x27, 0x70, 0x5D,
  0x05, 0x08, 0xC0, 0xE0, 0x37, 0x72, 0x06, 0xFB, 0x04, 0x77, 0x40, 0x8F, 0x90, 0x67, 0x76, 0x0B,
  0xE0, 0x97, 0x77, 0x02, 0x0E, 0xC0, 0xD8, 0x0A, 0x86, 0x08, 0x72, 0x56, 0x77, 0x65, 0x42, 0x77,
  0x38, 0x15, 0xBE, 0xFA, 0x82, 0xEB, 0x72, 0x74, 0x07, 0x0E, 0xFF, 0xA0, 0xC0, 0x57, 0x03, 0x0D,
  0xFF, 0xD0, 0xA6, 0x06, 0xFB, 0x00, 0xEF, 0xA0, 0x35, 0x07, 0xF8, 0x1B, 0x62, 0x48, 0x21, 0x47,
  0xBB, 0x0B, 0x50, 0x5E, 0x0B, 0x02, 0x74, 0x82, 0x17, 0xE4, 0x40, 0x10, 0xED, 0x08, 0x77, 0x70,
  0xBD, 0x08, 0x77, 0x70, 0x4D, 0x0B, 0x77, 0x71, 0x0C, 0xD0, 0x27, 0x77, 0x02, 0xD0, 0x97, 0x77,
  0x10, 0x8D, 0x02, 0x77, 0x71, 0x0D, 0xC0, 0xC7, 0x77, 0x10, 0x1D, 0x07, 0x77, 0x71, 0x05, 0xD0,
  0x37, 0x77, 0x10, 0x8D, 0x77, 0x72, 0x0A, 0xC0, 0xD7, 0x77, 0x20, 0xCC, 0x0B, 0x77, 0x72, 0x0E,
  0xC0, 0x97, 0x77, 0x2D, 0x09, 0x77, 0x72, 0xD0, 0x87, 0x77, 0x2D, 0x07, 0x77, 0x72, 0xD0, 0x87,
  0x77, 0x2D, 0x08, 0x77, 0x72, 0x0E, 0xC0, 0x97, 0x77, 0x20, 0xCC, 0x0A, 0x77, 0x72, 0x0B, 0xC0,
  0xC7, 0x77, 0x20, 0x9D, 0x77, 0x72, 0x06, 0xD0, 0x27, 0x77, 0x10, 0x2D, 0x06, 0x77, 0x72, 0x0E,
  0xC0, 0xB7, 0x77, 0x20, 0x9D, 0x77, 0x72, 0x05, 0xD0, 0x67, 0x77, 0x20, 0xDC, 0x0E, 0x77, 0x72,
  0x07, 0xD0, 0x77, 0x77, 0x20, 0xED, 0x03, 0x77, 0x71, 0x05, 0xD0, 0xE0, 0x37, 0x77, 0x10, 0x9E,
  0x08, 0x76, 0x81, 0x38, 0x16, 0x0B, 0xE8, 0x2E, 0x94, 0x14, 0x83, 0x13, 0x69, 0xDA, 0x02, 0x70,
  0xBF, 0xB0, 0x0E, 0xF9, 0x02, 0x71, 0x08, 0xFF, 0xD0, 0x27, 0x20, 0x30, 0xBF, 0xFB, 0x02, 0x74,
  0x81, 0x28, 0xDF, 0xB8, 0x2E, 0xB7, 0x27, 0x72, 0x87, 0x35, 0x67, 0x76, 0x54, 0x26,
  // "č" (U+010D)
  0x48, 0x31, 0x77, 0x76, 0x75, 0x83, 0x67, 0x77, 0x14, 0x01, 0x0D, 0xB0, 0xB0, 0x17, 0x10, 0x20,
  0xCB, 0x0D, 0x01, 0x50, 0x20, 0xEB, 0x0D, 0x03, 0x60, 0x40, 0xEB, 0x0D, 0x02, 0x70, 0x30, 0xEC,
  0x04, 0x40, 0x6C, 0x0D, 0x02, 0x72, 0x03, 0xD0, 0x52, 0x07, 0xC0, 0xE0, 0x27, 0x40, 0x5D, 0x05,
  0x08, 0xC0, 0xE0, 0x37, 0x60, 0x6F, 0xB0, 0x47, 0x71, 0x08, 0xF9, 0x06, 0x77, 0x30, 0xBE, 0x09,
  0x77, 0x40, 0x20, 0xEC, 0x0D, 0x80, 0x9E, 0x70, 0x87, 0x13, 0x56, 0x77, 0x65, 0x37, 0x78, 0x12,
  0x8C, 0xFB, 0x81, 0xC7, 0x27, 0x10, 0x30, 0xBF, 0xFA, 0x0B, 0x01, 0x50, 0x7F, 0xFC, 0x0E, 0x50,
  0xAF, 0xB0, 0x0E, 0xF0, 0x94, 0x08, 0xF8, 0x19, 0x51, 0x48, 0x22, 0x59, 0xEA, 0x04, 0x30, 0x4E,
  0x0A, 0x01, 0x74, 0x07, 0x0D, 0x40, 0xDD, 0x08, 0x77, 0x40, 0x5D, 0x0B, 0x77, 0x50, 0xCD, 0x02,
  0x77, 0x40, 0x1D, 0x0A, 0x77, 0x50, 0x5D, 0x05, 0x77, 0x50, 0x8D, 0x01, 0x77, 0x50, 0xAC, 0x0E,
  0x77, 0x60, 0xCC, 0x0B, 0x77, 0x60, 0xCC, 0x0B, 0x77, 0x60, 0xDC, 0x0A, 0x77, 0x60, 0xDC, 0x0A,
  0x77, 0x60, 0xDC, 0x0A, 0x77, 0x60, 0xCC, 0x0B, 0x77, 0x60, 0xBC, 0x0D, 0x77, 0x60, 0x9D, 0x77,
  0x60, 0x6D, 0x03, 0x77, 0x50, 0x3D, 0x09, 0x77, 0x60, 0xEC, 0x0E, 0x77, 0x60, 0x8D, 0x09, 0x77,
  0x50, 0x2E, 0x06, 0x77, 0x50, 0x9E, 0x09, 0x01, 0x75, 0x04, 0x09, 0x40, 0xDE, 0x82, 0xE9, 0x51,
  0x48, 0x51, 0x36, 0xAE, 0xFE, 0x40, 0x10, 0xDF, 0xB0, 0x0E, 0xF0, 0xE5, 0x01, 0x0A, 0xFF, 0xC0,
  0xE7, 0x06, 0x0D, 0xFF, 0xA0, 0xD7, 0x28, 0x15, 0xAE, 0xFB, 0x81, 0xC9, 0x47, 0x68, 0x72, 0x45,
  0x67, 0x66, 0x42, 0x60,
  // "Ď" (U+010E)
  0x28, 0x31, 0x77, 0x76, 0x75, 0x83, 0x67, 0x77, 0x17, 0x10, 0x10, 0xDB, 0x0B, 0x01, 0x71, 0x02,
  0x0C, 0xB0, 0xD0, 0x17, 0x20, 0x20, 0xEB, 0x0D, 0x03, 0x60, 0x40, 0xEB, 0x0D, 0x02, 0x74, 0x03,
  0x0E, 0xC0, 0x44, 0x06, 0xC0, 0xD0, 0x27, 0x60, 0x3D, 0x05, 0x20, 0x7C, 0x0E, 0x02, 0x77, 0x10,
  0x5D, 0x05, 0x08, 0xC0, 0xE0, 0x37, 0x73, 0x06, 0xFB, 0x04, 0x77, 0x50, 0x8F, 0x90, 0x67, 0x77,
  0x0B, 0xE0, 0x97, 0x77, 0x10, 0x20, 0xEC, 0x0D, 0x80, 0xAC, 0x00, 0x0C, 0xFB, 0x84, 0xED, 0xC9,
  0x73, 0x76, 0x0C, 0xFF, 0xA8, 0x1D, 0x81, 0x73, 0x0C, 0xFF, 0xD0, 0x87, 0x20, 0xCF, 0xFE, 0x0D,
  0x03, 0x70, 0xCC, 0x0B, 0x80, 0x16, 0x81, 0x79, 0xBF, 0xA0, 0x46, 0x0C, 0xC0, 0x97, 0x20, 0x50,
  0xCF, 0x04, 0x50, 0xCC, 0x09, 0x74, 0x05, 0x0E, 0xD0, 0xE0, 0x24, 0x0C, 0xC0, 0x97, 0x50, 0x10,
  0xCD, 0x0C, 0x40, 0xCC, 0x09, 0x76, 0x01, 0x0D, 0xD0, 0x63, 0x0C, 0xC0, 0x97, 0x70, 0x20, 0xEC,
  0x0E, 0x30, 0xCC, 0x09, 0x77, 0x10, 0x7D, 0x06, 0x20, 0xCC, 0x09, 0x77, 0x20, 0xEC, 0x0C, 0x20,
  0xCC, 0x09, 0x77, 0x20, 0x8D, 0x81, 0x20, 0xCC, 0x09, 0x77, 0x20, 0x3D, 0x81, 0x60, 0xCC, 0x09,
  0x77, 0x30, 0xEC, 0x81, 0xA0, 0xCC, 0x09, 0x77, 0x30, 0xBC, 0x81, 0xC0, 0xCC, 0x09, 0x77, 0x30,
  0x8D, 0x10, 0xCC, 0x09, 0x77, 0x30, 0x6D, 0x01, 0x0C, 0xC0, 0x97, 0x73, 0x05, 0xD0, 0x20, 0xCC,
  0x09, 0x77, 0x30, 0x4D, 0x03, 0x0C, 0xC0, 0x97, 0x73, 0x03, 0xD0, 0x40, 0xCC, 0x09, 0x77, 0x30,
  0x3D, 0x04, 0x0C, 0xC0, 0x97, 0x73, 0x03, 0xD0, 0x30, 0xCC, 0x09, 0x77, 0x30, 0x4D, 0x03, 0x0C,
  0xC0, 0x97, 0x73, 0x05, 0xD0, 0x20, 0xCC, 0x09, 0x77, 0x30, 0x7D, 0x10, 0xCC, 0x09, 0x77, 0x30,
  0xAC, 0x81, 0xE0, 0xCC, 0x09, 0x77, 0x30, 0xDC, 0x81, 0xB0, 0xCC, 0x09, 0x77, 0x20, 0x1D, 0x81,
  0x80, 0xCC, 0x09, 0x77, 0x20, 0x5D, 0x81, 0x40, 0xCC, 0x09, 0x77, 0x20, 0xBD, 0x20, 0xCC, 0x09,
  0x77, 0x10, 0x2D, 0x0A, 0x20, 0xCC, 0x09, 0x77, 0x10, 0xBD, 0x04, 0x20, 0xCC, 0x09, 0x77, 0x05,
  0xD0, 0xC3, 0x0C, 0xC0, 0x97, 0x60, 0x30, 0xED, 0x04, 0x30, 0xCC, 0x09, 0x75, 0x03, 0x0E, 0xD0,
  0x94, 0x0C, 0xC0, 0x97, 0x40, 0x8E, 0x0C, 0x50, 0xCC, 0x09, 0x71, 0x81, 0x28, 0xEE, 0x0D, 0x02,
  0x50, 0xCC, 0x87, 0xB6, 0x66, 0x67, 0x8A, 0xEF, 0x90, 0xD0, 0x16, 0x0C, 0xFF, 0xE0, 0xA7, 0x10,
  0xCF, 0xFC, 0x0D, 0x04, 0x72, 0x0C, 0xFF, 0xA0, 0xA0, 0x47, 0x40, 0xCF, 0xA8, 0x4E, 0xEC, 0xA8,
  0x47, 0x70,
  // "ď" (U+010F)
  0x77, 0x70, 0x8C, 0x0C, 0x40, 0xBC, 0x07, 0x77, 0x70, 0x8C, 0x0C, 0x40, 0xDC, 0x03, 0x77, 0x70,
  0x8C, 0x0C, 0x30, 0x1C, 0x0D, 0x77, 0x71, 0x08, 0xC0, 0xC3, 0x03, 0xC0, 0x87, 0x77, 0x10, 0x8C,
  0x0C, 0x30, 0x7C, 0x01, 0x77, 0x71, 0x08, 0xC0, 0xC3, 0x0A, 0xB0, 0x97, 0x77, 0x20, 0x8C, 0x0C,
  0x30, 0xDB, 0x02, 0x77, 0x72, 0x08, 0xC0, 0xC2, 0x02, 0xB0, 0xA7, 0x77, 0x30, 0x8C, 0x0C, 0x20,
  0x6B, 0x02, 0x77, 0x73, 0x08, 0xC0, 0xC2, 0x0A, 0xA0, 0x77, 0x77, 0x40, 0x8C, 0x0C, 0x77, 0x77,
  0x30, 0x8C, 0x0C, 0x77, 0x77, 0x30, 0x8C, 0x0C, 0x77, 0x58, 0x51, 0x46, 0x77, 0x63, 0x50, 0x8C,
  0x0C, 0x77, 0x30, 0x50, 0xBF, 0x81, 0xE9, 0x12, 0x07, 0xC0, 0xC7, 0x71, 0x02, 0x0C, 0xFC, 0x82,
  0xD2, 0x06, 0xC0, 0xC7, 0x70, 0x20, 0xEF, 0xE8, 0x1E, 0x25, 0xC0, 0xC7, 0x60, 0x10, 0xDF, 0x90,
  0x0E, 0xD0, 0xC0, 0x4C, 0x0C, 0x76, 0x0A, 0xE8, 0x1C, 0x51, 0x28, 0x11, 0x5D, 0xB0, 0xCC, 0x0C,
  0x75, 0x03, 0xE0, 0x87, 0x10, 0xAF, 0x0C, 0x75, 0x0A, 0xD0, 0x97, 0x30, 0xCE, 0x0C, 0x74, 0x01,
  0xD0, 0xE7, 0x40, 0x3E, 0x0C, 0x74, 0x06, 0xD0, 0x77, 0x50, 0xBD, 0x0C, 0x74, 0x09, 0xD0, 0x17,
  0x50, 0x6D, 0x0C, 0x74, 0x0C, 0xC0, 0xC7, 0x60, 0x2D, 0x0C, 0x74, 0xD0, 0x97, 0x70, 0xEC, 0x0C,
  0x73, 0x01, 0xD0, 0x77, 0x70, 0xCC, 0x0C, 0x73, 0x02, 0xD0, 0x57, 0x70, 0xAC, 0x0C, 0x73, 0x03,
  0xD0, 0x47, 0x70, 0x9C, 0x0C, 0x73, 0x04, 0xD0, 0x37, 0x70, 0x9C, 0x0C, 0x73, 0x04, 0xD0, 0x37,
  0x70, 0x8C, 0x0C, 0x73, 0x03, 0xD0, 0x47, 0x70, 0x8C, 0x0C, 0x73, 0x03, 0xD0, 0x47, 0x70, 0x9C,
  0x0C, 0x73, 0x01, 0xD0, 0x67, 0x70, 0xAC, 0x0C, 0x74, 0xD0, 0x87, 0x70, 0xCC, 0x0C, 0x74, 0x0D,
  0xC0, 0xA7, 0x7D, 0x0C, 0x74, 0x09, 0xC0, 0xE7, 0x60, 0x4D, 0x0C, 0x74, 0x06, 0xD0, 0x47, 0x50,
  0x9D, 0x0C, 0x74, 0x01, 0xD0, 0xB7, 0x40, 0x2E, 0x0C, 0x75, 0x0B, 0xD0, 0x57, 0x30, 0xBE, 0x0C,
  0x75, 0x03, 0xD0, 0xE0, 0x47, 0x10, 0x9F, 0x0C, 0x76, 0x0A, 0xE0, 0x90, 0x33, 0x81, 0x16, 0xDB,
  0x0C, 0xC0, 0xC7, 0x60, 0x10, 0xDF, 0x90, 0xEE, 0x0C, 0x02, 0xC0, 0xC7, 0x70, 0x20, 0xDF, 0xE0,
  0xD0, 0x11, 0xC0, 0xC7, 0x71, 0x01, 0x0B, 0xFC, 0x0C, 0x01, 0x20, 0xDB, 0x0C, 0x77, 0x30, 0x40,
  0xBF, 0x0D, 0x07, 0x40, 0xBB, 0x0C, 0x77, 0x58, 0x51, 0x46, 0x77, 0x52, 0x77, 0x70,
  // "Đ" (U+0110)
  0x40, 0x3F, 0xC8, 0x4E, 0xDB, 0x85, 0x17, 0x72, 0x03, 0xFF, 0xB0, 0xB0, 0x57, 0x70, 0x3F, 0xFD,
  0x0D, 0x04, 0x75, 0x03, 0xFF, 0xF0, 0x97, 0x40, 0x3D, 0x08, 0x80, 0x16, 0x81, 0x8A, 0xDF, 0x90,
  0xC0, 0x17, 0x20, 0x3D, 0x03, 0x71, 0x81, 0x28, 0xEE, 0x0C, 0x72, 0x03, 0xD0, 0x37, 0x30, 0x10,
  0x9E, 0x0A, 0x71, 0x03, 0xD0, 0x37, 0x50, 0x5E, 0x06, 0x70, 0x3D, 0x03, 0x76, 0x05, 0xD0, 0xE0,
  0x16, 0x03, 0xD0, 0x37, 0x70, 0x8D, 0x08, 0x60, 0x3D, 0x03, 0x77, 0x10, 0xDC, 0x0E, 0x60, 0x3D,
  0x03, 0x77, 0x10, 0x5D, 0x06, 0x50, 0x3D, 0x03, 0x77, 0x20, 0xEC, 0x0B, 0x50, 0x3D, 0x03, 0x77,
  0x20, 0x9D, 0x50, 0x3D, 0x03, 0x77, 0x20, 0x5D, 0x04, 0x40, 0x3D, 0x03, 0x77, 0x20, 0x2D, 0x06,
  0x40, 0x3D, 0x03, 0x77, 0x30, 0xEC, 0x09, 0x40, 0x3D, 0x03, 0x77, 0x30, 0xCC, 0x0B, 0x40, 0x3D,
  0x03, 0x77, 0x30, 0xBC, 0x84, 0xC6, 0x66, 0x68, 0xD0, 0x88, 0x02, 0x60, 0x37, 0x30, 0xAC, 0x0C,
  0xFF, 0xB0, 0x87, 0x30, 0xAC, 0x0D, 0xFF, 0xB0, 0x87, 0x30, 0x9C, 0x0D, 0xFF, 0xB0, 0x87, 0x30,
  0xAC, 0x0D, 0xFF, 0xB0, 0x87, 0x30, 0xAC, 0x0C, 0x40, 0x3D, 0x03, 0x77, 0x30, 0xCC, 0x0B, 0x40,
  0x3D, 0x03, 0x77, 0x30, 0xDC, 0x0A, 0x40, 0x3D, 0x03, 0x77, 0x3D, 0x08, 0x40, 0x3D, 0x03, 0x77,
  0x20, 0x3D, 0x05, 0x40, 0x3D, 0x03, 0x77, 0x20, 0x7D, 0x02, 0x40, 0x3D, 0x03, 0x77, 0x20, 0xCC,
  0x0D, 0x50, 0x3D, 0x03, 0x77, 0x10, 0x2D, 0x09, 0x50, 0x3D, 0x03, 0x77, 0x10, 0x8D, 0x04, 0x50,
  0x3D, 0x03, 0x77, 0x02, 0xD0, 0xD6, 0x03, 0xD0, 0x37, 0x70, 0xBD, 0x06, 0x60, 0x3D, 0x03, 0x76,
  0x08, 0xD0, 0xD7, 0x03, 0xD0, 0x37, 0x50, 0x8E, 0x03, 0x70, 0x3D, 0x03, 0x73, 0x02, 0x0B, 0xE0,
  0x77, 0x10, 0x3D, 0x03, 0x71, 0x04, 0x0A, 0xF0, 0x97, 0x20, 0x3D, 0x86, 0x86, 0x66, 0x67, 0x9C,
  0xFA, 0x08, 0x73, 0x03, 0xFF, 0xE0, 0xE0, 0x57, 0x40, 0x3F, 0xFD, 0x09, 0x01, 0x75, 0x03, 0xFF,
  0xA8, 0x1D, 0x82, 0x77, 0x03, 0xFB, 0x84, 0xED, 0xB9, 0x63, 0x76,
  // "đ" (U+0111)
  0x77, 0x71, 0x02, 0xD0, 0x37, 0x77, 0x50, 0x2D, 0x03, 0x77, 0x75, 0x02, 0xD0, 0x37, 0x77, 0x50,
  0x2D, 0x03, 0x77, 0x75, 0x02, 0xD0, 0x37, 0x72, 0x0B, 0xFF, 0xE7, 0x50, 0xBF, 0xFE, 0x75, 0x0B,
  0xFF, 0xE7, 0x50, 0xBF, 0xFE, 0x75, 0x04, 0x80, 0x56, 0x07, 0xD0, 0x88, 0x00, 0x67, 0x77, 0x10,
  0x2D, 0x03, 0x77, 0x75, 0x02, 0xD0, 0x37, 0x77, 0x50, 0x2D, 0x03, 0x77, 0x75, 0x02, 0xD0, 0x37,
  0x58, 0x32, 0x6A, 0xCE, 0xA8, 0x2E, 0xB7, 0x23, 0x01, 0xD0, 0x37, 0x30, 0x30, 0xBF, 0xC0, 0x82,
  0x01, 0xD0, 0x37, 0x20, 0x8F, 0xF0, 0xC0, 0x11, 0xD0, 0x37, 0x10, 0xAF, 0xFA, 0x81, 0xC0, 0xEC,
  0x03, 0x70, 0x8F, 0x85, 0xEA, 0x86, 0x79, 0xDC, 0x08, 0x0D, 0xC0, 0x36, 0x03, 0xE0, 0xE0, 0x67,
  0x04, 0x0E, 0xF9, 0x03, 0x60, 0xCD, 0x0D, 0x01, 0x72, 0x01, 0x0D, 0xF0, 0x35, 0x03, 0xD0, 0xE0,
  0x27, 0x40, 0x3F, 0x03, 0x50, 0x9D, 0x07, 0x76, 0x09, 0xE0, 0x35, 0x0E, 0xC0, 0xE7, 0x70, 0x2E,
  0x03, 0x40, 0x1D, 0x09, 0x77, 0x10, 0xDD, 0x03, 0x40, 0x4D, 0x05, 0x77, 0x10, 0xAD, 0x03, 0x40,
  0x7D, 0x02, 0x77, 0x10, 0x7D, 0x03, 0x40, 0x8D, 0x77, 0x20, 0x4D, 0x03, 0x40, 0x9C, 0x0E, 0x77,
  0x20, 0x3D, 0x03, 0x40, 0xAC, 0x0D, 0x77, 0x20, 0x2D, 0x03, 0x40, 0xAC, 0x0C, 0x77, 0x20, 0x2D,
  0x03, 0x40, 0xAC, 0x0D, 0x77, 0x20, 0x2D, 0x03, 0x40, 0x9C, 0x0E, 0x77, 0x20, 0x3D, 0x03, 0x40,
  0x8D, 0x77, 0x20, 0x4D, 0x03, 0x40, 0x6D, 0x02, 0x77, 0x10, 0x6D, 0x03, 0x40, 0x3D, 0x05, 0x77,
  0x10, 0x9D, 0x03, 0x5D, 0x0A, 0x77, 0x10, 0xDD, 0x03, 0x50, 0xBC, 0x0E, 0x77, 0x04, 0xE0, 0x35,
  0x06, 0xD0, 0x87, 0x60, 0xCE, 0x03, 0x60, 0xED, 0x04, 0x74, 0x07, 0xF0, 0x36, 0x07, 0xD0, 0xE0,
  0x57, 0x20, 0x7F, 0x90, 0x37, 0x0C, 0xE8, 0x1B, 0x51, 0x38, 0x11, 0x6C, 0xB0, 0x0E, 0xC0, 0x37,
  0x02, 0x0D, 0xFA, 0x0E, 0xF0, 0x30, 0xBC, 0x03, 0x71, 0x01, 0x0D, 0xFF, 0x98, 0x15, 0x09, 0xC0,
  0x37, 0x20, 0x10, 0x9F, 0xD0, 0xE0, 0x32, 0x06, 0xC0, 0x37, 0x48, 0x12, 0x9E, 0xF8, 0x1E, 0x81,
  0x30, 0x4C, 0x03, 0x77, 0x85, 0x35, 0x67, 0x75, 0x37, 0x72,
  // "Ē" (U+0112)
  0x40, 0x58, 0x09, 0x46, 0x05, 0x71, 0x0D, 0xFF, 0xA0, 0xE7, 0x10, 0xDF, 0xFA, 0x0E, 0x71, 0x0D,
  0xFF, 0xA0, 0xE7, 0x10, 0xDF, 0xFA, 0x0E, 0x80, 0xA8, 0x20, 0x04, 0xFF, 0xFB, 0x0E, 0x04, 0xFF,
  0xFB, 0x0E, 0x04, 0xFF, 0xFB, 0x0E, 0x04, 0xFF, 0xFB, 0x0E, 0x04, 0xD0, 0x78, 0x09, 0x66, 0x05,
  0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75,
  0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75,
  0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75,
  0x04, 0xD0, 0x17, 0x75, 0x04, 0xFF, 0xFA, 0x81, 0xB0, 0x4F, 0xFF, 0xA8, 0x1B, 0x04, 0xFF, 0xFA,
  0x81, 0xB0, 0x4F, 0xFF, 0xA8, 0x1B, 0x04, 0xD0, 0x78, 0x09, 0x56, 0x81, 0x40, 0x4D, 0x01, 0x77,
  0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77,
  0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77,
  0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77,
  0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x07, 0x80, 0x96, 0x60, 0x50, 0x4F,
  0xFF, 0xB0, 0xE0, 0x4F, 0xFF, 0xB0, 0xE0, 0x4F, 0xFF, 0xB0, 0xE0, 0x4F, 0xFF, 0xB0, 0xE0,
  // "ē" (U+0113)
  0x60, 0x58, 0x09, 0x46, 0x05, 0x75, 0x0D, 0xFF, 0xA0, 0xE7, 0x50, 0xDF, 0xFA, 0x0E, 0x75, 0x0D,
  0xFF, 0xA0, 0xE7, 0x50, 0xDF, 0xFA, 0x0E, 0x80, 0xA8, 0x60, 0x86, 0x25, 0x67, 0x65, 0x41, 0x77,
  0x58, 0x14, 0xAE, 0xF9, 0x0B, 0x06, 0x77, 0x10, 0x40, 0xCF, 0xE0, 0xD0, 0x57, 0x50, 0x9F, 0xFB,
  0x09, 0x73, 0x0B, 0xFA, 0x00, 0xEF, 0x90, 0xA7, 0x10, 0xAE, 0x81, 0xC6, 0x24, 0x04, 0x09, 0xE0,
  0x76, 0x06, 0xD0, 0xE0, 0x57, 0x20, 0x30, 0xDD, 0x03, 0x40, 0x10, 0xEC, 0x0E, 0x02, 0x74, 0x02,
  0x0E, 0xC0, 0xA4, 0x09, 0xD0, 0x47, 0x60, 0x5D, 0x02, 0x20, 0x1D, 0x09, 0x77, 0x10, 0xDC, 0x08,
  0x20, 0x6D, 0x01, 0x77, 0x10, 0x8C, 0x0B, 0x20, 0xBC, 0x0B, 0x77, 0x20, 0x4D, 0x20, 0xEC, 0x06,
  0x77, 0x20, 0x1D, 0x02, 0x01, 0xD0, 0x88, 0x09, 0x56, 0xD0, 0x04, 0xFF, 0xFF, 0x00, 0x5F, 0xFF,
  0xF0, 0x60, 0x5F, 0xFF, 0xF0, 0x06, 0xFF, 0xFF, 0x06, 0x05, 0xD0, 0x17, 0x77, 0x20, 0x4D, 0x02,
  0x77, 0x72, 0x02, 0xD0, 0x47, 0x77, 0x3D, 0x07, 0x77, 0x73, 0x0C, 0xC0, 0xB7, 0x77, 0x30, 0x7D,
  0x02, 0x77, 0x72, 0x02, 0xD0, 0x97, 0x77, 0x30, 0xAD, 0x04, 0x77, 0x72, 0x02, 0xD0, 0xE0, 0x47,
  0x73, 0x04, 0x50, 0x7E, 0x08, 0x01, 0x75, 0x82, 0x27, 0xDE, 0x60, 0xAE, 0x82, 0xEA, 0x52, 0x58,
  0x22, 0x58, 0xCB, 0x0E, 0x70, 0xAF, 0xB0, 0x0E, 0xFA, 0x0E, 0x71, 0x07, 0xFF, 0xE0, 0xE7, 0x20,
  0x20, 0xAF, 0xFB, 0x0C, 0x06, 0x74, 0x81, 0x17, 0xCF, 0xB8, 0x2E, 0xA7, 0x27, 0x73, 0x87, 0x35,
  0x67, 0x76, 0x54, 0x17, 0x10,
  // "Ĕ" (U+0114)
  0x30, 0x3B, 0x06, 0x73, 0x05, 0xB0, 0x46, 0x01, 0xB0, 0xD7, 0x30, 0xCB, 0x02, 0x70, 0xDB, 0x0B,
  0x02, 0x60, 0x10, 0xAB, 0x0D, 0x71, 0x06, 0xD8, 0x4B, 0x86, 0x78, 0xBD, 0x07, 0x72, 0x0C, 0xFF,
  0x0D, 0x73, 0x01, 0x0D, 0xFD, 0x0D, 0x01, 0x74, 0x01, 0x0A, 0xFB, 0x0A, 0x01, 0x77, 0x89, 0x03,
  0x8C, 0xEF, 0xED, 0xB7, 0x28, 0x0A, 0x86, 0x00, 0x4F, 0xFF, 0xB0, 0xE0, 0x4F, 0xFF, 0xB0, 0xE0,
  0x4F, 0xFF, 0xB0, 0xE0, 0x4F, 0xFF, 0xB0, 0xE0, 0x4D, 0x07, 0x80, 0x96, 0x60, 0x50, 0x4D, 0x01,
  0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01,
  0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01,
  0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01,
  0x77, 0x50, 0x4F, 0xFF, 0xA8, 0x1B, 0x04, 0xFF, 0xFA, 0x81, 0xB0, 0x4F, 0xFF, 0xA8, 0x1B, 0x04,
  0xFF, 0xFA, 0x81, 0xB0, 0x4D, 0x07, 0x80, 0x95, 0x68, 0x14, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0,
  0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0,
  0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0,
  0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0,
  0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x78, 0x09, 0x66, 0x05, 0x04, 0xFF, 0xFB, 0x0E,
  0x04, 0xFF, 0xFB, 0x0E, 0x04, 0xFF, 0xFB, 0x0E, 0x04, 0xFF, 0xFB, 0x0E,
  // "ĕ" (U+0115)
  0x50, 0x3B, 0x06, 0x73, 0x05, 0xB0, 0x47, 0x30, 0x1B, 0x0D, 0x73, 0x0C, 0xB0, 0x27, 0x40, 0xDB,
  0x0B, 0x02, 0x60, 0x10, 0xAB, 0x0D, 0x75, 0x06, 0xD8, 0x4B, 0x86, 0x78, 0xBD, 0x07, 0x76, 0x0C,
  0xFF, 0x0D, 0x77, 0x01, 0x0D, 0xFD, 0x0D, 0x01, 0x77, 0x10, 0x10, 0xAF, 0xB0, 0xA0, 0x17, 0x74,
  0x89, 0x03, 0x8C, 0xEF, 0xED, 0xB7, 0x28, 0x0A, 0x92, 0x08, 0x62, 0x56, 0x76, 0x54, 0x17, 0x75,
  0x81, 0x4A, 0xEF, 0x90, 0xB0, 0x67, 0x71, 0x04, 0x0C, 0xFE, 0x0D, 0x05, 0x75, 0x09, 0xFF, 0xB0,
  0x97, 0x30, 0xBF, 0xA0, 0x0E, 0xF9, 0x0A, 0x71, 0x0A, 0xE8, 0x1C, 0x62, 0x40, 0x40, 0x9E, 0x07,
  0x60, 0x6D, 0x0E, 0x05, 0x72, 0x03, 0x0D, 0xD0, 0x34, 0x01, 0x0E, 0xC0, 0xE0, 0x27, 0x40, 0x20,
  0xEC, 0x0A, 0x40, 0x9D, 0x04, 0x76, 0x05, 0xD0, 0x22, 0x01, 0xD0, 0x97, 0x71, 0x0D, 0xC0, 0x82,
  0x06, 0xD0, 0x17, 0x71, 0x08, 0xC0, 0xB2, 0x0B, 0xC0, 0xB7, 0x72, 0x04, 0xD2, 0x0E, 0xC0, 0x67,
  0x72, 0x01, 0xD0, 0x20, 0x1D, 0x08, 0x80, 0x95, 0x6D, 0x00, 0x4F, 0xFF, 0xF0, 0x05, 0xFF, 0xFF,
  0x06, 0x05, 0xFF, 0xFF, 0x00, 0x6F, 0xFF, 0xF0, 0x60, 0x5D, 0x01, 0x77, 0x72, 0x04, 0xD0, 0x27,
  0x77, 0x20, 0x2D, 0x04, 0x77, 0x73, 0xD0, 0x77, 0x77, 0x30, 0xCC, 0x0B, 0x77, 0x73, 0x07, 0xD0,
  0x27, 0x77, 0x20, 0x2D, 0x09, 0x77, 0x73, 0x0A, 0xD0, 0x47, 0x77, 0x20, 0x2D, 0x0E, 0x04, 0x77,
  0x30, 0x45, 0x07, 0xE0, 0x80, 0x17, 0x58, 0x22, 0x7D, 0xE6, 0x0A, 0xE8, 0x2E, 0xA5, 0x25, 0x82,
  0x25, 0x8C, 0xB0, 0xE7, 0x0A, 0xFB, 0x00, 0xEF, 0xA0, 0xE7, 0x10, 0x7F, 0xFE, 0x0E, 0x72, 0x02,
  0x0A, 0xFF, 0xB0, 0xC0, 0x67, 0x48, 0x11, 0x7C, 0xFB, 0x82, 0xEA, 0x72, 0x77, 0x38, 0x73, 0x56,
  0x77, 0x65, 0x41, 0x71,
  // "Ė" (U+0116)
  0x73, 0x84, 0x2A, 0xEE, 0xA2, 0x77, 0x50, 0x20, 0xEC, 0x0E, 0x02, 0x77, 0x40, 0x8E, 0x08, 0x77,
  0x40, 0xBE, 0x0B, 0x77, 0x40, 0xBE, 0x0B, 0x77, 0x40, 0x8E, 0x08, 0x77, 0x40, 0x20, 0xEC, 0x0E,
  0x02, 0x77, 0x58, 0x42, 0xAE, 0xEA, 0x28, 0x0A, 0xC2, 0x00, 0x4F, 0xFF, 0xB0, 0xE0, 0x4F, 0xFF,
  0xB0, 0xE0, 0x4F, 0xFF, 0xB0, 0xE0, 0x4F, 0xFF, 0xB0, 0xE0, 0x4D, 0x07, 0x80, 0x96, 0x60, 0x50,
  0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50,
  0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50,
  0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50,
  0x4D, 0x01, 0x77, 0x50, 0x4F, 0xFF, 0xA8, 0x1B, 0x04, 0xFF, 0xFA, 0x81, 0xB0, 0x4F, 0xFF, 0xA8,
  0x1B, 0x04, 0xFF, 0xFA, 0x81, 0xB0, 0x4D, 0x07, 0x80, 0x95, 0x68, 0x14, 0x04, 0xD0, 0x17, 0x75,
  0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75,
  0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75,
  0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75,
  0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x78, 0x09, 0x66, 0x05, 0x04, 0xFF,
  0xFB, 0x0E, 0x04, 0xFF, 0xFB, 0x0E, 0x04, 0xFF, 0xFB, 0x0E, 0x04, 0xFF, 0xFB, 0x0E,
  // "ė" (U+0117)
  0x75, 0x84, 0x2A, 0xEE, 0xA2, 0x77, 0x72, 0x02, 0x0E, 0xC0, 0xE0, 0x27, 0x77, 0x10, 0x8E, 0x08,
  0x77, 0x71, 0x0B, 0xE0, 0xB7, 0x77, 0x10, 0xBE, 0x0B, 0x77, 0x71, 0x08, 0xE0, 0x87, 0x77, 0x10,
  0x20, 0xEC, 0x0E, 0x02, 0x77, 0x72, 0x84, 0x2A, 0xEE, 0xA2, 0x80, 0xAD, 0x20, 0x86, 0x25, 0x67,
  0x65, 0x41, 0x77, 0x58, 0x14, 0xAE, 0xF9, 0x0B, 0x06, 0x77, 0x10, 0x40, 0xCF, 0xE0, 0xD0, 0x57,
  0x50, 0x9F, 0xFB, 0x09, 0x73, 0x0B, 0xFA, 0x00, 0xEF, 0x90, 0xA7, 0x10, 0xAE, 0x81, 0xC6, 0x24,
  0x04, 0x09, 0xE0, 0x76, 0x06, 0xD0, 0xE0, 0x57, 0x20, 0x30, 0xDD, 0x03, 0x40, 0x10, 0xEC, 0x0E,
  0x02, 0x74, 0x02, 0x0E, 0xC0, 0xA4, 0x09, 0xD0, 0x47, 0x60, 0x5D, 0x02, 0x20, 0x1D, 0x09, 0x77,
  0x10, 0xDC, 0x08, 0x20, 0x6D, 0x01, 0x77, 0x10, 0x8C, 0x0B, 0x20, 0xBC, 0x0B, 0x77, 0x20, 0x4D,
  0x20, 0xEC, 0x06, 0x77, 0x20, 0x1D, 0x02, 0x01, 0xD0, 0x88, 0x09, 0x56, 0xD0, 0x04, 0xFF, 0xFF,
  0x00, 0x5F, 0xFF, 0xF0, 0x60, 0x5F, 0xFF, 0xF0, 0x06, 0xFF, 0xFF, 0x06, 0x05, 0xD0, 0x17, 0x77,
  0x20, 0x4D, 0x02, 0x77, 0x72, 0x02, 0xD0, 0x47, 0x77, 0x3D, 0x07, 0x77, 0x73, 0x0C, 0xC0, 0xB7,
  0x77, 0x30, 0x7D, 0x02, 0x77, 0x72, 0x02, 0xD0, 0x97, 0x77, 0x30, 0xAD, 0x04, 0x77, 0x72, 0x02,
  0xD0, 0xE0, 0x47, 0x73, 0x04, 0x50, 0x7E, 0x08, 0x01, 0x75, 0x82, 0x27, 0xDE, 0x60, 0xAE, 0x82,
  0xEA, 0x52, 0x58, 0x22, 0x58, 0xCB, 0x0E, 0x70, 0xAF, 0xB0, 0x0E, 0xFA, 0x0E, 0x71, 0x07, 0xFF,
  0xE0, 0xE7, 0x20, 0x20, 0xAF, 0xFB, 0x0C, 0x06, 0x74, 0x81, 0x17, 0xCF, 0xB8, 0x2E, 0xA7, 0x27,
  0x73, 0x87, 0x35, 0x67, 0x76, 0x54, 0x17, 0x10,
  // "Ę" (U+0118)
  0x04, 0xFF, 0xFB, 0x0E, 0x04, 0xFF, 0xFB, 0x0E, 0x04, 0xFF, 0xFB, 0x0E, 0x04, 0xFF, 0xFB, 0x0E,
  0x04, 0xD0, 0x78, 0x09, 0x66, 0x05, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0,
  0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0,
  0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0,
  0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xFF, 0xFA, 0x81, 0xB0, 0x4F,
  0xFF, 0xA8, 0x1B, 0x04, 0xFF, 0xFA, 0x81, 0xB0, 0x4F, 0xFF, 0xA8, 0x1B, 0x04, 0xD0, 0x78, 0x09,
  0x56, 0x81, 0x40, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D,
  0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D,
  0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D,
  0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D,
  0x07, 0x80, 0x96, 0x60, 0x50, 0x4F, 0xFF, 0xB0, 0xE0, 0x4F, 0xFF, 0xB0, 0xE0, 0x4F, 0xFF, 0xB0,
  0xE0, 0x4F, 0xFF, 0xB0, 0xE7, 0x73, 0x08, 0xB0, 0x77, 0x76, 0x06, 0xB0, 0x97, 0x76, 0x02, 0xB0,
  0xC7, 0x77, 0x0B, 0xB0, 0x37, 0x76, 0x02, 0xB0, 0xD7, 0x77, 0x07, 0xB0, 0x97, 0x77, 0x09, 0xB0,
  0x97, 0x77, 0x0B, 0xB0, 0xC7, 0x77, 0x09, 0xC0, 0x90, 0x22, 0x03, 0x77, 0x20, 0x6F, 0xA0, 0x27,
  0x72, 0x0D, 0xF9, 0x02, 0x77, 0x20, 0x30, 0xEF, 0x02, 0x77, 0x38, 0x71, 0x8C, 0xEF, 0xEC, 0x81,
  0x10,
  // "ę" (U+0119)
  0x75, 0x86, 0x25, 0x67, 0x65, 0x41, 0x77, 0x58, 0x14, 0xAE, 0xF9, 0x0B, 0x06, 0x77, 0x10, 0x40,
  0xCF, 0xE0, 0xD0, 0x57, 0x50, 0x9F, 0xFB, 0x09, 0x73, 0x0B, 0xFA, 0x00, 0xEF, 0x90, 0xA7, 0x10,
  0xAE, 0x81, 0xC6, 0x24, 0x04, 0x09, 0xE0, 0x76, 0x06, 0xD0, 0xE0, 0x57, 0x20, 0x30, 0xDD, 0x03,
  0x40, 0x10, 0xEC, 0x0E, 0x02, 0x74, 0x02, 0x0E, 0xC0, 0xA4, 0x09, 0xD0, 0x47, 0x60, 0x5D, 0x02,
  0x20, 0x1D, 0x09, 0x77, 0x10, 0xDC, 0x08, 0x20, 0x6D, 0x01, 0x77, 0x10, 0x8C, 0x0B, 0x20, 0xBC,
  0x0B, 0x77, 0x20, 0x4D, 0x20, 0xEC, 0x06, 0x77, 0x20, 0x1D, 0x02, 0x01, 0xD0, 0x88, 0x09, 0x56,
  0xD0, 0x04, 0xFF, 0xFF, 0x00, 0x5F, 0xFF, 0xF0, 0x60, 0x5F, 0xFF, 0xF0, 0x06, 0xFF, 0xFF, 0x06,
  0x05, 0xD0, 0x17, 0x77, 0x20, 0x4D, 0x02, 0x77, 0x72, 0x02, 0xD0, 0x47, 0x77, 0x3D, 0x07, 0x77,
  0x73, 0x0C, 0xC0, 0xB7, 0x77, 0x30, 0x7D, 0x02, 0x77, 0x72, 0x02, 0xD0, 0x97, 0x77, 0x30, 0xAD,
  0x04, 0x77, 0x72, 0x02, 0xD0, 0xE0, 0x47, 0x73, 0x04, 0x50, 0x7E, 0x08, 0x01, 0x75, 0x82, 0x27,
  0xDE, 0x60, 0xAE, 0x82, 0xEA, 0x52, 0x58, 0x22, 0x58, 0xCB, 0x0E, 0x70, 0xAF, 0xB0, 0x0E, 0xFA,
  0x0E, 0x71, 0x07, 0xFF, 0xE0, 0xE7, 0x20, 0x20, 0xAF, 0xFC, 0x09, 0x74, 0x81, 0x17, 0xCF, 0xF0,
  0x67, 0x72, 0x87, 0x35, 0x67, 0x77, 0x65, 0xDA, 0x0E, 0x03, 0x77, 0x72, 0x01, 0x0C, 0xA0, 0xE0,
  0x27, 0x77, 0x30, 0xBA, 0x0E, 0x03, 0x77, 0x73, 0x06, 0xB0, 0x77, 0x77, 0x40, 0xEB, 0x01, 0x77,
  0x73, 0x04, 0xB0, 0xD7, 0x77, 0x40, 0x6B, 0x0E, 0x77, 0x74, 0x07, 0xC0, 0x27, 0x77, 0x30, 0x5C,
  0x0C, 0x04, 0x20, 0x20, 0x17, 0x75, 0x01, 0xFA, 0x06, 0x77, 0x60, 0x9F, 0x90, 0x67, 0x77, 0x0B,
  0xF0, 0x67, 0x77, 0x18, 0x65, 0xBE, 0xFE, 0xD9, 0x22,
  // "Ě" (U+011A)
  0x28, 0x31, 0x77, 0x76, 0x75, 0x83, 0x67, 0x77, 0x14, 0x01, 0x0D, 0xB0, 0xB0, 0x17, 0x10, 0x20,
  0xCB, 0x0D, 0x01, 0x50, 0x20, 0xEB, 0x0D, 0x03, 0x60, 0x40, 0xEB, 0x0D, 0x02, 0x70, 0x30, 0xEC,
  0x04, 0x40, 0x6C, 0x0D, 0x02, 0x72, 0x03, 0xD0, 0x52, 0x07, 0xC0, 0xE0, 0x27, 0x40, 0x5D, 0x05,
  0x08, 0xC0, 0xE0, 0x37, 0x60, 0x6F, 0xB0, 0x47, 0x71, 0x08, 0xF9, 0x06, 0x77, 0x30, 0xBE, 0x09,
  0x77, 0x40, 0x20, 0xEC, 0x0D, 0x80, 0xA9, 0x00, 0x04, 0xFF, 0xFB, 0x0E, 0x04, 0xFF, 0xFB, 0x0E,
  0x04, 0xFF, 0xFB, 0x0E, 0x04, 0xFF, 0xFB, 0x0E, 0x04, 0xD0, 0x78, 0x09, 0x66, 0x05, 0x04, 0xD0,
  0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0,
  0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0,
  0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0, 0x17, 0x75, 0x04, 0xD0,
  0x17, 0x75, 0x04, 0xFF, 0xFA, 0x81, 0xB0, 0x4F, 0xFF, 0xA8, 0x1B, 0x04, 0xFF, 0xFA, 0x81, 0xB0,
  0x4F, 0xFF, 0xA8, 0x1B, 0x04, 0xD0, 0x78, 0x09, 0x56, 0x81, 0x40, 0x4D, 0x01, 0x77, 0x50, 0x4D,
  0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D,
  0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D,
  0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D,
  0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x50, 0x4D, 0x07, 0x80, 0x96, 0x60, 0x50, 0x4F, 0xFF, 0xB0,
  0xE0, 0x4F, 0xFF, 0xB0, 0xE0, 0x4F, 0xFF, 0xB0, 0xE0, 0x4F, 0xFF, 0xB0, 0xE0,
  // "ě" (U+011B)
  0x48, 0x31, 0x77, 0x76, 0x75, 0x83, 0x67, 0x77, 0x17, 0x10, 0x10, 0xDB, 0x0B, 0x01, 0x71, 0x02,
  0x0C, 0xB0, 0xD0, 0x17, 0x20, 0x20, 0xEB, 0x0D, 0x03, 0x60, 0x40, 0xEB, 0x0D, 0x02, 0x74, 0x03,
  0x0E, 0xC0, 0x44, 0x06, 0xC0, 0xD0, 0x27, 0x60, 0x3D, 0x05, 0x20, 0x7C, 0x0E, 0x02, 0x77, 0x10,
  0x5D, 0x05, 0x08, 0xC0, 0xE0, 0x37, 0x73, 0x06, 0xFB, 0x04, 0x77, 0x50, 0x8F, 0x90, 0x67, 0x77,
  0x0B, 0xE0, 0x97, 0x77, 0x10, 0x20, 0xEC, 0x0D, 0x80, 0xA9, 0x40, 0x86, 0x25, 0x67, 0x65, 0x41,
  0x77, 0x58, 0x14, 0xAE, 0xF9, 0x0B, 0x06, 0x77, 0x10, 0x40, 0xCF, 0xE0, 0xD0, 0x57, 0x50, 0x9F,
  0xFB, 0x09, 0x73, 0x0B, 0xFA, 0x00, 0xEF, 0x90, 0xA7, 0x10, 0xAE, 0x81, 0xC6, 0x24, 0x04, 0x09,
  0xE0, 0x76, 0x06, 0xD0, 0xE0, 0x57, 0x20, 0x30, 0xDD, 0x03, 0x40, 0x10, 0xEC, 0x0E, 0x02, 0x74,
  0x02, 0x0E, 0xC0, 0xA4, 0x09, 0xD0, 0x47, 0x60, 0x5D, 0x02, 0x20, 0x1D, 0x09, 0x77, 0x10, 0xDC,
  0x08, 0x20, 0x6D, 0x01, 0x77, 0x10, 0x8C, 0x0B, 0x20, 0xBC, 0x0B, 0x77, 0x20, 0x4D, 0x20, 0xEC,
  0x06, 0x77, 0x20, 0x1D, 0x02, 0x01, 0xD0, 0x88, 0x09, 0x56, 0xD0, 0x04, 0xFF, 0xFF, 0x00, 0x5F,
  0xFF, 0xF0, 0x60, 0x5F, 0xFF, 0xF0, 0x06, 0xFF, 0xFF, 0x06, 0x05, 0xD0, 0x17, 0x77, 0x20, 0x4D,
  0x02, 0x77, 0x72, 0x02, 0xD0, 0x47, 0x77, 0x3D, 0x07, 0x77, 0x73, 0x0C, 0xC0, 0xB7, 0x77, 0x30,
  0x7D, 0x02, 0x77, 0x72, 0x02, 0xD0, 0x97, 0x77, 0x30, 0xAD, 0x04, 0x77, 0x72, 0x02, 0xD0, 0xE0,
  0x47, 0x73, 0x04, 0x50, 0x7E, 0x08, 0x01, 0x75, 0x82, 0x27, 0xDE, 0x60, 0xAE, 0x82, 0xEA, 0x52,
  0x58, 0x22, 0x58, 0xCB, 0x0E, 0x70, 0xAF, 0xB0, 0x0E, 0xFA, 0x0E, 0x71, 0x07, 0xFF, 0xE0, 0xE7,
  0x20, 0x20, 0xAF, 0xFB, 0x0C, 0x06, 0x74, 0x81, 0x17, 0xCF, 0xB8, 0x2E, 0xA7, 0x27, 0x73, 0x87,
  0x35, 0x67, 0x76, 0x54, 0x17, 0x10,
  // "Ĝ" (U+011C)
  0x77, 0x80, 0x17, 0x06, 0x77, 0x72, 0x06, 0xE0, 0x47, 0x77, 0x02, 0x0E, 0xE0, 0xD0, 0x17, 0x75,
  0x01, 0x0D, 0xF9, 0x0B, 0x77, 0x50, 0xBC, 0x0A, 0x0C, 0xC0, 0x97, 0x73, 0x09, 0xC8, 0x29, 0x01,
  0xCC, 0x07, 0x77, 0x10, 0x7C, 0x09, 0x30, 0x10, 0xCC, 0x06, 0x76, 0x06, 0xC0, 0x86, 0x0B, 0xC0,
  0x57, 0x40, 0x5C, 0x07, 0x71, 0x09, 0xC0, 0x47, 0x20, 0x1B, 0x0D, 0x03, 0x73, 0x05, 0x0E, 0xB0,
  0x18, 0x0A, 0x85, 0x08, 0x73, 0x56, 0x77, 0x65, 0x41, 0x77, 0x38, 0x12, 0x7C, 0xFB, 0x81, 0xE9,
  0x57, 0x50, 0x20, 0xAF, 0xFA, 0x81, 0xE8, 0x17, 0x10, 0x7F, 0xFD, 0x0E, 0x01, 0x70, 0xAF, 0xB0,
  0x0E, 0xF9, 0x09, 0x70, 0xBF, 0x81, 0xA5, 0x24, 0x82, 0x14, 0x7C, 0xB0, 0x26, 0x09, 0xE0, 0xA0,
  0x27, 0x48, 0x13, 0xBB, 0x60, 0x5E, 0x06, 0x77, 0x10, 0x16, 0x0E, 0xD0, 0x57, 0x77, 0x10, 0x8D,
  0x08, 0x77, 0x72, 0x0E, 0xC0, 0xE7, 0x77, 0x20, 0x6D, 0x06, 0x77, 0x72, 0x0B, 0xC0, 0xE7, 0x77,
  0x20, 0x1D, 0x09, 0x77, 0x72, 0x05, 0xD0, 0x47, 0x77, 0x20, 0x8D, 0x77, 0x73, 0x0B, 0xC0, 0xC7,
  0x77, 0x30, 0xEC, 0x0A, 0x77, 0x73, 0xD0, 0x77, 0x77, 0x20, 0x2D, 0x05, 0x77, 0x72, 0x03, 0xD0,
  0x57, 0x77, 0x20, 0x3D, 0x04, 0x72, 0x01, 0x80, 0x90, 0x60, 0x50, 0x4D, 0x03, 0x72, 0x03, 0xFD,
  0x0C, 0x04, 0xD0, 0x37, 0x20, 0x3F, 0xD0, 0xC0, 0x4D, 0x04, 0x72, 0x03, 0xFD, 0x0C, 0x03, 0xD0,
  0x47, 0x20, 0x3F, 0xD0, 0xC0, 0x2D, 0x06, 0x77, 0x30, 0x6C, 0x0C, 0x01, 0xD0, 0x77, 0x73, 0x06,
  0xC8, 0x1C, 0x0E, 0xC0, 0xA7, 0x73, 0x06, 0xC8, 0x1C, 0x0C, 0xC0, 0xD7, 0x73, 0x06, 0xC8, 0x1C,
  0x09, 0xD0, 0x17, 0x72, 0x06, 0xC8, 0x1C, 0x05, 0xD0, 0x57, 0x72, 0x06, 0xC8, 0x1C, 0x01, 0xD0,
  0xA7, 0x72, 0x06, 0xC0, 0xC2, 0x0C, 0xD0, 0x17, 0x71, 0x06, 0xC0, 0xC2, 0x06, 0xD0, 0x87, 0x71,
  0x06, 0xC0, 0xC3, 0x0E, 0xD0, 0x37, 0x70, 0x6C, 0x0C, 0x30, 0x7D, 0x0D, 0x01, 0x76, 0x06, 0xC0,
  0xC4, 0x0D, 0xD0, 0xC0, 0x17, 0x50, 0x6C, 0x0C, 0x40, 0x3E, 0x0E, 0x05, 0x74, 0x06, 0xC0, 0xC5,
  0x06, 0xF8, 0x1D, 0x73, 0x58, 0x22, 0x48, 0xDC, 0x0C, 0x60, 0x6F, 0xC0, 0x0E, 0xFA, 0x0C, 0x70,
  0x40, 0xEF, 0xFE, 0x0C, 0x71, 0x81, 0x18, 0xEF, 0xFB, 0x0E, 0x07, 0x73, 0x82, 0x16, 0xBE, 0xFB,
  0x82, 0xEB, 0x73, 0x77, 0x28, 0x90, 0x24, 0x67, 0x77, 0x65, 0x31, 0x60,
  // "ĝ" (U+011D)
  0x75, 0x80, 0x17, 0x06, 0x77, 0x71, 0x06, 0xE0, 0x47, 0x76, 0x02, 0x0E, 0xE0, 0xD0, 0x17, 0x74,
  0x01, 0x0D, 0xF9, 0x0B, 0x77, 0x40, 0xBC, 0x0A, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC8, 0x29, 0x01,
  0xCC, 0x07, 0x77, 0x07, 0xC0, 0x93, 0x01, 0x0C, 0xC0, 0x67, 0x50, 0x6C, 0x08, 0x60, 0xBC, 0x05,
  0x73, 0x05, 0xC0, 0x77, 0x10, 0x9C, 0x04, 0x71, 0x01, 0xB0, 0xD0, 0x37, 0x30, 0x50, 0xEB, 0x01,
  0x80, 0x9F, 0x50, 0x85, 0x35, 0x77, 0x75, 0x37, 0x75, 0x81, 0x29, 0xEF, 0x81, 0xE8, 0x13, 0x03,
  0xC0, 0x36, 0x08, 0xFD, 0x0E, 0x05, 0x20, 0x5C, 0x03, 0x40, 0x10, 0xBF, 0xF9, 0x81, 0x60, 0x8C,
  0x03, 0x40, 0xBF, 0xA0, 0xEF, 0x04, 0x0B, 0xC0, 0x33, 0x08, 0xE8, 0x1C, 0x61, 0x38, 0x11, 0x6C,
  0xB0, 0x0E, 0xC0, 0x32, 0x02, 0xE0, 0x67, 0x20, 0x5F, 0x90, 0x32, 0x0B, 0xD0, 0x67, 0x40, 0x4F,
  0x81, 0x30, 0x2D, 0x0A, 0x76, 0x08, 0xE8, 0x13, 0x08, 0xD0, 0x27, 0x70, 0xED, 0x81, 0x30, 0xDC,
  0x0B, 0x77, 0x10, 0x9D, 0x03, 0x01, 0xD0, 0x77, 0x71, 0x04, 0xD0, 0x30, 0x4D, 0x03, 0x77, 0x10,
  0x1D, 0x03, 0x07, 0xD0, 0x17, 0x72, 0x0D, 0xC0, 0x30, 0x8C, 0x0E, 0x77, 0x30, 0xCC, 0x03, 0x09,
  0xC0, 0xD7, 0x73, 0x0B, 0xC0, 0x30, 0xAC, 0x0D, 0x77, 0x30, 0xAC, 0x03, 0x0A, 0xC0, 0xC7, 0x73,
  0x0A, 0xC0, 0x30, 0x9C, 0x0D, 0x77, 0x30, 0xAC, 0x03, 0x08, 0xC0, 0xE7, 0x73, 0x0B, 0xC0, 0x30,
  0x7D, 0x01, 0x77, 0x20, 0xCC, 0x03, 0x05, 0xD0, 0x37, 0x72, 0x0E, 0xC0, 0x30, 0x2D, 0x07, 0x77,
  0x10, 0x1D, 0x81, 0x30, 0xEC, 0x0C, 0x77, 0x10, 0x5D, 0x81, 0x30, 0x9D, 0x02, 0x77, 0x0B, 0xD8,
  0x13, 0x03, 0xD0, 0xB7, 0x60, 0x3E, 0x03, 0x20, 0xDD, 0x07, 0x74, 0x01, 0x0D, 0xE0, 0x32, 0x04,
  0xE0, 0x77, 0x20, 0x30, 0xDF, 0x03, 0x30, 0x9E, 0x81, 0xD7, 0x23, 0x81, 0x14, 0xAF, 0xA0, 0x33,
  0x01, 0x0C, 0xFA, 0x0E, 0xF0, 0xC0, 0xBC, 0x03, 0x40, 0x10, 0xCF, 0xF9, 0x81, 0xD2, 0xBC, 0x03,
  0x60, 0x8F, 0xE8, 0x2C, 0x20, 0xCC, 0x03, 0x78, 0x12, 0x9E, 0xF9, 0x0B, 0x06, 0x30, 0xDC, 0x03,
  0x73, 0x85, 0x25, 0x67, 0x65, 0x46, 0x0D, 0xC0, 0x27, 0x77, 0x20, 0xEC, 0x01, 0x77, 0x72, 0xD7,
  0x77, 0x20, 0x3D, 0x77, 0x72, 0x07, 0xC0, 0xB7, 0x77, 0x20, 0xDC, 0x08, 0x77, 0x71, 0x08, 0xD0,
  0x33, 0x0B, 0x04, 0x77, 0x20, 0x6D, 0x0B, 0x4A, 0x81, 0xD8, 0x47, 0x40, 0x30, 0xAE, 0x04, 0x4E,
  0x89, 0x0D, 0xB9, 0x77, 0x67, 0x8A, 0xDF, 0x08, 0x5F, 0xFF, 0x90, 0xA6, 0x0D, 0xFF, 0xE0, 0x77,
  0x18, 0x14, 0x9D, 0xFF, 0x81, 0xE8, 0x27, 0x58, 0x94, 0x26, 0x8B, 0xDE, 0xEF, 0xED, 0xCA, 0x74,
  0x72,
  // "Ğ" (U+011E)
  0x70, 0x3B, 0x06, 0x73, 0x05, 0xB0, 0x47, 0x30, 0x1B, 0x0D, 0x73, 0x0C, 0xB0, 0x27, 0x40, 0xDB,
  0x0B, 0x02, 0x60, 0x10, 0xAB, 0x0D, 0x75, 0x06, 0xD8, 0x4B, 0x86, 0x78, 0xBD, 0x07, 0x76, 0x0C,
  0xFF, 0x0D, 0x77, 0x01, 0x0D, 0xFD, 0x0D, 0x01, 0x77, 0x10, 0x10, 0xAF, 0xB0, 0xA0, 0x17, 0x74,
  0x89, 0x03, 0x8C, 0xEF, 0xED, 0xB7, 0x28, 0x0A, 0x93, 0x08, 0x73, 0x56, 0x77, 0x65, 0x41, 0x77,
  0x38, 0x12, 0x7C, 0xFB, 0x81, 0xE9, 0x57, 0x50, 0x20, 0xAF, 0xFA, 0x81, 0xE8, 0x17, 0x10, 0x7F,
  0xFD, 0x0E, 0x01, 0x70, 0xAF, 0xB0, 0x0E, 0xF9, 0x09, 0x70, 0xBF, 0x81, 0xA5, 0x24, 0x82, 0x14,
  0x7C, 0xB0, 0x26, 0x09, 0xE0, 0xA0, 0x27, 0x48, 0x13, 0xBB, 0x60, 0x5E, 0x06, 0x77, 0x10, 0x16,
  0x0E, 0xD0, 0x57, 0x77, 0x10, 0x8D, 0x08, 0x77, 0x72, 0x0E, 0xC0, 0xE7, 0x77, 0x20, 0x6D, 0x06,
  0x77, 0x72, 0x0B, 0xC0, 0xE7, 0x77, 0x20, 0x1D, 0x09, 0x77, 0x72, 0x05, 0xD0, 0x47, 0x77, 0x20,
  0x8D, 0x77, 0x73, 0x0B, 0xC0, 0xC7, 0x77, 0x30, 0xEC, 0x0A, 0x77, 0x73, 0xD0, 0x77, 0x77, 0x20,
  0x2D, 0x05, 0x77, 0x72, 0x03, 0xD0, 0x57, 0x77, 0x20, 0x3D, 0x04, 0x72, 0x01, 0x80, 0x90, 0x60,
  0x50, 0x4D, 0x03, 0x72, 0x03, 0xFD, 0x0C, 0x04, 0xD0, 0x37, 0x20, 0x3F, 0xD0, 0xC0, 0x4D, 0x04,
  0x72, 0x03, 0xFD, 0x0C, 0x03, 0xD0, 0x47, 0x20, 0x3F, 0xD0, 0xC0, 0x2D, 0x06, 0x77, 0x30, 0x6C,
  0x0C, 0x01, 0xD0, 0x77, 0x73, 0x06, 0xC8, 0x1C, 0x0E, 0xC0, 0xA7, 0x73, 0x06, 0xC8, 0x1C, 0x0C,
  0xC0, 0xD7, 0x73, 0x06, 0xC8, 0x1C, 0x09, 0xD0, 0x17, 0x72, 0x06, 0xC8, 0x1C, 0x05, 0xD0, 0x57,
  0x72, 0x06, 0xC8, 0x1C, 0x01, 0xD0, 0xA7, 0x72, 0x06, 0xC0, 0xC2, 0x0C, 0xD0, 0x17, 0x71, 0x06,
  0xC0, 0xC2, 0x06, 0xD0, 0x87, 0x71, 0x06, 0xC0, 0xC3, 0x0E, 0xD0, 0x37, 0x70, 0x6C, 0x0C, 0x30,
  0x7D, 0x0D, 0x01, 0x76, 0x06, 0xC0, 0xC4, 0x0D, 0xD0, 0xC0, 0x17, 0x50, 0x6C, 0x0C, 0x40, 0x3E,
  0x0E, 0x05, 0x74, 0x06, 0xC0, 0xC5, 0x06, 0xF8, 0x1D, 0x73, 0x58, 0x22, 0x48, 0xDC, 0x0C, 0x60,
  0x6F, 0xC0, 0x0E, 0xFA, 0x0C, 0x70, 0x40, 0xEF, 0xFE, 0x0C, 0x71, 0x81, 0x18, 0xEF, 0xFB, 0x0E,
  0x07, 0x73, 0x82, 0x16, 0xBE, 0xFB, 0x82, 0xEB, 0x73, 0x77, 0x28, 0x90, 0x24, 0x67, 0x77, 0x65,
  0x31, 0x60,
  // "ğ" (U+011F)
  0x50, 0x3B, 0x06, 0x73, 0x05, 0xB0, 0x47, 0x20, 0x1B, 0x0D, 0x73, 0x0C, 0xB0, 0x27, 0x30, 0xDB,
  0x0B, 0x02, 0x60, 0x10, 0xAB, 0x0D, 0x74, 0x06, 0xD8, 0x4B, 0x86, 0x78, 0xBD, 0x07, 0x75, 0x0C,
  0xFF, 0x0D, 0x76, 0x01, 0x0D, 0xFD, 0x0D, 0x01, 0x77, 0x01, 0x0A, 0xFB, 0x0A, 0x01, 0x77, 0x38,
  0x90, 0x38, 0xCE, 0xFE, 0xDB, 0x72, 0x80, 0xA8, 0x30, 0x85, 0x35, 0x77, 0x75, 0x37, 0x75, 0x81,
  0x29, 0xEF, 0x81, 0xE8, 0x13, 0x03, 0xC0, 0x36, 0x08, 0xFD, 0x0E, 0x05, 0x20, 0x5C, 0x03, 0x40,
  0x10, 0xBF, 0xF9, 0x81, 0x60, 0x8C, 0x03, 0x40, 0xBF, 0xA0, 0xEF, 0x04, 0x0B, 0xC0, 0x33, 0x08,
  0xE8, 0x1C, 0x61, 0x38, 0x11, 0x6C, 0xB0, 0x0E, 0xC0, 0x32, 0x02, 0xE0, 0x67, 0x20, 0x5F, 0x90,
  0x32, 0x0B, 0xD0, 0x67, 0x40, 0x4F, 0x81, 0x30, 0x2D, 0x0A, 0x76, 0x08, 0xE8, 0x13, 0x08, 0xD0,
  0x27, 0x70, 0xED, 0x81, 0x30, 0xDC, 0x0B, 0x77, 0x10, 0x9D, 0x03, 0x01, 0xD0, 0x77, 0x71, 0x04,
  0xD0, 0x30, 0x4D, 0x03, 0x77, 0x10, 0x1D, 0x03, 0x07, 0xD0, 0x17, 0x72, 0x0D, 0xC0, 0x30, 0x8C,
  0x0E, 0x77, 0x30, 0xCC, 0x03, 0x09, 0xC0, 0xD7, 0x73, 0x0B, 0xC0, 0x30, 0xAC, 0x0D, 0x77, 0x30,
  0xAC, 0x03, 0x0A, 0xC0, 0xC7, 0x73, 0x0A, 0xC0, 0x30, 0x9C, 0x0D, 0x77, 0x30, 0xAC, 0x03, 0x08,
  0xC0, 0xE7, 0x73, 0x0B, 0xC0, 0x30, 0x7D, 0x01, 0x77, 0x20, 0xCC, 0x03, 0x05, 0xD0, 0x37, 0x72,
  0x0E, 0xC0, 0x30, 0x2D, 0x07, 0x77, 0x10, 0x1D, 0x81, 0x30, 0xEC, 0x0C, 0x77, 0x10, 0x5D, 0x81,
  0x30, 0x9D, 0x02, 0x77, 0x0B, 0xD8, 0x13, 0x03, 0xD0, 0xB7, 0x60, 0x3E, 0x03, 0x20, 0xDD, 0x07,
  0x74, 0x01, 0x0D, 0xE0, 0x32, 0x04, 0xE0, 0x77, 0x20, 0x30, 0xDF, 0x03, 0x30, 0x9E, 0x81, 0xD7,
  0x23, 0x81, 0x14, 0xAF, 0xA0, 0x33, 0x01, 0x0C, 0xFA, 0x0E, 0xF0, 0xC0, 0xBC, 0x03, 0x40, 0x10,
  0xCF, 0xF9, 0x81, 0xD2, 0xBC, 0x03, 0x60, 0x8F, 0xE8, 0x2C, 0x20, 0xCC, 0x03, 0x78, 0x12, 0x9E,
  0xF9, 0x0B, 0x06, 0x30, 0xDC, 0x03, 0x73, 0x85, 0x25, 0x67, 0x65, 0x46, 0x0D, 0xC0, 0x27, 0x77,
  0x20, 0xEC, 0x01, 0x77, 0x72, 0xD7, 0x77, 0x20, 0x3D, 0x77, 0x72, 0x07, 0xC0, 0xB7, 0x77, 0x20,
  0xDC, 0x08, 0x77, 0x71, 0x08, 0xD0, 0x33, 0x0B, 0x04, 0x77, 0x20, 0x6D, 0x0B, 0x4A, 0x81, 0xD8,
  0x47, 0x40, 0x30, 0xAE, 0x04, 0x4E, 0x89, 0x0D, 0xB9, 0x77, 0x67, 0x8A, 0xDF, 0x08, 0x5F, 0xFF,
  0x90, 0xA6, 0x0D, 0xFF, 0xE0, 0x77, 0x18, 0x14, 0x9D, 0xFF, 0x81, 0xE8, 0x27, 0x58, 0x94, 0x26,
  0x8B, 0xDE, 0xEF, 0xED, 0xCA, 0x74, 0x72,
  // "Ġ" (U+0120)
  0x77, 0x84, 0x2A, 0xEE, 0xA2, 0x77, 0x72, 0x02, 0x0E, 0xC0, 0xE0, 0x27, 0x77, 0x10, 0x8E, 0x08,
  0x77, 0x71, 0x0B, 0xE0, 0xB7, 0x77, 0x10, 0xBE, 0x0B, 0x77, 0x71, 0x08, 0xE0, 0x87, 0x77, 0x10,
  0x20, 0xEC, 0x0E, 0x02, 0x77, 0x72, 0x84, 0x2A, 0xEE, 0xA2, 0x80, 0xAD, 0x30, 0x87, 0x35, 0x67,
  0x76, 0x54, 0x17, 0x73, 0x81, 0x27, 0xCF, 0xB8, 0x1E, 0x95, 0x75, 0x02, 0x0A, 0xFF, 0xA8, 0x1E,
  0x81, 0x71, 0x07, 0xFF, 0xD0, 0xE0, 0x17, 0x0A, 0xFB, 0x00, 0xEF, 0x90, 0x97, 0x0B, 0xF8, 0x1A,
  0x52, 0x48, 0x21, 0x47, 0xCB, 0x02, 0x60, 0x9E, 0x0A, 0x02, 0x74, 0x81, 0x3B, 0xB6, 0x05, 0xE0,
  0x67, 0x71, 0x01, 0x60, 0xED, 0x05, 0x77, 0x71, 0x08, 0xD0, 0x87, 0x77, 0x20, 0xEC, 0x0E, 0x77,
  0x72, 0x06, 0xD0, 0x67, 0x77, 0x20, 0xBC, 0x0E, 0x77, 0x72, 0x01, 0xD0, 0x97, 0x77, 0x20, 0x5D,
  0x04, 0x77, 0x72, 0x08, 0xD7, 0x77, 0x30, 0xBC, 0x0C, 0x77, 0x73, 0x0E, 0xC0, 0xA7, 0x77, 0x3D,
  0x07, 0x77, 0x72, 0x02, 0xD0, 0x57, 0x77, 0x20, 0x3D, 0x05, 0x77, 0x72, 0x03, 0xD0, 0x47, 0x20,
  0x18, 0x09, 0x06, 0x05, 0x04, 0xD0, 0x37, 0x20, 0x3F, 0xD0, 0xC0, 0x4D, 0x03, 0x72, 0x03, 0xFD,
  0x0C, 0x04, 0xD0, 0x47, 0x20, 0x3F, 0xD0, 0xC0, 0x3D, 0x04, 0x72, 0x03, 0xFD, 0x0C, 0x02, 0xD0,
  0x67, 0x73, 0x06, 0xC0, 0xC0, 0x1D, 0x07, 0x77, 0x30, 0x6C, 0x81, 0xC0, 0xEC, 0x0A, 0x77, 0x30,
  0x6C, 0x81, 0xC0, 0xCC, 0x0D, 0x77, 0x30, 0x6C, 0x81, 0xC0, 0x9D, 0x01, 0x77, 0x20, 0x6C, 0x81,
  0xC0, 0x5D, 0x05, 0x77, 0x20, 0x6C, 0x81, 0xC0, 0x1D, 0x0A, 0x77, 0x20, 0x6C, 0x0C, 0x20, 0xCD,
  0x01, 0x77, 0x10, 0x6C, 0x0C, 0x20, 0x6D, 0x08, 0x77, 0x10, 0x6C, 0x0C, 0x30, 0xED, 0x03, 0x77,
  0x06, 0xC0, 0xC3, 0x07, 0xD0, 0xD0, 0x17, 0x60, 0x6C, 0x0C, 0x40, 0xDD, 0x0C, 0x01, 0x75, 0x06,
  0xC0, 0xC4, 0x03, 0xE0, 0xE0, 0x57, 0x40, 0x6C, 0x0C, 0x50, 0x6F, 0x81, 0xD7, 0x35, 0x82, 0x24,
  0x8D, 0xC0, 0xC6, 0x06, 0xFC, 0x00, 0xEF, 0xA0, 0xC7, 0x04, 0x0E, 0xFF, 0xE0, 0xC7, 0x18, 0x11,
  0x8E, 0xFF, 0xB0, 0xE0, 0x77, 0x38, 0x21, 0x6B, 0xEF, 0xB8, 0x2E, 0xB7, 0x37, 0x72, 0x89, 0x02,
  0x46, 0x77, 0x76, 0x53, 0x16,
  // "ġ" (U+0121)
  0x75, 0x84, 0x2A, 0xEE, 0xA2, 0x77, 0x71, 0x02, 0x0E, 0xC0, 0xE0, 0x27, 0x77, 0x08, 0xE0, 0x87,
  0x77, 0x0B, 0xE0, 0xB7, 0x77, 0x0B, 0xE0, 0xB7, 0x77, 0x08, 0xE0, 0x87, 0x77, 0x02, 0x0E, 0xC0,
  0xE0, 0x27, 0x77, 0x18, 0x42, 0xAE, 0xEA, 0x28, 0x0A, 0xC2, 0x08, 0x53, 0x57, 0x77, 0x53, 0x77,
  0x58, 0x12, 0x9E, 0xF8, 0x1E, 0x81, 0x30, 0x3C, 0x03, 0x60, 0x8F, 0xD0, 0xE0, 0x52, 0x05, 0xC0,
  0x34, 0x01, 0x0B, 0xFF, 0x98, 0x16, 0x08, 0xC0, 0x34, 0x0B, 0xFA, 0x0E, 0xF0, 0x40, 0xBC, 0x03,
  0x30, 0x8E, 0x81, 0xC6, 0x13, 0x81, 0x16, 0xCB, 0x00, 0xEC, 0x03, 0x20, 0x2E, 0x06, 0x72, 0x05,
  0xF9, 0x03, 0x20, 0xBD, 0x06, 0x74, 0x04, 0xF8, 0x13, 0x02, 0xD0, 0xA7, 0x60, 0x8E, 0x81, 0x30,
  0x8D, 0x02, 0x77, 0x0E, 0xD8, 0x13, 0x0D, 0xC0, 0xB7, 0x71, 0x09, 0xD0, 0x30, 0x1D, 0x07, 0x77,
  0x10, 0x4D, 0x03, 0x04, 0xD0, 0x37, 0x71, 0x01, 0xD0, 0x30, 0x7D, 0x01, 0x77, 0x20, 0xDC, 0x03,
  0x08, 0xC0, 0xE7, 0x73, 0x0C, 0xC0, 0x30, 0x9C, 0x0D, 0x77, 0x30, 0xBC, 0x03, 0x0A, 0xC0, 0xD7,
  0x73, 0x0A, 0xC0, 0x30, 0xAC, 0x0C, 0x77, 0x30, 0xAC, 0x03, 0x09, 0xC0, 0xD7, 0x73, 0x0A, 0xC0,
  0x30, 0x8C, 0x0E, 0x77, 0x30, 0xBC, 0x03, 0x07, 0xD0, 0x17, 0x72, 0x0C, 0xC0, 0x30, 0x5D, 0x03,
  0x77, 0x20, 0xEC, 0x03, 0x02, 0xD0, 0x77, 0x71, 0x01, 0xD8, 0x13, 0x0E, 0xC0, 0xC7, 0x71, 0x05,
  0xD8, 0x13, 0x09, 0xD0, 0x27, 0x70, 0xBD, 0x81, 0x30, 0x3D, 0x0B, 0x76, 0x03, 0xE0, 0x32, 0x0D,
  0xD0, 0x77, 0x40, 0x10, 0xDE, 0x03, 0x20, 0x4E, 0x07, 0x72, 0x03, 0x0D, 0xF0, 0x33, 0x09, 0xE8,
  0x1D, 0x72, 0x38, 0x11, 0x4A, 0xFA, 0x03, 0x30, 0x10, 0xCF, 0xA0, 0xEF, 0x0C, 0x0B, 0xC0, 0x34,
  0x01, 0x0C, 0xFF, 0x98, 0x1D, 0x2B, 0xC0, 0x36, 0x08, 0xFE, 0x82, 0xC2, 0x0C, 0xC0, 0x37, 0x81,
  0x29, 0xEF, 0x90, 0xB0, 0x63, 0x0D, 0xC0, 0x37, 0x38, 0x52, 0x56, 0x76, 0x54, 0x60, 0xDC, 0x02,
  0x77, 0x72, 0x0E, 0xC0, 0x17, 0x77, 0x2D, 0x77, 0x72, 0x03, 0xD7, 0x77, 0x20, 0x7C, 0x0B, 0x77,
  0x72, 0x0D, 0xC0, 0x87, 0x77, 0x10, 0x8D, 0x03, 0x30, 0xB0, 0x47, 0x72, 0x06, 0xD0, 0xB4, 0xA8,
  0x1D, 0x84, 0x74, 0x03, 0x0A, 0xE0, 0x44, 0xE8, 0x90, 0xDB, 0x97, 0x76, 0x78, 0xAD, 0xF0, 0x85,
  0xFF, 0xF9, 0x0A, 0x60, 0xDF, 0xFE, 0x07, 0x71, 0x81, 0x49, 0xDF, 0xF8, 0x1E, 0x82, 0x75, 0x89,
  0x42, 0x68, 0xBD, 0xEE, 0xFE, 0xDC, 0xA7, 0x47, 0x20,
  // "Ģ" (U+0122)
  0x77, 0x18, 0x73, 0x56, 0x77, 0x65, 0x41, 0x77, 0x38, 0x12, 0x7C, 0xFB, 0x81, 0xE9, 0x57, 0x50,
  0x20, 0xAF, 0xFA, 0x81, 0xE8, 0x17, 0x10, 0x7F, 0xFD, 0x0E, 0x01, 0x70, 0xAF, 0xB0, 0x0E, 0xF9,
  0x09, 0x70, 0xBF, 0x81, 0xA5, 0x24, 0x82, 0x14, 0x7C, 0xB0, 0x26, 0x09, 0xE0, 0xA0, 0x27, 0x48,
  0x13, 0xBB, 0x60, 0x5E, 0x06, 0x77, 0x10, 0x16, 0x0E, 0xD0, 0x57, 0x77, 0x10, 0x8D, 0x08, 0x77,
  0x72, 0x0E, 0xC0, 0xE7, 0x77, 0x20, 0x6D, 0x06, 0x77, 0x72, 0x0B, 0xC0, 0xE7, 0x77, 0x20, 0x1D,
  0x09, 0x77, 0x72, 0x05, 0xD0, 0x47, 0x77, 0x20, 0x8D, 0x77, 0x73, 0x0B, 0xC0, 0xC7, 0x77, 0x30,
  0xEC, 0x0A, 0x77, 0x73, 0xD0, 0x77, 0x77, 0x20, 0x2D, 0x05, 0x77, 0x72, 0x03, 0xD0, 0x57, 0x77,
  0x20, 0x3D, 0x04, 0x72, 0x01, 0x80, 0x90, 0x60, 0x50, 0x4D, 0x03, 0x72, 0x03, 0xFD, 0x0C, 0x04,
  0xD0, 0x37, 0x20, 0x3F, 0xD0, 0xC0, 0x4D, 0x04, 0x72, 0x03, 0xFD, 0x0C, 0x03, 0xD0, 0x47, 0x20,
  0x3F, 0xD0, 0xC0, 0x2D, 0x06, 0x77, 0x30, 0x6C, 0x0C, 0x01, 0xD0, 0x77, 0x73, 0x06, 0xC8, 0x1C,
  0x0E, 0xC0, 0xA7, 0x73, 0x06, 0xC8, 0x1C, 0x0C, 0xC0, 0xD7, 0x73, 0x06, 0xC8, 0x1C, 0x09, 0xD0,
  0x17, 0x72, 0x06, 0xC8, 0x1C, 0x05, 0xD0, 0x57, 0x72, 0x06, 0xC8, 0x1C, 0x01, 0xD0, 0xA7, 0x72,
  0x06, 0xC0, 0xC2, 0x0C, 0xD0, 0x17, 0x71, 0x06, 0xC0, 0xC2, 0x06, 0xD0, 0x87, 0x71, 0x06, 0xC0,
  0xC3, 0x0E, 0xD0, 0x37, 0x70, 0x6C, 0x0C, 0x30, 0x7D, 0x0D, 0x01, 0x76, 0x06, 0xC0, 0xC4, 0x0D,
  0xD0, 0xC0, 0x17, 0x50, 0x6C, 0x0C, 0x40, 0x3E, 0x0E, 0x05, 0x74, 0x06, 0xC0, 0xC5, 0x06, 0xF8,
  0x1D, 0x73, 0x58, 0x22, 0x48, 0xDC, 0x0C, 0x60, 0x6F, 0xC0, 0x0E, 0xFA, 0x0C, 0x70, 0x40, 0xEF,
  0xFE, 0x0C, 0x71, 0x81, 0x18, 0xEF, 0xFB, 0x0E, 0x07, 0x73, 0x82, 0x16, 0xBE, 0xFB, 0x82, 0xEB,
  0x73, 0x77, 0x28, 0x90, 0x24, 0x67, 0x77, 0x65, 0x31, 0x80, 0x99, 0x50, 0x09, 0xC0, 0xA7, 0x77,
  0x30, 0xBC, 0x05, 0x77, 0x73, 0x0E, 0xB0, 0xE7, 0x77, 0x30, 0x2C, 0x09, 0x77, 0x73, 0x06, 0xC0,
  0x27, 0x77, 0x30, 0xBB, 0x09, 0x77, 0x74, 0x0E, 0xB0, 0x27, 0x77, 0x30, 0x4B, 0x08, 0x77, 0x74,
  0x0A, 0xA0, 0xD0, 0x17, 0x77, 0x4B, 0x04, 0x76,
  // "ģ" (U+0123)
  0x77, 0x10, 0x7A, 0x0C, 0x77, 0x73, 0x02, 0xB0, 0x87, 0x77, 0x30, 0xBB, 0x02, 0x77, 0x72, 0x05,
  0xB0, 0xD7, 0x77, 0x30, 0xDB, 0x08, 0x77, 0x72, 0x05, 0xC0, 0x47, 0x77, 0x20, 0xCC, 0x77, 0x72,
  0x03, 0xC0, 0xC7, 0x77, 0x20, 0x9C, 0x08, 0x77, 0x72, 0x0D, 0xC0, 0x68, 0x09, 0xD1, 0x08, 0x53,
  0x57, 0x77, 0x53, 0x77, 0x58, 0x12, 0x9E, 0xF8, 0x1E, 0x81, 0x30, 0x3C, 0x03, 0x60, 0x8F, 0xD0,
  0xE0, 0x52, 0x05, 0xC0, 0x34, 0x01, 0x0B, 0xFF, 0x98, 0x16, 0x08, 0xC0, 0x34, 0x0B, 0xFA, 0x0E,
  0xF0, 0x40, 0xBC, 0x03, 0x30, 0x8E, 0x81, 0xC6, 0x13, 0x81, 0x16, 0xCB, 0x00, 0xEC, 0x03, 0x20,
  0x2E, 0x06, 0x72, 0x05, 0xF9, 0x03, 0x20, 0xBD, 0x06, 0x74, 0x04, 0xF8, 0x13, 0x02, 0xD0, 0xA7,
  0x60, 0x8E, 0x81, 0x30, 0x8D, 0x02, 0x77, 0x0E, 0xD8, 0x13, 0x0D, 0xC0, 0xB7, 0x71, 0x09, 0xD0,
  0x30, 0x1D, 0x07, 0x77, 0x10, 0x4D, 0x03, 0x04, 0xD0, 0x37, 0x71, 0x01, 0xD0, 0x30, 0x7D, 0x01,
  0x77, 0x20, 0xDC, 0x03, 0x08, 0xC0, 0xE7, 0x73, 0x0C, 0xC0, 0x30, 0x9C, 0x0D, 0x77, 0x30, 0xBC,
  0x03, 0x0A, 0xC0, 0xD7, 0x73, 0x0A, 0xC0, 0x30, 0xAC, 0x0C, 0x77, 0x30, 0xAC, 0x03, 0x09, 0xC0,
  0xD7, 0x73, 0x0A, 0xC0, 0x30, 0x8C, 0x0E, 0x77, 0x30, 0xBC, 0x03, 0x07, 0xD0, 0x17, 0x72, 0x0C,
  0xC0, 0x30, 0x5D, 0x03, 0x77, 0x20, 0xEC, 0x03, 0x02, 0xD0, 0x77, 0x71, 0x01, 0xD8, 0x13, 0x0E,
  0xC0, 0xC7, 0x71, 0x05, 0xD8, 0x13, 0x09, 0xD0, 0x27, 0x70, 0xBD, 0x81, 0x30, 0x3D, 0x0B, 0x76,
  0x03, 0xE0, 0x32, 0x0D, 0xD0, 0x77, 0x40, 0x10, 0xDE, 0x03, 0x20, 0x4E, 0x07, 0x72, 0x03, 0x0D,
  0xF0, 0x33, 0x09, 0xE8, 0x1D, 0x72, 0x38, 0x11, 0x4A, 0xFA, 0x03, 0x30, 0x10, 0xCF, 0xA0, 0xEF,
  0x0C, 0x0B, 0xC0, 0x34, 0x01, 0x0C, 0xFF, 0x98, 0x1D, 0x2B, 0xC0, 0x36, 0x08, 0xFE, 0x82, 0xC2,
  0x0C, 0xC0, 0x37, 0x81, 0x29, 0xEF, 0x90, 0xB0, 0x63, 0x0D, 0xC0, 0x37, 0x38, 0x52, 0x56, 0x76,
  0x54, 0x60, 0xDC, 0x02, 0x77, 0x72, 0x0E, 0xC0, 0x17, 0x77, 0x2D, 0x77, 0x72, 0x03, 0xD7, 0x77,
  0x20, 0x7C, 0x0B, 0x77, 0x72, 0x0D, 0xC0, 0x87, 0x77, 0x10, 0x8D, 0x03, 0x30, 0xB0, 0x47, 0x72,
  0x06, 0xD0, 0xB4, 0xA8, 0x1D, 0x84, 0x74, 0x03, 0x0A, 0xE0, 0x44, 0xE8, 0x90, 0xDB, 0x97, 0x76,
  0x78, 0xAD, 0xF0, 0x85, 0xFF, 0xF9, 0x0A, 0x60, 0xDF, 0xFE, 0x07, 0x71, 0x81, 0x49, 0xDF, 0xF8,
  0x1E, 0x82, 0x75, 0x89, 0x42, 0x68, 0xBD, 0xEE, 0xFE, 0xDC, 0xA7, 0x47, 0x20,
  // "Ĥ" (U+0124)
  0x74, 0x80, 0x17, 0x06, 0x77, 0x70, 0x6E, 0x04, 0x77, 0x50, 0x20, 0xEE, 0x0D, 0x01, 0x77, 0x30,
  0x10, 0xDF, 0x90, 0xB7, 0x73, 0x0B, 0xC0, 0xA0, 0xCC, 0x09, 0x77, 0x10, 0x9C, 0x82, 0x90, 0x1C,
  0xC0, 0x77, 0x60, 0x7C, 0x09, 0x30, 0x10, 0xCC, 0x06, 0x74, 0x06, 0xC0, 0x86, 0x0B, 0xC0, 0x57,
  0x20, 0x5C, 0x07, 0x71, 0x09, 0xC0, 0x47, 0x01, 0xB0, 0xD0, 0x37, 0x30, 0x50, 0xEB, 0x01, 0x80,
  0xA9, 0x30, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0,
  0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0,
  0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72,
  0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0,
  0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0,
  0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72,
  0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xFF,
  0xFD, 0x00, 0xCF, 0xFF, 0xD0, 0x0C, 0xFF, 0xFD, 0x00, 0xCF, 0xFF, 0xD0, 0x0C, 0xC0, 0xB8, 0x09,
  0x46, 0x0B, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C,
  0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09,
  0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97,
  0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C,
  0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09,
  0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97,
  0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C,
  0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0xC0,
  // "ĥ" (U+0125)
  0x71, 0x80, 0x17, 0x06, 0x77, 0x77, 0x06, 0xE0, 0x47, 0x77, 0x50, 0x20, 0xEE, 0x0D, 0x01, 0x77,
  0x73, 0x01, 0x0D, 0xF9, 0x0B, 0x77, 0x73, 0x0B, 0xC0, 0xA0, 0xCC, 0x09, 0x77, 0x71, 0x09, 0xC8,
  0x29, 0x01, 0xCC, 0x07, 0x77, 0x60, 0x7C, 0x09, 0x30, 0x10, 0xCC, 0x06, 0x77, 0x40, 0x6C, 0x08,
  0x60, 0xBC, 0x05, 0x77, 0x20, 0x5C, 0x07, 0x71, 0x09, 0xC0, 0x47, 0x70, 0x1B, 0x0D, 0x03, 0x73,
  0x05, 0x0E, 0xB0, 0x18, 0x0A, 0xB4, 0x00, 0x3D, 0x03, 0x77, 0x77, 0x03, 0xD0, 0x37, 0x77, 0x70,
  0x3D, 0x03, 0x77, 0x77, 0x03, 0xD0, 0x37, 0x77, 0x70, 0x3D, 0x03, 0x77, 0x77, 0x03, 0xD0, 0x37,
  0x77, 0x70, 0x3D, 0x03, 0x77, 0x77, 0x03, 0xD0, 0x37, 0x77, 0x70, 0x3D, 0x03, 0x77, 0x77, 0x03,
  0xD0, 0x37, 0x77, 0x70, 0x3D, 0x03, 0x77, 0x77, 0x03, 0xD0, 0x37, 0x77, 0x70, 0x3D, 0x03, 0x77,
  0x77, 0x03, 0xD0, 0x36, 0x85, 0x25, 0x67, 0x65, 0x27, 0x71, 0x03, 0xD0, 0x23, 0x81, 0x18, 0xDF,
  0x81, 0xD7, 0x17, 0x50, 0x3D, 0x02, 0x20, 0x50, 0xEF, 0xC0, 0xE0, 0x67, 0x40, 0x3D, 0x81, 0x10,
  0x7F, 0xF9, 0x09, 0x73, 0x03, 0xD0, 0x10, 0x6E, 0x00, 0xEF, 0xA0, 0x67, 0x20, 0x3D, 0x02, 0x0E,
  0xB0, 0x90, 0x44, 0x04, 0x0A, 0xF0, 0x17, 0x10, 0x3D, 0x0A, 0xA0, 0xD0, 0x37, 0x10, 0x40, 0xED,
  0x08, 0x71, 0x03, 0xF0, 0xD0, 0x17, 0x30, 0x5D, 0x0D, 0x71, 0x03, 0xF0, 0x37, 0x50, 0xCD, 0x01,
  0x70, 0x3E, 0x09, 0x76, 0x06, 0xD0, 0x47, 0x03, 0xE0, 0x37, 0x60, 0x2D, 0x05, 0x70, 0x3D, 0x0D,
  0x77, 0x1D, 0x07, 0x70, 0x3D, 0x09, 0x77, 0x10, 0xEC, 0x07, 0x70, 0x3D, 0x06, 0x77, 0x10, 0xEC,
  0x07, 0x70, 0x3D, 0x04, 0x77, 0x10, 0xEC, 0x07, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x70,
  0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x70, 0x3D, 0x03,
  0x77, 0x10, 0xEC, 0x07, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x70, 0x3D, 0x03, 0x77, 0x10,
  0xEC, 0x07, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07,
  0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x70, 0x3D,
  0x03, 0x77, 0x10, 0xEC, 0x07, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x70, 0x3D, 0x03, 0x77,
  0x10, 0xEC, 0x07, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC,
  0x07, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x70,
  0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07,
  // "Ħ" (U+0126)
  0x40, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x0C, 0x71, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0xC7, 0x10,
  0xCC, 0x09, 0x77, 0x20, 0x9C, 0x0C, 0x71, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0xC7, 0x10, 0xCC,
  0x09, 0x77, 0x20, 0x9C, 0x0C, 0x71, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0xC7, 0x10, 0xCC, 0x09,
  0x77, 0x20, 0x9C, 0x0C, 0x48, 0x0A, 0x94, 0xF8, 0x00, 0x60, 0xDC, 0x0B, 0x80, 0x94, 0x60, 0xBC,
  0x0D, 0x80, 0x06, 0x40, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x0C, 0x71, 0x0C, 0xC0, 0x97, 0x72, 0x09,
  0xC0, 0xC7, 0x10, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x0C, 0x71, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0,
  0xC7, 0x10, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x0C, 0x71, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0xC7,
  0x10, 0xCF, 0xFF, 0xD0, 0xC7, 0x10, 0xCF, 0xFF, 0xD0, 0xC7, 0x10, 0xCF, 0xFF, 0xD0, 0xC7, 0x10,
  0xCF, 0xFF, 0xD0, 0xC7, 0x10, 0xCC, 0x0B, 0x80, 0x94, 0x60, 0xBC, 0x0C, 0x71, 0x0C, 0xC0, 0x97,
  0x72, 0x09, 0xC0, 0xC7, 0x10, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x0C, 0x71, 0x0C, 0xC0, 0x97, 0x72,
  0x09, 0xC0, 0xC7, 0x10, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x0C, 0x71, 0x0C, 0xC0, 0x97, 0x72, 0x09,
  0xC0, 0xC7, 0x10, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x0C, 0x71, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0,
  0xC7, 0x10, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x0C, 0x71, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0xC7,
  0x10, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x0C, 0x71, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0xC7, 0x10,
  0xCC, 0x09, 0x77, 0x20, 0x9C, 0x0C, 0x71, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0xC7, 0x10, 0xCC,
  0x09, 0x77, 0x20, 0x9C, 0x0C, 0x71, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0xC7, 0x10, 0xCC, 0x09,
  0x77, 0x20, 0x9C, 0x0C, 0x71, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0xC7, 0x10, 0xCC, 0x09, 0x77,
  0x20, 0x9C, 0x0C, 0x71, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0xC7, 0x10, 0xCC, 0x09, 0x77, 0x20,
  0x9C, 0x0C, 0x40,
  // "ħ" (U+0127)
  0x40, 0x3D, 0x03, 0x77, 0x74, 0x03, 0xD0, 0x37, 0x77, 0x40, 0x3D, 0x03, 0x77, 0x74, 0x03, 0xD0,
  0x37, 0x77, 0x40, 0x3D, 0x03, 0x77, 0x78, 0x00, 0x60, 0x8D, 0x08, 0x80, 0x56, 0x04, 0x74, 0xFF,
  0xE0, 0xB7, 0x4F, 0xFE, 0x0B, 0x74, 0xFF, 0xE0, 0xB7, 0x4F, 0xFE, 0x0B, 0x77, 0x10, 0x3D, 0x03,
  0x77, 0x74, 0x03, 0xD0, 0x37, 0x77, 0x40, 0x3D, 0x03, 0x77, 0x74, 0x03, 0xD0, 0x36, 0x85, 0x25,
  0x67, 0x65, 0x27, 0x50, 0x3D, 0x02, 0x38, 0x11, 0x8D, 0xF8, 0x1D, 0x71, 0x72, 0x03, 0xD0, 0x22,
  0x05, 0x0E, 0xFC, 0x0E, 0x06, 0x71, 0x03, 0xD8, 0x11, 0x07, 0xFF, 0x90, 0x97, 0x03, 0xD0, 0x10,
  0x6E, 0x00, 0xEF, 0xA0, 0x66, 0x03, 0xD0, 0x20, 0xEB, 0x09, 0x04, 0x40, 0x40, 0xAF, 0x01, 0x50,
  0x3D, 0x0A, 0xA0, 0xD0, 0x37, 0x10, 0x40, 0xED, 0x08, 0x50, 0x3F, 0x0D, 0x01, 0x73, 0x05, 0xD0,
  0xD5, 0x03, 0xF0, 0x37, 0x50, 0xCD, 0x01, 0x40, 0x3E, 0x09, 0x76, 0x06, 0xD0, 0x44, 0x03, 0xE0,
  0x37, 0x60, 0x2D, 0x05, 0x40, 0x3D, 0x0D, 0x77, 0x1D, 0x07, 0x40, 0x3D, 0x09, 0x77, 0x10, 0xEC,
  0x07, 0x40, 0x3D, 0x06, 0x77, 0x10, 0xEC, 0x07, 0x40, 0x3D, 0x04, 0x77, 0x10, 0xEC, 0x07, 0x40,
  0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x40, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x40, 0x3D, 0x03,
  0x77, 0x10, 0xEC, 0x07, 0x40, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x40, 0x3D, 0x03, 0x77, 0x10,
  0xEC, 0x07, 0x40, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x40, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07,
  0x40, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x40, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x40, 0x3D,
  0x03, 0x77, 0x10, 0xEC, 0x07, 0x40, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x40, 0x3D, 0x03, 0x77,
  0x10, 0xEC, 0x07, 0x40, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x40, 0x3D, 0x03, 0x77, 0x10, 0xEC,
  0x07, 0x40, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x40, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x40,
  0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x40, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07,
  // "Ĩ" (U+0128)
  0x48, 0x51, 0x8D, 0xED, 0xB4, 0x71, 0x05, 0xA0, 0xB4, 0x02, 0x0E, 0xE0, 0xB0, 0x26, 0x0B, 0xA0,
  0x83, 0x01, 0x0D, 0xFA, 0x07, 0x40, 0x4B, 0x04, 0x30, 0x8F, 0xC8, 0x2E, 0x97, 0x9B, 0x0E, 0x40,
  0xEB, 0x82, 0x97, 0x8D, 0xFC, 0x08, 0x30, 0x5B, 0x05, 0x40, 0x70, 0xEF, 0x90, 0xD4, 0x08, 0xA0,
  0xB6, 0x02, 0x0B, 0xE0, 0xE0, 0x24, 0x0B, 0xA0, 0x67, 0x18, 0x54, 0xAD, 0xFD, 0x81, 0x80, 0x9F,
  0x00, 0x06, 0xFF, 0xF9, 0x00, 0x6F, 0xFF, 0x90, 0x06, 0xFF, 0xF9, 0x00, 0x6F, 0xFF, 0x98, 0x90,
  0x61, 0x46, 0x78, 0xAB, 0xDE, 0xE8, 0x7E, 0xDB, 0xA8, 0x76, 0x41, 0x72, 0x0B, 0xC0, 0x97, 0x74,
  0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74,
  0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74,
  0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74,
  0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74,
  0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74,
  0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74,
  0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74,
  0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x78,
  0x31, 0x34, 0x5D, 0xC8, 0x3C, 0x54, 0x31, 0x58, 0x24, 0xBD, 0xEF, 0xFA, 0x83, 0xED, 0xB4, 0x6F,
  0xFF, 0x90, 0x06, 0xFF, 0xF9, 0x00, 0x6F, 0xFF, 0x90, 0x60,
  // "ĩ" (U+0129)
  0x68, 0x51, 0x8D, 0xED, 0xB4, 0x71, 0x05, 0xA0, 0xB7, 0x20, 0x20, 0xEE, 0x0B, 0x02, 0x60, 0xBA,
  0x08, 0x71, 0x01, 0x0D, 0xFA, 0x07, 0x40, 0x4B, 0x04, 0x71, 0x08, 0xFC, 0x82, 0xE9, 0x79, 0xB0,
  0xE7, 0x20, 0xEB, 0x82, 0x97, 0x8D, 0xFC, 0x08, 0x71, 0x05, 0xB0, 0x54, 0x07, 0x0E, 0xF9, 0x0D,
  0x72, 0x08, 0xA0, 0xB6, 0x02, 0x0B, 0xE0, 0xE0, 0x27, 0x20, 0xBA, 0x06, 0x71, 0x85, 0x4A, 0xDF,
  0xD8, 0x18, 0x0A, 0xA5, 0x00, 0x3F, 0xF9, 0x0A, 0x75, 0x03, 0xFF, 0x90, 0xA7, 0x50, 0x3F, 0xF9,
  0x0A, 0x75, 0x81, 0x3D, 0xEF, 0xE0, 0xA7, 0x72, 0x86, 0x12, 0x35, 0x67, 0x8D, 0xC0, 0xA7, 0x77,
  0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0,
  0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72,
  0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A,
  0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20,
  0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7,
  0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B,
  0xC0, 0xA7, 0x74, 0x84, 0x12, 0x34, 0x6D, 0xC8, 0x3C, 0x54, 0x31, 0x78, 0x41, 0x9A, 0xBD, 0xEF,
  0xFB, 0x85, 0xED, 0xCA, 0x93, 0x3F, 0xFF, 0xE0, 0x60, 0x3F, 0xFF, 0xE0, 0x60, 0x3F, 0xFF, 0xE0,
  0x60,
  // "Ī" (U+012A)
  0x30, 0x58, 0x09, 0x46, 0x05, 0x60, 0xDF, 0xFA, 0x0E, 0x60, 0xDF, 0xFA, 0x0E, 0x60, 0xDF, 0xFA,
  0x0E, 0x60, 0xDF, 0xFA, 0x0E, 0x80, 0x9E, 0x70, 0x06, 0xFF, 0xF9, 0x00, 0x6F, 0xFF, 0x90, 0x06,
  0xFF, 0xF9, 0x00, 0x6F, 0xFF, 0x98, 0x90, 0x61, 0x46, 0x78, 0xAB, 0xDE, 0xE8, 0x7E, 0xDB, 0xA8,
  0x76, 0x41, 0x72, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B,
  0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B,
  0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B,
  0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B,
  0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B,
  0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B,
  0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B,
  0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B,
  0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x78, 0x31, 0x34, 0x5D, 0xC8, 0x3C, 0x54, 0x31, 0x58, 0x24,
  0xBD, 0xEF, 0xFA, 0x83, 0xED, 0xB4, 0x6F, 0xFF, 0x90, 0x06, 0xFF, 0xF9, 0x00, 0x6F, 0xFF, 0x90,
  0x60,
  // "ī" (U+012B)
  0x50, 0x58, 0x09, 0x46, 0x05, 0x74, 0x0D, 0xFF, 0xA0, 0xE7, 0x40, 0xDF, 0xFA, 0x0E, 0x74, 0x0D,
  0xFF, 0xA0, 0xE7, 0x40, 0xDF, 0xFA, 0x0E, 0x80, 0xAA, 0x40, 0x03, 0xFF, 0x90, 0xA7, 0x50, 0x3F,
  0xF9, 0x0A, 0x75, 0x03, 0xFF, 0x90, 0xA7, 0x58, 0x13, 0xDE, 0xFE, 0x0A, 0x77, 0x28, 0x61, 0x23,
  0x56, 0x78, 0xDC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B,
  0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77,
  0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC,
  0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77,
  0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0,
  0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72,
  0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x48, 0x41, 0x23, 0x46, 0xDC, 0x83, 0xC5, 0x43,
  0x17, 0x84, 0x19, 0xAB, 0xDE, 0xFF, 0xB8, 0x5E, 0xDC, 0xA9, 0x33, 0xFF, 0xFE, 0x06, 0x03, 0xFF,
  0xFE, 0x06, 0x03, 0xFF, 0xFE, 0x06,
  // "Ĭ" (U+012C)
  0x20, 0x3B, 0x06, 0x73, 0x05, 0xB0, 0x44, 0x01, 0xB0, 0xD7, 0x30, 0xCB, 0x02, 0x50, 0xDB, 0x0B,
  0x02, 0x60, 0x10, 0xAB, 0x0D, 0x60, 0x6D, 0x84, 0xB8, 0x67, 0x8B, 0xD0, 0x77, 0x0C, 0xFF, 0x0D,
  0x71, 0x01, 0x0D, 0xFD, 0x0D, 0x01, 0x72, 0x01, 0x0A, 0xFB, 0x0A, 0x01, 0x75, 0x89, 0x03, 0x8C,
  0xEF, 0xED, 0xB7, 0x28, 0x09, 0xF3, 0x00, 0x6F, 0xFF, 0x90, 0x06, 0xFF, 0xF9, 0x00, 0x6F, 0xFF,
  0x90, 0x06, 0xFF, 0xF9, 0x89, 0x06, 0x14, 0x67, 0x8A, 0xBD, 0xEE, 0x87, 0xED, 0xBA, 0x87, 0x64,
  0x17, 0x20, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09,
  0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09,
  0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09,
  0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09,
  0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09,
  0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09,
  0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09,
  0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09,
  0x77, 0x40, 0xBC, 0x09, 0x77, 0x83, 0x13, 0x45, 0xDC, 0x83, 0xC5, 0x43, 0x15, 0x82, 0x4B, 0xDE,
  0xFF, 0xA8, 0x3E, 0xDB, 0x46, 0xFF, 0xF9, 0x00, 0x6F, 0xFF, 0x90, 0x06, 0xFF, 0xF9, 0x06,
  // "ĭ" (U+012D)
  0x40, 0x3B, 0x06, 0x73, 0x05, 0xB0, 0x47, 0x20, 0x1B, 0x0D, 0x73, 0x0C, 0xB0, 0x27, 0x30, 0xDB,
  0x0B, 0x02, 0x60, 0x10, 0xAB, 0x0D, 0x74, 0x06, 0xD8, 0x4B, 0x86, 0x78, 0xBD, 0x07, 0x75, 0x0C,
  0xFF, 0x0D, 0x76, 0x01, 0x0D, 0xFD, 0x0D, 0x01, 0x77, 0x01, 0x0A, 0xFB, 0x0A, 0x01, 0x77, 0x38,
  0x90, 0x38, 0xCE, 0xFE, 0xDB, 0x72, 0x80, 0xAB, 0x00, 0x03, 0xFF, 0x90, 0xA7, 0x50, 0x3F, 0xF9,
  0x0A, 0x75, 0x03, 0xFF, 0x90, 0xA7, 0x58, 0x13, 0xDE, 0xFE, 0x0A, 0x77, 0x28, 0x61, 0x23, 0x56,
  0x78, 0xDC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0,
  0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72,
  0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A,
  0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20,
  0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7,
  0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B,
  0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x48, 0x41, 0x23, 0x46, 0xDC, 0x83, 0xC5, 0x43, 0x17,
  0x84, 0x19, 0xAB, 0xDE, 0xFF, 0xB8, 0x5E, 0xDC, 0xA9, 0x33, 0xFF, 0xFE, 0x06, 0x03, 0xFF, 0xFE,
  0x06, 0x03, 0xFF, 0xFE, 0x06,
  // "Į" (U+012E)
  0x06, 0xFF, 0xF9, 0x00, 0x6F, 0xFF, 0x90, 0x06, 0xFF, 0xF9, 0x00, 0x6F, 0xFF, 0x98, 0x90, 0x61,
  0x46, 0x78, 0xAB, 0xDE, 0xE8, 0x7E, 0xDB, 0xA8, 0x76, 0x41, 0x72, 0x0B, 0xC0, 0x97, 0x74, 0x0B,
  0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B,
  0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B,
  0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B,
  0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B,
  0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B,
  0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B,
  0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B,
  0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x97, 0x78, 0x31,
  0x34, 0x5D, 0xC8, 0x3C, 0x54, 0x31, 0x58, 0x24, 0xBD, 0xEF, 0xFA, 0x83, 0xED, 0xB4, 0x6F, 0xFF,
  0x90, 0x06, 0xFF, 0xF9, 0x00, 0x6F, 0xFF, 0x90, 0x67, 0x71, 0x08, 0xB0, 0x77, 0x74, 0x06, 0xB0,
  0x97, 0x74, 0x02, 0xB0, 0xC7, 0x75, 0x0B, 0xB0, 0x37, 0x74, 0x02, 0xB0, 0xD7, 0x75, 0x07, 0xB0,
  0x97, 0x75, 0x09, 0xB0, 0x97, 0x75, 0x0B, 0xB0, 0xC7, 0x75, 0x09, 0xC0, 0x90, 0x22, 0x03, 0x77,
  0x06, 0xFA, 0x02, 0x77, 0x0D, 0xF9, 0x02, 0x77, 0x03, 0x0E, 0xF0, 0x27, 0x71, 0x87, 0x18, 0xCE,
  0xFE, 0xC8, 0x11,
  // "į" (U+012F)
  0x75, 0x83, 0x7D, 0xEC, 0x57, 0x77, 0x20, 0xAD, 0x07, 0x77, 0x70, 0x2E, 0x0E, 0x77, 0x70, 0x5F,
  0x02, 0x77, 0x60, 0x5F, 0x02, 0x77, 0x60, 0x2E, 0x0E, 0x77, 0x71, 0x0A, 0xD0, 0x77, 0x77, 0x28,
  0x37, 0xDE, 0xC5, 0x80, 0xAE, 0x70, 0x03, 0xFF, 0x90, 0xA7, 0x50, 0x3F, 0xF9, 0x0A, 0x75, 0x03,
  0xFF, 0x90, 0xA7, 0x58, 0x13, 0xDE, 0xFE, 0x0A, 0x77, 0x28, 0x61, 0x23, 0x56, 0x78, 0xDC, 0x0A,
  0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20,
  0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7,
  0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B,
  0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77,
  0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC,
  0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77,
  0x20, 0xBC, 0x0A, 0x77, 0x48, 0x41, 0x23, 0x46, 0xDC, 0x83, 0xC5, 0x43, 0x17, 0x84, 0x19, 0xAB,
  0xDE, 0xFF, 0xB8, 0x5E, 0xDC, 0xA9, 0x33, 0xFF, 0xFE, 0x06, 0x03, 0xFF, 0xFE, 0x06, 0x03, 0xFF,
  0xFE, 0x06, 0x77, 0x40, 0x8B, 0x07, 0x77, 0x72, 0x06, 0xB0, 0x97, 0x77, 0x20, 0x2B, 0x0C, 0x77,
  0x73, 0x0B, 0xB0, 0x37, 0x77, 0x20, 0x2B, 0x0D, 0x77, 0x73, 0x07, 0xB0, 0x97, 0x77, 0x30, 0x9B,
  0x09, 0x77, 0x73, 0x0B, 0xB0, 0xC7, 0x77, 0x30, 0x9C, 0x09, 0x02, 0x20, 0x37, 0x75, 0x06, 0xFA,
  0x02, 0x77, 0x50, 0xDF, 0x90, 0x27, 0x75, 0x03, 0x0E, 0xF0, 0x27, 0x76, 0x87, 0x18, 0xCE, 0xFE,
  0xC8, 0x13,
  // "İ" (U+0130)
  0x72, 0x84, 0x2A, 0xEE, 0xA2, 0x77, 0x30, 0x20, 0xEC, 0x0E, 0x02, 0x77, 0x20, 0x8E, 0x08, 0x77,
  0x20, 0xBE, 0x0B, 0x77, 0x20, 0xBE, 0x0B, 0x77, 0x20, 0x8E, 0x08, 0x77, 0x20, 0x20, 0xEC, 0x0E,
  0x02, 0x77, 0x38, 0x42, 0xAE, 0xEA, 0x28, 0x0A, 0xA5, 0x00, 0x6F, 0xFF, 0x90, 0x06, 0xFF, 0xF9,
  0x00, 0x6F, 0xFF, 0x90, 0x06, 0xFF, 0xF9, 0x89, 0x06, 0x14, 0x67, 0x8A, 0xBD, 0xEE, 0x87, 0xED,
  0xBA, 0x87, 0x64, 0x17, 0x20, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77,
  0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77,
  0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77,
  0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77,
  0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77,
  0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77,
  0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77,
  0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77,
  0x40, 0xBC, 0x09, 0x77, 0x40, 0xBC, 0x09, 0x77, 0x83, 0x13, 0x45, 0xDC, 0x83, 0xC5, 0x43, 0x15,
  0x82, 0x4B, 0xDE, 0xFF, 0xA8, 0x3E, 0xDB, 0x46, 0xFF, 0xF9, 0x00, 0x6F, 0xFF, 0x90, 0x06, 0xFF,
  0xF9, 0x06,
  // "ı" (U+0131)
  0x10, 0x3F, 0xF9, 0x0A, 0x75, 0x03, 0xFF, 0x90, 0xA7, 0x50, 0x3F, 0xF9, 0x0A, 0x75, 0x81, 0x3D,
  0xEF, 0xE0, 0xA7, 0x72, 0x86, 0x12, 0x35, 0x67, 0x8D, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77,
  0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC,
  0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77,
  0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0,
  0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72,
  0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A,
  0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x74, 0x84,
  0x12, 0x34, 0x6D, 0xC8, 0x3C, 0x54, 0x31, 0x78, 0x41, 0x9A, 0xBD, 0xEF, 0xFB, 0x85, 0xED, 0xCA,
  0x93, 0x3F, 0xFF, 0xE0, 0x60, 0x3F, 0xFF, 0xE0, 0x60, 0x3F, 0xFF, 0xE0, 0x60,
  // "Ĳ" (U+0132)
  0xD0, 0x67, 0x50, 0x6F, 0xB0, 0x67, 0x50, 0x6F, 0xB0, 0x67, 0x50, 0x6F, 0xB0, 0x67, 0x50, 0x6F,
  0xB0, 0x67, 0x50, 0x6F, 0xB0, 0x67, 0x50, 0x6F, 0xB0, 0x67, 0x50, 0x6F, 0xB0, 0x67, 0x50, 0x6F,
  0xB0, 0x67, 0x50, 0x6F, 0xB0, 0x67, 0x50, 0x6F, 0xB0, 0x67, 0x50, 0x6F, 0xB0, 0x67, 0x50, 0x6F,
  0xB0, 0x67, 0x50, 0x6F, 0xB0, 0x67, 0x50, 0x6F, 0xB0, 0x67, 0x50, 0x6F, 0xB0, 0x67, 0x50, 0x6F,
  0xB0, 0x67, 0x50, 0x6F, 0xB0, 0x67, 0x50, 0x6F, 0xB0, 0x67, 0x50, 0x6F, 0xB0, 0x67, 0x50, 0x6F,
  0xB0, 0x67, 0x50, 0x6F, 0xB0, 0x67, 0x50, 0x6F, 0xB0, 0x67, 0x50, 0x6F, 0xB0, 0x67, 0x50, 0x6F,
  0xB0, 0x67, 0x50, 0x6F, 0xB0, 0x67, 0x50, 0x6F, 0xB0, 0x67, 0x50, 0x6F, 0xB0, 0x67, 0x50, 0x6F,
  0xB0, 0x67, 0x50, 0x6F, 0xB0, 0x67, 0x50, 0x6F, 0xB0, 0x67, 0x50, 0x7C, 0x0E, 0x77, 0x40, 0x8C,
  0x0D, 0x77, 0x40, 0xAC, 0x0C, 0x77, 0x40, 0xEC, 0x09, 0x77, 0x30, 0x3D, 0x06, 0x77, 0x30, 0xBD,
  0x02, 0x77, 0x20, 0x7D, 0x82, 0xB0, 0x95, 0x76, 0x09, 0xE8, 0x13, 0x0D, 0xA8, 0x2B, 0x74, 0x25,
  0x81, 0x38, 0xEE, 0x09, 0x20, 0xDF, 0x0F, 0xEF, 0xA0, 0xC3, 0x0D, 0xFF, 0xC0, 0xA4, 0x0D, 0xFF,
  0xA0, 0xE0, 0x75, 0x82, 0x27, 0xBD, 0xFC, 0x0B, 0x06, 0x75, 0x87, 0x24, 0x56, 0x77, 0x65, 0x37,
  0x30,
  // "ĳ" (U+0133)
  0x18, 0x44, 0xBE, 0xD9, 0x17, 0x38, 0x61, 0x9D, 0xEB, 0x30, 0x5D, 0x0D, 0x73, 0x0C, 0xD0, 0x40,
  0xCE, 0x05, 0x71, 0x04, 0xE0, 0xCF, 0x08, 0x71, 0x07, 0xE0, 0x0E, 0xE0, 0x87, 0x10, 0x7E, 0x0E,
  0x0C, 0xE0, 0x57, 0x10, 0x4E, 0x0C, 0x04, 0xD0, 0xC7, 0x30, 0xCD, 0x86, 0x40, 0x3B, 0xED, 0x81,
  0x74, 0x83, 0x8D, 0xEB, 0x38, 0x0A, 0x96, 0x0D, 0x06, 0x73, 0x02, 0xD0, 0x31, 0xD0, 0x67, 0x30,
  0x2D, 0x03, 0x1D, 0x06, 0x73, 0x02, 0xD0, 0x31, 0xD0, 0x67, 0x30, 0x2D, 0x03, 0x1D, 0x06, 0x73,
  0x02, 0xD0, 0x31, 0xD0, 0x67, 0x30, 0x2D, 0x03, 0x1D, 0x06, 0x73, 0x02, 0xD0, 0x31, 0xD0, 0x67,
  0x30, 0x2D, 0x03, 0x1D, 0x06, 0x73, 0x02, 0xD0, 0x31, 0xD0, 0x67, 0x30, 0x2D, 0x03, 0x1D, 0x06,
  0x73, 0x02, 0xD0, 0x31, 0xD0, 0x67, 0x30, 0x2D, 0x03, 0x1D, 0x06, 0x73, 0x02, 0xD0, 0x31, 0xD0,
  0x67, 0x30, 0x2D, 0x03, 0x1D, 0x06, 0x73, 0x02, 0xD0, 0x31, 0xD0, 0x67, 0x30, 0x2D, 0x03, 0x1D,
  0x06, 0x73, 0x02, 0xD0, 0x31, 0xD0, 0x67, 0x30, 0x2D, 0x03, 0x1D, 0x06, 0x73, 0x02, 0xD0, 0x31,
  0xD0, 0x67, 0x30, 0x2D, 0x03, 0x1D, 0x06, 0x73, 0x02, 0xD0, 0x31, 0xD0, 0x67, 0x30, 0x2D, 0x03,
  0x1D, 0x06, 0x73, 0x02, 0xD0, 0x31, 0xD0, 0x67, 0x30, 0x2D, 0x03, 0x1D, 0x06, 0x73, 0x02, 0xD0,
  0x31, 0xD0, 0x67, 0x30, 0x2D, 0x03, 0x1D, 0x06, 0x73, 0x02, 0xD0, 0x31, 0xD0, 0x67, 0x30, 0x2D,
  0x03, 0x1D, 0x06, 0x73, 0x02, 0xD0, 0x31, 0xD0, 0x67, 0x30, 0x2D, 0x03, 0x1D, 0x06, 0x73, 0x02,
  0xD0, 0x31, 0xD0, 0x67, 0x30, 0x2D, 0x03, 0x77, 0x30, 0x2D, 0x03, 0x77, 0x30, 0x2D, 0x03, 0x77,
  0x30, 0x3D, 0x03, 0x77, 0x30, 0x4D, 0x02, 0x77, 0x30, 0x7D, 0x01, 0x77, 0x30, 0xCC, 0x0E, 0x77,
  0x30, 0x4D, 0x0A, 0x77, 0x20, 0x10, 0xDD, 0x05, 0x28, 0x11, 0x62, 0x73, 0x05, 0x0E, 0xD0, 0xC3,
  0x03, 0xA8, 0x90, 0xEB, 0x98, 0x76, 0x78, 0xAE, 0xF0, 0x33, 0x03, 0xFF, 0xC0, 0x54, 0x03, 0xFF,
  0xA0, 0xE0, 0x45, 0x03, 0xFF, 0x81, 0xE8, 0x17, 0x85, 0x25, 0x8A, 0xCD, 0xEA, 0x83, 0xED, 0xB8,
  0x57, 0x10,
  // "Ĵ" (U+0134)
  0x77, 0x28, 0x01, 0x70, 0x67, 0x77, 0x20, 0x6E, 0x04, 0x77, 0x70, 0x20, 0xEE, 0x0D, 0x01, 0x77,
  0x50, 0x10, 0xDF, 0x90, 0xB7, 0x75, 0x0B, 0xC0, 0xA0, 0xCC, 0x09, 0x77, 0x30, 0x9C, 0x82, 0x90,
  0x1C, 0xC0, 0x77, 0x71, 0x07, 0xC0, 0x93, 0x01, 0x0C, 0xC0, 0x67, 0x60, 0x6C, 0x08, 0x60, 0xBC,
  0x05, 0x74, 0x05, 0xC0, 0x77, 0x10, 0x9C, 0x04, 0x72, 0x01, 0xB0, 0xD0, 0x37, 0x30, 0x50, 0xEB,
  0x01, 0x80, 0xAC, 0x20, 0x07, 0xC0, 0xE7, 0x77, 0x30, 0x7C, 0x0E, 0x77, 0x73, 0x07, 0xC0, 0xE7,
  0x77, 0x30, 0x7C, 0x0E, 0x77, 0x73, 0x07, 0xC0, 0xE7, 0x77, 0x30, 0x7C, 0x0E, 0x77, 0x73, 0x07,
  0xC0, 0xE7, 0x77, 0x30, 0x7C, 0x0E, 0x77, 0x73, 0x07, 0xC0, 0xE7, 0x77, 0x30, 0x7C, 0x0E, 0x77,
  0x73, 0x07, 0xC0, 0xE7, 0x77, 0x30, 0x7C, 0x0E, 0x77, 0x73, 0x07, 0xC0, 0xE7, 0x77, 0x30, 0x7C,
  0x0E, 0x77, 0x73, 0x07, 0xC0, 0xE7, 0x77, 0x30, 0x7C, 0x0E, 0x77, 0x73, 0x07, 0xC0, 0xE7, 0x77,
  0x30, 0x7C, 0x0E, 0x77, 0x73, 0x07, 0xC0, 0xE7, 0x77, 0x30, 0x7C, 0x0E, 0x77, 0x73, 0x07, 0xC0,
  0xE7, 0x77, 0x30, 0x7C, 0x0E, 0x77, 0x73, 0x07, 0xC0, 0xE7, 0x77, 0x30, 0x7C, 0x0E, 0x77, 0x73,
  0x07, 0xC0, 0xE7, 0x77, 0x30, 0x7C, 0x0E, 0x77, 0x73, 0x07, 0xC0, 0xE7, 0x77, 0x30, 0x7C, 0x0E,
  0x77, 0x73, 0x07, 0xC0, 0xE7, 0x77, 0x30, 0x7C, 0x0E, 0x77, 0x73, 0x08, 0xC0, 0xD7, 0x77, 0x30,
  0x9C, 0x0C, 0x77, 0x73, 0x0B, 0xC0, 0xB7, 0x77, 0x30, 0xEC, 0x08, 0x77, 0x72, 0x03, 0xD0, 0x57,
  0x77, 0x20, 0xAD, 0x01, 0x77, 0x71, 0x05, 0xD0, 0xB7, 0x20, 0x80, 0x37, 0x40, 0x5E, 0x04, 0x72,
  0xA8, 0x2D, 0x96, 0x34, 0x81, 0x15, 0xBE, 0x0A, 0x73, 0xF9, 0x0E, 0xFA, 0x0D, 0x01, 0x73, 0xFF,
  0xB0, 0xD0, 0x27, 0x4F, 0xFA, 0x0A, 0x01, 0x75, 0x82, 0x27, 0xBE, 0xFA, 0x81, 0xE9, 0x37, 0x74,
  0x87, 0x13, 0x56, 0x77, 0x65, 0x27, 0x73,
  // "ĵ" (U+0135)
  0x77, 0x80, 0x17, 0x06, 0x77, 0x70, 0x6E, 0x04, 0x77, 0x50, 0x20, 0xEE, 0x0D, 0x01, 0x77, 0x30,
  0x10, 0xDF, 0x90, 0xB7, 0x73, 0x0B, 0xC0, 0xA0, 0xCC, 0x09, 0x77, 0x10, 0x9C, 0x82, 0x90, 0x1C,
  0xC0, 0x77, 0x60, 0x7C, 0x09, 0x30, 0x10, 0xCC, 0x06, 0x74, 0x06, 0xC0, 0x86, 0x0B, 0xC0, 0x57,
  0x20, 0x5C, 0x07, 0x71, 0x09, 0xC0, 0x47, 0x01, 0xB0, 0xD0, 0x37, 0x30, 0x50, 0xEB, 0x01, 0x80,
  0xA9, 0x40, 0x01, 0xFF, 0x90, 0xC7, 0x40, 0x1F, 0xF9, 0x0C, 0x74, 0x01, 0xFF, 0x90, 0xC7, 0x40,
  0x1F, 0xF9, 0x0C, 0x77, 0x87, 0x13, 0x45, 0x67, 0x89, 0xDC, 0x0C, 0x77, 0x71, 0x09, 0xC0, 0xC7,
  0x77, 0x10, 0x9C, 0x0C, 0x77, 0x71, 0x09, 0xC0, 0xC7, 0x77, 0x10, 0x9C, 0x0C, 0x77, 0x71, 0x09,
  0xC0, 0xC7, 0x77, 0x10, 0x9C, 0x0C, 0x77, 0x71, 0x09, 0xC0, 0xC7, 0x77, 0x10, 0x9C, 0x0C, 0x77,
  0x71, 0x09, 0xC0, 0xC7, 0x77, 0x10, 0x9C, 0x0C, 0x77, 0x71, 0x09, 0xC0, 0xC7, 0x77, 0x10, 0x9C,
  0x0C, 0x77, 0x71, 0x09, 0xC0, 0xC7, 0x77, 0x10, 0x9C, 0x0C, 0x77, 0x71, 0x09, 0xC0, 0xC7, 0x77,
  0x10, 0x9C, 0x0C, 0x77, 0x71, 0x09, 0xC0, 0xC7, 0x77, 0x10, 0x9C, 0x0C, 0x77, 0x71, 0x09, 0xC0,
  0xC7, 0x77, 0x10, 0x9C, 0x0C, 0x77, 0x71, 0x09, 0xC0, 0xC7, 0x77, 0x10, 0x9C, 0x0C, 0x77, 0x71,
  0x09, 0xC0, 0xC7, 0x77, 0x10, 0x9C, 0x0C, 0x77, 0x71, 0x09, 0xC0, 0xC7, 0x77, 0x10, 0x9C, 0x0C,
  0x77, 0x71, 0x09, 0xC0, 0xC7, 0x77, 0x10, 0x9C, 0x0C, 0x77, 0x71, 0x09, 0xC0, 0xC7, 0x77, 0x10,
  0x9C, 0x0C, 0x77, 0x71, 0x0A, 0xC0, 0xB7, 0x77, 0x10, 0xDC, 0x0A, 0x77, 0x70, 0x2D, 0x08, 0x77,
  0x70, 0x8D, 0x04, 0x77, 0x60, 0x3D, 0x0E, 0x71, 0x81, 0x35, 0x17, 0x20, 0x6E, 0x07, 0x71, 0x06,
  0xA8, 0x7D, 0xA8, 0x76, 0x67, 0xAE, 0xE0, 0xD7, 0x20, 0x6F, 0xFA, 0x0E, 0x02, 0x72, 0x06, 0xFF,
  0x90, 0xC0, 0x27, 0x30, 0x6F, 0xE0, 0xE0, 0x77, 0x68, 0x43, 0x69, 0xBC, 0xEA, 0x83, 0xED, 0xB8,
  0x47, 0x70,
  // "Ķ" (U+0136)
  0x0C, 0xC0, 0x97, 0x71, 0x02, 0x0E, 0xC8, 0x1E, 0x2C, 0xC0, 0x97, 0x71, 0x0C, 0xD8, 0x15, 0x0C,
  0xC0, 0x97, 0x70, 0x8D, 0x09, 0x20, 0xCC, 0x09, 0x76, 0x04, 0xD0, 0xD3, 0x0C, 0xC0, 0x97, 0x50,
  0x10, 0xED, 0x03, 0x30, 0xCC, 0x09, 0x75, 0x0B, 0xD0, 0x74, 0x0C, 0xC0, 0x97, 0x40, 0x7D, 0x0B,
  0x50, 0xCC, 0x09, 0x73, 0x03, 0xD0, 0xE0, 0x15, 0x0C, 0xC0, 0x97, 0x20, 0x10, 0xDD, 0x04, 0x60,
  0xCC, 0x09, 0x72, 0x0A, 0xD0, 0x87, 0x0C, 0xC0, 0x97, 0x10, 0x6D, 0x0C, 0x71, 0x0C, 0xC0, 0x97,
  0x03, 0xD0, 0xE0, 0x27, 0x10, 0xCC, 0x09, 0x70, 0xDD, 0x06, 0x72, 0x0C, 0xC0, 0x96, 0x0A, 0xD0,
  0xA7, 0x30, 0xCC, 0x09, 0x50, 0x6D, 0x0D, 0x01, 0x73, 0x0C, 0xC0, 0x94, 0x02, 0x0E, 0xD0, 0x37,
  0x40, 0xCC, 0x09, 0x40, 0xCD, 0x07, 0x75, 0x0C, 0xC0, 0x93, 0x08, 0xD0, 0xB7, 0x60, 0xCC, 0x09,
  0x20, 0x3D, 0x0E, 0x01, 0x76, 0x0C, 0xC0, 0x92, 0x0D, 0xD0, 0x57, 0x70, 0xCC, 0x81, 0x90, 0x9E,
  0x09, 0x77, 0x0C, 0xC0, 0x90, 0x3F, 0x90, 0x37, 0x60, 0xCC, 0x09, 0x0C, 0xF9, 0x0D, 0x76, 0x0C,
  0xC0, 0xEC, 0x0B, 0xD0, 0x77, 0x50, 0xCF, 0x98, 0x17, 0x0C, 0xD0, 0x27, 0x40, 0xCF, 0x09, 0x20,
  0x3D, 0x0C, 0x74, 0x0C, 0xE0, 0xA4, 0x09, 0xD0, 0x67, 0x30, 0xCD, 0x0C, 0x60, 0xDC, 0x0E, 0x01,
  0x72, 0x0C, 0xC0, 0xD0, 0x16, 0x05, 0xD0, 0xB7, 0x20, 0xCC, 0x09, 0x71, 0x0A, 0xD0, 0x57, 0x10,
  0xCC, 0x09, 0x71, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x0C, 0xC0, 0x97, 0x20, 0x6D, 0x09, 0x70, 0xCC,
  0x09, 0x73, 0x0C, 0xD0, 0x46, 0x0C, 0xC0, 0x97, 0x30, 0x2D, 0x0D, 0x60, 0xCC, 0x09, 0x74, 0x08,
  0xD0, 0x85, 0x0C, 0xC0, 0x97, 0x50, 0xDD, 0x03, 0x40, 0xCC, 0x09, 0x75, 0x04, 0xD0, 0xC4, 0x0C,
  0xC0, 0x97, 0x60, 0xAD, 0x07, 0x30, 0xCC, 0x09, 0x76, 0x01, 0x0E, 0xD0, 0x22, 0x0C, 0xC0, 0x97,
  0x70, 0x6D, 0x0B, 0x20, 0xCC, 0x09, 0x77, 0x10, 0xBD, 0x81, 0x60, 0xCC, 0x09, 0x77, 0x10, 0x2D,
  0x81, 0xE1, 0xCC, 0x09, 0x77, 0x20, 0x7D, 0x0A, 0x80, 0x9B, 0x70, 0x09, 0xC0, 0xA7, 0x77, 0x20,
  0xBC, 0x05, 0x77, 0x72, 0x0E, 0xB0, 0xE7, 0x77, 0x20, 0x2C, 0x09, 0x77, 0x72, 0x06, 0xC0, 0x27,
  0x77, 0x20, 0xBB, 0x09, 0x77, 0x73, 0x0E, 0xB0, 0x27, 0x77, 0x20, 0x4B, 0x08, 0x77, 0x73, 0x0A,
  0xA0, 0xD0, 0x17, 0x77, 0x3B, 0x04, 0x77, 0x10,
  // "ķ" (U+0137)
  0x0A, 0xC0, 0xA7, 0x77, 0x10, 0xAC, 0x0A, 0x77, 0x71, 0x0A, 0xC0, 0xA7, 0x77, 0x10, 0xAC, 0x0A,
  0x77, 0x71, 0x0A, 0xC0, 0xA7, 0x77, 0x10, 0xAC, 0x0A, 0x77, 0x71, 0x0A, 0xC0, 0xA7, 0x77, 0x10,
  0xAC, 0x0A, 0x77, 0x71, 0x0A, 0xC0, 0xA7, 0x77, 0x10, 0xAC, 0x0A, 0x77, 0x71, 0x0A, 0xC0, 0xA7,
  0x77, 0x10, 0xAC, 0x0A, 0x77, 0x71, 0x0A, 0xC0, 0xA7, 0x77, 0x10, 0xAC, 0x0A, 0x77, 0x71, 0x0A,
  0xC0, 0xA7, 0x70, 0x8D, 0x81, 0xC1, 0xAC, 0x0A, 0x76, 0x07, 0xD8, 0x2D, 0x10, 0xAC, 0x0A, 0x75,
  0x05, 0xD0, 0xE0, 0x22, 0x0A, 0xC0, 0xA7, 0x40, 0x4D, 0x0E, 0x02, 0x30, 0xAC, 0x0A, 0x73, 0x03,
  0x0E, 0xD0, 0x34, 0x0A, 0xC0, 0xA7, 0x20, 0x20, 0xED, 0x04, 0x50, 0xAC, 0x0A, 0x71, 0x01, 0x0D,
  0xD0, 0x56, 0x0A, 0xC0, 0xA7, 0x01, 0x0C, 0xD0, 0x67, 0x0A, 0xC0, 0xA7, 0x0B, 0xD0, 0x87, 0x10,
  0xAC, 0x0A, 0x60, 0xAD, 0x09, 0x72, 0x0A, 0xC0, 0xA5, 0x09, 0xD0, 0xA7, 0x30, 0xAC, 0x09, 0x40,
  0x7D, 0x0B, 0x74, 0x0A, 0xC0, 0x83, 0x06, 0xD0, 0xC7, 0x50, 0xAC, 0x07, 0x20, 0x4D, 0x0D, 0x01,
  0x75, 0x0A, 0xC8, 0x27, 0x02, 0xED, 0x0E, 0x01, 0x75, 0x0A, 0xC8, 0x16, 0x1D, 0xF0, 0xC7, 0x50,
  0xAC, 0x05, 0x0B, 0xFA, 0x08, 0x74, 0x0A, 0xC0, 0xCC, 0x07, 0x0A, 0xD0, 0x47, 0x30, 0xAF, 0x90,
  0x62, 0x0D, 0xC0, 0xE0, 0x17, 0x20, 0xAF, 0x06, 0x30, 0x3D, 0x0C, 0x72, 0x0A, 0xE0, 0x55, 0x07,
  0xD0, 0x87, 0x10, 0xAD, 0x05, 0x70, 0xBD, 0x04, 0x70, 0xAC, 0x0A, 0x71, 0x01, 0x0E, 0xC0, 0xE0,
  0x26, 0x0A, 0xC0, 0xA7, 0x20, 0x4D, 0x0C, 0x60, 0xAC, 0x0A, 0x73, 0x08, 0xD0, 0x85, 0x0A, 0xC0,
  0xA7, 0x40, 0xCD, 0x05, 0x40, 0xAC, 0x0A, 0x74, 0x02, 0x0E, 0xC0, 0xE0, 0x23, 0x0A, 0xC0, 0xA7,
  0x50, 0x5D, 0x0C, 0x30, 0xAC, 0x0A, 0x76, 0x09, 0xD0, 0x82, 0x0A, 0xC0, 0xA7, 0x70, 0xDD, 0x81,
  0x50, 0xAC, 0x0A, 0x77, 0x02, 0xD8, 0x1E, 0x2A, 0xC0, 0xA7, 0x71, 0x06, 0xD0, 0xC8, 0x09, 0xB3,
  0x00, 0x9C, 0x0A, 0x77, 0x71, 0x0B, 0xC0, 0x57, 0x77, 0x10, 0xEB, 0x0E, 0x77, 0x71, 0x02, 0xC0,
  0x97, 0x77, 0x10, 0x6C, 0x02, 0x77, 0x71, 0x0B, 0xB0, 0x97, 0x77, 0x20, 0xEB, 0x02, 0x77, 0x71,
  0x04, 0xB0, 0x87, 0x77, 0x20, 0xAA, 0x0D, 0x01, 0x77, 0x72, 0xB0, 0x47, 0x71,
  // "ĸ" (U+0138)
  0x0A, 0xC0, 0xA7, 0x70, 0x8D, 0x81, 0xC1, 0xAC, 0x0A, 0x76, 0x07, 0xD8, 0x2D, 0x10, 0xAC, 0x0A,
  0x75, 0x05, 0xD0, 0xE0, 0x22, 0x0A, 0xC0, 0xA7, 0x40, 0x4D, 0x0E, 0x02, 0x30, 0xAC, 0x0A, 0x73,
  0x03, 0x0E, 0xD0, 0x34, 0x0A, 0xC0, 0xA7, 0x20, 0x20, 0xED, 0x04, 0x50, 0xAC, 0x0A, 0x71, 0x01,
  0x0D, 0xD0, 0x56, 0x0A, 0xC0, 0xA7, 0x01, 0x0C, 0xD0, 0x67, 0x0A, 0xC0, 0xA7, 0x0B, 0xD0, 0x87,
  0x10, 0xAC, 0x0A, 0x60, 0xAD, 0x09, 0x72, 0x0A, 0xC0, 0xA5, 0x09, 0xD0, 0xA7, 0x30, 0xAC, 0x09,
  0x40, 0x7D, 0x0B, 0x74, 0x0A, 0xC0, 0x83, 0x06, 0xD0, 0xC7, 0x50, 0xAC, 0x07, 0x20, 0x4D, 0x0D,
  0x01, 0x75, 0x0A, 0xC8, 0x27, 0x02, 0xED, 0x0E, 0x01, 0x75, 0x0A, 0xC8, 0x16, 0x1D, 0xF0, 0xC7,
  0x50, 0xAC, 0x05, 0x0B, 0xFA, 0x08, 0x74, 0x0A, 0xC0, 0xCC, 0x07, 0x0A, 0xD0, 0x47, 0x30, 0xAF,
  0x90, 0x62, 0x0D, 0xC0, 0xE0, 0x17, 0x20, 0xAF, 0x06, 0x30, 0x3D, 0x0C, 0x72, 0x0A, 0xE0, 0x55,
  0x07, 0xD0, 0x87, 0x10, 0xAD, 0x05, 0x70, 0xBD, 0x04, 0x70, 0xAC, 0x0A, 0x71, 0x01, 0x0E, 0xC0,
  0xE0, 0x26, 0x0A, 0xC0, 0xA7, 0x20, 0x4D, 0x0C, 0x60, 0xAC, 0x0A, 0x73, 0x08, 0xD0, 0x85, 0x0A,
  0xC0, 0xA7, 0x40, 0xCD, 0x05, 0x40, 0xAC, 0x0A, 0x74, 0x02, 0x0E, 0xC0, 0xE0, 0x23, 0x0A, 0xC0,
  0xA7, 0x50, 0x5D, 0x0C, 0x30, 0xAC, 0x0A, 0x76, 0x09, 0xD0, 0x82, 0x0A, 0xC0, 0xA7, 0x70, 0xDD,
  0x81, 0x50, 0xAC, 0x0A, 0x77, 0x02, 0xD8, 0x1E, 0x2A, 0xC0, 0xA7, 0x71, 0x06, 0xD0, 0xC0,
  // "Ĺ" (U+0139)
  0x70, 0x58, 0x01, 0x70, 0x67, 0x73, 0x01, 0xE0, 0x97, 0x73, 0x0A, 0xD0, 0xC7, 0x73, 0x04, 0xD0,
  0xD0, 0x17, 0x73, 0x0D, 0xC0, 0xE0, 0x27, 0x73, 0x08, 0xC0, 0xE0, 0x27, 0x73, 0x03, 0xC0, 0xE0,
  0x37, 0x74, 0x0D, 0xB0, 0xE0, 0x37, 0x74, 0x09, 0xB0, 0xD0, 0x27, 0x74, 0x03, 0xB0, 0xB0, 0x18,
  0x0A, 0x93, 0x00, 0x1D, 0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40, 0x1D,
  0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40, 0x1D,
  0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40, 0x1D,
  0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40, 0x1D,
  0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40, 0x1D,
  0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40, 0x1D,
  0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40, 0x1D,
  0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40, 0x1D,
  0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40, 0x1D,
  0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40, 0x1D, 0x09, 0x80, 0x95, 0x60,
  0x50, 0x1F, 0xFF, 0xA0, 0xE0, 0x1F, 0xFF, 0xA0, 0xE0, 0x1F, 0xFF, 0xA0, 0xE0, 0x1F, 0xFF, 0xA0,
  0xE0,
  // "ĺ" (U+013A)
  0x77, 0x30, 0x58, 0x01, 0x70, 0x67, 0x77, 0x01, 0xE0, 0x97, 0x77, 0x0A, 0xD0, 0xC7, 0x77, 0x04,
  0xD0, 0xD0, 0x17, 0x77, 0x0D, 0xC0, 0xE0, 0x27, 0x77, 0x08, 0xC0, 0xE0, 0x27, 0x77, 0x03, 0xC0,
  0xE0, 0x37, 0x77, 0x10, 0xDB, 0x0E, 0x03, 0x77, 0x71, 0x09, 0xB0, 0xD0, 0x27, 0x77, 0x10, 0x3B,
  0x0B, 0x01, 0x80, 0x9F, 0x50, 0x0D, 0xFF, 0x90, 0xE7, 0x50, 0xDF, 0xF9, 0x0E, 0x75, 0x0D, 0xFF,
  0x90, 0xE7, 0x50, 0xDF, 0xF9, 0x0E, 0x75, 0x05, 0x80, 0x66, 0x0A, 0xC0, 0xE7, 0x77, 0x20, 0x6C,
  0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7, 0x77,
  0x20, 0x6C, 0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x72, 0x06, 0xC0,
  0xE7, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x72,
  0x06, 0xC0, 0xE7, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7, 0x77, 0x20, 0x6C, 0x0E,
  0x77, 0x72, 0x06, 0xC0, 0xE7, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7, 0x77, 0x20,
  0x6C, 0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7,
  0x77, 0x20, 0x6C, 0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x72, 0x06,
  0xC0, 0xE7, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7, 0x77, 0x20, 0x6C, 0x0E, 0x77,
  0x72, 0x06, 0xC0, 0xE7, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7, 0x77, 0x20, 0x6C,
  0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7, 0x74,
  0x84, 0x12, 0x34, 0x5A, 0xD8, 0x26, 0x43, 0x27, 0x84, 0x19, 0xAB, 0xCE, 0xFF, 0xC8, 0x4D, 0xCB,
  0x93, 0x3F, 0xFF, 0xE0, 0x60, 0x3F, 0xFF, 0xE0, 0x60, 0x3F, 0xFF, 0xE0, 0x60,
  // "Ļ" (U+013B)
  0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74,
  0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74,
  0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74,
  0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74,
  0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74,
  0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74,
  0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74,
  0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74,
  0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74,
  0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x98, 0x09, 0x56, 0x05, 0x01, 0xFF,
  0xFA, 0x0E, 0x01, 0xFF, 0xFA, 0x0E, 0x01, 0xFF, 0xFA, 0x0E, 0x01, 0xFF, 0xFA, 0x0E, 0x80, 0x9A,
  0x20, 0x09, 0xC0, 0xA7, 0x75, 0x0B, 0xC0, 0x57, 0x75, 0x0E, 0xB0, 0xE7, 0x75, 0x02, 0xC0, 0x97,
  0x75, 0x06, 0xC0, 0x27, 0x75, 0x0B, 0xB0, 0x97, 0x76, 0x0E, 0xB0, 0x27, 0x75, 0x04, 0xB0, 0x87,
  0x76, 0x0A, 0xA0, 0xD0, 0x17, 0x76, 0xB0, 0x47, 0x50,
  // "ļ" (U+013C)
  0x10, 0xDF, 0xF9, 0x0E, 0x75, 0x0D, 0xFF, 0x90, 0xE7, 0x50, 0xDF, 0xF9, 0x0E, 0x75, 0x0D, 0xFF,
  0x90, 0xE7, 0x50, 0x58, 0x06, 0x60, 0xAC, 0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7, 0x77, 0x20, 0x6C,
  0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7, 0x77,
  0x20, 0x6C, 0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x72, 0x06, 0xC0,
  0xE7, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x72,
  0x06, 0xC0, 0xE7, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7, 0x77, 0x20, 0x6C, 0x0E,
  0x77, 0x72, 0x06, 0xC0, 0xE7, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7, 0x77, 0x20,
  0x6C, 0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7,
  0x77, 0x20, 0x6C, 0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x72, 0x06,
  0xC0, 0xE7, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7, 0x77, 0x20, 0x6C, 0x0E, 0x77,
  0x72, 0x06, 0xC0, 0xE7, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7, 0x77, 0x20, 0x6C,
  0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x48, 0x41, 0x23, 0x45, 0xAD,
  0x82, 0x64, 0x32, 0x78, 0x41, 0x9A, 0xBC, 0xEF, 0xFC, 0x84, 0xDC, 0xB9, 0x33, 0xFF, 0xFE, 0x06,
  0x03, 0xFF, 0xFE, 0x06, 0x03, 0xFF, 0xFE, 0x06, 0x80, 0x9B, 0x70, 0x09, 0xC0, 0xA7, 0x77, 0x20,
  0xBC, 0x05, 0x77, 0x72, 0x0E, 0xB0, 0xE7, 0x77, 0x20, 0x2C, 0x09, 0x77, 0x72, 0x06, 0xC0, 0x27,
  0x77, 0x20, 0xBB, 0x09, 0x77, 0x73, 0x0E, 0xB0, 0x27, 0x77, 0x20, 0x4B, 0x08, 0x77, 0x73, 0x0A,
  0xA0, 0xD0, 0x17, 0x77, 0x3B, 0x04, 0x77, 0x10,
  // "Ľ" (U+013D)
  0x01, 0xD0, 0x47, 0x5D, 0x03, 0x01, 0xD0, 0x47, 0x40, 0x2C, 0x81, 0xE0, 0x1D, 0x04, 0x74, 0x05,
  0xC8, 0x19, 0x01, 0xD0, 0x47, 0x40, 0x8C, 0x81, 0x30, 0x1D, 0x04, 0x74, 0x0B, 0xB0, 0xC2, 0x01,
  0xD0, 0x47, 0x40, 0xEB, 0x05, 0x20, 0x1D, 0x04, 0x73, 0x02, 0xB0, 0xD3, 0x01, 0xD0, 0x47, 0x30,
  0x6B, 0x05, 0x30, 0x1D, 0x04, 0x73, 0x0B, 0xA0, 0xC4, 0x01, 0xD0, 0x47, 0x30, 0xEA, 0x03, 0x40,
  0x1D, 0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40,
  0x1D, 0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40,
  0x1D, 0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40,
  0x1D, 0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40,
  0x1D, 0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40,
  0x1D, 0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40,
  0x1D, 0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40, 0x1D, 0x04, 0x77, 0x40,
  0x1D, 0x09, 0x80, 0x95, 0x60, 0x50, 0x1F, 0xFF, 0xA0, 0xE0, 0x1F, 0xFF, 0xA0, 0xE0, 0x1F, 0xFF,
  0xA0, 0xE0, 0x1F, 0xFF, 0xA0, 0xE0,
  // "ľ" (U+013E)
  0x10, 0xDF, 0xF9, 0x0E, 0x60, 0x7C, 0x81, 0xB0, 0xDF, 0xF9, 0x0E, 0x60, 0x9C, 0x81, 0x70, 0xDF,
  0xF9, 0x0E, 0x60, 0xCC, 0x81, 0x20, 0xDF, 0xF9, 0x0E, 0x6C, 0x0B, 0x20, 0x58, 0x06, 0x60, 0xAC,
  0x0E, 0x50, 0x3C, 0x04, 0x76, 0x06, 0xC0, 0xE5, 0x06, 0xB0, 0xD7, 0x70, 0x6C, 0x0E, 0x50, 0x9B,
  0x06, 0x77, 0x06, 0xC0, 0xE5, 0x0D, 0xA0, 0xD7, 0x71, 0x06, 0xC0, 0xE4, 0x02, 0xB0, 0x57, 0x71,
  0x06, 0xC0, 0xE4, 0x06, 0xA0, 0xB7, 0x72, 0x06, 0xC0, 0xE7, 0x77, 0x30, 0x6C, 0x0E, 0x77, 0x73,
  0x06, 0xC0, 0xE7, 0x77, 0x30, 0x6C, 0x0E, 0x77, 0x73, 0x06, 0xC0, 0xE7, 0x77, 0x30, 0x6C, 0x0E,
  0x77, 0x73, 0x06, 0xC0, 0xE7, 0x77, 0x30, 0x6C, 0x0E, 0x77, 0x73, 0x06, 0xC0, 0xE7, 0x77, 0x30,
  0x6C, 0x0E, 0x77, 0x73, 0x06, 0xC0, 0xE7, 0x77, 0x30, 0x6C, 0x0E, 0x77, 0x73, 0x06, 0xC0, 0xE7,
  0x77, 0x30, 0x6C, 0x0E, 0x77, 0x73, 0x06, 0xC0, 0xE7, 0x77, 0x30, 0x6C, 0x0E, 0x77, 0x73, 0x06,
  0xC0, 0xE7, 0x77, 0x30, 0x6C, 0x0E, 0x77, 0x73, 0x06, 0xC0, 0xE7, 0x77, 0x30, 0x6C, 0x0E, 0x77,
  0x73, 0x06, 0xC0, 0xE7, 0x77, 0x30, 0x6C, 0x0E, 0x77, 0x73, 0x06, 0xC0, 0xE7, 0x77, 0x30, 0x6C,
  0x0E, 0x77, 0x73, 0x06, 0xC0, 0xE7, 0x77, 0x30, 0x6C, 0x0E, 0x77, 0x73, 0x06, 0xC0, 0xE7, 0x77,
  0x30, 0x6C, 0x0E, 0x77, 0x73, 0x06, 0xC0, 0xE7, 0x77, 0x30, 0x6C, 0x0E, 0x77, 0x73, 0x06, 0xC0,
  0xE7, 0x75, 0x84, 0x12, 0x34, 0x5A, 0xD8, 0x26, 0x43, 0x27, 0x18, 0x41, 0x9A, 0xBC, 0xEF, 0xFC,
  0x85, 0xDC, 0xB9, 0x30, 0x3F, 0xFF, 0xE8, 0x16, 0x03, 0xFF, 0xFE, 0x81, 0x60, 0x3F, 0xFF, 0xE0,
  0x61,
  // "Ŀ" (U+013F)
  0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74,
  0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74,
  0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74,
  0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74,
  0x01, 0xD0, 0x47, 0x58, 0x23, 0x66, 0x32, 0x01, 0xD0, 0x47, 0x40, 0xAC, 0x81, 0xA0, 0x1D, 0x04,
  0x73, 0x05, 0xE0, 0x50, 0x1D, 0x04, 0x73, 0x09, 0xE0, 0x90, 0x1D, 0x04, 0x73, 0x0A, 0xE0, 0xA0,
  0x1D, 0x04, 0x73, 0x09, 0xE0, 0x90, 0x1D, 0x04, 0x73, 0x05, 0xE0, 0x50, 0x1D, 0x04, 0x74, 0x09,
  0xC8, 0x19, 0x01, 0xD0, 0x47, 0x58, 0x23, 0x66, 0x32, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47,
  0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47,
  0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47,
  0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0x98,
  0x09, 0x56, 0x05, 0x01, 0xFF, 0xFA, 0x0E, 0x01, 0xFF, 0xFA, 0x0E, 0x01, 0xFF, 0xFA, 0x0E, 0x01,
  0xFF, 0xFA, 0x0E,
  // "ŀ" (U+0140)
  0x10, 0xDF, 0xF9, 0x0E, 0x77, 0x50, 0xDF, 0xF9, 0x0E, 0x77, 0x50, 0xDF, 0xF9, 0x0E, 0x77, 0x50,
  0xDF, 0xF9, 0x0E, 0x77, 0x50, 0x58, 0x06, 0x60, 0xAC, 0x0E, 0x77, 0x77, 0x20, 0x6C, 0x0E, 0x77,
  0x77, 0x20, 0x6C, 0x0E, 0x77, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x77,
  0x20, 0x6C, 0x0E, 0x77, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x77, 0x20,
  0x6C, 0x0E, 0x77, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x77, 0x20, 0x6C,
  0x0E, 0x77, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x77, 0x20, 0x6C, 0x0E, 0x75, 0x82, 0x36, 0x63, 0x77,
  0x06, 0xC0, 0xE7, 0x40, 0xAC, 0x0A, 0x76, 0x06, 0xC0, 0xE7, 0x30, 0x5E, 0x05, 0x75, 0x06, 0xC0,
  0xE7, 0x30, 0x9E, 0x09, 0x75, 0x06, 0xC0, 0xE7, 0x30, 0xAE, 0x0A, 0x75, 0x06, 0xC0, 0xE7, 0x30,
  0x9E, 0x09, 0x75, 0x06, 0xC0, 0xE7, 0x30, 0x5E, 0x05, 0x75, 0x06, 0xC0, 0xE7, 0x40, 0x9C, 0x09,
  0x76, 0x06, 0xC0, 0xE7, 0x58, 0x23, 0x66, 0x37, 0x70, 0x6C, 0x0E, 0x77, 0x77, 0x20, 0x6C, 0x0E,
  0x77, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x77, 0x20, 0x6C, 0x0E, 0x77,
  0x77, 0x20, 0x6C, 0x0E, 0x77, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x77,
  0x20, 0x6C, 0x0E, 0x77, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x77, 0x20,
  0x6C, 0x0E, 0x77, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x77, 0x20, 0x6C,
  0x0E, 0x77, 0x74, 0x84, 0x12, 0x34, 0x5A, 0xD8, 0x26, 0x43, 0x27, 0x78, 0x41, 0x9A, 0xBC, 0xEF,
  0xFC, 0x83, 0xDC, 0xB9, 0x37, 0x03, 0xFF, 0xFE, 0x06, 0x70, 0x3F, 0xFF, 0xE0, 0x67, 0x03, 0xFF,
  0xFE, 0x06, 0x70,
  // "Ł" (U+0141)
  0x60, 0xAC, 0x0A, 0x77, 0x74, 0x0A, 0xC0, 0xA7, 0x77, 0x40, 0xAC, 0x0A, 0x77, 0x74, 0x0A, 0xC0,
  0xA7, 0x77, 0x40, 0xAC, 0x0A, 0x77, 0x74, 0x0A, 0xC0, 0xA7, 0x77, 0x40, 0xAC, 0x0A, 0x77, 0x74,
  0x0A, 0xC0, 0xA7, 0x77, 0x40, 0xAC, 0x0A, 0x77, 0x74, 0x0A, 0xC0, 0xA7, 0x77, 0x40, 0xAC, 0x0A,
  0x77, 0x74, 0x0A, 0xC0, 0xA7, 0x77, 0x40, 0xAC, 0x0A, 0x77, 0x74, 0x0A, 0xC0, 0xA7, 0x77, 0x40,
  0xAC, 0x0A, 0x77, 0x74, 0x0A, 0xC0, 0xA7, 0x77, 0x40, 0xAC, 0x0A, 0x58, 0x12, 0xB3, 0x77, 0x30,
  0xAC, 0x0A, 0x40, 0x8A, 0x0B, 0x77, 0x30, 0xAC, 0x0A, 0x20, 0x50, 0xEC, 0x04, 0x77, 0x20, 0xAC,
  0x81, 0xA2, 0xBE, 0x0D, 0x77, 0x20, 0xAC, 0x0E, 0xF0, 0xB0, 0x27, 0x72, 0x0A, 0xFB, 0x0D, 0x04,
  0x77, 0x40, 0xAF, 0x90, 0xE0, 0x77, 0x75, 0x01, 0x0C, 0xF0, 0x90, 0x17, 0x75, 0x06, 0x0E, 0xE0,
  0xC0, 0x37, 0x75, 0x03, 0x0C, 0xF0, 0xB7, 0x75, 0x01, 0x09, 0xFA, 0x0A, 0x77, 0x50, 0x8F, 0xB0,
  0xA7, 0x76, 0x0E, 0xB0, 0x0D, 0xC0, 0xA7, 0x76, 0x84, 0x5F, 0xE7, 0x0A, 0xC0, 0xA7, 0x77, 0x08,
  0x01, 0x20, 0xAC, 0x0A, 0x77, 0x74, 0x0A, 0xC0, 0xA7, 0x77, 0x40, 0xAC, 0x0A, 0x77, 0x74, 0x0A,
  0xC0, 0xA7, 0x77, 0x40, 0xAC, 0x0A, 0x77, 0x74, 0x0A, 0xC0, 0xA7, 0x77, 0x40, 0xAC, 0x0A, 0x77,
  0x74, 0x0A, 0xC0, 0xA7, 0x77, 0x40, 0xAC, 0x0C, 0x80, 0x96, 0x60, 0x16, 0x0A, 0xFF, 0xFA, 0x04,
  0x60, 0xAF, 0xFF, 0xA0, 0x46, 0x0A, 0xFF, 0xFA, 0x04, 0x60, 0xAF, 0xFF, 0xA0, 0x40,
  // "ł" (U+0142)
  0x10, 0xDF, 0xF9, 0x0E, 0x75, 0x0D, 0xFF, 0x90, 0xE7, 0x50, 0xDF, 0xF9, 0x0E, 0x75, 0x0D, 0xFF,
  0x90, 0xE7, 0x50, 0x58, 0x06, 0x60, 0xAC, 0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7, 0x77, 0x20, 0x6C,
  0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7, 0x77,
  0x20, 0x6C, 0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x72, 0x06, 0xC0,
  0xE7, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x72,
  0x06, 0xC0, 0xE3, 0x81, 0x19, 0x67, 0x73, 0x06, 0xC0, 0xE2, 0x83, 0x5E, 0xFE, 0x17, 0x72, 0x06,
  0xC8, 0x1E, 0x2B, 0xC0, 0xA7, 0x72, 0x06, 0xFC, 0x0E, 0x02, 0x77, 0x10, 0x6F, 0xB0, 0xA0, 0x17,
  0x72, 0x06, 0xF9, 0x0D, 0x04, 0x77, 0x40, 0x9F, 0x07, 0x77, 0x40, 0x30, 0xCE, 0x0B, 0x02, 0x77,
  0x30, 0x10, 0x9F, 0x0E, 0x77, 0x40, 0x50, 0xEF, 0x90, 0xE7, 0x72, 0x02, 0x0B, 0xFB, 0x0E, 0x77,
  0x10, 0x2E, 0x0E, 0x0B, 0xC0, 0xE7, 0x72, 0x0A, 0xC8, 0x1A, 0x16, 0xC0, 0xE7, 0x72, 0x83, 0x1E,
  0xFD, 0x42, 0x06, 0xC0, 0xE7, 0x73, 0x06, 0x07, 0x40, 0x6C, 0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7,
  0x77, 0x20, 0x6C, 0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x72, 0x06,
  0xC0, 0xE7, 0x77, 0x20, 0x6C, 0x0E, 0x77, 0x72, 0x06, 0xC0, 0xE7, 0x77, 0x20, 0x6C, 0x0E, 0x77,
  0x72, 0x06, 0xC0, 0xE7, 0x74, 0x84, 0x12, 0x34, 0x5A, 0xD8, 0x26, 0x43, 0x27, 0x84, 0x19, 0xAB,
  0xCE, 0xFF, 0xC8, 0x4D, 0xCB, 0x93, 0x3F, 0xFF, 0xE0, 0x60, 0x3F, 0xFF, 0xE0, 0x60, 0x3F, 0xFF,
  0xE0, 0x60,
  // "Ń" (U+0143)
  0x77, 0x30, 0x58, 0x01, 0x70, 0x67, 0x76, 0x01, 0xE0, 0x97, 0x76, 0x0A, 0xD0, 0xC7, 0x76, 0x04,
  0xD0, 0xD0, 0x17, 0x76, 0x0D, 0xC0, 0xE0, 0x27, 0x76, 0x08, 0xC0, 0xE0, 0x27, 0x76, 0x03, 0xC0,
  0xE0, 0x37, 0x77, 0x0D, 0xB0, 0xE0, 0x37, 0x77, 0x09, 0xB0, 0xD0, 0x27, 0x77, 0x03, 0xB0, 0xB0,
  0x18, 0x0A, 0xA3, 0x00, 0xCE, 0x08, 0x77, 0x06, 0xC0, 0x0C, 0xE0, 0xE7, 0x70, 0x6C, 0x00, 0xCF,
  0x06, 0x76, 0x06, 0xC0, 0x0C, 0xF0, 0xD7, 0x60, 0x6C, 0x00, 0xCF, 0x90, 0x47, 0x50, 0x6C, 0x00,
  0xCF, 0x90, 0xB7, 0x50, 0x6C, 0x00, 0xCB, 0x0A, 0x0D, 0xC0, 0x27, 0x40, 0x6C, 0x00, 0xCB, 0x0B,
  0x07, 0xC0, 0x97, 0x40, 0x6C, 0x00, 0xCB, 0x81, 0xD1, 0xEB, 0x0E, 0x01, 0x73, 0x06, 0xC0, 0x0C,
  0xB8, 0x1E, 0x09, 0xC0, 0x77, 0x30, 0x6C, 0x00, 0xCC, 0x10, 0x2C, 0x0D, 0x73, 0x06, 0xC0, 0x0C,
  0xC8, 0x11, 0x0A, 0xC0, 0x57, 0x20, 0x6C, 0x00, 0xCC, 0x81, 0x20, 0x3C, 0x0B, 0x72, 0x06, 0xC0,
  0x0C, 0xC0, 0x32, 0x0C, 0xC0, 0x37, 0x10, 0x6C, 0x00, 0xCC, 0x03, 0x20, 0x5C, 0x09, 0x71, 0x06,
  0xC0, 0x0C, 0xC0, 0x43, 0x0D, 0xC0, 0x17, 0x06, 0xC0, 0x0C, 0xC0, 0x43, 0x07, 0xC0, 0x77, 0x06,
  0xC0, 0x0C, 0xC0, 0x53, 0x01, 0x0E, 0xB0, 0xE7, 0x06, 0xC0, 0x0C, 0xC0, 0x64, 0x09, 0xC0, 0x56,
  0x06, 0xC0, 0x0C, 0xC0, 0x64, 0x02, 0xC0, 0xC6, 0x06, 0xC0, 0x0C, 0xC0, 0x65, 0x0B, 0xC0, 0x35,
  0x06, 0xC0, 0x0C, 0xC0, 0x65, 0x04, 0xC0, 0xA5, 0x06, 0xC0, 0x0C, 0xC0, 0x66, 0x0C, 0xC0, 0x14,
  0x06, 0xC0, 0x0C, 0xC0, 0x66, 0x05, 0xC0, 0x84, 0x06, 0xC0, 0x0C, 0xC0, 0x67, 0x0E, 0xB0, 0xE4,
  0x06, 0xC0, 0x0C, 0xC0, 0x67, 0x07, 0xC0, 0x63, 0x06, 0xC0, 0x0C, 0xC0, 0x67, 0x01, 0xC0, 0xD3,
  0x06, 0xC0, 0x0C, 0xC0, 0x67, 0x10, 0x9C, 0x04, 0x20, 0x5C, 0x00, 0xCC, 0x06, 0x71, 0x02, 0xC0,
  0xB2, 0x05, 0xC0, 0x0C, 0xC0, 0x67, 0x20, 0xBC, 0x81, 0x20, 0x4C, 0x00, 0xCC, 0x06, 0x72, 0x04,
  0xC8, 0x19, 0x03, 0xC0, 0x0C, 0xC0, 0x67, 0x30, 0xCB, 0x81, 0xE1, 0x3C, 0x00, 0xCC, 0x06, 0x73,
  0x06, 0xC0, 0x70, 0x2C, 0x00, 0xCC, 0x06, 0x74, 0x0E, 0xB0, 0xD0, 0x1C, 0x00, 0xCC, 0x06, 0x74,
  0x07, 0xC0, 0x5C, 0x00, 0xCC, 0x06, 0x74, 0x01, 0xC0, 0xB0, 0xEB, 0x00, 0xCC, 0x06, 0x75, 0x09,
  0xF9, 0x00, 0xCC, 0x06, 0x75, 0x02, 0xF9, 0x00, 0xCC, 0x06, 0x76, 0x0B, 0xF0, 0x0C, 0xC0, 0x67,
  0x60, 0x4F, 0x00, 0xCC, 0x06, 0x77, 0x0D, 0xE0, 0x0C, 0xC0, 0x67, 0x70, 0x6E, 0x00, 0xCC, 0x06,
  0x77, 0x10, 0xED, 0x0C,
  // "ń" (U+0144)
  0x77, 0x40, 0x58, 0x01, 0x70, 0x67, 0x76, 0x01, 0xE0, 0x97, 0x76, 0x0A, 0xD0, 0xC7, 0x76, 0x04,
  0xD0, 0xD0, 0x17, 0x76, 0x0D, 0xC0, 0xE0, 0x27, 0x76, 0x08, 0xC0, 0xE0, 0x27, 0x76, 0x03, 0xC0,
  0xE0, 0x37, 0x77, 0x0D, 0xB0, 0xE0, 0x37, 0x77, 0x09, 0xB0, 0xD0, 0x27, 0x77, 0x03, 0xB0, 0xB0,
  0x18, 0x0A, 0x83, 0x08, 0x52, 0x56, 0x76, 0x53, 0x71, 0x03, 0xC0, 0x34, 0x81, 0x29, 0xEF, 0x81,
  0xE9, 0x25, 0x03, 0xC0, 0x53, 0x09, 0xFE, 0x08, 0x40, 0x3C, 0x82, 0x70, 0x1C, 0xFF, 0x90, 0xB3,
  0x03, 0xC8, 0x1A, 0x0B, 0xE0, 0x0E, 0xFA, 0x09, 0x20, 0x3C, 0x0C, 0x05, 0xB8, 0x1D, 0x73, 0x48,
  0x12, 0x7E, 0xE8, 0x12, 0x03, 0xD0, 0xEA, 0x09, 0x72, 0x01, 0x0C, 0xD8, 0x1A, 0x03, 0xF0, 0x97,
  0x40, 0x10, 0xEC, 0x81, 0xE0, 0x3E, 0x0E, 0x76, 0x09, 0xD0, 0x03, 0xE0, 0x67, 0x60, 0x4D, 0x05,
  0x03, 0xE0, 0x17, 0x60, 0x1D, 0x06, 0x03, 0xD0, 0xB7, 0x71, 0xD0, 0x70, 0x3D, 0x08, 0x77, 0x10,
  0xEC, 0x07, 0x03, 0xD0, 0x67, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x04, 0x77, 0x10, 0xEC, 0x07, 0x03,
  0xD0, 0x47, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0, 0x37, 0x71,
  0x0E, 0xC0, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0, 0x37, 0x71, 0x0E, 0xC0, 0x70,
  0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0, 0x37, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x03, 0x77,
  0x10, 0xEC, 0x07, 0x03, 0xD0, 0x37, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07,
  0x03, 0xD0, 0x37, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0, 0x37,
  0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0, 0x37, 0x71, 0x0E, 0xC0,
  0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0, 0x37, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x03,
  0x77, 0x10, 0xEC, 0x07,
  // "Ņ" (U+0145)
  0x0C, 0xE0, 0x87, 0x70, 0x6C, 0x00, 0xCE, 0x0E, 0x77, 0x06, 0xC0, 0x0C, 0xF0, 0x67, 0x60, 0x6C,
  0x00, 0xCF, 0x0D, 0x76, 0x06, 0xC0, 0x0C, 0xF9, 0x04, 0x75, 0x06, 0xC0, 0x0C, 0xF9, 0x0B, 0x75,
  0x06, 0xC0, 0x0C, 0xB0, 0xA0, 0xDC, 0x02, 0x74, 0x06, 0xC0, 0x0C, 0xB0, 0xB0, 0x7C, 0x09, 0x74,
  0x06, 0xC0, 0x0C, 0xB8, 0x1D, 0x1E, 0xB0, 0xE0, 0x17, 0x30, 0x6C, 0x00, 0xCB, 0x81, 0xE0, 0x9C,
  0x07, 0x73, 0x06, 0xC0, 0x0C, 0xC1, 0x02, 0xC0, 0xD7, 0x30, 0x6C, 0x00, 0xCC, 0x81, 0x10, 0xAC,
  0x05, 0x72, 0x06, 0xC0, 0x0C, 0xC8, 0x12, 0x03, 0xC0, 0xB7, 0x20, 0x6C, 0x00, 0xCC, 0x03, 0x20,
  0xCC, 0x03, 0x71, 0x06, 0xC0, 0x0C, 0xC0, 0x32, 0x05, 0xC0, 0x97, 0x10, 0x6C, 0x00, 0xCC, 0x04,
  0x30, 0xDC, 0x01, 0x70, 0x6C, 0x00, 0xCC, 0x04, 0x30, 0x7C, 0x07, 0x70, 0x6C, 0x00, 0xCC, 0x05,
  0x30, 0x10, 0xEB, 0x0E, 0x70, 0x6C, 0x00, 0xCC, 0x06, 0x40, 0x9C, 0x05, 0x60, 0x6C, 0x00, 0xCC,
  0x06, 0x40, 0x2C, 0x0C, 0x60, 0x6C, 0x00, 0xCC, 0x06, 0x50, 0xBC, 0x03, 0x50, 0x6C, 0x00, 0xCC,
  0x06, 0x50, 0x4C, 0x0A, 0x50, 0x6C, 0x00, 0xCC, 0x06, 0x60, 0xCC, 0x01, 0x40, 0x6C, 0x00, 0xCC,
  0x06, 0x60, 0x5C, 0x08, 0x40, 0x6C, 0x00, 0xCC, 0x06, 0x70, 0xEB, 0x0E, 0x40, 0x6C, 0x00, 0xCC,
  0x06, 0x70, 0x7C, 0x06, 0x30, 0x6C, 0x00, 0xCC, 0x06, 0x70, 0x1C, 0x0D, 0x30, 0x6C, 0x00, 0xCC,
  0x06, 0x71, 0x09, 0xC0, 0x42, 0x05, 0xC0, 0x0C, 0xC0, 0x67, 0x10, 0x2C, 0x0B, 0x20, 0x5C, 0x00,
  0xCC, 0x06, 0x72, 0x0B, 0xC8, 0x12, 0x04, 0xC0, 0x0C, 0xC0, 0x67, 0x20, 0x4C, 0x81, 0x90, 0x3C,
  0x00, 0xCC, 0x06, 0x73, 0x0C, 0xB8, 0x1E, 0x13, 0xC0, 0x0C, 0xC0, 0x67, 0x30, 0x6C, 0x07, 0x02,
  0xC0, 0x0C, 0xC0, 0x67, 0x40, 0xEB, 0x0D, 0x01, 0xC0, 0x0C, 0xC0, 0x67, 0x40, 0x7C, 0x05, 0xC0,
  0x0C, 0xC0, 0x67, 0x40, 0x1C, 0x0B, 0x0E, 0xB0, 0x0C, 0xC0, 0x67, 0x50, 0x9F, 0x90, 0x0C, 0xC0,
  0x67, 0x50, 0x2F, 0x90, 0x0C, 0xC0, 0x67, 0x60, 0xBF, 0x00, 0xCC, 0x06, 0x76, 0x04, 0xF0, 0x0C,
  0xC0, 0x67, 0x70, 0xDE, 0x00, 0xCC, 0x06, 0x77, 0x06, 0xE0, 0x0C, 0xC0, 0x67, 0x71, 0x0E, 0xD0,
  0xC8, 0x09, 0xB3, 0x00, 0x9C, 0x0A, 0x77, 0x71, 0x0B, 0xC0, 0x57, 0x77, 0x10, 0xEB, 0x0E, 0x77,
  0x71, 0x02, 0xC0, 0x97, 0x77, 0x10, 0x6C, 0x02, 0x77, 0x71, 0x0B, 0xB0, 0x97, 0x77, 0x20, 0xEB,
  0x02, 0x77, 0x71, 0x04, 0xB0, 0x87, 0x77, 0x20, 0xAA, 0x0D, 0x01, 0x77, 0x72, 0xB0, 0x47, 0x71,
  // "ņ" (U+0146)
  0x76, 0x85, 0x25, 0x67, 0x65, 0x37, 0x10, 0x3C, 0x03, 0x48, 0x12, 0x9E, 0xF8, 0x1E, 0x92, 0x50,
  0x3C, 0x05, 0x30, 0x9F, 0xE0, 0x84, 0x03, 0xC8, 0x27, 0x01, 0xCF, 0xF9, 0x0B, 0x30, 0x3C, 0x81,
  0xA0, 0xBE, 0x00, 0xEF, 0xA0, 0x92, 0x03, 0xC0, 0xC0, 0x5B, 0x81, 0xD7, 0x34, 0x81, 0x27, 0xEE,
  0x81, 0x20, 0x3D, 0x0E, 0xA0, 0x97, 0x20, 0x10, 0xCD, 0x81, 0xA0, 0x3F, 0x09, 0x74, 0x01, 0x0E,
  0xC8, 0x1E, 0x03, 0xE0, 0xE7, 0x60, 0x9D, 0x00, 0x3E, 0x06, 0x76, 0x04, 0xD0, 0x50, 0x3E, 0x01,
  0x76, 0x01, 0xD0, 0x60, 0x3D, 0x0B, 0x77, 0x1D, 0x07, 0x03, 0xD0, 0x87, 0x71, 0x0E, 0xC0, 0x70,
  0x3D, 0x06, 0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0, 0x47, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x04, 0x77,
  0x10, 0xEC, 0x07, 0x03, 0xD0, 0x37, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07,
  0x03, 0xD0, 0x37, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0, 0x37,
  0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0, 0x37, 0x71, 0x0E, 0xC0,
  0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0, 0x37, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x03,
  0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0, 0x37, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC,
  0x07, 0x03, 0xD0, 0x37, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0,
  0x37, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0, 0x37, 0x71, 0x0E,
  0xC0, 0x78, 0x09, 0xB3, 0x00, 0x9C, 0x0A, 0x77, 0x71, 0x0B, 0xC0, 0x57, 0x77, 0x10, 0xEB, 0x0E,
  0x77, 0x71, 0x02, 0xC0, 0x97, 0x77, 0x10, 0x6C, 0x02, 0x77, 0x71, 0x0B, 0xB0, 0x97, 0x77, 0x20,
  0xEB, 0x02, 0x77, 0x71, 0x04, 0xB0, 0x87, 0x77, 0x20, 0xAA, 0x0D, 0x01, 0x77, 0x72, 0xB0, 0x47,
  0x71,
  // "Ň" (U+0147)
  0x38, 0x31, 0x77, 0x76, 0x75, 0x83, 0x67, 0x77, 0x16, 0x01, 0x0D, 0xB0, 0xB0, 0x17, 0x10, 0x20,
  0xCB, 0x0D, 0x01, 0x70, 0x20, 0xEB, 0x0D, 0x03, 0x60, 0x40, 0xEB, 0x0D, 0x02, 0x72, 0x03, 0x0E,
  0xC0, 0x44, 0x06, 0xC0, 0xD0, 0x27, 0x40, 0x3D, 0x05, 0x20, 0x7C, 0x0E, 0x02, 0x76, 0x05, 0xD0,
  0x50, 0x8C, 0x0E, 0x03, 0x77, 0x10, 0x6F, 0xB0, 0x47, 0x73, 0x08, 0xF9, 0x06, 0x77, 0x50, 0xBE,
  0x09, 0x77, 0x60, 0x20, 0xEC, 0x0D, 0x80, 0xAA, 0x30, 0x0C, 0xE0, 0x87, 0x70, 0x6C, 0x00, 0xCE,
  0x0E, 0x77, 0x06, 0xC0, 0x0C, 0xF0, 0x67, 0x60, 0x6C, 0x00, 0xCF, 0x0D, 0x76, 0x06, 0xC0, 0x0C,
  0xF9, 0x04, 0x75, 0x06, 0xC0, 0x0C, 0xF9, 0x0B, 0x75, 0x06, 0xC0, 0x0C, 0xB0, 0xA0, 0xDC, 0x02,
  0x74, 0x06, 0xC0, 0x0C, 0xB0, 0xB0, 0x7C, 0x09, 0x74, 0x06, 0xC0, 0x0C, 0xB8, 0x1D, 0x1E, 0xB0,
  0xE0, 0x17, 0x30, 0x6C, 0x00, 0xCB, 0x81, 0xE0, 0x9C, 0x07, 0x73, 0x06, 0xC0, 0x0C, 0xC1, 0x02,
  0xC0, 0xD7, 0x30, 0x6C, 0x00, 0xCC, 0x81, 0x10, 0xAC, 0x05, 0x72, 0x06, 0xC0, 0x0C, 0xC8, 0x12,
  0x03, 0xC0, 0xB7, 0x20, 0x6C, 0x00, 0xCC, 0x03, 0x20, 0xCC, 0x03, 0x71, 0x06, 0xC0, 0x0C, 0xC0,
  0x32, 0x05, 0xC0, 0x97, 0x10, 0x6C, 0x00, 0xCC, 0x04, 0x30, 0xDC, 0x01, 0x70, 0x6C, 0x00, 0xCC,
  0x04, 0x30, 0x7C, 0x07, 0x70, 0x6C, 0x00, 0xCC, 0x05, 0x30, 0x10, 0xEB, 0x0E, 0x70, 0x6C, 0x00,
  0xCC, 0x06, 0x40, 0x9C, 0x05, 0x60, 0x6C, 0x00, 0xCC, 0x06, 0x40, 0x2C, 0x0C, 0x60, 0x6C, 0x00,
  0xCC, 0x06, 0x50, 0xBC, 0x03, 0x50, 0x6C, 0x00, 0xCC, 0x06, 0x50, 0x4C, 0x0A, 0x50, 0x6C, 0x00,
  0xCC, 0x06, 0x60, 0xCC, 0x01, 0x40, 0x6C, 0x00, 0xCC, 0x06, 0x60, 0x5C, 0x08, 0x40, 0x6C, 0x00,
  0xCC, 0x06, 0x70, 0xEB, 0x0E, 0x40, 0x6C, 0x00, 0xCC, 0x06, 0x70, 0x7C, 0x06, 0x30, 0x6C, 0x00,
  0xCC, 0x06, 0x70, 0x1C, 0x0D, 0x30, 0x6C, 0x00, 0xCC, 0x06, 0x71, 0x09, 0xC0, 0x42, 0x05, 0xC0,
  0x0C, 0xC0, 0x67, 0x10, 0x2C, 0x0B, 0x20, 0x5C, 0x00, 0xCC, 0x06, 0x72, 0x0B, 0xC8, 0x12, 0x04,
  0xC0, 0x0C, 0xC0, 0x67, 0x20, 0x4C, 0x81, 0x90, 0x3C, 0x00, 0xCC, 0x06, 0x73, 0x0C, 0xB8, 0x1E,
  0x13, 0xC0, 0x0C, 0xC0, 0x67, 0x30, 0x6C, 0x07, 0x02, 0xC0, 0x0C, 0xC0, 0x67, 0x40, 0xEB, 0x0D,
  0x01, 0xC0, 0x0C, 0xC0, 0x67, 0x40, 0x7C, 0x05, 0xC0, 0x0C, 0xC0, 0x67, 0x40, 0x1C, 0x0B, 0x0E,
  0xB0, 0x0C, 0xC0, 0x67, 0x50, 0x9F, 0x90, 0x0C, 0xC0, 0x67, 0x50, 0x2F, 0x90, 0x0C, 0xC0, 0x67,
  0x60, 0xBF, 0x00, 0xCC, 0x06, 0x76, 0x04, 0xF0, 0x0C, 0xC0, 0x67, 0x70, 0xDE, 0x00, 0xCC, 0x06,
  0x77, 0x06, 0xE0, 0x0C, 0xC0, 0x67, 0x71, 0x0E, 0xD0, 0xC0,
  // "ň" (U+0148)
  0x48, 0x31, 0x77, 0x76, 0x75, 0x83, 0x67, 0x77, 0x16, 0x01, 0x0D, 0xB0, 0xB0, 0x17, 0x10, 0x20,
  0xCB, 0x0D, 0x01, 0x70, 0x20, 0xEB, 0x0D, 0x03, 0x60, 0x40, 0xEB, 0x0D, 0x02, 0x72, 0x03, 0x0E,
  0xC0, 0x44, 0x06, 0xC0, 0xD0, 0x27, 0x40, 0x3D, 0x05, 0x20, 0x7C, 0x0E, 0x02, 0x76, 0x05, 0xD0,
  0x50, 0x8C, 0x0E, 0x03, 0x77, 0x10, 0x6F, 0xB0, 0x47, 0x73, 0x08, 0xF9, 0x06, 0x77, 0x50, 0xBE,
  0x09, 0x77, 0x60, 0x20, 0xEC, 0x0D, 0x80, 0xA8, 0x30, 0x85, 0x25, 0x67, 0x65, 0x37, 0x10, 0x3C,
  0x03, 0x48, 0x12, 0x9E, 0xF8, 0x1E, 0x92, 0x50, 0x3C, 0x05, 0x30, 0x9F, 0xE0, 0x84, 0x03, 0xC8,
  0x27, 0x01, 0xCF, 0xF9, 0x0B, 0x30, 0x3C, 0x81, 0xA0, 0xBE, 0x00, 0xEF, 0xA0, 0x92, 0x03, 0xC0,
  0xC0, 0x5B, 0x81, 0xD7, 0x34, 0x81, 0x27, 0xEE, 0x81, 0x20, 0x3D, 0x0E, 0xA0, 0x97, 0x20, 0x10,
  0xCD, 0x81, 0xA0, 0x3F, 0x09, 0x74, 0x01, 0x0E, 0xC8, 0x1E, 0x03, 0xE0, 0xE7, 0x60, 0x9D, 0x00,
  0x3E, 0x06, 0x76, 0x04, 0xD0, 0x50, 0x3E, 0x01, 0x76, 0x01, 0xD0, 0x60, 0x3D, 0x0B, 0x77, 0x1D,
  0x07, 0x03, 0xD0, 0x87, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x06, 0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0,
  0x47, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x04, 0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0, 0x37, 0x71, 0x0E,
  0xC0, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0, 0x37, 0x71, 0x0E, 0xC0, 0x70, 0x3D,
  0x03, 0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0, 0x37, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x03, 0x77, 0x10,
  0xEC, 0x07, 0x03, 0xD0, 0x37, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x03,
  0xD0, 0x37, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0, 0x37, 0x71,
  0x0E, 0xC0, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0, 0x37, 0x71, 0x0E, 0xC0, 0x70,
  0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0, 0x37, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x03, 0x77,
  0x10, 0xEC, 0x07, 0x03, 0xD0, 0x37, 0x71, 0x0E, 0xC0, 0x70,
  // "ŉ" (U+0149)
  0x20, 0x2E, 0x06, 0x77, 0x76, 0x04, 0xE0, 0x47, 0x77, 0x60, 0x7E, 0x77, 0x77, 0x09, 0xD0, 0xB7,
  0x77, 0x70, 0xCD, 0x06, 0x77, 0x77, 0xE0, 0x17, 0x77, 0x60, 0x2D, 0x0B, 0x77, 0x77, 0x05, 0xD0,
  0x67, 0x77, 0x70, 0x9D, 0x01, 0x77, 0x77, 0x0C, 0xC0, 0x97, 0x77, 0x71, 0xD0, 0x37, 0x68, 0x51,
  0x46, 0x77, 0x54, 0x71, 0x03, 0xC0, 0xD2, 0x04, 0xC0, 0x14, 0x06, 0x0C, 0xF9, 0x0A, 0x03, 0x50,
  0x6C, 0x06, 0x20, 0x4C, 0x03, 0x20, 0x30, 0xDF, 0xD0, 0x94, 0x0A, 0xB0, 0xE3, 0x04, 0xC8, 0x26,
  0x04, 0xEF, 0xF0, 0xC3, 0x0D, 0xB0, 0x93, 0x04, 0xC8, 0x19, 0x2E, 0xFF, 0xA0, 0xA7, 0x30, 0x4C,
  0x0C, 0x0B, 0xB8, 0x6D, 0x73, 0x10, 0x14, 0x9F, 0x03, 0x72, 0x04, 0xF9, 0x08, 0x71, 0x02, 0x0D,
  0xD0, 0xA7, 0x20, 0x4F, 0x08, 0x73, 0x03, 0xD0, 0xE7, 0x20, 0x4E, 0x0C, 0x75, 0x0A, 0xD0, 0x37,
  0x10, 0x4E, 0x05, 0x75, 0x04, 0xD0, 0x57, 0x10, 0x4D, 0x0E, 0x76, 0x01, 0xD0, 0x67, 0x10, 0x4D,
  0x0A, 0x77, 0xD0, 0x77, 0x10, 0x4D, 0x07, 0x77, 0x0E, 0xC0, 0x77, 0x10, 0x4D, 0x04, 0x77, 0x0E,
  0xC0, 0x77, 0x10, 0x4D, 0x03, 0x77, 0x0E, 0xC0, 0x77, 0x10, 0x4D, 0x02, 0x77, 0x0E, 0xC0, 0x77,
  0x10, 0x4D, 0x01, 0x77, 0x0E, 0xC0, 0x77, 0x10, 0x4D, 0x01, 0x77, 0x0E, 0xC0, 0x77, 0x10, 0x4D,
  0x01, 0x77, 0x0E, 0xC0, 0x77, 0x10, 0x4D, 0x01, 0x77, 0x0E, 0xC0, 0x77, 0x10, 0x4D, 0x01, 0x77,
  0x0E, 0xC0, 0x77, 0x10, 0x4D, 0x01, 0x77, 0x0E, 0xC0, 0x77, 0x10, 0x4D, 0x01, 0x77, 0x0E, 0xC0,
  0x77, 0x10, 0x4D, 0x01, 0x77, 0x0E, 0xC0, 0x77, 0x10, 0x4D, 0x01, 0x77, 0x0E, 0xC0, 0x77, 0x10,
  0x4D, 0x01, 0x77, 0x0E, 0xC0, 0x77, 0x10, 0x4D, 0x01, 0x77, 0x0E, 0xC0, 0x77, 0x10, 0x4D, 0x01,
  0x77, 0x0E, 0xC0, 0x77, 0x10, 0x4D, 0x01, 0x77, 0x0E, 0xC0, 0x77, 0x10, 0x4D, 0x01, 0x77, 0x0E,
  0xC0, 0x77, 0x10, 0x4D, 0x01, 0x77, 0x0E, 0xC0, 0x77, 0x10, 0x4D, 0x01, 0x77, 0x0E, 0xC0, 0x77,
  0x10, 0x4D, 0x01, 0x77, 0x0E, 0xC0, 0x70,
  // "Ŋ" (U+014A)
  0x0C, 0xE0, 0x87, 0x70, 0x6C, 0x00, 0xCE, 0x0E, 0x77, 0x06, 0xC0, 0x0C, 0xF0, 0x67, 0x60, 0x6C,
  0x00, 0xCF, 0x0D, 0x76, 0x06, 0xC0, 0x0C, 0xF9, 0x04, 0x75, 0x06, 0xC0, 0x0C, 0xF9, 0x0B, 0x75,
  0x06, 0xC0, 0x0C, 0xB0, 0xA0, 0xDC, 0x02, 0x74, 0x06, 0xC0, 0x0C, 0xB0, 0xB0, 0x7C, 0x09, 0x74,
  0x06, 0xC0, 0x0C, 0xB8, 0x1D, 0x1E, 0xB0, 0xE0, 0x17, 0x30, 0x6C, 0x00, 0xCB, 0x81, 0xE0, 0x9C,
  0x07, 0x73, 0x06, 0xC0, 0x0C, 0xC1, 0x02, 0xC0, 0xD7, 0x30, 0x6C, 0x00, 0xCC, 0x81, 0x10, 0xAC,
  0x05, 0x72, 0x06, 0xC0, 0x0C, 0xC8, 0x12, 0x03, 0xC0, 0xB7, 0x20, 0x6C, 0x00, 0xCC, 0x03, 0x20,
  0xCC, 0x03, 0x71, 0x06, 0xC0, 0x0C, 0xC0, 0x32, 0x05, 0xC0, 0x97, 0x10, 0x6C, 0x00, 0xCC, 0x04,
  0x30, 0xDC, 0x01, 0x70, 0x6C, 0x00, 0xCC, 0x04, 0x30, 0x7C, 0x07, 0x70, 0x6C, 0x00, 0xCC, 0x05,
  0x30, 0x10, 0xEB, 0x0E, 0x70, 0x6C, 0x00, 0xCC, 0x06, 0x40, 0x9C, 0x05, 0x60, 0x6C, 0x00, 0xCC,
  0x06, 0x40, 0x2C, 0x0C, 0x60, 0x6C, 0x00, 0xCC, 0x06, 0x50, 0xBC, 0x03, 0x50, 0x6C, 0x00, 0xCC,
  0x06, 0x50, 0x4C, 0x0A, 0x50, 0x6C, 0x00, 0xCC, 0x06, 0x60, 0xCC, 0x01, 0x40, 0x6C, 0x00, 0xCC,
  0x06, 0x60, 0x5C, 0x08, 0x40, 0x6C, 0x00, 0xCC, 0x06, 0x70, 0xEB, 0x0E, 0x40, 0x6C, 0x00, 0xCC,
  0x06, 0x70, 0x7C, 0x06, 0x30, 0x6C, 0x00, 0xCC, 0x06, 0x70, 0x1C, 0x0D, 0x30, 0x6C, 0x00, 0xCC,
  0x06, 0x71, 0x09, 0xC0, 0x42, 0x05, 0xC0, 0x0C, 0xC0, 0x67, 0x10, 0x2C, 0x0B, 0x20, 0x5C, 0x00,
  0xCC, 0x06, 0x72, 0x0B, 0xC8, 0x12, 0x04, 0xC0, 0x0C, 0xC0, 0x67, 0x20, 0x4C, 0x81, 0x90, 0x3C,
  0x00, 0xCC, 0x06, 0x73, 0x0C, 0xB8, 0x1E, 0x13, 0xC0, 0x0C, 0xC0, 0x67, 0x30, 0x6C, 0x07, 0x02,
  0xC0, 0x0C, 0xC0, 0x67, 0x40, 0xEB, 0x0D, 0x01, 0xC0, 0x0C, 0xC0, 0x67, 0x40, 0x7C, 0x05, 0xC0,
  0x0C, 0xC0, 0x67, 0x40, 0x1C, 0x0B, 0x0E, 0xB0, 0x0C, 0xC0, 0x67, 0x50, 0x9F, 0x90, 0x0C, 0xC0,
  0x67, 0x50, 0x2F, 0x90, 0x0C, 0xC0, 0x67, 0x60, 0xBF, 0x00, 0xCC, 0x06, 0x76, 0x04, 0xF0, 0x0C,
  0xC0, 0x67, 0x70, 0xDE, 0x00, 0xCC, 0x06, 0x77, 0x06, 0xE0, 0x0C, 0xC0, 0x67, 0x71, 0x0E, 0xD0,
  0xC7, 0x77, 0x10, 0x4C, 0x0B, 0x77, 0x71, 0x05, 0xC0, 0xA7, 0x77, 0x10, 0x7C, 0x08, 0x77, 0x71,
  0x0C, 0xC0, 0x57, 0x77, 0x05, 0xD0, 0x17, 0x76, 0x04, 0xD0, 0xB7, 0x68, 0x17, 0x41, 0x28, 0x11,
  0x5A, 0xE0, 0x47, 0x6F, 0xE0, 0x97, 0x7F, 0xD0, 0xB7, 0x71, 0xFC, 0x07, 0x77, 0x20, 0xDF, 0x81,
  0xD8, 0x17, 0x74, 0x85, 0x24, 0x56, 0x54, 0x17, 0x10,
  // "ŋ" (U+014B)
  0x76, 0x85, 0x25, 0x67, 0x65, 0x37, 0x10, 0x3C, 0x03, 0x48, 0x12, 0x9E, 0xF8, 0x1E, 0x92, 0x50,
  0x3C, 0x05, 0x30, 0x9F, 0xE0, 0x84, 0x03, 0xC8, 0x27, 0x01, 0xCF, 0xF9, 0x0B, 0x30, 0x3C, 0x81,
  0xA0, 0xBE, 0x00, 0xEF, 0xA0, 0x92, 0x03, 0xC0, 0xC0, 0x5B, 0x81, 0xD7, 0x34, 0x81, 0x27, 0xEE,
  0x81, 0x30, 0x3D, 0x0E, 0xA0, 0x97, 0x20, 0x10, 0xCD, 0x81, 0xA0, 0x3F, 0x09, 0x74, 0x01, 0x0E,
  0xC8, 0x1E, 0x03, 0xE0, 0xE7, 0x60, 0x9D, 0x00, 0x3E, 0x06, 0x76, 0x03, 0xD0, 0x50, 0x3E, 0x01,
  0x76, 0x01, 0xD0, 0x60, 0x3D, 0x0B, 0x77, 0x1D, 0x07, 0x03, 0xD0, 0x87, 0x71, 0x0E, 0xC0, 0x70,
  0x3D, 0x06, 0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0, 0x47, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x04, 0x77,
  0x10, 0xEC, 0x07, 0x03, 0xD0, 0x37, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07,
  0x03, 0xD0, 0x37, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0, 0x37,
  0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0, 0x37, 0x71, 0x0E, 0xC0,
  0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0, 0x37, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x03,
  0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0, 0x37, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC,
  0x07, 0x03, 0xD0, 0x37, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0,
  0x37, 0x71, 0x0E, 0xC0, 0x70, 0x3D, 0x03, 0x77, 0x10, 0xEC, 0x07, 0x03, 0xD0, 0x37, 0x71, 0x0E,
  0xC0, 0x77, 0x77, 0x10, 0xEC, 0x07, 0x77, 0x71, 0x0E, 0xC0, 0x77, 0x77, 0x10, 0xEC, 0x07, 0x77,
  0x71, 0x0E, 0xC0, 0x77, 0x77, 0x10, 0xEC, 0x07, 0x77, 0x71, 0x0E, 0xC0, 0x67, 0x77, 0x01, 0xD0,
  0x57, 0x77, 0x05, 0xD0, 0x27, 0x76, 0x02, 0x0D, 0xC0, 0xE7, 0x71, 0x85, 0x6B, 0x87, 0x69, 0xED,
  0x08, 0x77, 0x10, 0x7F, 0xB0, 0xE0, 0x17, 0x71, 0x07, 0xFB, 0x04, 0x77, 0x20, 0x7F, 0x90, 0xD0,
  0x47, 0x73, 0x87, 0x28, 0xCE, 0xFE, 0xDA, 0x65,
  // "Ō" (U+014C)
  0x70, 0x58, 0x09, 0x46, 0x05, 0x77, 0x0D, 0xFF, 0xA0, 0xE7, 0x70, 0xDF, 0xFA, 0x0E, 0x77, 0x0D,
  0xFF, 0xA0, 0xE7, 0x70, 0xDF, 0xFA, 0x0E, 0x80, 0xA9, 0x70, 0x86, 0x14, 0x67, 0x76, 0x41, 0x77,
  0x78, 0x11, 0x8D, 0xF9, 0x81, 0xD8, 0x27, 0x73, 0x08, 0xFF, 0x08, 0x77, 0x01, 0x0C, 0xFF, 0xA0,
  0xD0, 0x17, 0x40, 0x10, 0xDF, 0x90, 0x0E, 0xF9, 0x0D, 0x02, 0x73, 0x0C, 0xE0, 0x90, 0x34, 0x81,
  0x37, 0xED, 0x0C, 0x72, 0x09, 0xD0, 0xC0, 0x17, 0x10, 0x10, 0xAD, 0x09, 0x70, 0x2D, 0x0C, 0x75,
  0x0A, 0xD0, 0x36, 0x0A, 0xC0, 0xE0, 0x17, 0x50, 0x10, 0xEC, 0x0B, 0x50, 0x2D, 0x07, 0x77, 0x06,
  0xD0, 0x24, 0x08, 0xD0, 0x17, 0x70, 0x1D, 0x08, 0x40, 0xDC, 0x0B, 0x77, 0x20, 0xAC, 0x0D, 0x30,
  0x1D, 0x06, 0x77, 0x20, 0x5D, 0x01, 0x20, 0x5D, 0x02, 0x77, 0x20, 0x1D, 0x05, 0x20, 0x8C, 0x0E,
  0x77, 0x40, 0xDC, 0x08, 0x20, 0xBC, 0x0B, 0x77, 0x40, 0xBC, 0x0B, 0x20, 0xEC, 0x09, 0x77, 0x40,
  0x9C, 0x0E, 0x2D, 0x07, 0x77, 0x40, 0x7D, 0x10, 0x1D, 0x05, 0x77, 0x40, 0x5D, 0x01, 0x03, 0xD0,
  0x57, 0x74, 0x05, 0xD0, 0x03, 0xD0, 0x47, 0x74, 0x04, 0xD0, 0x30, 0x4D, 0x03, 0x77, 0x40, 0x3D,
  0x00, 0x4D, 0x03, 0x77, 0x40, 0x3D, 0x00, 0x4D, 0x03, 0x77, 0x40, 0x3D, 0x04, 0x03, 0xD0, 0x47,
  0x74, 0x04, 0xD0, 0x03, 0xD0, 0x57, 0x74, 0x05, 0xD0, 0x30, 0x1D, 0x05, 0x77, 0x40, 0x5D, 0x01,
  0x1D, 0x07, 0x77, 0x40, 0x7D, 0x20, 0xEC, 0x09, 0x77, 0x40, 0x9C, 0x0D, 0x20, 0xBC, 0x0B, 0x77,
  0x40, 0xBC, 0x0B, 0x20, 0x9C, 0x0E, 0x77, 0x40, 0xEC, 0x08, 0x20, 0x6D, 0x02, 0x77, 0x20, 0x2D,
  0x05, 0x20, 0x2D, 0x05, 0x77, 0x20, 0x5D, 0x01, 0x30, 0xDC, 0x0A, 0x77, 0x20, 0xAC, 0x0C, 0x40,
  0x8D, 0x01, 0x77, 0x01, 0xD0, 0x74, 0x02, 0xD0, 0x77, 0x70, 0x6D, 0x01, 0x50, 0xBC, 0x0E, 0x01,
  0x75, 0x01, 0x0E, 0xC0, 0xA6, 0x03, 0xD0, 0xB7, 0x50, 0xBD, 0x02, 0x70, 0x9D, 0x0B, 0x01, 0x71,
  0x01, 0x0B, 0xD0, 0x87, 0x20, 0xDD, 0x81, 0xE8, 0x34, 0x81, 0x38, 0xED, 0x0C, 0x73, 0x02, 0x0D,
  0xF9, 0x00, 0xEF, 0x90, 0xD0, 0x17, 0x40, 0x20, 0xDF, 0xFA, 0x0C, 0x01, 0x77, 0x09, 0xFF, 0x08,
  0x77, 0x38, 0x12, 0x8E, 0xF9, 0x81, 0xD8, 0x17, 0x77, 0x86, 0x25, 0x67, 0x76, 0x41, 0x75,
  // "ō" (U+014D)
  0x60, 0x58, 0x09, 0x46, 0x05, 0x75, 0x0D, 0xFF, 0xA0, 0xE7, 0x50, 0xDF, 0xFA, 0x0E, 0x75, 0x0D,
  0xFF, 0xA0, 0xE7, 0x50, 0xDF, 0xFA, 0x0E, 0x80, 0xA8, 0x50, 0x86, 0x25, 0x67, 0x76, 0x41, 0x77,
  0x58, 0x13, 0x9E, 0xF9, 0x81, 0xD8, 0x27, 0x70, 0x20, 0xBF, 0xF0, 0x90, 0x17, 0x40, 0x5F, 0xFB,
  0x0E, 0x04, 0x72, 0x07, 0xFA, 0x00, 0xEF, 0xA0, 0x57, 0x05, 0xE8, 0x1D, 0x73, 0x48, 0x13, 0x8E,
  0xE0, 0x35, 0x01, 0x0E, 0xD0, 0x97, 0x20, 0x10, 0xAD, 0x0D, 0x50, 0xAD, 0x08, 0x75, 0x0A, 0xD0,
  0x83, 0x02, 0xD0, 0xB7, 0x70, 0xDD, 0x01, 0x20, 0x8D, 0x02, 0x77, 0x04, 0xD0, 0x72, 0x0D, 0xC0,
  0xB7, 0x72, 0x0D, 0xC8, 0x1C, 0x02, 0xD0, 0x57, 0x72, 0x07, 0xD0, 0x10, 0x5D, 0x01, 0x77, 0x20,
  0x3D, 0x04, 0x07, 0xC0, 0xE7, 0x74, 0xD0, 0x70, 0x9C, 0x0C, 0x77, 0x40, 0xEC, 0x08, 0x0A, 0xC0,
  0xB7, 0x74, 0x0D, 0xC0, 0x90, 0xAC, 0x0A, 0x77, 0x40, 0xCC, 0x00, 0xAC, 0x0A, 0x77, 0x40, 0xCC,
  0x0A, 0x09, 0xC0, 0xB7, 0x74, 0x0D, 0xC0, 0x90, 0x8C, 0x0C, 0x77, 0x40, 0xEC, 0x09, 0x06, 0xC0,
  0xE7, 0x73, 0x01, 0xD0, 0x70, 0x4D, 0x02, 0x77, 0x20, 0x3D, 0x04, 0x01, 0xD0, 0x67, 0x72, 0x08,
  0xD8, 0x11, 0x0C, 0xC0, 0xB7, 0x72, 0x0D, 0xC0, 0xD2, 0x07, 0xD0, 0x37, 0x70, 0x4D, 0x08, 0x20,
  0x1D, 0x0C, 0x77, 0x0D, 0xD0, 0x13, 0x08, 0xD0, 0x97, 0x50, 0xAD, 0x09, 0x50, 0xDD, 0x09, 0x01,
  0x71, 0x01, 0x0A, 0xD0, 0xE0, 0x15, 0x03, 0xE8, 0x1E, 0x83, 0x48, 0x13, 0x8E, 0xE0, 0x47, 0x05,
  0xFA, 0x00, 0xEF, 0xA0, 0x67, 0x20, 0x40, 0xEF, 0xFA, 0x0E, 0x05, 0x74, 0x01, 0x0A, 0xFF, 0x0A,
  0x01, 0x77, 0x81, 0x28, 0xDF, 0x98, 0x1D, 0x92, 0x77, 0x58, 0x61, 0x46, 0x77, 0x64, 0x27, 0x40,
  // "Ŏ" (U+014E)
  0x60, 0x3B, 0x06, 0x73, 0x05, 0xB0, 0x47, 0x50, 0x1B, 0x0D, 0x73, 0x0C, 0xB0, 0x27, 0x60, 0xDB,
  0x0B, 0x02, 0x60, 0x10, 0xAB, 0x0D, 0x77, 0x06, 0xD8, 0x4B, 0x86, 0x78, 0xBD, 0x07, 0x77, 0x10,
  0xCF, 0xF0, 0xD7, 0x72, 0x01, 0x0D, 0xFD, 0x0D, 0x01, 0x77, 0x30, 0x10, 0xAF, 0xB0, 0xA0, 0x17,
  0x76, 0x89, 0x03, 0x8C, 0xEF, 0xED, 0xB7, 0x28, 0x0A, 0xA3, 0x08, 0x61, 0x46, 0x77, 0x64, 0x17,
  0x77, 0x81, 0x18, 0xDF, 0x98, 0x1D, 0x82, 0x77, 0x30, 0x8F, 0xF0, 0x87, 0x70, 0x10, 0xCF, 0xFA,
  0x0D, 0x01, 0x74, 0x01, 0x0D, 0xF9, 0x00, 0xEF, 0x90, 0xD0, 0x27, 0x30, 0xCE, 0x09, 0x03, 0x48,
  0x13, 0x7E, 0xD0, 0xC7, 0x20, 0x9D, 0x0C, 0x01, 0x71, 0x01, 0x0A, 0xD0, 0x97, 0x02, 0xD0, 0xC7,
  0x50, 0xAD, 0x03, 0x60, 0xAC, 0x0E, 0x01, 0x75, 0x01, 0x0E, 0xC0, 0xB5, 0x02, 0xD0, 0x77, 0x70,
  0x6D, 0x02, 0x40, 0x8D, 0x01, 0x77, 0x01, 0xD0, 0x84, 0x0D, 0xC0, 0xB7, 0x72, 0x0A, 0xC0, 0xD3,
  0x01, 0xD0, 0x67, 0x72, 0x05, 0xD0, 0x12, 0x05, 0xD0, 0x27, 0x72, 0x01, 0xD0, 0x52, 0x08, 0xC0,
  0xE7, 0x74, 0x0D, 0xC0, 0x82, 0x0B, 0xC0, 0xB7, 0x74, 0x0B, 0xC0, 0xB2, 0x0E, 0xC0, 0x97, 0x74,
  0x09, 0xC0, 0xE2, 0xD0, 0x77, 0x74, 0x07, 0xD1, 0x01, 0xD0, 0x57, 0x74, 0x05, 0xD0, 0x10, 0x3D,
  0x05, 0x77, 0x40, 0x5D, 0x00, 0x3D, 0x04, 0x77, 0x40, 0x4D, 0x03, 0x04, 0xD0, 0x37, 0x74, 0x03,
  0xD0, 0x04, 0xD0, 0x37, 0x74, 0x03, 0xD0, 0x04, 0xD0, 0x37, 0x74, 0x03, 0xD0, 0x40, 0x3D, 0x04,
  0x77, 0x40, 0x4D, 0x00, 0x3D, 0x05, 0x77, 0x40, 0x5D, 0x03, 0x01, 0xD0, 0x57, 0x74, 0x05, 0xD0,
  0x11, 0xD0, 0x77, 0x74, 0x07, 0xD2, 0x0E, 0xC0, 0x97, 0x74, 0x09, 0xC0, 0xD2, 0x0B, 0xC0, 0xB7,
  0x74, 0x0B, 0xC0, 0xB2, 0x09, 0xC0, 0xE7, 0x74, 0x0E, 0xC0, 0x82, 0x06, 0xD0, 0x27, 0x72, 0x02,
  0xD0, 0x52, 0x02, 0xD0, 0x57, 0x72, 0x05, 0xD0, 0x13, 0x0D, 0xC0, 0xA7, 0x72, 0x0A, 0xC0, 0xC4,
  0x08, 0xD0, 0x17, 0x70, 0x1D, 0x07, 0x40, 0x2D, 0x07, 0x77, 0x06, 0xD0, 0x15, 0x0B, 0xC0, 0xE0,
  0x17, 0x50, 0x10, 0xEC, 0x0A, 0x60, 0x3D, 0x0B, 0x75, 0x0B, 0xD0, 0x27, 0x09, 0xD0, 0xB0, 0x17,
  0x10, 0x10, 0xBD, 0x08, 0x72, 0x0D, 0xD8, 0x1E, 0x83, 0x48, 0x13, 0x8E, 0xD0, 0xC7, 0x30, 0x20,
  0xDF, 0x90, 0x0E, 0xF9, 0x0D, 0x01, 0x74, 0x02, 0x0D, 0xFF, 0xA0, 0xC0, 0x17, 0x70, 0x9F, 0xF0,
  0x87, 0x73, 0x81, 0x28, 0xEF, 0x98, 0x1D, 0x81, 0x77, 0x78, 0x62, 0x56, 0x77, 0x64, 0x17, 0x50,
  // "ŏ" (U+014F)
  0x50, 0x3B, 0x06, 0x73, 0x05, 0xB0, 0x47, 0x30, 0x1B, 0x0D, 0x73, 0x0C, 0xB0, 0x27, 0x40, 0xDB,
  0x0B, 0x02, 0x60, 0x10, 0xAB, 0x0D, 0x75, 0x06, 0xD8, 0x4B, 0x86, 0x78, 0xBD, 0x07, 0x76, 0x0C,
  0xFF, 0x0D, 0x77, 0x01, 0x0D, 0xFD, 0x0D, 0x01, 0x77, 0x10, 0x10, 0xAF, 0xB0, 0xA0, 0x17, 0x74,
  0x89, 0x03, 0x8C, 0xEF, 0xED, 0xB7, 0x28, 0x0A, 0x91, 0x08, 0x62, 0x56, 0x77, 0x64, 0x17, 0x75,
  0x81, 0x39, 0xEF, 0x98, 0x1D, 0x82, 0x77, 0x02, 0x0B, 0xFF, 0x09, 0x01, 0x74, 0x05, 0xFF, 0xB0,
  0xE0, 0x47, 0x20, 0x7F, 0xA0, 0x0E, 0xFA, 0x05, 0x70, 0x5E, 0x81, 0xD7, 0x34, 0x81, 0x38, 0xEE,
  0x03, 0x50, 0x10, 0xED, 0x09, 0x72, 0x01, 0x0A, 0xD0, 0xD5, 0x0A, 0xD0, 0x87, 0x50, 0xAD, 0x08,
  0x30, 0x2D, 0x0B, 0x77, 0x0D, 0xD0, 0x12, 0x08, 0xD0, 0x27, 0x70, 0x4D, 0x07, 0x20, 0xDC, 0x0B,
  0x77, 0x20, 0xDC, 0x81, 0xC0, 0x2D, 0x05, 0x77, 0x20, 0x7D, 0x01, 0x05, 0xD0, 0x17, 0x72, 0x03,
  0xD0, 0x40, 0x7C, 0x0E, 0x77, 0x4D, 0x07, 0x09, 0xC0, 0xC7, 0x74, 0x0E, 0xC0, 0x80, 0xAC, 0x0B,
  0x77, 0x40, 0xDC, 0x09, 0x0A, 0xC0, 0xA7, 0x74, 0x0C, 0xC0, 0x0A, 0xC0, 0xA7, 0x74, 0x0C, 0xC0,
  0xA0, 0x9C, 0x0B, 0x77, 0x40, 0xDC, 0x09, 0x08, 0xC0, 0xC7, 0x74, 0x0E, 0xC0, 0x90, 0x6C, 0x0E,
  0x77, 0x30, 0x1D, 0x07, 0x04, 0xD0, 0x27, 0x72, 0x03, 0xD0, 0x40, 0x1D, 0x06, 0x77, 0x20, 0x8D,
  0x81, 0x10, 0xCC, 0x0B, 0x77, 0x20, 0xDC, 0x0D, 0x20, 0x7D, 0x03, 0x77, 0x04, 0xD0, 0x82, 0x01,
  0xD0, 0xC7, 0x70, 0xDD, 0x01, 0x30, 0x8D, 0x09, 0x75, 0x0A, 0xD0, 0x95, 0x0D, 0xD0, 0x90, 0x17,
  0x10, 0x10, 0xAD, 0x0E, 0x01, 0x50, 0x3E, 0x81, 0xE8, 0x34, 0x81, 0x38, 0xEE, 0x04, 0x70, 0x5F,
  0xA0, 0x0E, 0xFA, 0x06, 0x72, 0x04, 0x0E, 0xFF, 0xA0, 0xE0, 0x57, 0x40, 0x10, 0xAF, 0xF0, 0xA0,
  0x17, 0x78, 0x12, 0x8D, 0xF9, 0x81, 0xD9, 0x27, 0x75, 0x86, 0x14, 0x67, 0x76, 0x42, 0x74,
  // "Ő" (U+0150)
  0x74, 0x0B, 0xD0, 0x33, 0x02, 0xD0, 0xC7, 0x70, 0x3D, 0x0B, 0x40, 0x9D, 0x04, 0x77, 0x0A, 0xC0,
  0xE0, 0x13, 0x02, 0xD0, 0x97, 0x70, 0x3D, 0x04, 0x40, 0xAC, 0x0C, 0x77, 0x10, 0xCC, 0x07, 0x40,
  0x3C, 0x0E, 0x02, 0x77, 0x05, 0xC0, 0x95, 0x0C, 0xC0, 0x37, 0x71, 0x0D, 0xB0, 0xC5, 0x05, 0xC0,
  0x57, 0x71, 0x08, 0xB0, 0xC0, 0x14, 0x01, 0x0E, 0xB0, 0x77, 0x71, 0x03, 0xB0, 0xD0, 0x15, 0x09,
  0xB0, 0x77, 0x72, 0x0A, 0xA0, 0xC0, 0x15, 0x01, 0xB0, 0x68, 0x0A, 0xA3, 0x08, 0x61, 0x46, 0x77,
  0x64, 0x17, 0x77, 0x81, 0x18, 0xDF, 0x98, 0x1D, 0x82, 0x77, 0x30, 0x8F, 0xF0, 0x87, 0x70, 0x10,
  0xCF, 0xFA, 0x0D, 0x01, 0x74, 0x01, 0x0D, 0xF9, 0x00, 0xEF, 0x90, 0xD0, 0x27, 0x30, 0xCE, 0x09,
  0x03, 0x48, 0x13, 0x7E, 0xD0, 0xC7, 0x20, 0x9D, 0x0C, 0x01, 0x71, 0x01, 0x0A, 0xD0, 0x97, 0x02,
  0xD0, 0xC7, 0x50, 0xAD, 0x03, 0x60, 0xAC, 0x0E, 0x01, 0x75, 0x01, 0x0E, 0xC0, 0xB5, 0x02, 0xD0,
  0x77, 0x70, 0x6D, 0x02, 0x40, 0x8D, 0x01, 0x77, 0x01, 0xD0, 0x84, 0x0D, 0xC0, 0xB7, 0x72, 0x0A,
  0xC0, 0xD3, 0x01, 0xD0, 0x67, 0x72, 0x05, 0xD0, 0x12, 0x05, 0xD0, 0x27, 0x72, 0x01, 0xD0, 0x52,
  0x08, 0xC0, 0xE7, 0x74, 0x0D, 0xC0, 0x82, 0x0B, 0xC0, 0xB7, 0x74, 0x0B, 0xC0, 0xB2, 0x0E, 0xC0,
  0x97, 0x74, 0x09, 0xC0, 0xE2, 0xD0, 0x77, 0x74, 0x07, 0xD1, 0x01, 0xD0, 0x57, 0x74, 0x05, 0xD0,
  0x10, 0x3D, 0x05, 0x77, 0x40, 0x5D, 0x00, 0x3D, 0x04, 0x77, 0x40, 0x4D, 0x03, 0x04, 0xD0, 0x37,
  0x74, 0x03, 0xD0, 0x04, 0xD0, 0x37, 0x74, 0x03, 0xD0, 0x04, 0xD0, 0x37, 0x74, 0x03, 0xD0, 0x40,
  0x3D, 0x04, 0x77, 0x40, 0x4D, 0x00, 0x3D, 0x05, 0x77, 0x40, 0x5D, 0x03, 0x01, 0xD0, 0x57, 0x74,
  0x05, 0xD0, 0x11, 0xD0, 0x77, 0x74, 0x07, 0xD2, 0x0E, 0xC0, 0x97, 0x74, 0x09, 0xC0, 0xD2, 0x0B,
  0xC0, 0xB7, 0x74, 0x0B, 0xC0, 0xB2, 0x09, 0xC0, 0xE7, 0x74, 0x0E, 0xC0, 0x82, 0x06, 0xD0, 0x27,
  0x72, 0x02, 0xD0, 0x52, 0x02, 0xD0, 0x57, 0x72, 0x05, 0xD0, 0x13, 0x0D, 0xC0, 0xA7, 0x72, 0x0A,
  0xC0, 0xC4, 0x08, 0xD0, 0x17, 0x70, 0x1D, 0x07, 0x40, 0x2D, 0x07, 0x77, 0x06, 0xD0, 0x15, 0x0B,
  0xC0, 0xE0, 0x17, 0x50, 0x10, 0xEC, 0x0A, 0x60, 0x3D, 0x0B, 0x75, 0x0B, 0xD0, 0x27, 0x09, 0xD0,
  0xB0, 0x17, 0x10, 0x10, 0xBD, 0x08, 0x72, 0x0D, 0xD8, 0x1E, 0x83, 0x48, 0x13, 0x8E, 0xD0, 0xC7,
  0x30, 0x20, 0xDF, 0x90, 0x0E, 0xF9, 0x0D, 0x01, 0x74, 0x02, 0x0D, 0xFF, 0xA0, 0xC0, 0x17, 0x70,
  0x9F, 0xF0, 0x87, 0x73, 0x81, 0x28, 0xEF, 0x98, 0x1D, 0x81, 0x77, 0x78, 0x62, 0x56, 0x77, 0x64,
  0x17, 0x50,
  // "ő" (U+0151)
  0x73, 0x0B, 0xD0, 0x33, 0x02, 0xD0, 0xC7, 0x50, 0x3D, 0x0B, 0x40, 0x9D, 0x04, 0x75, 0x0A, 0xC0,
  0xE0, 0x13, 0x02, 0xD0, 0x97, 0x50, 0x3D, 0x04, 0x40, 0xAC, 0x0C, 0x76, 0x0C, 0xC0, 0x74, 0x03,
  0xC0, 0xE0, 0x27, 0x50, 0x5C, 0x09, 0x50, 0xCC, 0x03, 0x76, 0x0D, 0xB0, 0xC5, 0x05, 0xC0, 0x57,
  0x60, 0x8B, 0x0C, 0x01, 0x40, 0x10, 0xEB, 0x07, 0x76, 0x03, 0xB0, 0xD0, 0x15, 0x09, 0xB0, 0x77,
  0x70, 0xAA, 0x0C, 0x01, 0x50, 0x1B, 0x06, 0x80, 0xA9, 0x10, 0x86, 0x25, 0x67, 0x76, 0x41, 0x77,
  0x58, 0x13, 0x9E, 0xF9, 0x81, 0xD8, 0x27, 0x70, 0x20, 0xBF, 0xF0, 0x90, 0x17, 0x40, 0x5F, 0xFB,
  0x0E, 0x04, 0x72, 0x07, 0xFA, 0x00, 0xEF, 0xA0, 0x57, 0x05, 0xE8, 0x1D, 0x73, 0x48, 0x13, 0x8E,
  0xE0, 0x35, 0x01, 0x0E, 0xD0, 0x97, 0x20, 0x10, 0xAD, 0x0D, 0x50, 0xAD, 0x08, 0x75, 0x0A, 0xD0,
  0x83, 0x02, 0xD0, 0xB7, 0x70, 0xDD, 0x01, 0x20, 0x8D, 0x02, 0x77, 0x04, 0xD0, 0x72, 0x0D, 0xC0,
  0xB7, 0x72, 0x0D, 0xC8, 0x1C, 0x02, 0xD0, 0x57, 0x72, 0x07, 0xD0, 0x10, 0x5D, 0x01, 0x77, 0x20,
  0x3D, 0x04, 0x07, 0xC0, 0xE7, 0x74, 0xD0, 0x70, 0x9C, 0x0C, 0x77, 0x40, 0xEC, 0x08, 0x0A, 0xC0,
  0xB7, 0x74, 0x0D, 0xC0, 0x90, 0xAC, 0x0A, 0x77, 0x40, 0xCC, 0x00, 0xAC, 0x0A, 0x77, 0x40, 0xCC,
  0x0A, 0x09, 0xC0, 0xB7, 0x74, 0x0D, 0xC0, 0x90, 0x8C, 0x0C, 0x77, 0x40, 0xEC, 0x09, 0x06, 0xC0,
  0xE7, 0x73, 0x01, 0xD0, 0x70, 0x4D, 0x02, 0x77, 0x20, 0x3D, 0x04, 0x01, 0xD0, 0x67, 0x72, 0x08,
  0xD8, 0x11, 0x0C, 0xC0, 0xB7, 0x72, 0x0D, 0xC0, 0xD2, 0x07, 0xD0, 0x37, 0x70, 0x4D, 0x08, 0x20,
  0x1D, 0x0C, 0x77, 0x0D, 0xD0, 0x13, 0x08, 0xD0, 0x97, 0x50, 0xAD, 0x09, 0x50, 0xDD, 0x09, 0x01,
  0x71, 0x01, 0x0A, 0xD0, 0xE0, 0x15, 0x03, 0xE8, 0x1E, 0x83, 0x48, 0x13, 0x8E, 0xE0, 0x47, 0x05,
  0xFA, 0x00, 0xEF, 0xA0, 0x67, 0x20, 0x40, 0xEF, 0xFA, 0x0E, 0x05, 0x74, 0x01, 0x0A, 0xFF, 0x0A,
  0x01, 0x77, 0x81, 0x28, 0xDF, 0x98, 0x1D, 0x92, 0x77, 0x58, 0x61, 0x46, 0x77, 0x64, 0x27, 0x40,
  // "Œ" (U+0152)
  0x73, 0x85, 0x35, 0x67, 0x65, 0x37, 0x77, 0x28, 0x11, 0x8E, 0xFF, 0xF9, 0x03, 0x60, 0x50, 0xEF,
  0xFF, 0xB0, 0x35, 0x07, 0xFF, 0xFD, 0x03, 0x40, 0x5F, 0x0E, 0xFF, 0xD0, 0x33, 0x01, 0x0E, 0xD0,
  0x70, 0x12, 0x81, 0x15, 0xCC, 0x0D, 0x80, 0x66, 0x01, 0x30, 0x9D, 0x03, 0x60, 0x6C, 0x0C, 0x76,
  0x02, 0xD0, 0x77, 0x06, 0xC0, 0xC7, 0x60, 0x8C, 0x0E, 0x71, 0x06, 0xC0, 0xC7, 0x60, 0xDC, 0x08,
  0x71, 0x06, 0xC0, 0xC7, 0x50, 0x3D, 0x03, 0x71, 0x06, 0xC0, 0xC7, 0x50, 0x7C, 0x0E, 0x72, 0x06,
  0xC0, 0xC7, 0x50, 0xAC, 0x0B, 0x72, 0x06, 0xC0, 0xC7, 0x50, 0xDC, 0x09, 0x72, 0x06, 0xC0, 0xC7,
  0x5D, 0x06, 0x72, 0x06, 0xC0, 0xC7, 0x40, 0x2D, 0x04, 0x72, 0x06, 0xC0, 0xC7, 0x40, 0x4D, 0x03,
  0x72, 0x06, 0xC0, 0xC7, 0x40, 0x5D, 0x01, 0x72, 0x06, 0xC0, 0xC7, 0x40, 0x7D, 0x73, 0x06, 0xC0,
  0xC7, 0x40, 0x8D, 0x73, 0x06, 0xFF, 0x81, 0x10, 0x8D, 0x73, 0x06, 0xFF, 0x81, 0x10, 0x8C, 0x0E,
  0x73, 0x06, 0xFF, 0x81, 0x10, 0x9C, 0x0E, 0x73, 0x06, 0xFF, 0x81, 0x10, 0x8C, 0x0E, 0x73, 0x06,
  0xC0, 0xD8, 0x05, 0x62, 0x08, 0xD7, 0x30, 0x6C, 0x0C, 0x74, 0x08, 0xD7, 0x30, 0x6C, 0x0C, 0x74,
  0x07, 0xD7, 0x30, 0x6C, 0x0C, 0x74, 0x05, 0xD0, 0x17, 0x20, 0x6C, 0x0C, 0x74, 0x04, 0xD0, 0x37,
  0x20, 0x6C, 0x0C, 0x74, 0x02, 0xD0, 0x47, 0x20, 0x6C, 0x0C, 0x75, 0xD0, 0x67, 0x20, 0x6C, 0x0C,
  0x75, 0x0D, 0xC0, 0x97, 0x20, 0x6C, 0x0C, 0x75, 0x0A, 0xC0, 0xB7, 0x20, 0x6C, 0x0C, 0x75, 0x07,
  0xC0, 0xE7, 0x20, 0x6C, 0x0C, 0x75, 0x03, 0xD0, 0x47, 0x10, 0x6C, 0x0C, 0x76, 0x0E, 0xC0, 0x87,
  0x10, 0x6C, 0x0C, 0x76, 0x09, 0xC0, 0xE7, 0x10, 0x6C, 0x0C, 0x76, 0x02, 0xD0, 0x77, 0x06, 0xC0,
  0xC7, 0x70, 0xBD, 0x03, 0x60, 0x6C, 0x0C, 0x77, 0x02, 0xE0, 0x70, 0x12, 0x81, 0x16, 0xCC, 0x0D,
  0x80, 0x66, 0x01, 0x40, 0x7F, 0x0E, 0xFF, 0xD0, 0x35, 0x0A, 0xFF, 0xFD, 0x03, 0x60, 0x9F, 0xFF,
  0xC0, 0x37, 0x04, 0x0B, 0xFF, 0xFA, 0x03, 0x72, 0x85, 0x15, 0x67, 0x65, 0x37, 0x73,
  // "œ" (U+0153)
  0x78, 0x41, 0x47, 0x76, 0x37, 0x38, 0x34, 0x67, 0x62, 0x74, 0x02, 0x0A, 0xE0, 0xD0, 0x46, 0x05,
  0x0D, 0xD0, 0xB0, 0x27, 0x10, 0x50, 0xEF, 0xA0, 0x64, 0x08, 0xF9, 0x0E, 0x04, 0x60, 0x4F, 0xD0,
  0x42, 0x06, 0xFB, 0x0E, 0x02, 0x40, 0x10, 0xEE, 0x0E, 0xD8, 0x2E, 0x01, 0xED, 0x0E, 0xD0, 0xB4,
  0x08, 0xD8, 0x37, 0x10, 0x17, 0xC0, 0x70, 0x9B, 0x0E, 0x05, 0x20, 0x30, 0xDC, 0x03, 0x30, 0xEC,
  0x04, 0x50, 0x5B, 0x0E, 0xC0, 0x34, 0x03, 0xC0, 0x92, 0x06, 0xC0, 0xA7, 0x0C, 0xE0, 0x96, 0x0A,
  0xB0, 0xE2, 0x0A, 0xC0, 0x37, 0x06, 0xE0, 0x36, 0x05, 0xC8, 0x11, 0x0E, 0xB0, 0xD7, 0x10, 0x1D,
  0x0E, 0x70, 0x1C, 0x04, 0x02, 0xC0, 0xA7, 0x20, 0xDC, 0x0B, 0x71, 0x0E, 0xB0, 0x70, 0x4C, 0x07,
  0x72, 0x0B, 0xC0, 0x87, 0x10, 0xCB, 0x09, 0x07, 0xC0, 0x57, 0x20, 0x9C, 0x07, 0x71, 0x0B, 0xB0,
  0xA0, 0x8C, 0x04, 0x72, 0x08, 0xC0, 0xA8, 0x04, 0x60, 0xCB, 0x0B, 0x09, 0xC0, 0x37, 0x20, 0x6F,
  0xFB, 0x0C, 0x09, 0xC0, 0x27, 0x20, 0x6F, 0xFB, 0x0C, 0x0A, 0xC0, 0x27, 0x20, 0x6F, 0xFB, 0x0C,
  0x0A, 0xC0, 0x27, 0x20, 0x6F, 0xFB, 0x0C, 0x09, 0xC0, 0x27, 0x20, 0x6C, 0x05, 0x76, 0x08, 0xC0,
  0x37, 0x20, 0x6C, 0x06, 0x76, 0x07, 0xC0, 0x47, 0x20, 0x7C, 0x07, 0x76, 0x05, 0xC0, 0x67, 0x20,
  0x9C, 0x09, 0x76, 0x03, 0xC0, 0x87, 0x20, 0xAC, 0x0B, 0x76, 0x01, 0xC0, 0xB7, 0x20, 0xDC, 0x0E,
  0x77, 0x0D, 0xB0, 0xE7, 0x2E, 0x02, 0x76, 0x08, 0xC0, 0x47, 0x05, 0xE0, 0x87, 0x60, 0x4C, 0x0B,
  0x70, 0xBE, 0x0E, 0x77, 0x0C, 0xC0, 0x65, 0x05, 0xB0, 0x0E, 0xB0, 0xA7, 0x10, 0x50, 0x73, 0x05,
  0xD0, 0x80, 0x12, 0x06, 0xC0, 0x80, 0x7C, 0x0B, 0x04, 0x38, 0x33, 0x7D, 0xF9, 0x40, 0xCE, 0x0E,
  0xD8, 0x2E, 0x10, 0xDE, 0x0E, 0xD0, 0x94, 0x02, 0x0E, 0xFC, 0x05, 0x20, 0x4F, 0xD0, 0x95, 0x03,
  0x0D, 0xFA, 0x07, 0x40, 0x5F, 0xB0, 0xE0, 0x46, 0x01, 0x09, 0xE0, 0xD0, 0x56, 0x03, 0x0B, 0xE0,
  0xD0, 0x77, 0x48, 0x34, 0x67, 0x63, 0x73, 0x84, 0x25, 0x77, 0x52, 0x50,
  // "Ŕ" (U+0154)
  0x77, 0x20, 0x58, 0x01, 0x70, 0x67, 0x77, 0x01, 0xE0, 0x97, 0x77, 0x0A, 0xD0, 0xC7, 0x77, 0x04,
  0xD0, 0xD0, 0x17, 0x77, 0x0D, 0xC0, 0xE0, 0x27, 0x77, 0x08, 0xC0, 0xE0, 0x27, 0x77, 0x03, 0xC0,
  0xE0, 0x37, 0x77, 0x10, 0xDB, 0x0E, 0x03, 0x77, 0x71, 0x09, 0xB0, 0xD0, 0x27, 0x77, 0x10, 0x3B,
  0x0B, 0x01, 0x80, 0xAB, 0x20, 0x04, 0xFB, 0x85, 0xEE, 0xDB, 0x86, 0x27, 0x40, 0x4F, 0xFB, 0x0C,
  0x06, 0x72, 0x04, 0xFF, 0xD0, 0xD0, 0x47, 0x04, 0xFF, 0xF0, 0x76, 0x04, 0xD8, 0x77, 0x66, 0x66,
  0x77, 0x9C, 0xF9, 0x06, 0x50, 0x4D, 0x01, 0x71, 0x81, 0x17, 0xEE, 0x01, 0x40, 0x4D, 0x01, 0x73,
  0x01, 0x0C, 0xD0, 0xA4, 0x04, 0xD0, 0x17, 0x40, 0x10, 0xED, 0x40, 0x4D, 0x01, 0x75, 0x07, 0xD0,
  0x43, 0x04, 0xD0, 0x17, 0x50, 0x2D, 0x08, 0x30, 0x4D, 0x01, 0x76, 0x0E, 0xC0, 0xA3, 0x04, 0xD0,
  0x17, 0x60, 0xDC, 0x0B, 0x30, 0x4D, 0x01, 0x76, 0x0C, 0xC0, 0xB3, 0x04, 0xD0, 0x17, 0x60, 0xDC,
  0x0B, 0x30, 0x4D, 0x01, 0x76, 0x0E, 0xC0, 0x93, 0x04, 0xD0, 0x17, 0x50, 0x2D, 0x06, 0x30, 0x4D,
  0x01, 0x75, 0x07, 0xD0, 0x23, 0x04, 0xD0, 0x17, 0x40, 0x10, 0xEC, 0x0C, 0x40, 0x4D, 0x01, 0x74,
  0x0A, 0xD0, 0x44, 0x04, 0xD0, 0x17, 0x20, 0x20, 0xBD, 0x0A, 0x50, 0x4D, 0x01, 0x58, 0x21, 0x36,
  0xBE, 0x0C, 0x01, 0x50, 0x4F, 0xFE, 0x0C, 0x01, 0x60, 0x4F, 0xFD, 0x08, 0x71, 0x04, 0xFF, 0xB0,
  0x90, 0x27, 0x20, 0x4F, 0xFA, 0x0E, 0x01, 0x73, 0x04, 0xD0, 0x78, 0x02, 0x6D, 0x09, 0x73, 0x04,
  0xD0, 0x16, 0x08, 0xD0, 0x37, 0x20, 0x4D, 0x01, 0x70, 0xEC, 0x0C, 0x72, 0x04, 0xD0, 0x17, 0x05,
  0xD0, 0x67, 0x10, 0x4D, 0x01, 0x71, 0x0C, 0xC0, 0xE0, 0x17, 0x04, 0xD0, 0x17, 0x10, 0x3D, 0x09,
  0x70, 0x4D, 0x01, 0x72, 0x09, 0xD0, 0x36, 0x04, 0xD0, 0x17, 0x20, 0x10, 0xEC, 0x0C, 0x60, 0x4D,
  0x01, 0x73, 0x06, 0xD0, 0x65, 0x04, 0xD0, 0x17, 0x40, 0xCC, 0x0E, 0x01, 0x40, 0x4D, 0x01, 0x74,
  0x04, 0xD0, 0x94, 0x04, 0xD0, 0x17, 0x50, 0xAD, 0x03, 0x30, 0x4D, 0x01, 0x75, 0x01, 0x0E, 0xC0,
  0xC3, 0x04, 0xD0, 0x17, 0x60, 0x7D, 0x06, 0x20, 0x4D, 0x01, 0x77, 0x0D, 0xC8, 0x2E, 0x10, 0x4D,
  0x01, 0x77, 0x05, 0xD8, 0x19, 0x04, 0xD0, 0x17, 0x71, 0x0B, 0xD0, 0x30, 0x4D, 0x01, 0x77, 0x10,
  0x2D, 0x0C,
  // "ŕ" (U+0155)
  0x77, 0x60, 0x58, 0x01, 0x70, 0x67, 0x77, 0x30, 0x1E, 0x09, 0x77, 0x73, 0x0A, 0xD0, 0xC7, 0x77,
  0x30, 0x4D, 0x0D, 0x01, 0x77, 0x73, 0x0D, 0xC0, 0xE0, 0x27, 0x77, 0x30, 0x8C, 0x0E, 0x02, 0x77,
  0x73, 0x03, 0xC0, 0xE0, 0x37, 0x77, 0x40, 0xDB, 0x0E, 0x03, 0x77, 0x74, 0x09, 0xB0, 0xD0, 0x27,
  0x77, 0x40, 0x3B, 0x0B, 0x01, 0x80, 0xAB, 0x60, 0x85, 0x36, 0x77, 0x64, 0x14, 0x04, 0xFD, 0x0D,
  0x50, 0x70, 0xEF, 0x83, 0xD8, 0x10, 0x4F, 0xE3, 0x01, 0x0C, 0xFC, 0x81, 0x10, 0x4F, 0xE0, 0x12,
  0x0C, 0xFC, 0x0C, 0x28, 0x22, 0x9B, 0xDF, 0xB8, 0x13, 0x0A, 0xE0, 0xED, 0x07, 0x78, 0x31, 0x35,
  0x7C, 0xC0, 0x05, 0xC0, 0xB0, 0x43, 0x83, 0x15, 0xCF, 0x27, 0x40, 0x7C, 0x08, 0x0E, 0xA0, 0xE0,
  0x57, 0x10, 0x47, 0x50, 0x7F, 0x90, 0x37, 0x77, 0x10, 0x7F, 0x06, 0x77, 0x72, 0x07, 0xE0, 0xC7,
  0x77, 0x30, 0x7E, 0x04, 0x77, 0x73, 0x07, 0xD0, 0xD7, 0x77, 0x40, 0x7D, 0x08, 0x77, 0x74, 0x07,
  0xD0, 0x47, 0x77, 0x40, 0x7D, 0x02, 0x77, 0x74, 0x07, 0xD7, 0x77, 0x50, 0x7D, 0x77, 0x75, 0x07,
  0xC0, 0xE7, 0x77, 0x50, 0x7C, 0x0E, 0x77, 0x75, 0x07, 0xC0, 0xE7, 0x77, 0x50, 0x7C, 0x0E, 0x77,
  0x75, 0x07, 0xC0, 0xE7, 0x77, 0x50, 0x7C, 0x0E, 0x77, 0x75, 0x07, 0xC0, 0xE7, 0x77, 0x50, 0x7C,
  0x0E, 0x77, 0x75, 0x07, 0xC0, 0xE7, 0x77, 0x50, 0x7C, 0x0E, 0x77, 0x75, 0x07, 0xC0, 0xE7, 0x77,
  0x18, 0x31, 0x24, 0x5B, 0xD8, 0x26, 0x43, 0x17, 0x58, 0x32, 0x9B, 0xCD, 0xFF, 0xA8, 0x3E, 0xCB,
  0x92, 0x60, 0x4F, 0xFF, 0xB0, 0x46, 0x04, 0xFF, 0xFB, 0x04, 0x60, 0x4F, 0xFF, 0xB0, 0x46,
  // "Ŗ" (U+0156)
  0x04, 0xFB, 0x85, 0xEE, 0xDB, 0x86, 0x27, 0x40, 0x4F, 0xFB, 0x0C, 0x06, 0x72, 0x04, 0xFF, 0xD0,
  0xD0, 0x47, 0x04, 0xFF, 0xF0, 0x76, 0x04, 0xD8, 0x77, 0x66, 0x66, 0x77, 0x9C, 0xF9, 0x06, 0x50,
  0x4D, 0x01, 0x71, 0x81, 0x17, 0xEE, 0x01, 0x40, 0x4D, 0x01, 0x73, 0x01, 0x0C, 0xD0, 0xA4, 0x04,
  0xD0, 0x17, 0x40, 0x10, 0xED, 0x40, 0x4D, 0x01, 0x75, 0x07, 0xD0, 0x43, 0x04, 0xD0, 0x17, 0x50,
  0x2D, 0x08, 0x30, 0x4D, 0x01, 0x76, 0x0E, 0xC0, 0xA3, 0x04, 0xD0, 0x17, 0x60, 0xDC, 0x0B, 0x30,
  0x4D, 0x01, 0x76, 0x0C, 0xC0, 0xB3, 0x04, 0xD0, 0x17, 0x60, 0xDC, 0x0B, 0x30, 0x4D, 0x01, 0x76,
  0x0E, 0xC0, 0x93, 0x04, 0xD0, 0x17, 0x50, 0x2D, 0x06, 0x30, 0x4D, 0x01, 0x75, 0x07, 0xD0, 0x23,
  0x04, 0xD0, 0x17, 0x40, 0x10, 0xEC, 0x0C, 0x40, 0x4D, 0x01, 0x74, 0x0A, 0xD0, 0x44, 0x04, 0xD0,
  0x17, 0x20, 0x20, 0xBD, 0x0A, 0x50, 0x4D, 0x01, 0x58, 0x21, 0x36, 0xBE, 0x0C, 0x01, 0x50, 0x4F,
  0xFE, 0x0C, 0x01, 0x60, 0x4F, 0xFD, 0x08, 0x71, 0x04, 0xFF, 0xB0, 0x90, 0x27, 0x20, 0x4F, 0xFA,
  0x0E, 0x01, 0x73, 0x04, 0xD0, 0x78, 0x02, 0x6D, 0x09, 0x73, 0x04, 0xD0, 0x16, 0x08, 0xD0, 0x37,
  0x20, 0x4D, 0x01, 0x70, 0xEC, 0x0C, 0x72, 0x04, 0xD0, 0x17, 0x05, 0xD0, 0x67, 0x10, 0x4D, 0x01,
  0x71, 0x0C, 0xC0, 0xE0, 0x17, 0x04, 0xD0, 0x17, 0x10, 0x3D, 0x09, 0x70, 0x4D, 0x01, 0x72, 0x09,
  0xD0, 0x36, 0x04, 0xD0, 0x17, 0x20, 0x10, 0xEC, 0x0C, 0x60, 0x4D, 0x01, 0x73, 0x06, 0xD0, 0x65,
  0x04, 0xD0, 0x17, 0x40, 0xCC, 0x0E, 0x01, 0x40, 0x4D, 0x01, 0x74, 0x04, 0xD0, 0x94, 0x04, 0xD0,
  0x17, 0x50, 0xAD, 0x03, 0x30, 0x4D, 0x01, 0x75, 0x01, 0x0E, 0xC0, 0xC3, 0x04, 0xD0, 0x17, 0x60,
  0x7D, 0x06, 0x20, 0x4D, 0x01, 0x77, 0x0D, 0xC8, 0x2E, 0x10, 0x4D, 0x01, 0x77, 0x05, 0xD8, 0x19,
  0x04, 0xD0, 0x17, 0x71, 0x0B, 0xD0, 0x30, 0x4D, 0x01, 0x77, 0x10, 0x2D, 0x0C, 0x80, 0x9B, 0x70,
  0x09, 0xC0, 0xA7, 0x77, 0x20, 0xBC, 0x05, 0x77, 0x72, 0x0E, 0xB0, 0xE7, 0x77, 0x20, 0x2C, 0x09,
  0x77, 0x72, 0x06, 0xC0, 0x27, 0x77, 0x20, 0xBB, 0x09, 0x77, 0x73, 0x0E, 0xB0, 0x27, 0x77, 0x20,
  0x4B, 0x08, 0x77, 0x73, 0x0A, 0xA0, 0xD0, 0x17, 0x77, 0x3B, 0x04, 0x77, 0x10,
  // "ŗ" (U+0157)
  0x77, 0x71, 0x85, 0x36, 0x77, 0x64, 0x14, 0x04, 0xFD, 0x0D, 0x50, 0x70, 0xEF, 0x83, 0xD8, 0x10,
  0x4F, 0xE3, 0x01, 0x0C, 0xFC, 0x81, 0x10, 0x4F, 0xE0, 0x12, 0x0C, 0xFC, 0x0C, 0x28, 0x22, 0x9B,
  0xDF, 0xB8, 0x13, 0x0A, 0xE0, 0xED, 0x07, 0x78, 0x31, 0x35, 0x7C, 0xC0, 0x05, 0xC0, 0xB0, 0x43,
  0x83, 0x15, 0xCF, 0x27, 0x40, 0x7C, 0x08, 0x0E, 0xA0, 0xE0, 0x57, 0x10, 0x47, 0x50, 0x7F, 0x90,
  0x37, 0x77, 0x10, 0x7F, 0x06, 0x77, 0x72, 0x07, 0xE0, 0xC7, 0x77, 0x30, 0x7E, 0x04, 0x77, 0x73,
  0x07, 0xD0, 0xD7, 0x77, 0x40, 0x7D, 0x08, 0x77, 0x74, 0x07, 0xD0, 0x47, 0x77, 0x40, 0x7D, 0x02,
  0x77, 0x74, 0x07, 0xD7, 0x77, 0x50, 0x7D, 0x77, 0x75, 0x07, 0xC0, 0xE7, 0x77, 0x50, 0x7C, 0x0E,
  0x77, 0x75, 0x07, 0xC0, 0xE7, 0x77, 0x50, 0x7C, 0x0E, 0x77, 0x75, 0x07, 0xC0, 0xE7, 0x77, 0x50,
  0x7C, 0x0E, 0x77, 0x75, 0x07, 0xC0, 0xE7, 0x77, 0x50, 0x7C, 0x0E, 0x77, 0x75, 0x07, 0xC0, 0xE7,
  0x77, 0x50, 0x7C, 0x0E, 0x77, 0x75, 0x07, 0xC0, 0xE7, 0x77, 0x18, 0x31, 0x24, 0x5B, 0xD8, 0x26,
  0x43, 0x17, 0x58, 0x32, 0x9B, 0xCD, 0xFF, 0xA8, 0x3E, 0xCB, 0x92, 0x60, 0x4F, 0xFF, 0xB0, 0x46,
  0x04, 0xFF, 0xFB, 0x04, 0x60, 0x4F, 0xFF, 0xB0, 0x48, 0x09, 0xD4, 0x00, 0x9C, 0x0A, 0x77, 0x75,
  0x0B, 0xC0, 0x57, 0x77, 0x50, 0xEB, 0x0E, 0x77, 0x75, 0x02, 0xC0, 0x97, 0x77, 0x50, 0x6C, 0x02,
  0x77, 0x75, 0x0B, 0xB0, 0x97, 0x77, 0x60, 0xEB, 0x02, 0x77, 0x75, 0x04, 0xB0, 0x87, 0x77, 0x60,
  0xAA, 0x0D, 0x01, 0x77, 0x76, 0xB0, 0x47, 0x76,
  // "Ř" (U+0158)
  0x28, 0x31, 0x77, 0x76, 0x75, 0x83, 0x67, 0x77, 0x17, 0x01, 0x0D, 0xB0, 0xB0, 0x17, 0x10, 0x20,
  0xCB, 0x0D, 0x01, 0x71, 0x02, 0x0E, 0xB0, 0xD0, 0x36, 0x04, 0x0E, 0xB0, 0xD0, 0x27, 0x30, 0x30,
  0xEC, 0x04, 0x40, 0x6C, 0x0D, 0x02, 0x75, 0x03, 0xD0, 0x52, 0x07, 0xC0, 0xE0, 0x27, 0x70, 0x5D,
  0x05, 0x08, 0xC0, 0xE0, 0x37, 0x72, 0x06, 0xFB, 0x04, 0x77, 0x40, 0x8F, 0x90, 0x67, 0x76, 0x0B,
  0xE0, 0x97, 0x77, 0x02, 0x0E, 0xC0, 0xD8, 0x0A, 0xB2, 0x00, 0x4F, 0xB8, 0x5E, 0xED, 0xB8, 0x62,
  0x74, 0x04, 0xFF, 0xB0, 0xC0, 0x67, 0x20, 0x4F, 0xFD, 0x0D, 0x04, 0x70, 0x4F, 0xFF, 0x07, 0x60,
  0x4D, 0x87, 0x76, 0x66, 0x67, 0x79, 0xCF, 0x90, 0x65, 0x04, 0xD0, 0x17, 0x18, 0x11, 0x7E, 0xE0,
  0x14, 0x04, 0xD0, 0x17, 0x30, 0x10, 0xCD, 0x0A, 0x40, 0x4D, 0x01, 0x74, 0x01, 0x0E, 0xD4, 0x04,
  0xD0, 0x17, 0x50, 0x7D, 0x04, 0x30, 0x4D, 0x01, 0x75, 0x02, 0xD0, 0x83, 0x04, 0xD0, 0x17, 0x60,
  0xEC, 0x0A, 0x30, 0x4D, 0x01, 0x76, 0x0D, 0xC0, 0xB3, 0x04, 0xD0, 0x17, 0x60, 0xCC, 0x0B, 0x30,
  0x4D, 0x01, 0x76, 0x0D, 0xC0, 0xB3, 0x04, 0xD0, 0x17, 0x60, 0xEC, 0x09, 0x30, 0x4D, 0x01, 0x75,
  0x02, 0xD0, 0x63, 0x04, 0xD0, 0x17, 0x50, 0x7D, 0x02, 0x30, 0x4D, 0x01, 0x74, 0x01, 0x0E, 0xC0,
  0xC4, 0x04, 0xD0, 0x17, 0x40, 0xAD, 0x04, 0x40, 0x4D, 0x01, 0x72, 0x02, 0x0B, 0xD0, 0xA5, 0x04,
  0xD0, 0x15, 0x82, 0x13, 0x6B, 0xE0, 0xC0, 0x15, 0x04, 0xFF, 0xE0, 0xC0, 0x16, 0x04, 0xFF, 0xD0,
  0x87, 0x10, 0x4F, 0xFB, 0x09, 0x02, 0x72, 0x04, 0xFF, 0xA0, 0xE0, 0x17, 0x30, 0x4D, 0x07, 0x80,
  0x26, 0xD0, 0x97, 0x30, 0x4D, 0x01, 0x60, 0x8D, 0x03, 0x72, 0x04, 0xD0, 0x17, 0x0E, 0xC0, 0xC7,
  0x20, 0x4D, 0x01, 0x70, 0x5D, 0x06, 0x71, 0x04, 0xD0, 0x17, 0x10, 0xCC, 0x0E, 0x01, 0x70, 0x4D,
  0x01, 0x71, 0x03, 0xD0, 0x97, 0x04, 0xD0, 0x17, 0x20, 0x9D, 0x03, 0x60, 0x4D, 0x01, 0x72, 0x01,
  0x0E, 0xC0, 0xC6, 0x04, 0xD0, 0x17, 0x30, 0x6D, 0x06, 0x50, 0x4D, 0x01, 0x74, 0x0C, 0xC0, 0xE0,
  0x14, 0x04, 0xD0, 0x17, 0x40, 0x4D, 0x09, 0x40, 0x4D, 0x01, 0x75, 0x0A, 0xD0, 0x33, 0x04, 0xD0,
  0x17, 0x50, 0x10, 0xEC, 0x0C, 0x30, 0x4D, 0x01, 0x76, 0x07, 0xD0, 0x62, 0x04, 0xD0, 0x17, 0x70,
  0xDC, 0x82, 0xE1, 0x04, 0xD0, 0x17, 0x70, 0x5D, 0x81, 0x90, 0x4D, 0x01, 0x77, 0x10, 0xBD, 0x03,
  0x04, 0xD0, 0x17, 0x71, 0x02, 0xD0, 0xC0,
  // "ř" (U+0159)
  0x68, 0x31, 0x77, 0x76, 0x75, 0x83, 0x67, 0x77, 0x17, 0x30, 0x10, 0xDB, 0x0B, 0x01, 0x71, 0x02,
  0x0C, 0xB0, 0xD0, 0x17, 0x40, 0x20, 0xEB, 0x0D, 0x03, 0x60, 0x40, 0xEB, 0x0D, 0x02, 0x76, 0x03,
  0x0E, 0xC0, 0x44, 0x06, 0xC0, 0xD0, 0x27, 0x71, 0x03, 0xD0, 0x52, 0x07, 0xC0, 0xE0, 0x27, 0x73,
  0x05, 0xD0, 0x50, 0x8C, 0x0E, 0x03, 0x77, 0x50, 0x6F, 0xB0, 0x47, 0x77, 0x08, 0xF9, 0x06, 0x77,
  0x72, 0x0B, 0xE0, 0x97, 0x77, 0x30, 0x20, 0xEC, 0x0D, 0x80, 0xAB, 0x60, 0x85, 0x36, 0x77, 0x64,
  0x14, 0x04, 0xFD, 0x0D, 0x50, 0x70, 0xEF, 0x83, 0xD8, 0x10, 0x4F, 0xE3, 0x01, 0x0C, 0xFC, 0x81,
  0x10, 0x4F, 0xE0, 0x12, 0x0C, 0xFC, 0x0C, 0x28, 0x22, 0x9B, 0xDF, 0xB8, 0x13, 0x0A, 0xE0, 0xED,
  0x07, 0x78, 0x31, 0x35, 0x7C, 0xC0, 0x05, 0xC0, 0xB0, 0x43, 0x83, 0x15, 0xCF, 0x27, 0x40, 0x7C,
  0x08, 0x0E, 0xA0, 0xE0, 0x57, 0x10, 0x47, 0x50, 0x7F, 0x90, 0x37, 0x77, 0x10, 0x7F, 0x06, 0x77,
  0x72, 0x07, 0xE0, 0xC7, 0x77, 0x30, 0x7E, 0x04, 0x77, 0x73, 0x07, 0xD0, 0xD7, 0x77, 0x40, 0x7D,
  0x08, 0x77, 0x74, 0x07, 0xD0, 0x47, 0x77, 0x40, 0x7D, 0x02, 0x77, 0x74, 0x07, 0xD7, 0x77, 0x50,
  0x7D, 0x77, 0x75, 0x07, 0xC0, 0xE7, 0x77, 0x50, 0x7C, 0x0E, 0x77, 0x75, 0x07, 0xC0, 0xE7, 0x77,
  0x50, 0x7C, 0x0E, 0x77, 0x75, 0x07, 0xC0, 0xE7, 0x77, 0x50, 0x7C, 0x0E, 0x77, 0x75, 0x07, 0xC0,
  0xE7, 0x77, 0x50, 0x7C, 0x0E, 0x77, 0x75, 0x07, 0xC0, 0xE7, 0x77, 0x50, 0x7C, 0x0E, 0x77, 0x75,
  0x07, 0xC0, 0xE7, 0x77, 0x18, 0x31, 0x24, 0x5B, 0xD8, 0x26, 0x43, 0x17, 0x58, 0x32, 0x9B, 0xCD,
  0xFF, 0xA8, 0x3E, 0xCB, 0x92, 0x60, 0x4F, 0xFF, 0xB0, 0x46, 0x04, 0xFF, 0xFB, 0x04, 0x60, 0x4F,
  0xFF, 0xB0, 0x46,
  // "Ś" (U+015A)
  0x77, 0x30, 0x58, 0x01, 0x70, 0x67, 0x75, 0x01, 0xE0, 0x97, 0x75, 0x0A, 0xD0, 0xC7, 0x75, 0x04,
  0xD0, 0xD0, 0x17, 0x75, 0x0D, 0xC0, 0xE0, 0x27, 0x75, 0x08, 0xC0, 0xE0, 0x27, 0x75, 0x03, 0xC0,
  0xE0, 0x37, 0x76, 0x0D, 0xB0, 0xE0, 0x37, 0x76, 0x09, 0xB0, 0xD0, 0x27, 0x76, 0x03, 0xB0, 0xB0,
  0x18, 0x09, 0xF4, 0x08, 0x90, 0x14, 0x56, 0x77, 0x65, 0x31, 0x77, 0x81, 0x28, 0xDF, 0xB8, 0x2E,
  0xA6, 0x27, 0x10, 0x10, 0xAF, 0xFB, 0x0C, 0x06, 0x50, 0x50, 0xEF, 0xFD, 0x09, 0x40, 0x5F, 0xB0,
  0xEF, 0xB0, 0x33, 0x02, 0xE8, 0x2E, 0x94, 0x14, 0x82, 0x25, 0x8D, 0xB0, 0xD4, 0x0A, 0xD0, 0xB0,
  0x17, 0x48, 0x22, 0x8E, 0x73, 0x02, 0xD0, 0xB7, 0x71, 0x00, 0x13, 0x07, 0xD0, 0x27, 0x76, 0x0B,
  0xC0, 0xD7, 0x77, 0x0C, 0xC0, 0xA7, 0x77, 0x0D, 0xC0, 0x97, 0x77, 0x0E, 0xC0, 0xA7, 0x77, 0x0D,
  0xC0, 0xC7, 0x77, 0x0B, 0xD0, 0x27, 0x76, 0x07, 0xD0, 0xB7, 0x76, 0x02, 0xE0, 0xA7, 0x76, 0x0A,
  0xE0, 0xE0, 0x67, 0x74, 0x01, 0x0D, 0xF0, 0xD0, 0x67, 0x73, 0x02, 0x0E, 0xF9, 0x81, 0xE7, 0x17,
  0x71, 0x03, 0x0D, 0xFA, 0x81, 0xE9, 0x27, 0x71, 0x09, 0xFC, 0x0A, 0x02, 0x77, 0x02, 0x0A, 0xFC,
  0x09, 0x01, 0x77, 0x03, 0x0B, 0xFB, 0x0E, 0x06, 0x77, 0x10, 0x30, 0xAF, 0xB0, 0x97, 0x72, 0x81,
  0x18, 0xEF, 0x90, 0x87, 0x73, 0x81, 0x18, 0xEF, 0x04, 0x77, 0x40, 0x10, 0x9E, 0x0C, 0x77, 0x60,
  0x5E, 0x03, 0x77, 0x60, 0x8D, 0x07, 0x77, 0x60, 0x1D, 0x09, 0x77, 0x70, 0xEC, 0x0A, 0x77, 0x70,
  0xCC, 0x0B, 0x77, 0x70, 0xDC, 0x09, 0x77, 0x70, 0xEC, 0x08, 0x77, 0x60, 0x4D, 0x05, 0x77, 0x60,
  0xBD, 0x01, 0x04, 0x77, 0x40, 0x6D, 0x84, 0xB0, 0xEE, 0x94, 0x77, 0x08, 0xE8, 0x13, 0x0E, 0xC8,
  0x2B, 0x85, 0x25, 0x82, 0x14, 0x8E, 0xE0, 0x92, 0x0E, 0xFB, 0x00, 0xEF, 0xB0, 0xA3, 0x0E, 0xFF,
  0xF0, 0x94, 0x08, 0x0E, 0xFF, 0xC0, 0xD0, 0x47, 0x82, 0x48, 0xBE, 0xFC, 0x81, 0xD9, 0x37, 0x68,
  0x91, 0x13, 0x56, 0x67, 0x76, 0x54, 0x17, 0x30,
  // "ś" (U+015B)
  0x77, 0x10, 0x58, 0x01, 0x70, 0x67, 0x72, 0x01, 0xE0, 0x97, 0x72, 0x0A, 0xD0, 0xC7, 0x72, 0x04,
  0xD0, 0xD0, 0x17, 0x72, 0x0D, 0xC0, 0xE0, 0x27, 0x72, 0x08, 0xC0, 0xE0, 0x27, 0x72, 0x03, 0xC0,
  0xE0, 0x37, 0x73, 0x0D, 0xB0, 0xE0, 0x37, 0x73, 0x09, 0xB0, 0xD0, 0x27, 0x73, 0x03, 0xB0, 0xB0,
  0x18, 0x09, 0xD6, 0x08, 0x73, 0x56, 0x77, 0x66, 0x42, 0x74, 0x81, 0x17, 0xCF, 0xB8, 0x2E, 0xB7,
  0x16, 0x08, 0xFF, 0xB0, 0xB0, 0x12, 0x01, 0x0C, 0xFF, 0xC0, 0xD3, 0x0B, 0xFA, 0x00, 0xEF, 0x90,
  0x72, 0x06, 0xD8, 0x2E, 0x84, 0x14, 0x82, 0x13, 0x6B, 0xB0, 0x22, 0x0C, 0xC0, 0xD0, 0x17, 0x48,
  0x11, 0x7A, 0x3D, 0x05, 0x77, 0x30, 0x1D, 0x01, 0x77, 0x30, 0x1D, 0x02, 0x77, 0x4D, 0x07, 0x77,
  0x40, 0xCD, 0x05, 0x77, 0x30, 0x5E, 0x0A, 0x02, 0x77, 0x20, 0xAF, 0x0A, 0x03, 0x77, 0x10, 0xAF,
  0x90, 0xC0, 0x57, 0x70, 0x60, 0xEF, 0x98, 0x1D, 0x71, 0x75, 0x81, 0x17, 0xEF, 0xA0, 0x90, 0x27,
  0x58, 0x11, 0x7E, 0xFA, 0x09, 0x01, 0x76, 0x06, 0x0C, 0xF9, 0x0E, 0x03, 0x77, 0x04, 0x0B, 0xF9,
  0x03, 0x77, 0x10, 0x20, 0xAE, 0x0D, 0x77, 0x30, 0x30, 0xED, 0x04, 0x77, 0x30, 0x3D, 0x08, 0x77,
  0x40, 0xCC, 0x0A, 0x77, 0x40, 0xBC, 0x0A, 0x77, 0x40, 0xDC, 0x08, 0x03, 0x77, 0x20, 0x3D, 0x83,
  0x6A, 0xE8, 0x27, 0x50, 0x10, 0xDD, 0x01, 0x0A, 0xB8, 0x2D, 0x85, 0x25, 0x82, 0x13, 0x8E, 0xD8,
  0x1A, 0x0A, 0xFA, 0x0F, 0xEF, 0x98, 0x2E, 0x10, 0xAF, 0xFD, 0x0E, 0x02, 0x20, 0x70, 0xEF, 0xFB,
  0x0A, 0x01, 0x58, 0x15, 0x9D, 0xFC, 0x81, 0xD8, 0x27, 0x48, 0x73, 0x56, 0x67, 0x76, 0x53, 0x72,
  // "Ŝ" (U+015C)
  0x74, 0x80, 0x17, 0x06, 0x77, 0x60, 0x6E, 0x04, 0x77, 0x40, 0x20, 0xEE, 0x0D, 0x01, 0x77, 0x20,
  0x10, 0xDF, 0x90, 0xB7, 0x72, 0x0B, 0xC0, 0xA0, 0xCC, 0x09, 0x77, 0x09, 0xC8, 0x29, 0x01, 0xCC,
  0x07, 0x75, 0x07, 0xC0, 0x93, 0x01, 0x0C, 0xC0, 0x67, 0x30, 0x6C, 0x08, 0x60, 0xBC, 0x05, 0x71,
  0x05, 0xC0, 0x77, 0x10, 0x9C, 0x04, 0x60, 0x1B, 0x0D, 0x03, 0x73, 0x05, 0x0E, 0xB0, 0x18, 0x09,
  0xE4, 0x08, 0x90, 0x14, 0x56, 0x77, 0x65, 0x31, 0x77, 0x81, 0x28, 0xDF, 0xB8, 0x2E, 0xA6, 0x27,
  0x10, 0x10, 0xAF, 0xFB, 0x0C, 0x06, 0x50, 0x50, 0xEF, 0xFD, 0x09, 0x40, 0x5F, 0xB0, 0xEF, 0xB0,
  0x33, 0x02, 0xE8, 0x2E, 0x94, 0x14, 0x82, 0x25, 0x8D, 0xB0, 0xD4, 0x0A, 0xD0, 0xB0, 0x17, 0x48,
  0x22, 0x8E, 0x73, 0x02, 0xD0, 0xB7, 0x71, 0x00, 0x13, 0x07, 0xD0, 0x27, 0x76, 0x0B, 0xC0, 0xD7,
  0x77, 0x0C, 0xC0, 0xA7, 0x77, 0x0D, 0xC0, 0x97, 0x77, 0x0E, 0xC0, 0xA7, 0x77, 0x0D, 0xC0, 0xC7,
  0x77, 0x0B, 0xD0, 0x27, 0x76, 0x07, 0xD0, 0xB7, 0x76, 0x02, 0xE0, 0xA7, 0x76, 0x0A, 0xE0, 0xE0,
  0x67, 0x74, 0x01, 0x0D, 0xF0, 0xD0, 0x67, 0x73, 0x02, 0x0E, 0xF9, 0x81, 0xE7, 0x17, 0x71, 0x03,
  0x0D, 0xFA, 0x81, 0xE9, 0x27, 0x71, 0x09, 0xFC, 0x0A, 0x02, 0x77, 0x02, 0x0A, 0xFC, 0x09, 0x01,
  0x77, 0x03, 0x0B, 0xFB, 0x0E, 0x06, 0x77, 0x10, 0x30, 0xAF, 0xB0, 0x97, 0x72, 0x81, 0x18, 0xEF,
  0x90, 0x87, 0x73, 0x81, 0x18, 0xEF, 0x04, 0x77, 0x40, 0x10, 0x9E, 0x0C, 0x77, 0x60, 0x5E, 0x03,
  0x77, 0x60, 0x8D, 0x07, 0x77, 0x60, 0x1D, 0x09, 0x77, 0x70, 0xEC, 0x0A, 0x77, 0x70, 0xCC, 0x0B,
  0x77, 0x70, 0xDC, 0x09, 0x77, 0x70, 0xEC, 0x08, 0x77, 0x60, 0x4D, 0x05, 0x77, 0x60, 0xBD, 0x01,
  0x04, 0x77, 0x40, 0x6D, 0x84, 0xB0, 0xEE, 0x94, 0x77, 0x08, 0xE8, 0x13, 0x0E, 0xC8, 0x2B, 0x85,
  0x25, 0x82, 0x14, 0x8E, 0xE0, 0x92, 0x0E, 0xFB, 0x00, 0xEF, 0xB0, 0xA3, 0x0E, 0xFF, 0xF0, 0x94,
  0x08, 0x0E, 0xFF, 0xC0, 0xD0, 0x47, 0x82, 0x48, 0xBE, 0xFC, 0x81, 0xD9, 0x37, 0x68, 0x91, 0x13,
  0x56, 0x67, 0x76, 0x54, 0x17, 0x30,
  // "ŝ" (U+015D)
  0x72, 0x80, 0x17, 0x06, 0x77, 0x30, 0x6E, 0x04, 0x77, 0x10, 0x20, 0xEE, 0x0D, 0x01, 0x76, 0x01,
  0x0D, 0xF9, 0x0B, 0x76, 0x0B, 0xC0, 0xA0, 0xCC, 0x09, 0x74, 0x09, 0xC8, 0x29, 0x01, 0xCC, 0x07,
  0x72, 0x07, 0xC0, 0x93, 0x01, 0x0C, 0xC0, 0x67, 0x06, 0xC0, 0x86, 0x0B, 0xC0, 0x55, 0x05, 0xC0,
  0x77, 0x10, 0x9C, 0x04, 0x30, 0x1B, 0x0D, 0x03, 0x73, 0x05, 0x0E, 0xB0, 0x18, 0x09, 0xC6, 0x08,
  0x73, 0x56, 0x77, 0x66, 0x42, 0x74, 0x81, 0x17, 0xCF, 0xB8, 0x2E, 0xB7, 0x16, 0x08, 0xFF, 0xB0,
  0xB0, 0x12, 0x01, 0x0C, 0xFF, 0xC0, 0xD3, 0x0B, 0xFA, 0x00, 0xEF, 0x90, 0x72, 0x06, 0xD8, 0x2E,
  0x84, 0x14, 0x82, 0x13, 0x6B, 0xB0, 0x22, 0x0C, 0xC0, 0xD0, 0x17, 0x48, 0x11, 0x7A, 0x3D, 0x05,
  0x77, 0x30, 0x1D, 0x01, 0x77, 0x30, 0x1D, 0x02, 0x77, 0x4D, 0x07, 0x77, 0x40, 0xCD, 0x05, 0x77,
  0x30, 0x5E, 0x0A, 0x02, 0x77, 0x20, 0xAF, 0x0A, 0x03, 0x77, 0x10, 0xAF, 0x90, 0xC0, 0x57, 0x70,
  0x60, 0xEF, 0x98, 0x1D, 0x71, 0x75, 0x81, 0x17, 0xEF, 0xA0, 0x90, 0x27, 0x58, 0x11, 0x7E, 0xFA,
  0x09, 0x01, 0x76, 0x06, 0x0C, 0xF9, 0x0E, 0x03, 0x77, 0x04, 0x0B, 0xF9, 0x03, 0x77, 0x10, 0x20,
  0xAE, 0x0D, 0x77, 0x30, 0x30, 0xED, 0x04, 0x77, 0x30, 0x3D, 0x08, 0x77, 0x40, 0xCC, 0x0A, 0x77,
  0x40, 0xBC, 0x0A, 0x77, 0x40, 0xDC, 0x08, 0x03, 0x77, 0x20, 0x3D, 0x83, 0x6A, 0xE8, 0x27, 0x50,
  0x10, 0xDD, 0x01, 0x0A, 0xB8, 0x2D, 0x85, 0x25, 0x82, 0x13, 0x8E, 0xD8, 0x1A, 0x0A, 0xFA, 0x0F,
  0xEF, 0x98, 0x2E, 0x10, 0xAF, 0xFD, 0x0E, 0x02, 0x20, 0x70, 0xEF, 0xFB, 0x0A, 0x01, 0x58, 0x15,
  0x9D, 0xFC, 0x81, 0xD8, 0x27, 0x48, 0x73, 0x56, 0x67, 0x76, 0x53, 0x72,
  // "Ş" (U+015E)
  0x73, 0x89, 0x01, 0x45, 0x67, 0x76, 0x53, 0x17, 0x78, 0x12, 0x8D, 0xFB, 0x82, 0xEA, 0x62, 0x71,
  0x01, 0x0A, 0xFF, 0xB0, 0xC0, 0x65, 0x05, 0x0E, 0xFF, 0xD0, 0x94, 0x05, 0xFB, 0x0E, 0xFB, 0x03,
  0x30, 0x2E, 0x82, 0xE9, 0x41, 0x48, 0x22, 0x58, 0xDB, 0x0D, 0x40, 0xAD, 0x0B, 0x01, 0x74, 0x82,
  0x28, 0xE7, 0x30, 0x2D, 0x0B, 0x77, 0x10, 0x01, 0x30, 0x7D, 0x02, 0x77, 0x60, 0xBC, 0x0D, 0x77,
  0x70, 0xCC, 0x0A, 0x77, 0x70, 0xDC, 0x09, 0x77, 0x70, 0xEC, 0x0A, 0x77, 0x70, 0xDC, 0x0C, 0x77,
  0x70, 0xBD, 0x02, 0x77, 0x60, 0x7D, 0x0B, 0x77, 0x60, 0x2E, 0x0A, 0x77, 0x60, 0xAE, 0x0E, 0x06,
  0x77, 0x40, 0x10, 0xDF, 0x0D, 0x06, 0x77, 0x30, 0x20, 0xEF, 0x98, 0x1E, 0x71, 0x77, 0x10, 0x30,
  0xDF, 0xA8, 0x1E, 0x92, 0x77, 0x10, 0x9F, 0xC0, 0xA0, 0x27, 0x70, 0x20, 0xAF, 0xC0, 0x90, 0x17,
  0x70, 0x30, 0xBF, 0xB0, 0xE0, 0x67, 0x71, 0x03, 0x0A, 0xFB, 0x09, 0x77, 0x28, 0x11, 0x8E, 0xF9,
  0x08, 0x77, 0x38, 0x11, 0x8E, 0xF0, 0x47, 0x74, 0x01, 0x09, 0xE0, 0xC7, 0x76, 0x05, 0xE0, 0x37,
  0x76, 0x08, 0xD0, 0x77, 0x76, 0x01, 0xD0, 0x97, 0x77, 0x0E, 0xC0, 0xA7, 0x77, 0x0C, 0xC0, 0xB7,
  0x77, 0x0D, 0xC0, 0x97, 0x77, 0x0E, 0xC0, 0x87, 0x76, 0x04, 0xD0, 0x57, 0x76, 0x0B, 0xD0, 0x10,
  0x47, 0x74, 0x06, 0xD8, 0x4B, 0x0E, 0xE9, 0x47, 0x70, 0x8E, 0x81, 0x30, 0xEC, 0x82, 0xB8, 0x52,
  0x58, 0x21, 0x48, 0xEE, 0x09, 0x20, 0xEF, 0xB0, 0x0E, 0xFB, 0x0A, 0x30, 0xEF, 0xFF, 0x09, 0x40,
  0x80, 0xEF, 0xFC, 0x0D, 0x04, 0x78, 0x24, 0x8B, 0xEF, 0xC8, 0x1D, 0x93, 0x76, 0x83, 0x13, 0x56,
  0x7B, 0x81, 0xD4, 0x17, 0x76, 0x06, 0xB0, 0x17, 0x77, 0x10, 0xDA, 0x0C, 0x77, 0x71, 0x05, 0xD0,
  0xA0, 0x27, 0x75, 0x09, 0xF0, 0x67, 0x76, 0x04, 0x09, 0xD0, 0x37, 0x77, 0x02, 0x0E, 0xB0, 0x97,
  0x77, 0x10, 0x8B, 0x0B, 0x77, 0x71, 0x07, 0xB0, 0xB7, 0x77, 0x10, 0xBB, 0x09, 0x77, 0x10, 0x30,
  0x12, 0x81, 0x14, 0xAC, 0x03, 0x77, 0x01, 0xFB, 0x08, 0x77, 0x10, 0x1F, 0x90, 0xE0, 0x67, 0x73,
  0x0C, 0x0E, 0xA8, 0x3E, 0xCA, 0x61, 0x74,
  // "ş" (U+015F)
  0x72, 0x87, 0x35, 0x67, 0x76, 0x64, 0x27, 0x48, 0x11, 0x7C, 0xFB, 0x82, 0xEB, 0x71, 0x60, 0x8F,
  0xFB, 0x0B, 0x01, 0x20, 0x10, 0xCF, 0xFC, 0x0D, 0x30, 0xBF, 0xA0, 0x0E, 0xF9, 0x07, 0x20, 0x6D,
  0x82, 0xE8, 0x41, 0x48, 0x21, 0x36, 0xBB, 0x02, 0x20, 0xCC, 0x0D, 0x01, 0x74, 0x81, 0x17, 0xA3,
  0xD0, 0x57, 0x73, 0x01, 0xD0, 0x17, 0x73, 0x01, 0xD0, 0x27, 0x74, 0xD0, 0x77, 0x74, 0x0C, 0xD0,
  0x57, 0x73, 0x05, 0xE0, 0xA0, 0x27, 0x72, 0x0A, 0xF0, 0xA0, 0x37, 0x71, 0x0A, 0xF9, 0x0C, 0x05,
  0x77, 0x06, 0x0E, 0xF9, 0x81, 0xD7, 0x17, 0x58, 0x11, 0x7E, 0xFA, 0x09, 0x02, 0x75, 0x81, 0x17,
  0xEF, 0xA0, 0x90, 0x17, 0x60, 0x60, 0xCF, 0x90, 0xE0, 0x37, 0x70, 0x40, 0xBF, 0x90, 0x37, 0x71,
  0x02, 0x0A, 0xE0, 0xD7, 0x73, 0x03, 0x0E, 0xD0, 0x47, 0x73, 0x03, 0xD0, 0x87, 0x74, 0x0C, 0xC0,
  0xA7, 0x74, 0x0B, 0xC0, 0xA7, 0x74, 0x0D, 0xC0, 0x80, 0x37, 0x72, 0x03, 0xD8, 0x36, 0xAE, 0x82,
  0x75, 0x01, 0x0D, 0xD0, 0x10, 0xAB, 0x82, 0xD8, 0x52, 0x58, 0x21, 0x38, 0xED, 0x81, 0xA0, 0xAF,
  0xA0, 0xFE, 0xF9, 0x82, 0xE1, 0x0A, 0xFF, 0xD0, 0xE0, 0x22, 0x07, 0x0E, 0xFF, 0xB0, 0xA0, 0x15,
  0x81, 0x59, 0xDF, 0xC8, 0x1D, 0x82, 0x74, 0x82, 0x35, 0x67, 0xB0, 0xD0, 0x37, 0x74, 0x06, 0xB0,
  0x17, 0x75, 0x0D, 0xA0, 0xC7, 0x75, 0x05, 0xD0, 0xA0, 0x27, 0x72, 0x09, 0xF0, 0x67, 0x73, 0x04,
  0x09, 0xD0, 0x37, 0x74, 0x02, 0x0E, 0xB0, 0x97, 0x75, 0x08, 0xB0, 0xB7, 0x75, 0x07, 0xB0, 0xB7,
  0x75, 0x0B, 0xB0, 0x97, 0x50, 0x30, 0x12, 0x81, 0x14, 0xAC, 0x03, 0x74, 0x01, 0xFB, 0x08, 0x75,
  0x01, 0xF9, 0x0E, 0x06, 0x77, 0x0C, 0x0E, 0xA8, 0x3E, 0xCA, 0x61, 0x72,
  // "Š" (U+0160)
  0x38, 0x31, 0x77, 0x76, 0x75, 0x83, 0x67, 0x77, 0x15, 0x01, 0x0D, 0xB0, 0xB0, 0x17, 0x10, 0x20,
  0xCB, 0x0D, 0x01, 0x60, 0x20, 0xEB, 0x0D, 0x03, 0x60, 0x40, 0xEB, 0x0D, 0x02, 0x71, 0x03, 0x0E,
  0xC0, 0x44, 0x06, 0xC0, 0xD0, 0x27, 0x30, 0x3D, 0x05, 0x20, 0x7C, 0x0E, 0x02, 0x75, 0x05, 0xD0,
  0x50, 0x8C, 0x0E, 0x03, 0x77, 0x06, 0xFB, 0x04, 0x77, 0x20, 0x8F, 0x90, 0x67, 0x74, 0x0B, 0xE0,
  0x97, 0x75, 0x02, 0x0E, 0xC0, 0xD8, 0x09, 0xF4, 0x08, 0x90, 0x14, 0x56, 0x77, 0x65, 0x31, 0x77,
  0x81, 0x28, 0xDF, 0xB8, 0x2E, 0xA6, 0x27, 0x10, 0x10, 0xAF, 0xFB, 0x0C, 0x06, 0x50, 0x50, 0xEF,
  0xFD, 0x09, 0x40, 0x5F, 0xB0, 0xEF, 0xB0, 0x33, 0x02, 0xE8, 0x2E, 0x94, 0x14, 0x82, 0x25, 0x8D,
  0xB0, 0xD4, 0x0A, 0xD0, 0xB0, 0x17, 0x48, 0x22, 0x8E, 0x73, 0x02, 0xD0, 0xB7, 0x71, 0x00, 0x13,
  0x07, 0xD0, 0x27, 0x76, 0x0B, 0xC0, 0xD7, 0x77, 0x0C, 0xC0, 0xA7, 0x77, 0x0D, 0xC0, 0x97, 0x77,
  0x0E, 0xC0, 0xA7, 0x77, 0x0D, 0xC0, 0xC7, 0x77, 0x0B, 0xD0, 0x27, 0x76, 0x07, 0xD0, 0xB7, 0x76,
  0x02, 0xE0, 0xA7, 0x76, 0x0A, 0xE0, 0xE0, 0x67, 0x74, 0x01, 0x0D, 0xF0, 0xD0, 0x67, 0x73, 0x02,
  0x0E, 0xF9, 0x81, 0xE7, 0x17, 0x71, 0x03, 0x0D, 0xFA, 0x81, 0xE9, 0x27, 0x71, 0x09, 0xFC, 0x0A,
  0x02, 0x77, 0x02, 0x0A, 0xFC, 0x09, 0x01, 0x77, 0x03, 0x0B, 0xFB, 0x0E, 0x06, 0x77, 0x10, 0x30,
  0xAF, 0xB0, 0x97, 0x72, 0x81, 0x18, 0xEF, 0x90, 0x87, 0x73, 0x81, 0x18, 0xEF, 0x04, 0x77, 0x40,
  0x10, 0x9E, 0x0C, 0x77, 0x60, 0x5E, 0x03, 0x77, 0x60, 0x8D, 0x07, 0x77, 0x60, 0x1D, 0x09, 0x77,
  0x70, 0xEC, 0x0A, 0x77, 0x70, 0xCC, 0x0B, 0x77, 0x70, 0xDC, 0x09, 0x77, 0x70, 0xEC, 0x08, 0x77,
  0x60, 0x4D, 0x05, 0x77, 0x60, 0xBD, 0x01, 0x04, 0x77, 0x40, 0x6D, 0x84, 0xB0, 0xEE, 0x94, 0x77,
  0x08, 0xE8, 0x13, 0x0E, 0xC8, 0x2B, 0x85, 0x25, 0x82, 0x14, 0x8E, 0xE0, 0x92, 0x0E, 0xFB, 0x00,
  0xEF, 0xB0, 0xA3, 0x0E, 0xFF, 0xF0, 0x94, 0x08, 0x0E, 0xFF, 0xC0, 0xD0, 0x47, 0x82, 0x48, 0xBE,
  0xFC, 0x81, 0xD9, 0x37, 0x68, 0x91, 0x13, 0x56, 0x67, 0x76, 0x54, 0x17, 0x30,
  // "š" (U+0161)
  0x18, 0x31, 0x77, 0x76, 0x75, 0x83, 0x67, 0x77, 0x12, 0x01, 0x0D, 0xB0, 0xB0, 0x17, 0x10, 0x20,
  0xCB, 0x0D, 0x01, 0x30, 0x20, 0xEB, 0x0D, 0x03, 0x60, 0x40, 0xEB, 0x0D, 0x02, 0x50, 0x30, 0xEC,
  0x04, 0x40, 0x6C, 0x0D, 0x02, 0x70, 0x3D, 0x05, 0x20, 0x7C, 0x0E, 0x02, 0x72, 0x05, 0xD0, 0x50,
  0x8C, 0x0E, 0x03, 0x74, 0x06, 0xFB, 0x04, 0x76, 0x08, 0xF9, 0x06, 0x77, 0x10, 0xBE, 0x09, 0x77,
  0x20, 0x20, 0xEC, 0x0D, 0x80, 0x9D, 0x60, 0x87, 0x35, 0x67, 0x76, 0x64, 0x27, 0x48, 0x11, 0x7C,
  0xFB, 0x82, 0xEB, 0x71, 0x60, 0x8F, 0xFB, 0x0B, 0x01, 0x20, 0x10, 0xCF, 0xFC, 0x0D, 0x30, 0xBF,
  0xA0, 0x0E, 0xF9, 0x07, 0x20, 0x6D, 0x82, 0xE8, 0x41, 0x48, 0x21, 0x36, 0xBB, 0x02, 0x20, 0xCC,
  0x0D, 0x01, 0x74, 0x81, 0x17, 0xA3, 0xD0, 0x57, 0x73, 0x01, 0xD0, 0x17, 0x73, 0x01, 0xD0, 0x27,
  0x74, 0xD0, 0x77, 0x74, 0x0C, 0xD0, 0x57, 0x73, 0x05, 0xE0, 0xA0, 0x27, 0x72, 0x0A, 0xF0, 0xA0,
  0x37, 0x71, 0x0A, 0xF9, 0x0C, 0x05, 0x77, 0x06, 0x0E, 0xF9, 0x81, 0xD7, 0x17, 0x58, 0x11, 0x7E,
  0xFA, 0x09, 0x02, 0x75, 0x81, 0x17, 0xEF, 0xA0, 0x90, 0x17, 0x60, 0x60, 0xCF, 0x90, 0xE0, 0x37,
  0x70, 0x40, 0xBF, 0x90, 0x37, 0x71, 0x02, 0x0A, 0xE0, 0xD7, 0x73, 0x03, 0x0E, 0xD0, 0x47, 0x73,
  0x03, 0xD0, 0x87, 0x74, 0x0C, 0xC0, 0xA7, 0x74, 0x0B, 0xC0, 0xA7, 0x74, 0x0D, 0xC0, 0x80, 0x37,
  0x72, 0x03, 0xD8, 0x36, 0xAE, 0x82, 0x75, 0x01, 0x0D, 0xD0, 0x10, 0xAB, 0x82, 0xD8, 0x52, 0x58,
  0x21, 0x38, 0xED, 0x81, 0xA0, 0xAF, 0xA0, 0xFE, 0xF9, 0x82, 0xE1, 0x0A, 0xFF, 0xD0, 0xE0, 0x22,
  0x07, 0x0E, 0xFF, 0xB0, 0xA0, 0x15, 0x81, 0x59, 0xDF, 0xC8, 0x1D, 0x82, 0x74, 0x87, 0x35, 0x66,
  0x77, 0x65, 0x37, 0x20,
  // "Ţ" (U+0162)
  0x04, 0xFF, 0xFF, 0xA0, 0x04, 0xFF, 0xFF, 0xA0, 0x04, 0xFF, 0xFF, 0xA0, 0x04, 0xFF, 0xFF, 0xA0,
  0x40, 0x18, 0x09, 0x06, 0x0C, 0xC0, 0xC8, 0x09, 0x06, 0x01, 0x76, 0x0A, 0xC0, 0xA7, 0x77, 0x50,
  0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7,
  0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75, 0x0A,
  0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77,
  0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC,
  0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77,
  0x50, 0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0,
  0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75,
  0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A,
  0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50,
  0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7,
  0x77, 0x50, 0xAC, 0x0B, 0x77, 0x76, 0x0E, 0xA0, 0x87, 0x77, 0x60, 0x6B, 0x01, 0x77, 0x76, 0x0D,
  0xA0, 0xC7, 0x77, 0x60, 0x5D, 0x0A, 0x02, 0x77, 0x73, 0x09, 0xF0, 0x67, 0x77, 0x40, 0x40, 0x9D,
  0x03, 0x77, 0x75, 0x02, 0x0E, 0xB0, 0x97, 0x77, 0x60, 0x8B, 0x0B, 0x77, 0x76, 0x07, 0xB0, 0xB7,
  0x77, 0x60, 0xBB, 0x09, 0x77, 0x60, 0x30, 0x12, 0x81, 0x14, 0xAC, 0x03, 0x77, 0x50, 0x1F, 0xB0,
  0x87, 0x76, 0x01, 0xF9, 0x0E, 0x06, 0x77, 0x71, 0x0C, 0x0E, 0xA8, 0x3E, 0xCA, 0x61, 0x76,
  // "ţ" (U+0163)
  0x73, 0x0D, 0xB0, 0x87, 0x77, 0x2C, 0x08, 0x77, 0x71, 0x01, 0xC0, 0x87, 0x77, 0x10, 0x3C, 0x08,
  0x77, 0x71, 0x05, 0xC0, 0x87, 0x77, 0x10, 0x7C, 0x08, 0x77, 0x71, 0x09, 0xC0, 0x87, 0x77, 0x10,
  0xBC, 0x08, 0x77, 0x70, 0x20, 0xDC, 0x08, 0x76, 0x85, 0x25, 0x79, 0xAC, 0xEF, 0xFE, 0x01, 0x09,
  0xFF, 0xFD, 0x01, 0x09, 0xFF, 0xFD, 0x01, 0x09, 0xFF, 0xFD, 0x01, 0x04, 0x80, 0x46, 0x0E, 0xC0,
  0xB8, 0x09, 0x06, 0x73, 0x0D, 0xC0, 0x87, 0x77, 0x10, 0xDC, 0x08, 0x77, 0x71, 0x0D, 0xC0, 0x87,
  0x77, 0x10, 0xDC, 0x08, 0x77, 0x71, 0x0D, 0xC0, 0x87, 0x77, 0x10, 0xDC, 0x08, 0x77, 0x71, 0x0D,
  0xC0, 0x87, 0x77, 0x10, 0xDC, 0x08, 0x77, 0x71, 0x0D, 0xC0, 0x87, 0x77, 0x10, 0xDC, 0x08, 0x77,
  0x71, 0x0D, 0xC0, 0x87, 0x77, 0x10, 0xDC, 0x08, 0x77, 0x71, 0x0D, 0xC0, 0x87, 0x77, 0x10, 0xDC,
  0x08, 0x77, 0x71, 0x0D, 0xC0, 0x87, 0x77, 0x10, 0xDC, 0x08, 0x77, 0x71, 0x0D, 0xC0, 0x87, 0x77,
  0x10, 0xDC, 0x09, 0x77, 0x71, 0x0C, 0xC0, 0xB7, 0x77, 0x10, 0xAC, 0x0E, 0x77, 0x71, 0x08, 0xD0,
  0x77, 0x77, 0x03, 0xE0, 0x47, 0x77, 0x0C, 0xE8, 0x1A, 0x41, 0x48, 0x22, 0x57, 0xA7, 0x30, 0x3F,
  0xA0, 0xFE, 0xC0, 0xE7, 0x40, 0x6F, 0xF9, 0x0E, 0x75, 0x04, 0x0D, 0xFE, 0x0E, 0x77, 0x81, 0x6B,
  0xEF, 0xA0, 0xD0, 0x97, 0x72, 0x01, 0xC8, 0x37, 0x75, 0x31, 0x77, 0x40, 0x6B, 0x01, 0x77, 0x72,
  0x0D, 0xA0, 0xC7, 0x77, 0x20, 0x5D, 0x0A, 0x02, 0x77, 0x60, 0x9F, 0x06, 0x77, 0x70, 0x40, 0x9D,
  0x03, 0x77, 0x71, 0x02, 0x0E, 0xB0, 0x97, 0x77, 0x20, 0x8B, 0x0B, 0x77, 0x72, 0x07, 0xB0, 0xB7,
  0x77, 0x20, 0xBB, 0x09, 0x77, 0x20, 0x30, 0x12, 0x81, 0x14, 0xAC, 0x03, 0x77, 0x10, 0x1F, 0xB0,
  0x87, 0x72, 0x01, 0xF9, 0x0E, 0x06, 0x77, 0x40, 0xC0, 0xEA, 0x83, 0xEC, 0xA6, 0x16,
  // "Ť" (U+0164)
  0x58, 0x31, 0x77, 0x76, 0x75, 0x83, 0x67, 0x77, 0x17, 0x30, 0x10, 0xDB, 0x0B, 0x01, 0x71, 0x02,
  0x0C, 0xB0, 0xD0, 0x17, 0x40, 0x20, 0xEB, 0x0D, 0x03, 0x60, 0x40, 0xEB, 0x0D, 0x02, 0x76, 0x03,
  0x0E, 0xC0, 0x44, 0x06, 0xC0, 0xD0, 0x27, 0x71, 0x03, 0xD0, 0x52, 0x07, 0xC0, 0xE0, 0x27, 0x73,
  0x05, 0xD0, 0x50, 0x8C, 0x0E, 0x03, 0x77, 0x50, 0x6F, 0xB0, 0x47, 0x77, 0x08, 0xF9, 0x06, 0x77,
  0x72, 0x0B, 0xE0, 0x97, 0x77, 0x30, 0x20, 0xEC, 0x0D, 0x80, 0xAD, 0x10, 0x04, 0xFF, 0xFF, 0xA0,
  0x04, 0xFF, 0xFF, 0xA0, 0x04, 0xFF, 0xFF, 0xA0, 0x04, 0xFF, 0xFF, 0xA0, 0x40, 0x18, 0x09, 0x06,
  0x0C, 0xC0, 0xC8, 0x09, 0x06, 0x01, 0x76, 0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75,
  0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A,
  0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50,
  0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7,
  0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75, 0x0A,
  0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77,
  0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC,
  0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77,
  0x50, 0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0,
  0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75,
  0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A,
  0x76,
  // "ť" (U+0165)
  0x77, 0x71, 0x08, 0xC0, 0xA7, 0x77, 0x10, 0xAC, 0x06, 0x77, 0x71, 0x0D, 0xC0, 0x17, 0x77, 0x1C,
  0x0A, 0x77, 0x71, 0x04, 0xC0, 0x37, 0x48, 0x32, 0x33, 0x31, 0x60, 0x7B, 0x0C, 0x75, 0x0D, 0xB0,
  0x86, 0x0A, 0xB0, 0x57, 0x5C, 0x08, 0x60, 0xEA, 0x0C, 0x75, 0x01, 0xC0, 0x85, 0x03, 0xB0, 0x47,
  0x50, 0x3C, 0x08, 0x50, 0x7A, 0x0B, 0x76, 0x05, 0xC0, 0x87, 0x77, 0x10, 0x7C, 0x08, 0x77, 0x71,
  0x09, 0xC0, 0x87, 0x77, 0x10, 0xBC, 0x08, 0x77, 0x68, 0x11, 0x3D, 0xC0, 0x87, 0x68, 0x52, 0x57,
  0x9B, 0xDE, 0xFF, 0xE0, 0x10, 0x9F, 0xFF, 0xD0, 0x10, 0x9F, 0xFF, 0xD0, 0x10, 0x9F, 0xFF, 0xD0,
  0x10, 0x48, 0x04, 0x60, 0xEC, 0x0B, 0x80, 0x90, 0x67, 0x30, 0xDC, 0x08, 0x77, 0x71, 0x0D, 0xC0,
  0x87, 0x77, 0x10, 0xDC, 0x08, 0x77, 0x71, 0x0D, 0xC0, 0x87, 0x77, 0x10, 0xDC, 0x08, 0x77, 0x71,
  0x0D, 0xC0, 0x87, 0x77, 0x10, 0xDC, 0x08, 0x77, 0x71, 0x0D, 0xC0, 0x87, 0x77, 0x10, 0xDC, 0x08,
  0x77, 0x71, 0x0D, 0xC0, 0x87, 0x77, 0x10, 0xDC, 0x08, 0x77, 0x71, 0x0D, 0xC0, 0x87, 0x77, 0x10,
  0xDC, 0x08, 0x77, 0x71, 0x0D, 0xC0, 0x87, 0x77, 0x10, 0xDC, 0x08, 0x77, 0x71, 0x0D, 0xC0, 0x87,
  0x77, 0x10, 0xDC, 0x08, 0x77, 0x71, 0x0D, 0xC0, 0x97, 0x77, 0x10, 0xCC, 0x0B, 0x77, 0x71, 0x0A,
  0xC0, 0xE7, 0x77, 0x10, 0x8D, 0x07, 0x77, 0x70, 0x3E, 0x04, 0x77, 0x70, 0xCE, 0x81, 0xA4, 0x14,
  0x82, 0x25, 0x7A, 0x73, 0x03, 0xFA, 0x0F, 0xEC, 0x0E, 0x74, 0x06, 0xFF, 0x90, 0xE7, 0x50, 0x40,
  0xDF, 0xE0, 0xE7, 0x78, 0x16, 0xBE, 0xFA, 0x0D, 0x09, 0x77, 0x38, 0x72, 0x56, 0x77, 0x75, 0x31,
  0x20,
  // "Ŧ" (U+0166)
  0x04, 0xFF, 0xFF, 0xA0, 0x04, 0xFF, 0xFF, 0xA0, 0x04, 0xFF, 0xFF, 0xA0, 0x04, 0xFF, 0xFF, 0xA0,
  0x40, 0x18, 0x09, 0x06, 0x0C, 0xC0, 0xC8, 0x09, 0x06, 0x01, 0x76, 0x0A, 0xC0, 0xA7, 0x77, 0x50,
  0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7,
  0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75, 0x0A,
  0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77,
  0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77, 0x30, 0x9F, 0xFF, 0x90, 0x97, 0x10, 0x9F,
  0xFF, 0x90, 0x97, 0x10, 0x9F, 0xFF, 0x90, 0x97, 0x10, 0x9F, 0xFF, 0x90, 0x97, 0x10, 0x38, 0x04,
  0x60, 0xCC, 0x0C, 0x80, 0x46, 0x04, 0x77, 0x30, 0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77,
  0x50, 0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0,
  0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75,
  0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A,
  0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50,
  0xAC, 0x0A, 0x77, 0x75, 0x0A, 0xC0, 0xA7, 0x77, 0x50, 0xAC, 0x0A, 0x76,
  // "ŧ" (U+0167)
  0x73, 0x0D, 0xB0, 0x87, 0x77, 0x2C, 0x08, 0x77, 0x71, 0x01, 0xC0, 0x87, 0x77, 0x10, 0x3C, 0x08,
  0x77, 0x71, 0x05, 0xC0, 0x87, 0x77, 0x10, 0x7C, 0x08, 0x77, 0x71, 0x09, 0xC0, 0x87, 0x77, 0x10,
  0xBC, 0x08, 0x77, 0x70, 0x20, 0xDC, 0x08, 0x76, 0x85, 0x25, 0x79, 0xAC, 0xEF, 0xFE, 0x01, 0x09,
  0xFF, 0xFD, 0x01, 0x09, 0xFF, 0xFD, 0x01, 0x09, 0xFF, 0xFD, 0x01, 0x04, 0x80, 0x46, 0x0E, 0xC0,
  0xB8, 0x09, 0x06, 0x73, 0x0D, 0xC0, 0x87, 0x77, 0x10, 0xDC, 0x08, 0x77, 0x71, 0x0D, 0xC0, 0x87,
  0x77, 0x10, 0xDC, 0x08, 0x77, 0x71, 0x0D, 0xC0, 0x87, 0x77, 0x10, 0xDC, 0x08, 0x76, 0x09, 0xFF,
  0xFD, 0x0E, 0x09, 0xFF, 0xFD, 0x0E, 0x09, 0xFF, 0xFD, 0x0E, 0x09, 0xFF, 0xFD, 0x0E, 0x04, 0x80,
  0x46, 0x0E, 0xC0, 0xB8, 0x09, 0x16, 0x72, 0x0D, 0xC0, 0x87, 0x77, 0x10, 0xDC, 0x08, 0x77, 0x71,
  0x0D, 0xC0, 0x87, 0x77, 0x10, 0xDC, 0x08, 0x77, 0x71, 0x0D, 0xC0, 0x87, 0x77, 0x10, 0xDC, 0x08,
  0x77, 0x71, 0x0D, 0xC0, 0x97, 0x77, 0x10, 0xCC, 0x0B, 0x77, 0x71, 0x0B, 0xC0, 0xE7, 0x77, 0x10,
  0x8D, 0x07, 0x77, 0x70, 0x3E, 0x04, 0x77, 0x70, 0xDE, 0x81, 0xA4, 0x14, 0x82, 0x24, 0x7A, 0x73,
  0x04, 0xFA, 0x0F, 0xEC, 0x0E, 0x74, 0x06, 0xFF, 0x90, 0xE7, 0x50, 0x40, 0xEF, 0xE0, 0xE7, 0x78,
  0x16, 0xBE, 0xFA, 0x0D, 0x09, 0x77, 0x38, 0x73, 0x56, 0x77, 0x75, 0x31, 0x20,
  // "Ũ" (U+0168)
  0x68, 0x51, 0x8D, 0xED, 0xB4, 0x71, 0x05, 0xA0, 0xB7, 0x10, 0x20, 0xEE, 0x0B, 0x02, 0x60, 0xBA,
  0x08, 0x70, 0x10, 0xDF, 0xA0, 0x74, 0x04, 0xB0, 0x47, 0x08, 0xFC, 0x82, 0xE9, 0x79, 0xB0, 0xE7,
  0x10, 0xEB, 0x82, 0x97, 0x8D, 0xFC, 0x08, 0x70, 0x5B, 0x05, 0x40, 0x70, 0xEF, 0x90, 0xD7, 0x10,
  0x8A, 0x0B, 0x60, 0x20, 0xBE, 0x0E, 0x02, 0x71, 0x0B, 0xA0, 0x67, 0x18, 0x54, 0xAD, 0xFD, 0x81,
  0x80, 0xA9, 0x60, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C,
  0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09,
  0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97,
  0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C,
  0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09,
  0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97,
  0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C,
  0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09,
  0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97,
  0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C,
  0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0xC0, 0xBC, 0x09, 0x77, 0x20,
  0xAC, 0x00, 0xBC, 0x0A, 0x77, 0x20, 0xAC, 0x0B, 0x0A, 0xC0, 0xB7, 0x72, 0x0B, 0xC0, 0x90, 0x8C,
  0x0E, 0x77, 0x20, 0xEC, 0x08, 0x05, 0xD0, 0x17, 0x70, 0x1D, 0x05, 0x02, 0xD0, 0x57, 0x70, 0x4D,
  0x81, 0x20, 0xEC, 0x0A, 0x77, 0x09, 0xC0, 0xD2, 0x09, 0xD0, 0x27, 0x50, 0x1D, 0x08, 0x20, 0x3D,
  0x0B, 0x75, 0x0B, 0xD0, 0x23, 0x0B, 0xD0, 0xA7, 0x30, 0xAD, 0x0A, 0x40, 0x2E, 0x81, 0xE7, 0x24,
  0x81, 0x27, 0xDD, 0x0E, 0x01, 0x50, 0x6F, 0xA0, 0x0E, 0xFA, 0x04, 0x70, 0x6F, 0xFB, 0x0E, 0x04,
  0x72, 0x03, 0x0D, 0xFF, 0x0B, 0x02, 0x75, 0x05, 0x0B, 0xFA, 0x81, 0xEA, 0x47, 0x73, 0x86, 0x35,
  0x67, 0x76, 0x52, 0x73,
  // "ũ" (U+0169)
  0x68, 0x51, 0x8D, 0xED, 0xB4, 0x71, 0x05, 0xA0, 0xB7, 0x10, 0x20, 0xEE, 0x0B, 0x02, 0x60, 0xBA,
  0x08, 0x70, 0x10, 0xDF, 0xA0, 0x74, 0x04, 0xB0, 0x47, 0x08, 0xFC, 0x82, 0xE9, 0x79, 0xB0, 0xE7,
  0x10, 0xEB, 0x82, 0x97, 0x8D, 0xFC, 0x08, 0x70, 0x5B, 0x05, 0x40, 0x70, 0xEF, 0x90, 0xD7, 0x10,
  0x8A, 0x0B, 0x60, 0x20, 0xBE, 0x0E, 0x02, 0x71, 0x0B, 0xA0, 0x67, 0x18, 0x54, 0xAD, 0xFD, 0x81,
  0x80, 0xA9, 0x60, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03,
  0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7,
  0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0,
  0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E,
  0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D,
  0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0,
  0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03,
  0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x4D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x04, 0xD0, 0x30, 0x7C,
  0x0E, 0x77, 0x10, 0x6D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x08, 0xD0, 0x30, 0x7D, 0x77, 0x10, 0xBD,
  0x03, 0x06, 0xD0, 0x17, 0x7E, 0x03, 0x05, 0xD0, 0x47, 0x60, 0x5E, 0x00, 0x3D, 0x09, 0x76, 0x0D,
  0xE8, 0x13, 0x0E, 0xC0, 0xE0, 0x17, 0x40, 0x8F, 0x81, 0x30, 0xAD, 0x0C, 0x01, 0x72, 0x08, 0xF9,
  0x81, 0x30, 0x3E, 0x81, 0xE7, 0x24, 0x81, 0x27, 0xDB, 0x0D, 0x0E, 0xC0, 0x32, 0x0A, 0xFA, 0x00,
  0xEE, 0x81, 0xE2, 0xBC, 0x03, 0x30, 0xCF, 0xFA, 0x81, 0x40, 0x8C, 0x03, 0x40, 0xAF, 0xE0, 0xD0,
  0x32, 0x06, 0xC0, 0x35, 0x81, 0x3A, 0xEF, 0x90, 0xC0, 0x64, 0x03, 0xC0, 0x37, 0x18, 0x63, 0x56,
  0x77, 0x64, 0x17, 0x50,
  // "Ū" (U+016A)
  0x50, 0x58, 0x09, 0x46, 0x05, 0x73, 0x0D, 0xFF, 0xA0, 0xE7, 0x30, 0xDF, 0xFA, 0x0E, 0x73, 0x0D,
  0xFF, 0xA0, 0xE7, 0x30, 0xDF, 0xFA, 0x0E, 0x80, 0xA9, 0x50, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0,
  0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72,
  0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0,
  0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0,
  0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72,
  0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0,
  0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0,
  0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72,
  0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0,
  0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0,
  0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72,
  0x09, 0xC0, 0xC0, 0xBC, 0x09, 0x77, 0x20, 0xAC, 0x00, 0xBC, 0x0A, 0x77, 0x20, 0xAC, 0x0B, 0x0A,
  0xC0, 0xB7, 0x72, 0x0B, 0xC0, 0x90, 0x8C, 0x0E, 0x77, 0x20, 0xEC, 0x08, 0x05, 0xD0, 0x17, 0x70,
  0x1D, 0x05, 0x02, 0xD0, 0x57, 0x70, 0x4D, 0x81, 0x20, 0xEC, 0x0A, 0x77, 0x09, 0xC0, 0xD2, 0x09,
  0xD0, 0x27, 0x50, 0x1D, 0x08, 0x20, 0x3D, 0x0B, 0x75, 0x0B, 0xD0, 0x23, 0x0B, 0xD0, 0xA7, 0x30,
  0xAD, 0x0A, 0x40, 0x2E, 0x81, 0xE7, 0x24, 0x81, 0x27, 0xDD, 0x0E, 0x01, 0x50, 0x6F, 0xA0, 0x0E,
  0xFA, 0x04, 0x70, 0x6F, 0xFB, 0x0E, 0x04, 0x72, 0x03, 0x0D, 0xFF, 0x0B, 0x02, 0x75, 0x05, 0x0B,
  0xFA, 0x81, 0xEA, 0x47, 0x73, 0x86, 0x35, 0x67, 0x76, 0x52, 0x73,
  // "ū" (U+016B)
  0x50, 0x58, 0x09, 0x46, 0x05, 0x73, 0x0D, 0xFF, 0xA0, 0xE7, 0x30, 0xDF, 0xFA, 0x0E, 0x73, 0x0D,
  0xFF, 0xA0, 0xE7, 0x30, 0xDF, 0xFA, 0x0E, 0x80, 0xA9, 0x50, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0,
  0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E,
  0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D,
  0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0,
  0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03,
  0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C,
  0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10,
  0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x4D, 0x03, 0x07,
  0xC0, 0xE7, 0x71, 0x04, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x6D, 0x03, 0x07, 0xC0, 0xE7, 0x71,
  0x08, 0xD0, 0x30, 0x7D, 0x77, 0x10, 0xBD, 0x03, 0x06, 0xD0, 0x17, 0x7E, 0x03, 0x05, 0xD0, 0x47,
  0x60, 0x5E, 0x00, 0x3D, 0x09, 0x76, 0x0D, 0xE8, 0x13, 0x0E, 0xC0, 0xE0, 0x17, 0x40, 0x8F, 0x81,
  0x30, 0xAD, 0x0C, 0x01, 0x72, 0x08, 0xF9, 0x81, 0x30, 0x3E, 0x81, 0xE7, 0x24, 0x81, 0x27, 0xDB,
  0x0D, 0x0E, 0xC0, 0x32, 0x0A, 0xFA, 0x00, 0xEE, 0x81, 0xE2, 0xBC, 0x03, 0x30, 0xCF, 0xFA, 0x81,
  0x40, 0x8C, 0x03, 0x40, 0xAF, 0xE0, 0xD0, 0x32, 0x06, 0xC0, 0x35, 0x81, 0x3A, 0xEF, 0x90, 0xC0,
  0x64, 0x03, 0xC0, 0x37, 0x18, 0x63, 0x56, 0x77, 0x64, 0x17, 0x50,
  // "Ŭ" (U+016C)
  0x40, 0x3B, 0x06, 0x73, 0x05, 0xB0, 0x47, 0x10, 0x1B, 0x0D, 0x73, 0x0C, 0xB0, 0x27, 0x20, 0xDB,
  0x0B, 0x02, 0x60, 0x10, 0xAB, 0x0D, 0x73, 0x06, 0xD8, 0x4B, 0x86, 0x78, 0xBD, 0x07, 0x74, 0x0C,
  0xFF, 0x0D, 0x75, 0x01, 0x0D, 0xFD, 0x0D, 0x01, 0x76, 0x01, 0x0A, 0xFB, 0x0A, 0x01, 0x77, 0x28,
  0x90, 0x38, 0xCE, 0xFE, 0xDB, 0x72, 0x80, 0xAA, 0x10, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C,
  0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09,
  0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97,
  0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C,
  0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09,
  0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97,
  0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C,
  0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09,
  0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97,
  0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C,
  0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09,
  0xC0, 0xC0, 0xBC, 0x09, 0x77, 0x20, 0xAC, 0x00, 0xBC, 0x0A, 0x77, 0x20, 0xAC, 0x0B, 0x0A, 0xC0,
  0xB7, 0x72, 0x0B, 0xC0, 0x90, 0x8C, 0x0E, 0x77, 0x20, 0xEC, 0x08, 0x05, 0xD0, 0x17, 0x70, 0x1D,
  0x05, 0x02, 0xD0, 0x57, 0x70, 0x4D, 0x81, 0x20, 0xEC, 0x0A, 0x77, 0x09, 0xC0, 0xD2, 0x09, 0xD0,
  0x27, 0x50, 0x1D, 0x08, 0x20, 0x3D, 0x0B, 0x75, 0x0B, 0xD0, 0x23, 0x0B, 0xD0, 0xA7, 0x30, 0xAD,
  0x0A, 0x40, 0x2E, 0x81, 0xE7, 0x24, 0x81, 0x27, 0xDD, 0x0E, 0x01, 0x50, 0x6F, 0xA0, 0x0E, 0xFA,
  0x04, 0x70, 0x6F, 0xFB, 0x0E, 0x04, 0x72, 0x03, 0x0D, 0xFF, 0x0B, 0x02, 0x75, 0x05, 0x0B, 0xFA,
  0x81, 0xEA, 0x47, 0x73, 0x86, 0x35, 0x67, 0x76, 0x52, 0x73,
  // "ŭ" (U+016D)
  0x40, 0x3B, 0x06, 0x73, 0x05, 0xB0, 0x47, 0x10, 0x1B, 0x0D, 0x73, 0x0C, 0xB0, 0x27, 0x20, 0xDB,
  0x0B, 0x02, 0x60, 0x10, 0xAB, 0x0D, 0x73, 0x06, 0xD8, 0x4B, 0x86, 0x78, 0xBD, 0x07, 0x74, 0x0C,
  0xFF, 0x0D, 0x75, 0x01, 0x0D, 0xFD, 0x0D, 0x01, 0x76, 0x01, 0x0A, 0xFB, 0x0A, 0x01, 0x77, 0x28,
  0x90, 0x38, 0xCE, 0xFE, 0xDB, 0x72, 0x80, 0xAA, 0x10, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30,
  0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77,
  0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03,
  0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7,
  0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0,
  0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E,
  0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D,
  0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x4D, 0x03, 0x07, 0xC0,
  0xE7, 0x71, 0x04, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x6D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x08,
  0xD0, 0x30, 0x7D, 0x77, 0x10, 0xBD, 0x03, 0x06, 0xD0, 0x17, 0x7E, 0x03, 0x05, 0xD0, 0x47, 0x60,
  0x5E, 0x00, 0x3D, 0x09, 0x76, 0x0D, 0xE8, 0x13, 0x0E, 0xC0, 0xE0, 0x17, 0x40, 0x8F, 0x81, 0x30,
  0xAD, 0x0C, 0x01, 0x72, 0x08, 0xF9, 0x81, 0x30, 0x3E, 0x81, 0xE7, 0x24, 0x81, 0x27, 0xDB, 0x0D,
  0x0E, 0xC0, 0x32, 0x0A, 0xFA, 0x00, 0xEE, 0x81, 0xE2, 0xBC, 0x03, 0x30, 0xCF, 0xFA, 0x81, 0x40,
  0x8C, 0x03, 0x40, 0xAF, 0xE0, 0xD0, 0x32, 0x06, 0xC0, 0x35, 0x81, 0x3A, 0xEF, 0x90, 0xC0, 0x64,
  0x03, 0xC0, 0x37, 0x18, 0x63, 0x56, 0x77, 0x64, 0x17, 0x50,
  // "Ů" (U+016E)
  0x73, 0x86, 0x39, 0xDF, 0xEC, 0x82, 0x77, 0x50, 0x7F, 0x90, 0x67, 0x73, 0x07, 0xFB, 0x05, 0x77,
  0x10, 0x10, 0xEA, 0x84, 0xE6, 0x11, 0x6E, 0xA0, 0xE7, 0x71, 0x05, 0xB0, 0x44, 0x05, 0xB0, 0x57,
  0x70, 0x8A, 0x0E, 0x60, 0xEA, 0x08, 0x77, 0x08, 0xA0, 0xC6, 0x0D, 0xA0, 0x87, 0x70, 0x8A, 0x0E,
  0x60, 0xEA, 0x07, 0x77, 0x05, 0xB0, 0x44, 0x05, 0xB0, 0x47, 0x71, 0x0E, 0xA8, 0x4E, 0x51, 0x16,
  0xEA, 0x0E, 0x77, 0x20, 0x6F, 0xB0, 0x57, 0x73, 0x07, 0xF9, 0x06, 0x77, 0x58, 0x63, 0x9D, 0xFE,
  0xD8, 0x28, 0x0A, 0xA2, 0x00, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x00, 0xCC, 0x09, 0x77, 0x20, 0x9C,
  0x00, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x00, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x00, 0xCC, 0x09, 0x77,
  0x20, 0x9C, 0x00, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x00, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x00, 0xCC,
  0x09, 0x77, 0x20, 0x9C, 0x00, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x00, 0xCC, 0x09, 0x77, 0x20, 0x9C,
  0x00, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x00, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x00, 0xCC, 0x09, 0x77,
  0x20, 0x9C, 0x00, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x00, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x00, 0xCC,
  0x09, 0x77, 0x20, 0x9C, 0x00, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x00, 0xCC, 0x09, 0x77, 0x20, 0x9C,
  0x00, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x00, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x00, 0xCC, 0x09, 0x77,
  0x20, 0x9C, 0x00, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x00, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x00, 0xCC,
  0x09, 0x77, 0x20, 0x9C, 0x00, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x00, 0xCC, 0x09, 0x77, 0x20, 0x9C,
  0x00, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x00, 0xCC, 0x09, 0x77, 0x20, 0x9C, 0x0C, 0x0B, 0xC0, 0x97,
  0x72, 0x0A, 0xC0, 0x0B, 0xC0, 0xA7, 0x72, 0x0A, 0xC0, 0xB0, 0xAC, 0x0B, 0x77, 0x20, 0xBC, 0x09,
  0x08, 0xC0, 0xE7, 0x72, 0x0E, 0xC0, 0x80, 0x5D, 0x01, 0x77, 0x01, 0xD0, 0x50, 0x2D, 0x05, 0x77,
  0x04, 0xD8, 0x12, 0x0E, 0xC0, 0xA7, 0x70, 0x9C, 0x0D, 0x20, 0x9D, 0x02, 0x75, 0x01, 0xD0, 0x82,
  0x03, 0xD0, 0xB7, 0x50, 0xBD, 0x02, 0x30, 0xBD, 0x0A, 0x73, 0x0A, 0xD0, 0xA4, 0x02, 0xE8, 0x1E,
  0x72, 0x48, 0x12, 0x7D, 0xD0, 0xE0, 0x15, 0x06, 0xFA, 0x00, 0xEF, 0xA0, 0x47, 0x06, 0xFF, 0xB0,
  0xE0, 0x47, 0x20, 0x30, 0xDF, 0xF0, 0xB0, 0x27, 0x50, 0x50, 0xBF, 0xA8, 0x1E, 0xA4, 0x77, 0x38,
  0x63, 0x56, 0x77, 0x65, 0x27, 0x30,
  // "ů" (U+016F)
  0x73, 0x86, 0x39, 0xDF, 0xEC, 0x82, 0x77, 0x50, 0x7F, 0x90, 0x67, 0x73, 0x07, 0xFB, 0x05, 0x77,
  0x10, 0x10, 0xEA, 0x84, 0xE6, 0x11, 0x6E, 0xA0, 0xE7, 0x71, 0x05, 0xB0, 0x44, 0x05, 0xB0, 0x57,
  0x70, 0x8A, 0x0E, 0x60, 0xEA, 0x08, 0x77, 0x08, 0xA0, 0xC6, 0x0D, 0xA0, 0x87, 0x70, 0x8A, 0x0E,
  0x60, 0xEA, 0x07, 0x77, 0x05, 0xB0, 0x44, 0x05, 0xB0, 0x47, 0x71, 0x0E, 0xA8, 0x4E, 0x51, 0x16,
  0xEA, 0x0E, 0x77, 0x20, 0x6F, 0xB0, 0x57, 0x73, 0x07, 0xF9, 0x06, 0x77, 0x58, 0x63, 0x9D, 0xFE,
  0xD8, 0x28, 0x0A, 0xA2, 0x00, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03,
  0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C,
  0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10,
  0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07,
  0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71,
  0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30,
  0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77,
  0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x04, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x4D, 0x03,
  0x07, 0xC0, 0xE7, 0x71, 0x06, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x8D, 0x03, 0x07, 0xD7, 0x71,
  0x0B, 0xD0, 0x30, 0x6D, 0x01, 0x77, 0xE0, 0x30, 0x5D, 0x04, 0x76, 0x05, 0xE0, 0x03, 0xD0, 0x97,
  0x60, 0xDE, 0x81, 0x30, 0xEC, 0x0E, 0x01, 0x74, 0x08, 0xF8, 0x13, 0x0A, 0xD0, 0xC0, 0x17, 0x20,
  0x8F, 0x98, 0x13, 0x03, 0xE8, 0x1E, 0x72, 0x48, 0x12, 0x7D, 0xB0, 0xD0, 0xEC, 0x03, 0x20, 0xAF,
  0xA0, 0x0E, 0xE8, 0x1E, 0x2B, 0xC0, 0x33, 0x0C, 0xFF, 0xA8, 0x14, 0x08, 0xC0, 0x34, 0x0A, 0xFE,
  0x0D, 0x03, 0x20, 0x6C, 0x03, 0x58, 0x13, 0xAE, 0xF9, 0x0C, 0x06, 0x40, 0x3C, 0x03, 0x71, 0x86,
  0x35, 0x67, 0x76, 0x41, 0x75,
  // "Ű" (U+0170)
  0x72, 0x0B, 0xD0, 0x33, 0x02, 0xD0, 0xC7, 0x30, 0x3D, 0x0B, 0x40, 0x9D, 0x04, 0x73, 0x0A, 0xC0,
  0xE0, 0x13, 0x02, 0xD0, 0x97, 0x30, 0x3D, 0x04, 0x40, 0xAC, 0x0C, 0x74, 0x0C, 0xC0, 0x74, 0x03,
  0xC0, 0xE0, 0x27, 0x30, 0x5C, 0x09, 0x50, 0xCC, 0x03, 0x74, 0x0D, 0xB0, 0xC5, 0x05, 0xC0, 0x57,
  0x40, 0x8B, 0x0C, 0x01, 0x40, 0x10, 0xEB, 0x07, 0x74, 0x03, 0xB0, 0xD0, 0x15, 0x09, 0xB0, 0x77,
  0x50, 0xAA, 0x0C, 0x01, 0x50, 0x1B, 0x06, 0x80, 0xAA, 0x10, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0,
  0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72,
  0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0,
  0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0,
  0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72,
  0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0,
  0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0,
  0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72,
  0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0,
  0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0,
  0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72,
  0x09, 0xC0, 0xC0, 0xBC, 0x09, 0x77, 0x20, 0xAC, 0x00, 0xBC, 0x0A, 0x77, 0x20, 0xAC, 0x0B, 0x0A,
  0xC0, 0xB7, 0x72, 0x0B, 0xC0, 0x90, 0x8C, 0x0E, 0x77, 0x20, 0xEC, 0x08, 0x05, 0xD0, 0x17, 0x70,
  0x1D, 0x05, 0x02, 0xD0, 0x57, 0x70, 0x4D, 0x81, 0x20, 0xEC, 0x0A, 0x77, 0x09, 0xC0, 0xD2, 0x09,
  0xD0, 0x27, 0x50, 0x1D, 0x08, 0x20, 0x3D, 0x0B, 0x75, 0x0B, 0xD0, 0x23, 0x0B, 0xD0, 0xA7, 0x30,
  0xAD, 0x0A, 0x40, 0x2E, 0x81, 0xE7, 0x24, 0x81, 0x27, 0xDD, 0x0E, 0x01, 0x50, 0x6F, 0xA0, 0x0E,
  0xFA, 0x04, 0x70, 0x6F, 0xFB, 0x0E, 0x04, 0x72, 0x03, 0x0D, 0xFF, 0x0B, 0x02, 0x75, 0x05, 0x0B,
  0xFA, 0x81, 0xEA, 0x47, 0x73, 0x86, 0x35, 0x67, 0x76, 0x52, 0x73,
  // "ű" (U+0171)
  0x72, 0x0B, 0xD0, 0x33, 0x02, 0xD0, 0xC7, 0x30, 0x3D, 0x0B, 0x40, 0x9D, 0x04, 0x73, 0x0A, 0xC0,
  0xE0, 0x13, 0x02, 0xD0, 0x97, 0x30, 0x3D, 0x04, 0x40, 0xAC, 0x0C, 0x74, 0x0C, 0xC0, 0x74, 0x03,
  0xC0, 0xE0, 0x27, 0x30, 0x5C, 0x09, 0x50, 0xCC, 0x03, 0x74, 0x0D, 0xB0, 0xC5, 0x05, 0xC0, 0x57,
  0x40, 0x8B, 0x0C, 0x01, 0x40, 0x10, 0xEB, 0x07, 0x74, 0x03, 0xB0, 0xD0, 0x15, 0x09, 0xB0, 0x77,
  0x50, 0xAA, 0x0C, 0x01, 0x50, 0x1B, 0x06, 0x80, 0xAA, 0x10, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0,
  0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E,
  0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D,
  0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0,
  0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03,
  0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C,
  0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10,
  0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x4D, 0x03, 0x07,
  0xC0, 0xE7, 0x71, 0x04, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x6D, 0x03, 0x07, 0xC0, 0xE7, 0x71,
  0x08, 0xD0, 0x30, 0x7D, 0x77, 0x10, 0xBD, 0x03, 0x06, 0xD0, 0x17, 0x7E, 0x03, 0x05, 0xD0, 0x47,
  0x60, 0x5E, 0x00, 0x3D, 0x09, 0x76, 0x0D, 0xE8, 0x13, 0x0E, 0xC0, 0xE0, 0x17, 0x40, 0x8F, 0x81,
  0x30, 0xAD, 0x0C, 0x01, 0x72, 0x08, 0xF9, 0x81, 0x30, 0x3E, 0x81, 0xE7, 0x24, 0x81, 0x27, 0xDB,
  0x0D, 0x0E, 0xC0, 0x32, 0x0A, 0xFA, 0x00, 0xEE, 0x81, 0xE2, 0xBC, 0x03, 0x30, 0xCF, 0xFA, 0x81,
  0x40, 0x8C, 0x03, 0x40, 0xAF, 0xE0, 0xD0, 0x32, 0x06, 0xC0, 0x35, 0x81, 0x3A, 0xEF, 0x90, 0xC0,
  0x64, 0x03, 0xC0, 0x37, 0x18, 0x63, 0x56, 0x77, 0x64, 0x17, 0x50,
  // "Ų" (U+0172)
  0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72,
  0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0,
  0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0,
  0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72,
  0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0,
  0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0,
  0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72,
  0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0,
  0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0,
  0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72,
  0x09, 0xC0, 0x0C, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0xC0, 0xBC, 0x09, 0x77, 0x20, 0xAC, 0x00, 0xBC,
  0x0A, 0x77, 0x20, 0xAC, 0x0B, 0x0A, 0xC0, 0xB7, 0x72, 0x0B, 0xC0, 0x90, 0x8C, 0x0E, 0x77, 0x20,
  0xEC, 0x07, 0x05, 0xD0, 0x17, 0x70, 0x1D, 0x04, 0x02, 0xD0, 0x57, 0x70, 0x4D, 0x20, 0xEC, 0x0A,
  0x77, 0x09, 0xC0, 0xB2, 0x09, 0xD0, 0x27, 0x50, 0x1D, 0x06, 0x20, 0x3D, 0x0B, 0x75, 0x0B, 0xC0,
  0xE0, 0x13, 0x0B, 0xD0, 0xA7, 0x30, 0xAD, 0x07, 0x40, 0x2E, 0x81, 0xE7, 0x24, 0x81, 0x27, 0xDD,
  0x0B, 0x60, 0x6F, 0xA0, 0x0E, 0xF9, 0x0C, 0x01, 0x70, 0x6F, 0xFB, 0x0A, 0x73, 0x03, 0x0D, 0xFE,
  0x0C, 0x03, 0x76, 0x05, 0x0B, 0xFB, 0x07, 0x77, 0x48, 0x23, 0x56, 0x9B, 0x0D, 0x02, 0x77, 0x70,
  0x30, 0xDA, 0x0B, 0x77, 0x71, 0x02, 0x0E, 0xA0, 0xB7, 0x77, 0x20, 0xDA, 0x0E, 0x01, 0x77, 0x71,
  0x07, 0xB0, 0x97, 0x77, 0x20, 0xCB, 0x05, 0x77, 0x72, 0xC0, 0x57, 0x77, 0x2C, 0x09, 0x77, 0x72,
  0x0D, 0xC8, 0x37, 0x10, 0x13, 0x77, 0x40, 0x9F, 0x90, 0xD7, 0x74, 0x02, 0x0E, 0xF0, 0xD7, 0x75,
  0x05, 0xF0, 0xD7, 0x76, 0x86, 0x29, 0xDE, 0xFD, 0xB6, 0x71,
  // "ų" (U+0173)
  0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD8, 0x13, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD8, 0x13, 0x07, 0xC0,
  0xE7, 0x71, 0x03, 0xD8, 0x13, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD8, 0x13, 0x07, 0xC0, 0xE7, 0x71,
  0x03, 0xD8, 0x13, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD8, 0x13, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD8,
  0x13, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD8, 0x13, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD8, 0x13, 0x07,
  0xC0, 0xE7, 0x71, 0x03, 0xD8, 0x13, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD8, 0x13, 0x07, 0xC0, 0xE7,
  0x71, 0x03, 0xD8, 0x13, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD8, 0x13, 0x07, 0xC0, 0xE7, 0x71, 0x03,
  0xD8, 0x13, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD8, 0x13, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD8, 0x13,
  0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD8, 0x13, 0x07, 0xC0, 0xE7, 0x71, 0x04, 0xD8, 0x13, 0x07, 0xC0,
  0xE7, 0x71, 0x04, 0xD8, 0x13, 0x07, 0xC0, 0xE7, 0x71, 0x06, 0xD8, 0x13, 0x07, 0xC0, 0xE7, 0x71,
  0x08, 0xD8, 0x13, 0x07, 0xD7, 0x71, 0x0B, 0xD8, 0x13, 0x06, 0xD0, 0x17, 0x7E, 0x81, 0x30, 0x5D,
  0x04, 0x76, 0x05, 0xE8, 0x13, 0x03, 0xD0, 0x97, 0x60, 0xDE, 0x03, 0x20, 0xEC, 0x0E, 0x01, 0x74,
  0x08, 0xF0, 0x32, 0x0A, 0xD0, 0xC0, 0x17, 0x20, 0x8F, 0x90, 0x32, 0x03, 0xE8, 0x1E, 0x72, 0x48,
  0x12, 0x7D, 0xB0, 0xD0, 0xEC, 0x03, 0x30, 0xAF, 0xA0, 0x0E, 0xE8, 0x1E, 0x2B, 0xC0, 0x34, 0x0C,
  0xFF, 0xA8, 0x14, 0x08, 0xC0, 0x35, 0x0A, 0xFE, 0x0D, 0x03, 0x20, 0x6C, 0x03, 0x68, 0x13, 0xAE,
  0xF9, 0x0C, 0x06, 0x40, 0xBC, 0x03, 0x72, 0x86, 0x35, 0x67, 0x76, 0x41, 0x50, 0x8B, 0x07, 0x77,
  0x72, 0x06, 0xB0, 0x97, 0x77, 0x20, 0x2B, 0x0C, 0x77, 0x73, 0x0B, 0xB0, 0x37, 0x77, 0x20, 0x2B,
  0x0D, 0x77, 0x73, 0x07, 0xB0, 0x97, 0x77, 0x30, 0x9B, 0x09, 0x77, 0x73, 0x0B, 0xB0, 0xC7, 0x77,
  0x30, 0x9C, 0x09, 0x02, 0x20, 0x37, 0x75, 0x06, 0xFA, 0x02, 0x77, 0x50, 0xDF, 0x90, 0x27, 0x75,
  0x03, 0x0E, 0xF0, 0x27, 0x76, 0x87, 0x18, 0xCE, 0xFE, 0xC8, 0x10,
  // "Ŵ" (U+0174)
  0x77, 0x80, 0x17, 0x06, 0x77, 0x76, 0x06, 0xE0, 0x47, 0x77, 0x40, 0x20, 0xEE, 0x0D, 0x01, 0x77,
  0x72, 0x01, 0x0D, 0xF9, 0x0B, 0x77, 0x72, 0x0B, 0xC0, 0xA0, 0xCC, 0x09, 0x77, 0x70, 0x9C, 0x82,
  0x90, 0x1C, 0xC0, 0x77, 0x75, 0x07, 0xC0, 0x93, 0x01, 0x0C, 0xC0, 0x67, 0x73, 0x06, 0xC0, 0x86,
  0x0B, 0xC0, 0x57, 0x71, 0x05, 0xC0, 0x77, 0x10, 0x9C, 0x04, 0x76, 0x01, 0xB0, 0xD0, 0x37, 0x30,
  0x50, 0xEB, 0x01, 0x80, 0xAD, 0x40, 0x06, 0xC0, 0x87, 0x77, 0x10, 0x8C, 0x06, 0x05, 0xC0, 0x97,
  0x77, 0x10, 0x9C, 0x05, 0x03, 0xC0, 0xB7, 0x77, 0x10, 0xAC, 0x03, 0x01, 0xC0, 0xC7, 0x77, 0x10,
  0xCC, 0x02, 0x1C, 0x0E, 0x77, 0x71, 0x0D, 0xC2, 0x0D, 0xC7, 0x77, 0x10, 0xEB, 0x0E, 0x20, 0xCC,
  0x01, 0x77, 0x7C, 0x0D, 0x20, 0xAC, 0x03, 0x77, 0x60, 0x2C, 0x0B, 0x20, 0x8C, 0x04, 0x77, 0x60,
  0x3C, 0x0A, 0x20, 0x6C, 0x06, 0x77, 0x60, 0x4C, 0x08, 0x20, 0x5C, 0x07, 0x77, 0x60, 0x6C, 0x06,
  0x20, 0x3C, 0x09, 0x70, 0x9C, 0x0B, 0x70, 0x7C, 0x05, 0x20, 0x1C, 0x0A, 0x70, 0xDD, 0x70, 0x8C,
  0x03, 0x3C, 0x0B, 0x60, 0x1E, 0x03, 0x60, 0xAC, 0x02, 0x30, 0xDB, 0x0D, 0x60, 0x5E, 0x07, 0x60,
  0xBC, 0x40, 0xCB, 0x0E, 0x60, 0x8E, 0x0B, 0x60, 0xCB, 0x0E, 0x40, 0xAC, 0x60, 0xCA, 0x0E, 0x0D,
  0xA0, 0xE6, 0x0D, 0xB0, 0xD4, 0x08, 0xC0, 0x25, 0xB0, 0xC0, 0xAB, 0x03, 0x5C, 0x0B, 0x40, 0x6C,
  0x03, 0x40, 0x4B, 0x0A, 0x07, 0xB0, 0x64, 0x01, 0xC0, 0x94, 0x05, 0xC0, 0x54, 0x07, 0xB0, 0x70,
  0x3B, 0x0A, 0x40, 0x2C, 0x08, 0x40, 0x3C, 0x06, 0x40, 0xBB, 0x04, 0x1B, 0x0E, 0x40, 0x3C, 0x06,
  0x40, 0x1C, 0x07, 0x40, 0xEB, 0x81, 0x10, 0xCB, 0x02, 0x30, 0x4C, 0x05, 0x5C, 0x09, 0x30, 0x3B,
  0x0D, 0x20, 0x9B, 0x06, 0x30, 0x5C, 0x03, 0x50, 0xDB, 0x0A, 0x30, 0x6B, 0x09, 0x20, 0x5B, 0x09,
  0x30, 0x6C, 0x02, 0x50, 0xBB, 0x0B, 0x30, 0xAB, 0x06, 0x20, 0x2B, 0x0D, 0x30, 0x7C, 0x60, 0xAB,
  0x0C, 0x30, 0xEB, 0x02, 0x30, 0xDB, 0x02, 0x20, 0x9B, 0x0E, 0x60, 0x8B, 0x0D, 0x20, 0x2B, 0x0E,
  0x40, 0xAB, 0x05, 0x20, 0xAB, 0x0D, 0x60, 0x6C, 0x20, 0x5B, 0x0A, 0x40, 0x6B, 0x09, 0x20, 0xBB,
  0x0B, 0x60, 0x5C, 0x20, 0x8B, 0x07, 0x40, 0x2B, 0x0D, 0x20, 0xCB, 0x09, 0x60, 0x3C, 0x81, 0x10,
  0xCB, 0x03, 0x50, 0xEB, 0x81, 0x10, 0xCB, 0x08, 0x60, 0x1C, 0x02, 0x1B, 0x0E, 0x60, 0xAB, 0x81,
  0x40, 0xDB, 0x06, 0x7C, 0x04, 0x03, 0xB0, 0xB6, 0x06, 0xB8, 0x17, 0x0E, 0xB0, 0x57, 0x0D, 0xB0,
  0x50, 0x6B, 0x08, 0x60, 0x3B, 0x0B, 0x1C, 0x03, 0x70, 0xBB, 0x06, 0x09, 0xB0, 0x47, 0x0E, 0xA0,
  0xE0, 0x1C, 0x02, 0x70, 0xAB, 0x06, 0x0C, 0xB7, 0x10, 0xAB, 0x04, 0xC7, 0x10, 0x8B, 0x08, 0xB0,
  0xC7, 0x10, 0x7B, 0x08, 0xB0, 0xE7, 0x10, 0x6B, 0x0B, 0xB0, 0x97, 0x10, 0x3B, 0x0B, 0xB0, 0xD7,
  0x10, 0x4F, 0x05, 0x72, 0x0E, 0xE0, 0xB7, 0x10, 0x3F, 0x01, 0x72, 0x0B, 0xE0, 0x97, 0x10, 0x1E,
  0x0D, 0x73, 0x07, 0xE0, 0x87, 0x2E, 0x0A, 0x73, 0x03, 0xE0, 0x67, 0x20, 0xDD, 0x06, 0x74, 0xE0,
  0x57, 0x20, 0xBD, 0x02, 0x74, 0x0B, 0xD0, 0x34,
  // "ŵ" (U+0175)
  0x77, 0x80, 0x17, 0x06, 0x77, 0x76, 0x06, 0xE0, 0x47, 0x77, 0x40, 0x20, 0xEE, 0x0D, 0x01, 0x77,
  0x72, 0x01, 0x0D, 0xF9, 0x0B, 0x77, 0x72, 0x0B, 0xC0, 0xA0, 0xCC, 0x09, 0x77, 0x70, 0x9C, 0x82,
  0x90, 0x1C, 0xC0, 0x77, 0x75, 0x07, 0xC0, 0x93, 0x01, 0x0C, 0xC0, 0x67, 0x73, 0x06, 0xC0, 0x86,
  0x0B, 0xC0, 0x57, 0x71, 0x05, 0xC0, 0x77, 0x10, 0x9C, 0x04, 0x76, 0x01, 0xB0, 0xD0, 0x37, 0x30,
  0x50, 0xEB, 0x01, 0x80, 0xAD, 0x40, 0x0E, 0xC0, 0x17, 0x77, 0x20, 0xDC, 0x0C, 0xC0, 0x37, 0x77,
  0x2C, 0x0D, 0x0A, 0xC0, 0x57, 0x77, 0x10, 0x3C, 0x0A, 0x07, 0xC0, 0x87, 0x77, 0x10, 0x5C, 0x07,
  0x05, 0xC0, 0xA7, 0x77, 0x10, 0x8C, 0x05, 0x02, 0xC0, 0xC7, 0x77, 0x10, 0xAC, 0x02, 0x1C, 0x0E,
  0x70, 0x2D, 0x0E, 0x01, 0x70, 0xDC, 0x20, 0xDC, 0x01, 0x60, 0x6E, 0x05, 0x7C, 0x0D, 0x20, 0xAC,
  0x04, 0x60, 0xBE, 0x09, 0x60, 0x2C, 0x0A, 0x20, 0x7C, 0x06, 0x6F, 0x0D, 0x60, 0x5C, 0x08, 0x20,
  0x5C, 0x08, 0x50, 0x4F, 0x90, 0x25, 0x07, 0xC0, 0x52, 0x02, 0xC0, 0xA5, 0x09, 0xB0, 0xC0, 0xDB,
  0x07, 0x50, 0xAC, 0x03, 0x3C, 0x0D, 0x50, 0xDB, 0x08, 0x09, 0xB0, 0xB5, 0x0C, 0xC4, 0x0D, 0xC4,
  0x02, 0xC0, 0x40, 0x5C, 0x50, 0xEB, 0x0D, 0x40, 0xAC, 0x02, 0x30, 0x7C, 0x10, 0x2C, 0x04, 0x30,
  0x2C, 0x0A, 0x40, 0x8C, 0x04, 0x30, 0xBB, 0x0C, 0x20, 0xDB, 0x08, 0x30, 0x4C, 0x08, 0x40, 0x5C,
  0x06, 0x3C, 0x08, 0x20, 0xAB, 0x0D, 0x30, 0x6C, 0x05, 0x40, 0x3C, 0x09, 0x20, 0x4C, 0x04, 0x20,
  0x6C, 0x01, 0x20, 0x9C, 0x03, 0x5C, 0x0A, 0x20, 0x8B, 0x0E, 0x30, 0x2C, 0x06, 0x20, 0xBC, 0x60,
  0xDB, 0x0C, 0x20, 0xCB, 0x0B, 0x40, 0xDB, 0x0A, 0x20, 0xDB, 0x0D, 0x60, 0xBB, 0x0E, 0x2C, 0x06,
  0x40, 0x9B, 0x0D, 0x20, 0xEB, 0x0B, 0x60, 0x8C, 0x10, 0x4C, 0x02, 0x40, 0x5C, 0x02, 0x1C, 0x08,
  0x60, 0x6C, 0x01, 0x07, 0xB0, 0xE5, 0x01, 0xC0, 0x50, 0x1C, 0x05, 0x60, 0x3C, 0x02, 0x0A, 0xB0,
  0xA6, 0x0D, 0xB0, 0x90, 0x3C, 0x03, 0x60, 0x1C, 0x03, 0x0D, 0xB0, 0x66, 0x09, 0xB0, 0xC0, 0x4C,
  0x71, 0x0E, 0xB0, 0x5C, 0x01, 0x60, 0x5C, 0x05, 0xB0, 0xD7, 0x10, 0xBB, 0x08, 0xB0, 0xD7, 0x01,
  0xC0, 0x9B, 0x0B, 0x71, 0x09, 0xB0, 0xDB, 0x09, 0x71, 0x0C, 0xB0, 0xDB, 0x08, 0x71, 0x06, 0xF0,
  0x57, 0x10, 0x8F, 0x06, 0x71, 0x04, 0xF0, 0x17, 0x10, 0x4F, 0x03, 0x71, 0x01, 0xE0, 0xC7, 0x3F,
  0x73, 0x0E, 0xD0, 0x87, 0x30, 0xCD, 0x0D, 0x50,
  // "Ŷ" (U+0176)
  0x76, 0x80, 0x17, 0x06, 0x77, 0x74, 0x06, 0xE0, 0x47, 0x77, 0x20, 0x20, 0xEE, 0x0D, 0x01, 0x77,
  0x70, 0x10, 0xDF, 0x90, 0xB7, 0x77, 0x0B, 0xC0, 0xA0, 0xCC, 0x09, 0x77, 0x50, 0x9C, 0x82, 0x90,
  0x1C, 0xC0, 0x77, 0x73, 0x07, 0xC0, 0x93, 0x01, 0x0C, 0xC0, 0x67, 0x71, 0x06, 0xC0, 0x86, 0x0B,
  0xC0, 0x57, 0x60, 0x5C, 0x07, 0x71, 0x09, 0xC0, 0x47, 0x40, 0x1B, 0x0D, 0x03, 0x73, 0x05, 0x0E,
  0xB0, 0x18, 0x0A, 0xC1, 0x00, 0xAD, 0x04, 0x77, 0x40, 0x1D, 0x0A, 0x02, 0xD0, 0xB7, 0x74, 0x08,
  0xD8, 0x12, 0x0A, 0xD0, 0x27, 0x73, 0x0E, 0xC0, 0xA2, 0x02, 0xD0, 0x97, 0x72, 0x07, 0xD0, 0x23,
  0x09, 0xD0, 0x17, 0x71, 0x0D, 0xC0, 0x94, 0x02, 0xD0, 0x87, 0x70, 0x5D, 0x02, 0x50, 0x9C, 0x0E,
  0x77, 0x0C, 0xC0, 0x96, 0x02, 0xD0, 0x77, 0x50, 0x4D, 0x02, 0x70, 0x9C, 0x0D, 0x75, 0x0B, 0xC0,
  0x97, 0x10, 0x2D, 0x05, 0x73, 0x03, 0xD0, 0x27, 0x20, 0x9C, 0x0C, 0x73, 0x0A, 0xC0, 0x97, 0x30,
  0x2D, 0x04, 0x71, 0x02, 0xD0, 0x27, 0x40, 0x9C, 0x0B, 0x71, 0x09, 0xC0, 0x97, 0x50, 0x2D, 0x03,
  0x60, 0x10, 0xEC, 0x02, 0x76, 0x09, 0xC0, 0xA6, 0x07, 0xC0, 0x97, 0x70, 0x1D, 0x01, 0x50, 0xEC,
  0x01, 0x77, 0x10, 0x9C, 0x08, 0x40, 0x6C, 0x09, 0x77, 0x20, 0x1C, 0x0E, 0x01, 0x30, 0xDC, 0x01,
  0x77, 0x30, 0x9C, 0x07, 0x20, 0x5C, 0x09, 0x77, 0x40, 0x1C, 0x0D, 0x20, 0xCC, 0x01, 0x77, 0x50,
  0x9C, 0x05, 0x03, 0xC0, 0x97, 0x76, 0x01, 0xC0, 0xC0, 0xBC, 0x01, 0x77, 0x70, 0x9F, 0x90, 0x87,
  0x77, 0x10, 0x1F, 0x90, 0x17, 0x77, 0x20, 0x8E, 0x08, 0x77, 0x73, 0x01, 0xE0, 0x17, 0x77, 0x40,
  0x9C, 0x09, 0x77, 0x75, 0x09, 0xC0, 0x97, 0x77, 0x50, 0x9C, 0x09, 0x77, 0x75, 0x09, 0xC0, 0x97,
  0x77, 0x50, 0x9C, 0x09, 0x77, 0x75, 0x09, 0xC0, 0x97, 0x77, 0x50, 0x9C, 0x09, 0x77, 0x75, 0x09,
  0xC0, 0x97, 0x77, 0x50, 0x9C, 0x09, 0x77, 0x75, 0x09, 0xC0, 0x97, 0x77, 0x50, 0x9C, 0x09, 0x77,
  0x75, 0x09, 0xC0, 0x97, 0x77, 0x50, 0x9C, 0x09, 0x77, 0x75, 0x09, 0xC0, 0x97, 0x77, 0x50, 0x9C,
  0x09, 0x77, 0x75, 0x09, 0xC0, 0x97, 0x77, 0x50, 0x9C, 0x09, 0x76,
  // "ŷ" (U+0177)
  0x76, 0x80, 0x17, 0x06, 0x77, 0x74, 0x06, 0xE0, 0x47, 0x77, 0x20, 0x20, 0xEE, 0x0D, 0x01, 0x77,
  0x70, 0x10, 0xDF, 0x90, 0xB7, 0x77, 0x0B, 0xC0, 0xA0, 0xCC, 0x09, 0x77, 0x50, 0x9C, 0x82, 0x90,
  0x1C, 0xC0, 0x77, 0x73, 0x07, 0xC0, 0x93, 0x01, 0x0C, 0xC0, 0x67, 0x71, 0x06, 0xC0, 0x86, 0x0B,
  0xC0, 0x57, 0x60, 0x5C, 0x07, 0x71, 0x09, 0xC0, 0x47, 0x40, 0x1B, 0x0D, 0x03, 0x73, 0x05, 0x0E,
  0xB0, 0x18, 0x0A, 0xC1, 0x00, 0x1D, 0x03, 0x77, 0x40, 0x7D, 0x81, 0x10, 0xAC, 0x09, 0x77, 0x40,
  0xCC, 0x0A, 0x20, 0x3C, 0x0E, 0x77, 0x30, 0x2D, 0x04, 0x30, 0xCC, 0x06, 0x77, 0x20, 0x7C, 0x0D,
  0x40, 0x5C, 0x0D, 0x77, 0x20, 0xCC, 0x08, 0x50, 0xEC, 0x04, 0x77, 0x02, 0xD0, 0x25, 0x08, 0xC0,
  0xA7, 0x70, 0x7C, 0x0C, 0x60, 0x1D, 0x01, 0x76, 0x0D, 0xC0, 0x67, 0x0A, 0xC0, 0x77, 0x50, 0x2C,
  0x0E, 0x71, 0x03, 0xC0, 0xE7, 0x50, 0x8C, 0x09, 0x72, 0x0C, 0xC0, 0x57, 0x40, 0xDC, 0x04, 0x72,
  0x06, 0xC0, 0xB7, 0x30, 0x3C, 0x0D, 0x74, 0x0E, 0xC0, 0x27, 0x20, 0x8C, 0x07, 0x74, 0x08, 0xC0,
  0x97, 0x20, 0xDC, 0x02, 0x74, 0x02, 0xC0, 0xE7, 0x10, 0x3C, 0x0B, 0x76, 0x0A, 0xC0, 0x67, 0x09,
  0xC0, 0x57, 0x60, 0x4C, 0x0C, 0x70, 0xEB, 0x0E, 0x77, 0x10, 0xDC, 0x03, 0x50, 0x4C, 0x09, 0x77,
  0x10, 0x6C, 0x0A, 0x50, 0x9C, 0x03, 0x77, 0x20, 0xEC, 0x01, 0x40, 0xEB, 0x0D, 0x77, 0x30, 0x8C,
  0x07, 0x30, 0x4C, 0x07, 0x77, 0x30, 0x2C, 0x0C, 0x30, 0x9C, 0x01, 0x77, 0x40, 0xBC, 0x02, 0x20,
  0xEB, 0x0B, 0x77, 0x50, 0x4C, 0x81, 0x70, 0x3C, 0x05, 0x77, 0x60, 0xDB, 0x81, 0xC0, 0x8B, 0x0E,
  0x77, 0x70, 0x6C, 0x02, 0x0D, 0xB0, 0x97, 0x77, 0x01, 0x0E, 0xB0, 0xAC, 0x03, 0x77, 0x71, 0x09,
  0xF0, 0xC7, 0x77, 0x20, 0x2F, 0x07, 0x77, 0x73, 0x0B, 0xE0, 0x17, 0x77, 0x30, 0x4D, 0x0A, 0x77,
  0x75, 0x0E, 0xC0, 0x47, 0x77, 0x40, 0x1C, 0x0E, 0x77, 0x75, 0x08, 0xC0, 0x87, 0x77, 0x50, 0xEC,
  0x02, 0x77, 0x74, 0x05, 0xC0, 0xC7, 0x77, 0x50, 0xCC, 0x06, 0x77, 0x74, 0x03, 0xC0, 0xE7, 0x77,
  0x50, 0xCC, 0x08, 0x77, 0x74, 0x08, 0xC0, 0xE0, 0x17, 0x77, 0x30, 0x8D, 0x08, 0x77, 0x38, 0x61,
  0x98, 0x76, 0x79, 0xED, 0x0E, 0x01, 0x77, 0x30, 0x2F, 0xD0, 0x47, 0x74, 0x02, 0xFC, 0x05, 0x77,
  0x50, 0x2F, 0xA0, 0xC0, 0x37, 0x76, 0x89, 0x01, 0xAC, 0xEE, 0xFE, 0xC9, 0x47, 0x77,
  // "Ÿ" (U+0178)
  0x78, 0x38, 0xDE, 0xB2, 0x71, 0x84, 0x2A, 0xEE, 0x91, 0x75, 0x0A, 0xC0, 0xE0, 0x17, 0x0D, 0xC0,
  0xB7, 0x5E, 0x05, 0x60, 0x3E, 0x01, 0x74, 0xE0, 0x66, 0x04, 0xE0, 0x27, 0x40, 0xED, 0x04, 0x60,
  0x2E, 0x75, 0x08, 0xC0, 0xD7, 0x10, 0xCC, 0x09, 0x76, 0x83, 0x7D, 0xEA, 0x27, 0x18, 0x31, 0xAE,
  0xD8, 0x80, 0xB8, 0x30, 0x0A, 0xD0, 0x47, 0x74, 0x01, 0xD0, 0xA0, 0x2D, 0x0B, 0x77, 0x40, 0x8D,
  0x81, 0x20, 0xAD, 0x02, 0x77, 0x30, 0xEC, 0x0A, 0x20, 0x2D, 0x09, 0x77, 0x20, 0x7D, 0x02, 0x30,
  0x9D, 0x01, 0x77, 0x10, 0xDC, 0x09, 0x40, 0x2D, 0x08, 0x77, 0x05, 0xD0, 0x25, 0x09, 0xC0, 0xE7,
  0x70, 0xCC, 0x09, 0x60, 0x2D, 0x07, 0x75, 0x04, 0xD0, 0x27, 0x09, 0xC0, 0xD7, 0x50, 0xBC, 0x09,
  0x71, 0x02, 0xD0, 0x57, 0x30, 0x3D, 0x02, 0x72, 0x09, 0xC0, 0xC7, 0x30, 0xAC, 0x09, 0x73, 0x02,
  0xD0, 0x47, 0x10, 0x2D, 0x02, 0x74, 0x09, 0xC0, 0xB7, 0x10, 0x9C, 0x09, 0x75, 0x02, 0xD0, 0x36,
  0x01, 0x0E, 0xC0, 0x27, 0x60, 0x9C, 0x0A, 0x60, 0x7C, 0x09, 0x77, 0x01, 0xD0, 0x15, 0x0E, 0xC0,
  0x17, 0x71, 0x09, 0xC0, 0x84, 0x06, 0xC0, 0x97, 0x72, 0x01, 0xC0, 0xE0, 0x13, 0x0D, 0xC0, 0x17,
  0x73, 0x09, 0xC0, 0x72, 0x05, 0xC0, 0x97, 0x74, 0x01, 0xC0, 0xD2, 0x0C, 0xC0, 0x17, 0x75, 0x09,
  0xC0, 0x50, 0x3C, 0x09, 0x77, 0x60, 0x1C, 0x0C, 0x0B, 0xC0, 0x17, 0x77, 0x09, 0xF9, 0x08, 0x77,
  0x71, 0x01, 0xF9, 0x01, 0x77, 0x72, 0x08, 0xE0, 0x87, 0x77, 0x30, 0x1E, 0x01, 0x77, 0x74, 0x09,
  0xC0, 0x97, 0x77, 0x50, 0x9C, 0x09, 0x77, 0x75, 0x09, 0xC0, 0x97, 0x77, 0x50, 0x9C, 0x09, 0x77,
  0x75, 0x09, 0xC0, 0x97, 0x77, 0x50, 0x9C, 0x09, 0x77, 0x75, 0x09, 0xC0, 0x97, 0x77, 0x50, 0x9C,
  0x09, 0x77, 0x75, 0x09, 0xC0, 0x97, 0x77, 0x50, 0x9C, 0x09, 0x77, 0x75, 0x09, 0xC0, 0x97, 0x77,
  0x50, 0x9C, 0x09, 0x77, 0x75, 0x09, 0xC0, 0x97, 0x77, 0x50, 0x9C, 0x09, 0x77, 0x75, 0x09, 0xC0,
  0x97, 0x77, 0x50, 0x9C, 0x09, 0x77, 0x75, 0x09, 0xC0, 0x97, 0x60,
  // "Ź" (U+0179)
  0x77, 0x30, 0x58, 0x01, 0x70, 0x67, 0x74, 0x01, 0xE0, 0x97, 0x74, 0x0A, 0xD0, 0xC7, 0x74, 0x04,
  0xD0, 0xD0, 0x17, 0x74, 0x0D, 0xC0, 0xE0, 0x27, 0x74, 0x08, 0xC0, 0xE0, 0x27, 0x74, 0x03, 0xC0,
  0xE0, 0x37, 0x75, 0x0D, 0xB0, 0xE0, 0x37, 0x75, 0x09, 0xB0, 0xD0, 0x27, 0x75, 0x03, 0xB0, 0xB0,
  0x18, 0x0A, 0x90, 0x00, 0x1F, 0xFF, 0xA8, 0x14, 0x01, 0xFF, 0xFA, 0x81, 0x40, 0x1F, 0xFF, 0xA8,
  0x14, 0x01, 0xFF, 0xFA, 0x04, 0x28, 0x09, 0x56, 0x0A, 0xC0, 0xE0, 0x17, 0x75, 0x0D, 0xC0, 0x77,
  0x75, 0x06, 0xC0, 0xE7, 0x76, 0x0E, 0xC0, 0x67, 0x75, 0x08, 0xC0, 0xD7, 0x75, 0x01, 0x0E, 0xC0,
  0x47, 0x75, 0x09, 0xC0, 0xB7, 0x75, 0x02, 0xD0, 0x37, 0x75, 0x0B, 0xC0, 0xA7, 0x75, 0x04, 0xD0,
  0x27, 0x75, 0x0C, 0xC0, 0x97, 0x75, 0x05, 0xC0, 0xE0, 0x17, 0x75, 0x0D, 0xC0, 0x77, 0x75, 0x07,
  0xC0, 0xE7, 0x75, 0x01, 0x0E, 0xC0, 0x67, 0x75, 0x08, 0xC0, 0xD7, 0x75, 0x01, 0xD0, 0x57, 0x75,
  0x0A, 0xC0, 0xC7, 0x75, 0x03, 0xD0, 0x37, 0x75, 0x0B, 0xC0, 0xB7, 0x75, 0x04, 0xD0, 0x27, 0x75,
  0x0C, 0xC0, 0x97, 0x75, 0x05, 0xD0, 0x17, 0x75, 0x0D, 0xC0, 0x87, 0x75, 0x07, 0xC0, 0xE0, 0x17,
  0x74, 0x01, 0x0E, 0xC0, 0x77, 0x75, 0x08, 0xC0, 0xD7, 0x75, 0x02, 0xD0, 0x57, 0x75, 0x0A, 0xC0,
  0xC7, 0x75, 0x03, 0xD0, 0x47, 0x75, 0x0B, 0xC0, 0xB7, 0x75, 0x04, 0xD0, 0x37, 0x75, 0x0D, 0xC0,
  0xA7, 0x75, 0x06, 0xD0, 0x27, 0x75, 0x0E, 0xC0, 0xC8, 0x09, 0x66, 0x01, 0x04, 0xFF, 0xFB, 0x00,
  0x4F, 0xFF, 0xB0, 0x04, 0xFF, 0xFB, 0x00, 0x4F, 0xFF, 0xB0, 0x40,
  // "ź" (U+017A)
  0x77, 0x30, 0x58, 0x01, 0x70, 0x67, 0x74, 0x01, 0xE0, 0x97, 0x74, 0x0A, 0xD0, 0xC7, 0x74, 0x04,
  0xD0, 0xD0, 0x17, 0x74, 0x0D, 0xC0, 0xE0, 0x27, 0x74, 0x08, 0xC0, 0xE0, 0x27, 0x74, 0x03, 0xC0,
  0xE0, 0x37, 0x75, 0x0D, 0xB0, 0xE0, 0x37, 0x75, 0x09, 0xB0, 0xD0, 0x27, 0x75, 0x03, 0xB0, 0xB0,
  0x18, 0x0A, 0x90, 0x00, 0x9F, 0xFF, 0xA8, 0x11, 0x09, 0xFF, 0xFA, 0x81, 0x10, 0x9F, 0xFF, 0xA8,
  0x11, 0x09, 0xFF, 0xFA, 0x81, 0x10, 0x48, 0x09, 0x56, 0x0E, 0xD0, 0x17, 0x74, 0x08, 0xD0, 0x97,
  0x74, 0x05, 0xD0, 0xB7, 0x74, 0x02, 0x0E, 0xC0, 0xD0, 0x17, 0x74, 0x0D, 0xD0, 0x37, 0x74, 0x0A,
  0xD0, 0x57, 0x74, 0x07, 0xD0, 0x87, 0x74, 0x04, 0xD0, 0xB7, 0x74, 0x01, 0x0E, 0xC0, 0xD0, 0x17,
  0x74, 0x0C, 0xC0, 0xE0, 0x27, 0x74, 0x09, 0xD0, 0x57, 0x74, 0x06, 0xD0, 0x87, 0x74, 0x03, 0xD0,
  0xB7, 0x74, 0x01, 0x0D, 0xC0, 0xD0, 0x17, 0x74, 0x0B, 0xC0, 0xE0, 0x27, 0x74, 0x08, 0xD0, 0x57,
  0x74, 0x05, 0xD0, 0x87, 0x74, 0x02, 0x0E, 0xC0, 0xA7, 0x75, 0x0D, 0xC0, 0xD7, 0x75, 0x0A, 0xC0,
  0xE0, 0x27, 0x74, 0x07, 0xD0, 0x47, 0x74, 0x03, 0xD0, 0x77, 0x74, 0x01, 0x0E, 0xC0, 0xA7, 0x75,
  0x0C, 0xD0, 0x78, 0x09, 0x56, 0x03, 0x07, 0xFF, 0xFB, 0x00, 0x9F, 0xFF, 0xB0, 0x09, 0xFF, 0xFB,
  0x00, 0x9F, 0xFF, 0xB0, 0x90,
  // "Ż" (U+017B)
  0x74, 0x84, 0x2A, 0xEE, 0xA2, 0x77, 0x50, 0x20, 0xEC, 0x0E, 0x02, 0x77, 0x40, 0x8E, 0x08, 0x77,
  0x40, 0xBE, 0x0B, 0x77, 0x40, 0xBE, 0x0B, 0x77, 0x40, 0x8E, 0x08, 0x77, 0x40, 0x20, 0xEC, 0x0E,
  0x02, 0x77, 0x58, 0x42, 0xAE, 0xEA, 0x28, 0x0A, 0xC2, 0x00, 0x1F, 0xFF, 0xA8, 0x14, 0x01, 0xFF,
  0xFA, 0x81, 0x40, 0x1F, 0xFF, 0xA8, 0x14, 0x01, 0xFF, 0xFA, 0x04, 0x28, 0x09, 0x56, 0x0A, 0xC0,
  0xE0, 0x17, 0x75, 0x0D, 0xC0, 0x77, 0x75, 0x06, 0xC0, 0xE7, 0x76, 0x0E, 0xC0, 0x67, 0x75, 0x08,
  0xC0, 0xD7, 0x75, 0x01, 0x0E, 0xC0, 0x47, 0x75, 0x09, 0xC0, 0xB7, 0x75, 0x02, 0xD0, 0x37, 0x75,
  0x0B, 0xC0, 0xA7, 0x75, 0x04, 0xD0, 0x27, 0x75, 0x0C, 0xC0, 0x97, 0x75, 0x05, 0xC0, 0xE0, 0x17,
  0x75, 0x0D, 0xC0, 0x77, 0x75, 0x07, 0xC0, 0xE7, 0x75, 0x01, 0x0E, 0xC0, 0x67, 0x75, 0x08, 0xC0,
  0xD7, 0x75, 0x01, 0xD0, 0x57, 0x75, 0x0A, 0xC0, 0xC7, 0x75, 0x03, 0xD0, 0x37, 0x75, 0x0B, 0xC0,
  0xB7, 0x75, 0x04, 0xD0, 0x27, 0x75, 0x0C, 0xC0, 0x97, 0x75, 0x05, 0xD0, 0x17, 0x75, 0x0D, 0xC0,
  0x87, 0x75, 0x07, 0xC0, 0xE0, 0x17, 0x74, 0x01, 0x0E, 0xC0, 0x77, 0x75, 0x08, 0xC0, 0xD7, 0x75,
  0x02, 0xD0, 0x57, 0x75, 0x0A, 0xC0, 0xC7, 0x75, 0x03, 0xD0, 0x47, 0x75, 0x0B, 0xC0, 0xB7, 0x75,
  0x04, 0xD0, 0x37, 0x75, 0x0D, 0xC0, 0xA7, 0x75, 0x06, 0xD0, 0x27, 0x75, 0x0E, 0xC0, 0xC8, 0x09,
  0x66, 0x01, 0x04, 0xFF, 0xFB, 0x00, 0x4F, 0xFF, 0xB0, 0x04, 0xFF, 0xFB, 0x00, 0x4F, 0xFF, 0xB0,
  0x40,
  // "ż" (U+017C)
  0x74, 0x84, 0x2A, 0xEE, 0xA2, 0x77, 0x50, 0x20, 0xEC, 0x0E, 0x02, 0x77, 0x40, 0x8E, 0x08, 0x77,
  0x40, 0xBE, 0x0B, 0x77, 0x40, 0xBE, 0x0B, 0x77, 0x40, 0x8E, 0x08, 0x77, 0x40, 0x20, 0xEC, 0x0E,
  0x02, 0x77, 0x58, 0x42, 0xAE, 0xEA, 0x28, 0x0A, 0xC2, 0x00, 0x9F, 0xFF, 0xA8, 0x11, 0x09, 0xFF,
  0xFA, 0x81, 0x10, 0x9F, 0xFF, 0xA8, 0x11, 0x09, 0xFF, 0xFA, 0x81, 0x10, 0x48, 0x09, 0x56, 0x0E,
  0xD0, 0x17, 0x74, 0x08, 0xD0, 0x97, 0x74, 0x05, 0xD0, 0xB7, 0x74, 0x02, 0x0E, 0xC0, 0xD0, 0x17,
  0x74, 0x0D, 0xD0, 0x37, 0x74, 0x0A, 0xD0, 0x57, 0x74, 0x07, 0xD0, 0x87, 0x74, 0x04, 0xD0, 0xB7,
  0x74, 0x01, 0x0E, 0xC0, 0xD0, 0x17, 0x74, 0x0C, 0xC0, 0xE0, 0x27, 0x74, 0x09, 0xD0, 0x57, 0x74,
  0x06, 0xD0, 0x87, 0x74, 0x03, 0xD0, 0xB7, 0x74, 0x01, 0x0D, 0xC0, 0xD0, 0x17, 0x74, 0x0B, 0xC0,
  0xE0, 0x27, 0x74, 0x08, 0xD0, 0x57, 0x74, 0x05, 0xD0, 0x87, 0x74, 0x02, 0x0E, 0xC0, 0xA7, 0x75,
  0x0D, 0xC0, 0xD7, 0x75, 0x0A, 0xC0, 0xE0, 0x27, 0x74, 0x07, 0xD0, 0x47, 0x74, 0x03, 0xD0, 0x77,
  0x74, 0x01, 0x0E, 0xC0, 0xA7, 0x75, 0x0C, 0xD0, 0x78, 0x09, 0x56, 0x03, 0x07, 0xFF, 0xFB, 0x00,
  0x9F, 0xFF, 0xB0, 0x09, 0xFF, 0xFB, 0x00, 0x9F, 0xFF, 0xB0, 0x90,
  // "Ž" (U+017D)
  0x38, 0x31, 0x77, 0x76, 0x75, 0x83, 0x67, 0x77, 0x14, 0x01, 0x0D, 0xB0, 0xB0, 0x17, 0x10, 0x20,
  0xCB, 0x0D, 0x01, 0x50, 0x20, 0xEB, 0x0D, 0x03, 0x60, 0x40, 0xEB, 0x0D, 0x02, 0x70, 0x30, 0xEC,
  0x04, 0x40, 0x6C, 0x0D, 0x02, 0x72, 0x03, 0xD0, 0x52, 0x07, 0xC0, 0xE0, 0x27, 0x40, 0x5D, 0x05,
  0x08, 0xC0, 0xE0, 0x37, 0x60, 0x6F, 0xB0, 0x47, 0x71, 0x08, 0xF9, 0x06, 0x77, 0x30, 0xBE, 0x09,
  0x77, 0x40, 0x20, 0xEC, 0x0D, 0x80, 0xA9, 0x00, 0x01, 0xFF, 0xFA, 0x81, 0x40, 0x1F, 0xFF, 0xA8,
  0x14, 0x01, 0xFF, 0xFA, 0x81, 0x40, 0x1F, 0xFF, 0xA0, 0x42, 0x80, 0x95, 0x60, 0xAC, 0x0E, 0x01,
  0x77, 0x50, 0xDC, 0x07, 0x77, 0x50, 0x6C, 0x0E, 0x77, 0x60, 0xEC, 0x06, 0x77, 0x50, 0x8C, 0x0D,
  0x77, 0x50, 0x10, 0xEC, 0x04, 0x77, 0x50, 0x9C, 0x0B, 0x77, 0x50, 0x2D, 0x03, 0x77, 0x50, 0xBC,
  0x0A, 0x77, 0x50, 0x4D, 0x02, 0x77, 0x50, 0xCC, 0x09, 0x77, 0x50, 0x5C, 0x0E, 0x01, 0x77, 0x50,
  0xDC, 0x07, 0x77, 0x50, 0x7C, 0x0E, 0x77, 0x50, 0x10, 0xEC, 0x06, 0x77, 0x50, 0x8C, 0x0D, 0x77,
  0x50, 0x1D, 0x05, 0x77, 0x50, 0xAC, 0x0C, 0x77, 0x50, 0x3D, 0x03, 0x77, 0x50, 0xBC, 0x0B, 0x77,
  0x50, 0x4D, 0x02, 0x77, 0x50, 0xCC, 0x09, 0x77, 0x50, 0x5D, 0x01, 0x77, 0x50, 0xDC, 0x08, 0x77,
  0x50, 0x7C, 0x0E, 0x01, 0x77, 0x40, 0x10, 0xEC, 0x07, 0x77, 0x50, 0x8C, 0x0D, 0x77, 0x50, 0x2D,
  0x05, 0x77, 0x50, 0xAC, 0x0C, 0x77, 0x50, 0x3D, 0x04, 0x77, 0x50, 0xBC, 0x0B, 0x77, 0x50, 0x4D,
  0x03, 0x77, 0x50, 0xDC, 0x0A, 0x77, 0x50, 0x6D, 0x02, 0x77, 0x50, 0xEC, 0x0C, 0x80, 0x96, 0x60,
  0x10, 0x4F, 0xFF, 0xB0, 0x04, 0xFF, 0xFB, 0x00, 0x4F, 0xFF, 0xB0, 0x04, 0xFF, 0xFB, 0x04,
  // "ž" (U+017E)
  0x38, 0x31, 0x77, 0x76, 0x75, 0x83, 0x67, 0x77, 0x14, 0x01, 0x0D, 0xB0, 0xB0, 0x17, 0x10, 0x20,
  0xCB, 0x0D, 0x01, 0x50, 0x20, 0xEB, 0x0D, 0x03, 0x60, 0x40, 0xEB, 0x0D, 0x02, 0x70, 0x30, 0xEC,
  0x04, 0x40, 0x6C, 0x0D, 0x02, 0x72, 0x03, 0xD0, 0x52, 0x07, 0xC0, 0xE0, 0x27, 0x40, 0x5D, 0x05,
  0x08, 0xC0, 0xE0, 0x37, 0x60, 0x6F, 0xB0, 0x47, 0x71, 0x08, 0xF9, 0x06, 0x77, 0x30, 0xBE, 0x09,
  0x77, 0x40, 0x20, 0xEC, 0x0D, 0x80, 0xA9, 0x00, 0x09, 0xFF, 0xFA, 0x81, 0x10, 0x9F, 0xFF, 0xA8,
  0x11, 0x09, 0xFF, 0xFA, 0x81, 0x10, 0x9F, 0xFF, 0xA8, 0x11, 0x04, 0x80, 0x95, 0x60, 0xED, 0x01,
  0x77, 0x40, 0x8D, 0x09, 0x77, 0x40, 0x5D, 0x0B, 0x77, 0x40, 0x20, 0xEC, 0x0D, 0x01, 0x77, 0x40,
  0xDD, 0x03, 0x77, 0x40, 0xAD, 0x05, 0x77, 0x40, 0x7D, 0x08, 0x77, 0x40, 0x4D, 0x0B, 0x77, 0x40,
  0x10, 0xEC, 0x0D, 0x01, 0x77, 0x40, 0xCC, 0x0E, 0x02, 0x77, 0x40, 0x9D, 0x05, 0x77, 0x40, 0x6D,
  0x08, 0x77, 0x40, 0x3D, 0x0B, 0x77, 0x40, 0x10, 0xDC, 0x0D, 0x01, 0x77, 0x40, 0xBC, 0x0E, 0x02,
  0x77, 0x40, 0x8D, 0x05, 0x77, 0x40, 0x5D, 0x08, 0x77, 0x40, 0x20, 0xEC, 0x0A, 0x77, 0x50, 0xDC,
  0x0D, 0x77, 0x50, 0xAC, 0x0E, 0x02, 0x77, 0x40, 0x7D, 0x04, 0x77, 0x40, 0x3D, 0x07, 0x77, 0x40,
  0x10, 0xEC, 0x0A, 0x77, 0x50, 0xCD, 0x07, 0x80, 0x95, 0x60, 0x30, 0x7F, 0xFF, 0xB0, 0x09, 0xFF,
  0xFB, 0x00, 0x9F, 0xFF, 0xB0, 0x09, 0xFF, 0xFB, 0x09,
  // "ſ" (U+017F)
  0x78, 0x92, 0x58, 0xBD, 0xEF, 0xEE, 0xCA, 0x74, 0x58, 0x11, 0x8E, 0xFD, 0x0B, 0x30, 0x40, 0xEF,
  0xF0, 0x72, 0x04, 0xFF, 0xA8, 0x12, 0x01, 0xF8, 0x5D, 0x97, 0x67, 0x9C, 0xA0, 0xD2, 0x09, 0xD0,
  0xD0, 0x47, 0x81, 0x15, 0x62, 0xD0, 0xE0, 0x17, 0x50, 0x4D, 0x06, 0x76, 0x07, 0xD7, 0x70, 0x9C,
  0x0C, 0x77, 0x0A, 0xC0, 0x97, 0x70, 0xBC, 0x09, 0x77, 0x0B, 0xC0, 0x87, 0x70, 0xBC, 0x08, 0x77,
  0x0B, 0xC0, 0x87, 0x70, 0xBC, 0x08, 0x77, 0x0B, 0xC0, 0x87, 0x70, 0xBC, 0x08, 0x77, 0x0B, 0xC0,
  0x87, 0x70, 0xBC, 0x08, 0x77, 0x0B, 0xC0, 0x87, 0x70, 0xBC, 0x08, 0x77, 0x0B, 0xC0, 0x87, 0x70,
  0xBC, 0x08, 0x77, 0x0B, 0xC0, 0x87, 0x70, 0xBC, 0x08, 0x77, 0x0B, 0xC0, 0x87, 0x70, 0xBC, 0x08,
  0x77, 0x0B, 0xC0, 0x87, 0x70, 0xBC, 0x08, 0x77, 0x0B, 0xC0, 0x87, 0x70, 0xBC, 0x08, 0x77, 0x0B,
  0xC0, 0x87, 0x70, 0xBC, 0x08, 0x77, 0x0B, 0xC0, 0x87, 0x70, 0xBC, 0x08, 0x77, 0x0B, 0xC0, 0x87,
  0x70, 0xBC, 0x08, 0x77, 0x0B, 0xC0, 0x87, 0x70, 0xBC, 0x08, 0x77, 0x0B, 0xC0, 0x87, 0x70, 0xBC,
  0x08, 0x77, 0x0B, 0xC0, 0x87, 0x70, 0xBC, 0x08, 0x77, 0x0B, 0xC0, 0x87, 0x70, 0xBC, 0x08, 0x77,
  // "Ω" (U+03A9)
  0x76, 0x86, 0x24, 0x67, 0x76, 0x52, 0x77, 0x72, 0x81, 0x28, 0xDF, 0x98, 0x1E, 0x93, 0x77, 0x40,
  0x10, 0xAF, 0xF0, 0xA0, 0x17, 0x71, 0x03, 0x0E, 0xFF, 0xA0, 0xE0, 0x47, 0x60, 0x4F, 0xB0, 0xEF,
  0xA0, 0x47, 0x40, 0x20, 0xEE, 0x81, 0xA4, 0x13, 0x81, 0x38, 0xED, 0x0E, 0x02, 0x73, 0x0C, 0xD0,
  0xD0, 0x37, 0x10, 0x10, 0xBD, 0x0C, 0x72, 0x06, 0xD0, 0xD0, 0x17, 0x40, 0xBD, 0x06, 0x71, 0x0E,
  0xD0, 0x37, 0x50, 0x10, 0xEC, 0x0D, 0x70, 0x5D, 0x08, 0x77, 0x07, 0xD0, 0x46, 0x0B, 0xD0, 0x17,
  0x70, 0x1D, 0x0A, 0x50, 0x1D, 0x0A, 0x77, 0x20, 0xAC, 0x0E, 0x50, 0x4D, 0x06, 0x77, 0x20, 0x6D,
  0x03, 0x40, 0x7D, 0x02, 0x77, 0x20, 0x2D, 0x06, 0x40, 0xAC, 0x0E, 0x77, 0x4D, 0x09, 0x40, 0xCC,
  0x0C, 0x77, 0x40, 0xDC, 0x0B, 0x40, 0xEC, 0x0A, 0x77, 0x40, 0xBC, 0x0D, 0x4D, 0x09, 0x77, 0x40,
  0x9C, 0x0E, 0x4D, 0x08, 0x77, 0x40, 0x8C, 0x0E, 0x4D, 0x07, 0x77, 0x40, 0x8D, 0x4D, 0x07, 0x77,
  0x40, 0x7D, 0x4D, 0x07, 0x77, 0x40, 0x7C, 0x0E, 0x4D, 0x07, 0x77, 0x40, 0x7C, 0x0D, 0x40, 0xDC,
  0x08, 0x77, 0x40, 0x8C, 0x0D, 0x40, 0xCC, 0x09, 0x77, 0x40, 0x9C, 0x0B, 0x40, 0xAC, 0x0A, 0x77,
  0x40, 0xAC, 0x09, 0x40, 0x8C, 0x0C, 0x77, 0x40, 0xCC, 0x07, 0x40, 0x4C, 0x0E, 0x77, 0x40, 0xEC,
  0x04, 0x40, 0x1D, 0x02, 0x77, 0x20, 0x1D, 0x01, 0x50, 0xDC, 0x05, 0x77, 0x20, 0x4C, 0x0D, 0x60,
  0x8C, 0x09, 0x77, 0x20, 0x8C, 0x08, 0x60, 0x3C, 0x0D, 0x77, 0x20, 0xCC, 0x03, 0x70, 0xDC, 0x03,
  0x77, 0x02, 0xC0, 0xD7, 0x10, 0x7C, 0x09, 0x77, 0x07, 0xC0, 0x77, 0x10, 0x10, 0xEB, 0x0E, 0x01,
  0x76, 0x0D, 0xC0, 0x17, 0x20, 0x8C, 0x08, 0x75, 0x06, 0xC0, 0x87, 0x30, 0x10, 0xEB, 0x0E, 0x01,
  0x73, 0x01, 0x0D, 0xB0, 0xE0, 0x17, 0x40, 0x6C, 0x0B, 0x73, 0x0A, 0xC0, 0x57, 0x60, 0xAC, 0x07,
  0x71, 0x06, 0xC0, 0xA7, 0x05, 0x80, 0x36, 0xD0, 0x56, 0x05, 0xC0, 0xE8, 0x03, 0x60, 0x50, 0xCF,
  0xD0, 0xE6, 0x0E, 0xFD, 0x00, 0xCF, 0xD0, 0xE6, 0x0E, 0xFD, 0x00, 0xCF, 0xD0, 0xE6, 0x0E, 0xFD,
  0x00, 0xCF, 0xD0, 0xE6, 0x0E, 0xFD, 0x0C,
  // "μ" (U+03BC)
  0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7,
  0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0,
  0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E,
  0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D,
  0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0,
  0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03,
  0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x03, 0xD0, 0x30, 0x7C,
  0x0E, 0x77, 0x10, 0x3D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x04, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10,
  0x5D, 0x03, 0x07, 0xC0, 0xE7, 0x71, 0x07, 0xD0, 0x30, 0x7C, 0x0E, 0x77, 0x10, 0xAD, 0x03, 0x07,
  0xD7, 0x71, 0x0E, 0xD0, 0x30, 0x7D, 0x02, 0x76, 0x03, 0xE0, 0x30, 0x7D, 0x06, 0x76, 0x0A, 0xE0,
  0x30, 0x7D, 0x0C, 0x75, 0x03, 0xF0, 0x30, 0x7E, 0x07, 0x73, 0x01, 0x0D, 0xF0, 0x30, 0x7F, 0x08,
  0x71, 0x06, 0x0E, 0xF9, 0x03, 0x07, 0xF9, 0x86, 0xEA, 0x76, 0x78, 0xAE, 0xC0, 0x70, 0xCC, 0x03,
  0x07, 0xFF, 0xD8, 0x1A, 0x09, 0xC0, 0x30, 0x7F, 0xFC, 0x0A, 0x20, 0x6C, 0x03, 0x07, 0xD0, 0xDF,
  0xB0, 0xD0, 0x53, 0x03, 0xC0, 0x30, 0x7C, 0x84, 0xE0, 0x59, 0xCE, 0xA8, 0x2D, 0xB8, 0x47, 0x40,
  0x7C, 0x0E, 0x77, 0x71, 0x07, 0xC0, 0xE7, 0x77, 0x10, 0x7C, 0x0E, 0x77, 0x71, 0x07, 0xC0, 0xE7,
  0x77, 0x10, 0x7C, 0x0E, 0x77, 0x71, 0x07, 0xC0, 0xE7, 0x77, 0x10, 0x7C, 0x0E, 0x77, 0x71, 0x07,
  0xC0, 0xE7, 0x77, 0x10, 0x7C, 0x0E, 0x77, 0x71, 0x07, 0xC0, 0xE7, 0x77, 0x10, 0x7C, 0x0E, 0x77,
  0x71, 0x07, 0xC0, 0xE7, 0x77, 0x10, 0x7C, 0x0E, 0x77, 0x71,
  // "π" (U+03C0)
  0x30, 0x70, 0xEF, 0xFF, 0xD8, 0x2B, 0x17, 0xEF, 0xFF, 0xF0, 0x0B, 0xFF, 0xFF, 0xA0, 0xB0, 0xCF,
  0xFF, 0xFA, 0x0B, 0x04, 0x80, 0x16, 0x08, 0xD8, 0x04, 0x60, 0xDC, 0x0A, 0x80, 0x16, 0x04, 0x60,
  0x3D, 0x71, 0x0C, 0xC0, 0x67, 0x50, 0x3D, 0x71, 0x0C, 0xC0, 0x67, 0x50, 0x3D, 0x71, 0x0C, 0xC0,
  0x67, 0x50, 0x3D, 0x71, 0x0C, 0xC0, 0x67, 0x50, 0x3D, 0x71, 0x0C, 0xC0, 0x67, 0x50, 0x3D, 0x71,
  0x0C, 0xC0, 0x67, 0x50, 0x3D, 0x71, 0x0C, 0xC0, 0x67, 0x50, 0x3D, 0x71, 0x0C, 0xC0, 0x67, 0x50,
  0x3D, 0x71, 0x0C, 0xC0, 0x67, 0x50, 0x3D, 0x71, 0x0C, 0xC0, 0x67, 0x50, 0x3D, 0x71, 0x0C, 0xC0,
  0x67, 0x50, 0x3D, 0x71, 0x0C, 0xC0, 0x67, 0x50, 0x3D, 0x71, 0x0C, 0xC0, 0x67, 0x50, 0x3D, 0x71,
  0x0C, 0xC0, 0x67, 0x50, 0x3D, 0x71, 0x0C, 0xC0, 0x67, 0x50, 0x3D, 0x71, 0x0C, 0xC0, 0x67, 0x50,
  0x3D, 0x71, 0x0C, 0xC0, 0x67, 0x50, 0x3D, 0x71, 0x0C, 0xC0, 0x67, 0x50, 0x3D, 0x71, 0x0C, 0xC0,
  0x67, 0x50, 0x3D, 0x71, 0x0C, 0xC0, 0x67, 0x50, 0x3D, 0x71, 0x0C, 0xC0, 0x77, 0x50, 0x3D, 0x71,
  0x0B, 0xC0, 0x97, 0x50, 0x3D, 0x71, 0x09, 0xC0, 0xE0, 0x17, 0x40, 0x3D, 0x71, 0x06, 0xD8, 0x3E,
  0x86, 0x8A, 0x70, 0x3D, 0x71, 0x01, 0xFA, 0x0C, 0x70, 0x3D, 0x72, 0x08, 0xF9, 0x0C, 0x70, 0x3D,
  0x73, 0x09, 0xF0, 0xC7, 0x01, 0x80, 0x16, 0x74, 0x81, 0x4A, 0xDA, 0x81, 0xDA, 0x41,
  // "–" (U+2013)
  0x80, 0xA4, 0x68, 0x09, 0xB4, 0xF0,
  // "—" (U+2014)
  0x80, 0xC0, 0x68, 0x0A, 0x94, 0xF0,
  // "€" (U+20AC)
  0x77, 0x48, 0x62, 0x56, 0x77, 0x65, 0x37, 0x77, 0x10, 0x60, 0xBF, 0xB8, 0x1D, 0x84, 0x77, 0x20,
  0x70, 0xEF, 0xF9, 0x0D, 0x06, 0x75, 0x02, 0x0C, 0xFF, 0xD0, 0x77, 0x30, 0x40, 0xEF, 0xA0, 0xEF,
  0xA0, 0xE7, 0x30, 0x30, 0xEE, 0x81, 0xB6, 0x24, 0x81, 0x26, 0xAC, 0x06, 0x72, 0x01, 0x0E, 0xD0,
  0xD0, 0x37, 0x38, 0x21, 0x7D, 0xD7, 0x30, 0xAD, 0x0B, 0x77, 0x10, 0x27, 0x20, 0x4D, 0x0C, 0x77,
  0x75, 0x0B, 0xC0, 0xE0, 0x17, 0x77, 0x40, 0x3D, 0x07, 0x77, 0x75, 0x09, 0xC0, 0xE7, 0x77, 0x60,
  0xDC, 0x09, 0x77, 0x75, 0x03, 0xD0, 0x37, 0x77, 0x50, 0x6C, 0x0E, 0x77, 0x76, 0x09, 0xC0, 0xB7,
  0x77, 0x10, 0x7F, 0xFF, 0xB0, 0x37, 0x07, 0xFF, 0xFB, 0x03, 0x70, 0x7F, 0xFF, 0xB0, 0x37, 0x07,
  0xFF, 0xFB, 0x03, 0x78, 0x33, 0x66, 0x67, 0xD0, 0x78, 0x09, 0x26, 0x01, 0x74, 0x03, 0xD0, 0x27,
  0x77, 0x50, 0x3D, 0x01, 0x77, 0x75, 0x03, 0xD0, 0x17, 0x77, 0x50, 0x2D, 0x02, 0x77, 0x71, 0x07,
  0xFF, 0xFB, 0x03, 0x70, 0x7F, 0xFF, 0xB0, 0x37, 0x07, 0xFF, 0xFB, 0x03, 0x70, 0x7F, 0xFF, 0xB0,
  0x37, 0x84, 0x36, 0x66, 0x6C, 0xC0, 0xD8, 0x09, 0x26, 0x01, 0x75, 0x06, 0xC0, 0xE7, 0x77, 0x60,
  0x3D, 0x03, 0x77, 0x76, 0x0D, 0xC0, 0x87, 0x77, 0x60, 0x9C, 0x0E, 0x77, 0x76, 0x02, 0xD0, 0x77,
  0x77, 0x60, 0xBD, 0x02, 0x77, 0x75, 0x03, 0xD0, 0xD0, 0x17, 0x77, 0x50, 0xAD, 0x0C, 0x01, 0x77,
  0x74, 0x01, 0x0D, 0xD0, 0xE0, 0x57, 0x58, 0x12, 0x74, 0x73, 0x03, 0x0E, 0xE8, 0x1D, 0x73, 0x58,
  0x22, 0x58, 0xDA, 0x05, 0x74, 0x03, 0x0E, 0xFB, 0x0E, 0xF9, 0x05, 0x75, 0x02, 0x0C, 0xFF, 0xC0,
  0x57, 0x70, 0x70, 0xEF, 0xFA, 0x04, 0x77, 0x20, 0x60, 0xBF, 0xB8, 0x1E, 0xA5, 0x77, 0x78, 0x72,
  0x56, 0x77, 0x66, 0x41, 0x60,
  // "₿" (U+20BF)
  0x60, 0xF7, 0x06, 0x48, 0x32, 0x77, 0x73, 0x77, 0x1B, 0x0C, 0x40, 0x5B, 0x07, 0x77, 0x1B, 0x0C,
  0x40, 0x5B, 0x07, 0x77, 0x1B, 0x0C, 0x40, 0x5B, 0x07, 0x77, 0x1B, 0x0C, 0x40, 0x5B, 0x07, 0x77,
  0x1B, 0x0C, 0x40, 0x5B, 0x07, 0x77, 0x1B, 0x0C, 0x40, 0x5B, 0x07, 0x72, 0x04, 0xFF, 0xB0, 0x90,
  0x17, 0x10, 0x4F, 0xFD, 0x0B, 0x04, 0x60, 0x4F, 0xFF, 0x0A, 0x01, 0x40, 0x4F, 0xFF, 0x90, 0xD0,
  0x23, 0x04, 0xC0, 0xD8, 0x03, 0x68, 0x27, 0x8A, 0xDF, 0x0C, 0x30, 0x4C, 0x0C, 0x74, 0x03, 0x0A,
  0xE0, 0x72, 0x04, 0xC0, 0xC7, 0x60, 0x7D, 0x0D, 0x20, 0x4C, 0x0C, 0x77, 0x0B, 0xD8, 0x12, 0x04,
  0xC0, 0xC7, 0x70, 0x5D, 0x81, 0x50, 0x4C, 0x0C, 0x77, 0x01, 0xD8, 0x16, 0x04, 0xC0, 0xC7, 0x71,
  0xD8, 0x17, 0x04, 0xC0, 0xC7, 0x71, 0xD8, 0x16, 0x04, 0xC0, 0xC7, 0x70, 0x1D, 0x81, 0x50, 0x4C,
  0x0C, 0x77, 0x04, 0xD8, 0x11, 0x04, 0xC0, 0xC7, 0x70, 0x9C, 0x0C, 0x20, 0x4C, 0x0C, 0x76, 0x03,
  0xD0, 0x62, 0x04, 0xC0, 0xC7, 0x50, 0x40, 0xEC, 0x0B, 0x30, 0x4C, 0x0C, 0x71, 0x82, 0x13, 0x6C,
  0xD0, 0xC0, 0x13, 0x04, 0xFF, 0xF0, 0x85, 0x04, 0xFF, 0xC8, 0x1B, 0x71, 0x60, 0x4F, 0xFB, 0x82,
  0xE9, 0x51, 0x60, 0x4F, 0xFE, 0x81, 0xE9, 0x24, 0x04, 0xC0, 0xD8, 0x03, 0x68, 0x27, 0x79, 0xCE,
  0x0E, 0x05, 0x30, 0x4C, 0x0C, 0x74, 0x81, 0x17, 0xED, 0x06, 0x20, 0x4C, 0x0C, 0x76, 0x02, 0x0D,
  0xD8, 0x13, 0x04, 0xC0, 0xC7, 0x70, 0x3D, 0x81, 0xB0, 0x4C, 0x0C, 0x77, 0x10, 0x9D, 0x02, 0x04,
  0xC0, 0xC7, 0x71, 0x03, 0xD0, 0x60, 0x4C, 0x0C, 0x77, 0x2D, 0x08, 0x04, 0xC0, 0xC7, 0x72, 0x0D,
  0xC0, 0xA0, 0x4C, 0x0C, 0x77, 0x20, 0xCC, 0x0A, 0x04, 0xC0, 0xC7, 0x72, 0x0D, 0xC0, 0x90, 0x4C,
  0x0C, 0x77, 0x2D, 0x08, 0x04, 0xC0, 0xC7, 0x71, 0x04, 0xD0, 0x50, 0x4C, 0x0C, 0x77, 0x10, 0xAD,
  0x02, 0x04, 0xC0, 0xC7, 0x70, 0x3D, 0x81, 0xC0, 0x4C, 0x0C, 0x76, 0x02, 0x0D, 0xD8, 0x16, 0x04,
  0xC0, 0xC7, 0x50, 0x70, 0xED, 0x0C, 0x20, 0x4C, 0x0D, 0x80, 0x46, 0x81, 0x78, 0xBF, 0x0E, 0x02,
  0x20, 0x4F, 0xFF, 0x90, 0xE0, 0x33, 0x04, 0xFF, 0xF0, 0xD0, 0x24, 0x04, 0xFF, 0xD0, 0xD0, 0x66,
  0x04, 0xFF, 0xB0, 0xA0, 0x37, 0x7B, 0x0C, 0x40, 0x5B, 0x07, 0x77, 0x1B, 0x0C, 0x40, 0x5B, 0x07,
  0x77, 0x1B, 0x0C, 0x40, 0x5B, 0x07, 0x77, 0x1B, 0x0C, 0x40, 0x5B, 0x07, 0x77, 0x1B, 0x0C, 0x40,
  0x5B, 0x07, 0x77, 0x1B, 0x0C, 0x40, 0x5B, 0x06, 0x72,
  // "‘" (U+2018)
  0x50, 0x9B, 0x05, 0x40, 0x10, 0xEB, 0x02, 0x40, 0x7B, 0x0E, 0x50, 0xDB, 0x0A, 0x40, 0x4C, 0x07,
  0x40, 0xAC, 0x03, 0x40, 0xEC, 0x40, 0x6C, 0x0D, 0x40, 0xBC, 0x09, 0x30, 0x1D, 0x06, 0x30, 0x6D,
  0x03, 0x30, 0xBD, 0x01, 0x3D, 0x0D, 0x30, 0x5D, 0x0B, 0x30, 0x6D, 0x08, 0x30,
  // "’" (U+2019)
  0x30, 0x8D, 0x0E, 0x30, 0xAD, 0x0E, 0x30, 0xDD, 0x09, 0x3E, 0x05, 0x20, 0x2E, 0x01, 0x20, 0x5D,
  0x0A, 0x30, 0x8D, 0x05, 0x30, 0xBC, 0x0E, 0x40, 0xEC, 0x09, 0x30, 0x2D, 0x03, 0x30, 0x6C, 0x0D,
  0x40, 0x9C, 0x07, 0x40, 0xDC, 0x01, 0x30, 0x1C, 0x09, 0x40, 0x4C, 0x03, 0x40,
  // "‚" (U+201A)
  0x30, 0x2E, 0x09, 0x30, 0x5E, 0x08, 0x30, 0x7E, 0x04, 0x30, 0xAD, 0x0E, 0x40, 0xDD, 0x0A, 0x4E,
  0x04, 0x30, 0x3D, 0x0E, 0x40, 0x6D, 0x09, 0x40, 0x9D, 0x03, 0x40, 0xDC, 0x0C, 0x40, 0x1D, 0x06,
  0x40, 0x4C, 0x0E, 0x01, 0x40, 0x7C, 0x09, 0x50, 0xBC, 0x02, 0x50, 0xEB, 0x0B, 0x50, 0x3C, 0x04,
  0x50,
  // "‛" (U+201B)
  0x06, 0xD0, 0x93, 0x05, 0xD0, 0xC4, 0xD0, 0xE4, 0x0B, 0xD0, 0x13, 0x06, 0xD0, 0x43, 0x01, 0xD0,
  0x74, 0x0B, 0xC0, 0xA4, 0x06, 0xC0, 0xD5, 0x0E, 0xC0, 0x14, 0x09, 0xC0, 0x44, 0x03, 0xC0, 0x85,
  0x0D, 0xB0, 0xB5, 0x06, 0xB0, 0xE6, 0x0E, 0xB0, 0x35, 0x08, 0xB0, 0x60,
  // "“" (U+201C)
  0x50, 0x9B, 0x05, 0x70, 0x9B, 0x05, 0x40, 0x10, 0xEB, 0x02, 0x60, 0x10, 0xEB, 0x02, 0x40, 0x7B,
  0x0E, 0x70, 0x7B, 0x0E, 0x50, 0xDB, 0x0A, 0x70, 0xDB, 0x0A, 0x40, 0x4C, 0x07, 0x60, 0x4C, 0x07,
  0x40, 0xAC, 0x03, 0x60, 0xAC, 0x03, 0x40, 0xEC, 0x70, 0xEC, 0x40, 0x6C, 0x0D, 0x60, 0x6C, 0x0D,
  0x40, 0xBC, 0x09, 0x60, 0xBC, 0x09, 0x30, 0x1D, 0x06, 0x50, 0x1D, 0x06, 0x30, 0x6D, 0x03, 0x50,
  0x6D, 0x03, 0x30, 0xBD, 0x01, 0x50, 0xBD, 0x01, 0x3D, 0x0D, 0x6D, 0x0D, 0x30, 0x5D, 0x0B, 0x50,
  0x5D, 0x0B, 0x30, 0x6D, 0x08, 0x50, 0x6D, 0x08, 0x30,
  // "”" (U+201D)
  0x30, 0x9D, 0x06, 0x50, 0x9D, 0x06, 0x30, 0xBD, 0x05, 0x50, 0xBD, 0x05, 0x30, 0xDD, 0x60, 0xDD,
  0x30, 0x1D, 0x0B, 0x50, 0x1D, 0x0B, 0x30, 0x3D, 0x06, 0x50, 0x3D, 0x06, 0x30, 0x6D, 0x01, 0x50,
  0x6D, 0x01, 0x30, 0x9C, 0x0B, 0x60, 0x9C, 0x0B, 0x40, 0xDC, 0x06, 0x60, 0xDC, 0x06, 0x4D, 0x01,
  0x6D, 0x01, 0x30, 0x3C, 0x09, 0x60, 0x3C, 0x09, 0x40, 0x7C, 0x04, 0x60, 0x7C, 0x04, 0x40, 0xAB,
  0x0D, 0x70, 0xAB, 0x0D, 0x50, 0xEB, 0x07, 0x70, 0xEB, 0x07, 0x40, 0x2B, 0x0E, 0x01, 0x60, 0x2B,
  0x0E, 0x01, 0x40, 0x5B, 0x09, 0x70, 0x5B, 0x09, 0x50,
  // "„" (U+201E)
  0x30, 0x2E, 0x09, 0x40, 0x2E, 0x09, 0x30, 0x5E, 0x08, 0x40, 0x5E, 0x08, 0x30, 0x7E, 0x04, 0x40,
  0x7E, 0x04, 0x30, 0xAD, 0x0E, 0x50, 0xAD, 0x0E, 0x40, 0xDD, 0x0A, 0x50, 0xDD, 0x0A, 0x4E, 0x04,
  0x5E, 0x04, 0x30, 0x3D, 0x0E, 0x50, 0x3D, 0x0E, 0x40, 0x6D, 0x09, 0x50, 0x6D, 0x09, 0x40, 0x9D,
  0x03, 0x50, 0x9D, 0x03, 0x40, 0xDC, 0x0C, 0x60, 0xDC, 0x0C, 0x40, 0x1D, 0x06, 0x50, 0x1D, 0x06,
  0x40, 0x4C, 0x0E, 0x01, 0x50, 0x4C, 0x0E, 0x01, 0x40, 0x7C, 0x09, 0x60, 0x7C, 0x09, 0x50, 0xBC,
  0x02, 0x60, 0xBC, 0x02, 0x50, 0xEB, 0x0B, 0x70, 0xEB, 0x0B, 0x50, 0x3C, 0x04, 0x60, 0x3C, 0x04,
  0x50,
  // "‟" (U+201F)
  0x06, 0xD0, 0x85, 0x06, 0xD0, 0x83, 0x05, 0xD0, 0xB5, 0x05, 0xD0, 0xB4, 0xD0, 0xD6, 0xD0, 0xD4,
  0x0B, 0xD0, 0x15, 0x0B, 0xD0, 0x13, 0x06, 0xD0, 0x35, 0x06, 0xD0, 0x33, 0x01, 0xD0, 0x65, 0x01,
  0xD0, 0x64, 0x0B, 0xC0, 0x96, 0x0B, 0xC0, 0x94, 0x06, 0xC0, 0xD6, 0x06, 0xC0, 0xD4, 0x01, 0xD6,
  0x01, 0xD5, 0x0A, 0xC0, 0x36, 0x0A, 0xC0, 0x34, 0x04, 0xC0, 0x76, 0x04, 0xC0, 0x75, 0x0D, 0xB0,
  0xA7, 0x0D, 0xB0, 0xA5, 0x07, 0xB0, 0xE7, 0x07, 0xB0, 0xE5, 0x01, 0xC0, 0x26, 0x01, 0xC0, 0x25,
  0x09, 0xB0, 0x57, 0x09, 0xB0, 0x50,
  // "†" (U+2020)
  0x71, 0x03, 0xD0, 0x97, 0x73, 0x01, 0xD0, 0x87, 0x74, 0xD0, 0x67, 0x74, 0x0D, 0xC0, 0x47, 0x74,
  0x0C, 0xC0, 0x27, 0x74, 0x0A, 0xC7, 0x75, 0x08, 0xB0, 0xE7, 0x75, 0x06, 0xB0, 0xC7, 0x75, 0x04,
  0xB0, 0xA7, 0x75, 0x03, 0xB0, 0x87, 0x75, 0x01, 0xB0, 0x67, 0x38, 0x33, 0x64, 0x31, 0x50, 0xEA,
  0x04, 0x58, 0x42, 0x35, 0x63, 0x8D, 0x83, 0xED, 0xBA, 0xEA, 0x82, 0xBB, 0xCD, 0xE0, 0x70, 0x8F,
  0xFF, 0x90, 0x70, 0x8F, 0xFF, 0x90, 0x70, 0x8F, 0x90, 0xEB, 0x0E, 0xFA, 0x87, 0x75, 0xA8, 0x75,
  0x43, 0x12, 0x0D, 0xA0, 0x32, 0x86, 0x23, 0x56, 0x79, 0xA5, 0x73, 0x0E, 0xA0, 0x47, 0x76, 0xB0,
  0x57, 0x76, 0xB0, 0x57, 0x75, 0x01, 0xB0, 0x67, 0x75, 0x02, 0xB0, 0x77, 0x75, 0x02, 0xB0, 0x87,
  0x75, 0x03, 0xB0, 0x97, 0x75, 0x04, 0xB0, 0x97, 0x75, 0x05, 0xB0, 0xA7, 0x75, 0x05, 0xB0, 0xB7,
  0x75, 0x06, 0xB0, 0xC7, 0x75, 0x07, 0xB0, 0xC7, 0x75, 0x07, 0xB0, 0xD7, 0x75, 0x08, 0xB0, 0xE7,
  0x75, 0x09, 0xC7, 0x75, 0x0A, 0xC7, 0x75, 0x0A, 0xC0, 0x17, 0x74, 0x0B, 0xC0, 0x27, 0x74, 0x0C,
  0xC0, 0x27, 0x74, 0x0D, 0xC0, 0x37, 0x74, 0x0D, 0xC0, 0x47, 0x74, 0x0E, 0xC0, 0x57, 0x74, 0xD0,
  0x57, 0x74, 0xD0, 0x67, 0x73, 0x01, 0xD0, 0x77, 0x73, 0x02, 0xD0, 0x87, 0x73, 0x02, 0xD0, 0x87,
  0x73, 0x03, 0xD0, 0x97, 0x73, 0x04, 0xD0, 0xA7, 0x20,
  // "‡" (U+2021)
  0x71, 0x01, 0xD0, 0xD7, 0x74, 0x0E, 0xC0, 0xB7, 0x74, 0x0C, 0xC0, 0x97, 0x74, 0x0A, 0xC0, 0x77,
  0x74, 0x08, 0xC0, 0x57, 0x74, 0x06, 0xC0, 0x37, 0x74, 0x04, 0xC0, 0x17, 0x74, 0x02, 0xC7, 0x76,
  0xB0, 0xD7, 0x76, 0x0E, 0xA0, 0xB7, 0x38, 0x46, 0x75, 0x43, 0x14, 0x0C, 0xA0, 0x94, 0x85, 0x13,
  0x46, 0x76, 0xBE, 0x82, 0xED, 0xBE, 0xA8, 0x2D, 0xBD, 0xEE, 0x00, 0xBF, 0xFF, 0x90, 0x0B, 0xFF,
  0xF9, 0x00, 0xBE, 0x82, 0xDC, 0xBE, 0xA8, 0x2D, 0xBC, 0xEE, 0x85, 0xB6, 0x75, 0x42, 0x14, 0x0C,
  0xA0, 0x94, 0x84, 0x12, 0x45, 0x76, 0x73, 0xB0, 0xC7, 0x75, 0x01, 0xB0, 0xE7, 0x75, 0x04, 0xC0,
  0x17, 0x74, 0x06, 0xC0, 0x37, 0x74, 0x09, 0xC0, 0x67, 0x74, 0x0B, 0xC0, 0x87, 0x74, 0x0D, 0xC0,
  0xB7, 0x74, 0x0D, 0xC0, 0xA7, 0x74, 0x0A, 0xC0, 0x77, 0x74, 0x08, 0xC0, 0x57, 0x74, 0x06, 0xC0,
  0x37, 0x74, 0x04, 0xC0, 0x17, 0x74, 0x01, 0xB0, 0xE7, 0x76, 0x0E, 0xA0, 0xC7, 0x38, 0x35, 0x54,
  0x21, 0x50, 0xCA, 0x09, 0x58, 0x41, 0x24, 0x55, 0xBD, 0x83, 0xDC, 0xB9, 0xDA, 0x83, 0xC9, 0xBC,
  0xED, 0x00, 0xBF, 0xFF, 0x90, 0x0B, 0xFF, 0xF9, 0x00, 0xBF, 0x90, 0xD0, 0xEA, 0x00, 0xEF, 0x98,
  0x7B, 0x78, 0x76, 0x43, 0x21, 0x20, 0xCA, 0x09, 0x28, 0x61, 0x23, 0x56, 0x78, 0x77, 0x30, 0xEA,
  0x0B, 0x77, 0x6B, 0x0D, 0x77, 0x50, 0x2C, 0x77, 0x50, 0x4C, 0x01, 0x77, 0x40, 0x6C, 0x03, 0x77,
  0x40, 0x8C, 0x05, 0x77, 0x40, 0xAC, 0x07, 0x77, 0x40, 0xCC, 0x09, 0x77, 0x40, 0xEC, 0x0B, 0x77,
  0x4D, 0x0D, 0x72,
  // "•" (U+2022)
  0x38, 0x62, 0x8D, 0xEE, 0xD8, 0x25, 0x07, 0xF9, 0x07, 0x30, 0x6F, 0xB0, 0x62, 0x0E, 0xFB, 0x81,
  0xE0, 0x4F, 0xD0, 0x40, 0x7F, 0xD0, 0x70, 0x9F, 0xD0, 0x09, 0xFD, 0x00, 0x9F, 0xD0, 0x90, 0x7F,
  0xD0, 0x70, 0x4F, 0xD8, 0x14, 0x0D, 0xFB, 0x0D, 0x20, 0x5F, 0xB0, 0x53, 0x06, 0xF9, 0x06, 0x58,
  0x62, 0x8D, 0xEE, 0xD8, 0x23,
  // "…" (U+2026)
  0x28, 0x23, 0x66, 0x37, 0x18, 0x23, 0x66, 0x37, 0x18, 0x23, 0x66, 0x33, 0x0A, 0xC0, 0xA6, 0x0A,
  0xC0, 0xA6, 0x0A, 0xC8, 0x1A, 0x05, 0xE0, 0x54, 0x05, 0xE0, 0x54, 0x05, 0xE0, 0x50, 0x9E, 0x09,
  0x40, 0x9E, 0x09, 0x40, 0x9E, 0x09, 0x0A, 0xE0, 0xA4, 0x0A, 0xE0, 0xA4, 0x0A, 0xE0, 0xA0, 0x9E,
  0x09, 0x40, 0x9E, 0x09, 0x40, 0x9E, 0x09, 0x05, 0xE0, 0x54, 0x05, 0xE0, 0x54, 0x05, 0xE8, 0x15,
  0x09, 0xC0, 0x96, 0x09, 0xC0, 0x96, 0x09, 0xC0, 0x93, 0x82, 0x36, 0x63, 0x71, 0x82, 0x36, 0x63,
  0x71, 0x82, 0x36, 0x63, 0x20,
  // "‰" (U+2030)
  0x58, 0x31, 0x57, 0x63, 0x77, 0x77, 0x10, 0x10, 0xAD, 0x0C, 0x03, 0x77, 0x75, 0x01, 0x0D, 0xF9,
  0x04, 0x77, 0x74, 0x0A, 0xFA, 0x0E, 0x01, 0x77, 0x72, 0x03, 0xC8, 0x1D, 0x8B, 0xC0, 0x87, 0x77,
  0x20, 0x9B, 0x0E, 0x01, 0x20, 0xBB, 0x0E, 0x77, 0x72, 0x0C, 0xB0, 0xA3, 0x05, 0xC0, 0x27, 0x77,
  0x1C, 0x07, 0x30, 0x2C, 0x05, 0x77, 0x71, 0xC0, 0x53, 0x01, 0xC0, 0x67, 0x77, 0x01, 0xC0, 0x54,
  0xC0, 0x67, 0x77, 0x1C, 0x05, 0x30, 0x1C, 0x05, 0x74, 0x80, 0x32, 0x40, 0xEB, 0x06, 0x30, 0x2C,
  0x04, 0x72, 0x04, 0x0D, 0xD0, 0xD0, 0x34, 0x0B, 0xB0, 0x93, 0x04, 0xC0, 0x17, 0x01, 0x0A, 0xD0,
  0xE0, 0x76, 0x06, 0xB0, 0xD3, 0x08, 0xB0, 0xB7, 0x06, 0x0E, 0xD0, 0xB0, 0x27, 0x10, 0xEB, 0x82,
  0x80, 0x4E, 0xB0, 0x55, 0x03, 0x0C, 0xD0, 0xD0, 0x57, 0x30, 0x4F, 0xA0, 0xB5, 0x09, 0xE0, 0x87,
  0x60, 0x6F, 0x0B, 0x40, 0x50, 0xED, 0x0C, 0x02, 0x77, 0x18, 0x52, 0x9D, 0xFE, 0xB5, 0x30, 0x20,
  0xBD, 0x0E, 0x06, 0x77, 0x75, 0x08, 0xE0, 0x90, 0x17, 0x77, 0x40, 0x40, 0xDD, 0x0C, 0x03, 0x77,
  0x74, 0x01, 0x0A, 0xD0, 0xE0, 0x77, 0x77, 0x50, 0x70, 0xED, 0x0A, 0x01, 0x77, 0x74, 0x03, 0x0C,
  0xD0, 0xD0, 0x47, 0x77, 0x40, 0x10, 0x9E, 0x08, 0x77, 0x75, 0x05, 0x0E, 0xD0, 0xB0, 0x27, 0x77,
  0x40, 0x20, 0xB8, 0x01, 0xE0, 0xD0, 0x68, 0x0C, 0x00, 0x85, 0x18, 0xDE, 0xEB, 0x57, 0x18, 0x55,
  0xBE, 0xFD, 0x91, 0x76, 0x04, 0x0E, 0xE0, 0xA6, 0x0A, 0xE0, 0xE0, 0x47, 0x40, 0x3F, 0xA0, 0xA4,
  0x09, 0xFA, 0x03, 0x73, 0x0C, 0xFB, 0x05, 0x20, 0x4F, 0xB0, 0xC7, 0x20, 0x3C, 0x82, 0x91, 0x3E,
  0xB0, 0xC2, 0x0A, 0xB8, 0x2E, 0x40, 0x8C, 0x04, 0x71, 0x08, 0xB0, 0xE3, 0x07, 0xC0, 0x11, 0xC0,
  0x83, 0x0E, 0xB0, 0x97, 0x10, 0xBB, 0x0B, 0x30, 0x2C, 0x05, 0x03, 0xC0, 0x33, 0x0A, 0xB0, 0xD7,
  0x10, 0xDB, 0x08, 0x4C, 0x07, 0x05, 0xC0, 0x13, 0x07, 0xC7, 0x10, 0xEB, 0x07, 0x40, 0xEB, 0x08,
  0x06, 0xC4, 0x06, 0xC7, 0x1C, 0x07, 0x40, 0xEB, 0x08, 0x06, 0xC4, 0x06, 0xC0, 0x17, 0x0E, 0xB0,
  0x74, 0x0E, 0xB0, 0x70, 0x5C, 0x40, 0x6C, 0x71, 0x0C, 0xB0, 0x84, 0xC0, 0x60, 0x4C, 0x40, 0x7B,
  0x0E, 0x71, 0x09, 0xB0, 0xA3, 0x01, 0xC0, 0x30, 0x1C, 0x02, 0x30, 0x9B, 0x0B, 0x71, 0x05, 0xB0,
  0xD3, 0x05, 0xB0, 0xE2, 0x0D, 0xB0, 0x63, 0x0C, 0xB0, 0x77, 0x20, 0xEB, 0x04, 0x20, 0xBB, 0x09,
  0x20, 0x7B, 0x0C, 0x20, 0x3C, 0x02, 0x72, 0x06, 0xB8, 0x1E, 0x8B, 0xB0, 0xE0, 0x13, 0x0D, 0xB8,
  0x1B, 0x8E, 0xB0, 0x97, 0x40, 0x9F, 0x90, 0x54, 0x03, 0x0E, 0xF0, 0xC7, 0x60, 0x7D, 0x0D, 0x04,
  0x60, 0x20, 0xCD, 0x09, 0x01, 0x77, 0x83, 0x15, 0x76, 0x37, 0x38, 0x33, 0x67, 0x51, 0x50,
  // "‹" (U+2039)
  0x73, 0x01, 0x75, 0x81, 0x8E, 0x77, 0x30, 0x5B, 0x0D, 0x05, 0x70, 0x3D, 0x06, 0x60, 0x10, 0xEC,
  0x09, 0x70, 0xCC, 0x0B, 0x70, 0xAC, 0x0D, 0x01, 0x60, 0x8C, 0x0E, 0x02, 0x60, 0x5D, 0x04, 0x60,
  0x3D, 0x07, 0x60, 0x10, 0xEC, 0x0A, 0x70, 0xCC, 0x0C, 0x70, 0xAC, 0x0E, 0x01, 0x70, 0xDC, 0x0C,
  0x71, 0x03, 0xD0, 0x97, 0x10, 0x5D, 0x06, 0x71, 0x07, 0xD0, 0x37, 0x10, 0xAC, 0x0E, 0x02, 0x71,
  0x0C, 0xC0, 0xC7, 0x10, 0x10, 0xDC, 0x0A, 0x71, 0x03, 0x0E, 0xC0, 0x77, 0x10, 0x5D, 0x05, 0x71,
  0x07, 0xC0, 0xE0, 0x27, 0x10, 0xAC, 0x08, 0x72, 0x82, 0xCF, 0xC3, 0x73, 0x01, 0x06, 0x30,
  // "›" (U+203A)
  0x30, 0x60, 0x17, 0x38, 0x23, 0xCF, 0xC7, 0x20, 0x8C, 0x0A, 0x71, 0x03, 0x0E, 0xC0, 0x77, 0x10,
  0x5D, 0x05, 0x71, 0x08, 0xC0, 0xE0, 0x37, 0x10, 0xAC, 0x0D, 0x01, 0x71, 0x0C, 0xC0, 0xC7, 0x10,
  0x20, 0xEC, 0x0A, 0x71, 0x03, 0xD0, 0x77, 0x10, 0x6D, 0x05, 0x71, 0x09, 0xD0, 0x37, 0x10, 0xCC,
  0x0D, 0x70, 0x10, 0xEC, 0x0A, 0x70, 0xCC, 0x0C, 0x70, 0xAC, 0x0E, 0x01, 0x60, 0x7D, 0x03, 0x60,
  0x4D, 0x05, 0x60, 0x20, 0xEC, 0x08, 0x60, 0x10, 0xDC, 0x0A, 0x70, 0xBC, 0x0C, 0x70, 0x9C, 0x0E,
  0x01, 0x60, 0x6D, 0x03, 0x70, 0x50, 0xDB, 0x05, 0x73, 0x81, 0x7E, 0x77, 0x50, 0x17, 0x30,
  // "⁄" (U+2044)
  0x77, 0x40, 0x5C, 0x03, 0x77, 0x40, 0xCB, 0x0B, 0x77, 0x40, 0x3C, 0x05, 0x77, 0x40, 0x9B, 0x0E,
  0x77, 0x40, 0x1C, 0x07, 0x77, 0x40, 0x7C, 0x01, 0x77, 0x40, 0xDB, 0x0A, 0x77, 0x40, 0x5C, 0x03,
  0x77, 0x40, 0xBB, 0x0C, 0x77, 0x40, 0x2C, 0x06, 0x77, 0x40, 0x9B, 0x0E, 0x77, 0x40, 0x10, 0xEB,
  0x08, 0x77, 0x40, 0x7C, 0x01, 0x77, 0x40, 0xDB, 0x0A, 0x77, 0x40, 0x4C, 0x04, 0x77, 0x40, 0xBB,
  0x0D, 0x77, 0x40, 0x2C, 0x06, 0x77, 0x40, 0x9B, 0x0E, 0x77, 0x50, 0xEB, 0x09, 0x77, 0x40, 0x6C,
  0x02, 0x77, 0x40, 0xDB, 0x0B, 0x77, 0x40, 0x4C, 0x04, 0x77, 0x40, 0xBB, 0x0D, 0x77, 0x40, 0x2C,
  0x07, 0x77, 0x40, 0x8C, 0x01, 0x77, 0x40, 0xEB, 0x09, 0x77, 0x40, 0x6C, 0x03, 0x77, 0x40, 0xCB,
  0x0C, 0x77, 0x40, 0x3C, 0x05, 0x77, 0x40, 0xAB, 0x0E, 0x77, 0x40, 0x1C, 0x07, 0x77, 0x40, 0x8C,
  0x01, 0x77, 0x40, 0xEB, 0x0A, 0x77, 0x40, 0x5C, 0x03, 0x77, 0x40, 0xCB, 0x0C, 0x77, 0x40, 0x3C,
  0x06, 0x77, 0x40, 0xAB, 0x0E, 0x77, 0x40, 0x1C, 0x08, 0x77, 0x40, 0x7C, 0x02, 0x77, 0x40, 0xDB,
  0x0A, 0x77, 0x40, 0x5C, 0x04, 0x77, 0x40, 0xBB, 0x0D, 0x77, 0x40, 0x3C, 0x06, 0x77, 0x40,
  // "™" (U+2122)
  0x02, 0x80, 0x92, 0x32, 0x02, 0x80, 0x13, 0x71, 0x80, 0x13, 0x01, 0x09, 0xFF, 0x81, 0x20, 0x8D,
  0x03, 0x60, 0x3D, 0x06, 0x09, 0xFF, 0x81, 0x20, 0x8D, 0x07, 0x60, 0x7D, 0x06, 0x09, 0xFF, 0x81,
  0x20, 0x8D, 0x0B, 0x60, 0xBD, 0x06, 0x60, 0xEA, 0x0D, 0x70, 0x8D, 0x0E, 0x60, 0xED, 0x06, 0x60,
  0xEA, 0x0D, 0x70, 0x8A, 0x00, 0xEA, 0x03, 0x40, 0x3A, 0x0E, 0xB0, 0x66, 0x0E, 0xA0, 0xD7, 0x08,
  0xA0, 0xE0, 0xBA, 0x06, 0x40, 0x7A, 0x09, 0xB0, 0x66, 0x0E, 0xA0, 0xD7, 0x08, 0xA0, 0xE0, 0x7A,
  0x0A, 0x40, 0xBA, 0x06, 0xB0, 0x66, 0x0E, 0xA0, 0xD7, 0x08, 0xB0, 0x3A, 0x0D, 0x48, 0x2E, 0xFB,
  0x6B, 0x06, 0x60, 0xEA, 0x0D, 0x70, 0x8B, 0x01, 0x0E, 0xA0, 0x22, 0x03, 0xA0, 0x70, 0x6B, 0x06,
  0x60, 0xEA, 0x0D, 0x70, 0x8B, 0x10, 0xBA, 0x05, 0x20, 0x7A, 0x03, 0x06, 0xB0, 0x66, 0x0E, 0xA0,
  0xD7, 0x08, 0xB1, 0x07, 0xA0, 0x92, 0x83, 0xAF, 0xE0, 0x6B, 0x06, 0x60, 0xEA, 0x0D, 0x70, 0x8B,
  0x10, 0x3A, 0x0D, 0x28, 0x3E, 0xFB, 0x06, 0xB0, 0x66, 0x0E, 0xA0, 0xD7, 0x08, 0xB2, 0xB0, 0x10,
  0x3A, 0x81, 0x70, 0x6B, 0x06, 0x60, 0xEA, 0x0D, 0x70, 0x8B, 0x20, 0xBA, 0x04, 0x06, 0xA8, 0x13,
  0x06, 0xB0, 0x66, 0x0E, 0xA0, 0xD7, 0x08, 0xB2, 0x08, 0xA8, 0x28, 0xAF, 0xE2, 0x06, 0xB0, 0x66,
  0x0E, 0xA0, 0xD7, 0x08, 0xB2, 0x04, 0xA8, 0x2C, 0xEF, 0xA2, 0x06, 0xB0, 0x66, 0x0E, 0xA0, 0xD7,
  0x08, 0xB3, 0xD0, 0x62, 0x06, 0xB0, 0x66, 0x0E, 0xA0, 0xD7, 0x08, 0xB3, 0x0C, 0xC0, 0x22, 0x06,
  0xB0, 0x66, 0x0E, 0xA0, 0xD7, 0x08, 0xB3, 0x08, 0xB0, 0xD3, 0x06, 0xB0, 0x66, 0x0E, 0xA0, 0xD7,
  0x08, 0xB3, 0x04, 0xB0, 0x93, 0x06, 0xB0, 0x66, 0x0D, 0xA0, 0xD7, 0x08, 0xB3, 0x01, 0xB0, 0x53,
  0x06, 0xB0, 0x60,
  // "⅒" (U+2152)
  0x78, 0x34, 0x77, 0x76, 0x77, 0x73, 0x05, 0xC0, 0x38, 0x0C, 0x60, 0x02, 0x0A, 0xC0, 0xD7, 0x77,
  0x30, 0xCB, 0x0B, 0x80, 0xC6, 0x00, 0x8E, 0x0D, 0x77, 0x72, 0x03, 0xC0, 0x58, 0x0C, 0x40, 0x05,
  0x0E, 0xF0, 0xD7, 0x77, 0x20, 0x9B, 0x0E, 0x80, 0xC3, 0x00, 0x30, 0xCD, 0x0E, 0xB0, 0xD7, 0x77,
  0x10, 0x1C, 0x07, 0x80, 0xC3, 0x00, 0xDD, 0x81, 0xC2, 0xEA, 0x0D, 0x77, 0x71, 0x07, 0xC0, 0x18,
  0x0C, 0x30, 0x04, 0xB0, 0xE0, 0x72, 0xB0, 0xD7, 0x77, 0x10, 0xDB, 0x0A, 0x80, 0xC5, 0x08, 0x2A,
  0xF8, 0x13, 0xB0, 0xD7, 0x77, 0x05, 0xC0, 0x38, 0x0C, 0x50, 0x00, 0x15, 0xB0, 0xD7, 0x77, 0x0B,
  0xB0, 0xC8, 0x0D, 0x50, 0xB0, 0xD7, 0x76, 0x02, 0xC0, 0x68, 0x0D, 0x50, 0xB0, 0xD7, 0x76, 0x09,
  0xB0, 0xE8, 0x0D, 0x60, 0xB0, 0xD7, 0x75, 0x01, 0x0E, 0xB0, 0x88, 0x0D, 0x60, 0xB0, 0xD7, 0x75,
  0x07, 0xC0, 0x18, 0x0D, 0x60, 0xB0, 0xD7, 0x75, 0x0D, 0xB0, 0xA8, 0x0D, 0x70, 0xB0, 0xD7, 0x74,
  0x04, 0xC0, 0x48, 0x0D, 0x70, 0xB0, 0xD7, 0x74, 0x0B, 0xB0, 0xD8, 0x0E, 0x00, 0xB0, 0xD7, 0x73,
  0x02, 0xC0, 0x68, 0x0E, 0x00, 0xB0, 0xD7, 0x73, 0x09, 0xB0, 0xE7, 0x48, 0x34, 0x77, 0x76, 0x77,
  0x28, 0x44, 0x67, 0x76, 0x37, 0x71, 0xB0, 0xD7, 0x73, 0x0E, 0xB0, 0x97, 0x20, 0x20, 0xAC, 0x0D,
  0x76, 0x81, 0x19, 0xEE, 0x0E, 0x08, 0x76, 0xB0, 0xD7, 0x72, 0x06, 0xC0, 0x27, 0x10, 0x8E, 0x0D,
  0x75, 0x04, 0x0E, 0xFB, 0x0D, 0x03, 0x74, 0xB0, 0xD7, 0x72, 0x0D, 0xB0, 0xB7, 0x05, 0x0E, 0xF0,
  0xD7, 0x40, 0x20, 0xEF, 0xD0, 0xE0, 0x27, 0x3B, 0x0D, 0x77, 0x10, 0x4C, 0x04, 0x50, 0x30, 0xCD,
  0x0E, 0xB0, 0xD7, 0x40, 0xCC, 0x84, 0x93, 0x01, 0x39, 0xC0, 0xC3, 0x01, 0x80, 0x28, 0xB0, 0xE8,
  0x02, 0x80, 0x27, 0x10, 0xBB, 0x0D, 0x60, 0xDD, 0x81, 0xC2, 0xEA, 0x0D, 0x73, 0x05, 0xC0, 0x56,
  0x05, 0xC0, 0x52, 0x03, 0xFF, 0xA0, 0x47, 0x02, 0xC0, 0x76, 0x04, 0xB0, 0xE0, 0x72, 0xB0, 0xD7,
  0x30, 0xCB, 0x09, 0x71, 0x09, 0xB0, 0xB2, 0x03, 0xFF, 0xA0, 0x47, 0x08, 0xC0, 0x17, 0x82, 0xAF,
  0x81, 0x3B, 0x0D, 0x72, 0x01, 0xC0, 0x17, 0x10, 0x1C, 0x81, 0x10, 0x3F, 0xFA, 0x04, 0x70, 0xEB,
  0x09, 0x71, 0x00, 0x15, 0xB0, 0xD7, 0x20, 0x5B, 0x0C, 0x73, 0x0B, 0xB0, 0x47, 0x77, 0x40, 0x6C,
  0x03, 0x77, 0x1B, 0x0D, 0x72, 0x08, 0xB0, 0x87, 0x30, 0x7B, 0x07, 0x77, 0x74, 0x0C, 0xB0, 0xC7,
  0x72, 0xB0, 0xD7, 0x20, 0xBB, 0x06, 0x73, 0x05, 0xB0, 0xA7, 0x77, 0x30, 0x3C, 0x05, 0x77, 0x2B,
  0x0D, 0x72, 0x0C, 0xB0, 0x57, 0x30, 0x3B, 0x0B, 0x77, 0x73, 0x0A, 0xB0, 0xE7, 0x73, 0xB0, 0xD7,
  0x20, 0xDB, 0x04, 0x73, 0x02, 0xB0, 0xC7, 0x77, 0x20, 0x1C, 0x07, 0x77, 0x3B, 0x0D, 0x72, 0x0D,
  0xB0, 0x37, 0x30, 0x2B, 0x0C, 0x77, 0x72, 0x08, 0xC0, 0x17, 0x73, 0xB0, 0xD7, 0x20, 0xDB, 0x04,
  0x73, 0x02, 0xB0, 0xC7, 0x77, 0x20, 0xEB, 0x0A, 0x77, 0x4B, 0x0D, 0x72, 0x0C, 0xB0, 0x47, 0x30,
  0x3B, 0x0B, 0x77, 0x71, 0x05, 0xC0, 0x37, 0x74, 0xB0, 0xD7, 0x20, 0xBB, 0x05, 0x73, 0x04, 0xB0,
  0xA7, 0x77, 0x10, 0xCB, 0x0C, 0x77, 0x5B, 0x0D, 0x72, 0x09, 0xB0, 0x77, 0x30, 0x6B, 0x08, 0x77,
  0x70, 0x3C, 0x06, 0x77, 0x5B, 0x0D, 0x72, 0x06, 0xB0, 0xA7, 0x30, 0x9B, 0x06, 0x77, 0x70, 0xAB,
  0x0E, 0x77, 0x6B, 0x0D, 0x72, 0x03, 0xB0, 0xE7, 0x30, 0xDB, 0x02, 0x77, 0x60, 0x1C, 0x08, 0x77,
  0x6B, 0x0D, 0x73, 0x0D, 0xB0, 0x57, 0x10, 0x4B, 0x0D, 0x77, 0x70, 0x7C, 0x02, 0x77, 0x6B, 0x0D,
  0x73, 0x08, 0xB0, 0xD0, 0x17, 0x0D, 0xB0, 0x87, 0x77, 0x0D, 0xB0, 0xA7, 0x70, 0x18, 0x02, 0x8B,
  0x0E, 0x80, 0x28, 0x02, 0x30, 0x10, 0xEB, 0x0C, 0x02, 0x40, 0x20, 0xCB, 0x0E, 0x01, 0x77, 0x60,
  0x5C, 0x04, 0x77, 0x03, 0xFF, 0xA0, 0x44, 0x06, 0xD8, 0x2B, 0x99, 0xBD, 0x07, 0x77, 0x70, 0xBB,
  0x0D, 0x77, 0x10, 0x3F, 0xFA, 0x04, 0x50, 0x7F, 0xD0, 0x97, 0x77, 0x03, 0xC0, 0x67, 0x71, 0x03,
  0xFF, 0xA0, 0x46, 0x05, 0x0E, 0xF9, 0x0E, 0x07, 0x80, 0x98, 0x00, 0x89, 0x01, 0x6A, 0xDE, 0xED,
  0xB6, 0x15,
  // "∂" (U+2202)
  0x74, 0x89, 0x12, 0x69, 0xCD, 0xEF, 0xEC, 0x96, 0x77, 0x30, 0x70, 0xDF, 0xC0, 0xE0, 0x87, 0x70,
  0x3F, 0xF9, 0x0C, 0x01, 0x75, 0x03, 0xFF, 0xA0, 0xD0, 0x17, 0x40, 0x3C, 0x84, 0xD9, 0x76, 0x8B,
  0xF0, 0xB7, 0x48, 0x33, 0xFE, 0x82, 0x60, 0x10, 0xAE, 0x05, 0x73, 0x02, 0x08, 0x74, 0x07, 0xD0,
  0xD7, 0x77, 0x30, 0xAD, 0x04, 0x77, 0x72, 0x02, 0xD0, 0x97, 0x77, 0x30, 0x9C, 0x0D, 0x77, 0x73,
  0x04, 0xD0, 0x17, 0x77, 0x3D, 0x04, 0x77, 0x73, 0x0D, 0xC0, 0x67, 0x77, 0x30, 0xBC, 0x08, 0x73,
  0x82, 0x16, 0xAD, 0xB8, 0x2E, 0xC7, 0x13, 0x0A, 0xC0, 0x97, 0x20, 0x80, 0xEF, 0xA0, 0xE0, 0x62,
  0x09, 0xC0, 0xA7, 0x02, 0x0D, 0xFE, 0x81, 0x90, 0x9C, 0x0A, 0x60, 0x40, 0xEF, 0xF9, 0x08, 0x0A,
  0xC0, 0x95, 0x03, 0xF8, 0x59, 0x41, 0x01, 0x49, 0xC0, 0xEC, 0x09, 0x40, 0x10, 0xED, 0x0D, 0x02,
  0x70, 0x40, 0xEF, 0x08, 0x40, 0xAD, 0x0D, 0x01, 0x72, 0x04, 0xF0, 0x63, 0x03, 0xD0, 0xE0, 0x17,
  0x40, 0x9E, 0x04, 0x30, 0xBD, 0x05, 0x75, 0x01, 0xE0, 0x22, 0x04, 0xD0, 0xB7, 0x70, 0xBD, 0x30,
  0x9D, 0x03, 0x77, 0x0B, 0xC0, 0xD3, 0x0E, 0xC0, 0xC7, 0x71, 0x0E, 0xC0, 0x92, 0x04, 0xD0, 0x67,
  0x70, 0x2D, 0x06, 0x20, 0x7D, 0x01, 0x77, 0x06, 0xD0, 0x22, 0x0A, 0xC0, 0xD7, 0x71, 0x0B, 0xC0,
  0xD3, 0x0D, 0xC0, 0xA7, 0x70, 0x1D, 0x08, 0x3D, 0x07, 0x77, 0x06, 0xD0, 0x33, 0xD0, 0x67, 0x70,
  0xDC, 0x0C, 0x30, 0x1D, 0x05, 0x76, 0x05, 0xD0, 0x54, 0xD0, 0x67, 0x60, 0xDC, 0x0D, 0x50, 0xEC,
  0x07, 0x75, 0x07, 0xD0, 0x65, 0x0D, 0xC0, 0xB7, 0x40, 0x3D, 0x0C, 0x60, 0x9D, 0x01, 0x72, 0x02,
  0x0E, 0xD0, 0x36, 0x05, 0xD0, 0x97, 0x10, 0x30, 0xED, 0x08, 0x71, 0x0E, 0xD0, 0x76, 0x07, 0xE0,
  0xB7, 0x20, 0x7E, 0x84, 0xD8, 0x67, 0xAE, 0xE0, 0xC0, 0x17, 0x30, 0xCF, 0xFA, 0x0B, 0x75, 0x01,
  0x0C, 0xFF, 0x07, 0x77, 0x10, 0x9F, 0xC0, 0xA0, 0x27, 0x73, 0x89, 0x11, 0x7B, 0xDE, 0xFE, 0xDA,
  0x61, 0x76,
  // "∆" (U+2206)
  0x77, 0x0E, 0xC0, 0xC7, 0x77, 0x60, 0x4E, 0x02, 0x77, 0x75, 0x0A, 0xE0, 0x87, 0x77, 0x50, 0xEE,
  0x0D, 0x77, 0x74, 0x05, 0xF9, 0x03, 0x77, 0x73, 0x0A, 0xF9, 0x09, 0x77, 0x72, 0x01, 0xC0, 0xCC,
  0x0E, 0x77, 0x72, 0x06, 0xC0, 0x80, 0xBC, 0x04, 0x77, 0x71, 0x0B, 0xC0, 0x30, 0x6C, 0x0A, 0x77,
  0x70, 0x1C, 0x81, 0xE0, 0x1C, 0x0E, 0x77, 0x70, 0x7C, 0x0A, 0x20, 0xCC, 0x05, 0x77, 0x60, 0xCC,
  0x05, 0x20, 0x6C, 0x0B, 0x77, 0x50, 0x2C, 0x0E, 0x30, 0x1D, 0x01, 0x77, 0x40, 0x7C, 0x0A, 0x40,
  0xBC, 0x06, 0x77, 0x40, 0xDC, 0x05, 0x40, 0x6C, 0x0B, 0x77, 0x30, 0x3C, 0x0E, 0x50, 0x1D, 0x01,
  0x77, 0x20, 0x8C, 0x0A, 0x60, 0xAC, 0x07, 0x77, 0x20, 0xDC, 0x04, 0x60, 0x5C, 0x0C, 0x77, 0x10,
  0x4C, 0x0E, 0x71, 0x0E, 0xC0, 0x27, 0x70, 0x9C, 0x09, 0x71, 0x0A, 0xC0, 0x87, 0x70, 0xEC, 0x04,
  0x71, 0x05, 0xC0, 0xD7, 0x60, 0x4C, 0x0E, 0x73, 0x0E, 0xC0, 0x37, 0x50, 0xAC, 0x08, 0x73, 0x09,
  0xC0, 0x97, 0x5D, 0x03, 0x73, 0x04, 0xC0, 0xE7, 0x40, 0x5C, 0x0D, 0x75, 0x0E, 0xC0, 0x47, 0x30,
  0xBC, 0x08, 0x75, 0x09, 0xC0, 0xA7, 0x20, 0x1D, 0x02, 0x75, 0x04, 0xC0, 0xE7, 0x20, 0x6C, 0x0C,
  0x77, 0x0E, 0xC0, 0x57, 0x10, 0xCC, 0x07, 0x77, 0x09, 0xC0, 0xB7, 0x02, 0xD0, 0x17, 0x70, 0x3D,
  0x01, 0x60, 0x7C, 0x0C, 0x77, 0x20, 0xDC, 0x06, 0x60, 0xCC, 0x06, 0x77, 0x20, 0x8C, 0x0C, 0x50,
  0x2D, 0x01, 0x77, 0x20, 0x3D, 0x02, 0x40, 0x8C, 0x0B, 0x77, 0x40, 0xDC, 0x07, 0x40, 0xDC, 0x05,
  0x77, 0x40, 0x8C, 0x0D, 0x30, 0x3D, 0x77, 0x50, 0x3D, 0x03, 0x20, 0x9C, 0x0A, 0x77, 0x60, 0xDC,
  0x08, 0x20, 0xEC, 0x05, 0x77, 0x60, 0x8C, 0x81, 0xD0, 0x4D, 0x80, 0xA1, 0x60, 0x8D, 0x04, 0x09,
  0xFF, 0xFF, 0xC0, 0x90, 0xCF, 0xFF, 0xFC, 0x00, 0xCF, 0xFF, 0xFC, 0x00, 0xCF, 0xFF, 0xFC, 0x0C,
  // "√" (U+221A)
  0x77, 0x77, 0x20, 0x58, 0x00, 0x77, 0x77, 0x72, 0x0D, 0xB0, 0xB7, 0x77, 0x71, 0x04, 0xC0, 0x67,
  0x77, 0x71, 0x09, 0xC0, 0x17, 0x77, 0x71, 0x0E, 0xB0, 0xB7, 0x77, 0x71, 0x04, 0xC0, 0x57, 0x77,
  0x71, 0x0A, 0xB0, 0xE7, 0x77, 0x72, 0x0E, 0xB0, 0xA7, 0x77, 0x71, 0x05, 0xC0, 0x47, 0x77, 0x71,
  0x0A, 0xB0, 0xE7, 0x77, 0x71, 0x01, 0xC0, 0x97, 0x77, 0x71, 0x05, 0xC0, 0x37, 0x77, 0x71, 0x0B,
  0xB0, 0xD7, 0x77, 0x71, 0x01, 0xC0, 0x87, 0x77, 0x71, 0x06, 0xC0, 0x37, 0x77, 0x71, 0x0B, 0xB0,
  0xD7, 0x77, 0x71, 0x01, 0xC0, 0x77, 0x77, 0x71, 0x07, 0xC0, 0x27, 0x77, 0x71, 0x0C, 0xB0, 0xC7,
  0x77, 0x71, 0x02, 0xC0, 0x67, 0x77, 0x71, 0x07, 0xC0, 0x17, 0x77, 0x71, 0x0D, 0xB0, 0xB7, 0x77,
  0x71, 0x03, 0xC0, 0x57, 0x05, 0x80, 0x36, 0x04, 0x76, 0x08, 0xC7, 0x10, 0xEF, 0x0E, 0x76, 0x0D,
  0xB0, 0xA7, 0x10, 0xEF, 0x90, 0x47, 0x40, 0x3C, 0x05, 0x71, 0x0E, 0xF9, 0x09, 0x74, 0x09, 0xB0,
  0xE7, 0x20, 0xEF, 0x90, 0xE7, 0x40, 0xEB, 0x09, 0x77, 0x07, 0xC0, 0x47, 0x20, 0x4C, 0x04, 0x77,
  0x01, 0xC0, 0xA7, 0x20, 0x9B, 0x0E, 0x77, 0x20, 0xBB, 0x0E, 0x72, 0x0E, 0xB0, 0x87, 0x72, 0x06,
  0xC0, 0x57, 0x05, 0xC0, 0x37, 0x72, 0x01, 0xC0, 0xA7, 0x0A, 0xB0, 0xD7, 0x74, 0x0B, 0xB0, 0xE7,
  0xC0, 0x87, 0x74, 0x05, 0xC0, 0x55, 0x05, 0xC0, 0x27, 0x75, 0x0E, 0xB0, 0xA5, 0x0B, 0xB0, 0xC7,
  0x76, 0x0A, 0xB0, 0xE4, 0x01, 0xC0, 0x77, 0x76, 0x04, 0xC0, 0x53, 0x06, 0xC0, 0x17, 0x77, 0x0E,
  0xB0, 0xA3, 0x0B, 0xB0, 0xB7, 0x77, 0x10, 0x9C, 0x20, 0x1C, 0x06, 0x77, 0x71, 0x03, 0xC8, 0x15,
  0x07, 0xC0, 0x17, 0x77, 0x20, 0xDB, 0x81, 0xA0, 0xCB, 0x0A, 0x77, 0x73, 0x08, 0xC0, 0x3C, 0x05,
  0x77, 0x73, 0x02, 0xC0, 0xCB, 0x0E, 0x77, 0x75, 0x0C, 0xF0, 0xA7, 0x77, 0x50, 0x7F, 0x04, 0x77,
  0x75, 0x02, 0xE0, 0xE7, 0x77, 0x70, 0xCD, 0x09, 0x77, 0x77, 0x06, 0xD0, 0x37, 0x77, 0x70, 0x1C,
  0x0D, 0x77, 0x77, 0x20, 0xBB, 0x08, 0x77, 0x30,
  // "∞" (U+221E)
  0x58, 0x62, 0x7B, 0xCC, 0xA6, 0x17, 0x38, 0x61, 0x7A, 0xCC, 0xB7, 0x27, 0x20, 0x8F, 0x90, 0x77,
  0x10, 0x7F, 0x90, 0x96, 0x01, 0x0B, 0xFB, 0x0B, 0x60, 0xAF, 0xB0, 0xC0, 0x14, 0x0A, 0xFD, 0x0C,
  0x40, 0xAF, 0xD0, 0xB3, 0x05, 0xC8, 0x4C, 0x41, 0x02, 0x8C, 0x0A, 0x20, 0x8B, 0x85, 0xE7, 0x20,
  0x15, 0xDC, 0x06, 0x20, 0xDB, 0x0A, 0x60, 0x30, 0xEB, 0x07, 0x04, 0xB0, 0xE0, 0x36, 0x0C, 0xB8,
  0x1D, 0x03, 0xB0, 0xE0, 0x17, 0x04, 0xC0, 0xEB, 0x04, 0x70, 0x1C, 0x03, 0x07, 0xB0, 0x97, 0x20,
  0x7E, 0x08, 0x72, 0x0A, 0xB0, 0x70, 0x9B, 0x06, 0x73, 0x0C, 0xC0, 0xD7, 0x30, 0x6B, 0x08, 0x0A,
  0xB0, 0x57, 0x30, 0x2C, 0x04, 0x73, 0x05, 0xB0, 0x90, 0xAB, 0x06, 0x73, 0x05, 0xC0, 0x87, 0x30,
  0x6B, 0x00, 0x8B, 0x09, 0x72, 0x01, 0x0D, 0xD0, 0x37, 0x20, 0x9B, 0x06, 0x05, 0xB0, 0xE7, 0x20,
  0xBE, 0x0D, 0x01, 0x70, 0x10, 0xEB, 0x03, 0x01, 0xC0, 0x97, 0x09, 0xB0, 0x0B, 0xB0, 0xB7, 0x0B,
  0xB0, 0xD2, 0x09, 0xC0, 0xB0, 0x33, 0x04, 0x0B, 0xB8, 0x2E, 0x11, 0xDB, 0x0D, 0x04, 0x30, 0x40,
  0xCC, 0x06, 0x20, 0x10, 0xDE, 0x0E, 0xE0, 0x42, 0x03, 0x0E, 0xD0, 0xEE, 0x0B, 0x40, 0x30, 0xEF,
  0xB0, 0xE0, 0x44, 0x03, 0x0E, 0xFB, 0x0C, 0x01, 0x50, 0x20, 0xBF, 0x90, 0xD0, 0x36, 0x02, 0x0C,
  0xF9, 0x0A, 0x72, 0x86, 0x49, 0xDE, 0xFD, 0xB6, 0x73, 0x81, 0x5A, 0xDA, 0x81, 0xD9, 0x45,
  // "≈" (U+2248)
  0x48, 0x73, 0x9C, 0xEF, 0xEB, 0x83, 0x77, 0x10, 0x60, 0x12, 0x01, 0x0A, 0xFA, 0x81, 0xD7, 0x17,
  0x48, 0x47, 0xF1, 0x02, 0xEF, 0xD8, 0x1E, 0x92, 0x71, 0x0A, 0xA8, 0x11, 0x1E, 0xFF, 0xA8, 0x1B,
  0x62, 0x28, 0x12, 0x7E, 0xB0, 0x10, 0x2C, 0x84, 0xD9, 0x66, 0x8C, 0xFF, 0xC0, 0x10, 0x2A, 0x0E,
  0x05, 0x68, 0x12, 0x8E, 0xFF, 0x84, 0x50, 0x2F, 0xC1, 0x72, 0x81, 0x17, 0xDF, 0xB0, 0xE0, 0x52,
  0x02, 0x0B, 0x77, 0x81, 0x4A, 0xED, 0x81, 0xE9, 0x17, 0x77, 0x18, 0x33, 0x55, 0x43, 0x80, 0x9C,
  0x00, 0x87, 0x49, 0xDE, 0xFE, 0xC9, 0x47, 0x71, 0x07, 0x01, 0x20, 0x30, 0xCF, 0xA8, 0x1E, 0x93,
  0x74, 0x83, 0x9F, 0x10, 0x5F, 0xF8, 0x1D, 0x71, 0x60, 0x40, 0xDA, 0x01, 0x02, 0xFF, 0xC8, 0x4C,
  0x86, 0x68, 0xDC, 0x01, 0x02, 0xC8, 0x4C, 0x86, 0x68, 0xCF, 0xFC, 0x01, 0x02, 0xA0, 0xC0, 0x36,
  0x81, 0x16, 0xDF, 0xE8, 0x4E, 0x40, 0x2F, 0x87, 0x48, 0x13, 0xAE, 0xFA, 0x0B, 0x02, 0x20, 0x20,
  0x67, 0x71, 0x87, 0x59, 0xCE, 0xFE, 0xC9, 0x44,
  // "≠" (U+2260)
  0x77, 0x40, 0x02, 0x77, 0x75, 0x82, 0xBF, 0xB5, 0x77, 0x72, 0x03, 0xC0, 0xD0, 0x17, 0x77, 0x0A,
  0xC0, 0xB7, 0x77, 0x02, 0xD0, 0x37, 0x77, 0x09, 0xC0, 0xC7, 0x77, 0x01, 0xD0, 0x47, 0x77, 0x08,
  0xC0, 0xC7, 0x77, 0x10, 0xEC, 0x05, 0x70, 0xCF, 0xFF, 0xD0, 0x0C, 0xFF, 0xFD, 0x00, 0xCF, 0xFF,
  0xD0, 0x0C, 0xFF, 0xFD, 0x0C, 0x09, 0x80, 0x7C, 0x0E, 0xD8, 0x05, 0xC0, 0x97, 0x50, 0xCC, 0x08,
  0x77, 0x70, 0x4D, 0x01, 0x77, 0x70, 0xCC, 0x09, 0x77, 0x70, 0x4D, 0x01, 0x77, 0x70, 0xBC, 0x09,
  0x77, 0x70, 0x3D, 0x02, 0x75, 0x09, 0x80, 0x4C, 0x0D, 0xD8, 0x09, 0x0C, 0x09, 0x0C, 0xFF, 0xFD,
  0x00, 0xCF, 0xFF, 0xD0, 0x0C, 0xFF, 0xFD, 0x00, 0xCF, 0xFF, 0xD0, 0xC6, 0x01, 0x0E, 0xC0, 0x57,
  0x77, 0x07, 0xC0, 0xD7, 0x77, 0x10, 0xEC, 0x05, 0x77, 0x70, 0x6C, 0x0D, 0x77, 0x71, 0x0D, 0xC0,
  0x67, 0x77, 0x05, 0xC0, 0xE7, 0x77, 0x10, 0x60, 0xEB, 0x07, 0x77, 0x73, 0x82, 0x5C, 0xE1, 0x77,
  0x75, 0x01, 0x77, 0x50,
  // "≤" (U+2264)
  0x77, 0x77, 0x05, 0x01, 0x77, 0x75, 0x82, 0x5C, 0xF2, 0x77, 0x73, 0x05, 0x0C, 0xB0, 0x27, 0x77,
  0x10, 0x50, 0xCD, 0x02, 0x77, 0x60, 0x50, 0xCF, 0x02, 0x77, 0x40, 0x50, 0xCF, 0x0C, 0x05, 0x77,
  0x30, 0x50, 0xCF, 0x0B, 0x04, 0x77, 0x30, 0x50, 0xCF, 0x0A, 0x03, 0x77, 0x30, 0x50, 0xCF, 0x0A,
  0x02, 0x77, 0x30, 0x50, 0xDF, 0x09, 0x02, 0x77, 0x30, 0x50, 0xDE, 0x81, 0xE8, 0x17, 0x73, 0x05,
  0x0D, 0xE8, 0x1E, 0x71, 0x77, 0x30, 0x50, 0xDE, 0x0E, 0x07, 0x77, 0x40, 0x50, 0xDE, 0x0D, 0x06,
  0x77, 0x50, 0xDE, 0x0C, 0x05, 0x77, 0x60, 0x1D, 0x0E, 0x04, 0x77, 0x71, 0x01, 0xE0, 0xC0, 0x67,
  0x77, 0x10, 0xAF, 0x81, 0xE9, 0x27, 0x76, 0x81, 0x29, 0xEF, 0x0B, 0x05, 0x77, 0x68, 0x11, 0x7D,
  0xF8, 0x1D, 0x71, 0x77, 0x60, 0x50, 0xCF, 0x90, 0xA0, 0x37, 0x76, 0x03, 0x0A, 0xF9, 0x0C, 0x06,
  0x77, 0x68, 0x11, 0x8E, 0xF8, 0x1E, 0x92, 0x77, 0x60, 0x60, 0xDF, 0x90, 0xB0, 0x57, 0x76, 0x04,
  0x0B, 0xF9, 0x81, 0xD7, 0x17, 0x75, 0x02, 0x09, 0xFA, 0x02, 0x77, 0x68, 0x11, 0x7E, 0xE0, 0x27,
  0x77, 0x20, 0x50, 0xCC, 0x02, 0x77, 0x74, 0x03, 0x0A, 0xA0, 0x27, 0x77, 0x68, 0x12, 0x82, 0x80,
  0xF1, 0x08, 0x0B, 0x04, 0x10, 0x1F, 0xFF, 0xF0, 0x20, 0x1F, 0xFF, 0xF0, 0x20, 0x1F, 0xFF, 0xF0,
  0x20, 0x1F, 0xFF, 0xF0, 0x20,
  // "≥" (U+2265)
  0x01, 0x05, 0x77, 0x77, 0x82, 0x2F, 0xC5, 0x77, 0x75, 0x02, 0xB0, 0xC0, 0x57, 0x77, 0x30, 0x2D,
  0x0C, 0x05, 0x77, 0x71, 0x02, 0xF0, 0xC0, 0x57, 0x77, 0x05, 0x0C, 0xF0, 0xC0, 0x57, 0x77, 0x04,
  0x0B, 0xF0, 0xC0, 0x57, 0x77, 0x03, 0x0B, 0xF0, 0xC0, 0x57, 0x77, 0x02, 0x0A, 0xF0, 0xC0, 0x57,
  0x77, 0x02, 0x09, 0xF0, 0xD0, 0x57, 0x77, 0x81, 0x18, 0xEE, 0x0D, 0x05, 0x77, 0x78, 0x11, 0x7E,
  0xE0, 0xD0, 0x57, 0x77, 0x10, 0x70, 0xEE, 0x0D, 0x05, 0x77, 0x71, 0x06, 0x0D, 0xE0, 0xD0, 0x57,
  0x77, 0x10, 0x50, 0xCE, 0x0D, 0x77, 0x72, 0x04, 0x0E, 0xD0, 0x17, 0x77, 0x06, 0x0C, 0xE0, 0x17,
  0x74, 0x81, 0x29, 0xEF, 0x0A, 0x77, 0x30, 0x50, 0xBF, 0x81, 0xE9, 0x27, 0x71, 0x81, 0x17, 0xDF,
  0x81, 0xD7, 0x17, 0x71, 0x03, 0x0A, 0xF9, 0x0C, 0x05, 0x77, 0x20, 0x60, 0xCF, 0x90, 0xA0, 0x37,
  0x71, 0x81, 0x29, 0xEF, 0x81, 0xE8, 0x17, 0x71, 0x05, 0x0B, 0xF9, 0x0D, 0x06, 0x77, 0x18, 0x11,
  0x7D, 0xF9, 0x0B, 0x04, 0x77, 0x20, 0x2F, 0xA0, 0x90, 0x27, 0x74, 0x02, 0xE8, 0x1E, 0x71, 0x77,
  0x60, 0x2C, 0x0C, 0x05, 0x77, 0x72, 0x02, 0xA0, 0xA0, 0x37, 0x77, 0x48, 0x12, 0x82, 0x80, 0x9A,
  0x40, 0x80, 0xB0, 0x41, 0x02, 0xFF, 0xFF, 0x01, 0x02, 0xFF, 0xFF, 0x01, 0x02, 0xFF, 0xFF, 0x01,
  0x02, 0xFF, 0xFF, 0x01,
};

const Font& font_NotoSansMono_Regular_60() {
  static SmoothFont font(font_NotoSansMono_Regular_60_data);
  return font;
}

}  // namespace roo_display
