#include "40.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSansMono-Regular (Noto Sans Mono Regular)
// Generated on Wed Nov 19 19:10:52 CET 2025
static const uint8_t font_NotoSansMono_Regular_40_data[] PROGMEM = {
  
  // Header
  0x01, 0x02, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x5D, 0x00, 0x00,
  0xF8, 0xF7, 0x3E, 0x28, 0x1F, 0xF6, 0x09, 0x00, 0x48, 0x0C, 0x18, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x09, 0x01, 0x0E, 0x1D, 0x18, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x06, 0x14, 0x11, 0x1D, 0x18, 0x00, 0x47, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x17, 0x1D, 0x18, 0x00, 0x7C, // "#" (U+0023)
  0x00, 0x24, 0x03, 0xFF, 0x14, 0x1F, 0x18, 0x01, 0x27, // "$" (U+0024)
  0x00, 0x25, 0x00, 0x01, 0x17, 0x1D, 0x18, 0x01, 0xDE, // "%" (U+0025)
  0x00, 0x26, 0x01, 0x01, 0x16, 0x1D, 0x18, 0x02, 0xCC, // "&" (U+0026)
  0x00, 0x27, 0x4A, 0x14, 0x0D, 0x1D, 0x18, 0x03, 0x95, // "'" (U+0027)
  0x00, 0x28, 0x08, 0xFB, 0x10, 0x1D, 0x18, 0x03, 0xA9, // "(" (U+0028)
  0x00, 0x29, 0x07, 0xFA, 0x0F, 0x1C, 0x18, 0x04, 0x13, // ")" (U+0029)
  0x00, 0x2A, 0x03, 0x0E, 0x14, 0x1E, 0x18, 0x04, 0x7E, // "*" (U+002A)
  0x00, 0x2B, 0x03, 0x06, 0x14, 0x18, 0x18, 0x04, 0xD9, // "+" (U+002B)
  0x00, 0x2C, 0x08, 0xFB, 0x0F, 0x05, 0x18, 0x05, 0x1E, // "," (U+002C)
  0x00, 0x2D, 0x06, 0x0A, 0x11, 0x0C, 0x18, 0x05, 0x3F, // "-" (U+002D)
  0x00, 0x2E, 0x49, 0x01, 0x0E, 0x05, 0x18, 0x05, 0x44, // "." (U+002E)
  0x00, 0x2F, 0x05, 0x01, 0x12, 0x1D, 0x18, 0x05, 0x53, // "/" (U+002F)
  0x00, 0x30, 0x02, 0x01, 0x15, 0x1D, 0x18, 0x05, 0xBA, // "0" (U+0030)
  0x00, 0x31, 0x04, 0x01, 0x14, 0x1D, 0x18, 0x06, 0x88, // "1" (U+0031)
  0x00, 0x32, 0x02, 0x01, 0x15, 0x1D, 0x18, 0x06, 0xFF, // "2" (U+0032)
  0x00, 0x33, 0x03, 0x01, 0x14, 0x1D, 0x18, 0x07, 0x81, // "3" (U+0033)
  0x00, 0x34, 0x02, 0x01, 0x15, 0x1D, 0x18, 0x08, 0x0B, // "4" (U+0034)
  0x00, 0x35, 0x03, 0x01, 0x14, 0x1D, 0x18, 0x08, 0x9F, // "5" (U+0035)
  0x00, 0x36, 0x02, 0x01, 0x15, 0x1D, 0x18, 0x09, 0x1D, // "6" (U+0036)
  0x00, 0x37, 0x02, 0x01, 0x15, 0x1D, 0x18, 0x09, 0xC8, // "7" (U+0037)
  0x00, 0x38, 0x02, 0x01, 0x15, 0x1D, 0x18, 0x0A, 0x3E, // "8" (U+0038)
  0x00, 0x39, 0x02, 0x01, 0x15, 0x1D, 0x18, 0x0B, 0x06, // "9" (U+0039)
  0x00, 0x3A, 0x09, 0x01, 0x0E, 0x16, 0x18, 0x0B, 0xB4, // ":" (U+003A)
  0x00, 0x3B, 0x08, 0xFC, 0x0F, 0x16, 0x18, 0x0B, 0xD3, // ";" (U+003B)
  0x00, 0x3C, 0x03, 0x05, 0x14, 0x19, 0x18, 0x0C, 0x06, // "<" (U+003C)
  0x00, 0x3D, 0x02, 0x0A, 0x15, 0x14, 0x18, 0x0C, 0x6D, // "=" (U+003D)
  0x00, 0x3E, 0x03, 0x05, 0x14, 0x19, 0x18, 0x0C, 0x86, // ">" (U+003E)
  0x00, 0x3F, 0x03, 0x01, 0x14, 0x1D, 0x18, 0x0C, 0xEC, // "?" (U+003F)
  0x00, 0x40, 0x00, 0xFD, 0x17, 0x1D, 0x18, 0x0D, 0x5D, // "@" (U+0040)
  0x00, 0x41, 0x00, 0x01, 0x17, 0x1D, 0x18, 0x0E, 0x85, // "A" (U+0041)
  0x00, 0x42, 0x03, 0x01, 0x15, 0x1D, 0x18, 0x0F, 0x31, // "B" (U+0042)
  0x00, 0x43, 0x02, 0x01, 0x15, 0x1D, 0x18, 0x0F, 0xE3, // "C" (U+0043)
  0x00, 0x44, 0x02, 0x01, 0x16, 0x1D, 0x18, 0x10, 0x6D, // "D" (U+0044)
  0x00, 0x45, 0x03, 0x01, 0x14, 0x1D, 0x18, 0x11, 0x21, // "E" (U+0045)
  0x00, 0x46, 0x03, 0x01, 0x14, 0x1D, 0x18, 0x11, 0x8D, // "F" (U+0046)
  0x00, 0x47, 0x01, 0x01, 0x15, 0x1D, 0x18, 0x11, 0xF7, // "G" (U+0047)
  0x00, 0x48, 0x02, 0x01, 0x15, 0x1D, 0x18, 0x12, 0x9F, // "H" (U+0048)
  0x00, 0x49, 0x04, 0x01, 0x13, 0x1D, 0x18, 0x13, 0x3A, // "I" (U+0049)
  0x00, 0x4A, 0x04, 0x01, 0x12, 0x1D, 0x18, 0x13, 0xA6, // "J" (U+004A)
  0x00, 0x4B, 0x02, 0x01, 0x15, 0x1D, 0x18, 0x13, 0xFF, // "K" (U+004B)
  0x00, 0x4C, 0x04, 0x01, 0x14, 0x1D, 0x18, 0x14, 0xBA, // "L" (U+004C)
  0x00, 0x4D, 0x02, 0x01, 0x15, 0x1D, 0x18, 0x15, 0x21, // "M" (U+004D)
  0x00, 0x4E, 0x02, 0x01, 0x15, 0x1D, 0x18, 0x15, 0xCD, // "N" (U+004E)
  0x00, 0x4F, 0x01, 0x01, 0x16, 0x1D, 0x18, 0x16, 0x97, // "O" (U+004F)
  0x00, 0x50, 0x03, 0x01, 0x15, 0x1D, 0x18, 0x17, 0x53, // "P" (U+0050)
  0x00, 0x51, 0x01, 0xFA, 0x16, 0x1D, 0x18, 0x17, 0xE4, // "Q" (U+0051)
  0x00, 0x52, 0x03, 0x01, 0x16, 0x1D, 0x18, 0x18, 0xBA, // "R" (U+0052)
  0x00, 0x53, 0x03, 0x01, 0x15, 0x1D, 0x18, 0x19, 0x6B, // "S" (U+0053)
  0x00, 0x54, 0x01, 0x01, 0x16, 0x1D, 0x18, 0x19, 0xFA, // "T" (U+0054)
  0x00, 0x55, 0x02, 0x01, 0x15, 0x1D, 0x18, 0x1A, 0x70, // "U" (U+0055)
  0x00, 0x56, 0x01, 0x01, 0x16, 0x1D, 0x18, 0x1B, 0x18, // "V" (U+0056)
  0x00, 0x57, 0x01, 0x01, 0x16, 0x1D, 0x18, 0x1B, 0xC6, // "W" (U+0057)
  0x00, 0x58, 0x01, 0x01, 0x16, 0x1D, 0x18, 0x1C, 0xBA, // "X" (U+0058)
  0x00, 0x59, 0x01, 0x01, 0x16, 0x1D, 0x18, 0x1D, 0x6B, // "Y" (U+0059)
  0x00, 0x5A, 0x03, 0x01, 0x14, 0x1D, 0x18, 0x1E, 0x05, // "Z" (U+005A)
  0x00, 0x5B, 0x09, 0xFB, 0x12, 0x1D, 0x18, 0x1E, 0x73, // "[" (U+005B)
  0x00, 0x5C, 0x05, 0x01, 0x12, 0x1D, 0x18, 0x1E, 0xC2, // "\" (U+005C)
  0x00, 0x5D, 0x05, 0xFB, 0x0E, 0x1D, 0x18, 0x1F, 0x27, // "]" (U+005D)
  0x00, 0x5E, 0x02, 0x0C, 0x15, 0x1D, 0x18, 0x1F, 0x76, // "^" (U+005E)
  0x00, 0x5F, 0x00, 0xFB, 0x17, 0xFD, 0x18, 0x1F, 0xDF, // "_" (U+005F)
  0x00, 0x60, 0x07, 0x19, 0x0F, 0x1F, 0x18, 0x1F, 0xE4, // "`" (U+0060)
  0x00, 0x61, 0x02, 0x01, 0x14, 0x16, 0x18, 0x1F, 0xFB, // "a" (U+0061)
  0x00, 0x62, 0x03, 0x01, 0x15, 0x1F, 0x18, 0x20, 0x86, // "b" (U+0062)
  0x00, 0x63, 0x03, 0x01, 0x14, 0x16, 0x18, 0x21, 0x42, // "c" (U+0063)
  0x00, 0x64, 0x02, 0x01, 0x14, 0x1F, 0x18, 0x21, 0xA8, // "d" (U+0064)
  0x00, 0x65, 0x02, 0x01, 0x15, 0x16, 0x18, 0x22, 0x63, // "e" (U+0065)
  0x00, 0x66, 0x02, 0x01, 0x16, 0x1F, 0x18, 0x22, 0xDA, // "f" (U+0066)
  0x00, 0x67, 0x02, 0xF7, 0x14, 0x16, 0x18, 0x23, 0x65, // "g" (U+0067)
  0x00, 0x68, 0x03, 0x01, 0x14, 0x1F, 0x18, 0x24, 0x31, // "h" (U+0068)
  0x00, 0x69, 0x03, 0x01, 0x15, 0x1F, 0x18, 0x24, 0xCE, // "i" (U+0069)
  0x00, 0x6A, 0x02, 0xF7, 0x10, 0x1F, 0x18, 0x25, 0x39, // "j" (U+006A)
  0x00, 0x6B, 0x04, 0x01, 0x16, 0x1F, 0x18, 0x25, 0xCC, // "k" (U+006B)
  0x00, 0x6C, 0x03, 0x01, 0x15, 0x1F, 0x18, 0x26, 0x81, // "l" (U+006C)
  0x00, 0x6D, 0x02, 0x01, 0x15, 0x16, 0x18, 0x27, 0x01, // "m" (U+006D)
  0x00, 0x6E, 0x03, 0x01, 0x14, 0x16, 0x18, 0x27, 0x90, // "n" (U+006E)
  0x00, 0x6F, 0x02, 0x01, 0x15, 0x16, 0x18, 0x28, 0x0A, // "o" (U+006F)
  0x00, 0x70, 0x03, 0xF7, 0x15, 0x16, 0x18, 0x28, 0x94, // "p" (U+0070)
  0x00, 0x71, 0x02, 0xF7, 0x14, 0x16, 0x18, 0x29, 0x52, // "q" (U+0071)
  0x00, 0x72, 0x02, 0x01, 0x16, 0x16, 0x18, 0x2A, 0x11, // "r" (U+0072)
  0x00, 0x73, 0x04, 0x01, 0x13, 0x16, 0x18, 0x2A, 0x71, // "s" (U+0073)
  0x00, 0x74, 0x02, 0x01, 0x14, 0x1C, 0x18, 0x2A, 0xDF, // "t" (U+0074)
  0x00, 0x75, 0x03, 0x01, 0x14, 0x16, 0x18, 0x2B, 0x58, // "u" (U+0075)
  0x00, 0x76, 0x02, 0x01, 0x15, 0x16, 0x18, 0x2B, 0xD4, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x01, 0x17, 0x16, 0x18, 0x2C, 0x52, // "w" (U+0077)
  0x00, 0x78, 0x02, 0x01, 0x15, 0x16, 0x18, 0x2D, 0x14, // "x" (U+0078)
  0x00, 0x79, 0x02, 0xF7, 0x15, 0x16, 0x18, 0x2D, 0x9C, // "y" (U+0079)
  0x00, 0x7A, 0x03, 0x01, 0x14, 0x16, 0x18, 0x2E, 0x49, // "z" (U+007A)
  0x00, 0x7B, 0x05, 0xFB, 0x12, 0x1D, 0x18, 0x2E, 0xA3, // "{" (U+007B)
  0x00, 0x7C, 0x4A, 0xF7, 0x0D, 0x1F, 0x18, 0x2F, 0x27, // "|" (U+007C)
  0x00, 0x7D, 0x05, 0xFA, 0x12, 0x1C, 0x18, 0x2F, 0x79, // "}" (U+007D)
  0x00, 0x7E, 0x03, 0x0D, 0x14, 0x13, 0x18, 0x2F, 0xFD, // "~" (U+007E)
  0x00, 0xA1, 0x09, 0xF9, 0x0E, 0x15, 0x18, 0x30, 0x2F, // "¡" (U+00A1)
  0x00, 0xA2, 0x03, 0x01, 0x14, 0x1D, 0x18, 0x30, 0x76, // "¢" (U+00A2)
  0x00, 0xA3, 0x03, 0x01, 0x14, 0x1D, 0x18, 0x30, 0xED, // "£" (U+00A3)
  0x00, 0xA4, 0x03, 0x06, 0x14, 0x17, 0x18, 0x31, 0x62, // "¤" (U+00A4)
  0x00, 0xA5, 0x01, 0x01, 0x16, 0x1D, 0x18, 0x31, 0xDE, // "¥" (U+00A5)
  0x00, 0xA6, 0x0A, 0xF7, 0x0D, 0x1F, 0x18, 0x32, 0x78, // "¦" (U+00A6)
  0x00, 0xA7, 0x04, 0x01, 0x13, 0x1F, 0x18, 0x32, 0xC6, // "§" (U+00A7)
  0x00, 0xA8, 0x05, 0x1A, 0x12, 0x1E, 0x18, 0x33, 0x70, // "¨" (U+00A8)
  0x00, 0xA9, 0x01, 0x05, 0x16, 0x19, 0x18, 0x33, 0x8D, // "©" (U+00A9)
  0x00, 0xAA, 0x06, 0x11, 0x11, 0x1E, 0x18, 0x34, 0x45, // "ª" (U+00AA)
  0x00, 0xAB, 0x03, 0x03, 0x14, 0x13, 0x18, 0x34, 0x8D, // "«" (U+00AB)
  0x00, 0xAC, 0x03, 0x06, 0x14, 0x10, 0x18, 0x35, 0x04, // "¬" (U+00AC)
  0x00, 0xAE, 0x01, 0x05, 0x16, 0x19, 0x18, 0x35, 0x29, // "®" (U+00AE)
  0x00, 0xAF, 0x06, 0x1A, 0x11, 0x1C, 0x18, 0x35, 0xF0, // "¯" (U+00AF)
  0x00, 0xB0, 0x06, 0x12, 0x11, 0x1D, 0x18, 0x35, 0xFA, // "°" (U+00B0)
  0x00, 0xB1, 0x03, 0x01, 0x14, 0x18, 0x18, 0x36, 0x36, // "±" (U+00B1)
  0x00, 0xB2, 0x06, 0x12, 0x12, 0x23, 0x18, 0x36, 0x89, // "²" (U+00B2)
  0x00, 0xB3, 0x06, 0x11, 0x11, 0x22, 0x18, 0x36, 0xD7, // "³" (U+00B3)
  0x00, 0xB4, 0x09, 0x19, 0x11, 0x1F, 0x18, 0x37, 0x2C, // "´" (U+00B4)
  0x00, 0xB5, 0x03, 0xF7, 0x14, 0x16, 0x18, 0x37, 0x44, // "µ" (U+00B5)
  0x00, 0xB6, 0x02, 0xFC, 0x15, 0x1F, 0x18, 0x37, 0xD3, // "¶" (U+00B6)
  0x00, 0xB7, 0x49, 0x0C, 0x0E, 0x10, 0x18, 0x38, 0xB2, // "·" (U+00B7)
  0x00, 0xB8, 0x08, 0xF7, 0x0F, 0x00, 0x18, 0x38, 0xC1, // "¸" (U+00B8)
  0x00, 0xB9, 0x06, 0x12, 0x12, 0x22, 0x18, 0x38, 0xE4, // "¹" (U+00B9)
  0x00, 0xBA, 0x06, 0x11, 0x11, 0x1E, 0x18, 0x39, 0x2B, // "º" (U+00BA)
  0x00, 0xBB, 0x03, 0x03, 0x14, 0x13, 0x18, 0x39, 0x72, // "»" (U+00BB)
  0x00, 0xBC, 0x00, 0x01, 0x16, 0x1D, 0x18, 0x39, 0xE9, // "¼" (U+00BC)
  0x00, 0xBD, 0x00, 0x01, 0x16, 0x1D, 0x18, 0x3A, 0xBE, // "½" (U+00BD)
  0x00, 0xBE, 0x01, 0x01, 0x16, 0x1D, 0x18, 0x3B, 0x8C, // "¾" (U+00BE)
  0x00, 0xBF, 0x02, 0xF9, 0x13, 0x15, 0x18, 0x3C, 0x67, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x17, 0x26, 0x18, 0x3C, 0xD9, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x17, 0x26, 0x18, 0x3D, 0xA3, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x01, 0x17, 0x26, 0x18, 0x3E, 0x6E, // "Â" (U+00C2)
  0x00, 0xC3, 0x00, 0x01, 0x17, 0x24, 0x18, 0x3F, 0x45, // "Ã" (U+00C3)
  0x00, 0xC4, 0x00, 0x01, 0x17, 0x25, 0x18, 0x40, 0x14, // "Ä" (U+00C4)
  0x00, 0xC5, 0x00, 0x01, 0x17, 0x27, 0x18, 0x40, 0xE4, // "Å" (U+00C5)
  0x00, 0xC6, 0x00, 0x01, 0x15, 0x1D, 0x18, 0x41, 0xC0, // "Æ" (U+00C6)
  0x00, 0xC7, 0x02, 0xF7, 0x15, 0x1D, 0x18, 0x42, 0x6F, // "Ç" (U+00C7)
  0x00, 0xC8, 0x03, 0x01, 0x14, 0x26, 0x18, 0x43, 0x25, // "È" (U+00C8)
  0x00, 0xC9, 0x03, 0x01, 0x14, 0x26, 0x18, 0x43, 0xAE, // "É" (U+00C9)
  0x00, 0xCA, 0x03, 0x01, 0x14, 0x26, 0x18, 0x44, 0x37, // "Ê" (U+00CA)
  0x00, 0xCB, 0x03, 0x01, 0x14, 0x25, 0x18, 0x44, 0xCB, // "Ë" (U+00CB)
  0x00, 0xCC, 0x04, 0x01, 0x13, 0x26, 0x18, 0x45, 0x59, // "Ì" (U+00CC)
  0x00, 0xCD, 0x04, 0x01, 0x13, 0x26, 0x18, 0x45, 0xE2, // "Í" (U+00CD)
  0x00, 0xCE, 0x04, 0x01, 0x13, 0x26, 0x18, 0x46, 0x6B, // "Î" (U+00CE)
  0x00, 0xCF, 0x04, 0x01, 0x13, 0x25, 0x18, 0x46, 0xFF, // "Ï" (U+00CF)
  0x00, 0xD0, 0x00, 0x01, 0x16, 0x1D, 0x18, 0x47, 0x8E, // "Ð" (U+00D0)
  0x00, 0xD1, 0x02, 0x01, 0x15, 0x24, 0x18, 0x48, 0x4A, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x01, 0x01, 0x16, 0x26, 0x18, 0x49, 0x36, // "Ò" (U+00D2)
  0x00, 0xD3, 0x01, 0x01, 0x16, 0x26, 0x18, 0x4A, 0x11, // "Ó" (U+00D3)
  0x00, 0xD4, 0x01, 0x01, 0x16, 0x26, 0x18, 0x4A, 0xEC, // "Ô" (U+00D4)
  0x00, 0xD5, 0x01, 0x01, 0x16, 0x24, 0x18, 0x4B, 0xD3, // "Õ" (U+00D5)
  0x00, 0xD6, 0x01, 0x01, 0x16, 0x25, 0x18, 0x4C, 0xB2, // "Ö" (U+00D6)
  0x00, 0xD7, 0x03, 0x06, 0x14, 0x17, 0x18, 0x4D, 0x92, // "×" (U+00D7)
  0x00, 0xD8, 0x01, 0x00, 0x16, 0x1E, 0x18, 0x4D, 0xF1, // "Ø" (U+00D8)
  0x00, 0xD9, 0x02, 0x01, 0x15, 0x26, 0x18, 0x4E, 0xD8, // "Ù" (U+00D9)
  0x00, 0xDA, 0x02, 0x01, 0x15, 0x26, 0x18, 0x4F, 0xA0, // "Ú" (U+00DA)
  0x00, 0xDB, 0x02, 0x01, 0x15, 0x26, 0x18, 0x50, 0x67, // "Û" (U+00DB)
  0x00, 0xDC, 0x02, 0x01, 0x15, 0x25, 0x18, 0x51, 0x3A, // "Ü" (U+00DC)
  0x00, 0xDD, 0x01, 0x01, 0x16, 0x26, 0x18, 0x52, 0x05, // "Ý" (U+00DD)
  0x00, 0xDE, 0x03, 0x01, 0x15, 0x1D, 0x18, 0x52, 0xBF, // "Þ" (U+00DE)
  0x00, 0xDF, 0x03, 0x01, 0x16, 0x1F, 0x18, 0x53, 0x4E, // "ß" (U+00DF)
  0x00, 0xE0, 0x02, 0x01, 0x14, 0x1F, 0x18, 0x54, 0x0D, // "à" (U+00E0)
  0x00, 0xE1, 0x02, 0x01, 0x14, 0x1F, 0x18, 0x54, 0xB6, // "á" (U+00E1)
  0x00, 0xE2, 0x02, 0x01, 0x14, 0x1F, 0x18, 0x55, 0x5E, // "â" (U+00E2)
  0x00, 0xE3, 0x02, 0x01, 0x14, 0x1D, 0x18, 0x56, 0x13, // "ã" (U+00E3)
  0x00, 0xE4, 0x02, 0x01, 0x14, 0x1E, 0x18, 0x56, 0xC0, // "ä" (U+00E4)
  0x00, 0xE5, 0x02, 0x01, 0x14, 0x20, 0x18, 0x57, 0x6D, // "å" (U+00E5)
  0x00, 0xE6, 0x00, 0x01, 0x17, 0x16, 0x18, 0x58, 0x26, // "æ" (U+00E6)
  0x00, 0xE7, 0x03, 0xF7, 0x14, 0x16, 0x18, 0x58, 0xCB, // "ç" (U+00E7)
  0x00, 0xE8, 0x02, 0x01, 0x15, 0x1F, 0x18, 0x59, 0x5A, // "è" (U+00E8)
  0x00, 0xE9, 0x02, 0x01, 0x15, 0x1F, 0x18, 0x59, 0xF0, // "é" (U+00E9)
  0x00, 0xEA, 0x02, 0x01, 0x15, 0x1F, 0x18, 0x5A, 0x85, // "ê" (U+00EA)
  0x00, 0xEB, 0x02, 0x01, 0x15, 0x1E, 0x18, 0x5B, 0x26, // "ë" (U+00EB)
  0x00, 0xEC, 0x03, 0x01, 0x15, 0x1F, 0x18, 0x5B, 0xBF, // "ì" (U+00EC)
  0x00, 0xED, 0x03, 0x01, 0x15, 0x1F, 0x18, 0x5C, 0x32, // "í" (U+00ED)
  0x00, 0xEE, 0x03, 0x01, 0x15, 0x1F, 0x18, 0x5C, 0xA3, // "î" (U+00EE)
  0x00, 0xEF, 0x03, 0x01, 0x15, 0x1E, 0x18, 0x5D, 0x21, // "ï" (U+00EF)
  0x00, 0xF0, 0x02, 0x01, 0x15, 0x1F, 0x18, 0x5D, 0x98, // "ð" (U+00F0)
  0x00, 0xF1, 0x03, 0x01, 0x14, 0x1D, 0x18, 0x5E, 0x56, // "ñ" (U+00F1)
  0x00, 0xF2, 0x02, 0x01, 0x15, 0x1F, 0x18, 0x5E, 0xF2, // "ò" (U+00F2)
  0x00, 0xF3, 0x02, 0x01, 0x15, 0x1F, 0x18, 0x5F, 0x9B, // "ó" (U+00F3)
  0x00, 0xF4, 0x02, 0x01, 0x15, 0x1F, 0x18, 0x60, 0x43, // "ô" (U+00F4)
  0x00, 0xF5, 0x02, 0x01, 0x15, 0x1D, 0x18, 0x60, 0xF7, // "õ" (U+00F5)
  0x00, 0xF6, 0x02, 0x01, 0x15, 0x1E, 0x18, 0x61, 0xA2, // "ö" (U+00F6)
  0x00, 0xF7, 0x03, 0x06, 0x14, 0x18, 0x18, 0x62, 0x4E, // "÷" (U+00F7)
  0x00, 0xF8, 0x02, 0x00, 0x15, 0x17, 0x18, 0x62, 0x80, // "ø" (U+00F8)
  0x00, 0xF9, 0x03, 0x01, 0x14, 0x1F, 0x18, 0x63, 0x2B, // "ù" (U+00F9)
  0x00, 0xFA, 0x03, 0x01, 0x14, 0x1F, 0x18, 0x63, 0xC4, // "ú" (U+00FA)
  0x00, 0xFB, 0x03, 0x01, 0x14, 0x1F, 0x18, 0x64, 0x5D, // "û" (U+00FB)
  0x00, 0xFC, 0x03, 0x01, 0x14, 0x1E, 0x18, 0x65, 0x01, // "ü" (U+00FC)
  0x00, 0xFD, 0x02, 0xF7, 0x15, 0x1F, 0x18, 0x65, 0x9F, // "ý" (U+00FD)
  0x00, 0xFE, 0x03, 0xF7, 0x15, 0x1F, 0x18, 0x66, 0x6B, // "þ" (U+00FE)
  0x00, 0xFF, 0x02, 0xF7, 0x15, 0x1E, 0x18, 0x67, 0x4D, // "ÿ" (U+00FF)
  0x01, 0x00, 0x00, 0x01, 0x17, 0x23, 0x18, 0x68, 0x1D, // "Ā" (U+0100)
  0x01, 0x01, 0x02, 0x01, 0x14, 0x1C, 0x18, 0x68, 0xD7, // "ā" (U+0101)
  0x01, 0x02, 0x00, 0x01, 0x17, 0x25, 0x18, 0x69, 0x70, // "Ă" (U+0102)
  0x01, 0x03, 0x02, 0x01, 0x14, 0x1E, 0x18, 0x6A, 0x42, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0xF8, 0x18, 0x1D, 0x18, 0x6A, 0xF2, // "Ą" (U+0104)
  0x01, 0x05, 0x02, 0xF8, 0x15, 0x16, 0x18, 0x6B, 0xC5, // "ą" (U+0105)
  0x01, 0x06, 0x02, 0x01, 0x15, 0x26, 0x18, 0x6C, 0x77, // "Ć" (U+0106)
  0x01, 0x07, 0x03, 0x01, 0x14, 0x1F, 0x18, 0x6D, 0x1E, // "ć" (U+0107)
  0x01, 0x08, 0x02, 0x01, 0x15, 0x26, 0x18, 0x6D, 0xA0, // "Ĉ" (U+0108)
  0x01, 0x09, 0x03, 0x01, 0x14, 0x1F, 0x18, 0x6E, 0x53, // "ĉ" (U+0109)
  0x01, 0x0A, 0x02, 0x01, 0x15, 0x25, 0x18, 0x6E, 0xE1, // "Ċ" (U+010A)
  0x01, 0x0B, 0x03, 0x01, 0x14, 0x1E, 0x18, 0x6F, 0x80, // "ċ" (U+010B)
  0x01, 0x0C, 0x02, 0x01, 0x15, 0x26, 0x18, 0x6F, 0xFA, // "Č" (U+010C)
  0x01, 0x0D, 0x03, 0x01, 0x14, 0x1F, 0x18, 0x70, 0xAF, // "č" (U+010D)
  0x01, 0x0E, 0x02, 0x01, 0x16, 0x26, 0x18, 0x71, 0x40, // "Ď" (U+010E)
  0x01, 0x0F, 0x01, 0x01, 0x19, 0x1F, 0x18, 0x72, 0x22, // "ď" (U+010F)
  0x01, 0x10, 0x00, 0x01, 0x16, 0x1D, 0x18, 0x72, 0xF2, // "Đ" (U+0110)
  0x01, 0x11, 0x02, 0x01, 0x17, 0x1F, 0x18, 0x73, 0xAE, // "đ" (U+0111)
  0x01, 0x12, 0x03, 0x01, 0x14, 0x23, 0x18, 0x74, 0x6F, // "Ē" (U+0112)
  0x01, 0x13, 0x02, 0x01, 0x15, 0x1C, 0x18, 0x74, 0xE9, // "ē" (U+0113)
  0x01, 0x14, 0x03, 0x01, 0x14, 0x25, 0x18, 0x75, 0x6F, // "Ĕ" (U+0114)
  0x01, 0x15, 0x02, 0x01, 0x15, 0x1E, 0x18, 0x75, 0xFF, // "ĕ" (U+0115)
  0x01, 0x16, 0x03, 0x01, 0x14, 0x25, 0x18, 0x76, 0x9B, // "Ė" (U+0116)
  0x01, 0x17, 0x02, 0x01, 0x15, 0x1E, 0x18, 0x77, 0x1B, // "ė" (U+0117)
  0x01, 0x18, 0x03, 0xF8, 0x14, 0x1D, 0x18, 0x77, 0xA8, // "Ę" (U+0118)
  0x01, 0x19, 0x02, 0xF8, 0x15, 0x16, 0x18, 0x78, 0x36, // "ę" (U+0119)
  0x01, 0x1A, 0x03, 0x01, 0x14, 0x26, 0x18, 0x78, 0xD2, // "Ě" (U+011A)
  0x01, 0x1B, 0x02, 0x01, 0x15, 0x1F, 0x18, 0x79, 0x6A, // "ě" (U+011B)
  0x01, 0x1C, 0x01, 0x01, 0x15, 0x26, 0x18, 0x7A, 0x0D, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x02, 0xF7, 0x14, 0x1F, 0x18, 0x7A, 0xDF, // "ĝ" (U+011D)
  0x01, 0x1E, 0x01, 0x01, 0x15, 0x25, 0x18, 0x7B, 0xD5, // "Ğ" (U+011E)
  0x01, 0x1F, 0x02, 0xF7, 0x14, 0x1E, 0x18, 0x7C, 0xA2, // "ğ" (U+011F)
  0x01, 0x20, 0x01, 0x01, 0x15, 0x25, 0x18, 0x7D, 0x93, // "Ġ" (U+0120)
  0x01, 0x21, 0x02, 0xF7, 0x14, 0x1E, 0x18, 0x7E, 0x51, // "ġ" (U+0121)
  0x01, 0x22, 0x01, 0xF8, 0x15, 0x1D, 0x18, 0x7F, 0x32, // "Ģ" (U+0122)
  0x01, 0x23, 0x02, 0xF7, 0x14, 0x1F, 0x18, 0x7F, 0xF4, // "ģ" (U+0123)
  0x01, 0x24, 0x02, 0x01, 0x15, 0x26, 0x18, 0x80, 0xD9, // "Ĥ" (U+0124)
  0x01, 0x25, 0xFE, 0x01, 0x14, 0x28, 0x18, 0x81, 0x9E, // "ĥ" (U+0125)
  0x01, 0x26, 0x00, 0x01, 0x17, 0x1D, 0x18, 0x82, 0x74, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x14, 0x1F, 0x18, 0x83, 0x22, // "ħ" (U+0127)
  0x01, 0x28, 0x04, 0x01, 0x13, 0x24, 0x18, 0x83, 0xCB, // "Ĩ" (U+0128)
  0x01, 0x29, 0x03, 0x01, 0x15, 0x1D, 0x18, 0x84, 0x59, // "ĩ" (U+0129)
  0x01, 0x2A, 0x04, 0x01, 0x13, 0x23, 0x18, 0x84, 0xCF, // "Ī" (U+012A)
  0x01, 0x2B, 0x03, 0x01, 0x15, 0x1C, 0x18, 0x85, 0x49, // "ī" (U+012B)
  0x01, 0x2C, 0x04, 0x01, 0x13, 0x25, 0x18, 0x85, 0xAB, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x03, 0x01, 0x15, 0x1E, 0x18, 0x86, 0x3B, // "ĭ" (U+012D)
  0x01, 0x2E, 0x04, 0xF8, 0x13, 0x1D, 0x18, 0x86, 0xB4, // "Į" (U+012E)
  0x01, 0x2F, 0x03, 0xF8, 0x15, 0x1F, 0x18, 0x87, 0x42, // "į" (U+012F)
  0x01, 0x30, 0x04, 0x01, 0x13, 0x25, 0x18, 0x87, 0xD2, // "İ" (U+0130)
  0x01, 0x31, 0x03, 0x01, 0x15, 0x16, 0x18, 0x88, 0x53, // "ı" (U+0131)
  0x01, 0x32, 0x04, 0x01, 0x13, 0x1D, 0x18, 0x88, 0xA7, // "Ĳ" (U+0132)
  0x01, 0x33, 0x04, 0xF7, 0x13, 0x1F, 0x18, 0x89, 0x19, // "ĳ" (U+0133)
  0x01, 0x34, 0x04, 0x01, 0x17, 0x26, 0x18, 0x89, 0xDF, // "Ĵ" (U+0134)
  0x01, 0x35, 0x02, 0xF7, 0x14, 0x1F, 0x18, 0x8A, 0x6E, // "ĵ" (U+0135)
  0x01, 0x36, 0x02, 0xF8, 0x15, 0x1D, 0x18, 0x8B, 0x22, // "Ķ" (U+0136)
  0x01, 0x37, 0x04, 0xF8, 0x16, 0x1F, 0x18, 0x8B, 0xF8, // "ķ" (U+0137)
  0x01, 0x38, 0x04, 0x01, 0x16, 0x16, 0x18, 0x8C, 0xC7, // "ĸ" (U+0138)
  0x01, 0x39, 0x04, 0x01, 0x14, 0x26, 0x18, 0x8D, 0x58, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x03, 0x01, 0x15, 0x28, 0x18, 0x8D, 0xDC, // "ĺ" (U+013A)
  0x01, 0x3B, 0x04, 0xF8, 0x14, 0x1D, 0x18, 0x8E, 0x79, // "Ļ" (U+013B)
  0x01, 0x3C, 0x03, 0xF8, 0x15, 0x1F, 0x18, 0x8E, 0xF8, // "ļ" (U+013C)
  0x01, 0x3D, 0x04, 0x01, 0x14, 0x1D, 0x18, 0x8F, 0x92, // "Ľ" (U+013D)
  0x01, 0x3E, 0x03, 0x01, 0x16, 0x1F, 0x18, 0x90, 0x07, // "ľ" (U+013E)
  0x01, 0x3F, 0x04, 0x01, 0x14, 0x1D, 0x18, 0x90, 0x97, // "Ŀ" (U+013F)
  0x01, 0x40, 0x03, 0x01, 0x1A, 0x1F, 0x18, 0x91, 0x09, // "ŀ" (U+0140)
  0x01, 0x41, 0x02, 0x01, 0x16, 0x1D, 0x18, 0x91, 0x9A, // "Ł" (U+0141)
  0x01, 0x42, 0x03, 0x01, 0x15, 0x1F, 0x18, 0x92, 0x1E, // "ł" (U+0142)
  0x01, 0x43, 0x02, 0x01, 0x15, 0x26, 0x18, 0x92, 0xAE, // "Ń" (U+0143)
  0x01, 0x44, 0x03, 0x01, 0x14, 0x1F, 0x18, 0x93, 0x97, // "ń" (U+0144)
  0x01, 0x45, 0x02, 0xF8, 0x15, 0x1D, 0x18, 0x94, 0x2E, // "Ņ" (U+0145)
  0x01, 0x46, 0x03, 0xF8, 0x14, 0x16, 0x18, 0x95, 0x13, // "ņ" (U+0146)
  0x01, 0x47, 0x02, 0x01, 0x15, 0x26, 0x18, 0x95, 0xA5, // "Ň" (U+0147)
  0x01, 0x48, 0x03, 0x01, 0x14, 0x1F, 0x18, 0x96, 0x9C, // "ň" (U+0148)
  0x01, 0x49, 0xFE, 0x01, 0x14, 0x1D, 0x18, 0x97, 0x42, // "ŉ" (U+0149)
  0x01, 0x4A, 0x02, 0xF9, 0x15, 0x1D, 0x18, 0x97, 0xEA, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x03, 0xF7, 0x14, 0x16, 0x18, 0x98, 0xDB, // "ŋ" (U+014B)
  0x01, 0x4C, 0x01, 0x01, 0x16, 0x23, 0x18, 0x99, 0x7A, // "Ō" (U+014C)
  0x01, 0x4D, 0x02, 0x01, 0x15, 0x1C, 0x18, 0x9A, 0x45, // "ō" (U+014D)
  0x01, 0x4E, 0x01, 0x01, 0x16, 0x25, 0x18, 0x9A, 0xDE, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x02, 0x01, 0x15, 0x1E, 0x18, 0x9B, 0xC0, // "ŏ" (U+014F)
  0x01, 0x50, 0x01, 0x01, 0x16, 0x25, 0x18, 0x9C, 0x6F, // "Ő" (U+0150)
  0x01, 0x51, 0x02, 0x01, 0x15, 0x1E, 0x18, 0x9D, 0x59, // "ő" (U+0151)
  0x01, 0x52, 0x01, 0x01, 0x16, 0x1D, 0x18, 0x9E, 0x10, // "Œ" (U+0152)
  0x01, 0x53, 0x00, 0x01, 0x17, 0x16, 0x18, 0x9E, 0xC3, // "œ" (U+0153)
  0x01, 0x54, 0x03, 0x01, 0x16, 0x26, 0x18, 0x9F, 0x70, // "Ŕ" (U+0154)
  0x01, 0x55, 0x02, 0x01, 0x16, 0x1F, 0x18, 0xA0, 0x3F, // "ŕ" (U+0155)
  0x01, 0x56, 0x03, 0xF8, 0x16, 0x1D, 0x18, 0xA0, 0xBE, // "Ŗ" (U+0156)
  0x01, 0x57, 0x02, 0xF8, 0x16, 0x16, 0x18, 0xA1, 0x8A, // "ŗ" (U+0157)
  0x01, 0x58, 0x03, 0x01, 0x16, 0x26, 0x18, 0xA2, 0x04, // "Ř" (U+0158)
  0x01, 0x59, 0x02, 0x01, 0x16, 0x1F, 0x18, 0xA2, 0xE1, // "ř" (U+0159)
  0x01, 0x5A, 0x03, 0x01, 0x15, 0x26, 0x18, 0xA3, 0x6E, // "Ś" (U+015A)
  0x01, 0x5B, 0x04, 0x01, 0x13, 0x1F, 0x18, 0xA4, 0x1A, // "ś" (U+015B)
  0x01, 0x5C, 0x03, 0x01, 0x15, 0x26, 0x18, 0xA4, 0xA4, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x04, 0x01, 0x13, 0x1F, 0x18, 0xA5, 0x5D, // "ŝ" (U+015D)
  0x01, 0x5E, 0x03, 0xF7, 0x15, 0x1D, 0x18, 0xA5, 0xF2, // "Ş" (U+015E)
  0x01, 0x5F, 0x04, 0xF7, 0x13, 0x16, 0x18, 0xA6, 0xAD, // "ş" (U+015F)
  0x01, 0x60, 0x03, 0x01, 0x15, 0x26, 0x18, 0xA7, 0x44, // "Š" (U+0160)
  0x01, 0x61, 0x04, 0x01, 0x13, 0x1F, 0x18, 0xA7, 0xFF, // "š" (U+0161)
  0x01, 0x62, 0x01, 0xF7, 0x16, 0x1D, 0x18, 0xA8, 0x98, // "Ţ" (U+0162)
  0x01, 0x63, 0x02, 0xF7, 0x14, 0x1C, 0x18, 0xA9, 0x3B, // "ţ" (U+0163)
  0x01, 0x64, 0x01, 0x01, 0x16, 0x26, 0x18, 0xA9, 0xE0, // "Ť" (U+0164)
  0x01, 0x65, 0x02, 0x01, 0x14, 0x1F, 0x18, 0xAA, 0x84, // "ť" (U+0165)
  0x01, 0x66, 0x01, 0x01, 0x16, 0x1D, 0x18, 0xAB, 0x0E, // "Ŧ" (U+0166)
  0x01, 0x67, 0x02, 0x01, 0x14, 0x1C, 0x18, 0xAB, 0x86, // "ŧ" (U+0167)
  0x01, 0x68, 0x02, 0x01, 0x15, 0x24, 0x18, 0xAC, 0x00, // "Ũ" (U+0168)
  0x01, 0x69, 0x03, 0x01, 0x14, 0x1D, 0x18, 0xAC, 0xCA, // "ũ" (U+0169)
  0x01, 0x6A, 0x02, 0x01, 0x15, 0x23, 0x18, 0xAD, 0x68, // "Ū" (U+016A)
  0x01, 0x6B, 0x03, 0x01, 0x14, 0x1C, 0x18, 0xAE, 0x1F, // "ū" (U+016B)
  0x01, 0x6C, 0x02, 0x01, 0x15, 0x25, 0x18, 0xAE, 0xA9, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x03, 0x01, 0x14, 0x1E, 0x18, 0xAF, 0x77, // "ŭ" (U+016D)
  0x01, 0x6E, 0x02, 0x01, 0x15, 0x27, 0x18, 0xB0, 0x17, // "Ů" (U+016E)
  0x01, 0x6F, 0x03, 0x01, 0x14, 0x20, 0x18, 0xB0, 0xEE, // "ů" (U+016F)
  0x01, 0x70, 0x02, 0x01, 0x15, 0x25, 0x18, 0xB1, 0x98, // "Ű" (U+0170)
  0x01, 0x71, 0x03, 0x01, 0x14, 0x1E, 0x18, 0xB2, 0x6E, // "ű" (U+0171)
  0x01, 0x72, 0x02, 0xF8, 0x15, 0x1D, 0x18, 0xB3, 0x16, // "Ų" (U+0172)
  0x01, 0x73, 0x03, 0xF8, 0x15, 0x16, 0x18, 0xB3, 0xE5, // "ų" (U+0173)
  0x01, 0x74, 0x01, 0x01, 0x16, 0x26, 0x18, 0xB4, 0x8F, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x17, 0x1F, 0x18, 0xB5, 0xAF, // "ŵ" (U+0175)
  0x01, 0x76, 0x01, 0x01, 0x16, 0x26, 0x18, 0xB6, 0x9D, // "Ŷ" (U+0176)
  0x01, 0x77, 0x02, 0xF7, 0x15, 0x1F, 0x18, 0xB7, 0x62, // "ŷ" (U+0177)
  0x01, 0x78, 0x01, 0x01, 0x16, 0x25, 0x18, 0xB8, 0x3A, // "Ÿ" (U+0178)
  0x01, 0x79, 0x03, 0x01, 0x14, 0x26, 0x18, 0xB8, 0xF9, // "Ź" (U+0179)
  0x01, 0x7A, 0x03, 0x01, 0x14, 0x1F, 0x18, 0xB9, 0x84, // "ź" (U+017A)
  0x01, 0x7B, 0x03, 0x01, 0x14, 0x25, 0x18, 0xB9, 0xFA, // "Ż" (U+017B)
  0x01, 0x7C, 0x03, 0x01, 0x14, 0x1E, 0x18, 0xBA, 0x7C, // "ż" (U+017C)
  0x01, 0x7D, 0x03, 0x01, 0x14, 0x26, 0x18, 0xBA, 0xEA, // "Ž" (U+017D)
  0x01, 0x7E, 0x03, 0x01, 0x14, 0x1F, 0x18, 0xBB, 0x84, // "ž" (U+017E)
  0x01, 0x7F, 0x08, 0x01, 0x15, 0x1F, 0x18, 0xBC, 0x09, // "ſ" (U+017F)
  0x03, 0xA9, 0x00, 0x01, 0x17, 0x1D, 0x18, 0xBC, 0x7E, // "Ω" (U+03A9)
  0x03, 0xBC, 0x03, 0xF7, 0x14, 0x16, 0x18, 0xBD, 0x3C, // "μ" (U+03BC)
  0x03, 0xC0, 0x01, 0x01, 0x16, 0x16, 0x18, 0xBD, 0xCB, // "π" (U+03C0)
  0x20, 0x13, 0x04, 0x0A, 0x13, 0x0C, 0x18, 0xBE, 0x59, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x0A, 0x17, 0x0C, 0x18, 0xBE, 0x5E, // "—" (U+2014)
  0x20, 0xAC, 0x01, 0x01, 0x16, 0x1D, 0x18, 0xBE, 0x63, // "€" (U+20AC)
  0x20, 0xBF, 0x03, 0xFD, 0x15, 0x21, 0x18, 0xBE, 0xF8, // "₿" (U+20BF)
  0x20, 0x18, 0x49, 0x14, 0x0E, 0x1D, 0x18, 0xBF, 0xDB, // "‘" (U+2018)
  0x20, 0x19, 0x08, 0x14, 0x0E, 0x1D, 0x18, 0xBF, 0xF9, // "’" (U+2019)
  0x20, 0x1A, 0x08, 0xFB, 0x0F, 0x05, 0x18, 0xC0, 0x16, // "‚" (U+201A)
  0x20, 0x1B, 0x09, 0x14, 0x0E, 0x1D, 0x18, 0xC0, 0x37, // "‛" (U+201B)
  0x20, 0x1C, 0x05, 0x14, 0x12, 0x1D, 0x18, 0xC0, 0x54, // "“" (U+201C)
  0x20, 0x1D, 0x05, 0x13, 0x12, 0x1C, 0x18, 0xC0, 0x8F, // "”" (U+201D)
  0x20, 0x1E, 0x05, 0xFB, 0x14, 0x05, 0x18, 0xC0, 0xCA, // "„" (U+201E)
  0x20, 0x1F, 0x05, 0x13, 0x12, 0x1C, 0x18, 0xC1, 0x0B, // "‟" (U+201F)
  0x20, 0x20, 0x04, 0x01, 0x13, 0x1F, 0x18, 0xC1, 0x45, // "†" (U+2020)
  0x20, 0x21, 0x04, 0x01, 0x13, 0x1F, 0x18, 0xC1, 0xB8, // "‡" (U+2021)
  0x20, 0x22, 0x07, 0x0B, 0x10, 0x14, 0x18, 0xC2, 0x3C, // "•" (U+2022)
  0x20, 0x26, 0x01, 0x01, 0x16, 0x05, 0x18, 0xC2, 0x5E, // "…" (U+2026)
  0x20, 0x30, 0x00, 0x01, 0x17, 0x1D, 0x18, 0xC2, 0x8D, // "‰" (U+2030)
  0x20, 0x39, 0x07, 0x03, 0x10, 0x13, 0x18, 0xC3, 0x7D, // "‹" (U+2039)
  0x20, 0x3A, 0x07, 0x04, 0x10, 0x14, 0x18, 0xC3, 0xB8, // "›" (U+203A)
  0x20, 0x44, 0xF8, 0x01, 0x07, 0x1D, 0x00, 0xC3, 0xF3, // "⁄" (U+2044)
  0x21, 0x22, 0xFF, 0x0F, 0x17, 0x1D, 0x18, 0xC4, 0x5B, // "™" (U+2122)
  0x21, 0x52, 0x0A, 0x00, 0x3E, 0x1D, 0x48, 0xC4, 0xF5, // "⅒" (U+2152)
  0x22, 0x02, 0x02, 0x01, 0x15, 0x1D, 0x18, 0xC6, 0x71, // "∂" (U+2202)
  0x22, 0x06, 0x00, 0x01, 0x17, 0x1D, 0x18, 0xC7, 0x1E, // "∆" (U+2206)
  0x22, 0x1A, 0x00, 0x01, 0x17, 0x22, 0x18, 0xC7, 0xC9, // "√" (U+221A)
  0x22, 0x1E, 0x00, 0x09, 0x17, 0x15, 0x18, 0xC8, 0x73, // "∞" (U+221E)
  0x22, 0x48, 0x02, 0x09, 0x15, 0x15, 0x18, 0xC8, 0xEB, // "≈" (U+2248)
  0x22, 0x60, 0x02, 0x04, 0x15, 0x1A, 0x18, 0xC9, 0x39, // "≠" (U+2260)
  0x22, 0x64, 0x02, 0x01, 0x15, 0x19, 0x18, 0xC9, 0x91, // "≤" (U+2264)
  0x22, 0x65, 0x02, 0x01, 0x15, 0x19, 0x18, 0xCA, 0x04, // "≥" (U+2265)
  
  // Kerning pairs
  
  // Glyph data
  // "!" (U+0021)
  0x02, 0xC0, 0x20, 0x1C, 0x02, 0x01, 0xC0, 0x11, 0xC0, 0x11, 0xC0, 0x11, 0xC2, 0x0E, 0xB2, 0x0E,
  0xB2, 0x0D, 0xA0, 0xE2, 0x0D, 0xA0, 0xE2, 0x0D, 0xA0, 0xD2, 0x0C, 0xA0, 0xD2, 0x0C, 0xA0, 0xC2,
  0x0B, 0xA0, 0xC2, 0x0B, 0xA0, 0xB2, 0x0A, 0xA0, 0xB2, 0x0A, 0xA0, 0xA2, 0x09, 0xA0, 0xA2, 0x09,
  0xA0, 0x92, 0x08, 0xA0, 0x92, 0x08, 0xA0, 0x87, 0x76, 0x84, 0x8E, 0xE8, 0x04, 0xC0, 0x40, 0x6C,
  0x06, 0x04, 0xC8, 0x44, 0x08, 0xEE, 0x81,
  // """ (U+0022)
  0x08, 0xB0, 0x22, 0x02, 0xB0, 0x80, 0x7B, 0x01, 0x20, 0x1B, 0x07, 0x06, 0xB4, 0xB0, 0x60, 0x4A,
  0x0E, 0x40, 0xEA, 0x04, 0x03, 0xA0, 0xD4, 0x0D, 0xA0, 0x30, 0x2A, 0x0B, 0x40, 0xBA, 0x02, 0x01,
  0xA0, 0xA4, 0x0A, 0xA0, 0x11, 0xA0, 0x94, 0x09, 0xA2, 0x81, 0xEF, 0x84, 0x81, 0x8F, 0xE2, 0x81,
  0xDF, 0x64, 0x81, 0x6F, 0xD1,
  // "#" (U+0023)
  0x72, 0x0A, 0xA0, 0x34, 0x81, 0xCF, 0xE7, 0x60, 0xCA, 0x5A, 0x0C, 0x76, 0xA0, 0xD4, 0x02, 0xA0,
  0x97, 0x50, 0x2A, 0x0A, 0x40, 0x5A, 0x06, 0x75, 0x05, 0xA0, 0x74, 0x08, 0xA0, 0x37, 0x50, 0x8A,
  0x05, 0x40, 0xAA, 0x01, 0x75, 0x0B, 0xA0, 0x24, 0x81, 0xDF, 0xD7, 0x60, 0xDA, 0x5A, 0x0A, 0x75,
  0x01, 0xA0, 0xC4, 0x03, 0xA0, 0x87, 0x0B, 0xFF, 0xE0, 0x32, 0x0B, 0xFF, 0xE0, 0x32, 0x0A, 0x80,
  0x0E, 0xB8, 0x01, 0xEB, 0x80, 0x1E, 0x02, 0x70, 0xBA, 0x5A, 0x0C, 0x76, 0x81, 0xEF, 0xD4, 0x03,
  0xA0, 0x97, 0x50, 0x2A, 0x09, 0x40, 0x6A, 0x06, 0x75, 0x06, 0xA0, 0x64, 0x0A, 0xA0, 0x37, 0x50,
  0x9A, 0x03, 0x40, 0xDA, 0x76, 0x0C, 0xA5, 0xA0, 0xC7, 0x03, 0xFF, 0xE0, 0xD2, 0x03, 0xFF, 0xE0,
  0xD2, 0x02, 0x80, 0x0E, 0xB8, 0x01, 0xEB, 0x80, 0x1E, 0x0C, 0x70, 0x8A, 0x04, 0x40, 0xCA, 0x76,
  0x0B, 0xA0, 0x14, 0xA0, 0xD7, 0x68, 0x1E, 0xFE, 0x40, 0x3A, 0x09, 0x75, 0x01, 0xA0, 0xB4, 0x06,
  0xA0, 0x67, 0x50, 0x4A, 0x08, 0x40, 0x9A, 0x03, 0x75, 0x07, 0xA0, 0x54, 0x0C, 0xA7, 0x60, 0xAA,
  0x02, 0x4A, 0x0C, 0x76, 0x81, 0xDF, 0xE4, 0x03, 0xA0, 0x97, 0x20,
  // "$" (U+0024)
  0x70, 0x7A, 0x01, 0x77, 0x07, 0xA0, 0x17, 0x70, 0x7A, 0x02, 0x74, 0x81, 0x6B, 0xED, 0x81, 0xDA,
  0x55, 0x04, 0x0E, 0xFD, 0x07, 0x20, 0x4F, 0xF0, 0x42, 0x0E, 0xB8, 0x18, 0x27, 0xA8, 0x41, 0x25,
  0x9E, 0xE2, 0x06, 0xB0, 0x62, 0x07, 0xA0, 0x14, 0x02, 0x20, 0xAA, 0x0D, 0x30, 0x7A, 0x01, 0x70,
  0xBA, 0x0A, 0x30, 0x7A, 0x01, 0x70, 0xBA, 0x0B, 0x30, 0x7A, 0x01, 0x70, 0x9A, 0x0E, 0x01, 0x20,
  0x7A, 0x01, 0x70, 0x4B, 0x82, 0xB1, 0x07, 0xA0, 0x17, 0x10, 0xCB, 0x81, 0xE9, 0xAA, 0x01, 0x71,
  0x01, 0x0D, 0xF0, 0x47, 0x30, 0x8F, 0x81, 0xD8, 0x27, 0x18, 0x12, 0x9E, 0xF0, 0x90, 0x17, 0x20,
  0x9F, 0x0E, 0x02, 0x71, 0x07, 0xA8, 0x15, 0x9E, 0xB0, 0xD7, 0x10, 0x7A, 0x82, 0x10, 0x1B, 0xB0,
  0x57, 0x07, 0xA0, 0x13, 0x0E, 0xA0, 0x97, 0x07, 0xA0, 0x13, 0x0B, 0xA0, 0xB7, 0x07, 0xA0, 0x13,
  0x0A, 0xA0, 0xB7, 0x07, 0xA0, 0x13, 0x0E, 0xA8, 0x19, 0x32, 0x50, 0x7A, 0x01, 0x20, 0x9B, 0x87,
  0x46, 0xFC, 0x84, 0x10, 0x7A, 0x81, 0x46, 0xCB, 0x81, 0xA0, 0x6F, 0xF0, 0xC2, 0x05, 0xFD, 0x0E,
  0x07, 0x48, 0x41, 0x69, 0xCE, 0xEB, 0x81, 0xC9, 0x57, 0x50, 0x7A, 0x01, 0x77, 0x07, 0xA0, 0x17,
  0x70, 0x7A, 0x01, 0x77, 0x07, 0xA0, 0x17,
  // "%" (U+0025)
  0x28, 0x51, 0x8D, 0xFE, 0xA3, 0x71, 0x0A, 0xA0, 0x64, 0x03, 0x0E, 0xE0, 0x76, 0x02, 0xA0, 0xD5,
  0x0D, 0xF9, 0x04, 0x50, 0xAA, 0x06, 0x40, 0x6A, 0x83, 0xE4, 0x01, 0xAA, 0x0C, 0x40, 0x2A, 0x0D,
  0x50, 0xBA, 0x05, 0x40, 0xEA, 0x02, 0x30, 0xAA, 0x06, 0x50, 0xEA, 0x01, 0x40, 0xAA, 0x05, 0x20,
  0x2A, 0x0E, 0x6B, 0x50, 0x9A, 0x06, 0x20, 0x9A, 0x07, 0x6B, 0x50, 0x9A, 0x81, 0x60, 0x2A, 0x0E,
  0x70, 0xDA, 0x01, 0x40, 0xAA, 0x81, 0x50, 0x9A, 0x07, 0x70, 0xAA, 0x06, 0x40, 0xEA, 0x02, 0x01,
  0xA0, 0xE7, 0x10, 0x5A, 0x83, 0xE5, 0x02, 0xBA, 0x81, 0xC0, 0x9A, 0x07, 0x72, 0x0C, 0xF9, 0x04,
  0x01, 0xA0, 0xE7, 0x30, 0x10, 0xDE, 0x81, 0x70, 0x9A, 0x07, 0x75, 0x86, 0x7C, 0xED, 0xA3, 0x01,
  0xA0, 0xE0, 0x17, 0x75, 0x08, 0xA0, 0x87, 0x75, 0x89, 0x21, 0xEF, 0xE1, 0x03, 0xAD, 0xEC, 0x77,
  0x50, 0x8A, 0x81, 0x80, 0x7E, 0x0D, 0x01, 0x72, 0x84, 0x1E, 0xFE, 0x15, 0xF9, 0x0C, 0x72, 0x08,
  0xA8, 0x18, 0x0C, 0xA8, 0x3A, 0x20, 0x4E, 0xA0, 0x57, 0x01, 0x0E, 0xA0, 0x10, 0x2A, 0x0E, 0x40,
  0x7A, 0x0A, 0x70, 0x7A, 0x81, 0x80, 0x5A, 0x0A, 0x40, 0x2A, 0x0D, 0x60, 0x10, 0xEA, 0x81, 0x10,
  0x6A, 0x08, 0x5B, 0x60, 0x7A, 0x09, 0x20, 0x6A, 0x08, 0x5B, 0x60, 0xEA, 0x01, 0x20, 0x5A, 0x08,
  0x5A, 0x0D, 0x50, 0x7A, 0x09, 0x30, 0x2A, 0x0B, 0x40, 0x3A, 0x0B, 0x50, 0xEA, 0x02, 0x40, 0xCA,
  0x01, 0x30, 0x8A, 0x06, 0x40, 0x7A, 0x09, 0x50, 0x4A, 0x82, 0xC4, 0x27, 0xA0, 0xD5, 0x0E, 0xA0,
  0x26, 0x07, 0xE0, 0xE0, 0x24, 0x06, 0xA0, 0xA7, 0x18, 0x53, 0xAE, 0xFD, 0x81, 0x20,
  // "&" (U+0026)
  0x58, 0x62, 0x9D, 0xEE, 0xC8, 0x17, 0x60, 0x40, 0xEE, 0x0E, 0x03, 0x74, 0x02, 0x0E, 0xF9, 0x0E,
  0x01, 0x73, 0x09, 0xB0, 0x62, 0x06, 0xB0, 0x87, 0x30, 0xEA, 0x08, 0x40, 0x9A, 0x0C, 0x73, 0xB0,
  0x44, 0x05, 0xA0, 0xE7, 0x3B, 0x04, 0x40, 0x5A, 0x0D, 0x73, 0x0D, 0xA0, 0x64, 0x08, 0xA0, 0xB7,
  0x30, 0x9A, 0x0A, 0x30, 0x10, 0xEA, 0x06, 0x73, 0x04, 0xB0, 0x12, 0x0B, 0xA0, 0xD7, 0x50, 0xCA,
  0x81, 0x90, 0xAB, 0x04, 0x75, 0x04, 0xB0, 0xCB, 0x06, 0x77, 0x0A, 0xD0, 0x67, 0x71, 0x08, 0xC0,
  0x57, 0x71, 0x09, 0xD0, 0x97, 0x70, 0xBB, 0x0E, 0xB0, 0x65, 0x08, 0xA0, 0xB3, 0x0A, 0xB8, 0x1A,
  0x0B, 0xB0, 0x34, 0x0B, 0xA0, 0x82, 0x04, 0xB0, 0xB2, 0x01, 0x0D, 0xA0, 0xE0, 0x22, 0x01, 0xB0,
  0x42, 0x0C, 0xA0, 0xD0, 0x13, 0x02, 0x0E, 0xA0, 0xC2, 0x06, 0xA0, 0xE2, 0x02, 0xB0, 0x65, 0x05,
  0xB8, 0x1A, 0x0D, 0xA0, 0x92, 0x05, 0xB0, 0x16, 0x08, 0xB0, 0xBB, 0x02, 0x20, 0x6B, 0x71, 0x0B,
  0xD0, 0xB3, 0x05, 0xB0, 0x17, 0x01, 0x0D, 0xC0, 0x23, 0x03, 0xB0, 0x57, 0x10, 0x8B, 0x0E, 0x01,
  0x40, 0xEA, 0x0D, 0x01, 0x60, 0x8D, 0x0B, 0x40, 0x8B, 0x0D, 0x04, 0x28, 0x11, 0x5D, 0xF0, 0x84,
  0x0C, 0xFC, 0x81, 0xB1, 0xCB, 0x04, 0x30, 0x10, 0xBF, 0x90, 0xE0, 0x62, 0x02, 0x0E, 0xA0, 0xE0,
  0x24, 0x86, 0x5A, 0xDF, 0xED, 0xA5, 0x50, 0x6B, 0x0C,
  // "'" (U+0027)
  0xDF, 0xFC, 0xCF, 0xFB, 0xBF, 0xFA, 0xAF, 0xF9, 0x8F, 0xF7, 0x7F, 0xF6, 0x6F, 0xF5, 0x5F, 0xF4,
  0x3F, 0xF3, 0x2F, 0xF1,
  // "(" (U+0028)
  0x50, 0x7A, 0x0C, 0x40, 0x4B, 0x03, 0x40, 0xDA, 0x08, 0x40, 0x8A, 0x0E, 0x01, 0x30, 0x10, 0xEA,
  0x07, 0x40, 0x8B, 0x01, 0x40, 0xEA, 0x09, 0x40, 0x4B, 0x04, 0x40, 0xAA, 0x0E, 0x50, 0xEA, 0x0A,
  0x40, 0x2B, 0x06, 0x40, 0x6B, 0x02, 0x40, 0x8B, 0x50, 0xBA, 0x0D, 0x50, 0xCA, 0x0B, 0x50, 0xEA,
  0x09, 0x50, 0xEA, 0x09, 0x5B, 0x08, 0x5B, 0x09, 0x50, 0xEA, 0x09, 0x50, 0xDA, 0x0B, 0x50, 0xBA,
  0x0C, 0x50, 0x9A, 0x0E, 0x50, 0x6B, 0x02, 0x40, 0x3B, 0x05, 0x50, 0xEA, 0x09, 0x50, 0xBA, 0x0E,
  0x50, 0x6B, 0x03, 0x50, 0xEA, 0x09, 0x50, 0x9A, 0x0E, 0x01, 0x40, 0x1B, 0x07, 0x50, 0x8A, 0x0E,
  0x01, 0x50, 0xDA, 0x08, 0x50, 0x4B, 0x02, 0x50, 0x7A, 0x0C,
  // ")" (U+0029)
  0x0C, 0xA0, 0x75, 0x02, 0xB0, 0x45, 0x08, 0xA0, 0xD5, 0x01, 0x0E, 0xA0, 0x85, 0x07, 0xB0, 0x14,
  0x01, 0x0E, 0xA0, 0x95, 0x09, 0xA0, 0xE5, 0x04, 0xB0, 0x55, 0x0E, 0xA0, 0xA5, 0x0A, 0xA0, 0xE5,
  0x05, 0xB0, 0x34, 0x02, 0xB0, 0x65, 0x0E, 0xA0, 0x95, 0x0D, 0xA0, 0xB5, 0x0B, 0xA0, 0xD5, 0x09,
  0xA0, 0xE5, 0x09, 0xB5, 0x08, 0xB5, 0x09, 0xA0, 0xE5, 0x0A, 0xA0, 0xE5, 0x0B, 0xA0, 0xC5, 0x0D,
  0xA0, 0xB5, 0xB0, 0x84, 0x02, 0xB0, 0x64, 0x06, 0xB0, 0x24, 0x0A, 0xA0, 0xE5, 0x0E, 0xA0, 0xA4,
  0x04, 0xB0, 0x44, 0x09, 0xA0, 0xE4, 0x01, 0x0E, 0xA0, 0x84, 0x07, 0xA0, 0xE0, 0x13, 0x01, 0x0E,
  0xA0, 0x84, 0x08, 0xA0, 0xD4, 0x03, 0xB0, 0x44, 0x0C, 0xA0, 0x75,
  // "*" (U+002A)
  0x70, 0x8A, 0x08, 0x77, 0x07, 0xA0, 0x77, 0x70, 0x6A, 0x06, 0x77, 0x05, 0xA0, 0x57, 0x70, 0x3A,
  0x03, 0x71, 0x07, 0x04, 0x40, 0x2A, 0x02, 0x38, 0x11, 0x59, 0x2B, 0x82, 0xB7, 0x31, 0xA8, 0x22,
  0x48, 0xCB, 0x02, 0x03, 0xFF, 0xA8, 0x45, 0x28, 0xAC, 0xEF, 0xA8, 0x2E, 0xCA, 0x46, 0x05, 0xC0,
  0x70, 0x27, 0x48, 0x5D, 0xFD, 0xDF, 0xD1, 0x73, 0x0A, 0xA0, 0x06, 0xA0, 0xB7, 0x20, 0x7A, 0x0D,
  0x20, 0xDA, 0x08, 0x70, 0x3B, 0x05, 0x20, 0x5B, 0x05, 0x60, 0xDA, 0x0D, 0x40, 0xDA, 0x0E, 0x01,
  0x58, 0x22, 0xBF, 0x54, 0x82, 0x5F, 0xC3, 0x71, 0x04, 0x60, 0x55,
  // "+" (U+002B)
  0x70, 0x6A, 0x07, 0x77, 0x06, 0xA0, 0x77, 0x70, 0x6A, 0x07, 0x77, 0x06, 0xA0, 0x77, 0x70, 0x6A,
  0x07, 0x77, 0x06, 0xA0, 0x77, 0x70, 0x6A, 0x07, 0x77, 0x06, 0xA0, 0x77, 0x0B, 0x80, 0x3E, 0xB8,
  0x02, 0xE0, 0xB0, 0xCF, 0xFA, 0x00, 0xCF, 0xFA, 0x0C, 0x70, 0x6A, 0x07, 0x77, 0x06, 0xA0, 0x77,
  0x70, 0x6A, 0x07, 0x77, 0x06, 0xA0, 0x77, 0x70, 0x6A, 0x07, 0x77, 0x06, 0xA0, 0x77, 0x70, 0x6A,
  0x07, 0x77, 0x06, 0xA0, 0x77,
  // "," (U+002C)
  0x20, 0x7C, 0x01, 0x20, 0x9B, 0x0E, 0x30, 0xCB, 0x09, 0x3C, 0x04, 0x20, 0x2B, 0x0E, 0x30, 0x5B,
  0x09, 0x30, 0x8B, 0x03, 0x30, 0xCA, 0x0D, 0x4B, 0x07, 0x30, 0x3A, 0x0E, 0x01, 0x30, 0x7A, 0x09,
  0x40,
  // "-" (U+002D)
  0x80, 0x90, 0xEF, 0xFF, 0xB0,
  // "." (U+002E)
  0x08, 0xEE, 0x80, 0x4F, 0xFF, 0xF4, 0x6F, 0xFF, 0xF6, 0x4F, 0xFF, 0xF4, 0x08, 0xEE, 0x80,
  // "/" (U+002F)
  0x73, 0x06, 0xA0, 0xE7, 0x30, 0xCA, 0x09, 0x72, 0x02, 0xB0, 0x37, 0x20, 0x8A, 0x0D, 0x73, 0x0E,
  0xA0, 0x77, 0x20, 0x4B, 0x01, 0x72, 0x0A, 0xA0, 0xB7, 0x20, 0x1B, 0x05, 0x72, 0x07, 0xA0, 0xE7,
  0x30, 0xCA, 0x09, 0x72, 0x03, 0xB0, 0x37, 0x20, 0x9A, 0x0D, 0x73, 0x0E, 0xA0, 0x77, 0x20, 0x5B,
  0x01, 0x72, 0x0B, 0xA0, 0xB7, 0x20, 0x1B, 0x05, 0x72, 0x07, 0xA0, 0xE7, 0x30, 0xDA, 0x09, 0x72,
  0x03, 0xB0, 0x37, 0x20, 0x9A, 0x0C, 0x73, 0x0E, 0xA0, 0x67, 0x20, 0x5B, 0x01, 0x72, 0x0B, 0xA0,
  0xA7, 0x20, 0x1B, 0x04, 0x72, 0x07, 0xA0, 0xE7, 0x30, 0xDA, 0x08, 0x72, 0x04, 0xB0, 0x27, 0x20,
  0x9A, 0x0C, 0x73, 0x0E, 0xA0, 0x67, 0x30,
  // "0" (U+0030)
  0x68, 0x66, 0xBD, 0xFE, 0xDA, 0x57, 0x30, 0x50, 0xEF, 0x90, 0xD0, 0x37, 0x05, 0xFD, 0x04, 0x50,
  0x3C, 0x07, 0x02, 0x20, 0x30, 0x9B, 0x0E, 0x01, 0x40, 0xBA, 0x0E, 0x03, 0x60, 0x7B, 0x09, 0x30,
  0x3B, 0x06, 0x70, 0xAC, 0x02, 0x20, 0x9A, 0x0E, 0x70, 0x3D, 0x07, 0x20, 0xDA, 0x08, 0x70, 0xCD,
  0x81, 0xB0, 0x1B, 0x05, 0x60, 0x7B, 0x07, 0xB1, 0x03, 0xB0, 0x15, 0x01, 0x0E, 0xA0, 0x91, 0xB0,
  0x20, 0x5B, 0x60, 0x9A, 0x82, 0xE1, 0x0D, 0xA0, 0x50, 0x7A, 0x0D, 0x50, 0x3B, 0x05, 0x20, 0xCA,
  0x07, 0x08, 0xA0, 0xC5, 0x0C, 0xA0, 0xC3, 0x0B, 0xA0, 0x70, 0x8A, 0x0C, 0x40, 0x6B, 0x03, 0x30,
  0xAA, 0x08, 0x09, 0xA0, 0xC3, 0x01, 0x0E, 0xA0, 0x94, 0x0A, 0xA0, 0x90, 0x8A, 0x0C, 0x30, 0x9A,
  0x0E, 0x01, 0x40, 0xAA, 0x08, 0x07, 0xA0, 0xD2, 0x03, 0xB0, 0x65, 0x0B, 0xA0, 0x80, 0x7A, 0x0D,
  0x20, 0xCA, 0x0C, 0x60, 0xBA, 0x07, 0x05, 0xB1, 0x06, 0xB0, 0x36, 0x0D, 0xA0, 0x50, 0x2B, 0x02,
  0x0E, 0xA0, 0x97, 0xB0, 0x31, 0xB0, 0xDA, 0x0E, 0x01, 0x60, 0x3B, 0x20, 0xBD, 0x06, 0x70, 0x7A,
  0x0C, 0x20, 0x7C, 0x0C, 0x71, 0x0D, 0xA0, 0x82, 0x01, 0xC0, 0x37, 0x05, 0xB0, 0x33, 0x09, 0xB0,
  0x36, 0x03, 0x0E, 0xA0, 0xB4, 0x01, 0x0E, 0xB0, 0x70, 0x22, 0x02, 0x08, 0xB0, 0xE0, 0x25, 0x04,
  0xFD, 0x05, 0x70, 0x30, 0xDF, 0x90, 0xD0, 0x47, 0x38, 0x65, 0xAD, 0xEF, 0xDA, 0x66,
  // "1" (U+0031)
  0x60, 0x40, 0xCA, 0x0B, 0x73, 0x03, 0x0B, 0xC0, 0xB7, 0x10, 0x20, 0xAE, 0x0B, 0x60, 0x10, 0x8F,
  0x90, 0xB6, 0x0D, 0xC8, 0x1E, 0x78, 0xA0, 0xB6, 0x07, 0xA0, 0xE0, 0x72, 0x08, 0xA0, 0xB7, 0x0C,
  0x07, 0x40, 0x9A, 0x0B, 0x76, 0x09, 0xA0, 0xB7, 0x60, 0xAA, 0x0B, 0x76, 0x0A, 0xA0, 0xB7, 0x60,
  0xAA, 0x0B, 0x76, 0x0A, 0xA0, 0xB7, 0x60, 0xAA, 0x0B, 0x76, 0x0A, 0xA0, 0xB7, 0x60, 0xAA, 0x0B,
  0x76, 0x0A, 0xA0, 0xB7, 0x60, 0xAA, 0x0B, 0x76, 0x0A, 0xA0, 0xB7, 0x60, 0xAA, 0x0B, 0x76, 0x0A,
  0xA0, 0xB7, 0x60, 0xAA, 0x0B, 0x76, 0x0A, 0xA0, 0xB7, 0x60, 0xAA, 0x0B, 0x76, 0x0A, 0xA0, 0xB7,
  0x60, 0xAA, 0x0B, 0x76, 0x0A, 0xA0, 0xB7, 0x06, 0x80, 0x19, 0x0D, 0xA0, 0xE8, 0x01, 0x98, 0x17,
  0x0A, 0xFF, 0x81, 0xC0, 0xAF, 0xF0, 0xC0,
  // "2" (U+0032)
  0x58, 0x73, 0x8C, 0xDF, 0xED, 0xA5, 0x72, 0x05, 0x0D, 0xFA, 0x0D, 0x04, 0x50, 0x10, 0xBF, 0xE0,
  0x54, 0x0A, 0xC8, 0x19, 0x41, 0x20, 0x30, 0x9C, 0x02, 0x38, 0x31, 0xDF, 0xB2, 0x70, 0x5B, 0x09,
  0x40, 0x20, 0x67, 0x30, 0xBA, 0x0E, 0x77, 0x20, 0x7B, 0x02, 0x77, 0x10, 0x5B, 0x03, 0x77, 0x10,
  0x5B, 0x03, 0x77, 0x10, 0x7B, 0x02, 0x77, 0x10, 0xBB, 0x77, 0x10, 0x1B, 0x0B, 0x77, 0x10, 0x9B,
  0x05, 0x77, 0x04, 0xB0, 0xD7, 0x70, 0x10, 0xEB, 0x05, 0x77, 0x0C, 0xB0, 0xA7, 0x70, 0xAB, 0x0D,
  0x77, 0x08, 0xB0, 0xE0, 0x27, 0x60, 0x7B, 0x0E, 0x03, 0x76, 0x07, 0xC0, 0x47, 0x60, 0x7C, 0x04,
  0x76, 0x07, 0xC0, 0x47, 0x60, 0x7C, 0x04, 0x76, 0x07, 0xB0, 0xE0, 0x47, 0x60, 0x7B, 0x0E, 0x04,
  0x76, 0x06, 0xB0, 0xE0, 0x37, 0x60, 0x2D, 0x80, 0x91, 0xE0, 0xB0, 0x3F, 0xFC, 0x0C, 0x03, 0xFF,
  0xC0, 0xC0,
  // "3" (U+0033)
  0x38, 0x91, 0x15, 0x9C, 0xEF, 0xED, 0xB7, 0x15, 0x02, 0x09, 0xFC, 0x07, 0x30, 0x7F, 0x0E, 0xE0,
  0x82, 0x05, 0xB8, 0x1B, 0x62, 0x30, 0x20, 0x9C, 0x04, 0x28, 0x19, 0xB3, 0x71, 0x05, 0xB0, 0xB7,
  0x70, 0xCB, 0x77, 0x08, 0xB0, 0x17, 0x60, 0x8B, 0x01, 0x76, 0x0B, 0xA0, 0xD7, 0x60, 0x3B, 0x08,
  0x75, 0x02, 0x0D, 0xA0, 0xE0, 0x17, 0x38, 0x13, 0x8E, 0xA0, 0xE0, 0x36, 0x0C, 0x0F, 0xEC, 0x81,
  0xE8, 0x17, 0x0D, 0xE0, 0xB0, 0x57, 0x20, 0xDF, 0xA0, 0x90, 0x17, 0x38, 0x21, 0x36, 0xBB, 0x0D,
  0x02, 0x76, 0x04, 0x0E, 0xA0, 0xD7, 0x70, 0x5B, 0x06, 0x77, 0x0E, 0xA0, 0xB7, 0x70, 0xBA, 0x0E,
  0x77, 0x0A, 0xB7, 0x70, 0xBA, 0x0E, 0x77, 0xB0, 0xC7, 0x60, 0x7B, 0x81, 0x79, 0x27, 0x30, 0x5C,
  0x01, 0xA8, 0x2C, 0x74, 0x13, 0x81, 0x14, 0xAC, 0x06, 0x1F, 0x0E, 0xF0, 0x82, 0x0C, 0xFD, 0x0D,
  0x04, 0x48, 0x92, 0x26, 0x9C, 0xDE, 0xFE, 0xDB, 0x84, 0x50,
  // "4" (U+0034)
  0x74, 0x08, 0xB0, 0xD7, 0x70, 0x2C, 0x0D, 0x77, 0x0A, 0xC0, 0xD7, 0x60, 0x4D, 0x0D, 0x76, 0x0D,
  0xA0, 0x9A, 0x0D, 0x75, 0x06, 0xA0, 0xC0, 0x6A, 0x0D, 0x74, 0x01, 0x0E, 0xA0, 0x40, 0x7A, 0x0D,
  0x74, 0x09, 0xA8, 0x1B, 0x07, 0xA0, 0xD7, 0x30, 0x3B, 0x81, 0x20, 0x8A, 0x0D, 0x73, 0x0B, 0xA0,
  0x92, 0x08, 0xA0, 0xD7, 0x20, 0x5A, 0x0E, 0x01, 0x20, 0x8A, 0x0D, 0x72, 0x0D, 0xA0, 0x63, 0x09,
  0xA0, 0xD7, 0x10, 0x8A, 0x0D, 0x40, 0x9A, 0x0D, 0x70, 0x2B, 0x04, 0x40, 0x9A, 0x0D, 0x70, 0xAA,
  0x0A, 0x50, 0x9A, 0x0D, 0x60, 0x4B, 0x02, 0x50, 0x9A, 0x0D, 0x60, 0xCA, 0x08, 0x60, 0x9A, 0x0D,
  0x50, 0x6A, 0x0E, 0x70, 0x9A, 0x0D, 0x40, 0x10, 0xEA, 0x06, 0x70, 0x9A, 0x0D, 0x40, 0x9A, 0x0C,
  0x71, 0x09, 0xA0, 0xD4, 0xC8, 0x04, 0xEC, 0x80, 0x0E, 0x80, 0xC4, 0xF7, 0x50, 0x9A, 0x0D, 0x77,
  0x20, 0x9A, 0x0D, 0x77, 0x20, 0x9A, 0x0D, 0x77, 0x20, 0x9A, 0x0D, 0x77, 0x20, 0x9A, 0x0D, 0x77,
  0x20, 0x9A, 0x0D, 0x40,
  // "5" (U+0035)
  0x10, 0x2F, 0xF0, 0x12, 0x03, 0xFF, 0x01, 0x20, 0x5B, 0x80, 0x7E, 0x01, 0x20, 0x6A, 0x0D, 0x77,
  0x07, 0xA0, 0xC7, 0x70, 0x8A, 0x0B, 0x77, 0x0A, 0xA0, 0x97, 0x70, 0xBA, 0x08, 0x77, 0x0C, 0xA0,
  0x77, 0x70, 0xDA, 0x05, 0x77, 0xB0, 0x47, 0x7B, 0x81, 0xBC, 0xEA, 0x82, 0xDC, 0x83, 0x50, 0x2F,
  0xD0, 0xC0, 0x23, 0x01, 0x0D, 0xD0, 0xEF, 0x04, 0x48, 0x27, 0x53, 0x13, 0x81, 0x38, 0xEB, 0x0E,
  0x03, 0x75, 0x01, 0x0B, 0xB0, 0xC7, 0x70, 0xDB, 0x03, 0x76, 0x06, 0xB0, 0x87, 0x60, 0x1B, 0x0A,
  0x77, 0xB0, 0xB7, 0x70, 0xEA, 0x0A, 0x77, 0xB0, 0x97, 0x60, 0x5B, 0x05, 0x76, 0x0C, 0xB8, 0x11,
  0x61, 0x73, 0x0A, 0xB8, 0x58, 0x0C, 0xFA, 0x52, 0x48, 0x13, 0x7E, 0xB0, 0xC2, 0x0C, 0xFE, 0x0C,
  0x01, 0x20, 0x9F, 0xC0, 0xE0, 0x85, 0x83, 0x16, 0x9C, 0xEA, 0x83, 0xED, 0xA6, 0x15,
  // "6" (U+0036)
  0x71, 0x89, 0x03, 0x8B, 0xDE, 0xFE, 0xEC, 0x27, 0x10, 0x40, 0xCF, 0xA0, 0x37, 0x09, 0xFC, 0x03,
  0x60, 0xBC, 0x81, 0xA5, 0x23, 0x81, 0x14, 0x15, 0x09, 0xB0, 0xB0, 0x27, 0x60, 0x3B, 0x0A, 0x77,
  0x10, 0xBA, 0x0D, 0x77, 0x10, 0x3B, 0x04, 0x77, 0x10, 0x8A, 0x0D, 0x77, 0x20, 0xCA, 0x08, 0x77,
  0x2B, 0x05, 0x28, 0x64, 0x9C, 0xED, 0xC9, 0x45, 0x03, 0xB8, 0x12, 0x0B, 0xF9, 0x0C, 0x03, 0x30,
  0x5B, 0x01, 0x0C, 0xFB, 0x0E, 0x04, 0x20, 0x7B, 0x09, 0xA8, 0x59, 0x41, 0x01, 0x4B, 0xB8, 0x2E,
  0x10, 0x7C, 0x0D, 0x03, 0x70, 0x7B, 0x81, 0x90, 0x8B, 0x0E, 0x02, 0x72, 0x0B, 0xB1, 0x09, 0xB0,
  0x77, 0x30, 0x4B, 0x04, 0x08, 0xB0, 0x17, 0x4B, 0x00, 0x7B, 0x75, 0x0D, 0xA0, 0x80, 0x6B, 0x75,
  0x0D, 0xA0, 0x80, 0x3B, 0x03, 0x74, 0x0E, 0xA0, 0x71, 0xB0, 0x77, 0x30, 0x1B, 0x81, 0x50, 0xBA,
  0x0D, 0x73, 0x05, 0xB8, 0x12, 0x05, 0xB0, 0x77, 0x20, 0xBA, 0x0D, 0x30, 0xCB, 0x05, 0x70, 0x8B,
  0x06, 0x30, 0x3C, 0x09, 0x03, 0x30, 0x40, 0xBB, 0x0B, 0x50, 0x40, 0xED, 0x0E, 0xD0, 0xC0, 0x16,
  0x03, 0x0C, 0xFA, 0x09, 0x73, 0x87, 0x49, 0xCE, 0xFE, 0xC8, 0x25,
  // "7" (U+0037)
  0x09, 0xFF, 0xC0, 0x09, 0xFF, 0xC0, 0x90, 0x88, 0x09, 0x3E, 0xB0, 0x87, 0x71, 0x04, 0xB0, 0x37,
  0x71, 0x0B, 0xA0, 0xC7, 0x71, 0x02, 0xB0, 0x67, 0x71, 0x08, 0xA0, 0xE7, 0x72, 0x0E, 0xA0, 0x97,
  0x71, 0x06, 0xB0, 0x27, 0x71, 0x0C, 0xA0, 0xB7, 0x71, 0x03, 0xB0, 0x57, 0x71, 0x0A, 0xA0, 0xE7,
  0x71, 0x01, 0xB0, 0x87, 0x71, 0x07, 0xB0, 0x27, 0x71, 0x0E, 0xA0, 0xB7, 0x71, 0x05, 0xB0, 0x47,
  0x71, 0x0C, 0xA0, 0xD7, 0x71, 0x03, 0xB0, 0x77, 0x71, 0x09, 0xB0, 0x17, 0x70, 0x10, 0xEA, 0x0A,
  0x77, 0x10, 0x7B, 0x03, 0x77, 0x10, 0xDA, 0x0D, 0x77, 0x10, 0x4B, 0x06, 0x77, 0x10, 0xBA, 0x0E,
  0x01, 0x77, 0x02, 0xB0, 0x97, 0x71, 0x08, 0xB0, 0x37, 0x71, 0x0E, 0xA0, 0xC7, 0x71, 0x06, 0xB0,
  0x57, 0x71, 0x0C, 0xA0, 0xE7, 0x40,
  // "8" (U+0038)
  0x58, 0x90, 0x16, 0xAD, 0xEE, 0xDB, 0x61, 0x72, 0x07, 0x0E, 0xF9, 0x0E, 0x07, 0x70, 0xAF, 0xD0,
  0x95, 0x07, 0xB8, 0x1D, 0x61, 0x28, 0x11, 0x6D, 0xB0, 0x74, 0x0E, 0xA0, 0xD0, 0x16, 0x01, 0x0D,
  0xA0, 0xE3, 0x03, 0xB0, 0x57, 0x10, 0x6B, 0x02, 0x20, 0x5B, 0x02, 0x71, 0x03, 0xB0, 0x42, 0x04,
  0xB0, 0x37, 0x10, 0x3B, 0x03, 0x20, 0x2B, 0x06, 0x71, 0x06, 0xB0, 0x13, 0x0C, 0xA0, 0xD0, 0x16,
  0x01, 0x0D, 0xA0, 0xB4, 0x04, 0xB0, 0xC0, 0x14, 0x02, 0x0C, 0xB0, 0x35, 0x06, 0xB0, 0xE0, 0x72,
  0x06, 0x0E, 0xA0, 0xE0, 0x47, 0x06, 0xC0, 0xE0, 0xDB, 0x0D, 0x03, 0x72, 0x03, 0x0D, 0xE0, 0x77,
  0x40, 0x80, 0xEE, 0x0D, 0x05, 0x71, 0x03, 0x0D, 0xB8, 0x1B, 0x5B, 0xC0, 0xB0, 0x15, 0x04, 0x0E,
  0xA0, 0xE0, 0x43, 0x03, 0x0C, 0xB0, 0xD0, 0x23, 0x01, 0x0E, 0xA0, 0xD0, 0x16, 0x07, 0xB0, 0xC3,
  0x09, 0xA0, 0xE0, 0x27, 0x10, 0x4B, 0x07, 0x20, 0xEA, 0x09, 0x73, 0x09, 0xA8, 0x1D, 0x02, 0xB0,
  0x57, 0x30, 0x5B, 0x01, 0x03, 0xB0, 0x37, 0x30, 0x4B, 0x00, 0x3B, 0x05, 0x73, 0x06, 0xB0, 0x21,
  0xB0, 0xA7, 0x30, 0xCA, 0x0E, 0x20, 0xAB, 0x05, 0x71, 0x08, 0xB0, 0x82, 0x02, 0xC0, 0x90, 0x33,
  0x81, 0x15, 0xBB, 0x0D, 0x01, 0x30, 0x5E, 0x0E, 0xE0, 0xE0, 0x25, 0x03, 0x0C, 0xFB, 0x09, 0x01,
  0x71, 0x89, 0x04, 0x9C, 0xEF, 0xED, 0xB7, 0x25,
  // "9" (U+0039)
  0x58, 0x72, 0x8C, 0xEF, 0xED, 0xA5, 0x72, 0x01, 0x0A, 0xFA, 0x0D, 0x03, 0x60, 0x20, 0xDD, 0x0E,
  0xE0, 0x55, 0x0D, 0xB0, 0xB0, 0x43, 0x03, 0x09, 0xC0, 0x23, 0x08, 0xB0, 0x77, 0x04, 0x0E, 0xA0,
  0xC3, 0x0E, 0xA0, 0xA7, 0x20, 0x5B, 0x81, 0x40, 0x4B, 0x03, 0x73, 0x0B, 0xA8, 0x1A, 0x07, 0xB7,
  0x40, 0x5A, 0x81, 0xE0, 0x8A, 0x0D, 0x74, 0x01, 0xB0, 0x20, 0x8A, 0x0D, 0x75, 0xB0, 0x50, 0x7A,
  0x0E, 0x74, 0x01, 0xB0, 0x70, 0x5B, 0x02, 0x73, 0x06, 0xB0, 0x80, 0x1B, 0x08, 0x72, 0x01, 0x0D,
  0xB8, 0x18, 0x0B, 0xB0, 0x47, 0x01, 0x0C, 0xC8, 0x19, 0x03, 0xC0, 0x80, 0x33, 0x83, 0x38, 0xEF,
  0xBB, 0x08, 0x20, 0x6E, 0x0E, 0xC0, 0xD0, 0x2B, 0x07, 0x30, 0x40, 0xEF, 0x98, 0x1B, 0x12, 0xB0,
  0x55, 0x86, 0x6A, 0xDE, 0xFD, 0xA5, 0x20, 0x4B, 0x04, 0x77, 0x10, 0x7B, 0x01, 0x77, 0x10, 0xBA,
  0x0D, 0x77, 0x10, 0x1B, 0x08, 0x77, 0x10, 0x8B, 0x03, 0x77, 0x01, 0x0E, 0xA0, 0xC7, 0x71, 0x0C,
  0xB0, 0x47, 0x60, 0x30, 0xCB, 0x09, 0x60, 0x40, 0x13, 0x81, 0x15, 0xAC, 0x0B, 0x70, 0xDA, 0x0E,
  0xF0, 0xA7, 0x10, 0xDF, 0x90, 0xD0, 0x57, 0x28, 0x79, 0xDE, 0xFE, 0xDB, 0x83, 0x71,
  // ":" (U+003A)
  0x18, 0x48, 0xEE, 0x80, 0x3C, 0x04, 0x06, 0xC0, 0x60, 0x3C, 0x84, 0x40, 0x7E, 0xE8, 0x80, 0x98,
  0x60, 0x84, 0x8E, 0xE8, 0x04, 0xC0, 0x40, 0x6C, 0x06, 0x04, 0xC8, 0x43, 0x08, 0xEE, 0x81,
  // ";" (U+003B)
  0x38, 0x29, 0xEE, 0x73, 0x05, 0xC0, 0x32, 0x08, 0xC0, 0x52, 0x05, 0xC0, 0x33, 0x82, 0x9E, 0xE7,
  0x80, 0x9A, 0x70, 0x07, 0xC0, 0x12, 0x09, 0xB0, 0xE3, 0x0C, 0xB0, 0x93, 0xC0, 0x42, 0x02, 0xB0,
  0xE3, 0x05, 0xB0, 0x93, 0x08, 0xB0, 0x33, 0x0C, 0xA0, 0xD4, 0xB0, 0x73, 0x03, 0xA0, 0xE0, 0x13,
  0x07, 0xA0, 0x94,
  // "<" (U+003C)
  0x77, 0x30, 0x17, 0x71, 0x81, 0x3C, 0x67, 0x60, 0x20, 0xAA, 0x06, 0x74, 0x01, 0x08, 0xC0, 0x57,
  0x30, 0x70, 0xEB, 0x0D, 0x04, 0x72, 0x05, 0x0D, 0xB0, 0xE0, 0x67, 0x20, 0x30, 0xCB, 0x0E, 0x07,
  0x72, 0x02, 0x0A, 0xC0, 0x90, 0x17, 0x10, 0x10, 0x8C, 0x0A, 0x02, 0x72, 0x06, 0x0E, 0xB0, 0xC0,
  0x37, 0x30, 0x6B, 0x0D, 0x05, 0x75, 0x06, 0xB0, 0xE0, 0x77, 0x58, 0x11, 0x8E, 0xB8, 0x1E, 0x81,
  0x74, 0x81, 0x17, 0xEB, 0x81, 0xE8, 0x17, 0x48, 0x11, 0x7E, 0xC0, 0x90, 0x27, 0x50, 0x70, 0xEC,
  0x09, 0x02, 0x75, 0x07, 0x0E, 0xC0, 0xA0, 0x37, 0x50, 0x70, 0xEC, 0x05, 0x76, 0x06, 0x0D, 0xA0,
  0x67, 0x71, 0x81, 0x6D, 0x67, 0x73, 0x01,
  // "=" (U+003D)
  0x02, 0x80, 0x96, 0xE0, 0x20, 0x3F, 0xFC, 0x00, 0x3F, 0xFC, 0x03, 0x80, 0x9C, 0x00, 0x02, 0x80,
  0x96, 0xE0, 0x20, 0x3F, 0xFC, 0x00, 0x3F, 0xFC, 0x03,
  // ">" (U+003E)
  0x01, 0x77, 0x38, 0x16, 0xC3, 0x77, 0x10, 0x6A, 0x0A, 0x02, 0x76, 0x05, 0xC0, 0x80, 0x17, 0x50,
  0x40, 0xDB, 0x0E, 0x07, 0x76, 0x06, 0x0E, 0xB0, 0xD0, 0x57, 0x60, 0x70, 0xEB, 0x0C, 0x03, 0x75,
  0x01, 0x09, 0xC0, 0xA0, 0x27, 0x50, 0x20, 0xAC, 0x08, 0x01, 0x75, 0x03, 0x0C, 0xB0, 0xE0, 0x67,
  0x60, 0x50, 0xDB, 0x06, 0x75, 0x07, 0x0E, 0xB0, 0x67, 0x28, 0x11, 0x8E, 0xB8, 0x1E, 0x81, 0x78,
  0x11, 0x8E, 0xB8, 0x1E, 0x71, 0x70, 0x20, 0x9C, 0x81, 0xE7, 0x17, 0x02, 0x09, 0xC0, 0xE0, 0x77,
  0x10, 0x30, 0xAC, 0x0E, 0x07, 0x72, 0x05, 0xC0, 0xE0, 0x77, 0x40, 0x6A, 0x0D, 0x06, 0x76, 0x81,
  0x6D, 0x67, 0x71, 0x01, 0x77, 0x30,
  // "?" (U+003F)
  0x38, 0x91, 0x38, 0xBD, 0xEF, 0xED, 0xA6, 0x14, 0x81, 0x18, 0xEF, 0xC0, 0x73, 0x01, 0xFF, 0x0A,
  0x30, 0xAA, 0x81, 0xB6, 0x23, 0x81, 0x16, 0xDB, 0x06, 0x28, 0x13, 0x81, 0x71, 0x01, 0x0D, 0xA0,
  0xE7, 0x70, 0x4B, 0x03, 0x77, 0xB0, 0x57, 0x7B, 0x05, 0x76, 0x02, 0xB0, 0x47, 0x60, 0x6B, 0x01,
  0x76, 0x0D, 0xA0, 0xC7, 0x60, 0xAB, 0x04, 0x74, 0x01, 0x0B, 0xB0, 0x97, 0x40, 0x30, 0xDB, 0x0A,
  0x74, 0x05, 0xC0, 0x87, 0x40, 0x4B, 0x0E, 0x05, 0x75, 0x0E, 0xA0, 0xE0, 0x37, 0x50, 0x6B, 0x03,
  0x76, 0x0A, 0xA0, 0x97, 0x70, 0xBA, 0x06, 0x77, 0x82, 0xBE, 0xE4, 0x80, 0x98, 0x00, 0x82, 0x9E,
  0xE7, 0x76, 0x05, 0xC0, 0x37, 0x50, 0x8C, 0x05, 0x75, 0x05, 0xC0, 0x37, 0x68, 0x29, 0xEE, 0x77,
  0x10,
  // "@" (U+0040)
  0x71, 0x87, 0x28, 0xBE, 0xFE, 0xD9, 0x47, 0x60, 0x10, 0xAF, 0xA0, 0xB0, 0x27, 0x30, 0x30, 0xED,
  0x0E, 0xD0, 0xE0, 0x47, 0x10, 0x30, 0xEA, 0x81, 0xE8, 0x33, 0x81, 0x28, 0xEA, 0x0E, 0x02, 0x60,
  0x10, 0xEA, 0x0C, 0x01, 0x70, 0x20, 0xCA, 0x0D, 0x60, 0xAA, 0x0B, 0x73, 0x01, 0x0D, 0xA0, 0x64,
  0x03, 0xA0, 0xE0, 0x17, 0x40, 0x3A, 0x0D, 0x40, 0xAA, 0x05, 0x76, 0x09, 0xA0, 0x42, 0x01, 0xA0,
  0xD4, 0x89, 0x11, 0x8D, 0xFE, 0xDA, 0x61, 0x03, 0xA0, 0x92, 0x05, 0xA0, 0x73, 0x03, 0x0E, 0xF0,
  0xC2, 0x81, 0xDF, 0xD2, 0x0A, 0xA0, 0x22, 0x02, 0x0E, 0xF9, 0x0B, 0x20, 0xAA, 0x83, 0x10, 0xDF,
  0xE3, 0x0A, 0xA0, 0xD0, 0x32, 0x08, 0xA0, 0xB2, 0x07, 0xA0, 0x31, 0xA0, 0xB2, 0x03, 0xB0, 0x33,
  0x05, 0xA0, 0xA2, 0x06, 0xA0, 0x40, 0x2A, 0x09, 0x20, 0x7A, 0x0A, 0x40, 0x6A, 0x09, 0x20, 0x5A,
  0x05, 0x04, 0xA0, 0x72, 0x0C, 0xA0, 0x64, 0x07, 0xA0, 0x82, 0x04, 0xA0, 0x60, 0x5A, 0x06, 0x20,
  0xEA, 0x03, 0x40, 0x8A, 0x07, 0x20, 0x4A, 0x00, 0x5A, 0x05, 0x2B, 0x01, 0x40, 0x9A, 0x06, 0x20,
  0x5A, 0x05, 0x06, 0xA0, 0x52, 0xB0, 0x14, 0x0B, 0xA0, 0x62, 0x06, 0xA0, 0x30, 0x5A, 0x06, 0x2B,
  0x02, 0x40, 0xDA, 0x05, 0x20, 0x7A, 0x01, 0x04, 0xA0, 0x72, 0x0D, 0xA0, 0x43, 0x02, 0xB0, 0x62,
  0x83, 0xAF, 0xE0, 0x3A, 0x09, 0x20, 0xAA, 0x09, 0x30, 0x6B, 0x07, 0x28, 0x3E, 0xFA, 0x01, 0xA0,
  0xC2, 0x05, 0xB8, 0x90, 0x50, 0x3E, 0xF9, 0xFD, 0x16, 0xA0, 0x52, 0x81, 0xDF, 0xE3, 0x0D, 0xE8,
  0x1C, 0x1E, 0xC0, 0xE3, 0x0A, 0xA0, 0x52, 0x03, 0x0E, 0xC8, 0x2E, 0x20, 0x8C, 0x05, 0x30, 0x5A,
  0x0A, 0x38, 0x42, 0xAD, 0xDA, 0x23, 0x82, 0x9D, 0xC4, 0x50, 0xEA, 0x03, 0x77, 0x60, 0x8A, 0x0C,
  0x77, 0x60, 0x10, 0xEA, 0x0A, 0x77, 0x60, 0x5B, 0x0B, 0x01, 0x73, 0x03, 0x71, 0x07, 0xB8, 0x2E,
  0x94, 0x22, 0x84, 0x13, 0x59, 0xED, 0x72, 0x07, 0xFE, 0x0D, 0x73, 0x03, 0x0B, 0xFB, 0x0C, 0x05,
  0x75, 0x89, 0x02, 0x7B, 0xDE, 0xED, 0xB8, 0x36,
  // "A" (U+0041)
  0x72, 0x01, 0xC7, 0x75, 0x06, 0xC0, 0x57, 0x74, 0x0B, 0xC0, 0xA7, 0x73, 0x01, 0xD0, 0xE7, 0x73,
  0x05, 0xA0, 0xD0, 0xEA, 0x05, 0x77, 0x20, 0xAA, 0x09, 0x0A, 0xA0, 0x97, 0x72, 0x0E, 0xA0, 0x50,
  0x6A, 0x0E, 0x77, 0x10, 0x5B, 0x01, 0x02, 0xB0, 0x47, 0x70, 0xAA, 0x0C, 0x20, 0xDA, 0x09, 0x77,
  0x0E, 0xA0, 0x72, 0x08, 0xA0, 0xE7, 0x60, 0x4B, 0x02, 0x20, 0x3B, 0x03, 0x75, 0x09, 0xA0, 0xD4,
  0x0E, 0xA0, 0x87, 0x50, 0xEA, 0x08, 0x40, 0x9A, 0x0D, 0x74, 0x03, 0xB0, 0x34, 0x04, 0xB0, 0x37,
  0x30, 0x8A, 0x0E, 0x60, 0xEA, 0x08, 0x73, 0x0D, 0xA0, 0x96, 0x0A, 0xA0, 0xD7, 0x20, 0x3B, 0x05,
  0x60, 0x5B, 0x02, 0x71, 0x08, 0xB8, 0x04, 0xEB, 0x07, 0x71, 0x0D, 0xFF, 0x0C, 0x70, 0x2F, 0xFA,
  0x02, 0x60, 0x7A, 0x0E, 0x72, 0x01, 0xB0, 0x76, 0x0C, 0xA0, 0xA7, 0x30, 0xBA, 0x0C, 0x50, 0x1B,
  0x06, 0x73, 0x07, 0xB0, 0x14, 0x06, 0xB0, 0x17, 0x30, 0x2B, 0x06, 0x40, 0xBA, 0x0C, 0x75, 0x0D,
  0xA0, 0xB3, 0x01, 0xB0, 0x77, 0x50, 0x8B, 0x01, 0x20, 0x6B, 0x02, 0x75, 0x03, 0xB0, 0x62, 0x0B,
  0xA0, 0xD7, 0x70, 0xEA, 0x81, 0xB0, 0x1B, 0x09, 0x77, 0x09, 0xB0, 0x10,
  // "B" (U+0042)
  0x03, 0xF9, 0x83, 0xED, 0xB8, 0x45, 0x03, 0xFE, 0x0D, 0x05, 0x30, 0x3B, 0x80, 0x1E, 0xF0, 0x72,
  0x03, 0xB0, 0x35, 0x81, 0x14, 0xAC, 0x81, 0x30, 0x3B, 0x03, 0x71, 0x08, 0xB8, 0x19, 0x03, 0xB0,
  0x37, 0x20, 0xEA, 0x81, 0xD0, 0x3B, 0x03, 0x72, 0x0B, 0xA8, 0x1E, 0x03, 0xB0, 0x37, 0x20, 0xAA,
  0x81, 0xE0, 0x3B, 0x03, 0x72, 0x0B, 0xA8, 0x1D, 0x03, 0xB0, 0x37, 0x10, 0x10, 0xEA, 0x81, 0x90,
  0x3B, 0x03, 0x71, 0x09, 0xB8, 0x12, 0x03, 0xB0, 0x35, 0x81, 0x25, 0xCB, 0x06, 0x20, 0x3F, 0xE0,
  0xC0, 0x43, 0x03, 0xFD, 0x07, 0x01, 0x40, 0x3B, 0x80, 0x1E, 0xE0, 0x90, 0x12, 0x03, 0xB0, 0x36,
  0x03, 0x09, 0xB8, 0x2D, 0x20, 0x3B, 0x03, 0x71, 0x04, 0xB8, 0x1C, 0x03, 0xB0, 0x37, 0x20, 0x8B,
  0x04, 0x03, 0xB0, 0x37, 0x20, 0x2B, 0x09, 0x03, 0xB0, 0x37, 0x30, 0xEA, 0x0B, 0x03, 0xB0, 0x37,
  0x30, 0xDA, 0x0C, 0x03, 0xB0, 0x37, 0x30, 0xEA, 0x0B, 0x03, 0xB0, 0x37, 0x20, 0x2B, 0x09, 0x03,
  0xB0, 0x37, 0x20, 0x8B, 0x05, 0x03, 0xB0, 0x37, 0x10, 0x4B, 0x81, 0xD0, 0x3B, 0x03, 0x60, 0x30,
  0x9C, 0x81, 0x50, 0x3B, 0x80, 0x1E, 0xF0, 0x82, 0x03, 0xFE, 0x0E, 0x05, 0x30, 0x3F, 0xA8, 0x2E,
  0xDA, 0x65,
  // "C" (U+0043)
  0x71, 0x89, 0x15, 0x9C, 0xEF, 0xEE, 0xC9, 0x51, 0x70, 0x60, 0xEF, 0xC0, 0x95, 0x0B, 0xFE, 0x08,
  0x40, 0xCC, 0x81, 0x93, 0x12, 0x84, 0x14, 0x8D, 0xF1, 0x30, 0x9B, 0x0C, 0x02, 0x72, 0x03, 0x30,
  0x4B, 0x0C, 0x01, 0x77, 0x0C, 0xB0, 0x27, 0x70, 0x3B, 0x09, 0x77, 0x10, 0x8B, 0x03, 0x77, 0x10,
  0xCA, 0x0D, 0x77, 0x2B, 0x0A, 0x77, 0x10, 0x2B, 0x08, 0x77, 0x10, 0x4B, 0x06, 0x77, 0x10, 0x5B,
  0x05, 0x77, 0x10, 0x5B, 0x05, 0x77, 0x10, 0x5B, 0x05, 0x77, 0x10, 0x4B, 0x06, 0x77, 0x10, 0x2B,
  0x07, 0x77, 0x2B, 0x0A, 0x77, 0x20, 0xDA, 0x0D, 0x77, 0x20, 0x9B, 0x02, 0x77, 0x10, 0x4B, 0x07,
  0x77, 0x20, 0xDA, 0x0E, 0x01, 0x77, 0x10, 0x6B, 0x0A, 0x77, 0x20, 0xCB, 0x09, 0x77, 0x10, 0x10,
  0xDB, 0x81, 0xD7, 0x23, 0x83, 0x13, 0x6B, 0xB5, 0x02, 0x0D, 0xE0, 0xED, 0x0B, 0x70, 0x8F, 0xC0,
  0xB7, 0x18, 0x92, 0x16, 0xAD, 0xEF, 0xED, 0xC9, 0x51, 0x10,
  // "D" (U+0044)
  0x03, 0xF8, 0x3E, 0xDB, 0x73, 0x71, 0x03, 0xFD, 0x0B, 0x03, 0x60, 0x3B, 0x80, 0x0E, 0xF0, 0x85,
  0x03, 0xB0, 0x64, 0x81, 0x26, 0xCC, 0x09, 0x40, 0x3B, 0x06, 0x70, 0x6C, 0x07, 0x30, 0x3B, 0x06,
  0x71, 0x03, 0x0E, 0xB0, 0x22, 0x03, 0xB0, 0x67, 0x20, 0x6B, 0x0A, 0x20, 0x3B, 0x06, 0x73, 0x0C,
  0xB8, 0x11, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x81, 0x60, 0x3B, 0x06, 0x74, 0xB8, 0x1A, 0x03, 0xB0,
  0x67, 0x40, 0xDA, 0x81, 0xD0, 0x3B, 0x06, 0x74, 0x0A, 0xB1, 0x03, 0xB0, 0x67, 0x40, 0x9B, 0x01,
  0x03, 0xB0, 0x67, 0x40, 0x8B, 0x02, 0x03, 0xB0, 0x67, 0x40, 0x7B, 0x02, 0x03, 0xB0, 0x67, 0x40,
  0x8B, 0x01, 0x03, 0xB0, 0x67, 0x40, 0x9B, 0x10, 0x3B, 0x06, 0x74, 0x0B, 0xB1, 0x03, 0xB0, 0x67,
  0x40, 0xEA, 0x81, 0xC0, 0x3B, 0x06, 0x73, 0x02, 0xB8, 0x19, 0x03, 0xB0, 0x67, 0x30, 0x7B, 0x81,
  0x50, 0x3B, 0x06, 0x73, 0x0D, 0xA0, 0xE2, 0x03, 0xB0, 0x67, 0x20, 0x8B, 0x08, 0x20, 0x3B, 0x06,
  0x71, 0x05, 0xB0, 0xE0, 0x12, 0x03, 0xB0, 0x67, 0x07, 0xC0, 0x43, 0x03, 0xB0, 0x63, 0x82, 0x14,
  0x8E, 0xC0, 0x64, 0x03, 0xB0, 0xFE, 0xF0, 0xE0, 0x45, 0x03, 0xFD, 0x08, 0x01, 0x60, 0x3E, 0x84,
  0xED, 0xC9, 0x51, 0x71,
  // "E" (U+0045)
  0x03, 0xFF, 0xA0, 0x90, 0x3F, 0xFA, 0x09, 0x03, 0xB8, 0x09, 0x1E, 0x08, 0x03, 0xB0, 0x67, 0x60,
  0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06,
  0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3F, 0xF9, 0x81, 0xD0,
  0x3F, 0xF9, 0x81, 0xD0, 0x3B, 0x80, 0x90, 0xE8, 0x1C, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76,
  0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0,
  0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60,
  0x3B, 0x80, 0x91, 0xE0, 0x80, 0x3F, 0xFA, 0x09, 0x03, 0xFF, 0xA0, 0x90,
  // "F" (U+0046)
  0x03, 0xFF, 0xA0, 0x90, 0x3F, 0xFA, 0x09, 0x03, 0xB8, 0x09, 0x1E, 0x08, 0x03, 0xB0, 0x67, 0x60,
  0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06,
  0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03,
  0xB0, 0x67, 0x60, 0x3F, 0xF9, 0x81, 0xD0, 0x3F, 0xF9, 0x81, 0xD0, 0x3B, 0x80, 0x90, 0xE8, 0x1C,
  0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0,
  0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60,
  0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76,
  // "G" (U+0047)
  0x71, 0x89, 0x13, 0x8B, 0xDE, 0xFE, 0xC9, 0x51, 0x71, 0x04, 0x0D, 0xFC, 0x08, 0x60, 0x9F, 0x0E,
  0xD0, 0x75, 0x09, 0xC8, 0x1A, 0x51, 0x38, 0x33, 0x7D, 0xE1, 0x40, 0x6B, 0x0D, 0x04, 0x72, 0x03,
  0x40, 0x10, 0xEA, 0x0E, 0x02, 0x77, 0x10, 0x9B, 0x05, 0x77, 0x20, 0xEA, 0x0C, 0x77, 0x20, 0x5B,
  0x06, 0x77, 0x20, 0x9B, 0x01, 0x77, 0x20, 0xCA, 0x0D, 0x77, 0x3B, 0x0B, 0x77, 0x20, 0x1B, 0x09,
  0x77, 0x20, 0x1B, 0x08, 0x77, 0x20, 0x2B, 0x07, 0x60, 0x78, 0x04, 0xE0, 0x02, 0xB0, 0x86, 0x07,
  0xF9, 0x03, 0x01, 0xB0, 0x96, 0x07, 0xF9, 0x03, 0x1B, 0x0A, 0x74, 0x04, 0xB8, 0x13, 0x0E, 0xA0,
  0xC7, 0x40, 0x4B, 0x81, 0x30, 0xBB, 0x74, 0x04, 0xB8, 0x13, 0x08, 0xB0, 0x47, 0x30, 0x4B, 0x81,
  0x30, 0x4B, 0x09, 0x73, 0x04, 0xB0, 0x32, 0x0D, 0xB0, 0x27, 0x20, 0x4B, 0x03, 0x20, 0x6B, 0x0C,
  0x72, 0x04, 0xB0, 0x33, 0x0C, 0xB0, 0xB0, 0x17, 0x04, 0xB0, 0x33, 0x02, 0x0E, 0xB8, 0x1E, 0x73,
  0x40, 0x30, 0x9B, 0x03, 0x40, 0x20, 0xDE, 0x0E, 0xF0, 0x35, 0x01, 0x08, 0xFD, 0x0D, 0x02, 0x78,
  0x92, 0x16, 0xAC, 0xEF, 0xEE, 0xCA, 0x63, 0x20,
  // "H" (U+0048)
  0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B,
  0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06,
  0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30,
  0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73,
  0x06, 0xB0, 0x03, 0xFF, 0xC0, 0x03, 0xFF, 0xC0, 0x03, 0xB8, 0x09, 0x0E, 0xB0, 0x03, 0xB0, 0x67,
  0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06,
  0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0,
  0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B,
  0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03,
  0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x30,
  // "I" (U+0049)
  0x09, 0xFF, 0x00, 0x9F, 0xF8, 0x29, 0x7D, 0xEF, 0xB8, 0x1E, 0xD7, 0x48, 0x11, 0x3D, 0xA8, 0x1C,
  0x31, 0x73, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75,
  0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0,
  0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50,
  0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B,
  0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x68, 0x44,
  0x9A, 0xCD, 0xEC, 0x85, 0xED, 0xBA, 0x94, 0x9F, 0xF0, 0x09, 0xFF, 0x09,
  // "J" (U+004A)
  0x74, 0xB0, 0x97, 0x4B, 0x09, 0x74, 0xB0, 0x97, 0x4B, 0x09, 0x74, 0xB0, 0x97, 0x4B, 0x09, 0x74,
  0xB0, 0x97, 0x4B, 0x09, 0x74, 0xB0, 0x97, 0x4B, 0x09, 0x74, 0xB0, 0x97, 0x4B, 0x09, 0x74, 0xB0,
  0x97, 0x4B, 0x09, 0x74, 0xB0, 0x97, 0x4B, 0x09, 0x74, 0xB0, 0x97, 0x4B, 0x09, 0x74, 0xB0, 0x97,
  0x4B, 0x09, 0x74, 0xB0, 0x87, 0x30, 0x2B, 0x07, 0x73, 0x05, 0xB0, 0x57, 0x30, 0xAB, 0x01, 0x72,
  0x05, 0xB8, 0x4B, 0x0E, 0xA5, 0x23, 0x02, 0x09, 0xC0, 0x31, 0xD0, 0xEE, 0x07, 0x2F, 0xB0, 0xE0,
  0x63, 0x83, 0x26, 0xAC, 0xEA, 0x82, 0xDB, 0x71, 0x40,
  // "K" (U+004B)
  0x03, 0xB0, 0x67, 0x30, 0xCB, 0x04, 0x03, 0xB0, 0x67, 0x20, 0x9B, 0x81, 0x80, 0x3B, 0x06, 0x71,
  0x04, 0xB0, 0xC2, 0x03, 0xB0, 0x67, 0x01, 0x0E, 0xA0, 0xE0, 0x22, 0x03, 0xB0, 0x67, 0x0B, 0xB0,
  0x63, 0x03, 0xB0, 0x66, 0x07, 0xB0, 0xA4, 0x03, 0xB0, 0x65, 0x03, 0xB0, 0xD0, 0x14, 0x03, 0xB0,
  0x64, 0x01, 0x0D, 0xB0, 0x35, 0x03, 0xB0, 0x64, 0x0A, 0xB0, 0x76, 0x03, 0xB0, 0x63, 0x06, 0xB0,
  0xB7, 0x03, 0xB0, 0x62, 0x02, 0xB0, 0xE0, 0x17, 0x03, 0xB0, 0x62, 0x0D, 0xB0, 0x57, 0x10, 0x3B,
  0x81, 0x60, 0x8B, 0x09, 0x72, 0x03, 0xB0, 0x60, 0x3C, 0x04, 0x72, 0x03, 0xB0, 0x60, 0xCC, 0x0D,
  0x72, 0x03, 0xB0, 0xDA, 0x0E, 0xB0, 0x77, 0x10, 0x3D, 0x81, 0xD1, 0xDB, 0x02, 0x70, 0x3C, 0x82,
  0xE2, 0x03, 0xB0, 0xB7, 0x03, 0xC0, 0x33, 0x09, 0xB0, 0x56, 0x03, 0xB0, 0x74, 0x01, 0x0E, 0xA0,
  0xE0, 0x15, 0x03, 0xB0, 0x65, 0x06, 0xB0, 0x95, 0x03, 0xB0, 0x66, 0x0B, 0xB0, 0x44, 0x03, 0xB0,
  0x66, 0x02, 0xB0, 0xD4, 0x03, 0xB0, 0x67, 0x08, 0xB0, 0x83, 0x03, 0xB0, 0x67, 0x10, 0xDB, 0x02,
  0x20, 0x3B, 0x06, 0x71, 0x04, 0xB0, 0xC2, 0x03, 0xB0, 0x67, 0x20, 0xAB, 0x81, 0x60, 0x3B, 0x06,
  0x72, 0x01, 0x0E, 0xA8, 0x1E, 0x13, 0xB0, 0x67, 0x30, 0x6B, 0x0A,
  // "L" (U+004C)
  0x06, 0xB0, 0x37, 0x50, 0x6B, 0x03, 0x75, 0x06, 0xB0, 0x37, 0x50, 0x6B, 0x03, 0x75, 0x06, 0xB0,
  0x37, 0x50, 0x6B, 0x03, 0x75, 0x06, 0xB0, 0x37, 0x50, 0x6B, 0x03, 0x75, 0x06, 0xB0, 0x37, 0x50,
  0x6B, 0x03, 0x75, 0x06, 0xB0, 0x37, 0x50, 0x6B, 0x03, 0x75, 0x06, 0xB0, 0x37, 0x50, 0x6B, 0x03,
  0x75, 0x06, 0xB0, 0x37, 0x50, 0x6B, 0x03, 0x75, 0x06, 0xB0, 0x37, 0x50, 0x6B, 0x03, 0x75, 0x06,
  0xB0, 0x37, 0x50, 0x6B, 0x03, 0x75, 0x06, 0xB0, 0x37, 0x50, 0x6B, 0x03, 0x75, 0x06, 0xB0, 0x37,
  0x50, 0x6B, 0x03, 0x75, 0x06, 0xB0, 0x37, 0x50, 0x6B, 0x03, 0x75, 0x06, 0xB8, 0x09, 0x0E, 0x08,
  0x06, 0xFF, 0x90, 0x90, 0x6F, 0xF9, 0x09,
  // "M" (U+004D)
  0xD0, 0x47, 0x10, 0x5F, 0xB0, 0x87, 0x10, 0x9F, 0xB0, 0xD7, 0x10, 0xDF, 0xC0, 0x26, 0x02, 0xF9,
  0x0E, 0x0C, 0xA0, 0x66, 0x07, 0xA0, 0xBE, 0x08, 0xA0, 0xA6, 0x0B, 0xA0, 0x8E, 0x05, 0xA0, 0xE6,
  0xB0, 0x5E, 0x03, 0x0D, 0xA0, 0x34, 0x04, 0xA0, 0xD0, 0x3E, 0x04, 0x09, 0xA0, 0x84, 0x08, 0xA0,
  0x80, 0x4E, 0x00, 0x4A, 0x0C, 0x40, 0xDA, 0x03, 0x05, 0xE0, 0x51, 0xB0, 0x12, 0x01, 0xA8, 0x1E,
  0x05, 0xE8, 0x15, 0x0B, 0xA0, 0x52, 0x06, 0xA8, 0x1A, 0x05, 0xE8, 0x16, 0x06, 0xA0, 0x92, 0x0A,
  0xA8, 0x15, 0x06, 0xE8, 0x16, 0x02, 0xA0, 0xE2, 0x0E, 0xA8, 0x11, 0x06, 0xE0, 0x62, 0x0D, 0xA0,
  0x03, 0xA0, 0xC2, 0x06, 0xE0, 0x62, 0x08, 0xA0, 0x70, 0x8A, 0x07, 0x20, 0x6E, 0x06, 0x20, 0x3A,
  0x0B, 0x0C, 0xA0, 0x32, 0x06, 0xE0, 0x63, 0x0E, 0xC0, 0xD3, 0x06, 0xE0, 0x63, 0x0A, 0xC0, 0x93,
  0x06, 0xE0, 0x63, 0x05, 0xC0, 0x43, 0x06, 0xE0, 0x63, 0x01, 0xC4, 0x06, 0xE0, 0x64, 0x82, 0x9C,
  0xC9, 0x40, 0x6E, 0x06, 0x75, 0x06, 0xE0, 0x67, 0x50, 0x6E, 0x06, 0x75, 0x06, 0xE0, 0x67, 0x50,
  0x6E, 0x06, 0x75, 0x06, 0xE0, 0x67, 0x50, 0x6E, 0x06, 0x75, 0x06, 0xB0,
  // "N" (U+004E)
  0x03, 0xC0, 0xC7, 0x20, 0x4B, 0x00, 0x3D, 0x03, 0x71, 0x04, 0xB0, 0x03, 0xD0, 0x97, 0x10, 0x4B,
  0x00, 0x3E, 0x01, 0x70, 0x4B, 0x00, 0x3A, 0x0C, 0x0D, 0xA0, 0x77, 0x04, 0xB0, 0x03, 0xA0, 0xD0,
  0x6A, 0x0D, 0x70, 0x4B, 0x00, 0x3A, 0x81, 0xE0, 0xEA, 0x05, 0x60, 0x4B, 0x00, 0x3B, 0x10, 0x8A,
  0x0C, 0x60, 0x4B, 0x00, 0x3B, 0x00, 0x1B, 0x03, 0x50, 0x4B, 0x00, 0x3B, 0x81, 0x20, 0xAA, 0x09,
  0x50, 0x4B, 0x00, 0x3B, 0x81, 0x20, 0x3B, 0x01, 0x40, 0x4B, 0x00, 0x3B, 0x03, 0x20, 0xCA, 0x07,
  0x40, 0x4B, 0x00, 0x3B, 0x04, 0x20, 0x5A, 0x0E, 0x40, 0x4B, 0x00, 0x3B, 0x04, 0x30, 0xDA, 0x05,
  0x30, 0x4B, 0x00, 0x3B, 0x04, 0x30, 0x7A, 0x0C, 0x30, 0x4B, 0x00, 0x3B, 0x04, 0x30, 0x1B, 0x03,
  0x20, 0x4B, 0x00, 0x3B, 0x04, 0x40, 0x9A, 0x0A, 0x20, 0x4B, 0x00, 0x3B, 0x04, 0x40, 0x2B, 0x81,
  0x10, 0x4B, 0x00, 0x3B, 0x04, 0x50, 0xBA, 0x81, 0x70, 0x3B, 0x00, 0x3B, 0x04, 0x50, 0x4A, 0x81,
  0xE0, 0x3B, 0x00, 0x3B, 0x04, 0x60, 0xDA, 0x05, 0x02, 0xB0, 0x03, 0xB0, 0x46, 0x06, 0xA0, 0xC0,
  0x1B, 0x00, 0x3B, 0x04, 0x70, 0xEA, 0x04, 0xB0, 0x03, 0xB0, 0x47, 0x08, 0xA0, 0xAB, 0x00, 0x3B,
  0x04, 0x70, 0x2E, 0x00, 0x3B, 0x04, 0x71, 0x0A, 0xD0, 0x03, 0xB0, 0x47, 0x10, 0x3D, 0x00, 0x3B,
  0x04, 0x72, 0x0C, 0xC0, 0x03, 0xB0, 0x47, 0x20, 0x5C, 0x03,
  // "O" (U+004F)
  0x78, 0x76, 0xAD, 0xEF, 0xDB, 0x61, 0x74, 0x05, 0x0E, 0xF9, 0x0E, 0x05, 0x72, 0x07, 0xFD, 0x08,
  0x70, 0x5B, 0x81, 0xE7, 0x22, 0x81, 0x17, 0xEB, 0x06, 0x50, 0x10, 0xEA, 0x0D, 0x02, 0x60, 0x10,
  0xDA, 0x0E, 0x01, 0x40, 0x8B, 0x04, 0x71, 0x03, 0xB0, 0x94, 0x0E, 0xA0, 0xC7, 0x30, 0xBA, 0x0E,
  0x30, 0x4B, 0x06, 0x73, 0x05, 0xB0, 0x42, 0x08, 0xB0, 0x17, 0x30, 0x1B, 0x08, 0x20, 0xBA, 0x0D,
  0x75, 0x0D, 0xA0, 0xC2, 0x0E, 0xA0, 0xB7, 0x50, 0xBA, 0x0E, 0x2B, 0x09, 0x75, 0x09, 0xB1, 0x02,
  0xB0, 0x87, 0x50, 0x8B, 0x00, 0x2B, 0x08, 0x75, 0x08, 0xB0, 0x20, 0x3B, 0x07, 0x75, 0x07, 0xB0,
  0x30, 0x2B, 0x08, 0x75, 0x08, 0xB0, 0x02, 0xB0, 0x87, 0x50, 0x8B, 0x01, 0x1B, 0x09, 0x75, 0x09,
  0xB2, 0x0E, 0xA0, 0xB7, 0x50, 0xBA, 0x0E, 0x20, 0xBA, 0x0D, 0x75, 0x0D, 0xA0, 0xB2, 0x08, 0xB0,
  0x17, 0x30, 0x1B, 0x08, 0x20, 0x4B, 0x05, 0x73, 0x05, 0xB0, 0x43, 0x0E, 0xA0, 0xB7, 0x30, 0xBA,
  0x0E, 0x40, 0x9B, 0x04, 0x71, 0x03, 0xB0, 0x84, 0x01, 0x0E, 0xA0, 0xD0, 0x26, 0x02, 0x0D, 0xA0,
  0xE0, 0x15, 0x06, 0xB8, 0x1E, 0x72, 0x28, 0x11, 0x7E, 0xB0, 0x57, 0x08, 0xFD, 0x07, 0x72, 0x06,
  0x0E, 0xF9, 0x0E, 0x05, 0x74, 0x82, 0x16, 0xBD, 0xA8, 0x1D, 0xA6, 0x70,
  // "P" (U+0050)
  0x03, 0xFA, 0x82, 0xEC, 0x95, 0x50, 0x3F, 0xE0, 0xE0, 0x63, 0x03, 0xB8, 0x01, 0xEF, 0x09, 0x20,
  0x3B, 0x06, 0x58, 0x11, 0x4A, 0xC8, 0x17, 0x03, 0xB0, 0x67, 0x10, 0x4B, 0x81, 0xE0, 0x3B, 0x06,
  0x72, 0x08, 0xB0, 0x50, 0x3B, 0x06, 0x72, 0x02, 0xB0, 0x90, 0x3B, 0x06, 0x73, 0xB0, 0xB0, 0x3B,
  0x06, 0x73, 0x0D, 0xA0, 0xC0, 0x3B, 0x06, 0x73, 0x0E, 0xA0, 0xA0, 0x3B, 0x06, 0x73, 0xB0, 0x90,
  0x3B, 0x06, 0x72, 0x04, 0xB0, 0x50, 0x3B, 0x06, 0x72, 0x0B, 0xB1, 0x03, 0xB0, 0x67, 0x10, 0x9B,
  0x81, 0x90, 0x3B, 0x06, 0x48, 0x21, 0x37, 0xDB, 0x82, 0xD1, 0x03, 0xFF, 0x0D, 0x02, 0x20, 0x3F,
  0xE0, 0x90, 0x13, 0x03, 0xB8, 0x01, 0xE8, 0x3D, 0xCA, 0x61, 0x50, 0x3B, 0x06, 0x77, 0x03, 0xB0,
  0x67, 0x70, 0x3B, 0x06, 0x77, 0x03, 0xB0, 0x67, 0x70, 0x3B, 0x06, 0x77, 0x03, 0xB0, 0x67, 0x70,
  0x3B, 0x06, 0x77, 0x03, 0xB0, 0x67, 0x70, 0x3B, 0x06, 0x77, 0x03, 0xB0, 0x67, 0x70, 0x3B, 0x06,
  0x77,
  // "Q" (U+0051)
  0x78, 0x66, 0xAD, 0xEF, 0xDA, 0x67, 0x50, 0x50, 0xEF, 0x90, 0xE0, 0x57, 0x20, 0x7F, 0xD0, 0x87,
  0x05, 0xB8, 0x1E, 0x72, 0x28, 0x11, 0x7E, 0xB0, 0x65, 0x01, 0x0E, 0xA0, 0xD0, 0x26, 0x01, 0x0D,
  0xA0, 0xE0, 0x14, 0x08, 0xB0, 0x47, 0x10, 0x3B, 0x08, 0x40, 0xEA, 0x0C, 0x73, 0x0B, 0xA0, 0xE3,
  0x04, 0xB0, 0x67, 0x30, 0x5B, 0x04, 0x20, 0x8B, 0x01, 0x73, 0x01, 0xB0, 0x82, 0x0B, 0xA0, 0xD7,
  0x50, 0xDA, 0x0B, 0x20, 0xEA, 0x0B, 0x75, 0x0B, 0xA0, 0xE2, 0xB0, 0x97, 0x50, 0x9B, 0x10, 0x2B,
  0x08, 0x75, 0x08, 0xB0, 0x02, 0xB0, 0x87, 0x50, 0x8B, 0x02, 0x03, 0xB0, 0x77, 0x50, 0x7B, 0x03,
  0x02, 0xB0, 0x87, 0x50, 0x8B, 0x00, 0x2B, 0x08, 0x75, 0x08, 0xB0, 0x21, 0xB0, 0x97, 0x50, 0x9B,
  0x20, 0xEA, 0x0B, 0x75, 0x0B, 0xA0, 0xE2, 0x0B, 0xA0, 0xD7, 0x50, 0xDA, 0x0C, 0x20, 0x8B, 0x01,
  0x73, 0x01, 0xB0, 0x82, 0x04, 0xB0, 0x57, 0x30, 0x5B, 0x04, 0x30, 0xEA, 0x0B, 0x73, 0x0B, 0xA0,
  0xE4, 0x09, 0xB0, 0x47, 0x10, 0x3B, 0x09, 0x40, 0x10, 0xEA, 0x0D, 0x02, 0x60, 0x20, 0xDB, 0x02,
  0x50, 0x6B, 0x81, 0xE7, 0x22, 0x81, 0x17, 0xEB, 0x07, 0x70, 0x8F, 0xD0, 0x97, 0x20, 0x60, 0xEF,
  0xA0, 0x97, 0x48, 0x51, 0x6B, 0xDF, 0xED, 0xB0, 0xB7, 0x74, 0x08, 0xB0, 0x37, 0x73, 0x01, 0x0E,
  0xA0, 0xB7, 0x74, 0x08, 0xB0, 0x47, 0x73, 0x01, 0xB0, 0xC7, 0x74, 0x08, 0xB0, 0x57, 0x73, 0x01,
  0xB0, 0xD7, 0x74, 0x09, 0xB0, 0x51,
  // "R" (U+0052)
  0x03, 0xF8, 0x3E, 0xDB, 0x84, 0x70, 0x3F, 0xD0, 0xD0, 0x45, 0x03, 0xB8, 0x00, 0xEF, 0x07, 0x40,
  0x3B, 0x06, 0x48, 0x11, 0x5B, 0xC0, 0x43, 0x03, 0xB0, 0x67, 0x07, 0xB0, 0xC3, 0x03, 0xB0, 0x67,
  0x10, 0xBB, 0x02, 0x20, 0x3B, 0x06, 0x71, 0x06, 0xB0, 0x52, 0x03, 0xB0, 0x67, 0x10, 0x4B, 0x07,
  0x20, 0x3B, 0x06, 0x71, 0x03, 0xB0, 0x72, 0x03, 0xB0, 0x67, 0x10, 0x4B, 0x06, 0x20, 0x3B, 0x06,
  0x71, 0x07, 0xB0, 0x32, 0x03, 0xB0, 0x67, 0x10, 0xDA, 0x0E, 0x30, 0x3B, 0x06, 0x70, 0x9B, 0x07,
  0x30, 0x3B, 0x06, 0x48, 0x11, 0x5C, 0xB0, 0xB4, 0x03, 0xB8, 0x00, 0xEE, 0x0B, 0x50, 0x3F, 0xC0,
  0xD0, 0x56, 0x03, 0xFC, 0x06, 0x70, 0x3B, 0x06, 0x40, 0xCA, 0x0E, 0x01, 0x60, 0x3B, 0x06, 0x40,
  0x4B, 0x08, 0x60, 0x3B, 0x06, 0x50, 0xAB, 0x02, 0x50, 0x3B, 0x06, 0x50, 0x2B, 0x0B, 0x50, 0x3B,
  0x06, 0x60, 0x8B, 0x05, 0x40, 0x3B, 0x06, 0x70, 0xEA, 0x0D, 0x40, 0x3B, 0x06, 0x70, 0x6B, 0x08,
  0x30, 0x3B, 0x06, 0x71, 0x0C, 0xB0, 0x22, 0x03, 0xB0, 0x67, 0x10, 0x3B, 0x0A, 0x20, 0x3B, 0x06,
  0x72, 0x0A, 0xB8, 0x14, 0x03, 0xB0, 0x67, 0x20, 0x2B, 0x81, 0xD0, 0x3B, 0x06, 0x73, 0x08, 0xB0,
  0x70,
  // "S" (U+0053)
  0x58, 0x91, 0x28, 0xBD, 0xEF, 0xED, 0xA7, 0x36, 0x01, 0x0A, 0xFC, 0x0E, 0x04, 0x30, 0x20, 0xEF,
  0xE0, 0x33, 0x0D, 0xB8, 0x1C, 0x61, 0x38, 0x33, 0x6B, 0xFD, 0x30, 0x5B, 0x0A, 0x72, 0x02, 0x04,
  0x30, 0xAB, 0x01, 0x77, 0x0D, 0xA0, 0xC7, 0x71, 0x0E, 0xA0, 0xB7, 0x71, 0x0D, 0xA0, 0xD7, 0x71,
  0x0B, 0xB0, 0x37, 0x70, 0x6B, 0x0E, 0x03, 0x77, 0x0D, 0xC0, 0x90, 0x27, 0x50, 0x20, 0xED, 0x0A,
  0x03, 0x74, 0x02, 0x0C, 0xE0, 0xC0, 0x57, 0x40, 0x50, 0xDE, 0x0C, 0x04, 0x74, 0x05, 0x0C, 0xE0,
  0x97, 0x50, 0x40, 0xBD, 0x09, 0x76, 0x03, 0x0C, 0xC0, 0x67, 0x70, 0x8B, 0x0C, 0x77, 0x10, 0xCB,
  0x77, 0x10, 0x9B, 0x02, 0x77, 0x08, 0xB0, 0x17, 0x70, 0xAB, 0x77, 0x01, 0x0E, 0xA8, 0x2C, 0x04,
  0x37, 0x40, 0xBB, 0x86, 0x60, 0x9F, 0xD9, 0x52, 0x48, 0x12, 0x6D, 0xB0, 0xD2, 0x09, 0xF0, 0xEE,
  0x0D, 0x02, 0x20, 0x6F, 0xE0, 0xA0, 0x15, 0x83, 0x48, 0xAD, 0xEA, 0x83, 0xED, 0xA7, 0x15,
  // "T" (U+0054)
  0x03, 0xFF, 0xE0, 0x03, 0xFF, 0xE0, 0x30, 0x28, 0x04, 0xEC, 0x80, 0x4E, 0x02, 0x72, 0x0C, 0xA0,
  0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0,
  0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0,
  0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0,
  0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0,
  0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0,
  0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0,
  0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x20,
  // "U" (U+0055)
  0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B,
  0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06,
  0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30,
  0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73,
  0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67,
  0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06,
  0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x03, 0x01, 0xB0, 0x77, 0x30, 0x7B, 0x01, 0x1B,
  0x08, 0x73, 0x08, 0xB2, 0x0E, 0xA0, 0xB7, 0x30, 0xBA, 0x0E, 0x20, 0xAA, 0x0E, 0x73, 0x0E, 0xA0,
  0xA2, 0x06, 0xB0, 0x57, 0x10, 0x5B, 0x06, 0x20, 0x1B, 0x0E, 0x02, 0x60, 0x10, 0xEA, 0x0E, 0x01,
  0x30, 0x8B, 0x81, 0xE7, 0x12, 0x81, 0x15, 0xDB, 0x07, 0x50, 0xBF, 0xD0, 0xA7, 0x09, 0xFB, 0x08,
  0x72, 0x82, 0x28, 0xCE, 0xA8, 0x2E, 0xB7, 0x15,
  // "V" (U+0056)
  0x0D, 0xA0, 0xE7, 0x70, 0xEA, 0x0D, 0x08, 0xB0, 0x37, 0x50, 0x3B, 0x08, 0x03, 0xB0, 0x77, 0x50,
  0x7B, 0x81, 0x30, 0xDA, 0x0C, 0x75, 0x0C, 0xA0, 0xD2, 0x08, 0xB0, 0x17, 0x30, 0x1B, 0x09, 0x20,
  0x3B, 0x05, 0x73, 0x05, 0xB0, 0x43, 0x0E, 0xA0, 0xA7, 0x30, 0xAA, 0x0E, 0x40, 0x9A, 0x0E, 0x73,
  0x0E, 0xA0, 0xA4, 0x04, 0xB0, 0x47, 0x10, 0x3B, 0x05, 0x50, 0xEA, 0x08, 0x71, 0x07, 0xB6, 0x0A,
  0xA0, 0xD7, 0x10, 0xCA, 0x0B, 0x60, 0x5B, 0x02, 0x60, 0x1B, 0x06, 0x7B, 0x06, 0x60, 0x5B, 0x01,
  0x70, 0xBA, 0x0B, 0x60, 0xAA, 0x0C, 0x71, 0x06, 0xB6, 0x0E, 0xA0, 0x77, 0x10, 0x1B, 0x04, 0x40,
  0x3B, 0x02, 0x72, 0x0B, 0xA0, 0x94, 0x07, 0xA0, 0xD7, 0x30, 0x6A, 0x0D, 0x40, 0xCA, 0x08, 0x73,
  0x02, 0xB0, 0x32, 0x01, 0xB0, 0x37, 0x40, 0xCA, 0x07, 0x20, 0x5A, 0x0E, 0x75, 0x07, 0xA0, 0xB2,
  0x09, 0xA0, 0x97, 0x50, 0x2B, 0x81, 0x10, 0xDA, 0x04, 0x76, 0x0D, 0xA0, 0x50, 0x2A, 0x0E, 0x77,
  0x08, 0xA0, 0x80, 0x5A, 0x0A, 0x77, 0x03, 0xA0, 0xC0, 0x9A, 0x05, 0x77, 0x10, 0xDA, 0x0D, 0xA0,
  0x17, 0x71, 0x09, 0xC0, 0xB7, 0x72, 0x04, 0xC0, 0x67, 0x73, 0x0E, 0xB0, 0x17, 0x10,
  // "W" (U+0057)
  0x0E, 0xA0, 0x57, 0x70, 0x5A, 0x0E, 0x0D, 0xA0, 0x77, 0x70, 0x6A, 0x0D, 0x0B, 0xA0, 0x87, 0x70,
  0x8A, 0x0B, 0x09, 0xA0, 0xA7, 0x70, 0x9A, 0x0A, 0x07, 0xA0, 0xB7, 0x70, 0xAA, 0x08, 0x06, 0xA0,
  0xD7, 0x70, 0xCA, 0x07, 0x04, 0xA0, 0xE7, 0x70, 0xDA, 0x05, 0x02, 0xB5, 0x0C, 0xA0, 0xD5, 0x0E,
  0xA0, 0x30, 0x1B, 0x01, 0x4C, 0x01, 0x4B, 0x81, 0x20, 0xEA, 0x03, 0x30, 0x3C, 0x05, 0x30, 0x2B,
  0x20, 0xDA, 0x04, 0x30, 0x7A, 0x81, 0xEF, 0x93, 0x03, 0xA0, 0xE2, 0x0B, 0xA0, 0x63, 0x84, 0xBF,
  0xDB, 0xFC, 0x30, 0x4A, 0x0D, 0x20, 0x9A, 0x07, 0x38, 0x2E, 0xFB, 0x8A, 0x30, 0x6A, 0x0B, 0x20,
  0x7A, 0x09, 0x20, 0x2A, 0x08, 0x05, 0xA0, 0x42, 0x07, 0xA0, 0xA2, 0x06, 0xA0, 0xA2, 0x06, 0xA0,
  0x40, 0x2A, 0x07, 0x20, 0x8A, 0x08, 0x20, 0x4A, 0x0B, 0x20, 0x9A, 0x83, 0x10, 0xEF, 0xB2, 0x09,
  0xA0, 0x72, 0x02, 0xA0, 0xD2, 0x81, 0xDF, 0xD2, 0x81, 0xBF, 0xE2, 0x0A, 0xA0, 0x52, 0x01, 0xA0,
  0xE2, 0xA0, 0x92, 0x07, 0xA8, 0x13, 0x0B, 0xA0, 0x43, 0x0E, 0xA1, 0x04, 0xA0, 0x62, 0x03, 0xA8,
  0x16, 0x0C, 0xA0, 0x23, 0x0D, 0xA1, 0x07, 0xA0, 0x33, 0xA8, 0x1A, 0x0D, 0xA0, 0x13, 0x0B, 0xA8,
  0x22, 0xAF, 0xE4, 0x83, 0xBF, 0xD0, 0xEA, 0x40, 0x9A, 0x82, 0x3D, 0xFB, 0x40, 0x8A, 0x01, 0xA0,
  0xD4, 0x08, 0xA0, 0x5A, 0x07, 0x40, 0x4A, 0x05, 0xA0, 0xB4, 0x06, 0xA0, 0x9A, 0x04, 0x40, 0x1A,
  0x09, 0xA0, 0xA4, 0x04, 0xA0, 0xCA, 0x01, 0x58, 0x1C, 0xFC, 0xA0, 0x84, 0x02, 0xC0, 0xD6, 0x09,
  0xC0, 0x74, 0x01, 0xC0, 0x96, 0x05, 0xC0, 0x55, 0x0E, 0xB0, 0x56, 0x01, 0xC0, 0x45, 0x0D, 0xB0,
  0x27, 0x0D, 0xB0, 0x22,
  // "X" (U+0058)
  0x10, 0xBB, 0x02, 0x73, 0x01, 0x0E, 0xA0, 0xA2, 0x02, 0xB0, 0xA7, 0x30, 0x9B, 0x02, 0x30, 0x8B,
  0x03, 0x71, 0x02, 0xB0, 0x85, 0x0D, 0xA0, 0xC7, 0x10, 0xBA, 0x0E, 0x60, 0x5B, 0x05, 0x60, 0x4B,
  0x05, 0x70, 0xBA, 0x0D, 0x60, 0xCA, 0x0C, 0x71, 0x03, 0xB0, 0x64, 0x06, 0xB0, 0x37, 0x20, 0x9A,
  0x0E, 0x40, 0xDA, 0x09, 0x73, 0x01, 0x0E, 0xA0, 0x72, 0x07, 0xA0, 0xE0, 0x17, 0x40, 0x6A, 0x82,
  0xE1, 0x1E, 0xA0, 0x77, 0x60, 0xCA, 0x00, 0x9A, 0x0D, 0x77, 0x03, 0xE0, 0x47, 0x71, 0x0A, 0xC0,
  0xA7, 0x72, 0x01, 0x0E, 0xB0, 0x27, 0x73, 0x0D, 0xA0, 0xD7, 0x73, 0x07, 0xC0, 0x77, 0x71, 0x02,
  0xE0, 0x27, 0x70, 0xAA, 0x0C, 0x0B, 0xA0, 0xA7, 0x60, 0x4B, 0x03, 0x02, 0xB0, 0x47, 0x50, 0xDA,
  0x0A, 0x20, 0x8A, 0x0D, 0x74, 0x07, 0xB0, 0x12, 0x01, 0x0E, 0xA0, 0x77, 0x20, 0x2B, 0x08, 0x40,
  0x6B, 0x02, 0x71, 0x0A, 0xA0, 0xD6, 0x0C, 0xA0, 0xA7, 0x04, 0xB0, 0x56, 0x04, 0xB0, 0x46, 0x0D,
  0xA0, 0xC7, 0x10, 0xAA, 0x0D, 0x50, 0x7B, 0x03, 0x71, 0x02, 0xB0, 0x73, 0x02, 0xB0, 0xA7, 0x30,
  0x8A, 0x0E, 0x02, 0x20, 0xAB, 0x01, 0x73, 0x01, 0x0E, 0xA8, 0x1A, 0x04, 0xB0, 0x87, 0x50, 0x6B,
  0x04,
  // "Y" (U+0059)
  0x05, 0xB0, 0x97, 0x50, 0x7B, 0x81, 0x50, 0xDA, 0x0E, 0x01, 0x74, 0x0D, 0xA0, 0xC2, 0x05, 0xB0,
  0x77, 0x30, 0x5B, 0x05, 0x30, 0xDA, 0x0E, 0x73, 0x0C, 0xA0, 0xD4, 0x05, 0xB0, 0x67, 0x10, 0x4B,
  0x05, 0x50, 0xDA, 0x0D, 0x71, 0x0B, 0xA0, 0xD6, 0x05, 0xB0, 0x46, 0x02, 0xB0, 0x57, 0x0D, 0xA0,
  0xB6, 0x0A, 0xA0, 0xD7, 0x10, 0x5B, 0x03, 0x40, 0x1B, 0x05, 0x72, 0x0D, 0xA0, 0xA4, 0x08, 0xA0,
  0xD7, 0x30, 0x5B, 0x01, 0x30, 0xEA, 0x05, 0x74, 0x0D, 0xA0, 0x82, 0x07, 0xA0, 0xD7, 0x50, 0x5A,
  0x82, 0xE1, 0x0D, 0xA0, 0x57, 0x60, 0xDA, 0x07, 0x05, 0xA0, 0xD7, 0x70, 0x5A, 0x0D, 0x0C, 0xA0,
  0x57, 0x71, 0x0D, 0xC0, 0xD7, 0x72, 0x05, 0xC0, 0x57, 0x73, 0x0D, 0xA0, 0xD7, 0x74, 0x0B, 0xA0,
  0xB7, 0x74, 0x0B, 0xA0, 0xB7, 0x74, 0x0B, 0xA0, 0xB7, 0x74, 0x0B, 0xA0, 0xB7, 0x74, 0x0B, 0xA0,
  0xB7, 0x74, 0x0B, 0xA0, 0xB7, 0x74, 0x0B, 0xA0, 0xB7, 0x74, 0x0B, 0xA0, 0xB7, 0x74, 0x0B, 0xA0,
  0xB7, 0x74, 0x0B, 0xA0, 0xB7, 0x74, 0x0B, 0xA0, 0xB7, 0x20,
  // "Z" (U+005A)
  0x10, 0x6F, 0xF9, 0x81, 0x30, 0x6F, 0xF9, 0x81, 0x30, 0x58, 0x07, 0xEC, 0x02, 0x76, 0x0C, 0xA0,
  0xB7, 0x60, 0x5B, 0x03, 0x76, 0x0D, 0xA0, 0xA7, 0x60, 0x6B, 0x02, 0x76, 0x0E, 0xA0, 0x97, 0x60,
  0x8B, 0x01, 0x75, 0x01, 0x0E, 0xA0, 0x87, 0x60, 0x9A, 0x0E, 0x01, 0x75, 0x02, 0xB0, 0x77, 0x60,
  0xAA, 0x0E, 0x76, 0x03, 0xB0, 0x67, 0x60, 0xBA, 0x0D, 0x76, 0x04, 0xB0, 0x57, 0x60, 0xCA, 0x0C,
  0x76, 0x06, 0xB0, 0x47, 0x60, 0xDA, 0x0B, 0x76, 0x07, 0xB0, 0x37, 0x50, 0x10, 0xEA, 0x0A, 0x76,
  0x08, 0xB0, 0x27, 0x50, 0x1B, 0x09, 0x76, 0x09, 0xA0, 0xE0, 0x17, 0x50, 0x2B, 0x08, 0x76, 0x0B,
  0xA0, 0xE7, 0x60, 0x2C, 0x80, 0x90, 0xE0, 0x20, 0x3F, 0xFA, 0x00, 0x3F, 0xFA, 0x03,
  // "[" (U+005B)
  0x06, 0xF9, 0x09, 0x06, 0xF9, 0x09, 0x06, 0xB8, 0x01, 0xE0, 0x80, 0x6B, 0x60, 0x6B, 0x60, 0x6B,
  0x60, 0x6B, 0x60, 0x6B, 0x60, 0x6B, 0x60, 0x6B, 0x60, 0x6B, 0x60, 0x6B, 0x60, 0x6B, 0x60, 0x6B,
  0x60, 0x6B, 0x60, 0x6B, 0x60, 0x6B, 0x60, 0x6B, 0x60, 0x6B, 0x60, 0x6B, 0x60, 0x6B, 0x60, 0x6B,
  0x60, 0x6B, 0x60, 0x6B, 0x60, 0x6B, 0x60, 0x6B, 0x60, 0x6B, 0x60, 0x6B, 0x60, 0x6B, 0x60, 0x6B,
  0x60, 0x6B, 0x60, 0x6B, 0x60, 0x6B, 0x80, 0x1E, 0x08, 0x06, 0xF9, 0x09, 0x06, 0xF9, 0x09,
  // "\" (U+005C)
  0x0E, 0xA0, 0x67, 0x30, 0x9A, 0x0C, 0x73, 0x04, 0xB0, 0x27, 0x30, 0xDA, 0x08, 0x73, 0x07, 0xA0,
  0xE7, 0x30, 0x2B, 0x04, 0x73, 0x0B, 0xA0, 0xA7, 0x30, 0x5B, 0x01, 0x73, 0x0E, 0xA0, 0x67, 0x30,
  0x9A, 0x0C, 0x73, 0x03, 0xB0, 0x37, 0x30, 0xDA, 0x09, 0x73, 0x07, 0xA0, 0xE7, 0x30, 0x1B, 0x05,
  0x73, 0x0B, 0xA0, 0xB7, 0x30, 0x5B, 0x01, 0x73, 0x0E, 0xA0, 0x77, 0x30, 0x9A, 0x0D, 0x73, 0x03,
  0xB0, 0x37, 0x30, 0xCA, 0x09, 0x73, 0x07, 0xA0, 0xE7, 0x30, 0x1B, 0x05, 0x73, 0x0A, 0xA0, 0xB7,
  0x30, 0x4B, 0x01, 0x73, 0x0E, 0xA0, 0x77, 0x30, 0x8A, 0x0D, 0x73, 0x02, 0xB0, 0x37, 0x30, 0xCA,
  0x09, 0x73, 0x06, 0xA0, 0xE0,
  // "]" (U+005D)
  0x09, 0xF9, 0x06, 0x09, 0xF9, 0x06, 0x08, 0x80, 0x1E, 0xB0, 0x66, 0xB0, 0x66, 0xB0, 0x66, 0xB0,
  0x66, 0xB0, 0x66, 0xB0, 0x66, 0xB0, 0x66, 0xB0, 0x66, 0xB0, 0x66, 0xB0, 0x66, 0xB0, 0x66, 0xB0,
  0x66, 0xB0, 0x66, 0xB0, 0x66, 0xB0, 0x66, 0xB0, 0x66, 0xB0, 0x66, 0xB0, 0x66, 0xB0, 0x66, 0xB0,
  0x66, 0xB0, 0x66, 0xB0, 0x66, 0xB0, 0x66, 0xB0, 0x66, 0xB0, 0x66, 0xB0, 0x66, 0xB0, 0x66, 0xB0,
  0x66, 0xB0, 0x66, 0xB0, 0x60, 0x88, 0x01, 0xEB, 0x06, 0x09, 0xF9, 0x06, 0x09, 0xF9, 0x06,
  // "^" (U+005E)
  0x71, 0x81, 0xAF, 0xC7, 0x72, 0x02, 0xB0, 0x57, 0x71, 0x09, 0xB0, 0xD7, 0x70, 0x1D, 0x06, 0x76,
  0x09, 0xA8, 0x25, 0xEF, 0xD7, 0x58, 0x41, 0xEF, 0xC0, 0x7A, 0x06, 0x74, 0x08, 0xA8, 0x45, 0x01,
  0xEF, 0xE7, 0x48, 0x1E, 0xFD, 0x30, 0x7A, 0x07, 0x72, 0x07, 0xA0, 0x64, 0x82, 0xEF, 0xE1, 0x71,
  0x81, 0xEF, 0xE5, 0x07, 0xA0, 0x87, 0x06, 0xA0, 0x86, 0x82, 0xEF, 0xE1, 0x60, 0xDA, 0x01, 0x60,
  0x6A, 0x09, 0x50, 0x6A, 0x09, 0x71, 0x0D, 0xA0, 0x24, 0x0D, 0xA0, 0x27, 0x10, 0x6A, 0x09, 0x30,
  0x5A, 0x0B, 0x73, 0x0D, 0xA0, 0x22, 0x0C, 0xA0, 0x47, 0x30, 0x6A, 0x81, 0xA0, 0x4A, 0x0C, 0x75,
  0x0D, 0xA0, 0x30, 0xBA, 0x05, 0x75, 0x05, 0xA0, 0xB0,
  // "_" (U+005F)
  0x80, 0xA4, 0xE8, 0x0D, 0x4F,
  // "`" (U+0060)
  0x83, 0x37, 0x77, 0x64, 0x01, 0x0E, 0xB0, 0x44, 0x04, 0xB0, 0xD5, 0x05, 0xB0, 0x75, 0x06, 0xB0,
  0x25, 0x07, 0xA0, 0xC6, 0x05, 0xA0, 0x70,
  // "a" (U+0061)
  0x58, 0x25, 0x9C, 0xEA, 0x82, 0xEB, 0x82, 0x60, 0x20, 0x9F, 0xC0, 0x95, 0x06, 0xE0, 0xEE, 0x0C,
  0x58, 0x3D, 0xE9, 0x52, 0x38, 0x11, 0x5C, 0xB0, 0x74, 0x02, 0x73, 0x0A, 0xA0, 0xE7, 0x71, 0x02,
  0xB0, 0x37, 0x71, 0x0E, 0xA0, 0x57, 0x71, 0x0D, 0xA0, 0x65, 0x83, 0x37, 0xAC, 0xD8, 0x01, 0xEB,
  0x06, 0x30, 0x30, 0xCF, 0xE0, 0x62, 0x05, 0xFF, 0x98, 0x16, 0x02, 0xC8, 0x2C, 0x63, 0x15, 0x0D,
  0xA8, 0x16, 0x0A, 0xB0, 0x77, 0x20, 0xDA, 0x81, 0x60, 0xEA, 0x0A, 0x73, 0x0E, 0xA0, 0x60, 0x1B,
  0x04, 0x72, 0x01, 0xB0, 0x60, 0x2B, 0x03, 0x72, 0x06, 0xB0, 0x60, 0x1B, 0x05, 0x71, 0x01, 0x0D,
  0xB8, 0x16, 0x0E, 0xA0, 0xB7, 0x01, 0x0C, 0xC8, 0x16, 0x09, 0xB0, 0xB0, 0x43, 0x84, 0x38, 0xEF,
  0xEE, 0xA8, 0x26, 0x01, 0xED, 0x0E, 0xC8, 0x1E, 0x2C, 0xA0, 0x62, 0x02, 0x0D, 0xF9, 0x82, 0xB2,
  0x0A, 0xA0, 0x64, 0x86, 0x5B, 0xDF, 0xED, 0x94, 0x30, 0x8A, 0x06,
  // "b" (U+0062)
  0x0C, 0xA0, 0xA7, 0x71, 0x0C, 0xA0, 0xA7, 0x71, 0x0C, 0xA0, 0xA7, 0x71, 0x0C, 0xA0, 0xA7, 0x71,
  0x0C, 0xA0, 0xA7, 0x71, 0x0C, 0xA0, 0xA7, 0x71, 0x0C, 0xA0, 0xA7, 0x71, 0x0C, 0xA0, 0xA7, 0x71,
  0x0C, 0xA0, 0xA7, 0x71, 0x0C, 0xA0, 0xA2, 0x86, 0x28, 0xCE, 0xED, 0xA5, 0x50, 0xCA, 0x81, 0x90,
  0x8F, 0x90, 0xC0, 0x23, 0x0C, 0xA0, 0x80, 0x9C, 0x0E, 0xD0, 0xE0, 0x32, 0x0C, 0xA0, 0xEA, 0x0B,
  0x04, 0x30, 0x40, 0xCB, 0x0D, 0x20, 0xCC, 0x09, 0x70, 0xAB, 0x81, 0x70, 0xCB, 0x0D, 0x72, 0x0E,
  0xA8, 0x1E, 0x0C, 0xB0, 0x67, 0x20, 0x8B, 0x03, 0x0C, 0xB0, 0x17, 0x20, 0x3B, 0x07, 0x0C, 0xA0,
  0xD7, 0x30, 0x1B, 0x09, 0x0C, 0xA0, 0xB7, 0x40, 0xEA, 0x0B, 0x0C, 0xA0, 0xA7, 0x40, 0xDA, 0x0B,
  0x0C, 0xA0, 0xB7, 0x40, 0xEA, 0x0B, 0x0C, 0xA0, 0xB7, 0x40, 0xEA, 0x0A, 0x0C, 0xA0, 0xD7, 0x30,
  0x1B, 0x09, 0x0C, 0xB0, 0x17, 0x20, 0x3B, 0x06, 0x0C, 0xB0, 0x67, 0x20, 0x8B, 0x03, 0x0C, 0xB0,
  0xC7, 0x20, 0xEA, 0x81, 0xD0, 0xCC, 0x08, 0x70, 0xAB, 0x81, 0x70, 0xCA, 0x0E, 0xA0, 0xB0, 0x43,
  0x04, 0x0B, 0xB0, 0xD2, 0x0C, 0xA0, 0x50, 0xBC, 0x0E, 0xD0, 0xE0, 0x22, 0x0C, 0xA8, 0x13, 0x09,
  0xF9, 0x0C, 0x02, 0x30, 0xCA, 0x02, 0x28, 0x62, 0x9C, 0xEF, 0xDA, 0x55,
  // "c" (U+0063)
  0x68, 0x24, 0x9C, 0xEA, 0x82, 0xEB, 0x84, 0x60, 0x50, 0xDF, 0xB0, 0xD0, 0x13, 0x09, 0xFD, 0x0C,
  0x30, 0x7C, 0x81, 0x94, 0x12, 0x83, 0x14, 0x9F, 0x72, 0x02, 0xB0, 0xE0, 0x47, 0x10, 0x20, 0x12,
  0x0A, 0xB0, 0x57, 0x60, 0xEA, 0x0D, 0x76, 0x03, 0xB0, 0x77, 0x60, 0x6B, 0x04, 0x76, 0x08, 0xB0,
  0x27, 0x60, 0x8B, 0x01, 0x76, 0x08, 0xB0, 0x17, 0x60, 0x7B, 0x02, 0x76, 0x06, 0xB0, 0x47, 0x60,
  0x4B, 0x07, 0x76, 0x01, 0xB0, 0xC7, 0x70, 0xBB, 0x04, 0x76, 0x04, 0xB0, 0xE0, 0x37, 0x60, 0xAC,
  0x09, 0x03, 0x48, 0x22, 0x6A, 0xE4, 0x0B, 0xFD, 0x0E, 0x50, 0x70, 0xEF, 0xB0, 0xE7, 0x89, 0x16,
  0xAD, 0xEF, 0xED, 0xB9, 0x51, 0x10,
  // "d" (U+0064)
  0x77, 0x10, 0xBA, 0x0C, 0x77, 0x10, 0xBA, 0x0C, 0x77, 0x10, 0xBA, 0x0C, 0x77, 0x10, 0xBA, 0x0C,
  0x77, 0x10, 0xBA, 0x0C, 0x77, 0x10, 0xBA, 0x0C, 0x77, 0x10, 0xBA, 0x0C, 0x77, 0x10, 0xBA, 0x0C,
  0x77, 0x10, 0xBA, 0x0C, 0x58, 0x65, 0x9D, 0xEF, 0xDA, 0x42, 0x0B, 0xA0, 0xC3, 0x03, 0x0C, 0xF9,
  0x81, 0xA0, 0xAA, 0x0C, 0x20, 0x30, 0xEF, 0xB0, 0xA0, 0x9A, 0x82, 0xC0, 0x1E, 0xB8, 0x1D, 0x51,
  0x20, 0x30, 0xAA, 0x0E, 0xA8, 0x1C, 0x08, 0xB0, 0xC0, 0x16, 0x09, 0xC8, 0x1C, 0x0E, 0xB0, 0x27,
  0x10, 0xDB, 0x0C, 0x04, 0xB0, 0x97, 0x20, 0x6B, 0x0C, 0x07, 0xB0, 0x47, 0x20, 0x2B, 0x0C, 0x0A,
  0xB0, 0x17, 0x30, 0xEA, 0x0C, 0x0B, 0xA0, 0xE7, 0x40, 0xDA, 0x00, 0xCA, 0x0E, 0x74, 0x0C, 0xA0,
  0xC0, 0xBA, 0x0D, 0x74, 0x0B, 0xA0, 0xC0, 0xBA, 0x0E, 0x74, 0x0C, 0xA0, 0xC0, 0x9B, 0x74, 0x0D,
  0xA0, 0xC0, 0x7B, 0x03, 0x73, 0xB0, 0xC0, 0x3B, 0x07, 0x72, 0x05, 0xB8, 0x1C, 0x0E, 0xA0, 0xE7,
  0x20, 0xCB, 0x81, 0xC0, 0x8B, 0x0A, 0x70, 0x7C, 0x0C, 0x20, 0xDB, 0x0C, 0x04, 0x30, 0x30, 0xAA,
  0x0E, 0xA0, 0xC2, 0x03, 0x0E, 0xD0, 0xEC, 0x0A, 0x07, 0xA0, 0xC3, 0x02, 0x0C, 0xF9, 0x81, 0x90,
  0x5A, 0x0C, 0x58, 0x65, 0xAD, 0xEE, 0xD9, 0x32, 0x03, 0xA0, 0xC0,
  // "e" (U+0065)
  0x68, 0x74, 0x9C, 0xEF, 0xEC, 0x83, 0x72, 0x02, 0x0C, 0xFA, 0x0A, 0x70, 0x5E, 0x0E, 0xD0, 0xC0,
  0x14, 0x04, 0xC0, 0xA0, 0x33, 0x03, 0x0B, 0xB0, 0xA4, 0x0D, 0xB0, 0x57, 0x09, 0xB0, 0x52, 0x07,
  0xB0, 0x77, 0x20, 0xDA, 0x0B, 0x20, 0xDA, 0x0D, 0x73, 0x07, 0xB0, 0x10, 0x2B, 0x07, 0x73, 0x02,
  0xB0, 0x05, 0xB0, 0x37, 0x4B, 0x00, 0x7F, 0xFC, 0x00, 0x8F, 0xFC, 0x09, 0x08, 0xB8, 0x09, 0x3E,
  0x08, 0x07, 0xB0, 0x17, 0x71, 0x06, 0xB0, 0x37, 0x71, 0x02, 0xB0, 0x67, 0x72, 0x0E, 0xA0, 0xB7,
  0x72, 0x07, 0xB0, 0x57, 0x72, 0x0E, 0xB0, 0x57, 0x30, 0x20, 0x43, 0x03, 0xC8, 0x1B, 0x62, 0x38,
  0x41, 0x37, 0xBF, 0x94, 0x04, 0x0E, 0xE0, 0xEE, 0x09, 0x50, 0x10, 0xAF, 0xC0, 0xE0, 0x67, 0x89,
  0x12, 0x7A, 0xDE, 0xFE, 0xDB, 0x84, 0x30,
  // "f" (U+0066)
  0x74, 0x89, 0x06, 0xAD, 0xEF, 0xED, 0xB8, 0x37, 0x20, 0x40, 0xEF, 0xA0, 0x97, 0x10, 0x3F, 0xC0,
  0x47, 0x10, 0xCB, 0x81, 0xB4, 0x12, 0x81, 0x13, 0x67, 0x10, 0x2B, 0x0C, 0x77, 0x20, 0x4B, 0x06,
  0x77, 0x20, 0x5B, 0x04, 0x77, 0x20, 0x5B, 0x03, 0x77, 0x20, 0x5B, 0x03, 0x72, 0x85, 0x28, 0x9A,
  0xBD, 0xEF, 0xD8, 0x14, 0x05, 0xFF, 0xC8, 0x14, 0x05, 0x80, 0x3E, 0xB8, 0x04, 0xE0, 0x47, 0x10,
  0x5B, 0x03, 0x77, 0x20, 0x5B, 0x03, 0x77, 0x20, 0x5B, 0x03, 0x77, 0x20, 0x5B, 0x03, 0x77, 0x20,
  0x5B, 0x03, 0x77, 0x20, 0x5B, 0x03, 0x77, 0x20, 0x5B, 0x03, 0x77, 0x20, 0x5B, 0x03, 0x77, 0x20,
  0x5B, 0x03, 0x77, 0x20, 0x5B, 0x03, 0x77, 0x20, 0x5B, 0x03, 0x77, 0x20, 0x5B, 0x03, 0x77, 0x20,
  0x5B, 0x03, 0x77, 0x20, 0x5B, 0x03, 0x77, 0x20, 0x5B, 0x03, 0x77, 0x20, 0x5B, 0x03, 0x77, 0x20,
  0x5B, 0x03, 0x77, 0x20, 0x5B, 0x03, 0x77, 0x20, 0x5B, 0x03, 0x72,
  // "g" (U+0067)
  0x58, 0x64, 0x9D, 0xEE, 0xD9, 0x42, 0x02, 0xA0, 0xC3, 0x01, 0x0B, 0xF9, 0x81, 0x90, 0x4A, 0x0C,
  0x20, 0x10, 0xDF, 0xB0, 0xA0, 0x7A, 0x0C, 0x20, 0xCB, 0x81, 0xC5, 0x12, 0x03, 0x09, 0xA0, 0xEA,
  0x81, 0xC0, 0x6B, 0x0B, 0x70, 0x5C, 0x81, 0xC0, 0xCA, 0x0E, 0x01, 0x71, 0x09, 0xB0, 0xC0, 0x3B,
  0x08, 0x72, 0x01, 0xB0, 0xC0, 0x6B, 0x04, 0x73, 0x0C, 0xA0, 0xC0, 0x9B, 0x01, 0x73, 0x09, 0xA0,
  0xC0, 0xAA, 0x0E, 0x74, 0x07, 0xA0, 0xC0, 0xBA, 0x0D, 0x74, 0x07, 0xA0, 0x0C, 0xA0, 0xD7, 0x40,
  0x6A, 0x0C, 0x0B, 0xA0, 0xE7, 0x40, 0x7A, 0x0C, 0x09, 0xB0, 0x17, 0x30, 0x8A, 0x0C, 0x07, 0xB0,
  0x47, 0x30, 0xAA, 0x0C, 0x03, 0xB0, 0x87, 0x30, 0xEA, 0x81, 0xC0, 0xDA, 0x0E, 0x01, 0x71, 0x06,
  0xB8, 0x1C, 0x07, 0xB0, 0xB7, 0x03, 0x0E, 0xB0, 0xC2, 0x0C, 0xB8, 0x1D, 0x51, 0x28, 0x12, 0x8E,
  0xC0, 0xC2, 0x02, 0x0E, 0xFB, 0x0E, 0x09, 0xA0, 0xC3, 0x02, 0x0B, 0xF9, 0x81, 0xE3, 0x8A, 0x0C,
  0x58, 0x91, 0x49, 0xDE, 0xFD, 0xB7, 0x10, 0x8A, 0x0C, 0x77, 0x10, 0x8A, 0x0C, 0x77, 0x10, 0x9A,
  0x0B, 0x77, 0x10, 0xCA, 0x0A, 0x77, 0x01, 0xB0, 0x77, 0x70, 0x8B, 0x82, 0x30, 0x74, 0x73, 0x04,
  0xB0, 0xC2, 0x84, 0xAF, 0xD9, 0x52, 0x40, 0x40, 0x9C, 0x04, 0x20, 0xAE, 0x0E, 0xF0, 0x73, 0x06,
  0x0D, 0xFC, 0x0D, 0x05, 0x68, 0x33, 0x7A, 0xCE, 0xA8, 0x2E, 0xC9, 0x55,
  // "h" (U+0068)
  0x0C, 0xA0, 0xC7, 0x70, 0xCA, 0x0C, 0x77, 0x0C, 0xA0, 0xC7, 0x70, 0xCA, 0x0C, 0x77, 0x0C, 0xA0,
  0xC7, 0x70, 0xCA, 0x0C, 0x77, 0x0C, 0xA0, 0xC7, 0x70, 0xCA, 0x0C, 0x77, 0x0C, 0xA0, 0xC7, 0x70,
  0xCA, 0x0C, 0x38, 0x66, 0xBD, 0xFE, 0xC8, 0x13, 0x0C, 0xA8, 0x2B, 0x04, 0xEF, 0x90, 0x62, 0x0C,
  0xA0, 0xB0, 0x4C, 0x0E, 0xE8, 0x17, 0x0C, 0xA8, 0x4B, 0xDF, 0xD5, 0x12, 0x03, 0x0B, 0xC0, 0x10,
  0xCC, 0x0C, 0x01, 0x60, 0xBB, 0x07, 0x0C, 0xB0, 0xE0, 0x17, 0x02, 0xB0, 0xB0, 0xCB, 0x08, 0x72,
  0x0C, 0xA0, 0xE0, 0xCB, 0x03, 0x72, 0x0A, 0xB0, 0xCB, 0x73, 0x09, 0xB0, 0xCA, 0x0D, 0x73, 0x09,
  0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0,
  0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA,
  0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C,
  0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0,
  // "i" (U+0069)
  0x78, 0x34, 0xDE, 0xA1, 0x76, 0x01, 0x0E, 0xB0, 0x97, 0x60, 0x3C, 0x0B, 0x77, 0x0E, 0xB0, 0x97,
  0x78, 0x34, 0xDE, 0xA1, 0x80, 0x99, 0x70, 0x02, 0xFB, 0x06, 0x70, 0x2F, 0xB0, 0x67, 0x83, 0x1A,
  0xBC, 0xDE, 0x06, 0x77, 0x03, 0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B,
  0x06, 0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77,
  0x02, 0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0,
  0x67, 0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B, 0x07, 0x78, 0x55, 0x89, 0xBC, 0xDE,
  0xE8, 0x5D, 0xCB, 0x98, 0x4C, 0xFF, 0xB0, 0x90, 0xCF, 0xFB, 0x09,
  // "j" (U+006A)
  0x72, 0x83, 0x1B, 0xED, 0x47, 0x30, 0x9B, 0x0E, 0x73, 0x0B, 0xC0, 0x27, 0x20, 0x9B, 0x0E, 0x73,
  0x83, 0x1A, 0xED, 0x48, 0x0F, 0x40, 0x0B, 0xFA, 0x0D, 0x40, 0xBF, 0xA0, 0xD4, 0x81, 0x8D, 0xEF,
  0x0D, 0x71, 0x82, 0x12, 0x3C, 0xA0, 0xD7, 0x40, 0xBA, 0x0D, 0x74, 0x0B, 0xA0, 0xD7, 0x40, 0xBA,
  0x0D, 0x74, 0x0B, 0xA0, 0xD7, 0x40, 0xBA, 0x0D, 0x74, 0x0B, 0xA0, 0xD7, 0x40, 0xBA, 0x0D, 0x74,
  0x0B, 0xA0, 0xD7, 0x40, 0xBA, 0x0D, 0x74, 0x0B, 0xA0, 0xD7, 0x40, 0xBA, 0x0D, 0x74, 0x0B, 0xA0,
  0xD7, 0x40, 0xBA, 0x0D, 0x74, 0x0B, 0xA0, 0xD7, 0x40, 0xBA, 0x0D, 0x74, 0x0B, 0xA0, 0xD7, 0x40,
  0xBA, 0x0D, 0x74, 0x0B, 0xA0, 0xD7, 0x40, 0xBA, 0x0D, 0x74, 0x0B, 0xA0, 0xD7, 0x40, 0xBA, 0x0D,
  0x74, 0x0E, 0xA0, 0xB7, 0x30, 0x3B, 0x09, 0x73, 0x0B, 0xB8, 0x44, 0x06, 0x73, 0x13, 0x04, 0x0B,
  0xB0, 0xC2, 0x09, 0xC0, 0xED, 0x0E, 0x02, 0x20, 0x9F, 0xA0, 0xC0, 0x23, 0x89, 0x03, 0x9B, 0xDE,
  0xFE, 0xDA, 0x55,
  // "k" (U+006B)
  0x0C, 0xA0, 0xC7, 0x71, 0x0C, 0xA0, 0xC7, 0x71, 0x0C, 0xA0, 0xC7, 0x71, 0x0C, 0xA0, 0xC7, 0x71,
  0x0C, 0xA0, 0xC7, 0x71, 0x0C, 0xA0, 0xC7, 0x71, 0x0C, 0xA0, 0xC7, 0x71, 0x0C, 0xA0, 0xC7, 0x71,
  0x0C, 0xA0, 0xC7, 0x71, 0x0C, 0xA0, 0xC7, 0x20, 0x8B, 0x81, 0xB0, 0xCA, 0x0C, 0x71, 0x06, 0xB8,
  0x2C, 0x10, 0xCA, 0x0C, 0x70, 0x4B, 0x0D, 0x01, 0x20, 0xCA, 0x0C, 0x60, 0x30, 0xEA, 0x0E, 0x02,
  0x30, 0xCA, 0x0C, 0x50, 0x10, 0xEB, 0x03, 0x40, 0xCA, 0x0C, 0x40, 0x10, 0xDB, 0x05, 0x50, 0xCA,
  0x0C, 0x40, 0xBB, 0x06, 0x60, 0xCA, 0x0B, 0x30, 0xAB, 0x08, 0x70, 0xCA, 0x0A, 0x20, 0x8B, 0x09,
  0x71, 0x0C, 0xA8, 0x1A, 0x05, 0xB0, 0xD7, 0x20, 0xCA, 0x09, 0x03, 0xD0, 0x67, 0x10, 0xCA, 0x09,
  0x0D, 0xA0, 0xEB, 0x02, 0x70, 0xCD, 0x81, 0x72, 0xEA, 0x0D, 0x70, 0xCC, 0x07, 0x20, 0x6B, 0x09,
  0x60, 0xCB, 0x07, 0x40, 0xAB, 0x05, 0x50, 0xCA, 0x0C, 0x50, 0x10, 0xEA, 0x0E, 0x01, 0x40, 0xCA,
  0x0C, 0x60, 0x4B, 0x0C, 0x40, 0xCA, 0x0C, 0x70, 0x8B, 0x08, 0x30, 0xCA, 0x0C, 0x71, 0x0C, 0xB0,
  0x32, 0x0C, 0xA0, 0xC7, 0x10, 0x2B, 0x82, 0xD1, 0x0C, 0xA0, 0xC7, 0x20, 0x6B, 0x81, 0xA0, 0xCA,
  0x0C, 0x73, 0x0B, 0xB0, 0x60,
  // "l" (U+006C)
  0x08, 0xFB, 0x09, 0x70, 0x8F, 0xB0, 0x97, 0x08, 0x80, 0x3E, 0xB0, 0x97, 0x71, 0x0E, 0xA0, 0x97,
  0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97,
  0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97,
  0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97,
  0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97,
  0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97,
  0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97,
  0x85, 0x58, 0x9A, 0xBC, 0xDD, 0x86, 0xED, 0xBA, 0x97, 0x4C, 0xFF, 0xB0, 0x90, 0xCF, 0xFB, 0x09,
  // "m" (U+006D)
  0xA8, 0x69, 0x02, 0xAE, 0xEC, 0x53, 0x83, 0x8D, 0xFD, 0x82, 0xA8, 0x1C, 0x2E, 0xD8, 0x15, 0x0C,
  0xD0, 0xB1, 0xB0, 0xCE, 0x0D, 0x09, 0xF0, 0x4C, 0x82, 0xB1, 0x08, 0xD8, 0x26, 0x02, 0xDA, 0x09,
  0xC0, 0x13, 0x0E, 0xB0, 0x93, 0x07, 0xA0, 0xCB, 0x0B, 0x40, 0xBB, 0x03, 0x30, 0x4A, 0x0E, 0xB0,
  0x84, 0x0A, 0xB4, 0x03, 0xE0, 0x64, 0x09, 0xA0, 0xD4, 0x02, 0xE0, 0x44, 0x08, 0xA0, 0xB4, 0x02,
  0xE0, 0x34, 0x08, 0xA0, 0xA4, 0x02, 0xE0, 0x34, 0x08, 0xA0, 0xA4, 0x02, 0xE0, 0x34, 0x08, 0xA0,
  0x94, 0x02, 0xE0, 0x34, 0x08, 0xA0, 0x94, 0x02, 0xE0, 0x34, 0x08, 0xA0, 0x94, 0x02, 0xE0, 0x34,
  0x08, 0xA0, 0x94, 0x02, 0xE0, 0x34, 0x08, 0xA0, 0x94, 0x02, 0xE0, 0x34, 0x08, 0xA0, 0x94, 0x02,
  0xE0, 0x34, 0x08, 0xA0, 0x94, 0x02, 0xE0, 0x34, 0x08, 0xA0, 0x94, 0x02, 0xE0, 0x34, 0x08, 0xA0,
  0x94, 0x02, 0xE0, 0x34, 0x08, 0xA0, 0x94, 0x02, 0xE0, 0x34, 0x08, 0xA0, 0x94, 0x02, 0xB0,
  // "n" (U+006E)
  0x0C, 0xA0, 0x22, 0x87, 0x16, 0xBD, 0xFE, 0xC9, 0x23, 0x0C, 0xA8, 0x24, 0x06, 0xEF, 0x90, 0x82,
  0x0C, 0xA0, 0x06, 0xFC, 0x81, 0x80, 0xCA, 0x0B, 0xA0, 0xB0, 0x43, 0x02, 0x09, 0xC0, 0x20, 0xCC,
  0x09, 0x70, 0x8B, 0x08, 0x0C, 0xB0, 0xD7, 0x20, 0xEA, 0x00, 0xCB, 0x07, 0x72, 0x0B, 0xA0, 0xE0,
  0xCB, 0x02, 0x72, 0x09, 0xB0, 0xCB, 0x73, 0x09, 0xB0, 0xCA, 0x0D, 0x73, 0x09, 0xB0, 0xCA, 0x0C,
  0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73,
  0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09,
  0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0,
  0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0,
  // "o" (U+006F)
  0x58, 0x21, 0x7B, 0xDA, 0x81, 0xDA, 0x67, 0x30, 0x8F, 0xA0, 0xE0, 0x67, 0x0B, 0xFD, 0x0A, 0x50,
  0xAB, 0x81, 0xD6, 0x12, 0x81, 0x16, 0xEB, 0x09, 0x30, 0x5B, 0x0C, 0x70, 0x10, 0xDB, 0x04, 0x20,
  0xCA, 0x0E, 0x01, 0x71, 0x02, 0xB8, 0x1C, 0x03, 0xB0, 0x87, 0x30, 0x9B, 0x02, 0x07, 0xB0, 0x37,
  0x30, 0x4B, 0x06, 0x09, 0xB7, 0x40, 0x1B, 0x09, 0x0B, 0xA0, 0xD7, 0x50, 0xEA, 0x0B, 0x0C, 0xA0,
  0xC7, 0x50, 0xDA, 0x0B, 0x0C, 0xA0, 0xC7, 0x50, 0xDA, 0x0C, 0x0B, 0xA0, 0xD7, 0x50, 0xEA, 0x0B,
  0x09, 0xB7, 0x40, 0x1B, 0x09, 0x06, 0xB0, 0x37, 0x30, 0x4B, 0x06, 0x02, 0xB0, 0x87, 0x30, 0x9B,
  0x81, 0x20, 0xBB, 0x01, 0x71, 0x02, 0xB0, 0xC2, 0x04, 0xB0, 0xC0, 0x16, 0x01, 0x0D, 0xB0, 0x43,
  0x09, 0xB8, 0x1D, 0x61, 0x28, 0x11, 0x6E, 0xB0, 0x95, 0x0A, 0xFD, 0x0B, 0x70, 0x70, 0xEF, 0x90,
  0xE0, 0x77, 0x28, 0x21, 0x6B, 0xDA, 0x82, 0xDB, 0x61, 0x50,
  // "p" (U+0070)
  0x0C, 0xA0, 0x32, 0x86, 0x29, 0xCE, 0xED, 0xA5, 0x50, 0xCA, 0x81, 0x50, 0x7F, 0x90, 0xC0, 0x23,
  0x0C, 0xA0, 0x70, 0x8C, 0x0E, 0xD0, 0xE0, 0x32, 0x0C, 0xA0, 0xDA, 0x09, 0x03, 0x30, 0x40, 0xBB,
  0x0D, 0x20, 0xCC, 0x06, 0x70, 0x9B, 0x81, 0x80, 0xCB, 0x0B, 0x72, 0x0D, 0xA8, 0x1E, 0x0C, 0xB0,
  0x47, 0x20, 0x7B, 0x04, 0x0C, 0xB7, 0x30, 0x3B, 0x07, 0x0C, 0xA0, 0xD7, 0x4B, 0x09, 0x0C, 0xA0,
  0xC7, 0x40, 0xEA, 0x0B, 0x0C, 0xA0, 0xB7, 0x40, 0xDA, 0x0B, 0x0C, 0xA0, 0xC7, 0x40, 0xEA, 0x0B,
  0x0C, 0xA0, 0xC7, 0x40, 0xEA, 0x0A, 0x0C, 0xA0, 0xE7, 0x30, 0x1B, 0x09, 0x0C, 0xB0, 0x17, 0x20,
  0x3B, 0x06, 0x0C, 0xB0, 0x67, 0x20, 0x8B, 0x03, 0x0C, 0xB0, 0xC7, 0x20, 0xEA, 0x81, 0xD0, 0xCC,
  0x07, 0x70, 0x9B, 0x81, 0x70, 0xCA, 0x0E, 0xA0, 0x90, 0x33, 0x04, 0x0B, 0xB0, 0xD2, 0x0C, 0xA0,
  0x80, 0x9C, 0x0E, 0xD0, 0xE0, 0x22, 0x0C, 0xA8, 0x19, 0x07, 0xF9, 0x0C, 0x02, 0x30, 0xCA, 0x0B,
  0x28, 0x62, 0x8C, 0xEF, 0xDA, 0x55, 0x0C, 0xA0, 0xB7, 0x71, 0x0C, 0xA0, 0xB7, 0x71, 0x0C, 0xA0,
  0xB7, 0x71, 0x0C, 0xA0, 0xB7, 0x71, 0x0C, 0xA0, 0xB7, 0x71, 0x0C, 0xA0, 0xB7, 0x71, 0x0C, 0xA0,
  0xB7, 0x71, 0x0C, 0xA0, 0xB7, 0x71, 0x0C, 0xA0, 0xB7, 0x71, 0x0C, 0xA0, 0xB7, 0x71,
  // "q" (U+0071)
  0x58, 0x64, 0x9D, 0xFE, 0xC9, 0x22, 0x02, 0xA0, 0xC3, 0x01, 0x0B, 0xF9, 0x81, 0x70, 0x4A, 0x0C,
  0x20, 0x10, 0xDD, 0x0E, 0xC0, 0x07, 0xA0, 0xC2, 0x0C, 0xB0, 0xC0, 0x43, 0x03, 0x0A, 0xA0, 0xDA,
  0x81, 0xC0, 0x6B, 0x0A, 0x70, 0x7C, 0x81, 0xC0, 0xDA, 0x0E, 0x72, 0x0C, 0xB0, 0xC0, 0x3B, 0x08,
  0x72, 0x06, 0xB0, 0xC0, 0x7B, 0x03, 0x72, 0x02, 0xB0, 0xC0, 0x9B, 0x01, 0x73, 0x0E, 0xA0, 0xC0,
  0xBA, 0x0E, 0x74, 0x0D, 0xA0, 0x0C, 0xA0, 0xD7, 0x40, 0xCA, 0x0C, 0x0B, 0xA0, 0xD7, 0x40, 0xBA,
  0x0C, 0x0B, 0xA0, 0xE7, 0x40, 0xCA, 0x0C, 0x09, 0xB0, 0x17, 0x30, 0xDA, 0x0C, 0x07, 0xB0, 0x47,
  0x3B, 0x0C, 0x03, 0xB0, 0x97, 0x20, 0x4B, 0x81, 0xC0, 0xDA, 0x0E, 0x01, 0x71, 0x0B, 0xB8, 0x1C,
  0x07, 0xB0, 0xB7, 0x06, 0xC0, 0xC2, 0x0C, 0xB0, 0xC0, 0x43, 0x03, 0x09, 0xA0, 0xEA, 0x0C, 0x20,
  0x20, 0xDD, 0x0E, 0xC0, 0x90, 0xAA, 0x0C, 0x30, 0x10, 0xBF, 0x98, 0x18, 0x0B, 0xA0, 0xC5, 0x86,
  0x49, 0xDE, 0xEC, 0x93, 0x20, 0xBA, 0x0C, 0x77, 0x10, 0xBA, 0x0C, 0x77, 0x10, 0xBA, 0x0C, 0x77,
  0x10, 0xBA, 0x0C, 0x77, 0x10, 0xBA, 0x0C, 0x77, 0x10, 0xBA, 0x0C, 0x77, 0x10, 0xBA, 0x0C, 0x77,
  0x10, 0xBA, 0x0C, 0x77, 0x10, 0xBA, 0x0C, 0x77, 0x10, 0xBA, 0x0C, 0x77, 0x10, 0xBA, 0x0C,
  // "r" (U+0072)
  0x10, 0xDF, 0x0E, 0x38, 0x13, 0xAE, 0xA8, 0x3D, 0xB6, 0x0D, 0xF9, 0x20, 0x6F, 0x82, 0x90, 0x9D,
  0xF0, 0x20, 0x4C, 0x0E, 0xB0, 0x54, 0x81, 0x13, 0x5B, 0x84, 0x5E, 0xFE, 0x61, 0x28, 0x15, 0xD1,
  0x7B, 0x82, 0xDF, 0xE2, 0x77, 0xD0, 0x37, 0x71, 0xC0, 0xA7, 0x72, 0xC0, 0x37, 0x72, 0xB0, 0xE7,
  0x73, 0xB0, 0xC7, 0x73, 0xB0, 0xA7, 0x73, 0xB0, 0x97, 0x73, 0xB0, 0x97, 0x73, 0xB0, 0x97, 0x73,
  0xB0, 0x97, 0x73, 0xB0, 0x97, 0x73, 0xB0, 0x97, 0x73, 0xB0, 0x97, 0x73, 0xB0, 0x97, 0x38, 0x43,
  0x79, 0xAC, 0xDD, 0x84, 0xED, 0xBA, 0x86, 0x40, 0x8F, 0xF9, 0x0D, 0x40, 0x8F, 0xF9, 0x0D, 0x40,
  // "s" (U+0073)
  0x48, 0x25, 0xAC, 0xEA, 0x82, 0xEC, 0x95, 0x40, 0x50, 0xEF, 0xC8, 0x14, 0x06, 0xE0, 0xEE, 0x81,
  0x10, 0xEA, 0x81, 0xE6, 0x23, 0x85, 0x13, 0x8D, 0xA0, 0x4B, 0x04, 0x72, 0x81, 0x10, 0x6B, 0x01,
  0x74, 0x05, 0xB0, 0x47, 0x40, 0x1B, 0x0D, 0x03, 0x74, 0x08, 0xC0, 0xA0, 0x37, 0x30, 0x8D, 0x0C,
  0x05, 0x72, 0x03, 0x0B, 0xD0, 0xD0, 0x77, 0x20, 0x30, 0xAD, 0x0E, 0x06, 0x72, 0x81, 0x29, 0xEC,
  0x09, 0x73, 0x01, 0x08, 0xC0, 0x47, 0x40, 0x4B, 0x09, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x81,
  0xB5, 0x17, 0x20, 0x3B, 0x84, 0x8C, 0xFB, 0x63, 0x48, 0x12, 0x6E, 0xB0, 0x30, 0xCE, 0x0E, 0xE8,
  0x18, 0x0A, 0xFC, 0x0E, 0x07, 0x38, 0x32, 0x7A, 0xCE, 0xA8, 0x3E, 0xDA, 0x61, 0x30,
  // "t" (U+0074)
  0x68, 0x21, 0x77, 0x57, 0x71, 0x05, 0xA0, 0xA7, 0x71, 0x07, 0xA0, 0xA7, 0x71, 0x09, 0xA0, 0xA7,
  0x71, 0x0B, 0xA0, 0xA7, 0x71, 0x0D, 0xA0, 0xA7, 0x28, 0x36, 0x9B, 0xCE, 0xFE, 0x10, 0xBF, 0xFB,
  0x10, 0xB8, 0x01, 0xEC, 0x80, 0x4E, 0x70, 0xEA, 0x0A, 0x77, 0x10, 0xEA, 0x0A, 0x77, 0x10, 0xEA,
  0x0A, 0x77, 0x10, 0xEA, 0x0A, 0x77, 0x10, 0xEA, 0x0A, 0x77, 0x10, 0xEA, 0x0A, 0x77, 0x10, 0xEA,
  0x0A, 0x77, 0x10, 0xEA, 0x0A, 0x77, 0x10, 0xEA, 0x0A, 0x77, 0x10, 0xEA, 0x0A, 0x77, 0x10, 0xEA,
  0x0A, 0x77, 0x10, 0xEA, 0x0A, 0x77, 0x10, 0xDA, 0x0C, 0x77, 0x10, 0xCA, 0x0E, 0x77, 0x10, 0x9B,
  0x07, 0x77, 0x03, 0xC0, 0x80, 0x23, 0x81, 0x24, 0x47, 0x09, 0xE0, 0xEB, 0x09, 0x71, 0x08, 0xFA,
  0x09, 0x72, 0x89, 0x02, 0x7B, 0xDE, 0xFD, 0xC9, 0x40,
  // "u" (U+0075)
  0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0,
  0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97,
  0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30,
  0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xDA,
  0x0C, 0xB0, 0x97, 0x30, 0xEA, 0x0C, 0xB0, 0x97, 0x20, 0x2B, 0x0C, 0x0E, 0xA0, 0xB7, 0x20, 0x6B,
  0x00, 0xCA, 0x0E, 0x72, 0x0D, 0xB0, 0xC0, 0x9B, 0x08, 0x70, 0x8C, 0x0C, 0x03, 0xC0, 0x90, 0x23,
  0x04, 0x0A, 0xA0, 0xDA, 0x81, 0xC0, 0x9E, 0x0E, 0xC0, 0x90, 0x7A, 0x0C, 0x20, 0xAF, 0xA8, 0x19,
  0x04, 0xA0, 0xC3, 0x87, 0x39, 0xDE, 0xFE, 0xC8, 0x22, 0x02, 0xA0, 0xC0,
  // "v" (U+0076)
  0xB0, 0xA7, 0x50, 0xBA, 0x0E, 0x0A, 0xA0, 0xE7, 0x40, 0x1B, 0x09, 0x04, 0xB0, 0x57, 0x30, 0x6B,
  0x81, 0x30, 0xEA, 0x0A, 0x73, 0x0B, 0xA0, 0xD2, 0x09, 0xB7, 0x20, 0x1B, 0x08, 0x20, 0x3B, 0x05,
  0x71, 0x06, 0xB0, 0x23, 0x0D, 0xA0, 0xB7, 0x10, 0xBA, 0x0C, 0x40, 0x7B, 0x01, 0x60, 0x1B, 0x06,
  0x40, 0x2B, 0x06, 0x60, 0x6B, 0x01, 0x50, 0xCA, 0x0B, 0x60, 0xBA, 0x0A, 0x60, 0x6B, 0x01, 0x40,
  0x1B, 0x05, 0x60, 0x1B, 0x06, 0x40, 0x6A, 0x0E, 0x71, 0x0A, 0xA0, 0xB4, 0x0B, 0xA0, 0x97, 0x10,
  0x5B, 0x01, 0x20, 0x1B, 0x03, 0x72, 0x0E, 0xA0, 0x72, 0x07, 0xA0, 0xD7, 0x30, 0x9A, 0x0C, 0x20,
  0xCA, 0x08, 0x73, 0x04, 0xB0, 0x02, 0xB0, 0x27, 0x40, 0xDA, 0x00, 0x7A, 0x0C, 0x75, 0x08, 0xA0,
  0x0C, 0xA0, 0x67, 0x50, 0x2E, 0x01, 0x76, 0x0C, 0xC0, 0xA7, 0x70, 0x7C, 0x05, 0x70,
  // "w" (U+0077)
  0x04, 0xB0, 0x17, 0x71, 0x0E, 0xA0, 0x50, 0x2B, 0x03, 0x77, 0x01, 0xB8, 0x12, 0x0E, 0xA0, 0x57,
  0x70, 0x4B, 0x20, 0xCA, 0x07, 0x77, 0x06, 0xA0, 0xD2, 0x0A, 0xA0, 0x94, 0x01, 0x80, 0x0D, 0x50,
  0x8A, 0x0A, 0x20, 0x7A, 0x0C, 0x40, 0x5C, 0x04, 0x40, 0xBA, 0x08, 0x20, 0x5A, 0x0E, 0x40, 0xAC,
  0x09, 0x40, 0xDA, 0x05, 0x20, 0x3B, 0x01, 0x38, 0x1E, 0xFE, 0xA0, 0xD4, 0xB0, 0x33, 0xB0, 0x32,
  0x03, 0xA0, 0x0B, 0xA0, 0x12, 0x03, 0xB4, 0x0D, 0xA0, 0x52, 0x07, 0xA0, 0x70, 0x8A, 0x06, 0x20,
  0x5A, 0x0D, 0x40, 0xBA, 0x07, 0x20, 0xCA, 0x03, 0x04, 0xA0, 0xA2, 0x07, 0xA0, 0xB4, 0x08, 0xA8,
  0x1A, 0x01, 0xA8, 0x1E, 0x01, 0xA0, 0xE2, 0x0A, 0xA0, 0x84, 0x06, 0xA8, 0x1C, 0x04, 0xA0, 0xB2,
  0x0C, 0xA8, 0x12, 0x0C, 0xA0, 0x64, 0x03, 0xA8, 0x1D, 0x08, 0xA0, 0x72, 0x08, 0xA8, 0x16, 0x0D,
  0xA0, 0x34, 0x01, 0xB1, 0x0C, 0xA0, 0x22, 0x04, 0xA0, 0xA1, 0xB0, 0x15, 0x0E, 0xA0, 0x1A, 0x0E,
  0x30, 0x1A, 0x0E, 0x01, 0xA0, 0xE6, 0x0C, 0xA0, 0x4A, 0x0A, 0x40, 0xCA, 0x04, 0xA0, 0xB6, 0x09,
  0xA0, 0x8A, 0x06, 0x40, 0x8A, 0x08, 0xA0, 0x96, 0x07, 0xA0, 0xCA, 0x02, 0x40, 0x4A, 0x0C, 0xA0,
  0x66, 0x04, 0xC0, 0xE5, 0x01, 0xD0, 0x46, 0x02, 0xC0, 0xA6, 0x0C, 0xC0, 0x17, 0xC0, 0x66, 0x08,
  0xB0, 0xE4,
  // "x" (U+0078)
  0x06, 0xB0, 0x97, 0x30, 0x9B, 0x81, 0x60, 0xBB, 0x04, 0x71, 0x04, 0xB0, 0xB2, 0x01, 0x0E, 0xA0,
  0xD0, 0x16, 0x01, 0x0D, 0xA0, 0xE0, 0x13, 0x04, 0xB0, 0xA6, 0x0A, 0xB0, 0x45, 0x09, 0xB0, 0x54,
  0x05, 0xB0, 0x87, 0x0C, 0xA0, 0xE0, 0x12, 0x01, 0x0E, 0xA0, 0xC7, 0x10, 0x2B, 0x0B, 0x20, 0xBA,
  0x0E, 0x02, 0x72, 0x06, 0xB0, 0x07, 0xB0, 0x67, 0x40, 0xBE, 0x0A, 0x75, 0x01, 0x0E, 0xC0, 0xD0,
  0x17, 0x60, 0x5C, 0x04, 0x77, 0x09, 0xC0, 0x87, 0x60, 0x4E, 0x04, 0x74, 0x01, 0x0E, 0xA0, 0x0C,
  0xA0, 0xE0, 0x17, 0x30, 0xBB, 0x00, 0x2B, 0x0B, 0x72, 0x07, 0xB0, 0x62, 0x07, 0xB0, 0x77, 0x03,
  0xB0, 0xB4, 0x0B, 0xB0, 0x35, 0x01, 0x0D, 0xA0, 0xE0, 0x14, 0x01, 0x0E, 0xA0, 0xD5, 0x0A, 0xB0,
  0x46, 0x05, 0xB0, 0x93, 0x06, 0xB0, 0x97, 0x10, 0x9B, 0x82, 0x50, 0x2E, 0xA0, 0xD7, 0x30, 0xDA,
  0x81, 0xE1, 0xCB, 0x03, 0x73, 0x03, 0xB0, 0xC0,
  // "y" (U+0079)
  0x0E, 0xA0, 0x77, 0x50, 0xAA, 0x0E, 0x09, 0xA0, 0xD7, 0x50, 0xEA, 0x09, 0x02, 0xB0, 0x47, 0x30,
  0x5B, 0x81, 0x30, 0xCA, 0x0A, 0x73, 0x0A, 0xA0, 0xD2, 0x05, 0xB0, 0x17, 0x20, 0xEA, 0x08, 0x30,
  0xEA, 0x07, 0x71, 0x04, 0xB0, 0x23, 0x08, 0xA0, 0xD7, 0x10, 0x9A, 0x0C, 0x40, 0x2B, 0x04, 0x70,
  0xEA, 0x06, 0x50, 0xBA, 0x0A, 0x60, 0x4B, 0x01, 0x50, 0x5B, 0x01, 0x50, 0x9A, 0x0B, 0x70, 0xEA,
  0x07, 0x50, 0xEA, 0x05, 0x70, 0x8A, 0x0D, 0x40, 0x4A, 0x0E, 0x71, 0x02, 0xB0, 0x43, 0x09, 0xA0,
  0x97, 0x20, 0xBA, 0x0A, 0x30, 0xEA, 0x04, 0x72, 0x05, 0xB2, 0x03, 0xA0, 0xD7, 0x40, 0xDA, 0x81,
  0x50, 0x8A, 0x08, 0x74, 0x07, 0xA8, 0x1A, 0x0D, 0xA0, 0x27, 0x40, 0x1A, 0x0E, 0x02, 0xA0, 0xC7,
  0x60, 0xAA, 0x0B, 0xA0, 0x67, 0x60, 0x4D, 0x01, 0x77, 0x0D, 0xB0, 0xB7, 0x71, 0x07, 0xB0, 0x57,
  0x71, 0x05, 0xA0, 0xE7, 0x72, 0x0B, 0xA0, 0x97, 0x71, 0x01, 0xB0, 0x47, 0x71, 0x07, 0xA0, 0xD7,
  0x72, 0x0E, 0xA0, 0x77, 0x71, 0x09, 0xA0, 0xE0, 0x17, 0x60, 0x20, 0xAB, 0x08, 0x73, 0x81, 0x6F,
  0xED, 0x0C, 0x74, 0x06, 0xE0, 0xC0, 0x17, 0x48, 0x55, 0xDE, 0xFD, 0xB5, 0x76,
  // "z" (U+007A)
  0x10, 0xBF, 0xF9, 0x81, 0x10, 0xBF, 0xF9, 0x81, 0x10, 0xB8, 0x07, 0xEC, 0x01, 0x75, 0x03, 0xB0,
  0xC7, 0x50, 0x10, 0xDA, 0x0E, 0x01, 0x75, 0x0B, 0xB0, 0x47, 0x50, 0x7B, 0x07, 0x75, 0x03, 0xB0,
  0xB7, 0x50, 0x10, 0xDA, 0x0D, 0x01, 0x75, 0x0B, 0xB0, 0x37, 0x50, 0x7B, 0x06, 0x75, 0x04, 0xB0,
  0xA7, 0x50, 0x10, 0xEA, 0x0D, 0x76, 0x0B, 0xA0, 0xE0, 0x27, 0x50, 0x8B, 0x05, 0x75, 0x04, 0xB0,
  0x97, 0x50, 0x10, 0xEA, 0x0C, 0x76, 0x0B, 0xA0, 0xE0, 0x27, 0x50, 0x8B, 0x04, 0x75, 0x03, 0xC8,
  0x09, 0x0E, 0x05, 0x06, 0xFF, 0xA0, 0x06, 0xFF, 0xA0, 0x60,
  // "{" (U+007B)
  0x72, 0x83, 0x5A, 0xDE, 0x67, 0x04, 0x0D, 0xC0, 0x66, 0x04, 0xE0, 0x66, 0x0D, 0xB0, 0xA0, 0x37,
  0x04, 0xB0, 0x87, 0x20, 0x6B, 0x01, 0x72, 0x07, 0xB7, 0x30, 0x8A, 0x0E, 0x73, 0x08, 0xA0, 0xE7,
  0x30, 0x8A, 0x0E, 0x73, 0x08, 0xA0, 0xE7, 0x30, 0x8A, 0x0E, 0x73, 0x08, 0xA0, 0xE7, 0x30, 0xAA,
  0x0D, 0x72, 0x02, 0x0E, 0xA0, 0x97, 0x81, 0x16, 0xEA, 0x0E, 0x01, 0x50, 0x5D, 0x0B, 0x02, 0x60,
  0x6B, 0x0D, 0x04, 0x71, 0x06, 0xD0, 0xB0, 0x27, 0x18, 0x13, 0x7E, 0xA0, 0xE0, 0x17, 0x20, 0x3B,
  0x09, 0x73, 0x0A, 0xA0, 0xD7, 0x30, 0x8A, 0x0E, 0x73, 0x08, 0xA0, 0xE7, 0x30, 0x8A, 0x0E, 0x73,
  0x08, 0xA0, 0xE7, 0x30, 0x8A, 0x0E, 0x73, 0x08, 0xA0, 0xE7, 0x30, 0x7B, 0x73, 0x06, 0xB0, 0x17,
  0x20, 0x4B, 0x07, 0x73, 0x0E, 0xB0, 0x90, 0x37, 0x10, 0x5E, 0x06, 0x70, 0x50, 0xEC, 0x06, 0x72,
  0x83, 0x6A, 0xDE, 0x60,
  // "|" (U+007C)
  0x6F, 0xF7, 0x6F, 0xF7, 0x6F, 0xF7, 0x6F, 0xF7, 0x6F, 0xF7, 0x6F, 0xF7, 0x6F, 0xF7, 0x6F, 0xF7,
  0x6F, 0xF7, 0x6F, 0xF7, 0x6F, 0xF7, 0x6F, 0xF7, 0x6F, 0xF7, 0x6F, 0xF7, 0x6F, 0xF7, 0x6F, 0xF7,
  0x6F, 0xF7, 0x6F, 0xF7, 0x6F, 0xF7, 0x6F, 0xF7, 0x6F, 0xF7, 0x6F, 0xF7, 0x6F, 0xF7, 0x6F, 0xF7,
  0x6F, 0xF7, 0x6F, 0xF7, 0x6F, 0xF7, 0x6F, 0xF7, 0x6F, 0xF7, 0x6F, 0xF7, 0x6F, 0xF7, 0x6F, 0xF7,
  0x6F, 0xF7, 0x6F, 0xF7, 0x6F, 0xF7, 0x6F, 0xF7, 0x6F, 0xF7, 0x6F, 0xF7, 0x6F, 0xF7, 0x6F, 0xF7,
  0x6F, 0xF7,
  // "}" (U+007D)
  0x83, 0x6E, 0xDA, 0x57, 0x20, 0x6C, 0x0E, 0x04, 0x70, 0x6E, 0x04, 0x71, 0x03, 0x09, 0xB0, 0xE7,
  0x30, 0x8B, 0x04, 0x72, 0x01, 0xB0, 0x67, 0x3B, 0x07, 0x73, 0x0E, 0xA0, 0x87, 0x30, 0xEA, 0x08,
  0x73, 0x0E, 0xA0, 0x87, 0x30, 0xEA, 0x08, 0x73, 0x0E, 0xA0, 0x87, 0x30, 0xEA, 0x08, 0x73, 0x0D,
  0xA0, 0xA7, 0x30, 0x9B, 0x03, 0x72, 0x01, 0x0E, 0xA8, 0x1E, 0x72, 0x71, 0x02, 0x0B, 0xD0, 0x67,
  0x10, 0x40, 0xDB, 0x06, 0x60, 0x20, 0xBD, 0x05, 0x50, 0x10, 0xEA, 0x81, 0xE6, 0x17, 0x09, 0xA0,
  0xE0, 0x27, 0x20, 0xDA, 0x0A, 0x73, 0x0E, 0xA0, 0x87, 0x30, 0xEA, 0x08, 0x73, 0x0E, 0xA0, 0x87,
  0x30, 0xEA, 0x08, 0x73, 0x0E, 0xA0, 0x87, 0x30, 0xEA, 0x08, 0x73, 0xB0, 0x77, 0x20, 0x1B, 0x06,
  0x72, 0x08, 0xB0, 0x47, 0x03, 0x0A, 0xB0, 0xD6, 0x06, 0xE0, 0x46, 0x06, 0xC0, 0xD0, 0x47, 0x83,
  0x6E, 0xDA, 0x57, 0x20,
  // "~" (U+007E)
  0x28, 0x44, 0xCE, 0xEB, 0x47, 0x83, 0x8F, 0xD0, 0x5E, 0x0A, 0x01, 0x58, 0x3B, 0xFA, 0x0E, 0xF0,
  0xD0, 0x33, 0x01, 0xA0, 0x70, 0x5A, 0x08, 0x20, 0x7C, 0x07, 0x20, 0x9A, 0x82, 0x2A, 0xFD, 0x40,
  0x30, 0xDF, 0x83, 0xB0, 0xCF, 0x85, 0x01, 0x0A, 0xD0, 0xE0, 0x21, 0xA0, 0x57, 0x84, 0x5B, 0xEE,
  0xB3, 0x20,
  // "¡" (U+00A1)
  0x18, 0x48, 0xEE, 0x80, 0x4C, 0x04, 0x06, 0xC0, 0x60, 0x4C, 0x84, 0x40, 0x8E, 0xE8, 0x77, 0x60,
  0x9A, 0x08, 0x20, 0x9A, 0x08, 0x20, 0x9A, 0x09, 0x20, 0xAA, 0x09, 0x20, 0xAA, 0x0A, 0x20, 0xBA,
  0x0A, 0x20, 0xBA, 0x0B, 0x20, 0xCA, 0x0B, 0x20, 0xCA, 0x0C, 0x20, 0xDA, 0x0C, 0x20, 0xDA, 0x0C,
  0x20, 0xEA, 0x0D, 0x20, 0xEA, 0x0D, 0x2B, 0x0E, 0x2B, 0x0E, 0x2C, 0x10, 0x1C, 0x10, 0x1C, 0x10,
  0x2C, 0x01, 0x02, 0xC0, 0x10, 0x2C, 0x02,
  // "¢" (U+00A2)
  0x71, 0x03, 0xA0, 0x87, 0x70, 0x3A, 0x08, 0x77, 0x03, 0xA0, 0x87, 0x58, 0x13, 0x8C, 0xB8, 0x3E,
  0xDA, 0x73, 0x50, 0x20, 0xCF, 0xC0, 0x33, 0x05, 0xFD, 0x0D, 0x30, 0x4C, 0x81, 0xA4, 0x13, 0x82,
  0x37, 0xB8, 0x30, 0xDB, 0x05, 0x75, 0x06, 0xB0, 0x77, 0x60, 0xCA, 0x0E, 0x77, 0xB0, 0x97, 0x60,
  0x3B, 0x06, 0x76, 0x04, 0xB0, 0x47, 0x60, 0x5B, 0x03, 0x76, 0x06, 0xB0, 0x37, 0x60, 0x5B, 0x04,
  0x76, 0x04, 0xB0, 0x67, 0x60, 0x1B, 0x09, 0x77, 0x0D, 0xA0, 0xE7, 0x70, 0x8B, 0x06, 0x76, 0x01,
  0xB0, 0xE0, 0x47, 0x60, 0x7C, 0x0A, 0x04, 0x48, 0x22, 0x59, 0xE4, 0x09, 0xE0, 0xEE, 0x50, 0x50,
  0xDF, 0xC7, 0x81, 0x59, 0xDB, 0x83, 0xED, 0xB7, 0x27, 0x20, 0x3A, 0x07, 0x77, 0x03, 0xA0, 0x77,
  0x70, 0x3A, 0x07, 0x77, 0x03, 0xA0, 0x76,
  // "£" (U+00A3)
  0x71, 0x86, 0x6B, 0xEF, 0xED, 0xA5, 0x71, 0x03, 0x0D, 0xF9, 0x0E, 0x04, 0x50, 0x20, 0xEF, 0xB0,
  0x35, 0x0C, 0xB0, 0x90, 0x22, 0x82, 0x15, 0xCC, 0x50, 0x3B, 0x08, 0x70, 0x15, 0x07, 0xB0, 0x17,
  0x60, 0x9A, 0x0E, 0x77, 0x0A, 0xA0, 0xD7, 0x70, 0xAA, 0x0D, 0x77, 0x0A, 0xA0, 0xD7, 0x70, 0xAA,
  0x0D, 0x77, 0x0A, 0xA0, 0xD7, 0x70, 0xAA, 0x0D, 0x73, 0x04, 0x0F, 0xEC, 0x80, 0x2E, 0x0D, 0x30,
  0x4F, 0xE0, 0xE3, 0x04, 0xFE, 0x0E, 0x70, 0xAA, 0x0D, 0x77, 0x0A, 0xA0, 0xD7, 0x70, 0xAA, 0x0D,
  0x77, 0x0A, 0xA0, 0xD7, 0x70, 0xAA, 0x0C, 0x77, 0x0B, 0xA0, 0xB7, 0x70, 0xDA, 0x07, 0x76, 0x03,
  0xB0, 0x17, 0x60, 0xBA, 0x09, 0x75, 0x01, 0x0B, 0xA0, 0xD0, 0x17, 0x40, 0x4C, 0x80, 0x91, 0xE0,
  0x6F, 0xFB, 0x06, 0xFF, 0xB0,
  // "¤" (U+00A4)
  0x10, 0xC0, 0x67, 0x58, 0x26, 0xC0, 0xBA, 0x89, 0x26, 0x01, 0x7C, 0xEE, 0xC7, 0x10, 0x5A, 0x0C,
  0x0A, 0xB0, 0x80, 0xEE, 0x0E, 0x08, 0xB8, 0x1A, 0x0B, 0xFF, 0x0B, 0x30, 0xCB, 0x08, 0x02, 0x28,
  0x11, 0x7E, 0xA0, 0xD0, 0x13, 0x82, 0xCF, 0xE3, 0x68, 0x22, 0xDF, 0xD3, 0x05, 0xA0, 0x57, 0x10,
  0x4A, 0x07, 0x28, 0x1B, 0xFE, 0x73, 0x81, 0xDF, 0xC2, 0x81, 0xEF, 0xC7, 0x30, 0xBA, 0x28, 0x1E,
  0xFC, 0x73, 0x0B, 0xA2, 0x81, 0xCF, 0xE7, 0x38, 0x1D, 0xFD, 0x20, 0x7A, 0x05, 0x71, 0x03, 0xA0,
  0x93, 0x82, 0xEF, 0xE2, 0x60, 0x10, 0xDA, 0x02, 0x30, 0xBA, 0x81, 0xE7, 0x22, 0x81, 0x17, 0xEA,
  0x0C, 0x30, 0x8F, 0xF8, 0x19, 0x08, 0xB0, 0x90, 0xEF, 0x0B, 0xB0, 0x70, 0xCA, 0x89, 0x26, 0x01,
  0x7C, 0xEF, 0xD8, 0x10, 0x8A, 0x82, 0xC0, 0xC7, 0x75, 0x81, 0x7C, 0x10,
  // "¥" (U+00A5)
  0x05, 0xB0, 0x57, 0x50, 0x5B, 0x81, 0x50, 0xCA, 0x0D, 0x75, 0x0C, 0xA0, 0xC2, 0x05, 0xB0, 0x57,
  0x30, 0x5B, 0x04, 0x30, 0xCA, 0x0C, 0x73, 0x0C, 0xA0, 0xB4, 0x04, 0xB0, 0x47, 0x10, 0x4B, 0x03,
  0x50, 0xCA, 0x0C, 0x71, 0x0C, 0xA0, 0xB6, 0x04, 0xB0, 0x46, 0x04, 0xB0, 0x37, 0x0C, 0xA0, 0xB6,
  0x0C, 0xA0, 0xA7, 0x10, 0x4B, 0x03, 0x40, 0x4B, 0x02, 0x72, 0x0B, 0xA0, 0xB4, 0x0C, 0xA0, 0xA7,
  0x30, 0x3B, 0x03, 0x20, 0x4B, 0x02, 0x74, 0x0B, 0xA0, 0xB2, 0x0C, 0xA0, 0x97, 0x50, 0x3B, 0x03,
  0x04, 0xB0, 0x17, 0x60, 0xBA, 0x0A, 0x0C, 0xA0, 0x87, 0x70, 0x3D, 0x0E, 0x01, 0x73, 0x07, 0x80,
  0x0E, 0xE8, 0x00, 0xE0, 0x76, 0x08, 0xFF, 0x08, 0x60, 0x8F, 0xF0, 0x87, 0x50, 0xBA, 0x0A, 0x77,
  0x40, 0xBA, 0x0A, 0x77, 0x40, 0xBA, 0x0A, 0x75, 0x07, 0x80, 0x1E, 0xC8, 0x01, 0xE0, 0x76, 0x08,
  0xFF, 0x08, 0x60, 0x8F, 0xF0, 0x87, 0x50, 0xBA, 0x0A, 0x77, 0x40, 0xBA, 0x0A, 0x77, 0x40, 0xBA,
  0x0A, 0x77, 0x40, 0xBA, 0x0A, 0x77, 0x40, 0xBA, 0x0A, 0x72,
  // "¦" (U+00A6)
  0x07, 0xA0, 0x60, 0x7A, 0x06, 0x07, 0xA0, 0x60, 0x7A, 0x06, 0x07, 0xA0, 0x60, 0x7A, 0x06, 0x07,
  0xA0, 0x60, 0x7A, 0x06, 0x07, 0xA0, 0x60, 0x7A, 0x06, 0x07, 0xA0, 0x60, 0x7A, 0x06, 0x07, 0xA0,
  0x60, 0x7A, 0x06, 0x07, 0xA0, 0x68, 0x0D, 0x00, 0x07, 0xA0, 0x60, 0x7A, 0x06, 0x07, 0xA0, 0x60,
  0x7A, 0x06, 0x07, 0xA0, 0x60, 0x7A, 0x06, 0x07, 0xA0, 0x60, 0x7A, 0x06, 0x07, 0xA0, 0x60, 0x7A,
  0x06, 0x07, 0xA0, 0x60, 0x7A, 0x06, 0x07, 0xA0, 0x60, 0x7A, 0x06, 0x07, 0xA0, 0x60,
  // "§" (U+00A7)
  0x38, 0x91, 0x16, 0xAD, 0xEF, 0xED, 0xB7, 0x24, 0x05, 0x0E, 0xFB, 0x82, 0xC1, 0x04, 0xE0, 0xED,
  0x0D, 0x20, 0xDA, 0x81, 0xE6, 0x13, 0x85, 0x14, 0x9F, 0x80, 0x1B, 0x05, 0x71, 0x82, 0x11, 0x02,
  0xB0, 0x17, 0x5B, 0x07, 0x75, 0x0A, 0xB0, 0x87, 0x40, 0x20, 0xEB, 0x81, 0xE8, 0x17, 0x20, 0x20,
  0xDD, 0x0A, 0x04, 0x71, 0x09, 0xF0, 0xD0, 0x44, 0x01, 0x0C, 0xA8, 0x2B, 0x6A, 0xEC, 0x09, 0x30,
  0xAA, 0x08, 0x40, 0x60, 0xEB, 0x81, 0xA0, 0x1A, 0x0C, 0x70, 0xAB, 0x00, 0x3A, 0x08, 0x71, 0x0C,
  0xA0, 0x70, 0x3A, 0x09, 0x71, 0x06, 0xA0, 0x80, 0x1A, 0x0E, 0x02, 0x70, 0x5A, 0x81, 0x60, 0x9A,
  0x0E, 0x04, 0x60, 0xAA, 0x02, 0x20, 0xCB, 0x0B, 0x04, 0x30, 0x6A, 0x09, 0x40, 0x70, 0xEB, 0x81,
  0xD7, 0x9A, 0x0B, 0x68, 0x11, 0x7D, 0xD0, 0xC7, 0x30, 0x40, 0xAC, 0x0C, 0x01, 0x73, 0x02, 0x0A,
  0xB0, 0xB7, 0x50, 0x6B, 0x03, 0x75, 0x0D, 0xA0, 0x77, 0x50, 0xBA, 0x81, 0x84, 0x27, 0x20, 0x3B,
  0x84, 0x69, 0xFC, 0x73, 0x48, 0x12, 0x7E, 0xA8, 0x1E, 0x19, 0xE0, 0xEE, 0x81, 0x60, 0x6F, 0xC0,
  0xD0, 0x53, 0x83, 0x16, 0xAC, 0xEA, 0x82, 0xEC, 0x95, 0x40,
  // "¨" (U+00A8)
  0x82, 0x1B, 0xEA, 0x68, 0x3A, 0xEC, 0x28, 0xB0, 0x74, 0x06, 0xB0, 0x90, 0xAB, 0x09, 0x40, 0x8B,
  0x0B, 0x08, 0xB0, 0x64, 0x05, 0xB8, 0x39, 0x1B, 0xEA, 0x68, 0x29, 0xEB, 0x10,
  // "©" (U+00A9)
  0x68, 0x90, 0x16, 0xAD, 0xEE, 0xDB, 0x72, 0x74, 0x08, 0xFB, 0x09, 0x01, 0x70, 0x10, 0xCA, 0x81,
  0xA5, 0x12, 0x81, 0x25, 0xBA, 0x0D, 0x02, 0x68, 0x2D, 0xFD, 0x27, 0x18, 0x33, 0xDF, 0xD1, 0x48,
  0x29, 0xFD, 0x12, 0x89, 0x23, 0xAE, 0xFD, 0xA4, 0x01, 0xDF, 0xA3, 0x02, 0xA0, 0x22, 0x06, 0xE0,
  0xA2, 0x03, 0xA0, 0x32, 0x81, 0x9F, 0x92, 0x03, 0xA8, 0x4B, 0x31, 0x37, 0x33, 0x81, 0xAF, 0x92,
  0x81, 0xDF, 0x42, 0x81, 0xAF, 0xC7, 0x28, 0x34, 0xFD, 0x01, 0xA3, 0x81, 0xEF, 0x57, 0x3A, 0x82,
  0x12, 0xFE, 0x20, 0x2A, 0x02, 0x73, 0x84, 0xEF, 0x23, 0xFD, 0x20, 0x3A, 0x01, 0x73, 0x84, 0xDF,
  0x32, 0xFD, 0x20, 0x2A, 0x02, 0x73, 0x82, 0xEF, 0x21, 0xA3, 0xA0, 0x47, 0x3A, 0x83, 0x10, 0xEF,
  0x42, 0x81, 0xBF, 0xB7, 0x28, 0x13, 0xFD, 0x28, 0x19, 0xF9, 0x20, 0x4A, 0x84, 0x81, 0x01, 0x43,
  0x38, 0x19, 0xF9, 0x20, 0x3A, 0x03, 0x20, 0x8E, 0x06, 0x20, 0x1A, 0x02, 0x38, 0x2A, 0xFD, 0x12,
  0x85, 0x4B, 0xEF, 0xEB, 0x32, 0x81, 0xCF, 0x94, 0x83, 0x1E, 0xFD, 0x27, 0x18, 0x31, 0xCF, 0xD1,
  0x50, 0x20, 0xDA, 0x09, 0x03, 0x40, 0x30, 0x9A, 0x0D, 0x02, 0x70, 0x10, 0xAC, 0x00, 0xEC, 0x09,
  0x74, 0x82, 0x27, 0xBE, 0xA8, 0x2D, 0xB7, 0x16,
  // "ª" (U+00AA)
  0x28, 0x54, 0x8A, 0xBB, 0x95, 0x40, 0xDF, 0x0C, 0x01, 0x28, 0x58, 0xD7, 0x20, 0x17, 0xA0, 0xA7,
  0x28, 0x1A, 0xFE, 0x72, 0x06, 0xA0, 0x17, 0x10, 0x5A, 0x01, 0x28, 0x26, 0xBD, 0xED, 0x81, 0x11,
  0xCB, 0x82, 0xDC, 0xCD, 0xA0, 0x10, 0x9A, 0x07, 0x40, 0x5A, 0x82, 0x1D, 0xFC, 0x50, 0x7A, 0x82,
  0x1D, 0xFA, 0x50, 0xCA, 0x83, 0x1B, 0xFE, 0x23, 0x09, 0xB0, 0x10, 0x4B, 0x0C, 0x0D, 0xA0, 0xAA,
  0x89, 0x31, 0x03, 0xAE, 0xFD, 0x93, 0x0A, 0xC1,
  // "«" (U+00AB)
  0x68, 0x13, 0xC2, 0x58, 0x15, 0xB1, 0x68, 0x31, 0xDF, 0xE4, 0x38, 0x33, 0xEF, 0xE2, 0x50, 0xBA,
  0x0E, 0x01, 0x20, 0x10, 0xDA, 0x0B, 0x50, 0x9B, 0x03, 0x30, 0xCA, 0x0D, 0x01, 0x40, 0x6B, 0x06,
  0x30, 0x9A, 0x0E, 0x02, 0x40, 0x4B, 0x09, 0x30, 0x7B, 0x05, 0x40, 0x20, 0xEA, 0x0B, 0x30, 0x4B,
  0x08, 0x50, 0xCA, 0x0D, 0x01, 0x20, 0x20, 0xEA, 0x0B, 0x50, 0x6B, 0x06, 0x30, 0x9B, 0x03, 0x60,
  0xBA, 0x0E, 0x01, 0x20, 0x10, 0xEA, 0x0C, 0x60, 0x10, 0xDA, 0x0C, 0x30, 0x3B, 0x09, 0x60, 0x20,
  0xEA, 0x09, 0x30, 0x5B, 0x06, 0x60, 0x5B, 0x06, 0x30, 0x8B, 0x03, 0x60, 0x7B, 0x03, 0x30, 0xBA,
  0x0E, 0x01, 0x60, 0xAA, 0x0D, 0x01, 0x30, 0xCA, 0x0C, 0x78, 0x2C, 0xFE, 0x33, 0x83, 0x2E, 0xFD,
  0x26, 0x81, 0x1A, 0x15, 0x81, 0x39, 0x11,
  // "¬" (U+00AC)
  0x80, 0x95, 0xE0, 0x8F, 0xFB, 0x09, 0xFF, 0xB0, 0x97, 0x70, 0x3A, 0x09, 0x77, 0x03, 0xA0, 0x97,
  0x70, 0x3A, 0x09, 0x77, 0x03, 0xA0, 0x97, 0x70, 0x3A, 0x09, 0x77, 0x03, 0xA0, 0x97, 0x70, 0x3A,
  0x09, 0x77, 0x82, 0x17, 0x74,
  // "®" (U+00AE)
  0x68, 0x90, 0x16, 0xAD, 0xEE, 0xDB, 0x72, 0x74, 0x08, 0xFB, 0x09, 0x01, 0x70, 0x10, 0xCA, 0x81,
  0xA5, 0x12, 0x81, 0x25, 0xBA, 0x0D, 0x02, 0x68, 0x2D, 0xFD, 0x27, 0x18, 0x33, 0xDF, 0xD1, 0x48,
  0x92, 0x9F, 0xD1, 0x08, 0xEE, 0xED, 0xB5, 0x28, 0x21, 0xDF, 0xA3, 0x02, 0xA0, 0x22, 0x09, 0xE0,
  0x82, 0x03, 0xA0, 0x32, 0x81, 0x9F, 0x93, 0x84, 0x9F, 0x60, 0x17, 0xA0, 0x12, 0x81, 0xAF, 0x92,
  0x81, 0xDF, 0x43, 0x81, 0x9F, 0x63, 0x81, 0xDF, 0x42, 0x83, 0x4F, 0xD0, 0x1A, 0x48, 0x19, 0xF6,
  0x38, 0x1D, 0xF3, 0x3A, 0x82, 0x12, 0xFE, 0x48, 0x19, 0xF6, 0x28, 0x16, 0xFE, 0x48, 0x4E, 0xF2,
  0x3F, 0xD4, 0x83, 0x9F, 0xED, 0xEA, 0x05, 0x48, 0x4D, 0xF3, 0x2F, 0xD4, 0x09, 0xD0, 0x55, 0x82,
  0xEF, 0x21, 0xA4, 0x85, 0x9F, 0x60, 0x8F, 0xB5, 0xA8, 0x31, 0x0E, 0xF4, 0x38, 0x69, 0xF6, 0x01,
  0xEF, 0x53, 0x81, 0x3F, 0xD2, 0x81, 0x9F, 0x93, 0x81, 0x9F, 0x62, 0x81, 0x6F, 0xD3, 0x81, 0x9F,
  0x92, 0x03, 0xA0, 0x32, 0x81, 0x9F, 0x63, 0x83, 0xCF, 0x80, 0x1A, 0x02, 0x38, 0x6A, 0xFD, 0x10,
  0x7C, 0x53, 0x85, 0x4C, 0xC2, 0xCF, 0x94, 0x83, 0x1E, 0xFD, 0x27, 0x18, 0x31, 0xCF, 0xD1, 0x50,
  0x20, 0xDA, 0x09, 0x03, 0x40, 0x30, 0x9A, 0x0D, 0x02, 0x70, 0x10, 0xAC, 0x00, 0xEC, 0x09, 0x74,
  0x82, 0x27, 0xBE, 0xA8, 0x2D, 0xB7, 0x16,
  // "¯" (U+00AF)
  0x0D, 0x80, 0x6E, 0x0D, 0x0E, 0xFB, 0x00, 0xEF, 0xB0, 0xE0,
  // "°" (U+00B0)
  0x38, 0x46, 0xCE, 0xEC, 0x64, 0x02, 0x0C, 0xE0, 0xC0, 0x22, 0x0D, 0xF9, 0x81, 0xD0, 0x7A, 0x0B,
  0x03, 0x20, 0x30, 0xBA, 0x82, 0x7D, 0xFC, 0x68, 0x1B, 0xFC, 0xA0, 0x76, 0x06, 0xC0, 0x76, 0x06,
  0xA8, 0x1D, 0xFC, 0x68, 0x2B, 0xFD, 0x8A, 0x0C, 0x04, 0x20, 0x30, 0xBA, 0x81, 0x71, 0xDF, 0x98,
  0x3D, 0x10, 0x3D, 0xE0, 0xD0, 0x23, 0x86, 0x17, 0xCE, 0xEC, 0x71, 0x20,
  // "±" (U+00B1)
  0x70, 0x8A, 0x05, 0x77, 0x08, 0xA0, 0x57, 0x70, 0x8A, 0x05, 0x77, 0x08, 0xA0, 0x57, 0x70, 0x8A,
  0x05, 0x77, 0x08, 0xA0, 0x57, 0x70, 0x8A, 0x05, 0x77, 0x08, 0xA0, 0x57, 0x0D, 0x80, 0x2E, 0xB8,
  0x03, 0xE0, 0xB0, 0xEF, 0xFA, 0x0C, 0x0E, 0xFF, 0xA0, 0xC7, 0x08, 0xA0, 0x57, 0x70, 0x8A, 0x05,
  0x77, 0x08, 0xA0, 0x57, 0x70, 0x8A, 0x05, 0x77, 0x08, 0xA0, 0x57, 0x70, 0x8A, 0x05, 0x77, 0x08,
  0xA0, 0x57, 0x70, 0x8A, 0x05, 0x80, 0xC7, 0x00, 0xB8, 0x09, 0x4E, 0x0B, 0x0C, 0xFF, 0xA0, 0x0C,
  0xFF, 0xA0, 0xC0,
  // "²" (U+00B2)
  0x48, 0x23, 0x45, 0x37, 0x07, 0x0E, 0xC0, 0xE0, 0x73, 0x03, 0x0D, 0xF9, 0x09, 0x20, 0x2A, 0x84,
  0xA3, 0x01, 0x5E, 0xA0, 0x32, 0x06, 0x05, 0x50, 0x5A, 0x07, 0x72, 0x02, 0xA0, 0x87, 0x20, 0x3A,
  0x07, 0x72, 0x09, 0xA0, 0x27, 0x10, 0x4A, 0x09, 0x71, 0x82, 0x3E, 0xFD, 0x71, 0x83, 0x3E, 0xFD,
  0x17, 0x83, 0x3E, 0xFD, 0x27, 0x83, 0x4E, 0xFD, 0x17, 0x83, 0x4E, 0xFC, 0x17, 0x04, 0xA0, 0xC0,
  0x17, 0x05, 0xA0, 0xE0, 0x68, 0x03, 0x50, 0x10, 0xCF, 0xC0, 0x30, 0xCF, 0xC0, 0x30,
  // "³" (U+00B3)
  0x28, 0x64, 0xAD, 0xFE, 0xC8, 0x12, 0x02, 0x0C, 0xF8, 0x2E, 0x20, 0x5A, 0x83, 0xD8, 0x67, 0xDA,
  0x0C, 0x20, 0x80, 0x64, 0x01, 0x0D, 0xA0, 0x27, 0x10, 0xAA, 0x03, 0x71, 0x0B, 0xA0, 0x27, 0x03,
  0xA0, 0xD3, 0x84, 0x25, 0x56, 0x9E, 0xA0, 0x33, 0x07, 0xD0, 0xD0, 0x34, 0x07, 0xE0, 0xD0, 0x46,
  0x81, 0x12, 0x8B, 0x02, 0x71, 0x06, 0xA0, 0x97, 0x10, 0x1A, 0x0B, 0x71, 0x03, 0xA8, 0x1B, 0x62,
  0x60, 0xBA, 0x87, 0x7C, 0xFC, 0x86, 0x67, 0xDA, 0x81, 0xE1, 0xBF, 0x90, 0xE0, 0x32, 0x81, 0x6A,
  0xDA, 0x82, 0xEB, 0x71, 0x20,
  // "´" (U+00B4)
  0x48, 0x33, 0x77, 0x76, 0x40, 0xDB, 0x07, 0x30, 0x7B, 0x0A, 0x30, 0x2B, 0x0B, 0x40, 0xBA, 0x0C,
  0x40, 0x6A, 0x0C, 0x01, 0x30, 0x1A, 0x0B, 0x50,
  // "µ" (U+00B5)
  0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0,
  0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97,
  0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30,
  0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xDA,
  0x0C, 0xB0, 0x97, 0x30, 0xEA, 0x0C, 0xB0, 0x97, 0x20, 0x2B, 0x0C, 0xB0, 0xB7, 0x20, 0x6B, 0x0C,
  0xB0, 0xE7, 0x20, 0xDB, 0x0C, 0xC0, 0x87, 0x08, 0xC0, 0xCD, 0x09, 0x02, 0x30, 0x40, 0xAA, 0x0D,
  0xA0, 0xCF, 0x90, 0xEC, 0x09, 0x07, 0xA0, 0xCF, 0xD8, 0x19, 0x04, 0xA0, 0xCB, 0x81, 0xDC, 0xEA,
  0x82, 0xEC, 0x82, 0x20, 0x2A, 0x0C, 0xB0, 0x97, 0x7B, 0x09, 0x77, 0xB0, 0x97, 0x7B, 0x09, 0x77,
  0xB0, 0x97, 0x7B, 0x09, 0x77, 0xB0, 0x97, 0x7B, 0x09, 0x77, 0xB0, 0x97, 0x7B, 0x09, 0x77,
  // "¶" (U+00B6)
  0x48, 0x24, 0x9C, 0xEF, 0xC0, 0x82, 0x02, 0x0C, 0xFF, 0x98, 0x28, 0x01, 0xDF, 0xB8, 0x74, 0x22,
  0x2C, 0xF8, 0x0A, 0xFC, 0x02, 0x38, 0x2B, 0xF8, 0x2F, 0xD0, 0x23, 0x82, 0xBF, 0x87, 0xFD, 0x02,
  0x38, 0x2B, 0xF8, 0xAF, 0xD0, 0x23, 0x82, 0xBF, 0x8D, 0xFD, 0x02, 0x38, 0x2B, 0xF8, 0xEF, 0xD0,
  0x23, 0x81, 0xBF, 0x8F, 0xE0, 0x23, 0x81, 0xBF, 0x8F, 0xE0, 0x23, 0x82, 0xBF, 0x8E, 0xFD, 0x02,
  0x38, 0x2B, 0xF8, 0xDF, 0xD0, 0x23, 0x82, 0xBF, 0x8B, 0xFD, 0x02, 0x38, 0x2B, 0xF8, 0x7F, 0xD0,
  0x23, 0x82, 0xBF, 0x83, 0xFD, 0x02, 0x38, 0x3B, 0xF8, 0x0B, 0xFC, 0x02, 0x38, 0x4B, 0xF8, 0x02,
  0xEF, 0xB0, 0x23, 0x81, 0xBF, 0x82, 0x03, 0x0D, 0xFA, 0x02, 0x38, 0x1B, 0xF8, 0x48, 0x55, 0xAC,
  0xDD, 0xCA, 0xA0, 0x23, 0x81, 0xBF, 0x87, 0x30, 0x2A, 0x02, 0x38, 0x1B, 0xF8, 0x73, 0x02, 0xA0,
  0x23, 0x81, 0xBF, 0x87, 0x30, 0x2A, 0x02, 0x38, 0x1B, 0xF8, 0x73, 0x02, 0xA0, 0x23, 0x81, 0xBF,
  0x87, 0x30, 0x2A, 0x02, 0x38, 0x1B, 0xF8, 0x73, 0x02, 0xA0, 0x23, 0x81, 0xBF, 0x87, 0x30, 0x2A,
  0x02, 0x38, 0x1B, 0xF8, 0x73, 0x02, 0xA0, 0x23, 0x81, 0xBF, 0x87, 0x30, 0x2A, 0x02, 0x38, 0x1B,
  0xF8, 0x73, 0x02, 0xA0, 0x23, 0x81, 0xBF, 0x87, 0x30, 0x2A, 0x02, 0x38, 0x1B, 0xF8, 0x73, 0x02,
  0xA0, 0x23, 0x81, 0xBF, 0x87, 0x30, 0x2A, 0x02, 0x38, 0x1B, 0xF8, 0x73, 0x02, 0xA0, 0x23, 0x81,
  0xBF, 0x87, 0x30, 0x2A, 0x02, 0x38, 0x1B, 0xF8, 0x73, 0x82, 0x19, 0x91, 0x38, 0x17, 0x95,
  // "·" (U+00B7)
  0x08, 0xEE, 0x80, 0x4F, 0xFF, 0xF4, 0x6F, 0xFF, 0xF6, 0x4F, 0xFF, 0xF4, 0x08, 0xEE, 0x80,
  // "¸" (U+00B8)
  0x20, 0x1A, 0x03, 0x48, 0x18, 0xFC, 0x48, 0x31, 0xEF, 0xB3, 0x30, 0x50, 0xEB, 0x0A, 0x40, 0x40,
  0xCA, 0x08, 0x40, 0x1A, 0x0C, 0x40, 0x1A, 0x84, 0xC4, 0x33, 0x5C, 0xA0, 0x8E, 0x81, 0xC0, 0xEA,
  0x81, 0xEB, 0x62,
  // "¹" (U+00B9)
  0x30, 0x10, 0x8A, 0x0E, 0x70, 0x60, 0xEB, 0x0E, 0x50, 0x30, 0xCB, 0x81, 0xEF, 0xE5, 0x0C, 0xA8,
  0x3E, 0x69, 0xFE, 0x58, 0x63, 0xFA, 0x10, 0xAF, 0xE6, 0x01, 0x38, 0x1A, 0xFE, 0x73, 0x81, 0xAF,
  0xE7, 0x38, 0x1A, 0xFE, 0x73, 0x81, 0xAF, 0xE7, 0x38, 0x1A, 0xFE, 0x73, 0x81, 0xAF, 0xE7, 0x38,
  0x1A, 0xFE, 0x73, 0x81, 0xAF, 0xE7, 0x38, 0x1A, 0xFE, 0x68, 0x00, 0x28, 0x1B, 0xFE, 0x80, 0x02,
  0x20, 0xCF, 0xB8, 0x13, 0x0C, 0xFB, 0x03,
  // "º" (U+00BA)
  0x38, 0x44, 0x9B, 0xB9, 0x35, 0x0A, 0xE0, 0xA3, 0x82, 0xAF, 0xE5, 0x28, 0x45, 0xEF, 0x90, 0x3A,
  0x06, 0x40, 0x6A, 0x82, 0x28, 0xFE, 0x6A, 0x82, 0x8B, 0xFB, 0x68, 0x4C, 0xFB, 0xDF, 0xA6, 0x84,
  0xBF, 0xCD, 0xFA, 0x68, 0x4B, 0xFC, 0xCF, 0xB6, 0x84, 0xCF, 0xB9, 0xFD, 0x68, 0x2E, 0xF8, 0x4A,
  0x03, 0x40, 0x4A, 0x84, 0x40, 0xCF, 0xC2, 0x28, 0x22, 0xDF, 0xB2, 0x02, 0x0D, 0xA0, 0xC0, 0xDA,
  0x0C, 0x01, 0x48, 0x47, 0xCE, 0xEC, 0x73,
  // "»" (U+00BB)
  0x18, 0x11, 0x93, 0x58, 0x11, 0xA1, 0x68, 0x32, 0xDF, 0xE2, 0x38, 0x23, 0xEF, 0xC7, 0x0C, 0xA0,
  0xC3, 0x01, 0x0D, 0xA0, 0xA6, 0x01, 0x0E, 0xA0, 0xA3, 0x03, 0xB0, 0x76, 0x03, 0xB0, 0x83, 0x06,
  0xB0, 0x56, 0x06, 0xB0, 0x53, 0x09, 0xA0, 0xE0, 0x26, 0x09, 0xB0, 0x33, 0x0C, 0xA0, 0xD0, 0x16,
  0x0C, 0xA0, 0xE0, 0x12, 0x01, 0x0E, 0xA0, 0xB6, 0x03, 0xB0, 0x93, 0x06, 0xB0, 0x65, 0x0B, 0xA0,
  0xE0, 0x22, 0x01, 0x0D, 0xA0, 0xC5, 0x08, 0xB0, 0x43, 0x0B, 0xA0, 0xE0, 0x24, 0x05, 0xB0, 0x73,
  0x09, 0xB0, 0x44, 0x02, 0x0E, 0xA0, 0x93, 0x06, 0xB0, 0x64, 0x01, 0x0D, 0xA0, 0xC3, 0x03, 0xB0,
  0x95, 0x0B, 0xA0, 0xD0, 0x12, 0x01, 0x0E, 0xA0, 0xB5, 0x83, 0x2E, 0xFE, 0x33, 0x83, 0x4E, 0xFD,
  0x16, 0x81, 0x1B, 0x55, 0x81, 0x2C, 0x36,
  // "¼" (U+00BC)
  0x30, 0x8A, 0x0E, 0x73, 0x02, 0xA0, 0xD3, 0x05, 0x0E, 0xB0, 0xE7, 0x30, 0x9A, 0x06, 0x20, 0x9B,
  0x81, 0xEF, 0xE7, 0x20, 0x2A, 0x0D, 0x30, 0x3A, 0x82, 0x69, 0xFE, 0x72, 0x0A, 0xA0, 0x54, 0x84,
  0x62, 0x09, 0xFE, 0x71, 0x02, 0xA0, 0xD7, 0x18, 0x19, 0xFE, 0x71, 0x0A, 0xA0, 0x57, 0x18, 0x19,
  0xFE, 0x70, 0x3A, 0x0D, 0x72, 0x81, 0x9F, 0xE7, 0x0B, 0xA0, 0x57, 0x28, 0x19, 0xFE, 0x60, 0x3A,
  0x0C, 0x73, 0x81, 0x9F, 0xE6, 0x0B, 0xA0, 0x57, 0x38, 0x19, 0xFE, 0x50, 0x3A, 0x0C, 0x72, 0x81,
  0x23, 0xBA, 0x81, 0x32, 0x12, 0x0B, 0xA0, 0x47, 0x10, 0xBF, 0x90, 0x30, 0x4A, 0x0C, 0x72, 0x0B,
  0xF9, 0x03, 0x0B, 0xA0, 0x47, 0x74, 0x04, 0xA0, 0xC4, 0x0F, 0x37, 0x50, 0xCA, 0x04, 0x30, 0x4A,
  0x0D, 0x74, 0x04, 0xA0, 0xB3, 0x01, 0x0D, 0xA0, 0xD7, 0x40, 0xCA, 0x03, 0x30, 0xAB, 0x0D, 0x73,
  0x05, 0xA0, 0xB3, 0x05, 0xA8, 0x1C, 0xFD, 0x73, 0x0C, 0xA0, 0x32, 0x85, 0x1E, 0xF9, 0xAF, 0xD7,
  0x20, 0x5A, 0x0B, 0x38, 0x5A, 0xFD, 0x0A, 0xFD, 0x72, 0x0D, 0xA0, 0x32, 0x05, 0xA8, 0x34, 0x0A,
  0xFD, 0x71, 0x05, 0xA0, 0xA2, 0x82, 0x1E, 0xF9, 0x28, 0x1A, 0xFD, 0x71, 0x0D, 0xA0, 0x32, 0x0B,
  0xA8, 0x64, 0x33, 0xBF, 0xE3, 0x35, 0x06, 0xA0, 0xA3, 0xFB, 0x0E, 0x50, 0xDA, 0x02, 0x3F, 0xB0,
  0xE4, 0x06, 0xA0, 0xA7, 0x38, 0x1A, 0xFD, 0x60, 0xDA, 0x02, 0x73, 0x81, 0xAF, 0xD5, 0x06, 0xA0,
  0xA7, 0x48, 0x1A, 0xFD, 0x20,
  // "½" (U+00BD)
  0x30, 0x8A, 0x0E, 0x73, 0x02, 0xA0, 0xD3, 0x05, 0x0E, 0xB0, 0xE7, 0x30, 0x9A, 0x06, 0x20, 0x9B,
  0x81, 0xEF, 0xE7, 0x20, 0x2A, 0x0D, 0x30, 0x3A, 0x82, 0x69, 0xFE, 0x72, 0x0A, 0xA0, 0x54, 0x84,
  0x62, 0x09, 0xFE, 0x71, 0x02, 0xA0, 0xD7, 0x18, 0x19, 0xFE, 0x71, 0x0A, 0xA0, 0x57, 0x18, 0x19,
  0xFE, 0x70, 0x3A, 0x0D, 0x72, 0x81, 0x9F, 0xE7, 0x0B, 0xA0, 0x57, 0x28, 0x19, 0xFE, 0x60, 0x3A,
  0x0C, 0x73, 0x81, 0x9F, 0xE6, 0x0B, 0xA0, 0x57, 0x38, 0x19, 0xFE, 0x50, 0x3A, 0x0C, 0x72, 0x81,
  0x23, 0xBA, 0x81, 0x32, 0x12, 0x0B, 0xA0, 0x47, 0x10, 0xBF, 0x90, 0x30, 0x4A, 0x0C, 0x72, 0x0B,
  0xF9, 0x03, 0x0B, 0xA0, 0x47, 0x74, 0x04, 0xA0, 0xC2, 0x82, 0x24, 0x42, 0x76, 0x0C, 0xA8, 0x14,
  0x4C, 0xC0, 0xC0, 0x27, 0x30, 0x4A, 0x0B, 0x05, 0xF0, 0xE0, 0x17, 0x20, 0xCA, 0x86, 0x30, 0xCD,
  0x40, 0x1A, 0xA0, 0x77, 0x10, 0x5A, 0x0B, 0x20, 0x14, 0x02, 0xA0, 0x97, 0x10, 0xCA, 0x03, 0x70,
  0x2A, 0x07, 0x70, 0x5A, 0x0B, 0x71, 0x09, 0xA0, 0x37, 0x0D, 0xA0, 0x37, 0x06, 0xA0, 0x87, 0x05,
  0xA0, 0xB7, 0x07, 0xA0, 0xA7, 0x10, 0xDA, 0x03, 0x60, 0x8A, 0x09, 0x71, 0x06, 0xA0, 0xA6, 0x09,
  0xA0, 0x87, 0x20, 0xDA, 0x02, 0x50, 0xAA, 0x06, 0x72, 0x06, 0xA0, 0xA5, 0x0A, 0xB8, 0x01, 0xE0,
  0xD4, 0x0D, 0xA0, 0x25, 0x0B, 0xF9, 0x0E, 0x30, 0x6A, 0x0A, 0x60, 0xBF, 0x90, 0xE0,
  // "¾" (U+00BE)
  0x18, 0x56, 0xBE, 0xFE, 0xA3, 0x72, 0x81, 0x9A, 0x92, 0x0D, 0xF0, 0x47, 0x07, 0xA0, 0x82, 0x84,
  0x8F, 0xB5, 0x49, 0xA0, 0xD7, 0x82, 0xEF, 0xE1, 0x30, 0x34, 0x0D, 0xA0, 0x15, 0x07, 0xA0, 0x87,
  0x20, 0xDA, 0x58, 0x31, 0xEF, 0xE1, 0x70, 0x10, 0x8A, 0x0B, 0x50, 0x8A, 0x07, 0x50, 0x5D, 0x0A,
  0x01, 0x48, 0x21, 0xEF, 0xE6, 0x05, 0xD0, 0xD0, 0x44, 0x09, 0xA0, 0x76, 0x83, 0x13, 0x35, 0x8B,
  0x02, 0x20, 0x1A, 0x0E, 0x75, 0x08, 0xA0, 0x62, 0x09, 0xA0, 0x67, 0x50, 0x7A, 0x81, 0x60, 0x2A,
  0x0D, 0x78, 0x5B, 0x62, 0x01, 0x5E, 0xA8, 0x13, 0x0A, 0xA0, 0x67, 0x0E, 0xF8, 0x19, 0x02, 0xA0,
  0xD7, 0x10, 0x90, 0xEC, 0x0D, 0x07, 0x20, 0xAA, 0x05, 0x73, 0x82, 0x23, 0x31, 0x30, 0x3A, 0x0D,
  0x40, 0xF3, 0x74, 0x0B, 0xA0, 0x53, 0x04, 0xA0, 0xD7, 0x30, 0x3A, 0x0C, 0x30, 0x10, 0xDA, 0x0D,
  0x73, 0x0B, 0xA0, 0x53, 0x0A, 0xB0, 0xD7, 0x20, 0x4A, 0x0C, 0x30, 0x5A, 0x81, 0xCF, 0xD7, 0x20,
  0xCA, 0x04, 0x28, 0x51, 0xEF, 0x9A, 0xFD, 0x71, 0x04, 0xA0, 0xC3, 0x85, 0xAF, 0xD0, 0xAF, 0xD7,
  0x10, 0xCA, 0x04, 0x20, 0x5A, 0x83, 0x40, 0xAF, 0xD7, 0x05, 0xA0, 0xB2, 0x82, 0x1E, 0xF9, 0x28,
  0x1A, 0xFD, 0x70, 0xDA, 0x03, 0x20, 0xBA, 0x86, 0x43, 0x3B, 0xFE, 0x33, 0x40, 0x5A, 0x0B, 0x3F,
  0xB0, 0xE4, 0x0D, 0xA0, 0x33, 0xFB, 0x0E, 0x30, 0x6A, 0x0A, 0x73, 0x81, 0xAF, 0xD5, 0x0D, 0xA0,
  0x27, 0x38, 0x1A, 0xFD, 0x40, 0x6A, 0x0A, 0x74, 0x81, 0xAF, 0xD2,
  // "¿" (U+00BF)
  0x71, 0x82, 0x7E, 0xE9, 0x76, 0x03, 0xC0, 0x57, 0x50, 0x5C, 0x08, 0x75, 0x03, 0xC0, 0x57, 0x68,
  0x27, 0xEE, 0x98, 0x09, 0x80, 0x08, 0x24, 0xEE, 0xB7, 0x70, 0x6A, 0x0B, 0x77, 0x09, 0xA0, 0x97,
  0x60, 0x3B, 0x06, 0x75, 0x03, 0x0E, 0xA0, 0xE7, 0x50, 0x50, 0xEB, 0x04, 0x74, 0x08, 0xC0, 0x57,
  0x40, 0xAB, 0x0D, 0x03, 0x74, 0x09, 0xB0, 0xB0, 0x17, 0x40, 0x5B, 0x0A, 0x76, 0x0C, 0xA0, 0xD7,
  0x60, 0x1B, 0x06, 0x76, 0x04, 0xB0, 0x27, 0x60, 0x5B, 0x77, 0x05, 0xB7, 0x70, 0x3B, 0x04, 0x77,
  0x0E, 0xA0, 0xD0, 0x17, 0x18, 0x11, 0x83, 0x20, 0x6B, 0x81, 0xD6, 0x13, 0x81, 0x26, 0xBA, 0x0A,
  0x30, 0xAE, 0x0E, 0xF0, 0x13, 0x07, 0xFC, 0x81, 0xE8, 0x14, 0x89, 0x11, 0x6A, 0xDE, 0xFE, 0xDB,
  0x83, 0x30,
  // "À" (U+00C0)
  0x68, 0x33, 0x77, 0x76, 0x77, 0x50, 0x10, 0xEB, 0x04, 0x77, 0x50, 0x4B, 0x0D, 0x77, 0x60, 0x5B,
  0x07, 0x77, 0x60, 0x6B, 0x02, 0x77, 0x60, 0x7A, 0x0C, 0x77, 0x70, 0x5A, 0x07, 0x80, 0xF6, 0x00,
  0x1C, 0x77, 0x50, 0x6C, 0x05, 0x77, 0x40, 0xBC, 0x0A, 0x77, 0x30, 0x1D, 0x0E, 0x77, 0x30, 0x5A,
  0x0D, 0x0E, 0xA0, 0x57, 0x72, 0x0A, 0xA0, 0x90, 0xAA, 0x09, 0x77, 0x20, 0xEA, 0x05, 0x06, 0xA0,
  0xE7, 0x71, 0x05, 0xB0, 0x10, 0x2B, 0x04, 0x77, 0x0A, 0xA0, 0xC2, 0x0D, 0xA0, 0x97, 0x70, 0xEA,
  0x07, 0x20, 0x8A, 0x0E, 0x76, 0x04, 0xB0, 0x22, 0x03, 0xB0, 0x37, 0x50, 0x9A, 0x0D, 0x40, 0xEA,
  0x08, 0x75, 0x0E, 0xA0, 0x84, 0x09, 0xA0, 0xD7, 0x40, 0x3B, 0x03, 0x40, 0x4B, 0x03, 0x73, 0x08,
  0xA0, 0xE6, 0x0E, 0xA0, 0x87, 0x30, 0xDA, 0x09, 0x60, 0xAA, 0x0D, 0x72, 0x03, 0xB0, 0x56, 0x05,
  0xB0, 0x27, 0x10, 0x8B, 0x80, 0x4E, 0xB0, 0x77, 0x10, 0xDF, 0xF0, 0xC7, 0x02, 0xFF, 0xA0, 0x26,
  0x07, 0xA0, 0xE7, 0x20, 0x1B, 0x07, 0x60, 0xCA, 0x0A, 0x73, 0x0B, 0xA0, 0xC5, 0x01, 0xB0, 0x67,
  0x30, 0x7B, 0x01, 0x40, 0x6B, 0x01, 0x73, 0x02, 0xB0, 0x64, 0x0B, 0xA0, 0xC7, 0x50, 0xDA, 0x0B,
  0x30, 0x1B, 0x07, 0x75, 0x08, 0xB0, 0x12, 0x06, 0xB0, 0x27, 0x50, 0x3B, 0x06, 0x20, 0xBA, 0x0D,
  0x77, 0x0E, 0xA8, 0x1B, 0x01, 0xB0, 0x97, 0x70, 0x9B, 0x01,
  // "Á" (U+00C1)
  0x77, 0x83, 0x37, 0x77, 0x67, 0x75, 0x0D, 0xB0, 0x77, 0x74, 0x07, 0xB0, 0xA7, 0x74, 0x02, 0xB0,
  0xB7, 0x75, 0x0B, 0xA0, 0xC7, 0x75, 0x06, 0xA0, 0xC0, 0x17, 0x74, 0x01, 0xA0, 0xB8, 0x0F, 0x70,
  0x01, 0xC7, 0x75, 0x06, 0xC0, 0x57, 0x74, 0x0B, 0xC0, 0xA7, 0x73, 0x01, 0xD0, 0xE7, 0x73, 0x05,
  0xA0, 0xD0, 0xEA, 0x05, 0x77, 0x20, 0xAA, 0x09, 0x0A, 0xA0, 0x97, 0x72, 0x0E, 0xA0, 0x50, 0x6A,
  0x0E, 0x77, 0x10, 0x5B, 0x01, 0x02, 0xB0, 0x47, 0x70, 0xAA, 0x0C, 0x20, 0xDA, 0x09, 0x77, 0x0E,
  0xA0, 0x72, 0x08, 0xA0, 0xE7, 0x60, 0x4B, 0x02, 0x20, 0x3B, 0x03, 0x75, 0x09, 0xA0, 0xD4, 0x0E,
  0xA0, 0x87, 0x50, 0xEA, 0x08, 0x40, 0x9A, 0x0D, 0x74, 0x03, 0xB0, 0x34, 0x04, 0xB0, 0x37, 0x30,
  0x8A, 0x0E, 0x60, 0xEA, 0x08, 0x73, 0x0D, 0xA0, 0x96, 0x0A, 0xA0, 0xD7, 0x20, 0x3B, 0x05, 0x60,
  0x5B, 0x02, 0x71, 0x08, 0xB8, 0x04, 0xEB, 0x07, 0x71, 0x0D, 0xFF, 0x0C, 0x70, 0x2F, 0xFA, 0x02,
  0x60, 0x7A, 0x0E, 0x72, 0x01, 0xB0, 0x76, 0x0C, 0xA0, 0xA7, 0x30, 0xBA, 0x0C, 0x50, 0x1B, 0x06,
  0x73, 0x07, 0xB0, 0x14, 0x06, 0xB0, 0x17, 0x30, 0x2B, 0x06, 0x40, 0xBA, 0x0C, 0x75, 0x0D, 0xA0,
  0xB3, 0x01, 0xB0, 0x77, 0x50, 0x8B, 0x01, 0x20, 0x6B, 0x02, 0x75, 0x03, 0xB0, 0x62, 0x0B, 0xA0,
  0xD7, 0x70, 0xEA, 0x81, 0xB0, 0x1B, 0x09, 0x77, 0x09, 0xB0, 0x10,
  // "Â" (U+00C2)
  0x73, 0x80, 0x07, 0x77, 0x50, 0x7C, 0x06, 0x77, 0x30, 0x4D, 0x0E, 0x02, 0x77, 0x10, 0x20, 0xEA,
  0x08, 0x0A, 0xA0, 0xD0, 0x17, 0x60, 0x10, 0xDA, 0x07, 0x20, 0xAA, 0x0C, 0x76, 0x0B, 0xA0, 0x74,
  0x09, 0xA0, 0xB7, 0x48, 0x29, 0xFE, 0x56, 0x06, 0xA0, 0x98, 0x0F, 0x20, 0x01, 0xC7, 0x75, 0x06,
  0xC0, 0x57, 0x74, 0x0B, 0xC0, 0xA7, 0x73, 0x01, 0xD0, 0xE7, 0x73, 0x05, 0xA0, 0xD0, 0xEA, 0x05,
  0x77, 0x20, 0xAA, 0x09, 0x0A, 0xA0, 0x97, 0x72, 0x0E, 0xA0, 0x50, 0x6A, 0x0E, 0x77, 0x10, 0x5B,
  0x01, 0x02, 0xB0, 0x47, 0x70, 0xAA, 0x0C, 0x20, 0xDA, 0x09, 0x77, 0x0E, 0xA0, 0x72, 0x08, 0xA0,
  0xE7, 0x60, 0x4B, 0x02, 0x20, 0x3B, 0x03, 0x75, 0x09, 0xA0, 0xD4, 0x0E, 0xA0, 0x87, 0x50, 0xEA,
  0x08, 0x40, 0x9A, 0x0D, 0x74, 0x03, 0xB0, 0x34, 0x04, 0xB0, 0x37, 0x30, 0x8A, 0x0E, 0x60, 0xEA,
  0x08, 0x73, 0x0D, 0xA0, 0x96, 0x0A, 0xA0, 0xD7, 0x20, 0x3B, 0x05, 0x60, 0x5B, 0x02, 0x71, 0x08,
  0xB8, 0x04, 0xEB, 0x07, 0x71, 0x0D, 0xFF, 0x0C, 0x70, 0x2F, 0xFA, 0x02, 0x60, 0x7A, 0x0E, 0x72,
  0x01, 0xB0, 0x76, 0x0C, 0xA0, 0xA7, 0x30, 0xBA, 0x0C, 0x50, 0x1B, 0x06, 0x73, 0x07, 0xB0, 0x14,
  0x06, 0xB0, 0x17, 0x30, 0x2B, 0x06, 0x40, 0xBA, 0x0C, 0x75, 0x0D, 0xA0, 0xB3, 0x01, 0xB0, 0x77,
  0x50, 0x8B, 0x01, 0x20, 0x6B, 0x02, 0x75, 0x03, 0xB0, 0x62, 0x0B, 0xA0, 0xD7, 0x70, 0xEA, 0x81,
  0xB0, 0x1B, 0x09, 0x77, 0x09, 0xB0, 0x10,
  // "Ã" (U+00C3)
  0x68, 0x41, 0x9E, 0xEB, 0x55, 0x81, 0xEF, 0x17, 0x30, 0xDD, 0x0C, 0x05, 0x28, 0x19, 0xFD, 0x73,
  0x07, 0xFD, 0x07, 0x73, 0x81, 0xDF, 0x92, 0x04, 0x0C, 0xD0, 0xD7, 0x30, 0x1A, 0x58, 0x45, 0xCE,
  0xE9, 0x18, 0x0F, 0x30, 0x01, 0xC7, 0x75, 0x06, 0xC0, 0x57, 0x74, 0x0B, 0xC0, 0xA7, 0x73, 0x01,
  0xD0, 0xE7, 0x73, 0x05, 0xA0, 0xD0, 0xEA, 0x05, 0x77, 0x20, 0xAA, 0x09, 0x0A, 0xA0, 0x97, 0x72,
  0x0E, 0xA0, 0x50, 0x6A, 0x0E, 0x77, 0x10, 0x5B, 0x01, 0x02, 0xB0, 0x47, 0x70, 0xAA, 0x0C, 0x20,
  0xDA, 0x09, 0x77, 0x0E, 0xA0, 0x72, 0x08, 0xA0, 0xE7, 0x60, 0x4B, 0x02, 0x20, 0x3B, 0x03, 0x75,
  0x09, 0xA0, 0xD4, 0x0E, 0xA0, 0x87, 0x50, 0xEA, 0x08, 0x40, 0x9A, 0x0D, 0x74, 0x03, 0xB0, 0x34,
  0x04, 0xB0, 0x37, 0x30, 0x8A, 0x0E, 0x60, 0xEA, 0x08, 0x73, 0x0D, 0xA0, 0x96, 0x0A, 0xA0, 0xD7,
  0x20, 0x3B, 0x05, 0x60, 0x5B, 0x02, 0x71, 0x08, 0xB8, 0x04, 0xEB, 0x07, 0x71, 0x0D, 0xFF, 0x0C,
  0x70, 0x2F, 0xFA, 0x02, 0x60, 0x7A, 0x0E, 0x72, 0x01, 0xB0, 0x76, 0x0C, 0xA0, 0xA7, 0x30, 0xBA,
  0x0C, 0x50, 0x1B, 0x06, 0x73, 0x07, 0xB0, 0x14, 0x06, 0xB0, 0x17, 0x30, 0x2B, 0x06, 0x40, 0xBA,
  0x0C, 0x75, 0x0D, 0xA0, 0xB3, 0x01, 0xB0, 0x77, 0x50, 0x8B, 0x01, 0x20, 0x6B, 0x02, 0x75, 0x03,
  0xB0, 0x62, 0x0B, 0xA0, 0xD7, 0x70, 0xEA, 0x81, 0xB0, 0x1B, 0x09, 0x77, 0x09, 0xB0, 0x10,
  // "Ä" (U+00C4)
  0x58, 0x21, 0xBE, 0xA6, 0x82, 0xAE, 0xC2, 0x73, 0x08, 0xB0, 0x74, 0x06, 0xB0, 0x97, 0x30, 0xAB,
  0x09, 0x40, 0x8B, 0x0B, 0x73, 0x08, 0xB0, 0x64, 0x05, 0xB0, 0x97, 0x38, 0x21, 0xBE, 0xA6, 0x82,
  0x9E, 0xB1, 0x80, 0x9A, 0x20, 0x01, 0xC7, 0x75, 0x06, 0xC0, 0x57, 0x74, 0x0B, 0xC0, 0xA7, 0x73,
  0x01, 0xD0, 0xE7, 0x73, 0x05, 0xA0, 0xD0, 0xEA, 0x05, 0x77, 0x20, 0xAA, 0x09, 0x0A, 0xA0, 0x97,
  0x72, 0x0E, 0xA0, 0x50, 0x6A, 0x0E, 0x77, 0x10, 0x5B, 0x01, 0x02, 0xB0, 0x47, 0x70, 0xAA, 0x0C,
  0x20, 0xDA, 0x09, 0x77, 0x0E, 0xA0, 0x72, 0x08, 0xA0, 0xE7, 0x60, 0x4B, 0x02, 0x20, 0x3B, 0x03,
  0x75, 0x09, 0xA0, 0xD4, 0x0E, 0xA0, 0x87, 0x50, 0xEA, 0x08, 0x40, 0x9A, 0x0D, 0x74, 0x03, 0xB0,
  0x34, 0x04, 0xB0, 0x37, 0x30, 0x8A, 0x0E, 0x60, 0xEA, 0x08, 0x73, 0x0D, 0xA0, 0x96, 0x0A, 0xA0,
  0xD7, 0x20, 0x3B, 0x05, 0x60, 0x5B, 0x02, 0x71, 0x08, 0xB8, 0x04, 0xEB, 0x07, 0x71, 0x0D, 0xFF,
  0x0C, 0x70, 0x2F, 0xFA, 0x02, 0x60, 0x7A, 0x0E, 0x72, 0x01, 0xB0, 0x76, 0x0C, 0xA0, 0xA7, 0x30,
  0xBA, 0x0C, 0x50, 0x1B, 0x06, 0x73, 0x07, 0xB0, 0x14, 0x06, 0xB0, 0x17, 0x30, 0x2B, 0x06, 0x40,
  0xBA, 0x0C, 0x75, 0x0D, 0xA0, 0xB3, 0x01, 0xB0, 0x77, 0x50, 0x8B, 0x01, 0x20, 0x6B, 0x02, 0x75,
  0x03, 0xB0, 0x62, 0x0B, 0xA0, 0xD7, 0x70, 0xEA, 0x81, 0xB0, 0x1B, 0x09, 0x77, 0x09, 0xB0, 0x10,
  // "Å" (U+00C5)
  0x72, 0x07, 0x0D, 0xA0, 0xD0, 0x67, 0x73, 0x0A, 0xE0, 0x97, 0x71, 0x02, 0xA8, 0x28, 0x11, 0x9A,
  0x02, 0x77, 0x81, 0x5F, 0xE4, 0x81, 0xEF, 0x57, 0x78, 0x15, 0xFE, 0x48, 0x1E, 0xF5, 0x77, 0x02,
  0xA8, 0x29, 0x22, 0xAA, 0x01, 0x77, 0x10, 0x8E, 0x08, 0x77, 0x38, 0x46, 0xCF, 0xEC, 0x58, 0x0F,
  0x60, 0x01, 0xC7, 0x75, 0x06, 0xC0, 0x57, 0x74, 0x0B, 0xC0, 0xA7, 0x73, 0x01, 0xD0, 0xE7, 0x73,
  0x05, 0xA0, 0xD0, 0xEA, 0x05, 0x77, 0x20, 0xAA, 0x09, 0x0A, 0xA0, 0x97, 0x72, 0x0E, 0xA0, 0x50,
  0x6A, 0x0E, 0x77, 0x10, 0x5B, 0x01, 0x02, 0xB0, 0x47, 0x70, 0xAA, 0x0C, 0x20, 0xDA, 0x09, 0x77,
  0x0E, 0xA0, 0x72, 0x08, 0xA0, 0xE7, 0x60, 0x4B, 0x02, 0x20, 0x3B, 0x03, 0x75, 0x09, 0xA0, 0xD4,
  0x0E, 0xA0, 0x87, 0x50, 0xEA, 0x08, 0x40, 0x9A, 0x0D, 0x74, 0x03, 0xB0, 0x34, 0x04, 0xB0, 0x37,
  0x30, 0x8A, 0x0E, 0x60, 0xEA, 0x08, 0x73, 0x0D, 0xA0, 0x96, 0x0A, 0xA0, 0xD7, 0x20, 0x3B, 0x05,
  0x60, 0x5B, 0x02, 0x71, 0x08, 0xB8, 0x04, 0xEB, 0x07, 0x71, 0x0D, 0xFF, 0x0C, 0x70, 0x2F, 0xFA,
  0x02, 0x60, 0x7A, 0x0E, 0x72, 0x01, 0xB0, 0x76, 0x0C, 0xA0, 0xA7, 0x30, 0xBA, 0x0C, 0x50, 0x1B,
  0x06, 0x73, 0x07, 0xB0, 0x14, 0x06, 0xB0, 0x17, 0x30, 0x2B, 0x06, 0x40, 0xBA, 0x0C, 0x75, 0x0D,
  0xA0, 0xB3, 0x01, 0xB0, 0x77, 0x50, 0x8B, 0x01, 0x20, 0x6B, 0x02, 0x75, 0x03, 0xB0, 0x62, 0x0B,
  0xA0, 0xD7, 0x70, 0xEA, 0x81, 0xB0, 0x1B, 0x09, 0x77, 0x09, 0xB0, 0x10,
  // "Æ" (U+00C6)
  0x70, 0xEF, 0xE0, 0xB6, 0x02, 0xFF, 0x0B, 0x60, 0x5B, 0x0E, 0xC8, 0x02, 0xE0, 0xA6, 0x08, 0xA8,
  0x18, 0x0E, 0xA0, 0x87, 0x60, 0xCA, 0x81, 0x50, 0xEA, 0x08, 0x76, 0xB8, 0x12, 0x0E, 0xA0, 0x87,
  0x50, 0x3A, 0x0E, 0x20, 0xEA, 0x08, 0x75, 0x07, 0xA0, 0xB2, 0x0E, 0xA0, 0x87, 0x50, 0xAA, 0x08,
  0x20, 0xEA, 0x08, 0x75, 0x0D, 0xA0, 0x52, 0x0E, 0xA0, 0x87, 0x40, 0x1B, 0x02, 0x20, 0xEA, 0x08,
  0x74, 0x05, 0xA0, 0xE3, 0x0E, 0xA0, 0x87, 0x40, 0x8A, 0x0B, 0x30, 0xEF, 0x90, 0xE5, 0x0C, 0xA0,
  0x83, 0x0E, 0xF9, 0x0E, 0x5B, 0x05, 0x30, 0xEB, 0x80, 0x1E, 0x0D, 0x40, 0x3B, 0x01, 0x30, 0xEA,
  0x08, 0x73, 0x06, 0xA0, 0xE4, 0x0E, 0xA0, 0x87, 0x30, 0xAB, 0x80, 0x0E, 0xB0, 0x87, 0x30, 0xDF,
  0xB0, 0x87, 0x20, 0x1F, 0xC0, 0x87, 0x20, 0x5B, 0x50, 0xEA, 0x08, 0x72, 0x08, 0xA0, 0xD5, 0x0E,
  0xA0, 0x87, 0x20, 0xBA, 0x09, 0x50, 0xEA, 0x08, 0x72, 0xB0, 0x65, 0x0E, 0xA0, 0x87, 0x10, 0x3B,
  0x03, 0x50, 0xEA, 0x08, 0x71, 0x06, 0xB6, 0x0E, 0xA0, 0x87, 0x10, 0xAA, 0x0C, 0x60, 0xEB, 0x80,
  0x2E, 0x81, 0xA0, 0xDA, 0x09, 0x60, 0xEF, 0xA0, 0xB0, 0x1B, 0x05, 0x60, 0xEF, 0xA0, 0xB0,
  // "Ç" (U+00C7)
  0x71, 0x89, 0x15, 0x9C, 0xEF, 0xEE, 0xC9, 0x51, 0x70, 0x60, 0xEF, 0xC0, 0x95, 0x0B, 0xFE, 0x08,
  0x40, 0xCC, 0x81, 0x93, 0x12, 0x84, 0x14, 0x8D, 0xF1, 0x30, 0x9B, 0x0C, 0x02, 0x72, 0x03, 0x30,
  0x4B, 0x0C, 0x01, 0x77, 0x0C, 0xB0, 0x27, 0x70, 0x3B, 0x09, 0x77, 0x10, 0x8B, 0x03, 0x77, 0x10,
  0xCA, 0x0D, 0x77, 0x2B, 0x0A, 0x77, 0x10, 0x2B, 0x08, 0x77, 0x10, 0x4B, 0x06, 0x77, 0x10, 0x5B,
  0x05, 0x77, 0x10, 0x5B, 0x05, 0x77, 0x10, 0x5B, 0x05, 0x77, 0x10, 0x4B, 0x06, 0x77, 0x10, 0x2B,
  0x07, 0x77, 0x2B, 0x0A, 0x77, 0x20, 0xDA, 0x0D, 0x77, 0x20, 0x9B, 0x02, 0x77, 0x10, 0x4B, 0x07,
  0x77, 0x20, 0xDA, 0x0E, 0x01, 0x77, 0x10, 0x6B, 0x0A, 0x77, 0x20, 0xCB, 0x09, 0x77, 0x10, 0x10,
  0xDB, 0x81, 0xD7, 0x23, 0x83, 0x13, 0x6B, 0xB5, 0x02, 0x0D, 0xE0, 0xED, 0x0B, 0x70, 0x8F, 0xC0,
  0xB7, 0x18, 0x92, 0x16, 0xAD, 0xEF, 0xED, 0xC9, 0x51, 0x74, 0x01, 0xA0, 0x37, 0x72, 0x81, 0x8F,
  0xC7, 0x72, 0x83, 0x1E, 0xFB, 0x37, 0x71, 0x05, 0x0E, 0xB0, 0xA7, 0x72, 0x04, 0x0C, 0xA0, 0x87,
  0x72, 0x01, 0xA0, 0xC7, 0x72, 0x01, 0xA0, 0xC7, 0x58, 0x34, 0x33, 0x5C, 0xA0, 0x87, 0x5E, 0x0C,
  0x76, 0x0E, 0xA8, 0x1E, 0xB6, 0x60,
  // "È" (U+00C8)
  0x38, 0x33, 0x77, 0x76, 0x76, 0x01, 0x0E, 0xB0, 0x47, 0x60, 0x4B, 0x0D, 0x77, 0x05, 0xB0, 0x77,
  0x70, 0x6B, 0x02, 0x77, 0x07, 0xA0, 0xC7, 0x71, 0x05, 0xA0, 0x78, 0x0C, 0x60, 0x03, 0xFF, 0xA0,
  0x90, 0x3F, 0xFA, 0x09, 0x03, 0xB8, 0x09, 0x1E, 0x08, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76,
  0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0,
  0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3F, 0xF9, 0x81, 0xD0, 0x3F, 0xF9, 0x81,
  0xD0, 0x3B, 0x80, 0x90, 0xE8, 0x1C, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67,
  0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B,
  0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x80, 0x91,
  0xE0, 0x80, 0x3F, 0xFA, 0x09, 0x03, 0xFF, 0xA0, 0x90,
  // "É" (U+00C9)
  0x74, 0x83, 0x37, 0x77, 0x67, 0x60, 0xDB, 0x07, 0x75, 0x07, 0xB0, 0xA7, 0x50, 0x2B, 0x0B, 0x76,
  0x0B, 0xA0, 0xC7, 0x60, 0x6A, 0x0C, 0x01, 0x75, 0x01, 0xA0, 0xB8, 0x0C, 0x70, 0x03, 0xFF, 0xA0,
  0x90, 0x3F, 0xFA, 0x09, 0x03, 0xB8, 0x09, 0x1E, 0x08, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76,
  0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0,
  0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3F, 0xF9, 0x81, 0xD0, 0x3F, 0xF9, 0x81,
  0xD0, 0x3B, 0x80, 0x90, 0xE8, 0x1C, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67,
  0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B,
  0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x80, 0x91,
  0xE0, 0x80, 0x3F, 0xFA, 0x09, 0x03, 0xFF, 0xA0, 0x90,
  // "Ê" (U+00CA)
  0x78, 0x00, 0x77, 0x60, 0x7C, 0x06, 0x74, 0x04, 0xD0, 0xE0, 0x27, 0x20, 0x20, 0xEA, 0x08, 0x0A,
  0xA0, 0xD0, 0x17, 0x01, 0x0D, 0xA0, 0x72, 0x0A, 0xA0, 0xC7, 0x0B, 0xA0, 0x74, 0x09, 0xA0, 0xB5,
  0x82, 0x9F, 0xE5, 0x60, 0x6A, 0x09, 0x80, 0xC2, 0x00, 0x3F, 0xFA, 0x09, 0x03, 0xFF, 0xA0, 0x90,
  0x3B, 0x80, 0x91, 0xE0, 0x80, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03,
  0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67,
  0x60, 0x3B, 0x06, 0x76, 0x03, 0xFF, 0x98, 0x1D, 0x03, 0xFF, 0x98, 0x1D, 0x03, 0xB8, 0x09, 0x0E,
  0x81, 0xC0, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60,
  0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06,
  0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB8, 0x09, 0x1E, 0x08, 0x03, 0xFF, 0xA0,
  0x90, 0x3F, 0xFA, 0x09,
  // "Ë" (U+00CB)
  0x28, 0x21, 0xBE, 0xA6, 0x82, 0xAE, 0xC2, 0x40, 0x8B, 0x07, 0x40, 0x6B, 0x09, 0x40, 0xAB, 0x09,
  0x40, 0x8B, 0x0B, 0x40, 0x8B, 0x06, 0x40, 0x5B, 0x09, 0x48, 0x21, 0xBE, 0xA6, 0x82, 0x9E, 0xB1,
  0x80, 0xE4, 0x00, 0x3F, 0xFA, 0x09, 0x03, 0xFF, 0xA0, 0x90, 0x3B, 0x80, 0x91, 0xE0, 0x80, 0x3B,
  0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76,
  0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xFF,
  0x98, 0x1D, 0x03, 0xFF, 0x98, 0x1D, 0x03, 0xB8, 0x09, 0x0E, 0x81, 0xC0, 0x3B, 0x06, 0x76, 0x03,
  0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67,
  0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B,
  0x06, 0x76, 0x03, 0xB8, 0x09, 0x1E, 0x08, 0x03, 0xFF, 0xA0, 0x90, 0x3F, 0xFA, 0x09,
  // "Ì" (U+00CC)
  0x28, 0x33, 0x77, 0x76, 0x74, 0x01, 0x0E, 0xB0, 0x47, 0x40, 0x4B, 0x0D, 0x75, 0x05, 0xB0, 0x77,
  0x50, 0x6B, 0x02, 0x75, 0x07, 0xA0, 0xC7, 0x60, 0x5A, 0x07, 0x80, 0xC1, 0x00, 0x9F, 0xF0, 0x09,
  0xFF, 0x82, 0x97, 0xDE, 0xFB, 0x81, 0xED, 0x74, 0x81, 0x13, 0xDA, 0x81, 0xC3, 0x17, 0x30, 0xDA,
  0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75,
  0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0,
  0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50,
  0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B,
  0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB6, 0x84, 0x49, 0xAC, 0xDE, 0xC8,
  0x5E, 0xDB, 0xA9, 0x49, 0xFF, 0x00, 0x9F, 0xF0, 0x90,
  // "Í" (U+00CD)
  0x73, 0x83, 0x37, 0x77, 0x67, 0x40, 0xDB, 0x07, 0x73, 0x07, 0xB0, 0xA7, 0x30, 0x2B, 0x0B, 0x74,
  0x0B, 0xA0, 0xC7, 0x40, 0x6A, 0x0C, 0x01, 0x73, 0x01, 0xA0, 0xB8, 0x0C, 0x20, 0x09, 0xFF, 0x00,
  0x9F, 0xF8, 0x29, 0x7D, 0xEF, 0xB8, 0x1E, 0xD7, 0x48, 0x11, 0x3D, 0xA8, 0x1C, 0x31, 0x73, 0x0D,
  0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7,
  0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA,
  0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75,
  0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0,
  0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x68, 0x44, 0x9A, 0xCD, 0xEC,
  0x85, 0xED, 0xBA, 0x94, 0x9F, 0xF0, 0x09, 0xFF, 0x09,
  // "Î" (U+00CE)
  0x68, 0x00, 0x77, 0x40, 0x7C, 0x06, 0x72, 0x04, 0xD0, 0xE0, 0x27, 0x02, 0x0E, 0xA0, 0x80, 0xAA,
  0x0D, 0x01, 0x50, 0x10, 0xDA, 0x07, 0x20, 0xAA, 0x0C, 0x50, 0xBA, 0x07, 0x40, 0x9A, 0x0B, 0x38,
  0x29, 0xFE, 0x56, 0x06, 0xA0, 0x97, 0x77, 0x75, 0x09, 0xFF, 0x00, 0x9F, 0xF8, 0x29, 0x7D, 0xEF,
  0xB8, 0x1E, 0xD7, 0x48, 0x11, 0x3D, 0xA8, 0x1C, 0x31, 0x73, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B,
  0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D,
  0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7,
  0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA,
  0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75,
  0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x68, 0x44, 0x9A, 0xCD, 0xEC, 0x85, 0xED, 0xBA, 0x94, 0x9F,
  0xF0, 0x09, 0xFF, 0x09,
  // "Ï" (U+00CF)
  0x18, 0x21, 0xBE, 0xA6, 0x82, 0xAE, 0xC2, 0x20, 0x8B, 0x07, 0x40, 0x6B, 0x09, 0x20, 0xAB, 0x09,
  0x40, 0x8B, 0x0B, 0x20, 0x8B, 0x06, 0x40, 0x5B, 0x09, 0x28, 0x21, 0xBE, 0xA6, 0x82, 0x9E, 0xB1,
  0x80, 0xD5, 0x00, 0x9F, 0xF0, 0x09, 0xFF, 0x82, 0x97, 0xDE, 0xFB, 0x81, 0xED, 0x74, 0x81, 0x13,
  0xDA, 0x81, 0xC3, 0x17, 0x30, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D,
  0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7,
  0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA,
  0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75,
  0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0,
  0xB6, 0x84, 0x49, 0xAC, 0xDE, 0xC8, 0x5E, 0xDB, 0xA9, 0x49, 0xFF, 0x00, 0x9F, 0xF0, 0x90,
  // "Ð" (U+00D0)
  0x30, 0xCF, 0x82, 0xEC, 0x95, 0x74, 0x0C, 0xFC, 0x0E, 0x07, 0x72, 0x0C, 0xB0, 0xFE, 0xF0, 0xC0,
  0x27, 0x0C, 0xA0, 0xC4, 0x81, 0x15, 0xAC, 0x0D, 0x02, 0x60, 0xCA, 0x0C, 0x70, 0x20, 0xCB, 0x0C,
  0x60, 0xCA, 0x0C, 0x72, 0x0B, 0xB0, 0x85, 0x0C, 0xA0, 0xC7, 0x20, 0x10, 0xEB, 0x01, 0x40, 0xCA,
  0x0C, 0x73, 0x06, 0xB0, 0x74, 0x0C, 0xA0, 0xC7, 0x40, 0xEA, 0x0C, 0x40, 0xCA, 0x0C, 0x74, 0x0A,
  0xB0, 0x13, 0x0C, 0xA0, 0xC7, 0x40, 0x7B, 0x04, 0x30, 0xCA, 0x0C, 0x74, 0x04, 0xB0, 0x63, 0x0C,
  0xA0, 0xC7, 0x40, 0x2B, 0x08, 0x0F, 0xEC, 0x80, 0x0E, 0x0A, 0x60, 0x1B, 0x08, 0xFC, 0x0A, 0x60,
  0x1B, 0x08, 0xFC, 0x0A, 0x60, 0x2B, 0x07, 0x30, 0xCA, 0x0C, 0x74, 0x03, 0xB0, 0x63, 0x0C, 0xA0,
  0xC7, 0x40, 0x5B, 0x05, 0x30, 0xCA, 0x0C, 0x74, 0x07, 0xB0, 0x23, 0x0C, 0xA0, 0xC7, 0x40, 0xBA,
  0x0E, 0x40, 0xCA, 0x0C, 0x73, 0x01, 0xB0, 0xB4, 0x0C, 0xA0, 0xC7, 0x30, 0x8B, 0x05, 0x40, 0xCA,
  0x0C, 0x72, 0x02, 0xB0, 0xD5, 0x0C, 0xA0, 0xC7, 0x10, 0x10, 0xDB, 0x06, 0x50, 0xCA, 0x0C, 0x70,
  0x40, 0xDB, 0x0A, 0x60, 0xCA, 0x0C, 0x48, 0x12, 0x6B, 0xC0, 0xB7, 0x0C, 0xB0, 0x0E, 0xF9, 0x09,
  0x71, 0x0C, 0xFC, 0x0B, 0x03, 0x72, 0x0C, 0xE8, 0x3E, 0xCA, 0x62, 0x71,
  // "Ñ" (U+00D1)
  0x48, 0x41, 0x9E, 0xEB, 0x55, 0x81, 0xEF, 0x16, 0x0D, 0xD0, 0xC0, 0x52, 0x81, 0x9F, 0xD6, 0x07,
  0xFD, 0x07, 0x68, 0x1D, 0xF9, 0x20, 0x40, 0xCD, 0x0D, 0x60, 0x1A, 0x58, 0x45, 0xCE, 0xE9, 0x18,
  0x0D, 0x00, 0x03, 0xC0, 0xC7, 0x20, 0x4B, 0x00, 0x3D, 0x03, 0x71, 0x04, 0xB0, 0x03, 0xD0, 0x97,
  0x10, 0x4B, 0x00, 0x3E, 0x01, 0x70, 0x4B, 0x00, 0x3A, 0x0C, 0x0D, 0xA0, 0x77, 0x04, 0xB0, 0x03,
  0xA0, 0xD0, 0x6A, 0x0D, 0x70, 0x4B, 0x00, 0x3A, 0x81, 0xE0, 0xEA, 0x05, 0x60, 0x4B, 0x00, 0x3B,
  0x10, 0x8A, 0x0C, 0x60, 0x4B, 0x00, 0x3B, 0x00, 0x1B, 0x03, 0x50, 0x4B, 0x00, 0x3B, 0x81, 0x20,
  0xAA, 0x09, 0x50, 0x4B, 0x00, 0x3B, 0x81, 0x20, 0x3B, 0x01, 0x40, 0x4B, 0x00, 0x3B, 0x03, 0x20,
  0xCA, 0x07, 0x40, 0x4B, 0x00, 0x3B, 0x04, 0x20, 0x5A, 0x0E, 0x40, 0x4B, 0x00, 0x3B, 0x04, 0x30,
  0xDA, 0x05, 0x30, 0x4B, 0x00, 0x3B, 0x04, 0x30, 0x7A, 0x0C, 0x30, 0x4B, 0x00, 0x3B, 0x04, 0x30,
  0x1B, 0x03, 0x20, 0x4B, 0x00, 0x3B, 0x04, 0x40, 0x9A, 0x0A, 0x20, 0x4B, 0x00, 0x3B, 0x04, 0x40,
  0x2B, 0x81, 0x10, 0x4B, 0x00, 0x3B, 0x04, 0x50, 0xBA, 0x81, 0x70, 0x3B, 0x00, 0x3B, 0x04, 0x50,
  0x4A, 0x81, 0xE0, 0x3B, 0x00, 0x3B, 0x04, 0x60, 0xDA, 0x05, 0x02, 0xB0, 0x03, 0xB0, 0x46, 0x06,
  0xA0, 0xC0, 0x1B, 0x00, 0x3B, 0x04, 0x70, 0xEA, 0x04, 0xB0, 0x03, 0xB0, 0x47, 0x08, 0xA0, 0xAB,
  0x00, 0x3B, 0x04, 0x70, 0x2E, 0x00, 0x3B, 0x04, 0x71, 0x0A, 0xD0, 0x03, 0xB0, 0x47, 0x10, 0x3D,
  0x00, 0x3B, 0x04, 0x72, 0x0C, 0xC0, 0x03, 0xB0, 0x47, 0x20, 0x5C, 0x03,
  // "Ò" (U+00D2)
  0x58, 0x33, 0x77, 0x76, 0x77, 0x30, 0x10, 0xEB, 0x04, 0x77, 0x30, 0x4B, 0x0D, 0x77, 0x40, 0x5B,
  0x07, 0x77, 0x40, 0x6B, 0x02, 0x77, 0x40, 0x7A, 0x0C, 0x77, 0x50, 0x5A, 0x07, 0x80, 0xE7, 0x08,
  0x76, 0xAD, 0xEF, 0xDB, 0x61, 0x74, 0x05, 0x0E, 0xF9, 0x0E, 0x05, 0x72, 0x07, 0xFD, 0x08, 0x70,
  0x5B, 0x81, 0xE7, 0x22, 0x81, 0x17, 0xEB, 0x06, 0x50, 0x10, 0xEA, 0x0D, 0x02, 0x60, 0x10, 0xDA,
  0x0E, 0x01, 0x40, 0x8B, 0x04, 0x71, 0x03, 0xB0, 0x94, 0x0E, 0xA0, 0xC7, 0x30, 0xBA, 0x0E, 0x30,
  0x4B, 0x06, 0x73, 0x05, 0xB0, 0x42, 0x08, 0xB0, 0x17, 0x30, 0x1B, 0x08, 0x20, 0xBA, 0x0D, 0x75,
  0x0D, 0xA0, 0xC2, 0x0E, 0xA0, 0xB7, 0x50, 0xBA, 0x0E, 0x2B, 0x09, 0x75, 0x09, 0xB1, 0x02, 0xB0,
  0x87, 0x50, 0x8B, 0x00, 0x2B, 0x08, 0x75, 0x08, 0xB0, 0x20, 0x3B, 0x07, 0x75, 0x07, 0xB0, 0x30,
  0x2B, 0x08, 0x75, 0x08, 0xB0, 0x02, 0xB0, 0x87, 0x50, 0x8B, 0x01, 0x1B, 0x09, 0x75, 0x09, 0xB2,
  0x0E, 0xA0, 0xB7, 0x50, 0xBA, 0x0E, 0x20, 0xBA, 0x0D, 0x75, 0x0D, 0xA0, 0xB2, 0x08, 0xB0, 0x17,
  0x30, 0x1B, 0x08, 0x20, 0x4B, 0x05, 0x73, 0x05, 0xB0, 0x43, 0x0E, 0xA0, 0xB7, 0x30, 0xBA, 0x0E,
  0x40, 0x9B, 0x04, 0x71, 0x03, 0xB0, 0x84, 0x01, 0x0E, 0xA0, 0xD0, 0x26, 0x02, 0x0D, 0xA0, 0xE0,
  0x15, 0x06, 0xB8, 0x1E, 0x72, 0x28, 0x11, 0x7E, 0xB0, 0x57, 0x08, 0xFD, 0x07, 0x72, 0x06, 0x0E,
  0xF9, 0x0E, 0x05, 0x74, 0x82, 0x16, 0xBD, 0xA8, 0x1D, 0xA6, 0x70,
  // "Ó" (U+00D3)
  0x76, 0x83, 0x37, 0x77, 0x67, 0x73, 0x0D, 0xB0, 0x77, 0x72, 0x07, 0xB0, 0xA7, 0x72, 0x02, 0xB0,
  0xB7, 0x73, 0x0B, 0xA0, 0xC7, 0x73, 0x06, 0xA0, 0xC0, 0x17, 0x72, 0x01, 0xA0, 0xB8, 0x0F, 0x00,
  0x87, 0x6A, 0xDE, 0xFD, 0xB6, 0x17, 0x40, 0x50, 0xEF, 0x90, 0xE0, 0x57, 0x20, 0x7F, 0xD0, 0x87,
  0x05, 0xB8, 0x1E, 0x72, 0x28, 0x11, 0x7E, 0xB0, 0x65, 0x01, 0x0E, 0xA0, 0xD0, 0x26, 0x01, 0x0D,
  0xA0, 0xE0, 0x14, 0x08, 0xB0, 0x47, 0x10, 0x3B, 0x09, 0x40, 0xEA, 0x0C, 0x73, 0x0B, 0xA0, 0xE3,
  0x04, 0xB0, 0x67, 0x30, 0x5B, 0x04, 0x20, 0x8B, 0x01, 0x73, 0x01, 0xB0, 0x82, 0x0B, 0xA0, 0xD7,
  0x50, 0xDA, 0x0C, 0x20, 0xEA, 0x0B, 0x75, 0x0B, 0xA0, 0xE2, 0xB0, 0x97, 0x50, 0x9B, 0x10, 0x2B,
  0x08, 0x75, 0x08, 0xB0, 0x02, 0xB0, 0x87, 0x50, 0x8B, 0x02, 0x03, 0xB0, 0x77, 0x50, 0x7B, 0x03,
  0x02, 0xB0, 0x87, 0x50, 0x8B, 0x00, 0x2B, 0x08, 0x75, 0x08, 0xB0, 0x11, 0xB0, 0x97, 0x50, 0x9B,
  0x20, 0xEA, 0x0B, 0x75, 0x0B, 0xA0, 0xE2, 0x0B, 0xA0, 0xD7, 0x50, 0xDA, 0x0B, 0x20, 0x8B, 0x01,
  0x73, 0x01, 0xB0, 0x82, 0x04, 0xB0, 0x57, 0x30, 0x5B, 0x04, 0x30, 0xEA, 0x0B, 0x73, 0x0B, 0xA0,
  0xE4, 0x09, 0xB0, 0x47, 0x10, 0x3B, 0x08, 0x40, 0x10, 0xEA, 0x0D, 0x02, 0x60, 0x20, 0xDA, 0x0E,
  0x01, 0x50, 0x6B, 0x81, 0xE7, 0x22, 0x81, 0x17, 0xEB, 0x05, 0x70, 0x8F, 0xD0, 0x77, 0x20, 0x60,
  0xEF, 0x90, 0xE0, 0x57, 0x48, 0x21, 0x6B, 0xDA, 0x81, 0xDA, 0x67,
  // "Ô" (U+00D4)
  0x72, 0x80, 0x07, 0x77, 0x30, 0x7C, 0x06, 0x77, 0x10, 0x4D, 0x0E, 0x02, 0x76, 0x02, 0x0E, 0xA0,
  0x80, 0xAA, 0x0D, 0x01, 0x74, 0x01, 0x0D, 0xA0, 0x72, 0x0A, 0xA0, 0xC7, 0x40, 0xBA, 0x07, 0x40,
  0x9A, 0x0B, 0x72, 0x82, 0x9F, 0xE5, 0x60, 0x6A, 0x09, 0x80, 0xE3, 0x08, 0x76, 0xAD, 0xEF, 0xDB,
  0x61, 0x74, 0x05, 0x0E, 0xF9, 0x0E, 0x05, 0x72, 0x07, 0xFD, 0x08, 0x70, 0x5B, 0x81, 0xE7, 0x22,
  0x81, 0x17, 0xEB, 0x06, 0x50, 0x10, 0xEA, 0x0D, 0x02, 0x60, 0x10, 0xDA, 0x0E, 0x01, 0x40, 0x8B,
  0x04, 0x71, 0x03, 0xB0, 0x94, 0x0E, 0xA0, 0xC7, 0x30, 0xBA, 0x0E, 0x30, 0x4B, 0x06, 0x73, 0x05,
  0xB0, 0x42, 0x08, 0xB0, 0x17, 0x30, 0x1B, 0x08, 0x20, 0xBA, 0x0D, 0x75, 0x0D, 0xA0, 0xC2, 0x0E,
  0xA0, 0xB7, 0x50, 0xBA, 0x0E, 0x2B, 0x09, 0x75, 0x09, 0xB1, 0x02, 0xB0, 0x87, 0x50, 0x8B, 0x00,
  0x2B, 0x08, 0x75, 0x08, 0xB0, 0x20, 0x3B, 0x07, 0x75, 0x07, 0xB0, 0x30, 0x2B, 0x08, 0x75, 0x08,
  0xB0, 0x02, 0xB0, 0x87, 0x50, 0x8B, 0x01, 0x1B, 0x09, 0x75, 0x09, 0xB2, 0x0E, 0xA0, 0xB7, 0x50,
  0xBA, 0x0E, 0x20, 0xBA, 0x0D, 0x75, 0x0D, 0xA0, 0xB2, 0x08, 0xB0, 0x17, 0x30, 0x1B, 0x08, 0x20,
  0x4B, 0x05, 0x73, 0x05, 0xB0, 0x43, 0x0E, 0xA0, 0xB7, 0x30, 0xBA, 0x0E, 0x40, 0x9B, 0x04, 0x71,
  0x03, 0xB0, 0x84, 0x01, 0x0E, 0xA0, 0xD0, 0x26, 0x02, 0x0D, 0xA0, 0xE0, 0x15, 0x06, 0xB8, 0x1E,
  0x72, 0x28, 0x11, 0x7E, 0xB0, 0x57, 0x08, 0xFD, 0x07, 0x72, 0x06, 0x0E, 0xF9, 0x0E, 0x05, 0x74,
  0x82, 0x16, 0xBD, 0xA8, 0x1D, 0xA6, 0x70,
  // "Õ" (U+00D5)
  0x58, 0x41, 0x9E, 0xEB, 0x55, 0x81, 0xEF, 0x17, 0x10, 0xDD, 0x0C, 0x05, 0x28, 0x19, 0xFD, 0x71,
  0x07, 0xFD, 0x07, 0x71, 0x81, 0xDF, 0x92, 0x04, 0x0C, 0xD0, 0xD7, 0x10, 0x1A, 0x58, 0x45, 0xCE,
  0xE9, 0x18, 0x0E, 0x40, 0x87, 0x6A, 0xDE, 0xFD, 0xB6, 0x17, 0x40, 0x50, 0xEF, 0x90, 0xE0, 0x57,
  0x20, 0x7F, 0xD0, 0x87, 0x05, 0xB8, 0x1E, 0x72, 0x28, 0x11, 0x7E, 0xB0, 0x65, 0x01, 0x0E, 0xA0,
  0xD0, 0x26, 0x01, 0x0D, 0xA0, 0xE0, 0x14, 0x08, 0xB0, 0x47, 0x10, 0x3B, 0x09, 0x40, 0xEA, 0x0C,
  0x73, 0x0B, 0xA0, 0xE3, 0x04, 0xB0, 0x67, 0x30, 0x5B, 0x04, 0x20, 0x8B, 0x01, 0x73, 0x01, 0xB0,
  0x82, 0x0B, 0xA0, 0xD7, 0x50, 0xDA, 0x0C, 0x20, 0xEA, 0x0B, 0x75, 0x0B, 0xA0, 0xE2, 0xB0, 0x97,
  0x50, 0x9B, 0x10, 0x2B, 0x08, 0x75, 0x08, 0xB0, 0x02, 0xB0, 0x87, 0x50, 0x8B, 0x02, 0x03, 0xB0,
  0x77, 0x50, 0x7B, 0x03, 0x02, 0xB0, 0x87, 0x50, 0x8B, 0x00, 0x2B, 0x08, 0x75, 0x08, 0xB0, 0x11,
  0xB0, 0x97, 0x50, 0x9B, 0x20, 0xEA, 0x0B, 0x75, 0x0B, 0xA0, 0xE2, 0x0B, 0xA0, 0xD7, 0x50, 0xDA,
  0x0B, 0x20, 0x8B, 0x01, 0x73, 0x01, 0xB0, 0x82, 0x04, 0xB0, 0x57, 0x30, 0x5B, 0x04, 0x30, 0xEA,
  0x0B, 0x73, 0x0B, 0xA0, 0xE4, 0x09, 0xB0, 0x47, 0x10, 0x3B, 0x08, 0x40, 0x10, 0xEA, 0x0D, 0x02,
  0x60, 0x20, 0xDA, 0x0E, 0x01, 0x50, 0x6B, 0x81, 0xE7, 0x22, 0x81, 0x17, 0xEB, 0x05, 0x70, 0x8F,
  0xD0, 0x77, 0x20, 0x60, 0xEF, 0x90, 0xE0, 0x57, 0x48, 0x21, 0x6B, 0xDA, 0x81, 0xDA, 0x67,
  // "Ö" (U+00D6)
  0x48, 0x21, 0xBE, 0xA6, 0x82, 0xAE, 0xC2, 0x71, 0x08, 0xB0, 0x74, 0x06, 0xB0, 0x97, 0x10, 0xAB,
  0x09, 0x40, 0x8B, 0x0B, 0x71, 0x08, 0xB0, 0x64, 0x05, 0xB0, 0x97, 0x18, 0x21, 0xBE, 0xA6, 0x82,
  0x9E, 0xB1, 0x80, 0x99, 0x10, 0x87, 0x6A, 0xDE, 0xFD, 0xB6, 0x17, 0x40, 0x50, 0xEF, 0x90, 0xE0,
  0x57, 0x20, 0x7F, 0xD0, 0x87, 0x05, 0xB8, 0x1E, 0x72, 0x28, 0x11, 0x7E, 0xB0, 0x65, 0x01, 0x0E,
  0xA0, 0xD0, 0x26, 0x01, 0x0D, 0xA0, 0xE0, 0x14, 0x08, 0xB0, 0x47, 0x10, 0x3B, 0x09, 0x40, 0xEA,
  0x0C, 0x73, 0x0B, 0xA0, 0xE3, 0x04, 0xB0, 0x67, 0x30, 0x5B, 0x04, 0x20, 0x8B, 0x01, 0x73, 0x01,
  0xB0, 0x82, 0x0B, 0xA0, 0xD7, 0x50, 0xDA, 0x0C, 0x20, 0xEA, 0x0B, 0x75, 0x0B, 0xA0, 0xE2, 0xB0,
  0x97, 0x50, 0x9B, 0x10, 0x2B, 0x08, 0x75, 0x08, 0xB0, 0x02, 0xB0, 0x87, 0x50, 0x8B, 0x02, 0x03,
  0xB0, 0x77, 0x50, 0x7B, 0x03, 0x02, 0xB0, 0x87, 0x50, 0x8B, 0x00, 0x2B, 0x08, 0x75, 0x08, 0xB0,
  0x11, 0xB0, 0x97, 0x50, 0x9B, 0x20, 0xEA, 0x0B, 0x75, 0x0B, 0xA0, 0xE2, 0x0B, 0xA0, 0xD7, 0x50,
  0xDA, 0x0B, 0x20, 0x8B, 0x01, 0x73, 0x01, 0xB0, 0x82, 0x04, 0xB0, 0x57, 0x30, 0x5B, 0x04, 0x30,
  0xEA, 0x0B, 0x73, 0x0B, 0xA0, 0xE4, 0x09, 0xB0, 0x47, 0x10, 0x3B, 0x08, 0x40, 0x10, 0xEA, 0x0D,
  0x02, 0x60, 0x20, 0xDA, 0x0E, 0x01, 0x50, 0x6B, 0x81, 0xE7, 0x22, 0x81, 0x17, 0xEB, 0x05, 0x70,
  0x8F, 0xD0, 0x77, 0x20, 0x60, 0xEF, 0x90, 0xE0, 0x57, 0x48, 0x21, 0x6B, 0xDA, 0x81, 0xDA, 0x67,
  // "×" (U+00D7)
  0x20, 0x77, 0x50, 0x60, 0x12, 0x81, 0xBF, 0x97, 0x38, 0x38, 0xFC, 0x14, 0xB0, 0x97, 0x10, 0x8B,
  0x81, 0x50, 0x5B, 0x09, 0x60, 0x8B, 0x05, 0x30, 0x5B, 0x09, 0x40, 0x8B, 0x05, 0x50, 0x5B, 0x09,
  0x20, 0x8B, 0x05, 0x70, 0x5B, 0x00, 0x8B, 0x05, 0x72, 0x05, 0xE0, 0x57, 0x40, 0x6C, 0x06, 0x75,
  0x09, 0xC0, 0x97, 0x40, 0x9E, 0x09, 0x72, 0x09, 0xB0, 0x50, 0x7B, 0x09, 0x70, 0x8B, 0x06, 0x20,
  0x6B, 0x09, 0x50, 0x8B, 0x06, 0x40, 0x6B, 0x08, 0x30, 0x8B, 0x06, 0x60, 0x6B, 0x81, 0x80, 0x4B,
  0x06, 0x71, 0x06, 0xB8, 0x35, 0x08, 0xF6, 0x73, 0x81, 0x5F, 0x93, 0x03, 0x75, 0x03, 0x20,
  // "Ø" (U+00D8)
  0x77, 0x40, 0xA0, 0x57, 0x28, 0x91, 0x6A, 0xDE, 0xFD, 0xB6, 0x10, 0x6A, 0x0B, 0x60, 0x50, 0xEF,
  0x98, 0x1E, 0x7E, 0xA0, 0x65, 0x07, 0xFF, 0x0C, 0x50, 0x5B, 0x81, 0xE7, 0x22, 0x02, 0x08, 0xD0,
  0x44, 0x01, 0x0E, 0xA0, 0xD0, 0x26, 0x03, 0xC0, 0x14, 0x08, 0xB0, 0x47, 0x03, 0xC0, 0x84, 0x0E,
  0xA0, 0xC7, 0x10, 0xCC, 0x0E, 0x30, 0x4B, 0x06, 0x70, 0x6E, 0x04, 0x20, 0x8B, 0x02, 0x70, 0xEA,
  0x07, 0xB0, 0x82, 0x0B, 0xA0, 0xE7, 0x08, 0xA8, 0x1C, 0x0D, 0xA0, 0xB2, 0x0E, 0xA0, 0xB6, 0x02,
  0xB8, 0x14, 0x0B, 0xA0, 0xE2, 0xB0, 0x96, 0x0B, 0xA0, 0xA2, 0x09, 0xB1, 0x01, 0xB0, 0x85, 0x04,
  0xB0, 0x22, 0x08, 0xB0, 0x10, 0x2B, 0x08, 0x50, 0xDA, 0x08, 0x30, 0x7B, 0x02, 0x03, 0xB0, 0x74,
  0x06, 0xA0, 0xE4, 0x07, 0xB0, 0x30, 0x2B, 0x07, 0x30, 0x10, 0xEA, 0x05, 0x40, 0x8B, 0x02, 0x01,
  0xB0, 0x83, 0x09, 0xA0, 0xC5, 0x08, 0xB0, 0x20, 0x1B, 0x09, 0x20, 0x2B, 0x03, 0x50, 0x9B, 0x20,
  0xEA, 0x0B, 0x20, 0xBA, 0x0A, 0x60, 0xBA, 0x0E, 0x20, 0xCA, 0x81, 0xD0, 0x4A, 0x0E, 0x01, 0x60,
  0xDA, 0x0B, 0x20, 0x9B, 0x01, 0x0D, 0xA0, 0x76, 0x01, 0xB0, 0x82, 0x05, 0xB0, 0xBA, 0x0D, 0x70,
  0x5B, 0x04, 0x3E, 0x05, 0x70, 0xBA, 0x0E, 0x40, 0xAC, 0x0C, 0x70, 0x3B, 0x08, 0x40, 0x2C, 0x05,
  0x60, 0x10, 0xDA, 0x0E, 0x01, 0x50, 0xDB, 0x81, 0xE7, 0x12, 0x81, 0x16, 0xEB, 0x05, 0x50, 0x6F,
  0xF0, 0x85, 0x01, 0x0E, 0xA0, 0xBF, 0xA0, 0xE0, 0x56, 0x08, 0xA8, 0x4C, 0x01, 0x7B, 0xEA, 0x81,
  0xDA, 0x67, 0x28, 0x16, 0xE3, 0x77, 0x30,
  // "Ù" (U+00D9)
  0x48, 0x33, 0x77, 0x76, 0x77, 0x10, 0x10, 0xEB, 0x04, 0x77, 0x10, 0x4B, 0x0D, 0x77, 0x20, 0x5B,
  0x07, 0x77, 0x20, 0x6B, 0x02, 0x77, 0x20, 0x7A, 0x0C, 0x77, 0x30, 0x5A, 0x07, 0x80, 0xD3, 0x00,
  0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0,
  0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B,
  0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06,
  0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30,
  0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73,
  0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67,
  0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x30, 0x1B, 0x07, 0x73, 0x07, 0xB0, 0x11, 0xB0,
  0x87, 0x30, 0x8B, 0x20, 0xEA, 0x0B, 0x73, 0x0B, 0xA0, 0xE2, 0x0A, 0xA0, 0xE7, 0x30, 0xEA, 0x0A,
  0x20, 0x6B, 0x05, 0x71, 0x05, 0xB0, 0x62, 0x01, 0xB0, 0xE0, 0x26, 0x01, 0x0E, 0xA0, 0xE0, 0x13,
  0x08, 0xB8, 0x1E, 0x71, 0x28, 0x11, 0x5D, 0xB0, 0x75, 0x0B, 0xFD, 0x0A, 0x70, 0x9F, 0xB0, 0x87,
  0x28, 0x22, 0x8C, 0xEA, 0x82, 0xEB, 0x71, 0x50,
  // "Ú" (U+00DA)
  0x75, 0x83, 0x37, 0x77, 0x67, 0x71, 0x0D, 0xB0, 0x77, 0x70, 0x7B, 0x0A, 0x77, 0x02, 0xB0, 0xB7,
  0x71, 0x0B, 0xA0, 0xC7, 0x71, 0x06, 0xA0, 0xC0, 0x17, 0x70, 0x1A, 0x0B, 0x80, 0xD4, 0x00, 0x3B,
  0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03,
  0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00,
  0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0,
  0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B,
  0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06,
  0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30,
  0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x30, 0x1B, 0x07, 0x73, 0x07, 0xB0, 0x11, 0xB0, 0x87,
  0x30, 0x8B, 0x20, 0xEA, 0x0B, 0x73, 0x0B, 0xA0, 0xE2, 0x0A, 0xA0, 0xE7, 0x30, 0xEA, 0x0A, 0x20,
  0x6B, 0x05, 0x71, 0x05, 0xB0, 0x62, 0x01, 0xB0, 0xE0, 0x26, 0x01, 0x0E, 0xA0, 0xE0, 0x13, 0x08,
  0xB8, 0x1E, 0x71, 0x28, 0x11, 0x5D, 0xB0, 0x75, 0x0B, 0xFD, 0x0A, 0x70, 0x9F, 0xB0, 0x87, 0x28,
  0x22, 0x8C, 0xEA, 0x82, 0xEB, 0x71, 0x50,
  // "Û" (U+00DB)
  0x71, 0x80, 0x07, 0x77, 0x10, 0x7C, 0x06, 0x76, 0x04, 0xD0, 0xE0, 0x27, 0x40, 0x20, 0xEA, 0x08,
  0x0A, 0xA0, 0xD0, 0x17, 0x20, 0x10, 0xDA, 0x07, 0x20, 0xAA, 0x0C, 0x72, 0x0B, 0xA0, 0x74, 0x09,
  0xA0, 0xB7, 0x82, 0x9F, 0xE5, 0x60, 0x6A, 0x09, 0x80, 0xC7, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0,
  0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B,
  0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06,
  0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30,
  0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73,
  0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67,
  0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06,
  0x73, 0x06, 0xB0, 0x30, 0x1B, 0x07, 0x73, 0x07, 0xB0, 0x11, 0xB0, 0x87, 0x30, 0x8B, 0x20, 0xEA,
  0x0B, 0x73, 0x0B, 0xA0, 0xE2, 0x0A, 0xA0, 0xE7, 0x30, 0xEA, 0x0A, 0x20, 0x6B, 0x05, 0x71, 0x05,
  0xB0, 0x62, 0x01, 0xB0, 0xE0, 0x26, 0x01, 0x0E, 0xA0, 0xE0, 0x13, 0x08, 0xB8, 0x1E, 0x71, 0x28,
  0x11, 0x5D, 0xB0, 0x75, 0x0B, 0xFD, 0x0A, 0x70, 0x9F, 0xB0, 0x87, 0x28, 0x22, 0x8C, 0xEA, 0x82,
  0xEB, 0x71, 0x50,
  // "Ü" (U+00DC)
  0x38, 0x21, 0xBE, 0xA6, 0x82, 0xAE, 0xC2, 0x60, 0x8B, 0x07, 0x40, 0x6B, 0x09, 0x60, 0xAB, 0x09,
  0x40, 0x8B, 0x0B, 0x60, 0x8B, 0x06, 0x40, 0x5B, 0x09, 0x68, 0x21, 0xBE, 0xA6, 0x82, 0x9E, 0xB1,
  0x80, 0xF3, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06,
  0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0,
  0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B,
  0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03,
  0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00,
  0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0,
  0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x30, 0x1B, 0x07, 0x73, 0x07,
  0xB0, 0x11, 0xB0, 0x87, 0x30, 0x8B, 0x20, 0xEA, 0x0B, 0x73, 0x0B, 0xA0, 0xE2, 0x0A, 0xA0, 0xE7,
  0x30, 0xEA, 0x0A, 0x20, 0x6B, 0x05, 0x71, 0x05, 0xB0, 0x62, 0x01, 0xB0, 0xE0, 0x26, 0x01, 0x0E,
  0xA0, 0xE0, 0x13, 0x08, 0xB8, 0x1E, 0x71, 0x28, 0x11, 0x5D, 0xB0, 0x75, 0x0B, 0xFD, 0x0A, 0x70,
  0x9F, 0xB0, 0x87, 0x28, 0x22, 0x8C, 0xEA, 0x82, 0xEB, 0x71, 0x50,
  // "Ý" (U+00DD)
  0x76, 0x83, 0x37, 0x77, 0x67, 0x73, 0x0D, 0xB0, 0x77, 0x72, 0x07, 0xB0, 0xA7, 0x72, 0x02, 0xB0,
  0xB7, 0x73, 0x0B, 0xA0, 0xC7, 0x73, 0x06, 0xA0, 0xC0, 0x17, 0x72, 0x01, 0xA0, 0xB8, 0x0E, 0x10,
  0x05, 0xB0, 0x97, 0x50, 0x7B, 0x81, 0x50, 0xDA, 0x0E, 0x01, 0x74, 0x0D, 0xA0, 0xC2, 0x05, 0xB0,
  0x77, 0x30, 0x5B, 0x05, 0x30, 0xDA, 0x0E, 0x73, 0x0C, 0xA0, 0xD4, 0x05, 0xB0, 0x67, 0x10, 0x4B,
  0x05, 0x50, 0xDA, 0x0D, 0x71, 0x0B, 0xA0, 0xD6, 0x05, 0xB0, 0x46, 0x02, 0xB0, 0x57, 0x0D, 0xA0,
  0xB6, 0x0A, 0xA0, 0xD7, 0x10, 0x5B, 0x03, 0x40, 0x1B, 0x05, 0x72, 0x0D, 0xA0, 0xA4, 0x08, 0xA0,
  0xD7, 0x30, 0x5B, 0x01, 0x30, 0xEA, 0x05, 0x74, 0x0D, 0xA0, 0x82, 0x07, 0xA0, 0xD7, 0x50, 0x5A,
  0x82, 0xE1, 0x0D, 0xA0, 0x57, 0x60, 0xDA, 0x07, 0x05, 0xA0, 0xD7, 0x70, 0x5A, 0x0D, 0x0C, 0xA0,
  0x57, 0x71, 0x0D, 0xC0, 0xD7, 0x72, 0x05, 0xC0, 0x57, 0x73, 0x0D, 0xA0, 0xD7, 0x74, 0x0B, 0xA0,
  0xB7, 0x74, 0x0B, 0xA0, 0xB7, 0x74, 0x0B, 0xA0, 0xB7, 0x74, 0x0B, 0xA0, 0xB7, 0x74, 0x0B, 0xA0,
  0xB7, 0x74, 0x0B, 0xA0, 0xB7, 0x74, 0x0B, 0xA0, 0xB7, 0x74, 0x0B, 0xA0, 0xB7, 0x74, 0x0B, 0xA0,
  0xB7, 0x74, 0x0B, 0xA0, 0xB7, 0x74, 0x0B, 0xA0, 0xB7, 0x20,
  // "Þ" (U+00DE)
  0x03, 0xB0, 0x67, 0x70, 0x3B, 0x06, 0x77, 0x03, 0xB0, 0x67, 0x70, 0x3B, 0x06, 0x77, 0x03, 0xB0,
  0x67, 0x70, 0x3B, 0x06, 0x77, 0x03, 0xB8, 0x02, 0xE8, 0x2D, 0xB9, 0x55, 0x03, 0xFE, 0x0E, 0x07,
  0x30, 0x3F, 0xF9, 0x0A, 0x20, 0x3B, 0x06, 0x58, 0x12, 0x5B, 0xC8, 0x18, 0x03, 0xB0, 0x67, 0x10,
  0x5C, 0x01, 0x03, 0xB0, 0x67, 0x20, 0x8B, 0x06, 0x03, 0xB0, 0x67, 0x20, 0x2B, 0x0A, 0x03, 0xB0,
  0x67, 0x30, 0xEA, 0x0B, 0x03, 0xB0, 0x67, 0x30, 0xDA, 0x0B, 0x03, 0xB0, 0x67, 0x3B, 0x09, 0x03,
  0xB0, 0x67, 0x20, 0x3B, 0x07, 0x03, 0xB0, 0x67, 0x20, 0x9B, 0x02, 0x03, 0xB0, 0x67, 0x10, 0x6B,
  0x81, 0xB0, 0x3B, 0x06, 0x58, 0x12, 0x6C, 0xC8, 0x13, 0x03, 0xB8, 0x01, 0xEE, 0x0E, 0x04, 0x20,
  0x3F, 0xE0, 0xB0, 0x23, 0x03, 0xF9, 0x83, 0xED, 0xB8, 0x35, 0x03, 0xB0, 0x67, 0x70, 0x3B, 0x06,
  0x77, 0x03, 0xB0, 0x67, 0x70, 0x3B, 0x06, 0x77, 0x03, 0xB0, 0x67, 0x70, 0x3B, 0x06, 0x77,
  // "ß" (U+00DF)
  0x48, 0x90, 0x49, 0xCD, 0xFE, 0xEB, 0x83, 0x71, 0x04, 0x0D, 0xFB, 0x0C, 0x03, 0x50, 0x5E, 0x0E,
  0xF0, 0x33, 0x02, 0xC0, 0xA0, 0x43, 0x81, 0x15, 0xCB, 0x0D, 0x30, 0x8B, 0x07, 0x71, 0x0B, 0xB0,
  0x42, 0x0C, 0xA0, 0xD7, 0x20, 0x4B, 0x06, 0x20, 0xEA, 0x09, 0x72, 0x04, 0xB0, 0x52, 0xB0, 0x87,
  0x20, 0x8B, 0x02, 0x2B, 0x08, 0x71, 0x04, 0xB0, 0xB3, 0xB0, 0x87, 0x06, 0xB0, 0xD0, 0x13, 0xB0,
  0x86, 0x09, 0xB0, 0xD0, 0x24, 0xB0, 0x85, 0x09, 0xB0, 0xB0, 0x15, 0xB0, 0x84, 0x03, 0xB0, 0xA7,
  0xB0, 0x84, 0x07, 0xB0, 0x17, 0xB0, 0x84, 0x08, 0xA0, 0xD7, 0x1B, 0x08, 0x40, 0x7B, 0x06, 0x7B,
  0x08, 0x40, 0x10, 0xEB, 0x09, 0x6B, 0x08, 0x50, 0x4C, 0x0D, 0x03, 0x4B, 0x08, 0x60, 0x30, 0xDC,
  0x07, 0x3B, 0x08, 0x70, 0x10, 0xBC, 0x0A, 0x2B, 0x08, 0x72, 0x06, 0x0E, 0xB0, 0xA1, 0xB0, 0x87,
  0x30, 0x20, 0xDB, 0x04, 0xB0, 0x87, 0x40, 0x20, 0xEA, 0x0A, 0xB0, 0x87, 0x50, 0xAA, 0x0D, 0xB0,
  0x87, 0x50, 0x8E, 0x08, 0x75, 0x0A, 0xA0, 0xEB, 0x08, 0x20, 0x10, 0x37, 0x01, 0x0E, 0xA0, 0xBB,
  0x08, 0x28, 0x33, 0xFB, 0x62, 0x30, 0x30, 0xCB, 0x06, 0xB0, 0x82, 0x03, 0xD0, 0xED, 0x0C, 0x1B,
  0x08, 0x20, 0x3F, 0xB0, 0xB0, 0x11, 0xB0, 0x83, 0x82, 0x38, 0xBD, 0xA8, 0x2E, 0xC9, 0x33,
  // "à" (U+00E0)
  0x48, 0x33, 0x77, 0x76, 0x77, 0x01, 0x0E, 0xB0, 0x47, 0x70, 0x4B, 0x0D, 0x77, 0x10, 0x5B, 0x07,
  0x77, 0x10, 0x6B, 0x02, 0x77, 0x10, 0x7A, 0x0C, 0x77, 0x20, 0x5A, 0x07, 0x80, 0xD5, 0x08, 0x25,
  0x9C, 0xEA, 0x82, 0xEB, 0x82, 0x60, 0x20, 0x9F, 0xC0, 0x95, 0x06, 0xE0, 0xEE, 0x0C, 0x58, 0x3D,
  0xE9, 0x52, 0x38, 0x11, 0x5C, 0xB0, 0x74, 0x02, 0x73, 0x0A, 0xA0, 0xE7, 0x71, 0x02, 0xB0, 0x37,
  0x71, 0x0E, 0xA0, 0x57, 0x71, 0x0D, 0xA0, 0x65, 0x83, 0x37, 0xAC, 0xD8, 0x01, 0xEB, 0x06, 0x30,
  0x30, 0xCF, 0xE0, 0x62, 0x05, 0xFF, 0x98, 0x16, 0x02, 0xC8, 0x2C, 0x63, 0x15, 0x0D, 0xA8, 0x16,
  0x0A, 0xB0, 0x77, 0x20, 0xDA, 0x81, 0x60, 0xEA, 0x0A, 0x73, 0x0E, 0xA0, 0x60, 0x1B, 0x04, 0x72,
  0x01, 0xB0, 0x60, 0x2B, 0x03, 0x72, 0x06, 0xB0, 0x60, 0x1B, 0x05, 0x71, 0x01, 0x0D, 0xB8, 0x16,
  0x0E, 0xA0, 0xB7, 0x01, 0x0C, 0xC8, 0x16, 0x09, 0xB0, 0xB0, 0x43, 0x84, 0x38, 0xEF, 0xEE, 0xA8,
  0x26, 0x01, 0xED, 0x0E, 0xC8, 0x1E, 0x2C, 0xA0, 0x62, 0x02, 0x0D, 0xF9, 0x82, 0xB2, 0x0A, 0xA0,
  0x64, 0x86, 0x5B, 0xDF, 0xED, 0x94, 0x30, 0x8A, 0x06,
  // "á" (U+00E1)
  0x75, 0x83, 0x37, 0x77, 0x67, 0x70, 0xDB, 0x07, 0x76, 0x07, 0xB0, 0xA7, 0x60, 0x2B, 0x0B, 0x77,
  0x0B, 0xA0, 0xC7, 0x70, 0x6A, 0x0C, 0x01, 0x76, 0x01, 0xA0, 0xB8, 0x0D, 0x60, 0x82, 0x59, 0xCE,
  0xA8, 0x2E, 0xB8, 0x26, 0x02, 0x09, 0xFC, 0x09, 0x50, 0x6E, 0x0E, 0xE0, 0xC5, 0x83, 0xDE, 0x95,
  0x23, 0x81, 0x15, 0xCB, 0x07, 0x40, 0x27, 0x30, 0xAA, 0x0E, 0x77, 0x10, 0x2B, 0x03, 0x77, 0x10,
  0xEA, 0x05, 0x77, 0x10, 0xDA, 0x06, 0x58, 0x33, 0x7A, 0xCD, 0x80, 0x1E, 0xB0, 0x63, 0x03, 0x0C,
  0xFE, 0x06, 0x20, 0x5F, 0xF9, 0x81, 0x60, 0x2C, 0x82, 0xC6, 0x31, 0x50, 0xDA, 0x81, 0x60, 0xAB,
  0x07, 0x72, 0x0D, 0xA8, 0x16, 0x0E, 0xA0, 0xA7, 0x30, 0xEA, 0x06, 0x01, 0xB0, 0x47, 0x20, 0x1B,
  0x06, 0x02, 0xB0, 0x37, 0x20, 0x6B, 0x06, 0x01, 0xB0, 0x57, 0x10, 0x10, 0xDB, 0x81, 0x60, 0xEA,
  0x0B, 0x70, 0x10, 0xCC, 0x81, 0x60, 0x9B, 0x0B, 0x04, 0x38, 0x43, 0x8E, 0xFE, 0xEA, 0x82, 0x60,
  0x1E, 0xD0, 0xEC, 0x81, 0xE2, 0xCA, 0x06, 0x20, 0x20, 0xDF, 0x98, 0x2B, 0x20, 0xAA, 0x06, 0x48,
  0x65, 0xBD, 0xFE, 0xD9, 0x43, 0x08, 0xA0, 0x60,
  // "â" (U+00E2)
  0x71, 0x80, 0x07, 0x77, 0x07, 0xC0, 0x67, 0x50, 0x4D, 0x0E, 0x02, 0x73, 0x02, 0x0E, 0xA0, 0x80,
  0xAA, 0x0D, 0x01, 0x71, 0x01, 0x0D, 0xA0, 0x72, 0x0A, 0xA0, 0xC7, 0x10, 0xBA, 0x07, 0x40, 0x9A,
  0x0B, 0x68, 0x29, 0xFE, 0x56, 0x06, 0xA0, 0x98, 0x0D, 0x10, 0x82, 0x59, 0xCE, 0xA8, 0x2E, 0xB8,
  0x26, 0x02, 0x09, 0xFC, 0x09, 0x50, 0x6E, 0x0E, 0xE0, 0xC5, 0x83, 0xDE, 0x95, 0x23, 0x81, 0x15,
  0xCB, 0x07, 0x40, 0x27, 0x30, 0xAA, 0x0E, 0x77, 0x10, 0x2B, 0x03, 0x77, 0x10, 0xEA, 0x05, 0x77,
  0x10, 0xDA, 0x06, 0x58, 0x33, 0x7A, 0xCD, 0x80, 0x1E, 0xB0, 0x63, 0x03, 0x0C, 0xFE, 0x06, 0x20,
  0x5F, 0xF9, 0x81, 0x60, 0x2C, 0x82, 0xC6, 0x31, 0x50, 0xDA, 0x81, 0x60, 0xAB, 0x07, 0x72, 0x0D,
  0xA8, 0x16, 0x0E, 0xA0, 0xA7, 0x30, 0xEA, 0x06, 0x01, 0xB0, 0x47, 0x20, 0x1B, 0x06, 0x02, 0xB0,
  0x37, 0x20, 0x6B, 0x06, 0x01, 0xB0, 0x57, 0x10, 0x10, 0xDB, 0x81, 0x60, 0xEA, 0x0B, 0x70, 0x10,
  0xCC, 0x81, 0x60, 0x9B, 0x0B, 0x04, 0x38, 0x43, 0x8E, 0xFE, 0xEA, 0x82, 0x60, 0x1E, 0xD0, 0xEC,
  0x81, 0xE2, 0xCA, 0x06, 0x20, 0x20, 0xDF, 0x98, 0x2B, 0x20, 0xAA, 0x06, 0x48, 0x65, 0xBD, 0xFE,
  0xD9, 0x43, 0x08, 0xA0, 0x60,
  // "ã" (U+00E3)
  0x48, 0x41, 0x9E, 0xEB, 0x55, 0x81, 0xEF, 0x15, 0x0D, 0xD0, 0xC0, 0x52, 0x81, 0x9F, 0xD5, 0x07,
  0xFD, 0x07, 0x58, 0x1D, 0xF9, 0x20, 0x40, 0xCD, 0x0D, 0x50, 0x1A, 0x58, 0x45, 0xCE, 0xE9, 0x18,
  0x0D, 0x20, 0x82, 0x59, 0xCE, 0xA8, 0x2E, 0xB8, 0x26, 0x02, 0x09, 0xFC, 0x09, 0x50, 0x6E, 0x0E,
  0xE0, 0xC5, 0x83, 0xDE, 0x95, 0x23, 0x81, 0x15, 0xCB, 0x07, 0x40, 0x27, 0x30, 0xAA, 0x0E, 0x77,
  0x10, 0x2B, 0x03, 0x77, 0x10, 0xEA, 0x05, 0x77, 0x10, 0xDA, 0x06, 0x58, 0x33, 0x7A, 0xCD, 0x80,
  0x1E, 0xB0, 0x63, 0x03, 0x0C, 0xFE, 0x06, 0x20, 0x5F, 0xF9, 0x81, 0x60, 0x2C, 0x82, 0xC6, 0x31,
  0x50, 0xDA, 0x81, 0x60, 0xAB, 0x07, 0x72, 0x0D, 0xA8, 0x16, 0x0E, 0xA0, 0xA7, 0x30, 0xEA, 0x06,
  0x01, 0xB0, 0x47, 0x20, 0x1B, 0x06, 0x02, 0xB0, 0x37, 0x20, 0x6B, 0x06, 0x01, 0xB0, 0x57, 0x10,
  0x10, 0xDB, 0x81, 0x60, 0xEA, 0x0B, 0x70, 0x10, 0xCC, 0x81, 0x60, 0x9B, 0x0B, 0x04, 0x38, 0x43,
  0x8E, 0xFE, 0xEA, 0x82, 0x60, 0x1E, 0xD0, 0xEC, 0x81, 0xE2, 0xCA, 0x06, 0x20, 0x20, 0xDF, 0x98,
  0x2B, 0x20, 0xAA, 0x06, 0x48, 0x65, 0xBD, 0xFE, 0xD9, 0x43, 0x08, 0xA0, 0x60,
  // "ä" (U+00E4)
  0x38, 0x21, 0xBE, 0xA6, 0x82, 0xAE, 0xC2, 0x50, 0x8B, 0x07, 0x40, 0x6B, 0x09, 0x50, 0xAB, 0x09,
  0x40, 0x8B, 0x0B, 0x50, 0x8B, 0x06, 0x40, 0x5B, 0x09, 0x58, 0x21, 0xBE, 0xA6, 0x82, 0x9E, 0xB1,
  0x80, 0xF4, 0x08, 0x25, 0x9C, 0xEA, 0x82, 0xEB, 0x82, 0x60, 0x20, 0x9F, 0xC0, 0x95, 0x06, 0xE0,
  0xEE, 0x0C, 0x58, 0x3D, 0xE9, 0x52, 0x38, 0x11, 0x5C, 0xB0, 0x74, 0x02, 0x73, 0x0A, 0xA0, 0xE7,
  0x71, 0x02, 0xB0, 0x37, 0x71, 0x0E, 0xA0, 0x57, 0x71, 0x0D, 0xA0, 0x65, 0x83, 0x37, 0xAC, 0xD8,
  0x01, 0xEB, 0x06, 0x30, 0x30, 0xCF, 0xE0, 0x62, 0x05, 0xFF, 0x98, 0x16, 0x02, 0xC8, 0x2C, 0x63,
  0x15, 0x0D, 0xA8, 0x16, 0x0A, 0xB0, 0x77, 0x20, 0xDA, 0x81, 0x60, 0xEA, 0x0A, 0x73, 0x0E, 0xA0,
  0x60, 0x1B, 0x04, 0x72, 0x01, 0xB0, 0x60, 0x2B, 0x03, 0x72, 0x06, 0xB0, 0x60, 0x1B, 0x05, 0x71,
  0x01, 0x0D, 0xB8, 0x16, 0x0E, 0xA0, 0xB7, 0x01, 0x0C, 0xC8, 0x16, 0x09, 0xB0, 0xB0, 0x43, 0x84,
  0x38, 0xEF, 0xEE, 0xA8, 0x26, 0x01, 0xED, 0x0E, 0xC8, 0x1E, 0x2C, 0xA0, 0x62, 0x02, 0x0D, 0xF9,
  0x82, 0xB2, 0x0A, 0xA0, 0x64, 0x86, 0x5B, 0xDF, 0xED, 0x94, 0x30, 0x8A, 0x06,
  // "å" (U+00E5)
  0x70, 0x70, 0xDA, 0x0D, 0x06, 0x75, 0x0A, 0xE0, 0x97, 0x30, 0x2A, 0x82, 0x81, 0x19, 0xA0, 0x27,
  0x28, 0x15, 0xFE, 0x48, 0x1E, 0xF5, 0x72, 0x81, 0x5F, 0xE4, 0x81, 0xEF, 0x57, 0x20, 0x2A, 0x82,
  0x92, 0x2A, 0xA0, 0x17, 0x30, 0x8E, 0x08, 0x75, 0x84, 0x6C, 0xFE, 0xC5, 0x80, 0xD5, 0x08, 0x25,
  0x9C, 0xEA, 0x82, 0xEB, 0x82, 0x60, 0x20, 0x9F, 0xC0, 0x95, 0x06, 0xE0, 0xEE, 0x0C, 0x58, 0x3D,
  0xE9, 0x52, 0x38, 0x11, 0x5C, 0xB0, 0x74, 0x02, 0x73, 0x0A, 0xA0, 0xE7, 0x71, 0x02, 0xB0, 0x37,
  0x71, 0x0E, 0xA0, 0x57, 0x71, 0x0D, 0xA0, 0x65, 0x83, 0x37, 0xAC, 0xD8, 0x01, 0xEB, 0x06, 0x30,
  0x30, 0xCF, 0xE0, 0x62, 0x05, 0xFF, 0x98, 0x16, 0x02, 0xC8, 0x2C, 0x63, 0x15, 0x0D, 0xA8, 0x16,
  0x0A, 0xB0, 0x77, 0x20, 0xDA, 0x81, 0x60, 0xEA, 0x0A, 0x73, 0x0E, 0xA0, 0x60, 0x1B, 0x04, 0x72,
  0x01, 0xB0, 0x60, 0x2B, 0x03, 0x72, 0x06, 0xB0, 0x60, 0x1B, 0x05, 0x71, 0x01, 0x0D, 0xB8, 0x16,
  0x0E, 0xA0, 0xB7, 0x01, 0x0C, 0xC8, 0x16, 0x09, 0xB0, 0xB0, 0x43, 0x84, 0x38, 0xEF, 0xEE, 0xA8,
  0x26, 0x01, 0xED, 0x0E, 0xC8, 0x1E, 0x2C, 0xA0, 0x62, 0x02, 0x0D, 0xF9, 0x82, 0xB2, 0x0A, 0xA0,
  0x64, 0x86, 0x5B, 0xDF, 0xED, 0x94, 0x30, 0x8A, 0x06,
  // "æ" (U+00E6)
  0x48, 0x55, 0xAE, 0xFD, 0x93, 0x38, 0x43, 0xAD, 0xEC, 0x76, 0x04, 0x0D, 0xF8, 0x15, 0x05, 0xE0,
  0xB5, 0x07, 0xF9, 0x0E, 0x03, 0xF9, 0x09, 0x48, 0x21, 0xEB, 0x42, 0x03, 0x0D, 0xA0, 0xEA, 0x07,
  0x20, 0x8B, 0x02, 0x40, 0x35, 0x03, 0xC0, 0x94, 0x0C, 0xA0, 0x77, 0x40, 0xDB, 0x01, 0x40, 0x6A,
  0x0B, 0x74, 0x0B, 0xA0, 0xC5, 0x03, 0xA0, 0xE7, 0x40, 0xAA, 0x09, 0x50, 0x2B, 0x01, 0x73, 0x0A,
  0xA0, 0x85, 0x01, 0xB0, 0x23, 0x82, 0x18, 0xCE, 0xFF, 0xA0, 0x22, 0x03, 0x0E, 0xFF, 0xD8, 0x23,
  0x02, 0xED, 0x00, 0xEB, 0x80, 0x6E, 0x81, 0x20, 0x9B, 0x09, 0x03, 0x30, 0xBA, 0x06, 0x74, 0x0E,
  0xA0, 0x95, 0x0B, 0xA0, 0x77, 0x30, 0x1B, 0x02, 0x50, 0xDA, 0x0A, 0x73, 0x02, 0xB6, 0x0E, 0xA0,
  0xD7, 0x30, 0x2B, 0x01, 0x40, 0x3C, 0x03, 0x73, 0xB0, 0x44, 0x0B, 0xC0, 0xC7, 0x03, 0x20, 0xCA,
  0x83, 0xD3, 0x01, 0x9A, 0x07, 0x0C, 0xA0, 0xC0, 0x32, 0x82, 0x15, 0xCA, 0x20, 0x5F, 0x98, 0x1D,
  0x03, 0xFA, 0x0A, 0x30, 0x9E, 0x0D, 0x02, 0x20, 0x5F, 0x90, 0x84, 0x84, 0x5C, 0xFE, 0xC6, 0x58,
  0x61, 0x8C, 0xEF, 0xD9, 0x32,
  // "ç" (U+00E7)
  0x68, 0x24, 0x9C, 0xEA, 0x82, 0xEB, 0x84, 0x60, 0x50, 0xDF, 0xB0, 0xD0, 0x13, 0x09, 0xFD, 0x0C,
  0x30, 0x7C, 0x81, 0x94, 0x12, 0x83, 0x14, 0x9F, 0x72, 0x02, 0xB0, 0xE0, 0x47, 0x10, 0x20, 0x12,
  0x0A, 0xB0, 0x57, 0x60, 0xEA, 0x0D, 0x76, 0x03, 0xB0, 0x77, 0x60, 0x6B, 0x04, 0x76, 0x08, 0xB0,
  0x27, 0x60, 0x8B, 0x01, 0x76, 0x08, 0xB0, 0x17, 0x60, 0x7B, 0x02, 0x76, 0x06, 0xB0, 0x47, 0x60,
  0x4B, 0x07, 0x76, 0x01, 0xB0, 0xC7, 0x70, 0xBB, 0x04, 0x76, 0x04, 0xB0, 0xE0, 0x37, 0x60, 0xAC,
  0x09, 0x03, 0x48, 0x22, 0x6A, 0xE4, 0x0B, 0xFD, 0x0E, 0x50, 0x70, 0xEF, 0xB0, 0xE7, 0x89, 0x16,
  0xAD, 0xEF, 0xED, 0xB9, 0x51, 0x72, 0x01, 0xA0, 0x37, 0x78, 0x18, 0xFC, 0x77, 0x83, 0x1E, 0xFB,
  0x37, 0x60, 0x50, 0xEB, 0x0A, 0x77, 0x04, 0x0C, 0xA0, 0x87, 0x70, 0x1A, 0x0C, 0x77, 0x01, 0xA0,
  0xC7, 0x38, 0x34, 0x33, 0x5C, 0xA0, 0x87, 0x3E, 0x0C, 0x74, 0x0E, 0xA8, 0x1E, 0xB6, 0x60,
  // "è" (U+00E8)
  0x48, 0x33, 0x77, 0x76, 0x77, 0x10, 0x10, 0xEB, 0x04, 0x77, 0x10, 0x4B, 0x0D, 0x77, 0x20, 0x5B,
  0x07, 0x77, 0x20, 0x6B, 0x02, 0x77, 0x20, 0x7A, 0x0C, 0x77, 0x30, 0x5A, 0x07, 0x80, 0xE1, 0x08,
  0x74, 0x9C, 0xEF, 0xEC, 0x83, 0x72, 0x02, 0x0C, 0xFA, 0x0A, 0x70, 0x5E, 0x0E, 0xD0, 0xC0, 0x14,
  0x04, 0xC0, 0xA0, 0x33, 0x03, 0x0B, 0xB0, 0xA4, 0x0D, 0xB0, 0x57, 0x09, 0xB0, 0x52, 0x07, 0xB0,
  0x77, 0x20, 0xDA, 0x0B, 0x20, 0xDA, 0x0D, 0x73, 0x07, 0xB0, 0x10, 0x2B, 0x07, 0x73, 0x02, 0xB0,
  0x05, 0xB0, 0x37, 0x4B, 0x00, 0x7F, 0xFC, 0x00, 0x8F, 0xFC, 0x09, 0x08, 0xB8, 0x09, 0x3E, 0x08,
  0x07, 0xB0, 0x17, 0x71, 0x06, 0xB0, 0x37, 0x71, 0x02, 0xB0, 0x67, 0x72, 0x0E, 0xA0, 0xB7, 0x72,
  0x07, 0xB0, 0x57, 0x72, 0x0E, 0xB0, 0x57, 0x30, 0x20, 0x43, 0x03, 0xC8, 0x1B, 0x62, 0x38, 0x41,
  0x37, 0xBF, 0x94, 0x04, 0x0E, 0xE0, 0xEE, 0x09, 0x50, 0x10, 0xAF, 0xC0, 0xE0, 0x67, 0x89, 0x12,
  0x7A, 0xDE, 0xFE, 0xDB, 0x84, 0x30,
  // "é" (U+00E9)
  0x75, 0x83, 0x37, 0x77, 0x67, 0x71, 0x0D, 0xB0, 0x77, 0x70, 0x7B, 0x0A, 0x77, 0x02, 0xB0, 0xB7,
  0x71, 0x0B, 0xA0, 0xC7, 0x71, 0x06, 0xA0, 0xC0, 0x17, 0x70, 0x1A, 0x0B, 0x80, 0xE2, 0x08, 0x74,
  0x9C, 0xEF, 0xEC, 0x83, 0x72, 0x02, 0x0C, 0xFA, 0x0A, 0x70, 0x5E, 0x0E, 0xD0, 0xC0, 0x14, 0x04,
  0xC0, 0xA0, 0x33, 0x03, 0x0B, 0xB0, 0xA4, 0x0D, 0xB0, 0x57, 0x09, 0xB0, 0x52, 0x07, 0xB0, 0x77,
  0x20, 0xDA, 0x0B, 0x20, 0xDA, 0x0D, 0x73, 0x07, 0xB0, 0x10, 0x2B, 0x07, 0x73, 0x02, 0xB0, 0x05,
  0xB0, 0x37, 0x4B, 0x00, 0x7F, 0xFC, 0x00, 0x8F, 0xFC, 0x09, 0x08, 0xB8, 0x09, 0x3E, 0x08, 0x07,
  0xB0, 0x17, 0x71, 0x06, 0xB0, 0x37, 0x71, 0x02, 0xB0, 0x67, 0x72, 0x0E, 0xA0, 0xB7, 0x72, 0x07,
  0xB0, 0x57, 0x72, 0x0E, 0xB0, 0x57, 0x30, 0x20, 0x43, 0x03, 0xC8, 0x1B, 0x62, 0x38, 0x41, 0x37,
  0xBF, 0x94, 0x04, 0x0E, 0xE0, 0xEE, 0x09, 0x50, 0x10, 0xAF, 0xC0, 0xE0, 0x67, 0x89, 0x12, 0x7A,
  0xDE, 0xFE, 0xDB, 0x84, 0x30,
  // "ê" (U+00EA)
  0x71, 0x80, 0x07, 0x77, 0x10, 0x7C, 0x06, 0x76, 0x04, 0xD0, 0xE0, 0x27, 0x40, 0x20, 0xEA, 0x08,
  0x0A, 0xA0, 0xD0, 0x17, 0x20, 0x10, 0xDA, 0x07, 0x20, 0xAA, 0x0C, 0x72, 0x0B, 0xA0, 0x74, 0x09,
  0xA0, 0xB7, 0x82, 0x9F, 0xE5, 0x60, 0x6A, 0x09, 0x80, 0xD5, 0x08, 0x74, 0x9C, 0xEF, 0xEC, 0x83,
  0x72, 0x02, 0x0C, 0xFA, 0x0A, 0x70, 0x5E, 0x0E, 0xD0, 0xC0, 0x14, 0x04, 0xC0, 0xA0, 0x33, 0x03,
  0x0B, 0xB0, 0xA4, 0x0D, 0xB0, 0x57, 0x09, 0xB0, 0x52, 0x07, 0xB0, 0x77, 0x20, 0xDA, 0x0B, 0x20,
  0xDA, 0x0D, 0x73, 0x07, 0xB0, 0x10, 0x2B, 0x07, 0x73, 0x02, 0xB0, 0x05, 0xB0, 0x37, 0x4B, 0x00,
  0x7F, 0xFC, 0x00, 0x8F, 0xFC, 0x09, 0x08, 0xB8, 0x09, 0x3E, 0x08, 0x07, 0xB0, 0x17, 0x71, 0x06,
  0xB0, 0x37, 0x71, 0x02, 0xB0, 0x67, 0x72, 0x0E, 0xA0, 0xB7, 0x72, 0x07, 0xB0, 0x57, 0x72, 0x0E,
  0xB0, 0x57, 0x30, 0x20, 0x43, 0x03, 0xC8, 0x1B, 0x62, 0x38, 0x41, 0x37, 0xBF, 0x94, 0x04, 0x0E,
  0xE0, 0xEE, 0x09, 0x50, 0x10, 0xAF, 0xC0, 0xE0, 0x67, 0x89, 0x12, 0x7A, 0xDE, 0xFE, 0xDB, 0x84,
  0x30,
  // "ë" (U+00EB)
  0x38, 0x21, 0xBE, 0xA6, 0x82, 0xAE, 0xC2, 0x60, 0x8B, 0x07, 0x40, 0x6B, 0x09, 0x60, 0xAB, 0x09,
  0x40, 0x8B, 0x0B, 0x60, 0x8B, 0x06, 0x40, 0x5B, 0x09, 0x68, 0x21, 0xBE, 0xA6, 0x82, 0x9E, 0xB1,
  0x80, 0x98, 0x10, 0x87, 0x49, 0xCE, 0xFE, 0xC8, 0x37, 0x20, 0x20, 0xCF, 0xA0, 0xA7, 0x05, 0xE0,
  0xED, 0x0C, 0x01, 0x40, 0x4C, 0x0A, 0x03, 0x30, 0x30, 0xBB, 0x0A, 0x40, 0xDB, 0x05, 0x70, 0x9B,
  0x05, 0x20, 0x7B, 0x07, 0x72, 0x0D, 0xA0, 0xB2, 0x0D, 0xA0, 0xD7, 0x30, 0x7B, 0x01, 0x02, 0xB0,
  0x77, 0x30, 0x2B, 0x00, 0x5B, 0x03, 0x74, 0xB0, 0x07, 0xFF, 0xC0, 0x08, 0xFF, 0xC0, 0x90, 0x8B,
  0x80, 0x93, 0xE0, 0x80, 0x7B, 0x01, 0x77, 0x10, 0x6B, 0x03, 0x77, 0x10, 0x2B, 0x06, 0x77, 0x20,
  0xEA, 0x0B, 0x77, 0x20, 0x7B, 0x05, 0x77, 0x20, 0xEB, 0x05, 0x73, 0x02, 0x04, 0x30, 0x3C, 0x81,
  0xB6, 0x23, 0x84, 0x13, 0x7B, 0xF9, 0x40, 0x40, 0xEE, 0x0E, 0xE0, 0x95, 0x01, 0x0A, 0xFC, 0x0E,
  0x06, 0x78, 0x91, 0x27, 0xAD, 0xEF, 0xED, 0xB8, 0x43,
  // "ì" (U+00EC)
  0x38, 0x33, 0x77, 0x76, 0x77, 0x01, 0x0E, 0xB0, 0x47, 0x70, 0x4B, 0x0D, 0x77, 0x10, 0x5B, 0x07,
  0x77, 0x10, 0x6B, 0x02, 0x77, 0x10, 0x7A, 0x0C, 0x77, 0x20, 0x5A, 0x07, 0x80, 0xD1, 0x00, 0x2F,
  0xB0, 0x67, 0x02, 0xFB, 0x06, 0x78, 0x31, 0xAB, 0xCD, 0xE0, 0x67, 0x70, 0x3B, 0x06, 0x77, 0x02,
  0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0, 0x67,
  0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B,
  0x06, 0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77,
  0x02, 0xB0, 0x77, 0x85, 0x58, 0x9B, 0xCD, 0xEE, 0x85, 0xDC, 0xB9, 0x84, 0xCF, 0xFB, 0x09, 0x0C,
  0xFF, 0xB0, 0x90,
  // "í" (U+00ED)
  0x74, 0x83, 0x37, 0x77, 0x67, 0x70, 0xDB, 0x07, 0x76, 0x07, 0xB0, 0xA7, 0x60, 0x2B, 0x0B, 0x77,
  0x0B, 0xA0, 0xC7, 0x70, 0x6A, 0x0C, 0x01, 0x76, 0x01, 0xA0, 0xB8, 0x0D, 0x20, 0x02, 0xFB, 0x06,
  0x70, 0x2F, 0xB0, 0x67, 0x83, 0x1A, 0xBC, 0xDE, 0x06, 0x77, 0x03, 0xB0, 0x67, 0x70, 0x2B, 0x06,
  0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77, 0x02,
  0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0, 0x67,
  0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B,
  0x07, 0x78, 0x55, 0x89, 0xBC, 0xDE, 0xE8, 0x5D, 0xCB, 0x98, 0x4C, 0xFF, 0xB0, 0x90, 0xCF, 0xFB,
  0x09,
  // "î" (U+00EE)
  0x78, 0x00, 0x77, 0x70, 0x7C, 0x06, 0x75, 0x04, 0xD0, 0xE0, 0x27, 0x30, 0x20, 0xEA, 0x08, 0x0A,
  0xA0, 0xD0, 0x17, 0x10, 0x10, 0xDA, 0x07, 0x20, 0xAA, 0x0C, 0x71, 0x0B, 0xA0, 0x74, 0x09, 0xA0,
  0xB6, 0x82, 0x9F, 0xE5, 0x60, 0x6A, 0x09, 0x80, 0xC5, 0x00, 0x2F, 0xB0, 0x67, 0x02, 0xFB, 0x06,
  0x78, 0x31, 0xAB, 0xCD, 0xE0, 0x67, 0x70, 0x3B, 0x06, 0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B, 0x06,
  0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77, 0x02,
  0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0, 0x67,
  0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0, 0x77, 0x85, 0x58,
  0x9B, 0xCD, 0xEE, 0x85, 0xDC, 0xB9, 0x84, 0xCF, 0xFB, 0x09, 0x0C, 0xFF, 0xB0, 0x90,
  // "ï" (U+00EF)
  0x28, 0x21, 0xBE, 0xA6, 0x82, 0xAE, 0xC2, 0x50, 0x8B, 0x07, 0x40, 0x6B, 0x09, 0x50, 0xAB, 0x09,
  0x40, 0x8B, 0x0B, 0x50, 0x8B, 0x06, 0x40, 0x5B, 0x09, 0x58, 0x21, 0xBE, 0xA6, 0x82, 0x9E, 0xB1,
  0x80, 0xF0, 0x00, 0x2F, 0xB0, 0x67, 0x02, 0xFB, 0x06, 0x78, 0x31, 0xAB, 0xCD, 0xE0, 0x67, 0x70,
  0x3B, 0x06, 0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B, 0x06,
  0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77, 0x02,
  0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0, 0x67,
  0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0, 0x77, 0x85, 0x58, 0x9B, 0xCD, 0xEE, 0x85, 0xDC, 0xB9, 0x84,
  0xCF, 0xFB, 0x09, 0x0C, 0xFF, 0xB0, 0x90,
  // "ð" (U+00F0)
  0x60, 0x60, 0x47, 0x02, 0x03, 0x71, 0x02, 0xA0, 0xB0, 0x24, 0x82, 0x8F, 0xE1, 0x70, 0x8C, 0x82,
  0x60, 0x6E, 0xB0, 0x87, 0x10, 0x60, 0xEB, 0x0E, 0xB0, 0xE0, 0x57, 0x30, 0x10, 0xBD, 0x08, 0x75,
  0x07, 0x0E, 0xC0, 0xC7, 0x40, 0x40, 0xDB, 0x0D, 0xB0, 0xB7, 0x20, 0x6B, 0x82, 0xE7, 0x04, 0xB0,
  0x97, 0x28, 0x2D, 0xF9, 0x13, 0x05, 0xB0, 0x47, 0x10, 0x03, 0x60, 0x9A, 0x0D, 0x77, 0x30, 0xDA,
  0x07, 0x77, 0x20, 0x4A, 0x0E, 0x78, 0x91, 0x38, 0xCE, 0xFE, 0xD9, 0x40, 0xBA, 0x06, 0x40, 0x20,
  0xBF, 0xA0, 0xB0, 0x6A, 0x0C, 0x30, 0x30, 0xEF, 0xC0, 0xDB, 0x82, 0x10, 0x2E, 0xB8, 0x1B, 0x41,
  0x30, 0x40, 0xBD, 0x81, 0x50, 0xAB, 0x07, 0x71, 0x07, 0xC0, 0x70, 0x2B, 0x0A, 0x73, 0x0A, 0xB0,
  0xA0, 0x6B, 0x03, 0x73, 0x02, 0xB0, 0xB0, 0x9A, 0x0E, 0x75, 0x0D, 0xA0, 0xC0, 0xBA, 0x0C, 0x75,
  0x0C, 0xA0, 0xB0, 0xCA, 0x0C, 0x75, 0x0C, 0xA0, 0xA0, 0xBA, 0x0C, 0x75, 0x0D, 0xA0, 0x09, 0xB7,
  0x40, 0x1B, 0x00, 0x5B, 0x04, 0x73, 0x05, 0xB8, 0x12, 0x1E, 0xA0, 0xC7, 0x30, 0xCA, 0x0C, 0x20,
  0x8B, 0x08, 0x71, 0x08, 0xB0, 0x53, 0x0B, 0xB8, 0x1C, 0x51, 0x30, 0x40, 0xBB, 0x0A, 0x40, 0x10,
  0xCF, 0xD0, 0xB7, 0x08, 0xFB, 0x08, 0x72, 0x89, 0x01, 0x7B, 0xDF, 0xED, 0xB7, 0x15,
  // "ñ" (U+00F1)
  0x38, 0x41, 0x9E, 0xEB, 0x55, 0x81, 0xEF, 0x14, 0x0D, 0xD0, 0xC0, 0x52, 0x81, 0x9F, 0xD4, 0x07,
  0xFD, 0x07, 0x48, 0x1D, 0xF9, 0x20, 0x40, 0xCD, 0x0D, 0x40, 0x1A, 0x58, 0x45, 0xCE, 0xE9, 0x18,
  0x0C, 0x30, 0x0C, 0xA0, 0x22, 0x87, 0x16, 0xBD, 0xFE, 0xC9, 0x23, 0x0C, 0xA8, 0x24, 0x06, 0xEF,
  0x90, 0x82, 0x0C, 0xA0, 0x06, 0xFC, 0x81, 0x80, 0xCA, 0x0B, 0xA0, 0xB0, 0x43, 0x02, 0x09, 0xC0,
  0x20, 0xCC, 0x09, 0x70, 0x8B, 0x08, 0x0C, 0xB0, 0xD7, 0x20, 0xEA, 0x00, 0xCB, 0x07, 0x72, 0x0B,
  0xA0, 0xE0, 0xCB, 0x02, 0x72, 0x09, 0xB0, 0xCB, 0x73, 0x09, 0xB0, 0xCA, 0x0D, 0x73, 0x09, 0xB0,
  0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA,
  0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C,
  0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73,
  0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0,
  // "ò" (U+00F2)
  0x48, 0x33, 0x77, 0x76, 0x77, 0x10, 0x10, 0xEB, 0x04, 0x77, 0x10, 0x4B, 0x0D, 0x77, 0x20, 0x5B,
  0x07, 0x77, 0x20, 0x6B, 0x02, 0x77, 0x20, 0x7A, 0x0C, 0x77, 0x30, 0x5A, 0x07, 0x80, 0xE0, 0x08,
  0x21, 0x7B, 0xDA, 0x81, 0xDA, 0x67, 0x30, 0x8F, 0xA0, 0xE0, 0x67, 0x0B, 0xFD, 0x0A, 0x50, 0xAB,
  0x81, 0xD6, 0x12, 0x81, 0x16, 0xEB, 0x09, 0x30, 0x5B, 0x0C, 0x70, 0x10, 0xDB, 0x04, 0x20, 0xCA,
  0x0E, 0x01, 0x71, 0x02, 0xB8, 0x1C, 0x03, 0xB0, 0x87, 0x30, 0x9B, 0x02, 0x07, 0xB0, 0x37, 0x30,
  0x4B, 0x06, 0x09, 0xB7, 0x40, 0x1B, 0x09, 0x0B, 0xA0, 0xD7, 0x50, 0xEA, 0x0B, 0x0C, 0xA0, 0xC7,
  0x50, 0xDA, 0x0B, 0x0C, 0xA0, 0xC7, 0x50, 0xDA, 0x0C, 0x0B, 0xA0, 0xD7, 0x50, 0xEA, 0x0B, 0x09,
  0xB7, 0x40, 0x1B, 0x09, 0x06, 0xB0, 0x37, 0x30, 0x4B, 0x06, 0x02, 0xB0, 0x87, 0x30, 0x9B, 0x81,
  0x20, 0xBB, 0x01, 0x71, 0x02, 0xB0, 0xC2, 0x04, 0xB0, 0xC0, 0x16, 0x01, 0x0D, 0xB0, 0x43, 0x09,
  0xB8, 0x1D, 0x61, 0x28, 0x11, 0x6E, 0xB0, 0x95, 0x0A, 0xFD, 0x0B, 0x70, 0x70, 0xEF, 0x90, 0xE0,
  0x77, 0x28, 0x21, 0x6B, 0xDA, 0x82, 0xDB, 0x61, 0x50,
  // "ó" (U+00F3)
  0x75, 0x83, 0x37, 0x77, 0x67, 0x71, 0x0D, 0xB0, 0x77, 0x70, 0x7B, 0x0A, 0x77, 0x02, 0xB0, 0xB7,
  0x71, 0x0B, 0xA0, 0xC7, 0x71, 0x06, 0xA0, 0xC0, 0x17, 0x70, 0x1A, 0x0B, 0x80, 0xE1, 0x08, 0x21,
  0x7B, 0xDA, 0x81, 0xDA, 0x67, 0x30, 0x8F, 0xA0, 0xE0, 0x67, 0x0B, 0xFD, 0x0A, 0x50, 0xAB, 0x81,
  0xD6, 0x12, 0x81, 0x16, 0xEB, 0x09, 0x30, 0x5B, 0x0C, 0x70, 0x10, 0xDB, 0x04, 0x20, 0xCA, 0x0E,
  0x01, 0x71, 0x02, 0xB8, 0x1C, 0x03, 0xB0, 0x87, 0x30, 0x9B, 0x02, 0x07, 0xB0, 0x37, 0x30, 0x4B,
  0x06, 0x09, 0xB7, 0x40, 0x1B, 0x09, 0x0B, 0xA0, 0xD7, 0x50, 0xEA, 0x0B, 0x0C, 0xA0, 0xC7, 0x50,
  0xDA, 0x0B, 0x0C, 0xA0, 0xC7, 0x50, 0xDA, 0x0C, 0x0B, 0xA0, 0xD7, 0x50, 0xEA, 0x0B, 0x09, 0xB7,
  0x40, 0x1B, 0x09, 0x06, 0xB0, 0x37, 0x30, 0x4B, 0x06, 0x02, 0xB0, 0x87, 0x30, 0x9B, 0x81, 0x20,
  0xBB, 0x01, 0x71, 0x02, 0xB0, 0xC2, 0x04, 0xB0, 0xC0, 0x16, 0x01, 0x0D, 0xB0, 0x43, 0x09, 0xB8,
  0x1D, 0x61, 0x28, 0x11, 0x6E, 0xB0, 0x95, 0x0A, 0xFD, 0x0B, 0x70, 0x70, 0xEF, 0x90, 0xE0, 0x77,
  0x28, 0x21, 0x6B, 0xDA, 0x82, 0xDB, 0x61, 0x50,
  // "ô" (U+00F4)
  0x71, 0x80, 0x07, 0x77, 0x10, 0x7C, 0x06, 0x76, 0x04, 0xD0, 0xE0, 0x27, 0x40, 0x20, 0xEA, 0x08,
  0x0A, 0xA0, 0xD0, 0x17, 0x20, 0x10, 0xDA, 0x07, 0x20, 0xAA, 0x0C, 0x72, 0x0B, 0xA0, 0x74, 0x09,
  0xA0, 0xB7, 0x82, 0x9F, 0xE5, 0x60, 0x6A, 0x09, 0x80, 0xD4, 0x08, 0x21, 0x7B, 0xDA, 0x81, 0xDA,
  0x67, 0x30, 0x8F, 0xA0, 0xE0, 0x67, 0x0B, 0xFD, 0x0A, 0x50, 0xAB, 0x81, 0xD6, 0x12, 0x81, 0x16,
  0xEB, 0x09, 0x30, 0x5B, 0x0C, 0x70, 0x10, 0xDB, 0x04, 0x20, 0xCA, 0x0E, 0x01, 0x71, 0x02, 0xB8,
  0x1C, 0x03, 0xB0, 0x87, 0x30, 0x9B, 0x02, 0x07, 0xB0, 0x37, 0x30, 0x4B, 0x06, 0x09, 0xB7, 0x40,
  0x1B, 0x09, 0x0B, 0xA0, 0xD7, 0x50, 0xEA, 0x0B, 0x0C, 0xA0, 0xC7, 0x50, 0xDA, 0x0B, 0x0C, 0xA0,
  0xC7, 0x50, 0xDA, 0x0C, 0x0B, 0xA0, 0xD7, 0x50, 0xEA, 0x0B, 0x09, 0xB7, 0x40, 0x1B, 0x09, 0x06,
  0xB0, 0x37, 0x30, 0x4B, 0x06, 0x02, 0xB0, 0x87, 0x30, 0x9B, 0x81, 0x20, 0xBB, 0x01, 0x71, 0x02,
  0xB0, 0xC2, 0x04, 0xB0, 0xC0, 0x16, 0x01, 0x0D, 0xB0, 0x43, 0x09, 0xB8, 0x1D, 0x61, 0x28, 0x11,
  0x6E, 0xB0, 0x95, 0x0A, 0xFD, 0x0B, 0x70, 0x70, 0xEF, 0x90, 0xE0, 0x77, 0x28, 0x21, 0x6B, 0xDA,
  0x82, 0xDB, 0x61, 0x50,
  // "õ" (U+00F5)
  0x48, 0x41, 0x9E, 0xEB, 0x55, 0x81, 0xEF, 0x16, 0x0D, 0xD0, 0xC0, 0x52, 0x81, 0x9F, 0xD6, 0x07,
  0xFD, 0x07, 0x68, 0x1D, 0xF9, 0x20, 0x40, 0xCD, 0x0D, 0x60, 0x1A, 0x58, 0x45, 0xCE, 0xE9, 0x18,
  0x0D, 0x50, 0x82, 0x17, 0xBD, 0xA8, 0x1D, 0xA6, 0x73, 0x08, 0xFA, 0x0E, 0x06, 0x70, 0xBF, 0xD0,
  0xA5, 0x0A, 0xB8, 0x1D, 0x61, 0x28, 0x11, 0x6E, 0xB0, 0x93, 0x05, 0xB0, 0xC7, 0x01, 0x0D, 0xB0,
  0x42, 0x0C, 0xA0, 0xE0, 0x17, 0x10, 0x2B, 0x81, 0xC0, 0x3B, 0x08, 0x73, 0x09, 0xB0, 0x20, 0x7B,
  0x03, 0x73, 0x04, 0xB0, 0x60, 0x9B, 0x74, 0x01, 0xB0, 0x90, 0xBA, 0x0D, 0x75, 0x0E, 0xA0, 0xB0,
  0xCA, 0x0C, 0x75, 0x0D, 0xA0, 0xB0, 0xCA, 0x0C, 0x75, 0x0D, 0xA0, 0xC0, 0xBA, 0x0D, 0x75, 0x0E,
  0xA0, 0xB0, 0x9B, 0x74, 0x01, 0xB0, 0x90, 0x6B, 0x03, 0x73, 0x04, 0xB0, 0x60, 0x2B, 0x08, 0x73,
  0x09, 0xB8, 0x12, 0x0B, 0xB0, 0x17, 0x10, 0x2B, 0x0C, 0x20, 0x4B, 0x0C, 0x01, 0x60, 0x10, 0xDB,
  0x04, 0x30, 0x9B, 0x81, 0xD6, 0x12, 0x81, 0x16, 0xEB, 0x09, 0x50, 0xAF, 0xD0, 0xB7, 0x07, 0x0E,
  0xF9, 0x0E, 0x07, 0x72, 0x82, 0x16, 0xBD, 0xA8, 0x2D, 0xB6, 0x15,
  // "ö" (U+00F6)
  0x38, 0x21, 0xBE, 0xA6, 0x82, 0xAE, 0xC2, 0x60, 0x8B, 0x07, 0x40, 0x6B, 0x09, 0x60, 0xAB, 0x09,
  0x40, 0x8B, 0x0B, 0x60, 0x8B, 0x06, 0x40, 0x5B, 0x09, 0x68, 0x21, 0xBE, 0xA6, 0x82, 0x9E, 0xB1,
  0x80, 0x98, 0x00, 0x82, 0x17, 0xBD, 0xA8, 0x1D, 0xA6, 0x73, 0x08, 0xFA, 0x0E, 0x06, 0x70, 0xBF,
  0xD0, 0xA5, 0x0A, 0xB8, 0x1D, 0x61, 0x28, 0x11, 0x6E, 0xB0, 0x93, 0x05, 0xB0, 0xC7, 0x01, 0x0D,
  0xB0, 0x42, 0x0C, 0xA0, 0xE0, 0x17, 0x10, 0x2B, 0x81, 0xC0, 0x3B, 0x08, 0x73, 0x09, 0xB0, 0x20,
  0x7B, 0x03, 0x73, 0x04, 0xB0, 0x60, 0x9B, 0x74, 0x01, 0xB0, 0x90, 0xBA, 0x0D, 0x75, 0x0E, 0xA0,
  0xB0, 0xCA, 0x0C, 0x75, 0x0D, 0xA0, 0xB0, 0xCA, 0x0C, 0x75, 0x0D, 0xA0, 0xC0, 0xBA, 0x0D, 0x75,
  0x0E, 0xA0, 0xB0, 0x9B, 0x74, 0x01, 0xB0, 0x90, 0x6B, 0x03, 0x73, 0x04, 0xB0, 0x60, 0x2B, 0x08,
  0x73, 0x09, 0xB8, 0x12, 0x0B, 0xB0, 0x17, 0x10, 0x2B, 0x0C, 0x20, 0x4B, 0x0C, 0x01, 0x60, 0x10,
  0xDB, 0x04, 0x30, 0x9B, 0x81, 0xD6, 0x12, 0x81, 0x16, 0xEB, 0x09, 0x50, 0xAF, 0xD0, 0xB7, 0x07,
  0x0E, 0xF9, 0x0E, 0x07, 0x72, 0x82, 0x16, 0xBD, 0xA8, 0x2D, 0xB6, 0x15,
  // "÷" (U+00F7)
  0x78, 0x27, 0xEE, 0x57, 0x60, 0x1C, 0x76, 0x03, 0xC0, 0x17, 0x50, 0x1B, 0x0E, 0x77, 0x82, 0x6E,
  0xD5, 0x80, 0xF1, 0x00, 0xB8, 0x09, 0x4E, 0x0B, 0x0C, 0xFF, 0xA0, 0x0C, 0xFF, 0xA0, 0xC8, 0x0F,
  0x10, 0x82, 0x7E, 0xE5, 0x76, 0x01, 0xC7, 0x60, 0x3C, 0x01, 0x75, 0x01, 0xB0, 0xE7, 0x78, 0x26,
  0xED, 0x57,
  // "ø" (U+00F8)
  0x77, 0x20, 0x40, 0x77, 0x89, 0x51, 0x7B, 0xDF, 0xED, 0xA6, 0x11, 0xDF, 0xC1, 0x40, 0x8F, 0xA0,
  0xE0, 0xCA, 0x0C, 0x40, 0xBF, 0xF0, 0x23, 0x0A, 0xB8, 0x1D, 0x61, 0x28, 0x12, 0x7E, 0xB0, 0xA3,
  0x05, 0xB0, 0xC7, 0x0B, 0xC0, 0x22, 0x0D, 0xA0, 0xE0, 0x16, 0x07, 0xD8, 0x1A, 0x03, 0xB0, 0x86,
  0x03, 0xB0, 0xCB, 0x01, 0x07, 0xB0, 0x35, 0x01, 0x0D, 0xA0, 0x70, 0x5B, 0x05, 0x09, 0xB6, 0x0A,
  0xA8, 0x1B, 0x01, 0xB0, 0x80, 0xBA, 0x0D, 0x50, 0x6A, 0x0E, 0x01, 0x2B, 0x0A, 0x0C, 0xA0, 0xC4,
  0x02, 0xB0, 0x43, 0x0D, 0xA0, 0x0B, 0xA0, 0xC4, 0x0D, 0xA0, 0x84, 0x0D, 0xA0, 0xC0, 0xAA, 0x0D,
  0x30, 0x9A, 0x0C, 0x50, 0xEA, 0x0B, 0x09, 0xB2, 0x05, 0xA0, 0xE0, 0x24, 0x01, 0xB0, 0x90, 0x5B,
  0x81, 0x31, 0xEA, 0x05, 0x50, 0x4B, 0x07, 0x02, 0xB0, 0x80, 0xCA, 0x09, 0x60, 0x9B, 0x81, 0x20,
  0xBD, 0x0D, 0x60, 0x2B, 0x0C, 0x20, 0x3D, 0x03, 0x50, 0x10, 0xCB, 0x05, 0x30, 0x8B, 0x81, 0xE7,
  0x12, 0x81, 0x16, 0xEB, 0x0A, 0x40, 0xBF, 0xE0, 0xB4, 0x06, 0xA0, 0x0E, 0xFA, 0x07, 0x50, 0xAA,
  0x83, 0x41, 0x6B, 0xDA, 0x82, 0xDB, 0x71, 0x70, 0x60, 0x87, 0x72,
  // "ù" (U+00F9)
  0x38, 0x33, 0x77, 0x76, 0x76, 0x01, 0x0E, 0xB0, 0x47, 0x60, 0x4B, 0x0D, 0x77, 0x05, 0xB0, 0x77,
  0x70, 0x6B, 0x02, 0x77, 0x07, 0xA0, 0xC7, 0x71, 0x05, 0xA0, 0x78, 0x0C, 0x60, 0xB0, 0x97, 0x30,
  0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA,
  0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C,
  0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0,
  0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xDA, 0x0C, 0xB0, 0x97,
  0x30, 0xEA, 0x0C, 0xB0, 0x97, 0x20, 0x2B, 0x0C, 0x0E, 0xA0, 0xB7, 0x20, 0x6B, 0x00, 0xCA, 0x0E,
  0x72, 0x0D, 0xB0, 0xC0, 0x9B, 0x08, 0x70, 0x8C, 0x0C, 0x03, 0xC0, 0x90, 0x23, 0x04, 0x0A, 0xA0,
  0xDA, 0x81, 0xC0, 0x9E, 0x0E, 0xC0, 0x90, 0x7A, 0x0C, 0x20, 0xAF, 0xA8, 0x19, 0x04, 0xA0, 0xC3,
  0x87, 0x39, 0xDE, 0xFE, 0xC8, 0x22, 0x02, 0xA0, 0xC0,
  // "ú" (U+00FA)
  0x74, 0x83, 0x37, 0x77, 0x67, 0x60, 0xDB, 0x07, 0x75, 0x07, 0xB0, 0xA7, 0x50, 0x2B, 0x0B, 0x76,
  0x0B, 0xA0, 0xC7, 0x60, 0x6A, 0x0C, 0x01, 0x75, 0x01, 0xA0, 0xB8, 0x0C, 0x70, 0xB0, 0x97, 0x30,
  0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA,
  0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C,
  0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0,
  0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xDA, 0x0C, 0xB0, 0x97,
  0x30, 0xEA, 0x0C, 0xB0, 0x97, 0x20, 0x2B, 0x0C, 0x0E, 0xA0, 0xB7, 0x20, 0x6B, 0x00, 0xCA, 0x0E,
  0x72, 0x0D, 0xB0, 0xC0, 0x9B, 0x08, 0x70, 0x8C, 0x0C, 0x03, 0xC0, 0x90, 0x23, 0x04, 0x0A, 0xA0,
  0xDA, 0x81, 0xC0, 0x9E, 0x0E, 0xC0, 0x90, 0x7A, 0x0C, 0x20, 0xAF, 0xA8, 0x19, 0x04, 0xA0, 0xC3,
  0x87, 0x39, 0xDE, 0xFE, 0xC8, 0x22, 0x02, 0xA0, 0xC0,
  // "û" (U+00FB)
  0x78, 0x00, 0x77, 0x60, 0x7C, 0x06, 0x74, 0x04, 0xD0, 0xE0, 0x27, 0x20, 0x20, 0xEA, 0x08, 0x0A,
  0xA0, 0xD0, 0x17, 0x01, 0x0D, 0xA0, 0x72, 0x0A, 0xA0, 0xC7, 0x0B, 0xA0, 0x74, 0x09, 0xA0, 0xB5,
  0x82, 0x9F, 0xE5, 0x60, 0x6A, 0x09, 0x80, 0xC2, 0x0B, 0x09, 0x73, 0x0C, 0xA0, 0xCB, 0x09, 0x73,
  0x0C, 0xA0, 0xCB, 0x09, 0x73, 0x0C, 0xA0, 0xCB, 0x09, 0x73, 0x0C, 0xA0, 0xCB, 0x09, 0x73, 0x0C,
  0xA0, 0xCB, 0x09, 0x73, 0x0C, 0xA0, 0xCB, 0x09, 0x73, 0x0C, 0xA0, 0xCB, 0x09, 0x73, 0x0C, 0xA0,
  0xCB, 0x09, 0x73, 0x0C, 0xA0, 0xCB, 0x09, 0x73, 0x0C, 0xA0, 0xCB, 0x09, 0x73, 0x0C, 0xA0, 0xCB,
  0x09, 0x73, 0x0C, 0xA0, 0xCB, 0x09, 0x73, 0x0D, 0xA0, 0xCB, 0x09, 0x73, 0x0E, 0xA0, 0xCB, 0x09,
  0x72, 0x02, 0xB0, 0xC0, 0xEA, 0x0B, 0x72, 0x06, 0xB0, 0x0C, 0xA0, 0xE7, 0x20, 0xDB, 0x0C, 0x09,
  0xB0, 0x87, 0x08, 0xC0, 0xC0, 0x3C, 0x09, 0x02, 0x30, 0x40, 0xAA, 0x0D, 0xA8, 0x1C, 0x09, 0xE0,
  0xEC, 0x09, 0x07, 0xA0, 0xC2, 0x0A, 0xFA, 0x81, 0x90, 0x4A, 0x0C, 0x38, 0x73, 0x9D, 0xEF, 0xEC,
  0x82, 0x20, 0x2A, 0x0C,
  // "ü" (U+00FC)
  0x28, 0x21, 0xBE, 0xA6, 0x82, 0xAE, 0xC2, 0x40, 0x8B, 0x07, 0x40, 0x6B, 0x09, 0x40, 0xAB, 0x09,
  0x40, 0x8B, 0x0B, 0x40, 0x8B, 0x06, 0x40, 0x5B, 0x09, 0x48, 0x21, 0xBE, 0xA6, 0x82, 0x9E, 0xB1,
  0x80, 0xE4, 0x0B, 0x09, 0x73, 0x0C, 0xA0, 0xCB, 0x09, 0x73, 0x0C, 0xA0, 0xCB, 0x09, 0x73, 0x0C,
  0xA0, 0xCB, 0x09, 0x73, 0x0C, 0xA0, 0xCB, 0x09, 0x73, 0x0C, 0xA0, 0xCB, 0x09, 0x73, 0x0C, 0xA0,
  0xCB, 0x09, 0x73, 0x0C, 0xA0, 0xCB, 0x09, 0x73, 0x0C, 0xA0, 0xCB, 0x09, 0x73, 0x0C, 0xA0, 0xCB,
  0x09, 0x73, 0x0C, 0xA0, 0xCB, 0x09, 0x73, 0x0C, 0xA0, 0xCB, 0x09, 0x73, 0x0C, 0xA0, 0xCB, 0x09,
  0x73, 0x0D, 0xA0, 0xCB, 0x09, 0x73, 0x0E, 0xA0, 0xCB, 0x09, 0x72, 0x02, 0xB0, 0xC0, 0xEA, 0x0B,
  0x72, 0x06, 0xB0, 0x0C, 0xA0, 0xE7, 0x20, 0xDB, 0x0C, 0x09, 0xB0, 0x87, 0x08, 0xC0, 0xC0, 0x3C,
  0x09, 0x02, 0x30, 0x40, 0xAA, 0x0D, 0xA8, 0x1C, 0x09, 0xE0, 0xEC, 0x09, 0x07, 0xA0, 0xC2, 0x0A,
  0xFA, 0x81, 0x90, 0x4A, 0x0C, 0x38, 0x73, 0x9D, 0xEF, 0xEC, 0x82, 0x20, 0x2A, 0x0C,
  // "ý" (U+00FD)
  0x75, 0x83, 0x37, 0x77, 0x67, 0x71, 0x0D, 0xB0, 0x77, 0x70, 0x7B, 0x0A, 0x77, 0x02, 0xB0, 0xB7,
  0x71, 0x0B, 0xA0, 0xC7, 0x71, 0x06, 0xA0, 0xC0, 0x17, 0x70, 0x1A, 0x0B, 0x80, 0xD4, 0x00, 0xEA,
  0x07, 0x75, 0x0A, 0xA0, 0xE0, 0x9A, 0x0D, 0x75, 0x0E, 0xA0, 0x90, 0x2B, 0x04, 0x73, 0x05, 0xB8,
  0x13, 0x0C, 0xA0, 0xA7, 0x30, 0xAA, 0x0D, 0x20, 0x5B, 0x01, 0x72, 0x0E, 0xA0, 0x83, 0x0E, 0xA0,
  0x77, 0x10, 0x4B, 0x02, 0x30, 0x8A, 0x0D, 0x71, 0x09, 0xA0, 0xC4, 0x02, 0xB0, 0x47, 0x0E, 0xA0,
  0x65, 0x0B, 0xA0, 0xA6, 0x04, 0xB0, 0x15, 0x05, 0xB0, 0x15, 0x09, 0xA0, 0xB7, 0x0E, 0xA0, 0x75,
  0x0E, 0xA0, 0x57, 0x08, 0xA0, 0xD4, 0x04, 0xA0, 0xE7, 0x10, 0x2B, 0x04, 0x30, 0x9A, 0x09, 0x72,
  0x0B, 0xA0, 0xA3, 0x0E, 0xA0, 0x47, 0x20, 0x5B, 0x20, 0x3A, 0x0D, 0x74, 0x0D, 0xA8, 0x15, 0x08,
  0xA0, 0x87, 0x40, 0x7A, 0x81, 0xA0, 0xDA, 0x02, 0x74, 0x01, 0xA0, 0xE0, 0x2A, 0x0C, 0x76, 0x0A,
  0xA0, 0xBA, 0x06, 0x76, 0x04, 0xD0, 0x17, 0x70, 0xDB, 0x0B, 0x77, 0x10, 0x7B, 0x05, 0x77, 0x10,
  0x5A, 0x0E, 0x77, 0x20, 0xBA, 0x09, 0x77, 0x10, 0x1B, 0x04, 0x77, 0x10, 0x7A, 0x0D, 0x77, 0x20,
  0xEA, 0x07, 0x77, 0x10, 0x9A, 0x0E, 0x01, 0x76, 0x02, 0x0A, 0xB0, 0x87, 0x38, 0x16, 0xFE, 0xD0,
  0xC7, 0x40, 0x6E, 0x0C, 0x01, 0x74, 0x85, 0x5D, 0xEF, 0xDB, 0x57, 0x60,
  // "þ" (U+00FE)
  0x0C, 0xA0, 0xB7, 0x71, 0x0C, 0xA0, 0xB7, 0x71, 0x0C, 0xA0, 0xB7, 0x71, 0x0C, 0xA0, 0xB7, 0x71,
  0x0C, 0xA0, 0xB7, 0x71, 0x0C, 0xA0, 0xB7, 0x71, 0x0C, 0xA0, 0xB7, 0x71, 0x0C, 0xA0, 0xB7, 0x71,
  0x0C, 0xA0, 0xB7, 0x71, 0x0C, 0xA0, 0xB2, 0x86, 0x29, 0xCE, 0xED, 0xA5, 0x50, 0xCA, 0x81, 0xB0,
  0x7F, 0x90, 0xC0, 0x23, 0x0C, 0xA0, 0xA0, 0x8C, 0x0E, 0xD0, 0xE0, 0x32, 0x0C, 0xA0, 0xDA, 0x09,
  0x03, 0x30, 0x40, 0xBB, 0x0D, 0x20, 0xCC, 0x06, 0x70, 0x9B, 0x81, 0x80, 0xCB, 0x0B, 0x72, 0x0D,
  0xA8, 0x1E, 0x0C, 0xB0, 0x47, 0x20, 0x7B, 0x04, 0x0C, 0xB7, 0x30, 0x3B, 0x07, 0x0C, 0xA0, 0xD7,
  0x4B, 0x09, 0x0C, 0xA0, 0xC7, 0x40, 0xEA, 0x0B, 0x0C, 0xA0, 0xB7, 0x40, 0xDA, 0x0B, 0x0C, 0xA0,
  0xC7, 0x40, 0xEA, 0x0B, 0x0C, 0xA0, 0xC7, 0x40, 0xEA, 0x0A, 0x0C, 0xA0, 0xE7, 0x30, 0x1B, 0x09,
  0x0C, 0xB0, 0x17, 0x20, 0x3B, 0x06, 0x0C, 0xB0, 0x67, 0x20, 0x8B, 0x03, 0x0C, 0xB0, 0xC7, 0x20,
  0xEA, 0x81, 0xD0, 0xCC, 0x07, 0x70, 0x9B, 0x81, 0x70, 0xCA, 0x0E, 0xA0, 0x90, 0x33, 0x04, 0x0B,
  0xB0, 0xD2, 0x0C, 0xA0, 0x80, 0x9C, 0x0E, 0xD0, 0xE0, 0x22, 0x0C, 0xA8, 0x19, 0x07, 0xF9, 0x0C,
  0x02, 0x30, 0xCA, 0x0B, 0x28, 0x62, 0x8C, 0xEF, 0xDA, 0x55, 0x0C, 0xA0, 0xB7, 0x71, 0x0C, 0xA0,
  0xB7, 0x71, 0x0C, 0xA0, 0xB7, 0x71, 0x0C, 0xA0, 0xB7, 0x71, 0x0C, 0xA0, 0xB7, 0x71, 0x0C, 0xA0,
  0xB7, 0x71, 0x0C, 0xA0, 0xB7, 0x71, 0x0C, 0xA0, 0xB7, 0x71, 0x0C, 0xA0, 0xB7, 0x71, 0x0C, 0xA0,
  0xB7, 0x71,
  // "ÿ" (U+00FF)
  0x38, 0x21, 0xBE, 0xA6, 0x82, 0xAE, 0xC2, 0x60, 0x8B, 0x07, 0x40, 0x6B, 0x09, 0x60, 0xAB, 0x09,
  0x40, 0x8B, 0x0B, 0x60, 0x8B, 0x06, 0x40, 0x5B, 0x09, 0x68, 0x21, 0xBE, 0xA6, 0x82, 0x9E, 0xB1,
  0x80, 0xF3, 0x00, 0xEA, 0x07, 0x75, 0x0A, 0xA0, 0xE0, 0x9A, 0x0D, 0x75, 0x0E, 0xA0, 0x90, 0x2B,
  0x04, 0x73, 0x05, 0xB8, 0x13, 0x0C, 0xA0, 0xA7, 0x30, 0xAA, 0x0D, 0x20, 0x5B, 0x01, 0x72, 0x0E,
  0xA0, 0x83, 0x0E, 0xA0, 0x77, 0x10, 0x4B, 0x02, 0x30, 0x8A, 0x0D, 0x71, 0x09, 0xA0, 0xC4, 0x02,
  0xB0, 0x47, 0x0E, 0xA0, 0x65, 0x0B, 0xA0, 0xA6, 0x04, 0xB0, 0x15, 0x05, 0xB0, 0x15, 0x09, 0xA0,
  0xB7, 0x0E, 0xA0, 0x75, 0x0E, 0xA0, 0x57, 0x08, 0xA0, 0xD4, 0x04, 0xA0, 0xE7, 0x10, 0x2B, 0x04,
  0x30, 0x9A, 0x09, 0x72, 0x0B, 0xA0, 0xA3, 0x0E, 0xA0, 0x47, 0x20, 0x5B, 0x20, 0x3A, 0x0D, 0x74,
  0x0D, 0xA8, 0x15, 0x08, 0xA0, 0x87, 0x40, 0x7A, 0x81, 0xA0, 0xDA, 0x02, 0x74, 0x01, 0xA0, 0xE0,
  0x2A, 0x0C, 0x76, 0x0A, 0xA0, 0xBA, 0x06, 0x76, 0x04, 0xD0, 0x17, 0x70, 0xDB, 0x0B, 0x77, 0x10,
  0x7B, 0x05, 0x77, 0x10, 0x5A, 0x0E, 0x77, 0x20, 0xBA, 0x09, 0x77, 0x10, 0x1B, 0x04, 0x77, 0x10,
  0x7A, 0x0D, 0x77, 0x20, 0xEA, 0x07, 0x77, 0x10, 0x9A, 0x0E, 0x01, 0x76, 0x02, 0x0A, 0xB0, 0x87,
  0x38, 0x16, 0xFE, 0xD0, 0xC7, 0x40, 0x6E, 0x0C, 0x01, 0x74, 0x85, 0x5D, 0xEF, 0xDB, 0x57, 0x60,
  // "Ā" (U+0100)
  0x60, 0xD8, 0x06, 0xE0, 0xD7, 0x50, 0xEF, 0xB0, 0xE7, 0x50, 0xEF, 0xB0, 0xE8, 0x09, 0xA3, 0x00,
  0x1C, 0x77, 0x50, 0x6C, 0x05, 0x77, 0x40, 0xBC, 0x0A, 0x77, 0x30, 0x1D, 0x0E, 0x77, 0x30, 0x5A,
  0x0D, 0x0E, 0xA0, 0x57, 0x72, 0x0A, 0xA0, 0x90, 0xAA, 0x09, 0x77, 0x20, 0xEA, 0x05, 0x06, 0xA0,
  0xE7, 0x71, 0x05, 0xB0, 0x10, 0x2B, 0x04, 0x77, 0x0A, 0xA0, 0xC2, 0x0D, 0xA0, 0x97, 0x70, 0xEA,
  0x07, 0x20, 0x8A, 0x0E, 0x76, 0x04, 0xB0, 0x22, 0x03, 0xB0, 0x37, 0x50, 0x9A, 0x0D, 0x40, 0xEA,
  0x08, 0x75, 0x0E, 0xA0, 0x84, 0x09, 0xA0, 0xD7, 0x40, 0x3B, 0x03, 0x40, 0x4B, 0x03, 0x73, 0x08,
  0xA0, 0xE6, 0x0E, 0xA0, 0x87, 0x30, 0xDA, 0x09, 0x60, 0xAA, 0x0D, 0x72, 0x03, 0xB0, 0x56, 0x05,
  0xB0, 0x27, 0x10, 0x8B, 0x80, 0x4E, 0xB0, 0x77, 0x10, 0xDF, 0xF0, 0xC7, 0x02, 0xFF, 0xA0, 0x26,
  0x07, 0xA0, 0xE7, 0x20, 0x1B, 0x07, 0x60, 0xCA, 0x0A, 0x73, 0x0B, 0xA0, 0xC5, 0x01, 0xB0, 0x67,
  0x30, 0x7B, 0x01, 0x40, 0x6B, 0x01, 0x73, 0x02, 0xB0, 0x64, 0x0B, 0xA0, 0xC7, 0x50, 0xDA, 0x0B,
  0x30, 0x1B, 0x07, 0x75, 0x08, 0xB0, 0x12, 0x06, 0xB0, 0x27, 0x50, 0x3B, 0x06, 0x20, 0xBA, 0x0D,
  0x77, 0x0E, 0xA8, 0x1B, 0x01, 0xB0, 0x97, 0x70, 0x9B, 0x01,
  // "ā" (U+0101)
  0x40, 0xD8, 0x06, 0xE0, 0xD7, 0x0E, 0xFB, 0x0E, 0x70, 0xEF, 0xB0, 0xE8, 0x0F, 0x50, 0x82, 0x59,
  0xCE, 0xA8, 0x2E, 0xB8, 0x26, 0x02, 0x09, 0xFC, 0x09, 0x50, 0x6E, 0x0E, 0xE0, 0xC5, 0x83, 0xDE,
  0x95, 0x23, 0x81, 0x15, 0xCB, 0x07, 0x40, 0x27, 0x30, 0xAA, 0x0E, 0x77, 0x10, 0x2B, 0x03, 0x77,
  0x10, 0xEA, 0x05, 0x77, 0x10, 0xDA, 0x06, 0x58, 0x33, 0x7A, 0xCD, 0x80, 0x1E, 0xB0, 0x63, 0x03,
  0x0C, 0xFE, 0x06, 0x20, 0x5F, 0xF9, 0x81, 0x60, 0x2C, 0x82, 0xC6, 0x31, 0x50, 0xDA, 0x81, 0x60,
  0xAB, 0x07, 0x72, 0x0D, 0xA8, 0x16, 0x0E, 0xA0, 0xA7, 0x30, 0xEA, 0x06, 0x01, 0xB0, 0x47, 0x20,
  0x1B, 0x06, 0x02, 0xB0, 0x37, 0x20, 0x6B, 0x06, 0x01, 0xB0, 0x57, 0x10, 0x10, 0xDB, 0x81, 0x60,
  0xEA, 0x0B, 0x70, 0x10, 0xCC, 0x81, 0x60, 0x9B, 0x0B, 0x04, 0x38, 0x43, 0x8E, 0xFE, 0xEA, 0x82,
  0x60, 0x1E, 0xD0, 0xEC, 0x81, 0xE2, 0xCA, 0x06, 0x20, 0x20, 0xDF, 0x98, 0x2B, 0x20, 0xAA, 0x06,
  0x48, 0x65, 0xBD, 0xFE, 0xD9, 0x43, 0x08, 0xA0, 0x60,
  // "Ă" (U+0102)
  0x58, 0x21, 0x77, 0x16, 0x82, 0x17, 0x71, 0x73, 0x01, 0xA0, 0x86, 0x08, 0xA0, 0x17, 0x40, 0xCA,
  0x08, 0x02, 0x20, 0x20, 0x8A, 0x0C, 0x75, 0x04, 0xFB, 0x04, 0x76, 0x06, 0xF9, 0x06, 0x77, 0x18,
  0x63, 0x9D, 0xFE, 0xD9, 0x28, 0x0F, 0x50, 0x01, 0xC7, 0x75, 0x06, 0xC0, 0x57, 0x74, 0x0B, 0xC0,
  0xA7, 0x73, 0x01, 0xD0, 0xE7, 0x73, 0x05, 0xA0, 0xD0, 0xEA, 0x05, 0x77, 0x20, 0xAA, 0x09, 0x0A,
  0xA0, 0x97, 0x72, 0x0E, 0xA0, 0x50, 0x6A, 0x0E, 0x77, 0x10, 0x5B, 0x01, 0x02, 0xB0, 0x47, 0x70,
  0xAA, 0x0C, 0x20, 0xDA, 0x09, 0x77, 0x0E, 0xA0, 0x72, 0x08, 0xA0, 0xE7, 0x60, 0x4B, 0x02, 0x20,
  0x3B, 0x03, 0x75, 0x09, 0xA0, 0xD4, 0x0E, 0xA0, 0x87, 0x50, 0xEA, 0x08, 0x40, 0x9A, 0x0D, 0x74,
  0x03, 0xB0, 0x34, 0x04, 0xB0, 0x37, 0x30, 0x8A, 0x0E, 0x60, 0xEA, 0x08, 0x73, 0x0D, 0xA0, 0x96,
  0x0A, 0xA0, 0xD7, 0x20, 0x3B, 0x05, 0x60, 0x5B, 0x02, 0x71, 0x08, 0xB8, 0x04, 0xEB, 0x07, 0x71,
  0x0D, 0xFF, 0x0C, 0x70, 0x2F, 0xFA, 0x02, 0x60, 0x7A, 0x0E, 0x72, 0x01, 0xB0, 0x76, 0x0C, 0xA0,
  0xA7, 0x30, 0xBA, 0x0C, 0x50, 0x1B, 0x06, 0x73, 0x07, 0xB0, 0x14, 0x06, 0xB0, 0x17, 0x30, 0x2B,
  0x06, 0x40, 0xBA, 0x0C, 0x75, 0x0D, 0xA0, 0xB3, 0x01, 0xB0, 0x77, 0x50, 0x8B, 0x01, 0x20, 0x6B,
  0x02, 0x75, 0x03, 0xB0, 0x62, 0x0B, 0xA0, 0xD7, 0x70, 0xEA, 0x81, 0xB0, 0x1B, 0x09, 0x77, 0x09,
  0xB0, 0x10,
  // "ă" (U+0103)
  0x38, 0x21, 0x77, 0x16, 0x82, 0x17, 0x71, 0x50, 0x1A, 0x08, 0x60, 0x8A, 0x01, 0x60, 0xCA, 0x08,
  0x02, 0x20, 0x20, 0x8A, 0x0C, 0x70, 0x4F, 0xB0, 0x47, 0x10, 0x6F, 0x90, 0x67, 0x38, 0x63, 0x9D,
  0xFE, 0xD9, 0x28, 0x0D, 0x40, 0x82, 0x59, 0xCE, 0xA8, 0x2E, 0xB8, 0x26, 0x02, 0x09, 0xFC, 0x09,
  0x50, 0x6E, 0x0E, 0xE0, 0xC5, 0x83, 0xDE, 0x95, 0x23, 0x81, 0x15, 0xCB, 0x07, 0x40, 0x27, 0x30,
  0xAA, 0x0E, 0x77, 0x10, 0x2B, 0x03, 0x77, 0x10, 0xEA, 0x05, 0x77, 0x10, 0xDA, 0x06, 0x58, 0x33,
  0x7A, 0xCD, 0x80, 0x1E, 0xB0, 0x63, 0x03, 0x0C, 0xFE, 0x06, 0x20, 0x5F, 0xF9, 0x81, 0x60, 0x2C,
  0x82, 0xC6, 0x31, 0x50, 0xDA, 0x81, 0x60, 0xAB, 0x07, 0x72, 0x0D, 0xA8, 0x16, 0x0E, 0xA0, 0xA7,
  0x30, 0xEA, 0x06, 0x01, 0xB0, 0x47, 0x20, 0x1B, 0x06, 0x02, 0xB0, 0x37, 0x20, 0x6B, 0x06, 0x01,
  0xB0, 0x57, 0x10, 0x10, 0xDB, 0x81, 0x60, 0xEA, 0x0B, 0x70, 0x10, 0xCC, 0x81, 0x60, 0x9B, 0x0B,
  0x04, 0x38, 0x43, 0x8E, 0xFE, 0xEA, 0x82, 0x60, 0x1E, 0xD0, 0xEC, 0x81, 0xE2, 0xCA, 0x06, 0x20,
  0x20, 0xDF, 0x98, 0x2B, 0x20, 0xAA, 0x06, 0x48, 0x65, 0xBD, 0xFE, 0xD9, 0x43, 0x08, 0xA0, 0x60,
  // "Ą" (U+0104)
  0x72, 0x01, 0xC7, 0x76, 0x06, 0xC0, 0x57, 0x75, 0x0B, 0xC0, 0xA7, 0x74, 0x01, 0xD0, 0xE7, 0x74,
  0x05, 0xA0, 0xD0, 0xEA, 0x05, 0x77, 0x30, 0xAA, 0x09, 0x0A, 0xA0, 0x97, 0x73, 0x0E, 0xA0, 0x50,
  0x6A, 0x0E, 0x77, 0x20, 0x5B, 0x01, 0x02, 0xB0, 0x47, 0x71, 0x0A, 0xA0, 0xC2, 0x0D, 0xA0, 0x97,
  0x71, 0x0E, 0xA0, 0x72, 0x08, 0xA0, 0xE7, 0x70, 0x4B, 0x02, 0x20, 0x3B, 0x03, 0x76, 0x09, 0xA0,
  0xD4, 0x0E, 0xA0, 0x87, 0x60, 0xEA, 0x08, 0x40, 0x9A, 0x0D, 0x75, 0x03, 0xB0, 0x34, 0x04, 0xB0,
  0x37, 0x40, 0x8A, 0x0E, 0x60, 0xEA, 0x08, 0x74, 0x0D, 0xA0, 0x96, 0x0A, 0xA0, 0xD7, 0x30, 0x3B,
  0x05, 0x60, 0x5B, 0x02, 0x72, 0x08, 0xB8, 0x04, 0xEB, 0x07, 0x72, 0x0D, 0xFF, 0x0C, 0x71, 0x02,
  0xFF, 0xA0, 0x27, 0x07, 0xA0, 0xE7, 0x20, 0x1B, 0x07, 0x70, 0xCA, 0x0A, 0x73, 0x0B, 0xA0, 0xC6,
  0x01, 0xB0, 0x67, 0x30, 0x7B, 0x01, 0x50, 0x6B, 0x01, 0x73, 0x02, 0xB0, 0x65, 0x0B, 0xA0, 0xC7,
  0x50, 0xDA, 0x0B, 0x40, 0x1B, 0x07, 0x75, 0x08, 0xB0, 0x13, 0x06, 0xB0, 0x27, 0x50, 0x3B, 0x06,
  0x30, 0xBA, 0x0D, 0x77, 0x0E, 0xA0, 0xB2, 0x01, 0xB0, 0x97, 0x70, 0x9B, 0x02, 0x77, 0x68, 0x22,
  0xEF, 0x97, 0x77, 0x81, 0xCF, 0xB7, 0x77, 0x07, 0xA0, 0x27, 0x77, 0x81, 0xDF, 0xC7, 0x77, 0x01,
  0xA0, 0xB7, 0x77, 0x01, 0xB0, 0x47, 0x77, 0x0E, 0xD0, 0x67, 0x74, 0x06, 0xD0, 0x67, 0x75, 0x84,
  0x6C, 0xFE, 0xC4,
  // "ą" (U+0105)
  0x58, 0x25, 0x9C, 0xEA, 0x82, 0xEB, 0x82, 0x70, 0x20, 0x9F, 0xC0, 0x96, 0x06, 0xE0, 0xEE, 0x0C,
  0x68, 0x3D, 0xE9, 0x52, 0x38, 0x11, 0x5C, 0xB0, 0x75, 0x02, 0x73, 0x0A, 0xA0, 0xE7, 0x72, 0x02,
  0xB0, 0x37, 0x72, 0x0E, 0xA0, 0x57, 0x72, 0x0D, 0xA0, 0x66, 0x83, 0x37, 0xAC, 0xD8, 0x01, 0xEB,
  0x06, 0x40, 0x30, 0xCF, 0xE0, 0x63, 0x05, 0xFF, 0x90, 0x62, 0x02, 0xC8, 0x2C, 0x63, 0x15, 0x0D,
  0xA0, 0x62, 0x0A, 0xB0, 0x77, 0x20, 0xDA, 0x06, 0x20, 0xEA, 0x0A, 0x73, 0x0E, 0xA8, 0x16, 0x01,
  0xB0, 0x47, 0x20, 0x1B, 0x81, 0x60, 0x2B, 0x03, 0x72, 0x06, 0xB8, 0x16, 0x01, 0xB0, 0x57, 0x10,
  0x10, 0xDB, 0x06, 0x20, 0xEA, 0x0B, 0x70, 0x10, 0xCC, 0x06, 0x20, 0x9B, 0x0B, 0x04, 0x38, 0x43,
  0x8E, 0xFE, 0xEA, 0x06, 0x20, 0x10, 0xED, 0x0E, 0xC8, 0x1E, 0x2C, 0xA0, 0x63, 0x02, 0x0D, 0xF9,
  0x82, 0xB2, 0x0A, 0xA0, 0x65, 0x86, 0x5B, 0xDF, 0xED, 0x94, 0x30, 0xAA, 0x08, 0x77, 0x18, 0x22,
  0xEF, 0x97, 0x72, 0x81, 0xCF, 0xB7, 0x72, 0x07, 0xA0, 0x27, 0x72, 0x81, 0xDF, 0xC7, 0x72, 0x01,
  0xA0, 0xB7, 0x72, 0x01, 0xB0, 0x47, 0x72, 0x0E, 0xD0, 0x67, 0x60, 0x6D, 0x06, 0x77, 0x84, 0x6C,
  0xFE, 0xC4,
  // "Ć" (U+0106)
  0x77, 0x83, 0x37, 0x77, 0x67, 0x71, 0x0D, 0xB0, 0x77, 0x70, 0x7B, 0x0A, 0x77, 0x02, 0xB0, 0xB7,
  0x71, 0x0B, 0xA0, 0xC7, 0x71, 0x06, 0xA0, 0xC0, 0x17, 0x70, 0x1A, 0x0B, 0x80, 0xE2, 0x08, 0x91,
  0x59, 0xCE, 0xFE, 0xEC, 0x95, 0x17, 0x06, 0x0E, 0xFC, 0x09, 0x50, 0xBF, 0xE0, 0x84, 0x0C, 0xC8,
  0x19, 0x31, 0x28, 0x41, 0x48, 0xDF, 0x13, 0x09, 0xB0, 0xC0, 0x27, 0x20, 0x33, 0x04, 0xB0, 0xC0,
  0x17, 0x70, 0xCB, 0x02, 0x77, 0x03, 0xB0, 0x97, 0x71, 0x08, 0xB0, 0x37, 0x71, 0x0C, 0xA0, 0xD7,
  0x72, 0xB0, 0xA7, 0x71, 0x02, 0xB0, 0x87, 0x71, 0x04, 0xB0, 0x67, 0x71, 0x05, 0xB0, 0x57, 0x71,
  0x05, 0xB0, 0x57, 0x71, 0x05, 0xB0, 0x57, 0x71, 0x04, 0xB0, 0x67, 0x71, 0x02, 0xB0, 0x77, 0x72,
  0xB0, 0xA7, 0x72, 0x0D, 0xA0, 0xD7, 0x72, 0x09, 0xB0, 0x27, 0x71, 0x04, 0xB0, 0x77, 0x72, 0x0D,
  0xA0, 0xE0, 0x17, 0x71, 0x06, 0xB0, 0xA7, 0x72, 0x0C, 0xB0, 0x97, 0x71, 0x01, 0x0D, 0xB8, 0x1D,
  0x72, 0x38, 0x31, 0x36, 0xBB, 0x50, 0x20, 0xDE, 0x0E, 0xD0, 0xB7, 0x08, 0xFC, 0x0B, 0x71, 0x89,
  0x21, 0x6A, 0xDE, 0xFE, 0xDC, 0x95, 0x11,
  // "ć" (U+0107)
  0x75, 0x83, 0x37, 0x77, 0x67, 0x60, 0xDB, 0x07, 0x75, 0x07, 0xB0, 0xA7, 0x50, 0x2B, 0x0B, 0x76,
  0x0B, 0xA0, 0xC7, 0x60, 0x6A, 0x0C, 0x01, 0x75, 0x01, 0xA0, 0xB8, 0x0D, 0x40, 0x82, 0x49, 0xCE,
  0xA8, 0x2E, 0xB8, 0x46, 0x05, 0x0D, 0xFB, 0x0D, 0x01, 0x30, 0x9F, 0xD0, 0xC3, 0x07, 0xC8, 0x19,
  0x41, 0x28, 0x31, 0x49, 0xF7, 0x20, 0x2B, 0x0E, 0x04, 0x71, 0x02, 0x01, 0x20, 0xAB, 0x05, 0x76,
  0x0E, 0xA0, 0xD7, 0x60, 0x3B, 0x07, 0x76, 0x06, 0xB0, 0x47, 0x60, 0x8B, 0x02, 0x76, 0x08, 0xB0,
  0x17, 0x60, 0x8B, 0x01, 0x76, 0x07, 0xB0, 0x27, 0x60, 0x6B, 0x04, 0x76, 0x04, 0xB0, 0x77, 0x60,
  0x1B, 0x0C, 0x77, 0x0B, 0xB0, 0x47, 0x60, 0x4B, 0x0E, 0x03, 0x76, 0x0A, 0xC0, 0x90, 0x34, 0x82,
  0x26, 0xAE, 0x40, 0xBF, 0xD0, 0xE5, 0x07, 0x0E, 0xFB, 0x0E, 0x78, 0x91, 0x6A, 0xDE, 0xFE, 0xDB,
  0x95, 0x11,
  // "Ĉ" (U+0108)
  0x73, 0x80, 0x07, 0x77, 0x10, 0x7C, 0x06, 0x76, 0x04, 0xD0, 0xE0, 0x27, 0x40, 0x20, 0xEA, 0x08,
  0x0A, 0xA0, 0xD0, 0x17, 0x20, 0x10, 0xDA, 0x07, 0x20, 0xAA, 0x0C, 0x72, 0x0B, 0xA0, 0x74, 0x09,
  0xA0, 0xB7, 0x82, 0x9F, 0xE5, 0x60, 0x6A, 0x09, 0x80, 0xD5, 0x08, 0x91, 0x59, 0xCE, 0xFE, 0xEC,
  0x95, 0x17, 0x06, 0x0E, 0xFC, 0x09, 0x50, 0xBF, 0xE0, 0x84, 0x0C, 0xC8, 0x19, 0x31, 0x28, 0x41,
  0x48, 0xDF, 0x13, 0x09, 0xB0, 0xC0, 0x27, 0x20, 0x33, 0x04, 0xB0, 0xC0, 0x17, 0x70, 0xCB, 0x02,
  0x77, 0x03, 0xB0, 0x97, 0x71, 0x08, 0xB0, 0x37, 0x71, 0x0C, 0xA0, 0xD7, 0x72, 0xB0, 0xA7, 0x71,
  0x02, 0xB0, 0x87, 0x71, 0x04, 0xB0, 0x67, 0x71, 0x05, 0xB0, 0x57, 0x71, 0x05, 0xB0, 0x57, 0x71,
  0x05, 0xB0, 0x57, 0x71, 0x04, 0xB0, 0x67, 0x71, 0x02, 0xB0, 0x77, 0x72, 0xB0, 0xA7, 0x72, 0x0D,
  0xA0, 0xD7, 0x72, 0x09, 0xB0, 0x27, 0x71, 0x04, 0xB0, 0x77, 0x72, 0x0D, 0xA0, 0xE0, 0x17, 0x71,
  0x06, 0xB0, 0xA7, 0x72, 0x0C, 0xB0, 0x97, 0x71, 0x01, 0x0D, 0xB8, 0x1D, 0x72, 0x38, 0x31, 0x36,
  0xBB, 0x50, 0x20, 0xDE, 0x0E, 0xD0, 0xB7, 0x08, 0xFC, 0x0B, 0x71, 0x89, 0x21, 0x6A, 0xDE, 0xFE,
  0xDC, 0x95, 0x11,
  // "ĉ" (U+0109)
  0x71, 0x80, 0x07, 0x76, 0x07, 0xC0, 0x67, 0x40, 0x4D, 0x0E, 0x02, 0x72, 0x02, 0x0E, 0xA0, 0x80,
  0xAA, 0x0D, 0x01, 0x70, 0x10, 0xDA, 0x07, 0x20, 0xAA, 0x0C, 0x70, 0xBA, 0x07, 0x40, 0x9A, 0x0B,
  0x58, 0x29, 0xFE, 0x56, 0x06, 0xA0, 0x98, 0x0C, 0x70, 0x82, 0x49, 0xCE, 0xA8, 0x2E, 0xB8, 0x46,
  0x05, 0x0D, 0xFB, 0x0D, 0x01, 0x30, 0x9F, 0xD0, 0xC3, 0x07, 0xC8, 0x19, 0x41, 0x28, 0x31, 0x49,
  0xF7, 0x20, 0x2B, 0x0E, 0x04, 0x71, 0x02, 0x01, 0x20, 0xAB, 0x05, 0x76, 0x0E, 0xA0, 0xD7, 0x60,
  0x3B, 0x07, 0x76, 0x06, 0xB0, 0x47, 0x60, 0x8B, 0x02, 0x76, 0x08, 0xB0, 0x17, 0x60, 0x8B, 0x01,
  0x76, 0x07, 0xB0, 0x27, 0x60, 0x6B, 0x04, 0x76, 0x04, 0xB0, 0x77, 0x60, 0x1B, 0x0C, 0x77, 0x0B,
  0xB0, 0x47, 0x60, 0x4B, 0x0E, 0x03, 0x76, 0x0A, 0xC0, 0x90, 0x34, 0x82, 0x26, 0xAE, 0x40, 0xBF,
  0xD0, 0xE5, 0x07, 0x0E, 0xFB, 0x0E, 0x78, 0x91, 0x6A, 0xDE, 0xFE, 0xDB, 0x95, 0x11,
  // "Ċ" (U+010A)
  0x73, 0x82, 0x8E, 0xE8, 0x77, 0x10, 0x4C, 0x04, 0x77, 0x07, 0xC0, 0x77, 0x70, 0x4C, 0x04, 0x77,
  0x18, 0x28, 0xEE, 0x88, 0x09, 0x86, 0x08, 0x91, 0x59, 0xCE, 0xFE, 0xEC, 0x95, 0x17, 0x06, 0x0E,
  0xFC, 0x09, 0x50, 0xBF, 0xE0, 0x84, 0x0C, 0xC8, 0x19, 0x31, 0x28, 0x41, 0x48, 0xDF, 0x13, 0x09,
  0xB0, 0xC0, 0x27, 0x20, 0x33, 0x04, 0xB0, 0xC0, 0x17, 0x70, 0xCB, 0x02, 0x77, 0x03, 0xB0, 0x97,
  0x71, 0x08, 0xB0, 0x37, 0x71, 0x0C, 0xA0, 0xD7, 0x72, 0xB0, 0xA7, 0x71, 0x02, 0xB0, 0x87, 0x71,
  0x04, 0xB0, 0x67, 0x71, 0x05, 0xB0, 0x57, 0x71, 0x05, 0xB0, 0x57, 0x71, 0x05, 0xB0, 0x57, 0x71,
  0x04, 0xB0, 0x67, 0x71, 0x02, 0xB0, 0x77, 0x72, 0xB0, 0xA7, 0x72, 0x0D, 0xA0, 0xD7, 0x72, 0x09,
  0xB0, 0x27, 0x71, 0x04, 0xB0, 0x77, 0x72, 0x0D, 0xA0, 0xE0, 0x17, 0x71, 0x06, 0xB0, 0xA7, 0x72,
  0x0C, 0xB0, 0x97, 0x71, 0x01, 0x0D, 0xB8, 0x1D, 0x72, 0x38, 0x31, 0x36, 0xBB, 0x50, 0x20, 0xDE,
  0x0E, 0xD0, 0xB7, 0x08, 0xFC, 0x0B, 0x71, 0x89, 0x21, 0x6A, 0xDE, 0xFE, 0xDC, 0x95, 0x11,
  // "ċ" (U+010B)
  0x71, 0x82, 0x8E, 0xE8, 0x76, 0x04, 0xC0, 0x47, 0x50, 0x7C, 0x07, 0x75, 0x04, 0xC0, 0x47, 0x68,
  0x28, 0xEE, 0x88, 0x0F, 0x60, 0x82, 0x49, 0xCE, 0xA8, 0x2E, 0xB8, 0x46, 0x05, 0x0D, 0xFB, 0x0D,
  0x01, 0x30, 0x9F, 0xD0, 0xC3, 0x07, 0xC8, 0x19, 0x41, 0x28, 0x31, 0x49, 0xF7, 0x20, 0x2B, 0x0E,
  0x04, 0x71, 0x02, 0x01, 0x20, 0xAB, 0x05, 0x76, 0x0E, 0xA0, 0xD7, 0x60, 0x3B, 0x07, 0x76, 0x06,
  0xB0, 0x47, 0x60, 0x8B, 0x02, 0x76, 0x08, 0xB0, 0x17, 0x60, 0x8B, 0x01, 0x76, 0x07, 0xB0, 0x27,
  0x60, 0x6B, 0x04, 0x76, 0x04, 0xB0, 0x77, 0x60, 0x1B, 0x0C, 0x77, 0x0B, 0xB0, 0x47, 0x60, 0x4B,
  0x0E, 0x03, 0x76, 0x0A, 0xC0, 0x90, 0x34, 0x82, 0x26, 0xAE, 0x40, 0xBF, 0xD0, 0xE5, 0x07, 0x0E,
  0xFB, 0x0E, 0x78, 0x91, 0x6A, 0xDE, 0xFE, 0xDB, 0x95, 0x11,
  // "Č" (U+010C)
  0x58, 0x15, 0x77, 0x71, 0x81, 0x77, 0x56, 0x05, 0xA0, 0xC0, 0x24, 0x02, 0x0D, 0xA0, 0x57, 0x07,
  0xA0, 0xE0, 0x32, 0x04, 0x0E, 0xA0, 0x67, 0x20, 0x8A, 0x81, 0xE3, 0x4B, 0x07, 0x74, 0x0A, 0xA0,
  0xEB, 0x09, 0x76, 0x0C, 0xC0, 0xB7, 0x70, 0x2B, 0x0E, 0x01, 0x80, 0xE1, 0x08, 0x91, 0x59, 0xCE,
  0xFE, 0xEC, 0x95, 0x17, 0x06, 0x0E, 0xFC, 0x09, 0x50, 0xBF, 0xE0, 0x84, 0x0C, 0xC8, 0x19, 0x31,
  0x28, 0x41, 0x48, 0xDF, 0x13, 0x09, 0xB0, 0xC0, 0x27, 0x20, 0x33, 0x04, 0xB0, 0xC0, 0x17, 0x70,
  0xCB, 0x02, 0x77, 0x03, 0xB0, 0x97, 0x71, 0x08, 0xB0, 0x37, 0x71, 0x0C, 0xA0, 0xD7, 0x72, 0xB0,
  0xA7, 0x71, 0x02, 0xB0, 0x87, 0x71, 0x04, 0xB0, 0x67, 0x71, 0x05, 0xB0, 0x57, 0x71, 0x05, 0xB0,
  0x57, 0x71, 0x05, 0xB0, 0x57, 0x71, 0x04, 0xB0, 0x67, 0x71, 0x02, 0xB0, 0x77, 0x72, 0xB0, 0xA7,
  0x72, 0x0D, 0xA0, 0xD7, 0x72, 0x09, 0xB0, 0x27, 0x71, 0x04, 0xB0, 0x77, 0x72, 0x0D, 0xA0, 0xE0,
  0x17, 0x71, 0x06, 0xB0, 0xA7, 0x72, 0x0C, 0xB0, 0x97, 0x71, 0x01, 0x0D, 0xB8, 0x1D, 0x72, 0x38,
  0x31, 0x36, 0xBB, 0x50, 0x20, 0xDE, 0x0E, 0xD0, 0xB7, 0x08, 0xFC, 0x0B, 0x71, 0x89, 0x21, 0x6A,
  0xDE, 0xFE, 0xDC, 0x95, 0x11,
  // "č" (U+010D)
  0x38, 0x15, 0x77, 0x71, 0x81, 0x77, 0x54, 0x05, 0xA0, 0xC0, 0x24, 0x02, 0x0D, 0xA0, 0x55, 0x07,
  0xA0, 0xE0, 0x32, 0x04, 0x0E, 0xA0, 0x67, 0x08, 0xA8, 0x1E, 0x34, 0xB0, 0x77, 0x20, 0xAA, 0x0E,
  0xB0, 0x97, 0x40, 0xCC, 0x0B, 0x75, 0x02, 0xB0, 0xE0, 0x18, 0x0D, 0x30, 0x82, 0x49, 0xCE, 0xA8,
  0x2E, 0xB8, 0x46, 0x05, 0x0D, 0xFB, 0x0D, 0x01, 0x30, 0x9F, 0xD0, 0xC3, 0x07, 0xC8, 0x19, 0x41,
  0x28, 0x31, 0x49, 0xF7, 0x20, 0x2B, 0x0E, 0x04, 0x71, 0x02, 0x01, 0x20, 0xAB, 0x05, 0x76, 0x0E,
  0xA0, 0xD7, 0x60, 0x3B, 0x07, 0x76, 0x06, 0xB0, 0x47, 0x60, 0x8B, 0x02, 0x76, 0x08, 0xB0, 0x17,
  0x60, 0x8B, 0x01, 0x76, 0x07, 0xB0, 0x27, 0x60, 0x6B, 0x04, 0x76, 0x04, 0xB0, 0x77, 0x60, 0x1B,
  0x0C, 0x77, 0x0B, 0xB0, 0x47, 0x60, 0x4B, 0x0E, 0x03, 0x76, 0x0A, 0xC0, 0x90, 0x34, 0x82, 0x26,
  0xAE, 0x40, 0xBF, 0xD0, 0xE5, 0x07, 0x0E, 0xFB, 0x0E, 0x78, 0x91, 0x6A, 0xDE, 0xFE, 0xDB, 0x95,
  0x11,
  // "Ď" (U+010E)
  0x28, 0x15, 0x77, 0x71, 0x81, 0x77, 0x57, 0x05, 0xA0, 0xC0, 0x24, 0x02, 0x0D, 0xA0, 0x57, 0x10,
  0x7A, 0x0E, 0x03, 0x20, 0x40, 0xEA, 0x06, 0x73, 0x08, 0xA8, 0x1E, 0x34, 0xB0, 0x77, 0x50, 0xAA,
  0x0E, 0xB0, 0x97, 0x70, 0xCC, 0x0B, 0x77, 0x10, 0x2B, 0x0E, 0x01, 0x80, 0xD7, 0x00, 0x3F, 0x83,
  0xED, 0xB7, 0x37, 0x10, 0x3F, 0xD0, 0xB0, 0x36, 0x03, 0xB8, 0x00, 0xEF, 0x08, 0x50, 0x3B, 0x06,
  0x48, 0x12, 0x6C, 0xC0, 0x94, 0x03, 0xB0, 0x67, 0x06, 0xC0, 0x73, 0x03, 0xB0, 0x67, 0x10, 0x30,
  0xEB, 0x02, 0x20, 0x3B, 0x06, 0x72, 0x06, 0xB0, 0xA2, 0x03, 0xB0, 0x67, 0x30, 0xCB, 0x81, 0x10,
  0x3B, 0x06, 0x73, 0x06, 0xB8, 0x16, 0x03, 0xB0, 0x67, 0x4B, 0x81, 0xA0, 0x3B, 0x06, 0x74, 0x0D,
  0xA8, 0x1D, 0x03, 0xB0, 0x67, 0x40, 0xAB, 0x10, 0x3B, 0x06, 0x74, 0x09, 0xB0, 0x10, 0x3B, 0x06,
  0x74, 0x08, 0xB0, 0x20, 0x3B, 0x06, 0x74, 0x07, 0xB0, 0x20, 0x3B, 0x06, 0x74, 0x08, 0xB0, 0x10,
  0x3B, 0x06, 0x74, 0x09, 0xB1, 0x03, 0xB0, 0x67, 0x40, 0xBB, 0x10, 0x3B, 0x06, 0x74, 0x0E, 0xA8,
  0x1C, 0x03, 0xB0, 0x67, 0x30, 0x2B, 0x81, 0x90, 0x3B, 0x06, 0x73, 0x07, 0xB8, 0x15, 0x03, 0xB0,
  0x67, 0x30, 0xDA, 0x0E, 0x20, 0x3B, 0x06, 0x72, 0x08, 0xB0, 0x82, 0x03, 0xB0, 0x67, 0x10, 0x5B,
  0x0E, 0x01, 0x20, 0x3B, 0x06, 0x70, 0x7C, 0x04, 0x30, 0x3B, 0x06, 0x38, 0x21, 0x48, 0xEC, 0x06,
  0x40, 0x3B, 0x0F, 0xEF, 0x0E, 0x04, 0x50, 0x3F, 0xD0, 0x80, 0x16, 0x03, 0xE8, 0x4E, 0xDC, 0x95,
  0x17, 0x10,
  // "ď" (U+010F)
  0x77, 0x05, 0xB0, 0x32, 0x0D, 0xA0, 0x97, 0x70, 0x5B, 0x03, 0x2B, 0x03, 0x77, 0x05, 0xB8, 0x13,
  0x04, 0xA0, 0xC7, 0x71, 0x05, 0xB8, 0x13, 0x07, 0xA0, 0x47, 0x71, 0x05, 0xB8, 0x33, 0x0C, 0xFB,
  0x77, 0x20, 0x5B, 0x03, 0x01, 0xA0, 0x27, 0x72, 0x05, 0xB0, 0x37, 0x76, 0x05, 0xB0, 0x37, 0x76,
  0x05, 0xB0, 0x37, 0x48, 0x90, 0x49, 0xDE, 0xFD, 0x92, 0x05, 0xB0, 0x37, 0x20, 0x10, 0xBF, 0x81,
  0xE4, 0x4B, 0x03, 0x72, 0x0C, 0xD0, 0xEB, 0x0E, 0x05, 0xB0, 0x37, 0x10, 0x8B, 0x81, 0xE7, 0x12,
  0x82, 0x5D, 0xFE, 0xB0, 0x37, 0x01, 0xC0, 0x35, 0x01, 0x0E, 0xC0, 0x37, 0x06, 0xB0, 0x87, 0x06,
  0xC0, 0x37, 0x0B, 0xB0, 0x27, 0x10, 0xEB, 0x03, 0x70, 0xEA, 0x0D, 0x72, 0x0B, 0xB0, 0x36, 0x01,
  0xB0, 0xA7, 0x20, 0x8B, 0x03, 0x60, 0x2B, 0x08, 0x72, 0x06, 0xB0, 0x36, 0x02, 0xB0, 0x77, 0x20,
  0x6B, 0x03, 0x60, 0x2B, 0x07, 0x72, 0x05, 0xB0, 0x36, 0x01, 0xB0, 0x87, 0x20, 0x6B, 0x03, 0x7B,
  0x09, 0x72, 0x07, 0xB0, 0x37, 0x0E, 0xA0, 0xC7, 0x20, 0x9B, 0x03, 0x70, 0xBB, 0x72, 0x0D, 0xB0,
  0x37, 0x06, 0xB0, 0x67, 0x04, 0xC0, 0x37, 0x01, 0xB0, 0xE0, 0x15, 0x01, 0x0D, 0xC0, 0x37, 0x10,
  0x8B, 0x0D, 0x05, 0x38, 0x25, 0xDF, 0xEB, 0x03, 0x72, 0x0B, 0xD0, 0xEB, 0x0E, 0x03, 0xB0, 0x37,
  0x30, 0xAF, 0x82, 0xD3, 0x0E, 0xA0, 0x37, 0x48, 0x64, 0xAD, 0xFE, 0xC7, 0x12, 0x0C, 0xA0, 0x36,
  // "Đ" (U+0110)
  0x30, 0xCF, 0x82, 0xEC, 0x95, 0x74, 0x0C, 0xFC, 0x0E, 0x07, 0x72, 0x0C, 0xB0, 0xFE, 0xF0, 0xC0,
  0x27, 0x0C, 0xA0, 0xC4, 0x81, 0x15, 0xAC, 0x0D, 0x02, 0x60, 0xCA, 0x0C, 0x70, 0x20, 0xCB, 0x0C,
  0x60, 0xCA, 0x0C, 0x72, 0x0B, 0xB0, 0x85, 0x0C, 0xA0, 0xC7, 0x20, 0x10, 0xEB, 0x01, 0x40, 0xCA,
  0x0C, 0x73, 0x06, 0xB0, 0x74, 0x0C, 0xA0, 0xC7, 0x40, 0xEA, 0x0C, 0x40, 0xCA, 0x0C, 0x74, 0x0A,
  0xB0, 0x13, 0x0C, 0xA0, 0xC7, 0x40, 0x7B, 0x04, 0x30, 0xCA, 0x0C, 0x74, 0x04, 0xB0, 0x63, 0x0C,
  0xA0, 0xC7, 0x40, 0x2B, 0x08, 0x0F, 0xEC, 0x80, 0x0E, 0x0A, 0x60, 0x1B, 0x08, 0xFC, 0x0A, 0x60,
  0x1B, 0x08, 0xFC, 0x0A, 0x60, 0x2B, 0x07, 0x30, 0xCA, 0x0C, 0x74, 0x03, 0xB0, 0x63, 0x0C, 0xA0,
  0xC7, 0x40, 0x5B, 0x05, 0x30, 0xCA, 0x0C, 0x74, 0x07, 0xB0, 0x23, 0x0C, 0xA0, 0xC7, 0x40, 0xBA,
  0x0E, 0x40, 0xCA, 0x0C, 0x73, 0x01, 0xB0, 0xB4, 0x0C, 0xA0, 0xC7, 0x30, 0x8B, 0x05, 0x40, 0xCA,
  0x0C, 0x72, 0x02, 0xB0, 0xD5, 0x0C, 0xA0, 0xC7, 0x10, 0x10, 0xDB, 0x06, 0x50, 0xCA, 0x0C, 0x70,
  0x40, 0xDB, 0x0A, 0x60, 0xCA, 0x0C, 0x48, 0x12, 0x6B, 0xC0, 0xB7, 0x0C, 0xB0, 0x0E, 0xF9, 0x09,
  0x71, 0x0C, 0xFC, 0x0B, 0x03, 0x72, 0x0C, 0xE8, 0x3E, 0xCA, 0x62, 0x71,
  // "đ" (U+0111)
  0x77, 0x10, 0xBA, 0x0C, 0x77, 0x40, 0xBA, 0x0C, 0x77, 0x40, 0xBA, 0x0C, 0x74, 0x0C, 0x80, 0x2E,
  0xC0, 0xFE, 0x71, 0x0D, 0xFE, 0x71, 0x0D, 0xFE, 0x77, 0x10, 0xBA, 0x0C, 0x77, 0x40, 0xBA, 0x0C,
  0x77, 0x40, 0xBA, 0x0C, 0x71, 0x86, 0x59, 0xDE, 0xFD, 0xA4, 0x20, 0xBA, 0x0C, 0x60, 0x30, 0xCF,
  0x98, 0x1A, 0x0A, 0xA0, 0xC5, 0x03, 0x0E, 0xFB, 0x0B, 0x09, 0xA0, 0xC4, 0x01, 0x0E, 0xB8, 0x1D,
  0x51, 0x20, 0x30, 0xAA, 0x0E, 0xA0, 0xC4, 0x08, 0xB0, 0xC7, 0x09, 0xC0, 0xC4, 0x0E, 0xB0, 0x27,
  0x10, 0xDB, 0x0C, 0x30, 0x4B, 0x09, 0x72, 0x07, 0xB0, 0xC3, 0x07, 0xB0, 0x47, 0x20, 0x2B, 0x0C,
  0x30, 0xAB, 0x01, 0x73, 0x0E, 0xA0, 0xC3, 0x0B, 0xA0, 0xE7, 0x40, 0xDA, 0x0C, 0x30, 0xCA, 0x0E,
  0x74, 0x0C, 0xA0, 0xC3, 0x0B, 0xA0, 0xD7, 0x40, 0xBA, 0x0C, 0x30, 0xBA, 0x0E, 0x74, 0x0C, 0xA0,
  0xC3, 0x09, 0xB7, 0x40, 0xDA, 0x0C, 0x30, 0x7B, 0x03, 0x73, 0xB0, 0xC3, 0x03, 0xB0, 0x87, 0x20,
  0x5B, 0x0C, 0x40, 0xEA, 0x0E, 0x72, 0x0C, 0xB0, 0xC4, 0x08, 0xB0, 0xA7, 0x07, 0xC0, 0xC5, 0x0D,
  0xB0, 0xC0, 0x43, 0x03, 0x0A, 0xA0, 0xEA, 0x0C, 0x50, 0x30, 0xED, 0x0E, 0xC0, 0xA0, 0x7A, 0x0C,
  0x60, 0x20, 0xCF, 0x98, 0x19, 0x05, 0xA0, 0xC7, 0x18, 0x65, 0xAD, 0xEE, 0xD9, 0x32, 0x03, 0xA0,
  0xC3,
  // "Ē" (U+0112)
  0x30, 0xD8, 0x06, 0xE0, 0xD6, 0x0E, 0xFB, 0x0E, 0x60, 0xEF, 0xB0, 0xE8, 0x0E, 0x50, 0x03, 0xFF,
  0xA0, 0x90, 0x3F, 0xFA, 0x09, 0x03, 0xB8, 0x09, 0x1E, 0x08, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06,
  0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03,
  0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3F, 0xF9, 0x81, 0xD0, 0x3F, 0xF9,
  0x81, 0xD0, 0x3B, 0x80, 0x90, 0xE8, 0x1C, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0,
  0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60,
  0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x80,
  0x91, 0xE0, 0x80, 0x3F, 0xFA, 0x09, 0x03, 0xFF, 0xA0, 0x90,
  // "ē" (U+0113)
  0x40, 0xD8, 0x06, 0xE0, 0xD7, 0x10, 0xEF, 0xB0, 0xE7, 0x10, 0xEF, 0xB0, 0xE8, 0x09, 0x82, 0x08,
  0x74, 0x9C, 0xEF, 0xEC, 0x83, 0x72, 0x02, 0x0C, 0xFA, 0x0A, 0x70, 0x5E, 0x0E, 0xD0, 0xC0, 0x14,
  0x04, 0xC0, 0xA0, 0x33, 0x03, 0x0B, 0xB0, 0xA4, 0x0D, 0xB0, 0x57, 0x09, 0xB0, 0x52, 0x07, 0xB0,
  0x77, 0x20, 0xDA, 0x0B, 0x20, 0xDA, 0x0D, 0x73, 0x07, 0xB0, 0x10, 0x2B, 0x07, 0x73, 0x02, 0xB0,
  0x05, 0xB0, 0x37, 0x4B, 0x00, 0x7F, 0xFC, 0x00, 0x8F, 0xFC, 0x09, 0x08, 0xB8, 0x09, 0x3E, 0x08,
  0x07, 0xB0, 0x17, 0x71, 0x06, 0xB0, 0x37, 0x71, 0x02, 0xB0, 0x67, 0x72, 0x0E, 0xA0, 0xB7, 0x72,
  0x07, 0xB0, 0x57, 0x72, 0x0E, 0xB0, 0x57, 0x30, 0x20, 0x43, 0x03, 0xC8, 0x1B, 0x62, 0x38, 0x41,
  0x37, 0xBF, 0x94, 0x04, 0x0E, 0xE0, 0xEE, 0x09, 0x50, 0x10, 0xAF, 0xC0, 0xE0, 0x67, 0x89, 0x12,
  0x7A, 0xDE, 0xFE, 0xDB, 0x84, 0x30,
  // "Ĕ" (U+0114)
  0x28, 0x21, 0x77, 0x16, 0x82, 0x17, 0x71, 0x40, 0x1A, 0x08, 0x60, 0x8A, 0x01, 0x50, 0xCA, 0x08,
  0x02, 0x20, 0x20, 0x8A, 0x0C, 0x60, 0x4F, 0xB0, 0x47, 0x06, 0xF9, 0x06, 0x72, 0x86, 0x39, 0xDF,
  0xED, 0x92, 0x80, 0xC5, 0x00, 0x3F, 0xFA, 0x09, 0x03, 0xFF, 0xA0, 0x90, 0x3B, 0x80, 0x91, 0xE0,
  0x80, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B,
  0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76,
  0x03, 0xFF, 0x98, 0x1D, 0x03, 0xFF, 0x98, 0x1D, 0x03, 0xB8, 0x09, 0x0E, 0x81, 0xC0, 0x3B, 0x06,
  0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03,
  0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67,
  0x60, 0x3B, 0x06, 0x76, 0x03, 0xB8, 0x09, 0x1E, 0x08, 0x03, 0xFF, 0xA0, 0x90, 0x3F, 0xFA, 0x09,
  // "ĕ" (U+0115)
  0x38, 0x21, 0x77, 0x16, 0x82, 0x17, 0x71, 0x60, 0x1A, 0x08, 0x60, 0x8A, 0x01, 0x70, 0xCA, 0x08,
  0x02, 0x20, 0x20, 0x8A, 0x0C, 0x71, 0x04, 0xFB, 0x04, 0x72, 0x06, 0xF9, 0x06, 0x74, 0x86, 0x39,
  0xDF, 0xED, 0x92, 0x80, 0xE0, 0x08, 0x74, 0x9C, 0xEF, 0xEC, 0x83, 0x72, 0x02, 0x0C, 0xFA, 0x0A,
  0x70, 0x5E, 0x0E, 0xD0, 0xC0, 0x14, 0x04, 0xC0, 0xA0, 0x33, 0x03, 0x0B, 0xB0, 0xA4, 0x0D, 0xB0,
  0x57, 0x09, 0xB0, 0x52, 0x07, 0xB0, 0x77, 0x20, 0xDA, 0x0B, 0x20, 0xDA, 0x0D, 0x73, 0x07, 0xB0,
  0x10, 0x2B, 0x07, 0x73, 0x02, 0xB0, 0x05, 0xB0, 0x37, 0x4B, 0x00, 0x7F, 0xFC, 0x00, 0x8F, 0xFC,
  0x09, 0x08, 0xB8, 0x09, 0x3E, 0x08, 0x07, 0xB0, 0x17, 0x71, 0x06, 0xB0, 0x37, 0x71, 0x02, 0xB0,
  0x67, 0x72, 0x0E, 0xA0, 0xB7, 0x72, 0x07, 0xB0, 0x57, 0x72, 0x0E, 0xB0, 0x57, 0x30, 0x20, 0x43,
  0x03, 0xC8, 0x1B, 0x62, 0x38, 0x41, 0x37, 0xBF, 0x94, 0x04, 0x0E, 0xE0, 0xEE, 0x09, 0x50, 0x10,
  0xAF, 0xC0, 0xE0, 0x67, 0x89, 0x12, 0x7A, 0xDE, 0xFE, 0xDB, 0x84, 0x30,
  // "Ė" (U+0116)
  0x78, 0x28, 0xEE, 0x87, 0x60, 0x4C, 0x04, 0x75, 0x07, 0xC0, 0x77, 0x50, 0x4C, 0x04, 0x76, 0x82,
  0x8E, 0xE8, 0x80, 0xF1, 0x00, 0x3F, 0xFA, 0x09, 0x03, 0xFF, 0xA0, 0x90, 0x3B, 0x80, 0x91, 0xE0,
  0x80, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B,
  0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76,
  0x03, 0xFF, 0x98, 0x1D, 0x03, 0xFF, 0x98, 0x1D, 0x03, 0xB8, 0x09, 0x0E, 0x81, 0xC0, 0x3B, 0x06,
  0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03,
  0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67,
  0x60, 0x3B, 0x06, 0x76, 0x03, 0xB8, 0x09, 0x1E, 0x08, 0x03, 0xFF, 0xA0, 0x90, 0x3F, 0xFA, 0x09,
  // "ė" (U+0117)
  0x71, 0x82, 0x8E, 0xE8, 0x77, 0x10, 0x4C, 0x04, 0x77, 0x07, 0xC0, 0x77, 0x70, 0x4C, 0x04, 0x77,
  0x18, 0x28, 0xEE, 0x88, 0x09, 0x86, 0x08, 0x74, 0x9C, 0xEF, 0xEC, 0x83, 0x72, 0x02, 0x0C, 0xFA,
  0x0A, 0x70, 0x5E, 0x0E, 0xD0, 0xC0, 0x14, 0x04, 0xC0, 0xA0, 0x33, 0x03, 0x0B, 0xB0, 0xA4, 0x0D,
  0xB0, 0x57, 0x09, 0xB0, 0x52, 0x07, 0xB0, 0x77, 0x20, 0xDA, 0x0B, 0x20, 0xDA, 0x0D, 0x73, 0x07,
  0xB0, 0x10, 0x2B, 0x07, 0x73, 0x02, 0xB0, 0x05, 0xB0, 0x37, 0x4B, 0x00, 0x7F, 0xFC, 0x00, 0x8F,
  0xFC, 0x09, 0x08, 0xB8, 0x09, 0x3E, 0x08, 0x07, 0xB0, 0x17, 0x71, 0x06, 0xB0, 0x37, 0x71, 0x02,
  0xB0, 0x67, 0x72, 0x0E, 0xA0, 0xB7, 0x72, 0x07, 0xB0, 0x57, 0x72, 0x0E, 0xB0, 0x57, 0x30, 0x20,
  0x43, 0x03, 0xC8, 0x1B, 0x62, 0x38, 0x41, 0x37, 0xBF, 0x94, 0x04, 0x0E, 0xE0, 0xEE, 0x09, 0x50,
  0x10, 0xAF, 0xC0, 0xE0, 0x67, 0x89, 0x12, 0x7A, 0xDE, 0xFE, 0xDB, 0x84, 0x30,
  // "Ę" (U+0118)
  0x03, 0xFF, 0xA0, 0x90, 0x3F, 0xFA, 0x09, 0x03, 0xB8, 0x09, 0x1E, 0x08, 0x03, 0xB0, 0x67, 0x60,
  0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06,
  0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3F, 0xF9, 0x81, 0xD0,
  0x3F, 0xF9, 0x81, 0xD0, 0x3B, 0x80, 0x90, 0xE8, 0x1C, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76,
  0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0,
  0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60,
  0x3B, 0x80, 0x91, 0xE0, 0x80, 0x3F, 0xFA, 0x09, 0x03, 0xFF, 0xA0, 0x97, 0x48, 0x22, 0xEF, 0x97,
  0x78, 0x1C, 0xFB, 0x77, 0x07, 0xA0, 0x27, 0x78, 0x1D, 0xFC, 0x77, 0x01, 0xA0, 0xB7, 0x70, 0x1B,
  0x04, 0x77, 0x0E, 0xD0, 0x67, 0x40, 0x6D, 0x06, 0x75, 0x84, 0x6C, 0xFE, 0xC4, 0x10,
  // "ę" (U+0119)
  0x68, 0x74, 0x9C, 0xEF, 0xEC, 0x83, 0x72, 0x02, 0x0C, 0xFA, 0x0A, 0x70, 0x5E, 0x0E, 0xD0, 0xC0,
  0x14, 0x04, 0xC0, 0xA0, 0x33, 0x03, 0x0B, 0xB0, 0xA4, 0x0D, 0xB0, 0x57, 0x09, 0xB0, 0x52, 0x07,
  0xB0, 0x77, 0x20, 0xDA, 0x0B, 0x20, 0xDA, 0x0D, 0x73, 0x07, 0xB0, 0x10, 0x2B, 0x07, 0x73, 0x02,
  0xB0, 0x05, 0xB0, 0x37, 0x4B, 0x00, 0x7F, 0xFC, 0x00, 0x8F, 0xFC, 0x09, 0x08, 0xB8, 0x09, 0x3E,
  0x08, 0x07, 0xB0, 0x17, 0x71, 0x06, 0xB0, 0x37, 0x71, 0x02, 0xB0, 0x67, 0x72, 0x0E, 0xA0, 0xB7,
  0x72, 0x07, 0xB0, 0x57, 0x72, 0x0E, 0xB0, 0x57, 0x30, 0x20, 0x43, 0x03, 0xC8, 0x1B, 0x62, 0x38,
  0x41, 0x37, 0xBF, 0x94, 0x04, 0x0E, 0xE0, 0xEE, 0x09, 0x50, 0x10, 0xAF, 0xD0, 0x77, 0x87, 0x27,
  0xAD, 0xEF, 0xED, 0xEA, 0x06, 0x77, 0x10, 0x6A, 0x05, 0x77, 0x10, 0x3A, 0x06, 0x77, 0x28, 0x1B,
  0xFD, 0x77, 0x20, 0x1A, 0x09, 0x77, 0x20, 0x4A, 0x09, 0x77, 0x20, 0x3A, 0x82, 0xE4, 0x01, 0x77,
  0x0E, 0xD0, 0x47, 0x60, 0x6D, 0x04, 0x77, 0x84, 0x5B, 0xED, 0xB2, 0x10,
  // "Ě" (U+011A)
  0x28, 0x15, 0x77, 0x71, 0x81, 0x77, 0x54, 0x05, 0xA0, 0xC0, 0x24, 0x02, 0x0D, 0xA0, 0x55, 0x07,
  0xA0, 0xE0, 0x32, 0x04, 0x0E, 0xA0, 0x67, 0x08, 0xA8, 0x1E, 0x34, 0xB0, 0x77, 0x20, 0xAA, 0x0E,
  0xB0, 0x97, 0x40, 0xCC, 0x0B, 0x75, 0x02, 0xB0, 0xE0, 0x18, 0x0C, 0x60, 0x03, 0xFF, 0xA0, 0x90,
  0x3F, 0xFA, 0x09, 0x03, 0xB8, 0x09, 0x1E, 0x08, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03,
  0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67,
  0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3F, 0xF9, 0x81, 0xD0, 0x3F, 0xF9, 0x81, 0xD0,
  0x3B, 0x80, 0x90, 0xE8, 0x1C, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60,
  0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06,
  0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x06, 0x76, 0x03, 0xB0, 0x67, 0x60, 0x3B, 0x80, 0x91, 0xE0,
  0x80, 0x3F, 0xFA, 0x09, 0x03, 0xFF, 0xA0, 0x90,
  // "ě" (U+011B)
  0x38, 0x15, 0x77, 0x71, 0x81, 0x77, 0x56, 0x05, 0xA0, 0xC0, 0x24, 0x02, 0x0D, 0xA0, 0x57, 0x07,
  0xA0, 0xE0, 0x32, 0x04, 0x0E, 0xA0, 0x67, 0x20, 0x8A, 0x81, 0xE3, 0x4B, 0x07, 0x74, 0x0A, 0xA0,
  0xEB, 0x09, 0x76, 0x0C, 0xC0, 0xB7, 0x70, 0x2B, 0x0E, 0x01, 0x80, 0xE1, 0x08, 0x74, 0x9C, 0xEF,
  0xEC, 0x83, 0x72, 0x02, 0x0C, 0xFA, 0x0A, 0x70, 0x5E, 0x0E, 0xD0, 0xC0, 0x14, 0x04, 0xC0, 0xA0,
  0x33, 0x03, 0x0B, 0xB0, 0xA4, 0x0D, 0xB0, 0x57, 0x09, 0xB0, 0x52, 0x07, 0xB0, 0x77, 0x20, 0xDA,
  0x0B, 0x20, 0xDA, 0x0D, 0x73, 0x07, 0xB0, 0x10, 0x2B, 0x07, 0x73, 0x02, 0xB0, 0x05, 0xB0, 0x37,
  0x4B, 0x00, 0x7F, 0xFC, 0x00, 0x8F, 0xFC, 0x09, 0x08, 0xB8, 0x09, 0x3E, 0x08, 0x07, 0xB0, 0x17,
  0x71, 0x06, 0xB0, 0x37, 0x71, 0x02, 0xB0, 0x67, 0x72, 0x0E, 0xA0, 0xB7, 0x72, 0x07, 0xB0, 0x57,
  0x72, 0x0E, 0xB0, 0x57, 0x30, 0x20, 0x43, 0x03, 0xC8, 0x1B, 0x62, 0x38, 0x41, 0x37, 0xBF, 0x94,
  0x04, 0x0E, 0xE0, 0xEE, 0x09, 0x50, 0x10, 0xAF, 0xC0, 0xE0, 0x67, 0x89, 0x12, 0x7A, 0xDE, 0xFE,
  0xDB, 0x84, 0x30,
  // "Ĝ" (U+011C)
  0x73, 0x80, 0x07, 0x77, 0x20, 0x7C, 0x06, 0x77, 0x04, 0xD0, 0xE0, 0x27, 0x50, 0x20, 0xEA, 0x08,
  0x0A, 0xA0, 0xD0, 0x17, 0x30, 0x10, 0xDA, 0x07, 0x20, 0xAA, 0x0C, 0x73, 0x0B, 0xA0, 0x74, 0x09,
  0xA0, 0xB7, 0x18, 0x29, 0xFE, 0x56, 0x06, 0xA0, 0x98, 0x0E, 0x00, 0x89, 0x13, 0x8B, 0xDE, 0xFE,
  0xC9, 0x51, 0x71, 0x04, 0x0D, 0xFC, 0x08, 0x60, 0x9F, 0x0E, 0xD0, 0x75, 0x09, 0xC8, 0x1A, 0x51,
  0x38, 0x33, 0x7D, 0xE1, 0x40, 0x6B, 0x0D, 0x04, 0x72, 0x03, 0x40, 0x10, 0xEA, 0x0E, 0x02, 0x77,
  0x10, 0x9B, 0x05, 0x77, 0x20, 0xEA, 0x0C, 0x77, 0x20, 0x5B, 0x06, 0x77, 0x20, 0x9B, 0x01, 0x77,
  0x20, 0xCA, 0x0D, 0x77, 0x3B, 0x0B, 0x77, 0x20, 0x1B, 0x09, 0x77, 0x20, 0x1B, 0x08, 0x77, 0x20,
  0x2B, 0x07, 0x60, 0x78, 0x04, 0xE0, 0x02, 0xB0, 0x86, 0x07, 0xF9, 0x03, 0x01, 0xB0, 0x96, 0x07,
  0xF9, 0x03, 0x1B, 0x0A, 0x74, 0x04, 0xB8, 0x13, 0x0E, 0xA0, 0xC7, 0x40, 0x4B, 0x81, 0x30, 0xBB,
  0x74, 0x04, 0xB8, 0x13, 0x08, 0xB0, 0x47, 0x30, 0x4B, 0x81, 0x30, 0x4B, 0x09, 0x73, 0x04, 0xB0,
  0x32, 0x0D, 0xB0, 0x27, 0x20, 0x4B, 0x03, 0x20, 0x6B, 0x0C, 0x72, 0x04, 0xB0, 0x33, 0x0C, 0xB0,
  0xB0, 0x17, 0x04, 0xB0, 0x33, 0x02, 0x0E, 0xB8, 0x1E, 0x73, 0x40, 0x30, 0x9B, 0x03, 0x40, 0x20,
  0xDE, 0x0E, 0xF0, 0x35, 0x01, 0x08, 0xFD, 0x0D, 0x02, 0x78, 0x92, 0x16, 0xAC, 0xEF, 0xEE, 0xCA,
  0x63, 0x20,
  // "ĝ" (U+011D)
  0x71, 0x80, 0x07, 0x77, 0x07, 0xC0, 0x67, 0x50, 0x4D, 0x0E, 0x02, 0x73, 0x02, 0x0E, 0xA0, 0x80,
  0xAA, 0x0D, 0x01, 0x71, 0x01, 0x0D, 0xA0, 0x72, 0x0A, 0xA0, 0xC7, 0x10, 0xBA, 0x07, 0x40, 0x9A,
  0x0B, 0x68, 0x29, 0xFE, 0x56, 0x06, 0xA0, 0x98, 0x0D, 0x10, 0x86, 0x49, 0xDE, 0xED, 0x94, 0x20,
  0x2A, 0x0C, 0x30, 0x10, 0xBF, 0x98, 0x19, 0x04, 0xA0, 0xC2, 0x01, 0x0D, 0xFB, 0x0A, 0x07, 0xA0,
  0xC2, 0x0C, 0xB8, 0x1C, 0x51, 0x20, 0x30, 0x9A, 0x0E, 0xA8, 0x1C, 0x06, 0xB0, 0xB7, 0x05, 0xC8,
  0x1C, 0x0C, 0xA0, 0xE0, 0x17, 0x10, 0x9B, 0x0C, 0x03, 0xB0, 0x87, 0x20, 0x1B, 0x0C, 0x06, 0xB0,
  0x47, 0x30, 0xCA, 0x0C, 0x09, 0xB0, 0x17, 0x30, 0x9A, 0x0C, 0x0A, 0xA0, 0xE7, 0x40, 0x7A, 0x0C,
  0x0B, 0xA0, 0xD7, 0x40, 0x7A, 0x00, 0xCA, 0x0D, 0x74, 0x06, 0xA0, 0xC0, 0xBA, 0x0E, 0x74, 0x07,
  0xA0, 0xC0, 0x9B, 0x01, 0x73, 0x08, 0xA0, 0xC0, 0x7B, 0x04, 0x73, 0x0A, 0xA0, 0xC0, 0x3B, 0x08,
  0x73, 0x0E, 0xA8, 0x1C, 0x0D, 0xA0, 0xE0, 0x17, 0x10, 0x6B, 0x81, 0xC0, 0x7B, 0x0B, 0x70, 0x30,
  0xEB, 0x0C, 0x20, 0xCB, 0x81, 0xD5, 0x12, 0x81, 0x28, 0xEC, 0x0C, 0x20, 0x20, 0xEF, 0xB0, 0xE0,
  0x9A, 0x0C, 0x30, 0x20, 0xBF, 0x98, 0x1E, 0x38, 0xA0, 0xC5, 0x89, 0x14, 0x9D, 0xEF, 0xDB, 0x71,
  0x08, 0xA0, 0xC7, 0x71, 0x08, 0xA0, 0xC7, 0x71, 0x09, 0xA0, 0xB7, 0x71, 0x0C, 0xA0, 0xA7, 0x70,
  0x1B, 0x07, 0x77, 0x08, 0xB8, 0x23, 0x07, 0x47, 0x30, 0x4B, 0x0C, 0x28, 0x4A, 0xFD, 0x95, 0x24,
  0x04, 0x09, 0xC0, 0x42, 0x0A, 0xE0, 0xEF, 0x07, 0x30, 0x60, 0xDF, 0xC0, 0xD0, 0x56, 0x83, 0x37,
  0xAC, 0xEA, 0x82, 0xEC, 0x95, 0x50,
  // "Ğ" (U+011E)
  0x58, 0x21, 0x77, 0x16, 0x82, 0x17, 0x71, 0x70, 0x1A, 0x08, 0x60, 0x8A, 0x01, 0x71, 0x0C, 0xA0,
  0x80, 0x22, 0x02, 0x08, 0xA0, 0xC7, 0x20, 0x4F, 0xB0, 0x47, 0x30, 0x6F, 0x90, 0x67, 0x58, 0x63,
  0x9D, 0xFE, 0xD9, 0x28, 0x0E, 0x30, 0x89, 0x13, 0x8B, 0xDE, 0xFE, 0xC9, 0x51, 0x71, 0x04, 0x0D,
  0xFC, 0x08, 0x60, 0x9F, 0x0E, 0xD0, 0x75, 0x09, 0xC8, 0x1A, 0x51, 0x38, 0x33, 0x7D, 0xE1, 0x40,
  0x6B, 0x0D, 0x04, 0x72, 0x03, 0x40, 0x10, 0xEA, 0x0E, 0x02, 0x77, 0x10, 0x9B, 0x05, 0x77, 0x20,
  0xEA, 0x0C, 0x77, 0x20, 0x5B, 0x06, 0x77, 0x20, 0x9B, 0x01, 0x77, 0x20, 0xCA, 0x0D, 0x77, 0x3B,
  0x0B, 0x77, 0x20, 0x1B, 0x09, 0x77, 0x20, 0x1B, 0x08, 0x77, 0x20, 0x2B, 0x07, 0x60, 0x78, 0x04,
  0xE0, 0x02, 0xB0, 0x86, 0x07, 0xF9, 0x03, 0x01, 0xB0, 0x96, 0x07, 0xF9, 0x03, 0x1B, 0x0A, 0x74,
  0x04, 0xB8, 0x13, 0x0E, 0xA0, 0xC7, 0x40, 0x4B, 0x81, 0x30, 0xBB, 0x74, 0x04, 0xB8, 0x13, 0x08,
  0xB0, 0x47, 0x30, 0x4B, 0x81, 0x30, 0x4B, 0x09, 0x73, 0x04, 0xB0, 0x32, 0x0D, 0xB0, 0x27, 0x20,
  0x4B, 0x03, 0x20, 0x6B, 0x0C, 0x72, 0x04, 0xB0, 0x33, 0x0C, 0xB0, 0xB0, 0x17, 0x04, 0xB0, 0x33,
  0x02, 0x0E, 0xB8, 0x1E, 0x73, 0x40, 0x30, 0x9B, 0x03, 0x40, 0x20, 0xDE, 0x0E, 0xF0, 0x35, 0x01,
  0x08, 0xFD, 0x0D, 0x02, 0x78, 0x92, 0x16, 0xAC, 0xEF, 0xEE, 0xCA, 0x63, 0x20,
  // "ğ" (U+011F)
  0x38, 0x21, 0x77, 0x16, 0x82, 0x17, 0x71, 0x50, 0x1A, 0x08, 0x60, 0x8A, 0x01, 0x60, 0xCA, 0x08,
  0x02, 0x20, 0x20, 0x8A, 0x0C, 0x70, 0x4F, 0xB0, 0x47, 0x10, 0x6F, 0x90, 0x67, 0x38, 0x63, 0x9D,
  0xFE, 0xD9, 0x28, 0x0D, 0x40, 0x86, 0x49, 0xDE, 0xED, 0x94, 0x20, 0x2A, 0x0C, 0x30, 0x10, 0xBF,
  0x98, 0x19, 0x04, 0xA0, 0xC2, 0x01, 0x0D, 0xFB, 0x0A, 0x07, 0xA0, 0xC2, 0x0C, 0xB8, 0x1C, 0x51,
  0x20, 0x30, 0x9A, 0x0E, 0xA8, 0x1C, 0x06, 0xB0, 0xB7, 0x05, 0xC8, 0x1C, 0x0C, 0xA0, 0xE0, 0x17,
  0x10, 0x9B, 0x0C, 0x03, 0xB0, 0x87, 0x20, 0x1B, 0x0C, 0x06, 0xB0, 0x47, 0x30, 0xCA, 0x0C, 0x09,
  0xB0, 0x17, 0x30, 0x9A, 0x0C, 0x0A, 0xA0, 0xE7, 0x40, 0x7A, 0x0C, 0x0B, 0xA0, 0xD7, 0x40, 0x7A,
  0x00, 0xCA, 0x0D, 0x74, 0x06, 0xA0, 0xC0, 0xBA, 0x0E, 0x74, 0x07, 0xA0, 0xC0, 0x9B, 0x01, 0x73,
  0x08, 0xA0, 0xC0, 0x7B, 0x04, 0x73, 0x0A, 0xA0, 0xC0, 0x3B, 0x08, 0x73, 0x0E, 0xA8, 0x1C, 0x0D,
  0xA0, 0xE0, 0x17, 0x10, 0x6B, 0x81, 0xC0, 0x7B, 0x0B, 0x70, 0x30, 0xEB, 0x0C, 0x20, 0xCB, 0x81,
  0xD5, 0x12, 0x81, 0x28, 0xEC, 0x0C, 0x20, 0x20, 0xEF, 0xB0, 0xE0, 0x9A, 0x0C, 0x30, 0x20, 0xBF,
  0x98, 0x1E, 0x38, 0xA0, 0xC5, 0x89, 0x14, 0x9D, 0xEF, 0xDB, 0x71, 0x08, 0xA0, 0xC7, 0x71, 0x08,
  0xA0, 0xC7, 0x71, 0x09, 0xA0, 0xB7, 0x71, 0x0C, 0xA0, 0xA7, 0x70, 0x1B, 0x07, 0x77, 0x08, 0xB8,
  0x23, 0x07, 0x47, 0x30, 0x4B, 0x0C, 0x28, 0x4A, 0xFD, 0x95, 0x24, 0x04, 0x09, 0xC0, 0x42, 0x0A,
  0xE0, 0xEF, 0x07, 0x30, 0x60, 0xDF, 0xC0, 0xD0, 0x56, 0x83, 0x37, 0xAC, 0xEA, 0x82, 0xEC, 0x95,
  0x50,
  // "Ġ" (U+0120)
  0x73, 0x82, 0x8E, 0xE8, 0x77, 0x20, 0x4C, 0x04, 0x77, 0x10, 0x7C, 0x07, 0x77, 0x10, 0x4C, 0x04,
  0x77, 0x28, 0x28, 0xEE, 0x88, 0x09, 0x92, 0x08, 0x91, 0x38, 0xBD, 0xEF, 0xEC, 0x95, 0x17, 0x10,
  0x40, 0xDF, 0xC0, 0x86, 0x09, 0xF0, 0xED, 0x07, 0x50, 0x9C, 0x81, 0xA5, 0x13, 0x83, 0x37, 0xDE,
  0x14, 0x06, 0xB0, 0xD0, 0x47, 0x20, 0x34, 0x01, 0x0E, 0xA0, 0xE0, 0x27, 0x71, 0x09, 0xB0, 0x57,
  0x72, 0x0E, 0xA0, 0xC7, 0x72, 0x05, 0xB0, 0x67, 0x72, 0x09, 0xB0, 0x17, 0x72, 0x0C, 0xA0, 0xD7,
  0x73, 0xB0, 0xB7, 0x72, 0x01, 0xB0, 0x97, 0x72, 0x01, 0xB0, 0x87, 0x72, 0x02, 0xB0, 0x76, 0x07,
  0x80, 0x4E, 0x00, 0x2B, 0x08, 0x60, 0x7F, 0x90, 0x30, 0x1B, 0x09, 0x60, 0x7F, 0x90, 0x31, 0xB0,
  0xA7, 0x40, 0x4B, 0x81, 0x30, 0xEA, 0x0C, 0x74, 0x04, 0xB8, 0x13, 0x0B, 0xB7, 0x40, 0x4B, 0x81,
  0x30, 0x8B, 0x04, 0x73, 0x04, 0xB8, 0x13, 0x04, 0xB0, 0x97, 0x30, 0x4B, 0x03, 0x20, 0xDB, 0x02,
  0x72, 0x04, 0xB0, 0x32, 0x06, 0xB0, 0xC7, 0x20, 0x4B, 0x03, 0x30, 0xCB, 0x0B, 0x01, 0x70, 0x4B,
  0x03, 0x30, 0x20, 0xEB, 0x81, 0xE7, 0x34, 0x03, 0x09, 0xB0, 0x34, 0x02, 0x0D, 0xE0, 0xEF, 0x03,
  0x50, 0x10, 0x8F, 0xD0, 0xD0, 0x27, 0x89, 0x21, 0x6A, 0xCE, 0xFE, 0xEC, 0xA6, 0x32,
  // "ġ" (U+0121)
  0x71, 0x82, 0x8E, 0xE8, 0x77, 0x04, 0xC0, 0x47, 0x60, 0x7C, 0x07, 0x76, 0x04, 0xC0, 0x47, 0x78,
  0x28, 0xEE, 0x88, 0x09, 0x81, 0x08, 0x64, 0x9D, 0xEE, 0xD9, 0x42, 0x02, 0xA0, 0xC3, 0x01, 0x0B,
  0xF9, 0x81, 0x90, 0x4A, 0x0C, 0x20, 0x10, 0xDF, 0xB0, 0xA0, 0x7A, 0x0C, 0x20, 0xCB, 0x81, 0xC5,
  0x12, 0x03, 0x09, 0xA0, 0xEA, 0x81, 0xC0, 0x6B, 0x0B, 0x70, 0x5C, 0x81, 0xC0, 0xCA, 0x0E, 0x01,
  0x71, 0x09, 0xB0, 0xC0, 0x3B, 0x08, 0x72, 0x01, 0xB0, 0xC0, 0x6B, 0x04, 0x73, 0x0C, 0xA0, 0xC0,
  0x9B, 0x01, 0x73, 0x09, 0xA0, 0xC0, 0xAA, 0x0E, 0x74, 0x07, 0xA0, 0xC0, 0xBA, 0x0D, 0x74, 0x07,
  0xA0, 0x0C, 0xA0, 0xD7, 0x40, 0x6A, 0x0C, 0x0B, 0xA0, 0xE7, 0x40, 0x7A, 0x0C, 0x09, 0xB0, 0x17,
  0x30, 0x8A, 0x0C, 0x07, 0xB0, 0x47, 0x30, 0xAA, 0x0C, 0x03, 0xB0, 0x87, 0x30, 0xEA, 0x81, 0xC0,
  0xDA, 0x0E, 0x01, 0x71, 0x06, 0xB8, 0x1C, 0x07, 0xB0, 0xB7, 0x03, 0x0E, 0xB0, 0xC2, 0x0C, 0xB8,
  0x1D, 0x51, 0x28, 0x12, 0x8E, 0xC0, 0xC2, 0x02, 0x0E, 0xFB, 0x0E, 0x09, 0xA0, 0xC3, 0x02, 0x0B,
  0xF9, 0x81, 0xE3, 0x8A, 0x0C, 0x58, 0x91, 0x49, 0xDE, 0xFD, 0xB7, 0x10, 0x8A, 0x0C, 0x77, 0x10,
  0x8A, 0x0C, 0x77, 0x10, 0x9A, 0x0B, 0x77, 0x10, 0xCA, 0x0A, 0x77, 0x01, 0xB0, 0x77, 0x70, 0x8B,
  0x82, 0x30, 0x74, 0x73, 0x04, 0xB0, 0xC2, 0x84, 0xAF, 0xD9, 0x52, 0x40, 0x40, 0x9C, 0x04, 0x20,
  0xAE, 0x0E, 0xF0, 0x73, 0x06, 0x0D, 0xFC, 0x0D, 0x05, 0x68, 0x33, 0x7A, 0xCE, 0xA8, 0x2E, 0xC9,
  0x55,
  // "Ģ" (U+0122)
  0x71, 0x89, 0x13, 0x8B, 0xDE, 0xFE, 0xC9, 0x51, 0x71, 0x04, 0x0D, 0xFC, 0x08, 0x60, 0x9F, 0x0E,
  0xD0, 0x75, 0x09, 0xC8, 0x1A, 0x51, 0x38, 0x33, 0x7D, 0xE1, 0x40, 0x6B, 0x0D, 0x04, 0x72, 0x03,
  0x40, 0x10, 0xEA, 0x0E, 0x02, 0x77, 0x10, 0x9B, 0x05, 0x77, 0x20, 0xEA, 0x0C, 0x77, 0x20, 0x5B,
  0x06, 0x77, 0x20, 0x9B, 0x01, 0x77, 0x20, 0xCA, 0x0D, 0x77, 0x3B, 0x0B, 0x77, 0x20, 0x1B, 0x09,
  0x77, 0x20, 0x1B, 0x08, 0x77, 0x20, 0x2B, 0x07, 0x60, 0x78, 0x04, 0xE0, 0x02, 0xB0, 0x86, 0x07,
  0xF9, 0x03, 0x01, 0xB0, 0x96, 0x07, 0xF9, 0x03, 0x1B, 0x0A, 0x74, 0x04, 0xB8, 0x13, 0x0E, 0xA0,
  0xC7, 0x40, 0x4B, 0x81, 0x30, 0xBB, 0x74, 0x04, 0xB8, 0x13, 0x08, 0xB0, 0x47, 0x30, 0x4B, 0x81,
  0x30, 0x4B, 0x09, 0x73, 0x04, 0xB0, 0x32, 0x0D, 0xB0, 0x27, 0x20, 0x4B, 0x03, 0x20, 0x6B, 0x0C,
  0x72, 0x04, 0xB0, 0x33, 0x0C, 0xB0, 0xB0, 0x17, 0x04, 0xB0, 0x33, 0x02, 0x0E, 0xB8, 0x1E, 0x73,
  0x40, 0x30, 0x9B, 0x03, 0x40, 0x20, 0xDE, 0x0E, 0xF0, 0x35, 0x01, 0x08, 0xFD, 0x0D, 0x02, 0x78,
  0x92, 0x16, 0xAC, 0xEF, 0xEE, 0xCA, 0x63, 0x80, 0x98, 0x70, 0x0B, 0xA0, 0xB7, 0x73, 0x0E, 0xA0,
  0x57, 0x72, 0x03, 0xA0, 0xD7, 0x73, 0x08, 0xA0, 0x47, 0x73, 0x81, 0xDF, 0xA7, 0x73, 0x82, 0x3F,
  0xD1, 0x72,
  // "ģ" (U+0123)
  0x73, 0x81, 0xBF, 0x77, 0x71, 0x07, 0xA0, 0x27, 0x70, 0x2A, 0x0C, 0x77, 0x10, 0xAA, 0x07, 0x77,
  0x02, 0xB0, 0x37, 0x70, 0x7A, 0x0E, 0x80, 0x98, 0x20, 0x86, 0x49, 0xDE, 0xED, 0x94, 0x20, 0x2A,
  0x0C, 0x30, 0x10, 0xBF, 0x98, 0x19, 0x04, 0xA0, 0xC2, 0x01, 0x0D, 0xFB, 0x0A, 0x07, 0xA0, 0xC2,
  0x0C, 0xB8, 0x1C, 0x51, 0x20, 0x30, 0x9A, 0x0E, 0xA8, 0x1C, 0x06, 0xB0, 0xB7, 0x05, 0xC8, 0x1C,
  0x0C, 0xA0, 0xE0, 0x17, 0x10, 0x9B, 0x0C, 0x03, 0xB0, 0x87, 0x20, 0x1B, 0x0C, 0x06, 0xB0, 0x47,
  0x30, 0xCA, 0x0C, 0x09, 0xB0, 0x17, 0x30, 0x9A, 0x0C, 0x0A, 0xA0, 0xE7, 0x40, 0x7A, 0x0C, 0x0B,
  0xA0, 0xD7, 0x40, 0x7A, 0x00, 0xCA, 0x0D, 0x74, 0x06, 0xA0, 0xC0, 0xBA, 0x0E, 0x74, 0x07, 0xA0,
  0xC0, 0x9B, 0x01, 0x73, 0x08, 0xA0, 0xC0, 0x7B, 0x04, 0x73, 0x0A, 0xA0, 0xC0, 0x3B, 0x08, 0x73,
  0x0E, 0xA8, 0x1C, 0x0D, 0xA0, 0xE0, 0x17, 0x10, 0x6B, 0x81, 0xC0, 0x7B, 0x0B, 0x70, 0x30, 0xEB,
  0x0C, 0x20, 0xCB, 0x81, 0xD5, 0x12, 0x81, 0x28, 0xEC, 0x0C, 0x20, 0x20, 0xEF, 0xB0, 0xE0, 0x9A,
  0x0C, 0x30, 0x20, 0xBF, 0x98, 0x1E, 0x38, 0xA0, 0xC5, 0x89, 0x14, 0x9D, 0xEF, 0xDB, 0x71, 0x08,
  0xA0, 0xC7, 0x71, 0x08, 0xA0, 0xC7, 0x71, 0x09, 0xA0, 0xB7, 0x71, 0x0C, 0xA0, 0xA7, 0x70, 0x1B,
  0x07, 0x77, 0x08, 0xB8, 0x23, 0x07, 0x47, 0x30, 0x4B, 0x0C, 0x28, 0x4A, 0xFD, 0x95, 0x24, 0x04,
  0x09, 0xC0, 0x42, 0x0A, 0xE0, 0xEF, 0x07, 0x30, 0x60, 0xDF, 0xC0, 0xD0, 0x56, 0x83, 0x37, 0xAC,
  0xEA, 0x82, 0xEC, 0x95, 0x50,
  // "Ĥ" (U+0124)
  0x71, 0x80, 0x07, 0x77, 0x10, 0x7C, 0x06, 0x76, 0x04, 0xD0, 0xE0, 0x27, 0x40, 0x20, 0xEA, 0x08,
  0x0A, 0xA0, 0xD0, 0x17, 0x20, 0x10, 0xDA, 0x07, 0x20, 0xAA, 0x0C, 0x72, 0x0B, 0xA0, 0x74, 0x09,
  0xA0, 0xB7, 0x82, 0x9F, 0xE5, 0x60, 0x6A, 0x09, 0x80, 0xC7, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0,
  0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B,
  0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06,
  0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30,
  0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3F, 0xFC, 0x00,
  0x3F, 0xFC, 0x00, 0x3B, 0x80, 0x90, 0xEB, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67,
  0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06,
  0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0,
  0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B,
  0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03,
  0xB0, 0x67, 0x30, 0x6B, 0x03,
  // "ĥ" (U+0125)
  0x58, 0x00, 0x77, 0x74, 0x07, 0xC0, 0x67, 0x72, 0x04, 0xD0, 0xE0, 0x27, 0x70, 0x20, 0xEA, 0x08,
  0x0A, 0xA0, 0xD0, 0x17, 0x50, 0x10, 0xDA, 0x07, 0x20, 0xAA, 0x0C, 0x75, 0x0B, 0xA0, 0x74, 0x09,
  0xA0, 0xB7, 0x38, 0x29, 0xFE, 0x56, 0x06, 0xA0, 0x98, 0x0F, 0x00, 0x0C, 0xA0, 0xC7, 0x75, 0x0C,
  0xA0, 0xC7, 0x75, 0x0C, 0xA0, 0xC7, 0x75, 0x0C, 0xA0, 0xC7, 0x75, 0x0C, 0xA0, 0xC7, 0x75, 0x0C,
  0xA0, 0xC7, 0x75, 0x0C, 0xA0, 0xC7, 0x75, 0x0C, 0xA0, 0xC7, 0x75, 0x0C, 0xA0, 0xC7, 0x75, 0x0C,
  0xA0, 0xC3, 0x86, 0x6B, 0xDF, 0xEC, 0x81, 0x71, 0x0C, 0xA8, 0x2B, 0x04, 0xEF, 0x90, 0x67, 0x0C,
  0xA0, 0xB0, 0x4C, 0x0E, 0xE0, 0x76, 0x0C, 0xA8, 0x4B, 0xDF, 0xD5, 0x12, 0x03, 0x0B, 0xC0, 0x15,
  0x0C, 0xC0, 0xC0, 0x16, 0x0B, 0xB0, 0x75, 0x0C, 0xB0, 0xE0, 0x17, 0x02, 0xB0, 0xB5, 0x0C, 0xB0,
  0x87, 0x20, 0xCA, 0x0E, 0x50, 0xCB, 0x03, 0x72, 0x0A, 0xB5, 0x0C, 0xB7, 0x30, 0x9B, 0x50, 0xCA,
  0x0D, 0x73, 0x09, 0xB5, 0x0C, 0xA0, 0xC7, 0x30, 0x9B, 0x50, 0xCA, 0x0C, 0x73, 0x09, 0xB5, 0x0C,
  0xA0, 0xC7, 0x30, 0x9B, 0x50, 0xCA, 0x0C, 0x73, 0x09, 0xB5, 0x0C, 0xA0, 0xC7, 0x30, 0x9B, 0x50,
  0xCA, 0x0C, 0x73, 0x09, 0xB5, 0x0C, 0xA0, 0xC7, 0x30, 0x9B, 0x50, 0xCA, 0x0C, 0x73, 0x09, 0xB5,
  0x0C, 0xA0, 0xC7, 0x30, 0x9B, 0x50, 0xCA, 0x0C, 0x73, 0x09, 0xB5, 0x0C, 0xA0, 0xC7, 0x30, 0x9B,
  0x50, 0xCA, 0x0C, 0x73, 0x09, 0xB0,
  // "Ħ" (U+0126)
  0x20, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x34, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x03, 0x40, 0x3B, 0x06,
  0x73, 0x06, 0xB0, 0x34, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x03, 0x40, 0x3B, 0x06, 0x73, 0x06, 0xB0,
  0x32, 0x80, 0xD4, 0xF0, 0xFE, 0xB8, 0x09, 0x0E, 0xB0, 0xFE, 0x20, 0x3B, 0x06, 0x73, 0x06, 0xB0,
  0x34, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x03, 0x40, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x34, 0x03, 0xB0,
  0x67, 0x30, 0x6B, 0x03, 0x40, 0x3F, 0xFC, 0x03, 0x40, 0x3F, 0xFC, 0x03, 0x40, 0x3B, 0x80, 0x90,
  0xEB, 0x03, 0x40, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x34, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x03, 0x40,
  0x3B, 0x06, 0x73, 0x06, 0xB0, 0x34, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x03, 0x40, 0x3B, 0x06, 0x73,
  0x06, 0xB0, 0x34, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x03, 0x40, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x34,
  0x03, 0xB0, 0x67, 0x30, 0x6B, 0x03, 0x40, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x34, 0x03, 0xB0, 0x67,
  0x30, 0x6B, 0x03, 0x40, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x34, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x03,
  0x40, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x34, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x03, 0x20,
  // "ħ" (U+0127)
  0x30, 0xCA, 0x0C, 0x77, 0x30, 0xCA, 0x0C, 0x77, 0x30, 0xCA, 0x0C, 0x77, 0x30, 0xCA, 0x0C, 0x77,
  0xFE, 0x0D, 0x7F, 0xE0, 0xD7, 0x0F, 0xEC, 0x80, 0x2E, 0x0C, 0x73, 0x0C, 0xA0, 0xC7, 0x73, 0x0C,
  0xA0, 0xC7, 0x73, 0x0C, 0xA0, 0xC3, 0x86, 0x6B, 0xDF, 0xEC, 0x81, 0x60, 0xCA, 0x82, 0xB0, 0x4E,
  0xF9, 0x06, 0x50, 0xCA, 0x0B, 0x04, 0xC0, 0xEE, 0x07, 0x40, 0xCA, 0x84, 0xBD, 0xFD, 0x51, 0x20,
  0x30, 0xBC, 0x01, 0x30, 0xCC, 0x0C, 0x01, 0x60, 0xBB, 0x07, 0x30, 0xCB, 0x0E, 0x01, 0x70, 0x2B,
  0x0B, 0x30, 0xCB, 0x08, 0x72, 0x0C, 0xA0, 0xE3, 0x0C, 0xB0, 0x37, 0x20, 0xAB, 0x30, 0xCB, 0x73,
  0x09, 0xB3, 0x0C, 0xA0, 0xD7, 0x30, 0x9B, 0x30, 0xCA, 0x0C, 0x73, 0x09, 0xB3, 0x0C, 0xA0, 0xC7,
  0x30, 0x9B, 0x30, 0xCA, 0x0C, 0x73, 0x09, 0xB3, 0x0C, 0xA0, 0xC7, 0x30, 0x9B, 0x30, 0xCA, 0x0C,
  0x73, 0x09, 0xB3, 0x0C, 0xA0, 0xC7, 0x30, 0x9B, 0x30, 0xCA, 0x0C, 0x73, 0x09, 0xB3, 0x0C, 0xA0,
  0xC7, 0x30, 0x9B, 0x30, 0xCA, 0x0C, 0x73, 0x09, 0xB3, 0x0C, 0xA0, 0xC7, 0x30, 0x9B, 0x30, 0xCA,
  0x0C, 0x73, 0x09, 0xB3, 0x0C, 0xA0, 0xC7, 0x30, 0x9B,
  // "Ĩ" (U+0128)
  0x28, 0x41, 0x9E, 0xEB, 0x55, 0x81, 0xEF, 0x12, 0x0D, 0xD0, 0xC0, 0x52, 0x81, 0x9F, 0xD2, 0x07,
  0xFD, 0x07, 0x28, 0x1D, 0xF9, 0x20, 0x40, 0xCD, 0x0D, 0x20, 0x1A, 0x58, 0x45, 0xCE, 0xE9, 0x17,
  0x77, 0x76, 0x09, 0xFF, 0x00, 0x9F, 0xF8, 0x29, 0x7D, 0xEF, 0xB8, 0x1E, 0xD7, 0x48, 0x11, 0x3D,
  0xA8, 0x1C, 0x31, 0x73, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA,
  0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75,
  0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0,
  0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50,
  0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B,
  0x68, 0x44, 0x9A, 0xCD, 0xEC, 0x85, 0xED, 0xBA, 0x94, 0x9F, 0xF0, 0x09, 0xFF, 0x09,
  // "ĩ" (U+0129)
  0x38, 0x41, 0x9E, 0xEB, 0x55, 0x81, 0xEF, 0x15, 0x0D, 0xD0, 0xC0, 0x52, 0x81, 0x9F, 0xD5, 0x07,
  0xFD, 0x07, 0x58, 0x1D, 0xF9, 0x20, 0x40, 0xCD, 0x0D, 0x50, 0x1A, 0x58, 0x45, 0xCE, 0xE9, 0x18,
  0x0C, 0x60, 0x02, 0xFB, 0x06, 0x70, 0x2F, 0xB0, 0x67, 0x83, 0x1A, 0xBC, 0xDE, 0x06, 0x77, 0x03,
  0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0, 0x67,
  0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B,
  0x06, 0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77,
  0x02, 0xB0, 0x67, 0x70, 0x2B, 0x07, 0x78, 0x55, 0x89, 0xBC, 0xDE, 0xE8, 0x5D, 0xCB, 0x98, 0x4C,
  0xFF, 0xB0, 0x90, 0xCF, 0xFB, 0x09,
  // "Ī" (U+012A)
  0x20, 0xD8, 0x06, 0xE0, 0xD4, 0x0E, 0xFB, 0x0E, 0x40, 0xEF, 0xB0, 0xE8, 0x0D, 0x60, 0x09, 0xFF,
  0x00, 0x9F, 0xF8, 0x29, 0x7D, 0xEF, 0xB8, 0x1E, 0xD7, 0x48, 0x11, 0x3D, 0xA8, 0x1C, 0x31, 0x73,
  0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0,
  0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50,
  0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B,
  0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D,
  0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x68, 0x44, 0x9A, 0xCD,
  0xEC, 0x85, 0xED, 0xBA, 0x94, 0x9F, 0xF0, 0x09, 0xFF, 0x09,
  // "ī" (U+012B)
  0x30, 0xD8, 0x06, 0xE0, 0xD7, 0x0E, 0xFB, 0x0E, 0x70, 0xEF, 0xB0, 0xE8, 0x0F, 0x10, 0x02, 0xFB,
  0x06, 0x70, 0x2F, 0xB0, 0x67, 0x83, 0x1A, 0xBC, 0xDE, 0x06, 0x77, 0x03, 0xB0, 0x67, 0x70, 0x2B,
  0x06, 0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77,
  0x02, 0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0,
  0x67, 0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0, 0x67, 0x70,
  0x2B, 0x07, 0x78, 0x55, 0x89, 0xBC, 0xDE, 0xE8, 0x5D, 0xCB, 0x98, 0x4C, 0xFF, 0xB0, 0x90, 0xCF,
  0xFB, 0x09,
  // "Ĭ" (U+012C)
  0x18, 0x21, 0x77, 0x16, 0x82, 0x17, 0x71, 0x20, 0x1A, 0x08, 0x60, 0x8A, 0x01, 0x30, 0xCA, 0x08,
  0x02, 0x20, 0x20, 0x8A, 0x0C, 0x40, 0x4F, 0xB0, 0x45, 0x06, 0xF9, 0x06, 0x78, 0x63, 0x9D, 0xFE,
  0xD9, 0x28, 0x0C, 0x00, 0x09, 0xFF, 0x00, 0x9F, 0xF8, 0x29, 0x7D, 0xEF, 0xB8, 0x1E, 0xD7, 0x48,
  0x11, 0x3D, 0xA8, 0x1C, 0x31, 0x73, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7,
  0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA,
  0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75,
  0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0,
  0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50,
  0xDA, 0x0B, 0x68, 0x44, 0x9A, 0xCD, 0xEC, 0x85, 0xED, 0xBA, 0x94, 0x9F, 0xF0, 0x09, 0xFF, 0x09,
  // "ĭ" (U+012D)
  0x28, 0x21, 0x77, 0x16, 0x82, 0x17, 0x71, 0x50, 0x1A, 0x08, 0x60, 0x8A, 0x01, 0x60, 0xCA, 0x08,
  0x02, 0x20, 0x20, 0x8A, 0x0C, 0x70, 0x4F, 0xB0, 0x47, 0x10, 0x6F, 0x90, 0x67, 0x38, 0x63, 0x9D,
  0xFE, 0xD9, 0x28, 0x0D, 0x00, 0x02, 0xFB, 0x06, 0x70, 0x2F, 0xB0, 0x67, 0x83, 0x1A, 0xBC, 0xDE,
  0x06, 0x77, 0x03, 0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77,
  0x02, 0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0,
  0x67, 0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0, 0x67, 0x70,
  0x2B, 0x06, 0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B, 0x07, 0x78, 0x55, 0x89, 0xBC, 0xDE, 0xE8, 0x5D,
  0xCB, 0x98, 0x4C, 0xFF, 0xB0, 0x90, 0xCF, 0xFB, 0x09,
  // "Į" (U+012E)
  0x09, 0xFF, 0x00, 0x9F, 0xF8, 0x29, 0x7D, 0xEF, 0xB8, 0x1E, 0xD7, 0x48, 0x11, 0x3D, 0xA8, 0x1C,
  0x31, 0x73, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75,
  0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0,
  0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50,
  0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B,
  0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x68, 0x44,
  0x9A, 0xCD, 0xEC, 0x85, 0xED, 0xBA, 0x94, 0x9F, 0xF0, 0x09, 0xFF, 0x09, 0x72, 0x82, 0x2E, 0xF9,
  0x75, 0x81, 0xCF, 0xB7, 0x50, 0x7A, 0x02, 0x75, 0x81, 0xDF, 0xC7, 0x50, 0x1A, 0x0B, 0x75, 0x01,
  0xB0, 0x47, 0x50, 0xED, 0x06, 0x72, 0x06, 0xD0, 0x67, 0x38, 0x46, 0xCF, 0xEC, 0x41,
  // "į" (U+012F)
  0x78, 0x34, 0xDE, 0xA1, 0x76, 0x01, 0x0E, 0xB0, 0x97, 0x60, 0x3C, 0x0B, 0x77, 0x0E, 0xB0, 0x97,
  0x78, 0x34, 0xDE, 0xA1, 0x80, 0x99, 0x70, 0x02, 0xFB, 0x06, 0x70, 0x2F, 0xB0, 0x67, 0x83, 0x1A,
  0xBC, 0xDE, 0x06, 0x77, 0x03, 0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B,
  0x06, 0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77,
  0x02, 0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0,
  0x67, 0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B, 0x07, 0x78, 0x55, 0x89, 0xBC, 0xDE,
  0xE8, 0x5D, 0xCB, 0x98, 0x4C, 0xFF, 0xB0, 0x90, 0xCF, 0xFB, 0x09, 0x74, 0x82, 0x2E, 0xF9, 0x77,
  0x18, 0x1C, 0xFB, 0x77, 0x10, 0x7A, 0x02, 0x77, 0x18, 0x1D, 0xFC, 0x77, 0x10, 0x1A, 0x0B, 0x77,
  0x10, 0x1B, 0x04, 0x77, 0x10, 0xED, 0x06, 0x75, 0x06, 0xD0, 0x67, 0x68, 0x46, 0xCF, 0xEC, 0x42,
  // "İ" (U+0130)
  0x68, 0x28, 0xEE, 0x87, 0x40, 0x4C, 0x04, 0x73, 0x07, 0xC0, 0x77, 0x30, 0x4C, 0x04, 0x74, 0x82,
  0x8E, 0xE8, 0x80, 0xE2, 0x00, 0x9F, 0xF0, 0x09, 0xFF, 0x82, 0x97, 0xDE, 0xFB, 0x81, 0xED, 0x74,
  0x81, 0x13, 0xDA, 0x81, 0xC3, 0x17, 0x30, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B,
  0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D,
  0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7,
  0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA,
  0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x0B, 0x75,
  0x0D, 0xA0, 0xB6, 0x84, 0x49, 0xAC, 0xDE, 0xC8, 0x5E, 0xDB, 0xA9, 0x49, 0xFF, 0x00, 0x9F, 0xF0,
  0x90,
  // "ı" (U+0131)
  0x02, 0xFB, 0x06, 0x70, 0x2F, 0xB0, 0x67, 0x83, 0x1A, 0xBC, 0xDE, 0x06, 0x77, 0x03, 0xB0, 0x67,
  0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B,
  0x06, 0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77,
  0x02, 0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0, 0x67, 0x70, 0x2B, 0x06, 0x77, 0x02, 0xB0,
  0x67, 0x70, 0x2B, 0x07, 0x78, 0x55, 0x89, 0xBC, 0xDE, 0xE8, 0x5D, 0xCB, 0x98, 0x4C, 0xFF, 0xB0,
  0x90, 0xCF, 0xFB, 0x09,
  // "Ĳ" (U+0132)
  0xB0, 0x97, 0x10, 0x9E, 0x09, 0x71, 0x09, 0xE0, 0x97, 0x10, 0x9E, 0x09, 0x71, 0x09, 0xE0, 0x97,
  0x10, 0x9E, 0x09, 0x71, 0x09, 0xE0, 0x97, 0x10, 0x9E, 0x09, 0x71, 0x09, 0xE0, 0x97, 0x10, 0x9E,
  0x09, 0x71, 0x09, 0xE0, 0x97, 0x10, 0x9E, 0x09, 0x71, 0x09, 0xE0, 0x97, 0x10, 0x9E, 0x09, 0x71,
  0x09, 0xE0, 0x97, 0x10, 0x9E, 0x09, 0x71, 0x09, 0xE0, 0x97, 0x10, 0x9E, 0x09, 0x71, 0x09, 0xE0,
  0x97, 0x10, 0x9E, 0x09, 0x71, 0x09, 0xE0, 0x97, 0x10, 0xAA, 0x0E, 0x75, 0x0B, 0xA0, 0xD7, 0x50,
  0xEA, 0x0B, 0x74, 0x06, 0xB0, 0x77, 0x30, 0x30, 0xEB, 0x84, 0x1D, 0xA6, 0x31, 0x30, 0x30, 0x8C,
  0x81, 0x80, 0xED, 0x0E, 0xE0, 0xB2, 0x0E, 0xFC, 0x08, 0x38, 0x92, 0x26, 0x9B, 0xDE, 0xFE, 0xDB,
  0x71, 0x40,
  // "ĳ" (U+0133)
  0x83, 0x2C, 0xEC, 0x36, 0x84, 0x3C, 0xEC, 0x2C, 0xB0, 0xD6, 0x0C, 0xB0, 0xC0, 0xEC, 0x60, 0xEB,
  0x0E, 0x0C, 0xB0, 0xC6, 0x0C, 0xB8, 0x4C, 0x2B, 0xEC, 0x26, 0x83, 0x2C, 0xEB, 0x28, 0x0F, 0x40,
  0x04, 0xB0, 0x46, 0x01, 0xB0, 0x70, 0x4B, 0x04, 0x60, 0x1B, 0x07, 0x04, 0xB0, 0x46, 0x01, 0xB0,
  0x70, 0x4B, 0x04, 0x60, 0x1B, 0x07, 0x04, 0xB0, 0x46, 0x01, 0xB0, 0x70, 0x4B, 0x04, 0x60, 0x1B,
  0x07, 0x04, 0xB0, 0x46, 0x01, 0xB0, 0x70, 0x4B, 0x04, 0x60, 0x1B, 0x07, 0x04, 0xB0, 0x46, 0x01,
  0xB0, 0x70, 0x4B, 0x04, 0x60, 0x1B, 0x07, 0x04, 0xB0, 0x46, 0x01, 0xB0, 0x70, 0x4B, 0x04, 0x60,
  0x1B, 0x07, 0x04, 0xB0, 0x46, 0x01, 0xB0, 0x70, 0x4B, 0x04, 0x60, 0x1B, 0x07, 0x04, 0xB0, 0x46,
  0x01, 0xB0, 0x70, 0x4B, 0x04, 0x60, 0x1B, 0x07, 0x04, 0xB0, 0x46, 0x01, 0xB0, 0x70, 0x4B, 0x04,
  0x60, 0x1B, 0x07, 0x04, 0xB0, 0x46, 0x01, 0xB0, 0x70, 0x4B, 0x04, 0x60, 0x1B, 0x07, 0x04, 0xB0,
  0x46, 0x01, 0xB0, 0x70, 0x4B, 0x04, 0x60, 0x1B, 0x07, 0x74, 0x01, 0xB0, 0x77, 0x40, 0x2B, 0x07,
  0x74, 0x02, 0xB0, 0x77, 0x40, 0x5B, 0x05, 0x74, 0x0A, 0xB0, 0x27, 0x30, 0x4B, 0x0D, 0x28, 0x28,
  0x73, 0x13, 0x02, 0x08, 0xC0, 0x52, 0x0C, 0xC0, 0xEE, 0x09, 0x30, 0xCF, 0xB0, 0x74, 0x89, 0x15,
  0x9B, 0xDE, 0xFE, 0xDB, 0x71, 0x40,
  // "Ĵ" (U+0134)
  0x74, 0x80, 0x07, 0x77, 0x10, 0x7C, 0x06, 0x76, 0x04, 0xD0, 0xE0, 0x27, 0x40, 0x20, 0xEA, 0x08,
  0x0A, 0xA0, 0xD0, 0x17, 0x20, 0x10, 0xDA, 0x07, 0x20, 0xAA, 0x0C, 0x72, 0x0B, 0xA0, 0x74, 0x09,
  0xA0, 0xB7, 0x82, 0x9F, 0xE5, 0x60, 0x6A, 0x09, 0x80, 0xD7, 0x0B, 0x09, 0x77, 0x2B, 0x09, 0x77,
  0x2B, 0x09, 0x77, 0x2B, 0x09, 0x77, 0x2B, 0x09, 0x77, 0x2B, 0x09, 0x77, 0x2B, 0x09, 0x77, 0x2B,
  0x09, 0x77, 0x2B, 0x09, 0x77, 0x2B, 0x09, 0x77, 0x2B, 0x09, 0x77, 0x2B, 0x09, 0x77, 0x2B, 0x09,
  0x77, 0x2B, 0x09, 0x77, 0x2B, 0x09, 0x77, 0x2B, 0x09, 0x77, 0x2B, 0x09, 0x77, 0x2B, 0x09, 0x77,
  0x2B, 0x09, 0x77, 0x2B, 0x09, 0x77, 0x2B, 0x08, 0x77, 0x10, 0x2B, 0x07, 0x77, 0x10, 0x5B, 0x05,
  0x77, 0x10, 0xAB, 0x01, 0x77, 0x05, 0xB0, 0xB6, 0x82, 0xEA, 0x52, 0x30, 0x20, 0x9C, 0x03, 0x6D,
  0x0E, 0xE0, 0x77, 0xFB, 0x0E, 0x06, 0x71, 0x83, 0x26, 0xAC, 0xEA, 0x82, 0xDB, 0x71, 0x72,
  // "ĵ" (U+0135)
  0x73, 0x80, 0x07, 0x77, 0x07, 0xC0, 0x67, 0x50, 0x4D, 0x0E, 0x02, 0x73, 0x02, 0x0E, 0xA0, 0x80,
  0xAA, 0x0D, 0x01, 0x71, 0x01, 0x0D, 0xA0, 0x72, 0x0A, 0xA0, 0xC7, 0x10, 0xBA, 0x07, 0x40, 0x9A,
  0x0B, 0x68, 0x29, 0xFE, 0x56, 0x06, 0xA0, 0x98, 0x0C, 0x50, 0x0B, 0xFA, 0x0D, 0x71, 0x0B, 0xFA,
  0x0D, 0x71, 0x81, 0x8D, 0xEF, 0x0D, 0x75, 0x82, 0x12, 0x3C, 0xA0, 0xD7, 0x71, 0x0B, 0xA0, 0xD7,
  0x71, 0x0B, 0xA0, 0xD7, 0x71, 0x0B, 0xA0, 0xD7, 0x71, 0x0B, 0xA0, 0xD7, 0x71, 0x0B, 0xA0, 0xD7,
  0x71, 0x0B, 0xA0, 0xD7, 0x71, 0x0B, 0xA0, 0xD7, 0x71, 0x0B, 0xA0, 0xD7, 0x71, 0x0B, 0xA0, 0xD7,
  0x71, 0x0B, 0xA0, 0xD7, 0x71, 0x0B, 0xA0, 0xD7, 0x71, 0x0B, 0xA0, 0xD7, 0x71, 0x0B, 0xA0, 0xD7,
  0x71, 0x0B, 0xA0, 0xD7, 0x71, 0x0B, 0xA0, 0xD7, 0x71, 0x0B, 0xA0, 0xD7, 0x71, 0x0B, 0xA0, 0xD7,
  0x71, 0x0B, 0xA0, 0xD7, 0x71, 0x0B, 0xA0, 0xD7, 0x71, 0x0B, 0xA0, 0xD7, 0x71, 0x0B, 0xA0, 0xD7,
  0x71, 0x0E, 0xA0, 0xB7, 0x70, 0x3B, 0x09, 0x77, 0x0B, 0xB0, 0x45, 0x82, 0x67, 0x31, 0x30, 0x40,
  0xBB, 0x0C, 0x60, 0x9C, 0x0E, 0xD0, 0xE0, 0x26, 0x09, 0xFA, 0x0C, 0x02, 0x78, 0x90, 0x39, 0xBD,
  0xEF, 0xED, 0xA5, 0x72,
  // "Ķ" (U+0136)
  0x03, 0xB0, 0x67, 0x30, 0xCB, 0x04, 0x03, 0xB0, 0x67, 0x20, 0x9B, 0x81, 0x80, 0x3B, 0x06, 0x71,
  0x04, 0xB0, 0xC2, 0x03, 0xB0, 0x67, 0x01, 0x0E, 0xA0, 0xE0, 0x22, 0x03, 0xB0, 0x67, 0x0B, 0xB0,
  0x63, 0x03, 0xB0, 0x66, 0x07, 0xB0, 0xA4, 0x03, 0xB0, 0x65, 0x03, 0xB0, 0xD0, 0x14, 0x03, 0xB0,
  0x64, 0x01, 0x0D, 0xB0, 0x35, 0x03, 0xB0, 0x64, 0x0A, 0xB0, 0x76, 0x03, 0xB0, 0x63, 0x06, 0xB0,
  0xB7, 0x03, 0xB0, 0x62, 0x02, 0xB0, 0xE0, 0x17, 0x03, 0xB0, 0x62, 0x0D, 0xB0, 0x57, 0x10, 0x3B,
  0x81, 0x60, 0x8B, 0x09, 0x72, 0x03, 0xB0, 0x60, 0x3C, 0x04, 0x72, 0x03, 0xB0, 0x60, 0xCC, 0x0D,
  0x72, 0x03, 0xB0, 0xDA, 0x0E, 0xB0, 0x77, 0x10, 0x3D, 0x81, 0xD1, 0xDB, 0x02, 0x70, 0x3C, 0x82,
  0xE2, 0x03, 0xB0, 0xB7, 0x03, 0xC0, 0x33, 0x09, 0xB0, 0x56, 0x03, 0xB0, 0x74, 0x01, 0x0E, 0xA0,
  0xE0, 0x15, 0x03, 0xB0, 0x65, 0x06, 0xB0, 0x95, 0x03, 0xB0, 0x66, 0x0B, 0xB0, 0x44, 0x03, 0xB0,
  0x66, 0x02, 0xB0, 0xD4, 0x03, 0xB0, 0x67, 0x08, 0xB0, 0x83, 0x03, 0xB0, 0x67, 0x10, 0xDB, 0x02,
  0x20, 0x3B, 0x06, 0x71, 0x04, 0xB0, 0xC2, 0x03, 0xB0, 0x67, 0x20, 0xAB, 0x81, 0x60, 0x3B, 0x06,
  0x72, 0x01, 0x0E, 0xA8, 0x1E, 0x13, 0xB0, 0x67, 0x30, 0x6B, 0x0A, 0x80, 0x98, 0x00, 0x0B, 0xA0,
  0xB7, 0x72, 0x0E, 0xA0, 0x57, 0x71, 0x03, 0xA0, 0xD7, 0x72, 0x08, 0xA0, 0x47, 0x72, 0x81, 0xDF,
  0xA7, 0x72, 0x82, 0x3F, 0xD1, 0x73,
  // "ķ" (U+0137)
  0x0C, 0xA0, 0xC7, 0x71, 0x0C, 0xA0, 0xC7, 0x71, 0x0C, 0xA0, 0xC7, 0x71, 0x0C, 0xA0, 0xC7, 0x71,
  0x0C, 0xA0, 0xC7, 0x71, 0x0C, 0xA0, 0xC7, 0x71, 0x0C, 0xA0, 0xC7, 0x71, 0x0C, 0xA0, 0xC7, 0x71,
  0x0C, 0xA0, 0xC7, 0x71, 0x0C, 0xA0, 0xC7, 0x20, 0x8B, 0x81, 0xB0, 0xCA, 0x0C, 0x71, 0x06, 0xB8,
  0x2C, 0x10, 0xCA, 0x0C, 0x70, 0x4B, 0x0D, 0x01, 0x20, 0xCA, 0x0C, 0x60, 0x30, 0xEA, 0x0E, 0x02,
  0x30, 0xCA, 0x0C, 0x50, 0x10, 0xEB, 0x03, 0x40, 0xCA, 0x0C, 0x40, 0x10, 0xDB, 0x05, 0x50, 0xCA,
  0x0C, 0x40, 0xBB, 0x06, 0x60, 0xCA, 0x0B, 0x30, 0xAB, 0x08, 0x70, 0xCA, 0x0A, 0x20, 0x8B, 0x09,
  0x71, 0x0C, 0xA8, 0x1A, 0x05, 0xB0, 0xD7, 0x20, 0xCA, 0x09, 0x03, 0xD0, 0x67, 0x10, 0xCA, 0x09,
  0x0D, 0xA0, 0xEB, 0x02, 0x70, 0xCD, 0x81, 0x72, 0xEA, 0x0D, 0x70, 0xCC, 0x07, 0x20, 0x6B, 0x09,
  0x60, 0xCB, 0x07, 0x40, 0xAB, 0x05, 0x50, 0xCA, 0x0C, 0x50, 0x10, 0xEA, 0x0E, 0x01, 0x40, 0xCA,
  0x0C, 0x60, 0x4B, 0x0C, 0x40, 0xCA, 0x0C, 0x70, 0x8B, 0x08, 0x30, 0xCA, 0x0C, 0x71, 0x0C, 0xB0,
  0x32, 0x0C, 0xA0, 0xC7, 0x10, 0x2B, 0x82, 0xD1, 0x0C, 0xA0, 0xC7, 0x20, 0x6B, 0x81, 0xA0, 0xCA,
  0x0C, 0x73, 0x0B, 0xB0, 0x68, 0x0F, 0x50, 0x0B, 0xA0, 0xB7, 0x71, 0x0E, 0xA0, 0x57, 0x70, 0x3A,
  0x0D, 0x77, 0x10, 0x8A, 0x04, 0x77, 0x18, 0x1D, 0xFA, 0x77, 0x18, 0x23, 0xFD, 0x17, 0x20,
  // "ĸ" (U+0138)
  0x0C, 0xA0, 0xC7, 0x20, 0x8B, 0x81, 0xB0, 0xCA, 0x0C, 0x71, 0x06, 0xB8, 0x2C, 0x10, 0xCA, 0x0C,
  0x70, 0x4B, 0x0D, 0x01, 0x20, 0xCA, 0x0C, 0x60, 0x30, 0xEA, 0x0E, 0x02, 0x30, 0xCA, 0x0C, 0x50,
  0x10, 0xEB, 0x03, 0x40, 0xCA, 0x0C, 0x40, 0x10, 0xDB, 0x05, 0x50, 0xCA, 0x0C, 0x40, 0xBB, 0x06,
  0x60, 0xCA, 0x0B, 0x30, 0xAB, 0x08, 0x70, 0xCA, 0x0A, 0x20, 0x8B, 0x09, 0x71, 0x0C, 0xA8, 0x1A,
  0x06, 0xB0, 0xD7, 0x20, 0xCA, 0x09, 0x03, 0xD0, 0x67, 0x10, 0xCA, 0x09, 0x0D, 0xA0, 0xEB, 0x02,
  0x70, 0xCD, 0x81, 0x72, 0xEA, 0x0D, 0x70, 0xCC, 0x07, 0x20, 0x6B, 0x09, 0x60, 0xCB, 0x07, 0x40,
  0xAB, 0x05, 0x50, 0xCA, 0x0C, 0x50, 0x10, 0xEA, 0x0E, 0x01, 0x40, 0xCA, 0x0C, 0x60, 0x4B, 0x0C,
  0x40, 0xCA, 0x0C, 0x70, 0x8B, 0x08, 0x30, 0xCA, 0x0C, 0x71, 0x0C, 0xB0, 0x32, 0x0C, 0xA0, 0xC7,
  0x10, 0x2B, 0x82, 0xD1, 0x0C, 0xA0, 0xC7, 0x20, 0x6B, 0x81, 0xA0, 0xCA, 0x0C, 0x73, 0x0B, 0xB0,
  0x60,
  // "Ĺ" (U+0139)
  0x48, 0x33, 0x77, 0x76, 0x75, 0x0D, 0xB0, 0x77, 0x40, 0x7B, 0x0A, 0x74, 0x02, 0xB0, 0xB7, 0x50,
  0xBA, 0x0C, 0x75, 0x06, 0xA0, 0xC0, 0x17, 0x40, 0x1A, 0x0B, 0x80, 0xD3, 0x00, 0x6B, 0x03, 0x75,
  0x06, 0xB0, 0x37, 0x50, 0x6B, 0x03, 0x75, 0x06, 0xB0, 0x37, 0x50, 0x6B, 0x03, 0x75, 0x06, 0xB0,
  0x37, 0x50, 0x6B, 0x03, 0x75, 0x06, 0xB0, 0x37, 0x50, 0x6B, 0x03, 0x75, 0x06, 0xB0, 0x37, 0x50,
  0x6B, 0x03, 0x75, 0x06, 0xB0, 0x37, 0x50, 0x6B, 0x03, 0x75, 0x06, 0xB0, 0x37, 0x50, 0x6B, 0x03,
  0x75, 0x06, 0xB0, 0x37, 0x50, 0x6B, 0x03, 0x75, 0x06, 0xB0, 0x37, 0x50, 0x6B, 0x03, 0x75, 0x06,
  0xB0, 0x37, 0x50, 0x6B, 0x03, 0x75, 0x06, 0xB0, 0x37, 0x50, 0x6B, 0x03, 0x75, 0x06, 0xB0, 0x37,
  0x50, 0x6B, 0x03, 0x75, 0x06, 0xB0, 0x37, 0x50, 0x6B, 0x80, 0x90, 0xE0, 0x80, 0x6F, 0xF9, 0x09,
  0x06, 0xFF, 0x90, 0x90,
  // "ĺ" (U+013A)
  0x74, 0x83, 0x37, 0x77, 0x67, 0x70, 0xDB, 0x07, 0x76, 0x07, 0xB0, 0xA7, 0x60, 0x2B, 0x0B, 0x77,
  0x0B, 0xA0, 0xC7, 0x70, 0x6A, 0x0C, 0x01, 0x76, 0x01, 0xA0, 0xB8, 0x0D, 0x20, 0x08, 0xFB, 0x09,
  0x70, 0x8F, 0xB0, 0x97, 0x08, 0x80, 0x3E, 0xB0, 0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0,
  0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0,
  0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0,
  0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0,
  0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0,
  0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0,
  0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97, 0x85, 0x58, 0x9A,
  0xBC, 0xDD, 0x86, 0xED, 0xBA, 0x97, 0x4C, 0xFF, 0xB0, 0x90, 0xCF, 0xFB, 0x09,
  // "Ļ" (U+013B)
  0x06, 0xB0, 0x37, 0x50, 0x6B, 0x03, 0x75, 0x06, 0xB0, 0x37, 0x50, 0x6B, 0x03, 0x75, 0x06, 0xB0,
  0x37, 0x50, 0x6B, 0x03, 0x75, 0x06, 0xB0, 0x37, 0x50, 0x6B, 0x03, 0x75, 0x06, 0xB0, 0x37, 0x50,
  0x6B, 0x03, 0x75, 0x06, 0xB0, 0x37, 0x50, 0x6B, 0x03, 0x75, 0x06, 0xB0, 0x37, 0x50, 0x6B, 0x03,
  0x75, 0x06, 0xB0, 0x37, 0x50, 0x6B, 0x03, 0x75, 0x06, 0xB0, 0x37, 0x50, 0x6B, 0x03, 0x75, 0x06,
  0xB0, 0x37, 0x50, 0x6B, 0x03, 0x75, 0x06, 0xB0, 0x37, 0x50, 0x6B, 0x03, 0x75, 0x06, 0xB0, 0x37,
  0x50, 0x6B, 0x03, 0x75, 0x06, 0xB0, 0x37, 0x50, 0x6B, 0x03, 0x75, 0x06, 0xB8, 0x09, 0x0E, 0x08,
  0x06, 0xFF, 0x90, 0x90, 0x6F, 0xF9, 0x09, 0x80, 0xE6, 0x00, 0xBA, 0x0B, 0x76, 0x0E, 0xA0, 0x57,
  0x50, 0x3A, 0x0D, 0x76, 0x08, 0xA0, 0x47, 0x68, 0x1D, 0xFA, 0x76, 0x82, 0x3F, 0xD1, 0x71,
  // "ļ" (U+013C)
  0x08, 0xFB, 0x09, 0x70, 0x8F, 0xB0, 0x97, 0x08, 0x80, 0x3E, 0xB0, 0x97, 0x71, 0x0E, 0xA0, 0x97,
  0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97,
  0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97,
  0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97,
  0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97,
  0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97,
  0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97,
  0x85, 0x58, 0x9A, 0xBC, 0xDD, 0x86, 0xED, 0xBA, 0x97, 0x4C, 0xFF, 0xB0, 0x90, 0xCF, 0xFB, 0x09,
  0x80, 0xF5, 0x00, 0xBA, 0x0B, 0x77, 0x10, 0xEA, 0x05, 0x77, 0x03, 0xA0, 0xD7, 0x71, 0x08, 0xA0,
  0x47, 0x71, 0x81, 0xDF, 0xA7, 0x71, 0x82, 0x3F, 0xD1, 0x72,
  // "Ľ" (U+013D)
  0x06, 0xB0, 0x37, 0x06, 0xB0, 0x10, 0x6B, 0x03, 0x70, 0x8A, 0x81, 0xB0, 0x6B, 0x03, 0x70, 0xCA,
  0x81, 0x40, 0x6B, 0x03, 0x7A, 0x0C, 0x20, 0x6B, 0x03, 0x60, 0x4A, 0x03, 0x20, 0x6B, 0x03, 0x68,
  0x19, 0xF9, 0x30, 0x6B, 0x03, 0x75, 0x06, 0xB0, 0x37, 0x50, 0x6B, 0x03, 0x75, 0x06, 0xB0, 0x37,
  0x50, 0x6B, 0x03, 0x75, 0x06, 0xB0, 0x37, 0x50, 0x6B, 0x03, 0x75, 0x06, 0xB0, 0x37, 0x50, 0x6B,
  0x03, 0x75, 0x06, 0xB0, 0x37, 0x50, 0x6B, 0x03, 0x75, 0x06, 0xB0, 0x37, 0x50, 0x6B, 0x03, 0x75,
  0x06, 0xB0, 0x37, 0x50, 0x6B, 0x03, 0x75, 0x06, 0xB0, 0x37, 0x50, 0x6B, 0x03, 0x75, 0x06, 0xB0,
  0x37, 0x50, 0x6B, 0x03, 0x75, 0x06, 0xB0, 0x37, 0x50, 0x6B, 0x80, 0x90, 0xE0, 0x80, 0x6F, 0xF9,
  0x09, 0x06, 0xFF, 0x90, 0x90,
  // "ľ" (U+013E)
  0x08, 0xFB, 0x09, 0x4B, 0x06, 0x08, 0xFB, 0x09, 0x30, 0x3B, 0x01, 0x08, 0x80, 0x3E, 0xB0, 0x93,
  0x06, 0xA0, 0x97, 0x20, 0xEA, 0x09, 0x30, 0xAA, 0x02, 0x72, 0x0E, 0xA0, 0x93, 0x81, 0xEF, 0x97,
  0x30, 0xEA, 0x09, 0x28, 0x13, 0xFD, 0x74, 0x0E, 0xA0, 0x97, 0x72, 0x0E, 0xA0, 0x97, 0x72, 0x0E,
  0xA0, 0x97, 0x72, 0x0E, 0xA0, 0x97, 0x72, 0x0E, 0xA0, 0x97, 0x72, 0x0E, 0xA0, 0x97, 0x72, 0x0E,
  0xA0, 0x97, 0x72, 0x0E, 0xA0, 0x97, 0x72, 0x0E, 0xA0, 0x97, 0x72, 0x0E, 0xA0, 0x97, 0x72, 0x0E,
  0xA0, 0x97, 0x72, 0x0E, 0xA0, 0x97, 0x72, 0x0E, 0xA0, 0x97, 0x72, 0x0E, 0xA0, 0x97, 0x72, 0x0E,
  0xA0, 0x97, 0x72, 0x0E, 0xA0, 0x97, 0x72, 0x0E, 0xA0, 0x97, 0x72, 0x0E, 0xA0, 0x97, 0x72, 0x0E,
  0xA0, 0x97, 0x72, 0x0E, 0xA0, 0x97, 0x72, 0x0E, 0xA0, 0x97, 0x71, 0x01, 0x0E, 0xA0, 0xA7, 0x18,
  0x46, 0x9A, 0xBC, 0xEF, 0x86, 0xED, 0xBA, 0x94, 0x0C, 0xFF, 0xB8, 0x19, 0x0C, 0xFF, 0xB0, 0x91,
  // "Ŀ" (U+013F)
  0x06, 0xB0, 0x37, 0x50, 0x6B, 0x03, 0x75, 0x06, 0xB0, 0x37, 0x50, 0x6B, 0x03, 0x75, 0x06, 0xB0,
  0x37, 0x50, 0x6B, 0x03, 0x75, 0x06, 0xB0, 0x37, 0x50, 0x6B, 0x03, 0x75, 0x06, 0xB0, 0x37, 0x50,
  0x6B, 0x03, 0x75, 0x06, 0xB0, 0x37, 0x50, 0x6B, 0x03, 0x75, 0x06, 0xB0, 0x37, 0x84, 0x8E, 0xE8,
  0x06, 0xB0, 0x36, 0x04, 0xC0, 0x40, 0x6B, 0x03, 0x60, 0x6C, 0x00, 0x6B, 0x03, 0x60, 0x4C, 0x04,
  0x06, 0xB0, 0x37, 0x84, 0x8E, 0xE8, 0x06, 0xB0, 0x37, 0x50, 0x6B, 0x03, 0x75, 0x06, 0xB0, 0x37,
  0x50, 0x6B, 0x03, 0x75, 0x06, 0xB0, 0x37, 0x50, 0x6B, 0x03, 0x75, 0x06, 0xB0, 0x37, 0x50, 0x6B,
  0x03, 0x75, 0x06, 0xB0, 0x37, 0x50, 0x6B, 0x80, 0x90, 0xE0, 0x80, 0x6F, 0xF9, 0x09, 0x06, 0xFF,
  0x90, 0x90,
  // "ŀ" (U+0140)
  0x08, 0xFB, 0x09, 0x75, 0x08, 0xFB, 0x09, 0x75, 0x08, 0x80, 0x3E, 0xB0, 0x97, 0x76, 0x0E, 0xA0,
  0x97, 0x76, 0x0E, 0xA0, 0x97, 0x76, 0x0E, 0xA0, 0x97, 0x76, 0x0E, 0xA0, 0x97, 0x76, 0x0E, 0xA0,
  0x97, 0x76, 0x0E, 0xA0, 0x97, 0x76, 0x0E, 0xA0, 0x97, 0x76, 0x0E, 0xA0, 0x97, 0x76, 0x0E, 0xA0,
  0x97, 0x76, 0x0E, 0xA0, 0x97, 0x82, 0x8E, 0xE8, 0x72, 0x0E, 0xA0, 0x96, 0x04, 0xC0, 0x47, 0x10,
  0xEA, 0x09, 0x60, 0x6C, 0x06, 0x71, 0x0E, 0xA0, 0x96, 0x04, 0xC0, 0x47, 0x10, 0xEA, 0x09, 0x78,
  0x28, 0xEE, 0x87, 0x20, 0xEA, 0x09, 0x77, 0x60, 0xEA, 0x09, 0x77, 0x60, 0xEA, 0x09, 0x77, 0x60,
  0xEA, 0x09, 0x77, 0x60, 0xEA, 0x09, 0x77, 0x60, 0xEA, 0x09, 0x77, 0x60, 0xEA, 0x09, 0x77, 0x60,
  0xEA, 0x09, 0x77, 0x60, 0xEA, 0x09, 0x77, 0x60, 0xEA, 0x09, 0x77, 0x60, 0xEA, 0x09, 0x75, 0x85,
  0x58, 0x9A, 0xBC, 0xDD, 0x85, 0xED, 0xBA, 0x97, 0x45, 0x0C, 0xFF, 0xB0, 0x95, 0x0C, 0xFF, 0xB0,
  0x95,
  // "Ł" (U+0141)
  0x40, 0xCA, 0x0C, 0x77, 0x30, 0xCA, 0x0C, 0x77, 0x30, 0xCA, 0x0C, 0x77, 0x30, 0xCA, 0x0C, 0x77,
  0x30, 0xCA, 0x0C, 0x77, 0x30, 0xCA, 0x0C, 0x77, 0x30, 0xCA, 0x0C, 0x77, 0x30, 0xCA, 0x0C, 0x77,
  0x30, 0xCA, 0x0C, 0x77, 0x30, 0xCA, 0x0C, 0x77, 0x30, 0xCA, 0x0C, 0x40, 0x17, 0x50, 0xCA, 0x0C,
  0x28, 0x21, 0x9E, 0x17, 0x40, 0xCA, 0x82, 0xC0, 0x5E, 0xA0, 0x97, 0x40, 0xCA, 0x0D, 0x0B, 0xC0,
  0x97, 0x40, 0xCE, 0x0C, 0x03, 0x75, 0x0C, 0xC0, 0xE0, 0x67, 0x50, 0x20, 0xBC, 0x09, 0x01, 0x75,
  0x08, 0xD0, 0xC7, 0x60, 0x9E, 0x0C, 0x76, 0x02, 0xA0, 0x90, 0xDA, 0x0C, 0x77, 0x82, 0x63, 0x0C,
  0xA0, 0xC7, 0x73, 0x0C, 0xA0, 0xC7, 0x73, 0x0C, 0xA0, 0xC7, 0x73, 0x0C, 0xA0, 0xC7, 0x73, 0x0C,
  0xA0, 0xC7, 0x73, 0x0C, 0xA0, 0xC7, 0x73, 0x0C, 0xB8, 0x09, 0x0E, 0x02, 0x40, 0xCF, 0xF9, 0x03,
  0x40, 0xCF, 0xF9, 0x03,
  // "ł" (U+0142)
  0x08, 0xFB, 0x09, 0x70, 0x8F, 0xB0, 0x97, 0x08, 0x80, 0x3E, 0xB0, 0x97, 0x71, 0x0E, 0xA0, 0x97,
  0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97,
  0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x92,
  0x03, 0x02, 0x74, 0x0E, 0xA8, 0x39, 0x19, 0xFB, 0x74, 0x0E, 0xA0, 0xD0, 0xEB, 0x05, 0x73, 0x0E,
  0xD0, 0xE0, 0x67, 0x40, 0xEC, 0x0A, 0x01, 0x73, 0x03, 0x0D, 0xB0, 0xD0, 0x47, 0x30, 0x10, 0x9D,
  0x09, 0x73, 0x05, 0x0E, 0xE0, 0x97, 0x30, 0xEA, 0x81, 0xE6, 0xEA, 0x09, 0x73, 0x84, 0x5F, 0xA1,
  0x0E, 0xA0, 0x97, 0x40, 0x33, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97,
  0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x97,
  0x85, 0x58, 0x9A, 0xBC, 0xDD, 0x86, 0xED, 0xBA, 0x97, 0x4C, 0xFF, 0xB0, 0x90, 0xCF, 0xFB, 0x09,
  // "Ń" (U+0143)
  0x75, 0x83, 0x37, 0x77, 0x67, 0x71, 0x0D, 0xB0, 0x77, 0x70, 0x7B, 0x0A, 0x77, 0x02, 0xB0, 0xB7,
  0x71, 0x0B, 0xA0, 0xC7, 0x71, 0x06, 0xA0, 0xC0, 0x17, 0x70, 0x1A, 0x0B, 0x80, 0xD4, 0x00, 0x3C,
  0x0C, 0x72, 0x04, 0xB0, 0x03, 0xD0, 0x37, 0x10, 0x4B, 0x00, 0x3D, 0x09, 0x71, 0x04, 0xB0, 0x03,
  0xE0, 0x17, 0x04, 0xB0, 0x03, 0xA0, 0xC0, 0xDA, 0x07, 0x70, 0x4B, 0x00, 0x3A, 0x0D, 0x06, 0xA0,
  0xD7, 0x04, 0xB0, 0x03, 0xA8, 0x1E, 0x0E, 0xA0, 0x56, 0x04, 0xB0, 0x03, 0xB1, 0x08, 0xA0, 0xC6,
  0x04, 0xB0, 0x03, 0xB0, 0x01, 0xB0, 0x35, 0x04, 0xB0, 0x03, 0xB8, 0x12, 0x0A, 0xA0, 0x95, 0x04,
  0xB0, 0x03, 0xB8, 0x12, 0x03, 0xB0, 0x14, 0x04, 0xB0, 0x03, 0xB0, 0x32, 0x0C, 0xA0, 0x74, 0x04,
  0xB0, 0x03, 0xB0, 0x42, 0x05, 0xA0, 0xE4, 0x04, 0xB0, 0x03, 0xB0, 0x43, 0x0D, 0xA0, 0x53, 0x04,
  0xB0, 0x03, 0xB0, 0x43, 0x07, 0xA0, 0xC3, 0x04, 0xB0, 0x03, 0xB0, 0x43, 0x01, 0xB0, 0x32, 0x04,
  0xB0, 0x03, 0xB0, 0x44, 0x09, 0xA0, 0xA2, 0x04, 0xB0, 0x03, 0xB0, 0x44, 0x02, 0xB8, 0x11, 0x04,
  0xB0, 0x03, 0xB0, 0x45, 0x0B, 0xA8, 0x17, 0x03, 0xB0, 0x03, 0xB0, 0x45, 0x04, 0xA8, 0x1E, 0x03,
  0xB0, 0x03, 0xB0, 0x46, 0x0D, 0xA0, 0x50, 0x2B, 0x00, 0x3B, 0x04, 0x60, 0x6A, 0x0C, 0x01, 0xB0,
  0x03, 0xB0, 0x47, 0x0E, 0xA0, 0x4B, 0x00, 0x3B, 0x04, 0x70, 0x8A, 0x0A, 0xB0, 0x03, 0xB0, 0x47,
  0x02, 0xE0, 0x03, 0xB0, 0x47, 0x10, 0xAD, 0x00, 0x3B, 0x04, 0x71, 0x03, 0xD0, 0x03, 0xB0, 0x47,
  0x20, 0xCC, 0x00, 0x3B, 0x04, 0x72, 0x05, 0xC0, 0x30,
  // "ń" (U+0144)
  0x74, 0x83, 0x37, 0x77, 0x67, 0x60, 0xDB, 0x07, 0x75, 0x07, 0xB0, 0xA7, 0x50, 0x2B, 0x0B, 0x76,
  0x0B, 0xA0, 0xC7, 0x60, 0x6A, 0x0C, 0x01, 0x75, 0x01, 0xA0, 0xB8, 0x0C, 0x70, 0x0C, 0xA0, 0x22,
  0x87, 0x16, 0xBD, 0xFE, 0xC9, 0x23, 0x0C, 0xA8, 0x24, 0x06, 0xEF, 0x90, 0x82, 0x0C, 0xA0, 0x06,
  0xFC, 0x81, 0x80, 0xCA, 0x0B, 0xA0, 0xB0, 0x43, 0x02, 0x09, 0xC0, 0x20, 0xCC, 0x09, 0x70, 0x8B,
  0x08, 0x0C, 0xB0, 0xD7, 0x20, 0xEA, 0x00, 0xCB, 0x07, 0x72, 0x0B, 0xA0, 0xE0, 0xCB, 0x02, 0x72,
  0x09, 0xB0, 0xCB, 0x73, 0x09, 0xB0, 0xCA, 0x0D, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0,
  0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA,
  0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C,
  0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73,
  0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0,
  // "Ņ" (U+0145)
  0x03, 0xC0, 0xC7, 0x20, 0x4B, 0x00, 0x3D, 0x03, 0x71, 0x04, 0xB0, 0x03, 0xD0, 0x97, 0x10, 0x4B,
  0x00, 0x3E, 0x01, 0x70, 0x4B, 0x00, 0x3A, 0x0C, 0x0D, 0xA0, 0x77, 0x04, 0xB0, 0x03, 0xA0, 0xD0,
  0x6A, 0x0D, 0x70, 0x4B, 0x00, 0x3A, 0x81, 0xE0, 0xEA, 0x05, 0x60, 0x4B, 0x00, 0x3B, 0x10, 0x8A,
  0x0C, 0x60, 0x4B, 0x00, 0x3B, 0x00, 0x1B, 0x03, 0x50, 0x4B, 0x00, 0x3B, 0x81, 0x20, 0xAA, 0x09,
  0x50, 0x4B, 0x00, 0x3B, 0x81, 0x20, 0x3B, 0x01, 0x40, 0x4B, 0x00, 0x3B, 0x03, 0x20, 0xCA, 0x07,
  0x40, 0x4B, 0x00, 0x3B, 0x04, 0x20, 0x5A, 0x0E, 0x40, 0x4B, 0x00, 0x3B, 0x04, 0x30, 0xDA, 0x05,
  0x30, 0x4B, 0x00, 0x3B, 0x04, 0x30, 0x7A, 0x0C, 0x30, 0x4B, 0x00, 0x3B, 0x04, 0x30, 0x1B, 0x03,
  0x20, 0x4B, 0x00, 0x3B, 0x04, 0x40, 0x9A, 0x0A, 0x20, 0x4B, 0x00, 0x3B, 0x04, 0x40, 0x2B, 0x81,
  0x10, 0x4B, 0x00, 0x3B, 0x04, 0x50, 0xBA, 0x81, 0x70, 0x3B, 0x00, 0x3B, 0x04, 0x50, 0x4A, 0x81,
  0xE0, 0x3B, 0x00, 0x3B, 0x04, 0x60, 0xDA, 0x05, 0x02, 0xB0, 0x03, 0xB0, 0x46, 0x06, 0xA0, 0xC0,
  0x1B, 0x00, 0x3B, 0x04, 0x70, 0xEA, 0x04, 0xB0, 0x03, 0xB0, 0x47, 0x08, 0xA0, 0xAB, 0x00, 0x3B,
  0x04, 0x70, 0x2E, 0x00, 0x3B, 0x04, 0x71, 0x0A, 0xD0, 0x03, 0xB0, 0x47, 0x10, 0x3D, 0x00, 0x3B,
  0x04, 0x72, 0x0C, 0xC0, 0x03, 0xB0, 0x47, 0x20, 0x5C, 0x03, 0x80, 0x98, 0x00, 0x0B, 0xA0, 0xB7,
  0x72, 0x0E, 0xA0, 0x57, 0x71, 0x03, 0xA0, 0xD7, 0x72, 0x08, 0xA0, 0x47, 0x72, 0x81, 0xDF, 0xA7,
  0x72, 0x82, 0x3F, 0xD1, 0x73,
  // "ņ" (U+0146)
  0x0C, 0xA0, 0x22, 0x87, 0x16, 0xBD, 0xFE, 0xC9, 0x23, 0x0C, 0xA8, 0x24, 0x06, 0xEF, 0x90, 0x82,
  0x0C, 0xA0, 0x06, 0xFC, 0x81, 0x80, 0xCA, 0x0B, 0xA0, 0xB0, 0x43, 0x02, 0x09, 0xC0, 0x20, 0xCC,
  0x09, 0x70, 0x8B, 0x08, 0x0C, 0xB0, 0xD7, 0x20, 0xEA, 0x00, 0xCB, 0x07, 0x72, 0x0B, 0xA0, 0xE0,
  0xCB, 0x02, 0x72, 0x09, 0xB0, 0xCB, 0x73, 0x09, 0xB0, 0xCA, 0x0D, 0x73, 0x09, 0xB0, 0xCA, 0x0C,
  0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73,
  0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09,
  0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0,
  0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB8, 0x0F, 0x10, 0x0B, 0xA0, 0xB7, 0x70,
  0xEA, 0x05, 0x76, 0x03, 0xA0, 0xD7, 0x70, 0x8A, 0x04, 0x77, 0x81, 0xDF, 0xA7, 0x78, 0x23, 0xFD,
  0x17, 0x20,
  // "Ň" (U+0147)
  0x38, 0x15, 0x77, 0x71, 0x81, 0x77, 0x56, 0x05, 0xA0, 0xC0, 0x24, 0x02, 0x0D, 0xA0, 0x57, 0x07,
  0xA0, 0xE0, 0x32, 0x04, 0x0E, 0xA0, 0x67, 0x20, 0x8A, 0x81, 0xE3, 0x4B, 0x07, 0x74, 0x0A, 0xA0,
  0xEB, 0x09, 0x76, 0x0C, 0xC0, 0xB7, 0x70, 0x2B, 0x0E, 0x01, 0x80, 0xD3, 0x00, 0x3C, 0x0C, 0x72,
  0x04, 0xB0, 0x03, 0xD0, 0x37, 0x10, 0x4B, 0x00, 0x3D, 0x09, 0x71, 0x04, 0xB0, 0x03, 0xE0, 0x17,
  0x04, 0xB0, 0x03, 0xA0, 0xC0, 0xDA, 0x07, 0x70, 0x4B, 0x00, 0x3A, 0x0D, 0x06, 0xA0, 0xD7, 0x04,
  0xB0, 0x03, 0xA8, 0x1E, 0x0E, 0xA0, 0x56, 0x04, 0xB0, 0x03, 0xB1, 0x08, 0xA0, 0xC6, 0x04, 0xB0,
  0x03, 0xB0, 0x01, 0xB0, 0x35, 0x04, 0xB0, 0x03, 0xB8, 0x12, 0x0A, 0xA0, 0x95, 0x04, 0xB0, 0x03,
  0xB8, 0x12, 0x03, 0xB0, 0x14, 0x04, 0xB0, 0x03, 0xB0, 0x32, 0x0C, 0xA0, 0x74, 0x04, 0xB0, 0x03,
  0xB0, 0x42, 0x05, 0xA0, 0xE4, 0x04, 0xB0, 0x03, 0xB0, 0x43, 0x0D, 0xA0, 0x53, 0x04, 0xB0, 0x03,
  0xB0, 0x43, 0x07, 0xA0, 0xC3, 0x04, 0xB0, 0x03, 0xB0, 0x43, 0x01, 0xB0, 0x32, 0x04, 0xB0, 0x03,
  0xB0, 0x44, 0x09, 0xA0, 0xA2, 0x04, 0xB0, 0x03, 0xB0, 0x44, 0x02, 0xB8, 0x11, 0x04, 0xB0, 0x03,
  0xB0, 0x45, 0x0B, 0xA8, 0x17, 0x03, 0xB0, 0x03, 0xB0, 0x45, 0x04, 0xA8, 0x1E, 0x03, 0xB0, 0x03,
  0xB0, 0x46, 0x0D, 0xA0, 0x50, 0x2B, 0x00, 0x3B, 0x04, 0x60, 0x6A, 0x0C, 0x01, 0xB0, 0x03, 0xB0,
  0x47, 0x0E, 0xA0, 0x4B, 0x00, 0x3B, 0x04, 0x70, 0x8A, 0x0A, 0xB0, 0x03, 0xB0, 0x47, 0x02, 0xE0,
  0x03, 0xB0, 0x47, 0x10, 0xAD, 0x00, 0x3B, 0x04, 0x71, 0x03, 0xD0, 0x03, 0xB0, 0x47, 0x20, 0xCC,
  0x00, 0x3B, 0x04, 0x72, 0x05, 0xC0, 0x30,
  // "ň" (U+0148)
  0x28, 0x15, 0x77, 0x71, 0x81, 0x77, 0x54, 0x05, 0xA0, 0xC0, 0x24, 0x02, 0x0D, 0xA0, 0x55, 0x07,
  0xA0, 0xE0, 0x32, 0x04, 0x0E, 0xA0, 0x67, 0x08, 0xA8, 0x1E, 0x34, 0xB0, 0x77, 0x20, 0xAA, 0x0E,
  0xB0, 0x97, 0x40, 0xCC, 0x0B, 0x75, 0x02, 0xB0, 0xE0, 0x18, 0x0C, 0x60, 0x0C, 0xA0, 0x22, 0x87,
  0x16, 0xBD, 0xFE, 0xC9, 0x23, 0x0C, 0xA8, 0x24, 0x06, 0xEF, 0x90, 0x82, 0x0C, 0xA0, 0x06, 0xFC,
  0x81, 0x80, 0xCA, 0x0B, 0xA0, 0xB0, 0x43, 0x02, 0x09, 0xC0, 0x20, 0xCC, 0x09, 0x70, 0x8B, 0x08,
  0x0C, 0xB0, 0xD7, 0x20, 0xEA, 0x00, 0xCB, 0x07, 0x72, 0x0B, 0xA0, 0xE0, 0xCB, 0x02, 0x72, 0x09,
  0xB0, 0xCB, 0x73, 0x09, 0xB0, 0xCA, 0x0D, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA,
  0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C,
  0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73,
  0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09,
  0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0,
  // "ŉ" (U+0149)
  0x10, 0x1C, 0x03, 0x77, 0x30, 0x4C, 0x01, 0x77, 0x30, 0x6B, 0x0C, 0x77, 0x40, 0x9B, 0x07, 0x77,
  0x40, 0xCB, 0x01, 0x77, 0x4B, 0x0B, 0x77, 0x40, 0x3B, 0x05, 0x77, 0x40, 0x6A, 0x81, 0xE0, 0x3A,
  0x0B, 0x38, 0x64, 0xAD, 0xEE, 0xD9, 0x33, 0x0A, 0xA8, 0x18, 0x03, 0xA8, 0x2D, 0x01, 0xBF, 0x90,
  0x92, 0x0D, 0xA8, 0x12, 0x03, 0xB0, 0x10, 0xCF, 0xB0, 0x96, 0x03, 0xB0, 0xBA, 0x08, 0x02, 0x20,
  0x30, 0xAC, 0x03, 0x50, 0x3D, 0x03, 0x60, 0x9B, 0x09, 0x50, 0x3C, 0x07, 0x70, 0x1B, 0x0C, 0x50,
  0x3C, 0x01, 0x71, 0x0B, 0xA0, 0xE5, 0x03, 0xB0, 0xB7, 0x20, 0x9B, 0x50, 0x3B, 0x09, 0x72, 0x09,
  0xB5, 0x03, 0xB0, 0x77, 0x20, 0x9B, 0x50, 0x3B, 0x06, 0x72, 0x09, 0xB5, 0x03, 0xB0, 0x67, 0x20,
  0x9B, 0x50, 0x3B, 0x06, 0x72, 0x09, 0xB5, 0x03, 0xB0, 0x67, 0x20, 0x9B, 0x50, 0x3B, 0x06, 0x72,
  0x09, 0xB5, 0x03, 0xB0, 0x67, 0x20, 0x9B, 0x50, 0x3B, 0x06, 0x72, 0x09, 0xB5, 0x03, 0xB0, 0x67,
  0x20, 0x9B, 0x50, 0x3B, 0x06, 0x72, 0x09, 0xB5, 0x03, 0xB0, 0x67, 0x20, 0x9B, 0x50, 0x3B, 0x06,
  0x72, 0x09, 0xB5, 0x03, 0xB0, 0x67, 0x20, 0x9B,
  // "Ŋ" (U+014A)
  0x03, 0xC0, 0xC7, 0x20, 0x4B, 0x00, 0x3D, 0x03, 0x71, 0x04, 0xB0, 0x03, 0xD0, 0x97, 0x10, 0x4B,
  0x00, 0x3E, 0x01, 0x70, 0x4B, 0x00, 0x3A, 0x0C, 0x0D, 0xA0, 0x77, 0x04, 0xB0, 0x03, 0xA0, 0xD0,
  0x6A, 0x0D, 0x70, 0x4B, 0x00, 0x3A, 0x81, 0xE0, 0xEA, 0x05, 0x60, 0x4B, 0x00, 0x3B, 0x10, 0x8A,
  0x0C, 0x60, 0x4B, 0x00, 0x3B, 0x00, 0x1B, 0x03, 0x50, 0x4B, 0x00, 0x3B, 0x81, 0x20, 0xAA, 0x09,
  0x50, 0x4B, 0x00, 0x3B, 0x81, 0x20, 0x3B, 0x01, 0x40, 0x4B, 0x00, 0x3B, 0x03, 0x20, 0xCA, 0x07,
  0x40, 0x4B, 0x00, 0x3B, 0x04, 0x20, 0x5A, 0x0E, 0x40, 0x4B, 0x00, 0x3B, 0x04, 0x30, 0xDA, 0x05,
  0x30, 0x4B, 0x00, 0x3B, 0x04, 0x30, 0x7A, 0x0C, 0x30, 0x4B, 0x00, 0x3B, 0x04, 0x30, 0x1B, 0x03,
  0x20, 0x4B, 0x00, 0x3B, 0x04, 0x40, 0x9A, 0x0A, 0x20, 0x4B, 0x00, 0x3B, 0x04, 0x40, 0x2B, 0x81,
  0x10, 0x4B, 0x00, 0x3B, 0x04, 0x50, 0xBA, 0x81, 0x70, 0x3B, 0x00, 0x3B, 0x04, 0x50, 0x4A, 0x81,
  0xE0, 0x3B, 0x00, 0x3B, 0x04, 0x60, 0xDA, 0x05, 0x02, 0xB0, 0x03, 0xB0, 0x46, 0x06, 0xA0, 0xC0,
  0x1B, 0x00, 0x3B, 0x04, 0x70, 0xEA, 0x04, 0xB0, 0x03, 0xB0, 0x47, 0x08, 0xA0, 0xAB, 0x00, 0x3B,
  0x04, 0x70, 0x2E, 0x00, 0x3B, 0x04, 0x71, 0x0A, 0xD0, 0x03, 0xB0, 0x47, 0x10, 0x3D, 0x00, 0x3B,
  0x04, 0x72, 0x0C, 0xC0, 0x03, 0xB0, 0x47, 0x20, 0x5C, 0x03, 0x77, 0x10, 0x3B, 0x02, 0x77, 0x10,
  0x4B, 0x01, 0x77, 0x10, 0x8A, 0x0E, 0x77, 0x10, 0x20, 0xEA, 0x0A, 0x72, 0x01, 0x02, 0x30, 0x50,
  0xDB, 0x03, 0x72, 0x05, 0xA0, 0xED, 0x09, 0x73, 0x05, 0xF0, 0x87, 0x48, 0x63, 0xBE, 0xFE, 0xC9,
  0x24,
  // "ŋ" (U+014B)
  0x0C, 0xA0, 0x22, 0x87, 0x16, 0xBD, 0xFE, 0xC9, 0x23, 0x0C, 0xA8, 0x24, 0x06, 0xEF, 0x90, 0x82,
  0x0C, 0xA0, 0x06, 0xFC, 0x81, 0x80, 0xCA, 0x0B, 0xA0, 0xB0, 0x43, 0x02, 0x09, 0xC0, 0x20, 0xCC,
  0x09, 0x70, 0x8B, 0x08, 0x0C, 0xB0, 0xD7, 0x20, 0xEA, 0x00, 0xCB, 0x07, 0x72, 0x0B, 0xA0, 0xE0,
  0xCB, 0x02, 0x72, 0x09, 0xB0, 0xCB, 0x73, 0x09, 0xB0, 0xCA, 0x0D, 0x73, 0x09, 0xB0, 0xCA, 0x0C,
  0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73,
  0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09,
  0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB0,
  0xCA, 0x0C, 0x73, 0x09, 0xB0, 0xCA, 0x0C, 0x73, 0x09, 0xB7, 0x70, 0x9B, 0x77, 0x09, 0xB7, 0x70,
  0x9B, 0x77, 0x09, 0xB7, 0x70, 0xAA, 0x0E, 0x77, 0x0D, 0xA0, 0xC7, 0x28, 0x32, 0x10, 0x19, 0xB0,
  0x87, 0x20, 0x9E, 0x0E, 0x01, 0x72, 0x09, 0xE0, 0x57, 0x30, 0x60, 0xDA, 0x81, 0xD9, 0x22,
  // "Ō" (U+014C)
  0x50, 0xD8, 0x06, 0xE0, 0xD7, 0x30, 0xEF, 0xB0, 0xE7, 0x30, 0xEF, 0xB0, 0xE8, 0x09, 0x92, 0x08,
  0x76, 0xAD, 0xEF, 0xDB, 0x61, 0x74, 0x05, 0x0E, 0xF9, 0x0E, 0x05, 0x72, 0x07, 0xFD, 0x08, 0x70,
  0x5B, 0x81, 0xE7, 0x22, 0x81, 0x17, 0xEB, 0x06, 0x50, 0x10, 0xEA, 0x0D, 0x02, 0x60, 0x10, 0xDA,
  0x0E, 0x01, 0x40, 0x8B, 0x04, 0x71, 0x03, 0xB0, 0x94, 0x0E, 0xA0, 0xC7, 0x30, 0xBA, 0x0E, 0x30,
  0x4B, 0x06, 0x73, 0x05, 0xB0, 0x42, 0x08, 0xB0, 0x17, 0x30, 0x1B, 0x08, 0x20, 0xBA, 0x0D, 0x75,
  0x0D, 0xA0, 0xC2, 0x0E, 0xA0, 0xB7, 0x50, 0xBA, 0x0E, 0x2B, 0x09, 0x75, 0x09, 0xB1, 0x02, 0xB0,
  0x87, 0x50, 0x8B, 0x00, 0x2B, 0x08, 0x75, 0x08, 0xB0, 0x20, 0x3B, 0x07, 0x75, 0x07, 0xB0, 0x30,
  0x2B, 0x08, 0x75, 0x08, 0xB0, 0x02, 0xB0, 0x87, 0x50, 0x8B, 0x01, 0x1B, 0x09, 0x75, 0x09, 0xB2,
  0x0E, 0xA0, 0xB7, 0x50, 0xBA, 0x0E, 0x20, 0xBA, 0x0D, 0x75, 0x0D, 0xA0, 0xB2, 0x08, 0xB0, 0x17,
  0x30, 0x1B, 0x08, 0x20, 0x4B, 0x05, 0x73, 0x05, 0xB0, 0x43, 0x0E, 0xA0, 0xB7, 0x30, 0xBA, 0x0E,
  0x40, 0x9B, 0x04, 0x71, 0x03, 0xB0, 0x84, 0x01, 0x0E, 0xA0, 0xD0, 0x26, 0x02, 0x0D, 0xA0, 0xE0,
  0x15, 0x06, 0xB8, 0x1E, 0x72, 0x28, 0x11, 0x7E, 0xB0, 0x57, 0x08, 0xFD, 0x07, 0x72, 0x06, 0x0E,
  0xF9, 0x0E, 0x05, 0x74, 0x82, 0x16, 0xBD, 0xA8, 0x1D, 0xA6, 0x70,
  // "ō" (U+014D)
  0x40, 0xD8, 0x06, 0xE0, 0xD7, 0x10, 0xEF, 0xB0, 0xE7, 0x10, 0xEF, 0xB0, 0xE8, 0x09, 0x81, 0x08,
  0x21, 0x7B, 0xDA, 0x81, 0xDA, 0x67, 0x30, 0x8F, 0xA0, 0xE0, 0x67, 0x0B, 0xFD, 0x0A, 0x50, 0xAB,
  0x81, 0xD6, 0x12, 0x81, 0x16, 0xEB, 0x09, 0x30, 0x5B, 0x0C, 0x70, 0x10, 0xDB, 0x04, 0x20, 0xCA,
  0x0E, 0x01, 0x71, 0x02, 0xB8, 0x1C, 0x03, 0xB0, 0x87, 0x30, 0x9B, 0x02, 0x07, 0xB0, 0x37, 0x30,
  0x4B, 0x06, 0x09, 0xB7, 0x40, 0x1B, 0x09, 0x0B, 0xA0, 0xD7, 0x50, 0xEA, 0x0B, 0x0C, 0xA0, 0xC7,
  0x50, 0xDA, 0x0B, 0x0C, 0xA0, 0xC7, 0x50, 0xDA, 0x0C, 0x0B, 0xA0, 0xD7, 0x50, 0xEA, 0x0B, 0x09,
  0xB7, 0x40, 0x1B, 0x09, 0x06, 0xB0, 0x37, 0x30, 0x4B, 0x06, 0x02, 0xB0, 0x87, 0x30, 0x9B, 0x81,
  0x20, 0xBB, 0x01, 0x71, 0x02, 0xB0, 0xC2, 0x04, 0xB0, 0xC0, 0x16, 0x01, 0x0D, 0xB0, 0x43, 0x09,
  0xB8, 0x1D, 0x61, 0x28, 0x11, 0x6E, 0xB0, 0x95, 0x0A, 0xFD, 0x0B, 0x70, 0x70, 0xEF, 0x90, 0xE0,
  0x77, 0x28, 0x21, 0x6B, 0xDA, 0x82, 0xDB, 0x61, 0x50,
  // "Ŏ" (U+014E)
  0x48, 0x21, 0x77, 0x16, 0x82, 0x17, 0x71, 0x71, 0x01, 0xA0, 0x86, 0x08, 0xA0, 0x17, 0x20, 0xCA,
  0x08, 0x02, 0x20, 0x20, 0x8A, 0x0C, 0x73, 0x04, 0xFB, 0x04, 0x74, 0x06, 0xF9, 0x06, 0x76, 0x86,
  0x39, 0xDF, 0xED, 0x92, 0x80, 0xE6, 0x08, 0x76, 0xAD, 0xEF, 0xDB, 0x61, 0x74, 0x05, 0x0E, 0xF9,
  0x0E, 0x05, 0x72, 0x07, 0xFD, 0x08, 0x70, 0x5B, 0x81, 0xE7, 0x22, 0x81, 0x17, 0xEB, 0x06, 0x50,
  0x10, 0xEA, 0x0D, 0x02, 0x60, 0x10, 0xDA, 0x0E, 0x01, 0x40, 0x8B, 0x04, 0x71, 0x03, 0xB0, 0x94,
  0x0E, 0xA0, 0xC7, 0x30, 0xBA, 0x0E, 0x30, 0x4B, 0x06, 0x73, 0x05, 0xB0, 0x42, 0x08, 0xB0, 0x17,
  0x30, 0x1B, 0x08, 0x20, 0xBA, 0x0D, 0x75, 0x0D, 0xA0, 0xC2, 0x0E, 0xA0, 0xB7, 0x50, 0xBA, 0x0E,
  0x2B, 0x09, 0x75, 0x09, 0xB1, 0x02, 0xB0, 0x87, 0x50, 0x8B, 0x00, 0x2B, 0x08, 0x75, 0x08, 0xB0,
  0x20, 0x3B, 0x07, 0x75, 0x07, 0xB0, 0x30, 0x2B, 0x08, 0x75, 0x08, 0xB0, 0x02, 0xB0, 0x87, 0x50,
  0x8B, 0x01, 0x1B, 0x09, 0x75, 0x09, 0xB2, 0x0E, 0xA0, 0xB7, 0x50, 0xBA, 0x0E, 0x20, 0xBA, 0x0D,
  0x75, 0x0D, 0xA0, 0xB2, 0x08, 0xB0, 0x17, 0x30, 0x1B, 0x08, 0x20, 0x4B, 0x05, 0x73, 0x05, 0xB0,
  0x43, 0x0E, 0xA0, 0xB7, 0x30, 0xBA, 0x0E, 0x40, 0x9B, 0x04, 0x71, 0x03, 0xB0, 0x84, 0x01, 0x0E,
  0xA0, 0xD0, 0x26, 0x02, 0x0D, 0xA0, 0xE0, 0x15, 0x06, 0xB8, 0x1E, 0x72, 0x28, 0x11, 0x7E, 0xB0,
  0x57, 0x08, 0xFD, 0x07, 0x72, 0x06, 0x0E, 0xF9, 0x0E, 0x05, 0x74, 0x82, 0x16, 0xBD, 0xA8, 0x1D,
  0xA6, 0x70,
  // "ŏ" (U+014F)
  0x38, 0x21, 0x77, 0x16, 0x82, 0x17, 0x71, 0x60, 0x1A, 0x08, 0x60, 0x8A, 0x01, 0x70, 0xCA, 0x08,
  0x02, 0x20, 0x20, 0x8A, 0x0C, 0x71, 0x04, 0xFB, 0x04, 0x72, 0x06, 0xF9, 0x06, 0x74, 0x86, 0x39,
  0xDF, 0xED, 0x92, 0x80, 0xD7, 0x08, 0x21, 0x7B, 0xDA, 0x81, 0xDA, 0x67, 0x30, 0x8F, 0xA0, 0xE0,
  0x67, 0x0B, 0xFD, 0x0A, 0x50, 0xAB, 0x81, 0xD6, 0x12, 0x81, 0x16, 0xEB, 0x09, 0x30, 0x5B, 0x0C,
  0x70, 0x10, 0xDB, 0x04, 0x20, 0xCA, 0x0E, 0x01, 0x71, 0x02, 0xB8, 0x1C, 0x03, 0xB0, 0x87, 0x30,
  0x9B, 0x02, 0x07, 0xB0, 0x37, 0x30, 0x4B, 0x06, 0x09, 0xB7, 0x40, 0x1B, 0x09, 0x0B, 0xA0, 0xD7,
  0x50, 0xEA, 0x0B, 0x0C, 0xA0, 0xC7, 0x50, 0xDA, 0x0B, 0x0C, 0xA0, 0xC7, 0x50, 0xDA, 0x0C, 0x0B,
  0xA0, 0xD7, 0x50, 0xEA, 0x0B, 0x09, 0xB7, 0x40, 0x1B, 0x09, 0x06, 0xB0, 0x37, 0x30, 0x4B, 0x06,
  0x02, 0xB0, 0x87, 0x30, 0x9B, 0x81, 0x20, 0xBB, 0x01, 0x71, 0x02, 0xB0, 0xC2, 0x04, 0xB0, 0xC0,
  0x16, 0x01, 0x0D, 0xB0, 0x43, 0x09, 0xB8, 0x1D, 0x61, 0x28, 0x11, 0x6E, 0xB0, 0x95, 0x0A, 0xFD,
  0x0B, 0x70, 0x70, 0xEF, 0x90, 0xE0, 0x77, 0x28, 0x21, 0x6B, 0xDA, 0x82, 0xDB, 0x61, 0x50,
  // "Ő" (U+0150)
  0x70, 0x9B, 0x06, 0x20, 0x8B, 0x06, 0x72, 0x02, 0xB0, 0xB2, 0x02, 0xB0, 0xB7, 0x30, 0xBA, 0x0C,
  0x30, 0xBA, 0x0C, 0x01, 0x72, 0x05, 0xA0, 0xD0, 0x12, 0x05, 0xA0, 0xD0, 0x17, 0x28, 0x31, 0xEF,
  0xD1, 0x28, 0x31, 0xEF, 0xD1, 0x73, 0x82, 0xAF, 0xB1, 0x38, 0x2A, 0xFB, 0x18, 0x0E, 0x60, 0x87,
  0x6A, 0xDE, 0xFD, 0xB6, 0x17, 0x40, 0x50, 0xEF, 0x90, 0xE0, 0x57, 0x20, 0x7F, 0xD0, 0x87, 0x05,
  0xB8, 0x1E, 0x72, 0x28, 0x11, 0x7E, 0xB0, 0x65, 0x01, 0x0E, 0xA0, 0xD0, 0x26, 0x01, 0x0D, 0xA0,
  0xE0, 0x14, 0x08, 0xB0, 0x47, 0x10, 0x3B, 0x09, 0x40, 0xEA, 0x0C, 0x73, 0x0B, 0xA0, 0xE3, 0x04,
  0xB0, 0x67, 0x30, 0x5B, 0x04, 0x20, 0x8B, 0x01, 0x73, 0x01, 0xB0, 0x82, 0x0B, 0xA0, 0xD7, 0x50,
  0xDA, 0x0C, 0x20, 0xEA, 0x0B, 0x75, 0x0B, 0xA0, 0xE2, 0xB0, 0x97, 0x50, 0x9B, 0x10, 0x2B, 0x08,
  0x75, 0x08, 0xB0, 0x02, 0xB0, 0x87, 0x50, 0x8B, 0x02, 0x03, 0xB0, 0x77, 0x50, 0x7B, 0x03, 0x02,
  0xB0, 0x87, 0x50, 0x8B, 0x00, 0x2B, 0x08, 0x75, 0x08, 0xB0, 0x11, 0xB0, 0x97, 0x50, 0x9B, 0x20,
  0xEA, 0x0B, 0x75, 0x0B, 0xA0, 0xE2, 0x0B, 0xA0, 0xD7, 0x50, 0xDA, 0x0B, 0x20, 0x8B, 0x01, 0x73,
  0x01, 0xB0, 0x82, 0x04, 0xB0, 0x57, 0x30, 0x5B, 0x04, 0x30, 0xEA, 0x0B, 0x73, 0x0B, 0xA0, 0xE4,
  0x09, 0xB0, 0x47, 0x10, 0x3B, 0x08, 0x40, 0x10, 0xEA, 0x0D, 0x02, 0x60, 0x20, 0xDA, 0x0E, 0x01,
  0x50, 0x6B, 0x81, 0xE7, 0x22, 0x81, 0x17, 0xEB, 0x05, 0x70, 0x8F, 0xD0, 0x77, 0x20, 0x60, 0xEF,
  0x90, 0xE0, 0x57, 0x48, 0x21, 0x6B, 0xDA, 0x81, 0xDA, 0x67,
  // "ő" (U+0151)
  0x60, 0x9B, 0x06, 0x20, 0x8B, 0x06, 0x70, 0x2B, 0x0B, 0x20, 0x2B, 0x0B, 0x71, 0x0B, 0xA0, 0xC3,
  0x0B, 0xA0, 0xC0, 0x17, 0x05, 0xA0, 0xD0, 0x12, 0x05, 0xA0, 0xD0, 0x17, 0x83, 0x1E, 0xFD, 0x12,
  0x83, 0x1E, 0xFD, 0x17, 0x18, 0x2A, 0xFB, 0x13, 0x82, 0xAF, 0xB1, 0x80, 0xD7, 0x08, 0x21, 0x7B,
  0xDA, 0x81, 0xDA, 0x67, 0x30, 0x8F, 0xA0, 0xE0, 0x67, 0x0B, 0xFD, 0x0A, 0x50, 0xAB, 0x81, 0xD6,
  0x12, 0x81, 0x16, 0xEB, 0x09, 0x30, 0x5B, 0x0C, 0x70, 0x10, 0xDB, 0x04, 0x20, 0xCA, 0x0E, 0x01,
  0x71, 0x02, 0xB8, 0x1C, 0x03, 0xB0, 0x87, 0x30, 0x9B, 0x02, 0x07, 0xB0, 0x37, 0x30, 0x4B, 0x06,
  0x09, 0xB7, 0x40, 0x1B, 0x09, 0x0B, 0xA0, 0xD7, 0x50, 0xEA, 0x0B, 0x0C, 0xA0, 0xC7, 0x50, 0xDA,
  0x0B, 0x0C, 0xA0, 0xC7, 0x50, 0xDA, 0x0C, 0x0B, 0xA0, 0xD7, 0x50, 0xEA, 0x0B, 0x09, 0xB7, 0x40,
  0x1B, 0x09, 0x06, 0xB0, 0x37, 0x30, 0x4B, 0x06, 0x02, 0xB0, 0x87, 0x30, 0x9B, 0x81, 0x20, 0xBB,
  0x01, 0x71, 0x02, 0xB0, 0xC2, 0x04, 0xB0, 0xC0, 0x16, 0x01, 0x0D, 0xB0, 0x43, 0x09, 0xB8, 0x1D,
  0x61, 0x28, 0x11, 0x6E, 0xB0, 0x95, 0x0A, 0xFD, 0x0B, 0x70, 0x70, 0xEF, 0x90, 0xE0, 0x77, 0x28,
  0x21, 0x6B, 0xDA, 0x82, 0xDB, 0x61, 0x50,
  // "Œ" (U+0152)
  0x58, 0x22, 0x8D, 0xEF, 0xD0, 0xC4, 0x07, 0xFF, 0xA0, 0xC3, 0x06, 0xFC, 0x80, 0x2E, 0x0B, 0x20,
  0x2B, 0x0D, 0x04, 0x20, 0x10, 0xAA, 0x0D, 0x72, 0x0A, 0xA0, 0xE0, 0x24, 0x09, 0xA0, 0xD7, 0x10,
  0x2B, 0x09, 0x50, 0x9A, 0x0D, 0x71, 0x07, 0xB0, 0x35, 0x09, 0xA0, 0xD7, 0x10, 0xAA, 0x0E, 0x60,
  0x9A, 0x0D, 0x71, 0x0E, 0xA0, 0xB6, 0x09, 0xA0, 0xD7, 0x01, 0xB0, 0x96, 0x09, 0xA0, 0xD7, 0x03,
  0xB0, 0x76, 0x09, 0xA0, 0xD7, 0x04, 0xB0, 0x56, 0x09, 0xA0, 0xD7, 0x05, 0xB0, 0x56, 0x09, 0xB8,
  0x02, 0xE1, 0x06, 0xB0, 0x46, 0x09, 0xFA, 0x10, 0x6B, 0x04, 0x60, 0x9F, 0xA1, 0x05, 0xB0, 0x46,
  0x09, 0xA0, 0xD7, 0x05, 0xB0, 0x56, 0x09, 0xA0, 0xD7, 0x04, 0xB0, 0x66, 0x09, 0xA0, 0xD7, 0x03,
  0xB0, 0x76, 0x09, 0xA0, 0xD7, 0x01, 0xB0, 0x96, 0x09, 0xA0, 0xD7, 0x10, 0xEA, 0x0B, 0x60, 0x9A,
  0x0D, 0x71, 0x0B, 0xA0, 0xE6, 0x09, 0xA0, 0xD7, 0x10, 0x7B, 0x03, 0x50, 0x9A, 0x0D, 0x71, 0x02,
  0xB0, 0x95, 0x09, 0xA0, 0xD7, 0x20, 0xBA, 0x0E, 0x02, 0x40, 0x9A, 0x0D, 0x72, 0x03, 0xB0, 0xD0,
  0x43, 0x0A, 0xA0, 0xD7, 0x30, 0x8F, 0xC8, 0x02, 0xE0, 0xB4, 0x09, 0xFF, 0xA0, 0xC5, 0x81, 0x4A,
  0xEF, 0xE0, 0xC0,
  // "œ" (U+0153)
  0x48, 0x52, 0x9D, 0xFE, 0x92, 0x48, 0x47, 0xCF, 0xD8, 0x16, 0x05, 0xE0, 0xE0, 0x22, 0x0B, 0xD0,
  0xD5, 0x03, 0xF9, 0x81, 0xC0, 0x8F, 0x0A, 0x40, 0xBA, 0x83, 0xD3, 0x01, 0xAA, 0x07, 0xA8, 0x2D,
  0x20, 0x5B, 0x02, 0x20, 0x3B, 0x03, 0x40, 0xEC, 0x03, 0x30, 0x8A, 0x08, 0x20, 0x7A, 0x0B, 0x50,
  0x8B, 0x0C, 0x40, 0x3A, 0x0B, 0x20, 0xBA, 0x07, 0x50, 0x4B, 0x08, 0x5A, 0x0E, 0x20, 0xDA, 0x04,
  0x50, 0x2B, 0x06, 0x50, 0xDA, 0x01, 0x1B, 0x02, 0x6B, 0x04, 0x50, 0xCA, 0x02, 0x01, 0xB0, 0x16,
  0xFD, 0x02, 0x01, 0xB0, 0x16, 0x0E, 0xFC, 0x03, 0x01, 0xB0, 0x16, 0x0E, 0xA8, 0x05, 0xE0, 0x21,
  0xB0, 0x16, 0x0E, 0xA0, 0x47, 0x3B, 0x03, 0x6B, 0x05, 0x73, 0x0D, 0xA0, 0x55, 0x01, 0xB0, 0x67,
  0x30, 0xAA, 0x07, 0x50, 0x4B, 0x09, 0x73, 0x06, 0xA0, 0xC5, 0x08, 0xB0, 0xD7, 0x30, 0x1B, 0x04,
  0x40, 0xDC, 0x05, 0x73, 0x0A, 0xA8, 0x3E, 0x40, 0x1A, 0xA0, 0x8A, 0x0E, 0x06, 0x28, 0x21, 0x5C,
  0x63, 0x01, 0x0E, 0xF8, 0x1D, 0x08, 0xC0, 0xEB, 0x06, 0x40, 0x40, 0xED, 0x0E, 0x02, 0x20, 0xBE,
  0x0E, 0x04, 0x58, 0x52, 0x9D, 0xFD, 0x91, 0x48, 0x55, 0xCE, 0xEC, 0x71, 0x20,
  // "Ŕ" (U+0154)
  0x74, 0x83, 0x37, 0x77, 0x67, 0x71, 0x0D, 0xB0, 0x77, 0x70, 0x7B, 0x0A, 0x77, 0x02, 0xB0, 0xB7,
  0x71, 0x0B, 0xA0, 0xC7, 0x71, 0x06, 0xA0, 0xC0, 0x17, 0x70, 0x1A, 0x0B, 0x80, 0xD5, 0x00, 0x3F,
  0x83, 0xED, 0xB8, 0x47, 0x03, 0xFD, 0x0D, 0x04, 0x50, 0x3B, 0x80, 0x0E, 0xF0, 0x74, 0x03, 0xB0,
  0x64, 0x81, 0x15, 0xBC, 0x04, 0x30, 0x3B, 0x06, 0x70, 0x7B, 0x0C, 0x30, 0x3B, 0x06, 0x71, 0x0B,
  0xB0, 0x22, 0x03, 0xB0, 0x67, 0x10, 0x6B, 0x05, 0x20, 0x3B, 0x06, 0x71, 0x04, 0xB0, 0x72, 0x03,
  0xB0, 0x67, 0x10, 0x3B, 0x07, 0x20, 0x3B, 0x06, 0x71, 0x04, 0xB0, 0x62, 0x03, 0xB0, 0x67, 0x10,
  0x7B, 0x03, 0x20, 0x3B, 0x06, 0x71, 0x0D, 0xA0, 0xE3, 0x03, 0xB0, 0x67, 0x09, 0xB0, 0x73, 0x03,
  0xB0, 0x64, 0x81, 0x15, 0xCB, 0x0B, 0x40, 0x3B, 0x80, 0x0E, 0xE0, 0xB5, 0x03, 0xFC, 0x0D, 0x05,
  0x60, 0x3F, 0xC0, 0x67, 0x03, 0xB0, 0x64, 0x0C, 0xA0, 0xE0, 0x16, 0x03, 0xB0, 0x64, 0x04, 0xB0,
  0x86, 0x03, 0xB0, 0x65, 0x0A, 0xB0, 0x25, 0x03, 0xB0, 0x65, 0x02, 0xB0, 0xB5, 0x03, 0xB0, 0x66,
  0x08, 0xB0, 0x54, 0x03, 0xB0, 0x67, 0x0E, 0xA0, 0xD4, 0x03, 0xB0, 0x67, 0x06, 0xB0, 0x83, 0x03,
  0xB0, 0x67, 0x10, 0xCB, 0x02, 0x20, 0x3B, 0x06, 0x71, 0x03, 0xB0, 0xA2, 0x03, 0xB0, 0x67, 0x20,
  0xAB, 0x81, 0x40, 0x3B, 0x06, 0x72, 0x02, 0xB8, 0x1D, 0x03, 0xB0, 0x67, 0x30, 0x8B, 0x07,
  // "ŕ" (U+0155)
  0x77, 0x83, 0x37, 0x77, 0x67, 0x72, 0x0D, 0xB0, 0x77, 0x71, 0x07, 0xB0, 0xA7, 0x71, 0x02, 0xB0,
  0xB7, 0x72, 0x0B, 0xA0, 0xC7, 0x72, 0x06, 0xA0, 0xC0, 0x17, 0x71, 0x01, 0xA0, 0xB8, 0x0D, 0x60,
  0x0D, 0xF0, 0xE3, 0x81, 0x3A, 0xEA, 0x83, 0xDB, 0x60, 0xDF, 0x92, 0x06, 0xF8, 0x29, 0x09, 0xDF,
  0x02, 0x04, 0xC0, 0xEB, 0x05, 0x48, 0x11, 0x35, 0xB8, 0x45, 0xEF, 0xE6, 0x12, 0x81, 0x5D, 0x17,
  0xB8, 0x2D, 0xFE, 0x27, 0x7D, 0x03, 0x77, 0x1C, 0x0A, 0x77, 0x2C, 0x03, 0x77, 0x2B, 0x0E, 0x77,
  0x3B, 0x0C, 0x77, 0x3B, 0x0A, 0x77, 0x3B, 0x09, 0x77, 0x3B, 0x09, 0x77, 0x3B, 0x09, 0x77, 0x3B,
  0x09, 0x77, 0x3B, 0x09, 0x77, 0x3B, 0x09, 0x77, 0x3B, 0x09, 0x77, 0x3B, 0x09, 0x73, 0x84, 0x37,
  0x9A, 0xCD, 0xD8, 0x4E, 0xDB, 0xA8, 0x64, 0x08, 0xFF, 0x90, 0xD4, 0x08, 0xFF, 0x90, 0xD4,
  // "Ŗ" (U+0156)
  0x03, 0xF8, 0x3E, 0xDB, 0x84, 0x70, 0x3F, 0xD0, 0xD0, 0x45, 0x03, 0xB8, 0x00, 0xEF, 0x07, 0x40,
  0x3B, 0x06, 0x48, 0x11, 0x5B, 0xC0, 0x43, 0x03, 0xB0, 0x67, 0x07, 0xB0, 0xC3, 0x03, 0xB0, 0x67,
  0x10, 0xBB, 0x02, 0x20, 0x3B, 0x06, 0x71, 0x06, 0xB0, 0x52, 0x03, 0xB0, 0x67, 0x10, 0x4B, 0x07,
  0x20, 0x3B, 0x06, 0x71, 0x03, 0xB0, 0x72, 0x03, 0xB0, 0x67, 0x10, 0x4B, 0x06, 0x20, 0x3B, 0x06,
  0x71, 0x07, 0xB0, 0x32, 0x03, 0xB0, 0x67, 0x10, 0xDA, 0x0E, 0x30, 0x3B, 0x06, 0x70, 0x9B, 0x07,
  0x30, 0x3B, 0x06, 0x48, 0x11, 0x5C, 0xB0, 0xB4, 0x03, 0xB8, 0x00, 0xEE, 0x0B, 0x50, 0x3F, 0xC0,
  0xD0, 0x56, 0x03, 0xFC, 0x06, 0x70, 0x3B, 0x06, 0x40, 0xCA, 0x0E, 0x01, 0x60, 0x3B, 0x06, 0x40,
  0x4B, 0x08, 0x60, 0x3B, 0x06, 0x50, 0xAB, 0x02, 0x50, 0x3B, 0x06, 0x50, 0x2B, 0x0B, 0x50, 0x3B,
  0x06, 0x60, 0x8B, 0x05, 0x40, 0x3B, 0x06, 0x70, 0xEA, 0x0D, 0x40, 0x3B, 0x06, 0x70, 0x6B, 0x08,
  0x30, 0x3B, 0x06, 0x71, 0x0C, 0xB0, 0x22, 0x03, 0xB0, 0x67, 0x10, 0x3B, 0x0A, 0x20, 0x3B, 0x06,
  0x72, 0x0A, 0xB8, 0x14, 0x03, 0xB0, 0x67, 0x20, 0x2B, 0x81, 0xD0, 0x3B, 0x06, 0x73, 0x08, 0xB0,
  0x78, 0x09, 0x80, 0x00, 0xBA, 0x0B, 0x77, 0x20, 0xEA, 0x05, 0x77, 0x10, 0x3A, 0x0D, 0x77, 0x20,
  0x8A, 0x04, 0x77, 0x28, 0x1D, 0xFA, 0x77, 0x28, 0x23, 0xFD, 0x17, 0x30,
  // "ŗ" (U+0157)
  0x10, 0xDF, 0x0E, 0x38, 0x13, 0xAE, 0xA8, 0x3D, 0xB6, 0x0D, 0xF9, 0x20, 0x6F, 0x82, 0x90, 0x9D,
  0xF0, 0x20, 0x4C, 0x0E, 0xB0, 0x54, 0x81, 0x13, 0x5B, 0x84, 0x5E, 0xFE, 0x61, 0x28, 0x15, 0xD1,
  0x7B, 0x82, 0xDF, 0xE2, 0x77, 0xD0, 0x37, 0x71, 0xC0, 0xA7, 0x72, 0xC0, 0x37, 0x72, 0xB0, 0xE7,
  0x73, 0xB0, 0xC7, 0x73, 0xB0, 0xA7, 0x73, 0xB0, 0x97, 0x73, 0xB0, 0x97, 0x73, 0xB0, 0x97, 0x73,
  0xB0, 0x97, 0x73, 0xB0, 0x97, 0x73, 0xB0, 0x97, 0x73, 0xB0, 0x97, 0x73, 0xB0, 0x97, 0x38, 0x43,
  0x79, 0xAC, 0xDD, 0x84, 0xED, 0xBA, 0x86, 0x40, 0x8F, 0xF9, 0x0D, 0x40, 0x8F, 0xF9, 0x0D, 0x80,
  0x98, 0x60, 0x0B, 0xA0, 0xB7, 0x73, 0x0E, 0xA0, 0x57, 0x72, 0x03, 0xA0, 0xD7, 0x73, 0x08, 0xA0,
  0x47, 0x73, 0x81, 0xDF, 0xA7, 0x73, 0x82, 0x3F, 0xD1, 0x75,
  // "Ř" (U+0158)
  0x28, 0x15, 0x77, 0x71, 0x81, 0x77, 0x56, 0x05, 0xA0, 0xC0, 0x24, 0x02, 0x0D, 0xA0, 0x57, 0x07,
  0xA0, 0xE0, 0x32, 0x04, 0x0E, 0xA0, 0x67, 0x20, 0x8A, 0x81, 0xE3, 0x4B, 0x07, 0x74, 0x0A, 0xA0,
  0xEB, 0x09, 0x76, 0x0C, 0xC0, 0xB7, 0x70, 0x2B, 0x0E, 0x01, 0x80, 0xD4, 0x00, 0x3F, 0x83, 0xED,
  0xB8, 0x47, 0x03, 0xFD, 0x0D, 0x04, 0x50, 0x3B, 0x80, 0x0E, 0xF0, 0x74, 0x03, 0xB0, 0x64, 0x81,
  0x15, 0xBC, 0x04, 0x30, 0x3B, 0x06, 0x70, 0x7B, 0x0C, 0x30, 0x3B, 0x06, 0x71, 0x0B, 0xB0, 0x22,
  0x03, 0xB0, 0x67, 0x10, 0x6B, 0x05, 0x20, 0x3B, 0x06, 0x71, 0x04, 0xB0, 0x72, 0x03, 0xB0, 0x67,
  0x10, 0x3B, 0x07, 0x20, 0x3B, 0x06, 0x71, 0x04, 0xB0, 0x62, 0x03, 0xB0, 0x67, 0x10, 0x7B, 0x03,
  0x20, 0x3B, 0x06, 0x71, 0x0D, 0xA0, 0xE3, 0x03, 0xB0, 0x67, 0x09, 0xB0, 0x73, 0x03, 0xB0, 0x64,
  0x81, 0x15, 0xCB, 0x0B, 0x40, 0x3B, 0x80, 0x0E, 0xE0, 0xB5, 0x03, 0xFC, 0x0D, 0x05, 0x60, 0x3F,
  0xC0, 0x67, 0x03, 0xB0, 0x64, 0x0C, 0xA0, 0xE0, 0x16, 0x03, 0xB0, 0x64, 0x04, 0xB0, 0x86, 0x03,
  0xB0, 0x65, 0x0A, 0xB0, 0x25, 0x03, 0xB0, 0x65, 0x02, 0xB0, 0xB5, 0x03, 0xB0, 0x66, 0x08, 0xB0,
  0x54, 0x03, 0xB0, 0x67, 0x0E, 0xA0, 0xD4, 0x03, 0xB0, 0x67, 0x06, 0xB0, 0x83, 0x03, 0xB0, 0x67,
  0x10, 0xCB, 0x02, 0x20, 0x3B, 0x06, 0x71, 0x03, 0xB0, 0xA2, 0x03, 0xB0, 0x67, 0x20, 0xAB, 0x81,
  0x40, 0x3B, 0x06, 0x72, 0x02, 0xB8, 0x1D, 0x03, 0xB0, 0x67, 0x30, 0x8B, 0x07,
  // "ř" (U+0159)
  0x58, 0x15, 0x77, 0x71, 0x81, 0x77, 0x57, 0x05, 0xA0, 0xC0, 0x24, 0x02, 0x0D, 0xA0, 0x57, 0x10,
  0x7A, 0x0E, 0x03, 0x20, 0x40, 0xEA, 0x06, 0x73, 0x08, 0xA8, 0x1E, 0x34, 0xB0, 0x77, 0x50, 0xAA,
  0x0E, 0xB0, 0x97, 0x70, 0xCC, 0x0B, 0x77, 0x10, 0x2B, 0x0E, 0x01, 0x80, 0xD5, 0x00, 0xDF, 0x0E,
  0x38, 0x13, 0xAE, 0xA8, 0x3D, 0xB6, 0x0D, 0xF9, 0x20, 0x6F, 0x82, 0x90, 0x9D, 0xF0, 0x20, 0x4C,
  0x0E, 0xB0, 0x54, 0x81, 0x13, 0x5B, 0x84, 0x5E, 0xFE, 0x61, 0x28, 0x15, 0xD1, 0x7B, 0x82, 0xDF,
  0xE2, 0x77, 0xD0, 0x37, 0x71, 0xC0, 0xA7, 0x72, 0xC0, 0x37, 0x72, 0xB0, 0xE7, 0x73, 0xB0, 0xC7,
  0x73, 0xB0, 0xA7, 0x73, 0xB0, 0x97, 0x73, 0xB0, 0x97, 0x73, 0xB0, 0x97, 0x73, 0xB0, 0x97, 0x73,
  0xB0, 0x97, 0x73, 0xB0, 0x97, 0x73, 0xB0, 0x97, 0x73, 0xB0, 0x97, 0x38, 0x43, 0x79, 0xAC, 0xDD,
  0x84, 0xED, 0xBA, 0x86, 0x40, 0x8F, 0xF9, 0x0D, 0x40, 0x8F, 0xF9, 0x0D, 0x40,
  // "Ś" (U+015A)
  0x75, 0x83, 0x37, 0x77, 0x67, 0x70, 0xDB, 0x07, 0x76, 0x07, 0xB0, 0xA7, 0x60, 0x2B, 0x0B, 0x77,
  0x0B, 0xA0, 0xC7, 0x70, 0x6A, 0x0C, 0x01, 0x76, 0x01, 0xA0, 0xB8, 0x0D, 0x60, 0x89, 0x12, 0x8B,
  0xDE, 0xFE, 0xDA, 0x73, 0x60, 0x10, 0xAF, 0xC0, 0xE0, 0x43, 0x02, 0x0E, 0xFE, 0x03, 0x30, 0xDB,
  0x81, 0xC6, 0x13, 0x83, 0x36, 0xBF, 0xD3, 0x05, 0xB0, 0xA7, 0x20, 0x20, 0x43, 0x0A, 0xB0, 0x17,
  0x70, 0xDA, 0x0C, 0x77, 0x10, 0xEA, 0x0B, 0x77, 0x10, 0xDA, 0x0D, 0x77, 0x10, 0xBB, 0x03, 0x77,
  0x06, 0xB0, 0xE0, 0x37, 0x70, 0xDC, 0x09, 0x02, 0x75, 0x02, 0x0E, 0xD0, 0xA0, 0x37, 0x40, 0x20,
  0xCE, 0x0C, 0x05, 0x74, 0x05, 0x0D, 0xE0, 0xC0, 0x47, 0x40, 0x50, 0xCE, 0x09, 0x75, 0x04, 0x0B,
  0xD0, 0x97, 0x60, 0x30, 0xCC, 0x06, 0x77, 0x08, 0xB0, 0xC7, 0x71, 0x0C, 0xB7, 0x71, 0x09, 0xB0,
  0x27, 0x70, 0x8B, 0x01, 0x77, 0x0A, 0xB7, 0x70, 0x10, 0xEA, 0x82, 0xC0, 0x43, 0x74, 0x0B, 0xB8,
  0x66, 0x09, 0xFD, 0x95, 0x24, 0x81, 0x26, 0xDB, 0x0D, 0x20, 0x9F, 0x0E, 0xE0, 0xD0, 0x22, 0x06,
  0xFE, 0x0A, 0x01, 0x58, 0x34, 0x8A, 0xDE, 0xA8, 0x3E, 0xDA, 0x71, 0x50,
  // "ś" (U+015B)
  0x73, 0x83, 0x37, 0x77, 0x67, 0x40, 0xDB, 0x07, 0x73, 0x07, 0xB0, 0xA7, 0x30, 0x2B, 0x0B, 0x74,
  0x0B, 0xA0, 0xC7, 0x40, 0x6A, 0x0C, 0x01, 0x73, 0x01, 0xA0, 0xB8, 0x0C, 0x60, 0x82, 0x5A, 0xCE,
  0xA8, 0x2E, 0xC9, 0x54, 0x05, 0x0E, 0xFC, 0x81, 0x40, 0x6E, 0x0E, 0xE8, 0x11, 0x0E, 0xA8, 0x1E,
  0x62, 0x38, 0x51, 0x38, 0xDA, 0x04, 0xB0, 0x47, 0x28, 0x11, 0x06, 0xB0, 0x17, 0x40, 0x5B, 0x04,
  0x74, 0x01, 0xB0, 0xD0, 0x37, 0x40, 0x8C, 0x0A, 0x03, 0x73, 0x08, 0xD0, 0xC0, 0x57, 0x20, 0x30,
  0xBD, 0x0D, 0x07, 0x72, 0x03, 0x0A, 0xD0, 0xE0, 0x67, 0x28, 0x12, 0x9E, 0xC0, 0x97, 0x30, 0x10,
  0x8C, 0x04, 0x74, 0x04, 0xB0, 0x97, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA8, 0x1B, 0x51, 0x72, 0x03,
  0xB8, 0x48, 0xCF, 0xB6, 0x34, 0x81, 0x26, 0xEB, 0x03, 0x0C, 0xE0, 0xEE, 0x81, 0x80, 0xAF, 0xC0,
  0xE0, 0x73, 0x83, 0x27, 0xAC, 0xEA, 0x83, 0xED, 0xA6, 0x13,
  // "Ŝ" (U+015C)
  0x71, 0x80, 0x07, 0x77, 0x07, 0xC0, 0x67, 0x50, 0x4D, 0x0E, 0x02, 0x73, 0x02, 0x0E, 0xA0, 0x80,
  0xAA, 0x0D, 0x01, 0x71, 0x01, 0x0D, 0xA0, 0x72, 0x0A, 0xA0, 0xC7, 0x10, 0xBA, 0x07, 0x40, 0x9A,
  0x0B, 0x68, 0x29, 0xFE, 0x56, 0x06, 0xA0, 0x98, 0x0D, 0x10, 0x89, 0x12, 0x8B, 0xDE, 0xFE, 0xDA,
  0x73, 0x60, 0x10, 0xAF, 0xC0, 0xE0, 0x43, 0x02, 0x0E, 0xFE, 0x03, 0x30, 0xDB, 0x81, 0xC6, 0x13,
  0x83, 0x36, 0xBF, 0xD3, 0x05, 0xB0, 0xA7, 0x20, 0x20, 0x43, 0x0A, 0xB0, 0x17, 0x70, 0xDA, 0x0C,
  0x77, 0x10, 0xEA, 0x0B, 0x77, 0x10, 0xDA, 0x0D, 0x77, 0x10, 0xBB, 0x03, 0x77, 0x06, 0xB0, 0xE0,
  0x37, 0x70, 0xDC, 0x09, 0x02, 0x75, 0x02, 0x0E, 0xD0, 0xA0, 0x37, 0x40, 0x20, 0xCE, 0x0C, 0x05,
  0x74, 0x05, 0x0D, 0xE0, 0xC0, 0x47, 0x40, 0x50, 0xCE, 0x09, 0x75, 0x04, 0x0B, 0xD0, 0x97, 0x60,
  0x30, 0xCC, 0x06, 0x77, 0x08, 0xB0, 0xC7, 0x71, 0x0C, 0xB7, 0x71, 0x09, 0xB0, 0x27, 0x70, 0x8B,
  0x01, 0x77, 0x0A, 0xB7, 0x70, 0x10, 0xEA, 0x82, 0xC0, 0x43, 0x74, 0x0B, 0xB8, 0x66, 0x09, 0xFD,
  0x95, 0x24, 0x81, 0x26, 0xDB, 0x0D, 0x20, 0x9F, 0x0E, 0xE0, 0xD0, 0x22, 0x06, 0xFE, 0x0A, 0x01,
  0x58, 0x34, 0x8A, 0xDE, 0xA8, 0x3E, 0xDA, 0x71, 0x50,
  // "ŝ" (U+015D)
  0x68, 0x00, 0x77, 0x40, 0x7C, 0x06, 0x72, 0x04, 0xD0, 0xE0, 0x27, 0x02, 0x0E, 0xA0, 0x80, 0xAA,
  0x0D, 0x01, 0x50, 0x10, 0xDA, 0x07, 0x20, 0xAA, 0x0C, 0x50, 0xBA, 0x07, 0x40, 0x9A, 0x0B, 0x38,
  0x29, 0xFE, 0x56, 0x06, 0xA0, 0x98, 0x0C, 0x10, 0x82, 0x5A, 0xCE, 0xA8, 0x2E, 0xC9, 0x54, 0x05,
  0x0E, 0xFC, 0x81, 0x40, 0x6E, 0x0E, 0xE8, 0x11, 0x0E, 0xA8, 0x1E, 0x62, 0x38, 0x51, 0x38, 0xDA,
  0x04, 0xB0, 0x47, 0x28, 0x11, 0x06, 0xB0, 0x17, 0x40, 0x5B, 0x04, 0x74, 0x01, 0xB0, 0xD0, 0x37,
  0x40, 0x8C, 0x0A, 0x03, 0x73, 0x08, 0xD0, 0xC0, 0x57, 0x20, 0x30, 0xBD, 0x0D, 0x07, 0x72, 0x03,
  0x0A, 0xD0, 0xE0, 0x67, 0x28, 0x12, 0x9E, 0xC0, 0x97, 0x30, 0x10, 0x8C, 0x04, 0x74, 0x04, 0xB0,
  0x97, 0x50, 0xDA, 0x0B, 0x75, 0x0D, 0xA8, 0x1B, 0x51, 0x72, 0x03, 0xB8, 0x48, 0xCF, 0xB6, 0x34,
  0x81, 0x26, 0xEB, 0x03, 0x0C, 0xE0, 0xEE, 0x81, 0x80, 0xAF, 0xC0, 0xE0, 0x73, 0x83, 0x27, 0xAC,
  0xEA, 0x83, 0xED, 0xA6, 0x13,
  // "Ş" (U+015E)
  0x58, 0x91, 0x28, 0xBD, 0xEF, 0xED, 0xA7, 0x36, 0x01, 0x0A, 0xFC, 0x0E, 0x04, 0x30, 0x20, 0xEF,
  0xE0, 0x33, 0x0D, 0xB8, 0x1C, 0x61, 0x38, 0x33, 0x6B, 0xFD, 0x30, 0x5B, 0x0A, 0x72, 0x02, 0x04,
  0x30, 0xAB, 0x01, 0x77, 0x0D, 0xA0, 0xC7, 0x71, 0x0E, 0xA0, 0xB7, 0x71, 0x0D, 0xA0, 0xD7, 0x71,
  0x0B, 0xB0, 0x37, 0x70, 0x6B, 0x0E, 0x03, 0x77, 0x0D, 0xC0, 0x90, 0x27, 0x50, 0x20, 0xED, 0x0A,
  0x03, 0x74, 0x02, 0x0C, 0xE0, 0xC0, 0x57, 0x40, 0x50, 0xDE, 0x0C, 0x04, 0x74, 0x05, 0x0C, 0xE0,
  0x97, 0x50, 0x40, 0xBD, 0x09, 0x76, 0x03, 0x0C, 0xC0, 0x67, 0x70, 0x8B, 0x0C, 0x77, 0x10, 0xCB,
  0x77, 0x10, 0x9B, 0x02, 0x77, 0x08, 0xB0, 0x17, 0x70, 0xAB, 0x77, 0x01, 0x0E, 0xA8, 0x2C, 0x04,
  0x37, 0x40, 0xBB, 0x86, 0x60, 0x9F, 0xD9, 0x52, 0x48, 0x12, 0x6D, 0xB0, 0xD2, 0x09, 0xF0, 0xEE,
  0x0D, 0x02, 0x20, 0x6F, 0xE0, 0xA0, 0x15, 0x83, 0x48, 0xAD, 0xEA, 0x83, 0xED, 0xA7, 0x17, 0x50,
  0x1A, 0x03, 0x77, 0x18, 0x18, 0xFC, 0x77, 0x18, 0x31, 0xEF, 0xB3, 0x77, 0x05, 0x0E, 0xB0, 0xA7,
  0x71, 0x04, 0x0C, 0xA0, 0x87, 0x71, 0x01, 0xA0, 0xC7, 0x71, 0x01, 0xA0, 0xC7, 0x48, 0x34, 0x33,
  0x5C, 0xA0, 0x87, 0x4E, 0x0C, 0x75, 0x0E, 0xA8, 0x1E, 0xB6, 0x71,
  // "ş" (U+015F)
  0x48, 0x25, 0xAC, 0xEA, 0x82, 0xEC, 0x95, 0x40, 0x50, 0xEF, 0xC8, 0x14, 0x06, 0xE0, 0xEE, 0x81,
  0x10, 0xEA, 0x81, 0xE6, 0x23, 0x85, 0x13, 0x8D, 0xA0, 0x4B, 0x04, 0x72, 0x81, 0x10, 0x6B, 0x01,
  0x74, 0x05, 0xB0, 0x47, 0x40, 0x1B, 0x0D, 0x03, 0x74, 0x08, 0xC0, 0xA0, 0x37, 0x30, 0x8D, 0x0C,
  0x05, 0x72, 0x03, 0x0B, 0xD0, 0xD0, 0x77, 0x20, 0x30, 0xAD, 0x0E, 0x06, 0x72, 0x81, 0x29, 0xEC,
  0x09, 0x73, 0x01, 0x08, 0xC0, 0x47, 0x40, 0x4B, 0x09, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x81,
  0xB5, 0x17, 0x20, 0x3B, 0x84, 0x8C, 0xFB, 0x63, 0x48, 0x12, 0x6E, 0xB0, 0x30, 0xCE, 0x0E, 0xE8,
  0x18, 0x0A, 0xFC, 0x0E, 0x07, 0x38, 0x32, 0x7A, 0xCE, 0xA8, 0x3E, 0xDA, 0x61, 0x72, 0x01, 0xA0,
  0x37, 0x58, 0x18, 0xFC, 0x75, 0x83, 0x1E, 0xFB, 0x37, 0x40, 0x50, 0xEB, 0x0A, 0x75, 0x04, 0x0C,
  0xA0, 0x87, 0x50, 0x1A, 0x0C, 0x75, 0x01, 0xA0, 0xC7, 0x18, 0x34, 0x33, 0x5C, 0xA0, 0x87, 0x1E,
  0x0C, 0x72, 0x0E, 0xA8, 0x1E, 0xB6, 0x60,
  // "Š" (U+0160)
  0x38, 0x15, 0x77, 0x71, 0x81, 0x77, 0x55, 0x05, 0xA0, 0xC0, 0x24, 0x02, 0x0D, 0xA0, 0x56, 0x07,
  0xA0, 0xE0, 0x32, 0x04, 0x0E, 0xA0, 0x67, 0x10, 0x8A, 0x81, 0xE3, 0x4B, 0x07, 0x73, 0x0A, 0xA0,
  0xEB, 0x09, 0x75, 0x0C, 0xC0, 0xB7, 0x60, 0x2B, 0x0E, 0x01, 0x80, 0xD5, 0x08, 0x91, 0x28, 0xBD,
  0xEF, 0xED, 0xA7, 0x36, 0x01, 0x0A, 0xFC, 0x0E, 0x04, 0x30, 0x20, 0xEF, 0xE0, 0x33, 0x0D, 0xB8,
  0x1C, 0x61, 0x38, 0x33, 0x6B, 0xFD, 0x30, 0x5B, 0x0A, 0x72, 0x02, 0x04, 0x30, 0xAB, 0x01, 0x77,
  0x0D, 0xA0, 0xC7, 0x71, 0x0E, 0xA0, 0xB7, 0x71, 0x0D, 0xA0, 0xD7, 0x71, 0x0B, 0xB0, 0x37, 0x70,
  0x6B, 0x0E, 0x03, 0x77, 0x0D, 0xC0, 0x90, 0x27, 0x50, 0x20, 0xED, 0x0A, 0x03, 0x74, 0x02, 0x0C,
  0xE0, 0xC0, 0x57, 0x40, 0x50, 0xDE, 0x0C, 0x04, 0x74, 0x05, 0x0C, 0xE0, 0x97, 0x50, 0x40, 0xBD,
  0x09, 0x76, 0x03, 0x0C, 0xC0, 0x67, 0x70, 0x8B, 0x0C, 0x77, 0x10, 0xCB, 0x77, 0x10, 0x9B, 0x02,
  0x77, 0x08, 0xB0, 0x17, 0x70, 0xAB, 0x77, 0x01, 0x0E, 0xA8, 0x2C, 0x04, 0x37, 0x40, 0xBB, 0x86,
  0x60, 0x9F, 0xD9, 0x52, 0x48, 0x12, 0x6D, 0xB0, 0xD2, 0x09, 0xF0, 0xEE, 0x0D, 0x02, 0x20, 0x6F,
  0xE0, 0xA0, 0x15, 0x83, 0x48, 0xAD, 0xEA, 0x83, 0xED, 0xA7, 0x15,
  // "š" (U+0161)
  0x18, 0x15, 0x77, 0x71, 0x81, 0x77, 0x52, 0x05, 0xA0, 0xC0, 0x24, 0x02, 0x0D, 0xA0, 0x53, 0x07,
  0xA0, 0xE0, 0x32, 0x04, 0x0E, 0xA0, 0x65, 0x08, 0xA8, 0x1E, 0x34, 0xB0, 0x77, 0x0A, 0xA0, 0xEB,
  0x09, 0x72, 0x0C, 0xC0, 0xB7, 0x30, 0x2B, 0x0E, 0x01, 0x80, 0xC5, 0x08, 0x25, 0xAC, 0xEA, 0x82,
  0xEC, 0x95, 0x40, 0x50, 0xEF, 0xC8, 0x14, 0x06, 0xE0, 0xEE, 0x81, 0x10, 0xEA, 0x81, 0xE6, 0x23,
  0x85, 0x13, 0x8D, 0xA0, 0x4B, 0x04, 0x72, 0x81, 0x10, 0x6B, 0x01, 0x74, 0x05, 0xB0, 0x47, 0x40,
  0x1B, 0x0D, 0x03, 0x74, 0x08, 0xC0, 0xA0, 0x37, 0x30, 0x8D, 0x0C, 0x05, 0x72, 0x03, 0x0B, 0xD0,
  0xD0, 0x77, 0x20, 0x30, 0xAD, 0x0E, 0x06, 0x72, 0x81, 0x29, 0xEC, 0x09, 0x73, 0x01, 0x08, 0xC0,
  0x47, 0x40, 0x4B, 0x09, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xDA, 0x81, 0xB5, 0x17, 0x20, 0x3B, 0x84,
  0x8C, 0xFB, 0x63, 0x48, 0x12, 0x6E, 0xB0, 0x30, 0xCE, 0x0E, 0xE8, 0x18, 0x0A, 0xFC, 0x0E, 0x07,
  0x38, 0x32, 0x7A, 0xCE, 0xA8, 0x3E, 0xDA, 0x61, 0x30,
  // "Ţ" (U+0162)
  0x03, 0xFF, 0xE0, 0x03, 0xFF, 0xE0, 0x30, 0x28, 0x04, 0xEC, 0x80, 0x4E, 0x02, 0x72, 0x0C, 0xA0,
  0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0,
  0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0,
  0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0,
  0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0,
  0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0,
  0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0,
  0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x01, 0xA0, 0x37, 0x74, 0x81, 0x8F, 0xC7, 0x74, 0x83, 0x1E,
  0xFB, 0x37, 0x73, 0x05, 0x0E, 0xB0, 0xA7, 0x74, 0x04, 0x0C, 0xA0, 0x87, 0x74, 0x01, 0xA0, 0xC7,
  0x74, 0x01, 0xA0, 0xC7, 0x78, 0x34, 0x33, 0x5C, 0xA0, 0x87, 0x7E, 0x0C, 0x77, 0x10, 0xEA, 0x81,
  0xEB, 0x67, 0x20,
  // "ţ" (U+0163)
  0x68, 0x21, 0x77, 0x57, 0x71, 0x05, 0xA0, 0xA7, 0x71, 0x07, 0xA0, 0xA7, 0x71, 0x09, 0xA0, 0xA7,
  0x71, 0x0B, 0xA0, 0xA7, 0x71, 0x0D, 0xA0, 0xA7, 0x28, 0x36, 0x9B, 0xCE, 0xFE, 0x10, 0xBF, 0xFB,
  0x10, 0xB8, 0x01, 0xEC, 0x80, 0x4E, 0x70, 0xEA, 0x0A, 0x77, 0x10, 0xEA, 0x0A, 0x77, 0x10, 0xEA,
  0x0A, 0x77, 0x10, 0xEA, 0x0A, 0x77, 0x10, 0xEA, 0x0A, 0x77, 0x10, 0xEA, 0x0A, 0x77, 0x10, 0xEA,
  0x0A, 0x77, 0x10, 0xEA, 0x0A, 0x77, 0x10, 0xEA, 0x0A, 0x77, 0x10, 0xEA, 0x0A, 0x77, 0x10, 0xEA,
  0x0A, 0x77, 0x10, 0xEA, 0x0A, 0x77, 0x10, 0xDA, 0x0C, 0x77, 0x10, 0xCA, 0x0E, 0x77, 0x10, 0x9B,
  0x07, 0x77, 0x03, 0xC0, 0x80, 0x23, 0x81, 0x24, 0x47, 0x09, 0xE0, 0xEB, 0x09, 0x71, 0x08, 0xFA,
  0x09, 0x72, 0x89, 0x02, 0x7B, 0xDE, 0xFD, 0xC9, 0x47, 0x40, 0x1A, 0x03, 0x77, 0x18, 0x18, 0xFC,
  0x77, 0x18, 0x31, 0xEF, 0xB3, 0x77, 0x05, 0x0E, 0xB0, 0xA7, 0x71, 0x04, 0x0C, 0xA0, 0x87, 0x71,
  0x01, 0xA0, 0xC7, 0x71, 0x01, 0xA0, 0xC7, 0x48, 0x34, 0x33, 0x5C, 0xA0, 0x87, 0x4E, 0x0C, 0x75,
  0x0E, 0xA8, 0x1E, 0xB6, 0x40,
  // "Ť" (U+0164)
  0x48, 0x15, 0x77, 0x71, 0x81, 0x77, 0x57, 0x10, 0x5A, 0x0C, 0x02, 0x40, 0x20, 0xDA, 0x05, 0x72,
  0x07, 0xA0, 0xE0, 0x32, 0x04, 0x0E, 0xA0, 0x67, 0x40, 0x8A, 0x81, 0xE3, 0x4B, 0x07, 0x76, 0x0A,
  0xA0, 0xEB, 0x09, 0x77, 0x10, 0xCC, 0x0B, 0x77, 0x20, 0x2B, 0x0E, 0x01, 0x80, 0xE0, 0x00, 0x3F,
  0xFE, 0x00, 0x3F, 0xFE, 0x03, 0x02, 0x80, 0x4E, 0xC8, 0x04, 0xE0, 0x27, 0x20, 0xCA, 0x0C, 0x77,
  0x40, 0xCA, 0x0C, 0x77, 0x40, 0xCA, 0x0C, 0x77, 0x40, 0xCA, 0x0C, 0x77, 0x40, 0xCA, 0x0C, 0x77,
  0x40, 0xCA, 0x0C, 0x77, 0x40, 0xCA, 0x0C, 0x77, 0x40, 0xCA, 0x0C, 0x77, 0x40, 0xCA, 0x0C, 0x77,
  0x40, 0xCA, 0x0C, 0x77, 0x40, 0xCA, 0x0C, 0x77, 0x40, 0xCA, 0x0C, 0x77, 0x40, 0xCA, 0x0C, 0x77,
  0x40, 0xCA, 0x0C, 0x77, 0x40, 0xCA, 0x0C, 0x77, 0x40, 0xCA, 0x0C, 0x77, 0x40, 0xCA, 0x0C, 0x77,
  0x40, 0xCA, 0x0C, 0x77, 0x40, 0xCA, 0x0C, 0x77, 0x40, 0xCA, 0x0C, 0x77, 0x40, 0xCA, 0x0C, 0x77,
  0x40, 0xCA, 0x0C, 0x77, 0x40, 0xCA, 0x0C, 0x77, 0x40, 0xCA, 0x0C, 0x77, 0x40, 0xCA, 0x0C, 0x77,
  0x40, 0xCA, 0x0C, 0x72,
  // "ť" (U+0165)
  0x77, 0x01, 0xB0, 0x67, 0x70, 0x3B, 0x01, 0x77, 0x07, 0xA0, 0x97, 0x82, 0x28, 0x85, 0x40, 0xAA,
  0x01, 0x70, 0x5A, 0x0A, 0x48, 0x1E, 0xF8, 0x71, 0x07, 0xA0, 0xA3, 0x81, 0x4F, 0xD7, 0x20, 0x9A,
  0x0A, 0x77, 0x10, 0xBA, 0x0A, 0x77, 0x10, 0xDA, 0x0A, 0x72, 0x83, 0x69, 0xBC, 0xEF, 0xE1, 0x0B,
  0xFF, 0xB1, 0x0B, 0x80, 0x1E, 0xC8, 0x04, 0xE7, 0x0E, 0xA0, 0xA7, 0x71, 0x0E, 0xA0, 0xA7, 0x71,
  0x0E, 0xA0, 0xA7, 0x71, 0x0E, 0xA0, 0xA7, 0x71, 0x0E, 0xA0, 0xA7, 0x71, 0x0E, 0xA0, 0xA7, 0x71,
  0x0E, 0xA0, 0xA7, 0x71, 0x0E, 0xA0, 0xA7, 0x71, 0x0E, 0xA0, 0xA7, 0x71, 0x0E, 0xA0, 0xA7, 0x71,
  0x0E, 0xA0, 0xA7, 0x71, 0x0E, 0xA0, 0xA7, 0x71, 0x0D, 0xA0, 0xC7, 0x71, 0x0C, 0xA0, 0xE7, 0x71,
  0x09, 0xB0, 0x77, 0x70, 0x3C, 0x08, 0x02, 0x38, 0x12, 0x44, 0x70, 0x9E, 0x0E, 0xB0, 0x97, 0x10,
  0x8F, 0xA0, 0x97, 0x28, 0x90, 0x27, 0xBD, 0xEF, 0xDC, 0x94,
  // "Ŧ" (U+0166)
  0x03, 0xFF, 0xE0, 0x03, 0xFF, 0xE0, 0x30, 0x28, 0x04, 0xEC, 0x80, 0x4E, 0x02, 0x72, 0x0C, 0xA0,
  0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0,
  0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0,
  0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x50, 0xBF, 0xF0, 0xB6, 0x0B, 0xFF, 0x0B, 0x60, 0xA8, 0x01, 0xEC,
  0x80, 0x1E, 0x0B, 0x75, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74,
  0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74,
  0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x74,
  0x0C, 0xA0, 0xC7, 0x74, 0x0C, 0xA0, 0xC7, 0x20,
  // "ŧ" (U+0167)
  0x68, 0x21, 0x77, 0x57, 0x71, 0x05, 0xA0, 0xA7, 0x71, 0x07, 0xA0, 0xA7, 0x71, 0x09, 0xA0, 0xA7,
  0x71, 0x0B, 0xA0, 0xA7, 0x71, 0x0D, 0xA0, 0xA7, 0x28, 0x36, 0x9B, 0xCE, 0xFE, 0x10, 0xBF, 0xFB,
  0x10, 0xB8, 0x01, 0xEC, 0x80, 0x4E, 0x70, 0xEA, 0x0A, 0x77, 0x10, 0xEA, 0x0A, 0x77, 0x10, 0xEA,
  0x0A, 0x77, 0x10, 0xEA, 0x0A, 0x77, 0x10, 0xEA, 0x0A, 0x72, 0x0B, 0xFF, 0xB0, 0x90, 0xBF, 0xFB,
  0x09, 0x0B, 0x80, 0x1E, 0xC8, 0x04, 0xE0, 0x96, 0x0E, 0xA0, 0xA7, 0x71, 0x0E, 0xA0, 0xA7, 0x71,
  0x0E, 0xA0, 0xA7, 0x71, 0x0E, 0xA0, 0xA7, 0x71, 0x0E, 0xA0, 0xB7, 0x71, 0x0D, 0xA0, 0xE7, 0x71,
  0x0A, 0xB0, 0x67, 0x70, 0x5C, 0x07, 0x02, 0x38, 0x11, 0x44, 0x70, 0xBE, 0x0E, 0xB0, 0x97, 0x10,
  0xAF, 0xA0, 0x97, 0x28, 0x23, 0x8B, 0xDA, 0x82, 0xDC, 0x94,
  // "Ũ" (U+0168)
  0x48, 0x41, 0x9E, 0xEB, 0x55, 0x81, 0xEF, 0x16, 0x0D, 0xD0, 0xC0, 0x52, 0x81, 0x9F, 0xD6, 0x07,
  0xFD, 0x07, 0x68, 0x1D, 0xF9, 0x20, 0x40, 0xCD, 0x0D, 0x60, 0x1A, 0x58, 0x45, 0xCE, 0xE9, 0x18,
  0x0D, 0x00, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67,
  0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06,
  0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0,
  0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B,
  0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03,
  0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00,
  0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x03, 0x01, 0xB0, 0x77, 0x30, 0x7B,
  0x01, 0x1B, 0x08, 0x73, 0x08, 0xB2, 0x0E, 0xA0, 0xB7, 0x30, 0xBA, 0x0E, 0x20, 0xAA, 0x0E, 0x73,
  0x0E, 0xA0, 0xA2, 0x06, 0xB0, 0x57, 0x10, 0x5B, 0x06, 0x20, 0x1B, 0x0E, 0x02, 0x60, 0x10, 0xEA,
  0x0E, 0x01, 0x30, 0x8B, 0x81, 0xE7, 0x12, 0x81, 0x15, 0xDB, 0x07, 0x50, 0xBF, 0xD0, 0xA7, 0x09,
  0xFB, 0x08, 0x72, 0x82, 0x28, 0xCE, 0xA8, 0x2E, 0xB7, 0x15,
  // "ũ" (U+0169)
  0x38, 0x41, 0x9E, 0xEB, 0x55, 0x81, 0xEF, 0x14, 0x0D, 0xD0, 0xC0, 0x52, 0x81, 0x9F, 0xD4, 0x07,
  0xFD, 0x07, 0x48, 0x1D, 0xF9, 0x20, 0x40, 0xCD, 0x0D, 0x40, 0x1A, 0x58, 0x45, 0xCE, 0xE9, 0x18,
  0x0C, 0x30, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA,
  0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C,
  0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0,
  0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97,
  0x30, 0xDA, 0x0C, 0xB0, 0x97, 0x30, 0xEA, 0x0C, 0xB0, 0x97, 0x20, 0x2B, 0x0C, 0x0E, 0xA0, 0xB7,
  0x20, 0x6B, 0x00, 0xCA, 0x0E, 0x72, 0x0D, 0xB0, 0xC0, 0x9B, 0x08, 0x70, 0x8C, 0x0C, 0x03, 0xC0,
  0x90, 0x23, 0x04, 0x0A, 0xA0, 0xDA, 0x81, 0xC0, 0x9E, 0x0E, 0xC0, 0x90, 0x7A, 0x0C, 0x20, 0xAF,
  0xA8, 0x19, 0x04, 0xA0, 0xC3, 0x87, 0x39, 0xDE, 0xFE, 0xC8, 0x22, 0x02, 0xA0, 0xC0,
  // "Ū" (U+016A)
  0x40, 0xD8, 0x06, 0xE0, 0xD7, 0x10, 0xEF, 0xB0, 0xE7, 0x10, 0xEF, 0xB0, 0xE8, 0x0F, 0x40, 0x03,
  0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00,
  0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0,
  0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B,
  0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06,
  0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30,
  0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73,
  0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x03, 0x01, 0xB0, 0x77, 0x30, 0x7B, 0x01, 0x1B, 0x08,
  0x73, 0x08, 0xB2, 0x0E, 0xA0, 0xB7, 0x30, 0xBA, 0x0E, 0x20, 0xAA, 0x0E, 0x73, 0x0E, 0xA0, 0xA2,
  0x06, 0xB0, 0x57, 0x10, 0x5B, 0x06, 0x20, 0x1B, 0x0E, 0x02, 0x60, 0x10, 0xEA, 0x0E, 0x01, 0x30,
  0x8B, 0x81, 0xE7, 0x12, 0x81, 0x15, 0xDB, 0x07, 0x50, 0xBF, 0xD0, 0xA7, 0x09, 0xFB, 0x08, 0x72,
  0x82, 0x28, 0xCE, 0xA8, 0x2E, 0xB7, 0x15,
  // "ū" (U+016B)
  0x30, 0xD8, 0x06, 0xE0, 0xD6, 0x0E, 0xFB, 0x0E, 0x60, 0xEF, 0xB0, 0xE8, 0x0E, 0x50, 0xB0, 0x97,
  0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30,
  0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA,
  0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C,
  0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xDA, 0x0C, 0xB0,
  0x97, 0x30, 0xEA, 0x0C, 0xB0, 0x97, 0x20, 0x2B, 0x0C, 0x0E, 0xA0, 0xB7, 0x20, 0x6B, 0x00, 0xCA,
  0x0E, 0x72, 0x0D, 0xB0, 0xC0, 0x9B, 0x08, 0x70, 0x8C, 0x0C, 0x03, 0xC0, 0x90, 0x23, 0x04, 0x0A,
  0xA0, 0xDA, 0x81, 0xC0, 0x9E, 0x0E, 0xC0, 0x90, 0x7A, 0x0C, 0x20, 0xAF, 0xA8, 0x19, 0x04, 0xA0,
  0xC3, 0x87, 0x39, 0xDE, 0xFE, 0xC8, 0x22, 0x02, 0xA0, 0xC0,
  // "Ŭ" (U+016C)
  0x38, 0x21, 0x77, 0x16, 0x82, 0x17, 0x71, 0x60, 0x1A, 0x08, 0x60, 0x8A, 0x01, 0x70, 0xCA, 0x08,
  0x02, 0x20, 0x20, 0x8A, 0x0C, 0x71, 0x04, 0xFB, 0x04, 0x72, 0x06, 0xF9, 0x06, 0x74, 0x86, 0x39,
  0xDF, 0xED, 0x92, 0x80, 0xD2, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B,
  0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06,
  0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30,
  0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73,
  0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67,
  0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06,
  0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x30, 0x1B,
  0x07, 0x73, 0x07, 0xB0, 0x11, 0xB0, 0x87, 0x30, 0x8B, 0x20, 0xEA, 0x0B, 0x73, 0x0B, 0xA0, 0xE2,
  0x0A, 0xA0, 0xE7, 0x30, 0xEA, 0x0A, 0x20, 0x6B, 0x05, 0x71, 0x05, 0xB0, 0x62, 0x01, 0xB0, 0xE0,
  0x26, 0x01, 0x0E, 0xA0, 0xE0, 0x13, 0x08, 0xB8, 0x1E, 0x71, 0x28, 0x11, 0x5D, 0xB0, 0x75, 0x0B,
  0xFD, 0x0A, 0x70, 0x9F, 0xB0, 0x87, 0x28, 0x22, 0x8C, 0xEA, 0x82, 0xEB, 0x71, 0x50,
  // "ŭ" (U+016D)
  0x28, 0x21, 0x77, 0x16, 0x82, 0x17, 0x71, 0x40, 0x1A, 0x08, 0x60, 0x8A, 0x01, 0x50, 0xCA, 0x08,
  0x02, 0x20, 0x20, 0x8A, 0x0C, 0x60, 0x4F, 0xB0, 0x47, 0x06, 0xF9, 0x06, 0x72, 0x86, 0x39, 0xDF,
  0xED, 0x92, 0x80, 0xC5, 0x0B, 0x09, 0x73, 0x0C, 0xA0, 0xCB, 0x09, 0x73, 0x0C, 0xA0, 0xCB, 0x09,
  0x73, 0x0C, 0xA0, 0xCB, 0x09, 0x73, 0x0C, 0xA0, 0xCB, 0x09, 0x73, 0x0C, 0xA0, 0xCB, 0x09, 0x73,
  0x0C, 0xA0, 0xCB, 0x09, 0x73, 0x0C, 0xA0, 0xCB, 0x09, 0x73, 0x0C, 0xA0, 0xCB, 0x09, 0x73, 0x0C,
  0xA0, 0xCB, 0x09, 0x73, 0x0C, 0xA0, 0xCB, 0x09, 0x73, 0x0C, 0xA0, 0xCB, 0x09, 0x73, 0x0C, 0xA0,
  0xCB, 0x09, 0x73, 0x0D, 0xA0, 0xCB, 0x09, 0x73, 0x0E, 0xA0, 0xCB, 0x09, 0x72, 0x02, 0xB0, 0xC0,
  0xEA, 0x0B, 0x72, 0x06, 0xB0, 0x0C, 0xA0, 0xE7, 0x20, 0xDB, 0x0C, 0x09, 0xB0, 0x87, 0x08, 0xC0,
  0xC0, 0x3C, 0x09, 0x02, 0x30, 0x40, 0xAA, 0x0D, 0xA8, 0x1C, 0x09, 0xE0, 0xEC, 0x09, 0x07, 0xA0,
  0xC2, 0x0A, 0xFA, 0x81, 0x90, 0x4A, 0x0C, 0x38, 0x73, 0x9D, 0xEF, 0xEC, 0x82, 0x20, 0x2A, 0x0C,
  // "Ů" (U+016E)
  0x70, 0x70, 0xDA, 0x0D, 0x06, 0x76, 0x0A, 0xE0, 0x97, 0x40, 0x2A, 0x82, 0x81, 0x19, 0xA0, 0x27,
  0x38, 0x15, 0xFE, 0x48, 0x1E, 0xF5, 0x73, 0x81, 0x5F, 0xE4, 0x81, 0xEF, 0x57, 0x30, 0x2A, 0x82,
  0x92, 0x2A, 0xA0, 0x17, 0x40, 0x8E, 0x08, 0x76, 0x84, 0x6C, 0xFE, 0xC5, 0x80, 0xD3, 0x00, 0x3B,
  0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03,
  0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00,
  0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0,
  0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B,
  0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06,
  0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30,
  0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x30, 0x1B, 0x07, 0x73, 0x07, 0xB0, 0x11, 0xB0, 0x87,
  0x30, 0x8B, 0x20, 0xEA, 0x0B, 0x73, 0x0B, 0xA0, 0xE2, 0x0A, 0xA0, 0xE7, 0x30, 0xEA, 0x0A, 0x20,
  0x6B, 0x05, 0x71, 0x05, 0xB0, 0x62, 0x01, 0xB0, 0xE0, 0x26, 0x01, 0x0E, 0xA0, 0xE0, 0x13, 0x08,
  0xB8, 0x1E, 0x71, 0x28, 0x11, 0x5D, 0xB0, 0x75, 0x0B, 0xFD, 0x0A, 0x70, 0x9F, 0xB0, 0x87, 0x28,
  0x22, 0x8C, 0xEA, 0x82, 0xEB, 0x71, 0x50,
  // "ů" (U+016F)
  0x60, 0x70, 0xDA, 0x0D, 0x06, 0x74, 0x0A, 0xE0, 0x97, 0x20, 0x2A, 0x82, 0x81, 0x19, 0xA0, 0x27,
  0x18, 0x15, 0xFE, 0x48, 0x1E, 0xF5, 0x71, 0x81, 0x5F, 0xE4, 0x81, 0xEF, 0x57, 0x10, 0x2A, 0x82,
  0x92, 0x2A, 0xA0, 0x17, 0x20, 0x8E, 0x08, 0x74, 0x84, 0x6C, 0xFE, 0xC5, 0x80, 0xC6, 0x0B, 0x09,
  0x73, 0x0C, 0xA0, 0xCB, 0x09, 0x73, 0x0C, 0xA0, 0xCB, 0x09, 0x73, 0x0C, 0xA0, 0xCB, 0x09, 0x73,
  0x0C, 0xA0, 0xCB, 0x09, 0x73, 0x0C, 0xA0, 0xCB, 0x09, 0x73, 0x0C, 0xA0, 0xCB, 0x09, 0x73, 0x0C,
  0xA0, 0xCB, 0x09, 0x73, 0x0C, 0xA0, 0xCB, 0x09, 0x73, 0x0C, 0xA0, 0xCB, 0x09, 0x73, 0x0C, 0xA0,
  0xCB, 0x09, 0x73, 0x0C, 0xA0, 0xCB, 0x09, 0x73, 0x0C, 0xA0, 0xCB, 0x09, 0x73, 0x0D, 0xA0, 0xCB,
  0x09, 0x73, 0x0E, 0xA0, 0xCB, 0x09, 0x72, 0x02, 0xB0, 0xC0, 0xEA, 0x0B, 0x72, 0x06, 0xB0, 0x0C,
  0xA0, 0xE7, 0x20, 0xDB, 0x0C, 0x09, 0xB0, 0x87, 0x08, 0xC0, 0xC0, 0x3C, 0x09, 0x02, 0x30, 0x40,
  0xAA, 0x0D, 0xA8, 0x1C, 0x09, 0xE0, 0xEC, 0x09, 0x07, 0xA0, 0xC2, 0x0A, 0xFA, 0x81, 0x90, 0x4A,
  0x0C, 0x38, 0x73, 0x9D, 0xEF, 0xEC, 0x82, 0x20, 0x2A, 0x0C,
  // "Ű" (U+0170)
  0x60, 0x9B, 0x06, 0x20, 0x8B, 0x06, 0x70, 0x2B, 0x0B, 0x20, 0x2B, 0x0B, 0x71, 0x0B, 0xA0, 0xC3,
  0x0B, 0xA0, 0xC0, 0x17, 0x05, 0xA0, 0xD0, 0x12, 0x05, 0xA0, 0xD0, 0x17, 0x83, 0x1E, 0xFD, 0x12,
  0x83, 0x1E, 0xFD, 0x17, 0x18, 0x2A, 0xFB, 0x13, 0x82, 0xAF, 0xB1, 0x80, 0xD2, 0x00, 0x3B, 0x06,
  0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0,
  0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B,
  0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03,
  0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00,
  0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0,
  0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B,
  0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x30, 0x1B, 0x07, 0x73, 0x07, 0xB0, 0x11, 0xB0, 0x87, 0x30,
  0x8B, 0x20, 0xEA, 0x0B, 0x73, 0x0B, 0xA0, 0xE2, 0x0A, 0xA0, 0xE7, 0x30, 0xEA, 0x0A, 0x20, 0x6B,
  0x05, 0x71, 0x05, 0xB0, 0x62, 0x01, 0xB0, 0xE0, 0x26, 0x01, 0x0E, 0xA0, 0xE0, 0x13, 0x08, 0xB8,
  0x1E, 0x71, 0x28, 0x11, 0x5D, 0xB0, 0x75, 0x0B, 0xFD, 0x0A, 0x70, 0x9F, 0xB0, 0x87, 0x28, 0x22,
  0x8C, 0xEA, 0x82, 0xEB, 0x71, 0x50,
  // "ű" (U+0171)
  0x50, 0x9B, 0x06, 0x20, 0x8B, 0x06, 0x50, 0x2B, 0x0B, 0x20, 0x2B, 0x0B, 0x60, 0xBA, 0x0C, 0x30,
  0xBA, 0x0C, 0x01, 0x50, 0x5A, 0x0D, 0x01, 0x20, 0x5A, 0x0D, 0x01, 0x58, 0x31, 0xEF, 0xD1, 0x28,
  0x31, 0xEF, 0xD1, 0x68, 0x2A, 0xFB, 0x13, 0x82, 0xAF, 0xB1, 0x80, 0xC5, 0x0B, 0x09, 0x73, 0x0C,
  0xA0, 0xCB, 0x09, 0x73, 0x0C, 0xA0, 0xCB, 0x09, 0x73, 0x0C, 0xA0, 0xCB, 0x09, 0x73, 0x0C, 0xA0,
  0xCB, 0x09, 0x73, 0x0C, 0xA0, 0xCB, 0x09, 0x73, 0x0C, 0xA0, 0xCB, 0x09, 0x73, 0x0C, 0xA0, 0xCB,
  0x09, 0x73, 0x0C, 0xA0, 0xCB, 0x09, 0x73, 0x0C, 0xA0, 0xCB, 0x09, 0x73, 0x0C, 0xA0, 0xCB, 0x09,
  0x73, 0x0C, 0xA0, 0xCB, 0x09, 0x73, 0x0C, 0xA0, 0xCB, 0x09, 0x73, 0x0D, 0xA0, 0xCB, 0x09, 0x73,
  0x0E, 0xA0, 0xCB, 0x09, 0x72, 0x02, 0xB0, 0xC0, 0xEA, 0x0B, 0x72, 0x06, 0xB0, 0x0C, 0xA0, 0xE7,
  0x20, 0xDB, 0x0C, 0x09, 0xB0, 0x87, 0x08, 0xC0, 0xC0, 0x3C, 0x09, 0x02, 0x30, 0x40, 0xAA, 0x0D,
  0xA8, 0x1C, 0x09, 0xE0, 0xEC, 0x09, 0x07, 0xA0, 0xC2, 0x0A, 0xFA, 0x81, 0x90, 0x4A, 0x0C, 0x38,
  0x73, 0x9D, 0xEF, 0xEC, 0x82, 0x20, 0x2A, 0x0C,
  // "Ų" (U+0172)
  0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B,
  0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06,
  0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30,
  0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73,
  0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67,
  0x30, 0x6B, 0x00, 0x3B, 0x06, 0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x00, 0x3B, 0x06,
  0x73, 0x06, 0xB0, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x03, 0x01, 0xB0, 0x77, 0x30, 0x7B, 0x02, 0x1B,
  0x08, 0x73, 0x08, 0xB8, 0x11, 0x0E, 0xA0, 0xB7, 0x30, 0xBA, 0x0E, 0x20, 0xAA, 0x0E, 0x73, 0x0E,
  0xA0, 0xB2, 0x06, 0xB0, 0x57, 0x10, 0x5B, 0x06, 0x20, 0x1B, 0x0E, 0x02, 0x60, 0x10, 0xEA, 0x0E,
  0x01, 0x30, 0x8B, 0x81, 0xE7, 0x12, 0x81, 0x15, 0xDB, 0x07, 0x50, 0xBF, 0xD0, 0xA7, 0x09, 0xFA,
  0x0E, 0x07, 0x72, 0x82, 0x28, 0xCE, 0xC0, 0xB0, 0x17, 0x70, 0x7A, 0x06, 0x77, 0x10, 0x6A, 0x05,
  0x77, 0x10, 0x1A, 0x09, 0x77, 0x20, 0x7A, 0x04, 0x77, 0x20, 0xAA, 0x04, 0x77, 0x20, 0x8A, 0x82,
  0xB1, 0x01, 0x76, 0x05, 0xD0, 0xE7, 0x70, 0xCC, 0x0E, 0x77, 0x84, 0x18, 0xDE, 0xD9, 0x60,
  // "ų" (U+0173)
  0xB0, 0x97, 0x30, 0xCA, 0x0C, 0x1B, 0x09, 0x73, 0x0C, 0xA0, 0xC1, 0xB0, 0x97, 0x30, 0xCA, 0x0C,
  0x1B, 0x09, 0x73, 0x0C, 0xA0, 0xC1, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0x1B, 0x09, 0x73, 0x0C, 0xA0,
  0xC1, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0x1B, 0x09, 0x73, 0x0C, 0xA0, 0xC1, 0xB0, 0x97, 0x30, 0xCA,
  0x0C, 0x1B, 0x09, 0x73, 0x0C, 0xA0, 0xC1, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0x1B, 0x09, 0x73, 0x0C,
  0xA0, 0xC1, 0xB0, 0x97, 0x30, 0xDA, 0x0C, 0x1B, 0x09, 0x73, 0x0E, 0xA0, 0xC1, 0xB0, 0x97, 0x20,
  0x2B, 0x81, 0xC0, 0xEA, 0x0B, 0x72, 0x06, 0xB8, 0x1C, 0x0C, 0xA0, 0xE7, 0x20, 0xDB, 0x81, 0xC0,
  0x9B, 0x08, 0x70, 0x8C, 0x81, 0xC0, 0x3C, 0x09, 0x02, 0x30, 0x40, 0xAA, 0x0D, 0xA0, 0xC2, 0x09,
  0xE0, 0xEC, 0x09, 0x07, 0xA0, 0xC3, 0x0A, 0xFA, 0x81, 0x90, 0x4A, 0x0C, 0x48, 0x73, 0x9D, 0xEF,
  0xEC, 0x82, 0x20, 0x4A, 0x0E, 0x77, 0x82, 0x2E, 0xF9, 0x77, 0x18, 0x1C, 0xFB, 0x77, 0x10, 0x7A,
  0x02, 0x77, 0x18, 0x1D, 0xFC, 0x77, 0x10, 0x1A, 0x0B, 0x77, 0x10, 0x1B, 0x04, 0x77, 0x10, 0xED,
  0x06, 0x75, 0x06, 0xD0, 0x67, 0x68, 0x46, 0xCF, 0xEC, 0x40,
  // "Ŵ" (U+0174)
  0x72, 0x80, 0x07, 0x77, 0x30, 0x7C, 0x06, 0x77, 0x10, 0x4D, 0x0E, 0x02, 0x76, 0x02, 0x0E, 0xA0,
  0x80, 0xAA, 0x0D, 0x01, 0x74, 0x01, 0x0D, 0xA0, 0x72, 0x0A, 0xA0, 0xC7, 0x40, 0xBA, 0x07, 0x40,
  0x9A, 0x0B, 0x72, 0x82, 0x9F, 0xE5, 0x60, 0x6A, 0x09, 0x80, 0xD4, 0x00, 0xEA, 0x05, 0x77, 0x05,
  0xA0, 0xE0, 0xDA, 0x07, 0x77, 0x06, 0xA0, 0xD0, 0xBA, 0x08, 0x77, 0x08, 0xA0, 0xB0, 0x9A, 0x0A,
  0x77, 0x09, 0xA0, 0xA0, 0x7A, 0x0B, 0x77, 0x0A, 0xA0, 0x80, 0x6A, 0x0D, 0x77, 0x0C, 0xA0, 0x70,
  0x4A, 0x0E, 0x77, 0x0D, 0xA0, 0x50, 0x2B, 0x50, 0xCA, 0x0D, 0x50, 0xEA, 0x03, 0x01, 0xB0, 0x14,
  0xC0, 0x14, 0xB8, 0x12, 0x0E, 0xA0, 0x33, 0x03, 0xC0, 0x53, 0x02, 0xB2, 0x0D, 0xA0, 0x43, 0x07,
  0xA8, 0x1E, 0xF9, 0x30, 0x3A, 0x0E, 0x20, 0xBA, 0x06, 0x38, 0x4B, 0xFD, 0xBF, 0xC3, 0x04, 0xA0,
  0xD2, 0x09, 0xA0, 0x73, 0x82, 0xEF, 0xB8, 0xA3, 0x06, 0xA0, 0xB2, 0x07, 0xA0, 0x92, 0x02, 0xA0,
  0x80, 0x5A, 0x04, 0x20, 0x7A, 0x0A, 0x20, 0x6A, 0x0A, 0x20, 0x6A, 0x04, 0x02, 0xA0, 0x72, 0x08,
  0xA0, 0x82, 0x04, 0xA0, 0xB2, 0x09, 0xA8, 0x31, 0x0E, 0xFB, 0x20, 0x9A, 0x07, 0x20, 0x2A, 0x0D,
  0x28, 0x1D, 0xFD, 0x28, 0x1B, 0xFE, 0x20, 0xAA, 0x05, 0x20, 0x1A, 0x0E, 0x2A, 0x09, 0x20, 0x7A,
  0x81, 0x30, 0xBA, 0x04, 0x30, 0xEA, 0x10, 0x4A, 0x06, 0x20, 0x3A, 0x81, 0x60, 0xCA, 0x02, 0x30,
  0xDA, 0x10, 0x7A, 0x03, 0x3A, 0x81, 0xA0, 0xDA, 0x01, 0x30, 0xBA, 0x82, 0x2A, 0xFE, 0x48, 0x3B,
  0xFD, 0x0E, 0xA4, 0x09, 0xA8, 0x23, 0xDF, 0xB4, 0x08, 0xA0, 0x1A, 0x0D, 0x40, 0x8A, 0x05, 0xA0,
  0x74, 0x04, 0xA0, 0x5A, 0x0B, 0x40, 0x6A, 0x09, 0xA0, 0x44, 0x01, 0xA0, 0x9A, 0x0A, 0x40, 0x4A,
  0x0C, 0xA0, 0x15, 0x81, 0xCF, 0xCA, 0x08, 0x40, 0x2C, 0x0D, 0x60, 0x9C, 0x07, 0x40, 0x1C, 0x09,
  0x60, 0x5C, 0x05, 0x50, 0xEB, 0x05, 0x60, 0x1C, 0x04, 0x50, 0xDB, 0x02, 0x70, 0xDB, 0x02, 0x20,
  // "ŵ" (U+0175)
  0x73, 0x80, 0x07, 0x77, 0x50, 0x7C, 0x06, 0x77, 0x30, 0x4D, 0x0E, 0x02, 0x77, 0x10, 0x20, 0xEA,
  0x08, 0x0A, 0xA0, 0xD0, 0x17, 0x60, 0x10, 0xDA, 0x07, 0x20, 0xAA, 0x0C, 0x76, 0x0B, 0xA0, 0x74,
  0x09, 0xA0, 0xB7, 0x48, 0x29, 0xFE, 0x56, 0x06, 0xA0, 0x98, 0x0E, 0x10, 0x04, 0xB0, 0x17, 0x71,
  0x0E, 0xA0, 0x50, 0x2B, 0x03, 0x77, 0x01, 0xB8, 0x12, 0x0E, 0xA0, 0x57, 0x70, 0x4B, 0x20, 0xCA,
  0x07, 0x77, 0x06, 0xA0, 0xD2, 0x0A, 0xA0, 0x94, 0x01, 0x80, 0x0D, 0x50, 0x8A, 0x0A, 0x20, 0x7A,
  0x0C, 0x40, 0x5C, 0x04, 0x40, 0xBA, 0x08, 0x20, 0x5A, 0x0E, 0x40, 0xAC, 0x09, 0x40, 0xDA, 0x05,
  0x20, 0x3B, 0x01, 0x38, 0x1E, 0xFE, 0xA0, 0xD4, 0xB0, 0x33, 0xB0, 0x32, 0x03, 0xA0, 0x0B, 0xA0,
  0x12, 0x03, 0xB4, 0x0D, 0xA0, 0x52, 0x07, 0xA0, 0x70, 0x8A, 0x06, 0x20, 0x5A, 0x0D, 0x40, 0xBA,
  0x07, 0x20, 0xCA, 0x03, 0x04, 0xA0, 0xA2, 0x07, 0xA0, 0xB4, 0x08, 0xA8, 0x1A, 0x01, 0xA8, 0x1E,
  0x01, 0xA0, 0xE2, 0x0A, 0xA0, 0x84, 0x06, 0xA8, 0x1C, 0x04, 0xA0, 0xB2, 0x0C, 0xA8, 0x12, 0x0C,
  0xA0, 0x64, 0x03, 0xA8, 0x1D, 0x08, 0xA0, 0x72, 0x08, 0xA8, 0x16, 0x0D, 0xA0, 0x34, 0x01, 0xB1,
  0x0C, 0xA0, 0x22, 0x04, 0xA0, 0xA1, 0xB0, 0x15, 0x0E, 0xA0, 0x1A, 0x0E, 0x30, 0x1A, 0x0E, 0x01,
  0xA0, 0xE6, 0x0C, 0xA0, 0x4A, 0x0A, 0x40, 0xCA, 0x04, 0xA0, 0xB6, 0x09, 0xA0, 0x8A, 0x06, 0x40,
  0x8A, 0x08, 0xA0, 0x96, 0x07, 0xA0, 0xCA, 0x02, 0x40, 0x4A, 0x0C, 0xA0, 0x66, 0x04, 0xC0, 0xE5,
  0x01, 0xD0, 0x46, 0x02, 0xC0, 0xA6, 0x0C, 0xC0, 0x17, 0xC0, 0x66, 0x08, 0xB0, 0xE4,
  // "Ŷ" (U+0176)
  0x72, 0x80, 0x07, 0x77, 0x30, 0x7C, 0x06, 0x77, 0x10, 0x4D, 0x0E, 0x02, 0x76, 0x02, 0x0E, 0xA0,
  0x80, 0xAA, 0x0D, 0x01, 0x74, 0x01, 0x0D, 0xA0, 0x72, 0x0A, 0xA0, 0xC7, 0x40, 0xBA, 0x07, 0x40,
  0x9A, 0x0B, 0x72, 0x82, 0x9F, 0xE5, 0x60, 0x6A, 0x09, 0x80, 0xD4, 0x00, 0x5B, 0x09, 0x75, 0x07,
  0xB8, 0x15, 0x0D, 0xA0, 0xE0, 0x17, 0x40, 0xDA, 0x0C, 0x20, 0x5B, 0x07, 0x73, 0x05, 0xB0, 0x53,
  0x0D, 0xA0, 0xE7, 0x30, 0xCA, 0x0D, 0x40, 0x5B, 0x06, 0x71, 0x04, 0xB0, 0x55, 0x0D, 0xA0, 0xD7,
  0x10, 0xBA, 0x0D, 0x60, 0x5B, 0x04, 0x60, 0x2B, 0x05, 0x70, 0xDA, 0x0B, 0x60, 0xAA, 0x0D, 0x71,
  0x05, 0xB0, 0x34, 0x01, 0xB0, 0x57, 0x20, 0xDA, 0x0A, 0x40, 0x8A, 0x0D, 0x73, 0x05, 0xB0, 0x13,
  0x0E, 0xA0, 0x57, 0x40, 0xDA, 0x08, 0x20, 0x7A, 0x0D, 0x75, 0x05, 0xA8, 0x2E, 0x10, 0xDA, 0x05,
  0x76, 0x0D, 0xA0, 0x70, 0x5A, 0x0D, 0x77, 0x05, 0xA0, 0xD0, 0xCA, 0x05, 0x77, 0x10, 0xDC, 0x0D,
  0x77, 0x20, 0x5C, 0x05, 0x77, 0x30, 0xDA, 0x0D, 0x77, 0x40, 0xBA, 0x0B, 0x77, 0x40, 0xBA, 0x0B,
  0x77, 0x40, 0xBA, 0x0B, 0x77, 0x40, 0xBA, 0x0B, 0x77, 0x40, 0xBA, 0x0B, 0x77, 0x40, 0xBA, 0x0B,
  0x77, 0x40, 0xBA, 0x0B, 0x77, 0x40, 0xBA, 0x0B, 0x77, 0x40, 0xBA, 0x0B, 0x77, 0x40, 0xBA, 0x0B,
  0x77, 0x40, 0xBA, 0x0B, 0x72,
  // "ŷ" (U+0177)
  0x71, 0x80, 0x07, 0x77, 0x10, 0x7C, 0x06, 0x76, 0x04, 0xD0, 0xE0, 0x27, 0x40, 0x20, 0xEA, 0x08,
  0x0A, 0xA0, 0xD0, 0x17, 0x20, 0x10, 0xDA, 0x07, 0x20, 0xAA, 0x0C, 0x72, 0x0B, 0xA0, 0x74, 0x09,
  0xA0, 0xB7, 0x82, 0x9F, 0xE5, 0x60, 0x6A, 0x09, 0x80, 0xC7, 0x00, 0xEA, 0x07, 0x75, 0x0A, 0xA0,
  0xE0, 0x9A, 0x0D, 0x75, 0x0E, 0xA0, 0x90, 0x2B, 0x04, 0x73, 0x05, 0xB8, 0x13, 0x0C, 0xA0, 0xA7,
  0x30, 0xAA, 0x0D, 0x20, 0x5B, 0x01, 0x72, 0x0E, 0xA0, 0x83, 0x0E, 0xA0, 0x77, 0x10, 0x4B, 0x02,
  0x30, 0x8A, 0x0D, 0x71, 0x09, 0xA0, 0xC4, 0x02, 0xB0, 0x47, 0x0E, 0xA0, 0x65, 0x0B, 0xA0, 0xA6,
  0x04, 0xB0, 0x15, 0x05, 0xB0, 0x15, 0x09, 0xA0, 0xB7, 0x0E, 0xA0, 0x75, 0x0E, 0xA0, 0x57, 0x08,
  0xA0, 0xD4, 0x04, 0xA0, 0xE7, 0x10, 0x2B, 0x04, 0x30, 0x9A, 0x09, 0x72, 0x0B, 0xA0, 0xA3, 0x0E,
  0xA0, 0x47, 0x20, 0x5B, 0x20, 0x3A, 0x0D, 0x74, 0x0D, 0xA8, 0x15, 0x08, 0xA0, 0x87, 0x40, 0x7A,
  0x81, 0xA0, 0xDA, 0x02, 0x74, 0x01, 0xA0, 0xE0, 0x2A, 0x0C, 0x76, 0x0A, 0xA0, 0xBA, 0x06, 0x76,
  0x04, 0xD0, 0x17, 0x70, 0xDB, 0x0B, 0x77, 0x10, 0x7B, 0x05, 0x77, 0x10, 0x5A, 0x0E, 0x77, 0x20,
  0xBA, 0x09, 0x77, 0x10, 0x1B, 0x04, 0x77, 0x10, 0x7A, 0x0D, 0x77, 0x20, 0xEA, 0x07, 0x77, 0x10,
  0x9A, 0x0E, 0x01, 0x76, 0x02, 0x0A, 0xB0, 0x87, 0x38, 0x16, 0xFE, 0xD0, 0xC7, 0x40, 0x6E, 0x0C,
  0x01, 0x74, 0x85, 0x5D, 0xEF, 0xDB, 0x57, 0x60,
  // "Ÿ" (U+0178)
  0x48, 0x21, 0xBE, 0xA6, 0x82, 0xAE, 0xC2, 0x71, 0x08, 0xB0, 0x74, 0x06, 0xB0, 0x97, 0x10, 0xAB,
  0x09, 0x40, 0x8B, 0x0B, 0x71, 0x08, 0xB0, 0x64, 0x05, 0xB0, 0x97, 0x18, 0x21, 0xBE, 0xA6, 0x82,
  0x9E, 0xB1, 0x80, 0x98, 0x20, 0x05, 0xB0, 0x97, 0x50, 0x7B, 0x81, 0x50, 0xDA, 0x0E, 0x01, 0x74,
  0x0D, 0xA0, 0xC2, 0x05, 0xB0, 0x77, 0x30, 0x5B, 0x05, 0x30, 0xDA, 0x0E, 0x73, 0x0C, 0xA0, 0xD4,
  0x05, 0xB0, 0x67, 0x10, 0x4B, 0x05, 0x50, 0xDA, 0x0D, 0x71, 0x0B, 0xA0, 0xD6, 0x05, 0xB0, 0x46,
  0x02, 0xB0, 0x57, 0x0D, 0xA0, 0xB6, 0x0A, 0xA0, 0xD7, 0x10, 0x5B, 0x03, 0x40, 0x1B, 0x05, 0x72,
  0x0D, 0xA0, 0xA4, 0x08, 0xA0, 0xD7, 0x30, 0x5B, 0x01, 0x30, 0xEA, 0x05, 0x74, 0x0D, 0xA0, 0x82,
  0x07, 0xA0, 0xD7, 0x50, 0x5A, 0x82, 0xE1, 0x0D, 0xA0, 0x57, 0x60, 0xDA, 0x07, 0x05, 0xA0, 0xD7,
  0x70, 0x5A, 0x0D, 0x0C, 0xA0, 0x57, 0x71, 0x0D, 0xC0, 0xD7, 0x72, 0x05, 0xC0, 0x57, 0x73, 0x0D,
  0xA0, 0xD7, 0x74, 0x0B, 0xA0, 0xB7, 0x74, 0x0B, 0xA0, 0xB7, 0x74, 0x0B, 0xA0, 0xB7, 0x74, 0x0B,
  0xA0, 0xB7, 0x74, 0x0B, 0xA0, 0xB7, 0x74, 0x0B, 0xA0, 0xB7, 0x74, 0x0B, 0xA0, 0xB7, 0x74, 0x0B,
  0xA0, 0xB7, 0x74, 0x0B, 0xA0, 0xB7, 0x74, 0x0B, 0xA0, 0xB7, 0x74, 0x0B, 0xA0, 0xB7, 0x20,
  // "Ź" (U+0179)
  0x74, 0x83, 0x37, 0x77, 0x67, 0x60, 0xDB, 0x07, 0x75, 0x07, 0xB0, 0xA7, 0x50, 0x2B, 0x0B, 0x76,
  0x0B, 0xA0, 0xC7, 0x60, 0x6A, 0x0C, 0x01, 0x75, 0x01, 0xA0, 0xB8, 0x0D, 0x00, 0x06, 0xFF, 0x98,
  0x13, 0x06, 0xFF, 0x98, 0x13, 0x05, 0x80, 0x7E, 0xC0, 0x27, 0x60, 0xCA, 0x0B, 0x76, 0x05, 0xB0,
  0x37, 0x60, 0xDA, 0x0A, 0x76, 0x06, 0xB0, 0x27, 0x60, 0xEA, 0x09, 0x76, 0x08, 0xB0, 0x17, 0x50,
  0x10, 0xEA, 0x08, 0x76, 0x09, 0xA0, 0xE0, 0x17, 0x50, 0x2B, 0x07, 0x76, 0x0A, 0xA0, 0xE7, 0x60,
  0x3B, 0x06, 0x76, 0x0B, 0xA0, 0xD7, 0x60, 0x4B, 0x05, 0x76, 0x0C, 0xA0, 0xC7, 0x60, 0x6B, 0x04,
  0x76, 0x0D, 0xA0, 0xB7, 0x60, 0x7B, 0x03, 0x75, 0x01, 0x0E, 0xA0, 0xA7, 0x60, 0x8B, 0x02, 0x75,
  0x01, 0xB0, 0x97, 0x60, 0x9A, 0x0E, 0x01, 0x75, 0x02, 0xB0, 0x87, 0x60, 0xBA, 0x0E, 0x76, 0x02,
  0xC8, 0x09, 0x0E, 0x02, 0x03, 0xFF, 0xA0, 0x03, 0xFF, 0xA0, 0x30,
  // "ź" (U+017A)
  0x74, 0x83, 0x37, 0x77, 0x67, 0x60, 0xDB, 0x07, 0x75, 0x07, 0xB0, 0xA7, 0x50, 0x2B, 0x0B, 0x76,
  0x0B, 0xA0, 0xC7, 0x60, 0x6A, 0x0C, 0x01, 0x75, 0x01, 0xA0, 0xB8, 0x0D, 0x00, 0x0B, 0xFF, 0x98,
  0x11, 0x0B, 0xFF, 0x98, 0x11, 0x0B, 0x80, 0x7E, 0xC0, 0x17, 0x50, 0x3B, 0x0C, 0x75, 0x01, 0x0D,
  0xA0, 0xE0, 0x17, 0x50, 0xBB, 0x04, 0x75, 0x07, 0xB0, 0x77, 0x50, 0x3B, 0x0B, 0x75, 0x01, 0x0D,
  0xA0, 0xD0, 0x17, 0x50, 0xBB, 0x03, 0x75, 0x07, 0xB0, 0x67, 0x50, 0x4B, 0x0A, 0x75, 0x01, 0x0E,
  0xA0, 0xD7, 0x60, 0xBA, 0x0E, 0x02, 0x75, 0x08, 0xB0, 0x57, 0x50, 0x4B, 0x09, 0x75, 0x01, 0x0E,
  0xA0, 0xC7, 0x60, 0xBA, 0x0E, 0x02, 0x75, 0x08, 0xB0, 0x47, 0x50, 0x3C, 0x80, 0x90, 0xE0, 0x50,
  0x6F, 0xFA, 0x00, 0x6F, 0xFA, 0x06,
  // "Ż" (U+017B)
  0x78, 0x28, 0xEE, 0x87, 0x60, 0x4C, 0x04, 0x75, 0x07, 0xC0, 0x77, 0x50, 0x4C, 0x04, 0x76, 0x82,
  0x8E, 0xE8, 0x80, 0xF2, 0x00, 0x6F, 0xF9, 0x81, 0x30, 0x6F, 0xF9, 0x81, 0x30, 0x58, 0x07, 0xEC,
  0x02, 0x76, 0x0C, 0xA0, 0xB7, 0x60, 0x5B, 0x03, 0x76, 0x0D, 0xA0, 0xA7, 0x60, 0x6B, 0x02, 0x76,
  0x0E, 0xA0, 0x97, 0x60, 0x8B, 0x01, 0x75, 0x01, 0x0E, 0xA0, 0x87, 0x60, 0x9A, 0x0E, 0x01, 0x75,
  0x02, 0xB0, 0x77, 0x60, 0xAA, 0x0E, 0x76, 0x03, 0xB0, 0x67, 0x60, 0xBA, 0x0D, 0x76, 0x04, 0xB0,
  0x57, 0x60, 0xCA, 0x0C, 0x76, 0x06, 0xB0, 0x47, 0x60, 0xDA, 0x0B, 0x76, 0x07, 0xB0, 0x37, 0x50,
  0x10, 0xEA, 0x0A, 0x76, 0x08, 0xB0, 0x27, 0x50, 0x1B, 0x09, 0x76, 0x09, 0xA0, 0xE0, 0x17, 0x50,
  0x2B, 0x08, 0x76, 0x0B, 0xA0, 0xE7, 0x60, 0x2C, 0x80, 0x90, 0xE0, 0x20, 0x3F, 0xFA, 0x00, 0x3F,
  0xFA, 0x03,
  // "ż" (U+017C)
  0x78, 0x28, 0xEE, 0x87, 0x60, 0x4C, 0x04, 0x75, 0x07, 0xC0, 0x77, 0x50, 0x4C, 0x04, 0x76, 0x82,
  0x8E, 0xE8, 0x80, 0xF2, 0x00, 0xBF, 0xF9, 0x81, 0x10, 0xBF, 0xF9, 0x81, 0x10, 0xB8, 0x07, 0xEC,
  0x01, 0x75, 0x03, 0xB0, 0xC7, 0x50, 0x10, 0xDA, 0x0E, 0x01, 0x75, 0x0B, 0xB0, 0x47, 0x50, 0x7B,
  0x07, 0x75, 0x03, 0xB0, 0xB7, 0x50, 0x10, 0xDA, 0x0D, 0x01, 0x75, 0x0B, 0xB0, 0x37, 0x50, 0x7B,
  0x06, 0x75, 0x04, 0xB0, 0xA7, 0x50, 0x10, 0xEA, 0x0D, 0x76, 0x0B, 0xA0, 0xE0, 0x27, 0x50, 0x8B,
  0x05, 0x75, 0x04, 0xB0, 0x97, 0x50, 0x10, 0xEA, 0x0C, 0x76, 0x0B, 0xA0, 0xE0, 0x27, 0x50, 0x8B,
  0x04, 0x75, 0x03, 0xC8, 0x09, 0x0E, 0x05, 0x06, 0xFF, 0xA0, 0x06, 0xFF, 0xA0, 0x60,
  // "Ž" (U+017D)
  0x28, 0x15, 0x77, 0x71, 0x81, 0x77, 0x54, 0x05, 0xA0, 0xC0, 0x24, 0x02, 0x0D, 0xA0, 0x55, 0x07,
  0xA0, 0xE0, 0x32, 0x04, 0x0E, 0xA0, 0x67, 0x08, 0xA8, 0x1E, 0x34, 0xB0, 0x77, 0x20, 0xAA, 0x0E,
  0xB0, 0x97, 0x40, 0xCC, 0x0B, 0x75, 0x02, 0xB0, 0xE0, 0x18, 0x0C, 0x70, 0x06, 0xFF, 0x98, 0x13,
  0x06, 0xFF, 0x98, 0x13, 0x05, 0x80, 0x7E, 0xC0, 0x27, 0x60, 0xCA, 0x0B, 0x76, 0x05, 0xB0, 0x37,
  0x60, 0xDA, 0x0A, 0x76, 0x06, 0xB0, 0x27, 0x60, 0xEA, 0x09, 0x76, 0x08, 0xB0, 0x17, 0x50, 0x10,
  0xEA, 0x08, 0x76, 0x09, 0xA0, 0xE0, 0x17, 0x50, 0x2B, 0x07, 0x76, 0x0A, 0xA0, 0xE7, 0x60, 0x3B,
  0x06, 0x76, 0x0B, 0xA0, 0xD7, 0x60, 0x4B, 0x05, 0x76, 0x0C, 0xA0, 0xC7, 0x60, 0x6B, 0x04, 0x76,
  0x0D, 0xA0, 0xB7, 0x60, 0x7B, 0x03, 0x75, 0x01, 0x0E, 0xA0, 0xA7, 0x60, 0x8B, 0x02, 0x75, 0x01,
  0xB0, 0x97, 0x60, 0x9A, 0x0E, 0x01, 0x75, 0x02, 0xB0, 0x87, 0x60, 0xBA, 0x0E, 0x76, 0x02, 0xC8,
  0x09, 0x0E, 0x02, 0x03, 0xFF, 0xA0, 0x03, 0xFF, 0xA0, 0x30,
  // "ž" (U+017E)
  0x28, 0x15, 0x77, 0x71, 0x81, 0x77, 0x54, 0x05, 0xA0, 0xC0, 0x24, 0x02, 0x0D, 0xA0, 0x55, 0x07,
  0xA0, 0xE0, 0x32, 0x04, 0x0E, 0xA0, 0x67, 0x08, 0xA8, 0x1E, 0x34, 0xB0, 0x77, 0x20, 0xAA, 0x0E,
  0xB0, 0x97, 0x40, 0xCC, 0x0B, 0x75, 0x02, 0xB0, 0xE0, 0x18, 0x0C, 0x70, 0x0B, 0xFF, 0x98, 0x11,
  0x0B, 0xFF, 0x98, 0x11, 0x0B, 0x80, 0x7E, 0xC0, 0x17, 0x50, 0x3B, 0x0C, 0x75, 0x01, 0x0D, 0xA0,
  0xE0, 0x17, 0x50, 0xBB, 0x04, 0x75, 0x07, 0xB0, 0x77, 0x50, 0x3B, 0x0B, 0x75, 0x01, 0x0D, 0xA0,
  0xD0, 0x17, 0x50, 0xBB, 0x03, 0x75, 0x07, 0xB0, 0x67, 0x50, 0x4B, 0x0A, 0x75, 0x01, 0x0E, 0xA0,
  0xD7, 0x60, 0xBA, 0x0E, 0x02, 0x75, 0x08, 0xB0, 0x57, 0x50, 0x4B, 0x09, 0x75, 0x01, 0x0E, 0xA0,
  0xC7, 0x60, 0xBA, 0x0E, 0x02, 0x75, 0x08, 0xB0, 0x47, 0x50, 0x3C, 0x80, 0x90, 0xE0, 0x50, 0x6F,
  0xFA, 0x00, 0x6F, 0xFA, 0x06,
  // "ſ" (U+017F)
  0x48, 0x90, 0x17, 0xBD, 0xFE, 0xDC, 0x95, 0x30, 0x8F, 0xA0, 0xA2, 0x0A, 0xFB, 0x81, 0x50, 0x4B,
  0x81, 0xE7, 0x12, 0x84, 0x14, 0x81, 0x0B, 0xB0, 0x37, 0x20, 0xEA, 0x0B, 0x72, 0x01, 0xB0, 0x77,
  0x20, 0x2B, 0x06, 0x72, 0x02, 0xB0, 0x57, 0x20, 0x2B, 0x05, 0x72, 0x02, 0xB0, 0x57, 0x20, 0x2B,
  0x05, 0x72, 0x02, 0xB0, 0x57, 0x20, 0x2B, 0x05, 0x72, 0x02, 0xB0, 0x57, 0x20, 0x2B, 0x05, 0x72,
  0x02, 0xB0, 0x57, 0x20, 0x2B, 0x05, 0x72, 0x02, 0xB0, 0x57, 0x20, 0x2B, 0x05, 0x72, 0x02, 0xB0,
  0x57, 0x20, 0x2B, 0x05, 0x72, 0x02, 0xB0, 0x57, 0x20, 0x2B, 0x05, 0x72, 0x02, 0xB0, 0x57, 0x20,
  0x2B, 0x05, 0x72, 0x02, 0xB0, 0x57, 0x20, 0x2B, 0x05, 0x72, 0x02, 0xB0, 0x57, 0x20, 0x2B, 0x05,
  0x72, 0x02, 0xB0, 0x57, 0x20,
  // "Ω" (U+03A9)
  0x78, 0x90, 0x16, 0xAD, 0xEE, 0xDB, 0x61, 0x76, 0x06, 0x0E, 0xF9, 0x0E, 0x06, 0x74, 0x09, 0xFD,
  0x09, 0x72, 0x07, 0xC0, 0x80, 0x22, 0x81, 0x17, 0xEB, 0x07, 0x70, 0x2B, 0x0E, 0x03, 0x60, 0x20,
  0xDB, 0x02, 0x60, 0xAB, 0x05, 0x71, 0x04, 0xB0, 0xA5, 0x01, 0xB0, 0xC7, 0x30, 0xCB, 0x50, 0x6B,
  0x06, 0x73, 0x06, 0xB0, 0x54, 0x09, 0xB0, 0x27, 0x30, 0x2B, 0x08, 0x40, 0xCA, 0x0E, 0x75, 0x0E,
  0xA0, 0xB4, 0x0E, 0xA0, 0xC7, 0x50, 0xDA, 0x0D, 0x4B, 0x0B, 0x75, 0x0B, 0xA0, 0xE4, 0xB0, 0xA7,
  0x50, 0xAB, 0x4B, 0x0A, 0x75, 0x0A, 0xB4, 0xB0, 0xA7, 0x50, 0xAA, 0x0E, 0x40, 0xEA, 0x0A, 0x75,
  0x0B, 0xA0, 0xD4, 0x0C, 0xA0, 0xC7, 0x50, 0xCA, 0x0B, 0x40, 0xAA, 0x0D, 0x75, 0x0D, 0xA0, 0x94,
  0x07, 0xB0, 0x17, 0x30, 0x1B, 0x06, 0x40, 0x3B, 0x04, 0x73, 0x04, 0xB0, 0x25, 0x0D, 0xA0, 0x87,
  0x30, 0x8A, 0x0D, 0x60, 0x8A, 0x0D, 0x73, 0x0C, 0xA0, 0x86, 0x02, 0xB0, 0x47, 0x10, 0x3B, 0x02,
  0x70, 0x9A, 0x0C, 0x71, 0x0B, 0xA0, 0x97, 0x10, 0x10, 0xEA, 0x06, 0x60, 0x5A, 0x0E, 0x01, 0x72,
  0x05, 0xA0, 0xE0, 0x24, 0x02, 0x0E, 0xA0, 0x45, 0x02, 0x80, 0x1E, 0xB0, 0xD4, 0x0D, 0xB8, 0x01,
  0xE0, 0x20, 0x3F, 0x90, 0xE4, 0x0E, 0xF9, 0x00, 0x3F, 0x90, 0xE4, 0x0E, 0xF9, 0x03,
  // "μ" (U+03BC)
  0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0,
  0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97,
  0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30,
  0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xCA, 0x0C, 0xB0, 0x97, 0x30, 0xDA,
  0x0C, 0xB0, 0x97, 0x30, 0xEA, 0x0C, 0xB0, 0x97, 0x20, 0x2B, 0x0C, 0xB0, 0xB7, 0x20, 0x6B, 0x0C,
  0xB0, 0xE7, 0x20, 0xDB, 0x0C, 0xC0, 0x87, 0x08, 0xC0, 0xCD, 0x09, 0x02, 0x30, 0x40, 0xAA, 0x0D,
  0xA0, 0xCF, 0x90, 0xEC, 0x09, 0x07, 0xA0, 0xCF, 0xD8, 0x19, 0x04, 0xA0, 0xCB, 0x81, 0xDC, 0xEA,
  0x82, 0xEC, 0x82, 0x20, 0x2A, 0x0C, 0xB0, 0x97, 0x7B, 0x09, 0x77, 0xB0, 0x97, 0x7B, 0x09, 0x77,
  0xB0, 0x97, 0x7B, 0x09, 0x77, 0xB0, 0x97, 0x7B, 0x09, 0x77, 0xB0, 0x97, 0x7B, 0x09, 0x77,
  // "π" (U+03C0)
  0x10, 0x10, 0x9F, 0xFC, 0x07, 0x05, 0xFF, 0xE0, 0x07, 0x80, 0x0E, 0xB8, 0x02, 0xEB, 0x80, 0x0E,
  0x07, 0x40, 0x2B, 0x04, 0x40, 0x3B, 0x04, 0x71, 0x02, 0xB0, 0x44, 0x03, 0xB0, 0x47, 0x10, 0x2B,
  0x04, 0x40, 0x3B, 0x04, 0x71, 0x02, 0xB0, 0x44, 0x03, 0xB0, 0x47, 0x10, 0x2B, 0x04, 0x40, 0x3B,
  0x04, 0x71, 0x02, 0xB0, 0x44, 0x03, 0xB0, 0x47, 0x10, 0x2B, 0x04, 0x40, 0x3B, 0x04, 0x71, 0x02,
  0xB0, 0x44, 0x03, 0xB0, 0x47, 0x10, 0x2B, 0x04, 0x40, 0x3B, 0x04, 0x71, 0x02, 0xB0, 0x44, 0x03,
  0xB0, 0x47, 0x10, 0x2B, 0x04, 0x40, 0x3B, 0x04, 0x71, 0x02, 0xB0, 0x44, 0x03, 0xB0, 0x47, 0x10,
  0x2B, 0x04, 0x40, 0x3B, 0x04, 0x71, 0x02, 0xB0, 0x44, 0x03, 0xB0, 0x47, 0x10, 0x2B, 0x04, 0x40,
  0x2B, 0x06, 0x71, 0x02, 0xB0, 0x45, 0xB8, 0x2C, 0x10, 0x25, 0x02, 0xB0, 0x45, 0x0B, 0xD0, 0xD5,
  0x02, 0xB0, 0x45, 0x03, 0xD0, 0xD5, 0x02, 0xB0, 0x46, 0x84, 0x3B, 0xEF, 0xEC, 0x10,
  // "–" (U+2013)
  0x80, 0x94, 0xEF, 0xFF, 0xFC,
  // "—" (U+2014)
  0x80, 0xA4, 0xE8, 0x0D, 0x4F,
  // "€" (U+20AC)
  0x73, 0x82, 0x28, 0xBD, 0xA8, 0x2E, 0xC9, 0x57, 0x30, 0x20, 0xBF, 0xB0, 0xE0, 0x87, 0x04, 0x0E,
  0xFD, 0x0B, 0x60, 0x4C, 0x81, 0xB5, 0x12, 0x84, 0x15, 0x9E, 0xF3, 0x50, 0x10, 0xEB, 0x06, 0x72,
  0x05, 0x60, 0x8B, 0x06, 0x77, 0x30, 0xEA, 0x0C, 0x77, 0x30, 0x6B, 0x04, 0x77, 0x30, 0xAA, 0x0D,
  0x77, 0x40, 0xEA, 0x09, 0x77, 0x82, 0x29, 0x9A, 0xB0, 0xC8, 0x05, 0x90, 0x14, 0x04, 0xFF, 0xA0,
  0x24, 0x04, 0xFF, 0xA0, 0x27, 0x07, 0xB0, 0x17, 0x73, 0x07, 0xB0, 0x17, 0x73, 0x07, 0xB0, 0x17,
  0x70, 0x4F, 0xFA, 0x02, 0x40, 0x4F, 0xFA, 0x02, 0x40, 0x20, 0xF9, 0xB0, 0xC8, 0x05, 0x90, 0x17,
  0x10, 0xDA, 0x0A, 0x77, 0x40, 0x9A, 0x0E, 0x77, 0x40, 0x5B, 0x05, 0x77, 0x40, 0xDA, 0x0D, 0x77,
  0x40, 0x7B, 0x08, 0x77, 0x40, 0xCB, 0x08, 0x77, 0x30, 0x20, 0xEB, 0x81, 0xD6, 0x23, 0x83, 0x25,
  0x9E, 0x37, 0x03, 0x0D, 0xE0, 0xED, 0x03, 0x71, 0x01, 0x0A, 0xFC, 0x03, 0x73, 0x82, 0x27, 0xBE,
  0xA8, 0x3E, 0xC9, 0x51, 0x10,
  // "₿" (U+20BF)
  0x48, 0x1A, 0xFD, 0x38, 0x1E, 0xF9, 0x73, 0x81, 0xAF, 0xD3, 0x81, 0xEF, 0x97, 0x38, 0x1A, 0xFD,
  0x38, 0x1E, 0xF9, 0x73, 0x81, 0xAF, 0xD3, 0x81, 0xEF, 0x96, 0x03, 0xFC, 0x0C, 0x04, 0x50, 0x3F,
  0xE0, 0xD0, 0x53, 0x03, 0xB8, 0x01, 0xEF, 0x07, 0x20, 0x3B, 0x03, 0x58, 0x11, 0x4A, 0xC8, 0x13,
  0x03, 0xB0, 0x37, 0x10, 0x8B, 0x81, 0x90, 0x3B, 0x03, 0x72, 0x0E, 0xA8, 0x1D, 0x03, 0xB0, 0x37,
  0x20, 0xBB, 0x10, 0x3B, 0x03, 0x72, 0x0A, 0xA8, 0x1E, 0x03, 0xB0, 0x37, 0x20, 0xBA, 0x81, 0xD0,
  0x3B, 0x03, 0x71, 0x01, 0x0E, 0xA8, 0x19, 0x03, 0xB0, 0x37, 0x10, 0x9B, 0x81, 0x20, 0x3B, 0x03,
  0x58, 0x12, 0x5C, 0xB0, 0x62, 0x03, 0xFE, 0x0C, 0x04, 0x30, 0x3F, 0xD0, 0x70, 0x14, 0x03, 0xB8,
  0x01, 0xEE, 0x09, 0x01, 0x20, 0x3B, 0x03, 0x60, 0x30, 0x9B, 0x82, 0xD2, 0x03, 0xB0, 0x37, 0x10,
  0x4B, 0x81, 0xC0, 0x3B, 0x03, 0x72, 0x08, 0xB0, 0x40, 0x3B, 0x03, 0x72, 0x02, 0xB0, 0x90, 0x3B,
  0x03, 0x73, 0x0E, 0xA0, 0xB0, 0x3B, 0x03, 0x73, 0x0D, 0xA0, 0xC0, 0x3B, 0x03, 0x73, 0x0E, 0xA0,
  0xB0, 0x3B, 0x03, 0x72, 0x02, 0xB0, 0x90, 0x3B, 0x03, 0x72, 0x08, 0xB0, 0x50, 0x3B, 0x03, 0x71,
  0x04, 0xB8, 0x1E, 0x03, 0xB0, 0x36, 0x03, 0x09, 0xC8, 0x16, 0x03, 0xB8, 0x01, 0xEF, 0x09, 0x20,
  0x3F, 0xE0, 0xE0, 0x63, 0x03, 0xFC, 0x81, 0xD6, 0x17, 0x18, 0x1A, 0xFD, 0x38, 0x1E, 0xF9, 0x73,
  0x81, 0xAF, 0xD3, 0x81, 0xEF, 0x97, 0x38, 0x1A, 0xFD, 0x38, 0x1E, 0xF9, 0x73, 0x81, 0xAF, 0xD3,
  0x81, 0xEF, 0x96,
  // "‘" (U+2018)
  0x00, 0x0C, 0xFD, 0x00, 0x3F, 0xFA, 0x00, 0xAF, 0xF6, 0x01, 0xFF, 0xF3, 0x06, 0xFF, 0xF0, 0x0C,
  0xFF, 0xC0, 0x1F, 0xFF, 0x90, 0x7F, 0xFF, 0x60, 0xBF, 0xFF, 0x30, 0xEF, 0xFF, 0x10,
  // "’" (U+2019)
  0x20, 0xBB, 0x0A, 0x20, 0xDB, 0x07, 0x2C, 0x81, 0x20, 0x3B, 0x0D, 0x20, 0x6B, 0x07, 0x20, 0x9B,
  0x02, 0x20, 0xCA, 0x0B, 0x3B, 0x05, 0x20, 0x4A, 0x0E, 0x30, 0x7A, 0x08, 0x30,
  // "‚" (U+201A)
  0x20, 0x7C, 0x01, 0x20, 0x9B, 0x0E, 0x30, 0xCB, 0x09, 0x3C, 0x04, 0x20, 0x2B, 0x0E, 0x30, 0x5B,
  0x09, 0x30, 0x8B, 0x03, 0x30, 0xCA, 0x0D, 0x4B, 0x07, 0x30, 0x3A, 0x0E, 0x01, 0x30, 0x7A, 0x09,
  0x40,
  // "‛" (U+201B)
  0x0E, 0xB8, 0x11, 0x0B, 0xB8, 0x14, 0x06, 0xB8, 0x16, 0x01, 0xB0, 0x92, 0x0C, 0xA0, 0xC2, 0x06,
  0xB2, 0x01, 0xB0, 0x32, 0x09, 0xA0, 0x72, 0x03, 0xA0, 0xA3, 0x81, 0xCF, 0xE0,
  // "“" (U+201C)
  0x38, 0x1C, 0xFD, 0x58, 0x1C, 0xFD, 0x20, 0x3A, 0x0A, 0x40, 0x3A, 0x0A, 0x20, 0xAA, 0x06, 0x40,
  0xAA, 0x81, 0x60, 0x1B, 0x03, 0x30, 0x1B, 0x81, 0x30, 0x6B, 0x40, 0x6B, 0x20, 0xCA, 0x0C, 0x40,
  0xCA, 0x81, 0xC0, 0x1B, 0x09, 0x30, 0x1B, 0x81, 0x90, 0x7B, 0x06, 0x30, 0x7B, 0x81, 0x60, 0xBB,
  0x03, 0x30, 0xBB, 0x81, 0x30, 0xEB, 0x01, 0x30, 0xEB, 0x01, 0x10,
  // "”" (U+201D)
  0x10, 0x1B, 0x0E, 0x30, 0x1B, 0x81, 0xE0, 0x3B, 0x0B, 0x30, 0x3B, 0x81, 0xB0, 0x6B, 0x06, 0x30,
  0x6B, 0x81, 0x60, 0x9B, 0x01, 0x30, 0x9B, 0x81, 0x10, 0xCA, 0x0B, 0x40, 0xCA, 0x0B, 0x2B, 0x06,
  0x4B, 0x81, 0x60, 0x3B, 0x01, 0x30, 0x3B, 0x81, 0x10, 0x6A, 0x09, 0x40, 0x6A, 0x09, 0x20, 0xAA,
  0x03, 0x40, 0xAA, 0x03, 0x28, 0x1D, 0xFC, 0x58, 0x1D, 0xFC, 0x30,
  // "„" (U+201E)
  0x20, 0x7C, 0x01, 0x20, 0x7C, 0x01, 0x20, 0x9B, 0x0E, 0x30, 0x9B, 0x0E, 0x30, 0xCB, 0x09, 0x30,
  0xCB, 0x09, 0x3C, 0x04, 0x3C, 0x04, 0x20, 0x2B, 0x0E, 0x30, 0x2B, 0x0E, 0x30, 0x5B, 0x09, 0x30,
  0x5B, 0x09, 0x30, 0x8B, 0x03, 0x30, 0x8B, 0x03, 0x30, 0xCA, 0x0D, 0x40, 0xCA, 0x0D, 0x4B, 0x07,
  0x4B, 0x07, 0x30, 0x3A, 0x0E, 0x01, 0x30, 0x3A, 0x0E, 0x01, 0x30, 0x7A, 0x09, 0x40, 0x7A, 0x09,
  0x40,
  // "‟" (U+201F)
  0x0E, 0xB0, 0x13, 0x0E, 0xB8, 0x11, 0x0B, 0xB0, 0x33, 0x0B, 0xB8, 0x13, 0x07, 0xB0, 0x63, 0x07,
  0xB8, 0x16, 0x01, 0xB0, 0x93, 0x01, 0xB0, 0x92, 0x0C, 0xA0, 0xC4, 0x0C, 0xA0, 0xC2, 0x06, 0xB4,
  0x06, 0xB2, 0x01, 0xB0, 0x33, 0x01, 0xB0, 0x32, 0x0A, 0xA0, 0x64, 0x0A, 0xA0, 0x62, 0x03, 0xA0,
  0xA4, 0x03, 0xA0, 0xA3, 0x81, 0xCF, 0xD5, 0x81, 0xCF, 0xD0,
  // "†" (U+2020)
  0x50, 0x2B, 0x0B, 0x75, 0xB0, 0x97, 0x50, 0xEA, 0x07, 0x75, 0x0C, 0xA0, 0x67, 0x50, 0xAA, 0x04,
  0x75, 0x09, 0xA0, 0x27, 0x50, 0x7A, 0x76, 0x81, 0x5F, 0xE7, 0x89, 0x7A, 0xDC, 0xA9, 0x79, 0xFD,
  0x78, 0x9B, 0xCD, 0x9A, 0xFF, 0x09, 0x0A, 0xD0, 0xEF, 0x98, 0x90, 0x95, 0x64, 0x31, 0x04, 0xFC,
  0x28, 0x32, 0x35, 0x64, 0x68, 0x14, 0xFD, 0x76, 0x81, 0x5F, 0xE7, 0x60, 0x6A, 0x76, 0x07, 0xA7,
  0x60, 0x7A, 0x01, 0x75, 0x08, 0xA0, 0x17, 0x50, 0x9A, 0x02, 0x75, 0x0A, 0xA0, 0x37, 0x50, 0xAA,
  0x04, 0x75, 0x0B, 0xA0, 0x57, 0x50, 0xCA, 0x05, 0x75, 0x0D, 0xA0, 0x67, 0x50, 0xDA, 0x07, 0x75,
  0x0E, 0xA0, 0x87, 0x5B, 0x08, 0x75, 0xB0, 0x97, 0x40, 0x1B, 0x0A, 0x74, 0x02, 0xB0, 0xB7, 0x40,
  0x2B, 0x0B, 0x60,
  // "‡" (U+2021)
  0x6B, 0x0D, 0x75, 0x0D, 0xA0, 0xB7, 0x50, 0xCA, 0x0A, 0x75, 0x0A, 0xA0, 0x87, 0x50, 0x8A, 0x06,
  0x75, 0x06, 0xA0, 0x47, 0x50, 0x4A, 0x02, 0x68, 0x58, 0x97, 0x65, 0x34, 0xA8, 0x63, 0x35, 0x67,
  0x98, 0xDF, 0xF0, 0x0D, 0xFF, 0x86, 0xD8, 0x97, 0x64, 0x34, 0xA8, 0x53, 0x34, 0x67, 0x98, 0x60,
  0x5A, 0x03, 0x75, 0x07, 0xA0, 0x57, 0x50, 0xAA, 0x08, 0x75, 0x0C, 0xA0, 0xA7, 0x50, 0xEA, 0x0C,
  0x75, 0x0C, 0xA0, 0xA7, 0x50, 0xAA, 0x08, 0x75, 0x08, 0xA0, 0x67, 0x50, 0x5A, 0x04, 0x68, 0x13,
  0x21, 0x30, 0x3A, 0x01, 0x38, 0x21, 0x23, 0xDB, 0x81, 0xEC, 0xCA, 0x81, 0xBC, 0xEB, 0x00, 0xDF,
  0xF8, 0x6D, 0xDF, 0xEC, 0xBA, 0xAA, 0x86, 0x9A, 0xBD, 0xEF, 0xD1, 0x50, 0x3A, 0x01, 0x50, 0x16,
  0x05, 0xA0, 0x37, 0x50, 0x7A, 0x05, 0x75, 0x09, 0xA0, 0x77, 0x50, 0xBA, 0x09, 0x75, 0x0D, 0xA0,
  0xB7, 0x5B, 0x0D, 0x60,
  // "•" (U+2022)
  0x28, 0x44, 0xBE, 0xEB, 0x43, 0x06, 0xE8, 0x26, 0x01, 0xEE, 0x81, 0xE1, 0x4F, 0x90, 0x40, 0x6F,
  0x90, 0x06, 0xF9, 0x06, 0x04, 0xF9, 0x81, 0x40, 0xEE, 0x0E, 0x20, 0x6E, 0x06, 0x38, 0x44, 0xBE,
  0xEB, 0x42,
  // "…" (U+2026)
  0x18, 0x28, 0xEE, 0x84, 0x82, 0x8E, 0xE8, 0x48, 0x48, 0xEE, 0x80, 0x4C, 0x04, 0x20, 0x4C, 0x04,
  0x20, 0x4C, 0x04, 0x06, 0xC0, 0x62, 0x06, 0xC0, 0x62, 0x06, 0xC0, 0x60, 0x4C, 0x04, 0x20, 0x4C,
  0x04, 0x20, 0x4C, 0x84, 0x40, 0x8E, 0xE8, 0x48, 0x28, 0xEE, 0x84, 0x82, 0x8E, 0xE8, 0x10,
  // "‰" (U+2030)
  0x28, 0x42, 0xAE, 0xEB, 0x47, 0x73, 0x03, 0x0E, 0xD0, 0x57, 0x72, 0x0C, 0xE0, 0xE0, 0x17, 0x70,
  0x2A, 0x82, 0xE2, 0x1D, 0xA0, 0x57, 0x70, 0x5A, 0x0A, 0x20, 0x7A, 0x08, 0x77, 0x06, 0xA0, 0x92,
  0x06, 0xA0, 0x97, 0x70, 0x5A, 0x09, 0x20, 0x6A, 0x08, 0x78, 0x00, 0x60, 0x52, 0x02, 0xA0, 0xB2,
  0x08, 0xA0, 0x65, 0x04, 0x0D, 0xB0, 0x90, 0x13, 0x0D, 0xA8, 0x14, 0x2D, 0xA0, 0x13, 0x01, 0x0A,
  0xB0, 0xD0, 0x35, 0x04, 0xE0, 0x83, 0x05, 0x0E, 0xB0, 0x77, 0x10, 0x40, 0xDA, 0x0E, 0x07, 0x20,
  0x20, 0xBB, 0x0B, 0x02, 0x74, 0x00, 0x13, 0x07, 0xB0, 0xE0, 0x67, 0x72, 0x03, 0x0C, 0xB0, 0xA0,
  0x17, 0x71, 0x01, 0x09, 0xB0, 0xD0, 0x47, 0x72, 0x05, 0x0E, 0xB0, 0x87, 0x72, 0x01, 0x0A, 0xB0,
  0xC0, 0x37, 0x72, 0x84, 0x6E, 0xEE, 0xE7, 0x77, 0x72, 0x84, 0x19, 0xEF, 0xC4, 0x48, 0x44, 0xBE,
  0xEA, 0x17, 0x01, 0x0D, 0xD0, 0x52, 0x05, 0xD0, 0xE0, 0x16, 0x09, 0xE0, 0xE2, 0x0E, 0xE0, 0xA6,
  0xB8, 0x14, 0x1C, 0xA0, 0x60, 0x5A, 0x81, 0xD1, 0x3B, 0x01, 0x40, 0x3A, 0x0C, 0x20, 0x6A, 0x09,
  0x08, 0xA0, 0x72, 0x0B, 0xA0, 0x44, 0x04, 0xA0, 0xA2, 0x04, 0xA0, 0xA0, 0x9A, 0x05, 0x20, 0x9A,
  0x05, 0x40, 0x4A, 0x0A, 0x20, 0x4A, 0x0A, 0x09, 0xA0, 0x52, 0x09, 0xA0, 0x54, 0x03, 0xA0, 0xB2,
  0x05, 0xA0, 0x90, 0x8A, 0x05, 0x20, 0xAA, 0x04, 0x58, 0x1E, 0xFD, 0x20, 0x8A, 0x06, 0x04, 0xA0,
  0x82, 0x0D, 0xA0, 0x15, 0x09, 0xA8, 0x92, 0x74, 0xEF, 0xE1, 0x0D, 0xFE, 0x47, 0xA0, 0xA6, 0x01,
  0x0D, 0xD0, 0x62, 0x04, 0xD0, 0xE0, 0x27, 0x84, 0x19, 0xEE, 0xC4, 0x48, 0x43, 0xBE, 0xEA, 0x22,
  // "‹" (U+2039)
  0x68, 0x13, 0x91, 0x68, 0x31, 0xEF, 0xE4, 0x50, 0xCA, 0x0C, 0x50, 0xAA, 0x0E, 0x01, 0x40, 0x8B,
  0x03, 0x40, 0x5B, 0x06, 0x40, 0x3B, 0x09, 0x40, 0x20, 0xEA, 0x0B, 0x50, 0x9B, 0x03, 0x50, 0x10,
  0xDA, 0x0C, 0x60, 0x30, 0xEA, 0x0A, 0x60, 0x5B, 0x07, 0x60, 0x7B, 0x05, 0x60, 0xAA, 0x0E, 0x02,
  0x60, 0xCA, 0x0D, 0x01, 0x58, 0x31, 0xDF, 0xD3, 0x60, 0x20, 0x72,
  // "›" (U+203A)
  0x20, 0x70, 0x26, 0x83, 0x3D, 0xFD, 0x15, 0x01, 0x0D, 0xA0, 0xC6, 0x02, 0x0E, 0xA0, 0xA6, 0x05,
  0xB0, 0x76, 0x07, 0xB0, 0x56, 0x0A, 0xA0, 0xE0, 0x36, 0x0C, 0xA0, 0xD0, 0x15, 0x03, 0xB0, 0x95,
  0x0B, 0xA0, 0xE0, 0x24, 0x09, 0xB0, 0x34, 0x06, 0xB0, 0x54, 0x03, 0xB0, 0x84, 0x01, 0x0E, 0xA0,
  0xA5, 0x0C, 0xA0, 0xC5, 0x83, 0x4E, 0xFE, 0x16, 0x81, 0x19, 0x36,
  // "⁄" (U+2044)
  0x75, 0x0A, 0xA0, 0x57, 0x40, 0x1A, 0x0E, 0x75, 0x07, 0xA0, 0x87, 0x50, 0xDA, 0x02, 0x74, 0x05,
  0xA0, 0xB7, 0x50, 0xBA, 0x04, 0x74, 0x02, 0xA0, 0xD7, 0x50, 0x9A, 0x07, 0x75, 0x0E, 0xA0, 0x17,
  0x40, 0x6A, 0x09, 0x75, 0x0D, 0xA0, 0x37, 0x40, 0x4A, 0x0C, 0x75, 0x0A, 0xA0, 0x57, 0x40, 0x1A,
  0x0E, 0x75, 0x08, 0xA0, 0x87, 0x50, 0xEA, 0x02, 0x74, 0x05, 0xA0, 0xA7, 0x50, 0xCA, 0x04, 0x74,
  0x03, 0xA0, 0xD7, 0x50, 0x9A, 0x07, 0x74, 0x83, 0x1E, 0xFE, 0x17, 0x40, 0x7A, 0x09, 0x75, 0x0D,
  0xA0, 0x37, 0x40, 0x4A, 0x0C, 0x75, 0x0B, 0xA0, 0x57, 0x40, 0x2A, 0x0E, 0x75, 0x08, 0xA0, 0x87,
  0x50, 0xEA, 0x01, 0x74, 0x05, 0xA0, 0xA7, 0x50,
  // "™" (U+2122)
  0x01, 0x80, 0x52, 0x84, 0x10, 0x22, 0x21, 0x50, 0xF2, 0x01, 0x06, 0xFA, 0x06, 0x1B, 0x0D, 0x40,
  0x3B, 0x09, 0x06, 0xFA, 0x06, 0x1C, 0x01, 0x30, 0x7B, 0x09, 0x48, 0x19, 0xFE, 0x5C, 0x05, 0x30,
  0xAB, 0x09, 0x48, 0x19, 0xFE, 0x5A, 0x81, 0xCF, 0x83, 0x83, 0xEE, 0xDF, 0x94, 0x81, 0x9F, 0xE5,
  0xA8, 0x18, 0xFC, 0x28, 0x42, 0xFA, 0xEF, 0x94, 0x81, 0x9F, 0xE5, 0xA0, 0x6A, 0x28, 0x46, 0xF5,
  0xEF, 0x94, 0x81, 0x9F, 0xE5, 0xA8, 0x91, 0x5C, 0xF4, 0x0A, 0xF1, 0xEF, 0x94, 0x81, 0x9F, 0xE5,
  0xA8, 0x91, 0x58, 0xF8, 0x0E, 0xD0, 0xEF, 0x94, 0x81, 0x9F, 0xE5, 0xA8, 0x91, 0x54, 0xFB, 0x2F,
  0x90, 0xEF, 0x94, 0x81, 0x9F, 0xE5, 0xA8, 0x91, 0x50, 0xFE, 0x6F, 0x50, 0xEF, 0x94, 0x81, 0x9F,
  0xE5, 0xA8, 0x91, 0x50, 0xCF, 0xDF, 0x10, 0xEF, 0x94, 0x81, 0x9F, 0xE5, 0xA8, 0x15, 0x08, 0xA0,
  0xC2, 0x81, 0xEF, 0x94, 0x81, 0x9F, 0xE5, 0xA8, 0x15, 0x04, 0xA0, 0x82, 0x81, 0xEF, 0x94, 0x81,
  0x9F, 0xE5, 0xA8, 0x15, 0x01, 0xA0, 0x42, 0x81, 0xEF, 0x90,
  // "⅒" (U+2152)
  0x30, 0x10, 0x8A, 0x0E, 0x77, 0x20, 0xAA, 0x05, 0x77, 0x76, 0x06, 0x0E, 0xB0, 0xE7, 0x71, 0x01,
  0xA0, 0xE7, 0x77, 0x50, 0x30, 0xCB, 0x81, 0xEF, 0xE7, 0x71, 0x07, 0xA0, 0x87, 0x77, 0x50, 0xCA,
  0x83, 0xE6, 0x9F, 0xE7, 0x71, 0x0D, 0xA0, 0x27, 0x77, 0x58, 0x63, 0xFA, 0x10, 0xAF, 0xE7, 0x70,
  0x5A, 0x0B, 0x77, 0x77, 0x01, 0x38, 0x1A, 0xFE, 0x77, 0x0B, 0xA0, 0x47, 0x77, 0x74, 0x81, 0xAF,
  0xE7, 0x60, 0x2A, 0x0D, 0x77, 0x77, 0x58, 0x1A, 0xFE, 0x76, 0x09, 0xA0, 0x77, 0x77, 0x75, 0x81,
  0xAF, 0xE7, 0x60, 0xEA, 0x01, 0x77, 0x77, 0x58, 0x1A, 0xFE, 0x75, 0x06, 0xA0, 0x97, 0x77, 0x76,
  0x81, 0xAF, 0xE7, 0x50, 0xDA, 0x03, 0x77, 0x77, 0x68, 0x1A, 0xFE, 0x74, 0x04, 0xA0, 0xC7, 0x77,
  0x77, 0x81, 0xAF, 0xE7, 0x40, 0xAA, 0x05, 0x60, 0x10, 0x8A, 0x0E, 0x71, 0x86, 0x18, 0xDE, 0xEC,
  0x81, 0x71, 0x81, 0xAF, 0xE7, 0x30, 0x1A, 0x0E, 0x60, 0x60, 0xEB, 0x0E, 0x70, 0x40, 0xEE, 0x0E,
  0x03, 0x38, 0x00, 0x28, 0x1B, 0xFE, 0x80, 0x02, 0x60, 0x8A, 0x08, 0x40, 0x30, 0xCB, 0x81, 0xEF,
  0xE6, 0x01, 0x0E, 0xA8, 0x2A, 0x66, 0xBA, 0x0E, 0x01, 0x20, 0xCF, 0xB0, 0x35, 0x0E, 0xA0, 0x24,
  0x0C, 0xA8, 0x3E, 0x69, 0xFE, 0x60, 0x9A, 0x07, 0x40, 0x7A, 0x09, 0x20, 0xCF, 0xB0, 0x34, 0x05,
  0xA0, 0xA5, 0x86, 0x3F, 0xA1, 0x0A, 0xFE, 0x68, 0x1E, 0xFD, 0x68, 0x1C, 0xFE, 0x77, 0x40, 0xCA,
  0x04, 0x60, 0x13, 0x81, 0xAF, 0xE5, 0x03, 0xA0, 0x86, 0x07, 0xA0, 0x37, 0x72, 0x03, 0xA0, 0xD7,
  0x48, 0x1A, 0xFE, 0x50, 0x6A, 0x05, 0x60, 0x4A, 0x05, 0x77, 0x20, 0x9A, 0x07, 0x74, 0x81, 0xAF,
  0xE5, 0x08, 0xA0, 0x36, 0x02, 0xA0, 0x77, 0x71, 0x83, 0x1E, 0xFE, 0x17, 0x48, 0x1A, 0xFE, 0x50,
  0x8A, 0x02, 0x60, 0x1A, 0x08, 0x77, 0x10, 0x7A, 0x09, 0x75, 0x81, 0xAF, 0xE5, 0x08, 0xA0, 0x26,
  0x01, 0xA0, 0x87, 0x71, 0x0D, 0xA0, 0x37, 0x58, 0x1A, 0xFE, 0x50, 0x8A, 0x03, 0x60, 0x2A, 0x07,
  0x77, 0x04, 0xA0, 0xC7, 0x68, 0x1A, 0xFE, 0x50, 0x6A, 0x05, 0x60, 0x4A, 0x05, 0x77, 0x0B, 0xA0,
  0x57, 0x68, 0x1A, 0xFE, 0x50, 0x3A, 0x08, 0x60, 0x7A, 0x03, 0x76, 0x02, 0xA0, 0xE7, 0x78, 0x1A,
  0xFE, 0x68, 0x1E, 0xFD, 0x68, 0x1C, 0xFE, 0x77, 0x08, 0xA0, 0x87, 0x38, 0x00, 0x28, 0x1B, 0xFE,
  0x80, 0x02, 0x20, 0x8A, 0x07, 0x40, 0x6A, 0x09, 0x77, 0x0E, 0xA0, 0x17, 0x30, 0xCF, 0xB8, 0x23,
  0x01, 0xEA, 0x82, 0xA6, 0x6A, 0xA0, 0xE0, 0x17, 0x60, 0x5A, 0x0A, 0x74, 0x0C, 0xFB, 0x03, 0x20,
  0x30, 0xEE, 0x0E, 0x04, 0x80, 0xD0, 0x08, 0x61, 0x8C, 0xEE, 0xD8, 0x13,
  // "∂" (U+2202)
  0x68, 0x74, 0x9C, 0xEF, 0xED, 0xA4, 0x73, 0x0B, 0xFA, 0x0B, 0x72, 0x0C, 0xFB, 0x0C, 0x71, 0x82,
  0xCD, 0x73, 0x28, 0x11, 0x7E, 0xB0, 0x87, 0x04, 0x70, 0x30, 0xEA, 0x0E, 0x01, 0x77, 0x10, 0x7B,
  0x05, 0x77, 0x2B, 0x09, 0x77, 0x20, 0xBA, 0x0C, 0x77, 0x20, 0x8B, 0x78, 0x55, 0xAD, 0xFE, 0xC7,
  0x20, 0x7B, 0x50, 0x20, 0xDF, 0x81, 0xD2, 0x6B, 0x01, 0x30, 0x40, 0xED, 0x0D, 0x0E, 0xA0, 0xD0,
  0x7B, 0x01, 0x20, 0x20, 0xEB, 0x0B, 0x03, 0x30, 0x50, 0xED, 0x30, 0xDB, 0x09, 0x60, 0x3C, 0x0E,
  0x20, 0x6B, 0x0B, 0x71, 0x08, 0xB0, 0xC2, 0x0D, 0xB0, 0x27, 0x10, 0x2B, 0x81, 0xA0, 0x3B, 0x0A,
  0x72, 0x03, 0xB8, 0x17, 0x08, 0xB0, 0x47, 0x20, 0x7B, 0x81, 0x30, 0xBA, 0x0E, 0x73, 0x0B, 0xA0,
  0xE2, 0x0E, 0xA0, 0xB7, 0x20, 0x1B, 0x0A, 0x2B, 0x09, 0x72, 0x07, 0xB0, 0x42, 0xB0, 0x97, 0x20,
  0xEA, 0x0D, 0x3B, 0x0A, 0x71, 0x08, 0xB0, 0x63, 0x0D, 0xA0, 0xD7, 0x04, 0xB0, 0xC4, 0x09, 0xB0,
  0x55, 0x04, 0x0E, 0xB0, 0x34, 0x03, 0xB0, 0xE0, 0x52, 0x02, 0x09, 0xC0, 0x56, 0x09, 0xFC, 0x06,
  0x71, 0x0A, 0xF9, 0x0C, 0x02, 0x73, 0x81, 0x5A, 0xDA, 0x81, 0xDA, 0x57, 0x20,
  // "∆" (U+2206)
  0x73, 0xB0, 0xE7, 0x75, 0x05, 0xC0, 0x47, 0x74, 0x0B, 0xC0, 0x97, 0x73, 0x01, 0xD0, 0xE7, 0x73,
  0x06, 0xA0, 0xC0, 0xEA, 0x05, 0x77, 0x20, 0xBA, 0x08, 0x0A, 0xA0, 0xA7, 0x71, 0x01, 0xB0, 0x30,
  0x5B, 0x01, 0x77, 0x07, 0xA0, 0xE2, 0xB0, 0x57, 0x70, 0xCA, 0x09, 0x20, 0xAA, 0x0B, 0x76, 0x02,
  0xB0, 0x42, 0x05, 0xB0, 0x17, 0x50, 0x7A, 0x0E, 0x40, 0xEA, 0x06, 0x75, 0x0D, 0xA0, 0x94, 0x0A,
  0xA0, 0xC7, 0x40, 0x2B, 0x04, 0x40, 0x4B, 0x02, 0x73, 0x08, 0xA0, 0xE6, 0x0E, 0xA0, 0x77, 0x30,
  0xDA, 0x09, 0x60, 0xAA, 0x0C, 0x72, 0x03, 0xB0, 0x46, 0x04, 0xB0, 0x27, 0x10, 0x8A, 0x0E, 0x71,
  0x0E, 0xA0, 0x87, 0x10, 0xEA, 0x09, 0x71, 0x09, 0xA0, 0xD7, 0x04, 0xB0, 0x37, 0x10, 0x4B, 0x03,
  0x60, 0x9A, 0x0D, 0x73, 0x0E, 0xA0, 0x86, 0x0E, 0xA0, 0x87, 0x30, 0x9A, 0x0E, 0x50, 0x4B, 0x03,
  0x73, 0x04, 0xB0, 0x44, 0x0A, 0xA0, 0xD7, 0x50, 0xEA, 0x09, 0x40, 0xEA, 0x08, 0x75, 0x09, 0xA0,
  0xE3, 0x05, 0xB0, 0x27, 0x50, 0x4B, 0x05, 0x20, 0xAA, 0x0C, 0x77, 0x0E, 0xA8, 0x1A, 0x01, 0xC8,
  0x09, 0x2E, 0xC1, 0x03, 0xFF, 0xF9, 0x00, 0x3F, 0xFF, 0x90, 0x30,
  // "√" (U+221A)
  0x77, 0x60, 0x10, 0xF7, 0x77, 0x60, 0x6A, 0x0B, 0x77, 0x60, 0xBA, 0x05, 0x77, 0x50, 0x1A, 0x0E,
  0x77, 0x60, 0x6A, 0x0A, 0x77, 0x60, 0xCA, 0x04, 0x77, 0x50, 0x2A, 0x0E, 0x77, 0x60, 0x7A, 0x09,
  0x77, 0x60, 0xCA, 0x03, 0x77, 0x50, 0x2A, 0x0D, 0x77, 0x60, 0x8A, 0x08, 0x77, 0x60, 0xDA, 0x02,
  0x77, 0x50, 0x3A, 0x0C, 0x77, 0x60, 0x8A, 0x07, 0x77, 0x60, 0xEA, 0x02, 0x77, 0x50, 0x4A, 0x0C,
  0x50, 0x4D, 0x09, 0x71, 0x09, 0xA0, 0x65, 0x04, 0xD0, 0xE7, 0x10, 0xEA, 0x01, 0x50, 0x40, 0xFE,
  0xB0, 0x46, 0x04, 0xA0, 0xB7, 0x30, 0x8A, 0x09, 0x60, 0xAA, 0x05, 0x73, 0x03, 0xA0, 0xE6, 0x81,
  0xEF, 0xE7, 0x50, 0xDA, 0x04, 0x40, 0x5A, 0x0A, 0x75, 0x07, 0xA0, 0xA4, 0x0B, 0xA0, 0x47, 0x50,
  0x2A, 0x0E, 0x30, 0x1A, 0x0E, 0x77, 0x0B, 0xA0, 0x52, 0x06, 0xA0, 0x97, 0x70, 0x6A, 0x0A, 0x20,
  0xBA, 0x03, 0x77, 0x01, 0xB1, 0x01, 0xA0, 0xD7, 0x72, 0x0A, 0xA0, 0x50, 0x7A, 0x08, 0x77, 0x20,
  0x5A, 0x0A, 0x0C, 0xA0, 0x27, 0x73, 0x0E, 0xC0, 0xC7, 0x74, 0x09, 0xC0, 0x77, 0x74, 0x04, 0xC0,
  0x17, 0x75, 0x0D, 0xA0, 0xB7, 0x76, 0x08, 0xA0, 0x67, 0x40,
  // "∞" (U+221E)
  0x38, 0x43, 0x9C, 0xC9, 0x36, 0x84, 0x39, 0xCC, 0x94, 0x50, 0x8E, 0x07, 0x40, 0x7E, 0x09, 0x30,
  0x7F, 0x90, 0x82, 0x06, 0xF9, 0x81, 0x80, 0x1B, 0x83, 0x71, 0x04, 0xDA, 0x04, 0x03, 0xA8, 0x3C,
  0x40, 0x17, 0xB0, 0x20, 0x7A, 0x07, 0x48, 0x61, 0xDF, 0xED, 0xFD, 0x14, 0x08, 0xA0, 0x70, 0xAA,
  0x60, 0x2C, 0x02, 0x50, 0x1A, 0x82, 0xAB, 0xFE, 0x70, 0x7A, 0x08, 0x78, 0x2E, 0xFB, 0xBA, 0x70,
  0xBA, 0x0D, 0x7A, 0x0A, 0x08, 0xA0, 0x55, 0x08, 0xC0, 0xA5, 0x06, 0xA0, 0x70, 0x3A, 0x0E, 0x04,
  0x20, 0x10, 0x8A, 0x09, 0x08, 0xA0, 0xA0, 0x12, 0x05, 0x0E, 0xA8, 0x11, 0x0A, 0xB0, 0xE0, 0xDB,
  0x0C, 0x20, 0xBB, 0x0D, 0x0E, 0xB0, 0x82, 0x01, 0x0C, 0xE0, 0xC0, 0x13, 0x0B, 0xE0, 0xA5, 0x84,
  0x6C, 0xEF, 0xC7, 0x68, 0x47, 0xCF, 0xEB, 0x53,
  // "≈" (U+2248)
  0x28, 0x66, 0xBE, 0xFD, 0xC8, 0x47, 0x18, 0x25, 0x52, 0xCF, 0x98, 0x1E, 0x94, 0x38, 0x34, 0xAF,
  0x66, 0xC0, 0xEF, 0x90, 0xEC, 0x83, 0x66, 0xFA, 0x43, 0x81, 0x49, 0xEF, 0x98, 0x2C, 0x15, 0x47,
  0x18, 0x64, 0x9C, 0xEF, 0xEB, 0x58, 0x0F, 0x40, 0x86, 0x6B, 0xEF, 0xDC, 0x84, 0x71, 0x82, 0x55,
  0x2C, 0xF9, 0x81, 0xE9, 0x43, 0x83, 0x4A, 0xF6, 0x6C, 0x0E, 0xF9, 0x0E, 0xC8, 0x36, 0x6F, 0xA4,
  0x38, 0x14, 0x9E, 0xF9, 0x82, 0xC1, 0x54, 0x71, 0x86, 0x49, 0xCE, 0xFE, 0xB5, 0x20,
  // "≠" (U+2260)
  0x76, 0x07, 0x01, 0x77, 0x30, 0x6A, 0x0A, 0x77, 0x20, 0xDA, 0x0B, 0x77, 0x10, 0x5B, 0x04, 0x77,
  0x10, 0xCA, 0x0C, 0x77, 0x10, 0x3B, 0x04, 0x50, 0x3F, 0xFC, 0x00, 0x3F, 0xFC, 0x00, 0x3F, 0xFC,
  0x03, 0x71, 0x03, 0xB0, 0x57, 0x71, 0x09, 0xA0, 0xE7, 0x71, 0x01, 0x0E, 0xA0, 0x87, 0x71, 0x06,
  0xB0, 0x27, 0x71, 0x0D, 0xA0, 0xB7, 0x20, 0x3F, 0xFC, 0x00, 0x3F, 0xFC, 0x00, 0x3F, 0xFC, 0x03,
  0x50, 0xBA, 0x0C, 0x77, 0x10, 0x3B, 0x05, 0x77, 0x10, 0xAA, 0x0D, 0x77, 0x10, 0x2B, 0x06, 0x77,
  0x18, 0x22, 0xBF, 0xD7, 0x74, 0x02, 0x04, 0x76,
  // "≤" (U+2264)
  0x77, 0x50, 0x27, 0x73, 0x81, 0x7E, 0x67, 0x71, 0x07, 0x0E, 0xA0, 0x67, 0x60, 0x70, 0xEC, 0x05,
  0x74, 0x07, 0x0E, 0xC0, 0x90, 0x27, 0x30, 0x70, 0xEB, 0x81, 0xE8, 0x17, 0x30, 0x70, 0xEB, 0x81,
  0xE7, 0x17, 0x30, 0x70, 0xEB, 0x0D, 0x07, 0x74, 0x07, 0x0E, 0xB0, 0xD0, 0x67, 0x40, 0x70, 0xEB,
  0x0C, 0x05, 0x75, 0x06, 0xB0, 0xC0, 0x47, 0x70, 0x6C, 0x0A, 0x04, 0x77, 0x05, 0x0C, 0xC0, 0xD0,
  0x67, 0x70, 0x30, 0xAC, 0x81, 0xE9, 0x27, 0x68, 0x11, 0x8E, 0xC0, 0xB0, 0x57, 0x70, 0x60, 0xDC,
  0x81, 0xE7, 0x17, 0x60, 0x40, 0xBD, 0x0A, 0x04, 0x76, 0x02, 0x09, 0xD0, 0x67, 0x78, 0x11, 0x7E,
  0xA0, 0x67, 0x73, 0x81, 0x5C, 0x68, 0x0C, 0x40, 0x05, 0x80, 0x96, 0xD0, 0x50, 0x6F, 0xFC, 0x00,
  0x6F, 0xFC, 0x06,
  // "≥" (U+2265)
  0x02, 0x77, 0x58, 0x16, 0xE7, 0x77, 0x30, 0x6A, 0x0E, 0x07, 0x77, 0x10, 0x5C, 0x0E, 0x07, 0x77,
  0x02, 0x09, 0xC0, 0xE0, 0x77, 0x78, 0x11, 0x8E, 0xB0, 0xE0, 0x77, 0x78, 0x11, 0x7E, 0xB0, 0xE0,
  0x77, 0x71, 0x07, 0x0D, 0xB0, 0xE0, 0x77, 0x71, 0x06, 0x0D, 0xB0, 0xE0, 0x77, 0x71, 0x05, 0x0C,
  0xB0, 0xE0, 0x77, 0x71, 0x04, 0x0C, 0xB0, 0x67, 0x60, 0x40, 0xAC, 0x06, 0x74, 0x06, 0x0D, 0xC0,
  0xC0, 0x57, 0x28, 0x12, 0x9E, 0xC0, 0xA0, 0x37, 0x20, 0x50, 0xBC, 0x81, 0xE8, 0x17, 0x18, 0x11,
  0x7E, 0xC0, 0xD0, 0x67, 0x20, 0x40, 0xAD, 0x0B, 0x04, 0x73, 0x06, 0xD0, 0x90, 0x27, 0x50, 0x6A,
  0x81, 0xE7, 0x17, 0x78, 0x16, 0xC5, 0x80, 0xE5, 0x00, 0x58, 0x09, 0x6D, 0x05, 0x06, 0xFF, 0xC0,
  0x06, 0xFF, 0xC0, 0x60,
};

const Font& font_NotoSansMono_Regular_40() {
  static SmoothFont font(font_NotoSansMono_Regular_40_data);
  return font;
}

}  // namespace roo_display
