#include "8.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSansMono-Bold (Noto Sans Mono Bold)
// Generated on Wed Nov 19 19:10:56 CET 2025
static const uint8_t font_NotoSansMono_Bold_8_data[] PROGMEM = {
  
  // Header
  0x01, 0x02, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x5D, 0x00, 0x00,
  0xFE, 0xFE, 0x0C, 0x09, 0x07, 0xFE, 0x03, 0x00, 0x0E, 0x04, 0x05, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x41, 0x01, 0x02, 0x06, 0x05, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x41, 0x04, 0x03, 0x06, 0x05, 0x00, 0x06, // """ (U+0022)
  0x00, 0x23, 0x40, 0x01, 0x04, 0x06, 0x05, 0x00, 0x0B, // "#" (U+0023)
  0x00, 0x24, 0x40, 0x01, 0x04, 0x07, 0x05, 0x00, 0x1A, // "$" (U+0024)
  0x00, 0x25, 0x40, 0x01, 0x04, 0x06, 0x05, 0x00, 0x2C, // "%" (U+0025)
  0x00, 0x26, 0x40, 0x01, 0x04, 0x06, 0x05, 0x00, 0x3B, // "&" (U+0026)
  0x00, 0x27, 0x41, 0x04, 0x02, 0x06, 0x05, 0x00, 0x4A, // "'" (U+0027)
  0x00, 0x28, 0x41, 0x00, 0x03, 0x06, 0x05, 0x00, 0x4D, // "(" (U+0028)
  0x00, 0x29, 0x41, 0xFF, 0x03, 0x05, 0x05, 0x00, 0x58, // ")" (U+0029)
  0x00, 0x2A, 0x40, 0x04, 0x04, 0x07, 0x05, 0x00, 0x63, // "*" (U+002A)
  0x00, 0x2B, 0x40, 0x02, 0x04, 0x05, 0x05, 0x00, 0x6D, // "+" (U+002B)
  0x00, 0x2C, 0x41, 0x00, 0x02, 0x02, 0x05, 0x00, 0x77, // "," (U+002C)
  0x00, 0x2D, 0x41, 0x02, 0x03, 0x03, 0x05, 0x00, 0x7A, // "-" (U+002D)
  0x00, 0x2E, 0x41, 0x01, 0x02, 0x01, 0x05, 0x00, 0x7D, // "." (U+002E)
  0x00, 0x2F, 0x41, 0x01, 0x03, 0x06, 0x05, 0x00, 0x7E, // "/" (U+002F)
  0x00, 0x30, 0x40, 0x01, 0x04, 0x06, 0x05, 0x00, 0x87, // "0" (U+0030)
  0x00, 0x31, 0x40, 0x01, 0x04, 0x06, 0x05, 0x00, 0x96, // "1" (U+0031)
  0x00, 0x32, 0x40, 0x01, 0x04, 0x06, 0x05, 0x00, 0xA5, // "2" (U+0032)
  0x00, 0x33, 0x40, 0x01, 0x04, 0x06, 0x05, 0x00, 0xB4, // "3" (U+0033)
  0x00, 0x34, 0x40, 0x01, 0x04, 0x06, 0x05, 0x00, 0xC3, // "4" (U+0034)
  0x00, 0x35, 0x40, 0x01, 0x04, 0x06, 0x05, 0x00, 0xD2, // "5" (U+0035)
  0x00, 0x36, 0x40, 0x01, 0x04, 0x06, 0x05, 0x00, 0xE1, // "6" (U+0036)
  0x00, 0x37, 0x40, 0x01, 0x04, 0x06, 0x05, 0x00, 0xF0, // "7" (U+0037)
  0x00, 0x38, 0x40, 0x01, 0x04, 0x06, 0x05, 0x00, 0xFF, // "8" (U+0038)
  0x00, 0x39, 0x40, 0x01, 0x04, 0x06, 0x05, 0x01, 0x0E, // "9" (U+0039)
  0x00, 0x3A, 0x41, 0x01, 0x02, 0x05, 0x05, 0x01, 0x1D, // ":" (U+003A)
  0x00, 0x3B, 0x41, 0x00, 0x03, 0x05, 0x05, 0x01, 0x22, // ";" (U+003B)
  0x00, 0x3C, 0x41, 0x02, 0x04, 0x05, 0x05, 0x01, 0x2B, // "<" (U+003C)
  0x00, 0x3D, 0x40, 0x02, 0x04, 0x05, 0x05, 0x01, 0x33, // "=" (U+003D)
  0x00, 0x3E, 0x40, 0x02, 0x03, 0x05, 0x05, 0x01, 0x3D, // ">" (U+003E)
  0x00, 0x3F, 0x40, 0x01, 0x04, 0x06, 0x05, 0x01, 0x45, // "?" (U+003F)
  0x00, 0x40, 0x40, 0xFE, 0x04, 0x06, 0x05, 0x01, 0x54, // "@" (U+0040)
  0x00, 0x41, 0x40, 0x01, 0x04, 0x06, 0x05, 0x01, 0x6B, // "A" (U+0041)
  0x00, 0x42, 0x40, 0x01, 0x04, 0x06, 0x05, 0x01, 0x7A, // "B" (U+0042)
  0x00, 0x43, 0x40, 0x01, 0x04, 0x06, 0x05, 0x01, 0x89, // "C" (U+0043)
  0x00, 0x44, 0x40, 0x01, 0x04, 0x06, 0x05, 0x01, 0x98, // "D" (U+0044)
  0x00, 0x45, 0x40, 0x01, 0x04, 0x06, 0x05, 0x01, 0xA7, // "E" (U+0045)
  0x00, 0x46, 0x40, 0x01, 0x04, 0x06, 0x05, 0x01, 0xB6, // "F" (U+0046)
  0x00, 0x47, 0x40, 0x01, 0x04, 0x06, 0x05, 0x01, 0xC5, // "G" (U+0047)
  0x00, 0x48, 0x40, 0x01, 0x04, 0x06, 0x05, 0x01, 0xD4, // "H" (U+0048)
  0x00, 0x49, 0x40, 0x01, 0x04, 0x06, 0x05, 0x01, 0xE3, // "I" (U+0049)
  0x00, 0x4A, 0x40, 0x01, 0x03, 0x06, 0x05, 0x01, 0xF2, // "J" (U+004A)
  0x00, 0x4B, 0x40, 0x01, 0x04, 0x06, 0x05, 0x01, 0xFE, // "K" (U+004B)
  0x00, 0x4C, 0x40, 0x01, 0x04, 0x06, 0x05, 0x02, 0x0D, // "L" (U+004C)
  0x00, 0x4D, 0x40, 0x01, 0x04, 0x06, 0x05, 0x02, 0x1C, // "M" (U+004D)
  0x00, 0x4E, 0x40, 0x01, 0x04, 0x06, 0x05, 0x02, 0x2B, // "N" (U+004E)
  0x00, 0x4F, 0x40, 0x01, 0x04, 0x06, 0x05, 0x02, 0x3A, // "O" (U+004F)
  0x00, 0x50, 0x40, 0x01, 0x04, 0x06, 0x05, 0x02, 0x49, // "P" (U+0050)
  0x00, 0x51, 0x40, 0xFF, 0x04, 0x06, 0x05, 0x02, 0x58, // "Q" (U+0051)
  0x00, 0x52, 0x40, 0x01, 0x04, 0x06, 0x05, 0x02, 0x6C, // "R" (U+0052)
  0x00, 0x53, 0x40, 0x01, 0x04, 0x06, 0x05, 0x02, 0x7B, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x04, 0x06, 0x05, 0x02, 0x8A, // "T" (U+0054)
  0x00, 0x55, 0x40, 0x01, 0x04, 0x06, 0x05, 0x02, 0x97, // "U" (U+0055)
  0x00, 0x56, 0x40, 0x01, 0x04, 0x06, 0x05, 0x02, 0xA6, // "V" (U+0056)
  0x00, 0x57, 0x40, 0x01, 0x04, 0x06, 0x05, 0x02, 0xB5, // "W" (U+0057)
  0x00, 0x58, 0x40, 0x01, 0x04, 0x06, 0x05, 0x02, 0xC4, // "X" (U+0058)
  0x00, 0x59, 0x40, 0x01, 0x04, 0x06, 0x05, 0x02, 0xD3, // "Y" (U+0059)
  0x00, 0x5A, 0x40, 0x01, 0x04, 0x06, 0x05, 0x02, 0xE2, // "Z" (U+005A)
  0x00, 0x5B, 0x41, 0xFE, 0x03, 0x06, 0x05, 0x02, 0xF1, // "[" (U+005B)
  0x00, 0x5C, 0x41, 0x01, 0x03, 0x06, 0x05, 0x02, 0xFF, // "\" (U+005C)
  0x00, 0x5D, 0x41, 0x00, 0x03, 0x08, 0x05, 0x03, 0x08, // "]" (U+005D)
  0x00, 0x5E, 0x40, 0x03, 0x04, 0x06, 0x05, 0x03, 0x16, // "^" (U+005E)
  0x00, 0x5F, 0x40, 0xFE, 0x04, 0xFF, 0x05, 0x03, 0x20, // "_" (U+005F)
  0x00, 0x60, 0x41, 0x06, 0x02, 0x07, 0x05, 0x03, 0x25, // "`" (U+0060)
  0x00, 0x61, 0x40, 0x01, 0x04, 0x05, 0x05, 0x03, 0x27, // "a" (U+0061)
  0x00, 0x62, 0x40, 0x01, 0x04, 0x07, 0x05, 0x03, 0x34, // "b" (U+0062)
  0x00, 0x63, 0x40, 0x01, 0x03, 0x05, 0x05, 0x03, 0x46, // "c" (U+0063)
  0x00, 0x64, 0x40, 0x01, 0x04, 0x07, 0x05, 0x03, 0x50, // "d" (U+0064)
  0x00, 0x65, 0x40, 0x01, 0x04, 0x05, 0x05, 0x03, 0x62, // "e" (U+0065)
  0x00, 0x66, 0x40, 0x01, 0x04, 0x07, 0x05, 0x03, 0x6F, // "f" (U+0066)
  0x00, 0x67, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x03, 0x81, // "g" (U+0067)
  0x00, 0x68, 0x40, 0x01, 0x04, 0x07, 0x05, 0x03, 0x93, // "h" (U+0068)
  0x00, 0x69, 0x40, 0x01, 0x04, 0x07, 0x05, 0x03, 0xA5, // "i" (U+0069)
  0x00, 0x6A, 0x40, 0xFF, 0x03, 0x07, 0x05, 0x03, 0xB7, // "j" (U+006A)
  0x00, 0x6B, 0x40, 0x01, 0x04, 0x07, 0x05, 0x03, 0xC9, // "k" (U+006B)
  0x00, 0x6C, 0x40, 0x01, 0x04, 0x07, 0x05, 0x03, 0xDB, // "l" (U+006C)
  0x00, 0x6D, 0x40, 0x01, 0x04, 0x05, 0x05, 0x03, 0xED, // "m" (U+006D)
  0x00, 0x6E, 0x40, 0x01, 0x04, 0x05, 0x05, 0x03, 0xFA, // "n" (U+006E)
  0x00, 0x6F, 0x40, 0x01, 0x04, 0x05, 0x05, 0x04, 0x07, // "o" (U+006F)
  0x00, 0x70, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x04, 0x14, // "p" (U+0070)
  0x00, 0x71, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x04, 0x26, // "q" (U+0071)
  0x00, 0x72, 0x40, 0x01, 0x04, 0x05, 0x05, 0x04, 0x38, // "r" (U+0072)
  0x00, 0x73, 0x40, 0x01, 0x04, 0x05, 0x05, 0x04, 0x45, // "s" (U+0073)
  0x00, 0x74, 0x40, 0x01, 0x04, 0x06, 0x05, 0x04, 0x52, // "t" (U+0074)
  0x00, 0x75, 0x40, 0x01, 0x04, 0x05, 0x05, 0x04, 0x61, // "u" (U+0075)
  0x00, 0x76, 0x40, 0x01, 0x04, 0x05, 0x05, 0x04, 0x6E, // "v" (U+0076)
  0x00, 0x77, 0x40, 0x01, 0x04, 0x05, 0x05, 0x04, 0x7B, // "w" (U+0077)
  0x00, 0x78, 0x40, 0x01, 0x04, 0x05, 0x05, 0x04, 0x88, // "x" (U+0078)
  0x00, 0x79, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x04, 0x95, // "y" (U+0079)
  0x00, 0x7A, 0x40, 0x01, 0x04, 0x05, 0x05, 0x04, 0xA7, // "z" (U+007A)
  0x00, 0x7B, 0x41, 0xFF, 0x03, 0x06, 0x05, 0x04, 0xB4, // "{" (U+007B)
  0x00, 0x7C, 0x02, 0xFF, 0x02, 0x07, 0x05, 0x04, 0xC0, // "|" (U+007C)
  0x00, 0x7D, 0x41, 0xFF, 0x03, 0x06, 0x05, 0x04, 0xC2, // "}" (U+007D)
  0x00, 0x7E, 0x40, 0x03, 0x04, 0x04, 0x05, 0x04, 0xCE, // "~" (U+007E)
  0x00, 0xA1, 0x42, 0xFF, 0x03, 0x04, 0x05, 0x04, 0xD3, // "¡" (U+00A1)
  0x00, 0xA2, 0x40, 0x01, 0x04, 0x06, 0x05, 0x04, 0xD9, // "¢" (U+00A2)
  0x00, 0xA3, 0x40, 0x01, 0x04, 0x06, 0x05, 0x04, 0xE8, // "£" (U+00A3)
  0x00, 0xA4, 0x40, 0x01, 0x04, 0x06, 0x05, 0x04, 0xF7, // "¤" (U+00A4)
  0x00, 0xA5, 0x40, 0x01, 0x04, 0x06, 0x05, 0x05, 0x06, // "¥" (U+00A5)
  0x00, 0xA6, 0x42, 0xFF, 0x02, 0x07, 0x05, 0x05, 0x15, // "¦" (U+00A6)
  0x00, 0xA7, 0x40, 0x01, 0x03, 0x07, 0x05, 0x05, 0x1A, // "§" (U+00A7)
  0x00, 0xA8, 0x41, 0x07, 0x03, 0x07, 0x05, 0x05, 0x28, // "¨" (U+00A8)
  0x00, 0xA9, 0x40, 0x01, 0x04, 0x05, 0x05, 0x05, 0x2A, // "©" (U+00A9)
  0x00, 0xAA, 0x41, 0x04, 0x03, 0x06, 0x05, 0x05, 0x37, // "ª" (U+00AA)
  0x00, 0xAB, 0x40, 0x01, 0x04, 0x04, 0x05, 0x05, 0x3C, // "«" (U+00AB)
  0x00, 0xAC, 0x40, 0x02, 0x04, 0x04, 0x05, 0x05, 0x46, // "¬" (U+00AC)
  0x00, 0xAE, 0x40, 0x01, 0x04, 0x05, 0x05, 0x05, 0x4E, // "®" (U+00AE)
  0x00, 0xAF, 0x41, 0x06, 0x03, 0x07, 0x05, 0x05, 0x5B, // "¯" (U+00AF)
  0x00, 0xB0, 0x41, 0x05, 0x03, 0x07, 0x05, 0x05, 0x5E, // "°" (U+00B0)
  0x00, 0xB1, 0x00, 0x01, 0x04, 0x06, 0x05, 0x05, 0x63, // "±" (U+00B1)
  0x00, 0xB2, 0x41, 0x04, 0x03, 0x07, 0x05, 0x05, 0x6F, // "²" (U+00B2)
  0x00, 0xB3, 0x41, 0x04, 0x03, 0x07, 0x05, 0x05, 0x75, // "³" (U+00B3)
  0x00, 0xB4, 0x41, 0x06, 0x03, 0x07, 0x05, 0x05, 0x7B, // "´" (U+00B4)
  0x00, 0xB5, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x05, 0x7E, // "µ" (U+00B5)
  0x00, 0xB6, 0x40, 0x00, 0x04, 0x07, 0x05, 0x05, 0x90, // "¶" (U+00B6)
  0x00, 0xB7, 0x41, 0x03, 0x02, 0x03, 0x05, 0x05, 0xA4, // "·" (U+00B7)
  0x00, 0xB8, 0x41, 0xFF, 0x03, 0x01, 0x05, 0x05, 0xA5, // "¸" (U+00B8)
  0x00, 0xB9, 0x41, 0x04, 0x03, 0x06, 0x05, 0x05, 0xAA, // "¹" (U+00B9)
  0x00, 0xBA, 0x41, 0x04, 0x03, 0x06, 0x05, 0x05, 0xAF, // "º" (U+00BA)
  0x00, 0xBB, 0x40, 0x01, 0x04, 0x04, 0x05, 0x05, 0xB4, // "»" (U+00BB)
  0x00, 0xBC, 0x40, 0x00, 0x04, 0x06, 0x05, 0x05, 0xBE, // "¼" (U+00BC)
  0x00, 0xBD, 0x40, 0x00, 0x04, 0x06, 0x05, 0x05, 0xD0, // "½" (U+00BD)
  0x00, 0xBE, 0x40, 0x00, 0x04, 0x06, 0x05, 0x05, 0xE2, // "¾" (U+00BE)
  0x00, 0xBF, 0x40, 0xFF, 0x04, 0x04, 0x05, 0x05, 0xF4, // "¿" (U+00BF)
  0x00, 0xC0, 0x40, 0x01, 0x04, 0x08, 0x05, 0x06, 0x03, // "À" (U+00C0)
  0x00, 0xC1, 0x40, 0x01, 0x04, 0x08, 0x05, 0x06, 0x17, // "Á" (U+00C1)
  0x00, 0xC2, 0x40, 0x01, 0x04, 0x08, 0x05, 0x06, 0x2B, // "Â" (U+00C2)
  0x00, 0xC3, 0x40, 0x01, 0x04, 0x07, 0x05, 0x06, 0x3F, // "Ã" (U+00C3)
  0x00, 0xC4, 0x40, 0x01, 0x04, 0x08, 0x05, 0x06, 0x51, // "Ä" (U+00C4)
  0x00, 0xC5, 0x40, 0x01, 0x04, 0x08, 0x05, 0x06, 0x65, // "Å" (U+00C5)
  0x00, 0xC6, 0x40, 0x01, 0x04, 0x06, 0x05, 0x06, 0x79, // "Æ" (U+00C6)
  0x00, 0xC7, 0x40, 0xFF, 0x04, 0x06, 0x05, 0x06, 0x88, // "Ç" (U+00C7)
  0x00, 0xC8, 0x40, 0x01, 0x04, 0x08, 0x05, 0x06, 0x9C, // "È" (U+00C8)
  0x00, 0xC9, 0x40, 0x01, 0x04, 0x08, 0x05, 0x06, 0xB0, // "É" (U+00C9)
  0x00, 0xCA, 0x40, 0x01, 0x04, 0x08, 0x05, 0x06, 0xC4, // "Ê" (U+00CA)
  0x00, 0xCB, 0x00, 0x01, 0x04, 0x08, 0x05, 0x06, 0xD8, // "Ë" (U+00CB)
  0x00, 0xCC, 0x40, 0x01, 0x04, 0x08, 0x05, 0x06, 0xEB, // "Ì" (U+00CC)
  0x00, 0xCD, 0x40, 0x01, 0x04, 0x08, 0x05, 0x06, 0xFF, // "Í" (U+00CD)
  0x00, 0xCE, 0x40, 0x01, 0x04, 0x08, 0x05, 0x07, 0x13, // "Î" (U+00CE)
  0x00, 0xCF, 0x40, 0x01, 0x04, 0x08, 0x05, 0x07, 0x27, // "Ï" (U+00CF)
  0x00, 0xD0, 0x40, 0x01, 0x04, 0x06, 0x05, 0x07, 0x3B, // "Ð" (U+00D0)
  0x00, 0xD1, 0x40, 0x01, 0x04, 0x07, 0x05, 0x07, 0x4A, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x40, 0x01, 0x04, 0x08, 0x05, 0x07, 0x5C, // "Ò" (U+00D2)
  0x00, 0xD3, 0x40, 0x01, 0x04, 0x08, 0x05, 0x07, 0x70, // "Ó" (U+00D3)
  0x00, 0xD4, 0x40, 0x01, 0x04, 0x08, 0x05, 0x07, 0x84, // "Ô" (U+00D4)
  0x00, 0xD5, 0x40, 0x01, 0x04, 0x07, 0x05, 0x07, 0x98, // "Õ" (U+00D5)
  0x00, 0xD6, 0x40, 0x01, 0x04, 0x08, 0x05, 0x07, 0xAA, // "Ö" (U+00D6)
  0x00, 0xD7, 0x40, 0x02, 0x03, 0x05, 0x05, 0x07, 0xBE, // "×" (U+00D7)
  0x00, 0xD8, 0x40, 0x00, 0x04, 0x06, 0x05, 0x07, 0xC6, // "Ø" (U+00D8)
  0x00, 0xD9, 0x40, 0x01, 0x04, 0x08, 0x05, 0x07, 0xD8, // "Ù" (U+00D9)
  0x00, 0xDA, 0x40, 0x01, 0x04, 0x08, 0x05, 0x07, 0xEC, // "Ú" (U+00DA)
  0x00, 0xDB, 0x40, 0x01, 0x04, 0x08, 0x05, 0x08, 0x00, // "Û" (U+00DB)
  0x00, 0xDC, 0x40, 0x01, 0x04, 0x08, 0x05, 0x08, 0x14, // "Ü" (U+00DC)
  0x00, 0xDD, 0x40, 0x01, 0x04, 0x08, 0x05, 0x08, 0x28, // "Ý" (U+00DD)
  0x00, 0xDE, 0x40, 0x01, 0x04, 0x06, 0x05, 0x08, 0x3C, // "Þ" (U+00DE)
  0x00, 0xDF, 0x40, 0x01, 0x04, 0x07, 0x05, 0x08, 0x4B, // "ß" (U+00DF)
  0x00, 0xE0, 0x40, 0x01, 0x04, 0x07, 0x05, 0x08, 0x5D, // "à" (U+00E0)
  0x00, 0xE1, 0x40, 0x01, 0x04, 0x07, 0x05, 0x08, 0x6F, // "á" (U+00E1)
  0x00, 0xE2, 0x40, 0x01, 0x04, 0x07, 0x05, 0x08, 0x81, // "â" (U+00E2)
  0x00, 0xE3, 0x40, 0x01, 0x04, 0x06, 0x05, 0x08, 0x93, // "ã" (U+00E3)
  0x00, 0xE4, 0x40, 0x01, 0x04, 0x07, 0x05, 0x08, 0xA2, // "ä" (U+00E4)
  0x00, 0xE5, 0x40, 0x01, 0x04, 0x07, 0x05, 0x08, 0xB4, // "å" (U+00E5)
  0x00, 0xE6, 0x40, 0x01, 0x04, 0x05, 0x05, 0x08, 0xC6, // "æ" (U+00E6)
  0x00, 0xE7, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x08, 0xD3, // "ç" (U+00E7)
  0x00, 0xE8, 0x40, 0x01, 0x04, 0x07, 0x05, 0x08, 0xE5, // "è" (U+00E8)
  0x00, 0xE9, 0x40, 0x01, 0x04, 0x07, 0x05, 0x08, 0xF7, // "é" (U+00E9)
  0x00, 0xEA, 0x40, 0x01, 0x04, 0x07, 0x05, 0x09, 0x09, // "ê" (U+00EA)
  0x00, 0xEB, 0x00, 0x01, 0x04, 0x07, 0x05, 0x09, 0x1B, // "ë" (U+00EB)
  0x00, 0xEC, 0x40, 0x01, 0x04, 0x07, 0x05, 0x09, 0x2C, // "ì" (U+00EC)
  0x00, 0xED, 0x40, 0x01, 0x04, 0x07, 0x05, 0x09, 0x3E, // "í" (U+00ED)
  0x00, 0xEE, 0x40, 0x01, 0x04, 0x07, 0x05, 0x09, 0x50, // "î" (U+00EE)
  0x00, 0xEF, 0x40, 0x01, 0x04, 0x07, 0x05, 0x09, 0x62, // "ï" (U+00EF)
  0x00, 0xF0, 0x40, 0x01, 0x04, 0x08, 0x05, 0x09, 0x74, // "ð" (U+00F0)
  0x00, 0xF1, 0x40, 0x01, 0x04, 0x06, 0x05, 0x09, 0x88, // "ñ" (U+00F1)
  0x00, 0xF2, 0x40, 0x01, 0x04, 0x07, 0x05, 0x09, 0x97, // "ò" (U+00F2)
  0x00, 0xF3, 0x40, 0x01, 0x04, 0x07, 0x05, 0x09, 0xA9, // "ó" (U+00F3)
  0x00, 0xF4, 0x40, 0x01, 0x04, 0x07, 0x05, 0x09, 0xBB, // "ô" (U+00F4)
  0x00, 0xF5, 0x40, 0x01, 0x04, 0x06, 0x05, 0x09, 0xCD, // "õ" (U+00F5)
  0x00, 0xF6, 0x00, 0x01, 0x04, 0x07, 0x05, 0x09, 0xDC, // "ö" (U+00F6)
  0x00, 0xF7, 0x40, 0x02, 0x04, 0x05, 0x05, 0x09, 0xED, // "÷" (U+00F7)
  0x00, 0xF8, 0x40, 0x01, 0x04, 0x05, 0x05, 0x09, 0xF7, // "ø" (U+00F8)
  0x00, 0xF9, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x04, // "ù" (U+00F9)
  0x00, 0xFA, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x16, // "ú" (U+00FA)
  0x00, 0xFB, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x28, // "û" (U+00FB)
  0x00, 0xFC, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x3A, // "ü" (U+00FC)
  0x00, 0xFD, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x0A, 0x4C, // "ý" (U+00FD)
  0x00, 0xFE, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x0A, 0x63, // "þ" (U+00FE)
  0x00, 0xFF, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x0A, 0x7A, // "ÿ" (U+00FF)
  0x01, 0x00, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0A, 0x91, // "Ā" (U+0100)
  0x01, 0x01, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0A, 0xA5, // "ā" (U+0101)
  0x01, 0x02, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0A, 0xB7, // "Ă" (U+0102)
  0x01, 0x03, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0A, 0xCB, // "ă" (U+0103)
  0x01, 0x04, 0x40, 0xFE, 0x05, 0x06, 0x05, 0x0A, 0xDD, // "Ą" (U+0104)
  0x01, 0x05, 0x40, 0xFE, 0x04, 0x05, 0x05, 0x0A, 0xF8, // "ą" (U+0105)
  0x01, 0x06, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0B, 0x0C, // "Ć" (U+0106)
  0x01, 0x07, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0B, 0x20, // "ć" (U+0107)
  0x01, 0x08, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0B, 0x32, // "Ĉ" (U+0108)
  0x01, 0x09, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0B, 0x46, // "ĉ" (U+0109)
  0x01, 0x0A, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0B, 0x58, // "Ċ" (U+010A)
  0x01, 0x0B, 0x40, 0x01, 0x03, 0x07, 0x05, 0x0B, 0x6C, // "ċ" (U+010B)
  0x01, 0x0C, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0B, 0x7A, // "Č" (U+010C)
  0x01, 0x0D, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0B, 0x8E, // "č" (U+010D)
  0x01, 0x0E, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0B, 0xA0, // "Ď" (U+010E)
  0x01, 0x0F, 0x40, 0x01, 0x05, 0x07, 0x05, 0x0B, 0xB4, // "ď" (U+010F)
  0x01, 0x10, 0x40, 0x01, 0x04, 0x06, 0x05, 0x0B, 0xC9, // "Đ" (U+0110)
  0x01, 0x11, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0B, 0xD8, // "đ" (U+0111)
  0x01, 0x12, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0B, 0xEA, // "Ē" (U+0112)
  0x01, 0x13, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0B, 0xFE, // "ē" (U+0113)
  0x01, 0x14, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0C, 0x10, // "Ĕ" (U+0114)
  0x01, 0x15, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0C, 0x24, // "ĕ" (U+0115)
  0x01, 0x16, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0C, 0x36, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0C, 0x48, // "ė" (U+0117)
  0x01, 0x18, 0x40, 0xFE, 0x04, 0x06, 0x05, 0x0C, 0x59, // "Ę" (U+0118)
  0x01, 0x19, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x0C, 0x70, // "ę" (U+0119)
  0x01, 0x1A, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0C, 0x82, // "Ě" (U+011A)
  0x01, 0x1B, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0C, 0x96, // "ě" (U+011B)
  0x01, 0x1C, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0C, 0xA8, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x0C, 0xBC, // "ĝ" (U+011D)
  0x01, 0x1E, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0C, 0xD3, // "Ğ" (U+011E)
  0x01, 0x1F, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x0C, 0xE7, // "ğ" (U+011F)
  0x01, 0x20, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0C, 0xFE, // "Ġ" (U+0120)
  0x01, 0x21, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0D, 0x11, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0xFE, 0x04, 0x06, 0x05, 0x0D, 0x27, // "Ģ" (U+0122)
  0x01, 0x23, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0D, 0x3C, // "ģ" (U+0123)
  0x01, 0x24, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0D, 0x51, // "Ĥ" (U+0124)
  0x01, 0x25, 0x40, 0x01, 0x04, 0x09, 0x05, 0x0D, 0x65, // "ĥ" (U+0125)
  0x01, 0x26, 0x40, 0x01, 0x04, 0x06, 0x05, 0x0D, 0x7C, // "Ħ" (U+0126)
  0x01, 0x27, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0D, 0x8B, // "ħ" (U+0127)
  0x01, 0x28, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0D, 0x9D, // "Ĩ" (U+0128)
  0x01, 0x29, 0x40, 0x01, 0x04, 0x06, 0x05, 0x0D, 0xAF, // "ĩ" (U+0129)
  0x01, 0x2A, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0D, 0xBE, // "Ī" (U+012A)
  0x01, 0x2B, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0D, 0xD2, // "ī" (U+012B)
  0x01, 0x2C, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0D, 0xE4, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0D, 0xF8, // "ĭ" (U+012D)
  0x01, 0x2E, 0x40, 0xFE, 0x04, 0x06, 0x05, 0x0E, 0x0A, // "Į" (U+012E)
  0x01, 0x2F, 0x40, 0xFE, 0x04, 0x07, 0x05, 0x0E, 0x21, // "į" (U+012F)
  0x01, 0x30, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0E, 0x3A, // "İ" (U+0130)
  0x01, 0x31, 0x40, 0x01, 0x04, 0x05, 0x05, 0x0E, 0x4D, // "ı" (U+0131)
  0x01, 0x32, 0x40, 0x01, 0x04, 0x06, 0x05, 0x0E, 0x5A, // "Ĳ" (U+0132)
  0x01, 0x33, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x0E, 0x69, // "ĳ" (U+0133)
  0x01, 0x34, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0E, 0x80, // "Ĵ" (U+0134)
  0x01, 0x35, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x0E, 0x94, // "ĵ" (U+0135)
  0x01, 0x36, 0x00, 0xFE, 0x04, 0x06, 0x05, 0x0E, 0xAB, // "Ķ" (U+0136)
  0x01, 0x37, 0x40, 0xFE, 0x04, 0x07, 0x05, 0x0E, 0xC1, // "ķ" (U+0137)
  0x01, 0x38, 0x40, 0x01, 0x04, 0x05, 0x05, 0x0E, 0xDA, // "ĸ" (U+0138)
  0x01, 0x39, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0E, 0xE7, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x40, 0x01, 0x04, 0x09, 0x05, 0x0E, 0xFB, // "ĺ" (U+013A)
  0x01, 0x3B, 0x00, 0xFE, 0x04, 0x06, 0x05, 0x0F, 0x12, // "Ļ" (U+013B)
  0x01, 0x3C, 0x40, 0xFE, 0x04, 0x07, 0x05, 0x0F, 0x26, // "ļ" (U+013C)
  0x01, 0x3D, 0x40, 0x01, 0x04, 0x06, 0x05, 0x0F, 0x3F, // "Ľ" (U+013D)
  0x01, 0x3E, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0F, 0x4E, // "ľ" (U+013E)
  0x01, 0x3F, 0x40, 0x01, 0x04, 0x06, 0x05, 0x0F, 0x60, // "Ŀ" (U+013F)
  0x01, 0x40, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0F, 0x6F, // "ŀ" (U+0140)
  0x01, 0x41, 0x40, 0x01, 0x04, 0x06, 0x05, 0x0F, 0x81, // "Ł" (U+0141)
  0x01, 0x42, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0F, 0x90, // "ł" (U+0142)
  0x01, 0x43, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0F, 0xA2, // "Ń" (U+0143)
  0x01, 0x44, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0F, 0xB6, // "ń" (U+0144)
  0x01, 0x45, 0x00, 0xFE, 0x04, 0x06, 0x05, 0x0F, 0xC8, // "Ņ" (U+0145)
  0x01, 0x46, 0x00, 0xFE, 0x04, 0x05, 0x05, 0x0F, 0xDD, // "ņ" (U+0146)
  0x01, 0x47, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0F, 0xF0, // "Ň" (U+0147)
  0x01, 0x48, 0x40, 0x01, 0x04, 0x07, 0x05, 0x10, 0x04, // "ň" (U+0148)
  0x01, 0x49, 0xBF, 0x01, 0x04, 0x06, 0x05, 0x10, 0x16, // "ŉ" (U+0149)
  0x01, 0x4A, 0x40, 0xFE, 0x04, 0x06, 0x05, 0x10, 0x28, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x10, 0x3F, // "ŋ" (U+014B)
  0x01, 0x4C, 0x40, 0x01, 0x04, 0x08, 0x05, 0x10, 0x51, // "Ō" (U+014C)
  0x01, 0x4D, 0x40, 0x01, 0x04, 0x07, 0x05, 0x10, 0x65, // "ō" (U+014D)
  0x01, 0x4E, 0x40, 0x01, 0x04, 0x08, 0x05, 0x10, 0x77, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x40, 0x01, 0x04, 0x07, 0x05, 0x10, 0x8B, // "ŏ" (U+014F)
  0x01, 0x50, 0x40, 0x01, 0x04, 0x08, 0x05, 0x10, 0x9D, // "Ő" (U+0150)
  0x01, 0x51, 0x40, 0x01, 0x04, 0x07, 0x05, 0x10, 0xB1, // "ő" (U+0151)
  0x01, 0x52, 0x40, 0x01, 0x04, 0x06, 0x05, 0x10, 0xC3, // "Œ" (U+0152)
  0x01, 0x53, 0x40, 0x01, 0x04, 0x05, 0x05, 0x10, 0xD2, // "œ" (U+0153)
  0x01, 0x54, 0x40, 0x01, 0x04, 0x08, 0x05, 0x10, 0xDF, // "Ŕ" (U+0154)
  0x01, 0x55, 0x40, 0x01, 0x04, 0x07, 0x05, 0x10, 0xF3, // "ŕ" (U+0155)
  0x01, 0x56, 0x00, 0xFE, 0x04, 0x06, 0x05, 0x11, 0x05, // "Ŗ" (U+0156)
  0x01, 0x57, 0x00, 0xFE, 0x04, 0x05, 0x05, 0x11, 0x1B, // "ŗ" (U+0157)
  0x01, 0x58, 0x40, 0x01, 0x04, 0x08, 0x05, 0x11, 0x2D, // "Ř" (U+0158)
  0x01, 0x59, 0x40, 0x01, 0x04, 0x07, 0x05, 0x11, 0x41, // "ř" (U+0159)
  0x01, 0x5A, 0x40, 0x01, 0x04, 0x08, 0x05, 0x11, 0x53, // "Ś" (U+015A)
  0x01, 0x5B, 0x40, 0x01, 0x04, 0x07, 0x05, 0x11, 0x67, // "ś" (U+015B)
  0x01, 0x5C, 0x40, 0x01, 0x04, 0x08, 0x05, 0x11, 0x79, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x40, 0x01, 0x04, 0x07, 0x05, 0x11, 0x8D, // "ŝ" (U+015D)
  0x01, 0x5E, 0x40, 0xFF, 0x04, 0x06, 0x05, 0x11, 0x9F, // "Ş" (U+015E)
  0x01, 0x5F, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x11, 0xB3, // "ş" (U+015F)
  0x01, 0x60, 0x40, 0x01, 0x04, 0x08, 0x05, 0x11, 0xC5, // "Š" (U+0160)
  0x01, 0x61, 0x40, 0x01, 0x04, 0x07, 0x05, 0x11, 0xD9, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFF, 0x04, 0x06, 0x05, 0x11, 0xEB, // "Ţ" (U+0162)
  0x01, 0x63, 0x40, 0xFF, 0x04, 0x06, 0x05, 0x11, 0xFE, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x04, 0x08, 0x05, 0x12, 0x12, // "Ť" (U+0164)
  0x01, 0x65, 0x40, 0x01, 0x04, 0x07, 0x05, 0x12, 0x25, // "ť" (U+0165)
  0x01, 0x66, 0x40, 0x01, 0x04, 0x06, 0x05, 0x12, 0x37, // "Ŧ" (U+0166)
  0x01, 0x67, 0x40, 0x01, 0x04, 0x06, 0x05, 0x12, 0x46, // "ŧ" (U+0167)
  0x01, 0x68, 0x40, 0x01, 0x04, 0x07, 0x05, 0x12, 0x55, // "Ũ" (U+0168)
  0x01, 0x69, 0x40, 0x01, 0x04, 0x06, 0x05, 0x12, 0x67, // "ũ" (U+0169)
  0x01, 0x6A, 0x40, 0x01, 0x04, 0x08, 0x05, 0x12, 0x76, // "Ū" (U+016A)
  0x01, 0x6B, 0x40, 0x01, 0x04, 0x07, 0x05, 0x12, 0x8A, // "ū" (U+016B)
  0x01, 0x6C, 0x40, 0x01, 0x04, 0x08, 0x05, 0x12, 0x9C, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x40, 0x01, 0x04, 0x07, 0x05, 0x12, 0xB0, // "ŭ" (U+016D)
  0x01, 0x6E, 0x40, 0x01, 0x04, 0x08, 0x05, 0x12, 0xC2, // "Ů" (U+016E)
  0x01, 0x6F, 0x40, 0x01, 0x04, 0x07, 0x05, 0x12, 0xD6, // "ů" (U+016F)
  0x01, 0x70, 0x40, 0x01, 0x04, 0x08, 0x05, 0x12, 0xE8, // "Ű" (U+0170)
  0x01, 0x71, 0x40, 0x01, 0x04, 0x07, 0x05, 0x12, 0xFC, // "ű" (U+0171)
  0x01, 0x72, 0x40, 0xFF, 0x04, 0x06, 0x05, 0x13, 0x0E, // "Ų" (U+0172)
  0x01, 0x73, 0x40, 0xFE, 0x04, 0x05, 0x05, 0x13, 0x22, // "ų" (U+0173)
  0x01, 0x74, 0x40, 0x01, 0x04, 0x08, 0x05, 0x13, 0x36, // "Ŵ" (U+0174)
  0x01, 0x75, 0x40, 0x01, 0x04, 0x07, 0x05, 0x13, 0x4A, // "ŵ" (U+0175)
  0x01, 0x76, 0x40, 0x01, 0x04, 0x08, 0x05, 0x13, 0x5C, // "Ŷ" (U+0176)
  0x01, 0x77, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x13, 0x70, // "ŷ" (U+0177)
  0x01, 0x78, 0x40, 0x01, 0x04, 0x08, 0x05, 0x13, 0x87, // "Ÿ" (U+0178)
  0x01, 0x79, 0x40, 0x01, 0x04, 0x08, 0x05, 0x13, 0x9B, // "Ź" (U+0179)
  0x01, 0x7A, 0x40, 0x01, 0x04, 0x07, 0x05, 0x13, 0xAF, // "ź" (U+017A)
  0x01, 0x7B, 0x00, 0x01, 0x04, 0x08, 0x05, 0x13, 0xC1, // "Ż" (U+017B)
  0x01, 0x7C, 0x00, 0x01, 0x04, 0x07, 0x05, 0x13, 0xD4, // "ż" (U+017C)
  0x01, 0x7D, 0x40, 0x01, 0x04, 0x08, 0x05, 0x13, 0xE4, // "Ž" (U+017D)
  0x01, 0x7E, 0x40, 0x01, 0x04, 0x07, 0x05, 0x13, 0xF8, // "ž" (U+017E)
  0x01, 0x7F, 0x41, 0x01, 0x03, 0x07, 0x05, 0x14, 0x0A, // "ſ" (U+017F)
  0x03, 0xA9, 0x40, 0x01, 0x04, 0x06, 0x05, 0x14, 0x15, // "Ω" (U+03A9)
  0x03, 0xBC, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x14, 0x24, // "μ" (U+03BC)
  0x03, 0xC0, 0x40, 0x01, 0x04, 0x05, 0x05, 0x14, 0x36, // "π" (U+03C0)
  0x20, 0x13, 0x40, 0x02, 0x03, 0x03, 0x05, 0x14, 0x43, // "–" (U+2013)
  0x20, 0x14, 0x40, 0x02, 0x04, 0x03, 0x05, 0x14, 0x47, // "—" (U+2014)
  0x20, 0xAC, 0x40, 0x01, 0x04, 0x06, 0x05, 0x14, 0x4C, // "€" (U+20AC)
  0x20, 0xBF, 0x40, 0x00, 0x04, 0x07, 0x05, 0x14, 0x5B, // "₿" (U+20BF)
  0x20, 0x18, 0x41, 0x04, 0x02, 0x06, 0x05, 0x14, 0x6F, // "‘" (U+2018)
  0x20, 0x19, 0x41, 0x04, 0x03, 0x06, 0x05, 0x14, 0x72, // "’" (U+2019)
  0x20, 0x1A, 0x41, 0x00, 0x02, 0x02, 0x05, 0x14, 0x77, // "‚" (U+201A)
  0x20, 0x1B, 0x41, 0x04, 0x02, 0x06, 0x05, 0x14, 0x7A, // "‛" (U+201B)
  0x20, 0x1C, 0x40, 0x04, 0x03, 0x06, 0x05, 0x14, 0x7D, // "“" (U+201C)
  0x20, 0x1D, 0x41, 0x04, 0x04, 0x06, 0x05, 0x14, 0x83, // "”" (U+201D)
  0x20, 0x1E, 0x40, 0x00, 0x03, 0x02, 0x05, 0x14, 0x89, // "„" (U+201E)
  0x20, 0x1F, 0x40, 0x04, 0x03, 0x06, 0x05, 0x14, 0x8F, // "‟" (U+201F)
  0x20, 0x20, 0x40, 0x01, 0x03, 0x07, 0x05, 0x14, 0x95, // "†" (U+2020)
  0x20, 0x21, 0x40, 0x01, 0x03, 0x07, 0x05, 0x14, 0xA3, // "‡" (U+2021)
  0x20, 0x22, 0x41, 0x03, 0x03, 0x05, 0x05, 0x14, 0xB1, // "•" (U+2022)
  0x20, 0x26, 0xBF, 0x01, 0x04, 0x01, 0x05, 0x14, 0xB6, // "…" (U+2026)
  0x20, 0x30, 0x40, 0x01, 0x04, 0x06, 0x05, 0x14, 0xB9, // "‰" (U+2030)
  0x20, 0x39, 0x41, 0x01, 0x03, 0x04, 0x05, 0x14, 0xC8, // "‹" (U+2039)
  0x20, 0x3A, 0x41, 0x01, 0x03, 0x04, 0x05, 0x14, 0xCE, // "›" (U+203A)
  0x20, 0x44, 0xBE, 0x01, 0x01, 0x06, 0x00, 0x14, 0xD4, // "⁄" (U+2044)
  0x21, 0x22, 0x40, 0x04, 0x04, 0x06, 0x05, 0x14, 0xE0, // "™" (U+2122)
  0x21, 0x52, 0x02, 0x01, 0x0C, 0x06, 0x0E, 0x14, 0xE8, // "⅒" (U+2152)
  0x22, 0x02, 0x40, 0x01, 0x04, 0x06, 0x05, 0x15, 0x07, // "∂" (U+2202)
  0x22, 0x06, 0x40, 0x01, 0x04, 0x06, 0x05, 0x15, 0x16, // "∆" (U+2206)
  0x22, 0x1A, 0x40, 0x01, 0x04, 0x08, 0x05, 0x15, 0x25, // "√" (U+221A)
  0x22, 0x1E, 0x40, 0x02, 0x04, 0x04, 0x05, 0x15, 0x39, // "∞" (U+221E)
  0x22, 0x48, 0x40, 0x02, 0x04, 0x05, 0x05, 0x15, 0x41, // "≈" (U+2248)
  0x22, 0x60, 0x00, 0x01, 0x04, 0x05, 0x05, 0x15, 0x4B, // "≠" (U+2260)
  0x22, 0x64, 0x40, 0x01, 0x04, 0x06, 0x05, 0x15, 0x57, // "≤" (U+2264)
  0x22, 0x65, 0x40, 0x01, 0x04, 0x06, 0x05, 0x15, 0x66, // "≥" (U+2265)
  
  // Kerning pairs
  
  // Glyph data
  // "!" (U+0021)
  0x3F, 0x3F, 0x2F, 0x2E, 0x00, 0x2D,
  // """ (U+0022)
  0xE6, 0xBD, 0x4A, 0x10, 0x10,
  // "#" (U+0023)
  0x06, 0x6C, 0x09, 0xFE, 0xFA, 0x1B, 0x69, 0x1C, 0xFE, 0xF6, 0x1C, 0x95, 0x02, 0xAA, 0x20,
  // "$" (U+0024)
  0x03, 0xB4, 0x03, 0xDC, 0xA0, 0x3D, 0x90, 0x00, 0x5E, 0xA0, 0x11, 0x8E, 0x14, 0xFF, 0xB0, 0x00,
  0x80, 0x00,
  // "%" (U+0025)
  0xAD, 0x1C, 0x1C, 0x99, 0x80, 0xBE, 0xD1, 0x00, 0x5B, 0xD6, 0x0B, 0x88, 0xB4, 0x93, 0xE7,
  // "&" (U+0026)
  0x1D, 0xD1, 0x04, 0xBA, 0x30, 0x1E, 0xC0, 0x05, 0xDB, 0xB5, 0xA6, 0xAE, 0x05, 0xEC, 0xD5,
  // "'" (U+0027)
  0x1E, 0x0D, 0x01,
  // "(" (U+0028)
  0x09, 0x41, 0xD0, 0x59, 0x07, 0x80, 0x69, 0x02, 0xD0, 0x09, 0x50,
  // ")" (U+0029)
  0x5A, 0x00, 0xD2, 0x09, 0x60, 0x87, 0x09, 0x50, 0xD2, 0x49, 0x00,
  // "*" (U+002A)
  0x00, 0xC0, 0x04, 0xAD, 0xB1, 0x08, 0xE5, 0x00, 0x83, 0x60,
  // "+" (U+002B)
  0x00, 0xD0, 0x06, 0xEF, 0xE3, 0x01, 0xD1, 0x00, 0x0D, 0x00,
  // "," (U+002C)
  0x1D, 0x3D, 0x58,
  // "-" (U+002D)
  0xBE, 0x81, 0x11,
  // "." (U+002E)
  0x2D,
  // "/" (U+002F)
  0x02, 0xC0, 0x87, 0x0D, 0x14, 0xB0, 0xA5, 0x0E, 0x00,
  // "0" (U+0030)
  0x0B, 0xE8, 0x06, 0xC5, 0xF2, 0x88, 0xCD, 0x58, 0xD7, 0xC5, 0x5E, 0x2E, 0x30, 0xAE, 0x90,
  // "1" (U+0031)
  0x08, 0xF2, 0x03, 0xBF, 0x20, 0x00, 0xF2, 0x00, 0x0F, 0x20, 0x00, 0xF2, 0x01, 0xDF, 0xE3,
  // "2" (U+0032)
  0x3C, 0xEA, 0x01, 0x52, 0xF3, 0x00, 0x2E, 0x10, 0x1D, 0x50, 0x1D, 0x60, 0x08, 0xFF, 0xF6,
  // "3" (U+0033)
  0x2C, 0xEA, 0x00, 0x33, 0xF0, 0x08, 0xF8, 0x00, 0x13, 0xF2, 0x22, 0x3F, 0x35, 0xEE, 0x80,
  // "4" (U+0034)
  0x00, 0x9B, 0x00, 0x3F, 0xB0, 0x0B, 0xAB, 0x04, 0xB5, 0xB0, 0xAE, 0xEF, 0x71, 0x16, 0xC0,
  // "5" (U+0035)
  0x1F, 0xFD, 0x02, 0xE1, 0x10, 0x4F, 0xB6, 0x00, 0x24, 0xF1, 0x22, 0x4F, 0x14, 0xEE, 0x70,
  // "6" (U+0036)
  0x06, 0xDE, 0x03, 0xE3, 0x10, 0x7C, 0xDB, 0x08, 0xD3, 0xE4, 0x5C, 0x2E, 0x40, 0xAE, 0xA0,
  // "7" (U+0037)
  0x9F, 0xFF, 0x60, 0x02, 0xF2, 0x00, 0x7A, 0x00, 0x0E, 0x40, 0x05, 0xD0, 0x00, 0xC6, 0x00,
  // "8" (U+0038)
  0x1B, 0xEA, 0x04, 0xD2, 0xF1, 0x0C, 0xCA, 0x03, 0xD9, 0xD1, 0x7B, 0x1E, 0x42, 0xCE, 0xA0,
  // "9" (U+0039)
  0x1B, 0xE7, 0x07, 0xB2, 0xF2, 0x8B, 0x1E, 0x53, 0xEE, 0xE4, 0x01, 0x5E, 0x02, 0xFC, 0x40,
  // ":" (U+003A)
  0x2D, 0x00, 0x00, 0x00, 0x2D,
  // ";" (U+003B)
  0x0E, 0x20, 0x00, 0x00, 0x01, 0xD0, 0x3D, 0x05, 0x80,
  // "<" (U+003C)
  0x00, 0x73, 0x6C, 0x70, 0xBA, 0x20, 0x03, 0xB4,
  // "=" (U+003D)
  0x6E, 0xEE, 0x30, 0x11, 0x10, 0x6E, 0xEE, 0x30, 0x11, 0x10,
  // ">" (U+003E)
  0x37, 0x00, 0x07, 0xC6, 0x03, 0xAB, 0x4B, 0x30,
  // "?" (U+003F)
  0x2C, 0xE9, 0x00, 0x42, 0xF1, 0x00, 0x7D, 0x00, 0x3D, 0x10, 0x01, 0x30, 0x00, 0x5B, 0x00,
  // "@" (U+0040)
  0x09, 0xEA, 0x06, 0xA1, 0x96, 0xB5, 0xD7, 0xAC, 0xA7, 0x7B, 0xCB, 0x68, 0xAC, 0x8D, 0xE5, 0x96,
  0x02, 0x01, 0xCF, 0xD0, 0x00, 0x10, 0x00,
  // "A" (U+0041)
  0x07, 0xF4, 0x00, 0xBA, 0x80, 0x0E, 0x2C, 0x04, 0xFE, 0xF1, 0x88, 0x1B, 0x5C, 0x40, 0x89,
  // "B" (U+0042)
  0x5F, 0xFC, 0x15, 0xB1, 0xE4, 0x5F, 0xEC, 0x05, 0xB2, 0xD5, 0x5B, 0x1D, 0x65, 0xFF, 0xB1,
  // "C" (U+0043)
  0x07, 0xEE, 0x44, 0xE3, 0x20, 0x8A, 0x00, 0x08, 0x90, 0x00, 0x5D, 0x21, 0x10, 0x9E, 0xE2,
  // "D" (U+0044)
  0x9F, 0xE8, 0x09, 0x82, 0xE4, 0x97, 0x0A, 0x79, 0x70, 0xA7, 0x98, 0x3E, 0x39, 0xFE, 0x70,
  // "E" (U+0045)
  0x5F, 0xFF, 0x35, 0xC0, 0x00, 0x5F, 0xEE, 0x15, 0xC1, 0x10, 0x5C, 0x00, 0x05, 0xFF, 0xF3,
  // "F" (U+0046)
  0x5F, 0xFF, 0x35, 0xC0, 0x00, 0x5F, 0xEE, 0x15, 0xC1, 0x10, 0x5B, 0x00, 0x05, 0xB0, 0x00,
  // "G" (U+0047)
  0x09, 0xED, 0x26, 0xD2, 0x10, 0xA7, 0x5E, 0x6B, 0x70, 0xA6, 0x7C, 0x1A, 0x60, 0xAE, 0xE5,
  // "H" (U+0048)
  0x98, 0x0B, 0x69, 0x80, 0xB6, 0x9F, 0xEF, 0x69, 0x81, 0xB6, 0x98, 0x0B, 0x69, 0x80, 0xB6,
  // "I" (U+0049)
  0x4F, 0xFF, 0x10, 0x2E, 0x00, 0x02, 0xE0, 0x00, 0x2E, 0x00, 0x02, 0xE0, 0x03, 0xEF, 0xD1,
  // "J" (U+004A)
  0x00, 0x3E, 0x00, 0x3E, 0x00, 0x3E, 0x00, 0x3E, 0x11, 0x7C, 0x4F, 0xE5,
  // "K" (U+004B)
  0x97, 0x1E, 0x39, 0x7A, 0x80, 0x9B, 0xD0, 0x09, 0xEE, 0x20, 0x97, 0x8A, 0x09, 0x71, 0xE3,
  // "L" (U+004C)
  0x4D, 0x00, 0x04, 0xD0, 0x00, 0x4D, 0x00, 0x04, 0xD0, 0x00, 0x4D, 0x22, 0x04, 0xFF, 0xF3,
  // "M" (U+004D)
  0xAE, 0x1F, 0x7A, 0xE5, 0xF7, 0xAC, 0x9D, 0x7A, 0xBE, 0xB7, 0xA9, 0xF9, 0x7A, 0x50, 0x87,
  // "N" (U+004E)
  0x9F, 0x19, 0x69, 0xD6, 0x96, 0x99, 0xB9, 0x69, 0x6D, 0x96, 0x96, 0x9D, 0x69, 0x64, 0xF6,
  // "O" (U+004F)
  0x1B, 0xE9, 0x08, 0xB2, 0xD4, 0xB7, 0x0A, 0x7B, 0x70, 0xA7, 0x8B, 0x1D, 0x41, 0xBE, 0x90,
  // "P" (U+0050)
  0x5F, 0xFB, 0x15, 0xC1, 0xC6, 0x5B, 0x0C, 0x65, 0xFF, 0xC1, 0x5C, 0x10, 0x05, 0xB0, 0x00,
  // "Q" (U+0051)
  0x1B, 0xE9, 0x08, 0xB2, 0xD4, 0xB7, 0x0A, 0x7B, 0x70, 0xA8, 0x8B, 0x1D, 0x51, 0xBF, 0xC0, 0x00,
  0x4D, 0x00, 0x00, 0x72,
  // "R" (U+0052)
  0x5F, 0xEA, 0x05, 0xC2, 0xF3, 0x5F, 0xFA, 0x05, 0xC9, 0x90, 0x5C, 0x2E, 0x15, 0xC0, 0xB7,
  // "S" (U+0053)
  0x0B, 0xFD, 0x14, 0xE1, 0x30, 0x1D, 0x91, 0x00, 0x18, 0xE1, 0x22, 0x1E, 0x44, 0xEE, 0xA0,
  // "T" (U+0054)
  0x0B, 0xB8, 0x18, 0x03, 0x93, 0x02, 0x93, 0x02, 0x93, 0x02, 0x93, 0x02, 0x92,
  // "U" (U+0055)
  0x98, 0x0B, 0x69, 0x80, 0xB6, 0x98, 0x0B, 0x69, 0x80, 0xB6, 0x8B, 0x2D, 0x51, 0xCE, 0xA0,
  // "V" (U+0056)
  0xC5, 0x09, 0x87, 0x90, 0xC4, 0x3D, 0x0E, 0x00, 0xE5, 0xB0, 0x0A, 0xC7, 0x00, 0x6F, 0x20,
  // "W" (U+0057)
  0xD2, 0x05, 0xAC, 0x6F, 0x69, 0xB9, 0xE9, 0x8A, 0xCA, 0xC7, 0x9E, 0x6E, 0x68, 0xF3, 0xF5,
  // "X" (U+0058)
  0x7A, 0x0D, 0x30, 0xD8, 0xB0, 0x05, 0xF2, 0x00, 0x6F, 0x30, 0x1E, 0x7C, 0x08, 0x90, 0xC5,
  // "Y" (U+0059)
  0x99, 0x0C, 0x62, 0xE3, 0xE0, 0x0B, 0xD8, 0x00, 0x4F, 0x10, 0x02, 0xF0, 0x00, 0x2F, 0x00,
  // "Z" (U+005A)
  0x2F, 0xFF, 0x30, 0x05, 0xD0, 0x00, 0xD4, 0x00, 0x6B, 0x00, 0x1E, 0x30, 0x05, 0xFF, 0xF3,
  // "[" (U+005B)
  0x2F, 0xB2, 0xD0, 0x2C, 0x02, 0xC0, 0x2C, 0x02, 0xC0, 0x2C, 0x02, 0xFB, 0x01, 0x10,
  // "\" (U+005C)
  0xC2, 0x07, 0x80, 0x1D, 0x00, 0xB4, 0x05, 0xA0, 0x0E,
  // "]" (U+005D)
  0x11, 0x0B, 0xF2, 0x0C, 0x20, 0xC2, 0x0C, 0x20, 0xC2, 0x0C, 0x20, 0xD2, 0xBF, 0x20,
  // "^" (U+005E)
  0x02, 0xC0, 0x00, 0x9D, 0x40, 0x1D, 0x2B, 0x07, 0x70, 0xA3,
  // "_" (U+005F)
  0xEE, 0xEE, 0xB1, 0x11, 0x11,
  // "`" (U+0060)
  0x63, 0x2C,
  // "a" (U+0061)
  0x2D, 0xEA, 0x00, 0x31, 0xE3, 0x3C, 0xEF, 0x48, 0xB4, 0xE4, 0x4E, 0xCC, 0x40,
  // "b" (U+0062)
  0x89, 0x00, 0x08, 0x80, 0x00, 0x8B, 0xDC, 0x08, 0xC1, 0xD5, 0x89, 0x0B, 0x68, 0xC1, 0xD5, 0x88,
  0xDB, 0x00,
  // "c" (U+0063)
  0x09, 0xED, 0x4E, 0x22, 0x6B, 0x00, 0x4E, 0x23, 0x0A, 0xED,
  // "d" (U+0064)
  0x00, 0x0C, 0x50, 0x00, 0xC5, 0x1D, 0xDD, 0x58, 0xB1, 0xD5, 0xA8, 0x0B, 0x58, 0xB1, 0xD5, 0x1D,
  0xCB, 0x50,
  // "e" (U+0065)
  0x0B, 0xE9, 0x06, 0xC1, 0xD3, 0x8F, 0xEF, 0x66, 0xC3, 0x31, 0x09, 0xEE, 0x30,
  // "f" (U+0066)
  0x00, 0xCF, 0x70, 0x4E, 0x10, 0x5E, 0xFF, 0x40, 0x5D, 0x00, 0x04, 0xD0, 0x00, 0x4D, 0x00, 0x04,
  0xD0, 0x00,
  // "g" (U+0067)
  0x2D, 0xCB, 0x58, 0xB1, 0xE5, 0xA8, 0x0B, 0x58, 0xB1, 0xD5, 0x2D, 0xDD, 0x51, 0x21, 0xE3, 0x4E,
  0xE9, 0x00,
  // "h" (U+0068)
  0x89, 0x00, 0x08, 0x90, 0x00, 0x8C, 0xDC, 0x18, 0xC2, 0xD5, 0x89, 0x0B, 0x68, 0x90, 0xB6, 0x89,
  0x0B, 0x60,
  // "i" (U+0069)
  0x01, 0xE1, 0x00, 0x00, 0x00, 0x4F, 0xF1, 0x00, 0x1F, 0x10, 0x01, 0xF1, 0x00, 0x1F, 0x10, 0x6F,
  0xFF, 0x50,
  // "j" (U+006A)
  0x00, 0xC5, 0x00, 0x00, 0x0E, 0xF6, 0x00, 0xB6, 0x00, 0xB6, 0x00, 0xB6, 0x00, 0xB6, 0x22, 0xD5,
  0x9F, 0xB0,
  // "k" (U+006B)
  0x89, 0x00, 0x08, 0x90, 0x00, 0x89, 0x2E, 0x38, 0xAC, 0x60, 0x8F, 0xF3, 0x08, 0xB6, 0xC0, 0x89,
  0x0C, 0x60,
  // "l" (U+006C)
  0x3F, 0xF1, 0x00, 0x2F, 0x10, 0x01, 0xF1, 0x00, 0x1F, 0x10, 0x01, 0xF1, 0x00, 0x1F, 0x10, 0x6F,
  0xFF, 0x50,
  // "m" (U+006D)
  0xBB, 0xAD, 0x5B, 0x7E, 0x88, 0xB5, 0xE6, 0x8B, 0x5E, 0x68, 0xB5, 0xE6, 0x80,
  // "n" (U+006E)
  0x8A, 0xEC, 0x18, 0xD1, 0xD5, 0x89, 0x0B, 0x68, 0x90, 0xB6, 0x89, 0x0B, 0x60,
  // "o" (U+006F)
  0x0B, 0xE9, 0x07, 0xB1, 0xD4, 0x98, 0x0B, 0x67, 0xB1, 0xD4, 0x0B, 0xF9, 0x00,
  // "p" (U+0070)
  0x8A, 0xEC, 0x08, 0xC1, 0xD5, 0x89, 0x0B, 0x78, 0xC1, 0xD5, 0x8C, 0xEB, 0x08, 0x80, 0x00, 0x89,
  0x00, 0x00,
  // "q" (U+0071)
  0x1D, 0xDB, 0x58, 0xB2, 0xE5, 0xA8, 0x0B, 0x58, 0xB1, 0xE5, 0x1D, 0xCD, 0x50, 0x00, 0xC5, 0x00,
  0x0C, 0x50,
  // "r" (U+0072)
  0x6F, 0xAD, 0x80, 0x8D, 0x20, 0x08, 0x90, 0x00, 0x8A, 0x00, 0x9F, 0xFA, 0x00,
  // "s" (U+0073)
  0x1B, 0xFC, 0x04, 0xF3, 0x30, 0x09, 0xF8, 0x02, 0x24, 0xF1, 0x4E, 0xFA, 0x00,
  // "t" (U+0074)
  0x06, 0x90, 0x07, 0xEF, 0xF3, 0x09, 0x91, 0x00, 0x99, 0x00, 0x08, 0xB1, 0x00, 0x3D, 0xF3,
  // "u" (U+0075)
  0x98, 0x0C, 0x59, 0x80, 0xC5, 0x98, 0x0C, 0x58, 0xB2, 0xE5, 0x3E, 0xCB, 0x50,
  // "v" (U+0076)
  0xA8, 0x0B, 0x75, 0xC0, 0xE2, 0x0F, 0x5C, 0x00, 0xBD, 0x70, 0x05, 0xF2, 0x00,
  // "w" (U+0077)
  0xE1, 0x04, 0xBC, 0x5F, 0x59, 0xA9, 0xE9, 0x78, 0xD9, 0xD5, 0x6F, 0x4F, 0x30,
  // "x" (U+0078)
  0x7D, 0x1E, 0x50, 0xDC, 0xB0, 0x07, 0xF4, 0x00, 0xDC, 0xB0, 0x8C, 0x1E, 0x50,
  // "y" (U+0079)
  0xA8, 0x0B, 0x74, 0xD0, 0xF2, 0x0E, 0x7C, 0x00, 0x9E, 0x70, 0x03, 0xF2, 0x01, 0x8C, 0x00, 0x8D,
  0x30, 0x00,
  // "z" (U+007A)
  0x5F, 0xFF, 0x30, 0x09, 0xB0, 0x04, 0xE1, 0x01, 0xE5, 0x00, 0x7F, 0xFF, 0x40,
  // "{" (U+007B)
  0x0A, 0xA0, 0xF2, 0x1F, 0x0D, 0x80, 0x4E, 0x00, 0xF0, 0x0F, 0x10, 0xBA,
  // "|" (U+007C)
  0x80, 0x5D,
  // "}" (U+007D)
  0xAA, 0x01, 0xF0, 0x0F, 0x00, 0xE4, 0x08, 0xD0, 0xF1, 0x1F, 0x0A, 0xA0,
  // "~" (U+007E)
  0x1D, 0x66, 0x26, 0x4B, 0xE0,
  // "¡" (U+00A1)
  0xD2, 0x00, 0xE1, 0xF2, 0xF3, 0xF3,
  // "¢" (U+00A2)
  0x00, 0xA3, 0x01, 0xDE, 0xE1, 0x5C, 0x00, 0x05, 0xC0, 0x00, 0x0D, 0xEE, 0x10, 0x0A, 0x20,
  // "£" (U+00A3)
  0x05, 0xED, 0x10, 0xB7, 0x10, 0x5F, 0xEA, 0x00, 0xC6, 0x10, 0x0D, 0x30, 0x05, 0xFF, 0xF4,
  // "¤" (U+00A4)
  0x00, 0x01, 0x04, 0xDE, 0xD1, 0x1C, 0x2D, 0x02, 0xB0, 0xD0, 0x4E, 0xFE, 0x11, 0x11, 0x20,
  // "¥" (U+00A5)
  0x89, 0x0C, 0x51, 0xE4, 0xD0, 0x09, 0xE6, 0x04, 0xEF, 0xE1, 0x4F, 0xFF, 0x10, 0x3E, 0x10,
  // "¦" (U+00A6)
  0xDD, 0xDD, 0x0D, 0xDD, 0xD0,
  // "§" (U+00A7)
  0x0A, 0xEA, 0x0F, 0x22, 0x0C, 0xD6, 0x1E, 0x2E, 0x06, 0xEA, 0x12, 0x4D, 0x1D, 0xE7,
  // "¨" (U+00A8)
  0xC1, 0xB0,
  // "©" (U+00A9)
  0x08, 0x96, 0x08, 0x79, 0x65, 0x9A, 0x00, 0x87, 0x79, 0x75, 0x08, 0x97, 0x00,
  // "ª" (U+00AA)
  0x5A, 0x66, 0x89, 0x78, 0x70,
  // "«" (U+00AB)
  0x08, 0x5B, 0x14, 0xD9, 0x90, 0x1D, 0x7C, 0x00, 0x33, 0x51,
  // "¬" (U+00AC)
  0x6E, 0xEE, 0x20, 0x11, 0xB2, 0x00, 0x06, 0x10,
  // "®" (U+00AE)
  0x08, 0x96, 0x08, 0x78, 0x75, 0x97, 0xB2, 0x87, 0x75, 0x85, 0x08, 0x96, 0x00,
  // "¯" (U+00AF)
  0xBE, 0x81, 0x11,
  // "°" (U+00B0)
  0x6D, 0x3B, 0x49, 0x8F, 0x50,
  // "±" (U+00B1)
  0x20, 0xD4, 0x0D, 0x28, 0x76, 0xEF, 0xE3, 0x01, 0xD1, 0x60, 0x6B, 0x03,
  // "²" (U+00B2)
  0x6B, 0x31, 0x66, 0x2B, 0x0A, 0xC8,
  // "³" (U+00B3)
  0x7C, 0x31, 0x56, 0x2D, 0x38, 0xB5,
  // "´" (U+00B4)
  0x04, 0x51, 0xC2,
  // "µ" (U+00B5)
  0x98, 0x0C, 0x59, 0x80, 0xC5, 0x98, 0x0C, 0x59, 0xB2, 0xE5, 0x9F, 0xCB, 0x59, 0x80, 0x00, 0x98,
  0x00, 0x00,
  // "¶" (U+00B6)
  0x2D, 0xFF, 0x69, 0xFF, 0x76, 0xAF, 0xF6, 0x67, 0xFF, 0x66, 0x07, 0xB6, 0x60, 0x06, 0x66, 0x00,
  0x66, 0x60, 0x06, 0x66,
  // "·" (U+00B7)
  0x2D,
  // "¸" (U+00B8)
  0x01, 0x00, 0xB1, 0x4B, 0x10,
  // "¹" (U+00B9)
  0x6D, 0x00, 0xB0, 0x4D, 0x50,
  // "º" (U+00BA)
  0x7B, 0x4C, 0x39, 0x5A, 0x30,
  // "»" (U+00BB)
  0x15, 0x33, 0x00, 0xC7, 0xD1, 0x09, 0x9D, 0x41, 0xB5, 0x80,
  // "¼" (U+00BC)
  0x98, 0x00, 0x12, 0x80, 0xB2, 0x7C, 0x86, 0x00, 0x2B, 0x61, 0x0B, 0x4C, 0x34, 0x56, 0xB6, 0x00,
  0x01, 0x00,
  // "½" (U+00BD)
  0x98, 0x00, 0x12, 0x80, 0xB1, 0x7C, 0xA4, 0x00, 0x68, 0xC5, 0x3A, 0x07, 0x30, 0x03, 0xF9, 0x00,
  0x01, 0x10,
  // "¾" (U+00BE)
  0x49, 0x00, 0x02, 0xB0, 0xB2, 0x9D, 0x86, 0x00, 0x2B, 0x72, 0x0B, 0x4C, 0x34, 0x56, 0xB6, 0x00,
  0x01, 0x00,
  // "¿" (U+00BF)
  0x00, 0xB5, 0x00, 0x03, 0x10, 0x01, 0xD3, 0x00, 0xD7, 0x00, 0x1F, 0x24, 0x00, 0x9E, 0xC2,
  // "À" (U+00C0)
  0x06, 0x30, 0x00, 0x2C, 0x00, 0x07, 0xF4, 0x00, 0xBA, 0x80, 0x0E, 0x2C, 0x04, 0xFE, 0xF1, 0x88,
  0x1B, 0x5C, 0x40, 0x89,
  // "Á" (U+00C1)
  0x00, 0x45, 0x00, 0x1C, 0x20, 0x07, 0xF4, 0x00, 0xBA, 0x80, 0x0E, 0x2C, 0x04, 0xFE, 0xF1, 0x88,
  0x1B, 0x5C, 0x40, 0x89,
  // "Â" (U+00C2)
  0x02, 0x71, 0x00, 0xB7, 0x90, 0x07, 0xF4, 0x00, 0xBA, 0x80, 0x0E, 0x2C, 0x04, 0xFE, 0xF1, 0x88,
  0x1B, 0x5C, 0x40, 0x89,
  // "Ã" (U+00C3)
  0x0B, 0xD9, 0x00, 0x7F, 0x40, 0x0B, 0xA8, 0x00, 0xE2, 0xC0, 0x4F, 0xEF, 0x18, 0x81, 0xB5, 0xC4,
  0x08, 0x90,
  // "Ä" (U+00C4)
  0x0C, 0x1B, 0x00, 0x00, 0x00, 0x07, 0xF4, 0x00, 0xBA, 0x80, 0x0E, 0x2C, 0x04, 0xFE, 0xF1, 0x88,
  0x1B, 0x5C, 0x40, 0x89,
  // "Å" (U+00C5)
  0x04, 0xD2, 0x00, 0x6F, 0x30, 0x07, 0xF4, 0x00, 0xBA, 0x80, 0x0E, 0x2C, 0x04, 0xFE, 0xF1, 0x88,
  0x1B, 0x5C, 0x40, 0x89,
  // "Æ" (U+00C6)
  0x0A, 0xFF, 0x80, 0xD9, 0x70, 0x2C, 0x8F, 0x65, 0xFF, 0x70, 0x97, 0x97, 0x0C, 0x38, 0xF8,
  // "Ç" (U+00C7)
  0x07, 0xEE, 0x44, 0xE3, 0x20, 0x8A, 0x00, 0x08, 0x90, 0x00, 0x5D, 0x21, 0x10, 0x9E, 0xF2, 0x00,
  0x0B, 0x10, 0x04, 0xB1,
  // "È" (U+00C8)
  0x06, 0x30, 0x00, 0x2C, 0x00, 0x5F, 0xFF, 0x35, 0xC0, 0x00, 0x5F, 0xEE, 0x15, 0xC1, 0x10, 0x5C,
  0x00, 0x05, 0xFF, 0xF3,
  // "É" (U+00C9)
  0x00, 0x45, 0x00, 0x1C, 0x20, 0x5F, 0xFF, 0x35, 0xC0, 0x00, 0x5F, 0xEE, 0x15, 0xC1, 0x10, 0x5C,
  0x00, 0x05, 0xFF, 0xF3,
  // "Ê" (U+00CA)
  0x02, 0x71, 0x00, 0xB7, 0x90, 0x5F, 0xFF, 0x35, 0xC0, 0x00, 0x5F, 0xEE, 0x15, 0xC1, 0x10, 0x5C,
  0x00, 0x05, 0xFF, 0xF3,
  // "Ë" (U+00CB)
  0x18, 0x1C, 0x1B, 0x60, 0x5B, 0x81, 0x35, 0xC3, 0x89, 0x25, 0xFE, 0xE1, 0x5C, 0x11, 0x05, 0xC3,
  0x05, 0xB0, 0x30,
  // "Ì" (U+00CC)
  0x06, 0x30, 0x00, 0x2C, 0x00, 0x4F, 0xFF, 0x10, 0x2E, 0x00, 0x02, 0xE0, 0x00, 0x2E, 0x00, 0x02,
  0xE0, 0x03, 0xEF, 0xD1,
  // "Í" (U+00CD)
  0x00, 0x45, 0x00, 0x1C, 0x20, 0x4F, 0xFF, 0x10, 0x2E, 0x00, 0x02, 0xE0, 0x00, 0x2E, 0x00, 0x02,
  0xE0, 0x03, 0xEF, 0xD1,
  // "Î" (U+00CE)
  0x02, 0x71, 0x00, 0xB7, 0x90, 0x4F, 0xFF, 0x10, 0x2E, 0x00, 0x02, 0xE0, 0x00, 0x2E, 0x00, 0x02,
  0xE0, 0x03, 0xEF, 0xD1,
  // "Ï" (U+00CF)
  0x0C, 0x1B, 0x00, 0x00, 0x00, 0x4F, 0xFF, 0x10, 0x2E, 0x00, 0x02, 0xE0, 0x00, 0x2E, 0x00, 0x02,
  0xE0, 0x03, 0xEF, 0xD1,
  // "Ð" (U+00D0)
  0x9F, 0xE8, 0x09, 0x82, 0xE4, 0xFF, 0x5A, 0x7A, 0x80, 0xA7, 0x98, 0x3E, 0x39, 0xFE, 0x70,
  // "Ñ" (U+00D1)
  0x0B, 0xD9, 0x09, 0xF1, 0x96, 0x9D, 0x69, 0x69, 0x9B, 0x96, 0x96, 0xD9, 0x69, 0x69, 0xD6, 0x96,
  0x4F, 0x60,
  // "Ò" (U+00D2)
  0x06, 0x30, 0x00, 0x2C, 0x00, 0x1B, 0xE9, 0x08, 0xB2, 0xD4, 0xB7, 0x0A, 0x7B, 0x70, 0xA7, 0x8B,
  0x1D, 0x41, 0xBE, 0x90,
  // "Ó" (U+00D3)
  0x00, 0x45, 0x00, 0x1C, 0x20, 0x1B, 0xE9, 0x08, 0xB2, 0xD4, 0xB7, 0x0A, 0x7B, 0x70, 0xA7, 0x8B,
  0x1D, 0x41, 0xBE, 0x90,
  // "Ô" (U+00D4)
  0x02, 0x71, 0x00, 0xB7, 0x90, 0x1B, 0xE9, 0x08, 0xB2, 0xD4, 0xB7, 0x0A, 0x7B, 0x70, 0xA7, 0x8B,
  0x1D, 0x41, 0xBE, 0x90,
  // "Õ" (U+00D5)
  0x0B, 0xD9, 0x01, 0xBE, 0x90, 0x8B, 0x2D, 0x4B, 0x70, 0xA7, 0xB7, 0x0A, 0x78, 0xB1, 0xD4, 0x1B,
  0xE9, 0x00,
  // "Ö" (U+00D6)
  0x0C, 0x1B, 0x00, 0x00, 0x00, 0x1B, 0xE9, 0x08, 0xB2, 0xD4, 0xB7, 0x0A, 0x7B, 0x70, 0xA7, 0x8B,
  0x1D, 0x41, 0xBE, 0x90,
  // "×" (U+00D7)
  0x04, 0x05, 0x1C, 0xBA, 0x08, 0xE5, 0x29, 0x1A,
  // "Ø" (U+00D8)
  0x1B, 0xEC, 0x78, 0xB3, 0xF5, 0xB7, 0xAC, 0x8B, 0xC8, 0xA7, 0x8E, 0x2D, 0x59, 0xCE, 0x90, 0x10,
  0x00, 0x00,
  // "Ù" (U+00D9)
  0x06, 0x30, 0x00, 0x2C, 0x00, 0x98, 0x0B, 0x69, 0x80, 0xB6, 0x98, 0x0B, 0x69, 0x80, 0xB6, 0x8B,
  0x2D, 0x51, 0xCE, 0xA0,
  // "Ú" (U+00DA)
  0x00, 0x45, 0x00, 0x1C, 0x20, 0x98, 0x0B, 0x69, 0x80, 0xB6, 0x98, 0x0B, 0x69, 0x80, 0xB6, 0x8B,
  0x2D, 0x51, 0xCE, 0xA0,
  // "Û" (U+00DB)
  0x02, 0x71, 0x00, 0xB7, 0x90, 0x98, 0x0B, 0x69, 0x80, 0xB6, 0x98, 0x0B, 0x69, 0x80, 0xB6, 0x8B,
  0x2D, 0x51, 0xCE, 0xA0,
  // "Ü" (U+00DC)
  0x0C, 0x1B, 0x00, 0x00, 0x00, 0x98, 0x0B, 0x69, 0x80, 0xB6, 0x98, 0x0B, 0x69, 0x80, 0xB6, 0x8B,
  0x2D, 0x51, 0xCE, 0xA0,
  // "Ý" (U+00DD)
  0x00, 0x45, 0x00, 0x1C, 0x20, 0x99, 0x0C, 0x62, 0xE3, 0xE0, 0x0B, 0xD8, 0x00, 0x4F, 0x10, 0x02,
  0xF0, 0x00, 0x2F, 0x00,
  // "Þ" (U+00DE)
  0x5B, 0x00, 0x05, 0xFE, 0xA0, 0x5C, 0x2D, 0x65, 0xB0, 0xC6, 0x5F, 0xFC, 0x15, 0xC1, 0x00,
  // "ß" (U+00DF)
  0x1C, 0xE9, 0x07, 0xB3, 0xF0, 0x88, 0x8A, 0x08, 0x8D, 0x50, 0x88, 0x5E, 0x38, 0x92, 0xA8, 0x89,
  0xEE, 0x30,
  // "à" (U+00E0)
  0x06, 0x30, 0x00, 0x2C, 0x00, 0x2D, 0xEA, 0x00, 0x31, 0xE3, 0x3C, 0xEF, 0x48, 0xB4, 0xE4, 0x4E,
  0xCC, 0x40,
  // "á" (U+00E1)
  0x00, 0x45, 0x00, 0x1C, 0x20, 0x2D, 0xEA, 0x00, 0x31, 0xE3, 0x3C, 0xEF, 0x48, 0xB4, 0xE4, 0x4E,
  0xCC, 0x40,
  // "â" (U+00E2)
  0x02, 0x71, 0x00, 0xB7, 0x90, 0x2D, 0xEA, 0x00, 0x31, 0xE3, 0x3C, 0xEF, 0x48, 0xB4, 0xE4, 0x4E,
  0xCC, 0x40,
  // "ã" (U+00E3)
  0x0B, 0xD9, 0x02, 0xDE, 0xA0, 0x03, 0x1E, 0x33, 0xCE, 0xF4, 0x8B, 0x4E, 0x44, 0xEC, 0xC4,
  // "ä" (U+00E4)
  0x0C, 0x1B, 0x00, 0x00, 0x00, 0x2D, 0xEA, 0x00, 0x31, 0xE3, 0x3C, 0xEF, 0x48, 0xB4, 0xE4, 0x4E,
  0xCC, 0x40,
  // "å" (U+00E5)
  0x04, 0xD2, 0x00, 0x6F, 0x30, 0x2D, 0xFA, 0x00, 0x31, 0xE3, 0x3C, 0xEF, 0x48, 0xB4, 0xE4, 0x4E,
  0xCC, 0x40,
  // "æ" (U+00E6)
  0x7E, 0xBE, 0x31, 0x3F, 0x69, 0x8E, 0xFE, 0xAD, 0x7F, 0x42, 0x9D, 0x7E, 0x60,
  // "ç" (U+00E7)
  0x09, 0xED, 0x04, 0xE2, 0x20, 0x6B, 0x00, 0x04, 0xE2, 0x30, 0x0A, 0xEF, 0x00, 0x00, 0xB1, 0x00,
  0x4B, 0x10,
  // "è" (U+00E8)
  0x06, 0x30, 0x00, 0x2C, 0x00, 0x0B, 0xE9, 0x06, 0xC1, 0xD3, 0x8F, 0xEF, 0x66, 0xC3, 0x31, 0x09,
  0xEE, 0x30,
  // "é" (U+00E9)
  0x00, 0x45, 0x00, 0x1C, 0x20, 0x0B, 0xE9, 0x06, 0xC1, 0xD3, 0x8F, 0xEF, 0x66, 0xC3, 0x31, 0x09,
  0xEE, 0x30,
  // "ê" (U+00EA)
  0x02, 0x71, 0x00, 0xB7, 0x90, 0x0B, 0xE9, 0x06, 0xC1, 0xD3, 0x8F, 0xEF, 0x66, 0xC3, 0x31, 0x09,
  0xEE, 0x30,
  // "ë" (U+00EB)
  0x18, 0x1C, 0x1B, 0x78, 0xA6, 0xBE, 0x90, 0x6C, 0x1D, 0x38, 0xFE, 0xF6, 0x6C, 0x33, 0x10, 0x9E,
  0xE3,
  // "ì" (U+00EC)
  0x06, 0x30, 0x00, 0x2C, 0x00, 0x4F, 0xF1, 0x00, 0x1F, 0x10, 0x01, 0xF1, 0x00, 0x1F, 0x10, 0x6F,
  0xFF, 0x50,
  // "í" (U+00ED)
  0x00, 0x45, 0x00, 0x1C, 0x20, 0x4F, 0xF1, 0x00, 0x1F, 0x10, 0x01, 0xF1, 0x00, 0x1F, 0x10, 0x6F,
  0xFF, 0x50,
  // "î" (U+00EE)
  0x02, 0x71, 0x00, 0xB7, 0x90, 0x4F, 0xF1, 0x00, 0x1F, 0x10, 0x01, 0xF1, 0x00, 0x1F, 0x10, 0x6F,
  0xFF, 0x50,
  // "ï" (U+00EF)
  0x0C, 0x1B, 0x00, 0x00, 0x00, 0x4F, 0xF1, 0x00, 0x1F, 0x10, 0x01, 0xF1, 0x00, 0x1F, 0x10, 0x6F,
  0xFF, 0x50,
  // "ð" (U+00F0)
  0x02, 0x13, 0x00, 0x6E, 0x90, 0x07, 0x7C, 0x01, 0xBD, 0xE3, 0x7B, 0x2E, 0x6A, 0x80, 0xB6, 0x8B,
  0x1D, 0x30, 0xBE, 0x80,
  // "ñ" (U+00F1)
  0x0B, 0xD9, 0x08, 0xAE, 0xC1, 0x8D, 0x1D, 0x58, 0x90, 0xB6, 0x89, 0x0B, 0x68, 0x90, 0xB6,
  // "ò" (U+00F2)
  0x06, 0x30, 0x00, 0x2C, 0x00, 0x0B, 0xE9, 0x07, 0xB1, 0xD4, 0x98, 0x0B, 0x67, 0xB1, 0xD4, 0x0B,
  0xF9, 0x00,
  // "ó" (U+00F3)
  0x00, 0x45, 0x00, 0x1C, 0x20, 0x0B, 0xE9, 0x07, 0xB1, 0xD4, 0x98, 0x0B, 0x67, 0xB1, 0xD4, 0x0B,
  0xF9, 0x00,
  // "ô" (U+00F4)
  0x02, 0x71, 0x00, 0xB7, 0x90, 0x0B, 0xE9, 0x07, 0xB1, 0xD4, 0x98, 0x0B, 0x67, 0xB1, 0xD4, 0x0B,
  0xF9, 0x00,
  // "õ" (U+00F5)
  0x0B, 0xD9, 0x00, 0xBE, 0x90, 0x7B, 0x1D, 0x49, 0x80, 0xB6, 0x7B, 0x1D, 0x40, 0xBF, 0x90,
  // "ö" (U+00F6)
  0x18, 0x1C, 0x1B, 0x78, 0xA5, 0xBE, 0x90, 0x7B, 0x1D, 0x49, 0x80, 0xB6, 0x7B, 0x1D, 0x40, 0xBF,
  0x91,
  // "÷" (U+00F7)
  0x00, 0xB0, 0x06, 0xEE, 0xE3, 0x01, 0x11, 0x00, 0x0B, 0x00,
  // "ø" (U+00F8)
  0x0B, 0xED, 0x17, 0xB7, 0xF4, 0xA9, 0xBB, 0x67, 0xF5, 0xD4, 0x3E, 0xE9, 0x00,
  // "ù" (U+00F9)
  0x06, 0x30, 0x00, 0x2C, 0x00, 0x98, 0x0C, 0x59, 0x80, 0xC5, 0x98, 0x0C, 0x58, 0xB2, 0xE5, 0x3E,
  0xCB, 0x50,
  // "ú" (U+00FA)
  0x00, 0x45, 0x00, 0x1C, 0x20, 0x98, 0x0C, 0x59, 0x80, 0xC5, 0x98, 0x0C, 0x58, 0xB2, 0xE5, 0x3E,
  0xCB, 0x50,
  // "û" (U+00FB)
  0x02, 0x71, 0x00, 0xB7, 0x90, 0x98, 0x0C, 0x59, 0x80, 0xC5, 0x98, 0x0C, 0x58, 0xB2, 0xE5, 0x3E,
  0xCB, 0x50,
  // "ü" (U+00FC)
  0x0C, 0x1B, 0x00, 0x00, 0x00, 0x98, 0x0C, 0x59, 0x80, 0xC5, 0x98, 0x0C, 0x58, 0xB2, 0xE5, 0x3E,
  0xCB, 0x50,
  // "ý" (U+00FD)
  0x00, 0x45, 0x00, 0x1C, 0x20, 0xA8, 0x0B, 0x74, 0xD0, 0xF2, 0x0E, 0x7C, 0x00, 0x9E, 0x70, 0x03,
  0xF2, 0x01, 0x8C, 0x00, 0x8D, 0x30, 0x00,
  // "þ" (U+00FE)
  0x89, 0x00, 0x08, 0x80, 0x00, 0x8B, 0xDC, 0x08, 0xC1, 0xD5, 0x89, 0x0B, 0x78, 0xC1, 0xD5, 0x8C,
  0xEB, 0x08, 0x80, 0x00, 0x89, 0x00, 0x00,
  // "ÿ" (U+00FF)
  0x0C, 0x1B, 0x00, 0x00, 0x00, 0xA8, 0x0B, 0x74, 0xD0, 0xF2, 0x0E, 0x7C, 0x00, 0x9E, 0x70, 0x03,
  0xF2, 0x01, 0x8C, 0x00, 0x8D, 0x30, 0x00,
  // "Ā" (U+0100)
  0x0B, 0xE8, 0x00, 0x11, 0x10, 0x07, 0xF4, 0x00, 0xBA, 0x80, 0x0E, 0x2C, 0x04, 0xFE, 0xF1, 0x88,
  0x1B, 0x5C, 0x40, 0x89,
  // "ā" (U+0101)
  0x0B, 0xE8, 0x00, 0x11, 0x10, 0x2D, 0xEA, 0x00, 0x31, 0xE3, 0x3C, 0xEF, 0x48, 0xB4, 0xE4, 0x4E,
  0xCC, 0x40,
  // "Ă" (U+0102)
  0x04, 0x04, 0x00, 0x9F, 0x70, 0x07, 0xF4, 0x00, 0xBA, 0x80, 0x0E, 0x2C, 0x04, 0xFE, 0xF1, 0x88,
  0x1B, 0x5C, 0x40, 0x89,
  // "ă" (U+0103)
  0x04, 0x04, 0x00, 0x9F, 0x70, 0x2D, 0xFA, 0x00, 0x31, 0xE3, 0x3C, 0xEF, 0x48, 0xB4, 0xE4, 0x4E,
  0xCC, 0x40,
  // "Ą" (U+0104)
  0x07, 0xF4, 0x00, 0x0B, 0xA8, 0x00, 0x0E, 0x2C, 0x00, 0x4F, 0xEF, 0x10, 0x88, 0x1B, 0x50, 0xC4,
  0x08, 0xC0, 0x00, 0x02, 0x90, 0x00, 0x02, 0xF3, 0x00, 0x00, 0x10,
  // "ą" (U+0105)
  0x2D, 0xEA, 0x00, 0x31, 0xE3, 0x3C, 0xEF, 0x48, 0xB4, 0xE4, 0x4E, 0xCF, 0x40, 0x02, 0x90, 0x00,
  0x2F, 0x30, 0x00, 0x10,
  // "Ć" (U+0106)
  0x00, 0x04, 0x50, 0x01, 0xC2, 0x07, 0xEE, 0x44, 0xE3, 0x20, 0x8A, 0x00, 0x08, 0x90, 0x00, 0x5D,
  0x21, 0x10, 0x9E, 0xE2,
  // "ć" (U+0107)
  0x00, 0x04, 0x50, 0x01, 0xC2, 0x09, 0xED, 0x04, 0xE2, 0x20, 0x6B, 0x00, 0x04, 0xE2, 0x30, 0x0A,
  0xED, 0x00,
  // "Ĉ" (U+0108)
  0x00, 0x27, 0x10, 0x0B, 0x79, 0x07, 0xEE, 0x44, 0xE3, 0x20, 0x8A, 0x00, 0x08, 0x90, 0x00, 0x5D,
  0x21, 0x10, 0x9E, 0xE2,
  // "ĉ" (U+0109)
  0x00, 0x27, 0x10, 0x0B, 0x79, 0x09, 0xED, 0x04, 0xE2, 0x20, 0x6B, 0x00, 0x04, 0xE2, 0x30, 0x0A,
  0xED, 0x00,
  // "Ċ" (U+010A)
  0x00, 0x2D, 0x00, 0x00, 0x00, 0x07, 0xEE, 0x44, 0xE3, 0x20, 0x8A, 0x00, 0x08, 0x90, 0x00, 0x5D,
  0x21, 0x10, 0x9E, 0xE2,
  // "ċ" (U+010B)
  0x00, 0x2D, 0x00, 0x00, 0x09, 0xED, 0x4E, 0x22, 0x6B, 0x00, 0x4E, 0x23, 0x0A, 0xED,
  // "Č" (U+010C)
  0x00, 0x61, 0x50, 0x07, 0xE4, 0x07, 0xEE, 0x44, 0xE3, 0x20, 0x8A, 0x00, 0x08, 0x90, 0x00, 0x5D,
  0x21, 0x10, 0x9E, 0xE2,
  // "č" (U+010D)
  0x00, 0x61, 0x50, 0x07, 0xE4, 0x09, 0xED, 0x04, 0xE2, 0x20, 0x6B, 0x00, 0x04, 0xE2, 0x30, 0x0A,
  0xED, 0x00,
  // "Ď" (U+010E)
  0x06, 0x15, 0x00, 0x7E, 0x40, 0x9F, 0xE8, 0x09, 0x82, 0xE4, 0x97, 0x0A, 0x79, 0x70, 0xA7, 0x98,
  0x3E, 0x39, 0xFE, 0x70,
  // "ď" (U+010F)
  0x00, 0x2E, 0xB2, 0x00, 0x2E, 0x00, 0x3E, 0xBE, 0x00, 0x99, 0x5E, 0x00, 0xB6, 0x1E, 0x00, 0x99,
  0x5E, 0x00, 0x3E, 0xAE, 0x00,
  // "Đ" (U+0110)
  0x9F, 0xE8, 0x09, 0x82, 0xE4, 0xFF, 0x5A, 0x7A, 0x80, 0xA7, 0x98, 0x3E, 0x39, 0xFE, 0x70,
  // "đ" (U+0111)
  0x00, 0x0C, 0x50, 0x0D, 0xFB, 0x2D, 0xDD, 0x58, 0xB1, 0xD5, 0xA8, 0x0B, 0x58, 0xB1, 0xD5, 0x1D,
  0xCB, 0x50,
  // "Ē" (U+0112)
  0x0B, 0xE8, 0x00, 0x11, 0x10, 0x5F, 0xFF, 0x35, 0xC0, 0x00, 0x5F, 0xEE, 0x15, 0xC1, 0x10, 0x5C,
  0x00, 0x05, 0xFF, 0xF3,
  // "ē" (U+0113)
  0x0B, 0xE8, 0x00, 0x11, 0x10, 0x0B, 0xE9, 0x06, 0xC1, 0xD3, 0x8F, 0xEF, 0x66, 0xC3, 0x31, 0x09,
  0xEE, 0x30,
  // "Ĕ" (U+0114)
  0x04, 0x04, 0x00, 0x9F, 0x70, 0x5F, 0xFF, 0x35, 0xC0, 0x00, 0x5F, 0xEE, 0x15, 0xC1, 0x10, 0x5C,
  0x00, 0x05, 0xFF, 0xF3,
  // "ĕ" (U+0115)
  0x04, 0x04, 0x00, 0x9F, 0x70, 0x0B, 0xF9, 0x06, 0xC1, 0xD3, 0x8F, 0xEF, 0x66, 0xC3, 0x31, 0x09,
  0xEE, 0x30,
  // "Ė" (U+0116)
  0x10, 0x20, 0xD7, 0x05, 0xB8, 0x13, 0x5C, 0x38, 0x92, 0x5F, 0xEE, 0x15, 0xC1, 0x10, 0x5C, 0x30,
  0x5B, 0x03,
  // "ė" (U+0117)
  0x10, 0x20, 0xD7, 0x18, 0xA6, 0xBE, 0x90, 0x6C, 0x1D, 0x38, 0xFE, 0xF6, 0x6C, 0x33, 0x10, 0x9E,
  0xE3,
  // "Ę" (U+0118)
  0x5F, 0xFF, 0x35, 0xC0, 0x00, 0x5F, 0xEE, 0x15, 0xC1, 0x10, 0x5C, 0x00, 0x05, 0xFF, 0xF3, 0x00,
  0x29, 0x00, 0x02, 0xF3, 0x00, 0x01, 0x00,
  // "ę" (U+0119)
  0x0B, 0xE9, 0x06, 0xC1, 0xD3, 0x8F, 0xEF, 0x66, 0xC3, 0x31, 0x09, 0xEF, 0x30, 0x02, 0x90, 0x00,
  0x2E, 0x20,
  // "Ě" (U+011A)
  0x06, 0x15, 0x00, 0x7E, 0x40, 0x5F, 0xFF, 0x35, 0xC0, 0x00, 0x5F, 0xEE, 0x15, 0xC1, 0x10, 0x5C,
  0x00, 0x05, 0xFF, 0xF3,
  // "ě" (U+011B)
  0x06, 0x15, 0x00, 0x7E, 0x40, 0x0B, 0xE9, 0x06, 0xC1, 0xD3, 0x8F, 0xEF, 0x66, 0xC3, 0x31, 0x09,
  0xEE, 0x30,
  // "Ĝ" (U+011C)
  0x00, 0x27, 0x10, 0x0B, 0x79, 0x09, 0xED, 0x26, 0xD2, 0x10, 0xA7, 0x5E, 0x6B, 0x70, 0xA6, 0x7C,
  0x1A, 0x60, 0xAE, 0xE5,
  // "ĝ" (U+011D)
  0x02, 0x71, 0x00, 0xB7, 0x90, 0x2D, 0xCB, 0x58, 0xB1, 0xE5, 0xA8, 0x0B, 0x58, 0xB1, 0xD5, 0x2D,
  0xDD, 0x51, 0x21, 0xE3, 0x4E, 0xE9, 0x00,
  // "Ğ" (U+011E)
  0x00, 0x40, 0x40, 0x09, 0xF7, 0x09, 0xEE, 0x26, 0xD2, 0x10, 0xA7, 0x5E, 0x6B, 0x70, 0xA6, 0x7C,
  0x1A, 0x60, 0xAE, 0xE5,
  // "ğ" (U+011F)
  0x04, 0x04, 0x00, 0x9F, 0x70, 0x2D, 0xDB, 0x58, 0xB1, 0xE5, 0xA8, 0x0B, 0x58, 0xB1, 0xD5, 0x2D,
  0xDD, 0x51, 0x21, 0xE3, 0x4E, 0xE9, 0x00,
  // "Ġ" (U+0120)
  0x20, 0x20, 0xD7, 0x8B, 0x39, 0xED, 0x26, 0xD2, 0x10, 0xA7, 0x5E, 0x6B, 0x70, 0xA6, 0x7C, 0x1A,
  0x60, 0xAE, 0xE5,
  // "ġ" (U+0121)
  0x10, 0x20, 0xD7, 0x8C, 0x02, 0xDC, 0xB5, 0x8B, 0x1E, 0x5A, 0x80, 0xB5, 0x8B, 0x1D, 0x52, 0xDD,
  0xD5, 0x12, 0x1E, 0x34, 0xEE, 0x91,
  // "Ģ" (U+0122)
  0x18, 0xB3, 0x9E, 0xD2, 0x6D, 0x21, 0x0A, 0x75, 0xE6, 0xB7, 0x0A, 0x67, 0xC1, 0xA6, 0x0A, 0xEE,
  0x57, 0x09, 0x03, 0x30, 0x12,
  // "ģ" (U+0123)
  0x20, 0xC7, 0x8C, 0x02, 0xDC, 0xB5, 0x8B, 0x1E, 0x5A, 0x80, 0xB5, 0x8B, 0x1D, 0x52, 0xDD, 0xD5,
  0x12, 0x1E, 0x34, 0xEE, 0x91,
  // "Ĥ" (U+0124)
  0x02, 0x71, 0x00, 0xB7, 0x90, 0x98, 0x0B, 0x69, 0x80, 0xB6, 0x9F, 0xEF, 0x69, 0x81, 0xB6, 0x98,
  0x0B, 0x69, 0x80, 0xB6,
  // "ĥ" (U+0125)
  0x27, 0x10, 0x0B, 0x79, 0x00, 0x89, 0x00, 0x08, 0x90, 0x00, 0x8C, 0xDC, 0x18, 0xC2, 0xD5, 0x89,
  0x0B, 0x68, 0x90, 0xB6, 0x89, 0x0B, 0x60,
  // "Ħ" (U+0126)
  0xFF, 0xEF, 0xB9, 0xA1, 0xC6, 0x8F, 0xEF, 0x58, 0xA1, 0xC5, 0x89, 0x0C, 0x58, 0x90, 0xC5,
  // "ħ" (U+0127)
  0x89, 0x00, 0x0F, 0xFB, 0x00, 0x8C, 0xDC, 0x18, 0xC2, 0xD5, 0x89, 0x0B, 0x68, 0x90, 0xB6, 0x89,
  0x0B, 0x60,
  // "Ĩ" (U+0128)
  0x0B, 0xD9, 0x04, 0xFF, 0xF1, 0x02, 0xE0, 0x00, 0x2E, 0x00, 0x02, 0xE0, 0x00, 0x2E, 0x00, 0x3E,
  0xFD, 0x10,
  // "ĩ" (U+0129)
  0x0B, 0xD9, 0x04, 0xFF, 0x10, 0x01, 0xF1, 0x00, 0x1F, 0x10, 0x01, 0xF1, 0x06, 0xFF, 0xF5,
  // "Ī" (U+012A)
  0x0B, 0xE8, 0x00, 0x11, 0x10, 0x4F, 0xFF, 0x10, 0x2E, 0x00, 0x02, 0xE0, 0x00, 0x2E, 0x00, 0x02,
  0xE0, 0x03, 0xEF, 0xD1,
  // "ī" (U+012B)
  0x0B, 0xE8, 0x00, 0x11, 0x10, 0x4F, 0xF1, 0x00, 0x1F, 0x10, 0x01, 0xF1, 0x00, 0x1F, 0x10, 0x6F,
  0xFF, 0x50,
  // "Ĭ" (U+012C)
  0x04, 0x04, 0x00, 0x9F, 0x70, 0x4F, 0xFF, 0x10, 0x2E, 0x00, 0x02, 0xE0, 0x00, 0x2E, 0x00, 0x02,
  0xE0, 0x03, 0xEF, 0xD1,
  // "ĭ" (U+012D)
  0x04, 0x04, 0x00, 0x9F, 0x70, 0x4F, 0xF1, 0x00, 0x1F, 0x10, 0x01, 0xF1, 0x00, 0x1F, 0x10, 0x6F,
  0xFF, 0x50,
  // "Į" (U+012E)
  0x4F, 0xFF, 0x10, 0x2E, 0x00, 0x02, 0xE0, 0x00, 0x2E, 0x00, 0x02, 0xE0, 0x03, 0xEF, 0xD1, 0x02,
  0x90, 0x00, 0x2F, 0x30, 0x00, 0x10, 0x00,
  // "į" (U+012F)
  0x01, 0xE1, 0x00, 0x00, 0x00, 0x4F, 0xF1, 0x00, 0x1F, 0x10, 0x01, 0xF1, 0x00, 0x1F, 0x10, 0x6F,
  0xFF, 0x50, 0x02, 0x90, 0x00, 0x2F, 0x30, 0x00, 0x10,
  // "İ" (U+0130)
  0x10, 0x20, 0xD7, 0x04, 0xB8, 0x21, 0x02, 0xE3, 0x02, 0x0E, 0x30, 0x20, 0xE3, 0x02, 0x0E, 0x28,
  0x33, 0xEF, 0xD1,
  // "ı" (U+0131)
  0x4F, 0xF1, 0x00, 0x1F, 0x10, 0x01, 0xF1, 0x00, 0x1F, 0x10, 0x6F, 0xFF, 0x50,
  // "Ĳ" (U+0132)
  0x4C, 0x0F, 0x14, 0xC0, 0xF1, 0x4C, 0x0F, 0x14, 0xC0, 0xF1, 0x12, 0x4F, 0x04, 0xFE, 0x70,
  // "ĳ" (U+0133)
  0x4D, 0x1E, 0x10, 0x00, 0x00, 0x4D, 0x1F, 0x14, 0xD1, 0xF1, 0x4D, 0x1F, 0x14, 0xD1, 0xF1, 0x4D,
  0x1F, 0x10, 0x25, 0xF0, 0x0E, 0xE7, 0x00,
  // "Ĵ" (U+0134)
  0x00, 0x27, 0x10, 0x0B, 0x79, 0x00, 0x3E, 0x00, 0x03, 0xE0, 0x00, 0x3E, 0x00, 0x03, 0xE0, 0x11,
  0x7C, 0x04, 0xFE, 0x50,
  // "ĵ" (U+0135)
  0x00, 0x27, 0x10, 0x0B, 0x79, 0x0E, 0xF6, 0x00, 0x0B, 0x60, 0x00, 0xB6, 0x00, 0x0B, 0x60, 0x00,
  0xB6, 0x02, 0x2D, 0x50, 0x9F, 0xB0, 0x00,
  // "Ķ" (U+0136)
  0x89, 0x39, 0x71, 0xE3, 0x97, 0xA8, 0x09, 0xBD, 0x28, 0x95, 0x9E, 0xE2, 0x09, 0x78, 0xA0, 0x97,
  0x1E, 0x36, 0x09, 0x03, 0x30, 0x13,
  // "ķ" (U+0137)
  0x89, 0x00, 0x08, 0x90, 0x00, 0x89, 0x2E, 0x38, 0xAC, 0x60, 0x8F, 0xF3, 0x08, 0xB6, 0xC0, 0x89,
  0x0C, 0x60, 0x00, 0x00, 0x00, 0x93, 0x00, 0x01, 0x00,
  // "ĸ" (U+0138)
  0x89, 0x2E, 0x38, 0xAC, 0x60, 0x8F, 0xF3, 0x08, 0xB6, 0xC0, 0x89, 0x0C, 0x60,
  // "Ĺ" (U+0139)
  0x04, 0x50, 0x01, 0xC2, 0x00, 0x4D, 0x00, 0x04, 0xD0, 0x00, 0x4D, 0x00, 0x04, 0xD0, 0x00, 0x4D,
  0x22, 0x04, 0xFF, 0xF3,
  // "ĺ" (U+013A)
  0x00, 0x45, 0x00, 0x1C, 0x20, 0x3F, 0xF1, 0x00, 0x2F, 0x10, 0x01, 0xF1, 0x00, 0x1F, 0x10, 0x01,
  0xF1, 0x00, 0x1F, 0x10, 0x6F, 0xFF, 0x50,
  // "Ļ" (U+013B)
  0x04, 0x0D, 0x30, 0x40, 0xD3, 0x04, 0x0D, 0x30, 0x40, 0xD3, 0x84, 0x4D, 0x22, 0x04, 0xB0, 0x37,
  0x09, 0x03, 0x30, 0x12,
  // "ļ" (U+013C)
  0x3F, 0xF1, 0x00, 0x2F, 0x10, 0x01, 0xF1, 0x00, 0x1F, 0x10, 0x01, 0xF1, 0x00, 0x1F, 0x10, 0x6F,
  0xFF, 0x50, 0x00, 0x00, 0x00, 0x93, 0x00, 0x01, 0x00,
  // "Ľ" (U+013D)
  0x4D, 0x0D, 0x04, 0xD0, 0x00, 0x4D, 0x00, 0x04, 0xD0, 0x00, 0x4D, 0x22, 0x04, 0xFF, 0xF3,
  // "ľ" (U+013E)
  0x2B, 0xF7, 0x70, 0x1F, 0x10, 0x01, 0xF1, 0x00, 0x1F, 0x10, 0x01, 0xF1, 0x00, 0x2F, 0x20, 0x7F,
  0xFF, 0x50,
  // "Ŀ" (U+013F)
  0x4D, 0x00, 0x04, 0xD0, 0x00, 0x4D, 0x00, 0x04, 0xD2, 0xD0, 0x4D, 0x22, 0x04, 0xFF, 0xF3,
  // "ŀ" (U+0140)
  0x3F, 0xF1, 0x00, 0x2F, 0x10, 0x01, 0xF1, 0x00, 0x1F, 0x10, 0x01, 0xF4, 0xD0, 0x1F, 0x10, 0x6F,
  0xFF, 0x50,
  // "Ł" (U+0141)
  0x0E, 0x30, 0x00, 0xE4, 0x00, 0x0E, 0xD1, 0x07, 0xF3, 0x00, 0x0E, 0x52, 0x10, 0xEF, 0xF8,
  // "ł" (U+0142)
  0x3F, 0xF1, 0x00, 0x2F, 0x10, 0x01, 0xF6, 0x00, 0x3F, 0x90, 0x0C, 0xF1, 0x00, 0x1F, 0x10, 0x6F,
  0xFF, 0x50,
  // "Ń" (U+0143)
  0x00, 0x45, 0x00, 0x1C, 0x20, 0x9F, 0x19, 0x69, 0xD6, 0x96, 0x99, 0xB9, 0x69, 0x6D, 0x96, 0x96,
  0x9D, 0x69, 0x64, 0xF6,
  // "ń" (U+0144)
  0x00, 0x45, 0x00, 0x1C, 0x20, 0x8A, 0xEC, 0x18, 0xD1, 0xD5, 0x89, 0x0B, 0x68, 0x90, 0xB6, 0x89,
  0x0B, 0x60,
  // "Ņ" (U+0145)
  0x8B, 0x49, 0xF1, 0x96, 0x9D, 0x69, 0x69, 0x9B, 0x96, 0x96, 0xD9, 0x69, 0x69, 0xD6, 0x96, 0x4F,
  0x66, 0x09, 0x03, 0x30, 0x13,
  // "ņ" (U+0146)
  0x8A, 0x78, 0xAE, 0xC1, 0x8D, 0x1D, 0x58, 0x90, 0xB6, 0x89, 0x0B, 0x68, 0x90, 0xB6, 0x60, 0x90,
  0x33, 0x01, 0x30,
  // "Ň" (U+0147)
  0x06, 0x15, 0x00, 0x7E, 0x40, 0x9F, 0x19, 0x69, 0xD6, 0x96, 0x99, 0xB9, 0x69, 0x6D, 0x96, 0x96,
  0x9D, 0x69, 0x64, 0xF6,
  // "ň" (U+0148)
  0x06, 0x15, 0x00, 0x7E, 0x40, 0x8A, 0xEC, 0x18, 0xD1, 0xD5, 0x89, 0x0B, 0x68, 0x90, 0xB6, 0x89,
  0x0B, 0x60,
  // "ŉ" (U+0149)
  0x97, 0x00, 0x00, 0xCA, 0x9D, 0xD1, 0x27, 0xD2, 0xD5, 0x07, 0xA0, 0xB6, 0x07, 0xA0, 0xB6, 0x07,
  0xA0, 0xB6,
  // "Ŋ" (U+014A)
  0x9F, 0x19, 0x69, 0xD6, 0x96, 0x99, 0xB9, 0x69, 0x6D, 0x96, 0x96, 0x9D, 0x69, 0x64, 0xF6, 0x00,
  0x0A, 0x60, 0x1F, 0xD1, 0x00, 0x10, 0x00,
  // "ŋ" (U+014B)
  0x8A, 0xEC, 0x18, 0xD2, 0xD5, 0x89, 0x0B, 0x68, 0x90, 0xB6, 0x89, 0x0B, 0x60, 0x00, 0xD5, 0x00,
  0xAD, 0x10,
  // "Ō" (U+014C)
  0x0B, 0xE8, 0x00, 0x11, 0x10, 0x1B, 0xE9, 0x08, 0xB2, 0xD4, 0xB7, 0x0A, 0x7B, 0x70, 0xA7, 0x8B,
  0x1D, 0x41, 0xBE, 0x90,
  // "ō" (U+014D)
  0x0B, 0xE8, 0x00, 0x11, 0x10, 0x0B, 0xE9, 0x07, 0xB1, 0xD4, 0x98, 0x0B, 0x67, 0xB1, 0xD4, 0x0B,
  0xF9, 0x00,
  // "Ŏ" (U+014E)
  0x04, 0x04, 0x00, 0x9F, 0x70, 0x1B, 0xF9, 0x08, 0xB2, 0xD4, 0xB7, 0x0A, 0x7B, 0x70, 0xA7, 0x8B,
  0x1D, 0x41, 0xBE, 0x90,
  // "ŏ" (U+014F)
  0x04, 0x04, 0x00, 0x9F, 0x70, 0x0B, 0xF9, 0x07, 0xB1, 0xD4, 0x98, 0x0B, 0x67, 0xB1, 0xD4, 0x0B,
  0xF9, 0x00,
  // "Ő" (U+0150)
  0x09, 0x89, 0x00, 0x01, 0x00, 0x1B, 0xE9, 0x08, 0xB2, 0xD4, 0xB7, 0x0A, 0x7B, 0x70, 0xA7, 0x8B,
  0x1D, 0x41, 0xBE, 0x90,
  // "ő" (U+0151)
  0x09, 0x89, 0x00, 0x01, 0x00, 0x0B, 0xE9, 0x07, 0xB1, 0xD4, 0x98, 0x0B, 0x67, 0xB1, 0xD4, 0x0B,
  0xF9, 0x00,
  // "Œ" (U+0152)
  0x2D, 0xFF, 0x99, 0xA8, 0x80, 0xB6, 0x8F, 0x7B, 0x68, 0x90, 0x99, 0x88, 0x02, 0xDF, 0xF9,
  // "œ" (U+0153)
  0x5E, 0x8E, 0x4B, 0x5F, 0x59, 0xC1, 0xFE, 0xBB, 0x5F, 0x42, 0x4E, 0x8E, 0x70,
  // "Ŕ" (U+0154)
  0x00, 0x45, 0x00, 0x1C, 0x20, 0x5F, 0xEA, 0x05, 0xC2, 0xF3, 0x5F, 0xFA, 0x05, 0xC9, 0x90, 0x5C,
  0x2E, 0x15, 0xC0, 0xB7,
  // "ŕ" (U+0155)
  0x00, 0x04, 0x50, 0x01, 0xC2, 0x6F, 0xAD, 0x80, 0x8D, 0x20, 0x08, 0x90, 0x00, 0x8A, 0x00, 0x9F,
  0xFA, 0x00,
  // "Ŗ" (U+0156)
  0x89, 0x15, 0xFE, 0xA0, 0x5C, 0x2F, 0x35, 0xA8, 0x97, 0xA0, 0x5C, 0x99, 0x05, 0xC2, 0xE1, 0x5C,
  0x0B, 0x77, 0x09, 0x03, 0x30, 0x12,
  // "ŗ" (U+0157)
  0x87, 0x6F, 0xAD, 0x80, 0x8D, 0x22, 0x08, 0x09, 0x30, 0x80, 0xA2, 0x09, 0xA0, 0xA7, 0x09, 0x03,
  0x30, 0x13,
  // "Ř" (U+0158)
  0x06, 0x15, 0x00, 0x7E, 0x40, 0x5F, 0xEA, 0x05, 0xC2, 0xF3, 0x5F, 0xFA, 0x05, 0xC9, 0x90, 0x5C,
  0x2E, 0x15, 0xC0, 0xB7,
  // "ř" (U+0159)
  0x00, 0x61, 0x50, 0x07, 0xE4, 0x6F, 0xAD, 0x80, 0x8D, 0x20, 0x08, 0x90, 0x00, 0x8A, 0x00, 0x9F,
  0xFA, 0x00,
  // "Ś" (U+015A)
  0x00, 0x04, 0x50, 0x01, 0xC2, 0x0B, 0xFD, 0x14, 0xE1, 0x30, 0x1D, 0x91, 0x00, 0x18, 0xE1, 0x22,
  0x1E, 0x44, 0xEE, 0xA0,
  // "ś" (U+015B)
  0x00, 0x45, 0x00, 0x1C, 0x20, 0x1B, 0xFC, 0x04, 0xF3, 0x30, 0x09, 0xF8, 0x02, 0x24, 0xF1, 0x4E,
  0xFA, 0x00,
  // "Ŝ" (U+015C)
  0x00, 0x27, 0x10, 0x0B, 0x79, 0x0B, 0xFD, 0x14, 0xE1, 0x30, 0x1D, 0x91, 0x00, 0x18, 0xE1, 0x22,
  0x1E, 0x44, 0xEE, 0xA0,
  // "ŝ" (U+015D)
  0x02, 0x71, 0x00, 0xB7, 0x90, 0x1B, 0xFC, 0x04, 0xF3, 0x30, 0x09, 0xF8, 0x02, 0x24, 0xF1, 0x4E,
  0xFA, 0x00,
  // "Ş" (U+015E)
  0x0B, 0xFD, 0x14, 0xE1, 0x30, 0x1D, 0x91, 0x00, 0x18, 0xE1, 0x22, 0x1E, 0x44, 0xEF, 0xA0, 0x00,
  0xB1, 0x00, 0x4B, 0x10,
  // "ş" (U+015F)
  0x1B, 0xFC, 0x04, 0xF3, 0x30, 0x09, 0xF8, 0x02, 0x24, 0xF1, 0x4E, 0xFA, 0x00, 0x0B, 0x10, 0x04,
  0xB1, 0x00,
  // "Š" (U+0160)
  0x00, 0x61, 0x50, 0x07, 0xE4, 0x0B, 0xFD, 0x14, 0xE1, 0x30, 0x1D, 0x91, 0x00, 0x18, 0xE1, 0x22,
  0x1E, 0x44, 0xEE, 0xA0,
  // "š" (U+0161)
  0x06, 0x15, 0x00, 0x7E, 0x40, 0x1B, 0xFC, 0x04, 0xF3, 0x30, 0x09, 0xF8, 0x02, 0x24, 0xF1, 0x4E,
  0xFA, 0x00,
  // "Ţ" (U+0162)
  0x0B, 0xB8, 0x18, 0x03, 0x93, 0x02, 0x93, 0x02, 0x93, 0x02, 0x93, 0x02, 0x94, 0x0B, 0x01, 0x28,
  0x14, 0xB1, 0x10,
  // "ţ" (U+0163)
  0x06, 0x90, 0x07, 0xEF, 0xF3, 0x09, 0x91, 0x00, 0x99, 0x00, 0x08, 0xB1, 0x00, 0x3D, 0xF3, 0x00,
  0x0B, 0x10, 0x04, 0xB1,
  // "Ť" (U+0164)
  0x18, 0x16, 0x15, 0x28, 0x37, 0xE4, 0x0B, 0xB8, 0x18, 0x03, 0x93, 0x02, 0x93, 0x02, 0x93, 0x02,
  0x93, 0x02, 0x92,
  // "ť" (U+0165)
  0x02, 0x39, 0x40, 0x69, 0x00, 0x7F, 0xFF, 0x30, 0x99, 0x10, 0x09, 0x90, 0x00, 0x8B, 0x10, 0x03,
  0xDF, 0x30,
  // "Ŧ" (U+0166)
  0xBF, 0xFF, 0x80, 0x3F, 0x00, 0x2E, 0xFE, 0x00, 0x4F, 0x10, 0x02, 0xF0, 0x00, 0x2F, 0x00,
  // "ŧ" (U+0167)
  0x06, 0x90, 0x07, 0xEF, 0xF3, 0x09, 0x91, 0x08, 0xFF, 0xE3, 0x19, 0xB2, 0x10, 0x3E, 0xF3,
  // "Ũ" (U+0168)
  0x0B, 0xD9, 0x09, 0x80, 0xB6, 0x98, 0x0B, 0x69, 0x80, 0xB6, 0x98, 0x0B, 0x68, 0xB2, 0xD5, 0x1C,
  0xEA, 0x00,
  // "ũ" (U+0169)
  0x0B, 0xD9, 0x09, 0x80, 0xC5, 0x98, 0x0C, 0x59, 0x80, 0xC5, 0x8B, 0x2E, 0x53, 0xEC, 0xB5,
  // "Ū" (U+016A)
  0x0B, 0xE8, 0x00, 0x11, 0x10, 0x98, 0x0B, 0x69, 0x80, 0xB6, 0x98, 0x0B, 0x69, 0x80, 0xB6, 0x8B,
  0x2D, 0x51, 0xCE, 0xA0,
  // "ū" (U+016B)
  0x0B, 0xE8, 0x00, 0x11, 0x10, 0x98, 0x0C, 0x59, 0x80, 0xC5, 0x98, 0x0C, 0x58, 0xB2, 0xE5, 0x3E,
  0xCB, 0x50,
  // "Ŭ" (U+016C)
  0x04, 0x04, 0x00, 0x9F, 0x70, 0x98, 0x0B, 0x69, 0x80, 0xB6, 0x98, 0x0B, 0x69, 0x80, 0xB6, 0x8B,
  0x2D, 0x51, 0xCE, 0xA0,
  // "ŭ" (U+016D)
  0x04, 0x04, 0x00, 0x9F, 0x70, 0x98, 0x0C, 0x59, 0x80, 0xC5, 0x98, 0x0C, 0x58, 0xB2, 0xE5, 0x3E,
  0xCB, 0x50,
  // "Ů" (U+016E)
  0x04, 0xD2, 0x00, 0x6F, 0x30, 0x98, 0x0B, 0x69, 0x80, 0xB6, 0x98, 0x0B, 0x69, 0x80, 0xB6, 0x8B,
  0x2D, 0x51, 0xCE, 0xA0,
  // "ů" (U+016F)
  0x04, 0xD2, 0x00, 0x6F, 0x30, 0x98, 0x0C, 0x59, 0x80, 0xC5, 0x98, 0x0C, 0x58, 0xB2, 0xE5, 0x3E,
  0xCB, 0x50,
  // "Ű" (U+0170)
  0x09, 0x89, 0x00, 0x01, 0x00, 0x98, 0x0B, 0x69, 0x80, 0xB6, 0x98, 0x0B, 0x69, 0x80, 0xB6, 0x8B,
  0x2D, 0x51, 0xCE, 0xA0,
  // "ű" (U+0171)
  0x09, 0x89, 0x00, 0x01, 0x00, 0x98, 0x0C, 0x59, 0x80, 0xC5, 0x98, 0x0C, 0x58, 0xB2, 0xE5, 0x3E,
  0xCB, 0x50,
  // "Ų" (U+0172)
  0x98, 0x0B, 0x69, 0x80, 0xB6, 0x98, 0x0B, 0x69, 0x80, 0xB6, 0x8B, 0x2D, 0x42, 0xCF, 0x80, 0x01,
  0x90, 0x00, 0x2E, 0x30,
  // "ų" (U+0173)
  0x98, 0x0C, 0x59, 0x80, 0xC5, 0x98, 0x0C, 0x58, 0xB2, 0xE5, 0x3E, 0xCE, 0x50, 0x02, 0x90, 0x00,
  0x2F, 0x30, 0x00, 0x10,
  // "Ŵ" (U+0174)
  0x02, 0x71, 0x00, 0xB7, 0x90, 0xD2, 0x05, 0xAC, 0x6F, 0x69, 0xB9, 0xE9, 0x8A, 0xCA, 0xC7, 0x9E,
  0x6E, 0x68, 0xF3, 0xF5,
  // "ŵ" (U+0175)
  0x02, 0x71, 0x00, 0xB7, 0x90, 0xE1, 0x04, 0xBC, 0x5F, 0x59, 0xA9, 0xE9, 0x78, 0xD9, 0xD5, 0x6F,
  0x4F, 0x30,
  // "Ŷ" (U+0176)
  0x02, 0x71, 0x00, 0xB7, 0x90, 0x99, 0x0C, 0x62, 0xE3, 0xE0, 0x0B, 0xD8, 0x00, 0x4F, 0x10, 0x02,
  0xF0, 0x00, 0x2F, 0x00,
  // "ŷ" (U+0177)
  0x02, 0x71, 0x00, 0xB7, 0x90, 0xA8, 0x0B, 0x74, 0xD0, 0xF2, 0x0E, 0x7C, 0x00, 0x9E, 0x70, 0x03,
  0xF2, 0x01, 0x8C, 0x00, 0x8D, 0x30, 0x00,
  // "Ÿ" (U+0178)
  0x0C, 0x1B, 0x00, 0x00, 0x00, 0x99, 0x0C, 0x62, 0xE3, 0xE0, 0x0B, 0xD8, 0x00, 0x4F, 0x10, 0x02,
  0xF0, 0x00, 0x2F, 0x00,
  // "Ź" (U+0179)
  0x00, 0x04, 0x50, 0x01, 0xC2, 0x2F, 0xFF, 0x30, 0x05, 0xD0, 0x00, 0xD4, 0x00, 0x6B, 0x00, 0x1E,
  0x30, 0x05, 0xFF, 0xF3,
  // "ź" (U+017A)
  0x00, 0x45, 0x00, 0x1C, 0x20, 0x5F, 0xFF, 0x30, 0x09, 0xB0, 0x04, 0xE1, 0x01, 0xE5, 0x00, 0x7F,
  0xFF, 0x40,
  // "Ż" (U+017B)
  0x20, 0x20, 0xD6, 0x02, 0xB0, 0x32, 0x05, 0x0D, 0x30, 0xD0, 0x42, 0x06, 0x0B, 0x28, 0x11, 0xE3,
  0x20, 0x5B, 0x03,
  // "ż" (U+017C)
  0x10, 0x20, 0xD7, 0x05, 0xB0, 0x32, 0x09, 0x0B, 0x28, 0x54, 0xE1, 0x01, 0xE5, 0x20, 0x7B, 0x04,
  // "Ž" (U+017D)
  0x00, 0x61, 0x50, 0x07, 0xE4, 0x2F, 0xFF, 0x30, 0x05, 0xD0, 0x00, 0xD4, 0x00, 0x6B, 0x00, 0x1E,
  0x30, 0x05, 0xFF, 0xF3,
  // "ž" (U+017E)
  0x06, 0x15, 0x00, 0x7E, 0x40, 0x5F, 0xFF, 0x30, 0x09, 0xB0, 0x04, 0xE1, 0x01, 0xE5, 0x00, 0x7F,
  0xFF, 0x40,
  // "ſ" (U+017F)
  0x1D, 0xE6, 0xC1, 0x6B, 0x06, 0xB0, 0x6B, 0x06, 0xB0, 0x6B, 0x00,
  // "Ω" (U+03A9)
  0x1B, 0xE9, 0x08, 0xA1, 0xD4, 0xA6, 0x09, 0x68, 0x70, 0xA4, 0x3C, 0x1C, 0x1D, 0xF6, 0xFA,
  // "μ" (U+03BC)
  0x98, 0x0C, 0x59, 0x80, 0xC5, 0x98, 0x0C, 0x59, 0xB2, 0xE5, 0x9F, 0xCB, 0x59, 0x80, 0x00, 0x98,
  0x00, 0x00,
  // "π" (U+03C0)
  0xCF, 0xFF, 0xB2, 0xE4, 0xD0, 0x2E, 0x3D, 0x02, 0xE3, 0xD1, 0x2E, 0x1D, 0xA0,
  // "–" (U+2013)
  0x2E, 0xEE, 0x01, 0x11,
  // "—" (U+2014)
  0xEE, 0xEE, 0xB1, 0x11, 0x11,
  // "€" (U+20AC)
  0x04, 0xDE, 0x50, 0xE5, 0x11, 0x9F, 0xE8, 0x0A, 0xFF, 0x90, 0x1E, 0x72, 0x10, 0x4D, 0xF4,
  // "₿" (U+20BF)
  0x07, 0x51, 0x05, 0xFF, 0xC1, 0x5B, 0x1E, 0x45, 0xFE, 0xC0, 0x5B, 0x2D, 0x55, 0xB1, 0xD6, 0x5F,
  0xFC, 0x10, 0x75, 0x10,
  // "‘" (U+2018)
  0x0D, 0x3D, 0x01,
  // "’" (U+2019)
  0x0F, 0x13, 0xC0, 0x01, 0x00,
  // "‚" (U+201A)
  0x1D, 0x3D, 0x58,
  // "‛" (U+201B)
  0x3D, 0x0D, 0x01,
  // "“" (U+201C)
  0x0D, 0x1D, 0x3D, 0x3D, 0x01, 0x01,
  // "”" (U+201D)
  0x10, 0x10, 0xD3, 0xD3, 0xD1, 0xD0,
  // "„" (U+201E)
  0x1D, 0x1D, 0x3D, 0x3D, 0x58, 0x58,
  // "‟" (U+201F)
  0x01, 0x01, 0x3D, 0x3D, 0x0D, 0x1D,
  // "†" (U+2020)
  0x01, 0xC0, 0x02, 0xB2, 0x2C, 0xEC, 0x00, 0xA0, 0x00, 0xB0, 0x01, 0xC0, 0x02, 0xD0,
  // "‡" (U+2021)
  0x01, 0xD0, 0x14, 0xC5, 0x29, 0xD9, 0x01, 0xD0, 0x17, 0xD8, 0x15, 0xC6, 0x01, 0xD0,
  // "•" (U+2022)
  0x5C, 0x2A, 0xF7, 0x6E, 0x30,
  // "…" (U+2026)
  0x2D, 0x3D, 0x3D,
  // "‰" (U+2030)
  0xAA, 0x00, 0x0A, 0xC9, 0x40, 0x1A, 0x20, 0x03, 0xB7, 0xC5, 0x0B, 0xBB, 0x90, 0xB8, 0xC6,
  // "‹" (U+2039)
  0x0A, 0x37, 0xB0, 0x3D, 0x10, 0x42,
  // "›" (U+203A)
  0x24, 0x01, 0xD3, 0x0B, 0x73, 0xA0,
  // "⁄" (U+2044)
  0x00, 0x76, 0x00, 0xC0, 0x03, 0x90, 0x09, 0x30, 0x0C, 0x00, 0x67, 0x00,
  // "™" (U+2122)
  0x99, 0x94, 0x94, 0x49, 0xC9, 0x33, 0x61, 0x60,
  // "⅒" (U+2152)
  0x40, 0x70, 0x65, 0x06, 0x0D, 0x20, 0xC7, 0x82, 0xB0, 0x39, 0x38, 0x94, 0x7B, 0x44, 0xD5, 0x93,
  0x6D, 0x0C, 0x0B, 0x30, 0xC2, 0x83, 0xB0, 0xC0, 0xB2, 0x87, 0x67, 0x04, 0xD5, 0x6B, 0x40,
  // "∂" (U+2202)
  0x07, 0xDA, 0x00, 0x20, 0xD4, 0x09, 0xDD, 0x55, 0xC0, 0xE3, 0x89, 0x4D, 0x03, 0xDC, 0x30,
  // "∆" (U+2206)
  0x06, 0xF3, 0x00, 0xBC, 0x80, 0x1E, 0x3D, 0x05, 0xA0, 0xD2, 0xA7, 0x19, 0x7E, 0xFF, 0xFB,
  // "√" (U+221A)
  0x00, 0x00, 0x60, 0x00, 0x59, 0x00, 0x09, 0x40, 0x00, 0xD0, 0xA9, 0x2B, 0x01, 0xD7, 0x60, 0x08,
  0xE2, 0x00, 0x3D, 0x00,
  // "∞" (U+221E)
  0x7B, 0x6C, 0x4C, 0x3E, 0x3A, 0x7B, 0x7C, 0x40,
  // "≈" (U+2248)
  0x3E, 0x71, 0x35, 0x2A, 0xE2, 0x7E, 0xEE, 0x41, 0x11, 0x10,
  // "≠" (U+2260)
  0x28, 0x25, 0x70, 0x6B, 0x03, 0x20, 0xD2, 0x06, 0xB8, 0x23, 0x08, 0x32,
  // "≤" (U+2264)
  0x00, 0x00, 0x10, 0x04, 0xB6, 0x2B, 0x81, 0x01, 0x8C, 0x61, 0x00, 0x06, 0x64, 0xCC, 0xC6,
  // "≥" (U+2265)
  0x10, 0x00, 0x06, 0xB4, 0x00, 0x01, 0x8B, 0x21, 0x6C, 0x81, 0x66, 0x00, 0x06, 0xCC, 0xC4,
};

const Font& font_NotoSansMono_Bold_8() {
  static SmoothFont font(font_NotoSansMono_Bold_8_data);
  return font;
}

}  // namespace roo_display
