#include "40.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSansMono-Bold (Noto Sans Mono Bold)
// Generated on Wed Nov 19 19:10:57 CET 2025
static const uint8_t font_NotoSansMono_Bold_40_data[] PROGMEM = {
  
  // Header
  0x01, 0x02, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x5D, 0x00, 0x00,
  0xF8, 0xF7, 0x3E, 0x28, 0x1E, 0xF7, 0x0B, 0x00, 0x48, 0x0B, 0x18, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x08, 0x01, 0x0F, 0x1C, 0x18, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x05, 0x13, 0x12, 0x1C, 0x18, 0x00, 0x4A, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x17, 0x1C, 0x18, 0x00, 0x7F, // "#" (U+0023)
  0x00, 0x24, 0x03, 0xFF, 0x14, 0x1E, 0x18, 0x01, 0x1B, // "$" (U+0024)
  0x00, 0x25, 0x00, 0x01, 0x17, 0x1C, 0x18, 0x01, 0xC5, // "%" (U+0025)
  0x00, 0x26, 0x01, 0x01, 0x17, 0x1C, 0x18, 0x02, 0x9B, // "&" (U+0026)
  0x00, 0x27, 0x09, 0x13, 0x0E, 0x1C, 0x18, 0x03, 0x49, // "'" (U+0027)
  0x00, 0x28, 0x07, 0xFA, 0x11, 0x1C, 0x18, 0x03, 0x5F, // "(" (U+0028)
  0x00, 0x29, 0x06, 0xFB, 0x10, 0x1D, 0x18, 0x03, 0xCC, // ")" (U+0029)
  0x00, 0x2A, 0x03, 0x0E, 0x14, 0x1E, 0x18, 0x04, 0x38, // "*" (U+002A)
  0x00, 0x2B, 0x02, 0x06, 0x15, 0x18, 0x18, 0x04, 0x93, // "+" (U+002B)
  0x00, 0x2C, 0x07, 0xFB, 0x0F, 0x06, 0x18, 0x04, 0xD9, // "," (U+002C)
  0x00, 0x2D, 0x06, 0x09, 0x11, 0x0D, 0x18, 0x04, 0xFD, // "-" (U+002D)
  0x00, 0x2E, 0x08, 0x01, 0x0F, 0x07, 0x18, 0x05, 0x02, // "." (U+002E)
  0x00, 0x2F, 0x04, 0x01, 0x13, 0x1C, 0x18, 0x05, 0x19, // "/" (U+002F)
  0x00, 0x30, 0x02, 0x01, 0x15, 0x1C, 0x18, 0x05, 0x7C, // "0" (U+0030)
  0x00, 0x31, 0x02, 0x01, 0x15, 0x1C, 0x18, 0x06, 0x24, // "1" (U+0031)
  0x00, 0x32, 0x02, 0x01, 0x16, 0x1C, 0x18, 0x06, 0x9A, // "2" (U+0032)
  0x00, 0x33, 0x02, 0x01, 0x15, 0x1C, 0x18, 0x07, 0x24, // "3" (U+0033)
  0x00, 0x34, 0x01, 0x01, 0x16, 0x1C, 0x18, 0x07, 0xB3, // "4" (U+0034)
  0x00, 0x35, 0x03, 0x01, 0x14, 0x1C, 0x18, 0x08, 0x3E, // "5" (U+0035)
  0x00, 0x36, 0x02, 0x01, 0x15, 0x1C, 0x18, 0x08, 0xBA, // "6" (U+0036)
  0x00, 0x37, 0x02, 0x01, 0x15, 0x1C, 0x18, 0x09, 0x58, // "7" (U+0037)
  0x00, 0x38, 0x02, 0x01, 0x15, 0x1C, 0x18, 0x09, 0xB4, // "8" (U+0038)
  0x00, 0x39, 0x02, 0x01, 0x15, 0x1C, 0x18, 0x0A, 0x55, // "9" (U+0039)
  0x00, 0x3A, 0x08, 0x01, 0x0F, 0x16, 0x18, 0x0A, 0xEE, // ":" (U+003A)
  0x00, 0x3B, 0x07, 0xFB, 0x10, 0x16, 0x18, 0x0B, 0x1E, // ";" (U+003B)
  0x00, 0x3C, 0x03, 0x05, 0x14, 0x19, 0x18, 0x0B, 0x5C, // "<" (U+003C)
  0x00, 0x3D, 0x02, 0x08, 0x15, 0x14, 0x18, 0x0B, 0xBD, // "=" (U+003D)
  0x00, 0x3E, 0x03, 0x05, 0x14, 0x19, 0x18, 0x0B, 0xE2, // ">" (U+003E)
  0x00, 0x3F, 0x03, 0x01, 0x14, 0x1C, 0x18, 0x0C, 0x43, // "?" (U+003F)
  0x00, 0x40, 0x00, 0xFE, 0x17, 0x1C, 0x18, 0x0C, 0xB8, // "@" (U+0040)
  0x00, 0x41, 0x00, 0x01, 0x17, 0x1C, 0x18, 0x0D, 0xBF, // "A" (U+0041)
  0x00, 0x42, 0x03, 0x01, 0x16, 0x1C, 0x18, 0x0E, 0x57, // "B" (U+0042)
  0x00, 0x43, 0x02, 0x01, 0x16, 0x1C, 0x18, 0x0E, 0xF7, // "C" (U+0043)
  0x00, 0x44, 0x01, 0x01, 0x16, 0x1C, 0x18, 0x0F, 0x7B, // "D" (U+0044)
  0x00, 0x45, 0x03, 0x01, 0x15, 0x1C, 0x18, 0x10, 0x20, // "E" (U+0045)
  0x00, 0x46, 0x03, 0x01, 0x15, 0x1C, 0x18, 0x10, 0x8C, // "F" (U+0046)
  0x00, 0x47, 0x01, 0x01, 0x16, 0x1C, 0x18, 0x10, 0xF5, // "G" (U+0047)
  0x00, 0x48, 0x01, 0x01, 0x16, 0x1C, 0x18, 0x11, 0x89, // "H" (U+0048)
  0x00, 0x49, 0x03, 0x01, 0x14, 0x1C, 0x18, 0x12, 0x1B, // "I" (U+0049)
  0x00, 0x4A, 0x03, 0x01, 0x13, 0x1C, 0x18, 0x12, 0x85, // "J" (U+004A)
  0x00, 0x4B, 0x01, 0x01, 0x16, 0x1C, 0x18, 0x12, 0xF4, // "K" (U+004B)
  0x00, 0x4C, 0x03, 0x01, 0x15, 0x1C, 0x18, 0x13, 0x9B, // "L" (U+004C)
  0x00, 0x4D, 0x01, 0x01, 0x16, 0x1C, 0x18, 0x13, 0xFF, // "M" (U+004D)
  0x00, 0x4E, 0x01, 0x01, 0x16, 0x1C, 0x18, 0x14, 0xD8, // "N" (U+004E)
  0x00, 0x4F, 0x01, 0x01, 0x16, 0x1C, 0x18, 0x15, 0x99, // "O" (U+004F)
  0x00, 0x50, 0x03, 0x01, 0x16, 0x1C, 0x18, 0x16, 0x42, // "P" (U+0050)
  0x00, 0x51, 0x01, 0xFA, 0x16, 0x1C, 0x18, 0x16, 0xCA, // "Q" (U+0051)
  0x00, 0x52, 0x03, 0x01, 0x17, 0x1C, 0x18, 0x17, 0x91, // "R" (U+0052)
  0x00, 0x53, 0x02, 0x01, 0x15, 0x1C, 0x18, 0x18, 0x1C, // "S" (U+0053)
  0x00, 0x54, 0x01, 0x01, 0x16, 0x1C, 0x18, 0x18, 0xAE, // "T" (U+0054)
  0x00, 0x55, 0x01, 0x01, 0x16, 0x1C, 0x18, 0x19, 0x1F, // "U" (U+0055)
  0x00, 0x56, 0x00, 0x01, 0x17, 0x1C, 0x18, 0x19, 0xBE, // "V" (U+0056)
  0x00, 0x57, 0x00, 0x01, 0x17, 0x1C, 0x18, 0x1A, 0x64, // "W" (U+0057)
  0x00, 0x58, 0x01, 0x01, 0x16, 0x1C, 0x18, 0x1B, 0x43, // "X" (U+0058)
  0x00, 0x59, 0x01, 0x01, 0x16, 0x1C, 0x18, 0x1B, 0xDD, // "Y" (U+0059)
  0x00, 0x5A, 0x03, 0x01, 0x15, 0x1C, 0x18, 0x1C, 0x68, // "Z" (U+005A)
  0x00, 0x5B, 0x09, 0xF9, 0x12, 0x1C, 0x18, 0x1C, 0xD7, // "[" (U+005B)
  0x00, 0x5C, 0x04, 0x01, 0x13, 0x1C, 0x18, 0x1D, 0x43, // "\" (U+005C)
  0x00, 0x5D, 0x05, 0xFC, 0x0E, 0x1F, 0x18, 0x1D, 0xA5, // "]" (U+005D)
  0x00, 0x5E, 0x01, 0x0C, 0x16, 0x1D, 0x18, 0x1E, 0x11, // "^" (U+005E)
  0x00, 0x5F, 0x00, 0xFA, 0x17, 0xFE, 0x18, 0x1E, 0x75, // "_" (U+005F)
  0x00, 0x60, 0x05, 0x19, 0x0F, 0x1F, 0x18, 0x1E, 0x7B, // "`" (U+0060)
  0x00, 0x61, 0x02, 0x01, 0x15, 0x16, 0x18, 0x1E, 0x97, // "a" (U+0061)
  0x00, 0x62, 0x02, 0x01, 0x16, 0x1E, 0x18, 0x1F, 0x14, // "b" (U+0062)
  0x00, 0x63, 0x02, 0x01, 0x14, 0x16, 0x18, 0x1F, 0xBB, // "c" (U+0063)
  0x00, 0x64, 0x01, 0x01, 0x15, 0x1E, 0x18, 0x20, 0x26, // "d" (U+0064)
  0x00, 0x65, 0x02, 0x01, 0x15, 0x16, 0x18, 0x20, 0xD2, // "e" (U+0065)
  0x00, 0x66, 0x02, 0x01, 0x16, 0x1E, 0x18, 0x21, 0x42, // "f" (U+0066)
  0x00, 0x67, 0x01, 0xF8, 0x15, 0x16, 0x18, 0x21, 0xC0, // "g" (U+0067)
  0x00, 0x68, 0x02, 0x01, 0x15, 0x1E, 0x18, 0x22, 0x76, // "h" (U+0068)
  0x00, 0x69, 0x02, 0x01, 0x15, 0x1F, 0x18, 0x22, 0xF7, // "i" (U+0069)
  0x00, 0x6A, 0x01, 0xF8, 0x11, 0x1F, 0x18, 0x23, 0x6E, // "j" (U+006A)
  0x00, 0x6B, 0x02, 0x01, 0x17, 0x1E, 0x18, 0x24, 0x08, // "k" (U+006B)
  0x00, 0x6C, 0x02, 0x01, 0x15, 0x1E, 0x18, 0x24, 0xAF, // "l" (U+006C)
  0x00, 0x6D, 0x01, 0x01, 0x16, 0x16, 0x18, 0x25, 0x1E, // "m" (U+006D)
  0x00, 0x6E, 0x02, 0x01, 0x15, 0x16, 0x18, 0x25, 0xCF, // "n" (U+006E)
  0x00, 0x6F, 0x01, 0x01, 0x16, 0x16, 0x18, 0x26, 0x38, // "o" (U+006F)
  0x00, 0x70, 0x02, 0xF8, 0x16, 0x16, 0x18, 0x26, 0xBB, // "p" (U+0070)
  0x00, 0x71, 0x01, 0xF8, 0x15, 0x16, 0x18, 0x27, 0x65, // "q" (U+0071)
  0x00, 0x72, 0x01, 0x01, 0x17, 0x16, 0x18, 0x28, 0x11, // "r" (U+0072)
  0x00, 0x73, 0x03, 0x01, 0x14, 0x16, 0x18, 0x28, 0x81, // "s" (U+0073)
  0x00, 0x74, 0x02, 0x01, 0x15, 0x1C, 0x18, 0x28, 0xF3, // "t" (U+0074)
  0x00, 0x75, 0x02, 0x01, 0x15, 0x16, 0x18, 0x29, 0x66, // "u" (U+0075)
  0x00, 0x76, 0x01, 0x01, 0x16, 0x16, 0x18, 0x29, 0xD1, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x01, 0x17, 0x16, 0x18, 0x2A, 0x4A, // "w" (U+0077)
  0x00, 0x78, 0x01, 0x01, 0x16, 0x16, 0x18, 0x2A, 0xF3, // "x" (U+0078)
  0x00, 0x79, 0x01, 0xF8, 0x16, 0x16, 0x18, 0x2B, 0x70, // "y" (U+0079)
  0x00, 0x7A, 0x02, 0x01, 0x15, 0x16, 0x18, 0x2C, 0x12, // "z" (U+007A)
  0x00, 0x7B, 0x05, 0xF9, 0x12, 0x1C, 0x18, 0x2C, 0x67, // "{" (U+007B)
  0x00, 0x7C, 0x09, 0xF8, 0x0E, 0x1E, 0x18, 0x2C, 0xD3, // "|" (U+007C)
  0x00, 0x7D, 0x05, 0xFB, 0x12, 0x1E, 0x18, 0x2D, 0x22, // "}" (U+007D)
  0x00, 0x7E, 0x02, 0x0C, 0x15, 0x13, 0x18, 0x2D, 0x8C, // "~" (U+007E)
  0x00, 0xA1, 0x08, 0xFA, 0x0F, 0x15, 0x18, 0x2D, 0xC8, // "¡" (U+00A1)
  0x00, 0xA2, 0x02, 0x01, 0x14, 0x1C, 0x18, 0x2E, 0x12, // "¢" (U+00A2)
  0x00, 0xA3, 0x03, 0x01, 0x15, 0x1C, 0x18, 0x2E, 0x8B, // "£" (U+00A3)
  0x00, 0xA4, 0x02, 0x06, 0x15, 0x19, 0x18, 0x2F, 0x04, // "¤" (U+00A4)
  0x00, 0xA5, 0x01, 0x01, 0x16, 0x1C, 0x18, 0x2F, 0x77, // "¥" (U+00A5)
  0x00, 0xA6, 0x09, 0xF8, 0x0E, 0x1E, 0x18, 0x30, 0x03, // "¦" (U+00A6)
  0x00, 0xA7, 0x04, 0x01, 0x13, 0x1E, 0x18, 0x30, 0x47, // "§" (U+00A7)
  0x00, 0xA8, 0x04, 0x19, 0x13, 0x1E, 0x18, 0x30, 0xDF, // "¨" (U+00A8)
  0x00, 0xA9, 0x01, 0x04, 0x16, 0x19, 0x18, 0x31, 0x03, // "©" (U+00A9)
  0x00, 0xAA, 0x05, 0x10, 0x12, 0x1D, 0x18, 0x31, 0xC4, // "ª" (U+00AA)
  0x00, 0xAB, 0x02, 0x03, 0x15, 0x14, 0x18, 0x32, 0x10, // "«" (U+00AB)
  0x00, 0xAC, 0x02, 0x06, 0x14, 0x11, 0x18, 0x32, 0x88, // "¬" (U+00AC)
  0x00, 0xAE, 0x01, 0x04, 0x16, 0x19, 0x18, 0x32, 0xB3, // "®" (U+00AE)
  0x00, 0xAF, 0x06, 0x1A, 0x12, 0x1D, 0x18, 0x33, 0x83, // "¯" (U+00AF)
  0x00, 0xB0, 0x05, 0x11, 0x12, 0x1C, 0x18, 0x33, 0x8B, // "°" (U+00B0)
  0x00, 0xB1, 0x02, 0x01, 0x15, 0x19, 0x18, 0x33, 0xCC, // "±" (U+00B1)
  0x00, 0xB2, 0x06, 0x12, 0x12, 0x23, 0x18, 0x34, 0x26, // "²" (U+00B2)
  0x00, 0xB3, 0x06, 0x11, 0x11, 0x22, 0x18, 0x34, 0x6C, // "³" (U+00B3)
  0x00, 0xB4, 0x09, 0x19, 0x13, 0x1F, 0x18, 0x34, 0xB9, // "´" (U+00B4)
  0x00, 0xB5, 0x02, 0xF8, 0x15, 0x16, 0x18, 0x34, 0xD1, // "µ" (U+00B5)
  0x00, 0xB6, 0x01, 0xFC, 0x15, 0x1E, 0x18, 0x35, 0x49, // "¶" (U+00B6)
  0x00, 0xB7, 0x08, 0x0C, 0x0F, 0x12, 0x18, 0x36, 0x05, // "·" (U+00B7)
  0x00, 0xB8, 0x08, 0xF8, 0x10, 0x01, 0x18, 0x36, 0x1C, // "¸" (U+00B8)
  0x00, 0xB9, 0x06, 0x12, 0x12, 0x22, 0x18, 0x36, 0x3F, // "¹" (U+00B9)
  0x00, 0xBA, 0x05, 0x10, 0x12, 0x1D, 0x18, 0x36, 0x82, // "º" (U+00BA)
  0x00, 0xBB, 0x02, 0x03, 0x15, 0x14, 0x18, 0x36, 0xD3, // "»" (U+00BB)
  0x00, 0xBC, 0x00, 0x00, 0x17, 0x1C, 0x18, 0x37, 0x4C, // "¼" (U+00BC)
  0x00, 0xBD, 0x00, 0x01, 0x17, 0x1C, 0x18, 0x38, 0x0F, // "½" (U+00BD)
  0x00, 0xBE, 0x01, 0x00, 0x17, 0x1C, 0x18, 0x38, 0xCC, // "¾" (U+00BE)
  0x00, 0xBF, 0x02, 0xFA, 0x13, 0x15, 0x18, 0x39, 0x8D, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x17, 0x26, 0x18, 0x3A, 0x03, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x17, 0x26, 0x18, 0x3A, 0xBF, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x01, 0x17, 0x26, 0x18, 0x3B, 0x77, // "Â" (U+00C2)
  0x00, 0xC3, 0x00, 0x01, 0x17, 0x25, 0x18, 0x3C, 0x3B, // "Ã" (U+00C3)
  0x00, 0xC4, 0x00, 0x01, 0x17, 0x25, 0x18, 0x3C, 0xFD, // "Ä" (U+00C4)
  0x00, 0xC5, 0x00, 0x01, 0x17, 0x28, 0x18, 0x3D, 0xBF, // "Å" (U+00C5)
  0x00, 0xC6, 0x00, 0x01, 0x16, 0x1C, 0x18, 0x3E, 0x8A, // "Æ" (U+00C6)
  0x00, 0xC7, 0x02, 0xF8, 0x16, 0x1C, 0x18, 0x3F, 0x2B, // "Ç" (U+00C7)
  0x00, 0xC8, 0x03, 0x01, 0x15, 0x26, 0x18, 0x3F, 0xD5, // "È" (U+00C8)
  0x00, 0xC9, 0x03, 0x01, 0x15, 0x26, 0x18, 0x40, 0x63, // "É" (U+00C9)
  0x00, 0xCA, 0x03, 0x01, 0x15, 0x26, 0x18, 0x40, 0xEC, // "Ê" (U+00CA)
  0x00, 0xCB, 0x03, 0x01, 0x15, 0x25, 0x18, 0x41, 0x81, // "Ë" (U+00CB)
  0x00, 0xCC, 0x03, 0x01, 0x14, 0x26, 0x18, 0x42, 0x15, // "Ì" (U+00CC)
  0x00, 0xCD, 0x03, 0x01, 0x14, 0x26, 0x18, 0x42, 0xA1, // "Í" (U+00CD)
  0x00, 0xCE, 0x03, 0x01, 0x14, 0x26, 0x18, 0x43, 0x28, // "Î" (U+00CE)
  0x00, 0xCF, 0x03, 0x01, 0x14, 0x25, 0x18, 0x43, 0xBB, // "Ï" (U+00CF)
  0x00, 0xD0, 0x00, 0x01, 0x16, 0x1C, 0x18, 0x44, 0x4D, // "Ð" (U+00D0)
  0x00, 0xD1, 0x01, 0x01, 0x16, 0x25, 0x18, 0x44, 0xF5, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x01, 0x01, 0x16, 0x26, 0x18, 0x45, 0xDF, // "Ò" (U+00D2)
  0x00, 0xD3, 0x01, 0x01, 0x16, 0x26, 0x18, 0x46, 0xAD, // "Ó" (U+00D3)
  0x00, 0xD4, 0x01, 0x01, 0x16, 0x26, 0x18, 0x47, 0x75, // "Ô" (U+00D4)
  0x00, 0xD5, 0x01, 0x01, 0x16, 0x25, 0x18, 0x48, 0x49, // "Õ" (U+00D5)
  0x00, 0xD6, 0x01, 0x01, 0x16, 0x25, 0x18, 0x49, 0x1B, // "Ö" (U+00D6)
  0x00, 0xD7, 0x03, 0x06, 0x14, 0x17, 0x18, 0x49, 0xED, // "×" (U+00D7)
  0x00, 0xD8, 0x00, 0xFF, 0x17, 0x1D, 0x18, 0x4A, 0x4B, // "Ø" (U+00D8)
  0x00, 0xD9, 0x01, 0x01, 0x16, 0x26, 0x18, 0x4B, 0x21, // "Ù" (U+00D9)
  0x00, 0xDA, 0x01, 0x01, 0x16, 0x26, 0x18, 0x4B, 0xE5, // "Ú" (U+00DA)
  0x00, 0xDB, 0x01, 0x01, 0x16, 0x26, 0x18, 0x4C, 0xA3, // "Û" (U+00DB)
  0x00, 0xDC, 0x01, 0x01, 0x16, 0x25, 0x18, 0x4D, 0x6D, // "Ü" (U+00DC)
  0x00, 0xDD, 0x01, 0x01, 0x16, 0x26, 0x18, 0x4E, 0x35, // "Ý" (U+00DD)
  0x00, 0xDE, 0x03, 0x01, 0x16, 0x1C, 0x18, 0x4E, 0xDF, // "Þ" (U+00DE)
  0x00, 0xDF, 0x02, 0x01, 0x16, 0x1E, 0x18, 0x4F, 0x65, // "ß" (U+00DF)
  0x00, 0xE0, 0x02, 0x01, 0x15, 0x1F, 0x18, 0x50, 0x26, // "à" (U+00E0)
  0x00, 0xE1, 0x02, 0x01, 0x15, 0x1F, 0x18, 0x50, 0xC5, // "á" (U+00E1)
  0x00, 0xE2, 0x02, 0x01, 0x15, 0x1F, 0x18, 0x51, 0x5F, // "â" (U+00E2)
  0x00, 0xE3, 0x02, 0x01, 0x15, 0x1E, 0x18, 0x52, 0x05, // "ã" (U+00E3)
  0x00, 0xE4, 0x02, 0x01, 0x15, 0x1E, 0x18, 0x52, 0xAA, // "ä" (U+00E4)
  0x00, 0xE5, 0x02, 0x01, 0x15, 0x21, 0x18, 0x53, 0x4F, // "å" (U+00E5)
  0x00, 0xE6, 0x00, 0x01, 0x17, 0x16, 0x18, 0x53, 0xFD, // "æ" (U+00E6)
  0x00, 0xE7, 0x02, 0xF8, 0x14, 0x16, 0x18, 0x54, 0x95, // "ç" (U+00E7)
  0x00, 0xE8, 0x02, 0x01, 0x15, 0x1F, 0x18, 0x55, 0x24, // "è" (U+00E8)
  0x00, 0xE9, 0x02, 0x01, 0x15, 0x1F, 0x18, 0x55, 0xB6, // "é" (U+00E9)
  0x00, 0xEA, 0x02, 0x01, 0x15, 0x1F, 0x18, 0x56, 0x43, // "ê" (U+00EA)
  0x00, 0xEB, 0x02, 0x01, 0x15, 0x1E, 0x18, 0x56, 0xDD, // "ë" (U+00EB)
  0x00, 0xEC, 0x02, 0x01, 0x15, 0x1F, 0x18, 0x57, 0x75, // "ì" (U+00EC)
  0x00, 0xED, 0x02, 0x01, 0x15, 0x1F, 0x18, 0x57, 0xEC, // "í" (U+00ED)
  0x00, 0xEE, 0x02, 0x01, 0x15, 0x1F, 0x18, 0x58, 0x5E, // "î" (U+00EE)
  0x00, 0xEF, 0x02, 0x01, 0x15, 0x1E, 0x18, 0x58, 0xDC, // "ï" (U+00EF)
  0x00, 0xF0, 0x01, 0x01, 0x16, 0x1F, 0x18, 0x59, 0x59, // "ð" (U+00F0)
  0x00, 0xF1, 0x02, 0x01, 0x15, 0x1E, 0x18, 0x5A, 0x15, // "ñ" (U+00F1)
  0x00, 0xF2, 0x01, 0x01, 0x16, 0x1F, 0x18, 0x5A, 0xA6, // "ò" (U+00F2)
  0x00, 0xF3, 0x01, 0x01, 0x16, 0x1F, 0x18, 0x5B, 0x4D, // "ó" (U+00F3)
  0x00, 0xF4, 0x01, 0x01, 0x16, 0x1F, 0x18, 0x5B, 0xEE, // "ô" (U+00F4)
  0x00, 0xF5, 0x01, 0x01, 0x16, 0x1E, 0x18, 0x5C, 0x9B, // "õ" (U+00F5)
  0x00, 0xF6, 0x01, 0x01, 0x16, 0x1E, 0x18, 0x5D, 0x46, // "ö" (U+00F6)
  0x00, 0xF7, 0x02, 0x05, 0x15, 0x18, 0x18, 0x5D, 0xF1, // "÷" (U+00F7)
  0x00, 0xF8, 0x01, 0x00, 0x16, 0x17, 0x18, 0x5E, 0x35, // "ø" (U+00F8)
  0x00, 0xF9, 0x02, 0x01, 0x15, 0x1F, 0x18, 0x5E, 0xD3, // "ù" (U+00F9)
  0x00, 0xFA, 0x02, 0x01, 0x15, 0x1F, 0x18, 0x5F, 0x60, // "ú" (U+00FA)
  0x00, 0xFB, 0x02, 0x01, 0x15, 0x1F, 0x18, 0x5F, 0xE8, // "û" (U+00FB)
  0x00, 0xFC, 0x02, 0x01, 0x15, 0x1E, 0x18, 0x60, 0x7D, // "ü" (U+00FC)
  0x00, 0xFD, 0x01, 0xF8, 0x16, 0x1F, 0x18, 0x61, 0x10, // "ý" (U+00FD)
  0x00, 0xFE, 0x02, 0xF8, 0x16, 0x1E, 0x18, 0x61, 0xD1, // "þ" (U+00FE)
  0x00, 0xFF, 0x01, 0xF8, 0x16, 0x1E, 0x18, 0x62, 0x9B, // "ÿ" (U+00FF)
  0x01, 0x00, 0x00, 0x01, 0x17, 0x24, 0x18, 0x63, 0x65, // "Ā" (U+0100)
  0x01, 0x01, 0x02, 0x01, 0x15, 0x1D, 0x18, 0x64, 0x0A, // "ā" (U+0101)
  0x01, 0x02, 0x00, 0x01, 0x17, 0x26, 0x18, 0x64, 0x93, // "Ă" (U+0102)
  0x01, 0x03, 0x02, 0x01, 0x15, 0x1F, 0x18, 0x65, 0x56, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0xF8, 0x17, 0x1C, 0x18, 0x65, 0xFB, // "Ą" (U+0104)
  0x01, 0x05, 0x02, 0xF8, 0x15, 0x16, 0x18, 0x66, 0xB7, // "ą" (U+0105)
  0x01, 0x06, 0x02, 0x01, 0x16, 0x26, 0x18, 0x67, 0x55, // "Ć" (U+0106)
  0x01, 0x07, 0x02, 0x01, 0x14, 0x1F, 0x18, 0x67, 0xF7, // "ć" (U+0107)
  0x01, 0x08, 0x02, 0x01, 0x16, 0x26, 0x18, 0x68, 0x7F, // "Ĉ" (U+0108)
  0x01, 0x09, 0x02, 0x01, 0x14, 0x1F, 0x18, 0x69, 0x2E, // "ĉ" (U+0109)
  0x01, 0x0A, 0x02, 0x01, 0x16, 0x26, 0x18, 0x69, 0xC2, // "Ċ" (U+010A)
  0x01, 0x0B, 0x02, 0x01, 0x14, 0x1F, 0x18, 0x6A, 0x68, // "ċ" (U+010B)
  0x01, 0x0C, 0x02, 0x01, 0x16, 0x26, 0x18, 0x6A, 0xF4, // "Č" (U+010C)
  0x01, 0x0D, 0x02, 0x01, 0x14, 0x1F, 0x18, 0x6B, 0xA3, // "č" (U+010D)
  0x01, 0x0E, 0x01, 0x01, 0x16, 0x26, 0x18, 0x6C, 0x38, // "Ď" (U+010E)
  0x01, 0x0F, 0x01, 0x01, 0x1B, 0x1E, 0x18, 0x6D, 0x09, // "ď" (U+010F)
  0x01, 0x10, 0x00, 0x01, 0x16, 0x1C, 0x18, 0x6D, 0xC9, // "Đ" (U+0110)
  0x01, 0x11, 0x01, 0x01, 0x17, 0x1E, 0x18, 0x6E, 0x71, // "đ" (U+0111)
  0x01, 0x12, 0x03, 0x01, 0x15, 0x24, 0x18, 0x6F, 0x1D, // "Ē" (U+0112)
  0x01, 0x13, 0x02, 0x01, 0x15, 0x1D, 0x18, 0x6F, 0x96, // "ē" (U+0113)
  0x01, 0x14, 0x03, 0x01, 0x15, 0x26, 0x18, 0x70, 0x13, // "Ĕ" (U+0114)
  0x01, 0x15, 0x02, 0x01, 0x15, 0x1F, 0x18, 0x70, 0xA8, // "ĕ" (U+0115)
  0x01, 0x16, 0x03, 0x01, 0x15, 0x26, 0x18, 0x71, 0x41, // "Ė" (U+0116)
  0x01, 0x17, 0x02, 0x01, 0x15, 0x1F, 0x18, 0x71, 0xCE, // "ė" (U+0117)
  0x01, 0x18, 0x03, 0xF8, 0x15, 0x1C, 0x18, 0x72, 0x5F, // "Ę" (U+0118)
  0x01, 0x19, 0x02, 0xF8, 0x15, 0x16, 0x18, 0x72, 0xEB, // "ę" (U+0119)
  0x01, 0x1A, 0x03, 0x01, 0x15, 0x26, 0x18, 0x73, 0x80, // "Ě" (U+011A)
  0x01, 0x1B, 0x02, 0x01, 0x15, 0x1F, 0x18, 0x74, 0x17, // "ě" (U+011B)
  0x01, 0x1C, 0x01, 0x01, 0x16, 0x26, 0x18, 0x74, 0xB2, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x01, 0xF8, 0x15, 0x1F, 0x18, 0x75, 0x71, // "ĝ" (U+011D)
  0x01, 0x1E, 0x01, 0x01, 0x16, 0x26, 0x18, 0x76, 0x52, // "Ğ" (U+011E)
  0x01, 0x1F, 0x01, 0xF8, 0x15, 0x1F, 0x18, 0x77, 0x11, // "ğ" (U+011F)
  0x01, 0x20, 0x01, 0x01, 0x16, 0x26, 0x18, 0x77, 0xF1, // "Ġ" (U+0120)
  0x01, 0x21, 0x01, 0xF8, 0x15, 0x1F, 0x18, 0x78, 0xA8, // "ġ" (U+0121)
  0x01, 0x22, 0x01, 0xF8, 0x16, 0x1C, 0x18, 0x79, 0x80, // "Ģ" (U+0122)
  0x01, 0x23, 0x01, 0xF8, 0x15, 0x1E, 0x18, 0x7A, 0x2F, // "ģ" (U+0123)
  0x01, 0x24, 0x01, 0x01, 0x16, 0x26, 0x18, 0x7A, 0xFE, // "Ĥ" (U+0124)
  0x01, 0x25, 0xFD, 0x01, 0x15, 0x28, 0x18, 0x7B, 0xBB, // "ĥ" (U+0125)
  0x01, 0x26, 0x00, 0x01, 0x17, 0x1C, 0x18, 0x7C, 0x77, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x15, 0x1E, 0x18, 0x7C, 0xF2, // "ħ" (U+0127)
  0x01, 0x28, 0x03, 0x01, 0x14, 0x25, 0x18, 0x7D, 0x80, // "Ĩ" (U+0128)
  0x01, 0x29, 0x02, 0x01, 0x15, 0x1E, 0x18, 0x7E, 0x12, // "ĩ" (U+0129)
  0x01, 0x2A, 0x03, 0x01, 0x14, 0x24, 0x18, 0x7E, 0x8F, // "Ī" (U+012A)
  0x01, 0x2B, 0x02, 0x01, 0x15, 0x1D, 0x18, 0x7F, 0x06, // "ī" (U+012B)
  0x01, 0x2C, 0x03, 0x01, 0x14, 0x26, 0x18, 0x7F, 0x67, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x02, 0x01, 0x15, 0x1F, 0x18, 0x7F, 0xF9, // "ĭ" (U+012D)
  0x01, 0x2E, 0x03, 0xF8, 0x14, 0x1C, 0x18, 0x80, 0x76, // "Į" (U+012E)
  0x01, 0x2F, 0x02, 0xF8, 0x15, 0x1F, 0x18, 0x81, 0x00, // "į" (U+012F)
  0x01, 0x30, 0x03, 0x01, 0x14, 0x26, 0x18, 0x81, 0x99, // "İ" (U+0130)
  0x01, 0x31, 0x02, 0x01, 0x15, 0x16, 0x18, 0x82, 0x24, // "ı" (U+0131)
  0x01, 0x32, 0x03, 0x01, 0x14, 0x1C, 0x18, 0x82, 0x79, // "Ĳ" (U+0132)
  0x01, 0x33, 0x03, 0xF8, 0x14, 0x1F, 0x18, 0x83, 0x08, // "ĳ" (U+0133)
  0x01, 0x34, 0x03, 0x01, 0x18, 0x26, 0x18, 0x83, 0xE1, // "Ĵ" (U+0134)
  0x01, 0x35, 0x01, 0xF8, 0x15, 0x1F, 0x18, 0x84, 0x87, // "ĵ" (U+0135)
  0x01, 0x36, 0x01, 0xF8, 0x16, 0x1C, 0x18, 0x85, 0x30, // "Ķ" (U+0136)
  0x01, 0x37, 0x02, 0xF8, 0x17, 0x1E, 0x18, 0x85, 0xF2, // "ķ" (U+0137)
  0x01, 0x38, 0x02, 0x01, 0x17, 0x16, 0x18, 0x86, 0xB5, // "ĸ" (U+0138)
  0x01, 0x39, 0x03, 0x01, 0x15, 0x26, 0x18, 0x87, 0x3C, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x02, 0x01, 0x15, 0x28, 0x18, 0x87, 0xBE, // "ĺ" (U+013A)
  0x01, 0x3B, 0x03, 0xF8, 0x15, 0x1C, 0x18, 0x88, 0x4A, // "Ļ" (U+013B)
  0x01, 0x3C, 0x02, 0xF8, 0x15, 0x1E, 0x18, 0x88, 0xC7, // "ļ" (U+013C)
  0x01, 0x3D, 0x03, 0x01, 0x15, 0x1C, 0x18, 0x89, 0x4F, // "Ľ" (U+013D)
  0x01, 0x3E, 0x02, 0x01, 0x17, 0x1E, 0x18, 0x89, 0xC1, // "ľ" (U+013E)
  0x01, 0x3F, 0x03, 0x01, 0x15, 0x1C, 0x18, 0x8A, 0x4F, // "Ŀ" (U+013F)
  0x01, 0x40, 0x02, 0x01, 0x1B, 0x1E, 0x18, 0x8A, 0xC5, // "ŀ" (U+0140)
  0x01, 0x41, 0x01, 0x01, 0x16, 0x1C, 0x18, 0x8B, 0x58, // "Ł" (U+0141)
  0x01, 0x42, 0x02, 0x01, 0x15, 0x1E, 0x18, 0x8B, 0xC1, // "ł" (U+0142)
  0x01, 0x43, 0x01, 0x01, 0x16, 0x26, 0x18, 0x8C, 0x41, // "Ń" (U+0143)
  0x01, 0x44, 0x02, 0x01, 0x15, 0x1F, 0x18, 0x8D, 0x21, // "ń" (U+0144)
  0x01, 0x45, 0x01, 0xF8, 0x16, 0x1C, 0x18, 0x8D, 0xA7, // "Ņ" (U+0145)
  0x01, 0x46, 0x02, 0xF8, 0x15, 0x16, 0x18, 0x8E, 0x83, // "ņ" (U+0146)
  0x01, 0x47, 0x01, 0x01, 0x16, 0x26, 0x18, 0x8F, 0x05, // "Ň" (U+0147)
  0x01, 0x48, 0x02, 0x01, 0x15, 0x1F, 0x18, 0x8F, 0xF2, // "ň" (U+0148)
  0x01, 0x49, 0xFB, 0x01, 0x15, 0x1C, 0x18, 0x90, 0x86, // "ŉ" (U+0149)
  0x01, 0x4A, 0x01, 0xF8, 0x16, 0x1C, 0x18, 0x91, 0x22, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x02, 0xF8, 0x15, 0x16, 0x18, 0x92, 0x0E, // "ŋ" (U+014B)
  0x01, 0x4C, 0x01, 0x01, 0x16, 0x24, 0x18, 0x92, 0x9B, // "Ō" (U+014C)
  0x01, 0x4D, 0x01, 0x01, 0x16, 0x1D, 0x18, 0x93, 0x52, // "ō" (U+014D)
  0x01, 0x4E, 0x01, 0x01, 0x16, 0x26, 0x18, 0x93, 0xE3, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x01, 0x01, 0x16, 0x1F, 0x18, 0x94, 0xB7, // "ŏ" (U+014F)
  0x01, 0x50, 0x01, 0x01, 0x16, 0x25, 0x18, 0x95, 0x64, // "Ő" (U+0150)
  0x01, 0x51, 0x01, 0x01, 0x16, 0x1E, 0x18, 0x96, 0x38, // "ő" (U+0151)
  0x01, 0x52, 0x01, 0x01, 0x17, 0x1C, 0x18, 0x96, 0xE5, // "Œ" (U+0152)
  0x01, 0x53, 0x00, 0x01, 0x17, 0x16, 0x18, 0x97, 0x8B, // "œ" (U+0153)
  0x01, 0x54, 0x03, 0x01, 0x17, 0x26, 0x18, 0x98, 0x25, // "Ŕ" (U+0154)
  0x01, 0x55, 0x01, 0x01, 0x17, 0x1F, 0x18, 0x98, 0xCF, // "ŕ" (U+0155)
  0x01, 0x56, 0x03, 0xF8, 0x17, 0x1C, 0x18, 0x99, 0x5F, // "Ŗ" (U+0156)
  0x01, 0x57, 0x01, 0xF8, 0x17, 0x16, 0x18, 0x9A, 0x05, // "ŗ" (U+0157)
  0x01, 0x58, 0x03, 0x01, 0x17, 0x26, 0x18, 0x9A, 0x90, // "Ř" (U+0158)
  0x01, 0x59, 0x01, 0x01, 0x17, 0x1F, 0x18, 0x9B, 0x47, // "ř" (U+0159)
  0x01, 0x5A, 0x02, 0x01, 0x15, 0x26, 0x18, 0x9B, 0xE3, // "Ś" (U+015A)
  0x01, 0x5B, 0x03, 0x01, 0x14, 0x1F, 0x18, 0x9C, 0x92, // "ś" (U+015B)
  0x01, 0x5C, 0x02, 0x01, 0x15, 0x26, 0x18, 0x9D, 0x21, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x03, 0x01, 0x14, 0x1F, 0x18, 0x9D, 0xDD, // "ŝ" (U+015D)
  0x01, 0x5E, 0x02, 0xF8, 0x15, 0x1C, 0x18, 0x9E, 0x78, // "Ş" (U+015E)
  0x01, 0x5F, 0x03, 0xF8, 0x14, 0x16, 0x18, 0x9F, 0x2F, // "ş" (U+015F)
  0x01, 0x60, 0x02, 0x01, 0x15, 0x26, 0x18, 0x9F, 0xC5, // "Š" (U+0160)
  0x01, 0x61, 0x03, 0x01, 0x14, 0x1F, 0x18, 0xA0, 0x82, // "š" (U+0161)
  0x01, 0x62, 0x01, 0xF8, 0x16, 0x1C, 0x18, 0xA1, 0x1E, // "Ţ" (U+0162)
  0x01, 0x63, 0x02, 0xF8, 0x15, 0x1C, 0x18, 0xA1, 0xB6, // "ţ" (U+0163)
  0x01, 0x64, 0x01, 0x01, 0x16, 0x26, 0x18, 0xA2, 0x4F, // "Ť" (U+0164)
  0x01, 0x65, 0x02, 0x01, 0x16, 0x1E, 0x18, 0xA2, 0xEC, // "ť" (U+0165)
  0x01, 0x66, 0x01, 0x01, 0x16, 0x1C, 0x18, 0xA3, 0x79, // "Ŧ" (U+0166)
  0x01, 0x67, 0x02, 0x01, 0x15, 0x1C, 0x18, 0xA3, 0xEC, // "ŧ" (U+0167)
  0x01, 0x68, 0x01, 0x01, 0x16, 0x25, 0x18, 0xA4, 0x5F, // "Ũ" (U+0168)
  0x01, 0x69, 0x02, 0x01, 0x15, 0x1E, 0x18, 0xA5, 0x27, // "ũ" (U+0169)
  0x01, 0x6A, 0x01, 0x01, 0x16, 0x24, 0x18, 0xA5, 0xBA, // "Ū" (U+016A)
  0x01, 0x6B, 0x02, 0x01, 0x15, 0x1D, 0x18, 0xA6, 0x67, // "ū" (U+016B)
  0x01, 0x6C, 0x01, 0x01, 0x16, 0x26, 0x18, 0xA6, 0xDE, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x02, 0x01, 0x15, 0x1F, 0x18, 0xA7, 0xA8, // "ŭ" (U+016D)
  0x01, 0x6E, 0x01, 0x01, 0x16, 0x28, 0x18, 0xA8, 0x3C, // "Ů" (U+016E)
  0x01, 0x6F, 0x02, 0x01, 0x15, 0x21, 0x18, 0xA9, 0x0E, // "ů" (U+016F)
  0x01, 0x70, 0x01, 0x01, 0x16, 0x25, 0x18, 0xA9, 0xAA, // "Ű" (U+0170)
  0x01, 0x71, 0x02, 0x01, 0x15, 0x1E, 0x18, 0xAA, 0x74, // "ű" (U+0171)
  0x01, 0x72, 0x01, 0xF8, 0x16, 0x1C, 0x18, 0xAB, 0x07, // "Ų" (U+0172)
  0x01, 0x73, 0x02, 0xF8, 0x15, 0x16, 0x18, 0xAB, 0xCE, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x17, 0x26, 0x18, 0xAC, 0x5A, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x17, 0x1F, 0x18, 0xAD, 0x66, // "ŵ" (U+0175)
  0x01, 0x76, 0x01, 0x01, 0x16, 0x26, 0x18, 0xAE, 0x3C, // "Ŷ" (U+0176)
  0x01, 0x77, 0x01, 0xF8, 0x16, 0x1F, 0x18, 0xAE, 0xF2, // "ŷ" (U+0177)
  0x01, 0x78, 0x01, 0x01, 0x16, 0x25, 0x18, 0xAF, 0xBF, // "Ÿ" (U+0178)
  0x01, 0x79, 0x03, 0x01, 0x15, 0x26, 0x18, 0xB0, 0x73, // "Ź" (U+0179)
  0x01, 0x7A, 0x02, 0x01, 0x15, 0x1F, 0x18, 0xB0, 0xFF, // "ź" (U+017A)
  0x01, 0x7B, 0x03, 0x01, 0x15, 0x26, 0x18, 0xB1, 0x71, // "Ż" (U+017B)
  0x01, 0x7C, 0x02, 0x01, 0x15, 0x1F, 0x18, 0xB2, 0x01, // "ż" (U+017C)
  0x01, 0x7D, 0x03, 0x01, 0x15, 0x26, 0x18, 0xB2, 0x77, // "Ž" (U+017D)
  0x01, 0x7E, 0x02, 0x01, 0x15, 0x1F, 0x18, 0xB3, 0x10, // "ž" (U+017E)
  0x01, 0x7F, 0x08, 0x01, 0x14, 0x1E, 0x18, 0xB3, 0x8F, // "ſ" (U+017F)
  0x03, 0xA9, 0x00, 0x01, 0x17, 0x1C, 0x18, 0xB3, 0xDA, // "Ω" (U+03A9)
  0x03, 0xBC, 0x02, 0xF7, 0x15, 0x16, 0x18, 0xB4, 0x8C, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x01, 0x17, 0x16, 0x18, 0xB5, 0x07, // "π" (U+03C0)
  0x20, 0x13, 0x04, 0x09, 0x13, 0x0D, 0x18, 0xB5, 0x94, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x09, 0x17, 0x0D, 0x18, 0xB5, 0x99, // "—" (U+2014)
  0x20, 0xAC, 0x01, 0x01, 0x16, 0x1C, 0x18, 0xB5, 0x9F, // "€" (U+20AC)
  0x20, 0xBF, 0x03, 0xFD, 0x16, 0x21, 0x18, 0xB6, 0x1E, // "₿" (U+20BF)
  0x20, 0x18, 0x08, 0x13, 0x0F, 0x1C, 0x18, 0xB6, 0xEE, // "‘" (U+2018)
  0x20, 0x19, 0x08, 0x13, 0x0F, 0x1C, 0x18, 0xB7, 0x0B, // "’" (U+2019)
  0x20, 0x1A, 0x07, 0xFB, 0x0F, 0x06, 0x18, 0xB7, 0x27, // "‚" (U+201A)
  0x20, 0x1B, 0x08, 0x13, 0x0F, 0x1C, 0x18, 0xB7, 0x4B, // "‛" (U+201B)
  0x20, 0x1C, 0x04, 0x13, 0x13, 0x1C, 0x18, 0xB7, 0x67, // "“" (U+201C)
  0x20, 0x1D, 0x04, 0x14, 0x13, 0x1D, 0x18, 0xB7, 0xA0, // "”" (U+201D)
  0x20, 0x1E, 0x04, 0xFB, 0x14, 0x06, 0x18, 0xB7, 0xD9, // "„" (U+201E)
  0x20, 0x1F, 0x04, 0x14, 0x13, 0x1D, 0x18, 0xB8, 0x20, // "‟" (U+201F)
  0x20, 0x20, 0x04, 0x01, 0x13, 0x1E, 0x18, 0xB8, 0x58, // "†" (U+2020)
  0x20, 0x21, 0x03, 0x01, 0x14, 0x1E, 0x18, 0xB8, 0xCE, // "‡" (U+2021)
  0x20, 0x22, 0x06, 0x09, 0x11, 0x14, 0x18, 0xB9, 0x52, // "•" (U+2022)
  0x20, 0x26, 0x00, 0x01, 0x17, 0x07, 0x18, 0xB9, 0x7F, // "…" (U+2026)
  0x20, 0x30, 0x00, 0x01, 0x17, 0x1C, 0x18, 0xB9, 0xC4, // "‰" (U+2030)
  0x20, 0x39, 0x06, 0x03, 0x11, 0x14, 0x18, 0xBA, 0x9E, // "‹" (U+2039)
  0x20, 0x3A, 0x06, 0x03, 0x11, 0x14, 0x18, 0xBA, 0xDC, // "›" (U+203A)
  0x20, 0x44, 0xF8, 0x01, 0x07, 0x1C, 0x00, 0xBB, 0x1A, // "⁄" (U+2044)
  0x21, 0x22, 0x00, 0x10, 0x17, 0x1D, 0x18, 0xBB, 0x80, // "™" (U+2122)
  0x21, 0x52, 0x0A, 0x00, 0x3E, 0x1D, 0x48, 0xBC, 0x07, // "⅒" (U+2152)
  0x22, 0x02, 0x02, 0x01, 0x15, 0x1E, 0x18, 0xBD, 0x67, // "∂" (U+2202)
  0x22, 0x06, 0x00, 0x01, 0x17, 0x1C, 0x18, 0xBE, 0x10, // "∆" (U+2206)
  0x22, 0x1A, 0x01, 0x01, 0x18, 0x22, 0x18, 0xBE, 0xAC, // "√" (U+221A)
  0x22, 0x1E, 0x00, 0x09, 0x17, 0x15, 0x18, 0xBF, 0x4E, // "∞" (U+221E)
  0x22, 0x48, 0x02, 0x08, 0x15, 0x16, 0x18, 0xBF, 0xBF, // "≈" (U+2248)
  0x22, 0x60, 0x02, 0x03, 0x15, 0x1A, 0x18, 0xC0, 0x1C, // "≠" (U+2260)
  0x22, 0x64, 0x02, 0x01, 0x15, 0x1A, 0x18, 0xC0, 0x79, // "≤" (U+2264)
  0x22, 0x65, 0x02, 0x01, 0x15, 0x1A, 0x18, 0xC0, 0xF4, // "≥" (U+2265)
  
  // Kerning pairs
  
  // Glyph data
  // "!" (U+0021)
  0x05, 0xE0, 0x50, 0x4E, 0x05, 0x03, 0xE0, 0x40, 0x3E, 0x03, 0x02, 0xE0, 0x30, 0x1E, 0x02, 0x01,
  0xE0, 0x11, 0xE0, 0x11, 0xE2, 0x0E, 0xD2, 0x0D, 0xC0, 0xE2, 0x0D, 0xC0, 0xD2, 0x0C, 0xC0, 0xD2,
  0x0B, 0xC0, 0xC2, 0x0B, 0xC0, 0xB2, 0x0A, 0xC0, 0xB2, 0x09, 0xC0, 0xA2, 0x09, 0xC0, 0x92, 0x08,
  0xC0, 0x97, 0x74, 0x86, 0x3B, 0xEE, 0xB2, 0x02, 0xD8, 0x1E, 0x17, 0xE0, 0x60, 0x9E, 0x08, 0x07,
  0xE8, 0x16, 0x1E, 0xC8, 0x7E, 0x10, 0x3B, 0xEE, 0xA2, 0x10,
  // """ (U+0022)
  0x0B, 0xC0, 0xB2, 0x0B, 0xC0, 0xB0, 0xAC, 0x0A, 0x20, 0xAC, 0x0A, 0x09, 0xC0, 0x82, 0x08, 0xC0,
  0x90, 0x8C, 0x07, 0x20, 0x7C, 0x08, 0x07, 0xC0, 0x62, 0x06, 0xC0, 0x70, 0x6C, 0x05, 0x20, 0x5C,
  0x05, 0x04, 0xC0, 0x42, 0x04, 0xC0, 0x40, 0x3C, 0x02, 0x20, 0x3C, 0x03, 0x02, 0xC0, 0x12, 0x01,
  0xC0, 0x20, 0x1C, 0x4C, 0x01,
  // "#" (U+0023)
  0x71, 0x08, 0xB0, 0x73, 0xB0, 0xE7, 0x50, 0xBB, 0x04, 0x20, 0x3B, 0x0B, 0x75, 0x0E, 0xB0, 0x12,
  0x06, 0xB0, 0x97, 0x40, 0x1B, 0x0E, 0x30, 0x9B, 0x06, 0x74, 0x04, 0xB0, 0xB3, 0x0C, 0xB0, 0x37,
  0x40, 0x7B, 0x08, 0x30, 0xEB, 0x75, 0x0A, 0xB0, 0x52, 0x02, 0xB0, 0xD6, 0x03, 0xFF, 0xF8, 0x16,
  0x03, 0xFF, 0xF8, 0x16, 0x03, 0xFF, 0xF8, 0x16, 0x03, 0xFF, 0xF0, 0x66, 0x06, 0xB0, 0x93, 0x0E,
  0xB7, 0x50, 0x9B, 0x06, 0x20, 0x1B, 0x0D, 0x75, 0x0B, 0xB0, 0x42, 0x04, 0xB0, 0xB7, 0x50, 0xEB,
  0x01, 0x20, 0x6B, 0x08, 0x74, 0x01, 0xB0, 0xE3, 0x09, 0xB0, 0x66, 0x06, 0xFF, 0xF8, 0x13, 0x06,
  0xFF, 0xF8, 0x13, 0x06, 0xFF, 0xF8, 0x13, 0x06, 0xFF, 0xF0, 0x36, 0x0D, 0xB0, 0x12, 0x06, 0xB0,
  0x97, 0x5B, 0x0E, 0x30, 0x9B, 0x07, 0x74, 0x03, 0xB0, 0xC3, 0x0C, 0xB0, 0x47, 0x40, 0x5B, 0x0A,
  0x30, 0xEB, 0x02, 0x74, 0x07, 0xB0, 0x72, 0x01, 0xC7, 0x50, 0xAB, 0x05, 0x20, 0x4B, 0x0C, 0x75,
  0x0C, 0xB0, 0x22, 0x06, 0xB0, 0xA7, 0x50, 0xEB, 0x30, 0x9B, 0x07, 0x71,
  // "$" (U+0024)
  0x70, 0x3A, 0x06, 0x77, 0x03, 0xA0, 0x67, 0x60, 0x10, 0x6A, 0x81, 0x93, 0x27, 0x20, 0x70, 0xCF,
  0x98, 0x1B, 0x71, 0x30, 0x40, 0xDF, 0xE8, 0x14, 0x04, 0xFF, 0x98, 0x11, 0x0E, 0xFF, 0x81, 0xA0,
  0x6D, 0x08, 0x05, 0xA8, 0x77, 0x36, 0x9E, 0xF4, 0x09, 0xC8, 0x18, 0x03, 0xA0, 0x64, 0x04, 0x20,
  0xBC, 0x81, 0x50, 0x3A, 0x06, 0x70, 0xBC, 0x81, 0x70, 0x3A, 0x06, 0x70, 0x8D, 0x06, 0x03, 0xA0,
  0x67, 0x02, 0xE0, 0xEA, 0x06, 0x71, 0x08, 0xF9, 0x0A, 0x02, 0x71, 0x09, 0xFA, 0x0B, 0x03, 0x70,
  0x40, 0xDF, 0xA0, 0xA0, 0x17, 0x06, 0x0D, 0xF9, 0x0D, 0x01, 0x71, 0x05, 0xF9, 0x0C, 0x71, 0x03,
  0xA0, 0xB0, 0xED, 0x04, 0x70, 0x3A, 0x81, 0x61, 0xCC, 0x09, 0x70, 0x3A, 0x81, 0x60, 0x4C, 0x0B,
  0x70, 0x3A, 0x81, 0x60, 0x4C, 0x82, 0xBB, 0x82, 0x40, 0x3A, 0x81, 0x60, 0x9C, 0x0A, 0x0B, 0xA8,
  0x3C, 0x74, 0x13, 0xA0, 0x09, 0xD0, 0x60, 0xBF, 0xF9, 0x81, 0xE0, 0xBF, 0xF9, 0x81, 0x50, 0xBF,
  0xF0, 0x62, 0x81, 0x18, 0xDF, 0xB0, 0xB0, 0x36, 0x83, 0x25, 0x79, 0xAA, 0x81, 0xB6, 0x17, 0x50,
  0x3A, 0x06, 0x77, 0x03, 0xA0, 0x67, 0x70, 0x3A, 0x06, 0x70,
  // "%" (U+0025)
  0x28, 0x52, 0x9D, 0xFE, 0xB6, 0x70, 0x4B, 0x0E, 0x40, 0x5F, 0x0B, 0x60, 0xCB, 0x07, 0x30, 0x2F,
  0xA0, 0x94, 0x05, 0xB0, 0xD4, 0x09, 0xB8, 0x19, 0x14, 0xC0, 0x13, 0x0D, 0xB0, 0x64, 0x0D, 0xB0,
  0x12, 0x0A, 0xB0, 0x42, 0x06, 0xB0, 0xD5, 0x0E, 0xB3, 0x08, 0xB0, 0x62, 0x0D, 0xB0, 0x55, 0xB0,
  0xE3, 0x08, 0xB8, 0x16, 0x06, 0xB0, 0xD6, 0x0D, 0xB0, 0x12, 0x0A, 0xB8, 0x14, 0x0E, 0xB0, 0x56,
  0x09, 0xB8, 0x29, 0x13, 0xEB, 0x01, 0x07, 0xB0, 0xC7, 0x02, 0xFA, 0x81, 0x91, 0xEB, 0x04, 0x71,
  0x05, 0xF8, 0x1C, 0x08, 0xB0, 0xC7, 0x38, 0x90, 0x39, 0xDF, 0xEC, 0x60, 0x1E, 0xB0, 0x47, 0x74,
  0x08, 0xB0, 0xB7, 0x74, 0x01, 0xC0, 0x37, 0x74, 0x09, 0xB0, 0xA7, 0x74, 0x02, 0xC8, 0x72, 0x05,
  0xBE, 0xFD, 0x92, 0x73, 0x0A, 0xB8, 0x1A, 0x0A, 0xE0, 0xE0, 0x47, 0x10, 0x2C, 0x02, 0x07, 0xF9,
  0x0E, 0x01, 0x70, 0xAB, 0x81, 0x90, 0xEB, 0x81, 0x41, 0xAB, 0x07, 0x60, 0x3C, 0x01, 0x03, 0xB0,
  0xA2, 0x03, 0xB0, 0xC6, 0x0B, 0xB8, 0x19, 0x05, 0xB0, 0x83, 0xB0, 0xE5, 0x03, 0xB8, 0x2E, 0x10,
  0x6B, 0x07, 0x30, 0xEB, 0x50, 0xBB, 0x08, 0x20, 0x5B, 0x08, 0x3B, 0x0E, 0x40, 0x4B, 0x0E, 0x01,
  0x20, 0x3B, 0x0A, 0x20, 0x2B, 0x0C, 0x40, 0xCB, 0x07, 0x40, 0xEB, 0x81, 0x41, 0xAB, 0x08, 0x30,
  0x5B, 0x0E, 0x50, 0x7F, 0x90, 0xE0, 0x13, 0x0D, 0xB0, 0x76, 0x0A, 0xF0, 0x43, 0x05, 0xB0, 0xE7,
  0x18, 0x55, 0xBE, 0xFD, 0x92, 0x20,
  // "&" (U+0026)
  0x58, 0x63, 0x9D, 0xFE, 0xDA, 0x47, 0x70, 0x7F, 0x90, 0xA7, 0x50, 0x6F, 0xB0, 0x97, 0x40, 0xEF,
  0xC0, 0x27, 0x20, 0x4C, 0x82, 0xD2, 0x1A, 0xC0, 0x67, 0x20, 0x7C, 0x06, 0x20, 0x2C, 0x08, 0x72,
  0x07, 0xC0, 0x42, 0x01, 0xC0, 0x87, 0x20, 0x6C, 0x06, 0x20, 0x5C, 0x05, 0x72, 0x03, 0xC8, 0x2B,
  0x01, 0xDB, 0x0E, 0x01, 0x73, 0x0D, 0xC0, 0x50, 0xDC, 0x07, 0x74, 0x06, 0xFA, 0x0B, 0x76, 0x0D,
  0xF0, 0xD0, 0x17, 0x60, 0x6E, 0x0D, 0x01, 0x76, 0x04, 0x0E, 0xE0, 0x64, 0x0E, 0xC0, 0x23, 0x04,
  0xF9, 0x0E, 0x02, 0x20, 0x2D, 0x30, 0x10, 0xEF, 0xA8, 0x2D, 0x10, 0x6C, 0x0B, 0x30, 0xAD, 0x07,
  0xD8, 0x1B, 0x0C, 0xC0, 0x72, 0x02, 0xD8, 0x15, 0x06, 0xD0, 0x9D, 0x02, 0x20, 0x7C, 0x0B, 0x30,
  0xAF, 0xA0, 0xC3, 0x0A, 0xC0, 0x64, 0x0D, 0xF9, 0x05, 0x30, 0xCC, 0x05, 0x40, 0x3F, 0x0D, 0x40,
  0xBC, 0x09, 0x50, 0x6E, 0x04, 0x40, 0x9D, 0x04, 0x30, 0x20, 0xBE, 0x07, 0x40, 0x4E, 0x81, 0xCA,
  0xCF, 0xA0, 0x34, 0x0D, 0xFF, 0xB0, 0xD4, 0x04, 0xFF, 0xC0, 0x94, 0x04, 0x0E, 0xF9, 0x82, 0xE8,
  0x2D, 0xD0, 0x54, 0x89, 0x01, 0x6B, 0xDF, 0xED, 0xA6, 0x12, 0x04, 0xD0, 0xE0, 0x10,
  // "'" (U+0027)
  0x0B, 0xC0, 0xB0, 0xAC, 0x0A, 0x09, 0xC0, 0x08, 0xC0, 0x07, 0xC0, 0x06, 0xC0, 0x50, 0x4C, 0x04,
  0x03, 0xC0, 0x02, 0xC0, 0x01, 0xC1,
  // "(" (U+0028)
  0x50, 0x20, 0xEB, 0x0A, 0x50, 0xCB, 0x0E, 0x01, 0x40, 0x6C, 0x06, 0x40, 0x10, 0xEB, 0x0D, 0x50,
  0x8C, 0x06, 0x50, 0xEB, 0x0E, 0x50, 0x6C, 0x08, 0x50, 0xBC, 0x03, 0x40, 0x1C, 0x0E, 0x50, 0x5C,
  0x0A, 0x50, 0x9C, 0x06, 0x50, 0xCC, 0x03, 0x5D, 0x50, 0x2C, 0x0D, 0x50, 0x3C, 0x0C, 0x50, 0x5C,
  0x0B, 0x50, 0x5C, 0x0A, 0x50, 0x6C, 0x0A, 0x50, 0x5C, 0x0A, 0x50, 0x5C, 0x0B, 0x50, 0x4C, 0x0C,
  0x50, 0x2C, 0x0D, 0x6D, 0x60, 0xDC, 0x03, 0x50, 0xAC, 0x06, 0x50, 0x6C, 0x0A, 0x50, 0x2C, 0x0E,
  0x60, 0xCC, 0x04, 0x50, 0x7C, 0x09, 0x50, 0x10, 0xEB, 0x0E, 0x01, 0x50, 0x8C, 0x07, 0x50, 0x10,
  0xEB, 0x0D, 0x60, 0x7C, 0x07, 0x60, 0xCB, 0x0E, 0x01, 0x50, 0x20, 0xEB, 0x09,
  // ")" (U+0029)
  0x0A, 0xB0, 0xE0, 0x25, 0x01, 0x0E, 0xB0, 0xC6, 0x07, 0xC0, 0x76, 0x0E, 0xB0, 0xE0, 0x15, 0x07,
  0xC0, 0x85, 0x01, 0xC0, 0xE0, 0x15, 0x0A, 0xC0, 0x65, 0x04, 0xC0, 0xC6, 0x0E, 0xC0, 0x15, 0x0A,
  0xC0, 0x65, 0x06, 0xC0, 0xA5, 0x03, 0xC0, 0xD6, 0xD6, 0x0E, 0xC0, 0x25, 0x0C, 0xC0, 0x45, 0x0B,
  0xC0, 0x55, 0x0A, 0xC0, 0x55, 0x0A, 0xC0, 0x65, 0x0A, 0xC0, 0x55, 0x0B, 0xC0, 0x55, 0x0C, 0xC0,
  0x35, 0x0E, 0xC0, 0x25, 0xD5, 0x03, 0xC0, 0xC5, 0x06, 0xC0, 0x95, 0x0A, 0xC0, 0x55, 0x0E, 0xC0,
  0x14, 0x03, 0xC0, 0xB5, 0x09, 0xC0, 0x55, 0x0E, 0xB0, 0xE5, 0x06, 0xC0, 0x85, 0x0D, 0xB0, 0xE0,
  0x14, 0x06, 0xC0, 0x64, 0x01, 0x0E, 0xB0, 0xC5, 0x0A, 0xB0, 0xE0, 0x25,
  // "*" (U+002A)
  0x60, 0x4C, 0x04, 0x75, 0x03, 0xC0, 0x37, 0x50, 0x1C, 0x02, 0x76, 0xC7, 0x70, 0xEB, 0x78, 0x33,
  0xEB, 0x73, 0x20, 0xDA, 0x0D, 0x28, 0x43, 0x7B, 0xF4, 0x6C, 0x81, 0xEA, 0xEA, 0x81, 0xEA, 0xEC,
  0x07, 0x0A, 0xFF, 0xA0, 0xA0, 0xDF, 0xFA, 0x85, 0xD1, 0x35, 0x79, 0xBE, 0x84, 0xB9, 0x86, 0x42,
  0x50, 0x7E, 0x07, 0x72, 0x04, 0xB0, 0x0E, 0xB0, 0x47, 0x01, 0x0E, 0xB0, 0x60, 0x7B, 0x0E, 0x02,
  0x60, 0xCB, 0x0D, 0x20, 0xEB, 0x0C, 0x50, 0x8C, 0x05, 0x20, 0x6C, 0x09, 0x40, 0x20, 0xAA, 0x0C,
  0x40, 0xDA, 0x0B, 0x02, 0x68, 0x14, 0xD4, 0x48, 0x15, 0xD5, 0x40,
  // "+" (U+002B)
  0x70, 0x1C, 0x03, 0x77, 0x01, 0xC0, 0x37, 0x70, 0x1C, 0x03, 0x77, 0x01, 0xC0, 0x37, 0x70, 0x1C,
  0x03, 0x77, 0x01, 0xC0, 0x37, 0x70, 0x1C, 0x03, 0x70, 0x28, 0x02, 0x90, 0xAC, 0x0B, 0x80, 0x29,
  0x02, 0x03, 0xFF, 0xC0, 0x03, 0xFF, 0xC0, 0x03, 0xFF, 0xC0, 0x03, 0xFF, 0xC0, 0x37, 0x01, 0xC0,
  0x37, 0x70, 0x1C, 0x03, 0x77, 0x01, 0xC0, 0x37, 0x70, 0x1C, 0x03, 0x77, 0x01, 0xC0, 0x37, 0x70,
  0x1C, 0x03, 0x77, 0x01, 0xC0, 0x37,
  // "," (U+002C)
  0x20, 0x2D, 0x09, 0x20, 0x4D, 0x06, 0x20, 0x7D, 0x02, 0x20, 0x9C, 0x0D, 0x30, 0xCC, 0x09, 0x30,
  0xEC, 0x04, 0x20, 0x2D, 0x30, 0x5C, 0x0B, 0x30, 0x7C, 0x06, 0x30, 0xAC, 0x01, 0x30, 0xDB, 0x0A,
  0x30, 0x1C, 0x03, 0x30,
  // "-" (U+002D)
  0x80, 0x90, 0x98, 0x0D, 0x4F,
  // "." (U+002E)
  0x18, 0x63, 0xBE, 0xEB, 0x20, 0x2D, 0x81, 0xE1, 0x7E, 0x06, 0x09, 0xE0, 0x80, 0x7E, 0x81, 0x61,
  0xEC, 0x87, 0xE1, 0x03, 0xBE, 0xEA, 0x21,
  // "/" (U+002F)
  0x73, 0x03, 0xC0, 0xC7, 0x30, 0x9C, 0x06, 0x73, 0x0E, 0xB0, 0xE7, 0x30, 0x5C, 0x09, 0x73, 0x0B,
  0xC0, 0x37, 0x20, 0x2C, 0x0D, 0x73, 0x08, 0xC0, 0x77, 0x30, 0xEC, 0x01, 0x72, 0x05, 0xC0, 0xA7,
  0x30, 0xBC, 0x04, 0x72, 0x02, 0xC0, 0xD7, 0x30, 0x8C, 0x07, 0x73, 0x0D, 0xC0, 0x17, 0x20, 0x4C,
  0x0B, 0x73, 0x0A, 0xC0, 0x57, 0x20, 0x1C, 0x0E, 0x73, 0x07, 0xC0, 0x87, 0x30, 0xDC, 0x02, 0x72,
  0x04, 0xC0, 0xB7, 0x30, 0xAC, 0x05, 0x72, 0x01, 0xC0, 0xE7, 0x30, 0x7C, 0x09, 0x73, 0x0D, 0xC0,
  0x37, 0x20, 0x3C, 0x0C, 0x73, 0x09, 0xC0, 0x67, 0x30, 0xEB, 0x0E, 0x73, 0x06, 0xC0, 0x97, 0x30,
  0xCC, 0x03, 0x73,
  // "0" (U+0030)
  0x58, 0x90, 0x17, 0xBD, 0xEE, 0xDA, 0x51, 0x72, 0x07, 0xFA, 0x0E, 0x05, 0x70, 0xAF, 0xD0, 0x85,
  0x08, 0xFF, 0x05, 0x30, 0x2E, 0x82, 0xEA, 0xAE, 0xD0, 0xE3, 0x09, 0xD0, 0x94, 0x0B, 0xD0, 0x72,
  0x0E, 0xC0, 0xD5, 0x0B, 0xD8, 0x1D, 0x04, 0xD0, 0x64, 0x06, 0xF0, 0x30, 0x7D, 0x01, 0x30, 0x10,
  0xEF, 0x06, 0x0A, 0xC0, 0xE4, 0x0A, 0xF9, 0x09, 0x0C, 0xC0, 0xC3, 0x05, 0xFA, 0x0B, 0x0D, 0xC0,
  0xA2, 0x01, 0x0E, 0xB0, 0xB0, 0xCC, 0x0D, 0x0E, 0xC0, 0x92, 0x09, 0xC0, 0x20, 0xBC, 0x0E, 0xD8,
  0x19, 0x03, 0xC8, 0x17, 0x0B, 0xFB, 0x81, 0x90, 0xDB, 0x0C, 0x20, 0xBD, 0x0E, 0xC0, 0x90, 0x8C,
  0x02, 0x20, 0xBC, 0x0E, 0x0D, 0xC0, 0xCC, 0x07, 0x30, 0xCC, 0x0D, 0x0C, 0xF9, 0x0C, 0x40, 0xDC,
  0x0C, 0x09, 0xF9, 0x03, 0x4D, 0x0A, 0x07, 0xF0, 0x84, 0x03, 0xD0, 0x70, 0x3E, 0x0D, 0x50, 0x7D,
  0x81, 0x30, 0xDD, 0x04, 0x50, 0xDC, 0x0E, 0x20, 0x8D, 0x09, 0x40, 0x9D, 0x09, 0x20, 0x10, 0xED,
  0x82, 0xEA, 0xAE, 0xE0, 0x23, 0x06, 0xFF, 0x08, 0x50, 0x8F, 0xD0, 0xA7, 0x06, 0x0E, 0xFA, 0x08,
  0x72, 0x89, 0x01, 0x6B, 0xDE, 0xFE, 0xB7, 0x25,
  // "1" (U+0031)
  0x70, 0x20, 0xAC, 0x0D, 0x74, 0x01, 0x09, 0xE0, 0xD7, 0x30, 0x70, 0xEF, 0x0D, 0x71, 0x06, 0x0E,
  0xFA, 0x0D, 0x60, 0x10, 0xDF, 0xC0, 0xD7, 0x0B, 0xFC, 0x0D, 0x70, 0x2D, 0x0C, 0x0D, 0xC0, 0xD7,
  0x10, 0x9A, 0x82, 0xD5, 0x0D, 0xC0, 0xD7, 0x18, 0x11, 0xD7, 0x30, 0xDC, 0x0D, 0x77, 0x0E, 0xC0,
  0xD7, 0x70, 0xEC, 0x0D, 0x77, 0x0E, 0xC0, 0xD7, 0x70, 0xEC, 0x0D, 0x77, 0x0E, 0xC0, 0xD7, 0x70,
  0xEC, 0x0D, 0x77, 0x0E, 0xC0, 0xD7, 0x70, 0xEC, 0x0D, 0x77, 0x0E, 0xC0, 0xD7, 0x70, 0xEC, 0x0D,
  0x77, 0x0E, 0xC0, 0xD7, 0x70, 0xEC, 0x0D, 0x77, 0x0E, 0xC0, 0xD7, 0x70, 0xEC, 0x0D, 0x73, 0x82,
  0x23, 0x57, 0xD8, 0x3E, 0x65, 0x32, 0x40, 0x7F, 0xFA, 0x03, 0x20, 0x7F, 0xFA, 0x03, 0x20, 0x7F,
  0xFA, 0x03, 0x20, 0x7F, 0xFA, 0x03,
  // "2" (U+0032)
  0x58, 0x90, 0x59, 0xCE, 0xEF, 0xEC, 0x94, 0x72, 0x07, 0x0E, 0xFB, 0x0B, 0x02, 0x50, 0x30, 0xDF,
  0xF0, 0x43, 0x06, 0xFF, 0xA0, 0xE0, 0x22, 0x03, 0xF8, 0x2C, 0xAB, 0xEE, 0x0B, 0x30, 0x5C, 0x08,
  0x01, 0x30, 0x10, 0xBE, 0x01, 0x38, 0x28, 0xFD, 0x26, 0x01, 0x0E, 0xD0, 0x54, 0x07, 0x72, 0x0B,
  0xD0, 0x67, 0x70, 0x9D, 0x06, 0x77, 0x0C, 0xD0, 0x47, 0x60, 0x2E, 0x77, 0x09, 0xD0, 0xA7, 0x60,
  0x5E, 0x02, 0x75, 0x03, 0x0E, 0xD0, 0x77, 0x50, 0x20, 0xED, 0x0B, 0x75, 0x02, 0x0D, 0xD0, 0xD0,
  0x17, 0x40, 0x20, 0xDD, 0x0D, 0x01, 0x74, 0x02, 0x0D, 0xD0, 0xD0, 0x17, 0x40, 0x20, 0xDD, 0x0C,
  0x01, 0x74, 0x02, 0x0E, 0xD0, 0xA7, 0x50, 0x20, 0xED, 0x08, 0x75, 0x02, 0x0E, 0xD0, 0x67, 0x50,
  0x20, 0xEC, 0x0E, 0x04, 0x75, 0x03, 0x0E, 0xD0, 0xD8, 0x09, 0x09, 0x02, 0x0B, 0xFF, 0xD0, 0x30,
  0xBF, 0xFD, 0x03, 0x0B, 0xFF, 0xD0, 0x30, 0xBF, 0xFD, 0x03,
  // "3" (U+0033)
  0x48, 0x91, 0x16, 0x9C, 0xEF, 0xED, 0xB7, 0x27, 0x04, 0x0B, 0xFC, 0x0A, 0x01, 0x40, 0xBF, 0xF0,
  0xD0, 0x23, 0x0A, 0xFF, 0x90, 0xD3, 0x01, 0x0E, 0xC8, 0x3E, 0xBA, 0xBE, 0xE0, 0x43, 0x83, 0x5F,
  0xE8, 0x35, 0x0B, 0xD0, 0x74, 0x05, 0x71, 0x02, 0xD0, 0x87, 0x7D, 0x07, 0x76, 0x01, 0xD0, 0x37,
  0x60, 0xAC, 0x0C, 0x74, 0x81, 0x26, 0xCC, 0x0E, 0x02, 0x7F, 0xB0, 0xD0, 0x37, 0x1F, 0x90, 0xC0,
  0x77, 0x3F, 0x98, 0x1C, 0x94, 0x72, 0xFC, 0x0C, 0x02, 0x78, 0x49, 0x9A, 0xAC, 0xEE, 0x0E, 0x02,
  0x75, 0x03, 0x0C, 0xD0, 0xB7, 0x60, 0x10, 0xED, 0x01, 0x76, 0x09, 0xD0, 0x57, 0x60, 0x8D, 0x06,
  0x76, 0x0A, 0xD8, 0x15, 0x02, 0x73, 0x01, 0x0E, 0xD8, 0x43, 0x2F, 0xB6, 0x26, 0x03, 0x0D, 0xD8,
  0x1E, 0x02, 0xC8, 0x4E, 0xCA, 0xAA, 0xDF, 0x81, 0x70, 0x2F, 0xFA, 0x0C, 0x20, 0x2F, 0xF9, 0x0C,
  0x01, 0x20, 0x10, 0xBF, 0xD0, 0xE0, 0x76, 0x89, 0x21, 0x58, 0xBD, 0xEF, 0xED, 0xC8, 0x46,
  // "4" (U+0034)
  0x74, 0x01, 0x0E, 0xC0, 0xB7, 0x71, 0x0A, 0xD0, 0xB7, 0x70, 0x5E, 0x0B, 0x76, 0x01, 0x0E, 0xE0,
  0xB7, 0x60, 0xAF, 0x0B, 0x75, 0x04, 0xF9, 0x0B, 0x75, 0x0D, 0xB0, 0xCC, 0x0B, 0x74, 0x09, 0xB0,
  0xB0, 0x9C, 0x0B, 0x73, 0x04, 0xC0, 0x30, 0xAC, 0x0B, 0x73, 0x0D, 0xB8, 0x19, 0x0A, 0xC0, 0xB7,
  0x20, 0x9B, 0x82, 0xE1, 0x0B, 0xC0, 0xB7, 0x10, 0x3C, 0x06, 0x20, 0xCC, 0x0B, 0x71, 0x0D, 0xB0,
  0xC3, 0x0C, 0xC0, 0xB7, 0x08, 0xC0, 0x33, 0x0C, 0xC0, 0xB6, 0x03, 0xC0, 0x94, 0x0C, 0xC0, 0xB6,
  0x0D, 0xB0, 0xE0, 0x14, 0x0C, 0xC0, 0xB5, 0x08, 0xC0, 0x65, 0x0C, 0xC0, 0xB4, 0x02, 0xD0, 0xA8,
  0x01, 0x90, 0xEC, 0x84, 0xD9, 0x99, 0x46, 0xFF, 0xE0, 0x06, 0xFF, 0xE0, 0x06, 0xFF, 0xE0, 0x06,
  0xFF, 0xE0, 0x67, 0x50, 0xCC, 0x0B, 0x77, 0x20, 0xCC, 0x0B, 0x77, 0x20, 0xCC, 0x0B, 0x77, 0x20,
  0xCC, 0x0B, 0x77, 0x20, 0xCC, 0x0B, 0x77, 0x20, 0xCC, 0x0B, 0x40,
  // "5" (U+0035)
  0x10, 0x6F, 0xF0, 0x62, 0x07, 0xFF, 0x06, 0x20, 0x8F, 0xF0, 0x62, 0x09, 0xFF, 0x06, 0x20, 0xBC,
  0x0E, 0x80, 0x59, 0x04, 0x20, 0xCC, 0x0C, 0x75, 0x0D, 0xC0, 0xA7, 0x50, 0xEC, 0x09, 0x75, 0xD0,
  0x87, 0x40, 0x1D, 0x07, 0x74, 0x03, 0xD8, 0x6D, 0xDE, 0xFD, 0xB7, 0x14, 0x04, 0xFE, 0x08, 0x30,
  0x5F, 0xF0, 0xB2, 0x06, 0xFF, 0x98, 0x28, 0x01, 0x9A, 0x83, 0xEC, 0xAA, 0xCF, 0x90, 0x22, 0x02,
  0x03, 0x50, 0x10, 0xBE, 0x08, 0x74, 0x0C, 0xD0, 0xC7, 0x40, 0x5D, 0x0E, 0x74, 0x02, 0xE7, 0x40,
  0x1D, 0x0E, 0x74, 0x03, 0xD0, 0xC0, 0x17, 0x30, 0x9D, 0x83, 0x9E, 0xA5, 0x16, 0x08, 0xE0, 0x30,
  0xEB, 0x84, 0xEB, 0xAA, 0xBE, 0xE8, 0x1B, 0x0E, 0xFF, 0x82, 0xD1, 0x0E, 0xFE, 0x0D, 0x02, 0x20,
  0xBF, 0xC0, 0xE0, 0x85, 0x83, 0x26, 0xAC, 0xEA, 0x82, 0xEC, 0x95, 0x60,
  // "6" (U+0036)
  0x71, 0x84, 0x15, 0x9C, 0xDE, 0xA0, 0xE0, 0xA7, 0x10, 0x30, 0xBF, 0xA0, 0xC7, 0x0A, 0xFC, 0x0C,
  0x50, 0x10, 0xCF, 0xD0, 0xC5, 0x0B, 0xF8, 0x5E, 0xBA, 0xAA, 0xCB, 0x40, 0x7E, 0x09, 0x03, 0x73,
  0x01, 0xE0, 0x47, 0x50, 0x7D, 0x05, 0x76, 0x0D, 0xC0, 0xC7, 0x60, 0x1D, 0x89, 0x05, 0x02, 0x8C,
  0xEE, 0xDA, 0x44, 0x05, 0xD0, 0x10, 0x6F, 0x90, 0xB0, 0x12, 0x08, 0xC0, 0xD0, 0x5F, 0xB0, 0xC2,
  0x09, 0xC0, 0x0E, 0xFC, 0x81, 0x70, 0xAF, 0x98, 0x1B, 0xAC, 0xE8, 0x1E, 0x0B, 0xE0, 0xC0, 0x23,
  0x05, 0xE0, 0x50, 0xCD, 0x0E, 0x01, 0x50, 0xAD, 0x08, 0x0B, 0xD0, 0x86, 0x04, 0xD0, 0x0A, 0xD0,
  0x46, 0x02, 0xD0, 0xB0, 0x8D, 0x03, 0x60, 0x1D, 0x0B, 0x05, 0xD0, 0x46, 0x01, 0xD0, 0xA0, 0x2D,
  0x07, 0x60, 0x4D, 0x81, 0x80, 0xCC, 0x0D, 0x60, 0xAD, 0x81, 0x50, 0x6D, 0x0B, 0x01, 0x30, 0x6D,
  0x0E, 0x01, 0x20, 0xCD, 0x82, 0xEB, 0xAD, 0xE0, 0x83, 0x03, 0xFF, 0x0D, 0x50, 0x40, 0xEF, 0xC0,
  0xE0, 0x26, 0x02, 0x0B, 0xFA, 0x0B, 0x01, 0x72, 0x87, 0x49, 0xCE, 0xFE, 0xC8, 0x35,
  // "7" (U+0037)
  0x80, 0x99, 0x3F, 0x0E, 0x80, 0x91, 0x90, 0xCD, 0x09, 0x76, 0x0C, 0xD0, 0x27, 0x50, 0x4D, 0x0A,
  0x76, 0x0B, 0xD0, 0x47, 0x50, 0x2D, 0x0C, 0x76, 0x09, 0xD0, 0x57, 0x50, 0x1D, 0x0E, 0x76, 0x08,
  0xD0, 0x77, 0x50, 0x10, 0xED, 0x01, 0x75, 0x07, 0xD0, 0x97, 0x60, 0xED, 0x02, 0x75, 0x06, 0xD0,
  0xB7, 0x60, 0xDD, 0x04, 0x75, 0x04, 0xD0, 0xD7, 0x60, 0xBD, 0x06, 0x75, 0x03, 0xD0, 0xE7, 0x60,
  0xAD, 0x08, 0x75, 0x02, 0xE0, 0x17, 0x50, 0x9D, 0x09, 0x75, 0x01, 0xE0, 0x37, 0x50, 0x8D, 0x0B,
  0x76, 0x0E, 0xD0, 0x47, 0x50, 0x6D, 0x0D, 0x76, 0x0D, 0xD0, 0x67, 0x30,
  // "8" (U+0038)
  0x58, 0x90, 0x27, 0xBD, 0xEE, 0xDB, 0x73, 0x71, 0x01, 0x0A, 0xFB, 0x0A, 0x02, 0x50, 0x20, 0xDF,
  0xD0, 0xE0, 0x34, 0x0D, 0xFF, 0x0D, 0x30, 0x6E, 0x82, 0xEB, 0xBE, 0xE0, 0x62, 0x0A, 0xD0, 0xA4,
  0x0A, 0xD0, 0xA2, 0x0B, 0xD0, 0x14, 0x01, 0xD0, 0xB2, 0x0A, 0xD6, 0xD0, 0xA2, 0x07, 0xD0, 0x24,
  0x02, 0xD0, 0x72, 0x01, 0xD0, 0xB4, 0x0B, 0xD0, 0x23, 0x09, 0xD8, 0x2B, 0x11, 0xBD, 0x08, 0x40,
  0x10, 0xCD, 0x00, 0xED, 0x09, 0x60, 0x10, 0xCF, 0xA0, 0xE0, 0x67, 0x10, 0x10, 0xDF, 0x90, 0x77,
  0x10, 0x40, 0xEF, 0xB0, 0xB0, 0x15, 0x06, 0xE0, 0xEE, 0x0E, 0x03, 0x30, 0x4E, 0x82, 0x70, 0x3C,
  0xD0, 0xE0, 0x22, 0x0D, 0xC0, 0xE0, 0x44, 0x09, 0xD8, 0x1C, 0x04, 0xD0, 0x76, 0x0A, 0xD0, 0x30,
  0x8D, 0x01, 0x60, 0x1D, 0x08, 0x09, 0xD7, 0x1D, 0x00, 0x9D, 0x03, 0x60, 0x3D, 0x08, 0x06, 0xD0,
  0xD0, 0x34, 0x02, 0x0D, 0xD0, 0x60, 0x2F, 0x82, 0xCA, 0xAC, 0xE8, 0x2E, 0x10, 0x9F, 0xFA, 0x06,
  0x30, 0xAF, 0xF0, 0x75, 0x07, 0x0E, 0xFB, 0x0C, 0x04, 0x71, 0x89, 0x05, 0x9C, 0xDF, 0xED, 0xB8,
  0x35,
  // "9" (U+0039)
  0x58, 0x74, 0x9C, 0xEF, 0xEC, 0x94, 0x72, 0x02, 0x0C, 0xFA, 0x0C, 0x03, 0x60, 0x40, 0xEF, 0xC0,
  0xE0, 0x44, 0x02, 0x0E, 0xFF, 0x03, 0x30, 0xBE, 0x82, 0xCA, 0xBE, 0xD0, 0xD2, 0x02, 0xE0, 0x44,
  0x09, 0xD8, 0x16, 0x06, 0xD0, 0x86, 0x0C, 0xC8, 0x1C, 0x0A, 0xD0, 0x36, 0x06, 0xD0, 0x20, 0xBD,
  0x01, 0x60, 0x3D, 0x05, 0x0C, 0xD0, 0x16, 0x03, 0xD0, 0x80, 0xBD, 0x03, 0x60, 0x7D, 0x0A, 0x09,
  0xD0, 0xA5, 0x02, 0x0E, 0xD0, 0xB0, 0x5E, 0x84, 0x82, 0x01, 0x6E, 0xE8, 0x1C, 0x0E, 0xFF, 0xB8,
  0x1B, 0x07, 0xFC, 0x0D, 0x0E, 0xC0, 0xA2, 0x0A, 0xFA, 0x81, 0xE2, 0xEC, 0x09, 0x30, 0x70, 0xEE,
  0x81, 0xC2, 0x1D, 0x07, 0x58, 0x45, 0x89, 0x97, 0x32, 0x05, 0xD0, 0x47, 0x60, 0xAD, 0x01, 0x75,
  0x01, 0xD0, 0xC7, 0x60, 0xAD, 0x06, 0x75, 0x08, 0xD0, 0xE7, 0x40, 0x40, 0xBE, 0x06, 0x48, 0x5C,
  0xCA, 0xAA, 0xBE, 0xF0, 0xB5, 0x0D, 0xFD, 0x0B, 0x01, 0x50, 0xDF, 0xC0, 0x97, 0x0D, 0xFA, 0x0B,
  0x03, 0x71, 0x0B, 0xB8, 0x4E, 0xDC, 0x95, 0x17, 0x10,
  // ":" (U+003A)
  0x18, 0x63, 0xBE, 0xEB, 0x20, 0x2D, 0x81, 0xE1, 0x7E, 0x06, 0x09, 0xE0, 0x80, 0x7E, 0x81, 0x61,
  0xEC, 0x87, 0xE1, 0x03, 0xBE, 0xEA, 0x28, 0x0F, 0x60, 0x86, 0x3B, 0xEE, 0xB2, 0x02, 0xD8, 0x1E,
  0x17, 0xE0, 0x60, 0x9E, 0x08, 0x07, 0xE8, 0x16, 0x1E, 0xC8, 0x7E, 0x10, 0x3B, 0xEE, 0xA2, 0x10,
  // ";" (U+003B)
  0x38, 0x45, 0xCE, 0xEA, 0x23, 0x03, 0xD0, 0xD3, 0x09, 0xE0, 0x52, 0x0B, 0xE0, 0x62, 0x09, 0xE0,
  0x42, 0x03, 0xD0, 0xD4, 0x84, 0x4B, 0xEE, 0xA1, 0x80, 0x9B, 0x10, 0x02, 0xD0, 0x93, 0x04, 0xD0,
  0x63, 0x07, 0xD0, 0x23, 0x09, 0xC0, 0xD4, 0x0C, 0xC0, 0x94, 0x0E, 0xC0, 0x43, 0x02, 0xD4, 0x05,
  0xC0, 0xB4, 0x07, 0xC0, 0x64, 0x0A, 0xC0, 0x14, 0x0D, 0xB0, 0xA4, 0x01, 0xC0, 0x34,
  // "<" (U+003C)
  0x77, 0x30, 0x27, 0x71, 0x81, 0x5D, 0x97, 0x60, 0x40, 0xCA, 0x09, 0x74, 0x04, 0x0C, 0xC0, 0x97,
  0x20, 0x30, 0xCE, 0x09, 0x70, 0x30, 0xBF, 0x0C, 0x03, 0x50, 0x30, 0xAF, 0x0C, 0x04, 0x50, 0x20,
  0xAF, 0x0C, 0x04, 0x50, 0x20, 0x9F, 0x0C, 0x04, 0x60, 0x6F, 0x0B, 0x04, 0x71, 0x09, 0xD0, 0xD0,
  0x47, 0x30, 0x9E, 0x0B, 0x04, 0x72, 0x03, 0x0B, 0xF0, 0xC0, 0x57, 0x20, 0x30, 0xBF, 0x0D, 0x06,
  0x72, 0x03, 0x0B, 0xF8, 0x1E, 0x71, 0x71, 0x03, 0x0A, 0xF8, 0x1E, 0x91, 0x71, 0x02, 0x0A, 0xF0,
  0x97, 0x30, 0x20, 0x9D, 0x09, 0x75, 0x02, 0x09, 0xB0, 0x97, 0x78, 0x21, 0x8F, 0x97, 0x72, 0x01,
  0x04,
  // "=" (U+003D)
  0x03, 0xFF, 0xC0, 0x03, 0xFF, 0xC0, 0x03, 0xFF, 0xC0, 0x03, 0xFF, 0xC0, 0x30, 0x28, 0x09, 0x69,
  0x02, 0x80, 0xF0, 0x00, 0x28, 0x09, 0x69, 0x02, 0x03, 0xFF, 0xC0, 0x03, 0xFF, 0xC0, 0x03, 0xFF,
  0xC0, 0x03, 0xFF, 0xC0, 0x30,
  // ">" (U+003E)
  0x02, 0x77, 0x38, 0x19, 0xD5, 0x77, 0x10, 0x9A, 0x0C, 0x05, 0x76, 0x09, 0xC0, 0xC0, 0x47, 0x40,
  0x9E, 0x0B, 0x04, 0x72, 0x03, 0x0C, 0xF0, 0xB0, 0x37, 0x20, 0x40, 0xCF, 0x0B, 0x03, 0x72, 0x04,
  0x0C, 0xF0, 0xA0, 0x27, 0x20, 0x40, 0xCF, 0x09, 0x02, 0x72, 0x04, 0x0B, 0xF0, 0x67, 0x30, 0x40,
  0xDD, 0x09, 0x72, 0x04, 0x0B, 0xE0, 0x97, 0x05, 0x0C, 0xF0, 0xB0, 0x35, 0x06, 0x0D, 0xF0, 0xB0,
  0x34, 0x81, 0x17, 0xEF, 0x0B, 0x03, 0x48, 0x11, 0x9E, 0xF0, 0xA0, 0x36, 0x09, 0xF0, 0xA0, 0x27,
  0x10, 0x9D, 0x09, 0x02, 0x73, 0x09, 0xB0, 0x90, 0x27, 0x58, 0x29, 0xF9, 0x17, 0x70, 0x40, 0x17,
  0x72,
  // "?" (U+003F)
  0x48, 0x90, 0x58, 0xBD, 0xEF, 0xDC, 0x83, 0x50, 0x30, 0xAF, 0xC0, 0xB0, 0x22, 0x08, 0xFF, 0x82,
  0xE3, 0x03, 0xFF, 0x90, 0xE2, 0x0B, 0xC8, 0x3E, 0xBA, 0xBE, 0xE8, 0x56, 0x03, 0xFE, 0x93, 0x50,
  0x8D, 0x0A, 0x20, 0x47, 0x20, 0xEC, 0x0C, 0x75, 0x0E, 0xC0, 0xB7, 0x40, 0x3D, 0x09, 0x73, 0x01,
  0x0C, 0xD0, 0x47, 0x20, 0x20, 0xDD, 0x0A, 0x72, 0x06, 0xE0, 0xB7, 0x20, 0x9E, 0x09, 0x72, 0x09,
  0xD0, 0xE0, 0x57, 0x20, 0x2D, 0x0C, 0x02, 0x73, 0x08, 0xC0, 0xE0, 0x17, 0x40, 0xAC, 0x08, 0x75,
  0x0B, 0xC0, 0x67, 0x58, 0x43, 0x55, 0x55, 0x28, 0x0D, 0x40, 0x84, 0x4C, 0xEE, 0xA2, 0x74, 0x03,
  0xD0, 0xD7, 0x40, 0x8E, 0x05, 0x73, 0x0A, 0xE0, 0x77, 0x30, 0x8E, 0x05, 0x73, 0x02, 0xD0, 0xD7,
  0x58, 0x43, 0xBE, 0xEA, 0x17,
  // "@" (U+0040)
  0x71, 0x82, 0x27, 0xBD, 0xA8, 0x1D, 0xA6, 0x76, 0x02, 0x0A, 0xFA, 0x0E, 0x06, 0x73, 0x05, 0x0E,
  0xFD, 0x0A, 0x71, 0x06, 0xC8, 0x1C, 0x62, 0x28, 0x13, 0x8E, 0xB0, 0xA6, 0x04, 0xC0, 0x77, 0x02,
  0x0D, 0xB0, 0x64, 0x01, 0x0E, 0xB0, 0x57, 0x20, 0x10, 0xEA, 0x0E, 0x01, 0x30, 0x9B, 0x08, 0x74,
  0x05, 0xB0, 0x82, 0x02, 0xB0, 0xD3, 0x86, 0x19, 0xDF, 0xEC, 0x83, 0x20, 0xDA, 0x0E, 0x20, 0x8B,
  0x06, 0x20, 0x20, 0xEF, 0x81, 0xB0, 0x8B, 0x81, 0x40, 0xDB, 0x20, 0x10, 0xEF, 0x98, 0x1C, 0x04,
  0xB0, 0x80, 0x3B, 0x0A, 0x20, 0x9F, 0xA8, 0x1B, 0x01, 0xB0, 0xB0, 0x6B, 0x81, 0x60, 0x1C, 0x81,
  0x71, 0x4B, 0x0A, 0x2B, 0x0D, 0x09, 0xB8, 0x13, 0x05, 0xB0, 0xA2, 0x03, 0xB0, 0x92, 0x0E, 0xA0,
  0xE0, 0xCB, 0x81, 0x10, 0x9B, 0x04, 0x20, 0x4B, 0x08, 0x20, 0xDB, 0x0D, 0xB2, 0x0B, 0xB0, 0x12,
  0x05, 0xB0, 0x82, 0x0E, 0xA0, 0x0E, 0xA0, 0xE2, 0x0C, 0xB3, 0x06, 0xB0, 0x72, 0xB0, 0xDB, 0x0E,
  0x20, 0xCA, 0x0E, 0x30, 0x8B, 0x81, 0x60, 0x1B, 0x0C, 0xC2, 0x0C, 0xB3, 0x0A, 0xB8, 0x16, 0x03,
  0xB0, 0x90, 0xEB, 0x20, 0xAB, 0x02, 0x20, 0xEB, 0x81, 0x60, 0x7B, 0x06, 0x0C, 0xB8, 0x12, 0x07,
  0xB8, 0x1A, 0x17, 0xC8, 0x1B, 0x1D, 0xB0, 0x10, 0xAB, 0x81, 0x50, 0x2F, 0xF9, 0x81, 0xA0, 0x6B,
  0x08, 0x20, 0xBE, 0x0C, 0xF8, 0x12, 0x02, 0xB0, 0xD2, 0x01, 0x0E, 0xC8, 0x1D, 0x18, 0xD0, 0x63,
  0x0C, 0xB0, 0x42, 0x84, 0x2A, 0xEE, 0xA1, 0x28, 0x38, 0xDF, 0xC4, 0x40, 0x5B, 0x0D, 0x77, 0x60,
  0xCB, 0x0A, 0x77, 0x50, 0x20, 0xEB, 0x0A, 0x01, 0x73, 0x03, 0x70, 0x4C, 0x82, 0xE8, 0x31, 0x28,
  0x41, 0x36, 0xAE, 0xD7, 0x10, 0x30, 0xDF, 0xE0, 0xD7, 0x20, 0x10, 0x8F, 0xD0, 0x97, 0x48, 0x31,
  0x5A, 0xCE, 0xA8, 0x3E, 0xC9, 0x61, 0x50,
  // "A" (U+0041)
  0x71, 0x0D, 0xE0, 0xC7, 0x71, 0x02, 0xF9, 0x01, 0x77, 0x06, 0xF9, 0x06, 0x77, 0x0B, 0xF9, 0x0A,
  0x77, 0x0E, 0xF9, 0x0E, 0x76, 0x04, 0xC0, 0x0B, 0xC0, 0x37, 0x50, 0x8C, 0x00, 0x8C, 0x08, 0x75,
  0x0C, 0xC0, 0x04, 0xC0, 0xC7, 0x40, 0x1D, 0x2D, 0x01, 0x73, 0x06, 0xC0, 0xC2, 0x0C, 0xC0, 0x57,
  0x30, 0xAC, 0x08, 0x20, 0x8C, 0x0A, 0x73, 0x0E, 0xC0, 0x42, 0x04, 0xC0, 0xE7, 0x20, 0x3D, 0x4D,
  0x03, 0x71, 0x08, 0xC0, 0xB4, 0x0C, 0xC0, 0x77, 0x10, 0xCC, 0x07, 0x40, 0x8C, 0x0C, 0x70, 0x1D,
  0x03, 0x40, 0x4D, 0x01, 0x60, 0x5D, 0x84, 0xA9, 0x99, 0x9A, 0xD0, 0x56, 0x0A, 0xFF, 0xA0, 0x96,
  0x0E, 0xFF, 0xA0, 0xE5, 0x03, 0xFF, 0xC0, 0x34, 0x07, 0xFF, 0xC0, 0x74, 0x0B, 0xC0, 0xA7, 0x10,
  0xCC, 0x0B, 0x30, 0x1D, 0x06, 0x71, 0x08, 0xD3, 0x05, 0xD0, 0x27, 0x10, 0x4D, 0x05, 0x20, 0x9C,
  0x0E, 0x72, 0x01, 0xD0, 0x92, 0x0D, 0xC0, 0xA7, 0x30, 0xCC, 0x81, 0xD0, 0x2D, 0x06, 0x73, 0x08,
  0xD0, 0x20, 0x7D, 0x02, 0x73, 0x05, 0xD0, 0x70,
  // "B" (U+0042)
  0x0C, 0xFA, 0x83, 0xED, 0xB8, 0x35, 0x0C, 0xFF, 0x0C, 0x03, 0x30, 0xCF, 0xFA, 0x04, 0x20, 0xCF,
  0xFA, 0x82, 0xE1, 0x0C, 0xC8, 0x4D, 0x99, 0x9A, 0xCF, 0x81, 0x60, 0xCC, 0x09, 0x50, 0x20, 0xDD,
  0x81, 0xA0, 0xCC, 0x09, 0x60, 0x5D, 0x81, 0xB0, 0xCC, 0x09, 0x60, 0x2D, 0x81, 0xB0, 0xCC, 0x09,
  0x60, 0x2D, 0x81, 0x90, 0xCC, 0x09, 0x60, 0x7D, 0x81, 0x50, 0xCC, 0x09, 0x40, 0x10, 0x6D, 0x0D,
  0x20, 0xCF, 0xF9, 0x0E, 0x03, 0x20, 0xCF, 0xF0, 0xB0, 0x23, 0x0C, 0xFE, 0x0D, 0x06, 0x40, 0xCF,
  0xF9, 0x0E, 0x04, 0x20, 0xCC, 0x85, 0xD9, 0x99, 0xAB, 0xEE, 0x81, 0x30, 0xCC, 0x09, 0x60, 0xAD,
  0x81, 0xC0, 0xCC, 0x09, 0x60, 0x10, 0xED, 0x02, 0x0C, 0xC0, 0x97, 0x0B, 0xD0, 0x40, 0xCC, 0x09,
  0x70, 0xAD, 0x05, 0x0C, 0xC0, 0x97, 0x0C, 0xD0, 0x50, 0xCC, 0x09, 0x60, 0x1E, 0x03, 0x0C, 0xC0,
  0x96, 0x0A, 0xD8, 0x1E, 0x0C, 0xC8, 0x5D, 0x99, 0x9A, 0xBE, 0xE8, 0x19, 0x0C, 0xFF, 0xA8, 0x2E,
  0x10, 0xCF, 0xF9, 0x0E, 0x03, 0x20, 0xCF, 0xF0, 0xC0, 0x23, 0x0C, 0xFB, 0x82, 0xEC, 0x83, 0x50,
  // "C" (U+0043)
  0x71, 0x89, 0x13, 0x8B, 0xDE, 0xFE, 0xDB, 0x73, 0x71, 0x06, 0x0D, 0xFC, 0x0D, 0x02, 0x40, 0x20,
  0xCF, 0xE0, 0xE4, 0x03, 0x0E, 0xFF, 0x08, 0x30, 0x10, 0xEF, 0x83, 0xCA, 0xAB, 0xDB, 0x01, 0x30,
  0xBE, 0x08, 0x01, 0x58, 0x12, 0x89, 0x30, 0x4E, 0x04, 0x76, 0x0B, 0xD0, 0x67, 0x60, 0x2D, 0x0E,
  0x77, 0x06, 0xD0, 0x87, 0x70, 0x9D, 0x04, 0x77, 0x0C, 0xD0, 0x17, 0x70, 0xED, 0x77, 0x10, 0xEC,
  0x0E, 0x77, 0x1D, 0x0D, 0x77, 0x1D, 0x0E, 0x77, 0x10, 0xED, 0x77, 0x10, 0xCD, 0x02, 0x77, 0x09,
  0xD0, 0x57, 0x70, 0x6D, 0x0A, 0x77, 0x01, 0xE0, 0x27, 0x70, 0xBD, 0x0C, 0x01, 0x76, 0x04, 0xE0,
  0xD0, 0x56, 0x82, 0x27, 0xD4, 0x30, 0xAF, 0x84, 0xEB, 0xAA, 0xBE, 0xB0, 0x43, 0x01, 0x0C, 0xFF,
  0x90, 0x44, 0x01, 0x0C, 0xFF, 0x04, 0x60, 0x70, 0xEF, 0xC0, 0xE0, 0x37, 0x18, 0x25, 0x9C, 0xEA,
  0x83, 0xED, 0xA7, 0x33,
  // "D" (U+0044)
  0x03, 0xFA, 0x83, 0xED, 0xB6, 0x27, 0x03, 0xFF, 0x0A, 0x02, 0x50, 0x3F, 0xFA, 0x05, 0x40, 0x3F,
  0xFB, 0x07, 0x30, 0x3D, 0x84, 0xC9, 0x9A, 0xBE, 0xF0, 0x42, 0x03, 0xD0, 0x85, 0x05, 0x0E, 0xD0,
  0xE2, 0x03, 0xD0, 0x86, 0x02, 0x0E, 0xD8, 0x16, 0x03, 0xD0, 0x87, 0x05, 0xD8, 0x1D, 0x03, 0xD0,
  0x87, 0x10, 0xDD, 0x02, 0x03, 0xD0, 0x87, 0x10, 0x8D, 0x05, 0x03, 0xD0, 0x87, 0x10, 0x5D, 0x08,
  0x03, 0xD0, 0x87, 0x10, 0x3D, 0x0A, 0x03, 0xD0, 0x87, 0x10, 0x2D, 0x0B, 0x03, 0xD0, 0x87, 0x10,
  0x1D, 0x0C, 0x03, 0xD0, 0x87, 0x10, 0x1D, 0x0B, 0x03, 0xD0, 0x87, 0x10, 0x2D, 0x0A, 0x03, 0xD0,
  0x87, 0x10, 0x4D, 0x09, 0x03, 0xD0, 0x87, 0x10, 0x6D, 0x07, 0x03, 0xD0, 0x87, 0x10, 0xAD, 0x00,
  0x3D, 0x08, 0x71, 0x0E, 0xD1, 0x03, 0xD0, 0x87, 0x07, 0xD8, 0x1A, 0x03, 0xD0, 0x86, 0x04, 0xE8,
  0x13, 0x03, 0xD0, 0x84, 0x01, 0x07, 0xE0, 0xB2, 0x03, 0xD8, 0x3C, 0x99, 0xAC, 0xF0, 0xE0, 0x12,
  0x03, 0xFF, 0xA0, 0xE0, 0x33, 0x03, 0xFF, 0x90, 0xD0, 0x24, 0x03, 0xFE, 0x0E, 0x07, 0x60, 0x3F,
  0xA8, 0x3D, 0xC9, 0x51, 0x70,
  // "E" (U+0045)
  0x0C, 0xFF, 0xB0, 0x30, 0xCF, 0xFB, 0x03, 0x0C, 0xFF, 0xB0, 0x30, 0xCF, 0xFB, 0x03, 0x0C, 0xC0,
  0xE8, 0x09, 0x09, 0x02, 0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0C, 0x76, 0x0C, 0xC0, 0xC7, 0x60, 0xCC,
  0x0C, 0x76, 0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0C, 0x76, 0x0C, 0xFF, 0xA8, 0x19, 0x0C, 0xFF, 0xA8,
  0x19, 0x0C, 0xFF, 0xA8, 0x19, 0x0C, 0xFF, 0xA8, 0x19, 0x0C, 0xC0, 0xE8, 0x07, 0x98, 0x15, 0x0C,
  0xC0, 0xC7, 0x60, 0xCC, 0x0C, 0x76, 0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0C, 0x76, 0x0C, 0xC0, 0xC7,
  0x60, 0xCC, 0x0C, 0x76, 0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0E, 0x80, 0x90, 0x90, 0x20, 0xCF, 0xFB,
  0x03, 0x0C, 0xFF, 0xB0, 0x30, 0xCF, 0xFB, 0x03, 0x0C, 0xFF, 0xB0, 0x30,
  // "F" (U+0046)
  0x0C, 0xFF, 0xB0, 0x30, 0xCF, 0xFB, 0x03, 0x0C, 0xFF, 0xB0, 0x30, 0xCF, 0xFB, 0x03, 0x0C, 0xC0,
  0xE8, 0x09, 0x09, 0x02, 0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0C, 0x76, 0x0C, 0xC0, 0xC7, 0x60, 0xCC,
  0x0C, 0x76, 0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0C, 0x76, 0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0E, 0x80,
  0x79, 0x81, 0x50, 0xCF, 0xFA, 0x81, 0x90, 0xCF, 0xFA, 0x81, 0x90, 0xCF, 0xFA, 0x81, 0x90, 0xCF,
  0xFA, 0x81, 0x90, 0xCC, 0x0C, 0x76, 0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0C, 0x76, 0x0C, 0xC0, 0xC7,
  0x60, 0xCC, 0x0C, 0x76, 0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0C, 0x76, 0x0C, 0xC0, 0xC7, 0x60, 0xCC,
  0x0C, 0x76, 0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0C, 0x76,
  // "G" (U+0047)
  0x71, 0x89, 0x14, 0x8C, 0xDE, 0xFE, 0xDA, 0x73, 0x72, 0x07, 0x0E, 0xFC, 0x0D, 0x07, 0x50, 0x20,
  0xDF, 0xF0, 0x94, 0x03, 0x0E, 0xFF, 0x90, 0x33, 0x01, 0x0D, 0xF8, 0x4E, 0xBA, 0xAC, 0xEA, 0x0C,
  0x40, 0xAE, 0x0B, 0x03, 0x68, 0x14, 0xA5, 0x30, 0x2E, 0x08, 0x77, 0x09, 0xD0, 0xA7, 0x71, 0x0E,
  0xD0, 0x27, 0x70, 0x3D, 0x0B, 0x77, 0x10, 0x7D, 0x06, 0x77, 0x10, 0x9D, 0x03, 0x77, 0x10, 0xAD,
  0x01, 0x5F, 0xA0, 0x30, 0xBD, 0x6F, 0xA0, 0x30, 0xCD, 0x6F, 0xA0, 0x30, 0xBD, 0x01, 0x5F, 0xA0,
  0x30, 0xAD, 0x02, 0x50, 0xF9, 0x0A, 0xD0, 0x30, 0x8D, 0x05, 0x72, 0xD0, 0x30, 0x5D, 0x09, 0x72,
  0xD0, 0x30, 0x1D, 0x0E, 0x72, 0xD8, 0x13, 0x0C, 0xD0, 0x77, 0x1D, 0x81, 0x30, 0x6E, 0x03, 0x7D,
  0x03, 0x20, 0xDE, 0x07, 0x6D, 0x03, 0x20, 0x4F, 0x98, 0x3C, 0xAA, 0xCE, 0xD0, 0x33, 0x07, 0xFF,
  0xB0, 0x34, 0x06, 0xFF, 0xA0, 0x35, 0x02, 0x0B, 0xFE, 0x0B, 0x01, 0x78, 0x32, 0x6A, 0xCE, 0xA8,
  0x4E, 0xDB, 0x95, 0x12,
  // "H" (U+0048)
  0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D,
  0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09,
  0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10,
  0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3F, 0xFE, 0x00,
  0x3F, 0xFE, 0x00, 0x3F, 0xFE, 0x00, 0x3F, 0xFE, 0x00, 0x3D, 0x0D, 0x80, 0x49, 0x0D, 0xD0, 0x03,
  0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00,
  0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0,
  0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D,
  0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09,
  0xD0, 0x30,
  // "I" (U+0049)
  0x06, 0xFF, 0xA0, 0x06, 0xFF, 0xA0, 0x06, 0xFF, 0xA0, 0x06, 0xFF, 0xA8, 0x66, 0x02, 0x46, 0x79,
  0xEC, 0x84, 0xE9, 0x76, 0x42, 0x70, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75,
  0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0,
  0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50,
  0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B,
  0x75, 0x0D, 0xC0, 0xB7, 0x18, 0x31, 0x35, 0x6E, 0xC8, 0x3D, 0x65, 0x31, 0x20, 0x5F, 0xFA, 0x05,
  0x06, 0xFF, 0xA0, 0x06, 0xFF, 0xA0, 0x06, 0xFF, 0xA0, 0x60,
  // "J" (U+004A)
  0x73, 0x01, 0xD0, 0x97, 0x30, 0x1D, 0x09, 0x73, 0x01, 0xD0, 0x97, 0x30, 0x1D, 0x09, 0x73, 0x01,
  0xD0, 0x97, 0x30, 0x1D, 0x09, 0x73, 0x01, 0xD0, 0x97, 0x30, 0x1D, 0x09, 0x73, 0x01, 0xD0, 0x97,
  0x30, 0x1D, 0x09, 0x73, 0x01, 0xD0, 0x97, 0x30, 0x1D, 0x09, 0x73, 0x01, 0xD0, 0x97, 0x30, 0x1D,
  0x09, 0x73, 0x01, 0xD0, 0x97, 0x30, 0x1D, 0x09, 0x73, 0x01, 0xD0, 0x97, 0x30, 0x1D, 0x09, 0x73,
  0x01, 0xD0, 0x87, 0x30, 0x2D, 0x07, 0x73, 0x05, 0xD0, 0x67, 0x30, 0xBD, 0x81, 0x23, 0x26, 0x01,
  0x09, 0xD8, 0x1E, 0x09, 0xA8, 0x4D, 0xBA, 0xAB, 0xEE, 0x81, 0x70, 0x9F, 0xE0, 0xD2, 0x09, 0xFD,
  0x0E, 0x03, 0x20, 0x9F, 0xC0, 0xB0, 0x13, 0x89, 0x22, 0x7A, 0xCD, 0xEF, 0xED, 0xB7, 0x25,
  // "K" (U+004B)
  0x03, 0xD0, 0x77, 0x01, 0x0E, 0xD0, 0x40, 0x3D, 0x07, 0x70, 0xBD, 0x81, 0x80, 0x3D, 0x07, 0x60,
  0x6D, 0x0C, 0x20, 0x3D, 0x07, 0x50, 0x10, 0xED, 0x02, 0x20, 0x3D, 0x07, 0x50, 0xBD, 0x06, 0x30,
  0x3D, 0x07, 0x40, 0x6D, 0x0B, 0x40, 0x3D, 0x07, 0x30, 0x20, 0xEC, 0x0E, 0x01, 0x40, 0x3D, 0x07,
  0x30, 0xBD, 0x04, 0x50, 0x3D, 0x07, 0x20, 0x7D, 0x08, 0x60, 0x3D, 0x81, 0x70, 0x2D, 0x0C, 0x70,
  0x3D, 0x81, 0x70, 0xBD, 0x02, 0x70, 0x3D, 0x07, 0x05, 0xD0, 0x67, 0x10, 0x3D, 0x08, 0x0D, 0xC0,
  0xC7, 0x20, 0x3D, 0x0E, 0xE0, 0x27, 0x10, 0x3F, 0xD0, 0xB7, 0x10, 0x3F, 0xE0, 0x47, 0x03, 0xF0,
  0xED, 0x0D, 0x70, 0x3E, 0x81, 0xC1, 0xAD, 0x06, 0x60, 0x3D, 0x82, 0xC1, 0x02, 0xD0, 0xE0, 0x15,
  0x03, 0xD0, 0x73, 0x09, 0xD0, 0x85, 0x03, 0xD0, 0x73, 0x01, 0x0E, 0xD0, 0x24, 0x03, 0xD0, 0x74,
  0x07, 0xD0, 0xA4, 0x03, 0xD0, 0x75, 0x0E, 0xD0, 0x43, 0x03, 0xD0, 0x75, 0x06, 0xD0, 0xC3, 0x03,
  0xD0, 0x76, 0x0D, 0xD0, 0x62, 0x03, 0xD0, 0x76, 0x04, 0xD0, 0xE2, 0x03, 0xD0, 0x77, 0x0B, 0xD8,
  0x18, 0x03, 0xD0, 0x77, 0x03, 0xE0, 0x20,
  // "L" (U+004C)
  0x06, 0xD0, 0x67, 0x50, 0x6D, 0x06, 0x75, 0x06, 0xD0, 0x67, 0x50, 0x6D, 0x06, 0x75, 0x06, 0xD0,
  0x67, 0x50, 0x6D, 0x06, 0x75, 0x06, 0xD0, 0x67, 0x50, 0x6D, 0x06, 0x75, 0x06, 0xD0, 0x67, 0x50,
  0x6D, 0x06, 0x75, 0x06, 0xD0, 0x67, 0x50, 0x6D, 0x06, 0x75, 0x06, 0xD0, 0x67, 0x50, 0x6D, 0x06,
  0x75, 0x06, 0xD0, 0x67, 0x50, 0x6D, 0x06, 0x75, 0x06, 0xD0, 0x67, 0x50, 0x6D, 0x06, 0x75, 0x06,
  0xD0, 0x67, 0x50, 0x6D, 0x06, 0x75, 0x06, 0xD0, 0x67, 0x50, 0x6D, 0x06, 0x75, 0x06, 0xD0, 0x67,
  0x50, 0x6D, 0x0C, 0x80, 0x79, 0x02, 0x06, 0xFF, 0xB0, 0x30, 0x6F, 0xFB, 0x03, 0x06, 0xFF, 0xB0,
  0x30, 0x6F, 0xFB, 0x03,
  // "M" (U+004D)
  0x06, 0xF0, 0x74, 0x02, 0xF0, 0x50, 0x6F, 0x0A, 0x40, 0x5F, 0x05, 0x06, 0xF0, 0xC4, 0x08, 0xF0,
  0x50, 0x6F, 0x0E, 0x40, 0xAF, 0x05, 0x06, 0xF9, 0x01, 0x30, 0xDF, 0x05, 0x06, 0xB0, 0xD0, 0xEB,
  0x04, 0x3B, 0x0D, 0xC0, 0x50, 0x6B, 0x0D, 0x0B, 0xB0, 0x62, 0x03, 0xB0, 0xAC, 0x05, 0x06, 0xC0,
  0x8B, 0x08, 0x20, 0x6B, 0x08, 0xC0, 0x50, 0x6C, 0x06, 0xB0, 0xA2, 0x08, 0xB0, 0x6C, 0x05, 0x06,
  0xC0, 0x4B, 0x0D, 0x20, 0xBB, 0x04, 0xC0, 0x50, 0x6C, 0x03, 0x0E, 0xB2, 0x0E, 0xA0, 0xD0, 0x5C,
  0x05, 0x06, 0xC0, 0x40, 0xCB, 0x02, 0x01, 0xB0, 0xA0, 0x5C, 0x05, 0x06, 0xC0, 0x50, 0x9B, 0x00,
  0x4B, 0x08, 0x06, 0xC0, 0x50, 0x6C, 0x00, 0x6B, 0x00, 0x7B, 0x05, 0x07, 0xC0, 0x50, 0x6C, 0x07,
  0x03, 0xB0, 0x09, 0xB0, 0x20, 0x8C, 0x05, 0x06, 0xC0, 0x81, 0xB0, 0xB0, 0xCB, 0x10, 0x9C, 0x05,
  0x06, 0xC8, 0x19, 0x0D, 0xA0, 0xEB, 0x81, 0xC0, 0xAC, 0x05, 0x06, 0xC8, 0x1A, 0x0A, 0xE8, 0x19,
  0x0B, 0xC0, 0x50, 0x6C, 0x81, 0xB0, 0x7E, 0x81, 0x70, 0xBC, 0x05, 0x06, 0xC8, 0x1B, 0x04, 0xE8,
  0x14, 0x0C, 0xC0, 0x50, 0x6C, 0x81, 0xC0, 0x1E, 0x81, 0x10, 0xCC, 0x05, 0x06, 0xC0, 0xC2, 0x0D,
  0xC0, 0xE2, 0x0D, 0xC0, 0x50, 0x6C, 0x0C, 0x73, 0x0D, 0xC0, 0x50, 0x6C, 0x0C, 0x73, 0x0D, 0xC0,
  0x50, 0x6C, 0x0C, 0x73, 0x0D, 0xC0, 0x50, 0x6C, 0x0C, 0x73, 0x0D, 0xC0, 0x50, 0x6C, 0x0C, 0x73,
  0x0D, 0xC0, 0x50, 0x6C, 0x0C, 0x73, 0x0D, 0xC0, 0x50,
  // "N" (U+004E)
  0x03, 0xF0, 0xD7, 0x0E, 0xC0, 0x03, 0xF9, 0x02, 0x60, 0xEC, 0x00, 0x3F, 0x90, 0x86, 0x0E, 0xC0,
  0x03, 0xF9, 0x0D, 0x60, 0xEC, 0x00, 0x3F, 0xA0, 0x25, 0x0E, 0xC0, 0x03, 0xC0, 0xDC, 0x08, 0x50,
  0xEC, 0x00, 0x3C, 0x0A, 0x0E, 0xB0, 0xD5, 0x0E, 0xC0, 0x03, 0xC0, 0xA0, 0x9C, 0x02, 0x40, 0xEC,
  0x00, 0x3C, 0x0B, 0x03, 0xC0, 0x74, 0x0E, 0xC0, 0x03, 0xC8, 0x1C, 0x0E, 0xB0, 0xD4, 0x0E, 0xC0,
  0x03, 0xC8, 0x1D, 0x09, 0xC0, 0x23, 0x0E, 0xC0, 0x03, 0xC8, 0x1D, 0x03, 0xC0, 0x73, 0x0E, 0xC0,
  0x03, 0xC0, 0xE2, 0x0E, 0xB0, 0xD3, 0x0E, 0xC0, 0x03, 0xC0, 0xE2, 0x09, 0xC0, 0x22, 0x0E, 0xC0,
  0x03, 0xC0, 0xE2, 0x03, 0xC0, 0x72, 0x0E, 0xC0, 0x03, 0xC0, 0xE3, 0x0E, 0xB0, 0xD2, 0x0E, 0xC0,
  0x03, 0xC0, 0xE3, 0x09, 0xC8, 0x12, 0x0E, 0xC0, 0x03, 0xC0, 0xE3, 0x04, 0xC8, 0x17, 0x0E, 0xC0,
  0x03, 0xC0, 0xE4, 0x0E, 0xB8, 0x1D, 0x0D, 0xC0, 0x03, 0xC0, 0xE4, 0x09, 0xC0, 0x20, 0xDC, 0x00,
  0x3C, 0x0E, 0x40, 0x4C, 0x07, 0x0C, 0xC0, 0x03, 0xC0, 0xE5, 0x0E, 0xB0, 0xD0, 0xBC, 0x00, 0x3C,
  0x0E, 0x50, 0x9C, 0x0D, 0xC0, 0x03, 0xC0, 0xE5, 0x04, 0xFA, 0x00, 0x3C, 0x0E, 0x60, 0xEF, 0x90,
  0x03, 0xC0, 0xE6, 0x09, 0xF9, 0x00, 0x3C, 0x0E, 0x60, 0x4F, 0x90, 0x03, 0xC0, 0xE7, 0x0E, 0xF0,
  0x30,
  // "O" (U+004F)
  0x68, 0x90, 0x27, 0xBD, 0xEE, 0xDB, 0x72, 0x73, 0x01, 0x0A, 0xFB, 0x0A, 0x01, 0x70, 0x20, 0xEF,
  0xD0, 0xE0, 0x25, 0x01, 0x0D, 0xFF, 0x0D, 0x01, 0x40, 0xAE, 0x82, 0xEB, 0xAE, 0xE0, 0x93, 0x03,
  0xE0, 0x74, 0x07, 0xE0, 0x22, 0x09, 0xD0, 0x86, 0x09, 0xD0, 0x92, 0x0E, 0xD0, 0x16, 0x01, 0xD8,
  0x1E, 0x03, 0xD0, 0xA7, 0x10, 0xBD, 0x03, 0x06, 0xD0, 0x77, 0x10, 0x7D, 0x05, 0x08, 0xD0, 0x47,
  0x10, 0x4D, 0x08, 0x0A, 0xD0, 0x27, 0x10, 0x3D, 0x0A, 0x0B, 0xD0, 0x17, 0x10, 0x2D, 0x00, 0xBD,
  0x01, 0x71, 0x01, 0xD0, 0xB0, 0xCD, 0x01, 0x71, 0x01, 0xD0, 0x0B, 0xD0, 0x17, 0x10, 0x2D, 0x0B,
  0x0A, 0xD0, 0x27, 0x10, 0x3D, 0x0A, 0x08, 0xD0, 0x47, 0x10, 0x4D, 0x08, 0x06, 0xD0, 0x77, 0x10,
  0x7D, 0x05, 0x03, 0xD0, 0xA7, 0x10, 0xBD, 0x81, 0x30, 0xED, 0x01, 0x60, 0x1D, 0x0E, 0x20, 0x9D,
  0x08, 0x60, 0x8D, 0x09, 0x20, 0x3E, 0x07, 0x40, 0x7E, 0x03, 0x30, 0xAE, 0x82, 0xDA, 0xAD, 0xE0,
  0x94, 0x01, 0x0D, 0xFF, 0x0D, 0x01, 0x50, 0x20, 0xEF, 0xD0, 0xE0, 0x27, 0x01, 0x0A, 0xFB, 0x0A,
  0x01, 0x73, 0x89, 0x02, 0x7B, 0xDE, 0xED, 0xB7, 0x26,
  // "P" (U+0050)
  0x0C, 0xFA, 0x83, 0xED, 0xB8, 0x35, 0x0C, 0xFF, 0x0C, 0x02, 0x30, 0xCF, 0xF9, 0x0E, 0x03, 0x20,
  0xCF, 0xFA, 0x82, 0xE1, 0x0C, 0xC8, 0x5E, 0x99, 0x9A, 0xBE, 0xE8, 0x18, 0x0C, 0xC0, 0xC6, 0x09,
  0xD8, 0x1E, 0x0C, 0xC0, 0xC7, 0x0D, 0xD0, 0x20, 0xCC, 0x0C, 0x70, 0x7D, 0x04, 0x0C, 0xC0, 0xC7,
  0x05, 0xD0, 0x50, 0xCC, 0x0C, 0x70, 0x6D, 0x05, 0x0C, 0xC0, 0xC7, 0x09, 0xD0, 0x40, 0xCC, 0x0C,
  0x60, 0x10, 0xED, 0x01, 0x0C, 0xC0, 0xC5, 0x03, 0x0C, 0xD8, 0x1C, 0x0C, 0xC8, 0x4E, 0x99, 0x9A,
  0xDF, 0x81, 0x50, 0xCF, 0xFA, 0x0C, 0x20, 0xCF, 0xF9, 0x0D, 0x01, 0x20, 0xCF, 0xF0, 0x94, 0x0C,
  0xFA, 0x83, 0xED, 0xB7, 0x15, 0x0C, 0xC0, 0xC7, 0x70, 0xCC, 0x0C, 0x77, 0x0C, 0xC0, 0xC7, 0x70,
  0xCC, 0x0C, 0x77, 0x0C, 0xC0, 0xC7, 0x70, 0xCC, 0x0C, 0x77, 0x0C, 0xC0, 0xC7, 0x70, 0xCC, 0x0C,
  0x77, 0x0C, 0xC0, 0xC7, 0x70, 0xCC, 0x0C, 0x77,
  // "Q" (U+0051)
  0x68, 0x90, 0x27, 0xBD, 0xEE, 0xDB, 0x72, 0x73, 0x01, 0x0A, 0xFB, 0x0A, 0x01, 0x70, 0x20, 0xEF,
  0xD0, 0xE0, 0x25, 0x01, 0x0D, 0xFF, 0x0D, 0x01, 0x40, 0xAE, 0x82, 0xEB, 0xAE, 0xE0, 0x93, 0x03,
  0xE0, 0x74, 0x07, 0xE0, 0x22, 0x09, 0xD0, 0x86, 0x09, 0xD0, 0x92, 0x0E, 0xD0, 0x16, 0x01, 0xD8,
  0x1E, 0x03, 0xD0, 0xA7, 0x10, 0xBD, 0x03, 0x06, 0xD0, 0x77, 0x10, 0x7D, 0x05, 0x08, 0xD0, 0x47,
  0x10, 0x4D, 0x08, 0x0A, 0xD0, 0x27, 0x10, 0x3D, 0x0A, 0x0B, 0xD0, 0x17, 0x10, 0x2D, 0x00, 0xBD,
  0x01, 0x71, 0x01, 0xD0, 0xB0, 0xCD, 0x01, 0x71, 0x01, 0xD0, 0xC0, 0xBD, 0x01, 0x71, 0x02, 0xD0,
  0xB0, 0xAD, 0x02, 0x71, 0x03, 0xD0, 0xA0, 0x8D, 0x04, 0x71, 0x04, 0xD0, 0x80, 0x6D, 0x07, 0x71,
  0x07, 0xD0, 0x60, 0x3D, 0x0A, 0x71, 0x0B, 0xD8, 0x13, 0x0E, 0xD0, 0x16, 0x01, 0xD0, 0xE2, 0x09,
  0xD0, 0x86, 0x08, 0xD0, 0xA2, 0x03, 0xE0, 0x74, 0x07, 0xE0, 0x33, 0x0A, 0xE8, 0x2D, 0xAA, 0xDE,
  0x0B, 0x40, 0x10, 0xDF, 0xF0, 0xE0, 0x15, 0x02, 0x0E, 0xFD, 0x0E, 0x03, 0x70, 0x10, 0xAF, 0xB0,
  0xD0, 0x17, 0x38, 0x32, 0x7B, 0xDE, 0xD0, 0xE0, 0x17, 0x71, 0x03, 0xD0, 0x97, 0x72, 0x0B, 0xD0,
  0x37, 0x71, 0x03, 0xD0, 0xB7, 0x72, 0x0A, 0xD0, 0x57, 0x71, 0x02, 0xD0, 0xD7, 0x72, 0x09, 0xD0,
  0x77, 0x71, 0x01, 0x80, 0x17, 0x06, 0x10,
  // "R" (U+0052)
  0x0C, 0xF8, 0x3E, 0xEC, 0x95, 0x71, 0x0C, 0xFD, 0x0E, 0x07, 0x60, 0xCF, 0xF0, 0xC0, 0x14, 0x0C,
  0xFF, 0x90, 0xB4, 0x0C, 0xD8, 0x29, 0xAA, 0xCF, 0x06, 0x30, 0xCD, 0x40, 0x20, 0xBD, 0x0C, 0x30,
  0xCD, 0x60, 0xED, 0x30, 0xCD, 0x60, 0xAD, 0x02, 0x20, 0xCD, 0x60, 0x9D, 0x03, 0x20, 0xCD, 0x60,
  0xBD, 0x02, 0x20, 0xCD, 0x50, 0x2D, 0x0E, 0x30, 0xCD, 0x40, 0x30, 0xDD, 0x0A, 0x30, 0xCD, 0x82,
  0x99, 0xAD, 0xF0, 0x23, 0x0C, 0xFF, 0x90, 0x54, 0x0C, 0xFF, 0x06, 0x50, 0xCF, 0xD0, 0xC0, 0x26,
  0x0C, 0xFD, 0x0C, 0x70, 0xCD, 0x20, 0x7D, 0x06, 0x60, 0xCD, 0x30, 0xDC, 0x0E, 0x60, 0xCD, 0x30,
  0x5D, 0x08, 0x50, 0xCD, 0x40, 0xCD, 0x02, 0x40, 0xCD, 0x40, 0x4D, 0x0A, 0x40, 0xCD, 0x50, 0xBD,
  0x03, 0x30, 0xCD, 0x50, 0x3D, 0x0C, 0x30, 0xCD, 0x60, 0xAD, 0x06, 0x20, 0xCD, 0x60, 0x2D, 0x0E,
  0x20, 0xCD, 0x70, 0x9D, 0x81, 0x80, 0xCD, 0x70, 0x10, 0xED, 0x02,
  // "S" (U+0053)
  0x58, 0x92, 0x16, 0xAD, 0xEF, 0xED, 0xCA, 0x63, 0x70, 0x8F, 0xD8, 0x1D, 0x71, 0x20, 0x10, 0xCF,
  0xF0, 0xE3, 0x0A, 0xFF, 0x90, 0x82, 0x02, 0xF8, 0x3C, 0xAA, 0xBE, 0xC0, 0x22, 0x06, 0xD0, 0xE0,
  0x35, 0x82, 0x37, 0xDB, 0x30, 0x8D, 0x07, 0x72, 0x01, 0x30, 0x9D, 0x05, 0x76, 0x07, 0xD0, 0x67,
  0x60, 0x4D, 0x0D, 0x02, 0x76, 0x0D, 0xD0, 0xE0, 0x67, 0x50, 0x4F, 0x0D, 0x06, 0x74, 0x06, 0xF9,
  0x0E, 0x06, 0x73, 0x05, 0x0E, 0xF9, 0x0D, 0x05, 0x72, 0x01, 0x0A, 0xFA, 0x0B, 0x01, 0x72, 0x03,
  0x0B, 0xF9, 0x0E, 0x02, 0x73, 0x04, 0x0B, 0xF0, 0xC7, 0x50, 0x30, 0xCE, 0x05, 0x76, 0x0B, 0xD0,
  0x97, 0x60, 0x4D, 0x0B, 0x76, 0x02, 0xD8, 0x1B, 0x26, 0x74, 0x05, 0xD8, 0x5A, 0x3F, 0xE9, 0x51,
  0x60, 0x40, 0xED, 0x06, 0x03, 0xD8, 0x4D, 0xBA, 0xAB, 0xEE, 0x81, 0xE1, 0x3F, 0xFB, 0x81, 0x50,
  0x3F, 0xFA, 0x07, 0x28, 0x11, 0x9E, 0xFD, 0x0B, 0x03, 0x68, 0x34, 0x8A, 0xDE, 0xA8, 0x3D, 0xCA,
  0x62, 0x50,
  // "T" (U+0054)
  0x0C, 0xFF, 0xE0, 0x0C, 0xFF, 0xE0, 0x0C, 0xFF, 0xE0, 0x0C, 0xFF, 0xE0, 0xC0, 0x78, 0x03, 0x9D,
  0x0E, 0x80, 0x39, 0x07, 0x71, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7,
  0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7,
  0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7,
  0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7,
  0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7,
  0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7,
  0x10,
  // "U" (U+0055)
  0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D,
  0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09,
  0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10,
  0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71,
  0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97,
  0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09,
  0x71, 0x09, 0xD0, 0x30, 0x2D, 0x09, 0x71, 0x0A, 0xD0, 0x20, 0x1D, 0x0B, 0x71, 0x0B, 0xD0, 0x11,
  0xD0, 0xE7, 0x10, 0xED, 0x20, 0xCD, 0x05, 0x60, 0x5D, 0x0B, 0x20, 0x7D, 0x0E, 0x04, 0x40, 0x40,
  0xED, 0x06, 0x20, 0x10, 0xEE, 0x82, 0xDA, 0xAD, 0xE0, 0xE4, 0x06, 0xFF, 0xA0, 0x45, 0x08, 0xFF,
  0x06, 0x70, 0x50, 0xDF, 0xB0, 0xC0, 0x47, 0x38, 0x90, 0x49, 0xCE, 0xFE, 0xDC, 0x84, 0x60,
  // "V" (U+0056)
  0x06, 0xD0, 0x57, 0x30, 0x6D, 0x06, 0x02, 0xD0, 0x97, 0x30, 0xAD, 0x81, 0x20, 0xDC, 0x0D, 0x73,
  0x0E, 0xC0, 0xD2, 0x08, 0xD0, 0x27, 0x10, 0x2D, 0x08, 0x20, 0x3D, 0x06, 0x71, 0x06, 0xD0, 0x33,
  0x0E, 0xC0, 0xA7, 0x10, 0xAC, 0x0E, 0x40, 0xAC, 0x0D, 0x71, 0x0E, 0xC0, 0xA4, 0x05, 0xD0, 0x26,
  0x02, 0xD0, 0x54, 0x01, 0xD0, 0x66, 0x06, 0xD0, 0x15, 0x0B, 0xC0, 0xA6, 0x0A, 0xC0, 0xB6, 0x07,
  0xC0, 0xE6, 0x0E, 0xC0, 0x76, 0x02, 0xD0, 0x24, 0x02, 0xD0, 0x27, 0x0D, 0xC0, 0x64, 0x06, 0xC0,
  0xD7, 0x10, 0x8C, 0x0A, 0x40, 0xAC, 0x08, 0x71, 0x04, 0xC0, 0xE4, 0x0E, 0xC0, 0x47, 0x20, 0xEC,
  0x03, 0x20, 0x2C, 0x0E, 0x73, 0x0A, 0xC0, 0x72, 0x06, 0xC0, 0xA7, 0x30, 0x5C, 0x0B, 0x20, 0x9C,
  0x05, 0x73, 0x01, 0xC0, 0xE2, 0x0D, 0xC0, 0x17, 0x40, 0xCC, 0x02, 0x1C, 0x0B, 0x75, 0x07, 0xC0,
  0x60, 0x3C, 0x07, 0x75, 0x02, 0xC0, 0x90, 0x6C, 0x02, 0x76, 0x0D, 0xB0, 0xC0, 0x9B, 0x0D, 0x77,
  0x09, 0xB0, 0xE0, 0xDB, 0x08, 0x77, 0x04, 0xF9, 0x04, 0x77, 0x10, 0xEE, 0x0E, 0x77, 0x20, 0xAE,
  0x0A, 0x77, 0x20, 0x5E, 0x05, 0x71,
  // "W" (U+0057)
  0x08, 0xC0, 0x77, 0x50, 0x7C, 0x08, 0x07, 0xC0, 0x97, 0x50, 0x8C, 0x07, 0x06, 0xC0, 0xA7, 0x50,
  0x9C, 0x06, 0x05, 0xC0, 0xC7, 0x50, 0xBC, 0x05, 0x03, 0xC0, 0xD7, 0x50, 0xCC, 0x04, 0x02, 0xD7,
  0x50, 0xDC, 0x03, 0x01, 0xD3, 0x0C, 0xC0, 0xD3, 0x0E, 0xC0, 0x11, 0xD0, 0x22, 0x0E, 0xD3, 0xD2,
  0x0E, 0xC8, 0x13, 0x01, 0xE8, 0x12, 0x01, 0xD2, 0x0D, 0xC8, 0x14, 0x04, 0xE8, 0x14, 0x02, 0xC0,
  0xE2, 0x0C, 0xC8, 0x15, 0x06, 0xE8, 0x17, 0x03, 0xC0, 0xD2, 0x0B, 0xC8, 0x16, 0x08, 0xE8, 0x19,
  0x04, 0xC0, 0xB2, 0x0A, 0xC8, 0x17, 0x0B, 0xA0, 0xD0, 0xCA, 0x81, 0xB0, 0x5C, 0x0A, 0x20, 0x9C,
  0x81, 0x80, 0xDA, 0x0B, 0x0A, 0xA8, 0x1E, 0x06, 0xC0, 0x92, 0x07, 0xC0, 0x81, 0xB0, 0x90, 0x8B,
  0x01, 0x07, 0xC0, 0x82, 0x06, 0xC0, 0x90, 0x2B, 0x07, 0x06, 0xB0, 0x30, 0x7C, 0x07, 0x20, 0x5C,
  0x09, 0x04, 0xB0, 0x50, 0x4B, 0x05, 0x07, 0xC0, 0x62, 0x04, 0xC0, 0x90, 0x7B, 0x00, 0x2B, 0x08,
  0x07, 0xC0, 0x52, 0x03, 0xC0, 0x09, 0xB2, 0xB0, 0xA0, 0x7C, 0x04, 0x20, 0x1C, 0x09, 0x0B, 0xA0,
  0xD2, 0x0D, 0xA0, 0xD0, 0x6C, 0x03, 0x3C, 0x09, 0x0D, 0xA0, 0xB2, 0x0B, 0xB0, 0x6C, 0x01, 0x3C,
  0x08, 0xB0, 0x92, 0x08, 0xB0, 0x8C, 0x40, 0xDB, 0x0A, 0xB0, 0x62, 0x06, 0xB0, 0x9C, 0x40, 0xCB,
  0x0E, 0xB0, 0x42, 0x04, 0xB0, 0xEB, 0x0E, 0x40, 0xBF, 0x02, 0x20, 0x1F, 0x0D, 0x40, 0xAF, 0x40,
  0xEE, 0x0B, 0x40, 0x9E, 0x0D, 0x40, 0xCE, 0x0A, 0x40, 0x8E, 0x0B, 0x40, 0xAE, 0x09, 0x20,
  // "X" (U+0058)
  0x05, 0xD0, 0x87, 0x10, 0x9D, 0x81, 0x50, 0xBD, 0x01, 0x60, 0x2D, 0x0B, 0x20, 0x2D, 0x09, 0x60,
  0xAD, 0x02, 0x30, 0x9D, 0x02, 0x40, 0x2D, 0x09, 0x40, 0x10, 0xEC, 0x0A, 0x40, 0xAC, 0x0E, 0x01,
  0x50, 0x6D, 0x02, 0x20, 0x3D, 0x06, 0x70, 0xCC, 0x0B, 0x20, 0xBC, 0x0C, 0x71, 0x03, 0xD0, 0x03,
  0xD0, 0x37, 0x20, 0xAC, 0x00, 0xBC, 0x09, 0x73, 0x01, 0x0E, 0xF9, 0x0E, 0x01, 0x74, 0x07, 0xF9,
  0x07, 0x76, 0x0D, 0xE0, 0xD7, 0x70, 0x5E, 0x04, 0x77, 0x10, 0xCC, 0x0C, 0x77, 0x10, 0x2E, 0x02,
  0x77, 0x0B, 0xE0, 0xB7, 0x60, 0x5F, 0x90, 0x57, 0x50, 0xDF, 0x90, 0xD7, 0x40, 0x8C, 0x0D, 0x0E,
  0xC0, 0x87, 0x20, 0x2D, 0x04, 0x06, 0xD0, 0x27, 0x10, 0xBC, 0x0C, 0x20, 0xDC, 0x0B, 0x70, 0x5D,
  0x03, 0x20, 0x5D, 0x05, 0x60, 0xDC, 0x0A, 0x40, 0xCC, 0x0D, 0x50, 0x8D, 0x02, 0x40, 0x4D, 0x08,
  0x30, 0x2D, 0x09, 0x60, 0xCD, 0x02, 0x20, 0xBC, 0x0E, 0x01, 0x60, 0x3D, 0x81, 0xB0, 0x4D, 0x08,
  0x71, 0x0B, 0xD0, 0x40, 0xDC, 0x0E, 0x72, 0x03, 0xD0, 0xD0,
  // "Y" (U+0059)
  0x0E, 0xD0, 0x27, 0x10, 0x1D, 0x0E, 0x07, 0xD0, 0x87, 0x10, 0x7D, 0x81, 0x70, 0xEC, 0x0E, 0x71,
  0x0E, 0xC0, 0xE2, 0x07, 0xD0, 0x66, 0x05, 0xD0, 0x82, 0x01, 0x0E, 0xC0, 0xD6, 0x0C, 0xC0, 0xE0,
  0x13, 0x08, 0xD0, 0x44, 0x03, 0xD0, 0x84, 0x01, 0xD0, 0xA4, 0x09, 0xD0, 0x15, 0x08, 0xD0, 0x22,
  0x01, 0xD0, 0x96, 0x01, 0xD0, 0x82, 0x07, 0xD0, 0x27, 0x09, 0xC0, 0xE2, 0x0D, 0xC0, 0x97, 0x10,
  0x2D, 0x06, 0x05, 0xD0, 0x27, 0x20, 0x9C, 0x0D, 0x0B, 0xC0, 0xA7, 0x30, 0x2F, 0xB0, 0x27, 0x40,
  0xAF, 0x90, 0xA7, 0x50, 0x2F, 0x90, 0x37, 0x60, 0xAE, 0x0B, 0x77, 0x03, 0xE0, 0x47, 0x71, 0x0D,
  0xC0, 0xE7, 0x72, 0x0D, 0xC0, 0xE7, 0x72, 0x0D, 0xC0, 0xE7, 0x72, 0x0D, 0xC0, 0xE7, 0x72, 0x0D,
  0xC0, 0xE7, 0x72, 0x0D, 0xC0, 0xE7, 0x72, 0x0D, 0xC0, 0xE7, 0x72, 0x0D, 0xC0, 0xE7, 0x72, 0x0D,
  0xC0, 0xE7, 0x72, 0x0D, 0xC0, 0xE7, 0x72, 0x0D, 0xC0, 0xE7, 0x10,
  // "Z" (U+005A)
  0x10, 0xCF, 0xFA, 0x81, 0x10, 0xCF, 0xFA, 0x81, 0x10, 0xCF, 0xFA, 0x81, 0x10, 0xCF, 0xFA, 0x81,
  0x10, 0x78, 0x05, 0x90, 0xCD, 0x0A, 0x75, 0x0D, 0xC0, 0xE0, 0x17, 0x40, 0x6D, 0x07, 0x74, 0x01,
  0x0E, 0xC0, 0xD7, 0x50, 0x9D, 0x04, 0x74, 0x02, 0xD0, 0xB7, 0x50, 0xBD, 0x02, 0x74, 0x05, 0xD0,
  0x87, 0x50, 0xDC, 0x0D, 0x75, 0x07, 0xD0, 0x57, 0x40, 0x10, 0xEC, 0x0B, 0x75, 0x0A, 0xD0, 0x37,
  0x40, 0x3D, 0x09, 0x75, 0x0C, 0xC0, 0xE0, 0x17, 0x40, 0x5D, 0x06, 0x75, 0x0E, 0xC0, 0xC7, 0x50,
  0x8D, 0x03, 0x74, 0x02, 0xD0, 0xA7, 0x50, 0xAC, 0x0E, 0x01, 0x74, 0x04, 0xD0, 0xD8, 0x07, 0x90,
  0x20, 0xBF, 0xFB, 0x03, 0x0C, 0xFF, 0xB0, 0x30, 0xCF, 0xFB, 0x03, 0x0C, 0xFF, 0xB0, 0x30,
  // "[" (U+005B)
  0x0C, 0xF9, 0x00, 0xCF, 0x90, 0x0C, 0xF9, 0x00, 0xCF, 0x90, 0x0C, 0xC8, 0x4A, 0x99, 0x97, 0xCC,
  0x02, 0x40, 0xCC, 0x02, 0x40, 0xCC, 0x02, 0x40, 0xCC, 0x02, 0x40, 0xCC, 0x02, 0x40, 0xCC, 0x02,
  0x40, 0xCC, 0x02, 0x40, 0xCC, 0x02, 0x40, 0xCC, 0x02, 0x40, 0xCC, 0x02, 0x40, 0xCC, 0x02, 0x40,
  0xCC, 0x02, 0x40, 0xCC, 0x02, 0x40, 0xCC, 0x02, 0x40, 0xCC, 0x02, 0x40, 0xCC, 0x02, 0x40, 0xCC,
  0x02, 0x40, 0xCC, 0x02, 0x40, 0xCC, 0x02, 0x40, 0xCC, 0x02, 0x40, 0xCC, 0x02, 0x40, 0xCC, 0x02,
  0x40, 0xCC, 0x02, 0x40, 0xCC, 0x02, 0x40, 0xCC, 0x02, 0x40, 0xCC, 0x02, 0x40, 0xCC, 0x84, 0xA9,
  0x99, 0x7C, 0xF9, 0x00, 0xCF, 0x90, 0x0C, 0xF9, 0x00, 0xCF, 0x90, 0xC0,
  // "\" (U+005C)
  0x0C, 0xC0, 0x37, 0x30, 0x6C, 0x09, 0x74, 0x0E, 0xB0, 0xE7, 0x40, 0x9C, 0x05, 0x73, 0x03, 0xC0,
  0xB7, 0x40, 0xDC, 0x02, 0x73, 0x07, 0xC0, 0x87, 0x30, 0x1C, 0x0E, 0x74, 0x0A, 0xC0, 0x57, 0x30,
  0x4C, 0x0B, 0x74, 0x0D, 0xC0, 0x27, 0x30, 0x7C, 0x07, 0x73, 0x01, 0xC0, 0xD7, 0x40, 0xBC, 0x04,
  0x73, 0x05, 0xC0, 0xA7, 0x40, 0xEC, 0x01, 0x73, 0x08, 0xC0, 0x77, 0x30, 0x2C, 0x0D, 0x74, 0x0B,
  0xC0, 0x47, 0x30, 0x5C, 0x0A, 0x74, 0x0E, 0xC0, 0x17, 0x30, 0x9C, 0x06, 0x73, 0x03, 0xC0, 0xD7,
  0x40, 0xCC, 0x03, 0x73, 0x06, 0xC0, 0x97, 0x30, 0x10, 0xEB, 0x0E, 0x74, 0x09, 0xC0, 0x67, 0x30,
  0x3C, 0x0C,
  // "]" (U+005D)
  0x0C, 0xF9, 0x00, 0xCF, 0x90, 0x0C, 0xF9, 0x00, 0xCF, 0x98, 0x4C, 0x79, 0x99, 0xAC, 0x0C, 0x40,
  0x2C, 0x0C, 0x40, 0x2C, 0x0C, 0x40, 0x2C, 0x0C, 0x40, 0x2C, 0x0C, 0x40, 0x2C, 0x0C, 0x40, 0x2C,
  0x0C, 0x40, 0x2C, 0x0C, 0x40, 0x2C, 0x0C, 0x40, 0x2C, 0x0C, 0x40, 0x2C, 0x0C, 0x40, 0x2C, 0x0C,
  0x40, 0x2C, 0x0C, 0x40, 0x2C, 0x0C, 0x40, 0x2C, 0x0C, 0x40, 0x2C, 0x0C, 0x40, 0x2C, 0x0C, 0x40,
  0x2C, 0x0C, 0x40, 0x2C, 0x0C, 0x40, 0x2C, 0x0C, 0x40, 0x2C, 0x0C, 0x40, 0x2C, 0x0C, 0x40, 0x2C,
  0x0C, 0x40, 0x2C, 0x0C, 0x40, 0x2C, 0x0C, 0x40, 0x2C, 0x0C, 0x40, 0x2C, 0x84, 0xC7, 0x99, 0x9A,
  0xC0, 0x0C, 0xF9, 0x00, 0xCF, 0x90, 0x0C, 0xF9, 0x00, 0xCF, 0x90, 0xC0,
  // "^" (U+005E)
  0x72, 0x0D, 0xA0, 0x57, 0x73, 0x06, 0xB0, 0xD7, 0x73, 0x0D, 0xC0, 0x57, 0x71, 0x06, 0xD0, 0xD7,
  0x71, 0x0D, 0xE0, 0x67, 0x60, 0x5F, 0x0D, 0x76, 0x0C, 0xB0, 0xEC, 0x06, 0x74, 0x05, 0xC0, 0x50,
  0xBB, 0x0E, 0x74, 0x0C, 0xB8, 0x1D, 0x03, 0xC0, 0x77, 0x20, 0x4C, 0x05, 0x20, 0xBB, 0x0E, 0x01,
  0x71, 0x0C, 0xB0, 0xD3, 0x03, 0xC0, 0x87, 0x04, 0xC0, 0x64, 0x0A, 0xB0, 0xE0, 0x16, 0x0B, 0xB0,
  0xE5, 0x02, 0xC0, 0x85, 0x03, 0xC0, 0x76, 0x0A, 0xC0, 0x14, 0x0B, 0xB0, 0xE7, 0x02, 0xC0, 0x93,
  0x03, 0xC0, 0x77, 0x10, 0x9C, 0x02, 0x20, 0xAB, 0x0E, 0x01, 0x71, 0x01, 0xC8, 0x19, 0x02, 0xC0,
  0x87, 0x30, 0x8C, 0x02,
  // "_" (U+005F)
  0x80, 0xA4, 0x98, 0x09, 0xB4, 0xF0,
  // "`" (U+0060)
  0x04, 0x80, 0x27, 0x40, 0x20, 0xDD, 0x05, 0x40, 0x20, 0xEC, 0x0E, 0x01, 0x40, 0x20, 0xDC, 0x09,
  0x50, 0x20, 0xDC, 0x04, 0x50, 0x10, 0xCB, 0x0E, 0x01, 0x60, 0xAB, 0x09,
  // "a" (U+0061)
  0x48, 0x91, 0x48, 0xBD, 0xEF, 0xED, 0xB9, 0x46, 0x81, 0x28, 0xEF, 0xC0, 0xD0, 0x54, 0x06, 0xFF,
  0x90, 0x74, 0x0D, 0xFF, 0x90, 0x43, 0x06, 0xB8, 0x4E, 0xCA, 0xAA, 0xCE, 0x0D, 0x48, 0x19, 0x52,
  0x60, 0x20, 0xCD, 0x02, 0x76, 0x03, 0xD0, 0x47, 0x60, 0x1D, 0x06, 0x48, 0x25, 0x9C, 0xEF, 0xC0,
  0x62, 0x05, 0x0D, 0xFF, 0x98, 0x16, 0x07, 0xFF, 0xB0, 0x60, 0x2E, 0x08, 0x03, 0x40, 0x1D, 0x06,
  0x09, 0xD0, 0x46, 0x01, 0xD0, 0x60, 0xDC, 0x0C, 0x70, 0x2D, 0x06, 0x0E, 0xC0, 0xA7, 0x06, 0xD0,
  0x6D, 0x0D, 0x60, 0x10, 0xDD, 0x06, 0x0D, 0xD0, 0x74, 0x03, 0x0D, 0xE0, 0x60, 0xAE, 0x82, 0xDA,
  0xAD, 0xF9, 0x06, 0x05, 0xFF, 0xC8, 0x16, 0x0B, 0xFC, 0x04, 0x0B, 0xC8, 0x26, 0x01, 0xBF, 0x98,
  0x2C, 0x30, 0x7C, 0x06, 0x38, 0x65, 0xAD, 0xFE, 0xD9, 0x53, 0x02, 0xC0, 0x60,
  // "b" (U+0062)
  0x0C, 0xC0, 0xD7, 0x71, 0x0C, 0xC0, 0xD7, 0x71, 0x0C, 0xC0, 0xD7, 0x71, 0x0C, 0xC0, 0xD7, 0x71,
  0x0C, 0xC0, 0xD7, 0x71, 0x0C, 0xC0, 0xD7, 0x71, 0x0C, 0xC0, 0xD7, 0x71, 0x0C, 0xC0, 0xD7, 0x71,
  0x0C, 0xC0, 0xC2, 0x86, 0x27, 0xCE, 0xFE, 0xB5, 0x50, 0xCC, 0x81, 0xB0, 0x7F, 0x90, 0xC0, 0x13,
  0x0C, 0xC0, 0xA0, 0x8F, 0xB0, 0xC3, 0x0C, 0xC0, 0xEF, 0xD0, 0x92, 0x0C, 0xF8, 0x2E, 0xBA, 0xDF,
  0x81, 0x20, 0xCE, 0x09, 0x40, 0x5E, 0x81, 0x80, 0xCD, 0x0B, 0x60, 0x6D, 0x81, 0xC0, 0xCD, 0x04,
  0x70, 0xED, 0x01, 0x0C, 0xD0, 0x17, 0x0A, 0xD0, 0x30, 0xCC, 0x0E, 0x71, 0x08, 0xD0, 0x40, 0xCC,
  0x0D, 0x71, 0x07, 0xD0, 0x50, 0xCC, 0x0D, 0x71, 0x08, 0xD0, 0x50, 0xCC, 0x0E, 0x71, 0x08, 0xD0,
  0x40, 0xCD, 0x01, 0x70, 0xBD, 0x03, 0x0C, 0xD0, 0x67, 0x0E, 0xD1, 0x0C, 0xD0, 0xD6, 0x06, 0xD8,
  0x1C, 0x0C, 0xE0, 0xA0, 0x13, 0x05, 0xE8, 0x17, 0x0C, 0xF8, 0x2E, 0xBA, 0xDF, 0x81, 0x10, 0xCF,
  0xFB, 0x08, 0x20, 0xCF, 0xFA, 0x0C, 0x30, 0xCC, 0x81, 0x46, 0xEF, 0x90, 0xB0, 0x13, 0x0C, 0xB0,
  0xC3, 0x86, 0x6A, 0xDE, 0xFD, 0xA4, 0x50,
  // "c" (U+0063)
  0x68, 0x31, 0x6A, 0xDE, 0xA8, 0x3E, 0xC9, 0x62, 0x50, 0x10, 0x9F, 0xD0, 0x83, 0x02, 0x0D, 0xFE,
  0x05, 0x20, 0x10, 0xDF, 0xE0, 0xE3, 0x09, 0xF8, 0x3C, 0xAA, 0xBE, 0xA0, 0x92, 0x02, 0xE0, 0xC0,
  0x25, 0x81, 0x27, 0x22, 0x08, 0xD0, 0xD7, 0x50, 0xBD, 0x04, 0x75, 0xD0, 0xE7, 0x50, 0x1D, 0x0C,
  0x75, 0x02, 0xD0, 0xB7, 0x50, 0x2D, 0x0B, 0x75, 0x01, 0xD0, 0xC7, 0x6D, 0x0E, 0x76, 0x0D, 0xD0,
  0x47, 0x50, 0xAD, 0x0C, 0x72, 0x01, 0x20, 0x4E, 0x0B, 0x02, 0x58, 0x23, 0x9F, 0x12, 0x0D, 0xF8,
  0x3D, 0xAA, 0xBE, 0xB0, 0x12, 0x03, 0xFF, 0x90, 0x13, 0x05, 0x0E, 0xFE, 0x01, 0x40, 0x20, 0xBF,
  0xC0, 0xC0, 0x16, 0x89, 0x13, 0x7B, 0xDE, 0xFE, 0xDB, 0x83, 0x20,
  // "d" (U+0064)
  0x77, 0x10, 0xDC, 0x0C, 0x77, 0x10, 0xDC, 0x0C, 0x77, 0x10, 0xDC, 0x0C, 0x77, 0x10, 0xDC, 0x0C,
  0x77, 0x10, 0xDC, 0x0C, 0x77, 0x10, 0xDC, 0x0C, 0x77, 0x10, 0xDC, 0x0C, 0x77, 0x10, 0xCC, 0x0C,
  0x58, 0x63, 0x9D, 0xEE, 0xDA, 0x42, 0x0C, 0xC0, 0xC4, 0x0A, 0xF9, 0x81, 0xB1, 0xAC, 0x0C, 0x30,
  0xCF, 0xB0, 0xC0, 0x8C, 0x0C, 0x20, 0x8F, 0xFB, 0x81, 0xC0, 0x2F, 0x82, 0xEB, 0xAC, 0xF8, 0x1C,
  0x08, 0xE0, 0x74, 0x04, 0x0E, 0xD8, 0x1C, 0x0C, 0xD0, 0x86, 0x05, 0xD0, 0xC0, 0x1E, 0x01, 0x70,
  0xEC, 0x0C, 0x03, 0xD0, 0xB7, 0x10, 0xAC, 0x0C, 0x04, 0xD0, 0x97, 0x10, 0x8C, 0x0C, 0x05, 0xD0,
  0x87, 0x10, 0x7C, 0x0C, 0x05, 0xD0, 0x77, 0x10, 0x6C, 0x0C, 0x04, 0xD0, 0x87, 0x10, 0x7C, 0x0C,
  0x03, 0xD0, 0xA7, 0x10, 0x9C, 0x0C, 0x01, 0xD0, 0xE7, 0x10, 0xDC, 0x81, 0xC0, 0xCD, 0x05, 0x60,
  0x4D, 0x81, 0xC0, 0x8D, 0x0E, 0x04, 0x40, 0x40, 0xED, 0x81, 0xC0, 0x2F, 0x82, 0xDA, 0xAD, 0xF0,
  0xC2, 0x0A, 0xFF, 0xB0, 0xC2, 0x01, 0x0D, 0xFB, 0x08, 0x09, 0xC0, 0xC3, 0x01, 0x0C, 0xF9, 0x81,
  0x70, 0x3C, 0x0C, 0x58, 0x65, 0xBE, 0xFE, 0xC8, 0x23, 0x0C, 0xB0, 0xC0,
  // "e" (U+0065)
  0x58, 0x90, 0x16, 0xAD, 0xEF, 0xEC, 0x84, 0x72, 0x07, 0x0E, 0xFA, 0x0C, 0x02, 0x60, 0xBF, 0xD0,
  0xE0, 0x44, 0x0B, 0xFF, 0x0E, 0x02, 0x20, 0x6E, 0x82, 0xEB, 0xAB, 0xE0, 0xB2, 0x0E, 0xD0, 0x90,
  0x13, 0x02, 0x0C, 0xD0, 0x20, 0x5D, 0x09, 0x70, 0xDC, 0x07, 0x09, 0xD0, 0x17, 0x07, 0xC0, 0xB0,
  0xCC, 0x0D, 0x71, 0x03, 0xC0, 0xD0, 0xEF, 0xFC, 0x0E, 0xFF, 0xE0, 0xEF, 0xFD, 0x0D, 0xFF, 0xD0,
  0xBC, 0x0B, 0x77, 0x08, 0xC0, 0xE0, 0x17, 0x60, 0x3D, 0x0B, 0x77, 0x0B, 0xD0, 0xD0, 0x57, 0x84,
  0x26, 0xA5, 0x03, 0xF9, 0x84, 0xCA, 0xAA, 0xCE, 0xB0, 0x52, 0x06, 0xFF, 0xA0, 0x53, 0x05, 0x0E,
  0xFF, 0x05, 0x40, 0x20, 0xAF, 0xD0, 0xD0, 0x36, 0x83, 0x16, 0x9C, 0xDA, 0x83, 0xED, 0xA7, 0x32,
  // "f" (U+0066)
  0x73, 0x89, 0x15, 0x9C, 0xEF, 0xED, 0xCA, 0x74, 0x71, 0x04, 0x0D, 0xFB, 0x0E, 0x70, 0x3F, 0xD0,
  0x97, 0x0C, 0xFD, 0x04, 0x60, 0x2F, 0x84, 0xCA, 0xAB, 0xEE, 0x70, 0x6D, 0x0E, 0x03, 0x50, 0x17,
  0x07, 0xD0, 0x77, 0x70, 0x7D, 0x05, 0x73, 0x82, 0x25, 0x9C, 0xFE, 0x82, 0x50, 0x3E, 0xFF, 0xB8,
  0x15, 0x04, 0xFF, 0xC8, 0x15, 0x04, 0xFF, 0xC8, 0x15, 0x02, 0x80, 0x19, 0x0C, 0xD0, 0xB8, 0x02,
  0x90, 0x37, 0x07, 0xD0, 0x47, 0x70, 0x7D, 0x04, 0x77, 0x07, 0xD0, 0x47, 0x70, 0x7D, 0x04, 0x77,
  0x07, 0xD0, 0x47, 0x70, 0x7D, 0x04, 0x77, 0x07, 0xD0, 0x47, 0x70, 0x7D, 0x04, 0x77, 0x07, 0xD0,
  0x47, 0x70, 0x7D, 0x04, 0x77, 0x07, 0xD0, 0x47, 0x70, 0x7D, 0x04, 0x77, 0x07, 0xD0, 0x47, 0x70,
  0x7D, 0x04, 0x77, 0x07, 0xD0, 0x47, 0x70, 0x7D, 0x04, 0x77, 0x07, 0xD0, 0x47, 0x10,
  // "g" (U+0067)
  0x58, 0x64, 0xAD, 0xEE, 0xC8, 0x23, 0x0C, 0xB0, 0xC3, 0x01, 0x0A, 0xF9, 0x81, 0x70, 0x3C, 0x0C,
  0x30, 0xCF, 0xB0, 0x09, 0xC0, 0xC2, 0x09, 0xFF, 0xB8, 0x1C, 0x02, 0xF8, 0x2D, 0xAA, 0xDF, 0x81,
  0xC0, 0x8E, 0x05, 0x40, 0x6E, 0x81, 0xC0, 0xDD, 0x06, 0x60, 0x8D, 0x0C, 0x01, 0xD0, 0xE7, 0x01,
  0xD0, 0xC0, 0x3D, 0x0B, 0x71, 0x0D, 0xC0, 0xC0, 0x5D, 0x08, 0x71, 0x0B, 0xC0, 0xC0, 0x5D, 0x07,
  0x71, 0x0A, 0xC0, 0xC0, 0x5D, 0x07, 0x71, 0x09, 0xC0, 0xC0, 0x5D, 0x08, 0x71, 0x0A, 0xC0, 0xC0,
  0x3D, 0x0B, 0x71, 0x0C, 0xC0, 0xC0, 0x1D, 0x0E, 0x71, 0xD8, 0x1C, 0x0D, 0xD0, 0x76, 0x07, 0xD8,
  0x1C, 0x08, 0xE0, 0x54, 0x05, 0xE8, 0x1C, 0x02, 0xF8, 0x2D, 0xAA, 0xDF, 0x0C, 0x20, 0x8F, 0xFB,
  0x0C, 0x30, 0xCF, 0xB0, 0x80, 0xEC, 0x0C, 0x30, 0x10, 0xAF, 0x90, 0x71, 0xD0, 0xC5, 0x86, 0x49,
  0xDE, 0xEC, 0x82, 0x2D, 0x0C, 0x77, 0x01, 0xD0, 0xB7, 0x70, 0x3D, 0x09, 0x20, 0x17, 0x40, 0xAD,
  0x05, 0x28, 0x2D, 0xC7, 0x36, 0x01, 0x08, 0xE0, 0x12, 0x0D, 0xC8, 0x3C, 0xBA, 0xAC, 0xF0, 0x83,
  0x0D, 0xFF, 0x90, 0xD0, 0x13, 0x0D, 0xFF, 0x0D, 0x01, 0x40, 0xCF, 0xD0, 0xE0, 0x87, 0x89, 0x23,
  0x7A, 0xCD, 0xEF, 0xED, 0xB8, 0x56,
  // "h" (U+0068)
  0x0C, 0xD7, 0x70, 0xCD, 0x77, 0x0C, 0xD7, 0x70, 0xCD, 0x77, 0x0C, 0xD7, 0x70, 0xCD, 0x77, 0x0C,
  0xD7, 0x70, 0xCC, 0x0E, 0x77, 0x0C, 0xC0, 0xE2, 0x87, 0x17, 0xCE, 0xFE, 0xC7, 0x13, 0x0C, 0xC8,
  0x2E, 0x05, 0xEF, 0x90, 0x62, 0x0C, 0xC0, 0xD0, 0x4F, 0xC8, 0x15, 0x0C, 0xFF, 0xB8, 0x1E, 0x1C,
  0xF9, 0x81, 0xBA, 0xCF, 0x07, 0x0C, 0xE0, 0xB0, 0x13, 0x03, 0x0D, 0xD0, 0xB0, 0xCD, 0x0E, 0x01,
  0x50, 0x4D, 0x0D, 0x0C, 0xD0, 0x87, 0x0E, 0xD0, 0xCD, 0x04, 0x70, 0xDD, 0x0C, 0xD0, 0x27, 0x0C,
  0xD0, 0xCD, 0x71, 0x0C, 0xD0, 0xCD, 0x71, 0x0C, 0xD0, 0xCD, 0x71, 0x0C, 0xD0, 0xCD, 0x71, 0x0C,
  0xD0, 0xCD, 0x71, 0x0C, 0xD0, 0xCD, 0x71, 0x0C, 0xD0, 0xCD, 0x71, 0x0C, 0xD0, 0xCD, 0x71, 0x0C,
  0xD0, 0xCD, 0x71, 0x0C, 0xD0, 0xCD, 0x71, 0x0C, 0xD0, 0xCD, 0x71, 0x0C, 0xD0, 0xCD, 0x71, 0x0C,
  0xD0,
  // "i" (U+0069)
  0x72, 0x82, 0x57, 0x52, 0x77, 0x01, 0x0D, 0xC0, 0x57, 0x60, 0x9D, 0x0E, 0x76, 0x0C, 0xE0, 0x27,
  0x50, 0xCE, 0x01, 0x75, 0x09, 0xD0, 0xE7, 0x60, 0x10, 0xDB, 0x0E, 0x05, 0x77, 0x18, 0x25, 0x75,
  0x17, 0x77, 0x70, 0x8F, 0xC0, 0x77, 0x08, 0xFC, 0x07, 0x70, 0x8F, 0xC0, 0x77, 0x08, 0xFC, 0x07,
  0x78, 0x51, 0x46, 0x79, 0xBD, 0xD0, 0x77, 0x60, 0x4D, 0x07, 0x76, 0x04, 0xD0, 0x77, 0x60, 0x4D,
  0x07, 0x76, 0x04, 0xD0, 0x77, 0x60, 0x4D, 0x07, 0x76, 0x04, 0xD0, 0x77, 0x60, 0x4D, 0x07, 0x76,
  0x04, 0xD0, 0x77, 0x60, 0x4D, 0x07, 0x76, 0x04, 0xD0, 0x77, 0x60, 0x4D, 0x07, 0x76, 0x04, 0xD0,
  0x77, 0x28, 0x32, 0x47, 0x9D, 0xD8, 0x3D, 0x97, 0x41, 0x28, 0x16, 0xCE, 0xFF, 0x98, 0x1D, 0xB9,
  0xFF, 0xD0, 0x9F, 0xFD, 0x09, 0xFF, 0xD0,
  // "j" (U+006A)
  0x74, 0x82, 0x46, 0x63, 0x75, 0x0B, 0xC0, 0x87, 0x30, 0x6E, 0x02, 0x72, 0x09, 0xE0, 0x57, 0x20,
  0x9E, 0x05, 0x72, 0x06, 0xE0, 0x27, 0x30, 0xCC, 0x07, 0x75, 0x82, 0x47, 0x62, 0x77, 0x72, 0x0D,
  0xFC, 0x02, 0x40, 0xDF, 0xC0, 0x24, 0x0D, 0xFC, 0x02, 0x40, 0xDF, 0xC0, 0x24, 0x85, 0x24, 0x57,
  0x9A, 0xED, 0x02, 0x73, 0x09, 0xD0, 0x27, 0x30, 0x9D, 0x02, 0x73, 0x09, 0xD0, 0x27, 0x30, 0x9D,
  0x02, 0x73, 0x09, 0xD0, 0x27, 0x30, 0x9D, 0x02, 0x73, 0x09, 0xD0, 0x27, 0x30, 0x9D, 0x02, 0x73,
  0x09, 0xD0, 0x27, 0x30, 0x9D, 0x02, 0x73, 0x09, 0xD0, 0x27, 0x30, 0x9D, 0x02, 0x73, 0x09, 0xD0,
  0x27, 0x30, 0x9D, 0x02, 0x73, 0x09, 0xD0, 0x27, 0x30, 0x9D, 0x02, 0x73, 0x0A, 0xD0, 0x27, 0x30,
  0xBD, 0x02, 0x73, 0x0D, 0xD7, 0x30, 0x3D, 0x82, 0xE0, 0x23, 0x60, 0x20, 0xDD, 0x81, 0xB0, 0x6A,
  0x83, 0xCB, 0xAA, 0xCF, 0x81, 0x50, 0x6F, 0xE0, 0xD2, 0x06, 0xFD, 0x0E, 0x02, 0x20, 0x6F, 0xC0,
  0xB0, 0x23, 0x89, 0x21, 0x58, 0xBD, 0xEF, 0xEE, 0xB8, 0x35,
  // "k" (U+006B)
  0x09, 0xD0, 0x37, 0x71, 0x09, 0xD0, 0x37, 0x71, 0x09, 0xD0, 0x37, 0x71, 0x09, 0xD0, 0x37, 0x71,
  0x09, 0xD0, 0x37, 0x71, 0x09, 0xD0, 0x37, 0x71, 0x09, 0xD0, 0x37, 0x71, 0x09, 0xD0, 0x37, 0x71,
  0x09, 0xD0, 0x36, 0x04, 0xE8, 0x16, 0x09, 0xD0, 0x35, 0x02, 0x0E, 0xD0, 0x82, 0x09, 0xD0, 0x34,
  0x01, 0x0D, 0xD0, 0xA3, 0x09, 0xD0, 0x34, 0x0B, 0xD0, 0xC4, 0x09, 0xD0, 0x33, 0x09, 0xD0, 0xD0,
  0x14, 0x09, 0xD0, 0x32, 0x07, 0xD0, 0xE0, 0x25, 0x09, 0xD8, 0x12, 0x04, 0xE0, 0x36, 0x09, 0xD8,
  0x12, 0x2E, 0xD0, 0x57, 0x09, 0xD0, 0x10, 0xDD, 0x06, 0x71, 0x09, 0xC0, 0xE0, 0x9E, 0x02, 0x71,
  0x09, 0xFD, 0x0B, 0x71, 0x09, 0xFE, 0x06, 0x70, 0x9F, 0xE0, 0xE0, 0x26, 0x09, 0xF0, 0x70, 0x5D,
  0x0B, 0x60, 0x9D, 0x0E, 0x03, 0x20, 0xAD, 0x06, 0x50, 0x9D, 0x03, 0x30, 0x10, 0xEC, 0x0E, 0x02,
  0x40, 0x9D, 0x03, 0x40, 0x6D, 0x0B, 0x40, 0x9D, 0x03, 0x50, 0xBD, 0x06, 0x30, 0x9D, 0x03, 0x50,
  0x20, 0xEC, 0x0E, 0x01, 0x20, 0x9D, 0x03, 0x60, 0x7D, 0x0B, 0x20, 0x9D, 0x03, 0x70, 0xCD, 0x81,
  0x60, 0x9D, 0x03, 0x70, 0x2D, 0x0E, 0x01,
  // "l" (U+006C)
  0x10, 0x3F, 0xC0, 0x67, 0x03, 0xFC, 0x06, 0x70, 0x3F, 0xC0, 0x67, 0x02, 0xFC, 0x06, 0x72, 0x82,
  0x36, 0xAD, 0xE0, 0x67, 0x60, 0x6D, 0x06, 0x76, 0x06, 0xD0, 0x67, 0x60, 0x6D, 0x06, 0x76, 0x06,
  0xD0, 0x67, 0x60, 0x6D, 0x06, 0x76, 0x06, 0xD0, 0x67, 0x60, 0x6D, 0x06, 0x76, 0x06, 0xD0, 0x67,
  0x60, 0x6D, 0x06, 0x76, 0x06, 0xD0, 0x67, 0x60, 0x6D, 0x06, 0x76, 0x06, 0xD0, 0x67, 0x60, 0x6D,
  0x06, 0x76, 0x06, 0xD0, 0x67, 0x60, 0x6D, 0x06, 0x76, 0x06, 0xD0, 0x67, 0x60, 0x6D, 0x06, 0x76,
  0x06, 0xD0, 0x67, 0x60, 0x6D, 0x06, 0x76, 0x06, 0xD0, 0x67, 0x38, 0x22, 0x57, 0xCD, 0x82, 0xB7,
  0x41, 0x38, 0x15, 0xAD, 0xFF, 0x82, 0xEB, 0x99, 0xFF, 0xD0, 0x9F, 0xFD, 0x09, 0xFF, 0xD0,
  // "m" (U+006D)
  0x0C, 0xB8, 0x63, 0x03, 0xBE, 0xEC, 0x43, 0x86, 0x6C, 0xEE, 0x91, 0x0C, 0xB8, 0x17, 0x2E, 0xD8,
  0x14, 0x09, 0xD8, 0x1B, 0x0C, 0xB0, 0x0B, 0xE0, 0xB0, 0x4F, 0x02, 0x0C, 0xFD, 0x0D, 0xF0, 0x60,
  0xCD, 0x00, 0xBE, 0x81, 0xDA, 0xEC, 0x09, 0x0C, 0xC0, 0x92, 0x0B, 0xC0, 0xE2, 0x06, 0xC0, 0xA0,
  0xCC, 0x04, 0x20, 0x8C, 0x0A, 0x20, 0x3C, 0x0B, 0x0C, 0xC0, 0x32, 0x08, 0xC0, 0x82, 0x03, 0xC0,
  0x0C, 0xC0, 0x32, 0x08, 0xC0, 0x82, 0x03, 0xC0, 0x0C, 0xC0, 0x32, 0x08, 0xC0, 0x82, 0x03, 0xC0,
  0x0C, 0xC0, 0x32, 0x08, 0xC0, 0x82, 0x03, 0xC0, 0x0C, 0xC0, 0x32, 0x08, 0xC0, 0x82, 0x03, 0xC0,
  0x0C, 0xC0, 0x32, 0x08, 0xC0, 0x82, 0x03, 0xC0, 0x0C, 0xC0, 0x32, 0x08, 0xC0, 0x82, 0x03, 0xC0,
  0x0C, 0xC0, 0x32, 0x08, 0xC0, 0x82, 0x03, 0xC0, 0x0C, 0xC0, 0x32, 0x08, 0xC0, 0x82, 0x03, 0xC0,
  0x0C, 0xC0, 0x32, 0x08, 0xC0, 0x82, 0x03, 0xC0, 0x0C, 0xC0, 0x32, 0x08, 0xC0, 0x82, 0x03, 0xC0,
  0x0C, 0xC0, 0x32, 0x08, 0xC0, 0x82, 0x03, 0xC0, 0x0C, 0xC0, 0x32, 0x08, 0xC0, 0x82, 0x03, 0xC0,
  0x0C, 0xC0, 0x32, 0x08, 0xC0, 0x82, 0x03, 0xC0, 0x0C, 0xC0, 0x32, 0x08, 0xC0, 0x82, 0x03, 0xC0,
  0xC0,
  // "n" (U+006E)
  0x0C, 0xB0, 0xB3, 0x87, 0x38, 0xCE, 0xFE, 0xC8, 0x13, 0x0C, 0xC8, 0x11, 0x09, 0xFA, 0x06, 0x20,
  0xCC, 0x06, 0x0A, 0xFC, 0x81, 0x60, 0xCF, 0xFC, 0x01, 0x0C, 0xF9, 0x81, 0xBA, 0xCF, 0x07, 0x0C,
  0xE0, 0xD0, 0x23, 0x03, 0x0E, 0xD0, 0xB0, 0xCE, 0x02, 0x50, 0x5D, 0x0E, 0x0C, 0xD0, 0xA7, 0xE0,
  0xCD, 0x05, 0x70, 0xDD, 0x0C, 0xD0, 0x27, 0x0C, 0xD0, 0xCD, 0x71, 0x0C, 0xD0, 0xCD, 0x71, 0x0C,
  0xD0, 0xCD, 0x71, 0x0C, 0xD0, 0xCD, 0x71, 0x0C, 0xD0, 0xCD, 0x71, 0x0C, 0xD0, 0xCD, 0x71, 0x0C,
  0xD0, 0xCD, 0x71, 0x0C, 0xD0, 0xCD, 0x71, 0x0C, 0xD0, 0xCD, 0x71, 0x0C, 0xD0, 0xCD, 0x71, 0x0C,
  0xD0, 0xCD, 0x71, 0x0C, 0xD0, 0xCD, 0x71, 0x0C, 0xD0,
  // "o" (U+006F)
  0x68, 0x90, 0x27, 0xBD, 0xFE, 0xDB, 0x72, 0x73, 0x01, 0x09, 0xFB, 0x0A, 0x01, 0x70, 0x20, 0xDF,
  0xD0, 0xE0, 0x35, 0x01, 0x0D, 0xFF, 0x0E, 0x02, 0x40, 0xBE, 0x82, 0xEA, 0xAD, 0xE0, 0xC3, 0x03,
  0xE0, 0x74, 0x05, 0xE0, 0x42, 0x0A, 0xD0, 0x86, 0x07, 0xD0, 0xB2, 0x0E, 0xD0, 0x17, 0xD8, 0x1E,
  0x02, 0xD0, 0xB7, 0x10, 0xBD, 0x03, 0x05, 0xD0, 0x97, 0x10, 0x9D, 0x04, 0x05, 0xD0, 0x77, 0x10,
  0x7D, 0x05, 0x06, 0xD0, 0x77, 0x10, 0x7D, 0x00, 0x5D, 0x09, 0x71, 0x09, 0xD0, 0x50, 0x3D, 0x0B,
  0x71, 0x0B, 0xD0, 0x21, 0xE0, 0x17, 0xD0, 0xE2, 0x0B, 0xD0, 0x86, 0x07, 0xD0, 0xA2, 0x04, 0xE0,
  0x74, 0x05, 0xE0, 0x43, 0x0B, 0xE8, 0x2E, 0xAA, 0xDE, 0x0B, 0x40, 0x20, 0xEF, 0xF0, 0xE0, 0x25,
  0x03, 0x0E, 0xFD, 0x0E, 0x03, 0x70, 0x10, 0xAF, 0xB0, 0xB0, 0x17, 0x38, 0x22, 0x8B, 0xEA, 0x82,
  0xEB, 0x83, 0x60,
  // "p" (U+0070)
  0x0C, 0xB0, 0xB3, 0x86, 0x28, 0xCE, 0xFE, 0xB5, 0x50, 0xCC, 0x81, 0x10, 0x8F, 0x90, 0xC0, 0x13,
  0x0C, 0xC0, 0x60, 0xAF, 0xB0, 0xC3, 0x0C, 0xFF, 0xB0, 0x92, 0x0C, 0xF8, 0x2E, 0xBA, 0xCF, 0x81,
  0x20, 0xCE, 0x0A, 0x40, 0x4E, 0x81, 0x80, 0xCD, 0x0C, 0x60, 0x7D, 0x81, 0xC0, 0xCD, 0x04, 0x60,
  0x1E, 0x01, 0x0C, 0xD7, 0x10, 0xCD, 0x03, 0x0C, 0xC0, 0xE7, 0x10, 0xAD, 0x04, 0x0C, 0xC0, 0xD7,
  0x10, 0x9D, 0x05, 0x0C, 0xC0, 0xD7, 0x10, 0x9D, 0x05, 0x0C, 0xC0, 0xE7, 0x10, 0xAD, 0x04, 0x0C,
  0xD0, 0x17, 0x0C, 0xD0, 0x30, 0xCD, 0x06, 0x7E, 0x10, 0xCD, 0x0D, 0x60, 0x6D, 0x81, 0xD0, 0xCE,
  0x0A, 0x01, 0x30, 0x40, 0xED, 0x81, 0x70, 0xCF, 0x82, 0xEB, 0xAC, 0xF8, 0x12, 0x0C, 0xFF, 0xB0,
  0x82, 0x0C, 0xC0, 0xB0, 0xCF, 0xB0, 0xB3, 0x0C, 0xC8, 0x1B, 0x1A, 0xF9, 0x0A, 0x40, 0xCC, 0x0C,
  0x28, 0x63, 0x8C, 0xEE, 0xD9, 0x35, 0x0C, 0xC0, 0xD7, 0x71, 0x0C, 0xC0, 0xD7, 0x71, 0x0C, 0xC0,
  0xD7, 0x71, 0x0C, 0xC0, 0xD7, 0x71, 0x0C, 0xC0, 0xD7, 0x71, 0x0C, 0xC0, 0xD7, 0x71, 0x0C, 0xC0,
  0xD7, 0x71, 0x0C, 0xC0, 0xD7, 0x71, 0x0C, 0xC0, 0xD7, 0x71,
  // "q" (U+0071)
  0x58, 0x65, 0xAD, 0xFE, 0xD9, 0x33, 0x0B, 0xB0, 0xC3, 0x01, 0x0B, 0xF9, 0x0A, 0x01, 0x1C, 0x0C,
  0x30, 0xBF, 0xB0, 0xC0, 0x6C, 0x0C, 0x20, 0x9F, 0xFB, 0x81, 0xC0, 0x1F, 0x82, 0xDA, 0xAE, 0xF8,
  0x1C, 0x08, 0xE0, 0x64, 0x07, 0xE8, 0x1C, 0x0C, 0xD0, 0x86, 0x09, 0xD0, 0xC1, 0xE0, 0x16, 0x01,
  0xD0, 0xC0, 0x3D, 0x0D, 0x71, 0x0D, 0xC0, 0xC0, 0x4D, 0x0A, 0x71, 0x0A, 0xC0, 0xC0, 0x5D, 0x09,
  0x71, 0x09, 0xC0, 0xC0, 0x5D, 0x09, 0x71, 0x09, 0xC0, 0xC0, 0x4D, 0x0A, 0x71, 0x09, 0xC0, 0xC0,
  0x3D, 0x0C, 0x71, 0x0B, 0xC0, 0xC0, 0x1E, 0x01, 0x7D, 0x81, 0xC0, 0xCD, 0x07, 0x60, 0x7D, 0x81,
  0xC0, 0x8E, 0x05, 0x40, 0x5E, 0x81, 0xC0, 0x3F, 0x82, 0xDA, 0xAD, 0xF0, 0xC2, 0x0A, 0xFF, 0xB0,
  0xC2, 0x01, 0x0D, 0xFB, 0x09, 0x0A, 0xC0, 0xC3, 0x01, 0x0C, 0xF9, 0x81, 0x70, 0xCC, 0x0C, 0x58,
  0x65, 0xBE, 0xFE, 0xC7, 0x22, 0x0D, 0xC0, 0xC7, 0x71, 0x0D, 0xC0, 0xC7, 0x71, 0x0D, 0xC0, 0xC7,
  0x71, 0x0D, 0xC0, 0xC7, 0x71, 0x0D, 0xC0, 0xC7, 0x71, 0x0D, 0xC0, 0xC7, 0x71, 0x0D, 0xC0, 0xC7,
  0x71, 0x0D, 0xC0, 0xC7, 0x71, 0x0D, 0xC0, 0xC7, 0x71, 0x0D, 0xC0, 0xC0,
  // "r" (U+0072)
  0x10, 0x4F, 0x90, 0xC4, 0x81, 0x6B, 0xEA, 0x83, 0xDB, 0x20, 0x4F, 0xA2, 0x01, 0x0C, 0xF2, 0x04,
  0xFA, 0x81, 0x30, 0xCF, 0x0B, 0x20, 0x4F, 0xA0, 0x60, 0x9F, 0x90, 0x82, 0x03, 0x0E, 0xF9, 0x0D,
  0xFA, 0x04, 0x48, 0x21, 0x46, 0xDF, 0xF7, 0x10, 0xAF, 0x85, 0xC5, 0x10, 0x13, 0x57, 0x10, 0xAE,
  0x0A, 0x77, 0x10, 0xAD, 0x0E, 0x01, 0x77, 0x10, 0xAD, 0x08, 0x77, 0x20, 0xAD, 0x04, 0x77, 0x20,
  0xAD, 0x02, 0x77, 0x20, 0xAD, 0x01, 0x77, 0x20, 0xAD, 0x01, 0x77, 0x20, 0xAD, 0x01, 0x77, 0x20,
  0xAD, 0x01, 0x77, 0x20, 0xAD, 0x01, 0x77, 0x81, 0x36, 0xDD, 0x81, 0x95, 0x17, 0x18, 0x12, 0x9C,
  0xFD, 0x81, 0xEB, 0x75, 0x05, 0xFF, 0xA0, 0xD5, 0x05, 0xFF, 0xA0, 0xD5, 0x05, 0xFF, 0xA0, 0xD5,
  // "s" (U+0073)
  0x48, 0x92, 0x48, 0xBD, 0xEF, 0xED, 0xB8, 0x51, 0x40, 0x30, 0xCF, 0xD8, 0x2B, 0x50, 0x4F, 0xF9,
  0x81, 0x61, 0xEF, 0xF8, 0x1E, 0x06, 0xE8, 0x3C, 0xAA, 0xBD, 0xC8, 0x19, 0x09, 0xD0, 0x76, 0x84,
  0x48, 0xD2, 0x09, 0xD0, 0x67, 0x40, 0x7D, 0x0E, 0x06, 0x73, 0x02, 0xF8, 0x1E, 0x94, 0x71, 0x08,
  0xFA, 0x81, 0xE8, 0x16, 0x08, 0xFC, 0x09, 0x01, 0x50, 0x20, 0xAF, 0xB0, 0xD0, 0x26, 0x81, 0x18,
  0xEF, 0x90, 0xD7, 0x20, 0x40, 0xBF, 0x06, 0x73, 0x02, 0x0C, 0xD0, 0x90, 0x37, 0x30, 0x3D, 0x84,
  0xBC, 0xE9, 0x41, 0x60, 0x7D, 0x0B, 0x0C, 0xC8, 0x4E, 0xBA, 0xAA, 0xDE, 0x08, 0x0C, 0xFF, 0xA0,
  0x20, 0xCF, 0xF9, 0x81, 0x70, 0xBF, 0xE0, 0xD0, 0x53, 0x84, 0x26, 0x9C, 0xDE, 0xA8, 0x3E, 0xDB,
  0x84, 0x40,
  // "t" (U+0074)
  0x60, 0x48, 0x00, 0x77, 0x71, 0x0A, 0xB0, 0xE7, 0x71, 0x0C, 0xB0, 0xE7, 0x71, 0xC0, 0xE7, 0x70,
  0x2C, 0x0E, 0x77, 0x05, 0xC0, 0xE7, 0x38, 0x21, 0x58, 0xCF, 0xF0, 0x10, 0xCF, 0xFC, 0x01, 0x0D,
  0xFF, 0xC0, 0x10, 0xDF, 0xFC, 0x85, 0x18, 0x99, 0x99, 0xED, 0x80, 0x49, 0x01, 0x50, 0xDC, 0x0E,
  0x77, 0x0D, 0xC0, 0xE7, 0x70, 0xDC, 0x0E, 0x77, 0x0D, 0xC0, 0xE7, 0x70, 0xDC, 0x0E, 0x77, 0x0D,
  0xC0, 0xE7, 0x70, 0xDC, 0x0E, 0x77, 0x0D, 0xC0, 0xE7, 0x70, 0xDC, 0x0E, 0x77, 0x0D, 0xD7, 0x70,
  0xCD, 0x03, 0x76, 0x09, 0xD0, 0xC0, 0x15, 0x00, 0x15, 0x05, 0xF8, 0x5C, 0xAA, 0xCE, 0xF4, 0x60,
  0xEF, 0xD0, 0x46, 0x04, 0xFD, 0x04, 0x70, 0x40, 0xDF, 0xB0, 0x47, 0x28, 0x91, 0x5A, 0xDE, 0xFE,
  0xDC, 0x96, 0x10,
  // "u" (U+0075)
  0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C,
  0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C,
  0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x01, 0xD0,
  0xCD, 0x0C, 0x70, 0x2D, 0x0C, 0xD0, 0xD7, 0x04, 0xD0, 0xCE, 0x70, 0x9D, 0x0C, 0x0E, 0xD0, 0x45,
  0x01, 0x0E, 0xD0, 0xC0, 0xBD, 0x0C, 0x01, 0x30, 0x20, 0xCE, 0x0C, 0x07, 0xE8, 0x2E, 0xBA, 0xCF,
  0x90, 0xC0, 0x1F, 0xFC, 0x81, 0xC0, 0x6F, 0xC0, 0xB0, 0x7C, 0x0C, 0x20, 0x6F, 0xA8, 0x19, 0x01,
  0xC0, 0xC3, 0x87, 0x28, 0xCE, 0xFD, 0xC7, 0x23, 0x0B, 0xB0, 0xC0,
  // "v" (U+0076)
  0x0E, 0xD0, 0x37, 0x10, 0x1D, 0x0E, 0x0A, 0xD0, 0x87, 0x10, 0x6D, 0x0A, 0x04, 0xD0, 0xC7, 0x10,
  0xAD, 0x81, 0x40, 0xDD, 0x02, 0x7D, 0x0D, 0x20, 0x8D, 0x07, 0x60, 0x5D, 0x08, 0x20, 0x2D, 0x0C,
  0x60, 0x9D, 0x02, 0x30, 0xCD, 0x01, 0x50, 0xEC, 0x0C, 0x40, 0x6D, 0x06, 0x40, 0x4D, 0x06, 0x40,
  0x1D, 0x0B, 0x40, 0x8D, 0x01, 0x50, 0xAD, 0x01, 0x30, 0xDC, 0x0A, 0x60, 0x5D, 0x05, 0x20, 0x3D,
  0x04, 0x70, 0xEC, 0x0A, 0x20, 0x7C, 0x0E, 0x71, 0x09, 0xC0, 0xE2, 0x0C, 0xC0, 0x87, 0x10, 0x3D,
  0x04, 0x01, 0xD0, 0x37, 0x20, 0xDC, 0x08, 0x05, 0xC0, 0xC7, 0x30, 0x7C, 0x0B, 0x09, 0xC0, 0x77,
  0x30, 0x1C, 0x0E, 0x0B, 0xC0, 0x17, 0x40, 0xBF, 0x90, 0xB7, 0x50, 0x5F, 0x90, 0x57, 0x60, 0xEE,
  0x0E, 0x77, 0x09, 0xE0, 0x97, 0x70, 0x4E, 0x03, 0x70,
  // "w" (U+0077)
  0x0C, 0xC0, 0x67, 0x50, 0x5C, 0x0D, 0x0A, 0xC0, 0x87, 0x50, 0x6C, 0x0B, 0x08, 0xC0, 0x97, 0x50,
  0x7C, 0x08, 0x06, 0xC0, 0xB7, 0x50, 0x9C, 0x06, 0x03, 0xC0, 0xC3, 0x08, 0xC0, 0x93, 0x0A, 0xC0,
  0x40, 0x1C, 0x0D, 0x30, 0xBC, 0x0C, 0x30, 0xBC, 0x81, 0x20, 0xEC, 0x30, 0xED, 0x30, 0xCC, 0x20,
  0xCC, 0x20, 0x2E, 0x03, 0x20, 0xEB, 0x0D, 0x20, 0xAC, 0x81, 0x20, 0x5E, 0x06, 0x2C, 0x0B, 0x20,
  0x8C, 0x81, 0x30, 0x9E, 0x81, 0xA0, 0x1C, 0x09, 0x20, 0x6C, 0x81, 0x40, 0xCA, 0x00, 0xDA, 0x81,
  0xD0, 0x2C, 0x07, 0x20, 0x4C, 0x06, 0x1B, 0x00, 0xAB, 0x01, 0x03, 0xC0, 0x42, 0x02, 0xC0, 0x70,
  0x2B, 0x00, 0x8B, 0x03, 0x05, 0xC0, 0x23, 0xC0, 0x90, 0x5B, 0x00, 0x5B, 0x00, 0x6C, 0x40, 0xDB,
  0x0A, 0x08, 0xB0, 0x02, 0xB0, 0x90, 0x7B, 0x0D, 0x40, 0xBB, 0x0C, 0x0A, 0xA0, 0xE2, 0xB0, 0xC0,
  0x9B, 0x0B, 0x40, 0x8B, 0x0D, 0x0C, 0xA0, 0xC2, 0x0C, 0xA0, 0xE0, 0xAB, 0x09, 0x40, 0x6F, 0x09,
  0x20, 0x9B, 0x0E, 0xB0, 0x74, 0x04, 0xF0, 0x62, 0x06, 0xF0, 0x54, 0x02, 0xF0, 0x32, 0x03, 0xF0,
  0x35, 0xF4, 0xF6, 0x0D, 0xD0, 0xC4, 0x0D, 0xD0, 0xE3,
  // "x" (U+0078)
  0x07, 0xE0, 0x66, 0x01, 0x0E, 0xD8, 0x1C, 0x0C, 0xD0, 0xE6, 0x0A, 0xE8, 0x12, 0x02, 0xE0, 0x84,
  0x04, 0xE0, 0x73, 0x07, 0xE0, 0x23, 0x0C, 0xD0, 0xB5, 0x0B, 0xD0, 0xA2, 0x07, 0xD0, 0xE0, 0x15,
  0x02, 0x0E, 0xD8, 0x13, 0x1E, 0xD0, 0x57, 0x06, 0xD0, 0xC0, 0xAD, 0x0A, 0x72, 0x0B, 0xFB, 0x0E,
  0x01, 0x72, 0x01, 0x0E, 0xFA, 0x04, 0x74, 0x05, 0xF9, 0x09, 0x76, 0x0B, 0xE0, 0xD7, 0x60, 0x10,
  0xDF, 0x02, 0x75, 0x0A, 0xF9, 0x0C, 0x74, 0x05, 0xFB, 0x07, 0x72, 0x01, 0x0E, 0xD0, 0xED, 0x02,
  0x71, 0x0B, 0xD0, 0xA0, 0x7D, 0x0C, 0x70, 0x6D, 0x82, 0xE1, 0x0D, 0xD0, 0x75, 0x02, 0x0E, 0xD0,
  0x72, 0x04, 0xE0, 0x34, 0x0C, 0xD0, 0xD4, 0x0B, 0xD0, 0xC3, 0x07, 0xE0, 0x44, 0x03, 0xE8, 0x18,
  0x02, 0xE0, 0xA6, 0x09, 0xE0, 0x30, 0xCD, 0x0E, 0x01, 0x60, 0x10, 0xED, 0x0D,
  // "y" (U+0079)
  0x0E, 0xD0, 0x47, 0x10, 0x3D, 0x0E, 0x09, 0xD0, 0x97, 0x10, 0x7D, 0x0A, 0x03, 0xD0, 0xE7, 0x10,
  0xCD, 0x81, 0x40, 0xCD, 0x04, 0x60, 0x1D, 0x0D, 0x20, 0x6D, 0x09, 0x60, 0x6D, 0x08, 0x30, 0xEC,
  0x0E, 0x60, 0xAD, 0x02, 0x30, 0x9D, 0x04, 0x50, 0xEC, 0x0C, 0x40, 0x3D, 0x0A, 0x40, 0x4D, 0x06,
  0x50, 0xCC, 0x0E, 0x40, 0x9D, 0x01, 0x50, 0x6D, 0x04, 0x30, 0xDC, 0x0A, 0x70, 0xEC, 0x0A, 0x20,
  0x2D, 0x04, 0x70, 0x9C, 0x0E, 0x20, 0x7C, 0x0E, 0x71, 0x03, 0xD8, 0x14, 0x0C, 0xC0, 0x87, 0x20,
  0xCC, 0x09, 0x01, 0xD0, 0x37, 0x20, 0x6C, 0x0D, 0x05, 0xC0, 0xC7, 0x40, 0xEC, 0x09, 0xC0, 0x77,
  0x40, 0x9F, 0xA0, 0x17, 0x40, 0x3F, 0x90, 0xB7, 0x60, 0xCF, 0x05, 0x76, 0x06, 0xE0, 0xE7, 0x71,
  0x0E, 0xD0, 0x97, 0x71, 0x0A, 0xD0, 0x37, 0x71, 0x0E, 0xC0, 0xD7, 0x71, 0x06, 0xD0, 0x67, 0x70,
  0x10, 0xDC, 0x0E, 0x01, 0x76, 0x02, 0x0C, 0xD0, 0x77, 0x38, 0x28, 0xBA, 0xCE, 0x0D, 0x74, 0x09,
  0xFA, 0x04, 0x74, 0x09, 0xF9, 0x06, 0x75, 0x09, 0xE0, 0xE0, 0x47, 0x60, 0x70, 0xDA, 0x81, 0xEB,
  0x67, 0x70,
  // "z" (U+007A)
  0x10, 0xCF, 0xFB, 0x20, 0xCF, 0xFB, 0x20, 0xCF, 0xFB, 0x20, 0xCF, 0xFB, 0x20, 0x78, 0x05, 0x90,
  0xCE, 0x09, 0x74, 0x01, 0x0D, 0xD0, 0xB7, 0x50, 0xBD, 0x0D, 0x01, 0x74, 0x09, 0xD0, 0xE0, 0x27,
  0x40, 0x5E, 0x04, 0x74, 0x03, 0xE0, 0x77, 0x40, 0x10, 0xDD, 0x0A, 0x75, 0x0C, 0xD0, 0xC7, 0x50,
  0x9D, 0x0D, 0x01, 0x74, 0x06, 0xE0, 0x37, 0x40, 0x3E, 0x05, 0x74, 0x01, 0x0E, 0xD0, 0x87, 0x50,
  0xCD, 0x0A, 0x75, 0x09, 0xE0, 0xA8, 0x06, 0x90, 0x04, 0xFF, 0xC0, 0x06, 0xFF, 0xC0, 0x06, 0xFF,
  0xC0, 0x06, 0xFF, 0xC0, 0x60,
  // "{" (U+007B)
  0x78, 0x51, 0x6A, 0xCE, 0xF7, 0x60, 0x50, 0xED, 0x08, 0x50, 0x3F, 0x08, 0x50, 0x9F, 0x08, 0x50,
  0xDD, 0x81, 0xEB, 0x55, 0x0E, 0xC0, 0x97, 0x1D, 0x02, 0x71, 0xD7, 0x2D, 0x72, 0xD7, 0x2D, 0x72,
  0xD7, 0x10, 0x1D, 0x71, 0x05, 0xD7, 0x04, 0x0E, 0xC0, 0xD4, 0x81, 0x5A, 0xDE, 0x06, 0x40, 0x8F,
  0x08, 0x50, 0x8D, 0x08, 0x02, 0x60, 0x8E, 0x0B, 0x02, 0x50, 0x8F, 0x0E, 0x03, 0x58, 0x11, 0x4A,
  0xD0, 0xB7, 0x10, 0x9C, 0x0E, 0x71, 0x02, 0xD7, 0x2D, 0x72, 0xD7, 0x2D, 0x72, 0xD7, 0x2D, 0x72,
  0xD0, 0x17, 0x1D, 0x03, 0x71, 0x0E, 0xC8, 0x1D, 0x51, 0x60, 0xCF, 0x08, 0x50, 0x7F, 0x08, 0x50,
  0x10, 0xDE, 0x08, 0x60, 0x10, 0xAD, 0x08, 0x71, 0x84, 0x14, 0x78, 0x95,
  // "|" (U+007C)
  0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0,
  0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0,
  0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0,
  0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0,
  0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x30,
  // "}" (U+007D)
  0x84, 0x59, 0x87, 0x41, 0x71, 0x08, 0xD0, 0xA0, 0x16, 0x08, 0xE0, 0xD6, 0x08, 0xF0, 0x75, 0x08,
  0xF0, 0xC6, 0x81, 0x15, 0xDC, 0x0E, 0x71, 0x03, 0xD7, 0x10, 0x1D, 0x72, 0xD7, 0x2D, 0x72, 0xD7,
  0x2D, 0x72, 0xD7, 0x2D, 0x02, 0x71, 0xD0, 0x97, 0x10, 0xBD, 0x81, 0xA3, 0x15, 0x03, 0x0E, 0xF0,
  0x85, 0x03, 0x0B, 0xE0, 0x86, 0x02, 0x08, 0xD0, 0x85, 0x08, 0xF0, 0x84, 0x06, 0xE8, 0x1D, 0xB5,
  0x40, 0xDC, 0x0E, 0x04, 0x7D, 0x05, 0x71, 0xD0, 0x17, 0x1D, 0x72, 0xD7, 0x2D, 0x72, 0xD7, 0x2D,
  0x71, 0x02, 0xD7, 0x10, 0x9C, 0x0E, 0x58, 0x15, 0xBE, 0xD0, 0xD5, 0x08, 0xF0, 0x95, 0x08, 0xF0,
  0x35, 0x08, 0xD0, 0xE0, 0x56, 0x85, 0x7F, 0xEC, 0xA6, 0x17,
  // "~" (U+007E)
  0x38, 0x44, 0xAD, 0xC9, 0x37, 0x82, 0x9D, 0xD3, 0x20, 0x7E, 0x07, 0x60, 0xCA, 0x81, 0x20, 0x3F,
  0x90, 0x85, 0x0E, 0xA2, 0x09, 0xA8, 0x2A, 0x11, 0xBB, 0x08, 0x30, 0x3A, 0x0C, 0x20, 0xEA, 0x01,
  0x30, 0xAB, 0x09, 0x20, 0xBA, 0x81, 0x80, 0x2A, 0x0B, 0x50, 0x9C, 0x0E, 0xB8, 0x12, 0x04, 0xA0,
  0x96, 0x07, 0xE0, 0x62, 0x05, 0xA0, 0x87, 0x84, 0x3A, 0xEF, 0xC5, 0x30,
  // "¡" (U+00A1)
  0x18, 0x72, 0xAE, 0xEB, 0x20, 0x1E, 0xC8, 0x1E, 0x16, 0xE0, 0x70, 0x8E, 0x09, 0x06, 0xE8, 0x17,
  0x1E, 0xD8, 0x62, 0x03, 0xBE, 0xEB, 0x37, 0x74, 0x09, 0xC0, 0x82, 0x09, 0xC0, 0x92, 0x0A, 0xC0,
  0x92, 0x0B, 0xC0, 0xA2, 0x0B, 0xC0, 0xB2, 0x0C, 0xC0, 0xB2, 0x0D, 0xC0, 0xC2, 0x0D, 0xC0, 0xD2,
  0x0E, 0xC0, 0xD2, 0xD0, 0xE2, 0xE1, 0x01, 0xE1, 0x01, 0xE0, 0x10, 0x2E, 0x01, 0x03, 0xE0, 0x20,
  0x3E, 0x03, 0x04, 0xE0, 0x30, 0x5E, 0x04, 0x05, 0xE0, 0x50,
  // "¢" (U+00A2)
  0x73, 0xB0, 0x27, 0x71, 0xB0, 0x27, 0x71, 0xB0, 0x27, 0x58, 0x11, 0x58, 0xB8, 0x2B, 0xA8, 0x57,
  0x03, 0x0B, 0xFC, 0x0A, 0x40, 0x9F, 0xE0, 0xD3, 0x0A, 0xFF, 0x08, 0x20, 0x7F, 0xF9, 0x82, 0x30,
  0x1E, 0xD8, 0x1E, 0x73, 0x28, 0x31, 0x36, 0xAC, 0x20, 0x7D, 0x0C, 0x01, 0x74, 0x0B, 0xD0, 0x17,
  0x50, 0xEC, 0x0A, 0x75, 0x01, 0xD0, 0x67, 0x50, 0x2D, 0x05, 0x75, 0x02, 0xD0, 0x57, 0x50, 0x1D,
  0x06, 0x76, 0x0E, 0xC0, 0xA7, 0x60, 0xBD, 0x01, 0x75, 0x06, 0xD0, 0xC0, 0x17, 0x20, 0x22, 0x0E,
  0xD8, 0x1E, 0x73, 0x28, 0x41, 0x25, 0x9E, 0x92, 0x05, 0xFF, 0x90, 0x93, 0x09, 0xFF, 0x09, 0x40,
  0x70, 0xEF, 0xD0, 0x95, 0x81, 0x18, 0xDF, 0x98, 0x1D, 0x81, 0x71, 0x01, 0x04, 0xB8, 0x17, 0x31,
  0x76, 0xB0, 0x27, 0x71, 0xB0, 0x27, 0x71, 0xB0, 0x25,
  // "£" (U+00A3)
  0x78, 0x90, 0x39, 0xCE, 0xFE, 0xDB, 0x72, 0x70, 0x20, 0xBF, 0xB0, 0xC0, 0x14, 0x02, 0x0E, 0xFC,
  0x0D, 0x50, 0xCF, 0xD0, 0x84, 0x03, 0xE8, 0x3E, 0xBA, 0xBE, 0xA0, 0x24, 0x07, 0xD0, 0xA0, 0x14,
  0x04, 0x07, 0x50, 0x9D, 0x01, 0x75, 0x0A, 0xC0, 0xD7, 0x60, 0xBC, 0x0D, 0x76, 0x0B, 0xC0, 0xD7,
  0x60, 0xBC, 0x0D, 0x73, 0x82, 0x79, 0x9D, 0xC0, 0xE8, 0x02, 0x90, 0x43, 0x0C, 0xFF, 0x06, 0x30,
  0xCF, 0xF0, 0x63, 0x0C, 0xFF, 0x06, 0x30, 0xCF, 0xF0, 0x66, 0x0B, 0xC0, 0xD7, 0x60, 0xBC, 0x0D,
  0x76, 0x0B, 0xC0, 0xD7, 0x60, 0xBC, 0x0B, 0x76, 0x0E, 0xC0, 0x87, 0x50, 0x4C, 0x0E, 0x02, 0x74,
  0x03, 0x0E, 0xB0, 0xE0, 0x47, 0x40, 0x7D, 0x0C, 0x80, 0x79, 0x05, 0x0B, 0xFF, 0xB0, 0x90, 0xBF,
  0xFB, 0x09, 0x0B, 0xFF, 0xB0, 0x90, 0xBF, 0xFB, 0x09,
  // "¤" (U+00A4)
  0x20, 0x50, 0x97, 0x50, 0xA0, 0x43, 0x04, 0xA0, 0x92, 0x84, 0x27, 0x99, 0x62, 0x20, 0xAA, 0x81,
  0x40, 0x3C, 0x08, 0x0A, 0xE0, 0x09, 0xC8, 0x13, 0x2E, 0xFF, 0xA8, 0x3D, 0x10, 0x3E, 0xFF, 0x0E,
  0x02, 0x30, 0x4F, 0xF0, 0x34, 0x04, 0xC0, 0xB0, 0x32, 0x03, 0x0B, 0xC0, 0x34, 0x0B, 0xB0, 0xA6,
  0x0A, 0xB0, 0xA4, 0xC0, 0x26, 0x02, 0xC3, 0x02, 0xC7, 0x1C, 0x01, 0x20, 0x1C, 0x71, 0xC4, 0x0D,
  0xB0, 0x66, 0x06, 0xB0, 0xD4, 0x08, 0xC0, 0x64, 0x06, 0xC0, 0x74, 0x01, 0xD8, 0x2D, 0xBB, 0xDD,
  0x01, 0x40, 0xBF, 0xF0, 0x93, 0x09, 0xFF, 0xA8, 0x17, 0x05, 0xC0, 0xDF, 0xE8, 0x13, 0x09, 0xA8,
  0x3D, 0x12, 0x9D, 0xA8, 0x3C, 0x81, 0x3E, 0xA0, 0x83, 0x81, 0xAD, 0x17, 0x38, 0x13, 0xE9, 0x50,
  0x17, 0x50, 0x23,
  // "¥" (U+00A5)
  0x0B, 0xD0, 0x17, 0x10, 0x1D, 0x0B, 0x03, 0xD0, 0x87, 0x10, 0x8D, 0x81, 0x30, 0xBC, 0x0E, 0x01,
  0x60, 0x10, 0xEC, 0x0A, 0x20, 0x3D, 0x07, 0x60, 0x7D, 0x02, 0x30, 0xAC, 0x0E, 0x60, 0xEC, 0x09,
  0x40, 0x2D, 0x06, 0x40, 0x6D, 0x02, 0x50, 0xAC, 0x0D, 0x40, 0xDC, 0x09, 0x60, 0x2D, 0x05, 0x20,
  0x5C, 0x0E, 0x01, 0x70, 0x9C, 0x0C, 0x20, 0xCC, 0x08, 0x71, 0x01, 0xD0, 0x03, 0xC0, 0xE0, 0x17,
  0x20, 0x8C, 0x00, 0xBC, 0x07, 0x73, 0x01, 0x0E, 0xF9, 0x0E, 0x75, 0x08, 0xF9, 0x06, 0x75, 0x01,
  0x0E, 0xE0, 0xD7, 0x20, 0x7F, 0xFA, 0x07, 0x40, 0x7F, 0xFA, 0x07, 0x40, 0x7F, 0xFA, 0x07, 0x73,
  0x0B, 0xC0, 0xB7, 0x72, 0x0B, 0xC0, 0xB7, 0x72, 0x0B, 0xC0, 0xB7, 0x30, 0x7F, 0xFA, 0x07, 0x40,
  0x7F, 0xFA, 0x07, 0x40, 0x7F, 0xFA, 0x07, 0x73, 0x0B, 0xC0, 0xB7, 0x72, 0x0B, 0xC0, 0xB7, 0x72,
  0x0B, 0xC0, 0xB7, 0x72, 0x0B, 0xC0, 0xB7, 0x72, 0x0B, 0xC0, 0xB7, 0x10,
  // "¦" (U+00A6)
  0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0,
  0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0,
  0x38, 0x0C, 0x60, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03,
  0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03,
  0xC0, 0x03, 0xC0, 0x30,
  // "§" (U+00A7)
  0x48, 0x90, 0x5A, 0xDE, 0xFE, 0xDA, 0x72, 0x40, 0x50, 0xEF, 0xB8, 0x2C, 0x40, 0x7F, 0xE0, 0x40,
  0x2F, 0xE8, 0x1D, 0x07, 0xC8, 0x92, 0xE5, 0x10, 0x14, 0x8D, 0xF6, 0x08, 0xC0, 0x97, 0x05, 0x20,
  0x7C, 0x0C, 0x73, 0x02, 0xD0, 0xB0, 0x37, 0x20, 0x8E, 0x0C, 0x06, 0x71, 0x07, 0xF8, 0x1E, 0x81,
  0x50, 0x6F, 0xA0, 0xE0, 0x53, 0x08, 0xC0, 0xC0, 0xEE, 0x81, 0x80, 0x4C, 0x08, 0x20, 0x70, 0xED,
  0x05, 0x0A, 0xC4, 0x01, 0x0C, 0xC0, 0xB0, 0xCC, 0x50, 0x2C, 0x0D, 0x0B, 0xC0, 0x55, 0x0E, 0xB0,
  0xC0, 0x7C, 0x0E, 0x06, 0x4C, 0x81, 0x90, 0xCD, 0x82, 0xC4, 0x09, 0xB0, 0xE0, 0x22, 0x0A, 0xE0,
  0xDB, 0x0E, 0x04, 0x40, 0x40, 0xCF, 0x90, 0x77, 0x03, 0x0A, 0xF0, 0x67, 0x10, 0x10, 0x8E, 0x02,
  0x72, 0x02, 0x0E, 0xC0, 0x77, 0x30, 0x7C, 0x81, 0xA8, 0x37, 0x10, 0x9C, 0x85, 0xAD, 0xFD, 0x84,
  0x22, 0x02, 0x07, 0xD0, 0x70, 0xDF, 0xE8, 0x1E, 0x1D, 0xFE, 0x82, 0x40, 0x7E, 0xFB, 0x0C, 0x03,
  0x48, 0x25, 0x9C, 0xEA, 0x82, 0xEC, 0x94, 0x40,
  // "¨" (U+00A8)
  0x18, 0x35, 0xDE, 0xC3, 0x48, 0x52, 0xBE, 0xD7, 0x02, 0xC0, 0xE4, 0x0C, 0xC0, 0x05, 0xD0, 0x33,
  0xD0, 0x90, 0x5D, 0x03, 0x3D, 0x09, 0x01, 0xC0, 0xD4, 0x0B, 0xC8, 0x54, 0x04, 0xCE, 0xB3, 0x48,
  0x31, 0xAE, 0xD6, 0x10,
  // "©" (U+00A9)
  0x78, 0x65, 0x9B, 0xCC, 0xB9, 0x57, 0x50, 0x80, 0xEF, 0x90, 0xE0, 0x87, 0x10, 0x20, 0xDF, 0xD0,
  0xD0, 0x25, 0x03, 0x0E, 0xB8, 0x1A, 0x51, 0x28, 0x12, 0x5B, 0xB0, 0xE0, 0x23, 0x01, 0x0D, 0xA8,
  0x92, 0xE3, 0x03, 0x8B, 0xCB, 0x82, 0x3D, 0xA0, 0xD3, 0x09, 0xA8, 0x2E, 0x10, 0x8F, 0x81, 0x11,
  0xDA, 0x81, 0x80, 0x1B, 0x81, 0x40, 0x7F, 0x0C, 0x20, 0x3A, 0x81, 0xE1, 0x6A, 0x81, 0xB0, 0x1B,
  0x84, 0xC3, 0x02, 0x75, 0x30, 0x9A, 0x05, 0x0A, 0xA8, 0x15, 0x06, 0xB0, 0x17, 0x10, 0x4A, 0x0A,
  0x0D, 0xA8, 0x12, 0x0A, 0xA0, 0xA7, 0x20, 0x1A, 0x0C, 0x0E, 0xA2, 0x0B, 0xA0, 0x77, 0x3A, 0x00,
  0xEA, 0x20, 0xBA, 0x06, 0x73, 0xA0, 0xE0, 0xDA, 0x81, 0x10, 0xAA, 0x08, 0x72, 0x01, 0xA0, 0xD0,
  0xAA, 0x81, 0x40, 0x7A, 0x0D, 0x72, 0x04, 0xA0, 0xB0, 0x7A, 0x81, 0xA0, 0x2B, 0x09, 0x30, 0x10,
  0x43, 0x09, 0xA0, 0x70, 0x2B, 0x81, 0x20, 0xAC, 0x82, 0xDE, 0xFC, 0x20, 0x3B, 0x81, 0x20, 0xAA,
  0x0C, 0x20, 0xBE, 0x0C, 0x20, 0xDA, 0x0B, 0x20, 0x20, 0xEA, 0x89, 0x2C, 0x10, 0x6B, 0xEF, 0xDA,
  0x42, 0xDB, 0x02, 0x30, 0x5B, 0x81, 0xE7, 0x24, 0x81, 0x38, 0xEB, 0x05, 0x50, 0x5D, 0x81, 0xED,
  0xDD, 0x0E, 0x05, 0x70, 0x30, 0xCF, 0xB0, 0xB0, 0x27, 0x38, 0x23, 0x8C, 0xEA, 0x82, 0xEB, 0x72,
  0x60,
  // "ª" (U+00AA)
  0x38, 0x65, 0x9C, 0xEF, 0xEC, 0x75, 0x0D, 0xF9, 0x0D, 0x01, 0x30, 0x7B, 0x00, 0xDC, 0x09, 0x40,
  0x80, 0x33, 0x02, 0x0E, 0xB7, 0x30, 0x9B, 0x02, 0x38, 0x26, 0xAD, 0xEE, 0x82, 0x30, 0x3D, 0xFB,
  0x81, 0x30, 0xDC, 0x82, 0xDC, 0xCE, 0xB0, 0x30, 0x2B, 0x0E, 0x03, 0x30, 0x9B, 0x03, 0x04, 0xB0,
  0x94, 0x0C, 0xB0, 0x03, 0xB0, 0xC3, 0x09, 0xC8, 0x13, 0x0E, 0xB0, 0xE0, 0xDE, 0x81, 0x30, 0x5F,
  0x05, 0x0A, 0xA0, 0x32, 0x89, 0x24, 0xBE, 0xFD, 0x92, 0x05, 0xBB, 0x20,
  // "«" (U+00AB)
  0x68, 0x15, 0xB3, 0x60, 0xB0, 0x87, 0x10, 0x20, 0xEA, 0x0A, 0x02, 0x30, 0x8A, 0x0E, 0x07, 0x60,
  0xCC, 0x0B, 0x20, 0x4D, 0x04, 0x40, 0x9C, 0x83, 0xE2, 0x01, 0xEC, 0x0A, 0x40, 0x5D, 0x06, 0x20,
  0xCC, 0x0D, 0x01, 0x30, 0x20, 0xEC, 0x0A, 0x20, 0x8D, 0x04, 0x40, 0xCC, 0x82, 0xE1, 0x05, 0xD0,
  0x94, 0x09, 0xD8, 0x24, 0x02, 0xEC, 0x0D, 0x40, 0x5D, 0x09, 0x20, 0xCD, 0x03, 0x40, 0x6D, 0x08,
  0x20, 0xDD, 0x02, 0x50, 0xAD, 0x81, 0x40, 0x2D, 0x0C, 0x50, 0x10, 0xDC, 0x82, 0xD1, 0x06, 0xD0,
  0x85, 0x03, 0xD0, 0xA2, 0x09, 0xD0, 0x35, 0x06, 0xD0, 0x52, 0x0C, 0xC0, 0xD6, 0x0A, 0xC8, 0x3E,
  0x10, 0x2E, 0xC0, 0x96, 0x0D, 0xC0, 0xB2, 0x05, 0xD0, 0x45, 0x02, 0xB0, 0xB0, 0x33, 0x09, 0xA0,
  0xE0, 0x77, 0x81, 0x6C, 0x46, 0x81, 0xC9, 0x12,
  // "¬" (U+00AC)
  0x02, 0x80, 0x95, 0x90, 0x70, 0x3F, 0xFB, 0x0C, 0x03, 0xFF, 0xB0, 0xC0, 0x3F, 0xFB, 0x0C, 0x03,
  0xFF, 0xB0, 0xC7, 0x70, 0x7B, 0x0C, 0x77, 0x07, 0xB0, 0xC7, 0x70, 0x7B, 0x0C, 0x77, 0x07, 0xB0,
  0xC7, 0x70, 0x7B, 0x0C, 0x77, 0x07, 0xB0, 0xC7, 0x70, 0x7B, 0x0C,
  // "®" (U+00AE)
  0x78, 0x65, 0x9B, 0xCC, 0xB9, 0x57, 0x50, 0x80, 0xEF, 0x90, 0xE0, 0x87, 0x10, 0x20, 0xDF, 0xD0,
  0xD0, 0x25, 0x02, 0x0E, 0xB8, 0x1A, 0x51, 0x28, 0x12, 0x5B, 0xB0, 0xE0, 0x24, 0x0D, 0xA8, 0x5E,
  0x42, 0x22, 0x21, 0x30, 0x30, 0xDA, 0x0D, 0x30, 0x8A, 0x81, 0xE2, 0x4D, 0x84, 0xE9, 0x10, 0x1D,
  0xA8, 0x27, 0x01, 0xEA, 0x81, 0x50, 0x4F, 0x0D, 0x20, 0x3A, 0x81, 0xE0, 0x6A, 0x0C, 0x20, 0x4A,
  0x82, 0x80, 0x2D, 0xA0, 0x52, 0x0A, 0xA0, 0x50, 0xAA, 0x06, 0x20, 0x4A, 0x08, 0x20, 0x8A, 0x08,
  0x20, 0x5A, 0x09, 0x0C, 0xA0, 0x22, 0x04, 0xA0, 0x82, 0x09, 0xA0, 0x72, 0x01, 0xA0, 0xC0, 0xDA,
  0x01, 0x20, 0x4A, 0x82, 0x80, 0x4E, 0xA0, 0x43, 0xA0, 0x0D, 0xA3, 0x04, 0xF0, 0xB4, 0xA0, 0xD0,
  0xCA, 0x02, 0x20, 0x4E, 0x0C, 0x40, 0x2A, 0x0D, 0x0A, 0xA0, 0x52, 0x04, 0xA8, 0x18, 0x0B, 0xA0,
  0x23, 0x05, 0xA0, 0xA0, 0x6A, 0x0A, 0x20, 0x4A, 0x81, 0x80, 0x4A, 0x09, 0x30, 0xBA, 0x07, 0x01,
  0xB8, 0x12, 0x04, 0xA0, 0x82, 0x0D, 0xA8, 0x12, 0x03, 0xB8, 0x12, 0x09, 0xA8, 0x1C, 0x04, 0xA0,
  0x82, 0x07, 0xA8, 0x19, 0x0D, 0xA0, 0xA2, 0x01, 0x0E, 0xA8, 0x3C, 0x34, 0x42, 0x38, 0x24, 0x46,
  0xDB, 0x02, 0x30, 0x4B, 0x81, 0xE7, 0x24, 0x81, 0x38, 0xEB, 0x05, 0x50, 0x50, 0xEC, 0x81, 0xED,
  0xDE, 0x05, 0x70, 0x20, 0xBF, 0xB0, 0xB0, 0x27, 0x38, 0x23, 0x8C, 0xEA, 0x82, 0xEB, 0x72, 0x60,
  // "¯" (U+00AF)
  0xFD, 0x01, 0xFD, 0x01, 0xFD, 0x01, 0xFD, 0x01,
  // "°" (U+00B0)
  0x38, 0x61, 0x7C, 0xEE, 0xC7, 0x15, 0x03, 0x0E, 0xE0, 0xE0, 0x43, 0x02, 0x0E, 0xF9, 0x0E, 0x03,
  0x20, 0xBB, 0x82, 0x81, 0x17, 0xB8, 0x1C, 0x02, 0xB0, 0x94, 0x09, 0xB0, 0x20, 0x4B, 0x04, 0x40,
  0x4B, 0x05, 0x04, 0xB0, 0x44, 0x04, 0xB0, 0x50, 0x2B, 0x09, 0x40, 0x9B, 0x81, 0x30, 0xCB, 0x82,
  0x71, 0x17, 0xB0, 0xD2, 0x03, 0xFB, 0x04, 0x30, 0x40, 0xEF, 0x05, 0x58, 0x61, 0x7C, 0xEE, 0xD8,
  0x23,
  // "±" (U+00B1)
  0x70, 0x1C, 0x03, 0x77, 0x01, 0xC0, 0x37, 0x70, 0x1C, 0x03, 0x77, 0x01, 0xC0, 0x37, 0x70, 0x1C,
  0x03, 0x77, 0x01, 0xC0, 0x37, 0x70, 0x1C, 0x03, 0x70, 0x18, 0x02, 0x90, 0xAC, 0x0B, 0x80, 0x29,
  0x02, 0x01, 0xFF, 0xC0, 0x30, 0x1F, 0xFC, 0x03, 0x01, 0xFF, 0xC0, 0x30, 0x1F, 0xFC, 0x03, 0x70,
  0x1C, 0x03, 0x77, 0x01, 0xC0, 0x37, 0x70, 0x1C, 0x03, 0x77, 0x01, 0xC0, 0x37, 0x70, 0x1C, 0x03,
  0x77, 0x01, 0xC0, 0x37, 0x70, 0x1C, 0x03, 0x77, 0x76, 0x02, 0x80, 0x96, 0x90, 0x20, 0x3F, 0xFC,
  0x00, 0x3F, 0xFC, 0x00, 0x3F, 0xFC, 0x00, 0x3F, 0xFC, 0x03,
  // "²" (U+00B2)
  0x48, 0x23, 0x45, 0x36, 0x81, 0x19, 0xEC, 0x0E, 0x08, 0x30, 0x50, 0xEF, 0x90, 0xA2, 0x0A, 0xFB,
  0x89, 0x03, 0x01, 0xDF, 0x92, 0x03, 0xEB, 0x07, 0x20, 0x30, 0x64, 0x09, 0xB0, 0x87, 0x10, 0x9B,
  0x07, 0x71, 0x0D, 0xB0, 0x47, 0x07, 0xB0, 0xD7, 0x05, 0xC0, 0x46, 0x06, 0xC0, 0x66, 0x06, 0xC0,
  0x66, 0x07, 0xC0, 0x56, 0x07, 0xC0, 0x46, 0x07, 0xC0, 0xA8, 0x02, 0x50, 0x20, 0xDF, 0xC0, 0x60,
  0xDF, 0xC0, 0x60, 0xDF, 0xC0, 0x60,
  // "³" (U+00B3)
  0x28, 0x64, 0x9D, 0xEE, 0xD8, 0x22, 0x03, 0x0C, 0xF8, 0x2E, 0x40, 0xBF, 0xA8, 0x7E, 0x11, 0xEF,
  0xC7, 0x68, 0xC8, 0x25, 0x04, 0x54, 0x08, 0xB0, 0x67, 0x08, 0xB0, 0x45, 0x81, 0x15, 0xEA, 0x0C,
  0x30, 0x1E, 0x0B, 0x01, 0x30, 0x1D, 0x0B, 0x01, 0x40, 0x1F, 0x06, 0x48, 0x25, 0x56, 0x9C, 0x04,
  0x70, 0x5B, 0x0B, 0x70, 0x1B, 0x81, 0xEA, 0x35, 0x04, 0xB8, 0x7E, 0xEF, 0xC8, 0x66, 0x8E, 0xB0,
  0xB0, 0xEF, 0xB0, 0x40, 0xDF, 0xA0, 0x62, 0x87, 0x5A, 0xDE, 0xFE, 0xC8, 0x22,
  // "´" (U+00B4)
  0x30, 0x28, 0x02, 0x70, 0x13, 0x0B, 0xD0, 0xA3, 0x05, 0xD0, 0xA3, 0x01, 0x0E, 0xC0, 0x94, 0x0A,
  0xC0, 0x94, 0x06, 0xC0, 0x75, 0x0E, 0xB0, 0x56,
  // "µ" (U+00B5)
  0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C,
  0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C,
  0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x01, 0xD0,
  0xCD, 0x0C, 0x70, 0x2D, 0x0C, 0xD0, 0xD7, 0x04, 0xD0, 0xCE, 0x70, 0x9D, 0x0C, 0xE0, 0x45, 0x01,
  0x0E, 0xD0, 0xCE, 0x0C, 0x01, 0x30, 0x20, 0xCE, 0x0C, 0xF8, 0x2E, 0xBA, 0xCF, 0x90, 0xCF, 0xFD,
  0x0C, 0xFE, 0x0B, 0x07, 0xC0, 0xCF, 0xD8, 0x19, 0x01, 0xC0, 0xCF, 0x98, 0x2D, 0xC7, 0x23, 0x0B,
  0xB0, 0xCD, 0x0C, 0x77, 0xD0, 0xC7, 0x7D, 0x0C, 0x77, 0xD0, 0xC7, 0x7D, 0x0C, 0x77, 0xD0, 0xC7,
  0x7D, 0x0C, 0x77, 0xD0, 0xC7, 0x7D, 0x0C, 0x77,
  // "¶" (U+00B6)
  0x58, 0x23, 0x8B, 0xDF, 0xD3, 0x01, 0x0B, 0xFF, 0xA2, 0x02, 0x0E, 0xFF, 0xB2, 0x0D, 0xFD, 0x81,
  0x10, 0x1B, 0x10, 0x6F, 0xE8, 0x11, 0x01, 0xB1, 0x0C, 0xFE, 0x81, 0x10, 0x1B, 0x01, 0xFF, 0x81,
  0x10, 0x1B, 0x03, 0xFF, 0x81, 0x10, 0x1B, 0x05, 0xFF, 0x81, 0x10, 0x1B, 0x05, 0xFF, 0x81, 0x10,
  0x1B, 0x05, 0xFF, 0x81, 0x10, 0x1B, 0x04, 0xFF, 0x81, 0x10, 0x1B, 0x03, 0xFF, 0x81, 0x10, 0x1B,
  0x1F, 0xF8, 0x11, 0x01, 0xB1, 0x0B, 0xFE, 0x81, 0x10, 0x1B, 0x10, 0x4F, 0xE8, 0x11, 0x01, 0xB2,
  0x0A, 0xFD, 0x81, 0x10, 0x1B, 0x30, 0xAF, 0xC8, 0x11, 0x01, 0xB4, 0x05, 0x0C, 0xFA, 0x81, 0x10,
  0x1B, 0x68, 0x51, 0x45, 0x65, 0x2E, 0xA8, 0x11, 0x01, 0xB7, 0x50, 0xEA, 0x81, 0x10, 0x1B, 0x75,
  0x0E, 0xA8, 0x11, 0x01, 0xB7, 0x50, 0xEA, 0x81, 0x10, 0x1B, 0x75, 0x0E, 0xA8, 0x11, 0x01, 0xB7,
  0x50, 0xEA, 0x81, 0x10, 0x1B, 0x75, 0x0E, 0xA8, 0x11, 0x01, 0xB7, 0x50, 0xEA, 0x81, 0x10, 0x1B,
  0x75, 0x0E, 0xA8, 0x11, 0x01, 0xB7, 0x50, 0xEA, 0x81, 0x10, 0x1B, 0x75, 0x0E, 0xA8, 0x11, 0x01,
  0xB7, 0x50, 0xEA, 0x81, 0x10, 0x1B, 0x75, 0x0E, 0xA8, 0x11, 0x01, 0xB7, 0x50, 0xEA, 0x81, 0x10,
  0x1B, 0x75, 0x0E, 0xA8, 0x11, 0x01, 0xB7, 0x50, 0xEA, 0x81, 0x10, 0x1B,
  // "·" (U+00B7)
  0x18, 0x63, 0xBE, 0xEB, 0x20, 0x2D, 0x81, 0xE1, 0x7E, 0x06, 0x09, 0xE0, 0x80, 0x7E, 0x81, 0x61,
  0xEC, 0x87, 0xE1, 0x03, 0xBE, 0xEA, 0x21,
  // "¸" (U+00B8)
  0x28, 0x23, 0x77, 0x45, 0x0C, 0xA0, 0x44, 0x03, 0xB0, 0xB0, 0x43, 0x08, 0x0E, 0xC0, 0x74, 0x06,
  0xC0, 0x14, 0x0D, 0xB0, 0x40, 0x12, 0x04, 0xC8, 0x14, 0xFE, 0xE0, 0x1F, 0x82, 0x60, 0xBE, 0xA8,
  0x1D, 0xA3, 0x20,
  // "¹" (U+00B9)
  0x40, 0x30, 0xDA, 0x0A, 0x70, 0x8C, 0x0A, 0x50, 0x30, 0xDD, 0x0A, 0x40, 0x8F, 0x0A, 0x40, 0xCB,
  0x0B, 0xB0, 0xA4, 0x83, 0x3F, 0xE6, 0x1B, 0x0A, 0x58, 0x25, 0x10, 0x1B, 0x0A, 0x71, 0x02, 0xB0,
  0xA7, 0x10, 0x2B, 0x0A, 0x71, 0x02, 0xB0, 0xA7, 0x10, 0x2B, 0x0A, 0x71, 0x02, 0xB0, 0xA7, 0x10,
  0x2B, 0x0A, 0x71, 0x02, 0xB0, 0xA4, 0x83, 0x18, 0xAB, 0xDC, 0x83, 0xCB, 0x95, 0x2F, 0xC0, 0x90,
  0x2F, 0xC0, 0x90,
  // "º" (U+00BA)
  0x38, 0x51, 0x8C, 0xEE, 0xC7, 0x60, 0x30, 0xEE, 0x0D, 0x02, 0x30, 0x10, 0xEB, 0x0D, 0x0E, 0xB0,
  0xD0, 0x12, 0x09, 0xB0, 0x72, 0x08, 0xB0, 0x72, 0x0E, 0xA0, 0xE4, 0xB8, 0x1D, 0x01, 0xB0, 0xA4,
  0x0C, 0xB0, 0x10, 0x3B, 0x09, 0x40, 0xAB, 0x02, 0x03, 0xB0, 0x94, 0x0B, 0xB0, 0x20, 0x1B, 0x0A,
  0x40, 0xCB, 0x81, 0x10, 0xEA, 0x0E, 0x4B, 0x0D, 0x20, 0x8B, 0x07, 0x20, 0x9B, 0x08, 0x20, 0x10,
  0xEB, 0x0D, 0x0E, 0xB0, 0xE0, 0x13, 0x03, 0x0E, 0xE0, 0xE0, 0x35, 0x86, 0x18, 0xCE, 0xEC, 0x71,
  0x30,
  // "»" (U+00BB)
  0x28, 0x11, 0x9C, 0x68, 0x14, 0xC6, 0x70, 0x70, 0xEA, 0x09, 0x30, 0x30, 0xBB, 0x02, 0x50, 0x4D,
  0x05, 0x20, 0xBC, 0x0D, 0x60, 0x9C, 0x83, 0xE2, 0x01, 0xEC, 0x0A, 0x60, 0xDC, 0x0C, 0x20, 0x5D,
  0x06, 0x50, 0x3D, 0x09, 0x20, 0xAD, 0x03, 0x50, 0x8D, 0x82, 0x60, 0x1D, 0xC0, 0xD0, 0x15, 0x0C,
  0xC8, 0x2E, 0x20, 0x4D, 0x0A, 0x50, 0x2D, 0x0D, 0x20, 0x8D, 0x06, 0x40, 0x3D, 0x0C, 0x20, 0x9D,
  0x05, 0x40, 0xDC, 0x82, 0xE2, 0x04, 0xD0, 0x94, 0x09, 0xD8, 0x25, 0x01, 0xEC, 0x0C, 0x40, 0x4D,
  0x08, 0x20, 0xAC, 0x0E, 0x02, 0x30, 0x10, 0xDC, 0x0C, 0x20, 0x6D, 0x05, 0x40, 0xAC, 0x83, 0xE1,
  0x02, 0xEC, 0x09, 0x40, 0x4D, 0x04, 0x20, 0xBC, 0x0C, 0x60, 0x70, 0xEA, 0x08, 0x30, 0x20, 0xAA,
  0x0E, 0x02, 0x71, 0x08, 0x0B, 0x68, 0x13, 0xB5, 0x60,
  // "¼" (U+00BC)
  0x30, 0x30, 0xCA, 0x08, 0x77, 0x30, 0x20, 0xAC, 0x08, 0x77, 0x20, 0x5E, 0x08, 0x77, 0x20, 0x2B,
  0x0C, 0xA0, 0x87, 0x38, 0x00, 0x30, 0x22, 0x82, 0x8C, 0x28, 0xA0, 0x87, 0x20, 0x5B, 0x0E, 0x02,
  0x50, 0x9A, 0x08, 0x71, 0x02, 0x0E, 0xB0, 0x56, 0x09, 0xA0, 0x87, 0x10, 0xCB, 0x08, 0x70, 0x9A,
  0x08, 0x70, 0x9B, 0x0C, 0x71, 0x09, 0xA0, 0x86, 0x05, 0xB0, 0xE0, 0x27, 0x10, 0x9A, 0x08, 0x50,
  0x20, 0xEB, 0x04, 0x68, 0x24, 0x78, 0xDA, 0x82, 0xD8, 0x73, 0x20, 0xCB, 0x08, 0x70, 0xBF, 0x98,
  0x18, 0x09, 0xB0, 0xC7, 0x10, 0xBF, 0x90, 0x80, 0x5B, 0x0E, 0x01, 0x77, 0x30, 0x20, 0xEB, 0x04,
  0x77, 0x40, 0xCB, 0x08, 0x20, 0x10, 0xF3, 0x75, 0x09, 0xB0, 0xC3, 0x0D, 0xB7, 0x40, 0x5B, 0x0E,
  0x01, 0x20, 0x8C, 0x73, 0x02, 0x0E, 0xB0, 0x42, 0x03, 0xD7, 0x30, 0xDB, 0x08, 0x38, 0x1C, 0xFE,
  0xB7, 0x20, 0x9B, 0x0C, 0x30, 0x7A, 0x07, 0xB7, 0x10, 0x6B, 0x0E, 0x01, 0x28, 0x32, 0xEF, 0xB3,
  0xB7, 0x02, 0x0E, 0xB0, 0x43, 0x83, 0xBF, 0xE1, 0x3B, 0x70, 0xDB, 0x08, 0x30, 0x6A, 0x81, 0x60,
  0x3B, 0x60, 0xAB, 0x0B, 0x40, 0xEA, 0x81, 0xA9, 0xBB, 0x81, 0xA9, 0x12, 0x06, 0xB0, 0xE0, 0x14,
  0xFC, 0x01, 0x28, 0x00, 0x80, 0x35, 0xFC, 0x01, 0x77, 0x30, 0x3B, 0x77, 0x60, 0x3B, 0x77, 0x60,
  0x10, 0xF7, 0x30,
  // "½" (U+00BD)
  0x30, 0x30, 0xCA, 0x08, 0x77, 0x30, 0x20, 0xAC, 0x08, 0x77, 0x20, 0x5E, 0x08, 0x77, 0x20, 0x2B,
  0x0C, 0xA0, 0x87, 0x38, 0x00, 0x30, 0x22, 0x82, 0x8C, 0x28, 0xA0, 0x87, 0x20, 0x5B, 0x0E, 0x02,
  0x50, 0x9A, 0x08, 0x71, 0x02, 0x0E, 0xB0, 0x46, 0x09, 0xA0, 0x87, 0x10, 0xDB, 0x08, 0x70, 0x9A,
  0x08, 0x70, 0xAB, 0x0B, 0x71, 0x09, 0xA0, 0x86, 0x06, 0xB0, 0xD0, 0x17, 0x10, 0x9A, 0x08, 0x50,
  0x3C, 0x03, 0x68, 0x24, 0x78, 0xDA, 0x85, 0xD8, 0x73, 0x01, 0xDB, 0x07, 0x70, 0xBF, 0x98, 0x18,
  0x0B, 0xB0, 0xA7, 0x10, 0xBF, 0x90, 0x80, 0x7B, 0x0D, 0x77, 0x40, 0x4B, 0x0E, 0x02, 0x77, 0x30,
  0x10, 0xEB, 0x85, 0x52, 0x8B, 0xCB, 0x77, 0x50, 0xCB, 0x09, 0x08, 0xE0, 0xC0, 0x17, 0x20, 0x9B,
  0x81, 0xC2, 0xEF, 0x08, 0x71, 0x05, 0xB8, 0x7E, 0x20, 0x5F, 0x71, 0x1D, 0xA0, 0xC7, 0x02, 0x0E,
  0xB0, 0x43, 0x02, 0x30, 0x9A, 0x0C, 0x70, 0xDB, 0x08, 0x71, 0x0D, 0xA0, 0x96, 0x0A, 0xB0, 0xB7,
  0x10, 0x9B, 0x02, 0x50, 0x6B, 0x0D, 0x01, 0x70, 0x8B, 0x06, 0x50, 0x3C, 0x03, 0x70, 0x8B, 0x08,
  0x50, 0x10, 0xDB, 0x07, 0x70, 0x7B, 0x08, 0x60, 0xBB, 0x0A, 0x70, 0x7B, 0x07, 0x78, 0x00, 0x17,
  0x03, 0xC8, 0x01, 0xE0, 0x57, 0x60, 0x3F, 0xA0, 0x57, 0x60, 0x3F, 0xA0, 0x50,
  // "¾" (U+00BE)
  0x18, 0x52, 0x9D, 0xEE, 0xC7, 0x77, 0x10, 0x6F, 0x0C, 0x77, 0x84, 0x2E, 0xFD, 0xAC, 0xB0, 0x57,
  0x70, 0x04, 0x30, 0xDA, 0x06, 0x77, 0x40, 0x20, 0xEA, 0x03, 0x60, 0x3C, 0x03, 0x38, 0x15, 0xDD,
  0xB0, 0x96, 0x01, 0x0D, 0xB0, 0x74, 0x06, 0xC0, 0xB0, 0x16, 0x0A, 0xB0, 0xA5, 0x06, 0xD0, 0xE0,
  0x24, 0x07, 0xB0, 0xD0, 0x17, 0x10, 0x30, 0xDA, 0x09, 0x30, 0x3C, 0x03, 0x73, 0x08, 0xA0, 0xC2,
  0x01, 0x0D, 0xB0, 0x65, 0x85, 0x79, 0x41, 0x03, 0xDA, 0x0B, 0x20, 0xBB, 0x0A, 0x60, 0x8F, 0x98,
  0x16, 0x07, 0xB0, 0xD7, 0x07, 0xF8, 0x19, 0x04, 0xC0, 0x27, 0x18, 0x90, 0x59, 0xBC, 0xC9, 0x40,
  0x1E, 0xB0, 0x67, 0x73, 0x0B, 0xB0, 0x97, 0x73, 0x08, 0xB0, 0xC3, 0x07, 0x0F, 0xA7, 0x30, 0x4B,
  0x0E, 0x02, 0x20, 0x3C, 0x72, 0x02, 0x0E, 0xB0, 0x53, 0x0D, 0xC7, 0x20, 0xCB, 0x09, 0x30, 0x9D,
  0x71, 0x09, 0xB0, 0xC3, 0x04, 0xA0, 0x9B, 0x70, 0x5B, 0x0E, 0x02, 0x28, 0x31, 0xEF, 0xC3, 0xB6,
  0x02, 0x0E, 0xB0, 0x53, 0x0A, 0xA0, 0x20, 0x3B, 0x60, 0xCB, 0x08, 0x30, 0x5A, 0x81, 0x70, 0x3B,
  0x50, 0x9B, 0x0C, 0x40, 0xEA, 0x81, 0xA9, 0xBB, 0x83, 0xA9, 0x10, 0x6B, 0x0E, 0x01, 0x4F, 0xC8,
  0x51, 0x08, 0x88, 0x83, 0x5F, 0xC0, 0x17, 0x72, 0x03, 0xB7, 0x75, 0x03, 0xB7, 0x75, 0x01, 0x0F,
  0x73,
  // "¿" (U+00BF)
  0x78, 0x41, 0xAE, 0xEB, 0x37, 0x50, 0xDD, 0x02, 0x73, 0x05, 0xE0, 0x87, 0x30, 0x7E, 0x0A, 0x73,
  0x05, 0xE0, 0x87, 0x40, 0xDD, 0x03, 0x74, 0x84, 0x2A, 0xEE, 0xC4, 0x80, 0xD4, 0x08, 0x42, 0x55,
  0x55, 0x37, 0x50, 0x6C, 0x0B, 0x75, 0x08, 0xC0, 0xA7, 0x40, 0x10, 0xEC, 0x08, 0x73, 0x02, 0x0C,
  0xD0, 0x27, 0x20, 0x50, 0xED, 0x09, 0x72, 0x09, 0xE0, 0x97, 0x20, 0xBE, 0x06, 0x72, 0x0A, 0xD0,
  0xD0, 0x27, 0x20, 0x4D, 0x0C, 0x01, 0x73, 0x09, 0xD0, 0x37, 0x40, 0xBC, 0x0E, 0x75, 0x0C, 0xC0,
  0xE7, 0x20, 0x42, 0x0A, 0xD0, 0x85, 0x85, 0x38, 0xEF, 0x30, 0x6E, 0x83, 0xEB, 0xAB, 0xEC, 0x82,
  0xB0, 0x1E, 0xFF, 0x98, 0x23, 0x03, 0xEF, 0xF0, 0x82, 0x02, 0x0B, 0xFC, 0x0A, 0x03, 0x58, 0x90,
  0x48, 0xCD, 0xFE, 0xDC, 0x95, 0x40,
  // "À" (U+00C0)
  0x50, 0x48, 0x02, 0x77, 0x73, 0x02, 0x0D, 0xD0, 0x57, 0x73, 0x02, 0x0E, 0xC0, 0xE0, 0x17, 0x73,
  0x02, 0x0D, 0xC0, 0x97, 0x74, 0x02, 0x0D, 0xC0, 0x47, 0x74, 0x01, 0x0C, 0xB0, 0xE0, 0x17, 0x75,
  0x0A, 0xB0, 0x98, 0x09, 0xA4, 0x00, 0xDE, 0x0C, 0x77, 0x10, 0x2F, 0x90, 0x17, 0x70, 0x6F, 0x90,
  0x67, 0x70, 0xBF, 0x90, 0xA7, 0x70, 0xEF, 0x90, 0xE7, 0x60, 0x4C, 0x00, 0xBC, 0x03, 0x75, 0x08,
  0xC0, 0x08, 0xC0, 0x87, 0x50, 0xCC, 0x00, 0x4C, 0x0C, 0x74, 0x01, 0xD2, 0xD0, 0x17, 0x30, 0x6C,
  0x0C, 0x20, 0xCC, 0x05, 0x73, 0x0A, 0xC0, 0x82, 0x08, 0xC0, 0xA7, 0x30, 0xEC, 0x04, 0x20, 0x4C,
  0x0E, 0x72, 0x03, 0xD4, 0xD0, 0x37, 0x10, 0x8C, 0x0B, 0x40, 0xCC, 0x07, 0x71, 0x0C, 0xC0, 0x74,
  0x08, 0xC0, 0xC7, 0x01, 0xD0, 0x34, 0x04, 0xD0, 0x16, 0x05, 0xD8, 0x4A, 0x99, 0x99, 0xAD, 0x05,
  0x60, 0xAF, 0xFA, 0x09, 0x60, 0xEF, 0xFA, 0x0E, 0x50, 0x3F, 0xFC, 0x03, 0x40, 0x7F, 0xFC, 0x07,
  0x40, 0xBC, 0x0A, 0x71, 0x0C, 0xC0, 0xB3, 0x01, 0xD0, 0x67, 0x10, 0x8D, 0x30, 0x5D, 0x02, 0x71,
  0x04, 0xD0, 0x52, 0x09, 0xC0, 0xE7, 0x20, 0x1D, 0x09, 0x20, 0xDC, 0x0A, 0x73, 0x0C, 0xC8, 0x1D,
  0x02, 0xD0, 0x67, 0x30, 0x8D, 0x02, 0x07, 0xD0, 0x27, 0x30, 0x5D, 0x07,
  // "Á" (U+00C1)
  0x75, 0x02, 0x80, 0x27, 0x01, 0x77, 0x20, 0xBD, 0x0A, 0x77, 0x20, 0x5D, 0x0A, 0x77, 0x20, 0x10,
  0xEC, 0x09, 0x77, 0x30, 0xAC, 0x09, 0x77, 0x30, 0x6C, 0x07, 0x77, 0x40, 0xEB, 0x05, 0x80, 0x9A,
  0x60, 0x0D, 0xE0, 0xC7, 0x71, 0x02, 0xF9, 0x01, 0x77, 0x06, 0xF9, 0x06, 0x77, 0x0B, 0xF9, 0x0A,
  0x77, 0x0E, 0xF9, 0x0E, 0x76, 0x04, 0xC0, 0x0B, 0xC0, 0x37, 0x50, 0x8C, 0x00, 0x8C, 0x08, 0x75,
  0x0C, 0xC0, 0x04, 0xC0, 0xC7, 0x40, 0x1D, 0x2D, 0x01, 0x73, 0x06, 0xC0, 0xC2, 0x0C, 0xC0, 0x57,
  0x30, 0xAC, 0x08, 0x20, 0x8C, 0x0A, 0x73, 0x0E, 0xC0, 0x42, 0x04, 0xC0, 0xE7, 0x20, 0x3D, 0x4D,
  0x03, 0x71, 0x08, 0xC0, 0xB4, 0x0C, 0xC0, 0x77, 0x10, 0xCC, 0x07, 0x40, 0x8C, 0x0C, 0x70, 0x1D,
  0x03, 0x40, 0x4D, 0x01, 0x60, 0x5D, 0x84, 0xA9, 0x99, 0x9A, 0xD0, 0x56, 0x0A, 0xFF, 0xA0, 0x96,
  0x0E, 0xFF, 0xA0, 0xE5, 0x03, 0xFF, 0xC0, 0x34, 0x07, 0xFF, 0xC0, 0x74, 0x0B, 0xC0, 0xA7, 0x10,
  0xCC, 0x0B, 0x30, 0x1D, 0x06, 0x71, 0x08, 0xD3, 0x05, 0xD0, 0x27, 0x10, 0x4D, 0x05, 0x20, 0x9C,
  0x0E, 0x72, 0x01, 0xD0, 0x92, 0x0D, 0xC0, 0xA7, 0x30, 0xCC, 0x81, 0xD0, 0x2D, 0x06, 0x73, 0x08,
  0xD0, 0x20, 0x7D, 0x02, 0x73, 0x05, 0xD0, 0x70,
  // "Â" (U+00C2)
  0x72, 0x80, 0x27, 0x01, 0x77, 0x20, 0x6E, 0x0A, 0x77, 0x10, 0x20, 0xEF, 0x05, 0x77, 0x0C, 0xC0,
  0xDB, 0x0E, 0x02, 0x75, 0x09, 0xB8, 0x2E, 0x41, 0xDB, 0x0C, 0x74, 0x06, 0xB0, 0xE0, 0x32, 0x01,
  0x0C, 0xB0, 0xA7, 0x20, 0x2B, 0x0C, 0x02, 0x50, 0xAB, 0x05, 0x80, 0x9A, 0x00, 0x0D, 0xE0, 0xC7,
  0x71, 0x02, 0xF9, 0x01, 0x77, 0x06, 0xF9, 0x06, 0x77, 0x0B, 0xF9, 0x0A, 0x77, 0x0E, 0xF9, 0x0E,
  0x76, 0x04, 0xC0, 0x0B, 0xC0, 0x37, 0x50, 0x8C, 0x00, 0x8C, 0x08, 0x75, 0x0C, 0xC0, 0x04, 0xC0,
  0xC7, 0x40, 0x1D, 0x2D, 0x01, 0x73, 0x06, 0xC0, 0xC2, 0x0C, 0xC0, 0x57, 0x30, 0xAC, 0x08, 0x20,
  0x8C, 0x0A, 0x73, 0x0E, 0xC0, 0x42, 0x04, 0xC0, 0xE7, 0x20, 0x3D, 0x4D, 0x03, 0x71, 0x08, 0xC0,
  0xB4, 0x0C, 0xC0, 0x77, 0x10, 0xCC, 0x07, 0x40, 0x8C, 0x0C, 0x70, 0x1D, 0x03, 0x40, 0x4D, 0x01,
  0x60, 0x5D, 0x84, 0xA9, 0x99, 0x9A, 0xD0, 0x56, 0x0A, 0xFF, 0xA0, 0x96, 0x0E, 0xFF, 0xA0, 0xE5,
  0x03, 0xFF, 0xC0, 0x34, 0x07, 0xFF, 0xC0, 0x74, 0x0B, 0xC0, 0xA7, 0x10, 0xCC, 0x0B, 0x30, 0x1D,
  0x06, 0x71, 0x08, 0xD3, 0x05, 0xD0, 0x27, 0x10, 0x4D, 0x05, 0x20, 0x9C, 0x0E, 0x72, 0x01, 0xD0,
  0x92, 0x0D, 0xC0, 0xA7, 0x30, 0xCC, 0x81, 0xD0, 0x2D, 0x06, 0x73, 0x08, 0xD0, 0x20, 0x7D, 0x02,
  0x73, 0x05, 0xD0, 0x70,
  // "Ã" (U+00C3)
  0x68, 0x43, 0xBE, 0xEA, 0x44, 0x06, 0xA0, 0x87, 0x20, 0x20, 0xED, 0x83, 0xC5, 0x11, 0xDA, 0x06,
  0x72, 0x0A, 0xFE, 0x02, 0x71, 0x01, 0xFE, 0x0C, 0x72, 0x05, 0xA8, 0x3C, 0x11, 0x6D, 0xD0, 0xE0,
  0x37, 0x20, 0x7A, 0x06, 0x48, 0x44, 0xAE, 0xEB, 0x28, 0x09, 0xA2, 0x00, 0xDE, 0x0C, 0x77, 0x10,
  0x2F, 0x90, 0x17, 0x70, 0x6F, 0x90, 0x67, 0x70, 0xBF, 0x90, 0xA7, 0x70, 0xEF, 0x90, 0xE7, 0x60,
  0x4C, 0x00, 0xBC, 0x03, 0x75, 0x08, 0xC0, 0x08, 0xC0, 0x87, 0x50, 0xCC, 0x00, 0x4C, 0x0C, 0x74,
  0x01, 0xD2, 0xD0, 0x17, 0x30, 0x6C, 0x0C, 0x20, 0xCC, 0x05, 0x73, 0x0A, 0xC0, 0x82, 0x08, 0xC0,
  0xA7, 0x30, 0xEC, 0x04, 0x20, 0x4C, 0x0E, 0x72, 0x03, 0xD4, 0xD0, 0x37, 0x10, 0x8C, 0x0B, 0x40,
  0xCC, 0x07, 0x71, 0x0C, 0xC0, 0x74, 0x08, 0xC0, 0xC7, 0x01, 0xD0, 0x34, 0x04, 0xD0, 0x16, 0x05,
  0xD8, 0x4A, 0x99, 0x99, 0xAD, 0x05, 0x60, 0xAF, 0xFA, 0x09, 0x60, 0xEF, 0xFA, 0x0E, 0x50, 0x3F,
  0xFC, 0x03, 0x40, 0x7F, 0xFC, 0x07, 0x40, 0xBC, 0x0A, 0x71, 0x0C, 0xC0, 0xB3, 0x01, 0xD0, 0x67,
  0x10, 0x8D, 0x30, 0x5D, 0x02, 0x71, 0x04, 0xD0, 0x52, 0x09, 0xC0, 0xE7, 0x20, 0x1D, 0x09, 0x20,
  0xDC, 0x0A, 0x73, 0x0C, 0xC8, 0x1D, 0x02, 0xD0, 0x67, 0x30, 0x8D, 0x02, 0x07, 0xD0, 0x27, 0x30,
  0x5D, 0x07,
  // "Ä" (U+00C4)
  0x58, 0x35, 0xDE, 0xC3, 0x48, 0x32, 0xBE, 0xD7, 0x72, 0x02, 0xC0, 0xE4, 0x0C, 0xC0, 0x57, 0x10,
  0x5D, 0x03, 0x3D, 0x09, 0x71, 0x05, 0xD0, 0x33, 0xD0, 0x97, 0x10, 0x1C, 0x0D, 0x40, 0xBC, 0x04,
  0x72, 0x83, 0x4C, 0xEB, 0x34, 0x83, 0x1A, 0xED, 0x68, 0x09, 0xA1, 0x00, 0xDE, 0x0C, 0x77, 0x10,
  0x2F, 0x90, 0x17, 0x70, 0x6F, 0x90, 0x67, 0x70, 0xBF, 0x90, 0xA7, 0x70, 0xEF, 0x90, 0xE7, 0x60,
  0x4C, 0x00, 0xBC, 0x03, 0x75, 0x08, 0xC0, 0x08, 0xC0, 0x87, 0x50, 0xCC, 0x00, 0x4C, 0x0C, 0x74,
  0x01, 0xD2, 0xD0, 0x17, 0x30, 0x6C, 0x0C, 0x20, 0xCC, 0x05, 0x73, 0x0A, 0xC0, 0x82, 0x08, 0xC0,
  0xA7, 0x30, 0xEC, 0x04, 0x20, 0x4C, 0x0E, 0x72, 0x03, 0xD4, 0xD0, 0x37, 0x10, 0x8C, 0x0B, 0x40,
  0xCC, 0x07, 0x71, 0x0C, 0xC0, 0x74, 0x08, 0xC0, 0xC7, 0x01, 0xD0, 0x34, 0x04, 0xD0, 0x16, 0x05,
  0xD8, 0x4A, 0x99, 0x99, 0xAD, 0x05, 0x60, 0xAF, 0xFA, 0x09, 0x60, 0xEF, 0xFA, 0x0E, 0x50, 0x3F,
  0xFC, 0x03, 0x40, 0x7F, 0xFC, 0x07, 0x40, 0xBC, 0x0A, 0x71, 0x0C, 0xC0, 0xB3, 0x01, 0xD0, 0x67,
  0x10, 0x8D, 0x30, 0x5D, 0x02, 0x71, 0x04, 0xD0, 0x52, 0x09, 0xC0, 0xE7, 0x20, 0x1D, 0x09, 0x20,
  0xDC, 0x0A, 0x73, 0x0C, 0xC8, 0x1D, 0x02, 0xD0, 0x67, 0x30, 0x8D, 0x02, 0x07, 0xD0, 0x27, 0x30,
  0x5D, 0x07,
  // "Å" (U+00C5)
  0x72, 0x84, 0x6C, 0xFE, 0xB5, 0x77, 0x30, 0xBE, 0x09, 0x77, 0x10, 0x5B, 0x00, 0xEB, 0x04, 0x77,
  0x0A, 0xA0, 0x72, 0x09, 0xA0, 0xA7, 0x70, 0xCA, 0x01, 0x20, 0x3A, 0x0B, 0x77, 0x0A, 0xA0, 0x72,
  0x09, 0xA0, 0x97, 0x70, 0x5B, 0x00, 0xEB, 0x04, 0x77, 0x10, 0xAE, 0x09, 0x77, 0x38, 0x46, 0xCF,
  0xEC, 0x58, 0x09, 0xA5, 0x00, 0xDE, 0x0C, 0x77, 0x10, 0x2F, 0x90, 0x17, 0x70, 0x6F, 0x90, 0x67,
  0x70, 0xBF, 0x90, 0xA7, 0x70, 0xEF, 0x90, 0xE7, 0x60, 0x4C, 0x00, 0xBC, 0x03, 0x75, 0x08, 0xC0,
  0x08, 0xC0, 0x87, 0x50, 0xCC, 0x00, 0x4C, 0x0C, 0x74, 0x01, 0xD2, 0xD0, 0x17, 0x30, 0x6C, 0x0C,
  0x20, 0xCC, 0x05, 0x73, 0x0A, 0xC0, 0x82, 0x08, 0xC0, 0xA7, 0x30, 0xEC, 0x04, 0x20, 0x4C, 0x0E,
  0x72, 0x03, 0xD4, 0xD0, 0x37, 0x10, 0x8C, 0x0B, 0x40, 0xCC, 0x07, 0x71, 0x0C, 0xC0, 0x74, 0x08,
  0xC0, 0xC7, 0x01, 0xD0, 0x34, 0x04, 0xD0, 0x16, 0x05, 0xD8, 0x4A, 0x99, 0x99, 0xAD, 0x05, 0x60,
  0xAF, 0xFA, 0x09, 0x60, 0xEF, 0xFA, 0x0E, 0x50, 0x3F, 0xFC, 0x03, 0x40, 0x7F, 0xFC, 0x07, 0x40,
  0xBC, 0x0A, 0x71, 0x0C, 0xC0, 0xB3, 0x01, 0xD0, 0x67, 0x10, 0x8D, 0x30, 0x5D, 0x02, 0x71, 0x04,
  0xD0, 0x52, 0x09, 0xC0, 0xE7, 0x20, 0x1D, 0x09, 0x20, 0xDC, 0x0A, 0x73, 0x0C, 0xC8, 0x1D, 0x02,
  0xD0, 0x67, 0x30, 0x8D, 0x02, 0x07, 0xD0, 0x27, 0x30, 0x5D, 0x07,
  // "Æ" (U+00C6)
  0x70, 0xEF, 0xF0, 0xC6, 0x02, 0xFF, 0x90, 0xC6, 0x06, 0xFF, 0x90, 0xC6, 0x0A, 0xFF, 0x90, 0xC6,
  0x0D, 0xC0, 0x90, 0xDC, 0x84, 0xB9, 0x99, 0x97, 0x50, 0x2C, 0x81, 0xB0, 0x9C, 0x03, 0x73, 0x05,
  0xC8, 0x18, 0x09, 0xC0, 0x37, 0x30, 0x9C, 0x81, 0x50, 0x9C, 0x03, 0x73, 0x0D, 0xC8, 0x11, 0x09,
  0xC0, 0x37, 0x20, 0x1C, 0x0D, 0x20, 0x9C, 0x03, 0x72, 0x05, 0xC0, 0xA2, 0x09, 0xC0, 0x37, 0x20,
  0x9C, 0x07, 0x20, 0x9F, 0xA0, 0x14, 0x0C, 0xC0, 0x32, 0x09, 0xFA, 0x01, 0x30, 0x1D, 0x30, 0x9F,
  0xA0, 0x13, 0x05, 0xC0, 0xC3, 0x09, 0xFA, 0x01, 0x30, 0x8C, 0x09, 0x30, 0x9C, 0x0B, 0x80, 0x09,
  0x40, 0xCC, 0x83, 0xC9, 0x99, 0xDC, 0x03, 0x71, 0xFF, 0x03, 0x70, 0x4F, 0xF0, 0x37, 0x08, 0xFF,
  0x03, 0x70, 0xCF, 0xF0, 0x37, 0xD0, 0x34, 0x09, 0xC0, 0x36, 0x04, 0xC0, 0xE5, 0x09, 0xC0, 0x36,
  0x07, 0xC0, 0xB5, 0x09, 0xC8, 0x6B, 0x99, 0x99, 0x70, 0xBC, 0x08, 0x50, 0x9F, 0xA8, 0x1C, 0x0E,
  0xC0, 0x45, 0x09, 0xFA, 0x0C, 0x03, 0xD0, 0x15, 0x09, 0xFA, 0x0C, 0x07, 0xC0, 0xD6, 0x09, 0xFA,
  0x0C,
  // "Ç" (U+00C7)
  0x71, 0x89, 0x13, 0x8B, 0xDE, 0xFE, 0xDB, 0x73, 0x71, 0x06, 0x0D, 0xFC, 0x0D, 0x02, 0x40, 0x20,
  0xCF, 0xE0, 0xE4, 0x03, 0x0E, 0xFF, 0x08, 0x30, 0x10, 0xEF, 0x83, 0xCA, 0xAB, 0xDB, 0x01, 0x30,
  0xBE, 0x08, 0x01, 0x58, 0x12, 0x89, 0x30, 0x4E, 0x04, 0x76, 0x0B, 0xD0, 0x67, 0x60, 0x2D, 0x0E,
  0x77, 0x06, 0xD0, 0x87, 0x70, 0x9D, 0x04, 0x77, 0x0C, 0xD0, 0x17, 0x70, 0xED, 0x77, 0x10, 0xEC,
  0x0E, 0x77, 0x1D, 0x0D, 0x77, 0x1D, 0x0E, 0x77, 0x10, 0xED, 0x77, 0x10, 0xCD, 0x02, 0x77, 0x09,
  0xD0, 0x57, 0x70, 0x6D, 0x0A, 0x77, 0x01, 0xE0, 0x27, 0x70, 0xBD, 0x0C, 0x01, 0x76, 0x04, 0xE0,
  0xD0, 0x56, 0x82, 0x27, 0xD4, 0x30, 0xAF, 0x84, 0xEB, 0xAA, 0xBE, 0xB0, 0x43, 0x01, 0x0C, 0xFF,
  0x90, 0x44, 0x01, 0x0C, 0xFF, 0x04, 0x60, 0x70, 0xEF, 0xC0, 0xE0, 0x37, 0x10, 0x50, 0x9C, 0x83,
  0xED, 0xA7, 0x37, 0x50, 0xCA, 0x04, 0x77, 0x20, 0x3B, 0x0B, 0x04, 0x77, 0x10, 0x80, 0xEC, 0x07,
  0x77, 0x20, 0x6C, 0x01, 0x77, 0x20, 0xDB, 0x04, 0x75, 0x01, 0x20, 0x4C, 0x04, 0x75, 0x90, 0xEE,
  0x01, 0x75, 0xF0, 0x67, 0x60, 0xB0, 0xEA, 0x81, 0xDA, 0x37,
  // "È" (U+00C8)
  0x20, 0x48, 0x02, 0x77, 0x50, 0x20, 0xDD, 0x05, 0x75, 0x02, 0x0E, 0xC0, 0xE0, 0x17, 0x50, 0x20,
  0xDC, 0x09, 0x76, 0x02, 0x0D, 0xC0, 0x47, 0x60, 0x10, 0xCB, 0x0E, 0x01, 0x77, 0x0A, 0xB0, 0x98,
  0x0F, 0x30, 0x0C, 0xFF, 0xB0, 0x30, 0xCF, 0xFB, 0x03, 0x0C, 0xFF, 0xB0, 0x30, 0xCF, 0xFB, 0x03,
  0x0C, 0xC0, 0xE8, 0x09, 0x09, 0x02, 0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0C, 0x76, 0x0C, 0xC0, 0xC7,
  0x60, 0xCC, 0x0C, 0x76, 0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0C, 0x76, 0x0C, 0xFF, 0xA8, 0x19, 0x0C,
  0xFF, 0xA8, 0x19, 0x0C, 0xFF, 0xA8, 0x19, 0x0C, 0xFF, 0xA8, 0x19, 0x0C, 0xC0, 0xE8, 0x07, 0x98,
  0x15, 0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0C, 0x76, 0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0C, 0x76, 0x0C,
  0xC0, 0xC7, 0x60, 0xCC, 0x0C, 0x76, 0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0E, 0x80, 0x90, 0x90, 0x20,
  0xCF, 0xFB, 0x03, 0x0C, 0xFF, 0xB0, 0x30, 0xCF, 0xFB, 0x03, 0x0C, 0xFF, 0xB0, 0x30,
  // "É" (U+00C9)
  0x72, 0x02, 0x80, 0x27, 0x01, 0x74, 0x0B, 0xD0, 0xA7, 0x40, 0x5D, 0x0A, 0x74, 0x01, 0x0E, 0xC0,
  0x97, 0x50, 0xAC, 0x09, 0x75, 0x06, 0xC0, 0x77, 0x60, 0xEB, 0x05, 0x80, 0xF5, 0x00, 0xCF, 0xFB,
  0x03, 0x0C, 0xFF, 0xB0, 0x30, 0xCF, 0xFB, 0x03, 0x0C, 0xFF, 0xB0, 0x30, 0xCC, 0x0E, 0x80, 0x90,
  0x90, 0x20, 0xCC, 0x0C, 0x76, 0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0C, 0x76, 0x0C, 0xC0, 0xC7, 0x60,
  0xCC, 0x0C, 0x76, 0x0C, 0xC0, 0xC7, 0x60, 0xCF, 0xFA, 0x81, 0x90, 0xCF, 0xFA, 0x81, 0x90, 0xCF,
  0xFA, 0x81, 0x90, 0xCF, 0xFA, 0x81, 0x90, 0xCC, 0x0E, 0x80, 0x79, 0x81, 0x50, 0xCC, 0x0C, 0x76,
  0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0C, 0x76, 0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0C, 0x76, 0x0C, 0xC0,
  0xC7, 0x60, 0xCC, 0x0C, 0x76, 0x0C, 0xC0, 0xE8, 0x09, 0x09, 0x02, 0x0C, 0xFF, 0xB0, 0x30, 0xCF,
  0xFB, 0x03, 0x0C, 0xFF, 0xB0, 0x30, 0xCF, 0xFB, 0x03,
  // "Ê" (U+00CA)
  0x68, 0x02, 0x70, 0x17, 0x40, 0x6E, 0x0A, 0x73, 0x02, 0x0E, 0xF0, 0x57, 0x20, 0xCC, 0x0D, 0xB0,
  0xE0, 0x27, 0x09, 0xB8, 0x2E, 0x41, 0xDB, 0x0C, 0x60, 0x6B, 0x0E, 0x03, 0x20, 0x10, 0xCB, 0x0A,
  0x40, 0x2B, 0x0C, 0x02, 0x50, 0xAB, 0x05, 0x80, 0xE7, 0x00, 0xCF, 0xFB, 0x03, 0x0C, 0xFF, 0xB0,
  0x30, 0xCF, 0xFB, 0x03, 0x0C, 0xFF, 0xB0, 0x30, 0xCC, 0x0E, 0x80, 0x90, 0x90, 0x20, 0xCC, 0x0C,
  0x76, 0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0C, 0x76, 0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0C, 0x76, 0x0C,
  0xC0, 0xC7, 0x60, 0xCF, 0xFA, 0x81, 0x90, 0xCF, 0xFA, 0x81, 0x90, 0xCF, 0xFA, 0x81, 0x90, 0xCF,
  0xFA, 0x81, 0x90, 0xCC, 0x0E, 0x80, 0x79, 0x81, 0x50, 0xCC, 0x0C, 0x76, 0x0C, 0xC0, 0xC7, 0x60,
  0xCC, 0x0C, 0x76, 0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0C, 0x76, 0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0C,
  0x76, 0x0C, 0xC0, 0xE8, 0x09, 0x09, 0x02, 0x0C, 0xFF, 0xB0, 0x30, 0xCF, 0xFB, 0x03, 0x0C, 0xFF,
  0xB0, 0x30, 0xCF, 0xFB, 0x03,
  // "Ë" (U+00CB)
  0x28, 0x35, 0xDE, 0xC3, 0x48, 0x32, 0xBE, 0xD7, 0x40, 0x2C, 0x0E, 0x40, 0xCC, 0x05, 0x30, 0x5D,
  0x03, 0x3D, 0x09, 0x30, 0x5D, 0x03, 0x3D, 0x09, 0x30, 0x1C, 0x0D, 0x40, 0xBC, 0x04, 0x48, 0x34,
  0xCE, 0xB3, 0x48, 0x31, 0xAE, 0xD6, 0x80, 0xF0, 0x00, 0xCF, 0xFB, 0x03, 0x0C, 0xFF, 0xB0, 0x30,
  0xCF, 0xFB, 0x03, 0x0C, 0xFF, 0xB0, 0x30, 0xCC, 0x0E, 0x80, 0x90, 0x90, 0x20, 0xCC, 0x0C, 0x76,
  0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0C, 0x76, 0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0C, 0x76, 0x0C, 0xC0,
  0xC7, 0x60, 0xCF, 0xFA, 0x81, 0x90, 0xCF, 0xFA, 0x81, 0x90, 0xCF, 0xFA, 0x81, 0x90, 0xCF, 0xFA,
  0x81, 0x90, 0xCC, 0x0E, 0x80, 0x79, 0x81, 0x50, 0xCC, 0x0C, 0x76, 0x0C, 0xC0, 0xC7, 0x60, 0xCC,
  0x0C, 0x76, 0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0C, 0x76, 0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0C, 0x76,
  0x0C, 0xC0, 0xE8, 0x09, 0x09, 0x02, 0x0C, 0xFF, 0xB0, 0x30, 0xCF, 0xFB, 0x03, 0x0C, 0xFF, 0xB0,
  0x30, 0xCF, 0xFB, 0x03,
  // "Ì" (U+00CC)
  0x20, 0x48, 0x02, 0x77, 0x40, 0x20, 0xDD, 0x05, 0x74, 0x02, 0x0E, 0xC0, 0xE0, 0x17, 0x40, 0x20,
  0xDC, 0x09, 0x75, 0x02, 0x0D, 0xC0, 0x47, 0x50, 0x10, 0xCB, 0x0E, 0x01, 0x76, 0x0A, 0xB0, 0x98,
  0x0E, 0x70, 0x06, 0xFF, 0xA0, 0x06, 0xFF, 0xA0, 0x06, 0xFF, 0xA0, 0x06, 0xFF, 0xA8, 0x66, 0x02,
  0x46, 0x79, 0xEC, 0x84, 0xE9, 0x76, 0x42, 0x70, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC,
  0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75,
  0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0,
  0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50,
  0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x18, 0x31, 0x35, 0x6E, 0xC8, 0x3D, 0x65, 0x31, 0x20, 0x5F,
  0xFA, 0x05, 0x06, 0xFF, 0xA0, 0x06, 0xFF, 0xA0, 0x06, 0xFF, 0xA0, 0x60,
  // "Í" (U+00CD)
  0x72, 0x02, 0x80, 0x27, 0x01, 0x73, 0x0B, 0xD0, 0xA7, 0x30, 0x5D, 0x0A, 0x73, 0x01, 0x0E, 0xC0,
  0x97, 0x40, 0xAC, 0x09, 0x74, 0x06, 0xC0, 0x77, 0x50, 0xEB, 0x05, 0x80, 0xF1, 0x00, 0x6F, 0xFA,
  0x00, 0x6F, 0xFA, 0x00, 0x6F, 0xFA, 0x00, 0x6F, 0xFA, 0x86, 0x60, 0x24, 0x67, 0x9E, 0xC8, 0x4E,
  0x97, 0x64, 0x27, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B,
  0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D,
  0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7,
  0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC,
  0x0B, 0x71, 0x83, 0x13, 0x56, 0xEC, 0x83, 0xD6, 0x53, 0x12, 0x05, 0xFF, 0xA0, 0x50, 0x6F, 0xFA,
  0x00, 0x6F, 0xFA, 0x00, 0x6F, 0xFA, 0x06,
  // "Î" (U+00CE)
  0x68, 0x02, 0x70, 0x17, 0x30, 0x6E, 0x0A, 0x72, 0x02, 0x0E, 0xF0, 0x57, 0x10, 0xCC, 0x0D, 0xB0,
  0xE0, 0x26, 0x09, 0xB8, 0x2E, 0x41, 0xDB, 0x0C, 0x50, 0x6B, 0x0E, 0x03, 0x20, 0x10, 0xCB, 0x0A,
  0x30, 0x2B, 0x0C, 0x02, 0x50, 0xAB, 0x05, 0x80, 0xE3, 0x00, 0x6F, 0xFA, 0x00, 0x6F, 0xFA, 0x00,
  0x6F, 0xFA, 0x00, 0x6F, 0xFA, 0x86, 0x60, 0x24, 0x67, 0x9E, 0xC8, 0x4E, 0x97, 0x64, 0x27, 0x0D,
  0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7,
  0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC,
  0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75,
  0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x71, 0x83, 0x13,
  0x56, 0xEC, 0x83, 0xD6, 0x53, 0x12, 0x05, 0xFF, 0xA0, 0x50, 0x6F, 0xFA, 0x00, 0x6F, 0xFA, 0x00,
  0x6F, 0xFA, 0x06,
  // "Ï" (U+00CF)
  0x28, 0x35, 0xDE, 0xC3, 0x48, 0x32, 0xBE, 0xD7, 0x30, 0x2C, 0x0E, 0x40, 0xCC, 0x05, 0x20, 0x5D,
  0x03, 0x3D, 0x09, 0x20, 0x5D, 0x03, 0x3D, 0x09, 0x20, 0x1C, 0x0D, 0x40, 0xBC, 0x04, 0x38, 0x34,
  0xCE, 0xB3, 0x48, 0x31, 0xAE, 0xD6, 0x80, 0xE4, 0x00, 0x6F, 0xFA, 0x00, 0x6F, 0xFA, 0x00, 0x6F,
  0xFA, 0x00, 0x6F, 0xFA, 0x86, 0x60, 0x24, 0x67, 0x9E, 0xC8, 0x4E, 0x97, 0x64, 0x27, 0x0D, 0xC0,
  0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50,
  0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B,
  0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D,
  0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x71, 0x83, 0x13, 0x56,
  0xEC, 0x83, 0xD6, 0x53, 0x12, 0x05, 0xFF, 0xA0, 0x50, 0x6F, 0xFA, 0x00, 0x6F, 0xFA, 0x00, 0x6F,
  0xFA, 0x06,
  // "Ð" (U+00D0)
  0x10, 0x3F, 0xA8, 0x3E, 0xDB, 0x62, 0x71, 0x03, 0xFF, 0x0A, 0x02, 0x60, 0x3F, 0xFA, 0x05, 0x50,
  0x3F, 0xFB, 0x07, 0x40, 0x3D, 0x84, 0xC9, 0x9A, 0xBE, 0xF0, 0x43, 0x03, 0xD0, 0x85, 0x05, 0x0E,
  0xD0, 0xE3, 0x03, 0xD0, 0x86, 0x02, 0x0E, 0xD0, 0x62, 0x03, 0xD0, 0x87, 0x05, 0xD0, 0xD2, 0x03,
  0xD0, 0x87, 0x10, 0xDD, 0x81, 0x20, 0x3D, 0x08, 0x71, 0x08, 0xD8, 0x15, 0x03, 0xD0, 0x87, 0x10,
  0x5D, 0x81, 0x80, 0x3D, 0x08, 0x71, 0x03, 0xD0, 0xAF, 0xC0, 0xB4, 0x02, 0xD0, 0xBF, 0xC0, 0xB4,
  0x01, 0xD0, 0xCF, 0xC0, 0xB4, 0x01, 0xD0, 0xBF, 0xC0, 0xB4, 0x02, 0xD8, 0x1A, 0x9B, 0xD8, 0x3C,
  0x99, 0x97, 0x40, 0x4D, 0x81, 0x90, 0x3D, 0x08, 0x71, 0x06, 0xD8, 0x17, 0x03, 0xD0, 0x87, 0x10,
  0xAD, 0x81, 0x30, 0x3D, 0x08, 0x71, 0x0E, 0xD2, 0x03, 0xD0, 0x87, 0x07, 0xD0, 0xA2, 0x03, 0xD0,
  0x86, 0x04, 0xE0, 0x32, 0x03, 0xD0, 0x84, 0x01, 0x07, 0xE0, 0xB3, 0x03, 0xD8, 0x3C, 0x99, 0xAC,
  0xF0, 0xE0, 0x13, 0x03, 0xFF, 0xA0, 0xE0, 0x34, 0x03, 0xFF, 0x90, 0xD0, 0x25, 0x03, 0xFE, 0x0E,
  0x07, 0x70, 0x3F, 0xA8, 0x3D, 0xC9, 0x51, 0x70,
  // "Ñ" (U+00D1)
  0x58, 0x43, 0xBE, 0xEA, 0x44, 0x06, 0xA0, 0x87, 0x02, 0x0E, 0xD8, 0x3C, 0x51, 0x1D, 0xA0, 0x67,
  0x0A, 0xFE, 0x02, 0x60, 0x1F, 0xE0, 0xC7, 0x05, 0xA8, 0x3C, 0x11, 0x6D, 0xD0, 0xE0, 0x37, 0x07,
  0xA0, 0x64, 0x84, 0x4A, 0xEE, 0xB2, 0x80, 0x98, 0x30, 0x03, 0xF0, 0xD7, 0x0E, 0xC0, 0x03, 0xF9,
  0x02, 0x60, 0xEC, 0x00, 0x3F, 0x90, 0x86, 0x0E, 0xC0, 0x03, 0xF9, 0x0D, 0x60, 0xEC, 0x00, 0x3F,
  0xA0, 0x25, 0x0E, 0xC0, 0x03, 0xC0, 0xDC, 0x08, 0x50, 0xEC, 0x00, 0x3C, 0x0A, 0x0E, 0xB0, 0xD5,
  0x0E, 0xC0, 0x03, 0xC0, 0xA0, 0x9C, 0x02, 0x40, 0xEC, 0x00, 0x3C, 0x0B, 0x03, 0xC0, 0x74, 0x0E,
  0xC0, 0x03, 0xC8, 0x1C, 0x0E, 0xB0, 0xD4, 0x0E, 0xC0, 0x03, 0xC8, 0x1D, 0x09, 0xC0, 0x23, 0x0E,
  0xC0, 0x03, 0xC8, 0x1D, 0x03, 0xC0, 0x73, 0x0E, 0xC0, 0x03, 0xC0, 0xE2, 0x0E, 0xB0, 0xD3, 0x0E,
  0xC0, 0x03, 0xC0, 0xE2, 0x09, 0xC0, 0x22, 0x0E, 0xC0, 0x03, 0xC0, 0xE2, 0x03, 0xC0, 0x72, 0x0E,
  0xC0, 0x03, 0xC0, 0xE3, 0x0E, 0xB0, 0xD2, 0x0E, 0xC0, 0x03, 0xC0, 0xE3, 0x09, 0xC8, 0x12, 0x0E,
  0xC0, 0x03, 0xC0, 0xE3, 0x04, 0xC8, 0x17, 0x0E, 0xC0, 0x03, 0xC0, 0xE4, 0x0E, 0xB8, 0x1D, 0x0D,
  0xC0, 0x03, 0xC0, 0xE4, 0x09, 0xC0, 0x20, 0xDC, 0x00, 0x3C, 0x0E, 0x40, 0x4C, 0x07, 0x0C, 0xC0,
  0x03, 0xC0, 0xE5, 0x0E, 0xB0, 0xD0, 0xBC, 0x00, 0x3C, 0x0E, 0x50, 0x9C, 0x0D, 0xC0, 0x03, 0xC0,
  0xE5, 0x04, 0xFA, 0x00, 0x3C, 0x0E, 0x60, 0xEF, 0x90, 0x03, 0xC0, 0xE6, 0x09, 0xF9, 0x00, 0x3C,
  0x0E, 0x60, 0x4F, 0x90, 0x03, 0xC0, 0xE7, 0x0E, 0xF0, 0x30,
  // "Ò" (U+00D2)
  0x40, 0x48, 0x02, 0x77, 0x71, 0x02, 0x0D, 0xD0, 0x57, 0x71, 0x02, 0x0E, 0xC0, 0xE0, 0x17, 0x71,
  0x02, 0x0D, 0xC0, 0x97, 0x72, 0x02, 0x0D, 0xC0, 0x47, 0x72, 0x01, 0x0C, 0xB0, 0xE0, 0x17, 0x73,
  0x0A, 0xB0, 0x98, 0x09, 0x93, 0x08, 0x90, 0x27, 0xBD, 0xEE, 0xDB, 0x72, 0x73, 0x01, 0x0A, 0xFB,
  0x0A, 0x01, 0x70, 0x20, 0xEF, 0xD0, 0xE0, 0x25, 0x01, 0x0D, 0xFF, 0x0D, 0x01, 0x40, 0xAE, 0x82,
  0xEB, 0xAE, 0xE0, 0x93, 0x03, 0xE0, 0x74, 0x07, 0xE0, 0x22, 0x09, 0xD0, 0x86, 0x09, 0xD0, 0x92,
  0x0E, 0xD0, 0x16, 0x01, 0xD8, 0x1E, 0x03, 0xD0, 0xA7, 0x10, 0xBD, 0x03, 0x06, 0xD0, 0x77, 0x10,
  0x7D, 0x05, 0x08, 0xD0, 0x47, 0x10, 0x4D, 0x08, 0x0A, 0xD0, 0x27, 0x10, 0x3D, 0x0A, 0x0B, 0xD0,
  0x17, 0x10, 0x2D, 0x00, 0xBD, 0x01, 0x71, 0x01, 0xD0, 0xB0, 0xCD, 0x01, 0x71, 0x01, 0xD0, 0x0B,
  0xD0, 0x17, 0x10, 0x2D, 0x0B, 0x0A, 0xD0, 0x27, 0x10, 0x3D, 0x0A, 0x08, 0xD0, 0x47, 0x10, 0x4D,
  0x08, 0x06, 0xD0, 0x77, 0x10, 0x7D, 0x05, 0x03, 0xD0, 0xA7, 0x10, 0xBD, 0x81, 0x30, 0xED, 0x01,
  0x60, 0x1D, 0x0E, 0x20, 0x9D, 0x08, 0x60, 0x8D, 0x09, 0x20, 0x3E, 0x07, 0x40, 0x7E, 0x03, 0x30,
  0xAE, 0x82, 0xDA, 0xAD, 0xE0, 0x94, 0x01, 0x0D, 0xFF, 0x0D, 0x01, 0x50, 0x20, 0xEF, 0xD0, 0xE0,
  0x27, 0x01, 0x0A, 0xFB, 0x0A, 0x01, 0x73, 0x89, 0x02, 0x7B, 0xDE, 0xED, 0xB7, 0x26,
  // "Ó" (U+00D3)
  0x74, 0x02, 0x80, 0x27, 0x01, 0x77, 0x0B, 0xD0, 0xA7, 0x70, 0x5D, 0x0A, 0x77, 0x01, 0x0E, 0xC0,
  0x97, 0x71, 0x0A, 0xC0, 0x97, 0x71, 0x06, 0xC0, 0x77, 0x72, 0x0E, 0xB0, 0x58, 0x09, 0x95, 0x08,
  0x90, 0x27, 0xBD, 0xEE, 0xDB, 0x72, 0x73, 0x01, 0x0A, 0xFB, 0x0A, 0x01, 0x70, 0x20, 0xEF, 0xD0,
  0xE0, 0x25, 0x01, 0x0D, 0xFF, 0x0D, 0x01, 0x40, 0xAE, 0x82, 0xEB, 0xAE, 0xE0, 0x93, 0x03, 0xE0,
  0x74, 0x07, 0xE0, 0x22, 0x09, 0xD0, 0x86, 0x09, 0xD0, 0x92, 0x0E, 0xD0, 0x16, 0x01, 0xD8, 0x1E,
  0x03, 0xD0, 0xA7, 0x10, 0xBD, 0x03, 0x06, 0xD0, 0x77, 0x10, 0x7D, 0x05, 0x08, 0xD0, 0x47, 0x10,
  0x4D, 0x08, 0x0A, 0xD0, 0x27, 0x10, 0x3D, 0x0A, 0x0B, 0xD0, 0x17, 0x10, 0x2D, 0x00, 0xBD, 0x01,
  0x71, 0x01, 0xD0, 0xB0, 0xCD, 0x01, 0x71, 0x01, 0xD0, 0x0B, 0xD0, 0x17, 0x10, 0x2D, 0x0B, 0x0A,
  0xD0, 0x27, 0x10, 0x3D, 0x0A, 0x08, 0xD0, 0x47, 0x10, 0x4D, 0x08, 0x06, 0xD0, 0x77, 0x10, 0x7D,
  0x05, 0x03, 0xD0, 0xA7, 0x10, 0xBD, 0x81, 0x30, 0xED, 0x01, 0x60, 0x1D, 0x0E, 0x20, 0x9D, 0x08,
  0x60, 0x8D, 0x09, 0x20, 0x3E, 0x07, 0x40, 0x7E, 0x03, 0x30, 0xAE, 0x82, 0xDA, 0xAD, 0xE0, 0x94,
  0x01, 0x0D, 0xFF, 0x0D, 0x01, 0x50, 0x20, 0xEF, 0xD0, 0xE0, 0x27, 0x01, 0x0A, 0xFB, 0x0A, 0x01,
  0x73, 0x89, 0x02, 0x7B, 0xDE, 0xED, 0xB7, 0x26,
  // "Ô" (U+00D4)
  0x71, 0x80, 0x27, 0x01, 0x77, 0x06, 0xE0, 0xA7, 0x60, 0x20, 0xEF, 0x05, 0x75, 0x0C, 0xC0, 0xDB,
  0x0E, 0x02, 0x73, 0x09, 0xB8, 0x2E, 0x41, 0xDB, 0x0C, 0x72, 0x06, 0xB0, 0xE0, 0x32, 0x01, 0x0C,
  0xB0, 0xA7, 0x02, 0xB0, 0xC0, 0x25, 0x0A, 0xB0, 0x58, 0x09, 0x87, 0x08, 0x90, 0x27, 0xBD, 0xEE,
  0xDB, 0x72, 0x73, 0x01, 0x0A, 0xFB, 0x0A, 0x01, 0x70, 0x20, 0xEF, 0xD0, 0xE0, 0x25, 0x01, 0x0D,
  0xFF, 0x0D, 0x01, 0x40, 0xAE, 0x82, 0xEB, 0xAE, 0xE0, 0x93, 0x03, 0xE0, 0x74, 0x07, 0xE0, 0x22,
  0x09, 0xD0, 0x86, 0x09, 0xD0, 0x92, 0x0E, 0xD0, 0x16, 0x01, 0xD8, 0x1E, 0x03, 0xD0, 0xA7, 0x10,
  0xBD, 0x03, 0x06, 0xD0, 0x77, 0x10, 0x7D, 0x05, 0x08, 0xD0, 0x47, 0x10, 0x4D, 0x08, 0x0A, 0xD0,
  0x27, 0x10, 0x3D, 0x0A, 0x0B, 0xD0, 0x17, 0x10, 0x2D, 0x00, 0xBD, 0x01, 0x71, 0x01, 0xD0, 0xB0,
  0xCD, 0x01, 0x71, 0x01, 0xD0, 0x0B, 0xD0, 0x17, 0x10, 0x2D, 0x0B, 0x0A, 0xD0, 0x27, 0x10, 0x3D,
  0x0A, 0x08, 0xD0, 0x47, 0x10, 0x4D, 0x08, 0x06, 0xD0, 0x77, 0x10, 0x7D, 0x05, 0x03, 0xD0, 0xA7,
  0x10, 0xBD, 0x81, 0x30, 0xED, 0x01, 0x60, 0x1D, 0x0E, 0x20, 0x9D, 0x08, 0x60, 0x8D, 0x09, 0x20,
  0x3E, 0x07, 0x40, 0x7E, 0x03, 0x30, 0xAE, 0x82, 0xDA, 0xAD, 0xE0, 0x94, 0x01, 0x0D, 0xFF, 0x0D,
  0x01, 0x50, 0x20, 0xEF, 0xD0, 0xE0, 0x27, 0x01, 0x0A, 0xFB, 0x0A, 0x01, 0x73, 0x89, 0x02, 0x7B,
  0xDE, 0xED, 0xB7, 0x26,
  // "Õ" (U+00D5)
  0x58, 0x43, 0xBE, 0xEA, 0x44, 0x06, 0xA0, 0x87, 0x02, 0x0E, 0xD8, 0x3C, 0x51, 0x1D, 0xA0, 0x67,
  0x0A, 0xFE, 0x02, 0x60, 0x1F, 0xE0, 0xC7, 0x05, 0xA8, 0x3C, 0x11, 0x6D, 0xD0, 0xE0, 0x37, 0x07,
  0xA0, 0x64, 0x84, 0x4A, 0xEE, 0xB2, 0x80, 0x99, 0x10, 0x89, 0x02, 0x7B, 0xDE, 0xED, 0xB7, 0x27,
  0x30, 0x10, 0xAF, 0xB0, 0xA0, 0x17, 0x02, 0x0E, 0xFD, 0x0E, 0x02, 0x50, 0x10, 0xDF, 0xF0, 0xD0,
  0x14, 0x0A, 0xE8, 0x2E, 0xBA, 0xEE, 0x09, 0x30, 0x3E, 0x07, 0x40, 0x7E, 0x02, 0x20, 0x9D, 0x08,
  0x60, 0x9D, 0x09, 0x20, 0xED, 0x01, 0x60, 0x1D, 0x81, 0xE0, 0x3D, 0x0A, 0x71, 0x0B, 0xD0, 0x30,
  0x6D, 0x07, 0x71, 0x07, 0xD0, 0x50, 0x8D, 0x04, 0x71, 0x04, 0xD0, 0x80, 0xAD, 0x02, 0x71, 0x03,
  0xD0, 0xA0, 0xBD, 0x01, 0x71, 0x02, 0xD0, 0x0B, 0xD0, 0x17, 0x10, 0x1D, 0x0B, 0x0C, 0xD0, 0x17,
  0x10, 0x1D, 0x00, 0xBD, 0x01, 0x71, 0x02, 0xD0, 0xB0, 0xAD, 0x02, 0x71, 0x03, 0xD0, 0xA0, 0x8D,
  0x04, 0x71, 0x04, 0xD0, 0x80, 0x6D, 0x07, 0x71, 0x07, 0xD0, 0x50, 0x3D, 0x0A, 0x71, 0x0B, 0xD8,
  0x13, 0x0E, 0xD0, 0x16, 0x01, 0xD0, 0xE2, 0x09, 0xD0, 0x86, 0x08, 0xD0, 0x92, 0x03, 0xE0, 0x74,
  0x07, 0xE0, 0x33, 0x0A, 0xE8, 0x2D, 0xAA, 0xDE, 0x09, 0x40, 0x10, 0xDF, 0xF0, 0xD0, 0x15, 0x02,
  0x0E, 0xFD, 0x0E, 0x02, 0x70, 0x10, 0xAF, 0xB0, 0xA0, 0x17, 0x38, 0x90, 0x27, 0xBD, 0xEE, 0xDB,
  0x72, 0x60,
  // "Ö" (U+00D6)
  0x48, 0x35, 0xDE, 0xC3, 0x48, 0x32, 0xBE, 0xD7, 0x70, 0x2C, 0x0E, 0x40, 0xCC, 0x05, 0x60, 0x5D,
  0x03, 0x3D, 0x09, 0x60, 0x5D, 0x03, 0x3D, 0x09, 0x60, 0x1C, 0x0D, 0x40, 0xBC, 0x04, 0x78, 0x34,
  0xCE, 0xB3, 0x48, 0x31, 0xAE, 0xD6, 0x80, 0x99, 0x00, 0x89, 0x02, 0x7B, 0xDE, 0xED, 0xB7, 0x27,
  0x30, 0x10, 0xAF, 0xB0, 0xA0, 0x17, 0x02, 0x0E, 0xFD, 0x0E, 0x02, 0x50, 0x10, 0xDF, 0xF0, 0xD0,
  0x14, 0x0A, 0xE8, 0x2E, 0xBA, 0xEE, 0x09, 0x30, 0x3E, 0x07, 0x40, 0x7E, 0x02, 0x20, 0x9D, 0x08,
  0x60, 0x9D, 0x09, 0x20, 0xED, 0x01, 0x60, 0x1D, 0x81, 0xE0, 0x3D, 0x0A, 0x71, 0x0B, 0xD0, 0x30,
  0x6D, 0x07, 0x71, 0x07, 0xD0, 0x50, 0x8D, 0x04, 0x71, 0x04, 0xD0, 0x80, 0xAD, 0x02, 0x71, 0x03,
  0xD0, 0xA0, 0xBD, 0x01, 0x71, 0x02, 0xD0, 0x0B, 0xD0, 0x17, 0x10, 0x1D, 0x0B, 0x0C, 0xD0, 0x17,
  0x10, 0x1D, 0x00, 0xBD, 0x01, 0x71, 0x02, 0xD0, 0xB0, 0xAD, 0x02, 0x71, 0x03, 0xD0, 0xA0, 0x8D,
  0x04, 0x71, 0x04, 0xD0, 0x80, 0x6D, 0x07, 0x71, 0x07, 0xD0, 0x50, 0x3D, 0x0A, 0x71, 0x0B, 0xD8,
  0x13, 0x0E, 0xD0, 0x16, 0x01, 0xD0, 0xE2, 0x09, 0xD0, 0x86, 0x08, 0xD0, 0x92, 0x03, 0xE0, 0x74,
  0x07, 0xE0, 0x33, 0x0A, 0xE8, 0x2D, 0xAA, 0xDE, 0x09, 0x40, 0x10, 0xDF, 0xF0, 0xD0, 0x15, 0x02,
  0x0E, 0xFD, 0x0E, 0x02, 0x70, 0x10, 0xAF, 0xB0, 0xA0, 0x17, 0x38, 0x90, 0x27, 0xBD, 0xEE, 0xDB,
  0x72, 0x60,
  // "×" (U+00D7)
  0x20, 0x30, 0x97, 0x30, 0x90, 0x33, 0x82, 0x3E, 0xFA, 0x71, 0x85, 0xAF, 0xE3, 0x02, 0xEB, 0x0A,
  0x60, 0xAB, 0x81, 0xE3, 0x7D, 0x0A, 0x40, 0xAD, 0x81, 0x70, 0x7D, 0x0B, 0x20, 0xBD, 0x07, 0x30,
  0x7D, 0x00, 0xBD, 0x07, 0x50, 0x7F, 0xB0, 0x77, 0x07, 0xF9, 0x07, 0x72, 0x08, 0xE0, 0x77, 0x30,
  0xBE, 0x0A, 0x72, 0x0A, 0xF9, 0x0A, 0x70, 0xAF, 0xB0, 0xA5, 0x0A, 0xD0, 0x07, 0xD0, 0x93, 0x0A,
  0xD0, 0x72, 0x07, 0xD8, 0x19, 0x07, 0xD0, 0x64, 0x07, 0xD8, 0x17, 0x1C, 0xB0, 0x66, 0x07, 0xB8,
  0x5C, 0x10, 0x1D, 0xF6, 0x71, 0x82, 0x7F, 0xC1, 0x30, 0x10, 0x57, 0x30, 0x60, 0x12,
  // "Ø" (U+00D8)
  0x77, 0x60, 0xB0, 0x57, 0x28, 0x90, 0x27, 0xBD, 0xEF, 0xDB, 0x82, 0x20, 0x8A, 0x0A, 0x01, 0x50,
  0x10, 0xAF, 0xB0, 0xA0, 0x5B, 0x0E, 0x02, 0x40, 0x20, 0xEF, 0xFA, 0x06, 0x40, 0x10, 0xDF, 0xFA,
  0x0A, 0x50, 0x9E, 0x82, 0xEB, 0xAE, 0xE0, 0xE5, 0x03, 0xE0, 0x74, 0x07, 0xE0, 0x34, 0x09, 0xD0,
  0x86, 0x0D, 0xD0, 0xA4, 0x0E, 0xD0, 0x15, 0x07, 0xE0, 0xE3, 0x03, 0xD0, 0xA5, 0x03, 0xF9, 0x03,
  0x20, 0x6D, 0x07, 0x50, 0xDF, 0x90, 0x62, 0x08, 0xD0, 0x44, 0x09, 0xB0, 0xED, 0x08, 0x20, 0xAD,
  0x02, 0x30, 0x4B, 0x0E, 0x05, 0xD0, 0xA2, 0x0B, 0xD0, 0x12, 0x01, 0x0E, 0xB0, 0x60, 0x1D, 0x0B,
  0x20, 0xBD, 0x01, 0x20, 0xAB, 0x81, 0xB0, 0x1D, 0x0C, 0x20, 0xCD, 0x81, 0x10, 0x6B, 0x82, 0xE1,
  0x01, 0xD0, 0xB2, 0x0B, 0xD8, 0x11, 0x2E, 0xB0, 0x52, 0x02, 0xD0, 0xB2, 0x0A, 0xD0, 0x30, 0xCB,
  0x09, 0x30, 0x2D, 0x0A, 0x20, 0x9D, 0x0B, 0xB0, 0xD4, 0x04, 0xD0, 0x82, 0x06, 0xFA, 0x03, 0x40,
  0x7D, 0x05, 0x20, 0x3F, 0x90, 0x85, 0x0A, 0xD0, 0x33, 0x0E, 0xE0, 0xC5, 0x01, 0xD0, 0xE4, 0x0A,
  0xE0, 0x25, 0x08, 0xD0, 0x84, 0x03, 0xE0, 0x74, 0x07, 0xE0, 0x25, 0x0E, 0xE8, 0x2D, 0xAA, 0xDE,
  0x09, 0x50, 0x7F, 0xFA, 0x0D, 0x01, 0x40, 0x3F, 0xFA, 0x0E, 0x02, 0x50, 0xDB, 0x09, 0x0A, 0xFB,
  0x0A, 0x01, 0x50, 0x30, 0xDA, 0x0C, 0x28, 0x90, 0x28, 0xBE, 0xFE, 0xDB, 0x72, 0x71, 0x82, 0x19,
  0xF3, 0x77, 0x71, 0x02, 0x77, 0x60,
  // "Ù" (U+00D9)
  0x40, 0x48, 0x02, 0x77, 0x71, 0x02, 0x0D, 0xD0, 0x57, 0x71, 0x02, 0x0E, 0xC0, 0xE0, 0x17, 0x71,
  0x02, 0x0D, 0xC0, 0x97, 0x72, 0x02, 0x0D, 0xC0, 0x47, 0x72, 0x01, 0x0C, 0xB0, 0xE0, 0x17, 0x73,
  0x0A, 0xB0, 0x98, 0x09, 0x85, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D,
  0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09,
  0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10,
  0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71,
  0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97,
  0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09,
  0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x03, 0x02, 0xD0, 0x97, 0x10, 0xAD, 0x02, 0x01,
  0xD0, 0xB7, 0x10, 0xBD, 0x01, 0x1D, 0x0E, 0x71, 0x0E, 0xD2, 0x0C, 0xD0, 0x56, 0x05, 0xD0, 0xB2,
  0x07, 0xD0, 0xE0, 0x44, 0x04, 0x0E, 0xD0, 0x62, 0x01, 0x0E, 0xE8, 0x2D, 0xAA, 0xDE, 0x0E, 0x40,
  0x6F, 0xFA, 0x04, 0x50, 0x8F, 0xF0, 0x67, 0x05, 0x0D, 0xFB, 0x0C, 0x04, 0x73, 0x89, 0x04, 0x9C,
  0xEF, 0xED, 0xC8, 0x46,
  // "Ú" (U+00DA)
  0x74, 0x02, 0x80, 0x27, 0x01, 0x77, 0x0B, 0xD0, 0xA7, 0x70, 0x5D, 0x0A, 0x77, 0x01, 0x0E, 0xC0,
  0x97, 0x71, 0x0A, 0xC0, 0x97, 0x71, 0x06, 0xC0, 0x77, 0x72, 0x0E, 0xB0, 0x58, 0x09, 0x87, 0x00,
  0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0,
  0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D,
  0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09,
  0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10,
  0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71,
  0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97,
  0x10, 0x9D, 0x03, 0x02, 0xD0, 0x97, 0x10, 0xAD, 0x02, 0x01, 0xD0, 0xB7, 0x10, 0xBD, 0x01, 0x1D,
  0x0E, 0x71, 0x0E, 0xD2, 0x0C, 0xD0, 0x56, 0x05, 0xD0, 0xB2, 0x07, 0xD0, 0xE0, 0x44, 0x04, 0x0E,
  0xD0, 0x62, 0x01, 0x0E, 0xE8, 0x2D, 0xAA, 0xDE, 0x0E, 0x40, 0x6F, 0xFA, 0x04, 0x50, 0x8F, 0xF0,
  0x67, 0x05, 0x0D, 0xFB, 0x0C, 0x04, 0x73, 0x89, 0x04, 0x9C, 0xEF, 0xED, 0xC8, 0x46,
  // "Û" (U+00DB)
  0x71, 0x80, 0x27, 0x01, 0x77, 0x06, 0xE0, 0xA7, 0x60, 0x20, 0xEF, 0x05, 0x75, 0x0C, 0xC0, 0xDB,
  0x0E, 0x02, 0x73, 0x09, 0xB8, 0x2E, 0x41, 0xDB, 0x0C, 0x72, 0x06, 0xB0, 0xE0, 0x32, 0x01, 0x0C,
  0xB0, 0xA7, 0x02, 0xB0, 0xC0, 0x25, 0x0A, 0xB0, 0x58, 0x09, 0x81, 0x00, 0x3D, 0x09, 0x71, 0x09,
  0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10,
  0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71,
  0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97,
  0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09,
  0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0,
  0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x03, 0x02,
  0xD0, 0x97, 0x10, 0xAD, 0x02, 0x01, 0xD0, 0xB7, 0x10, 0xBD, 0x01, 0x1D, 0x0E, 0x71, 0x0E, 0xD2,
  0x0C, 0xD0, 0x56, 0x05, 0xD0, 0xB2, 0x07, 0xD0, 0xE0, 0x44, 0x04, 0x0E, 0xD0, 0x62, 0x01, 0x0E,
  0xE8, 0x2D, 0xAA, 0xDE, 0x0E, 0x40, 0x6F, 0xFA, 0x04, 0x50, 0x8F, 0xF0, 0x67, 0x05, 0x0D, 0xFB,
  0x0C, 0x04, 0x73, 0x89, 0x04, 0x9C, 0xEF, 0xED, 0xC8, 0x46,
  // "Ü" (U+00DC)
  0x48, 0x35, 0xDE, 0xC3, 0x48, 0x32, 0xBE, 0xD7, 0x70, 0x2C, 0x0E, 0x40, 0xCC, 0x05, 0x60, 0x5D,
  0x03, 0x3D, 0x09, 0x60, 0x5D, 0x03, 0x3D, 0x09, 0x60, 0x1C, 0x0D, 0x40, 0xBC, 0x04, 0x78, 0x34,
  0xCE, 0xB3, 0x48, 0x31, 0xAE, 0xD6, 0x80, 0x98, 0x20, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D,
  0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03,
  0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00,
  0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0,
  0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D,
  0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09,
  0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x30, 0x2D, 0x09, 0x71,
  0x0A, 0xD0, 0x20, 0x1D, 0x0B, 0x71, 0x0B, 0xD0, 0x11, 0xD0, 0xE7, 0x10, 0xED, 0x20, 0xCD, 0x05,
  0x60, 0x5D, 0x0B, 0x20, 0x7D, 0x0E, 0x04, 0x40, 0x40, 0xED, 0x06, 0x20, 0x10, 0xEE, 0x82, 0xDA,
  0xAD, 0xE0, 0xE4, 0x06, 0xFF, 0xA0, 0x45, 0x08, 0xFF, 0x06, 0x70, 0x50, 0xDF, 0xB0, 0xC0, 0x47,
  0x38, 0x90, 0x49, 0xCE, 0xFE, 0xDC, 0x84, 0x60,
  // "Ý" (U+00DD)
  0x74, 0x02, 0x80, 0x27, 0x01, 0x77, 0x0B, 0xD0, 0xA7, 0x70, 0x5D, 0x0A, 0x77, 0x01, 0x0E, 0xC0,
  0x97, 0x71, 0x0A, 0xC0, 0x97, 0x71, 0x06, 0xC0, 0x77, 0x72, 0x0E, 0xB0, 0x58, 0x09, 0x87, 0x00,
  0xED, 0x02, 0x71, 0x01, 0xD0, 0xE0, 0x7D, 0x08, 0x71, 0x07, 0xD8, 0x17, 0x0E, 0xC0, 0xE7, 0x10,
  0xEC, 0x0E, 0x20, 0x7D, 0x06, 0x60, 0x5D, 0x08, 0x20, 0x10, 0xEC, 0x0D, 0x60, 0xCC, 0x0E, 0x01,
  0x30, 0x8D, 0x04, 0x40, 0x3D, 0x08, 0x40, 0x1D, 0x0A, 0x40, 0x9D, 0x01, 0x50, 0x8D, 0x02, 0x20,
  0x1D, 0x09, 0x60, 0x1D, 0x08, 0x20, 0x7D, 0x02, 0x70, 0x9C, 0x0E, 0x20, 0xDC, 0x09, 0x71, 0x02,
  0xD0, 0x60, 0x5D, 0x02, 0x72, 0x09, 0xC0, 0xD0, 0xBC, 0x0A, 0x73, 0x02, 0xFB, 0x02, 0x74, 0x0A,
  0xF9, 0x0A, 0x75, 0x02, 0xF9, 0x03, 0x76, 0x0A, 0xE0, 0xB7, 0x70, 0x3E, 0x04, 0x77, 0x10, 0xDC,
  0x0E, 0x77, 0x20, 0xDC, 0x0E, 0x77, 0x20, 0xDC, 0x0E, 0x77, 0x20, 0xDC, 0x0E, 0x77, 0x20, 0xDC,
  0x0E, 0x77, 0x20, 0xDC, 0x0E, 0x77, 0x20, 0xDC, 0x0E, 0x77, 0x20, 0xDC, 0x0E, 0x77, 0x20, 0xDC,
  0x0E, 0x77, 0x20, 0xDC, 0x0E, 0x77, 0x20, 0xDC, 0x0E, 0x71,
  // "Þ" (U+00DE)
  0x0C, 0xC0, 0xC7, 0x70, 0xCC, 0x0C, 0x77, 0x0C, 0xC0, 0xC7, 0x70, 0xCC, 0x0C, 0x77, 0x0C, 0xC0,
  0xE8, 0x01, 0x98, 0x18, 0x52, 0x60, 0xCF, 0xE0, 0xC0, 0x64, 0x0C, 0xFF, 0x90, 0xA3, 0x0C, 0xFF,
  0xA0, 0xA2, 0x0C, 0xFF, 0xB8, 0x15, 0x0C, 0xC0, 0xC4, 0x81, 0x15, 0xDD, 0x81, 0xC0, 0xCC, 0x0C,
  0x60, 0x20, 0xED, 0x01, 0x0C, 0xC0, 0xC7, 0x09, 0xD0, 0x40, 0xCC, 0x0C, 0x70, 0x6D, 0x05, 0x0C,
  0xC0, 0xC7, 0x05, 0xD0, 0x60, 0xCC, 0x0C, 0x70, 0x7D, 0x05, 0x0C, 0xC0, 0xC7, 0x0B, 0xD0, 0x30,
  0xCC, 0x0C, 0x60, 0x5D, 0x81, 0xE0, 0xCC, 0x0C, 0x40, 0x30, 0x8E, 0x81, 0x90, 0xCF, 0xFB, 0x81,
  0x20, 0xCF, 0xFA, 0x07, 0x20, 0xCF, 0xF9, 0x07, 0x30, 0xCF, 0xE0, 0xB0, 0x34, 0x0C, 0xC0, 0xE8,
  0x01, 0x98, 0x17, 0x51, 0x60, 0xCC, 0x0C, 0x77, 0x0C, 0xC0, 0xC7, 0x70, 0xCC, 0x0C, 0x77, 0x0C,
  0xC0, 0xC7, 0x70, 0xCC, 0x0C, 0x77,
  // "ß" (U+00DF)
  0x58, 0x90, 0x59, 0xDE, 0xFE, 0xDA, 0x61, 0x72, 0x06, 0x0E, 0xFB, 0x09, 0x01, 0x60, 0x9F, 0xE0,
  0xC0, 0x14, 0x07, 0xFF, 0x90, 0xB3, 0x01, 0x0E, 0xE8, 0x2C, 0xAB, 0xEE, 0x03, 0x20, 0x6D, 0x0D,
  0x02, 0x30, 0x10, 0xBD, 0x07, 0x20, 0x9D, 0x05, 0x50, 0x3D, 0x08, 0x20, 0xBD, 0x60, 0x2D, 0x06,
  0x20, 0xCC, 0x0D, 0x60, 0x7D, 0x02, 0x20, 0xCC, 0x0D, 0x50, 0x5D, 0x09, 0x30, 0xCC, 0x0D, 0x40,
  0x6D, 0x0C, 0x40, 0xCC, 0x0D, 0x30, 0x6D, 0x0B, 0x01, 0x40, 0xCC, 0x0D, 0x20, 0x2D, 0x0A, 0x60,
  0xCC, 0x0D, 0x20, 0x8C, 0x0E, 0x70, 0xCC, 0x0D, 0x20, 0xAC, 0x0E, 0x70, 0xCC, 0x0D, 0x20, 0x9D,
  0x0B, 0x01, 0x50, 0xCC, 0x0D, 0x20, 0x4E, 0x0D, 0x03, 0x40, 0xCC, 0x0D, 0x30, 0xAF, 0x07, 0x30,
  0xCC, 0x0D, 0x40, 0xAF, 0x09, 0x20, 0xCC, 0x0D, 0x50, 0x7F, 0x81, 0x80, 0xCC, 0x0D, 0x60, 0x20,
  0xCE, 0x03, 0x0C, 0xC0, 0xD7, 0x10, 0xAD, 0x09, 0x0C, 0xC0, 0xD7, 0x20, 0xEC, 0x00, 0xCC, 0x0D,
  0x72, 0x0E, 0xC0, 0x0C, 0xC8, 0x3D, 0x04, 0xB4, 0x40, 0x5D, 0x0B, 0x0C, 0xC8, 0x1D, 0x04, 0xA8,
  0x2E, 0xBA, 0xCE, 0x08, 0x0C, 0xC8, 0x1D, 0x04, 0xFD, 0x03, 0x0C, 0xC8, 0x1D, 0x04, 0xFC, 0x81,
  0x80, 0xCC, 0x81, 0xD0, 0x4F, 0xB0, 0x82, 0x0C, 0xC0, 0xD2, 0x82, 0x59, 0xCD, 0xA8, 0x2E, 0xB7,
  0x23,
  // "à" (U+00E0)
  0x30, 0x48, 0x02, 0x77, 0x60, 0x20, 0xDD, 0x05, 0x76, 0x02, 0x0E, 0xC0, 0xE0, 0x17, 0x60, 0x20,
  0xDC, 0x09, 0x77, 0x02, 0x0D, 0xC0, 0x47, 0x70, 0x10, 0xCB, 0x0E, 0x01, 0x77, 0x10, 0xAB, 0x09,
  0x80, 0xD6, 0x08, 0x91, 0x48, 0xBD, 0xEF, 0xED, 0xB9, 0x46, 0x81, 0x28, 0xEF, 0xC0, 0xD0, 0x54,
  0x06, 0xFF, 0x90, 0x74, 0x0D, 0xFF, 0x90, 0x43, 0x06, 0xB8, 0x4E, 0xCA, 0xAA, 0xCE, 0x0D, 0x48,
  0x19, 0x52, 0x60, 0x20, 0xCD, 0x02, 0x76, 0x03, 0xD0, 0x47, 0x60, 0x1D, 0x06, 0x48, 0x25, 0x9C,
  0xEF, 0xC0, 0x62, 0x05, 0x0D, 0xFF, 0x98, 0x16, 0x07, 0xFF, 0xB0, 0x60, 0x2E, 0x08, 0x03, 0x40,
  0x1D, 0x06, 0x09, 0xD0, 0x46, 0x01, 0xD0, 0x60, 0xDC, 0x0C, 0x70, 0x2D, 0x06, 0x0E, 0xC0, 0xA7,
  0x06, 0xD0, 0x6D, 0x0D, 0x60, 0x10, 0xDD, 0x06, 0x0D, 0xD0, 0x74, 0x03, 0x0D, 0xE0, 0x60, 0xAE,
  0x82, 0xDA, 0xAD, 0xF9, 0x06, 0x05, 0xFF, 0xC8, 0x16, 0x0B, 0xFC, 0x04, 0x0B, 0xC8, 0x26, 0x01,
  0xBF, 0x98, 0x2C, 0x30, 0x7C, 0x06, 0x38, 0x65, 0xAD, 0xFE, 0xD9, 0x53, 0x02, 0xC0, 0x60,
  // "á" (U+00E1)
  0x73, 0x02, 0x80, 0x27, 0x01, 0x75, 0x0B, 0xD0, 0xA7, 0x50, 0x5D, 0x0A, 0x75, 0x01, 0x0E, 0xC0,
  0x97, 0x60, 0xAC, 0x09, 0x76, 0x06, 0xC0, 0x77, 0x70, 0xEB, 0x05, 0x80, 0xE0, 0x08, 0x91, 0x48,
  0xBD, 0xEF, 0xED, 0xB9, 0x46, 0x81, 0x28, 0xEF, 0xC0, 0xD0, 0x54, 0x06, 0xFF, 0x90, 0x74, 0x0D,
  0xFF, 0x90, 0x43, 0x06, 0xB8, 0x4E, 0xCA, 0xAA, 0xCE, 0x0D, 0x48, 0x19, 0x52, 0x60, 0x20, 0xCD,
  0x02, 0x76, 0x03, 0xD0, 0x47, 0x60, 0x1D, 0x06, 0x48, 0x25, 0x9C, 0xEF, 0xC0, 0x62, 0x05, 0x0D,
  0xFF, 0x98, 0x16, 0x07, 0xFF, 0xB0, 0x60, 0x2E, 0x08, 0x03, 0x40, 0x1D, 0x06, 0x09, 0xD0, 0x46,
  0x01, 0xD0, 0x60, 0xDC, 0x0C, 0x70, 0x2D, 0x06, 0x0E, 0xC0, 0xA7, 0x06, 0xD0, 0x6D, 0x0D, 0x60,
  0x10, 0xDD, 0x06, 0x0D, 0xD0, 0x74, 0x03, 0x0D, 0xE0, 0x60, 0xAE, 0x82, 0xDA, 0xAD, 0xF9, 0x06,
  0x05, 0xFF, 0xC8, 0x16, 0x0B, 0xFC, 0x04, 0x0B, 0xC8, 0x26, 0x01, 0xBF, 0x98, 0x2C, 0x30, 0x7C,
  0x06, 0x38, 0x65, 0xAD, 0xFE, 0xD9, 0x53, 0x02, 0xC0, 0x60,
  // "â" (U+00E2)
  0x78, 0x02, 0x70, 0x17, 0x50, 0x6E, 0x0A, 0x74, 0x02, 0x0E, 0xF0, 0x57, 0x30, 0xCC, 0x0D, 0xB0,
  0xE0, 0x27, 0x10, 0x9B, 0x82, 0xE4, 0x1D, 0xB0, 0xC7, 0x06, 0xB0, 0xE0, 0x32, 0x01, 0x0C, 0xB0,
  0xA5, 0x02, 0xB0, 0xC0, 0x25, 0x0A, 0xB0, 0x58, 0x0D, 0x20, 0x89, 0x14, 0x8B, 0xDE, 0xFE, 0xDB,
  0x94, 0x68, 0x12, 0x8E, 0xFC, 0x0D, 0x05, 0x40, 0x6F, 0xF9, 0x07, 0x40, 0xDF, 0xF9, 0x04, 0x30,
  0x6B, 0x84, 0xEC, 0xAA, 0xAC, 0xE0, 0xD4, 0x81, 0x95, 0x26, 0x02, 0x0C, 0xD0, 0x27, 0x60, 0x3D,
  0x04, 0x76, 0x01, 0xD0, 0x64, 0x82, 0x59, 0xCE, 0xFC, 0x06, 0x20, 0x50, 0xDF, 0xF9, 0x81, 0x60,
  0x7F, 0xFB, 0x06, 0x02, 0xE0, 0x80, 0x34, 0x01, 0xD0, 0x60, 0x9D, 0x04, 0x60, 0x1D, 0x06, 0x0D,
  0xC0, 0xC7, 0x02, 0xD0, 0x60, 0xEC, 0x0A, 0x70, 0x6D, 0x06, 0xD0, 0xD6, 0x01, 0x0D, 0xD0, 0x60,
  0xDD, 0x07, 0x40, 0x30, 0xDE, 0x06, 0x0A, 0xE8, 0x2D, 0xAA, 0xDF, 0x90, 0x60, 0x5F, 0xFC, 0x81,
  0x60, 0xBF, 0xC0, 0x40, 0xBC, 0x82, 0x60, 0x1B, 0xF9, 0x82, 0xC3, 0x07, 0xC0, 0x63, 0x86, 0x5A,
  0xDF, 0xED, 0x95, 0x30, 0x2C, 0x06,
  // "ã" (U+00E3)
  0x48, 0x43, 0xBE, 0xEA, 0x44, 0x06, 0xA0, 0x85, 0x02, 0x0E, 0xD8, 0x3C, 0x51, 0x1D, 0xA0, 0x65,
  0x0A, 0xFE, 0x02, 0x40, 0x1F, 0xE0, 0xC5, 0x05, 0xA8, 0x3C, 0x11, 0x6D, 0xD0, 0xE0, 0x35, 0x07,
  0xA0, 0x64, 0x84, 0x4A, 0xEE, 0xB2, 0x80, 0xD4, 0x08, 0x91, 0x48, 0xBD, 0xEF, 0xED, 0xB9, 0x46,
  0x81, 0x28, 0xEF, 0xC0, 0xD0, 0x54, 0x06, 0xFF, 0x90, 0x74, 0x0D, 0xFF, 0x90, 0x43, 0x06, 0xB8,
  0x4E, 0xCA, 0xAA, 0xCE, 0x0D, 0x48, 0x19, 0x52, 0x60, 0x20, 0xCD, 0x02, 0x76, 0x03, 0xD0, 0x47,
  0x60, 0x1D, 0x06, 0x48, 0x25, 0x9C, 0xEF, 0xC0, 0x62, 0x05, 0x0D, 0xFF, 0x98, 0x16, 0x07, 0xFF,
  0xB0, 0x60, 0x2E, 0x08, 0x03, 0x40, 0x1D, 0x06, 0x09, 0xD0, 0x46, 0x01, 0xD0, 0x60, 0xDC, 0x0C,
  0x70, 0x2D, 0x06, 0x0E, 0xC0, 0xA7, 0x06, 0xD0, 0x6D, 0x0D, 0x60, 0x10, 0xDD, 0x06, 0x0D, 0xD0,
  0x74, 0x03, 0x0D, 0xE0, 0x60, 0xAE, 0x82, 0xDA, 0xAD, 0xF9, 0x06, 0x05, 0xFF, 0xC8, 0x16, 0x0B,
  0xFC, 0x04, 0x0B, 0xC8, 0x26, 0x01, 0xBF, 0x98, 0x2C, 0x30, 0x7C, 0x06, 0x38, 0x65, 0xAD, 0xFE,
  0xD9, 0x53, 0x02, 0xC0, 0x60,
  // "ä" (U+00E4)
  0x38, 0x35, 0xDE, 0xC3, 0x48, 0x32, 0xBE, 0xD7, 0x50, 0x2C, 0x0E, 0x40, 0xCC, 0x05, 0x40, 0x5D,
  0x03, 0x3D, 0x09, 0x40, 0x5D, 0x03, 0x3D, 0x09, 0x40, 0x1C, 0x0D, 0x40, 0xBC, 0x04, 0x58, 0x34,
  0xCE, 0xB3, 0x48, 0x31, 0xAE, 0xD6, 0x80, 0xD3, 0x08, 0x91, 0x48, 0xBD, 0xEF, 0xED, 0xB9, 0x46,
  0x81, 0x28, 0xEF, 0xC0, 0xD0, 0x54, 0x06, 0xFF, 0x90, 0x74, 0x0D, 0xFF, 0x90, 0x43, 0x06, 0xB8,
  0x4E, 0xCA, 0xAA, 0xCE, 0x0D, 0x48, 0x19, 0x52, 0x60, 0x20, 0xCD, 0x02, 0x76, 0x03, 0xD0, 0x47,
  0x60, 0x1D, 0x06, 0x48, 0x25, 0x9C, 0xEF, 0xC0, 0x62, 0x05, 0x0D, 0xFF, 0x98, 0x16, 0x07, 0xFF,
  0xB0, 0x60, 0x2E, 0x08, 0x03, 0x40, 0x1D, 0x06, 0x09, 0xD0, 0x46, 0x01, 0xD0, 0x60, 0xDC, 0x0C,
  0x70, 0x2D, 0x06, 0x0E, 0xC0, 0xA7, 0x06, 0xD0, 0x6D, 0x0D, 0x60, 0x10, 0xDD, 0x06, 0x0D, 0xD0,
  0x74, 0x03, 0x0D, 0xE0, 0x60, 0xAE, 0x82, 0xDA, 0xAD, 0xF9, 0x06, 0x05, 0xFF, 0xC8, 0x16, 0x0B,
  0xFC, 0x04, 0x0B, 0xC8, 0x26, 0x01, 0xBF, 0x98, 0x2C, 0x30, 0x7C, 0x06, 0x38, 0x65, 0xAD, 0xFE,
  0xD9, 0x53, 0x02, 0xC0, 0x60,
  // "å" (U+00E5)
  0x78, 0x46, 0xCF, 0xEB, 0x57, 0x60, 0xBE, 0x09, 0x74, 0x05, 0xB0, 0x0E, 0xB0, 0x47, 0x30, 0xAA,
  0x07, 0x20, 0x9A, 0x0A, 0x73, 0x0C, 0xA0, 0x12, 0x03, 0xA0, 0xB7, 0x30, 0xAA, 0x07, 0x20, 0x9A,
  0x09, 0x73, 0x05, 0xB0, 0x0E, 0xB0, 0x47, 0x40, 0xAE, 0x09, 0x76, 0x84, 0x6C, 0xFE, 0xC5, 0x80,
  0xD7, 0x08, 0x91, 0x48, 0xBD, 0xEF, 0xED, 0xB9, 0x46, 0x81, 0x28, 0xEF, 0xC0, 0xD0, 0x54, 0x06,
  0xFF, 0x90, 0x74, 0x0D, 0xFF, 0x90, 0x43, 0x06, 0xB8, 0x4E, 0xCA, 0xAA, 0xCE, 0x0D, 0x48, 0x19,
  0x52, 0x60, 0x20, 0xCD, 0x02, 0x76, 0x03, 0xD0, 0x47, 0x60, 0x1D, 0x06, 0x48, 0x25, 0x9C, 0xEF,
  0xC0, 0x62, 0x05, 0x0D, 0xFF, 0x98, 0x16, 0x07, 0xFF, 0xB0, 0x60, 0x2E, 0x08, 0x03, 0x40, 0x1D,
  0x06, 0x09, 0xD0, 0x46, 0x01, 0xD0, 0x60, 0xDC, 0x0C, 0x70, 0x2D, 0x06, 0x0E, 0xC0, 0xA7, 0x06,
  0xD0, 0x6D, 0x0D, 0x60, 0x10, 0xDD, 0x06, 0x0D, 0xD0, 0x74, 0x03, 0x0D, 0xE0, 0x60, 0xAE, 0x82,
  0xDA, 0xAD, 0xF9, 0x06, 0x05, 0xFF, 0xC8, 0x16, 0x0B, 0xFC, 0x04, 0x0B, 0xC8, 0x26, 0x01, 0xBF,
  0x98, 0x2C, 0x30, 0x7C, 0x06, 0x38, 0x65, 0xAD, 0xFE, 0xD9, 0x53, 0x02, 0xC0, 0x60,
  // "æ" (U+00E6)
  0x38, 0x64, 0x9D, 0xEF, 0xDA, 0x53, 0x85, 0x6C, 0xEF, 0xD8, 0x14, 0x03, 0x0D, 0xF9, 0x81, 0xB4,
  0xDE, 0x0D, 0x01, 0x30, 0x1F, 0xFD, 0x0C, 0x40, 0x9F, 0xFD, 0x06, 0x38, 0x51, 0xFE, 0xBA, 0xBE,
  0xE8, 0x1E, 0xBD, 0xC0, 0xD4, 0x02, 0x50, 0xCD, 0x03, 0x20, 0xCC, 0x01, 0x72, 0x07, 0xC0, 0xB3,
  0x07, 0xC0, 0x57, 0x20, 0x6C, 0x09, 0x30, 0x4C, 0x07, 0x38, 0x23, 0x9D, 0xEF, 0xFA, 0x08, 0x20,
  0x9F, 0xFE, 0x81, 0x90, 0x7F, 0xFF, 0x81, 0x90, 0xEC, 0x82, 0xA2, 0x06, 0xFE, 0x09, 0x04, 0xC0,
  0xE3, 0x06, 0xC0, 0x77, 0x20, 0x7C, 0x09, 0x30, 0x7C, 0x09, 0x72, 0x08, 0xC0, 0x73, 0x08, 0xC0,
  0xD7, 0x20, 0x8C, 0x09, 0x30, 0xCD, 0x06, 0x71, 0x07, 0xC0, 0xD2, 0x03, 0xF0, 0x64, 0x82, 0x48,
  0x05, 0xD8, 0x1D, 0xAE, 0xF9, 0x86, 0xDA, 0xAD, 0xFA, 0x01, 0xFB, 0x0A, 0xFB, 0x0A, 0x20, 0x9F,
  0x98, 0x1C, 0x06, 0xFA, 0x0A, 0x20, 0x10, 0xCE, 0x0C, 0x01, 0x20, 0x6F, 0x90, 0x64, 0x84, 0x7C,
  0xEE, 0xC6, 0x58, 0x61, 0x7C, 0xEF, 0xD9, 0x32,
  // "ç" (U+00E7)
  0x68, 0x31, 0x6A, 0xDE, 0xA8, 0x3E, 0xC9, 0x62, 0x50, 0x10, 0x9F, 0xD0, 0x83, 0x02, 0x0D, 0xFE,
  0x05, 0x20, 0x10, 0xDF, 0xE0, 0xE3, 0x09, 0xF8, 0x3C, 0xAA, 0xBE, 0xA0, 0x92, 0x02, 0xE0, 0xC0,
  0x25, 0x81, 0x27, 0x22, 0x08, 0xD0, 0xD7, 0x50, 0xBD, 0x04, 0x75, 0xD0, 0xE7, 0x50, 0x1D, 0x0C,
  0x75, 0x02, 0xD0, 0xB7, 0x50, 0x2D, 0x0B, 0x75, 0x01, 0xD0, 0xC7, 0x6D, 0x0E, 0x76, 0x0D, 0xD0,
  0x47, 0x50, 0xAD, 0x0C, 0x72, 0x01, 0x20, 0x4E, 0x0B, 0x02, 0x58, 0x23, 0x9F, 0x12, 0x0D, 0xF8,
  0x3D, 0xAA, 0xBE, 0xB0, 0x12, 0x03, 0xFF, 0x90, 0x13, 0x05, 0x0E, 0xFE, 0x01, 0x40, 0x20, 0xBF,
  0xC0, 0xC0, 0x16, 0x81, 0x37, 0xBC, 0x82, 0xDB, 0x83, 0x74, 0x0C, 0xA0, 0x47, 0x70, 0x3B, 0x0B,
  0x04, 0x76, 0x08, 0x0E, 0xC0, 0x77, 0x70, 0x6C, 0x01, 0x77, 0x0D, 0xB0, 0x47, 0x30, 0x12, 0x04,
  0xC0, 0x47, 0x39, 0x0E, 0xE0, 0x17, 0x3F, 0x06, 0x74, 0x0B, 0x0E, 0xA8, 0x1D, 0xA3, 0x50,
  // "è" (U+00E8)
  0x30, 0x48, 0x02, 0x77, 0x60, 0x20, 0xDD, 0x05, 0x76, 0x02, 0x0E, 0xC0, 0xE0, 0x17, 0x60, 0x20,
  0xDC, 0x09, 0x77, 0x02, 0x0D, 0xC0, 0x47, 0x70, 0x10, 0xCB, 0x0E, 0x01, 0x77, 0x10, 0xAB, 0x09,
  0x80, 0xD7, 0x08, 0x90, 0x16, 0xAD, 0xEF, 0xEC, 0x84, 0x72, 0x07, 0x0E, 0xFA, 0x0C, 0x02, 0x60,
  0xBF, 0xD0, 0xE0, 0x44, 0x0B, 0xFF, 0x0E, 0x02, 0x20, 0x6E, 0x82, 0xEB, 0xAB, 0xE0, 0xB2, 0x0E,
  0xD0, 0x90, 0x13, 0x02, 0x0C, 0xD0, 0x20, 0x5D, 0x09, 0x70, 0xDC, 0x07, 0x09, 0xD0, 0x17, 0x07,
  0xC0, 0xB0, 0xCC, 0x0D, 0x71, 0x03, 0xC0, 0xD0, 0xEF, 0xFC, 0x0E, 0xFF, 0xE0, 0xEF, 0xFD, 0x0D,
  0xFF, 0xD0, 0xBC, 0x0B, 0x77, 0x08, 0xC0, 0xE0, 0x17, 0x60, 0x3D, 0x0B, 0x77, 0x0B, 0xD0, 0xD0,
  0x57, 0x84, 0x26, 0xA5, 0x03, 0xF9, 0x84, 0xCA, 0xAA, 0xCE, 0xB0, 0x52, 0x06, 0xFF, 0xA0, 0x53,
  0x05, 0x0E, 0xFF, 0x05, 0x40, 0x20, 0xAF, 0xD0, 0xD0, 0x36, 0x83, 0x16, 0x9C, 0xDA, 0x83, 0xED,
  0xA7, 0x32,
  // "é" (U+00E9)
  0x73, 0x02, 0x80, 0x27, 0x01, 0x75, 0x0B, 0xD0, 0xA7, 0x50, 0x5D, 0x0A, 0x75, 0x01, 0x0E, 0xC0,
  0x97, 0x60, 0xAC, 0x09, 0x76, 0x06, 0xC0, 0x77, 0x70, 0xEB, 0x05, 0x80, 0xE1, 0x08, 0x90, 0x16,
  0xAD, 0xEF, 0xEC, 0x84, 0x72, 0x07, 0x0E, 0xFA, 0x0C, 0x02, 0x60, 0xBF, 0xD0, 0xE0, 0x44, 0x0B,
  0xFF, 0x0E, 0x02, 0x20, 0x6E, 0x82, 0xEB, 0xAB, 0xE0, 0xB2, 0x0E, 0xD0, 0x90, 0x13, 0x02, 0x0C,
  0xD0, 0x20, 0x5D, 0x09, 0x70, 0xDC, 0x07, 0x09, 0xD0, 0x17, 0x07, 0xC0, 0xB0, 0xCC, 0x0D, 0x71,
  0x03, 0xC0, 0xD0, 0xEF, 0xFC, 0x0E, 0xFF, 0xE0, 0xEF, 0xFD, 0x0D, 0xFF, 0xD0, 0xBC, 0x0B, 0x77,
  0x08, 0xC0, 0xE0, 0x17, 0x60, 0x3D, 0x0B, 0x77, 0x0B, 0xD0, 0xD0, 0x57, 0x84, 0x26, 0xA5, 0x03,
  0xF9, 0x84, 0xCA, 0xAA, 0xCE, 0xB0, 0x52, 0x06, 0xFF, 0xA0, 0x53, 0x05, 0x0E, 0xFF, 0x05, 0x40,
  0x20, 0xAF, 0xD0, 0xD0, 0x36, 0x83, 0x16, 0x9C, 0xDA, 0x83, 0xED, 0xA7, 0x32,
  // "ê" (U+00EA)
  0x78, 0x02, 0x70, 0x17, 0x50, 0x6E, 0x0A, 0x74, 0x02, 0x0E, 0xF0, 0x57, 0x30, 0xCC, 0x0D, 0xB0,
  0xE0, 0x27, 0x10, 0x9B, 0x82, 0xE4, 0x1D, 0xB0, 0xC7, 0x06, 0xB0, 0xE0, 0x32, 0x01, 0x0C, 0xB0,
  0xA5, 0x02, 0xB0, 0xC0, 0x25, 0x0A, 0xB0, 0x58, 0x0D, 0x30, 0x89, 0x01, 0x6A, 0xDE, 0xFE, 0xC8,
  0x47, 0x20, 0x70, 0xEF, 0xA0, 0xC0, 0x26, 0x0B, 0xFD, 0x0E, 0x04, 0x40, 0xBF, 0xF0, 0xE0, 0x22,
  0x06, 0xE8, 0x2E, 0xBA, 0xBE, 0x0B, 0x20, 0xED, 0x09, 0x01, 0x30, 0x20, 0xCD, 0x02, 0x05, 0xD0,
  0x97, 0x0D, 0xC0, 0x70, 0x9D, 0x01, 0x70, 0x7C, 0x0B, 0x0C, 0xC0, 0xD7, 0x10, 0x3C, 0x0D, 0x0E,
  0xFF, 0xC0, 0xEF, 0xFE, 0x0E, 0xFF, 0xD0, 0xDF, 0xFD, 0x0B, 0xC0, 0xB7, 0x70, 0x8C, 0x0E, 0x01,
  0x76, 0x03, 0xD0, 0xB7, 0x70, 0xBD, 0x0D, 0x05, 0x78, 0x42, 0x6A, 0x50, 0x3F, 0x98, 0x4C, 0xAA,
  0xAC, 0xEB, 0x05, 0x20, 0x6F, 0xFA, 0x05, 0x30, 0x50, 0xEF, 0xF0, 0x54, 0x02, 0x0A, 0xFD, 0x0D,
  0x03, 0x68, 0x31, 0x69, 0xCD, 0xA8, 0x3E, 0xDA, 0x73, 0x20,
  // "ë" (U+00EB)
  0x38, 0x35, 0xDE, 0xC3, 0x48, 0x32, 0xBE, 0xD7, 0x50, 0x2C, 0x0E, 0x40, 0xCC, 0x05, 0x40, 0x5D,
  0x03, 0x3D, 0x09, 0x40, 0x5D, 0x03, 0x3D, 0x09, 0x40, 0x1C, 0x0D, 0x40, 0xBC, 0x04, 0x58, 0x34,
  0xCE, 0xB3, 0x48, 0x31, 0xAE, 0xD6, 0x80, 0xD4, 0x08, 0x90, 0x16, 0xAD, 0xEF, 0xEC, 0x84, 0x72,
  0x07, 0x0E, 0xFA, 0x0C, 0x02, 0x60, 0xBF, 0xD0, 0xE0, 0x44, 0x0B, 0xFF, 0x0E, 0x02, 0x20, 0x6E,
  0x82, 0xEB, 0xAB, 0xE0, 0xB2, 0x0E, 0xD0, 0x90, 0x13, 0x02, 0x0C, 0xD0, 0x20, 0x5D, 0x09, 0x70,
  0xDC, 0x07, 0x09, 0xD0, 0x17, 0x07, 0xC0, 0xB0, 0xCC, 0x0D, 0x71, 0x03, 0xC0, 0xD0, 0xEF, 0xFC,
  0x0E, 0xFF, 0xE0, 0xEF, 0xFD, 0x0D, 0xFF, 0xD0, 0xBC, 0x0B, 0x77, 0x08, 0xC0, 0xE0, 0x17, 0x60,
  0x3D, 0x0B, 0x77, 0x0B, 0xD0, 0xD0, 0x57, 0x84, 0x26, 0xA5, 0x03, 0xF9, 0x84, 0xCA, 0xAA, 0xCE,
  0xB0, 0x52, 0x06, 0xFF, 0xA0, 0x53, 0x05, 0x0E, 0xFF, 0x05, 0x40, 0x20, 0xAF, 0xD0, 0xD0, 0x36,
  0x83, 0x16, 0x9C, 0xDA, 0x83, 0xED, 0xA7, 0x32,
  // "ì" (U+00EC)
  0x30, 0x48, 0x02, 0x77, 0x60, 0x20, 0xDD, 0x05, 0x76, 0x02, 0x0E, 0xC0, 0xE0, 0x17, 0x60, 0x20,
  0xDC, 0x09, 0x77, 0x02, 0x0D, 0xC0, 0x47, 0x70, 0x10, 0xCB, 0x0E, 0x01, 0x77, 0x10, 0xAB, 0x09,
  0x80, 0xD3, 0x00, 0x8F, 0xC0, 0x77, 0x08, 0xFC, 0x07, 0x70, 0x8F, 0xC0, 0x77, 0x08, 0xFC, 0x07,
  0x78, 0x51, 0x46, 0x79, 0xBD, 0xD0, 0x77, 0x60, 0x4D, 0x07, 0x76, 0x04, 0xD0, 0x77, 0x60, 0x4D,
  0x07, 0x76, 0x04, 0xD0, 0x77, 0x60, 0x4D, 0x07, 0x76, 0x04, 0xD0, 0x77, 0x60, 0x4D, 0x07, 0x76,
  0x04, 0xD0, 0x77, 0x60, 0x4D, 0x07, 0x76, 0x04, 0xD0, 0x77, 0x60, 0x4D, 0x07, 0x76, 0x04, 0xD0,
  0x77, 0x28, 0x32, 0x47, 0x9D, 0xD8, 0x3D, 0x97, 0x41, 0x28, 0x16, 0xCE, 0xFF, 0x98, 0x1D, 0xB9,
  0xFF, 0xD0, 0x9F, 0xFD, 0x09, 0xFF, 0xD0,
  // "í" (U+00ED)
  0x73, 0x02, 0x80, 0x27, 0x01, 0x75, 0x0B, 0xD0, 0xA7, 0x50, 0x5D, 0x0A, 0x75, 0x01, 0x0E, 0xC0,
  0x97, 0x60, 0xAC, 0x09, 0x76, 0x06, 0xC0, 0x77, 0x70, 0xEB, 0x05, 0x80, 0xD5, 0x00, 0x8F, 0xC0,
  0x77, 0x08, 0xFC, 0x07, 0x70, 0x8F, 0xC0, 0x77, 0x08, 0xFC, 0x07, 0x78, 0x51, 0x46, 0x79, 0xBD,
  0xD0, 0x77, 0x60, 0x4D, 0x07, 0x76, 0x04, 0xD0, 0x77, 0x60, 0x4D, 0x07, 0x76, 0x04, 0xD0, 0x77,
  0x60, 0x4D, 0x07, 0x76, 0x04, 0xD0, 0x77, 0x60, 0x4D, 0x07, 0x76, 0x04, 0xD0, 0x77, 0x60, 0x4D,
  0x07, 0x76, 0x04, 0xD0, 0x77, 0x60, 0x4D, 0x07, 0x76, 0x04, 0xD0, 0x77, 0x28, 0x32, 0x47, 0x9D,
  0xD8, 0x3D, 0x97, 0x41, 0x28, 0x16, 0xCE, 0xFF, 0x98, 0x1D, 0xB9, 0xFF, 0xD0, 0x9F, 0xFD, 0x09,
  0xFF, 0xD0,
  // "î" (U+00EE)
  0x78, 0x02, 0x70, 0x17, 0x50, 0x6E, 0x0A, 0x74, 0x02, 0x0E, 0xF0, 0x57, 0x30, 0xCC, 0x0D, 0xB0,
  0xE0, 0x27, 0x10, 0x9B, 0x82, 0xE4, 0x1D, 0xB0, 0xC7, 0x06, 0xB0, 0xE0, 0x32, 0x01, 0x0C, 0xB0,
  0xA5, 0x02, 0xB0, 0xC0, 0x25, 0x0A, 0xB0, 0x58, 0x0C, 0x70, 0x08, 0xFC, 0x07, 0x70, 0x8F, 0xC0,
  0x77, 0x08, 0xFC, 0x07, 0x70, 0x8F, 0xC0, 0x77, 0x85, 0x14, 0x67, 0x9B, 0xDD, 0x07, 0x76, 0x04,
  0xD0, 0x77, 0x60, 0x4D, 0x07, 0x76, 0x04, 0xD0, 0x77, 0x60, 0x4D, 0x07, 0x76, 0x04, 0xD0, 0x77,
  0x60, 0x4D, 0x07, 0x76, 0x04, 0xD0, 0x77, 0x60, 0x4D, 0x07, 0x76, 0x04, 0xD0, 0x77, 0x60, 0x4D,
  0x07, 0x76, 0x04, 0xD0, 0x77, 0x60, 0x4D, 0x07, 0x72, 0x83, 0x24, 0x79, 0xDD, 0x83, 0xD9, 0x74,
  0x12, 0x81, 0x6C, 0xEF, 0xF9, 0x81, 0xDB, 0x9F, 0xFD, 0x09, 0xFF, 0xD0, 0x9F, 0xFD,
  // "ï" (U+00EF)
  0x38, 0x35, 0xDE, 0xC3, 0x48, 0x32, 0xBE, 0xD7, 0x50, 0x2C, 0x0E, 0x40, 0xCC, 0x05, 0x40, 0x5D,
  0x03, 0x3D, 0x09, 0x40, 0x5D, 0x03, 0x3D, 0x09, 0x40, 0x1C, 0x0D, 0x40, 0xBC, 0x04, 0x58, 0x34,
  0xCE, 0xB3, 0x48, 0x31, 0xAE, 0xD6, 0x80, 0xD0, 0x00, 0x8F, 0xC0, 0x77, 0x08, 0xFC, 0x07, 0x70,
  0x8F, 0xC0, 0x77, 0x08, 0xFC, 0x07, 0x78, 0x51, 0x46, 0x79, 0xBD, 0xD0, 0x77, 0x60, 0x4D, 0x07,
  0x76, 0x04, 0xD0, 0x77, 0x60, 0x4D, 0x07, 0x76, 0x04, 0xD0, 0x77, 0x60, 0x4D, 0x07, 0x76, 0x04,
  0xD0, 0x77, 0x60, 0x4D, 0x07, 0x76, 0x04, 0xD0, 0x77, 0x60, 0x4D, 0x07, 0x76, 0x04, 0xD0, 0x77,
  0x60, 0x4D, 0x07, 0x76, 0x04, 0xD0, 0x77, 0x28, 0x32, 0x47, 0x9D, 0xD8, 0x3D, 0x97, 0x41, 0x28,
  0x16, 0xCE, 0xFF, 0x98, 0x1D, 0xB9, 0xFF, 0xD0, 0x9F, 0xFD, 0x09, 0xFF, 0xD0,
  // "ð" (U+00F0)
  0x70, 0x70, 0x37, 0x06, 0x01, 0x73, 0x04, 0xA0, 0xB0, 0x33, 0x82, 0x3C, 0xFB, 0x73, 0x0D, 0xC8,
  0x19, 0x29, 0xC0, 0x57, 0x10, 0x3F, 0xC0, 0xE0, 0x57, 0x20, 0x20, 0xBF, 0x90, 0x90, 0x17, 0x40,
  0x10, 0xDE, 0x0A, 0x75, 0x06, 0x0E, 0xF9, 0x07, 0x73, 0x0A, 0xD0, 0xDD, 0x05, 0x72, 0x04, 0xB8,
  0x2C, 0x30, 0xBC, 0x0E, 0x02, 0x72, 0x81, 0xAE, 0x63, 0x01, 0x0D, 0xC0, 0xB7, 0x20, 0x01, 0x50,
  0x3D, 0x04, 0x71, 0x87, 0x16, 0x89, 0x97, 0x40, 0x9C, 0x0C, 0x60, 0x20, 0xBF, 0x0D, 0x05, 0xD0,
  0x24, 0x06, 0xFB, 0x0E, 0x0D, 0xC0, 0x83, 0x05, 0xFF, 0xB0, 0xC2, 0x01, 0x0E, 0xFF, 0xC2, 0x08,
  0xE0, 0x70, 0x22, 0x03, 0x09, 0xF8, 0x12, 0x0D, 0xD0, 0x56, 0x07, 0xE0, 0x40, 0x2D, 0x0D, 0x71,
  0x0D, 0xD0, 0x50, 0x4D, 0x09, 0x71, 0x08, 0xD0, 0x60, 0x5D, 0x07, 0x71, 0x07, 0xD0, 0x50, 0x6D,
  0x07, 0x71, 0x07, 0xD0, 0x40, 0x5D, 0x08, 0x71, 0x09, 0xD0, 0x02, 0xD0, 0xC7, 0x10, 0xDC, 0x0D,
  0x20, 0xED, 0x03, 0x60, 0x5D, 0x09, 0x20, 0x9D, 0x0D, 0x03, 0x40, 0x40, 0xED, 0x02, 0x20, 0x10,
  0xEE, 0x82, 0xCA, 0xAD, 0xE0, 0xA4, 0x06, 0xFF, 0x90, 0xD0, 0x15, 0x07, 0xFE, 0x0C, 0x02, 0x70,
  0x30, 0xCF, 0xB0, 0x87, 0x48, 0x90, 0x49, 0xCE, 0xFE, 0xDB, 0x61, 0x60,
  // "ñ" (U+00F1)
  0x48, 0x43, 0xBE, 0xEA, 0x44, 0x06, 0xA0, 0x85, 0x02, 0x0E, 0xD8, 0x3C, 0x51, 0x1D, 0xA0, 0x65,
  0x0A, 0xFE, 0x02, 0x40, 0x1F, 0xE0, 0xC5, 0x05, 0xA8, 0x3C, 0x11, 0x6D, 0xD0, 0xE0, 0x35, 0x07,
  0xA0, 0x64, 0x84, 0x4A, 0xEE, 0xB2, 0x80, 0xD0, 0x00, 0xCB, 0x0B, 0x38, 0x73, 0x8C, 0xEF, 0xEC,
  0x81, 0x30, 0xCC, 0x81, 0x10, 0x9F, 0xA0, 0x62, 0x0C, 0xC0, 0x60, 0xAF, 0xC8, 0x16, 0x0C, 0xFF,
  0xC0, 0x10, 0xCF, 0x98, 0x1B, 0xAC, 0xF0, 0x70, 0xCE, 0x0D, 0x02, 0x30, 0x30, 0xED, 0x0B, 0x0C,
  0xE0, 0x25, 0x05, 0xD0, 0xE0, 0xCD, 0x0A, 0x7E, 0x0C, 0xD0, 0x57, 0x0D, 0xD0, 0xCD, 0x02, 0x70,
  0xCD, 0x0C, 0xD7, 0x10, 0xCD, 0x0C, 0xD7, 0x10, 0xCD, 0x0C, 0xD7, 0x10, 0xCD, 0x0C, 0xD7, 0x10,
  0xCD, 0x0C, 0xD7, 0x10, 0xCD, 0x0C, 0xD7, 0x10, 0xCD, 0x0C, 0xD7, 0x10, 0xCD, 0x0C, 0xD7, 0x10,
  0xCD, 0x0C, 0xD7, 0x10, 0xCD, 0x0C, 0xD7, 0x10, 0xCD, 0x0C, 0xD7, 0x10, 0xCD, 0x0C, 0xD7, 0x10,
  0xCD,
  // "ò" (U+00F2)
  0x40, 0x48, 0x02, 0x77, 0x71, 0x02, 0x0D, 0xD0, 0x57, 0x71, 0x02, 0x0E, 0xC0, 0xE0, 0x17, 0x71,
  0x02, 0x0D, 0xC0, 0x97, 0x72, 0x02, 0x0D, 0xC0, 0x47, 0x72, 0x01, 0x0C, 0xB0, 0xE0, 0x17, 0x73,
  0x0A, 0xB0, 0x98, 0x0E, 0x50, 0x89, 0x02, 0x7B, 0xDF, 0xED, 0xB7, 0x27, 0x30, 0x10, 0x9F, 0xB0,
  0xA0, 0x17, 0x02, 0x0D, 0xFD, 0x0E, 0x03, 0x50, 0x10, 0xDF, 0xF0, 0xE0, 0x24, 0x0B, 0xE8, 0x2E,
  0xAA, 0xDE, 0x0C, 0x30, 0x3E, 0x07, 0x40, 0x5E, 0x04, 0x20, 0xAD, 0x08, 0x60, 0x7D, 0x0B, 0x20,
  0xED, 0x01, 0x7D, 0x81, 0xE0, 0x2D, 0x0B, 0x71, 0x0B, 0xD0, 0x30, 0x5D, 0x09, 0x71, 0x09, 0xD0,
  0x40, 0x5D, 0x07, 0x71, 0x07, 0xD0, 0x50, 0x6D, 0x07, 0x71, 0x07, 0xD0, 0x05, 0xD0, 0x97, 0x10,
  0x9D, 0x05, 0x03, 0xD0, 0xB7, 0x10, 0xBD, 0x02, 0x1E, 0x01, 0x7D, 0x0E, 0x20, 0xBD, 0x08, 0x60,
  0x7D, 0x0A, 0x20, 0x4E, 0x07, 0x40, 0x5E, 0x04, 0x30, 0xBE, 0x82, 0xEA, 0xAD, 0xE0, 0xB4, 0x02,
  0x0E, 0xFF, 0x0E, 0x02, 0x50, 0x30, 0xEF, 0xD0, 0xE0, 0x37, 0x01, 0x0A, 0xFB, 0x0B, 0x01, 0x73,
  0x82, 0x28, 0xBE, 0xA8, 0x2E, 0xB8, 0x36,
  // "ó" (U+00F3)
  0x74, 0x02, 0x80, 0x27, 0x01, 0x77, 0x0B, 0xD0, 0xA7, 0x70, 0x5D, 0x0A, 0x77, 0x01, 0x0E, 0xC0,
  0x97, 0x71, 0x0A, 0xC0, 0x97, 0x71, 0x06, 0xC0, 0x77, 0x72, 0x0E, 0xB0, 0x58, 0x0E, 0x70, 0x89,
  0x02, 0x7B, 0xDF, 0xED, 0xB7, 0x27, 0x30, 0x10, 0x9F, 0xB0, 0xA0, 0x17, 0x02, 0x0D, 0xFD, 0x0E,
  0x03, 0x50, 0x10, 0xDF, 0xF0, 0xE0, 0x24, 0x0B, 0xE8, 0x2E, 0xAA, 0xDE, 0x0C, 0x30, 0x3E, 0x07,
  0x40, 0x5E, 0x04, 0x20, 0xAD, 0x08, 0x60, 0x7D, 0x0B, 0x20, 0xED, 0x01, 0x7D, 0x81, 0xE0, 0x2D,
  0x0B, 0x71, 0x0B, 0xD0, 0x30, 0x5D, 0x09, 0x71, 0x09, 0xD0, 0x40, 0x5D, 0x07, 0x71, 0x07, 0xD0,
  0x50, 0x6D, 0x07, 0x71, 0x07, 0xD0, 0x05, 0xD0, 0x97, 0x10, 0x9D, 0x05, 0x03, 0xD0, 0xB7, 0x10,
  0xBD, 0x02, 0x1E, 0x01, 0x7D, 0x0E, 0x20, 0xBD, 0x08, 0x60, 0x7D, 0x0A, 0x20, 0x4E, 0x07, 0x40,
  0x5E, 0x04, 0x30, 0xBE, 0x82, 0xEA, 0xAD, 0xE0, 0xB4, 0x02, 0x0E, 0xFF, 0x0E, 0x02, 0x50, 0x30,
  0xEF, 0xD0, 0xE0, 0x37, 0x01, 0x0A, 0xFB, 0x0B, 0x01, 0x73, 0x82, 0x28, 0xBE, 0xA8, 0x2E, 0xB8,
  0x36,
  // "ô" (U+00F4)
  0x71, 0x80, 0x27, 0x01, 0x77, 0x06, 0xE0, 0xA7, 0x60, 0x20, 0xEF, 0x05, 0x75, 0x0C, 0xC0, 0xDB,
  0x0E, 0x02, 0x73, 0x09, 0xB8, 0x2E, 0x41, 0xDB, 0x0C, 0x72, 0x06, 0xB0, 0xE0, 0x32, 0x01, 0x0C,
  0xB0, 0xA7, 0x02, 0xB0, 0xC0, 0x25, 0x0A, 0xB0, 0x58, 0x0E, 0x10, 0x89, 0x02, 0x7B, 0xDF, 0xED,
  0xB7, 0x27, 0x30, 0x10, 0x9F, 0xB0, 0xA0, 0x17, 0x02, 0x0D, 0xFD, 0x0E, 0x03, 0x50, 0x10, 0xDF,
  0xF0, 0xE0, 0x24, 0x0B, 0xE8, 0x2E, 0xAA, 0xDE, 0x0C, 0x30, 0x3E, 0x07, 0x40, 0x5E, 0x04, 0x20,
  0xAD, 0x08, 0x60, 0x7D, 0x0B, 0x20, 0xED, 0x01, 0x7D, 0x81, 0xE0, 0x2D, 0x0B, 0x71, 0x0B, 0xD0,
  0x30, 0x5D, 0x09, 0x71, 0x09, 0xD0, 0x40, 0x5D, 0x07, 0x71, 0x07, 0xD0, 0x50, 0x6D, 0x07, 0x71,
  0x07, 0xD0, 0x05, 0xD0, 0x97, 0x10, 0x9D, 0x05, 0x03, 0xD0, 0xB7, 0x10, 0xBD, 0x02, 0x1E, 0x01,
  0x7D, 0x0E, 0x20, 0xBD, 0x08, 0x60, 0x7D, 0x0A, 0x20, 0x4E, 0x07, 0x40, 0x5E, 0x04, 0x30, 0xBE,
  0x82, 0xEA, 0xAD, 0xE0, 0xB4, 0x02, 0x0E, 0xFF, 0x0E, 0x02, 0x50, 0x30, 0xEF, 0xD0, 0xE0, 0x37,
  0x01, 0x0A, 0xFB, 0x0B, 0x01, 0x73, 0x82, 0x28, 0xBE, 0xA8, 0x2E, 0xB8, 0x36,
  // "õ" (U+00F5)
  0x58, 0x43, 0xBE, 0xEA, 0x44, 0x06, 0xA0, 0x87, 0x02, 0x0E, 0xD8, 0x3C, 0x51, 0x1D, 0xA0, 0x67,
  0x0A, 0xFE, 0x02, 0x60, 0x1F, 0xE0, 0xC7, 0x05, 0xA8, 0x3C, 0x11, 0x6D, 0xD0, 0xE0, 0x37, 0x07,
  0xA0, 0x64, 0x84, 0x4A, 0xEE, 0xB2, 0x80, 0xE3, 0x08, 0x90, 0x27, 0xBD, 0xFE, 0xDB, 0x72, 0x73,
  0x01, 0x09, 0xFB, 0x0A, 0x01, 0x70, 0x20, 0xDF, 0xD0, 0xE0, 0x35, 0x01, 0x0D, 0xFF, 0x0E, 0x02,
  0x40, 0xBE, 0x82, 0xEA, 0xAD, 0xE0, 0xC3, 0x03, 0xE0, 0x74, 0x05, 0xE0, 0x42, 0x0A, 0xD0, 0x86,
  0x07, 0xD0, 0xB2, 0x0E, 0xD0, 0x17, 0xD8, 0x1E, 0x02, 0xD0, 0xB7, 0x10, 0xBD, 0x03, 0x05, 0xD0,
  0x97, 0x10, 0x9D, 0x04, 0x05, 0xD0, 0x77, 0x10, 0x7D, 0x05, 0x06, 0xD0, 0x77, 0x10, 0x7D, 0x00,
  0x5D, 0x09, 0x71, 0x09, 0xD0, 0x50, 0x3D, 0x0B, 0x71, 0x0B, 0xD0, 0x21, 0xE0, 0x17, 0xD0, 0xE2,
  0x0B, 0xD0, 0x86, 0x07, 0xD0, 0xA2, 0x04, 0xE0, 0x74, 0x05, 0xE0, 0x43, 0x0B, 0xE8, 0x2E, 0xAA,
  0xDE, 0x0B, 0x40, 0x20, 0xEF, 0xF0, 0xE0, 0x25, 0x03, 0x0E, 0xFD, 0x0E, 0x03, 0x70, 0x10, 0xAF,
  0xB0, 0xB0, 0x17, 0x38, 0x22, 0x8B, 0xEA, 0x82, 0xEB, 0x83, 0x60,
  // "ö" (U+00F6)
  0x48, 0x35, 0xDE, 0xC3, 0x48, 0x32, 0xBE, 0xD7, 0x70, 0x2C, 0x0E, 0x40, 0xCC, 0x05, 0x60, 0x5D,
  0x03, 0x3D, 0x09, 0x60, 0x5D, 0x03, 0x3D, 0x09, 0x60, 0x1C, 0x0D, 0x40, 0xBC, 0x04, 0x78, 0x34,
  0xCE, 0xB3, 0x48, 0x31, 0xAE, 0xD6, 0x80, 0xE2, 0x08, 0x90, 0x27, 0xBD, 0xFE, 0xDB, 0x72, 0x73,
  0x01, 0x09, 0xFB, 0x0A, 0x01, 0x70, 0x20, 0xDF, 0xD0, 0xE0, 0x35, 0x01, 0x0D, 0xFF, 0x0E, 0x02,
  0x40, 0xBE, 0x82, 0xEA, 0xAD, 0xE0, 0xC3, 0x03, 0xE0, 0x74, 0x05, 0xE0, 0x42, 0x0A, 0xD0, 0x86,
  0x07, 0xD0, 0xB2, 0x0E, 0xD0, 0x17, 0xD8, 0x1E, 0x02, 0xD0, 0xB7, 0x10, 0xBD, 0x03, 0x05, 0xD0,
  0x97, 0x10, 0x9D, 0x04, 0x05, 0xD0, 0x77, 0x10, 0x7D, 0x05, 0x06, 0xD0, 0x77, 0x10, 0x7D, 0x00,
  0x5D, 0x09, 0x71, 0x09, 0xD0, 0x50, 0x3D, 0x0B, 0x71, 0x0B, 0xD0, 0x21, 0xE0, 0x17, 0xD0, 0xE2,
  0x0B, 0xD0, 0x86, 0x07, 0xD0, 0xA2, 0x04, 0xE0, 0x74, 0x05, 0xE0, 0x43, 0x0B, 0xE8, 0x2E, 0xAA,
  0xDE, 0x0B, 0x40, 0x20, 0xEF, 0xF0, 0xE0, 0x25, 0x03, 0x0E, 0xFD, 0x0E, 0x03, 0x70, 0x10, 0xAF,
  0xB0, 0xB0, 0x17, 0x38, 0x22, 0x8B, 0xEA, 0x82, 0xEB, 0x83, 0x60,
  // "÷" (U+00F7)
  0x71, 0x82, 0x8E, 0xE8, 0x77, 0x10, 0x6C, 0x06, 0x77, 0x09, 0xC0, 0xA7, 0x70, 0x9C, 0x09, 0x77,
  0x05, 0xC0, 0x67, 0x71, 0x82, 0x8E, 0xE8, 0x77, 0x77, 0x02, 0x80, 0x96, 0x90, 0x20, 0x3F, 0xFC,
  0x00, 0x3F, 0xFC, 0x00, 0x3F, 0xFC, 0x00, 0x3F, 0xFC, 0x03, 0x80, 0xD4, 0x08, 0x28, 0xEE, 0x87,
  0x71, 0x06, 0xC0, 0x67, 0x70, 0x9C, 0x0A, 0x77, 0x09, 0xC0, 0x97, 0x70, 0x5C, 0x05, 0x77, 0x18,
  0x28, 0xEE, 0x87, 0x10,
  // "ø" (U+00F8)
  0x77, 0x20, 0x10, 0x87, 0x38, 0x22, 0x7B, 0xDA, 0x86, 0xEB, 0x72, 0xAF, 0xC2, 0x60, 0x10, 0x9F,
  0xE0, 0xD5, 0x02, 0x0D, 0xFF, 0x04, 0x40, 0x10, 0xEF, 0xF0, 0xE0, 0x14, 0x0B, 0xE8, 0x2E, 0xAB,
  0xEE, 0x0B, 0x30, 0x4E, 0x07, 0x30, 0x2F, 0x03, 0x20, 0xAD, 0x08, 0x40, 0xAF, 0x0A, 0x20, 0xED,
  0x01, 0x30, 0x6F, 0x98, 0x1E, 0x02, 0xD0, 0xB3, 0x02, 0x0E, 0xB0, 0xDD, 0x02, 0x05, 0xD0, 0x93,
  0x0C, 0xB0, 0x70, 0x9D, 0x04, 0x05, 0xD0, 0x72, 0x08, 0xB8, 0x1B, 0x08, 0xD0, 0x05, 0xD8, 0x17,
  0x04, 0xB8, 0x2E, 0x10, 0x7D, 0x05, 0x04, 0xD8, 0x19, 0x1E, 0xB0, 0x42, 0x08, 0xD0, 0x50, 0x3D,
  0x0B, 0x0A, 0xB0, 0x83, 0x0B, 0xD8, 0x13, 0x0E, 0xF9, 0x0C, 0x40, 0xEC, 0x0E, 0x20, 0xAF, 0x0E,
  0x02, 0x30, 0x7D, 0x0A, 0x20, 0x3F, 0x06, 0x30, 0x5E, 0x04, 0x30, 0xBE, 0x82, 0xDA, 0xAD, 0xE0,
  0xC4, 0x01, 0x0D, 0xFF, 0x0E, 0x02, 0x40, 0x10, 0xDF, 0xE0, 0xE0, 0x35, 0x09, 0xFE, 0x0B, 0x01,
  0x60, 0x7A, 0x89, 0x1D, 0x27, 0xBD, 0xEF, 0xEB, 0x83, 0x72, 0x81, 0x2C, 0x47, 0x72,
  // "ù" (U+00F9)
  0x30, 0x48, 0x02, 0x77, 0x60, 0x20, 0xDD, 0x05, 0x76, 0x02, 0x0E, 0xC0, 0xE0, 0x17, 0x60, 0x20,
  0xDC, 0x09, 0x77, 0x02, 0x0D, 0xC0, 0x47, 0x70, 0x10, 0xCB, 0x0E, 0x01, 0x77, 0x10, 0xAB, 0x09,
  0x80, 0xD2, 0x0D, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C,
  0x71, 0xD0, 0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C,
  0x71, 0xD0, 0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C,
  0x70, 0x1D, 0x0C, 0xD0, 0xC7, 0x02, 0xD0, 0xCD, 0x0D, 0x70, 0x4D, 0x0C, 0xE7, 0x09, 0xD0, 0xC0,
  0xED, 0x04, 0x50, 0x10, 0xED, 0x0C, 0x0B, 0xD0, 0xC0, 0x13, 0x02, 0x0C, 0xE0, 0xC0, 0x7E, 0x82,
  0xEB, 0xAC, 0xF9, 0x0C, 0x01, 0xFF, 0xC8, 0x1C, 0x06, 0xFC, 0x0B, 0x07, 0xC0, 0xC2, 0x06, 0xFA,
  0x81, 0x90, 0x1C, 0x0C, 0x38, 0x72, 0x8C, 0xEF, 0xDC, 0x72, 0x30, 0xBB, 0x0C,
  // "ú" (U+00FA)
  0x73, 0x02, 0x80, 0x27, 0x01, 0x75, 0x0B, 0xD0, 0xA7, 0x50, 0x5D, 0x0A, 0x75, 0x01, 0x0E, 0xC0,
  0x97, 0x60, 0xAC, 0x09, 0x76, 0x06, 0xC0, 0x77, 0x70, 0xEB, 0x05, 0x80, 0xD4, 0x0D, 0x0C, 0x71,
  0xD0, 0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x71,
  0xD0, 0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x71,
  0xD0, 0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x70, 0x1D, 0x0C, 0xD0, 0xC7,
  0x02, 0xD0, 0xCD, 0x0D, 0x70, 0x4D, 0x0C, 0xE7, 0x09, 0xD0, 0xC0, 0xED, 0x04, 0x50, 0x10, 0xED,
  0x0C, 0x0B, 0xD0, 0xC0, 0x13, 0x02, 0x0C, 0xE0, 0xC0, 0x7E, 0x82, 0xEB, 0xAC, 0xF9, 0x0C, 0x01,
  0xFF, 0xC8, 0x1C, 0x06, 0xFC, 0x0B, 0x07, 0xC0, 0xC2, 0x06, 0xFA, 0x81, 0x90, 0x1C, 0x0C, 0x38,
  0x72, 0x8C, 0xEF, 0xDC, 0x72, 0x30, 0xBB, 0x0C,
  // "û" (U+00FB)
  0x78, 0x02, 0x70, 0x17, 0x50, 0x6E, 0x0A, 0x74, 0x02, 0x0E, 0xF0, 0x57, 0x30, 0xCC, 0x0D, 0xB0,
  0xE0, 0x27, 0x10, 0x9B, 0x82, 0xE4, 0x1D, 0xB0, 0xC7, 0x06, 0xB0, 0xE0, 0x32, 0x01, 0x0C, 0xB0,
  0xA5, 0x02, 0xB0, 0xC0, 0x25, 0x0A, 0xB0, 0x58, 0x0C, 0x60, 0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7,
  0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7,
  0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7,
  0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x01, 0xD0, 0xCD, 0x0C, 0x70, 0x2D, 0x0C, 0xD0,
  0xD7, 0x04, 0xD0, 0xCE, 0x70, 0x9D, 0x0C, 0x0E, 0xD0, 0x45, 0x01, 0x0E, 0xD0, 0xC0, 0xBD, 0x0C,
  0x01, 0x30, 0x20, 0xCE, 0x0C, 0x07, 0xE8, 0x2E, 0xBA, 0xCF, 0x90, 0xC0, 0x1F, 0xFC, 0x81, 0xC0,
  0x6F, 0xC0, 0xB0, 0x7C, 0x0C, 0x20, 0x6F, 0xA8, 0x19, 0x01, 0xC0, 0xC3, 0x87, 0x28, 0xCE, 0xFD,
  0xC7, 0x23, 0x0B, 0xB0, 0xC0,
  // "ü" (U+00FC)
  0x38, 0x35, 0xDE, 0xC3, 0x48, 0x32, 0xBE, 0xD7, 0x50, 0x2C, 0x0E, 0x40, 0xCC, 0x05, 0x40, 0x5D,
  0x03, 0x3D, 0x09, 0x40, 0x5D, 0x03, 0x3D, 0x09, 0x40, 0x1C, 0x0D, 0x40, 0xBC, 0x04, 0x58, 0x34,
  0xCE, 0xB3, 0x48, 0x31, 0xAE, 0xD6, 0x80, 0xC7, 0x0D, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x71, 0xD0,
  0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x71, 0xD0,
  0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x71, 0xD0,
  0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x70, 0x1D, 0x0C, 0xD0, 0xC7, 0x02, 0xD0, 0xCD, 0x0D, 0x70,
  0x4D, 0x0C, 0xE7, 0x09, 0xD0, 0xC0, 0xED, 0x04, 0x50, 0x10, 0xED, 0x0C, 0x0B, 0xD0, 0xC0, 0x13,
  0x02, 0x0C, 0xE0, 0xC0, 0x7E, 0x82, 0xEB, 0xAC, 0xF9, 0x0C, 0x01, 0xFF, 0xC8, 0x1C, 0x06, 0xFC,
  0x0B, 0x07, 0xC0, 0xC2, 0x06, 0xFA, 0x81, 0x90, 0x1C, 0x0C, 0x38, 0x72, 0x8C, 0xEF, 0xDC, 0x72,
  0x30, 0xBB, 0x0C,
  // "ý" (U+00FD)
  0x74, 0x02, 0x80, 0x27, 0x01, 0x77, 0x0B, 0xD0, 0xA7, 0x70, 0x5D, 0x0A, 0x77, 0x01, 0x0E, 0xC0,
  0x97, 0x71, 0x0A, 0xC0, 0x97, 0x71, 0x06, 0xC0, 0x77, 0x72, 0x0E, 0xB0, 0x58, 0x0E, 0x10, 0x0E,
  0xD0, 0x47, 0x10, 0x3D, 0x0E, 0x09, 0xD0, 0x97, 0x10, 0x7D, 0x0A, 0x03, 0xD0, 0xE7, 0x10, 0xCD,
  0x81, 0x40, 0xCD, 0x04, 0x60, 0x1D, 0x0D, 0x20, 0x6D, 0x09, 0x60, 0x6D, 0x08, 0x30, 0xEC, 0x0E,
  0x60, 0xAD, 0x02, 0x30, 0x9D, 0x04, 0x50, 0xEC, 0x0C, 0x40, 0x3D, 0x0A, 0x40, 0x4D, 0x06, 0x50,
  0xCC, 0x0E, 0x40, 0x9D, 0x01, 0x50, 0x6D, 0x04, 0x30, 0xDC, 0x0A, 0x70, 0xEC, 0x0A, 0x20, 0x2D,
  0x04, 0x70, 0x9C, 0x0E, 0x20, 0x7C, 0x0E, 0x71, 0x03, 0xD8, 0x14, 0x0C, 0xC0, 0x87, 0x20, 0xCC,
  0x09, 0x01, 0xD0, 0x37, 0x20, 0x6C, 0x0D, 0x05, 0xC0, 0xC7, 0x40, 0xEC, 0x09, 0xC0, 0x77, 0x40,
  0x9F, 0xA0, 0x17, 0x40, 0x3F, 0x90, 0xB7, 0x60, 0xCF, 0x05, 0x76, 0x06, 0xE0, 0xE7, 0x71, 0x0E,
  0xD0, 0x97, 0x71, 0x0A, 0xD0, 0x37, 0x71, 0x0E, 0xC0, 0xD7, 0x71, 0x06, 0xD0, 0x67, 0x70, 0x10,
  0xDC, 0x0E, 0x01, 0x76, 0x02, 0x0C, 0xD0, 0x77, 0x38, 0x28, 0xBA, 0xCE, 0x0D, 0x74, 0x09, 0xFA,
  0x04, 0x74, 0x09, 0xF9, 0x06, 0x75, 0x09, 0xE0, 0xE0, 0x47, 0x60, 0x70, 0xDA, 0x81, 0xEB, 0x67,
  0x70,
  // "þ" (U+00FE)
  0x0C, 0xC0, 0xD7, 0x71, 0x0C, 0xC0, 0xD7, 0x71, 0x0C, 0xC0, 0xD7, 0x71, 0x0C, 0xC0, 0xD7, 0x71,
  0x0C, 0xC0, 0xD7, 0x71, 0x0C, 0xC0, 0xD7, 0x71, 0x0C, 0xC0, 0xD7, 0x71, 0x0C, 0xC0, 0xD7, 0x71,
  0x0C, 0xC0, 0xD2, 0x86, 0x27, 0xCE, 0xFE, 0xB5, 0x50, 0xCC, 0x81, 0xC0, 0x7F, 0x90, 0xC0, 0x13,
  0x0C, 0xC0, 0xB0, 0x8F, 0xB0, 0xC3, 0x0C, 0xFF, 0xB0, 0x92, 0x0C, 0xF8, 0x2E, 0xBA, 0xCF, 0x81,
  0x20, 0xCE, 0x0A, 0x40, 0x4E, 0x81, 0x80, 0xCD, 0x0C, 0x60, 0x7D, 0x81, 0xC0, 0xCD, 0x04, 0x60,
  0x1E, 0x01, 0x0C, 0xD7, 0x10, 0xCD, 0x03, 0x0C, 0xC0, 0xE7, 0x10, 0xAD, 0x04, 0x0C, 0xC0, 0xD7,
  0x10, 0x9D, 0x05, 0x0C, 0xC0, 0xD7, 0x10, 0x9D, 0x05, 0x0C, 0xC0, 0xE7, 0x10, 0xAD, 0x04, 0x0C,
  0xD0, 0x17, 0x0C, 0xD0, 0x30, 0xCD, 0x06, 0x7E, 0x10, 0xCD, 0x0D, 0x60, 0x6D, 0x81, 0xD0, 0xCE,
  0x0A, 0x01, 0x30, 0x40, 0xED, 0x81, 0x70, 0xCF, 0x82, 0xEB, 0xAC, 0xF8, 0x12, 0x0C, 0xFF, 0xB0,
  0x82, 0x0C, 0xC0, 0xB0, 0xCF, 0xB0, 0xB3, 0x0C, 0xC8, 0x1B, 0x1A, 0xF9, 0x0A, 0x40, 0xCC, 0x0C,
  0x28, 0x63, 0x8C, 0xEE, 0xD9, 0x35, 0x0C, 0xC0, 0xD7, 0x71, 0x0C, 0xC0, 0xD7, 0x71, 0x0C, 0xC0,
  0xD7, 0x71, 0x0C, 0xC0, 0xD7, 0x71, 0x0C, 0xC0, 0xD7, 0x71, 0x0C, 0xC0, 0xD7, 0x71, 0x0C, 0xC0,
  0xD7, 0x71, 0x0C, 0xC0, 0xD7, 0x71, 0x0C, 0xC0, 0xD7, 0x71,
  // "ÿ" (U+00FF)
  0x48, 0x35, 0xDE, 0xC3, 0x48, 0x32, 0xBE, 0xD7, 0x70, 0x2C, 0x0E, 0x40, 0xCC, 0x05, 0x60, 0x5D,
  0x03, 0x3D, 0x09, 0x60, 0x5D, 0x03, 0x3D, 0x09, 0x60, 0x1C, 0x0D, 0x40, 0xBC, 0x04, 0x78, 0x34,
  0xCE, 0xB3, 0x48, 0x31, 0xAE, 0xD6, 0x80, 0xD4, 0x00, 0xED, 0x04, 0x71, 0x03, 0xD0, 0xE0, 0x9D,
  0x09, 0x71, 0x07, 0xD0, 0xA0, 0x3D, 0x0E, 0x71, 0x0C, 0xD8, 0x14, 0x0C, 0xD0, 0x46, 0x01, 0xD0,
  0xD2, 0x06, 0xD0, 0x96, 0x06, 0xD0, 0x83, 0x0E, 0xC0, 0xE6, 0x0A, 0xD0, 0x23, 0x09, 0xD0, 0x45,
  0x0E, 0xC0, 0xC4, 0x03, 0xD0, 0xA4, 0x04, 0xD0, 0x65, 0x0C, 0xC0, 0xE4, 0x09, 0xD0, 0x15, 0x06,
  0xD0, 0x43, 0x0D, 0xC0, 0xA7, 0x0E, 0xC0, 0xA2, 0x02, 0xD0, 0x47, 0x09, 0xC0, 0xE2, 0x07, 0xC0,
  0xE7, 0x10, 0x3D, 0x81, 0x40, 0xCC, 0x08, 0x72, 0x0C, 0xC0, 0x90, 0x1D, 0x03, 0x72, 0x06, 0xC0,
  0xD0, 0x5C, 0x0C, 0x74, 0x0E, 0xC0, 0x9C, 0x07, 0x74, 0x09, 0xFA, 0x01, 0x74, 0x03, 0xF9, 0x0B,
  0x76, 0x0C, 0xF0, 0x57, 0x60, 0x6E, 0x0E, 0x77, 0x10, 0xED, 0x09, 0x77, 0x10, 0xAD, 0x03, 0x77,
  0x10, 0xEC, 0x0D, 0x77, 0x10, 0x6D, 0x06, 0x77, 0x01, 0x0D, 0xC0, 0xE0, 0x17, 0x60, 0x20, 0xCD,
  0x07, 0x73, 0x82, 0x8B, 0xAC, 0xE0, 0xD7, 0x40, 0x9F, 0xA0, 0x47, 0x40, 0x9F, 0x90, 0x67, 0x50,
  0x9E, 0x0E, 0x04, 0x76, 0x07, 0x0D, 0xA8, 0x1E, 0xB6, 0x77,
  // "Ā" (U+0100)
  0x6F, 0xD0, 0x17, 0x4F, 0xD0, 0x17, 0x4F, 0xD0, 0x17, 0x4F, 0xD0, 0x18, 0x09, 0xD1, 0x00, 0xDE,
  0x0C, 0x77, 0x10, 0x2F, 0x90, 0x17, 0x70, 0x6F, 0x90, 0x67, 0x70, 0xBF, 0x90, 0xA7, 0x70, 0xEF,
  0x90, 0xE7, 0x60, 0x4C, 0x00, 0xBC, 0x03, 0x75, 0x08, 0xC0, 0x08, 0xC0, 0x87, 0x50, 0xCC, 0x00,
  0x4C, 0x0C, 0x74, 0x01, 0xD2, 0xD0, 0x17, 0x30, 0x6C, 0x0C, 0x20, 0xCC, 0x05, 0x73, 0x0A, 0xC0,
  0x82, 0x08, 0xC0, 0xA7, 0x30, 0xEC, 0x04, 0x20, 0x4C, 0x0E, 0x72, 0x03, 0xD4, 0xD0, 0x37, 0x10,
  0x8C, 0x0B, 0x40, 0xCC, 0x07, 0x71, 0x0C, 0xC0, 0x74, 0x08, 0xC0, 0xC7, 0x01, 0xD0, 0x34, 0x04,
  0xD0, 0x16, 0x05, 0xD8, 0x4A, 0x99, 0x99, 0xAD, 0x05, 0x60, 0xAF, 0xFA, 0x09, 0x60, 0xEF, 0xFA,
  0x0E, 0x50, 0x3F, 0xFC, 0x03, 0x40, 0x7F, 0xFC, 0x07, 0x40, 0xBC, 0x0A, 0x71, 0x0C, 0xC0, 0xB3,
  0x01, 0xD0, 0x67, 0x10, 0x8D, 0x30, 0x5D, 0x02, 0x71, 0x04, 0xD0, 0x52, 0x09, 0xC0, 0xE7, 0x20,
  0x1D, 0x09, 0x20, 0xDC, 0x0A, 0x73, 0x0C, 0xC8, 0x1D, 0x02, 0xD0, 0x67, 0x30, 0x8D, 0x02, 0x07,
  0xD0, 0x27, 0x30, 0x5D, 0x07,
  // "ā" (U+0101)
  0x4F, 0xD0, 0x17, 0xFD, 0x01, 0x7F, 0xD0, 0x17, 0xFD, 0x01, 0x80, 0xF7, 0x08, 0x91, 0x48, 0xBD,
  0xEF, 0xED, 0xB9, 0x46, 0x81, 0x28, 0xEF, 0xC0, 0xD0, 0x54, 0x06, 0xFF, 0x90, 0x74, 0x0D, 0xFF,
  0x90, 0x43, 0x06, 0xB8, 0x4E, 0xCA, 0xAA, 0xCE, 0x0D, 0x48, 0x19, 0x52, 0x60, 0x20, 0xCD, 0x02,
  0x76, 0x03, 0xD0, 0x47, 0x60, 0x1D, 0x06, 0x48, 0x25, 0x9C, 0xEF, 0xC0, 0x62, 0x05, 0x0D, 0xFF,
  0x98, 0x16, 0x07, 0xFF, 0xB0, 0x60, 0x2E, 0x08, 0x03, 0x40, 0x1D, 0x06, 0x09, 0xD0, 0x46, 0x01,
  0xD0, 0x60, 0xDC, 0x0C, 0x70, 0x2D, 0x06, 0x0E, 0xC0, 0xA7, 0x06, 0xD0, 0x6D, 0x0D, 0x60, 0x10,
  0xDD, 0x06, 0x0D, 0xD0, 0x74, 0x03, 0x0D, 0xE0, 0x60, 0xAE, 0x82, 0xDA, 0xAD, 0xF9, 0x06, 0x05,
  0xFF, 0xC8, 0x16, 0x0B, 0xFC, 0x04, 0x0B, 0xC8, 0x26, 0x01, 0xBF, 0x98, 0x2C, 0x30, 0x7C, 0x06,
  0x38, 0x65, 0xAD, 0xFE, 0xD9, 0x53, 0x02, 0xC0, 0x60,
  // "Ă" (U+0102)
  0x58, 0x24, 0x77, 0x66, 0x82, 0x47, 0x76, 0x73, 0x07, 0xA0, 0xE0, 0x15, 0x0C, 0xA0, 0xB7, 0x30,
  0x4B, 0x84, 0xC4, 0x10, 0x3A, 0xB0, 0x77, 0x40, 0xEF, 0xC0, 0x27, 0x40, 0x5F, 0xB0, 0x77, 0x60,
  0x6F, 0x90, 0x87, 0x71, 0x86, 0x29, 0xDE, 0xFD, 0x93, 0x80, 0x9A, 0x40, 0x0D, 0xE0, 0xC7, 0x71,
  0x02, 0xF9, 0x01, 0x77, 0x06, 0xF9, 0x06, 0x77, 0x0B, 0xF9, 0x0A, 0x77, 0x0E, 0xF9, 0x0E, 0x76,
  0x04, 0xC0, 0x0B, 0xC0, 0x37, 0x50, 0x8C, 0x00, 0x8C, 0x08, 0x75, 0x0C, 0xC0, 0x04, 0xC0, 0xC7,
  0x40, 0x1D, 0x2D, 0x01, 0x73, 0x06, 0xC0, 0xC2, 0x0C, 0xC0, 0x57, 0x30, 0xAC, 0x08, 0x20, 0x8C,
  0x0A, 0x73, 0x0E, 0xC0, 0x42, 0x04, 0xC0, 0xE7, 0x20, 0x3D, 0x4D, 0x03, 0x71, 0x08, 0xC0, 0xB4,
  0x0C, 0xC0, 0x77, 0x10, 0xCC, 0x07, 0x40, 0x8C, 0x0C, 0x70, 0x1D, 0x03, 0x40, 0x4D, 0x01, 0x60,
  0x5D, 0x84, 0xA9, 0x99, 0x9A, 0xD0, 0x56, 0x0A, 0xFF, 0xA0, 0x96, 0x0E, 0xFF, 0xA0, 0xE5, 0x03,
  0xFF, 0xC0, 0x34, 0x07, 0xFF, 0xC0, 0x74, 0x0B, 0xC0, 0xA7, 0x10, 0xCC, 0x0B, 0x30, 0x1D, 0x06,
  0x71, 0x08, 0xD3, 0x05, 0xD0, 0x27, 0x10, 0x4D, 0x05, 0x20, 0x9C, 0x0E, 0x72, 0x01, 0xD0, 0x92,
  0x0D, 0xC0, 0xA7, 0x30, 0xCC, 0x81, 0xD0, 0x2D, 0x06, 0x73, 0x08, 0xD0, 0x20, 0x7D, 0x02, 0x73,
  0x05, 0xD0, 0x70,
  // "ă" (U+0103)
  0x38, 0x24, 0x77, 0x66, 0x82, 0x47, 0x76, 0x60, 0x7A, 0x0E, 0x01, 0x50, 0xCA, 0x0B, 0x60, 0x4B,
  0x84, 0xC4, 0x10, 0x3A, 0xB0, 0x77, 0x0E, 0xFC, 0x02, 0x70, 0x5F, 0xB0, 0x77, 0x20, 0x6F, 0x90,
  0x87, 0x48, 0x62, 0x9D, 0xEF, 0xD9, 0x38, 0x0D, 0x60, 0x89, 0x14, 0x8B, 0xDE, 0xFE, 0xDB, 0x94,
  0x68, 0x12, 0x8E, 0xFC, 0x0D, 0x05, 0x40, 0x6F, 0xF9, 0x07, 0x40, 0xDF, 0xF9, 0x04, 0x30, 0x6B,
  0x84, 0xEC, 0xAA, 0xAC, 0xE0, 0xD4, 0x81, 0x95, 0x26, 0x02, 0x0C, 0xD0, 0x27, 0x60, 0x3D, 0x04,
  0x76, 0x01, 0xD0, 0x64, 0x82, 0x59, 0xCE, 0xFC, 0x06, 0x20, 0x50, 0xDF, 0xF9, 0x81, 0x60, 0x7F,
  0xFB, 0x06, 0x02, 0xE0, 0x80, 0x34, 0x01, 0xD0, 0x60, 0x9D, 0x04, 0x60, 0x1D, 0x06, 0x0D, 0xC0,
  0xC7, 0x02, 0xD0, 0x60, 0xEC, 0x0A, 0x70, 0x6D, 0x06, 0xD0, 0xD6, 0x01, 0x0D, 0xD0, 0x60, 0xDD,
  0x07, 0x40, 0x30, 0xDE, 0x06, 0x0A, 0xE8, 0x2D, 0xAA, 0xDF, 0x90, 0x60, 0x5F, 0xFC, 0x81, 0x60,
  0xBF, 0xC0, 0x40, 0xBC, 0x82, 0x60, 0x1B, 0xF9, 0x82, 0xC3, 0x07, 0xC0, 0x63, 0x86, 0x5A, 0xDF,
  0xED, 0x95, 0x30, 0x2C, 0x06,
  // "Ą" (U+0104)
  0x71, 0x0D, 0xE0, 0xC7, 0x71, 0x02, 0xF9, 0x01, 0x77, 0x06, 0xF9, 0x06, 0x77, 0x0B, 0xF9, 0x0A,
  0x77, 0x0E, 0xF9, 0x0E, 0x76, 0x04, 0xC0, 0x0B, 0xC0, 0x37, 0x50, 0x8C, 0x00, 0x8C, 0x08, 0x75,
  0x0C, 0xC0, 0x04, 0xC0, 0xC7, 0x40, 0x1D, 0x2D, 0x01, 0x73, 0x06, 0xC0, 0xC2, 0x0C, 0xC0, 0x57,
  0x30, 0xAC, 0x08, 0x20, 0x8C, 0x0A, 0x73, 0x0E, 0xC0, 0x42, 0x04, 0xC0, 0xE7, 0x20, 0x3D, 0x4D,
  0x03, 0x71, 0x08, 0xC0, 0xB4, 0x0C, 0xC0, 0x77, 0x10, 0xCC, 0x07, 0x40, 0x8C, 0x0C, 0x70, 0x1D,
  0x03, 0x40, 0x4D, 0x01, 0x60, 0x5D, 0x84, 0xA9, 0x99, 0x9A, 0xD0, 0x56, 0x0A, 0xFF, 0xA0, 0x96,
  0x0E, 0xFF, 0xA0, 0xE5, 0x03, 0xFF, 0xC0, 0x34, 0x07, 0xFF, 0xC0, 0x74, 0x0B, 0xC0, 0xA7, 0x10,
  0xCC, 0x0B, 0x30, 0x1D, 0x06, 0x71, 0x08, 0xD3, 0x05, 0xD0, 0x27, 0x10, 0x4D, 0x05, 0x20, 0x9C,
  0x0E, 0x72, 0x01, 0xD0, 0x92, 0x0D, 0xC0, 0xA7, 0x30, 0xCC, 0x81, 0xD0, 0x2D, 0x06, 0x73, 0x08,
  0xD0, 0x20, 0x7D, 0x02, 0x73, 0x05, 0xD0, 0x77, 0x74, 0x0C, 0xA0, 0xC7, 0x75, 0x09, 0xB0, 0x27,
  0x74, 0x01, 0xB0, 0xB7, 0x75, 0x06, 0xB0, 0x97, 0x75, 0x07, 0xB8, 0x2D, 0x20, 0x37, 0x72, 0x06,
  0xF7, 0x72, 0x02, 0xF7, 0x73, 0x07, 0xE7, 0x74, 0x84, 0x5B, 0xEF, 0xD9,
  // "ą" (U+0105)
  0x48, 0x91, 0x48, 0xBD, 0xEF, 0xED, 0xB9, 0x46, 0x81, 0x28, 0xEF, 0xC0, 0xD0, 0x54, 0x06, 0xFF,
  0x90, 0x74, 0x0D, 0xFF, 0x90, 0x43, 0x06, 0xB8, 0x4E, 0xCA, 0xAA, 0xCE, 0x0D, 0x48, 0x19, 0x52,
  0x60, 0x20, 0xCD, 0x02, 0x76, 0x03, 0xD0, 0x47, 0x60, 0x1D, 0x06, 0x48, 0x25, 0x9C, 0xEF, 0xC0,
  0x62, 0x05, 0x0D, 0xFF, 0x98, 0x16, 0x07, 0xFF, 0xB0, 0x60, 0x2E, 0x08, 0x03, 0x40, 0x1D, 0x06,
  0x09, 0xD0, 0x46, 0x01, 0xD0, 0x60, 0xDC, 0x0C, 0x70, 0x2D, 0x06, 0x0E, 0xC0, 0xA7, 0x06, 0xD0,
  0x6D, 0x0D, 0x60, 0x10, 0xDD, 0x06, 0x0D, 0xD0, 0x74, 0x03, 0x0D, 0xE0, 0x60, 0xAE, 0x82, 0xDA,
  0xAD, 0xF9, 0x06, 0x05, 0xFF, 0xC8, 0x16, 0x0B, 0xFC, 0x04, 0x0B, 0xC8, 0x26, 0x01, 0xBF, 0x98,
  0x2C, 0x30, 0x7C, 0x06, 0x38, 0x65, 0xAD, 0xFE, 0xD9, 0x53, 0x03, 0xC0, 0x67, 0x70, 0xCA, 0x0C,
  0x77, 0x10, 0x9B, 0x02, 0x77, 0x01, 0xB0, 0xB7, 0x71, 0x06, 0xB0, 0x97, 0x71, 0x07, 0xB8, 0x2D,
  0x20, 0x37, 0x50, 0x6F, 0x75, 0x02, 0xF7, 0x60, 0x7E, 0x77, 0x84, 0x5B, 0xEF, 0xD9,
  // "Ć" (U+0106)
  0x75, 0x02, 0x80, 0x27, 0x01, 0x76, 0x0B, 0xD0, 0xA7, 0x60, 0x5D, 0x0A, 0x76, 0x01, 0x0E, 0xC0,
  0x97, 0x70, 0xAC, 0x09, 0x77, 0x06, 0xC0, 0x77, 0x71, 0x0E, 0xB0, 0x58, 0x09, 0x92, 0x08, 0x91,
  0x38, 0xBD, 0xEF, 0xED, 0xB7, 0x37, 0x10, 0x60, 0xDF, 0xC0, 0xD0, 0x24, 0x02, 0x0C, 0xFE, 0x0E,
  0x40, 0x30, 0xEF, 0xF0, 0x83, 0x01, 0x0E, 0xF8, 0x3C, 0xAA, 0xBD, 0xB0, 0x13, 0x0B, 0xE0, 0x80,
  0x15, 0x81, 0x28, 0x93, 0x04, 0xE0, 0x47, 0x60, 0xBD, 0x06, 0x76, 0x02, 0xD0, 0xE7, 0x70, 0x6D,
  0x08, 0x77, 0x09, 0xD0, 0x47, 0x70, 0xCD, 0x01, 0x77, 0x0E, 0xD7, 0x71, 0x0E, 0xC0, 0xE7, 0x71,
  0xD0, 0xD7, 0x71, 0xD0, 0xE7, 0x71, 0x0E, 0xD7, 0x71, 0x0C, 0xD0, 0x27, 0x70, 0x9D, 0x05, 0x77,
  0x06, 0xD0, 0xA7, 0x70, 0x1E, 0x02, 0x77, 0x0B, 0xD0, 0xC0, 0x17, 0x60, 0x4E, 0x0D, 0x05, 0x68,
  0x22, 0x7D, 0x43, 0x0A, 0xF8, 0x4E, 0xBA, 0xAB, 0xEB, 0x04, 0x30, 0x10, 0xCF, 0xF9, 0x04, 0x40,
  0x10, 0xCF, 0xF0, 0x46, 0x07, 0x0E, 0xFC, 0x0E, 0x03, 0x71, 0x82, 0x59, 0xCE, 0xA8, 0x3E, 0xDA,
  0x73, 0x30,
  // "ć" (U+0107)
  0x74, 0x02, 0x80, 0x27, 0x01, 0x74, 0x0B, 0xD0, 0xA7, 0x40, 0x5D, 0x0A, 0x74, 0x01, 0x0E, 0xC0,
  0x97, 0x50, 0xAC, 0x09, 0x75, 0x06, 0xC0, 0x77, 0x60, 0xEB, 0x05, 0x80, 0xD6, 0x08, 0x31, 0x6A,
  0xDE, 0xA8, 0x3E, 0xC9, 0x62, 0x50, 0x10, 0x9F, 0xD0, 0x83, 0x02, 0x0D, 0xFE, 0x05, 0x20, 0x10,
  0xDF, 0xE0, 0xE3, 0x09, 0xF8, 0x3C, 0xAA, 0xBE, 0xA0, 0x92, 0x02, 0xE0, 0xC0, 0x25, 0x81, 0x27,
  0x22, 0x08, 0xD0, 0xD7, 0x50, 0xBD, 0x04, 0x75, 0xD0, 0xE7, 0x50, 0x1D, 0x0C, 0x75, 0x02, 0xD0,
  0xB7, 0x50, 0x2D, 0x0B, 0x75, 0x01, 0xD0, 0xC7, 0x6D, 0x0E, 0x76, 0x0D, 0xD0, 0x47, 0x50, 0xAD,
  0x0C, 0x72, 0x01, 0x20, 0x4E, 0x0B, 0x02, 0x58, 0x23, 0x9F, 0x12, 0x0D, 0xF8, 0x3D, 0xAA, 0xBE,
  0xB0, 0x12, 0x03, 0xFF, 0x90, 0x13, 0x05, 0x0E, 0xFE, 0x01, 0x40, 0x20, 0xBF, 0xC0, 0xC0, 0x16,
  0x89, 0x13, 0x7B, 0xDE, 0xFE, 0xDB, 0x83, 0x20,
  // "Ĉ" (U+0108)
  0x72, 0x80, 0x27, 0x01, 0x76, 0x06, 0xE0, 0xA7, 0x50, 0x20, 0xEF, 0x05, 0x74, 0x0C, 0xC0, 0xDB,
  0x0E, 0x02, 0x72, 0x09, 0xB8, 0x2E, 0x41, 0xDB, 0x0C, 0x71, 0x06, 0xB0, 0xE0, 0x32, 0x01, 0x0C,
  0xB0, 0xA6, 0x02, 0xB0, 0xC0, 0x25, 0x0A, 0xB0, 0x58, 0x09, 0x84, 0x08, 0x91, 0x38, 0xBD, 0xEF,
  0xED, 0xB7, 0x37, 0x10, 0x60, 0xDF, 0xC0, 0xD0, 0x24, 0x02, 0x0C, 0xFE, 0x0E, 0x40, 0x30, 0xEF,
  0xF0, 0x83, 0x01, 0x0E, 0xF8, 0x3C, 0xAA, 0xBD, 0xB0, 0x13, 0x0B, 0xE0, 0x80, 0x15, 0x81, 0x28,
  0x93, 0x04, 0xE0, 0x47, 0x60, 0xBD, 0x06, 0x76, 0x02, 0xD0, 0xE7, 0x70, 0x6D, 0x08, 0x77, 0x09,
  0xD0, 0x47, 0x70, 0xCD, 0x01, 0x77, 0x0E, 0xD7, 0x71, 0x0E, 0xC0, 0xE7, 0x71, 0xD0, 0xD7, 0x71,
  0xD0, 0xE7, 0x71, 0x0E, 0xD7, 0x71, 0x0C, 0xD0, 0x27, 0x70, 0x9D, 0x05, 0x77, 0x06, 0xD0, 0xA7,
  0x70, 0x1E, 0x02, 0x77, 0x0B, 0xD0, 0xC0, 0x17, 0x60, 0x4E, 0x0D, 0x05, 0x68, 0x22, 0x7D, 0x43,
  0x0A, 0xF8, 0x4E, 0xBA, 0xAB, 0xEB, 0x04, 0x30, 0x10, 0xCF, 0xF9, 0x04, 0x40, 0x10, 0xCF, 0xF0,
  0x46, 0x07, 0x0E, 0xFC, 0x0E, 0x03, 0x71, 0x82, 0x59, 0xCE, 0xA8, 0x3E, 0xDA, 0x73, 0x30,
  // "ĉ" (U+0109)
  0x71, 0x80, 0x27, 0x01, 0x74, 0x06, 0xE0, 0xA7, 0x30, 0x20, 0xEF, 0x05, 0x72, 0x0C, 0xC0, 0xDB,
  0x0E, 0x02, 0x70, 0x9B, 0x82, 0xE4, 0x1D, 0xB0, 0xC6, 0x06, 0xB0, 0xE0, 0x32, 0x01, 0x0C, 0xB0,
  0xA4, 0x02, 0xB0, 0xC0, 0x25, 0x0A, 0xB0, 0x58, 0x0D, 0x00, 0x83, 0x16, 0xAD, 0xEA, 0x83, 0xEC,
  0x96, 0x25, 0x01, 0x09, 0xFD, 0x08, 0x30, 0x20, 0xDF, 0xE0, 0x52, 0x01, 0x0D, 0xFE, 0x0E, 0x30,
  0x9F, 0x83, 0xCA, 0xAB, 0xEA, 0x09, 0x20, 0x2E, 0x0C, 0x02, 0x58, 0x12, 0x72, 0x20, 0x8D, 0x0D,
  0x75, 0x0B, 0xD0, 0x47, 0x5D, 0x0E, 0x75, 0x01, 0xD0, 0xC7, 0x50, 0x2D, 0x0B, 0x75, 0x02, 0xD0,
  0xB7, 0x50, 0x1D, 0x0C, 0x76, 0xD0, 0xE7, 0x60, 0xDD, 0x04, 0x75, 0x0A, 0xD0, 0xC7, 0x20, 0x12,
  0x04, 0xE0, 0xB0, 0x25, 0x82, 0x39, 0xF1, 0x20, 0xDF, 0x83, 0xDA, 0xAB, 0xEB, 0x01, 0x20, 0x3F,
  0xF9, 0x01, 0x30, 0x50, 0xEF, 0xE0, 0x14, 0x02, 0x0B, 0xFC, 0x0C, 0x01, 0x68, 0x91, 0x37, 0xBD,
  0xEF, 0xED, 0xB8, 0x32,
  // "Ċ" (U+010A)
  0x72, 0x84, 0x3B, 0xEE, 0xB3, 0x77, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x60, 0x6E, 0x05, 0x76, 0x08,
  0xE0, 0x77, 0x60, 0x6E, 0x05, 0x76, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x78, 0x43, 0xBE, 0xEB, 0x28,
  0x09, 0x91, 0x08, 0x91, 0x38, 0xBD, 0xEF, 0xED, 0xB7, 0x37, 0x10, 0x60, 0xDF, 0xC0, 0xD0, 0x24,
  0x02, 0x0C, 0xFE, 0x0E, 0x40, 0x30, 0xEF, 0xF0, 0x83, 0x01, 0x0E, 0xF8, 0x3C, 0xAA, 0xBD, 0xB0,
  0x13, 0x0B, 0xE0, 0x80, 0x15, 0x81, 0x28, 0x93, 0x04, 0xE0, 0x47, 0x60, 0xBD, 0x06, 0x76, 0x02,
  0xD0, 0xE7, 0x70, 0x6D, 0x08, 0x77, 0x09, 0xD0, 0x47, 0x70, 0xCD, 0x01, 0x77, 0x0E, 0xD7, 0x71,
  0x0E, 0xC0, 0xE7, 0x71, 0xD0, 0xD7, 0x71, 0xD0, 0xE7, 0x71, 0x0E, 0xD7, 0x71, 0x0C, 0xD0, 0x27,
  0x70, 0x9D, 0x05, 0x77, 0x06, 0xD0, 0xA7, 0x70, 0x1E, 0x02, 0x77, 0x0B, 0xD0, 0xC0, 0x17, 0x60,
  0x4E, 0x0D, 0x05, 0x68, 0x22, 0x7D, 0x43, 0x0A, 0xF8, 0x4E, 0xBA, 0xAB, 0xEB, 0x04, 0x30, 0x10,
  0xCF, 0xF9, 0x04, 0x40, 0x10, 0xCF, 0xF0, 0x46, 0x07, 0x0E, 0xFC, 0x0E, 0x03, 0x71, 0x82, 0x59,
  0xCE, 0xA8, 0x3E, 0xDA, 0x73, 0x30,
  // "ċ" (U+010B)
  0x71, 0x84, 0x3B, 0xEE, 0xB3, 0x75, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x40, 0x6E, 0x05, 0x74, 0x08,
  0xE0, 0x77, 0x40, 0x6E, 0x05, 0x74, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x58, 0x43, 0xBE, 0xEB, 0x28,
  0x0D, 0x50, 0x83, 0x16, 0xAD, 0xEA, 0x83, 0xEC, 0x96, 0x25, 0x01, 0x09, 0xFD, 0x08, 0x30, 0x20,
  0xDF, 0xE0, 0x52, 0x01, 0x0D, 0xFE, 0x0E, 0x30, 0x9F, 0x83, 0xCA, 0xAB, 0xEA, 0x09, 0x20, 0x2E,
  0x0C, 0x02, 0x58, 0x12, 0x72, 0x20, 0x8D, 0x0D, 0x75, 0x0B, 0xD0, 0x47, 0x5D, 0x0E, 0x75, 0x01,
  0xD0, 0xC7, 0x50, 0x2D, 0x0B, 0x75, 0x02, 0xD0, 0xB7, 0x50, 0x1D, 0x0C, 0x76, 0xD0, 0xE7, 0x60,
  0xDD, 0x04, 0x75, 0x0A, 0xD0, 0xC7, 0x20, 0x12, 0x04, 0xE0, 0xB0, 0x25, 0x82, 0x39, 0xF1, 0x20,
  0xDF, 0x83, 0xDA, 0xAB, 0xEB, 0x01, 0x20, 0x3F, 0xF9, 0x01, 0x30, 0x50, 0xEF, 0xE0, 0x14, 0x02,
  0x0B, 0xFC, 0x0C, 0x01, 0x68, 0x91, 0x37, 0xBD, 0xEF, 0xED, 0xB8, 0x32,
  // "Č" (U+010C)
  0x48, 0x32, 0x77, 0x74, 0x68, 0x34, 0x77, 0x72, 0x50, 0x10, 0xDB, 0x07, 0x40, 0x7B, 0x0D, 0x01,
  0x60, 0x20, 0xEB, 0x08, 0x20, 0xAB, 0x0E, 0x02, 0x71, 0x05, 0xC0, 0x80, 0xAC, 0x05, 0x73, 0x09,
  0xF9, 0x09, 0x75, 0x0D, 0xE0, 0xD7, 0x60, 0x3E, 0x03, 0x80, 0x99, 0x00, 0x89, 0x13, 0x8B, 0xDE,
  0xFE, 0xDB, 0x73, 0x71, 0x06, 0x0D, 0xFC, 0x0D, 0x02, 0x40, 0x20, 0xCF, 0xE0, 0xE4, 0x03, 0x0E,
  0xFF, 0x08, 0x30, 0x10, 0xEF, 0x83, 0xCA, 0xAB, 0xDB, 0x01, 0x30, 0xBE, 0x08, 0x01, 0x58, 0x12,
  0x89, 0x30, 0x4E, 0x04, 0x76, 0x0B, 0xD0, 0x67, 0x60, 0x2D, 0x0E, 0x77, 0x06, 0xD0, 0x87, 0x70,
  0x9D, 0x04, 0x77, 0x0C, 0xD0, 0x17, 0x70, 0xED, 0x77, 0x10, 0xEC, 0x0E, 0x77, 0x1D, 0x0D, 0x77,
  0x1D, 0x0E, 0x77, 0x10, 0xED, 0x77, 0x10, 0xCD, 0x02, 0x77, 0x09, 0xD0, 0x57, 0x70, 0x6D, 0x0A,
  0x77, 0x01, 0xE0, 0x27, 0x70, 0xBD, 0x0C, 0x01, 0x76, 0x04, 0xE0, 0xD0, 0x56, 0x82, 0x27, 0xD4,
  0x30, 0xAF, 0x84, 0xEB, 0xAA, 0xBE, 0xB0, 0x43, 0x01, 0x0C, 0xFF, 0x90, 0x44, 0x01, 0x0C, 0xFF,
  0x04, 0x60, 0x70, 0xEF, 0xC0, 0xE0, 0x37, 0x18, 0x25, 0x9C, 0xEA, 0x83, 0xED, 0xA7, 0x33,
  // "č" (U+010D)
  0x38, 0x32, 0x77, 0x74, 0x68, 0x34, 0x77, 0x72, 0x30, 0x10, 0xDB, 0x07, 0x40, 0x7B, 0x0D, 0x01,
  0x40, 0x20, 0xEB, 0x08, 0x20, 0xAB, 0x0E, 0x02, 0x60, 0x5C, 0x08, 0x0A, 0xC0, 0x57, 0x10, 0x9F,
  0x90, 0x97, 0x30, 0xDE, 0x0D, 0x74, 0x03, 0xE0, 0x38, 0x0D, 0x40, 0x83, 0x16, 0xAD, 0xEA, 0x83,
  0xEC, 0x96, 0x25, 0x01, 0x09, 0xFD, 0x08, 0x30, 0x20, 0xDF, 0xE0, 0x52, 0x01, 0x0D, 0xFE, 0x0E,
  0x30, 0x9F, 0x83, 0xCA, 0xAB, 0xEA, 0x09, 0x20, 0x2E, 0x0C, 0x02, 0x58, 0x12, 0x72, 0x20, 0x8D,
  0x0D, 0x75, 0x0B, 0xD0, 0x47, 0x5D, 0x0E, 0x75, 0x01, 0xD0, 0xC7, 0x50, 0x2D, 0x0B, 0x75, 0x02,
  0xD0, 0xB7, 0x50, 0x1D, 0x0C, 0x76, 0xD0, 0xE7, 0x60, 0xDD, 0x04, 0x75, 0x0A, 0xD0, 0xC7, 0x20,
  0x12, 0x04, 0xE0, 0xB0, 0x25, 0x82, 0x39, 0xF1, 0x20, 0xDF, 0x83, 0xDA, 0xAB, 0xEB, 0x01, 0x20,
  0x3F, 0xF9, 0x01, 0x30, 0x50, 0xEF, 0xE0, 0x14, 0x02, 0x0B, 0xFC, 0x0C, 0x01, 0x68, 0x91, 0x37,
  0xBD, 0xEF, 0xED, 0xB8, 0x32,
  // "Ď" (U+010E)
  0x28, 0x32, 0x77, 0x74, 0x68, 0x34, 0x77, 0x72, 0x60, 0x10, 0xDB, 0x07, 0x40, 0x7B, 0x0D, 0x01,
  0x70, 0x20, 0xEB, 0x08, 0x20, 0xAB, 0x0E, 0x02, 0x72, 0x05, 0xC0, 0x80, 0xAC, 0x05, 0x74, 0x09,
  0xF9, 0x09, 0x76, 0x0D, 0xE0, 0xD7, 0x70, 0x3E, 0x03, 0x80, 0x98, 0x60, 0x03, 0xFA, 0x83, 0xED,
  0xB6, 0x27, 0x03, 0xFF, 0x0A, 0x02, 0x50, 0x3F, 0xFA, 0x05, 0x40, 0x3F, 0xFB, 0x07, 0x30, 0x3D,
  0x84, 0xC9, 0x9A, 0xBE, 0xF0, 0x42, 0x03, 0xD0, 0x85, 0x05, 0x0E, 0xD0, 0xE2, 0x03, 0xD0, 0x86,
  0x02, 0x0E, 0xD8, 0x16, 0x03, 0xD0, 0x87, 0x05, 0xD8, 0x1D, 0x03, 0xD0, 0x87, 0x10, 0xDD, 0x02,
  0x03, 0xD0, 0x87, 0x10, 0x8D, 0x05, 0x03, 0xD0, 0x87, 0x10, 0x5D, 0x08, 0x03, 0xD0, 0x87, 0x10,
  0x3D, 0x0A, 0x03, 0xD0, 0x87, 0x10, 0x2D, 0x0B, 0x03, 0xD0, 0x87, 0x10, 0x1D, 0x0C, 0x03, 0xD0,
  0x87, 0x10, 0x1D, 0x0B, 0x03, 0xD0, 0x87, 0x10, 0x2D, 0x0A, 0x03, 0xD0, 0x87, 0x10, 0x4D, 0x09,
  0x03, 0xD0, 0x87, 0x10, 0x6D, 0x07, 0x03, 0xD0, 0x87, 0x10, 0xAD, 0x00, 0x3D, 0x08, 0x71, 0x0E,
  0xD1, 0x03, 0xD0, 0x87, 0x07, 0xD8, 0x1A, 0x03, 0xD0, 0x86, 0x04, 0xE8, 0x13, 0x03, 0xD0, 0x84,
  0x01, 0x07, 0xE0, 0xB2, 0x03, 0xD8, 0x3C, 0x99, 0xAC, 0xF0, 0xE0, 0x12, 0x03, 0xFF, 0xA0, 0xE0,
  0x33, 0x03, 0xFF, 0x90, 0xD0, 0x24, 0x03, 0xFE, 0x0E, 0x07, 0x60, 0x3F, 0xA8, 0x3D, 0xC9, 0x51,
  0x70,
  // "ď" (U+010F)
  0x76, 0x0D, 0xC8, 0x1C, 0x03, 0xD0, 0x27, 0x60, 0xDC, 0x81, 0xC0, 0x5C, 0x0A, 0x77, 0x0D, 0xC8,
  0x1C, 0x09, 0xC0, 0x27, 0x70, 0xDC, 0x81, 0xC0, 0xCB, 0x09, 0x77, 0x10, 0xDC, 0x0C, 0x1B, 0x0D,
  0x77, 0x20, 0xDC, 0x0C, 0x04, 0xB0, 0x47, 0x72, 0x0D, 0xC0, 0xC7, 0x77, 0x0C, 0xC0, 0xC7, 0x58,
  0x53, 0x9D, 0xFE, 0xC6, 0x20, 0xCC, 0x0C, 0x74, 0x07, 0xF8, 0x1C, 0x1A, 0xC0, 0xC7, 0x30, 0x7F,
  0xA0, 0xC0, 0x8C, 0x0C, 0x72, 0x02, 0xFF, 0xA0, 0xC7, 0x20, 0xAE, 0x81, 0xDA, 0xBF, 0x0C, 0x72,
  0xE0, 0x73, 0x01, 0x0C, 0xD0, 0xC7, 0x10, 0x3D, 0x0B, 0x50, 0x3D, 0x0C, 0x71, 0x07, 0xD0, 0x66,
  0x0D, 0xC0, 0xC7, 0x10, 0x9D, 0x03, 0x60, 0x9C, 0x0C, 0x71, 0x0A, 0xD0, 0x26, 0x08, 0xC0, 0xC7,
  0x10, 0xBD, 0x01, 0x60, 0x7C, 0x0C, 0x71, 0x0B, 0xD0, 0x16, 0x06, 0xC0, 0xC7, 0x10, 0xAD, 0x02,
  0x60, 0x7C, 0x0C, 0x71, 0x09, 0xD0, 0x46, 0x09, 0xC0, 0xC7, 0x10, 0x7D, 0x07, 0x60, 0xCC, 0x0C,
  0x71, 0x04, 0xD0, 0xC5, 0x03, 0xD0, 0xC7, 0x10, 0x1E, 0x08, 0x30, 0x20, 0xDD, 0x0C, 0x72, 0x09,
  0xE8, 0x1D, 0xAB, 0xF0, 0xC7, 0x20, 0x3F, 0xFA, 0x0C, 0x73, 0x07, 0xFA, 0x08, 0x09, 0xC0, 0xC7,
  0x40, 0x9F, 0x81, 0x90, 0x3C, 0x0C, 0x75, 0x85, 0x4B, 0xEF, 0xDA, 0x43, 0x0C, 0xB0, 0xC7, 0x10,
  // "Đ" (U+0110)
  0x10, 0x3F, 0xA8, 0x3E, 0xDB, 0x62, 0x71, 0x03, 0xFF, 0x0A, 0x02, 0x60, 0x3F, 0xFA, 0x05, 0x50,
  0x3F, 0xFB, 0x07, 0x40, 0x3D, 0x84, 0xC9, 0x9A, 0xBE, 0xF0, 0x43, 0x03, 0xD0, 0x85, 0x05, 0x0E,
  0xD0, 0xE3, 0x03, 0xD0, 0x86, 0x02, 0x0E, 0xD0, 0x62, 0x03, 0xD0, 0x87, 0x05, 0xD0, 0xD2, 0x03,
  0xD0, 0x87, 0x10, 0xDD, 0x81, 0x20, 0x3D, 0x08, 0x71, 0x08, 0xD8, 0x15, 0x03, 0xD0, 0x87, 0x10,
  0x5D, 0x81, 0x80, 0x3D, 0x08, 0x71, 0x03, 0xD0, 0xAF, 0xC0, 0xB4, 0x02, 0xD0, 0xBF, 0xC0, 0xB4,
  0x01, 0xD0, 0xCF, 0xC0, 0xB4, 0x01, 0xD0, 0xBF, 0xC0, 0xB4, 0x02, 0xD8, 0x1A, 0x9B, 0xD8, 0x3C,
  0x99, 0x97, 0x40, 0x4D, 0x81, 0x90, 0x3D, 0x08, 0x71, 0x06, 0xD8, 0x17, 0x03, 0xD0, 0x87, 0x10,
  0xAD, 0x81, 0x30, 0x3D, 0x08, 0x71, 0x0E, 0xD2, 0x03, 0xD0, 0x87, 0x07, 0xD0, 0xA2, 0x03, 0xD0,
  0x86, 0x04, 0xE0, 0x32, 0x03, 0xD0, 0x84, 0x01, 0x07, 0xE0, 0xB3, 0x03, 0xD8, 0x3C, 0x99, 0xAC,
  0xF0, 0xE0, 0x13, 0x03, 0xFF, 0xA0, 0xE0, 0x34, 0x03, 0xFF, 0x90, 0xD0, 0x25, 0x03, 0xFE, 0x0E,
  0x07, 0x70, 0x3F, 0xA8, 0x3D, 0xC9, 0x51, 0x70,
  // "đ" (U+0111)
  0x77, 0x10, 0xDC, 0x0C, 0x77, 0x30, 0xDC, 0x0C, 0x77, 0x30, 0xDC, 0x0C, 0x74, 0x08, 0xFE, 0x72,
  0x08, 0xFE, 0x72, 0x08, 0xFE, 0x72, 0x08, 0xFE, 0x77, 0x10, 0xDC, 0x0C, 0x78, 0x64, 0x9D, 0xEE,
  0xDA, 0x42, 0x0C, 0xC0, 0xC6, 0x0A, 0xF9, 0x81, 0xB1, 0xBC, 0x0C, 0x50, 0xCF, 0xB0, 0xC0, 0x9C,
  0x0C, 0x40, 0x9F, 0xFB, 0x0C, 0x30, 0x2F, 0x82, 0xEB, 0xAC, 0xF0, 0xC3, 0x08, 0xE0, 0x74, 0x04,
  0x0E, 0xD0, 0xC3, 0x0C, 0xD0, 0x86, 0x05, 0xD0, 0xC2, 0x01, 0xE0, 0x17, 0x0E, 0xC0, 0xC2, 0x03,
  0xD0, 0xB7, 0x10, 0xAC, 0x0C, 0x20, 0x4D, 0x09, 0x71, 0x08, 0xC0, 0xC2, 0x05, 0xD0, 0x87, 0x10,
  0x7C, 0x0C, 0x20, 0x5D, 0x07, 0x71, 0x06, 0xC0, 0xC2, 0x04, 0xD0, 0x87, 0x10, 0x7C, 0x0C, 0x20,
  0x3D, 0x0A, 0x71, 0x09, 0xC0, 0xC2, 0x01, 0xD0, 0xE7, 0x10, 0xDC, 0x0C, 0x30, 0xCD, 0x05, 0x60,
  0x4D, 0x0C, 0x30, 0x8D, 0x0E, 0x04, 0x40, 0x40, 0xED, 0x0C, 0x30, 0x3F, 0x82, 0xDA, 0xAD, 0xF0,
  0xC4, 0x0A, 0xFF, 0xB0, 0xC4, 0x01, 0x0D, 0xFB, 0x08, 0x09, 0xC0, 0xC5, 0x01, 0x0C, 0xF9, 0x81,
  0x70, 0x3C, 0x0C, 0x78, 0x65, 0xBE, 0xFE, 0xC8, 0x23, 0x0C, 0xB0, 0xC2,
  // "Ē" (U+0112)
  0x3F, 0xD0, 0x16, 0xFD, 0x01, 0x6F, 0xD0, 0x16, 0xFD, 0x01, 0x80, 0x99, 0x30, 0x0C, 0xFF, 0xB0,
  0x30, 0xCF, 0xFB, 0x03, 0x0C, 0xFF, 0xB0, 0x30, 0xCF, 0xFB, 0x03, 0x0C, 0xC0, 0xE8, 0x09, 0x09,
  0x02, 0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0C, 0x76, 0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0C, 0x76, 0x0C,
  0xC0, 0xC7, 0x60, 0xCC, 0x0C, 0x76, 0x0C, 0xFF, 0xA8, 0x19, 0x0C, 0xFF, 0xA8, 0x19, 0x0C, 0xFF,
  0xA8, 0x19, 0x0C, 0xFF, 0xA8, 0x19, 0x0C, 0xC0, 0xE8, 0x07, 0x98, 0x15, 0x0C, 0xC0, 0xC7, 0x60,
  0xCC, 0x0C, 0x76, 0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0C, 0x76, 0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0C,
  0x76, 0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0E, 0x80, 0x90, 0x90, 0x20, 0xCF, 0xFB, 0x03, 0x0C, 0xFF,
  0xB0, 0x30, 0xCF, 0xFB, 0x03, 0x0C, 0xFF, 0xB0, 0x30,
  // "ē" (U+0113)
  0x4F, 0xD0, 0x17, 0xFD, 0x01, 0x7F, 0xD0, 0x17, 0xFD, 0x01, 0x80, 0x98, 0x00, 0x89, 0x01, 0x6A,
  0xDE, 0xFE, 0xC8, 0x47, 0x20, 0x70, 0xEF, 0xA0, 0xC0, 0x26, 0x0B, 0xFD, 0x0E, 0x04, 0x40, 0xBF,
  0xF0, 0xE0, 0x22, 0x06, 0xE8, 0x2E, 0xBA, 0xBE, 0x0B, 0x20, 0xED, 0x09, 0x01, 0x30, 0x20, 0xCD,
  0x02, 0x05, 0xD0, 0x97, 0x0D, 0xC0, 0x70, 0x9D, 0x01, 0x70, 0x7C, 0x0B, 0x0C, 0xC0, 0xD7, 0x10,
  0x3C, 0x0D, 0x0E, 0xFF, 0xC0, 0xEF, 0xFE, 0x0E, 0xFF, 0xD0, 0xDF, 0xFD, 0x0B, 0xC0, 0xB7, 0x70,
  0x8C, 0x0E, 0x01, 0x76, 0x03, 0xD0, 0xB7, 0x70, 0xBD, 0x0D, 0x05, 0x78, 0x42, 0x6A, 0x50, 0x3F,
  0x98, 0x4C, 0xAA, 0xAC, 0xEB, 0x05, 0x20, 0x6F, 0xFA, 0x05, 0x30, 0x50, 0xEF, 0xF0, 0x54, 0x02,
  0x0A, 0xFD, 0x0D, 0x03, 0x68, 0x31, 0x69, 0xCD, 0xA8, 0x3E, 0xDA, 0x73, 0x20,
  // "Ĕ" (U+0114)
  0x28, 0x24, 0x77, 0x66, 0x82, 0x47, 0x76, 0x50, 0x7A, 0x0E, 0x01, 0x50, 0xCA, 0x0B, 0x50, 0x4B,
  0x84, 0xC4, 0x10, 0x3A, 0xB0, 0x76, 0x0E, 0xFC, 0x02, 0x60, 0x5F, 0xB0, 0x77, 0x10, 0x6F, 0x90,
  0x87, 0x38, 0x62, 0x9D, 0xEF, 0xD9, 0x38, 0x0F, 0x30, 0x0C, 0xFF, 0xB0, 0x30, 0xCF, 0xFB, 0x03,
  0x0C, 0xFF, 0xB0, 0x30, 0xCF, 0xFB, 0x03, 0x0C, 0xC0, 0xE8, 0x09, 0x09, 0x02, 0x0C, 0xC0, 0xC7,
  0x60, 0xCC, 0x0C, 0x76, 0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0C, 0x76, 0x0C, 0xC0, 0xC7, 0x60, 0xCC,
  0x0C, 0x76, 0x0C, 0xFF, 0xA8, 0x19, 0x0C, 0xFF, 0xA8, 0x19, 0x0C, 0xFF, 0xA8, 0x19, 0x0C, 0xFF,
  0xA8, 0x19, 0x0C, 0xC0, 0xE8, 0x07, 0x98, 0x15, 0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0C, 0x76, 0x0C,
  0xC0, 0xC7, 0x60, 0xCC, 0x0C, 0x76, 0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0C, 0x76, 0x0C, 0xC0, 0xC7,
  0x60, 0xCC, 0x0E, 0x80, 0x90, 0x90, 0x20, 0xCF, 0xFB, 0x03, 0x0C, 0xFF, 0xB0, 0x30, 0xCF, 0xFB,
  0x03, 0x0C, 0xFF, 0xB0, 0x30,
  // "ĕ" (U+0115)
  0x38, 0x24, 0x77, 0x66, 0x82, 0x47, 0x76, 0x60, 0x7A, 0x0E, 0x01, 0x50, 0xCA, 0x0B, 0x60, 0x4B,
  0x84, 0xC4, 0x10, 0x3A, 0xB0, 0x77, 0x0E, 0xFC, 0x02, 0x70, 0x5F, 0xB0, 0x77, 0x20, 0x6F, 0x90,
  0x87, 0x48, 0x62, 0x9D, 0xEF, 0xD9, 0x38, 0x0D, 0x70, 0x89, 0x01, 0x6A, 0xDE, 0xFE, 0xC8, 0x47,
  0x20, 0x70, 0xEF, 0xA0, 0xC0, 0x26, 0x0B, 0xFD, 0x0E, 0x04, 0x40, 0xBF, 0xF0, 0xE0, 0x22, 0x06,
  0xE8, 0x2E, 0xBA, 0xBE, 0x0B, 0x20, 0xED, 0x09, 0x01, 0x30, 0x20, 0xCD, 0x02, 0x05, 0xD0, 0x97,
  0x0D, 0xC0, 0x70, 0x9D, 0x01, 0x70, 0x7C, 0x0B, 0x0C, 0xC0, 0xD7, 0x10, 0x3C, 0x0D, 0x0E, 0xFF,
  0xC0, 0xEF, 0xFE, 0x0E, 0xFF, 0xD0, 0xDF, 0xFD, 0x0B, 0xC0, 0xB7, 0x70, 0x8C, 0x0E, 0x01, 0x76,
  0x03, 0xD0, 0xB7, 0x70, 0xBD, 0x0D, 0x05, 0x78, 0x42, 0x6A, 0x50, 0x3F, 0x98, 0x4C, 0xAA, 0xAC,
  0xEB, 0x05, 0x20, 0x6F, 0xFA, 0x05, 0x30, 0x50, 0xEF, 0xF0, 0x54, 0x02, 0x0A, 0xFD, 0x0D, 0x03,
  0x68, 0x31, 0x69, 0xCD, 0xA8, 0x3E, 0xDA, 0x73, 0x20,
  // "Ė" (U+0116)
  0x68, 0x43, 0xBE, 0xEB, 0x37, 0x50, 0x10, 0xEC, 0x0E, 0x01, 0x74, 0x06, 0xE0, 0x57, 0x40, 0x8E,
  0x07, 0x74, 0x06, 0xE0, 0x57, 0x40, 0x10, 0xEC, 0x0E, 0x01, 0x75, 0x84, 0x3B, 0xEE, 0xB2, 0x80,
  0xF4, 0x00, 0xCF, 0xFB, 0x03, 0x0C, 0xFF, 0xB0, 0x30, 0xCF, 0xFB, 0x03, 0x0C, 0xFF, 0xB0, 0x30,
  0xCC, 0x0E, 0x80, 0x90, 0x90, 0x20, 0xCC, 0x0C, 0x76, 0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0C, 0x76,
  0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0C, 0x76, 0x0C, 0xC0, 0xC7, 0x60, 0xCF, 0xFA, 0x81, 0x90, 0xCF,
  0xFA, 0x81, 0x90, 0xCF, 0xFA, 0x81, 0x90, 0xCF, 0xFA, 0x81, 0x90, 0xCC, 0x0E, 0x80, 0x79, 0x81,
  0x50, 0xCC, 0x0C, 0x76, 0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0C, 0x76, 0x0C, 0xC0, 0xC7, 0x60, 0xCC,
  0x0C, 0x76, 0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0C, 0x76, 0x0C, 0xC0, 0xE8, 0x09, 0x09, 0x02, 0x0C,
  0xFF, 0xB0, 0x30, 0xCF, 0xFB, 0x03, 0x0C, 0xFF, 0xB0, 0x30, 0xCF, 0xFB, 0x03,
  // "ė" (U+0117)
  0x78, 0x43, 0xBE, 0xEB, 0x37, 0x60, 0x10, 0xEC, 0x0E, 0x01, 0x75, 0x06, 0xE0, 0x57, 0x50, 0x8E,
  0x07, 0x75, 0x06, 0xE0, 0x57, 0x50, 0x10, 0xEC, 0x0E, 0x01, 0x76, 0x84, 0x3B, 0xEE, 0xB2, 0x80,
  0xE0, 0x08, 0x90, 0x16, 0xAD, 0xEF, 0xEC, 0x84, 0x72, 0x07, 0x0E, 0xFA, 0x0C, 0x02, 0x60, 0xBF,
  0xD0, 0xE0, 0x44, 0x0B, 0xFF, 0x0E, 0x02, 0x20, 0x6E, 0x82, 0xEB, 0xAB, 0xE0, 0xB2, 0x0E, 0xD0,
  0x90, 0x13, 0x02, 0x0C, 0xD0, 0x20, 0x5D, 0x09, 0x70, 0xDC, 0x07, 0x09, 0xD0, 0x17, 0x07, 0xC0,
  0xB0, 0xCC, 0x0D, 0x71, 0x03, 0xC0, 0xD0, 0xEF, 0xFC, 0x0E, 0xFF, 0xE0, 0xEF, 0xFD, 0x0D, 0xFF,
  0xD0, 0xBC, 0x0B, 0x77, 0x08, 0xC0, 0xE0, 0x17, 0x60, 0x3D, 0x0B, 0x77, 0x0B, 0xD0, 0xD0, 0x57,
  0x84, 0x26, 0xA5, 0x03, 0xF9, 0x84, 0xCA, 0xAA, 0xCE, 0xB0, 0x52, 0x06, 0xFF, 0xA0, 0x53, 0x05,
  0x0E, 0xFF, 0x05, 0x40, 0x20, 0xAF, 0xD0, 0xD0, 0x36, 0x83, 0x16, 0x9C, 0xDA, 0x83, 0xED, 0xA7,
  0x32,
  // "Ę" (U+0118)
  0x0C, 0xFF, 0xB0, 0x30, 0xCF, 0xFB, 0x03, 0x0C, 0xFF, 0xB0, 0x30, 0xCF, 0xFB, 0x03, 0x0C, 0xC0,
  0xE8, 0x09, 0x09, 0x02, 0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0C, 0x76, 0x0C, 0xC0, 0xC7, 0x60, 0xCC,
  0x0C, 0x76, 0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0C, 0x76, 0x0C, 0xFF, 0xA8, 0x19, 0x0C, 0xFF, 0xA8,
  0x19, 0x0C, 0xFF, 0xA8, 0x19, 0x0C, 0xFF, 0xA8, 0x19, 0x0C, 0xC0, 0xE8, 0x07, 0x98, 0x15, 0x0C,
  0xC0, 0xC7, 0x60, 0xCC, 0x0C, 0x76, 0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0C, 0x76, 0x0C, 0xC0, 0xC7,
  0x60, 0xCC, 0x0C, 0x76, 0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0E, 0x80, 0x90, 0x90, 0x20, 0xCF, 0xFB,
  0x03, 0x0C, 0xFF, 0xB0, 0x30, 0xCF, 0xFB, 0x03, 0x0C, 0xFF, 0xB0, 0x37, 0x40, 0xCA, 0x0C, 0x77,
  0x09, 0xB0, 0x27, 0x60, 0x1B, 0x0B, 0x77, 0x06, 0xB0, 0x97, 0x70, 0x7B, 0x82, 0xD2, 0x03, 0x74,
  0x06, 0xF7, 0x40, 0x2F, 0x75, 0x07, 0xE7, 0x68, 0x45, 0xBE, 0xFD, 0x92,
  // "ę" (U+0119)
  0x58, 0x90, 0x16, 0xAD, 0xEF, 0xEC, 0x84, 0x72, 0x07, 0x0E, 0xFA, 0x0C, 0x02, 0x60, 0xBF, 0xD0,
  0xE0, 0x44, 0x0B, 0xFF, 0x0E, 0x02, 0x20, 0x6E, 0x82, 0xEB, 0xAB, 0xE0, 0xB2, 0x0E, 0xD0, 0x90,
  0x13, 0x02, 0x0C, 0xD0, 0x20, 0x5D, 0x09, 0x70, 0xDC, 0x07, 0x09, 0xD0, 0x17, 0x07, 0xC0, 0xB0,
  0xCC, 0x0D, 0x71, 0x03, 0xC0, 0xD0, 0xEF, 0xFC, 0x0E, 0xFF, 0xE0, 0xEF, 0xFD, 0x0D, 0xFF, 0xD0,
  0xBC, 0x0B, 0x77, 0x08, 0xC0, 0xE0, 0x17, 0x60, 0x3D, 0x0B, 0x77, 0x0B, 0xD0, 0xD0, 0x57, 0x84,
  0x26, 0xA5, 0x03, 0xF9, 0x84, 0xCA, 0xAA, 0xCE, 0xB0, 0x52, 0x06, 0xFF, 0xA0, 0x53, 0x05, 0x0E,
  0xFF, 0x05, 0x40, 0x20, 0xAF, 0xD0, 0xE0, 0x36, 0x83, 0x16, 0x9C, 0xDE, 0x0B, 0x01, 0x76, 0x01,
  0x0D, 0xA0, 0xA7, 0x71, 0x0B, 0xA0, 0xD7, 0x71, 0x04, 0xB0, 0x87, 0x71, 0x08, 0xB0, 0x67, 0x71,
  0x0A, 0xB8, 0x2B, 0x10, 0x27, 0x50, 0x9E, 0x0C, 0x75, 0x05, 0xE0, 0xC7, 0x60, 0xBD, 0x0C, 0x77,
  0x84, 0x7C, 0xEE, 0xD7, 0x10,
  // "Ě" (U+011A)
  0x18, 0x32, 0x77, 0x74, 0x68, 0x34, 0x77, 0x72, 0x30, 0x10, 0xDB, 0x07, 0x40, 0x7B, 0x0D, 0x01,
  0x40, 0x20, 0xEB, 0x08, 0x20, 0xAB, 0x0E, 0x02, 0x60, 0x5C, 0x08, 0x0A, 0xC0, 0x57, 0x10, 0x9F,
  0x90, 0x97, 0x30, 0xDE, 0x0D, 0x74, 0x03, 0xE0, 0x38, 0x0F, 0x30, 0x0C, 0xFF, 0xB0, 0x30, 0xCF,
  0xFB, 0x03, 0x0C, 0xFF, 0xB0, 0x30, 0xCF, 0xFB, 0x03, 0x0C, 0xC0, 0xE8, 0x09, 0x09, 0x02, 0x0C,
  0xC0, 0xC7, 0x60, 0xCC, 0x0C, 0x76, 0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0C, 0x76, 0x0C, 0xC0, 0xC7,
  0x60, 0xCC, 0x0C, 0x76, 0x0C, 0xFF, 0xA8, 0x19, 0x0C, 0xFF, 0xA8, 0x19, 0x0C, 0xFF, 0xA8, 0x19,
  0x0C, 0xFF, 0xA8, 0x19, 0x0C, 0xC0, 0xE8, 0x07, 0x98, 0x15, 0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0C,
  0x76, 0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0C, 0x76, 0x0C, 0xC0, 0xC7, 0x60, 0xCC, 0x0C, 0x76, 0x0C,
  0xC0, 0xC7, 0x60, 0xCC, 0x0E, 0x80, 0x90, 0x90, 0x20, 0xCF, 0xFB, 0x03, 0x0C, 0xFF, 0xB0, 0x30,
  0xCF, 0xFB, 0x03, 0x0C, 0xFF, 0xB0, 0x30,
  // "ě" (U+011B)
  0x28, 0x32, 0x77, 0x74, 0x68, 0x34, 0x77, 0x72, 0x40, 0x10, 0xDB, 0x07, 0x40, 0x7B, 0x0D, 0x01,
  0x50, 0x20, 0xEB, 0x08, 0x20, 0xAB, 0x0E, 0x02, 0x70, 0x5C, 0x08, 0x0A, 0xC0, 0x57, 0x20, 0x9F,
  0x90, 0x97, 0x40, 0xDE, 0x0D, 0x75, 0x03, 0xE0, 0x38, 0x0D, 0x70, 0x89, 0x01, 0x6A, 0xDE, 0xFE,
  0xC8, 0x47, 0x20, 0x70, 0xEF, 0xA0, 0xC0, 0x26, 0x0B, 0xFD, 0x0E, 0x04, 0x40, 0xBF, 0xF0, 0xE0,
  0x22, 0x06, 0xE8, 0x2E, 0xBA, 0xBE, 0x0B, 0x20, 0xED, 0x09, 0x01, 0x30, 0x20, 0xCD, 0x02, 0x05,
  0xD0, 0x97, 0x0D, 0xC0, 0x70, 0x9D, 0x01, 0x70, 0x7C, 0x0B, 0x0C, 0xC0, 0xD7, 0x10, 0x3C, 0x0D,
  0x0E, 0xFF, 0xC0, 0xEF, 0xFE, 0x0E, 0xFF, 0xD0, 0xDF, 0xFD, 0x0B, 0xC0, 0xB7, 0x70, 0x8C, 0x0E,
  0x01, 0x76, 0x03, 0xD0, 0xB7, 0x70, 0xBD, 0x0D, 0x05, 0x78, 0x42, 0x6A, 0x50, 0x3F, 0x98, 0x4C,
  0xAA, 0xAC, 0xEB, 0x05, 0x20, 0x6F, 0xFA, 0x05, 0x30, 0x50, 0xEF, 0xF0, 0x54, 0x02, 0x0A, 0xFD,
  0x0D, 0x03, 0x68, 0x31, 0x69, 0xCD, 0xA8, 0x3E, 0xDA, 0x73, 0x20,
  // "Ĝ" (U+011C)
  0x72, 0x80, 0x27, 0x01, 0x77, 0x06, 0xE0, 0xA7, 0x60, 0x20, 0xEF, 0x05, 0x75, 0x0C, 0xC0, 0xDB,
  0x0E, 0x02, 0x73, 0x09, 0xB8, 0x2E, 0x41, 0xDB, 0x0C, 0x72, 0x06, 0xB0, 0xE0, 0x32, 0x01, 0x0C,
  0xB0, 0xA7, 0x02, 0xB0, 0xC0, 0x25, 0x0A, 0xB0, 0x58, 0x09, 0x90, 0x08, 0x91, 0x48, 0xCD, 0xEF,
  0xED, 0xA7, 0x37, 0x20, 0x70, 0xEF, 0xC0, 0xD0, 0x75, 0x02, 0x0D, 0xFF, 0x09, 0x40, 0x30, 0xEF,
  0xF9, 0x03, 0x30, 0x10, 0xDF, 0x84, 0xEB, 0xAA, 0xCE, 0xA0, 0xC4, 0x0A, 0xE0, 0xB0, 0x36, 0x81,
  0x4A, 0x53, 0x02, 0xE0, 0x87, 0x70, 0x9D, 0x0A, 0x77, 0x10, 0xED, 0x02, 0x77, 0x03, 0xD0, 0xB7,
  0x71, 0x07, 0xD0, 0x67, 0x71, 0x09, 0xD0, 0x37, 0x71, 0x0A, 0xD0, 0x15, 0xFA, 0x03, 0x0B, 0xD6,
  0xFA, 0x03, 0x0C, 0xD6, 0xFA, 0x03, 0x0B, 0xD0, 0x15, 0xFA, 0x03, 0x0A, 0xD0, 0x25, 0x0F, 0x90,
  0xAD, 0x03, 0x08, 0xD0, 0x57, 0x2D, 0x03, 0x05, 0xD0, 0x97, 0x2D, 0x03, 0x01, 0xD0, 0xE7, 0x2D,
  0x81, 0x30, 0xCD, 0x07, 0x71, 0xD8, 0x13, 0x06, 0xE0, 0x37, 0xD0, 0x32, 0x0D, 0xE0, 0x76, 0xD0,
  0x32, 0x04, 0xF9, 0x83, 0xCA, 0xAC, 0xED, 0x03, 0x30, 0x7F, 0xFB, 0x03, 0x40, 0x6F, 0xFA, 0x03,
  0x50, 0x20, 0xBF, 0xE0, 0xB0, 0x17, 0x83, 0x26, 0xAC, 0xEA, 0x84, 0xED, 0xB9, 0x51, 0x20,
  // "ĝ" (U+011D)
  0x71, 0x80, 0x27, 0x01, 0x76, 0x06, 0xE0, 0xA7, 0x50, 0x20, 0xEF, 0x05, 0x74, 0x0C, 0xC0, 0xDB,
  0x0E, 0x02, 0x72, 0x09, 0xB8, 0x2E, 0x41, 0xDB, 0x0C, 0x71, 0x06, 0xB0, 0xE0, 0x32, 0x01, 0x0C,
  0xB0, 0xA6, 0x02, 0xB0, 0xC0, 0x25, 0x0A, 0xB0, 0x58, 0x0D, 0x50, 0x86, 0x4A, 0xDE, 0xEC, 0x82,
  0x30, 0xCB, 0x0C, 0x30, 0x10, 0xAF, 0x98, 0x17, 0x03, 0xC0, 0xC3, 0x0C, 0xFB, 0x00, 0x9C, 0x0C,
  0x20, 0x9F, 0xFB, 0x81, 0xC0, 0x2F, 0x82, 0xDA, 0xAD, 0xF8, 0x1C, 0x08, 0xE0, 0x54, 0x06, 0xE8,
  0x1C, 0x0D, 0xD0, 0x66, 0x08, 0xD0, 0xC0, 0x1D, 0x0E, 0x70, 0x1D, 0x0C, 0x03, 0xD0, 0xB7, 0x10,
  0xDC, 0x0C, 0x05, 0xD0, 0x87, 0x10, 0xBC, 0x0C, 0x05, 0xD0, 0x77, 0x10, 0xAC, 0x0C, 0x05, 0xD0,
  0x77, 0x10, 0x9C, 0x0C, 0x05, 0xD0, 0x87, 0x10, 0xAC, 0x0C, 0x03, 0xD0, 0xB7, 0x10, 0xCC, 0x0C,
  0x01, 0xD0, 0xE7, 0x1D, 0x81, 0xC0, 0xDD, 0x07, 0x60, 0x7D, 0x81, 0xC0, 0x8E, 0x05, 0x40, 0x5E,
  0x81, 0xC0, 0x2F, 0x82, 0xDA, 0xAD, 0xF0, 0xC2, 0x08, 0xFF, 0xB0, 0xC3, 0x0C, 0xFB, 0x08, 0x0E,
  0xC0, 0xC3, 0x01, 0x0A, 0xF9, 0x07, 0x1D, 0x0C, 0x58, 0x64, 0x9D, 0xEE, 0xC8, 0x22, 0xD0, 0xC7,
  0x70, 0x1D, 0x0B, 0x77, 0x03, 0xD0, 0x92, 0x01, 0x74, 0x0A, 0xD0, 0x52, 0x82, 0xDC, 0x73, 0x60,
  0x10, 0x8E, 0x01, 0x20, 0xDC, 0x83, 0xCB, 0xAA, 0xCF, 0x08, 0x30, 0xDF, 0xF9, 0x0D, 0x01, 0x30,
  0xDF, 0xF0, 0xD0, 0x14, 0x0C, 0xFD, 0x0E, 0x08, 0x78, 0x92, 0x37, 0xAC, 0xDE, 0xFE, 0xDB, 0x85,
  0x60,
  // "Ğ" (U+011E)
  0x58, 0x24, 0x77, 0x66, 0x82, 0x47, 0x76, 0x71, 0x07, 0xA0, 0xE0, 0x15, 0x0C, 0xA0, 0xB7, 0x10,
  0x4B, 0x84, 0xC4, 0x10, 0x3A, 0xB0, 0x77, 0x20, 0xEF, 0xC0, 0x27, 0x20, 0x5F, 0xB0, 0x77, 0x40,
  0x6F, 0x90, 0x87, 0x68, 0x62, 0x9D, 0xEF, 0xD9, 0x38, 0x09, 0x94, 0x08, 0x91, 0x48, 0xCD, 0xEF,
  0xED, 0xA7, 0x37, 0x20, 0x70, 0xEF, 0xC0, 0xD0, 0x75, 0x02, 0x0D, 0xFF, 0x09, 0x40, 0x30, 0xEF,
  0xF9, 0x03, 0x30, 0x10, 0xDF, 0x84, 0xEB, 0xAA, 0xCE, 0xA0, 0xC4, 0x0A, 0xE0, 0xB0, 0x36, 0x81,
  0x4A, 0x53, 0x02, 0xE0, 0x87, 0x70, 0x9D, 0x0A, 0x77, 0x10, 0xED, 0x02, 0x77, 0x03, 0xD0, 0xB7,
  0x71, 0x07, 0xD0, 0x67, 0x71, 0x09, 0xD0, 0x37, 0x71, 0x0A, 0xD0, 0x15, 0xFA, 0x03, 0x0B, 0xD6,
  0xFA, 0x03, 0x0C, 0xD6, 0xFA, 0x03, 0x0B, 0xD0, 0x15, 0xFA, 0x03, 0x0A, 0xD0, 0x25, 0x0F, 0x90,
  0xAD, 0x03, 0x08, 0xD0, 0x57, 0x2D, 0x03, 0x05, 0xD0, 0x97, 0x2D, 0x03, 0x01, 0xD0, 0xE7, 0x2D,
  0x81, 0x30, 0xCD, 0x07, 0x71, 0xD8, 0x13, 0x06, 0xE0, 0x37, 0xD0, 0x32, 0x0D, 0xE0, 0x76, 0xD0,
  0x32, 0x04, 0xF9, 0x83, 0xCA, 0xAC, 0xED, 0x03, 0x30, 0x7F, 0xFB, 0x03, 0x40, 0x6F, 0xFA, 0x03,
  0x50, 0x20, 0xBF, 0xE0, 0xB0, 0x17, 0x83, 0x26, 0xAC, 0xEA, 0x84, 0xED, 0xB9, 0x51, 0x20,
  // "ğ" (U+011F)
  0x48, 0x24, 0x77, 0x66, 0x82, 0x47, 0x76, 0x70, 0x7A, 0x0E, 0x01, 0x50, 0xCA, 0x0B, 0x70, 0x4B,
  0x84, 0xC4, 0x10, 0x3A, 0xB0, 0x77, 0x10, 0xEF, 0xC0, 0x27, 0x10, 0x5F, 0xB0, 0x77, 0x30, 0x6F,
  0x90, 0x87, 0x58, 0x62, 0x9D, 0xEF, 0xD9, 0x38, 0x0E, 0x10, 0x86, 0x4A, 0xDE, 0xEC, 0x82, 0x30,
  0xCB, 0x0C, 0x30, 0x10, 0xAF, 0x98, 0x17, 0x03, 0xC0, 0xC3, 0x0C, 0xFB, 0x00, 0x9C, 0x0C, 0x20,
  0x9F, 0xFB, 0x81, 0xC0, 0x2F, 0x82, 0xDA, 0xAD, 0xF8, 0x1C, 0x08, 0xE0, 0x54, 0x06, 0xE8, 0x1C,
  0x0D, 0xD0, 0x66, 0x08, 0xD0, 0xC0, 0x1D, 0x0E, 0x70, 0x1D, 0x0C, 0x03, 0xD0, 0xB7, 0x10, 0xDC,
  0x0C, 0x05, 0xD0, 0x87, 0x10, 0xBC, 0x0C, 0x05, 0xD0, 0x77, 0x10, 0xAC, 0x0C, 0x05, 0xD0, 0x77,
  0x10, 0x9C, 0x0C, 0x05, 0xD0, 0x87, 0x10, 0xAC, 0x0C, 0x03, 0xD0, 0xB7, 0x10, 0xCC, 0x0C, 0x01,
  0xD0, 0xE7, 0x1D, 0x81, 0xC0, 0xDD, 0x07, 0x60, 0x7D, 0x81, 0xC0, 0x8E, 0x05, 0x40, 0x5E, 0x81,
  0xC0, 0x2F, 0x82, 0xDA, 0xAD, 0xF0, 0xC2, 0x08, 0xFF, 0xB0, 0xC3, 0x0C, 0xFB, 0x08, 0x0E, 0xC0,
  0xC3, 0x01, 0x0A, 0xF9, 0x07, 0x1D, 0x0C, 0x58, 0x64, 0x9D, 0xEE, 0xC8, 0x22, 0xD0, 0xC7, 0x70,
  0x1D, 0x0B, 0x77, 0x03, 0xD0, 0x92, 0x01, 0x74, 0x0A, 0xD0, 0x52, 0x82, 0xDC, 0x73, 0x60, 0x10,
  0x8E, 0x01, 0x20, 0xDC, 0x83, 0xCB, 0xAA, 0xCF, 0x08, 0x30, 0xDF, 0xF9, 0x0D, 0x01, 0x30, 0xDF,
  0xF0, 0xD0, 0x14, 0x0C, 0xFD, 0x0E, 0x08, 0x78, 0x92, 0x37, 0xAC, 0xDE, 0xFE, 0xDB, 0x85, 0x60,
  // "Ġ" (U+0120)
  0x72, 0x84, 0x3B, 0xEE, 0xB3, 0x77, 0x10, 0x10, 0xEC, 0x0E, 0x01, 0x77, 0x06, 0xE0, 0x57, 0x70,
  0x8E, 0x07, 0x77, 0x06, 0xE0, 0x57, 0x70, 0x10, 0xEC, 0x0E, 0x01, 0x77, 0x18, 0x43, 0xBE, 0xEB,
  0x28, 0x09, 0x95, 0x08, 0x91, 0x48, 0xCD, 0xEF, 0xED, 0xA7, 0x37, 0x20, 0x70, 0xEF, 0xC0, 0xD0,
  0x75, 0x02, 0x0D, 0xFF, 0x09, 0x40, 0x30, 0xEF, 0xF9, 0x03, 0x30, 0x10, 0xDF, 0x84, 0xEB, 0xAA,
  0xCE, 0xA0, 0xC4, 0x0A, 0xE0, 0xB0, 0x36, 0x81, 0x4A, 0x53, 0x02, 0xE0, 0x87, 0x70, 0x9D, 0x0A,
  0x77, 0x10, 0xED, 0x02, 0x77, 0x03, 0xD0, 0xB7, 0x71, 0x07, 0xD0, 0x67, 0x71, 0x09, 0xD0, 0x37,
  0x71, 0x0A, 0xD0, 0x15, 0xFA, 0x03, 0x0B, 0xD6, 0xFA, 0x03, 0x0C, 0xD6, 0xFA, 0x03, 0x0B, 0xD0,
  0x15, 0xFA, 0x03, 0x0A, 0xD0, 0x25, 0x0F, 0x90, 0xAD, 0x03, 0x08, 0xD0, 0x57, 0x2D, 0x03, 0x05,
  0xD0, 0x97, 0x2D, 0x03, 0x01, 0xD0, 0xE7, 0x2D, 0x81, 0x30, 0xCD, 0x07, 0x71, 0xD8, 0x13, 0x06,
  0xE0, 0x37, 0xD0, 0x32, 0x0D, 0xE0, 0x76, 0xD0, 0x32, 0x04, 0xF9, 0x83, 0xCA, 0xAC, 0xED, 0x03,
  0x30, 0x7F, 0xFB, 0x03, 0x40, 0x6F, 0xFA, 0x03, 0x50, 0x20, 0xBF, 0xE0, 0xB0, 0x17, 0x83, 0x26,
  0xAC, 0xEA, 0x84, 0xED, 0xB9, 0x51, 0x20,
  // "ġ" (U+0121)
  0x71, 0x84, 0x3B, 0xEE, 0xB3, 0x77, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x60, 0x6E, 0x05, 0x76, 0x08,
  0xE0, 0x77, 0x60, 0x6E, 0x05, 0x76, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x78, 0x43, 0xBE, 0xEB, 0x28,
  0x0E, 0x20, 0x86, 0x4A, 0xDE, 0xEC, 0x82, 0x30, 0xCB, 0x0C, 0x30, 0x10, 0xAF, 0x98, 0x17, 0x03,
  0xC0, 0xC3, 0x0C, 0xFB, 0x00, 0x9C, 0x0C, 0x20, 0x9F, 0xFB, 0x81, 0xC0, 0x2F, 0x82, 0xDA, 0xAD,
  0xF8, 0x1C, 0x08, 0xE0, 0x54, 0x06, 0xE8, 0x1C, 0x0D, 0xD0, 0x66, 0x08, 0xD0, 0xC0, 0x1D, 0x0E,
  0x70, 0x1D, 0x0C, 0x03, 0xD0, 0xB7, 0x10, 0xDC, 0x0C, 0x05, 0xD0, 0x87, 0x10, 0xBC, 0x0C, 0x05,
  0xD0, 0x77, 0x10, 0xAC, 0x0C, 0x05, 0xD0, 0x77, 0x10, 0x9C, 0x0C, 0x05, 0xD0, 0x87, 0x10, 0xAC,
  0x0C, 0x03, 0xD0, 0xB7, 0x10, 0xCC, 0x0C, 0x01, 0xD0, 0xE7, 0x1D, 0x81, 0xC0, 0xDD, 0x07, 0x60,
  0x7D, 0x81, 0xC0, 0x8E, 0x05, 0x40, 0x5E, 0x81, 0xC0, 0x2F, 0x82, 0xDA, 0xAD, 0xF0, 0xC2, 0x08,
  0xFF, 0xB0, 0xC3, 0x0C, 0xFB, 0x08, 0x0E, 0xC0, 0xC3, 0x01, 0x0A, 0xF9, 0x07, 0x1D, 0x0C, 0x58,
  0x64, 0x9D, 0xEE, 0xC8, 0x22, 0xD0, 0xC7, 0x70, 0x1D, 0x0B, 0x77, 0x03, 0xD0, 0x92, 0x01, 0x74,
  0x0A, 0xD0, 0x52, 0x82, 0xDC, 0x73, 0x60, 0x10, 0x8E, 0x01, 0x20, 0xDC, 0x83, 0xCB, 0xAA, 0xCF,
  0x08, 0x30, 0xDF, 0xF9, 0x0D, 0x01, 0x30, 0xDF, 0xF0, 0xD0, 0x14, 0x0C, 0xFD, 0x0E, 0x08, 0x78,
  0x92, 0x37, 0xAC, 0xDE, 0xFE, 0xDB, 0x85, 0x60,
  // "Ģ" (U+0122)
  0x71, 0x89, 0x14, 0x8C, 0xDE, 0xFE, 0xDA, 0x73, 0x72, 0x07, 0x0E, 0xFC, 0x0D, 0x07, 0x50, 0x20,
  0xDF, 0xF0, 0x94, 0x03, 0x0E, 0xFF, 0x90, 0x33, 0x01, 0x0D, 0xF8, 0x4E, 0xBA, 0xAC, 0xEA, 0x0C,
  0x40, 0xAE, 0x0B, 0x03, 0x68, 0x14, 0xA5, 0x30, 0x2E, 0x08, 0x77, 0x09, 0xD0, 0xA7, 0x71, 0x0E,
  0xD0, 0x27, 0x70, 0x3D, 0x0B, 0x77, 0x10, 0x7D, 0x06, 0x77, 0x10, 0x9D, 0x03, 0x77, 0x10, 0xAD,
  0x01, 0x5F, 0xA0, 0x30, 0xBD, 0x6F, 0xA0, 0x30, 0xCD, 0x6F, 0xA0, 0x30, 0xBD, 0x01, 0x5F, 0xA0,
  0x30, 0xAD, 0x02, 0x50, 0xF9, 0x0A, 0xD0, 0x30, 0x8D, 0x05, 0x72, 0xD0, 0x30, 0x5D, 0x09, 0x72,
  0xD0, 0x30, 0x1D, 0x0E, 0x72, 0xD8, 0x13, 0x0C, 0xD0, 0x77, 0x1D, 0x81, 0x30, 0x6E, 0x03, 0x7D,
  0x03, 0x20, 0xDE, 0x07, 0x6D, 0x03, 0x20, 0x4F, 0x98, 0x3C, 0xAA, 0xCE, 0xD0, 0x33, 0x07, 0xFF,
  0xB0, 0x34, 0x06, 0xFF, 0xA0, 0x35, 0x02, 0x0B, 0xFE, 0x0B, 0x01, 0x78, 0x32, 0x6A, 0xCE, 0xA8,
  0x4E, 0xDB, 0x95, 0x18, 0x09, 0x91, 0x00, 0xCC, 0x08, 0x77, 0x20, 0xEC, 0x01, 0x77, 0x10, 0x3C,
  0x08, 0x77, 0x20, 0x6B, 0x0E, 0x01, 0x77, 0x20, 0xAB, 0x05, 0x77, 0x30, 0xEA, 0x0A, 0x73,
  // "ģ" (U+0123)
  0x73, 0x05, 0xB0, 0x37, 0x71, 0x01, 0x0E, 0xB7, 0x72, 0x09, 0xB0, 0xB7, 0x71, 0x03, 0xC0, 0x77,
  0x71, 0x0B, 0xC0, 0x47, 0x70, 0x2D, 0x01, 0x80, 0xE2, 0x08, 0x64, 0xAD, 0xEE, 0xC8, 0x23, 0x0C,
  0xB0, 0xC3, 0x01, 0x0A, 0xF9, 0x81, 0x70, 0x3C, 0x0C, 0x30, 0xCF, 0xB0, 0x09, 0xC0, 0xC2, 0x09,
  0xFF, 0xB8, 0x1C, 0x02, 0xF8, 0x2D, 0xAA, 0xDF, 0x81, 0xC0, 0x8E, 0x05, 0x40, 0x6E, 0x81, 0xC0,
  0xDD, 0x06, 0x60, 0x8D, 0x0C, 0x01, 0xD0, 0xE7, 0x01, 0xD0, 0xC0, 0x3D, 0x0B, 0x71, 0x0D, 0xC0,
  0xC0, 0x5D, 0x08, 0x71, 0x0B, 0xC0, 0xC0, 0x5D, 0x07, 0x71, 0x0A, 0xC0, 0xC0, 0x5D, 0x07, 0x71,
  0x09, 0xC0, 0xC0, 0x5D, 0x08, 0x71, 0x0A, 0xC0, 0xC0, 0x3D, 0x0B, 0x71, 0x0C, 0xC0, 0xC0, 0x1D,
  0x0E, 0x71, 0xD8, 0x1C, 0x0D, 0xD0, 0x76, 0x07, 0xD8, 0x1C, 0x08, 0xE0, 0x54, 0x05, 0xE8, 0x1C,
  0x02, 0xF8, 0x2D, 0xAA, 0xDF, 0x0C, 0x20, 0x8F, 0xFB, 0x0C, 0x30, 0xCF, 0xB0, 0x80, 0xEC, 0x0C,
  0x30, 0x10, 0xAF, 0x90, 0x71, 0xD0, 0xC5, 0x86, 0x49, 0xDE, 0xEC, 0x82, 0x2D, 0x0C, 0x77, 0x01,
  0xD0, 0xB7, 0x70, 0x3D, 0x09, 0x20, 0x17, 0x40, 0xAD, 0x05, 0x28, 0x2D, 0xC7, 0x36, 0x01, 0x08,
  0xE0, 0x12, 0x0D, 0xC8, 0x3C, 0xBA, 0xAC, 0xF0, 0x83, 0x0D, 0xFF, 0x90, 0xD0, 0x13, 0x0D, 0xFF,
  0x0D, 0x01, 0x40, 0xCF, 0xD0, 0xE0, 0x87, 0x89, 0x23, 0x7A, 0xCD, 0xEF, 0xED, 0xB8, 0x56,
  // "Ĥ" (U+0124)
  0x71, 0x80, 0x27, 0x01, 0x77, 0x06, 0xE0, 0xA7, 0x60, 0x20, 0xEF, 0x05, 0x75, 0x0C, 0xC0, 0xDB,
  0x0E, 0x02, 0x73, 0x09, 0xB8, 0x2E, 0x41, 0xDB, 0x0C, 0x72, 0x06, 0xB0, 0xE0, 0x32, 0x01, 0x0C,
  0xB0, 0xA7, 0x02, 0xB0, 0xC0, 0x25, 0x0A, 0xB0, 0x58, 0x09, 0x81, 0x00, 0x3D, 0x09, 0x71, 0x09,
  0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10,
  0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71,
  0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97,
  0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xFF, 0xE0, 0x03, 0xFF, 0xE0, 0x03, 0xFF,
  0xE0, 0x03, 0xFF, 0xE0, 0x03, 0xD0, 0xD8, 0x04, 0x90, 0xDD, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0,
  0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D,
  0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09,
  0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10,
  0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x03,
  // "ĥ" (U+0125)
  0x58, 0x02, 0x70, 0x17, 0x73, 0x06, 0xE0, 0xA7, 0x72, 0x02, 0x0E, 0xF0, 0x57, 0x71, 0x0C, 0xC0,
  0xDB, 0x0E, 0x02, 0x76, 0x09, 0xB8, 0x2E, 0x41, 0xDB, 0x0C, 0x75, 0x06, 0xB0, 0xE0, 0x32, 0x01,
  0x0C, 0xB0, 0xA7, 0x30, 0x2B, 0x0C, 0x02, 0x50, 0xAB, 0x05, 0x80, 0x9A, 0x50, 0x0C, 0xD7, 0x75,
  0x0C, 0xD7, 0x75, 0x0C, 0xD7, 0x75, 0x0C, 0xD7, 0x75, 0x0C, 0xD7, 0x75, 0x0C, 0xD7, 0x75, 0x0C,
  0xD7, 0x75, 0x0C, 0xC0, 0xE7, 0x75, 0x0C, 0xC0, 0xE2, 0x87, 0x17, 0xCE, 0xFE, 0xC7, 0x17, 0x10,
  0xCC, 0x82, 0xE0, 0x5E, 0xF9, 0x06, 0x70, 0xCC, 0x0D, 0x04, 0xFC, 0x05, 0x60, 0xCF, 0xFB, 0x0E,
  0x01, 0x50, 0xCF, 0x98, 0x1B, 0xAC, 0xF0, 0x75, 0x0C, 0xE0, 0xB0, 0x13, 0x03, 0x0D, 0xD0, 0xB5,
  0x0C, 0xD0, 0xE0, 0x15, 0x04, 0xD0, 0xD5, 0x0C, 0xD0, 0x87, 0x0E, 0xD5, 0x0C, 0xD0, 0x47, 0x0D,
  0xD5, 0x0C, 0xD0, 0x27, 0x0C, 0xD5, 0x0C, 0xD7, 0x10, 0xCD, 0x50, 0xCD, 0x71, 0x0C, 0xD5, 0x0C,
  0xD7, 0x10, 0xCD, 0x50, 0xCD, 0x71, 0x0C, 0xD5, 0x0C, 0xD7, 0x10, 0xCD, 0x50, 0xCD, 0x71, 0x0C,
  0xD5, 0x0C, 0xD7, 0x10, 0xCD, 0x50, 0xCD, 0x71, 0x0C, 0xD5, 0x0C, 0xD7, 0x10, 0xCD, 0x50, 0xCD,
  0x71, 0x0C, 0xD5, 0x0C, 0xD7, 0x10, 0xCD, 0x50, 0xCD, 0x71, 0x0C, 0xD0,
  // "Ħ" (U+0126)
  0x20, 0xBD, 0x01, 0x7D, 0x0B, 0x40, 0xBD, 0x01, 0x7D, 0x0B, 0x40, 0xBD, 0x01, 0x7D, 0x0B, 0x28,
  0x09, 0xB4, 0xF2, 0x0B, 0xD0, 0x17, 0xD0, 0xB4, 0x0B, 0xD0, 0x17, 0xD0, 0xB4, 0x0B, 0xD0, 0x17,
  0xD0, 0xB4, 0x0B, 0xD0, 0x17, 0xD0, 0xB4, 0x0B, 0xFF, 0xC0, 0xB4, 0x0B, 0xFF, 0xC0, 0xB4, 0x0B,
  0xFF, 0xC0, 0xB4, 0x0B, 0xFF, 0xC0, 0xB4, 0x0B, 0xD0, 0xA8, 0x02, 0x90, 0xAD, 0x0B, 0x40, 0xBD,
  0x01, 0x7D, 0x0B, 0x40, 0xBD, 0x01, 0x7D, 0x0B, 0x40, 0xBD, 0x01, 0x7D, 0x0B, 0x40, 0xBD, 0x01,
  0x7D, 0x0B, 0x40, 0xBD, 0x01, 0x7D, 0x0B, 0x40, 0xBD, 0x01, 0x7D, 0x0B, 0x40, 0xBD, 0x01, 0x7D,
  0x0B, 0x40, 0xBD, 0x01, 0x7D, 0x0B, 0x40, 0xBD, 0x01, 0x7D, 0x0B, 0x40, 0xBD, 0x01, 0x7D, 0x0B,
  0x40, 0xBD, 0x01, 0x7D, 0x0B, 0x40, 0xBD, 0x01, 0x7D, 0x0B, 0x20,
  // "ħ" (U+0127)
  0x20, 0xCD, 0x77, 0x20, 0xCD, 0x77, 0x20, 0xCD, 0x77, 0xFE, 0x0E, 0x71, 0xFE, 0x0E, 0x71, 0xFE,
  0x0E, 0x71, 0xFE, 0x0E, 0x73, 0x0C, 0xD7, 0x72, 0x0C, 0xC0, 0xE2, 0x87, 0x17, 0xCE, 0xFE, 0xB7,
  0x15, 0x0C, 0xC8, 0x2E, 0x05, 0xEF, 0x0E, 0x05, 0x40, 0xCC, 0x0D, 0x04, 0xFC, 0x05, 0x30, 0xCF,
  0xFB, 0x0E, 0x30, 0xCF, 0x98, 0x1B, 0xAB, 0xF0, 0x62, 0x0C, 0xE0, 0xC0, 0x13, 0x02, 0x0D, 0xD0,
  0xB2, 0x0C, 0xD0, 0xE0, 0x15, 0x04, 0xD0, 0xD2, 0x0C, 0xD0, 0x87, 0x0E, 0xC0, 0xE2, 0x0C, 0xD0,
  0x47, 0x0D, 0xD2, 0x0C, 0xD0, 0x27, 0x0C, 0xD2, 0x0C, 0xD7, 0x10, 0xCD, 0x20, 0xCD, 0x71, 0x0C,
  0xD2, 0x0C, 0xD7, 0x10, 0xCD, 0x20, 0xCD, 0x71, 0x0C, 0xD2, 0x0C, 0xD7, 0x10, 0xCD, 0x20, 0xCD,
  0x71, 0x0C, 0xD2, 0x0C, 0xD7, 0x10, 0xCD, 0x20, 0xCD, 0x71, 0x0C, 0xD2, 0x0C, 0xD7, 0x10, 0xCD,
  0x20, 0xCD, 0x71, 0x0C, 0xD2, 0x0C, 0xD7, 0x10, 0xCD, 0x20, 0xCD, 0x71, 0x0C, 0xD0,
  // "Ĩ" (U+0128)
  0x38, 0x43, 0xBE, 0xEA, 0x44, 0x06, 0xA0, 0x83, 0x02, 0x0E, 0xD8, 0x3C, 0x51, 0x1D, 0xA0, 0x63,
  0x0A, 0xFE, 0x02, 0x20, 0x1F, 0xE0, 0xC3, 0x05, 0xA8, 0x3C, 0x11, 0x6D, 0xD0, 0xE0, 0x33, 0x07,
  0xA0, 0x64, 0x84, 0x4A, 0xEE, 0xB2, 0x80, 0xE5, 0x00, 0x6F, 0xFA, 0x00, 0x6F, 0xFA, 0x00, 0x6F,
  0xFA, 0x00, 0x6F, 0xFA, 0x86, 0x60, 0x24, 0x67, 0x9E, 0xC8, 0x4E, 0x97, 0x64, 0x27, 0x0D, 0xC0,
  0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50,
  0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B,
  0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D,
  0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x71, 0x83, 0x13, 0x56,
  0xEC, 0x83, 0xD6, 0x53, 0x12, 0x05, 0xFF, 0xA0, 0x50, 0x6F, 0xFA, 0x00, 0x6F, 0xFA, 0x00, 0x6F,
  0xFA, 0x06,
  // "ĩ" (U+0129)
  0x48, 0x43, 0xBE, 0xEA, 0x44, 0x06, 0xA0, 0x85, 0x02, 0x0E, 0xD8, 0x3C, 0x51, 0x1D, 0xA0, 0x65,
  0x0A, 0xFE, 0x02, 0x40, 0x1F, 0xE0, 0xC5, 0x05, 0xA8, 0x3C, 0x11, 0x6D, 0xD0, 0xE0, 0x35, 0x07,
  0xA0, 0x64, 0x84, 0x4A, 0xEE, 0xB2, 0x80, 0xD1, 0x00, 0x8F, 0xC0, 0x77, 0x08, 0xFC, 0x07, 0x70,
  0x8F, 0xC0, 0x77, 0x08, 0xFC, 0x07, 0x78, 0x51, 0x46, 0x79, 0xBD, 0xD0, 0x77, 0x60, 0x4D, 0x07,
  0x76, 0x04, 0xD0, 0x77, 0x60, 0x4D, 0x07, 0x76, 0x04, 0xD0, 0x77, 0x60, 0x4D, 0x07, 0x76, 0x04,
  0xD0, 0x77, 0x60, 0x4D, 0x07, 0x76, 0x04, 0xD0, 0x77, 0x60, 0x4D, 0x07, 0x76, 0x04, 0xD0, 0x77,
  0x60, 0x4D, 0x07, 0x76, 0x04, 0xD0, 0x77, 0x28, 0x32, 0x47, 0x9D, 0xD8, 0x3D, 0x97, 0x41, 0x28,
  0x16, 0xCE, 0xFF, 0x98, 0x1D, 0xB9, 0xFF, 0xD0, 0x9F, 0xFD, 0x09, 0xFF, 0xD0,
  // "Ī" (U+012A)
  0x3F, 0xD0, 0x15, 0xFD, 0x01, 0x5F, 0xD0, 0x15, 0xFD, 0x01, 0x80, 0x98, 0x60, 0x06, 0xFF, 0xA0,
  0x06, 0xFF, 0xA0, 0x06, 0xFF, 0xA0, 0x06, 0xFF, 0xA8, 0x66, 0x02, 0x46, 0x79, 0xEC, 0x84, 0xE9,
  0x76, 0x42, 0x70, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7,
  0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC,
  0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75,
  0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0,
  0xB7, 0x18, 0x31, 0x35, 0x6E, 0xC8, 0x3D, 0x65, 0x31, 0x20, 0x5F, 0xFA, 0x05, 0x06, 0xFF, 0xA0,
  0x06, 0xFF, 0xA0, 0x06, 0xFF, 0xA0, 0x60,
  // "ī" (U+012B)
  0x4F, 0xD0, 0x17, 0xFD, 0x01, 0x7F, 0xD0, 0x17, 0xFD, 0x01, 0x80, 0xF4, 0x00, 0x8F, 0xC0, 0x77,
  0x08, 0xFC, 0x07, 0x70, 0x8F, 0xC0, 0x77, 0x08, 0xFC, 0x07, 0x78, 0x51, 0x46, 0x79, 0xBD, 0xD0,
  0x77, 0x60, 0x4D, 0x07, 0x76, 0x04, 0xD0, 0x77, 0x60, 0x4D, 0x07, 0x76, 0x04, 0xD0, 0x77, 0x60,
  0x4D, 0x07, 0x76, 0x04, 0xD0, 0x77, 0x60, 0x4D, 0x07, 0x76, 0x04, 0xD0, 0x77, 0x60, 0x4D, 0x07,
  0x76, 0x04, 0xD0, 0x77, 0x60, 0x4D, 0x07, 0x76, 0x04, 0xD0, 0x77, 0x28, 0x32, 0x47, 0x9D, 0xD8,
  0x3D, 0x97, 0x41, 0x28, 0x16, 0xCE, 0xFF, 0x98, 0x1D, 0xB9, 0xFF, 0xD0, 0x9F, 0xFD, 0x09, 0xFF,
  0xD0,
  // "Ĭ" (U+012C)
  0x28, 0x24, 0x77, 0x66, 0x82, 0x47, 0x76, 0x40, 0x7A, 0x0E, 0x01, 0x50, 0xCA, 0x0B, 0x40, 0x4B,
  0x84, 0xC4, 0x10, 0x3A, 0xB0, 0x75, 0x0E, 0xFC, 0x02, 0x50, 0x5F, 0xB0, 0x77, 0x06, 0xF9, 0x08,
  0x72, 0x86, 0x29, 0xDE, 0xFD, 0x93, 0x80, 0xE7, 0x00, 0x6F, 0xFA, 0x00, 0x6F, 0xFA, 0x00, 0x6F,
  0xFA, 0x00, 0x6F, 0xFA, 0x86, 0x60, 0x24, 0x67, 0x9E, 0xC8, 0x4E, 0x97, 0x64, 0x27, 0x0D, 0xC0,
  0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50,
  0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B,
  0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D,
  0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x71, 0x83, 0x13, 0x56,
  0xEC, 0x83, 0xD6, 0x53, 0x12, 0x05, 0xFF, 0xA0, 0x50, 0x6F, 0xFA, 0x00, 0x6F, 0xFA, 0x00, 0x6F,
  0xFA, 0x06,
  // "ĭ" (U+012D)
  0x38, 0x24, 0x77, 0x66, 0x82, 0x47, 0x76, 0x60, 0x7A, 0x0E, 0x01, 0x50, 0xCA, 0x0B, 0x60, 0x4B,
  0x84, 0xC4, 0x10, 0x3A, 0xB0, 0x77, 0x0E, 0xFC, 0x02, 0x70, 0x5F, 0xB0, 0x77, 0x20, 0x6F, 0x90,
  0x87, 0x48, 0x62, 0x9D, 0xEF, 0xD9, 0x38, 0x0D, 0x30, 0x08, 0xFC, 0x07, 0x70, 0x8F, 0xC0, 0x77,
  0x08, 0xFC, 0x07, 0x70, 0x8F, 0xC0, 0x77, 0x85, 0x14, 0x67, 0x9B, 0xDD, 0x07, 0x76, 0x04, 0xD0,
  0x77, 0x60, 0x4D, 0x07, 0x76, 0x04, 0xD0, 0x77, 0x60, 0x4D, 0x07, 0x76, 0x04, 0xD0, 0x77, 0x60,
  0x4D, 0x07, 0x76, 0x04, 0xD0, 0x77, 0x60, 0x4D, 0x07, 0x76, 0x04, 0xD0, 0x77, 0x60, 0x4D, 0x07,
  0x76, 0x04, 0xD0, 0x77, 0x60, 0x4D, 0x07, 0x72, 0x83, 0x24, 0x79, 0xDD, 0x83, 0xD9, 0x74, 0x12,
  0x81, 0x6C, 0xEF, 0xF9, 0x81, 0xDB, 0x9F, 0xFD, 0x09, 0xFF, 0xD0, 0x9F, 0xFD,
  // "Į" (U+012E)
  0x06, 0xFF, 0xA0, 0x06, 0xFF, 0xA0, 0x06, 0xFF, 0xA0, 0x06, 0xFF, 0xA8, 0x66, 0x02, 0x46, 0x79,
  0xEC, 0x84, 0xE9, 0x76, 0x42, 0x70, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75,
  0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0,
  0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50,
  0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B,
  0x75, 0x0D, 0xC0, 0xB7, 0x18, 0x31, 0x35, 0x6E, 0xC8, 0x3D, 0x65, 0x31, 0x20, 0x5F, 0xFA, 0x05,
  0x06, 0xFF, 0xA0, 0x06, 0xFF, 0xA0, 0x06, 0xFF, 0xA0, 0x67, 0x20, 0xCA, 0x0C, 0x76, 0x09, 0xB0,
  0x27, 0x50, 0x1B, 0x0B, 0x76, 0x06, 0xB0, 0x97, 0x60, 0x7B, 0x82, 0xD2, 0x03, 0x73, 0x06, 0xF7,
  0x30, 0x2F, 0x74, 0x07, 0xE7, 0x58, 0x45, 0xBE, 0xFD, 0x93,
  // "į" (U+012F)
  0x72, 0x82, 0x57, 0x52, 0x77, 0x01, 0x0D, 0xC0, 0x57, 0x60, 0x9D, 0x0E, 0x76, 0x0C, 0xE0, 0x27,
  0x50, 0xCE, 0x01, 0x75, 0x09, 0xD0, 0xE7, 0x60, 0x10, 0xDB, 0x0E, 0x05, 0x77, 0x18, 0x25, 0x75,
  0x17, 0x77, 0x70, 0x8F, 0xC0, 0x77, 0x08, 0xFC, 0x07, 0x70, 0x8F, 0xC0, 0x77, 0x08, 0xFC, 0x07,
  0x78, 0x51, 0x46, 0x79, 0xBD, 0xD0, 0x77, 0x60, 0x4D, 0x07, 0x76, 0x04, 0xD0, 0x77, 0x60, 0x4D,
  0x07, 0x76, 0x04, 0xD0, 0x77, 0x60, 0x4D, 0x07, 0x76, 0x04, 0xD0, 0x77, 0x60, 0x4D, 0x07, 0x76,
  0x04, 0xD0, 0x77, 0x60, 0x4D, 0x07, 0x76, 0x04, 0xD0, 0x77, 0x60, 0x4D, 0x07, 0x76, 0x04, 0xD0,
  0x77, 0x28, 0x32, 0x47, 0x9D, 0xD8, 0x3D, 0x97, 0x41, 0x28, 0x16, 0xCE, 0xFF, 0x98, 0x1D, 0xB9,
  0xFF, 0xD0, 0x9F, 0xFD, 0x09, 0xFF, 0xD7, 0x50, 0xCA, 0x0C, 0x77, 0x10, 0x9B, 0x02, 0x77, 0x01,
  0xB0, 0xB7, 0x71, 0x06, 0xB0, 0x97, 0x71, 0x07, 0xB8, 0x2D, 0x20, 0x37, 0x50, 0x6F, 0x75, 0x02,
  0xF7, 0x60, 0x7E, 0x77, 0x84, 0x5B, 0xEF, 0xD9, 0x20,
  // "İ" (U+0130)
  0x68, 0x43, 0xBE, 0xEB, 0x37, 0x40, 0x10, 0xEC, 0x0E, 0x01, 0x73, 0x06, 0xE0, 0x57, 0x30, 0x8E,
  0x07, 0x73, 0x06, 0xE0, 0x57, 0x30, 0x10, 0xEC, 0x0E, 0x01, 0x74, 0x84, 0x3B, 0xEE, 0xB2, 0x80,
  0xF0, 0x00, 0x6F, 0xFA, 0x00, 0x6F, 0xFA, 0x00, 0x6F, 0xFA, 0x00, 0x6F, 0xFA, 0x86, 0x60, 0x24,
  0x67, 0x9E, 0xC8, 0x4E, 0x97, 0x64, 0x27, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0,
  0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50,
  0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B,
  0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x75, 0x0D,
  0xC0, 0xB7, 0x50, 0xDC, 0x0B, 0x71, 0x83, 0x13, 0x56, 0xEC, 0x83, 0xD6, 0x53, 0x12, 0x05, 0xFF,
  0xA0, 0x50, 0x6F, 0xFA, 0x00, 0x6F, 0xFA, 0x00, 0x6F, 0xFA, 0x06,
  // "ı" (U+0131)
  0x10, 0x8F, 0xC0, 0x77, 0x08, 0xFC, 0x07, 0x70, 0x8F, 0xC0, 0x77, 0x08, 0xFC, 0x07, 0x78, 0x51,
  0x46, 0x79, 0xBD, 0xD0, 0x77, 0x60, 0x4D, 0x07, 0x76, 0x04, 0xD0, 0x77, 0x60, 0x4D, 0x07, 0x76,
  0x04, 0xD0, 0x77, 0x60, 0x4D, 0x07, 0x76, 0x04, 0xD0, 0x77, 0x60, 0x4D, 0x07, 0x76, 0x04, 0xD0,
  0x77, 0x60, 0x4D, 0x07, 0x76, 0x04, 0xD0, 0x77, 0x60, 0x4D, 0x07, 0x76, 0x04, 0xD0, 0x77, 0x28,
  0x32, 0x47, 0x9D, 0xD8, 0x3D, 0x97, 0x41, 0x28, 0x16, 0xCE, 0xFF, 0x98, 0x1D, 0xB9, 0xFF, 0xD0,
  0x9F, 0xFD, 0x09, 0xFF, 0xD0,
  // "Ĳ" (U+0132)
  0x09, 0xC0, 0xE5, 0x01, 0xD0, 0x09, 0xC0, 0xE5, 0x01, 0xD0, 0x09, 0xC0, 0xE5, 0x01, 0xD0, 0x09,
  0xC0, 0xE5, 0x01, 0xD0, 0x09, 0xC0, 0xE5, 0x01, 0xD0, 0x09, 0xC0, 0xE5, 0x01, 0xD0, 0x09, 0xC0,
  0xE5, 0x01, 0xD0, 0x09, 0xC0, 0xE5, 0x01, 0xD0, 0x09, 0xC0, 0xE5, 0x01, 0xD0, 0x09, 0xC0, 0xE5,
  0x01, 0xD0, 0x09, 0xC0, 0xE5, 0x01, 0xD0, 0x09, 0xC0, 0xE5, 0x01, 0xD0, 0x09, 0xC0, 0xE5, 0x01,
  0xD0, 0x09, 0xC0, 0xE5, 0x01, 0xD0, 0x09, 0xC0, 0xE5, 0x01, 0xD0, 0x09, 0xC0, 0xE5, 0x01, 0xD0,
  0x09, 0xC0, 0xE5, 0x01, 0xD0, 0x09, 0xC0, 0xE5, 0x01, 0xD0, 0x09, 0xC0, 0xE5, 0x01, 0xD0, 0x80,
  0x9C, 0x0E, 0x50, 0x2D, 0x07, 0x74, 0x05, 0xD0, 0x67, 0x40, 0xCD, 0x81, 0x22, 0x17, 0x01, 0x0A,
  0xD8, 0x1D, 0x08, 0xA8, 0x4D, 0xBA, 0xAA, 0xCF, 0x81, 0x70, 0x8F, 0xF0, 0xD2, 0x08, 0xFE, 0x0D,
  0x02, 0x20, 0x8F, 0xD0, 0xA0, 0x13, 0x84, 0x26, 0x9B, 0xDE, 0xA8, 0x3E, 0xDA, 0x71, 0x50,
  // "ĳ" (U+0133)
  0x18, 0x31, 0x57, 0x51, 0x68, 0x61, 0x57, 0x51, 0x03, 0xEB, 0x0E, 0x04, 0x40, 0x30, 0xEB, 0x81,
  0xE3, 0xBD, 0x0C, 0x40, 0xCD, 0x0B, 0x0E, 0xE4, 0xE0, 0x0E, 0xE4, 0xE0, 0xE0, 0xBD, 0x0C, 0x40,
  0xCD, 0x81, 0xB3, 0xEB, 0x0E, 0x03, 0x40, 0x40, 0xEB, 0x86, 0xE2, 0x01, 0x57, 0x51, 0x68, 0x21,
  0x57, 0x57, 0x76, 0x06, 0xD0, 0x54, 0x06, 0xD0, 0x50, 0x6D, 0x05, 0x40, 0x6D, 0x05, 0x06, 0xD0,
  0x54, 0x06, 0xD0, 0x50, 0x6D, 0x05, 0x40, 0x6D, 0x05, 0x06, 0xD0, 0x54, 0x06, 0xD0, 0x50, 0x6D,
  0x05, 0x40, 0x6D, 0x05, 0x06, 0xD0, 0x54, 0x06, 0xD0, 0x50, 0x6D, 0x05, 0x40, 0x6D, 0x05, 0x06,
  0xD0, 0x54, 0x06, 0xD0, 0x50, 0x6D, 0x05, 0x40, 0x6D, 0x05, 0x06, 0xD0, 0x54, 0x06, 0xD0, 0x50,
  0x6D, 0x05, 0x40, 0x6D, 0x05, 0x06, 0xD0, 0x54, 0x06, 0xD0, 0x50, 0x6D, 0x05, 0x40, 0x6D, 0x05,
  0x06, 0xD0, 0x54, 0x06, 0xD0, 0x50, 0x6D, 0x05, 0x40, 0x6D, 0x05, 0x06, 0xD0, 0x54, 0x06, 0xD0,
  0x50, 0x6D, 0x05, 0x40, 0x6D, 0x05, 0x06, 0xD0, 0x54, 0x06, 0xD0, 0x50, 0x6D, 0x05, 0x40, 0x6D,
  0x05, 0x06, 0xD0, 0x54, 0x06, 0xD0, 0x50, 0x6D, 0x05, 0x40, 0x7D, 0x05, 0x74, 0x07, 0xD0, 0x57,
  0x40, 0xAD, 0x04, 0x73, 0x01, 0x0E, 0xD0, 0x22, 0x02, 0x60, 0x10, 0xBD, 0x0E, 0x20, 0x3A, 0x83,
  0xCB, 0xAA, 0xBF, 0x09, 0x20, 0x3F, 0xE0, 0xE0, 0x12, 0x03, 0xFE, 0x04, 0x30, 0x3F, 0xC0, 0xD0,
  0x35, 0x83, 0x58, 0xBD, 0xEA, 0x82, 0xEC, 0x94, 0x50,
  // "Ĵ" (U+0134)
  0x74, 0x80, 0x27, 0x01, 0x77, 0x06, 0xE0, 0xA7, 0x60, 0x20, 0xEF, 0x05, 0x75, 0x0C, 0xC0, 0xDB,
  0x0E, 0x02, 0x73, 0x09, 0xB8, 0x2E, 0x41, 0xDB, 0x0C, 0x72, 0x06, 0xB0, 0xE0, 0x32, 0x01, 0x0C,
  0xB0, 0xA7, 0x02, 0xB0, 0xC0, 0x25, 0x0A, 0xB0, 0x58, 0x09, 0x90, 0x00, 0x1D, 0x09, 0x77, 0x10,
  0x1D, 0x09, 0x77, 0x10, 0x1D, 0x09, 0x77, 0x10, 0x1D, 0x09, 0x77, 0x10, 0x1D, 0x09, 0x77, 0x10,
  0x1D, 0x09, 0x77, 0x10, 0x1D, 0x09, 0x77, 0x10, 0x1D, 0x09, 0x77, 0x10, 0x1D, 0x09, 0x77, 0x10,
  0x1D, 0x09, 0x77, 0x10, 0x1D, 0x09, 0x77, 0x10, 0x1D, 0x09, 0x77, 0x10, 0x1D, 0x09, 0x77, 0x10,
  0x1D, 0x09, 0x77, 0x10, 0x1D, 0x09, 0x77, 0x10, 0x1D, 0x09, 0x77, 0x10, 0x1D, 0x09, 0x77, 0x10,
  0x1D, 0x09, 0x77, 0x10, 0x1D, 0x08, 0x77, 0x10, 0x2D, 0x07, 0x77, 0x10, 0x5D, 0x06, 0x77, 0x10,
  0xBD, 0x02, 0x50, 0x30, 0x26, 0x01, 0x09, 0xD0, 0xE6, 0x09, 0xA8, 0x4D, 0xBA, 0xAB, 0xEE, 0x07,
  0x60, 0x9F, 0xE0, 0xD7, 0x09, 0xFD, 0x0E, 0x03, 0x70, 0x9F, 0xC0, 0xB0, 0x17, 0x18, 0x92, 0x27,
  0xAC, 0xDE, 0xFE, 0xDB, 0x72, 0x73,
  // "ĵ" (U+0135)
  0x73, 0x80, 0x27, 0x01, 0x76, 0x06, 0xE0, 0xA7, 0x50, 0x20, 0xEF, 0x05, 0x74, 0x0C, 0xC0, 0xDB,
  0x0E, 0x02, 0x72, 0x09, 0xB8, 0x2E, 0x41, 0xDB, 0x0C, 0x71, 0x06, 0xB0, 0xE0, 0x32, 0x01, 0x0C,
  0xB0, 0xA6, 0x02, 0xB0, 0xC0, 0x25, 0x0A, 0xB0, 0x58, 0x0D, 0x20, 0x0D, 0xFC, 0x02, 0x71, 0x0D,
  0xFC, 0x02, 0x71, 0x0D, 0xFC, 0x02, 0x71, 0x0D, 0xFC, 0x02, 0x71, 0x85, 0x24, 0x57, 0x9A, 0xED,
  0x02, 0x77, 0x09, 0xD0, 0x27, 0x70, 0x9D, 0x02, 0x77, 0x09, 0xD0, 0x27, 0x70, 0x9D, 0x02, 0x77,
  0x09, 0xD0, 0x27, 0x70, 0x9D, 0x02, 0x77, 0x09, 0xD0, 0x27, 0x70, 0x9D, 0x02, 0x77, 0x09, 0xD0,
  0x27, 0x70, 0x9D, 0x02, 0x77, 0x09, 0xD0, 0x27, 0x70, 0x9D, 0x02, 0x77, 0x09, 0xD0, 0x27, 0x70,
  0x9D, 0x02, 0x77, 0x09, 0xD0, 0x27, 0x70, 0x9D, 0x02, 0x77, 0x0A, 0xD0, 0x27, 0x70, 0xBD, 0x02,
  0x77, 0x0D, 0xD7, 0x70, 0x3D, 0x0E, 0x50, 0x20, 0x36, 0x02, 0x0D, 0xD0, 0xB5, 0x06, 0xA8, 0x3C,
  0xBA, 0xAC, 0xF0, 0x55, 0x06, 0xFE, 0x0D, 0x60, 0x6F, 0xD0, 0xE0, 0x26, 0x06, 0xFC, 0x0B, 0x02,
  0x78, 0x92, 0x15, 0x8B, 0xDE, 0xFE, 0xEB, 0x83, 0x72,
  // "Ķ" (U+0136)
  0x03, 0xD0, 0x77, 0x01, 0x0E, 0xD0, 0x40, 0x3D, 0x07, 0x70, 0xBD, 0x81, 0x80, 0x3D, 0x07, 0x60,
  0x6D, 0x0C, 0x20, 0x3D, 0x07, 0x50, 0x10, 0xED, 0x02, 0x20, 0x3D, 0x07, 0x50, 0xBD, 0x06, 0x30,
  0x3D, 0x07, 0x40, 0x6D, 0x0B, 0x40, 0x3D, 0x07, 0x30, 0x20, 0xEC, 0x0E, 0x01, 0x40, 0x3D, 0x07,
  0x30, 0xBD, 0x04, 0x50, 0x3D, 0x07, 0x20, 0x7D, 0x08, 0x60, 0x3D, 0x81, 0x70, 0x2D, 0x0C, 0x70,
  0x3D, 0x81, 0x70, 0xBD, 0x02, 0x70, 0x3D, 0x07, 0x05, 0xD0, 0x67, 0x10, 0x3D, 0x08, 0x0D, 0xC0,
  0xC7, 0x20, 0x3D, 0x0E, 0xE0, 0x27, 0x10, 0x3F, 0xD0, 0xB7, 0x10, 0x3F, 0xE0, 0x47, 0x03, 0xF0,
  0xED, 0x0D, 0x70, 0x3E, 0x81, 0xC1, 0xAD, 0x06, 0x60, 0x3D, 0x82, 0xC1, 0x02, 0xD0, 0xE0, 0x15,
  0x03, 0xD0, 0x73, 0x09, 0xD0, 0x85, 0x03, 0xD0, 0x73, 0x01, 0x0E, 0xD0, 0x24, 0x03, 0xD0, 0x74,
  0x07, 0xD0, 0xA4, 0x03, 0xD0, 0x75, 0x0E, 0xD0, 0x43, 0x03, 0xD0, 0x75, 0x06, 0xD0, 0xC3, 0x03,
  0xD0, 0x76, 0x0D, 0xD0, 0x62, 0x03, 0xD0, 0x76, 0x04, 0xD0, 0xE2, 0x03, 0xD0, 0x77, 0x0B, 0xD8,
  0x18, 0x03, 0xD0, 0x77, 0x03, 0xE0, 0x28, 0x09, 0x86, 0x00, 0xCC, 0x08, 0x77, 0x20, 0xEC, 0x01,
  0x77, 0x10, 0x3C, 0x08, 0x77, 0x20, 0x6B, 0x0E, 0x01, 0x77, 0x20, 0xAB, 0x05, 0x77, 0x30, 0xEA,
  0x0A, 0x74,
  // "ķ" (U+0137)
  0x09, 0xD0, 0x37, 0x71, 0x09, 0xD0, 0x37, 0x71, 0x09, 0xD0, 0x37, 0x71, 0x09, 0xD0, 0x37, 0x71,
  0x09, 0xD0, 0x37, 0x71, 0x09, 0xD0, 0x37, 0x71, 0x09, 0xD0, 0x37, 0x71, 0x09, 0xD0, 0x37, 0x71,
  0x09, 0xD0, 0x36, 0x04, 0xE8, 0x16, 0x09, 0xD0, 0x35, 0x02, 0x0E, 0xD0, 0x82, 0x09, 0xD0, 0x34,
  0x01, 0x0D, 0xD0, 0xA3, 0x09, 0xD0, 0x34, 0x0B, 0xD0, 0xC4, 0x09, 0xD0, 0x33, 0x09, 0xD0, 0xD0,
  0x14, 0x09, 0xD0, 0x32, 0x07, 0xD0, 0xE0, 0x25, 0x09, 0xD8, 0x12, 0x04, 0xE0, 0x36, 0x09, 0xD8,
  0x12, 0x2E, 0xD0, 0x57, 0x09, 0xD0, 0x10, 0xDD, 0x06, 0x71, 0x09, 0xC0, 0xE0, 0x9E, 0x02, 0x71,
  0x09, 0xFD, 0x0B, 0x71, 0x09, 0xFE, 0x06, 0x70, 0x9F, 0xE0, 0xE0, 0x26, 0x09, 0xF0, 0x70, 0x5D,
  0x0B, 0x60, 0x9D, 0x0E, 0x03, 0x20, 0xAD, 0x06, 0x50, 0x9D, 0x03, 0x30, 0x10, 0xEC, 0x0E, 0x02,
  0x40, 0x9D, 0x03, 0x40, 0x6D, 0x0B, 0x40, 0x9D, 0x03, 0x50, 0xBD, 0x06, 0x30, 0x9D, 0x03, 0x50,
  0x20, 0xEC, 0x0E, 0x01, 0x20, 0x9D, 0x03, 0x60, 0x7D, 0x0B, 0x20, 0x9D, 0x03, 0x70, 0xCD, 0x81,
  0x60, 0x9D, 0x03, 0x70, 0x2D, 0x0E, 0x01, 0x80, 0x98, 0x60, 0x0C, 0xC0, 0x87, 0x72, 0x0E, 0xC0,
  0x17, 0x71, 0x03, 0xC0, 0x87, 0x72, 0x06, 0xB0, 0xE0, 0x17, 0x72, 0x0A, 0xB0, 0x57, 0x73, 0x0E,
  0xA0, 0xA7, 0x40,
  // "ĸ" (U+0138)
  0x09, 0xD0, 0x36, 0x04, 0xE8, 0x16, 0x09, 0xD0, 0x35, 0x02, 0x0E, 0xD0, 0x82, 0x09, 0xD0, 0x34,
  0x01, 0x0D, 0xD0, 0xA3, 0x09, 0xD0, 0x34, 0x0B, 0xD0, 0xC4, 0x09, 0xD0, 0x33, 0x09, 0xD0, 0xD0,
  0x14, 0x09, 0xD0, 0x32, 0x07, 0xD0, 0xE0, 0x25, 0x09, 0xD8, 0x12, 0x04, 0xE0, 0x36, 0x09, 0xD8,
  0x12, 0x2E, 0xD0, 0x57, 0x09, 0xD0, 0x10, 0xDD, 0x06, 0x71, 0x09, 0xC0, 0xE0, 0x9E, 0x02, 0x71,
  0x09, 0xFD, 0x0B, 0x71, 0x09, 0xFE, 0x06, 0x70, 0x9F, 0xE0, 0xE0, 0x26, 0x09, 0xF0, 0x70, 0x5D,
  0x0B, 0x60, 0x9D, 0x0E, 0x03, 0x20, 0xAD, 0x06, 0x50, 0x9D, 0x03, 0x30, 0x10, 0xEC, 0x0E, 0x02,
  0x40, 0x9D, 0x03, 0x40, 0x6D, 0x0B, 0x40, 0x9D, 0x03, 0x50, 0xBD, 0x06, 0x30, 0x9D, 0x03, 0x50,
  0x20, 0xEC, 0x0E, 0x01, 0x20, 0x9D, 0x03, 0x60, 0x7D, 0x0B, 0x20, 0x9D, 0x03, 0x70, 0xCD, 0x81,
  0x60, 0x9D, 0x03, 0x70, 0x2D, 0x0E, 0x01,
  // "Ĺ" (U+0139)
  0x30, 0x28, 0x02, 0x70, 0x17, 0x40, 0xBD, 0x0A, 0x74, 0x05, 0xD0, 0xA7, 0x40, 0x10, 0xEC, 0x09,
  0x75, 0x0A, 0xC0, 0x97, 0x50, 0x6C, 0x07, 0x76, 0x0E, 0xB0, 0x58, 0x09, 0x83, 0x00, 0x6D, 0x06,
  0x75, 0x06, 0xD0, 0x67, 0x50, 0x6D, 0x06, 0x75, 0x06, 0xD0, 0x67, 0x50, 0x6D, 0x06, 0x75, 0x06,
  0xD0, 0x67, 0x50, 0x6D, 0x06, 0x75, 0x06, 0xD0, 0x67, 0x50, 0x6D, 0x06, 0x75, 0x06, 0xD0, 0x67,
  0x50, 0x6D, 0x06, 0x75, 0x06, 0xD0, 0x67, 0x50, 0x6D, 0x06, 0x75, 0x06, 0xD0, 0x67, 0x50, 0x6D,
  0x06, 0x75, 0x06, 0xD0, 0x67, 0x50, 0x6D, 0x06, 0x75, 0x06, 0xD0, 0x67, 0x50, 0x6D, 0x06, 0x75,
  0x06, 0xD0, 0x67, 0x50, 0x6D, 0x06, 0x75, 0x06, 0xD0, 0x67, 0x50, 0x6D, 0x06, 0x75, 0x06, 0xD0,
  0xC8, 0x07, 0x90, 0x20, 0x6F, 0xFB, 0x03, 0x06, 0xFF, 0xB0, 0x30, 0x6F, 0xFB, 0x03, 0x06, 0xFF,
  0xB0, 0x30,
  // "ĺ" (U+013A)
  0x73, 0x02, 0x80, 0x27, 0x01, 0x75, 0x0B, 0xD0, 0xA7, 0x50, 0x5D, 0x0A, 0x75, 0x01, 0x0E, 0xC0,
  0x97, 0x60, 0xAC, 0x09, 0x76, 0x06, 0xC0, 0x77, 0x70, 0xEB, 0x05, 0x80, 0x98, 0x10, 0x03, 0xFC,
  0x06, 0x70, 0x3F, 0xC0, 0x67, 0x03, 0xFC, 0x06, 0x70, 0x2F, 0xC0, 0x67, 0x28, 0x23, 0x6A, 0xDE,
  0x06, 0x76, 0x06, 0xD0, 0x67, 0x60, 0x6D, 0x06, 0x76, 0x06, 0xD0, 0x67, 0x60, 0x6D, 0x06, 0x76,
  0x06, 0xD0, 0x67, 0x60, 0x6D, 0x06, 0x76, 0x06, 0xD0, 0x67, 0x60, 0x6D, 0x06, 0x76, 0x06, 0xD0,
  0x67, 0x60, 0x6D, 0x06, 0x76, 0x06, 0xD0, 0x67, 0x60, 0x6D, 0x06, 0x76, 0x06, 0xD0, 0x67, 0x60,
  0x6D, 0x06, 0x76, 0x06, 0xD0, 0x67, 0x60, 0x6D, 0x06, 0x76, 0x06, 0xD0, 0x67, 0x60, 0x6D, 0x06,
  0x76, 0x06, 0xD0, 0x67, 0x60, 0x6D, 0x06, 0x73, 0x82, 0x25, 0x7C, 0xD8, 0x2B, 0x74, 0x13, 0x81,
  0x5A, 0xDF, 0xF8, 0x2E, 0xB9, 0x9F, 0xFD, 0x09, 0xFF, 0xD0, 0x9F, 0xFD,
  // "Ļ" (U+013B)
  0x06, 0xD0, 0x67, 0x50, 0x6D, 0x06, 0x75, 0x06, 0xD0, 0x67, 0x50, 0x6D, 0x06, 0x75, 0x06, 0xD0,
  0x67, 0x50, 0x6D, 0x06, 0x75, 0x06, 0xD0, 0x67, 0x50, 0x6D, 0x06, 0x75, 0x06, 0xD0, 0x67, 0x50,
  0x6D, 0x06, 0x75, 0x06, 0xD0, 0x67, 0x50, 0x6D, 0x06, 0x75, 0x06, 0xD0, 0x67, 0x50, 0x6D, 0x06,
  0x75, 0x06, 0xD0, 0x67, 0x50, 0x6D, 0x06, 0x75, 0x06, 0xD0, 0x67, 0x50, 0x6D, 0x06, 0x75, 0x06,
  0xD0, 0x67, 0x50, 0x6D, 0x06, 0x75, 0x06, 0xD0, 0x67, 0x50, 0x6D, 0x06, 0x75, 0x06, 0xD0, 0x67,
  0x50, 0x6D, 0x0C, 0x80, 0x79, 0x02, 0x06, 0xFF, 0xB0, 0x30, 0x6F, 0xFB, 0x03, 0x06, 0xFF, 0xB0,
  0x30, 0x6F, 0xFB, 0x03, 0x80, 0xF4, 0x00, 0xCC, 0x08, 0x76, 0x0E, 0xC0, 0x17, 0x50, 0x3C, 0x08,
  0x76, 0x06, 0xB0, 0xE0, 0x17, 0x60, 0xAB, 0x05, 0x77, 0x0E, 0xA0, 0xA7, 0x20,
  // "ļ" (U+013C)
  0x10, 0x3F, 0xC0, 0x67, 0x03, 0xFC, 0x06, 0x70, 0x3F, 0xC0, 0x67, 0x02, 0xFC, 0x06, 0x72, 0x82,
  0x36, 0xAD, 0xE0, 0x67, 0x60, 0x6D, 0x06, 0x76, 0x06, 0xD0, 0x67, 0x60, 0x6D, 0x06, 0x76, 0x06,
  0xD0, 0x67, 0x60, 0x6D, 0x06, 0x76, 0x06, 0xD0, 0x67, 0x60, 0x6D, 0x06, 0x76, 0x06, 0xD0, 0x67,
  0x60, 0x6D, 0x06, 0x76, 0x06, 0xD0, 0x67, 0x60, 0x6D, 0x06, 0x76, 0x06, 0xD0, 0x67, 0x60, 0x6D,
  0x06, 0x76, 0x06, 0xD0, 0x67, 0x60, 0x6D, 0x06, 0x76, 0x06, 0xD0, 0x67, 0x60, 0x6D, 0x06, 0x76,
  0x06, 0xD0, 0x67, 0x60, 0x6D, 0x06, 0x76, 0x06, 0xD0, 0x67, 0x38, 0x22, 0x57, 0xCD, 0x82, 0xB7,
  0x41, 0x38, 0x15, 0xAD, 0xFF, 0x82, 0xEB, 0x99, 0xFF, 0xD0, 0x9F, 0xFD, 0x09, 0xFF, 0xD8, 0x09,
  0x80, 0x00, 0xCC, 0x08, 0x77, 0x0E, 0xC0, 0x17, 0x60, 0x3C, 0x08, 0x77, 0x06, 0xB0, 0xE0, 0x17,
  0x70, 0xAB, 0x05, 0x77, 0x10, 0xEA, 0x0A, 0x72,
  // "Ľ" (U+013D)
  0x06, 0xD0, 0x65, 0x06, 0xC8, 0x1E, 0x06, 0xD0, 0x65, 0x08, 0xC8, 0x17, 0x06, 0xD0, 0x65, 0x0C,
  0xB0, 0xE2, 0x06, 0xD0, 0x65, 0xC0, 0x52, 0x06, 0xD0, 0x64, 0x03, 0xB0, 0xB3, 0x06, 0xD0, 0x64,
  0x07, 0xB0, 0x23, 0x06, 0xD0, 0x67, 0x50, 0x6D, 0x06, 0x75, 0x06, 0xD0, 0x67, 0x50, 0x6D, 0x06,
  0x75, 0x06, 0xD0, 0x67, 0x50, 0x6D, 0x06, 0x75, 0x06, 0xD0, 0x67, 0x50, 0x6D, 0x06, 0x75, 0x06,
  0xD0, 0x67, 0x50, 0x6D, 0x06, 0x75, 0x06, 0xD0, 0x67, 0x50, 0x6D, 0x06, 0x75, 0x06, 0xD0, 0x67,
  0x50, 0x6D, 0x06, 0x75, 0x06, 0xD0, 0x67, 0x50, 0x6D, 0x06, 0x75, 0x06, 0xD0, 0x67, 0x50, 0x6D,
  0x0C, 0x80, 0x79, 0x02, 0x06, 0xFF, 0xB0, 0x30, 0x6F, 0xFB, 0x03, 0x06, 0xFF, 0xB0, 0x30, 0x6F,
  0xFB, 0x03,
  // "ľ" (U+013E)
  0x10, 0x3F, 0xC0, 0x62, 0x09, 0xC8, 0x1B, 0x03, 0xFC, 0x06, 0x20, 0xCC, 0x81, 0x40, 0x3F, 0xC0,
  0x62, 0x0E, 0xB0, 0xB2, 0x82, 0x18, 0xBE, 0xF9, 0x81, 0x60, 0x3C, 0x03, 0x68, 0x11, 0x4A, 0xD8,
  0x16, 0x07, 0xB0, 0x87, 0x20, 0x6D, 0x81, 0x60, 0xAA, 0x0D, 0x73, 0x06, 0xD0, 0x67, 0x71, 0x06,
  0xD0, 0x67, 0x71, 0x06, 0xD0, 0x67, 0x71, 0x06, 0xD0, 0x67, 0x71, 0x06, 0xD0, 0x67, 0x71, 0x06,
  0xD0, 0x67, 0x71, 0x06, 0xD0, 0x67, 0x71, 0x06, 0xD0, 0x67, 0x71, 0x06, 0xD0, 0x67, 0x71, 0x06,
  0xD0, 0x67, 0x71, 0x06, 0xD0, 0x67, 0x71, 0x06, 0xD0, 0x67, 0x71, 0x06, 0xD0, 0x67, 0x71, 0x06,
  0xD0, 0x67, 0x71, 0x06, 0xD0, 0x67, 0x71, 0x06, 0xD0, 0x67, 0x71, 0x06, 0xD0, 0x67, 0x71, 0x06,
  0xD0, 0x67, 0x71, 0x06, 0xD0, 0x67, 0x48, 0x31, 0x36, 0x8C, 0xD8, 0x2C, 0x85, 0x35, 0x81, 0x5B,
  0xEF, 0xF9, 0x0C, 0x0A, 0x20, 0x9F, 0xFD, 0x20, 0x9F, 0xFD, 0x20, 0x9F, 0xFD, 0x20,
  // "Ŀ" (U+013F)
  0x06, 0xD0, 0x67, 0x50, 0x6D, 0x06, 0x75, 0x06, 0xD0, 0x67, 0x50, 0x6D, 0x06, 0x75, 0x06, 0xD0,
  0x67, 0x50, 0x6D, 0x06, 0x75, 0x06, 0xD0, 0x67, 0x50, 0x6D, 0x06, 0x75, 0x06, 0xD0, 0x65, 0x86,
  0x3B, 0xEE, 0xB2, 0x06, 0xD0, 0x64, 0x02, 0xD8, 0x1E, 0x16, 0xD0, 0x64, 0x07, 0xE0, 0x06, 0xD0,
  0x64, 0x09, 0xE0, 0x80, 0x6D, 0x06, 0x40, 0x7E, 0x00, 0x6D, 0x06, 0x40, 0x10, 0xEC, 0x81, 0xE1,
  0x6D, 0x06, 0x58, 0x63, 0xBE, 0xEA, 0x20, 0x6D, 0x06, 0x75, 0x06, 0xD0, 0x67, 0x50, 0x6D, 0x06,
  0x75, 0x06, 0xD0, 0x67, 0x50, 0x6D, 0x06, 0x75, 0x06, 0xD0, 0x67, 0x50, 0x6D, 0x06, 0x75, 0x06,
  0xD0, 0x67, 0x50, 0x6D, 0x0C, 0x80, 0x79, 0x02, 0x06, 0xFF, 0xB0, 0x30, 0x6F, 0xFB, 0x03, 0x06,
  0xFF, 0xB0, 0x30, 0x6F, 0xFB, 0x03,
  // "ŀ" (U+0140)
  0x10, 0x3F, 0xC0, 0x67, 0x60, 0x3F, 0xC0, 0x67, 0x60, 0x3F, 0xC0, 0x67, 0x60, 0x2F, 0xC0, 0x67,
  0x71, 0x82, 0x36, 0xAD, 0xE0, 0x67, 0x75, 0x06, 0xD0, 0x67, 0x75, 0x06, 0xD0, 0x67, 0x75, 0x06,
  0xD0, 0x67, 0x75, 0x06, 0xD0, 0x67, 0x75, 0x06, 0xD0, 0x67, 0x75, 0x06, 0xD0, 0x67, 0x75, 0x06,
  0xD0, 0x65, 0x84, 0x3B, 0xEE, 0xB2, 0x71, 0x06, 0xD0, 0x64, 0x02, 0xD0, 0xE0, 0x17, 0x06, 0xD0,
  0x64, 0x07, 0xE0, 0x67, 0x06, 0xD0, 0x64, 0x09, 0xE0, 0x87, 0x06, 0xD0, 0x64, 0x07, 0xE0, 0x67,
  0x06, 0xD0, 0x64, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x06, 0xD0, 0x65, 0x84, 0x3B, 0xEE, 0xA2, 0x71,
  0x06, 0xD0, 0x67, 0x75, 0x06, 0xD0, 0x67, 0x75, 0x06, 0xD0, 0x67, 0x75, 0x06, 0xD0, 0x67, 0x75,
  0x06, 0xD0, 0x67, 0x75, 0x06, 0xD0, 0x67, 0x75, 0x06, 0xD0, 0x67, 0x72, 0x82, 0x25, 0x7C, 0xD8,
  0x2B, 0x74, 0x17, 0x28, 0x15, 0xAD, 0xFF, 0x81, 0xEB, 0x96, 0x09, 0xFF, 0xD6, 0x09, 0xFF, 0xD6,
  0x09, 0xFF, 0xD6,
  // "Ł" (U+0141)
  0x40, 0xCD, 0x77, 0x20, 0xCD, 0x77, 0x20, 0xCD, 0x77, 0x20, 0xCD, 0x77, 0x20, 0xCD, 0x77, 0x20,
  0xCD, 0x77, 0x20, 0xCD, 0x77, 0x20, 0xCD, 0x77, 0x20, 0xCD, 0x20, 0x27, 0x60, 0xCD, 0x18, 0x17,
  0xF8, 0x75, 0x0C, 0xD0, 0xDB, 0x02, 0x74, 0x0C, 0xFA, 0x0B, 0x74, 0x0C, 0xFA, 0x0A, 0x74, 0x0C,
  0xF0, 0xD0, 0x47, 0x30, 0x10, 0xAE, 0x0E, 0x07, 0x74, 0x07, 0x0E, 0xF0, 0x17, 0x40, 0x2F, 0xA7,
  0x60, 0x9F, 0x97, 0x60, 0x10, 0xEF, 0x77, 0x81, 0x54, 0xCD, 0x77, 0x20, 0xCD, 0x77, 0x20, 0xCD,
  0x77, 0x20, 0xCD, 0x77, 0x20, 0xCD, 0x80, 0x79, 0x07, 0x40, 0xCF, 0xFA, 0x0C, 0x40, 0xCF, 0xFA,
  0x0C, 0x40, 0xCF, 0xFA, 0x0C, 0x40, 0xCF, 0xFA, 0x0C,
  // "ł" (U+0142)
  0x10, 0x3F, 0xC0, 0x67, 0x03, 0xFC, 0x06, 0x70, 0x3F, 0xC0, 0x67, 0x02, 0xFC, 0x06, 0x72, 0x82,
  0x36, 0xAD, 0xE0, 0x67, 0x60, 0x6D, 0x06, 0x76, 0x06, 0xD0, 0x67, 0x60, 0x6D, 0x06, 0x76, 0x06,
  0xD0, 0x67, 0x60, 0x6D, 0x06, 0x76, 0x06, 0xD8, 0x26, 0x06, 0x17, 0x30, 0x6D, 0x82, 0x9C, 0xFA,
  0x73, 0x06, 0xFA, 0x04, 0x72, 0x06, 0xFA, 0x0D, 0x72, 0x06, 0xF9, 0x0D, 0x04, 0x71, 0x01, 0x0B,
  0xE0, 0xE0, 0x77, 0x20, 0x60, 0xEE, 0x0B, 0x01, 0x71, 0x03, 0x0C, 0xF9, 0x06, 0x71, 0x02, 0xFB,
  0x06, 0x72, 0x09, 0xFA, 0x06, 0x72, 0x83, 0x1E, 0xFC, 0x9D, 0x06, 0x73, 0x82, 0x66, 0x06, 0xD0,
  0x67, 0x60, 0x6D, 0x06, 0x76, 0x06, 0xD0, 0x67, 0x60, 0x6D, 0x06, 0x73, 0x82, 0x25, 0x7C, 0xD8,
  0x2B, 0x74, 0x13, 0x81, 0x5A, 0xDF, 0xF8, 0x2E, 0xB9, 0x9F, 0xFD, 0x09, 0xFF, 0xD0, 0x9F, 0xFD,
  // "Ń" (U+0143)
  0x74, 0x02, 0x80, 0x27, 0x01, 0x77, 0x0B, 0xD0, 0xA7, 0x70, 0x5D, 0x0A, 0x77, 0x01, 0x0E, 0xC0,
  0x97, 0x71, 0x0A, 0xC0, 0x97, 0x71, 0x06, 0xC0, 0x77, 0x72, 0x0E, 0xB0, 0x58, 0x09, 0x87, 0x00,
  0x3F, 0x0D, 0x70, 0xEC, 0x00, 0x3F, 0x90, 0x26, 0x0E, 0xC0, 0x03, 0xF9, 0x08, 0x60, 0xEC, 0x00,
  0x3F, 0x90, 0xD6, 0x0E, 0xC0, 0x03, 0xFA, 0x02, 0x50, 0xEC, 0x00, 0x3C, 0x0D, 0xC0, 0x85, 0x0E,
  0xC0, 0x03, 0xC0, 0xA0, 0xEB, 0x0D, 0x50, 0xEC, 0x00, 0x3C, 0x0A, 0x09, 0xC0, 0x24, 0x0E, 0xC0,
  0x03, 0xC0, 0xB0, 0x3C, 0x07, 0x40, 0xEC, 0x00, 0x3C, 0x81, 0xC0, 0xEB, 0x0D, 0x40, 0xEC, 0x00,
  0x3C, 0x81, 0xD0, 0x9C, 0x02, 0x30, 0xEC, 0x00, 0x3C, 0x81, 0xD0, 0x3C, 0x07, 0x30, 0xEC, 0x00,
  0x3C, 0x0E, 0x20, 0xEB, 0x0D, 0x30, 0xEC, 0x00, 0x3C, 0x0E, 0x20, 0x9C, 0x02, 0x20, 0xEC, 0x00,
  0x3C, 0x0E, 0x20, 0x3C, 0x07, 0x20, 0xEC, 0x00, 0x3C, 0x0E, 0x30, 0xEB, 0x0D, 0x20, 0xEC, 0x00,
  0x3C, 0x0E, 0x30, 0x9C, 0x81, 0x20, 0xEC, 0x00, 0x3C, 0x0E, 0x30, 0x4C, 0x81, 0x70, 0xEC, 0x00,
  0x3C, 0x0E, 0x40, 0xEB, 0x81, 0xD0, 0xDC, 0x00, 0x3C, 0x0E, 0x40, 0x9C, 0x02, 0x0D, 0xC0, 0x03,
  0xC0, 0xE4, 0x04, 0xC0, 0x70, 0xCC, 0x00, 0x3C, 0x0E, 0x50, 0xEB, 0x0D, 0x0B, 0xC0, 0x03, 0xC0,
  0xE5, 0x09, 0xC0, 0xDC, 0x00, 0x3C, 0x0E, 0x50, 0x4F, 0xA0, 0x03, 0xC0, 0xE6, 0x0E, 0xF9, 0x00,
  0x3C, 0x0E, 0x60, 0x9F, 0x90, 0x03, 0xC0, 0xE6, 0x04, 0xF9, 0x00, 0x3C, 0x0E, 0x70, 0xEF, 0x03,
  // "ń" (U+0144)
  0x73, 0x02, 0x80, 0x27, 0x01, 0x75, 0x0B, 0xD0, 0xA7, 0x50, 0x5D, 0x0A, 0x75, 0x01, 0x0E, 0xC0,
  0x97, 0x60, 0xAC, 0x09, 0x76, 0x06, 0xC0, 0x77, 0x70, 0xEB, 0x05, 0x80, 0xD4, 0x00, 0xCB, 0x0B,
  0x38, 0x73, 0x8C, 0xEF, 0xEC, 0x81, 0x30, 0xCC, 0x81, 0x10, 0x9F, 0xA0, 0x62, 0x0C, 0xC0, 0x60,
  0xAF, 0xC8, 0x16, 0x0C, 0xFF, 0xC0, 0x10, 0xCF, 0x98, 0x1B, 0xAC, 0xF0, 0x70, 0xCE, 0x0D, 0x02,
  0x30, 0x30, 0xED, 0x0B, 0x0C, 0xE0, 0x25, 0x05, 0xD0, 0xE0, 0xCD, 0x0A, 0x7E, 0x0C, 0xD0, 0x57,
  0x0D, 0xD0, 0xCD, 0x02, 0x70, 0xCD, 0x0C, 0xD7, 0x10, 0xCD, 0x0C, 0xD7, 0x10, 0xCD, 0x0C, 0xD7,
  0x10, 0xCD, 0x0C, 0xD7, 0x10, 0xCD, 0x0C, 0xD7, 0x10, 0xCD, 0x0C, 0xD7, 0x10, 0xCD, 0x0C, 0xD7,
  0x10, 0xCD, 0x0C, 0xD7, 0x10, 0xCD, 0x0C, 0xD7, 0x10, 0xCD, 0x0C, 0xD7, 0x10, 0xCD, 0x0C, 0xD7,
  0x10, 0xCD, 0x0C, 0xD7, 0x10, 0xCD,
  // "Ņ" (U+0145)
  0x03, 0xF0, 0xD7, 0x0E, 0xC0, 0x03, 0xF9, 0x02, 0x60, 0xEC, 0x00, 0x3F, 0x90, 0x86, 0x0E, 0xC0,
  0x03, 0xF9, 0x0D, 0x60, 0xEC, 0x00, 0x3F, 0xA0, 0x25, 0x0E, 0xC0, 0x03, 0xC0, 0xDC, 0x08, 0x50,
  0xEC, 0x00, 0x3C, 0x0A, 0x0E, 0xB0, 0xD5, 0x0E, 0xC0, 0x03, 0xC0, 0xA0, 0x9C, 0x02, 0x40, 0xEC,
  0x00, 0x3C, 0x0B, 0x03, 0xC0, 0x74, 0x0E, 0xC0, 0x03, 0xC8, 0x1C, 0x0E, 0xB0, 0xD4, 0x0E, 0xC0,
  0x03, 0xC8, 0x1D, 0x09, 0xC0, 0x23, 0x0E, 0xC0, 0x03, 0xC8, 0x1D, 0x03, 0xC0, 0x73, 0x0E, 0xC0,
  0x03, 0xC0, 0xE2, 0x0E, 0xB0, 0xD3, 0x0E, 0xC0, 0x03, 0xC0, 0xE2, 0x09, 0xC0, 0x22, 0x0E, 0xC0,
  0x03, 0xC0, 0xE2, 0x03, 0xC0, 0x72, 0x0E, 0xC0, 0x03, 0xC0, 0xE3, 0x0E, 0xB0, 0xD2, 0x0E, 0xC0,
  0x03, 0xC0, 0xE3, 0x09, 0xC8, 0x12, 0x0E, 0xC0, 0x03, 0xC0, 0xE3, 0x04, 0xC8, 0x17, 0x0E, 0xC0,
  0x03, 0xC0, 0xE4, 0x0E, 0xB8, 0x1D, 0x0D, 0xC0, 0x03, 0xC0, 0xE4, 0x09, 0xC0, 0x20, 0xDC, 0x00,
  0x3C, 0x0E, 0x40, 0x4C, 0x07, 0x0C, 0xC0, 0x03, 0xC0, 0xE5, 0x0E, 0xB0, 0xD0, 0xBC, 0x00, 0x3C,
  0x0E, 0x50, 0x9C, 0x0D, 0xC0, 0x03, 0xC0, 0xE5, 0x04, 0xFA, 0x00, 0x3C, 0x0E, 0x60, 0xEF, 0x90,
  0x03, 0xC0, 0xE6, 0x09, 0xF9, 0x00, 0x3C, 0x0E, 0x60, 0x4F, 0x90, 0x03, 0xC0, 0xE7, 0x0E, 0xF0,
  0x38, 0x09, 0x86, 0x00, 0xCC, 0x08, 0x77, 0x20, 0xEC, 0x01, 0x77, 0x10, 0x3C, 0x08, 0x77, 0x20,
  0x6B, 0x0E, 0x01, 0x77, 0x20, 0xAB, 0x05, 0x77, 0x30, 0xEA, 0x0A, 0x74,
  // "ņ" (U+0146)
  0x0C, 0xB0, 0xB3, 0x87, 0x38, 0xCE, 0xFE, 0xC8, 0x13, 0x0C, 0xC8, 0x11, 0x09, 0xFA, 0x06, 0x20,
  0xCC, 0x06, 0x0A, 0xFC, 0x81, 0x60, 0xCF, 0xFC, 0x01, 0x0C, 0xF9, 0x81, 0xBA, 0xCF, 0x07, 0x0C,
  0xE0, 0xD0, 0x23, 0x03, 0x0E, 0xD0, 0xB0, 0xCE, 0x02, 0x50, 0x5D, 0x0E, 0x0C, 0xD0, 0xA7, 0xE0,
  0xCD, 0x05, 0x70, 0xDD, 0x0C, 0xD0, 0x27, 0x0C, 0xD0, 0xCD, 0x71, 0x0C, 0xD0, 0xCD, 0x71, 0x0C,
  0xD0, 0xCD, 0x71, 0x0C, 0xD0, 0xCD, 0x71, 0x0C, 0xD0, 0xCD, 0x71, 0x0C, 0xD0, 0xCD, 0x71, 0x0C,
  0xD0, 0xCD, 0x71, 0x0C, 0xD0, 0xCD, 0x71, 0x0C, 0xD0, 0xCD, 0x71, 0x0C, 0xD0, 0xCD, 0x71, 0x0C,
  0xD0, 0xCD, 0x71, 0x0C, 0xD0, 0xCD, 0x71, 0x0C, 0xD8, 0x0F, 0x70, 0x0C, 0xC0, 0x87, 0x70, 0xEC,
  0x01, 0x76, 0x03, 0xC0, 0x87, 0x70, 0x6B, 0x0E, 0x01, 0x77, 0x0A, 0xB0, 0x57, 0x71, 0x0E, 0xA0,
  0xA7, 0x30,
  // "Ň" (U+0147)
  0x38, 0x32, 0x77, 0x74, 0x68, 0x34, 0x77, 0x72, 0x60, 0x10, 0xDB, 0x07, 0x40, 0x7B, 0x0D, 0x01,
  0x70, 0x20, 0xEB, 0x08, 0x20, 0xAB, 0x0E, 0x02, 0x72, 0x05, 0xC0, 0x80, 0xAC, 0x05, 0x74, 0x09,
  0xF9, 0x09, 0x76, 0x0D, 0xE0, 0xD7, 0x70, 0x3E, 0x03, 0x80, 0x98, 0x50, 0x03, 0xF0, 0xD7, 0x0E,
  0xC0, 0x03, 0xF9, 0x02, 0x60, 0xEC, 0x00, 0x3F, 0x90, 0x86, 0x0E, 0xC0, 0x03, 0xF9, 0x0D, 0x60,
  0xEC, 0x00, 0x3F, 0xA0, 0x25, 0x0E, 0xC0, 0x03, 0xC0, 0xDC, 0x08, 0x50, 0xEC, 0x00, 0x3C, 0x0A,
  0x0E, 0xB0, 0xD5, 0x0E, 0xC0, 0x03, 0xC0, 0xA0, 0x9C, 0x02, 0x40, 0xEC, 0x00, 0x3C, 0x0B, 0x03,
  0xC0, 0x74, 0x0E, 0xC0, 0x03, 0xC8, 0x1C, 0x0E, 0xB0, 0xD4, 0x0E, 0xC0, 0x03, 0xC8, 0x1D, 0x09,
  0xC0, 0x23, 0x0E, 0xC0, 0x03, 0xC8, 0x1D, 0x03, 0xC0, 0x73, 0x0E, 0xC0, 0x03, 0xC0, 0xE2, 0x0E,
  0xB0, 0xD3, 0x0E, 0xC0, 0x03, 0xC0, 0xE2, 0x09, 0xC0, 0x22, 0x0E, 0xC0, 0x03, 0xC0, 0xE2, 0x03,
  0xC0, 0x72, 0x0E, 0xC0, 0x03, 0xC0, 0xE3, 0x0E, 0xB0, 0xD2, 0x0E, 0xC0, 0x03, 0xC0, 0xE3, 0x09,
  0xC8, 0x12, 0x0E, 0xC0, 0x03, 0xC0, 0xE3, 0x04, 0xC8, 0x17, 0x0E, 0xC0, 0x03, 0xC0, 0xE4, 0x0E,
  0xB8, 0x1D, 0x0D, 0xC0, 0x03, 0xC0, 0xE4, 0x09, 0xC0, 0x20, 0xDC, 0x00, 0x3C, 0x0E, 0x40, 0x4C,
  0x07, 0x0C, 0xC0, 0x03, 0xC0, 0xE5, 0x0E, 0xB0, 0xD0, 0xBC, 0x00, 0x3C, 0x0E, 0x50, 0x9C, 0x0D,
  0xC0, 0x03, 0xC0, 0xE5, 0x04, 0xFA, 0x00, 0x3C, 0x0E, 0x60, 0xEF, 0x90, 0x03, 0xC0, 0xE6, 0x09,
  0xF9, 0x00, 0x3C, 0x0E, 0x60, 0x4F, 0x90, 0x03, 0xC0, 0xE7, 0x0E, 0xF0, 0x30,
  // "ň" (U+0148)
  0x28, 0x32, 0x77, 0x74, 0x68, 0x34, 0x77, 0x72, 0x40, 0x10, 0xDB, 0x07, 0x40, 0x7B, 0x0D, 0x01,
  0x50, 0x20, 0xEB, 0x08, 0x20, 0xAB, 0x0E, 0x02, 0x70, 0x5C, 0x08, 0x0A, 0xC0, 0x57, 0x20, 0x9F,
  0x90, 0x97, 0x40, 0xDE, 0x0D, 0x75, 0x03, 0xE0, 0x38, 0x0D, 0x20, 0x0C, 0xB0, 0xB3, 0x87, 0x38,
  0xCE, 0xFE, 0xC8, 0x13, 0x0C, 0xC8, 0x11, 0x09, 0xFA, 0x06, 0x20, 0xCC, 0x06, 0x0A, 0xFC, 0x81,
  0x60, 0xCF, 0xFC, 0x01, 0x0C, 0xF9, 0x81, 0xBA, 0xCF, 0x07, 0x0C, 0xE0, 0xD0, 0x23, 0x03, 0x0E,
  0xD0, 0xB0, 0xCE, 0x02, 0x50, 0x5D, 0x0E, 0x0C, 0xD0, 0xA7, 0xE0, 0xCD, 0x05, 0x70, 0xDD, 0x0C,
  0xD0, 0x27, 0x0C, 0xD0, 0xCD, 0x71, 0x0C, 0xD0, 0xCD, 0x71, 0x0C, 0xD0, 0xCD, 0x71, 0x0C, 0xD0,
  0xCD, 0x71, 0x0C, 0xD0, 0xCD, 0x71, 0x0C, 0xD0, 0xCD, 0x71, 0x0C, 0xD0, 0xCD, 0x71, 0x0C, 0xD0,
  0xCD, 0x71, 0x0C, 0xD0, 0xCD, 0x71, 0x0C, 0xD0, 0xCD, 0x71, 0x0C, 0xD0, 0xCD, 0x71, 0x0C, 0xD0,
  0xCD, 0x71, 0x0C, 0xD0,
  // "ŉ" (U+0149)
  0x20, 0xAD, 0x01, 0x77, 0x60, 0xCC, 0x0D, 0x77, 0x7D, 0x09, 0x77, 0x60, 0x2D, 0x03, 0x77, 0x60,
  0x5C, 0x0E, 0x77, 0x70, 0x8C, 0x08, 0x77, 0x70, 0xCC, 0x02, 0x06, 0xC0, 0x23, 0x86, 0x5B, 0xDF,
  0xEC, 0x82, 0x4C, 0x81, 0xB0, 0x6C, 0x82, 0x60, 0x1C, 0xF9, 0x07, 0x20, 0x3C, 0x81, 0x50, 0x6C,
  0x81, 0xA0, 0xDF, 0xB8, 0x16, 0x07, 0xB0, 0xE2, 0x06, 0xC0, 0xE0, 0xAF, 0xD0, 0x17, 0x06, 0xF9,
  0x81, 0xDA, 0xBF, 0x07, 0x70, 0x6F, 0x05, 0x30, 0x20, 0xDD, 0x0B, 0x70, 0x6E, 0x07, 0x50, 0x4D,
  0x0E, 0x70, 0x6E, 0x01, 0x60, 0xED, 0x70, 0x6D, 0x0B, 0x70, 0xDD, 0x70, 0x6D, 0x08, 0x70, 0xCD,
  0x70, 0x6D, 0x07, 0x70, 0xCD, 0x70, 0x6D, 0x06, 0x70, 0xCD, 0x70, 0x6D, 0x06, 0x70, 0xCD, 0x70,
  0x6D, 0x06, 0x70, 0xCD, 0x70, 0x6D, 0x06, 0x70, 0xCD, 0x70, 0x6D, 0x06, 0x70, 0xCD, 0x70, 0x6D,
  0x06, 0x70, 0xCD, 0x70, 0x6D, 0x06, 0x70, 0xCD, 0x70, 0x6D, 0x06, 0x70, 0xCD, 0x70, 0x6D, 0x06,
  0x70, 0xCD, 0x70, 0x6D, 0x06, 0x70, 0xCD, 0x70, 0x6D, 0x06, 0x70, 0xCD,
  // "Ŋ" (U+014A)
  0x03, 0xF0, 0xD7, 0x0E, 0xC0, 0x03, 0xF9, 0x02, 0x60, 0xEC, 0x00, 0x3F, 0x90, 0x86, 0x0E, 0xC0,
  0x03, 0xF9, 0x0D, 0x60, 0xEC, 0x00, 0x3F, 0xA0, 0x25, 0x0E, 0xC0, 0x03, 0xC0, 0xDC, 0x08, 0x50,
  0xEC, 0x00, 0x3C, 0x0A, 0x0E, 0xB0, 0xD5, 0x0E, 0xC0, 0x03, 0xC0, 0xA0, 0x9C, 0x02, 0x40, 0xEC,
  0x00, 0x3C, 0x0B, 0x03, 0xC0, 0x74, 0x0E, 0xC0, 0x03, 0xC8, 0x1C, 0x0E, 0xB0, 0xD4, 0x0E, 0xC0,
  0x03, 0xC8, 0x1D, 0x09, 0xC0, 0x23, 0x0E, 0xC0, 0x03, 0xC8, 0x1D, 0x03, 0xC0, 0x73, 0x0E, 0xC0,
  0x03, 0xC0, 0xE2, 0x0E, 0xB0, 0xD3, 0x0E, 0xC0, 0x03, 0xC0, 0xE2, 0x09, 0xC0, 0x22, 0x0E, 0xC0,
  0x03, 0xC0, 0xE2, 0x03, 0xC0, 0x72, 0x0E, 0xC0, 0x03, 0xC0, 0xE3, 0x0E, 0xB0, 0xD2, 0x0E, 0xC0,
  0x03, 0xC0, 0xE3, 0x09, 0xC8, 0x12, 0x0E, 0xC0, 0x03, 0xC0, 0xE3, 0x04, 0xC8, 0x17, 0x0E, 0xC0,
  0x03, 0xC0, 0xE4, 0x0E, 0xB8, 0x1D, 0x0D, 0xC0, 0x03, 0xC0, 0xE4, 0x09, 0xC0, 0x20, 0xDC, 0x00,
  0x3C, 0x0E, 0x40, 0x4C, 0x07, 0x0C, 0xC0, 0x03, 0xC0, 0xE5, 0x0E, 0xB0, 0xD0, 0xBC, 0x00, 0x3C,
  0x0E, 0x50, 0x9C, 0x0D, 0xC0, 0x03, 0xC0, 0xE5, 0x04, 0xFA, 0x00, 0x3C, 0x0E, 0x60, 0xEF, 0x90,
  0x03, 0xC0, 0xE6, 0x09, 0xF9, 0x00, 0x3C, 0x0E, 0x60, 0x4F, 0x90, 0x03, 0xC0, 0xE7, 0x0E, 0xF0,
  0x37, 0x72, 0x09, 0xC0, 0x27, 0x72, 0x0C, 0xC0, 0x17, 0x71, 0x04, 0xC0, 0xE7, 0x28, 0x12, 0x31,
  0x28, 0x12, 0x7E, 0xC0, 0xB7, 0x20, 0x7F, 0xC0, 0x57, 0x20, 0x7F, 0xB0, 0xB7, 0x30, 0x7F, 0xA0,
  0xB7, 0x40, 0x7F, 0x0D, 0x06, 0x75, 0x86, 0x15, 0x89, 0x98, 0x63, 0x60,
  // "ŋ" (U+014B)
  0x0C, 0xB0, 0xB3, 0x87, 0x38, 0xCE, 0xFE, 0xC8, 0x23, 0x0C, 0xC8, 0x11, 0x09, 0xFA, 0x07, 0x20,
  0xCC, 0x06, 0x0A, 0xFC, 0x81, 0x60, 0xCF, 0xFC, 0x01, 0x0C, 0xF9, 0x81, 0xBA, 0xBF, 0x07, 0x0C,
  0xE0, 0xD0, 0x23, 0x02, 0x0D, 0xD0, 0xB0, 0xCE, 0x02, 0x50, 0x4D, 0x0E, 0x0C, 0xD0, 0xA7, 0x0E,
  0xD0, 0xCD, 0x05, 0x70, 0xDD, 0x0C, 0xD0, 0x27, 0x0C, 0xD0, 0xCD, 0x71, 0x0C, 0xD0, 0xCD, 0x71,
  0x0C, 0xD0, 0xCD, 0x71, 0x0C, 0xD0, 0xCD, 0x71, 0x0C, 0xD0, 0xCD, 0x71, 0x0C, 0xD0, 0xCD, 0x71,
  0x0C, 0xD0, 0xCD, 0x71, 0x0C, 0xD0, 0xCD, 0x71, 0x0C, 0xD0, 0xCD, 0x71, 0x0C, 0xD0, 0xCD, 0x71,
  0x0C, 0xD0, 0xCD, 0x71, 0x0C, 0xD0, 0xCD, 0x71, 0x0C, 0xD7, 0x70, 0xCD, 0x77, 0x0C, 0xD7, 0x70,
  0xEC, 0x0E, 0x76, 0x06, 0xD0, 0xD7, 0x28, 0x27, 0xBA, 0xCE, 0x09, 0x72, 0x08, 0xFA, 0x04, 0x72,
  0x08, 0xF9, 0x0A, 0x73, 0x08, 0xF0, 0xA7, 0x48, 0x65, 0xCE, 0xFE, 0xDA, 0x43,
  // "Ō" (U+014C)
  0x5F, 0xD0, 0x17, 0x2F, 0xD0, 0x17, 0x2F, 0xD0, 0x17, 0x2F, 0xD0, 0x18, 0x09, 0xB6, 0x08, 0x90,
  0x27, 0xBD, 0xEE, 0xDB, 0x72, 0x73, 0x01, 0x0A, 0xFB, 0x0A, 0x01, 0x70, 0x20, 0xEF, 0xD0, 0xE0,
  0x25, 0x01, 0x0D, 0xFF, 0x0D, 0x01, 0x40, 0xAE, 0x82, 0xEB, 0xAE, 0xE0, 0x93, 0x03, 0xE0, 0x74,
  0x07, 0xE0, 0x22, 0x09, 0xD0, 0x86, 0x09, 0xD0, 0x92, 0x0E, 0xD0, 0x16, 0x01, 0xD8, 0x1E, 0x03,
  0xD0, 0xA7, 0x10, 0xBD, 0x03, 0x06, 0xD0, 0x77, 0x10, 0x7D, 0x05, 0x08, 0xD0, 0x47, 0x10, 0x4D,
  0x08, 0x0A, 0xD0, 0x27, 0x10, 0x3D, 0x0A, 0x0B, 0xD0, 0x17, 0x10, 0x2D, 0x00, 0xBD, 0x01, 0x71,
  0x01, 0xD0, 0xB0, 0xCD, 0x01, 0x71, 0x01, 0xD0, 0x0B, 0xD0, 0x17, 0x10, 0x2D, 0x0B, 0x0A, 0xD0,
  0x27, 0x10, 0x3D, 0x0A, 0x08, 0xD0, 0x47, 0x10, 0x4D, 0x08, 0x06, 0xD0, 0x77, 0x10, 0x7D, 0x05,
  0x03, 0xD0, 0xA7, 0x10, 0xBD, 0x81, 0x30, 0xED, 0x01, 0x60, 0x1D, 0x0E, 0x20, 0x9D, 0x08, 0x60,
  0x8D, 0x09, 0x20, 0x3E, 0x07, 0x40, 0x7E, 0x03, 0x30, 0xAE, 0x82, 0xDA, 0xAD, 0xE0, 0x94, 0x01,
  0x0D, 0xFF, 0x0D, 0x01, 0x50, 0x20, 0xEF, 0xD0, 0xE0, 0x27, 0x01, 0x0A, 0xFB, 0x0A, 0x01, 0x73,
  0x89, 0x02, 0x7B, 0xDE, 0xED, 0xB7, 0x26,
  // "ō" (U+014D)
  0x5F, 0xD0, 0x17, 0x2F, 0xD0, 0x17, 0x2F, 0xD0, 0x17, 0x2F, 0xD0, 0x18, 0x09, 0x90, 0x08, 0x90,
  0x27, 0xBD, 0xFE, 0xDB, 0x72, 0x73, 0x01, 0x09, 0xFB, 0x0A, 0x01, 0x70, 0x20, 0xDF, 0xD0, 0xE0,
  0x35, 0x01, 0x0D, 0xFF, 0x0E, 0x02, 0x40, 0xBE, 0x82, 0xEA, 0xAD, 0xE0, 0xC3, 0x03, 0xE0, 0x74,
  0x05, 0xE0, 0x42, 0x0A, 0xD0, 0x86, 0x07, 0xD0, 0xB2, 0x0E, 0xD0, 0x17, 0xD8, 0x1E, 0x02, 0xD0,
  0xB7, 0x10, 0xBD, 0x03, 0x05, 0xD0, 0x97, 0x10, 0x9D, 0x04, 0x05, 0xD0, 0x77, 0x10, 0x7D, 0x05,
  0x06, 0xD0, 0x77, 0x10, 0x7D, 0x00, 0x5D, 0x09, 0x71, 0x09, 0xD0, 0x50, 0x3D, 0x0B, 0x71, 0x0B,
  0xD0, 0x21, 0xE0, 0x17, 0xD0, 0xE2, 0x0B, 0xD0, 0x86, 0x07, 0xD0, 0xA2, 0x04, 0xE0, 0x74, 0x05,
  0xE0, 0x43, 0x0B, 0xE8, 0x2E, 0xAA, 0xDE, 0x0B, 0x40, 0x20, 0xEF, 0xF0, 0xE0, 0x25, 0x03, 0x0E,
  0xFD, 0x0E, 0x03, 0x70, 0x10, 0xAF, 0xB0, 0xB0, 0x17, 0x38, 0x22, 0x8B, 0xEA, 0x82, 0xEB, 0x83,
  0x60,
  // "Ŏ" (U+014E)
  0x48, 0x24, 0x77, 0x66, 0x82, 0x47, 0x76, 0x71, 0x07, 0xA0, 0xE0, 0x15, 0x0C, 0xA0, 0xB7, 0x10,
  0x4B, 0x84, 0xC4, 0x10, 0x3A, 0xB0, 0x77, 0x20, 0xEF, 0xC0, 0x27, 0x20, 0x5F, 0xB0, 0x77, 0x40,
  0x6F, 0x90, 0x87, 0x68, 0x62, 0x9D, 0xEF, 0xD9, 0x38, 0x09, 0x93, 0x08, 0x90, 0x27, 0xBD, 0xEE,
  0xDB, 0x72, 0x73, 0x01, 0x0A, 0xFB, 0x0A, 0x01, 0x70, 0x20, 0xEF, 0xD0, 0xE0, 0x25, 0x01, 0x0D,
  0xFF, 0x0D, 0x01, 0x40, 0xAE, 0x82, 0xEB, 0xAE, 0xE0, 0x93, 0x03, 0xE0, 0x74, 0x07, 0xE0, 0x22,
  0x09, 0xD0, 0x86, 0x09, 0xD0, 0x92, 0x0E, 0xD0, 0x16, 0x01, 0xD8, 0x1E, 0x03, 0xD0, 0xA7, 0x10,
  0xBD, 0x03, 0x06, 0xD0, 0x77, 0x10, 0x7D, 0x05, 0x08, 0xD0, 0x47, 0x10, 0x4D, 0x08, 0x0A, 0xD0,
  0x27, 0x10, 0x3D, 0x0A, 0x0B, 0xD0, 0x17, 0x10, 0x2D, 0x00, 0xBD, 0x01, 0x71, 0x01, 0xD0, 0xB0,
  0xCD, 0x01, 0x71, 0x01, 0xD0, 0x0B, 0xD0, 0x17, 0x10, 0x2D, 0x0B, 0x0A, 0xD0, 0x27, 0x10, 0x3D,
  0x0A, 0x08, 0xD0, 0x47, 0x10, 0x4D, 0x08, 0x06, 0xD0, 0x77, 0x10, 0x7D, 0x05, 0x03, 0xD0, 0xA7,
  0x10, 0xBD, 0x81, 0x30, 0xED, 0x01, 0x60, 0x1D, 0x0E, 0x20, 0x9D, 0x08, 0x60, 0x8D, 0x09, 0x20,
  0x3E, 0x07, 0x40, 0x7E, 0x03, 0x30, 0xAE, 0x82, 0xDA, 0xAD, 0xE0, 0x94, 0x01, 0x0D, 0xFF, 0x0D,
  0x01, 0x50, 0x20, 0xEF, 0xD0, 0xE0, 0x27, 0x01, 0x0A, 0xFB, 0x0A, 0x01, 0x73, 0x89, 0x02, 0x7B,
  0xDE, 0xED, 0xB7, 0x26,
  // "ŏ" (U+014F)
  0x48, 0x24, 0x77, 0x66, 0x82, 0x47, 0x76, 0x71, 0x07, 0xA0, 0xE0, 0x15, 0x0C, 0xA0, 0xB7, 0x10,
  0x4B, 0x84, 0xC4, 0x10, 0x3A, 0xB0, 0x77, 0x20, 0xEF, 0xC0, 0x27, 0x20, 0x5F, 0xB0, 0x77, 0x40,
  0x6F, 0x90, 0x87, 0x68, 0x62, 0x9D, 0xEF, 0xD9, 0x38, 0x0E, 0x50, 0x89, 0x02, 0x7B, 0xDF, 0xED,
  0xB7, 0x27, 0x30, 0x10, 0x9F, 0xB0, 0xA0, 0x17, 0x02, 0x0D, 0xFD, 0x0E, 0x03, 0x50, 0x10, 0xDF,
  0xF0, 0xE0, 0x24, 0x0B, 0xE8, 0x2E, 0xAA, 0xDE, 0x0C, 0x30, 0x3E, 0x07, 0x40, 0x5E, 0x04, 0x20,
  0xAD, 0x08, 0x60, 0x7D, 0x0B, 0x20, 0xED, 0x01, 0x7D, 0x81, 0xE0, 0x2D, 0x0B, 0x71, 0x0B, 0xD0,
  0x30, 0x5D, 0x09, 0x71, 0x09, 0xD0, 0x40, 0x5D, 0x07, 0x71, 0x07, 0xD0, 0x50, 0x6D, 0x07, 0x71,
  0x07, 0xD0, 0x05, 0xD0, 0x97, 0x10, 0x9D, 0x05, 0x03, 0xD0, 0xB7, 0x10, 0xBD, 0x02, 0x1E, 0x01,
  0x7D, 0x0E, 0x20, 0xBD, 0x08, 0x60, 0x7D, 0x0A, 0x20, 0x4E, 0x07, 0x40, 0x5E, 0x04, 0x30, 0xBE,
  0x82, 0xEA, 0xAD, 0xE0, 0xB4, 0x02, 0x0E, 0xFF, 0x0E, 0x02, 0x50, 0x30, 0xEF, 0xD0, 0xE0, 0x37,
  0x01, 0x0A, 0xFB, 0x0B, 0x01, 0x73, 0x82, 0x28, 0xBE, 0xA8, 0x2E, 0xB8, 0x36,
  // "Ő" (U+0150)
  0x60, 0x4D, 0x03, 0x02, 0xD0, 0x57, 0x10, 0xCC, 0x81, 0x70, 0xAC, 0x0A, 0x71, 0x07, 0xC8, 0x18,
  0x04, 0xC0, 0xA7, 0x10, 0x2C, 0x07, 0x20, 0xDB, 0x09, 0x72, 0x0B, 0xB0, 0x52, 0x09, 0xB0, 0x87,
  0x20, 0x5A, 0x0D, 0x03, 0x20, 0x2A, 0x0E, 0x05, 0x80, 0x99, 0x30, 0x89, 0x02, 0x7B, 0xDE, 0xED,
  0xB7, 0x27, 0x30, 0x10, 0xAF, 0xB0, 0xA0, 0x17, 0x02, 0x0E, 0xFD, 0x0E, 0x02, 0x50, 0x10, 0xDF,
  0xF0, 0xD0, 0x14, 0x0A, 0xE8, 0x2E, 0xBA, 0xEE, 0x09, 0x30, 0x3E, 0x07, 0x40, 0x7E, 0x02, 0x20,
  0x9D, 0x08, 0x60, 0x9D, 0x09, 0x20, 0xED, 0x01, 0x60, 0x1D, 0x81, 0xE0, 0x3D, 0x0A, 0x71, 0x0B,
  0xD0, 0x30, 0x6D, 0x07, 0x71, 0x07, 0xD0, 0x50, 0x8D, 0x04, 0x71, 0x04, 0xD0, 0x80, 0xAD, 0x02,
  0x71, 0x03, 0xD0, 0xA0, 0xBD, 0x01, 0x71, 0x02, 0xD0, 0x0B, 0xD0, 0x17, 0x10, 0x1D, 0x0B, 0x0C,
  0xD0, 0x17, 0x10, 0x1D, 0x00, 0xBD, 0x01, 0x71, 0x02, 0xD0, 0xB0, 0xAD, 0x02, 0x71, 0x03, 0xD0,
  0xA0, 0x8D, 0x04, 0x71, 0x04, 0xD0, 0x80, 0x6D, 0x07, 0x71, 0x07, 0xD0, 0x50, 0x3D, 0x0A, 0x71,
  0x0B, 0xD8, 0x13, 0x0E, 0xD0, 0x16, 0x01, 0xD0, 0xE2, 0x09, 0xD0, 0x86, 0x08, 0xD0, 0x92, 0x03,
  0xE0, 0x74, 0x07, 0xE0, 0x33, 0x0A, 0xE8, 0x2D, 0xAA, 0xDE, 0x09, 0x40, 0x10, 0xDF, 0xF0, 0xD0,
  0x15, 0x02, 0x0E, 0xFD, 0x0E, 0x02, 0x70, 0x10, 0xAF, 0xB0, 0xA0, 0x17, 0x38, 0x90, 0x27, 0xBD,
  0xEE, 0xDB, 0x72, 0x60,
  // "ő" (U+0151)
  0x60, 0x4D, 0x03, 0x02, 0xD0, 0x57, 0x10, 0xCC, 0x81, 0x70, 0xAC, 0x0A, 0x71, 0x07, 0xC8, 0x18,
  0x04, 0xC0, 0xA7, 0x10, 0x2C, 0x07, 0x20, 0xDB, 0x09, 0x72, 0x0B, 0xB0, 0x52, 0x09, 0xB0, 0x87,
  0x20, 0x5A, 0x0D, 0x03, 0x20, 0x2A, 0x0E, 0x05, 0x80, 0xE5, 0x08, 0x90, 0x27, 0xBD, 0xFE, 0xDB,
  0x72, 0x73, 0x01, 0x09, 0xFB, 0x0A, 0x01, 0x70, 0x20, 0xDF, 0xD0, 0xE0, 0x35, 0x01, 0x0D, 0xFF,
  0x0E, 0x02, 0x40, 0xBE, 0x82, 0xEA, 0xAD, 0xE0, 0xC3, 0x03, 0xE0, 0x74, 0x05, 0xE0, 0x42, 0x0A,
  0xD0, 0x86, 0x07, 0xD0, 0xB2, 0x0E, 0xD0, 0x17, 0xD8, 0x1E, 0x02, 0xD0, 0xB7, 0x10, 0xBD, 0x03,
  0x05, 0xD0, 0x97, 0x10, 0x9D, 0x04, 0x05, 0xD0, 0x77, 0x10, 0x7D, 0x05, 0x06, 0xD0, 0x77, 0x10,
  0x7D, 0x00, 0x5D, 0x09, 0x71, 0x09, 0xD0, 0x50, 0x3D, 0x0B, 0x71, 0x0B, 0xD0, 0x21, 0xE0, 0x17,
  0xD0, 0xE2, 0x0B, 0xD0, 0x86, 0x07, 0xD0, 0xA2, 0x04, 0xE0, 0x74, 0x05, 0xE0, 0x43, 0x0B, 0xE8,
  0x2E, 0xAA, 0xDE, 0x0B, 0x40, 0x20, 0xEF, 0xF0, 0xE0, 0x25, 0x03, 0x0E, 0xFD, 0x0E, 0x03, 0x70,
  0x10, 0xAF, 0xB0, 0xB0, 0x17, 0x38, 0x22, 0x8B, 0xEA, 0x82, 0xEB, 0x83, 0x60,
  // "Œ" (U+0152)
  0x58, 0x23, 0x9C, 0xEF, 0xE0, 0x34, 0x09, 0xFF, 0xB0, 0x33, 0x0B, 0xFF, 0xC0, 0x32, 0x07, 0xFF,
  0xD8, 0x13, 0x01, 0xE8, 0x2E, 0xAA, 0xEC, 0x0D, 0x80, 0x19, 0x81, 0x20, 0x7D, 0x0B, 0x30, 0xBC,
  0x0B, 0x70, 0xDD, 0x01, 0x30, 0xBC, 0x0B, 0x60, 0x1D, 0x0A, 0x40, 0xBC, 0x0B, 0x60, 0x5D, 0x05,
  0x40, 0xBC, 0x0B, 0x60, 0x7D, 0x02, 0x40, 0xBC, 0x0B, 0x60, 0x9D, 0x50, 0xBC, 0x86, 0xD9, 0x99,
  0x94, 0x0B, 0xC0, 0xE5, 0x0B, 0xFA, 0x81, 0x70, 0xBC, 0x0E, 0x50, 0xBF, 0xA8, 0x17, 0x0C, 0xC0,
  0xD5, 0x0B, 0xFA, 0x81, 0x70, 0xCC, 0x0D, 0x50, 0xBF, 0xA8, 0x17, 0x0B, 0xC0, 0xE5, 0x0B, 0xC0,
  0xB6, 0x0A, 0xC0, 0xE5, 0x0B, 0xC0, 0xB6, 0x09, 0xD5, 0x0B, 0xC0, 0xB6, 0x07, 0xD0, 0x24, 0x0B,
  0xC0, 0xB6, 0x05, 0xD0, 0x44, 0x0B, 0xC0, 0xB6, 0x02, 0xD0, 0x84, 0x0B, 0xC0, 0xB7, 0x0D, 0xC0,
  0xD4, 0x0B, 0xC0, 0xB7, 0x08, 0xD0, 0x93, 0x0B, 0xC0, 0xB7, 0x02, 0xE8, 0x2D, 0xAA, 0xEC, 0x0D,
  0x80, 0x19, 0x02, 0x20, 0x8F, 0xFD, 0x03, 0x30, 0xCF, 0xFC, 0x03, 0x30, 0x10, 0xAF, 0xFB, 0x03,
  0x58, 0x24, 0x9D, 0xEF, 0xE0, 0x30,
  // "œ" (U+0153)
  0x48, 0x52, 0x9D, 0xFD, 0xA3, 0x38, 0x51, 0x8D, 0xFD, 0x92, 0x60, 0x5F, 0x82, 0x60, 0x2D, 0xD0,
  0xE0, 0x34, 0x03, 0xFA, 0x04, 0x0C, 0xF0, 0xE0, 0x13, 0x0C, 0xFF, 0xD0, 0x82, 0x04, 0xC8, 0x19,
  0x04, 0xE8, 0x2E, 0x40, 0x9B, 0x0D, 0x20, 0x9C, 0x01, 0x20, 0x8D, 0x05, 0x3C, 0x81, 0x30, 0xDB,
  0x0C, 0x30, 0x3D, 0x40, 0xCB, 0x05, 0x1C, 0x09, 0x4C, 0x0E, 0x40, 0xBB, 0x07, 0x02, 0xC0, 0x84,
  0x0E, 0xFD, 0x08, 0x03, 0xC0, 0x74, 0x0D, 0xFD, 0x09, 0x04, 0xC0, 0x64, 0x0C, 0xFD, 0x09, 0x03,
  0xC0, 0x64, 0x0C, 0xFD, 0x09, 0x02, 0xC0, 0x74, 0x0D, 0xB0, 0xD7, 0x20, 0x1C, 0x08, 0x40, 0xEB,
  0x0E, 0x73, 0x0E, 0xB0, 0x94, 0xD0, 0x17, 0x20, 0xBB, 0x0C, 0x30, 0x3D, 0x05, 0x72, 0x08, 0xC0,
  0x12, 0x08, 0xD0, 0xC6, 0x04, 0x20, 0x3C, 0x81, 0xA0, 0x4F, 0x84, 0xB3, 0x01, 0x5B, 0x93, 0x0B,
  0xFF, 0xE3, 0x02, 0xFA, 0x04, 0x0B, 0xFA, 0x40, 0x40, 0xEE, 0x82, 0x60, 0x1D, 0xF0, 0xC5, 0x85,
  0x29, 0xDF, 0xDA, 0x33, 0x86, 0x17, 0xCE, 0xED, 0x94, 0x20,
  // "Ŕ" (U+0154)
  0x72, 0x02, 0x80, 0x27, 0x01, 0x76, 0x0B, 0xD0, 0xA7, 0x60, 0x5D, 0x0A, 0x76, 0x01, 0x0E, 0xC0,
  0x97, 0x70, 0xAC, 0x09, 0x77, 0x06, 0xC0, 0x77, 0x71, 0x0E, 0xB0, 0x58, 0x09, 0x85, 0x00, 0xCF,
  0x83, 0xEE, 0xC9, 0x57, 0x10, 0xCF, 0xD0, 0xE0, 0x76, 0x0C, 0xFF, 0x0C, 0x01, 0x40, 0xCF, 0xF9,
  0x0B, 0x40, 0xCD, 0x82, 0x9A, 0xAC, 0xF0, 0x63, 0x0C, 0xD4, 0x02, 0x0B, 0xD0, 0xC3, 0x0C, 0xD6,
  0x0E, 0xD3, 0x0C, 0xD6, 0x0A, 0xD0, 0x22, 0x0C, 0xD6, 0x09, 0xD0, 0x32, 0x0C, 0xD6, 0x0B, 0xD0,
  0x22, 0x0C, 0xD5, 0x02, 0xD0, 0xE3, 0x0C, 0xD4, 0x03, 0x0D, 0xD0, 0xA3, 0x0C, 0xD8, 0x29, 0x9A,
  0xDF, 0x02, 0x30, 0xCF, 0xF9, 0x05, 0x40, 0xCF, 0xF0, 0x65, 0x0C, 0xFD, 0x0C, 0x02, 0x60, 0xCF,
  0xD0, 0xC7, 0x0C, 0xD2, 0x07, 0xD0, 0x66, 0x0C, 0xD3, 0x0D, 0xC0, 0xE6, 0x0C, 0xD3, 0x05, 0xD0,
  0x85, 0x0C, 0xD4, 0x0C, 0xD0, 0x24, 0x0C, 0xD4, 0x04, 0xD0, 0xA4, 0x0C, 0xD5, 0x0B, 0xD0, 0x33,
  0x0C, 0xD5, 0x03, 0xD0, 0xC3, 0x0C, 0xD6, 0x0A, 0xD0, 0x62, 0x0C, 0xD6, 0x02, 0xD0, 0xE2, 0x0C,
  0xD7, 0x09, 0xD8, 0x18, 0x0C, 0xD7, 0x01, 0x0E, 0xD0, 0x20,
  // "ŕ" (U+0155)
  0x75, 0x02, 0x80, 0x27, 0x01, 0x77, 0x10, 0xBD, 0x0A, 0x77, 0x10, 0x5D, 0x0A, 0x77, 0x10, 0x10,
  0xEC, 0x09, 0x77, 0x20, 0xAC, 0x09, 0x77, 0x20, 0x6C, 0x07, 0x77, 0x30, 0xEB, 0x05, 0x80, 0xE4,
  0x00, 0x4F, 0x90, 0xC4, 0x81, 0x6B, 0xEA, 0x83, 0xDB, 0x20, 0x4F, 0xA2, 0x01, 0x0C, 0xF2, 0x04,
  0xFA, 0x81, 0x30, 0xCF, 0x0B, 0x20, 0x4F, 0xA0, 0x60, 0x9F, 0x90, 0x82, 0x03, 0x0E, 0xF9, 0x0D,
  0xFA, 0x04, 0x48, 0x21, 0x46, 0xDF, 0xF7, 0x10, 0xAF, 0x85, 0xC5, 0x10, 0x13, 0x57, 0x10, 0xAE,
  0x0A, 0x77, 0x10, 0xAD, 0x0E, 0x01, 0x77, 0x10, 0xAD, 0x08, 0x77, 0x20, 0xAD, 0x04, 0x77, 0x20,
  0xAD, 0x02, 0x77, 0x20, 0xAD, 0x01, 0x77, 0x20, 0xAD, 0x01, 0x77, 0x20, 0xAD, 0x01, 0x77, 0x20,
  0xAD, 0x01, 0x77, 0x20, 0xAD, 0x01, 0x77, 0x81, 0x36, 0xDD, 0x81, 0x95, 0x17, 0x18, 0x12, 0x9C,
  0xFD, 0x81, 0xEB, 0x75, 0x05, 0xFF, 0xA0, 0xD5, 0x05, 0xFF, 0xA0, 0xD5, 0x05, 0xFF, 0xA0, 0xD5,
  // "Ŗ" (U+0156)
  0x0C, 0xF8, 0x3E, 0xEC, 0x95, 0x71, 0x0C, 0xFD, 0x0E, 0x07, 0x60, 0xCF, 0xF0, 0xC0, 0x14, 0x0C,
  0xFF, 0x90, 0xB4, 0x0C, 0xD8, 0x29, 0xAA, 0xCF, 0x06, 0x30, 0xCD, 0x40, 0x20, 0xBD, 0x0C, 0x30,
  0xCD, 0x60, 0xED, 0x30, 0xCD, 0x60, 0xAD, 0x02, 0x20, 0xCD, 0x60, 0x9D, 0x03, 0x20, 0xCD, 0x60,
  0xBD, 0x02, 0x20, 0xCD, 0x50, 0x2D, 0x0E, 0x30, 0xCD, 0x40, 0x30, 0xDD, 0x0A, 0x30, 0xCD, 0x82,
  0x99, 0xAD, 0xF0, 0x23, 0x0C, 0xFF, 0x90, 0x54, 0x0C, 0xFF, 0x06, 0x50, 0xCF, 0xD0, 0xC0, 0x26,
  0x0C, 0xFD, 0x0C, 0x70, 0xCD, 0x20, 0x7D, 0x06, 0x60, 0xCD, 0x30, 0xDC, 0x0E, 0x60, 0xCD, 0x30,
  0x5D, 0x08, 0x50, 0xCD, 0x40, 0xCD, 0x02, 0x40, 0xCD, 0x40, 0x4D, 0x0A, 0x40, 0xCD, 0x50, 0xBD,
  0x03, 0x30, 0xCD, 0x50, 0x3D, 0x0C, 0x30, 0xCD, 0x60, 0xAD, 0x06, 0x20, 0xCD, 0x60, 0x2D, 0x0E,
  0x20, 0xCD, 0x70, 0x9D, 0x81, 0x80, 0xCD, 0x70, 0x10, 0xED, 0x02, 0x80, 0x98, 0x20, 0x0C, 0xC0,
  0x87, 0x71, 0x0E, 0xC0, 0x17, 0x70, 0x3C, 0x08, 0x77, 0x10, 0x6B, 0x0E, 0x01, 0x77, 0x10, 0xAB,
  0x05, 0x77, 0x20, 0xEA, 0x0A, 0x74,
  // "ŗ" (U+0157)
  0x10, 0x4F, 0x90, 0xC4, 0x81, 0x6B, 0xEA, 0x83, 0xDB, 0x20, 0x4F, 0xA2, 0x01, 0x0C, 0xF2, 0x04,
  0xFA, 0x81, 0x30, 0xCF, 0x0B, 0x20, 0x4F, 0xA0, 0x60, 0x9F, 0x90, 0x82, 0x03, 0x0E, 0xF9, 0x0D,
  0xFA, 0x04, 0x48, 0x21, 0x46, 0xDF, 0xF7, 0x10, 0xAF, 0x85, 0xC5, 0x10, 0x13, 0x57, 0x10, 0xAE,
  0x0A, 0x77, 0x10, 0xAD, 0x0E, 0x01, 0x77, 0x10, 0xAD, 0x08, 0x77, 0x20, 0xAD, 0x04, 0x77, 0x20,
  0xAD, 0x02, 0x77, 0x20, 0xAD, 0x01, 0x77, 0x20, 0xAD, 0x01, 0x77, 0x20, 0xAD, 0x01, 0x77, 0x20,
  0xAD, 0x01, 0x77, 0x20, 0xAD, 0x01, 0x77, 0x81, 0x36, 0xDD, 0x81, 0x95, 0x17, 0x18, 0x12, 0x9C,
  0xFD, 0x81, 0xEB, 0x75, 0x05, 0xFF, 0xA0, 0xD5, 0x05, 0xFF, 0xA0, 0xD5, 0x05, 0xFF, 0xA0, 0xD8,
  0x09, 0x94, 0x00, 0xCC, 0x08, 0x77, 0x30, 0xEC, 0x01, 0x77, 0x20, 0x3C, 0x08, 0x77, 0x30, 0x6B,
  0x0E, 0x01, 0x77, 0x30, 0xAB, 0x05, 0x77, 0x40, 0xEA, 0x0A, 0x77,
  // "Ř" (U+0158)
  0x18, 0x32, 0x77, 0x74, 0x68, 0x34, 0x77, 0x72, 0x50, 0x10, 0xDB, 0x07, 0x40, 0x7B, 0x0D, 0x01,
  0x60, 0x20, 0xEB, 0x08, 0x20, 0xAB, 0x0E, 0x02, 0x71, 0x05, 0xC0, 0x80, 0xAC, 0x05, 0x73, 0x09,
  0xF9, 0x09, 0x75, 0x0D, 0xE0, 0xD7, 0x60, 0x3E, 0x03, 0x80, 0x98, 0x30, 0x0C, 0xF8, 0x3E, 0xEC,
  0x95, 0x71, 0x0C, 0xFD, 0x0E, 0x07, 0x60, 0xCF, 0xF0, 0xC0, 0x14, 0x0C, 0xFF, 0x90, 0xB4, 0x0C,
  0xD8, 0x29, 0xAA, 0xCF, 0x06, 0x30, 0xCD, 0x40, 0x20, 0xBD, 0x0C, 0x30, 0xCD, 0x60, 0xED, 0x30,
  0xCD, 0x60, 0xAD, 0x02, 0x20, 0xCD, 0x60, 0x9D, 0x03, 0x20, 0xCD, 0x60, 0xBD, 0x02, 0x20, 0xCD,
  0x50, 0x2D, 0x0E, 0x30, 0xCD, 0x40, 0x30, 0xDD, 0x0A, 0x30, 0xCD, 0x82, 0x99, 0xAD, 0xF0, 0x23,
  0x0C, 0xFF, 0x90, 0x54, 0x0C, 0xFF, 0x06, 0x50, 0xCF, 0xD0, 0xC0, 0x26, 0x0C, 0xFD, 0x0C, 0x70,
  0xCD, 0x20, 0x7D, 0x06, 0x60, 0xCD, 0x30, 0xDC, 0x0E, 0x60, 0xCD, 0x30, 0x5D, 0x08, 0x50, 0xCD,
  0x40, 0xCD, 0x02, 0x40, 0xCD, 0x40, 0x4D, 0x0A, 0x40, 0xCD, 0x50, 0xBD, 0x03, 0x30, 0xCD, 0x50,
  0x3D, 0x0C, 0x30, 0xCD, 0x60, 0xAD, 0x06, 0x20, 0xCD, 0x60, 0x2D, 0x0E, 0x20, 0xCD, 0x70, 0x9D,
  0x81, 0x80, 0xCD, 0x70, 0x10, 0xED, 0x02,
  // "ř" (U+0159)
  0x48, 0x32, 0x77, 0x74, 0x68, 0x34, 0x77, 0x72, 0x70, 0x10, 0xDB, 0x07, 0x40, 0x7B, 0x0D, 0x01,
  0x71, 0x02, 0x0E, 0xB0, 0x82, 0x0A, 0xB0, 0xE0, 0x27, 0x30, 0x5C, 0x08, 0x0A, 0xC0, 0x57, 0x50,
  0x9F, 0x90, 0x97, 0x70, 0xDE, 0x0D, 0x77, 0x10, 0x3E, 0x03, 0x80, 0xE2, 0x00, 0x4F, 0x90, 0xC4,
  0x81, 0x6B, 0xEA, 0x83, 0xDB, 0x20, 0x4F, 0xA2, 0x01, 0x0C, 0xF2, 0x04, 0xFA, 0x81, 0x30, 0xCF,
  0x0B, 0x20, 0x4F, 0xA0, 0x60, 0x9F, 0x90, 0x82, 0x03, 0x0E, 0xF9, 0x0D, 0xFA, 0x04, 0x48, 0x21,
  0x46, 0xDF, 0xF7, 0x10, 0xAF, 0x85, 0xC5, 0x10, 0x13, 0x57, 0x10, 0xAE, 0x0A, 0x77, 0x10, 0xAD,
  0x0E, 0x01, 0x77, 0x10, 0xAD, 0x08, 0x77, 0x20, 0xAD, 0x04, 0x77, 0x20, 0xAD, 0x02, 0x77, 0x20,
  0xAD, 0x01, 0x77, 0x20, 0xAD, 0x01, 0x77, 0x20, 0xAD, 0x01, 0x77, 0x20, 0xAD, 0x01, 0x77, 0x20,
  0xAD, 0x01, 0x77, 0x81, 0x36, 0xDD, 0x81, 0x95, 0x17, 0x18, 0x12, 0x9C, 0xFD, 0x81, 0xEB, 0x75,
  0x05, 0xFF, 0xA0, 0xD5, 0x05, 0xFF, 0xA0, 0xD5, 0x05, 0xFF, 0xA0, 0xD5,
  // "Ś" (U+015A)
  0x74, 0x02, 0x80, 0x27, 0x01, 0x75, 0x0B, 0xD0, 0xA7, 0x50, 0x5D, 0x0A, 0x75, 0x01, 0x0E, 0xC0,
  0x97, 0x60, 0xAC, 0x09, 0x76, 0x06, 0xC0, 0x77, 0x70, 0xEB, 0x05, 0x80, 0x98, 0x40, 0x89, 0x21,
  0x6A, 0xDE, 0xFE, 0xDC, 0xA6, 0x37, 0x08, 0xFD, 0x81, 0xD7, 0x12, 0x01, 0x0C, 0xFF, 0x0E, 0x30,
  0xAF, 0xF9, 0x08, 0x20, 0x2F, 0x83, 0xCA, 0xAB, 0xEC, 0x02, 0x20, 0x6D, 0x0E, 0x03, 0x58, 0x23,
  0x7D, 0xB3, 0x08, 0xD0, 0x77, 0x20, 0x13, 0x09, 0xD0, 0x57, 0x60, 0x7D, 0x06, 0x76, 0x04, 0xD0,
  0xD0, 0x27, 0x60, 0xDD, 0x0E, 0x06, 0x75, 0x04, 0xF0, 0xD0, 0x67, 0x40, 0x6F, 0x90, 0xE0, 0x67,
  0x30, 0x50, 0xEF, 0x90, 0xD0, 0x57, 0x20, 0x10, 0xAF, 0xA0, 0xB0, 0x17, 0x20, 0x30, 0xBF, 0x90,
  0xE0, 0x27, 0x30, 0x40, 0xBF, 0x0C, 0x75, 0x03, 0x0C, 0xE0, 0x57, 0x60, 0xBD, 0x09, 0x76, 0x04,
  0xD0, 0xB7, 0x60, 0x2D, 0x81, 0xB2, 0x67, 0x40, 0x5D, 0x85, 0xA3, 0xFE, 0x95, 0x16, 0x04, 0x0E,
  0xD0, 0x60, 0x3D, 0x84, 0xDB, 0xAA, 0xBE, 0xE8, 0x1E, 0x13, 0xFF, 0xB8, 0x15, 0x03, 0xFF, 0xA0,
  0x72, 0x81, 0x19, 0xEF, 0xD0, 0xB0, 0x36, 0x83, 0x48, 0xAD, 0xEA, 0x83, 0xDC, 0xA6, 0x25,
  // "ś" (U+015B)
  0x72, 0x02, 0x80, 0x27, 0x01, 0x73, 0x0B, 0xD0, 0xA7, 0x30, 0x5D, 0x0A, 0x73, 0x01, 0x0E, 0xC0,
  0x97, 0x40, 0xAC, 0x09, 0x74, 0x06, 0xC0, 0x77, 0x50, 0xEB, 0x05, 0x80, 0xD3, 0x08, 0x92, 0x48,
  0xBD, 0xEF, 0xED, 0xB8, 0x51, 0x40, 0x30, 0xCF, 0xD8, 0x2B, 0x50, 0x4F, 0xF9, 0x81, 0x61, 0xEF,
  0xF8, 0x1E, 0x06, 0xE8, 0x3C, 0xAA, 0xBD, 0xC8, 0x19, 0x09, 0xD0, 0x76, 0x84, 0x48, 0xD2, 0x09,
  0xD0, 0x67, 0x40, 0x7D, 0x0E, 0x06, 0x73, 0x02, 0xF8, 0x1E, 0x94, 0x71, 0x08, 0xFA, 0x81, 0xE8,
  0x16, 0x08, 0xFC, 0x09, 0x01, 0x50, 0x20, 0xAF, 0xB0, 0xD0, 0x26, 0x81, 0x18, 0xEF, 0x90, 0xD7,
  0x20, 0x40, 0xBF, 0x06, 0x73, 0x02, 0x0C, 0xD0, 0x90, 0x37, 0x30, 0x3D, 0x84, 0xBC, 0xE9, 0x41,
  0x60, 0x7D, 0x0B, 0x0C, 0xC8, 0x4E, 0xBA, 0xAA, 0xDE, 0x08, 0x0C, 0xFF, 0xA0, 0x20, 0xCF, 0xF9,
  0x81, 0x70, 0xBF, 0xE0, 0xD0, 0x53, 0x84, 0x26, 0x9C, 0xDE, 0xA8, 0x3E, 0xDB, 0x84, 0x40,
  // "Ŝ" (U+015C)
  0x71, 0x80, 0x27, 0x01, 0x75, 0x06, 0xE0, 0xA7, 0x40, 0x20, 0xEF, 0x05, 0x73, 0x0C, 0xC0, 0xDB,
  0x0E, 0x02, 0x71, 0x09, 0xB8, 0x2E, 0x41, 0xDB, 0x0C, 0x70, 0x6B, 0x0E, 0x03, 0x20, 0x10, 0xCB,
  0x0A, 0x50, 0x2B, 0x0C, 0x02, 0x50, 0xAB, 0x05, 0x80, 0xF6, 0x08, 0x92, 0x16, 0xAD, 0xEF, 0xED,
  0xCA, 0x63, 0x70, 0x8F, 0xD8, 0x1D, 0x71, 0x20, 0x10, 0xCF, 0xF0, 0xE3, 0x0A, 0xFF, 0x90, 0x82,
  0x02, 0xF8, 0x3C, 0xAA, 0xBE, 0xC0, 0x22, 0x06, 0xD0, 0xE0, 0x35, 0x82, 0x37, 0xDB, 0x30, 0x8D,
  0x07, 0x72, 0x01, 0x30, 0x9D, 0x05, 0x76, 0x07, 0xD0, 0x67, 0x60, 0x4D, 0x0D, 0x02, 0x76, 0x0D,
  0xD0, 0xE0, 0x67, 0x50, 0x4F, 0x0D, 0x06, 0x74, 0x06, 0xF9, 0x0E, 0x06, 0x73, 0x05, 0x0E, 0xF9,
  0x0D, 0x05, 0x72, 0x01, 0x0A, 0xFA, 0x0B, 0x01, 0x72, 0x03, 0x0B, 0xF9, 0x0E, 0x02, 0x73, 0x04,
  0x0B, 0xF0, 0xC7, 0x50, 0x30, 0xCE, 0x05, 0x76, 0x0B, 0xD0, 0x97, 0x60, 0x4D, 0x0B, 0x76, 0x02,
  0xD8, 0x1B, 0x26, 0x74, 0x05, 0xD8, 0x5A, 0x3F, 0xE9, 0x51, 0x60, 0x40, 0xED, 0x06, 0x03, 0xD8,
  0x4D, 0xBA, 0xAB, 0xEE, 0x81, 0xE1, 0x3F, 0xFB, 0x81, 0x50, 0x3F, 0xFA, 0x07, 0x28, 0x11, 0x9E,
  0xFD, 0x0B, 0x03, 0x68, 0x34, 0x8A, 0xDE, 0xA8, 0x3D, 0xCA, 0x62, 0x50,
  // "ŝ" (U+015D)
  0x68, 0x02, 0x70, 0x17, 0x30, 0x6E, 0x0A, 0x72, 0x02, 0x0E, 0xF0, 0x57, 0x10, 0xCC, 0x0D, 0xB0,
  0xE0, 0x26, 0x09, 0xB8, 0x2E, 0x41, 0xDB, 0x0C, 0x50, 0x6B, 0x0E, 0x03, 0x20, 0x10, 0xCB, 0x0A,
  0x30, 0x2B, 0x0C, 0x02, 0x50, 0xAB, 0x05, 0x80, 0xC5, 0x08, 0x92, 0x48, 0xBD, 0xEF, 0xED, 0xB8,
  0x51, 0x40, 0x30, 0xCF, 0xD8, 0x2B, 0x50, 0x4F, 0xF9, 0x81, 0x61, 0xEF, 0xF8, 0x1E, 0x06, 0xE8,
  0x3C, 0xAA, 0xBD, 0xC8, 0x19, 0x09, 0xD0, 0x76, 0x84, 0x48, 0xD2, 0x09, 0xD0, 0x67, 0x40, 0x7D,
  0x0E, 0x06, 0x73, 0x02, 0xF8, 0x1E, 0x94, 0x71, 0x08, 0xFA, 0x81, 0xE8, 0x16, 0x08, 0xFC, 0x09,
  0x01, 0x50, 0x20, 0xAF, 0xB0, 0xD0, 0x26, 0x81, 0x18, 0xEF, 0x90, 0xD7, 0x20, 0x40, 0xBF, 0x06,
  0x73, 0x02, 0x0C, 0xD0, 0x90, 0x37, 0x30, 0x3D, 0x84, 0xBC, 0xE9, 0x41, 0x60, 0x7D, 0x0B, 0x0C,
  0xC8, 0x4E, 0xBA, 0xAA, 0xDE, 0x08, 0x0C, 0xFF, 0xA0, 0x20, 0xCF, 0xF9, 0x81, 0x70, 0xBF, 0xE0,
  0xD0, 0x53, 0x84, 0x26, 0x9C, 0xDE, 0xA8, 0x3E, 0xDB, 0x84, 0x40,
  // "Ş" (U+015E)
  0x58, 0x92, 0x16, 0xAD, 0xEF, 0xED, 0xCA, 0x63, 0x70, 0x8F, 0xD8, 0x1D, 0x71, 0x20, 0x10, 0xCF,
  0xF0, 0xE3, 0x0A, 0xFF, 0x90, 0x82, 0x02, 0xF8, 0x3C, 0xAA, 0xBE, 0xC0, 0x22, 0x06, 0xD0, 0xE0,
  0x35, 0x82, 0x37, 0xDB, 0x30, 0x8D, 0x07, 0x72, 0x01, 0x30, 0x9D, 0x05, 0x76, 0x07, 0xD0, 0x67,
  0x60, 0x4D, 0x0D, 0x02, 0x76, 0x0D, 0xD0, 0xE0, 0x67, 0x50, 0x4F, 0x0D, 0x06, 0x74, 0x06, 0xF9,
  0x0E, 0x06, 0x73, 0x05, 0x0E, 0xF9, 0x0D, 0x05, 0x72, 0x01, 0x0A, 0xFA, 0x0B, 0x01, 0x72, 0x03,
  0x0B, 0xF9, 0x0E, 0x02, 0x73, 0x04, 0x0B, 0xF0, 0xC7, 0x50, 0x30, 0xCE, 0x05, 0x76, 0x0B, 0xD0,
  0x97, 0x60, 0x4D, 0x0B, 0x76, 0x02, 0xD8, 0x1B, 0x26, 0x74, 0x05, 0xD8, 0x5A, 0x3F, 0xE9, 0x51,
  0x60, 0x40, 0xED, 0x06, 0x03, 0xD8, 0x4D, 0xBA, 0xAB, 0xEE, 0x81, 0xE1, 0x3F, 0xFB, 0x81, 0x50,
  0x3F, 0xFA, 0x07, 0x28, 0x11, 0x9E, 0xFD, 0x0B, 0x03, 0x68, 0x34, 0x8A, 0xDE, 0xC8, 0x1A, 0x62,
  0x76, 0x0C, 0xA0, 0x47, 0x71, 0x03, 0xB0, 0xB0, 0x47, 0x70, 0x80, 0xEC, 0x07, 0x77, 0x10, 0x6C,
  0x01, 0x77, 0x10, 0xDB, 0x04, 0x74, 0x01, 0x20, 0x4C, 0x04, 0x74, 0x90, 0xEE, 0x01, 0x74, 0xF0,
  0x67, 0x50, 0xB0, 0xEA, 0x81, 0xDA, 0x37,
  // "ş" (U+015F)
  0x48, 0x92, 0x48, 0xBD, 0xEF, 0xED, 0xB8, 0x51, 0x40, 0x30, 0xCF, 0xD8, 0x2B, 0x50, 0x4F, 0xF9,
  0x81, 0x61, 0xEF, 0xF8, 0x1E, 0x06, 0xE8, 0x3C, 0xAA, 0xBD, 0xC8, 0x19, 0x09, 0xD0, 0x76, 0x84,
  0x48, 0xD2, 0x09, 0xD0, 0x67, 0x40, 0x7D, 0x0E, 0x06, 0x73, 0x02, 0xF8, 0x1E, 0x94, 0x71, 0x08,
  0xFA, 0x81, 0xE8, 0x16, 0x08, 0xFC, 0x09, 0x01, 0x50, 0x20, 0xAF, 0xB0, 0xD0, 0x26, 0x81, 0x18,
  0xEF, 0x90, 0xD7, 0x20, 0x40, 0xBF, 0x06, 0x73, 0x02, 0x0C, 0xD0, 0x90, 0x37, 0x30, 0x3D, 0x84,
  0xBC, 0xE9, 0x41, 0x60, 0x7D, 0x0B, 0x0C, 0xC8, 0x4E, 0xBA, 0xAA, 0xDE, 0x08, 0x0C, 0xFF, 0xA0,
  0x20, 0xCF, 0xF9, 0x81, 0x70, 0xBF, 0xE0, 0xD0, 0x53, 0x84, 0x26, 0x9C, 0xDE, 0xC8, 0x1B, 0x84,
  0x74, 0x0C, 0xA0, 0x47, 0x60, 0x3B, 0x0B, 0x04, 0x75, 0x08, 0x0E, 0xC0, 0x77, 0x60, 0x6C, 0x01,
  0x76, 0x0D, 0xB0, 0x47, 0x20, 0x12, 0x04, 0xC0, 0x47, 0x29, 0x0E, 0xE0, 0x17, 0x2F, 0x06, 0x73,
  0x0B, 0x0E, 0xA8, 0x1D, 0xA3, 0x60,
  // "Š" (U+0160)
  0x38, 0x32, 0x77, 0x74, 0x68, 0x34, 0x77, 0x72, 0x40, 0x10, 0xDB, 0x07, 0x40, 0x7B, 0x0D, 0x01,
  0x50, 0x20, 0xEB, 0x08, 0x20, 0xAB, 0x0E, 0x02, 0x70, 0x5C, 0x08, 0x0A, 0xC0, 0x57, 0x20, 0x9F,
  0x90, 0x97, 0x40, 0xDE, 0x0D, 0x75, 0x03, 0xE0, 0x38, 0x09, 0x82, 0x08, 0x92, 0x16, 0xAD, 0xEF,
  0xED, 0xCA, 0x63, 0x70, 0x8F, 0xD8, 0x1D, 0x71, 0x20, 0x10, 0xCF, 0xF0, 0xE3, 0x0A, 0xFF, 0x90,
  0x82, 0x02, 0xF8, 0x3C, 0xAA, 0xBE, 0xC0, 0x22, 0x06, 0xD0, 0xE0, 0x35, 0x82, 0x37, 0xDB, 0x30,
  0x8D, 0x07, 0x72, 0x01, 0x30, 0x9D, 0x05, 0x76, 0x07, 0xD0, 0x67, 0x60, 0x4D, 0x0D, 0x02, 0x76,
  0x0D, 0xD0, 0xE0, 0x67, 0x50, 0x4F, 0x0D, 0x06, 0x74, 0x06, 0xF9, 0x0E, 0x06, 0x73, 0x05, 0x0E,
  0xF9, 0x0D, 0x05, 0x72, 0x01, 0x0A, 0xFA, 0x0B, 0x01, 0x72, 0x03, 0x0B, 0xF9, 0x0E, 0x02, 0x73,
  0x04, 0x0B, 0xF0, 0xC7, 0x50, 0x30, 0xCE, 0x05, 0x76, 0x0B, 0xD0, 0x97, 0x60, 0x4D, 0x0B, 0x76,
  0x02, 0xD8, 0x1B, 0x26, 0x74, 0x05, 0xD8, 0x5A, 0x3F, 0xE9, 0x51, 0x60, 0x40, 0xED, 0x06, 0x03,
  0xD8, 0x4D, 0xBA, 0xAB, 0xEE, 0x81, 0xE1, 0x3F, 0xFB, 0x81, 0x50, 0x3F, 0xFA, 0x07, 0x28, 0x11,
  0x9E, 0xFD, 0x0B, 0x03, 0x68, 0x34, 0x8A, 0xDE, 0xA8, 0x3D, 0xCA, 0x62, 0x50,
  // "š" (U+0161)
  0x18, 0x32, 0x77, 0x74, 0x68, 0x34, 0x77, 0x72, 0x20, 0x10, 0xDB, 0x07, 0x40, 0x7B, 0x0D, 0x01,
  0x30, 0x20, 0xEB, 0x08, 0x20, 0xAB, 0x0E, 0x02, 0x50, 0x5C, 0x08, 0x0A, 0xC0, 0x57, 0x09, 0xF9,
  0x09, 0x72, 0x0D, 0xE0, 0xD7, 0x30, 0x3E, 0x03, 0x80, 0xD1, 0x08, 0x92, 0x48, 0xBD, 0xEF, 0xED,
  0xB8, 0x51, 0x40, 0x30, 0xCF, 0xD8, 0x2B, 0x50, 0x4F, 0xF9, 0x81, 0x61, 0xEF, 0xF8, 0x1E, 0x06,
  0xE8, 0x3C, 0xAA, 0xBD, 0xC8, 0x19, 0x09, 0xD0, 0x76, 0x84, 0x48, 0xD2, 0x09, 0xD0, 0x67, 0x40,
  0x7D, 0x0E, 0x06, 0x73, 0x02, 0xF8, 0x1E, 0x94, 0x71, 0x08, 0xFA, 0x81, 0xE8, 0x16, 0x08, 0xFC,
  0x09, 0x01, 0x50, 0x20, 0xAF, 0xB0, 0xD0, 0x26, 0x81, 0x18, 0xEF, 0x90, 0xD7, 0x20, 0x40, 0xBF,
  0x06, 0x73, 0x02, 0x0C, 0xD0, 0x90, 0x37, 0x30, 0x3D, 0x84, 0xBC, 0xE9, 0x41, 0x60, 0x7D, 0x0B,
  0x0C, 0xC8, 0x4E, 0xBA, 0xAA, 0xDE, 0x08, 0x0C, 0xFF, 0xA0, 0x20, 0xCF, 0xF9, 0x81, 0x70, 0xBF,
  0xE0, 0xD0, 0x53, 0x84, 0x26, 0x9C, 0xDE, 0xA8, 0x3E, 0xDB, 0x84, 0x40,
  // "Ţ" (U+0162)
  0x0C, 0xFF, 0xE0, 0x0C, 0xFF, 0xE0, 0x0C, 0xFF, 0xE0, 0x0C, 0xFF, 0xE0, 0xC0, 0x78, 0x03, 0x9D,
  0x0E, 0x80, 0x39, 0x07, 0x71, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7,
  0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7,
  0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7,
  0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7,
  0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7,
  0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7,
  0x73, 0x0C, 0xA0, 0x47, 0x73, 0x03, 0xB0, 0xB0, 0x47, 0x72, 0x08, 0x0E, 0xC0, 0x77, 0x73, 0x06,
  0xC0, 0x17, 0x73, 0x0D, 0xB0, 0x47, 0x60, 0x12, 0x04, 0xC0, 0x47, 0x69, 0x0E, 0xE0, 0x17, 0x6F,
  0x06, 0x77, 0x0B, 0x0E, 0xA8, 0x1D, 0xA3, 0x71,
  // "ţ" (U+0163)
  0x60, 0x48, 0x00, 0x77, 0x71, 0x0A, 0xB0, 0xE7, 0x71, 0x0C, 0xB0, 0xE7, 0x71, 0xC0, 0xE7, 0x70,
  0x2C, 0x0E, 0x77, 0x05, 0xC0, 0xE7, 0x38, 0x21, 0x58, 0xCF, 0xF0, 0x10, 0xCF, 0xFC, 0x01, 0x0D,
  0xFF, 0xC0, 0x10, 0xDF, 0xFC, 0x85, 0x18, 0x99, 0x99, 0xED, 0x80, 0x49, 0x01, 0x50, 0xDC, 0x0E,
  0x77, 0x0D, 0xC0, 0xE7, 0x70, 0xDC, 0x0E, 0x77, 0x0D, 0xC0, 0xE7, 0x70, 0xDC, 0x0E, 0x77, 0x0D,
  0xC0, 0xE7, 0x70, 0xDC, 0x0E, 0x77, 0x0D, 0xC0, 0xE7, 0x70, 0xDC, 0x0E, 0x77, 0x0D, 0xD7, 0x70,
  0xCD, 0x03, 0x76, 0x09, 0xD0, 0xC0, 0x15, 0x00, 0x15, 0x05, 0xF8, 0x5C, 0xAA, 0xCE, 0xF4, 0x60,
  0xEF, 0xD0, 0x46, 0x04, 0xFD, 0x04, 0x70, 0x40, 0xDF, 0xB0, 0x47, 0x20, 0x50, 0xAC, 0x83, 0xDC,
  0x96, 0x17, 0x40, 0xCA, 0x04, 0x77, 0x10, 0x3B, 0x0B, 0x04, 0x77, 0x08, 0x0E, 0xC0, 0x77, 0x71,
  0x06, 0xC0, 0x17, 0x71, 0x0D, 0xB0, 0x47, 0x40, 0x12, 0x04, 0xC0, 0x47, 0x49, 0x0E, 0xE0, 0x17,
  0x4F, 0x06, 0x75, 0x0B, 0x0E, 0xA8, 0x1D, 0xA3, 0x40,
  // "Ť" (U+0164)
  0x38, 0x32, 0x77, 0x74, 0x68, 0x34, 0x77, 0x72, 0x60, 0x10, 0xDB, 0x07, 0x40, 0x7B, 0x0D, 0x01,
  0x70, 0x20, 0xEB, 0x08, 0x20, 0xAB, 0x0E, 0x02, 0x72, 0x05, 0xC0, 0x80, 0xAC, 0x05, 0x74, 0x09,
  0xF9, 0x09, 0x76, 0x0D, 0xE0, 0xD7, 0x70, 0x3E, 0x03, 0x80, 0x98, 0x50, 0x0C, 0xFF, 0xE0, 0x0C,
  0xFF, 0xE0, 0x0C, 0xFF, 0xE0, 0x0C, 0xFF, 0xE0, 0xC0, 0x78, 0x03, 0x9D, 0x0E, 0x80, 0x39, 0x07,
  0x71, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7,
  0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7,
  0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7,
  0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7,
  0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7,
  0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7, 0x10,
  // "ť" (U+0165)
  0x77, 0x10, 0x7C, 0x0C, 0x77, 0x10, 0xAC, 0x05, 0x77, 0x10, 0xDB, 0x0D, 0x78, 0x35, 0xAA, 0xA9,
  0x30, 0x1C, 0x04, 0x70, 0xBB, 0x0E, 0x30, 0x5B, 0x0A, 0x71, 0x0E, 0xB0, 0xE3, 0x08, 0xA0, 0xE0,
  0x17, 0x01, 0xC0, 0xE7, 0x71, 0x04, 0xC0, 0xE7, 0x48, 0x31, 0x47, 0xAD, 0xFE, 0x81, 0x10, 0xCF,
  0xFC, 0x81, 0x10, 0xDF, 0xFC, 0x81, 0x10, 0xDF, 0xFC, 0x86, 0x10, 0x89, 0x99, 0x9E, 0xD8, 0x04,
  0x90, 0x16, 0x0D, 0xC0, 0xE7, 0x71, 0x0D, 0xC0, 0xE7, 0x71, 0x0D, 0xC0, 0xE7, 0x71, 0x0D, 0xC0,
  0xE7, 0x71, 0x0D, 0xC0, 0xE7, 0x71, 0x0D, 0xC0, 0xE7, 0x71, 0x0D, 0xC0, 0xE7, 0x71, 0x0D, 0xC0,
  0xE7, 0x71, 0x0D, 0xC0, 0xE7, 0x71, 0x0D, 0xD7, 0x71, 0x0C, 0xD0, 0x37, 0x70, 0x9D, 0x0C, 0x01,
  0x50, 0x01, 0x60, 0x5F, 0x85, 0xCA, 0xAC, 0xEF, 0x47, 0x0E, 0xFD, 0x04, 0x70, 0x4F, 0xD0, 0x47,
  0x10, 0x40, 0xDF, 0xB0, 0x47, 0x38, 0x91, 0x5A, 0xDE, 0xFE, 0xDC, 0x96, 0x11,
  // "Ŧ" (U+0166)
  0x0C, 0xFF, 0xE0, 0x0C, 0xFF, 0xE0, 0x0C, 0xFF, 0xE0, 0x0C, 0xFF, 0xE0, 0xC0, 0x78, 0x03, 0x9D,
  0x0E, 0x80, 0x39, 0x07, 0x71, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7,
  0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7, 0x40, 0x88, 0x00, 0x9D,
  0x84, 0xE9, 0x99, 0x98, 0x60, 0xDF, 0xF0, 0xD6, 0x0D, 0xFF, 0x0D, 0x60, 0xDF, 0xF0, 0xD6, 0x0D,
  0xFF, 0x0D, 0x74, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E,
  0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E,
  0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E, 0xC0, 0xD7, 0x72, 0x0E,
  0xC0, 0xD7, 0x10,
  // "ŧ" (U+0167)
  0x60, 0x48, 0x00, 0x77, 0x71, 0x0A, 0xB0, 0xE7, 0x71, 0x0C, 0xB0, 0xE7, 0x71, 0xC0, 0xE7, 0x70,
  0x2C, 0x0E, 0x77, 0x05, 0xC0, 0xE7, 0x38, 0x21, 0x58, 0xCF, 0xF0, 0x10, 0xCF, 0xFC, 0x01, 0x0D,
  0xFF, 0xC0, 0x10, 0xDF, 0xFC, 0x85, 0x18, 0x99, 0x99, 0xED, 0x80, 0x49, 0x01, 0x50, 0xDC, 0x0E,
  0x77, 0x0D, 0xC0, 0xE7, 0x70, 0xDC, 0x0E, 0x72, 0x0D, 0xFF, 0xC0, 0x40, 0xDF, 0xFC, 0x04, 0x0D,
  0xFF, 0xC0, 0x40, 0xDF, 0xFC, 0x04, 0x50, 0xDC, 0x0E, 0x77, 0x0D, 0xC0, 0xE7, 0x70, 0xDD, 0x77,
  0x0C, 0xD0, 0x37, 0x60, 0xAD, 0x0C, 0x01, 0x50, 0x16, 0x06, 0xF8, 0x5B, 0xAA, 0xCE, 0xF4, 0x60,
  0xEF, 0xD0, 0x46, 0x05, 0xFD, 0x04, 0x70, 0x50, 0xEF, 0xB0, 0x47, 0x28, 0x91, 0x5A, 0xDE, 0xFE,
  0xDC, 0x96, 0x10,
  // "Ũ" (U+0168)
  0x58, 0x43, 0xBE, 0xEA, 0x44, 0x06, 0xA0, 0x87, 0x02, 0x0E, 0xD8, 0x3C, 0x51, 0x1D, 0xA0, 0x67,
  0x0A, 0xFE, 0x02, 0x60, 0x1F, 0xE0, 0xC7, 0x05, 0xA8, 0x3C, 0x11, 0x6D, 0xD0, 0xE0, 0x37, 0x07,
  0xA0, 0x64, 0x84, 0x4A, 0xEE, 0xB2, 0x80, 0x98, 0x30, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D,
  0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03,
  0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00,
  0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0,
  0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D,
  0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09,
  0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x30, 0x2D, 0x09, 0x71,
  0x0A, 0xD0, 0x20, 0x1D, 0x0B, 0x71, 0x0B, 0xD0, 0x11, 0xD0, 0xE7, 0x10, 0xED, 0x20, 0xCD, 0x05,
  0x60, 0x5D, 0x0B, 0x20, 0x7D, 0x0E, 0x04, 0x40, 0x40, 0xED, 0x06, 0x20, 0x10, 0xEE, 0x82, 0xDA,
  0xAD, 0xE0, 0xE4, 0x06, 0xFF, 0xA0, 0x45, 0x08, 0xFF, 0x06, 0x70, 0x50, 0xDF, 0xB0, 0xC0, 0x47,
  0x38, 0x90, 0x49, 0xCE, 0xFE, 0xDC, 0x84, 0x60,
  // "ũ" (U+0169)
  0x48, 0x43, 0xBE, 0xEA, 0x44, 0x06, 0xA0, 0x85, 0x02, 0x0E, 0xD8, 0x3C, 0x51, 0x1D, 0xA0, 0x65,
  0x0A, 0xFE, 0x02, 0x40, 0x1F, 0xE0, 0xC5, 0x05, 0xA8, 0x3C, 0x11, 0x6D, 0xD0, 0xE0, 0x35, 0x07,
  0xA0, 0x64, 0x84, 0x4A, 0xEE, 0xB2, 0x80, 0xD0, 0x0D, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x71, 0xD0,
  0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x71, 0xD0,
  0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x71, 0xD0,
  0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x70, 0x1D, 0x0C, 0xD0, 0xC7, 0x02, 0xD0, 0xCD, 0x0D, 0x70,
  0x4D, 0x0C, 0xE7, 0x09, 0xD0, 0xC0, 0xED, 0x04, 0x50, 0x10, 0xED, 0x0C, 0x0B, 0xD0, 0xC0, 0x13,
  0x02, 0x0C, 0xE0, 0xC0, 0x7E, 0x82, 0xEB, 0xAC, 0xF9, 0x0C, 0x01, 0xFF, 0xC8, 0x1C, 0x06, 0xFC,
  0x0B, 0x07, 0xC0, 0xC2, 0x06, 0xFA, 0x81, 0x90, 0x1C, 0x0C, 0x38, 0x72, 0x8C, 0xEF, 0xDC, 0x72,
  0x30, 0xBB, 0x0C,
  // "Ū" (U+016A)
  0x5F, 0xD0, 0x17, 0x2F, 0xD0, 0x17, 0x2F, 0xD0, 0x17, 0x2F, 0xD0, 0x18, 0x09, 0xB0, 0x00, 0x3D,
  0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03,
  0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00,
  0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0,
  0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D,
  0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09,
  0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10,
  0x9D, 0x03, 0x02, 0xD0, 0x97, 0x10, 0xAD, 0x02, 0x01, 0xD0, 0xB7, 0x10, 0xBD, 0x01, 0x1D, 0x0E,
  0x71, 0x0E, 0xD2, 0x0C, 0xD0, 0x56, 0x05, 0xD0, 0xB2, 0x07, 0xD0, 0xE0, 0x44, 0x04, 0x0E, 0xD0,
  0x62, 0x01, 0x0E, 0xE8, 0x2D, 0xAA, 0xDE, 0x0E, 0x40, 0x6F, 0xFA, 0x04, 0x50, 0x8F, 0xF0, 0x67,
  0x05, 0x0D, 0xFB, 0x0C, 0x04, 0x73, 0x89, 0x04, 0x9C, 0xEF, 0xED, 0xC8, 0x46,
  // "ū" (U+016B)
  0x4F, 0xD0, 0x17, 0xFD, 0x01, 0x7F, 0xD0, 0x17, 0xFD, 0x01, 0x80, 0xF3, 0x0D, 0x0C, 0x71, 0xD0,
  0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x71, 0xD0,
  0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x71, 0xD0,
  0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x70, 0x1D, 0x0C, 0xD0, 0xC7, 0x02,
  0xD0, 0xCD, 0x0D, 0x70, 0x4D, 0x0C, 0xE7, 0x09, 0xD0, 0xC0, 0xED, 0x04, 0x50, 0x10, 0xED, 0x0C,
  0x0B, 0xD0, 0xC0, 0x13, 0x02, 0x0C, 0xE0, 0xC0, 0x7E, 0x82, 0xEB, 0xAC, 0xF9, 0x0C, 0x01, 0xFF,
  0xC8, 0x1C, 0x06, 0xFC, 0x0B, 0x07, 0xC0, 0xC2, 0x06, 0xFA, 0x81, 0x90, 0x1C, 0x0C, 0x38, 0x72,
  0x8C, 0xEF, 0xDC, 0x72, 0x30, 0xBB, 0x0C,
  // "Ŭ" (U+016C)
  0x48, 0x24, 0x77, 0x66, 0x82, 0x47, 0x76, 0x71, 0x07, 0xA0, 0xE0, 0x15, 0x0C, 0xA0, 0xB7, 0x10,
  0x4B, 0x84, 0xC4, 0x10, 0x3A, 0xB0, 0x77, 0x20, 0xEF, 0xC0, 0x27, 0x20, 0x5F, 0xB0, 0x77, 0x40,
  0x6F, 0x90, 0x87, 0x68, 0x62, 0x9D, 0xEF, 0xD9, 0x38, 0x09, 0x85, 0x00, 0x3D, 0x09, 0x71, 0x09,
  0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10,
  0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71,
  0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97,
  0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09,
  0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0,
  0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x03, 0x02,
  0xD0, 0x97, 0x10, 0xAD, 0x02, 0x01, 0xD0, 0xB7, 0x10, 0xBD, 0x01, 0x1D, 0x0E, 0x71, 0x0E, 0xD2,
  0x0C, 0xD0, 0x56, 0x05, 0xD0, 0xB2, 0x07, 0xD0, 0xE0, 0x44, 0x04, 0x0E, 0xD0, 0x62, 0x01, 0x0E,
  0xE8, 0x2D, 0xAA, 0xDE, 0x0E, 0x40, 0x6F, 0xFA, 0x04, 0x50, 0x8F, 0xF0, 0x67, 0x05, 0x0D, 0xFB,
  0x0C, 0x04, 0x73, 0x89, 0x04, 0x9C, 0xEF, 0xED, 0xC8, 0x46,
  // "ŭ" (U+016D)
  0x38, 0x24, 0x77, 0x66, 0x82, 0x47, 0x76, 0x60, 0x7A, 0x0E, 0x01, 0x50, 0xCA, 0x0B, 0x60, 0x4B,
  0x84, 0xC4, 0x10, 0x3A, 0xB0, 0x77, 0x0E, 0xFC, 0x02, 0x70, 0x5F, 0xB0, 0x77, 0x20, 0x6F, 0x90,
  0x87, 0x48, 0x62, 0x9D, 0xEF, 0xD9, 0x38, 0x0D, 0x20, 0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D,
  0x0C, 0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D,
  0x0C, 0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D,
  0x0C, 0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x01, 0xD0, 0xCD, 0x0C, 0x70, 0x2D, 0x0C, 0xD0, 0xD7,
  0x04, 0xD0, 0xCE, 0x70, 0x9D, 0x0C, 0x0E, 0xD0, 0x45, 0x01, 0x0E, 0xD0, 0xC0, 0xBD, 0x0C, 0x01,
  0x30, 0x20, 0xCE, 0x0C, 0x07, 0xE8, 0x2E, 0xBA, 0xCF, 0x90, 0xC0, 0x1F, 0xFC, 0x81, 0xC0, 0x6F,
  0xC0, 0xB0, 0x7C, 0x0C, 0x20, 0x6F, 0xA8, 0x19, 0x01, 0xC0, 0xC3, 0x87, 0x28, 0xCE, 0xFD, 0xC7,
  0x23, 0x0B, 0xB0, 0xC0,
  // "Ů" (U+016E)
  0x71, 0x84, 0x6C, 0xFE, 0xB5, 0x77, 0x10, 0xBE, 0x09, 0x76, 0x05, 0xB0, 0x0E, 0xB0, 0x47, 0x50,
  0xAA, 0x07, 0x20, 0x9A, 0x0A, 0x75, 0x0C, 0xA0, 0x12, 0x03, 0xA0, 0xB7, 0x50, 0xAA, 0x07, 0x20,
  0x9A, 0x09, 0x75, 0x05, 0xB0, 0x0E, 0xB0, 0x47, 0x60, 0xAE, 0x09, 0x77, 0x18, 0x46, 0xCF, 0xEC,
  0x58, 0x09, 0x86, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D,
  0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03,
  0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00,
  0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0,
  0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D,
  0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09,
  0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x03, 0x02, 0xD0, 0x97, 0x10, 0xAD, 0x02, 0x01, 0xD0, 0xB7,
  0x10, 0xBD, 0x01, 0x1D, 0x0E, 0x71, 0x0E, 0xD2, 0x0C, 0xD0, 0x56, 0x05, 0xD0, 0xB2, 0x07, 0xD0,
  0xE0, 0x44, 0x04, 0x0E, 0xD0, 0x62, 0x01, 0x0E, 0xE8, 0x2D, 0xAA, 0xDE, 0x0E, 0x40, 0x6F, 0xFA,
  0x04, 0x50, 0x8F, 0xF0, 0x67, 0x05, 0x0D, 0xFB, 0x0C, 0x04, 0x73, 0x89, 0x04, 0x9C, 0xEF, 0xED,
  0xC8, 0x46,
  // "ů" (U+016F)
  0x78, 0x46, 0xCF, 0xEB, 0x57, 0x60, 0xBE, 0x09, 0x74, 0x05, 0xB0, 0x0E, 0xB0, 0x47, 0x30, 0xAA,
  0x07, 0x20, 0x9A, 0x0A, 0x73, 0x0C, 0xA0, 0x12, 0x03, 0xA0, 0xB7, 0x30, 0xAA, 0x07, 0x20, 0x9A,
  0x09, 0x73, 0x05, 0xB0, 0x0E, 0xB0, 0x47, 0x40, 0xAE, 0x09, 0x76, 0x84, 0x6C, 0xFE, 0xC5, 0x80,
  0xD3, 0x0D, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x71,
  0xD0, 0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x71,
  0xD0, 0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x71, 0xD0, 0xCD, 0x0C, 0x70,
  0x1D, 0x0C, 0xD0, 0xC7, 0x02, 0xD0, 0xCD, 0x0D, 0x70, 0x4D, 0x0C, 0xE7, 0x09, 0xD0, 0xC0, 0xED,
  0x04, 0x50, 0x10, 0xED, 0x0C, 0x0B, 0xD0, 0xC0, 0x13, 0x02, 0x0C, 0xE0, 0xC0, 0x7E, 0x82, 0xEB,
  0xAC, 0xF9, 0x0C, 0x01, 0xFF, 0xC8, 0x1C, 0x06, 0xFC, 0x0B, 0x07, 0xC0, 0xC2, 0x06, 0xFA, 0x81,
  0x90, 0x1C, 0x0C, 0x38, 0x72, 0x8C, 0xEF, 0xDC, 0x72, 0x30, 0xBB, 0x0C,
  // "Ű" (U+0170)
  0x60, 0x4D, 0x03, 0x02, 0xD0, 0x57, 0x10, 0xCC, 0x81, 0x70, 0xAC, 0x0A, 0x71, 0x07, 0xC8, 0x18,
  0x04, 0xC0, 0xA7, 0x10, 0x2C, 0x07, 0x20, 0xDB, 0x09, 0x72, 0x0B, 0xB0, 0x52, 0x09, 0xB0, 0x87,
  0x20, 0x5A, 0x0D, 0x03, 0x20, 0x2A, 0x0E, 0x05, 0x80, 0x98, 0x50, 0x03, 0xD0, 0x97, 0x10, 0x9D,
  0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09,
  0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10,
  0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71,
  0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97,
  0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09,
  0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x30, 0x2D,
  0x09, 0x71, 0x0A, 0xD0, 0x20, 0x1D, 0x0B, 0x71, 0x0B, 0xD0, 0x11, 0xD0, 0xE7, 0x10, 0xED, 0x20,
  0xCD, 0x05, 0x60, 0x5D, 0x0B, 0x20, 0x7D, 0x0E, 0x04, 0x40, 0x40, 0xED, 0x06, 0x20, 0x10, 0xEE,
  0x82, 0xDA, 0xAD, 0xE0, 0xE4, 0x06, 0xFF, 0xA0, 0x45, 0x08, 0xFF, 0x06, 0x70, 0x50, 0xDF, 0xB0,
  0xC0, 0x47, 0x38, 0x90, 0x49, 0xCE, 0xFE, 0xDC, 0x84, 0x60,
  // "ű" (U+0171)
  0x50, 0x4D, 0x03, 0x02, 0xD0, 0x56, 0x0C, 0xC8, 0x17, 0x0A, 0xC0, 0xA6, 0x07, 0xC8, 0x18, 0x04,
  0xC0, 0xA6, 0x02, 0xC0, 0x72, 0x0D, 0xB0, 0x97, 0x0B, 0xB0, 0x52, 0x09, 0xB0, 0x87, 0x05, 0xA0,
  0xD0, 0x32, 0x02, 0xA0, 0xE0, 0x58, 0x0D, 0x20, 0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C,
  0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C,
  0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C,
  0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x01, 0xD0, 0xCD, 0x0C, 0x70, 0x2D, 0x0C, 0xD0, 0xD7, 0x04,
  0xD0, 0xCE, 0x70, 0x9D, 0x0C, 0x0E, 0xD0, 0x45, 0x01, 0x0E, 0xD0, 0xC0, 0xBD, 0x0C, 0x01, 0x30,
  0x20, 0xCE, 0x0C, 0x07, 0xE8, 0x2E, 0xBA, 0xCF, 0x90, 0xC0, 0x1F, 0xFC, 0x81, 0xC0, 0x6F, 0xC0,
  0xB0, 0x7C, 0x0C, 0x20, 0x6F, 0xA8, 0x19, 0x01, 0xC0, 0xC3, 0x87, 0x28, 0xCE, 0xFD, 0xC7, 0x23,
  0x0B, 0xB0, 0xC0,
  // "Ų" (U+0172)
  0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D,
  0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09,
  0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10,
  0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71,
  0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97,
  0x10, 0x9D, 0x00, 0x3D, 0x09, 0x71, 0x09, 0xD0, 0x03, 0xD0, 0x97, 0x10, 0x9D, 0x00, 0x3D, 0x09,
  0x71, 0x09, 0xD0, 0x30, 0x2D, 0x09, 0x71, 0x0A, 0xD0, 0x20, 0x1D, 0x0B, 0x71, 0x0B, 0xD0, 0x11,
  0xD0, 0xE7, 0x10, 0xEC, 0x0E, 0x20, 0xCD, 0x05, 0x60, 0x5D, 0x0A, 0x20, 0x8D, 0x0E, 0x04, 0x40,
  0x40, 0xED, 0x05, 0x20, 0x1F, 0x82, 0xDA, 0xAD, 0xE0, 0xC4, 0x07, 0xFF, 0x90, 0xE0, 0x25, 0x0A,
  0xFE, 0x0D, 0x03, 0x70, 0x70, 0xEF, 0xB0, 0x80, 0x17, 0x28, 0x31, 0x6A, 0xDE, 0xC0, 0xB0, 0x27,
  0x71, 0x04, 0x0E, 0xA0, 0x87, 0x72, 0x03, 0xB0, 0x77, 0x73, 0x0D, 0xA0, 0xD7, 0x73, 0x03, 0xB0,
  0xA7, 0x73, 0x06, 0xB8, 0x2E, 0x30, 0x27, 0x70, 0x5F, 0x01, 0x76, 0x01, 0xF0, 0x17, 0x70, 0x7E,
  0x01, 0x77, 0x18, 0x44, 0xBE, 0xFD, 0xA7,
  // "ų" (U+0173)
  0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C,
  0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C,
  0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x01, 0xD0,
  0xCD, 0x0C, 0x70, 0x2D, 0x0C, 0xD0, 0xD7, 0x04, 0xD0, 0xCE, 0x70, 0x9D, 0x0C, 0x0E, 0xD0, 0x45,
  0x01, 0x0E, 0xD0, 0xC0, 0xBD, 0x0C, 0x01, 0x30, 0x20, 0xCE, 0x0C, 0x07, 0xE8, 0x2E, 0xBA, 0xCF,
  0x90, 0xC0, 0x1F, 0xFC, 0x81, 0xC0, 0x6F, 0xC0, 0xB0, 0x7C, 0x0C, 0x20, 0x6F, 0xA8, 0x19, 0x01,
  0xC0, 0xC3, 0x87, 0x28, 0xCE, 0xFD, 0xC7, 0x22, 0x01, 0xC0, 0xC7, 0x70, 0xCA, 0x0C, 0x77, 0x10,
  0x9B, 0x02, 0x77, 0x01, 0xB0, 0xB7, 0x71, 0x06, 0xB0, 0x97, 0x71, 0x07, 0xB8, 0x2D, 0x20, 0x37,
  0x50, 0x6F, 0x75, 0x02, 0xF7, 0x60, 0x7E, 0x77, 0x84, 0x5B, 0xEF, 0xD9,
  // "Ŵ" (U+0174)
  0x72, 0x80, 0x27, 0x01, 0x77, 0x20, 0x6E, 0x0A, 0x77, 0x10, 0x20, 0xEF, 0x05, 0x77, 0x0C, 0xC0,
  0xDB, 0x0E, 0x02, 0x75, 0x09, 0xB8, 0x2E, 0x41, 0xDB, 0x0C, 0x74, 0x06, 0xB0, 0xE0, 0x32, 0x01,
  0x0C, 0xB0, 0xA7, 0x20, 0x2B, 0x0C, 0x02, 0x50, 0xAB, 0x05, 0x80, 0x99, 0x00, 0x08, 0xC0, 0x77,
  0x50, 0x7C, 0x08, 0x07, 0xC0, 0x97, 0x50, 0x8C, 0x07, 0x06, 0xC0, 0xA7, 0x50, 0x9C, 0x06, 0x05,
  0xC0, 0xC7, 0x50, 0xBC, 0x05, 0x03, 0xC0, 0xD7, 0x50, 0xCC, 0x04, 0x02, 0xD7, 0x50, 0xDC, 0x03,
  0x01, 0xD3, 0x0C, 0xC0, 0xD3, 0x0E, 0xC0, 0x11, 0xD0, 0x22, 0x0E, 0xD3, 0xD2, 0x0E, 0xC8, 0x13,
  0x01, 0xE8, 0x12, 0x01, 0xD2, 0x0D, 0xC8, 0x14, 0x04, 0xE8, 0x14, 0x02, 0xC0, 0xE2, 0x0C, 0xC8,
  0x15, 0x06, 0xE8, 0x17, 0x03, 0xC0, 0xD2, 0x0B, 0xC8, 0x16, 0x08, 0xE8, 0x19, 0x04, 0xC0, 0xB2,
  0x0A, 0xC8, 0x17, 0x0B, 0xA0, 0xD0, 0xCA, 0x81, 0xB0, 0x5C, 0x0A, 0x20, 0x9C, 0x81, 0x80, 0xDA,
  0x0B, 0x0A, 0xA8, 0x1E, 0x06, 0xC0, 0x92, 0x07, 0xC0, 0x81, 0xB0, 0x90, 0x8B, 0x01, 0x07, 0xC0,
  0x82, 0x06, 0xC0, 0x90, 0x2B, 0x07, 0x06, 0xB0, 0x30, 0x7C, 0x07, 0x20, 0x5C, 0x09, 0x04, 0xB0,
  0x50, 0x4B, 0x05, 0x07, 0xC0, 0x62, 0x04, 0xC0, 0x90, 0x7B, 0x00, 0x2B, 0x08, 0x07, 0xC0, 0x52,
  0x03, 0xC0, 0x09, 0xB2, 0xB0, 0xA0, 0x7C, 0x04, 0x20, 0x1C, 0x09, 0x0B, 0xA0, 0xD2, 0x0D, 0xA0,
  0xD0, 0x6C, 0x03, 0x3C, 0x09, 0x0D, 0xA0, 0xB2, 0x0B, 0xB0, 0x6C, 0x01, 0x3C, 0x08, 0xB0, 0x92,
  0x08, 0xB0, 0x8C, 0x40, 0xDB, 0x0A, 0xB0, 0x62, 0x06, 0xB0, 0x9C, 0x40, 0xCB, 0x0E, 0xB0, 0x42,
  0x04, 0xB0, 0xEB, 0x0E, 0x40, 0xBF, 0x02, 0x20, 0x1F, 0x0D, 0x40, 0xAF, 0x40, 0xEE, 0x0B, 0x40,
  0x9E, 0x0D, 0x40, 0xCE, 0x0A, 0x40, 0x8E, 0x0B, 0x40, 0xAE, 0x09, 0x20,
  // "ŵ" (U+0175)
  0x72, 0x80, 0x27, 0x01, 0x77, 0x20, 0x6E, 0x0A, 0x77, 0x10, 0x20, 0xEF, 0x05, 0x77, 0x0C, 0xC0,
  0xDB, 0x0E, 0x02, 0x75, 0x09, 0xB8, 0x2E, 0x41, 0xDB, 0x0C, 0x74, 0x06, 0xB0, 0xE0, 0x32, 0x01,
  0x0C, 0xB0, 0xA7, 0x20, 0x2B, 0x0C, 0x02, 0x50, 0xAB, 0x05, 0x80, 0xE0, 0x00, 0xCC, 0x06, 0x75,
  0x05, 0xC0, 0xD0, 0xAC, 0x08, 0x75, 0x06, 0xC0, 0xB0, 0x8C, 0x09, 0x75, 0x07, 0xC0, 0x80, 0x6C,
  0x0B, 0x75, 0x09, 0xC0, 0x60, 0x3C, 0x0C, 0x30, 0x8C, 0x09, 0x30, 0xAC, 0x04, 0x01, 0xC0, 0xD3,
  0x0B, 0xC0, 0xC3, 0x0B, 0xC8, 0x12, 0x0E, 0xC3, 0x0E, 0xD3, 0x0C, 0xC2, 0x0C, 0xC2, 0x02, 0xE0,
  0x32, 0x0E, 0xB0, 0xD2, 0x0A, 0xC8, 0x12, 0x05, 0xE0, 0x62, 0xC0, 0xB2, 0x08, 0xC8, 0x13, 0x09,
  0xE8, 0x1A, 0x01, 0xC0, 0x92, 0x06, 0xC8, 0x14, 0x0C, 0xA0, 0x0D, 0xA8, 0x1D, 0x02, 0xC0, 0x72,
  0x04, 0xC0, 0x61, 0xB0, 0x0A, 0xB0, 0x10, 0x3C, 0x04, 0x20, 0x2C, 0x07, 0x02, 0xB0, 0x08, 0xB0,
  0x30, 0x5C, 0x02, 0x3C, 0x09, 0x05, 0xB0, 0x05, 0xB0, 0x06, 0xC4, 0x0D, 0xB0, 0xA0, 0x8B, 0x00,
  0x2B, 0x09, 0x07, 0xB0, 0xD4, 0x0B, 0xB0, 0xC0, 0xAA, 0x0E, 0x2B, 0x0C, 0x09, 0xB0, 0xB4, 0x08,
  0xB0, 0xD0, 0xCA, 0x0C, 0x20, 0xCA, 0x0E, 0x0A, 0xB0, 0x94, 0x06, 0xF0, 0x92, 0x09, 0xB0, 0xEB,
  0x07, 0x40, 0x4F, 0x06, 0x20, 0x6F, 0x05, 0x40, 0x2F, 0x03, 0x20, 0x3F, 0x03, 0x5F, 0x4F, 0x60,
  0xDD, 0x0C, 0x40, 0xDD, 0x0E, 0x30,
  // "Ŷ" (U+0176)
  0x71, 0x80, 0x27, 0x01, 0x77, 0x06, 0xE0, 0xA7, 0x60, 0x20, 0xEF, 0x05, 0x75, 0x0C, 0xC0, 0xDB,
  0x0E, 0x02, 0x73, 0x09, 0xB8, 0x2E, 0x41, 0xDB, 0x0C, 0x72, 0x06, 0xB0, 0xE0, 0x32, 0x01, 0x0C,
  0xB0, 0xA7, 0x02, 0xB0, 0xC0, 0x25, 0x0A, 0xB0, 0x58, 0x09, 0x81, 0x00, 0xED, 0x02, 0x71, 0x01,
  0xD0, 0xE0, 0x7D, 0x08, 0x71, 0x07, 0xD8, 0x17, 0x0E, 0xC0, 0xE7, 0x10, 0xEC, 0x0E, 0x20, 0x7D,
  0x06, 0x60, 0x5D, 0x08, 0x20, 0x10, 0xEC, 0x0D, 0x60, 0xCC, 0x0E, 0x01, 0x30, 0x8D, 0x04, 0x40,
  0x3D, 0x08, 0x40, 0x1D, 0x0A, 0x40, 0x9D, 0x01, 0x50, 0x8D, 0x02, 0x20, 0x1D, 0x09, 0x60, 0x1D,
  0x08, 0x20, 0x7D, 0x02, 0x70, 0x9C, 0x0E, 0x20, 0xDC, 0x09, 0x71, 0x02, 0xD0, 0x60, 0x5D, 0x02,
  0x72, 0x09, 0xC0, 0xD0, 0xBC, 0x0A, 0x73, 0x02, 0xFB, 0x02, 0x74, 0x0A, 0xF9, 0x0A, 0x75, 0x02,
  0xF9, 0x03, 0x76, 0x0A, 0xE0, 0xB7, 0x70, 0x3E, 0x04, 0x77, 0x10, 0xDC, 0x0E, 0x77, 0x20, 0xDC,
  0x0E, 0x77, 0x20, 0xDC, 0x0E, 0x77, 0x20, 0xDC, 0x0E, 0x77, 0x20, 0xDC, 0x0E, 0x77, 0x20, 0xDC,
  0x0E, 0x77, 0x20, 0xDC, 0x0E, 0x77, 0x20, 0xDC, 0x0E, 0x77, 0x20, 0xDC, 0x0E, 0x77, 0x20, 0xDC,
  0x0E, 0x77, 0x20, 0xDC, 0x0E, 0x71,
  // "ŷ" (U+0177)
  0x71, 0x80, 0x27, 0x01, 0x77, 0x06, 0xE0, 0xA7, 0x60, 0x20, 0xEF, 0x05, 0x75, 0x0C, 0xC0, 0xDB,
  0x0E, 0x02, 0x73, 0x09, 0xB8, 0x2E, 0x41, 0xDB, 0x0C, 0x72, 0x06, 0xB0, 0xE0, 0x32, 0x01, 0x0C,
  0xB0, 0xA7, 0x02, 0xB0, 0xC0, 0x25, 0x0A, 0xB0, 0x58, 0x0D, 0x30, 0x0E, 0xD0, 0x47, 0x10, 0x3D,
  0x0E, 0x09, 0xD0, 0x97, 0x10, 0x7D, 0x0A, 0x03, 0xD0, 0xE7, 0x10, 0xCD, 0x81, 0x40, 0xCD, 0x04,
  0x60, 0x1D, 0x0D, 0x20, 0x6D, 0x09, 0x60, 0x6D, 0x08, 0x30, 0xEC, 0x0E, 0x60, 0xAD, 0x02, 0x30,
  0x9D, 0x04, 0x50, 0xEC, 0x0C, 0x40, 0x3D, 0x0A, 0x40, 0x4D, 0x06, 0x50, 0xCC, 0x0E, 0x40, 0x9D,
  0x01, 0x50, 0x6D, 0x04, 0x30, 0xDC, 0x0A, 0x70, 0xEC, 0x0A, 0x20, 0x2D, 0x04, 0x70, 0x9C, 0x0E,
  0x20, 0x7C, 0x0E, 0x71, 0x03, 0xD8, 0x14, 0x0C, 0xC0, 0x87, 0x20, 0xCC, 0x09, 0x01, 0xD0, 0x37,
  0x20, 0x6C, 0x0D, 0x05, 0xC0, 0xC7, 0x40, 0xEC, 0x09, 0xC0, 0x77, 0x40, 0x9F, 0xA0, 0x17, 0x40,
  0x3F, 0x90, 0xB7, 0x60, 0xCF, 0x05, 0x76, 0x06, 0xE0, 0xE7, 0x71, 0x0E, 0xD0, 0x97, 0x71, 0x0A,
  0xD0, 0x37, 0x71, 0x0E, 0xC0, 0xD7, 0x71, 0x06, 0xD0, 0x67, 0x70, 0x10, 0xDC, 0x0E, 0x01, 0x76,
  0x02, 0x0C, 0xD0, 0x77, 0x38, 0x28, 0xBA, 0xCE, 0x0D, 0x74, 0x09, 0xFA, 0x04, 0x74, 0x09, 0xF9,
  0x06, 0x75, 0x09, 0xE0, 0xE0, 0x47, 0x60, 0x70, 0xDA, 0x81, 0xEB, 0x67, 0x70,
  // "Ÿ" (U+0178)
  0x48, 0x35, 0xDE, 0xC3, 0x48, 0x32, 0xBE, 0xD7, 0x70, 0x2C, 0x0E, 0x40, 0xCC, 0x05, 0x60, 0x5D,
  0x03, 0x3D, 0x09, 0x60, 0x5D, 0x03, 0x3D, 0x09, 0x60, 0x1C, 0x0D, 0x40, 0xBC, 0x04, 0x78, 0x34,
  0xCE, 0xB3, 0x48, 0x31, 0xAE, 0xD6, 0x80, 0x98, 0x20, 0x0E, 0xD0, 0x27, 0x10, 0x1D, 0x0E, 0x07,
  0xD0, 0x87, 0x10, 0x7D, 0x81, 0x70, 0xEC, 0x0E, 0x71, 0x0E, 0xC0, 0xE2, 0x07, 0xD0, 0x66, 0x05,
  0xD0, 0x82, 0x01, 0x0E, 0xC0, 0xD6, 0x0C, 0xC0, 0xE0, 0x13, 0x08, 0xD0, 0x44, 0x03, 0xD0, 0x84,
  0x01, 0xD0, 0xA4, 0x09, 0xD0, 0x15, 0x08, 0xD0, 0x22, 0x01, 0xD0, 0x96, 0x01, 0xD0, 0x82, 0x07,
  0xD0, 0x27, 0x09, 0xC0, 0xE2, 0x0D, 0xC0, 0x97, 0x10, 0x2D, 0x06, 0x05, 0xD0, 0x27, 0x20, 0x9C,
  0x0D, 0x0B, 0xC0, 0xA7, 0x30, 0x2F, 0xB0, 0x27, 0x40, 0xAF, 0x90, 0xA7, 0x50, 0x2F, 0x90, 0x37,
  0x60, 0xAE, 0x0B, 0x77, 0x03, 0xE0, 0x47, 0x71, 0x0D, 0xC0, 0xE7, 0x72, 0x0D, 0xC0, 0xE7, 0x72,
  0x0D, 0xC0, 0xE7, 0x72, 0x0D, 0xC0, 0xE7, 0x72, 0x0D, 0xC0, 0xE7, 0x72, 0x0D, 0xC0, 0xE7, 0x72,
  0x0D, 0xC0, 0xE7, 0x72, 0x0D, 0xC0, 0xE7, 0x72, 0x0D, 0xC0, 0xE7, 0x72, 0x0D, 0xC0, 0xE7, 0x72,
  0x0D, 0xC0, 0xE7, 0x10,
  // "Ź" (U+0179)
  0x72, 0x02, 0x80, 0x27, 0x01, 0x74, 0x0B, 0xD0, 0xA7, 0x40, 0x5D, 0x0A, 0x74, 0x01, 0x0E, 0xC0,
  0x97, 0x50, 0xAC, 0x09, 0x75, 0x06, 0xC0, 0x77, 0x60, 0xEB, 0x05, 0x80, 0xF6, 0x00, 0xCF, 0xFA,
  0x81, 0x10, 0xCF, 0xFA, 0x81, 0x10, 0xCF, 0xFA, 0x81, 0x10, 0xCF, 0xFA, 0x81, 0x10, 0x78, 0x05,
  0x90, 0xCD, 0x0A, 0x75, 0x0D, 0xC0, 0xE0, 0x17, 0x40, 0x6D, 0x07, 0x74, 0x01, 0x0E, 0xC0, 0xD7,
  0x50, 0x9D, 0x04, 0x74, 0x02, 0xD0, 0xB7, 0x50, 0xBD, 0x02, 0x74, 0x05, 0xD0, 0x87, 0x50, 0xDC,
  0x0D, 0x75, 0x07, 0xD0, 0x57, 0x40, 0x10, 0xEC, 0x0B, 0x75, 0x0A, 0xD0, 0x37, 0x40, 0x3D, 0x09,
  0x75, 0x0C, 0xC0, 0xE0, 0x17, 0x40, 0x5D, 0x06, 0x75, 0x0E, 0xC0, 0xC7, 0x50, 0x8D, 0x03, 0x74,
  0x02, 0xD0, 0xA7, 0x50, 0xAC, 0x0E, 0x01, 0x74, 0x04, 0xD0, 0xD8, 0x07, 0x90, 0x20, 0xBF, 0xFB,
  0x03, 0x0C, 0xFF, 0xB0, 0x30, 0xCF, 0xFB, 0x03, 0x0C, 0xFF, 0xB0, 0x30,
  // "ź" (U+017A)
  0x73, 0x02, 0x80, 0x27, 0x01, 0x75, 0x0B, 0xD0, 0xA7, 0x50, 0x5D, 0x0A, 0x75, 0x01, 0x0E, 0xC0,
  0x97, 0x60, 0xAC, 0x09, 0x76, 0x06, 0xC0, 0x77, 0x70, 0xEB, 0x05, 0x80, 0xD5, 0x00, 0xCF, 0xFB,
  0x20, 0xCF, 0xFB, 0x20, 0xCF, 0xFB, 0x20, 0xCF, 0xFB, 0x20, 0x78, 0x05, 0x90, 0xCE, 0x09, 0x74,
  0x01, 0x0D, 0xD0, 0xB7, 0x50, 0xBD, 0x0D, 0x01, 0x74, 0x09, 0xD0, 0xE0, 0x27, 0x40, 0x5E, 0x04,
  0x74, 0x03, 0xE0, 0x77, 0x40, 0x10, 0xDD, 0x0A, 0x75, 0x0C, 0xD0, 0xC7, 0x50, 0x9D, 0x0D, 0x01,
  0x74, 0x06, 0xE0, 0x37, 0x40, 0x3E, 0x05, 0x74, 0x01, 0x0E, 0xD0, 0x87, 0x50, 0xCD, 0x0A, 0x75,
  0x09, 0xE0, 0xA8, 0x06, 0x90, 0x04, 0xFF, 0xC0, 0x06, 0xFF, 0xC0, 0x06, 0xFF, 0xC0, 0x06, 0xFF,
  0xC0, 0x60,
  // "Ż" (U+017B)
  0x68, 0x43, 0xBE, 0xEB, 0x37, 0x50, 0x10, 0xEC, 0x0E, 0x01, 0x74, 0x06, 0xE0, 0x57, 0x40, 0x8E,
  0x07, 0x74, 0x06, 0xE0, 0x57, 0x40, 0x10, 0xEC, 0x0E, 0x01, 0x75, 0x84, 0x3B, 0xEE, 0xB2, 0x80,
  0xF5, 0x00, 0xCF, 0xFA, 0x81, 0x10, 0xCF, 0xFA, 0x81, 0x10, 0xCF, 0xFA, 0x81, 0x10, 0xCF, 0xFA,
  0x81, 0x10, 0x78, 0x05, 0x90, 0xCD, 0x0A, 0x75, 0x0D, 0xC0, 0xE0, 0x17, 0x40, 0x6D, 0x07, 0x74,
  0x01, 0x0E, 0xC0, 0xD7, 0x50, 0x9D, 0x04, 0x74, 0x02, 0xD0, 0xB7, 0x50, 0xBD, 0x02, 0x74, 0x05,
  0xD0, 0x87, 0x50, 0xDC, 0x0D, 0x75, 0x07, 0xD0, 0x57, 0x40, 0x10, 0xEC, 0x0B, 0x75, 0x0A, 0xD0,
  0x37, 0x40, 0x3D, 0x09, 0x75, 0x0C, 0xC0, 0xE0, 0x17, 0x40, 0x5D, 0x06, 0x75, 0x0E, 0xC0, 0xC7,
  0x50, 0x8D, 0x03, 0x74, 0x02, 0xD0, 0xA7, 0x50, 0xAC, 0x0E, 0x01, 0x74, 0x04, 0xD0, 0xD8, 0x07,
  0x90, 0x20, 0xBF, 0xFB, 0x03, 0x0C, 0xFF, 0xB0, 0x30, 0xCF, 0xFB, 0x03, 0x0C, 0xFF, 0xB0, 0x30,
  // "ż" (U+017C)
  0x78, 0x43, 0xBE, 0xEB, 0x37, 0x60, 0x10, 0xEC, 0x0E, 0x01, 0x75, 0x06, 0xE0, 0x57, 0x50, 0x8E,
  0x07, 0x75, 0x06, 0xE0, 0x57, 0x50, 0x10, 0xEC, 0x0E, 0x01, 0x76, 0x84, 0x3B, 0xEE, 0xB2, 0x80,
  0xD4, 0x00, 0xCF, 0xFB, 0x20, 0xCF, 0xFB, 0x20, 0xCF, 0xFB, 0x20, 0xCF, 0xFB, 0x20, 0x78, 0x05,
  0x90, 0xCE, 0x09, 0x74, 0x01, 0x0D, 0xD0, 0xB7, 0x50, 0xBD, 0x0D, 0x01, 0x74, 0x09, 0xD0, 0xE0,
  0x27, 0x40, 0x5E, 0x04, 0x74, 0x03, 0xE0, 0x77, 0x40, 0x10, 0xDD, 0x0A, 0x75, 0x0C, 0xD0, 0xC7,
  0x50, 0x9D, 0x0D, 0x01, 0x74, 0x06, 0xE0, 0x37, 0x40, 0x3E, 0x05, 0x74, 0x01, 0x0E, 0xD0, 0x87,
  0x50, 0xCD, 0x0A, 0x75, 0x09, 0xE0, 0xA8, 0x06, 0x90, 0x04, 0xFF, 0xC0, 0x06, 0xFF, 0xC0, 0x06,
  0xFF, 0xC0, 0x06, 0xFF, 0xC0, 0x60,
  // "Ž" (U+017D)
  0x18, 0x32, 0x77, 0x74, 0x68, 0x34, 0x77, 0x72, 0x30, 0x10, 0xDB, 0x07, 0x40, 0x7B, 0x0D, 0x01,
  0x40, 0x20, 0xEB, 0x08, 0x20, 0xAB, 0x0E, 0x02, 0x60, 0x5C, 0x08, 0x0A, 0xC0, 0x57, 0x10, 0x9F,
  0x90, 0x97, 0x30, 0xDE, 0x0D, 0x74, 0x03, 0xE0, 0x38, 0x0F, 0x40, 0x0C, 0xFF, 0xA8, 0x11, 0x0C,
  0xFF, 0xA8, 0x11, 0x0C, 0xFF, 0xA8, 0x11, 0x0C, 0xFF, 0xA8, 0x11, 0x07, 0x80, 0x59, 0x0C, 0xD0,
  0xA7, 0x50, 0xDC, 0x0E, 0x01, 0x74, 0x06, 0xD0, 0x77, 0x40, 0x10, 0xEC, 0x0D, 0x75, 0x09, 0xD0,
  0x47, 0x40, 0x2D, 0x0B, 0x75, 0x0B, 0xD0, 0x27, 0x40, 0x5D, 0x08, 0x75, 0x0D, 0xC0, 0xD7, 0x50,
  0x7D, 0x05, 0x74, 0x01, 0x0E, 0xC0, 0xB7, 0x50, 0xAD, 0x03, 0x74, 0x03, 0xD0, 0x97, 0x50, 0xCC,
  0x0E, 0x01, 0x74, 0x05, 0xD0, 0x67, 0x50, 0xEC, 0x0C, 0x75, 0x08, 0xD0, 0x37, 0x40, 0x2D, 0x0A,
  0x75, 0x0A, 0xC0, 0xE0, 0x17, 0x40, 0x4D, 0x0D, 0x80, 0x79, 0x02, 0x0B, 0xFF, 0xB0, 0x30, 0xCF,
  0xFB, 0x03, 0x0C, 0xFF, 0xB0, 0x30, 0xCF, 0xFB, 0x03,
  // "ž" (U+017E)
  0x28, 0x32, 0x77, 0x74, 0x68, 0x34, 0x77, 0x72, 0x40, 0x10, 0xDB, 0x07, 0x40, 0x7B, 0x0D, 0x01,
  0x50, 0x20, 0xEB, 0x08, 0x20, 0xAB, 0x0E, 0x02, 0x70, 0x5C, 0x08, 0x0A, 0xC0, 0x57, 0x20, 0x9F,
  0x90, 0x97, 0x40, 0xDE, 0x0D, 0x75, 0x03, 0xE0, 0x38, 0x0D, 0x30, 0x0C, 0xFF, 0xB2, 0x0C, 0xFF,
  0xB2, 0x0C, 0xFF, 0xB2, 0x0C, 0xFF, 0xB2, 0x07, 0x80, 0x59, 0x0C, 0xE0, 0x97, 0x40, 0x10, 0xDD,
  0x0B, 0x75, 0x0B, 0xD0, 0xD0, 0x17, 0x40, 0x9D, 0x0E, 0x02, 0x74, 0x05, 0xE0, 0x47, 0x40, 0x3E,
  0x07, 0x74, 0x01, 0x0D, 0xD0, 0xA7, 0x50, 0xCD, 0x0C, 0x75, 0x09, 0xD0, 0xD0, 0x17, 0x40, 0x6E,
  0x03, 0x74, 0x03, 0xE0, 0x57, 0x40, 0x10, 0xED, 0x08, 0x75, 0x0C, 0xD0, 0xA7, 0x50, 0x9E, 0x0A,
  0x80, 0x69, 0x00, 0x4F, 0xFC, 0x00, 0x6F, 0xFC, 0x00, 0x6F, 0xFC, 0x00, 0x6F, 0xFC, 0x06,
  // "ſ" (U+017F)
  0x38, 0x93, 0x49, 0xCE, 0xFE, 0xDB, 0x83, 0x01, 0xCF, 0xA8, 0x1A, 0x0C, 0xFB, 0x00, 0x6F, 0xC0,
  0x10, 0xBE, 0x85, 0xCA, 0xCF, 0xC0, 0xED, 0x04, 0x30, 0x10, 0x21, 0xD0, 0xC7, 0xD0, 0xA7, 0xD0,
  0xA7, 0xD0, 0xA7, 0xD0, 0xA7, 0xD0, 0xA7, 0xD0, 0xA7, 0xD0, 0xA7, 0xD0, 0xA7, 0xD0, 0xA7, 0xD0,
  0xA7, 0xD0, 0xA7, 0xD0, 0xA7, 0xD0, 0xA7, 0xD0, 0xA7, 0xD0, 0xA7, 0xD0, 0xA7, 0xD0, 0xA7, 0xD0,
  0xA7, 0xD0, 0xA7, 0xD0, 0xA7, 0xD0, 0xA7, 0xD0, 0xA7, 0xD0, 0xA7,
  // "Ω" (U+03A9)
  0x78, 0x90, 0x27, 0xBD, 0xEE, 0xDB, 0x72, 0x75, 0x01, 0x0A, 0xFB, 0x09, 0x73, 0x02, 0x0D, 0xFD,
  0x0C, 0x01, 0x70, 0x10, 0xEF, 0xF0, 0xD7, 0x0B, 0xE8, 0x2D, 0xBB, 0xDE, 0x09, 0x50, 0x3D, 0x0E,
  0x05, 0x40, 0x50, 0xED, 0x01, 0x40, 0x9D, 0x05, 0x60, 0x5D, 0x07, 0x40, 0xDC, 0x0D, 0x71, 0x0C,
  0xC0, 0xC3, 0x01, 0xD0, 0x87, 0x10, 0x7D, 0x30, 0x3D, 0x04, 0x71, 0x04, 0xD0, 0x22, 0x05, 0xD0,
  0x27, 0x10, 0x2D, 0x03, 0x20, 0x5D, 0x01, 0x72, 0xD0, 0x42, 0x06, 0xD0, 0x17, 0x2D, 0x04, 0x20,
  0x5D, 0x01, 0x72, 0xD0, 0x32, 0x03, 0xD0, 0x27, 0x10, 0x1D, 0x02, 0x20, 0x1D, 0x03, 0x71, 0x02,
  0xD4, 0x0E, 0xC0, 0x47, 0x10, 0x4C, 0x0C, 0x40, 0xAC, 0x07, 0x71, 0x08, 0xC0, 0x84, 0x05, 0xC0,
  0xA7, 0x10, 0xBC, 0x03, 0x50, 0xDB, 0x0E, 0x70, 0x1C, 0x0C, 0x60, 0x5C, 0x06, 0x60, 0x8C, 0x03,
  0x70, 0xAB, 0x0D, 0x01, 0x40, 0x20, 0xEB, 0x08, 0x72, 0x0C, 0xB0, 0xB3, 0x01, 0x0D, 0xB0, 0xA5,
  0x04, 0x80, 0x1A, 0xC0, 0x62, 0x07, 0xC8, 0x01, 0xA0, 0x40, 0x6F, 0xA0, 0x62, 0x08, 0xFA, 0x00,
  0x6F, 0xA0, 0x62, 0x08, 0xFA, 0x00, 0x6F, 0xA0, 0x62, 0x08, 0xFA, 0x00, 0x6F, 0xA0, 0x62, 0x08,
  0xFA, 0x06,
  // "μ" (U+03BC)
  0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C,
  0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C,
  0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x1D, 0x0C, 0xD0, 0xC7, 0x01, 0xD0,
  0xCD, 0x0C, 0x70, 0x2D, 0x0C, 0xD0, 0xD7, 0x04, 0xD0, 0xCE, 0x70, 0x9D, 0x0C, 0xE0, 0x45, 0x01,
  0x0E, 0xD0, 0xCE, 0x0C, 0x01, 0x30, 0x20, 0xCE, 0x0C, 0xF8, 0x2E, 0xBA, 0xCF, 0x90, 0xCF, 0xFD,
  0x0C, 0xFE, 0x0A, 0x06, 0xC0, 0xCF, 0xD8, 0x18, 0x01, 0xC0, 0xCF, 0x98, 0x2D, 0xC7, 0x23, 0x0B,
  0xB0, 0xCD, 0x0C, 0x77, 0xD0, 0xC7, 0x7D, 0x0C, 0x77, 0xD0, 0xC7, 0x7D, 0x0C, 0x77, 0xD0, 0xC7,
  0x7D, 0x0C, 0x77, 0xD0, 0xC7, 0x7D, 0x0C, 0x77, 0xD0, 0xC7, 0x70,
  // "π" (U+03C0)
  0x20, 0x30, 0xCF, 0xFD, 0x81, 0xA1, 0x9F, 0xFF, 0x00, 0xAF, 0xFF, 0x90, 0x0A, 0xFF, 0xF9, 0x84,
  0xA7, 0xAA, 0xAE, 0xC8, 0x3E, 0xAA, 0xAB, 0xD8, 0x3B, 0xAA, 0xA7, 0x40, 0xBC, 0x0B, 0x30, 0x2D,
  0x04, 0x71, 0x0B, 0xC0, 0xB3, 0x02, 0xD0, 0x47, 0x10, 0xBC, 0x0B, 0x30, 0x2D, 0x04, 0x71, 0x0B,
  0xC0, 0xB3, 0x02, 0xD0, 0x47, 0x10, 0xBC, 0x0B, 0x30, 0x2D, 0x04, 0x71, 0x0B, 0xC0, 0xB3, 0x02,
  0xD0, 0x47, 0x10, 0xBC, 0x0B, 0x30, 0x2D, 0x04, 0x71, 0x0B, 0xC0, 0xB3, 0x02, 0xD0, 0x47, 0x10,
  0xBC, 0x0B, 0x30, 0x2D, 0x04, 0x71, 0x0B, 0xC0, 0xB3, 0x02, 0xD0, 0x47, 0x10, 0xBC, 0x0B, 0x30,
  0x2D, 0x05, 0x71, 0x0B, 0xC0, 0xB3, 0x01, 0xD0, 0x93, 0x01, 0x40, 0xBC, 0x0B, 0x4E, 0x82, 0xCA,
  0xD9, 0x40, 0xBC, 0x0B, 0x40, 0xCF, 0x90, 0x94, 0x0B, 0xC0, 0xB4, 0x05, 0xF9, 0x09, 0x40, 0xBC,
  0x0B, 0x50, 0x9F, 0x09, 0x40, 0xBC, 0x0B, 0x68, 0x65, 0xBE, 0xFE, 0xC9, 0x30,
  // "–" (U+2013)
  0x80, 0x94, 0x98, 0x0F, 0x4F,
  // "—" (U+2014)
  0x80, 0xA4, 0x98, 0x09, 0xB4, 0xF0,
  // "€" (U+20AC)
  0x73, 0x89, 0x04, 0x8C, 0xDE, 0xFE, 0xC9, 0x57, 0x30, 0x60, 0xDF, 0xB0, 0xE0, 0x76, 0x01, 0x0C,
  0xFE, 0x08, 0x50, 0x20, 0xDF, 0xF0, 0x15, 0x0C, 0xF8, 0x3C, 0xAA, 0xBE, 0xA0, 0x95, 0x07, 0xE0,
  0x70, 0x15, 0x81, 0x38, 0x25, 0x0E, 0xD0, 0x37, 0x70, 0x5D, 0x08, 0x77, 0x10, 0x9D, 0x01, 0x75,
  0x05, 0xFF, 0xA5, 0x05, 0xFF, 0xA5, 0x05, 0xFF, 0xA7, 0x1D, 0x0A, 0x77, 0x2D, 0x09, 0x77, 0x2D,
  0x0A, 0x76, 0x05, 0xFF, 0xA5, 0x05, 0xFF, 0xA5, 0x05, 0xFF, 0xA7, 0x10, 0x8D, 0x01, 0x77, 0x10,
  0x4D, 0x06, 0x77, 0x20, 0xEC, 0x0D, 0x77, 0x20, 0x8D, 0x0A, 0x77, 0x10, 0x10, 0xED, 0x0B, 0x03,
  0x58, 0x11, 0x69, 0x60, 0x6F, 0x83, 0xDA, 0xAA, 0xCA, 0x0D, 0x70, 0x9F, 0xE0, 0xD7, 0x10, 0x8F,
  0xD0, 0xD7, 0x20, 0x30, 0xCF, 0xB0, 0xC7, 0x48, 0x91, 0x38, 0xBD, 0xEF, 0xED, 0xA6, 0x11,
  // "₿" (U+20BF)
  0x48, 0x15, 0x77, 0x38, 0x17, 0x75, 0x74, 0x81, 0xBF, 0xE3, 0xA0, 0xA7, 0x48, 0x1B, 0xFE, 0x3A,
  0x0A, 0x74, 0x81, 0xBF, 0xE3, 0xA0, 0xA7, 0x48, 0x1B, 0xFE, 0x3A, 0x0A, 0x70, 0xCF, 0xC8, 0x1D,
  0x72, 0x50, 0xCF, 0xF0, 0xB0, 0x33, 0x0C, 0xFF, 0xA0, 0x42, 0x0C, 0xFF, 0xA8, 0x2E, 0x10, 0xCC,
  0x84, 0xD9, 0x99, 0xAC, 0xF8, 0x16, 0x0C, 0xC0, 0x95, 0x02, 0x0D, 0xD8, 0x1A, 0x0C, 0xC0, 0x96,
  0x05, 0xD8, 0x1B, 0x0C, 0xC0, 0x96, 0x02, 0xD8, 0x1B, 0x0C, 0xC0, 0x96, 0x02, 0xD8, 0x19, 0x0C,
  0xC0, 0x96, 0x07, 0xD8, 0x15, 0x0C, 0xC0, 0x94, 0x01, 0x06, 0xD0, 0xD2, 0x0C, 0xFF, 0x90, 0xE0,
  0x32, 0x0C, 0xFF, 0x0B, 0x02, 0x30, 0xCF, 0xE0, 0xD0, 0x64, 0x0C, 0xFF, 0x90, 0xE0, 0x42, 0x0C,
  0xC8, 0x5D, 0x99, 0x9A, 0xBE, 0xE8, 0x13, 0x0C, 0xC0, 0x96, 0x0A, 0xD8, 0x1C, 0x0C, 0xC0, 0x96,
  0x01, 0x0E, 0xD0, 0x20, 0xCC, 0x09, 0x70, 0xBD, 0x04, 0x0C, 0xC0, 0x97, 0x0A, 0xD0, 0x50, 0xCC,
  0x09, 0x70, 0xCD, 0x05, 0x0C, 0xC0, 0x96, 0x01, 0xE0, 0x30, 0xCC, 0x09, 0x60, 0xAE, 0x10, 0xCC,
  0x85, 0xD9, 0x99, 0xAB, 0xEE, 0x81, 0x90, 0xCF, 0xFA, 0x82, 0xE1, 0x0C, 0xFF, 0x90, 0xE0, 0x42,
  0x0C, 0xFF, 0x0C, 0x02, 0x30, 0xCF, 0xC8, 0x1E, 0x83, 0x72, 0x81, 0xBF, 0xE3, 0xA0, 0xA7, 0x48,
  0x1B, 0xFE, 0x3A, 0x0A, 0x74, 0x81, 0xBF, 0xE3, 0xA0, 0xA7, 0x48, 0x1B, 0xFE, 0x3A, 0x0A, 0x70,
  // "‘" (U+2018)
  0x30, 0x8B, 0x0A, 0x30, 0xEB, 0x06, 0x20, 0x6C, 0x03, 0x20, 0xCC, 0x20, 0x2C, 0x0C, 0x20, 0x8C,
  0x09, 0x20, 0xDC, 0x81, 0x60, 0x3D, 0x81, 0x30, 0x7D, 0x20, 0xAC, 0x0D, 0x20,
  // "’" (U+2019)
  0x20, 0xBD, 0x20, 0xDC, 0x0C, 0x2D, 0x81, 0x80, 0x3D, 0x81, 0x30, 0x6C, 0x0D, 0x20, 0x9C, 0x07,
  0x20, 0xCC, 0x02, 0x2C, 0x0B, 0x20, 0x4C, 0x04, 0x20, 0x7B, 0x0D, 0x30,
  // "‚" (U+201A)
  0x20, 0x2D, 0x09, 0x20, 0x4D, 0x06, 0x20, 0x7D, 0x02, 0x20, 0x9C, 0x0D, 0x30, 0xCC, 0x09, 0x30,
  0xEC, 0x04, 0x20, 0x2D, 0x30, 0x5C, 0x0B, 0x30, 0x7C, 0x06, 0x30, 0xAC, 0x01, 0x30, 0xDB, 0x0A,
  0x30, 0x1C, 0x03, 0x30,
  // "‛" (U+201B)
  0x0A, 0xC0, 0xD2, 0x07, 0xD2, 0x03, 0xD0, 0x32, 0x0D, 0xC0, 0x62, 0x08, 0xC0, 0x92, 0x02, 0xC0,
  0xC3, 0x0C, 0xC3, 0x06, 0xC0, 0x33, 0x0E, 0xB0, 0x63, 0x08, 0xB0, 0xA0,
  // "“" (U+201C)
  0x30, 0x8B, 0x0A, 0x30, 0x8B, 0x0A, 0x30, 0xEB, 0x06, 0x30, 0xEB, 0x06, 0x20, 0x6C, 0x03, 0x20,
  0x6C, 0x03, 0x20, 0xCC, 0x30, 0xCC, 0x20, 0x2C, 0x0C, 0x20, 0x2C, 0x0C, 0x20, 0x8C, 0x09, 0x20,
  0x8C, 0x09, 0x20, 0xDC, 0x06, 0x20, 0xDC, 0x81, 0x60, 0x3D, 0x81, 0x30, 0x3D, 0x81, 0x30, 0x7D,
  0x20, 0x7D, 0x20, 0xAC, 0x0D, 0x20, 0xAC, 0x0D, 0x20,
  // "”" (U+201D)
  0x20, 0xDC, 0x0A, 0x20, 0xDC, 0x0A, 0x2D, 0x07, 0x2D, 0x81, 0x70, 0x3D, 0x81, 0x30, 0x3D, 0x81,
  0x30, 0x6C, 0x0D, 0x20, 0x6C, 0x0D, 0x20, 0x9C, 0x08, 0x20, 0x9C, 0x08, 0x20, 0xCC, 0x02, 0x20,
  0xCC, 0x02, 0x2C, 0x0C, 0x3C, 0x0C, 0x20, 0x3C, 0x06, 0x20, 0x3C, 0x06, 0x20, 0x6B, 0x0E, 0x30,
  0x6B, 0x0E, 0x30, 0xAB, 0x08, 0x30, 0xAB, 0x08, 0x30,
  // "„" (U+201E)
  0x20, 0x2D, 0x81, 0x90, 0x2D, 0x09, 0x20, 0x4D, 0x81, 0x60, 0x4D, 0x06, 0x20, 0x7D, 0x81, 0x20,
  0x7D, 0x02, 0x20, 0x9C, 0x0D, 0x20, 0x9C, 0x0D, 0x30, 0xCC, 0x09, 0x20, 0xCC, 0x09, 0x30, 0xEC,
  0x04, 0x20, 0xEC, 0x04, 0x20, 0x2D, 0x20, 0x2D, 0x30, 0x5C, 0x0B, 0x20, 0x5C, 0x0B, 0x30, 0x7C,
  0x06, 0x20, 0x7C, 0x06, 0x30, 0xAC, 0x01, 0x20, 0xAC, 0x01, 0x30, 0xDB, 0x0A, 0x30, 0xDB, 0x0A,
  0x30, 0x1C, 0x03, 0x20, 0x1C, 0x03, 0x30,
  // "‟" (U+201F)
  0x0A, 0xC0, 0xD2, 0x0A, 0xC0, 0xD2, 0x07, 0xD2, 0x07, 0xD2, 0x03, 0xD8, 0x13, 0x03, 0xD0, 0x32,
  0x0D, 0xC0, 0x62, 0x0D, 0xC0, 0x62, 0x08, 0xC0, 0x92, 0x08, 0xC0, 0x92, 0x02, 0xC0, 0xC2, 0x02,
  0xC0, 0xC3, 0x0C, 0xC3, 0x0C, 0xC3, 0x06, 0xC0, 0x32, 0x06, 0xC0, 0x33, 0x0E, 0xB0, 0x63, 0x0E,
  0xB0, 0x63, 0x08, 0xB0, 0xA3, 0x08, 0xB0, 0xA0,
  // "†" (U+2020)
  0x50, 0xCC, 0x05, 0x73, 0x0A, 0xC0, 0x37, 0x30, 0x8C, 0x01, 0x73, 0x06, 0xC7, 0x40, 0x4B, 0x0D,
  0x74, 0x02, 0xB0, 0xB7, 0x5B, 0x09, 0x60, 0x20, 0x14, 0x0E, 0xA0, 0x74, 0x81, 0x12, 0xEA, 0x82,
  0xEC, 0xBE, 0xA8, 0x2C, 0xBD, 0xEA, 0x0D, 0x0E, 0xFF, 0x0D, 0x0E, 0xFF, 0x0D, 0x0E, 0xA8, 0x2E,
  0xCB, 0xEA, 0x82, 0xCB, 0xDE, 0xA8, 0x1D, 0x21, 0x40, 0xDA, 0x06, 0x40, 0x10, 0x26, 0x0E, 0xA0,
  0x77, 0x50, 0xEA, 0x08, 0x75, 0xB0, 0x97, 0x40, 0x1B, 0x09, 0x74, 0x02, 0xB0, 0xA7, 0x40, 0x2B,
  0x0B, 0x74, 0x03, 0xB0, 0xC7, 0x40, 0x4B, 0x0D, 0x74, 0x05, 0xB0, 0xE7, 0x40, 0x6C, 0x74, 0x07,
  0xC7, 0x40, 0x8C, 0x01, 0x73, 0x09, 0xC0, 0x27, 0x30, 0xAC, 0x03, 0x73, 0x0A, 0xC0, 0x47, 0x30,
  0xBC, 0x05, 0x73, 0x0C, 0xC0, 0x65,
  // "‡" (U+2021)
  0x60, 0x9C, 0x08, 0x75, 0x07, 0xC0, 0x67, 0x50, 0x5C, 0x04, 0x75, 0x02, 0xC0, 0x27, 0x6C, 0x77,
  0x0D, 0xA0, 0xD7, 0x70, 0xBA, 0x0B, 0x78, 0x61, 0xFD, 0xCB, 0x98, 0xCA, 0x87, 0xC8, 0x9B, 0xCD,
  0xF1, 0x1F, 0xFA, 0x00, 0x1F, 0xFA, 0x00, 0x1D, 0x00, 0xEA, 0x00, 0xED, 0x84, 0x10, 0x54, 0x31,
  0x20, 0xBA, 0x0A, 0x28, 0x21, 0x34, 0x67, 0x10, 0xEA, 0x0E, 0x76, 0x02, 0xC0, 0x27, 0x50, 0x6C,
  0x05, 0x75, 0x06, 0xC0, 0x67, 0x50, 0x3C, 0x02, 0x76, 0xB0, 0xE7, 0x70, 0xCA, 0x0B, 0x78, 0x61,
  0xFE, 0xDB, 0xA8, 0xCA, 0x87, 0xC8, 0xAB, 0xDE, 0xF1, 0x1F, 0xFA, 0x00, 0x1F, 0xFA, 0x00, 0x1D,
  0x0D, 0x0E, 0xA0, 0xE0, 0xDD, 0x84, 0x10, 0x54, 0x21, 0x20, 0xAA, 0x0A, 0x28, 0x21, 0x24, 0x57,
  0x10, 0xDA, 0x0C, 0x77, 0xB0, 0xE7, 0x60, 0x2C, 0x01, 0x75, 0x04, 0xC0, 0x47, 0x50, 0x7C, 0x06,
  0x75, 0x09, 0xC0, 0x86,
  // "•" (U+2022)
  0x38, 0x47, 0xCE, 0xEC, 0x74, 0x01, 0x0D, 0xE0, 0xD0, 0x12, 0x0B, 0xF9, 0x81, 0xB0, 0x2F, 0xB0,
  0x20, 0x5F, 0xB0, 0x50, 0x7F, 0xB0, 0x07, 0xFB, 0x06, 0x05, 0xFB, 0x05, 0x02, 0xFB, 0x81, 0x20,
  0xBF, 0x90, 0xB2, 0x01, 0x0D, 0xE0, 0xD0, 0x14, 0x84, 0x7C, 0xEE, 0xC7, 0x30,
  // "…" (U+2026)
  0x18, 0x43, 0xBE, 0xEB, 0x22, 0x84, 0x3B, 0xEE, 0xB2, 0x28, 0x63, 0xBE, 0xEB, 0x20, 0x2D, 0x81,
  0xE1, 0x2D, 0x81, 0xE1, 0x2D, 0x81, 0xE1, 0x7E, 0x06, 0x07, 0xE0, 0x60, 0x7E, 0x06, 0x09, 0xE0,
  0x80, 0x9E, 0x08, 0x09, 0xE0, 0x80, 0x7E, 0x06, 0x07, 0xE0, 0x60, 0x7E, 0x81, 0x61, 0xEC, 0x82,
  0xE1, 0x1E, 0xC8, 0x2E, 0x11, 0xEC, 0x87, 0xE1, 0x03, 0xBE, 0xEA, 0x22, 0x84, 0x3B, 0xEE, 0xA2,
  0x28, 0x43, 0xBE, 0xEA, 0x21,
  // "‰" (U+2030)
  0x28, 0x43, 0xBE, 0xEB, 0x47, 0x73, 0x03, 0x0E, 0xD0, 0x47, 0x72, 0x0B, 0xE0, 0xD7, 0x71, 0x01,
  0xB0, 0x60, 0x3B, 0x03, 0x77, 0x03, 0xB8, 0x11, 0x0E, 0xA0, 0x67, 0x70, 0x4B, 0x20, 0xDA, 0x07,
  0x77, 0x03, 0xB8, 0x11, 0x0E, 0xA0, 0x65, 0x80, 0x01, 0x6B, 0x06, 0x03, 0xB0, 0x33, 0x05, 0x0E,
  0xA0, 0xE0, 0x56, 0x0B, 0xE0, 0xE3, 0x09, 0xB0, 0xB0, 0x17, 0x02, 0x0E, 0xD8, 0x25, 0x03, 0xDB,
  0x07, 0x73, 0x86, 0x2B, 0xEE, 0xC4, 0x07, 0xB0, 0xD0, 0x37, 0x72, 0x02, 0x0C, 0xB0, 0x97, 0x73,
  0x05, 0x0E, 0xA0, 0xE0, 0x57, 0x72, 0x01, 0x0A, 0xB0, 0xB0, 0x17, 0x72, 0x03, 0x0D, 0xB0, 0x77,
  0x73, 0x08, 0xB0, 0xD0, 0x37, 0x73, 0x89, 0x16, 0xAA, 0xA8, 0x17, 0xDF, 0xD7, 0x48, 0x44, 0xCE,
  0xEA, 0x17, 0x10, 0xAD, 0x09, 0x20, 0x4D, 0x0D, 0x01, 0x60, 0x3F, 0x81, 0x30, 0xDE, 0x09, 0x60,
  0x8A, 0x81, 0xD1, 0xCA, 0x09, 0x03, 0xB0, 0x40, 0x7A, 0x0E, 0x60, 0xBA, 0x81, 0x90, 0x7A, 0x0C,
  0x06, 0xA8, 0x1E, 0x02, 0xB0, 0x25, 0x0C, 0xA8, 0x17, 0x06, 0xA0, 0xD0, 0x7A, 0x81, 0xC0, 0x1B,
  0x03, 0x50, 0xCA, 0x81, 0x70, 0x6A, 0x0D, 0x07, 0xA8, 0x1C, 0x01, 0xB0, 0x35, 0x0B, 0xA8, 0x19,
  0x07, 0xA0, 0xC0, 0x5A, 0x81, 0xE0, 0x2B, 0x02, 0x50, 0x8A, 0x81, 0xD1, 0xCA, 0x09, 0x02, 0xB0,
  0x40, 0x7A, 0x0E, 0x60, 0x3F, 0x81, 0x40, 0xCE, 0x09, 0x70, 0x9D, 0x0A, 0x20, 0x3D, 0x0E, 0x01,
  0x71, 0x83, 0x7D, 0xFD, 0x74, 0x84, 0x3B, 0xFE, 0xA2, 0x20,
  // "‹" (U+2039)
  0x70, 0xA0, 0x67, 0x20, 0x9A, 0x0D, 0x05, 0x60, 0x7D, 0x05, 0x40, 0x4D, 0x0A, 0x40, 0x20, 0xEC,
  0x0C, 0x50, 0xDC, 0x0E, 0x02, 0x40, 0xBD, 0x04, 0x40, 0x8D, 0x07, 0x40, 0x5D, 0x0A, 0x50, 0x7D,
  0x08, 0x60, 0xAD, 0x05, 0x60, 0xCC, 0x0E, 0x02, 0x50, 0x20, 0xEC, 0x0D, 0x01, 0x50, 0x4D, 0x0B,
  0x60, 0x6D, 0x08, 0x60, 0x9D, 0x04, 0x60, 0xBA, 0x0E, 0x08, 0x78, 0x21, 0xD9, 0x12,
  // "›" (U+203A)
  0x28, 0x21, 0x9D, 0x17, 0x07, 0x0E, 0xA0, 0xB6, 0x04, 0xD0, 0x96, 0x08, 0xD0, 0x66, 0x0B, 0xD0,
  0x35, 0x01, 0x0D, 0xC0, 0xE0, 0x25, 0x02, 0x0E, 0xC0, 0xC6, 0x05, 0xD0, 0xA6, 0x08, 0xD0, 0x75,
  0x0A, 0xD0, 0x54, 0x07, 0xD0, 0x84, 0x04, 0xD0, 0xB4, 0x02, 0x0E, 0xC0, 0xD5, 0x0C, 0xC0, 0xE0,
  0x24, 0x0A, 0xD0, 0x44, 0x05, 0xD0, 0x66, 0x05, 0x0D, 0xA0, 0x97, 0x20, 0x60, 0xB7,
  // "⁄" (U+2044)
  0x74, 0x07, 0xB0, 0xC7, 0x40, 0xDB, 0x05, 0x73, 0x05, 0xB0, 0xE7, 0x40, 0xBB, 0x08, 0x73, 0x02,
  0xC0, 0x27, 0x30, 0x9B, 0x0A, 0x74, 0x0E, 0xB0, 0x47, 0x30, 0x6B, 0x0D, 0x74, 0x0D, 0xB0, 0x77,
  0x30, 0x4B, 0x0E, 0x01, 0x73, 0x0A, 0xB0, 0x97, 0x30, 0x1C, 0x03, 0x73, 0x07, 0xB0, 0xC7, 0x40,
  0xEB, 0x05, 0x73, 0x05, 0xB0, 0xE7, 0x40, 0xBB, 0x08, 0x73, 0x02, 0xC0, 0x17, 0x30, 0x9B, 0x0A,
  0x73, 0x01, 0x0E, 0xB0, 0x47, 0x30, 0x6B, 0x0D, 0x74, 0x0D, 0xB0, 0x67, 0x30, 0x4B, 0x0E, 0x01,
  0x73, 0x0A, 0xB0, 0x97, 0x30, 0x1C, 0x03, 0x73, 0x08, 0xB0, 0xB7, 0x40, 0xEB, 0x05, 0x73, 0x05,
  0xB0, 0xE7, 0x40, 0xCB, 0x08, 0x74,
  // "™" (U+2122)
  0x80, 0x5A, 0x85, 0x90, 0xAA, 0xAA, 0x23, 0x02, 0x80, 0x0A, 0xFA, 0x0D, 0x01, 0xC0, 0x73, 0x08,
  0xFE, 0x0D, 0x01, 0xC0, 0xC3, 0x0D, 0xC3, 0x05, 0xA0, 0x83, 0x01, 0xA0, 0xEA, 0x81, 0x20, 0x3A,
  0x0E, 0xA3, 0x05, 0xA0, 0x83, 0x01, 0xA8, 0x7A, 0xEF, 0x70, 0x9F, 0xAD, 0xA3, 0x05, 0xA0, 0x83,
  0x01, 0xA8, 0x7A, 0x9F, 0xC0, 0xEF, 0x5E, 0xA3, 0x05, 0xA0, 0x83, 0x01, 0xA0, 0xB0, 0x4A, 0x83,
  0x6F, 0xE0, 0xEA, 0x30, 0x5A, 0x08, 0x30, 0x1A, 0x87, 0xB0, 0xEF, 0xEF, 0xA0, 0xEA, 0x30, 0x5A,
  0x08, 0x30, 0x1A, 0x81, 0xB0, 0xAB, 0x81, 0x40, 0xEA, 0x30, 0x5A, 0x08, 0x30, 0x1A, 0x81, 0xB0,
  0x5A, 0x0E, 0x20, 0xEA, 0x30, 0x5A, 0x08, 0x30, 0x1A, 0x0B, 0x28, 0x19, 0x96, 0x20, 0xEA, 0x30,
  0x5A, 0x08, 0x30, 0x1A, 0x0B, 0x70, 0xEA, 0x30, 0x5A, 0x08, 0x30, 0x1A, 0x0B, 0x70, 0xEA, 0x30,
  0x5A, 0x08, 0x30, 0x1A, 0x0B, 0x70, 0xEA,
  // "⅒" (U+2152)
  0x40, 0x30, 0xDA, 0x0A, 0x80, 0xD3, 0x00, 0x8C, 0x0A, 0x77, 0x07, 0xB0, 0xC7, 0x77, 0x50, 0x30,
  0xDD, 0x0A, 0x77, 0x0D, 0xB0, 0x57, 0x77, 0x40, 0x8F, 0x0A, 0x76, 0x05, 0xB0, 0xE7, 0x77, 0x50,
  0xCB, 0x0B, 0xB0, 0xA7, 0x60, 0xBB, 0x08, 0x77, 0x75, 0x83, 0x3F, 0xE6, 0x1B, 0x0A, 0x75, 0x02,
  0xC0, 0x27, 0x77, 0x68, 0x25, 0x10, 0x1B, 0x0A, 0x75, 0x09, 0xB0, 0xA7, 0x77, 0x73, 0x02, 0xB0,
  0xA7, 0x50, 0xEB, 0x04, 0x77, 0x77, 0x30, 0x2B, 0x0A, 0x74, 0x06, 0xB0, 0xD7, 0x77, 0x74, 0x02,
  0xB0, 0xA7, 0x40, 0xDB, 0x07, 0x77, 0x77, 0x40, 0x2B, 0x0A, 0x73, 0x04, 0xB0, 0xE0, 0x17, 0x77,
  0x74, 0x02, 0xB0, 0xA7, 0x30, 0xAB, 0x09, 0x77, 0x77, 0x50, 0x2B, 0x0A, 0x72, 0x01, 0xC0, 0x35,
  0x03, 0x0D, 0xA0, 0xA7, 0x18, 0x63, 0x9D, 0xFE, 0xC8, 0x17, 0x02, 0xB0, 0xA7, 0x20, 0x7B, 0x0C,
  0x50, 0x8C, 0x0A, 0x70, 0x8F, 0x0E, 0x04, 0x28, 0x31, 0x8A, 0xBD, 0xC8, 0x2C, 0xB9, 0x55, 0x0E,
  0xB0, 0x53, 0x03, 0x0D, 0xD0, 0xA6, 0x06, 0xFB, 0x81, 0x30, 0x2F, 0xC0, 0x94, 0x05, 0xB0, 0xE3,
  0x08, 0xF0, 0xA6, 0x0E, 0xB8, 0x2C, 0x66, 0xCB, 0x81, 0xD0, 0x2F, 0xC0, 0x94, 0x0B, 0xB0, 0x83,
  0x0C, 0xB0, 0xBB, 0x0A, 0x50, 0x5B, 0x0C, 0x40, 0xBB, 0x04, 0x77, 0x20, 0x2C, 0x01, 0x38, 0x33,
  0xFE, 0x61, 0xB0, 0xA5, 0x0A, 0xB0, 0x54, 0x03, 0xB0, 0x97, 0x72, 0x09, 0xB0, 0xA5, 0x82, 0x51,
  0x01, 0xB0, 0xA5, 0x0C, 0xB0, 0x15, 0x0E, 0xA0, 0xC7, 0x71, 0x01, 0x0E, 0xB0, 0x47, 0x10, 0x2B,
  0x0A, 0x50, 0xEB, 0x60, 0xDA, 0x0E, 0x77, 0x10, 0x6B, 0x0D, 0x72, 0x02, 0xB0, 0xA5, 0xB0, 0xE6,
  0x0C, 0xB7, 0x71, 0x0D, 0xB0, 0x67, 0x20, 0x2B, 0x0A, 0x5B, 0x0E, 0x60, 0xCB, 0x77, 0x04, 0xB0,
  0xE0, 0x17, 0x20, 0x2B, 0x0A, 0x50, 0xEB, 0x60, 0xDA, 0x0E, 0x77, 0x0A, 0xB0, 0x97, 0x30, 0x2B,
  0x0A, 0x50, 0xCB, 0x01, 0x5B, 0x0C, 0x76, 0x01, 0xC0, 0x37, 0x30, 0x2B, 0x0A, 0x50, 0x9B, 0x05,
  0x40, 0x4B, 0x09, 0x76, 0x08, 0xB0, 0xB7, 0x40, 0x2B, 0x0A, 0x50, 0x4B, 0x0C, 0x40, 0xCB, 0x04,
  0x76, 0x0E, 0xB0, 0x57, 0x83, 0x18, 0xAB, 0xDC, 0x82, 0xCB, 0x95, 0x20, 0xDB, 0x82, 0xC6, 0x6C,
  0xB0, 0xD7, 0x60, 0x5B, 0x0E, 0x71, 0x02, 0xFC, 0x09, 0x20, 0x4F, 0xB0, 0x47, 0x60, 0xCB, 0x08,
  0x71, 0x02, 0xFC, 0x09, 0x30, 0x5F, 0x90, 0x68, 0x0D, 0x00, 0x86, 0x28, 0xDE, 0xED, 0x92, 0x30,
  // "∂" (U+2202)
  0x78, 0x61, 0x58, 0x99, 0x86, 0x17, 0x30, 0x50, 0xBF, 0x90, 0x90, 0x17, 0x05, 0xFC, 0x0D, 0x01,
  0x60, 0x5F, 0xD0, 0xC6, 0x05, 0xFE, 0x06, 0x50, 0x5A, 0x84, 0xA4, 0x10, 0x3C, 0xD0, 0xD5, 0x81,
  0x5C, 0x36, 0x0B, 0xD0, 0x34, 0x02, 0x71, 0x02, 0xD0, 0x77, 0x70, 0xDC, 0x09, 0x71, 0x82, 0x23,
  0x31, 0x20, 0xAC, 0x0B, 0x58, 0x11, 0x8E, 0xC8, 0x1C, 0x39, 0xC0, 0xC4, 0x04, 0x0E, 0xF0, 0xE0,
  0xBC, 0x0D, 0x30, 0x5F, 0xF9, 0x0C, 0x20, 0x20, 0xEF, 0xF9, 0x0C, 0x20, 0xCD, 0x83, 0xD5, 0x11,
  0x6E, 0x81, 0xB0, 0x5D, 0x0D, 0x01, 0x40, 0x6D, 0x81, 0x90, 0xCD, 0x03, 0x50, 0x2D, 0x06, 0x02,
  0xD0, 0xA6, 0x05, 0xD0, 0x30, 0x6D, 0x04, 0x60, 0x9D, 0x10, 0x9D, 0x70, 0xEC, 0x81, 0xB0, 0xCC,
  0x0D, 0x60, 0x4D, 0x81, 0x60, 0xDC, 0x0B, 0x60, 0xBD, 0x81, 0x10, 0xDC, 0x0B, 0x50, 0x4D, 0x09,
  0x20, 0xCC, 0x0C, 0x40, 0x10, 0xDD, 0x02, 0x20, 0x9D, 0x03, 0x20, 0x10, 0xCD, 0x08, 0x30, 0x5D,
  0x82, 0xEA, 0xAE, 0xD0, 0xD5, 0x0D, 0xFD, 0x0E, 0x02, 0x50, 0x4F, 0xC0, 0xD0, 0x27, 0x05, 0xFA,
  0x09, 0x73, 0x87, 0x28, 0xCE, 0xFE, 0xC8, 0x27, 0x10,
  // "∆" (U+2206)
  0x71, 0x06, 0xE0, 0x67, 0x72, 0x0B, 0xE0, 0xC7, 0x71, 0x01, 0xF9, 0x01, 0x77, 0x06, 0xF9, 0x07,
  0x77, 0x0B, 0xB0, 0x0E, 0xB0, 0xC7, 0x60, 0x1C, 0x00, 0xBC, 0x01, 0x75, 0x06, 0xC0, 0x07, 0xC0,
  0x77, 0x50, 0xBC, 0x00, 0x3C, 0x0C, 0x74, 0x01, 0xC0, 0xD2, 0x0D, 0xC0, 0x17, 0x30, 0x6C, 0x09,
  0x20, 0x9C, 0x07, 0x73, 0x0C, 0xC0, 0x42, 0x04, 0xC0, 0xC7, 0x20, 0x1C, 0x0E, 0x40, 0xEC, 0x01,
  0x71, 0x06, 0xC0, 0xA4, 0x0A, 0xC0, 0x77, 0x10, 0xCC, 0x05, 0x40, 0x5C, 0x0C, 0x70, 0x1D, 0x01,
  0x40, 0x1D, 0x02, 0x60, 0x7C, 0x0B, 0x60, 0xBC, 0x07, 0x60, 0xCC, 0x07, 0x60, 0x6C, 0x0C, 0x50,
  0x2D, 0x02, 0x60, 0x1D, 0x02, 0x40, 0x7C, 0x0D, 0x71, 0x0C, 0xC0, 0x74, 0x0C, 0xC0, 0x87, 0x10,
  0x7C, 0x0C, 0x30, 0x2D, 0x03, 0x71, 0x03, 0xD0, 0x22, 0x07, 0xC0, 0xE7, 0x30, 0xDC, 0x07, 0x20,
  0xCC, 0x09, 0x73, 0x08, 0xC8, 0x1C, 0x02, 0xD0, 0xC8, 0x06, 0xA0, 0xCD, 0x02, 0x07, 0xFF, 0xF9,
  0x07, 0x09, 0xFF, 0xF9, 0x00, 0x9F, 0xFF, 0x90, 0x09, 0xFF, 0xF9, 0x09,
  // "√" (U+221A)
  0x77, 0x40, 0x6C, 0x03, 0x77, 0x40, 0xAB, 0x0D, 0x77, 0x50, 0xEB, 0x08, 0x77, 0x40, 0x4C, 0x04,
  0x77, 0x40, 0x9B, 0x0E, 0x77, 0x50, 0xEB, 0x09, 0x77, 0x40, 0x3C, 0x04, 0x77, 0x40, 0x8B, 0x0E,
  0x77, 0x50, 0xDB, 0x0A, 0x77, 0x40, 0x2C, 0x05, 0x77, 0x40, 0x7C, 0x01, 0x77, 0x40, 0xBB, 0x0B,
  0x77, 0x40, 0x1C, 0x06, 0x77, 0x40, 0x5C, 0x01, 0x77, 0x40, 0xAB, 0x0C, 0x50, 0x78, 0x01, 0x90,
  0x67, 0x0E, 0xB0, 0x75, 0x0B, 0xD0, 0xE6, 0x04, 0xC0, 0x25, 0x0B, 0xE0, 0x45, 0x09, 0xB0, 0xD6,
  0x0B, 0xE0, 0xA5, 0x0D, 0xB0, 0x86, 0x0B, 0xE0, 0xE4, 0x03, 0xC0, 0x37, 0x20, 0x2C, 0x05, 0x30,
  0x8B, 0x0E, 0x74, 0x0B, 0xB0, 0xB3, 0x0C, 0xB0, 0x97, 0x40, 0x5C, 0x81, 0x10, 0x1C, 0x04, 0x75,
  0x0E, 0xB8, 0x17, 0x06, 0xB0, 0xE7, 0x60, 0x9B, 0x81, 0xC0, 0xBB, 0x0A, 0x76, 0x03, 0xC0, 0x3C,
  0x05, 0x77, 0x0D, 0xB0, 0xDC, 0x77, 0x10, 0x7F, 0x0B, 0x77, 0x10, 0x1F, 0x06, 0x77, 0x20, 0xBE,
  0x01, 0x77, 0x20, 0x5D, 0x0C, 0x77, 0x40, 0xEC, 0x07, 0x77, 0x40, 0x9C, 0x02, 0x77, 0x40, 0x3B,
  0x0D, 0x74,
  // "∞" (U+221E)
  0x38, 0x44, 0xBE, 0xFC, 0x76, 0x84, 0x6C, 0xEE, 0xB4, 0x50, 0x8E, 0x0D, 0x02, 0x20, 0x10, 0xBE,
  0x08, 0x30, 0x5F, 0x98, 0x2E, 0x20, 0xCF, 0x90, 0x62, 0x0E, 0xC0, 0xDC, 0x0D, 0x0B, 0xC0, 0xDC,
  0x81, 0xE0, 0x4B, 0x83, 0xE2, 0x02, 0xDE, 0x83, 0xC1, 0x02, 0xEB, 0x04, 0x07, 0xB0, 0x73, 0x01,
  0x0D, 0xC0, 0xD0, 0x13, 0x08, 0xB0, 0x60, 0x8B, 0x05, 0x40, 0x5C, 0x05, 0x40, 0x6B, 0x00, 0x7B,
  0x07, 0x40, 0xCC, 0x0D, 0x40, 0x8B, 0x06, 0x04, 0xB8, 0x3E, 0x20, 0x1B, 0xE8, 0x3B, 0x10, 0x3E,
  0xB8, 0x13, 0x0E, 0xC0, 0xDC, 0x0D, 0xD0, 0xDC, 0x0D, 0x20, 0x6F, 0x98, 0x1D, 0x16, 0xFA, 0x04,
  0x30, 0x8E, 0x0D, 0x02, 0x20, 0x7F, 0x06, 0x58, 0x44, 0xAE, 0xFD, 0x75, 0x85, 0x4B, 0xEF, 0xDA,
  0x33,
  // "≈" (U+2248)
  0x28, 0x51, 0x58, 0x98, 0x61, 0x73, 0x82, 0x30, 0x5E, 0xE0, 0xA0, 0x47, 0x81, 0x89, 0x6F, 0xB8,
  0x90, 0xD7, 0x20, 0x15, 0xCF, 0x9A, 0xFF, 0xC0, 0x90, 0xAF, 0xFC, 0x89, 0x09, 0xAF, 0xC4, 0x10,
  0x27, 0xDF, 0xB8, 0x15, 0xA8, 0x70, 0x50, 0xBE, 0x82, 0xE5, 0x03, 0x73, 0x84, 0x26, 0x99, 0x85,
  0x58, 0x52, 0x68, 0x99, 0x73, 0x73, 0x81, 0x41, 0xAF, 0x81, 0xE9, 0x45, 0x82, 0x4C, 0x9A, 0xFD,
  0x82, 0xCA, 0xAD, 0xA0, 0x90, 0xAF, 0xFC, 0x09, 0x0A, 0xFF, 0xC8, 0x91, 0x9A, 0xF9, 0x31, 0x02,
  0x5A, 0xEF, 0x98, 0x2E, 0x48, 0x37, 0x18, 0x75, 0x9D, 0xEF, 0xEC, 0x71, 0x10,
  // "≠" (U+2260)
  0x75, 0x01, 0x77, 0x48, 0x21, 0xFB, 0x57, 0x72, 0x07, 0xB0, 0xE0, 0x47, 0x70, 0xCC, 0x01, 0x76,
  0x03, 0xC0, 0xA7, 0x70, 0x9C, 0x04, 0x40, 0x3F, 0xFC, 0x00, 0x3F, 0xFC, 0x00, 0x3F, 0xFC, 0x00,
  0x3F, 0xFC, 0x03, 0x02, 0x80, 0x3C, 0x0E, 0xC0, 0xD8, 0x01, 0xC0, 0x27, 0x10, 0xDB, 0x0E, 0x77,
  0x03, 0xC0, 0x97, 0x70, 0xAC, 0x03, 0x70, 0x28, 0x02, 0xCD, 0x80, 0x3C, 0x02, 0x03, 0xFF, 0xC0,
  0x03, 0xFF, 0xC0, 0x03, 0xFF, 0xC0, 0x03, 0xFF, 0xC0, 0x35, 0x0E, 0xB0, 0xE7, 0x70, 0x4C, 0x08,
  0x77, 0x0A, 0xC0, 0x27, 0x70, 0x60, 0xCA, 0x0C, 0x77, 0x38, 0x12, 0x85, 0x74,
  // "≤" (U+2264)
  0x77, 0x40, 0x60, 0x97, 0x72, 0x82, 0x6E, 0xFA, 0x77, 0x06, 0x0E, 0xB0, 0xA7, 0x50, 0x60, 0xED,
  0x0A, 0x73, 0x06, 0x0E, 0xE0, 0xE0, 0x67, 0x10, 0x60, 0xEE, 0x81, 0xE7, 0x17, 0x06, 0x0E, 0xE0,
  0xD0, 0x67, 0x10, 0x60, 0xDE, 0x0C, 0x05, 0x71, 0x06, 0x0D, 0xE0, 0xB0, 0x47, 0x10, 0x50, 0xDE,
  0x0A, 0x03, 0x73, 0x09, 0xD0, 0xB0, 0x27, 0x50, 0x9E, 0x0A, 0x03, 0x74, 0x05, 0x0D, 0xF0, 0xC0,
  0x67, 0x40, 0x40, 0xBF, 0x81, 0xE9, 0x27, 0x30, 0x20, 0x9F, 0x90, 0xB0, 0x57, 0x38, 0x11, 0x7E,
  0xF8, 0x1E, 0x82, 0x73, 0x06, 0x0C, 0xF9, 0x08, 0x74, 0x04, 0x0B, 0xE0, 0xA7, 0x68, 0x12, 0x9E,
  0xB0, 0xA7, 0x71, 0x83, 0x17, 0xDF, 0xA7, 0x74, 0x05, 0x07, 0x80, 0xA0, 0x10, 0x9F, 0xFC, 0x0A,
  0x09, 0xFF, 0xC0, 0xA0, 0x9F, 0xFC, 0x0A, 0x09, 0xFF, 0xC0, 0xA0,
  // "≥" (U+2265)
  0x09, 0x07, 0x77, 0x48, 0x2A, 0xFE, 0x67, 0x72, 0x0A, 0xB0, 0xE0, 0x67, 0x70, 0xAD, 0x0E, 0x06,
  0x75, 0x06, 0x0E, 0xE0, 0xE0, 0x67, 0x48, 0x11, 0x7E, 0xE0, 0xE0, 0x67, 0x50, 0x60, 0xDE, 0x0E,
  0x06, 0x75, 0x05, 0x0C, 0xE0, 0xD0, 0x67, 0x50, 0x40, 0xBE, 0x0D, 0x06, 0x75, 0x03, 0x0A, 0xE0,
  0xD0, 0x57, 0x50, 0x20, 0xBD, 0x09, 0x74, 0x03, 0x0A, 0xE0, 0x97, 0x20, 0x60, 0xCF, 0x0D, 0x05,
  0x68, 0x12, 0x9E, 0xF0, 0xB0, 0x46, 0x05, 0x0B, 0xF9, 0x09, 0x02, 0x58, 0x12, 0x8E, 0xF8, 0x1E,
  0x71, 0x60, 0x8F, 0x90, 0xC0, 0x67, 0x20, 0xAE, 0x0B, 0x04, 0x74, 0x0A, 0xB8, 0x1E, 0x92, 0x76,
  0x83, 0xAF, 0xD7, 0x17, 0x71, 0x07, 0x05, 0x77, 0x48, 0x0A, 0x01, 0x0A, 0xFF, 0xC0, 0x90, 0xAF,
  0xFC, 0x09, 0x0A, 0xFF, 0xC0, 0x90, 0xAF, 0xFC, 0x09,
};

const Font& font_NotoSansMono_Bold_40() {
  static SmoothFont font(font_NotoSansMono_Bold_40_data);
  return font;
}

}  // namespace roo_display
