#include "10.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSansMono-Bold (Noto Sans Mono Bold)
// Generated on Wed Nov 19 19:10:56 CET 2025
static const uint8_t font_NotoSansMono_Bold_10_data[] PROGMEM = {
  
  // Header
  0x01, 0x02, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x5D, 0x00, 0x00,
  0xFE, 0xFE, 0x0F, 0x0B, 0x08, 0xFD, 0x03, 0x00, 0x12, 0x04, 0x06, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x42, 0x01, 0x03, 0x08, 0x06, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x41, 0x06, 0x04, 0x08, 0x06, 0x00, 0x08, // """ (U+0022)
  0x00, 0x23, 0x40, 0x01, 0x05, 0x08, 0x06, 0x00, 0x0E, // "#" (U+0023)
  0x00, 0x24, 0x40, 0x00, 0x05, 0x08, 0x06, 0x00, 0x26, // "$" (U+0024)
  0x00, 0x25, 0x40, 0x01, 0x05, 0x08, 0x06, 0x00, 0x41, // "%" (U+0025)
  0x00, 0x26, 0x40, 0x01, 0x05, 0x08, 0x06, 0x00, 0x59, // "&" (U+0026)
  0x00, 0x27, 0x42, 0x06, 0x03, 0x08, 0x06, 0x00, 0x71, // "'" (U+0027)
  0x00, 0x28, 0x41, 0x00, 0x04, 0x08, 0x06, 0x00, 0x74, // "(" (U+0028)
  0x00, 0x29, 0x41, 0xFE, 0x04, 0x06, 0x06, 0x00, 0x86, // ")" (U+0029)
  0x00, 0x2A, 0x40, 0x04, 0x05, 0x08, 0x06, 0x00, 0x98, // "*" (U+002A)
  0x00, 0x2B, 0x00, 0x02, 0x05, 0x06, 0x06, 0x00, 0xA7, // "+" (U+002B)
  0x00, 0x2C, 0x42, 0xFF, 0x03, 0x01, 0x06, 0x00, 0xB4, // "," (U+002C)
  0x00, 0x2D, 0x41, 0x02, 0x04, 0x03, 0x06, 0x00, 0xB7, // "-" (U+002D)
  0x00, 0x2E, 0x42, 0x01, 0x03, 0x02, 0x06, 0x00, 0xBB, // "." (U+002E)
  0x00, 0x2F, 0x41, 0x01, 0x04, 0x08, 0x06, 0x00, 0xBD, // "/" (U+002F)
  0x00, 0x30, 0x40, 0x01, 0x05, 0x08, 0x06, 0x00, 0xCD, // "0" (U+0030)
  0x00, 0x31, 0x00, 0x01, 0x05, 0x08, 0x06, 0x00, 0xE5, // "1" (U+0031)
  0x00, 0x32, 0x40, 0x01, 0x05, 0x08, 0x06, 0x00, 0xFC, // "2" (U+0032)
  0x00, 0x33, 0x40, 0x01, 0x05, 0x08, 0x06, 0x01, 0x14, // "3" (U+0033)
  0x00, 0x34, 0x40, 0x01, 0x05, 0x08, 0x06, 0x01, 0x2C, // "4" (U+0034)
  0x00, 0x35, 0x40, 0x01, 0x05, 0x08, 0x06, 0x01, 0x44, // "5" (U+0035)
  0x00, 0x36, 0x40, 0x01, 0x05, 0x08, 0x06, 0x01, 0x5C, // "6" (U+0036)
  0x00, 0x37, 0x00, 0x01, 0x05, 0x08, 0x06, 0x01, 0x74, // "7" (U+0037)
  0x00, 0x38, 0x40, 0x01, 0x05, 0x08, 0x06, 0x01, 0x8B, // "8" (U+0038)
  0x00, 0x39, 0x40, 0x01, 0x05, 0x08, 0x06, 0x01, 0xA3, // "9" (U+0039)
  0x00, 0x3A, 0x42, 0x01, 0x03, 0x06, 0x06, 0x01, 0xBB, // ":" (U+003A)
  0x00, 0x3B, 0x42, 0xFF, 0x03, 0x06, 0x06, 0x01, 0xC1, // ";" (U+003B)
  0x00, 0x3C, 0x40, 0x02, 0x05, 0x06, 0x06, 0x01, 0xC9, // "<" (U+003C)
  0x00, 0x3D, 0x40, 0x02, 0x05, 0x05, 0x06, 0x01, 0xD8, // "=" (U+003D)
  0x00, 0x3E, 0x40, 0x02, 0x05, 0x06, 0x06, 0x01, 0xE4, // ">" (U+003E)
  0x00, 0x3F, 0x41, 0x01, 0x05, 0x08, 0x06, 0x01, 0xF3, // "?" (U+003F)
  0x00, 0x40, 0x40, 0xFF, 0x05, 0x08, 0x06, 0x02, 0x07, // "@" (U+0040)
  0x00, 0x41, 0x40, 0x01, 0x05, 0x08, 0x06, 0x02, 0x25, // "A" (U+0041)
  0x00, 0x42, 0x40, 0x01, 0x05, 0x08, 0x06, 0x02, 0x3D, // "B" (U+0042)
  0x00, 0x43, 0x40, 0x01, 0x05, 0x08, 0x06, 0x02, 0x55, // "C" (U+0043)
  0x00, 0x44, 0x40, 0x01, 0x05, 0x08, 0x06, 0x02, 0x6D, // "D" (U+0044)
  0x00, 0x45, 0x00, 0x01, 0x05, 0x08, 0x06, 0x02, 0x85, // "E" (U+0045)
  0x00, 0x46, 0x00, 0x01, 0x05, 0x08, 0x06, 0x02, 0x9C, // "F" (U+0046)
  0x00, 0x47, 0x40, 0x01, 0x05, 0x08, 0x06, 0x02, 0xB3, // "G" (U+0047)
  0x00, 0x48, 0x40, 0x01, 0x05, 0x08, 0x06, 0x02, 0xCB, // "H" (U+0048)
  0x00, 0x49, 0x00, 0x01, 0x05, 0x08, 0x06, 0x02, 0xE3, // "I" (U+0049)
  0x00, 0x4A, 0x40, 0x01, 0x04, 0x08, 0x06, 0x02, 0xF7, // "J" (U+004A)
  0x00, 0x4B, 0x40, 0x01, 0x05, 0x08, 0x06, 0x03, 0x0B, // "K" (U+004B)
  0x00, 0x4C, 0x40, 0x01, 0x05, 0x08, 0x06, 0x03, 0x23, // "L" (U+004C)
  0x00, 0x4D, 0x40, 0x01, 0x05, 0x08, 0x06, 0x03, 0x3B, // "M" (U+004D)
  0x00, 0x4E, 0x40, 0x01, 0x05, 0x08, 0x06, 0x03, 0x53, // "N" (U+004E)
  0x00, 0x4F, 0x40, 0x01, 0x05, 0x08, 0x06, 0x03, 0x6B, // "O" (U+004F)
  0x00, 0x50, 0x40, 0x01, 0x05, 0x08, 0x06, 0x03, 0x83, // "P" (U+0050)
  0x00, 0x51, 0x40, 0xFF, 0x05, 0x08, 0x06, 0x03, 0x9B, // "Q" (U+0051)
  0x00, 0x52, 0x40, 0x01, 0x05, 0x08, 0x06, 0x03, 0xB9, // "R" (U+0052)
  0x00, 0x53, 0x40, 0x01, 0x05, 0x08, 0x06, 0x03, 0xD1, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x05, 0x08, 0x06, 0x03, 0xE9, // "T" (U+0054)
  0x00, 0x55, 0x40, 0x01, 0x05, 0x08, 0x06, 0x03, 0xFC, // "U" (U+0055)
  0x00, 0x56, 0x40, 0x01, 0x05, 0x08, 0x06, 0x04, 0x14, // "V" (U+0056)
  0x00, 0x57, 0x40, 0x01, 0x05, 0x08, 0x06, 0x04, 0x2C, // "W" (U+0057)
  0x00, 0x58, 0x40, 0x01, 0x05, 0x08, 0x06, 0x04, 0x44, // "X" (U+0058)
  0x00, 0x59, 0x00, 0x01, 0x05, 0x08, 0x06, 0x04, 0x5C, // "Y" (U+0059)
  0x00, 0x5A, 0x40, 0x01, 0x05, 0x08, 0x06, 0x04, 0x73, // "Z" (U+005A)
  0x00, 0x5B, 0x42, 0xFF, 0x04, 0x08, 0x06, 0x04, 0x8B, // "[" (U+005B)
  0x00, 0x5C, 0x41, 0x01, 0x04, 0x08, 0x06, 0x04, 0x9A, // "\" (U+005C)
  0x00, 0x5D, 0x41, 0xFF, 0x03, 0x08, 0x06, 0x04, 0xAA, // "]" (U+005D)
  0x00, 0x5E, 0x40, 0x04, 0x05, 0x08, 0x06, 0x04, 0xB9, // "^" (U+005E)
  0x00, 0x5F, 0x00, 0xFE, 0x05, 0xFF, 0x06, 0x04, 0xC8, // "_" (U+005F)
  0x00, 0x60, 0x41, 0x08, 0x03, 0x09, 0x06, 0x04, 0xCB, // "`" (U+0060)
  0x00, 0x61, 0x40, 0x01, 0x05, 0x06, 0x06, 0x04, 0xCE, // "a" (U+0061)
  0x00, 0x62, 0x40, 0x01, 0x05, 0x08, 0x06, 0x04, 0xE0, // "b" (U+0062)
  0x00, 0x63, 0x40, 0x01, 0x05, 0x06, 0x06, 0x04, 0xF8, // "c" (U+0063)
  0x00, 0x64, 0x40, 0x01, 0x05, 0x08, 0x06, 0x05, 0x0A, // "d" (U+0064)
  0x00, 0x65, 0x40, 0x01, 0x05, 0x06, 0x06, 0x05, 0x22, // "e" (U+0065)
  0x00, 0x66, 0x40, 0x01, 0x05, 0x08, 0x06, 0x05, 0x34, // "f" (U+0066)
  0x00, 0x67, 0x40, 0xFE, 0x05, 0x06, 0x06, 0x05, 0x4C, // "g" (U+0067)
  0x00, 0x68, 0x40, 0x01, 0x05, 0x08, 0x06, 0x05, 0x67, // "h" (U+0068)
  0x00, 0x69, 0x00, 0x01, 0x05, 0x08, 0x06, 0x05, 0x7F, // "i" (U+0069)
  0x00, 0x6A, 0x40, 0xFE, 0x04, 0x08, 0x06, 0x05, 0x95, // "j" (U+006A)
  0x00, 0x6B, 0x40, 0x01, 0x05, 0x08, 0x06, 0x05, 0xB1, // "k" (U+006B)
  0x00, 0x6C, 0x00, 0x01, 0x05, 0x08, 0x06, 0x05, 0xC9, // "l" (U+006C)
  0x00, 0x6D, 0x40, 0x01, 0x05, 0x06, 0x06, 0x05, 0xDE, // "m" (U+006D)
  0x00, 0x6E, 0x40, 0x01, 0x05, 0x06, 0x06, 0x05, 0xF0, // "n" (U+006E)
  0x00, 0x6F, 0x40, 0x01, 0x05, 0x06, 0x06, 0x06, 0x02, // "o" (U+006F)
  0x00, 0x70, 0x40, 0xFE, 0x05, 0x06, 0x06, 0x06, 0x14, // "p" (U+0070)
  0x00, 0x71, 0x40, 0xFE, 0x05, 0x06, 0x06, 0x06, 0x2F, // "q" (U+0071)
  0x00, 0x72, 0x40, 0x01, 0x05, 0x06, 0x06, 0x06, 0x4A, // "r" (U+0072)
  0x00, 0x73, 0x40, 0x01, 0x05, 0x06, 0x06, 0x06, 0x5C, // "s" (U+0073)
  0x00, 0x74, 0x40, 0x01, 0x05, 0x08, 0x06, 0x06, 0x6E, // "t" (U+0074)
  0x00, 0x75, 0x40, 0x01, 0x05, 0x06, 0x06, 0x06, 0x86, // "u" (U+0075)
  0x00, 0x76, 0x40, 0x01, 0x05, 0x06, 0x06, 0x06, 0x98, // "v" (U+0076)
  0x00, 0x77, 0x40, 0x01, 0x05, 0x06, 0x06, 0x06, 0xAA, // "w" (U+0077)
  0x00, 0x78, 0x40, 0x01, 0x05, 0x06, 0x06, 0x06, 0xBC, // "x" (U+0078)
  0x00, 0x79, 0x40, 0xFE, 0x05, 0x06, 0x06, 0x06, 0xCE, // "y" (U+0079)
  0x00, 0x7A, 0x40, 0x01, 0x05, 0x06, 0x06, 0x06, 0xE9, // "z" (U+007A)
  0x00, 0x7B, 0x41, 0xFF, 0x04, 0x08, 0x06, 0x06, 0xFB, // "{" (U+007B)
  0x00, 0x7C, 0x02, 0xFE, 0x03, 0x08, 0x06, 0x07, 0x0F, // "|" (U+007C)
  0x00, 0x7D, 0x41, 0xFF, 0x04, 0x08, 0x06, 0x07, 0x12, // "}" (U+007D)
  0x00, 0x7E, 0x40, 0x03, 0x05, 0x05, 0x06, 0x07, 0x26, // "~" (U+007E)
  0x00, 0xA1, 0x42, 0xFE, 0x03, 0x05, 0x06, 0x07, 0x2F, // "¡" (U+00A1)
  0x00, 0xA2, 0x40, 0x01, 0x05, 0x08, 0x06, 0x07, 0x37, // "¢" (U+00A2)
  0x00, 0xA3, 0x00, 0x01, 0x05, 0x08, 0x06, 0x07, 0x4F, // "£" (U+00A3)
  0x00, 0xA4, 0x40, 0x02, 0x05, 0x07, 0x06, 0x07, 0x66, // "¤" (U+00A4)
  0x00, 0xA5, 0x40, 0x01, 0x05, 0x08, 0x06, 0x07, 0x78, // "¥" (U+00A5)
  0x00, 0xA6, 0x02, 0xFE, 0x03, 0x08, 0x06, 0x07, 0x90, // "¦" (U+00A6)
  0x00, 0xA7, 0x41, 0x01, 0x04, 0x08, 0x06, 0x07, 0x95, // "§" (U+00A7)
  0x00, 0xA8, 0x41, 0x07, 0x04, 0x08, 0x06, 0x07, 0xA5, // "¨" (U+00A8)
  0x00, 0xA9, 0x40, 0x01, 0x05, 0x07, 0x06, 0x07, 0xA9, // "©" (U+00A9)
  0x00, 0xAA, 0x41, 0x05, 0x04, 0x08, 0x06, 0x07, 0xBE, // "ª" (U+00AA)
  0x00, 0xAB, 0x40, 0x01, 0x05, 0x05, 0x06, 0x07, 0xC6, // "«" (U+00AB)
  0x00, 0xAC, 0x00, 0x01, 0x05, 0x04, 0x06, 0x07, 0xD5, // "¬" (U+00AC)
  0x00, 0xAE, 0x40, 0x01, 0x05, 0x07, 0x06, 0x07, 0xE0, // "®" (U+00AE)
  0x00, 0xAF, 0x41, 0x07, 0x04, 0x08, 0x06, 0x07, 0xF5, // "¯" (U+00AF)
  0x00, 0xB0, 0x41, 0x04, 0x04, 0x07, 0x06, 0x07, 0xF9, // "°" (U+00B0)
  0x00, 0xB1, 0x00, 0x01, 0x05, 0x07, 0x06, 0x08, 0x01, // "±" (U+00B1)
  0x00, 0xB2, 0x41, 0x05, 0x04, 0x09, 0x06, 0x08, 0x14, // "²" (U+00B2)
  0x00, 0xB3, 0x41, 0x05, 0x04, 0x09, 0x06, 0x08, 0x1E, // "³" (U+00B3)
  0x00, 0xB4, 0x42, 0x08, 0x04, 0x09, 0x06, 0x08, 0x28, // "´" (U+00B4)
  0x00, 0xB5, 0x40, 0xFE, 0x05, 0x06, 0x06, 0x08, 0x2B, // "µ" (U+00B5)
  0x00, 0xB6, 0x40, 0xFF, 0x05, 0x08, 0x06, 0x08, 0x46, // "¶" (U+00B6)
  0x00, 0xB7, 0x42, 0x04, 0x03, 0x05, 0x06, 0x08, 0x64, // "·" (U+00B7)
  0x00, 0xB8, 0x42, 0xFE, 0x03, 0x00, 0x06, 0x08, 0x66, // "¸" (U+00B8)
  0x00, 0xB9, 0x41, 0x05, 0x04, 0x08, 0x06, 0x08, 0x69, // "¹" (U+00B9)
  0x00, 0xBA, 0x41, 0x05, 0x04, 0x08, 0x06, 0x08, 0x71, // "º" (U+00BA)
  0x00, 0xBB, 0x40, 0x01, 0x05, 0x05, 0x06, 0x08, 0x79, // "»" (U+00BB)
  0x00, 0xBC, 0x40, 0x01, 0x05, 0x08, 0x06, 0x08, 0x88, // "¼" (U+00BC)
  0x00, 0xBD, 0x40, 0x00, 0x05, 0x08, 0x06, 0x08, 0xA0, // "½" (U+00BD)
  0x00, 0xBE, 0x40, 0x01, 0x05, 0x08, 0x06, 0x08, 0xBB, // "¾" (U+00BE)
  0x00, 0xBF, 0x40, 0xFE, 0x04, 0x05, 0x06, 0x08, 0xD3, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x08, 0xE7, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x09, 0x06, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x09, 0x26, // "Â" (U+00C2)
  0x00, 0xC3, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x09, 0x46, // "Ã" (U+00C3)
  0x00, 0xC4, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x09, 0x67, // "Ä" (U+00C4)
  0x00, 0xC5, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x09, 0x85, // "Å" (U+00C5)
  0x00, 0xC6, 0x40, 0x01, 0x05, 0x08, 0x06, 0x09, 0xA3, // "Æ" (U+00C6)
  0x00, 0xC7, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x09, 0xBB, // "Ç" (U+00C7)
  0x00, 0xC8, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x09, 0xDB, // "È" (U+00C8)
  0x00, 0xC9, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x09, 0xF8, // "É" (U+00C9)
  0x00, 0xCA, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x0A, 0x15, // "Ê" (U+00CA)
  0x00, 0xCB, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x0A, 0x33, // "Ë" (U+00CB)
  0x00, 0xCC, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x0A, 0x51, // "Ì" (U+00CC)
  0x00, 0xCD, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x0A, 0x6A, // "Í" (U+00CD)
  0x00, 0xCE, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x0A, 0x84, // "Î" (U+00CE)
  0x00, 0xCF, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x0A, 0x9E, // "Ï" (U+00CF)
  0x00, 0xD0, 0x40, 0x01, 0x05, 0x08, 0x06, 0x0A, 0xB9, // "Ð" (U+00D0)
  0x00, 0xD1, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x0A, 0xD1, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x0A, 0xF2, // "Ò" (U+00D2)
  0x00, 0xD3, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x0B, 0x13, // "Ó" (U+00D3)
  0x00, 0xD4, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x0B, 0x34, // "Ô" (U+00D4)
  0x00, 0xD5, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x0B, 0x55, // "Õ" (U+00D5)
  0x00, 0xD6, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x0B, 0x76, // "Ö" (U+00D6)
  0x00, 0xD7, 0x41, 0x02, 0x04, 0x06, 0x06, 0x0B, 0x94, // "×" (U+00D7)
  0x00, 0xD8, 0x00, 0x00, 0x05, 0x09, 0x06, 0x0B, 0x9E, // "Ø" (U+00D8)
  0x00, 0xD9, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x0B, 0xBA, // "Ù" (U+00D9)
  0x00, 0xDA, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x0B, 0xDB, // "Ú" (U+00DA)
  0x00, 0xDB, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x0B, 0xFC, // "Û" (U+00DB)
  0x00, 0xDC, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x0C, 0x1D, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x0C, 0x3B, // "Ý" (U+00DD)
  0x00, 0xDE, 0x40, 0x01, 0x05, 0x08, 0x06, 0x0C, 0x58, // "Þ" (U+00DE)
  0x00, 0xDF, 0x40, 0x01, 0x05, 0x08, 0x06, 0x0C, 0x70, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x01, 0x05, 0x09, 0x06, 0x0C, 0x88, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x05, 0x09, 0x06, 0x0C, 0xA1, // "á" (U+00E1)
  0x00, 0xE2, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0C, 0xBB, // "â" (U+00E2)
  0x00, 0xE3, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0C, 0xD6, // "ã" (U+00E3)
  0x00, 0xE4, 0x40, 0x01, 0x05, 0x08, 0x06, 0x0C, 0xF1, // "ä" (U+00E4)
  0x00, 0xE5, 0x40, 0x01, 0x05, 0x08, 0x06, 0x0D, 0x09, // "å" (U+00E5)
  0x00, 0xE6, 0x40, 0x01, 0x05, 0x06, 0x06, 0x0D, 0x21, // "æ" (U+00E6)
  0x00, 0xE7, 0x40, 0xFE, 0x05, 0x06, 0x06, 0x0D, 0x33, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x01, 0x05, 0x09, 0x06, 0x0D, 0x4E, // "è" (U+00E8)
  0x00, 0xE9, 0x00, 0x01, 0x05, 0x09, 0x06, 0x0D, 0x67, // "é" (U+00E9)
  0x00, 0xEA, 0x00, 0x01, 0x05, 0x09, 0x06, 0x0D, 0x81, // "ê" (U+00EA)
  0x00, 0xEB, 0x40, 0x01, 0x05, 0x08, 0x06, 0x0D, 0x9B, // "ë" (U+00EB)
  0x00, 0xEC, 0x00, 0x01, 0x05, 0x09, 0x06, 0x0D, 0xB3, // "ì" (U+00EC)
  0x00, 0xED, 0x00, 0x01, 0x05, 0x09, 0x06, 0x0D, 0xC9, // "í" (U+00ED)
  0x00, 0xEE, 0x00, 0x01, 0x05, 0x09, 0x06, 0x0D, 0xE0, // "î" (U+00EE)
  0x00, 0xEF, 0x40, 0x01, 0x05, 0x08, 0x06, 0x0D, 0xF7, // "ï" (U+00EF)
  0x00, 0xF0, 0x40, 0x01, 0x05, 0x08, 0x06, 0x0E, 0x0F, // "ð" (U+00F0)
  0x00, 0xF1, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0E, 0x27, // "ñ" (U+00F1)
  0x00, 0xF2, 0x00, 0x01, 0x05, 0x09, 0x06, 0x0E, 0x42, // "ò" (U+00F2)
  0x00, 0xF3, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0E, 0x5C, // "ó" (U+00F3)
  0x00, 0xF4, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0E, 0x77, // "ô" (U+00F4)
  0x00, 0xF5, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0E, 0x92, // "õ" (U+00F5)
  0x00, 0xF6, 0x40, 0x01, 0x05, 0x08, 0x06, 0x0E, 0xAD, // "ö" (U+00F6)
  0x00, 0xF7, 0x00, 0x01, 0x05, 0x06, 0x06, 0x0E, 0xC5, // "÷" (U+00F7)
  0x00, 0xF8, 0x40, 0x00, 0x05, 0x06, 0x06, 0x0E, 0xD4, // "ø" (U+00F8)
  0x00, 0xF9, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0E, 0xE9, // "ù" (U+00F9)
  0x00, 0xFA, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0F, 0x04, // "ú" (U+00FA)
  0x00, 0xFB, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0F, 0x1F, // "û" (U+00FB)
  0x00, 0xFC, 0x40, 0x01, 0x05, 0x08, 0x06, 0x0F, 0x3A, // "ü" (U+00FC)
  0x00, 0xFD, 0x00, 0xFE, 0x05, 0x09, 0x06, 0x0F, 0x52, // "ý" (U+00FD)
  0x00, 0xFE, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x0F, 0x75, // "þ" (U+00FE)
  0x00, 0xFF, 0x40, 0xFE, 0x05, 0x08, 0x06, 0x0F, 0x94, // "ÿ" (U+00FF)
  0x01, 0x00, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x0F, 0xB5, // "Ā" (U+0100)
  0x01, 0x01, 0x40, 0x01, 0x05, 0x08, 0x06, 0x0F, 0xD3, // "ā" (U+0101)
  0x01, 0x02, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x0F, 0xEB, // "Ă" (U+0102)
  0x01, 0x03, 0x40, 0x01, 0x05, 0x09, 0x06, 0x10, 0x0C, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x10, 0x27, // "Ą" (U+0104)
  0x01, 0x05, 0x40, 0xFE, 0x05, 0x06, 0x06, 0x10, 0x46, // "ą" (U+0105)
  0x01, 0x06, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x10, 0x61, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x01, 0x05, 0x09, 0x06, 0x10, 0x7F, // "ć" (U+0107)
  0x01, 0x08, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x10, 0x99, // "Ĉ" (U+0108)
  0x01, 0x09, 0x40, 0x01, 0x05, 0x09, 0x06, 0x10, 0xB7, // "ĉ" (U+0109)
  0x01, 0x0A, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x10, 0xD2, // "Ċ" (U+010A)
  0x01, 0x0B, 0x40, 0x01, 0x05, 0x08, 0x06, 0x10, 0xEE, // "ċ" (U+010B)
  0x01, 0x0C, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x11, 0x06, // "Č" (U+010C)
  0x01, 0x0D, 0x40, 0x01, 0x05, 0x09, 0x06, 0x11, 0x25, // "č" (U+010D)
  0x01, 0x0E, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x11, 0x40, // "Ď" (U+010E)
  0x01, 0x0F, 0x40, 0x01, 0x06, 0x08, 0x06, 0x11, 0x61, // "ď" (U+010F)
  0x01, 0x10, 0x40, 0x01, 0x05, 0x08, 0x06, 0x11, 0x7D, // "Đ" (U+0110)
  0x01, 0x11, 0x40, 0x01, 0x05, 0x08, 0x06, 0x11, 0x95, // "đ" (U+0111)
  0x01, 0x12, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x11, 0xAD, // "Ē" (U+0112)
  0x01, 0x13, 0x40, 0x01, 0x05, 0x08, 0x06, 0x11, 0xCB, // "ē" (U+0113)
  0x01, 0x14, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x11, 0xE3, // "Ĕ" (U+0114)
  0x01, 0x15, 0x40, 0x01, 0x05, 0x09, 0x06, 0x12, 0x03, // "ĕ" (U+0115)
  0x01, 0x16, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x12, 0x1E, // "Ė" (U+0116)
  0x01, 0x17, 0x40, 0x01, 0x05, 0x08, 0x06, 0x12, 0x3A, // "ė" (U+0117)
  0x01, 0x18, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x12, 0x52, // "Ę" (U+0118)
  0x01, 0x19, 0x40, 0xFE, 0x05, 0x06, 0x06, 0x12, 0x70, // "ę" (U+0119)
  0x01, 0x1A, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x12, 0x8B, // "Ě" (U+011A)
  0x01, 0x1B, 0x40, 0x01, 0x05, 0x09, 0x06, 0x12, 0xAA, // "ě" (U+011B)
  0x01, 0x1C, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x12, 0xC5, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x40, 0xFE, 0x05, 0x09, 0x06, 0x12, 0xE5, // "ĝ" (U+011D)
  0x01, 0x1E, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x13, 0x09, // "Ğ" (U+011E)
  0x01, 0x1F, 0x40, 0xFE, 0x05, 0x09, 0x06, 0x13, 0x2A, // "ğ" (U+011F)
  0x01, 0x20, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x13, 0x4E, // "Ġ" (U+0120)
  0x01, 0x21, 0x40, 0xFE, 0x05, 0x08, 0x06, 0x13, 0x6B, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x13, 0x8C, // "Ģ" (U+0122)
  0x01, 0x23, 0x40, 0xFE, 0x05, 0x08, 0x06, 0x13, 0xAA, // "ģ" (U+0123)
  0x01, 0x24, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x13, 0xCB, // "Ĥ" (U+0124)
  0x01, 0x25, 0xFF, 0x01, 0x05, 0x0B, 0x06, 0x13, 0xEC, // "ĥ" (U+0125)
  0x01, 0x26, 0x00, 0x01, 0x05, 0x08, 0x06, 0x14, 0x0F, // "Ħ" (U+0126)
  0x01, 0x27, 0x40, 0x01, 0x05, 0x08, 0x06, 0x14, 0x26, // "ħ" (U+0127)
  0x01, 0x28, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x14, 0x3E, // "Ĩ" (U+0128)
  0x01, 0x29, 0x00, 0x01, 0x05, 0x09, 0x06, 0x14, 0x5B, // "ĩ" (U+0129)
  0x01, 0x2A, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x14, 0x75, // "Ī" (U+012A)
  0x01, 0x2B, 0x00, 0x01, 0x05, 0x08, 0x06, 0x14, 0x8F, // "ī" (U+012B)
  0x01, 0x2C, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x14, 0xA6, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x00, 0x01, 0x05, 0x09, 0x06, 0x14, 0xC3, // "ĭ" (U+012D)
  0x01, 0x2E, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x14, 0xDD, // "Į" (U+012E)
  0x01, 0x2F, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x14, 0xF7, // "į" (U+012F)
  0x01, 0x30, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x15, 0x14, // "İ" (U+0130)
  0x01, 0x31, 0x00, 0x01, 0x05, 0x06, 0x06, 0x15, 0x2C, // "ı" (U+0131)
  0x01, 0x32, 0x40, 0x01, 0x05, 0x08, 0x06, 0x15, 0x3D, // "Ĳ" (U+0132)
  0x01, 0x33, 0x40, 0xFE, 0x05, 0x08, 0x06, 0x15, 0x55, // "ĳ" (U+0133)
  0x01, 0x34, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x15, 0x76, // "Ĵ" (U+0134)
  0x01, 0x35, 0x40, 0xFE, 0x04, 0x09, 0x06, 0x15, 0x93, // "ĵ" (U+0135)
  0x01, 0x36, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x15, 0xB1, // "Ķ" (U+0136)
  0x01, 0x37, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x15, 0xD1, // "ķ" (U+0137)
  0x01, 0x38, 0x40, 0x01, 0x05, 0x06, 0x06, 0x15, 0xEF, // "ĸ" (U+0138)
  0x01, 0x39, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x16, 0x01, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x16, 0x20, // "ĺ" (U+013A)
  0x01, 0x3B, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x16, 0x3B, // "Ļ" (U+013B)
  0x01, 0x3C, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x16, 0x58, // "ļ" (U+013C)
  0x01, 0x3D, 0x40, 0x01, 0x05, 0x08, 0x06, 0x16, 0x72, // "Ľ" (U+013D)
  0x01, 0x3E, 0x40, 0x01, 0x05, 0x08, 0x06, 0x16, 0x8A, // "ľ" (U+013E)
  0x01, 0x3F, 0x40, 0x01, 0x05, 0x08, 0x06, 0x16, 0xA2, // "Ŀ" (U+013F)
  0x01, 0x40, 0x00, 0x01, 0x06, 0x08, 0x06, 0x16, 0xBA, // "ŀ" (U+0140)
  0x01, 0x41, 0x40, 0x01, 0x05, 0x08, 0x06, 0x16, 0xD3, // "Ł" (U+0141)
  0x01, 0x42, 0x40, 0x01, 0x05, 0x08, 0x06, 0x16, 0xEB, // "ł" (U+0142)
  0x01, 0x43, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x17, 0x03, // "Ń" (U+0143)
  0x01, 0x44, 0x40, 0x01, 0x05, 0x09, 0x06, 0x17, 0x23, // "ń" (U+0144)
  0x01, 0x45, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x17, 0x3E, // "Ņ" (U+0145)
  0x01, 0x46, 0x00, 0xFE, 0x05, 0x06, 0x06, 0x17, 0x5D, // "ņ" (U+0146)
  0x01, 0x47, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x17, 0x77, // "Ň" (U+0147)
  0x01, 0x48, 0x40, 0x01, 0x05, 0x09, 0x06, 0x17, 0x98, // "ň" (U+0148)
  0x01, 0x49, 0xBF, 0x01, 0x05, 0x08, 0x06, 0x17, 0xB3, // "ŉ" (U+0149)
  0x01, 0x4A, 0x40, 0xFE, 0x05, 0x08, 0x06, 0x17, 0xCF, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x40, 0xFE, 0x05, 0x06, 0x06, 0x17, 0xF0, // "ŋ" (U+014B)
  0x01, 0x4C, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x18, 0x0B, // "Ō" (U+014C)
  0x01, 0x4D, 0x40, 0x01, 0x05, 0x08, 0x06, 0x18, 0x29, // "ō" (U+014D)
  0x01, 0x4E, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x18, 0x41, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x40, 0x01, 0x05, 0x09, 0x06, 0x18, 0x62, // "ŏ" (U+014F)
  0x01, 0x50, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x18, 0x7D, // "Ő" (U+0150)
  0x01, 0x51, 0x40, 0x01, 0x05, 0x08, 0x06, 0x18, 0x9B, // "ő" (U+0151)
  0x01, 0x52, 0x40, 0x01, 0x05, 0x08, 0x06, 0x18, 0xB3, // "Œ" (U+0152)
  0x01, 0x53, 0x40, 0x01, 0x05, 0x06, 0x06, 0x18, 0xCB, // "œ" (U+0153)
  0x01, 0x54, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x18, 0xDD, // "Ŕ" (U+0154)
  0x01, 0x55, 0x00, 0x01, 0x05, 0x09, 0x06, 0x18, 0xFD, // "ŕ" (U+0155)
  0x01, 0x56, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x19, 0x16, // "Ŗ" (U+0156)
  0x01, 0x57, 0x00, 0xFE, 0x05, 0x06, 0x06, 0x19, 0x35, // "ŗ" (U+0157)
  0x01, 0x58, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x19, 0x4D, // "Ř" (U+0158)
  0x01, 0x59, 0x40, 0x01, 0x05, 0x09, 0x06, 0x19, 0x6E, // "ř" (U+0159)
  0x01, 0x5A, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x19, 0x89, // "Ś" (U+015A)
  0x01, 0x5B, 0x40, 0x01, 0x05, 0x09, 0x06, 0x19, 0xA9, // "ś" (U+015B)
  0x01, 0x5C, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x19, 0xC4, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x40, 0x01, 0x05, 0x09, 0x06, 0x19, 0xE4, // "ŝ" (U+015D)
  0x01, 0x5E, 0x40, 0xFE, 0x05, 0x08, 0x06, 0x19, 0xFF, // "Ş" (U+015E)
  0x01, 0x5F, 0x40, 0xFE, 0x05, 0x06, 0x06, 0x1A, 0x20, // "ş" (U+015F)
  0x01, 0x60, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x1A, 0x3B, // "Š" (U+0160)
  0x01, 0x61, 0x40, 0x01, 0x05, 0x09, 0x06, 0x1A, 0x5C, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x1A, 0x77, // "Ţ" (U+0162)
  0x01, 0x63, 0x40, 0xFE, 0x05, 0x08, 0x06, 0x1A, 0x91, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x1A, 0xB2, // "Ť" (U+0164)
  0x01, 0x65, 0x40, 0x01, 0x05, 0x08, 0x06, 0x1A, 0xCC, // "ť" (U+0165)
  0x01, 0x66, 0x00, 0x01, 0x05, 0x08, 0x06, 0x1A, 0xE4, // "Ŧ" (U+0166)
  0x01, 0x67, 0x40, 0x01, 0x05, 0x08, 0x06, 0x1A, 0xF9, // "ŧ" (U+0167)
  0x01, 0x68, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x1B, 0x11, // "Ũ" (U+0168)
  0x01, 0x69, 0x40, 0x01, 0x05, 0x09, 0x06, 0x1B, 0x32, // "ũ" (U+0169)
  0x01, 0x6A, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x1B, 0x4D, // "Ū" (U+016A)
  0x01, 0x6B, 0x40, 0x01, 0x05, 0x08, 0x06, 0x1B, 0x6B, // "ū" (U+016B)
  0x01, 0x6C, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x1B, 0x83, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x40, 0x01, 0x05, 0x09, 0x06, 0x1B, 0xA4, // "ŭ" (U+016D)
  0x01, 0x6E, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x1B, 0xBF, // "Ů" (U+016E)
  0x01, 0x6F, 0x40, 0x01, 0x05, 0x08, 0x06, 0x1B, 0xDD, // "ů" (U+016F)
  0x01, 0x70, 0x40, 0x01, 0x05, 0x0A, 0x06, 0x1B, 0xF5, // "Ű" (U+0170)
  0x01, 0x71, 0x40, 0x01, 0x05, 0x08, 0x06, 0x1C, 0x13, // "ű" (U+0171)
  0x01, 0x72, 0x40, 0xFE, 0x05, 0x08, 0x06, 0x1C, 0x2B, // "Ų" (U+0172)
  0x01, 0x73, 0x40, 0xFE, 0x05, 0x06, 0x06, 0x1C, 0x4C, // "ų" (U+0173)
  0x01, 0x74, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x1C, 0x67, // "Ŵ" (U+0174)
  0x01, 0x75, 0x40, 0x01, 0x05, 0x09, 0x06, 0x1C, 0x88, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x1C, 0xA3, // "Ŷ" (U+0176)
  0x01, 0x77, 0x00, 0xFE, 0x05, 0x09, 0x06, 0x1C, 0xC0, // "ŷ" (U+0177)
  0x01, 0x78, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x1C, 0xE3, // "Ÿ" (U+0178)
  0x01, 0x79, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x1D, 0x00, // "Ź" (U+0179)
  0x01, 0x7A, 0x00, 0x01, 0x05, 0x09, 0x06, 0x1D, 0x1E, // "ź" (U+017A)
  0x01, 0x7B, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x1D, 0x37, // "Ż" (U+017B)
  0x01, 0x7C, 0x00, 0x01, 0x05, 0x08, 0x06, 0x1D, 0x53, // "ż" (U+017C)
  0x01, 0x7D, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x1D, 0x6A, // "Ž" (U+017D)
  0x01, 0x7E, 0x00, 0x01, 0x05, 0x09, 0x06, 0x1D, 0x89, // "ž" (U+017E)
  0x01, 0x7F, 0x42, 0x01, 0x05, 0x08, 0x06, 0x1D, 0xA3, // "ſ" (U+017F)
  0x03, 0xA9, 0x40, 0x01, 0x05, 0x08, 0x06, 0x1D, 0xB3, // "Ω" (U+03A9)
  0x03, 0xBC, 0x40, 0xFE, 0x05, 0x06, 0x06, 0x1D, 0xCB, // "μ" (U+03BC)
  0x03, 0xC0, 0x40, 0x01, 0x05, 0x06, 0x06, 0x1D, 0xE6, // "π" (U+03C0)
  0x20, 0x13, 0x01, 0x02, 0x04, 0x03, 0x06, 0x1D, 0xF8, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x02, 0x05, 0x03, 0x06, 0x1D, 0xFB, // "—" (U+2014)
  0x20, 0xAC, 0x40, 0x01, 0x05, 0x08, 0x06, 0x1D, 0xFE, // "€" (U+20AC)
  0x20, 0xBF, 0x40, 0x00, 0x05, 0x0A, 0x06, 0x1E, 0x16, // "₿" (U+20BF)
  0x20, 0x18, 0x42, 0x06, 0x03, 0x08, 0x06, 0x1E, 0x37, // "‘" (U+2018)
  0x20, 0x19, 0x42, 0x06, 0x03, 0x08, 0x06, 0x1E, 0x3A, // "’" (U+2019)
  0x20, 0x1A, 0x42, 0xFF, 0x03, 0x01, 0x06, 0x1E, 0x3D, // "‚" (U+201A)
  0x20, 0x1B, 0x42, 0x06, 0x03, 0x08, 0x06, 0x1E, 0x40, // "‛" (U+201B)
  0x20, 0x1C, 0x41, 0x06, 0x04, 0x08, 0x06, 0x1E, 0x43, // "“" (U+201C)
  0x20, 0x1D, 0x41, 0x05, 0x04, 0x07, 0x06, 0x1E, 0x49, // "”" (U+201D)
  0x20, 0x1E, 0x41, 0xFF, 0x04, 0x01, 0x06, 0x1E, 0x4F, // "„" (U+201E)
  0x20, 0x1F, 0x41, 0x05, 0x04, 0x07, 0x06, 0x1E, 0x55, // "‟" (U+201F)
  0x20, 0x20, 0x41, 0x01, 0x04, 0x08, 0x06, 0x1E, 0x5B, // "†" (U+2020)
  0x20, 0x21, 0x41, 0x01, 0x04, 0x08, 0x06, 0x1E, 0x6B, // "‡" (U+2021)
  0x20, 0x22, 0x41, 0x03, 0x04, 0x05, 0x06, 0x1E, 0x7B, // "•" (U+2022)
  0x20, 0x26, 0x00, 0x01, 0x05, 0x02, 0x06, 0x1E, 0x81, // "…" (U+2026)
  0x20, 0x30, 0x40, 0x01, 0x05, 0x08, 0x06, 0x1E, 0x85, // "‰" (U+2030)
  0x20, 0x39, 0x41, 0x01, 0x04, 0x05, 0x06, 0x1E, 0x9D, // "‹" (U+2039)
  0x20, 0x3A, 0x41, 0x02, 0x04, 0x06, 0x06, 0x1E, 0xA7, // "›" (U+203A)
  0x20, 0x44, 0xBE, 0x01, 0x01, 0x08, 0x00, 0x1E, 0xB1, // "⁄" (U+2044)
  0x21, 0x22, 0x40, 0x04, 0x05, 0x07, 0x06, 0x1E, 0xC1, // "™" (U+2122)
  0x21, 0x52, 0x02, 0x01, 0x0F, 0x08, 0x12, 0x1E, 0xCD, // "⅒" (U+2152)
  0x22, 0x02, 0x40, 0x01, 0x05, 0x07, 0x06, 0x1F, 0x01, // "∂" (U+2202)
  0x22, 0x06, 0x40, 0x01, 0x05, 0x08, 0x06, 0x1F, 0x16, // "∆" (U+2206)
  0x22, 0x1A, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x1F, 0x2E, // "√" (U+221A)
  0x22, 0x1E, 0x40, 0x03, 0x05, 0x05, 0x06, 0x1F, 0x4B, // "∞" (U+221E)
  0x22, 0x48, 0x40, 0x02, 0x05, 0x06, 0x06, 0x1F, 0x54, // "≈" (U+2248)
  0x22, 0x60, 0x00, 0x01, 0x05, 0x07, 0x06, 0x1F, 0x63, // "≠" (U+2260)
  0x22, 0x64, 0x00, 0x00, 0x05, 0x07, 0x06, 0x1F, 0x74, // "≤" (U+2264)
  0x22, 0x65, 0x00, 0x00, 0x05, 0x07, 0x06, 0x1F, 0x8B, // "≥" (U+2265)
  
  // Kerning pairs
  
  // Glyph data
  // "!" (U+0021)
  0xCC, 0xCC, 0xBB, 0xAA, 0xAA, 0x00, 0x11, 0xBB,
  // """ (U+0022)
  0xAA, 0xAA, 0x99, 0x99, 0x76, 0x67,
  // "#" (U+0023)
  0x00, 0xE2, 0xE0, 0x02, 0xD3, 0xC0, 0x8F, 0xFF, 0xFD, 0x18, 0xB9, 0x92, 0x07, 0x89, 0x60, 0xDF,
  0xFF, 0xF8, 0x2C, 0x6E, 0x41, 0x0E, 0x2E, 0x00,
  // "$" (U+0024)
  0x00, 0x56, 0x00, 0x09, 0xFF, 0xD0, 0x1F, 0x97, 0x50, 0x1F, 0xB5, 0x00, 0x05, 0xEE, 0x50, 0x00,
  0x4B, 0xF1, 0x15, 0x59, 0xF2, 0x2F, 0xFF, 0x90, 0x00, 0x66, 0x00,
  // "%" (U+0025)
  0x7E, 0x50, 0xE1, 0xE7, 0xC7, 0x90, 0xE4, 0xCD, 0x20, 0x7E, 0xBB, 0x00, 0x00, 0xCA, 0xF8, 0x04,
  0xCC, 0x7E, 0x0B, 0x5C, 0x7E, 0x2D, 0x05, 0xE7,
  // "&" (U+0026)
  0x08, 0xE9, 0x00, 0x1F, 0x7F, 0x10, 0x0F, 0x6F, 0x00, 0x0B, 0xF7, 0x00, 0x2E, 0xF5, 0xC6, 0x9B,
  0x6E, 0xF2, 0x9C, 0x5E, 0xD0, 0x2D, 0xE9, 0xE7,
  // "'" (U+0027)
  0xAA, 0x99, 0x76,
  // "(" (U+0028)
  0x01, 0xE3, 0x07, 0xB0, 0x0C, 0x60, 0x0F, 0x30, 0x1F, 0x20, 0x0F, 0x30, 0x0D, 0x60, 0x08, 0xB0,
  0x01, 0xE3,
  // ")" (U+0029)
  0x3E, 0x10, 0x0B, 0x70, 0x06, 0xD0, 0x03, 0xF0, 0x02, 0xF1, 0x03, 0xF0, 0x06, 0xC0, 0x0B, 0x70,
  0x3E, 0x10,
  // "*" (U+002A)
  0x00, 0x88, 0x00, 0x08, 0x9A, 0x81, 0x18, 0xEE, 0x81, 0x05, 0xCC, 0x50, 0x03, 0x33, 0x20,
  // "+" (U+002B)
  0x20, 0x08, 0x40, 0x08, 0x20, 0x4C, 0x85, 0x41, 0x39, 0xA3, 0x12, 0x00, 0x82,
  // "," (U+002C)
  0x9C, 0xC8, 0xE3,
  // "-" (U+002D)
  0x7F, 0xF7, 0x13, 0x31,
  // "." (U+002E)
  0x11, 0xBB,
  // "/" (U+002F)
  0x00, 0x6C, 0x00, 0xB7, 0x01, 0xF2, 0x07, 0xC0, 0x0C, 0x70, 0x2F, 0x10, 0x7C, 0x00, 0xC6, 0x00,
  // "0" (U+0030)
  0x06, 0xDE, 0x50, 0x1F, 0x89, 0xF1, 0x5F, 0x0C, 0xF5, 0x7E, 0x5C, 0xE6, 0x7E, 0xD4, 0xE6, 0x5F,
  0xB0, 0xF5, 0x1F, 0x88, 0xF1, 0x06, 0xEE, 0x60,
  // "1" (U+0031)
  0x18, 0x13, 0xCE, 0x20, 0x2A, 0x0E, 0x38, 0x15, 0x7E, 0x40, 0x70, 0xE4, 0x07, 0x0E, 0x40, 0x70,
  0xE3, 0x82, 0x29, 0xF3, 0x20, 0xDB, 0x04,
  // "2" (U+0032)
  0x19, 0xEE, 0x70, 0x2D, 0x69, 0xF3, 0x00, 0x03, 0xF5, 0x00, 0x09, 0xE1, 0x00, 0x5F, 0x60, 0x03,
  0xE8, 0x00, 0x2E, 0xC3, 0x32, 0x6F, 0xFF, 0xF8,
  // "3" (U+0033)
  0x1A, 0xEE, 0x70, 0x08, 0x59, 0xF1, 0x00, 0x07, 0xE0, 0x03, 0xFF, 0x50, 0x00, 0x39, 0xF2, 0x00,
  0x02, 0xF4, 0x37, 0x49, 0xF2, 0x3D, 0xFD, 0x60,
  // "4" (U+0034)
  0x00, 0x0E, 0xA0, 0x00, 0x8F, 0xA0, 0x02, 0xED, 0xA0, 0x0A, 0x9A, 0xA0, 0x3E, 0x1B, 0xA0, 0x9F,
  0xFF, 0xF9, 0x23, 0x3B, 0xB2, 0x00, 0x0A, 0xA0,
  // "5" (U+0035)
  0x0D, 0xFF, 0xD0, 0x0E, 0x94, 0x40, 0x0F, 0x61, 0x00, 0x1F, 0xFF, 0x80, 0x04, 0x3A, 0xF2, 0x00,
  0x04, 0xF3, 0x28, 0x5B, 0xE0, 0x2D, 0xFC, 0x40,
  // "6" (U+0036)
  0x01, 0xAE, 0xE0, 0x0C, 0xD5, 0x40, 0x3F, 0x30, 0x00, 0x6F, 0x9F, 0xA0, 0x6F, 0x86, 0xF4, 0x5F,
  0x10, 0xF6, 0x1E, 0x87, 0xF3, 0x04, 0xDE, 0x70,
  // "7" (U+0037)
  0x07, 0xC8, 0x57, 0x13, 0x36, 0xF4, 0x30, 0x90, 0xD4, 0x0E, 0x08, 0x38, 0x16, 0xF2, 0x30, 0xC0,
  0xB3, 0x81, 0x2F, 0x53, 0x09, 0x0E, 0x30,
  // "8" (U+0038)
  0x07, 0xDD, 0x70, 0x1F, 0x88, 0xF1, 0x0F, 0x88, 0xF1, 0x07, 0xFF, 0x60, 0x0D, 0xCD, 0xC0, 0x5F,
  0x11, 0xF5, 0x4F, 0x76, 0xF4, 0x08, 0xEE, 0x70,
  // "9" (U+0039)
  0x07, 0xED, 0x40, 0x3F, 0x78, 0xE1, 0x6F, 0x01, 0xF5, 0x5F, 0x45, 0xF6, 0x0D, 0xFC, 0xF6, 0x00,
  0x23, 0xF3, 0x04, 0x5D, 0xC0, 0x0E, 0xEA, 0x10,
  // ":" (U+003A)
  0xBB, 0x11, 0x00, 0x00, 0x11, 0xBB,
  // ";" (U+003B)
  0x7D, 0x6B, 0x00, 0x00, 0x00, 0x9C, 0xC8, 0xE3,
  // "<" (U+003C)
  0x00, 0x03, 0xB2, 0x03, 0xBD, 0x60, 0x1F, 0xC1, 0x00, 0x02, 0x9E, 0x80, 0x00, 0x01, 0x92,
  // "=" (U+003D)
  0x4F, 0xFF, 0xF4, 0x13, 0x33, 0x31, 0x4F, 0xFF, 0xF4, 0x13, 0x33, 0x31,
  // ">" (U+003E)
  0x2B, 0x30, 0x00, 0x06, 0xDB, 0x30, 0x00, 0x1C, 0xF1, 0x08, 0xE9, 0x20, 0x29, 0x10, 0x00,
  // "?" (U+003F)
  0xAE, 0xD6, 0x0A, 0x59, 0xF1, 0x00, 0x5F, 0x20, 0x1D, 0xC0, 0x0B, 0xC1, 0x00, 0xC5, 0x00, 0x02,
  0x00, 0x01, 0xE6, 0x00,
  // "@" (U+0040)
  0x04, 0xDE, 0x80, 0x2E, 0x75, 0xD6, 0x97, 0xBE, 0x9C, 0xD6, 0xCA, 0x6E, 0xE6, 0x79, 0x5E, 0xE6,
  0x9B, 0x8D, 0xC6, 0xFC, 0xF7, 0x7C, 0x41, 0x40, 0x0A, 0xFF, 0xC0, 0x00, 0x12, 0x00,
  // "A" (U+0041)
  0x01, 0xFF, 0x00, 0x04, 0xEE, 0x40, 0x08, 0xBB, 0x80, 0x0C, 0x88, 0xC0, 0x0F, 0x66, 0xF0, 0x4F,
  0xFF, 0xF4, 0x8D, 0x33, 0xE8, 0xC9, 0x00, 0xAC,
  // "B" (U+0042)
  0x3F, 0xFE, 0xA0, 0x3F, 0x56, 0xF5, 0x3F, 0x23, 0xF5, 0x3F, 0xFF, 0xB0, 0x3F, 0x55, 0xF5, 0x3F,
  0x20, 0xE8, 0x3F, 0x56, 0xF6, 0x3F, 0xFE, 0xA0,
  // "C" (U+0043)
  0x01, 0xBE, 0xE5, 0x0D, 0xC4, 0x62, 0x4F, 0x30, 0x00, 0x7F, 0x00, 0x00, 0x7F, 0x00, 0x00, 0x5F,
  0x20, 0x00, 0x1E, 0xB4, 0x63, 0x03, 0xCF, 0xD3,
  // "D" (U+0044)
  0x8F, 0xFC, 0x40, 0x8E, 0x49, 0xF2, 0x8D, 0x00, 0xE8, 0x8D, 0x00, 0xCA, 0x8D, 0x00, 0xC9, 0x8D,
  0x00, 0xE7, 0x8E, 0x4A, 0xF1, 0x8F, 0xFD, 0x40,
  // "E" (U+0045)
  0x03, 0xC8, 0x90, 0x43, 0xF6, 0x33, 0x13, 0xF3, 0x30, 0x3C, 0x89, 0x02, 0x3F, 0x53, 0x30, 0x3F,
  0x33, 0x85, 0x3F, 0x63, 0x31, 0x3C, 0x04,
  // "F" (U+0046)
  0x03, 0xC8, 0x90, 0x43, 0xF6, 0x33, 0x13, 0xF3, 0x38, 0x13, 0xF3, 0x30, 0x3C, 0x89, 0x02, 0x3F,
  0x53, 0x30, 0x3F, 0x33, 0x81, 0x3F, 0x33,
  // "G" (U+0047)
  0x04, 0xCF, 0xD4, 0x1F, 0xB4, 0x71, 0x7E, 0x00, 0x00, 0x9C, 0x00, 0x00, 0xAC, 0x0B, 0xF8, 0x8E,
  0x02, 0xC8, 0x2F, 0xA4, 0xD8, 0x05, 0xDF, 0xD5,
  // "H" (U+0048)
  0x8E, 0x00, 0xE8, 0x8E, 0x00, 0xE8, 0x8E, 0x00, 0xE8, 0x8F, 0xFF, 0xF8, 0x8E, 0x33, 0xE8, 0x8E,
  0x00, 0xE8, 0x8E, 0x00, 0xE8, 0x8E, 0x00, 0xE8,
  // "I" (U+0049)
  0x01, 0xC8, 0x41, 0x03, 0xCC, 0x33, 0x00, 0xA4, 0x00, 0xA4, 0x00, 0xA4, 0x00, 0xA3, 0x84, 0x2C,
  0xB2, 0x01, 0xC0, 0x10,
  // "J" (U+004A)
  0x00, 0x08, 0xE0, 0x00, 0x8E, 0x00, 0x08, 0xE0, 0x00, 0x8E, 0x00, 0x08, 0xE0, 0x00, 0x8D, 0x16,
  0x5D, 0xA2, 0xEE, 0xB2,
  // "K" (U+004B)
  0x8D, 0x03, 0xF5, 0x8D, 0x0C, 0xB0, 0x8D, 0x6E, 0x20, 0x8E, 0xD8, 0x00, 0x8F, 0xFD, 0x00, 0x8E,
  0x3F, 0x50, 0x8D, 0x0B, 0xC0, 0x8D, 0x03, 0xF5,
  // "L" (U+004C)
  0x1F, 0x50, 0x00, 0x1F, 0x50, 0x00, 0x1F, 0x50, 0x00, 0x1F, 0x50, 0x00, 0x1F, 0x50, 0x00, 0x1F,
  0x50, 0x00, 0x1F, 0x95, 0x51, 0x1F, 0xFF, 0xF4,
  // "M" (U+004D)
  0x9F, 0x65, 0xF9, 0x9E, 0x87, 0xF9, 0x9C, 0xAA, 0xD9, 0x9B, 0xDC, 0xB9, 0x9A, 0xEE, 0xA9, 0x9A,
  0xCC, 0xA9, 0x9A, 0x00, 0xA9, 0x9A, 0x00, 0xA9,
  // "N" (U+004E)
  0x8F, 0x80, 0xB8, 0x8E, 0xD0, 0xB8, 0x8B, 0xF2, 0xB8, 0x8B, 0xB6, 0xB8, 0x8B, 0x7B, 0xB8, 0x8B,
  0x2F, 0xB8, 0x8B, 0x0D, 0xE8, 0x8B, 0x09, 0xF8,
  // "O" (U+004F)
  0x07, 0xEE, 0x70, 0x3F, 0x77, 0xF3, 0x8E, 0x00, 0xE8, 0xAC, 0x00, 0xCA, 0xAC, 0x00, 0xCA, 0x8E,
  0x00, 0xE8, 0x3F, 0x77, 0xF3, 0x07, 0xEE, 0x70,
  // "P" (U+0050)
  0x3F, 0xFE, 0xA0, 0x3F, 0x65, 0xF6, 0x3F, 0x30, 0xD8, 0x3F, 0x33, 0xF6, 0x3F, 0xFF, 0xC1, 0x3F,
  0x52, 0x00, 0x3F, 0x30, 0x00, 0x3F, 0x30, 0x00,
  // "Q" (U+0051)
  0x07, 0xEE, 0x70, 0x3F, 0x77, 0xF3, 0x8E, 0x00, 0xE8, 0xAC, 0x00, 0xCA, 0xAC, 0x00, 0xCA, 0x8E,
  0x00, 0xE8, 0x3F, 0x77, 0xF4, 0x07, 0xEF, 0xA0, 0x00, 0x0A, 0xC0, 0x00, 0x03, 0xF4,
  // "R" (U+0052)
  0x3F, 0xFD, 0x50, 0x3F, 0x69, 0xF1, 0x3F, 0x32, 0xF4, 0x3F, 0x47, 0xF2, 0x3F, 0xFF, 0x80, 0x3F,
  0x6E, 0x60, 0x3F, 0x37, 0xE1, 0x3F, 0x30, 0xE8,
  // "S" (U+0053)
  0x06, 0xDE, 0xC1, 0x0F, 0xA4, 0x80, 0x1F, 0x70, 0x00, 0x09, 0xFA, 0x10, 0x00, 0x7E, 0xE1, 0x00,
  0x03, 0xF6, 0x38, 0x47, 0xF4, 0x2C, 0xFD, 0x80,
  // "T" (U+0054)
  0x0A, 0xC8, 0x5A, 0x23, 0xCC, 0x32, 0x20, 0x0B, 0x40, 0x0B, 0x40, 0x0B, 0x40, 0x0B, 0x40, 0x0B,
  0x40, 0x0B, 0x20,
  // "U" (U+0055)
  0x8E, 0x00, 0xE8, 0x8E, 0x00, 0xE8, 0x8E, 0x00, 0xE8, 0x8E, 0x00, 0xE8, 0x8E, 0x00, 0xE8, 0x7E,
  0x00, 0xE7, 0x4F, 0x77, 0xF4, 0x08, 0xEE, 0x80,
  // "V" (U+0056)
  0xCA, 0x00, 0xAB, 0x8D, 0x00, 0xD7, 0x3F, 0x11, 0xF3, 0x0E, 0x55, 0xE0, 0x0B, 0x88, 0xB0, 0x07,
  0xBB, 0x70, 0x03, 0xEE, 0x30, 0x00, 0xEE, 0x00,
  // "W" (U+0057)
  0xD6, 0x00, 0x6D, 0xC7, 0x00, 0x7C, 0xB8, 0xBB, 0x8B, 0xA9, 0xDD, 0x9A, 0x9A, 0xDD, 0xA9, 0x8C,
  0xBB, 0xC8, 0x7E, 0x99, 0xE7, 0x6F, 0x77, 0xF6,
  // "X" (U+0058)
  0x6E, 0x11, 0xF6, 0x0D, 0x78, 0xD0, 0x05, 0xEE, 0x50, 0x00, 0xDD, 0x00, 0x00, 0xEE, 0x00, 0x07,
  0xDD, 0x70, 0x1E, 0x66, 0xE1, 0x8D, 0x00, 0xE8,
  // "Y" (U+0059)
  0x09, 0x0E, 0x28, 0x93, 0xD9, 0x2F, 0x44, 0xF2, 0x0B, 0xA9, 0xB2, 0x82, 0x5F, 0xE5, 0x30, 0x0D,
  0x40, 0x0B, 0x40, 0x0B, 0x40, 0x0B, 0x20,
  // "Z" (U+005A)
  0x0E, 0xFF, 0xF4, 0x03, 0x3A, 0xE1, 0x00, 0x0E, 0x80, 0x00, 0x7E, 0x10, 0x00, 0xE8, 0x00, 0x06,
  0xE1, 0x00, 0x0E, 0xA3, 0x31, 0x3F, 0xFF, 0xF4,
  // "[" (U+005B)
  0xAF, 0xAA, 0xA2, 0xA8, 0x0A, 0x80, 0xA8, 0x0A, 0x80, 0xA8, 0x0A, 0x80, 0xAF, 0xA2, 0x32,
  // "\" (U+005C)
  0xC6, 0x00, 0x7B, 0x00, 0x2F, 0x10, 0x0C, 0x60, 0x07, 0xC0, 0x01, 0xF2, 0x00, 0xC7, 0x00, 0x6C,
  // "]" (U+005D)
  0x23, 0x2A, 0xFA, 0x08, 0xA0, 0x8A, 0x08, 0xA0, 0x8A, 0x08, 0xA0, 0x8A, 0x2A, 0xAA, 0xFA,
  // "^" (U+005E)
  0x00, 0x97, 0x00, 0x01, 0xFE, 0x00, 0x07, 0xAB, 0x60, 0x0E, 0x34, 0xD0, 0x5C, 0x00, 0xC5,
  // "_" (U+005F)
  0xE8, 0x02, 0x30,
  // "`" (U+0060)
  0x37, 0x00, 0x99,
  // "a" (U+0061)
  0x0B, 0xEE, 0x80, 0x05, 0x56, 0xF3, 0x0B, 0xFF, 0xF5, 0x6F, 0x53, 0xF5, 0x6F, 0x58, 0xF5, 0x1C,
  0xE8, 0xD5,
  // "b" (U+0062)
  0x7F, 0x00, 0x00, 0x7F, 0x00, 0x00, 0x7E, 0x9E, 0xA0, 0x7F, 0x87, 0xF5, 0x7F, 0x00, 0xE8, 0x7F,
  0x00, 0xE8, 0x7F, 0x87, 0xF5, 0x7B, 0x8E, 0xA0,
  // "c" (U+0063)
  0x04, 0xCF, 0xD1, 0x0E, 0xB4, 0x60, 0x3F, 0x30, 0x00, 0x3F, 0x30, 0x00, 0x1E, 0xB4, 0x70, 0x05,
  0xDF, 0xC0,
  // "d" (U+0064)
  0x00, 0x00, 0xF7, 0x00, 0x00, 0xF7, 0x0A, 0xEA, 0xE7, 0x5F, 0x77, 0xF7, 0x8E, 0x00, 0xE7, 0x8E,
  0x00, 0xD7, 0x5F, 0x76, 0xF7, 0x0B, 0xE9, 0xD7,
  // "e" (U+0065)
  0x06, 0xEE, 0x80, 0x3F, 0x76, 0xE4, 0x7F, 0xFF, 0xF7, 0x6F, 0x33, 0x31, 0x2F, 0xA4, 0x63, 0x05,
  0xCF, 0xD3,
  // "f" (U+0066)
  0x00, 0x5E, 0xF9, 0x00, 0xDC, 0x42, 0x3D, 0xFF, 0xF5, 0x13, 0xEA, 0x31, 0x00, 0xD9, 0x00, 0x00,
  0xD9, 0x00, 0x00, 0xD9, 0x00, 0x00, 0xD9, 0x00,
  // "g" (U+0067)
  0x0A, 0xE9, 0xD7, 0x5F, 0x77, 0xF7, 0x8E, 0x00, 0xE7, 0x8E, 0x00, 0xE7, 0x5F, 0x77, 0xF7, 0x0A,
  0xE9, 0xF7, 0x00, 0x00, 0xF6, 0x28, 0x48, 0xF2, 0x2D, 0xFD, 0x60,
  // "h" (U+0068)
  0x7F, 0x00, 0x00, 0x7F, 0x00, 0x00, 0x7F, 0x9E, 0xB0, 0x7F, 0x86, 0xF6, 0x7F, 0x10, 0xF7, 0x7F,
  0x00, 0xE7, 0x7F, 0x00, 0xE7, 0x7F, 0x00, 0xE7,
  // "i" (U+0069)
  0x20, 0x80, 0xD4, 0x01, 0x02, 0x20, 0x1A, 0x0D, 0x38, 0x13, 0xAD, 0x40, 0x90, 0xD4, 0x09, 0x0D,
  0x38, 0x42, 0xAE, 0x20, 0x6C, 0x07,
  // "j" (U+006A)
  0x00, 0x4E, 0x30, 0x00, 0x30, 0x0A, 0xFF, 0x40, 0x27, 0xF4, 0x00, 0x2F, 0x40, 0x02, 0xF4, 0x00,
  0x2F, 0x40, 0x02, 0xF4, 0x00, 0x3F, 0x44, 0x6A, 0xF1, 0x7F, 0xE7, 0x00,
  // "k" (U+006B)
  0x6F, 0x00, 0x00, 0x6F, 0x00, 0x00, 0x6F, 0x05, 0xF5, 0x6F, 0x3E, 0x80, 0x6F, 0xCD, 0x00, 0x6F,
  0xCF, 0x40, 0x6F, 0x09, 0xD0, 0x6F, 0x01, 0xE8,
  // "l" (U+006C)
  0x1A, 0x0D, 0x38, 0x11, 0xAD, 0x40, 0x90, 0xD4, 0x09, 0x0D, 0x40, 0x90, 0xD4, 0x09, 0x0D, 0x38,
  0x41, 0xAD, 0x10, 0x6C, 0x07,
  // "m" (U+006D)
  0xAA, 0xE7, 0xE6, 0xAB, 0xBC, 0xBA, 0xA8, 0x99, 0x8A, 0xA8, 0x99, 0x8A, 0xA8, 0x99, 0x8A, 0xA8,
  0x99, 0x8A,
  // "n" (U+006E)
  0x7C, 0x9E, 0xB0, 0x7F, 0x96, 0xF6, 0x7F, 0x10, 0xF7, 0x7F, 0x00, 0xE7, 0x7F, 0x00, 0xE7, 0x7F,
  0x00, 0xE7,
  // "o" (U+006F)
  0x07, 0xEE, 0x70, 0x4F, 0x77, 0xF4, 0x8E, 0x00, 0xE8, 0x8E, 0x00, 0xE8, 0x4F, 0x77, 0xF4, 0x08,
  0xEE, 0x70,
  // "p" (U+0070)
  0x7C, 0x9E, 0xA0, 0x7F, 0x87, 0xF5, 0x7F, 0x00, 0xE8, 0x7F, 0x00, 0xE8, 0x7F, 0x87, 0xF5, 0x7E,
  0xAE, 0x90, 0x7F, 0x00, 0x00, 0x7F, 0x00, 0x00, 0x7F, 0x00, 0x00,
  // "q" (U+0071)
  0x0A, 0xE9, 0xC7, 0x5F, 0x77, 0xF7, 0x8E, 0x00, 0xE7, 0x8E, 0x00, 0xE7, 0x5F, 0x77, 0xF7, 0x0B,
  0xE9, 0xE7, 0x00, 0x00, 0xF7, 0x00, 0x00, 0xF7, 0x00, 0x00, 0xF7,
  // "r" (U+0072)
  0x4F, 0xF7, 0xEA, 0x03, 0xFC, 0x42, 0x02, 0xF5, 0x00, 0x02, 0xF4, 0x00, 0x05, 0xF7, 0x10, 0x9F,
  0xFF, 0xA0,
  // "s" (U+0073)
  0x07, 0xEE, 0xB0, 0x1F, 0x94, 0x70, 0x0D, 0xE8, 0x10, 0x00, 0x7E, 0xE0, 0x27, 0x48, 0xF2, 0x2D,
  0xFE, 0x80,
  // "t" (U+0074)
  0x00, 0x71, 0x00, 0x00, 0xF3, 0x00, 0x5E, 0xFF, 0xF4, 0x16, 0xF6, 0x41, 0x03, 0xF3, 0x00, 0x03,
  0xF3, 0x00, 0x01, 0xF9, 0x42, 0x00, 0x8E, 0xE4,
  // "u" (U+0075)
  0x7E, 0x00, 0xF7, 0x7E, 0x00, 0xF7, 0x7E, 0x00, 0xF7, 0x7E, 0x01, 0xF7, 0x6F, 0x69, 0xF7, 0x0B,
  0xE9, 0xC7,
  // "v" (U+0076)
  0x9E, 0x00, 0xD9, 0x4F, 0x32, 0xF4, 0x0E, 0x76, 0xE0, 0x09, 0xBB, 0x90, 0x04, 0xFE, 0x40, 0x00,
  0xEE, 0x00,
  // "w" (U+0077)
  0xE5, 0x00, 0x5E, 0xC7, 0xBB, 0x6C, 0xA8, 0xDD, 0x7A, 0x8A, 0xDD, 0xA8, 0x6E, 0xAA, 0xE6, 0x4F,
  0x88, 0xF4,
  // "x" (U+0078)
  0x6F, 0x43, 0xF7, 0x0C, 0xCB, 0xC0, 0x02, 0xFF, 0x30, 0x03, 0xFF, 0x30, 0x0C, 0xBB, 0xD0, 0x7F,
  0x33, 0xF7,
  // "y" (U+0079)
  0x9E, 0x00, 0xD9, 0x4F, 0x32, 0xF4, 0x0E, 0x76, 0xE0, 0x09, 0xCA, 0xA0, 0x04, 0xFE, 0x50, 0x00,
  0xEF, 0x00, 0x00, 0xBB, 0x00, 0x28, 0xF4, 0x00, 0x6E, 0x80, 0x00,
  // "z" (U+007A)
  0x3F, 0xFF, 0xF4, 0x03, 0x4D, 0xD1, 0x00, 0x7F, 0x30, 0x03, 0xF6, 0x00, 0x1D, 0xC3, 0x31, 0x5F,
  0xFF, 0xF5,
  // "{" (U+007B)
  0x02, 0xD9, 0x07, 0xD3, 0x07, 0xB0, 0x0A, 0xB0, 0x9E, 0x40, 0x2C, 0xA0, 0x07, 0xB0, 0x07, 0xD0,
  0x03, 0xF9, 0x00, 0x11,
  // "|" (U+007C)
  0x80, 0xA2, 0x80,
  // "}" (U+007D)
  0x11, 0x00, 0x9F, 0x30, 0x1D, 0x70, 0x0B, 0x70, 0x0A, 0xC2, 0x04, 0xE9, 0x0B, 0xA0, 0x0B, 0x70,
  0x3D, 0x70, 0x9D, 0x20,
  // "~" (U+007E)
  0x0D, 0xD4, 0x93, 0x47, 0x4E, 0xE0, 0x11, 0x01, 0x10,
  // "¡" (U+00A1)
  0xBB, 0x11, 0x00, 0xAA, 0xAA, 0xBB, 0xCC, 0xCC,
  // "¢" (U+00A2)
  0x00, 0x0C, 0x00, 0x05, 0xEF, 0xF2, 0x1E, 0x91, 0x30, 0x3F, 0x20, 0x00, 0x3F, 0x20, 0x00, 0x0E,
  0xA3, 0x51, 0x04, 0xDF, 0xE1, 0x00, 0x0C, 0x00,
  // "£" (U+00A3)
  0x28, 0x7A, 0xED, 0x20, 0x5F, 0x66, 0x20, 0x79, 0x30, 0x3B, 0x09, 0x28, 0x28, 0xF3, 0x22, 0x07,
  0x0D, 0x48, 0x4C, 0xA3, 0x31, 0x2C, 0x06,
  // "¤" (U+00A4)
  0x01, 0x00, 0x10, 0x3E, 0xDD, 0xE2, 0x0D, 0x77, 0xD0, 0x0E, 0x33, 0xE0, 0x2E, 0xFF, 0xE1, 0x04,
  0x11, 0x40,
  // "¥" (U+00A5)
  0x8D, 0x00, 0xE8, 0x1F, 0x55, 0xF1, 0x09, 0xBB, 0x90, 0x02, 0xFF, 0x20, 0x1F, 0xFF, 0xF1, 0x03,
  0xBB, 0x30, 0x1F, 0xFF, 0xF1, 0x03, 0xBB, 0x30,
  // "¦" (U+00A6)
  0x80, 0x48, 0x68, 0x04, 0x80,
  // "§" (U+00A7)
  0x5D, 0xE8, 0xDA, 0x45, 0x7E, 0x81, 0xC7, 0xAC, 0xBB, 0x7C, 0x05, 0xD9, 0x74, 0x9D, 0xAE, 0xD5,
  // "¨" (U+00A8)
  0xB6, 0x6C, 0x10, 0x01,
  // "©" (U+00A9)
  0x08, 0xEE, 0x80, 0x5B, 0xDF, 0xA5, 0xA7, 0xA4, 0x0A, 0xA7, 0x81, 0x1A, 0x7B, 0xDF, 0xB7, 0x0B,
  0xFF, 0xB0, 0x00, 0x22, 0x00,
  // "ª" (U+00AA)
  0x1B, 0xD3, 0x3C, 0xD8, 0x87, 0x88, 0x3C, 0x97,
  // "«" (U+00AB)
  0x02, 0xC2, 0xC2, 0x0D, 0x9B, 0xB0, 0x3F, 0x6E, 0x60, 0x07, 0xD6, 0xE1, 0x00, 0x50, 0x40,
  // "¬" (U+00AC)
  0x04, 0xC8, 0x53, 0x13, 0x33, 0xE3, 0x40, 0xD0, 0x34, 0x02, 0x10,
  // "®" (U+00AE)
  0x08, 0xEE, 0x80, 0x5D, 0xFE, 0xC5, 0xA3, 0x9A, 0x3A, 0xA2, 0xDC, 0x1A, 0x6B, 0x88, 0xB7, 0x0B,
  0xFF, 0xB0, 0x00, 0x22, 0x00,
  // "¯" (U+00AF)
  0x8F, 0xF8, 0x13, 0x31,
  // "°" (U+00B0)
  0x2D, 0xD2, 0x89, 0x98, 0x4F, 0xF4, 0x01, 0x10,
  // "±" (U+00B1)
  0x20, 0x08, 0x40, 0x08, 0x20, 0x4C, 0x85, 0x40, 0x39, 0xA3, 0x12, 0x00, 0x82, 0x85, 0x13, 0x33,
  0x31, 0x4C, 0x04,
  // "²" (U+00B2)
  0x3C, 0xC1, 0x11, 0xA5, 0x02, 0xD1, 0x1C, 0x40, 0x6E, 0xD7,
  // "³" (U+00B3)
  0x3C, 0xC1, 0x01, 0xB4, 0x0A, 0xD1, 0x10, 0x96, 0x5D, 0xC2,
  // "´" (U+00B4)
  0x07, 0x47, 0xB1,
  // "µ" (U+00B5)
  0x7E, 0x00, 0xF7, 0x7E, 0x00, 0xF7, 0x7E, 0x00, 0xF7, 0x7E, 0x01, 0xF7, 0x7F, 0x69, 0xF7, 0x7F,
  0xE9, 0xC7, 0x7E, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x7E, 0x00, 0x00,
  // "¶" (U+00B6)
  0x09, 0xEF, 0xF7, 0x5F, 0xFF, 0x77, 0x8F, 0xFF, 0x47, 0x8F, 0xFF, 0x47, 0x4F, 0xFF, 0x47, 0x04,
  0x8D, 0x47, 0x00, 0x0B, 0x47, 0x00, 0x0B, 0x47, 0x00, 0x0B, 0x47, 0x00, 0x08, 0x35,
  // "·" (U+00B7)
  0x11, 0xBB,
  // "¸" (U+00B8)
  0x43, 0x3E, 0xCA,
  // "¹" (U+00B9)
  0x2B, 0xA0, 0x27, 0xA0, 0x04, 0xA0, 0x2B, 0xD6,
  // "º" (U+00BA)
  0x2C, 0xC1, 0x77, 0x77, 0x77, 0x77, 0x1B, 0xB1,
  // "»" (U+00BB)
  0x04, 0x05, 0x00, 0x2E, 0x6D, 0x70, 0x06, 0xE6, 0xF3, 0x0B, 0xB9, 0xC0, 0x2C, 0x2C, 0x20,
  // "¼" (U+00BC)
  0x7D, 0x00, 0x00, 0x4C, 0x00, 0x94, 0x0C, 0x06, 0xA0, 0x8E, 0xAD, 0x10, 0x00, 0xC3, 0x72, 0x09,
  0x76, 0xC4, 0x3A, 0x0B, 0xC9, 0x00, 0x00, 0x63,
  // "½" (U+00BD)
  0x7D, 0x00, 0x00, 0x4C, 0x00, 0x94, 0x0C, 0x06, 0xA0, 0x7E, 0x9D, 0x10, 0x00, 0xC9, 0xE7, 0x07,
  0x92, 0x68, 0x3C, 0x01, 0xA1, 0x00, 0x08, 0xFD, 0x00, 0x01, 0x32,
  // "¾" (U+00BE)
  0x6F, 0x70, 0x00, 0x3F, 0x50, 0x84, 0x27, 0x95, 0xB0, 0x9F, 0xAD, 0x10, 0x03, 0xC3, 0x61, 0x09,
  0x76, 0xC4, 0x3A, 0x0B, 0xC9, 0x00, 0x00, 0x63,
  // "¿" (U+00BF)
  0x00, 0x7E, 0x10, 0x00, 0x20, 0x00, 0x5C, 0x00, 0x1C, 0xB0, 0x0C, 0xD2, 0x02, 0xF5, 0x00, 0x1F,
  0x85, 0xA0, 0x6E, 0xEA,
  // "À" (U+00C0)
  0x10, 0x30, 0x75, 0x00, 0x97, 0x20, 0x1A, 0x38, 0x24, 0xEE, 0x42, 0x82, 0x8B, 0xB8, 0x28, 0x2C,
  0x88, 0xC2, 0x98, 0x36, 0x6F, 0x04, 0xC8, 0x74, 0x8D, 0x33, 0xE8, 0xC9, 0x20, 0xA0, 0xC0,
  // "Á" (U+00C1)
  0x30, 0x70, 0x43, 0x81, 0x7B, 0x17, 0x10, 0x1A, 0x38, 0x24, 0xEE, 0x42, 0x82, 0x8B, 0xB8, 0x28,
  0x2C, 0x88, 0xC2, 0x98, 0x36, 0x6F, 0x04, 0xC8, 0x74, 0x8D, 0x33, 0xE8, 0xC9, 0x20, 0xA0, 0xC0,
  // "Â" (U+00C2)
  0x20, 0x60, 0x73, 0x82, 0x7A, 0x98, 0x71, 0x01, 0xA3, 0x82, 0x4E, 0xE4, 0x28, 0x28, 0xBB, 0x82,
  0x82, 0xC8, 0x8C, 0x29, 0x83, 0x66, 0xF0, 0x4C, 0x87, 0x48, 0xD3, 0x3E, 0x8C, 0x92, 0x0A, 0x0C,
  // "Ã" (U+00C3)
  0x06, 0xC1, 0xB0, 0x0B, 0x5E, 0x80, 0x01, 0x00, 0x00, 0x01, 0xFF, 0x00, 0x04, 0xEE, 0x40, 0x08,
  0xBB, 0x80, 0x0C, 0x88, 0xC0, 0x0F, 0x66, 0xF0, 0x4F, 0xFF, 0xF4, 0x8D, 0x33, 0xE8, 0xC9, 0x00,
  0xAC,
  // "Ä" (U+00C4)
  0x0B, 0x66, 0xC0, 0x01, 0x00, 0x10, 0x01, 0xFF, 0x00, 0x04, 0xEE, 0x40, 0x08, 0xBB, 0x80, 0x0C,
  0x88, 0xC0, 0x0F, 0x66, 0xF0, 0x4F, 0xFF, 0xF4, 0x8D, 0x33, 0xE8, 0xC9, 0x00, 0xAC,
  // "Å" (U+00C5)
  0x01, 0xDD, 0x00, 0x01, 0xFE, 0x10, 0x01, 0xFF, 0x00, 0x04, 0xEE, 0x40, 0x08, 0xBB, 0x80, 0x0C,
  0x88, 0xC0, 0x0F, 0x66, 0xF0, 0x4F, 0xFF, 0xF4, 0x8D, 0x33, 0xE8, 0xC9, 0x00, 0xAC,
  // "Æ" (U+00C6)
  0x04, 0xFF, 0xFA, 0x08, 0xBE, 0x72, 0x0B, 0x8E, 0x40, 0x0E, 0x5E, 0xF8, 0x2F, 0x3E, 0x71, 0x5F,
  0xFF, 0x40, 0x9C, 0x3E, 0x72, 0xC8, 0x0E, 0xFA,
  // "Ç" (U+00C7)
  0x18, 0x94, 0x1B, 0xEE, 0x50, 0xDC, 0x46, 0x24, 0xF3, 0x30, 0x79, 0x40, 0x79, 0x48, 0x15, 0xF2,
  0x38, 0x92, 0x1E, 0xB4, 0x63, 0x03, 0xCF, 0xD3, 0x20, 0x40, 0x34, 0x03, 0x0E, 0x40, 0xC0, 0xA2,
  // "È" (U+00C8)
  0x10, 0x30, 0x75, 0x00, 0x97, 0x10, 0x3C, 0x89, 0x04, 0x3F, 0x63, 0x31, 0x3F, 0x33, 0x03, 0xC8,
  0x90, 0x23, 0xF5, 0x33, 0x03, 0xF3, 0x38, 0x53, 0xF6, 0x33, 0x13, 0xC0, 0x40,
  // "É" (U+00C9)
  0x30, 0x70, 0x43, 0x81, 0x7B, 0x17, 0x03, 0xC8, 0x90, 0x43, 0xF6, 0x33, 0x13, 0xF3, 0x30, 0x3C,
  0x89, 0x02, 0x3F, 0x53, 0x30, 0x3F, 0x33, 0x85, 0x3F, 0x63, 0x31, 0x3C, 0x04,
  // "Ê" (U+00CA)
  0x20, 0x60, 0x73, 0x82, 0x7A, 0x98, 0x70, 0x3C, 0x89, 0x04, 0x3F, 0x63, 0x31, 0x3F, 0x33, 0x03,
  0xC8, 0x90, 0x23, 0xF5, 0x33, 0x03, 0xF3, 0x38, 0x53, 0xF6, 0x33, 0x13, 0xC0, 0x40,
  // "Ë" (U+00CB)
  0x0B, 0x66, 0xC0, 0x01, 0x00, 0x10, 0x3F, 0xFF, 0xF4, 0x3F, 0x63, 0x31, 0x3F, 0x30, 0x00, 0x3F,
  0xFF, 0xF2, 0x3F, 0x53, 0x30, 0x3F, 0x30, 0x00, 0x3F, 0x63, 0x31, 0x3F, 0xFF, 0xF4,
  // "Ì" (U+00CC)
  0x10, 0x30, 0x75, 0x00, 0x97, 0x10, 0x1C, 0x84, 0x10, 0x3C, 0xC3, 0x30, 0x0A, 0x40, 0x0A, 0x40,
  0x0A, 0x40, 0x0A, 0x38, 0x42, 0xCB, 0x20, 0x1C, 0x01,
  // "Í" (U+00CD)
  0x30, 0x70, 0x43, 0x81, 0x7B, 0x17, 0x01, 0xC8, 0x41, 0x03, 0xCC, 0x33, 0x00, 0xA4, 0x00, 0xA4,
  0x00, 0xA4, 0x00, 0xA3, 0x84, 0x2C, 0xB2, 0x01, 0xC0, 0x10,
  // "Î" (U+00CE)
  0x20, 0x60, 0x73, 0x82, 0x7A, 0x98, 0x70, 0x1C, 0x84, 0x10, 0x3C, 0xC3, 0x30, 0x0A, 0x40, 0x0A,
  0x40, 0x0A, 0x40, 0x0A, 0x38, 0x42, 0xCB, 0x20, 0x1C, 0x01,
  // "Ï" (U+00CF)
  0x18, 0x2B, 0x66, 0xC2, 0x01, 0x28, 0x11, 0x01, 0xC8, 0x41, 0x03, 0xCC, 0x33, 0x00, 0xA4, 0x00,
  0xA4, 0x00, 0xA4, 0x00, 0xA3, 0x84, 0x2C, 0xB2, 0x01, 0xC0, 0x10,
  // "Ð" (U+00D0)
  0x8F, 0xFC, 0x40, 0x8E, 0x49, 0xF2, 0x8D, 0x00, 0xE8, 0x8D, 0x00, 0xCA, 0xFF, 0xE0, 0xC9, 0xAE,
  0x30, 0xE7, 0x8E, 0x4A, 0xF1, 0x8F, 0xFD, 0x40,
  // "Ñ" (U+00D1)
  0x06, 0xC1, 0xB0, 0x0B, 0x5E, 0x80, 0x01, 0x00, 0x00, 0x8F, 0x80, 0xB8, 0x8E, 0xD0, 0xB8, 0x8B,
  0xF2, 0xB8, 0x8B, 0xB6, 0xB8, 0x8B, 0x7B, 0xB8, 0x8B, 0x2F, 0xB8, 0x8B, 0x0D, 0xE8, 0x8B, 0x09,
  0xF8,
  // "Ò" (U+00D2)
  0x03, 0x70, 0x00, 0x00, 0x99, 0x00, 0x00, 0x00, 0x00, 0x07, 0xEE, 0x70, 0x3F, 0x77, 0xF3, 0x8E,
  0x00, 0xE8, 0xAC, 0x00, 0xCA, 0xAC, 0x00, 0xCA, 0x8E, 0x00, 0xE8, 0x3F, 0x77, 0xF3, 0x07, 0xEE,
  0x70,
  // "Ó" (U+00D3)
  0x00, 0x07, 0x40, 0x00, 0x7B, 0x10, 0x00, 0x00, 0x00, 0x07, 0xEE, 0x70, 0x3F, 0x77, 0xF3, 0x8E,
  0x00, 0xE8, 0xAC, 0x00, 0xCA, 0xAC, 0x00, 0xCA, 0x8E, 0x00, 0xE8, 0x3F, 0x77, 0xF3, 0x07, 0xEE,
  0x70,
  // "Ô" (U+00D4)
  0x00, 0x67, 0x00, 0x07, 0xA9, 0x80, 0x00, 0x00, 0x00, 0x07, 0xEE, 0x70, 0x3F, 0x77, 0xF3, 0x8E,
  0x00, 0xE8, 0xAC, 0x00, 0xCA, 0xAC, 0x00, 0xCA, 0x8E, 0x00, 0xE8, 0x3F, 0x77, 0xF3, 0x07, 0xEE,
  0x70,
  // "Õ" (U+00D5)
  0x06, 0xC1, 0xB0, 0x0B, 0x5E, 0x80, 0x01, 0x00, 0x00, 0x07, 0xEE, 0x70, 0x3F, 0x77, 0xF3, 0x8E,
  0x00, 0xE8, 0xAC, 0x00, 0xCA, 0xAC, 0x00, 0xCA, 0x8E, 0x00, 0xE8, 0x3F, 0x77, 0xF3, 0x07, 0xEE,
  0x70,
  // "Ö" (U+00D6)
  0x0B, 0x66, 0xC0, 0x01, 0x00, 0x10, 0x07, 0xEE, 0x70, 0x3F, 0x77, 0xF3, 0x8E, 0x00, 0xE8, 0xAC,
  0x00, 0xCA, 0xAC, 0x00, 0xCA, 0x8E, 0x00, 0xE8, 0x3F, 0x77, 0xF3, 0x07, 0xEE, 0x70,
  // "×" (U+00D7)
  0x70, 0x07, 0xBB, 0xBA, 0x1E, 0xE1, 0xBA, 0xBB, 0x60, 0x06,
  // "Ø" (U+00D8)
  0x58, 0xE0, 0x10, 0x7E, 0xEB, 0x93, 0xF7, 0x8F, 0x48, 0xE0, 0x9F, 0x8A, 0xC3, 0xDC, 0xAA, 0xCC,
  0x4C, 0xA8, 0xFA, 0x0E, 0x84, 0xF8, 0x7F, 0x39, 0xBE, 0xE7, 0x02, 0x50,
  // "Ù" (U+00D9)
  0x03, 0x70, 0x00, 0x00, 0x99, 0x00, 0x00, 0x00, 0x00, 0x8E, 0x00, 0xE8, 0x8E, 0x00, 0xE8, 0x8E,
  0x00, 0xE8, 0x8E, 0x00, 0xE8, 0x8E, 0x00, 0xE8, 0x7E, 0x00, 0xE7, 0x4F, 0x77, 0xF4, 0x08, 0xEE,
  0x80,
  // "Ú" (U+00DA)
  0x00, 0x07, 0x40, 0x00, 0x7B, 0x10, 0x00, 0x00, 0x00, 0x8E, 0x00, 0xE8, 0x8E, 0x00, 0xE8, 0x8E,
  0x00, 0xE8, 0x8E, 0x00, 0xE8, 0x8E, 0x00, 0xE8, 0x7E, 0x00, 0xE7, 0x4F, 0x77, 0xF4, 0x08, 0xEE,
  0x80,
  // "Û" (U+00DB)
  0x00, 0x67, 0x00, 0x07, 0xA9, 0x80, 0x00, 0x00, 0x00, 0x8E, 0x00, 0xE8, 0x8E, 0x00, 0xE8, 0x8E,
  0x00, 0xE8, 0x8E, 0x00, 0xE8, 0x8E, 0x00, 0xE8, 0x7E, 0x00, 0xE7, 0x4F, 0x77, 0xF4, 0x08, 0xEE,
  0x80,
  // "Ü" (U+00DC)
  0x0B, 0x66, 0xC0, 0x01, 0x00, 0x10, 0x8E, 0x00, 0xE8, 0x8E, 0x00, 0xE8, 0x8E, 0x00, 0xE8, 0x8E,
  0x00, 0xE8, 0x8E, 0x00, 0xE8, 0x7E, 0x00, 0xE7, 0x4F, 0x77, 0xF4, 0x08, 0xEE, 0x80,
  // "Ý" (U+00DD)
  0x30, 0x70, 0x43, 0x81, 0x7B, 0x17, 0x09, 0x0E, 0x28, 0x93, 0xD9, 0x2F, 0x44, 0xF2, 0x0B, 0xA9,
  0xB2, 0x82, 0x5F, 0xE5, 0x30, 0x0D, 0x40, 0x0B, 0x40, 0x0B, 0x40, 0x0B, 0x20,
  // "Þ" (U+00DE)
  0x3F, 0x30, 0x00, 0x3F, 0x30, 0x00, 0x3F, 0xFF, 0xB1, 0x3F, 0x54, 0xF7, 0x3F, 0x32, 0xE7, 0x3F,
  0xFF, 0xD2, 0x3F, 0x52, 0x00, 0x3F, 0x30, 0x00,
  // "ß" (U+00DF)
  0x09, 0xED, 0x70, 0x5F, 0x69, 0xF1, 0x7F, 0x09, 0xD0, 0x7E, 0x4F, 0x20, 0x7E, 0x3F, 0x90, 0x7E,
  0x04, 0xE8, 0x7E, 0x44, 0xDA, 0x7E, 0x7F, 0xD3,
  // "à" (U+00E0)
  0x10, 0x30, 0x75, 0x00, 0x97, 0x28, 0x2B, 0xEE, 0x82, 0x85, 0x55, 0x6F, 0x30, 0xBB, 0x8A, 0x15,
  0x6F, 0x53, 0xF5, 0x6F, 0x58, 0xF5, 0x1C, 0xE8, 0xD5,
  // "á" (U+00E1)
  0x30, 0x70, 0x43, 0x81, 0x7B, 0x17, 0x18, 0x2B, 0xEE, 0x82, 0x85, 0x55, 0x6F, 0x30, 0xBB, 0x8A,
  0x15, 0x6F, 0x53, 0xF5, 0x6F, 0x58, 0xF5, 0x1C, 0xE8, 0xD5,
  // "â" (U+00E2)
  0x00, 0x67, 0x00, 0x07, 0xA9, 0x80, 0x00, 0x00, 0x00, 0x0B, 0xEE, 0x80, 0x05, 0x56, 0xF3, 0x0B,
  0xFF, 0xF5, 0x6F, 0x53, 0xF5, 0x6F, 0x58, 0xF5, 0x1C, 0xE8, 0xD5,
  // "ã" (U+00E3)
  0x06, 0xC1, 0xB0, 0x0B, 0x5E, 0x80, 0x01, 0x00, 0x00, 0x0B, 0xEE, 0x80, 0x05, 0x56, 0xF3, 0x0B,
  0xFF, 0xF5, 0x6F, 0x53, 0xF5, 0x6F, 0x58, 0xF5, 0x1C, 0xE8, 0xD5,
  // "ä" (U+00E4)
  0x0B, 0x66, 0xC0, 0x01, 0x00, 0x10, 0x0B, 0xEE, 0x80, 0x05, 0x56, 0xF3, 0x0B, 0xFF, 0xF5, 0x6F,
  0x53, 0xF5, 0x6F, 0x58, 0xF5, 0x1C, 0xE8, 0xD5,
  // "å" (U+00E5)
  0x01, 0xDD, 0x00, 0x01, 0xFE, 0x10, 0x0B, 0xFF, 0x80, 0x05, 0x56, 0xF3, 0x0B, 0xFF, 0xF5, 0x6F,
  0x53, 0xF5, 0x6F, 0x58, 0xF5, 0x1C, 0xE8, 0xD5,
  // "æ" (U+00E6)
  0x5E, 0xCB, 0xE4, 0x14, 0xCC, 0x9B, 0x6F, 0xFF, 0xFD, 0xDA, 0xAB, 0x33, 0xD9, 0xCE, 0x54, 0x7E,
  0x79, 0xE8,
  // "ç" (U+00E7)
  0x04, 0xCF, 0xD1, 0x0E, 0xB4, 0x60, 0x3F, 0x30, 0x00, 0x3F, 0x30, 0x00, 0x1E, 0xB4, 0x70, 0x05,
  0xDF, 0xC0, 0x00, 0x43, 0x00, 0x00, 0x3E, 0x00, 0x00, 0xCA, 0x00,
  // "è" (U+00E8)
  0x10, 0x30, 0x75, 0x00, 0x97, 0x28, 0x92, 0x6E, 0xE8, 0x03, 0xF7, 0x6E, 0x47, 0xC8, 0xA1, 0x76,
  0xF3, 0x33, 0x12, 0xFA, 0x46, 0x30, 0x5C, 0xFD, 0x30,
  // "é" (U+00E9)
  0x30, 0x70, 0x43, 0x81, 0x7B, 0x17, 0x18, 0x92, 0x6E, 0xE8, 0x03, 0xF7, 0x6E, 0x47, 0xC8, 0xA1,
  0x76, 0xF3, 0x33, 0x12, 0xFA, 0x46, 0x30, 0x5C, 0xFD, 0x30,
  // "ê" (U+00EA)
  0x20, 0x60, 0x73, 0x82, 0x7A, 0x98, 0x71, 0x89, 0x26, 0xEE, 0x80, 0x3F, 0x76, 0xE4, 0x7C, 0x8A,
  0x17, 0x6F, 0x33, 0x31, 0x2F, 0xA4, 0x63, 0x05, 0xCF, 0xD3,
  // "ë" (U+00EB)
  0x0B, 0x66, 0xC0, 0x01, 0x00, 0x10, 0x06, 0xEE, 0x80, 0x3F, 0x76, 0xE4, 0x7F, 0xFF, 0xF7, 0x6F,
  0x33, 0x31, 0x2F, 0xA4, 0x63, 0x05, 0xCF, 0xD3,
  // "ì" (U+00EC)
  0x10, 0x30, 0x75, 0x00, 0x97, 0x10, 0x1A, 0x0D, 0x38, 0x13, 0xAD, 0x40, 0x90, 0xD4, 0x09, 0x0D,
  0x38, 0x42, 0xAE, 0x20, 0x6C, 0x07,
  // "í" (U+00ED)
  0x30, 0x70, 0x43, 0x81, 0x7B, 0x17, 0x01, 0xA0, 0xD3, 0x81, 0x3A, 0xD4, 0x09, 0x0D, 0x40, 0x90,
  0xD3, 0x84, 0x2A, 0xE2, 0x06, 0xC0, 0x70,
  // "î" (U+00EE)
  0x20, 0x60, 0x73, 0x82, 0x7A, 0x98, 0x70, 0x1A, 0x0D, 0x38, 0x13, 0xAD, 0x40, 0x90, 0xD4, 0x09,
  0x0D, 0x38, 0x42, 0xAE, 0x20, 0x6C, 0x07,
  // "ï" (U+00EF)
  0x0B, 0x66, 0xC0, 0x01, 0x00, 0x10, 0x1F, 0xFD, 0x00, 0x03, 0xAD, 0x00, 0x00, 0x9D, 0x00, 0x00,
  0x9D, 0x00, 0x02, 0xAE, 0x20, 0x6F, 0xFF, 0xF7,
  // "ð" (U+00F0)
  0x02, 0xC7, 0xA0, 0x01, 0xEF, 0x50, 0x02, 0x57, 0xE0, 0x0A, 0xFD, 0xF5, 0x6F, 0x55, 0xF8, 0x8E,
  0x00, 0xD8, 0x6F, 0x66, 0xF4, 0x09, 0xEE, 0x70,
  // "ñ" (U+00F1)
  0x06, 0xC1, 0xB0, 0x0B, 0x5E, 0x80, 0x01, 0x00, 0x00, 0x7C, 0x9E, 0xB0, 0x7F, 0x96, 0xF6, 0x7F,
  0x10, 0xF7, 0x7F, 0x00, 0xE7, 0x7F, 0x00, 0xE7, 0x7F, 0x00, 0xE7,
  // "ò" (U+00F2)
  0x10, 0x30, 0x75, 0x00, 0x97, 0x28, 0x93, 0x7E, 0xE7, 0x04, 0xF7, 0x7F, 0x48, 0xE2, 0x82, 0xE8,
  0x8E, 0x28, 0x93, 0xE8, 0x4F, 0x77, 0xF4, 0x08, 0xEE, 0x71,
  // "ó" (U+00F3)
  0x00, 0x07, 0x40, 0x00, 0x7B, 0x10, 0x00, 0x00, 0x00, 0x07, 0xEE, 0x70, 0x4F, 0x77, 0xF4, 0x8E,
  0x00, 0xE8, 0x8E, 0x00, 0xE8, 0x4F, 0x77, 0xF4, 0x08, 0xEE, 0x70,
  // "ô" (U+00F4)
  0x00, 0x67, 0x00, 0x07, 0xA9, 0x80, 0x00, 0x00, 0x00, 0x07, 0xEE, 0x70, 0x4F, 0x77, 0xF4, 0x8E,
  0x00, 0xE8, 0x8E, 0x00, 0xE8, 0x4F, 0x77, 0xF4, 0x08, 0xEE, 0x70,
  // "õ" (U+00F5)
  0x06, 0xC1, 0xB0, 0x0B, 0x5E, 0x80, 0x01, 0x00, 0x00, 0x07, 0xEE, 0x70, 0x4F, 0x77, 0xF4, 0x8E,
  0x00, 0xE8, 0x8E, 0x00, 0xE8, 0x4F, 0x77, 0xF4, 0x08, 0xEE, 0x70,
  // "ö" (U+00F6)
  0x0B, 0x66, 0xC0, 0x01, 0x00, 0x10, 0x07, 0xEE, 0x70, 0x4F, 0x77, 0xF4, 0x8E, 0x00, 0xE8, 0x8E,
  0x00, 0xE8, 0x4F, 0x77, 0xF4, 0x08, 0xEE, 0x70,
  // "÷" (U+00F7)
  0x20, 0x08, 0x40, 0x01, 0x20, 0x4C, 0x85, 0x41, 0x33, 0x33, 0x12, 0x00, 0x84, 0x00, 0x12,
  // "ø" (U+00F8)
  0x07, 0xEE, 0xE1, 0x4F, 0x7B, 0xF4, 0x8E, 0x2D, 0xE8, 0x8E, 0xC4, 0xE8, 0x4F, 0xC7, 0xF4, 0x1E,
  0xEE, 0x70, 0x01, 0x00, 0x00,
  // "ù" (U+00F9)
  0x03, 0x70, 0x00, 0x00, 0x99, 0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, 0xF7, 0x7E, 0x00, 0xF7, 0x7E,
  0x00, 0xF7, 0x7E, 0x01, 0xF7, 0x6F, 0x69, 0xF7, 0x0B, 0xE9, 0xC7,
  // "ú" (U+00FA)
  0x00, 0x07, 0x40, 0x00, 0x7B, 0x10, 0x00, 0x00, 0x00, 0x7E, 0x00, 0xF7, 0x7E, 0x00, 0xF7, 0x7E,
  0x00, 0xF7, 0x7E, 0x01, 0xF7, 0x6F, 0x69, 0xF7, 0x0B, 0xE9, 0xC7,
  // "û" (U+00FB)
  0x00, 0x67, 0x00, 0x07, 0xA9, 0x80, 0x00, 0x00, 0x00, 0x7E, 0x00, 0xF7, 0x7E, 0x00, 0xF7, 0x7E,
  0x00, 0xF7, 0x7E, 0x01, 0xF7, 0x6F, 0x69, 0xF7, 0x0B, 0xE9, 0xC7,
  // "ü" (U+00FC)
  0x0B, 0x66, 0xC0, 0x01, 0x00, 0x10, 0x7E, 0x00, 0xF7, 0x7E, 0x00, 0xF7, 0x7E, 0x00, 0xF7, 0x7E,
  0x01, 0xF7, 0x6F, 0x69, 0xF7, 0x0B, 0xE9, 0xC7,
  // "ý" (U+00FD)
  0x30, 0x70, 0x43, 0x81, 0x7B, 0x17, 0x09, 0x0E, 0x28, 0x93, 0xD9, 0x4F, 0x32, 0xF4, 0x0E, 0x76,
  0xE2, 0x82, 0x9C, 0xAA, 0x28, 0x24, 0xFE, 0x53, 0x0E, 0x94, 0x00, 0xB2, 0x82, 0x28, 0xF4, 0x28,
  0x16, 0xE8, 0x30,
  // "þ" (U+00FE)
  0x07, 0x94, 0x07, 0x94, 0x89, 0x37, 0xE9, 0xEA, 0x07, 0xF8, 0x7F, 0x57, 0x92, 0x81, 0xE8, 0x79,
  0x28, 0x95, 0xE8, 0x7F, 0x87, 0xF5, 0x7E, 0xAE, 0x90, 0x79, 0x40, 0x79, 0x40, 0x79, 0x40,
  // "ÿ" (U+00FF)
  0x0B, 0x66, 0xC0, 0x01, 0x00, 0x10, 0x9E, 0x00, 0xD9, 0x4F, 0x32, 0xF4, 0x0E, 0x76, 0xE0, 0x09,
  0xCA, 0xA0, 0x04, 0xFE, 0x50, 0x00, 0xEF, 0x00, 0x00, 0xBB, 0x00, 0x28, 0xF4, 0x00, 0x6E, 0x80,
  0x00,
  // "Ā" (U+0100)
  0x08, 0xFF, 0x80, 0x01, 0x33, 0x10, 0x01, 0xFF, 0x00, 0x04, 0xEE, 0x40, 0x08, 0xBB, 0x80, 0x0C,
  0x88, 0xC0, 0x0F, 0x66, 0xF0, 0x4F, 0xFF, 0xF4, 0x8D, 0x33, 0xE8, 0xC9, 0x00, 0xAC,
  // "ā" (U+0101)
  0x08, 0xFF, 0x80, 0x01, 0x33, 0x10, 0x0B, 0xEE, 0x80, 0x05, 0x56, 0xF3, 0x0B, 0xFF, 0xF5, 0x6F,
  0x53, 0xF5, 0x6F, 0x58, 0xF5, 0x1C, 0xE8, 0xD5,
  // "Ă" (U+0102)
  0x07, 0x54, 0x70, 0x04, 0xFF, 0x40, 0x00, 0x11, 0x00, 0x01, 0xFF, 0x00, 0x04, 0xEE, 0x40, 0x08,
  0xBB, 0x80, 0x0C, 0x88, 0xC0, 0x0F, 0x66, 0xF0, 0x4F, 0xFF, 0xF4, 0x8D, 0x33, 0xE8, 0xC9, 0x00,
  0xAC,
  // "ă" (U+0103)
  0x07, 0x54, 0x70, 0x04, 0xFF, 0x40, 0x00, 0x11, 0x00, 0x0B, 0xEE, 0x80, 0x05, 0x56, 0xF3, 0x0B,
  0xFF, 0xF5, 0x6F, 0x53, 0xF5, 0x6F, 0x58, 0xF5, 0x1C, 0xE8, 0xD5,
  // "Ą" (U+0104)
  0x10, 0x1A, 0x38, 0x24, 0xEE, 0x42, 0x82, 0x8B, 0xB8, 0x28, 0x2C, 0x88, 0xC2, 0x98, 0x36, 0x6F,
  0x04, 0xC8, 0x74, 0x8D, 0x33, 0xE8, 0xC9, 0x20, 0xD9, 0x40, 0xB0, 0x34, 0x0B, 0x95, 0x02,
  // "ą" (U+0105)
  0x0B, 0xEE, 0x80, 0x05, 0x56, 0xF3, 0x0B, 0xFF, 0xF5, 0x6F, 0x53, 0xF5, 0x6F, 0x58, 0xF5, 0x1C,
  0xEB, 0xF5, 0x00, 0x0B, 0x30, 0x00, 0x0B, 0xF0, 0x00, 0x00, 0x20,
  // "Ć" (U+0106)
  0x40, 0x70, 0x43, 0x81, 0x7B, 0x17, 0x89, 0x41, 0xBE, 0xE5, 0x0D, 0xC4, 0x62, 0x4F, 0x33, 0x07,
  0x94, 0x07, 0x94, 0x81, 0x5F, 0x23, 0x89, 0x21, 0xEB, 0x46, 0x30, 0x3C, 0xFD, 0x30,
  // "ć" (U+0107)
  0x30, 0x70, 0x43, 0x81, 0x7B, 0x17, 0x18, 0x94, 0x4C, 0xFD, 0x10, 0xEB, 0x46, 0x03, 0xF3, 0x38,
  0x13, 0xF3, 0x38, 0x31, 0xEB, 0x47, 0x28, 0x25, 0xDF, 0xC1,
  // "Ĉ" (U+0108)
  0x30, 0x60, 0x73, 0x82, 0x7A, 0x98, 0x78, 0x94, 0x1B, 0xEE, 0x50, 0xDC, 0x46, 0x24, 0xF3, 0x30,
  0x79, 0x40, 0x79, 0x48, 0x15, 0xF2, 0x38, 0x92, 0x1E, 0xB4, 0x63, 0x03, 0xCF, 0xD3,
  // "ĉ" (U+0109)
  0x00, 0x67, 0x00, 0x07, 0xA9, 0x80, 0x00, 0x00, 0x00, 0x04, 0xCF, 0xD1, 0x0E, 0xB4, 0x60, 0x3F,
  0x30, 0x00, 0x3F, 0x30, 0x00, 0x1E, 0xB4, 0x70, 0x05, 0xDF, 0xC0,
  // "Ċ" (U+010A)
  0x30, 0x0B, 0x40, 0x01, 0x28, 0x94, 0x1B, 0xEE, 0x50, 0xDC, 0x46, 0x24, 0xF3, 0x30, 0x79, 0x40,
  0x79, 0x48, 0x15, 0xF2, 0x38, 0x92, 0x1E, 0xB4, 0x63, 0x03, 0xCF, 0xD3,
  // "ċ" (U+010B)
  0x00, 0xBB, 0x00, 0x00, 0x11, 0x00, 0x04, 0xCF, 0xD1, 0x0E, 0xB4, 0x60, 0x3F, 0x30, 0x00, 0x3F,
  0x30, 0x00, 0x1E, 0xB4, 0x70, 0x05, 0xDF, 0xC0,
  // "Č" (U+010C)
  0x28, 0x25, 0x33, 0x52, 0x82, 0x2E, 0xE2, 0x78, 0x94, 0x1B, 0xEE, 0x50, 0xDC, 0x46, 0x24, 0xF3,
  0x30, 0x79, 0x40, 0x79, 0x48, 0x15, 0xF2, 0x38, 0x92, 0x1E, 0xB4, 0x63, 0x03, 0xCF, 0xD3,
  // "č" (U+010D)
  0x05, 0x33, 0x50, 0x02, 0xEE, 0x20, 0x00, 0x00, 0x00, 0x04, 0xCF, 0xD1, 0x0E, 0xB4, 0x60, 0x3F,
  0x30, 0x00, 0x3F, 0x30, 0x00, 0x1E, 0xB4, 0x70, 0x05, 0xDF, 0xC0,
  // "Ď" (U+010E)
  0x05, 0x33, 0x50, 0x02, 0xEE, 0x20, 0x00, 0x00, 0x00, 0x8F, 0xFC, 0x40, 0x8E, 0x49, 0xF2, 0x8D,
  0x00, 0xE8, 0x8D, 0x00, 0xCA, 0x8D, 0x00, 0xC9, 0x8D, 0x00, 0xE7, 0x8E, 0x4A, 0xF1, 0x8F, 0xFD,
  0x40,
  // "ď" (U+010F)
  0x00, 0x07, 0xEA, 0x80, 0x00, 0x7E, 0x30, 0x1C, 0xEA, 0xE0, 0x07, 0xF5, 0xBE, 0x00, 0x9C, 0x06,
  0xE0, 0x0A, 0xC0, 0x6E, 0x00, 0x7F, 0x5B, 0xE0, 0x01, 0xCD, 0x8E, 0x00,
  // "Đ" (U+0110)
  0x8F, 0xFC, 0x40, 0x8E, 0x49, 0xF2, 0x8D, 0x00, 0xE8, 0x8D, 0x00, 0xCA, 0xFF, 0xE0, 0xC9, 0xAE,
  0x30, 0xE7, 0x8E, 0x4A, 0xF1, 0x8F, 0xFD, 0x40,
  // "đ" (U+0111)
  0x00, 0x00, 0xF7, 0x00, 0x6F, 0xFF, 0x0A, 0xEA, 0xE7, 0x5F, 0x77, 0xF7, 0x8E, 0x00, 0xE7, 0x8E,
  0x00, 0xD7, 0x5F, 0x76, 0xF7, 0x0B, 0xE9, 0xD7,
  // "Ē" (U+0112)
  0x08, 0xFF, 0x80, 0x01, 0x33, 0x10, 0x3F, 0xFF, 0xF4, 0x3F, 0x63, 0x31, 0x3F, 0x30, 0x00, 0x3F,
  0xFF, 0xF2, 0x3F, 0x53, 0x30, 0x3F, 0x30, 0x00, 0x3F, 0x63, 0x31, 0x3F, 0xFF, 0xF4,
  // "ē" (U+0113)
  0x08, 0xFF, 0x80, 0x01, 0x33, 0x10, 0x06, 0xEE, 0x80, 0x3F, 0x76, 0xE4, 0x7F, 0xFF, 0xF7, 0x6F,
  0x33, 0x31, 0x2F, 0xA4, 0x63, 0x05, 0xCF, 0xD3,
  // "Ĕ" (U+0114)
  0x18, 0x27, 0x54, 0x72, 0x04, 0xA0, 0x43, 0x00, 0x12, 0x03, 0xC8, 0x90, 0x43, 0xF6, 0x33, 0x13,
  0xF3, 0x30, 0x3C, 0x89, 0x02, 0x3F, 0x53, 0x30, 0x3F, 0x33, 0x85, 0x3F, 0x63, 0x31, 0x3C, 0x04,
  // "ĕ" (U+0115)
  0x07, 0x54, 0x70, 0x04, 0xFF, 0x40, 0x00, 0x11, 0x00, 0x06, 0xEE, 0x80, 0x3F, 0x76, 0xE4, 0x7F,
  0xFF, 0xF7, 0x6F, 0x33, 0x31, 0x2F, 0xA4, 0x63, 0x05, 0xCF, 0xD3,
  // "Ė" (U+0116)
  0x20, 0x0B, 0x40, 0x01, 0x20, 0x3C, 0x89, 0x04, 0x3F, 0x63, 0x31, 0x3F, 0x33, 0x03, 0xC8, 0x90,
  0x23, 0xF5, 0x33, 0x03, 0xF3, 0x38, 0x53, 0xF6, 0x33, 0x13, 0xC0, 0x40,
  // "ė" (U+0117)
  0x00, 0xBB, 0x00, 0x00, 0x11, 0x00, 0x06, 0xEE, 0x80, 0x3F, 0x76, 0xE4, 0x7F, 0xFF, 0xF7, 0x6F,
  0x33, 0x31, 0x2F, 0xA4, 0x63, 0x05, 0xCF, 0xD3,
  // "Ę" (U+0118)
  0x03, 0xC8, 0x90, 0x43, 0xF6, 0x33, 0x13, 0xF3, 0x30, 0x3C, 0x89, 0x02, 0x3F, 0x53, 0x30, 0x3F,
  0x33, 0x85, 0x3F, 0x63, 0x31, 0x3C, 0x04, 0x30, 0xB0, 0x34, 0x0B, 0x95, 0x02, 0x10,
  // "ę" (U+0119)
  0x06, 0xEE, 0x60, 0x3F, 0x97, 0xF2, 0x7F, 0x10, 0xD6, 0x6F, 0xFF, 0xF7, 0x2F, 0x97, 0x83, 0x05,
  0xCF, 0xF4, 0x00, 0x06, 0x90, 0x00, 0x0A, 0x80, 0x00, 0x05, 0xE2,
  // "Ě" (U+011A)
  0x18, 0x25, 0x33, 0x52, 0x82, 0x2E, 0xE2, 0x70, 0x3C, 0x89, 0x04, 0x3F, 0x63, 0x31, 0x3F, 0x33,
  0x03, 0xC8, 0x90, 0x23, 0xF5, 0x33, 0x03, 0xF3, 0x38, 0x53, 0xF6, 0x33, 0x13, 0xC0, 0x40,
  // "ě" (U+011B)
  0x05, 0x33, 0x50, 0x02, 0xEE, 0x20, 0x00, 0x00, 0x00, 0x06, 0xEE, 0x80, 0x3F, 0x76, 0xE4, 0x7F,
  0xFF, 0xF7, 0x6F, 0x33, 0x31, 0x2F, 0xA4, 0x63, 0x05, 0xCF, 0xD3,
  // "Ĝ" (U+011C)
  0x20, 0x60, 0x73, 0x82, 0x7A, 0x98, 0x71, 0x89, 0x34, 0xCF, 0xD4, 0x1F, 0xB4, 0x71, 0x7E, 0x40,
  0x90, 0xC4, 0x8A, 0x6A, 0xC0, 0xBF, 0x88, 0xE0, 0x2C, 0x82, 0xFA, 0x4D, 0x80, 0x5D, 0xFD, 0x50,
  // "ĝ" (U+011D)
  0x00, 0x67, 0x00, 0x07, 0xA9, 0x80, 0x00, 0x00, 0x00, 0x0A, 0xE9, 0xD7, 0x5F, 0x77, 0xF7, 0x8E,
  0x00, 0xE7, 0x8E, 0x00, 0xE7, 0x5F, 0x77, 0xF7, 0x0A, 0xE9, 0xF7, 0x00, 0x00, 0xF6, 0x28, 0x48,
  0xF2, 0x2D, 0xFD, 0x60,
  // "Ğ" (U+011E)
  0x07, 0x54, 0x70, 0x04, 0xFF, 0x40, 0x00, 0x11, 0x00, 0x04, 0xCF, 0xD4, 0x1F, 0xB4, 0x71, 0x7E,
  0x00, 0x00, 0x9C, 0x00, 0x00, 0xAC, 0x0B, 0xF8, 0x8E, 0x02, 0xC8, 0x2F, 0xA4, 0xD8, 0x05, 0xDF,
  0xD5,
  // "ğ" (U+011F)
  0x07, 0x54, 0x70, 0x04, 0xFF, 0x40, 0x00, 0x11, 0x00, 0x0A, 0xE9, 0xD7, 0x5F, 0x77, 0xF7, 0x8E,
  0x00, 0xE7, 0x8E, 0x00, 0xE7, 0x5F, 0x77, 0xF7, 0x0A, 0xE9, 0xF7, 0x00, 0x00, 0xF6, 0x28, 0x48,
  0xF2, 0x2D, 0xFD, 0x60,
  // "Ġ" (U+0120)
  0x20, 0x0B, 0x40, 0x01, 0x38, 0x93, 0x4C, 0xFD, 0x41, 0xFB, 0x47, 0x17, 0xE4, 0x09, 0x0C, 0x48,
  0xA6, 0xAC, 0x0B, 0xF8, 0x8E, 0x02, 0xC8, 0x2F, 0xA4, 0xD8, 0x05, 0xDF, 0xD5,
  // "ġ" (U+0121)
  0x00, 0xBB, 0x00, 0x00, 0x11, 0x00, 0x0A, 0xE9, 0xD7, 0x5F, 0x77, 0xF7, 0x8E, 0x00, 0xE7, 0x8E,
  0x00, 0xE7, 0x5F, 0x77, 0xF7, 0x0A, 0xE9, 0xF7, 0x00, 0x00, 0xF6, 0x28, 0x48, 0xF2, 0x2D, 0xFD,
  0x60,
  // "Ģ" (U+0122)
  0x18, 0x93, 0x4C, 0xFD, 0x41, 0xFB, 0x47, 0x17, 0xE4, 0x09, 0x0C, 0x48, 0xA6, 0xAC, 0x0B, 0xF8,
  0x8E, 0x02, 0xC8, 0x2F, 0xA4, 0xD8, 0x05, 0xDF, 0xD5, 0x71, 0x0C, 0x05, 0x40, 0x33,
  // "ģ" (U+0123)
  0x00, 0x5A, 0x00, 0x00, 0x32, 0x00, 0x0A, 0xE9, 0xD7, 0x5F, 0x77, 0xF7, 0x8E, 0x00, 0xE7, 0x8E,
  0x00, 0xE7, 0x5F, 0x77, 0xF7, 0x0A, 0xE9, 0xF7, 0x00, 0x00, 0xF6, 0x28, 0x48, 0xF2, 0x2D, 0xFD,
  0x60,
  // "Ĥ" (U+0124)
  0x00, 0x67, 0x00, 0x07, 0xA9, 0x80, 0x00, 0x00, 0x00, 0x8E, 0x00, 0xE8, 0x8E, 0x00, 0xE8, 0x8E,
  0x00, 0xE8, 0x8F, 0xFF, 0xF8, 0x8E, 0x33, 0xE8, 0x8E, 0x00, 0xE8, 0x8E, 0x00, 0xE8, 0x8E, 0x00,
  0xE8,
  // "ĥ" (U+0125)
  0x10, 0x60, 0x74, 0x82, 0x7A, 0x98, 0x74, 0x07, 0x95, 0x07, 0x95, 0x83, 0x7F, 0x9E, 0xB2, 0x89,
  0x57, 0xF8, 0x6F, 0x60, 0x7F, 0x10, 0xF7, 0x07, 0x92, 0x82, 0xE7, 0x07, 0x92, 0x82, 0xE7, 0x07,
  0x92, 0x0E, 0x07,
  // "Ħ" (U+0126)
  0x07, 0x92, 0x90, 0x7E, 0x85, 0x8F, 0x44, 0xF8, 0x6C, 0x86, 0x66, 0xF3, 0x3F, 0x66, 0x92, 0x90,
  0x06, 0x92, 0x90, 0x06, 0x92, 0x90, 0x60,
  // "ħ" (U+0127)
  0x7F, 0x00, 0x00, 0xFF, 0xF7, 0x00, 0x7F, 0x8E, 0xB0, 0x7F, 0x86, 0xF6, 0x7F, 0x10, 0xF7, 0x7F,
  0x00, 0xE7, 0x7F, 0x00, 0xE7, 0x7F, 0x00, 0xE7,
  // "Ĩ" (U+0128)
  0x18, 0x26, 0xC1, 0xB2, 0x82, 0xB5, 0xE8, 0x20, 0x14, 0x01, 0xC8, 0x41, 0x03, 0xCC, 0x33, 0x00,
  0xA4, 0x00, 0xA4, 0x00, 0xA4, 0x00, 0xA3, 0x84, 0x2C, 0xB2, 0x01, 0xC0, 0x10,
  // "ĩ" (U+0129)
  0x18, 0x26, 0xC1, 0xB2, 0x82, 0xB5, 0xE8, 0x20, 0x14, 0x01, 0xA0, 0xD3, 0x81, 0x3A, 0xD4, 0x09,
  0x0D, 0x40, 0x90, 0xD3, 0x84, 0x2A, 0xE2, 0x06, 0xC0, 0x70,
  // "Ī" (U+012A)
  0x10, 0x8A, 0x08, 0x28, 0x41, 0x33, 0x10, 0x1C, 0x84, 0x10, 0x3C, 0xC3, 0x30, 0x0A, 0x40, 0x0A,
  0x40, 0x0A, 0x40, 0x0A, 0x38, 0x42, 0xCB, 0x20, 0x1C, 0x01,
  // "ī" (U+012B)
  0x10, 0x8A, 0x08, 0x28, 0x41, 0x33, 0x10, 0x1A, 0x0D, 0x38, 0x13, 0xAD, 0x40, 0x90, 0xD4, 0x09,
  0x0D, 0x38, 0x42, 0xAE, 0x20, 0x6C, 0x07,
  // "Ĭ" (U+012C)
  0x18, 0x27, 0x54, 0x72, 0x04, 0xA0, 0x43, 0x00, 0x12, 0x01, 0xC8, 0x41, 0x03, 0xCC, 0x33, 0x00,
  0xA4, 0x00, 0xA4, 0x00, 0xA4, 0x00, 0xA3, 0x84, 0x2C, 0xB2, 0x01, 0xC0, 0x10,
  // "ĭ" (U+012D)
  0x18, 0x27, 0x54, 0x72, 0x04, 0xA0, 0x43, 0x00, 0x12, 0x01, 0xA0, 0xD3, 0x81, 0x3A, 0xD4, 0x09,
  0x0D, 0x40, 0x90, 0xD3, 0x84, 0x2A, 0xE2, 0x06, 0xC0, 0x70,
  // "Į" (U+012E)
  0x01, 0xC8, 0x41, 0x03, 0xCC, 0x33, 0x00, 0xA4, 0x00, 0xA4, 0x00, 0xA4, 0x00, 0xA3, 0x84, 0x2C,
  0xB2, 0x01, 0xC0, 0x13, 0x0B, 0x03, 0x40, 0xB9, 0x50, 0x21,
  // "į" (U+012F)
  0x20, 0x80, 0xD4, 0x01, 0x02, 0x20, 0x1A, 0x0D, 0x38, 0x13, 0xAD, 0x40, 0x90, 0xD4, 0x09, 0x0D,
  0x38, 0x42, 0xAE, 0x20, 0x6C, 0x07, 0x30, 0xB0, 0x34, 0x0B, 0x95, 0x02, 0x10,
  // "İ" (U+0130)
  0x20, 0x0B, 0x40, 0x01, 0x20, 0x1C, 0x84, 0x10, 0x3C, 0xC3, 0x30, 0x0A, 0x40, 0x0A, 0x40, 0x0A,
  0x40, 0x0A, 0x38, 0x42, 0xCB, 0x20, 0x1C, 0x01,
  // "ı" (U+0131)
  0x01, 0xA0, 0xD3, 0x81, 0x3A, 0xD4, 0x09, 0x0D, 0x40, 0x90, 0xD3, 0x84, 0x2A, 0xE2, 0x06, 0xC0,
  0x70,
  // "Ĳ" (U+0132)
  0x2F, 0x34, 0xF2, 0x2F, 0x34, 0xF2, 0x2F, 0x34, 0xF2, 0x2F, 0x34, 0xF2, 0x2F, 0x34, 0xF2, 0x00,
  0x04, 0xF1, 0x17, 0x5B, 0xE0, 0x1E, 0xFC, 0x40,
  // "ĳ" (U+0133)
  0x1E, 0x55, 0xE1, 0x02, 0x00, 0x20, 0x1F, 0x55, 0xF1, 0x1F, 0x55, 0xF1, 0x1F, 0x55, 0xF1, 0x1F,
  0x55, 0xF1, 0x1F, 0x55, 0xF1, 0x1F, 0x55, 0xF1, 0x00, 0x06, 0xF1, 0x06, 0x6C, 0xE0, 0x0A, 0xFD,
  0x40,
  // "Ĵ" (U+0134)
  0x30, 0x60, 0x73, 0x82, 0x7A, 0x98, 0x72, 0x08, 0x0E, 0x40, 0x80, 0xE4, 0x08, 0x0E, 0x40, 0x80,
  0xE4, 0x08, 0x0E, 0x48, 0x94, 0x8D, 0x01, 0x65, 0xDA, 0x02, 0xEE, 0xB2, 0x10,
  // "ĵ" (U+0135)
  0x00, 0x67, 0x00, 0x7A, 0x98, 0x00, 0x00, 0x00, 0xAF, 0xF4, 0x02, 0x7F, 0x40, 0x02, 0xF4, 0x00,
  0x2F, 0x40, 0x02, 0xF4, 0x00, 0x2F, 0x40, 0x03, 0xF4, 0x46, 0xAF, 0x17, 0xFE, 0x70,
  // "Ķ" (U+0136)
  0x8A, 0x48, 0xD0, 0x3F, 0x58, 0xD0, 0xCB, 0x08, 0xD6, 0xE2, 0x08, 0xED, 0x82, 0x08, 0xA0, 0xD2,
  0x8A, 0x08, 0xE3, 0xF5, 0x08, 0xD0, 0xBC, 0x08, 0xD0, 0x3F, 0x57, 0x10, 0xC0, 0x54, 0x03, 0x30,
  // "ķ" (U+0137)
  0x06, 0x94, 0x06, 0x94, 0x89, 0x66, 0xF0, 0x5F, 0x56, 0xF3, 0xE8, 0x06, 0xFC, 0xD2, 0x8A, 0x06,
  0xFC, 0xF4, 0x06, 0xF0, 0x9D, 0x06, 0xF0, 0x1E, 0x87, 0x10, 0xC0, 0x54, 0x03, 0x30,
  // "ĸ" (U+0138)
  0x6F, 0x05, 0xF5, 0x6F, 0x3E, 0x80, 0x6F, 0xCD, 0x00, 0x6F, 0xCF, 0x40, 0x6F, 0x09, 0xD0, 0x6F,
  0x01, 0xE8,
  // "Ĺ" (U+0139)
  0x20, 0x70, 0x43, 0x81, 0x7B, 0x17, 0x18, 0x11, 0xF5, 0x38, 0x11, 0xF5, 0x38, 0x11, 0xF5, 0x38,
  0x11, 0xF5, 0x38, 0x11, 0xF5, 0x38, 0x11, 0xF5, 0x38, 0x51, 0xF9, 0x55, 0x11, 0xC0, 0x40,
  // "ĺ" (U+013A)
  0x30, 0x70, 0x43, 0x81, 0x7B, 0x17, 0x1A, 0x0D, 0x38, 0x11, 0xAD, 0x40, 0x90, 0xD4, 0x09, 0x0D,
  0x40, 0x90, 0xD4, 0x09, 0x0D, 0x38, 0x41, 0xAD, 0x10, 0x6C, 0x07,
  // "Ļ" (U+013B)
  0x81, 0x1F, 0x53, 0x81, 0x1F, 0x53, 0x81, 0x1F, 0x53, 0x81, 0x1F, 0x53, 0x81, 0x1F, 0x53, 0x81,
  0x1F, 0x53, 0x85, 0x1F, 0x95, 0x51, 0x1C, 0x04, 0x71, 0x0C, 0x05, 0x40, 0x33,
  // "ļ" (U+013C)
  0x1A, 0x0D, 0x38, 0x11, 0xAD, 0x40, 0x90, 0xD4, 0x09, 0x0D, 0x40, 0x90, 0xD4, 0x09, 0x0D, 0x38,
  0x41, 0xAD, 0x10, 0x6C, 0x07, 0x71, 0x0C, 0x05, 0x40, 0x33,
  // "Ľ" (U+013D)
  0x1F, 0x53, 0xE1, 0x1F, 0x51, 0x20, 0x1F, 0x50, 0x00, 0x1F, 0x50, 0x00, 0x1F, 0x50, 0x00, 0x1F,
  0x50, 0x00, 0x1F, 0x95, 0x51, 0x1F, 0xFF, 0xF4,
  // "ľ" (U+013E)
  0x0C, 0xED, 0x7A, 0x00, 0x9D, 0x21, 0x00, 0x9D, 0x00, 0x00, 0x9D, 0x00, 0x00, 0x9D, 0x00, 0x00,
  0x9D, 0x00, 0x02, 0xBD, 0x30, 0x6F, 0xFF, 0xF7,
  // "Ŀ" (U+013F)
  0x1F, 0x50, 0x00, 0x1F, 0x50, 0x00, 0x1F, 0x50, 0x00, 0x1F, 0x50, 0x11, 0x1F, 0x50, 0xBB, 0x1F,
  0x50, 0x00, 0x1F, 0x95, 0x51, 0x1F, 0xFF, 0xF4,
  // "ŀ" (U+0140)
  0x1A, 0x0D, 0x48, 0x11, 0xAD, 0x50, 0x90, 0xD5, 0x83, 0x9D, 0x01, 0x12, 0x83, 0x9D, 0x0B, 0xB2,
  0x09, 0x0D, 0x48, 0x21, 0xAD, 0x12, 0x06, 0xC0, 0x71,
  // "Ł" (U+0141)
  0x0A, 0xB0, 0x00, 0x0A, 0xB0, 0x00, 0x0A, 0xC4, 0x00, 0x0B, 0xFC, 0x00, 0x5F, 0xC0, 0x00, 0x1C,
  0xB0, 0x00, 0x0A, 0xD5, 0x54, 0x0A, 0xFF, 0xFA,
  // "ł" (U+0142)
  0x0F, 0xFD, 0x00, 0x01, 0xAD, 0x00, 0x00, 0x9D, 0x10, 0x00, 0x9F, 0xC0, 0x05, 0xEE, 0x10, 0x06,
  0xCD, 0x00, 0x01, 0xAD, 0x10, 0x6F, 0xFF, 0xF7,
  // "Ń" (U+0143)
  0x30, 0x70, 0x43, 0x81, 0x7B, 0x17, 0x8D, 0x68, 0xF8, 0x0B, 0x88, 0xED, 0x0B, 0x88, 0xBF, 0x2B,
  0x88, 0xBB, 0x6B, 0x88, 0xB7, 0xBB, 0x88, 0xB2, 0xFB, 0x88, 0xB0, 0xDE, 0x88, 0xB0, 0x9F, 0x80,
  // "ń" (U+0144)
  0x00, 0x07, 0x40, 0x00, 0x7B, 0x10, 0x00, 0x00, 0x00, 0x7C, 0x9E, 0xB0, 0x7F, 0x96, 0xF6, 0x7F,
  0x10, 0xF7, 0x7F, 0x00, 0xE7, 0x7F, 0x00, 0xE7, 0x7F, 0x00, 0xE7,
  // "Ņ" (U+0145)
  0x8D, 0x68, 0xF8, 0x0B, 0x88, 0xED, 0x0B, 0x88, 0xBF, 0x2B, 0x88, 0xBB, 0x6B, 0x88, 0xB7, 0xBB,
  0x88, 0xB2, 0xFB, 0x88, 0xB0, 0xDE, 0x88, 0xB0, 0x9F, 0x87, 0x10, 0xC0, 0x54, 0x03, 0x30,
  // "ņ" (U+0146)
  0x8A, 0x17, 0xC9, 0xEB, 0x07, 0xF9, 0x6F, 0x67, 0xF1, 0x0F, 0x77, 0x92, 0x81, 0xE7, 0x79, 0x28,
  0x1E, 0x77, 0x92, 0x0E, 0x07, 0x71, 0x0C, 0x05, 0x40, 0x33,
  // "Ň" (U+0147)
  0x05, 0x33, 0x50, 0x02, 0xEE, 0x20, 0x00, 0x00, 0x00, 0x8F, 0x80, 0xB8, 0x8E, 0xD0, 0xB8, 0x8B,
  0xF2, 0xB8, 0x8B, 0xB6, 0xB8, 0x8B, 0x7B, 0xB8, 0x8B, 0x2F, 0xB8, 0x8B, 0x0D, 0xE8, 0x8B, 0x09,
  0xF8,
  // "ň" (U+0148)
  0x05, 0x33, 0x50, 0x02, 0xEE, 0x20, 0x00, 0x00, 0x00, 0x7C, 0x9E, 0xB0, 0x7F, 0x96, 0xF6, 0x7F,
  0x10, 0xF7, 0x7F, 0x00, 0xE7, 0x7F, 0x00, 0xE7, 0x7F, 0x00, 0xE7,
  // "ŉ" (U+0149)
  0xBA, 0x00, 0x00, 0x0D, 0x60, 0x00, 0x00, 0xD6, 0xD9, 0xEB, 0x10, 0x5F, 0x96, 0xF6, 0x05, 0xF2,
  0x0F, 0x70, 0x5F, 0x10, 0xE7, 0x05, 0xF1, 0x0E, 0x70, 0x5F, 0x10, 0xE7,
  // "Ŋ" (U+014A)
  0x8F, 0x80, 0xB8, 0x8E, 0xD0, 0xB8, 0x8B, 0xF2, 0xB8, 0x8B, 0xB6, 0xB8, 0x8B, 0x7B, 0xB8, 0x8B,
  0x2F, 0xB8, 0x8B, 0x0D, 0xE8, 0x8B, 0x09, 0xF8, 0x00, 0x01, 0xC7, 0x00, 0x9F, 0xD1, 0x00, 0x12,
  0x00,
  // "ŋ" (U+014B)
  0x7C, 0x9E, 0xB0, 0x7F, 0x96, 0xF5, 0x7F, 0x10, 0xF7, 0x7F, 0x00, 0xE7, 0x7F, 0x00, 0xE7, 0x7F,
  0x00, 0xE7, 0x00, 0x00, 0xE7, 0x00, 0x05, 0xF6, 0x00, 0x1F, 0xC1,
  // "Ō" (U+014C)
  0x08, 0xFF, 0x80, 0x01, 0x33, 0x10, 0x07, 0xEE, 0x70, 0x3F, 0x77, 0xF3, 0x8E, 0x00, 0xE8, 0xAC,
  0x00, 0xCA, 0xAC, 0x00, 0xCA, 0x8E, 0x00, 0xE8, 0x3F, 0x77, 0xF3, 0x07, 0xEE, 0x70,
  // "ō" (U+014D)
  0x08, 0xFF, 0x80, 0x01, 0x33, 0x10, 0x07, 0xEE, 0x70, 0x4F, 0x77, 0xF4, 0x8E, 0x00, 0xE8, 0x8E,
  0x00, 0xE8, 0x4F, 0x77, 0xF4, 0x08, 0xEE, 0x70,
  // "Ŏ" (U+014E)
  0x07, 0x54, 0x70, 0x04, 0xFF, 0x40, 0x00, 0x11, 0x00, 0x07, 0xEE, 0x70, 0x3F, 0x77, 0xF3, 0x8E,
  0x00, 0xE8, 0xAC, 0x00, 0xCA, 0xAC, 0x00, 0xCA, 0x8E, 0x00, 0xE8, 0x3F, 0x77, 0xF3, 0x07, 0xEE,
  0x70,
  // "ŏ" (U+014F)
  0x07, 0x54, 0x70, 0x04, 0xFF, 0x40, 0x00, 0x11, 0x00, 0x07, 0xEE, 0x70, 0x4F, 0x77, 0xF4, 0x8E,
  0x00, 0xE8, 0x8E, 0x00, 0xE8, 0x4F, 0x77, 0xF4, 0x08, 0xEE, 0x70,
  // "Ő" (U+0150)
  0x05, 0xBA, 0x90, 0x02, 0x02, 0x00, 0x07, 0xEE, 0x70, 0x3F, 0x77, 0xF3, 0x8E, 0x00, 0xE8, 0xAC,
  0x00, 0xCA, 0xAC, 0x00, 0xCA, 0x8E, 0x00, 0xE8, 0x3F, 0x77, 0xF3, 0x07, 0xEE, 0x70,
  // "ő" (U+0151)
  0x05, 0xBA, 0x90, 0x02, 0x02, 0x00, 0x07, 0xEE, 0x70, 0x4F, 0x77, 0xF4, 0x8E, 0x00, 0xE8, 0x8E,
  0x00, 0xE8, 0x4F, 0x77, 0xF4, 0x08, 0xEE, 0x70,
  // "Œ" (U+0152)
  0x09, 0xFF, 0xFC, 0x5F, 0x6E, 0x93, 0x9D, 0x0E, 0x70, 0xAB, 0x0E, 0xF9, 0xAB, 0x0E, 0x82, 0x9C,
  0x0E, 0x60, 0x5F, 0x5E, 0x93, 0x0A, 0xFF, 0xFC,
  // "œ" (U+0153)
  0x2D, 0xB7, 0xE5, 0x9A, 0xBD, 0x8C, 0xB5, 0x7F, 0xFD, 0xB5, 0x7C, 0x33, 0x9A, 0xBE, 0x55, 0x2D,
  0xB7, 0xE9,
  // "Ŕ" (U+0154)
  0x30, 0x70, 0x43, 0x81, 0x7B, 0x17, 0x03, 0xA8, 0xA4, 0xD5, 0x03, 0xF6, 0x9F, 0x13, 0xF3, 0x2F,
  0x43, 0xF4, 0x7F, 0x23, 0xB8, 0xA2, 0x80, 0x3F, 0x6E, 0x60, 0x3F, 0x37, 0xE1, 0x3F, 0x30, 0xE8,
  // "ŕ" (U+0155)
  0x30, 0x70, 0x43, 0x81, 0x7B, 0x17, 0x04, 0xA8, 0x93, 0x7E, 0xA0, 0x3F, 0xC4, 0x20, 0x2F, 0x53,
  0x81, 0x2F, 0x43, 0x84, 0x5F, 0x71, 0x09, 0xB0, 0xA1,
  // "Ŗ" (U+0156)
  0x03, 0xA8, 0xA4, 0xD5, 0x03, 0xF6, 0x9F, 0x13, 0xF3, 0x2F, 0x43, 0xF4, 0x7F, 0x23, 0xB8, 0xA2,
  0x80, 0x3F, 0x6E, 0x60, 0x3F, 0x37, 0xE1, 0x3F, 0x30, 0xE8, 0x71, 0x0C, 0x05, 0x40, 0x33,
  // "ŗ" (U+0157)
  0x04, 0xA8, 0x93, 0x7E, 0xA0, 0x3F, 0xC4, 0x20, 0x2F, 0x53, 0x81, 0x2F, 0x43, 0x84, 0x5F, 0x71,
  0x09, 0xB0, 0xA7, 0x20, 0xC0, 0x54, 0x03, 0x30,
  // "Ř" (U+0158)
  0x05, 0x33, 0x50, 0x02, 0xEE, 0x20, 0x00, 0x00, 0x00, 0x3F, 0xFD, 0x50, 0x3F, 0x69, 0xF1, 0x3F,
  0x32, 0xF4, 0x3F, 0x47, 0xF2, 0x3F, 0xFF, 0x80, 0x3F, 0x6E, 0x60, 0x3F, 0x37, 0xE1, 0x3F, 0x30,
  0xE8,
  // "ř" (U+0159)
  0x05, 0x33, 0x50, 0x02, 0xEE, 0x20, 0x00, 0x00, 0x00, 0x4F, 0xF7, 0xEA, 0x03, 0xFC, 0x42, 0x02,
  0xF5, 0x00, 0x02, 0xF4, 0x00, 0x05, 0xF7, 0x10, 0x9F, 0xFF, 0xA0,
  // "Ś" (U+015A)
  0x30, 0x70, 0x43, 0x81, 0x7B, 0x17, 0x18, 0x94, 0x6D, 0xEC, 0x10, 0xFA, 0x48, 0x01, 0xF7, 0x48,
  0x29, 0xFA, 0x13, 0x82, 0x7E, 0xE1, 0x38, 0x94, 0x3F, 0x63, 0x84, 0x7F, 0x42, 0xCF, 0xD8, 0x10,
  // "ś" (U+015B)
  0x00, 0x07, 0x40, 0x00, 0x7B, 0x10, 0x00, 0x00, 0x00, 0x07, 0xEE, 0xB0, 0x1F, 0x94, 0x70, 0x0D,
  0xE8, 0x10, 0x00, 0x7E, 0xE0, 0x27, 0x48, 0xF2, 0x2D, 0xFE, 0x80,
  // "Ŝ" (U+015C)
  0x20, 0x60, 0x73, 0x82, 0x7A, 0x98, 0x71, 0x89, 0x46, 0xDE, 0xC1, 0x0F, 0xA4, 0x80, 0x1F, 0x74,
  0x82, 0x9F, 0xA1, 0x38, 0x27, 0xEE, 0x13, 0x89, 0x43, 0xF6, 0x38, 0x47, 0xF4, 0x2C, 0xFD, 0x81,
  // "ŝ" (U+015D)
  0x00, 0x67, 0x00, 0x07, 0xA9, 0x80, 0x00, 0x00, 0x00, 0x07, 0xEE, 0xB0, 0x1F, 0x94, 0x70, 0x0D,
  0xE8, 0x10, 0x00, 0x7E, 0xE0, 0x27, 0x48, 0xF2, 0x2D, 0xFE, 0x80,
  // "Ş" (U+015E)
  0x06, 0xDE, 0xC1, 0x0F, 0xA4, 0x80, 0x1F, 0x70, 0x00, 0x09, 0xFA, 0x10, 0x00, 0x7E, 0xE1, 0x00,
  0x03, 0xF6, 0x38, 0x47, 0xF4, 0x2C, 0xFD, 0x80, 0x00, 0x43, 0x00, 0x00, 0x3E, 0x00, 0x00, 0xCA,
  0x00,
  // "ş" (U+015F)
  0x07, 0xEE, 0xB0, 0x1F, 0x94, 0x70, 0x0D, 0xE8, 0x10, 0x00, 0x7E, 0xE0, 0x27, 0x48, 0xF2, 0x2D,
  0xFE, 0x80, 0x00, 0x43, 0x00, 0x00, 0x3E, 0x00, 0x00, 0xCA, 0x00,
  // "Š" (U+0160)
  0x05, 0x33, 0x50, 0x02, 0xEE, 0x20, 0x00, 0x00, 0x00, 0x06, 0xDE, 0xC1, 0x0F, 0xA4, 0x80, 0x1F,
  0x70, 0x00, 0x09, 0xFA, 0x10, 0x00, 0x7E, 0xE1, 0x00, 0x03, 0xF6, 0x38, 0x47, 0xF4, 0x2C, 0xFD,
  0x80,
  // "š" (U+0161)
  0x05, 0x33, 0x50, 0x02, 0xEE, 0x20, 0x00, 0x00, 0x00, 0x07, 0xEE, 0xB0, 0x1F, 0x94, 0x70, 0x0D,
  0xE8, 0x10, 0x00, 0x7E, 0xE0, 0x27, 0x48, 0xF2, 0x2D, 0xFE, 0x80,
  // "Ţ" (U+0162)
  0x0A, 0xC8, 0x5A, 0x23, 0xCC, 0x32, 0x20, 0x0B, 0x40, 0x0B, 0x40, 0x0B, 0x40, 0x0B, 0x40, 0x0B,
  0x40, 0x0B, 0x40, 0x40, 0x34, 0x03, 0x0E, 0x40, 0xC0, 0xA2,
  // "ţ" (U+0163)
  0x00, 0x71, 0x00, 0x00, 0xF3, 0x00, 0x5E, 0xFF, 0xF4, 0x16, 0xF6, 0x41, 0x03, 0xF3, 0x00, 0x03,
  0xF3, 0x00, 0x01, 0xF9, 0x42, 0x00, 0x8E, 0xE4, 0x00, 0x04, 0x30, 0x00, 0x03, 0xE0, 0x00, 0x0C,
  0xA0,
  // "Ť" (U+0164)
  0x18, 0x25, 0x33, 0x52, 0x82, 0x2E, 0xE2, 0x70, 0xAC, 0x85, 0xA2, 0x3C, 0xC3, 0x22, 0x00, 0xB4,
  0x00, 0xB4, 0x00, 0xB4, 0x00, 0xB4, 0x00, 0xB4, 0x00, 0xB2,
  // "ť" (U+0165)
  0x00, 0x41, 0xB7, 0x00, 0xF3, 0x30, 0x5D, 0xFF, 0xF4, 0x16, 0xF6, 0x41, 0x03, 0xF3, 0x00, 0x03,
  0xF3, 0x00, 0x01, 0xF9, 0x42, 0x00, 0x8E, 0xE4,
  // "Ŧ" (U+0166)
  0x0A, 0xC8, 0x5A, 0x23, 0xCC, 0x32, 0x20, 0x0B, 0x40, 0x0B, 0x30, 0xEA, 0x0E, 0x28, 0x23, 0xCC,
  0x33, 0x00, 0xB4, 0x00, 0xB2,
  // "ŧ" (U+0167)
  0x00, 0x71, 0x00, 0x00, 0xF3, 0x00, 0x5E, 0xFF, 0xF4, 0x27, 0xF7, 0x41, 0x7F, 0xFF, 0xF5, 0x16,
  0xF6, 0x31, 0x01, 0xF9, 0x42, 0x00, 0x8E, 0xE4,
  // "Ũ" (U+0168)
  0x06, 0xC1, 0xB0, 0x0B, 0x5E, 0x80, 0x01, 0x00, 0x00, 0x8E, 0x00, 0xE8, 0x8E, 0x00, 0xE8, 0x8E,
  0x00, 0xE8, 0x8E, 0x00, 0xE8, 0x8E, 0x00, 0xE8, 0x7E, 0x00, 0xE7, 0x4F, 0x77, 0xF4, 0x08, 0xEE,
  0x80,
  // "ũ" (U+0169)
  0x06, 0xC1, 0xB0, 0x0B, 0x5E, 0x80, 0x01, 0x00, 0x00, 0x7E, 0x00, 0xF7, 0x7E, 0x00, 0xF7, 0x7E,
  0x00, 0xF7, 0x7E, 0x01, 0xF7, 0x6F, 0x69, 0xF7, 0x0B, 0xE9, 0xC7,
  // "Ū" (U+016A)
  0x08, 0xFF, 0x80, 0x01, 0x33, 0x10, 0x8E, 0x00, 0xE8, 0x8E, 0x00, 0xE8, 0x8E, 0x00, 0xE8, 0x8E,
  0x00, 0xE8, 0x8E, 0x00, 0xE8, 0x7E, 0x00, 0xE7, 0x4F, 0x77, 0xF4, 0x08, 0xEE, 0x80,
  // "ū" (U+016B)
  0x08, 0xFF, 0x80, 0x01, 0x33, 0x10, 0x7E, 0x00, 0xF7, 0x7E, 0x00, 0xF7, 0x7E, 0x00, 0xF7, 0x7E,
  0x01, 0xF7, 0x6F, 0x69, 0xF7, 0x0B, 0xE9, 0xC7,
  // "Ŭ" (U+016C)
  0x07, 0x54, 0x70, 0x04, 0xFF, 0x40, 0x00, 0x11, 0x00, 0x8E, 0x00, 0xE8, 0x8E, 0x00, 0xE8, 0x8E,
  0x00, 0xE8, 0x8E, 0x00, 0xE8, 0x8E, 0x00, 0xE8, 0x7E, 0x00, 0xE7, 0x4F, 0x77, 0xF4, 0x08, 0xEE,
  0x80,
  // "ŭ" (U+016D)
  0x07, 0x54, 0x70, 0x04, 0xFF, 0x40, 0x00, 0x11, 0x00, 0x7E, 0x00, 0xF7, 0x7E, 0x00, 0xF7, 0x7E,
  0x00, 0xF7, 0x7E, 0x01, 0xF7, 0x6F, 0x69, 0xF7, 0x0B, 0xE9, 0xC7,
  // "Ů" (U+016E)
  0x01, 0xDD, 0x00, 0x01, 0xFE, 0x10, 0x8E, 0x11, 0xE8, 0x8E, 0x00, 0xE8, 0x8E, 0x00, 0xE8, 0x8E,
  0x00, 0xE8, 0x8E, 0x00, 0xE8, 0x7E, 0x00, 0xE7, 0x4F, 0x77, 0xF4, 0x08, 0xEE, 0x80,
  // "ů" (U+016F)
  0x01, 0xDD, 0x00, 0x01, 0xFE, 0x10, 0x7E, 0x11, 0xF7, 0x7E, 0x00, 0xF7, 0x7E, 0x00, 0xF7, 0x7E,
  0x01, 0xF7, 0x6F, 0x69, 0xF7, 0x0B, 0xE9, 0xC7,
  // "Ű" (U+0170)
  0x05, 0xBA, 0x90, 0x02, 0x02, 0x00, 0x8E, 0x00, 0xE8, 0x8E, 0x00, 0xE8, 0x8E, 0x00, 0xE8, 0x8E,
  0x00, 0xE8, 0x8E, 0x00, 0xE8, 0x7E, 0x00, 0xE7, 0x4F, 0x77, 0xF4, 0x08, 0xEE, 0x80,
  // "ű" (U+0171)
  0x05, 0xBA, 0x90, 0x02, 0x02, 0x00, 0x7E, 0x00, 0xF7, 0x7E, 0x00, 0xF7, 0x7E, 0x00, 0xF7, 0x7E,
  0x01, 0xF7, 0x6F, 0x69, 0xF7, 0x0B, 0xE9, 0xC7,
  // "Ų" (U+0172)
  0x8E, 0x00, 0xE8, 0x8E, 0x00, 0xE8, 0x8E, 0x00, 0xE8, 0x8E, 0x00, 0xE8, 0x8E, 0x00, 0xE8, 0x7E,
  0x00, 0xE8, 0x4F, 0x77, 0xF5, 0x09, 0xEF, 0xB0, 0x00, 0x79, 0x00, 0x00, 0xC6, 0x00, 0x00, 0x8E,
  0x00,
  // "ų" (U+0173)
  0x7E, 0x00, 0xF7, 0x7E, 0x00, 0xF7, 0x7E, 0x00, 0xF7, 0x7E, 0x01, 0xF7, 0x6F, 0x69, 0xF7, 0x0B,
  0xEC, 0xF7, 0x00, 0x0B, 0x30, 0x00, 0x0B, 0xF0, 0x00, 0x00, 0x20,
  // "Ŵ" (U+0174)
  0x00, 0x67, 0x00, 0x07, 0xA9, 0x80, 0x00, 0x00, 0x00, 0xD6, 0x00, 0x6D, 0xC7, 0x00, 0x7C, 0xB8,
  0xBB, 0x8B, 0xA9, 0xDD, 0x9A, 0x9A, 0xDD, 0xA9, 0x8C, 0xBB, 0xC8, 0x7E, 0x99, 0xE7, 0x6F, 0x77,
  0xF6,
  // "ŵ" (U+0175)
  0x00, 0x67, 0x00, 0x07, 0xA9, 0x80, 0x00, 0x00, 0x00, 0xE5, 0x00, 0x5E, 0xC7, 0xBB, 0x6C, 0xA8,
  0xDD, 0x7A, 0x8A, 0xDD, 0xA8, 0x6E, 0xAA, 0xE6, 0x4F, 0x88, 0xF4,
  // "Ŷ" (U+0176)
  0x20, 0x60, 0x73, 0x82, 0x7A, 0x98, 0x70, 0x90, 0xE2, 0x89, 0x3D, 0x92, 0xF4, 0x4F, 0x20, 0xBA,
  0x9B, 0x28, 0x25, 0xFE, 0x53, 0x00, 0xD4, 0x00, 0xB4, 0x00, 0xB4, 0x00, 0xB2,
  // "ŷ" (U+0177)
  0x20, 0x60, 0x73, 0x82, 0x7A, 0x98, 0x70, 0x90, 0xE2, 0x89, 0x3D, 0x94, 0xF3, 0x2F, 0x40, 0xE7,
  0x6E, 0x28, 0x29, 0xCA, 0xA2, 0x82, 0x4F, 0xE5, 0x30, 0xE9, 0x40, 0x0B, 0x28, 0x22, 0x8F, 0x42,
  0x81, 0x6E, 0x83,
  // "Ÿ" (U+0178)
  0x18, 0x2B, 0x66, 0xC2, 0x01, 0x28, 0x21, 0x09, 0xE2, 0x89, 0x3D, 0x92, 0xF4, 0x4F, 0x20, 0xBA,
  0x9B, 0x28, 0x25, 0xFE, 0x53, 0x00, 0xD4, 0x00, 0xB4, 0x00, 0xB4, 0x00, 0xB2,
  // "Ź" (U+0179)
  0x30, 0x70, 0x43, 0x81, 0x7B, 0x17, 0x10, 0xEB, 0x85, 0x40, 0x33, 0xAE, 0x13, 0x0E, 0x08, 0x38,
  0x17, 0xE1, 0x30, 0xE0, 0x83, 0x81, 0x6E, 0x13, 0x84, 0xEA, 0x33, 0x13, 0xC0, 0x40,
  // "ź" (U+017A)
  0x30, 0x70, 0x43, 0x81, 0x7B, 0x17, 0x03, 0xC8, 0x54, 0x03, 0x4D, 0xD1, 0x28, 0x17, 0xF3, 0x28,
  0x13, 0xF6, 0x28, 0x51, 0xDC, 0x33, 0x15, 0xC0, 0x50,
  // "Ż" (U+017B)
  0x20, 0x0B, 0x40, 0x01, 0x30, 0xEB, 0x85, 0x40, 0x33, 0xAE, 0x13, 0x0E, 0x08, 0x38, 0x17, 0xE1,
  0x30, 0xE0, 0x83, 0x81, 0x6E, 0x13, 0x84, 0xEA, 0x33, 0x13, 0xC0, 0x40,
  // "ż" (U+017C)
  0x20, 0x0B, 0x40, 0x01, 0x20, 0x3C, 0x85, 0x40, 0x34, 0xDD, 0x12, 0x81, 0x7F, 0x32, 0x81, 0x3F,
  0x62, 0x85, 0x1D, 0xC3, 0x31, 0x5C, 0x05,
  // "Ž" (U+017D)
  0x18, 0x25, 0x33, 0x52, 0x82, 0x2E, 0xE2, 0x71, 0x0E, 0xB8, 0x54, 0x03, 0x3A, 0xE1, 0x30, 0xE0,
  0x83, 0x81, 0x7E, 0x13, 0x0E, 0x08, 0x38, 0x16, 0xE1, 0x38, 0x4E, 0xA3, 0x31, 0x3C, 0x04,
  // "ž" (U+017E)
  0x18, 0x25, 0x33, 0x52, 0x82, 0x2E, 0xE2, 0x70, 0x3C, 0x85, 0x40, 0x34, 0xDD, 0x12, 0x81, 0x7F,
  0x32, 0x81, 0x3F, 0x62, 0x85, 0x1D, 0xC3, 0x31, 0x5C, 0x05,
  // "ſ" (U+017F)
  0x7E, 0xE1, 0xFA, 0x40, 0xF6, 0x00, 0xF6, 0x00, 0xF6, 0x00, 0xF6, 0x00, 0xF6, 0x00, 0xF6, 0x00,
  // "Ω" (U+03A9)
  0x07, 0xDD, 0x60, 0x3F, 0x77, 0xF2, 0x7D, 0x00, 0xD7, 0x8C, 0x00, 0xB8, 0x7D, 0x00, 0xC7, 0x3E,
  0x00, 0xE3, 0x3D, 0x77, 0xC3, 0xDF, 0x99, 0xFD,
  // "μ" (U+03BC)
  0x7E, 0x00, 0xF7, 0x7E, 0x00, 0xF7, 0x7E, 0x00, 0xF7, 0x7F, 0x01, 0xF7, 0x7F, 0x69, 0xF7, 0x7F,
  0xE9, 0xC7, 0x7E, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x7E, 0x00, 0x00,
  // "π" (U+03C0)
  0xAF, 0xFF, 0xFE, 0x3E, 0x9A, 0xD3, 0x0E, 0x68, 0xC0, 0x0E, 0x68, 0xC0, 0x0E, 0x68, 0xE4, 0x0E,
  0x63, 0xEC,
  // "–" (U+2013)
  0xC8, 0x00, 0x30,
  // "—" (U+2014)
  0xE8, 0x02, 0x30,
  // "€" (U+20AC)
  0x00, 0x7E, 0xE7, 0x06, 0xF6, 0x53, 0x0C, 0x90, 0x00, 0x9F, 0xFF, 0x70, 0x9F, 0xFF, 0x70, 0x2D,
  0xA3, 0x10, 0x07, 0xE6, 0x43, 0x00, 0x8E, 0xE5,
  // "₿" (U+20BF)
  0x00, 0x01, 0x00, 0x02, 0x7A, 0x00, 0x3F, 0xFF, 0xA0, 0x3F, 0x56, 0xF6, 0x3F, 0x23, 0xF5, 0x3F,
  0xFF, 0xB0, 0x3F, 0x55, 0xF5, 0x3F, 0x20, 0xE8, 0x3F, 0x56, 0xF6, 0x3F, 0xFF, 0xA0, 0x02, 0x7A,
  0x00,
  // "‘" (U+2018)
  0x4D, 0x9A, 0xB6,
  // "’" (U+2019)
  0x7E, 0xA9, 0xA4,
  // "‚" (U+201A)
  0x9C, 0xC8, 0xE3,
  // "‛" (U+201B)
  0xD8, 0x8A, 0x3B,
  // "“" (U+201C)
  0x4D, 0x4D, 0x9A, 0x9A, 0xB6, 0xB6,
  // "”" (U+201D)
  0x6B, 0x6B, 0xA9, 0xA9, 0xD4, 0xD4,
  // "„" (U+201E)
  0x9C, 0x9C, 0xC8, 0xC8, 0xE3, 0xE3,
  // "‟" (U+201F)
  0xB6, 0xB6, 0x9A, 0x9A, 0x4D, 0x4D,
  // "†" (U+2020)
  0x0A, 0x80, 0x08, 0x60, 0xDE, 0xDD, 0x38, 0x63, 0x08, 0x60, 0x08, 0x70, 0x09, 0x80, 0x0A, 0x90,
  // "‡" (U+2021)
  0x09, 0x90, 0x17, 0x71, 0xFE, 0xEF, 0x08, 0x80, 0x08, 0x80, 0xED, 0xDE, 0x38, 0x83, 0x09, 0x90,
  // "•" (U+2022)
  0x1D, 0xD1, 0x5F, 0xF5, 0x1D, 0xD1,
  // "…" (U+2026)
  0x80, 0x21, 0x80, 0x2B,
  // "‰" (U+2030)
  0x7E, 0x10, 0x00, 0xCA, 0x50, 0x00, 0x9F, 0x4B, 0x40, 0x03, 0xC3, 0x00, 0x2C, 0x30, 0x00, 0x28,
  0xE5, 0xE8, 0x0A, 0xCC, 0xCC, 0x06, 0xE5, 0xE7,
  // "‹" (U+2039)
  0x01, 0xC2, 0x0C, 0xA0, 0x3F, 0x40, 0x07, 0xE1, 0x00, 0x50,
  // "›" (U+203A)
  0x05, 0x00, 0x1E, 0x70, 0x04, 0xF3, 0x0A, 0xC0, 0x2C, 0x10,
  // "⁄" (U+2044)
  0x00, 0x3C, 0x00, 0x97, 0x00, 0xE1, 0x05, 0xB0, 0x0B, 0x50, 0x1E, 0x00, 0x79, 0x00, 0xC4, 0x00,
  // "™" (U+2122)
  0xDE, 0xAD, 0x2E, 0x19, 0x4D, 0x9D, 0x19, 0x49, 0xCB, 0x19, 0x36, 0x0A,
  // "⅒" (U+2152)
  0x50, 0x30, 0xC7, 0x81, 0x2B, 0xA2, 0x09, 0x07, 0x78, 0x12, 0x7A, 0x20, 0xE0, 0x17, 0x18, 0x34,
  0xA0, 0x5B, 0x48, 0xA0, 0x2C, 0xB2, 0x2B, 0xD6, 0xB5, 0x2B, 0xA0, 0x96, 0x59, 0x38, 0x91, 0x1E,
  0x02, 0x7A, 0x0B, 0x33, 0xB3, 0x07, 0x09, 0x28, 0x54, 0xA0, 0x96, 0x59, 0x38, 0x91, 0xC4, 0x02,
  0xBD, 0x62, 0xCC, 0x20,
  // "∂" (U+2202)
  0x03, 0xDE, 0x90, 0x02, 0x22, 0xF4, 0x05, 0xED, 0xE6, 0x1F, 0x72, 0xF6, 0x6F, 0x04, 0xF2, 0x6F,
  0x1B, 0xB0, 0x0C, 0xFA, 0x10,
  // "∆" (U+2206)
  0x00, 0xEE, 0x00, 0x04, 0xFF, 0x30, 0x08, 0xDD, 0x80, 0x0D, 0x88, 0xD0, 0x2F, 0x44, 0xF2, 0x6E,
  0x00, 0xE6, 0xBC, 0x44, 0xCB, 0xEF, 0xFF, 0xFE,
  // "√" (U+221A)
  0x40, 0x10, 0x74, 0x05, 0x0C, 0x40, 0x90, 0x84, 0x0D, 0x03, 0x38, 0x94, 0x2E, 0x0A, 0xF1, 0x6A,
  0x02, 0xB6, 0xA6, 0x28, 0x25, 0xBE, 0x12, 0x81, 0x1F, 0xD4, 0x0A, 0x08, 0x20,
  // "∞" (U+221E)
  0x6E, 0x88, 0xE7, 0xD4, 0xCC, 0x4C, 0x7E, 0x8A, 0xE6,
  // "≈" (U+2248)
  0x2D, 0xC4, 0x24, 0x55, 0x7D, 0xD3, 0x2E, 0xD4, 0x24, 0x55, 0x7F, 0xF3, 0x00, 0x01, 0x10,
  // "≠" (U+2260)
  0x30, 0x15, 0x82, 0xB7, 0x04, 0xC8, 0x64, 0x02, 0x9B, 0x20, 0x4C, 0x84, 0x40, 0x7D, 0x22, 0x30,
  0x23,
  // "≤" (U+2264)
  0x50, 0x13, 0x89, 0x36, 0xD5, 0x06, 0xD9, 0x20, 0x5F, 0x91, 0x38, 0x31, 0x8E, 0xA2, 0x48, 0x66,
  0x45, 0xEE, 0xEE, 0x61, 0x80, 0x01, 0x10,
  // "≥" (U+2265)
  0x01, 0x58, 0x15, 0xD6, 0x48, 0x22, 0x9D, 0x63, 0x89, 0x21, 0x9F, 0x52, 0xAE, 0x81, 0x04, 0x64,
  0x84, 0x6E, 0xEE, 0xE5, 0x18, 0x00, 0x11,
};

const Font& font_NotoSansMono_Bold_10() {
  static SmoothFont font(font_NotoSansMono_Bold_10_data);
  return font;
}

}  // namespace roo_display
