#include "8.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSerif-Regular (Noto Serif Regular)
// Generated on Thu Mar 30 22:29:06 CEST 2023
static const uint8_t font_NotoSerif_Regular_8_data[] PROGMEM = {
  
  // Header
  0x01, 0x01, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x03, 0x17,
  0xFE, 0xFE, 0x09, 0x0A, 0x07, 0xFE, 0x04, 0x01, 0x0A, 0x03, 0x03, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x00, 0x01, 0x01, 0x07, 0x03, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x00, 0x06, 0x02, 0x07, 0x03, 0x00, 0x09, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x04, 0x07, 0x04, 0x00, 0x0D, // "#" (U+0023)
  0x00, 0x24, 0x00, 0x00, 0x03, 0x07, 0x04, 0x00, 0x21, // "$" (U+0024)
  0x00, 0x25, 0x00, 0x01, 0x06, 0x07, 0x07, 0x00, 0x33, // "%" (U+0025)
  0x00, 0x26, 0x00, 0x01, 0x05, 0x07, 0x06, 0x00, 0x4F, // "&" (U+0026)
  0x00, 0x27, 0x00, 0x06, 0x01, 0x07, 0x02, 0x00, 0x66, // "'" (U+0027)
  0x00, 0x28, 0x00, 0x00, 0x02, 0x06, 0x03, 0x00, 0x69, // "(" (U+0028)
  0x00, 0x29, 0x00, 0x00, 0x02, 0x06, 0x03, 0x00, 0x76, // ")" (U+0029)
  0x00, 0x2A, 0x00, 0x04, 0x03, 0x07, 0x04, 0x00, 0x83, // "*" (U+002A)
  0x00, 0x2B, 0x00, 0x02, 0x03, 0x05, 0x04, 0x00, 0x8D, // "+" (U+002B)
  0x00, 0x2C, 0x00, 0xFF, 0x01, 0x01, 0x02, 0x00, 0x95, // "," (U+002C)
  0x00, 0x2D, 0x00, 0x03, 0x02, 0x03, 0x02, 0x00, 0x99, // "-" (U+002D)
  0x00, 0x2E, 0x00, 0x01, 0x01, 0x01, 0x02, 0x00, 0x9C, // "." (U+002E)
  0x00, 0x2F, 0x00, 0x00, 0x02, 0x07, 0x02, 0x00, 0x9E, // "/" (U+002F)
  0x00, 0x30, 0x00, 0x01, 0x04, 0x07, 0x04, 0x00, 0xAB, // "0" (U+0030)
  0x00, 0x31, 0x00, 0x01, 0x03, 0x07, 0x04, 0x00, 0xBF, // "1" (U+0031)
  0x00, 0x32, 0x00, 0x01, 0x03, 0x07, 0x04, 0x00, 0xCD, // "2" (U+0032)
  0x00, 0x33, 0x00, 0x01, 0x03, 0x07, 0x04, 0x00, 0xDE, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x01, 0x04, 0x07, 0x04, 0x00, 0xEE, // "4" (U+0034)
  0x00, 0x35, 0x00, 0x01, 0x03, 0x07, 0x04, 0x01, 0x03, // "5" (U+0035)
  0x00, 0x36, 0x00, 0x01, 0x03, 0x07, 0x04, 0x01, 0x14, // "6" (U+0036)
  0x00, 0x37, 0x00, 0x01, 0x03, 0x07, 0x04, 0x01, 0x24, // "7" (U+0037)
  0x00, 0x38, 0x00, 0x01, 0x03, 0x07, 0x04, 0x01, 0x35, // "8" (U+0038)
  0x00, 0x39, 0x00, 0x01, 0x03, 0x07, 0x04, 0x01, 0x45, // "9" (U+0039)
  0x00, 0x3A, 0x00, 0x01, 0x01, 0x05, 0x02, 0x01, 0x55, // ":" (U+003A)
  0x00, 0x3B, 0x00, 0xFF, 0x01, 0x05, 0x02, 0x01, 0x5B, // ";" (U+003B)
  0x00, 0x3C, 0x00, 0x02, 0x03, 0x05, 0x04, 0x01, 0x63, // "<" (U+003C)
  0x00, 0x3D, 0x00, 0x03, 0x03, 0x05, 0x04, 0x01, 0x6C, // "=" (U+003D)
  0x00, 0x3E, 0x00, 0x02, 0x03, 0x05, 0x04, 0x01, 0x73, // ">" (U+003E)
  0x00, 0x3F, 0x00, 0x01, 0x03, 0x07, 0x04, 0x01, 0x7C, // "?" (U+003F)
  0x00, 0x40, 0x00, 0x00, 0x06, 0x07, 0x07, 0x01, 0x8B, // "@" (U+0040)
  0x00, 0x41, 0x00, 0x01, 0x05, 0x07, 0x06, 0x01, 0xA8, // "A" (U+0041)
  0x00, 0x42, 0x00, 0x01, 0x04, 0x07, 0x05, 0x01, 0xBE, // "B" (U+0042)
  0x00, 0x43, 0x00, 0x01, 0x04, 0x07, 0x05, 0x01, 0xD1, // "C" (U+0043)
  0x00, 0x44, 0x00, 0x01, 0x05, 0x07, 0x06, 0x01, 0xE4, // "D" (U+0044)
  0x00, 0x45, 0x00, 0x01, 0x04, 0x07, 0x05, 0x01, 0xFC, // "E" (U+0045)
  0x00, 0x46, 0x00, 0x01, 0x04, 0x07, 0x05, 0x02, 0x0E, // "F" (U+0046)
  0x00, 0x47, 0x00, 0x01, 0x05, 0x07, 0x06, 0x02, 0x1F, // "G" (U+0047)
  0x00, 0x48, 0x00, 0x01, 0x05, 0x07, 0x06, 0x02, 0x35, // "H" (U+0048)
  0x00, 0x49, 0x00, 0x01, 0x02, 0x07, 0x03, 0x02, 0x4E, // "I" (U+0049)
  0x00, 0x4A, 0x00, 0xFF, 0x02, 0x07, 0x03, 0x02, 0x5A, // "J" (U+004A)
  0x00, 0x4B, 0x00, 0x01, 0x05, 0x07, 0x06, 0x02, 0x69, // "K" (U+004B)
  0x00, 0x4C, 0x00, 0x01, 0x04, 0x07, 0x05, 0x02, 0x81, // "L" (U+004C)
  0x00, 0x4D, 0x00, 0x01, 0x07, 0x07, 0x08, 0x02, 0x90, // "M" (U+004D)
  0x00, 0x4E, 0x00, 0x01, 0x05, 0x07, 0x06, 0x02, 0xB1, // "N" (U+004E)
  0x00, 0x4F, 0x00, 0x01, 0x05, 0x07, 0x06, 0x02, 0xC8, // "O" (U+004F)
  0x00, 0x50, 0x00, 0x01, 0x04, 0x07, 0x05, 0x02, 0xE1, // "P" (U+0050)
  0x00, 0x51, 0x00, 0xFF, 0x05, 0x07, 0x06, 0x02, 0xF4, // "Q" (U+0051)
  0x00, 0x52, 0x00, 0x01, 0x05, 0x07, 0x05, 0x03, 0x12, // "R" (U+0052)
  0x00, 0x53, 0x00, 0x01, 0x03, 0x07, 0x04, 0x03, 0x2A, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x04, 0x07, 0x05, 0x03, 0x3B, // "T" (U+0054)
  0x00, 0x55, 0x00, 0x01, 0x05, 0x07, 0x06, 0x03, 0x4B, // "U" (U+0055)
  0x00, 0x56, 0x00, 0x01, 0x05, 0x07, 0x05, 0x03, 0x63, // "V" (U+0056)
  0x00, 0x57, 0x00, 0x01, 0x08, 0x07, 0x08, 0x03, 0x79, // "W" (U+0057)
  0x00, 0x58, 0x00, 0x01, 0x05, 0x07, 0x05, 0x03, 0x9A, // "X" (U+0058)
  0x00, 0x59, 0x00, 0x01, 0x04, 0x07, 0x05, 0x03, 0xB1, // "Y" (U+0059)
  0x00, 0x5A, 0x00, 0x01, 0x04, 0x07, 0x05, 0x03, 0xC3, // "Z" (U+005A)
  0x00, 0x5B, 0x00, 0x00, 0x02, 0x07, 0x03, 0x03, 0xD7, // "[" (U+005B)
  0x00, 0x5C, 0x00, 0x00, 0x02, 0x07, 0x02, 0x03, 0xE5, // "\" (U+005C)
  0x00, 0x5D, 0x00, 0x00, 0x02, 0x07, 0x03, 0x03, 0xF3, // "]" (U+005D)
  0x00, 0x5E, 0x00, 0x03, 0x03, 0x06, 0x04, 0x04, 0x01, // "^" (U+005E)
  0x00, 0x5F, 0x00, 0xFF, 0x03, 0xFF, 0x04, 0x04, 0x0B, // "_" (U+005F)
  0x00, 0x60, 0x00, 0x07, 0x01, 0x08, 0x02, 0x04, 0x0E, // "`" (U+0060)
  0x00, 0x61, 0x00, 0x01, 0x04, 0x05, 0x05, 0x04, 0x11, // "a" (U+0061)
  0x00, 0x62, 0x00, 0x01, 0x04, 0x07, 0x05, 0x04, 0x1F, // "b" (U+0062)
  0x00, 0x63, 0x00, 0x01, 0x03, 0x05, 0x04, 0x04, 0x32, // "c" (U+0063)
  0x00, 0x64, 0x00, 0x01, 0x04, 0x07, 0x05, 0x04, 0x3F, // "d" (U+0064)
  0x00, 0x65, 0x00, 0x01, 0x03, 0x05, 0x04, 0x04, 0x51, // "e" (U+0065)
  0x00, 0x66, 0x00, 0x01, 0x03, 0x07, 0x03, 0x04, 0x5D, // "f" (U+0066)
  0x00, 0x67, 0x00, 0xFF, 0x04, 0x05, 0x04, 0x04, 0x6C, // "g" (U+0067)
  0x00, 0x68, 0x00, 0x01, 0x04, 0x07, 0x05, 0x04, 0x80, // "h" (U+0068)
  0x00, 0x69, 0x00, 0x01, 0x02, 0x07, 0x03, 0x04, 0x93, // "i" (U+0069)
  0x00, 0x6A, 0x00, 0xFF, 0x01, 0x07, 0x02, 0x04, 0x9F, // "j" (U+006A)
  0x00, 0x6B, 0x00, 0x01, 0x04, 0x07, 0x05, 0x04, 0xAA, // "k" (U+006B)
  0x00, 0x6C, 0x00, 0x01, 0x02, 0x07, 0x02, 0x04, 0xBD, // "l" (U+006C)
  0x00, 0x6D, 0x00, 0x01, 0x07, 0x05, 0x08, 0x04, 0xC9, // "m" (U+006D)
  0x00, 0x6E, 0x00, 0x01, 0x04, 0x05, 0x05, 0x04, 0xDF, // "n" (U+006E)
  0x00, 0x6F, 0x00, 0x01, 0x04, 0x05, 0x05, 0x04, 0xED, // "o" (U+006F)
  0x00, 0x70, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x04, 0xFB, // "p" (U+0070)
  0x00, 0x71, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x05, 0x0E, // "q" (U+0071)
  0x00, 0x72, 0x00, 0x01, 0x03, 0x05, 0x04, 0x05, 0x20, // "r" (U+0072)
  0x00, 0x73, 0x00, 0x01, 0x03, 0x05, 0x04, 0x05, 0x2D, // "s" (U+0073)
  0x00, 0x74, 0x00, 0x01, 0x02, 0x06, 0x03, 0x05, 0x39, // "t" (U+0074)
  0x00, 0x75, 0x00, 0x01, 0x04, 0x05, 0x05, 0x05, 0x44, // "u" (U+0075)
  0x00, 0x76, 0x00, 0x01, 0x04, 0x05, 0x05, 0x05, 0x52, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x01, 0x06, 0x05, 0x07, 0x05, 0x61, // "w" (U+0077)
  0x00, 0x78, 0x00, 0x01, 0x04, 0x05, 0x05, 0x05, 0x75, // "x" (U+0078)
  0x00, 0x79, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x05, 0x83, // "y" (U+0079)
  0x00, 0x7A, 0x00, 0x01, 0x03, 0x05, 0x04, 0x05, 0x96, // "z" (U+007A)
  0x00, 0x7B, 0x00, 0x00, 0x02, 0x07, 0x03, 0x05, 0xA2, // "{" (U+007B)
  0x00, 0x7C, 0x02, 0xFF, 0x02, 0x07, 0x04, 0x05, 0xB0, // "|" (U+007C)
  0x00, 0x7D, 0x00, 0x00, 0x02, 0x07, 0x03, 0x05, 0xB2, // "}" (U+007D)
  0x00, 0x7E, 0x00, 0x03, 0x03, 0x04, 0x04, 0x05, 0xC0, // "~" (U+007E)
  0x00, 0xA1, 0x01, 0xFE, 0x02, 0x04, 0x03, 0x05, 0xC5, // "¡" (U+00A1)
  0x00, 0xA2, 0x00, 0x01, 0x03, 0x07, 0x04, 0x05, 0xCE, // "¢" (U+00A2)
  0x00, 0xA3, 0x00, 0x01, 0x04, 0x07, 0x04, 0x05, 0xDE, // "£" (U+00A3)
  0x00, 0xA4, 0x00, 0x02, 0x03, 0x06, 0x04, 0x05, 0xF1, // "¤" (U+00A4)
  0x00, 0xA5, 0x00, 0x01, 0x04, 0x07, 0x04, 0x05, 0xFD, // "¥" (U+00A5)
  0x00, 0xA6, 0x02, 0xFF, 0x02, 0x07, 0x04, 0x06, 0x11, // "¦" (U+00A6)
  0x00, 0xA7, 0x00, 0x00, 0x03, 0x07, 0x04, 0x06, 0x17, // "§" (U+00A7)
  0x00, 0xA8, 0x01, 0x07, 0x03, 0x07, 0x05, 0x06, 0x2A, // "¨" (U+00A8)
  0x00, 0xA9, 0x00, 0x01, 0x06, 0x07, 0x07, 0x06, 0x2D, // "©" (U+00A9)
  0x00, 0xAA, 0x00, 0x04, 0x02, 0x06, 0x03, 0x06, 0x49, // "ª" (U+00AA)
  0x00, 0xAB, 0x00, 0x02, 0x03, 0x05, 0x04, 0x06, 0x4F, // "«" (U+00AB)
  0x00, 0xAC, 0x00, 0x02, 0x03, 0x04, 0x04, 0x06, 0x59, // "¬" (U+00AC)
  0x00, 0xAE, 0x00, 0x01, 0x06, 0x07, 0x07, 0x06, 0x5F, // "®" (U+00AE)
  0x00, 0xAF, 0x00, 0x08, 0x03, 0x08, 0x04, 0x06, 0x7A, // "¯" (U+00AF)
  0x00, 0xB0, 0x00, 0x05, 0x02, 0x07, 0x03, 0x06, 0x7D, // "°" (U+00B0)
  0x00, 0xB1, 0x00, 0x01, 0x03, 0x05, 0x04, 0x06, 0x83, // "±" (U+00B1)
  0x00, 0xB2, 0x00, 0x04, 0x02, 0x07, 0x03, 0x06, 0x8E, // "²" (U+00B2)
  0x00, 0xB3, 0x00, 0x04, 0x02, 0x07, 0x03, 0x06, 0x96, // "³" (U+00B3)
  0x00, 0xB4, 0x00, 0x07, 0x01, 0x08, 0x02, 0x06, 0x9E, // "´" (U+00B4)
  0x00, 0xB5, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x06, 0xA1, // "µ" (U+00B5)
  0x00, 0xB6, 0x00, 0x00, 0x04, 0x07, 0x05, 0x06, 0xB3, // "¶" (U+00B6)
  0x00, 0xB7, 0x00, 0x04, 0x01, 0x04, 0x02, 0x06, 0xC8, // "·" (U+00B7)
  0x00, 0xB8, 0x00, 0xFF, 0x02, 0x01, 0x03, 0x06, 0xCA, // "¸" (U+00B8)
  0x00, 0xB9, 0x00, 0x04, 0x02, 0x07, 0x03, 0x06, 0xD0, // "¹" (U+00B9)
  0x00, 0xBA, 0x00, 0x04, 0x02, 0x06, 0x03, 0x06, 0xD8, // "º" (U+00BA)
  0x00, 0xBB, 0x00, 0x02, 0x03, 0x05, 0x04, 0x06, 0xDE, // "»" (U+00BB)
  0x00, 0xBC, 0x00, 0x01, 0x06, 0x07, 0x07, 0x06, 0xE8, // "¼" (U+00BC)
  0x00, 0xBD, 0x00, 0x01, 0x06, 0x07, 0x07, 0x07, 0x01, // "½" (U+00BD)
  0x00, 0xBE, 0x00, 0x01, 0x06, 0x07, 0x07, 0x07, 0x1A, // "¾" (U+00BE)
  0x00, 0xBF, 0x00, 0xFE, 0x03, 0x04, 0x04, 0x07, 0x34, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x05, 0x09, 0x06, 0x07, 0x43, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x05, 0x09, 0x06, 0x07, 0x5E, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x01, 0x05, 0x09, 0x06, 0x07, 0x78, // "Â" (U+00C2)
  0x00, 0xC3, 0x00, 0x01, 0x05, 0x08, 0x06, 0x07, 0x93, // "Ã" (U+00C3)
  0x00, 0xC4, 0x00, 0x01, 0x05, 0x08, 0x06, 0x07, 0xAD, // "Ä" (U+00C4)
  0x00, 0xC5, 0x00, 0x01, 0x05, 0x08, 0x06, 0x07, 0xC6, // "Å" (U+00C5)
  0x00, 0xC6, 0x00, 0x01, 0x07, 0x07, 0x08, 0x07, 0xDF, // "Æ" (U+00C6)
  0x00, 0xC7, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x07, 0xFC, // "Ç" (U+00C7)
  0x00, 0xC8, 0x00, 0x01, 0x04, 0x09, 0x05, 0x08, 0x14, // "È" (U+00C8)
  0x00, 0xC9, 0x00, 0x01, 0x04, 0x09, 0x05, 0x08, 0x2C, // "É" (U+00C9)
  0x00, 0xCA, 0x00, 0x01, 0x04, 0x09, 0x05, 0x08, 0x42, // "Ê" (U+00CA)
  0x00, 0xCB, 0x00, 0x01, 0x04, 0x08, 0x05, 0x08, 0x59, // "Ë" (U+00CB)
  0x00, 0xCC, 0x00, 0x01, 0x02, 0x09, 0x03, 0x08, 0x6E, // "Ì" (U+00CC)
  0x00, 0xCD, 0x00, 0x01, 0x02, 0x09, 0x03, 0x08, 0x7E, // "Í" (U+00CD)
  0x00, 0xCE, 0x00, 0x01, 0x02, 0x09, 0x03, 0x08, 0x8D, // "Î" (U+00CE)
  0x00, 0xCF, 0x00, 0x01, 0x02, 0x08, 0x03, 0x08, 0x9D, // "Ï" (U+00CF)
  0x00, 0xD0, 0x00, 0x01, 0x05, 0x07, 0x06, 0x08, 0xAB, // "Ð" (U+00D0)
  0x00, 0xD1, 0x00, 0x01, 0x05, 0x08, 0x06, 0x08, 0xC3, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x00, 0x01, 0x05, 0x09, 0x06, 0x08, 0xDD, // "Ò" (U+00D2)
  0x00, 0xD3, 0x00, 0x01, 0x05, 0x09, 0x06, 0x08, 0xFB, // "Ó" (U+00D3)
  0x00, 0xD4, 0x00, 0x01, 0x05, 0x09, 0x06, 0x09, 0x18, // "Ô" (U+00D4)
  0x00, 0xD5, 0x00, 0x01, 0x05, 0x08, 0x06, 0x09, 0x35, // "Õ" (U+00D5)
  0x00, 0xD6, 0x00, 0x01, 0x05, 0x08, 0x06, 0x09, 0x51, // "Ö" (U+00D6)
  0x00, 0xD7, 0x00, 0x02, 0x03, 0x05, 0x04, 0x09, 0x6D, // "×" (U+00D7)
  0x00, 0xD8, 0x00, 0x00, 0x05, 0x07, 0x06, 0x09, 0x77, // "Ø" (U+00D8)
  0x00, 0xD9, 0x00, 0x01, 0x05, 0x09, 0x06, 0x09, 0x8F, // "Ù" (U+00D9)
  0x00, 0xDA, 0x00, 0x01, 0x05, 0x09, 0x06, 0x09, 0xAD, // "Ú" (U+00DA)
  0x00, 0xDB, 0x00, 0x01, 0x05, 0x09, 0x06, 0x09, 0xCA, // "Û" (U+00DB)
  0x00, 0xDC, 0x00, 0x01, 0x05, 0x08, 0x06, 0x09, 0xE7, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0A, 0x02, // "Ý" (U+00DD)
  0x00, 0xDE, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x18, // "Þ" (U+00DE)
  0x00, 0xDF, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x2B, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0A, 0x3F, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0A, 0x53, // "á" (U+00E1)
  0x00, 0xE2, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0A, 0x66, // "â" (U+00E2)
  0x00, 0xE3, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x79, // "ã" (U+00E3)
  0x00, 0xE4, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x8D, // "ä" (U+00E4)
  0x00, 0xE5, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0A, 0x9F, // "å" (U+00E5)
  0x00, 0xE6, 0x00, 0x01, 0x06, 0x05, 0x07, 0x0A, 0xB6, // "æ" (U+00E6)
  0x00, 0xE7, 0x00, 0xFF, 0x03, 0x05, 0x04, 0x0A, 0xC9, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0A, 0xDA, // "è" (U+00E8)
  0x00, 0xE9, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0A, 0xEB, // "é" (U+00E9)
  0x00, 0xEA, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0A, 0xFB, // "ê" (U+00EA)
  0x00, 0xEB, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0B, 0x0C, // "ë" (U+00EB)
  0x00, 0xEC, 0x00, 0x01, 0x02, 0x08, 0x03, 0x0B, 0x1B, // "ì" (U+00EC)
  0x00, 0xED, 0x00, 0x01, 0x02, 0x08, 0x03, 0x0B, 0x28, // "í" (U+00ED)
  0x00, 0xEE, 0x00, 0x01, 0x02, 0x08, 0x03, 0x0B, 0x35, // "î" (U+00EE)
  0x00, 0xEF, 0x00, 0x01, 0x02, 0x07, 0x03, 0x0B, 0x43, // "ï" (U+00EF)
  0x00, 0xF0, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0B, 0x4F, // "ð" (U+00F0)
  0x00, 0xF1, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0B, 0x63, // "ñ" (U+00F1)
  0x00, 0xF2, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0B, 0x76, // "ò" (U+00F2)
  0x00, 0xF3, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0B, 0x8A, // "ó" (U+00F3)
  0x00, 0xF4, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0B, 0x9D, // "ô" (U+00F4)
  0x00, 0xF5, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0B, 0xB0, // "õ" (U+00F5)
  0x00, 0xF6, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0B, 0xC3, // "ö" (U+00F6)
  0x00, 0xF7, 0x00, 0x02, 0x03, 0x05, 0x04, 0x0B, 0xD5, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x00, 0x04, 0x06, 0x05, 0x0B, 0xDD, // "ø" (U+00F8)
  0x00, 0xF9, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0B, 0xEE, // "ù" (U+00F9)
  0x00, 0xFA, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0C, 0x02, // "ú" (U+00FA)
  0x00, 0xFB, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0C, 0x15, // "û" (U+00FB)
  0x00, 0xFC, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0C, 0x28, // "ü" (U+00FC)
  0x00, 0xFD, 0x00, 0xFF, 0x04, 0x08, 0x05, 0x0C, 0x3A, // "ý" (U+00FD)
  0x00, 0xFE, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0C, 0x51, // "þ" (U+00FE)
  0x00, 0xFF, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0C, 0x69, // "ÿ" (U+00FF)
  0x01, 0x00, 0x00, 0x01, 0x05, 0x07, 0x06, 0x0C, 0x7F, // "Ā" (U+0100)
  0x01, 0x01, 0x00, 0x01, 0x04, 0x06, 0x05, 0x0C, 0x96, // "ā" (U+0101)
  0x01, 0x02, 0x00, 0x01, 0x05, 0x08, 0x06, 0x0C, 0xA7, // "Ă" (U+0102)
  0x01, 0x03, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0C, 0xC1, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0xFF, 0x05, 0x07, 0x06, 0x0C, 0xD5, // "Ą" (U+0104)
  0x01, 0x05, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x0C, 0xF1, // "ą" (U+0105)
  0x01, 0x06, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0D, 0x05, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0D, 0x1C, // "ć" (U+0107)
  0x01, 0x08, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0D, 0x2D, // "Ĉ" (U+0108)
  0x01, 0x09, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0D, 0x45, // "ĉ" (U+0109)
  0x01, 0x0A, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0D, 0x57, // "Ċ" (U+010A)
  0x01, 0x0B, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0D, 0x6D, // "ċ" (U+010B)
  0x01, 0x0C, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0D, 0x7D, // "Č" (U+010C)
  0x01, 0x0D, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0D, 0x96, // "č" (U+010D)
  0x01, 0x0E, 0x00, 0x01, 0x05, 0x09, 0x06, 0x0D, 0xA8, // "Ď" (U+010E)
  0x01, 0x0F, 0x00, 0x01, 0x05, 0x07, 0x05, 0x0D, 0xC7, // "ď" (U+010F)
  0x01, 0x10, 0x00, 0x01, 0x05, 0x07, 0x06, 0x0D, 0xDF, // "Đ" (U+0110)
  0x01, 0x11, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0D, 0xF7, // "đ" (U+0111)
  0x01, 0x12, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0E, 0x0A, // "Ē" (U+0112)
  0x01, 0x13, 0x00, 0x01, 0x03, 0x06, 0x04, 0x0E, 0x1C, // "ē" (U+0113)
  0x01, 0x14, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0E, 0x2A, // "Ĕ" (U+0114)
  0x01, 0x15, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0E, 0x3F, // "ĕ" (U+0115)
  0x01, 0x16, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0E, 0x4F, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0E, 0x64, // "ė" (U+0117)
  0x01, 0x18, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0E, 0x73, // "Ę" (U+0118)
  0x01, 0x19, 0x00, 0xFF, 0x03, 0x05, 0x04, 0x0E, 0x89, // "ę" (U+0119)
  0x01, 0x1A, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0E, 0x99, // "Ě" (U+011A)
  0x01, 0x1B, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0E, 0xB1, // "ě" (U+011B)
  0x01, 0x1C, 0x00, 0x01, 0x05, 0x09, 0x06, 0x0E, 0xC2, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x00, 0xFF, 0x04, 0x08, 0x04, 0x0E, 0xDD, // "ĝ" (U+011D)
  0x01, 0x1E, 0x00, 0x01, 0x05, 0x08, 0x06, 0x0E, 0xF6, // "Ğ" (U+011E)
  0x01, 0x1F, 0x00, 0xFF, 0x04, 0x07, 0x04, 0x0F, 0x0F, // "ğ" (U+011F)
  0x01, 0x20, 0x00, 0x01, 0x05, 0x08, 0x06, 0x0F, 0x28, // "Ġ" (U+0120)
  0x01, 0x21, 0x00, 0xFF, 0x04, 0x07, 0x04, 0x0F, 0x41, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0xFE, 0x05, 0x07, 0x06, 0x0F, 0x58, // "Ģ" (U+0122)
  0x01, 0x23, 0x00, 0xFF, 0x04, 0x07, 0x04, 0x0F, 0x73, // "ģ" (U+0123)
  0x01, 0x24, 0x00, 0x01, 0x05, 0x09, 0x06, 0x0F, 0x8B, // "Ĥ" (U+0124)
  0x01, 0x25, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x0F, 0xA8, // "ĥ" (U+0125)
  0x01, 0x26, 0x00, 0x01, 0x05, 0x07, 0x06, 0x0F, 0xC0, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0F, 0xD8, // "ħ" (U+0127)
  0x01, 0x28, 0x00, 0x01, 0x03, 0x08, 0x03, 0x0F, 0xEC, // "Ĩ" (U+0128)
  0x01, 0x29, 0xFF, 0x01, 0x02, 0x07, 0x03, 0x0F, 0xFC, // "ĩ" (U+0129)
  0x01, 0x2A, 0x00, 0x01, 0x02, 0x07, 0x03, 0x10, 0x0E, // "Ī" (U+012A)
  0x01, 0x2B, 0x00, 0x01, 0x02, 0x06, 0x03, 0x10, 0x1A, // "ī" (U+012B)
  0x01, 0x2C, 0x00, 0x01, 0x02, 0x08, 0x03, 0x10, 0x25, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x00, 0x01, 0x02, 0x07, 0x03, 0x10, 0x33, // "ĭ" (U+012D)
  0x01, 0x2E, 0x00, 0xFF, 0x02, 0x07, 0x03, 0x10, 0x3F, // "Į" (U+012E)
  0x01, 0x2F, 0x00, 0xFF, 0x02, 0x07, 0x03, 0x10, 0x4E, // "į" (U+012F)
  0x01, 0x30, 0x00, 0x01, 0x02, 0x08, 0x03, 0x10, 0x5D, // "İ" (U+0130)
  0x01, 0x31, 0x00, 0x01, 0x02, 0x05, 0x03, 0x10, 0x6B, // "ı" (U+0131)
  0x01, 0x32, 0x00, 0xFF, 0x05, 0x07, 0x06, 0x10, 0x74, // "Ĳ" (U+0132)
  0x01, 0x33, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x10, 0x8F, // "ĳ" (U+0133)
  0x01, 0x34, 0x00, 0xFF, 0x02, 0x09, 0x03, 0x10, 0xA6, // "Ĵ" (U+0134)
  0x01, 0x35, 0x00, 0xFF, 0x02, 0x08, 0x02, 0x10, 0xB9, // "ĵ" (U+0135)
  0x01, 0x36, 0x00, 0xFE, 0x05, 0x07, 0x06, 0x10, 0xCA, // "Ķ" (U+0136)
  0x01, 0x37, 0x00, 0xFE, 0x04, 0x07, 0x05, 0x10, 0xE7, // "ķ" (U+0137)
  0x01, 0x38, 0x00, 0x01, 0x04, 0x05, 0x05, 0x10, 0xFF, // "ĸ" (U+0138)
  0x01, 0x39, 0x00, 0x01, 0x04, 0x09, 0x05, 0x11, 0x0D, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x00, 0x01, 0x02, 0x0A, 0x02, 0x11, 0x20, // "ĺ" (U+013A)
  0x01, 0x3B, 0x00, 0xFE, 0x04, 0x07, 0x05, 0x11, 0x30, // "Ļ" (U+013B)
  0x01, 0x3C, 0x00, 0xFE, 0x02, 0x07, 0x02, 0x11, 0x43, // "ļ" (U+013C)
  0x01, 0x3D, 0x00, 0x01, 0x04, 0x07, 0x05, 0x11, 0x53, // "Ľ" (U+013D)
  0x01, 0x3E, 0x00, 0x01, 0x02, 0x07, 0x02, 0x11, 0x63, // "ľ" (U+013E)
  0x01, 0x3F, 0x00, 0x01, 0x04, 0x07, 0x05, 0x11, 0x6F, // "Ŀ" (U+013F)
  0x01, 0x40, 0x00, 0x01, 0x03, 0x07, 0x03, 0x11, 0x7F, // "ŀ" (U+0140)
  0x01, 0x41, 0x00, 0x01, 0x04, 0x07, 0x05, 0x11, 0x91, // "Ł" (U+0141)
  0x01, 0x42, 0x00, 0x01, 0x02, 0x07, 0x03, 0x11, 0xA3, // "ł" (U+0142)
  0x01, 0x43, 0x00, 0x01, 0x05, 0x09, 0x06, 0x11, 0xB0, // "Ń" (U+0143)
  0x01, 0x44, 0x00, 0x01, 0x04, 0x08, 0x05, 0x11, 0xCB, // "ń" (U+0144)
  0x01, 0x45, 0x00, 0xFE, 0x05, 0x07, 0x06, 0x11, 0xDE, // "Ņ" (U+0145)
  0x01, 0x46, 0x00, 0xFE, 0x04, 0x05, 0x05, 0x11, 0xFA, // "ņ" (U+0146)
  0x01, 0x47, 0x00, 0x01, 0x05, 0x09, 0x06, 0x12, 0x0D, // "Ň" (U+0147)
  0x01, 0x48, 0x00, 0x01, 0x04, 0x08, 0x05, 0x12, 0x29, // "ň" (U+0148)
  0x01, 0x49, 0x00, 0x01, 0x05, 0x07, 0x06, 0x12, 0x3E, // "ŉ" (U+0149)
  0x01, 0x4A, 0x00, 0xFF, 0x05, 0x07, 0x06, 0x12, 0x54, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x12, 0x70, // "ŋ" (U+014B)
  0x01, 0x4C, 0x00, 0x01, 0x05, 0x07, 0x06, 0x12, 0x84, // "Ō" (U+014C)
  0x01, 0x4D, 0x00, 0x01, 0x04, 0x06, 0x05, 0x12, 0x9D, // "ō" (U+014D)
  0x01, 0x4E, 0x00, 0x01, 0x05, 0x08, 0x06, 0x12, 0xAE, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x00, 0x01, 0x04, 0x07, 0x05, 0x12, 0xCA, // "ŏ" (U+014F)
  0x01, 0x50, 0x00, 0x01, 0x05, 0x08, 0x06, 0x12, 0xDE, // "Ő" (U+0150)
  0x01, 0x51, 0x00, 0x01, 0x04, 0x07, 0x05, 0x12, 0xFA, // "ő" (U+0151)
  0x01, 0x52, 0x00, 0x01, 0x07, 0x07, 0x08, 0x13, 0x0D, // "Œ" (U+0152)
  0x01, 0x53, 0x00, 0x01, 0x06, 0x05, 0x07, 0x13, 0x2C, // "œ" (U+0153)
  0x01, 0x54, 0x00, 0x01, 0x05, 0x09, 0x05, 0x13, 0x40, // "Ŕ" (U+0154)
  0x01, 0x55, 0x00, 0x01, 0x03, 0x08, 0x04, 0x13, 0x5D, // "ŕ" (U+0155)
  0x01, 0x56, 0x00, 0xFE, 0x05, 0x07, 0x05, 0x13, 0x6E, // "Ŗ" (U+0156)
  0x01, 0x57, 0x00, 0xFE, 0x03, 0x05, 0x04, 0x13, 0x8B, // "ŗ" (U+0157)
  0x01, 0x58, 0x00, 0x01, 0x05, 0x09, 0x05, 0x13, 0x9C, // "Ř" (U+0158)
  0x01, 0x59, 0x00, 0x01, 0x03, 0x08, 0x04, 0x13, 0xBB, // "ř" (U+0159)
  0x01, 0x5A, 0x00, 0x01, 0x03, 0x09, 0x04, 0x13, 0xCD, // "Ś" (U+015A)
  0x01, 0x5B, 0x00, 0x01, 0x03, 0x08, 0x04, 0x13, 0xE1, // "ś" (U+015B)
  0x01, 0x5C, 0x00, 0x01, 0x03, 0x09, 0x04, 0x13, 0xF1, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x00, 0x01, 0x03, 0x08, 0x04, 0x14, 0x05, // "ŝ" (U+015D)
  0x01, 0x5E, 0x00, 0xFF, 0x03, 0x07, 0x04, 0x14, 0x16, // "Ş" (U+015E)
  0x01, 0x5F, 0x00, 0xFF, 0x03, 0x05, 0x04, 0x14, 0x2B, // "ş" (U+015F)
  0x01, 0x60, 0x00, 0x01, 0x03, 0x09, 0x04, 0x14, 0x3B, // "Š" (U+0160)
  0x01, 0x61, 0x00, 0x01, 0x03, 0x08, 0x04, 0x14, 0x50, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x14, 0x61, // "Ţ" (U+0162)
  0x01, 0x63, 0x00, 0xFF, 0x02, 0x06, 0x03, 0x14, 0x75, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x04, 0x09, 0x05, 0x14, 0x83, // "Ť" (U+0164)
  0x01, 0x65, 0x00, 0x01, 0x02, 0x07, 0x03, 0x14, 0x99, // "ť" (U+0165)
  0x01, 0x66, 0x00, 0x01, 0x04, 0x07, 0x05, 0x14, 0xA5, // "Ŧ" (U+0166)
  0x01, 0x67, 0x00, 0x01, 0x02, 0x06, 0x03, 0x14, 0xB8, // "ŧ" (U+0167)
  0x01, 0x68, 0x00, 0x01, 0x05, 0x08, 0x06, 0x14, 0xC3, // "Ũ" (U+0168)
  0x01, 0x69, 0x00, 0x01, 0x04, 0x07, 0x05, 0x14, 0xDF, // "ũ" (U+0169)
  0x01, 0x6A, 0x00, 0x01, 0x05, 0x07, 0x06, 0x14, 0xF2, // "Ū" (U+016A)
  0x01, 0x6B, 0x00, 0x01, 0x04, 0x06, 0x05, 0x15, 0x0A, // "ū" (U+016B)
  0x01, 0x6C, 0x00, 0x01, 0x05, 0x08, 0x06, 0x15, 0x1B, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x00, 0x01, 0x04, 0x07, 0x05, 0x15, 0x36, // "ŭ" (U+016D)
  0x01, 0x6E, 0x00, 0x01, 0x05, 0x09, 0x06, 0x15, 0x4A, // "Ů" (U+016E)
  0x01, 0x6F, 0x00, 0x01, 0x04, 0x08, 0x05, 0x15, 0x68, // "ů" (U+016F)
  0x01, 0x70, 0x00, 0x01, 0x05, 0x08, 0x06, 0x15, 0x7F, // "Ű" (U+0170)
  0x01, 0x71, 0x00, 0x01, 0x04, 0x07, 0x05, 0x15, 0x9B, // "ű" (U+0171)
  0x01, 0x72, 0x00, 0xFF, 0x05, 0x07, 0x06, 0x15, 0xAE, // "Ų" (U+0172)
  0x01, 0x73, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x15, 0xCA, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x08, 0x09, 0x08, 0x15, 0xDE, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x06, 0x08, 0x07, 0x16, 0x04, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x01, 0x04, 0x09, 0x05, 0x16, 0x1E, // "Ŷ" (U+0176)
  0x01, 0x77, 0x00, 0xFF, 0x04, 0x08, 0x05, 0x16, 0x34, // "ŷ" (U+0177)
  0x01, 0x78, 0x00, 0x01, 0x04, 0x08, 0x05, 0x16, 0x4C, // "Ÿ" (U+0178)
  0x01, 0x79, 0x00, 0x01, 0x04, 0x09, 0x05, 0x16, 0x61, // "Ź" (U+0179)
  0x01, 0x7A, 0x00, 0x01, 0x03, 0x08, 0x04, 0x16, 0x79, // "ź" (U+017A)
  0x01, 0x7B, 0x00, 0x01, 0x04, 0x08, 0x05, 0x16, 0x8A, // "Ż" (U+017B)
  0x01, 0x7C, 0x00, 0x01, 0x03, 0x07, 0x04, 0x16, 0xA1, // "ż" (U+017C)
  0x01, 0x7D, 0x00, 0x01, 0x04, 0x09, 0x05, 0x16, 0xB0, // "Ž" (U+017D)
  0x01, 0x7E, 0x00, 0x01, 0x03, 0x08, 0x04, 0x16, 0xCA, // "ž" (U+017E)
  0x01, 0x7F, 0x00, 0x01, 0x03, 0x07, 0x03, 0x16, 0xDC, // "ſ" (U+017F)
  0x03, 0xA9, 0x00, 0x01, 0x05, 0x07, 0x06, 0x16, 0xEE, // "Ω" (U+03A9)
  0x03, 0xBC, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x17, 0x07, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x01, 0x04, 0x05, 0x05, 0x17, 0x19, // "π" (U+03C0)
  0x20, 0x13, 0x00, 0x03, 0x03, 0x03, 0x04, 0x17, 0x28, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x03, 0x07, 0x03, 0x08, 0x17, 0x2A, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x01, 0x04, 0x07, 0x04, 0x17, 0x2C, // "€" (U+20AC)
  0x20, 0xBF, 0x00, 0x00, 0x04, 0x07, 0x04, 0x17, 0x3E, // "₿" (U+20BF)
  0x20, 0x18, 0x00, 0x05, 0x01, 0x07, 0x02, 0x17, 0x53, // "‘" (U+2018)
  0x20, 0x19, 0x00, 0x05, 0x01, 0x07, 0x02, 0x17, 0x57, // "’" (U+2019)
  0x20, 0x1A, 0x00, 0xFF, 0x01, 0x01, 0x02, 0x17, 0x5B, // "‚" (U+201A)
  0x20, 0x1B, 0x00, 0x05, 0x01, 0x07, 0x02, 0x17, 0x5F, // "‛" (U+201B)
  0x20, 0x1C, 0x00, 0x05, 0x03, 0x07, 0x04, 0x17, 0x63, // "“" (U+201C)
  0x20, 0x1D, 0x00, 0x05, 0x03, 0x07, 0x04, 0x17, 0x6B, // "”" (U+201D)
  0x20, 0x1E, 0x00, 0xFF, 0x03, 0x01, 0x04, 0x17, 0x73, // "„" (U+201E)
  0x20, 0x1F, 0x00, 0x05, 0x03, 0x07, 0x04, 0x17, 0x7B, // "‟" (U+201F)
  0x20, 0x20, 0x00, 0x00, 0x03, 0x07, 0x04, 0x17, 0x83, // "†" (U+2020)
  0x20, 0x21, 0x00, 0x00, 0x03, 0x07, 0x04, 0x17, 0x94, // "‡" (U+2021)
  0x20, 0x22, 0x00, 0x03, 0x02, 0x05, 0x03, 0x17, 0xA7, // "•" (U+2022)
  0x20, 0x26, 0x00, 0x01, 0x06, 0x02, 0x07, 0x17, 0xAD, // "…" (U+2026)
  0x20, 0x30, 0x00, 0x01, 0x09, 0x07, 0x0A, 0x17, 0xB6, // "‰" (U+2030)
  0x20, 0x39, 0x00, 0x02, 0x01, 0x05, 0x03, 0x17, 0xD9, // "‹" (U+2039)
  0x20, 0x3A, 0x00, 0x02, 0x02, 0x05, 0x03, 0x17, 0xDE, // "›" (U+203A)
  0x20, 0x44, 0xFE, 0x01, 0x01, 0x07, 0x01, 0x17, 0xE6, // "⁄" (U+2044)
  0x21, 0x22, 0x00, 0x04, 0x06, 0x06, 0x07, 0x17, 0xF4, // "™" (U+2122)
  0x21, 0x52, 0x00, 0x01, 0x08, 0x07, 0x09, 0x18, 0x00, // "⅒" (U+2152)
  0xFB, 0x01, 0x00, 0x01, 0x05, 0x07, 0x05, 0x18, 0x1D, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0x00, 0x01, 0x05, 0x07, 0x05, 0x18, 0x36, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x01, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0xC0, 0x01, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x01, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x01, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x01, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x01, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x01, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xC6, 0x01, // "Æ (U+0022 U+00C6)
  0x00, 0x22, 0x01, 0x00, 0x01, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x02, 0x01, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x04, 0x01, // "Ą (U+0022 U+0104)
  0x00, 0x27, 0x00, 0x41, 0x01, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0xC0, 0x01, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x01, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x01, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x01, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x01, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x01, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xC6, 0x01, // 'Æ (U+0027 U+00C6)
  0x00, 0x27, 0x01, 0x00, 0x01, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x02, 0x01, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x04, 0x01, // 'Ą (U+0027 U+0104)
  0x00, 0x2A, 0x00, 0x2C, 0x01, // *, (U+002A U+002C)
  0x00, 0x2A, 0x00, 0x2E, 0x01, // *. (U+002A U+002E)
  0x00, 0x2A, 0x00, 0xC6, 0x01, // *Æ (U+002A U+00C6)
  0x00, 0x2A, 0x20, 0x1A, 0x01, // *‚ (U+002A U+201A)
  0x00, 0x2A, 0x20, 0x1E, 0x01, // *„ (U+002A U+201E)
  0x00, 0x2A, 0x20, 0x26, 0x01, // *… (U+002A U+2026)
  0x00, 0x2C, 0x00, 0x3F, 0x01, // ,? (U+002C U+003F)
  0x00, 0x2C, 0x00, 0x54, 0x01, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x56, 0x01, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x01, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x01, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0x76, 0x01, // ,v (U+002C U+0076)
  0x00, 0x2C, 0x00, 0xDD, 0x01, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x01, 0x62, 0x01, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x01, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x01, // ,Ŧ (U+002C U+0166)
  0x00, 0x2C, 0x01, 0x74, 0x01, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x76, 0x01, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x78, 0x01, // ,Ÿ (U+002C U+0178)
  0x00, 0x2E, 0x00, 0x3F, 0x01, // .? (U+002E U+003F)
  0x00, 0x2E, 0x00, 0x54, 0x01, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x56, 0x01, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x01, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x01, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0x76, 0x01, // .v (U+002E U+0076)
  0x00, 0x2E, 0x00, 0xDD, 0x01, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x01, 0x62, 0x01, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x01, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x01, // .Ŧ (U+002E U+0166)
  0x00, 0x2E, 0x01, 0x74, 0x01, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x76, 0x01, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x78, 0x01, // .Ÿ (U+002E U+0178)
  0x00, 0x30, 0x20, 0x44, 0x01, // 0⁄ (U+0030 U+2044)
  0x00, 0x31, 0x20, 0x44, 0x01, // 1⁄ (U+0031 U+2044)
  0x00, 0x32, 0x20, 0x44, 0x01, // 2⁄ (U+0032 U+2044)
  0x00, 0x33, 0x20, 0x44, 0x01, // 3⁄ (U+0033 U+2044)
  0x00, 0x34, 0x20, 0x44, 0x01, // 4⁄ (U+0034 U+2044)
  0x00, 0x35, 0x20, 0x44, 0x01, // 5⁄ (U+0035 U+2044)
  0x00, 0x36, 0x20, 0x44, 0x01, // 6⁄ (U+0036 U+2044)
  0x00, 0x37, 0x20, 0x44, 0x01, // 7⁄ (U+0037 U+2044)
  0x00, 0x38, 0x20, 0x44, 0x01, // 8⁄ (U+0038 U+2044)
  0x00, 0x39, 0x20, 0x44, 0x01, // 9⁄ (U+0039 U+2044)
  0x00, 0x41, 0x00, 0x22, 0x01, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x01, // A' (U+0041 U+0027)
  0x00, 0x41, 0x00, 0x2A, 0x01, // A* (U+0041 U+002A)
  0x00, 0x41, 0x00, 0x56, 0x01, // AV (U+0041 U+0056)
  0x00, 0x41, 0x00, 0x57, 0x01, // AW (U+0041 U+0057)
  0x00, 0x41, 0x00, 0x59, 0x01, // AY (U+0041 U+0059)
  0x00, 0x41, 0x00, 0xDD, 0x01, // AÝ (U+0041 U+00DD)
  0x00, 0x41, 0x01, 0x74, 0x01, // AŴ (U+0041 U+0174)
  0x00, 0x41, 0x01, 0x76, 0x01, // AŶ (U+0041 U+0176)
  0x00, 0x41, 0x01, 0x78, 0x01, // AŸ (U+0041 U+0178)
  0x00, 0x41, 0x20, 0x18, 0x01, // A‘ (U+0041 U+2018)
  0x00, 0x41, 0x20, 0x19, 0x01, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1C, 0x01, // A“ (U+0041 U+201C)
  0x00, 0x41, 0x20, 0x1D, 0x01, // A” (U+0041 U+201D)
  0x00, 0x41, 0x21, 0x22, 0x01, // A™ (U+0041 U+2122)
  0x00, 0x46, 0x00, 0x2C, 0x01, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x01, // F. (U+0046 U+002E)
  0x00, 0x46, 0x00, 0x41, 0x01, // FA (U+0046 U+0041)
  0x00, 0x46, 0x00, 0xC0, 0x01, // FÀ (U+0046 U+00C0)
  0x00, 0x46, 0x00, 0xC1, 0x01, // FÁ (U+0046 U+00C1)
  0x00, 0x46, 0x00, 0xC2, 0x01, // FÂ (U+0046 U+00C2)
  0x00, 0x46, 0x00, 0xC3, 0x01, // FÃ (U+0046 U+00C3)
  0x00, 0x46, 0x00, 0xC4, 0x01, // FÄ (U+0046 U+00C4)
  0x00, 0x46, 0x00, 0xC5, 0x01, // FÅ (U+0046 U+00C5)
  0x00, 0x46, 0x00, 0xC6, 0x01, // FÆ (U+0046 U+00C6)
  0x00, 0x46, 0x01, 0x00, 0x01, // FĀ (U+0046 U+0100)
  0x00, 0x46, 0x01, 0x02, 0x01, // FĂ (U+0046 U+0102)
  0x00, 0x46, 0x01, 0x04, 0x01, // FĄ (U+0046 U+0104)
  0x00, 0x46, 0x20, 0x1A, 0x01, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x01, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x01, // F… (U+0046 U+2026)
  0x00, 0x4C, 0x00, 0x2A, 0x01, // L* (U+004C U+002A)
  0x00, 0x4C, 0x00, 0x3F, 0x01, // L? (U+004C U+003F)
  0x00, 0x4C, 0x00, 0x54, 0x01, // LT (U+004C U+0054)
  0x00, 0x4C, 0x01, 0x62, 0x01, // LŢ (U+004C U+0162)
  0x00, 0x4C, 0x01, 0x64, 0x01, // LŤ (U+004C U+0164)
  0x00, 0x4C, 0x01, 0x66, 0x01, // LŦ (U+004C U+0166)
  0x00, 0x4C, 0x20, 0x18, 0x01, // L‘ (U+004C U+2018)
  0x00, 0x4C, 0x20, 0x19, 0x01, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1C, 0x01, // L“ (U+004C U+201C)
  0x00, 0x4C, 0x20, 0x1D, 0x01, // L” (U+004C U+201D)
  0x00, 0x4C, 0x21, 0x22, 0x01, // L™ (U+004C U+2122)
  0x00, 0x50, 0x00, 0x2C, 0x01, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x01, // P. (U+0050 U+002E)
  0x00, 0x50, 0x00, 0xC6, 0x01, // PÆ (U+0050 U+00C6)
  0x00, 0x50, 0x20, 0x1A, 0x01, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x01, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x01, // P… (U+0050 U+2026)
  0x00, 0x54, 0x00, 0x2C, 0x01, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2E, 0x01, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0xC6, 0x01, // TÆ (U+0054 U+00C6)
  0x00, 0x54, 0x20, 0x1A, 0x01, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x01, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x01, // T… (U+0054 U+2026)
  0x00, 0x56, 0x00, 0x2C, 0x01, // V, (U+0056 U+002C)
  0x00, 0x56, 0x00, 0x2E, 0x01, // V. (U+0056 U+002E)
  0x00, 0x56, 0x00, 0x41, 0x01, // VA (U+0056 U+0041)
  0x00, 0x56, 0x00, 0xC0, 0x01, // VÀ (U+0056 U+00C0)
  0x00, 0x56, 0x00, 0xC1, 0x01, // VÁ (U+0056 U+00C1)
  0x00, 0x56, 0x00, 0xC2, 0x01, // VÂ (U+0056 U+00C2)
  0x00, 0x56, 0x00, 0xC3, 0x01, // VÃ (U+0056 U+00C3)
  0x00, 0x56, 0x00, 0xC4, 0x01, // VÄ (U+0056 U+00C4)
  0x00, 0x56, 0x00, 0xC5, 0x01, // VÅ (U+0056 U+00C5)
  0x00, 0x56, 0x00, 0xC6, 0x01, // VÆ (U+0056 U+00C6)
  0x00, 0x56, 0x01, 0x00, 0x01, // VĀ (U+0056 U+0100)
  0x00, 0x56, 0x01, 0x02, 0x01, // VĂ (U+0056 U+0102)
  0x00, 0x56, 0x01, 0x04, 0x01, // VĄ (U+0056 U+0104)
  0x00, 0x56, 0x20, 0x1A, 0x01, // V‚ (U+0056 U+201A)
  0x00, 0x56, 0x20, 0x1E, 0x01, // V„ (U+0056 U+201E)
  0x00, 0x56, 0x20, 0x26, 0x01, // V… (U+0056 U+2026)
  0x00, 0x57, 0x00, 0x2C, 0x01, // W, (U+0057 U+002C)
  0x00, 0x57, 0x00, 0x2E, 0x01, // W. (U+0057 U+002E)
  0x00, 0x57, 0x00, 0x41, 0x01, // WA (U+0057 U+0041)
  0x00, 0x57, 0x00, 0x61, 0x01, // Wa (U+0057 U+0061)
  0x00, 0x57, 0x00, 0xC0, 0x01, // WÀ (U+0057 U+00C0)
  0x00, 0x57, 0x00, 0xC1, 0x01, // WÁ (U+0057 U+00C1)
  0x00, 0x57, 0x00, 0xC2, 0x01, // WÂ (U+0057 U+00C2)
  0x00, 0x57, 0x00, 0xC3, 0x01, // WÃ (U+0057 U+00C3)
  0x00, 0x57, 0x00, 0xC4, 0x01, // WÄ (U+0057 U+00C4)
  0x00, 0x57, 0x00, 0xC5, 0x01, // WÅ (U+0057 U+00C5)
  0x00, 0x57, 0x00, 0xC6, 0x01, // WÆ (U+0057 U+00C6)
  0x00, 0x57, 0x00, 0xE0, 0x01, // Wà (U+0057 U+00E0)
  0x00, 0x57, 0x00, 0xE1, 0x01, // Wá (U+0057 U+00E1)
  0x00, 0x57, 0x00, 0xE2, 0x01, // Wâ (U+0057 U+00E2)
  0x00, 0x57, 0x00, 0xE3, 0x01, // Wã (U+0057 U+00E3)
  0x00, 0x57, 0x00, 0xE4, 0x01, // Wä (U+0057 U+00E4)
  0x00, 0x57, 0x00, 0xE5, 0x01, // Wå (U+0057 U+00E5)
  0x00, 0x57, 0x00, 0xE6, 0x01, // Wæ (U+0057 U+00E6)
  0x00, 0x57, 0x01, 0x00, 0x01, // WĀ (U+0057 U+0100)
  0x00, 0x57, 0x01, 0x01, 0x01, // Wā (U+0057 U+0101)
  0x00, 0x57, 0x01, 0x02, 0x01, // WĂ (U+0057 U+0102)
  0x00, 0x57, 0x01, 0x03, 0x01, // Wă (U+0057 U+0103)
  0x00, 0x57, 0x01, 0x04, 0x01, // WĄ (U+0057 U+0104)
  0x00, 0x57, 0x01, 0x05, 0x01, // Wą (U+0057 U+0105)
  0x00, 0x57, 0x20, 0x1A, 0x01, // W‚ (U+0057 U+201A)
  0x00, 0x57, 0x20, 0x1E, 0x01, // W„ (U+0057 U+201E)
  0x00, 0x57, 0x20, 0x26, 0x01, // W… (U+0057 U+2026)
  0x00, 0x59, 0x00, 0x2C, 0x01, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x01, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x00, 0x41, 0x01, // YA (U+0059 U+0041)
  0x00, 0x59, 0x00, 0x63, 0x01, // Yc (U+0059 U+0063)
  0x00, 0x59, 0x00, 0x64, 0x01, // Yd (U+0059 U+0064)
  0x00, 0x59, 0x00, 0x65, 0x01, // Ye (U+0059 U+0065)
  0x00, 0x59, 0x00, 0x67, 0x01, // Yg (U+0059 U+0067)
  0x00, 0x59, 0x00, 0x6F, 0x01, // Yo (U+0059 U+006F)
  0x00, 0x59, 0x00, 0x71, 0x01, // Yq (U+0059 U+0071)
  0x00, 0x59, 0x00, 0xC0, 0x01, // YÀ (U+0059 U+00C0)
  0x00, 0x59, 0x00, 0xC1, 0x01, // YÁ (U+0059 U+00C1)
  0x00, 0x59, 0x00, 0xC2, 0x01, // YÂ (U+0059 U+00C2)
  0x00, 0x59, 0x00, 0xC3, 0x01, // YÃ (U+0059 U+00C3)
  0x00, 0x59, 0x00, 0xC4, 0x01, // YÄ (U+0059 U+00C4)
  0x00, 0x59, 0x00, 0xC5, 0x01, // YÅ (U+0059 U+00C5)
  0x00, 0x59, 0x00, 0xC6, 0x01, // YÆ (U+0059 U+00C6)
  0x00, 0x59, 0x00, 0xE7, 0x01, // Yç (U+0059 U+00E7)
  0x00, 0x59, 0x00, 0xE8, 0x01, // Yè (U+0059 U+00E8)
  0x00, 0x59, 0x00, 0xE9, 0x01, // Yé (U+0059 U+00E9)
  0x00, 0x59, 0x00, 0xEA, 0x01, // Yê (U+0059 U+00EA)
  0x00, 0x59, 0x00, 0xEB, 0x01, // Yë (U+0059 U+00EB)
  0x00, 0x59, 0x00, 0xF0, 0x01, // Yð (U+0059 U+00F0)
  0x00, 0x59, 0x00, 0xF2, 0x01, // Yò (U+0059 U+00F2)
  0x00, 0x59, 0x00, 0xF3, 0x01, // Yó (U+0059 U+00F3)
  0x00, 0x59, 0x00, 0xF4, 0x01, // Yô (U+0059 U+00F4)
  0x00, 0x59, 0x00, 0xF5, 0x01, // Yõ (U+0059 U+00F5)
  0x00, 0x59, 0x00, 0xF6, 0x01, // Yö (U+0059 U+00F6)
  0x00, 0x59, 0x00, 0xF8, 0x01, // Yø (U+0059 U+00F8)
  0x00, 0x59, 0x01, 0x00, 0x01, // YĀ (U+0059 U+0100)
  0x00, 0x59, 0x01, 0x02, 0x01, // YĂ (U+0059 U+0102)
  0x00, 0x59, 0x01, 0x04, 0x01, // YĄ (U+0059 U+0104)
  0x00, 0x59, 0x01, 0x07, 0x01, // Yć (U+0059 U+0107)
  0x00, 0x59, 0x01, 0x09, 0x01, // Yĉ (U+0059 U+0109)
  0x00, 0x59, 0x01, 0x0B, 0x01, // Yċ (U+0059 U+010B)
  0x00, 0x59, 0x01, 0x0D, 0x01, // Yč (U+0059 U+010D)
  0x00, 0x59, 0x01, 0x0F, 0x01, // Yď (U+0059 U+010F)
  0x00, 0x59, 0x01, 0x11, 0x01, // Yđ (U+0059 U+0111)
  0x00, 0x59, 0x01, 0x13, 0x01, // Yē (U+0059 U+0113)
  0x00, 0x59, 0x01, 0x15, 0x01, // Yĕ (U+0059 U+0115)
  0x00, 0x59, 0x01, 0x17, 0x01, // Yė (U+0059 U+0117)
  0x00, 0x59, 0x01, 0x19, 0x01, // Yę (U+0059 U+0119)
  0x00, 0x59, 0x01, 0x1B, 0x01, // Yě (U+0059 U+011B)
  0x00, 0x59, 0x01, 0x1D, 0x01, // Yĝ (U+0059 U+011D)
  0x00, 0x59, 0x01, 0x1F, 0x01, // Yğ (U+0059 U+011F)
  0x00, 0x59, 0x01, 0x21, 0x01, // Yġ (U+0059 U+0121)
  0x00, 0x59, 0x01, 0x23, 0x01, // Yģ (U+0059 U+0123)
  0x00, 0x59, 0x01, 0x4D, 0x01, // Yō (U+0059 U+014D)
  0x00, 0x59, 0x01, 0x4F, 0x01, // Yŏ (U+0059 U+014F)
  0x00, 0x59, 0x01, 0x51, 0x01, // Yő (U+0059 U+0151)
  0x00, 0x59, 0x01, 0x53, 0x01, // Yœ (U+0059 U+0153)
  0x00, 0x59, 0x20, 0x1A, 0x01, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x01, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x01, // Y… (U+0059 U+2026)
  0x00, 0x62, 0x00, 0x59, 0x01, // bY (U+0062 U+0059)
  0x00, 0x62, 0x00, 0xDD, 0x01, // bÝ (U+0062 U+00DD)
  0x00, 0x62, 0x01, 0x76, 0x01, // bŶ (U+0062 U+0176)
  0x00, 0x62, 0x01, 0x78, 0x01, // bŸ (U+0062 U+0178)
  0x00, 0x6F, 0x00, 0x59, 0x01, // oY (U+006F U+0059)
  0x00, 0x6F, 0x00, 0xDD, 0x01, // oÝ (U+006F U+00DD)
  0x00, 0x6F, 0x01, 0x76, 0x01, // oŶ (U+006F U+0176)
  0x00, 0x6F, 0x01, 0x78, 0x01, // oŸ (U+006F U+0178)
  0x00, 0x70, 0x00, 0x59, 0x01, // pY (U+0070 U+0059)
  0x00, 0x70, 0x00, 0xDD, 0x01, // pÝ (U+0070 U+00DD)
  0x00, 0x70, 0x01, 0x76, 0x01, // pŶ (U+0070 U+0176)
  0x00, 0x70, 0x01, 0x78, 0x01, // pŸ (U+0070 U+0178)
  0x00, 0x72, 0x00, 0x2C, 0x01, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x01, // r. (U+0072 U+002E)
  0x00, 0x72, 0x20, 0x1A, 0x01, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x01, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x01, // r… (U+0072 U+2026)
  0x00, 0x76, 0x00, 0x2E, 0x01, // v. (U+0076 U+002E)
  0x00, 0x76, 0x20, 0x1A, 0x01, // v‚ (U+0076 U+201A)
  0x00, 0x76, 0x20, 0x1E, 0x01, // v„ (U+0076 U+201E)
  0x00, 0x76, 0x20, 0x26, 0x01, // v… (U+0076 U+2026)
  0x00, 0x77, 0x00, 0x2C, 0x01, // w, (U+0077 U+002C)
  0x00, 0x77, 0x00, 0x2E, 0x01, // w. (U+0077 U+002E)
  0x00, 0x77, 0x20, 0x1A, 0x01, // w‚ (U+0077 U+201A)
  0x00, 0x77, 0x20, 0x1E, 0x01, // w„ (U+0077 U+201E)
  0x00, 0x77, 0x20, 0x26, 0x01, // w… (U+0077 U+2026)
  0x00, 0x79, 0x00, 0x2C, 0x01, // y, (U+0079 U+002C)
  0x00, 0x79, 0x00, 0x2E, 0x01, // y. (U+0079 U+002E)
  0x00, 0x79, 0x20, 0x1A, 0x01, // y‚ (U+0079 U+201A)
  0x00, 0x79, 0x20, 0x1E, 0x01, // y„ (U+0079 U+201E)
  0x00, 0x79, 0x20, 0x26, 0x01, // y… (U+0079 U+2026)
  0x00, 0xC0, 0x00, 0x22, 0x01, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x01, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x00, 0x2A, 0x01, // À* (U+00C0 U+002A)
  0x00, 0xC0, 0x00, 0x56, 0x01, // ÀV (U+00C0 U+0056)
  0x00, 0xC0, 0x00, 0x57, 0x01, // ÀW (U+00C0 U+0057)
  0x00, 0xC0, 0x00, 0x59, 0x01, // ÀY (U+00C0 U+0059)
  0x00, 0xC0, 0x00, 0xDD, 0x01, // ÀÝ (U+00C0 U+00DD)
  0x00, 0xC0, 0x01, 0x74, 0x01, // ÀŴ (U+00C0 U+0174)
  0x00, 0xC0, 0x01, 0x76, 0x01, // ÀŶ (U+00C0 U+0176)
  0x00, 0xC0, 0x01, 0x78, 0x01, // ÀŸ (U+00C0 U+0178)
  0x00, 0xC0, 0x20, 0x18, 0x01, // À‘ (U+00C0 U+2018)
  0x00, 0xC0, 0x20, 0x19, 0x01, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1C, 0x01, // À“ (U+00C0 U+201C)
  0x00, 0xC0, 0x20, 0x1D, 0x01, // À” (U+00C0 U+201D)
  0x00, 0xC0, 0x21, 0x22, 0x01, // À™ (U+00C0 U+2122)
  0x00, 0xC1, 0x00, 0x22, 0x01, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x01, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x00, 0x2A, 0x01, // Á* (U+00C1 U+002A)
  0x00, 0xC1, 0x00, 0x56, 0x01, // ÁV (U+00C1 U+0056)
  0x00, 0xC1, 0x00, 0x57, 0x01, // ÁW (U+00C1 U+0057)
  0x00, 0xC1, 0x00, 0x59, 0x01, // ÁY (U+00C1 U+0059)
  0x00, 0xC1, 0x00, 0xDD, 0x01, // ÁÝ (U+00C1 U+00DD)
  0x00, 0xC1, 0x01, 0x74, 0x01, // ÁŴ (U+00C1 U+0174)
  0x00, 0xC1, 0x01, 0x76, 0x01, // ÁŶ (U+00C1 U+0176)
  0x00, 0xC1, 0x01, 0x78, 0x01, // ÁŸ (U+00C1 U+0178)
  0x00, 0xC1, 0x20, 0x18, 0x01, // Á‘ (U+00C1 U+2018)
  0x00, 0xC1, 0x20, 0x19, 0x01, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1C, 0x01, // Á“ (U+00C1 U+201C)
  0x00, 0xC1, 0x20, 0x1D, 0x01, // Á” (U+00C1 U+201D)
  0x00, 0xC1, 0x21, 0x22, 0x01, // Á™ (U+00C1 U+2122)
  0x00, 0xC2, 0x00, 0x22, 0x01, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x01, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x00, 0x2A, 0x01, // Â* (U+00C2 U+002A)
  0x00, 0xC2, 0x00, 0x56, 0x01, // ÂV (U+00C2 U+0056)
  0x00, 0xC2, 0x00, 0x57, 0x01, // ÂW (U+00C2 U+0057)
  0x00, 0xC2, 0x00, 0x59, 0x01, // ÂY (U+00C2 U+0059)
  0x00, 0xC2, 0x00, 0xDD, 0x01, // ÂÝ (U+00C2 U+00DD)
  0x00, 0xC2, 0x01, 0x74, 0x01, // ÂŴ (U+00C2 U+0174)
  0x00, 0xC2, 0x01, 0x76, 0x01, // ÂŶ (U+00C2 U+0176)
  0x00, 0xC2, 0x01, 0x78, 0x01, // ÂŸ (U+00C2 U+0178)
  0x00, 0xC2, 0x20, 0x18, 0x01, // Â‘ (U+00C2 U+2018)
  0x00, 0xC2, 0x20, 0x19, 0x01, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1C, 0x01, // Â“ (U+00C2 U+201C)
  0x00, 0xC2, 0x20, 0x1D, 0x01, // Â” (U+00C2 U+201D)
  0x00, 0xC2, 0x21, 0x22, 0x01, // Â™ (U+00C2 U+2122)
  0x00, 0xC3, 0x00, 0x22, 0x01, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x01, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x00, 0x2A, 0x01, // Ã* (U+00C3 U+002A)
  0x00, 0xC3, 0x00, 0x56, 0x01, // ÃV (U+00C3 U+0056)
  0x00, 0xC3, 0x00, 0x57, 0x01, // ÃW (U+00C3 U+0057)
  0x00, 0xC3, 0x00, 0x59, 0x01, // ÃY (U+00C3 U+0059)
  0x00, 0xC3, 0x00, 0xDD, 0x01, // ÃÝ (U+00C3 U+00DD)
  0x00, 0xC3, 0x01, 0x74, 0x01, // ÃŴ (U+00C3 U+0174)
  0x00, 0xC3, 0x01, 0x76, 0x01, // ÃŶ (U+00C3 U+0176)
  0x00, 0xC3, 0x01, 0x78, 0x01, // ÃŸ (U+00C3 U+0178)
  0x00, 0xC3, 0x20, 0x18, 0x01, // Ã‘ (U+00C3 U+2018)
  0x00, 0xC3, 0x20, 0x19, 0x01, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1C, 0x01, // Ã“ (U+00C3 U+201C)
  0x00, 0xC3, 0x20, 0x1D, 0x01, // Ã” (U+00C3 U+201D)
  0x00, 0xC3, 0x21, 0x22, 0x01, // Ã™ (U+00C3 U+2122)
  0x00, 0xC4, 0x00, 0x22, 0x01, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x01, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x00, 0x2A, 0x01, // Ä* (U+00C4 U+002A)
  0x00, 0xC4, 0x00, 0x56, 0x01, // ÄV (U+00C4 U+0056)
  0x00, 0xC4, 0x00, 0x57, 0x01, // ÄW (U+00C4 U+0057)
  0x00, 0xC4, 0x00, 0x59, 0x01, // ÄY (U+00C4 U+0059)
  0x00, 0xC4, 0x00, 0xDD, 0x01, // ÄÝ (U+00C4 U+00DD)
  0x00, 0xC4, 0x01, 0x74, 0x01, // ÄŴ (U+00C4 U+0174)
  0x00, 0xC4, 0x01, 0x76, 0x01, // ÄŶ (U+00C4 U+0176)
  0x00, 0xC4, 0x01, 0x78, 0x01, // ÄŸ (U+00C4 U+0178)
  0x00, 0xC4, 0x20, 0x18, 0x01, // Ä‘ (U+00C4 U+2018)
  0x00, 0xC4, 0x20, 0x19, 0x01, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1C, 0x01, // Ä“ (U+00C4 U+201C)
  0x00, 0xC4, 0x20, 0x1D, 0x01, // Ä” (U+00C4 U+201D)
  0x00, 0xC4, 0x21, 0x22, 0x01, // Ä™ (U+00C4 U+2122)
  0x00, 0xC5, 0x00, 0x22, 0x01, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x01, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x00, 0x2A, 0x01, // Å* (U+00C5 U+002A)
  0x00, 0xC5, 0x00, 0x56, 0x01, // ÅV (U+00C5 U+0056)
  0x00, 0xC5, 0x00, 0x57, 0x01, // ÅW (U+00C5 U+0057)
  0x00, 0xC5, 0x00, 0x59, 0x01, // ÅY (U+00C5 U+0059)
  0x00, 0xC5, 0x00, 0xDD, 0x01, // ÅÝ (U+00C5 U+00DD)
  0x00, 0xC5, 0x01, 0x74, 0x01, // ÅŴ (U+00C5 U+0174)
  0x00, 0xC5, 0x01, 0x76, 0x01, // ÅŶ (U+00C5 U+0176)
  0x00, 0xC5, 0x01, 0x78, 0x01, // ÅŸ (U+00C5 U+0178)
  0x00, 0xC5, 0x20, 0x18, 0x01, // Å‘ (U+00C5 U+2018)
  0x00, 0xC5, 0x20, 0x19, 0x01, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1C, 0x01, // Å“ (U+00C5 U+201C)
  0x00, 0xC5, 0x20, 0x1D, 0x01, // Å” (U+00C5 U+201D)
  0x00, 0xC5, 0x21, 0x22, 0x01, // Å™ (U+00C5 U+2122)
  0x00, 0xDD, 0x00, 0x2C, 0x01, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x01, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x00, 0x41, 0x01, // ÝA (U+00DD U+0041)
  0x00, 0xDD, 0x00, 0x63, 0x01, // Ýc (U+00DD U+0063)
  0x00, 0xDD, 0x00, 0x64, 0x01, // Ýd (U+00DD U+0064)
  0x00, 0xDD, 0x00, 0x65, 0x01, // Ýe (U+00DD U+0065)
  0x00, 0xDD, 0x00, 0x67, 0x01, // Ýg (U+00DD U+0067)
  0x00, 0xDD, 0x00, 0x6F, 0x01, // Ýo (U+00DD U+006F)
  0x00, 0xDD, 0x00, 0x71, 0x01, // Ýq (U+00DD U+0071)
  0x00, 0xDD, 0x00, 0xC0, 0x01, // ÝÀ (U+00DD U+00C0)
  0x00, 0xDD, 0x00, 0xC1, 0x01, // ÝÁ (U+00DD U+00C1)
  0x00, 0xDD, 0x00, 0xC2, 0x01, // ÝÂ (U+00DD U+00C2)
  0x00, 0xDD, 0x00, 0xC3, 0x01, // ÝÃ (U+00DD U+00C3)
  0x00, 0xDD, 0x00, 0xC4, 0x01, // ÝÄ (U+00DD U+00C4)
  0x00, 0xDD, 0x00, 0xC5, 0x01, // ÝÅ (U+00DD U+00C5)
  0x00, 0xDD, 0x00, 0xC6, 0x01, // ÝÆ (U+00DD U+00C6)
  0x00, 0xDD, 0x00, 0xE7, 0x01, // Ýç (U+00DD U+00E7)
  0x00, 0xDD, 0x00, 0xE8, 0x01, // Ýè (U+00DD U+00E8)
  0x00, 0xDD, 0x00, 0xE9, 0x01, // Ýé (U+00DD U+00E9)
  0x00, 0xDD, 0x00, 0xEA, 0x01, // Ýê (U+00DD U+00EA)
  0x00, 0xDD, 0x00, 0xEB, 0x01, // Ýë (U+00DD U+00EB)
  0x00, 0xDD, 0x00, 0xF0, 0x01, // Ýð (U+00DD U+00F0)
  0x00, 0xDD, 0x00, 0xF2, 0x01, // Ýò (U+00DD U+00F2)
  0x00, 0xDD, 0x00, 0xF3, 0x01, // Ýó (U+00DD U+00F3)
  0x00, 0xDD, 0x00, 0xF4, 0x01, // Ýô (U+00DD U+00F4)
  0x00, 0xDD, 0x00, 0xF5, 0x01, // Ýõ (U+00DD U+00F5)
  0x00, 0xDD, 0x00, 0xF6, 0x01, // Ýö (U+00DD U+00F6)
  0x00, 0xDD, 0x00, 0xF8, 0x01, // Ýø (U+00DD U+00F8)
  0x00, 0xDD, 0x01, 0x00, 0x01, // ÝĀ (U+00DD U+0100)
  0x00, 0xDD, 0x01, 0x02, 0x01, // ÝĂ (U+00DD U+0102)
  0x00, 0xDD, 0x01, 0x04, 0x01, // ÝĄ (U+00DD U+0104)
  0x00, 0xDD, 0x01, 0x07, 0x01, // Ýć (U+00DD U+0107)
  0x00, 0xDD, 0x01, 0x09, 0x01, // Ýĉ (U+00DD U+0109)
  0x00, 0xDD, 0x01, 0x0B, 0x01, // Ýċ (U+00DD U+010B)
  0x00, 0xDD, 0x01, 0x0D, 0x01, // Ýč (U+00DD U+010D)
  0x00, 0xDD, 0x01, 0x0F, 0x01, // Ýď (U+00DD U+010F)
  0x00, 0xDD, 0x01, 0x11, 0x01, // Ýđ (U+00DD U+0111)
  0x00, 0xDD, 0x01, 0x13, 0x01, // Ýē (U+00DD U+0113)
  0x00, 0xDD, 0x01, 0x15, 0x01, // Ýĕ (U+00DD U+0115)
  0x00, 0xDD, 0x01, 0x17, 0x01, // Ýė (U+00DD U+0117)
  0x00, 0xDD, 0x01, 0x19, 0x01, // Ýę (U+00DD U+0119)
  0x00, 0xDD, 0x01, 0x1B, 0x01, // Ýě (U+00DD U+011B)
  0x00, 0xDD, 0x01, 0x1D, 0x01, // Ýĝ (U+00DD U+011D)
  0x00, 0xDD, 0x01, 0x1F, 0x01, // Ýğ (U+00DD U+011F)
  0x00, 0xDD, 0x01, 0x21, 0x01, // Ýġ (U+00DD U+0121)
  0x00, 0xDD, 0x01, 0x23, 0x01, // Ýģ (U+00DD U+0123)
  0x00, 0xDD, 0x01, 0x4D, 0x01, // Ýō (U+00DD U+014D)
  0x00, 0xDD, 0x01, 0x4F, 0x01, // Ýŏ (U+00DD U+014F)
  0x00, 0xDD, 0x01, 0x51, 0x01, // Ýő (U+00DD U+0151)
  0x00, 0xDD, 0x01, 0x53, 0x01, // Ýœ (U+00DD U+0153)
  0x00, 0xDD, 0x20, 0x1A, 0x01, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x01, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x01, // Ý… (U+00DD U+2026)
  0x00, 0xDF, 0x00, 0x59, 0x01, // ßY (U+00DF U+0059)
  0x00, 0xDF, 0x00, 0xDD, 0x01, // ßÝ (U+00DF U+00DD)
  0x00, 0xDF, 0x01, 0x76, 0x01, // ßŶ (U+00DF U+0176)
  0x00, 0xDF, 0x01, 0x78, 0x01, // ßŸ (U+00DF U+0178)
  0x00, 0xF0, 0x00, 0x59, 0x01, // ðY (U+00F0 U+0059)
  0x00, 0xF0, 0x00, 0xDD, 0x01, // ðÝ (U+00F0 U+00DD)
  0x00, 0xF0, 0x01, 0x76, 0x01, // ðŶ (U+00F0 U+0176)
  0x00, 0xF0, 0x01, 0x78, 0x01, // ðŸ (U+00F0 U+0178)
  0x00, 0xF2, 0x00, 0x59, 0x01, // òY (U+00F2 U+0059)
  0x00, 0xF2, 0x00, 0xDD, 0x01, // òÝ (U+00F2 U+00DD)
  0x00, 0xF2, 0x01, 0x76, 0x01, // òŶ (U+00F2 U+0176)
  0x00, 0xF2, 0x01, 0x78, 0x01, // òŸ (U+00F2 U+0178)
  0x00, 0xF3, 0x00, 0x59, 0x01, // óY (U+00F3 U+0059)
  0x00, 0xF3, 0x00, 0xDD, 0x01, // óÝ (U+00F3 U+00DD)
  0x00, 0xF3, 0x01, 0x76, 0x01, // óŶ (U+00F3 U+0176)
  0x00, 0xF3, 0x01, 0x78, 0x01, // óŸ (U+00F3 U+0178)
  0x00, 0xF4, 0x00, 0x59, 0x01, // ôY (U+00F4 U+0059)
  0x00, 0xF4, 0x00, 0xDD, 0x01, // ôÝ (U+00F4 U+00DD)
  0x00, 0xF4, 0x01, 0x76, 0x01, // ôŶ (U+00F4 U+0176)
  0x00, 0xF4, 0x01, 0x78, 0x01, // ôŸ (U+00F4 U+0178)
  0x00, 0xF5, 0x00, 0x59, 0x01, // õY (U+00F5 U+0059)
  0x00, 0xF5, 0x00, 0xDD, 0x01, // õÝ (U+00F5 U+00DD)
  0x00, 0xF5, 0x01, 0x76, 0x01, // õŶ (U+00F5 U+0176)
  0x00, 0xF5, 0x01, 0x78, 0x01, // õŸ (U+00F5 U+0178)
  0x00, 0xF6, 0x00, 0x59, 0x01, // öY (U+00F6 U+0059)
  0x00, 0xF6, 0x00, 0xDD, 0x01, // öÝ (U+00F6 U+00DD)
  0x00, 0xF6, 0x01, 0x76, 0x01, // öŶ (U+00F6 U+0176)
  0x00, 0xF6, 0x01, 0x78, 0x01, // öŸ (U+00F6 U+0178)
  0x00, 0xF8, 0x00, 0x59, 0x01, // øY (U+00F8 U+0059)
  0x00, 0xF8, 0x00, 0xDD, 0x01, // øÝ (U+00F8 U+00DD)
  0x00, 0xF8, 0x01, 0x76, 0x01, // øŶ (U+00F8 U+0176)
  0x00, 0xF8, 0x01, 0x78, 0x01, // øŸ (U+00F8 U+0178)
  0x00, 0xFD, 0x00, 0x2C, 0x01, // ý, (U+00FD U+002C)
  0x00, 0xFD, 0x00, 0x2E, 0x01, // ý. (U+00FD U+002E)
  0x00, 0xFD, 0x20, 0x1A, 0x01, // ý‚ (U+00FD U+201A)
  0x00, 0xFD, 0x20, 0x1E, 0x01, // ý„ (U+00FD U+201E)
  0x00, 0xFD, 0x20, 0x26, 0x01, // ý… (U+00FD U+2026)
  0x00, 0xFE, 0x00, 0x59, 0x01, // þY (U+00FE U+0059)
  0x00, 0xFE, 0x00, 0xDD, 0x01, // þÝ (U+00FE U+00DD)
  0x00, 0xFE, 0x01, 0x76, 0x01, // þŶ (U+00FE U+0176)
  0x00, 0xFE, 0x01, 0x78, 0x01, // þŸ (U+00FE U+0178)
  0x00, 0xFF, 0x00, 0x2C, 0x01, // ÿ, (U+00FF U+002C)
  0x00, 0xFF, 0x00, 0x2E, 0x01, // ÿ. (U+00FF U+002E)
  0x00, 0xFF, 0x20, 0x1A, 0x01, // ÿ‚ (U+00FF U+201A)
  0x00, 0xFF, 0x20, 0x1E, 0x01, // ÿ„ (U+00FF U+201E)
  0x00, 0xFF, 0x20, 0x26, 0x01, // ÿ… (U+00FF U+2026)
  0x01, 0x00, 0x00, 0x22, 0x01, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x01, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x00, 0x2A, 0x01, // Ā* (U+0100 U+002A)
  0x01, 0x00, 0x00, 0x56, 0x01, // ĀV (U+0100 U+0056)
  0x01, 0x00, 0x00, 0x57, 0x01, // ĀW (U+0100 U+0057)
  0x01, 0x00, 0x00, 0x59, 0x01, // ĀY (U+0100 U+0059)
  0x01, 0x00, 0x00, 0xDD, 0x01, // ĀÝ (U+0100 U+00DD)
  0x01, 0x00, 0x01, 0x74, 0x01, // ĀŴ (U+0100 U+0174)
  0x01, 0x00, 0x01, 0x76, 0x01, // ĀŶ (U+0100 U+0176)
  0x01, 0x00, 0x01, 0x78, 0x01, // ĀŸ (U+0100 U+0178)
  0x01, 0x00, 0x20, 0x18, 0x01, // Ā‘ (U+0100 U+2018)
  0x01, 0x00, 0x20, 0x19, 0x01, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1C, 0x01, // Ā“ (U+0100 U+201C)
  0x01, 0x00, 0x20, 0x1D, 0x01, // Ā” (U+0100 U+201D)
  0x01, 0x00, 0x21, 0x22, 0x01, // Ā™ (U+0100 U+2122)
  0x01, 0x02, 0x00, 0x22, 0x01, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x01, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x00, 0x2A, 0x01, // Ă* (U+0102 U+002A)
  0x01, 0x02, 0x00, 0x56, 0x01, // ĂV (U+0102 U+0056)
  0x01, 0x02, 0x00, 0x57, 0x01, // ĂW (U+0102 U+0057)
  0x01, 0x02, 0x00, 0x59, 0x01, // ĂY (U+0102 U+0059)
  0x01, 0x02, 0x00, 0xDD, 0x01, // ĂÝ (U+0102 U+00DD)
  0x01, 0x02, 0x01, 0x74, 0x01, // ĂŴ (U+0102 U+0174)
  0x01, 0x02, 0x01, 0x76, 0x01, // ĂŶ (U+0102 U+0176)
  0x01, 0x02, 0x01, 0x78, 0x01, // ĂŸ (U+0102 U+0178)
  0x01, 0x02, 0x20, 0x18, 0x01, // Ă‘ (U+0102 U+2018)
  0x01, 0x02, 0x20, 0x19, 0x01, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1C, 0x01, // Ă“ (U+0102 U+201C)
  0x01, 0x02, 0x20, 0x1D, 0x01, // Ă” (U+0102 U+201D)
  0x01, 0x02, 0x21, 0x22, 0x01, // Ă™ (U+0102 U+2122)
  0x01, 0x04, 0x00, 0x22, 0x01, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x01, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x00, 0x2A, 0x01, // Ą* (U+0104 U+002A)
  0x01, 0x04, 0x00, 0x56, 0x01, // ĄV (U+0104 U+0056)
  0x01, 0x04, 0x00, 0x57, 0x01, // ĄW (U+0104 U+0057)
  0x01, 0x04, 0x00, 0x59, 0x01, // ĄY (U+0104 U+0059)
  0x01, 0x04, 0x00, 0xDD, 0x01, // ĄÝ (U+0104 U+00DD)
  0x01, 0x04, 0x01, 0x74, 0x01, // ĄŴ (U+0104 U+0174)
  0x01, 0x04, 0x01, 0x76, 0x01, // ĄŶ (U+0104 U+0176)
  0x01, 0x04, 0x01, 0x78, 0x01, // ĄŸ (U+0104 U+0178)
  0x01, 0x04, 0x20, 0x18, 0x01, // Ą‘ (U+0104 U+2018)
  0x01, 0x04, 0x20, 0x19, 0x01, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1C, 0x01, // Ą“ (U+0104 U+201C)
  0x01, 0x04, 0x20, 0x1D, 0x01, // Ą” (U+0104 U+201D)
  0x01, 0x04, 0x21, 0x22, 0x01, // Ą™ (U+0104 U+2122)
  0x01, 0x39, 0x00, 0x2A, 0x01, // Ĺ* (U+0139 U+002A)
  0x01, 0x39, 0x00, 0x3F, 0x01, // Ĺ? (U+0139 U+003F)
  0x01, 0x39, 0x00, 0x54, 0x01, // ĹT (U+0139 U+0054)
  0x01, 0x39, 0x01, 0x62, 0x01, // ĹŢ (U+0139 U+0162)
  0x01, 0x39, 0x01, 0x64, 0x01, // ĹŤ (U+0139 U+0164)
  0x01, 0x39, 0x01, 0x66, 0x01, // ĹŦ (U+0139 U+0166)
  0x01, 0x39, 0x20, 0x18, 0x01, // Ĺ‘ (U+0139 U+2018)
  0x01, 0x39, 0x20, 0x19, 0x01, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1C, 0x01, // Ĺ“ (U+0139 U+201C)
  0x01, 0x39, 0x20, 0x1D, 0x01, // Ĺ” (U+0139 U+201D)
  0x01, 0x39, 0x21, 0x22, 0x01, // Ĺ™ (U+0139 U+2122)
  0x01, 0x3B, 0x00, 0x2A, 0x01, // Ļ* (U+013B U+002A)
  0x01, 0x3B, 0x00, 0x3F, 0x01, // Ļ? (U+013B U+003F)
  0x01, 0x3B, 0x00, 0x54, 0x01, // ĻT (U+013B U+0054)
  0x01, 0x3B, 0x01, 0x62, 0x01, // ĻŢ (U+013B U+0162)
  0x01, 0x3B, 0x01, 0x64, 0x01, // ĻŤ (U+013B U+0164)
  0x01, 0x3B, 0x01, 0x66, 0x01, // ĻŦ (U+013B U+0166)
  0x01, 0x3B, 0x20, 0x18, 0x01, // Ļ‘ (U+013B U+2018)
  0x01, 0x3B, 0x20, 0x19, 0x01, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1C, 0x01, // Ļ“ (U+013B U+201C)
  0x01, 0x3B, 0x20, 0x1D, 0x01, // Ļ” (U+013B U+201D)
  0x01, 0x3B, 0x21, 0x22, 0x01, // Ļ™ (U+013B U+2122)
  0x01, 0x41, 0x00, 0x2A, 0x01, // Ł* (U+0141 U+002A)
  0x01, 0x41, 0x00, 0x3F, 0x01, // Ł? (U+0141 U+003F)
  0x01, 0x41, 0x00, 0x54, 0x01, // ŁT (U+0141 U+0054)
  0x01, 0x41, 0x01, 0x62, 0x01, // ŁŢ (U+0141 U+0162)
  0x01, 0x41, 0x01, 0x64, 0x01, // ŁŤ (U+0141 U+0164)
  0x01, 0x41, 0x01, 0x66, 0x01, // ŁŦ (U+0141 U+0166)
  0x01, 0x41, 0x20, 0x18, 0x01, // Ł‘ (U+0141 U+2018)
  0x01, 0x41, 0x20, 0x19, 0x01, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1C, 0x01, // Ł“ (U+0141 U+201C)
  0x01, 0x41, 0x20, 0x1D, 0x01, // Ł” (U+0141 U+201D)
  0x01, 0x41, 0x21, 0x22, 0x01, // Ł™ (U+0141 U+2122)
  0x01, 0x4D, 0x00, 0x59, 0x01, // ōY (U+014D U+0059)
  0x01, 0x4D, 0x00, 0xDD, 0x01, // ōÝ (U+014D U+00DD)
  0x01, 0x4D, 0x01, 0x76, 0x01, // ōŶ (U+014D U+0176)
  0x01, 0x4D, 0x01, 0x78, 0x01, // ōŸ (U+014D U+0178)
  0x01, 0x4F, 0x00, 0x59, 0x01, // ŏY (U+014F U+0059)
  0x01, 0x4F, 0x00, 0xDD, 0x01, // ŏÝ (U+014F U+00DD)
  0x01, 0x4F, 0x01, 0x76, 0x01, // ŏŶ (U+014F U+0176)
  0x01, 0x4F, 0x01, 0x78, 0x01, // ŏŸ (U+014F U+0178)
  0x01, 0x51, 0x00, 0x59, 0x01, // őY (U+0151 U+0059)
  0x01, 0x51, 0x00, 0xDD, 0x01, // őÝ (U+0151 U+00DD)
  0x01, 0x51, 0x01, 0x76, 0x01, // őŶ (U+0151 U+0176)
  0x01, 0x51, 0x01, 0x78, 0x01, // őŸ (U+0151 U+0178)
  0x01, 0x55, 0x00, 0x2C, 0x01, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x01, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x20, 0x1A, 0x01, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x01, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x01, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x01, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x01, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x20, 0x1A, 0x01, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x01, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x01, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x01, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x01, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x20, 0x1A, 0x01, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x01, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x01, // ř… (U+0159 U+2026)
  0x01, 0x62, 0x00, 0x2C, 0x01, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2E, 0x01, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0xC6, 0x01, // ŢÆ (U+0162 U+00C6)
  0x01, 0x62, 0x20, 0x1A, 0x01, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x01, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x01, // Ţ… (U+0162 U+2026)
  0x01, 0x64, 0x00, 0x2C, 0x01, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2E, 0x01, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0xC6, 0x01, // ŤÆ (U+0164 U+00C6)
  0x01, 0x64, 0x20, 0x1A, 0x01, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x01, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x01, // Ť… (U+0164 U+2026)
  0x01, 0x66, 0x00, 0x2C, 0x01, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2E, 0x01, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0xC6, 0x01, // ŦÆ (U+0166 U+00C6)
  0x01, 0x66, 0x20, 0x1A, 0x01, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x01, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x01, // Ŧ… (U+0166 U+2026)
  0x01, 0x74, 0x00, 0x2C, 0x01, // Ŵ, (U+0174 U+002C)
  0x01, 0x74, 0x00, 0x2E, 0x01, // Ŵ. (U+0174 U+002E)
  0x01, 0x74, 0x00, 0x41, 0x01, // ŴA (U+0174 U+0041)
  0x01, 0x74, 0x00, 0x61, 0x01, // Ŵa (U+0174 U+0061)
  0x01, 0x74, 0x00, 0xC0, 0x01, // ŴÀ (U+0174 U+00C0)
  0x01, 0x74, 0x00, 0xC1, 0x01, // ŴÁ (U+0174 U+00C1)
  0x01, 0x74, 0x00, 0xC2, 0x01, // ŴÂ (U+0174 U+00C2)
  0x01, 0x74, 0x00, 0xC3, 0x01, // ŴÃ (U+0174 U+00C3)
  0x01, 0x74, 0x00, 0xC4, 0x01, // ŴÄ (U+0174 U+00C4)
  0x01, 0x74, 0x00, 0xC5, 0x01, // ŴÅ (U+0174 U+00C5)
  0x01, 0x74, 0x00, 0xC6, 0x01, // ŴÆ (U+0174 U+00C6)
  0x01, 0x74, 0x00, 0xE0, 0x01, // Ŵà (U+0174 U+00E0)
  0x01, 0x74, 0x00, 0xE1, 0x01, // Ŵá (U+0174 U+00E1)
  0x01, 0x74, 0x00, 0xE2, 0x01, // Ŵâ (U+0174 U+00E2)
  0x01, 0x74, 0x00, 0xE3, 0x01, // Ŵã (U+0174 U+00E3)
  0x01, 0x74, 0x00, 0xE4, 0x01, // Ŵä (U+0174 U+00E4)
  0x01, 0x74, 0x00, 0xE5, 0x01, // Ŵå (U+0174 U+00E5)
  0x01, 0x74, 0x00, 0xE6, 0x01, // Ŵæ (U+0174 U+00E6)
  0x01, 0x74, 0x01, 0x00, 0x01, // ŴĀ (U+0174 U+0100)
  0x01, 0x74, 0x01, 0x01, 0x01, // Ŵā (U+0174 U+0101)
  0x01, 0x74, 0x01, 0x02, 0x01, // ŴĂ (U+0174 U+0102)
  0x01, 0x74, 0x01, 0x03, 0x01, // Ŵă (U+0174 U+0103)
  0x01, 0x74, 0x01, 0x04, 0x01, // ŴĄ (U+0174 U+0104)
  0x01, 0x74, 0x01, 0x05, 0x01, // Ŵą (U+0174 U+0105)
  0x01, 0x74, 0x20, 0x1A, 0x01, // Ŵ‚ (U+0174 U+201A)
  0x01, 0x74, 0x20, 0x1E, 0x01, // Ŵ„ (U+0174 U+201E)
  0x01, 0x74, 0x20, 0x26, 0x01, // Ŵ… (U+0174 U+2026)
  0x01, 0x75, 0x00, 0x2C, 0x01, // ŵ, (U+0175 U+002C)
  0x01, 0x75, 0x00, 0x2E, 0x01, // ŵ. (U+0175 U+002E)
  0x01, 0x75, 0x20, 0x1A, 0x01, // ŵ‚ (U+0175 U+201A)
  0x01, 0x75, 0x20, 0x1E, 0x01, // ŵ„ (U+0175 U+201E)
  0x01, 0x75, 0x20, 0x26, 0x01, // ŵ… (U+0175 U+2026)
  0x01, 0x76, 0x00, 0x2C, 0x01, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x01, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x00, 0x41, 0x01, // ŶA (U+0176 U+0041)
  0x01, 0x76, 0x00, 0x63, 0x01, // Ŷc (U+0176 U+0063)
  0x01, 0x76, 0x00, 0x64, 0x01, // Ŷd (U+0176 U+0064)
  0x01, 0x76, 0x00, 0x65, 0x01, // Ŷe (U+0176 U+0065)
  0x01, 0x76, 0x00, 0x67, 0x01, // Ŷg (U+0176 U+0067)
  0x01, 0x76, 0x00, 0x6F, 0x01, // Ŷo (U+0176 U+006F)
  0x01, 0x76, 0x00, 0x71, 0x01, // Ŷq (U+0176 U+0071)
  0x01, 0x76, 0x00, 0xC0, 0x01, // ŶÀ (U+0176 U+00C0)
  0x01, 0x76, 0x00, 0xC1, 0x01, // ŶÁ (U+0176 U+00C1)
  0x01, 0x76, 0x00, 0xC2, 0x01, // ŶÂ (U+0176 U+00C2)
  0x01, 0x76, 0x00, 0xC3, 0x01, // ŶÃ (U+0176 U+00C3)
  0x01, 0x76, 0x00, 0xC4, 0x01, // ŶÄ (U+0176 U+00C4)
  0x01, 0x76, 0x00, 0xC5, 0x01, // ŶÅ (U+0176 U+00C5)
  0x01, 0x76, 0x00, 0xC6, 0x01, // ŶÆ (U+0176 U+00C6)
  0x01, 0x76, 0x00, 0xE7, 0x01, // Ŷç (U+0176 U+00E7)
  0x01, 0x76, 0x00, 0xE8, 0x01, // Ŷè (U+0176 U+00E8)
  0x01, 0x76, 0x00, 0xE9, 0x01, // Ŷé (U+0176 U+00E9)
  0x01, 0x76, 0x00, 0xEA, 0x01, // Ŷê (U+0176 U+00EA)
  0x01, 0x76, 0x00, 0xEB, 0x01, // Ŷë (U+0176 U+00EB)
  0x01, 0x76, 0x00, 0xF0, 0x01, // Ŷð (U+0176 U+00F0)
  0x01, 0x76, 0x00, 0xF2, 0x01, // Ŷò (U+0176 U+00F2)
  0x01, 0x76, 0x00, 0xF3, 0x01, // Ŷó (U+0176 U+00F3)
  0x01, 0x76, 0x00, 0xF4, 0x01, // Ŷô (U+0176 U+00F4)
  0x01, 0x76, 0x00, 0xF5, 0x01, // Ŷõ (U+0176 U+00F5)
  0x01, 0x76, 0x00, 0xF6, 0x01, // Ŷö (U+0176 U+00F6)
  0x01, 0x76, 0x00, 0xF8, 0x01, // Ŷø (U+0176 U+00F8)
  0x01, 0x76, 0x01, 0x00, 0x01, // ŶĀ (U+0176 U+0100)
  0x01, 0x76, 0x01, 0x02, 0x01, // ŶĂ (U+0176 U+0102)
  0x01, 0x76, 0x01, 0x04, 0x01, // ŶĄ (U+0176 U+0104)
  0x01, 0x76, 0x01, 0x07, 0x01, // Ŷć (U+0176 U+0107)
  0x01, 0x76, 0x01, 0x09, 0x01, // Ŷĉ (U+0176 U+0109)
  0x01, 0x76, 0x01, 0x0B, 0x01, // Ŷċ (U+0176 U+010B)
  0x01, 0x76, 0x01, 0x0D, 0x01, // Ŷč (U+0176 U+010D)
  0x01, 0x76, 0x01, 0x0F, 0x01, // Ŷď (U+0176 U+010F)
  0x01, 0x76, 0x01, 0x11, 0x01, // Ŷđ (U+0176 U+0111)
  0x01, 0x76, 0x01, 0x13, 0x01, // Ŷē (U+0176 U+0113)
  0x01, 0x76, 0x01, 0x15, 0x01, // Ŷĕ (U+0176 U+0115)
  0x01, 0x76, 0x01, 0x17, 0x01, // Ŷė (U+0176 U+0117)
  0x01, 0x76, 0x01, 0x19, 0x01, // Ŷę (U+0176 U+0119)
  0x01, 0x76, 0x01, 0x1B, 0x01, // Ŷě (U+0176 U+011B)
  0x01, 0x76, 0x01, 0x1D, 0x01, // Ŷĝ (U+0176 U+011D)
  0x01, 0x76, 0x01, 0x1F, 0x01, // Ŷğ (U+0176 U+011F)
  0x01, 0x76, 0x01, 0x21, 0x01, // Ŷġ (U+0176 U+0121)
  0x01, 0x76, 0x01, 0x23, 0x01, // Ŷģ (U+0176 U+0123)
  0x01, 0x76, 0x01, 0x4D, 0x01, // Ŷō (U+0176 U+014D)
  0x01, 0x76, 0x01, 0x4F, 0x01, // Ŷŏ (U+0176 U+014F)
  0x01, 0x76, 0x01, 0x51, 0x01, // Ŷő (U+0176 U+0151)
  0x01, 0x76, 0x01, 0x53, 0x01, // Ŷœ (U+0176 U+0153)
  0x01, 0x76, 0x20, 0x1A, 0x01, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x01, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x01, // Ŷ… (U+0176 U+2026)
  0x01, 0x77, 0x00, 0x2C, 0x01, // ŷ, (U+0177 U+002C)
  0x01, 0x77, 0x00, 0x2E, 0x01, // ŷ. (U+0177 U+002E)
  0x01, 0x77, 0x20, 0x1A, 0x01, // ŷ‚ (U+0177 U+201A)
  0x01, 0x77, 0x20, 0x1E, 0x01, // ŷ„ (U+0177 U+201E)
  0x01, 0x77, 0x20, 0x26, 0x01, // ŷ… (U+0177 U+2026)
  0x01, 0x78, 0x00, 0x2C, 0x01, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x01, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x00, 0x41, 0x01, // ŸA (U+0178 U+0041)
  0x01, 0x78, 0x00, 0x63, 0x01, // Ÿc (U+0178 U+0063)
  0x01, 0x78, 0x00, 0x64, 0x01, // Ÿd (U+0178 U+0064)
  0x01, 0x78, 0x00, 0x65, 0x01, // Ÿe (U+0178 U+0065)
  0x01, 0x78, 0x00, 0x67, 0x01, // Ÿg (U+0178 U+0067)
  0x01, 0x78, 0x00, 0x6F, 0x01, // Ÿo (U+0178 U+006F)
  0x01, 0x78, 0x00, 0x71, 0x01, // Ÿq (U+0178 U+0071)
  0x01, 0x78, 0x00, 0xC0, 0x01, // ŸÀ (U+0178 U+00C0)
  0x01, 0x78, 0x00, 0xC1, 0x01, // ŸÁ (U+0178 U+00C1)
  0x01, 0x78, 0x00, 0xC2, 0x01, // ŸÂ (U+0178 U+00C2)
  0x01, 0x78, 0x00, 0xC3, 0x01, // ŸÃ (U+0178 U+00C3)
  0x01, 0x78, 0x00, 0xC4, 0x01, // ŸÄ (U+0178 U+00C4)
  0x01, 0x78, 0x00, 0xC5, 0x01, // ŸÅ (U+0178 U+00C5)
  0x01, 0x78, 0x00, 0xC6, 0x01, // ŸÆ (U+0178 U+00C6)
  0x01, 0x78, 0x00, 0xE7, 0x01, // Ÿç (U+0178 U+00E7)
  0x01, 0x78, 0x00, 0xE8, 0x01, // Ÿè (U+0178 U+00E8)
  0x01, 0x78, 0x00, 0xE9, 0x01, // Ÿé (U+0178 U+00E9)
  0x01, 0x78, 0x00, 0xEA, 0x01, // Ÿê (U+0178 U+00EA)
  0x01, 0x78, 0x00, 0xEB, 0x01, // Ÿë (U+0178 U+00EB)
  0x01, 0x78, 0x00, 0xF0, 0x01, // Ÿð (U+0178 U+00F0)
  0x01, 0x78, 0x00, 0xF2, 0x01, // Ÿò (U+0178 U+00F2)
  0x01, 0x78, 0x00, 0xF3, 0x01, // Ÿó (U+0178 U+00F3)
  0x01, 0x78, 0x00, 0xF4, 0x01, // Ÿô (U+0178 U+00F4)
  0x01, 0x78, 0x00, 0xF5, 0x01, // Ÿõ (U+0178 U+00F5)
  0x01, 0x78, 0x00, 0xF6, 0x01, // Ÿö (U+0178 U+00F6)
  0x01, 0x78, 0x00, 0xF8, 0x01, // Ÿø (U+0178 U+00F8)
  0x01, 0x78, 0x01, 0x00, 0x01, // ŸĀ (U+0178 U+0100)
  0x01, 0x78, 0x01, 0x02, 0x01, // ŸĂ (U+0178 U+0102)
  0x01, 0x78, 0x01, 0x04, 0x01, // ŸĄ (U+0178 U+0104)
  0x01, 0x78, 0x01, 0x07, 0x01, // Ÿć (U+0178 U+0107)
  0x01, 0x78, 0x01, 0x09, 0x01, // Ÿĉ (U+0178 U+0109)
  0x01, 0x78, 0x01, 0x0B, 0x01, // Ÿċ (U+0178 U+010B)
  0x01, 0x78, 0x01, 0x0D, 0x01, // Ÿč (U+0178 U+010D)
  0x01, 0x78, 0x01, 0x0F, 0x01, // Ÿď (U+0178 U+010F)
  0x01, 0x78, 0x01, 0x11, 0x01, // Ÿđ (U+0178 U+0111)
  0x01, 0x78, 0x01, 0x13, 0x01, // Ÿē (U+0178 U+0113)
  0x01, 0x78, 0x01, 0x15, 0x01, // Ÿĕ (U+0178 U+0115)
  0x01, 0x78, 0x01, 0x17, 0x01, // Ÿė (U+0178 U+0117)
  0x01, 0x78, 0x01, 0x19, 0x01, // Ÿę (U+0178 U+0119)
  0x01, 0x78, 0x01, 0x1B, 0x01, // Ÿě (U+0178 U+011B)
  0x01, 0x78, 0x01, 0x1D, 0x01, // Ÿĝ (U+0178 U+011D)
  0x01, 0x78, 0x01, 0x1F, 0x01, // Ÿğ (U+0178 U+011F)
  0x01, 0x78, 0x01, 0x21, 0x01, // Ÿġ (U+0178 U+0121)
  0x01, 0x78, 0x01, 0x23, 0x01, // Ÿģ (U+0178 U+0123)
  0x01, 0x78, 0x01, 0x4D, 0x01, // Ÿō (U+0178 U+014D)
  0x01, 0x78, 0x01, 0x4F, 0x01, // Ÿŏ (U+0178 U+014F)
  0x01, 0x78, 0x01, 0x51, 0x01, // Ÿő (U+0178 U+0151)
  0x01, 0x78, 0x01, 0x53, 0x01, // Ÿœ (U+0178 U+0153)
  0x01, 0x78, 0x20, 0x1A, 0x01, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x01, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x01, // Ÿ… (U+0178 U+2026)
  0x20, 0x18, 0x00, 0x41, 0x01, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0xC0, 0x01, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x01, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x01, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x01, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x01, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x01, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xC6, 0x01, // ‘Æ (U+2018 U+00C6)
  0x20, 0x18, 0x01, 0x00, 0x01, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x02, 0x01, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x04, 0x01, // ‘Ą (U+2018 U+0104)
  0x20, 0x19, 0x00, 0x41, 0x01, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0xC0, 0x01, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x01, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x01, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x01, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x01, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x01, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x01, 0x00, 0x01, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x02, 0x01, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x04, 0x01, // ’Ą (U+2019 U+0104)
  0x20, 0x1A, 0x00, 0x3F, 0x01, // ‚? (U+201A U+003F)
  0x20, 0x1A, 0x00, 0x54, 0x01, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x56, 0x01, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x01, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x01, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0x76, 0x01, // ‚v (U+201A U+0076)
  0x20, 0x1A, 0x00, 0xDD, 0x01, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x01, 0x62, 0x01, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x01, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x01, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1A, 0x01, 0x74, 0x01, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x76, 0x01, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x78, 0x01, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x01, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0xC0, 0x01, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x01, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x01, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x01, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x01, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x01, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xC6, 0x01, // “Æ (U+201C U+00C6)
  0x20, 0x1C, 0x01, 0x00, 0x01, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x02, 0x01, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x04, 0x01, // “Ą (U+201C U+0104)
  0x20, 0x1D, 0x00, 0x41, 0x01, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0xC0, 0x01, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x01, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x01, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x01, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x01, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x01, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x01, 0x00, 0x01, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x02, 0x01, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x04, 0x01, // ”Ą (U+201D U+0104)
  0x20, 0x1E, 0x00, 0x3F, 0x01, // „? (U+201E U+003F)
  0x20, 0x1E, 0x00, 0x54, 0x01, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x56, 0x01, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x01, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x01, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0x76, 0x01, // „v (U+201E U+0076)
  0x20, 0x1E, 0x00, 0xDD, 0x01, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x01, 0x62, 0x01, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x01, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x01, // „Ŧ (U+201E U+0166)
  0x20, 0x1E, 0x01, 0x74, 0x01, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x76, 0x01, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x78, 0x01, // „Ÿ (U+201E U+0178)
  0x20, 0x26, 0x00, 0x3F, 0x01, // …? (U+2026 U+003F)
  0x20, 0x26, 0x00, 0x54, 0x01, // …T (U+2026 U+0054)
  0x20, 0x26, 0x00, 0x56, 0x01, // …V (U+2026 U+0056)
  0x20, 0x26, 0x00, 0x57, 0x01, // …W (U+2026 U+0057)
  0x20, 0x26, 0x00, 0x59, 0x01, // …Y (U+2026 U+0059)
  0x20, 0x26, 0x00, 0x76, 0x01, // …v (U+2026 U+0076)
  0x20, 0x26, 0x00, 0xDD, 0x01, // …Ý (U+2026 U+00DD)
  0x20, 0x26, 0x01, 0x62, 0x01, // …Ţ (U+2026 U+0162)
  0x20, 0x26, 0x01, 0x64, 0x01, // …Ť (U+2026 U+0164)
  0x20, 0x26, 0x01, 0x66, 0x01, // …Ŧ (U+2026 U+0166)
  0x20, 0x26, 0x01, 0x74, 0x01, // …Ŵ (U+2026 U+0174)
  0x20, 0x26, 0x01, 0x76, 0x01, // …Ŷ (U+2026 U+0176)
  0x20, 0x26, 0x01, 0x78, 0x01, // …Ÿ (U+2026 U+0178)
  0x20, 0x44, 0x00, 0x30, 0x01, // ⁄0 (U+2044 U+0030)
  0x20, 0x44, 0x00, 0x31, 0x01, // ⁄1 (U+2044 U+0031)
  0x20, 0x44, 0x00, 0x32, 0x01, // ⁄2 (U+2044 U+0032)
  0x20, 0x44, 0x00, 0x33, 0x01, // ⁄3 (U+2044 U+0033)
  0x20, 0x44, 0x00, 0x34, 0x01, // ⁄4 (U+2044 U+0034)
  0x20, 0x44, 0x00, 0x35, 0x01, // ⁄5 (U+2044 U+0035)
  0x20, 0x44, 0x00, 0x36, 0x01, // ⁄6 (U+2044 U+0036)
  0x20, 0x44, 0x00, 0x37, 0x01, // ⁄7 (U+2044 U+0037)
  0x20, 0x44, 0x00, 0x38, 0x01, // ⁄8 (U+2044 U+0038)
  0x20, 0x44, 0x00, 0x39, 0x01, // ⁄9 (U+2044 U+0039)
  
  // Glyph data
  // "!" (U+0021)
  0x89, 0x41, 0xB1, 0xB0, 0xA0, 0x80, 0x50, 0x11, 0xA0,
  // """ (U+0022)
  0x84, 0x73, 0xB5, 0x27,
  // "#" (U+0023)
  0x18, 0x15, 0x17, 0x28, 0xA4, 0x70, 0x70, 0x4B, 0x9B, 0x20, 0x73, 0x30, 0x7B, 0xB8, 0x02, 0x47,
  0x28, 0x14, 0x27, 0x20,
  // "$" (U+0024)
  0x28, 0x93, 0x60, 0x19, 0xB7, 0x47, 0x64, 0x0B, 0x93, 0x89, 0x0A, 0x97, 0x26, 0xB1, 0x8A, 0x32,
  0x02, 0x10,
  // "%" (U+0025)
  0x89, 0x23, 0x76, 0x06, 0x10, 0x81, 0xA0, 0x72, 0x83, 0x91, 0xB4, 0x32, 0x89, 0x47, 0x2A, 0x83,
  0x63, 0x16, 0x56, 0xA0, 0xA2, 0x83, 0x70, 0xA0, 0xB2, 0x07, 0x10, 0xF6,
  // "&" (U+0026)
  0x18, 0x18, 0x76, 0x38, 0x1C, 0x0B, 0x38, 0x1D, 0xD9, 0x38, 0xA5, 0xAC, 0x08, 0x48, 0x59, 0x68,
  0x0A, 0x10, 0xA6, 0x03, 0x96, 0x6B, 0x60,
  // "'" (U+0027)
  0x82, 0x73, 0x52,
  // "(" (U+0028)
  0x18, 0x96, 0x63, 0x28, 0x07, 0x50, 0x84, 0x06, 0x50, 0x28, 0x20, 0x50, 0x30,
  // ")" (U+0029)
  0x05, 0x03, 0x20, 0xA2, 0x89, 0x39, 0x30, 0x84, 0x09, 0x20, 0xA0, 0x53, 0x10,
  // "*" (U+002A)
  0x89, 0x52, 0x44, 0x24, 0xBA, 0x36, 0x87, 0x50, 0x22, 0x10,
  // "+" (U+002B)
  0x20, 0x63, 0x84, 0x70, 0x48, 0xB8, 0x20, 0x71,
  // "," (U+002C)
  0x83, 0x76, 0x25, 0x41,
  // "-" (U+002D)
  0x81, 0x8A, 0x30,
  // "." (U+002E)
  0x00, 0x60,
  // "/" (U+002F)
  0x18, 0x24, 0x20, 0x62, 0x07, 0x28, 0x46, 0x03, 0x40, 0x62, 0x07, 0x20, 0x72,
  // "0" (U+0030)
  0x18, 0xB2, 0x98, 0x40, 0x66, 0x0B, 0x09, 0x30, 0xB0, 0x93, 0x0B, 0x18, 0x30, 0xB0, 0x56, 0x0B,
  0x28, 0x19, 0x84, 0x10,
  // "1" (U+0031)
  0x18, 0x44, 0xB0, 0x36, 0xB3, 0x0B, 0x30, 0xB3, 0x0B, 0x38, 0x4B, 0x01, 0x7E, 0x50,
  // "2" (U+0032)
  0x86, 0x2A, 0x94, 0x44, 0x1B, 0x20, 0x20, 0x92, 0x83, 0x81, 0x03, 0x52, 0x85, 0x70, 0x37, 0xCB,
  0xD0,
  // "3" (U+0033)
  0x86, 0x2A, 0x95, 0x44, 0x0B, 0x28, 0x43, 0x80, 0x4B, 0x33, 0x0C, 0x03, 0x28, 0x3D, 0x49, 0x95,
  // "4" (U+0034)
  0x20, 0xA0, 0x52, 0x81, 0x39, 0x52, 0x89, 0x47, 0x65, 0x05, 0x26, 0x50, 0x88, 0xBA, 0x22, 0x06,
  0x05, 0x28, 0x11, 0xBB, 0x10,
  // "5" (U+0035)
  0x89, 0x01, 0xCB, 0x82, 0x30, 0x23, 0x22, 0x82, 0x48, 0x82, 0x28, 0x11, 0xB2, 0x28, 0x3B, 0x59,
  0x94,
  // "6" (U+0036)
  0x18, 0x77, 0x88, 0x29, 0x07, 0x66, 0x28, 0x96, 0x79, 0x74, 0x75, 0x0C, 0x37, 0x0B, 0x08, 0x76,
  // "7" (U+0037)
  0x83, 0x7B, 0xBE, 0x32, 0x0A, 0x20, 0x30, 0x62, 0x08, 0x02, 0x20, 0xA2, 0x02, 0x08, 0x20, 0x60,
  0x41,
  // "8" (U+0038)
  0x8B, 0x21, 0x87, 0x56, 0x50, 0xB4, 0xD8, 0x90, 0xAE, 0x26, 0x51, 0xC8, 0x20, 0xA2, 0x86, 0x60,
  // "9" (U+0039)
  0x8A, 0x21, 0x99, 0x36, 0x51, 0xB8, 0x30, 0xC7, 0x50, 0xD0, 0x97, 0xB2, 0x84, 0x18, 0x38, 0x91,
  // ":" (U+003A)
  0x82, 0x48, 0x01, 0x38, 0x11, 0x48,
  // ";" (U+003B)
  0x82, 0x48, 0x01, 0x38, 0x41, 0x49, 0x25, 0x11,
  // "<" (U+003C)
  0x28, 0x71, 0x70, 0x76, 0x03, 0x82, 0x30, 0x50, 0x70,
  // "=" (U+003D)
  0x82, 0x38, 0x87, 0x48, 0x23, 0x88, 0x70,
  // ">" (U+003E)
  0x00, 0x43, 0x81, 0x38, 0x32, 0x83, 0x67, 0x37, 0x11,
  // "?" (U+003F)
  0x86, 0x68, 0x81, 0x50, 0x56, 0x28, 0x37, 0x50, 0x48, 0x20, 0x73, 0x02, 0x30, 0xA0, 0x11,
  // "@" (U+0040)
  0x20, 0xF7, 0x83, 0x81, 0x07, 0x33, 0x8B, 0x57, 0x18, 0x28, 0x84, 0x76, 0x4A, 0x08, 0x17, 0x72,
  0xB0, 0xB0, 0x75, 0x45, 0x74, 0x81, 0x0A, 0x30, 0x32, 0x83, 0x18, 0x77, 0x11,
  // "A" (U+0041)
  0x20, 0x90, 0x44, 0x0A, 0x09, 0x38, 0x13, 0x4C, 0x38, 0x27, 0x0A, 0x32, 0x89, 0x7A, 0x7A, 0x70,
  0x25, 0x01, 0xB0, 0xA9, 0x03, 0xE4,
  // "B" (U+0042)
  0x8C, 0x15, 0xE6, 0x91, 0x0C, 0x06, 0x60, 0xC0, 0x75, 0x0D, 0x6B, 0x10, 0xC0, 0x39, 0x0C, 0x02,
  0xA5, 0xE6, 0x83,
  // "C" (U+0043)
  0x18, 0x91, 0x68, 0xA5, 0x2A, 0x01, 0x56, 0x63, 0x08, 0x05, 0x30, 0x07, 0x30, 0x20, 0xB2, 0x84,
  0x10, 0x7A, 0x94,
  // "D" (U+0044)
  0x83, 0x5E, 0x68, 0x32, 0x0C, 0x20, 0xC2, 0x0C, 0x28, 0x29, 0x30, 0xC2, 0x82, 0x85, 0x0C, 0x28,
  0x29, 0x40, 0xC2, 0x85, 0xC0, 0x5E, 0x69, 0x41,
  // "E" (U+0045)
  0x85, 0x5E, 0x69, 0x50, 0xC2, 0x81, 0x30, 0xC4, 0x81, 0xD6, 0x42, 0x0C, 0x40, 0xC2, 0x84, 0x45,
  0xE6, 0x79,
  // "F" (U+0046)
  0x85, 0x5E, 0x69, 0x50, 0xC2, 0x81, 0x30, 0xC4, 0x81, 0xD7, 0x52, 0x0C, 0x40, 0xC3, 0x81, 0x5E,
  0x52,
  // "G" (U+0047)
  0x18, 0x55, 0x88, 0x90, 0x2A, 0x28, 0x29, 0x06, 0x64, 0x08, 0x05, 0x48, 0x66, 0x60, 0x3A, 0x42,
  0xB2, 0x0C, 0x28, 0x25, 0x97, 0xA1,
  // "H" (U+0048)
  0x86, 0x5E, 0x41, 0xCA, 0x0C, 0x28, 0x28, 0x40, 0xC2, 0x89, 0x08, 0x40, 0xD7, 0x7B, 0x40, 0xC2,
  0x82, 0x84, 0x0C, 0x28, 0x68, 0x45, 0xE4, 0x1C, 0x90,
  // "I" (U+0049)
  0x83, 0x5E, 0x40, 0xC2, 0x0C, 0x20, 0xC2, 0x0C, 0x28, 0x3C, 0x05, 0xE4,
  // "J" (U+004A)
  0x83, 0x5E, 0x40, 0xC2, 0x0C, 0x20, 0xC2, 0x0C, 0x20, 0xC2, 0x0C, 0x28, 0x2C, 0x08, 0x51,
  // "K" (U+004B)
  0x89, 0x15, 0xE4, 0x3D, 0x20, 0xC0, 0x62, 0x28, 0x1C, 0x25, 0x38, 0x1D, 0xB6, 0x38, 0x2D, 0x1D,
  0x12, 0x89, 0x1C, 0x06, 0x90, 0x5E, 0x40, 0xB6,
  // "L" (U+004C)
  0x81, 0x5E, 0x43, 0x0C, 0x40, 0xC4, 0x0C, 0x40, 0xC4, 0x0C, 0x28, 0x47, 0x5E, 0x67, 0x90,
  // "M" (U+004D)
  0x81, 0x5F, 0x42, 0x84, 0xBB, 0x10, 0xB8, 0x20, 0xB0, 0x62, 0x84, 0x7C, 0x04, 0x76, 0x28, 0x47,
  0x92, 0x75, 0x62, 0x84, 0x75, 0x77, 0x56, 0x28, 0x95, 0x70, 0xD4, 0x56, 0x05, 0xC1, 0xA0, 0x9B,
  0x10,
  // "N" (U+004E)
  0x8D, 0x05, 0xE1, 0x0A, 0x70, 0xC8, 0x05, 0x10, 0x7C, 0x15, 0x10, 0x74, 0x95, 0x10, 0x70, 0xB8,
  0x10, 0x70, 0x3E, 0x15, 0xC1, 0x0B, 0x10,
  // "O" (U+004F)
  0x18, 0x56, 0x88, 0x50, 0x3A, 0x28, 0x2B, 0x17, 0x62, 0x82, 0x75, 0x85, 0x28, 0x26, 0x77, 0x62,
  0x82, 0x75, 0x2A, 0x28, 0x5B, 0x10, 0x68, 0x85, 0x10,
  // "P" (U+0050)
  0x82, 0x5E, 0x69, 0x28, 0xA0, 0xC0, 0x66, 0x0C, 0x05, 0x70, 0xC0, 0x83, 0x0D, 0x65, 0x20, 0xC3,
  0x81, 0x5E, 0x52,
  // "Q" (U+0051)
  0x18, 0x56, 0x78, 0x50, 0x39, 0x28, 0x2A, 0x17, 0x62, 0x82, 0x76, 0x85, 0x28, 0x26, 0x76, 0x62,
  0x82, 0x75, 0x2A, 0x28, 0x5B, 0x10, 0x69, 0xA5, 0x30, 0x40, 0x95, 0x09, 0x06, 0x10,
  // "R" (U+0052)
  0x83, 0x5E, 0x69, 0x12, 0x82, 0xC0, 0x57, 0x28, 0x2C, 0x07, 0x42, 0x81, 0xD8, 0x83, 0x81, 0xC1,
  0xC3, 0x89, 0x1C, 0x09, 0x40, 0x5E, 0x42, 0xB2,
  // "S" (U+0053)
  0x89, 0x01, 0x99, 0x67, 0x40, 0x55, 0x93, 0x81, 0x9C, 0x22, 0x81, 0x3C, 0x72, 0x83, 0xB4, 0x97,
  0x50,
  // "T" (U+0054)
  0x89, 0x0B, 0x7D, 0x7A, 0x40, 0xC0, 0x42, 0x0C, 0x40, 0xC4, 0x0C, 0x40, 0xC3, 0x81, 0x5E, 0x41,
  // "U" (U+0055)
  0x86, 0x7D, 0x32, 0xC4, 0x1A, 0x28, 0x27, 0x01, 0xA2, 0x82, 0x70, 0x1A, 0x28, 0x27, 0x01, 0xA2,
  0x07, 0x20, 0xC2, 0x07, 0x28, 0x27, 0x98, 0x31,
  // "V" (U+0056)
  0x86, 0xAC, 0x13, 0xD2, 0x2A, 0x20, 0x72, 0x82, 0xC0, 0x34, 0x28, 0x19, 0x37, 0x38, 0x14, 0x77,
  0x40, 0xB0, 0x64, 0x0B, 0x01, 0x20,
  // "W" (U+0057)
  0x89, 0x79, 0xC1, 0x1B, 0x04, 0xC1, 0x1B, 0x04, 0xD0, 0x17, 0x28, 0x5C, 0x07, 0x92, 0x43, 0x28,
  0x49, 0x27, 0x56, 0x73, 0x84, 0x66, 0x71, 0xA7, 0x38, 0x42, 0xC4, 0x0B, 0x74, 0x0E, 0x20, 0xA0,
  0x42,
  // "X" (U+0058)
  0x83, 0x7E, 0x27, 0xA2, 0x81, 0xB2, 0x73, 0x81, 0x3B, 0x54, 0x0D, 0x02, 0x38, 0x13, 0x8A, 0x38,
  0x91, 0x80, 0xB2, 0x09, 0xA0, 0xAC, 0x10,
  // "Y" (U+0059)
  0x89, 0x4B, 0xB0, 0x8B, 0x1B, 0x06, 0x10, 0x93, 0x72, 0x81, 0x2C, 0x23, 0x0C, 0x40, 0xC3, 0x81,
  0x5E, 0x51,
  // "Z" (U+005A)
  0x87, 0x88, 0x7E, 0x24, 0x03, 0xB3, 0x0B, 0x03, 0x20, 0x30, 0xB3, 0x0A, 0x03, 0x20, 0x20, 0xB2,
  0x84, 0x39, 0xA7, 0x95,
  // "[" (U+005B)
  0x8A, 0x63, 0xC3, 0x39, 0x03, 0x90, 0x39, 0x03, 0x90, 0x39, 0x03, 0x90, 0x29, 0x30,
  // "\" (U+005C)
  0x07, 0x20, 0x72, 0x06, 0x20, 0x30, 0x42, 0x07, 0x20, 0x72, 0x07, 0x20, 0x40, 0x20,
  // "]" (U+005D)
  0x8A, 0x54, 0xD1, 0x0A, 0x10, 0xA1, 0x0A, 0x10, 0xA1, 0x0A, 0x10, 0xB1, 0x4A, 0x10,
  // "^" (U+005E)
  0x10, 0x20, 0x82, 0x00, 0x72, 0x85, 0x71, 0x65, 0x20, 0x80,
  // "_" (U+005F)
  0x0F, 0x80, 0x60,
  // "`" (U+0060)
  0x82, 0x42, 0x17,
  // "a" (U+0061)
  0x8A, 0x71, 0xA9, 0x40, 0x13, 0x19, 0x01, 0x77, 0x90, 0x83, 0x29, 0x04, 0xA6, 0xC1,
  // "b" (U+0062)
  0x07, 0x09, 0x30, 0x20, 0x93, 0x8A, 0x62, 0xB8, 0xA0, 0x2B, 0x06, 0x52, 0x90, 0x46, 0x2B, 0x06,
  0x57, 0xA8, 0xA1,
  // "c" (U+0063)
  0x89, 0x01, 0x99, 0x56, 0x41, 0x38, 0x32, 0x06, 0x05, 0x28, 0x21, 0xA8, 0x50,
  // "d" (U+0064)
  0x20, 0x20, 0xD4, 0x8B, 0x1A, 0x01, 0xA8, 0xC0, 0x65, 0x0C, 0x08, 0x30, 0xB0, 0x65, 0x0C, 0x01,
  0xA8, 0xB6,
  // "e" (U+0065)
  0x89, 0x41, 0xA9, 0x46, 0x50, 0xB8, 0x98, 0xA6, 0x53, 0x81, 0x98, 0x50,
  // "f" (U+0066)
  0x18, 0x38, 0x85, 0x0B, 0x28, 0x14, 0xD5, 0x20, 0xB3, 0x0B, 0x30, 0xB2, 0x81, 0x6D, 0x41,
  // "g" (U+0067)
  0x89, 0x72, 0xBA, 0xA1, 0x65, 0x56, 0x01, 0xA8, 0x10, 0x34, 0x38, 0x41, 0xDC, 0x70, 0x92, 0x84,
  0xB0, 0x77, 0x66, 0x10,
  // "h" (U+0068)
  0x07, 0x09, 0x30, 0x20, 0x93, 0x8A, 0x72, 0xB8, 0xB0, 0x2A, 0x09, 0x22, 0x90, 0x83, 0x29, 0x08,
  0x37, 0xC1, 0x88,
  // "i" (U+0069)
  0x01, 0x09, 0x48, 0x95, 0x6A, 0x01, 0xA0, 0x1A, 0x01, 0xA0, 0x6D, 0x30,
  // "j" (U+006A)
  0x02, 0x08, 0x28, 0x94, 0x79, 0x29, 0x29, 0x29, 0x29, 0x28, 0x93,
  // "k" (U+006B)
  0x07, 0x09, 0x30, 0x20, 0x93, 0x8A, 0x72, 0x92, 0xD3, 0x29, 0x92, 0x02, 0xED, 0x10, 0x29, 0x49,
  0x07, 0xC1, 0xA5,
  // "l" (U+006C)
  0x8A, 0x37, 0x90, 0x29, 0x02, 0x90, 0x29, 0x02, 0x90, 0x29, 0x07, 0xC2,
  // "m" (U+006D)
  0x8C, 0x65, 0xB8, 0xA6, 0xB5, 0x01, 0xC0, 0x84, 0x1A, 0x01, 0xA0, 0x83, 0x1A, 0x01, 0xA0, 0x83,
  0x1A, 0x06, 0xD2, 0x88, 0x1D, 0x20,
  // "n" (U+006E)
  0x8A, 0x76, 0xB8, 0xB0, 0x1C, 0x07, 0x41, 0xA0, 0x74, 0x1A, 0x07, 0x46, 0xD2, 0x79,
  // "o" (U+006F)
  0x8A, 0x61, 0x97, 0x60, 0x65, 0x0A, 0x08, 0x30, 0x92, 0x65, 0x0A, 0x01, 0x97, 0x71,
  // "p" (U+0070)
  0x8B, 0x17, 0xA8, 0xA0, 0x2B, 0x06, 0x52, 0x90, 0x46, 0x2B, 0x06, 0x52, 0xB8, 0xA0, 0x29, 0x38,
  0x17, 0xC1, 0x20,
  // "q" (U+0071)
  0x8A, 0x61, 0xA8, 0xB6, 0x65, 0x0C, 0x08, 0x30, 0xB0, 0x65, 0x0C, 0x01, 0xA8, 0xC4, 0x0A, 0x38,
  0x14, 0xD6,
  // "r" (U+0072)
  0x89, 0x06, 0xAA, 0x71, 0xD0, 0x11, 0xB2, 0x01, 0x0A, 0x28, 0x16, 0xD3, 0x10,
  // "s" (U+0073)
  0x8A, 0x14, 0x7A, 0x08, 0x42, 0x01, 0xB9, 0x03, 0x08, 0x36, 0x69, 0x10,
  // "t" (U+0074)
  0x8A, 0x02, 0x70, 0x8B, 0x43, 0x80, 0x38, 0x03, 0x80, 0x1B, 0x40,
  // "u" (U+0075)
  0x8A, 0x77, 0x91, 0xC3, 0x29, 0x08, 0x32, 0x90, 0x83, 0x1A, 0x09, 0x30, 0xA8, 0xA8,
  // "v" (U+0076)
  0x87, 0xAB, 0x0B, 0x42, 0x90, 0x72, 0x81, 0xC0, 0x62, 0x81, 0x88, 0x22, 0x03, 0x0B, 0x20,
  // "w" (U+0077)
  0x8A, 0x2A, 0xA0, 0xC0, 0x88, 0x38, 0x2B, 0x35, 0x10, 0xB6, 0x38, 0x72, 0x83, 0xB6, 0x0A, 0x62,
  0x83, 0x76, 0x09, 0x41,
  // "x" (U+0078)
  0x87, 0x7D, 0x3C, 0x20, 0x96, 0x22, 0x02, 0x0C, 0x38, 0x77, 0x56, 0x08, 0xA3, 0xE4,
  // "y" (U+0079)
  0x87, 0xBB, 0x0C, 0x42, 0x90, 0x72, 0x81, 0xB1, 0x62, 0x81, 0x6A, 0x13, 0x0B, 0x30, 0x20, 0x62,
  0x05, 0x09, 0x30,
  // "z" (U+007A)
  0x85, 0x78, 0xB7, 0x10, 0xC2, 0x89, 0x17, 0x60, 0x1B, 0x02, 0x8B, 0x88,
  // "{" (U+007B)
  0x18, 0x93, 0x58, 0x09, 0x20, 0xA1, 0x0B, 0x04, 0xA2, 0x86, 0xA1, 0x0A, 0x20, 0x38,
  // "|" (U+007C)
  0x80, 0x57,
  // "}" (U+007D)
  0x03, 0x0A, 0x28, 0xA1, 0xB1, 0x0A, 0x10, 0x92, 0x04, 0xA0, 0xA1, 0x0B, 0x14, 0x71,
  // "~" (U+007E)
  0x86, 0x29, 0x25, 0x50, 0x76,
  // "¡" (U+00A1)
  0x89, 0x4A, 0x11, 0x05, 0x08, 0x0A, 0x0B, 0x0B, 0x10,
  // "¢" (U+00A2)
  0x18, 0xA5, 0x18, 0x10, 0xB8, 0xB4, 0x76, 0x15, 0x66, 0x02, 0xA6, 0x20, 0x6B, 0x72, 0x06, 0x10,
  // "£" (U+00A3)
  0x18, 0x91, 0x87, 0x90, 0x28, 0x05, 0x01, 0x93, 0x82, 0x4D, 0x71, 0x20, 0x80, 0x13, 0x08, 0x38,
  0x34, 0xAB, 0xA1,
  // "¤" (U+00A4)
  0x01, 0x28, 0x97, 0x13, 0xB9, 0x92, 0x40, 0x72, 0x60, 0x73, 0x98, 0x80,
  // "¥" (U+00A5)
  0x87, 0xBB, 0x1D, 0x33, 0x90, 0x72, 0x81, 0xB1, 0x52, 0x00, 0x82, 0x87, 0x18, 0xC4, 0x01, 0x7C,
  0x42, 0x81, 0x8D, 0x31,
  // "¦" (U+00A6)
  0x0F, 0x78, 0x14, 0x04, 0x0F, 0x70,
  // "§" (U+00A7)
  0x18, 0xA1, 0x99, 0x52, 0x70, 0x31, 0xD8, 0x05, 0x55, 0xA1, 0xCA, 0x92, 0x89, 0x07, 0x91, 0x50,
  0x80, 0x77, 0x20,
  // "¨" (U+00A8)
  0x81, 0x72, 0x40,
  // "©" (U+00A9)
  0x18, 0x21, 0x77, 0x62, 0x89, 0x71, 0x84, 0x75, 0x80, 0x62, 0x80, 0x34, 0x27, 0x27, 0x28, 0x95,
  0x24, 0x62, 0x90, 0x14, 0x21, 0x85, 0x75, 0x82, 0x82, 0x17, 0x76, 0x20,
  // "ª" (U+00AA)
  0x87, 0x47, 0x64, 0x69, 0x86, 0xA0,
  // "«" (U+00AB)
  0x18, 0x90, 0x30, 0x31, 0x98, 0x25, 0x7C, 0x28, 0x18, 0x35,
  // "¬" (U+00AC)
  0x82, 0x48, 0x89, 0x30, 0x73, 0x05,
  // "®" (U+00AE)
  0x18, 0x21, 0x77, 0x62, 0x8C, 0x01, 0x99, 0x54, 0x80, 0x61, 0x90, 0x94, 0x27, 0x09, 0x92, 0x24,
  0x61, 0x94, 0x64, 0x21, 0x89, 0x29, 0x82, 0x82, 0x17, 0x76, 0x20,
  // "¯" (U+00AF)
  0x0F, 0x80, 0x50,
  // "°" (U+00B0)
  0x87, 0x39, 0x58, 0x09, 0x39, 0x50,
  // "±" (U+00B1)
  0x28, 0x47, 0x03, 0x8B, 0x72, 0x07, 0x38, 0x46, 0x03, 0x88, 0x70,
  // "²" (U+00B2)
  0x89, 0x23, 0x64, 0x21, 0x90, 0x72, 0x68, 0x70,
  // "³" (U+00B3)
  0x89, 0x24, 0x65, 0x08, 0x53, 0x0A, 0x46, 0x30,
  // "´" (U+00B4)
  0x18, 0x15, 0x63,
  // "µ" (U+00B5)
  0x8B, 0x13, 0x80, 0xA1, 0x38, 0x0A, 0x13, 0x80, 0xA1, 0x39, 0x0C, 0x14, 0xC8, 0x95, 0x45, 0x30,
  0x20, 0xA3,
  // "¶" (U+00B6)
  0x89, 0x45, 0xFB, 0xB4, 0xAF, 0x97, 0x07, 0xF9, 0x72, 0x81, 0x48, 0x73, 0x00, 0x73, 0x00, 0x73,
  0x00, 0x72, 0x82, 0x46, 0x64,
  // "·" (U+00B7)
  0x00, 0x60,
  // "¸" (U+00B8)
  0x10, 0x72, 0x82, 0x81, 0x38, 0x10,
  // "¹" (U+00B9)
  0x03, 0x0A, 0x20, 0xB2, 0x83, 0xB0, 0x28, 0x30,
  // "º" (U+00BA)
  0x87, 0x66, 0x7A, 0x0A, 0x56, 0x70,
  // "»" (U+00BB)
  0x89, 0x52, 0x03, 0x01, 0x98, 0x20, 0xB6, 0x73, 0x48, 0x10,
  // "¼" (U+00BC)
  0x40, 0x82, 0x83, 0x3A, 0x03, 0x53, 0x81, 0xB0, 0x74, 0x89, 0x3B, 0x07, 0x08, 0x32, 0x89, 0x13,
  0x94, 0x28, 0x68, 0x06, 0x98, 0x03, 0x42, 0x07, 0x05,
  // "½" (U+00BD)
  0x40, 0x82, 0x83, 0x3A, 0x03, 0x53, 0x81, 0xB0, 0x74, 0x89, 0x3B, 0x07, 0x36, 0x42, 0x89, 0x12,
  0x19, 0x20, 0x82, 0x87, 0x72, 0x03, 0x40, 0x68, 0x70,
  // "¾" (U+00BE)
  0x40, 0x82, 0x83, 0x46, 0x53, 0x53, 0x81, 0x85, 0x73, 0x89, 0x43, 0x0B, 0x70, 0x83, 0x46, 0x91,
  0x39, 0x42, 0x86, 0x80, 0x69, 0x80, 0x34, 0x20, 0x70, 0x50,
  // "¿" (U+00BF)
  0x10, 0x10, 0xA3, 0x02, 0x30, 0x72, 0x83, 0x84, 0x05, 0x72, 0x86, 0x65, 0x05, 0x18, 0x96,
  // "À" (U+00C0)
  0x10, 0x40, 0x24, 0x01, 0x07, 0x50, 0x90, 0x44, 0x0A, 0x09, 0x38, 0x13, 0x4C, 0x38, 0x27, 0x0A,
  0x32, 0x89, 0x7A, 0x7A, 0x70, 0x25, 0x01, 0xB0, 0xA9, 0x03, 0xE4,
  // "Á" (U+00C1)
  0x30, 0x54, 0x06, 0x03, 0x40, 0x90, 0x44, 0x0A, 0x09, 0x38, 0x13, 0x4C, 0x38, 0x27, 0x0A, 0x32,
  0x89, 0x7A, 0x7A, 0x70, 0x25, 0x01, 0xB0, 0xA9, 0x03, 0xE4,
  // "Â" (U+00C2)
  0x20, 0x74, 0x81, 0x56, 0x54, 0x09, 0x04, 0x40, 0xA0, 0x93, 0x81, 0x34, 0xC3, 0x82, 0x70, 0xA3,
  0x28, 0x97, 0xA7, 0xA7, 0x02, 0x50, 0x1B, 0x0A, 0x90, 0x3E, 0x40,
  // "Ã" (U+00C3)
  0x18, 0x24, 0x96, 0x12, 0x81, 0x3D, 0xE4, 0x0A, 0x09, 0x38, 0x13, 0x4C, 0x38, 0x27, 0x0A, 0x32,
  0x89, 0x7A, 0x7A, 0x70, 0x25, 0x01, 0xB0, 0xA9, 0x03, 0xE4,
  // "Ä" (U+00C4)
  0x28, 0x17, 0x24, 0x30, 0x90, 0x44, 0x0A, 0x09, 0x38, 0x13, 0x4C, 0x38, 0x27, 0x0A, 0x32, 0x89,
  0x7A, 0x7A, 0x70, 0x25, 0x01, 0xB0, 0xA9, 0x03, 0xE4,
  // "Å" (U+00C5)
  0x20, 0x70, 0x54, 0x0B, 0x07, 0x40, 0xA0, 0x93, 0x81, 0x34, 0xC3, 0x82, 0x70, 0xA2, 0x28, 0x97,
  0xA7, 0xA7, 0x02, 0x50, 0x1B, 0x0A, 0x90, 0x3E, 0x40,
  // "Æ" (U+00C6)
  0x28, 0x33, 0xCA, 0x6C, 0x38, 0x34, 0x77, 0x03, 0x38, 0x17, 0x47, 0x48, 0x42, 0x54, 0xA6, 0x22,
  0x82, 0x87, 0x97, 0x38, 0x96, 0x17, 0x04, 0x70, 0x12, 0xA9, 0x0A, 0xA6, 0xA3,
  // "Ç" (U+00C7)
  0x18, 0x91, 0x68, 0xA5, 0x2A, 0x01, 0x56, 0x63, 0x08, 0x05, 0x30, 0x07, 0x30, 0x20, 0xB2, 0x84,
  0x10, 0x7E, 0xD4, 0x30, 0xA3, 0x06, 0x05, 0x10,
  // "È" (U+00C8)
  0x10, 0x40, 0x23, 0x01, 0x07, 0x28, 0x55, 0xE6, 0x95, 0x0C, 0x28, 0x13, 0x0C, 0x48, 0x1D, 0x64,
  0x20, 0xC4, 0x0C, 0x28, 0x44, 0x5E, 0x67, 0x90,
  // "É" (U+00C9)
  0x30, 0x53, 0x89, 0x06, 0x30, 0x5E, 0x69, 0x50, 0xC2, 0x81, 0x30, 0xC4, 0x81, 0xD6, 0x42, 0x0C,
  0x40, 0xC2, 0x84, 0x45, 0xE6, 0x79,
  // "Ê" (U+00CA)
  0x20, 0x73, 0x89, 0x15, 0x65, 0x05, 0xE6, 0x95, 0x0C, 0x28, 0x13, 0x0C, 0x48, 0x1D, 0x64, 0x20,
  0xC4, 0x0C, 0x28, 0x44, 0x5E, 0x67, 0x90,
  // "Ë" (U+00CB)
  0x18, 0x91, 0x72, 0x40, 0x5E, 0x69, 0x50, 0xC2, 0x81, 0x30, 0xC4, 0x81, 0xD6, 0x42, 0x0C, 0x40,
  0xC2, 0x84, 0x45, 0xE6, 0x79,
  // "Ì" (U+00CC)
  0x89, 0x14, 0x20, 0x17, 0x05, 0xE4, 0x0C, 0x20, 0xC2, 0x0C, 0x20, 0xC2, 0x83, 0xC0, 0x5E, 0x40,
  // "Í" (U+00CD)
  0x28, 0x75, 0x06, 0x35, 0xE4, 0x0C, 0x20, 0xC2, 0x0C, 0x20, 0xC2, 0x83, 0xC0, 0x5E, 0x40,
  // "Î" (U+00CE)
  0x18, 0x90, 0x70, 0x56, 0x55, 0xE4, 0x0C, 0x20, 0xC2, 0x0C, 0x20, 0xC2, 0x83, 0xC0, 0x5E, 0x40,
  // "Ï" (U+00CF)
  0x86, 0x72, 0x45, 0xE4, 0x0C, 0x20, 0xC2, 0x0C, 0x20, 0xC2, 0x83, 0xC0, 0x5E, 0x40,
  // "Ð" (U+00D0)
  0x83, 0x5E, 0x68, 0x32, 0x0C, 0x20, 0xC2, 0x0C, 0x28, 0x90, 0x93, 0x4D, 0x61, 0x85, 0x0C, 0x28,
  0x29, 0x40, 0xC2, 0x85, 0xC0, 0x5E, 0x69, 0x41,
  // "Ñ" (U+00D1)
  0x18, 0xD5, 0x49, 0x61, 0x05, 0xF4, 0xAB, 0x70, 0xC8, 0x05, 0x10, 0x7C, 0x15, 0x10, 0x74, 0x95,
  0x10, 0x70, 0xB8, 0x10, 0x70, 0x3E, 0x15, 0xC1, 0x0B, 0x10,
  // "Ò" (U+00D2)
  0x10, 0x40, 0x24, 0x01, 0x07, 0x48, 0x56, 0x88, 0x50, 0x3A, 0x28, 0x2B, 0x17, 0x62, 0x82, 0x75,
  0x85, 0x28, 0x26, 0x77, 0x62, 0x82, 0x75, 0x2A, 0x28, 0x5B, 0x10, 0x68, 0x85, 0x10,
  // "Ó" (U+00D3)
  0x30, 0x54, 0x06, 0x03, 0x38, 0x56, 0x88, 0x50, 0x3A, 0x28, 0x2B, 0x17, 0x62, 0x82, 0x75, 0x85,
  0x28, 0x26, 0x77, 0x62, 0x82, 0x75, 0x2A, 0x28, 0x5B, 0x10, 0x68, 0x85, 0x10,
  // "Ô" (U+00D4)
  0x20, 0x74, 0x81, 0x56, 0x53, 0x85, 0x68, 0x85, 0x03, 0xA2, 0x82, 0xB1, 0x76, 0x28, 0x27, 0x58,
  0x52, 0x82, 0x67, 0x76, 0x28, 0x27, 0x52, 0xA2, 0x85, 0xB1, 0x06, 0x88, 0x51,
  // "Õ" (U+00D5)
  0x18, 0x24, 0x96, 0x12, 0x85, 0xAB, 0xF5, 0x03, 0xA2, 0x82, 0xB1, 0x76, 0x28, 0x27, 0x58, 0x52,
  0x82, 0x67, 0x76, 0x28, 0x27, 0x52, 0xA2, 0x85, 0xB1, 0x06, 0x88, 0x51,
  // "Ö" (U+00D6)
  0x28, 0x17, 0x24, 0x28, 0x56, 0x88, 0x50, 0x3A, 0x28, 0x2B, 0x17, 0x62, 0x82, 0x75, 0x85, 0x28,
  0x26, 0x77, 0x62, 0x82, 0x75, 0x2A, 0x28, 0x5B, 0x10, 0x68, 0x85, 0x10,
  // "×" (U+00D7)
  0x89, 0x62, 0x10, 0x30, 0x87, 0x30, 0x79, 0x12, 0x30, 0x60,
  // "Ø" (U+00D8)
  0x18, 0xC6, 0x68, 0x89, 0x02, 0xA0, 0x5C, 0x17, 0x60, 0x77, 0x58, 0x54, 0x36, 0x76, 0x67, 0x07,
  0x53, 0xC4, 0x0B, 0x10, 0xB8, 0x85, 0x20, 0x34,
  // "Ù" (U+00D9)
  0x10, 0x40, 0x24, 0x01, 0x07, 0x38, 0x67, 0xD3, 0x2C, 0x41, 0xA2, 0x82, 0x70, 0x1A, 0x28, 0x27,
  0x01, 0xA2, 0x82, 0x70, 0x1A, 0x20, 0x72, 0x0C, 0x20, 0x72, 0x82, 0x79, 0x83, 0x10,
  // "Ú" (U+00DA)
  0x30, 0x54, 0x06, 0x03, 0x28, 0x67, 0xD3, 0x2C, 0x41, 0xA2, 0x82, 0x70, 0x1A, 0x28, 0x27, 0x01,
  0xA2, 0x82, 0x70, 0x1A, 0x20, 0x72, 0x0C, 0x20, 0x72, 0x82, 0x79, 0x83, 0x10,
  // "Û" (U+00DB)
  0x30, 0x74, 0x89, 0x25, 0x65, 0x07, 0xD3, 0x2C, 0x41, 0xA2, 0x82, 0x70, 0x1A, 0x28, 0x27, 0x01,
  0xA2, 0x82, 0x70, 0x1A, 0x20, 0x72, 0x0C, 0x20, 0x72, 0x82, 0x79, 0x83, 0x10,
  // "Ü" (U+00DC)
  0x28, 0x92, 0x72, 0x40, 0x7D, 0x32, 0xC4, 0x1A, 0x28, 0x27, 0x01, 0xA2, 0x82, 0x70, 0x1A, 0x28,
  0x27, 0x01, 0xA2, 0x07, 0x20, 0xC2, 0x07, 0x28, 0x27, 0x98, 0x31,
  // "Ý" (U+00DD)
  0x30, 0x53, 0x89, 0x76, 0x30, 0xBB, 0x08, 0xB1, 0xB0, 0x61, 0x09, 0x37, 0x28, 0x12, 0xC2, 0x30,
  0xC4, 0x0C, 0x38, 0x15, 0xE5, 0x10,
  // "Þ" (U+00DE)
  0x81, 0x5E, 0x43, 0x81, 0xD6, 0x62, 0x8A, 0x4C, 0x07, 0x50, 0xC0, 0x57, 0x0C, 0x08, 0x40, 0xD6,
  0x50, 0x5E, 0x42,
  // "ß" (U+00DF)
  0x18, 0x17, 0x69, 0x28, 0xB3, 0xB0, 0x64, 0x5A, 0x58, 0x21, 0xA9, 0x30, 0x1A, 0x2C, 0x51, 0xA3,
  0x0B, 0x6A, 0x75, 0x70,
  // "à" (U+00E0)
  0x10, 0x40, 0x23, 0x01, 0x07, 0x78, 0xA7, 0x1A, 0x94, 0x01, 0x31, 0x90, 0x17, 0x79, 0x08, 0x32,
  0x90, 0x4A, 0x6C, 0x10,
  // "á" (U+00E1)
  0x30, 0x53, 0x06, 0x03, 0x68, 0xA7, 0x1A, 0x94, 0x01, 0x31, 0x90, 0x17, 0x79, 0x08, 0x32, 0x90,
  0x4A, 0x6C, 0x10,
  // "â" (U+00E2)
  0x20, 0x73, 0x81, 0x56, 0x56, 0x8A, 0x71, 0xA9, 0x40, 0x13, 0x19, 0x01, 0x77, 0x90, 0x83, 0x29,
  0x04, 0xA6, 0xC1,
  // "ã" (U+00E3)
  0x86, 0x49, 0x61, 0x03, 0x39, 0x28, 0xA7, 0x1A, 0x94, 0x01, 0x31, 0x90, 0x17, 0x79, 0x08, 0x32,
  0x90, 0x4A, 0x6C, 0x10,
  // "ä" (U+00E4)
  0x18, 0x17, 0x24, 0x68, 0xA7, 0x1A, 0x94, 0x01, 0x31, 0x90, 0x17, 0x79, 0x08, 0x32, 0x90, 0x4A,
  0x6C, 0x10,
  // "å" (U+00E5)
  0x10, 0x30, 0x73, 0x81, 0x73, 0x32, 0x03, 0x07, 0x28, 0xA7, 0x1A, 0x94, 0x01, 0x31, 0x90, 0x17,
  0x79, 0x08, 0x32, 0x90, 0x4A, 0x6C, 0x10,
  // "æ" (U+00E6)
  0x8A, 0x71, 0xA9, 0x98, 0x90, 0x13, 0x1C, 0x08, 0x32, 0x88, 0xC7, 0x93, 0x83, 0x2C, 0x38, 0x44,
  0xA7, 0x78, 0x81,
  // "ç" (U+00E7)
  0x89, 0x01, 0x99, 0x56, 0x41, 0x38, 0x32, 0x06, 0x05, 0x28, 0x21, 0xAF, 0x52, 0x83, 0x81, 0x03,
  0x81,
  // "è" (U+00E8)
  0x10, 0x40, 0x22, 0x01, 0x07, 0x58, 0x94, 0x1A, 0x94, 0x65, 0x0B, 0x89, 0x8A, 0x65, 0x38, 0x19,
  0x85,
  // "é" (U+00E9)
  0x30, 0x52, 0x06, 0x03, 0x48, 0x94, 0x1A, 0x94, 0x65, 0x0B, 0x89, 0x8A, 0x65, 0x38, 0x19, 0x85,
  // "ê" (U+00EA)
  0x20, 0x72, 0x81, 0x56, 0x54, 0x89, 0x41, 0xA9, 0x46, 0x50, 0xB8, 0x98, 0xA6, 0x53, 0x81, 0x98,
  0x50,
  // "ë" (U+00EB)
  0x18, 0x17, 0x24, 0x48, 0x94, 0x1A, 0x94, 0x65, 0x0B, 0x89, 0x8A, 0x65, 0x38, 0x19, 0x85,
  // "ì" (U+00EC)
  0x83, 0x42, 0x01, 0x74, 0x89, 0x56, 0xA0, 0x1A, 0x01, 0xA0, 0x1A, 0x06, 0xD3,
  // "í" (U+00ED)
  0x28, 0x25, 0x06, 0x33, 0x89, 0x56, 0xA0, 0x1A, 0x01, 0xA0, 0x1A, 0x06, 0xD3,
  // "î" (U+00EE)
  0x18, 0x37, 0x05, 0x65, 0x38, 0x95, 0x6A, 0x01, 0xA0, 0x1A, 0x01, 0xA0, 0x6D, 0x30,
  // "ï" (U+00EF)
  0x81, 0x72, 0x43, 0x89, 0x56, 0xA0, 0x1A, 0x01, 0xA0, 0x1A, 0x06, 0xD3,
  // "ð" (U+00F0)
  0x18, 0x16, 0x84, 0x28, 0x14, 0x75, 0x28, 0xA5, 0x77, 0xC0, 0x55, 0x0B, 0x18, 0x30, 0x92, 0x64,
  0x0A, 0x01, 0x97, 0x61,
  // "ñ" (U+00F1)
  0x18, 0xC0, 0x49, 0x61, 0x03, 0x39, 0x06, 0xB8, 0xB0, 0x1C, 0x07, 0x41, 0xA0, 0x74, 0x1A, 0x07,
  0x46, 0xD2, 0x79,
  // "ò" (U+00F2)
  0x10, 0x40, 0x23, 0x01, 0x07, 0x78, 0xA6, 0x19, 0x76, 0x06, 0x50, 0xA0, 0x83, 0x09, 0x26, 0x50,
  0xA0, 0x19, 0x77, 0x10,
  // "ó" (U+00F3)
  0x30, 0x53, 0x06, 0x03, 0x68, 0xA6, 0x19, 0x76, 0x06, 0x50, 0xA0, 0x83, 0x09, 0x26, 0x50, 0xA0,
  0x19, 0x77, 0x10,
  // "ô" (U+00F4)
  0x20, 0x73, 0x81, 0x56, 0x56, 0x8A, 0x61, 0x97, 0x60, 0x65, 0x0A, 0x08, 0x30, 0x92, 0x65, 0x0A,
  0x01, 0x97, 0x71,
  // "õ" (U+00F5)
  0x18, 0xB7, 0x49, 0x61, 0x03, 0x39, 0x01, 0x97, 0x60, 0x65, 0x0A, 0x08, 0x30, 0x92, 0x65, 0x0A,
  0x01, 0x97, 0x71,
  // "ö" (U+00F6)
  0x18, 0x17, 0x24, 0x68, 0xA6, 0x19, 0x76, 0x06, 0x50, 0xA0, 0x83, 0x09, 0x26, 0x50, 0xA0, 0x19,
  0x77, 0x10,
  // "÷" (U+00F7)
  0x18, 0x21, 0x70, 0x40, 0xF8, 0x50, 0x10, 0x71,
  // "ø" (U+00F8)
  0x38, 0xB3, 0x30, 0x19, 0x7A, 0x06, 0x55, 0xC0, 0x84, 0x69, 0x27, 0xA1, 0xA0, 0x2B, 0x77, 0x02,
  0x13,
  // "ù" (U+00F9)
  0x10, 0x40, 0x23, 0x01, 0x07, 0x78, 0xA7, 0x79, 0x1C, 0x32, 0x90, 0x83, 0x29, 0x08, 0x31, 0xA0,
  0x93, 0x0A, 0x8A, 0x80,
  // "ú" (U+00FA)
  0x30, 0x53, 0x06, 0x03, 0x68, 0xA7, 0x79, 0x1C, 0x32, 0x90, 0x83, 0x29, 0x08, 0x31, 0xA0, 0x93,
  0x0A, 0x8A, 0x80,
  // "û" (U+00FB)
  0x20, 0x73, 0x81, 0x56, 0x56, 0x8A, 0x77, 0x91, 0xC3, 0x29, 0x08, 0x32, 0x90, 0x83, 0x1A, 0x09,
  0x30, 0xA8, 0xA8,
  // "ü" (U+00FC)
  0x18, 0x17, 0x24, 0x68, 0xA7, 0x79, 0x1C, 0x32, 0x90, 0x83, 0x29, 0x08, 0x31, 0xA0, 0x93, 0x0A,
  0x8A, 0x80,
  // "ý" (U+00FD)
  0x30, 0x53, 0x06, 0x03, 0x68, 0x7B, 0xB0, 0xC4, 0x29, 0x07, 0x28, 0x1B, 0x16, 0x28, 0x16, 0xA1,
  0x30, 0xB3, 0x02, 0x06, 0x20, 0x50, 0x93,
  // "þ" (U+00FE)
  0x07, 0x09, 0x30, 0x20, 0x93, 0x8B, 0x12, 0xB8, 0xA0, 0x2B, 0x06, 0x52, 0x90, 0x46, 0x2B, 0x06,
  0x52, 0xC8, 0xA0, 0x29, 0x38, 0x17, 0xC1, 0x20,
  // "ÿ" (U+00FF)
  0x18, 0x17, 0x24, 0x68, 0x7B, 0xB0, 0xC4, 0x29, 0x07, 0x28, 0x1B, 0x16, 0x28, 0x16, 0xA1, 0x30,
  0xB3, 0x02, 0x06, 0x20, 0x50, 0x93,
  // "Ā" (U+0100)
  0x18, 0x15, 0xFA, 0x40, 0xA0, 0x93, 0x81, 0x34, 0xC3, 0x82, 0x70, 0xA3, 0x28, 0x97, 0xA7, 0xA7,
  0x02, 0x50, 0x1B, 0x0A, 0x90, 0x3E, 0x40,
  // "ā" (U+0101)
  0x18, 0xB3, 0x58, 0x50, 0x1A, 0x94, 0x01, 0x31, 0x90, 0x17, 0x79, 0x08, 0x32, 0x90, 0x4A, 0x6C,
  0x10,
  // "Ă" (U+0102)
  0x18, 0x14, 0x04, 0x38, 0x14, 0xF7, 0x40, 0xA0, 0x93, 0x81, 0x34, 0xC3, 0x82, 0x70, 0xA3, 0x28,
  0x97, 0xA7, 0xA7, 0x02, 0x50, 0x1B, 0x0A, 0x90, 0x3E, 0x40,
  // "ă" (U+0103)
  0x18, 0x14, 0x04, 0x28, 0xB3, 0x4B, 0x20, 0x1A, 0x94, 0x01, 0x31, 0x90, 0x17, 0x79, 0x08, 0x32,
  0x90, 0x4A, 0x6C, 0x10,
  // "Ą" (U+0104)
  0x20, 0x90, 0x44, 0x0A, 0x09, 0x38, 0x13, 0x4C, 0x38, 0x27, 0x0A, 0x32, 0x89, 0x7A, 0x7A, 0x70,
  0x25, 0x01, 0xB0, 0xA9, 0x03, 0xF4, 0x30, 0x70, 0x24, 0x04, 0x09, 0x10,
  // "ą" (U+0105)
  0x8A, 0x71, 0xA9, 0x40, 0x13, 0x19, 0x01, 0x77, 0x90, 0x83, 0x29, 0x04, 0xA6, 0xE1, 0x20, 0x70,
  0x23, 0x04, 0x09, 0x10,
  // "Ć" (U+0106)
  0x30, 0x53, 0x06, 0x03, 0x28, 0x91, 0x68, 0xA5, 0x2A, 0x01, 0x56, 0x63, 0x08, 0x05, 0x30, 0x07,
  0x30, 0x20, 0xB2, 0x84, 0x10, 0x7A, 0x94,
  // "ć" (U+0107)
  0x30, 0x52, 0x06, 0x03, 0x48, 0x90, 0x19, 0x95, 0x64, 0x13, 0x83, 0x20, 0x60, 0x52, 0x82, 0x1A,
  0x85,
  // "Ĉ" (U+0108)
  0x20, 0x73, 0x81, 0x56, 0x52, 0x89, 0x16, 0x8A, 0x52, 0xA0, 0x15, 0x66, 0x30, 0x80, 0x53, 0x00,
  0x73, 0x02, 0x0B, 0x28, 0x41, 0x07, 0xA9, 0x40,
  // "ĉ" (U+0109)
  0x20, 0x72, 0x81, 0x56, 0x54, 0x89, 0x01, 0x99, 0x56, 0x41, 0x38, 0x32, 0x06, 0x05, 0x28, 0x21,
  0xA8, 0x50,
  // "Ċ" (U+010A)
  0x20, 0x60, 0x12, 0x89, 0x16, 0x8A, 0x52, 0xA0, 0x15, 0x66, 0x30, 0x80, 0x53, 0x00, 0x73, 0x02,
  0x0B, 0x28, 0x41, 0x07, 0xA9, 0x40,
  // "ċ" (U+010B)
  0x10, 0x60, 0x15, 0x89, 0x01, 0x99, 0x56, 0x41, 0x38, 0x32, 0x06, 0x05, 0x28, 0x21, 0xA8, 0x50,
  // "Č" (U+010C)
  0x18, 0x13, 0x03, 0x28, 0x12, 0xD2, 0x28, 0x91, 0x68, 0xA5, 0x2A, 0x01, 0x56, 0x63, 0x08, 0x05,
  0x30, 0x07, 0x30, 0x20, 0xB2, 0x84, 0x10, 0x7A, 0x94,
  // "č" (U+010D)
  0x18, 0x53, 0x03, 0x02, 0xD2, 0x48, 0x90, 0x19, 0x95, 0x64, 0x13, 0x83, 0x20, 0x60, 0x52, 0x82,
  0x1A, 0x85,
  // "Ď" (U+010E)
  0x18, 0x13, 0x03, 0x38, 0x12, 0xD2, 0x28, 0x35, 0xE6, 0x83, 0x20, 0xC2, 0x0C, 0x20, 0xC2, 0x82,
  0x93, 0x0C, 0x28, 0x28, 0x50, 0xC2, 0x82, 0x94, 0x0C, 0x28, 0x5C, 0x05, 0xE6, 0x94, 0x10,
  // "ď" (U+010F)
  0x28, 0x22, 0xD6, 0x33, 0x85, 0xA3, 0x01, 0xA8, 0xC2, 0x82, 0x65, 0x0C, 0x28, 0x28, 0x30, 0xB2,
  0x82, 0x65, 0x0C, 0x28, 0x31, 0xA8, 0xB6, 0x10,
  // "Đ" (U+0110)
  0x83, 0x5E, 0x68, 0x32, 0x0C, 0x20, 0xC2, 0x0C, 0x28, 0x90, 0x93, 0x4D, 0x61, 0x85, 0x0C, 0x28,
  0x29, 0x40, 0xC2, 0x85, 0xC0, 0x5E, 0x69, 0x41,
  // "đ" (U+0111)
  0x20, 0x20, 0xD3, 0x8B, 0x26, 0xC5, 0x1A, 0x8C, 0x06, 0x50, 0xC0, 0x83, 0x0B, 0x07, 0x50, 0xC0,
  0x1A, 0x8B, 0x60,
  // "Ē" (U+0112)
  0x85, 0x5F, 0xEE, 0x50, 0xC2, 0x81, 0x30, 0xC4, 0x81, 0xD6, 0x42, 0x0C, 0x40, 0xC2, 0x84, 0x45,
  0xE6, 0x79,
  // "ē" (U+0113)
  0x18, 0x97, 0x58, 0x51, 0xA9, 0x46, 0x50, 0xB8, 0x98, 0xA6, 0x53, 0x81, 0x98, 0x50,
  // "Ĕ" (U+0114)
  0x18, 0x34, 0x04, 0x05, 0xA8, 0x2C, 0x50, 0xC2, 0x81, 0x30, 0xC4, 0x81, 0xD6, 0x42, 0x0C, 0x40,
  0xC2, 0x84, 0x45, 0xE6, 0x79,
  // "ĕ" (U+0115)
  0x18, 0xA3, 0x40, 0x40, 0x4B, 0x21, 0xA9, 0x46, 0x50, 0xB8, 0x98, 0xA6, 0x53, 0x81, 0x98, 0x50,
  // "Ė" (U+0116)
  0x28, 0x90, 0x61, 0x05, 0xE6, 0x95, 0x0C, 0x28, 0x13, 0x0C, 0x48, 0x1D, 0x64, 0x20, 0xC4, 0x0C,
  0x28, 0x44, 0x5E, 0x67, 0x90,
  // "ė" (U+0117)
  0x10, 0x60, 0x15, 0x89, 0x41, 0xA9, 0x46, 0x50, 0xB8, 0x98, 0xA6, 0x53, 0x81, 0x98, 0x50,
  // "Ę" (U+0118)
  0x85, 0x5E, 0x69, 0x50, 0xC2, 0x81, 0x30, 0xC4, 0x81, 0xD6, 0x42, 0x0C, 0x40, 0xC2, 0x84, 0x45,
  0xE6, 0x7A, 0x30, 0x94, 0x00, 0x70,
  // "ę" (U+0119)
  0x89, 0x41, 0x99, 0x46, 0x50, 0xB8, 0x97, 0x96, 0x53, 0x81, 0xA9, 0x62, 0x08, 0x30, 0xB0, 0x40,
  // "Ě" (U+011A)
  0x18, 0x13, 0x03, 0x28, 0x91, 0x2D, 0x20, 0x5E, 0x69, 0x50, 0xC2, 0x81, 0x30, 0xC4, 0x81, 0xD6,
  0x42, 0x0C, 0x40, 0xC2, 0x84, 0x45, 0xE6, 0x79,
  // "ě" (U+011B)
  0x18, 0x53, 0x03, 0x02, 0xD2, 0x48, 0x94, 0x1A, 0x94, 0x65, 0x0B, 0x89, 0x8A, 0x65, 0x38, 0x19,
  0x85,
  // "Ĝ" (U+011C)
  0x30, 0x74, 0x81, 0x56, 0x52, 0x85, 0x58, 0x89, 0x02, 0xA2, 0x82, 0x90, 0x66, 0x40, 0x80, 0x54,
  0x86, 0x66, 0x03, 0xA4, 0x2B, 0x20, 0xC2, 0x82, 0x59, 0x7A, 0x10,
  // "ĝ" (U+011D)
  0x20, 0x73, 0x81, 0x56, 0x56, 0x89, 0x72, 0xBA, 0xA1, 0x65, 0x56, 0x01, 0xA8, 0x10, 0x34, 0x38,
  0x41, 0xDC, 0x70, 0x92, 0x84, 0xB0, 0x77, 0x66, 0x10,
  // "Ğ" (U+011E)
  0x28, 0x14, 0x04, 0x28, 0x55, 0xCF, 0xC0, 0x2A, 0x28, 0x29, 0x06, 0x64, 0x08, 0x05, 0x48, 0x66,
  0x60, 0x3A, 0x42, 0xB2, 0x0C, 0x28, 0x25, 0x97, 0xA1,
  // "ğ" (U+011F)
  0x18, 0x14, 0x04, 0x28, 0xA3, 0x4B, 0x20, 0x2B, 0xAA, 0x16, 0x55, 0x60, 0x1A, 0x81, 0x03, 0x43,
  0x84, 0x1D, 0xC7, 0x09, 0x28, 0x4B, 0x07, 0x76, 0x61,
  // "Ġ" (U+0120)
  0x20, 0x60, 0x13, 0x85, 0x58, 0x89, 0x02, 0xA2, 0x82, 0x90, 0x66, 0x40, 0x80, 0x54, 0x86, 0x66,
  0x03, 0xA4, 0x2B, 0x20, 0xC2, 0x82, 0x59, 0x7A, 0x10,
  // "ġ" (U+0121)
  0x10, 0x60, 0x17, 0x89, 0x72, 0xBA, 0xA1, 0x65, 0x56, 0x01, 0xA8, 0x10, 0x34, 0x38, 0x41, 0xDC,
  0x70, 0x92, 0x84, 0xB0, 0x77, 0x66, 0x10,
  // "Ģ" (U+0122)
  0x18, 0x55, 0x88, 0x90, 0x2A, 0x28, 0x29, 0x06, 0x64, 0x08, 0x05, 0x48, 0x66, 0x60, 0x3A, 0x42,
  0xB2, 0x0C, 0x28, 0x25, 0x97, 0xA7, 0x20, 0x50, 0x44, 0x01, 0x30,
  // "ģ" (U+0123)
  0x20, 0x83, 0x01, 0x03, 0x28, 0x97, 0x2B, 0xAA, 0x16, 0x55, 0x60, 0x1A, 0x81, 0x03, 0x43, 0x84,
  0x1D, 0xC7, 0x09, 0x28, 0x4B, 0x07, 0x76, 0x61,
  // "Ĥ" (U+0124)
  0x30, 0x74, 0x89, 0x25, 0x65, 0x05, 0xE4, 0x1C, 0xA0, 0xC2, 0x82, 0x84, 0x0C, 0x28, 0x90, 0x84,
  0x0D, 0x77, 0xB4, 0x0C, 0x28, 0x28, 0x40, 0xC2, 0x86, 0x84, 0x5E, 0x41, 0xC9,
  // "ĥ" (U+0125)
  0x20, 0x73, 0x81, 0x56, 0x56, 0x07, 0x09, 0x30, 0x20, 0x93, 0x8A, 0x72, 0xB8, 0xB0, 0x2A, 0x09,
  0x22, 0x90, 0x83, 0x29, 0x08, 0x37, 0xC1, 0x88,
  // "Ħ" (U+0126)
  0x86, 0x5F, 0x41, 0xCA, 0x0C, 0x28, 0x96, 0x84, 0x5D, 0x77, 0xB9, 0x0D, 0x77, 0xB4, 0x0C, 0x28,
  0x28, 0x40, 0xC2, 0x86, 0x84, 0x5E, 0x41, 0xC9,
  // "ħ" (U+0127)
  0x08, 0x09, 0x38, 0x16, 0xB5, 0x28, 0xA7, 0x2C, 0x8A, 0x02, 0xA0, 0x92, 0x29, 0x08, 0x32, 0x90,
  0x83, 0x7C, 0x18, 0x80,
  // "Ĩ" (U+0128)
  0x85, 0x49, 0x61, 0x8F, 0xE2, 0x0C, 0x30, 0xC3, 0x0C, 0x30, 0xC3, 0x0C, 0x28, 0x15, 0xE4, 0x10,
  // "ĩ" (U+0129)
  0x85, 0x49, 0x61, 0x33, 0x92, 0x06, 0x0A, 0x20, 0x10, 0xA2, 0x01, 0x0A, 0x20, 0x10, 0xA2, 0x81,
  0x6D, 0x30,
  // "Ī" (U+012A)
  0x83, 0xBF, 0x90, 0xC2, 0x0C, 0x20, 0xC2, 0x0C, 0x28, 0x3C, 0x05, 0xE4,
  // "ī" (U+012B)
  0x8A, 0x05, 0x85, 0x6A, 0x01, 0xA0, 0x1A, 0x01, 0xA0, 0x6D, 0x30,
  // "Ĭ" (U+012C)
  0x86, 0x40, 0x49, 0xF7, 0x0C, 0x20, 0xC2, 0x0C, 0x20, 0xC2, 0x83, 0xC0, 0x5E, 0x40,
  // "ĭ" (U+012D)
  0x8A, 0x34, 0x04, 0x4B, 0x26, 0xA0, 0x1A, 0x01, 0xA0, 0x1A, 0x06, 0xD3,
  // "Į" (U+012E)
  0x83, 0x5E, 0x40, 0xC2, 0x0C, 0x20, 0xC2, 0x0C, 0x28, 0x5C, 0x05, 0xF5, 0x09, 0x20, 0x07,
  // "į" (U+012F)
  0x01, 0x09, 0x48, 0x96, 0x6A, 0x01, 0xA0, 0x1A, 0x01, 0xA0, 0x7E, 0x39, 0x20, 0x07, 0x10,
  // "İ" (U+0130)
  0x18, 0x56, 0x15, 0xE4, 0x0C, 0x20, 0xC2, 0x0C, 0x20, 0xC2, 0x83, 0xC0, 0x5E, 0x40,
  // "ı" (U+0131)
  0x89, 0x56, 0xA0, 0x1A, 0x01, 0xA0, 0x1A, 0x06, 0xD3,
  // "Ĳ" (U+0132)
  0x86, 0x5E, 0x45, 0xE4, 0x0C, 0x20, 0xC2, 0x0C, 0x20, 0xC2, 0x0C, 0x20, 0xC2, 0x0C, 0x20, 0xC2,
  0x0C, 0x28, 0x5C, 0x05, 0xE4, 0x0C, 0x50, 0xC4, 0x08, 0x05, 0x10,
  // "ĳ" (U+0133)
  0x83, 0x19, 0x02, 0x85, 0x8A, 0x76, 0xA0, 0x79, 0x1A, 0x02, 0x91, 0xA0, 0x29, 0x1A, 0x02, 0x96,
  0xD3, 0x29, 0x30, 0x20, 0x83, 0x09, 0x03,
  // "Ĵ" (U+0134)
  0x18, 0x90, 0x70, 0x56, 0x55, 0xE4, 0x0C, 0x20, 0xC2, 0x0C, 0x20, 0xC2, 0x0C, 0x20, 0xC2, 0x82,
  0xC0, 0x85, 0x10,
  // "ĵ" (U+0135)
  0x18, 0x37, 0x05, 0x65, 0x38, 0xA2, 0x79, 0x02, 0x90, 0x29, 0x02, 0x90, 0x29, 0x02, 0x80, 0x93,
  0x10,
  // "Ķ" (U+0136)
  0x89, 0x15, 0xE4, 0x3D, 0x20, 0xC0, 0x62, 0x28, 0x1C, 0x25, 0x38, 0x1D, 0xB6, 0x38, 0x2D, 0x1D,
  0x12, 0x89, 0x1C, 0x06, 0x90, 0x5E, 0x40, 0xB6, 0x71, 0x05, 0x04, 0x40, 0x13,
  // "ķ" (U+0137)
  0x07, 0x09, 0x30, 0x20, 0x93, 0x8A, 0x72, 0x92, 0xD3, 0x29, 0x92, 0x02, 0xED, 0x10, 0x29, 0x49,
  0x07, 0xC1, 0xA5, 0x60, 0x50, 0x43, 0x01, 0x30,
  // "ĸ" (U+0138)
  0x8A, 0x77, 0x92, 0xD3, 0x29, 0x92, 0x02, 0xED, 0x10, 0x29, 0x49, 0x07, 0xC1, 0xA5,
  // "Ĺ" (U+0139)
  0x20, 0x53, 0x06, 0x03, 0x28, 0x15, 0xE4, 0x30, 0xC4, 0x0C, 0x40, 0xC4, 0x0C, 0x40, 0xC2, 0x84,
  0x75, 0xE6, 0x79,
  // "ĺ" (U+013A)
  0x28, 0x25, 0x06, 0x33, 0x8A, 0x37, 0x90, 0x29, 0x02, 0x90, 0x29, 0x02, 0x90, 0x29, 0x07, 0xC2,
  // "Ļ" (U+013B)
  0x81, 0x5E, 0x43, 0x0C, 0x40, 0xC4, 0x0C, 0x40, 0xC4, 0x0C, 0x28, 0x47, 0x5E, 0x67, 0x97, 0x05,
  0x04, 0x30, 0x12,
  // "ļ" (U+013C)
  0x8A, 0x37, 0x90, 0x29, 0x02, 0x90, 0x29, 0x02, 0x90, 0x29, 0x07, 0xC2, 0x38, 0x25, 0x40, 0x12,
  // "Ľ" (U+013D)
  0x87, 0x5E, 0x47, 0x20, 0xC0, 0x22, 0x0C, 0x40, 0xC4, 0x0C, 0x40, 0xC2, 0x84, 0x75, 0xE6, 0x79,
  // "ľ" (U+013E)
  0x8A, 0x37, 0x99, 0x29, 0x22, 0x90, 0x29, 0x02, 0x90, 0x29, 0x07, 0xC2,
  // "Ŀ" (U+013F)
  0x81, 0x5E, 0x43, 0x0C, 0x40, 0xC4, 0x84, 0xC0, 0x61, 0x0C, 0x40, 0xC2, 0x84, 0x75, 0xE6, 0x79,
  // "ŀ" (U+0140)
  0x07, 0x09, 0x20, 0x20, 0x92, 0x02, 0x09, 0x28, 0x42, 0x96, 0x12, 0x92, 0x02, 0x09, 0x28, 0x17,
  0xC2, 0x10,
  // "Ł" (U+0141)
  0x81, 0x5E, 0x43, 0x0C, 0x48, 0x1C, 0x41, 0x20, 0xD0, 0x32, 0x05, 0x0C, 0x40, 0xC2, 0x84, 0x75,
  0xE6, 0x79,
  // "ł" (U+0142)
  0x06, 0x0B, 0x20, 0xB2, 0x0B, 0x28, 0x2D, 0x45, 0xB2, 0x83, 0xB0, 0x6D, 0x30,
  // "Ń" (U+0143)
  0x30, 0x54, 0x06, 0x03, 0x28, 0xD0, 0x5E, 0x10, 0xA7, 0x0C, 0x80, 0x51, 0x07, 0xC1, 0x51, 0x07,
  0x49, 0x51, 0x07, 0x0B, 0x81, 0x07, 0x03, 0xE1, 0x5C, 0x10, 0xB1,
  // "ń" (U+0144)
  0x30, 0x53, 0x06, 0x03, 0x68, 0xA7, 0x6B, 0x8B, 0x01, 0xC0, 0x74, 0x1A, 0x07, 0x41, 0xA0, 0x74,
  0x6D, 0x27, 0x90,
  // "Ņ" (U+0145)
  0x8D, 0x05, 0xE1, 0x0A, 0x70, 0xC8, 0x05, 0x10, 0x7C, 0x15, 0x10, 0x74, 0x95, 0x10, 0x70, 0xB8,
  0x10, 0x70, 0x3E, 0x15, 0xC1, 0x0B, 0x17, 0x10, 0x50, 0x44, 0x01, 0x30,
  // "ņ" (U+0146)
  0x8A, 0x76, 0xB8, 0xB0, 0x1C, 0x07, 0x41, 0xA0, 0x74, 0x1A, 0x07, 0x46, 0xD2, 0x79, 0x70, 0x50,
  0x43, 0x01, 0x20,
  // "Ň" (U+0147)
  0x28, 0x13, 0x03, 0x38, 0xD4, 0x2D, 0x20, 0x5E, 0x10, 0xA7, 0x0C, 0x80, 0x51, 0x07, 0xC1, 0x51,
  0x07, 0x49, 0x51, 0x07, 0x0B, 0x81, 0x07, 0x03, 0xE1, 0x5C, 0x10, 0xB1,
  // "ň" (U+0148)
  0x18, 0x13, 0x03, 0x28, 0x12, 0xD2, 0x68, 0xA7, 0x6B, 0x8B, 0x01, 0xC0, 0x74, 0x1A, 0x07, 0x41,
  0xA0, 0x74, 0x6D, 0x27, 0x90,
  // "ŉ" (U+0149)
  0x07, 0x06, 0x40, 0x20, 0x64, 0x83, 0x46, 0xB8, 0xB2, 0x8A, 0x51, 0xC0, 0x74, 0x01, 0xA0, 0x74,
  0x01, 0xA0, 0x74, 0x06, 0xD2, 0x79,
  // "Ŋ" (U+014A)
  0x8D, 0x05, 0xE1, 0x0B, 0x80, 0xC8, 0x05, 0x10, 0x7C, 0x25, 0x10, 0x74, 0xA5, 0x10, 0x70, 0xB9,
  0x10, 0x70, 0x3F, 0x15, 0xC2, 0x0A, 0x14, 0x06, 0x01, 0x30, 0x10, 0x81,
  // "ŋ" (U+014B)
  0x8A, 0x76, 0xB8, 0xB0, 0x1C, 0x07, 0x41, 0xA0, 0x74, 0x1A, 0x07, 0x46, 0xD2, 0x74, 0x30, 0x70,
  0x32, 0x02, 0x0A, 0x10,
  // "Ō" (U+014C)
  0x18, 0x5C, 0xFD, 0x50, 0x3A, 0x28, 0x2B, 0x17, 0x62, 0x82, 0x75, 0x85, 0x28, 0x26, 0x77, 0x62,
  0x82, 0x75, 0x2A, 0x28, 0x5B, 0x10, 0x68, 0x85, 0x10,
  // "ō" (U+014D)
  0x18, 0xB2, 0x58, 0x50, 0x19, 0x76, 0x06, 0x50, 0xA0, 0x83, 0x09, 0x26, 0x50, 0xA0, 0x19, 0x77,
  0x10,
  // "Ŏ" (U+014E)
  0x28, 0x14, 0x04, 0x28, 0x56, 0xCF, 0x80, 0x3A, 0x28, 0x2B, 0x17, 0x62, 0x82, 0x75, 0x85, 0x28,
  0x26, 0x77, 0x62, 0x82, 0x75, 0x2A, 0x28, 0x5B, 0x10, 0x68, 0x85, 0x10,
  // "ŏ" (U+014F)
  0x18, 0x14, 0x04, 0x28, 0xB2, 0x4B, 0x20, 0x19, 0x76, 0x06, 0x50, 0xA0, 0x83, 0x09, 0x26, 0x50,
  0xA0, 0x19, 0x77, 0x10,
  // "Ő" (U+0150)
  0x18, 0x24, 0x7A, 0x12, 0x85, 0x88, 0x95, 0x03, 0xA2, 0x82, 0xB1, 0x76, 0x28, 0x27, 0x58, 0x52,
  0x82, 0x67, 0x76, 0x28, 0x27, 0x52, 0xA2, 0x85, 0xB1, 0x06, 0x88, 0x51,
  // "ő" (U+0151)
  0x18, 0x44, 0x7A, 0x10, 0x13, 0x8A, 0x61, 0x97, 0x60, 0x65, 0x0A, 0x08, 0x30, 0x92, 0x65, 0x0A,
  0x01, 0x97, 0x71,
  // "Œ" (U+0152)
  0x18, 0xA2, 0x69, 0xAC, 0x8D, 0x03, 0xA0, 0x38, 0x04, 0x07, 0x60, 0x38, 0x38, 0x93, 0x85, 0x03,
  0xB7, 0x30, 0x76, 0x03, 0x83, 0x89, 0x62, 0xA0, 0x38, 0x01, 0x30, 0x68, 0x9B, 0x7A, 0x40,
  // "œ" (U+0153)
  0x8B, 0x01, 0x97, 0x68, 0x84, 0x65, 0x0B, 0x40, 0xB8, 0x30, 0x98, 0x79, 0x65, 0x0B, 0x42, 0x85,
  0x19, 0x77, 0x98, 0x50,
  // "Ŕ" (U+0154)
  0x30, 0x54, 0x06, 0x03, 0x28, 0x35, 0xE6, 0x91, 0x28, 0x2C, 0x05, 0x72, 0x82, 0xC0, 0x74, 0x28,
  0x1D, 0x88, 0x38, 0x1C, 0x1C, 0x38, 0x91, 0xC0, 0x94, 0x05, 0xE4, 0x2B, 0x20,
  // "ŕ" (U+0155)
  0x20, 0x52, 0x06, 0x03, 0x58, 0x90, 0x6A, 0xA7, 0x1D, 0x01, 0x1B, 0x20, 0x10, 0xA2, 0x81, 0x6D,
  0x31,
  // "Ŗ" (U+0156)
  0x83, 0x5E, 0x69, 0x12, 0x82, 0xC0, 0x57, 0x28, 0x2C, 0x07, 0x42, 0x81, 0xD8, 0x83, 0x81, 0xC1,
  0xC3, 0x89, 0x1C, 0x09, 0x40, 0x5E, 0x42, 0xB2, 0x71, 0x05, 0x04, 0x40, 0x13,
  // "ŗ" (U+0157)
  0x89, 0x06, 0xAA, 0x71, 0xD0, 0x11, 0xB2, 0x01, 0x0A, 0x28, 0x16, 0xD3, 0x50, 0x50, 0x42, 0x01,
  0x30,
  // "Ř" (U+0158)
  0x18, 0x13, 0x03, 0x38, 0x12, 0xD2, 0x28, 0x35, 0xE6, 0x91, 0x28, 0x2C, 0x05, 0x72, 0x82, 0xC0,
  0x74, 0x28, 0x1D, 0x88, 0x38, 0x1C, 0x1C, 0x38, 0x91, 0xC0, 0x94, 0x05, 0xE4, 0x2B, 0x20,
  // "ř" (U+0159)
  0x85, 0x30, 0x30, 0x2D, 0x25, 0x89, 0x06, 0xAA, 0x71, 0xD0, 0x11, 0xB2, 0x01, 0x0A, 0x28, 0x16,
  0xD3, 0x10,
  // "Ś" (U+015A)
  0x20, 0x52, 0x89, 0x36, 0x30, 0x19, 0x96, 0x74, 0x05, 0x59, 0x38, 0x19, 0xC2, 0x28, 0x13, 0xC7,
  0x28, 0x3B, 0x49, 0x75,
  // "ś" (U+015B)
  0x20, 0x52, 0x06, 0x03, 0x58, 0xA1, 0x47, 0xA0, 0x84, 0x20, 0x1B, 0x90, 0x30, 0x83, 0x66, 0x91,
  // "Ŝ" (U+015C)
  0x20, 0x72, 0x89, 0x35, 0x65, 0x19, 0x96, 0x74, 0x05, 0x59, 0x38, 0x19, 0xC2, 0x28, 0x13, 0xC7,
  0x28, 0x3B, 0x49, 0x75,
  // "ŝ" (U+015D)
  0x10, 0x72, 0x81, 0x56, 0x55, 0x8A, 0x14, 0x7A, 0x08, 0x42, 0x01, 0xB9, 0x03, 0x08, 0x36, 0x69,
  0x10,
  // "Ş" (U+015E)
  0x89, 0x01, 0x99, 0x67, 0x40, 0x55, 0x93, 0x81, 0x9C, 0x22, 0x81, 0x3C, 0x72, 0x83, 0xB4, 0x9E,
  0x52, 0x83, 0x81, 0x03, 0x81,
  // "ş" (U+015F)
  0x8A, 0x14, 0x7A, 0x08, 0x42, 0x01, 0xB9, 0x03, 0x08, 0x36, 0xE9, 0x28, 0x38, 0x10, 0x38, 0x20,
  // "Š" (U+0160)
  0x18, 0x97, 0x30, 0x30, 0x2D, 0x21, 0x99, 0x67, 0x40, 0x55, 0x93, 0x81, 0x9C, 0x22, 0x81, 0x3C,
  0x72, 0x83, 0xB4, 0x97, 0x50,
  // "š" (U+0161)
  0x85, 0x30, 0x30, 0x2D, 0x25, 0x8A, 0x14, 0x7A, 0x08, 0x42, 0x01, 0xB9, 0x03, 0x08, 0x36, 0x69,
  0x10,
  // "Ţ" (U+0162)
  0x89, 0x0B, 0x7D, 0x7A, 0x40, 0xC0, 0x42, 0x0C, 0x40, 0xC4, 0x0C, 0x40, 0xC3, 0x81, 0x9F, 0x43,
  0x0A, 0x30, 0x60, 0x52,
  // "ţ" (U+0163)
  0x8A, 0x02, 0x70, 0x8B, 0x43, 0x80, 0x38, 0x03, 0x80, 0x1F, 0x82, 0x82, 0xA0, 0x65,
  // "Ť" (U+0164)
  0x18, 0x13, 0x03, 0x28, 0x94, 0x2D, 0x20, 0xB7, 0xD7, 0xA4, 0x0C, 0x04, 0x20, 0xC4, 0x0C, 0x40,
  0xC4, 0x0C, 0x38, 0x15, 0xE4, 0x10,
  // "ť" (U+0165)
  0x28, 0xA1, 0x92, 0x72, 0x8B, 0x43, 0x80, 0x38, 0x03, 0x80, 0x1B, 0x40,
  // "Ŧ" (U+0166)
  0x89, 0x0B, 0x7D, 0x7A, 0x40, 0xC0, 0x42, 0x0C, 0x28, 0x32, 0x7D, 0x71, 0x20, 0xC4, 0x0C, 0x38,
  0x15, 0xE4, 0x10,
  // "ŧ" (U+0167)
  0x8A, 0x02, 0x70, 0x8B, 0x43, 0x80, 0x7B, 0x33, 0x80, 0x1B, 0x40,
  // "Ũ" (U+0168)
  0x18, 0x93, 0x49, 0x61, 0x07, 0xF6, 0xCC, 0x41, 0xA2, 0x82, 0x70, 0x1A, 0x28, 0x27, 0x01, 0xA2,
  0x82, 0x70, 0x1A, 0x20, 0x72, 0x0C, 0x20, 0x72, 0x82, 0x79, 0x83, 0x10,
  // "ũ" (U+0169)
  0x18, 0xC0, 0x49, 0x61, 0x03, 0x39, 0x07, 0x91, 0xC3, 0x29, 0x08, 0x32, 0x90, 0x83, 0x1A, 0x09,
  0x30, 0xA8, 0xA8,
  // "Ū" (U+016A)
  0x86, 0x7D, 0x8B, 0xF4, 0x1A, 0x28, 0x27, 0x01, 0xA2, 0x82, 0x70, 0x1A, 0x28, 0x27, 0x01, 0xA2,
  0x07, 0x20, 0xC2, 0x07, 0x28, 0x27, 0x98, 0x31,
  // "ū" (U+016B)
  0x18, 0xB3, 0x58, 0x50, 0x79, 0x1C, 0x32, 0x90, 0x83, 0x29, 0x08, 0x31, 0xA0, 0x93, 0x0A, 0x8A,
  0x80,
  // "Ŭ" (U+016C)
  0x28, 0x92, 0x40, 0x40, 0x7D, 0x7E, 0xF4, 0x1A, 0x28, 0x27, 0x01, 0xA2, 0x82, 0x70, 0x1A, 0x28,
  0x27, 0x01, 0xA2, 0x07, 0x20, 0xC2, 0x07, 0x28, 0x27, 0x98, 0x31,
  // "ŭ" (U+016D)
  0x18, 0x14, 0x04, 0x28, 0xB3, 0x4B, 0x20, 0x79, 0x1C, 0x32, 0x90, 0x83, 0x29, 0x08, 0x31, 0xA0,
  0x93, 0x0A, 0x8A, 0x80,
  // "Ů" (U+016E)
  0x20, 0x30, 0x74, 0x89, 0x27, 0x33, 0x07, 0xD6, 0xAD, 0x41, 0xA2, 0x82, 0x70, 0x1A, 0x28, 0x27,
  0x01, 0xA2, 0x82, 0x70, 0x1A, 0x20, 0x72, 0x0C, 0x20, 0x72, 0x82, 0x79, 0x83, 0x10,
  // "ů" (U+016F)
  0x10, 0x30, 0x73, 0x81, 0x73, 0x32, 0x03, 0x07, 0x28, 0xA7, 0x79, 0x1C, 0x32, 0x90, 0x83, 0x29,
  0x08, 0x31, 0xA0, 0x93, 0x0A, 0x8A, 0x80,
  // "Ű" (U+0170)
  0x18, 0x93, 0x47, 0xA1, 0x07, 0xF3, 0x3C, 0x41, 0xA2, 0x82, 0x70, 0x1A, 0x28, 0x27, 0x01, 0xA2,
  0x82, 0x70, 0x1A, 0x20, 0x72, 0x0C, 0x20, 0x72, 0x82, 0x79, 0x83, 0x10,
  // "ű" (U+0171)
  0x18, 0x44, 0x7A, 0x10, 0x13, 0x8A, 0x77, 0x91, 0xC3, 0x29, 0x08, 0x32, 0x90, 0x83, 0x1A, 0x09,
  0x30, 0xA8, 0xA8,
  // "Ų" (U+0172)
  0x86, 0x7D, 0x32, 0xC4, 0x1A, 0x28, 0x27, 0x01, 0xA2, 0x82, 0x70, 0x1A, 0x28, 0x27, 0x01, 0xA2,
  0x07, 0x20, 0xC2, 0x07, 0x28, 0x27, 0x99, 0x33, 0x09, 0x50, 0x07, 0x20,
  // "ų" (U+0173)
  0x8A, 0x77, 0x91, 0xC3, 0x29, 0x08, 0x32, 0x90, 0x83, 0x1A, 0x09, 0x30, 0xA8, 0xC8, 0x20, 0x70,
  0x23, 0x04, 0x09, 0x10,
  // "Ŵ" (U+0174)
  0x40, 0x77, 0x81, 0x56, 0x53, 0x89, 0x79, 0xC1, 0x1B, 0x04, 0xC1, 0x1B, 0x04, 0xD0, 0x17, 0x28,
  0x5C, 0x07, 0x92, 0x43, 0x28, 0x49, 0x27, 0x56, 0x73, 0x84, 0x66, 0x71, 0xA7, 0x38, 0x42, 0xC4,
  0x0B, 0x74, 0x0E, 0x20, 0xA0, 0x42,
  // "ŵ" (U+0175)
  0x30, 0x75, 0x81, 0x56, 0x57, 0x28, 0xA2, 0xAA, 0x0C, 0x08, 0x83, 0x82, 0xB3, 0x51, 0x0B, 0x63,
  0x87, 0x28, 0x3B, 0x60, 0xA6, 0x28, 0x37, 0x60, 0x94, 0x10,
  // "Ŷ" (U+0176)
  0x20, 0x73, 0x8A, 0x05, 0x65, 0x0B, 0xB0, 0x8B, 0x1B, 0x06, 0x10, 0x93, 0x72, 0x81, 0x2C, 0x23,
  0x0C, 0x40, 0xC3, 0x81, 0x5E, 0x51,
  // "ŷ" (U+0177)
  0x20, 0x73, 0x81, 0x56, 0x56, 0x87, 0xBB, 0x0C, 0x42, 0x90, 0x72, 0x81, 0xB1, 0x62, 0x81, 0x6A,
  0x13, 0x0B, 0x30, 0x20, 0x62, 0x05, 0x09, 0x30,
  // "Ÿ" (U+0178)
  0x18, 0xA0, 0x72, 0x40, 0xBB, 0x08, 0xB1, 0xB0, 0x61, 0x09, 0x37, 0x28, 0x12, 0xC2, 0x30, 0xC4,
  0x0C, 0x38, 0x15, 0xE5, 0x10,
  // "Ź" (U+0179)
  0x30, 0x53, 0x89, 0x26, 0x30, 0x88, 0x7E, 0x24, 0x03, 0xB3, 0x0B, 0x03, 0x20, 0x30, 0xB3, 0x0A,
  0x03, 0x20, 0x20, 0xB2, 0x84, 0x39, 0xA7, 0x95,
  // "ź" (U+017A)
  0x20, 0x52, 0x06, 0x03, 0x58, 0x57, 0x8B, 0x71, 0x0C, 0x28, 0x91, 0x76, 0x01, 0xB0, 0x28, 0xB8,
  0x80,
  // "Ż" (U+017B)
  0x28, 0x92, 0x61, 0x08, 0x87, 0xE2, 0x40, 0x3B, 0x30, 0xB0, 0x32, 0x03, 0x0B, 0x30, 0xA0, 0x32,
  0x02, 0x0B, 0x28, 0x43, 0x9A, 0x79, 0x50,
  // "ż" (U+017C)
  0x10, 0x60, 0x15, 0x85, 0x78, 0xB7, 0x10, 0xC2, 0x89, 0x17, 0x60, 0x1B, 0x02, 0x8B, 0x88,
  // "Ž" (U+017D)
  0x18, 0x13, 0x03, 0x28, 0x93, 0x2D, 0x20, 0x88, 0x7E, 0x24, 0x03, 0xB3, 0x0B, 0x03, 0x20, 0x30,
  0xB3, 0x0A, 0x03, 0x20, 0x20, 0xB2, 0x84, 0x39, 0xA7, 0x95,
  // "ž" (U+017E)
  0x18, 0x53, 0x03, 0x02, 0xD2, 0x48, 0x57, 0x8B, 0x71, 0x0C, 0x28, 0x91, 0x76, 0x01, 0xB0, 0x28,
  0xB8, 0x80,
  // "ſ" (U+017F)
  0x18, 0x38, 0x93, 0x19, 0x20, 0x20, 0x92, 0x02, 0x09, 0x20, 0x20, 0x92, 0x02, 0x09, 0x28, 0x17,
  0xC3, 0x10,
  // "Ω" (U+03A9)
  0x18, 0x57, 0x88, 0x70, 0x49, 0x28, 0x29, 0x47, 0x62, 0x82, 0x67, 0x67, 0x28, 0x26, 0x61, 0xB2,
  0x89, 0x4A, 0x14, 0x18, 0x82, 0x49, 0xBA, 0xAB, 0x90,
  // "μ" (U+03BC)
  0x8B, 0x13, 0x80, 0xA1, 0x38, 0x0A, 0x13, 0x80, 0xA1, 0x39, 0x0C, 0x14, 0xC8, 0x95, 0x45, 0x30,
  0x20, 0xA3,
  // "π" (U+03C0)
  0x87, 0x7D, 0xBD, 0x82, 0x70, 0x72, 0x81, 0x80, 0x82, 0x87, 0x90, 0x90, 0x66, 0x09, 0x40,
  // "–" (U+2013)
  0x80, 0x08,
  // "—" (U+2014)
  0x80, 0x48,
  // "€" (U+20AC)
  0x18, 0x91, 0x39, 0xB1, 0x0B, 0x06, 0x10, 0xB3, 0x86, 0x5C, 0x62, 0x05, 0xC6, 0x30, 0xC4, 0x82,
  0x49, 0x81,
  // "₿" (U+20BF)
  0x8C, 0x05, 0xC7, 0x70, 0x1A, 0x0C, 0x01, 0xA0, 0xB0, 0x1C, 0x95, 0x01, 0xA0, 0xC0, 0x1A, 0x0C,
  0x15, 0xC6, 0x82, 0x00, 0x42,
  // "‘" (U+2018)
  0x18, 0x34, 0x61, 0x67,
  // "’" (U+2019)
  0x83, 0x76, 0x26, 0x41,
  // "‚" (U+201A)
  0x83, 0x76, 0x25, 0x41,
  // "‛" (U+201B)
  0x84, 0x67, 0x62, 0x04,
  // "“" (U+201C)
  0x18, 0x91, 0x42, 0x26, 0x18, 0x06, 0x7C, 0x10,
  // "”" (U+201D)
  0x89, 0x17, 0x6C, 0x12, 0x67, 0x04, 0x13, 0x10,
  // "„" (U+201E)
  0x89, 0x17, 0x6C, 0x12, 0x57, 0x04, 0x13, 0x10,
  // "‟" (U+201F)
  0x85, 0x67, 0xC1, 0x62, 0x82, 0x81, 0x42, 0x20,
  // "†" (U+2020)
  0x10, 0x80, 0x22, 0x06, 0x28, 0x57, 0xA8, 0x30, 0x93, 0x20, 0x80, 0x22, 0x07, 0x30, 0x63, 0x05,
  0x20,
  // "‡" (U+2021)
  0x18, 0x94, 0x81, 0x04, 0x95, 0x22, 0x83, 0x10, 0x61, 0x28, 0x94, 0x61, 0x02, 0x83, 0x15, 0x96,
  0x20, 0x71, 0x10,
  // "•" (U+2022)
  0x87, 0x29, 0x18, 0xF7, 0x5E, 0x30,
  // "…" (U+2026)
  0x18, 0x93, 0x10, 0x10, 0x10, 0x48, 0x0C, 0x0A, 0x10,
  // "‰" (U+2030)
  0x84, 0x37, 0x60, 0x61, 0x48, 0x38, 0x1A, 0x07, 0x58, 0x39, 0x1B, 0x43, 0x58, 0xA2, 0x72, 0xA8,
  0x36, 0x31, 0x64, 0x16, 0x56, 0xA0, 0xA8, 0x1A, 0x28, 0x67, 0x0A, 0x0B, 0x91, 0xB2, 0x86, 0x70,
  0x66, 0x64, 0x77,
  // "‹" (U+2039)
  0x18, 0x53, 0x19, 0x57, 0x08,
  // "›" (U+203A)
  0x02, 0x20, 0x10, 0x92, 0x82, 0xB1, 0x34, 0x10,
  // "⁄" (U+2044)
  0x30, 0x82, 0x03, 0x05, 0x20, 0x73, 0x07, 0x20, 0x60, 0x12, 0x08, 0x20, 0x30, 0x42,
  // "™" (U+2122)
  0x8A, 0x3A, 0xEB, 0xC0, 0xB4, 0x17, 0x1B, 0x9C, 0x03, 0xE4, 0xAA, 0xC4,
  // "⅒" (U+2152)
  0x40, 0x84, 0x83, 0x3A, 0x03, 0x55, 0x81, 0xB0, 0x76, 0x89, 0x7B, 0x07, 0x3A, 0x26, 0x42, 0x89,
  0x10, 0xBA, 0x1A, 0x20, 0x82, 0x89, 0x3B, 0x91, 0xA0, 0x34, 0x02, 0x85, 0x63,
  // "ﬁ" (U+FB01)
  0x18, 0x26, 0x6A, 0x32, 0x81, 0xB0, 0x12, 0x83, 0x4D, 0x69, 0x62, 0x82, 0xB0, 0x46, 0x28, 0x2B,
  0x04, 0x62, 0x89, 0x1B, 0x04, 0x60, 0x6D, 0x3A, 0xB1,
  // "ﬂ" (U+FB02)
  0x18, 0x27, 0x6B, 0x62, 0x89, 0x0B, 0x05, 0x60, 0x4D, 0x54, 0x62, 0x82, 0xB0, 0x46, 0x28, 0x2B,
  0x04, 0x62, 0x89, 0x1B, 0x04, 0x60, 0x6D, 0x3A, 0xB1,
};

const Font& font_NotoSerif_Regular_8() {
  static SmoothFont font(font_NotoSerif_Regular_8_data);
  return font;
}

}  // namespace roo_display
