#include "8.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSans-Italic (Noto Sans Italic)
// Generated on Thu Mar 30 22:28:01 CEST 2023
static const uint8_t font_NotoSans_Italic_8_data[] PROGMEM = {
  
  // Header
  0x01, 0x01, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x01, 0x7A,
  0xFE, 0xFE, 0x08, 0x0A, 0x07, 0xFE, 0x04, 0x01, 0x09, 0x03, 0x02, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x00, 0x01, 0x02, 0x07, 0x02, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x01, 0x05, 0x03, 0x07, 0x03, 0x00, 0x0C, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x05, 0x07, 0x05, 0x00, 0x12, // "#" (U+0023)
  0x00, 0x24, 0x00, 0x01, 0x03, 0x07, 0x04, 0x00, 0x29, // "$" (U+0024)
  0x00, 0x25, 0x00, 0x01, 0x05, 0x07, 0x06, 0x00, 0x38, // "%" (U+0025)
  0x00, 0x26, 0x00, 0x01, 0x04, 0x07, 0x05, 0x00, 0x4F, // "&" (U+0026)
  0x00, 0x27, 0x01, 0x06, 0x01, 0x07, 0x02, 0x00, 0x64, // "'" (U+0027)
  0x00, 0x28, 0x00, 0x00, 0x02, 0x07, 0x02, 0x00, 0x66, // "(" (U+0028)
  0x00, 0x29, 0xFF, 0x00, 0x01, 0x07, 0x02, 0x00, 0x74, // ")" (U+0029)
  0x00, 0x2A, 0x01, 0x03, 0x04, 0x07, 0x04, 0x00, 0x81, // "*" (U+002A)
  0x00, 0x2B, 0x00, 0x02, 0x04, 0x05, 0x05, 0x00, 0x8C, // "+" (U+002B)
  0x00, 0x2C, 0xFF, 0x00, 0x01, 0x01, 0x02, 0x00, 0x95, // "," (U+002C)
  0x00, 0x2D, 0x00, 0x03, 0x02, 0x03, 0x03, 0x00, 0x99, // "-" (U+002D)
  0x00, 0x2E, 0x00, 0x01, 0x00, 0x01, 0x02, 0x00, 0x9C, // "." (U+002E)
  0x00, 0x2F, 0xFF, 0x01, 0x03, 0x07, 0x03, 0x00, 0x9D, // "/" (U+002F)
  0x00, 0x30, 0x00, 0x01, 0x04, 0x07, 0x04, 0x00, 0xAD, // "0" (U+0030)
  0x00, 0x31, 0x01, 0x01, 0x03, 0x07, 0x04, 0x00, 0xC1, // "1" (U+0031)
  0x00, 0x32, 0x00, 0x01, 0x04, 0x07, 0x04, 0x00, 0xCE, // "2" (U+0032)
  0x00, 0x33, 0x00, 0x01, 0x04, 0x07, 0x04, 0x00, 0xE3, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x01, 0x04, 0x07, 0x04, 0x00, 0xF6, // "4" (U+0034)
  0x00, 0x35, 0x00, 0x01, 0x04, 0x07, 0x04, 0x01, 0x0A, // "5" (U+0035)
  0x00, 0x36, 0x00, 0x01, 0x04, 0x07, 0x04, 0x01, 0x1A, // "6" (U+0036)
  0x00, 0x37, 0x00, 0x01, 0x04, 0x07, 0x04, 0x01, 0x2E, // "7" (U+0037)
  0x00, 0x38, 0x00, 0x01, 0x04, 0x07, 0x04, 0x01, 0x40, // "8" (U+0038)
  0x00, 0x39, 0x00, 0x01, 0x04, 0x07, 0x04, 0x01, 0x53, // "9" (U+0039)
  0x00, 0x3A, 0x00, 0x01, 0x01, 0x05, 0x02, 0x01, 0x65, // ":" (U+003A)
  0x00, 0x3B, 0xFF, 0x00, 0x01, 0x05, 0x02, 0x01, 0x69, // ";" (U+003B)
  0x00, 0x3C, 0x00, 0x02, 0x04, 0x05, 0x05, 0x01, 0x71, // "<" (U+003C)
  0x00, 0x3D, 0x00, 0x03, 0x04, 0x05, 0x05, 0x01, 0x7B, // "=" (U+003D)
  0x00, 0x3E, 0x00, 0x02, 0x04, 0x05, 0x05, 0x01, 0x83, // ">" (U+003E)
  0x00, 0x3F, 0x00, 0x01, 0x03, 0x07, 0x03, 0x01, 0x8D, // "?" (U+003F)
  0x00, 0x40, 0x00, 0x00, 0x06, 0x07, 0x07, 0x01, 0x9E, // "@" (U+0040)
  0x00, 0x41, 0xFF, 0x01, 0x03, 0x07, 0x05, 0x01, 0xBC, // "A" (U+0041)
  0x00, 0x42, 0x00, 0x01, 0x04, 0x07, 0x05, 0x01, 0xD0, // "B" (U+0042)
  0x00, 0x43, 0x00, 0x01, 0x04, 0x07, 0x05, 0x01, 0xE3, // "C" (U+0043)
  0x00, 0x44, 0x00, 0x01, 0x04, 0x07, 0x05, 0x01, 0xF5, // "D" (U+0044)
  0x00, 0x45, 0x00, 0x01, 0x04, 0x07, 0x04, 0x02, 0x0A, // "E" (U+0045)
  0x00, 0x46, 0x00, 0x01, 0x04, 0x07, 0x04, 0x02, 0x1C, // "F" (U+0046)
  0x00, 0x47, 0x00, 0x01, 0x05, 0x07, 0x05, 0x02, 0x2D, // "G" (U+0047)
  0x00, 0x48, 0x00, 0x01, 0x05, 0x07, 0x05, 0x02, 0x44, // "H" (U+0048)
  0x00, 0x49, 0x00, 0x01, 0x02, 0x07, 0x03, 0x02, 0x5C, // "I" (U+0049)
  0x00, 0x4A, 0xFE, 0x00, 0x02, 0x07, 0x02, 0x02, 0x69, // "J" (U+004A)
  0x00, 0x4B, 0x00, 0x01, 0x04, 0x07, 0x05, 0x02, 0x7B, // "K" (U+004B)
  0x00, 0x4C, 0x00, 0x01, 0x03, 0x07, 0x04, 0x02, 0x8F, // "L" (U+004C)
  0x00, 0x4D, 0x00, 0x01, 0x06, 0x07, 0x07, 0x02, 0xA0, // "M" (U+004D)
  0x00, 0x4E, 0x00, 0x01, 0x05, 0x07, 0x06, 0x02, 0xBB, // "N" (U+004E)
  0x00, 0x4F, 0x00, 0x01, 0x05, 0x07, 0x06, 0x02, 0xD2, // "O" (U+004F)
  0x00, 0x50, 0x00, 0x01, 0x04, 0x07, 0x05, 0x02, 0xEB, // "P" (U+0050)
  0x00, 0x51, 0x00, 0xFF, 0x05, 0x07, 0x06, 0x02, 0xFD, // "Q" (U+0051)
  0x00, 0x52, 0x00, 0x01, 0x04, 0x07, 0x05, 0x03, 0x19, // "R" (U+0052)
  0x00, 0x53, 0x00, 0x01, 0x03, 0x07, 0x04, 0x03, 0x2C, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x04, 0x07, 0x04, 0x03, 0x3D, // "T" (U+0054)
  0x00, 0x55, 0x00, 0x01, 0x05, 0x07, 0x05, 0x03, 0x4D, // "U" (U+0055)
  0x00, 0x56, 0x00, 0x01, 0x04, 0x07, 0x04, 0x03, 0x65, // "V" (U+0056)
  0x00, 0x57, 0x00, 0x01, 0x07, 0x07, 0x07, 0x03, 0x79, // "W" (U+0057)
  0x00, 0x58, 0xFF, 0x01, 0x04, 0x07, 0x04, 0x03, 0x98, // "X" (U+0058)
  0x00, 0x59, 0x00, 0x01, 0x04, 0x07, 0x04, 0x03, 0xAF, // "Y" (U+0059)
  0x00, 0x5A, 0x00, 0x01, 0x04, 0x07, 0x04, 0x03, 0xC1, // "Z" (U+005A)
  0x00, 0x5B, 0x00, 0x00, 0x02, 0x07, 0x02, 0x03, 0xD5, // "[" (U+005B)
  0x00, 0x5C, 0x00, 0x01, 0x02, 0x07, 0x03, 0x03, 0xE3, // "\" (U+005C)
  0x00, 0x5D, 0xFF, 0x00, 0x02, 0x07, 0x02, 0x03, 0xEF, // "]" (U+005D)
  0x00, 0x5E, 0x00, 0x03, 0x04, 0x06, 0x05, 0x04, 0x01, // "^" (U+005E)
  0x00, 0x5F, 0xFF, 0xFF, 0x02, 0xFF, 0x03, 0x04, 0x0D, // "_" (U+005F)
  0x00, 0x60, 0x01, 0x07, 0x02, 0x08, 0x02, 0x04, 0x10, // "`" (U+0060)
  0x00, 0x61, 0x00, 0x01, 0x04, 0x05, 0x05, 0x04, 0x13, // "a" (U+0061)
  0x00, 0x62, 0x00, 0x01, 0x04, 0x07, 0x05, 0x04, 0x21, // "b" (U+0062)
  0x00, 0x63, 0x00, 0x01, 0x03, 0x05, 0x04, 0x04, 0x33, // "c" (U+0063)
  0x00, 0x64, 0x00, 0x01, 0x04, 0x07, 0x05, 0x04, 0x40, // "d" (U+0064)
  0x00, 0x65, 0x00, 0x01, 0x03, 0x05, 0x04, 0x04, 0x51, // "e" (U+0065)
  0x00, 0x66, 0xFF, 0xFF, 0x03, 0x07, 0x03, 0x04, 0x5D, // "f" (U+0066)
  0x00, 0x67, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x04, 0x73, // "g" (U+0067)
  0x00, 0x68, 0x00, 0x01, 0x04, 0x07, 0x05, 0x04, 0x86, // "h" (U+0068)
  0x00, 0x69, 0x00, 0x01, 0x01, 0x07, 0x02, 0x04, 0x98, // "i" (U+0069)
  0x00, 0x6A, 0xFF, 0xFF, 0x01, 0x07, 0x02, 0x04, 0xA0, // "j" (U+006A)
  0x00, 0x6B, 0x00, 0x01, 0x03, 0x07, 0x04, 0x04, 0xAE, // "k" (U+006B)
  0x00, 0x6C, 0x00, 0x01, 0x02, 0x07, 0x02, 0x04, 0xBE, // "l" (U+006C)
  0x00, 0x6D, 0x00, 0x01, 0x06, 0x05, 0x07, 0x04, 0xCA, // "m" (U+006D)
  0x00, 0x6E, 0x00, 0x01, 0x04, 0x05, 0x05, 0x04, 0xDD, // "n" (U+006E)
  0x00, 0x6F, 0x00, 0x01, 0x04, 0x05, 0x05, 0x04, 0xEB, // "o" (U+006F)
  0x00, 0x70, 0xFF, 0xFF, 0x04, 0x05, 0x05, 0x04, 0xF9, // "p" (U+0070)
  0x00, 0x71, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x05, 0x0E, // "q" (U+0071)
  0x00, 0x72, 0x00, 0x01, 0x03, 0x05, 0x03, 0x05, 0x21, // "r" (U+0072)
  0x00, 0x73, 0x00, 0x01, 0x03, 0x05, 0x03, 0x05, 0x2C, // "s" (U+0073)
  0x00, 0x74, 0x00, 0x01, 0x02, 0x06, 0x03, 0x05, 0x37, // "t" (U+0074)
  0x00, 0x75, 0x00, 0x01, 0x04, 0x05, 0x05, 0x05, 0x42, // "u" (U+0075)
  0x00, 0x76, 0x00, 0x01, 0x03, 0x05, 0x04, 0x05, 0x50, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x01, 0x05, 0x05, 0x06, 0x05, 0x5C, // "w" (U+0077)
  0x00, 0x78, 0x00, 0x01, 0x03, 0x05, 0x04, 0x05, 0x6D, // "x" (U+0078)
  0x00, 0x79, 0xFF, 0xFF, 0x03, 0x05, 0x04, 0x05, 0x79, // "y" (U+0079)
  0x00, 0x7A, 0x00, 0x01, 0x03, 0x05, 0x04, 0x05, 0x8C, // "z" (U+007A)
  0x00, 0x7B, 0x00, 0x00, 0x03, 0x07, 0x03, 0x05, 0x98, // "{" (U+007B)
  0x00, 0x7C, 0x02, 0xFF, 0x02, 0x07, 0x04, 0x05, 0xAB, // "|" (U+007C)
  0x00, 0x7D, 0xFF, 0x00, 0x02, 0x07, 0x03, 0x05, 0xAD, // "}" (U+007D)
  0x00, 0x7E, 0x00, 0x03, 0x04, 0x04, 0x05, 0x05, 0xBF, // "~" (U+007E)
  0x00, 0xA1, 0x00, 0xFF, 0x01, 0x05, 0x02, 0x05, 0xC6, // "¡" (U+00A1)
  0x00, 0xA2, 0x00, 0x01, 0x03, 0x07, 0x04, 0x05, 0xCF, // "¢" (U+00A2)
  0x00, 0xA3, 0x00, 0x01, 0x04, 0x07, 0x04, 0x05, 0xDE, // "£" (U+00A3)
  0x00, 0xA4, 0x00, 0x02, 0x03, 0x06, 0x04, 0x05, 0xF1, // "¤" (U+00A4)
  0x00, 0xA5, 0x00, 0x01, 0x04, 0x07, 0x04, 0x05, 0xFC, // "¥" (U+00A5)
  0x00, 0xA6, 0x02, 0xFF, 0x02, 0x07, 0x04, 0x06, 0x10, // "¦" (U+00A6)
  0x00, 0xA7, 0x00, 0x01, 0x03, 0x07, 0x04, 0x06, 0x14, // "§" (U+00A7)
  0x00, 0xA8, 0x01, 0x07, 0x03, 0x07, 0x04, 0x06, 0x24, // "¨" (U+00A8)
  0x00, 0xA9, 0x00, 0x01, 0x06, 0x07, 0x07, 0x06, 0x27, // "©" (U+00A9)
  0x00, 0xAA, 0x00, 0x04, 0x02, 0x06, 0x03, 0x06, 0x42, // "ª" (U+00AA)
  0x00, 0xAB, 0x00, 0x01, 0x03, 0x04, 0x04, 0x06, 0x48, // "«" (U+00AB)
  0x00, 0xAC, 0x00, 0x02, 0x04, 0x04, 0x05, 0x06, 0x52, // "¬" (U+00AC)
  0x00, 0xAE, 0x00, 0x01, 0x06, 0x07, 0x07, 0x06, 0x5A, // "®" (U+00AE)
  0x00, 0xAF, 0x00, 0x08, 0x03, 0x08, 0x03, 0x06, 0x74, // "¯" (U+00AF)
  0x00, 0xB0, 0x00, 0x05, 0x02, 0x07, 0x03, 0x06, 0x77, // "°" (U+00B0)
  0x00, 0xB1, 0x00, 0x01, 0x04, 0x05, 0x05, 0x06, 0x7D, // "±" (U+00B1)
  0x00, 0xB2, 0x00, 0x04, 0x03, 0x07, 0x03, 0x06, 0x8A, // "²" (U+00B2)
  0x00, 0xB3, 0x00, 0x04, 0x02, 0x07, 0x03, 0x06, 0x93, // "³" (U+00B3)
  0x00, 0xB4, 0x01, 0x07, 0x02, 0x08, 0x02, 0x06, 0x9B, // "´" (U+00B4)
  0x00, 0xB5, 0xFF, 0xFF, 0x04, 0x05, 0x05, 0x06, 0x9E, // "µ" (U+00B5)
  0x00, 0xB6, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x06, 0xB3, // "¶" (U+00B6)
  0x00, 0xB7, 0x00, 0x03, 0x00, 0x03, 0x02, 0x06, 0xCC, // "·" (U+00B7)
  0x00, 0xB8, 0xFF, 0xFF, 0x00, 0x01, 0x02, 0x06, 0xCD, // "¸" (U+00B8)
  0x00, 0xB9, 0x01, 0x04, 0x02, 0x07, 0x03, 0x06, 0xD1, // "¹" (U+00B9)
  0x00, 0xBA, 0x00, 0x04, 0x02, 0x06, 0x03, 0x06, 0xD6, // "º" (U+00BA)
  0x00, 0xBB, 0x00, 0x01, 0x03, 0x04, 0x04, 0x06, 0xDC, // "»" (U+00BB)
  0x00, 0xBC, 0x01, 0x01, 0x05, 0x07, 0x06, 0x06, 0xE6, // "¼" (U+00BC)
  0x00, 0xBD, 0x01, 0x01, 0x06, 0x07, 0x06, 0x06, 0xF8, // "½" (U+00BD)
  0x00, 0xBE, 0x00, 0x01, 0x05, 0x07, 0x06, 0x07, 0x0F, // "¾" (U+00BE)
  0x00, 0xBF, 0xFF, 0xFE, 0x02, 0x04, 0x03, 0x07, 0x25, // "¿" (U+00BF)
  0x00, 0xC0, 0xFF, 0x01, 0x03, 0x09, 0x05, 0x07, 0x36, // "À" (U+00C0)
  0x00, 0xC1, 0xFF, 0x01, 0x04, 0x09, 0x05, 0x07, 0x4E, // "Á" (U+00C1)
  0x00, 0xC2, 0xFF, 0x01, 0x04, 0x09, 0x05, 0x07, 0x68, // "Â" (U+00C2)
  0x00, 0xC3, 0xFF, 0x01, 0x04, 0x07, 0x05, 0x07, 0x84, // "Ã" (U+00C3)
  0x00, 0xC4, 0xFF, 0x01, 0x03, 0x08, 0x05, 0x07, 0x9A, // "Ä" (U+00C4)
  0x00, 0xC5, 0xFF, 0x01, 0x03, 0x08, 0x05, 0x07, 0xB1, // "Å" (U+00C5)
  0x00, 0xC6, 0xFF, 0x01, 0x06, 0x07, 0x07, 0x07, 0xC7, // "Æ" (U+00C6)
  0x00, 0xC7, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x07, 0xE2, // "Ç" (U+00C7)
  0x00, 0xC8, 0x00, 0x01, 0x04, 0x09, 0x04, 0x07, 0xF9, // "È" (U+00C8)
  0x00, 0xC9, 0x00, 0x01, 0x04, 0x09, 0x04, 0x08, 0x0E, // "É" (U+00C9)
  0x00, 0xCA, 0x00, 0x01, 0x04, 0x09, 0x04, 0x08, 0x24, // "Ê" (U+00CA)
  0x00, 0xCB, 0x00, 0x01, 0x04, 0x08, 0x04, 0x08, 0x3B, // "Ë" (U+00CB)
  0x00, 0xCC, 0x00, 0x01, 0x02, 0x09, 0x03, 0x08, 0x50, // "Ì" (U+00CC)
  0x00, 0xCD, 0x00, 0x01, 0x03, 0x09, 0x03, 0x08, 0x60, // "Í" (U+00CD)
  0x00, 0xCE, 0x00, 0x01, 0x03, 0x09, 0x03, 0x08, 0x74, // "Î" (U+00CE)
  0x00, 0xCF, 0x00, 0x01, 0x02, 0x08, 0x03, 0x08, 0x89, // "Ï" (U+00CF)
  0x00, 0xD0, 0x00, 0x01, 0x04, 0x07, 0x05, 0x08, 0x98, // "Ð" (U+00D0)
  0x00, 0xD1, 0x00, 0x01, 0x05, 0x07, 0x06, 0x08, 0xAD, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x00, 0x01, 0x05, 0x09, 0x06, 0x08, 0xC4, // "Ò" (U+00D2)
  0x00, 0xD3, 0x00, 0x01, 0x05, 0x09, 0x06, 0x08, 0xE0, // "Ó" (U+00D3)
  0x00, 0xD4, 0x00, 0x01, 0x05, 0x09, 0x06, 0x08, 0xFD, // "Ô" (U+00D4)
  0x00, 0xD5, 0x00, 0x01, 0x05, 0x07, 0x06, 0x09, 0x1A, // "Õ" (U+00D5)
  0x00, 0xD6, 0x00, 0x01, 0x05, 0x08, 0x06, 0x09, 0x33, // "Ö" (U+00D6)
  0x00, 0xD7, 0x00, 0x02, 0x03, 0x05, 0x05, 0x09, 0x4F, // "×" (U+00D7)
  0x00, 0xD8, 0x00, 0x01, 0x05, 0x07, 0x06, 0x09, 0x59, // "Ø" (U+00D8)
  0x00, 0xD9, 0x00, 0x01, 0x05, 0x09, 0x05, 0x09, 0x70, // "Ù" (U+00D9)
  0x00, 0xDA, 0x00, 0x01, 0x05, 0x09, 0x05, 0x09, 0x8C, // "Ú" (U+00DA)
  0x00, 0xDB, 0x00, 0x01, 0x05, 0x09, 0x05, 0x09, 0xA8, // "Û" (U+00DB)
  0x00, 0xDC, 0x00, 0x01, 0x05, 0x08, 0x05, 0x09, 0xC6, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x01, 0x04, 0x09, 0x04, 0x09, 0xE1, // "Ý" (U+00DD)
  0x00, 0xDE, 0x00, 0x01, 0x04, 0x07, 0x05, 0x09, 0xF8, // "Þ" (U+00DE)
  0x00, 0xDF, 0xFF, 0xFF, 0x04, 0x07, 0x05, 0x0A, 0x0B, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0A, 0x28, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0A, 0x3A, // "á" (U+00E1)
  0x00, 0xE2, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0A, 0x4C, // "â" (U+00E2)
  0x00, 0xE3, 0x00, 0x01, 0x04, 0x06, 0x05, 0x0A, 0x60, // "ã" (U+00E3)
  0x00, 0xE4, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x70, // "ä" (U+00E4)
  0x00, 0xE5, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x81, // "å" (U+00E5)
  0x00, 0xE6, 0x00, 0x01, 0x06, 0x05, 0x07, 0x0A, 0x94, // "æ" (U+00E6)
  0x00, 0xE7, 0x00, 0xFF, 0x03, 0x05, 0x04, 0x0A, 0xA7, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0A, 0xB8, // "è" (U+00E8)
  0x00, 0xE9, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0A, 0xC8, // "é" (U+00E9)
  0x00, 0xEA, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0A, 0xD8, // "ê" (U+00EA)
  0x00, 0xEB, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0A, 0xEA, // "ë" (U+00EB)
  0x00, 0xEC, 0x00, 0x01, 0x02, 0x08, 0x02, 0x0A, 0xF9, // "ì" (U+00EC)
  0x00, 0xED, 0x00, 0x01, 0x02, 0x08, 0x02, 0x0B, 0x05, // "í" (U+00ED)
  0x00, 0xEE, 0x00, 0x01, 0x02, 0x08, 0x02, 0x0B, 0x11, // "î" (U+00EE)
  0x00, 0xEF, 0x00, 0x01, 0x02, 0x07, 0x02, 0x0B, 0x1E, // "ï" (U+00EF)
  0x00, 0xF0, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0B, 0x29, // "ð" (U+00F0)
  0x00, 0xF1, 0x00, 0x01, 0x04, 0x06, 0x05, 0x0B, 0x40, // "ñ" (U+00F1)
  0x00, 0xF2, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0B, 0x50, // "ò" (U+00F2)
  0x00, 0xF3, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0B, 0x62, // "ó" (U+00F3)
  0x00, 0xF4, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0B, 0x75, // "ô" (U+00F4)
  0x00, 0xF5, 0x00, 0x01, 0x04, 0x06, 0x05, 0x0B, 0x89, // "õ" (U+00F5)
  0x00, 0xF6, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0B, 0x9A, // "ö" (U+00F6)
  0x00, 0xF7, 0x00, 0x02, 0x04, 0x05, 0x05, 0x0B, 0xAB, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x01, 0x04, 0x05, 0x05, 0x0B, 0xB3, // "ø" (U+00F8)
  0x00, 0xF9, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0B, 0xC1, // "ù" (U+00F9)
  0x00, 0xFA, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0B, 0xD3, // "ú" (U+00FA)
  0x00, 0xFB, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0B, 0xE5, // "û" (U+00FB)
  0x00, 0xFC, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0B, 0xF9, // "ü" (U+00FC)
  0x00, 0xFD, 0xFF, 0xFF, 0x03, 0x08, 0x04, 0x0C, 0x0A, // "ý" (U+00FD)
  0x00, 0xFE, 0xFF, 0xFF, 0x04, 0x07, 0x05, 0x0C, 0x21, // "þ" (U+00FE)
  0x00, 0xFF, 0xFF, 0xFF, 0x03, 0x07, 0x04, 0x0C, 0x3A, // "ÿ" (U+00FF)
  0x01, 0x00, 0xFF, 0x01, 0x04, 0x07, 0x05, 0x0C, 0x50, // "Ā" (U+0100)
  0x01, 0x01, 0x00, 0x01, 0x04, 0x06, 0x05, 0x0C, 0x66, // "ā" (U+0101)
  0x01, 0x02, 0xFF, 0x01, 0x04, 0x07, 0x05, 0x0C, 0x76, // "Ă" (U+0102)
  0x01, 0x03, 0x00, 0x01, 0x04, 0x06, 0x05, 0x0C, 0x8C, // "ă" (U+0103)
  0x01, 0x04, 0xFF, 0xFF, 0x03, 0x07, 0x05, 0x0C, 0x9C, // "Ą" (U+0104)
  0x01, 0x05, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x0C, 0xB5, // "ą" (U+0105)
  0x01, 0x06, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0C, 0xC8, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0C, 0xDE, // "ć" (U+0107)
  0x01, 0x08, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0C, 0xEF, // "Ĉ" (U+0108)
  0x01, 0x09, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0D, 0x07, // "ĉ" (U+0109)
  0x01, 0x0A, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0D, 0x19, // "Ċ" (U+010A)
  0x01, 0x0B, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0D, 0x2D, // "ċ" (U+010B)
  0x01, 0x0C, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0D, 0x3B, // "Č" (U+010C)
  0x01, 0x0D, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0D, 0x53, // "č" (U+010D)
  0x01, 0x0E, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0D, 0x64, // "Ď" (U+010E)
  0x01, 0x0F, 0x00, 0x01, 0x05, 0x07, 0x05, 0x0D, 0x7F, // "ď" (U+010F)
  0x01, 0x10, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0D, 0x95, // "Đ" (U+0110)
  0x01, 0x11, 0x00, 0x01, 0x05, 0x07, 0x05, 0x0D, 0xAA, // "đ" (U+0111)
  0x01, 0x12, 0x00, 0x01, 0x04, 0x07, 0x04, 0x0D, 0xBF, // "Ē" (U+0112)
  0x01, 0x13, 0x00, 0x01, 0x04, 0x06, 0x04, 0x0D, 0xD1, // "ē" (U+0113)
  0x01, 0x14, 0x00, 0x01, 0x04, 0x07, 0x04, 0x0D, 0xE1, // "Ĕ" (U+0114)
  0x01, 0x15, 0x00, 0x01, 0x04, 0x06, 0x04, 0x0D, 0xF3, // "ĕ" (U+0115)
  0x01, 0x16, 0x00, 0x01, 0x04, 0x08, 0x04, 0x0E, 0x03, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0E, 0x16, // "ė" (U+0117)
  0x01, 0x18, 0x00, 0xFF, 0x04, 0x07, 0x04, 0x0E, 0x24, // "Ę" (U+0118)
  0x01, 0x19, 0x00, 0xFF, 0x03, 0x05, 0x04, 0x0E, 0x3B, // "ę" (U+0119)
  0x01, 0x1A, 0x00, 0x01, 0x04, 0x09, 0x04, 0x0E, 0x4C, // "Ě" (U+011A)
  0x01, 0x1B, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0E, 0x63, // "ě" (U+011B)
  0x01, 0x1C, 0x00, 0x01, 0x05, 0x09, 0x05, 0x0E, 0x74, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x00, 0xFF, 0x04, 0x08, 0x05, 0x0E, 0x90, // "ĝ" (U+011D)
  0x01, 0x1E, 0x00, 0x01, 0x05, 0x07, 0x05, 0x0E, 0xA8, // "Ğ" (U+011E)
  0x01, 0x1F, 0x00, 0xFF, 0x04, 0x06, 0x05, 0x0E, 0xBF, // "ğ" (U+011F)
  0x01, 0x20, 0x00, 0x01, 0x05, 0x08, 0x05, 0x0E, 0xD4, // "Ġ" (U+0120)
  0x01, 0x21, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0E, 0xEC, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0xFF, 0x05, 0x07, 0x05, 0x0F, 0x01, // "Ģ" (U+0122)
  0x01, 0x23, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0F, 0x1C, // "ģ" (U+0123)
  0x01, 0x24, 0x00, 0x01, 0x05, 0x09, 0x05, 0x0F, 0x34, // "Ĥ" (U+0124)
  0x01, 0x25, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x0F, 0x52, // "ĥ" (U+0125)
  0x01, 0x26, 0x00, 0x01, 0x05, 0x07, 0x05, 0x0F, 0x6A, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0F, 0x83, // "ħ" (U+0127)
  0x01, 0x28, 0x00, 0x01, 0x03, 0x07, 0x03, 0x0F, 0x97, // "Ĩ" (U+0128)
  0x01, 0x29, 0x00, 0x01, 0x02, 0x06, 0x02, 0x0F, 0xA6, // "ĩ" (U+0129)
  0x01, 0x2A, 0x00, 0x01, 0x03, 0x07, 0x03, 0x0F, 0xB0, // "Ī" (U+012A)
  0x01, 0x2B, 0x00, 0x01, 0x03, 0x06, 0x02, 0x0F, 0xBF, // "ī" (U+012B)
  0x01, 0x2C, 0x00, 0x01, 0x03, 0x07, 0x03, 0x0F, 0xCC, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x00, 0x01, 0x02, 0x06, 0x02, 0x0F, 0xDB, // "ĭ" (U+012D)
  0x01, 0x2E, 0xFF, 0xFF, 0x02, 0x07, 0x03, 0x0F, 0xE5, // "Į" (U+012E)
  0x01, 0x2F, 0xFF, 0xFF, 0x01, 0x07, 0x02, 0x0F, 0xF9, // "į" (U+012F)
  0x01, 0x30, 0x00, 0x01, 0x02, 0x08, 0x03, 0x10, 0x06, // "İ" (U+0130)
  0x01, 0x31, 0x00, 0x01, 0x01, 0x05, 0x02, 0x10, 0x14, // "ı" (U+0131)
  0x01, 0x32, 0x00, 0x00, 0x05, 0x07, 0x05, 0x10, 0x1A, // "Ĳ" (U+0132)
  0x01, 0x33, 0x00, 0xFF, 0x03, 0x07, 0x04, 0x10, 0x34, // "ĳ" (U+0133)
  0x01, 0x34, 0xFE, 0x00, 0x03, 0x09, 0x02, 0x10, 0x47, // "Ĵ" (U+0134)
  0x01, 0x35, 0xFF, 0xFF, 0x02, 0x08, 0x02, 0x10, 0x5E, // "ĵ" (U+0135)
  0x01, 0x36, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x10, 0x72, // "Ķ" (U+0136)
  0x01, 0x37, 0x00, 0xFF, 0x03, 0x07, 0x04, 0x10, 0x8A, // "ķ" (U+0137)
  0x01, 0x38, 0x00, 0x01, 0x03, 0x05, 0x04, 0x10, 0x9E, // "ĸ" (U+0138)
  0x01, 0x39, 0x00, 0x01, 0x03, 0x09, 0x04, 0x10, 0xAA, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x00, 0x01, 0x03, 0x0A, 0x02, 0x10, 0xBF, // "ĺ" (U+013A)
  0x01, 0x3B, 0x00, 0xFF, 0x03, 0x07, 0x04, 0x10, 0xD2, // "Ļ" (U+013B)
  0x01, 0x3C, 0xFF, 0xFF, 0x02, 0x07, 0x02, 0x10, 0xE7, // "ļ" (U+013C)
  0x01, 0x3D, 0x00, 0x01, 0x03, 0x07, 0x04, 0x10, 0xFA, // "Ľ" (U+013D)
  0x01, 0x3E, 0x00, 0x01, 0x03, 0x07, 0x02, 0x11, 0x0B, // "ľ" (U+013E)
  0x01, 0x3F, 0x00, 0x01, 0x03, 0x07, 0x04, 0x11, 0x1A, // "Ŀ" (U+013F)
  0x01, 0x40, 0x00, 0x01, 0x02, 0x07, 0x02, 0x11, 0x2A, // "ŀ" (U+0140)
  0x01, 0x41, 0x00, 0x01, 0x03, 0x07, 0x04, 0x11, 0x36, // "Ł" (U+0141)
  0x01, 0x42, 0x00, 0x01, 0x02, 0x07, 0x02, 0x11, 0x46, // "ł" (U+0142)
  0x01, 0x43, 0x00, 0x01, 0x05, 0x09, 0x06, 0x11, 0x52, // "Ń" (U+0143)
  0x01, 0x44, 0x00, 0x01, 0x04, 0x08, 0x05, 0x11, 0x6D, // "ń" (U+0144)
  0x01, 0x45, 0x00, 0xFF, 0x05, 0x07, 0x06, 0x11, 0x7F, // "Ņ" (U+0145)
  0x01, 0x46, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x11, 0x9A, // "ņ" (U+0146)
  0x01, 0x47, 0x00, 0x01, 0x05, 0x09, 0x06, 0x11, 0xAC, // "Ň" (U+0147)
  0x01, 0x48, 0x00, 0x01, 0x04, 0x08, 0x05, 0x11, 0xC8, // "ň" (U+0148)
  0x01, 0x49, 0x00, 0x01, 0x05, 0x07, 0x05, 0x11, 0xDC, // "ŉ" (U+0149)
  0x01, 0x4A, 0x00, 0xFF, 0x05, 0x07, 0x06, 0x11, 0xF1, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x12, 0x0D, // "ŋ" (U+014B)
  0x01, 0x4C, 0x00, 0x01, 0x05, 0x07, 0x06, 0x12, 0x21, // "Ō" (U+014C)
  0x01, 0x4D, 0x00, 0x01, 0x04, 0x06, 0x05, 0x12, 0x3A, // "ō" (U+014D)
  0x01, 0x4E, 0x00, 0x01, 0x05, 0x07, 0x06, 0x12, 0x4A, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x00, 0x01, 0x04, 0x06, 0x05, 0x12, 0x63, // "ŏ" (U+014F)
  0x01, 0x50, 0x00, 0x01, 0x05, 0x08, 0x06, 0x12, 0x73, // "Ő" (U+0150)
  0x01, 0x51, 0x00, 0x01, 0x04, 0x07, 0x05, 0x12, 0x8E, // "ő" (U+0151)
  0x01, 0x52, 0x00, 0x01, 0x07, 0x07, 0x07, 0x12, 0xA1, // "Œ" (U+0152)
  0x01, 0x53, 0x00, 0x01, 0x06, 0x05, 0x07, 0x12, 0xBE, // "œ" (U+0153)
  0x01, 0x54, 0x00, 0x01, 0x04, 0x09, 0x05, 0x12, 0xD2, // "Ŕ" (U+0154)
  0x01, 0x55, 0x00, 0x01, 0x03, 0x08, 0x03, 0x12, 0xE9, // "ŕ" (U+0155)
  0x01, 0x56, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x12, 0xF8, // "Ŗ" (U+0156)
  0x01, 0x57, 0xFF, 0xFF, 0x03, 0x05, 0x03, 0x13, 0x0F, // "ŗ" (U+0157)
  0x01, 0x58, 0x00, 0x01, 0x04, 0x09, 0x05, 0x13, 0x1F, // "Ř" (U+0158)
  0x01, 0x59, 0x00, 0x01, 0x03, 0x08, 0x03, 0x13, 0x38, // "ř" (U+0159)
  0x01, 0x5A, 0x00, 0x01, 0x03, 0x09, 0x04, 0x13, 0x48, // "Ś" (U+015A)
  0x01, 0x5B, 0x00, 0x01, 0x03, 0x08, 0x03, 0x13, 0x5D, // "ś" (U+015B)
  0x01, 0x5C, 0x00, 0x01, 0x04, 0x09, 0x04, 0x13, 0x6D, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x00, 0x01, 0x03, 0x08, 0x03, 0x13, 0x84, // "ŝ" (U+015D)
  0x01, 0x5E, 0x00, 0xFF, 0x03, 0x07, 0x04, 0x13, 0x95, // "Ş" (U+015E)
  0x01, 0x5F, 0x00, 0xFF, 0x03, 0x05, 0x03, 0x13, 0xAA, // "ş" (U+015F)
  0x01, 0x60, 0x00, 0x01, 0x04, 0x09, 0x04, 0x13, 0xB9, // "Š" (U+0160)
  0x01, 0x61, 0x00, 0x01, 0x03, 0x08, 0x03, 0x13, 0xD1, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFF, 0x04, 0x07, 0x04, 0x13, 0xE1, // "Ţ" (U+0162)
  0x01, 0x63, 0x00, 0xFF, 0x02, 0x06, 0x03, 0x13, 0xF6, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x04, 0x09, 0x04, 0x14, 0x04, // "Ť" (U+0164)
  0x01, 0x65, 0x00, 0x01, 0x03, 0x07, 0x03, 0x14, 0x19, // "ť" (U+0165)
  0x01, 0x66, 0x00, 0x01, 0x04, 0x07, 0x04, 0x14, 0x2A, // "Ŧ" (U+0166)
  0x01, 0x67, 0x00, 0x01, 0x02, 0x06, 0x03, 0x14, 0x3B, // "ŧ" (U+0167)
  0x01, 0x68, 0x00, 0x01, 0x05, 0x07, 0x05, 0x14, 0x46, // "Ũ" (U+0168)
  0x01, 0x69, 0x00, 0x01, 0x04, 0x06, 0x05, 0x14, 0x5E, // "ũ" (U+0169)
  0x01, 0x6A, 0x00, 0x01, 0x05, 0x07, 0x05, 0x14, 0x6E, // "Ū" (U+016A)
  0x01, 0x6B, 0x00, 0x01, 0x04, 0x06, 0x05, 0x14, 0x86, // "ū" (U+016B)
  0x01, 0x6C, 0x00, 0x01, 0x05, 0x07, 0x05, 0x14, 0x96, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x00, 0x01, 0x04, 0x06, 0x05, 0x14, 0xAE, // "ŭ" (U+016D)
  0x01, 0x6E, 0x00, 0x01, 0x05, 0x08, 0x05, 0x14, 0xBE, // "Ů" (U+016E)
  0x01, 0x6F, 0x00, 0x01, 0x04, 0x07, 0x05, 0x14, 0xD9, // "ů" (U+016F)
  0x01, 0x70, 0x00, 0x01, 0x05, 0x08, 0x05, 0x14, 0xEC, // "Ű" (U+0170)
  0x01, 0x71, 0x00, 0x01, 0x04, 0x07, 0x05, 0x15, 0x07, // "ű" (U+0171)
  0x01, 0x72, 0x00, 0xFF, 0x05, 0x07, 0x05, 0x15, 0x1A, // "Ų" (U+0172)
  0x01, 0x73, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x15, 0x37, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x07, 0x09, 0x07, 0x15, 0x4A, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x05, 0x08, 0x06, 0x15, 0x6F, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x01, 0x04, 0x09, 0x04, 0x15, 0x86, // "Ŷ" (U+0176)
  0x01, 0x77, 0xFF, 0xFF, 0x03, 0x08, 0x04, 0x15, 0x9D, // "ŷ" (U+0177)
  0x01, 0x78, 0x00, 0x01, 0x04, 0x08, 0x04, 0x15, 0xB5, // "Ÿ" (U+0178)
  0x01, 0x79, 0x00, 0x01, 0x04, 0x09, 0x04, 0x15, 0xCA, // "Ź" (U+0179)
  0x01, 0x7A, 0x00, 0x01, 0x03, 0x08, 0x04, 0x15, 0xE2, // "ź" (U+017A)
  0x01, 0x7B, 0x00, 0x01, 0x04, 0x08, 0x04, 0x15, 0xF3, // "Ż" (U+017B)
  0x01, 0x7C, 0x00, 0x01, 0x03, 0x07, 0x04, 0x16, 0x09, // "ż" (U+017C)
  0x01, 0x7D, 0x00, 0x01, 0x04, 0x09, 0x04, 0x16, 0x17, // "Ž" (U+017D)
  0x01, 0x7E, 0x00, 0x01, 0x03, 0x08, 0x04, 0x16, 0x31, // "ž" (U+017E)
  0x01, 0x7F, 0xFF, 0xFF, 0x03, 0x07, 0x02, 0x16, 0x42, // "ſ" (U+017F)
  0x03, 0xA9, 0x00, 0x01, 0x05, 0x07, 0x06, 0x16, 0x55, // "Ω" (U+03A9)
  0x03, 0xBC, 0xFF, 0xFF, 0x04, 0x05, 0x05, 0x16, 0x6E, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x01, 0x04, 0x05, 0x05, 0x16, 0x83, // "π" (U+03C0)
  0x20, 0x13, 0x00, 0x03, 0x03, 0x03, 0x04, 0x16, 0x91, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x03, 0x07, 0x03, 0x08, 0x16, 0x94, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x01, 0x04, 0x07, 0x04, 0x16, 0x98, // "€" (U+20AC)
  0x20, 0xBF, 0x00, 0x00, 0x04, 0x08, 0x04, 0x16, 0xAA, // "₿" (U+20BF)
  0x20, 0x18, 0x00, 0x06, 0x01, 0x07, 0x01, 0x16, 0xC1, // "‘" (U+2018)
  0x20, 0x19, 0x00, 0x06, 0x01, 0x07, 0x01, 0x16, 0xC4, // "’" (U+2019)
  0x20, 0x1A, 0xFF, 0x00, 0x00, 0x01, 0x02, 0x16, 0xC7, // "‚" (U+201A)
  0x20, 0x1B, 0x00, 0x05, 0x01, 0x07, 0x01, 0x16, 0xCA, // "‛" (U+201B)
  0x20, 0x1C, 0x00, 0x05, 0x03, 0x07, 0x03, 0x16, 0xCE, // "“" (U+201C)
  0x20, 0x1D, 0x00, 0x05, 0x03, 0x07, 0x03, 0x16, 0xD6, // "”" (U+201D)
  0x20, 0x1E, 0xFF, 0x00, 0x02, 0x02, 0x03, 0x16, 0xDE, // "„" (U+201E)
  0x20, 0x1F, 0x00, 0x05, 0x02, 0x07, 0x03, 0x16, 0xE6, // "‟" (U+201F)
  0x20, 0x20, 0x01, 0x01, 0x03, 0x07, 0x04, 0x16, 0xEC, // "†" (U+2020)
  0x20, 0x21, 0x00, 0x01, 0x03, 0x07, 0x04, 0x16, 0xF8, // "‡" (U+2021)
  0x20, 0x22, 0x00, 0x03, 0x02, 0x04, 0x03, 0x17, 0x07, // "•" (U+2022)
  0x20, 0x26, 0x00, 0x01, 0x04, 0x01, 0x06, 0x17, 0x0B, // "…" (U+2026)
  0x20, 0x30, 0x00, 0x01, 0x08, 0x07, 0x09, 0x17, 0x0F, // "‰" (U+2030)
  0x20, 0x39, 0x00, 0x01, 0x01, 0x04, 0x02, 0x17, 0x2F, // "‹" (U+2039)
  0x20, 0x3A, 0x00, 0x01, 0x01, 0x04, 0x02, 0x17, 0x34, // "›" (U+203A)
  0x20, 0x44, 0xFE, 0x01, 0x02, 0x07, 0x01, 0x17, 0x39, // "⁄" (U+2044)
  0x21, 0x22, 0x00, 0x03, 0x05, 0x06, 0x06, 0x17, 0x4A, // "™" (U+2122)
  0x21, 0x52, 0x01, 0x01, 0x07, 0x07, 0x08, 0x17, 0x58, // "⅒" (U+2152)
  0xFB, 0x01, 0xFF, 0xFF, 0x04, 0x07, 0x05, 0x17, 0x72, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0xFF, 0xFF, 0x05, 0x07, 0x05, 0x17, 0x8D, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x01, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0xC0, 0x01, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x01, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x01, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x01, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x01, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x01, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x01, 0x00, 0x01, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x02, 0x01, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x04, 0x01, // "Ą (U+0022 U+0104)
  0x00, 0x27, 0x00, 0x41, 0x01, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0xC0, 0x01, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x01, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x01, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x01, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x01, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x01, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x01, 0x00, 0x01, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x02, 0x01, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x04, 0x01, // 'Ą (U+0027 U+0104)
  0x00, 0x2C, 0x00, 0x54, 0x01, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x01, 0x62, 0x01, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x01, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x01, // ,Ŧ (U+002C U+0166)
  0x00, 0x2E, 0x00, 0x54, 0x01, // .T (U+002E U+0054)
  0x00, 0x2E, 0x01, 0x62, 0x01, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x01, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x01, // .Ŧ (U+002E U+0166)
  0x00, 0x30, 0x20, 0x44, 0x01, // 0⁄ (U+0030 U+2044)
  0x00, 0x31, 0x20, 0x44, 0x01, // 1⁄ (U+0031 U+2044)
  0x00, 0x32, 0x20, 0x44, 0x01, // 2⁄ (U+0032 U+2044)
  0x00, 0x33, 0x20, 0x44, 0x01, // 3⁄ (U+0033 U+2044)
  0x00, 0x34, 0x20, 0x44, 0x01, // 4⁄ (U+0034 U+2044)
  0x00, 0x35, 0x20, 0x44, 0x01, // 5⁄ (U+0035 U+2044)
  0x00, 0x36, 0x20, 0x44, 0x01, // 6⁄ (U+0036 U+2044)
  0x00, 0x37, 0x20, 0x44, 0x01, // 7⁄ (U+0037 U+2044)
  0x00, 0x38, 0x20, 0x44, 0x01, // 8⁄ (U+0038 U+2044)
  0x00, 0x39, 0x20, 0x44, 0x01, // 9⁄ (U+0039 U+2044)
  0x00, 0x41, 0x00, 0x22, 0x01, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x01, // A' (U+0041 U+0027)
  0x00, 0x41, 0x20, 0x19, 0x01, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1D, 0x01, // A” (U+0041 U+201D)
  0x00, 0x4C, 0x00, 0x22, 0x01, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x01, // L' (U+004C U+0027)
  0x00, 0x4C, 0x20, 0x19, 0x01, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1D, 0x01, // L” (U+004C U+201D)
  0x00, 0x50, 0x00, 0x2C, 0x01, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x01, // P. (U+0050 U+002E)
  0x00, 0x50, 0x20, 0x1A, 0x01, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x01, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x01, // P… (U+0050 U+2026)
  0x00, 0x54, 0x00, 0x61, 0x01, // Ta (U+0054 U+0061)
  0x00, 0x54, 0x00, 0x63, 0x01, // Tc (U+0054 U+0063)
  0x00, 0x54, 0x00, 0x64, 0x01, // Td (U+0054 U+0064)
  0x00, 0x54, 0x00, 0x65, 0x01, // Te (U+0054 U+0065)
  0x00, 0x54, 0x00, 0x67, 0x01, // Tg (U+0054 U+0067)
  0x00, 0x54, 0x00, 0x6F, 0x01, // To (U+0054 U+006F)
  0x00, 0x54, 0x00, 0x71, 0x01, // Tq (U+0054 U+0071)
  0x00, 0x54, 0x00, 0xE0, 0x01, // Tà (U+0054 U+00E0)
  0x00, 0x54, 0x00, 0xE1, 0x01, // Tá (U+0054 U+00E1)
  0x00, 0x54, 0x00, 0xE2, 0x01, // Tâ (U+0054 U+00E2)
  0x00, 0x54, 0x00, 0xE3, 0x01, // Tã (U+0054 U+00E3)
  0x00, 0x54, 0x00, 0xE4, 0x01, // Tä (U+0054 U+00E4)
  0x00, 0x54, 0x00, 0xE5, 0x01, // Tå (U+0054 U+00E5)
  0x00, 0x54, 0x00, 0xE6, 0x01, // Tæ (U+0054 U+00E6)
  0x00, 0x54, 0x00, 0xE7, 0x01, // Tç (U+0054 U+00E7)
  0x00, 0x54, 0x00, 0xE8, 0x01, // Tè (U+0054 U+00E8)
  0x00, 0x54, 0x00, 0xE9, 0x01, // Té (U+0054 U+00E9)
  0x00, 0x54, 0x00, 0xEA, 0x01, // Tê (U+0054 U+00EA)
  0x00, 0x54, 0x00, 0xEB, 0x01, // Të (U+0054 U+00EB)
  0x00, 0x54, 0x00, 0xF2, 0x01, // Tò (U+0054 U+00F2)
  0x00, 0x54, 0x00, 0xF3, 0x01, // Tó (U+0054 U+00F3)
  0x00, 0x54, 0x00, 0xF4, 0x01, // Tô (U+0054 U+00F4)
  0x00, 0x54, 0x00, 0xF5, 0x01, // Tõ (U+0054 U+00F5)
  0x00, 0x54, 0x00, 0xF6, 0x01, // Tö (U+0054 U+00F6)
  0x00, 0x54, 0x00, 0xF8, 0x01, // Tø (U+0054 U+00F8)
  0x00, 0x54, 0x01, 0x01, 0x01, // Tā (U+0054 U+0101)
  0x00, 0x54, 0x01, 0x03, 0x01, // Tă (U+0054 U+0103)
  0x00, 0x54, 0x01, 0x05, 0x01, // Tą (U+0054 U+0105)
  0x00, 0x54, 0x01, 0x07, 0x01, // Tć (U+0054 U+0107)
  0x00, 0x54, 0x01, 0x09, 0x01, // Tĉ (U+0054 U+0109)
  0x00, 0x54, 0x01, 0x0B, 0x01, // Tċ (U+0054 U+010B)
  0x00, 0x54, 0x01, 0x0D, 0x01, // Tč (U+0054 U+010D)
  0x00, 0x54, 0x01, 0x0F, 0x01, // Tď (U+0054 U+010F)
  0x00, 0x54, 0x01, 0x11, 0x01, // Tđ (U+0054 U+0111)
  0x00, 0x54, 0x01, 0x13, 0x01, // Tē (U+0054 U+0113)
  0x00, 0x54, 0x01, 0x15, 0x01, // Tĕ (U+0054 U+0115)
  0x00, 0x54, 0x01, 0x17, 0x01, // Tė (U+0054 U+0117)
  0x00, 0x54, 0x01, 0x19, 0x01, // Tę (U+0054 U+0119)
  0x00, 0x54, 0x01, 0x1B, 0x01, // Tě (U+0054 U+011B)
  0x00, 0x54, 0x01, 0x1D, 0x01, // Tĝ (U+0054 U+011D)
  0x00, 0x54, 0x01, 0x1F, 0x01, // Tğ (U+0054 U+011F)
  0x00, 0x54, 0x01, 0x21, 0x01, // Tġ (U+0054 U+0121)
  0x00, 0x54, 0x01, 0x23, 0x01, // Tģ (U+0054 U+0123)
  0x00, 0x54, 0x01, 0x4D, 0x01, // Tō (U+0054 U+014D)
  0x00, 0x54, 0x01, 0x4F, 0x01, // Tŏ (U+0054 U+014F)
  0x00, 0x54, 0x01, 0x51, 0x01, // Tő (U+0054 U+0151)
  0x00, 0x54, 0x01, 0x53, 0x01, // Tœ (U+0054 U+0153)
  0x00, 0x72, 0x00, 0x2C, 0x01, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x01, // r. (U+0072 U+002E)
  0x00, 0x72, 0x20, 0x1A, 0x01, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x01, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x01, // r… (U+0072 U+2026)
  0x00, 0xC0, 0x00, 0x22, 0x01, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x01, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x20, 0x19, 0x01, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1D, 0x01, // À” (U+00C0 U+201D)
  0x00, 0xC1, 0x00, 0x22, 0x01, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x01, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x20, 0x19, 0x01, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1D, 0x01, // Á” (U+00C1 U+201D)
  0x00, 0xC2, 0x00, 0x22, 0x01, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x01, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x20, 0x19, 0x01, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1D, 0x01, // Â” (U+00C2 U+201D)
  0x00, 0xC3, 0x00, 0x22, 0x01, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x01, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x20, 0x19, 0x01, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1D, 0x01, // Ã” (U+00C3 U+201D)
  0x00, 0xC4, 0x00, 0x22, 0x01, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x01, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x20, 0x19, 0x01, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1D, 0x01, // Ä” (U+00C4 U+201D)
  0x00, 0xC5, 0x00, 0x22, 0x01, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x01, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x20, 0x19, 0x01, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1D, 0x01, // Å” (U+00C5 U+201D)
  0x00, 0xDE, 0x00, 0x2C, 0x01, // Þ, (U+00DE U+002C)
  0x00, 0xDE, 0x00, 0x2E, 0x01, // Þ. (U+00DE U+002E)
  0x00, 0xDE, 0x20, 0x1A, 0x01, // Þ‚ (U+00DE U+201A)
  0x00, 0xDE, 0x20, 0x1E, 0x01, // Þ„ (U+00DE U+201E)
  0x00, 0xDE, 0x20, 0x26, 0x01, // Þ… (U+00DE U+2026)
  0x01, 0x00, 0x00, 0x22, 0x01, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x01, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x20, 0x19, 0x01, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1D, 0x01, // Ā” (U+0100 U+201D)
  0x01, 0x02, 0x00, 0x22, 0x01, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x01, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x20, 0x19, 0x01, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1D, 0x01, // Ă” (U+0102 U+201D)
  0x01, 0x04, 0x00, 0x22, 0x01, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x01, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x20, 0x19, 0x01, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1D, 0x01, // Ą” (U+0104 U+201D)
  0x01, 0x39, 0x00, 0x22, 0x01, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x01, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x20, 0x19, 0x01, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1D, 0x01, // Ĺ” (U+0139 U+201D)
  0x01, 0x3B, 0x00, 0x22, 0x01, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x01, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x20, 0x19, 0x01, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1D, 0x01, // Ļ” (U+013B U+201D)
  0x01, 0x3D, 0x00, 0x22, 0x01, // Ľ" (U+013D U+0022)
  0x01, 0x3D, 0x00, 0x27, 0x01, // Ľ' (U+013D U+0027)
  0x01, 0x3D, 0x20, 0x19, 0x01, // Ľ’ (U+013D U+2019)
  0x01, 0x3D, 0x20, 0x1D, 0x01, // Ľ” (U+013D U+201D)
  0x01, 0x3F, 0x00, 0x22, 0x01, // Ŀ" (U+013F U+0022)
  0x01, 0x3F, 0x00, 0x27, 0x01, // Ŀ' (U+013F U+0027)
  0x01, 0x3F, 0x20, 0x19, 0x01, // Ŀ’ (U+013F U+2019)
  0x01, 0x3F, 0x20, 0x1D, 0x01, // Ŀ” (U+013F U+201D)
  0x01, 0x41, 0x00, 0x22, 0x01, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x01, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x20, 0x19, 0x01, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1D, 0x01, // Ł” (U+0141 U+201D)
  0x01, 0x55, 0x00, 0x2C, 0x01, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x01, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x20, 0x1A, 0x01, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x01, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x01, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x01, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x01, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x20, 0x1A, 0x01, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x01, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x01, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x01, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x01, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x20, 0x1A, 0x01, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x01, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x01, // ř… (U+0159 U+2026)
  0x01, 0x62, 0x00, 0x61, 0x01, // Ţa (U+0162 U+0061)
  0x01, 0x62, 0x00, 0x63, 0x01, // Ţc (U+0162 U+0063)
  0x01, 0x62, 0x00, 0x64, 0x01, // Ţd (U+0162 U+0064)
  0x01, 0x62, 0x00, 0x65, 0x01, // Ţe (U+0162 U+0065)
  0x01, 0x62, 0x00, 0x67, 0x01, // Ţg (U+0162 U+0067)
  0x01, 0x62, 0x00, 0x6F, 0x01, // Ţo (U+0162 U+006F)
  0x01, 0x62, 0x00, 0x71, 0x01, // Ţq (U+0162 U+0071)
  0x01, 0x62, 0x00, 0xE0, 0x01, // Ţà (U+0162 U+00E0)
  0x01, 0x62, 0x00, 0xE1, 0x01, // Ţá (U+0162 U+00E1)
  0x01, 0x62, 0x00, 0xE2, 0x01, // Ţâ (U+0162 U+00E2)
  0x01, 0x62, 0x00, 0xE3, 0x01, // Ţã (U+0162 U+00E3)
  0x01, 0x62, 0x00, 0xE4, 0x01, // Ţä (U+0162 U+00E4)
  0x01, 0x62, 0x00, 0xE5, 0x01, // Ţå (U+0162 U+00E5)
  0x01, 0x62, 0x00, 0xE6, 0x01, // Ţæ (U+0162 U+00E6)
  0x01, 0x62, 0x00, 0xE7, 0x01, // Ţç (U+0162 U+00E7)
  0x01, 0x62, 0x00, 0xE8, 0x01, // Ţè (U+0162 U+00E8)
  0x01, 0x62, 0x00, 0xE9, 0x01, // Ţé (U+0162 U+00E9)
  0x01, 0x62, 0x00, 0xEA, 0x01, // Ţê (U+0162 U+00EA)
  0x01, 0x62, 0x00, 0xEB, 0x01, // Ţë (U+0162 U+00EB)
  0x01, 0x62, 0x00, 0xF2, 0x01, // Ţò (U+0162 U+00F2)
  0x01, 0x62, 0x00, 0xF3, 0x01, // Ţó (U+0162 U+00F3)
  0x01, 0x62, 0x00, 0xF4, 0x01, // Ţô (U+0162 U+00F4)
  0x01, 0x62, 0x00, 0xF5, 0x01, // Ţõ (U+0162 U+00F5)
  0x01, 0x62, 0x00, 0xF6, 0x01, // Ţö (U+0162 U+00F6)
  0x01, 0x62, 0x00, 0xF8, 0x01, // Ţø (U+0162 U+00F8)
  0x01, 0x62, 0x01, 0x01, 0x01, // Ţā (U+0162 U+0101)
  0x01, 0x62, 0x01, 0x03, 0x01, // Ţă (U+0162 U+0103)
  0x01, 0x62, 0x01, 0x05, 0x01, // Ţą (U+0162 U+0105)
  0x01, 0x62, 0x01, 0x07, 0x01, // Ţć (U+0162 U+0107)
  0x01, 0x62, 0x01, 0x09, 0x01, // Ţĉ (U+0162 U+0109)
  0x01, 0x62, 0x01, 0x0B, 0x01, // Ţċ (U+0162 U+010B)
  0x01, 0x62, 0x01, 0x0D, 0x01, // Ţč (U+0162 U+010D)
  0x01, 0x62, 0x01, 0x0F, 0x01, // Ţď (U+0162 U+010F)
  0x01, 0x62, 0x01, 0x11, 0x01, // Ţđ (U+0162 U+0111)
  0x01, 0x62, 0x01, 0x13, 0x01, // Ţē (U+0162 U+0113)
  0x01, 0x62, 0x01, 0x15, 0x01, // Ţĕ (U+0162 U+0115)
  0x01, 0x62, 0x01, 0x17, 0x01, // Ţė (U+0162 U+0117)
  0x01, 0x62, 0x01, 0x19, 0x01, // Ţę (U+0162 U+0119)
  0x01, 0x62, 0x01, 0x1B, 0x01, // Ţě (U+0162 U+011B)
  0x01, 0x62, 0x01, 0x1D, 0x01, // Ţĝ (U+0162 U+011D)
  0x01, 0x62, 0x01, 0x1F, 0x01, // Ţğ (U+0162 U+011F)
  0x01, 0x62, 0x01, 0x21, 0x01, // Ţġ (U+0162 U+0121)
  0x01, 0x62, 0x01, 0x23, 0x01, // Ţģ (U+0162 U+0123)
  0x01, 0x62, 0x01, 0x4D, 0x01, // Ţō (U+0162 U+014D)
  0x01, 0x62, 0x01, 0x4F, 0x01, // Ţŏ (U+0162 U+014F)
  0x01, 0x62, 0x01, 0x51, 0x01, // Ţő (U+0162 U+0151)
  0x01, 0x62, 0x01, 0x53, 0x01, // Ţœ (U+0162 U+0153)
  0x01, 0x64, 0x00, 0x61, 0x01, // Ťa (U+0164 U+0061)
  0x01, 0x64, 0x00, 0x63, 0x01, // Ťc (U+0164 U+0063)
  0x01, 0x64, 0x00, 0x64, 0x01, // Ťd (U+0164 U+0064)
  0x01, 0x64, 0x00, 0x65, 0x01, // Ťe (U+0164 U+0065)
  0x01, 0x64, 0x00, 0x67, 0x01, // Ťg (U+0164 U+0067)
  0x01, 0x64, 0x00, 0x6F, 0x01, // Ťo (U+0164 U+006F)
  0x01, 0x64, 0x00, 0x71, 0x01, // Ťq (U+0164 U+0071)
  0x01, 0x64, 0x00, 0xE0, 0x01, // Ťà (U+0164 U+00E0)
  0x01, 0x64, 0x00, 0xE1, 0x01, // Ťá (U+0164 U+00E1)
  0x01, 0x64, 0x00, 0xE2, 0x01, // Ťâ (U+0164 U+00E2)
  0x01, 0x64, 0x00, 0xE3, 0x01, // Ťã (U+0164 U+00E3)
  0x01, 0x64, 0x00, 0xE4, 0x01, // Ťä (U+0164 U+00E4)
  0x01, 0x64, 0x00, 0xE5, 0x01, // Ťå (U+0164 U+00E5)
  0x01, 0x64, 0x00, 0xE6, 0x01, // Ťæ (U+0164 U+00E6)
  0x01, 0x64, 0x00, 0xE7, 0x01, // Ťç (U+0164 U+00E7)
  0x01, 0x64, 0x00, 0xE8, 0x01, // Ťè (U+0164 U+00E8)
  0x01, 0x64, 0x00, 0xE9, 0x01, // Ťé (U+0164 U+00E9)
  0x01, 0x64, 0x00, 0xEA, 0x01, // Ťê (U+0164 U+00EA)
  0x01, 0x64, 0x00, 0xEB, 0x01, // Ťë (U+0164 U+00EB)
  0x01, 0x64, 0x00, 0xF2, 0x01, // Ťò (U+0164 U+00F2)
  0x01, 0x64, 0x00, 0xF3, 0x01, // Ťó (U+0164 U+00F3)
  0x01, 0x64, 0x00, 0xF4, 0x01, // Ťô (U+0164 U+00F4)
  0x01, 0x64, 0x00, 0xF5, 0x01, // Ťõ (U+0164 U+00F5)
  0x01, 0x64, 0x00, 0xF6, 0x01, // Ťö (U+0164 U+00F6)
  0x01, 0x64, 0x00, 0xF8, 0x01, // Ťø (U+0164 U+00F8)
  0x01, 0x64, 0x01, 0x01, 0x01, // Ťā (U+0164 U+0101)
  0x01, 0x64, 0x01, 0x03, 0x01, // Ťă (U+0164 U+0103)
  0x01, 0x64, 0x01, 0x05, 0x01, // Ťą (U+0164 U+0105)
  0x01, 0x64, 0x01, 0x07, 0x01, // Ťć (U+0164 U+0107)
  0x01, 0x64, 0x01, 0x09, 0x01, // Ťĉ (U+0164 U+0109)
  0x01, 0x64, 0x01, 0x0B, 0x01, // Ťċ (U+0164 U+010B)
  0x01, 0x64, 0x01, 0x0D, 0x01, // Ťč (U+0164 U+010D)
  0x01, 0x64, 0x01, 0x0F, 0x01, // Ťď (U+0164 U+010F)
  0x01, 0x64, 0x01, 0x11, 0x01, // Ťđ (U+0164 U+0111)
  0x01, 0x64, 0x01, 0x13, 0x01, // Ťē (U+0164 U+0113)
  0x01, 0x64, 0x01, 0x15, 0x01, // Ťĕ (U+0164 U+0115)
  0x01, 0x64, 0x01, 0x17, 0x01, // Ťė (U+0164 U+0117)
  0x01, 0x64, 0x01, 0x19, 0x01, // Ťę (U+0164 U+0119)
  0x01, 0x64, 0x01, 0x1B, 0x01, // Ťě (U+0164 U+011B)
  0x01, 0x64, 0x01, 0x1D, 0x01, // Ťĝ (U+0164 U+011D)
  0x01, 0x64, 0x01, 0x1F, 0x01, // Ťğ (U+0164 U+011F)
  0x01, 0x64, 0x01, 0x21, 0x01, // Ťġ (U+0164 U+0121)
  0x01, 0x64, 0x01, 0x23, 0x01, // Ťģ (U+0164 U+0123)
  0x01, 0x64, 0x01, 0x4D, 0x01, // Ťō (U+0164 U+014D)
  0x01, 0x64, 0x01, 0x4F, 0x01, // Ťŏ (U+0164 U+014F)
  0x01, 0x64, 0x01, 0x51, 0x01, // Ťő (U+0164 U+0151)
  0x01, 0x64, 0x01, 0x53, 0x01, // Ťœ (U+0164 U+0153)
  0x01, 0x66, 0x00, 0x61, 0x01, // Ŧa (U+0166 U+0061)
  0x01, 0x66, 0x00, 0x63, 0x01, // Ŧc (U+0166 U+0063)
  0x01, 0x66, 0x00, 0x64, 0x01, // Ŧd (U+0166 U+0064)
  0x01, 0x66, 0x00, 0x65, 0x01, // Ŧe (U+0166 U+0065)
  0x01, 0x66, 0x00, 0x67, 0x01, // Ŧg (U+0166 U+0067)
  0x01, 0x66, 0x00, 0x6F, 0x01, // Ŧo (U+0166 U+006F)
  0x01, 0x66, 0x00, 0x71, 0x01, // Ŧq (U+0166 U+0071)
  0x01, 0x66, 0x00, 0xE0, 0x01, // Ŧà (U+0166 U+00E0)
  0x01, 0x66, 0x00, 0xE1, 0x01, // Ŧá (U+0166 U+00E1)
  0x01, 0x66, 0x00, 0xE2, 0x01, // Ŧâ (U+0166 U+00E2)
  0x01, 0x66, 0x00, 0xE3, 0x01, // Ŧã (U+0166 U+00E3)
  0x01, 0x66, 0x00, 0xE4, 0x01, // Ŧä (U+0166 U+00E4)
  0x01, 0x66, 0x00, 0xE5, 0x01, // Ŧå (U+0166 U+00E5)
  0x01, 0x66, 0x00, 0xE6, 0x01, // Ŧæ (U+0166 U+00E6)
  0x01, 0x66, 0x00, 0xE7, 0x01, // Ŧç (U+0166 U+00E7)
  0x01, 0x66, 0x00, 0xE8, 0x01, // Ŧè (U+0166 U+00E8)
  0x01, 0x66, 0x00, 0xE9, 0x01, // Ŧé (U+0166 U+00E9)
  0x01, 0x66, 0x00, 0xEA, 0x01, // Ŧê (U+0166 U+00EA)
  0x01, 0x66, 0x00, 0xEB, 0x01, // Ŧë (U+0166 U+00EB)
  0x01, 0x66, 0x00, 0xF2, 0x01, // Ŧò (U+0166 U+00F2)
  0x01, 0x66, 0x00, 0xF3, 0x01, // Ŧó (U+0166 U+00F3)
  0x01, 0x66, 0x00, 0xF4, 0x01, // Ŧô (U+0166 U+00F4)
  0x01, 0x66, 0x00, 0xF5, 0x01, // Ŧõ (U+0166 U+00F5)
  0x01, 0x66, 0x00, 0xF6, 0x01, // Ŧö (U+0166 U+00F6)
  0x01, 0x66, 0x00, 0xF8, 0x01, // Ŧø (U+0166 U+00F8)
  0x01, 0x66, 0x01, 0x01, 0x01, // Ŧā (U+0166 U+0101)
  0x01, 0x66, 0x01, 0x03, 0x01, // Ŧă (U+0166 U+0103)
  0x01, 0x66, 0x01, 0x05, 0x01, // Ŧą (U+0166 U+0105)
  0x01, 0x66, 0x01, 0x07, 0x01, // Ŧć (U+0166 U+0107)
  0x01, 0x66, 0x01, 0x09, 0x01, // Ŧĉ (U+0166 U+0109)
  0x01, 0x66, 0x01, 0x0B, 0x01, // Ŧċ (U+0166 U+010B)
  0x01, 0x66, 0x01, 0x0D, 0x01, // Ŧč (U+0166 U+010D)
  0x01, 0x66, 0x01, 0x0F, 0x01, // Ŧď (U+0166 U+010F)
  0x01, 0x66, 0x01, 0x11, 0x01, // Ŧđ (U+0166 U+0111)
  0x01, 0x66, 0x01, 0x13, 0x01, // Ŧē (U+0166 U+0113)
  0x01, 0x66, 0x01, 0x15, 0x01, // Ŧĕ (U+0166 U+0115)
  0x01, 0x66, 0x01, 0x17, 0x01, // Ŧė (U+0166 U+0117)
  0x01, 0x66, 0x01, 0x19, 0x01, // Ŧę (U+0166 U+0119)
  0x01, 0x66, 0x01, 0x1B, 0x01, // Ŧě (U+0166 U+011B)
  0x01, 0x66, 0x01, 0x1D, 0x01, // Ŧĝ (U+0166 U+011D)
  0x01, 0x66, 0x01, 0x1F, 0x01, // Ŧğ (U+0166 U+011F)
  0x01, 0x66, 0x01, 0x21, 0x01, // Ŧġ (U+0166 U+0121)
  0x01, 0x66, 0x01, 0x23, 0x01, // Ŧģ (U+0166 U+0123)
  0x01, 0x66, 0x01, 0x4D, 0x01, // Ŧō (U+0166 U+014D)
  0x01, 0x66, 0x01, 0x4F, 0x01, // Ŧŏ (U+0166 U+014F)
  0x01, 0x66, 0x01, 0x51, 0x01, // Ŧő (U+0166 U+0151)
  0x01, 0x66, 0x01, 0x53, 0x01, // Ŧœ (U+0166 U+0153)
  0x20, 0x18, 0x00, 0x41, 0x01, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0xC0, 0x01, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x01, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x01, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x01, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x01, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x01, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x01, 0x00, 0x01, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x02, 0x01, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x04, 0x01, // ‘Ą (U+2018 U+0104)
  0x20, 0x19, 0x00, 0x41, 0x01, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0xC0, 0x01, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x01, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x01, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x01, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x01, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x01, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x01, 0x00, 0x01, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x02, 0x01, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x04, 0x01, // ’Ą (U+2019 U+0104)
  0x20, 0x1A, 0x00, 0x54, 0x01, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x01, 0x62, 0x01, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x01, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x01, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1C, 0x00, 0x41, 0x01, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0xC0, 0x01, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x01, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x01, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x01, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x01, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x01, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x01, 0x00, 0x01, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x02, 0x01, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x04, 0x01, // “Ą (U+201C U+0104)
  0x20, 0x1D, 0x00, 0x41, 0x01, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0xC0, 0x01, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x01, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x01, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x01, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x01, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x01, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x01, 0x00, 0x01, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x02, 0x01, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x04, 0x01, // ”Ą (U+201D U+0104)
  0x20, 0x1E, 0x00, 0x54, 0x01, // „T (U+201E U+0054)
  0x20, 0x1E, 0x01, 0x62, 0x01, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x01, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x01, // „Ŧ (U+201E U+0166)
  0x20, 0x44, 0x00, 0x30, 0x01, // ⁄0 (U+2044 U+0030)
  0x20, 0x44, 0x00, 0x31, 0x01, // ⁄1 (U+2044 U+0031)
  0x20, 0x44, 0x00, 0x32, 0x01, // ⁄2 (U+2044 U+0032)
  0x20, 0x44, 0x00, 0x33, 0x01, // ⁄3 (U+2044 U+0033)
  0x20, 0x44, 0x00, 0x34, 0x01, // ⁄4 (U+2044 U+0034)
  0x20, 0x44, 0x00, 0x35, 0x01, // ⁄5 (U+2044 U+0035)
  0x20, 0x44, 0x00, 0x36, 0x01, // ⁄6 (U+2044 U+0036)
  0x20, 0x44, 0x00, 0x37, 0x01, // ⁄7 (U+2044 U+0037)
  0x20, 0x44, 0x00, 0x38, 0x01, // ⁄8 (U+2044 U+0038)
  0x20, 0x44, 0x00, 0x39, 0x01, // ⁄9 (U+2044 U+0039)
  
  // Glyph data
  // "!" (U+0021)
  0x18, 0x2B, 0x10, 0xC2, 0x89, 0x2B, 0x02, 0x80, 0x45, 0x02, 0x10, 0x72,
  // """ (U+0022)
  0x83, 0xA8, 0x27, 0x82, 0x01, 0x10,
  // "#" (U+0023)
  0x28, 0x19, 0x08, 0x38, 0x94, 0x83, 0x50, 0x3C, 0xDD, 0xC2, 0x06, 0x28, 0x28, 0x38, 0xDB, 0xD8,
  0x28, 0x18, 0x25, 0x28, 0x21, 0x66, 0x22,
  // "$" (U+0024)
  0x28, 0x78, 0x60, 0xAA, 0x40, 0xB8, 0x28, 0x93, 0x1C, 0x61, 0x36, 0x97, 0xDB, 0x20, 0x62,
  // "%" (U+0025)
  0x18, 0xC7, 0x8B, 0x02, 0x61, 0x78, 0x19, 0x04, 0x48, 0x63, 0x05, 0x4A, 0x89, 0xA1, 0xBB, 0x56,
  0x90, 0x36, 0x62, 0x90, 0x90, 0x3C, 0x50,
  // "&" (U+0026)
  0x18, 0x12, 0xBB, 0x28, 0x68, 0x29, 0x20, 0x7B, 0xC2, 0x89, 0x08, 0xD1, 0x07, 0x68, 0x4A, 0xA2,
  0x85, 0xE4, 0x5C, 0xA6, 0x80,
  // "'" (U+0027)
  0x0A, 0x07,
  // "(" (U+0028)
  0x18, 0x95, 0x28, 0x09, 0x02, 0x80, 0x73, 0x09, 0x10, 0xA2, 0x83, 0x81, 0x04, 0x41,
  // ")" (U+0029)
  0x20, 0x82, 0x0A, 0x20, 0xA2, 0x0A, 0x28, 0x7A, 0x03, 0x70, 0x91, 0x45, 0x10,
  // "*" (U+002A)
  0x18, 0x34, 0x20, 0x98, 0x28, 0x52, 0xD9, 0x59, 0x55, 0x30, 0x21,
  // "+" (U+002B)
  0x20, 0x92, 0x83, 0x5B, 0xDB, 0x32, 0x09, 0x40, 0x92,
  // "," (U+002C)
  0x18, 0x2A, 0x12, 0x71,
  // "-" (U+002D)
  0x81, 0x8B, 0x10,
  // "." (U+002E)
  0x07,
  // "/" (U+002F)
  0x30, 0x60, 0x43, 0x0A, 0x30, 0x50, 0x63, 0x0A, 0x30, 0x30, 0x73, 0x0A, 0x01, 0x20, 0x20, 0x83,
  // "0" (U+0030)
  0x18, 0x14, 0xCA, 0x28, 0xB2, 0xB0, 0x82, 0x47, 0x07, 0x37, 0x40, 0x82, 0x82, 0x0B, 0x07, 0x42,
  0x90, 0x1C, 0xB1, 0x10,
  // "1" (U+0031)
  0x18, 0x90, 0xA7, 0x9A, 0x40, 0x91, 0x0A, 0x28, 0x5A, 0x01, 0x90, 0x46, 0x10,
  // "2" (U+0032)
  0x18, 0x17, 0xBB, 0x28, 0x22, 0x09, 0x23, 0x0A, 0x01, 0x20, 0x50, 0x72, 0x03, 0x0A, 0x20, 0x20,
  0xA3, 0x82, 0xDC, 0xB7, 0x10,
  // "3" (U+0033)
  0x18, 0x18, 0xBB, 0x28, 0x21, 0x09, 0x23, 0x0B, 0x28, 0x16, 0xD3, 0x30, 0x20, 0xA3, 0x85, 0x2A,
  0x09, 0xBC, 0x21,
  // "4" (U+0034)
  0x30, 0xD0, 0x12, 0x08, 0x0C, 0x28, 0x13, 0x8A, 0x28, 0x94, 0xB1, 0xA0, 0x74, 0x27, 0x0B, 0xBC,
  0xC2, 0x20, 0x90, 0x11,
  // "5" (U+0035)
  0x18, 0x47, 0xCB, 0x20, 0x94, 0x0A, 0x48, 0x1D, 0xC5, 0x40, 0xB3, 0x85, 0x1A, 0x07, 0xBB, 0x21,
  // "6" (U+0036)
  0x18, 0x51, 0xAB, 0x30, 0x94, 0x20, 0x10, 0xB3, 0x8A, 0x15, 0xAB, 0x70, 0x76, 0x0B, 0x06, 0x40,
  0xB0, 0x1B, 0xB4, 0x10,
  // "7" (U+0037)
  0x18, 0x2B, 0xBD, 0x63, 0x0A, 0x30, 0x30, 0x83, 0x0A, 0x01, 0x20, 0x20, 0x93, 0x09, 0x02, 0x20,
  0x20, 0x93,
  // "8" (U+0038)
  0x18, 0xB7, 0x4C, 0xB1, 0x0A, 0x07, 0x40, 0x98, 0xC1, 0x08, 0xD4, 0x06, 0x50, 0xA0, 0x92, 0x0B,
  0x03, 0xCC, 0x41,
  // "9" (U+0039)
  0x18, 0xA0, 0x6B, 0x90, 0x1A, 0x0A, 0x13, 0x60, 0x82, 0x38, 0x0D, 0x20, 0xFA, 0x38, 0x44, 0x60,
  0x7B, 0x92,
  // ":" (U+003A)
  0x01, 0x07, 0x60, 0x71,
  // ";" (U+003B)
  0x10, 0x10, 0x77, 0x04, 0x28, 0x2A, 0x02, 0x31,
  // "<" (U+003C)
  0x38, 0x90, 0x63, 0x06, 0x82, 0x03, 0x94, 0x48, 0x14, 0x93,
  // "=" (U+003D)
  0x83, 0x4B, 0xBB, 0x35, 0x83, 0x4B, 0xBB, 0x30,
  // ">" (U+003E)
  0x04, 0x06, 0x48, 0x13, 0x86, 0x38, 0x45, 0x92, 0x49, 0x32,
  // "?" (U+003F)
  0x82, 0x1B, 0xC4, 0x20, 0x20, 0x92, 0x83, 0x57, 0x02, 0xB2, 0x09, 0x01, 0x20, 0x32, 0x03, 0x05,
  0x20,
  // "@" (U+0040)
  0x28, 0x28, 0xBB, 0x82, 0x08, 0x04, 0x28, 0xB6, 0x74, 0x27, 0x4C, 0xC1, 0x76, 0x2A, 0x09, 0x17,
  0x82, 0x83, 0x85, 0x47, 0x2A, 0x79, 0x90, 0x2A, 0x20, 0x13, 0x82, 0x4B, 0xB7, 0x20,
  // "A" (U+0041)
  0x30, 0x90, 0x72, 0x81, 0x1B, 0x82, 0x81, 0x74, 0xA2, 0x89, 0x0B, 0x0A, 0x05, 0xDB, 0xC0, 0xB2,
  0x81, 0xB3, 0x82, 0x0A,
  // "B" (U+0042)
  0x18, 0xB7, 0x8C, 0xC4, 0x0B, 0x02, 0xA0, 0xB0, 0x48, 0x1E, 0xCC, 0x03, 0x70, 0x83, 0x64, 0x08,
  0x39, 0xCB, 0x81,
  // "C" (U+0043)
  0x28, 0x49, 0xBB, 0x0A, 0x42, 0x01, 0x0A, 0x30, 0x50, 0x63, 0x06, 0x05, 0x30, 0x30, 0x94, 0x81,
  0x9C, 0xB1,
  // "D" (U+0044)
  0x18, 0x48, 0xCC, 0x40, 0xA2, 0x81, 0xC0, 0xB2, 0x81, 0xA1, 0xA2, 0x81, 0xB3, 0x72, 0x89, 0x0B,
  0x64, 0x08, 0x69, 0xCB, 0x61,
  // "E" (U+0045)
  0x18, 0x48, 0xBB, 0x40, 0xA4, 0x0B, 0x38, 0x51, 0xEB, 0x80, 0x37, 0x30, 0x60, 0x43, 0x82, 0x9C,
  0xB3, 0x10,
  // "F" (U+0046)
  0x18, 0x48, 0xBB, 0x40, 0xA4, 0x0A, 0x38, 0x51, 0xEB, 0x70, 0x36, 0x30, 0x60, 0x43, 0x09, 0x01,
  0x30,
  // "G" (U+0047)
  0x18, 0x61, 0xAB, 0xC2, 0x09, 0x43, 0x01, 0x0A, 0x48, 0x64, 0x60, 0xAC, 0x06, 0x52, 0x85, 0xB0,
  0x39, 0x01, 0x92, 0x82, 0x8C, 0xB4, 0x10,
  // "H" (U+0048)
  0x18, 0x58, 0x20, 0x55, 0x0A, 0x28, 0x27, 0x30, 0xB2, 0x09, 0x28, 0x5E, 0xBB, 0xC0, 0x37, 0x28,
  0x93, 0xA0, 0x64, 0x02, 0x80, 0x82, 0x05, 0x51,
  // "I" (U+0049)
  0x18, 0x5C, 0xA0, 0x82, 0x0A, 0x28, 0x90, 0xA0, 0x19, 0x04, 0x60, 0xB9, 0x10,
  // "J" (U+004A)
  0x30, 0x80, 0x23, 0x0A, 0x40, 0xB3, 0x02, 0x08, 0x30, 0x05, 0x30, 0x80, 0x23, 0x0B, 0x28, 0x12,
  0xB5, 0x20,
  // "K" (U+004B)
  0x18, 0x97, 0x82, 0x1A, 0x0A, 0x0A, 0x10, 0xB9, 0x30, 0x1E, 0xC2, 0x89, 0x43, 0x78, 0x30, 0x64,
  0x38, 0x09, 0x20, 0xB1,
  // "L" (U+004C)
  0x10, 0x80, 0x22, 0x0A, 0x30, 0xB2, 0x01, 0x09, 0x20, 0x30, 0x72, 0x06, 0x04, 0x28, 0x29, 0xCB,
  0x30,
  // "M" (U+004D)
  0x10, 0x08, 0x28, 0x38, 0xA0, 0x99, 0x28, 0xC2, 0xC7, 0x0A, 0x90, 0x79, 0x51, 0x99, 0x09, 0x82,
  0x36, 0x95, 0x4A, 0x06, 0x38, 0xA0, 0xB0, 0x91, 0x66, 0x1A, 0x10,
  // "N" (U+004E)
  0x18, 0xC6, 0x86, 0x01, 0x90, 0xAA, 0x03, 0x60, 0xA9, 0x06, 0x41, 0x95, 0x59, 0x13, 0x60, 0x9A,
  0x06, 0x30, 0xAA, 0x09, 0x10, 0x68, 0x10,
  // "O" (U+004F)
  0x18, 0x21, 0xBB, 0x92, 0x85, 0xA3, 0x07, 0x42, 0x92, 0x82, 0x47, 0x56, 0x28, 0x25, 0x66, 0x52,
  0x85, 0x83, 0x39, 0x01, 0xC2, 0x82, 0x8B, 0xB2, 0x10,
  // "P" (U+0050)
  0x18, 0xB0, 0x8C, 0xB1, 0x0B, 0x04, 0x70, 0xC0, 0x37, 0x1B, 0x09, 0x33, 0xDB, 0x60, 0x65, 0x30,
  0x90, 0x23,
  // "Q" (U+0051)
  0x18, 0x21, 0xBB, 0x92, 0x85, 0xA3, 0x07, 0x42, 0x92, 0x82, 0x47, 0x56, 0x28, 0x25, 0x66, 0x52,
  0x85, 0x83, 0x39, 0x01, 0xB2, 0x82, 0x8B, 0xC2, 0x40, 0xB5, 0x00, 0x31,
  // "R" (U+0052)
  0x18, 0xB7, 0x8C, 0xC2, 0x0A, 0x03, 0x70, 0xA0, 0x75, 0x1D, 0xD8, 0x03, 0x65, 0x50, 0x64, 0x19,
  0x09, 0x10, 0xB1,
  // "S" (U+0053)
  0x18, 0x37, 0xBC, 0x0A, 0x20, 0x10, 0xC3, 0x81, 0x5B, 0x12, 0x05, 0x07, 0x28, 0x45, 0x7A, 0xBB,
  0x10,
  // "T" (U+0054)
  0x83, 0x2B, 0xEB, 0x72, 0x0B, 0x40, 0xA3, 0x02, 0x08, 0x30, 0x05, 0x30, 0x80, 0x33, 0x0A, 0x30,
  // "U" (U+0055)
  0x18, 0x59, 0x10, 0x46, 0x0B, 0x28, 0x27, 0x30, 0xA2, 0x82, 0x91, 0x28, 0x28, 0x2A, 0x04, 0x62,
  0x85, 0xA0, 0x46, 0x05, 0x62, 0x81, 0xAA, 0x92,
  // "V" (U+0056)
  0x03, 0x07, 0x28, 0x95, 0xB2, 0x80, 0x47, 0x09, 0x0A, 0x10, 0xA1, 0x92, 0x81, 0xA8, 0x32, 0x00,
  0xA3, 0x0A, 0x05, 0x20,
  // "W" (U+0057)
  0x89, 0x51, 0x80, 0x59, 0x06, 0x51, 0x90, 0x99, 0x0A, 0x28, 0x49, 0x18, 0x91, 0x92, 0x84, 0xA7,
  0x29, 0x73, 0x28, 0x3A, 0x90, 0x9A, 0x38, 0x3C, 0x60, 0xA7, 0x30, 0xD2, 0x0C, 0x02, 0x20,
  // "X" (U+0058)
  0x28, 0x2A, 0x03, 0x82, 0x81, 0x91, 0xA3, 0x81, 0x5B, 0x43, 0x04, 0x0C, 0x48, 0x1A, 0xA1, 0x28,
  0x90, 0x74, 0x55, 0x02, 0xA0, 0x19, 0x10,
  // "Y" (U+0059)
  0x87, 0x28, 0x04, 0x80, 0xA0, 0xB2, 0x81, 0xA5, 0x62, 0x08, 0x0B, 0x30, 0x60, 0x53, 0x08, 0x02,
  0x30, 0xA3,
  // "Z" (U+005A)
  0x18, 0x2A, 0xBD, 0x73, 0x0B, 0x01, 0x20, 0x80, 0x52, 0x02, 0x0A, 0x30, 0xB0, 0x12, 0x07, 0x06,
  0x38, 0x2E, 0xBB, 0x61,
  // "[" (U+005B)
  0x18, 0x2A, 0xA0, 0xA2, 0x87, 0x90, 0x36, 0x06, 0x30, 0x92, 0x0A, 0x20, 0xC0, 0x61,
  // "\" (U+005C)
  0x01, 0x08, 0x20, 0x92, 0x09, 0x20, 0x92, 0x09, 0x28, 0x37, 0x20, 0x54,
  // "]" (U+005D)
  0x18, 0x11, 0xD5, 0x20, 0x70, 0x22, 0x0A, 0x30, 0xA2, 0x01, 0x09, 0x20, 0x40, 0x62, 0x83, 0x73,
  0x06, 0xC2,
  // "^" (U+005E)
  0x10, 0x30, 0x93, 0x89, 0x48, 0x71, 0x01, 0x71, 0x80, 0x72, 0x08, 0x10,
  // "_" (U+005F)
  0x82, 0x7B, 0xB5,
  // "`" (U+0060)
  0x82, 0x50, 0x44,
  // "a" (U+0061)
  0x18, 0xA5, 0x8C, 0x84, 0x39, 0x0B, 0x17, 0x30, 0xB0, 0x92, 0x3B, 0x04, 0xC7, 0x81,
  // "b" (U+0062)
  0x10, 0x90, 0x13, 0x0A, 0x48, 0xA5, 0xB9, 0xB0, 0x2C, 0x08, 0x35, 0x60, 0x92, 0x75, 0x0B, 0x09,
  0x8B, 0x31,
  // "c" (U+0063)
  0x18, 0x38, 0xB7, 0x38, 0x20, 0x80, 0x32, 0x08, 0x03, 0x28, 0x13, 0xCB, 0x10,
  // "d" (U+0064)
  0x40, 0xA3, 0x8B, 0x02, 0x70, 0x8C, 0x94, 0x39, 0x0B, 0x27, 0x30, 0xB0, 0x92, 0x3B, 0x04, 0xC7,
  0x81,
  // "e" (U+0065)
  0x18, 0x93, 0x8C, 0x73, 0x72, 0xA8, 0xCA, 0x18, 0x32, 0x82, 0x3C, 0xB2,
  // "f" (U+0066)
  0x28, 0x13, 0xC5, 0x20, 0x90, 0x12, 0x81, 0x3D, 0x93, 0x0A, 0x30, 0x30, 0x73, 0x06, 0x04, 0x30,
  0x90, 0x13, 0x0B, 0x30, 0xB0, 0x73,
  // "g" (U+0067)
  0x18, 0xA5, 0x8C, 0x84, 0x39, 0x0B, 0x17, 0x30, 0xB0, 0x92, 0x3B, 0x04, 0xC8, 0x83, 0x84, 0x64,
  0x09, 0xBA, 0x20,
  // "h" (U+0068)
  0x10, 0x90, 0x13, 0x0B, 0x48, 0xA5, 0xB9, 0xC0, 0x2C, 0x08, 0x25, 0x60, 0xA0, 0x73, 0x0A, 0x0A,
  0x01, 0x91,
  // "i" (U+0069)
  0x10, 0x63, 0x86, 0xA2, 0x85, 0x57, 0x3A, 0x10,
  // "j" (U+006A)
  0x20, 0x65, 0x89, 0x2A, 0x02, 0x80, 0x55, 0x08, 0x20, 0xA2, 0x82, 0xB0, 0xC5, 0x10,
  // "k" (U+006B)
  0x10, 0x90, 0x12, 0x0B, 0x38, 0xA1, 0xA1, 0xA2, 0x9A, 0x15, 0xD7, 0x07, 0x3B, 0x0A, 0x07, 0x40,
  // "l" (U+006C)
  0x18, 0x29, 0x10, 0xA2, 0x89, 0x2A, 0x02, 0x80, 0x55, 0x07, 0x30, 0xA2,
  // "m" (U+006D)
  0x10, 0xFA, 0x8B, 0x45, 0xC5, 0x2C, 0x0A, 0x43, 0x85, 0x60, 0xB0, 0x55, 0x73, 0x0A, 0x07, 0x2A,
  0x02, 0x70, 0xA1,
  // "n" (U+006E)
  0x18, 0xA5, 0xBA, 0xC0, 0x2D, 0x09, 0x25, 0x70, 0xB0, 0x83, 0x0B, 0x0B, 0x01, 0xA1,
  // "o" (U+006F)
  0x18, 0xA5, 0x8C, 0x90, 0x48, 0x0A, 0x18, 0x20, 0xA0, 0x83, 0x1B, 0x02, 0xCC, 0x21,
  // "p" (U+0070)
  0x28, 0x1A, 0xAC, 0x28, 0x96, 0x2C, 0x08, 0x30, 0x56, 0x09, 0x20, 0x85, 0x0B, 0x28, 0x2A, 0x9C,
  0x32, 0x0A, 0x40, 0x10, 0x94,
  // "q" (U+0071)
  0x18, 0xA5, 0x8C, 0x84, 0x39, 0x0B, 0x17, 0x30, 0xB0, 0x92, 0x3B, 0x04, 0xC8, 0x83, 0x00, 0x53,
  0x08, 0x02, 0x10,
  // "r" (U+0072)
  0x18, 0x3A, 0xA4, 0x2C, 0x20, 0x50, 0x62, 0x07, 0x03, 0x20, 0xA3,
  // "s" (U+0073)
  0x84, 0x2C, 0xB2, 0x55, 0x30, 0x90, 0x53, 0x83, 0xB0, 0xBC, 0x71,
  // "t" (U+0074)
  0x18, 0x97, 0x90, 0x5E, 0x92, 0x90, 0x45, 0x07, 0x30, 0x5C, 0x10,
  // "u" (U+0075)
  0x18, 0xA5, 0xA0, 0x64, 0x38, 0x08, 0x15, 0x50, 0xB0, 0x83, 0x2B, 0x05, 0xB7, 0x81,
  // "v" (U+0076)
  0x8A, 0x18, 0x20, 0xB7, 0x34, 0x65, 0x4A, 0x04, 0x97, 0x02, 0xE1, 0x10,
  // "w" (U+0077)
  0x8B, 0x38, 0x25, 0x90, 0xB7, 0x29, 0x83, 0x77, 0x57, 0x99, 0x16, 0xA1, 0x99, 0x06, 0xA0, 0xB4,
  0x10,
  // "x" (U+0078)
  0x8A, 0x22, 0x81, 0xA0, 0xAA, 0x10, 0x96, 0x03, 0x89, 0x0A, 0x09, 0x10,
  // "y" (U+0079)
  0x18, 0x93, 0x82, 0x0B, 0x06, 0x45, 0x60, 0x45, 0xA2, 0x81, 0x2A, 0x63, 0x0E, 0x30, 0x50, 0x72,
  0x08, 0x0B, 0x30,
  // "z" (U+007A)
  0x82, 0x1B, 0xD6, 0x20, 0x92, 0x83, 0x81, 0x05, 0x52, 0x81, 0xEB, 0x91,
  // "{" (U+007B)
  0x18, 0x41, 0xC1, 0x06, 0x42, 0x08, 0x01, 0x20, 0xA2, 0x0C, 0x05, 0x20, 0x20, 0x72, 0x05, 0x04,
  0x20, 0x30, 0xA2,
  // "|" (U+007C)
  0x80, 0x59,
  // "}" (U+007D)
  0x20, 0xC0, 0x12, 0x06, 0x03, 0x20, 0x80, 0x12, 0x09, 0x38, 0x37, 0x90, 0x19, 0x28, 0x36, 0x50,
  0x3A, 0x20,
  // "~" (U+007E)
  0x89, 0x03, 0xB7, 0x33, 0x30, 0x7B, 0x10,
  // "¡" (U+00A1)
  0x18, 0x92, 0x80, 0x33, 0x47, 0x2A, 0x0C, 0x02, 0x10,
  // "¢" (U+00A2)
  0x28, 0x62, 0x80, 0x46, 0x40, 0xA3, 0x09, 0x20, 0x10, 0xB3, 0x84, 0xAC, 0x50, 0x25, 0x10,
  // "£" (U+00A3)
  0x28, 0x4B, 0xB6, 0x05, 0x53, 0x08, 0x02, 0x28, 0x26, 0xEB, 0x42, 0x0A, 0x30, 0x20, 0x83, 0x82,
  0xEC, 0xB8, 0x10,
  // "¤" (U+00A4)
  0x38, 0x94, 0x12, 0xCB, 0xB0, 0x70, 0x80, 0x80, 0x82, 0x0F, 0xB0,
  // "¥" (U+00A5)
  0x18, 0x93, 0xA0, 0x19, 0x0A, 0x08, 0x20, 0x91, 0x92, 0x89, 0x36, 0xA2, 0x02, 0xCE, 0x80, 0x5C,
  0xC5, 0x20, 0x70, 0x22,
  // "¦" (U+00A6)
  0x0F, 0x93, 0x0F, 0x90,
  // "§" (U+00A7)
  0x18, 0x37, 0xB9, 0x0B, 0x38, 0x91, 0x9A, 0x24, 0x63, 0x70, 0xAB, 0x12, 0x83, 0xA0, 0x9B, 0x91,
  // "¨" (U+00A8)
  0x81, 0x14, 0x60,
  // "©" (U+00A9)
  0x18, 0x21, 0x67, 0x53, 0x87, 0x75, 0x95, 0x70, 0x60, 0x92, 0x83, 0x61, 0x61, 0x82, 0x83, 0x33,
  0x61, 0x92, 0x86, 0x61, 0x08, 0x69, 0x57, 0x28, 0x21, 0x77, 0x62,
  // "ª" (U+00AA)
  0x18, 0x68, 0xA4, 0x27, 0x17, 0x50,
  // "«" (U+00AB)
  0x18, 0x90, 0x51, 0x55, 0x69, 0x14, 0x5A, 0x28, 0x14, 0x31,
  // "¬" (U+00AC)
  0x83, 0x5B, 0xBC, 0x43, 0x03, 0x04, 0x30, 0x01,
  // "®" (U+00AE)
  0x18, 0x21, 0x67, 0x53, 0x8B, 0x77, 0x99, 0x47, 0x06, 0x09, 0x27, 0x61, 0x60, 0xAC, 0x23, 0x36,
  0x09, 0x45, 0x61, 0x08, 0x40, 0x67, 0x28, 0x21, 0x77, 0x62,
  // "¯" (U+00AF)
  0x01, 0x0F, 0x90,
  // "°" (U+00B0)
  0x87, 0x28, 0x67, 0x08, 0x29, 0x60,
  // "±" (U+00B1)
  0x20, 0x92, 0x83, 0x5B, 0xDB, 0x32, 0x09, 0x40, 0x92, 0x83, 0x5B, 0xBB, 0x30,
  // "²" (U+00B2)
  0x10, 0x50, 0x83, 0x87, 0x71, 0x05, 0x40, 0x39, 0x61,
  // "³" (U+00B3)
  0x18, 0x34, 0x80, 0x49, 0x28, 0x29, 0x37, 0x50,
  // "´" (U+00B4)
  0x81, 0x23, 0x91,
  // "µ" (U+00B5)
  0x28, 0x95, 0xA0, 0x55, 0x02, 0x80, 0x82, 0x05, 0x50, 0xA2, 0x82, 0x83, 0x2C, 0x28, 0x2A, 0xA7,
  0x92, 0x0A, 0x40, 0x10, 0x94,
  // "¶" (U+00B6)
  0x18, 0x39, 0xFD, 0xA2, 0xA8, 0x16, 0x73, 0xA8, 0x16, 0x71, 0xA8, 0x56, 0x70, 0x59, 0x67, 0x30,
  0x60, 0x73, 0x06, 0x07, 0x30, 0x60, 0x73, 0x00, 0x10,
  // "·" (U+00B7)
  0x07,
  // "¸" (U+00B8)
  0x18, 0x31, 0x18, 0x56,
  // "¹" (U+00B9)
  0x86, 0x15, 0x58, 0x26, 0x53,
  // "º" (U+00BA)
  0x18, 0x67, 0x84, 0x37, 0x17, 0x30,
  // "»" (U+00BB)
  0x81, 0x33, 0x62, 0x89, 0x0A, 0x63, 0x56, 0x92, 0x32, 0x21,
  // "¼" (U+00BC)
  0x38, 0xB5, 0x18, 0x15, 0x08, 0x15, 0x83, 0x60, 0x26, 0x99, 0x05, 0x9A, 0x90, 0x1B, 0x8B, 0x08,
  0x10, 0x31,
  // "½" (U+00BD)
  0x38, 0x93, 0x18, 0x01, 0x50, 0x81, 0x05, 0x83, 0x62, 0x8A, 0x52, 0x69, 0x58, 0x05, 0x93, 0x07,
  0x11, 0x80, 0x54, 0x08, 0x13, 0x96, 0x10,
  // "¾" (U+00BE)
  0x48, 0x93, 0x18, 0x04, 0x80, 0x81, 0x04, 0x93, 0x63, 0x8A, 0x19, 0x90, 0x93, 0x7B, 0x36, 0x90,
  0x18, 0x38, 0xB0, 0x81, 0x20, 0x30,
  // "¿" (U+00BF)
  0x20, 0x50, 0x32, 0x03, 0x20, 0x10, 0x92, 0x83, 0xB2, 0x07, 0x52, 0x09, 0x02, 0x28, 0x24, 0xCB,
  0x10,
  // "À" (U+00C0)
  0x30, 0x54, 0x00, 0x43, 0x09, 0x07, 0x28, 0x11, 0xB8, 0x28, 0x17, 0x4A, 0x28, 0x90, 0xB0, 0xA0,
  0x5D, 0xBC, 0x0B, 0x28, 0x1B, 0x38, 0x20, 0xA0,
  // "Á" (U+00C1)
  0x40, 0x20, 0x34, 0x09, 0x40, 0x90, 0x73, 0x81, 0x1B, 0x83, 0x81, 0x74, 0xA3, 0x81, 0xB0, 0xA2,
  0x82, 0x5D, 0xBC, 0x20, 0xB2, 0x82, 0xB0, 0x38, 0x20, 0xA1,
  // "Â" (U+00C2)
  0x30, 0x10, 0x64, 0x81, 0x87, 0x23, 0x09, 0x07, 0x38, 0x11, 0xB8, 0x38, 0x17, 0x4A, 0x38, 0x1B,
  0x0A, 0x28, 0x25, 0xDB, 0xC2, 0x0B, 0x28, 0x2B, 0x03, 0x82, 0x0A, 0x10,
  // "Ã" (U+00C3)
  0x3A, 0x06, 0x28, 0x11, 0xB8, 0x38, 0x17, 0x4A, 0x38, 0x1B, 0x0A, 0x28, 0x25, 0xDB, 0xC2, 0x0B,
  0x28, 0x2B, 0x03, 0x82, 0x0A, 0x10,
  // "Ä" (U+00C4)
  0x28, 0x11, 0x46, 0x30, 0x90, 0x72, 0x81, 0x1B, 0x82, 0x81, 0x74, 0xA2, 0x89, 0x0B, 0x0A, 0x05,
  0xDB, 0xC0, 0xB2, 0x81, 0xB3, 0x82, 0x0A,
  // "Å" (U+00C5)
  0x30, 0x60, 0x53, 0x90, 0xC2, 0x81, 0x1B, 0x82, 0x81, 0x74, 0xA2, 0x89, 0x0B, 0x0A, 0x05, 0xDB,
  0xC0, 0xB2, 0x81, 0xB3, 0x82, 0x0A,
  // "Æ" (U+00C6)
  0x38, 0x31, 0xDD, 0xB9, 0x38, 0x19, 0x67, 0x48, 0x22, 0xA6, 0x44, 0x89, 0x19, 0x29, 0xCB, 0x20,
  0x2E, 0xBE, 0x48, 0x2A, 0x20, 0xB3, 0x85, 0x39, 0x01, 0xEB, 0x91,
  // "Ç" (U+00C7)
  0x28, 0x49, 0xBB, 0x0A, 0x42, 0x01, 0x0A, 0x30, 0x50, 0x63, 0x06, 0x05, 0x30, 0x30, 0x94, 0x81,
  0x9D, 0xB2, 0x01, 0x08, 0x30, 0x50, 0x62,
  // "È" (U+00C8)
  0x20, 0x54, 0x00, 0x42, 0x84, 0x8B, 0xB4, 0x0A, 0x40, 0xB3, 0x85, 0x1E, 0xB8, 0x03, 0x73, 0x06,
  0x04, 0x38, 0x29, 0xCB, 0x31,
  // "É" (U+00C9)
  0x30, 0x20, 0x33, 0x09, 0x28, 0x48, 0xBB, 0x40, 0xA4, 0x0B, 0x38, 0x51, 0xEB, 0x80, 0x37, 0x30,
  0x60, 0x43, 0x82, 0x9C, 0xB3, 0x10,
  // "Ê" (U+00CA)
  0x20, 0x10, 0x63, 0x89, 0x08, 0x72, 0x08, 0xBB, 0x40, 0xA4, 0x0B, 0x38, 0x51, 0xEB, 0x80, 0x37,
  0x30, 0x60, 0x43, 0x82, 0x9C, 0xB3, 0x10,
  // "Ë" (U+00CB)
  0x18, 0x11, 0x46, 0x28, 0x48, 0xBB, 0x40, 0xA4, 0x0B, 0x38, 0x51, 0xEB, 0x80, 0x37, 0x30, 0x60,
  0x43, 0x82, 0x9C, 0xB3, 0x10,
  // "Ì" (U+00CC)
  0x10, 0x52, 0x89, 0x04, 0x40, 0xCA, 0x08, 0x20, 0xA2, 0x89, 0x0A, 0x01, 0x90, 0x46, 0x0B, 0x91,
  // "Í" (U+00CD)
  0x20, 0x20, 0x32, 0x09, 0x20, 0xC0, 0xA2, 0x08, 0x02, 0x20, 0xA3, 0x0A, 0x20, 0x10, 0x92, 0x04,
  0x06, 0x20, 0xB0, 0x92,
  // "Î" (U+00CE)
  0x10, 0x10, 0x62, 0x84, 0x87, 0x20, 0xCA, 0x20, 0x80, 0x22, 0x0A, 0x30, 0xA2, 0x01, 0x09, 0x20,
  0x40, 0x62, 0x0B, 0x09, 0x20,
  // "Ï" (U+00CF)
  0x89, 0x11, 0x46, 0x0C, 0xA0, 0x82, 0x0A, 0x28, 0x90, 0xA0, 0x19, 0x04, 0x60, 0xB9, 0x10,
  // "Ð" (U+00D0)
  0x18, 0x48, 0xCC, 0x40, 0xA2, 0x81, 0xC0, 0xB2, 0x86, 0xA8, 0xEA, 0x0B, 0x47, 0x28, 0x90, 0xB6,
  0x40, 0x86, 0x9C, 0xB6, 0x10,
  // "Ñ" (U+00D1)
  0x18, 0xC6, 0x86, 0x9C, 0xF0, 0xAA, 0x03, 0x60, 0xA9, 0x06, 0x41, 0x95, 0x59, 0x13, 0x60, 0x9A,
  0x06, 0x30, 0xAA, 0x09, 0x10, 0x68, 0x10,
  // "Ò" (U+00D2)
  0x30, 0x55, 0x00, 0x42, 0x82, 0x1B, 0xB9, 0x28, 0x5A, 0x30, 0x74, 0x29, 0x28, 0x24, 0x75, 0x62,
  0x82, 0x56, 0x65, 0x28, 0x58, 0x33, 0x90, 0x1C, 0x28, 0x28, 0xBB, 0x21,
  // "Ó" (U+00D3)
  0x30, 0x20, 0x34, 0x09, 0x38, 0x21, 0xBB, 0x92, 0x85, 0xA3, 0x07, 0x42, 0x92, 0x82, 0x47, 0x56,
  0x28, 0x25, 0x66, 0x52, 0x85, 0x83, 0x39, 0x01, 0xC2, 0x82, 0x8B, 0xB2, 0x10,
  // "Ô" (U+00D4)
  0x30, 0x10, 0x64, 0x86, 0x87, 0x20, 0x1B, 0xB9, 0x28, 0x5A, 0x30, 0x74, 0x29, 0x28, 0x24, 0x75,
  0x62, 0x82, 0x56, 0x65, 0x28, 0x58, 0x33, 0x90, 0x1C, 0x28, 0x28, 0xBB, 0x21,
  // "Õ" (U+00D5)
  0x10, 0x10, 0xBA, 0x87, 0x60, 0xA3, 0x07, 0x42, 0x92, 0x82, 0x47, 0x56, 0x28, 0x25, 0x66, 0x52,
  0x85, 0x83, 0x39, 0x01, 0xC2, 0x82, 0x8B, 0xB2, 0x10,
  // "Ö" (U+00D6)
  0x28, 0x11, 0x46, 0x28, 0x21, 0xBB, 0x92, 0x85, 0xA3, 0x07, 0x42, 0x92, 0x82, 0x47, 0x56, 0x28,
  0x25, 0x66, 0x52, 0x85, 0x83, 0x39, 0x01, 0xC2, 0x82, 0x8B, 0xB2, 0x10,
  // "×" (U+00D7)
  0x89, 0x61, 0x30, 0x40, 0x97, 0x70, 0x5C, 0x31, 0x70, 0x80,
  // "Ø" (U+00D8)
  0x18, 0xC6, 0x1A, 0xBB, 0x70, 0xA3, 0x0D, 0x42, 0x90, 0x96, 0x75, 0x64, 0x75, 0x66, 0x6A, 0x08,
  0x43, 0xE2, 0x1C, 0x04, 0xCB, 0xB2, 0x10,
  // "Ù" (U+00D9)
  0x30, 0x55, 0x00, 0x42, 0x85, 0x91, 0x04, 0x60, 0xB2, 0x82, 0x73, 0x0A, 0x28, 0x29, 0x12, 0x82,
  0x82, 0xA0, 0x46, 0x28, 0x5A, 0x04, 0x60, 0x56, 0x28, 0x1A, 0xA9, 0x20,
  // "Ú" (U+00DA)
  0x30, 0x20, 0x34, 0x09, 0x38, 0x59, 0x10, 0x46, 0x0B, 0x28, 0x27, 0x30, 0xA2, 0x82, 0x91, 0x28,
  0x28, 0x2A, 0x04, 0x62, 0x85, 0xA0, 0x46, 0x05, 0x62, 0x81, 0xAA, 0x92,
  // "Û" (U+00DB)
  0x20, 0x10, 0x64, 0x81, 0x87, 0x22, 0x85, 0x91, 0x04, 0x60, 0xB2, 0x82, 0x73, 0x0A, 0x28, 0x29,
  0x12, 0x82, 0x82, 0xA0, 0x46, 0x28, 0x5A, 0x04, 0x60, 0x56, 0x28, 0x1A, 0xA9, 0x20,
  // "Ü" (U+00DC)
  0x28, 0x11, 0x46, 0x28, 0x59, 0x10, 0x46, 0x0B, 0x28, 0x27, 0x30, 0xA2, 0x82, 0x91, 0x28, 0x28,
  0x2A, 0x04, 0x62, 0x85, 0xA0, 0x46, 0x05, 0x62, 0x81, 0xAA, 0x92,
  // "Ý" (U+00DD)
  0x30, 0x20, 0x33, 0x89, 0x19, 0x02, 0x80, 0x48, 0x0A, 0x0B, 0x28, 0x1A, 0x56, 0x20, 0x80, 0xB3,
  0x06, 0x05, 0x30, 0x80, 0x23, 0x0A, 0x30,
  // "Þ" (U+00DE)
  0x10, 0x80, 0x23, 0x81, 0xBB, 0x92, 0x8A, 0x3B, 0x08, 0x31, 0xA0, 0x74, 0x37, 0x0B, 0x16, 0xDB,
  0x40, 0x92, 0x30,
  // "ß" (U+00DF)
  0x28, 0x23, 0xBC, 0x22, 0x82, 0xA0, 0x64, 0x28, 0x1B, 0x39, 0x28, 0x22, 0x8A, 0x12, 0x82, 0x55,
  0x2B, 0x28, 0x90, 0x83, 0x0A, 0x10, 0xA6, 0xC9, 0x20, 0xB4, 0x0C, 0x05, 0x40,
  // "à" (U+00E0)
  0x20, 0x54, 0x00, 0x47, 0x8A, 0x58, 0xC8, 0x43, 0x90, 0xB1, 0x73, 0x0B, 0x09, 0x23, 0xB0, 0x4C,
  0x78, 0x10,
  // "á" (U+00E1)
  0x30, 0x20, 0x33, 0x09, 0x78, 0xA5, 0x8C, 0x84, 0x39, 0x0B, 0x17, 0x30, 0xB0, 0x92, 0x3B, 0x04,
  0xC7, 0x81,
  // "â" (U+00E2)
  0x20, 0x10, 0x63, 0x81, 0x87, 0x26, 0x8A, 0x58, 0xC8, 0x43, 0x90, 0xB1, 0x73, 0x0B, 0x09, 0x23,
  0xB0, 0x4C, 0x78, 0x10,
  // "ã" (U+00E3)
  0x28, 0xB1, 0x9B, 0x60, 0x8C, 0x84, 0x39, 0x0B, 0x17, 0x30, 0xB0, 0x92, 0x3B, 0x04, 0xC7, 0x81,
  // "ä" (U+00E4)
  0x18, 0x11, 0x46, 0x78, 0xA5, 0x8C, 0x84, 0x39, 0x0B, 0x17, 0x30, 0xB0, 0x92, 0x3B, 0x04, 0xC7,
  0x81,
  // "å" (U+00E5)
  0x20, 0x60, 0x53, 0x06, 0x05, 0x28, 0xA5, 0x8C, 0x84, 0x39, 0x0B, 0x17, 0x30, 0xB0, 0x92, 0x3B,
  0x04, 0xC7, 0x81,
  // "æ" (U+00E6)
  0x18, 0xA6, 0x8C, 0x9A, 0xC2, 0x39, 0x0D, 0x27, 0x47, 0x30, 0xDB, 0x70, 0x92, 0x6C, 0x38, 0x44,
  0xC8, 0xAB, 0x91,
  // "ç" (U+00E7)
  0x18, 0x38, 0xB7, 0x38, 0x20, 0x80, 0x32, 0x08, 0x03, 0x28, 0x43, 0xEB, 0x01, 0x82, 0x05, 0x06,
  0x20,
  // "è" (U+00E8)
  0x20, 0x53, 0x00, 0x45, 0x89, 0x38, 0xC7, 0x37, 0x2A, 0x8C, 0xA1, 0x83, 0x28, 0x23, 0xCB, 0x20,
  // "é" (U+00E9)
  0x20, 0x20, 0x32, 0x09, 0x68, 0x93, 0x8C, 0x73, 0x72, 0xA8, 0xCA, 0x18, 0x32, 0x82, 0x3C, 0xB2,
  // "ê" (U+00EA)
  0x10, 0x10, 0x62, 0x81, 0x87, 0x25, 0x89, 0x38, 0xC7, 0x37, 0x2A, 0x8C, 0xA1, 0x83, 0x28, 0x23,
  0xCB, 0x20,
  // "ë" (U+00EB)
  0x18, 0x11, 0x46, 0x58, 0x93, 0x8C, 0x73, 0x72, 0xA8, 0xCA, 0x18, 0x32, 0x82, 0x3C, 0xB2,
  // "ì" (U+00EC)
  0x10, 0x52, 0x00, 0x44, 0x89, 0x2A, 0x02, 0x80, 0x55, 0x07, 0x30, 0xA2,
  // "í" (U+00ED)
  0x18, 0x22, 0x30, 0x95, 0x89, 0x2A, 0x02, 0x80, 0x55, 0x07, 0x30, 0xA2,
  // "î" (U+00EE)
  0x84, 0x16, 0x08, 0x72, 0x48, 0x92, 0xA0, 0x28, 0x05, 0x50, 0x73, 0x0A, 0x20,
  // "ï" (U+00EF)
  0x81, 0x14, 0x64, 0x89, 0x2A, 0x02, 0x80, 0x55, 0x07, 0x30, 0xA2,
  // "ð" (U+00F0)
  0x28, 0x14, 0x22, 0x20, 0xA0, 0xB2, 0x81, 0x13, 0xA2, 0x8A, 0x58, 0xBB, 0x15, 0x70, 0xC1, 0x82,
  0x0A, 0x09, 0x21, 0xA0, 0x3C, 0xC2, 0x10,
  // "ñ" (U+00F1)
  0x28, 0xB1, 0x9B, 0x60, 0xBA, 0xC0, 0x2D, 0x09, 0x25, 0x70, 0xB0, 0x83, 0x0B, 0x0B, 0x01, 0xA1,
  // "ò" (U+00F2)
  0x20, 0x54, 0x00, 0x47, 0x8A, 0x58, 0xC9, 0x04, 0x80, 0xA1, 0x82, 0x0A, 0x08, 0x31, 0xB0, 0x2C,
  0xC2, 0x10,
  // "ó" (U+00F3)
  0x20, 0x20, 0x33, 0x09, 0x71, 0x8A, 0x58, 0xC9, 0x04, 0x80, 0xA1, 0x82, 0x0A, 0x08, 0x31, 0xB0,
  0x2C, 0xC2, 0x10,
  // "ô" (U+00F4)
  0x10, 0x10, 0x63, 0x81, 0x87, 0x27, 0x8A, 0x58, 0xC9, 0x04, 0x80, 0xA1, 0x82, 0x0A, 0x08, 0x31,
  0xB0, 0x2C, 0xC2, 0x10,
  // "õ" (U+00F5)
  0x18, 0x19, 0xB6, 0x28, 0xA5, 0x8C, 0x90, 0x48, 0x0A, 0x18, 0x20, 0xA0, 0x83, 0x1B, 0x02, 0xCC,
  0x21,
  // "ö" (U+00F6)
  0x18, 0x11, 0x46, 0x78, 0xA5, 0x8C, 0x90, 0x48, 0x0A, 0x18, 0x20, 0xA0, 0x83, 0x1B, 0x02, 0xCC,
  0x21,
  // "÷" (U+00F7)
  0x20, 0x72, 0x83, 0x5B, 0xBB, 0x37, 0x07, 0x20,
  // "ø" (U+00F8)
  0x18, 0xA5, 0x8B, 0xC1, 0x47, 0x4D, 0x08, 0x48, 0xA0, 0x8A, 0x1A, 0x08, 0xCC, 0x21,
  // "ù" (U+00F9)
  0x20, 0x54, 0x00, 0x47, 0x8A, 0x5A, 0x06, 0x43, 0x80, 0x81, 0x55, 0x0B, 0x08, 0x32, 0xB0, 0x5B,
  0x78, 0x10,
  // "ú" (U+00FA)
  0x30, 0x20, 0x33, 0x09, 0x78, 0xA5, 0xA0, 0x64, 0x38, 0x08, 0x15, 0x50, 0xB0, 0x83, 0x2B, 0x05,
  0xB7, 0x81,
  // "û" (U+00FB)
  0x20, 0x10, 0x63, 0x81, 0x87, 0x26, 0x8A, 0x5A, 0x06, 0x43, 0x80, 0x81, 0x55, 0x0B, 0x08, 0x32,
  0xB0, 0x5B, 0x78, 0x10,
  // "ü" (U+00FC)
  0x18, 0x11, 0x46, 0x78, 0xA5, 0xA0, 0x64, 0x38, 0x08, 0x15, 0x50, 0xB0, 0x83, 0x2B, 0x05, 0xB7,
  0x81,
  // "ý" (U+00FD)
  0x30, 0x20, 0x33, 0x09, 0x78, 0x93, 0x82, 0x0B, 0x06, 0x45, 0x60, 0x45, 0xA2, 0x81, 0x2A, 0x63,
  0x0E, 0x30, 0x50, 0x72, 0x08, 0x0B, 0x30,
  // "þ" (U+00FE)
  0x20, 0x90, 0x14, 0x0A, 0x58, 0x1B, 0x9B, 0x28, 0x96, 0x2C, 0x08, 0x30, 0x56, 0x09, 0x20, 0x85,
  0x0B, 0x28, 0x2A, 0x8B, 0x42, 0x0A, 0x40, 0x10, 0x94,
  // "ÿ" (U+00FF)
  0x28, 0x11, 0x46, 0x68, 0x93, 0x82, 0x0B, 0x06, 0x45, 0x60, 0x45, 0xA2, 0x81, 0x2A, 0x63, 0x0E,
  0x30, 0x50, 0x72, 0x08, 0x0B, 0x30,
  // "Ā" (U+0100)
  0x3A, 0x01, 0x28, 0x11, 0xB8, 0x38, 0x17, 0x4A, 0x38, 0x1B, 0x0A, 0x28, 0x25, 0xDB, 0xC2, 0x0B,
  0x28, 0x2B, 0x03, 0x82, 0x0A, 0x10,
  // "ā" (U+0101)
  0x28, 0xB1, 0xBB, 0x10, 0x8C, 0x84, 0x39, 0x0B, 0x17, 0x30, 0xB0, 0x92, 0x3B, 0x04, 0xC7, 0x81,
  // "Ă" (U+0102)
  0x3A, 0x01, 0x28, 0x11, 0xB8, 0x38, 0x17, 0x4A, 0x38, 0x1B, 0x0A, 0x28, 0x25, 0xDB, 0xC2, 0x0B,
  0x28, 0x2B, 0x03, 0x82, 0x0A, 0x10,
  // "ă" (U+0103)
  0x28, 0xB1, 0x8A, 0x10, 0x8C, 0x84, 0x39, 0x0B, 0x17, 0x30, 0xB0, 0x92, 0x3B, 0x04, 0xC7, 0x81,
  // "Ą" (U+0104)
  0x30, 0x90, 0x72, 0x81, 0x1B, 0x82, 0x81, 0x74, 0xA2, 0x89, 0x0B, 0x0A, 0x05, 0xDB, 0xC0, 0xB2,
  0x81, 0xB3, 0x82, 0x0B, 0x30, 0x20, 0x53, 0x02, 0x07,
  // "ą" (U+0105)
  0x18, 0xA5, 0x8C, 0x84, 0x39, 0x0B, 0x17, 0x30, 0xB0, 0x92, 0x3B, 0x04, 0xC9, 0x82, 0x02, 0x05,
  0x30, 0x20, 0x72,
  // "Ć" (U+0106)
  0x30, 0x20, 0x33, 0x09, 0x38, 0x49, 0xBB, 0x0A, 0x42, 0x01, 0x0A, 0x30, 0x50, 0x63, 0x06, 0x05,
  0x30, 0x30, 0x94, 0x81, 0x9C, 0xB1,
  // "ć" (U+0107)
  0x20, 0x20, 0x32, 0x09, 0x68, 0x38, 0xB7, 0x38, 0x20, 0x80, 0x32, 0x08, 0x03, 0x28, 0x13, 0xCB,
  0x10,
  // "Ĉ" (U+0108)
  0x20, 0x10, 0x63, 0x81, 0x87, 0x22, 0x84, 0x9B, 0xB0, 0xA4, 0x20, 0x10, 0xA3, 0x05, 0x06, 0x30,
  0x60, 0x53, 0x03, 0x09, 0x48, 0x19, 0xCB, 0x10,
  // "ĉ" (U+0109)
  0x10, 0x10, 0x62, 0x81, 0x87, 0x25, 0x83, 0x8B, 0x73, 0x82, 0x08, 0x03, 0x20, 0x80, 0x32, 0x81,
  0x3C, 0xB1,
  // "Ċ" (U+010A)
  0x30, 0x73, 0x84, 0x9B, 0xB0, 0xA4, 0x20, 0x10, 0xA3, 0x05, 0x06, 0x30, 0x60, 0x53, 0x03, 0x09,
  0x48, 0x19, 0xCB, 0x10,
  // "ċ" (U+010B)
  0x20, 0x76, 0x83, 0x8B, 0x73, 0x82, 0x08, 0x03, 0x20, 0x80, 0x32, 0x81, 0x3C, 0xB1,
  // "Č" (U+010C)
  0x28, 0x14, 0x13, 0x20, 0x60, 0xB3, 0x84, 0x9B, 0xB0, 0xA4, 0x20, 0x10, 0xA3, 0x05, 0x06, 0x30,
  0x60, 0x53, 0x03, 0x09, 0x48, 0x19, 0xCB, 0x10,
  // "č" (U+010D)
  0x18, 0x44, 0x13, 0x06, 0xB6, 0x83, 0x8B, 0x73, 0x82, 0x08, 0x03, 0x20, 0x80, 0x32, 0x81, 0x3C,
  0xB1,
  // "Ď" (U+010E)
  0x28, 0x14, 0x13, 0x20, 0x60, 0xB2, 0x84, 0x8C, 0xC4, 0x0A, 0x28, 0x1C, 0x0B, 0x28, 0x1A, 0x1A,
  0x28, 0x1B, 0x37, 0x28, 0x90, 0xB6, 0x40, 0x86, 0x9C, 0xB6, 0x10,
  // "ď" (U+010F)
  0x40, 0xA0, 0x93, 0x8A, 0x12, 0x83, 0x08, 0xC9, 0x40, 0x39, 0x0B, 0x20, 0x73, 0x0B, 0x28, 0x29,
  0x23, 0xB2, 0x82, 0x4C, 0x78, 0x20,
  // "Đ" (U+0110)
  0x18, 0x48, 0xCC, 0x40, 0xA2, 0x81, 0xC0, 0xB2, 0x86, 0xA8, 0xEA, 0x0B, 0x47, 0x28, 0x90, 0xB6,
  0x40, 0x86, 0x9C, 0xB6, 0x10,
  // "đ" (U+0111)
  0x40, 0xA3, 0x8A, 0x26, 0xCD, 0x10, 0x8C, 0x96, 0x03, 0x80, 0xB2, 0x07, 0x30, 0xB2, 0x82, 0x92,
  0x3C, 0x28, 0x24, 0xC7, 0x92,
  // "Ē" (U+0112)
  0x10, 0x9A, 0x81, 0x50, 0xA4, 0x0B, 0x38, 0x51, 0xEB, 0x80, 0x37, 0x30, 0x60, 0x43, 0x82, 0x9C,
  0xB3, 0x10,
  // "ē" (U+0113)
  0x28, 0xA2, 0xBB, 0x10, 0x8C, 0x70, 0x37, 0x2A, 0x08, 0xCA, 0x10, 0x83, 0x38, 0x23, 0xCB, 0x21,
  // "Ĕ" (U+0114)
  0x10, 0x8A, 0x81, 0x60, 0xA4, 0x0B, 0x38, 0x51, 0xEB, 0x80, 0x37, 0x30, 0x60, 0x43, 0x82, 0x9C,
  0xB3, 0x10,
  // "ĕ" (U+0115)
  0x28, 0xA2, 0x8A, 0x10, 0x8C, 0x70, 0x37, 0x2A, 0x08, 0xCA, 0x10, 0x83, 0x38, 0x23, 0xCB, 0x21,
  // "Ė" (U+0116)
  0x30, 0x72, 0x84, 0x8B, 0xB4, 0x0A, 0x40, 0xB3, 0x85, 0x1E, 0xB8, 0x03, 0x73, 0x06, 0x04, 0x38,
  0x29, 0xCB, 0x31,
  // "ė" (U+0117)
  0x20, 0x76, 0x89, 0x38, 0xC7, 0x37, 0x2A, 0x8C, 0xA1, 0x83, 0x28, 0x23, 0xCB, 0x20,
  // "Ę" (U+0118)
  0x18, 0x48, 0xBB, 0x40, 0xA4, 0x0B, 0x38, 0x51, 0xEB, 0x80, 0x37, 0x30, 0x60, 0x43, 0x82, 0x9C,
  0xD3, 0x20, 0x20, 0x53, 0x02, 0x07, 0x20,
  // "ę" (U+0119)
  0x18, 0x93, 0x8C, 0x73, 0x72, 0xA8, 0xCA, 0x18, 0x32, 0x85, 0x3C, 0xC2, 0x02, 0x42, 0x04, 0x08,
  0x10,
  // "Ě" (U+011A)
  0x28, 0x14, 0x13, 0x20, 0x60, 0xB2, 0x84, 0x8B, 0xB4, 0x0A, 0x40, 0xB3, 0x85, 0x1E, 0xB8, 0x03,
  0x73, 0x06, 0x04, 0x38, 0x29, 0xCB, 0x31,
  // "ě" (U+011B)
  0x18, 0x44, 0x13, 0x06, 0xB6, 0x89, 0x38, 0xC7, 0x37, 0x2A, 0x8C, 0xA1, 0x83, 0x28, 0x23, 0xCB,
  0x20,
  // "Ĝ" (U+011C)
  0x30, 0x10, 0x64, 0x89, 0x28, 0x72, 0x01, 0xAB, 0xC2, 0x09, 0x43, 0x01, 0x0A, 0x48, 0x64, 0x60,
  0xAC, 0x06, 0x52, 0x85, 0xB0, 0x39, 0x01, 0x92, 0x82, 0x8C, 0xB4, 0x10,
  // "ĝ" (U+011D)
  0x20, 0x10, 0x63, 0x81, 0x87, 0x26, 0x8A, 0x58, 0xC8, 0x43, 0x90, 0xB1, 0x73, 0x0B, 0x09, 0x23,
  0xB0, 0x4C, 0x88, 0x38, 0x46, 0x40, 0x9B, 0xA2,
  // "Ğ" (U+011E)
  0x10, 0x10, 0xAA, 0x82, 0x40, 0x94, 0x30, 0x10, 0xA4, 0x86, 0x46, 0x0A, 0xC0, 0x65, 0x28, 0x5B,
  0x03, 0x90, 0x19, 0x28, 0x28, 0xCB, 0x41,
  // "ğ" (U+011F)
  0x28, 0xB1, 0x8A, 0x10, 0x8C, 0x84, 0x39, 0x0B, 0x17, 0x30, 0xB0, 0x92, 0x3B, 0x04, 0xC8, 0x83,
  0x84, 0x64, 0x09, 0xBA, 0x20,
  // "Ġ" (U+0120)
  0x30, 0x73, 0x86, 0x1A, 0xBC, 0x20, 0x94, 0x30, 0x10, 0xA4, 0x86, 0x46, 0x0A, 0xC0, 0x65, 0x28,
  0x5B, 0x03, 0x90, 0x19, 0x28, 0x28, 0xCB, 0x41,
  // "ġ" (U+0121)
  0x20, 0x77, 0x18, 0xA5, 0x8C, 0x84, 0x39, 0x0B, 0x17, 0x30, 0xB0, 0x92, 0x3B, 0x04, 0xC8, 0x83,
  0x84, 0x64, 0x09, 0xBA, 0x20,
  // "Ģ" (U+0122)
  0x18, 0x61, 0xAB, 0xC2, 0x09, 0x43, 0x01, 0x0A, 0x48, 0x64, 0x60, 0xAC, 0x06, 0x52, 0x85, 0xB0,
  0x39, 0x01, 0x92, 0x82, 0x8C, 0xB4, 0x30, 0x54, 0x03, 0x05, 0x30,
  // "ģ" (U+0123)
  0x20, 0x20, 0x63, 0x03, 0x01, 0x28, 0xA5, 0x8C, 0x84, 0x39, 0x0B, 0x17, 0x30, 0xB0, 0x92, 0x3B,
  0x04, 0xC8, 0x83, 0x84, 0x64, 0x09, 0xBA, 0x20,
  // "Ĥ" (U+0124)
  0x20, 0x10, 0x64, 0x81, 0x87, 0x22, 0x85, 0x82, 0x05, 0x50, 0xA2, 0x82, 0x73, 0x0B, 0x20, 0x92,
  0x85, 0xEB, 0xBC, 0x03, 0x72, 0x89, 0x3A, 0x06, 0x40, 0x28, 0x08, 0x20, 0x55, 0x10,
  // "ĥ" (U+0125)
  0x10, 0x10, 0x63, 0x81, 0x87, 0x27, 0x09, 0x01, 0x30, 0xB4, 0x8A, 0x5B, 0x9C, 0x02, 0xC0, 0x82,
  0x56, 0x0A, 0x07, 0x30, 0xA0, 0xA0, 0x19, 0x10,
  // "Ħ" (U+0126)
  0x18, 0x93, 0x82, 0x05, 0x64, 0xDA, 0xAC, 0xA0, 0xB2, 0x89, 0x0A, 0x01, 0xEB, 0xBC, 0x03, 0x72,
  0x89, 0x3A, 0x06, 0x40, 0x28, 0x09, 0x20, 0x55, 0x10,
  // "ħ" (U+0127)
  0x10, 0x80, 0x22, 0x82, 0x2D, 0x93, 0x28, 0xA5, 0xBA, 0xC0, 0x1C, 0x09, 0x24, 0x60, 0xA0, 0x73,
  0x0A, 0x0A, 0x01, 0x91,
  // "Ĩ" (U+0128)
  0x1A, 0x82, 0x60, 0x82, 0x20, 0xA3, 0x0A, 0x20, 0x10, 0x92, 0x04, 0x06, 0x20, 0xB0, 0x92,
  // "ĩ" (U+0129)
  0x89, 0x69, 0xB6, 0x0A, 0x02, 0x80, 0x55, 0x07, 0x30, 0xA2,
  // "Ī" (U+012A)
  0x1A, 0x82, 0x10, 0x82, 0x20, 0xA3, 0x0A, 0x20, 0x10, 0x92, 0x04, 0x06, 0x20, 0xB0, 0x92,
  // "ī" (U+012B)
  0x18, 0x3B, 0xB1, 0x0A, 0x20, 0x20, 0x82, 0x00, 0x52, 0x07, 0x03, 0x20, 0xA3,
  // "Ĭ" (U+012C)
  0x1A, 0x82, 0x20, 0x82, 0x20, 0xA3, 0x0A, 0x20, 0x10, 0x92, 0x04, 0x06, 0x20, 0xB0, 0x92,
  // "ĭ" (U+012D)
  0x89, 0x68, 0xA1, 0x0A, 0x02, 0x80, 0x55, 0x07, 0x30, 0xA2,
  // "Į" (U+012E)
  0x20, 0xC0, 0xA2, 0x08, 0x02, 0x20, 0xA3, 0x0A, 0x20, 0x10, 0x92, 0x04, 0x06, 0x28, 0x3D, 0x90,
  0x25, 0x20, 0x20, 0x72,
  // "į" (U+012F)
  0x20, 0x65, 0x8A, 0x0A, 0x02, 0x80, 0x55, 0x07, 0x30, 0xC0, 0x25, 0x02, 0x71,
  // "İ" (U+0130)
  0x28, 0x77, 0x0C, 0xA0, 0x82, 0x0A, 0x28, 0x90, 0xA0, 0x19, 0x04, 0x60, 0xB9, 0x10,
  // "ı" (U+0131)
  0x18, 0x6A, 0x28, 0x55, 0x73, 0xA1,
  // "Ĳ" (U+0132)
  0x18, 0x90, 0xCA, 0x08, 0x20, 0x82, 0x0A, 0x20, 0xA2, 0x0B, 0x28, 0xA3, 0xA0, 0x28, 0x01, 0x90,
  0x55, 0x04, 0x60, 0x82, 0x0B, 0x90, 0xB3, 0x81, 0x2B, 0x52,
  // "ĳ" (U+0133)
  0x18, 0x16, 0x06, 0x58, 0xA0, 0xA0, 0xA2, 0x82, 0x85, 0x55, 0x57, 0x38, 0x2A, 0x0A, 0x30, 0xB2,
  0x0C, 0x05, 0x10,
  // "Ĵ" (U+0134)
  0x30, 0x10, 0x64, 0x81, 0x87, 0x23, 0x08, 0x02, 0x40, 0xA5, 0x0B, 0x40, 0x20, 0x84, 0x00, 0x54,
  0x08, 0x02, 0x40, 0xB3, 0x81, 0x2B, 0x53,
  // "ĵ" (U+0135)
  0x10, 0x10, 0x62, 0x81, 0x87, 0x26, 0x0A, 0x20, 0x20, 0x82, 0x00, 0x52, 0x08, 0x02, 0x20, 0xA3,
  0x0B, 0x20, 0xC0, 0x52,
  // "Ķ" (U+0136)
  0x18, 0x97, 0x82, 0x1A, 0x0A, 0x0A, 0x10, 0xB9, 0x30, 0x1E, 0xC2, 0x89, 0x43, 0x78, 0x30, 0x64,
  0x38, 0x09, 0x20, 0xB3, 0x05, 0x30, 0x30, 0x52,
  // "ķ" (U+0137)
  0x10, 0x90, 0x12, 0x0B, 0x38, 0xA3, 0xA1, 0xA2, 0x9A, 0x15, 0xD7, 0x07, 0x3B, 0x0A, 0x07, 0x40,
  0x52, 0x03, 0x05, 0x20,
  // "ĸ" (U+0138)
  0x18, 0xA1, 0xA1, 0xA2, 0x9A, 0x15, 0xD7, 0x07, 0x3B, 0x0A, 0x07, 0x40,
  // "Ĺ" (U+0139)
  0x20, 0x20, 0x32, 0x09, 0x20, 0x80, 0x22, 0x0A, 0x30, 0xB2, 0x01, 0x09, 0x20, 0x30, 0x72, 0x06,
  0x04, 0x28, 0x29, 0xCB, 0x30,
  // "ĺ" (U+013A)
  0x20, 0x20, 0x32, 0x09, 0x60, 0x90, 0x12, 0x0A, 0x30, 0xA2, 0x02, 0x08, 0x20, 0x05, 0x20, 0x70,
  0x32, 0x0A, 0x30,
  // "Ļ" (U+013B)
  0x10, 0x80, 0x22, 0x0A, 0x30, 0xB2, 0x01, 0x09, 0x20, 0x30, 0x72, 0x06, 0x04, 0x28, 0x49, 0xCB,
  0x30, 0x52, 0x03, 0x05, 0x20,
  // "ļ" (U+013C)
  0x20, 0x90, 0x12, 0x0A, 0x30, 0xA2, 0x02, 0x08, 0x20, 0x05, 0x20, 0x70, 0x32, 0x0A, 0x30, 0x52,
  0x03, 0x05, 0x20,
  // "Ľ" (U+013D)
  0x18, 0x78, 0x29, 0x0A, 0x04, 0x0B, 0x20, 0x10, 0x92, 0x03, 0x07, 0x20, 0x60, 0x42, 0x82, 0x9C,
  0xB3,
  // "ľ" (U+013E)
  0x18, 0x49, 0x74, 0x0A, 0x32, 0x0A, 0x20, 0x20, 0x82, 0x00, 0x52, 0x07, 0x03, 0x20, 0xA3,
  // "Ŀ" (U+013F)
  0x10, 0x80, 0x22, 0x0A, 0x30, 0xB2, 0x84, 0x19, 0x07, 0x37, 0x20, 0x60, 0x42, 0x82, 0x9C, 0xB3,
  // "ŀ" (U+0140)
  0x18, 0x29, 0x10, 0xA2, 0x89, 0x2A, 0x02, 0x87, 0x55, 0x07, 0x30, 0xA2,
  // "Ł" (U+0141)
  0x10, 0x80, 0x22, 0x0A, 0x38, 0x7B, 0x10, 0x1E, 0x50, 0xA7, 0x20, 0x60, 0x42, 0x82, 0x9C, 0xB3,
  // "ł" (U+0142)
  0x18, 0x29, 0x10, 0xA2, 0x89, 0x2B, 0x03, 0xD1, 0xA6, 0x07, 0x30, 0xA2,
  // "Ń" (U+0143)
  0x30, 0x20, 0x34, 0x09, 0x38, 0xC6, 0x86, 0x01, 0x90, 0xAA, 0x03, 0x60, 0xA9, 0x06, 0x41, 0x95,
  0x59, 0x13, 0x60, 0x9A, 0x06, 0x30, 0xAA, 0x09, 0x10, 0x68, 0x10,
  // "ń" (U+0144)
  0x30, 0x20, 0x33, 0x09, 0x78, 0xA5, 0xBA, 0xC0, 0x2D, 0x09, 0x25, 0x70, 0xB0, 0x83, 0x0B, 0x0B,
  0x01, 0xA1,
  // "Ņ" (U+0145)
  0x18, 0xC6, 0x86, 0x01, 0x90, 0xAA, 0x03, 0x60, 0xA9, 0x06, 0x41, 0x95, 0x59, 0x13, 0x60, 0x9A,
  0x06, 0x30, 0xAA, 0x09, 0x10, 0x68, 0x30, 0x54, 0x03, 0x05, 0x30,
  // "ņ" (U+0146)
  0x18, 0xA5, 0xBA, 0xC0, 0x2D, 0x09, 0x25, 0x70, 0xB0, 0x83, 0x0B, 0x0B, 0x01, 0xA2, 0x05, 0x30,
  0x30, 0x53,
  // "Ň" (U+0147)
  0x38, 0x14, 0x13, 0x30, 0x60, 0xB2, 0x8C, 0x68, 0x60, 0x19, 0x0A, 0xA0, 0x36, 0x0A, 0x90, 0x64,
  0x19, 0x55, 0x91, 0x36, 0x09, 0xA0, 0x63, 0x0A, 0xA0, 0x91, 0x06, 0x81,
  // "ň" (U+0148)
  0x28, 0x14, 0x13, 0x20, 0x60, 0xB7, 0x8A, 0x5B, 0xAC, 0x02, 0xD0, 0x92, 0x57, 0x0B, 0x08, 0x30,
  0xB0, 0xB0, 0x1A, 0x10,
  // "ŉ" (U+0149)
  0x10, 0xB4, 0x00, 0x46, 0x81, 0xBA, 0xC2, 0x89, 0x02, 0xD0, 0x92, 0x05, 0x70, 0xB2, 0x82, 0x83,
  0x0B, 0x28, 0x2B, 0x01, 0xA1,
  // "Ŋ" (U+014A)
  0x18, 0xC6, 0x86, 0x01, 0x90, 0x9A, 0x03, 0x60, 0xA9, 0x16, 0x41, 0x95, 0x59, 0x13, 0x60, 0x9A,
  0x06, 0x30, 0xAA, 0x09, 0x10, 0x58, 0x40, 0x60, 0x53, 0x09, 0x0A, 0x20,
  // "ŋ" (U+014B)
  0x18, 0xA5, 0xAA, 0xC0, 0x2C, 0x08, 0x25, 0x60, 0xA0, 0x73, 0x0A, 0x0A, 0x01, 0x93, 0x05, 0x06,
  0x28, 0x14, 0xC1, 0x10,
  // "Ō" (U+014C)
  0x10, 0x10, 0xBA, 0x87, 0x10, 0xA3, 0x07, 0x42, 0x92, 0x82, 0x47, 0x56, 0x28, 0x25, 0x66, 0x52,
  0x85, 0x83, 0x39, 0x01, 0xC2, 0x82, 0x8B, 0xB2, 0x10,
  // "ō" (U+014D)
  0x28, 0xB1, 0xBB, 0x10, 0x8C, 0x90, 0x48, 0x0A, 0x18, 0x20, 0xA0, 0x83, 0x1B, 0x02, 0xCC, 0x21,
  // "Ŏ" (U+014E)
  0x10, 0x10, 0xBA, 0x87, 0x20, 0xA3, 0x07, 0x42, 0x92, 0x82, 0x47, 0x56, 0x28, 0x25, 0x66, 0x52,
  0x85, 0x83, 0x39, 0x01, 0xC2, 0x82, 0x8B, 0xB2, 0x10,
  // "ŏ" (U+014F)
  0x28, 0xB1, 0x8A, 0x10, 0x8C, 0x90, 0x48, 0x0A, 0x18, 0x20, 0xA0, 0x83, 0x1B, 0x02, 0xCC, 0x21,
  // "Ő" (U+0150)
  0x38, 0x67, 0x66, 0x01, 0xBC, 0xB2, 0x85, 0xA3, 0x07, 0x42, 0x92, 0x82, 0x47, 0x56, 0x28, 0x25,
  0x66, 0x52, 0x85, 0x83, 0x39, 0x01, 0xC2, 0x82, 0x8B, 0xB2, 0x10,
  // "ő" (U+0151)
  0x28, 0x17, 0x66, 0x20, 0x01, 0x28, 0xA5, 0x8C, 0x90, 0x48, 0x0A, 0x18, 0x20, 0xA0, 0x83, 0x1B,
  0x02, 0xCC, 0x21,
  // "Œ" (U+0152)
  0x18, 0x92, 0x1B, 0xBE, 0xBB, 0x10, 0xA3, 0x0B, 0x38, 0x32, 0x90, 0x29, 0x38, 0x93, 0x56, 0x05,
  0xDB, 0x50, 0x65, 0x07, 0x33, 0x82, 0x39, 0x0A, 0x58, 0x38, 0xBE, 0xBB, 0x20,
  // "œ" (U+0153)
  0x18, 0xA7, 0x8B, 0x87, 0xC6, 0x48, 0x0A, 0x63, 0x98, 0x20, 0xAC, 0xA1, 0x82, 0x1E, 0x22, 0x85,
  0x2C, 0xB4, 0xCB, 0x10,
  // "Ŕ" (U+0154)
  0x30, 0x20, 0x33, 0x09, 0x28, 0xB7, 0x8C, 0xC2, 0x0A, 0x03, 0x70, 0xA0, 0x75, 0x1D, 0xD8, 0x03,
  0x65, 0x50, 0x64, 0x19, 0x09, 0x10, 0xB1,
  // "ŕ" (U+0155)
  0x20, 0x20, 0x32, 0x09, 0x68, 0x3A, 0xA4, 0x2C, 0x20, 0x50, 0x62, 0x07, 0x03, 0x20, 0xA3,
  // "Ŗ" (U+0156)
  0x18, 0xB7, 0x8C, 0xC2, 0x0A, 0x03, 0x70, 0xA0, 0x75, 0x1D, 0xD8, 0x03, 0x65, 0x50, 0x64, 0x19,
  0x09, 0x10, 0xB3, 0x05, 0x30, 0x30, 0x52,
  // "ŗ" (U+0157)
  0x28, 0x4A, 0xA4, 0x02, 0xC3, 0x05, 0x06, 0x30, 0x70, 0x33, 0x0A, 0x40, 0x53, 0x03, 0x05, 0x30,
  // "Ř" (U+0158)
  0x28, 0x14, 0x13, 0x20, 0x60, 0xB2, 0x8B, 0x78, 0xCC, 0x20, 0xA0, 0x37, 0x0A, 0x07, 0x51, 0xDD,
  0x80, 0x36, 0x55, 0x06, 0x41, 0x90, 0x91, 0x0B, 0x10,
  // "ř" (U+0159)
  0x18, 0x44, 0x13, 0x06, 0xB6, 0x83, 0xAA, 0x42, 0xC2, 0x05, 0x06, 0x20, 0x70, 0x32, 0x0A, 0x30,
  // "Ś" (U+015A)
  0x20, 0x20, 0x32, 0x09, 0x28, 0x37, 0xBC, 0x0A, 0x20, 0x10, 0xC3, 0x81, 0x5B, 0x12, 0x05, 0x07,
  0x28, 0x45, 0x7A, 0xBB, 0x10,
  // "ś" (U+015B)
  0x20, 0x20, 0x32, 0x09, 0x58, 0x42, 0xCB, 0x25, 0x53, 0x09, 0x05, 0x38, 0x3B, 0x0B, 0xC7, 0x10,
  // "Ŝ" (U+015C)
  0x20, 0x10, 0x63, 0x85, 0x87, 0x20, 0x7B, 0xC2, 0x0A, 0x30, 0x10, 0xC4, 0x81, 0x5B, 0x13, 0x05,
  0x07, 0x38, 0x55, 0x70, 0xAB, 0xB1, 0x10,
  // "ŝ" (U+015D)
  0x10, 0x10, 0x62, 0x81, 0x87, 0x24, 0x84, 0x2C, 0xB2, 0x55, 0x30, 0x90, 0x53, 0x83, 0xB0, 0xBC,
  0x71,
  // "Ş" (U+015E)
  0x18, 0x37, 0xBC, 0x0A, 0x20, 0x10, 0xC3, 0x81, 0x5B, 0x12, 0x05, 0x07, 0x28, 0x65, 0x7A, 0xDB,
  0x11, 0x82, 0x05, 0x06, 0x20,
  // "ş" (U+015F)
  0x84, 0x2C, 0xB2, 0x55, 0x30, 0x90, 0x53, 0x86, 0xB0, 0xBE, 0x70, 0x18, 0x20, 0x50, 0x62,
  // "Š" (U+0160)
  0x28, 0x14, 0x13, 0x20, 0x60, 0xB2, 0x81, 0x7B, 0xC2, 0x0A, 0x30, 0x10, 0xC4, 0x81, 0x5B, 0x13,
  0x05, 0x07, 0x38, 0x55, 0x70, 0xAB, 0xB1, 0x10,
  // "š" (U+0161)
  0x18, 0x44, 0x13, 0x06, 0xB5, 0x84, 0x2C, 0xB2, 0x55, 0x30, 0x90, 0x53, 0x83, 0xB0, 0xBC, 0x71,
  // "Ţ" (U+0162)
  0x83, 0x2B, 0xEB, 0x72, 0x0B, 0x40, 0xA3, 0x02, 0x08, 0x30, 0x05, 0x30, 0x80, 0x33, 0x0C, 0x30,
  0x10, 0x83, 0x05, 0x06, 0x30,
  // "ţ" (U+0163)
  0x18, 0xA4, 0x90, 0x5E, 0x92, 0x90, 0x45, 0x07, 0x30, 0x5E, 0x11, 0x80, 0x56, 0x10,
  // "Ť" (U+0164)
  0x28, 0x14, 0x13, 0x28, 0x66, 0xB0, 0x2B, 0xEB, 0x72, 0x0B, 0x40, 0xA3, 0x02, 0x08, 0x30, 0x05,
  0x30, 0x80, 0x33, 0x0A, 0x30,
  // "ť" (U+0165)
  0x28, 0x92, 0x54, 0x09, 0x30, 0x5E, 0x90, 0x29, 0x20, 0x40, 0x52, 0x07, 0x03, 0x28, 0x15, 0xC1,
  0x10,
  // "Ŧ" (U+0166)
  0x83, 0x2B, 0xEB, 0x72, 0x0B, 0x40, 0xA2, 0x82, 0x3C, 0xD7, 0x20, 0x05, 0x30, 0x80, 0x33, 0x0A,
  0x30,
  // "ŧ" (U+0167)
  0x18, 0x97, 0x90, 0x5E, 0x91, 0x90, 0xAD, 0x46, 0x30, 0x6C, 0x10,
  // "Ũ" (U+0168)
  0x18, 0x59, 0xAB, 0xA6, 0x0B, 0x28, 0x27, 0x30, 0xA2, 0x82, 0x91, 0x28, 0x28, 0x2A, 0x04, 0x62,
  0x85, 0xA0, 0x46, 0x05, 0x62, 0x81, 0xAA, 0x92,
  // "ũ" (U+0169)
  0x28, 0xB1, 0x9B, 0x60, 0xA0, 0x64, 0x38, 0x08, 0x15, 0x50, 0xB0, 0x83, 0x2B, 0x05, 0xB7, 0x81,
  // "Ū" (U+016A)
  0x18, 0x59, 0x1B, 0xF7, 0x0B, 0x28, 0x27, 0x30, 0xA2, 0x82, 0x91, 0x28, 0x28, 0x2A, 0x04, 0x62,
  0x85, 0xA0, 0x46, 0x05, 0x62, 0x81, 0xAA, 0x92,
  // "ū" (U+016B)
  0x28, 0xB1, 0xBB, 0x10, 0xA0, 0x64, 0x38, 0x08, 0x15, 0x50, 0xB0, 0x83, 0x2B, 0x05, 0xB7, 0x81,
  // "Ŭ" (U+016C)
  0x18, 0x59, 0xAA, 0x66, 0x0B, 0x28, 0x27, 0x30, 0xA2, 0x82, 0x91, 0x28, 0x28, 0x2A, 0x04, 0x62,
  0x85, 0xA0, 0x46, 0x05, 0x62, 0x81, 0xAA, 0x92,
  // "ŭ" (U+016D)
  0x28, 0xB1, 0x8A, 0x10, 0xA0, 0x64, 0x38, 0x08, 0x15, 0x50, 0xB0, 0x83, 0x2B, 0x05, 0xB7, 0x81,
  // "Ů" (U+016E)
  0x30, 0x60, 0x52, 0x85, 0x91, 0x6A, 0x60, 0xB2, 0x82, 0x73, 0x0A, 0x28, 0x29, 0x12, 0x82, 0x82,
  0xA0, 0x46, 0x28, 0x5A, 0x04, 0x60, 0x56, 0x28, 0x1A, 0xA9, 0x20,
  // "ů" (U+016F)
  0x20, 0x60, 0x53, 0x06, 0x05, 0x28, 0xA5, 0xA0, 0x64, 0x38, 0x08, 0x15, 0x50, 0xB0, 0x83, 0x2B,
  0x05, 0xB7, 0x81,
  // "Ű" (U+0170)
  0x38, 0x91, 0x76, 0x60, 0x91, 0x15, 0x60, 0xB2, 0x82, 0x73, 0x0A, 0x28, 0x29, 0x12, 0x82, 0x82,
  0xA0, 0x46, 0x28, 0x5A, 0x04, 0x60, 0x56, 0x28, 0x1A, 0xA9, 0x20,
  // "ű" (U+0171)
  0x28, 0x17, 0x66, 0x20, 0x01, 0x28, 0xA5, 0xA0, 0x64, 0x38, 0x08, 0x15, 0x50, 0xB0, 0x83, 0x2B,
  0x05, 0xB7, 0x81,
  // "Ų" (U+0172)
  0x18, 0x59, 0x10, 0x46, 0x0B, 0x28, 0x27, 0x30, 0xA2, 0x82, 0x91, 0x28, 0x28, 0x2A, 0x04, 0x62,
  0x85, 0xA0, 0x46, 0x05, 0x62, 0x81, 0xAC, 0x93, 0x02, 0x05, 0x40, 0x20, 0x73,
  // "ų" (U+0173)
  0x18, 0xA5, 0xA0, 0x64, 0x38, 0x08, 0x15, 0x50, 0xB0, 0x83, 0x2B, 0x05, 0xB9, 0x82, 0x02, 0x05,
  0x30, 0x20, 0x72,
  // "Ŵ" (U+0174)
  0x30, 0x10, 0x66, 0x81, 0x87, 0x22, 0x89, 0x51, 0x80, 0x59, 0x06, 0x51, 0x90, 0x99, 0x0A, 0x28,
  0x49, 0x18, 0x91, 0x92, 0x84, 0xA7, 0x29, 0x73, 0x28, 0x3A, 0x90, 0x9A, 0x38, 0x3C, 0x60, 0xA7,
  0x30, 0xD2, 0x0C, 0x02, 0x20,
  // "ŵ" (U+0175)
  0x20, 0x10, 0x64, 0x81, 0x87, 0x27, 0x8B, 0x38, 0x25, 0x90, 0xB7, 0x29, 0x83, 0x77, 0x57, 0x99,
  0x16, 0xA1, 0x99, 0x06, 0xA0, 0xB4, 0x10,
  // "Ŷ" (U+0176)
  0x20, 0x10, 0x63, 0x89, 0x28, 0x72, 0x28, 0x04, 0x80, 0xA0, 0xB2, 0x81, 0xA5, 0x62, 0x08, 0x0B,
  0x30, 0x60, 0x53, 0x08, 0x02, 0x30, 0xA3,
  // "ŷ" (U+0177)
  0x20, 0x10, 0x63, 0x81, 0x87, 0x26, 0x89, 0x38, 0x20, 0xB0, 0x64, 0x56, 0x04, 0x5A, 0x28, 0x12,
  0xA6, 0x30, 0xE3, 0x05, 0x07, 0x20, 0x80, 0xB3,
  // "Ÿ" (U+0178)
  0x18, 0x93, 0x14, 0x60, 0x28, 0x04, 0x80, 0xA0, 0xB2, 0x81, 0xA5, 0x62, 0x08, 0x0B, 0x30, 0x60,
  0x53, 0x08, 0x02, 0x30, 0xA3,
  // "Ź" (U+0179)
  0x30, 0x20, 0x33, 0x09, 0x28, 0x2A, 0xBD, 0x73, 0x0B, 0x01, 0x20, 0x80, 0x52, 0x02, 0x0A, 0x30,
  0xB0, 0x12, 0x07, 0x06, 0x38, 0x2E, 0xBB, 0x61,
  // "ź" (U+017A)
  0x20, 0x20, 0x32, 0x09, 0x58, 0x21, 0xBD, 0x62, 0x09, 0x28, 0x38, 0x10, 0x55, 0x28, 0x1E, 0xB9,
  0x10,
  // "Ż" (U+017B)
  0x30, 0x72, 0x82, 0xAB, 0xD7, 0x30, 0xB0, 0x12, 0x08, 0x05, 0x20, 0x20, 0xA3, 0x0B, 0x01, 0x20,
  0x70, 0x63, 0x82, 0xEB, 0xB6, 0x10,
  // "ż" (U+017C)
  0x20, 0x75, 0x82, 0x1B, 0xD6, 0x20, 0x92, 0x83, 0x81, 0x05, 0x52, 0x81, 0xEB, 0x91,
  // "Ž" (U+017D)
  0x28, 0x14, 0x13, 0x20, 0x60, 0xB2, 0x82, 0xAB, 0xD7, 0x30, 0xB0, 0x12, 0x08, 0x05, 0x20, 0x20,
  0xA3, 0x0B, 0x01, 0x20, 0x70, 0x63, 0x82, 0xEB, 0xB6, 0x10,
  // "ž" (U+017E)
  0x18, 0x44, 0x13, 0x06, 0xB5, 0x82, 0x1B, 0xD6, 0x20, 0x92, 0x83, 0x81, 0x05, 0x52, 0x81, 0xEB,
  0x91,
  // "ſ" (U+017F)
  0x28, 0x15, 0xC4, 0x20, 0xB4, 0x0B, 0x30, 0x20, 0x83, 0x00, 0x53, 0x08, 0x03, 0x30, 0xB4, 0x0B,
  0x30, 0xC0, 0x53,
  // "Ω" (U+03A9)
  0x18, 0x21, 0xBC, 0xA2, 0x85, 0xB1, 0x07, 0x52, 0x92, 0x82, 0x37, 0x56, 0x28, 0x25, 0x64, 0x72,
  0x89, 0x49, 0x20, 0xA0, 0x48, 0x0B, 0xE3, 0xEB, 0x20,
  // "μ" (U+03BC)
  0x28, 0x95, 0xA0, 0x55, 0x02, 0x80, 0x82, 0x05, 0x50, 0xA2, 0x82, 0x83, 0x2C, 0x28, 0x2A, 0xA7,
  0x92, 0x0A, 0x40, 0x10, 0x94,
  // "π" (U+03C0)
  0x8A, 0x75, 0xEB, 0xEB, 0x0A, 0x0A, 0x02, 0x80, 0xA0, 0x55, 0x18, 0x08, 0x21, 0xC1,
  // "–" (U+2013)
  0x82, 0x8B, 0xB5,
  // "—" (U+2014)
  0x08, 0x80, 0x2B, 0x04,
  // "€" (U+20AC)
  0x28, 0x46, 0xB9, 0x03, 0x93, 0x09, 0x02, 0x28, 0x65, 0xEB, 0x60, 0x8E, 0xB3, 0x0B, 0x48, 0x17,
  0xB8, 0x10,
  // "₿" (U+20BF)
  0x20, 0x06, 0x28, 0xC3, 0x8C, 0xD1, 0x0B, 0x07, 0x50, 0xB0, 0x93, 0x1E, 0xC8, 0x03, 0x70, 0xC0,
  0x64, 0x0C, 0x09, 0xCC, 0x50, 0x15, 0x52,
  // "‘" (U+2018)
  0x18, 0x19, 0x47,
  // "’" (U+2019)
  0x18, 0x1B, 0x44,
  // "‚" (U+201A)
  0x18, 0x1B, 0x26,
  // "‛" (U+201B)
  0x84, 0x1A, 0x09, 0x01,
  // "“" (U+201C)
  0x18, 0x90, 0x94, 0x53, 0x7B, 0x01, 0x01, 0x10,
  // "”" (U+201D)
  0x18, 0x90, 0xB7, 0x54, 0x59, 0x01, 0x01, 0x10,
  // "„" (U+201E)
  0x18, 0x90, 0x10, 0x10, 0xB6, 0x63, 0x69, 0x10,
  // "‟" (U+201F)
  0x87, 0x19, 0xA0, 0x98, 0x01, 0x10,
  // "†" (U+2020)
  0x18, 0x95, 0xB0, 0x28, 0x28, 0xA6, 0x34, 0x07, 0x20, 0xA2, 0x0C, 0x20,
  // "‡" (U+2021)
  0x20, 0xA2, 0x8A, 0x35, 0xA4, 0x05, 0x94, 0x04, 0x60, 0x37, 0x61, 0x4A, 0x61, 0x0B, 0x20,
  // "•" (U+2022)
  0x84, 0x2F, 0x61, 0xD5,
  // "…" (U+2026)
  0x83, 0x70, 0x70, 0x70,
  // "‰" (U+2030)
  0x18, 0x38, 0xB0, 0x26, 0x38, 0x31, 0x78, 0x19, 0x48, 0x34, 0x48, 0x63, 0x48, 0xC2, 0x54, 0xA8,
  0x9A, 0x2B, 0x51, 0xBB, 0x56, 0x99, 0x19, 0x03, 0x66, 0x29, 0x92, 0x70, 0x90, 0x3C, 0x58, 0xB1,
  // "‹" (U+2039)
  0x18, 0x55, 0x56, 0x55, 0x04,
  // "›" (U+203A)
  0x85, 0x33, 0x0A, 0x47, 0x41,
  // "⁄" (U+2044)
  0x30, 0x10, 0x83, 0x08, 0x01, 0x20, 0x30, 0x63, 0x09, 0x30, 0x60, 0x32, 0x01, 0x08, 0x30, 0x80,
  0x13,
  // "™" (U+2122)
  0x8A, 0x6B, 0xE9, 0x73, 0x81, 0x76, 0x97, 0x81, 0x76, 0x87, 0x80, 0x22, 0x12, 0x30,
  // "⅒" (U+2152)
  0x30, 0x10, 0x82, 0x83, 0x15, 0x08, 0x12, 0x82, 0x58, 0x36, 0x38, 0xB1, 0x26, 0xA5, 0x58, 0x05,
  0x98, 0x98, 0x53, 0x18, 0x28, 0x67, 0x18, 0x15, 0x38, 0x51,
  // "ﬁ" (U+FB01)
  0x28, 0x23, 0xC5, 0x62, 0x09, 0x01, 0x38, 0x33, 0xD9, 0x0A, 0x28, 0xA3, 0xA0, 0x28, 0x03, 0x70,
  0x55, 0x06, 0x40, 0x73, 0x09, 0x10, 0xA2, 0x0B, 0x40, 0xB0, 0x74,
  // "ﬂ" (U+FB02)
  0x28, 0x33, 0xC5, 0x91, 0x28, 0x29, 0x10, 0xA2, 0x83, 0x3D, 0x90, 0xA3, 0x82, 0xA0, 0x28, 0x28,
  0x33, 0x70, 0x55, 0x28, 0x36, 0x40, 0x73, 0x28, 0x29, 0x10, 0xA3, 0x0B, 0x50, 0xB0, 0x75,
};

const Font& font_NotoSans_Italic_8() {
  static SmoothFont font(font_NotoSans_Italic_8_data);
  return font;
}

}  // namespace roo_display
