#include "15.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSans-CondensedItalic (Noto Sans Condensed Italic)
// Generated on Thu Mar 30 22:28:54 CEST 2023
static const uint8_t font_NotoSans_CondensedItalic_15_data[] PROGMEM = {
  
  // Header
  0x01, 0x01, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x05, 0x09,
  0xFC, 0xFD, 0x0E, 0x0F, 0x0B, 0xFD, 0x05, 0x02, 0x0E, 0x04, 0x03, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x00, 0x01, 0x03, 0x0A, 0x04, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x01, 0x08, 0x05, 0x0A, 0x05, 0x00, 0x16, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x07, 0x0A, 0x07, 0x00, 0x1F, // "#" (U+0023)
  0x00, 0x24, 0x00, 0x00, 0x06, 0x0B, 0x07, 0x00, 0x47, // "$" (U+0024)
  0x00, 0x25, 0x00, 0x01, 0x09, 0x0A, 0x0A, 0x00, 0x6D, // "%" (U+0025)
  0x00, 0x26, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x00, 0xA3, // "&" (U+0026)
  0x00, 0x27, 0x01, 0x08, 0x03, 0x0A, 0x03, 0x00, 0xCC, // "'" (U+0027)
  0x00, 0x28, 0x00, 0xFE, 0x04, 0x0A, 0x04, 0x00, 0xD2, // "(" (U+0028)
  0x00, 0x29, 0xFF, 0xFE, 0x03, 0x0A, 0x04, 0x00, 0xF4, // ")" (U+0029)
  0x00, 0x2A, 0x01, 0x06, 0x06, 0x0B, 0x06, 0x01, 0x16, // "*" (U+002A)
  0x00, 0x2B, 0x00, 0x03, 0x06, 0x09, 0x07, 0x01, 0x2A, // "+" (U+002B)
  0x00, 0x2C, 0xFF, 0xFF, 0x01, 0x02, 0x03, 0x01, 0x40, // "," (U+002C)
  0x00, 0x2D, 0x00, 0x04, 0x03, 0x05, 0x04, 0x01, 0x48, // "-" (U+002D)
  0x00, 0x2E, 0x00, 0x01, 0x01, 0x02, 0x03, 0x01, 0x4D, // "." (U+002E)
  0x00, 0x2F, 0xFF, 0x01, 0x06, 0x0A, 0x05, 0x01, 0x50, // "/" (U+002F)
  0x00, 0x30, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x01, 0x6B, // "0" (U+0030)
  0x00, 0x31, 0x01, 0x01, 0x05, 0x0A, 0x07, 0x01, 0x91, // "1" (U+0031)
  0x00, 0x32, 0xFF, 0x01, 0x06, 0x0A, 0x07, 0x01, 0xAB, // "2" (U+0032)
  0x00, 0x33, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x01, 0xC8, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x01, 0xE9, // "4" (U+0034)
  0x00, 0x35, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x02, 0x0B, // "5" (U+0035)
  0x00, 0x36, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x02, 0x2A, // "6" (U+0036)
  0x00, 0x37, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x02, 0x4F, // "7" (U+0037)
  0x00, 0x38, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x02, 0x69, // "8" (U+0038)
  0x00, 0x39, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x02, 0x90, // "9" (U+0039)
  0x00, 0x3A, 0x00, 0x01, 0x02, 0x08, 0x03, 0x02, 0xB4, // ":" (U+003A)
  0x00, 0x3B, 0xFF, 0xFF, 0x03, 0x08, 0x03, 0x02, 0xBD, // ";" (U+003B)
  0x00, 0x3C, 0x00, 0x03, 0x06, 0x09, 0x07, 0x02, 0xCF, // "<" (U+003C)
  0x00, 0x3D, 0x00, 0x03, 0x06, 0x07, 0x07, 0x02, 0xE4, // "=" (U+003D)
  0x00, 0x3E, 0x00, 0x03, 0x06, 0x09, 0x07, 0x02, 0xF2, // ">" (U+003E)
  0x00, 0x3F, 0x00, 0x01, 0x05, 0x0A, 0x05, 0x03, 0x08, // "?" (U+003F)
  0x00, 0x40, 0x00, 0x00, 0x09, 0x0A, 0x0A, 0x03, 0x24, // "@" (U+0040)
  0x00, 0x41, 0xFF, 0x01, 0x05, 0x0A, 0x07, 0x03, 0x59, // "A" (U+0041)
  0x00, 0x42, 0x00, 0x01, 0x07, 0x0A, 0x07, 0x03, 0x7E, // "B" (U+0042)
  0x00, 0x43, 0x00, 0x01, 0x07, 0x0A, 0x07, 0x03, 0xA9, // "C" (U+0043)
  0x00, 0x44, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x03, 0xCA, // "D" (U+0044)
  0x00, 0x45, 0x00, 0x01, 0x06, 0x0A, 0x06, 0x03, 0xF5, // "E" (U+0045)
  0x00, 0x46, 0x00, 0x01, 0x06, 0x0A, 0x06, 0x04, 0x12, // "F" (U+0046)
  0x00, 0x47, 0x00, 0x01, 0x08, 0x0A, 0x08, 0x04, 0x2F, // "G" (U+0047)
  0x00, 0x48, 0x00, 0x01, 0x08, 0x0A, 0x08, 0x04, 0x5B, // "H" (U+0048)
  0x00, 0x49, 0xFF, 0x01, 0x05, 0x0A, 0x04, 0x04, 0x8D, // "I" (U+0049)
  0x00, 0x4A, 0xFD, 0xFD, 0x03, 0x0A, 0x03, 0x04, 0xA9, // "J" (U+004A)
  0x00, 0x4B, 0x00, 0x01, 0x07, 0x0A, 0x07, 0x04, 0xCE, // "K" (U+004B)
  0x00, 0x4C, 0x00, 0x01, 0x04, 0x0A, 0x06, 0x04, 0xF9, // "L" (U+004C)
  0x00, 0x4D, 0x00, 0x01, 0x0A, 0x0A, 0x0B, 0x05, 0x13, // "M" (U+004D)
  0x00, 0x4E, 0x00, 0x01, 0x08, 0x0A, 0x09, 0x05, 0x4E, // "N" (U+004E)
  0x00, 0x4F, 0x00, 0x01, 0x08, 0x0A, 0x08, 0x05, 0x7F, // "O" (U+004F)
  0x00, 0x50, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x05, 0xAD, // "P" (U+0050)
  0x00, 0x51, 0x00, 0xFE, 0x08, 0x0A, 0x08, 0x05, 0xCE, // "Q" (U+0051)
  0x00, 0x52, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x06, 0x04, // "R" (U+0052)
  0x00, 0x53, 0xFF, 0x01, 0x06, 0x0A, 0x06, 0x06, 0x2C, // "S" (U+0053)
  0x00, 0x54, 0x01, 0x01, 0x06, 0x0A, 0x06, 0x06, 0x4E, // "T" (U+0054)
  0x00, 0x55, 0x00, 0x01, 0x08, 0x0A, 0x08, 0x06, 0x68, // "U" (U+0055)
  0x00, 0x56, 0x01, 0x01, 0x07, 0x0A, 0x07, 0x06, 0x98, // "V" (U+0056)
  0x00, 0x57, 0x01, 0x01, 0x0B, 0x0A, 0x0B, 0x06, 0xBD, // "W" (U+0057)
  0x00, 0x58, 0xFF, 0x01, 0x07, 0x0A, 0x06, 0x06, 0xF8, // "X" (U+0058)
  0x00, 0x59, 0x01, 0x01, 0x07, 0x0A, 0x06, 0x07, 0x20, // "Y" (U+0059)
  0x00, 0x5A, 0xFF, 0x01, 0x06, 0x0A, 0x06, 0x07, 0x3F, // "Z" (U+005A)
  0x00, 0x5B, 0xFF, 0xFD, 0x05, 0x0A, 0x04, 0x07, 0x5B, // "[" (U+005B)
  0x00, 0x5C, 0x01, 0x01, 0x03, 0x0A, 0x05, 0x07, 0x7E, // "\" (U+005C)
  0x00, 0x5D, 0xFF, 0xFD, 0x04, 0x0A, 0x04, 0x07, 0x8F, // "]" (U+005D)
  0x00, 0x5E, 0x00, 0x06, 0x06, 0x0B, 0x07, 0x07, 0xB2, // "^" (U+005E)
  0x00, 0x5F, 0xFE, 0xFE, 0x03, 0xFF, 0x05, 0x07, 0xC7, // "_" (U+005F)
  0x00, 0x60, 0x02, 0x0A, 0x04, 0x0C, 0x04, 0x07, 0xCE, // "`" (U+0060)
  0x00, 0x61, 0x00, 0x01, 0x06, 0x08, 0x07, 0x07, 0xD4, // "a" (U+0061)
  0x00, 0x62, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x07, 0xF4, // "b" (U+0062)
  0x00, 0x63, 0x00, 0x01, 0x05, 0x08, 0x05, 0x08, 0x1A, // "c" (U+0063)
  0x00, 0x64, 0x00, 0x01, 0x07, 0x0B, 0x07, 0x08, 0x32, // "d" (U+0064)
  0x00, 0x65, 0x00, 0x01, 0x05, 0x08, 0x06, 0x08, 0x5D, // "e" (U+0065)
  0x00, 0x66, 0xFE, 0xFE, 0x05, 0x0B, 0x04, 0x08, 0x76, // "f" (U+0066)
  0x00, 0x67, 0xFF, 0xFE, 0x06, 0x08, 0x07, 0x08, 0x9C, // "g" (U+0067)
  0x00, 0x68, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x08, 0xCB, // "h" (U+0068)
  0x00, 0x69, 0x00, 0x01, 0x03, 0x0B, 0x03, 0x08, 0xF1, // "i" (U+0069)
  0x00, 0x6A, 0xFE, 0xFE, 0x03, 0x0B, 0x03, 0x09, 0x07, // "j" (U+006A)
  0x00, 0x6B, 0x00, 0x01, 0x06, 0x0B, 0x06, 0x09, 0x27, // "k" (U+006B)
  0x00, 0x6C, 0x00, 0x01, 0x03, 0x0B, 0x03, 0x09, 0x4D, // "l" (U+006C)
  0x00, 0x6D, 0x00, 0x01, 0x09, 0x08, 0x0A, 0x09, 0x67, // "m" (U+006D)
  0x00, 0x6E, 0x00, 0x01, 0x06, 0x08, 0x07, 0x09, 0x94, // "n" (U+006E)
  0x00, 0x6F, 0x00, 0x01, 0x06, 0x08, 0x07, 0x09, 0xB4, // "o" (U+006F)
  0x00, 0x70, 0xFF, 0xFE, 0x06, 0x08, 0x07, 0x09, 0xD3, // "p" (U+0070)
  0x00, 0x71, 0x00, 0xFE, 0x06, 0x08, 0x07, 0x09, 0xFE, // "q" (U+0071)
  0x00, 0x72, 0x00, 0x01, 0x05, 0x08, 0x05, 0x0A, 0x25, // "r" (U+0072)
  0x00, 0x73, 0x00, 0x01, 0x05, 0x08, 0x05, 0x0A, 0x3C, // "s" (U+0073)
  0x00, 0x74, 0x00, 0x01, 0x04, 0x0A, 0x04, 0x0A, 0x54, // "t" (U+0074)
  0x00, 0x75, 0x00, 0x01, 0x06, 0x08, 0x07, 0x0A, 0x6F, // "u" (U+0075)
  0x00, 0x76, 0x00, 0x01, 0x06, 0x08, 0x06, 0x0A, 0x8F, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x01, 0x09, 0x08, 0x09, 0x0A, 0xAB, // "w" (U+0077)
  0x00, 0x78, 0xFF, 0x01, 0x06, 0x08, 0x06, 0x0A, 0xD5, // "x" (U+0078)
  0x00, 0x79, 0xFE, 0xFE, 0x06, 0x08, 0x06, 0x0A, 0xF3, // "y" (U+0079)
  0x00, 0x7A, 0xFF, 0x01, 0x05, 0x08, 0x05, 0x0B, 0x18, // "z" (U+007A)
  0x00, 0x7B, 0x00, 0xFE, 0x05, 0x0A, 0x05, 0x0B, 0x2F, // "{" (U+007B)
  0x00, 0x7C, 0x02, 0xFE, 0x03, 0x0B, 0x06, 0x0B, 0x52, // "|" (U+007C)
  0x00, 0x7D, 0xFF, 0xFE, 0x04, 0x0A, 0x05, 0x0B, 0x62, // "}" (U+007D)
  0x00, 0x7E, 0x00, 0x05, 0x06, 0x06, 0x07, 0x0B, 0x85, // "~" (U+007E)
  0x00, 0xA1, 0xFF, 0xFE, 0x03, 0x08, 0x04, 0x0B, 0x8E, // "¡" (U+00A1)
  0x00, 0xA2, 0x01, 0x01, 0x06, 0x0A, 0x07, 0x0B, 0xA9, // "¢" (U+00A2)
  0x00, 0xA3, 0xFF, 0x01, 0x06, 0x0A, 0x07, 0x0B, 0xC6, // "£" (U+00A3)
  0x00, 0xA4, 0x01, 0x02, 0x07, 0x09, 0x08, 0x0B, 0xE6, // "¤" (U+00A4)
  0x00, 0xA5, 0x00, 0x01, 0x07, 0x0A, 0x07, 0x0C, 0x03, // "¥" (U+00A5)
  0x00, 0xA6, 0x02, 0xFE, 0x03, 0x0B, 0x06, 0x0C, 0x27, // "¦" (U+00A6)
  0x00, 0xA7, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x0C, 0x35, // "§" (U+00A7)
  0x00, 0xA8, 0x02, 0x0B, 0x06, 0x0B, 0x07, 0x0C, 0x57, // "¨" (U+00A8)
  0x00, 0xA9, 0x00, 0x00, 0x0B, 0x0B, 0x0C, 0x0C, 0x5B, // "©" (U+00A9)
  0x00, 0xAA, 0x01, 0x07, 0x05, 0x0A, 0x04, 0x0C, 0x9E, // "ª" (U+00AA)
  0x00, 0xAB, 0x00, 0x02, 0x06, 0x07, 0x07, 0x0C, 0xAA, // "«" (U+00AB)
  0x00, 0xAC, 0x00, 0x03, 0x06, 0x06, 0x07, 0x0C, 0xC1, // "¬" (U+00AC)
  0x00, 0xAE, 0x00, 0x00, 0x0B, 0x0B, 0x0C, 0x0C, 0xCE, // "®" (U+00AE)
  0x00, 0xAF, 0x01, 0x0B, 0x07, 0x0C, 0x06, 0x0D, 0x17, // "¯" (U+00AF)
  0x00, 0xB0, 0x00, 0x08, 0x04, 0x0B, 0x06, 0x0D, 0x1E, // "°" (U+00B0)
  0x00, 0xB1, 0x00, 0x01, 0x06, 0x09, 0x07, 0x0D, 0x2A, // "±" (U+00B1)
  0x00, 0xB2, 0x00, 0x07, 0x05, 0x0D, 0x05, 0x0D, 0x43, // "²" (U+00B2)
  0x00, 0xB3, 0x00, 0x07, 0x05, 0x0D, 0x05, 0x0D, 0x58, // "³" (U+00B3)
  0x00, 0xB4, 0x01, 0x0A, 0x04, 0x0C, 0x04, 0x0D, 0x6D, // "´" (U+00B4)
  0x00, 0xB5, 0xFF, 0xFE, 0x06, 0x08, 0x07, 0x0D, 0x74, // "µ" (U+00B5)
  0x00, 0xB6, 0x01, 0xFF, 0x06, 0x0B, 0x08, 0x0D, 0xA2, // "¶" (U+00B6)
  0x00, 0xB7, 0x01, 0x05, 0x02, 0x06, 0x03, 0x0D, 0xCD, // "·" (U+00B7)
  0x00, 0xB8, 0xFE, 0xFD, 0x01, 0x00, 0x03, 0x0D, 0xD0, // "¸" (U+00B8)
  0x00, 0xB9, 0x02, 0x07, 0x04, 0x0D, 0x05, 0x0D, 0xD9, // "¹" (U+00B9)
  0x00, 0xBA, 0x01, 0x07, 0x04, 0x0A, 0x04, 0x0D, 0xE5, // "º" (U+00BA)
  0x00, 0xBB, 0x00, 0x02, 0x05, 0x07, 0x07, 0x0D, 0xEF, // "»" (U+00BB)
  0x00, 0xBC, 0x00, 0x01, 0x09, 0x0B, 0x0A, 0x0E, 0x03, // "¼" (U+00BC)
  0x00, 0xBD, 0x00, 0x01, 0x0A, 0x0B, 0x0B, 0x0E, 0x37, // "½" (U+00BD)
  0x00, 0xBE, 0x00, 0x01, 0x0A, 0x0B, 0x0A, 0x0E, 0x71, // "¾" (U+00BE)
  0x00, 0xBF, 0xFF, 0xFF, 0x04, 0x08, 0x05, 0x0E, 0xAA, // "¿" (U+00BF)
  0x00, 0xC0, 0xFF, 0x01, 0x05, 0x0F, 0x07, 0x0E, 0xC6, // "À" (U+00C0)
  0x00, 0xC1, 0xFF, 0x01, 0x06, 0x0F, 0x07, 0x0E, 0xF3, // "Á" (U+00C1)
  0x00, 0xC2, 0xFF, 0x01, 0x06, 0x0F, 0x07, 0x0F, 0x24, // "Â" (U+00C2)
  0x00, 0xC3, 0xFF, 0x01, 0x07, 0x0E, 0x07, 0x0F, 0x57, // "Ã" (U+00C3)
  0x00, 0xC4, 0xFF, 0x01, 0x06, 0x0E, 0x07, 0x0F, 0x89, // "Ä" (U+00C4)
  0x00, 0xC5, 0xFF, 0x01, 0x06, 0x0F, 0x07, 0x0F, 0xB6, // "Å" (U+00C5)
  0x00, 0xC6, 0xFF, 0x01, 0x0A, 0x0A, 0x0A, 0x0F, 0xE8, // "Æ" (U+00C6)
  0x00, 0xC7, 0x00, 0xFD, 0x07, 0x0A, 0x07, 0x10, 0x14, // "Ç" (U+00C7)
  0x00, 0xC8, 0x00, 0x01, 0x06, 0x0F, 0x06, 0x10, 0x40, // "È" (U+00C8)
  0x00, 0xC9, 0x00, 0x01, 0x06, 0x0F, 0x06, 0x10, 0x65, // "É" (U+00C9)
  0x00, 0xCA, 0x00, 0x01, 0x06, 0x0F, 0x06, 0x10, 0x8C, // "Ê" (U+00CA)
  0x00, 0xCB, 0x00, 0x01, 0x06, 0x0E, 0x06, 0x10, 0xB4, // "Ë" (U+00CB)
  0x00, 0xCC, 0xFF, 0x01, 0x05, 0x0F, 0x04, 0x10, 0xD7, // "Ì" (U+00CC)
  0x00, 0xCD, 0xFF, 0x01, 0x05, 0x0F, 0x04, 0x10, 0xFB, // "Í" (U+00CD)
  0x00, 0xCE, 0xFF, 0x01, 0x05, 0x0F, 0x04, 0x11, 0x20, // "Î" (U+00CE)
  0x00, 0xCF, 0xFF, 0x01, 0x05, 0x0E, 0x04, 0x11, 0x47, // "Ï" (U+00CF)
  0x00, 0xD0, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x11, 0x68, // "Ð" (U+00D0)
  0x00, 0xD1, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x11, 0x94, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x00, 0x01, 0x08, 0x0F, 0x08, 0x11, 0xCE, // "Ò" (U+00D2)
  0x00, 0xD3, 0x00, 0x01, 0x08, 0x0F, 0x08, 0x12, 0x05, // "Ó" (U+00D3)
  0x00, 0xD4, 0x00, 0x01, 0x08, 0x0F, 0x08, 0x12, 0x3D, // "Ô" (U+00D4)
  0x00, 0xD5, 0x00, 0x01, 0x08, 0x0E, 0x08, 0x12, 0x76, // "Õ" (U+00D5)
  0x00, 0xD6, 0x00, 0x01, 0x08, 0x0E, 0x08, 0x12, 0xAD, // "Ö" (U+00D6)
  0x00, 0xD7, 0x01, 0x03, 0x06, 0x08, 0x07, 0x12, 0xE1, // "×" (U+00D7)
  0x00, 0xD8, 0x00, 0x00, 0x08, 0x0B, 0x08, 0x12, 0xF6, // "Ø" (U+00D8)
  0x00, 0xD9, 0x00, 0x01, 0x08, 0x0F, 0x08, 0x13, 0x2B, // "Ù" (U+00D9)
  0x00, 0xDA, 0x00, 0x01, 0x08, 0x0F, 0x08, 0x13, 0x64, // "Ú" (U+00DA)
  0x00, 0xDB, 0x00, 0x01, 0x08, 0x0F, 0x08, 0x13, 0x9E, // "Û" (U+00DB)
  0x00, 0xDC, 0x00, 0x01, 0x08, 0x0E, 0x08, 0x13, 0xD9, // "Ü" (U+00DC)
  0x00, 0xDD, 0x01, 0x01, 0x07, 0x0F, 0x06, 0x14, 0x0F, // "Ý" (U+00DD)
  0x00, 0xDE, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x14, 0x38, // "Þ" (U+00DE)
  0x00, 0xDF, 0xFE, 0xFE, 0x06, 0x0B, 0x07, 0x14, 0x5A, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x14, 0x92, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x14, 0xB9, // "á" (U+00E1)
  0x00, 0xE2, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x14, 0xE2, // "â" (U+00E2)
  0x00, 0xE3, 0x00, 0x01, 0x07, 0x0B, 0x07, 0x15, 0x0C, // "ã" (U+00E3)
  0x00, 0xE4, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x15, 0x39, // "ä" (U+00E4)
  0x00, 0xE5, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x15, 0x5E, // "å" (U+00E5)
  0x00, 0xE6, 0x00, 0x01, 0x09, 0x08, 0x0A, 0x15, 0x88, // "æ" (U+00E6)
  0x00, 0xE7, 0x00, 0xFD, 0x05, 0x08, 0x05, 0x15, 0xB2, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x01, 0x05, 0x0C, 0x06, 0x15, 0xD5, // "è" (U+00E8)
  0x00, 0xE9, 0x00, 0x01, 0x06, 0x0C, 0x06, 0x15, 0xF5, // "é" (U+00E9)
  0x00, 0xEA, 0x00, 0x01, 0x06, 0x0C, 0x06, 0x16, 0x1A, // "ê" (U+00EA)
  0x00, 0xEB, 0x00, 0x01, 0x06, 0x0B, 0x06, 0x16, 0x41, // "ë" (U+00EB)
  0x00, 0xEC, 0x00, 0x01, 0x03, 0x0C, 0x03, 0x16, 0x62, // "ì" (U+00EC)
  0x00, 0xED, 0x00, 0x01, 0x04, 0x0C, 0x03, 0x16, 0x7C, // "í" (U+00ED)
  0x00, 0xEE, 0x00, 0x01, 0x04, 0x0C, 0x03, 0x16, 0x99, // "î" (U+00EE)
  0x00, 0xEF, 0x00, 0x01, 0x04, 0x0B, 0x03, 0x16, 0xB7, // "ï" (U+00EF)
  0x00, 0xF0, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x16, 0xD0, // "ð" (U+00F0)
  0x00, 0xF1, 0x00, 0x01, 0x07, 0x0B, 0x07, 0x16, 0xF8, // "ñ" (U+00F1)
  0x00, 0xF2, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x17, 0x26, // "ò" (U+00F2)
  0x00, 0xF3, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x17, 0x4C, // "ó" (U+00F3)
  0x00, 0xF4, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x17, 0x74, // "ô" (U+00F4)
  0x00, 0xF5, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x17, 0x9D, // "õ" (U+00F5)
  0x00, 0xF6, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x17, 0xC4, // "ö" (U+00F6)
  0x00, 0xF7, 0x00, 0x03, 0x06, 0x09, 0x07, 0x17, 0xE8, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x00, 0x06, 0x09, 0x07, 0x17, 0xFA, // "ø" (U+00F8)
  0x00, 0xF9, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x18, 0x1A, // "ù" (U+00F9)
  0x00, 0xFA, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x18, 0x42, // "ú" (U+00FA)
  0x00, 0xFB, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x18, 0x6B, // "û" (U+00FB)
  0x00, 0xFC, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x18, 0x96, // "ü" (U+00FC)
  0x00, 0xFD, 0xFE, 0xFE, 0x06, 0x0C, 0x06, 0x18, 0xBB, // "ý" (U+00FD)
  0x00, 0xFE, 0xFF, 0xFE, 0x06, 0x0B, 0x07, 0x18, 0xE9, // "þ" (U+00FE)
  0x00, 0xFF, 0xFE, 0xFE, 0x06, 0x0B, 0x06, 0x19, 0x1C, // "ÿ" (U+00FF)
  0x01, 0x00, 0xFF, 0x01, 0x06, 0x0D, 0x07, 0x19, 0x46, // "Ā" (U+0100)
  0x01, 0x01, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x19, 0x74, // "ā" (U+0101)
  0x01, 0x02, 0xFF, 0x01, 0x06, 0x0E, 0x07, 0x19, 0x9A, // "Ă" (U+0102)
  0x01, 0x03, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x19, 0xCA, // "ă" (U+0103)
  0x01, 0x04, 0xFF, 0xFD, 0x05, 0x0A, 0x07, 0x19, 0xF1, // "Ą" (U+0104)
  0x01, 0x05, 0x00, 0xFD, 0x06, 0x08, 0x07, 0x1A, 0x1F, // "ą" (U+0105)
  0x01, 0x06, 0x00, 0x01, 0x07, 0x0F, 0x07, 0x1A, 0x48, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x01, 0x05, 0x0C, 0x05, 0x1A, 0x72, // "ć" (U+0107)
  0x01, 0x08, 0x00, 0x01, 0x07, 0x0F, 0x07, 0x1A, 0x93, // "Ĉ" (U+0108)
  0x01, 0x09, 0x00, 0x01, 0x05, 0x0C, 0x05, 0x1A, 0xBF, // "ĉ" (U+0109)
  0x01, 0x0A, 0x00, 0x01, 0x07, 0x0E, 0x07, 0x1A, 0xE1, // "Ċ" (U+010A)
  0x01, 0x0B, 0x00, 0x01, 0x05, 0x0B, 0x05, 0x1B, 0x06, // "ċ" (U+010B)
  0x01, 0x0C, 0x00, 0x01, 0x07, 0x0F, 0x07, 0x1B, 0x21, // "Č" (U+010C)
  0x01, 0x0D, 0x00, 0x01, 0x06, 0x0C, 0x05, 0x1B, 0x4C, // "č" (U+010D)
  0x01, 0x0E, 0x00, 0x01, 0x07, 0x0F, 0x08, 0x1B, 0x70, // "Ď" (U+010E)
  0x01, 0x0F, 0x00, 0x01, 0x0A, 0x0B, 0x08, 0x1B, 0xA5, // "ď" (U+010F)
  0x01, 0x10, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x1B, 0xD6, // "Đ" (U+0110)
  0x01, 0x11, 0x00, 0x01, 0x08, 0x0B, 0x07, 0x1C, 0x02, // "đ" (U+0111)
  0x01, 0x12, 0x00, 0x01, 0x06, 0x0D, 0x06, 0x1C, 0x31, // "Ē" (U+0112)
  0x01, 0x13, 0x00, 0x01, 0x06, 0x0A, 0x06, 0x1C, 0x55, // "ē" (U+0113)
  0x01, 0x14, 0x00, 0x01, 0x06, 0x0E, 0x06, 0x1C, 0x77, // "Ĕ" (U+0114)
  0x01, 0x15, 0x00, 0x01, 0x06, 0x0B, 0x06, 0x1C, 0x9C, // "ĕ" (U+0115)
  0x01, 0x16, 0x00, 0x01, 0x06, 0x0D, 0x06, 0x1C, 0xC0, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x1C, 0xE1, // "ė" (U+0117)
  0x01, 0x18, 0x00, 0xFD, 0x06, 0x0A, 0x06, 0x1C, 0xFD, // "Ę" (U+0118)
  0x01, 0x19, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x1D, 0x24, // "ę" (U+0119)
  0x01, 0x1A, 0x00, 0x01, 0x06, 0x0F, 0x06, 0x1D, 0x45, // "Ě" (U+011A)
  0x01, 0x1B, 0x00, 0x01, 0x06, 0x0C, 0x06, 0x1D, 0x6D, // "ě" (U+011B)
  0x01, 0x1C, 0x00, 0x01, 0x08, 0x0F, 0x08, 0x1D, 0x93, // "Ĝ" (U+011C)
  0x01, 0x1D, 0xFF, 0xFE, 0x06, 0x0C, 0x07, 0x1D, 0xCA, // "ĝ" (U+011D)
  0x01, 0x1E, 0x00, 0x01, 0x08, 0x0E, 0x08, 0x1E, 0x04, // "Ğ" (U+011E)
  0x01, 0x1F, 0xFF, 0xFE, 0x06, 0x0B, 0x07, 0x1E, 0x38, // "ğ" (U+011F)
  0x01, 0x20, 0x00, 0x01, 0x08, 0x0E, 0x08, 0x1E, 0x6F, // "Ġ" (U+0120)
  0x01, 0x21, 0xFF, 0xFE, 0x06, 0x0B, 0x07, 0x1E, 0x9F, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0xFE, 0x08, 0x0A, 0x08, 0x1E, 0xD2, // "Ģ" (U+0122)
  0x01, 0x23, 0xFF, 0xFE, 0x06, 0x0B, 0x07, 0x1F, 0x05, // "ģ" (U+0123)
  0x01, 0x24, 0x00, 0x01, 0x08, 0x0F, 0x08, 0x1F, 0x3C, // "Ĥ" (U+0124)
  0x01, 0x25, 0x00, 0x01, 0x06, 0x0F, 0x07, 0x1F, 0x79, // "ĥ" (U+0125)
  0x01, 0x26, 0x00, 0x01, 0x08, 0x0A, 0x08, 0x1F, 0xAA, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x1F, 0xDB, // "ħ" (U+0127)
  0x01, 0x28, 0xFF, 0x01, 0x06, 0x0E, 0x04, 0x20, 0x03, // "Ĩ" (U+0128)
  0x01, 0x29, 0x00, 0x01, 0x05, 0x0B, 0x03, 0x20, 0x28, // "ĩ" (U+0129)
  0x01, 0x2A, 0xFF, 0x01, 0x05, 0x0D, 0x04, 0x20, 0x45, // "Ī" (U+012A)
  0x01, 0x2B, 0x00, 0x01, 0x04, 0x0A, 0x03, 0x20, 0x67, // "ī" (U+012B)
  0x01, 0x2C, 0xFF, 0x01, 0x05, 0x0E, 0x04, 0x20, 0x82, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x00, 0x01, 0x04, 0x0B, 0x03, 0x20, 0xA6, // "ĭ" (U+012D)
  0x01, 0x2E, 0xFF, 0xFD, 0x05, 0x0A, 0x04, 0x20, 0xC1, // "Į" (U+012E)
  0x01, 0x2F, 0xFF, 0xFD, 0x03, 0x0B, 0x03, 0x20, 0xE6, // "į" (U+012F)
  0x01, 0x30, 0xFF, 0x01, 0x05, 0x0E, 0x04, 0x21, 0x08, // "İ" (U+0130)
  0x01, 0x31, 0x00, 0x01, 0x02, 0x08, 0x03, 0x21, 0x28, // "ı" (U+0131)
  0x01, 0x32, 0xFF, 0xFD, 0x07, 0x0A, 0x08, 0x21, 0x36, // "Ĳ" (U+0132)
  0x01, 0x33, 0x00, 0xFE, 0x06, 0x0B, 0x06, 0x21, 0x70, // "ĳ" (U+0133)
  0x01, 0x34, 0xFD, 0xFD, 0x04, 0x0F, 0x03, 0x21, 0x9E, // "Ĵ" (U+0134)
  0x01, 0x35, 0xFE, 0xFE, 0x04, 0x0C, 0x03, 0x21, 0xCE, // "ĵ" (U+0135)
  0x01, 0x36, 0x00, 0xFE, 0x07, 0x0A, 0x07, 0x21, 0xF5, // "Ķ" (U+0136)
  0x01, 0x37, 0x00, 0xFE, 0x06, 0x0B, 0x06, 0x22, 0x28, // "ķ" (U+0137)
  0x01, 0x38, 0x00, 0x01, 0x06, 0x08, 0x06, 0x22, 0x56, // "ĸ" (U+0138)
  0x01, 0x39, 0x00, 0x01, 0x06, 0x0F, 0x06, 0x22, 0x75, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x00, 0x01, 0x05, 0x0F, 0x03, 0x22, 0x9A, // "ĺ" (U+013A)
  0x01, 0x3B, 0x00, 0xFE, 0x04, 0x0A, 0x06, 0x22, 0xBF, // "Ļ" (U+013B)
  0x01, 0x3C, 0xFF, 0xFE, 0x03, 0x0B, 0x03, 0x22, 0xE1, // "ļ" (U+013C)
  0x01, 0x3D, 0x00, 0x01, 0x06, 0x0A, 0x06, 0x23, 0x05, // "Ľ" (U+013D)
  0x01, 0x3E, 0x00, 0x01, 0x06, 0x0B, 0x04, 0x23, 0x24, // "ľ" (U+013E)
  0x01, 0x3F, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x23, 0x44, // "Ŀ" (U+013F)
  0x01, 0x40, 0x00, 0x01, 0x04, 0x0B, 0x04, 0x23, 0x60, // "ŀ" (U+0140)
  0x01, 0x41, 0x00, 0x01, 0x04, 0x0A, 0x06, 0x23, 0x7C, // "Ł" (U+0141)
  0x01, 0x42, 0x00, 0x01, 0x03, 0x0B, 0x03, 0x23, 0x97, // "ł" (U+0142)
  0x01, 0x43, 0x00, 0x01, 0x08, 0x0F, 0x09, 0x23, 0xB0, // "Ń" (U+0143)
  0x01, 0x44, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x23, 0xEB, // "ń" (U+0144)
  0x01, 0x45, 0x00, 0xFE, 0x08, 0x0A, 0x09, 0x24, 0x14, // "Ņ" (U+0145)
  0x01, 0x46, 0x00, 0xFE, 0x06, 0x08, 0x07, 0x24, 0x4D, // "ņ" (U+0146)
  0x01, 0x47, 0x00, 0x01, 0x08, 0x0F, 0x09, 0x24, 0x74, // "Ň" (U+0147)
  0x01, 0x48, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x24, 0xB0, // "ň" (U+0148)
  0x01, 0x49, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x24, 0xDA, // "ŉ" (U+0149)
  0x01, 0x4A, 0x00, 0xFE, 0x08, 0x0A, 0x09, 0x25, 0x06, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x00, 0xFE, 0x06, 0x08, 0x07, 0x25, 0x40, // "ŋ" (U+014B)
  0x01, 0x4C, 0x00, 0x01, 0x08, 0x0D, 0x08, 0x25, 0x68, // "Ō" (U+014C)
  0x01, 0x4D, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x25, 0x9C, // "ō" (U+014D)
  0x01, 0x4E, 0x00, 0x01, 0x08, 0x0E, 0x08, 0x25, 0xC1, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x25, 0xF7, // "ŏ" (U+014F)
  0x01, 0x50, 0x00, 0x01, 0x08, 0x0F, 0x08, 0x26, 0x1D, // "Ő" (U+0150)
  0x01, 0x51, 0x00, 0x01, 0x07, 0x0C, 0x07, 0x26, 0x57, // "ő" (U+0151)
  0x01, 0x52, 0x00, 0x01, 0x0A, 0x0A, 0x0A, 0x26, 0x85, // "Œ" (U+0152)
  0x01, 0x53, 0x00, 0x01, 0x0A, 0x08, 0x0B, 0x26, 0xB4, // "œ" (U+0153)
  0x01, 0x54, 0x00, 0x01, 0x07, 0x0F, 0x07, 0x26, 0xE2, // "Ŕ" (U+0154)
  0x01, 0x55, 0x00, 0x01, 0x05, 0x0C, 0x05, 0x27, 0x18, // "ŕ" (U+0155)
  0x01, 0x56, 0x00, 0xFE, 0x06, 0x0A, 0x07, 0x27, 0x38, // "Ŗ" (U+0156)
  0x01, 0x57, 0x00, 0xFE, 0x05, 0x08, 0x05, 0x27, 0x67, // "ŗ" (U+0157)
  0x01, 0x58, 0x00, 0x01, 0x06, 0x0F, 0x07, 0x27, 0x86, // "Ř" (U+0158)
  0x01, 0x59, 0x00, 0x01, 0x05, 0x0C, 0x05, 0x27, 0xB8, // "ř" (U+0159)
  0x01, 0x5A, 0xFF, 0x01, 0x06, 0x0F, 0x06, 0x27, 0xD9, // "Ś" (U+015A)
  0x01, 0x5B, 0x00, 0x01, 0x05, 0x0C, 0x05, 0x28, 0x05, // "ś" (U+015B)
  0x01, 0x5C, 0xFF, 0x01, 0x06, 0x0F, 0x06, 0x28, 0x26, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x00, 0x01, 0x05, 0x0C, 0x05, 0x28, 0x53, // "ŝ" (U+015D)
  0x01, 0x5E, 0xFF, 0xFD, 0x06, 0x0A, 0x06, 0x28, 0x75, // "Ş" (U+015E)
  0x01, 0x5F, 0xFF, 0xFD, 0x05, 0x08, 0x05, 0x28, 0xA2, // "ş" (U+015F)
  0x01, 0x60, 0xFF, 0x01, 0x06, 0x0F, 0x06, 0x28, 0xC7, // "Š" (U+0160)
  0x01, 0x61, 0x00, 0x01, 0x05, 0x0C, 0x05, 0x28, 0xF4, // "š" (U+0161)
  0x01, 0x62, 0xFF, 0xFD, 0x06, 0x0A, 0x06, 0x29, 0x16, // "Ţ" (U+0162)
  0x01, 0x63, 0xFF, 0xFD, 0x04, 0x0A, 0x04, 0x29, 0x3C, // "ţ" (U+0163)
  0x01, 0x64, 0x01, 0x01, 0x06, 0x0F, 0x06, 0x29, 0x64, // "Ť" (U+0164)
  0x01, 0x65, 0x00, 0x01, 0x06, 0x0B, 0x04, 0x29, 0x89, // "ť" (U+0165)
  0x01, 0x66, 0x01, 0x01, 0x06, 0x0A, 0x06, 0x29, 0xAA, // "Ŧ" (U+0166)
  0x01, 0x67, 0x00, 0x01, 0x04, 0x0A, 0x04, 0x29, 0xC6, // "ŧ" (U+0167)
  0x01, 0x68, 0x00, 0x01, 0x08, 0x0E, 0x08, 0x29, 0xE1, // "Ũ" (U+0168)
  0x01, 0x69, 0x00, 0x01, 0x07, 0x0B, 0x07, 0x2A, 0x1A, // "ũ" (U+0169)
  0x01, 0x6A, 0x00, 0x01, 0x08, 0x0D, 0x08, 0x2A, 0x48, // "Ū" (U+016A)
  0x01, 0x6B, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x2A, 0x7F, // "ū" (U+016B)
  0x01, 0x6C, 0x00, 0x01, 0x08, 0x0E, 0x08, 0x2A, 0xA5, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x2A, 0xDD, // "ŭ" (U+016D)
  0x01, 0x6E, 0x00, 0x01, 0x08, 0x0F, 0x08, 0x2B, 0x05, // "Ů" (U+016E)
  0x01, 0x6F, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x2B, 0x40, // "ů" (U+016F)
  0x01, 0x70, 0x00, 0x01, 0x08, 0x0F, 0x08, 0x2B, 0x6A, // "Ű" (U+0170)
  0x01, 0x71, 0x00, 0x01, 0x07, 0x0C, 0x07, 0x2B, 0xA6, // "ű" (U+0171)
  0x01, 0x72, 0x00, 0xFD, 0x08, 0x0A, 0x08, 0x2B, 0xD7, // "Ų" (U+0172)
  0x01, 0x73, 0x00, 0xFD, 0x06, 0x08, 0x07, 0x2C, 0x11, // "ų" (U+0173)
  0x01, 0x74, 0x01, 0x01, 0x0B, 0x0F, 0x0B, 0x2C, 0x3B, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x09, 0x0C, 0x09, 0x2C, 0x83, // "ŵ" (U+0175)
  0x01, 0x76, 0x01, 0x01, 0x07, 0x0F, 0x06, 0x2C, 0xB8, // "Ŷ" (U+0176)
  0x01, 0x77, 0xFE, 0xFE, 0x06, 0x0C, 0x06, 0x2C, 0xE2, // "ŷ" (U+0177)
  0x01, 0x78, 0x01, 0x01, 0x07, 0x0E, 0x06, 0x2D, 0x12, // "Ÿ" (U+0178)
  0x01, 0x79, 0xFF, 0x01, 0x06, 0x0F, 0x06, 0x2D, 0x37, // "Ź" (U+0179)
  0x01, 0x7A, 0xFF, 0x01, 0x05, 0x0C, 0x05, 0x2D, 0x5D, // "ź" (U+017A)
  0x01, 0x7B, 0xFF, 0x01, 0x06, 0x0E, 0x06, 0x2D, 0x7D, // "Ż" (U+017B)
  0x01, 0x7C, 0xFF, 0x01, 0x05, 0x0B, 0x05, 0x2D, 0x9D, // "ż" (U+017C)
  0x01, 0x7D, 0xFF, 0x01, 0x06, 0x0F, 0x06, 0x2D, 0xB7, // "Ž" (U+017D)
  0x01, 0x7E, 0xFF, 0x01, 0x05, 0x0C, 0x05, 0x2D, 0xDE, // "ž" (U+017E)
  0x01, 0x7F, 0xFE, 0xFE, 0x05, 0x0B, 0x03, 0x2D, 0xFF, // "ſ" (U+017F)
  0x03, 0xA9, 0xFF, 0x01, 0x08, 0x0A, 0x09, 0x2E, 0x24, // "Ω" (U+03A9)
  0x03, 0xBC, 0xFF, 0xFE, 0x06, 0x08, 0x07, 0x2E, 0x56, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x01, 0x07, 0x08, 0x07, 0x2E, 0x84, // "π" (U+03C0)
  0x20, 0x13, 0x00, 0x04, 0x06, 0x05, 0x07, 0x2E, 0xA7, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x04, 0x0D, 0x05, 0x0E, 0x2E, 0xAE, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x01, 0x07, 0x0A, 0x07, 0x2E, 0xB6, // "€" (U+20AC)
  0x20, 0xBF, 0x00, 0xFF, 0x06, 0x0C, 0x07, 0x2E, 0xDB, // "₿" (U+20BF)
  0x20, 0x18, 0x01, 0x07, 0x03, 0x0A, 0x03, 0x2F, 0x0E, // "‘" (U+2018)
  0x20, 0x19, 0x01, 0x07, 0x03, 0x0A, 0x03, 0x2F, 0x16, // "’" (U+2019)
  0x20, 0x1A, 0xFF, 0xFF, 0x01, 0x02, 0x03, 0x2F, 0x1D, // "‚" (U+201A)
  0x20, 0x1B, 0x01, 0x08, 0x02, 0x0A, 0x03, 0x2F, 0x25, // "‛" (U+201B)
  0x20, 0x1C, 0x01, 0x08, 0x05, 0x0A, 0x05, 0x2F, 0x29, // "“" (U+201C)
  0x20, 0x1D, 0x01, 0x08, 0x05, 0x0A, 0x05, 0x2F, 0x32, // "”" (U+201D)
  0x20, 0x1E, 0xFF, 0xFF, 0x04, 0x02, 0x05, 0x2F, 0x3B, // "„" (U+201E)
  0x20, 0x1F, 0x01, 0x08, 0x05, 0x0A, 0x05, 0x2F, 0x48, // "‟" (U+201F)
  0x20, 0x20, 0x01, 0x01, 0x06, 0x0B, 0x06, 0x2F, 0x51, // "†" (U+2020)
  0x20, 0x21, 0x00, 0x01, 0x06, 0x0B, 0x06, 0x2F, 0x70, // "‡" (U+2021)
  0x20, 0x22, 0x01, 0x04, 0x04, 0x07, 0x05, 0x2F, 0x93, // "•" (U+2022)
  0x20, 0x26, 0x00, 0x01, 0x08, 0x02, 0x0A, 0x2F, 0x9D, // "…" (U+2026)
  0x20, 0x30, 0x00, 0x01, 0x0D, 0x0A, 0x0E, 0x2F, 0xA8, // "‰" (U+2030)
  0x20, 0x39, 0x00, 0x02, 0x03, 0x07, 0x04, 0x2F, 0xEB, // "‹" (U+2039)
  0x20, 0x3A, 0x00, 0x02, 0x03, 0x07, 0x04, 0x2F, 0xF9, // "›" (U+203A)
  0x20, 0x44, 0xFC, 0x01, 0x05, 0x0A, 0x02, 0x30, 0x07, // "⁄" (U+2044)
  0x21, 0x22, 0x00, 0x06, 0x09, 0x0B, 0x0A, 0x30, 0x22, // "™" (U+2122)
  0x21, 0x52, 0x00, 0x01, 0x0E, 0x0B, 0x0E, 0x30, 0x42, // "⅒" (U+2152)
  0xFB, 0x01, 0xFE, 0xFE, 0x07, 0x0B, 0x07, 0x30, 0x8C, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0xFE, 0xFE, 0x07, 0x0B, 0x07, 0x30, 0xC6, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x01, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0x61, 0x01, // "a (U+0022 U+0061)
  0x00, 0x22, 0x00, 0x63, 0x01, // "c (U+0022 U+0063)
  0x00, 0x22, 0x00, 0x64, 0x01, // "d (U+0022 U+0064)
  0x00, 0x22, 0x00, 0x65, 0x01, // "e (U+0022 U+0065)
  0x00, 0x22, 0x00, 0x6F, 0x01, // "o (U+0022 U+006F)
  0x00, 0x22, 0x00, 0x71, 0x01, // "q (U+0022 U+0071)
  0x00, 0x22, 0x00, 0xC0, 0x01, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x01, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x01, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x01, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x01, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x01, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xE0, 0x01, // "à (U+0022 U+00E0)
  0x00, 0x22, 0x00, 0xE1, 0x01, // "á (U+0022 U+00E1)
  0x00, 0x22, 0x00, 0xE2, 0x01, // "â (U+0022 U+00E2)
  0x00, 0x22, 0x00, 0xE3, 0x01, // "ã (U+0022 U+00E3)
  0x00, 0x22, 0x00, 0xE4, 0x01, // "ä (U+0022 U+00E4)
  0x00, 0x22, 0x00, 0xE5, 0x01, // "å (U+0022 U+00E5)
  0x00, 0x22, 0x00, 0xE6, 0x01, // "æ (U+0022 U+00E6)
  0x00, 0x22, 0x00, 0xE7, 0x01, // "ç (U+0022 U+00E7)
  0x00, 0x22, 0x00, 0xE8, 0x01, // "è (U+0022 U+00E8)
  0x00, 0x22, 0x00, 0xE9, 0x01, // "é (U+0022 U+00E9)
  0x00, 0x22, 0x00, 0xEA, 0x01, // "ê (U+0022 U+00EA)
  0x00, 0x22, 0x00, 0xEB, 0x01, // "ë (U+0022 U+00EB)
  0x00, 0x22, 0x00, 0xF2, 0x01, // "ò (U+0022 U+00F2)
  0x00, 0x22, 0x00, 0xF3, 0x01, // "ó (U+0022 U+00F3)
  0x00, 0x22, 0x00, 0xF4, 0x01, // "ô (U+0022 U+00F4)
  0x00, 0x22, 0x00, 0xF5, 0x01, // "õ (U+0022 U+00F5)
  0x00, 0x22, 0x00, 0xF6, 0x01, // "ö (U+0022 U+00F6)
  0x00, 0x22, 0x00, 0xF8, 0x01, // "ø (U+0022 U+00F8)
  0x00, 0x22, 0x01, 0x00, 0x01, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x01, 0x01, // "ā (U+0022 U+0101)
  0x00, 0x22, 0x01, 0x02, 0x01, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x03, 0x01, // "ă (U+0022 U+0103)
  0x00, 0x22, 0x01, 0x04, 0x01, // "Ą (U+0022 U+0104)
  0x00, 0x22, 0x01, 0x05, 0x01, // "ą (U+0022 U+0105)
  0x00, 0x22, 0x01, 0x07, 0x01, // "ć (U+0022 U+0107)
  0x00, 0x22, 0x01, 0x09, 0x01, // "ĉ (U+0022 U+0109)
  0x00, 0x22, 0x01, 0x0B, 0x01, // "ċ (U+0022 U+010B)
  0x00, 0x22, 0x01, 0x0D, 0x01, // "č (U+0022 U+010D)
  0x00, 0x22, 0x01, 0x0F, 0x01, // "ď (U+0022 U+010F)
  0x00, 0x22, 0x01, 0x11, 0x01, // "đ (U+0022 U+0111)
  0x00, 0x22, 0x01, 0x13, 0x01, // "ē (U+0022 U+0113)
  0x00, 0x22, 0x01, 0x15, 0x01, // "ĕ (U+0022 U+0115)
  0x00, 0x22, 0x01, 0x17, 0x01, // "ė (U+0022 U+0117)
  0x00, 0x22, 0x01, 0x19, 0x01, // "ę (U+0022 U+0119)
  0x00, 0x22, 0x01, 0x1B, 0x01, // "ě (U+0022 U+011B)
  0x00, 0x22, 0x01, 0x4D, 0x01, // "ō (U+0022 U+014D)
  0x00, 0x22, 0x01, 0x4F, 0x01, // "ŏ (U+0022 U+014F)
  0x00, 0x22, 0x01, 0x51, 0x01, // "ő (U+0022 U+0151)
  0x00, 0x22, 0x01, 0x53, 0x01, // "œ (U+0022 U+0153)
  0x00, 0x26, 0x00, 0x54, 0x01, // &T (U+0026 U+0054)
  0x00, 0x26, 0x00, 0x59, 0x01, // &Y (U+0026 U+0059)
  0x00, 0x26, 0x00, 0xDD, 0x01, // &Ý (U+0026 U+00DD)
  0x00, 0x26, 0x01, 0x62, 0x01, // &Ţ (U+0026 U+0162)
  0x00, 0x26, 0x01, 0x64, 0x01, // &Ť (U+0026 U+0164)
  0x00, 0x26, 0x01, 0x66, 0x01, // &Ŧ (U+0026 U+0166)
  0x00, 0x26, 0x01, 0x76, 0x01, // &Ŷ (U+0026 U+0176)
  0x00, 0x26, 0x01, 0x78, 0x01, // &Ÿ (U+0026 U+0178)
  0x00, 0x27, 0x00, 0x41, 0x01, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0x61, 0x01, // 'a (U+0027 U+0061)
  0x00, 0x27, 0x00, 0x63, 0x01, // 'c (U+0027 U+0063)
  0x00, 0x27, 0x00, 0x64, 0x01, // 'd (U+0027 U+0064)
  0x00, 0x27, 0x00, 0x65, 0x01, // 'e (U+0027 U+0065)
  0x00, 0x27, 0x00, 0x6F, 0x01, // 'o (U+0027 U+006F)
  0x00, 0x27, 0x00, 0x71, 0x01, // 'q (U+0027 U+0071)
  0x00, 0x27, 0x00, 0xC0, 0x01, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x01, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x01, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x01, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x01, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x01, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xE0, 0x01, // 'à (U+0027 U+00E0)
  0x00, 0x27, 0x00, 0xE1, 0x01, // 'á (U+0027 U+00E1)
  0x00, 0x27, 0x00, 0xE2, 0x01, // 'â (U+0027 U+00E2)
  0x00, 0x27, 0x00, 0xE3, 0x01, // 'ã (U+0027 U+00E3)
  0x00, 0x27, 0x00, 0xE4, 0x01, // 'ä (U+0027 U+00E4)
  0x00, 0x27, 0x00, 0xE5, 0x01, // 'å (U+0027 U+00E5)
  0x00, 0x27, 0x00, 0xE6, 0x01, // 'æ (U+0027 U+00E6)
  0x00, 0x27, 0x00, 0xE7, 0x01, // 'ç (U+0027 U+00E7)
  0x00, 0x27, 0x00, 0xE8, 0x01, // 'è (U+0027 U+00E8)
  0x00, 0x27, 0x00, 0xE9, 0x01, // 'é (U+0027 U+00E9)
  0x00, 0x27, 0x00, 0xEA, 0x01, // 'ê (U+0027 U+00EA)
  0x00, 0x27, 0x00, 0xEB, 0x01, // 'ë (U+0027 U+00EB)
  0x00, 0x27, 0x00, 0xF2, 0x01, // 'ò (U+0027 U+00F2)
  0x00, 0x27, 0x00, 0xF3, 0x01, // 'ó (U+0027 U+00F3)
  0x00, 0x27, 0x00, 0xF4, 0x01, // 'ô (U+0027 U+00F4)
  0x00, 0x27, 0x00, 0xF5, 0x01, // 'õ (U+0027 U+00F5)
  0x00, 0x27, 0x00, 0xF6, 0x01, // 'ö (U+0027 U+00F6)
  0x00, 0x27, 0x00, 0xF8, 0x01, // 'ø (U+0027 U+00F8)
  0x00, 0x27, 0x01, 0x00, 0x01, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x01, 0x01, // 'ā (U+0027 U+0101)
  0x00, 0x27, 0x01, 0x02, 0x01, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x03, 0x01, // 'ă (U+0027 U+0103)
  0x00, 0x27, 0x01, 0x04, 0x01, // 'Ą (U+0027 U+0104)
  0x00, 0x27, 0x01, 0x05, 0x01, // 'ą (U+0027 U+0105)
  0x00, 0x27, 0x01, 0x07, 0x01, // 'ć (U+0027 U+0107)
  0x00, 0x27, 0x01, 0x09, 0x01, // 'ĉ (U+0027 U+0109)
  0x00, 0x27, 0x01, 0x0B, 0x01, // 'ċ (U+0027 U+010B)
  0x00, 0x27, 0x01, 0x0D, 0x01, // 'č (U+0027 U+010D)
  0x00, 0x27, 0x01, 0x0F, 0x01, // 'ď (U+0027 U+010F)
  0x00, 0x27, 0x01, 0x11, 0x01, // 'đ (U+0027 U+0111)
  0x00, 0x27, 0x01, 0x13, 0x01, // 'ē (U+0027 U+0113)
  0x00, 0x27, 0x01, 0x15, 0x01, // 'ĕ (U+0027 U+0115)
  0x00, 0x27, 0x01, 0x17, 0x01, // 'ė (U+0027 U+0117)
  0x00, 0x27, 0x01, 0x19, 0x01, // 'ę (U+0027 U+0119)
  0x00, 0x27, 0x01, 0x1B, 0x01, // 'ě (U+0027 U+011B)
  0x00, 0x27, 0x01, 0x4D, 0x01, // 'ō (U+0027 U+014D)
  0x00, 0x27, 0x01, 0x4F, 0x01, // 'ŏ (U+0027 U+014F)
  0x00, 0x27, 0x01, 0x51, 0x01, // 'ő (U+0027 U+0151)
  0x00, 0x27, 0x01, 0x53, 0x01, // 'œ (U+0027 U+0153)
  0x00, 0x2C, 0x00, 0x43, 0x01, // ,C (U+002C U+0043)
  0x00, 0x2C, 0x00, 0x47, 0x01, // ,G (U+002C U+0047)
  0x00, 0x2C, 0x00, 0x4F, 0x01, // ,O (U+002C U+004F)
  0x00, 0x2C, 0x00, 0x51, 0x01, // ,Q (U+002C U+0051)
  0x00, 0x2C, 0x00, 0x54, 0x01, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x56, 0x01, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x01, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x01, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0xC7, 0x01, // ,Ç (U+002C U+00C7)
  0x00, 0x2C, 0x00, 0xD2, 0x01, // ,Ò (U+002C U+00D2)
  0x00, 0x2C, 0x00, 0xD3, 0x01, // ,Ó (U+002C U+00D3)
  0x00, 0x2C, 0x00, 0xD4, 0x01, // ,Ô (U+002C U+00D4)
  0x00, 0x2C, 0x00, 0xD5, 0x01, // ,Õ (U+002C U+00D5)
  0x00, 0x2C, 0x00, 0xD6, 0x01, // ,Ö (U+002C U+00D6)
  0x00, 0x2C, 0x00, 0xD8, 0x01, // ,Ø (U+002C U+00D8)
  0x00, 0x2C, 0x00, 0xDD, 0x01, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x01, 0x06, 0x01, // ,Ć (U+002C U+0106)
  0x00, 0x2C, 0x01, 0x08, 0x01, // ,Ĉ (U+002C U+0108)
  0x00, 0x2C, 0x01, 0x0A, 0x01, // ,Ċ (U+002C U+010A)
  0x00, 0x2C, 0x01, 0x0C, 0x01, // ,Č (U+002C U+010C)
  0x00, 0x2C, 0x01, 0x1C, 0x01, // ,Ĝ (U+002C U+011C)
  0x00, 0x2C, 0x01, 0x1E, 0x01, // ,Ğ (U+002C U+011E)
  0x00, 0x2C, 0x01, 0x20, 0x01, // ,Ġ (U+002C U+0120)
  0x00, 0x2C, 0x01, 0x22, 0x01, // ,Ģ (U+002C U+0122)
  0x00, 0x2C, 0x01, 0x4C, 0x01, // ,Ō (U+002C U+014C)
  0x00, 0x2C, 0x01, 0x4E, 0x01, // ,Ŏ (U+002C U+014E)
  0x00, 0x2C, 0x01, 0x50, 0x01, // ,Ő (U+002C U+0150)
  0x00, 0x2C, 0x01, 0x52, 0x01, // ,Œ (U+002C U+0152)
  0x00, 0x2C, 0x01, 0x62, 0x01, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x01, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x01, // ,Ŧ (U+002C U+0166)
  0x00, 0x2C, 0x01, 0x74, 0x01, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x76, 0x01, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x78, 0x01, // ,Ÿ (U+002C U+0178)
  0x00, 0x2D, 0x00, 0x54, 0x01, // -T (U+002D U+0054)
  0x00, 0x2D, 0x01, 0x62, 0x01, // -Ţ (U+002D U+0162)
  0x00, 0x2D, 0x01, 0x64, 0x01, // -Ť (U+002D U+0164)
  0x00, 0x2D, 0x01, 0x66, 0x01, // -Ŧ (U+002D U+0166)
  0x00, 0x2E, 0x00, 0x43, 0x01, // .C (U+002E U+0043)
  0x00, 0x2E, 0x00, 0x47, 0x01, // .G (U+002E U+0047)
  0x00, 0x2E, 0x00, 0x4F, 0x01, // .O (U+002E U+004F)
  0x00, 0x2E, 0x00, 0x51, 0x01, // .Q (U+002E U+0051)
  0x00, 0x2E, 0x00, 0x54, 0x01, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x56, 0x01, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x01, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x01, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0xC7, 0x01, // .Ç (U+002E U+00C7)
  0x00, 0x2E, 0x00, 0xD2, 0x01, // .Ò (U+002E U+00D2)
  0x00, 0x2E, 0x00, 0xD3, 0x01, // .Ó (U+002E U+00D3)
  0x00, 0x2E, 0x00, 0xD4, 0x01, // .Ô (U+002E U+00D4)
  0x00, 0x2E, 0x00, 0xD5, 0x01, // .Õ (U+002E U+00D5)
  0x00, 0x2E, 0x00, 0xD6, 0x01, // .Ö (U+002E U+00D6)
  0x00, 0x2E, 0x00, 0xD8, 0x01, // .Ø (U+002E U+00D8)
  0x00, 0x2E, 0x00, 0xDD, 0x01, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x01, 0x06, 0x01, // .Ć (U+002E U+0106)
  0x00, 0x2E, 0x01, 0x08, 0x01, // .Ĉ (U+002E U+0108)
  0x00, 0x2E, 0x01, 0x0A, 0x01, // .Ċ (U+002E U+010A)
  0x00, 0x2E, 0x01, 0x0C, 0x01, // .Č (U+002E U+010C)
  0x00, 0x2E, 0x01, 0x1C, 0x01, // .Ĝ (U+002E U+011C)
  0x00, 0x2E, 0x01, 0x1E, 0x01, // .Ğ (U+002E U+011E)
  0x00, 0x2E, 0x01, 0x20, 0x01, // .Ġ (U+002E U+0120)
  0x00, 0x2E, 0x01, 0x22, 0x01, // .Ģ (U+002E U+0122)
  0x00, 0x2E, 0x01, 0x4C, 0x01, // .Ō (U+002E U+014C)
  0x00, 0x2E, 0x01, 0x4E, 0x01, // .Ŏ (U+002E U+014E)
  0x00, 0x2E, 0x01, 0x50, 0x01, // .Ő (U+002E U+0150)
  0x00, 0x2E, 0x01, 0x52, 0x01, // .Œ (U+002E U+0152)
  0x00, 0x2E, 0x01, 0x62, 0x01, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x01, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x01, // .Ŧ (U+002E U+0166)
  0x00, 0x2E, 0x01, 0x74, 0x01, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x76, 0x01, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x78, 0x01, // .Ÿ (U+002E U+0178)
  0x00, 0x30, 0x20, 0x44, 0x02, // 0⁄ (U+0030 U+2044)
  0x00, 0x31, 0x20, 0x44, 0x02, // 1⁄ (U+0031 U+2044)
  0x00, 0x32, 0x20, 0x44, 0x02, // 2⁄ (U+0032 U+2044)
  0x00, 0x33, 0x20, 0x44, 0x02, // 3⁄ (U+0033 U+2044)
  0x00, 0x34, 0x20, 0x44, 0x02, // 4⁄ (U+0034 U+2044)
  0x00, 0x35, 0x20, 0x44, 0x02, // 5⁄ (U+0035 U+2044)
  0x00, 0x36, 0x20, 0x44, 0x02, // 6⁄ (U+0036 U+2044)
  0x00, 0x37, 0x20, 0x44, 0x02, // 7⁄ (U+0037 U+2044)
  0x00, 0x38, 0x20, 0x44, 0x02, // 8⁄ (U+0038 U+2044)
  0x00, 0x39, 0x20, 0x44, 0x02, // 9⁄ (U+0039 U+2044)
  0x00, 0x41, 0x00, 0x22, 0x01, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x01, // A' (U+0041 U+0027)
  0x00, 0x41, 0x20, 0x19, 0x01, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1D, 0x01, // A” (U+0041 U+201D)
  0x00, 0x44, 0x00, 0x2C, 0x01, // D, (U+0044 U+002C)
  0x00, 0x44, 0x00, 0x2E, 0x01, // D. (U+0044 U+002E)
  0x00, 0x44, 0x20, 0x1A, 0x01, // D‚ (U+0044 U+201A)
  0x00, 0x44, 0x20, 0x1E, 0x01, // D„ (U+0044 U+201E)
  0x00, 0x44, 0x20, 0x26, 0x01, // D… (U+0044 U+2026)
  0x00, 0x46, 0x00, 0x2C, 0x01, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x01, // F. (U+0046 U+002E)
  0x00, 0x46, 0x20, 0x1A, 0x01, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x01, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x01, // F… (U+0046 U+2026)
  0x00, 0x4C, 0x00, 0x22, 0x01, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x01, // L' (U+004C U+0027)
  0x00, 0x4C, 0x00, 0x54, 0x01, // LT (U+004C U+0054)
  0x00, 0x4C, 0x00, 0x59, 0x01, // LY (U+004C U+0059)
  0x00, 0x4C, 0x00, 0xAB, 0x01, // L« (U+004C U+00AB)
  0x00, 0x4C, 0x00, 0xDD, 0x01, // LÝ (U+004C U+00DD)
  0x00, 0x4C, 0x01, 0x62, 0x01, // LŢ (U+004C U+0162)
  0x00, 0x4C, 0x01, 0x64, 0x01, // LŤ (U+004C U+0164)
  0x00, 0x4C, 0x01, 0x66, 0x01, // LŦ (U+004C U+0166)
  0x00, 0x4C, 0x01, 0x76, 0x01, // LŶ (U+004C U+0176)
  0x00, 0x4C, 0x01, 0x78, 0x01, // LŸ (U+004C U+0178)
  0x00, 0x4C, 0x20, 0x19, 0x01, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1D, 0x01, // L” (U+004C U+201D)
  0x00, 0x4C, 0x20, 0x39, 0x01, // L‹ (U+004C U+2039)
  0x00, 0x4F, 0x00, 0x2C, 0x01, // O, (U+004F U+002C)
  0x00, 0x4F, 0x00, 0x2E, 0x01, // O. (U+004F U+002E)
  0x00, 0x4F, 0x20, 0x1A, 0x01, // O‚ (U+004F U+201A)
  0x00, 0x4F, 0x20, 0x1E, 0x01, // O„ (U+004F U+201E)
  0x00, 0x4F, 0x20, 0x26, 0x01, // O… (U+004F U+2026)
  0x00, 0x50, 0x00, 0x2C, 0x02, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x02, // P. (U+0050 U+002E)
  0x00, 0x50, 0x20, 0x1A, 0x02, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x02, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x02, // P… (U+0050 U+2026)
  0x00, 0x51, 0x00, 0x2C, 0x01, // Q, (U+0051 U+002C)
  0x00, 0x51, 0x00, 0x2E, 0x01, // Q. (U+0051 U+002E)
  0x00, 0x51, 0x20, 0x1A, 0x01, // Q‚ (U+0051 U+201A)
  0x00, 0x51, 0x20, 0x1E, 0x01, // Q„ (U+0051 U+201E)
  0x00, 0x51, 0x20, 0x26, 0x01, // Q… (U+0051 U+2026)
  0x00, 0x54, 0x00, 0x2C, 0x01, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2D, 0x01, // T- (U+0054 U+002D)
  0x00, 0x54, 0x00, 0x2E, 0x01, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0x61, 0x01, // Ta (U+0054 U+0061)
  0x00, 0x54, 0x00, 0x63, 0x01, // Tc (U+0054 U+0063)
  0x00, 0x54, 0x00, 0x64, 0x01, // Td (U+0054 U+0064)
  0x00, 0x54, 0x00, 0x65, 0x01, // Te (U+0054 U+0065)
  0x00, 0x54, 0x00, 0x67, 0x01, // Tg (U+0054 U+0067)
  0x00, 0x54, 0x00, 0x6D, 0x01, // Tm (U+0054 U+006D)
  0x00, 0x54, 0x00, 0x6E, 0x01, // Tn (U+0054 U+006E)
  0x00, 0x54, 0x00, 0x6F, 0x01, // To (U+0054 U+006F)
  0x00, 0x54, 0x00, 0x70, 0x01, // Tp (U+0054 U+0070)
  0x00, 0x54, 0x00, 0x71, 0x01, // Tq (U+0054 U+0071)
  0x00, 0x54, 0x00, 0x72, 0x01, // Tr (U+0054 U+0072)
  0x00, 0x54, 0x00, 0x73, 0x01, // Ts (U+0054 U+0073)
  0x00, 0x54, 0x00, 0x75, 0x01, // Tu (U+0054 U+0075)
  0x00, 0x54, 0x00, 0xAB, 0x01, // T« (U+0054 U+00AB)
  0x00, 0x54, 0x00, 0xE0, 0x01, // Tà (U+0054 U+00E0)
  0x00, 0x54, 0x00, 0xE1, 0x01, // Tá (U+0054 U+00E1)
  0x00, 0x54, 0x00, 0xE2, 0x01, // Tâ (U+0054 U+00E2)
  0x00, 0x54, 0x00, 0xE3, 0x01, // Tã (U+0054 U+00E3)
  0x00, 0x54, 0x00, 0xE4, 0x01, // Tä (U+0054 U+00E4)
  0x00, 0x54, 0x00, 0xE5, 0x01, // Tå (U+0054 U+00E5)
  0x00, 0x54, 0x00, 0xE6, 0x01, // Tæ (U+0054 U+00E6)
  0x00, 0x54, 0x00, 0xE7, 0x01, // Tç (U+0054 U+00E7)
  0x00, 0x54, 0x00, 0xE8, 0x01, // Tè (U+0054 U+00E8)
  0x00, 0x54, 0x00, 0xE9, 0x01, // Té (U+0054 U+00E9)
  0x00, 0x54, 0x00, 0xEA, 0x01, // Tê (U+0054 U+00EA)
  0x00, 0x54, 0x00, 0xEB, 0x01, // Të (U+0054 U+00EB)
  0x00, 0x54, 0x00, 0xF1, 0x01, // Tñ (U+0054 U+00F1)
  0x00, 0x54, 0x00, 0xF2, 0x01, // Tò (U+0054 U+00F2)
  0x00, 0x54, 0x00, 0xF3, 0x01, // Tó (U+0054 U+00F3)
  0x00, 0x54, 0x00, 0xF4, 0x01, // Tô (U+0054 U+00F4)
  0x00, 0x54, 0x00, 0xF5, 0x01, // Tõ (U+0054 U+00F5)
  0x00, 0x54, 0x00, 0xF6, 0x01, // Tö (U+0054 U+00F6)
  0x00, 0x54, 0x00, 0xF8, 0x01, // Tø (U+0054 U+00F8)
  0x00, 0x54, 0x00, 0xF9, 0x01, // Tù (U+0054 U+00F9)
  0x00, 0x54, 0x00, 0xFA, 0x01, // Tú (U+0054 U+00FA)
  0x00, 0x54, 0x00, 0xFB, 0x01, // Tû (U+0054 U+00FB)
  0x00, 0x54, 0x00, 0xFC, 0x01, // Tü (U+0054 U+00FC)
  0x00, 0x54, 0x01, 0x01, 0x01, // Tā (U+0054 U+0101)
  0x00, 0x54, 0x01, 0x03, 0x01, // Tă (U+0054 U+0103)
  0x00, 0x54, 0x01, 0x05, 0x01, // Tą (U+0054 U+0105)
  0x00, 0x54, 0x01, 0x07, 0x01, // Tć (U+0054 U+0107)
  0x00, 0x54, 0x01, 0x09, 0x01, // Tĉ (U+0054 U+0109)
  0x00, 0x54, 0x01, 0x0B, 0x01, // Tċ (U+0054 U+010B)
  0x00, 0x54, 0x01, 0x0D, 0x01, // Tč (U+0054 U+010D)
  0x00, 0x54, 0x01, 0x0F, 0x01, // Tď (U+0054 U+010F)
  0x00, 0x54, 0x01, 0x11, 0x01, // Tđ (U+0054 U+0111)
  0x00, 0x54, 0x01, 0x13, 0x01, // Tē (U+0054 U+0113)
  0x00, 0x54, 0x01, 0x15, 0x01, // Tĕ (U+0054 U+0115)
  0x00, 0x54, 0x01, 0x17, 0x01, // Tė (U+0054 U+0117)
  0x00, 0x54, 0x01, 0x19, 0x01, // Tę (U+0054 U+0119)
  0x00, 0x54, 0x01, 0x1B, 0x01, // Tě (U+0054 U+011B)
  0x00, 0x54, 0x01, 0x1D, 0x01, // Tĝ (U+0054 U+011D)
  0x00, 0x54, 0x01, 0x1F, 0x01, // Tğ (U+0054 U+011F)
  0x00, 0x54, 0x01, 0x21, 0x01, // Tġ (U+0054 U+0121)
  0x00, 0x54, 0x01, 0x23, 0x01, // Tģ (U+0054 U+0123)
  0x00, 0x54, 0x01, 0x38, 0x01, // Tĸ (U+0054 U+0138)
  0x00, 0x54, 0x01, 0x44, 0x01, // Tń (U+0054 U+0144)
  0x00, 0x54, 0x01, 0x46, 0x01, // Tņ (U+0054 U+0146)
  0x00, 0x54, 0x01, 0x48, 0x01, // Tň (U+0054 U+0148)
  0x00, 0x54, 0x01, 0x4B, 0x01, // Tŋ (U+0054 U+014B)
  0x00, 0x54, 0x01, 0x4D, 0x01, // Tō (U+0054 U+014D)
  0x00, 0x54, 0x01, 0x4F, 0x01, // Tŏ (U+0054 U+014F)
  0x00, 0x54, 0x01, 0x51, 0x01, // Tő (U+0054 U+0151)
  0x00, 0x54, 0x01, 0x53, 0x01, // Tœ (U+0054 U+0153)
  0x00, 0x54, 0x01, 0x55, 0x01, // Tŕ (U+0054 U+0155)
  0x00, 0x54, 0x01, 0x57, 0x01, // Tŗ (U+0054 U+0157)
  0x00, 0x54, 0x01, 0x5B, 0x01, // Tś (U+0054 U+015B)
  0x00, 0x54, 0x01, 0x5D, 0x01, // Tŝ (U+0054 U+015D)
  0x00, 0x54, 0x01, 0x5F, 0x01, // Tş (U+0054 U+015F)
  0x00, 0x54, 0x01, 0x61, 0x01, // Tš (U+0054 U+0161)
  0x00, 0x54, 0x01, 0x69, 0x01, // Tũ (U+0054 U+0169)
  0x00, 0x54, 0x01, 0x6B, 0x01, // Tū (U+0054 U+016B)
  0x00, 0x54, 0x01, 0x6D, 0x01, // Tŭ (U+0054 U+016D)
  0x00, 0x54, 0x01, 0x6F, 0x01, // Tů (U+0054 U+016F)
  0x00, 0x54, 0x01, 0x71, 0x01, // Tű (U+0054 U+0171)
  0x00, 0x54, 0x01, 0x73, 0x01, // Tų (U+0054 U+0173)
  0x00, 0x54, 0x20, 0x13, 0x01, // T– (U+0054 U+2013)
  0x00, 0x54, 0x20, 0x14, 0x01, // T— (U+0054 U+2014)
  0x00, 0x54, 0x20, 0x1A, 0x01, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x01, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x01, // T… (U+0054 U+2026)
  0x00, 0x54, 0x20, 0x39, 0x01, // T‹ (U+0054 U+2039)
  0x00, 0x56, 0x00, 0x2C, 0x01, // V, (U+0056 U+002C)
  0x00, 0x56, 0x00, 0x2E, 0x01, // V. (U+0056 U+002E)
  0x00, 0x56, 0x20, 0x1A, 0x01, // V‚ (U+0056 U+201A)
  0x00, 0x56, 0x20, 0x1E, 0x01, // V„ (U+0056 U+201E)
  0x00, 0x56, 0x20, 0x26, 0x01, // V… (U+0056 U+2026)
  0x00, 0x57, 0x00, 0x2C, 0x01, // W, (U+0057 U+002C)
  0x00, 0x57, 0x00, 0x2E, 0x01, // W. (U+0057 U+002E)
  0x00, 0x57, 0x20, 0x1A, 0x01, // W‚ (U+0057 U+201A)
  0x00, 0x57, 0x20, 0x1E, 0x01, // W„ (U+0057 U+201E)
  0x00, 0x57, 0x20, 0x26, 0x01, // W… (U+0057 U+2026)
  0x00, 0x59, 0x00, 0x2C, 0x01, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x01, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x00, 0x61, 0x01, // Ya (U+0059 U+0061)
  0x00, 0x59, 0x00, 0x63, 0x01, // Yc (U+0059 U+0063)
  0x00, 0x59, 0x00, 0x64, 0x01, // Yd (U+0059 U+0064)
  0x00, 0x59, 0x00, 0x65, 0x01, // Ye (U+0059 U+0065)
  0x00, 0x59, 0x00, 0x6F, 0x01, // Yo (U+0059 U+006F)
  0x00, 0x59, 0x00, 0x71, 0x01, // Yq (U+0059 U+0071)
  0x00, 0x59, 0x00, 0xAB, 0x01, // Y« (U+0059 U+00AB)
  0x00, 0x59, 0x00, 0xBB, 0x01, // Y» (U+0059 U+00BB)
  0x00, 0x59, 0x00, 0xE0, 0x01, // Yà (U+0059 U+00E0)
  0x00, 0x59, 0x00, 0xE1, 0x01, // Yá (U+0059 U+00E1)
  0x00, 0x59, 0x00, 0xE2, 0x01, // Yâ (U+0059 U+00E2)
  0x00, 0x59, 0x00, 0xE3, 0x01, // Yã (U+0059 U+00E3)
  0x00, 0x59, 0x00, 0xE4, 0x01, // Yä (U+0059 U+00E4)
  0x00, 0x59, 0x00, 0xE5, 0x01, // Yå (U+0059 U+00E5)
  0x00, 0x59, 0x00, 0xE6, 0x01, // Yæ (U+0059 U+00E6)
  0x00, 0x59, 0x00, 0xE7, 0x01, // Yç (U+0059 U+00E7)
  0x00, 0x59, 0x00, 0xE8, 0x01, // Yè (U+0059 U+00E8)
  0x00, 0x59, 0x00, 0xE9, 0x01, // Yé (U+0059 U+00E9)
  0x00, 0x59, 0x00, 0xEA, 0x01, // Yê (U+0059 U+00EA)
  0x00, 0x59, 0x00, 0xEB, 0x01, // Yë (U+0059 U+00EB)
  0x00, 0x59, 0x00, 0xF2, 0x01, // Yò (U+0059 U+00F2)
  0x00, 0x59, 0x00, 0xF3, 0x01, // Yó (U+0059 U+00F3)
  0x00, 0x59, 0x00, 0xF4, 0x01, // Yô (U+0059 U+00F4)
  0x00, 0x59, 0x00, 0xF5, 0x01, // Yõ (U+0059 U+00F5)
  0x00, 0x59, 0x00, 0xF6, 0x01, // Yö (U+0059 U+00F6)
  0x00, 0x59, 0x00, 0xF8, 0x01, // Yø (U+0059 U+00F8)
  0x00, 0x59, 0x01, 0x01, 0x01, // Yā (U+0059 U+0101)
  0x00, 0x59, 0x01, 0x03, 0x01, // Yă (U+0059 U+0103)
  0x00, 0x59, 0x01, 0x05, 0x01, // Yą (U+0059 U+0105)
  0x00, 0x59, 0x01, 0x07, 0x01, // Yć (U+0059 U+0107)
  0x00, 0x59, 0x01, 0x09, 0x01, // Yĉ (U+0059 U+0109)
  0x00, 0x59, 0x01, 0x0B, 0x01, // Yċ (U+0059 U+010B)
  0x00, 0x59, 0x01, 0x0D, 0x01, // Yč (U+0059 U+010D)
  0x00, 0x59, 0x01, 0x0F, 0x01, // Yď (U+0059 U+010F)
  0x00, 0x59, 0x01, 0x11, 0x01, // Yđ (U+0059 U+0111)
  0x00, 0x59, 0x01, 0x13, 0x01, // Yē (U+0059 U+0113)
  0x00, 0x59, 0x01, 0x15, 0x01, // Yĕ (U+0059 U+0115)
  0x00, 0x59, 0x01, 0x17, 0x01, // Yė (U+0059 U+0117)
  0x00, 0x59, 0x01, 0x19, 0x01, // Yę (U+0059 U+0119)
  0x00, 0x59, 0x01, 0x1B, 0x01, // Yě (U+0059 U+011B)
  0x00, 0x59, 0x01, 0x4D, 0x01, // Yō (U+0059 U+014D)
  0x00, 0x59, 0x01, 0x4F, 0x01, // Yŏ (U+0059 U+014F)
  0x00, 0x59, 0x01, 0x51, 0x01, // Yő (U+0059 U+0151)
  0x00, 0x59, 0x01, 0x53, 0x01, // Yœ (U+0059 U+0153)
  0x00, 0x59, 0x20, 0x1A, 0x01, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x01, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x01, // Y… (U+0059 U+2026)
  0x00, 0x59, 0x20, 0x39, 0x01, // Y‹ (U+0059 U+2039)
  0x00, 0x59, 0x20, 0x3A, 0x01, // Y› (U+0059 U+203A)
  0x00, 0xAB, 0x00, 0x59, 0x01, // «Y (U+00AB U+0059)
  0x00, 0xAB, 0x00, 0xDD, 0x01, // «Ý (U+00AB U+00DD)
  0x00, 0xAB, 0x01, 0x76, 0x01, // «Ŷ (U+00AB U+0176)
  0x00, 0xAB, 0x01, 0x78, 0x01, // «Ÿ (U+00AB U+0178)
  0x00, 0xBB, 0x00, 0x54, 0x01, // »T (U+00BB U+0054)
  0x00, 0xBB, 0x00, 0x59, 0x01, // »Y (U+00BB U+0059)
  0x00, 0xBB, 0x00, 0xDD, 0x01, // »Ý (U+00BB U+00DD)
  0x00, 0xBB, 0x01, 0x62, 0x01, // »Ţ (U+00BB U+0162)
  0x00, 0xBB, 0x01, 0x64, 0x01, // »Ť (U+00BB U+0164)
  0x00, 0xBB, 0x01, 0x66, 0x01, // »Ŧ (U+00BB U+0166)
  0x00, 0xBB, 0x01, 0x76, 0x01, // »Ŷ (U+00BB U+0176)
  0x00, 0xBB, 0x01, 0x78, 0x01, // »Ÿ (U+00BB U+0178)
  0x00, 0xBF, 0x00, 0x54, 0x01, // ¿T (U+00BF U+0054)
  0x00, 0xBF, 0x01, 0x62, 0x01, // ¿Ţ (U+00BF U+0162)
  0x00, 0xBF, 0x01, 0x64, 0x01, // ¿Ť (U+00BF U+0164)
  0x00, 0xBF, 0x01, 0x66, 0x01, // ¿Ŧ (U+00BF U+0166)
  0x00, 0xC0, 0x00, 0x22, 0x01, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x01, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x20, 0x19, 0x01, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1D, 0x01, // À” (U+00C0 U+201D)
  0x00, 0xC1, 0x00, 0x22, 0x01, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x01, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x20, 0x19, 0x01, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1D, 0x01, // Á” (U+00C1 U+201D)
  0x00, 0xC2, 0x00, 0x22, 0x01, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x01, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x20, 0x19, 0x01, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1D, 0x01, // Â” (U+00C2 U+201D)
  0x00, 0xC3, 0x00, 0x22, 0x01, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x01, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x20, 0x19, 0x01, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1D, 0x01, // Ã” (U+00C3 U+201D)
  0x00, 0xC4, 0x00, 0x22, 0x01, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x01, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x20, 0x19, 0x01, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1D, 0x01, // Ä” (U+00C4 U+201D)
  0x00, 0xC5, 0x00, 0x22, 0x01, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x01, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x20, 0x19, 0x01, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1D, 0x01, // Å” (U+00C5 U+201D)
  0x00, 0xD0, 0x00, 0x2C, 0x01, // Ð, (U+00D0 U+002C)
  0x00, 0xD0, 0x00, 0x2E, 0x01, // Ð. (U+00D0 U+002E)
  0x00, 0xD0, 0x20, 0x1A, 0x01, // Ð‚ (U+00D0 U+201A)
  0x00, 0xD0, 0x20, 0x1E, 0x01, // Ð„ (U+00D0 U+201E)
  0x00, 0xD0, 0x20, 0x26, 0x01, // Ð… (U+00D0 U+2026)
  0x00, 0xD2, 0x00, 0x2C, 0x01, // Ò, (U+00D2 U+002C)
  0x00, 0xD2, 0x00, 0x2E, 0x01, // Ò. (U+00D2 U+002E)
  0x00, 0xD2, 0x20, 0x1A, 0x01, // Ò‚ (U+00D2 U+201A)
  0x00, 0xD2, 0x20, 0x1E, 0x01, // Ò„ (U+00D2 U+201E)
  0x00, 0xD2, 0x20, 0x26, 0x01, // Ò… (U+00D2 U+2026)
  0x00, 0xD3, 0x00, 0x2C, 0x01, // Ó, (U+00D3 U+002C)
  0x00, 0xD3, 0x00, 0x2E, 0x01, // Ó. (U+00D3 U+002E)
  0x00, 0xD3, 0x20, 0x1A, 0x01, // Ó‚ (U+00D3 U+201A)
  0x00, 0xD3, 0x20, 0x1E, 0x01, // Ó„ (U+00D3 U+201E)
  0x00, 0xD3, 0x20, 0x26, 0x01, // Ó… (U+00D3 U+2026)
  0x00, 0xD4, 0x00, 0x2C, 0x01, // Ô, (U+00D4 U+002C)
  0x00, 0xD4, 0x00, 0x2E, 0x01, // Ô. (U+00D4 U+002E)
  0x00, 0xD4, 0x20, 0x1A, 0x01, // Ô‚ (U+00D4 U+201A)
  0x00, 0xD4, 0x20, 0x1E, 0x01, // Ô„ (U+00D4 U+201E)
  0x00, 0xD4, 0x20, 0x26, 0x01, // Ô… (U+00D4 U+2026)
  0x00, 0xD5, 0x00, 0x2C, 0x01, // Õ, (U+00D5 U+002C)
  0x00, 0xD5, 0x00, 0x2E, 0x01, // Õ. (U+00D5 U+002E)
  0x00, 0xD5, 0x20, 0x1A, 0x01, // Õ‚ (U+00D5 U+201A)
  0x00, 0xD5, 0x20, 0x1E, 0x01, // Õ„ (U+00D5 U+201E)
  0x00, 0xD5, 0x20, 0x26, 0x01, // Õ… (U+00D5 U+2026)
  0x00, 0xD6, 0x00, 0x2C, 0x01, // Ö, (U+00D6 U+002C)
  0x00, 0xD6, 0x00, 0x2E, 0x01, // Ö. (U+00D6 U+002E)
  0x00, 0xD6, 0x20, 0x1A, 0x01, // Ö‚ (U+00D6 U+201A)
  0x00, 0xD6, 0x20, 0x1E, 0x01, // Ö„ (U+00D6 U+201E)
  0x00, 0xD6, 0x20, 0x26, 0x01, // Ö… (U+00D6 U+2026)
  0x00, 0xD8, 0x00, 0x2C, 0x01, // Ø, (U+00D8 U+002C)
  0x00, 0xD8, 0x00, 0x2E, 0x01, // Ø. (U+00D8 U+002E)
  0x00, 0xD8, 0x20, 0x1A, 0x01, // Ø‚ (U+00D8 U+201A)
  0x00, 0xD8, 0x20, 0x1E, 0x01, // Ø„ (U+00D8 U+201E)
  0x00, 0xD8, 0x20, 0x26, 0x01, // Ø… (U+00D8 U+2026)
  0x00, 0xDD, 0x00, 0x2C, 0x01, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x01, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x00, 0x61, 0x01, // Ýa (U+00DD U+0061)
  0x00, 0xDD, 0x00, 0x63, 0x01, // Ýc (U+00DD U+0063)
  0x00, 0xDD, 0x00, 0x64, 0x01, // Ýd (U+00DD U+0064)
  0x00, 0xDD, 0x00, 0x65, 0x01, // Ýe (U+00DD U+0065)
  0x00, 0xDD, 0x00, 0x6F, 0x01, // Ýo (U+00DD U+006F)
  0x00, 0xDD, 0x00, 0x71, 0x01, // Ýq (U+00DD U+0071)
  0x00, 0xDD, 0x00, 0xAB, 0x01, // Ý« (U+00DD U+00AB)
  0x00, 0xDD, 0x00, 0xBB, 0x01, // Ý» (U+00DD U+00BB)
  0x00, 0xDD, 0x00, 0xE0, 0x01, // Ýà (U+00DD U+00E0)
  0x00, 0xDD, 0x00, 0xE1, 0x01, // Ýá (U+00DD U+00E1)
  0x00, 0xDD, 0x00, 0xE2, 0x01, // Ýâ (U+00DD U+00E2)
  0x00, 0xDD, 0x00, 0xE3, 0x01, // Ýã (U+00DD U+00E3)
  0x00, 0xDD, 0x00, 0xE4, 0x01, // Ýä (U+00DD U+00E4)
  0x00, 0xDD, 0x00, 0xE5, 0x01, // Ýå (U+00DD U+00E5)
  0x00, 0xDD, 0x00, 0xE6, 0x01, // Ýæ (U+00DD U+00E6)
  0x00, 0xDD, 0x00, 0xE7, 0x01, // Ýç (U+00DD U+00E7)
  0x00, 0xDD, 0x00, 0xE8, 0x01, // Ýè (U+00DD U+00E8)
  0x00, 0xDD, 0x00, 0xE9, 0x01, // Ýé (U+00DD U+00E9)
  0x00, 0xDD, 0x00, 0xEA, 0x01, // Ýê (U+00DD U+00EA)
  0x00, 0xDD, 0x00, 0xEB, 0x01, // Ýë (U+00DD U+00EB)
  0x00, 0xDD, 0x00, 0xF2, 0x01, // Ýò (U+00DD U+00F2)
  0x00, 0xDD, 0x00, 0xF3, 0x01, // Ýó (U+00DD U+00F3)
  0x00, 0xDD, 0x00, 0xF4, 0x01, // Ýô (U+00DD U+00F4)
  0x00, 0xDD, 0x00, 0xF5, 0x01, // Ýõ (U+00DD U+00F5)
  0x00, 0xDD, 0x00, 0xF6, 0x01, // Ýö (U+00DD U+00F6)
  0x00, 0xDD, 0x00, 0xF8, 0x01, // Ýø (U+00DD U+00F8)
  0x00, 0xDD, 0x01, 0x01, 0x01, // Ýā (U+00DD U+0101)
  0x00, 0xDD, 0x01, 0x03, 0x01, // Ýă (U+00DD U+0103)
  0x00, 0xDD, 0x01, 0x05, 0x01, // Ýą (U+00DD U+0105)
  0x00, 0xDD, 0x01, 0x07, 0x01, // Ýć (U+00DD U+0107)
  0x00, 0xDD, 0x01, 0x09, 0x01, // Ýĉ (U+00DD U+0109)
  0x00, 0xDD, 0x01, 0x0B, 0x01, // Ýċ (U+00DD U+010B)
  0x00, 0xDD, 0x01, 0x0D, 0x01, // Ýč (U+00DD U+010D)
  0x00, 0xDD, 0x01, 0x0F, 0x01, // Ýď (U+00DD U+010F)
  0x00, 0xDD, 0x01, 0x11, 0x01, // Ýđ (U+00DD U+0111)
  0x00, 0xDD, 0x01, 0x13, 0x01, // Ýē (U+00DD U+0113)
  0x00, 0xDD, 0x01, 0x15, 0x01, // Ýĕ (U+00DD U+0115)
  0x00, 0xDD, 0x01, 0x17, 0x01, // Ýė (U+00DD U+0117)
  0x00, 0xDD, 0x01, 0x19, 0x01, // Ýę (U+00DD U+0119)
  0x00, 0xDD, 0x01, 0x1B, 0x01, // Ýě (U+00DD U+011B)
  0x00, 0xDD, 0x01, 0x4D, 0x01, // Ýō (U+00DD U+014D)
  0x00, 0xDD, 0x01, 0x4F, 0x01, // Ýŏ (U+00DD U+014F)
  0x00, 0xDD, 0x01, 0x51, 0x01, // Ýő (U+00DD U+0151)
  0x00, 0xDD, 0x01, 0x53, 0x01, // Ýœ (U+00DD U+0153)
  0x00, 0xDD, 0x20, 0x1A, 0x01, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x01, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x01, // Ý… (U+00DD U+2026)
  0x00, 0xDD, 0x20, 0x39, 0x01, // Ý‹ (U+00DD U+2039)
  0x00, 0xDD, 0x20, 0x3A, 0x01, // Ý› (U+00DD U+203A)
  0x00, 0xDE, 0x00, 0x2C, 0x02, // Þ, (U+00DE U+002C)
  0x00, 0xDE, 0x00, 0x2E, 0x02, // Þ. (U+00DE U+002E)
  0x00, 0xDE, 0x20, 0x1A, 0x02, // Þ‚ (U+00DE U+201A)
  0x00, 0xDE, 0x20, 0x1E, 0x02, // Þ„ (U+00DE U+201E)
  0x00, 0xDE, 0x20, 0x26, 0x02, // Þ… (U+00DE U+2026)
  0x01, 0x00, 0x00, 0x22, 0x01, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x01, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x20, 0x19, 0x01, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1D, 0x01, // Ā” (U+0100 U+201D)
  0x01, 0x02, 0x00, 0x22, 0x01, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x01, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x20, 0x19, 0x01, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1D, 0x01, // Ă” (U+0102 U+201D)
  0x01, 0x04, 0x00, 0x22, 0x01, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x01, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x20, 0x19, 0x01, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1D, 0x01, // Ą” (U+0104 U+201D)
  0x01, 0x0E, 0x00, 0x2C, 0x01, // Ď, (U+010E U+002C)
  0x01, 0x0E, 0x00, 0x2E, 0x01, // Ď. (U+010E U+002E)
  0x01, 0x0E, 0x20, 0x1A, 0x01, // Ď‚ (U+010E U+201A)
  0x01, 0x0E, 0x20, 0x1E, 0x01, // Ď„ (U+010E U+201E)
  0x01, 0x0E, 0x20, 0x26, 0x01, // Ď… (U+010E U+2026)
  0x01, 0x10, 0x00, 0x2C, 0x01, // Đ, (U+0110 U+002C)
  0x01, 0x10, 0x00, 0x2E, 0x01, // Đ. (U+0110 U+002E)
  0x01, 0x10, 0x20, 0x1A, 0x01, // Đ‚ (U+0110 U+201A)
  0x01, 0x10, 0x20, 0x1E, 0x01, // Đ„ (U+0110 U+201E)
  0x01, 0x10, 0x20, 0x26, 0x01, // Đ… (U+0110 U+2026)
  0x01, 0x39, 0x00, 0x22, 0x01, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x01, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x00, 0x54, 0x01, // ĹT (U+0139 U+0054)
  0x01, 0x39, 0x00, 0x59, 0x01, // ĹY (U+0139 U+0059)
  0x01, 0x39, 0x00, 0xAB, 0x01, // Ĺ« (U+0139 U+00AB)
  0x01, 0x39, 0x00, 0xDD, 0x01, // ĹÝ (U+0139 U+00DD)
  0x01, 0x39, 0x01, 0x62, 0x01, // ĹŢ (U+0139 U+0162)
  0x01, 0x39, 0x01, 0x64, 0x01, // ĹŤ (U+0139 U+0164)
  0x01, 0x39, 0x01, 0x66, 0x01, // ĹŦ (U+0139 U+0166)
  0x01, 0x39, 0x01, 0x76, 0x01, // ĹŶ (U+0139 U+0176)
  0x01, 0x39, 0x01, 0x78, 0x01, // ĹŸ (U+0139 U+0178)
  0x01, 0x39, 0x20, 0x19, 0x01, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1D, 0x01, // Ĺ” (U+0139 U+201D)
  0x01, 0x39, 0x20, 0x39, 0x01, // Ĺ‹ (U+0139 U+2039)
  0x01, 0x3B, 0x00, 0x22, 0x01, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x01, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x00, 0x54, 0x01, // ĻT (U+013B U+0054)
  0x01, 0x3B, 0x00, 0x59, 0x01, // ĻY (U+013B U+0059)
  0x01, 0x3B, 0x00, 0xAB, 0x01, // Ļ« (U+013B U+00AB)
  0x01, 0x3B, 0x00, 0xDD, 0x01, // ĻÝ (U+013B U+00DD)
  0x01, 0x3B, 0x01, 0x62, 0x01, // ĻŢ (U+013B U+0162)
  0x01, 0x3B, 0x01, 0x64, 0x01, // ĻŤ (U+013B U+0164)
  0x01, 0x3B, 0x01, 0x66, 0x01, // ĻŦ (U+013B U+0166)
  0x01, 0x3B, 0x01, 0x76, 0x01, // ĻŶ (U+013B U+0176)
  0x01, 0x3B, 0x01, 0x78, 0x01, // ĻŸ (U+013B U+0178)
  0x01, 0x3B, 0x20, 0x19, 0x01, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1D, 0x01, // Ļ” (U+013B U+201D)
  0x01, 0x3B, 0x20, 0x39, 0x01, // Ļ‹ (U+013B U+2039)
  0x01, 0x3D, 0x00, 0x22, 0x01, // Ľ" (U+013D U+0022)
  0x01, 0x3D, 0x00, 0x27, 0x01, // Ľ' (U+013D U+0027)
  0x01, 0x3D, 0x00, 0x54, 0x01, // ĽT (U+013D U+0054)
  0x01, 0x3D, 0x00, 0x59, 0x01, // ĽY (U+013D U+0059)
  0x01, 0x3D, 0x00, 0xAB, 0x01, // Ľ« (U+013D U+00AB)
  0x01, 0x3D, 0x00, 0xDD, 0x01, // ĽÝ (U+013D U+00DD)
  0x01, 0x3D, 0x01, 0x62, 0x01, // ĽŢ (U+013D U+0162)
  0x01, 0x3D, 0x01, 0x64, 0x01, // ĽŤ (U+013D U+0164)
  0x01, 0x3D, 0x01, 0x66, 0x01, // ĽŦ (U+013D U+0166)
  0x01, 0x3D, 0x01, 0x76, 0x01, // ĽŶ (U+013D U+0176)
  0x01, 0x3D, 0x01, 0x78, 0x01, // ĽŸ (U+013D U+0178)
  0x01, 0x3D, 0x20, 0x19, 0x01, // Ľ’ (U+013D U+2019)
  0x01, 0x3D, 0x20, 0x1D, 0x01, // Ľ” (U+013D U+201D)
  0x01, 0x3D, 0x20, 0x39, 0x01, // Ľ‹ (U+013D U+2039)
  0x01, 0x3F, 0x00, 0x22, 0x01, // Ŀ" (U+013F U+0022)
  0x01, 0x3F, 0x00, 0x27, 0x01, // Ŀ' (U+013F U+0027)
  0x01, 0x3F, 0x00, 0x54, 0x01, // ĿT (U+013F U+0054)
  0x01, 0x3F, 0x00, 0x59, 0x01, // ĿY (U+013F U+0059)
  0x01, 0x3F, 0x00, 0xAB, 0x01, // Ŀ« (U+013F U+00AB)
  0x01, 0x3F, 0x00, 0xDD, 0x01, // ĿÝ (U+013F U+00DD)
  0x01, 0x3F, 0x01, 0x62, 0x01, // ĿŢ (U+013F U+0162)
  0x01, 0x3F, 0x01, 0x64, 0x01, // ĿŤ (U+013F U+0164)
  0x01, 0x3F, 0x01, 0x66, 0x01, // ĿŦ (U+013F U+0166)
  0x01, 0x3F, 0x01, 0x76, 0x01, // ĿŶ (U+013F U+0176)
  0x01, 0x3F, 0x01, 0x78, 0x01, // ĿŸ (U+013F U+0178)
  0x01, 0x3F, 0x20, 0x19, 0x01, // Ŀ’ (U+013F U+2019)
  0x01, 0x3F, 0x20, 0x1D, 0x01, // Ŀ” (U+013F U+201D)
  0x01, 0x3F, 0x20, 0x39, 0x01, // Ŀ‹ (U+013F U+2039)
  0x01, 0x41, 0x00, 0x22, 0x01, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x01, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x00, 0x54, 0x01, // ŁT (U+0141 U+0054)
  0x01, 0x41, 0x00, 0x59, 0x01, // ŁY (U+0141 U+0059)
  0x01, 0x41, 0x00, 0xAB, 0x01, // Ł« (U+0141 U+00AB)
  0x01, 0x41, 0x00, 0xDD, 0x01, // ŁÝ (U+0141 U+00DD)
  0x01, 0x41, 0x01, 0x62, 0x01, // ŁŢ (U+0141 U+0162)
  0x01, 0x41, 0x01, 0x64, 0x01, // ŁŤ (U+0141 U+0164)
  0x01, 0x41, 0x01, 0x66, 0x01, // ŁŦ (U+0141 U+0166)
  0x01, 0x41, 0x01, 0x76, 0x01, // ŁŶ (U+0141 U+0176)
  0x01, 0x41, 0x01, 0x78, 0x01, // ŁŸ (U+0141 U+0178)
  0x01, 0x41, 0x20, 0x19, 0x01, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1D, 0x01, // Ł” (U+0141 U+201D)
  0x01, 0x41, 0x20, 0x39, 0x01, // Ł‹ (U+0141 U+2039)
  0x01, 0x4C, 0x00, 0x2C, 0x01, // Ō, (U+014C U+002C)
  0x01, 0x4C, 0x00, 0x2E, 0x01, // Ō. (U+014C U+002E)
  0x01, 0x4C, 0x20, 0x1A, 0x01, // Ō‚ (U+014C U+201A)
  0x01, 0x4C, 0x20, 0x1E, 0x01, // Ō„ (U+014C U+201E)
  0x01, 0x4C, 0x20, 0x26, 0x01, // Ō… (U+014C U+2026)
  0x01, 0x4E, 0x00, 0x2C, 0x01, // Ŏ, (U+014E U+002C)
  0x01, 0x4E, 0x00, 0x2E, 0x01, // Ŏ. (U+014E U+002E)
  0x01, 0x4E, 0x20, 0x1A, 0x01, // Ŏ‚ (U+014E U+201A)
  0x01, 0x4E, 0x20, 0x1E, 0x01, // Ŏ„ (U+014E U+201E)
  0x01, 0x4E, 0x20, 0x26, 0x01, // Ŏ… (U+014E U+2026)
  0x01, 0x50, 0x00, 0x2C, 0x01, // Ő, (U+0150 U+002C)
  0x01, 0x50, 0x00, 0x2E, 0x01, // Ő. (U+0150 U+002E)
  0x01, 0x50, 0x20, 0x1A, 0x01, // Ő‚ (U+0150 U+201A)
  0x01, 0x50, 0x20, 0x1E, 0x01, // Ő„ (U+0150 U+201E)
  0x01, 0x50, 0x20, 0x26, 0x01, // Ő… (U+0150 U+2026)
  0x01, 0x62, 0x00, 0x2C, 0x01, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2D, 0x01, // Ţ- (U+0162 U+002D)
  0x01, 0x62, 0x00, 0x2E, 0x01, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0x61, 0x01, // Ţa (U+0162 U+0061)
  0x01, 0x62, 0x00, 0x63, 0x01, // Ţc (U+0162 U+0063)
  0x01, 0x62, 0x00, 0x64, 0x01, // Ţd (U+0162 U+0064)
  0x01, 0x62, 0x00, 0x65, 0x01, // Ţe (U+0162 U+0065)
  0x01, 0x62, 0x00, 0x67, 0x01, // Ţg (U+0162 U+0067)
  0x01, 0x62, 0x00, 0x6D, 0x01, // Ţm (U+0162 U+006D)
  0x01, 0x62, 0x00, 0x6E, 0x01, // Ţn (U+0162 U+006E)
  0x01, 0x62, 0x00, 0x6F, 0x01, // Ţo (U+0162 U+006F)
  0x01, 0x62, 0x00, 0x70, 0x01, // Ţp (U+0162 U+0070)
  0x01, 0x62, 0x00, 0x71, 0x01, // Ţq (U+0162 U+0071)
  0x01, 0x62, 0x00, 0x72, 0x01, // Ţr (U+0162 U+0072)
  0x01, 0x62, 0x00, 0x73, 0x01, // Ţs (U+0162 U+0073)
  0x01, 0x62, 0x00, 0x75, 0x01, // Ţu (U+0162 U+0075)
  0x01, 0x62, 0x00, 0xAB, 0x01, // Ţ« (U+0162 U+00AB)
  0x01, 0x62, 0x00, 0xE0, 0x01, // Ţà (U+0162 U+00E0)
  0x01, 0x62, 0x00, 0xE1, 0x01, // Ţá (U+0162 U+00E1)
  0x01, 0x62, 0x00, 0xE2, 0x01, // Ţâ (U+0162 U+00E2)
  0x01, 0x62, 0x00, 0xE3, 0x01, // Ţã (U+0162 U+00E3)
  0x01, 0x62, 0x00, 0xE4, 0x01, // Ţä (U+0162 U+00E4)
  0x01, 0x62, 0x00, 0xE5, 0x01, // Ţå (U+0162 U+00E5)
  0x01, 0x62, 0x00, 0xE6, 0x01, // Ţæ (U+0162 U+00E6)
  0x01, 0x62, 0x00, 0xE7, 0x01, // Ţç (U+0162 U+00E7)
  0x01, 0x62, 0x00, 0xE8, 0x01, // Ţè (U+0162 U+00E8)
  0x01, 0x62, 0x00, 0xE9, 0x01, // Ţé (U+0162 U+00E9)
  0x01, 0x62, 0x00, 0xEA, 0x01, // Ţê (U+0162 U+00EA)
  0x01, 0x62, 0x00, 0xEB, 0x01, // Ţë (U+0162 U+00EB)
  0x01, 0x62, 0x00, 0xF1, 0x01, // Ţñ (U+0162 U+00F1)
  0x01, 0x62, 0x00, 0xF2, 0x01, // Ţò (U+0162 U+00F2)
  0x01, 0x62, 0x00, 0xF3, 0x01, // Ţó (U+0162 U+00F3)
  0x01, 0x62, 0x00, 0xF4, 0x01, // Ţô (U+0162 U+00F4)
  0x01, 0x62, 0x00, 0xF5, 0x01, // Ţõ (U+0162 U+00F5)
  0x01, 0x62, 0x00, 0xF6, 0x01, // Ţö (U+0162 U+00F6)
  0x01, 0x62, 0x00, 0xF8, 0x01, // Ţø (U+0162 U+00F8)
  0x01, 0x62, 0x00, 0xF9, 0x01, // Ţù (U+0162 U+00F9)
  0x01, 0x62, 0x00, 0xFA, 0x01, // Ţú (U+0162 U+00FA)
  0x01, 0x62, 0x00, 0xFB, 0x01, // Ţû (U+0162 U+00FB)
  0x01, 0x62, 0x00, 0xFC, 0x01, // Ţü (U+0162 U+00FC)
  0x01, 0x62, 0x01, 0x01, 0x01, // Ţā (U+0162 U+0101)
  0x01, 0x62, 0x01, 0x03, 0x01, // Ţă (U+0162 U+0103)
  0x01, 0x62, 0x01, 0x05, 0x01, // Ţą (U+0162 U+0105)
  0x01, 0x62, 0x01, 0x07, 0x01, // Ţć (U+0162 U+0107)
  0x01, 0x62, 0x01, 0x09, 0x01, // Ţĉ (U+0162 U+0109)
  0x01, 0x62, 0x01, 0x0B, 0x01, // Ţċ (U+0162 U+010B)
  0x01, 0x62, 0x01, 0x0D, 0x01, // Ţč (U+0162 U+010D)
  0x01, 0x62, 0x01, 0x0F, 0x01, // Ţď (U+0162 U+010F)
  0x01, 0x62, 0x01, 0x11, 0x01, // Ţđ (U+0162 U+0111)
  0x01, 0x62, 0x01, 0x13, 0x01, // Ţē (U+0162 U+0113)
  0x01, 0x62, 0x01, 0x15, 0x01, // Ţĕ (U+0162 U+0115)
  0x01, 0x62, 0x01, 0x17, 0x01, // Ţė (U+0162 U+0117)
  0x01, 0x62, 0x01, 0x19, 0x01, // Ţę (U+0162 U+0119)
  0x01, 0x62, 0x01, 0x1B, 0x01, // Ţě (U+0162 U+011B)
  0x01, 0x62, 0x01, 0x1D, 0x01, // Ţĝ (U+0162 U+011D)
  0x01, 0x62, 0x01, 0x1F, 0x01, // Ţğ (U+0162 U+011F)
  0x01, 0x62, 0x01, 0x21, 0x01, // Ţġ (U+0162 U+0121)
  0x01, 0x62, 0x01, 0x23, 0x01, // Ţģ (U+0162 U+0123)
  0x01, 0x62, 0x01, 0x38, 0x01, // Ţĸ (U+0162 U+0138)
  0x01, 0x62, 0x01, 0x44, 0x01, // Ţń (U+0162 U+0144)
  0x01, 0x62, 0x01, 0x46, 0x01, // Ţņ (U+0162 U+0146)
  0x01, 0x62, 0x01, 0x48, 0x01, // Ţň (U+0162 U+0148)
  0x01, 0x62, 0x01, 0x4B, 0x01, // Ţŋ (U+0162 U+014B)
  0x01, 0x62, 0x01, 0x4D, 0x01, // Ţō (U+0162 U+014D)
  0x01, 0x62, 0x01, 0x4F, 0x01, // Ţŏ (U+0162 U+014F)
  0x01, 0x62, 0x01, 0x51, 0x01, // Ţő (U+0162 U+0151)
  0x01, 0x62, 0x01, 0x53, 0x01, // Ţœ (U+0162 U+0153)
  0x01, 0x62, 0x01, 0x55, 0x01, // Ţŕ (U+0162 U+0155)
  0x01, 0x62, 0x01, 0x57, 0x01, // Ţŗ (U+0162 U+0157)
  0x01, 0x62, 0x01, 0x5B, 0x01, // Ţś (U+0162 U+015B)
  0x01, 0x62, 0x01, 0x5D, 0x01, // Ţŝ (U+0162 U+015D)
  0x01, 0x62, 0x01, 0x5F, 0x01, // Ţş (U+0162 U+015F)
  0x01, 0x62, 0x01, 0x61, 0x01, // Ţš (U+0162 U+0161)
  0x01, 0x62, 0x01, 0x69, 0x01, // Ţũ (U+0162 U+0169)
  0x01, 0x62, 0x01, 0x6B, 0x01, // Ţū (U+0162 U+016B)
  0x01, 0x62, 0x01, 0x6D, 0x01, // Ţŭ (U+0162 U+016D)
  0x01, 0x62, 0x01, 0x6F, 0x01, // Ţů (U+0162 U+016F)
  0x01, 0x62, 0x01, 0x71, 0x01, // Ţű (U+0162 U+0171)
  0x01, 0x62, 0x01, 0x73, 0x01, // Ţų (U+0162 U+0173)
  0x01, 0x62, 0x20, 0x13, 0x01, // Ţ– (U+0162 U+2013)
  0x01, 0x62, 0x20, 0x14, 0x01, // Ţ— (U+0162 U+2014)
  0x01, 0x62, 0x20, 0x1A, 0x01, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x01, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x01, // Ţ… (U+0162 U+2026)
  0x01, 0x62, 0x20, 0x39, 0x01, // Ţ‹ (U+0162 U+2039)
  0x01, 0x64, 0x00, 0x2C, 0x01, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2D, 0x01, // Ť- (U+0164 U+002D)
  0x01, 0x64, 0x00, 0x2E, 0x01, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0x61, 0x01, // Ťa (U+0164 U+0061)
  0x01, 0x64, 0x00, 0x63, 0x01, // Ťc (U+0164 U+0063)
  0x01, 0x64, 0x00, 0x64, 0x01, // Ťd (U+0164 U+0064)
  0x01, 0x64, 0x00, 0x65, 0x01, // Ťe (U+0164 U+0065)
  0x01, 0x64, 0x00, 0x67, 0x01, // Ťg (U+0164 U+0067)
  0x01, 0x64, 0x00, 0x6D, 0x01, // Ťm (U+0164 U+006D)
  0x01, 0x64, 0x00, 0x6E, 0x01, // Ťn (U+0164 U+006E)
  0x01, 0x64, 0x00, 0x6F, 0x01, // Ťo (U+0164 U+006F)
  0x01, 0x64, 0x00, 0x70, 0x01, // Ťp (U+0164 U+0070)
  0x01, 0x64, 0x00, 0x71, 0x01, // Ťq (U+0164 U+0071)
  0x01, 0x64, 0x00, 0x72, 0x01, // Ťr (U+0164 U+0072)
  0x01, 0x64, 0x00, 0x73, 0x01, // Ťs (U+0164 U+0073)
  0x01, 0x64, 0x00, 0x75, 0x01, // Ťu (U+0164 U+0075)
  0x01, 0x64, 0x00, 0xAB, 0x01, // Ť« (U+0164 U+00AB)
  0x01, 0x64, 0x00, 0xE0, 0x01, // Ťà (U+0164 U+00E0)
  0x01, 0x64, 0x00, 0xE1, 0x01, // Ťá (U+0164 U+00E1)
  0x01, 0x64, 0x00, 0xE2, 0x01, // Ťâ (U+0164 U+00E2)
  0x01, 0x64, 0x00, 0xE3, 0x01, // Ťã (U+0164 U+00E3)
  0x01, 0x64, 0x00, 0xE4, 0x01, // Ťä (U+0164 U+00E4)
  0x01, 0x64, 0x00, 0xE5, 0x01, // Ťå (U+0164 U+00E5)
  0x01, 0x64, 0x00, 0xE6, 0x01, // Ťæ (U+0164 U+00E6)
  0x01, 0x64, 0x00, 0xE7, 0x01, // Ťç (U+0164 U+00E7)
  0x01, 0x64, 0x00, 0xE8, 0x01, // Ťè (U+0164 U+00E8)
  0x01, 0x64, 0x00, 0xE9, 0x01, // Ťé (U+0164 U+00E9)
  0x01, 0x64, 0x00, 0xEA, 0x01, // Ťê (U+0164 U+00EA)
  0x01, 0x64, 0x00, 0xEB, 0x01, // Ťë (U+0164 U+00EB)
  0x01, 0x64, 0x00, 0xF1, 0x01, // Ťñ (U+0164 U+00F1)
  0x01, 0x64, 0x00, 0xF2, 0x01, // Ťò (U+0164 U+00F2)
  0x01, 0x64, 0x00, 0xF3, 0x01, // Ťó (U+0164 U+00F3)
  0x01, 0x64, 0x00, 0xF4, 0x01, // Ťô (U+0164 U+00F4)
  0x01, 0x64, 0x00, 0xF5, 0x01, // Ťõ (U+0164 U+00F5)
  0x01, 0x64, 0x00, 0xF6, 0x01, // Ťö (U+0164 U+00F6)
  0x01, 0x64, 0x00, 0xF8, 0x01, // Ťø (U+0164 U+00F8)
  0x01, 0x64, 0x00, 0xF9, 0x01, // Ťù (U+0164 U+00F9)
  0x01, 0x64, 0x00, 0xFA, 0x01, // Ťú (U+0164 U+00FA)
  0x01, 0x64, 0x00, 0xFB, 0x01, // Ťû (U+0164 U+00FB)
  0x01, 0x64, 0x00, 0xFC, 0x01, // Ťü (U+0164 U+00FC)
  0x01, 0x64, 0x01, 0x01, 0x01, // Ťā (U+0164 U+0101)
  0x01, 0x64, 0x01, 0x03, 0x01, // Ťă (U+0164 U+0103)
  0x01, 0x64, 0x01, 0x05, 0x01, // Ťą (U+0164 U+0105)
  0x01, 0x64, 0x01, 0x07, 0x01, // Ťć (U+0164 U+0107)
  0x01, 0x64, 0x01, 0x09, 0x01, // Ťĉ (U+0164 U+0109)
  0x01, 0x64, 0x01, 0x0B, 0x01, // Ťċ (U+0164 U+010B)
  0x01, 0x64, 0x01, 0x0D, 0x01, // Ťč (U+0164 U+010D)
  0x01, 0x64, 0x01, 0x0F, 0x01, // Ťď (U+0164 U+010F)
  0x01, 0x64, 0x01, 0x11, 0x01, // Ťđ (U+0164 U+0111)
  0x01, 0x64, 0x01, 0x13, 0x01, // Ťē (U+0164 U+0113)
  0x01, 0x64, 0x01, 0x15, 0x01, // Ťĕ (U+0164 U+0115)
  0x01, 0x64, 0x01, 0x17, 0x01, // Ťė (U+0164 U+0117)
  0x01, 0x64, 0x01, 0x19, 0x01, // Ťę (U+0164 U+0119)
  0x01, 0x64, 0x01, 0x1B, 0x01, // Ťě (U+0164 U+011B)
  0x01, 0x64, 0x01, 0x1D, 0x01, // Ťĝ (U+0164 U+011D)
  0x01, 0x64, 0x01, 0x1F, 0x01, // Ťğ (U+0164 U+011F)
  0x01, 0x64, 0x01, 0x21, 0x01, // Ťġ (U+0164 U+0121)
  0x01, 0x64, 0x01, 0x23, 0x01, // Ťģ (U+0164 U+0123)
  0x01, 0x64, 0x01, 0x38, 0x01, // Ťĸ (U+0164 U+0138)
  0x01, 0x64, 0x01, 0x44, 0x01, // Ťń (U+0164 U+0144)
  0x01, 0x64, 0x01, 0x46, 0x01, // Ťņ (U+0164 U+0146)
  0x01, 0x64, 0x01, 0x48, 0x01, // Ťň (U+0164 U+0148)
  0x01, 0x64, 0x01, 0x4B, 0x01, // Ťŋ (U+0164 U+014B)
  0x01, 0x64, 0x01, 0x4D, 0x01, // Ťō (U+0164 U+014D)
  0x01, 0x64, 0x01, 0x4F, 0x01, // Ťŏ (U+0164 U+014F)
  0x01, 0x64, 0x01, 0x51, 0x01, // Ťő (U+0164 U+0151)
  0x01, 0x64, 0x01, 0x53, 0x01, // Ťœ (U+0164 U+0153)
  0x01, 0x64, 0x01, 0x55, 0x01, // Ťŕ (U+0164 U+0155)
  0x01, 0x64, 0x01, 0x57, 0x01, // Ťŗ (U+0164 U+0157)
  0x01, 0x64, 0x01, 0x5B, 0x01, // Ťś (U+0164 U+015B)
  0x01, 0x64, 0x01, 0x5D, 0x01, // Ťŝ (U+0164 U+015D)
  0x01, 0x64, 0x01, 0x5F, 0x01, // Ťş (U+0164 U+015F)
  0x01, 0x64, 0x01, 0x61, 0x01, // Ťš (U+0164 U+0161)
  0x01, 0x64, 0x01, 0x69, 0x01, // Ťũ (U+0164 U+0169)
  0x01, 0x64, 0x01, 0x6B, 0x01, // Ťū (U+0164 U+016B)
  0x01, 0x64, 0x01, 0x6D, 0x01, // Ťŭ (U+0164 U+016D)
  0x01, 0x64, 0x01, 0x6F, 0x01, // Ťů (U+0164 U+016F)
  0x01, 0x64, 0x01, 0x71, 0x01, // Ťű (U+0164 U+0171)
  0x01, 0x64, 0x01, 0x73, 0x01, // Ťų (U+0164 U+0173)
  0x01, 0x64, 0x20, 0x13, 0x01, // Ť– (U+0164 U+2013)
  0x01, 0x64, 0x20, 0x14, 0x01, // Ť— (U+0164 U+2014)
  0x01, 0x64, 0x20, 0x1A, 0x01, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x01, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x01, // Ť… (U+0164 U+2026)
  0x01, 0x64, 0x20, 0x39, 0x01, // Ť‹ (U+0164 U+2039)
  0x01, 0x66, 0x00, 0x2C, 0x01, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2D, 0x01, // Ŧ- (U+0166 U+002D)
  0x01, 0x66, 0x00, 0x2E, 0x01, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0x61, 0x01, // Ŧa (U+0166 U+0061)
  0x01, 0x66, 0x00, 0x63, 0x01, // Ŧc (U+0166 U+0063)
  0x01, 0x66, 0x00, 0x64, 0x01, // Ŧd (U+0166 U+0064)
  0x01, 0x66, 0x00, 0x65, 0x01, // Ŧe (U+0166 U+0065)
  0x01, 0x66, 0x00, 0x67, 0x01, // Ŧg (U+0166 U+0067)
  0x01, 0x66, 0x00, 0x6D, 0x01, // Ŧm (U+0166 U+006D)
  0x01, 0x66, 0x00, 0x6E, 0x01, // Ŧn (U+0166 U+006E)
  0x01, 0x66, 0x00, 0x6F, 0x01, // Ŧo (U+0166 U+006F)
  0x01, 0x66, 0x00, 0x70, 0x01, // Ŧp (U+0166 U+0070)
  0x01, 0x66, 0x00, 0x71, 0x01, // Ŧq (U+0166 U+0071)
  0x01, 0x66, 0x00, 0x72, 0x01, // Ŧr (U+0166 U+0072)
  0x01, 0x66, 0x00, 0x73, 0x01, // Ŧs (U+0166 U+0073)
  0x01, 0x66, 0x00, 0x75, 0x01, // Ŧu (U+0166 U+0075)
  0x01, 0x66, 0x00, 0xAB, 0x01, // Ŧ« (U+0166 U+00AB)
  0x01, 0x66, 0x00, 0xE0, 0x01, // Ŧà (U+0166 U+00E0)
  0x01, 0x66, 0x00, 0xE1, 0x01, // Ŧá (U+0166 U+00E1)
  0x01, 0x66, 0x00, 0xE2, 0x01, // Ŧâ (U+0166 U+00E2)
  0x01, 0x66, 0x00, 0xE3, 0x01, // Ŧã (U+0166 U+00E3)
  0x01, 0x66, 0x00, 0xE4, 0x01, // Ŧä (U+0166 U+00E4)
  0x01, 0x66, 0x00, 0xE5, 0x01, // Ŧå (U+0166 U+00E5)
  0x01, 0x66, 0x00, 0xE6, 0x01, // Ŧæ (U+0166 U+00E6)
  0x01, 0x66, 0x00, 0xE7, 0x01, // Ŧç (U+0166 U+00E7)
  0x01, 0x66, 0x00, 0xE8, 0x01, // Ŧè (U+0166 U+00E8)
  0x01, 0x66, 0x00, 0xE9, 0x01, // Ŧé (U+0166 U+00E9)
  0x01, 0x66, 0x00, 0xEA, 0x01, // Ŧê (U+0166 U+00EA)
  0x01, 0x66, 0x00, 0xEB, 0x01, // Ŧë (U+0166 U+00EB)
  0x01, 0x66, 0x00, 0xF1, 0x01, // Ŧñ (U+0166 U+00F1)
  0x01, 0x66, 0x00, 0xF2, 0x01, // Ŧò (U+0166 U+00F2)
  0x01, 0x66, 0x00, 0xF3, 0x01, // Ŧó (U+0166 U+00F3)
  0x01, 0x66, 0x00, 0xF4, 0x01, // Ŧô (U+0166 U+00F4)
  0x01, 0x66, 0x00, 0xF5, 0x01, // Ŧõ (U+0166 U+00F5)
  0x01, 0x66, 0x00, 0xF6, 0x01, // Ŧö (U+0166 U+00F6)
  0x01, 0x66, 0x00, 0xF8, 0x01, // Ŧø (U+0166 U+00F8)
  0x01, 0x66, 0x00, 0xF9, 0x01, // Ŧù (U+0166 U+00F9)
  0x01, 0x66, 0x00, 0xFA, 0x01, // Ŧú (U+0166 U+00FA)
  0x01, 0x66, 0x00, 0xFB, 0x01, // Ŧû (U+0166 U+00FB)
  0x01, 0x66, 0x00, 0xFC, 0x01, // Ŧü (U+0166 U+00FC)
  0x01, 0x66, 0x01, 0x01, 0x01, // Ŧā (U+0166 U+0101)
  0x01, 0x66, 0x01, 0x03, 0x01, // Ŧă (U+0166 U+0103)
  0x01, 0x66, 0x01, 0x05, 0x01, // Ŧą (U+0166 U+0105)
  0x01, 0x66, 0x01, 0x07, 0x01, // Ŧć (U+0166 U+0107)
  0x01, 0x66, 0x01, 0x09, 0x01, // Ŧĉ (U+0166 U+0109)
  0x01, 0x66, 0x01, 0x0B, 0x01, // Ŧċ (U+0166 U+010B)
  0x01, 0x66, 0x01, 0x0D, 0x01, // Ŧč (U+0166 U+010D)
  0x01, 0x66, 0x01, 0x0F, 0x01, // Ŧď (U+0166 U+010F)
  0x01, 0x66, 0x01, 0x11, 0x01, // Ŧđ (U+0166 U+0111)
  0x01, 0x66, 0x01, 0x13, 0x01, // Ŧē (U+0166 U+0113)
  0x01, 0x66, 0x01, 0x15, 0x01, // Ŧĕ (U+0166 U+0115)
  0x01, 0x66, 0x01, 0x17, 0x01, // Ŧė (U+0166 U+0117)
  0x01, 0x66, 0x01, 0x19, 0x01, // Ŧę (U+0166 U+0119)
  0x01, 0x66, 0x01, 0x1B, 0x01, // Ŧě (U+0166 U+011B)
  0x01, 0x66, 0x01, 0x1D, 0x01, // Ŧĝ (U+0166 U+011D)
  0x01, 0x66, 0x01, 0x1F, 0x01, // Ŧğ (U+0166 U+011F)
  0x01, 0x66, 0x01, 0x21, 0x01, // Ŧġ (U+0166 U+0121)
  0x01, 0x66, 0x01, 0x23, 0x01, // Ŧģ (U+0166 U+0123)
  0x01, 0x66, 0x01, 0x38, 0x01, // Ŧĸ (U+0166 U+0138)
  0x01, 0x66, 0x01, 0x44, 0x01, // Ŧń (U+0166 U+0144)
  0x01, 0x66, 0x01, 0x46, 0x01, // Ŧņ (U+0166 U+0146)
  0x01, 0x66, 0x01, 0x48, 0x01, // Ŧň (U+0166 U+0148)
  0x01, 0x66, 0x01, 0x4B, 0x01, // Ŧŋ (U+0166 U+014B)
  0x01, 0x66, 0x01, 0x4D, 0x01, // Ŧō (U+0166 U+014D)
  0x01, 0x66, 0x01, 0x4F, 0x01, // Ŧŏ (U+0166 U+014F)
  0x01, 0x66, 0x01, 0x51, 0x01, // Ŧő (U+0166 U+0151)
  0x01, 0x66, 0x01, 0x53, 0x01, // Ŧœ (U+0166 U+0153)
  0x01, 0x66, 0x01, 0x55, 0x01, // Ŧŕ (U+0166 U+0155)
  0x01, 0x66, 0x01, 0x57, 0x01, // Ŧŗ (U+0166 U+0157)
  0x01, 0x66, 0x01, 0x5B, 0x01, // Ŧś (U+0166 U+015B)
  0x01, 0x66, 0x01, 0x5D, 0x01, // Ŧŝ (U+0166 U+015D)
  0x01, 0x66, 0x01, 0x5F, 0x01, // Ŧş (U+0166 U+015F)
  0x01, 0x66, 0x01, 0x61, 0x01, // Ŧš (U+0166 U+0161)
  0x01, 0x66, 0x01, 0x69, 0x01, // Ŧũ (U+0166 U+0169)
  0x01, 0x66, 0x01, 0x6B, 0x01, // Ŧū (U+0166 U+016B)
  0x01, 0x66, 0x01, 0x6D, 0x01, // Ŧŭ (U+0166 U+016D)
  0x01, 0x66, 0x01, 0x6F, 0x01, // Ŧů (U+0166 U+016F)
  0x01, 0x66, 0x01, 0x71, 0x01, // Ŧű (U+0166 U+0171)
  0x01, 0x66, 0x01, 0x73, 0x01, // Ŧų (U+0166 U+0173)
  0x01, 0x66, 0x20, 0x13, 0x01, // Ŧ– (U+0166 U+2013)
  0x01, 0x66, 0x20, 0x14, 0x01, // Ŧ— (U+0166 U+2014)
  0x01, 0x66, 0x20, 0x1A, 0x01, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x01, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x01, // Ŧ… (U+0166 U+2026)
  0x01, 0x66, 0x20, 0x39, 0x01, // Ŧ‹ (U+0166 U+2039)
  0x01, 0x74, 0x00, 0x2C, 0x01, // Ŵ, (U+0174 U+002C)
  0x01, 0x74, 0x00, 0x2E, 0x01, // Ŵ. (U+0174 U+002E)
  0x01, 0x74, 0x20, 0x1A, 0x01, // Ŵ‚ (U+0174 U+201A)
  0x01, 0x74, 0x20, 0x1E, 0x01, // Ŵ„ (U+0174 U+201E)
  0x01, 0x74, 0x20, 0x26, 0x01, // Ŵ… (U+0174 U+2026)
  0x01, 0x76, 0x00, 0x2C, 0x01, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x01, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x00, 0x61, 0x01, // Ŷa (U+0176 U+0061)
  0x01, 0x76, 0x00, 0x63, 0x01, // Ŷc (U+0176 U+0063)
  0x01, 0x76, 0x00, 0x64, 0x01, // Ŷd (U+0176 U+0064)
  0x01, 0x76, 0x00, 0x65, 0x01, // Ŷe (U+0176 U+0065)
  0x01, 0x76, 0x00, 0x6F, 0x01, // Ŷo (U+0176 U+006F)
  0x01, 0x76, 0x00, 0x71, 0x01, // Ŷq (U+0176 U+0071)
  0x01, 0x76, 0x00, 0xAB, 0x01, // Ŷ« (U+0176 U+00AB)
  0x01, 0x76, 0x00, 0xBB, 0x01, // Ŷ» (U+0176 U+00BB)
  0x01, 0x76, 0x00, 0xE0, 0x01, // Ŷà (U+0176 U+00E0)
  0x01, 0x76, 0x00, 0xE1, 0x01, // Ŷá (U+0176 U+00E1)
  0x01, 0x76, 0x00, 0xE2, 0x01, // Ŷâ (U+0176 U+00E2)
  0x01, 0x76, 0x00, 0xE3, 0x01, // Ŷã (U+0176 U+00E3)
  0x01, 0x76, 0x00, 0xE4, 0x01, // Ŷä (U+0176 U+00E4)
  0x01, 0x76, 0x00, 0xE5, 0x01, // Ŷå (U+0176 U+00E5)
  0x01, 0x76, 0x00, 0xE6, 0x01, // Ŷæ (U+0176 U+00E6)
  0x01, 0x76, 0x00, 0xE7, 0x01, // Ŷç (U+0176 U+00E7)
  0x01, 0x76, 0x00, 0xE8, 0x01, // Ŷè (U+0176 U+00E8)
  0x01, 0x76, 0x00, 0xE9, 0x01, // Ŷé (U+0176 U+00E9)
  0x01, 0x76, 0x00, 0xEA, 0x01, // Ŷê (U+0176 U+00EA)
  0x01, 0x76, 0x00, 0xEB, 0x01, // Ŷë (U+0176 U+00EB)
  0x01, 0x76, 0x00, 0xF2, 0x01, // Ŷò (U+0176 U+00F2)
  0x01, 0x76, 0x00, 0xF3, 0x01, // Ŷó (U+0176 U+00F3)
  0x01, 0x76, 0x00, 0xF4, 0x01, // Ŷô (U+0176 U+00F4)
  0x01, 0x76, 0x00, 0xF5, 0x01, // Ŷõ (U+0176 U+00F5)
  0x01, 0x76, 0x00, 0xF6, 0x01, // Ŷö (U+0176 U+00F6)
  0x01, 0x76, 0x00, 0xF8, 0x01, // Ŷø (U+0176 U+00F8)
  0x01, 0x76, 0x01, 0x01, 0x01, // Ŷā (U+0176 U+0101)
  0x01, 0x76, 0x01, 0x03, 0x01, // Ŷă (U+0176 U+0103)
  0x01, 0x76, 0x01, 0x05, 0x01, // Ŷą (U+0176 U+0105)
  0x01, 0x76, 0x01, 0x07, 0x01, // Ŷć (U+0176 U+0107)
  0x01, 0x76, 0x01, 0x09, 0x01, // Ŷĉ (U+0176 U+0109)
  0x01, 0x76, 0x01, 0x0B, 0x01, // Ŷċ (U+0176 U+010B)
  0x01, 0x76, 0x01, 0x0D, 0x01, // Ŷč (U+0176 U+010D)
  0x01, 0x76, 0x01, 0x0F, 0x01, // Ŷď (U+0176 U+010F)
  0x01, 0x76, 0x01, 0x11, 0x01, // Ŷđ (U+0176 U+0111)
  0x01, 0x76, 0x01, 0x13, 0x01, // Ŷē (U+0176 U+0113)
  0x01, 0x76, 0x01, 0x15, 0x01, // Ŷĕ (U+0176 U+0115)
  0x01, 0x76, 0x01, 0x17, 0x01, // Ŷė (U+0176 U+0117)
  0x01, 0x76, 0x01, 0x19, 0x01, // Ŷę (U+0176 U+0119)
  0x01, 0x76, 0x01, 0x1B, 0x01, // Ŷě (U+0176 U+011B)
  0x01, 0x76, 0x01, 0x4D, 0x01, // Ŷō (U+0176 U+014D)
  0x01, 0x76, 0x01, 0x4F, 0x01, // Ŷŏ (U+0176 U+014F)
  0x01, 0x76, 0x01, 0x51, 0x01, // Ŷő (U+0176 U+0151)
  0x01, 0x76, 0x01, 0x53, 0x01, // Ŷœ (U+0176 U+0153)
  0x01, 0x76, 0x20, 0x1A, 0x01, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x01, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x01, // Ŷ… (U+0176 U+2026)
  0x01, 0x76, 0x20, 0x39, 0x01, // Ŷ‹ (U+0176 U+2039)
  0x01, 0x76, 0x20, 0x3A, 0x01, // Ŷ› (U+0176 U+203A)
  0x01, 0x78, 0x00, 0x2C, 0x01, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x01, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x00, 0x61, 0x01, // Ÿa (U+0178 U+0061)
  0x01, 0x78, 0x00, 0x63, 0x01, // Ÿc (U+0178 U+0063)
  0x01, 0x78, 0x00, 0x64, 0x01, // Ÿd (U+0178 U+0064)
  0x01, 0x78, 0x00, 0x65, 0x01, // Ÿe (U+0178 U+0065)
  0x01, 0x78, 0x00, 0x6F, 0x01, // Ÿo (U+0178 U+006F)
  0x01, 0x78, 0x00, 0x71, 0x01, // Ÿq (U+0178 U+0071)
  0x01, 0x78, 0x00, 0xAB, 0x01, // Ÿ« (U+0178 U+00AB)
  0x01, 0x78, 0x00, 0xBB, 0x01, // Ÿ» (U+0178 U+00BB)
  0x01, 0x78, 0x00, 0xE0, 0x01, // Ÿà (U+0178 U+00E0)
  0x01, 0x78, 0x00, 0xE1, 0x01, // Ÿá (U+0178 U+00E1)
  0x01, 0x78, 0x00, 0xE2, 0x01, // Ÿâ (U+0178 U+00E2)
  0x01, 0x78, 0x00, 0xE3, 0x01, // Ÿã (U+0178 U+00E3)
  0x01, 0x78, 0x00, 0xE4, 0x01, // Ÿä (U+0178 U+00E4)
  0x01, 0x78, 0x00, 0xE5, 0x01, // Ÿå (U+0178 U+00E5)
  0x01, 0x78, 0x00, 0xE6, 0x01, // Ÿæ (U+0178 U+00E6)
  0x01, 0x78, 0x00, 0xE7, 0x01, // Ÿç (U+0178 U+00E7)
  0x01, 0x78, 0x00, 0xE8, 0x01, // Ÿè (U+0178 U+00E8)
  0x01, 0x78, 0x00, 0xE9, 0x01, // Ÿé (U+0178 U+00E9)
  0x01, 0x78, 0x00, 0xEA, 0x01, // Ÿê (U+0178 U+00EA)
  0x01, 0x78, 0x00, 0xEB, 0x01, // Ÿë (U+0178 U+00EB)
  0x01, 0x78, 0x00, 0xF2, 0x01, // Ÿò (U+0178 U+00F2)
  0x01, 0x78, 0x00, 0xF3, 0x01, // Ÿó (U+0178 U+00F3)
  0x01, 0x78, 0x00, 0xF4, 0x01, // Ÿô (U+0178 U+00F4)
  0x01, 0x78, 0x00, 0xF5, 0x01, // Ÿõ (U+0178 U+00F5)
  0x01, 0x78, 0x00, 0xF6, 0x01, // Ÿö (U+0178 U+00F6)
  0x01, 0x78, 0x00, 0xF8, 0x01, // Ÿø (U+0178 U+00F8)
  0x01, 0x78, 0x01, 0x01, 0x01, // Ÿā (U+0178 U+0101)
  0x01, 0x78, 0x01, 0x03, 0x01, // Ÿă (U+0178 U+0103)
  0x01, 0x78, 0x01, 0x05, 0x01, // Ÿą (U+0178 U+0105)
  0x01, 0x78, 0x01, 0x07, 0x01, // Ÿć (U+0178 U+0107)
  0x01, 0x78, 0x01, 0x09, 0x01, // Ÿĉ (U+0178 U+0109)
  0x01, 0x78, 0x01, 0x0B, 0x01, // Ÿċ (U+0178 U+010B)
  0x01, 0x78, 0x01, 0x0D, 0x01, // Ÿč (U+0178 U+010D)
  0x01, 0x78, 0x01, 0x0F, 0x01, // Ÿď (U+0178 U+010F)
  0x01, 0x78, 0x01, 0x11, 0x01, // Ÿđ (U+0178 U+0111)
  0x01, 0x78, 0x01, 0x13, 0x01, // Ÿē (U+0178 U+0113)
  0x01, 0x78, 0x01, 0x15, 0x01, // Ÿĕ (U+0178 U+0115)
  0x01, 0x78, 0x01, 0x17, 0x01, // Ÿė (U+0178 U+0117)
  0x01, 0x78, 0x01, 0x19, 0x01, // Ÿę (U+0178 U+0119)
  0x01, 0x78, 0x01, 0x1B, 0x01, // Ÿě (U+0178 U+011B)
  0x01, 0x78, 0x01, 0x4D, 0x01, // Ÿō (U+0178 U+014D)
  0x01, 0x78, 0x01, 0x4F, 0x01, // Ÿŏ (U+0178 U+014F)
  0x01, 0x78, 0x01, 0x51, 0x01, // Ÿő (U+0178 U+0151)
  0x01, 0x78, 0x01, 0x53, 0x01, // Ÿœ (U+0178 U+0153)
  0x01, 0x78, 0x20, 0x1A, 0x01, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x01, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x01, // Ÿ… (U+0178 U+2026)
  0x01, 0x78, 0x20, 0x39, 0x01, // Ÿ‹ (U+0178 U+2039)
  0x01, 0x78, 0x20, 0x3A, 0x01, // Ÿ› (U+0178 U+203A)
  0x20, 0x13, 0x00, 0x54, 0x01, // –T (U+2013 U+0054)
  0x20, 0x13, 0x01, 0x62, 0x01, // –Ţ (U+2013 U+0162)
  0x20, 0x13, 0x01, 0x64, 0x01, // –Ť (U+2013 U+0164)
  0x20, 0x13, 0x01, 0x66, 0x01, // –Ŧ (U+2013 U+0166)
  0x20, 0x14, 0x00, 0x54, 0x01, // —T (U+2014 U+0054)
  0x20, 0x14, 0x01, 0x62, 0x01, // —Ţ (U+2014 U+0162)
  0x20, 0x14, 0x01, 0x64, 0x01, // —Ť (U+2014 U+0164)
  0x20, 0x14, 0x01, 0x66, 0x01, // —Ŧ (U+2014 U+0166)
  0x20, 0x18, 0x00, 0x41, 0x01, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0x61, 0x01, // ‘a (U+2018 U+0061)
  0x20, 0x18, 0x00, 0x63, 0x01, // ‘c (U+2018 U+0063)
  0x20, 0x18, 0x00, 0x64, 0x01, // ‘d (U+2018 U+0064)
  0x20, 0x18, 0x00, 0x65, 0x01, // ‘e (U+2018 U+0065)
  0x20, 0x18, 0x00, 0x6F, 0x01, // ‘o (U+2018 U+006F)
  0x20, 0x18, 0x00, 0x71, 0x01, // ‘q (U+2018 U+0071)
  0x20, 0x18, 0x00, 0xC0, 0x01, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x01, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x01, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x01, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x01, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x01, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xE0, 0x01, // ‘à (U+2018 U+00E0)
  0x20, 0x18, 0x00, 0xE1, 0x01, // ‘á (U+2018 U+00E1)
  0x20, 0x18, 0x00, 0xE2, 0x01, // ‘â (U+2018 U+00E2)
  0x20, 0x18, 0x00, 0xE3, 0x01, // ‘ã (U+2018 U+00E3)
  0x20, 0x18, 0x00, 0xE4, 0x01, // ‘ä (U+2018 U+00E4)
  0x20, 0x18, 0x00, 0xE5, 0x01, // ‘å (U+2018 U+00E5)
  0x20, 0x18, 0x00, 0xE6, 0x01, // ‘æ (U+2018 U+00E6)
  0x20, 0x18, 0x00, 0xE7, 0x01, // ‘ç (U+2018 U+00E7)
  0x20, 0x18, 0x00, 0xE8, 0x01, // ‘è (U+2018 U+00E8)
  0x20, 0x18, 0x00, 0xE9, 0x01, // ‘é (U+2018 U+00E9)
  0x20, 0x18, 0x00, 0xEA, 0x01, // ‘ê (U+2018 U+00EA)
  0x20, 0x18, 0x00, 0xEB, 0x01, // ‘ë (U+2018 U+00EB)
  0x20, 0x18, 0x00, 0xF2, 0x01, // ‘ò (U+2018 U+00F2)
  0x20, 0x18, 0x00, 0xF3, 0x01, // ‘ó (U+2018 U+00F3)
  0x20, 0x18, 0x00, 0xF4, 0x01, // ‘ô (U+2018 U+00F4)
  0x20, 0x18, 0x00, 0xF5, 0x01, // ‘õ (U+2018 U+00F5)
  0x20, 0x18, 0x00, 0xF6, 0x01, // ‘ö (U+2018 U+00F6)
  0x20, 0x18, 0x00, 0xF8, 0x01, // ‘ø (U+2018 U+00F8)
  0x20, 0x18, 0x01, 0x00, 0x01, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x01, 0x01, // ‘ā (U+2018 U+0101)
  0x20, 0x18, 0x01, 0x02, 0x01, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x03, 0x01, // ‘ă (U+2018 U+0103)
  0x20, 0x18, 0x01, 0x04, 0x01, // ‘Ą (U+2018 U+0104)
  0x20, 0x18, 0x01, 0x05, 0x01, // ‘ą (U+2018 U+0105)
  0x20, 0x18, 0x01, 0x07, 0x01, // ‘ć (U+2018 U+0107)
  0x20, 0x18, 0x01, 0x09, 0x01, // ‘ĉ (U+2018 U+0109)
  0x20, 0x18, 0x01, 0x0B, 0x01, // ‘ċ (U+2018 U+010B)
  0x20, 0x18, 0x01, 0x0D, 0x01, // ‘č (U+2018 U+010D)
  0x20, 0x18, 0x01, 0x0F, 0x01, // ‘ď (U+2018 U+010F)
  0x20, 0x18, 0x01, 0x11, 0x01, // ‘đ (U+2018 U+0111)
  0x20, 0x18, 0x01, 0x13, 0x01, // ‘ē (U+2018 U+0113)
  0x20, 0x18, 0x01, 0x15, 0x01, // ‘ĕ (U+2018 U+0115)
  0x20, 0x18, 0x01, 0x17, 0x01, // ‘ė (U+2018 U+0117)
  0x20, 0x18, 0x01, 0x19, 0x01, // ‘ę (U+2018 U+0119)
  0x20, 0x18, 0x01, 0x1B, 0x01, // ‘ě (U+2018 U+011B)
  0x20, 0x18, 0x01, 0x4D, 0x01, // ‘ō (U+2018 U+014D)
  0x20, 0x18, 0x01, 0x4F, 0x01, // ‘ŏ (U+2018 U+014F)
  0x20, 0x18, 0x01, 0x51, 0x01, // ‘ő (U+2018 U+0151)
  0x20, 0x18, 0x01, 0x53, 0x01, // ‘œ (U+2018 U+0153)
  0x20, 0x19, 0x00, 0x41, 0x01, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0x61, 0x01, // ’a (U+2019 U+0061)
  0x20, 0x19, 0x00, 0x63, 0x01, // ’c (U+2019 U+0063)
  0x20, 0x19, 0x00, 0x64, 0x01, // ’d (U+2019 U+0064)
  0x20, 0x19, 0x00, 0x65, 0x01, // ’e (U+2019 U+0065)
  0x20, 0x19, 0x00, 0x6F, 0x01, // ’o (U+2019 U+006F)
  0x20, 0x19, 0x00, 0x71, 0x01, // ’q (U+2019 U+0071)
  0x20, 0x19, 0x00, 0xC0, 0x01, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x01, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x01, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x01, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x01, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x01, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xE0, 0x01, // ’à (U+2019 U+00E0)
  0x20, 0x19, 0x00, 0xE1, 0x01, // ’á (U+2019 U+00E1)
  0x20, 0x19, 0x00, 0xE2, 0x01, // ’â (U+2019 U+00E2)
  0x20, 0x19, 0x00, 0xE3, 0x01, // ’ã (U+2019 U+00E3)
  0x20, 0x19, 0x00, 0xE4, 0x01, // ’ä (U+2019 U+00E4)
  0x20, 0x19, 0x00, 0xE5, 0x01, // ’å (U+2019 U+00E5)
  0x20, 0x19, 0x00, 0xE6, 0x01, // ’æ (U+2019 U+00E6)
  0x20, 0x19, 0x00, 0xE7, 0x01, // ’ç (U+2019 U+00E7)
  0x20, 0x19, 0x00, 0xE8, 0x01, // ’è (U+2019 U+00E8)
  0x20, 0x19, 0x00, 0xE9, 0x01, // ’é (U+2019 U+00E9)
  0x20, 0x19, 0x00, 0xEA, 0x01, // ’ê (U+2019 U+00EA)
  0x20, 0x19, 0x00, 0xEB, 0x01, // ’ë (U+2019 U+00EB)
  0x20, 0x19, 0x00, 0xF2, 0x01, // ’ò (U+2019 U+00F2)
  0x20, 0x19, 0x00, 0xF3, 0x01, // ’ó (U+2019 U+00F3)
  0x20, 0x19, 0x00, 0xF4, 0x01, // ’ô (U+2019 U+00F4)
  0x20, 0x19, 0x00, 0xF5, 0x01, // ’õ (U+2019 U+00F5)
  0x20, 0x19, 0x00, 0xF6, 0x01, // ’ö (U+2019 U+00F6)
  0x20, 0x19, 0x00, 0xF8, 0x01, // ’ø (U+2019 U+00F8)
  0x20, 0x19, 0x01, 0x00, 0x01, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x01, 0x01, // ’ā (U+2019 U+0101)
  0x20, 0x19, 0x01, 0x02, 0x01, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x03, 0x01, // ’ă (U+2019 U+0103)
  0x20, 0x19, 0x01, 0x04, 0x01, // ’Ą (U+2019 U+0104)
  0x20, 0x19, 0x01, 0x05, 0x01, // ’ą (U+2019 U+0105)
  0x20, 0x19, 0x01, 0x07, 0x01, // ’ć (U+2019 U+0107)
  0x20, 0x19, 0x01, 0x09, 0x01, // ’ĉ (U+2019 U+0109)
  0x20, 0x19, 0x01, 0x0B, 0x01, // ’ċ (U+2019 U+010B)
  0x20, 0x19, 0x01, 0x0D, 0x01, // ’č (U+2019 U+010D)
  0x20, 0x19, 0x01, 0x0F, 0x01, // ’ď (U+2019 U+010F)
  0x20, 0x19, 0x01, 0x11, 0x01, // ’đ (U+2019 U+0111)
  0x20, 0x19, 0x01, 0x13, 0x01, // ’ē (U+2019 U+0113)
  0x20, 0x19, 0x01, 0x15, 0x01, // ’ĕ (U+2019 U+0115)
  0x20, 0x19, 0x01, 0x17, 0x01, // ’ė (U+2019 U+0117)
  0x20, 0x19, 0x01, 0x19, 0x01, // ’ę (U+2019 U+0119)
  0x20, 0x19, 0x01, 0x1B, 0x01, // ’ě (U+2019 U+011B)
  0x20, 0x19, 0x01, 0x4D, 0x01, // ’ō (U+2019 U+014D)
  0x20, 0x19, 0x01, 0x4F, 0x01, // ’ŏ (U+2019 U+014F)
  0x20, 0x19, 0x01, 0x51, 0x01, // ’ő (U+2019 U+0151)
  0x20, 0x19, 0x01, 0x53, 0x01, // ’œ (U+2019 U+0153)
  0x20, 0x1A, 0x00, 0x43, 0x01, // ‚C (U+201A U+0043)
  0x20, 0x1A, 0x00, 0x47, 0x01, // ‚G (U+201A U+0047)
  0x20, 0x1A, 0x00, 0x4F, 0x01, // ‚O (U+201A U+004F)
  0x20, 0x1A, 0x00, 0x51, 0x01, // ‚Q (U+201A U+0051)
  0x20, 0x1A, 0x00, 0x54, 0x01, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x56, 0x01, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x01, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x01, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0xC7, 0x01, // ‚Ç (U+201A U+00C7)
  0x20, 0x1A, 0x00, 0xD2, 0x01, // ‚Ò (U+201A U+00D2)
  0x20, 0x1A, 0x00, 0xD3, 0x01, // ‚Ó (U+201A U+00D3)
  0x20, 0x1A, 0x00, 0xD4, 0x01, // ‚Ô (U+201A U+00D4)
  0x20, 0x1A, 0x00, 0xD5, 0x01, // ‚Õ (U+201A U+00D5)
  0x20, 0x1A, 0x00, 0xD6, 0x01, // ‚Ö (U+201A U+00D6)
  0x20, 0x1A, 0x00, 0xD8, 0x01, // ‚Ø (U+201A U+00D8)
  0x20, 0x1A, 0x00, 0xDD, 0x01, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x01, 0x06, 0x01, // ‚Ć (U+201A U+0106)
  0x20, 0x1A, 0x01, 0x08, 0x01, // ‚Ĉ (U+201A U+0108)
  0x20, 0x1A, 0x01, 0x0A, 0x01, // ‚Ċ (U+201A U+010A)
  0x20, 0x1A, 0x01, 0x0C, 0x01, // ‚Č (U+201A U+010C)
  0x20, 0x1A, 0x01, 0x1C, 0x01, // ‚Ĝ (U+201A U+011C)
  0x20, 0x1A, 0x01, 0x1E, 0x01, // ‚Ğ (U+201A U+011E)
  0x20, 0x1A, 0x01, 0x20, 0x01, // ‚Ġ (U+201A U+0120)
  0x20, 0x1A, 0x01, 0x22, 0x01, // ‚Ģ (U+201A U+0122)
  0x20, 0x1A, 0x01, 0x4C, 0x01, // ‚Ō (U+201A U+014C)
  0x20, 0x1A, 0x01, 0x4E, 0x01, // ‚Ŏ (U+201A U+014E)
  0x20, 0x1A, 0x01, 0x50, 0x01, // ‚Ő (U+201A U+0150)
  0x20, 0x1A, 0x01, 0x52, 0x01, // ‚Œ (U+201A U+0152)
  0x20, 0x1A, 0x01, 0x62, 0x01, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x01, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x01, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1A, 0x01, 0x74, 0x01, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x76, 0x01, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x78, 0x01, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x01, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0x61, 0x01, // “a (U+201C U+0061)
  0x20, 0x1C, 0x00, 0x63, 0x01, // “c (U+201C U+0063)
  0x20, 0x1C, 0x00, 0x64, 0x01, // “d (U+201C U+0064)
  0x20, 0x1C, 0x00, 0x65, 0x01, // “e (U+201C U+0065)
  0x20, 0x1C, 0x00, 0x6F, 0x01, // “o (U+201C U+006F)
  0x20, 0x1C, 0x00, 0x71, 0x01, // “q (U+201C U+0071)
  0x20, 0x1C, 0x00, 0xC0, 0x01, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x01, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x01, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x01, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x01, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x01, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xE0, 0x01, // “à (U+201C U+00E0)
  0x20, 0x1C, 0x00, 0xE1, 0x01, // “á (U+201C U+00E1)
  0x20, 0x1C, 0x00, 0xE2, 0x01, // “â (U+201C U+00E2)
  0x20, 0x1C, 0x00, 0xE3, 0x01, // “ã (U+201C U+00E3)
  0x20, 0x1C, 0x00, 0xE4, 0x01, // “ä (U+201C U+00E4)
  0x20, 0x1C, 0x00, 0xE5, 0x01, // “å (U+201C U+00E5)
  0x20, 0x1C, 0x00, 0xE6, 0x01, // “æ (U+201C U+00E6)
  0x20, 0x1C, 0x00, 0xE7, 0x01, // “ç (U+201C U+00E7)
  0x20, 0x1C, 0x00, 0xE8, 0x01, // “è (U+201C U+00E8)
  0x20, 0x1C, 0x00, 0xE9, 0x01, // “é (U+201C U+00E9)
  0x20, 0x1C, 0x00, 0xEA, 0x01, // “ê (U+201C U+00EA)
  0x20, 0x1C, 0x00, 0xEB, 0x01, // “ë (U+201C U+00EB)
  0x20, 0x1C, 0x00, 0xF2, 0x01, // “ò (U+201C U+00F2)
  0x20, 0x1C, 0x00, 0xF3, 0x01, // “ó (U+201C U+00F3)
  0x20, 0x1C, 0x00, 0xF4, 0x01, // “ô (U+201C U+00F4)
  0x20, 0x1C, 0x00, 0xF5, 0x01, // “õ (U+201C U+00F5)
  0x20, 0x1C, 0x00, 0xF6, 0x01, // “ö (U+201C U+00F6)
  0x20, 0x1C, 0x00, 0xF8, 0x01, // “ø (U+201C U+00F8)
  0x20, 0x1C, 0x01, 0x00, 0x01, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x01, 0x01, // “ā (U+201C U+0101)
  0x20, 0x1C, 0x01, 0x02, 0x01, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x03, 0x01, // “ă (U+201C U+0103)
  0x20, 0x1C, 0x01, 0x04, 0x01, // “Ą (U+201C U+0104)
  0x20, 0x1C, 0x01, 0x05, 0x01, // “ą (U+201C U+0105)
  0x20, 0x1C, 0x01, 0x07, 0x01, // “ć (U+201C U+0107)
  0x20, 0x1C, 0x01, 0x09, 0x01, // “ĉ (U+201C U+0109)
  0x20, 0x1C, 0x01, 0x0B, 0x01, // “ċ (U+201C U+010B)
  0x20, 0x1C, 0x01, 0x0D, 0x01, // “č (U+201C U+010D)
  0x20, 0x1C, 0x01, 0x0F, 0x01, // “ď (U+201C U+010F)
  0x20, 0x1C, 0x01, 0x11, 0x01, // “đ (U+201C U+0111)
  0x20, 0x1C, 0x01, 0x13, 0x01, // “ē (U+201C U+0113)
  0x20, 0x1C, 0x01, 0x15, 0x01, // “ĕ (U+201C U+0115)
  0x20, 0x1C, 0x01, 0x17, 0x01, // “ė (U+201C U+0117)
  0x20, 0x1C, 0x01, 0x19, 0x01, // “ę (U+201C U+0119)
  0x20, 0x1C, 0x01, 0x1B, 0x01, // “ě (U+201C U+011B)
  0x20, 0x1C, 0x01, 0x4D, 0x01, // “ō (U+201C U+014D)
  0x20, 0x1C, 0x01, 0x4F, 0x01, // “ŏ (U+201C U+014F)
  0x20, 0x1C, 0x01, 0x51, 0x01, // “ő (U+201C U+0151)
  0x20, 0x1C, 0x01, 0x53, 0x01, // “œ (U+201C U+0153)
  0x20, 0x1D, 0x00, 0x41, 0x01, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0x61, 0x01, // ”a (U+201D U+0061)
  0x20, 0x1D, 0x00, 0x63, 0x01, // ”c (U+201D U+0063)
  0x20, 0x1D, 0x00, 0x64, 0x01, // ”d (U+201D U+0064)
  0x20, 0x1D, 0x00, 0x65, 0x01, // ”e (U+201D U+0065)
  0x20, 0x1D, 0x00, 0x6F, 0x01, // ”o (U+201D U+006F)
  0x20, 0x1D, 0x00, 0x71, 0x01, // ”q (U+201D U+0071)
  0x20, 0x1D, 0x00, 0xC0, 0x01, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x01, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x01, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x01, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x01, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x01, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xE0, 0x01, // ”à (U+201D U+00E0)
  0x20, 0x1D, 0x00, 0xE1, 0x01, // ”á (U+201D U+00E1)
  0x20, 0x1D, 0x00, 0xE2, 0x01, // ”â (U+201D U+00E2)
  0x20, 0x1D, 0x00, 0xE3, 0x01, // ”ã (U+201D U+00E3)
  0x20, 0x1D, 0x00, 0xE4, 0x01, // ”ä (U+201D U+00E4)
  0x20, 0x1D, 0x00, 0xE5, 0x01, // ”å (U+201D U+00E5)
  0x20, 0x1D, 0x00, 0xE6, 0x01, // ”æ (U+201D U+00E6)
  0x20, 0x1D, 0x00, 0xE7, 0x01, // ”ç (U+201D U+00E7)
  0x20, 0x1D, 0x00, 0xE8, 0x01, // ”è (U+201D U+00E8)
  0x20, 0x1D, 0x00, 0xE9, 0x01, // ”é (U+201D U+00E9)
  0x20, 0x1D, 0x00, 0xEA, 0x01, // ”ê (U+201D U+00EA)
  0x20, 0x1D, 0x00, 0xEB, 0x01, // ”ë (U+201D U+00EB)
  0x20, 0x1D, 0x00, 0xF2, 0x01, // ”ò (U+201D U+00F2)
  0x20, 0x1D, 0x00, 0xF3, 0x01, // ”ó (U+201D U+00F3)
  0x20, 0x1D, 0x00, 0xF4, 0x01, // ”ô (U+201D U+00F4)
  0x20, 0x1D, 0x00, 0xF5, 0x01, // ”õ (U+201D U+00F5)
  0x20, 0x1D, 0x00, 0xF6, 0x01, // ”ö (U+201D U+00F6)
  0x20, 0x1D, 0x00, 0xF8, 0x01, // ”ø (U+201D U+00F8)
  0x20, 0x1D, 0x01, 0x00, 0x01, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x01, 0x01, // ”ā (U+201D U+0101)
  0x20, 0x1D, 0x01, 0x02, 0x01, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x03, 0x01, // ”ă (U+201D U+0103)
  0x20, 0x1D, 0x01, 0x04, 0x01, // ”Ą (U+201D U+0104)
  0x20, 0x1D, 0x01, 0x05, 0x01, // ”ą (U+201D U+0105)
  0x20, 0x1D, 0x01, 0x07, 0x01, // ”ć (U+201D U+0107)
  0x20, 0x1D, 0x01, 0x09, 0x01, // ”ĉ (U+201D U+0109)
  0x20, 0x1D, 0x01, 0x0B, 0x01, // ”ċ (U+201D U+010B)
  0x20, 0x1D, 0x01, 0x0D, 0x01, // ”č (U+201D U+010D)
  0x20, 0x1D, 0x01, 0x0F, 0x01, // ”ď (U+201D U+010F)
  0x20, 0x1D, 0x01, 0x11, 0x01, // ”đ (U+201D U+0111)
  0x20, 0x1D, 0x01, 0x13, 0x01, // ”ē (U+201D U+0113)
  0x20, 0x1D, 0x01, 0x15, 0x01, // ”ĕ (U+201D U+0115)
  0x20, 0x1D, 0x01, 0x17, 0x01, // ”ė (U+201D U+0117)
  0x20, 0x1D, 0x01, 0x19, 0x01, // ”ę (U+201D U+0119)
  0x20, 0x1D, 0x01, 0x1B, 0x01, // ”ě (U+201D U+011B)
  0x20, 0x1D, 0x01, 0x4D, 0x01, // ”ō (U+201D U+014D)
  0x20, 0x1D, 0x01, 0x4F, 0x01, // ”ŏ (U+201D U+014F)
  0x20, 0x1D, 0x01, 0x51, 0x01, // ”ő (U+201D U+0151)
  0x20, 0x1D, 0x01, 0x53, 0x01, // ”œ (U+201D U+0153)
  0x20, 0x1E, 0x00, 0x43, 0x01, // „C (U+201E U+0043)
  0x20, 0x1E, 0x00, 0x47, 0x01, // „G (U+201E U+0047)
  0x20, 0x1E, 0x00, 0x4F, 0x01, // „O (U+201E U+004F)
  0x20, 0x1E, 0x00, 0x51, 0x01, // „Q (U+201E U+0051)
  0x20, 0x1E, 0x00, 0x54, 0x01, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x56, 0x01, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x01, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x01, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0xC7, 0x01, // „Ç (U+201E U+00C7)
  0x20, 0x1E, 0x00, 0xD2, 0x01, // „Ò (U+201E U+00D2)
  0x20, 0x1E, 0x00, 0xD3, 0x01, // „Ó (U+201E U+00D3)
  0x20, 0x1E, 0x00, 0xD4, 0x01, // „Ô (U+201E U+00D4)
  0x20, 0x1E, 0x00, 0xD5, 0x01, // „Õ (U+201E U+00D5)
  0x20, 0x1E, 0x00, 0xD6, 0x01, // „Ö (U+201E U+00D6)
  0x20, 0x1E, 0x00, 0xD8, 0x01, // „Ø (U+201E U+00D8)
  0x20, 0x1E, 0x00, 0xDD, 0x01, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x01, 0x06, 0x01, // „Ć (U+201E U+0106)
  0x20, 0x1E, 0x01, 0x08, 0x01, // „Ĉ (U+201E U+0108)
  0x20, 0x1E, 0x01, 0x0A, 0x01, // „Ċ (U+201E U+010A)
  0x20, 0x1E, 0x01, 0x0C, 0x01, // „Č (U+201E U+010C)
  0x20, 0x1E, 0x01, 0x1C, 0x01, // „Ĝ (U+201E U+011C)
  0x20, 0x1E, 0x01, 0x1E, 0x01, // „Ğ (U+201E U+011E)
  0x20, 0x1E, 0x01, 0x20, 0x01, // „Ġ (U+201E U+0120)
  0x20, 0x1E, 0x01, 0x22, 0x01, // „Ģ (U+201E U+0122)
  0x20, 0x1E, 0x01, 0x4C, 0x01, // „Ō (U+201E U+014C)
  0x20, 0x1E, 0x01, 0x4E, 0x01, // „Ŏ (U+201E U+014E)
  0x20, 0x1E, 0x01, 0x50, 0x01, // „Ő (U+201E U+0150)
  0x20, 0x1E, 0x01, 0x52, 0x01, // „Œ (U+201E U+0152)
  0x20, 0x1E, 0x01, 0x62, 0x01, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x01, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x01, // „Ŧ (U+201E U+0166)
  0x20, 0x1E, 0x01, 0x74, 0x01, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x76, 0x01, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x78, 0x01, // „Ÿ (U+201E U+0178)
  0x20, 0x39, 0x00, 0x59, 0x01, // ‹Y (U+2039 U+0059)
  0x20, 0x39, 0x00, 0xDD, 0x01, // ‹Ý (U+2039 U+00DD)
  0x20, 0x39, 0x01, 0x76, 0x01, // ‹Ŷ (U+2039 U+0176)
  0x20, 0x39, 0x01, 0x78, 0x01, // ‹Ÿ (U+2039 U+0178)
  0x20, 0x3A, 0x00, 0x54, 0x01, // ›T (U+203A U+0054)
  0x20, 0x3A, 0x00, 0x59, 0x01, // ›Y (U+203A U+0059)
  0x20, 0x3A, 0x00, 0xDD, 0x01, // ›Ý (U+203A U+00DD)
  0x20, 0x3A, 0x01, 0x62, 0x01, // ›Ţ (U+203A U+0162)
  0x20, 0x3A, 0x01, 0x64, 0x01, // ›Ť (U+203A U+0164)
  0x20, 0x3A, 0x01, 0x66, 0x01, // ›Ŧ (U+203A U+0166)
  0x20, 0x3A, 0x01, 0x76, 0x01, // ›Ŷ (U+203A U+0176)
  0x20, 0x3A, 0x01, 0x78, 0x01, // ›Ÿ (U+203A U+0178)
  0x20, 0x44, 0x00, 0x30, 0x02, // ⁄0 (U+2044 U+0030)
  0x20, 0x44, 0x00, 0x31, 0x02, // ⁄1 (U+2044 U+0031)
  0x20, 0x44, 0x00, 0x32, 0x02, // ⁄2 (U+2044 U+0032)
  0x20, 0x44, 0x00, 0x33, 0x02, // ⁄3 (U+2044 U+0033)
  0x20, 0x44, 0x00, 0x34, 0x02, // ⁄4 (U+2044 U+0034)
  0x20, 0x44, 0x00, 0x35, 0x02, // ⁄5 (U+2044 U+0035)
  0x20, 0x44, 0x00, 0x36, 0x02, // ⁄6 (U+2044 U+0036)
  0x20, 0x44, 0x00, 0x37, 0x02, // ⁄7 (U+2044 U+0037)
  0x20, 0x44, 0x00, 0x38, 0x02, // ⁄8 (U+2044 U+0038)
  0x20, 0x44, 0x00, 0x39, 0x02, // ⁄9 (U+2044 U+0039)
  
  // Glyph data
  // "!" (U+0021)
  0x20, 0xA0, 0xB2, 0x87, 0xD7, 0x01, 0xF3, 0x04, 0xE2, 0x07, 0x0A, 0x20, 0xA0, 0x52, 0x0E, 0x01,
  0x50, 0x60, 0x92, 0x0A, 0x09, 0x20,
  // """ (U+0022)
  0x19, 0x89, 0x24, 0x99, 0x2E, 0x0C, 0x45, 0x90, 0xD1,
  // "#" (U+0023)
  0x38, 0x27, 0x70, 0xD4, 0x82, 0xD1, 0x68, 0x28, 0x5B, 0xEF, 0xEF, 0xE8, 0x28, 0x29, 0x51, 0xD4,
  0x82, 0xD1, 0x49, 0x38, 0x31, 0xD0, 0x85, 0x28, 0x94, 0xBE, 0xFE, 0xFE, 0x80, 0x1B, 0x53, 0xC1,
  0x38, 0x2D, 0x07, 0x73, 0x83, 0x59, 0x0C, 0x13,
  // "$" (U+0024)
  0x40, 0xB4, 0x89, 0x74, 0xAE, 0xA4, 0x03, 0xE6, 0x95, 0x30, 0x88, 0x54, 0x38, 0x26, 0xDA, 0x14,
  0x81, 0x8F, 0x64, 0x82, 0x1B, 0xE5, 0x38, 0x93, 0x46, 0x98, 0x04, 0x18, 0x3C, 0x50, 0x9A, 0x0D,
  0x07, 0x40, 0xB5, 0x01, 0x05, 0x40,
  // "%" (U+0025)
  0x28, 0x19, 0xE7, 0x20, 0x80, 0x72, 0x85, 0x6A, 0x3C, 0x03, 0xC3, 0x85, 0xC2, 0x3B, 0x0C, 0x33,
  0x84, 0xE0, 0x68, 0x69, 0x38, 0xA2, 0x1D, 0x1D, 0x4D, 0x3C, 0xC1, 0x0C, 0xF7, 0xA5, 0xC3, 0x96,
  0x38, 0x55, 0xA3, 0xB0, 0xA5, 0x38, 0x5D, 0x17, 0x70, 0xD1, 0x28, 0x59, 0x60, 0x88, 0x6A, 0x20,
  0x30, 0xC2, 0x82, 0x3E, 0xC1, 0x10,
  // "&" (U+0026)
  0x28, 0x21, 0xCF, 0xA4, 0x83, 0xB9, 0x2F, 0x23, 0x82, 0xE4, 0x1D, 0x48, 0x2B, 0x48, 0x34, 0x81,
  0xBD, 0x33, 0x8A, 0x01, 0xC6, 0xD6, 0x2E, 0x19, 0x90, 0x6D, 0x99, 0x0D, 0x52, 0x89, 0x0E, 0xD1,
  0x0C, 0x90, 0x6F, 0xD2, 0x85, 0x4D, 0xEA, 0x2E, 0x51,
  // "'" (U+0027)
  0x18, 0x5E, 0x52, 0xE0, 0x59, 0x10,
  // "(" (U+0028)
  0x30, 0x60, 0xA2, 0x81, 0x3D, 0x12, 0x0C, 0x05, 0x20, 0x50, 0xD3, 0x0C, 0x06, 0x28, 0x11, 0xF1,
  0x20, 0x50, 0xC3, 0x07, 0x0A, 0x30, 0x90, 0x83, 0x00, 0x83, 0x07, 0x0A, 0x30, 0x40, 0xC4, 0x0E,
  0x01, 0x20,
  // ")" (U+0029)
  0x20, 0x20, 0xD4, 0x0D, 0x02, 0x30, 0xB0, 0x53, 0x0A, 0x07, 0x30, 0xA0, 0x73, 0x0C, 0x06, 0x30,
  0xE0, 0x42, 0x03, 0x0E, 0x30, 0x70, 0xA3, 0x0D, 0x04, 0x20, 0x60, 0xB2, 0x81, 0x1D, 0x22, 0x0B,
  0x05, 0x30,
  // "*" (U+002A)
  0x20, 0x10, 0xE2, 0x82, 0x38, 0x3B, 0x28, 0x90, 0x27, 0xDE, 0xEA, 0x05, 0xCC, 0x38, 0x2C, 0x29,
  0x74, 0x02, 0x01, 0x10,
  // "+" (U+002B)
  0x30, 0xC0, 0x45, 0x0C, 0x04, 0x50, 0xC0, 0x42, 0x89, 0x43, 0xEE, 0xFE, 0xEA, 0x01, 0x1C, 0x51,
  0x13, 0x0C, 0x04, 0x50, 0xC0, 0x42,
  // "," (U+002C)
  0x18, 0x90, 0x27, 0x09, 0x90, 0xE2, 0x68, 0x10,
  // "-" (U+002D)
  0x82, 0x8E, 0xE9, 0x0F, 0x11,
  // "." (U+002E)
  0x82, 0x69, 0xA9,
  // "/" (U+002F)
  0x58, 0x13, 0xE1, 0x50, 0xC0, 0x65, 0x05, 0x0C, 0x60, 0xD0, 0x35, 0x08, 0x0A, 0x58, 0x12, 0xE1,
  0x50, 0xA0, 0x75, 0x04, 0x0D, 0x60, 0xC0, 0x55, 0x06, 0x0B, 0x60,
  // "0" (U+0030)
  0x28, 0x21, 0xBE, 0xA3, 0x86, 0xD8, 0x1D, 0x50, 0x6D, 0x28, 0x3B, 0x70, 0xC6, 0x28, 0x3C, 0x61,
  0xF2, 0x28, 0x2E, 0x45, 0xE2, 0x83, 0x2F, 0x17, 0xB2, 0x83, 0x6C, 0x07, 0xA2, 0x86, 0xC6, 0x05,
  0xD1, 0x8C, 0x38, 0x2A, 0xEB, 0x12,
  // "1" (U+0031)
  0x28, 0x93, 0x3D, 0x90, 0x6D, 0xE5, 0x1A, 0x3F, 0x22, 0x04, 0x0E, 0x30, 0x80, 0xA3, 0x0B, 0x07,
  0x39, 0x03, 0x20, 0x39, 0x30, 0x70, 0xC3, 0x0A, 0x08, 0x20,
  // "2" (U+0032)
  0x38, 0x27, 0xEE, 0xA4, 0x83, 0x92, 0x2E, 0x66, 0x0C, 0x06, 0x58, 0x11, 0xF2, 0x50, 0xB0, 0x95,
  0x09, 0x0B, 0x50, 0x80, 0xC5, 0x81, 0x8C, 0x14, 0x81, 0x8C, 0x14, 0x03, 0xD2,
  // "3" (U+0033)
  0x18, 0x31, 0x8D, 0xEA, 0x38, 0x37, 0x11, 0xE6, 0x50, 0xC0, 0x63, 0x81, 0x18, 0xC3, 0x81, 0xDF,
  0x94, 0x82, 0x15, 0xE3, 0x50, 0xB0, 0x85, 0x89, 0x5D, 0x60, 0x51, 0x18, 0xE1, 0x0B, 0xEE, 0xB2,
  0x20,
  // "4" (U+0034)
  0x48, 0x13, 0xF6, 0x48, 0x1C, 0xF3, 0x30, 0x09, 0x93, 0x82, 0x5B, 0x6C, 0x28, 0x31, 0xD1, 0x98,
  0x28, 0xB0, 0xB4, 0x0D, 0x50, 0x79, 0x01, 0xF1, 0x0F, 0xEE, 0xEF, 0xE1, 0x11, 0x19, 0xA1, 0x40,
  0xC0, 0x52,
  // "5" (U+0035)
  0x20, 0xAB, 0x07, 0x20, 0xE0, 0x24, 0x05, 0x0B, 0x58, 0x2A, 0xED, 0x93, 0x83, 0x32, 0x3E, 0x85,
  0x08, 0x0B, 0x50, 0x80, 0xA5, 0x86, 0xC7, 0x06, 0x11, 0x8E, 0x28, 0x3B, 0xEE, 0xB2, 0x20,
  // "6" (U+0036)
  0x38, 0x25, 0xCF, 0xA2, 0x87, 0x6C, 0x30, 0x10, 0x3D, 0x14, 0x83, 0xA9, 0xCD, 0x42, 0x89, 0x5E,
  0xA2, 0x9D, 0x03, 0xF1, 0x04, 0xF0, 0x5C, 0x28, 0x35, 0xD0, 0x6B, 0x28, 0x79, 0x90, 0x4E, 0x24,
  0xF2, 0x28, 0x29, 0xED, 0x52,
  // "7" (U+0037)
  0x10, 0x6D, 0x50, 0xA0, 0x94, 0x81, 0x3E, 0x14, 0x0B, 0x07, 0x40, 0x40, 0xE5, 0x0C, 0x06, 0x40,
  0x60, 0xD5, 0x0D, 0x05, 0x40, 0x70, 0xC4, 0x81, 0x1E, 0x34,
  // "8" (U+0038)
  0x28, 0x95, 0x4D, 0xFB, 0x10, 0x2F, 0x51, 0xC9, 0x05, 0xD2, 0x87, 0x98, 0x02, 0xE0, 0x1D, 0x22,
  0x82, 0x9A, 0xA2, 0x28, 0x68, 0xC8, 0xE2, 0x07, 0xB2, 0x83, 0xA9, 0x0C, 0x62, 0x89, 0x58, 0xB0,
  0xBA, 0x13, 0xE6, 0x02, 0xBE, 0xD7, 0x20,
  // "9" (U+0039)
  0x28, 0x25, 0xDE, 0x92, 0x87, 0x4E, 0x32, 0xE3, 0x0B, 0x72, 0x83, 0xC6, 0x0E, 0x32, 0x89, 0x5E,
  0x50, 0xE5, 0x08, 0xF3, 0x07, 0xFE, 0x9E, 0x50, 0x90, 0xA4, 0x87, 0x2E, 0x20, 0x21, 0x3D, 0x72,
  0x82, 0xBF, 0xD6, 0x30,
  // ":" (U+003A)
  0x18, 0x35, 0xE0, 0x6A, 0x75, 0x83, 0x78, 0x0B, 0x81,
  // ";" (U+003B)
  0x28, 0x14, 0xE1, 0x20, 0x50, 0xB7, 0x77, 0x10, 0x50, 0x93, 0x0B, 0x07, 0x20, 0x20, 0xE3, 0x07,
  0x05, 0x30,
  // "<" (U+003C)
  0x50, 0x20, 0x73, 0x87, 0x2A, 0xE6, 0x01, 0x9E, 0x72, 0x81, 0x3F, 0x95, 0x82, 0x7D, 0x92, 0x58,
  0x27, 0xEA, 0x25, 0x07, 0x0A,
  // "=" (U+003D)
  0x03, 0x80, 0x1E, 0x09, 0x18, 0x02, 0x17, 0x03, 0x80, 0x1E, 0x09, 0x18, 0x02, 0x10,
  // ">" (U+003E)
  0x03, 0x06, 0x58, 0x21, 0xBD, 0x55, 0x82, 0x3B, 0xC5, 0x58, 0x14, 0xEA, 0x38, 0x76, 0xDA, 0x20,
  0x6D, 0xA3, 0x28, 0x14, 0xB3, 0x40,
  // "?" (U+003F)
  0x18, 0x91, 0x5C, 0xEC, 0x10, 0x32, 0x1D, 0x74, 0x0C, 0x05, 0x30, 0x60, 0xC3, 0x81, 0x6C, 0x12,
  0x81, 0x3D, 0x13, 0x09, 0x05, 0x72, 0x81, 0x2C, 0x13, 0x05, 0x0D, 0x40,
  // "@" (U+0040)
  0x38, 0x41, 0x9D, 0xFD, 0x53, 0x86, 0x2D, 0x72, 0x04, 0xD3, 0x28, 0xF2, 0xC3, 0x5E, 0xE5, 0x59,
  0x08, 0x74, 0xC1, 0xB3, 0x3A, 0x0D, 0x0B, 0x30, 0xE0, 0x59, 0x4A, 0x0E, 0x05, 0xA0, 0x95, 0x67,
  0x2D, 0x0B, 0x83, 0xD0, 0x77, 0x0D, 0xE4, 0xEE, 0x30, 0x5A, 0x72, 0x0D, 0x06, 0x20, 0x10, 0x24,
  0x84, 0x2B, 0xFE, 0xC3, 0x30,
  // "A" (U+0041)
  0x48, 0x14, 0xF7, 0x48, 0x1C, 0xD7, 0x38, 0x24, 0xD9, 0x83, 0x82, 0xB7, 0x89, 0x28, 0x34, 0xF1,
  0x89, 0x28, 0x5B, 0x90, 0x8A, 0x03, 0xA8, 0x93, 0xEF, 0xB0, 0xBB, 0x22, 0x8B, 0x3F, 0x32, 0x82,
  0x7C, 0xAA, 0x30, 0x60, 0xD0,
  // "B" (U+0042)
  0x20, 0xAA, 0x0D, 0x07, 0x38, 0x97, 0xD5, 0x06, 0xF2, 0x01, 0xF1, 0x02, 0xF2, 0x05, 0xD2, 0x0A,
  0x0B, 0x28, 0x39, 0xFE, 0xF9, 0x38, 0x4C, 0x71, 0x5F, 0x22, 0x90, 0x32, 0x83, 0xD6, 0x03, 0xE3,
  0x98, 0x64, 0x07, 0xB0, 0x1A, 0xD2, 0x0A, 0xA8, 0x1E, 0xA1, 0x20,
  // "C" (U+0043)
  0x38, 0x35, 0xCF, 0xD5, 0x28, 0x90, 0x6E, 0x50, 0x31, 0x02, 0xF4, 0x50, 0x90, 0xB6, 0x0E, 0x05,
  0x58, 0x12, 0xF1, 0x50, 0x49, 0x68, 0x13, 0xF1, 0x68, 0x3D, 0x91, 0x12, 0x38, 0x33, 0xCF, 0xD5,
  0x20,
  // "D" (U+0044)
  0x20, 0xAA, 0x0C, 0x05, 0x38, 0x90, 0xD5, 0x06, 0xF2, 0x01, 0xF2, 0x28, 0x3D, 0x70, 0x5E, 0x38,
  0x3B, 0x80, 0x9A, 0x38, 0x3D, 0x70, 0xC6, 0x39, 0x82, 0x40, 0xF3, 0x28, 0x25, 0xE0, 0x39, 0x28,
  0x90, 0x1D, 0x60, 0x7B, 0x03, 0xCA, 0x20, 0xAA, 0x0C, 0x06, 0x30,
  // "E" (U+0045)
  0x20, 0xAB, 0x0A, 0x20, 0xD0, 0x54, 0x81, 0x1F, 0x14, 0x05, 0x0D, 0x58, 0x39, 0xFE, 0xE7, 0x28,
  0x2C, 0x61, 0x13, 0x90, 0x24, 0x03, 0x0E, 0x50, 0x70, 0xB5, 0x0A, 0xB0, 0xA2,
  // "F" (U+0046)
  0x20, 0xAB, 0x0A, 0x20, 0xD0, 0x54, 0x81, 0x1F, 0x14, 0x05, 0x0C, 0x58, 0x39, 0xFE, 0xE6, 0x28,
  0x2C, 0x51, 0x13, 0x90, 0x14, 0x03, 0x0E, 0x50, 0x70, 0xB5, 0x0A, 0x08, 0x50,
  // "G" (U+0047)
  0x38, 0x44, 0xBE, 0xEB, 0x22, 0x84, 0x6E, 0x61, 0x15, 0x28, 0x12, 0xF4, 0x60, 0xA0, 0xB7, 0x98,
  0x90, 0x50, 0x3E, 0xE7, 0x03, 0xF1, 0x28, 0x31, 0xE5, 0x04, 0x93, 0x85, 0x1F, 0x10, 0x2F, 0x12,
  0x04, 0x0E, 0x38, 0x4D, 0xA1, 0x19, 0xA3, 0x84, 0x2B, 0xEE, 0xC4, 0x20,
  // "H" (U+0048)
  0x20, 0xA0, 0x83, 0x0E, 0x04, 0x20, 0xD0, 0x52, 0x03, 0x92, 0x81, 0x1F, 0x12, 0x07, 0x0C, 0x20,
  0x50, 0xD3, 0x0A, 0x09, 0x28, 0x58, 0xFE, 0xEE, 0xF5, 0x28, 0x5C, 0x72, 0x24, 0xF2, 0x29, 0x02,
  0x20, 0x50, 0xE2, 0x03, 0x0E, 0x30, 0x90, 0xA2, 0x07, 0x0B, 0x30, 0xC0, 0x72, 0x0A, 0x08, 0x39,
  0x03, 0x20,
  // "I" (U+0049)
  0x28, 0x34, 0xEF, 0xB1, 0x30, 0x80, 0xA5, 0x0B, 0x07, 0x59, 0x03, 0x40, 0x39, 0x50, 0x70, 0xC5,
  0x0A, 0x08, 0x50, 0xD0, 0x54, 0x81, 0x1F, 0x13, 0x82, 0x5D, 0xFB, 0x30,
  // "J" (U+004A)
  0x50, 0xA0, 0x95, 0x0D, 0x05, 0x48, 0x11, 0xF2, 0x40, 0x40, 0xE5, 0x08, 0x0B, 0x50, 0xB0, 0x75,
  0x0E, 0x04, 0x48, 0x12, 0xF1, 0x40, 0x60, 0xD5, 0x00, 0x95, 0x0D, 0x05, 0x48, 0x14, 0xF1, 0x28,
  0x22, 0xFE, 0x54, 0x01, 0x50,
  // "K" (U+004B)
  0x20, 0xA0, 0x82, 0x0B, 0x09, 0x28, 0x3D, 0x50, 0x9B, 0x28, 0x41, 0xF1, 0x7D, 0x12, 0x83, 0x5D,
  0x5E, 0x23, 0x82, 0x9C, 0xE6, 0x48, 0x2C, 0xDC, 0x84, 0x98, 0x13, 0x6D, 0x38, 0x43, 0xF0, 0x2F,
  0x22, 0x07, 0x0B, 0x20, 0xD0, 0x62, 0x0A, 0x08, 0x20, 0x90, 0xB2,
  // "L" (U+004C)
  0x20, 0xA0, 0x83, 0x0D, 0x05, 0x28, 0x11, 0xF1, 0x20, 0x50, 0xD3, 0x09, 0x0A, 0x30, 0xC0, 0x63,
  0x90, 0x32, 0x03, 0x0E, 0x38, 0x47, 0xC1, 0x11, 0xAB, 0x09,
  // "M" (U+004D)
  0x28, 0x1A, 0xF3, 0x38, 0x15, 0xFB, 0x28, 0x1D, 0xF4, 0x38, 0x6C, 0xF7, 0x01, 0xFC, 0x52, 0x87,
  0x5C, 0xE4, 0x05, 0xDA, 0x62, 0x0D, 0x07, 0x92, 0x0F, 0x98, 0x47, 0x05, 0xC6, 0xC2, 0x87, 0xC5,
  0x88, 0x0D, 0x4A, 0x92, 0x98, 0xB3, 0x27, 0x96, 0xB0, 0xD5, 0x03, 0xE0, 0x6A, 0xD3, 0x1F, 0x10,
  0x7A, 0x05, 0xFB, 0x05, 0xD2, 0x87, 0xA7, 0x04, 0xF3, 0x08, 0xA2,
  // "N" (U+004E)
  0x20, 0xA9, 0x30, 0x70, 0xB2, 0x81, 0xDF, 0x32, 0x85, 0xA7, 0x01, 0xFA, 0x72, 0x87, 0xE4, 0x05,
  0xC6, 0xB0, 0x29, 0x28, 0x59, 0x92, 0xE0, 0x6C, 0x28, 0x5C, 0x50, 0xE3, 0x99, 0x29, 0x87, 0x20,
  0xA7, 0xC5, 0x03, 0xE2, 0x85, 0x7B, 0xF1, 0x07, 0xA2, 0x81, 0x3F, 0xD2, 0x0A, 0x07, 0x30, 0xE0,
  0xA2,
  // "O" (U+004F)
  0x38, 0x36, 0xDE, 0xC2, 0x38, 0x48, 0xD3, 0x1A, 0xC2, 0x81, 0x2F, 0x22, 0x84, 0x3F, 0x10, 0xAA,
  0x38, 0x42, 0xF1, 0x0E, 0x53, 0x84, 0x4F, 0x02, 0xF2, 0x38, 0x27, 0xC0, 0x49, 0x48, 0x4C, 0x70,
  0x3F, 0x12, 0x81, 0x5E, 0x12, 0x84, 0xE8, 0x04, 0xE6, 0x38, 0x34, 0xCF, 0xD5, 0x30,
  // "P" (U+0050)
  0x20, 0xAA, 0x0C, 0x03, 0x28, 0x95, 0xD5, 0x1A, 0xC0, 0x1F, 0x10, 0x5E, 0x05, 0xD2, 0x89, 0x58,
  0xC0, 0x9A, 0x04, 0xE5, 0x0C, 0xEF, 0xD6, 0x29, 0x04, 0x40, 0x39, 0x50, 0x70, 0xB5, 0x0A, 0x08,
  0x50,
  // "Q" (U+0051)
  0x38, 0x36, 0xDE, 0xB2, 0x38, 0x47, 0xD3, 0x1A, 0xC2, 0x81, 0x2F, 0x22, 0x84, 0x3F, 0x10, 0xAA,
  0x38, 0x42, 0xF1, 0x0E, 0x53, 0x84, 0x4F, 0x02, 0xF2, 0x38, 0x27, 0xC0, 0x49, 0x48, 0x4C, 0x70,
  0x3F, 0x12, 0x81, 0x4E, 0x12, 0x84, 0xE8, 0x04, 0xE6, 0x30, 0x40, 0xDA, 0x06, 0x68, 0x13, 0xF2,
  0x70, 0xC0, 0x97, 0x04, 0x07, 0x30,
  // "R" (U+0052)
  0x20, 0xAA, 0x0C, 0x02, 0x28, 0x95, 0xD5, 0x1A, 0xC0, 0x1F, 0x20, 0x5E, 0x05, 0xE2, 0x89, 0x57,
  0xC0, 0x9B, 0x03, 0xE6, 0x0C, 0xFE, 0xE6, 0x29, 0x81, 0x57, 0xD2, 0x87, 0x3F, 0x02, 0xF2, 0x07,
  0xC2, 0x83, 0xD6, 0x0A, 0x82, 0x09, 0x0B, 0x10,
  // "S" (U+0053)
  0x38, 0x37, 0xDF, 0xD5, 0x28, 0x46, 0xE3, 0x04, 0x22, 0x0A, 0x09, 0x60, 0x90, 0xC6, 0x82, 0x2E,
  0xB1, 0x58, 0x11, 0xDC, 0x68, 0x12, 0xF4, 0x69, 0x04, 0x28, 0x93, 0x51, 0x18, 0xE1, 0x01, 0xCE,
  0xEB, 0x22,
  // "T" (U+0054)
  0x09, 0xC0, 0xE2, 0x0B, 0x08, 0x40, 0xE0, 0x53, 0x81, 0x2F, 0x13, 0x05, 0x0D, 0x40, 0x09, 0x40,
  0xD0, 0x63, 0x81, 0x1F, 0x23, 0x04, 0x0E, 0x40, 0x70, 0xB4,
  // "U" (U+0055)
  0x20, 0xB0, 0x73, 0x90, 0x32, 0x0E, 0x03, 0x20, 0x40, 0xE2, 0x03, 0x93, 0x07, 0x0B, 0x20, 0x60,
  0xC3, 0x0B, 0x07, 0x20, 0xA0, 0x83, 0x0E, 0x04, 0x20, 0xE0, 0x42, 0x03, 0x92, 0x81, 0x2F, 0x12,
  0x07, 0x0C, 0x20, 0x49, 0x30, 0xC0, 0x72, 0x85, 0x2F, 0x52, 0x7E, 0x13, 0x83, 0x6D, 0xFC, 0x33,
  // "V" (U+0056)
  0x0A, 0x09, 0x38, 0x29, 0xB9, 0x92, 0x83, 0x1F, 0x49, 0x92, 0x83, 0x8C, 0x08, 0xA2, 0x86, 0xE4,
  0x08, 0xA0, 0x7C, 0x28, 0x37, 0xB0, 0xE4, 0x28, 0x26, 0xB6, 0xC3, 0x82, 0x6B, 0xD5, 0x38, 0x15,
  0xEC, 0x48, 0x14, 0xF5, 0x40,
  // "W" (U+0057)
  0x00, 0x92, 0x81, 0x2F, 0x32, 0x82, 0x9A, 0x99, 0x28, 0x19, 0xF3, 0x28, 0xB7, 0xE3, 0x98, 0x01,
  0xED, 0x30, 0x6C, 0x09, 0x80, 0x79, 0xC3, 0x0D, 0x50, 0x98, 0x0D, 0x2C, 0x34, 0xE2, 0x87, 0x98,
  0x5B, 0x0D, 0x3B, 0x72, 0x87, 0x98, 0xC4, 0x0D, 0x5E, 0x12, 0x81, 0xAA, 0xD2, 0x81, 0xDA, 0x93,
  0x81, 0xAF, 0x62, 0x81, 0xDF, 0x23, 0x0A, 0x0E, 0x30, 0xD0, 0xB4,
  // "X" (U+0058)
  0x20, 0x49, 0x28, 0x14, 0xE1, 0x39, 0x82, 0x30, 0xD5, 0x48, 0x2C, 0x68, 0xA5, 0x82, 0x8C, 0xE1,
  0x58, 0x15, 0xF5, 0x68, 0x1C, 0xF4, 0x58, 0x27, 0xCB, 0x74, 0x83, 0x2E, 0x28, 0xA4, 0x83, 0xC7,
  0x05, 0xE3, 0x08, 0x0C, 0x28, 0x12, 0xF2, 0x20,
  // "Y" (U+0059)
  0x00, 0x92, 0x83, 0x4E, 0x16, 0xC2, 0x86, 0xD6, 0x04, 0xE0, 0x7C, 0x28, 0x31, 0xF2, 0xE3, 0x38,
  0x1E, 0xC9, 0x48, 0x1C, 0xE1, 0x40, 0xB0, 0x75, 0x90, 0x44, 0x03, 0x95, 0x07, 0x0C, 0x50,
  // "Z" (U+005A)
  0x20, 0x3C, 0x09, 0x58, 0x14, 0xF2, 0x50, 0xD0, 0x75, 0x08, 0x0C, 0x58, 0x13, 0xF2, 0x50, 0xD0,
  0x75, 0x08, 0x0C, 0x58, 0x13, 0xF2, 0x50, 0xD0, 0x75, 0x05, 0xC0, 0xB2,
  // "[" (U+005B)
  0x30, 0x9A, 0x03, 0x30, 0xD0, 0x45, 0x90, 0x14, 0x04, 0x0D, 0x50, 0x70, 0x95, 0x0A, 0x06, 0x50,
  0xE0, 0x34, 0x01, 0x95, 0x05, 0x0C, 0x50, 0x08, 0x50, 0xB0, 0x55, 0x90, 0x24, 0x82, 0x3F, 0xE9,
  0x40, 0x01, 0x40,
  // "\" (U+005C)
  0x85, 0x6B, 0x03, 0xD0, 0x19, 0x28, 0xA1, 0xE2, 0x0C, 0x40, 0xA6, 0x08, 0x90, 0x6B, 0x04, 0xD0,
  0x19,
  // "]" (U+005D)
  0x20, 0x5A, 0x08, 0x40, 0xC0, 0x44, 0x90, 0x13, 0x03, 0x0D, 0x40, 0x70, 0xA4, 0x0A, 0x07, 0x40,
  0xD0, 0x33, 0x01, 0x94, 0x04, 0x0C, 0x40, 0x80, 0x94, 0x0B, 0x05, 0x40, 0xE0, 0x22, 0x81, 0xCE,
  0xE3, 0x0F, 0x13,
  // "^" (U+005E)
  0x30, 0x09, 0x48, 0x13, 0xDE, 0x48, 0x2B, 0x5C, 0x52, 0x83, 0x4C, 0x06, 0xA2, 0x86, 0xD4, 0x01,
  0xE0, 0x6B, 0x30, 0xB0, 0x50,
  // "_" (U+005F)
  0x84, 0x3E, 0xEE, 0xEA, 0x18, 0x00, 0x11,
  // "`" (U+0060)
  0x83, 0x33, 0x06, 0xC2, 0x0C, 0x03,
  // "a" (U+0061)
  0x28, 0x95, 0x6E, 0xD5, 0xC0, 0x5E, 0x33, 0xE8, 0x0D, 0x62, 0x98, 0x90, 0x53, 0xF1, 0x01, 0xF2,
  0x6D, 0x28, 0x35, 0xE0, 0x7B, 0x28, 0x96, 0xBA, 0x06, 0xD1, 0x7E, 0x70, 0x1C, 0xE7, 0xB4, 0x10,
  // "b" (U+0062)
  0x20, 0x09, 0x50, 0xC0, 0x65, 0x90, 0x24, 0x89, 0x63, 0xE6, 0xEC, 0x10, 0x7E, 0x71, 0xD6, 0x0A,
  0xB2, 0x83, 0xB8, 0x0D, 0x42, 0x81, 0xD6, 0x19, 0x28, 0x31, 0xF3, 0x5E, 0x28, 0x95, 0x7D, 0x08,
  0xF3, 0x3E, 0x50, 0xB5, 0xDE, 0x62,
  // "c" (U+0063)
  0x28, 0x93, 0x6D, 0xE7, 0x05, 0xE3, 0x11, 0x0D, 0x53, 0x03, 0x0E, 0x40, 0x60, 0xC4, 0x07, 0x0B,
  0x48, 0x35, 0xE2, 0x12, 0x28, 0x2A, 0xED, 0x31,
  // "d" (U+0064)
  0x60, 0xB0, 0x76, 0x0E, 0x04, 0x50, 0x29, 0x38, 0x36, 0xED, 0x7C, 0x28, 0x45, 0xE3, 0x2F, 0x92,
  0x0D, 0x06, 0x28, 0x93, 0xE5, 0x02, 0xF1, 0x01, 0xF2, 0x06, 0xC2, 0x05, 0x0E, 0x20, 0x70, 0xB2,
  0x00, 0xB2, 0x84, 0x6D, 0x17, 0xE7, 0x28, 0x41, 0xCE, 0x6B, 0x42,
  // "e" (U+0065)
  0x28, 0xA6, 0x6D, 0xE7, 0x05, 0xC2, 0x5D, 0x0D, 0x31, 0xAA, 0x4F, 0xEE, 0x80, 0x7B, 0x40, 0x70,
  0xB4, 0x83, 0x5E, 0x31, 0x42, 0x82, 0x9E, 0xE8, 0x10,
  // "f" (U+0066)
  0x48, 0x21, 0xBF, 0x64, 0x81, 0x8A, 0x15, 0x0D, 0x04, 0x40, 0x10, 0xBA, 0x05, 0x40, 0x50, 0xD6,
  0x00, 0x96, 0x0C, 0x06, 0x69, 0x02, 0x50, 0x40, 0xE6, 0x07, 0x0B, 0x60, 0xB0, 0x76, 0x0E, 0x03,
  0x50, 0x50, 0xE5, 0x81, 0xBE, 0x45,
  // "g" (U+0067)
  0x38, 0x36, 0xED, 0x5C, 0x28, 0x45, 0xE3, 0x3E, 0x82, 0x0D, 0x06, 0x29, 0x89, 0x25, 0x02, 0xF1,
  0x01, 0xF1, 0x06, 0xC2, 0x05, 0x0D, 0x20, 0x70, 0xB2, 0x0B, 0x0A, 0x28, 0x46, 0xD1, 0x7F, 0x62,
  0x84, 0x1C, 0xE7, 0xE3, 0x50, 0x30, 0xE3, 0x83, 0x30, 0x2C, 0x72, 0x83, 0x1C, 0xED, 0x83,
  // "h" (U+0068)
  0x20, 0x09, 0x50, 0xC0, 0x65, 0x90, 0x24, 0x89, 0x63, 0xE7, 0xEC, 0x10, 0x7E, 0x61, 0xE5, 0x0A,
  0xA2, 0x8A, 0x0E, 0x40, 0xD5, 0x02, 0xF1, 0x1F, 0x10, 0x5D, 0x05, 0xD2, 0x83, 0x89, 0x08, 0xA2,
  0x83, 0xC6, 0x0B, 0x62, 0x90, 0x31,
  // "i" (U+0069)
  0x20, 0x90, 0x67, 0x20, 0x40, 0xE2, 0x07, 0x0A, 0x20, 0xB0, 0x72, 0x87, 0xE4, 0x02, 0xF1, 0x05,
  0xD2, 0x08, 0x09, 0x20, 0xB0, 0x62,
  // "j" (U+006A)
  0x40, 0x90, 0x67, 0x71, 0x04, 0x0E, 0x40, 0x70, 0xA4, 0x0B, 0x07, 0x40, 0xE0, 0x33, 0x02, 0x94,
  0x06, 0x0C, 0x40, 0x90, 0x84, 0x0D, 0x05, 0x38, 0x11, 0xF1, 0x30, 0x70, 0xC3, 0x81, 0xDD, 0x33,
  // "k" (U+006B)
  0x20, 0x80, 0x95, 0x0C, 0x06, 0x59, 0x02, 0x48, 0x92, 0x3E, 0x02, 0xE3, 0x06, 0xB1, 0xD5, 0x28,
  0x2A, 0x7B, 0x83, 0x0D, 0x0C, 0x93, 0x83, 0x1F, 0x9F, 0x32, 0x83, 0x5D, 0x0C, 0x72, 0x83, 0x89,
  0x08, 0xB2, 0x83, 0xB6, 0x04, 0xE2,
  // "l" (U+006C)
  0x20, 0x80, 0x92, 0x0C, 0x06, 0x29, 0x82, 0x30, 0x3E, 0x20, 0x60, 0xB2, 0x0A, 0x08, 0x28, 0x7D,
  0x40, 0x1F, 0x10, 0x5D, 0x20, 0x80, 0x92, 0x0B, 0x06, 0x20,
  // "m" (U+006D)
  0x18, 0xA4, 0x4B, 0x7E, 0xB2, 0xCE, 0x60, 0x7E, 0x52, 0xFC, 0x28, 0xC0, 0xBA, 0x29, 0x89, 0x04,
  0x07, 0xB0, 0xE5, 0x04, 0xE2, 0x86, 0xA8, 0x2F, 0x10, 0x7B, 0x28, 0x2E, 0x45, 0xD2, 0x86, 0xA7,
  0x01, 0xF1, 0x8A, 0x28, 0x95, 0xE4, 0x05, 0xD0, 0xB6, 0x01, 0xF1, 0x08, 0xA1,
  // "n" (U+006E)
  0x18, 0x96, 0x4B, 0x7E, 0xC1, 0x07, 0xE6, 0x1E, 0x50, 0xBA, 0x28, 0xA0, 0xE4, 0x0E, 0x50, 0x2F,
  0x12, 0xF1, 0x05, 0xD0, 0x5D, 0x28, 0x39, 0xA0, 0x9A, 0x28, 0x3C, 0x60, 0xC6, 0x29, 0x03, 0x10,
  // "o" (U+006F)
  0x28, 0x26, 0xEE, 0x72, 0x87, 0x5E, 0x23, 0xF2, 0x0D, 0x52, 0x82, 0xE4, 0x3E, 0x39, 0x81, 0x36,
  0xC2, 0x83, 0x3F, 0x17, 0xB2, 0x87, 0x8A, 0x05, 0xE1, 0x4E, 0x32, 0x82, 0x9E, 0xD4, 0x20,
  // "p" (U+0070)
  0x28, 0x44, 0xB6, 0xEC, 0x12, 0x84, 0x7E, 0x71, 0xD6, 0x20, 0x0B, 0x20, 0xB0, 0x72, 0x0E, 0x05,
  0x28, 0x92, 0xC6, 0x02, 0xF1, 0x01, 0xF3, 0x05, 0x92, 0x06, 0x0D, 0x28, 0x49, 0xF3, 0x3E, 0x52,
  0x83, 0xC7, 0xDE, 0x63, 0x90, 0x25, 0x04, 0x0E, 0x60, 0x70, 0xA6,
  // "q" (U+0071)
  0x28, 0x95, 0x7E, 0xD6, 0xC0, 0x5E, 0x33, 0xF8, 0x0D, 0x62, 0x98, 0x90, 0x53, 0xF1, 0x01, 0xF1,
  0x6C, 0x28, 0x35, 0xD0, 0x7B, 0x28, 0x96, 0xBA, 0x06, 0xD1, 0x7E, 0x60, 0x1C, 0xE7, 0xE3, 0x40,
  0x30, 0xE5, 0x06, 0x0B, 0x50, 0xA0, 0x82,
  // "r" (U+0072)
  0x18, 0x90, 0x4B, 0x8F, 0x20, 0x7E, 0x61, 0x20, 0xB0, 0xA4, 0x0E, 0x05, 0x38, 0x12, 0xF1, 0x30,
  0x50, 0xD4, 0x08, 0x0A, 0x40, 0xB0, 0x64,
  // "s" (U+0073)
  0x18, 0x90, 0x4D, 0xEC, 0x10, 0xE6, 0x14, 0x29, 0x03, 0x48, 0x19, 0xD2, 0x48, 0x19, 0xD1, 0x49,
  0x89, 0x24, 0x04, 0x04, 0xF2, 0x0C, 0xFD, 0x62,
  // "t" (U+0074)
  0x20, 0x80, 0x53, 0x83, 0xE2, 0x01, 0xDA, 0x82, 0x50, 0x7B, 0x30, 0xA0, 0x73, 0x0E, 0x04, 0x28,
  0x12, 0xF1, 0x20, 0x50, 0xD3, 0x81, 0x7C, 0x12, 0x81, 0x3E, 0xE2,
  // "u" (U+0075)
  0x10, 0x50, 0xD2, 0x83, 0x8A, 0x08, 0xA2, 0x83, 0xB6, 0x0B, 0x72, 0x98, 0x73, 0x0E, 0x30, 0x3F,
  0x03, 0x92, 0x83, 0x7C, 0x06, 0xC2, 0x89, 0x6C, 0x90, 0x7D, 0x18, 0xE5, 0x02, 0xDE, 0x5D, 0x21,
  // "v" (U+0076)
  0x02, 0x92, 0x87, 0x2F, 0x21, 0xF1, 0x08, 0xA2, 0x98, 0x21, 0x1E, 0x32, 0x98, 0x12, 0x7B, 0x38,
  0x2E, 0x2D, 0x33, 0x81, 0xE7, 0xC4, 0x81, 0xDD, 0x44, 0x0C, 0x0D, 0x40,
  // "w" (U+0077)
  0x84, 0x1F, 0x10, 0x9E, 0x28, 0xC6, 0xC6, 0x1F, 0x11, 0xEE, 0x03, 0xE0, 0x1F, 0x17, 0x9E, 0x09,
  0x80, 0x1F, 0x1D, 0x3D, 0x0E, 0x20, 0x1F, 0x5B, 0x1D, 0x6B, 0x28, 0x61, 0xFA, 0x52, 0xDC, 0x42,
  0x85, 0x1F, 0xD0, 0x2E, 0xD3, 0x85, 0x1F, 0x70, 0x2F, 0x73,
  // "x" (U+0078)
  0x28, 0x4B, 0x80, 0x5D, 0x12, 0x83, 0x7B, 0x1E, 0x43, 0x82, 0x2F, 0xA8, 0x50, 0xE0, 0xC5, 0x81,
  0x3F, 0xB5, 0x0D, 0x07, 0x94, 0x83, 0x9A, 0x0E, 0x42, 0x84, 0x4E, 0x10, 0xA8, 0x20,
  // "y" (U+0079)
  0x28, 0x51, 0xF1, 0x01, 0xF2, 0x39, 0x82, 0x20, 0x8A, 0x48, 0x3E, 0x31, 0xE3, 0x48, 0x2D, 0x37,
  0xA5, 0x82, 0xC4, 0xE3, 0x58, 0x1B, 0xAA, 0x68, 0x1A, 0xF3, 0x60, 0x0A, 0x68, 0x11, 0xE3, 0x60,
  0xA0, 0x95, 0x81, 0x5F, 0xB6,
  // "z" (U+007A)
  0x20, 0xAB, 0x02, 0x40, 0x90, 0xA4, 0x81, 0x3E, 0x14, 0x0D, 0x05, 0x40, 0x80, 0xB4, 0x81, 0x2E,
  0x24, 0x0C, 0x07, 0x40, 0x5B, 0x0C, 0x20,
  // "{" (U+007B)
  0x38, 0x13, 0xCB, 0x30, 0xD0, 0x73, 0x02, 0x94, 0x05, 0x0C, 0x40, 0x09, 0x38, 0x12, 0xE4, 0x28,
  0x18, 0xE5, 0x38, 0x11, 0x9A, 0x40, 0x60, 0xB4, 0x09, 0x08, 0x40, 0xD0, 0x44, 0x0E, 0x05, 0x48,
  0x18, 0xF4, 0x20,
  // "|" (U+007C)
  0x8B, 0x24, 0xB4, 0xB4, 0xB4, 0xB4, 0xB4, 0xB4, 0xB4, 0xB4, 0xB4, 0xB4, 0xB4, 0xB4, 0xB4, 0xB0,
  // "}" (U+007D)
  0x28, 0x13, 0xE7, 0x40, 0x60, 0xE4, 0x04, 0x0D, 0x40, 0x70, 0xA4, 0x0A, 0x07, 0x40, 0xB0, 0x84,
  0x81, 0x4E, 0x92, 0x82, 0x2E, 0x51, 0x20, 0x80, 0x94, 0x0B, 0x06, 0x49, 0x02, 0x30, 0x60, 0xE3,
  0x81, 0xBE, 0x53,
  // "~" (U+007E)
  0x18, 0x93, 0xAD, 0x92, 0x06, 0x46, 0x28, 0xEE, 0x60,
  // "¡" (U+00A1)
  0x28, 0x11, 0xD4, 0x28, 0x12, 0xC2, 0x70, 0x06, 0x30, 0xA0, 0x53, 0x0E, 0x02, 0x20, 0x20, 0xE3,
  0x06, 0x0C, 0x30, 0xA0, 0x93, 0x0E, 0x06, 0x28, 0x12, 0xD3, 0x20,
  // "¢" (U+00A2)
  0x30, 0x70, 0x53, 0x89, 0x39, 0xEB, 0x20, 0xBC, 0x34, 0x04, 0xE1, 0x30, 0xA0, 0x94, 0x0C, 0x06,
  0x48, 0x2C, 0x90, 0x12, 0x82, 0x4E, 0xED, 0x30, 0x60, 0x74, 0x09, 0x04, 0x30,
  // "£" (U+00A3)
  0x48, 0x26, 0xDE, 0xB3, 0x83, 0x3F, 0x31, 0x33, 0x09, 0x0A, 0x60, 0xD0, 0x54, 0x84, 0x3E, 0xFE,
  0xE1, 0x38, 0x25, 0xE1, 0x14, 0x07, 0x0B, 0x60, 0xB0, 0x75, 0x81, 0x6C, 0x14, 0x02, 0xD0, 0x31,
  // "¤" (U+00A4)
  0x02, 0x48, 0xA0, 0x20, 0xC8, 0xDE, 0x8D, 0x14, 0xD2, 0x1B, 0x70, 0x95, 0x28, 0x31, 0xB0, 0x94,
  0x28, 0xA0, 0x1C, 0x05, 0xC1, 0x0A, 0x70, 0xBA, 0xEE, 0xAC, 0x13, 0x40, 0x31,
  // "¥" (U+00A5)
  0x10, 0x29, 0x28, 0x13, 0xE1, 0x29, 0x82, 0x20, 0xB6, 0x38, 0x2D, 0x35, 0xC4, 0x82, 0xB6, 0xD3,
  0x48, 0x19, 0xE8, 0x48, 0x3D, 0xEF, 0xD7, 0x40, 0x80, 0x94, 0x84, 0x6E, 0xFE, 0xE1, 0x38, 0x21,
  0xE4, 0x14, 0x02, 0x95,
  // "¦" (U+00A6)
  0x89, 0x04, 0xB4, 0xB4, 0xB4, 0xB4, 0xB7, 0x18, 0x90, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B,
  // "§" (U+00A7)
  0x28, 0x94, 0x5D, 0xEB, 0x01, 0xF3, 0x14, 0x02, 0xE1, 0x48, 0x1C, 0xD4, 0x28, 0x96, 0xA7, 0x5E,
  0x20, 0xF1, 0x0B, 0x40, 0xBA, 0x4C, 0x38, 0x18, 0xF3, 0x48, 0x93, 0xA7, 0x04, 0x12, 0xD5, 0x0A,
  0xEE, 0x82,
  // "¨" (U+00A8)
  0x83, 0x1C, 0x09, 0x50,
  // "©" (U+00A9)
  0x38, 0x43, 0x9D, 0xDB, 0x65, 0x87, 0x8D, 0x62, 0x24, 0xAC, 0x12, 0x89, 0x05, 0xB0, 0x2B, 0xDB,
  0x26, 0xC2, 0x85, 0xD1, 0x0E, 0x72, 0x42, 0x85, 0xA5, 0x2B, 0x05, 0xC5, 0x85, 0x49, 0x49, 0x07,
  0x95, 0x85, 0x2B, 0x2A, 0x06, 0xB5, 0x89, 0x03, 0x90, 0xD0, 0x1E, 0x30, 0x12, 0x89, 0x39, 0x60,
  0x7A, 0x05, 0xEE, 0xE1, 0x3D, 0x38, 0x1A, 0xB3, 0x28, 0x21, 0x7E, 0x34, 0x85, 0x6C, 0xFE, 0xE9,
  0x27, 0x10, 0x15,
  // "ª" (U+00AA)
  0x8A, 0x11, 0xBB, 0xB2, 0xA3, 0x1D, 0x0E, 0x05, 0x90, 0x9B, 0xA6, 0x10,
  // "«" (U+00AB)
  0x28, 0xA6, 0x58, 0x09, 0x30, 0x4D, 0x28, 0xB0, 0x3E, 0x36, 0xD1, 0x04, 0xE0, 0x9A, 0x38, 0x3C,
  0x52, 0xE1, 0x28, 0x35, 0xA0, 0xA5, 0x10,
  // "¬" (U+00AC)
  0x03, 0x80, 0x1E, 0x86, 0x90, 0x11, 0x11, 0x79, 0x50, 0x60, 0x95, 0x06, 0x09,
  // "®" (U+00AE)
  0x38, 0x43, 0x9D, 0xDB, 0x65, 0x87, 0x8D, 0x62, 0x24, 0xAC, 0x12, 0x89, 0x05, 0xB0, 0xAE, 0xD8,
  0x06, 0xC2, 0x89, 0x3D, 0x10, 0xB5, 0x2D, 0x40, 0xA5, 0x2B, 0x28, 0x90, 0xB4, 0x0D, 0x40, 0x49,
  0x49, 0x28, 0x2B, 0xEF, 0xA2, 0x82, 0x2B, 0x2A, 0x28, 0x2B, 0x58, 0xA2, 0x82, 0x39, 0x0D, 0x28,
  0xA1, 0xB4, 0x0E, 0x30, 0x96, 0x07, 0xA0, 0x73, 0x05, 0x63, 0xD3, 0x81, 0xAB, 0x32, 0x82, 0x17,
  0xE3, 0x48, 0x56, 0xCF, 0xEE, 0x92, 0x71, 0x01, 0x50,
  // "¯" (U+00AF)
  0x06, 0x80, 0x1E, 0x07, 0x18, 0x01, 0x11,
  // "°" (U+00B0)
  0x18, 0xA1, 0x6D, 0xC4, 0x2D, 0x23, 0xD3, 0xC0, 0x1E, 0x09, 0xEE, 0x60,
  // "±" (U+00B1)
  0x30, 0xC0, 0x45, 0x0C, 0x04, 0x50, 0xC0, 0x42, 0x89, 0x43, 0xEE, 0xFE, 0xEA, 0x01, 0x1C, 0x51,
  0x13, 0x0C, 0x04, 0x50, 0xC0, 0x47, 0x20, 0x4D, 0x0B,
  // "²" (U+00B2)
  0x28, 0x19, 0xD9, 0x38, 0x24, 0x0E, 0x13, 0x01, 0x0D, 0x40, 0xB0, 0x53, 0x09, 0x07, 0x30, 0x90,
  0x83, 0x83, 0x3E, 0xDD, 0x41,
  // "³" (U+00B3)
  0x28, 0x1A, 0xD9, 0x38, 0x23, 0x0E, 0x13, 0x02, 0x0D, 0x38, 0x1B, 0xE2, 0x40, 0x07, 0x28, 0x71,
  0x09, 0x70, 0x1C, 0xD9, 0x20,
  // "´" (U+00B4)
  0x28, 0x76, 0x50, 0x4D, 0x21, 0xC2, 0x10,
  // "µ" (U+00B5)
  0x20, 0x40, 0xE2, 0x08, 0x0A, 0x20, 0x80, 0xA2, 0x0B, 0x07, 0x20, 0xB0, 0x72, 0x0E, 0x03, 0x28,
  0x2E, 0x40, 0x29, 0x28, 0x43, 0xF1, 0x06, 0xC2, 0x06, 0x0D, 0x20, 0xB0, 0x92, 0x84, 0x9D, 0x06,
  0xF6, 0x28, 0x90, 0xDD, 0xE8, 0xC2, 0x01, 0xF2, 0x50, 0x40, 0xE6, 0x08, 0x0A, 0x60,
  // "¶" (U+00B6)
  0x10, 0x80, 0xEA, 0x0E, 0x05, 0xA8, 0x2E, 0x0C, 0x9A, 0x82, 0xE0, 0xCA, 0xA8, 0x2E, 0x0C, 0x9A,
  0x82, 0xE0, 0xC6, 0xA8, 0x7E, 0x0C, 0x0A, 0xEE, 0x0C, 0x38, 0x1C, 0x0C, 0x38, 0x1C, 0x0C, 0x38,
  0x1C, 0x0C, 0x38, 0x1C, 0x0C, 0x38, 0x1C, 0x0C, 0x38, 0x1C, 0x0C,
  // "·" (U+00B7)
  0x82, 0x69, 0xA9,
  // "¸" (U+00B8)
  0x20, 0x62, 0x89, 0x11, 0xB4, 0x02, 0x89, 0x1D, 0xB1,
  // "¹" (U+00B9)
  0x18, 0xA1, 0x35, 0x7E, 0x76, 0xA4, 0x0D, 0x11, 0xD0, 0x4A, 0x08, 0x71,
  // "º" (U+00BA)
  0x89, 0x61, 0xBC, 0x89, 0x40, 0xDD, 0x03, 0xA8, 0xCB, 0x10,
  // "»" (U+00BB)
  0x18, 0x2B, 0x12, 0xB2, 0x8B, 0x29, 0x80, 0xD4, 0x03, 0xF1, 0x8B, 0x05, 0xD1, 0x9B, 0x3E, 0x27,
  0xC0, 0xB4, 0x1C, 0x11,
  // "¼" (U+00BC)
  0x30, 0x30, 0x57, 0x81, 0x7E, 0x72, 0x81, 0x1C, 0x12, 0x81, 0x6A, 0x42, 0x0B, 0x04, 0x48, 0x4D,
  0x10, 0x97, 0x13, 0x84, 0x1D, 0x05, 0xA4, 0x93, 0x85, 0x4A, 0x3C, 0x2C, 0xD3, 0x85, 0x88, 0xC2,
  0xA7, 0x94, 0x84, 0xB4, 0x75, 0x86, 0x38, 0x58, 0x81, 0xDD, 0xFD, 0x20, 0x50, 0xB4, 0x0E, 0x28,
  0x12, 0xC1, 0x40, 0x52,
  // "½" (U+00BD)
  0x30, 0x30, 0x57, 0x18, 0x17, 0xE7, 0x28, 0x11, 0xC1, 0x38, 0x16, 0xA4, 0x20, 0xB0, 0x45, 0x83,
  0xD1, 0x09, 0x75, 0x86, 0x1D, 0x05, 0xA9, 0xD9, 0x38, 0x74, 0xA3, 0xC0, 0x40, 0xE1, 0x28, 0x28,
  0x8C, 0x22, 0x01, 0x0D, 0x40, 0xB0, 0x43, 0x0B, 0x05, 0x30, 0x08, 0x30, 0x90, 0x73, 0x05, 0x0B,
  0x30, 0x90, 0x83, 0x81, 0x2C, 0x12, 0x83, 0x3E, 0xDD, 0x41,
  // "¾" (U+00BE)
  0x28, 0x1A, 0xD9, 0x71, 0x82, 0x30, 0xE1, 0x28, 0x11, 0xC1, 0x30, 0x20, 0xD3, 0x0B, 0x04, 0x38,
  0x1B, 0xE2, 0x28, 0x19, 0x71, 0x48, 0x47, 0x70, 0x5A, 0x49, 0x28, 0xA2, 0x10, 0x97, 0x3C, 0x2C,
  0xD0, 0x1C, 0xD9, 0x1C, 0x2A, 0x79, 0x58, 0x4B, 0x47, 0x58, 0x64, 0x85, 0x88, 0x1D, 0xDF, 0xD3,
  0x05, 0x0B, 0x40, 0xE3, 0x81, 0x2C, 0x14, 0x05, 0x20,
  // "¿" (U+00BF)
  0x40, 0xD0, 0x53, 0x81, 0x1C, 0x37, 0x20, 0x50, 0x93, 0x81, 0x1D, 0x32, 0x81, 0x1C, 0x63, 0x0C,
  0x06, 0x30, 0x50, 0xC4, 0x89, 0x17, 0xD1, 0x23, 0x01, 0xCF, 0xC5, 0x10,
  // "À" (U+00C0)
  0x40, 0x03, 0x50, 0x60, 0xC6, 0x0C, 0x03, 0x77, 0x48, 0x14, 0xF7, 0x48, 0x1C, 0xD7, 0x38, 0x24,
  0xD9, 0x83, 0x82, 0xB7, 0x89, 0x28, 0x34, 0xF1, 0x89, 0x28, 0x5B, 0x90, 0x8A, 0x03, 0xA8, 0x93,
  0xEF, 0xB0, 0xBB, 0x22, 0x8B, 0x3F, 0x32, 0x82, 0x7C, 0xAA, 0x30, 0x60, 0xD0,
  // "Á" (U+00C1)
  0x60, 0x60, 0x55, 0x81, 0x4D, 0x24, 0x81, 0x1C, 0x27, 0x77, 0x81, 0x4F, 0x75, 0x81, 0xCD, 0x74,
  0x82, 0x4D, 0x98, 0x48, 0x2B, 0x78, 0x93, 0x83, 0x4F, 0x18, 0x93, 0x83, 0xB9, 0x08, 0xA2, 0x03,
  0xA8, 0x1E, 0xFB, 0x28, 0x90, 0xBB, 0x22, 0x8B, 0x03, 0xF3, 0x28, 0x37, 0xC0, 0xAA, 0x30, 0x60,
  0xD1,
  // "Â" (U+00C2)
  0x50, 0x40, 0x55, 0x82, 0x3D, 0xE1, 0x38, 0x31, 0xB2, 0x67, 0x77, 0x68, 0x14, 0xF7, 0x58, 0x1C,
  0xD7, 0x48, 0x24, 0xD9, 0x84, 0x82, 0xB7, 0x89, 0x38, 0x34, 0xF1, 0x89, 0x38, 0x3B, 0x90, 0x8A,
  0x20, 0x3A, 0x81, 0xEF, 0xB2, 0x89, 0x0B, 0xB2, 0x28, 0xB0, 0x3F, 0x32, 0x83, 0x7C, 0x0A, 0xA3,
  0x06, 0x0D, 0x10,
  // "Ã" (U+00C3)
  0x48, 0x38, 0xC3, 0x64, 0x38, 0x32, 0xA4, 0xDD, 0x77, 0x72, 0x81, 0x4F, 0x76, 0x81, 0xCD, 0x75,
  0x82, 0x4D, 0x98, 0x58, 0x2B, 0x78, 0x94, 0x83, 0x4F, 0x18, 0x94, 0x83, 0xB9, 0x08, 0xA3, 0x03,
  0xA8, 0x1E, 0xFB, 0x38, 0x4B, 0xB2, 0x28, 0xB2, 0x81, 0x3F, 0x32, 0x07, 0x0C, 0x20, 0x0A, 0x30,
  0x60, 0xD2,
  // "Ä" (U+00C4)
  0x38, 0x31, 0xC0, 0x95, 0x77, 0x77, 0x81, 0x4F, 0x75, 0x81, 0xCD, 0x74, 0x82, 0x4D, 0x98, 0x48,
  0x2B, 0x78, 0x93, 0x83, 0x4F, 0x18, 0x93, 0x83, 0xB9, 0x08, 0xA2, 0x03, 0xA8, 0x1E, 0xFB, 0x28,
  0x90, 0xBB, 0x22, 0x8B, 0x03, 0xF3, 0x28, 0x37, 0xC0, 0xAA, 0x30, 0x60, 0xD1,
  // "Å" (U+00C5)
  0x48, 0x16, 0xD9, 0x58, 0x2C, 0x2B, 0x14, 0x81, 0x9F, 0xC7, 0x77, 0x81, 0x4F, 0x75, 0x81, 0xCD,
  0x74, 0x82, 0x4D, 0x98, 0x48, 0x2B, 0x78, 0x93, 0x83, 0x4F, 0x18, 0x93, 0x83, 0xB9, 0x08, 0xA2,
  0x03, 0xA8, 0x1E, 0xFB, 0x28, 0x90, 0xBB, 0x22, 0x8B, 0x03, 0xF3, 0x28, 0x37, 0xC0, 0xAA, 0x30,
  0x60, 0xD1,
  // "Æ" (U+00C6)
  0x50, 0x9D, 0x01, 0x48, 0x23, 0xE9, 0xB7, 0x18, 0x2B, 0x8B, 0x77, 0x83, 0x4E, 0x1E, 0x37, 0x85,
  0xD7, 0x2F, 0xEE, 0xD4, 0x83, 0x6E, 0x05, 0xC0, 0xF1, 0x38, 0x41, 0xEF, 0xEE, 0x86, 0x84, 0x8D,
  0x11, 0xC5, 0x58, 0x52, 0xF4, 0x01, 0xF2, 0x50, 0x0A, 0x20, 0x4C, 0x30,
  // "Ç" (U+00C7)
  0x38, 0x35, 0xCF, 0xD5, 0x28, 0x90, 0x6E, 0x50, 0x31, 0x02, 0xF4, 0x50, 0x90, 0xB6, 0x0E, 0x05,
  0x58, 0x12, 0xF1, 0x50, 0x49, 0x68, 0x13, 0xF1, 0x68, 0x3D, 0x91, 0x12, 0x38, 0x33, 0xCF, 0xD5,
  0x50, 0x66, 0x81, 0x1B, 0x45, 0x81, 0x28, 0x94, 0x82, 0x1D, 0xB1, 0x30,
  // "È" (U+00C8)
  0x30, 0x03, 0x50, 0x60, 0xC6, 0x0C, 0x03, 0x77, 0x30, 0xAB, 0x0A, 0x20, 0xD0, 0x54, 0x81, 0x1F,
  0x14, 0x05, 0x0D, 0x58, 0x39, 0xFE, 0xE7, 0x28, 0x2C, 0x61, 0x13, 0x90, 0x24, 0x03, 0x0E, 0x50,
  0x70, 0xB5, 0x0A, 0xB0, 0xA2,
  // "É" (U+00C9)
  0x50, 0x60, 0x54, 0x81, 0x4D, 0x23, 0x81, 0x1C, 0x27, 0x73, 0x0A, 0xB0, 0xA2, 0x0D, 0x05, 0x48,
  0x11, 0xF1, 0x40, 0x50, 0xD5, 0x83, 0x9F, 0xEE, 0x72, 0x82, 0xC6, 0x11, 0x39, 0x02, 0x40, 0x30,
  0xE5, 0x07, 0x0B, 0x50, 0xAB, 0x0A, 0x20,
  // "Ê" (U+00CA)
  0x40, 0x40, 0x54, 0x82, 0x3D, 0xE1, 0x28, 0x31, 0xB2, 0x67, 0x77, 0x20, 0xAB, 0x0A, 0x20, 0xD0,
  0x54, 0x81, 0x1F, 0x14, 0x05, 0x0D, 0x58, 0x39, 0xFE, 0xE7, 0x28, 0x2C, 0x61, 0x13, 0x90, 0x24,
  0x03, 0x0E, 0x50, 0x70, 0xB5, 0x0A, 0xB0, 0xA2,
  // "Ë" (U+00CB)
  0x28, 0x31, 0xC0, 0x95, 0x77, 0x72, 0x0A, 0xB0, 0xA2, 0x0D, 0x05, 0x48, 0x11, 0xF1, 0x40, 0x50,
  0xD5, 0x83, 0x9F, 0xEE, 0x72, 0x82, 0xC6, 0x11, 0x39, 0x02, 0x40, 0x30, 0xE5, 0x07, 0x0B, 0x50,
  0xAB, 0x0A, 0x20,
  // "Ì" (U+00CC)
  0x30, 0x03, 0x50, 0x60, 0xC6, 0x0C, 0x03, 0x77, 0x38, 0x34, 0xEF, 0xB1, 0x30, 0x80, 0xA5, 0x0B,
  0x07, 0x59, 0x03, 0x40, 0x39, 0x50, 0x70, 0xC5, 0x0A, 0x08, 0x50, 0xD0, 0x54, 0x81, 0x1F, 0x13,
  0x82, 0x5D, 0xFB, 0x30,
  // "Í" (U+00CD)
  0x50, 0x60, 0x54, 0x81, 0x4D, 0x23, 0x81, 0x1C, 0x27, 0x73, 0x83, 0x4E, 0xFB, 0x13, 0x08, 0x0A,
  0x50, 0xB0, 0x75, 0x90, 0x34, 0x03, 0x95, 0x07, 0x0C, 0x50, 0xA0, 0x85, 0x0D, 0x05, 0x48, 0x11,
  0xF1, 0x38, 0x25, 0xDF, 0xB3,
  // "Î" (U+00CE)
  0x40, 0x40, 0x54, 0x82, 0x3D, 0xE1, 0x28, 0x31, 0xB2, 0x67, 0x77, 0x28, 0x34, 0xEF, 0xB1, 0x30,
  0x80, 0xA5, 0x0B, 0x07, 0x59, 0x03, 0x40, 0x39, 0x50, 0x70, 0xC5, 0x0A, 0x08, 0x50, 0xD0, 0x54,
  0x81, 0x1F, 0x13, 0x82, 0x5D, 0xFB, 0x30,
  // "Ï" (U+00CF)
  0x28, 0x31, 0xC0, 0x95, 0x77, 0x72, 0x83, 0x4E, 0xFB, 0x13, 0x08, 0x0A, 0x50, 0xB0, 0x75, 0x90,
  0x34, 0x03, 0x95, 0x07, 0x0C, 0x50, 0xA0, 0x85, 0x0D, 0x05, 0x48, 0x11, 0xF1, 0x38, 0x25, 0xDF,
  0xB3,
  // "Ð" (U+00D0)
  0x20, 0xAA, 0x0C, 0x05, 0x38, 0x90, 0xE5, 0x06, 0xF2, 0x02, 0xF1, 0x28, 0x3D, 0x70, 0x6C, 0x38,
  0x1B, 0x87, 0xA8, 0x96, 0xE2, 0x0D, 0x70, 0xD6, 0x10, 0x1F, 0x41, 0xF2, 0x28, 0x36, 0xE0, 0x4E,
  0x28, 0x90, 0x1E, 0x60, 0x7B, 0x03, 0xDB, 0x20, 0xBA, 0x0C, 0x07, 0x30,
  // "Ñ" (U+00D1)
  0x48, 0x38, 0xC3, 0x64, 0x38, 0x32, 0xA4, 0xDD, 0x77, 0x70, 0xA9, 0x30, 0x70, 0xB2, 0x81, 0xDF,
  0x32, 0x85, 0xA7, 0x01, 0xFA, 0x72, 0x87, 0xE4, 0x05, 0xC6, 0xB0, 0x29, 0x28, 0x59, 0x92, 0xE0,
  0x6C, 0x28, 0x5C, 0x50, 0xE3, 0x99, 0x29, 0x87, 0x20, 0xA7, 0xC5, 0x03, 0xE2, 0x85, 0x7B, 0xF1,
  0x07, 0xA2, 0x81, 0x3F, 0xD2, 0x0A, 0x07, 0x30, 0xE0, 0xA2,
  // "Ò" (U+00D2)
  0x40, 0x03, 0x70, 0x60, 0xC7, 0x10, 0xC0, 0x37, 0x77, 0x28, 0x36, 0xDE, 0xC2, 0x38, 0x48, 0xD3,
  0x1A, 0xC2, 0x81, 0x2F, 0x22, 0x84, 0x3F, 0x10, 0xAA, 0x38, 0x42, 0xF1, 0x0E, 0x53, 0x84, 0x4F,
  0x02, 0xF2, 0x38, 0x27, 0xC0, 0x49, 0x48, 0x4C, 0x70, 0x3F, 0x12, 0x81, 0x5E, 0x12, 0x84, 0xE8,
  0x04, 0xE6, 0x38, 0x34, 0xCF, 0xD5, 0x30,
  // "Ó" (U+00D3)
  0x60, 0x60, 0x56, 0x81, 0x4D, 0x25, 0x81, 0x1C, 0x27, 0x77, 0x28, 0x36, 0xDE, 0xC2, 0x38, 0x48,
  0xD3, 0x1A, 0xC2, 0x81, 0x2F, 0x22, 0x84, 0x3F, 0x10, 0xAA, 0x38, 0x42, 0xF1, 0x0E, 0x53, 0x84,
  0x4F, 0x02, 0xF2, 0x38, 0x27, 0xC0, 0x49, 0x48, 0x4C, 0x70, 0x3F, 0x12, 0x81, 0x5E, 0x12, 0x84,
  0xE8, 0x04, 0xE6, 0x38, 0x34, 0xCF, 0xD5, 0x30,
  // "Ô" (U+00D4)
  0x50, 0x40, 0x56, 0x82, 0x3D, 0xE1, 0x48, 0x31, 0xB2, 0x67, 0x77, 0x71, 0x83, 0x6D, 0xEC, 0x23,
  0x84, 0x8D, 0x31, 0xAC, 0x28, 0x12, 0xF2, 0x28, 0x43, 0xF1, 0x0A, 0xA3, 0x84, 0x2F, 0x10, 0xE5,
  0x38, 0x44, 0xF0, 0x2F, 0x23, 0x82, 0x7C, 0x04, 0x94, 0x84, 0xC7, 0x03, 0xF1, 0x28, 0x15, 0xE1,
  0x28, 0x4E, 0x80, 0x4E, 0x63, 0x83, 0x4C, 0xFD, 0x53,
  // "Õ" (U+00D5)
  0x48, 0x38, 0xC3, 0x64, 0x38, 0x32, 0xA4, 0xDD, 0x77, 0x71, 0x83, 0x6D, 0xEC, 0x23, 0x84, 0x8D,
  0x31, 0xAC, 0x28, 0x12, 0xF2, 0x28, 0x43, 0xF1, 0x0A, 0xA3, 0x84, 0x2F, 0x10, 0xE5, 0x38, 0x44,
  0xF0, 0x2F, 0x23, 0x82, 0x7C, 0x04, 0x94, 0x84, 0xC7, 0x03, 0xF1, 0x28, 0x15, 0xE1, 0x28, 0x4E,
  0x80, 0x4E, 0x63, 0x83, 0x4C, 0xFD, 0x53,
  // "Ö" (U+00D6)
  0x38, 0x31, 0xC0, 0x95, 0x77, 0x77, 0x38, 0x36, 0xDE, 0xC2, 0x38, 0x48, 0xD3, 0x1A, 0xC2, 0x81,
  0x2F, 0x22, 0x84, 0x3F, 0x10, 0xAA, 0x38, 0x42, 0xF1, 0x0E, 0x53, 0x84, 0x4F, 0x02, 0xF2, 0x38,
  0x27, 0xC0, 0x49, 0x48, 0x4C, 0x70, 0x3F, 0x12, 0x81, 0x5E, 0x12, 0x84, 0xE8, 0x04, 0xE6, 0x38,
  0x34, 0xCF, 0xD5, 0x30,
  // "×" (U+00D7)
  0x0D, 0x04, 0x28, 0x5B, 0x63, 0xE4, 0xB9, 0x28, 0x14, 0xFB, 0x38, 0x92, 0xBB, 0xE4, 0x0B, 0x90,
  0x3E, 0x45, 0x30, 0x30, 0x20,
  // "Ø" (U+00D8)
  0x71, 0x02, 0x38, 0x46, 0xDE, 0xBB, 0x62, 0x84, 0x8D, 0x31, 0xBD, 0x28, 0x91, 0x2F, 0x30, 0x1D,
  0xF1, 0x0A, 0xB2, 0x8B, 0x0A, 0x5F, 0x10, 0xE6, 0x06, 0x54, 0xF0, 0x2F, 0x32, 0x80, 0x7C, 0x04,
  0xF1, 0x92, 0x89, 0x1C, 0x70, 0x3F, 0x62, 0x05, 0xE1, 0x29, 0x83, 0xA1, 0x4E, 0x62, 0x84, 0x6A,
  0xCF, 0xD5, 0x30, 0x47, 0x10,
  // "Ù" (U+00D9)
  0x40, 0x03, 0x70, 0x60, 0xC7, 0x10, 0xC0, 0x37, 0x77, 0x10, 0xB0, 0x73, 0x90, 0x32, 0x0E, 0x03,
  0x20, 0x40, 0xE2, 0x03, 0x93, 0x07, 0x0B, 0x20, 0x60, 0xC3, 0x0B, 0x07, 0x20, 0xA0, 0x83, 0x0E,
  0x04, 0x20, 0xE0, 0x42, 0x03, 0x92, 0x81, 0x2F, 0x12, 0x07, 0x0C, 0x20, 0x49, 0x30, 0xC0, 0x72,
  0x85, 0x2F, 0x52, 0x7E, 0x13, 0x83, 0x6D, 0xFC, 0x33,
  // "Ú" (U+00DA)
  0x60, 0x60, 0x56, 0x81, 0x4D, 0x25, 0x81, 0x1C, 0x27, 0x77, 0x10, 0xB0, 0x73, 0x90, 0x32, 0x0E,
  0x03, 0x20, 0x40, 0xE2, 0x03, 0x93, 0x07, 0x0B, 0x20, 0x60, 0xC3, 0x0B, 0x07, 0x20, 0xA0, 0x83,
  0x0E, 0x04, 0x20, 0xE0, 0x42, 0x03, 0x92, 0x81, 0x2F, 0x12, 0x07, 0x0C, 0x20, 0x49, 0x30, 0xC0,
  0x72, 0x85, 0x2F, 0x52, 0x7E, 0x13, 0x83, 0x6D, 0xFC, 0x33,
  // "Û" (U+00DB)
  0x50, 0x40, 0x56, 0x82, 0x3D, 0xE1, 0x48, 0x31, 0xB2, 0x67, 0x77, 0x70, 0xB0, 0x73, 0x90, 0x32,
  0x0E, 0x03, 0x20, 0x40, 0xE2, 0x03, 0x93, 0x07, 0x0B, 0x20, 0x60, 0xC3, 0x0B, 0x07, 0x20, 0xA0,
  0x83, 0x0E, 0x04, 0x20, 0xE0, 0x42, 0x03, 0x92, 0x81, 0x2F, 0x12, 0x07, 0x0C, 0x20, 0x49, 0x30,
  0xC0, 0x72, 0x85, 0x2F, 0x52, 0x7E, 0x13, 0x83, 0x6D, 0xFC, 0x33,
  // "Ü" (U+00DC)
  0x38, 0x31, 0xC0, 0x95, 0x77, 0x77, 0x20, 0xB0, 0x73, 0x90, 0x32, 0x0E, 0x03, 0x20, 0x40, 0xE2,
  0x03, 0x93, 0x07, 0x0B, 0x20, 0x60, 0xC3, 0x0B, 0x07, 0x20, 0xA0, 0x83, 0x0E, 0x04, 0x20, 0xE0,
  0x42, 0x03, 0x92, 0x81, 0x2F, 0x12, 0x07, 0x0C, 0x20, 0x49, 0x30, 0xC0, 0x72, 0x85, 0x2F, 0x52,
  0x7E, 0x13, 0x83, 0x6D, 0xFC, 0x33,
  // "Ý" (U+00DD)
  0x40, 0x60, 0x54, 0x81, 0x4D, 0x23, 0x81, 0x1C, 0x27, 0x72, 0x00, 0x92, 0x83, 0x4E, 0x16, 0xC2,
  0x86, 0xD6, 0x04, 0xE0, 0x7C, 0x28, 0x31, 0xF2, 0xE3, 0x38, 0x1E, 0xC9, 0x48, 0x1C, 0xE1, 0x40,
  0xB0, 0x75, 0x90, 0x44, 0x03, 0x95, 0x07, 0x0C, 0x50,
  // "Þ" (U+00DE)
  0x20, 0xA0, 0x75, 0x82, 0xDF, 0xD7, 0x28, 0x71, 0xF2, 0x5F, 0x50, 0x5C, 0x28, 0x3B, 0x80, 0x99,
  0x28, 0xB0, 0xC7, 0x0C, 0x60, 0x1E, 0x40, 0xF3, 0x1A, 0xC0, 0x3F, 0xEF, 0xA1, 0x07, 0xC1, 0x40,
  0xA0, 0x85,
  // "ß" (U+00DF)
  0x48, 0x31, 0xAE, 0xD4, 0x48, 0x3A, 0xA1, 0x8C, 0x38, 0x41, 0xF2, 0x08, 0xA3, 0x84, 0x4E, 0x06,
  0xD1, 0x38, 0x38, 0xA3, 0xE2, 0x48, 0x2C, 0x68, 0xB5, 0x98, 0x23, 0x3F, 0x33, 0x03, 0x0E, 0x20,
  0x80, 0xC3, 0x07, 0x0B, 0x20, 0x39, 0x38, 0x4A, 0x83, 0x08, 0xD3, 0x84, 0xE4, 0xCF, 0xC3, 0x28,
  0x12, 0xF1, 0x60, 0x80, 0xB6, 0x81, 0xED, 0x26,
  // "à" (U+00E0)
  0x30, 0x03, 0x50, 0x60, 0xC6, 0x0C, 0x03, 0x73, 0x89, 0x56, 0xED, 0x5C, 0x05, 0xE3, 0x3E, 0x80,
  0xD6, 0x29, 0x89, 0x05, 0x3F, 0x10, 0x1F, 0x26, 0xD2, 0x83, 0x5E, 0x07, 0xB2, 0x89, 0x6B, 0xA0,
  0x6D, 0x17, 0xE7, 0x01, 0xCE, 0x7B, 0x41,
  // "á" (U+00E1)
  0x50, 0x60, 0x54, 0x81, 0x4D, 0x23, 0x81, 0x1C, 0x27, 0x38, 0x95, 0x6E, 0xD5, 0xC0, 0x5E, 0x33,
  0xE8, 0x0D, 0x62, 0x98, 0x90, 0x53, 0xF1, 0x01, 0xF2, 0x6D, 0x28, 0x35, 0xE0, 0x7B, 0x28, 0x96,
  0xBA, 0x06, 0xD1, 0x7E, 0x70, 0x1C, 0xE7, 0xB4, 0x10,
  // "â" (U+00E2)
  0x40, 0x40, 0x54, 0x82, 0x3D, 0xE1, 0x28, 0x31, 0xB2, 0x67, 0x72, 0x89, 0x56, 0xED, 0x5C, 0x05,
  0xE3, 0x3E, 0x80, 0xD6, 0x29, 0x89, 0x05, 0x3F, 0x10, 0x1F, 0x26, 0xD2, 0x83, 0x5E, 0x07, 0xB2,
  0x89, 0x6B, 0xA0, 0x6D, 0x17, 0xE7, 0x01, 0xCE, 0x7B, 0x41,
  // "ã" (U+00E3)
  0x38, 0x38, 0xC3, 0x64, 0x28, 0x32, 0xA4, 0xDD, 0x74, 0x83, 0x6E, 0xD5, 0xC2, 0x84, 0x5E, 0x33,
  0xE8, 0x20, 0xD0, 0x62, 0x98, 0x92, 0x50, 0x3F, 0x10, 0x1F, 0x20, 0x6D, 0x20, 0x50, 0xE2, 0x07,
  0x0B, 0x20, 0xB0, 0xA2, 0x84, 0x6D, 0x17, 0xE7, 0x28, 0x41, 0xCE, 0x7B, 0x42,
  // "ä" (U+00E4)
  0x28, 0x31, 0xC0, 0x95, 0x77, 0x28, 0x95, 0x6E, 0xD5, 0xC0, 0x5E, 0x33, 0xE8, 0x0D, 0x62, 0x98,
  0x90, 0x53, 0xF1, 0x01, 0xF2, 0x6D, 0x28, 0x35, 0xE0, 0x7B, 0x28, 0x96, 0xBA, 0x06, 0xD1, 0x7E,
  0x70, 0x1C, 0xE7, 0xB4, 0x10,
  // "å" (U+00E5)
  0x38, 0x16, 0xD9, 0x48, 0x2C, 0x2B, 0x13, 0x81, 0x9F, 0xC7, 0x38, 0x95, 0x6E, 0xD5, 0xC0, 0x5E,
  0x33, 0xE8, 0x0D, 0x62, 0x98, 0x90, 0x53, 0xF1, 0x01, 0xF2, 0x6D, 0x28, 0x35, 0xE0, 0x7B, 0x28,
  0x96, 0xBA, 0x06, 0xD1, 0x7E, 0x70, 0x1C, 0xE7, 0xB4, 0x10,
  // "æ" (U+00E6)
  0x28, 0xC6, 0x6E, 0xC8, 0x9C, 0xE7, 0x05, 0xE3, 0x5F, 0xC2, 0x5D, 0x0D, 0x60, 0x1F, 0x32, 0xB9,
  0x3F, 0x10, 0x3F, 0xEC, 0x70, 0x5C, 0x20, 0x70, 0xA4, 0x07, 0x0B, 0x20, 0xD0, 0xA4, 0x8A, 0x16,
  0xD1, 0x8E, 0xE2, 0x15, 0x01, 0xCE, 0x5D, 0x7E, 0xE8, 0x10,
  // "ç" (U+00E7)
  0x28, 0x93, 0x6D, 0xE7, 0x05, 0xE3, 0x11, 0x0D, 0x53, 0x03, 0x0E, 0x40, 0x60, 0xC4, 0x07, 0x0B,
  0x48, 0x35, 0xE2, 0x12, 0x28, 0x2A, 0xED, 0x33, 0x06, 0x48, 0x11, 0xB4, 0x38, 0x12, 0x89, 0x28,
  0x21, 0xDB, 0x12,
  // "è" (U+00E8)
  0x30, 0x03, 0x40, 0x60, 0xC5, 0x0C, 0x03, 0x71, 0x8A, 0x66, 0xDE, 0x70, 0x5C, 0x25, 0xD0, 0xD3,
  0x1A, 0xA4, 0xFE, 0xE8, 0x07, 0xB4, 0x07, 0x0B, 0x48, 0x35, 0xE3, 0x14, 0x28, 0x29, 0xEE, 0x81,
  // "é" (U+00E9)
  0x50, 0x60, 0x54, 0x81, 0x4D, 0x23, 0x81, 0x1C, 0x27, 0x38, 0x26, 0xDE, 0x72, 0x83, 0x5C, 0x25,
  0xD2, 0x89, 0x1D, 0x31, 0xAA, 0x04, 0xFE, 0xE8, 0x20, 0x70, 0xB5, 0x07, 0x0B, 0x58, 0x35, 0xE3,
  0x14, 0x38, 0x29, 0xEE, 0x82,
  // "ê" (U+00EA)
  0x40, 0x40, 0x54, 0x82, 0x3D, 0xE1, 0x28, 0x31, 0xB2, 0x67, 0x72, 0x82, 0x6D, 0xE7, 0x28, 0x35,
  0xC2, 0x5D, 0x28, 0x91, 0xD3, 0x1A, 0xA0, 0x4F, 0xEE, 0x82, 0x07, 0x0B, 0x50, 0x70, 0xB5, 0x83,
  0x5E, 0x31, 0x43, 0x82, 0x9E, 0xE8, 0x20,
  // "ë" (U+00EB)
  0x28, 0x31, 0xC0, 0x95, 0x77, 0x28, 0x26, 0xDE, 0x72, 0x83, 0x5C, 0x25, 0xD2, 0x89, 0x1D, 0x31,
  0xAA, 0x04, 0xFE, 0xE8, 0x20, 0x70, 0xB5, 0x07, 0x0B, 0x58, 0x35, 0xE3, 0x14, 0x38, 0x29, 0xEE,
  0x82,
  // "ì" (U+00EC)
  0x10, 0x03, 0x20, 0x60, 0xC3, 0x0C, 0x03, 0x50, 0x40, 0xE2, 0x07, 0x0A, 0x20, 0xB0, 0x72, 0x87,
  0xE4, 0x02, 0xF1, 0x05, 0xD2, 0x08, 0x09, 0x20, 0xB0, 0x62,
  // "í" (U+00ED)
  0x30, 0x60, 0x52, 0x85, 0x4D, 0x20, 0x1C, 0x27, 0x04, 0x0E, 0x30, 0x70, 0xA3, 0x0B, 0x07, 0x30,
  0xE0, 0x42, 0x81, 0x2F, 0x12, 0x05, 0x0D, 0x30, 0x80, 0x93, 0x0B, 0x06, 0x30,
  // "î" (U+00EE)
  0x20, 0x40, 0x52, 0x87, 0x3D, 0xE1, 0x1B, 0x26, 0x76, 0x04, 0x0E, 0x30, 0x70, 0xA3, 0x0B, 0x07,
  0x30, 0xE0, 0x42, 0x81, 0x2F, 0x12, 0x05, 0x0D, 0x30, 0x80, 0x93, 0x0B, 0x06, 0x30,
  // "ï" (U+00EF)
  0x83, 0x1C, 0x09, 0x57, 0x40, 0x40, 0xE3, 0x07, 0x0A, 0x30, 0xB0, 0x73, 0x0E, 0x04, 0x28, 0x12,
  0xF1, 0x20, 0x50, 0xD3, 0x08, 0x09, 0x30, 0xB0, 0x63,
  // "ð" (U+00F0)
  0x28, 0x31, 0xD6, 0xA6, 0x38, 0x19, 0xF6, 0x38, 0x27, 0x66, 0xB6, 0x90, 0x12, 0x89, 0x49, 0xD8,
  0xE3, 0x0B, 0xA2, 0x8F, 0x34, 0xE2, 0x83, 0x3F, 0x18, 0xA2, 0x83, 0x4E, 0x0A, 0x82, 0x89, 0x59,
  0x90, 0x8C, 0x15, 0xE2, 0x01, 0xBE, 0xC3, 0x20,
  // "ñ" (U+00F1)
  0x38, 0x38, 0xC3, 0x64, 0x28, 0x32, 0xA4, 0xDD, 0x73, 0x84, 0x4B, 0x7E, 0xC1, 0x28, 0x47, 0xE6,
  0x1E, 0x52, 0x0B, 0x0A, 0x20, 0xE0, 0x42, 0x89, 0x3E, 0x50, 0x2F, 0x10, 0x2F, 0x10, 0x5D, 0x20,
  0x50, 0xD2, 0x09, 0x0A, 0x20, 0x90, 0xA2, 0x0C, 0x06, 0x20, 0xC0, 0x62, 0x90, 0x32,
  // "ò" (U+00F2)
  0x30, 0x03, 0x50, 0x60, 0xC6, 0x0C, 0x03, 0x73, 0x82, 0x6E, 0xE7, 0x28, 0x75, 0xE2, 0x3F, 0x20,
  0xD5, 0x28, 0x2E, 0x43, 0xE3, 0x98, 0x13, 0x6C, 0x28, 0x33, 0xF1, 0x7B, 0x28, 0x78, 0xA0, 0x5E,
  0x14, 0xE3, 0x28, 0x29, 0xED, 0x42,
  // "ó" (U+00F3)
  0x50, 0x60, 0x54, 0x81, 0x4D, 0x23, 0x81, 0x1C, 0x27, 0x38, 0x26, 0xEE, 0x72, 0x87, 0x5E, 0x23,
  0xF2, 0x0D, 0x52, 0x82, 0xE4, 0x3E, 0x39, 0x81, 0x36, 0xC2, 0x83, 0x3F, 0x17, 0xB2, 0x87, 0x8A,
  0x05, 0xE1, 0x4E, 0x32, 0x82, 0x9E, 0xD4, 0x20,
  // "ô" (U+00F4)
  0x40, 0x40, 0x54, 0x82, 0x3D, 0xE1, 0x28, 0x31, 0xB2, 0x67, 0x72, 0x82, 0x6E, 0xE7, 0x28, 0x75,
  0xE2, 0x3F, 0x20, 0xD5, 0x28, 0x2E, 0x43, 0xE3, 0x98, 0x13, 0x6C, 0x28, 0x33, 0xF1, 0x7B, 0x28,
  0x78, 0xA0, 0x5E, 0x14, 0xE3, 0x28, 0x29, 0xED, 0x42,
  // "õ" (U+00F5)
  0x28, 0x91, 0x8C, 0x36, 0x40, 0x2A, 0x4D, 0xD7, 0x38, 0x26, 0xEE, 0x72, 0x87, 0x5E, 0x23, 0xF2,
  0x0D, 0x52, 0x82, 0xE4, 0x3E, 0x39, 0x81, 0x36, 0xC2, 0x83, 0x3F, 0x17, 0xB2, 0x87, 0x8A, 0x05,
  0xE1, 0x4E, 0x32, 0x82, 0x9E, 0xD4, 0x20,
  // "ö" (U+00F6)
  0x28, 0x31, 0xC0, 0x95, 0x77, 0x28, 0x26, 0xEE, 0x72, 0x87, 0x5E, 0x23, 0xF2, 0x0D, 0x52, 0x82,
  0xE4, 0x3E, 0x39, 0x81, 0x36, 0xC2, 0x83, 0x3F, 0x17, 0xB2, 0x87, 0x8A, 0x05, 0xE1, 0x4E, 0x32,
  0x82, 0x9E, 0xD4, 0x20,
  // "÷" (U+00F7)
  0x30, 0xD0, 0x55, 0x0A, 0x03, 0x72, 0x03, 0x80, 0x1E, 0x0A, 0x18, 0x02, 0x13, 0x0A, 0x03, 0x50,
  0xD0, 0x52,
  // "ø" (U+00F8)
  0x60, 0x42, 0x8E, 0x26, 0xEE, 0xB7, 0x05, 0xE3, 0x5F, 0x20, 0xD6, 0x09, 0xE4, 0x3F, 0x07, 0x2F,
  0x36, 0xC3, 0x62, 0xF1, 0x7B, 0x90, 0x8B, 0x05, 0xF4, 0x4E, 0x30, 0x8C, 0xED, 0x42, 0x06, 0x60,
  // "ù" (U+00F9)
  0x30, 0x03, 0x50, 0x60, 0xC6, 0x0C, 0x03, 0x72, 0x05, 0x0D, 0x28, 0x38, 0xA0, 0x8A, 0x28, 0x3B,
  0x60, 0xB7, 0x29, 0x87, 0x30, 0xE3, 0x03, 0xF0, 0x39, 0x28, 0x37, 0xC0, 0x6C, 0x28, 0x96, 0xC9,
  0x07, 0xD1, 0x8E, 0x50, 0x2D, 0xE5, 0xD2, 0x10,
  // "ú" (U+00FA)
  0x50, 0x60, 0x54, 0x81, 0x4D, 0x23, 0x81, 0x1C, 0x27, 0x20, 0x50, 0xD2, 0x83, 0x8A, 0x08, 0xA2,
  0x83, 0xB6, 0x0B, 0x72, 0x98, 0x73, 0x0E, 0x30, 0x3F, 0x03, 0x92, 0x83, 0x7C, 0x06, 0xC2, 0x89,
  0x6C, 0x90, 0x7D, 0x18, 0xE5, 0x02, 0xDE, 0x5D, 0x21,
  // "û" (U+00FB)
  0x40, 0x40, 0x54, 0x82, 0x3D, 0xE1, 0x28, 0x31, 0xB2, 0x67, 0x71, 0x05, 0x0D, 0x28, 0x38, 0xA0,
  0x8A, 0x28, 0x3B, 0x60, 0xB7, 0x29, 0x87, 0x30, 0xE3, 0x03, 0xF0, 0x39, 0x28, 0x37, 0xC0, 0x6C,
  0x28, 0x96, 0xC9, 0x07, 0xD1, 0x8E, 0x50, 0x2D, 0xE5, 0xD2, 0x10,
  // "ü" (U+00FC)
  0x28, 0x31, 0xC0, 0x95, 0x77, 0x10, 0x50, 0xD2, 0x83, 0x8A, 0x08, 0xA2, 0x83, 0xB6, 0x0B, 0x72,
  0x98, 0x73, 0x0E, 0x30, 0x3F, 0x03, 0x92, 0x83, 0x7C, 0x06, 0xC2, 0x89, 0x6C, 0x90, 0x7D, 0x18,
  0xE5, 0x02, 0xDE, 0x5D, 0x21,
  // "ý" (U+00FD)
  0x60, 0x60, 0x56, 0x81, 0x4D, 0x25, 0x81, 0x1C, 0x27, 0x68, 0x51, 0xF1, 0x01, 0xF2, 0x39, 0x82,
  0x20, 0x8A, 0x48, 0x3E, 0x31, 0xE3, 0x48, 0x2D, 0x37, 0xA5, 0x82, 0xC4, 0xE3, 0x58, 0x1B, 0xAA,
  0x68, 0x1A, 0xF3, 0x60, 0x0A, 0x68, 0x11, 0xE3, 0x60, 0xA0, 0x95, 0x81, 0x5F, 0xB6,
  // "þ" (U+00FE)
  0x30, 0x80, 0x96, 0x0C, 0x06, 0x69, 0x02, 0x58, 0x43, 0xE6, 0xEC, 0x12, 0x84, 0x7E, 0x71, 0xD6,
  0x20, 0xA0, 0xB2, 0x0B, 0x07, 0x20, 0xE0, 0x52, 0x84, 0xC6, 0x02, 0xF1, 0x29, 0x82, 0x30, 0x5E,
  0x20, 0x60, 0xD2, 0x84, 0x9F, 0x33, 0xE5, 0x28, 0x3C, 0x7D, 0xE6, 0x39, 0x02, 0x50, 0x40, 0xE6,
  0x07, 0x0A, 0x60,
  // "ÿ" (U+00FF)
  0x38, 0x31, 0xC0, 0x95, 0x77, 0x78, 0x51, 0xF1, 0x01, 0xF2, 0x39, 0x82, 0x20, 0x8A, 0x48, 0x3E,
  0x31, 0xE3, 0x48, 0x2D, 0x37, 0xA5, 0x82, 0xC4, 0xE3, 0x58, 0x1B, 0xAA, 0x68, 0x1A, 0xF3, 0x60,
  0x0A, 0x68, 0x11, 0xE3, 0x60, 0xA0, 0x95, 0x81, 0x5F, 0xB6,
  // "Ā" (U+0100)
  0x38, 0x32, 0xEE, 0xE7, 0x40, 0xF1, 0x76, 0x81, 0x4F, 0x75, 0x81, 0xCD, 0x74, 0x82, 0x4D, 0x98,
  0x48, 0x2B, 0x78, 0x93, 0x83, 0x4F, 0x18, 0x93, 0x83, 0xB9, 0x08, 0xA2, 0x03, 0xA8, 0x1E, 0xFB,
  0x28, 0x90, 0xBB, 0x22, 0x8B, 0x03, 0xF3, 0x28, 0x37, 0xC0, 0xAA, 0x30, 0x60, 0xD1,
  // "ā" (U+0101)
  0x28, 0x32, 0xEE, 0xE7, 0x30, 0xF1, 0x38, 0x95, 0x6E, 0xD5, 0xC0, 0x5E, 0x33, 0xE8, 0x0D, 0x62,
  0x98, 0x90, 0x53, 0xF1, 0x01, 0xF2, 0x6D, 0x28, 0x35, 0xE0, 0x7B, 0x28, 0x96, 0xBA, 0x06, 0xD1,
  0x7E, 0x70, 0x1C, 0xE7, 0xB4, 0x10,
  // "Ă" (U+0102)
  0x48, 0x2D, 0x26, 0x94, 0x82, 0x7E, 0xB1, 0x77, 0x68, 0x14, 0xF7, 0x58, 0x1C, 0xD7, 0x48, 0x24,
  0xD9, 0x84, 0x82, 0xB7, 0x89, 0x38, 0x34, 0xF1, 0x89, 0x38, 0x3B, 0x90, 0x8A, 0x20, 0x3A, 0x81,
  0xEF, 0xB2, 0x89, 0x0B, 0xB2, 0x28, 0xB0, 0x3F, 0x32, 0x83, 0x7C, 0x0A, 0xA3, 0x06, 0x0D, 0x10,
  // "ă" (U+0103)
  0x38, 0x2D, 0x26, 0x93, 0x82, 0x7E, 0xB1, 0x72, 0x89, 0x56, 0xED, 0x5C, 0x05, 0xE3, 0x3E, 0x80,
  0xD6, 0x29, 0x89, 0x05, 0x3F, 0x10, 0x1F, 0x26, 0xD2, 0x83, 0x5E, 0x07, 0xB2, 0x89, 0x6B, 0xA0,
  0x6D, 0x17, 0xE7, 0x01, 0xCE, 0x7B, 0x41,
  // "Ą" (U+0104)
  0x48, 0x14, 0xF7, 0x48, 0x1C, 0xD7, 0x38, 0x24, 0xD9, 0x83, 0x82, 0xB7, 0x89, 0x28, 0x34, 0xF1,
  0x89, 0x28, 0x5B, 0x90, 0x8A, 0x03, 0xA8, 0x93, 0xEF, 0xB0, 0xBB, 0x22, 0x8B, 0x3F, 0x32, 0x82,
  0x7C, 0xAA, 0x30, 0x89, 0x40, 0x20, 0xB5, 0x09, 0x07, 0x58, 0x17, 0xF5, 0x50, 0x11,
  // "ą" (U+0105)
  0x28, 0x95, 0x6E, 0xD5, 0xC0, 0x5E, 0x33, 0xE8, 0x0D, 0x62, 0x98, 0x90, 0x53, 0xF1, 0x01, 0xF2,
  0x6D, 0x28, 0x35, 0xE0, 0x7B, 0x28, 0x96, 0xBA, 0x06, 0xD1, 0x7E, 0x70, 0x1C, 0xE9, 0xE4, 0x30,
  0x20, 0xB5, 0x09, 0x07, 0x58, 0x17, 0xF5, 0x50, 0x13,
  // "Ć" (U+0106)
  0x60, 0x60, 0x55, 0x81, 0x4D, 0x24, 0x81, 0x1C, 0x27, 0x76, 0x83, 0x5C, 0xFD, 0x52, 0x89, 0x06,
  0xE5, 0x03, 0x10, 0x2F, 0x45, 0x09, 0x0B, 0x60, 0xE0, 0x55, 0x81, 0x2F, 0x15, 0x04, 0x96, 0x81,
  0x3F, 0x16, 0x83, 0xD9, 0x11, 0x23, 0x83, 0x3C, 0xFD, 0x52,
  // "ć" (U+0107)
  0x40, 0x60, 0x53, 0x81, 0x4D, 0x22, 0x81, 0x1C, 0x27, 0x28, 0x93, 0x6D, 0xE7, 0x05, 0xE3, 0x11,
  0x0D, 0x53, 0x03, 0x0E, 0x40, 0x60, 0xC4, 0x07, 0x0B, 0x48, 0x35, 0xE2, 0x12, 0x28, 0x2A, 0xED,
  0x31,
  // "Ĉ" (U+0108)
  0x50, 0x40, 0x55, 0x82, 0x3D, 0xE1, 0x38, 0x31, 0xB2, 0x67, 0x77, 0x58, 0x35, 0xCF, 0xD5, 0x28,
  0x90, 0x6E, 0x50, 0x31, 0x02, 0xF4, 0x50, 0x90, 0xB6, 0x0E, 0x05, 0x58, 0x12, 0xF1, 0x50, 0x49,
  0x68, 0x13, 0xF1, 0x68, 0x3D, 0x91, 0x12, 0x38, 0x33, 0xCF, 0xD5, 0x20,
  // "ĉ" (U+0109)
  0x30, 0x40, 0x53, 0x89, 0x03, 0xDE, 0x10, 0x1B, 0x26, 0x77, 0x18, 0x93, 0x6D, 0xE7, 0x05, 0xE3,
  0x11, 0x0D, 0x53, 0x03, 0x0E, 0x40, 0x60, 0xC4, 0x07, 0x0B, 0x48, 0x35, 0xE2, 0x12, 0x28, 0x2A,
  0xED, 0x31,
  // "Ċ" (U+010A)
  0x50, 0xC0, 0x37, 0x77, 0x78, 0x35, 0xCF, 0xD5, 0x28, 0x90, 0x6E, 0x50, 0x31, 0x02, 0xF4, 0x50,
  0x90, 0xB6, 0x0E, 0x05, 0x58, 0x12, 0xF1, 0x50, 0x49, 0x68, 0x13, 0xF1, 0x68, 0x3D, 0x91, 0x12,
  0x38, 0x33, 0xCF, 0xD5, 0x20,
  // "ċ" (U+010B)
  0x40, 0xC0, 0x37, 0x78, 0x93, 0x6D, 0xE7, 0x05, 0xE3, 0x11, 0x0D, 0x53, 0x03, 0x0E, 0x40, 0x60,
  0xC4, 0x07, 0x0B, 0x48, 0x35, 0xE2, 0x12, 0x28, 0x2A, 0xED, 0x31,
  // "Č" (U+010C)
  0x40, 0x52, 0x06, 0x48, 0x27, 0x9A, 0x54, 0x81, 0x1F, 0x97, 0x76, 0x83, 0x5C, 0xFD, 0x52, 0x89,
  0x06, 0xE5, 0x03, 0x10, 0x2F, 0x45, 0x09, 0x0B, 0x60, 0xE0, 0x55, 0x81, 0x2F, 0x15, 0x04, 0x96,
  0x81, 0x3F, 0x16, 0x83, 0xD9, 0x11, 0x23, 0x83, 0x3C, 0xFD, 0x52,
  // "č" (U+010D)
  0x30, 0x52, 0x06, 0x38, 0x27, 0x9A, 0x53, 0x81, 0x1F, 0x97, 0x38, 0x26, 0xDE, 0x72, 0x83, 0x5E,
  0x31, 0x12, 0x0D, 0x05, 0x40, 0x30, 0xE5, 0x06, 0x0C, 0x50, 0x70, 0xB5, 0x83, 0x5E, 0x21, 0x23,
  0x82, 0xAE, 0xD3, 0x20,
  // "Ď" (U+010E)
  0x30, 0x52, 0x06, 0x48, 0x27, 0x9A, 0x54, 0x81, 0x1F, 0x97, 0x76, 0x0A, 0xA0, 0xC0, 0x53, 0x89,
  0x0D, 0x50, 0x6F, 0x20, 0x1F, 0x22, 0x83, 0xD7, 0x05, 0xE3, 0x83, 0xB8, 0x09, 0xA3, 0x83, 0xD7,
  0x0C, 0x63, 0x98, 0x24, 0x0F, 0x32, 0x82, 0x5E, 0x03, 0x92, 0x89, 0x01, 0xD6, 0x07, 0xB0, 0x3C,
  0xA2, 0x0A, 0xA0, 0xC0, 0x63,
  // "ď" (U+010F)
  0x68, 0x3B, 0x71, 0xF2, 0x68, 0x2E, 0x46, 0x96, 0x82, 0x2F, 0x05, 0x48, 0x36, 0xED, 0x7C, 0x58,
  0x45, 0xE3, 0x2F, 0x95, 0x0D, 0x06, 0x20, 0xE0, 0x54, 0x85, 0x2F, 0x10, 0x1F, 0x24, 0x06, 0x0C,
  0x20, 0x50, 0xE5, 0x07, 0x0B, 0x20, 0x0B, 0x58, 0x46, 0xD1, 0x7E, 0x75, 0x84, 0x1C, 0xE6, 0xB4,
  0x50,
  // "Đ" (U+0110)
  0x20, 0xAA, 0x0C, 0x05, 0x38, 0x90, 0xE5, 0x06, 0xF2, 0x02, 0xF1, 0x28, 0x3D, 0x70, 0x6C, 0x38,
  0x1B, 0x87, 0xA8, 0x96, 0xE2, 0x0D, 0x70, 0xD6, 0x10, 0x1F, 0x41, 0xF2, 0x28, 0x36, 0xE0, 0x4E,
  0x28, 0x90, 0x1E, 0x60, 0x7B, 0x03, 0xDB, 0x20, 0xBA, 0x0C, 0x07, 0x30,
  // "đ" (U+0111)
  0x60, 0xB0, 0x75, 0x83, 0xBE, 0xFE, 0x25, 0x02, 0x94, 0x83, 0x6E, 0xC7, 0xC3, 0x84, 0x5E, 0x32,
  0xF8, 0x30, 0xD0, 0x62, 0x0E, 0x05, 0x20, 0x39, 0x28, 0x11, 0xF2, 0x20, 0x60, 0xC2, 0x05, 0x0E,
  0x30, 0x70, 0xB2, 0x0B, 0x0A, 0x38, 0x46, 0xD1, 0x7E, 0x73, 0x84, 0x1C, 0xE6, 0xB4, 0x30,
  // "Ē" (U+0112)
  0x28, 0x32, 0xEE, 0xE7, 0x30, 0xF1, 0x73, 0x0A, 0xB0, 0xA2, 0x0D, 0x05, 0x48, 0x11, 0xF1, 0x40,
  0x50, 0xD5, 0x83, 0x9F, 0xEE, 0x72, 0x82, 0xC6, 0x11, 0x39, 0x02, 0x40, 0x30, 0xE5, 0x07, 0x0B,
  0x50, 0xAB, 0x0A, 0x20,
  // "ē" (U+0113)
  0x28, 0x32, 0xEE, 0xE7, 0x30, 0xF1, 0x38, 0x26, 0xDE, 0x72, 0x83, 0x5C, 0x25, 0xD2, 0x89, 0x1D,
  0x31, 0xAA, 0x04, 0xFE, 0xE8, 0x20, 0x70, 0xB5, 0x07, 0x0B, 0x58, 0x35, 0xE3, 0x14, 0x38, 0x29,
  0xEE, 0x82,
  // "Ĕ" (U+0114)
  0x38, 0x2D, 0x26, 0x93, 0x82, 0x7E, 0xB1, 0x77, 0x20, 0xAB, 0x0A, 0x20, 0xD0, 0x54, 0x81, 0x1F,
  0x14, 0x05, 0x0D, 0x58, 0x39, 0xFE, 0xE7, 0x28, 0x2C, 0x61, 0x13, 0x90, 0x24, 0x03, 0x0E, 0x50,
  0x70, 0xB5, 0x0A, 0xB0, 0xA2,
  // "ĕ" (U+0115)
  0x38, 0x2D, 0x26, 0x93, 0x82, 0x7E, 0xB1, 0x72, 0x82, 0x6D, 0xE7, 0x28, 0x35, 0xC2, 0x5D, 0x28,
  0x91, 0xD3, 0x1A, 0xA0, 0x4F, 0xEE, 0x82, 0x07, 0x0B, 0x50, 0x70, 0xB5, 0x83, 0x5E, 0x31, 0x43,
  0x82, 0x9E, 0xE8, 0x20,
  // "Ė" (U+0116)
  0x40, 0xC0, 0x37, 0x73, 0x0A, 0xB0, 0xA2, 0x0D, 0x05, 0x48, 0x11, 0xF1, 0x40, 0x50, 0xD5, 0x83,
  0x9F, 0xEE, 0x72, 0x82, 0xC6, 0x11, 0x39, 0x02, 0x40, 0x30, 0xE5, 0x07, 0x0B, 0x50, 0xAB, 0x0A,
  0x20,
  // "ė" (U+0117)
  0x40, 0xC0, 0x37, 0x78, 0xA6, 0x6D, 0xE7, 0x05, 0xC2, 0x5D, 0x0D, 0x31, 0xAA, 0x4F, 0xEE, 0x80,
  0x7B, 0x40, 0x70, 0xB4, 0x83, 0x5E, 0x31, 0x42, 0x82, 0x9E, 0xE8, 0x10,
  // "Ę" (U+0118)
  0x20, 0xAB, 0x0A, 0x20, 0xD0, 0x54, 0x81, 0x1F, 0x14, 0x05, 0x0D, 0x58, 0x39, 0xFE, 0xE7, 0x28,
  0x2C, 0x61, 0x13, 0x90, 0x24, 0x03, 0x0E, 0x50, 0x70, 0xB5, 0x0A, 0xB0, 0xA3, 0x02, 0x0B, 0x50,
  0x90, 0x75, 0x81, 0x7F, 0x55, 0x01, 0x40,
  // "ę" (U+0119)
  0x28, 0xA6, 0x6D, 0xE7, 0x05, 0xC2, 0x5D, 0x0D, 0x31, 0xAA, 0x4F, 0xEE, 0x80, 0x7B, 0x40, 0x70,
  0xB4, 0x83, 0x5E, 0x31, 0x42, 0x82, 0x9E, 0xF9, 0x30, 0x40, 0x94, 0x0D, 0x03, 0x48, 0x1A, 0xE1,
  0x10,
  // "Ě" (U+011A)
  0x30, 0x52, 0x06, 0x38, 0x27, 0x9A, 0x53, 0x81, 0x1F, 0x97, 0x73, 0x0A, 0xB0, 0xA2, 0x0D, 0x05,
  0x48, 0x11, 0xF1, 0x40, 0x50, 0xD5, 0x83, 0x9F, 0xEE, 0x72, 0x82, 0xC6, 0x11, 0x39, 0x02, 0x40,
  0x30, 0xE5, 0x07, 0x0B, 0x50, 0xAB, 0x0A, 0x20,
  // "ě" (U+011B)
  0x30, 0x52, 0x06, 0x38, 0x27, 0x9A, 0x53, 0x81, 0x1F, 0x97, 0x38, 0x26, 0xDE, 0x72, 0x83, 0x5C,
  0x25, 0xD2, 0x89, 0x1D, 0x31, 0xAA, 0x04, 0xFE, 0xE8, 0x20, 0x70, 0xB5, 0x07, 0x0B, 0x58, 0x35,
  0xE3, 0x14, 0x38, 0x29, 0xEE, 0x82,
  // "Ĝ" (U+011C)
  0x50, 0x40, 0x56, 0x82, 0x3D, 0xE1, 0x48, 0x31, 0xB2, 0x67, 0x77, 0x71, 0x84, 0x4B, 0xEE, 0xB2,
  0x28, 0x46, 0xE6, 0x11, 0x52, 0x81, 0x2F, 0x46, 0x0A, 0x0B, 0x79, 0x89, 0x05, 0x03, 0xEE, 0x70,
  0x3F, 0x12, 0x83, 0x1E, 0x50, 0x49, 0x38, 0x51, 0xF1, 0x02, 0xF1, 0x20, 0x40, 0xE3, 0x84, 0xDA,
  0x11, 0x9A, 0x38, 0x42, 0xBE, 0xEC, 0x42,
  // "ĝ" (U+011D)
  0x50, 0x40, 0x55, 0x82, 0x3D, 0xE1, 0x38, 0x31, 0xB2, 0x67, 0x74, 0x83, 0x6E, 0xD5, 0xC2, 0x84,
  0x5E, 0x33, 0xE8, 0x20, 0xD0, 0x62, 0x98, 0x92, 0x50, 0x2F, 0x10, 0x1F, 0x10, 0x6C, 0x20, 0x50,
  0xD2, 0x07, 0x0B, 0x20, 0xB0, 0xA2, 0x84, 0x6D, 0x17, 0xF6, 0x28, 0x41, 0xCE, 0x7E, 0x35, 0x03,
  0x0E, 0x38, 0x33, 0x02, 0xC7, 0x28, 0x31, 0xCE, 0xD8, 0x30,
  // "Ğ" (U+011E)
  0x48, 0x2D, 0x26, 0x95, 0x82, 0x7E, 0xB1, 0x77, 0x71, 0x84, 0x4B, 0xEE, 0xB2, 0x28, 0x46, 0xE6,
  0x11, 0x52, 0x81, 0x2F, 0x46, 0x0A, 0x0B, 0x79, 0x89, 0x05, 0x03, 0xEE, 0x70, 0x3F, 0x12, 0x83,
  0x1E, 0x50, 0x49, 0x38, 0x51, 0xF1, 0x02, 0xF1, 0x20, 0x40, 0xE3, 0x84, 0xDA, 0x11, 0x9A, 0x38,
  0x42, 0xBE, 0xEC, 0x42,
  // "ğ" (U+011F)
  0x48, 0x2D, 0x26, 0x94, 0x82, 0x7E, 0xB1, 0x74, 0x83, 0x6E, 0xD5, 0xC2, 0x84, 0x5E, 0x33, 0xE8,
  0x20, 0xD0, 0x62, 0x98, 0x92, 0x50, 0x2F, 0x10, 0x1F, 0x10, 0x6C, 0x20, 0x50, 0xD2, 0x07, 0x0B,
  0x20, 0xB0, 0xA2, 0x84, 0x6D, 0x17, 0xF6, 0x28, 0x41, 0xCE, 0x7E, 0x35, 0x03, 0x0E, 0x38, 0x33,
  0x02, 0xC7, 0x28, 0x31, 0xCE, 0xD8, 0x30,
  // "Ġ" (U+0120)
  0x60, 0xC0, 0x37, 0x77, 0x73, 0x84, 0x4B, 0xEE, 0xB2, 0x28, 0x46, 0xE6, 0x11, 0x52, 0x81, 0x2F,
  0x46, 0x0A, 0x0B, 0x79, 0x89, 0x05, 0x03, 0xEE, 0x70, 0x3F, 0x12, 0x83, 0x1E, 0x50, 0x49, 0x38,
  0x51, 0xF1, 0x02, 0xF1, 0x20, 0x40, 0xE3, 0x84, 0xDA, 0x11, 0x9A, 0x38, 0x42, 0xBE, 0xEC, 0x42,
  // "ġ" (U+0121)
  0x50, 0xC0, 0x37, 0x76, 0x83, 0x6E, 0xD5, 0xC2, 0x84, 0x5E, 0x33, 0xE8, 0x20, 0xD0, 0x62, 0x98,
  0x92, 0x50, 0x2F, 0x10, 0x1F, 0x10, 0x6C, 0x20, 0x50, 0xD2, 0x07, 0x0B, 0x20, 0xB0, 0xA2, 0x84,
  0x6D, 0x17, 0xF6, 0x28, 0x41, 0xCE, 0x7E, 0x35, 0x03, 0x0E, 0x38, 0x33, 0x02, 0xC7, 0x28, 0x31,
  0xCE, 0xD8, 0x30,
  // "Ģ" (U+0122)
  0x38, 0x44, 0xBE, 0xEB, 0x22, 0x84, 0x6E, 0x61, 0x15, 0x28, 0x12, 0xF4, 0x60, 0xA0, 0xB7, 0x98,
  0x90, 0x50, 0x3E, 0xE7, 0x03, 0xF1, 0x28, 0x31, 0xE5, 0x04, 0x93, 0x85, 0x1F, 0x10, 0x2F, 0x12,
  0x04, 0x0E, 0x38, 0x4D, 0xA1, 0x19, 0xA3, 0x84, 0x2B, 0xEE, 0xC4, 0x50, 0x70, 0x26, 0x03, 0x0D,
  0x70, 0xA0, 0x35,
  // "ģ" (U+0123)
  0x60, 0xB0, 0x25, 0x06, 0x0A, 0x60, 0x60, 0x24, 0x83, 0x6E, 0xD5, 0xC2, 0x84, 0x5E, 0x33, 0xE8,
  0x20, 0xD0, 0x62, 0x98, 0x92, 0x50, 0x2F, 0x10, 0x1F, 0x10, 0x6C, 0x20, 0x50, 0xD2, 0x07, 0x0B,
  0x20, 0xB0, 0xA2, 0x84, 0x6D, 0x17, 0xF6, 0x28, 0x41, 0xCE, 0x7E, 0x35, 0x03, 0x0E, 0x38, 0x33,
  0x02, 0xC7, 0x28, 0x31, 0xCE, 0xD8, 0x30,
  // "Ĥ" (U+0124)
  0x50, 0x40, 0x56, 0x82, 0x3D, 0xE1, 0x48, 0x31, 0xB2, 0x67, 0x77, 0x70, 0xA0, 0x83, 0x0E, 0x04,
  0x20, 0xD0, 0x52, 0x03, 0x92, 0x81, 0x1F, 0x12, 0x07, 0x0C, 0x20, 0x50, 0xD3, 0x0A, 0x09, 0x28,
  0x58, 0xFE, 0xEE, 0xF5, 0x28, 0x5C, 0x72, 0x24, 0xF2, 0x29, 0x02, 0x20, 0x50, 0xE2, 0x03, 0x0E,
  0x30, 0x90, 0xA2, 0x07, 0x0B, 0x30, 0xC0, 0x72, 0x0A, 0x08, 0x39, 0x03, 0x20,
  // "ĥ" (U+0125)
  0x30, 0x40, 0x54, 0x82, 0x3D, 0xE1, 0x28, 0x31, 0xB2, 0x67, 0x73, 0x00, 0x95, 0x0C, 0x06, 0x59,
  0x02, 0x48, 0x96, 0x3E, 0x7E, 0xC1, 0x07, 0xE6, 0x1E, 0x50, 0xAA, 0x28, 0xA0, 0xE4, 0x0D, 0x50,
  0x2F, 0x11, 0xF1, 0x05, 0xD0, 0x5D, 0x28, 0x38, 0x90, 0x8A, 0x28, 0x3C, 0x60, 0xB6, 0x29, 0x03,
  0x10,
  // "Ħ" (U+0126)
  0x20, 0xB0, 0x72, 0x89, 0x41, 0xF3, 0x2E, 0xFE, 0xEE, 0xEF, 0xD0, 0x39, 0x30, 0x80, 0xA2, 0x07,
  0x0C, 0x30, 0xB0, 0x72, 0x85, 0xAF, 0xEE, 0xEF, 0x32, 0x83, 0xD6, 0x11, 0x39, 0x28, 0x11, 0xF2,
  0x20, 0x50, 0xD2, 0x04, 0x0E, 0x30, 0x09, 0x20, 0x70, 0xB3, 0x0C, 0x06, 0x20, 0xB0, 0x83, 0x90,
  0x32,
  // "ħ" (U+0127)
  0x20, 0x09, 0x48, 0x3B, 0xFE, 0xE1, 0x39, 0x01, 0x48, 0x34, 0xD7, 0xEC, 0x28, 0x77, 0xE5, 0x1F,
  0x40, 0xAA, 0x28, 0xA0, 0xE3, 0x0E, 0x50, 0x2F, 0x11, 0xF1, 0x05, 0xD0, 0x5D, 0x28, 0x38, 0x90,
  0x8A, 0x28, 0x3C, 0x60, 0xB6, 0x29, 0x03, 0x10,
  // "Ĩ" (U+0128)
  0x38, 0x38, 0xC3, 0x64, 0x28, 0x32, 0xA4, 0xDD, 0x77, 0x58, 0x34, 0xEF, 0xB1, 0x40, 0x80, 0xA6,
  0x0B, 0x07, 0x69, 0x03, 0x50, 0x39, 0x60, 0x70, 0xC6, 0x0A, 0x08, 0x60, 0xD0, 0x55, 0x81, 0x1F,
  0x14, 0x82, 0x5D, 0xFB, 0x40,
  // "ĩ" (U+0129)
  0x18, 0x90, 0x8C, 0x36, 0x42, 0xA4, 0xDD, 0x71, 0x04, 0x0E, 0x40, 0x70, 0xA4, 0x0B, 0x07, 0x40,
  0xE0, 0x43, 0x81, 0x2F, 0x13, 0x05, 0x0D, 0x40, 0x80, 0x94, 0x0B, 0x06, 0x40,
  // "Ī" (U+012A)
  0x28, 0x32, 0xEE, 0xE7, 0x30, 0xF1, 0x73, 0x83, 0x4E, 0xFB, 0x13, 0x08, 0x0A, 0x50, 0xB0, 0x75,
  0x90, 0x34, 0x03, 0x95, 0x07, 0x0C, 0x50, 0xA0, 0x85, 0x0D, 0x05, 0x48, 0x11, 0xF1, 0x38, 0x25,
  0xDF, 0xB3,
  // "ī" (U+012B)
  0x83, 0x2E, 0xEE, 0x71, 0x0F, 0x12, 0x04, 0x0E, 0x30, 0x70, 0xA3, 0x0B, 0x07, 0x30, 0xE0, 0x42,
  0x81, 0x2F, 0x12, 0x05, 0x0D, 0x30, 0x80, 0x93, 0x0B, 0x06, 0x30,
  // "Ĭ" (U+012C)
  0x38, 0x2D, 0x26, 0x93, 0x82, 0x7E, 0xB1, 0x77, 0x28, 0x34, 0xEF, 0xB1, 0x30, 0x80, 0xA5, 0x0B,
  0x07, 0x59, 0x03, 0x40, 0x39, 0x50, 0x70, 0xC5, 0x0A, 0x08, 0x50, 0xD0, 0x54, 0x81, 0x1F, 0x13,
  0x82, 0x5D, 0xFB, 0x30,
  // "ĭ" (U+012D)
  0x18, 0x7D, 0x26, 0x90, 0x7E, 0xB1, 0x60, 0x40, 0xE3, 0x07, 0x0A, 0x30, 0xB0, 0x73, 0x0E, 0x04,
  0x28, 0x12, 0xF1, 0x20, 0x50, 0xD3, 0x08, 0x09, 0x30, 0xB0, 0x63,
  // "Į" (U+012E)
  0x28, 0x34, 0xEF, 0xB1, 0x30, 0x80, 0xA5, 0x0B, 0x07, 0x59, 0x03, 0x40, 0x39, 0x50, 0x70, 0xC5,
  0x0A, 0x08, 0x50, 0xD0, 0x54, 0x81, 0x1F, 0x13, 0x05, 0xA0, 0xB3, 0x02, 0x0B, 0x50, 0x90, 0x75,
  0x81, 0x7F, 0x55, 0x01, 0x50,
  // "į" (U+012F)
  0x30, 0x90, 0x67, 0x50, 0x40, 0xE3, 0x07, 0x0A, 0x30, 0xB0, 0x73, 0x0E, 0x04, 0x28, 0x12, 0xF1,
  0x20, 0x50, 0xD3, 0x08, 0x09, 0x30, 0xE0, 0x92, 0x02, 0x0B, 0x30, 0x90, 0x73, 0x81, 0x7F, 0x53,
  0x01, 0x30,
  // "İ" (U+0130)
  0x40, 0xC0, 0x37, 0x77, 0x38, 0x34, 0xEF, 0xB1, 0x30, 0x80, 0xA5, 0x0B, 0x07, 0x59, 0x03, 0x40,
  0x39, 0x50, 0x70, 0xC5, 0x0A, 0x08, 0x50, 0xD0, 0x54, 0x81, 0x1F, 0x13, 0x82, 0x5D, 0xFB, 0x30,
  // "ı" (U+0131)
  0x18, 0xA4, 0x4E, 0x07, 0xA0, 0xB7, 0x0E, 0x42, 0xF1, 0x5D, 0x08, 0x90, 0xB6, 0x10,
  // "Ĳ" (U+0132)
  0x28, 0x54, 0xEF, 0xB1, 0xA9, 0x30, 0x80, 0xA2, 0x0D, 0x05, 0x38, 0x4B, 0x70, 0x1F, 0x23, 0x98,
  0x23, 0x04, 0xE3, 0x03, 0x92, 0x08, 0x0B, 0x30, 0x70, 0xC2, 0x0B, 0x07, 0x30, 0xA0, 0x82, 0x0E,
  0x04, 0x38, 0x4D, 0x50, 0x2F, 0x12, 0x84, 0x1F, 0x10, 0x6D, 0x28, 0x55, 0xDF, 0xB0, 0x99, 0x70,
  0xD0, 0x56, 0x81, 0x4F, 0x14, 0x82, 0x2F, 0xE5, 0x60, 0x15,
  // "ĳ" (U+0133)
  0x28, 0x39, 0x60, 0x96, 0x77, 0x18, 0x34, 0xE0, 0x4E, 0x28, 0x37, 0xA0, 0x7A, 0x28, 0x3B, 0x70,
  0xB7, 0x28, 0x90, 0xE4, 0x0E, 0x30, 0x2F, 0x12, 0x92, 0x83, 0x5D, 0x06, 0xC2, 0x83, 0x89, 0x09,
  0x82, 0x83, 0xB6, 0x0D, 0x54, 0x81, 0x1F, 0x14, 0x07, 0x0C, 0x48, 0x1D, 0xD3, 0x30,
  // "Ĵ" (U+0134)
  0x50, 0x40, 0x55, 0x82, 0x3D, 0xE1, 0x38, 0x31, 0xB2, 0x67, 0x77, 0x70, 0xA0, 0x96, 0x0D, 0x05,
  0x58, 0x11, 0xF2, 0x50, 0x40, 0xE6, 0x08, 0x0B, 0x60, 0xB0, 0x76, 0x0E, 0x04, 0x58, 0x12, 0xF1,
  0x50, 0x60, 0xD6, 0x00, 0x96, 0x0D, 0x05, 0x58, 0x14, 0xF1, 0x38, 0x22, 0xFE, 0x55, 0x01, 0x60,
  // "ĵ" (U+0135)
  0x40, 0x40, 0x54, 0x82, 0x3D, 0xE1, 0x28, 0x31, 0xB2, 0x67, 0x73, 0x04, 0x0E, 0x50, 0x70, 0xA5,
  0x0B, 0x07, 0x50, 0xE0, 0x34, 0x02, 0x95, 0x06, 0x0C, 0x50, 0x90, 0x85, 0x0D, 0x05, 0x48, 0x11,
  0xF1, 0x40, 0x70, 0xC4, 0x81, 0xDD, 0x34,
  // "Ķ" (U+0136)
  0x20, 0xA0, 0x82, 0x0B, 0x09, 0x28, 0x3D, 0x50, 0x9B, 0x28, 0x41, 0xF1, 0x7D, 0x12, 0x83, 0x5D,
  0x5E, 0x23, 0x82, 0x9C, 0xE6, 0x48, 0x2C, 0xDC, 0x84, 0x98, 0x13, 0x6D, 0x38, 0x43, 0xF0, 0x2F,
  0x22, 0x07, 0x0B, 0x20, 0xD0, 0x62, 0x0A, 0x08, 0x20, 0x90, 0xB4, 0x07, 0x02, 0x50, 0x30, 0xD6,
  0x0A, 0x03, 0x50,
  // "ķ" (U+0137)
  0x20, 0x80, 0x95, 0x0C, 0x06, 0x59, 0x02, 0x48, 0x92, 0x3E, 0x02, 0xE3, 0x06, 0xB1, 0xD5, 0x28,
  0x2A, 0x7B, 0x83, 0x0D, 0x0C, 0x93, 0x83, 0x1F, 0x9F, 0x32, 0x83, 0x5D, 0x0C, 0x72, 0x83, 0x89,
  0x08, 0xB2, 0x83, 0xB6, 0x04, 0xE4, 0x07, 0x02, 0x40, 0x30, 0xD5, 0x0A, 0x03, 0x40,
  // "ĸ" (U+0138)
  0x18, 0x92, 0x4E, 0x02, 0xE3, 0x07, 0xB1, 0xD5, 0x28, 0x2B, 0x7B, 0x83, 0x0E, 0x0C, 0x93, 0x83,
  0x2F, 0x9F, 0x32, 0x83, 0x5D, 0x0C, 0x72, 0x83, 0x89, 0x08, 0xB2, 0x83, 0xB6, 0x04, 0xE2,
  // "Ĺ" (U+0139)
  0x50, 0x60, 0x54, 0x81, 0x4D, 0x23, 0x81, 0x1C, 0x27, 0x73, 0x0A, 0x08, 0x50, 0xD0, 0x54, 0x81,
  0x1F, 0x14, 0x05, 0x0D, 0x50, 0x90, 0xA5, 0x0C, 0x06, 0x59, 0x03, 0x40, 0x30, 0xE5, 0x07, 0x0C,
  0x0F, 0x12, 0x0A, 0xB0, 0x92,
  // "ĺ" (U+013A)
  0x40, 0x60, 0x53, 0x81, 0x4D, 0x22, 0x81, 0x1C, 0x27, 0x20, 0x80, 0x94, 0x0C, 0x06, 0x49, 0x03,
  0x30, 0x30, 0xE4, 0x06, 0x0B, 0x40, 0xA0, 0x84, 0x0D, 0x04, 0x38, 0x11, 0xF1, 0x30, 0x50, 0xD4,
  0x08, 0x09, 0x40, 0xB0, 0x64,
  // "Ļ" (U+013B)
  0x20, 0xA0, 0x83, 0x0D, 0x05, 0x28, 0x11, 0xF1, 0x20, 0x50, 0xD3, 0x09, 0x0A, 0x30, 0xC0, 0x63,
  0x90, 0x32, 0x03, 0x0E, 0x38, 0x47, 0xC1, 0x11, 0xAB, 0x09, 0x20, 0x70, 0x22, 0x03, 0x0D, 0x30,
  0xA0, 0x32,
  // "ļ" (U+013C)
  0x30, 0x80, 0x93, 0x0C, 0x06, 0x39, 0x03, 0x20, 0x30, 0xE3, 0x06, 0x0B, 0x30, 0xA0, 0x83, 0x0D,
  0x04, 0x28, 0x11, 0xF1, 0x20, 0x50, 0xD3, 0x08, 0x09, 0x30, 0xB0, 0x63, 0x07, 0x02, 0x20, 0x30,
  0xD3, 0x0A, 0x03, 0x30,
  // "Ľ" (U+013D)
  0x28, 0x3A, 0x81, 0xF2, 0x28, 0x2D, 0x56, 0x92, 0x82, 0x1F, 0x15, 0x30, 0x50, 0xD5, 0x09, 0x0A,
  0x50, 0xC0, 0x65, 0x90, 0x34, 0x03, 0x0E, 0x50, 0x70, 0xC0, 0xF1, 0x20, 0xAB, 0x09, 0x20,
  // "ľ" (U+013E)
  0x28, 0x38, 0x91, 0xF2, 0x28, 0x2C, 0x66, 0x93, 0x90, 0x30, 0x53, 0x03, 0x0E, 0x50, 0x60, 0xB5,
  0x0A, 0x08, 0x50, 0xD0, 0x44, 0x81, 0x1F, 0x14, 0x05, 0x0D, 0x50, 0x80, 0x95, 0x0B, 0x06, 0x50,
  // "Ŀ" (U+013F)
  0x20, 0xA0, 0x84, 0x0D, 0x05, 0x38, 0x11, 0xF1, 0x30, 0x50, 0xD4, 0x86, 0x9A, 0x0C, 0x30, 0xC6,
  0x49, 0x03, 0x30, 0x30, 0xE4, 0x85, 0x7C, 0x11, 0x10, 0xAB, 0x09, 0x10,
  // "ŀ" (U+0140)
  0x20, 0x80, 0x93, 0x0C, 0x06, 0x39, 0x03, 0x20, 0x30, 0xE3, 0x06, 0x0B, 0x38, 0x5A, 0x8C, 0x30,
  0xD4, 0x28, 0x11, 0xF1, 0x20, 0x50, 0xD3, 0x08, 0x09, 0x30, 0xB0, 0x63,
  // "Ł" (U+0141)
  0x20, 0x90, 0xA3, 0x0C, 0x06, 0x28, 0x11, 0xF3, 0x28, 0x92, 0x4E, 0x12, 0x07, 0xED, 0x55, 0xEA,
  0x28, 0x18, 0xF4, 0x20, 0x29, 0x38, 0x46, 0xD1, 0x11, 0x9B, 0x0A,
  // "ł" (U+0142)
  0x20, 0x70, 0xB2, 0x0B, 0x07, 0x28, 0x97, 0xE4, 0x02, 0xF1, 0x05, 0xE9, 0x1B, 0xD5, 0xBE, 0x62,
  0x98, 0x22, 0x03, 0xE2, 0x07, 0x0B, 0x20, 0xA0, 0x72,
  // "Ń" (U+0143)
  0x60, 0x60, 0x56, 0x81, 0x4D, 0x25, 0x81, 0x1C, 0x27, 0x77, 0x10, 0xA9, 0x30, 0x70, 0xB2, 0x81,
  0xDF, 0x32, 0x85, 0xA7, 0x01, 0xFA, 0x72, 0x87, 0xE4, 0x05, 0xC6, 0xB0, 0x29, 0x28, 0x59, 0x92,
  0xE0, 0x6C, 0x28, 0x5C, 0x50, 0xE3, 0x99, 0x29, 0x87, 0x20, 0xA7, 0xC5, 0x03, 0xE2, 0x85, 0x7B,
  0xF1, 0x07, 0xA2, 0x81, 0x3F, 0xD2, 0x0A, 0x07, 0x30, 0xE0, 0xA2,
  // "ń" (U+0144)
  0x50, 0x60, 0x54, 0x81, 0x4D, 0x23, 0x81, 0x1C, 0x27, 0x28, 0x96, 0x4B, 0x7E, 0xC1, 0x07, 0xE6,
  0x1E, 0x50, 0xBA, 0x28, 0xA0, 0xE4, 0x0E, 0x50, 0x2F, 0x12, 0xF1, 0x05, 0xD0, 0x5D, 0x28, 0x39,
  0xA0, 0x9A, 0x28, 0x3C, 0x60, 0xC6, 0x29, 0x03, 0x10,
  // "Ņ" (U+0145)
  0x20, 0xA9, 0x30, 0x70, 0xB2, 0x81, 0xDF, 0x32, 0x85, 0xA7, 0x01, 0xFA, 0x72, 0x87, 0xE4, 0x05,
  0xC6, 0xB0, 0x29, 0x28, 0x59, 0x92, 0xE0, 0x6C, 0x28, 0x5C, 0x50, 0xE3, 0x99, 0x29, 0x87, 0x20,
  0xA7, 0xC5, 0x03, 0xE2, 0x85, 0x7B, 0xF1, 0x07, 0xA2, 0x81, 0x3F, 0xD2, 0x0A, 0x07, 0x30, 0xE0,
  0xA5, 0x07, 0x02, 0x60, 0x30, 0xD7, 0x0A, 0x03, 0x50,
  // "ņ" (U+0146)
  0x18, 0x96, 0x4B, 0x7E, 0xC1, 0x07, 0xE6, 0x1E, 0x50, 0xBA, 0x28, 0xA0, 0xE4, 0x0E, 0x50, 0x2F,
  0x12, 0xF1, 0x05, 0xD0, 0x5D, 0x28, 0x39, 0xA0, 0x9A, 0x28, 0x3C, 0x60, 0xC6, 0x29, 0x03, 0x30,
  0x70, 0x24, 0x03, 0x0D, 0x50, 0xA0, 0x34,
  // "Ň" (U+0147)
  0x40, 0x52, 0x06, 0x58, 0x27, 0x9A, 0x55, 0x81, 0x1F, 0x97, 0x77, 0x10, 0xA9, 0x30, 0x70, 0xB2,
  0x81, 0xDF, 0x32, 0x85, 0xA7, 0x01, 0xFA, 0x72, 0x87, 0xE4, 0x05, 0xC6, 0xB0, 0x29, 0x28, 0x59,
  0x92, 0xE0, 0x6C, 0x28, 0x5C, 0x50, 0xE3, 0x99, 0x29, 0x87, 0x20, 0xA7, 0xC5, 0x03, 0xE2, 0x85,
  0x7B, 0xF1, 0x07, 0xA2, 0x81, 0x3F, 0xD2, 0x0A, 0x07, 0x30, 0xE0, 0xA2,
  // "ň" (U+0148)
  0x30, 0x52, 0x06, 0x38, 0x27, 0x9A, 0x53, 0x81, 0x1F, 0x97, 0x28, 0x96, 0x4B, 0x7E, 0xC1, 0x07,
  0xE6, 0x1E, 0x50, 0xBA, 0x28, 0xA0, 0xE4, 0x0E, 0x50, 0x2F, 0x12, 0xF1, 0x05, 0xD0, 0x5D, 0x28,
  0x39, 0xA0, 0x9A, 0x28, 0x3C, 0x60, 0xC6, 0x29, 0x03, 0x10,
  // "ŉ" (U+0149)
  0x10, 0xE0, 0x55, 0x04, 0x0D, 0x68, 0x96, 0xB5, 0x4B, 0x7E, 0xC1, 0x60, 0x7E, 0x61, 0xE5, 0x20,
  0xB0, 0xA2, 0x0E, 0x04, 0x28, 0x93, 0xE5, 0x02, 0xF1, 0x02, 0xF1, 0x05, 0xD2, 0x05, 0x0D, 0x20,
  0x90, 0xA2, 0x09, 0x0A, 0x20, 0xC0, 0x62, 0x0C, 0x06, 0x29, 0x03, 0x10,
  // "Ŋ" (U+014A)
  0x20, 0xA9, 0x30, 0x70, 0xB2, 0x81, 0xDF, 0x42, 0x85, 0xB7, 0x01, 0xFA, 0x72, 0x87, 0xE4, 0x05,
  0xC5, 0xB0, 0x29, 0x28, 0x59, 0x91, 0xF0, 0x6C, 0x28, 0x5C, 0x50, 0xD4, 0x99, 0x29, 0x87, 0x20,
  0x97, 0xC6, 0x03, 0xE2, 0x85, 0x5C, 0xF2, 0x07, 0xA2, 0x81, 0x1F, 0xE2, 0x0A, 0x07, 0x30, 0xD0,
  0xB7, 0x0C, 0x07, 0x68, 0x13, 0xF2, 0x58, 0x1E, 0xE7, 0x30,
  // "ŋ" (U+014B)
  0x18, 0x96, 0x4B, 0x7E, 0xC1, 0x07, 0xE6, 0x1E, 0x50, 0xBA, 0x28, 0xA0, 0xE3, 0x0E, 0x50, 0x2F,
  0x02, 0xF1, 0x06, 0xC0, 0x5D, 0x28, 0x39, 0x90, 0x8A, 0x28, 0x7D, 0x50, 0xB6, 0x01, 0xF1, 0x40,
  0x40, 0xD5, 0x0A, 0x08, 0x38, 0x22, 0xFC, 0x12,
  // "Ō" (U+014C)
  0x38, 0x32, 0xEE, 0xE7, 0x50, 0xF1, 0x77, 0x83, 0x6D, 0xEC, 0x23, 0x84, 0x8D, 0x31, 0xAC, 0x28,
  0x12, 0xF2, 0x28, 0x43, 0xF1, 0x0A, 0xA3, 0x84, 0x2F, 0x10, 0xE5, 0x38, 0x44, 0xF0, 0x2F, 0x23,
  0x82, 0x7C, 0x04, 0x94, 0x84, 0xC7, 0x03, 0xF1, 0x28, 0x15, 0xE1, 0x28, 0x4E, 0x80, 0x4E, 0x63,
  0x83, 0x4C, 0xFD, 0x53,
  // "ō" (U+014D)
  0x28, 0x32, 0xEE, 0xE7, 0x30, 0xF1, 0x38, 0x26, 0xEE, 0x72, 0x87, 0x5E, 0x23, 0xF2, 0x0D, 0x52,
  0x82, 0xE4, 0x3E, 0x39, 0x81, 0x36, 0xC2, 0x83, 0x3F, 0x17, 0xB2, 0x87, 0x8A, 0x05, 0xE1, 0x4E,
  0x32, 0x82, 0x9E, 0xD4, 0x20,
  // "Ŏ" (U+014E)
  0x48, 0x2D, 0x26, 0x95, 0x82, 0x7E, 0xB1, 0x77, 0x71, 0x83, 0x6D, 0xEC, 0x23, 0x84, 0x8D, 0x31,
  0xAC, 0x28, 0x12, 0xF2, 0x28, 0x43, 0xF1, 0x0A, 0xA3, 0x84, 0x2F, 0x10, 0xE5, 0x38, 0x44, 0xF0,
  0x2F, 0x23, 0x82, 0x7C, 0x04, 0x94, 0x84, 0xC7, 0x03, 0xF1, 0x28, 0x15, 0xE1, 0x28, 0x4E, 0x80,
  0x4E, 0x63, 0x83, 0x4C, 0xFD, 0x53,
  // "ŏ" (U+014F)
  0x38, 0x2D, 0x26, 0x93, 0x82, 0x7E, 0xB1, 0x72, 0x82, 0x6E, 0xE7, 0x28, 0x75, 0xE2, 0x3F, 0x20,
  0xD5, 0x28, 0x2E, 0x43, 0xE3, 0x98, 0x13, 0x6C, 0x28, 0x33, 0xF1, 0x7B, 0x28, 0x78, 0xA0, 0x5E,
  0x14, 0xE3, 0x28, 0x29, 0xED, 0x42,
  // "Ő" (U+0150)
  0x50, 0xF1, 0x02, 0x48, 0x32, 0xD3, 0xC6, 0x38, 0x31, 0xA2, 0x95, 0x77, 0x71, 0x83, 0x6D, 0xEC,
  0x23, 0x84, 0x8D, 0x31, 0xAC, 0x28, 0x12, 0xF2, 0x28, 0x43, 0xF1, 0x0A, 0xA3, 0x84, 0x2F, 0x10,
  0xE5, 0x38, 0x44, 0xF0, 0x2F, 0x23, 0x82, 0x7C, 0x04, 0x94, 0x84, 0xC7, 0x03, 0xF1, 0x28, 0x15,
  0xE1, 0x28, 0x4E, 0x80, 0x4E, 0x63, 0x83, 0x4C, 0xFD, 0x53,
  // "ő" (U+0151)
  0x40, 0xF1, 0x02, 0x38, 0x32, 0xD3, 0xC6, 0x28, 0x31, 0xA2, 0x95, 0x74, 0x82, 0x6E, 0xE7, 0x38,
  0x45, 0xE2, 0x3F, 0x22, 0x0D, 0x05, 0x28, 0x3E, 0x40, 0x3E, 0x39, 0x82, 0x30, 0x6C, 0x28, 0x43,
  0xF1, 0x07, 0xB2, 0x08, 0x0A, 0x28, 0x45, 0xE1, 0x4E, 0x33, 0x82, 0x9E, 0xD4, 0x30,
  // "Œ" (U+0152)
  0x30, 0x70, 0xDD, 0x07, 0x28, 0x49, 0xD3, 0x1F, 0x24, 0x84, 0x3F, 0x20, 0x4E, 0x50, 0x0A, 0x20,
  0x70, 0xA5, 0x0E, 0x05, 0x28, 0x7B, 0xFE, 0xE5, 0x02, 0xF1, 0x28, 0x2E, 0x41, 0x12, 0x04, 0x92,
  0x03, 0x95, 0x84, 0x3F, 0x10, 0x6C, 0x68, 0x3E, 0x80, 0xA9, 0x60, 0x30, 0xCD, 0x07, 0x20,
  // "œ" (U+0153)
  0x28, 0x66, 0xEE, 0x52, 0xCE, 0xA2, 0x89, 0x35, 0xD2, 0x3E, 0xD5, 0x1F, 0x30, 0xD5, 0x28, 0x5E,
  0x70, 0x6E, 0x03, 0x93, 0x98, 0x5E, 0xEA, 0x20, 0x6C, 0x28, 0x13, 0xF1, 0x40, 0x70, 0xB2, 0x08,
  0x95, 0x89, 0x05, 0xE1, 0x4D, 0xD6, 0x04, 0x12, 0x87, 0x9E, 0xC2, 0x4D, 0xEB, 0x11,
  // "Ŕ" (U+0154)
  0x60, 0x60, 0x55, 0x81, 0x4D, 0x24, 0x81, 0x1C, 0x27, 0x75, 0x0A, 0xA0, 0xC0, 0x23, 0x83, 0xD5,
  0x1A, 0xC2, 0x84, 0x1F, 0x20, 0x5E, 0x20, 0x50, 0xE2, 0x07, 0x0C, 0x28, 0x49, 0xB0, 0x3E, 0x62,
  0x83, 0xCF, 0xEE, 0x63, 0x98, 0x15, 0x7D, 0x38, 0x43, 0xF0, 0x2F, 0x22, 0x07, 0x0C, 0x20, 0xD0,
  0x62, 0x0A, 0x08, 0x20, 0x90, 0xB2,
  // "ŕ" (U+0155)
  0x40, 0x60, 0x53, 0x81, 0x4D, 0x22, 0x81, 0x1C, 0x27, 0x18, 0x90, 0x4B, 0x8F, 0x20, 0x7E, 0x61,
  0x20, 0xB0, 0xA4, 0x0E, 0x05, 0x38, 0x12, 0xF1, 0x30, 0x50, 0xD4, 0x08, 0x0A, 0x40, 0xB0, 0x64,
  // "Ŗ" (U+0156)
  0x20, 0xAA, 0x0C, 0x02, 0x28, 0x95, 0xD5, 0x1A, 0xC0, 0x1F, 0x20, 0x5E, 0x05, 0xE2, 0x89, 0x57,
  0xC0, 0x9B, 0x03, 0xE6, 0x0C, 0xFE, 0xE6, 0x29, 0x81, 0x57, 0xD2, 0x87, 0x3F, 0x02, 0xF2, 0x07,
  0xC2, 0x83, 0xD6, 0x0A, 0x82, 0x09, 0x0B, 0x30, 0x70, 0x24, 0x03, 0x0D, 0x50, 0xA0, 0x34,
  // "ŗ" (U+0157)
  0x18, 0x90, 0x4B, 0x8F, 0x20, 0x7E, 0x61, 0x20, 0xB0, 0xA4, 0x0E, 0x05, 0x38, 0x12, 0xF1, 0x30,
  0x50, 0xD4, 0x08, 0x0A, 0x40, 0xB0, 0x65, 0x07, 0x02, 0x30, 0x30, 0xD4, 0x0A, 0x03, 0x40,
  // "Ř" (U+0158)
  0x30, 0x52, 0x06, 0x38, 0x27, 0x9A, 0x53, 0x81, 0x1F, 0x97, 0x73, 0x0A, 0xA0, 0xC0, 0x22, 0x89,
  0x5D, 0x51, 0xAC, 0x01, 0xF2, 0x05, 0xE0, 0x5E, 0x28, 0x95, 0x7C, 0x09, 0xB0, 0x3E, 0x60, 0xCF,
  0xEE, 0x62, 0x98, 0x15, 0x7D, 0x28, 0x73, 0xF0, 0x2F, 0x20, 0x7C, 0x28, 0x3D, 0x60, 0xA8, 0x20,
  0x90, 0xB1,
  // "ř" (U+0159)
  0x20, 0x52, 0x06, 0x28, 0x27, 0x9A, 0x52, 0x81, 0x1F, 0x97, 0x18, 0x90, 0x4B, 0x8F, 0x20, 0x7E,
  0x61, 0x20, 0xB0, 0xA4, 0x0E, 0x05, 0x38, 0x12, 0xF1, 0x30, 0x50, 0xD4, 0x08, 0x0A, 0x40, 0xB0,
  0x64,
  // "Ś" (U+015A)
  0x60, 0x60, 0x55, 0x81, 0x4D, 0x24, 0x81, 0x1C, 0x27, 0x76, 0x83, 0x7D, 0xFD, 0x52, 0x84, 0x6E,
  0x30, 0x42, 0x20, 0xA0, 0x96, 0x09, 0x0C, 0x68, 0x22, 0xEB, 0x15, 0x81, 0x1D, 0xC6, 0x81, 0x2F,
  0x46, 0x90, 0x42, 0x89, 0x35, 0x11, 0x8E, 0x10, 0x1C, 0xEE, 0xB2, 0x20,
  // "ś" (U+015B)
  0x40, 0x60, 0x53, 0x81, 0x4D, 0x22, 0x81, 0x1C, 0x27, 0x18, 0x90, 0x4D, 0xEC, 0x10, 0xE6, 0x14,
  0x29, 0x03, 0x48, 0x19, 0xD2, 0x48, 0x19, 0xD1, 0x49, 0x89, 0x24, 0x04, 0x04, 0xF2, 0x0C, 0xFD,
  0x62,
  // "Ŝ" (U+015C)
  0x50, 0x40, 0x55, 0x82, 0x3D, 0xE1, 0x38, 0x31, 0xB2, 0x67, 0x77, 0x58, 0x37, 0xDF, 0xD5, 0x28,
  0x46, 0xE3, 0x04, 0x22, 0x0A, 0x09, 0x60, 0x90, 0xC6, 0x82, 0x2E, 0xB1, 0x58, 0x11, 0xDC, 0x68,
  0x12, 0xF4, 0x69, 0x04, 0x28, 0x93, 0x51, 0x18, 0xE1, 0x01, 0xCE, 0xEB, 0x22,
  // "ŝ" (U+015D)
  0x30, 0x40, 0x53, 0x89, 0x03, 0xDE, 0x10, 0x1B, 0x26, 0x77, 0x89, 0x04, 0xDE, 0xC1, 0x0E, 0x61,
  0x42, 0x90, 0x34, 0x81, 0x9D, 0x24, 0x81, 0x9D, 0x14, 0x98, 0x92, 0x40, 0x40, 0x4F, 0x20, 0xCF,
  0xD6, 0x20,
  // "Ş" (U+015E)
  0x38, 0x37, 0xDF, 0xD5, 0x28, 0x46, 0xE3, 0x04, 0x22, 0x0A, 0x09, 0x60, 0x90, 0xC6, 0x82, 0x2E,
  0xB1, 0x58, 0x11, 0xDC, 0x68, 0x12, 0xF4, 0x69, 0x04, 0x28, 0x93, 0x51, 0x18, 0xE1, 0x01, 0xCE,
  0xEB, 0x24, 0x06, 0x68, 0x11, 0xB4, 0x58, 0x12, 0x89, 0x48, 0x21, 0xDB, 0x14,
  // "ş" (U+015F)
  0x28, 0x34, 0xDE, 0xC1, 0x28, 0x2E, 0x61, 0x43, 0x90, 0x35, 0x81, 0x9D, 0x25, 0x81, 0x9D, 0x15,
  0x90, 0x42, 0x83, 0x40, 0x4F, 0x22, 0x82, 0xCF, 0xD6, 0x40, 0x65, 0x81, 0x1B, 0x44, 0x81, 0x28,
  0x93, 0x82, 0x1D, 0xB1, 0x30,
  // "Š" (U+0160)
  0x40, 0x52, 0x06, 0x48, 0x27, 0x9A, 0x54, 0x81, 0x1F, 0x97, 0x76, 0x83, 0x7D, 0xFD, 0x52, 0x84,
  0x6E, 0x30, 0x42, 0x20, 0xA0, 0x96, 0x09, 0x0C, 0x68, 0x22, 0xEB, 0x15, 0x81, 0x1D, 0xC6, 0x81,
  0x2F, 0x46, 0x90, 0x42, 0x89, 0x35, 0x11, 0x8E, 0x10, 0x1C, 0xEE, 0xB2, 0x20,
  // "š" (U+0161)
  0x20, 0x52, 0x06, 0x28, 0x27, 0x9A, 0x52, 0x81, 0x1F, 0x97, 0x18, 0x90, 0x4D, 0xEC, 0x10, 0xE6,
  0x14, 0x29, 0x03, 0x48, 0x19, 0xD2, 0x48, 0x19, 0xD1, 0x49, 0x89, 0x24, 0x04, 0x04, 0xF2, 0x0C,
  0xFD, 0x62,
  // "Ţ" (U+0162)
  0x20, 0x9C, 0x0E, 0x40, 0xB0, 0x86, 0x0E, 0x05, 0x58, 0x12, 0xF1, 0x50, 0x50, 0xD6, 0x00, 0x96,
  0x0D, 0x06, 0x58, 0x11, 0xF2, 0x50, 0x40, 0xE6, 0x07, 0x0B, 0x60, 0x66, 0x81, 0x1B, 0x45, 0x81,
  0x28, 0x94, 0x82, 0x1D, 0xB1, 0x40,
  // "ţ" (U+0163)
  0x30, 0x80, 0x54, 0x0E, 0x02, 0x20, 0x10, 0xDA, 0x05, 0x20, 0x70, 0xB4, 0x0A, 0x07, 0x40, 0xE0,
  0x43, 0x81, 0x2F, 0x13, 0x05, 0x0D, 0x48, 0x17, 0xC1, 0x38, 0x13, 0xEE, 0x40, 0x64, 0x81, 0x1B,
  0x43, 0x81, 0x28, 0x92, 0x82, 0x1D, 0xB1, 0x20,
  // "Ť" (U+0164)
  0x20, 0x52, 0x06, 0x28, 0x27, 0x9A, 0x52, 0x81, 0x1F, 0x97, 0x60, 0x9C, 0x0E, 0x20, 0xB0, 0x84,
  0x0E, 0x05, 0x38, 0x12, 0xF1, 0x30, 0x50, 0xD4, 0x00, 0x94, 0x0D, 0x06, 0x38, 0x11, 0xF2, 0x30,
  0x40, 0xE4, 0x07, 0x0B, 0x40,
  // "ť" (U+0165)
  0x48, 0x11, 0xF2, 0x28, 0x28, 0x56, 0x93, 0x81, 0xE2, 0x52, 0x01, 0x0D, 0xA0, 0x53, 0x07, 0x0B,
  0x50, 0xA0, 0x75, 0x0E, 0x04, 0x48, 0x12, 0xF1, 0x40, 0x50, 0xD5, 0x81, 0x7C, 0x14, 0x81, 0x3E,
  0xE4,
  // "Ŧ" (U+0166)
  0x09, 0xC0, 0xE2, 0x0B, 0x08, 0x40, 0xE0, 0x43, 0x03, 0x93, 0x89, 0x0D, 0xEF, 0xE5, 0x01, 0xA9,
  0x13, 0x0D, 0x05, 0x38, 0x11, 0xF2, 0x30, 0x40, 0xE4, 0x08, 0x0B, 0x40,
  // "ŧ" (U+0167)
  0x20, 0x80, 0x53, 0x83, 0xE2, 0x01, 0xDA, 0x82, 0x50, 0x7B, 0x30, 0xA0, 0x82, 0x86, 0xAF, 0xEA,
  0x02, 0xF3, 0x20, 0x40, 0xD3, 0x07, 0x0C, 0x38, 0x13, 0xEE, 0x20,
  // "Ũ" (U+0168)
  0x48, 0x38, 0xC3, 0x64, 0x38, 0x32, 0xA4, 0xDD, 0x77, 0x70, 0xB0, 0x73, 0x90, 0x32, 0x0E, 0x03,
  0x20, 0x40, 0xE2, 0x03, 0x93, 0x07, 0x0B, 0x20, 0x60, 0xC3, 0x0B, 0x07, 0x20, 0xA0, 0x83, 0x0E,
  0x04, 0x20, 0xE0, 0x42, 0x03, 0x92, 0x81, 0x2F, 0x12, 0x07, 0x0C, 0x20, 0x49, 0x30, 0xC0, 0x72,
  0x85, 0x2F, 0x52, 0x7E, 0x13, 0x83, 0x6D, 0xFC, 0x33,
  // "ũ" (U+0169)
  0x38, 0x38, 0xC3, 0x64, 0x28, 0x32, 0xA4, 0xDD, 0x73, 0x05, 0x0D, 0x20, 0x80, 0xA2, 0x08, 0x0A,
  0x20, 0xB0, 0x62, 0x0B, 0x07, 0x29, 0x03, 0x28, 0x2E, 0x30, 0x39, 0x20, 0x39, 0x20, 0x70, 0xC2,
  0x06, 0x0C, 0x20, 0xC0, 0x92, 0x84, 0x7D, 0x18, 0xE5, 0x28, 0x42, 0xDE, 0x5D, 0x22,
  // "Ū" (U+016A)
  0x38, 0x32, 0xEE, 0xE7, 0x50, 0xF1, 0x76, 0x0B, 0x07, 0x39, 0x03, 0x20, 0xE0, 0x32, 0x04, 0x0E,
  0x20, 0x39, 0x30, 0x70, 0xB2, 0x06, 0x0C, 0x30, 0xB0, 0x72, 0x0A, 0x08, 0x30, 0xE0, 0x42, 0x0E,
  0x04, 0x20, 0x39, 0x28, 0x12, 0xF1, 0x20, 0x70, 0xC2, 0x04, 0x93, 0x0C, 0x07, 0x28, 0x52, 0xF5,
  0x27, 0xE1, 0x38, 0x36, 0xDF, 0xC3, 0x30,
  // "ū" (U+016B)
  0x28, 0x32, 0xEE, 0xE7, 0x30, 0xF1, 0x20, 0x50, 0xD2, 0x83, 0x8A, 0x08, 0xA2, 0x83, 0xB6, 0x0B,
  0x72, 0x98, 0x73, 0x0E, 0x30, 0x3F, 0x03, 0x92, 0x83, 0x7C, 0x06, 0xC2, 0x89, 0x6C, 0x90, 0x7D,
  0x18, 0xE5, 0x02, 0xDE, 0x5D, 0x21,
  // "Ŭ" (U+016C)
  0x48, 0x2D, 0x26, 0x95, 0x82, 0x7E, 0xB1, 0x77, 0x70, 0xB0, 0x73, 0x90, 0x32, 0x0E, 0x03, 0x20,
  0x40, 0xE2, 0x03, 0x93, 0x07, 0x0B, 0x20, 0x60, 0xC3, 0x0B, 0x07, 0x20, 0xA0, 0x83, 0x0E, 0x04,
  0x20, 0xE0, 0x42, 0x03, 0x92, 0x81, 0x2F, 0x12, 0x07, 0x0C, 0x20, 0x49, 0x30, 0xC0, 0x72, 0x85,
  0x2F, 0x52, 0x7E, 0x13, 0x83, 0x6D, 0xFC, 0x33,
  // "ŭ" (U+016D)
  0x38, 0x2D, 0x26, 0x93, 0x82, 0x7E, 0xB1, 0x71, 0x05, 0x0D, 0x28, 0x38, 0xA0, 0x8A, 0x28, 0x3B,
  0x60, 0xB7, 0x29, 0x87, 0x30, 0xE3, 0x03, 0xF0, 0x39, 0x28, 0x37, 0xC0, 0x6C, 0x28, 0x96, 0xC9,
  0x07, 0xD1, 0x8E, 0x50, 0x2D, 0xE5, 0xD2, 0x10,
  // "Ů" (U+016E)
  0x48, 0x16, 0xD9, 0x68, 0x2C, 0x2B, 0x15, 0x81, 0x9F, 0xC7, 0x77, 0x10, 0xB0, 0x73, 0x90, 0x32,
  0x0E, 0x03, 0x20, 0x40, 0xE2, 0x03, 0x93, 0x07, 0x0B, 0x20, 0x60, 0xC3, 0x0B, 0x07, 0x20, 0xA0,
  0x83, 0x0E, 0x04, 0x20, 0xE0, 0x42, 0x03, 0x92, 0x81, 0x2F, 0x12, 0x07, 0x0C, 0x20, 0x49, 0x30,
  0xC0, 0x72, 0x85, 0x2F, 0x52, 0x7E, 0x13, 0x83, 0x6D, 0xFC, 0x33,
  // "ů" (U+016F)
  0x38, 0x16, 0xD9, 0x48, 0x2C, 0x2B, 0x13, 0x81, 0x9F, 0xC7, 0x20, 0x50, 0xD2, 0x83, 0x8A, 0x08,
  0xA2, 0x83, 0xB6, 0x0B, 0x72, 0x98, 0x73, 0x0E, 0x30, 0x3F, 0x03, 0x92, 0x83, 0x7C, 0x06, 0xC2,
  0x89, 0x6C, 0x90, 0x7D, 0x18, 0xE5, 0x02, 0xDE, 0x5D, 0x21,
  // "Ű" (U+0170)
  0x50, 0xF1, 0x02, 0x48, 0x32, 0xD3, 0xC6, 0x38, 0x31, 0xA2, 0x95, 0x77, 0x70, 0xB0, 0x73, 0x90,
  0x32, 0x0E, 0x03, 0x20, 0x40, 0xE2, 0x03, 0x93, 0x07, 0x0B, 0x20, 0x60, 0xC3, 0x0B, 0x07, 0x20,
  0xA0, 0x83, 0x0E, 0x04, 0x20, 0xE0, 0x42, 0x03, 0x92, 0x81, 0x2F, 0x12, 0x07, 0x0C, 0x20, 0x49,
  0x30, 0xC0, 0x72, 0x85, 0x2F, 0x52, 0x7E, 0x13, 0x83, 0x6D, 0xFC, 0x33,
  // "ű" (U+0171)
  0x40, 0xF1, 0x02, 0x38, 0x32, 0xD3, 0xC6, 0x28, 0x31, 0xA2, 0x95, 0x73, 0x05, 0x0D, 0x20, 0x80,
  0xA2, 0x08, 0x0A, 0x20, 0xB0, 0x62, 0x0B, 0x07, 0x29, 0x03, 0x28, 0x2E, 0x30, 0x39, 0x20, 0x39,
  0x20, 0x70, 0xC2, 0x06, 0x0C, 0x20, 0xC0, 0x92, 0x84, 0x7D, 0x18, 0xE5, 0x28, 0x42, 0xDE, 0x5D,
  0x22,
  // "Ų" (U+0172)
  0x20, 0xB0, 0x73, 0x90, 0x32, 0x0E, 0x03, 0x20, 0x40, 0xE2, 0x03, 0x93, 0x07, 0x0B, 0x20, 0x60,
  0xC3, 0x0B, 0x07, 0x20, 0xA0, 0x83, 0x0E, 0x04, 0x20, 0xE0, 0x42, 0x03, 0x92, 0x81, 0x2F, 0x12,
  0x07, 0x0C, 0x20, 0x49, 0x30, 0xC0, 0x72, 0x85, 0x2F, 0x52, 0x7E, 0x13, 0x06, 0xA0, 0xC0, 0x34,
  0x02, 0x0B, 0x70, 0x90, 0x77, 0x81, 0x7F, 0x57, 0x01, 0x60,
  // "ų" (U+0173)
  0x10, 0x50, 0xD2, 0x83, 0x8A, 0x08, 0xA2, 0x83, 0xB6, 0x0B, 0x72, 0x98, 0x73, 0x0E, 0x30, 0x3F,
  0x03, 0x92, 0x83, 0x7C, 0x06, 0xC2, 0x89, 0x6C, 0x90, 0x7D, 0x18, 0xE5, 0x02, 0xDE, 0x8F, 0x23,
  0x02, 0x0B, 0x50, 0x90, 0x75, 0x81, 0x7F, 0x55, 0x01, 0x30,
  // "Ŵ" (U+0174)
  0x50, 0x40, 0x57, 0x18, 0x23, 0xDE, 0x16, 0x83, 0x1B, 0x26, 0x77, 0x77, 0x40, 0x09, 0x28, 0x12,
  0xF3, 0x28, 0x29, 0xA9, 0x92, 0x81, 0x9F, 0x32, 0x8B, 0x7E, 0x39, 0x80, 0x1E, 0xD3, 0x06, 0xC0,
  0x98, 0x07, 0x9C, 0x30, 0xD5, 0x09, 0x80, 0xD2, 0xC3, 0x4E, 0x28, 0x79, 0x85, 0xB0, 0xD3, 0xB7,
  0x28, 0x79, 0x8C, 0x40, 0xD5, 0xE1, 0x28, 0x1A, 0xAD, 0x28, 0x1D, 0xA9, 0x38, 0x1A, 0xF6, 0x28,
  0x1D, 0xF2, 0x30, 0xA0, 0xE3, 0x0D, 0x0B, 0x40,
  // "ŵ" (U+0175)
  0x50, 0x40, 0x57, 0x82, 0x3D, 0xE1, 0x58, 0x31, 0xB2, 0x67, 0x75, 0x84, 0x1F, 0x10, 0x9E, 0x28,
  0xC6, 0xC6, 0x1F, 0x11, 0xEE, 0x03, 0xE0, 0x1F, 0x17, 0x9E, 0x09, 0x80, 0x1F, 0x1D, 0x3D, 0x0E,
  0x20, 0x1F, 0x5B, 0x1D, 0x6B, 0x28, 0x61, 0xFA, 0x52, 0xDC, 0x42, 0x85, 0x1F, 0xD0, 0x2E, 0xD3,
  0x85, 0x1F, 0x70, 0x2F, 0x73,
  // "Ŷ" (U+0176)
  0x30, 0x40, 0x54, 0x82, 0x3D, 0xE1, 0x28, 0x31, 0xB2, 0x67, 0x77, 0x10, 0x09, 0x28, 0x34, 0xE1,
  0x6C, 0x28, 0x6D, 0x60, 0x4E, 0x07, 0xC2, 0x83, 0x1F, 0x2E, 0x33, 0x81, 0xEC, 0x94, 0x81, 0xCE,
  0x14, 0x0B, 0x07, 0x59, 0x04, 0x40, 0x39, 0x50, 0x70, 0xC5,
  // "ŷ" (U+0177)
  0x50, 0x40, 0x56, 0x82, 0x3D, 0xE1, 0x48, 0x31, 0xB2, 0x67, 0x75, 0x85, 0x1F, 0x10, 0x1F, 0x23,
  0x98, 0x22, 0x08, 0xA4, 0x83, 0xE3, 0x1E, 0x34, 0x82, 0xD3, 0x7A, 0x58, 0x2C, 0x4E, 0x35, 0x81,
  0xBA, 0xA6, 0x81, 0xAF, 0x36, 0x00, 0xA6, 0x81, 0x1E, 0x36, 0x0A, 0x09, 0x58, 0x15, 0xFB, 0x60,
  // "Ÿ" (U+0178)
  0x18, 0x31, 0xC0, 0x95, 0x77, 0x71, 0x00, 0x92, 0x83, 0x4E, 0x16, 0xC2, 0x86, 0xD6, 0x04, 0xE0,
  0x7C, 0x28, 0x31, 0xF2, 0xE3, 0x38, 0x1E, 0xC9, 0x48, 0x1C, 0xE1, 0x40, 0xB0, 0x75, 0x90, 0x44,
  0x03, 0x95, 0x07, 0x0C, 0x50,
  // "Ź" (U+0179)
  0x60, 0x60, 0x55, 0x81, 0x4D, 0x24, 0x81, 0x1C, 0x27, 0x75, 0x03, 0xC0, 0x95, 0x81, 0x4F, 0x25,
  0x0D, 0x07, 0x50, 0x80, 0xC5, 0x81, 0x3F, 0x25, 0x0D, 0x07, 0x50, 0x80, 0xC5, 0x81, 0x3F, 0x25,
  0x0D, 0x07, 0x50, 0x5C, 0x0B, 0x20,
  // "ź" (U+017A)
  0x50, 0x60, 0x54, 0x81, 0x4D, 0x23, 0x81, 0x1C, 0x27, 0x30, 0xAB, 0x02, 0x40, 0x90, 0xA4, 0x81,
  0x3E, 0x14, 0x0D, 0x05, 0x40, 0x80, 0xB4, 0x81, 0x2E, 0x24, 0x0C, 0x07, 0x40, 0x5B, 0x0C, 0x20,
  // "Ż" (U+017B)
  0x50, 0xC0, 0x37, 0x77, 0x60, 0x3C, 0x09, 0x58, 0x14, 0xF2, 0x50, 0xD0, 0x75, 0x08, 0x0C, 0x58,
  0x13, 0xF2, 0x50, 0xD0, 0x75, 0x08, 0x0C, 0x58, 0x13, 0xF2, 0x50, 0xD0, 0x75, 0x05, 0xC0, 0xB2,
  // "ż" (U+017C)
  0x40, 0xC0, 0x37, 0x73, 0x0A, 0xB0, 0x24, 0x09, 0x0A, 0x48, 0x13, 0xE1, 0x40, 0xD0, 0x54, 0x08,
  0x0B, 0x48, 0x12, 0xE2, 0x40, 0xC0, 0x74, 0x05, 0xB0, 0xC2,
  // "Ž" (U+017D)
  0x40, 0x52, 0x06, 0x48, 0x27, 0x9A, 0x54, 0x81, 0x1F, 0x97, 0x75, 0x03, 0xC0, 0x95, 0x81, 0x4F,
  0x25, 0x0D, 0x07, 0x50, 0x80, 0xC5, 0x81, 0x3F, 0x25, 0x0D, 0x07, 0x50, 0x80, 0xC5, 0x81, 0x3F,
  0x25, 0x0D, 0x07, 0x50, 0x5C, 0x0B, 0x20,
  // "ž" (U+017E)
  0x30, 0x52, 0x06, 0x38, 0x27, 0x9A, 0x53, 0x81, 0x1F, 0x97, 0x30, 0xAB, 0x02, 0x40, 0x90, 0xA4,
  0x81, 0x3E, 0x14, 0x0D, 0x05, 0x40, 0x80, 0xB4, 0x81, 0x2E, 0x24, 0x0C, 0x07, 0x40, 0x5B, 0x0C,
  0x20,
  // "ſ" (U+017F)
  0x48, 0x22, 0xCE, 0x44, 0x81, 0xB9, 0x15, 0x90, 0x35, 0x04, 0x0E, 0x60, 0x70, 0xB6, 0x0B, 0x07,
  0x60, 0xE0, 0x45, 0x02, 0x96, 0x06, 0x0C, 0x60, 0xA0, 0x86, 0x0D, 0x05, 0x58, 0x11, 0xF1, 0x50,
  0x80, 0xC5, 0x81, 0xED, 0x25,
  // "Ω" (U+03A9)
  0x48, 0x37, 0xDF, 0xC3, 0x48, 0x49, 0xD3, 0x19, 0xE3, 0x81, 0x4F, 0x22, 0x81, 0x2F, 0x32, 0x0B,
  0x09, 0x38, 0x11, 0xF3, 0x29, 0x04, 0x38, 0x53, 0xF1, 0x02, 0xF2, 0x30, 0x70, 0xC2, 0x81, 0x2F,
  0x13, 0x0D, 0x06, 0x30, 0xE0, 0x32, 0x07, 0x0C, 0x48, 0x48, 0xA0, 0x5C, 0x12, 0x05, 0xA0, 0xE1,
  0xB0, 0x51,
  // "μ" (U+03BC)
  0x20, 0x40, 0xE2, 0x08, 0x0A, 0x20, 0x80, 0xA2, 0x0B, 0x07, 0x20, 0xB0, 0x72, 0x0E, 0x03, 0x28,
  0x2E, 0x40, 0x29, 0x28, 0x43, 0xF1, 0x06, 0xC2, 0x06, 0x0D, 0x20, 0xB0, 0x92, 0x84, 0x9D, 0x06,
  0xF6, 0x28, 0x90, 0xDD, 0xE8, 0xC2, 0x01, 0xF2, 0x50, 0x40, 0xE6, 0x08, 0x0A, 0x60,
  // "π" (U+03C0)
  0x02, 0x0D, 0xD8, 0x29, 0x04, 0xE2, 0x90, 0x32, 0x82, 0x7B, 0x03, 0x93, 0x83, 0xB7, 0x06, 0xB3,
  0x83, 0xE4, 0x0A, 0x82, 0x84, 0x2F, 0x10, 0xD5, 0x20, 0x50, 0xD2, 0x90, 0x42, 0x08, 0x09, 0x28,
  0x1B, 0xE1, 0x10,
  // "–" (U+2013)
  0x07, 0x80, 0x1E, 0x05, 0x18, 0x01, 0x11,
  // "—" (U+2014)
  0x07, 0x80, 0x90, 0xE0, 0x31, 0x80, 0x90, 0x11,
  // "€" (U+20AC)
  0x38, 0x35, 0xCF, 0xD3, 0x28, 0x36, 0xE4, 0x03, 0x28, 0x11, 0xE3, 0x48, 0x44, 0xEF, 0xEE, 0x43,
  0x82, 0xA9, 0x11, 0x38, 0x3A, 0xFE, 0xE8, 0x38, 0x21, 0xD6, 0x15, 0x0B, 0x07, 0x68, 0x37, 0xC1,
  0x21, 0x48, 0x2A, 0xED, 0x42,
  // "₿" (U+20BF)
  0x38, 0x13, 0x7A, 0x48, 0x16, 0x4A, 0x30, 0xAA, 0x0D, 0x01, 0x28, 0xA7, 0xD5, 0x1C, 0x90, 0x1F,
  0x10, 0xA9, 0x05, 0xD0, 0x4E, 0x30, 0x9F, 0xEE, 0x32, 0x83, 0xC7, 0x2C, 0x92, 0x98, 0x53, 0x06,
  0xD0, 0x3E, 0x28, 0x91, 0x9B, 0x07, 0xB0, 0x4E, 0x50, 0xAA, 0x0E, 0x06, 0x38, 0x1A, 0x55, 0x48,
  0x15, 0x31, 0x30,
  // "‘" (U+2018)
  0x18, 0x90, 0x95, 0x3D, 0x0B, 0x80, 0x71, 0x10,
  // "’" (U+2019)
  0x18, 0x7E, 0x54, 0xD0, 0xB5, 0x06, 0x20,
  // "‚" (U+201A)
  0x18, 0x90, 0x37, 0x0A, 0x91, 0xE2, 0x78, 0x10,
  // "‛" (U+201B)
  0x84, 0x7C, 0x6B, 0x3C,
  // "“" (U+201C)
  0x18, 0x93, 0xA5, 0x3C, 0x4D, 0x0D, 0x4D, 0x66, 0xD1,
  // "”" (U+201D)
  0x18, 0x93, 0xE5, 0x8C, 0x6B, 0x0E, 0x3D, 0x27, 0x81,
  // "„" (U+201E)
  0x18, 0xA3, 0xAA, 0x3F, 0x20, 0xE3, 0x8B, 0x05, 0xC0, 0xD3, 0x0B, 0x44, 0xB2,
  // "‟" (U+201F)
  0x89, 0x57, 0xC1, 0xF2, 0x5C, 0x0F, 0x22, 0xC0, 0xC3,
  // "†" (U+2020)
  0x28, 0x12, 0xF1, 0x30, 0x40, 0xC3, 0x89, 0x11, 0x67, 0x10, 0x7D, 0xEC, 0xD3, 0x20, 0xC4, 0x01,
  0x0C, 0x40, 0x50, 0xA4, 0x09, 0x07, 0x40, 0xD0, 0x43, 0x81, 0x1F, 0x13, 0x05, 0x0E, 0x40,
  // "‡" (U+2021)
  0x38, 0x12, 0xF1, 0x40, 0x30, 0xC3, 0x89, 0x32, 0x58, 0x95, 0x20, 0x59, 0xD9, 0x93, 0x30, 0xD0,
  0x14, 0x02, 0x0E, 0x50, 0x50, 0xA3, 0x89, 0x34, 0x8B, 0xB8, 0x30, 0x35, 0xC6, 0x61, 0x30, 0xE5,
  0x05, 0x0D, 0x40,
  // "•" (U+2022)
  0x83, 0x4E, 0xD3, 0xCA, 0x09, 0x0C, 0xA8, 0x39, 0x4E, 0xD2,
  // "…" (U+2026)
  0x83, 0x69, 0x06, 0x92, 0x85, 0x69, 0xA9, 0x0A, 0x92, 0x0A, 0x09,
  // "‰" (U+2030)
  0x28, 0x19, 0xE7, 0x20, 0x80, 0x76, 0x85, 0x6A, 0x3C, 0x03, 0xC7, 0x85, 0xC2, 0x3B, 0x0C, 0x37,
  0x84, 0xE0, 0x68, 0x69, 0x78, 0xB2, 0x1D, 0x1D, 0x4D, 0x3C, 0xC1, 0x0A, 0xD4, 0x0C, 0xF7, 0xA5,
  0xC3, 0x96, 0x97, 0x5A, 0x38, 0x91, 0x5A, 0x3B, 0x0A, 0x5E, 0x05, 0x93, 0x89, 0x1D, 0x17, 0x70,
  0xD5, 0xB0, 0x95, 0x28, 0x91, 0x96, 0x08, 0x86, 0xA4, 0xB3, 0xD2, 0x03, 0x0C, 0x28, 0x63, 0xEC,
  0x10, 0xDE, 0x31,
  // "‹" (U+2039)
  0x28, 0x92, 0x58, 0x04, 0xD2, 0x3E, 0x30, 0x4E, 0x30, 0xC0, 0x52, 0x05, 0x0A, 0x10,
  // "›" (U+203A)
  0x10, 0xB0, 0x12, 0x00, 0x92, 0x89, 0x32, 0xF1, 0x05, 0xE2, 0x2E, 0x30, 0xB4, 0x20,
  // "⁄" (U+2044)
  0x78, 0x11, 0xC1, 0x70, 0xB0, 0x47, 0x09, 0x07, 0x70, 0x50, 0xA7, 0x03, 0x0C, 0x78, 0x11, 0xC2,
  0x70, 0xB0, 0x47, 0x00, 0x87, 0x05, 0x0B, 0x78, 0x12, 0xC1, 0x70,
  // "™" (U+2122)
  0x8F, 0x29, 0xCC, 0x8A, 0x70, 0x1D, 0x20, 0x65, 0x0B, 0xC0, 0x6D, 0x20, 0x65, 0x0B, 0x92, 0xA9,
  0x20, 0x65, 0x0B, 0x48, 0x99, 0x20, 0x65, 0x0B, 0x0E, 0x49, 0x20, 0x22, 0x04, 0x04, 0x03, 0x10,
  // "⅒" (U+2152)
  0x30, 0x30, 0x57, 0x58, 0x17, 0xE7, 0x28, 0x11, 0xC1, 0x78, 0x16, 0xA4, 0x20, 0xB0, 0x47, 0x28,
  0x3D, 0x10, 0x97, 0x72, 0x89, 0x21, 0xD0, 0x5A, 0x03, 0x50, 0x5D, 0xB3, 0x89, 0x34, 0xA3, 0xC0,
  0x7E, 0x71, 0xD1, 0xB3, 0x28, 0x93, 0x88, 0xC2, 0x06, 0xA4, 0x78, 0x0B, 0x43, 0x0B, 0x04, 0x38,
  0x5D, 0x1B, 0x40, 0xD2, 0x20, 0x08, 0x38, 0x51, 0xD0, 0xC2, 0x1D, 0x20, 0x50, 0xB4, 0x89, 0x14,
  0xA0, 0xC3, 0x88, 0x02, 0xC1, 0x48, 0x48, 0x70, 0x5D, 0xA2,
  // "ﬁ" (U+FB01)
  0x48, 0x41, 0xBF, 0x69, 0x64, 0x81, 0x8A, 0x17, 0x0D, 0x04, 0x60, 0x10, 0xBA, 0x81, 0x54, 0xE4,
  0x05, 0x0D, 0x20, 0x70, 0xA4, 0x00, 0x92, 0x0B, 0x07, 0x40, 0xC0, 0x62, 0x0E, 0x04, 0x49, 0x83,
  0x20, 0x2F, 0x13, 0x04, 0x0E, 0x20, 0x50, 0xD4, 0x07, 0x0B, 0x20, 0x80, 0x94, 0x0B, 0x07, 0x20,
  0xB0, 0x64, 0x0E, 0x03, 0x70, 0x50, 0xE7, 0x81, 0xBE, 0x47,
  // "ﬂ" (U+FB02)
  0x48, 0x41, 0xBF, 0x68, 0x94, 0x84, 0x8A, 0x10, 0xC6, 0x40, 0xD0, 0x42, 0x90, 0x32, 0x01, 0x0B,
  0xA8, 0x15, 0x3E, 0x40, 0x50, 0xD2, 0x06, 0x0B, 0x40, 0x09, 0x20, 0xA0, 0x84, 0x0C, 0x06, 0x20,
  0xD0, 0x44, 0x98, 0x32, 0x01, 0xF1, 0x30, 0x40, 0xE2, 0x05, 0x0D, 0x40, 0x70, 0xB2, 0x08, 0x09,
  0x40, 0xB0, 0x72, 0x0B, 0x06, 0x40, 0xE0, 0x37, 0x05, 0x0E, 0x78, 0x1B, 0xE4, 0x70,
};

const Font& font_NotoSans_CondensedItalic_15() {
  static SmoothFont font(font_NotoSans_CondensedItalic_15_data);
  return font;
}

}  // namespace roo_display
