#include "60.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSans-Condensed (Noto Sans Condensed)
// Generated on Thu Mar 30 22:28:30 CEST 2023
static const uint8_t font_NotoSans_Condensed_60_data[] PROGMEM = {
  
  // Header
  0x01, 0x01, 0x04, 0x02, 0x01, 0x03, 0x01, 0x01, 0x57, 0x0C, 0x63,
  0xF6, 0xF3, 0x3A, 0x3C, 0x2E, 0xF2, 0x0E, 0x07, 0x3D, 0x0D, 0x0E, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x04, 0x00, 0x0A, 0x2B, 0x0F, 0x00, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x03, 0x1C, 0x13, 0x2B, 0x17, 0x00, 0x00, 0x70, // """ (U+0022)
  0x00, 0x23, 0x01, 0x01, 0x1D, 0x2B, 0x1F, 0x00, 0x00, 0xC8, // "#" (U+0023)
  0x00, 0x24, 0x02, 0xFD, 0x19, 0x2E, 0x1C, 0x00, 0x01, 0xD1, // "$" (U+0024)
  0x00, 0x25, 0x02, 0x00, 0x28, 0x2C, 0x2B, 0x00, 0x02, 0xFF, // "%" (U+0025)
  0x00, 0x26, 0x02, 0x00, 0x20, 0x2C, 0x21, 0x00, 0x04, 0xC7, // "&" (U+0026)
  0x00, 0x27, 0x03, 0x1C, 0x09, 0x2B, 0x0D, 0x00, 0x06, 0x0E, // "'" (U+0027)
  0x00, 0x28, 0x02, 0xF7, 0x0F, 0x2B, 0x12, 0x00, 0x06, 0x3A, // "(" (U+0028)
  0x00, 0x29, 0x02, 0xF7, 0x0E, 0x2B, 0x12, 0x00, 0x06, 0xEF, // ")" (U+0029)
  0x00, 0x2A, 0x02, 0x19, 0x18, 0x2E, 0x1B, 0x00, 0x07, 0x95, // "*" (U+002A)
  0x00, 0x2B, 0x02, 0x08, 0x1A, 0x24, 0x1C, 0x00, 0x08, 0x1B, // "+" (U+002B)
  0x00, 0x2C, 0x02, 0xF9, 0x0A, 0x07, 0x0E, 0x00, 0x08, 0x94, // "," (U+002C)
  0x00, 0x2D, 0x01, 0x0F, 0x0F, 0x13, 0x11, 0x00, 0x08, 0xC1, // "-" (U+002D)
  0x00, 0x2E, 0x03, 0x00, 0x0A, 0x08, 0x0E, 0x00, 0x08, 0xD1, // "." (U+002E)
  0x00, 0x2F, 0x01, 0x01, 0x15, 0x2B, 0x16, 0x00, 0x08, 0xEE, // "/" (U+002F)
  0x00, 0x30, 0x02, 0x00, 0x19, 0x2C, 0x1C, 0x00, 0x09, 0x9A, // "0" (U+0030)
  0x00, 0x31, 0x04, 0x01, 0x12, 0x2B, 0x1C, 0x00, 0x0A, 0xAB, // "1" (U+0031)
  0x00, 0x32, 0x02, 0x01, 0x19, 0x2C, 0x1C, 0x00, 0x0B, 0x54, // "2" (U+0032)
  0x00, 0x33, 0x02, 0x00, 0x19, 0x2C, 0x1C, 0x00, 0x0C, 0x24, // "3" (U+0033)
  0x00, 0x34, 0x01, 0x01, 0x1B, 0x2B, 0x1C, 0x00, 0x0D, 0x0F, // "4" (U+0034)
  0x00, 0x35, 0x03, 0x00, 0x19, 0x2B, 0x1C, 0x00, 0x0D, 0xFF, // "5" (U+0035)
  0x00, 0x36, 0x02, 0x00, 0x19, 0x2C, 0x1C, 0x00, 0x0E, 0xCE, // "6" (U+0036)
  0x00, 0x37, 0x02, 0x01, 0x19, 0x2B, 0x1C, 0x00, 0x0F, 0xD5, // "7" (U+0037)
  0x00, 0x38, 0x02, 0x00, 0x19, 0x2C, 0x1C, 0x00, 0x10, 0x82, // "8" (U+0038)
  0x00, 0x39, 0x02, 0x00, 0x19, 0x2C, 0x1C, 0x00, 0x11, 0x9A, // "9" (U+0039)
  0x00, 0x3A, 0x03, 0x00, 0x0A, 0x21, 0x0E, 0x00, 0x12, 0xA1, // ":" (U+003A)
  0x00, 0x3B, 0x02, 0xF9, 0x0A, 0x21, 0x0E, 0x00, 0x12, 0xDB, // ";" (U+003B)
  0x00, 0x3C, 0x02, 0x08, 0x1A, 0x23, 0x1C, 0x00, 0x13, 0x27, // "<" (U+003C)
  0x00, 0x3D, 0x02, 0x0E, 0x19, 0x1E, 0x1C, 0x00, 0x13, 0xBF, // "=" (U+003D)
  0x00, 0x3E, 0x02, 0x08, 0x1A, 0x23, 0x1C, 0x00, 0x13, 0xE1, // ">" (U+003E)
  0x00, 0x3F, 0x00, 0x00, 0x13, 0x2C, 0x15, 0x00, 0x14, 0x75, // "?" (U+003F)
  0x00, 0x40, 0x03, 0xFB, 0x28, 0x2B, 0x2C, 0x00, 0x15, 0x23, // "@" (U+0040)
  0x00, 0x41, 0x00, 0x01, 0x1E, 0x2B, 0x1E, 0x00, 0x16, 0xFD, // "A" (U+0041)
  0x00, 0x42, 0x04, 0x01, 0x1D, 0x2B, 0x20, 0x00, 0x18, 0x05, // "B" (U+0042)
  0x00, 0x43, 0x03, 0x00, 0x1C, 0x2C, 0x1E, 0x00, 0x19, 0x15, // "C" (U+0043)
  0x00, 0x44, 0x04, 0x01, 0x1F, 0x2B, 0x23, 0x00, 0x19, 0xF1, // "D" (U+0044)
  0x00, 0x45, 0x04, 0x01, 0x17, 0x2B, 0x1B, 0x00, 0x1B, 0x08, // "E" (U+0045)
  0x00, 0x46, 0x04, 0x01, 0x17, 0x2B, 0x19, 0x00, 0x1B, 0xA3, // "F" (U+0046)
  0x00, 0x47, 0x03, 0x00, 0x20, 0x2C, 0x24, 0x00, 0x1C, 0x3C, // "G" (U+0047)
  0x00, 0x48, 0x04, 0x01, 0x1E, 0x2B, 0x24, 0x00, 0x1D, 0x59, // "H" (U+0048)
  0x00, 0x49, 0x02, 0x01, 0x0F, 0x2B, 0x12, 0x00, 0x1E, 0x67, // "I" (U+0049)
  0x00, 0x4A, 0xFC, 0xF5, 0x09, 0x2B, 0x0E, 0x00, 0x1F, 0x01, // "J" (U+004A)
  0x00, 0x4B, 0x04, 0x01, 0x1D, 0x2B, 0x1E, 0x00, 0x1F, 0xC7, // "K" (U+004B)
  0x00, 0x4C, 0x04, 0x01, 0x17, 0x2B, 0x19, 0x00, 0x20, 0xDE, // "L" (U+004C)
  0x00, 0x4D, 0x04, 0x01, 0x29, 0x2B, 0x2F, 0x00, 0x21, 0x76, // "M" (U+004D)
  0x00, 0x4E, 0x04, 0x01, 0x20, 0x2B, 0x26, 0x00, 0x23, 0x35, // "N" (U+004E)
  0x00, 0x4F, 0x03, 0x00, 0x21, 0x2C, 0x25, 0x00, 0x24, 0x72, // "O" (U+004F)
  0x00, 0x50, 0x04, 0x01, 0x1B, 0x2B, 0x1E, 0x00, 0x25, 0x9C, // "P" (U+0050)
  0x00, 0x51, 0x03, 0xF7, 0x21, 0x2C, 0x25, 0x00, 0x26, 0x81, // "Q" (U+0051)
  0x00, 0x52, 0x04, 0x01, 0x1D, 0x2B, 0x1F, 0x00, 0x27, 0xD1, // "R" (U+0052)
  0x00, 0x53, 0x02, 0x00, 0x18, 0x2C, 0x1B, 0x00, 0x28, 0xE7, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x19, 0x2B, 0x1A, 0x00, 0x29, 0xCA, // "T" (U+0054)
  0x00, 0x55, 0x04, 0x00, 0x1E, 0x2B, 0x23, 0x00, 0x2A, 0x7B, // "U" (U+0055)
  0x00, 0x56, 0x00, 0x01, 0x1D, 0x2B, 0x1D, 0x00, 0x2B, 0x97, // "V" (U+0056)
  0x00, 0x57, 0x00, 0x01, 0x2E, 0x2B, 0x2F, 0x00, 0x2C, 0x9E, // "W" (U+0057)
  0x00, 0x58, 0x00, 0x01, 0x1A, 0x2B, 0x1B, 0x00, 0x2E, 0x6F, // "X" (U+0058)
  0x00, 0x59, 0x00, 0x01, 0x1A, 0x2B, 0x1B, 0x00, 0x2F, 0x78, // "Y" (U+0059)
  0x00, 0x5A, 0x01, 0x01, 0x17, 0x2B, 0x19, 0x00, 0x30, 0x58, // "Z" (U+005A)
  0x00, 0x5B, 0x04, 0xF6, 0x11, 0x2B, 0x13, 0x00, 0x31, 0x09, // "[" (U+005B)
  0x00, 0x5C, 0x01, 0x01, 0x15, 0x2B, 0x16, 0x00, 0x31, 0xC5, // "\" (U+005C)
  0x00, 0x5D, 0x01, 0xF6, 0x0E, 0x2B, 0x13, 0x00, 0x32, 0x6F, // "]" (U+005D)
  0x00, 0x5E, 0x01, 0x14, 0x1B, 0x2C, 0x1D, 0x00, 0x33, 0x2B, // "^" (U+005E)
  0x00, 0x5F, 0xFF, 0xF8, 0x1A, 0xFC, 0x1A, 0x00, 0x33, 0xC6, // "_" (U+005F)
  0x00, 0x60, 0x02, 0x26, 0x0D, 0x2F, 0x10, 0x00, 0x33, 0xDA, // "`" (U+0060)
  0x00, 0x61, 0x02, 0x00, 0x17, 0x21, 0x1C, 0x00, 0x33, 0xFF, // "a" (U+0061)
  0x00, 0x62, 0x04, 0x00, 0x1B, 0x2E, 0x1E, 0x00, 0x34, 0xC7, // "b" (U+0062)
  0x00, 0x63, 0x02, 0x00, 0x15, 0x21, 0x17, 0x00, 0x35, 0xE3, // "c" (U+0063)
  0x00, 0x64, 0x02, 0x00, 0x1A, 0x2E, 0x1E, 0x00, 0x36, 0x77, // "d" (U+0064)
  0x00, 0x65, 0x02, 0x00, 0x19, 0x21, 0x1C, 0x00, 0x37, 0x8D, // "e" (U+0065)
  0x00, 0x66, 0x00, 0x01, 0x12, 0x2F, 0x11, 0x00, 0x38, 0x41, // "f" (U+0066)
  0x00, 0x67, 0x02, 0xF3, 0x1A, 0x21, 0x1E, 0x00, 0x38, 0xF5, // "g" (U+0067)
  0x00, 0x68, 0x04, 0x01, 0x1A, 0x2E, 0x1E, 0x00, 0x3A, 0x1D, // "h" (U+0068)
  0x00, 0x69, 0x03, 0x01, 0x09, 0x2D, 0x0E, 0x00, 0x3B, 0x25, // "i" (U+0069)
  0x00, 0x6A, 0xFE, 0xF3, 0x09, 0x2D, 0x0E, 0x00, 0x3B, 0x9D, // "j" (U+006A)
  0x00, 0x6B, 0x04, 0x01, 0x19, 0x2E, 0x1A, 0x00, 0x3C, 0x46, // "k" (U+006B)
  0x00, 0x6C, 0x04, 0x01, 0x09, 0x2E, 0x0D, 0x00, 0x3D, 0x46, // "l" (U+006C)
  0x00, 0x6D, 0x04, 0x01, 0x29, 0x21, 0x2D, 0x00, 0x3D, 0xB9, // "m" (U+006D)
  0x00, 0x6E, 0x04, 0x01, 0x1A, 0x21, 0x1E, 0x00, 0x3F, 0x06, // "n" (U+006E)
  0x00, 0x6F, 0x02, 0x00, 0x1A, 0x21, 0x1E, 0x00, 0x3F, 0xD7, // "o" (U+006F)
  0x00, 0x70, 0x04, 0xF3, 0x1B, 0x21, 0x1E, 0x00, 0x40, 0xAE, // "p" (U+0070)
  0x00, 0x71, 0x02, 0xF3, 0x1A, 0x21, 0x1E, 0x00, 0x41, 0xCA, // "q" (U+0071)
  0x00, 0x72, 0x04, 0x01, 0x13, 0x21, 0x14, 0x00, 0x42, 0xE1, // "r" (U+0072)
  0x00, 0x73, 0x02, 0x00, 0x14, 0x21, 0x17, 0x00, 0x43, 0x69, // "s" (U+0073)
  0x00, 0x74, 0x01, 0x00, 0x10, 0x28, 0x11, 0x00, 0x44, 0x0D, // "t" (U+0074)
  0x00, 0x75, 0x04, 0x00, 0x19, 0x20, 0x1E, 0x00, 0x44, 0xA3, // "u" (U+0075)
  0x00, 0x76, 0x00, 0x01, 0x18, 0x20, 0x19, 0x00, 0x45, 0x3E, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x01, 0x26, 0x20, 0x28, 0x00, 0x45, 0xF7, // "w" (U+0077)
  0x00, 0x78, 0x01, 0x01, 0x18, 0x20, 0x19, 0x00, 0x47, 0x3F, // "x" (U+0078)
  0x00, 0x79, 0x00, 0xF3, 0x18, 0x20, 0x19, 0x00, 0x48, 0x01, // "y" (U+0079)
  0x00, 0x7A, 0x01, 0x01, 0x13, 0x20, 0x15, 0x00, 0x48, 0xF6, // "z" (U+007A)
  0x00, 0x7B, 0x02, 0xF7, 0x13, 0x2B, 0x16, 0x00, 0x49, 0x6D, // "{" (U+007B)
  0x00, 0x7C, 0x0B, 0xF3, 0x0F, 0x2F, 0x1B, 0x00, 0x4A, 0x3A, // "|" (U+007C)
  0x00, 0x7D, 0x02, 0xF7, 0x13, 0x2B, 0x16, 0x00, 0x4A, 0xD3, // "}" (U+007D)
  0x00, 0x7E, 0x02, 0x13, 0x1A, 0x1A, 0x1C, 0x00, 0x4B, 0xA0, // "~" (U+007E)
  0x00, 0xA1, 0x04, 0xF5, 0x0A, 0x20, 0x0F, 0x00, 0x4B, 0xDE, // "¡" (U+00A1)
  0x00, 0xA2, 0x04, 0x00, 0x17, 0x2B, 0x1C, 0x00, 0x4C, 0x4D, // "¢" (U+00A2)
  0x00, 0xA3, 0x02, 0x01, 0x19, 0x2C, 0x1C, 0x00, 0x4D, 0x0A, // "£" (U+00A3)
  0x00, 0xA4, 0x03, 0x07, 0x1D, 0x22, 0x21, 0x00, 0x4D, 0xC4, // "¤" (U+00A4)
  0x00, 0xA5, 0x01, 0x01, 0x1A, 0x2B, 0x1C, 0x00, 0x4E, 0x9C, // "¥" (U+00A5)
  0x00, 0xA6, 0x0B, 0xF3, 0x0F, 0x2E, 0x1B, 0x00, 0x4F, 0x7C, // "¦" (U+00A6)
  0x00, 0xA7, 0x02, 0x02, 0x15, 0x2E, 0x19, 0x00, 0x4F, 0xF2, // "§" (U+00A7)
  0x00, 0xA8, 0x08, 0x26, 0x17, 0x2B, 0x20, 0x00, 0x50, 0xE6, // "¨" (U+00A8)
  0x00, 0xA9, 0x02, 0x00, 0x2E, 0x2B, 0x32, 0x00, 0x51, 0x0C, // "©" (U+00A9)
  0x00, 0xAA, 0x01, 0x18, 0x10, 0x2B, 0x13, 0x00, 0x52, 0xE3, // "ª" (U+00AA)
  0x00, 0xAB, 0x02, 0x04, 0x1A, 0x1C, 0x1D, 0x00, 0x53, 0x53, // "«" (U+00AB)
  0x00, 0xAC, 0x02, 0x08, 0x19, 0x18, 0x1C, 0x00, 0x54, 0x01, // "¬" (U+00AC)
  0x00, 0xAE, 0x02, 0x00, 0x2E, 0x2B, 0x32, 0x00, 0x54, 0x46, // "®" (U+00AE)
  0x00, 0xAF, 0xFF, 0x2F, 0x1B, 0x33, 0x1B, 0x00, 0x56, 0x37, // "¯" (U+00AF)
  0x00, 0xB0, 0x02, 0x1C, 0x14, 0x2C, 0x17, 0x00, 0x56, 0x4C, // "°" (U+00B0)
  0x00, 0xB1, 0x02, 0x01, 0x1A, 0x25, 0x1C, 0x00, 0x56, 0xAE, // "±" (U+00B1)
  0x00, 0xB2, 0x01, 0x1A, 0x10, 0x34, 0x14, 0x00, 0x57, 0x3D, // "²" (U+00B2)
  0x00, 0xB3, 0x01, 0x19, 0x11, 0x33, 0x14, 0x00, 0x57, 0xB0, // "³" (U+00B3)
  0x00, 0xB4, 0x02, 0x26, 0x0D, 0x2F, 0x10, 0x00, 0x58, 0x34, // "´" (U+00B4)
  0x00, 0xB5, 0x04, 0xF3, 0x1A, 0x20, 0x1E, 0x00, 0x58, 0x59, // "µ" (U+00B5)
  0x00, 0xB6, 0x03, 0xF9, 0x1A, 0x2D, 0x20, 0x00, 0x59, 0x5F, // "¶" (U+00B6)
  0x00, 0xB7, 0x03, 0x12, 0x0A, 0x1A, 0x0E, 0x00, 0x5A, 0xB2, // "·" (U+00B7)
  0x00, 0xB8, 0x00, 0xF3, 0x0B, 0x01, 0x0D, 0x00, 0x5A, 0xCF, // "¸" (U+00B8)
  0x00, 0xB9, 0x02, 0x1A, 0x0D, 0x33, 0x14, 0x00, 0x5B, 0x0D, // "¹" (U+00B9)
  0x00, 0xBA, 0x01, 0x18, 0x12, 0x2B, 0x14, 0x00, 0x5B, 0x6A, // "º" (U+00BA)
  0x00, 0xBB, 0x02, 0x04, 0x1A, 0x1C, 0x1D, 0x00, 0x5B, 0xDB, // "»" (U+00BB)
  0x00, 0xBC, 0x02, 0x01, 0x2A, 0x2B, 0x2B, 0x00, 0x5C, 0x87, // "¼" (U+00BC)
  0x00, 0xBD, 0x01, 0x01, 0x2A, 0x2B, 0x2D, 0x00, 0x5E, 0x11, // "½" (U+00BD)
  0x00, 0xBE, 0x01, 0x01, 0x2B, 0x2C, 0x2D, 0x00, 0x5F, 0x95, // "¾" (U+00BE)
  0x00, 0xBF, 0x01, 0xF5, 0x14, 0x21, 0x15, 0x00, 0x61, 0x3D, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x1E, 0x39, 0x1E, 0x00, 0x61, 0xEB, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x1E, 0x39, 0x1E, 0x00, 0x63, 0x28, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x01, 0x1E, 0x39, 0x1E, 0x00, 0x64, 0x65, // "Â" (U+00C2)
  0x00, 0xC3, 0x00, 0x01, 0x1E, 0x36, 0x1E, 0x00, 0x65, 0xB7, // "Ã" (U+00C3)
  0x00, 0xC4, 0x00, 0x01, 0x1E, 0x35, 0x1E, 0x00, 0x66, 0xF6, // "Ä" (U+00C4)
  0x00, 0xC5, 0x00, 0x01, 0x1E, 0x35, 0x1E, 0x00, 0x68, 0x2E, // "Å" (U+00C5)
  0x00, 0xC6, 0x00, 0x01, 0x26, 0x2B, 0x2A, 0x00, 0x69, 0x79, // "Æ" (U+00C6)
  0x00, 0xC7, 0x03, 0xF3, 0x1C, 0x2C, 0x1E, 0x00, 0x6A, 0xAB, // "Ç" (U+00C7)
  0x00, 0xC8, 0x04, 0x01, 0x17, 0x39, 0x1B, 0x00, 0x6B, 0xCB, // "È" (U+00C8)
  0x00, 0xC9, 0x04, 0x01, 0x17, 0x39, 0x1B, 0x00, 0x6C, 0x94, // "É" (U+00C9)
  0x00, 0xCA, 0x04, 0x01, 0x17, 0x39, 0x1B, 0x00, 0x6D, 0x5B, // "Ê" (U+00CA)
  0x00, 0xCB, 0x04, 0x01, 0x17, 0x35, 0x1B, 0x00, 0x6E, 0x39, // "Ë" (U+00CB)
  0x00, 0xCC, 0x00, 0x01, 0x0F, 0x39, 0x12, 0x00, 0x6E, 0xFF, // "Ì" (U+00CC)
  0x00, 0xCD, 0x02, 0x01, 0x12, 0x39, 0x12, 0x00, 0x6F, 0xC9, // "Í" (U+00CD)
  0x00, 0xCE, 0x00, 0x01, 0x11, 0x39, 0x12, 0x00, 0x70, 0x94, // "Î" (U+00CE)
  0x00, 0xCF, 0x01, 0x01, 0x10, 0x35, 0x12, 0x00, 0x71, 0x74, // "Ï" (U+00CF)
  0x00, 0xD0, 0x01, 0x01, 0x1F, 0x2B, 0x23, 0x00, 0x72, 0x3A, // "Ð" (U+00D0)
  0x00, 0xD1, 0x04, 0x01, 0x20, 0x36, 0x26, 0x00, 0x73, 0x5D, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x03, 0x00, 0x21, 0x39, 0x25, 0x00, 0x74, 0xD1, // "Ò" (U+00D2)
  0x00, 0xD3, 0x03, 0x00, 0x21, 0x39, 0x25, 0x00, 0x76, 0x30, // "Ó" (U+00D3)
  0x00, 0xD4, 0x03, 0x00, 0x21, 0x39, 0x25, 0x00, 0x77, 0x8F, // "Ô" (U+00D4)
  0x00, 0xD5, 0x03, 0x00, 0x21, 0x36, 0x25, 0x00, 0x79, 0x02, // "Õ" (U+00D5)
  0x00, 0xD6, 0x03, 0x00, 0x21, 0x35, 0x25, 0x00, 0x7A, 0x62, // "Ö" (U+00D6)
  0x00, 0xD7, 0x02, 0x0A, 0x19, 0x21, 0x1C, 0x00, 0x7B, 0xBC, // "×" (U+00D7)
  0x00, 0xD8, 0x03, 0xFE, 0x21, 0x2D, 0x25, 0x00, 0x7C, 0x54, // "Ø" (U+00D8)
  0x00, 0xD9, 0x04, 0x00, 0x1E, 0x39, 0x23, 0x00, 0x7D, 0xD1, // "Ù" (U+00D9)
  0x00, 0xDA, 0x04, 0x00, 0x1E, 0x39, 0x23, 0x00, 0x7F, 0x20, // "Ú" (U+00DA)
  0x00, 0xDB, 0x04, 0x00, 0x1E, 0x39, 0x23, 0x00, 0x80, 0x6E, // "Û" (U+00DB)
  0x00, 0xDC, 0x04, 0x00, 0x1E, 0x35, 0x23, 0x00, 0x81, 0xD2, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x01, 0x1A, 0x39, 0x1B, 0x00, 0x83, 0x1C, // "Ý" (U+00DD)
  0x00, 0xDE, 0x04, 0x01, 0x1B, 0x2B, 0x1D, 0x00, 0x84, 0x2D, // "Þ" (U+00DE)
  0x00, 0xDF, 0x04, 0x00, 0x1C, 0x2F, 0x1F, 0x00, 0x85, 0x13, // "ß" (U+00DF)
  0x00, 0xE0, 0x02, 0x00, 0x17, 0x2F, 0x1C, 0x00, 0x86, 0x4F, // "à" (U+00E0)
  0x00, 0xE1, 0x02, 0x00, 0x17, 0x2F, 0x1C, 0x00, 0x87, 0x48, // "á" (U+00E1)
  0x00, 0xE2, 0x02, 0x00, 0x17, 0x2F, 0x1C, 0x00, 0x88, 0x3F, // "â" (U+00E2)
  0x00, 0xE3, 0x02, 0x00, 0x17, 0x2C, 0x1C, 0x00, 0x89, 0x4B, // "ã" (U+00E3)
  0x00, 0xE4, 0x02, 0x00, 0x17, 0x2B, 0x1C, 0x00, 0x8A, 0x46, // "ä" (U+00E4)
  0x00, 0xE5, 0x02, 0x00, 0x17, 0x31, 0x1C, 0x00, 0x8B, 0x39, // "å" (U+00E5)
  0x00, 0xE6, 0x02, 0x00, 0x28, 0x21, 0x2B, 0x00, 0x8C, 0x4B, // "æ" (U+00E6)
  0x00, 0xE7, 0x02, 0xF3, 0x15, 0x21, 0x17, 0x00, 0x8D, 0x82, // "ç" (U+00E7)
  0x00, 0xE8, 0x02, 0x00, 0x19, 0x2F, 0x1C, 0x00, 0x8E, 0x56, // "è" (U+00E8)
  0x00, 0xE9, 0x02, 0x00, 0x19, 0x2F, 0x1C, 0x00, 0x8F, 0x3B, // "é" (U+00E9)
  0x00, 0xEA, 0x02, 0x00, 0x19, 0x2F, 0x1C, 0x00, 0x90, 0x1F, // "ê" (U+00EA)
  0x00, 0xEB, 0x02, 0x00, 0x19, 0x2B, 0x1C, 0x00, 0x91, 0x18, // "ë" (U+00EB)
  0x00, 0xEC, 0xFF, 0x01, 0x0A, 0x2F, 0x0E, 0x00, 0x91, 0xF9, // "ì" (U+00EC)
  0x00, 0xED, 0x03, 0x01, 0x0E, 0x2F, 0x0E, 0x00, 0x92, 0x81, // "í" (U+00ED)
  0x00, 0xEE, 0xFE, 0x01, 0x0F, 0x2F, 0x0E, 0x00, 0x93, 0x09, // "î" (U+00EE)
  0x00, 0xEF, 0xFF, 0x01, 0x0E, 0x2B, 0x0E, 0x00, 0x93, 0xBA, // "ï" (U+00EF)
  0x00, 0xF0, 0x02, 0x00, 0x1A, 0x2F, 0x1E, 0x00, 0x94, 0x52, // "ð" (U+00F0)
  0x00, 0xF1, 0x04, 0x01, 0x1A, 0x2C, 0x1E, 0x00, 0x95, 0x73, // "ñ" (U+00F1)
  0x00, 0xF2, 0x02, 0x00, 0x1A, 0x2F, 0x1E, 0x00, 0x96, 0x77, // "ò" (U+00F2)
  0x00, 0xF3, 0x02, 0x00, 0x1A, 0x2F, 0x1E, 0x00, 0x97, 0x7E, // "ó" (U+00F3)
  0x00, 0xF4, 0x02, 0x00, 0x1A, 0x2F, 0x1E, 0x00, 0x98, 0x85, // "ô" (U+00F4)
  0x00, 0xF5, 0x02, 0x00, 0x1A, 0x2C, 0x1E, 0x00, 0x99, 0xA1, // "õ" (U+00F5)
  0x00, 0xF6, 0x02, 0x00, 0x1A, 0x2B, 0x1E, 0x00, 0x9A, 0xAB, // "ö" (U+00F6)
  0x00, 0xF7, 0x02, 0x08, 0x1A, 0x23, 0x1C, 0x00, 0x9B, 0xAF, // "÷" (U+00F7)
  0x00, 0xF8, 0x02, 0xFD, 0x1A, 0x23, 0x1E, 0x00, 0x9C, 0x04, // "ø" (U+00F8)
  0x00, 0xF9, 0x04, 0x00, 0x19, 0x2F, 0x1E, 0x00, 0x9D, 0x18, // "ù" (U+00F9)
  0x00, 0xFA, 0x04, 0x00, 0x19, 0x2F, 0x1E, 0x00, 0x9D, 0xE4, // "ú" (U+00FA)
  0x00, 0xFB, 0x04, 0x00, 0x19, 0x2F, 0x1E, 0x00, 0x9E, 0xAE, // "û" (U+00FB)
  0x00, 0xFC, 0x04, 0x00, 0x19, 0x2B, 0x1E, 0x00, 0x9F, 0x8D, // "ü" (U+00FC)
  0x00, 0xFD, 0x00, 0xF3, 0x18, 0x2F, 0x19, 0x00, 0xA0, 0x53, // "ý" (U+00FD)
  0x00, 0xFE, 0x04, 0xF3, 0x1B, 0x2F, 0x1E, 0x00, 0xA1, 0x79, // "þ" (U+00FE)
  0x00, 0xFF, 0x00, 0xF3, 0x18, 0x2B, 0x19, 0x00, 0xA2, 0xD0, // "ÿ" (U+00FF)
  0x01, 0x00, 0x00, 0x01, 0x1E, 0x35, 0x1E, 0x00, 0xA3, 0xF3, // "Ā" (U+0100)
  0x01, 0x01, 0x02, 0x00, 0x17, 0x2A, 0x1C, 0x00, 0xA5, 0x14, // "ā" (U+0101)
  0x01, 0x02, 0x00, 0x01, 0x1E, 0x38, 0x1E, 0x00, 0xA5, 0xF1, // "Ă" (U+0102)
  0x01, 0x03, 0x02, 0x00, 0x17, 0x2D, 0x1C, 0x00, 0xA7, 0x2D, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0xF4, 0x1E, 0x2B, 0x1E, 0x00, 0xA8, 0x24, // "Ą" (U+0104)
  0x01, 0x05, 0x02, 0xF4, 0x18, 0x21, 0x1C, 0x00, 0xA9, 0x6E, // "ą" (U+0105)
  0x01, 0x06, 0x03, 0x00, 0x1C, 0x3A, 0x1E, 0x00, 0xAA, 0x72, // "Ć" (U+0106)
  0x01, 0x07, 0x02, 0x00, 0x15, 0x2F, 0x17, 0x00, 0xAB, 0x7E, // "ć" (U+0107)
  0x01, 0x08, 0x03, 0x00, 0x1C, 0x3A, 0x1E, 0x00, 0xAC, 0x3E, // "Ĉ" (U+0108)
  0x01, 0x09, 0x02, 0x00, 0x16, 0x2F, 0x17, 0x00, 0xAD, 0x60, // "ĉ" (U+0109)
  0x01, 0x0A, 0x03, 0x00, 0x1C, 0x38, 0x1E, 0x00, 0xAE, 0x3F, // "Ċ" (U+010A)
  0x01, 0x0B, 0x02, 0x00, 0x15, 0x2D, 0x17, 0x00, 0xAF, 0x3A, // "ċ" (U+010B)
  0x01, 0x0C, 0x03, 0x00, 0x1C, 0x3A, 0x1E, 0x00, 0xAF, 0xEB, // "Č" (U+010C)
  0x01, 0x0D, 0x02, 0x00, 0x16, 0x2F, 0x17, 0x00, 0xB1, 0x03, // "č" (U+010D)
  0x01, 0x0E, 0x04, 0x01, 0x1F, 0x3A, 0x23, 0x00, 0xB1, 0xD8, // "Ď" (U+010E)
  0x01, 0x0F, 0x02, 0x00, 0x23, 0x2E, 0x1E, 0x00, 0xB3, 0x2D, // "ď" (U+010F)
  0x01, 0x10, 0x01, 0x01, 0x1F, 0x2B, 0x23, 0x00, 0xB4, 0x79, // "Đ" (U+0110)
  0x01, 0x11, 0x02, 0x00, 0x1E, 0x2E, 0x1E, 0x00, 0xB5, 0x9C, // "đ" (U+0111)
  0x01, 0x12, 0x04, 0x01, 0x17, 0x35, 0x1B, 0x00, 0xB6, 0xC1, // "Ē" (U+0112)
  0x01, 0x13, 0x02, 0x00, 0x19, 0x2A, 0x1C, 0x00, 0xB7, 0x72, // "ē" (U+0113)
  0x01, 0x14, 0x04, 0x01, 0x17, 0x38, 0x1B, 0x00, 0xB8, 0x3D, // "Ĕ" (U+0114)
  0x01, 0x15, 0x02, 0x00, 0x19, 0x2D, 0x1C, 0x00, 0xB9, 0x07, // "ĕ" (U+0115)
  0x01, 0x16, 0x04, 0x01, 0x17, 0x38, 0x1B, 0x00, 0xB9, 0xEB, // "Ė" (U+0116)
  0x01, 0x17, 0x02, 0x00, 0x19, 0x2D, 0x1C, 0x00, 0xBA, 0xA4, // "ė" (U+0117)
  0x01, 0x18, 0x04, 0xF4, 0x17, 0x2B, 0x1B, 0x00, 0xBB, 0x78, // "Ę" (U+0118)
  0x01, 0x19, 0x02, 0xF3, 0x19, 0x21, 0x1C, 0x00, 0xBC, 0x4A, // "ę" (U+0119)
  0x01, 0x1A, 0x04, 0x01, 0x17, 0x3A, 0x1B, 0x00, 0xBD, 0x38, // "Ě" (U+011A)
  0x01, 0x1B, 0x02, 0x00, 0x19, 0x2F, 0x1C, 0x00, 0xBE, 0x0C, // "ě" (U+011B)
  0x01, 0x1C, 0x03, 0x00, 0x20, 0x3A, 0x24, 0x00, 0xBE, 0xFB, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x02, 0xF3, 0x1A, 0x2F, 0x1E, 0x00, 0xC0, 0x61, // "ĝ" (U+011D)
  0x01, 0x1E, 0x03, 0x00, 0x20, 0x38, 0x24, 0x00, 0xC1, 0xCF, // "Ğ" (U+011E)
  0x01, 0x1F, 0x02, 0xF3, 0x1A, 0x2D, 0x1E, 0x00, 0xC3, 0x20, // "ğ" (U+011F)
  0x01, 0x20, 0x03, 0x00, 0x20, 0x38, 0x24, 0x00, 0xC4, 0x7A, // "Ġ" (U+0120)
  0x01, 0x21, 0x02, 0xF3, 0x1A, 0x2D, 0x1E, 0x00, 0xC5, 0xBA, // "ġ" (U+0121)
  0x01, 0x22, 0x03, 0xF4, 0x20, 0x2C, 0x24, 0x00, 0xC7, 0x02, // "Ģ" (U+0122)
  0x01, 0x23, 0x02, 0xF3, 0x1A, 0x2F, 0x1E, 0x00, 0xC8, 0x50, // "ģ" (U+0123)
  0x01, 0x24, 0x04, 0x01, 0x1E, 0x3A, 0x24, 0x00, 0xC9, 0xA3, // "Ĥ" (U+0124)
  0x01, 0x25, 0xFE, 0x01, 0x1A, 0x3C, 0x1E, 0x00, 0xCA, 0xF8, // "ĥ" (U+0125)
  0x01, 0x26, 0xFF, 0x01, 0x23, 0x2B, 0x24, 0x00, 0xCC, 0x5D, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x1A, 0x2E, 0x1E, 0x00, 0xCD, 0x8F, // "ħ" (U+0127)
  0x01, 0x28, 0xFF, 0x01, 0x12, 0x37, 0x12, 0x00, 0xCE, 0xA5, // "Ĩ" (U+0128)
  0x01, 0x29, 0xFD, 0x01, 0x10, 0x2C, 0x0E, 0x00, 0xCF, 0x78, // "ĩ" (U+0129)
  0x01, 0x2A, 0x01, 0x01, 0x10, 0x35, 0x12, 0x00, 0xD0, 0x1C, // "Ī" (U+012A)
  0x01, 0x2B, 0xFF, 0x01, 0x0E, 0x2A, 0x0E, 0x00, 0xD0, 0xCE, // "ī" (U+012B)
  0x01, 0x2C, 0x01, 0x01, 0x11, 0x38, 0x12, 0x00, 0xD1, 0x51, // "Ĭ" (U+012C)
  0x01, 0x2D, 0xFE, 0x01, 0x0E, 0x2D, 0x0E, 0x00, 0xD2, 0x1D, // "ĭ" (U+012D)
  0x01, 0x2E, 0x02, 0xF4, 0x0F, 0x2B, 0x12, 0x00, 0xD2, 0xBA, // "Į" (U+012E)
  0x01, 0x2F, 0x01, 0xF4, 0x0A, 0x2D, 0x0E, 0x00, 0xD3, 0x86, // "į" (U+012F)
  0x01, 0x30, 0x02, 0x01, 0x0F, 0x38, 0x12, 0x00, 0xD4, 0x2C, // "İ" (U+0130)
  0x01, 0x31, 0x04, 0x01, 0x09, 0x20, 0x0E, 0x00, 0xD4, 0xE1, // "ı" (U+0131)
  0x01, 0x32, 0x02, 0xF5, 0x1A, 0x2B, 0x20, 0x00, 0xD5, 0x31, // "Ĳ" (U+0132)
  0x01, 0x33, 0x03, 0xF3, 0x17, 0x2D, 0x1B, 0x00, 0xD6, 0x84, // "ĳ" (U+0133)
  0x01, 0x34, 0xFC, 0xF5, 0x0F, 0x3A, 0x0E, 0x00, 0xD7, 0xC1, // "Ĵ" (U+0134)
  0x01, 0x35, 0xFE, 0xF3, 0x0F, 0x2F, 0x0E, 0x00, 0xD8, 0xCD, // "ĵ" (U+0135)
  0x01, 0x36, 0x04, 0xF4, 0x1D, 0x2B, 0x1E, 0x00, 0xD9, 0xB3, // "Ķ" (U+0136)
  0x01, 0x37, 0x04, 0xF4, 0x19, 0x2E, 0x1A, 0x00, 0xDA, 0xF7, // "ķ" (U+0137)
  0x01, 0x38, 0x04, 0x01, 0x19, 0x20, 0x1A, 0x00, 0xDC, 0x23, // "ĸ" (U+0138)
  0x01, 0x39, 0x04, 0x01, 0x17, 0x3A, 0x19, 0x00, 0xDC, 0xEA, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x03, 0x01, 0x0E, 0x3C, 0x0D, 0x00, 0xDD, 0xAE, // "ĺ" (U+013A)
  0x01, 0x3B, 0x04, 0xF4, 0x17, 0x2B, 0x19, 0x00, 0xDE, 0x5F, // "Ļ" (U+013B)
  0x01, 0x3C, 0x03, 0xF4, 0x0A, 0x2E, 0x0D, 0x00, 0xDF, 0x21, // "ļ" (U+013C)
  0x01, 0x3D, 0x04, 0x01, 0x18, 0x2B, 0x19, 0x00, 0xDF, 0xCD, // "Ľ" (U+013D)
  0x01, 0x3E, 0x04, 0x01, 0x12, 0x2E, 0x0D, 0x00, 0xE0, 0x91, // "ľ" (U+013E)
  0x01, 0x3F, 0x04, 0x01, 0x17, 0x2B, 0x19, 0x00, 0xE1, 0x49, // "Ŀ" (U+013F)
  0x01, 0x40, 0x04, 0x01, 0x12, 0x2E, 0x10, 0x00, 0xE1, 0xF5, // "ŀ" (U+0140)
  0x01, 0x41, 0x00, 0x01, 0x18, 0x2B, 0x19, 0x00, 0xE2, 0xA7, // "Ł" (U+0141)
  0x01, 0x42, 0xFF, 0x01, 0x0F, 0x2E, 0x0E, 0x00, 0xE3, 0x6D, // "ł" (U+0142)
  0x01, 0x43, 0x04, 0x01, 0x20, 0x3A, 0x26, 0x00, 0xE4, 0x20, // "Ń" (U+0143)
  0x01, 0x44, 0x04, 0x01, 0x1A, 0x2F, 0x1E, 0x00, 0xE5, 0x91, // "ń" (U+0144)
  0x01, 0x45, 0x04, 0xF4, 0x20, 0x2B, 0x26, 0x00, 0xE6, 0x92, // "Ņ" (U+0145)
  0x01, 0x46, 0x04, 0xF4, 0x1A, 0x21, 0x1E, 0x00, 0xE8, 0x00, // "ņ" (U+0146)
  0x01, 0x47, 0x04, 0x01, 0x20, 0x3A, 0x26, 0x00, 0xE8, 0xFD, // "Ň" (U+0147)
  0x01, 0x48, 0x04, 0x01, 0x1A, 0x2F, 0x1E, 0x00, 0xEA, 0x79, // "ň" (U+0148)
  0x01, 0x49, 0x00, 0x01, 0x1E, 0x2B, 0x22, 0x00, 0xEB, 0x84, // "ŉ" (U+0149)
  0x01, 0x4A, 0x04, 0xF5, 0x20, 0x2B, 0x26, 0x00, 0xEC, 0xA8, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x04, 0xF3, 0x1A, 0x21, 0x1E, 0x00, 0xEE, 0x1C, // "ŋ" (U+014B)
  0x01, 0x4C, 0x03, 0x00, 0x21, 0x35, 0x25, 0x00, 0xEF, 0x27, // "Ō" (U+014C)
  0x01, 0x4D, 0x02, 0x00, 0x1A, 0x2A, 0x1E, 0x00, 0xF0, 0x6A, // "ō" (U+014D)
  0x01, 0x4E, 0x03, 0x00, 0x21, 0x38, 0x25, 0x00, 0xF1, 0x58, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x02, 0x00, 0x1A, 0x2D, 0x1E, 0x00, 0xF2, 0xB5, // "ŏ" (U+014F)
  0x01, 0x50, 0x03, 0x00, 0x21, 0x3A, 0x25, 0x00, 0xF3, 0xBD, // "Ő" (U+0150)
  0x01, 0x51, 0x02, 0x00, 0x1A, 0x2F, 0x1E, 0x00, 0xF5, 0x33, // "ő" (U+0151)
  0x01, 0x52, 0x03, 0x00, 0x28, 0x2C, 0x2C, 0x00, 0xF6, 0x52, // "Œ" (U+0152)
  0x01, 0x53, 0x02, 0x00, 0x2B, 0x21, 0x2E, 0x00, 0xF7, 0x99, // "œ" (U+0153)
  0x01, 0x54, 0x04, 0x01, 0x1D, 0x3A, 0x1F, 0x00, 0xF8, 0xE4, // "Ŕ" (U+0154)
  0x01, 0x55, 0x04, 0x01, 0x13, 0x2F, 0x14, 0x00, 0xFA, 0x2B, // "ŕ" (U+0155)
  0x01, 0x56, 0x04, 0xF4, 0x1D, 0x2B, 0x1F, 0x00, 0xFA, 0xDF, // "Ŗ" (U+0156)
  0x01, 0x57, 0x03, 0xF4, 0x13, 0x21, 0x14, 0x00, 0xFC, 0x21, // "ŗ" (U+0157)
  0x01, 0x58, 0x04, 0x01, 0x1D, 0x3A, 0x1F, 0x00, 0xFC, 0xD3, // "Ř" (U+0158)
  0x01, 0x59, 0x03, 0x01, 0x14, 0x2F, 0x14, 0x00, 0xFE, 0x26, // "ř" (U+0159)
  0x01, 0x5A, 0x02, 0x00, 0x18, 0x3A, 0x1B, 0x00, 0xFE, 0xE8, // "Ś" (U+015A)
  0x01, 0x5B, 0x02, 0x00, 0x14, 0x2F, 0x17, 0x00, 0xFF, 0xFB, // "ś" (U+015B)
  0x01, 0x5C, 0x02, 0x00, 0x18, 0x3A, 0x1B, 0x01, 0x00, 0xCB, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x02, 0x00, 0x14, 0x2F, 0x17, 0x01, 0x01, 0xF2, // "ŝ" (U+015D)
  0x01, 0x5E, 0x02, 0xF3, 0x18, 0x2C, 0x1B, 0x01, 0x02, 0xD8, // "Ş" (U+015E)
  0x01, 0x5F, 0x02, 0xF3, 0x14, 0x21, 0x17, 0x01, 0x03, 0xFC, // "ş" (U+015F)
  0x01, 0x60, 0x02, 0x00, 0x18, 0x3A, 0x1B, 0x01, 0x04, 0xDD, // "Š" (U+0160)
  0x01, 0x61, 0x02, 0x00, 0x14, 0x2F, 0x17, 0x01, 0x05, 0xFB, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xF3, 0x19, 0x2B, 0x1A, 0x01, 0x06, 0xD7, // "Ţ" (U+0162)
  0x01, 0x63, 0x01, 0xF3, 0x10, 0x28, 0x11, 0x01, 0x07, 0xD0, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x19, 0x3A, 0x1A, 0x01, 0x08, 0xA0, // "Ť" (U+0164)
  0x01, 0x65, 0x01, 0x00, 0x17, 0x2E, 0x11, 0x01, 0x09, 0x8F, // "ť" (U+0165)
  0x01, 0x66, 0x00, 0x01, 0x19, 0x2B, 0x1A, 0x01, 0x0A, 0x59, // "Ŧ" (U+0166)
  0x01, 0x67, 0x01, 0x00, 0x10, 0x28, 0x11, 0x01, 0x0B, 0x0F, // "ŧ" (U+0167)
  0x01, 0x68, 0x04, 0x00, 0x1E, 0x37, 0x23, 0x01, 0x0B, 0xAA, // "Ũ" (U+0168)
  0x01, 0x69, 0x04, 0x00, 0x19, 0x2C, 0x1E, 0x01, 0x0C, 0xFD, // "ũ" (U+0169)
  0x01, 0x6A, 0x04, 0x00, 0x1E, 0x35, 0x23, 0x01, 0x0D, 0xCC, // "Ū" (U+016A)
  0x01, 0x6B, 0x04, 0x00, 0x19, 0x2A, 0x1E, 0x01, 0x0F, 0x00, // "ū" (U+016B)
  0x01, 0x6C, 0x04, 0x00, 0x1E, 0x38, 0x23, 0x01, 0x0F, 0xB1, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x04, 0x00, 0x19, 0x2D, 0x1E, 0x01, 0x11, 0x00, // "ŭ" (U+016D)
  0x01, 0x6E, 0x04, 0x00, 0x1E, 0x3C, 0x23, 0x01, 0x11, 0xCB, // "Ů" (U+016E)
  0x01, 0x6F, 0x04, 0x00, 0x19, 0x31, 0x1E, 0x01, 0x13, 0x34, // "ů" (U+016F)
  0x01, 0x70, 0x04, 0x00, 0x1E, 0x3A, 0x23, 0x01, 0x14, 0x19, // "Ű" (U+0170)
  0x01, 0x71, 0x04, 0x00, 0x1B, 0x2F, 0x1E, 0x01, 0x15, 0x7E, // "ű" (U+0171)
  0x01, 0x72, 0x04, 0xF3, 0x1E, 0x2B, 0x23, 0x01, 0x16, 0x6F, // "Ų" (U+0172)
  0x01, 0x73, 0x04, 0xF4, 0x1A, 0x20, 0x1E, 0x01, 0x17, 0xC2, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x2E, 0x3A, 0x2F, 0x01, 0x18, 0xA2, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x26, 0x2F, 0x28, 0x01, 0x1A, 0xC6, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x01, 0x1A, 0x3A, 0x1B, 0x01, 0x1C, 0x5E, // "Ŷ" (U+0176)
  0x01, 0x77, 0x00, 0xF3, 0x18, 0x2F, 0x19, 0x01, 0x1D, 0x85, // "ŷ" (U+0177)
  0x01, 0x78, 0x00, 0x01, 0x1A, 0x36, 0x1B, 0x01, 0x1E, 0xC0, // "Ÿ" (U+0178)
  0x01, 0x79, 0x01, 0x01, 0x17, 0x3A, 0x19, 0x01, 0x1F, 0xCE, // "Ź" (U+0179)
  0x01, 0x7A, 0x01, 0x01, 0x13, 0x2F, 0x15, 0x01, 0x20, 0xB0, // "ź" (U+017A)
  0x01, 0x7B, 0x01, 0x01, 0x17, 0x38, 0x19, 0x01, 0x21, 0x53, // "Ż" (U+017B)
  0x01, 0x7C, 0x01, 0x01, 0x13, 0x2D, 0x15, 0x01, 0x22, 0x24, // "ż" (U+017C)
  0x01, 0x7D, 0x01, 0x01, 0x17, 0x3A, 0x19, 0x01, 0x22, 0xB8, // "Ž" (U+017D)
  0x01, 0x7E, 0x01, 0x01, 0x13, 0x2F, 0x15, 0x01, 0x23, 0xA4, // "ž" (U+017E)
  0x01, 0x7F, 0x04, 0x01, 0x11, 0x2E, 0x0F, 0x01, 0x24, 0x53, // "ſ" (U+017F)
  0x03, 0xA9, 0x01, 0x01, 0x23, 0x2C, 0x25, 0x01, 0x24, 0xFA, // "Ω" (U+03A9)
  0x03, 0xBC, 0x04, 0xF3, 0x1A, 0x20, 0x1E, 0x01, 0x26, 0x34, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x00, 0x1E, 0x20, 0x20, 0x01, 0x27, 0x3A, // "π" (U+03C0)
  0x20, 0x13, 0x02, 0x0F, 0x1B, 0x13, 0x1E, 0x01, 0x28, 0x24, // "–" (U+2013)
  0x20, 0x14, 0x02, 0x0F, 0x39, 0x13, 0x3C, 0x01, 0x28, 0x37, // "—" (U+2014)
  0x20, 0xAC, 0x01, 0x00, 0x1A, 0x2C, 0x1C, 0x01, 0x28, 0x4C, // "€" (U+20AC)
  0x20, 0xBF, 0x04, 0xFB, 0x1A, 0x31, 0x1C, 0x01, 0x29, 0x16, // "₿" (U+20BF)
  0x20, 0x18, 0x01, 0x1D, 0x09, 0x2B, 0x0B, 0x01, 0x2A, 0x5C, // "‘" (U+2018)
  0x20, 0x19, 0x01, 0x1D, 0x09, 0x2B, 0x0B, 0x01, 0x2A, 0x88, // "’" (U+2019)
  0x20, 0x1A, 0x02, 0xF9, 0x0A, 0x07, 0x0E, 0x01, 0x2A, 0xB4, // "‚" (U+201A)
  0x20, 0x1B, 0x01, 0x1D, 0x09, 0x2B, 0x0B, 0x01, 0x2A, 0xE0, // "‛" (U+201B)
  0x20, 0x1C, 0x01, 0x1D, 0x13, 0x2B, 0x15, 0x01, 0x2B, 0x0A, // "“" (U+201C)
  0x20, 0x1D, 0x01, 0x1D, 0x13, 0x2B, 0x15, 0x01, 0x2B, 0x65, // "”" (U+201D)
  0x20, 0x1E, 0x01, 0xF9, 0x13, 0x07, 0x16, 0x01, 0x2B, 0xBC, // "„" (U+201E)
  0x20, 0x1F, 0x01, 0x1D, 0x13, 0x2B, 0x15, 0x01, 0x2C, 0x13, // "‟" (U+201F)
  0x20, 0x20, 0x03, 0x01, 0x18, 0x2E, 0x1C, 0x01, 0x2C, 0x6B, // "†" (U+2020)
  0x20, 0x21, 0x03, 0x01, 0x18, 0x2E, 0x1C, 0x01, 0x2D, 0x2C, // "‡" (U+2021)
  0x20, 0x22, 0x04, 0x0F, 0x12, 0x1E, 0x17, 0x01, 0x2D, 0xF2, // "•" (U+2022)
  0x20, 0x26, 0x03, 0x00, 0x26, 0x08, 0x2B, 0x01, 0x2E, 0x2F, // "…" (U+2026)
  0x20, 0x30, 0x02, 0x00, 0x3A, 0x2C, 0x3D, 0x01, 0x2E, 0x8C, // "‰" (U+2030)
  0x20, 0x39, 0x02, 0x04, 0x0E, 0x1C, 0x11, 0x01, 0x31, 0x00, // "‹" (U+2039)
  0x20, 0x3A, 0x02, 0x04, 0x0E, 0x1C, 0x11, 0x01, 0x31, 0x58, // "›" (U+203A)
  0x20, 0x44, 0xF6, 0x01, 0x11, 0x2B, 0x07, 0x01, 0x31, 0xAF, // "⁄" (U+2044)
  0x21, 0x22, 0x00, 0x17, 0x24, 0x2C, 0x28, 0x01, 0x32, 0x7C, // "™" (U+2122)
  0x21, 0x52, 0x02, 0x00, 0x39, 0x2B, 0x3C, 0x01, 0x33, 0x80, // "⅒" (U+2152)
  0xFB, 0x01, 0x00, 0x01, 0x1A, 0x2F, 0x1E, 0x01, 0x35, 0xA0, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0x00, 0x01, 0x1A, 0x2F, 0x1E, 0x01, 0x36, 0xCD, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x03, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0x61, 0x02, // "a (U+0022 U+0061)
  0x00, 0x22, 0x00, 0x63, 0x03, // "c (U+0022 U+0063)
  0x00, 0x22, 0x00, 0x64, 0x03, // "d (U+0022 U+0064)
  0x00, 0x22, 0x00, 0x65, 0x03, // "e (U+0022 U+0065)
  0x00, 0x22, 0x00, 0x67, 0x01, // "g (U+0022 U+0067)
  0x00, 0x22, 0x00, 0x6D, 0x01, // "m (U+0022 U+006D)
  0x00, 0x22, 0x00, 0x6E, 0x01, // "n (U+0022 U+006E)
  0x00, 0x22, 0x00, 0x6F, 0x03, // "o (U+0022 U+006F)
  0x00, 0x22, 0x00, 0x70, 0x01, // "p (U+0022 U+0070)
  0x00, 0x22, 0x00, 0x71, 0x03, // "q (U+0022 U+0071)
  0x00, 0x22, 0x00, 0x72, 0x01, // "r (U+0022 U+0072)
  0x00, 0x22, 0x00, 0x73, 0x01, // "s (U+0022 U+0073)
  0x00, 0x22, 0x00, 0x75, 0x01, // "u (U+0022 U+0075)
  0x00, 0x22, 0x00, 0xC0, 0x03, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x03, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x03, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x03, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x03, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x03, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xC6, 0x04, // "Æ (U+0022 U+00C6)
  0x00, 0x22, 0x00, 0xE0, 0x03, // "à (U+0022 U+00E0)
  0x00, 0x22, 0x00, 0xE1, 0x02, // "á (U+0022 U+00E1)
  0x00, 0x22, 0x00, 0xE2, 0x02, // "â (U+0022 U+00E2)
  0x00, 0x22, 0x00, 0xE3, 0x02, // "ã (U+0022 U+00E3)
  0x00, 0x22, 0x00, 0xE4, 0x02, // "ä (U+0022 U+00E4)
  0x00, 0x22, 0x00, 0xE5, 0x02, // "å (U+0022 U+00E5)
  0x00, 0x22, 0x00, 0xE6, 0x02, // "æ (U+0022 U+00E6)
  0x00, 0x22, 0x00, 0xE7, 0x03, // "ç (U+0022 U+00E7)
  0x00, 0x22, 0x00, 0xE8, 0x03, // "è (U+0022 U+00E8)
  0x00, 0x22, 0x00, 0xE9, 0x03, // "é (U+0022 U+00E9)
  0x00, 0x22, 0x00, 0xEA, 0x03, // "ê (U+0022 U+00EA)
  0x00, 0x22, 0x00, 0xEB, 0x03, // "ë (U+0022 U+00EB)
  0x00, 0x22, 0x00, 0xF2, 0x03, // "ò (U+0022 U+00F2)
  0x00, 0x22, 0x00, 0xF3, 0x03, // "ó (U+0022 U+00F3)
  0x00, 0x22, 0x00, 0xF4, 0x03, // "ô (U+0022 U+00F4)
  0x00, 0x22, 0x00, 0xF5, 0x03, // "õ (U+0022 U+00F5)
  0x00, 0x22, 0x00, 0xF6, 0x03, // "ö (U+0022 U+00F6)
  0x00, 0x22, 0x00, 0xF8, 0x03, // "ø (U+0022 U+00F8)
  0x00, 0x22, 0x00, 0xF9, 0x01, // "ù (U+0022 U+00F9)
  0x00, 0x22, 0x00, 0xFA, 0x01, // "ú (U+0022 U+00FA)
  0x00, 0x22, 0x00, 0xFB, 0x01, // "û (U+0022 U+00FB)
  0x00, 0x22, 0x00, 0xFC, 0x01, // "ü (U+0022 U+00FC)
  0x00, 0x22, 0x01, 0x00, 0x03, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x01, 0x02, // "ā (U+0022 U+0101)
  0x00, 0x22, 0x01, 0x02, 0x03, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x03, 0x02, // "ă (U+0022 U+0103)
  0x00, 0x22, 0x01, 0x04, 0x03, // "Ą (U+0022 U+0104)
  0x00, 0x22, 0x01, 0x05, 0x02, // "ą (U+0022 U+0105)
  0x00, 0x22, 0x01, 0x07, 0x03, // "ć (U+0022 U+0107)
  0x00, 0x22, 0x01, 0x09, 0x03, // "ĉ (U+0022 U+0109)
  0x00, 0x22, 0x01, 0x0B, 0x03, // "ċ (U+0022 U+010B)
  0x00, 0x22, 0x01, 0x0D, 0x03, // "č (U+0022 U+010D)
  0x00, 0x22, 0x01, 0x0F, 0x03, // "ď (U+0022 U+010F)
  0x00, 0x22, 0x01, 0x11, 0x03, // "đ (U+0022 U+0111)
  0x00, 0x22, 0x01, 0x13, 0x03, // "ē (U+0022 U+0113)
  0x00, 0x22, 0x01, 0x15, 0x03, // "ĕ (U+0022 U+0115)
  0x00, 0x22, 0x01, 0x17, 0x03, // "ė (U+0022 U+0117)
  0x00, 0x22, 0x01, 0x19, 0x03, // "ę (U+0022 U+0119)
  0x00, 0x22, 0x01, 0x1B, 0x03, // "ě (U+0022 U+011B)
  0x00, 0x22, 0x01, 0x1D, 0x01, // "ĝ (U+0022 U+011D)
  0x00, 0x22, 0x01, 0x1F, 0x01, // "ğ (U+0022 U+011F)
  0x00, 0x22, 0x01, 0x21, 0x01, // "ġ (U+0022 U+0121)
  0x00, 0x22, 0x01, 0x23, 0x01, // "ģ (U+0022 U+0123)
  0x00, 0x22, 0x01, 0x38, 0x01, // "ĸ (U+0022 U+0138)
  0x00, 0x22, 0x01, 0x44, 0x01, // "ń (U+0022 U+0144)
  0x00, 0x22, 0x01, 0x46, 0x01, // "ņ (U+0022 U+0146)
  0x00, 0x22, 0x01, 0x4B, 0x01, // "ŋ (U+0022 U+014B)
  0x00, 0x22, 0x01, 0x4D, 0x03, // "ō (U+0022 U+014D)
  0x00, 0x22, 0x01, 0x4F, 0x03, // "ŏ (U+0022 U+014F)
  0x00, 0x22, 0x01, 0x51, 0x03, // "ő (U+0022 U+0151)
  0x00, 0x22, 0x01, 0x53, 0x03, // "œ (U+0022 U+0153)
  0x00, 0x22, 0x01, 0x55, 0x01, // "ŕ (U+0022 U+0155)
  0x00, 0x22, 0x01, 0x57, 0x01, // "ŗ (U+0022 U+0157)
  0x00, 0x22, 0x01, 0x5B, 0x01, // "ś (U+0022 U+015B)
  0x00, 0x22, 0x01, 0x5F, 0x01, // "ş (U+0022 U+015F)
  0x00, 0x22, 0x01, 0x69, 0x01, // "ũ (U+0022 U+0169)
  0x00, 0x22, 0x01, 0x6B, 0x01, // "ū (U+0022 U+016B)
  0x00, 0x22, 0x01, 0x6D, 0x01, // "ŭ (U+0022 U+016D)
  0x00, 0x22, 0x01, 0x6F, 0x01, // "ů (U+0022 U+016F)
  0x00, 0x22, 0x01, 0x71, 0x01, // "ű (U+0022 U+0171)
  0x00, 0x22, 0x01, 0x73, 0x01, // "ų (U+0022 U+0173)
  0x00, 0x22, 0x03, 0xBC, 0x01, // "μ (U+0022 U+03BC)
  0x00, 0x26, 0x00, 0x54, 0x02, // &T (U+0026 U+0054)
  0x00, 0x26, 0x00, 0x56, 0x01, // &V (U+0026 U+0056)
  0x00, 0x26, 0x00, 0x57, 0x01, // &W (U+0026 U+0057)
  0x00, 0x26, 0x00, 0x59, 0x01, // &Y (U+0026 U+0059)
  0x00, 0x26, 0x00, 0xDD, 0x01, // &Ý (U+0026 U+00DD)
  0x00, 0x26, 0x01, 0x62, 0x02, // &Ţ (U+0026 U+0162)
  0x00, 0x26, 0x01, 0x64, 0x02, // &Ť (U+0026 U+0164)
  0x00, 0x26, 0x01, 0x66, 0x02, // &Ŧ (U+0026 U+0166)
  0x00, 0x26, 0x01, 0x74, 0x01, // &Ŵ (U+0026 U+0174)
  0x00, 0x26, 0x01, 0x76, 0x01, // &Ŷ (U+0026 U+0176)
  0x00, 0x26, 0x01, 0x78, 0x01, // &Ÿ (U+0026 U+0178)
  0x00, 0x27, 0x00, 0x41, 0x03, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0x61, 0x02, // 'a (U+0027 U+0061)
  0x00, 0x27, 0x00, 0x63, 0x03, // 'c (U+0027 U+0063)
  0x00, 0x27, 0x00, 0x64, 0x03, // 'd (U+0027 U+0064)
  0x00, 0x27, 0x00, 0x65, 0x03, // 'e (U+0027 U+0065)
  0x00, 0x27, 0x00, 0x67, 0x01, // 'g (U+0027 U+0067)
  0x00, 0x27, 0x00, 0x6D, 0x01, // 'm (U+0027 U+006D)
  0x00, 0x27, 0x00, 0x6E, 0x01, // 'n (U+0027 U+006E)
  0x00, 0x27, 0x00, 0x6F, 0x03, // 'o (U+0027 U+006F)
  0x00, 0x27, 0x00, 0x70, 0x01, // 'p (U+0027 U+0070)
  0x00, 0x27, 0x00, 0x71, 0x03, // 'q (U+0027 U+0071)
  0x00, 0x27, 0x00, 0x72, 0x01, // 'r (U+0027 U+0072)
  0x00, 0x27, 0x00, 0x73, 0x01, // 's (U+0027 U+0073)
  0x00, 0x27, 0x00, 0x75, 0x01, // 'u (U+0027 U+0075)
  0x00, 0x27, 0x00, 0xC0, 0x03, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x03, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x03, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x03, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x03, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x03, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xC6, 0x04, // 'Æ (U+0027 U+00C6)
  0x00, 0x27, 0x00, 0xE0, 0x03, // 'à (U+0027 U+00E0)
  0x00, 0x27, 0x00, 0xE1, 0x02, // 'á (U+0027 U+00E1)
  0x00, 0x27, 0x00, 0xE2, 0x02, // 'â (U+0027 U+00E2)
  0x00, 0x27, 0x00, 0xE3, 0x02, // 'ã (U+0027 U+00E3)
  0x00, 0x27, 0x00, 0xE4, 0x02, // 'ä (U+0027 U+00E4)
  0x00, 0x27, 0x00, 0xE5, 0x02, // 'å (U+0027 U+00E5)
  0x00, 0x27, 0x00, 0xE6, 0x02, // 'æ (U+0027 U+00E6)
  0x00, 0x27, 0x00, 0xE7, 0x03, // 'ç (U+0027 U+00E7)
  0x00, 0x27, 0x00, 0xE8, 0x03, // 'è (U+0027 U+00E8)
  0x00, 0x27, 0x00, 0xE9, 0x03, // 'é (U+0027 U+00E9)
  0x00, 0x27, 0x00, 0xEA, 0x03, // 'ê (U+0027 U+00EA)
  0x00, 0x27, 0x00, 0xEB, 0x03, // 'ë (U+0027 U+00EB)
  0x00, 0x27, 0x00, 0xF2, 0x03, // 'ò (U+0027 U+00F2)
  0x00, 0x27, 0x00, 0xF3, 0x03, // 'ó (U+0027 U+00F3)
  0x00, 0x27, 0x00, 0xF4, 0x03, // 'ô (U+0027 U+00F4)
  0x00, 0x27, 0x00, 0xF5, 0x03, // 'õ (U+0027 U+00F5)
  0x00, 0x27, 0x00, 0xF6, 0x03, // 'ö (U+0027 U+00F6)
  0x00, 0x27, 0x00, 0xF8, 0x03, // 'ø (U+0027 U+00F8)
  0x00, 0x27, 0x00, 0xF9, 0x01, // 'ù (U+0027 U+00F9)
  0x00, 0x27, 0x00, 0xFA, 0x01, // 'ú (U+0027 U+00FA)
  0x00, 0x27, 0x00, 0xFB, 0x01, // 'û (U+0027 U+00FB)
  0x00, 0x27, 0x00, 0xFC, 0x01, // 'ü (U+0027 U+00FC)
  0x00, 0x27, 0x01, 0x00, 0x03, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x01, 0x02, // 'ā (U+0027 U+0101)
  0x00, 0x27, 0x01, 0x02, 0x03, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x03, 0x02, // 'ă (U+0027 U+0103)
  0x00, 0x27, 0x01, 0x04, 0x03, // 'Ą (U+0027 U+0104)
  0x00, 0x27, 0x01, 0x05, 0x02, // 'ą (U+0027 U+0105)
  0x00, 0x27, 0x01, 0x07, 0x03, // 'ć (U+0027 U+0107)
  0x00, 0x27, 0x01, 0x09, 0x03, // 'ĉ (U+0027 U+0109)
  0x00, 0x27, 0x01, 0x0B, 0x03, // 'ċ (U+0027 U+010B)
  0x00, 0x27, 0x01, 0x0D, 0x03, // 'č (U+0027 U+010D)
  0x00, 0x27, 0x01, 0x0F, 0x03, // 'ď (U+0027 U+010F)
  0x00, 0x27, 0x01, 0x11, 0x03, // 'đ (U+0027 U+0111)
  0x00, 0x27, 0x01, 0x13, 0x03, // 'ē (U+0027 U+0113)
  0x00, 0x27, 0x01, 0x15, 0x03, // 'ĕ (U+0027 U+0115)
  0x00, 0x27, 0x01, 0x17, 0x03, // 'ė (U+0027 U+0117)
  0x00, 0x27, 0x01, 0x19, 0x03, // 'ę (U+0027 U+0119)
  0x00, 0x27, 0x01, 0x1B, 0x03, // 'ě (U+0027 U+011B)
  0x00, 0x27, 0x01, 0x1D, 0x01, // 'ĝ (U+0027 U+011D)
  0x00, 0x27, 0x01, 0x1F, 0x01, // 'ğ (U+0027 U+011F)
  0x00, 0x27, 0x01, 0x21, 0x01, // 'ġ (U+0027 U+0121)
  0x00, 0x27, 0x01, 0x23, 0x01, // 'ģ (U+0027 U+0123)
  0x00, 0x27, 0x01, 0x38, 0x01, // 'ĸ (U+0027 U+0138)
  0x00, 0x27, 0x01, 0x44, 0x01, // 'ń (U+0027 U+0144)
  0x00, 0x27, 0x01, 0x46, 0x01, // 'ņ (U+0027 U+0146)
  0x00, 0x27, 0x01, 0x4B, 0x01, // 'ŋ (U+0027 U+014B)
  0x00, 0x27, 0x01, 0x4D, 0x03, // 'ō (U+0027 U+014D)
  0x00, 0x27, 0x01, 0x4F, 0x03, // 'ŏ (U+0027 U+014F)
  0x00, 0x27, 0x01, 0x51, 0x03, // 'ő (U+0027 U+0151)
  0x00, 0x27, 0x01, 0x53, 0x03, // 'œ (U+0027 U+0153)
  0x00, 0x27, 0x01, 0x55, 0x01, // 'ŕ (U+0027 U+0155)
  0x00, 0x27, 0x01, 0x57, 0x01, // 'ŗ (U+0027 U+0157)
  0x00, 0x27, 0x01, 0x5B, 0x01, // 'ś (U+0027 U+015B)
  0x00, 0x27, 0x01, 0x5F, 0x01, // 'ş (U+0027 U+015F)
  0x00, 0x27, 0x01, 0x69, 0x01, // 'ũ (U+0027 U+0169)
  0x00, 0x27, 0x01, 0x6B, 0x01, // 'ū (U+0027 U+016B)
  0x00, 0x27, 0x01, 0x6D, 0x01, // 'ŭ (U+0027 U+016D)
  0x00, 0x27, 0x01, 0x6F, 0x01, // 'ů (U+0027 U+016F)
  0x00, 0x27, 0x01, 0x71, 0x01, // 'ű (U+0027 U+0171)
  0x00, 0x27, 0x01, 0x73, 0x01, // 'ų (U+0027 U+0173)
  0x00, 0x27, 0x03, 0xBC, 0x01, // 'μ (U+0027 U+03BC)
  0x00, 0x2C, 0x00, 0x43, 0x02, // ,C (U+002C U+0043)
  0x00, 0x2C, 0x00, 0x47, 0x02, // ,G (U+002C U+0047)
  0x00, 0x2C, 0x00, 0x4F, 0x02, // ,O (U+002C U+004F)
  0x00, 0x2C, 0x00, 0x51, 0x02, // ,Q (U+002C U+0051)
  0x00, 0x2C, 0x00, 0x54, 0x03, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x55, 0x01, // ,U (U+002C U+0055)
  0x00, 0x2C, 0x00, 0x56, 0x03, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x03, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x03, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0xC7, 0x02, // ,Ç (U+002C U+00C7)
  0x00, 0x2C, 0x00, 0xD2, 0x02, // ,Ò (U+002C U+00D2)
  0x00, 0x2C, 0x00, 0xD3, 0x02, // ,Ó (U+002C U+00D3)
  0x00, 0x2C, 0x00, 0xD4, 0x02, // ,Ô (U+002C U+00D4)
  0x00, 0x2C, 0x00, 0xD5, 0x02, // ,Õ (U+002C U+00D5)
  0x00, 0x2C, 0x00, 0xD6, 0x02, // ,Ö (U+002C U+00D6)
  0x00, 0x2C, 0x00, 0xD8, 0x02, // ,Ø (U+002C U+00D8)
  0x00, 0x2C, 0x00, 0xD9, 0x01, // ,Ù (U+002C U+00D9)
  0x00, 0x2C, 0x00, 0xDA, 0x01, // ,Ú (U+002C U+00DA)
  0x00, 0x2C, 0x00, 0xDB, 0x01, // ,Û (U+002C U+00DB)
  0x00, 0x2C, 0x00, 0xDC, 0x01, // ,Ü (U+002C U+00DC)
  0x00, 0x2C, 0x00, 0xDD, 0x03, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x01, 0x06, 0x02, // ,Ć (U+002C U+0106)
  0x00, 0x2C, 0x01, 0x08, 0x02, // ,Ĉ (U+002C U+0108)
  0x00, 0x2C, 0x01, 0x0A, 0x02, // ,Ċ (U+002C U+010A)
  0x00, 0x2C, 0x01, 0x0C, 0x02, // ,Č (U+002C U+010C)
  0x00, 0x2C, 0x01, 0x1C, 0x02, // ,Ĝ (U+002C U+011C)
  0x00, 0x2C, 0x01, 0x1E, 0x02, // ,Ğ (U+002C U+011E)
  0x00, 0x2C, 0x01, 0x20, 0x02, // ,Ġ (U+002C U+0120)
  0x00, 0x2C, 0x01, 0x22, 0x02, // ,Ģ (U+002C U+0122)
  0x00, 0x2C, 0x01, 0x4C, 0x02, // ,Ō (U+002C U+014C)
  0x00, 0x2C, 0x01, 0x4E, 0x02, // ,Ŏ (U+002C U+014E)
  0x00, 0x2C, 0x01, 0x50, 0x02, // ,Ő (U+002C U+0150)
  0x00, 0x2C, 0x01, 0x52, 0x02, // ,Œ (U+002C U+0152)
  0x00, 0x2C, 0x01, 0x62, 0x03, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x03, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x03, // ,Ŧ (U+002C U+0166)
  0x00, 0x2C, 0x01, 0x68, 0x01, // ,Ũ (U+002C U+0168)
  0x00, 0x2C, 0x01, 0x6A, 0x01, // ,Ū (U+002C U+016A)
  0x00, 0x2C, 0x01, 0x6C, 0x01, // ,Ŭ (U+002C U+016C)
  0x00, 0x2C, 0x01, 0x6E, 0x01, // ,Ů (U+002C U+016E)
  0x00, 0x2C, 0x01, 0x70, 0x01, // ,Ű (U+002C U+0170)
  0x00, 0x2C, 0x01, 0x72, 0x01, // ,Ų (U+002C U+0172)
  0x00, 0x2C, 0x01, 0x74, 0x03, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x76, 0x03, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x78, 0x03, // ,Ÿ (U+002C U+0178)
  0x00, 0x2D, 0x00, 0x54, 0x02, // -T (U+002D U+0054)
  0x00, 0x2D, 0x01, 0x62, 0x02, // -Ţ (U+002D U+0162)
  0x00, 0x2D, 0x01, 0x64, 0x02, // -Ť (U+002D U+0164)
  0x00, 0x2D, 0x01, 0x66, 0x02, // -Ŧ (U+002D U+0166)
  0x00, 0x2E, 0x00, 0x43, 0x02, // .C (U+002E U+0043)
  0x00, 0x2E, 0x00, 0x47, 0x02, // .G (U+002E U+0047)
  0x00, 0x2E, 0x00, 0x4F, 0x02, // .O (U+002E U+004F)
  0x00, 0x2E, 0x00, 0x51, 0x02, // .Q (U+002E U+0051)
  0x00, 0x2E, 0x00, 0x54, 0x03, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x55, 0x01, // .U (U+002E U+0055)
  0x00, 0x2E, 0x00, 0x56, 0x03, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x03, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x03, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0xC7, 0x02, // .Ç (U+002E U+00C7)
  0x00, 0x2E, 0x00, 0xD2, 0x02, // .Ò (U+002E U+00D2)
  0x00, 0x2E, 0x00, 0xD3, 0x02, // .Ó (U+002E U+00D3)
  0x00, 0x2E, 0x00, 0xD4, 0x02, // .Ô (U+002E U+00D4)
  0x00, 0x2E, 0x00, 0xD5, 0x02, // .Õ (U+002E U+00D5)
  0x00, 0x2E, 0x00, 0xD6, 0x02, // .Ö (U+002E U+00D6)
  0x00, 0x2E, 0x00, 0xD8, 0x02, // .Ø (U+002E U+00D8)
  0x00, 0x2E, 0x00, 0xD9, 0x01, // .Ù (U+002E U+00D9)
  0x00, 0x2E, 0x00, 0xDA, 0x01, // .Ú (U+002E U+00DA)
  0x00, 0x2E, 0x00, 0xDB, 0x01, // .Û (U+002E U+00DB)
  0x00, 0x2E, 0x00, 0xDC, 0x01, // .Ü (U+002E U+00DC)
  0x00, 0x2E, 0x00, 0xDD, 0x03, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x01, 0x06, 0x02, // .Ć (U+002E U+0106)
  0x00, 0x2E, 0x01, 0x08, 0x02, // .Ĉ (U+002E U+0108)
  0x00, 0x2E, 0x01, 0x0A, 0x02, // .Ċ (U+002E U+010A)
  0x00, 0x2E, 0x01, 0x0C, 0x02, // .Č (U+002E U+010C)
  0x00, 0x2E, 0x01, 0x1C, 0x02, // .Ĝ (U+002E U+011C)
  0x00, 0x2E, 0x01, 0x1E, 0x02, // .Ğ (U+002E U+011E)
  0x00, 0x2E, 0x01, 0x20, 0x02, // .Ġ (U+002E U+0120)
  0x00, 0x2E, 0x01, 0x22, 0x02, // .Ģ (U+002E U+0122)
  0x00, 0x2E, 0x01, 0x4C, 0x02, // .Ō (U+002E U+014C)
  0x00, 0x2E, 0x01, 0x4E, 0x02, // .Ŏ (U+002E U+014E)
  0x00, 0x2E, 0x01, 0x50, 0x02, // .Ő (U+002E U+0150)
  0x00, 0x2E, 0x01, 0x52, 0x02, // .Œ (U+002E U+0152)
  0x00, 0x2E, 0x01, 0x62, 0x03, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x03, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x03, // .Ŧ (U+002E U+0166)
  0x00, 0x2E, 0x01, 0x68, 0x01, // .Ũ (U+002E U+0168)
  0x00, 0x2E, 0x01, 0x6A, 0x01, // .Ū (U+002E U+016A)
  0x00, 0x2E, 0x01, 0x6C, 0x01, // .Ŭ (U+002E U+016C)
  0x00, 0x2E, 0x01, 0x6E, 0x01, // .Ů (U+002E U+016E)
  0x00, 0x2E, 0x01, 0x70, 0x01, // .Ű (U+002E U+0170)
  0x00, 0x2E, 0x01, 0x72, 0x01, // .Ų (U+002E U+0172)
  0x00, 0x2E, 0x01, 0x74, 0x03, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x76, 0x03, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x78, 0x03, // .Ÿ (U+002E U+0178)
  0x00, 0x30, 0x20, 0x44, 0x08, // 0⁄ (U+0030 U+2044)
  0x00, 0x31, 0x20, 0x44, 0x08, // 1⁄ (U+0031 U+2044)
  0x00, 0x32, 0x20, 0x44, 0x08, // 2⁄ (U+0032 U+2044)
  0x00, 0x33, 0x20, 0x44, 0x08, // 3⁄ (U+0033 U+2044)
  0x00, 0x34, 0x20, 0x44, 0x08, // 4⁄ (U+0034 U+2044)
  0x00, 0x35, 0x20, 0x44, 0x08, // 5⁄ (U+0035 U+2044)
  0x00, 0x36, 0x20, 0x44, 0x08, // 6⁄ (U+0036 U+2044)
  0x00, 0x37, 0x20, 0x44, 0x08, // 7⁄ (U+0037 U+2044)
  0x00, 0x38, 0x20, 0x44, 0x08, // 8⁄ (U+0038 U+2044)
  0x00, 0x39, 0x20, 0x44, 0x08, // 9⁄ (U+0039 U+2044)
  0x00, 0x41, 0x00, 0x22, 0x03, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x03, // A' (U+0041 U+0027)
  0x00, 0x41, 0x00, 0x54, 0x02, // AT (U+0041 U+0054)
  0x00, 0x41, 0x00, 0x56, 0x01, // AV (U+0041 U+0056)
  0x00, 0x41, 0x00, 0x57, 0x01, // AW (U+0041 U+0057)
  0x00, 0x41, 0x00, 0x59, 0x02, // AY (U+0041 U+0059)
  0x00, 0x41, 0x00, 0xDD, 0x02, // AÝ (U+0041 U+00DD)
  0x00, 0x41, 0x01, 0x62, 0x02, // AŢ (U+0041 U+0162)
  0x00, 0x41, 0x01, 0x64, 0x02, // AŤ (U+0041 U+0164)
  0x00, 0x41, 0x01, 0x66, 0x02, // AŦ (U+0041 U+0166)
  0x00, 0x41, 0x01, 0x74, 0x01, // AŴ (U+0041 U+0174)
  0x00, 0x41, 0x01, 0x76, 0x02, // AŶ (U+0041 U+0176)
  0x00, 0x41, 0x01, 0x78, 0x02, // AŸ (U+0041 U+0178)
  0x00, 0x41, 0x20, 0x19, 0x03, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1D, 0x03, // A” (U+0041 U+201D)
  0x00, 0x42, 0x00, 0x2C, 0x01, // B, (U+0042 U+002C)
  0x00, 0x42, 0x00, 0x2E, 0x01, // B. (U+0042 U+002E)
  0x00, 0x42, 0x20, 0x1A, 0x01, // B‚ (U+0042 U+201A)
  0x00, 0x42, 0x20, 0x1E, 0x01, // B„ (U+0042 U+201E)
  0x00, 0x42, 0x20, 0x26, 0x01, // B… (U+0042 U+2026)
  0x00, 0x43, 0x00, 0x43, 0x01, // CC (U+0043 U+0043)
  0x00, 0x43, 0x00, 0x47, 0x01, // CG (U+0043 U+0047)
  0x00, 0x43, 0x00, 0x4F, 0x01, // CO (U+0043 U+004F)
  0x00, 0x43, 0x00, 0x51, 0x01, // CQ (U+0043 U+0051)
  0x00, 0x43, 0x00, 0xAB, 0x01, // C« (U+0043 U+00AB)
  0x00, 0x43, 0x00, 0xC7, 0x01, // CÇ (U+0043 U+00C7)
  0x00, 0x43, 0x00, 0xD2, 0x01, // CÒ (U+0043 U+00D2)
  0x00, 0x43, 0x00, 0xD3, 0x01, // CÓ (U+0043 U+00D3)
  0x00, 0x43, 0x00, 0xD4, 0x01, // CÔ (U+0043 U+00D4)
  0x00, 0x43, 0x00, 0xD5, 0x01, // CÕ (U+0043 U+00D5)
  0x00, 0x43, 0x00, 0xD6, 0x01, // CÖ (U+0043 U+00D6)
  0x00, 0x43, 0x00, 0xD8, 0x01, // CØ (U+0043 U+00D8)
  0x00, 0x43, 0x01, 0x06, 0x01, // CĆ (U+0043 U+0106)
  0x00, 0x43, 0x01, 0x08, 0x01, // CĈ (U+0043 U+0108)
  0x00, 0x43, 0x01, 0x0A, 0x01, // CĊ (U+0043 U+010A)
  0x00, 0x43, 0x01, 0x0C, 0x01, // CČ (U+0043 U+010C)
  0x00, 0x43, 0x01, 0x1C, 0x01, // CĜ (U+0043 U+011C)
  0x00, 0x43, 0x01, 0x1E, 0x01, // CĞ (U+0043 U+011E)
  0x00, 0x43, 0x01, 0x20, 0x01, // CĠ (U+0043 U+0120)
  0x00, 0x43, 0x01, 0x22, 0x01, // CĢ (U+0043 U+0122)
  0x00, 0x43, 0x01, 0x4C, 0x01, // CŌ (U+0043 U+014C)
  0x00, 0x43, 0x01, 0x4E, 0x01, // CŎ (U+0043 U+014E)
  0x00, 0x43, 0x01, 0x50, 0x01, // CŐ (U+0043 U+0150)
  0x00, 0x43, 0x01, 0x52, 0x01, // CŒ (U+0043 U+0152)
  0x00, 0x43, 0x20, 0x39, 0x01, // C‹ (U+0043 U+2039)
  0x00, 0x44, 0x00, 0x2C, 0x02, // D, (U+0044 U+002C)
  0x00, 0x44, 0x00, 0x2E, 0x02, // D. (U+0044 U+002E)
  0x00, 0x44, 0x00, 0x54, 0x01, // DT (U+0044 U+0054)
  0x00, 0x44, 0x01, 0x62, 0x01, // DŢ (U+0044 U+0162)
  0x00, 0x44, 0x01, 0x64, 0x01, // DŤ (U+0044 U+0164)
  0x00, 0x44, 0x01, 0x66, 0x01, // DŦ (U+0044 U+0166)
  0x00, 0x44, 0x20, 0x1A, 0x02, // D‚ (U+0044 U+201A)
  0x00, 0x44, 0x20, 0x1E, 0x02, // D„ (U+0044 U+201E)
  0x00, 0x44, 0x20, 0x26, 0x02, // D… (U+0044 U+2026)
  0x00, 0x46, 0x00, 0x2C, 0x03, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x03, // F. (U+0046 U+002E)
  0x00, 0x46, 0x00, 0x41, 0x01, // FA (U+0046 U+0041)
  0x00, 0x46, 0x00, 0xC0, 0x01, // FÀ (U+0046 U+00C0)
  0x00, 0x46, 0x00, 0xC1, 0x01, // FÁ (U+0046 U+00C1)
  0x00, 0x46, 0x00, 0xC2, 0x01, // FÂ (U+0046 U+00C2)
  0x00, 0x46, 0x00, 0xC3, 0x01, // FÃ (U+0046 U+00C3)
  0x00, 0x46, 0x00, 0xC4, 0x01, // FÄ (U+0046 U+00C4)
  0x00, 0x46, 0x00, 0xC5, 0x01, // FÅ (U+0046 U+00C5)
  0x00, 0x46, 0x01, 0x00, 0x01, // FĀ (U+0046 U+0100)
  0x00, 0x46, 0x01, 0x02, 0x01, // FĂ (U+0046 U+0102)
  0x00, 0x46, 0x01, 0x04, 0x01, // FĄ (U+0046 U+0104)
  0x00, 0x46, 0x20, 0x1A, 0x03, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x03, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x03, // F… (U+0046 U+2026)
  0x00, 0x4B, 0x00, 0xAB, 0x01, // K« (U+004B U+00AB)
  0x00, 0x4B, 0x20, 0x39, 0x01, // K‹ (U+004B U+2039)
  0x00, 0x4C, 0x00, 0x22, 0x03, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x03, // L' (U+004C U+0027)
  0x00, 0x4C, 0x00, 0x43, 0x01, // LC (U+004C U+0043)
  0x00, 0x4C, 0x00, 0x47, 0x01, // LG (U+004C U+0047)
  0x00, 0x4C, 0x00, 0x4F, 0x01, // LO (U+004C U+004F)
  0x00, 0x4C, 0x00, 0x51, 0x01, // LQ (U+004C U+0051)
  0x00, 0x4C, 0x00, 0x54, 0x02, // LT (U+004C U+0054)
  0x00, 0x4C, 0x00, 0x56, 0x02, // LV (U+004C U+0056)
  0x00, 0x4C, 0x00, 0x57, 0x02, // LW (U+004C U+0057)
  0x00, 0x4C, 0x00, 0x59, 0x02, // LY (U+004C U+0059)
  0x00, 0x4C, 0x00, 0xC7, 0x01, // LÇ (U+004C U+00C7)
  0x00, 0x4C, 0x00, 0xD2, 0x01, // LÒ (U+004C U+00D2)
  0x00, 0x4C, 0x00, 0xD3, 0x01, // LÓ (U+004C U+00D3)
  0x00, 0x4C, 0x00, 0xD4, 0x01, // LÔ (U+004C U+00D4)
  0x00, 0x4C, 0x00, 0xD5, 0x01, // LÕ (U+004C U+00D5)
  0x00, 0x4C, 0x00, 0xD6, 0x01, // LÖ (U+004C U+00D6)
  0x00, 0x4C, 0x00, 0xD8, 0x01, // LØ (U+004C U+00D8)
  0x00, 0x4C, 0x00, 0xDD, 0x02, // LÝ (U+004C U+00DD)
  0x00, 0x4C, 0x01, 0x06, 0x01, // LĆ (U+004C U+0106)
  0x00, 0x4C, 0x01, 0x08, 0x01, // LĈ (U+004C U+0108)
  0x00, 0x4C, 0x01, 0x0A, 0x01, // LĊ (U+004C U+010A)
  0x00, 0x4C, 0x01, 0x0C, 0x01, // LČ (U+004C U+010C)
  0x00, 0x4C, 0x01, 0x1C, 0x01, // LĜ (U+004C U+011C)
  0x00, 0x4C, 0x01, 0x1E, 0x01, // LĞ (U+004C U+011E)
  0x00, 0x4C, 0x01, 0x20, 0x01, // LĠ (U+004C U+0120)
  0x00, 0x4C, 0x01, 0x22, 0x01, // LĢ (U+004C U+0122)
  0x00, 0x4C, 0x01, 0x4C, 0x01, // LŌ (U+004C U+014C)
  0x00, 0x4C, 0x01, 0x4E, 0x01, // LŎ (U+004C U+014E)
  0x00, 0x4C, 0x01, 0x50, 0x01, // LŐ (U+004C U+0150)
  0x00, 0x4C, 0x01, 0x52, 0x01, // LŒ (U+004C U+0152)
  0x00, 0x4C, 0x01, 0x62, 0x02, // LŢ (U+004C U+0162)
  0x00, 0x4C, 0x01, 0x64, 0x02, // LŤ (U+004C U+0164)
  0x00, 0x4C, 0x01, 0x66, 0x02, // LŦ (U+004C U+0166)
  0x00, 0x4C, 0x01, 0x74, 0x02, // LŴ (U+004C U+0174)
  0x00, 0x4C, 0x01, 0x76, 0x02, // LŶ (U+004C U+0176)
  0x00, 0x4C, 0x01, 0x78, 0x02, // LŸ (U+004C U+0178)
  0x00, 0x4C, 0x20, 0x19, 0x03, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1D, 0x03, // L” (U+004C U+201D)
  0x00, 0x4F, 0x00, 0x2C, 0x02, // O, (U+004F U+002C)
  0x00, 0x4F, 0x00, 0x2E, 0x02, // O. (U+004F U+002E)
  0x00, 0x4F, 0x00, 0x54, 0x01, // OT (U+004F U+0054)
  0x00, 0x4F, 0x01, 0x62, 0x01, // OŢ (U+004F U+0162)
  0x00, 0x4F, 0x01, 0x64, 0x01, // OŤ (U+004F U+0164)
  0x00, 0x4F, 0x01, 0x66, 0x01, // OŦ (U+004F U+0166)
  0x00, 0x4F, 0x20, 0x1A, 0x02, // O‚ (U+004F U+201A)
  0x00, 0x4F, 0x20, 0x1E, 0x02, // O„ (U+004F U+201E)
  0x00, 0x4F, 0x20, 0x26, 0x02, // O… (U+004F U+2026)
  0x00, 0x50, 0x00, 0x2C, 0x06, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x06, // P. (U+0050 U+002E)
  0x00, 0x50, 0x00, 0x41, 0x02, // PA (U+0050 U+0041)
  0x00, 0x50, 0x00, 0x58, 0x01, // PX (U+0050 U+0058)
  0x00, 0x50, 0x00, 0xAB, 0x01, // P« (U+0050 U+00AB)
  0x00, 0x50, 0x00, 0xC0, 0x02, // PÀ (U+0050 U+00C0)
  0x00, 0x50, 0x00, 0xC1, 0x02, // PÁ (U+0050 U+00C1)
  0x00, 0x50, 0x00, 0xC2, 0x02, // PÂ (U+0050 U+00C2)
  0x00, 0x50, 0x00, 0xC3, 0x02, // PÃ (U+0050 U+00C3)
  0x00, 0x50, 0x00, 0xC4, 0x02, // PÄ (U+0050 U+00C4)
  0x00, 0x50, 0x00, 0xC5, 0x02, // PÅ (U+0050 U+00C5)
  0x00, 0x50, 0x00, 0xC6, 0x02, // PÆ (U+0050 U+00C6)
  0x00, 0x50, 0x01, 0x00, 0x02, // PĀ (U+0050 U+0100)
  0x00, 0x50, 0x01, 0x02, 0x02, // PĂ (U+0050 U+0102)
  0x00, 0x50, 0x01, 0x04, 0x02, // PĄ (U+0050 U+0104)
  0x00, 0x50, 0x20, 0x1A, 0x06, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x06, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x06, // P… (U+0050 U+2026)
  0x00, 0x50, 0x20, 0x39, 0x01, // P‹ (U+0050 U+2039)
  0x00, 0x51, 0x00, 0x2C, 0x02, // Q, (U+0051 U+002C)
  0x00, 0x51, 0x00, 0x2E, 0x02, // Q. (U+0051 U+002E)
  0x00, 0x51, 0x00, 0x54, 0x01, // QT (U+0051 U+0054)
  0x00, 0x51, 0x01, 0x62, 0x01, // QŢ (U+0051 U+0162)
  0x00, 0x51, 0x01, 0x64, 0x01, // QŤ (U+0051 U+0164)
  0x00, 0x51, 0x01, 0x66, 0x01, // QŦ (U+0051 U+0166)
  0x00, 0x51, 0x20, 0x1A, 0x02, // Q‚ (U+0051 U+201A)
  0x00, 0x51, 0x20, 0x1E, 0x02, // Q„ (U+0051 U+201E)
  0x00, 0x51, 0x20, 0x26, 0x02, // Q… (U+0051 U+2026)
  0x00, 0x54, 0x00, 0x26, 0x01, // T& (U+0054 U+0026)
  0x00, 0x54, 0x00, 0x2C, 0x03, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2D, 0x02, // T- (U+0054 U+002D)
  0x00, 0x54, 0x00, 0x2E, 0x03, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0x41, 0x02, // TA (U+0054 U+0041)
  0x00, 0x54, 0x00, 0x43, 0x01, // TC (U+0054 U+0043)
  0x00, 0x54, 0x00, 0x47, 0x01, // TG (U+0054 U+0047)
  0x00, 0x54, 0x00, 0x4F, 0x01, // TO (U+0054 U+004F)
  0x00, 0x54, 0x00, 0x51, 0x01, // TQ (U+0054 U+0051)
  0x00, 0x54, 0x00, 0x61, 0x03, // Ta (U+0054 U+0061)
  0x00, 0x54, 0x00, 0x63, 0x03, // Tc (U+0054 U+0063)
  0x00, 0x54, 0x00, 0x64, 0x03, // Td (U+0054 U+0064)
  0x00, 0x54, 0x00, 0x65, 0x03, // Te (U+0054 U+0065)
  0x00, 0x54, 0x00, 0x67, 0x03, // Tg (U+0054 U+0067)
  0x00, 0x54, 0x00, 0x6D, 0x02, // Tm (U+0054 U+006D)
  0x00, 0x54, 0x00, 0x6E, 0x02, // Tn (U+0054 U+006E)
  0x00, 0x54, 0x00, 0x6F, 0x03, // To (U+0054 U+006F)
  0x00, 0x54, 0x00, 0x70, 0x02, // Tp (U+0054 U+0070)
  0x00, 0x54, 0x00, 0x71, 0x03, // Tq (U+0054 U+0071)
  0x00, 0x54, 0x00, 0x72, 0x02, // Tr (U+0054 U+0072)
  0x00, 0x54, 0x00, 0x73, 0x03, // Ts (U+0054 U+0073)
  0x00, 0x54, 0x00, 0x75, 0x02, // Tu (U+0054 U+0075)
  0x00, 0x54, 0x00, 0x76, 0x01, // Tv (U+0054 U+0076)
  0x00, 0x54, 0x00, 0x77, 0x01, // Tw (U+0054 U+0077)
  0x00, 0x54, 0x00, 0x78, 0x01, // Tx (U+0054 U+0078)
  0x00, 0x54, 0x00, 0x79, 0x01, // Ty (U+0054 U+0079)
  0x00, 0x54, 0x00, 0x7A, 0x02, // Tz (U+0054 U+007A)
  0x00, 0x54, 0x00, 0xAB, 0x03, // T« (U+0054 U+00AB)
  0x00, 0x54, 0x00, 0xBB, 0x01, // T» (U+0054 U+00BB)
  0x00, 0x54, 0x00, 0xC0, 0x02, // TÀ (U+0054 U+00C0)
  0x00, 0x54, 0x00, 0xC1, 0x02, // TÁ (U+0054 U+00C1)
  0x00, 0x54, 0x00, 0xC2, 0x02, // TÂ (U+0054 U+00C2)
  0x00, 0x54, 0x00, 0xC3, 0x02, // TÃ (U+0054 U+00C3)
  0x00, 0x54, 0x00, 0xC4, 0x02, // TÄ (U+0054 U+00C4)
  0x00, 0x54, 0x00, 0xC5, 0x02, // TÅ (U+0054 U+00C5)
  0x00, 0x54, 0x00, 0xC7, 0x01, // TÇ (U+0054 U+00C7)
  0x00, 0x54, 0x00, 0xD2, 0x01, // TÒ (U+0054 U+00D2)
  0x00, 0x54, 0x00, 0xD3, 0x01, // TÓ (U+0054 U+00D3)
  0x00, 0x54, 0x00, 0xD4, 0x01, // TÔ (U+0054 U+00D4)
  0x00, 0x54, 0x00, 0xD5, 0x01, // TÕ (U+0054 U+00D5)
  0x00, 0x54, 0x00, 0xD6, 0x01, // TÖ (U+0054 U+00D6)
  0x00, 0x54, 0x00, 0xD8, 0x01, // TØ (U+0054 U+00D8)
  0x00, 0x54, 0x00, 0xE0, 0x03, // Tà (U+0054 U+00E0)
  0x00, 0x54, 0x00, 0xE1, 0x03, // Tá (U+0054 U+00E1)
  0x00, 0x54, 0x00, 0xE2, 0x03, // Tâ (U+0054 U+00E2)
  0x00, 0x54, 0x00, 0xE3, 0x03, // Tã (U+0054 U+00E3)
  0x00, 0x54, 0x00, 0xE4, 0x03, // Tä (U+0054 U+00E4)
  0x00, 0x54, 0x00, 0xE5, 0x03, // Tå (U+0054 U+00E5)
  0x00, 0x54, 0x00, 0xE6, 0x03, // Tæ (U+0054 U+00E6)
  0x00, 0x54, 0x00, 0xE7, 0x03, // Tç (U+0054 U+00E7)
  0x00, 0x54, 0x00, 0xE8, 0x03, // Tè (U+0054 U+00E8)
  0x00, 0x54, 0x00, 0xE9, 0x03, // Té (U+0054 U+00E9)
  0x00, 0x54, 0x00, 0xEA, 0x03, // Tê (U+0054 U+00EA)
  0x00, 0x54, 0x00, 0xEB, 0x03, // Të (U+0054 U+00EB)
  0x00, 0x54, 0x00, 0xF2, 0x03, // Tò (U+0054 U+00F2)
  0x00, 0x54, 0x00, 0xF3, 0x03, // Tó (U+0054 U+00F3)
  0x00, 0x54, 0x00, 0xF4, 0x03, // Tô (U+0054 U+00F4)
  0x00, 0x54, 0x00, 0xF5, 0x03, // Tõ (U+0054 U+00F5)
  0x00, 0x54, 0x00, 0xF6, 0x03, // Tö (U+0054 U+00F6)
  0x00, 0x54, 0x00, 0xF8, 0x03, // Tø (U+0054 U+00F8)
  0x00, 0x54, 0x00, 0xF9, 0x02, // Tù (U+0054 U+00F9)
  0x00, 0x54, 0x00, 0xFA, 0x02, // Tú (U+0054 U+00FA)
  0x00, 0x54, 0x00, 0xFB, 0x02, // Tû (U+0054 U+00FB)
  0x00, 0x54, 0x00, 0xFC, 0x02, // Tü (U+0054 U+00FC)
  0x00, 0x54, 0x00, 0xFD, 0x01, // Tý (U+0054 U+00FD)
  0x00, 0x54, 0x00, 0xFF, 0x01, // Tÿ (U+0054 U+00FF)
  0x00, 0x54, 0x01, 0x00, 0x02, // TĀ (U+0054 U+0100)
  0x00, 0x54, 0x01, 0x01, 0x03, // Tā (U+0054 U+0101)
  0x00, 0x54, 0x01, 0x02, 0x02, // TĂ (U+0054 U+0102)
  0x00, 0x54, 0x01, 0x03, 0x03, // Tă (U+0054 U+0103)
  0x00, 0x54, 0x01, 0x04, 0x02, // TĄ (U+0054 U+0104)
  0x00, 0x54, 0x01, 0x05, 0x03, // Tą (U+0054 U+0105)
  0x00, 0x54, 0x01, 0x06, 0x01, // TĆ (U+0054 U+0106)
  0x00, 0x54, 0x01, 0x07, 0x03, // Tć (U+0054 U+0107)
  0x00, 0x54, 0x01, 0x08, 0x01, // TĈ (U+0054 U+0108)
  0x00, 0x54, 0x01, 0x09, 0x03, // Tĉ (U+0054 U+0109)
  0x00, 0x54, 0x01, 0x0A, 0x01, // TĊ (U+0054 U+010A)
  0x00, 0x54, 0x01, 0x0B, 0x03, // Tċ (U+0054 U+010B)
  0x00, 0x54, 0x01, 0x0C, 0x01, // TČ (U+0054 U+010C)
  0x00, 0x54, 0x01, 0x0D, 0x03, // Tč (U+0054 U+010D)
  0x00, 0x54, 0x01, 0x0F, 0x03, // Tď (U+0054 U+010F)
  0x00, 0x54, 0x01, 0x11, 0x03, // Tđ (U+0054 U+0111)
  0x00, 0x54, 0x01, 0x13, 0x03, // Tē (U+0054 U+0113)
  0x00, 0x54, 0x01, 0x15, 0x03, // Tĕ (U+0054 U+0115)
  0x00, 0x54, 0x01, 0x17, 0x03, // Tė (U+0054 U+0117)
  0x00, 0x54, 0x01, 0x19, 0x03, // Tę (U+0054 U+0119)
  0x00, 0x54, 0x01, 0x1B, 0x03, // Tě (U+0054 U+011B)
  0x00, 0x54, 0x01, 0x1C, 0x01, // TĜ (U+0054 U+011C)
  0x00, 0x54, 0x01, 0x1D, 0x03, // Tĝ (U+0054 U+011D)
  0x00, 0x54, 0x01, 0x1E, 0x01, // TĞ (U+0054 U+011E)
  0x00, 0x54, 0x01, 0x1F, 0x03, // Tğ (U+0054 U+011F)
  0x00, 0x54, 0x01, 0x20, 0x01, // TĠ (U+0054 U+0120)
  0x00, 0x54, 0x01, 0x21, 0x03, // Tġ (U+0054 U+0121)
  0x00, 0x54, 0x01, 0x22, 0x01, // TĢ (U+0054 U+0122)
  0x00, 0x54, 0x01, 0x23, 0x03, // Tģ (U+0054 U+0123)
  0x00, 0x54, 0x01, 0x38, 0x02, // Tĸ (U+0054 U+0138)
  0x00, 0x54, 0x01, 0x44, 0x02, // Tń (U+0054 U+0144)
  0x00, 0x54, 0x01, 0x46, 0x02, // Tņ (U+0054 U+0146)
  0x00, 0x54, 0x01, 0x4B, 0x02, // Tŋ (U+0054 U+014B)
  0x00, 0x54, 0x01, 0x4C, 0x01, // TŌ (U+0054 U+014C)
  0x00, 0x54, 0x01, 0x4D, 0x03, // Tō (U+0054 U+014D)
  0x00, 0x54, 0x01, 0x4E, 0x01, // TŎ (U+0054 U+014E)
  0x00, 0x54, 0x01, 0x4F, 0x03, // Tŏ (U+0054 U+014F)
  0x00, 0x54, 0x01, 0x50, 0x01, // TŐ (U+0054 U+0150)
  0x00, 0x54, 0x01, 0x51, 0x03, // Tő (U+0054 U+0151)
  0x00, 0x54, 0x01, 0x52, 0x01, // TŒ (U+0054 U+0152)
  0x00, 0x54, 0x01, 0x53, 0x03, // Tœ (U+0054 U+0153)
  0x00, 0x54, 0x01, 0x55, 0x02, // Tŕ (U+0054 U+0155)
  0x00, 0x54, 0x01, 0x57, 0x02, // Tŗ (U+0054 U+0157)
  0x00, 0x54, 0x01, 0x5B, 0x03, // Tś (U+0054 U+015B)
  0x00, 0x54, 0x01, 0x5F, 0x03, // Tş (U+0054 U+015F)
  0x00, 0x54, 0x01, 0x69, 0x02, // Tũ (U+0054 U+0169)
  0x00, 0x54, 0x01, 0x6B, 0x02, // Tū (U+0054 U+016B)
  0x00, 0x54, 0x01, 0x6D, 0x02, // Tŭ (U+0054 U+016D)
  0x00, 0x54, 0x01, 0x6F, 0x02, // Tů (U+0054 U+016F)
  0x00, 0x54, 0x01, 0x71, 0x02, // Tű (U+0054 U+0171)
  0x00, 0x54, 0x01, 0x73, 0x02, // Tų (U+0054 U+0173)
  0x00, 0x54, 0x01, 0x75, 0x01, // Tŵ (U+0054 U+0175)
  0x00, 0x54, 0x01, 0x77, 0x01, // Tŷ (U+0054 U+0177)
  0x00, 0x54, 0x01, 0x7A, 0x02, // Tź (U+0054 U+017A)
  0x00, 0x54, 0x01, 0x7C, 0x02, // Tż (U+0054 U+017C)
  0x00, 0x54, 0x01, 0x7E, 0x02, // Tž (U+0054 U+017E)
  0x00, 0x54, 0x20, 0x13, 0x02, // T– (U+0054 U+2013)
  0x00, 0x54, 0x20, 0x14, 0x02, // T— (U+0054 U+2014)
  0x00, 0x54, 0x20, 0x1A, 0x03, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x03, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x03, // T… (U+0054 U+2026)
  0x00, 0x54, 0x20, 0x39, 0x03, // T‹ (U+0054 U+2039)
  0x00, 0x54, 0x20, 0x3A, 0x01, // T› (U+0054 U+203A)
  0x00, 0x55, 0x00, 0x2C, 0x01, // U, (U+0055 U+002C)
  0x00, 0x55, 0x00, 0x2E, 0x01, // U. (U+0055 U+002E)
  0x00, 0x55, 0x20, 0x1A, 0x01, // U‚ (U+0055 U+201A)
  0x00, 0x55, 0x20, 0x1E, 0x01, // U„ (U+0055 U+201E)
  0x00, 0x55, 0x20, 0x26, 0x01, // U… (U+0055 U+2026)
  0x00, 0x56, 0x00, 0x2C, 0x02, // V, (U+0056 U+002C)
  0x00, 0x56, 0x00, 0x2E, 0x02, // V. (U+0056 U+002E)
  0x00, 0x56, 0x00, 0x41, 0x01, // VA (U+0056 U+0041)
  0x00, 0x56, 0x00, 0x61, 0x01, // Va (U+0056 U+0061)
  0x00, 0x56, 0x00, 0x63, 0x01, // Vc (U+0056 U+0063)
  0x00, 0x56, 0x00, 0x64, 0x01, // Vd (U+0056 U+0064)
  0x00, 0x56, 0x00, 0x65, 0x01, // Ve (U+0056 U+0065)
  0x00, 0x56, 0x00, 0x6F, 0x01, // Vo (U+0056 U+006F)
  0x00, 0x56, 0x00, 0x71, 0x01, // Vq (U+0056 U+0071)
  0x00, 0x56, 0x00, 0xAB, 0x01, // V« (U+0056 U+00AB)
  0x00, 0x56, 0x00, 0xC0, 0x01, // VÀ (U+0056 U+00C0)
  0x00, 0x56, 0x00, 0xC1, 0x01, // VÁ (U+0056 U+00C1)
  0x00, 0x56, 0x00, 0xC2, 0x01, // VÂ (U+0056 U+00C2)
  0x00, 0x56, 0x00, 0xC3, 0x01, // VÃ (U+0056 U+00C3)
  0x00, 0x56, 0x00, 0xC4, 0x01, // VÄ (U+0056 U+00C4)
  0x00, 0x56, 0x00, 0xC5, 0x01, // VÅ (U+0056 U+00C5)
  0x00, 0x56, 0x00, 0xE0, 0x01, // Và (U+0056 U+00E0)
  0x00, 0x56, 0x00, 0xE1, 0x01, // Vá (U+0056 U+00E1)
  0x00, 0x56, 0x00, 0xE2, 0x01, // Vâ (U+0056 U+00E2)
  0x00, 0x56, 0x00, 0xE3, 0x01, // Vã (U+0056 U+00E3)
  0x00, 0x56, 0x00, 0xE4, 0x01, // Vä (U+0056 U+00E4)
  0x00, 0x56, 0x00, 0xE5, 0x01, // Vå (U+0056 U+00E5)
  0x00, 0x56, 0x00, 0xE6, 0x01, // Væ (U+0056 U+00E6)
  0x00, 0x56, 0x00, 0xE7, 0x01, // Vç (U+0056 U+00E7)
  0x00, 0x56, 0x00, 0xE8, 0x01, // Vè (U+0056 U+00E8)
  0x00, 0x56, 0x00, 0xE9, 0x01, // Vé (U+0056 U+00E9)
  0x00, 0x56, 0x00, 0xEA, 0x01, // Vê (U+0056 U+00EA)
  0x00, 0x56, 0x00, 0xEB, 0x01, // Vë (U+0056 U+00EB)
  0x00, 0x56, 0x00, 0xF2, 0x01, // Vò (U+0056 U+00F2)
  0x00, 0x56, 0x00, 0xF3, 0x01, // Vó (U+0056 U+00F3)
  0x00, 0x56, 0x00, 0xF4, 0x01, // Vô (U+0056 U+00F4)
  0x00, 0x56, 0x00, 0xF5, 0x01, // Võ (U+0056 U+00F5)
  0x00, 0x56, 0x00, 0xF6, 0x01, // Vö (U+0056 U+00F6)
  0x00, 0x56, 0x00, 0xF8, 0x01, // Vø (U+0056 U+00F8)
  0x00, 0x56, 0x01, 0x00, 0x01, // VĀ (U+0056 U+0100)
  0x00, 0x56, 0x01, 0x01, 0x01, // Vā (U+0056 U+0101)
  0x00, 0x56, 0x01, 0x02, 0x01, // VĂ (U+0056 U+0102)
  0x00, 0x56, 0x01, 0x03, 0x01, // Vă (U+0056 U+0103)
  0x00, 0x56, 0x01, 0x04, 0x01, // VĄ (U+0056 U+0104)
  0x00, 0x56, 0x01, 0x05, 0x01, // Vą (U+0056 U+0105)
  0x00, 0x56, 0x01, 0x07, 0x01, // Vć (U+0056 U+0107)
  0x00, 0x56, 0x01, 0x09, 0x01, // Vĉ (U+0056 U+0109)
  0x00, 0x56, 0x01, 0x0B, 0x01, // Vċ (U+0056 U+010B)
  0x00, 0x56, 0x01, 0x0D, 0x01, // Vč (U+0056 U+010D)
  0x00, 0x56, 0x01, 0x0F, 0x01, // Vď (U+0056 U+010F)
  0x00, 0x56, 0x01, 0x11, 0x01, // Vđ (U+0056 U+0111)
  0x00, 0x56, 0x01, 0x13, 0x01, // Vē (U+0056 U+0113)
  0x00, 0x56, 0x01, 0x15, 0x01, // Vĕ (U+0056 U+0115)
  0x00, 0x56, 0x01, 0x17, 0x01, // Vė (U+0056 U+0117)
  0x00, 0x56, 0x01, 0x19, 0x01, // Vę (U+0056 U+0119)
  0x00, 0x56, 0x01, 0x1B, 0x01, // Vě (U+0056 U+011B)
  0x00, 0x56, 0x01, 0x4D, 0x01, // Vō (U+0056 U+014D)
  0x00, 0x56, 0x01, 0x4F, 0x01, // Vŏ (U+0056 U+014F)
  0x00, 0x56, 0x01, 0x51, 0x01, // Vő (U+0056 U+0151)
  0x00, 0x56, 0x01, 0x53, 0x01, // Vœ (U+0056 U+0153)
  0x00, 0x56, 0x20, 0x1A, 0x02, // V‚ (U+0056 U+201A)
  0x00, 0x56, 0x20, 0x1E, 0x02, // V„ (U+0056 U+201E)
  0x00, 0x56, 0x20, 0x26, 0x02, // V… (U+0056 U+2026)
  0x00, 0x56, 0x20, 0x39, 0x01, // V‹ (U+0056 U+2039)
  0x00, 0x57, 0x00, 0x2C, 0x02, // W, (U+0057 U+002C)
  0x00, 0x57, 0x00, 0x2E, 0x02, // W. (U+0057 U+002E)
  0x00, 0x57, 0x00, 0x41, 0x01, // WA (U+0057 U+0041)
  0x00, 0x57, 0x00, 0x61, 0x01, // Wa (U+0057 U+0061)
  0x00, 0x57, 0x00, 0x63, 0x01, // Wc (U+0057 U+0063)
  0x00, 0x57, 0x00, 0x64, 0x01, // Wd (U+0057 U+0064)
  0x00, 0x57, 0x00, 0x65, 0x01, // We (U+0057 U+0065)
  0x00, 0x57, 0x00, 0x6F, 0x01, // Wo (U+0057 U+006F)
  0x00, 0x57, 0x00, 0x71, 0x01, // Wq (U+0057 U+0071)
  0x00, 0x57, 0x00, 0xAB, 0x01, // W« (U+0057 U+00AB)
  0x00, 0x57, 0x00, 0xC0, 0x01, // WÀ (U+0057 U+00C0)
  0x00, 0x57, 0x00, 0xC1, 0x01, // WÁ (U+0057 U+00C1)
  0x00, 0x57, 0x00, 0xC2, 0x01, // WÂ (U+0057 U+00C2)
  0x00, 0x57, 0x00, 0xC3, 0x01, // WÃ (U+0057 U+00C3)
  0x00, 0x57, 0x00, 0xC4, 0x01, // WÄ (U+0057 U+00C4)
  0x00, 0x57, 0x00, 0xC5, 0x01, // WÅ (U+0057 U+00C5)
  0x00, 0x57, 0x00, 0xE0, 0x01, // Wà (U+0057 U+00E0)
  0x00, 0x57, 0x00, 0xE1, 0x01, // Wá (U+0057 U+00E1)
  0x00, 0x57, 0x00, 0xE2, 0x01, // Wâ (U+0057 U+00E2)
  0x00, 0x57, 0x00, 0xE3, 0x01, // Wã (U+0057 U+00E3)
  0x00, 0x57, 0x00, 0xE4, 0x01, // Wä (U+0057 U+00E4)
  0x00, 0x57, 0x00, 0xE5, 0x01, // Wå (U+0057 U+00E5)
  0x00, 0x57, 0x00, 0xE6, 0x01, // Wæ (U+0057 U+00E6)
  0x00, 0x57, 0x00, 0xE7, 0x01, // Wç (U+0057 U+00E7)
  0x00, 0x57, 0x00, 0xE8, 0x01, // Wè (U+0057 U+00E8)
  0x00, 0x57, 0x00, 0xE9, 0x01, // Wé (U+0057 U+00E9)
  0x00, 0x57, 0x00, 0xEA, 0x01, // Wê (U+0057 U+00EA)
  0x00, 0x57, 0x00, 0xEB, 0x01, // Wë (U+0057 U+00EB)
  0x00, 0x57, 0x00, 0xF2, 0x01, // Wò (U+0057 U+00F2)
  0x00, 0x57, 0x00, 0xF3, 0x01, // Wó (U+0057 U+00F3)
  0x00, 0x57, 0x00, 0xF4, 0x01, // Wô (U+0057 U+00F4)
  0x00, 0x57, 0x00, 0xF5, 0x01, // Wõ (U+0057 U+00F5)
  0x00, 0x57, 0x00, 0xF6, 0x01, // Wö (U+0057 U+00F6)
  0x00, 0x57, 0x00, 0xF8, 0x01, // Wø (U+0057 U+00F8)
  0x00, 0x57, 0x01, 0x00, 0x01, // WĀ (U+0057 U+0100)
  0x00, 0x57, 0x01, 0x01, 0x01, // Wā (U+0057 U+0101)
  0x00, 0x57, 0x01, 0x02, 0x01, // WĂ (U+0057 U+0102)
  0x00, 0x57, 0x01, 0x03, 0x01, // Wă (U+0057 U+0103)
  0x00, 0x57, 0x01, 0x04, 0x01, // WĄ (U+0057 U+0104)
  0x00, 0x57, 0x01, 0x05, 0x01, // Wą (U+0057 U+0105)
  0x00, 0x57, 0x01, 0x07, 0x01, // Wć (U+0057 U+0107)
  0x00, 0x57, 0x01, 0x09, 0x01, // Wĉ (U+0057 U+0109)
  0x00, 0x57, 0x01, 0x0B, 0x01, // Wċ (U+0057 U+010B)
  0x00, 0x57, 0x01, 0x0D, 0x01, // Wč (U+0057 U+010D)
  0x00, 0x57, 0x01, 0x0F, 0x01, // Wď (U+0057 U+010F)
  0x00, 0x57, 0x01, 0x11, 0x01, // Wđ (U+0057 U+0111)
  0x00, 0x57, 0x01, 0x13, 0x01, // Wē (U+0057 U+0113)
  0x00, 0x57, 0x01, 0x15, 0x01, // Wĕ (U+0057 U+0115)
  0x00, 0x57, 0x01, 0x17, 0x01, // Wė (U+0057 U+0117)
  0x00, 0x57, 0x01, 0x19, 0x01, // Wę (U+0057 U+0119)
  0x00, 0x57, 0x01, 0x1B, 0x01, // Wě (U+0057 U+011B)
  0x00, 0x57, 0x01, 0x4D, 0x01, // Wō (U+0057 U+014D)
  0x00, 0x57, 0x01, 0x4F, 0x01, // Wŏ (U+0057 U+014F)
  0x00, 0x57, 0x01, 0x51, 0x01, // Wő (U+0057 U+0151)
  0x00, 0x57, 0x01, 0x53, 0x01, // Wœ (U+0057 U+0153)
  0x00, 0x57, 0x20, 0x1A, 0x02, // W‚ (U+0057 U+201A)
  0x00, 0x57, 0x20, 0x1E, 0x02, // W„ (U+0057 U+201E)
  0x00, 0x57, 0x20, 0x26, 0x02, // W… (U+0057 U+2026)
  0x00, 0x57, 0x20, 0x39, 0x01, // W‹ (U+0057 U+2039)
  0x00, 0x58, 0x00, 0xAB, 0x01, // X« (U+0058 U+00AB)
  0x00, 0x58, 0x20, 0x39, 0x01, // X‹ (U+0058 U+2039)
  0x00, 0x59, 0x00, 0x26, 0x01, // Y& (U+0059 U+0026)
  0x00, 0x59, 0x00, 0x2C, 0x03, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x03, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x00, 0x41, 0x02, // YA (U+0059 U+0041)
  0x00, 0x59, 0x00, 0x43, 0x01, // YC (U+0059 U+0043)
  0x00, 0x59, 0x00, 0x47, 0x01, // YG (U+0059 U+0047)
  0x00, 0x59, 0x00, 0x4F, 0x01, // YO (U+0059 U+004F)
  0x00, 0x59, 0x00, 0x51, 0x01, // YQ (U+0059 U+0051)
  0x00, 0x59, 0x00, 0x61, 0x02, // Ya (U+0059 U+0061)
  0x00, 0x59, 0x00, 0x63, 0x02, // Yc (U+0059 U+0063)
  0x00, 0x59, 0x00, 0x64, 0x02, // Yd (U+0059 U+0064)
  0x00, 0x59, 0x00, 0x65, 0x02, // Ye (U+0059 U+0065)
  0x00, 0x59, 0x00, 0x67, 0x02, // Yg (U+0059 U+0067)
  0x00, 0x59, 0x00, 0x6D, 0x01, // Ym (U+0059 U+006D)
  0x00, 0x59, 0x00, 0x6E, 0x01, // Yn (U+0059 U+006E)
  0x00, 0x59, 0x00, 0x6F, 0x02, // Yo (U+0059 U+006F)
  0x00, 0x59, 0x00, 0x70, 0x01, // Yp (U+0059 U+0070)
  0x00, 0x59, 0x00, 0x71, 0x02, // Yq (U+0059 U+0071)
  0x00, 0x59, 0x00, 0x72, 0x01, // Yr (U+0059 U+0072)
  0x00, 0x59, 0x00, 0x73, 0x02, // Ys (U+0059 U+0073)
  0x00, 0x59, 0x00, 0x75, 0x01, // Yu (U+0059 U+0075)
  0x00, 0x59, 0x00, 0x7A, 0x01, // Yz (U+0059 U+007A)
  0x00, 0x59, 0x00, 0xAB, 0x03, // Y« (U+0059 U+00AB)
  0x00, 0x59, 0x00, 0xBB, 0x01, // Y» (U+0059 U+00BB)
  0x00, 0x59, 0x00, 0xC0, 0x02, // YÀ (U+0059 U+00C0)
  0x00, 0x59, 0x00, 0xC1, 0x02, // YÁ (U+0059 U+00C1)
  0x00, 0x59, 0x00, 0xC2, 0x02, // YÂ (U+0059 U+00C2)
  0x00, 0x59, 0x00, 0xC3, 0x02, // YÃ (U+0059 U+00C3)
  0x00, 0x59, 0x00, 0xC4, 0x02, // YÄ (U+0059 U+00C4)
  0x00, 0x59, 0x00, 0xC5, 0x02, // YÅ (U+0059 U+00C5)
  0x00, 0x59, 0x00, 0xC7, 0x01, // YÇ (U+0059 U+00C7)
  0x00, 0x59, 0x00, 0xD2, 0x01, // YÒ (U+0059 U+00D2)
  0x00, 0x59, 0x00, 0xD3, 0x01, // YÓ (U+0059 U+00D3)
  0x00, 0x59, 0x00, 0xD4, 0x01, // YÔ (U+0059 U+00D4)
  0x00, 0x59, 0x00, 0xD5, 0x01, // YÕ (U+0059 U+00D5)
  0x00, 0x59, 0x00, 0xD6, 0x01, // YÖ (U+0059 U+00D6)
  0x00, 0x59, 0x00, 0xD8, 0x01, // YØ (U+0059 U+00D8)
  0x00, 0x59, 0x00, 0xE0, 0x02, // Yà (U+0059 U+00E0)
  0x00, 0x59, 0x00, 0xE1, 0x02, // Yá (U+0059 U+00E1)
  0x00, 0x59, 0x00, 0xE2, 0x02, // Yâ (U+0059 U+00E2)
  0x00, 0x59, 0x00, 0xE3, 0x02, // Yã (U+0059 U+00E3)
  0x00, 0x59, 0x00, 0xE4, 0x02, // Yä (U+0059 U+00E4)
  0x00, 0x59, 0x00, 0xE5, 0x02, // Yå (U+0059 U+00E5)
  0x00, 0x59, 0x00, 0xE6, 0x02, // Yæ (U+0059 U+00E6)
  0x00, 0x59, 0x00, 0xE7, 0x02, // Yç (U+0059 U+00E7)
  0x00, 0x59, 0x00, 0xE8, 0x02, // Yè (U+0059 U+00E8)
  0x00, 0x59, 0x00, 0xE9, 0x02, // Yé (U+0059 U+00E9)
  0x00, 0x59, 0x00, 0xEA, 0x02, // Yê (U+0059 U+00EA)
  0x00, 0x59, 0x00, 0xEB, 0x02, // Yë (U+0059 U+00EB)
  0x00, 0x59, 0x00, 0xF2, 0x02, // Yò (U+0059 U+00F2)
  0x00, 0x59, 0x00, 0xF3, 0x02, // Yó (U+0059 U+00F3)
  0x00, 0x59, 0x00, 0xF4, 0x02, // Yô (U+0059 U+00F4)
  0x00, 0x59, 0x00, 0xF5, 0x02, // Yõ (U+0059 U+00F5)
  0x00, 0x59, 0x00, 0xF6, 0x02, // Yö (U+0059 U+00F6)
  0x00, 0x59, 0x00, 0xF8, 0x02, // Yø (U+0059 U+00F8)
  0x00, 0x59, 0x00, 0xF9, 0x01, // Yù (U+0059 U+00F9)
  0x00, 0x59, 0x00, 0xFA, 0x01, // Yú (U+0059 U+00FA)
  0x00, 0x59, 0x00, 0xFB, 0x01, // Yû (U+0059 U+00FB)
  0x00, 0x59, 0x00, 0xFC, 0x01, // Yü (U+0059 U+00FC)
  0x00, 0x59, 0x01, 0x00, 0x02, // YĀ (U+0059 U+0100)
  0x00, 0x59, 0x01, 0x01, 0x02, // Yā (U+0059 U+0101)
  0x00, 0x59, 0x01, 0x02, 0x02, // YĂ (U+0059 U+0102)
  0x00, 0x59, 0x01, 0x03, 0x02, // Yă (U+0059 U+0103)
  0x00, 0x59, 0x01, 0x04, 0x02, // YĄ (U+0059 U+0104)
  0x00, 0x59, 0x01, 0x05, 0x02, // Yą (U+0059 U+0105)
  0x00, 0x59, 0x01, 0x06, 0x01, // YĆ (U+0059 U+0106)
  0x00, 0x59, 0x01, 0x07, 0x02, // Yć (U+0059 U+0107)
  0x00, 0x59, 0x01, 0x08, 0x01, // YĈ (U+0059 U+0108)
  0x00, 0x59, 0x01, 0x09, 0x02, // Yĉ (U+0059 U+0109)
  0x00, 0x59, 0x01, 0x0A, 0x01, // YĊ (U+0059 U+010A)
  0x00, 0x59, 0x01, 0x0B, 0x02, // Yċ (U+0059 U+010B)
  0x00, 0x59, 0x01, 0x0C, 0x01, // YČ (U+0059 U+010C)
  0x00, 0x59, 0x01, 0x0D, 0x02, // Yč (U+0059 U+010D)
  0x00, 0x59, 0x01, 0x0F, 0x02, // Yď (U+0059 U+010F)
  0x00, 0x59, 0x01, 0x11, 0x02, // Yđ (U+0059 U+0111)
  0x00, 0x59, 0x01, 0x13, 0x02, // Yē (U+0059 U+0113)
  0x00, 0x59, 0x01, 0x15, 0x02, // Yĕ (U+0059 U+0115)
  0x00, 0x59, 0x01, 0x17, 0x02, // Yė (U+0059 U+0117)
  0x00, 0x59, 0x01, 0x19, 0x02, // Yę (U+0059 U+0119)
  0x00, 0x59, 0x01, 0x1B, 0x02, // Yě (U+0059 U+011B)
  0x00, 0x59, 0x01, 0x1C, 0x01, // YĜ (U+0059 U+011C)
  0x00, 0x59, 0x01, 0x1D, 0x02, // Yĝ (U+0059 U+011D)
  0x00, 0x59, 0x01, 0x1E, 0x01, // YĞ (U+0059 U+011E)
  0x00, 0x59, 0x01, 0x1F, 0x02, // Yğ (U+0059 U+011F)
  0x00, 0x59, 0x01, 0x20, 0x01, // YĠ (U+0059 U+0120)
  0x00, 0x59, 0x01, 0x21, 0x02, // Yġ (U+0059 U+0121)
  0x00, 0x59, 0x01, 0x22, 0x01, // YĢ (U+0059 U+0122)
  0x00, 0x59, 0x01, 0x23, 0x02, // Yģ (U+0059 U+0123)
  0x00, 0x59, 0x01, 0x38, 0x01, // Yĸ (U+0059 U+0138)
  0x00, 0x59, 0x01, 0x44, 0x01, // Yń (U+0059 U+0144)
  0x00, 0x59, 0x01, 0x46, 0x01, // Yņ (U+0059 U+0146)
  0x00, 0x59, 0x01, 0x4B, 0x01, // Yŋ (U+0059 U+014B)
  0x00, 0x59, 0x01, 0x4C, 0x01, // YŌ (U+0059 U+014C)
  0x00, 0x59, 0x01, 0x4D, 0x02, // Yō (U+0059 U+014D)
  0x00, 0x59, 0x01, 0x4E, 0x01, // YŎ (U+0059 U+014E)
  0x00, 0x59, 0x01, 0x4F, 0x02, // Yŏ (U+0059 U+014F)
  0x00, 0x59, 0x01, 0x50, 0x01, // YŐ (U+0059 U+0150)
  0x00, 0x59, 0x01, 0x51, 0x02, // Yő (U+0059 U+0151)
  0x00, 0x59, 0x01, 0x52, 0x01, // YŒ (U+0059 U+0152)
  0x00, 0x59, 0x01, 0x53, 0x02, // Yœ (U+0059 U+0153)
  0x00, 0x59, 0x01, 0x55, 0x01, // Yŕ (U+0059 U+0155)
  0x00, 0x59, 0x01, 0x57, 0x01, // Yŗ (U+0059 U+0157)
  0x00, 0x59, 0x01, 0x5B, 0x02, // Yś (U+0059 U+015B)
  0x00, 0x59, 0x01, 0x5F, 0x02, // Yş (U+0059 U+015F)
  0x00, 0x59, 0x01, 0x69, 0x01, // Yũ (U+0059 U+0169)
  0x00, 0x59, 0x01, 0x6B, 0x01, // Yū (U+0059 U+016B)
  0x00, 0x59, 0x01, 0x6D, 0x01, // Yŭ (U+0059 U+016D)
  0x00, 0x59, 0x01, 0x6F, 0x01, // Yů (U+0059 U+016F)
  0x00, 0x59, 0x01, 0x71, 0x01, // Yű (U+0059 U+0171)
  0x00, 0x59, 0x01, 0x73, 0x01, // Yų (U+0059 U+0173)
  0x00, 0x59, 0x01, 0x7A, 0x01, // Yź (U+0059 U+017A)
  0x00, 0x59, 0x01, 0x7C, 0x01, // Yż (U+0059 U+017C)
  0x00, 0x59, 0x01, 0x7E, 0x01, // Yž (U+0059 U+017E)
  0x00, 0x59, 0x20, 0x1A, 0x03, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x03, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x03, // Y… (U+0059 U+2026)
  0x00, 0x59, 0x20, 0x39, 0x03, // Y‹ (U+0059 U+2039)
  0x00, 0x59, 0x20, 0x3A, 0x01, // Y› (U+0059 U+203A)
  0x00, 0x5A, 0x00, 0xAB, 0x01, // Z« (U+005A U+00AB)
  0x00, 0x5A, 0x20, 0x39, 0x01, // Z‹ (U+005A U+2039)
  0x00, 0x62, 0x00, 0x76, 0x01, // bv (U+0062 U+0076)
  0x00, 0x62, 0x00, 0x77, 0x01, // bw (U+0062 U+0077)
  0x00, 0x62, 0x00, 0x78, 0x01, // bx (U+0062 U+0078)
  0x00, 0x62, 0x00, 0x79, 0x01, // by (U+0062 U+0079)
  0x00, 0x62, 0x00, 0xFD, 0x01, // bý (U+0062 U+00FD)
  0x00, 0x62, 0x00, 0xFF, 0x01, // bÿ (U+0062 U+00FF)
  0x00, 0x62, 0x01, 0x75, 0x01, // bŵ (U+0062 U+0175)
  0x00, 0x62, 0x01, 0x77, 0x01, // bŷ (U+0062 U+0177)
  0x00, 0x65, 0x00, 0x76, 0x01, // ev (U+0065 U+0076)
  0x00, 0x65, 0x00, 0x77, 0x01, // ew (U+0065 U+0077)
  0x00, 0x65, 0x00, 0x78, 0x01, // ex (U+0065 U+0078)
  0x00, 0x65, 0x00, 0x79, 0x01, // ey (U+0065 U+0079)
  0x00, 0x65, 0x00, 0xFD, 0x01, // eý (U+0065 U+00FD)
  0x00, 0x65, 0x00, 0xFF, 0x01, // eÿ (U+0065 U+00FF)
  0x00, 0x65, 0x01, 0x75, 0x01, // eŵ (U+0065 U+0175)
  0x00, 0x65, 0x01, 0x77, 0x01, // eŷ (U+0065 U+0177)
  0x00, 0x66, 0x00, 0x2C, 0x01, // f, (U+0066 U+002C)
  0x00, 0x66, 0x00, 0x2E, 0x01, // f. (U+0066 U+002E)
  0x00, 0x66, 0x20, 0x1A, 0x01, // f‚ (U+0066 U+201A)
  0x00, 0x66, 0x20, 0x1E, 0x01, // f„ (U+0066 U+201E)
  0x00, 0x66, 0x20, 0x26, 0x01, // f… (U+0066 U+2026)
  0x00, 0x6F, 0x00, 0x76, 0x01, // ov (U+006F U+0076)
  0x00, 0x6F, 0x00, 0x77, 0x01, // ow (U+006F U+0077)
  0x00, 0x6F, 0x00, 0x78, 0x01, // ox (U+006F U+0078)
  0x00, 0x6F, 0x00, 0x79, 0x01, // oy (U+006F U+0079)
  0x00, 0x6F, 0x00, 0xFD, 0x01, // oý (U+006F U+00FD)
  0x00, 0x6F, 0x00, 0xFF, 0x01, // oÿ (U+006F U+00FF)
  0x00, 0x6F, 0x01, 0x75, 0x01, // oŵ (U+006F U+0175)
  0x00, 0x6F, 0x01, 0x77, 0x01, // oŷ (U+006F U+0177)
  0x00, 0x70, 0x00, 0x76, 0x01, // pv (U+0070 U+0076)
  0x00, 0x70, 0x00, 0x77, 0x01, // pw (U+0070 U+0077)
  0x00, 0x70, 0x00, 0x78, 0x01, // px (U+0070 U+0078)
  0x00, 0x70, 0x00, 0x79, 0x01, // py (U+0070 U+0079)
  0x00, 0x70, 0x00, 0xFD, 0x01, // pý (U+0070 U+00FD)
  0x00, 0x70, 0x00, 0xFF, 0x01, // pÿ (U+0070 U+00FF)
  0x00, 0x70, 0x01, 0x75, 0x01, // pŵ (U+0070 U+0175)
  0x00, 0x70, 0x01, 0x77, 0x01, // pŷ (U+0070 U+0177)
  0x00, 0x72, 0x00, 0x2C, 0x03, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x03, // r. (U+0072 U+002E)
  0x00, 0x72, 0x00, 0x61, 0x01, // ra (U+0072 U+0061)
  0x00, 0x72, 0x00, 0x63, 0x01, // rc (U+0072 U+0063)
  0x00, 0x72, 0x00, 0x64, 0x01, // rd (U+0072 U+0064)
  0x00, 0x72, 0x00, 0x65, 0x01, // re (U+0072 U+0065)
  0x00, 0x72, 0x00, 0x6F, 0x01, // ro (U+0072 U+006F)
  0x00, 0x72, 0x00, 0x71, 0x01, // rq (U+0072 U+0071)
  0x00, 0x72, 0x00, 0xE0, 0x01, // rà (U+0072 U+00E0)
  0x00, 0x72, 0x00, 0xE1, 0x01, // rá (U+0072 U+00E1)
  0x00, 0x72, 0x00, 0xE2, 0x01, // râ (U+0072 U+00E2)
  0x00, 0x72, 0x00, 0xE3, 0x01, // rã (U+0072 U+00E3)
  0x00, 0x72, 0x00, 0xE4, 0x01, // rä (U+0072 U+00E4)
  0x00, 0x72, 0x00, 0xE5, 0x01, // rå (U+0072 U+00E5)
  0x00, 0x72, 0x00, 0xE6, 0x01, // ræ (U+0072 U+00E6)
  0x00, 0x72, 0x00, 0xE7, 0x01, // rç (U+0072 U+00E7)
  0x00, 0x72, 0x00, 0xE8, 0x01, // rè (U+0072 U+00E8)
  0x00, 0x72, 0x00, 0xE9, 0x01, // ré (U+0072 U+00E9)
  0x00, 0x72, 0x00, 0xEA, 0x01, // rê (U+0072 U+00EA)
  0x00, 0x72, 0x00, 0xEB, 0x01, // rë (U+0072 U+00EB)
  0x00, 0x72, 0x00, 0xF2, 0x01, // rò (U+0072 U+00F2)
  0x00, 0x72, 0x00, 0xF3, 0x01, // ró (U+0072 U+00F3)
  0x00, 0x72, 0x00, 0xF4, 0x01, // rô (U+0072 U+00F4)
  0x00, 0x72, 0x00, 0xF5, 0x01, // rõ (U+0072 U+00F5)
  0x00, 0x72, 0x00, 0xF6, 0x01, // rö (U+0072 U+00F6)
  0x00, 0x72, 0x00, 0xF8, 0x01, // rø (U+0072 U+00F8)
  0x00, 0x72, 0x01, 0x01, 0x01, // rā (U+0072 U+0101)
  0x00, 0x72, 0x01, 0x03, 0x01, // ră (U+0072 U+0103)
  0x00, 0x72, 0x01, 0x05, 0x01, // rą (U+0072 U+0105)
  0x00, 0x72, 0x01, 0x07, 0x01, // rć (U+0072 U+0107)
  0x00, 0x72, 0x01, 0x09, 0x01, // rĉ (U+0072 U+0109)
  0x00, 0x72, 0x01, 0x0B, 0x01, // rċ (U+0072 U+010B)
  0x00, 0x72, 0x01, 0x0D, 0x01, // rč (U+0072 U+010D)
  0x00, 0x72, 0x01, 0x0F, 0x01, // rď (U+0072 U+010F)
  0x00, 0x72, 0x01, 0x11, 0x01, // rđ (U+0072 U+0111)
  0x00, 0x72, 0x01, 0x13, 0x01, // rē (U+0072 U+0113)
  0x00, 0x72, 0x01, 0x15, 0x01, // rĕ (U+0072 U+0115)
  0x00, 0x72, 0x01, 0x17, 0x01, // rė (U+0072 U+0117)
  0x00, 0x72, 0x01, 0x19, 0x01, // rę (U+0072 U+0119)
  0x00, 0x72, 0x01, 0x1B, 0x01, // rě (U+0072 U+011B)
  0x00, 0x72, 0x01, 0x4D, 0x01, // rō (U+0072 U+014D)
  0x00, 0x72, 0x01, 0x4F, 0x01, // rŏ (U+0072 U+014F)
  0x00, 0x72, 0x01, 0x51, 0x01, // rő (U+0072 U+0151)
  0x00, 0x72, 0x01, 0x53, 0x01, // rœ (U+0072 U+0153)
  0x00, 0x72, 0x20, 0x1A, 0x03, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x03, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x03, // r… (U+0072 U+2026)
  0x00, 0x76, 0x00, 0x2C, 0x02, // v, (U+0076 U+002C)
  0x00, 0x76, 0x00, 0x2E, 0x02, // v. (U+0076 U+002E)
  0x00, 0x76, 0x20, 0x1A, 0x02, // v‚ (U+0076 U+201A)
  0x00, 0x76, 0x20, 0x1E, 0x02, // v„ (U+0076 U+201E)
  0x00, 0x76, 0x20, 0x26, 0x02, // v… (U+0076 U+2026)
  0x00, 0x77, 0x00, 0x2C, 0x02, // w, (U+0077 U+002C)
  0x00, 0x77, 0x00, 0x2E, 0x02, // w. (U+0077 U+002E)
  0x00, 0x77, 0x20, 0x1A, 0x02, // w‚ (U+0077 U+201A)
  0x00, 0x77, 0x20, 0x1E, 0x02, // w„ (U+0077 U+201E)
  0x00, 0x77, 0x20, 0x26, 0x02, // w… (U+0077 U+2026)
  0x00, 0x79, 0x00, 0x2C, 0x02, // y, (U+0079 U+002C)
  0x00, 0x79, 0x00, 0x2E, 0x02, // y. (U+0079 U+002E)
  0x00, 0x79, 0x20, 0x1A, 0x02, // y‚ (U+0079 U+201A)
  0x00, 0x79, 0x20, 0x1E, 0x02, // y„ (U+0079 U+201E)
  0x00, 0x79, 0x20, 0x26, 0x02, // y… (U+0079 U+2026)
  0x00, 0xA1, 0x00, 0x54, 0x01, // ¡T (U+00A1 U+0054)
  0x00, 0xA1, 0x00, 0x59, 0x01, // ¡Y (U+00A1 U+0059)
  0x00, 0xA1, 0x00, 0xDD, 0x01, // ¡Ý (U+00A1 U+00DD)
  0x00, 0xA1, 0x01, 0x62, 0x01, // ¡Ţ (U+00A1 U+0162)
  0x00, 0xA1, 0x01, 0x64, 0x01, // ¡Ť (U+00A1 U+0164)
  0x00, 0xA1, 0x01, 0x66, 0x01, // ¡Ŧ (U+00A1 U+0166)
  0x00, 0xA1, 0x01, 0x76, 0x01, // ¡Ŷ (U+00A1 U+0176)
  0x00, 0xA1, 0x01, 0x78, 0x01, // ¡Ÿ (U+00A1 U+0178)
  0x00, 0xAB, 0x00, 0x54, 0x01, // «T (U+00AB U+0054)
  0x00, 0xAB, 0x00, 0x59, 0x01, // «Y (U+00AB U+0059)
  0x00, 0xAB, 0x00, 0xDD, 0x01, // «Ý (U+00AB U+00DD)
  0x00, 0xAB, 0x01, 0x62, 0x01, // «Ţ (U+00AB U+0162)
  0x00, 0xAB, 0x01, 0x64, 0x01, // «Ť (U+00AB U+0164)
  0x00, 0xAB, 0x01, 0x66, 0x01, // «Ŧ (U+00AB U+0166)
  0x00, 0xAB, 0x01, 0x76, 0x01, // «Ŷ (U+00AB U+0176)
  0x00, 0xAB, 0x01, 0x78, 0x01, // «Ÿ (U+00AB U+0178)
  0x00, 0xBB, 0x00, 0x54, 0x03, // »T (U+00BB U+0054)
  0x00, 0xBB, 0x00, 0x56, 0x01, // »V (U+00BB U+0056)
  0x00, 0xBB, 0x00, 0x57, 0x01, // »W (U+00BB U+0057)
  0x00, 0xBB, 0x00, 0x58, 0x01, // »X (U+00BB U+0058)
  0x00, 0xBB, 0x00, 0x59, 0x03, // »Y (U+00BB U+0059)
  0x00, 0xBB, 0x00, 0xDD, 0x03, // »Ý (U+00BB U+00DD)
  0x00, 0xBB, 0x01, 0x62, 0x03, // »Ţ (U+00BB U+0162)
  0x00, 0xBB, 0x01, 0x64, 0x03, // »Ť (U+00BB U+0164)
  0x00, 0xBB, 0x01, 0x66, 0x03, // »Ŧ (U+00BB U+0166)
  0x00, 0xBB, 0x01, 0x74, 0x01, // »Ŵ (U+00BB U+0174)
  0x00, 0xBB, 0x01, 0x76, 0x03, // »Ŷ (U+00BB U+0176)
  0x00, 0xBB, 0x01, 0x78, 0x03, // »Ÿ (U+00BB U+0178)
  0x00, 0xBF, 0x00, 0x54, 0x02, // ¿T (U+00BF U+0054)
  0x00, 0xBF, 0x00, 0x56, 0x01, // ¿V (U+00BF U+0056)
  0x00, 0xBF, 0x00, 0x57, 0x01, // ¿W (U+00BF U+0057)
  0x00, 0xBF, 0x00, 0x59, 0x02, // ¿Y (U+00BF U+0059)
  0x00, 0xBF, 0x00, 0xDD, 0x02, // ¿Ý (U+00BF U+00DD)
  0x00, 0xBF, 0x01, 0x62, 0x02, // ¿Ţ (U+00BF U+0162)
  0x00, 0xBF, 0x01, 0x64, 0x02, // ¿Ť (U+00BF U+0164)
  0x00, 0xBF, 0x01, 0x66, 0x02, // ¿Ŧ (U+00BF U+0166)
  0x00, 0xBF, 0x01, 0x74, 0x01, // ¿Ŵ (U+00BF U+0174)
  0x00, 0xBF, 0x01, 0x76, 0x02, // ¿Ŷ (U+00BF U+0176)
  0x00, 0xBF, 0x01, 0x78, 0x02, // ¿Ÿ (U+00BF U+0178)
  0x00, 0xC0, 0x00, 0x22, 0x03, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x03, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x00, 0x54, 0x02, // ÀT (U+00C0 U+0054)
  0x00, 0xC0, 0x00, 0x56, 0x01, // ÀV (U+00C0 U+0056)
  0x00, 0xC0, 0x00, 0x57, 0x01, // ÀW (U+00C0 U+0057)
  0x00, 0xC0, 0x00, 0x59, 0x02, // ÀY (U+00C0 U+0059)
  0x00, 0xC0, 0x00, 0xDD, 0x02, // ÀÝ (U+00C0 U+00DD)
  0x00, 0xC0, 0x01, 0x62, 0x02, // ÀŢ (U+00C0 U+0162)
  0x00, 0xC0, 0x01, 0x64, 0x02, // ÀŤ (U+00C0 U+0164)
  0x00, 0xC0, 0x01, 0x66, 0x02, // ÀŦ (U+00C0 U+0166)
  0x00, 0xC0, 0x01, 0x74, 0x01, // ÀŴ (U+00C0 U+0174)
  0x00, 0xC0, 0x01, 0x76, 0x02, // ÀŶ (U+00C0 U+0176)
  0x00, 0xC0, 0x01, 0x78, 0x02, // ÀŸ (U+00C0 U+0178)
  0x00, 0xC0, 0x20, 0x19, 0x03, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1D, 0x03, // À” (U+00C0 U+201D)
  0x00, 0xC1, 0x00, 0x22, 0x03, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x03, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x00, 0x54, 0x02, // ÁT (U+00C1 U+0054)
  0x00, 0xC1, 0x00, 0x56, 0x01, // ÁV (U+00C1 U+0056)
  0x00, 0xC1, 0x00, 0x57, 0x01, // ÁW (U+00C1 U+0057)
  0x00, 0xC1, 0x00, 0x59, 0x02, // ÁY (U+00C1 U+0059)
  0x00, 0xC1, 0x00, 0xDD, 0x02, // ÁÝ (U+00C1 U+00DD)
  0x00, 0xC1, 0x01, 0x62, 0x02, // ÁŢ (U+00C1 U+0162)
  0x00, 0xC1, 0x01, 0x64, 0x02, // ÁŤ (U+00C1 U+0164)
  0x00, 0xC1, 0x01, 0x66, 0x02, // ÁŦ (U+00C1 U+0166)
  0x00, 0xC1, 0x01, 0x74, 0x01, // ÁŴ (U+00C1 U+0174)
  0x00, 0xC1, 0x01, 0x76, 0x02, // ÁŶ (U+00C1 U+0176)
  0x00, 0xC1, 0x01, 0x78, 0x02, // ÁŸ (U+00C1 U+0178)
  0x00, 0xC1, 0x20, 0x19, 0x03, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1D, 0x03, // Á” (U+00C1 U+201D)
  0x00, 0xC2, 0x00, 0x22, 0x03, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x03, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x00, 0x54, 0x02, // ÂT (U+00C2 U+0054)
  0x00, 0xC2, 0x00, 0x56, 0x01, // ÂV (U+00C2 U+0056)
  0x00, 0xC2, 0x00, 0x57, 0x01, // ÂW (U+00C2 U+0057)
  0x00, 0xC2, 0x00, 0x59, 0x02, // ÂY (U+00C2 U+0059)
  0x00, 0xC2, 0x00, 0xDD, 0x02, // ÂÝ (U+00C2 U+00DD)
  0x00, 0xC2, 0x01, 0x62, 0x02, // ÂŢ (U+00C2 U+0162)
  0x00, 0xC2, 0x01, 0x64, 0x02, // ÂŤ (U+00C2 U+0164)
  0x00, 0xC2, 0x01, 0x66, 0x02, // ÂŦ (U+00C2 U+0166)
  0x00, 0xC2, 0x01, 0x74, 0x01, // ÂŴ (U+00C2 U+0174)
  0x00, 0xC2, 0x01, 0x76, 0x02, // ÂŶ (U+00C2 U+0176)
  0x00, 0xC2, 0x01, 0x78, 0x02, // ÂŸ (U+00C2 U+0178)
  0x00, 0xC2, 0x20, 0x19, 0x03, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1D, 0x03, // Â” (U+00C2 U+201D)
  0x00, 0xC3, 0x00, 0x22, 0x03, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x03, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x00, 0x54, 0x02, // ÃT (U+00C3 U+0054)
  0x00, 0xC3, 0x00, 0x56, 0x01, // ÃV (U+00C3 U+0056)
  0x00, 0xC3, 0x00, 0x57, 0x01, // ÃW (U+00C3 U+0057)
  0x00, 0xC3, 0x00, 0x59, 0x02, // ÃY (U+00C3 U+0059)
  0x00, 0xC3, 0x00, 0xDD, 0x02, // ÃÝ (U+00C3 U+00DD)
  0x00, 0xC3, 0x01, 0x62, 0x02, // ÃŢ (U+00C3 U+0162)
  0x00, 0xC3, 0x01, 0x64, 0x02, // ÃŤ (U+00C3 U+0164)
  0x00, 0xC3, 0x01, 0x66, 0x02, // ÃŦ (U+00C3 U+0166)
  0x00, 0xC3, 0x01, 0x74, 0x01, // ÃŴ (U+00C3 U+0174)
  0x00, 0xC3, 0x01, 0x76, 0x02, // ÃŶ (U+00C3 U+0176)
  0x00, 0xC3, 0x01, 0x78, 0x02, // ÃŸ (U+00C3 U+0178)
  0x00, 0xC3, 0x20, 0x19, 0x03, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1D, 0x03, // Ã” (U+00C3 U+201D)
  0x00, 0xC4, 0x00, 0x22, 0x03, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x03, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x00, 0x54, 0x02, // ÄT (U+00C4 U+0054)
  0x00, 0xC4, 0x00, 0x56, 0x01, // ÄV (U+00C4 U+0056)
  0x00, 0xC4, 0x00, 0x57, 0x01, // ÄW (U+00C4 U+0057)
  0x00, 0xC4, 0x00, 0x59, 0x02, // ÄY (U+00C4 U+0059)
  0x00, 0xC4, 0x00, 0xDD, 0x02, // ÄÝ (U+00C4 U+00DD)
  0x00, 0xC4, 0x01, 0x62, 0x02, // ÄŢ (U+00C4 U+0162)
  0x00, 0xC4, 0x01, 0x64, 0x02, // ÄŤ (U+00C4 U+0164)
  0x00, 0xC4, 0x01, 0x66, 0x02, // ÄŦ (U+00C4 U+0166)
  0x00, 0xC4, 0x01, 0x74, 0x01, // ÄŴ (U+00C4 U+0174)
  0x00, 0xC4, 0x01, 0x76, 0x02, // ÄŶ (U+00C4 U+0176)
  0x00, 0xC4, 0x01, 0x78, 0x02, // ÄŸ (U+00C4 U+0178)
  0x00, 0xC4, 0x20, 0x19, 0x03, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1D, 0x03, // Ä” (U+00C4 U+201D)
  0x00, 0xC5, 0x00, 0x22, 0x03, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x03, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x00, 0x54, 0x02, // ÅT (U+00C5 U+0054)
  0x00, 0xC5, 0x00, 0x56, 0x01, // ÅV (U+00C5 U+0056)
  0x00, 0xC5, 0x00, 0x57, 0x01, // ÅW (U+00C5 U+0057)
  0x00, 0xC5, 0x00, 0x59, 0x02, // ÅY (U+00C5 U+0059)
  0x00, 0xC5, 0x00, 0xDD, 0x02, // ÅÝ (U+00C5 U+00DD)
  0x00, 0xC5, 0x01, 0x62, 0x02, // ÅŢ (U+00C5 U+0162)
  0x00, 0xC5, 0x01, 0x64, 0x02, // ÅŤ (U+00C5 U+0164)
  0x00, 0xC5, 0x01, 0x66, 0x02, // ÅŦ (U+00C5 U+0166)
  0x00, 0xC5, 0x01, 0x74, 0x01, // ÅŴ (U+00C5 U+0174)
  0x00, 0xC5, 0x01, 0x76, 0x02, // ÅŶ (U+00C5 U+0176)
  0x00, 0xC5, 0x01, 0x78, 0x02, // ÅŸ (U+00C5 U+0178)
  0x00, 0xC5, 0x20, 0x19, 0x03, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1D, 0x03, // Å” (U+00C5 U+201D)
  0x00, 0xC7, 0x00, 0x43, 0x01, // ÇC (U+00C7 U+0043)
  0x00, 0xC7, 0x00, 0x47, 0x01, // ÇG (U+00C7 U+0047)
  0x00, 0xC7, 0x00, 0x4F, 0x01, // ÇO (U+00C7 U+004F)
  0x00, 0xC7, 0x00, 0x51, 0x01, // ÇQ (U+00C7 U+0051)
  0x00, 0xC7, 0x00, 0xAB, 0x01, // Ç« (U+00C7 U+00AB)
  0x00, 0xC7, 0x00, 0xC7, 0x01, // ÇÇ (U+00C7 U+00C7)
  0x00, 0xC7, 0x00, 0xD2, 0x01, // ÇÒ (U+00C7 U+00D2)
  0x00, 0xC7, 0x00, 0xD3, 0x01, // ÇÓ (U+00C7 U+00D3)
  0x00, 0xC7, 0x00, 0xD4, 0x01, // ÇÔ (U+00C7 U+00D4)
  0x00, 0xC7, 0x00, 0xD5, 0x01, // ÇÕ (U+00C7 U+00D5)
  0x00, 0xC7, 0x00, 0xD6, 0x01, // ÇÖ (U+00C7 U+00D6)
  0x00, 0xC7, 0x00, 0xD8, 0x01, // ÇØ (U+00C7 U+00D8)
  0x00, 0xC7, 0x01, 0x06, 0x01, // ÇĆ (U+00C7 U+0106)
  0x00, 0xC7, 0x01, 0x08, 0x01, // ÇĈ (U+00C7 U+0108)
  0x00, 0xC7, 0x01, 0x0A, 0x01, // ÇĊ (U+00C7 U+010A)
  0x00, 0xC7, 0x01, 0x0C, 0x01, // ÇČ (U+00C7 U+010C)
  0x00, 0xC7, 0x01, 0x1C, 0x01, // ÇĜ (U+00C7 U+011C)
  0x00, 0xC7, 0x01, 0x1E, 0x01, // ÇĞ (U+00C7 U+011E)
  0x00, 0xC7, 0x01, 0x20, 0x01, // ÇĠ (U+00C7 U+0120)
  0x00, 0xC7, 0x01, 0x22, 0x01, // ÇĢ (U+00C7 U+0122)
  0x00, 0xC7, 0x01, 0x4C, 0x01, // ÇŌ (U+00C7 U+014C)
  0x00, 0xC7, 0x01, 0x4E, 0x01, // ÇŎ (U+00C7 U+014E)
  0x00, 0xC7, 0x01, 0x50, 0x01, // ÇŐ (U+00C7 U+0150)
  0x00, 0xC7, 0x01, 0x52, 0x01, // ÇŒ (U+00C7 U+0152)
  0x00, 0xC7, 0x20, 0x39, 0x01, // Ç‹ (U+00C7 U+2039)
  0x00, 0xD0, 0x00, 0x2C, 0x02, // Ð, (U+00D0 U+002C)
  0x00, 0xD0, 0x00, 0x2E, 0x02, // Ð. (U+00D0 U+002E)
  0x00, 0xD0, 0x00, 0x54, 0x01, // ÐT (U+00D0 U+0054)
  0x00, 0xD0, 0x01, 0x62, 0x01, // ÐŢ (U+00D0 U+0162)
  0x00, 0xD0, 0x01, 0x64, 0x01, // ÐŤ (U+00D0 U+0164)
  0x00, 0xD0, 0x01, 0x66, 0x01, // ÐŦ (U+00D0 U+0166)
  0x00, 0xD0, 0x20, 0x1A, 0x02, // Ð‚ (U+00D0 U+201A)
  0x00, 0xD0, 0x20, 0x1E, 0x02, // Ð„ (U+00D0 U+201E)
  0x00, 0xD0, 0x20, 0x26, 0x02, // Ð… (U+00D0 U+2026)
  0x00, 0xD2, 0x00, 0x2C, 0x02, // Ò, (U+00D2 U+002C)
  0x00, 0xD2, 0x00, 0x2E, 0x02, // Ò. (U+00D2 U+002E)
  0x00, 0xD2, 0x00, 0x54, 0x01, // ÒT (U+00D2 U+0054)
  0x00, 0xD2, 0x01, 0x62, 0x01, // ÒŢ (U+00D2 U+0162)
  0x00, 0xD2, 0x01, 0x64, 0x01, // ÒŤ (U+00D2 U+0164)
  0x00, 0xD2, 0x01, 0x66, 0x01, // ÒŦ (U+00D2 U+0166)
  0x00, 0xD2, 0x20, 0x1A, 0x02, // Ò‚ (U+00D2 U+201A)
  0x00, 0xD2, 0x20, 0x1E, 0x02, // Ò„ (U+00D2 U+201E)
  0x00, 0xD2, 0x20, 0x26, 0x02, // Ò… (U+00D2 U+2026)
  0x00, 0xD3, 0x00, 0x2C, 0x02, // Ó, (U+00D3 U+002C)
  0x00, 0xD3, 0x00, 0x2E, 0x02, // Ó. (U+00D3 U+002E)
  0x00, 0xD3, 0x00, 0x54, 0x01, // ÓT (U+00D3 U+0054)
  0x00, 0xD3, 0x01, 0x62, 0x01, // ÓŢ (U+00D3 U+0162)
  0x00, 0xD3, 0x01, 0x64, 0x01, // ÓŤ (U+00D3 U+0164)
  0x00, 0xD3, 0x01, 0x66, 0x01, // ÓŦ (U+00D3 U+0166)
  0x00, 0xD3, 0x20, 0x1A, 0x02, // Ó‚ (U+00D3 U+201A)
  0x00, 0xD3, 0x20, 0x1E, 0x02, // Ó„ (U+00D3 U+201E)
  0x00, 0xD3, 0x20, 0x26, 0x02, // Ó… (U+00D3 U+2026)
  0x00, 0xD4, 0x00, 0x2C, 0x02, // Ô, (U+00D4 U+002C)
  0x00, 0xD4, 0x00, 0x2E, 0x02, // Ô. (U+00D4 U+002E)
  0x00, 0xD4, 0x00, 0x54, 0x01, // ÔT (U+00D4 U+0054)
  0x00, 0xD4, 0x01, 0x62, 0x01, // ÔŢ (U+00D4 U+0162)
  0x00, 0xD4, 0x01, 0x64, 0x01, // ÔŤ (U+00D4 U+0164)
  0x00, 0xD4, 0x01, 0x66, 0x01, // ÔŦ (U+00D4 U+0166)
  0x00, 0xD4, 0x20, 0x1A, 0x02, // Ô‚ (U+00D4 U+201A)
  0x00, 0xD4, 0x20, 0x1E, 0x02, // Ô„ (U+00D4 U+201E)
  0x00, 0xD4, 0x20, 0x26, 0x02, // Ô… (U+00D4 U+2026)
  0x00, 0xD5, 0x00, 0x2C, 0x02, // Õ, (U+00D5 U+002C)
  0x00, 0xD5, 0x00, 0x2E, 0x02, // Õ. (U+00D5 U+002E)
  0x00, 0xD5, 0x00, 0x54, 0x01, // ÕT (U+00D5 U+0054)
  0x00, 0xD5, 0x01, 0x62, 0x01, // ÕŢ (U+00D5 U+0162)
  0x00, 0xD5, 0x01, 0x64, 0x01, // ÕŤ (U+00D5 U+0164)
  0x00, 0xD5, 0x01, 0x66, 0x01, // ÕŦ (U+00D5 U+0166)
  0x00, 0xD5, 0x20, 0x1A, 0x02, // Õ‚ (U+00D5 U+201A)
  0x00, 0xD5, 0x20, 0x1E, 0x02, // Õ„ (U+00D5 U+201E)
  0x00, 0xD5, 0x20, 0x26, 0x02, // Õ… (U+00D5 U+2026)
  0x00, 0xD6, 0x00, 0x2C, 0x02, // Ö, (U+00D6 U+002C)
  0x00, 0xD6, 0x00, 0x2E, 0x02, // Ö. (U+00D6 U+002E)
  0x00, 0xD6, 0x00, 0x54, 0x01, // ÖT (U+00D6 U+0054)
  0x00, 0xD6, 0x01, 0x62, 0x01, // ÖŢ (U+00D6 U+0162)
  0x00, 0xD6, 0x01, 0x64, 0x01, // ÖŤ (U+00D6 U+0164)
  0x00, 0xD6, 0x01, 0x66, 0x01, // ÖŦ (U+00D6 U+0166)
  0x00, 0xD6, 0x20, 0x1A, 0x02, // Ö‚ (U+00D6 U+201A)
  0x00, 0xD6, 0x20, 0x1E, 0x02, // Ö„ (U+00D6 U+201E)
  0x00, 0xD6, 0x20, 0x26, 0x02, // Ö… (U+00D6 U+2026)
  0x00, 0xD8, 0x00, 0x2C, 0x02, // Ø, (U+00D8 U+002C)
  0x00, 0xD8, 0x00, 0x2E, 0x02, // Ø. (U+00D8 U+002E)
  0x00, 0xD8, 0x00, 0x54, 0x01, // ØT (U+00D8 U+0054)
  0x00, 0xD8, 0x01, 0x62, 0x01, // ØŢ (U+00D8 U+0162)
  0x00, 0xD8, 0x01, 0x64, 0x01, // ØŤ (U+00D8 U+0164)
  0x00, 0xD8, 0x01, 0x66, 0x01, // ØŦ (U+00D8 U+0166)
  0x00, 0xD8, 0x20, 0x1A, 0x02, // Ø‚ (U+00D8 U+201A)
  0x00, 0xD8, 0x20, 0x1E, 0x02, // Ø„ (U+00D8 U+201E)
  0x00, 0xD8, 0x20, 0x26, 0x02, // Ø… (U+00D8 U+2026)
  0x00, 0xD9, 0x00, 0x2C, 0x01, // Ù, (U+00D9 U+002C)
  0x00, 0xD9, 0x00, 0x2E, 0x01, // Ù. (U+00D9 U+002E)
  0x00, 0xD9, 0x20, 0x1A, 0x01, // Ù‚ (U+00D9 U+201A)
  0x00, 0xD9, 0x20, 0x1E, 0x01, // Ù„ (U+00D9 U+201E)
  0x00, 0xD9, 0x20, 0x26, 0x01, // Ù… (U+00D9 U+2026)
  0x00, 0xDA, 0x00, 0x2C, 0x01, // Ú, (U+00DA U+002C)
  0x00, 0xDA, 0x00, 0x2E, 0x01, // Ú. (U+00DA U+002E)
  0x00, 0xDA, 0x20, 0x1A, 0x01, // Ú‚ (U+00DA U+201A)
  0x00, 0xDA, 0x20, 0x1E, 0x01, // Ú„ (U+00DA U+201E)
  0x00, 0xDA, 0x20, 0x26, 0x01, // Ú… (U+00DA U+2026)
  0x00, 0xDB, 0x00, 0x2C, 0x01, // Û, (U+00DB U+002C)
  0x00, 0xDB, 0x00, 0x2E, 0x01, // Û. (U+00DB U+002E)
  0x00, 0xDB, 0x20, 0x1A, 0x01, // Û‚ (U+00DB U+201A)
  0x00, 0xDB, 0x20, 0x1E, 0x01, // Û„ (U+00DB U+201E)
  0x00, 0xDB, 0x20, 0x26, 0x01, // Û… (U+00DB U+2026)
  0x00, 0xDC, 0x00, 0x2C, 0x01, // Ü, (U+00DC U+002C)
  0x00, 0xDC, 0x00, 0x2E, 0x01, // Ü. (U+00DC U+002E)
  0x00, 0xDC, 0x20, 0x1A, 0x01, // Ü‚ (U+00DC U+201A)
  0x00, 0xDC, 0x20, 0x1E, 0x01, // Ü„ (U+00DC U+201E)
  0x00, 0xDC, 0x20, 0x26, 0x01, // Ü… (U+00DC U+2026)
  0x00, 0xDD, 0x00, 0x26, 0x01, // Ý& (U+00DD U+0026)
  0x00, 0xDD, 0x00, 0x2C, 0x03, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x03, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x00, 0x41, 0x02, // ÝA (U+00DD U+0041)
  0x00, 0xDD, 0x00, 0x43, 0x01, // ÝC (U+00DD U+0043)
  0x00, 0xDD, 0x00, 0x47, 0x01, // ÝG (U+00DD U+0047)
  0x00, 0xDD, 0x00, 0x4F, 0x01, // ÝO (U+00DD U+004F)
  0x00, 0xDD, 0x00, 0x51, 0x01, // ÝQ (U+00DD U+0051)
  0x00, 0xDD, 0x00, 0x61, 0x02, // Ýa (U+00DD U+0061)
  0x00, 0xDD, 0x00, 0x63, 0x02, // Ýc (U+00DD U+0063)
  0x00, 0xDD, 0x00, 0x64, 0x02, // Ýd (U+00DD U+0064)
  0x00, 0xDD, 0x00, 0x65, 0x02, // Ýe (U+00DD U+0065)
  0x00, 0xDD, 0x00, 0x67, 0x02, // Ýg (U+00DD U+0067)
  0x00, 0xDD, 0x00, 0x6D, 0x01, // Ým (U+00DD U+006D)
  0x00, 0xDD, 0x00, 0x6E, 0x01, // Ýn (U+00DD U+006E)
  0x00, 0xDD, 0x00, 0x6F, 0x02, // Ýo (U+00DD U+006F)
  0x00, 0xDD, 0x00, 0x70, 0x01, // Ýp (U+00DD U+0070)
  0x00, 0xDD, 0x00, 0x71, 0x02, // Ýq (U+00DD U+0071)
  0x00, 0xDD, 0x00, 0x72, 0x01, // Ýr (U+00DD U+0072)
  0x00, 0xDD, 0x00, 0x73, 0x02, // Ýs (U+00DD U+0073)
  0x00, 0xDD, 0x00, 0x75, 0x01, // Ýu (U+00DD U+0075)
  0x00, 0xDD, 0x00, 0x7A, 0x01, // Ýz (U+00DD U+007A)
  0x00, 0xDD, 0x00, 0xAB, 0x03, // Ý« (U+00DD U+00AB)
  0x00, 0xDD, 0x00, 0xBB, 0x01, // Ý» (U+00DD U+00BB)
  0x00, 0xDD, 0x00, 0xC0, 0x02, // ÝÀ (U+00DD U+00C0)
  0x00, 0xDD, 0x00, 0xC1, 0x02, // ÝÁ (U+00DD U+00C1)
  0x00, 0xDD, 0x00, 0xC2, 0x02, // ÝÂ (U+00DD U+00C2)
  0x00, 0xDD, 0x00, 0xC3, 0x02, // ÝÃ (U+00DD U+00C3)
  0x00, 0xDD, 0x00, 0xC4, 0x02, // ÝÄ (U+00DD U+00C4)
  0x00, 0xDD, 0x00, 0xC5, 0x02, // ÝÅ (U+00DD U+00C5)
  0x00, 0xDD, 0x00, 0xC7, 0x01, // ÝÇ (U+00DD U+00C7)
  0x00, 0xDD, 0x00, 0xD2, 0x01, // ÝÒ (U+00DD U+00D2)
  0x00, 0xDD, 0x00, 0xD3, 0x01, // ÝÓ (U+00DD U+00D3)
  0x00, 0xDD, 0x00, 0xD4, 0x01, // ÝÔ (U+00DD U+00D4)
  0x00, 0xDD, 0x00, 0xD5, 0x01, // ÝÕ (U+00DD U+00D5)
  0x00, 0xDD, 0x00, 0xD6, 0x01, // ÝÖ (U+00DD U+00D6)
  0x00, 0xDD, 0x00, 0xD8, 0x01, // ÝØ (U+00DD U+00D8)
  0x00, 0xDD, 0x00, 0xE0, 0x02, // Ýà (U+00DD U+00E0)
  0x00, 0xDD, 0x00, 0xE1, 0x02, // Ýá (U+00DD U+00E1)
  0x00, 0xDD, 0x00, 0xE2, 0x02, // Ýâ (U+00DD U+00E2)
  0x00, 0xDD, 0x00, 0xE3, 0x02, // Ýã (U+00DD U+00E3)
  0x00, 0xDD, 0x00, 0xE4, 0x02, // Ýä (U+00DD U+00E4)
  0x00, 0xDD, 0x00, 0xE5, 0x02, // Ýå (U+00DD U+00E5)
  0x00, 0xDD, 0x00, 0xE6, 0x02, // Ýæ (U+00DD U+00E6)
  0x00, 0xDD, 0x00, 0xE7, 0x02, // Ýç (U+00DD U+00E7)
  0x00, 0xDD, 0x00, 0xE8, 0x02, // Ýè (U+00DD U+00E8)
  0x00, 0xDD, 0x00, 0xE9, 0x02, // Ýé (U+00DD U+00E9)
  0x00, 0xDD, 0x00, 0xEA, 0x02, // Ýê (U+00DD U+00EA)
  0x00, 0xDD, 0x00, 0xEB, 0x02, // Ýë (U+00DD U+00EB)
  0x00, 0xDD, 0x00, 0xF2, 0x02, // Ýò (U+00DD U+00F2)
  0x00, 0xDD, 0x00, 0xF3, 0x02, // Ýó (U+00DD U+00F3)
  0x00, 0xDD, 0x00, 0xF4, 0x02, // Ýô (U+00DD U+00F4)
  0x00, 0xDD, 0x00, 0xF5, 0x02, // Ýõ (U+00DD U+00F5)
  0x00, 0xDD, 0x00, 0xF6, 0x02, // Ýö (U+00DD U+00F6)
  0x00, 0xDD, 0x00, 0xF8, 0x02, // Ýø (U+00DD U+00F8)
  0x00, 0xDD, 0x00, 0xF9, 0x01, // Ýù (U+00DD U+00F9)
  0x00, 0xDD, 0x00, 0xFA, 0x01, // Ýú (U+00DD U+00FA)
  0x00, 0xDD, 0x00, 0xFB, 0x01, // Ýû (U+00DD U+00FB)
  0x00, 0xDD, 0x00, 0xFC, 0x01, // Ýü (U+00DD U+00FC)
  0x00, 0xDD, 0x01, 0x00, 0x02, // ÝĀ (U+00DD U+0100)
  0x00, 0xDD, 0x01, 0x01, 0x02, // Ýā (U+00DD U+0101)
  0x00, 0xDD, 0x01, 0x02, 0x02, // ÝĂ (U+00DD U+0102)
  0x00, 0xDD, 0x01, 0x03, 0x02, // Ýă (U+00DD U+0103)
  0x00, 0xDD, 0x01, 0x04, 0x02, // ÝĄ (U+00DD U+0104)
  0x00, 0xDD, 0x01, 0x05, 0x02, // Ýą (U+00DD U+0105)
  0x00, 0xDD, 0x01, 0x06, 0x01, // ÝĆ (U+00DD U+0106)
  0x00, 0xDD, 0x01, 0x07, 0x02, // Ýć (U+00DD U+0107)
  0x00, 0xDD, 0x01, 0x08, 0x01, // ÝĈ (U+00DD U+0108)
  0x00, 0xDD, 0x01, 0x09, 0x02, // Ýĉ (U+00DD U+0109)
  0x00, 0xDD, 0x01, 0x0A, 0x01, // ÝĊ (U+00DD U+010A)
  0x00, 0xDD, 0x01, 0x0B, 0x02, // Ýċ (U+00DD U+010B)
  0x00, 0xDD, 0x01, 0x0C, 0x01, // ÝČ (U+00DD U+010C)
  0x00, 0xDD, 0x01, 0x0D, 0x02, // Ýč (U+00DD U+010D)
  0x00, 0xDD, 0x01, 0x0F, 0x02, // Ýď (U+00DD U+010F)
  0x00, 0xDD, 0x01, 0x11, 0x02, // Ýđ (U+00DD U+0111)
  0x00, 0xDD, 0x01, 0x13, 0x02, // Ýē (U+00DD U+0113)
  0x00, 0xDD, 0x01, 0x15, 0x02, // Ýĕ (U+00DD U+0115)
  0x00, 0xDD, 0x01, 0x17, 0x02, // Ýė (U+00DD U+0117)
  0x00, 0xDD, 0x01, 0x19, 0x02, // Ýę (U+00DD U+0119)
  0x00, 0xDD, 0x01, 0x1B, 0x02, // Ýě (U+00DD U+011B)
  0x00, 0xDD, 0x01, 0x1C, 0x01, // ÝĜ (U+00DD U+011C)
  0x00, 0xDD, 0x01, 0x1D, 0x02, // Ýĝ (U+00DD U+011D)
  0x00, 0xDD, 0x01, 0x1E, 0x01, // ÝĞ (U+00DD U+011E)
  0x00, 0xDD, 0x01, 0x1F, 0x02, // Ýğ (U+00DD U+011F)
  0x00, 0xDD, 0x01, 0x20, 0x01, // ÝĠ (U+00DD U+0120)
  0x00, 0xDD, 0x01, 0x21, 0x02, // Ýġ (U+00DD U+0121)
  0x00, 0xDD, 0x01, 0x22, 0x01, // ÝĢ (U+00DD U+0122)
  0x00, 0xDD, 0x01, 0x23, 0x02, // Ýģ (U+00DD U+0123)
  0x00, 0xDD, 0x01, 0x38, 0x01, // Ýĸ (U+00DD U+0138)
  0x00, 0xDD, 0x01, 0x44, 0x01, // Ýń (U+00DD U+0144)
  0x00, 0xDD, 0x01, 0x46, 0x01, // Ýņ (U+00DD U+0146)
  0x00, 0xDD, 0x01, 0x4B, 0x01, // Ýŋ (U+00DD U+014B)
  0x00, 0xDD, 0x01, 0x4C, 0x01, // ÝŌ (U+00DD U+014C)
  0x00, 0xDD, 0x01, 0x4D, 0x02, // Ýō (U+00DD U+014D)
  0x00, 0xDD, 0x01, 0x4E, 0x01, // ÝŎ (U+00DD U+014E)
  0x00, 0xDD, 0x01, 0x4F, 0x02, // Ýŏ (U+00DD U+014F)
  0x00, 0xDD, 0x01, 0x50, 0x01, // ÝŐ (U+00DD U+0150)
  0x00, 0xDD, 0x01, 0x51, 0x02, // Ýő (U+00DD U+0151)
  0x00, 0xDD, 0x01, 0x52, 0x01, // ÝŒ (U+00DD U+0152)
  0x00, 0xDD, 0x01, 0x53, 0x02, // Ýœ (U+00DD U+0153)
  0x00, 0xDD, 0x01, 0x55, 0x01, // Ýŕ (U+00DD U+0155)
  0x00, 0xDD, 0x01, 0x57, 0x01, // Ýŗ (U+00DD U+0157)
  0x00, 0xDD, 0x01, 0x5B, 0x02, // Ýś (U+00DD U+015B)
  0x00, 0xDD, 0x01, 0x5F, 0x02, // Ýş (U+00DD U+015F)
  0x00, 0xDD, 0x01, 0x69, 0x01, // Ýũ (U+00DD U+0169)
  0x00, 0xDD, 0x01, 0x6B, 0x01, // Ýū (U+00DD U+016B)
  0x00, 0xDD, 0x01, 0x6D, 0x01, // Ýŭ (U+00DD U+016D)
  0x00, 0xDD, 0x01, 0x6F, 0x01, // Ýů (U+00DD U+016F)
  0x00, 0xDD, 0x01, 0x71, 0x01, // Ýű (U+00DD U+0171)
  0x00, 0xDD, 0x01, 0x73, 0x01, // Ýų (U+00DD U+0173)
  0x00, 0xDD, 0x01, 0x7A, 0x01, // Ýź (U+00DD U+017A)
  0x00, 0xDD, 0x01, 0x7C, 0x01, // Ýż (U+00DD U+017C)
  0x00, 0xDD, 0x01, 0x7E, 0x01, // Ýž (U+00DD U+017E)
  0x00, 0xDD, 0x20, 0x1A, 0x03, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x03, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x03, // Ý… (U+00DD U+2026)
  0x00, 0xDD, 0x20, 0x39, 0x03, // Ý‹ (U+00DD U+2039)
  0x00, 0xDD, 0x20, 0x3A, 0x01, // Ý› (U+00DD U+203A)
  0x00, 0xDE, 0x00, 0x2C, 0x06, // Þ, (U+00DE U+002C)
  0x00, 0xDE, 0x00, 0x2E, 0x06, // Þ. (U+00DE U+002E)
  0x00, 0xDE, 0x00, 0x41, 0x02, // ÞA (U+00DE U+0041)
  0x00, 0xDE, 0x00, 0x58, 0x01, // ÞX (U+00DE U+0058)
  0x00, 0xDE, 0x00, 0xAB, 0x01, // Þ« (U+00DE U+00AB)
  0x00, 0xDE, 0x00, 0xC0, 0x02, // ÞÀ (U+00DE U+00C0)
  0x00, 0xDE, 0x00, 0xC1, 0x02, // ÞÁ (U+00DE U+00C1)
  0x00, 0xDE, 0x00, 0xC2, 0x02, // ÞÂ (U+00DE U+00C2)
  0x00, 0xDE, 0x00, 0xC3, 0x02, // ÞÃ (U+00DE U+00C3)
  0x00, 0xDE, 0x00, 0xC4, 0x02, // ÞÄ (U+00DE U+00C4)
  0x00, 0xDE, 0x00, 0xC5, 0x02, // ÞÅ (U+00DE U+00C5)
  0x00, 0xDE, 0x00, 0xC6, 0x02, // ÞÆ (U+00DE U+00C6)
  0x00, 0xDE, 0x01, 0x00, 0x02, // ÞĀ (U+00DE U+0100)
  0x00, 0xDE, 0x01, 0x02, 0x02, // ÞĂ (U+00DE U+0102)
  0x00, 0xDE, 0x01, 0x04, 0x02, // ÞĄ (U+00DE U+0104)
  0x00, 0xDE, 0x20, 0x1A, 0x06, // Þ‚ (U+00DE U+201A)
  0x00, 0xDE, 0x20, 0x1E, 0x06, // Þ„ (U+00DE U+201E)
  0x00, 0xDE, 0x20, 0x26, 0x06, // Þ… (U+00DE U+2026)
  0x00, 0xDE, 0x20, 0x39, 0x01, // Þ‹ (U+00DE U+2039)
  0x00, 0xE6, 0x00, 0x76, 0x01, // æv (U+00E6 U+0076)
  0x00, 0xE6, 0x00, 0x77, 0x01, // æw (U+00E6 U+0077)
  0x00, 0xE6, 0x00, 0x78, 0x01, // æx (U+00E6 U+0078)
  0x00, 0xE6, 0x00, 0x79, 0x01, // æy (U+00E6 U+0079)
  0x00, 0xE6, 0x00, 0xFD, 0x01, // æý (U+00E6 U+00FD)
  0x00, 0xE6, 0x00, 0xFF, 0x01, // æÿ (U+00E6 U+00FF)
  0x00, 0xE6, 0x01, 0x75, 0x01, // æŵ (U+00E6 U+0175)
  0x00, 0xE6, 0x01, 0x77, 0x01, // æŷ (U+00E6 U+0177)
  0x00, 0xE8, 0x00, 0x76, 0x01, // èv (U+00E8 U+0076)
  0x00, 0xE8, 0x00, 0x77, 0x01, // èw (U+00E8 U+0077)
  0x00, 0xE8, 0x00, 0x78, 0x01, // èx (U+00E8 U+0078)
  0x00, 0xE8, 0x00, 0x79, 0x01, // èy (U+00E8 U+0079)
  0x00, 0xE8, 0x00, 0xFD, 0x01, // èý (U+00E8 U+00FD)
  0x00, 0xE8, 0x00, 0xFF, 0x01, // èÿ (U+00E8 U+00FF)
  0x00, 0xE8, 0x01, 0x75, 0x01, // èŵ (U+00E8 U+0175)
  0x00, 0xE8, 0x01, 0x77, 0x01, // èŷ (U+00E8 U+0177)
  0x00, 0xE9, 0x00, 0x76, 0x01, // év (U+00E9 U+0076)
  0x00, 0xE9, 0x00, 0x77, 0x01, // éw (U+00E9 U+0077)
  0x00, 0xE9, 0x00, 0x78, 0x01, // éx (U+00E9 U+0078)
  0x00, 0xE9, 0x00, 0x79, 0x01, // éy (U+00E9 U+0079)
  0x00, 0xE9, 0x00, 0xFD, 0x01, // éý (U+00E9 U+00FD)
  0x00, 0xE9, 0x00, 0xFF, 0x01, // éÿ (U+00E9 U+00FF)
  0x00, 0xE9, 0x01, 0x75, 0x01, // éŵ (U+00E9 U+0175)
  0x00, 0xE9, 0x01, 0x77, 0x01, // éŷ (U+00E9 U+0177)
  0x00, 0xEA, 0x00, 0x76, 0x01, // êv (U+00EA U+0076)
  0x00, 0xEA, 0x00, 0x77, 0x01, // êw (U+00EA U+0077)
  0x00, 0xEA, 0x00, 0x78, 0x01, // êx (U+00EA U+0078)
  0x00, 0xEA, 0x00, 0x79, 0x01, // êy (U+00EA U+0079)
  0x00, 0xEA, 0x00, 0xFD, 0x01, // êý (U+00EA U+00FD)
  0x00, 0xEA, 0x00, 0xFF, 0x01, // êÿ (U+00EA U+00FF)
  0x00, 0xEA, 0x01, 0x75, 0x01, // êŵ (U+00EA U+0175)
  0x00, 0xEA, 0x01, 0x77, 0x01, // êŷ (U+00EA U+0177)
  0x00, 0xEB, 0x00, 0x76, 0x01, // ëv (U+00EB U+0076)
  0x00, 0xEB, 0x00, 0x77, 0x01, // ëw (U+00EB U+0077)
  0x00, 0xEB, 0x00, 0x78, 0x01, // ëx (U+00EB U+0078)
  0x00, 0xEB, 0x00, 0x79, 0x01, // ëy (U+00EB U+0079)
  0x00, 0xEB, 0x00, 0xFD, 0x01, // ëý (U+00EB U+00FD)
  0x00, 0xEB, 0x00, 0xFF, 0x01, // ëÿ (U+00EB U+00FF)
  0x00, 0xEB, 0x01, 0x75, 0x01, // ëŵ (U+00EB U+0175)
  0x00, 0xEB, 0x01, 0x77, 0x01, // ëŷ (U+00EB U+0177)
  0x00, 0xF0, 0x00, 0x76, 0x01, // ðv (U+00F0 U+0076)
  0x00, 0xF0, 0x00, 0x77, 0x01, // ðw (U+00F0 U+0077)
  0x00, 0xF0, 0x00, 0x78, 0x01, // ðx (U+00F0 U+0078)
  0x00, 0xF0, 0x00, 0x79, 0x01, // ðy (U+00F0 U+0079)
  0x00, 0xF0, 0x00, 0xFD, 0x01, // ðý (U+00F0 U+00FD)
  0x00, 0xF0, 0x00, 0xFF, 0x01, // ðÿ (U+00F0 U+00FF)
  0x00, 0xF0, 0x01, 0x75, 0x01, // ðŵ (U+00F0 U+0175)
  0x00, 0xF0, 0x01, 0x77, 0x01, // ðŷ (U+00F0 U+0177)
  0x00, 0xF2, 0x00, 0x76, 0x01, // òv (U+00F2 U+0076)
  0x00, 0xF2, 0x00, 0x77, 0x01, // òw (U+00F2 U+0077)
  0x00, 0xF2, 0x00, 0x78, 0x01, // òx (U+00F2 U+0078)
  0x00, 0xF2, 0x00, 0x79, 0x01, // òy (U+00F2 U+0079)
  0x00, 0xF2, 0x00, 0xFD, 0x01, // òý (U+00F2 U+00FD)
  0x00, 0xF2, 0x00, 0xFF, 0x01, // òÿ (U+00F2 U+00FF)
  0x00, 0xF2, 0x01, 0x75, 0x01, // òŵ (U+00F2 U+0175)
  0x00, 0xF2, 0x01, 0x77, 0x01, // òŷ (U+00F2 U+0177)
  0x00, 0xF3, 0x00, 0x76, 0x01, // óv (U+00F3 U+0076)
  0x00, 0xF3, 0x00, 0x77, 0x01, // ów (U+00F3 U+0077)
  0x00, 0xF3, 0x00, 0x78, 0x01, // óx (U+00F3 U+0078)
  0x00, 0xF3, 0x00, 0x79, 0x01, // óy (U+00F3 U+0079)
  0x00, 0xF3, 0x00, 0xFD, 0x01, // óý (U+00F3 U+00FD)
  0x00, 0xF3, 0x00, 0xFF, 0x01, // óÿ (U+00F3 U+00FF)
  0x00, 0xF3, 0x01, 0x75, 0x01, // óŵ (U+00F3 U+0175)
  0x00, 0xF3, 0x01, 0x77, 0x01, // óŷ (U+00F3 U+0177)
  0x00, 0xF4, 0x00, 0x76, 0x01, // ôv (U+00F4 U+0076)
  0x00, 0xF4, 0x00, 0x77, 0x01, // ôw (U+00F4 U+0077)
  0x00, 0xF4, 0x00, 0x78, 0x01, // ôx (U+00F4 U+0078)
  0x00, 0xF4, 0x00, 0x79, 0x01, // ôy (U+00F4 U+0079)
  0x00, 0xF4, 0x00, 0xFD, 0x01, // ôý (U+00F4 U+00FD)
  0x00, 0xF4, 0x00, 0xFF, 0x01, // ôÿ (U+00F4 U+00FF)
  0x00, 0xF4, 0x01, 0x75, 0x01, // ôŵ (U+00F4 U+0175)
  0x00, 0xF4, 0x01, 0x77, 0x01, // ôŷ (U+00F4 U+0177)
  0x00, 0xF5, 0x00, 0x76, 0x01, // õv (U+00F5 U+0076)
  0x00, 0xF5, 0x00, 0x77, 0x01, // õw (U+00F5 U+0077)
  0x00, 0xF5, 0x00, 0x78, 0x01, // õx (U+00F5 U+0078)
  0x00, 0xF5, 0x00, 0x79, 0x01, // õy (U+00F5 U+0079)
  0x00, 0xF5, 0x00, 0xFD, 0x01, // õý (U+00F5 U+00FD)
  0x00, 0xF5, 0x00, 0xFF, 0x01, // õÿ (U+00F5 U+00FF)
  0x00, 0xF5, 0x01, 0x75, 0x01, // õŵ (U+00F5 U+0175)
  0x00, 0xF5, 0x01, 0x77, 0x01, // õŷ (U+00F5 U+0177)
  0x00, 0xF6, 0x00, 0x76, 0x01, // öv (U+00F6 U+0076)
  0x00, 0xF6, 0x00, 0x77, 0x01, // öw (U+00F6 U+0077)
  0x00, 0xF6, 0x00, 0x78, 0x01, // öx (U+00F6 U+0078)
  0x00, 0xF6, 0x00, 0x79, 0x01, // öy (U+00F6 U+0079)
  0x00, 0xF6, 0x00, 0xFD, 0x01, // öý (U+00F6 U+00FD)
  0x00, 0xF6, 0x00, 0xFF, 0x01, // öÿ (U+00F6 U+00FF)
  0x00, 0xF6, 0x01, 0x75, 0x01, // öŵ (U+00F6 U+0175)
  0x00, 0xF6, 0x01, 0x77, 0x01, // öŷ (U+00F6 U+0177)
  0x00, 0xF8, 0x00, 0x76, 0x01, // øv (U+00F8 U+0076)
  0x00, 0xF8, 0x00, 0x77, 0x01, // øw (U+00F8 U+0077)
  0x00, 0xF8, 0x00, 0x78, 0x01, // øx (U+00F8 U+0078)
  0x00, 0xF8, 0x00, 0x79, 0x01, // øy (U+00F8 U+0079)
  0x00, 0xF8, 0x00, 0xFD, 0x01, // øý (U+00F8 U+00FD)
  0x00, 0xF8, 0x00, 0xFF, 0x01, // øÿ (U+00F8 U+00FF)
  0x00, 0xF8, 0x01, 0x75, 0x01, // øŵ (U+00F8 U+0175)
  0x00, 0xF8, 0x01, 0x77, 0x01, // øŷ (U+00F8 U+0177)
  0x00, 0xFD, 0x00, 0x2C, 0x02, // ý, (U+00FD U+002C)
  0x00, 0xFD, 0x00, 0x2E, 0x02, // ý. (U+00FD U+002E)
  0x00, 0xFD, 0x20, 0x1A, 0x02, // ý‚ (U+00FD U+201A)
  0x00, 0xFD, 0x20, 0x1E, 0x02, // ý„ (U+00FD U+201E)
  0x00, 0xFD, 0x20, 0x26, 0x02, // ý… (U+00FD U+2026)
  0x00, 0xFE, 0x00, 0x76, 0x01, // þv (U+00FE U+0076)
  0x00, 0xFE, 0x00, 0x77, 0x01, // þw (U+00FE U+0077)
  0x00, 0xFE, 0x00, 0x78, 0x01, // þx (U+00FE U+0078)
  0x00, 0xFE, 0x00, 0x79, 0x01, // þy (U+00FE U+0079)
  0x00, 0xFE, 0x00, 0xFD, 0x01, // þý (U+00FE U+00FD)
  0x00, 0xFE, 0x00, 0xFF, 0x01, // þÿ (U+00FE U+00FF)
  0x00, 0xFE, 0x01, 0x75, 0x01, // þŵ (U+00FE U+0175)
  0x00, 0xFE, 0x01, 0x77, 0x01, // þŷ (U+00FE U+0177)
  0x00, 0xFF, 0x00, 0x2C, 0x02, // ÿ, (U+00FF U+002C)
  0x00, 0xFF, 0x00, 0x2E, 0x02, // ÿ. (U+00FF U+002E)
  0x00, 0xFF, 0x20, 0x1A, 0x02, // ÿ‚ (U+00FF U+201A)
  0x00, 0xFF, 0x20, 0x1E, 0x02, // ÿ„ (U+00FF U+201E)
  0x00, 0xFF, 0x20, 0x26, 0x02, // ÿ… (U+00FF U+2026)
  0x01, 0x00, 0x00, 0x22, 0x03, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x03, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x00, 0x54, 0x02, // ĀT (U+0100 U+0054)
  0x01, 0x00, 0x00, 0x56, 0x01, // ĀV (U+0100 U+0056)
  0x01, 0x00, 0x00, 0x57, 0x01, // ĀW (U+0100 U+0057)
  0x01, 0x00, 0x00, 0x59, 0x02, // ĀY (U+0100 U+0059)
  0x01, 0x00, 0x00, 0xDD, 0x02, // ĀÝ (U+0100 U+00DD)
  0x01, 0x00, 0x01, 0x62, 0x02, // ĀŢ (U+0100 U+0162)
  0x01, 0x00, 0x01, 0x64, 0x02, // ĀŤ (U+0100 U+0164)
  0x01, 0x00, 0x01, 0x66, 0x02, // ĀŦ (U+0100 U+0166)
  0x01, 0x00, 0x01, 0x74, 0x01, // ĀŴ (U+0100 U+0174)
  0x01, 0x00, 0x01, 0x76, 0x02, // ĀŶ (U+0100 U+0176)
  0x01, 0x00, 0x01, 0x78, 0x02, // ĀŸ (U+0100 U+0178)
  0x01, 0x00, 0x20, 0x19, 0x03, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1D, 0x03, // Ā” (U+0100 U+201D)
  0x01, 0x02, 0x00, 0x22, 0x03, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x03, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x00, 0x54, 0x02, // ĂT (U+0102 U+0054)
  0x01, 0x02, 0x00, 0x56, 0x01, // ĂV (U+0102 U+0056)
  0x01, 0x02, 0x00, 0x57, 0x01, // ĂW (U+0102 U+0057)
  0x01, 0x02, 0x00, 0x59, 0x02, // ĂY (U+0102 U+0059)
  0x01, 0x02, 0x00, 0xDD, 0x02, // ĂÝ (U+0102 U+00DD)
  0x01, 0x02, 0x01, 0x62, 0x02, // ĂŢ (U+0102 U+0162)
  0x01, 0x02, 0x01, 0x64, 0x02, // ĂŤ (U+0102 U+0164)
  0x01, 0x02, 0x01, 0x66, 0x02, // ĂŦ (U+0102 U+0166)
  0x01, 0x02, 0x01, 0x74, 0x01, // ĂŴ (U+0102 U+0174)
  0x01, 0x02, 0x01, 0x76, 0x02, // ĂŶ (U+0102 U+0176)
  0x01, 0x02, 0x01, 0x78, 0x02, // ĂŸ (U+0102 U+0178)
  0x01, 0x02, 0x20, 0x19, 0x03, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1D, 0x03, // Ă” (U+0102 U+201D)
  0x01, 0x04, 0x00, 0x22, 0x03, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x03, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x00, 0x54, 0x02, // ĄT (U+0104 U+0054)
  0x01, 0x04, 0x00, 0x56, 0x01, // ĄV (U+0104 U+0056)
  0x01, 0x04, 0x00, 0x57, 0x01, // ĄW (U+0104 U+0057)
  0x01, 0x04, 0x00, 0x59, 0x02, // ĄY (U+0104 U+0059)
  0x01, 0x04, 0x00, 0xDD, 0x02, // ĄÝ (U+0104 U+00DD)
  0x01, 0x04, 0x01, 0x62, 0x02, // ĄŢ (U+0104 U+0162)
  0x01, 0x04, 0x01, 0x64, 0x02, // ĄŤ (U+0104 U+0164)
  0x01, 0x04, 0x01, 0x66, 0x02, // ĄŦ (U+0104 U+0166)
  0x01, 0x04, 0x01, 0x74, 0x01, // ĄŴ (U+0104 U+0174)
  0x01, 0x04, 0x01, 0x76, 0x02, // ĄŶ (U+0104 U+0176)
  0x01, 0x04, 0x01, 0x78, 0x02, // ĄŸ (U+0104 U+0178)
  0x01, 0x04, 0x20, 0x19, 0x03, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1D, 0x03, // Ą” (U+0104 U+201D)
  0x01, 0x06, 0x00, 0x43, 0x01, // ĆC (U+0106 U+0043)
  0x01, 0x06, 0x00, 0x47, 0x01, // ĆG (U+0106 U+0047)
  0x01, 0x06, 0x00, 0x4F, 0x01, // ĆO (U+0106 U+004F)
  0x01, 0x06, 0x00, 0x51, 0x01, // ĆQ (U+0106 U+0051)
  0x01, 0x06, 0x00, 0xAB, 0x01, // Ć« (U+0106 U+00AB)
  0x01, 0x06, 0x00, 0xC7, 0x01, // ĆÇ (U+0106 U+00C7)
  0x01, 0x06, 0x00, 0xD2, 0x01, // ĆÒ (U+0106 U+00D2)
  0x01, 0x06, 0x00, 0xD3, 0x01, // ĆÓ (U+0106 U+00D3)
  0x01, 0x06, 0x00, 0xD4, 0x01, // ĆÔ (U+0106 U+00D4)
  0x01, 0x06, 0x00, 0xD5, 0x01, // ĆÕ (U+0106 U+00D5)
  0x01, 0x06, 0x00, 0xD6, 0x01, // ĆÖ (U+0106 U+00D6)
  0x01, 0x06, 0x00, 0xD8, 0x01, // ĆØ (U+0106 U+00D8)
  0x01, 0x06, 0x01, 0x06, 0x01, // ĆĆ (U+0106 U+0106)
  0x01, 0x06, 0x01, 0x08, 0x01, // ĆĈ (U+0106 U+0108)
  0x01, 0x06, 0x01, 0x0A, 0x01, // ĆĊ (U+0106 U+010A)
  0x01, 0x06, 0x01, 0x0C, 0x01, // ĆČ (U+0106 U+010C)
  0x01, 0x06, 0x01, 0x1C, 0x01, // ĆĜ (U+0106 U+011C)
  0x01, 0x06, 0x01, 0x1E, 0x01, // ĆĞ (U+0106 U+011E)
  0x01, 0x06, 0x01, 0x20, 0x01, // ĆĠ (U+0106 U+0120)
  0x01, 0x06, 0x01, 0x22, 0x01, // ĆĢ (U+0106 U+0122)
  0x01, 0x06, 0x01, 0x4C, 0x01, // ĆŌ (U+0106 U+014C)
  0x01, 0x06, 0x01, 0x4E, 0x01, // ĆŎ (U+0106 U+014E)
  0x01, 0x06, 0x01, 0x50, 0x01, // ĆŐ (U+0106 U+0150)
  0x01, 0x06, 0x01, 0x52, 0x01, // ĆŒ (U+0106 U+0152)
  0x01, 0x06, 0x20, 0x39, 0x01, // Ć‹ (U+0106 U+2039)
  0x01, 0x08, 0x00, 0x43, 0x01, // ĈC (U+0108 U+0043)
  0x01, 0x08, 0x00, 0x47, 0x01, // ĈG (U+0108 U+0047)
  0x01, 0x08, 0x00, 0x4F, 0x01, // ĈO (U+0108 U+004F)
  0x01, 0x08, 0x00, 0x51, 0x01, // ĈQ (U+0108 U+0051)
  0x01, 0x08, 0x00, 0xAB, 0x01, // Ĉ« (U+0108 U+00AB)
  0x01, 0x08, 0x00, 0xC7, 0x01, // ĈÇ (U+0108 U+00C7)
  0x01, 0x08, 0x00, 0xD2, 0x01, // ĈÒ (U+0108 U+00D2)
  0x01, 0x08, 0x00, 0xD3, 0x01, // ĈÓ (U+0108 U+00D3)
  0x01, 0x08, 0x00, 0xD4, 0x01, // ĈÔ (U+0108 U+00D4)
  0x01, 0x08, 0x00, 0xD5, 0x01, // ĈÕ (U+0108 U+00D5)
  0x01, 0x08, 0x00, 0xD6, 0x01, // ĈÖ (U+0108 U+00D6)
  0x01, 0x08, 0x00, 0xD8, 0x01, // ĈØ (U+0108 U+00D8)
  0x01, 0x08, 0x01, 0x06, 0x01, // ĈĆ (U+0108 U+0106)
  0x01, 0x08, 0x01, 0x08, 0x01, // ĈĈ (U+0108 U+0108)
  0x01, 0x08, 0x01, 0x0A, 0x01, // ĈĊ (U+0108 U+010A)
  0x01, 0x08, 0x01, 0x0C, 0x01, // ĈČ (U+0108 U+010C)
  0x01, 0x08, 0x01, 0x1C, 0x01, // ĈĜ (U+0108 U+011C)
  0x01, 0x08, 0x01, 0x1E, 0x01, // ĈĞ (U+0108 U+011E)
  0x01, 0x08, 0x01, 0x20, 0x01, // ĈĠ (U+0108 U+0120)
  0x01, 0x08, 0x01, 0x22, 0x01, // ĈĢ (U+0108 U+0122)
  0x01, 0x08, 0x01, 0x4C, 0x01, // ĈŌ (U+0108 U+014C)
  0x01, 0x08, 0x01, 0x4E, 0x01, // ĈŎ (U+0108 U+014E)
  0x01, 0x08, 0x01, 0x50, 0x01, // ĈŐ (U+0108 U+0150)
  0x01, 0x08, 0x01, 0x52, 0x01, // ĈŒ (U+0108 U+0152)
  0x01, 0x08, 0x20, 0x39, 0x01, // Ĉ‹ (U+0108 U+2039)
  0x01, 0x0A, 0x00, 0x43, 0x01, // ĊC (U+010A U+0043)
  0x01, 0x0A, 0x00, 0x47, 0x01, // ĊG (U+010A U+0047)
  0x01, 0x0A, 0x00, 0x4F, 0x01, // ĊO (U+010A U+004F)
  0x01, 0x0A, 0x00, 0x51, 0x01, // ĊQ (U+010A U+0051)
  0x01, 0x0A, 0x00, 0xAB, 0x01, // Ċ« (U+010A U+00AB)
  0x01, 0x0A, 0x00, 0xC7, 0x01, // ĊÇ (U+010A U+00C7)
  0x01, 0x0A, 0x00, 0xD2, 0x01, // ĊÒ (U+010A U+00D2)
  0x01, 0x0A, 0x00, 0xD3, 0x01, // ĊÓ (U+010A U+00D3)
  0x01, 0x0A, 0x00, 0xD4, 0x01, // ĊÔ (U+010A U+00D4)
  0x01, 0x0A, 0x00, 0xD5, 0x01, // ĊÕ (U+010A U+00D5)
  0x01, 0x0A, 0x00, 0xD6, 0x01, // ĊÖ (U+010A U+00D6)
  0x01, 0x0A, 0x00, 0xD8, 0x01, // ĊØ (U+010A U+00D8)
  0x01, 0x0A, 0x01, 0x06, 0x01, // ĊĆ (U+010A U+0106)
  0x01, 0x0A, 0x01, 0x08, 0x01, // ĊĈ (U+010A U+0108)
  0x01, 0x0A, 0x01, 0x0A, 0x01, // ĊĊ (U+010A U+010A)
  0x01, 0x0A, 0x01, 0x0C, 0x01, // ĊČ (U+010A U+010C)
  0x01, 0x0A, 0x01, 0x1C, 0x01, // ĊĜ (U+010A U+011C)
  0x01, 0x0A, 0x01, 0x1E, 0x01, // ĊĞ (U+010A U+011E)
  0x01, 0x0A, 0x01, 0x20, 0x01, // ĊĠ (U+010A U+0120)
  0x01, 0x0A, 0x01, 0x22, 0x01, // ĊĢ (U+010A U+0122)
  0x01, 0x0A, 0x01, 0x4C, 0x01, // ĊŌ (U+010A U+014C)
  0x01, 0x0A, 0x01, 0x4E, 0x01, // ĊŎ (U+010A U+014E)
  0x01, 0x0A, 0x01, 0x50, 0x01, // ĊŐ (U+010A U+0150)
  0x01, 0x0A, 0x01, 0x52, 0x01, // ĊŒ (U+010A U+0152)
  0x01, 0x0A, 0x20, 0x39, 0x01, // Ċ‹ (U+010A U+2039)
  0x01, 0x0C, 0x00, 0x43, 0x01, // ČC (U+010C U+0043)
  0x01, 0x0C, 0x00, 0x47, 0x01, // ČG (U+010C U+0047)
  0x01, 0x0C, 0x00, 0x4F, 0x01, // ČO (U+010C U+004F)
  0x01, 0x0C, 0x00, 0x51, 0x01, // ČQ (U+010C U+0051)
  0x01, 0x0C, 0x00, 0xAB, 0x01, // Č« (U+010C U+00AB)
  0x01, 0x0C, 0x00, 0xC7, 0x01, // ČÇ (U+010C U+00C7)
  0x01, 0x0C, 0x00, 0xD2, 0x01, // ČÒ (U+010C U+00D2)
  0x01, 0x0C, 0x00, 0xD3, 0x01, // ČÓ (U+010C U+00D3)
  0x01, 0x0C, 0x00, 0xD4, 0x01, // ČÔ (U+010C U+00D4)
  0x01, 0x0C, 0x00, 0xD5, 0x01, // ČÕ (U+010C U+00D5)
  0x01, 0x0C, 0x00, 0xD6, 0x01, // ČÖ (U+010C U+00D6)
  0x01, 0x0C, 0x00, 0xD8, 0x01, // ČØ (U+010C U+00D8)
  0x01, 0x0C, 0x01, 0x06, 0x01, // ČĆ (U+010C U+0106)
  0x01, 0x0C, 0x01, 0x08, 0x01, // ČĈ (U+010C U+0108)
  0x01, 0x0C, 0x01, 0x0A, 0x01, // ČĊ (U+010C U+010A)
  0x01, 0x0C, 0x01, 0x0C, 0x01, // ČČ (U+010C U+010C)
  0x01, 0x0C, 0x01, 0x1C, 0x01, // ČĜ (U+010C U+011C)
  0x01, 0x0C, 0x01, 0x1E, 0x01, // ČĞ (U+010C U+011E)
  0x01, 0x0C, 0x01, 0x20, 0x01, // ČĠ (U+010C U+0120)
  0x01, 0x0C, 0x01, 0x22, 0x01, // ČĢ (U+010C U+0122)
  0x01, 0x0C, 0x01, 0x4C, 0x01, // ČŌ (U+010C U+014C)
  0x01, 0x0C, 0x01, 0x4E, 0x01, // ČŎ (U+010C U+014E)
  0x01, 0x0C, 0x01, 0x50, 0x01, // ČŐ (U+010C U+0150)
  0x01, 0x0C, 0x01, 0x52, 0x01, // ČŒ (U+010C U+0152)
  0x01, 0x0C, 0x20, 0x39, 0x01, // Č‹ (U+010C U+2039)
  0x01, 0x0E, 0x00, 0x2C, 0x02, // Ď, (U+010E U+002C)
  0x01, 0x0E, 0x00, 0x2E, 0x02, // Ď. (U+010E U+002E)
  0x01, 0x0E, 0x00, 0x54, 0x01, // ĎT (U+010E U+0054)
  0x01, 0x0E, 0x01, 0x62, 0x01, // ĎŢ (U+010E U+0162)
  0x01, 0x0E, 0x01, 0x64, 0x01, // ĎŤ (U+010E U+0164)
  0x01, 0x0E, 0x01, 0x66, 0x01, // ĎŦ (U+010E U+0166)
  0x01, 0x0E, 0x20, 0x1A, 0x02, // Ď‚ (U+010E U+201A)
  0x01, 0x0E, 0x20, 0x1E, 0x02, // Ď„ (U+010E U+201E)
  0x01, 0x0E, 0x20, 0x26, 0x02, // Ď… (U+010E U+2026)
  0x01, 0x10, 0x00, 0x2C, 0x02, // Đ, (U+0110 U+002C)
  0x01, 0x10, 0x00, 0x2E, 0x02, // Đ. (U+0110 U+002E)
  0x01, 0x10, 0x00, 0x54, 0x01, // ĐT (U+0110 U+0054)
  0x01, 0x10, 0x01, 0x62, 0x01, // ĐŢ (U+0110 U+0162)
  0x01, 0x10, 0x01, 0x64, 0x01, // ĐŤ (U+0110 U+0164)
  0x01, 0x10, 0x01, 0x66, 0x01, // ĐŦ (U+0110 U+0166)
  0x01, 0x10, 0x20, 0x1A, 0x02, // Đ‚ (U+0110 U+201A)
  0x01, 0x10, 0x20, 0x1E, 0x02, // Đ„ (U+0110 U+201E)
  0x01, 0x10, 0x20, 0x26, 0x02, // Đ… (U+0110 U+2026)
  0x01, 0x13, 0x00, 0x76, 0x01, // ēv (U+0113 U+0076)
  0x01, 0x13, 0x00, 0x77, 0x01, // ēw (U+0113 U+0077)
  0x01, 0x13, 0x00, 0x78, 0x01, // ēx (U+0113 U+0078)
  0x01, 0x13, 0x00, 0x79, 0x01, // ēy (U+0113 U+0079)
  0x01, 0x13, 0x00, 0xFD, 0x01, // ēý (U+0113 U+00FD)
  0x01, 0x13, 0x00, 0xFF, 0x01, // ēÿ (U+0113 U+00FF)
  0x01, 0x13, 0x01, 0x75, 0x01, // ēŵ (U+0113 U+0175)
  0x01, 0x13, 0x01, 0x77, 0x01, // ēŷ (U+0113 U+0177)
  0x01, 0x15, 0x00, 0x76, 0x01, // ĕv (U+0115 U+0076)
  0x01, 0x15, 0x00, 0x77, 0x01, // ĕw (U+0115 U+0077)
  0x01, 0x15, 0x00, 0x78, 0x01, // ĕx (U+0115 U+0078)
  0x01, 0x15, 0x00, 0x79, 0x01, // ĕy (U+0115 U+0079)
  0x01, 0x15, 0x00, 0xFD, 0x01, // ĕý (U+0115 U+00FD)
  0x01, 0x15, 0x00, 0xFF, 0x01, // ĕÿ (U+0115 U+00FF)
  0x01, 0x15, 0x01, 0x75, 0x01, // ĕŵ (U+0115 U+0175)
  0x01, 0x15, 0x01, 0x77, 0x01, // ĕŷ (U+0115 U+0177)
  0x01, 0x17, 0x00, 0x76, 0x01, // ėv (U+0117 U+0076)
  0x01, 0x17, 0x00, 0x77, 0x01, // ėw (U+0117 U+0077)
  0x01, 0x17, 0x00, 0x78, 0x01, // ėx (U+0117 U+0078)
  0x01, 0x17, 0x00, 0x79, 0x01, // ėy (U+0117 U+0079)
  0x01, 0x17, 0x00, 0xFD, 0x01, // ėý (U+0117 U+00FD)
  0x01, 0x17, 0x00, 0xFF, 0x01, // ėÿ (U+0117 U+00FF)
  0x01, 0x17, 0x01, 0x75, 0x01, // ėŵ (U+0117 U+0175)
  0x01, 0x17, 0x01, 0x77, 0x01, // ėŷ (U+0117 U+0177)
  0x01, 0x19, 0x00, 0x76, 0x01, // ęv (U+0119 U+0076)
  0x01, 0x19, 0x00, 0x77, 0x01, // ęw (U+0119 U+0077)
  0x01, 0x19, 0x00, 0x78, 0x01, // ęx (U+0119 U+0078)
  0x01, 0x19, 0x00, 0x79, 0x01, // ęy (U+0119 U+0079)
  0x01, 0x19, 0x00, 0xFD, 0x01, // ęý (U+0119 U+00FD)
  0x01, 0x19, 0x00, 0xFF, 0x01, // ęÿ (U+0119 U+00FF)
  0x01, 0x19, 0x01, 0x75, 0x01, // ęŵ (U+0119 U+0175)
  0x01, 0x19, 0x01, 0x77, 0x01, // ęŷ (U+0119 U+0177)
  0x01, 0x1B, 0x00, 0x76, 0x01, // ěv (U+011B U+0076)
  0x01, 0x1B, 0x00, 0x77, 0x01, // ěw (U+011B U+0077)
  0x01, 0x1B, 0x00, 0x78, 0x01, // ěx (U+011B U+0078)
  0x01, 0x1B, 0x00, 0x79, 0x01, // ěy (U+011B U+0079)
  0x01, 0x1B, 0x00, 0xFD, 0x01, // ěý (U+011B U+00FD)
  0x01, 0x1B, 0x00, 0xFF, 0x01, // ěÿ (U+011B U+00FF)
  0x01, 0x1B, 0x01, 0x75, 0x01, // ěŵ (U+011B U+0175)
  0x01, 0x1B, 0x01, 0x77, 0x01, // ěŷ (U+011B U+0177)
  0x01, 0x36, 0x00, 0xAB, 0x01, // Ķ« (U+0136 U+00AB)
  0x01, 0x36, 0x20, 0x39, 0x01, // Ķ‹ (U+0136 U+2039)
  0x01, 0x39, 0x00, 0x22, 0x03, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x03, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x00, 0x43, 0x01, // ĹC (U+0139 U+0043)
  0x01, 0x39, 0x00, 0x47, 0x01, // ĹG (U+0139 U+0047)
  0x01, 0x39, 0x00, 0x4F, 0x01, // ĹO (U+0139 U+004F)
  0x01, 0x39, 0x00, 0x51, 0x01, // ĹQ (U+0139 U+0051)
  0x01, 0x39, 0x00, 0x54, 0x02, // ĹT (U+0139 U+0054)
  0x01, 0x39, 0x00, 0x56, 0x02, // ĹV (U+0139 U+0056)
  0x01, 0x39, 0x00, 0x57, 0x02, // ĹW (U+0139 U+0057)
  0x01, 0x39, 0x00, 0x59, 0x02, // ĹY (U+0139 U+0059)
  0x01, 0x39, 0x00, 0xC7, 0x01, // ĹÇ (U+0139 U+00C7)
  0x01, 0x39, 0x00, 0xD2, 0x01, // ĹÒ (U+0139 U+00D2)
  0x01, 0x39, 0x00, 0xD3, 0x01, // ĹÓ (U+0139 U+00D3)
  0x01, 0x39, 0x00, 0xD4, 0x01, // ĹÔ (U+0139 U+00D4)
  0x01, 0x39, 0x00, 0xD5, 0x01, // ĹÕ (U+0139 U+00D5)
  0x01, 0x39, 0x00, 0xD6, 0x01, // ĹÖ (U+0139 U+00D6)
  0x01, 0x39, 0x00, 0xD8, 0x01, // ĹØ (U+0139 U+00D8)
  0x01, 0x39, 0x00, 0xDD, 0x02, // ĹÝ (U+0139 U+00DD)
  0x01, 0x39, 0x01, 0x06, 0x01, // ĹĆ (U+0139 U+0106)
  0x01, 0x39, 0x01, 0x08, 0x01, // ĹĈ (U+0139 U+0108)
  0x01, 0x39, 0x01, 0x0A, 0x01, // ĹĊ (U+0139 U+010A)
  0x01, 0x39, 0x01, 0x0C, 0x01, // ĹČ (U+0139 U+010C)
  0x01, 0x39, 0x01, 0x1C, 0x01, // ĹĜ (U+0139 U+011C)
  0x01, 0x39, 0x01, 0x1E, 0x01, // ĹĞ (U+0139 U+011E)
  0x01, 0x39, 0x01, 0x20, 0x01, // ĹĠ (U+0139 U+0120)
  0x01, 0x39, 0x01, 0x22, 0x01, // ĹĢ (U+0139 U+0122)
  0x01, 0x39, 0x01, 0x4C, 0x01, // ĹŌ (U+0139 U+014C)
  0x01, 0x39, 0x01, 0x4E, 0x01, // ĹŎ (U+0139 U+014E)
  0x01, 0x39, 0x01, 0x50, 0x01, // ĹŐ (U+0139 U+0150)
  0x01, 0x39, 0x01, 0x52, 0x01, // ĹŒ (U+0139 U+0152)
  0x01, 0x39, 0x01, 0x62, 0x02, // ĹŢ (U+0139 U+0162)
  0x01, 0x39, 0x01, 0x64, 0x02, // ĹŤ (U+0139 U+0164)
  0x01, 0x39, 0x01, 0x66, 0x02, // ĹŦ (U+0139 U+0166)
  0x01, 0x39, 0x01, 0x74, 0x02, // ĹŴ (U+0139 U+0174)
  0x01, 0x39, 0x01, 0x76, 0x02, // ĹŶ (U+0139 U+0176)
  0x01, 0x39, 0x01, 0x78, 0x02, // ĹŸ (U+0139 U+0178)
  0x01, 0x39, 0x20, 0x19, 0x03, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1D, 0x03, // Ĺ” (U+0139 U+201D)
  0x01, 0x3B, 0x00, 0x22, 0x03, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x03, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x00, 0x43, 0x01, // ĻC (U+013B U+0043)
  0x01, 0x3B, 0x00, 0x47, 0x01, // ĻG (U+013B U+0047)
  0x01, 0x3B, 0x00, 0x4F, 0x01, // ĻO (U+013B U+004F)
  0x01, 0x3B, 0x00, 0x51, 0x01, // ĻQ (U+013B U+0051)
  0x01, 0x3B, 0x00, 0x54, 0x02, // ĻT (U+013B U+0054)
  0x01, 0x3B, 0x00, 0x56, 0x02, // ĻV (U+013B U+0056)
  0x01, 0x3B, 0x00, 0x57, 0x02, // ĻW (U+013B U+0057)
  0x01, 0x3B, 0x00, 0x59, 0x02, // ĻY (U+013B U+0059)
  0x01, 0x3B, 0x00, 0xC7, 0x01, // ĻÇ (U+013B U+00C7)
  0x01, 0x3B, 0x00, 0xD2, 0x01, // ĻÒ (U+013B U+00D2)
  0x01, 0x3B, 0x00, 0xD3, 0x01, // ĻÓ (U+013B U+00D3)
  0x01, 0x3B, 0x00, 0xD4, 0x01, // ĻÔ (U+013B U+00D4)
  0x01, 0x3B, 0x00, 0xD5, 0x01, // ĻÕ (U+013B U+00D5)
  0x01, 0x3B, 0x00, 0xD6, 0x01, // ĻÖ (U+013B U+00D6)
  0x01, 0x3B, 0x00, 0xD8, 0x01, // ĻØ (U+013B U+00D8)
  0x01, 0x3B, 0x00, 0xDD, 0x02, // ĻÝ (U+013B U+00DD)
  0x01, 0x3B, 0x01, 0x06, 0x01, // ĻĆ (U+013B U+0106)
  0x01, 0x3B, 0x01, 0x08, 0x01, // ĻĈ (U+013B U+0108)
  0x01, 0x3B, 0x01, 0x0A, 0x01, // ĻĊ (U+013B U+010A)
  0x01, 0x3B, 0x01, 0x0C, 0x01, // ĻČ (U+013B U+010C)
  0x01, 0x3B, 0x01, 0x1C, 0x01, // ĻĜ (U+013B U+011C)
  0x01, 0x3B, 0x01, 0x1E, 0x01, // ĻĞ (U+013B U+011E)
  0x01, 0x3B, 0x01, 0x20, 0x01, // ĻĠ (U+013B U+0120)
  0x01, 0x3B, 0x01, 0x22, 0x01, // ĻĢ (U+013B U+0122)
  0x01, 0x3B, 0x01, 0x4C, 0x01, // ĻŌ (U+013B U+014C)
  0x01, 0x3B, 0x01, 0x4E, 0x01, // ĻŎ (U+013B U+014E)
  0x01, 0x3B, 0x01, 0x50, 0x01, // ĻŐ (U+013B U+0150)
  0x01, 0x3B, 0x01, 0x52, 0x01, // ĻŒ (U+013B U+0152)
  0x01, 0x3B, 0x01, 0x62, 0x02, // ĻŢ (U+013B U+0162)
  0x01, 0x3B, 0x01, 0x64, 0x02, // ĻŤ (U+013B U+0164)
  0x01, 0x3B, 0x01, 0x66, 0x02, // ĻŦ (U+013B U+0166)
  0x01, 0x3B, 0x01, 0x74, 0x02, // ĻŴ (U+013B U+0174)
  0x01, 0x3B, 0x01, 0x76, 0x02, // ĻŶ (U+013B U+0176)
  0x01, 0x3B, 0x01, 0x78, 0x02, // ĻŸ (U+013B U+0178)
  0x01, 0x3B, 0x20, 0x19, 0x03, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1D, 0x03, // Ļ” (U+013B U+201D)
  0x01, 0x3D, 0x00, 0x22, 0x03, // Ľ" (U+013D U+0022)
  0x01, 0x3D, 0x00, 0x27, 0x03, // Ľ' (U+013D U+0027)
  0x01, 0x3D, 0x00, 0x43, 0x01, // ĽC (U+013D U+0043)
  0x01, 0x3D, 0x00, 0x47, 0x01, // ĽG (U+013D U+0047)
  0x01, 0x3D, 0x00, 0x4F, 0x01, // ĽO (U+013D U+004F)
  0x01, 0x3D, 0x00, 0x51, 0x01, // ĽQ (U+013D U+0051)
  0x01, 0x3D, 0x00, 0x54, 0x02, // ĽT (U+013D U+0054)
  0x01, 0x3D, 0x00, 0x56, 0x02, // ĽV (U+013D U+0056)
  0x01, 0x3D, 0x00, 0x57, 0x02, // ĽW (U+013D U+0057)
  0x01, 0x3D, 0x00, 0x59, 0x02, // ĽY (U+013D U+0059)
  0x01, 0x3D, 0x00, 0xC7, 0x01, // ĽÇ (U+013D U+00C7)
  0x01, 0x3D, 0x00, 0xD2, 0x01, // ĽÒ (U+013D U+00D2)
  0x01, 0x3D, 0x00, 0xD3, 0x01, // ĽÓ (U+013D U+00D3)
  0x01, 0x3D, 0x00, 0xD4, 0x01, // ĽÔ (U+013D U+00D4)
  0x01, 0x3D, 0x00, 0xD5, 0x01, // ĽÕ (U+013D U+00D5)
  0x01, 0x3D, 0x00, 0xD6, 0x01, // ĽÖ (U+013D U+00D6)
  0x01, 0x3D, 0x00, 0xD8, 0x01, // ĽØ (U+013D U+00D8)
  0x01, 0x3D, 0x00, 0xDD, 0x02, // ĽÝ (U+013D U+00DD)
  0x01, 0x3D, 0x01, 0x06, 0x01, // ĽĆ (U+013D U+0106)
  0x01, 0x3D, 0x01, 0x08, 0x01, // ĽĈ (U+013D U+0108)
  0x01, 0x3D, 0x01, 0x0A, 0x01, // ĽĊ (U+013D U+010A)
  0x01, 0x3D, 0x01, 0x0C, 0x01, // ĽČ (U+013D U+010C)
  0x01, 0x3D, 0x01, 0x1C, 0x01, // ĽĜ (U+013D U+011C)
  0x01, 0x3D, 0x01, 0x1E, 0x01, // ĽĞ (U+013D U+011E)
  0x01, 0x3D, 0x01, 0x20, 0x01, // ĽĠ (U+013D U+0120)
  0x01, 0x3D, 0x01, 0x22, 0x01, // ĽĢ (U+013D U+0122)
  0x01, 0x3D, 0x01, 0x4C, 0x01, // ĽŌ (U+013D U+014C)
  0x01, 0x3D, 0x01, 0x4E, 0x01, // ĽŎ (U+013D U+014E)
  0x01, 0x3D, 0x01, 0x50, 0x01, // ĽŐ (U+013D U+0150)
  0x01, 0x3D, 0x01, 0x52, 0x01, // ĽŒ (U+013D U+0152)
  0x01, 0x3D, 0x01, 0x62, 0x02, // ĽŢ (U+013D U+0162)
  0x01, 0x3D, 0x01, 0x64, 0x02, // ĽŤ (U+013D U+0164)
  0x01, 0x3D, 0x01, 0x66, 0x02, // ĽŦ (U+013D U+0166)
  0x01, 0x3D, 0x01, 0x74, 0x02, // ĽŴ (U+013D U+0174)
  0x01, 0x3D, 0x01, 0x76, 0x02, // ĽŶ (U+013D U+0176)
  0x01, 0x3D, 0x01, 0x78, 0x02, // ĽŸ (U+013D U+0178)
  0x01, 0x3D, 0x20, 0x19, 0x03, // Ľ’ (U+013D U+2019)
  0x01, 0x3D, 0x20, 0x1D, 0x03, // Ľ” (U+013D U+201D)
  0x01, 0x3F, 0x00, 0x22, 0x03, // Ŀ" (U+013F U+0022)
  0x01, 0x3F, 0x00, 0x27, 0x03, // Ŀ' (U+013F U+0027)
  0x01, 0x3F, 0x00, 0x43, 0x01, // ĿC (U+013F U+0043)
  0x01, 0x3F, 0x00, 0x47, 0x01, // ĿG (U+013F U+0047)
  0x01, 0x3F, 0x00, 0x4F, 0x01, // ĿO (U+013F U+004F)
  0x01, 0x3F, 0x00, 0x51, 0x01, // ĿQ (U+013F U+0051)
  0x01, 0x3F, 0x00, 0x54, 0x02, // ĿT (U+013F U+0054)
  0x01, 0x3F, 0x00, 0x56, 0x02, // ĿV (U+013F U+0056)
  0x01, 0x3F, 0x00, 0x57, 0x02, // ĿW (U+013F U+0057)
  0x01, 0x3F, 0x00, 0x59, 0x02, // ĿY (U+013F U+0059)
  0x01, 0x3F, 0x00, 0xC7, 0x01, // ĿÇ (U+013F U+00C7)
  0x01, 0x3F, 0x00, 0xD2, 0x01, // ĿÒ (U+013F U+00D2)
  0x01, 0x3F, 0x00, 0xD3, 0x01, // ĿÓ (U+013F U+00D3)
  0x01, 0x3F, 0x00, 0xD4, 0x01, // ĿÔ (U+013F U+00D4)
  0x01, 0x3F, 0x00, 0xD5, 0x01, // ĿÕ (U+013F U+00D5)
  0x01, 0x3F, 0x00, 0xD6, 0x01, // ĿÖ (U+013F U+00D6)
  0x01, 0x3F, 0x00, 0xD8, 0x01, // ĿØ (U+013F U+00D8)
  0x01, 0x3F, 0x00, 0xDD, 0x02, // ĿÝ (U+013F U+00DD)
  0x01, 0x3F, 0x01, 0x06, 0x01, // ĿĆ (U+013F U+0106)
  0x01, 0x3F, 0x01, 0x08, 0x01, // ĿĈ (U+013F U+0108)
  0x01, 0x3F, 0x01, 0x0A, 0x01, // ĿĊ (U+013F U+010A)
  0x01, 0x3F, 0x01, 0x0C, 0x01, // ĿČ (U+013F U+010C)
  0x01, 0x3F, 0x01, 0x1C, 0x01, // ĿĜ (U+013F U+011C)
  0x01, 0x3F, 0x01, 0x1E, 0x01, // ĿĞ (U+013F U+011E)
  0x01, 0x3F, 0x01, 0x20, 0x01, // ĿĠ (U+013F U+0120)
  0x01, 0x3F, 0x01, 0x22, 0x01, // ĿĢ (U+013F U+0122)
  0x01, 0x3F, 0x01, 0x4C, 0x01, // ĿŌ (U+013F U+014C)
  0x01, 0x3F, 0x01, 0x4E, 0x01, // ĿŎ (U+013F U+014E)
  0x01, 0x3F, 0x01, 0x50, 0x01, // ĿŐ (U+013F U+0150)
  0x01, 0x3F, 0x01, 0x52, 0x01, // ĿŒ (U+013F U+0152)
  0x01, 0x3F, 0x01, 0x62, 0x02, // ĿŢ (U+013F U+0162)
  0x01, 0x3F, 0x01, 0x64, 0x02, // ĿŤ (U+013F U+0164)
  0x01, 0x3F, 0x01, 0x66, 0x02, // ĿŦ (U+013F U+0166)
  0x01, 0x3F, 0x01, 0x74, 0x02, // ĿŴ (U+013F U+0174)
  0x01, 0x3F, 0x01, 0x76, 0x02, // ĿŶ (U+013F U+0176)
  0x01, 0x3F, 0x01, 0x78, 0x02, // ĿŸ (U+013F U+0178)
  0x01, 0x3F, 0x20, 0x19, 0x03, // Ŀ’ (U+013F U+2019)
  0x01, 0x3F, 0x20, 0x1D, 0x03, // Ŀ” (U+013F U+201D)
  0x01, 0x41, 0x00, 0x22, 0x03, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x03, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x00, 0x43, 0x01, // ŁC (U+0141 U+0043)
  0x01, 0x41, 0x00, 0x47, 0x01, // ŁG (U+0141 U+0047)
  0x01, 0x41, 0x00, 0x4F, 0x01, // ŁO (U+0141 U+004F)
  0x01, 0x41, 0x00, 0x51, 0x01, // ŁQ (U+0141 U+0051)
  0x01, 0x41, 0x00, 0x54, 0x02, // ŁT (U+0141 U+0054)
  0x01, 0x41, 0x00, 0x56, 0x02, // ŁV (U+0141 U+0056)
  0x01, 0x41, 0x00, 0x57, 0x02, // ŁW (U+0141 U+0057)
  0x01, 0x41, 0x00, 0x59, 0x02, // ŁY (U+0141 U+0059)
  0x01, 0x41, 0x00, 0xC7, 0x01, // ŁÇ (U+0141 U+00C7)
  0x01, 0x41, 0x00, 0xD2, 0x01, // ŁÒ (U+0141 U+00D2)
  0x01, 0x41, 0x00, 0xD3, 0x01, // ŁÓ (U+0141 U+00D3)
  0x01, 0x41, 0x00, 0xD4, 0x01, // ŁÔ (U+0141 U+00D4)
  0x01, 0x41, 0x00, 0xD5, 0x01, // ŁÕ (U+0141 U+00D5)
  0x01, 0x41, 0x00, 0xD6, 0x01, // ŁÖ (U+0141 U+00D6)
  0x01, 0x41, 0x00, 0xD8, 0x01, // ŁØ (U+0141 U+00D8)
  0x01, 0x41, 0x00, 0xDD, 0x02, // ŁÝ (U+0141 U+00DD)
  0x01, 0x41, 0x01, 0x06, 0x01, // ŁĆ (U+0141 U+0106)
  0x01, 0x41, 0x01, 0x08, 0x01, // ŁĈ (U+0141 U+0108)
  0x01, 0x41, 0x01, 0x0A, 0x01, // ŁĊ (U+0141 U+010A)
  0x01, 0x41, 0x01, 0x0C, 0x01, // ŁČ (U+0141 U+010C)
  0x01, 0x41, 0x01, 0x1C, 0x01, // ŁĜ (U+0141 U+011C)
  0x01, 0x41, 0x01, 0x1E, 0x01, // ŁĞ (U+0141 U+011E)
  0x01, 0x41, 0x01, 0x20, 0x01, // ŁĠ (U+0141 U+0120)
  0x01, 0x41, 0x01, 0x22, 0x01, // ŁĢ (U+0141 U+0122)
  0x01, 0x41, 0x01, 0x4C, 0x01, // ŁŌ (U+0141 U+014C)
  0x01, 0x41, 0x01, 0x4E, 0x01, // ŁŎ (U+0141 U+014E)
  0x01, 0x41, 0x01, 0x50, 0x01, // ŁŐ (U+0141 U+0150)
  0x01, 0x41, 0x01, 0x52, 0x01, // ŁŒ (U+0141 U+0152)
  0x01, 0x41, 0x01, 0x62, 0x02, // ŁŢ (U+0141 U+0162)
  0x01, 0x41, 0x01, 0x64, 0x02, // ŁŤ (U+0141 U+0164)
  0x01, 0x41, 0x01, 0x66, 0x02, // ŁŦ (U+0141 U+0166)
  0x01, 0x41, 0x01, 0x74, 0x02, // ŁŴ (U+0141 U+0174)
  0x01, 0x41, 0x01, 0x76, 0x02, // ŁŶ (U+0141 U+0176)
  0x01, 0x41, 0x01, 0x78, 0x02, // ŁŸ (U+0141 U+0178)
  0x01, 0x41, 0x20, 0x19, 0x03, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1D, 0x03, // Ł” (U+0141 U+201D)
  0x01, 0x4C, 0x00, 0x2C, 0x02, // Ō, (U+014C U+002C)
  0x01, 0x4C, 0x00, 0x2E, 0x02, // Ō. (U+014C U+002E)
  0x01, 0x4C, 0x00, 0x54, 0x01, // ŌT (U+014C U+0054)
  0x01, 0x4C, 0x01, 0x62, 0x01, // ŌŢ (U+014C U+0162)
  0x01, 0x4C, 0x01, 0x64, 0x01, // ŌŤ (U+014C U+0164)
  0x01, 0x4C, 0x01, 0x66, 0x01, // ŌŦ (U+014C U+0166)
  0x01, 0x4C, 0x20, 0x1A, 0x02, // Ō‚ (U+014C U+201A)
  0x01, 0x4C, 0x20, 0x1E, 0x02, // Ō„ (U+014C U+201E)
  0x01, 0x4C, 0x20, 0x26, 0x02, // Ō… (U+014C U+2026)
  0x01, 0x4D, 0x00, 0x76, 0x01, // ōv (U+014D U+0076)
  0x01, 0x4D, 0x00, 0x77, 0x01, // ōw (U+014D U+0077)
  0x01, 0x4D, 0x00, 0x78, 0x01, // ōx (U+014D U+0078)
  0x01, 0x4D, 0x00, 0x79, 0x01, // ōy (U+014D U+0079)
  0x01, 0x4D, 0x00, 0xFD, 0x01, // ōý (U+014D U+00FD)
  0x01, 0x4D, 0x00, 0xFF, 0x01, // ōÿ (U+014D U+00FF)
  0x01, 0x4D, 0x01, 0x75, 0x01, // ōŵ (U+014D U+0175)
  0x01, 0x4D, 0x01, 0x77, 0x01, // ōŷ (U+014D U+0177)
  0x01, 0x4E, 0x00, 0x2C, 0x02, // Ŏ, (U+014E U+002C)
  0x01, 0x4E, 0x00, 0x2E, 0x02, // Ŏ. (U+014E U+002E)
  0x01, 0x4E, 0x00, 0x54, 0x01, // ŎT (U+014E U+0054)
  0x01, 0x4E, 0x01, 0x62, 0x01, // ŎŢ (U+014E U+0162)
  0x01, 0x4E, 0x01, 0x64, 0x01, // ŎŤ (U+014E U+0164)
  0x01, 0x4E, 0x01, 0x66, 0x01, // ŎŦ (U+014E U+0166)
  0x01, 0x4E, 0x20, 0x1A, 0x02, // Ŏ‚ (U+014E U+201A)
  0x01, 0x4E, 0x20, 0x1E, 0x02, // Ŏ„ (U+014E U+201E)
  0x01, 0x4E, 0x20, 0x26, 0x02, // Ŏ… (U+014E U+2026)
  0x01, 0x4F, 0x00, 0x76, 0x01, // ŏv (U+014F U+0076)
  0x01, 0x4F, 0x00, 0x77, 0x01, // ŏw (U+014F U+0077)
  0x01, 0x4F, 0x00, 0x78, 0x01, // ŏx (U+014F U+0078)
  0x01, 0x4F, 0x00, 0x79, 0x01, // ŏy (U+014F U+0079)
  0x01, 0x4F, 0x00, 0xFD, 0x01, // ŏý (U+014F U+00FD)
  0x01, 0x4F, 0x00, 0xFF, 0x01, // ŏÿ (U+014F U+00FF)
  0x01, 0x4F, 0x01, 0x75, 0x01, // ŏŵ (U+014F U+0175)
  0x01, 0x4F, 0x01, 0x77, 0x01, // ŏŷ (U+014F U+0177)
  0x01, 0x50, 0x00, 0x2C, 0x02, // Ő, (U+0150 U+002C)
  0x01, 0x50, 0x00, 0x2E, 0x02, // Ő. (U+0150 U+002E)
  0x01, 0x50, 0x00, 0x54, 0x01, // ŐT (U+0150 U+0054)
  0x01, 0x50, 0x01, 0x62, 0x01, // ŐŢ (U+0150 U+0162)
  0x01, 0x50, 0x01, 0x64, 0x01, // ŐŤ (U+0150 U+0164)
  0x01, 0x50, 0x01, 0x66, 0x01, // ŐŦ (U+0150 U+0166)
  0x01, 0x50, 0x20, 0x1A, 0x02, // Ő‚ (U+0150 U+201A)
  0x01, 0x50, 0x20, 0x1E, 0x02, // Ő„ (U+0150 U+201E)
  0x01, 0x50, 0x20, 0x26, 0x02, // Ő… (U+0150 U+2026)
  0x01, 0x51, 0x00, 0x76, 0x01, // őv (U+0151 U+0076)
  0x01, 0x51, 0x00, 0x77, 0x01, // őw (U+0151 U+0077)
  0x01, 0x51, 0x00, 0x78, 0x01, // őx (U+0151 U+0078)
  0x01, 0x51, 0x00, 0x79, 0x01, // őy (U+0151 U+0079)
  0x01, 0x51, 0x00, 0xFD, 0x01, // őý (U+0151 U+00FD)
  0x01, 0x51, 0x00, 0xFF, 0x01, // őÿ (U+0151 U+00FF)
  0x01, 0x51, 0x01, 0x75, 0x01, // őŵ (U+0151 U+0175)
  0x01, 0x51, 0x01, 0x77, 0x01, // őŷ (U+0151 U+0177)
  0x01, 0x53, 0x00, 0x76, 0x01, // œv (U+0153 U+0076)
  0x01, 0x53, 0x00, 0x77, 0x01, // œw (U+0153 U+0077)
  0x01, 0x53, 0x00, 0x78, 0x01, // œx (U+0153 U+0078)
  0x01, 0x53, 0x00, 0x79, 0x01, // œy (U+0153 U+0079)
  0x01, 0x53, 0x00, 0xFD, 0x01, // œý (U+0153 U+00FD)
  0x01, 0x53, 0x00, 0xFF, 0x01, // œÿ (U+0153 U+00FF)
  0x01, 0x53, 0x01, 0x75, 0x01, // œŵ (U+0153 U+0175)
  0x01, 0x53, 0x01, 0x77, 0x01, // œŷ (U+0153 U+0177)
  0x01, 0x55, 0x00, 0x2C, 0x03, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x03, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x00, 0x61, 0x01, // ŕa (U+0155 U+0061)
  0x01, 0x55, 0x00, 0x63, 0x01, // ŕc (U+0155 U+0063)
  0x01, 0x55, 0x00, 0x64, 0x01, // ŕd (U+0155 U+0064)
  0x01, 0x55, 0x00, 0x65, 0x01, // ŕe (U+0155 U+0065)
  0x01, 0x55, 0x00, 0x6F, 0x01, // ŕo (U+0155 U+006F)
  0x01, 0x55, 0x00, 0x71, 0x01, // ŕq (U+0155 U+0071)
  0x01, 0x55, 0x00, 0xE0, 0x01, // ŕà (U+0155 U+00E0)
  0x01, 0x55, 0x00, 0xE1, 0x01, // ŕá (U+0155 U+00E1)
  0x01, 0x55, 0x00, 0xE2, 0x01, // ŕâ (U+0155 U+00E2)
  0x01, 0x55, 0x00, 0xE3, 0x01, // ŕã (U+0155 U+00E3)
  0x01, 0x55, 0x00, 0xE4, 0x01, // ŕä (U+0155 U+00E4)
  0x01, 0x55, 0x00, 0xE5, 0x01, // ŕå (U+0155 U+00E5)
  0x01, 0x55, 0x00, 0xE6, 0x01, // ŕæ (U+0155 U+00E6)
  0x01, 0x55, 0x00, 0xE7, 0x01, // ŕç (U+0155 U+00E7)
  0x01, 0x55, 0x00, 0xE8, 0x01, // ŕè (U+0155 U+00E8)
  0x01, 0x55, 0x00, 0xE9, 0x01, // ŕé (U+0155 U+00E9)
  0x01, 0x55, 0x00, 0xEA, 0x01, // ŕê (U+0155 U+00EA)
  0x01, 0x55, 0x00, 0xEB, 0x01, // ŕë (U+0155 U+00EB)
  0x01, 0x55, 0x00, 0xF2, 0x01, // ŕò (U+0155 U+00F2)
  0x01, 0x55, 0x00, 0xF3, 0x01, // ŕó (U+0155 U+00F3)
  0x01, 0x55, 0x00, 0xF4, 0x01, // ŕô (U+0155 U+00F4)
  0x01, 0x55, 0x00, 0xF5, 0x01, // ŕõ (U+0155 U+00F5)
  0x01, 0x55, 0x00, 0xF6, 0x01, // ŕö (U+0155 U+00F6)
  0x01, 0x55, 0x00, 0xF8, 0x01, // ŕø (U+0155 U+00F8)
  0x01, 0x55, 0x01, 0x01, 0x01, // ŕā (U+0155 U+0101)
  0x01, 0x55, 0x01, 0x03, 0x01, // ŕă (U+0155 U+0103)
  0x01, 0x55, 0x01, 0x05, 0x01, // ŕą (U+0155 U+0105)
  0x01, 0x55, 0x01, 0x07, 0x01, // ŕć (U+0155 U+0107)
  0x01, 0x55, 0x01, 0x09, 0x01, // ŕĉ (U+0155 U+0109)
  0x01, 0x55, 0x01, 0x0B, 0x01, // ŕċ (U+0155 U+010B)
  0x01, 0x55, 0x01, 0x0D, 0x01, // ŕč (U+0155 U+010D)
  0x01, 0x55, 0x01, 0x0F, 0x01, // ŕď (U+0155 U+010F)
  0x01, 0x55, 0x01, 0x11, 0x01, // ŕđ (U+0155 U+0111)
  0x01, 0x55, 0x01, 0x13, 0x01, // ŕē (U+0155 U+0113)
  0x01, 0x55, 0x01, 0x15, 0x01, // ŕĕ (U+0155 U+0115)
  0x01, 0x55, 0x01, 0x17, 0x01, // ŕė (U+0155 U+0117)
  0x01, 0x55, 0x01, 0x19, 0x01, // ŕę (U+0155 U+0119)
  0x01, 0x55, 0x01, 0x1B, 0x01, // ŕě (U+0155 U+011B)
  0x01, 0x55, 0x01, 0x4D, 0x01, // ŕō (U+0155 U+014D)
  0x01, 0x55, 0x01, 0x4F, 0x01, // ŕŏ (U+0155 U+014F)
  0x01, 0x55, 0x01, 0x51, 0x01, // ŕő (U+0155 U+0151)
  0x01, 0x55, 0x01, 0x53, 0x01, // ŕœ (U+0155 U+0153)
  0x01, 0x55, 0x20, 0x1A, 0x03, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x03, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x03, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x03, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x03, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x00, 0x61, 0x01, // ŗa (U+0157 U+0061)
  0x01, 0x57, 0x00, 0x63, 0x01, // ŗc (U+0157 U+0063)
  0x01, 0x57, 0x00, 0x64, 0x01, // ŗd (U+0157 U+0064)
  0x01, 0x57, 0x00, 0x65, 0x01, // ŗe (U+0157 U+0065)
  0x01, 0x57, 0x00, 0x6F, 0x01, // ŗo (U+0157 U+006F)
  0x01, 0x57, 0x00, 0x71, 0x01, // ŗq (U+0157 U+0071)
  0x01, 0x57, 0x00, 0xE0, 0x01, // ŗà (U+0157 U+00E0)
  0x01, 0x57, 0x00, 0xE1, 0x01, // ŗá (U+0157 U+00E1)
  0x01, 0x57, 0x00, 0xE2, 0x01, // ŗâ (U+0157 U+00E2)
  0x01, 0x57, 0x00, 0xE3, 0x01, // ŗã (U+0157 U+00E3)
  0x01, 0x57, 0x00, 0xE4, 0x01, // ŗä (U+0157 U+00E4)
  0x01, 0x57, 0x00, 0xE5, 0x01, // ŗå (U+0157 U+00E5)
  0x01, 0x57, 0x00, 0xE6, 0x01, // ŗæ (U+0157 U+00E6)
  0x01, 0x57, 0x00, 0xE7, 0x01, // ŗç (U+0157 U+00E7)
  0x01, 0x57, 0x00, 0xE8, 0x01, // ŗè (U+0157 U+00E8)
  0x01, 0x57, 0x00, 0xE9, 0x01, // ŗé (U+0157 U+00E9)
  0x01, 0x57, 0x00, 0xEA, 0x01, // ŗê (U+0157 U+00EA)
  0x01, 0x57, 0x00, 0xEB, 0x01, // ŗë (U+0157 U+00EB)
  0x01, 0x57, 0x00, 0xF2, 0x01, // ŗò (U+0157 U+00F2)
  0x01, 0x57, 0x00, 0xF3, 0x01, // ŗó (U+0157 U+00F3)
  0x01, 0x57, 0x00, 0xF4, 0x01, // ŗô (U+0157 U+00F4)
  0x01, 0x57, 0x00, 0xF5, 0x01, // ŗõ (U+0157 U+00F5)
  0x01, 0x57, 0x00, 0xF6, 0x01, // ŗö (U+0157 U+00F6)
  0x01, 0x57, 0x00, 0xF8, 0x01, // ŗø (U+0157 U+00F8)
  0x01, 0x57, 0x01, 0x01, 0x01, // ŗā (U+0157 U+0101)
  0x01, 0x57, 0x01, 0x03, 0x01, // ŗă (U+0157 U+0103)
  0x01, 0x57, 0x01, 0x05, 0x01, // ŗą (U+0157 U+0105)
  0x01, 0x57, 0x01, 0x07, 0x01, // ŗć (U+0157 U+0107)
  0x01, 0x57, 0x01, 0x09, 0x01, // ŗĉ (U+0157 U+0109)
  0x01, 0x57, 0x01, 0x0B, 0x01, // ŗċ (U+0157 U+010B)
  0x01, 0x57, 0x01, 0x0D, 0x01, // ŗč (U+0157 U+010D)
  0x01, 0x57, 0x01, 0x0F, 0x01, // ŗď (U+0157 U+010F)
  0x01, 0x57, 0x01, 0x11, 0x01, // ŗđ (U+0157 U+0111)
  0x01, 0x57, 0x01, 0x13, 0x01, // ŗē (U+0157 U+0113)
  0x01, 0x57, 0x01, 0x15, 0x01, // ŗĕ (U+0157 U+0115)
  0x01, 0x57, 0x01, 0x17, 0x01, // ŗė (U+0157 U+0117)
  0x01, 0x57, 0x01, 0x19, 0x01, // ŗę (U+0157 U+0119)
  0x01, 0x57, 0x01, 0x1B, 0x01, // ŗě (U+0157 U+011B)
  0x01, 0x57, 0x01, 0x4D, 0x01, // ŗō (U+0157 U+014D)
  0x01, 0x57, 0x01, 0x4F, 0x01, // ŗŏ (U+0157 U+014F)
  0x01, 0x57, 0x01, 0x51, 0x01, // ŗő (U+0157 U+0151)
  0x01, 0x57, 0x01, 0x53, 0x01, // ŗœ (U+0157 U+0153)
  0x01, 0x57, 0x20, 0x1A, 0x03, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x03, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x03, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x03, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x03, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x00, 0x61, 0x01, // řa (U+0159 U+0061)
  0x01, 0x59, 0x00, 0x63, 0x01, // řc (U+0159 U+0063)
  0x01, 0x59, 0x00, 0x64, 0x01, // řd (U+0159 U+0064)
  0x01, 0x59, 0x00, 0x65, 0x01, // ře (U+0159 U+0065)
  0x01, 0x59, 0x00, 0x6F, 0x01, // řo (U+0159 U+006F)
  0x01, 0x59, 0x00, 0x71, 0x01, // řq (U+0159 U+0071)
  0x01, 0x59, 0x00, 0xE0, 0x01, // řà (U+0159 U+00E0)
  0x01, 0x59, 0x00, 0xE1, 0x01, // řá (U+0159 U+00E1)
  0x01, 0x59, 0x00, 0xE2, 0x01, // řâ (U+0159 U+00E2)
  0x01, 0x59, 0x00, 0xE3, 0x01, // řã (U+0159 U+00E3)
  0x01, 0x59, 0x00, 0xE4, 0x01, // řä (U+0159 U+00E4)
  0x01, 0x59, 0x00, 0xE5, 0x01, // řå (U+0159 U+00E5)
  0x01, 0x59, 0x00, 0xE6, 0x01, // řæ (U+0159 U+00E6)
  0x01, 0x59, 0x00, 0xE7, 0x01, // řç (U+0159 U+00E7)
  0x01, 0x59, 0x00, 0xE8, 0x01, // řè (U+0159 U+00E8)
  0x01, 0x59, 0x00, 0xE9, 0x01, // řé (U+0159 U+00E9)
  0x01, 0x59, 0x00, 0xEA, 0x01, // řê (U+0159 U+00EA)
  0x01, 0x59, 0x00, 0xEB, 0x01, // řë (U+0159 U+00EB)
  0x01, 0x59, 0x00, 0xF2, 0x01, // řò (U+0159 U+00F2)
  0x01, 0x59, 0x00, 0xF3, 0x01, // řó (U+0159 U+00F3)
  0x01, 0x59, 0x00, 0xF4, 0x01, // řô (U+0159 U+00F4)
  0x01, 0x59, 0x00, 0xF5, 0x01, // řõ (U+0159 U+00F5)
  0x01, 0x59, 0x00, 0xF6, 0x01, // řö (U+0159 U+00F6)
  0x01, 0x59, 0x00, 0xF8, 0x01, // řø (U+0159 U+00F8)
  0x01, 0x59, 0x01, 0x01, 0x01, // řā (U+0159 U+0101)
  0x01, 0x59, 0x01, 0x03, 0x01, // řă (U+0159 U+0103)
  0x01, 0x59, 0x01, 0x05, 0x01, // řą (U+0159 U+0105)
  0x01, 0x59, 0x01, 0x07, 0x01, // řć (U+0159 U+0107)
  0x01, 0x59, 0x01, 0x09, 0x01, // řĉ (U+0159 U+0109)
  0x01, 0x59, 0x01, 0x0B, 0x01, // řċ (U+0159 U+010B)
  0x01, 0x59, 0x01, 0x0D, 0x01, // řč (U+0159 U+010D)
  0x01, 0x59, 0x01, 0x0F, 0x01, // řď (U+0159 U+010F)
  0x01, 0x59, 0x01, 0x11, 0x01, // řđ (U+0159 U+0111)
  0x01, 0x59, 0x01, 0x13, 0x01, // řē (U+0159 U+0113)
  0x01, 0x59, 0x01, 0x15, 0x01, // řĕ (U+0159 U+0115)
  0x01, 0x59, 0x01, 0x17, 0x01, // řė (U+0159 U+0117)
  0x01, 0x59, 0x01, 0x19, 0x01, // řę (U+0159 U+0119)
  0x01, 0x59, 0x01, 0x1B, 0x01, // řě (U+0159 U+011B)
  0x01, 0x59, 0x01, 0x4D, 0x01, // řō (U+0159 U+014D)
  0x01, 0x59, 0x01, 0x4F, 0x01, // řŏ (U+0159 U+014F)
  0x01, 0x59, 0x01, 0x51, 0x01, // řő (U+0159 U+0151)
  0x01, 0x59, 0x01, 0x53, 0x01, // řœ (U+0159 U+0153)
  0x01, 0x59, 0x20, 0x1A, 0x03, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x03, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x03, // ř… (U+0159 U+2026)
  0x01, 0x62, 0x00, 0x26, 0x01, // Ţ& (U+0162 U+0026)
  0x01, 0x62, 0x00, 0x2C, 0x03, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2D, 0x02, // Ţ- (U+0162 U+002D)
  0x01, 0x62, 0x00, 0x2E, 0x03, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0x41, 0x02, // ŢA (U+0162 U+0041)
  0x01, 0x62, 0x00, 0x43, 0x01, // ŢC (U+0162 U+0043)
  0x01, 0x62, 0x00, 0x47, 0x01, // ŢG (U+0162 U+0047)
  0x01, 0x62, 0x00, 0x4F, 0x01, // ŢO (U+0162 U+004F)
  0x01, 0x62, 0x00, 0x51, 0x01, // ŢQ (U+0162 U+0051)
  0x01, 0x62, 0x00, 0x61, 0x03, // Ţa (U+0162 U+0061)
  0x01, 0x62, 0x00, 0x63, 0x03, // Ţc (U+0162 U+0063)
  0x01, 0x62, 0x00, 0x64, 0x03, // Ţd (U+0162 U+0064)
  0x01, 0x62, 0x00, 0x65, 0x03, // Ţe (U+0162 U+0065)
  0x01, 0x62, 0x00, 0x67, 0x03, // Ţg (U+0162 U+0067)
  0x01, 0x62, 0x00, 0x6D, 0x02, // Ţm (U+0162 U+006D)
  0x01, 0x62, 0x00, 0x6E, 0x02, // Ţn (U+0162 U+006E)
  0x01, 0x62, 0x00, 0x6F, 0x03, // Ţo (U+0162 U+006F)
  0x01, 0x62, 0x00, 0x70, 0x02, // Ţp (U+0162 U+0070)
  0x01, 0x62, 0x00, 0x71, 0x03, // Ţq (U+0162 U+0071)
  0x01, 0x62, 0x00, 0x72, 0x02, // Ţr (U+0162 U+0072)
  0x01, 0x62, 0x00, 0x73, 0x03, // Ţs (U+0162 U+0073)
  0x01, 0x62, 0x00, 0x75, 0x02, // Ţu (U+0162 U+0075)
  0x01, 0x62, 0x00, 0x76, 0x01, // Ţv (U+0162 U+0076)
  0x01, 0x62, 0x00, 0x77, 0x01, // Ţw (U+0162 U+0077)
  0x01, 0x62, 0x00, 0x78, 0x01, // Ţx (U+0162 U+0078)
  0x01, 0x62, 0x00, 0x79, 0x01, // Ţy (U+0162 U+0079)
  0x01, 0x62, 0x00, 0x7A, 0x02, // Ţz (U+0162 U+007A)
  0x01, 0x62, 0x00, 0xAB, 0x03, // Ţ« (U+0162 U+00AB)
  0x01, 0x62, 0x00, 0xBB, 0x01, // Ţ» (U+0162 U+00BB)
  0x01, 0x62, 0x00, 0xC0, 0x02, // ŢÀ (U+0162 U+00C0)
  0x01, 0x62, 0x00, 0xC1, 0x02, // ŢÁ (U+0162 U+00C1)
  0x01, 0x62, 0x00, 0xC2, 0x02, // ŢÂ (U+0162 U+00C2)
  0x01, 0x62, 0x00, 0xC3, 0x02, // ŢÃ (U+0162 U+00C3)
  0x01, 0x62, 0x00, 0xC4, 0x02, // ŢÄ (U+0162 U+00C4)
  0x01, 0x62, 0x00, 0xC5, 0x02, // ŢÅ (U+0162 U+00C5)
  0x01, 0x62, 0x00, 0xC7, 0x01, // ŢÇ (U+0162 U+00C7)
  0x01, 0x62, 0x00, 0xD2, 0x01, // ŢÒ (U+0162 U+00D2)
  0x01, 0x62, 0x00, 0xD3, 0x01, // ŢÓ (U+0162 U+00D3)
  0x01, 0x62, 0x00, 0xD4, 0x01, // ŢÔ (U+0162 U+00D4)
  0x01, 0x62, 0x00, 0xD5, 0x01, // ŢÕ (U+0162 U+00D5)
  0x01, 0x62, 0x00, 0xD6, 0x01, // ŢÖ (U+0162 U+00D6)
  0x01, 0x62, 0x00, 0xD8, 0x01, // ŢØ (U+0162 U+00D8)
  0x01, 0x62, 0x00, 0xE0, 0x03, // Ţà (U+0162 U+00E0)
  0x01, 0x62, 0x00, 0xE1, 0x03, // Ţá (U+0162 U+00E1)
  0x01, 0x62, 0x00, 0xE2, 0x03, // Ţâ (U+0162 U+00E2)
  0x01, 0x62, 0x00, 0xE3, 0x03, // Ţã (U+0162 U+00E3)
  0x01, 0x62, 0x00, 0xE4, 0x03, // Ţä (U+0162 U+00E4)
  0x01, 0x62, 0x00, 0xE5, 0x03, // Ţå (U+0162 U+00E5)
  0x01, 0x62, 0x00, 0xE6, 0x03, // Ţæ (U+0162 U+00E6)
  0x01, 0x62, 0x00, 0xE7, 0x03, // Ţç (U+0162 U+00E7)
  0x01, 0x62, 0x00, 0xE8, 0x03, // Ţè (U+0162 U+00E8)
  0x01, 0x62, 0x00, 0xE9, 0x03, // Ţé (U+0162 U+00E9)
  0x01, 0x62, 0x00, 0xEA, 0x03, // Ţê (U+0162 U+00EA)
  0x01, 0x62, 0x00, 0xEB, 0x03, // Ţë (U+0162 U+00EB)
  0x01, 0x62, 0x00, 0xF2, 0x03, // Ţò (U+0162 U+00F2)
  0x01, 0x62, 0x00, 0xF3, 0x03, // Ţó (U+0162 U+00F3)
  0x01, 0x62, 0x00, 0xF4, 0x03, // Ţô (U+0162 U+00F4)
  0x01, 0x62, 0x00, 0xF5, 0x03, // Ţõ (U+0162 U+00F5)
  0x01, 0x62, 0x00, 0xF6, 0x03, // Ţö (U+0162 U+00F6)
  0x01, 0x62, 0x00, 0xF8, 0x03, // Ţø (U+0162 U+00F8)
  0x01, 0x62, 0x00, 0xF9, 0x02, // Ţù (U+0162 U+00F9)
  0x01, 0x62, 0x00, 0xFA, 0x02, // Ţú (U+0162 U+00FA)
  0x01, 0x62, 0x00, 0xFB, 0x02, // Ţû (U+0162 U+00FB)
  0x01, 0x62, 0x00, 0xFC, 0x02, // Ţü (U+0162 U+00FC)
  0x01, 0x62, 0x00, 0xFD, 0x01, // Ţý (U+0162 U+00FD)
  0x01, 0x62, 0x00, 0xFF, 0x01, // Ţÿ (U+0162 U+00FF)
  0x01, 0x62, 0x01, 0x00, 0x02, // ŢĀ (U+0162 U+0100)
  0x01, 0x62, 0x01, 0x01, 0x03, // Ţā (U+0162 U+0101)
  0x01, 0x62, 0x01, 0x02, 0x02, // ŢĂ (U+0162 U+0102)
  0x01, 0x62, 0x01, 0x03, 0x03, // Ţă (U+0162 U+0103)
  0x01, 0x62, 0x01, 0x04, 0x02, // ŢĄ (U+0162 U+0104)
  0x01, 0x62, 0x01, 0x05, 0x03, // Ţą (U+0162 U+0105)
  0x01, 0x62, 0x01, 0x06, 0x01, // ŢĆ (U+0162 U+0106)
  0x01, 0x62, 0x01, 0x07, 0x03, // Ţć (U+0162 U+0107)
  0x01, 0x62, 0x01, 0x08, 0x01, // ŢĈ (U+0162 U+0108)
  0x01, 0x62, 0x01, 0x09, 0x03, // Ţĉ (U+0162 U+0109)
  0x01, 0x62, 0x01, 0x0A, 0x01, // ŢĊ (U+0162 U+010A)
  0x01, 0x62, 0x01, 0x0B, 0x03, // Ţċ (U+0162 U+010B)
  0x01, 0x62, 0x01, 0x0C, 0x01, // ŢČ (U+0162 U+010C)
  0x01, 0x62, 0x01, 0x0D, 0x03, // Ţč (U+0162 U+010D)
  0x01, 0x62, 0x01, 0x0F, 0x03, // Ţď (U+0162 U+010F)
  0x01, 0x62, 0x01, 0x11, 0x03, // Ţđ (U+0162 U+0111)
  0x01, 0x62, 0x01, 0x13, 0x03, // Ţē (U+0162 U+0113)
  0x01, 0x62, 0x01, 0x15, 0x03, // Ţĕ (U+0162 U+0115)
  0x01, 0x62, 0x01, 0x17, 0x03, // Ţė (U+0162 U+0117)
  0x01, 0x62, 0x01, 0x19, 0x03, // Ţę (U+0162 U+0119)
  0x01, 0x62, 0x01, 0x1B, 0x03, // Ţě (U+0162 U+011B)
  0x01, 0x62, 0x01, 0x1C, 0x01, // ŢĜ (U+0162 U+011C)
  0x01, 0x62, 0x01, 0x1D, 0x03, // Ţĝ (U+0162 U+011D)
  0x01, 0x62, 0x01, 0x1E, 0x01, // ŢĞ (U+0162 U+011E)
  0x01, 0x62, 0x01, 0x1F, 0x03, // Ţğ (U+0162 U+011F)
  0x01, 0x62, 0x01, 0x20, 0x01, // ŢĠ (U+0162 U+0120)
  0x01, 0x62, 0x01, 0x21, 0x03, // Ţġ (U+0162 U+0121)
  0x01, 0x62, 0x01, 0x22, 0x01, // ŢĢ (U+0162 U+0122)
  0x01, 0x62, 0x01, 0x23, 0x03, // Ţģ (U+0162 U+0123)
  0x01, 0x62, 0x01, 0x38, 0x02, // Ţĸ (U+0162 U+0138)
  0x01, 0x62, 0x01, 0x44, 0x02, // Ţń (U+0162 U+0144)
  0x01, 0x62, 0x01, 0x46, 0x02, // Ţņ (U+0162 U+0146)
  0x01, 0x62, 0x01, 0x4B, 0x02, // Ţŋ (U+0162 U+014B)
  0x01, 0x62, 0x01, 0x4C, 0x01, // ŢŌ (U+0162 U+014C)
  0x01, 0x62, 0x01, 0x4D, 0x03, // Ţō (U+0162 U+014D)
  0x01, 0x62, 0x01, 0x4E, 0x01, // ŢŎ (U+0162 U+014E)
  0x01, 0x62, 0x01, 0x4F, 0x03, // Ţŏ (U+0162 U+014F)
  0x01, 0x62, 0x01, 0x50, 0x01, // ŢŐ (U+0162 U+0150)
  0x01, 0x62, 0x01, 0x51, 0x03, // Ţő (U+0162 U+0151)
  0x01, 0x62, 0x01, 0x52, 0x01, // ŢŒ (U+0162 U+0152)
  0x01, 0x62, 0x01, 0x53, 0x03, // Ţœ (U+0162 U+0153)
  0x01, 0x62, 0x01, 0x55, 0x02, // Ţŕ (U+0162 U+0155)
  0x01, 0x62, 0x01, 0x57, 0x02, // Ţŗ (U+0162 U+0157)
  0x01, 0x62, 0x01, 0x5B, 0x03, // Ţś (U+0162 U+015B)
  0x01, 0x62, 0x01, 0x5F, 0x03, // Ţş (U+0162 U+015F)
  0x01, 0x62, 0x01, 0x69, 0x02, // Ţũ (U+0162 U+0169)
  0x01, 0x62, 0x01, 0x6B, 0x02, // Ţū (U+0162 U+016B)
  0x01, 0x62, 0x01, 0x6D, 0x02, // Ţŭ (U+0162 U+016D)
  0x01, 0x62, 0x01, 0x6F, 0x02, // Ţů (U+0162 U+016F)
  0x01, 0x62, 0x01, 0x71, 0x02, // Ţű (U+0162 U+0171)
  0x01, 0x62, 0x01, 0x73, 0x02, // Ţų (U+0162 U+0173)
  0x01, 0x62, 0x01, 0x75, 0x01, // Ţŵ (U+0162 U+0175)
  0x01, 0x62, 0x01, 0x77, 0x01, // Ţŷ (U+0162 U+0177)
  0x01, 0x62, 0x01, 0x7A, 0x02, // Ţź (U+0162 U+017A)
  0x01, 0x62, 0x01, 0x7C, 0x02, // Ţż (U+0162 U+017C)
  0x01, 0x62, 0x01, 0x7E, 0x02, // Ţž (U+0162 U+017E)
  0x01, 0x62, 0x20, 0x13, 0x02, // Ţ– (U+0162 U+2013)
  0x01, 0x62, 0x20, 0x14, 0x02, // Ţ— (U+0162 U+2014)
  0x01, 0x62, 0x20, 0x1A, 0x03, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x03, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x03, // Ţ… (U+0162 U+2026)
  0x01, 0x62, 0x20, 0x39, 0x03, // Ţ‹ (U+0162 U+2039)
  0x01, 0x62, 0x20, 0x3A, 0x01, // Ţ› (U+0162 U+203A)
  0x01, 0x64, 0x00, 0x26, 0x01, // Ť& (U+0164 U+0026)
  0x01, 0x64, 0x00, 0x2C, 0x03, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2D, 0x02, // Ť- (U+0164 U+002D)
  0x01, 0x64, 0x00, 0x2E, 0x03, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0x41, 0x02, // ŤA (U+0164 U+0041)
  0x01, 0x64, 0x00, 0x43, 0x01, // ŤC (U+0164 U+0043)
  0x01, 0x64, 0x00, 0x47, 0x01, // ŤG (U+0164 U+0047)
  0x01, 0x64, 0x00, 0x4F, 0x01, // ŤO (U+0164 U+004F)
  0x01, 0x64, 0x00, 0x51, 0x01, // ŤQ (U+0164 U+0051)
  0x01, 0x64, 0x00, 0x61, 0x03, // Ťa (U+0164 U+0061)
  0x01, 0x64, 0x00, 0x63, 0x03, // Ťc (U+0164 U+0063)
  0x01, 0x64, 0x00, 0x64, 0x03, // Ťd (U+0164 U+0064)
  0x01, 0x64, 0x00, 0x65, 0x03, // Ťe (U+0164 U+0065)
  0x01, 0x64, 0x00, 0x67, 0x03, // Ťg (U+0164 U+0067)
  0x01, 0x64, 0x00, 0x6D, 0x02, // Ťm (U+0164 U+006D)
  0x01, 0x64, 0x00, 0x6E, 0x02, // Ťn (U+0164 U+006E)
  0x01, 0x64, 0x00, 0x6F, 0x03, // Ťo (U+0164 U+006F)
  0x01, 0x64, 0x00, 0x70, 0x02, // Ťp (U+0164 U+0070)
  0x01, 0x64, 0x00, 0x71, 0x03, // Ťq (U+0164 U+0071)
  0x01, 0x64, 0x00, 0x72, 0x02, // Ťr (U+0164 U+0072)
  0x01, 0x64, 0x00, 0x73, 0x03, // Ťs (U+0164 U+0073)
  0x01, 0x64, 0x00, 0x75, 0x02, // Ťu (U+0164 U+0075)
  0x01, 0x64, 0x00, 0x76, 0x01, // Ťv (U+0164 U+0076)
  0x01, 0x64, 0x00, 0x77, 0x01, // Ťw (U+0164 U+0077)
  0x01, 0x64, 0x00, 0x78, 0x01, // Ťx (U+0164 U+0078)
  0x01, 0x64, 0x00, 0x79, 0x01, // Ťy (U+0164 U+0079)
  0x01, 0x64, 0x00, 0x7A, 0x02, // Ťz (U+0164 U+007A)
  0x01, 0x64, 0x00, 0xAB, 0x03, // Ť« (U+0164 U+00AB)
  0x01, 0x64, 0x00, 0xBB, 0x01, // Ť» (U+0164 U+00BB)
  0x01, 0x64, 0x00, 0xC0, 0x02, // ŤÀ (U+0164 U+00C0)
  0x01, 0x64, 0x00, 0xC1, 0x02, // ŤÁ (U+0164 U+00C1)
  0x01, 0x64, 0x00, 0xC2, 0x02, // ŤÂ (U+0164 U+00C2)
  0x01, 0x64, 0x00, 0xC3, 0x02, // ŤÃ (U+0164 U+00C3)
  0x01, 0x64, 0x00, 0xC4, 0x02, // ŤÄ (U+0164 U+00C4)
  0x01, 0x64, 0x00, 0xC5, 0x02, // ŤÅ (U+0164 U+00C5)
  0x01, 0x64, 0x00, 0xC7, 0x01, // ŤÇ (U+0164 U+00C7)
  0x01, 0x64, 0x00, 0xD2, 0x01, // ŤÒ (U+0164 U+00D2)
  0x01, 0x64, 0x00, 0xD3, 0x01, // ŤÓ (U+0164 U+00D3)
  0x01, 0x64, 0x00, 0xD4, 0x01, // ŤÔ (U+0164 U+00D4)
  0x01, 0x64, 0x00, 0xD5, 0x01, // ŤÕ (U+0164 U+00D5)
  0x01, 0x64, 0x00, 0xD6, 0x01, // ŤÖ (U+0164 U+00D6)
  0x01, 0x64, 0x00, 0xD8, 0x01, // ŤØ (U+0164 U+00D8)
  0x01, 0x64, 0x00, 0xE0, 0x03, // Ťà (U+0164 U+00E0)
  0x01, 0x64, 0x00, 0xE1, 0x03, // Ťá (U+0164 U+00E1)
  0x01, 0x64, 0x00, 0xE2, 0x03, // Ťâ (U+0164 U+00E2)
  0x01, 0x64, 0x00, 0xE3, 0x03, // Ťã (U+0164 U+00E3)
  0x01, 0x64, 0x00, 0xE4, 0x03, // Ťä (U+0164 U+00E4)
  0x01, 0x64, 0x00, 0xE5, 0x03, // Ťå (U+0164 U+00E5)
  0x01, 0x64, 0x00, 0xE6, 0x03, // Ťæ (U+0164 U+00E6)
  0x01, 0x64, 0x00, 0xE7, 0x03, // Ťç (U+0164 U+00E7)
  0x01, 0x64, 0x00, 0xE8, 0x03, // Ťè (U+0164 U+00E8)
  0x01, 0x64, 0x00, 0xE9, 0x03, // Ťé (U+0164 U+00E9)
  0x01, 0x64, 0x00, 0xEA, 0x03, // Ťê (U+0164 U+00EA)
  0x01, 0x64, 0x00, 0xEB, 0x03, // Ťë (U+0164 U+00EB)
  0x01, 0x64, 0x00, 0xF2, 0x03, // Ťò (U+0164 U+00F2)
  0x01, 0x64, 0x00, 0xF3, 0x03, // Ťó (U+0164 U+00F3)
  0x01, 0x64, 0x00, 0xF4, 0x03, // Ťô (U+0164 U+00F4)
  0x01, 0x64, 0x00, 0xF5, 0x03, // Ťõ (U+0164 U+00F5)
  0x01, 0x64, 0x00, 0xF6, 0x03, // Ťö (U+0164 U+00F6)
  0x01, 0x64, 0x00, 0xF8, 0x03, // Ťø (U+0164 U+00F8)
  0x01, 0x64, 0x00, 0xF9, 0x02, // Ťù (U+0164 U+00F9)
  0x01, 0x64, 0x00, 0xFA, 0x02, // Ťú (U+0164 U+00FA)
  0x01, 0x64, 0x00, 0xFB, 0x02, // Ťû (U+0164 U+00FB)
  0x01, 0x64, 0x00, 0xFC, 0x02, // Ťü (U+0164 U+00FC)
  0x01, 0x64, 0x00, 0xFD, 0x01, // Ťý (U+0164 U+00FD)
  0x01, 0x64, 0x00, 0xFF, 0x01, // Ťÿ (U+0164 U+00FF)
  0x01, 0x64, 0x01, 0x00, 0x02, // ŤĀ (U+0164 U+0100)
  0x01, 0x64, 0x01, 0x01, 0x03, // Ťā (U+0164 U+0101)
  0x01, 0x64, 0x01, 0x02, 0x02, // ŤĂ (U+0164 U+0102)
  0x01, 0x64, 0x01, 0x03, 0x03, // Ťă (U+0164 U+0103)
  0x01, 0x64, 0x01, 0x04, 0x02, // ŤĄ (U+0164 U+0104)
  0x01, 0x64, 0x01, 0x05, 0x03, // Ťą (U+0164 U+0105)
  0x01, 0x64, 0x01, 0x06, 0x01, // ŤĆ (U+0164 U+0106)
  0x01, 0x64, 0x01, 0x07, 0x03, // Ťć (U+0164 U+0107)
  0x01, 0x64, 0x01, 0x08, 0x01, // ŤĈ (U+0164 U+0108)
  0x01, 0x64, 0x01, 0x09, 0x03, // Ťĉ (U+0164 U+0109)
  0x01, 0x64, 0x01, 0x0A, 0x01, // ŤĊ (U+0164 U+010A)
  0x01, 0x64, 0x01, 0x0B, 0x03, // Ťċ (U+0164 U+010B)
  0x01, 0x64, 0x01, 0x0C, 0x01, // ŤČ (U+0164 U+010C)
  0x01, 0x64, 0x01, 0x0D, 0x03, // Ťč (U+0164 U+010D)
  0x01, 0x64, 0x01, 0x0F, 0x03, // Ťď (U+0164 U+010F)
  0x01, 0x64, 0x01, 0x11, 0x03, // Ťđ (U+0164 U+0111)
  0x01, 0x64, 0x01, 0x13, 0x03, // Ťē (U+0164 U+0113)
  0x01, 0x64, 0x01, 0x15, 0x03, // Ťĕ (U+0164 U+0115)
  0x01, 0x64, 0x01, 0x17, 0x03, // Ťė (U+0164 U+0117)
  0x01, 0x64, 0x01, 0x19, 0x03, // Ťę (U+0164 U+0119)
  0x01, 0x64, 0x01, 0x1B, 0x03, // Ťě (U+0164 U+011B)
  0x01, 0x64, 0x01, 0x1C, 0x01, // ŤĜ (U+0164 U+011C)
  0x01, 0x64, 0x01, 0x1D, 0x03, // Ťĝ (U+0164 U+011D)
  0x01, 0x64, 0x01, 0x1E, 0x01, // ŤĞ (U+0164 U+011E)
  0x01, 0x64, 0x01, 0x1F, 0x03, // Ťğ (U+0164 U+011F)
  0x01, 0x64, 0x01, 0x20, 0x01, // ŤĠ (U+0164 U+0120)
  0x01, 0x64, 0x01, 0x21, 0x03, // Ťġ (U+0164 U+0121)
  0x01, 0x64, 0x01, 0x22, 0x01, // ŤĢ (U+0164 U+0122)
  0x01, 0x64, 0x01, 0x23, 0x03, // Ťģ (U+0164 U+0123)
  0x01, 0x64, 0x01, 0x38, 0x02, // Ťĸ (U+0164 U+0138)
  0x01, 0x64, 0x01, 0x44, 0x02, // Ťń (U+0164 U+0144)
  0x01, 0x64, 0x01, 0x46, 0x02, // Ťņ (U+0164 U+0146)
  0x01, 0x64, 0x01, 0x4B, 0x02, // Ťŋ (U+0164 U+014B)
  0x01, 0x64, 0x01, 0x4C, 0x01, // ŤŌ (U+0164 U+014C)
  0x01, 0x64, 0x01, 0x4D, 0x03, // Ťō (U+0164 U+014D)
  0x01, 0x64, 0x01, 0x4E, 0x01, // ŤŎ (U+0164 U+014E)
  0x01, 0x64, 0x01, 0x4F, 0x03, // Ťŏ (U+0164 U+014F)
  0x01, 0x64, 0x01, 0x50, 0x01, // ŤŐ (U+0164 U+0150)
  0x01, 0x64, 0x01, 0x51, 0x03, // Ťő (U+0164 U+0151)
  0x01, 0x64, 0x01, 0x52, 0x01, // ŤŒ (U+0164 U+0152)
  0x01, 0x64, 0x01, 0x53, 0x03, // Ťœ (U+0164 U+0153)
  0x01, 0x64, 0x01, 0x55, 0x02, // Ťŕ (U+0164 U+0155)
  0x01, 0x64, 0x01, 0x57, 0x02, // Ťŗ (U+0164 U+0157)
  0x01, 0x64, 0x01, 0x5B, 0x03, // Ťś (U+0164 U+015B)
  0x01, 0x64, 0x01, 0x5F, 0x03, // Ťş (U+0164 U+015F)
  0x01, 0x64, 0x01, 0x69, 0x02, // Ťũ (U+0164 U+0169)
  0x01, 0x64, 0x01, 0x6B, 0x02, // Ťū (U+0164 U+016B)
  0x01, 0x64, 0x01, 0x6D, 0x02, // Ťŭ (U+0164 U+016D)
  0x01, 0x64, 0x01, 0x6F, 0x02, // Ťů (U+0164 U+016F)
  0x01, 0x64, 0x01, 0x71, 0x02, // Ťű (U+0164 U+0171)
  0x01, 0x64, 0x01, 0x73, 0x02, // Ťų (U+0164 U+0173)
  0x01, 0x64, 0x01, 0x75, 0x01, // Ťŵ (U+0164 U+0175)
  0x01, 0x64, 0x01, 0x77, 0x01, // Ťŷ (U+0164 U+0177)
  0x01, 0x64, 0x01, 0x7A, 0x02, // Ťź (U+0164 U+017A)
  0x01, 0x64, 0x01, 0x7C, 0x02, // Ťż (U+0164 U+017C)
  0x01, 0x64, 0x01, 0x7E, 0x02, // Ťž (U+0164 U+017E)
  0x01, 0x64, 0x20, 0x13, 0x02, // Ť– (U+0164 U+2013)
  0x01, 0x64, 0x20, 0x14, 0x02, // Ť— (U+0164 U+2014)
  0x01, 0x64, 0x20, 0x1A, 0x03, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x03, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x03, // Ť… (U+0164 U+2026)
  0x01, 0x64, 0x20, 0x39, 0x03, // Ť‹ (U+0164 U+2039)
  0x01, 0x64, 0x20, 0x3A, 0x01, // Ť› (U+0164 U+203A)
  0x01, 0x66, 0x00, 0x26, 0x01, // Ŧ& (U+0166 U+0026)
  0x01, 0x66, 0x00, 0x2C, 0x03, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2D, 0x02, // Ŧ- (U+0166 U+002D)
  0x01, 0x66, 0x00, 0x2E, 0x03, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0x41, 0x02, // ŦA (U+0166 U+0041)
  0x01, 0x66, 0x00, 0x43, 0x01, // ŦC (U+0166 U+0043)
  0x01, 0x66, 0x00, 0x47, 0x01, // ŦG (U+0166 U+0047)
  0x01, 0x66, 0x00, 0x4F, 0x01, // ŦO (U+0166 U+004F)
  0x01, 0x66, 0x00, 0x51, 0x01, // ŦQ (U+0166 U+0051)
  0x01, 0x66, 0x00, 0x61, 0x03, // Ŧa (U+0166 U+0061)
  0x01, 0x66, 0x00, 0x63, 0x03, // Ŧc (U+0166 U+0063)
  0x01, 0x66, 0x00, 0x64, 0x03, // Ŧd (U+0166 U+0064)
  0x01, 0x66, 0x00, 0x65, 0x03, // Ŧe (U+0166 U+0065)
  0x01, 0x66, 0x00, 0x67, 0x03, // Ŧg (U+0166 U+0067)
  0x01, 0x66, 0x00, 0x6D, 0x02, // Ŧm (U+0166 U+006D)
  0x01, 0x66, 0x00, 0x6E, 0x02, // Ŧn (U+0166 U+006E)
  0x01, 0x66, 0x00, 0x6F, 0x03, // Ŧo (U+0166 U+006F)
  0x01, 0x66, 0x00, 0x70, 0x02, // Ŧp (U+0166 U+0070)
  0x01, 0x66, 0x00, 0x71, 0x03, // Ŧq (U+0166 U+0071)
  0x01, 0x66, 0x00, 0x72, 0x02, // Ŧr (U+0166 U+0072)
  0x01, 0x66, 0x00, 0x73, 0x03, // Ŧs (U+0166 U+0073)
  0x01, 0x66, 0x00, 0x75, 0x02, // Ŧu (U+0166 U+0075)
  0x01, 0x66, 0x00, 0x76, 0x01, // Ŧv (U+0166 U+0076)
  0x01, 0x66, 0x00, 0x77, 0x01, // Ŧw (U+0166 U+0077)
  0x01, 0x66, 0x00, 0x78, 0x01, // Ŧx (U+0166 U+0078)
  0x01, 0x66, 0x00, 0x79, 0x01, // Ŧy (U+0166 U+0079)
  0x01, 0x66, 0x00, 0x7A, 0x02, // Ŧz (U+0166 U+007A)
  0x01, 0x66, 0x00, 0xAB, 0x03, // Ŧ« (U+0166 U+00AB)
  0x01, 0x66, 0x00, 0xBB, 0x01, // Ŧ» (U+0166 U+00BB)
  0x01, 0x66, 0x00, 0xC0, 0x02, // ŦÀ (U+0166 U+00C0)
  0x01, 0x66, 0x00, 0xC1, 0x02, // ŦÁ (U+0166 U+00C1)
  0x01, 0x66, 0x00, 0xC2, 0x02, // ŦÂ (U+0166 U+00C2)
  0x01, 0x66, 0x00, 0xC3, 0x02, // ŦÃ (U+0166 U+00C3)
  0x01, 0x66, 0x00, 0xC4, 0x02, // ŦÄ (U+0166 U+00C4)
  0x01, 0x66, 0x00, 0xC5, 0x02, // ŦÅ (U+0166 U+00C5)
  0x01, 0x66, 0x00, 0xC7, 0x01, // ŦÇ (U+0166 U+00C7)
  0x01, 0x66, 0x00, 0xD2, 0x01, // ŦÒ (U+0166 U+00D2)
  0x01, 0x66, 0x00, 0xD3, 0x01, // ŦÓ (U+0166 U+00D3)
  0x01, 0x66, 0x00, 0xD4, 0x01, // ŦÔ (U+0166 U+00D4)
  0x01, 0x66, 0x00, 0xD5, 0x01, // ŦÕ (U+0166 U+00D5)
  0x01, 0x66, 0x00, 0xD6, 0x01, // ŦÖ (U+0166 U+00D6)
  0x01, 0x66, 0x00, 0xD8, 0x01, // ŦØ (U+0166 U+00D8)
  0x01, 0x66, 0x00, 0xE0, 0x03, // Ŧà (U+0166 U+00E0)
  0x01, 0x66, 0x00, 0xE1, 0x03, // Ŧá (U+0166 U+00E1)
  0x01, 0x66, 0x00, 0xE2, 0x03, // Ŧâ (U+0166 U+00E2)
  0x01, 0x66, 0x00, 0xE3, 0x03, // Ŧã (U+0166 U+00E3)
  0x01, 0x66, 0x00, 0xE4, 0x03, // Ŧä (U+0166 U+00E4)
  0x01, 0x66, 0x00, 0xE5, 0x03, // Ŧå (U+0166 U+00E5)
  0x01, 0x66, 0x00, 0xE6, 0x03, // Ŧæ (U+0166 U+00E6)
  0x01, 0x66, 0x00, 0xE7, 0x03, // Ŧç (U+0166 U+00E7)
  0x01, 0x66, 0x00, 0xE8, 0x03, // Ŧè (U+0166 U+00E8)
  0x01, 0x66, 0x00, 0xE9, 0x03, // Ŧé (U+0166 U+00E9)
  0x01, 0x66, 0x00, 0xEA, 0x03, // Ŧê (U+0166 U+00EA)
  0x01, 0x66, 0x00, 0xEB, 0x03, // Ŧë (U+0166 U+00EB)
  0x01, 0x66, 0x00, 0xF2, 0x03, // Ŧò (U+0166 U+00F2)
  0x01, 0x66, 0x00, 0xF3, 0x03, // Ŧó (U+0166 U+00F3)
  0x01, 0x66, 0x00, 0xF4, 0x03, // Ŧô (U+0166 U+00F4)
  0x01, 0x66, 0x00, 0xF5, 0x03, // Ŧõ (U+0166 U+00F5)
  0x01, 0x66, 0x00, 0xF6, 0x03, // Ŧö (U+0166 U+00F6)
  0x01, 0x66, 0x00, 0xF8, 0x03, // Ŧø (U+0166 U+00F8)
  0x01, 0x66, 0x00, 0xF9, 0x02, // Ŧù (U+0166 U+00F9)
  0x01, 0x66, 0x00, 0xFA, 0x02, // Ŧú (U+0166 U+00FA)
  0x01, 0x66, 0x00, 0xFB, 0x02, // Ŧû (U+0166 U+00FB)
  0x01, 0x66, 0x00, 0xFC, 0x02, // Ŧü (U+0166 U+00FC)
  0x01, 0x66, 0x00, 0xFD, 0x01, // Ŧý (U+0166 U+00FD)
  0x01, 0x66, 0x00, 0xFF, 0x01, // Ŧÿ (U+0166 U+00FF)
  0x01, 0x66, 0x01, 0x00, 0x02, // ŦĀ (U+0166 U+0100)
  0x01, 0x66, 0x01, 0x01, 0x03, // Ŧā (U+0166 U+0101)
  0x01, 0x66, 0x01, 0x02, 0x02, // ŦĂ (U+0166 U+0102)
  0x01, 0x66, 0x01, 0x03, 0x03, // Ŧă (U+0166 U+0103)
  0x01, 0x66, 0x01, 0x04, 0x02, // ŦĄ (U+0166 U+0104)
  0x01, 0x66, 0x01, 0x05, 0x03, // Ŧą (U+0166 U+0105)
  0x01, 0x66, 0x01, 0x06, 0x01, // ŦĆ (U+0166 U+0106)
  0x01, 0x66, 0x01, 0x07, 0x03, // Ŧć (U+0166 U+0107)
  0x01, 0x66, 0x01, 0x08, 0x01, // ŦĈ (U+0166 U+0108)
  0x01, 0x66, 0x01, 0x09, 0x03, // Ŧĉ (U+0166 U+0109)
  0x01, 0x66, 0x01, 0x0A, 0x01, // ŦĊ (U+0166 U+010A)
  0x01, 0x66, 0x01, 0x0B, 0x03, // Ŧċ (U+0166 U+010B)
  0x01, 0x66, 0x01, 0x0C, 0x01, // ŦČ (U+0166 U+010C)
  0x01, 0x66, 0x01, 0x0D, 0x03, // Ŧč (U+0166 U+010D)
  0x01, 0x66, 0x01, 0x0F, 0x03, // Ŧď (U+0166 U+010F)
  0x01, 0x66, 0x01, 0x11, 0x03, // Ŧđ (U+0166 U+0111)
  0x01, 0x66, 0x01, 0x13, 0x03, // Ŧē (U+0166 U+0113)
  0x01, 0x66, 0x01, 0x15, 0x03, // Ŧĕ (U+0166 U+0115)
  0x01, 0x66, 0x01, 0x17, 0x03, // Ŧė (U+0166 U+0117)
  0x01, 0x66, 0x01, 0x19, 0x03, // Ŧę (U+0166 U+0119)
  0x01, 0x66, 0x01, 0x1B, 0x03, // Ŧě (U+0166 U+011B)
  0x01, 0x66, 0x01, 0x1C, 0x01, // ŦĜ (U+0166 U+011C)
  0x01, 0x66, 0x01, 0x1D, 0x03, // Ŧĝ (U+0166 U+011D)
  0x01, 0x66, 0x01, 0x1E, 0x01, // ŦĞ (U+0166 U+011E)
  0x01, 0x66, 0x01, 0x1F, 0x03, // Ŧğ (U+0166 U+011F)
  0x01, 0x66, 0x01, 0x20, 0x01, // ŦĠ (U+0166 U+0120)
  0x01, 0x66, 0x01, 0x21, 0x03, // Ŧġ (U+0166 U+0121)
  0x01, 0x66, 0x01, 0x22, 0x01, // ŦĢ (U+0166 U+0122)
  0x01, 0x66, 0x01, 0x23, 0x03, // Ŧģ (U+0166 U+0123)
  0x01, 0x66, 0x01, 0x38, 0x02, // Ŧĸ (U+0166 U+0138)
  0x01, 0x66, 0x01, 0x44, 0x02, // Ŧń (U+0166 U+0144)
  0x01, 0x66, 0x01, 0x46, 0x02, // Ŧņ (U+0166 U+0146)
  0x01, 0x66, 0x01, 0x4B, 0x02, // Ŧŋ (U+0166 U+014B)
  0x01, 0x66, 0x01, 0x4C, 0x01, // ŦŌ (U+0166 U+014C)
  0x01, 0x66, 0x01, 0x4D, 0x03, // Ŧō (U+0166 U+014D)
  0x01, 0x66, 0x01, 0x4E, 0x01, // ŦŎ (U+0166 U+014E)
  0x01, 0x66, 0x01, 0x4F, 0x03, // Ŧŏ (U+0166 U+014F)
  0x01, 0x66, 0x01, 0x50, 0x01, // ŦŐ (U+0166 U+0150)
  0x01, 0x66, 0x01, 0x51, 0x03, // Ŧő (U+0166 U+0151)
  0x01, 0x66, 0x01, 0x52, 0x01, // ŦŒ (U+0166 U+0152)
  0x01, 0x66, 0x01, 0x53, 0x03, // Ŧœ (U+0166 U+0153)
  0x01, 0x66, 0x01, 0x55, 0x02, // Ŧŕ (U+0166 U+0155)
  0x01, 0x66, 0x01, 0x57, 0x02, // Ŧŗ (U+0166 U+0157)
  0x01, 0x66, 0x01, 0x5B, 0x03, // Ŧś (U+0166 U+015B)
  0x01, 0x66, 0x01, 0x5F, 0x03, // Ŧş (U+0166 U+015F)
  0x01, 0x66, 0x01, 0x69, 0x02, // Ŧũ (U+0166 U+0169)
  0x01, 0x66, 0x01, 0x6B, 0x02, // Ŧū (U+0166 U+016B)
  0x01, 0x66, 0x01, 0x6D, 0x02, // Ŧŭ (U+0166 U+016D)
  0x01, 0x66, 0x01, 0x6F, 0x02, // Ŧů (U+0166 U+016F)
  0x01, 0x66, 0x01, 0x71, 0x02, // Ŧű (U+0166 U+0171)
  0x01, 0x66, 0x01, 0x73, 0x02, // Ŧų (U+0166 U+0173)
  0x01, 0x66, 0x01, 0x75, 0x01, // Ŧŵ (U+0166 U+0175)
  0x01, 0x66, 0x01, 0x77, 0x01, // Ŧŷ (U+0166 U+0177)
  0x01, 0x66, 0x01, 0x7A, 0x02, // Ŧź (U+0166 U+017A)
  0x01, 0x66, 0x01, 0x7C, 0x02, // Ŧż (U+0166 U+017C)
  0x01, 0x66, 0x01, 0x7E, 0x02, // Ŧž (U+0166 U+017E)
  0x01, 0x66, 0x20, 0x13, 0x02, // Ŧ– (U+0166 U+2013)
  0x01, 0x66, 0x20, 0x14, 0x02, // Ŧ— (U+0166 U+2014)
  0x01, 0x66, 0x20, 0x1A, 0x03, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x03, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x03, // Ŧ… (U+0166 U+2026)
  0x01, 0x66, 0x20, 0x39, 0x03, // Ŧ‹ (U+0166 U+2039)
  0x01, 0x66, 0x20, 0x3A, 0x01, // Ŧ› (U+0166 U+203A)
  0x01, 0x68, 0x00, 0x2C, 0x01, // Ũ, (U+0168 U+002C)
  0x01, 0x68, 0x00, 0x2E, 0x01, // Ũ. (U+0168 U+002E)
  0x01, 0x68, 0x20, 0x1A, 0x01, // Ũ‚ (U+0168 U+201A)
  0x01, 0x68, 0x20, 0x1E, 0x01, // Ũ„ (U+0168 U+201E)
  0x01, 0x68, 0x20, 0x26, 0x01, // Ũ… (U+0168 U+2026)
  0x01, 0x6A, 0x00, 0x2C, 0x01, // Ū, (U+016A U+002C)
  0x01, 0x6A, 0x00, 0x2E, 0x01, // Ū. (U+016A U+002E)
  0x01, 0x6A, 0x20, 0x1A, 0x01, // Ū‚ (U+016A U+201A)
  0x01, 0x6A, 0x20, 0x1E, 0x01, // Ū„ (U+016A U+201E)
  0x01, 0x6A, 0x20, 0x26, 0x01, // Ū… (U+016A U+2026)
  0x01, 0x6C, 0x00, 0x2C, 0x01, // Ŭ, (U+016C U+002C)
  0x01, 0x6C, 0x00, 0x2E, 0x01, // Ŭ. (U+016C U+002E)
  0x01, 0x6C, 0x20, 0x1A, 0x01, // Ŭ‚ (U+016C U+201A)
  0x01, 0x6C, 0x20, 0x1E, 0x01, // Ŭ„ (U+016C U+201E)
  0x01, 0x6C, 0x20, 0x26, 0x01, // Ŭ… (U+016C U+2026)
  0x01, 0x6E, 0x00, 0x2C, 0x01, // Ů, (U+016E U+002C)
  0x01, 0x6E, 0x00, 0x2E, 0x01, // Ů. (U+016E U+002E)
  0x01, 0x6E, 0x20, 0x1A, 0x01, // Ů‚ (U+016E U+201A)
  0x01, 0x6E, 0x20, 0x1E, 0x01, // Ů„ (U+016E U+201E)
  0x01, 0x6E, 0x20, 0x26, 0x01, // Ů… (U+016E U+2026)
  0x01, 0x70, 0x00, 0x2C, 0x01, // Ű, (U+0170 U+002C)
  0x01, 0x70, 0x00, 0x2E, 0x01, // Ű. (U+0170 U+002E)
  0x01, 0x70, 0x20, 0x1A, 0x01, // Ű‚ (U+0170 U+201A)
  0x01, 0x70, 0x20, 0x1E, 0x01, // Ű„ (U+0170 U+201E)
  0x01, 0x70, 0x20, 0x26, 0x01, // Ű… (U+0170 U+2026)
  0x01, 0x72, 0x00, 0x2C, 0x01, // Ų, (U+0172 U+002C)
  0x01, 0x72, 0x00, 0x2E, 0x01, // Ų. (U+0172 U+002E)
  0x01, 0x72, 0x20, 0x1A, 0x01, // Ų‚ (U+0172 U+201A)
  0x01, 0x72, 0x20, 0x1E, 0x01, // Ų„ (U+0172 U+201E)
  0x01, 0x72, 0x20, 0x26, 0x01, // Ų… (U+0172 U+2026)
  0x01, 0x74, 0x00, 0x2C, 0x02, // Ŵ, (U+0174 U+002C)
  0x01, 0x74, 0x00, 0x2E, 0x02, // Ŵ. (U+0174 U+002E)
  0x01, 0x74, 0x00, 0x41, 0x01, // ŴA (U+0174 U+0041)
  0x01, 0x74, 0x00, 0x61, 0x01, // Ŵa (U+0174 U+0061)
  0x01, 0x74, 0x00, 0x63, 0x01, // Ŵc (U+0174 U+0063)
  0x01, 0x74, 0x00, 0x64, 0x01, // Ŵd (U+0174 U+0064)
  0x01, 0x74, 0x00, 0x65, 0x01, // Ŵe (U+0174 U+0065)
  0x01, 0x74, 0x00, 0x6F, 0x01, // Ŵo (U+0174 U+006F)
  0x01, 0x74, 0x00, 0x71, 0x01, // Ŵq (U+0174 U+0071)
  0x01, 0x74, 0x00, 0xAB, 0x01, // Ŵ« (U+0174 U+00AB)
  0x01, 0x74, 0x00, 0xC0, 0x01, // ŴÀ (U+0174 U+00C0)
  0x01, 0x74, 0x00, 0xC1, 0x01, // ŴÁ (U+0174 U+00C1)
  0x01, 0x74, 0x00, 0xC2, 0x01, // ŴÂ (U+0174 U+00C2)
  0x01, 0x74, 0x00, 0xC3, 0x01, // ŴÃ (U+0174 U+00C3)
  0x01, 0x74, 0x00, 0xC4, 0x01, // ŴÄ (U+0174 U+00C4)
  0x01, 0x74, 0x00, 0xC5, 0x01, // ŴÅ (U+0174 U+00C5)
  0x01, 0x74, 0x00, 0xE0, 0x01, // Ŵà (U+0174 U+00E0)
  0x01, 0x74, 0x00, 0xE1, 0x01, // Ŵá (U+0174 U+00E1)
  0x01, 0x74, 0x00, 0xE2, 0x01, // Ŵâ (U+0174 U+00E2)
  0x01, 0x74, 0x00, 0xE3, 0x01, // Ŵã (U+0174 U+00E3)
  0x01, 0x74, 0x00, 0xE4, 0x01, // Ŵä (U+0174 U+00E4)
  0x01, 0x74, 0x00, 0xE5, 0x01, // Ŵå (U+0174 U+00E5)
  0x01, 0x74, 0x00, 0xE6, 0x01, // Ŵæ (U+0174 U+00E6)
  0x01, 0x74, 0x00, 0xE7, 0x01, // Ŵç (U+0174 U+00E7)
  0x01, 0x74, 0x00, 0xE8, 0x01, // Ŵè (U+0174 U+00E8)
  0x01, 0x74, 0x00, 0xE9, 0x01, // Ŵé (U+0174 U+00E9)
  0x01, 0x74, 0x00, 0xEA, 0x01, // Ŵê (U+0174 U+00EA)
  0x01, 0x74, 0x00, 0xEB, 0x01, // Ŵë (U+0174 U+00EB)
  0x01, 0x74, 0x00, 0xF2, 0x01, // Ŵò (U+0174 U+00F2)
  0x01, 0x74, 0x00, 0xF3, 0x01, // Ŵó (U+0174 U+00F3)
  0x01, 0x74, 0x00, 0xF4, 0x01, // Ŵô (U+0174 U+00F4)
  0x01, 0x74, 0x00, 0xF5, 0x01, // Ŵõ (U+0174 U+00F5)
  0x01, 0x74, 0x00, 0xF6, 0x01, // Ŵö (U+0174 U+00F6)
  0x01, 0x74, 0x00, 0xF8, 0x01, // Ŵø (U+0174 U+00F8)
  0x01, 0x74, 0x01, 0x00, 0x01, // ŴĀ (U+0174 U+0100)
  0x01, 0x74, 0x01, 0x01, 0x01, // Ŵā (U+0174 U+0101)
  0x01, 0x74, 0x01, 0x02, 0x01, // ŴĂ (U+0174 U+0102)
  0x01, 0x74, 0x01, 0x03, 0x01, // Ŵă (U+0174 U+0103)
  0x01, 0x74, 0x01, 0x04, 0x01, // ŴĄ (U+0174 U+0104)
  0x01, 0x74, 0x01, 0x05, 0x01, // Ŵą (U+0174 U+0105)
  0x01, 0x74, 0x01, 0x07, 0x01, // Ŵć (U+0174 U+0107)
  0x01, 0x74, 0x01, 0x09, 0x01, // Ŵĉ (U+0174 U+0109)
  0x01, 0x74, 0x01, 0x0B, 0x01, // Ŵċ (U+0174 U+010B)
  0x01, 0x74, 0x01, 0x0D, 0x01, // Ŵč (U+0174 U+010D)
  0x01, 0x74, 0x01, 0x0F, 0x01, // Ŵď (U+0174 U+010F)
  0x01, 0x74, 0x01, 0x11, 0x01, // Ŵđ (U+0174 U+0111)
  0x01, 0x74, 0x01, 0x13, 0x01, // Ŵē (U+0174 U+0113)
  0x01, 0x74, 0x01, 0x15, 0x01, // Ŵĕ (U+0174 U+0115)
  0x01, 0x74, 0x01, 0x17, 0x01, // Ŵė (U+0174 U+0117)
  0x01, 0x74, 0x01, 0x19, 0x01, // Ŵę (U+0174 U+0119)
  0x01, 0x74, 0x01, 0x1B, 0x01, // Ŵě (U+0174 U+011B)
  0x01, 0x74, 0x01, 0x4D, 0x01, // Ŵō (U+0174 U+014D)
  0x01, 0x74, 0x01, 0x4F, 0x01, // Ŵŏ (U+0174 U+014F)
  0x01, 0x74, 0x01, 0x51, 0x01, // Ŵő (U+0174 U+0151)
  0x01, 0x74, 0x01, 0x53, 0x01, // Ŵœ (U+0174 U+0153)
  0x01, 0x74, 0x20, 0x1A, 0x02, // Ŵ‚ (U+0174 U+201A)
  0x01, 0x74, 0x20, 0x1E, 0x02, // Ŵ„ (U+0174 U+201E)
  0x01, 0x74, 0x20, 0x26, 0x02, // Ŵ… (U+0174 U+2026)
  0x01, 0x74, 0x20, 0x39, 0x01, // Ŵ‹ (U+0174 U+2039)
  0x01, 0x75, 0x00, 0x2C, 0x02, // ŵ, (U+0175 U+002C)
  0x01, 0x75, 0x00, 0x2E, 0x02, // ŵ. (U+0175 U+002E)
  0x01, 0x75, 0x20, 0x1A, 0x02, // ŵ‚ (U+0175 U+201A)
  0x01, 0x75, 0x20, 0x1E, 0x02, // ŵ„ (U+0175 U+201E)
  0x01, 0x75, 0x20, 0x26, 0x02, // ŵ… (U+0175 U+2026)
  0x01, 0x76, 0x00, 0x26, 0x01, // Ŷ& (U+0176 U+0026)
  0x01, 0x76, 0x00, 0x2C, 0x03, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x03, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x00, 0x41, 0x02, // ŶA (U+0176 U+0041)
  0x01, 0x76, 0x00, 0x43, 0x01, // ŶC (U+0176 U+0043)
  0x01, 0x76, 0x00, 0x47, 0x01, // ŶG (U+0176 U+0047)
  0x01, 0x76, 0x00, 0x4F, 0x01, // ŶO (U+0176 U+004F)
  0x01, 0x76, 0x00, 0x51, 0x01, // ŶQ (U+0176 U+0051)
  0x01, 0x76, 0x00, 0x61, 0x02, // Ŷa (U+0176 U+0061)
  0x01, 0x76, 0x00, 0x63, 0x02, // Ŷc (U+0176 U+0063)
  0x01, 0x76, 0x00, 0x64, 0x02, // Ŷd (U+0176 U+0064)
  0x01, 0x76, 0x00, 0x65, 0x02, // Ŷe (U+0176 U+0065)
  0x01, 0x76, 0x00, 0x67, 0x02, // Ŷg (U+0176 U+0067)
  0x01, 0x76, 0x00, 0x6D, 0x01, // Ŷm (U+0176 U+006D)
  0x01, 0x76, 0x00, 0x6E, 0x01, // Ŷn (U+0176 U+006E)
  0x01, 0x76, 0x00, 0x6F, 0x02, // Ŷo (U+0176 U+006F)
  0x01, 0x76, 0x00, 0x70, 0x01, // Ŷp (U+0176 U+0070)
  0x01, 0x76, 0x00, 0x71, 0x02, // Ŷq (U+0176 U+0071)
  0x01, 0x76, 0x00, 0x72, 0x01, // Ŷr (U+0176 U+0072)
  0x01, 0x76, 0x00, 0x73, 0x02, // Ŷs (U+0176 U+0073)
  0x01, 0x76, 0x00, 0x75, 0x01, // Ŷu (U+0176 U+0075)
  0x01, 0x76, 0x00, 0x7A, 0x01, // Ŷz (U+0176 U+007A)
  0x01, 0x76, 0x00, 0xAB, 0x03, // Ŷ« (U+0176 U+00AB)
  0x01, 0x76, 0x00, 0xBB, 0x01, // Ŷ» (U+0176 U+00BB)
  0x01, 0x76, 0x00, 0xC0, 0x02, // ŶÀ (U+0176 U+00C0)
  0x01, 0x76, 0x00, 0xC1, 0x02, // ŶÁ (U+0176 U+00C1)
  0x01, 0x76, 0x00, 0xC2, 0x02, // ŶÂ (U+0176 U+00C2)
  0x01, 0x76, 0x00, 0xC3, 0x02, // ŶÃ (U+0176 U+00C3)
  0x01, 0x76, 0x00, 0xC4, 0x02, // ŶÄ (U+0176 U+00C4)
  0x01, 0x76, 0x00, 0xC5, 0x02, // ŶÅ (U+0176 U+00C5)
  0x01, 0x76, 0x00, 0xC7, 0x01, // ŶÇ (U+0176 U+00C7)
  0x01, 0x76, 0x00, 0xD2, 0x01, // ŶÒ (U+0176 U+00D2)
  0x01, 0x76, 0x00, 0xD3, 0x01, // ŶÓ (U+0176 U+00D3)
  0x01, 0x76, 0x00, 0xD4, 0x01, // ŶÔ (U+0176 U+00D4)
  0x01, 0x76, 0x00, 0xD5, 0x01, // ŶÕ (U+0176 U+00D5)
  0x01, 0x76, 0x00, 0xD6, 0x01, // ŶÖ (U+0176 U+00D6)
  0x01, 0x76, 0x00, 0xD8, 0x01, // ŶØ (U+0176 U+00D8)
  0x01, 0x76, 0x00, 0xE0, 0x02, // Ŷà (U+0176 U+00E0)
  0x01, 0x76, 0x00, 0xE1, 0x02, // Ŷá (U+0176 U+00E1)
  0x01, 0x76, 0x00, 0xE2, 0x02, // Ŷâ (U+0176 U+00E2)
  0x01, 0x76, 0x00, 0xE3, 0x02, // Ŷã (U+0176 U+00E3)
  0x01, 0x76, 0x00, 0xE4, 0x02, // Ŷä (U+0176 U+00E4)
  0x01, 0x76, 0x00, 0xE5, 0x02, // Ŷå (U+0176 U+00E5)
  0x01, 0x76, 0x00, 0xE6, 0x02, // Ŷæ (U+0176 U+00E6)
  0x01, 0x76, 0x00, 0xE7, 0x02, // Ŷç (U+0176 U+00E7)
  0x01, 0x76, 0x00, 0xE8, 0x02, // Ŷè (U+0176 U+00E8)
  0x01, 0x76, 0x00, 0xE9, 0x02, // Ŷé (U+0176 U+00E9)
  0x01, 0x76, 0x00, 0xEA, 0x02, // Ŷê (U+0176 U+00EA)
  0x01, 0x76, 0x00, 0xEB, 0x02, // Ŷë (U+0176 U+00EB)
  0x01, 0x76, 0x00, 0xF2, 0x02, // Ŷò (U+0176 U+00F2)
  0x01, 0x76, 0x00, 0xF3, 0x02, // Ŷó (U+0176 U+00F3)
  0x01, 0x76, 0x00, 0xF4, 0x02, // Ŷô (U+0176 U+00F4)
  0x01, 0x76, 0x00, 0xF5, 0x02, // Ŷõ (U+0176 U+00F5)
  0x01, 0x76, 0x00, 0xF6, 0x02, // Ŷö (U+0176 U+00F6)
  0x01, 0x76, 0x00, 0xF8, 0x02, // Ŷø (U+0176 U+00F8)
  0x01, 0x76, 0x00, 0xF9, 0x01, // Ŷù (U+0176 U+00F9)
  0x01, 0x76, 0x00, 0xFA, 0x01, // Ŷú (U+0176 U+00FA)
  0x01, 0x76, 0x00, 0xFB, 0x01, // Ŷû (U+0176 U+00FB)
  0x01, 0x76, 0x00, 0xFC, 0x01, // Ŷü (U+0176 U+00FC)
  0x01, 0x76, 0x01, 0x00, 0x02, // ŶĀ (U+0176 U+0100)
  0x01, 0x76, 0x01, 0x01, 0x02, // Ŷā (U+0176 U+0101)
  0x01, 0x76, 0x01, 0x02, 0x02, // ŶĂ (U+0176 U+0102)
  0x01, 0x76, 0x01, 0x03, 0x02, // Ŷă (U+0176 U+0103)
  0x01, 0x76, 0x01, 0x04, 0x02, // ŶĄ (U+0176 U+0104)
  0x01, 0x76, 0x01, 0x05, 0x02, // Ŷą (U+0176 U+0105)
  0x01, 0x76, 0x01, 0x06, 0x01, // ŶĆ (U+0176 U+0106)
  0x01, 0x76, 0x01, 0x07, 0x02, // Ŷć (U+0176 U+0107)
  0x01, 0x76, 0x01, 0x08, 0x01, // ŶĈ (U+0176 U+0108)
  0x01, 0x76, 0x01, 0x09, 0x02, // Ŷĉ (U+0176 U+0109)
  0x01, 0x76, 0x01, 0x0A, 0x01, // ŶĊ (U+0176 U+010A)
  0x01, 0x76, 0x01, 0x0B, 0x02, // Ŷċ (U+0176 U+010B)
  0x01, 0x76, 0x01, 0x0C, 0x01, // ŶČ (U+0176 U+010C)
  0x01, 0x76, 0x01, 0x0D, 0x02, // Ŷč (U+0176 U+010D)
  0x01, 0x76, 0x01, 0x0F, 0x02, // Ŷď (U+0176 U+010F)
  0x01, 0x76, 0x01, 0x11, 0x02, // Ŷđ (U+0176 U+0111)
  0x01, 0x76, 0x01, 0x13, 0x02, // Ŷē (U+0176 U+0113)
  0x01, 0x76, 0x01, 0x15, 0x02, // Ŷĕ (U+0176 U+0115)
  0x01, 0x76, 0x01, 0x17, 0x02, // Ŷė (U+0176 U+0117)
  0x01, 0x76, 0x01, 0x19, 0x02, // Ŷę (U+0176 U+0119)
  0x01, 0x76, 0x01, 0x1B, 0x02, // Ŷě (U+0176 U+011B)
  0x01, 0x76, 0x01, 0x1C, 0x01, // ŶĜ (U+0176 U+011C)
  0x01, 0x76, 0x01, 0x1D, 0x02, // Ŷĝ (U+0176 U+011D)
  0x01, 0x76, 0x01, 0x1E, 0x01, // ŶĞ (U+0176 U+011E)
  0x01, 0x76, 0x01, 0x1F, 0x02, // Ŷğ (U+0176 U+011F)
  0x01, 0x76, 0x01, 0x20, 0x01, // ŶĠ (U+0176 U+0120)
  0x01, 0x76, 0x01, 0x21, 0x02, // Ŷġ (U+0176 U+0121)
  0x01, 0x76, 0x01, 0x22, 0x01, // ŶĢ (U+0176 U+0122)
  0x01, 0x76, 0x01, 0x23, 0x02, // Ŷģ (U+0176 U+0123)
  0x01, 0x76, 0x01, 0x38, 0x01, // Ŷĸ (U+0176 U+0138)
  0x01, 0x76, 0x01, 0x44, 0x01, // Ŷń (U+0176 U+0144)
  0x01, 0x76, 0x01, 0x46, 0x01, // Ŷņ (U+0176 U+0146)
  0x01, 0x76, 0x01, 0x4B, 0x01, // Ŷŋ (U+0176 U+014B)
  0x01, 0x76, 0x01, 0x4C, 0x01, // ŶŌ (U+0176 U+014C)
  0x01, 0x76, 0x01, 0x4D, 0x02, // Ŷō (U+0176 U+014D)
  0x01, 0x76, 0x01, 0x4E, 0x01, // ŶŎ (U+0176 U+014E)
  0x01, 0x76, 0x01, 0x4F, 0x02, // Ŷŏ (U+0176 U+014F)
  0x01, 0x76, 0x01, 0x50, 0x01, // ŶŐ (U+0176 U+0150)
  0x01, 0x76, 0x01, 0x51, 0x02, // Ŷő (U+0176 U+0151)
  0x01, 0x76, 0x01, 0x52, 0x01, // ŶŒ (U+0176 U+0152)
  0x01, 0x76, 0x01, 0x53, 0x02, // Ŷœ (U+0176 U+0153)
  0x01, 0x76, 0x01, 0x55, 0x01, // Ŷŕ (U+0176 U+0155)
  0x01, 0x76, 0x01, 0x57, 0x01, // Ŷŗ (U+0176 U+0157)
  0x01, 0x76, 0x01, 0x5B, 0x02, // Ŷś (U+0176 U+015B)
  0x01, 0x76, 0x01, 0x5F, 0x02, // Ŷş (U+0176 U+015F)
  0x01, 0x76, 0x01, 0x69, 0x01, // Ŷũ (U+0176 U+0169)
  0x01, 0x76, 0x01, 0x6B, 0x01, // Ŷū (U+0176 U+016B)
  0x01, 0x76, 0x01, 0x6D, 0x01, // Ŷŭ (U+0176 U+016D)
  0x01, 0x76, 0x01, 0x6F, 0x01, // Ŷů (U+0176 U+016F)
  0x01, 0x76, 0x01, 0x71, 0x01, // Ŷű (U+0176 U+0171)
  0x01, 0x76, 0x01, 0x73, 0x01, // Ŷų (U+0176 U+0173)
  0x01, 0x76, 0x01, 0x7A, 0x01, // Ŷź (U+0176 U+017A)
  0x01, 0x76, 0x01, 0x7C, 0x01, // Ŷż (U+0176 U+017C)
  0x01, 0x76, 0x01, 0x7E, 0x01, // Ŷž (U+0176 U+017E)
  0x01, 0x76, 0x20, 0x1A, 0x03, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x03, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x03, // Ŷ… (U+0176 U+2026)
  0x01, 0x76, 0x20, 0x39, 0x03, // Ŷ‹ (U+0176 U+2039)
  0x01, 0x76, 0x20, 0x3A, 0x01, // Ŷ› (U+0176 U+203A)
  0x01, 0x77, 0x00, 0x2C, 0x02, // ŷ, (U+0177 U+002C)
  0x01, 0x77, 0x00, 0x2E, 0x02, // ŷ. (U+0177 U+002E)
  0x01, 0x77, 0x20, 0x1A, 0x02, // ŷ‚ (U+0177 U+201A)
  0x01, 0x77, 0x20, 0x1E, 0x02, // ŷ„ (U+0177 U+201E)
  0x01, 0x77, 0x20, 0x26, 0x02, // ŷ… (U+0177 U+2026)
  0x01, 0x78, 0x00, 0x26, 0x01, // Ÿ& (U+0178 U+0026)
  0x01, 0x78, 0x00, 0x2C, 0x03, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x03, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x00, 0x41, 0x02, // ŸA (U+0178 U+0041)
  0x01, 0x78, 0x00, 0x43, 0x01, // ŸC (U+0178 U+0043)
  0x01, 0x78, 0x00, 0x47, 0x01, // ŸG (U+0178 U+0047)
  0x01, 0x78, 0x00, 0x4F, 0x01, // ŸO (U+0178 U+004F)
  0x01, 0x78, 0x00, 0x51, 0x01, // ŸQ (U+0178 U+0051)
  0x01, 0x78, 0x00, 0x61, 0x02, // Ÿa (U+0178 U+0061)
  0x01, 0x78, 0x00, 0x63, 0x02, // Ÿc (U+0178 U+0063)
  0x01, 0x78, 0x00, 0x64, 0x02, // Ÿd (U+0178 U+0064)
  0x01, 0x78, 0x00, 0x65, 0x02, // Ÿe (U+0178 U+0065)
  0x01, 0x78, 0x00, 0x67, 0x02, // Ÿg (U+0178 U+0067)
  0x01, 0x78, 0x00, 0x6D, 0x01, // Ÿm (U+0178 U+006D)
  0x01, 0x78, 0x00, 0x6E, 0x01, // Ÿn (U+0178 U+006E)
  0x01, 0x78, 0x00, 0x6F, 0x02, // Ÿo (U+0178 U+006F)
  0x01, 0x78, 0x00, 0x70, 0x01, // Ÿp (U+0178 U+0070)
  0x01, 0x78, 0x00, 0x71, 0x02, // Ÿq (U+0178 U+0071)
  0x01, 0x78, 0x00, 0x72, 0x01, // Ÿr (U+0178 U+0072)
  0x01, 0x78, 0x00, 0x73, 0x02, // Ÿs (U+0178 U+0073)
  0x01, 0x78, 0x00, 0x75, 0x01, // Ÿu (U+0178 U+0075)
  0x01, 0x78, 0x00, 0x7A, 0x01, // Ÿz (U+0178 U+007A)
  0x01, 0x78, 0x00, 0xAB, 0x03, // Ÿ« (U+0178 U+00AB)
  0x01, 0x78, 0x00, 0xBB, 0x01, // Ÿ» (U+0178 U+00BB)
  0x01, 0x78, 0x00, 0xC0, 0x02, // ŸÀ (U+0178 U+00C0)
  0x01, 0x78, 0x00, 0xC1, 0x02, // ŸÁ (U+0178 U+00C1)
  0x01, 0x78, 0x00, 0xC2, 0x02, // ŸÂ (U+0178 U+00C2)
  0x01, 0x78, 0x00, 0xC3, 0x02, // ŸÃ (U+0178 U+00C3)
  0x01, 0x78, 0x00, 0xC4, 0x02, // ŸÄ (U+0178 U+00C4)
  0x01, 0x78, 0x00, 0xC5, 0x02, // ŸÅ (U+0178 U+00C5)
  0x01, 0x78, 0x00, 0xC7, 0x01, // ŸÇ (U+0178 U+00C7)
  0x01, 0x78, 0x00, 0xD2, 0x01, // ŸÒ (U+0178 U+00D2)
  0x01, 0x78, 0x00, 0xD3, 0x01, // ŸÓ (U+0178 U+00D3)
  0x01, 0x78, 0x00, 0xD4, 0x01, // ŸÔ (U+0178 U+00D4)
  0x01, 0x78, 0x00, 0xD5, 0x01, // ŸÕ (U+0178 U+00D5)
  0x01, 0x78, 0x00, 0xD6, 0x01, // ŸÖ (U+0178 U+00D6)
  0x01, 0x78, 0x00, 0xD8, 0x01, // ŸØ (U+0178 U+00D8)
  0x01, 0x78, 0x00, 0xE0, 0x02, // Ÿà (U+0178 U+00E0)
  0x01, 0x78, 0x00, 0xE1, 0x02, // Ÿá (U+0178 U+00E1)
  0x01, 0x78, 0x00, 0xE2, 0x02, // Ÿâ (U+0178 U+00E2)
  0x01, 0x78, 0x00, 0xE3, 0x02, // Ÿã (U+0178 U+00E3)
  0x01, 0x78, 0x00, 0xE4, 0x02, // Ÿä (U+0178 U+00E4)
  0x01, 0x78, 0x00, 0xE5, 0x02, // Ÿå (U+0178 U+00E5)
  0x01, 0x78, 0x00, 0xE6, 0x02, // Ÿæ (U+0178 U+00E6)
  0x01, 0x78, 0x00, 0xE7, 0x02, // Ÿç (U+0178 U+00E7)
  0x01, 0x78, 0x00, 0xE8, 0x02, // Ÿè (U+0178 U+00E8)
  0x01, 0x78, 0x00, 0xE9, 0x02, // Ÿé (U+0178 U+00E9)
  0x01, 0x78, 0x00, 0xEA, 0x02, // Ÿê (U+0178 U+00EA)
  0x01, 0x78, 0x00, 0xEB, 0x02, // Ÿë (U+0178 U+00EB)
  0x01, 0x78, 0x00, 0xF2, 0x02, // Ÿò (U+0178 U+00F2)
  0x01, 0x78, 0x00, 0xF3, 0x02, // Ÿó (U+0178 U+00F3)
  0x01, 0x78, 0x00, 0xF4, 0x02, // Ÿô (U+0178 U+00F4)
  0x01, 0x78, 0x00, 0xF5, 0x02, // Ÿõ (U+0178 U+00F5)
  0x01, 0x78, 0x00, 0xF6, 0x02, // Ÿö (U+0178 U+00F6)
  0x01, 0x78, 0x00, 0xF8, 0x02, // Ÿø (U+0178 U+00F8)
  0x01, 0x78, 0x00, 0xF9, 0x01, // Ÿù (U+0178 U+00F9)
  0x01, 0x78, 0x00, 0xFA, 0x01, // Ÿú (U+0178 U+00FA)
  0x01, 0x78, 0x00, 0xFB, 0x01, // Ÿû (U+0178 U+00FB)
  0x01, 0x78, 0x00, 0xFC, 0x01, // Ÿü (U+0178 U+00FC)
  0x01, 0x78, 0x01, 0x00, 0x02, // ŸĀ (U+0178 U+0100)
  0x01, 0x78, 0x01, 0x01, 0x02, // Ÿā (U+0178 U+0101)
  0x01, 0x78, 0x01, 0x02, 0x02, // ŸĂ (U+0178 U+0102)
  0x01, 0x78, 0x01, 0x03, 0x02, // Ÿă (U+0178 U+0103)
  0x01, 0x78, 0x01, 0x04, 0x02, // ŸĄ (U+0178 U+0104)
  0x01, 0x78, 0x01, 0x05, 0x02, // Ÿą (U+0178 U+0105)
  0x01, 0x78, 0x01, 0x06, 0x01, // ŸĆ (U+0178 U+0106)
  0x01, 0x78, 0x01, 0x07, 0x02, // Ÿć (U+0178 U+0107)
  0x01, 0x78, 0x01, 0x08, 0x01, // ŸĈ (U+0178 U+0108)
  0x01, 0x78, 0x01, 0x09, 0x02, // Ÿĉ (U+0178 U+0109)
  0x01, 0x78, 0x01, 0x0A, 0x01, // ŸĊ (U+0178 U+010A)
  0x01, 0x78, 0x01, 0x0B, 0x02, // Ÿċ (U+0178 U+010B)
  0x01, 0x78, 0x01, 0x0C, 0x01, // ŸČ (U+0178 U+010C)
  0x01, 0x78, 0x01, 0x0D, 0x02, // Ÿč (U+0178 U+010D)
  0x01, 0x78, 0x01, 0x0F, 0x02, // Ÿď (U+0178 U+010F)
  0x01, 0x78, 0x01, 0x11, 0x02, // Ÿđ (U+0178 U+0111)
  0x01, 0x78, 0x01, 0x13, 0x02, // Ÿē (U+0178 U+0113)
  0x01, 0x78, 0x01, 0x15, 0x02, // Ÿĕ (U+0178 U+0115)
  0x01, 0x78, 0x01, 0x17, 0x02, // Ÿė (U+0178 U+0117)
  0x01, 0x78, 0x01, 0x19, 0x02, // Ÿę (U+0178 U+0119)
  0x01, 0x78, 0x01, 0x1B, 0x02, // Ÿě (U+0178 U+011B)
  0x01, 0x78, 0x01, 0x1C, 0x01, // ŸĜ (U+0178 U+011C)
  0x01, 0x78, 0x01, 0x1D, 0x02, // Ÿĝ (U+0178 U+011D)
  0x01, 0x78, 0x01, 0x1E, 0x01, // ŸĞ (U+0178 U+011E)
  0x01, 0x78, 0x01, 0x1F, 0x02, // Ÿğ (U+0178 U+011F)
  0x01, 0x78, 0x01, 0x20, 0x01, // ŸĠ (U+0178 U+0120)
  0x01, 0x78, 0x01, 0x21, 0x02, // Ÿġ (U+0178 U+0121)
  0x01, 0x78, 0x01, 0x22, 0x01, // ŸĢ (U+0178 U+0122)
  0x01, 0x78, 0x01, 0x23, 0x02, // Ÿģ (U+0178 U+0123)
  0x01, 0x78, 0x01, 0x38, 0x01, // Ÿĸ (U+0178 U+0138)
  0x01, 0x78, 0x01, 0x44, 0x01, // Ÿń (U+0178 U+0144)
  0x01, 0x78, 0x01, 0x46, 0x01, // Ÿņ (U+0178 U+0146)
  0x01, 0x78, 0x01, 0x4B, 0x01, // Ÿŋ (U+0178 U+014B)
  0x01, 0x78, 0x01, 0x4C, 0x01, // ŸŌ (U+0178 U+014C)
  0x01, 0x78, 0x01, 0x4D, 0x02, // Ÿō (U+0178 U+014D)
  0x01, 0x78, 0x01, 0x4E, 0x01, // ŸŎ (U+0178 U+014E)
  0x01, 0x78, 0x01, 0x4F, 0x02, // Ÿŏ (U+0178 U+014F)
  0x01, 0x78, 0x01, 0x50, 0x01, // ŸŐ (U+0178 U+0150)
  0x01, 0x78, 0x01, 0x51, 0x02, // Ÿő (U+0178 U+0151)
  0x01, 0x78, 0x01, 0x52, 0x01, // ŸŒ (U+0178 U+0152)
  0x01, 0x78, 0x01, 0x53, 0x02, // Ÿœ (U+0178 U+0153)
  0x01, 0x78, 0x01, 0x55, 0x01, // Ÿŕ (U+0178 U+0155)
  0x01, 0x78, 0x01, 0x57, 0x01, // Ÿŗ (U+0178 U+0157)
  0x01, 0x78, 0x01, 0x5B, 0x02, // Ÿś (U+0178 U+015B)
  0x01, 0x78, 0x01, 0x5F, 0x02, // Ÿş (U+0178 U+015F)
  0x01, 0x78, 0x01, 0x69, 0x01, // Ÿũ (U+0178 U+0169)
  0x01, 0x78, 0x01, 0x6B, 0x01, // Ÿū (U+0178 U+016B)
  0x01, 0x78, 0x01, 0x6D, 0x01, // Ÿŭ (U+0178 U+016D)
  0x01, 0x78, 0x01, 0x6F, 0x01, // Ÿů (U+0178 U+016F)
  0x01, 0x78, 0x01, 0x71, 0x01, // Ÿű (U+0178 U+0171)
  0x01, 0x78, 0x01, 0x73, 0x01, // Ÿų (U+0178 U+0173)
  0x01, 0x78, 0x01, 0x7A, 0x01, // Ÿź (U+0178 U+017A)
  0x01, 0x78, 0x01, 0x7C, 0x01, // Ÿż (U+0178 U+017C)
  0x01, 0x78, 0x01, 0x7E, 0x01, // Ÿž (U+0178 U+017E)
  0x01, 0x78, 0x20, 0x1A, 0x03, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x03, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x03, // Ÿ… (U+0178 U+2026)
  0x01, 0x78, 0x20, 0x39, 0x03, // Ÿ‹ (U+0178 U+2039)
  0x01, 0x78, 0x20, 0x3A, 0x01, // Ÿ› (U+0178 U+203A)
  0x01, 0x79, 0x00, 0xAB, 0x01, // Ź« (U+0179 U+00AB)
  0x01, 0x79, 0x20, 0x39, 0x01, // Ź‹ (U+0179 U+2039)
  0x01, 0x7B, 0x00, 0xAB, 0x01, // Ż« (U+017B U+00AB)
  0x01, 0x7B, 0x20, 0x39, 0x01, // Ż‹ (U+017B U+2039)
  0x01, 0x7D, 0x00, 0xAB, 0x01, // Ž« (U+017D U+00AB)
  0x01, 0x7D, 0x20, 0x39, 0x01, // Ž‹ (U+017D U+2039)
  0x20, 0x13, 0x00, 0x54, 0x02, // –T (U+2013 U+0054)
  0x20, 0x13, 0x01, 0x62, 0x02, // –Ţ (U+2013 U+0162)
  0x20, 0x13, 0x01, 0x64, 0x02, // –Ť (U+2013 U+0164)
  0x20, 0x13, 0x01, 0x66, 0x02, // –Ŧ (U+2013 U+0166)
  0x20, 0x14, 0x00, 0x54, 0x02, // —T (U+2014 U+0054)
  0x20, 0x14, 0x01, 0x62, 0x02, // —Ţ (U+2014 U+0162)
  0x20, 0x14, 0x01, 0x64, 0x02, // —Ť (U+2014 U+0164)
  0x20, 0x14, 0x01, 0x66, 0x02, // —Ŧ (U+2014 U+0166)
  0x20, 0x18, 0x00, 0x41, 0x03, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0x61, 0x02, // ‘a (U+2018 U+0061)
  0x20, 0x18, 0x00, 0x63, 0x03, // ‘c (U+2018 U+0063)
  0x20, 0x18, 0x00, 0x64, 0x03, // ‘d (U+2018 U+0064)
  0x20, 0x18, 0x00, 0x65, 0x03, // ‘e (U+2018 U+0065)
  0x20, 0x18, 0x00, 0x67, 0x01, // ‘g (U+2018 U+0067)
  0x20, 0x18, 0x00, 0x6D, 0x01, // ‘m (U+2018 U+006D)
  0x20, 0x18, 0x00, 0x6E, 0x01, // ‘n (U+2018 U+006E)
  0x20, 0x18, 0x00, 0x6F, 0x03, // ‘o (U+2018 U+006F)
  0x20, 0x18, 0x00, 0x70, 0x01, // ‘p (U+2018 U+0070)
  0x20, 0x18, 0x00, 0x71, 0x03, // ‘q (U+2018 U+0071)
  0x20, 0x18, 0x00, 0x72, 0x01, // ‘r (U+2018 U+0072)
  0x20, 0x18, 0x00, 0x73, 0x01, // ‘s (U+2018 U+0073)
  0x20, 0x18, 0x00, 0x75, 0x01, // ‘u (U+2018 U+0075)
  0x20, 0x18, 0x00, 0xC0, 0x03, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x03, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x03, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x03, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x03, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x03, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xC6, 0x04, // ‘Æ (U+2018 U+00C6)
  0x20, 0x18, 0x00, 0xE0, 0x03, // ‘à (U+2018 U+00E0)
  0x20, 0x18, 0x00, 0xE1, 0x02, // ‘á (U+2018 U+00E1)
  0x20, 0x18, 0x00, 0xE2, 0x02, // ‘â (U+2018 U+00E2)
  0x20, 0x18, 0x00, 0xE3, 0x02, // ‘ã (U+2018 U+00E3)
  0x20, 0x18, 0x00, 0xE4, 0x02, // ‘ä (U+2018 U+00E4)
  0x20, 0x18, 0x00, 0xE5, 0x02, // ‘å (U+2018 U+00E5)
  0x20, 0x18, 0x00, 0xE6, 0x02, // ‘æ (U+2018 U+00E6)
  0x20, 0x18, 0x00, 0xE7, 0x03, // ‘ç (U+2018 U+00E7)
  0x20, 0x18, 0x00, 0xE8, 0x03, // ‘è (U+2018 U+00E8)
  0x20, 0x18, 0x00, 0xE9, 0x03, // ‘é (U+2018 U+00E9)
  0x20, 0x18, 0x00, 0xEA, 0x03, // ‘ê (U+2018 U+00EA)
  0x20, 0x18, 0x00, 0xEB, 0x03, // ‘ë (U+2018 U+00EB)
  0x20, 0x18, 0x00, 0xF2, 0x03, // ‘ò (U+2018 U+00F2)
  0x20, 0x18, 0x00, 0xF3, 0x03, // ‘ó (U+2018 U+00F3)
  0x20, 0x18, 0x00, 0xF4, 0x03, // ‘ô (U+2018 U+00F4)
  0x20, 0x18, 0x00, 0xF5, 0x03, // ‘õ (U+2018 U+00F5)
  0x20, 0x18, 0x00, 0xF6, 0x03, // ‘ö (U+2018 U+00F6)
  0x20, 0x18, 0x00, 0xF8, 0x03, // ‘ø (U+2018 U+00F8)
  0x20, 0x18, 0x00, 0xF9, 0x01, // ‘ù (U+2018 U+00F9)
  0x20, 0x18, 0x00, 0xFA, 0x01, // ‘ú (U+2018 U+00FA)
  0x20, 0x18, 0x00, 0xFB, 0x01, // ‘û (U+2018 U+00FB)
  0x20, 0x18, 0x00, 0xFC, 0x01, // ‘ü (U+2018 U+00FC)
  0x20, 0x18, 0x01, 0x00, 0x03, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x01, 0x02, // ‘ā (U+2018 U+0101)
  0x20, 0x18, 0x01, 0x02, 0x03, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x03, 0x02, // ‘ă (U+2018 U+0103)
  0x20, 0x18, 0x01, 0x04, 0x03, // ‘Ą (U+2018 U+0104)
  0x20, 0x18, 0x01, 0x05, 0x02, // ‘ą (U+2018 U+0105)
  0x20, 0x18, 0x01, 0x07, 0x03, // ‘ć (U+2018 U+0107)
  0x20, 0x18, 0x01, 0x09, 0x03, // ‘ĉ (U+2018 U+0109)
  0x20, 0x18, 0x01, 0x0B, 0x03, // ‘ċ (U+2018 U+010B)
  0x20, 0x18, 0x01, 0x0D, 0x03, // ‘č (U+2018 U+010D)
  0x20, 0x18, 0x01, 0x0F, 0x03, // ‘ď (U+2018 U+010F)
  0x20, 0x18, 0x01, 0x11, 0x03, // ‘đ (U+2018 U+0111)
  0x20, 0x18, 0x01, 0x13, 0x03, // ‘ē (U+2018 U+0113)
  0x20, 0x18, 0x01, 0x15, 0x03, // ‘ĕ (U+2018 U+0115)
  0x20, 0x18, 0x01, 0x17, 0x03, // ‘ė (U+2018 U+0117)
  0x20, 0x18, 0x01, 0x19, 0x03, // ‘ę (U+2018 U+0119)
  0x20, 0x18, 0x01, 0x1B, 0x03, // ‘ě (U+2018 U+011B)
  0x20, 0x18, 0x01, 0x1D, 0x01, // ‘ĝ (U+2018 U+011D)
  0x20, 0x18, 0x01, 0x1F, 0x01, // ‘ğ (U+2018 U+011F)
  0x20, 0x18, 0x01, 0x21, 0x01, // ‘ġ (U+2018 U+0121)
  0x20, 0x18, 0x01, 0x23, 0x01, // ‘ģ (U+2018 U+0123)
  0x20, 0x18, 0x01, 0x38, 0x01, // ‘ĸ (U+2018 U+0138)
  0x20, 0x18, 0x01, 0x44, 0x01, // ‘ń (U+2018 U+0144)
  0x20, 0x18, 0x01, 0x46, 0x01, // ‘ņ (U+2018 U+0146)
  0x20, 0x18, 0x01, 0x4B, 0x01, // ‘ŋ (U+2018 U+014B)
  0x20, 0x18, 0x01, 0x4D, 0x03, // ‘ō (U+2018 U+014D)
  0x20, 0x18, 0x01, 0x4F, 0x03, // ‘ŏ (U+2018 U+014F)
  0x20, 0x18, 0x01, 0x51, 0x03, // ‘ő (U+2018 U+0151)
  0x20, 0x18, 0x01, 0x53, 0x03, // ‘œ (U+2018 U+0153)
  0x20, 0x18, 0x01, 0x55, 0x01, // ‘ŕ (U+2018 U+0155)
  0x20, 0x18, 0x01, 0x57, 0x01, // ‘ŗ (U+2018 U+0157)
  0x20, 0x18, 0x01, 0x5B, 0x01, // ‘ś (U+2018 U+015B)
  0x20, 0x18, 0x01, 0x5F, 0x01, // ‘ş (U+2018 U+015F)
  0x20, 0x18, 0x01, 0x69, 0x01, // ‘ũ (U+2018 U+0169)
  0x20, 0x18, 0x01, 0x6B, 0x01, // ‘ū (U+2018 U+016B)
  0x20, 0x18, 0x01, 0x6D, 0x01, // ‘ŭ (U+2018 U+016D)
  0x20, 0x18, 0x01, 0x6F, 0x01, // ‘ů (U+2018 U+016F)
  0x20, 0x18, 0x01, 0x71, 0x01, // ‘ű (U+2018 U+0171)
  0x20, 0x18, 0x01, 0x73, 0x01, // ‘ų (U+2018 U+0173)
  0x20, 0x18, 0x03, 0xBC, 0x01, // ‘μ (U+2018 U+03BC)
  0x20, 0x19, 0x00, 0x41, 0x03, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0x61, 0x02, // ’a (U+2019 U+0061)
  0x20, 0x19, 0x00, 0x63, 0x03, // ’c (U+2019 U+0063)
  0x20, 0x19, 0x00, 0x64, 0x03, // ’d (U+2019 U+0064)
  0x20, 0x19, 0x00, 0x65, 0x03, // ’e (U+2019 U+0065)
  0x20, 0x19, 0x00, 0x67, 0x01, // ’g (U+2019 U+0067)
  0x20, 0x19, 0x00, 0x6D, 0x01, // ’m (U+2019 U+006D)
  0x20, 0x19, 0x00, 0x6E, 0x01, // ’n (U+2019 U+006E)
  0x20, 0x19, 0x00, 0x6F, 0x03, // ’o (U+2019 U+006F)
  0x20, 0x19, 0x00, 0x70, 0x01, // ’p (U+2019 U+0070)
  0x20, 0x19, 0x00, 0x71, 0x03, // ’q (U+2019 U+0071)
  0x20, 0x19, 0x00, 0x72, 0x01, // ’r (U+2019 U+0072)
  0x20, 0x19, 0x00, 0x73, 0x01, // ’s (U+2019 U+0073)
  0x20, 0x19, 0x00, 0x75, 0x01, // ’u (U+2019 U+0075)
  0x20, 0x19, 0x00, 0xC0, 0x03, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x03, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x03, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x03, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x03, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x03, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xC6, 0x04, // ’Æ (U+2019 U+00C6)
  0x20, 0x19, 0x00, 0xE0, 0x03, // ’à (U+2019 U+00E0)
  0x20, 0x19, 0x00, 0xE1, 0x02, // ’á (U+2019 U+00E1)
  0x20, 0x19, 0x00, 0xE2, 0x02, // ’â (U+2019 U+00E2)
  0x20, 0x19, 0x00, 0xE3, 0x02, // ’ã (U+2019 U+00E3)
  0x20, 0x19, 0x00, 0xE4, 0x02, // ’ä (U+2019 U+00E4)
  0x20, 0x19, 0x00, 0xE5, 0x02, // ’å (U+2019 U+00E5)
  0x20, 0x19, 0x00, 0xE6, 0x02, // ’æ (U+2019 U+00E6)
  0x20, 0x19, 0x00, 0xE7, 0x03, // ’ç (U+2019 U+00E7)
  0x20, 0x19, 0x00, 0xE8, 0x03, // ’è (U+2019 U+00E8)
  0x20, 0x19, 0x00, 0xE9, 0x03, // ’é (U+2019 U+00E9)
  0x20, 0x19, 0x00, 0xEA, 0x03, // ’ê (U+2019 U+00EA)
  0x20, 0x19, 0x00, 0xEB, 0x03, // ’ë (U+2019 U+00EB)
  0x20, 0x19, 0x00, 0xF2, 0x03, // ’ò (U+2019 U+00F2)
  0x20, 0x19, 0x00, 0xF3, 0x03, // ’ó (U+2019 U+00F3)
  0x20, 0x19, 0x00, 0xF4, 0x03, // ’ô (U+2019 U+00F4)
  0x20, 0x19, 0x00, 0xF5, 0x03, // ’õ (U+2019 U+00F5)
  0x20, 0x19, 0x00, 0xF6, 0x03, // ’ö (U+2019 U+00F6)
  0x20, 0x19, 0x00, 0xF8, 0x03, // ’ø (U+2019 U+00F8)
  0x20, 0x19, 0x00, 0xF9, 0x01, // ’ù (U+2019 U+00F9)
  0x20, 0x19, 0x00, 0xFA, 0x01, // ’ú (U+2019 U+00FA)
  0x20, 0x19, 0x00, 0xFB, 0x01, // ’û (U+2019 U+00FB)
  0x20, 0x19, 0x00, 0xFC, 0x01, // ’ü (U+2019 U+00FC)
  0x20, 0x19, 0x01, 0x00, 0x03, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x01, 0x02, // ’ā (U+2019 U+0101)
  0x20, 0x19, 0x01, 0x02, 0x03, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x03, 0x02, // ’ă (U+2019 U+0103)
  0x20, 0x19, 0x01, 0x04, 0x03, // ’Ą (U+2019 U+0104)
  0x20, 0x19, 0x01, 0x05, 0x02, // ’ą (U+2019 U+0105)
  0x20, 0x19, 0x01, 0x07, 0x03, // ’ć (U+2019 U+0107)
  0x20, 0x19, 0x01, 0x09, 0x03, // ’ĉ (U+2019 U+0109)
  0x20, 0x19, 0x01, 0x0B, 0x03, // ’ċ (U+2019 U+010B)
  0x20, 0x19, 0x01, 0x0D, 0x03, // ’č (U+2019 U+010D)
  0x20, 0x19, 0x01, 0x0F, 0x03, // ’ď (U+2019 U+010F)
  0x20, 0x19, 0x01, 0x11, 0x03, // ’đ (U+2019 U+0111)
  0x20, 0x19, 0x01, 0x13, 0x03, // ’ē (U+2019 U+0113)
  0x20, 0x19, 0x01, 0x15, 0x03, // ’ĕ (U+2019 U+0115)
  0x20, 0x19, 0x01, 0x17, 0x03, // ’ė (U+2019 U+0117)
  0x20, 0x19, 0x01, 0x19, 0x03, // ’ę (U+2019 U+0119)
  0x20, 0x19, 0x01, 0x1B, 0x03, // ’ě (U+2019 U+011B)
  0x20, 0x19, 0x01, 0x1D, 0x01, // ’ĝ (U+2019 U+011D)
  0x20, 0x19, 0x01, 0x1F, 0x01, // ’ğ (U+2019 U+011F)
  0x20, 0x19, 0x01, 0x21, 0x01, // ’ġ (U+2019 U+0121)
  0x20, 0x19, 0x01, 0x23, 0x01, // ’ģ (U+2019 U+0123)
  0x20, 0x19, 0x01, 0x38, 0x01, // ’ĸ (U+2019 U+0138)
  0x20, 0x19, 0x01, 0x44, 0x01, // ’ń (U+2019 U+0144)
  0x20, 0x19, 0x01, 0x46, 0x01, // ’ņ (U+2019 U+0146)
  0x20, 0x19, 0x01, 0x4B, 0x01, // ’ŋ (U+2019 U+014B)
  0x20, 0x19, 0x01, 0x4D, 0x03, // ’ō (U+2019 U+014D)
  0x20, 0x19, 0x01, 0x4F, 0x03, // ’ŏ (U+2019 U+014F)
  0x20, 0x19, 0x01, 0x51, 0x03, // ’ő (U+2019 U+0151)
  0x20, 0x19, 0x01, 0x53, 0x03, // ’œ (U+2019 U+0153)
  0x20, 0x19, 0x01, 0x55, 0x01, // ’ŕ (U+2019 U+0155)
  0x20, 0x19, 0x01, 0x57, 0x01, // ’ŗ (U+2019 U+0157)
  0x20, 0x19, 0x01, 0x5B, 0x01, // ’ś (U+2019 U+015B)
  0x20, 0x19, 0x01, 0x5F, 0x01, // ’ş (U+2019 U+015F)
  0x20, 0x19, 0x01, 0x69, 0x01, // ’ũ (U+2019 U+0169)
  0x20, 0x19, 0x01, 0x6B, 0x01, // ’ū (U+2019 U+016B)
  0x20, 0x19, 0x01, 0x6D, 0x01, // ’ŭ (U+2019 U+016D)
  0x20, 0x19, 0x01, 0x6F, 0x01, // ’ů (U+2019 U+016F)
  0x20, 0x19, 0x01, 0x71, 0x01, // ’ű (U+2019 U+0171)
  0x20, 0x19, 0x01, 0x73, 0x01, // ’ų (U+2019 U+0173)
  0x20, 0x19, 0x03, 0xBC, 0x01, // ’μ (U+2019 U+03BC)
  0x20, 0x1A, 0x00, 0x43, 0x02, // ‚C (U+201A U+0043)
  0x20, 0x1A, 0x00, 0x47, 0x02, // ‚G (U+201A U+0047)
  0x20, 0x1A, 0x00, 0x4F, 0x02, // ‚O (U+201A U+004F)
  0x20, 0x1A, 0x00, 0x51, 0x02, // ‚Q (U+201A U+0051)
  0x20, 0x1A, 0x00, 0x54, 0x03, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x55, 0x01, // ‚U (U+201A U+0055)
  0x20, 0x1A, 0x00, 0x56, 0x03, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x03, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x03, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0xC7, 0x02, // ‚Ç (U+201A U+00C7)
  0x20, 0x1A, 0x00, 0xD2, 0x02, // ‚Ò (U+201A U+00D2)
  0x20, 0x1A, 0x00, 0xD3, 0x02, // ‚Ó (U+201A U+00D3)
  0x20, 0x1A, 0x00, 0xD4, 0x02, // ‚Ô (U+201A U+00D4)
  0x20, 0x1A, 0x00, 0xD5, 0x02, // ‚Õ (U+201A U+00D5)
  0x20, 0x1A, 0x00, 0xD6, 0x02, // ‚Ö (U+201A U+00D6)
  0x20, 0x1A, 0x00, 0xD8, 0x02, // ‚Ø (U+201A U+00D8)
  0x20, 0x1A, 0x00, 0xD9, 0x01, // ‚Ù (U+201A U+00D9)
  0x20, 0x1A, 0x00, 0xDA, 0x01, // ‚Ú (U+201A U+00DA)
  0x20, 0x1A, 0x00, 0xDB, 0x01, // ‚Û (U+201A U+00DB)
  0x20, 0x1A, 0x00, 0xDC, 0x01, // ‚Ü (U+201A U+00DC)
  0x20, 0x1A, 0x00, 0xDD, 0x03, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x01, 0x06, 0x02, // ‚Ć (U+201A U+0106)
  0x20, 0x1A, 0x01, 0x08, 0x02, // ‚Ĉ (U+201A U+0108)
  0x20, 0x1A, 0x01, 0x0A, 0x02, // ‚Ċ (U+201A U+010A)
  0x20, 0x1A, 0x01, 0x0C, 0x02, // ‚Č (U+201A U+010C)
  0x20, 0x1A, 0x01, 0x1C, 0x02, // ‚Ĝ (U+201A U+011C)
  0x20, 0x1A, 0x01, 0x1E, 0x02, // ‚Ğ (U+201A U+011E)
  0x20, 0x1A, 0x01, 0x20, 0x02, // ‚Ġ (U+201A U+0120)
  0x20, 0x1A, 0x01, 0x22, 0x02, // ‚Ģ (U+201A U+0122)
  0x20, 0x1A, 0x01, 0x4C, 0x02, // ‚Ō (U+201A U+014C)
  0x20, 0x1A, 0x01, 0x4E, 0x02, // ‚Ŏ (U+201A U+014E)
  0x20, 0x1A, 0x01, 0x50, 0x02, // ‚Ő (U+201A U+0150)
  0x20, 0x1A, 0x01, 0x52, 0x02, // ‚Œ (U+201A U+0152)
  0x20, 0x1A, 0x01, 0x62, 0x03, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x03, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x03, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1A, 0x01, 0x68, 0x01, // ‚Ũ (U+201A U+0168)
  0x20, 0x1A, 0x01, 0x6A, 0x01, // ‚Ū (U+201A U+016A)
  0x20, 0x1A, 0x01, 0x6C, 0x01, // ‚Ŭ (U+201A U+016C)
  0x20, 0x1A, 0x01, 0x6E, 0x01, // ‚Ů (U+201A U+016E)
  0x20, 0x1A, 0x01, 0x70, 0x01, // ‚Ű (U+201A U+0170)
  0x20, 0x1A, 0x01, 0x72, 0x01, // ‚Ų (U+201A U+0172)
  0x20, 0x1A, 0x01, 0x74, 0x03, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x76, 0x03, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x78, 0x03, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x03, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0x61, 0x02, // “a (U+201C U+0061)
  0x20, 0x1C, 0x00, 0x63, 0x03, // “c (U+201C U+0063)
  0x20, 0x1C, 0x00, 0x64, 0x03, // “d (U+201C U+0064)
  0x20, 0x1C, 0x00, 0x65, 0x03, // “e (U+201C U+0065)
  0x20, 0x1C, 0x00, 0x67, 0x01, // “g (U+201C U+0067)
  0x20, 0x1C, 0x00, 0x6D, 0x01, // “m (U+201C U+006D)
  0x20, 0x1C, 0x00, 0x6E, 0x01, // “n (U+201C U+006E)
  0x20, 0x1C, 0x00, 0x6F, 0x03, // “o (U+201C U+006F)
  0x20, 0x1C, 0x00, 0x70, 0x01, // “p (U+201C U+0070)
  0x20, 0x1C, 0x00, 0x71, 0x03, // “q (U+201C U+0071)
  0x20, 0x1C, 0x00, 0x72, 0x01, // “r (U+201C U+0072)
  0x20, 0x1C, 0x00, 0x73, 0x01, // “s (U+201C U+0073)
  0x20, 0x1C, 0x00, 0x75, 0x01, // “u (U+201C U+0075)
  0x20, 0x1C, 0x00, 0xC0, 0x03, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x03, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x03, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x03, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x03, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x03, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xC6, 0x04, // “Æ (U+201C U+00C6)
  0x20, 0x1C, 0x00, 0xE0, 0x03, // “à (U+201C U+00E0)
  0x20, 0x1C, 0x00, 0xE1, 0x02, // “á (U+201C U+00E1)
  0x20, 0x1C, 0x00, 0xE2, 0x02, // “â (U+201C U+00E2)
  0x20, 0x1C, 0x00, 0xE3, 0x02, // “ã (U+201C U+00E3)
  0x20, 0x1C, 0x00, 0xE4, 0x02, // “ä (U+201C U+00E4)
  0x20, 0x1C, 0x00, 0xE5, 0x02, // “å (U+201C U+00E5)
  0x20, 0x1C, 0x00, 0xE6, 0x02, // “æ (U+201C U+00E6)
  0x20, 0x1C, 0x00, 0xE7, 0x03, // “ç (U+201C U+00E7)
  0x20, 0x1C, 0x00, 0xE8, 0x03, // “è (U+201C U+00E8)
  0x20, 0x1C, 0x00, 0xE9, 0x03, // “é (U+201C U+00E9)
  0x20, 0x1C, 0x00, 0xEA, 0x03, // “ê (U+201C U+00EA)
  0x20, 0x1C, 0x00, 0xEB, 0x03, // “ë (U+201C U+00EB)
  0x20, 0x1C, 0x00, 0xF2, 0x03, // “ò (U+201C U+00F2)
  0x20, 0x1C, 0x00, 0xF3, 0x03, // “ó (U+201C U+00F3)
  0x20, 0x1C, 0x00, 0xF4, 0x03, // “ô (U+201C U+00F4)
  0x20, 0x1C, 0x00, 0xF5, 0x03, // “õ (U+201C U+00F5)
  0x20, 0x1C, 0x00, 0xF6, 0x03, // “ö (U+201C U+00F6)
  0x20, 0x1C, 0x00, 0xF8, 0x03, // “ø (U+201C U+00F8)
  0x20, 0x1C, 0x00, 0xF9, 0x01, // “ù (U+201C U+00F9)
  0x20, 0x1C, 0x00, 0xFA, 0x01, // “ú (U+201C U+00FA)
  0x20, 0x1C, 0x00, 0xFB, 0x01, // “û (U+201C U+00FB)
  0x20, 0x1C, 0x00, 0xFC, 0x01, // “ü (U+201C U+00FC)
  0x20, 0x1C, 0x01, 0x00, 0x03, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x01, 0x02, // “ā (U+201C U+0101)
  0x20, 0x1C, 0x01, 0x02, 0x03, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x03, 0x02, // “ă (U+201C U+0103)
  0x20, 0x1C, 0x01, 0x04, 0x03, // “Ą (U+201C U+0104)
  0x20, 0x1C, 0x01, 0x05, 0x02, // “ą (U+201C U+0105)
  0x20, 0x1C, 0x01, 0x07, 0x03, // “ć (U+201C U+0107)
  0x20, 0x1C, 0x01, 0x09, 0x03, // “ĉ (U+201C U+0109)
  0x20, 0x1C, 0x01, 0x0B, 0x03, // “ċ (U+201C U+010B)
  0x20, 0x1C, 0x01, 0x0D, 0x03, // “č (U+201C U+010D)
  0x20, 0x1C, 0x01, 0x0F, 0x03, // “ď (U+201C U+010F)
  0x20, 0x1C, 0x01, 0x11, 0x03, // “đ (U+201C U+0111)
  0x20, 0x1C, 0x01, 0x13, 0x03, // “ē (U+201C U+0113)
  0x20, 0x1C, 0x01, 0x15, 0x03, // “ĕ (U+201C U+0115)
  0x20, 0x1C, 0x01, 0x17, 0x03, // “ė (U+201C U+0117)
  0x20, 0x1C, 0x01, 0x19, 0x03, // “ę (U+201C U+0119)
  0x20, 0x1C, 0x01, 0x1B, 0x03, // “ě (U+201C U+011B)
  0x20, 0x1C, 0x01, 0x1D, 0x01, // “ĝ (U+201C U+011D)
  0x20, 0x1C, 0x01, 0x1F, 0x01, // “ğ (U+201C U+011F)
  0x20, 0x1C, 0x01, 0x21, 0x01, // “ġ (U+201C U+0121)
  0x20, 0x1C, 0x01, 0x23, 0x01, // “ģ (U+201C U+0123)
  0x20, 0x1C, 0x01, 0x38, 0x01, // “ĸ (U+201C U+0138)
  0x20, 0x1C, 0x01, 0x44, 0x01, // “ń (U+201C U+0144)
  0x20, 0x1C, 0x01, 0x46, 0x01, // “ņ (U+201C U+0146)
  0x20, 0x1C, 0x01, 0x4B, 0x01, // “ŋ (U+201C U+014B)
  0x20, 0x1C, 0x01, 0x4D, 0x03, // “ō (U+201C U+014D)
  0x20, 0x1C, 0x01, 0x4F, 0x03, // “ŏ (U+201C U+014F)
  0x20, 0x1C, 0x01, 0x51, 0x03, // “ő (U+201C U+0151)
  0x20, 0x1C, 0x01, 0x53, 0x03, // “œ (U+201C U+0153)
  0x20, 0x1C, 0x01, 0x55, 0x01, // “ŕ (U+201C U+0155)
  0x20, 0x1C, 0x01, 0x57, 0x01, // “ŗ (U+201C U+0157)
  0x20, 0x1C, 0x01, 0x5B, 0x01, // “ś (U+201C U+015B)
  0x20, 0x1C, 0x01, 0x5F, 0x01, // “ş (U+201C U+015F)
  0x20, 0x1C, 0x01, 0x69, 0x01, // “ũ (U+201C U+0169)
  0x20, 0x1C, 0x01, 0x6B, 0x01, // “ū (U+201C U+016B)
  0x20, 0x1C, 0x01, 0x6D, 0x01, // “ŭ (U+201C U+016D)
  0x20, 0x1C, 0x01, 0x6F, 0x01, // “ů (U+201C U+016F)
  0x20, 0x1C, 0x01, 0x71, 0x01, // “ű (U+201C U+0171)
  0x20, 0x1C, 0x01, 0x73, 0x01, // “ų (U+201C U+0173)
  0x20, 0x1C, 0x03, 0xBC, 0x01, // “μ (U+201C U+03BC)
  0x20, 0x1D, 0x00, 0x41, 0x03, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0x61, 0x02, // ”a (U+201D U+0061)
  0x20, 0x1D, 0x00, 0x63, 0x03, // ”c (U+201D U+0063)
  0x20, 0x1D, 0x00, 0x64, 0x03, // ”d (U+201D U+0064)
  0x20, 0x1D, 0x00, 0x65, 0x03, // ”e (U+201D U+0065)
  0x20, 0x1D, 0x00, 0x67, 0x01, // ”g (U+201D U+0067)
  0x20, 0x1D, 0x00, 0x6D, 0x01, // ”m (U+201D U+006D)
  0x20, 0x1D, 0x00, 0x6E, 0x01, // ”n (U+201D U+006E)
  0x20, 0x1D, 0x00, 0x6F, 0x03, // ”o (U+201D U+006F)
  0x20, 0x1D, 0x00, 0x70, 0x01, // ”p (U+201D U+0070)
  0x20, 0x1D, 0x00, 0x71, 0x03, // ”q (U+201D U+0071)
  0x20, 0x1D, 0x00, 0x72, 0x01, // ”r (U+201D U+0072)
  0x20, 0x1D, 0x00, 0x73, 0x01, // ”s (U+201D U+0073)
  0x20, 0x1D, 0x00, 0x75, 0x01, // ”u (U+201D U+0075)
  0x20, 0x1D, 0x00, 0xC0, 0x03, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x03, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x03, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x03, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x03, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x03, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xC6, 0x04, // ”Æ (U+201D U+00C6)
  0x20, 0x1D, 0x00, 0xE0, 0x03, // ”à (U+201D U+00E0)
  0x20, 0x1D, 0x00, 0xE1, 0x02, // ”á (U+201D U+00E1)
  0x20, 0x1D, 0x00, 0xE2, 0x02, // ”â (U+201D U+00E2)
  0x20, 0x1D, 0x00, 0xE3, 0x02, // ”ã (U+201D U+00E3)
  0x20, 0x1D, 0x00, 0xE4, 0x02, // ”ä (U+201D U+00E4)
  0x20, 0x1D, 0x00, 0xE5, 0x02, // ”å (U+201D U+00E5)
  0x20, 0x1D, 0x00, 0xE6, 0x02, // ”æ (U+201D U+00E6)
  0x20, 0x1D, 0x00, 0xE7, 0x03, // ”ç (U+201D U+00E7)
  0x20, 0x1D, 0x00, 0xE8, 0x03, // ”è (U+201D U+00E8)
  0x20, 0x1D, 0x00, 0xE9, 0x03, // ”é (U+201D U+00E9)
  0x20, 0x1D, 0x00, 0xEA, 0x03, // ”ê (U+201D U+00EA)
  0x20, 0x1D, 0x00, 0xEB, 0x03, // ”ë (U+201D U+00EB)
  0x20, 0x1D, 0x00, 0xF2, 0x03, // ”ò (U+201D U+00F2)
  0x20, 0x1D, 0x00, 0xF3, 0x03, // ”ó (U+201D U+00F3)
  0x20, 0x1D, 0x00, 0xF4, 0x03, // ”ô (U+201D U+00F4)
  0x20, 0x1D, 0x00, 0xF5, 0x03, // ”õ (U+201D U+00F5)
  0x20, 0x1D, 0x00, 0xF6, 0x03, // ”ö (U+201D U+00F6)
  0x20, 0x1D, 0x00, 0xF8, 0x03, // ”ø (U+201D U+00F8)
  0x20, 0x1D, 0x00, 0xF9, 0x01, // ”ù (U+201D U+00F9)
  0x20, 0x1D, 0x00, 0xFA, 0x01, // ”ú (U+201D U+00FA)
  0x20, 0x1D, 0x00, 0xFB, 0x01, // ”û (U+201D U+00FB)
  0x20, 0x1D, 0x00, 0xFC, 0x01, // ”ü (U+201D U+00FC)
  0x20, 0x1D, 0x01, 0x00, 0x03, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x01, 0x02, // ”ā (U+201D U+0101)
  0x20, 0x1D, 0x01, 0x02, 0x03, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x03, 0x02, // ”ă (U+201D U+0103)
  0x20, 0x1D, 0x01, 0x04, 0x03, // ”Ą (U+201D U+0104)
  0x20, 0x1D, 0x01, 0x05, 0x02, // ”ą (U+201D U+0105)
  0x20, 0x1D, 0x01, 0x07, 0x03, // ”ć (U+201D U+0107)
  0x20, 0x1D, 0x01, 0x09, 0x03, // ”ĉ (U+201D U+0109)
  0x20, 0x1D, 0x01, 0x0B, 0x03, // ”ċ (U+201D U+010B)
  0x20, 0x1D, 0x01, 0x0D, 0x03, // ”č (U+201D U+010D)
  0x20, 0x1D, 0x01, 0x0F, 0x03, // ”ď (U+201D U+010F)
  0x20, 0x1D, 0x01, 0x11, 0x03, // ”đ (U+201D U+0111)
  0x20, 0x1D, 0x01, 0x13, 0x03, // ”ē (U+201D U+0113)
  0x20, 0x1D, 0x01, 0x15, 0x03, // ”ĕ (U+201D U+0115)
  0x20, 0x1D, 0x01, 0x17, 0x03, // ”ė (U+201D U+0117)
  0x20, 0x1D, 0x01, 0x19, 0x03, // ”ę (U+201D U+0119)
  0x20, 0x1D, 0x01, 0x1B, 0x03, // ”ě (U+201D U+011B)
  0x20, 0x1D, 0x01, 0x1D, 0x01, // ”ĝ (U+201D U+011D)
  0x20, 0x1D, 0x01, 0x1F, 0x01, // ”ğ (U+201D U+011F)
  0x20, 0x1D, 0x01, 0x21, 0x01, // ”ġ (U+201D U+0121)
  0x20, 0x1D, 0x01, 0x23, 0x01, // ”ģ (U+201D U+0123)
  0x20, 0x1D, 0x01, 0x38, 0x01, // ”ĸ (U+201D U+0138)
  0x20, 0x1D, 0x01, 0x44, 0x01, // ”ń (U+201D U+0144)
  0x20, 0x1D, 0x01, 0x46, 0x01, // ”ņ (U+201D U+0146)
  0x20, 0x1D, 0x01, 0x4B, 0x01, // ”ŋ (U+201D U+014B)
  0x20, 0x1D, 0x01, 0x4D, 0x03, // ”ō (U+201D U+014D)
  0x20, 0x1D, 0x01, 0x4F, 0x03, // ”ŏ (U+201D U+014F)
  0x20, 0x1D, 0x01, 0x51, 0x03, // ”ő (U+201D U+0151)
  0x20, 0x1D, 0x01, 0x53, 0x03, // ”œ (U+201D U+0153)
  0x20, 0x1D, 0x01, 0x55, 0x01, // ”ŕ (U+201D U+0155)
  0x20, 0x1D, 0x01, 0x57, 0x01, // ”ŗ (U+201D U+0157)
  0x20, 0x1D, 0x01, 0x5B, 0x01, // ”ś (U+201D U+015B)
  0x20, 0x1D, 0x01, 0x5F, 0x01, // ”ş (U+201D U+015F)
  0x20, 0x1D, 0x01, 0x69, 0x01, // ”ũ (U+201D U+0169)
  0x20, 0x1D, 0x01, 0x6B, 0x01, // ”ū (U+201D U+016B)
  0x20, 0x1D, 0x01, 0x6D, 0x01, // ”ŭ (U+201D U+016D)
  0x20, 0x1D, 0x01, 0x6F, 0x01, // ”ů (U+201D U+016F)
  0x20, 0x1D, 0x01, 0x71, 0x01, // ”ű (U+201D U+0171)
  0x20, 0x1D, 0x01, 0x73, 0x01, // ”ų (U+201D U+0173)
  0x20, 0x1D, 0x03, 0xBC, 0x01, // ”μ (U+201D U+03BC)
  0x20, 0x1E, 0x00, 0x43, 0x02, // „C (U+201E U+0043)
  0x20, 0x1E, 0x00, 0x47, 0x02, // „G (U+201E U+0047)
  0x20, 0x1E, 0x00, 0x4F, 0x02, // „O (U+201E U+004F)
  0x20, 0x1E, 0x00, 0x51, 0x02, // „Q (U+201E U+0051)
  0x20, 0x1E, 0x00, 0x54, 0x03, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x55, 0x01, // „U (U+201E U+0055)
  0x20, 0x1E, 0x00, 0x56, 0x03, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x03, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x03, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0xC7, 0x02, // „Ç (U+201E U+00C7)
  0x20, 0x1E, 0x00, 0xD2, 0x02, // „Ò (U+201E U+00D2)
  0x20, 0x1E, 0x00, 0xD3, 0x02, // „Ó (U+201E U+00D3)
  0x20, 0x1E, 0x00, 0xD4, 0x02, // „Ô (U+201E U+00D4)
  0x20, 0x1E, 0x00, 0xD5, 0x02, // „Õ (U+201E U+00D5)
  0x20, 0x1E, 0x00, 0xD6, 0x02, // „Ö (U+201E U+00D6)
  0x20, 0x1E, 0x00, 0xD8, 0x02, // „Ø (U+201E U+00D8)
  0x20, 0x1E, 0x00, 0xD9, 0x01, // „Ù (U+201E U+00D9)
  0x20, 0x1E, 0x00, 0xDA, 0x01, // „Ú (U+201E U+00DA)
  0x20, 0x1E, 0x00, 0xDB, 0x01, // „Û (U+201E U+00DB)
  0x20, 0x1E, 0x00, 0xDC, 0x01, // „Ü (U+201E U+00DC)
  0x20, 0x1E, 0x00, 0xDD, 0x03, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x01, 0x06, 0x02, // „Ć (U+201E U+0106)
  0x20, 0x1E, 0x01, 0x08, 0x02, // „Ĉ (U+201E U+0108)
  0x20, 0x1E, 0x01, 0x0A, 0x02, // „Ċ (U+201E U+010A)
  0x20, 0x1E, 0x01, 0x0C, 0x02, // „Č (U+201E U+010C)
  0x20, 0x1E, 0x01, 0x1C, 0x02, // „Ĝ (U+201E U+011C)
  0x20, 0x1E, 0x01, 0x1E, 0x02, // „Ğ (U+201E U+011E)
  0x20, 0x1E, 0x01, 0x20, 0x02, // „Ġ (U+201E U+0120)
  0x20, 0x1E, 0x01, 0x22, 0x02, // „Ģ (U+201E U+0122)
  0x20, 0x1E, 0x01, 0x4C, 0x02, // „Ō (U+201E U+014C)
  0x20, 0x1E, 0x01, 0x4E, 0x02, // „Ŏ (U+201E U+014E)
  0x20, 0x1E, 0x01, 0x50, 0x02, // „Ő (U+201E U+0150)
  0x20, 0x1E, 0x01, 0x52, 0x02, // „Œ (U+201E U+0152)
  0x20, 0x1E, 0x01, 0x62, 0x03, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x03, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x03, // „Ŧ (U+201E U+0166)
  0x20, 0x1E, 0x01, 0x68, 0x01, // „Ũ (U+201E U+0168)
  0x20, 0x1E, 0x01, 0x6A, 0x01, // „Ū (U+201E U+016A)
  0x20, 0x1E, 0x01, 0x6C, 0x01, // „Ŭ (U+201E U+016C)
  0x20, 0x1E, 0x01, 0x6E, 0x01, // „Ů (U+201E U+016E)
  0x20, 0x1E, 0x01, 0x70, 0x01, // „Ű (U+201E U+0170)
  0x20, 0x1E, 0x01, 0x72, 0x01, // „Ų (U+201E U+0172)
  0x20, 0x1E, 0x01, 0x74, 0x03, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x76, 0x03, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x78, 0x03, // „Ÿ (U+201E U+0178)
  0x20, 0x39, 0x00, 0x54, 0x01, // ‹T (U+2039 U+0054)
  0x20, 0x39, 0x00, 0x59, 0x01, // ‹Y (U+2039 U+0059)
  0x20, 0x39, 0x00, 0xDD, 0x01, // ‹Ý (U+2039 U+00DD)
  0x20, 0x39, 0x01, 0x62, 0x01, // ‹Ţ (U+2039 U+0162)
  0x20, 0x39, 0x01, 0x64, 0x01, // ‹Ť (U+2039 U+0164)
  0x20, 0x39, 0x01, 0x66, 0x01, // ‹Ŧ (U+2039 U+0166)
  0x20, 0x39, 0x01, 0x76, 0x01, // ‹Ŷ (U+2039 U+0176)
  0x20, 0x39, 0x01, 0x78, 0x01, // ‹Ÿ (U+2039 U+0178)
  0x20, 0x3A, 0x00, 0x54, 0x03, // ›T (U+203A U+0054)
  0x20, 0x3A, 0x00, 0x56, 0x01, // ›V (U+203A U+0056)
  0x20, 0x3A, 0x00, 0x57, 0x01, // ›W (U+203A U+0057)
  0x20, 0x3A, 0x00, 0x58, 0x01, // ›X (U+203A U+0058)
  0x20, 0x3A, 0x00, 0x59, 0x03, // ›Y (U+203A U+0059)
  0x20, 0x3A, 0x00, 0xDD, 0x03, // ›Ý (U+203A U+00DD)
  0x20, 0x3A, 0x01, 0x62, 0x03, // ›Ţ (U+203A U+0162)
  0x20, 0x3A, 0x01, 0x64, 0x03, // ›Ť (U+203A U+0164)
  0x20, 0x3A, 0x01, 0x66, 0x03, // ›Ŧ (U+203A U+0166)
  0x20, 0x3A, 0x01, 0x74, 0x01, // ›Ŵ (U+203A U+0174)
  0x20, 0x3A, 0x01, 0x76, 0x03, // ›Ŷ (U+203A U+0176)
  0x20, 0x3A, 0x01, 0x78, 0x03, // ›Ÿ (U+203A U+0178)
  0x20, 0x44, 0x00, 0x30, 0x08, // ⁄0 (U+2044 U+0030)
  0x20, 0x44, 0x00, 0x31, 0x08, // ⁄1 (U+2044 U+0031)
  0x20, 0x44, 0x00, 0x32, 0x08, // ⁄2 (U+2044 U+0032)
  0x20, 0x44, 0x00, 0x33, 0x08, // ⁄3 (U+2044 U+0033)
  0x20, 0x44, 0x00, 0x34, 0x08, // ⁄4 (U+2044 U+0034)
  0x20, 0x44, 0x00, 0x35, 0x08, // ⁄5 (U+2044 U+0035)
  0x20, 0x44, 0x00, 0x36, 0x08, // ⁄6 (U+2044 U+0036)
  0x20, 0x44, 0x00, 0x37, 0x08, // ⁄7 (U+2044 U+0037)
  0x20, 0x44, 0x00, 0x38, 0x08, // ⁄8 (U+2044 U+0038)
  0x20, 0x44, 0x00, 0x39, 0x08, // ⁄9 (U+2044 U+0039)
  
  // Glyph data
  // "!" (U+0021)
  0x0A, 0xD0, 0x50, 0x9D, 0x04, 0x09, 0xD0, 0x40, 0x8D, 0x03, 0x07, 0xD0, 0x30, 0x7D, 0x02, 0x06,
  0xD0, 0x10, 0x5D, 0x01, 0x05, 0xD1, 0x04, 0xD1, 0x04, 0xC8, 0x1E, 0x03, 0xC8, 0x1E, 0x02, 0xC8,
  0x1D, 0x02, 0xC8, 0x1C, 0x01, 0xC0, 0xC2, 0xC0, 0xB2, 0xC0, 0xB2, 0xC0, 0xA2, 0x0E, 0xB0, 0x92,
  0x0D, 0xB0, 0x92, 0x0D, 0xB0, 0x82, 0x0C, 0xB0, 0x72, 0x0B, 0xB0, 0x72, 0x0B, 0xB0, 0x62, 0x0A,
  0xB0, 0x52, 0x0A, 0xB0, 0x52, 0x09, 0xB0, 0x42, 0x08, 0xB0, 0x42, 0x08, 0xB0, 0x32, 0x07, 0xB0,
  0x22, 0x06, 0xB0, 0x27, 0x77, 0x72, 0x82, 0x15, 0x74, 0x20, 0x20, 0xEB, 0x81, 0xB0, 0xAD, 0x06,
  0x0E, 0xD0, 0xAE, 0x0B, 0x0E, 0xD0, 0xA0, 0xBD, 0x81, 0x62, 0xDB, 0x0A, 0x38, 0x15, 0x74, 0x20,
  // """ (U+0022)
  0x05, 0xD0, 0x34, 0x0E, 0xC0, 0xA0, 0x4D, 0x02, 0x40, 0xDC, 0x09, 0x03, 0xD0, 0x14, 0x0C, 0xC0,
  0x80, 0x2D, 0x50, 0xBC, 0x07, 0x01, 0xC0, 0xE5, 0x0A, 0xC0, 0x61, 0xC0, 0xD5, 0x09, 0xC0, 0x51,
  0xC0, 0xC5, 0x08, 0xC8, 0x14, 0x0D, 0xB0, 0xB5, 0x07, 0xC8, 0x13, 0x0C, 0xB0, 0xA5, 0x05, 0xC8,
  0x12, 0x0B, 0xB0, 0x95, 0x04, 0xC8, 0x11, 0x0A, 0xB0, 0x85, 0x03, 0xC2, 0x09, 0xB0, 0x75, 0x02,
  0xB0, 0xE2, 0x08, 0xB0, 0x65, 0x01, 0xB0, 0xD2, 0x07, 0xB0, 0x56, 0xB0, 0xC2, 0x06, 0xB0, 0x46,
  0xB0, 0xB2, 0x05, 0xB0, 0x36, 0x0E, 0xA0, 0xA1,
  // "#" (U+0023)
  0x73, 0x0C, 0xB0, 0x25, 0x01, 0xB0, 0xA7, 0x70, 0xEB, 0x60, 0x4B, 0x07, 0x76, 0x01, 0xB0, 0xD6,
  0x06, 0xB0, 0x57, 0x60, 0x3B, 0x0B, 0x60, 0x8B, 0x03, 0x76, 0x05, 0xB0, 0x86, 0x0B, 0xB0, 0x17,
  0x60, 0x8B, 0x06, 0x60, 0xDA, 0x0E, 0x77, 0x0A, 0xB0, 0x46, 0xB0, 0xC7, 0x70, 0xCB, 0x01, 0x50,
  0x2B, 0x0A, 0x77, 0x0E, 0xA0, 0xE6, 0x05, 0xB0, 0x77, 0x60, 0x1B, 0x0C, 0x60, 0x7B, 0x05, 0x76,
  0x03, 0xB0, 0xA6, 0x09, 0xB0, 0x37, 0x60, 0x5B, 0x07, 0x60, 0xBB, 0x01, 0x60, 0x1F, 0xFF, 0xD8,
  0x1B, 0x01, 0xFF, 0xFD, 0x81, 0xB0, 0x1F, 0xFF, 0xD8, 0x1B, 0x01, 0xFF, 0xFD, 0x0B, 0x28, 0x02,
  0x5B, 0x0D, 0x80, 0x25, 0x0A, 0xB0, 0x98, 0x01, 0x50, 0x37, 0x02, 0xB0, 0xA6, 0x09, 0xB0, 0x47,
  0x60, 0x5B, 0x08, 0x60, 0xBB, 0x02, 0x76, 0x07, 0xB0, 0x56, 0x0E, 0xB7, 0x70, 0x9B, 0x03, 0x6B,
  0x0D, 0x77, 0x0B, 0xB0, 0x15, 0x03, 0xB0, 0xB7, 0x70, 0xEA, 0x0E, 0x60, 0x5B, 0x08, 0x76, 0x01,
  0xB0, 0xC6, 0x07, 0xB0, 0x67, 0x60, 0x3B, 0x0A, 0x60, 0xAB, 0x04, 0x76, 0x05, 0xB0, 0x86, 0x0C,
  0xB0, 0x27, 0x0B, 0xFF, 0xFD, 0x81, 0x30, 0xBF, 0xFF, 0xD8, 0x13, 0x0B, 0xFF, 0xFD, 0x81, 0x30,
  0xBF, 0xFF, 0xD8, 0x13, 0x03, 0x80, 0x15, 0xB0, 0xD8, 0x02, 0x50, 0xAB, 0x09, 0x80, 0x25, 0x01,
  0x60, 0x2B, 0x0A, 0x60, 0x9B, 0x04, 0x76, 0x04, 0xB0, 0x86, 0x0B, 0xB0, 0x27, 0x60, 0x6B, 0x06,
  0x60, 0xDB, 0x77, 0x09, 0xB0, 0x46, 0xB0, 0xD7, 0x70, 0xBB, 0x01, 0x50, 0x2B, 0x0B, 0x77, 0x0D,
  0xB6, 0x05, 0xB0, 0x87, 0x7B, 0x0D, 0x60, 0x7B, 0x06, 0x76, 0x02, 0xB0, 0xA6, 0x09, 0xB0, 0x47,
  0x60, 0x4B, 0x08, 0x60, 0xBB, 0x02, 0x76, 0x06, 0xB0, 0x66, 0x0E, 0xB7, 0x70, 0x8B, 0x04, 0x6B,
  0x0D, 0x77, 0x0B, 0xB0, 0x25, 0x03, 0xB0, 0xA7, 0x30,
  // "$" (U+0024)
  0x73, 0x82, 0x37, 0x75, 0x77, 0x60, 0x7A, 0x0B, 0x77, 0x60, 0x7A, 0x0B, 0x77, 0x60, 0x7A, 0x0B,
  0x77, 0x60, 0x7A, 0x0B, 0x77, 0x48, 0x12, 0x5A, 0xA8, 0x3D, 0x76, 0x41, 0x75, 0x07, 0x0C, 0xFB,
  0x81, 0xD8, 0x27, 0x04, 0x0D, 0xFF, 0x90, 0xA0, 0x24, 0x06, 0xFF, 0xC0, 0x83, 0x04, 0xFF, 0xD0,
  0x23, 0x0E, 0xD8, 0x1B, 0x69, 0xA8, 0x4B, 0x34, 0x7A, 0xEA, 0x0C, 0x30, 0x6C, 0x0E, 0x03, 0x20,
  0x7A, 0x0B, 0x58, 0x14, 0xA6, 0x30, 0xBC, 0x03, 0x30, 0x7A, 0x0B, 0x74, 0xC0, 0xB4, 0x07, 0xA0,
  0xB7, 0x30, 0x1C, 0x07, 0x40, 0x7A, 0x0B, 0x73, 0x02, 0xC0, 0x64, 0x07, 0xA0, 0xB7, 0x30, 0x1C,
  0x07, 0x40, 0x7A, 0x0B, 0x74, 0xC0, 0xA4, 0x07, 0xA0, 0xB7, 0x40, 0xCC, 0x02, 0x30, 0x7A, 0x0B,
  0x74, 0x06, 0xC0, 0xD0, 0x22, 0x07, 0xA0, 0xB7, 0x50, 0xEC, 0x82, 0xE7, 0x17, 0xA0, 0xB7, 0x50,
  0x4F, 0x0D, 0xA0, 0xB7, 0x60, 0x40, 0xEF, 0x90, 0xC0, 0x17, 0x60, 0x20, 0xCF, 0xA0, 0xA0, 0x37,
  0x60, 0x60, 0xDF, 0xA0, 0xB0, 0x37, 0x60, 0x50, 0xBF, 0xA0, 0x97, 0x70, 0x7F, 0xA0, 0xC0, 0x27,
  0x50, 0x7A, 0x0D, 0x0A, 0xE0, 0xD0, 0x17, 0x40, 0x7A, 0x82, 0xB0, 0x2A, 0xD0, 0x97, 0x40, 0x7A,
  0x0B, 0x30, 0x5D, 0x01, 0x73, 0x07, 0xA0, 0xB4, 0x08, 0xC0, 0x67, 0x30, 0x7A, 0x0B, 0x40, 0x1C,
  0x08, 0x73, 0x07, 0xA0, 0xB5, 0x0E, 0xB0, 0xA7, 0x30, 0x7A, 0x0B, 0x50, 0xEB, 0x09, 0x73, 0x07,
  0xA0, 0xB4, 0x01, 0xC0, 0x87, 0x30, 0x7A, 0x0B, 0x40, 0x7C, 0x81, 0x52, 0x77, 0x10, 0x7A, 0x0B,
  0x30, 0x30, 0xEB, 0x85, 0xE0, 0x2F, 0xE9, 0x45, 0x07, 0xA0, 0xB2, 0x06, 0x0E, 0xC8, 0x18, 0x02,
  0xD8, 0x3C, 0x97, 0x69, 0xA8, 0x1D, 0xAE, 0xD0, 0xC2, 0x02, 0xFF, 0xD0, 0xD0, 0x22, 0x02, 0xFF,
  0xC0, 0xB0, 0x14, 0x05, 0x0B, 0xFF, 0x0C, 0x05, 0x72, 0x84, 0x47, 0xAC, 0xEE, 0xB8, 0x2E, 0x96,
  0x27, 0x73, 0x07, 0xA0, 0xB7, 0x76, 0x07, 0xA0, 0xB7, 0x76, 0x07, 0xA0, 0xB7, 0x76, 0x07, 0xA0,
  0xB7, 0x76, 0x07, 0xA0, 0xB7, 0x76, 0x07, 0xA0, 0xB7, 0x76, 0x82, 0x37, 0x75, 0x73,
  // "%" (U+0025)
  0x68, 0x24, 0x66, 0x47, 0x77, 0x75, 0x06, 0x0E, 0xC0, 0xE0, 0x77, 0x60, 0x1C, 0x01, 0x74, 0x07,
  0xF9, 0x09, 0x75, 0x07, 0xB0, 0xA7, 0x40, 0x4F, 0xB0, 0x67, 0x40, 0xDB, 0x03, 0x74, 0x0C, 0xB8,
  0x2E, 0x99, 0xEB, 0x0E, 0x73, 0x04, 0xB0, 0xD7, 0x40, 0x3B, 0x0E, 0x02, 0x20, 0x20, 0xEB, 0x06,
  0x72, 0x0B, 0xB0, 0x67, 0x40, 0x8B, 0x09, 0x40, 0x7B, 0x0B, 0x71, 0x01, 0xB0, 0xE0, 0x17, 0x40,
  0xCB, 0x04, 0x40, 0x2C, 0x71, 0x08, 0xB0, 0x97, 0x5C, 0x01, 0x50, 0xEB, 0x04, 0x70, 0xEB, 0x03,
  0x74, 0x02, 0xB0, 0xE6, 0x0B, 0xB0, 0x66, 0x05, 0xB0, 0xC7, 0x50, 0x4B, 0x0D, 0x60, 0x9B, 0x08,
  0x60, 0xBB, 0x05, 0x75, 0x05, 0xB0, 0xB6, 0x08, 0xB0, 0x95, 0x02, 0xB0, 0xE7, 0x60, 0x5B, 0x0B,
  0x60, 0x8B, 0x0A, 0x50, 0x9B, 0x08, 0x76, 0x06, 0xB0, 0xB6, 0x07, 0xB0, 0xA5, 0x0E, 0xB0, 0x27,
  0x60, 0x6B, 0x0B, 0x60, 0x8B, 0x0A, 0x40, 0x6B, 0x0B, 0x77, 0x05, 0xB0, 0xB6, 0x08, 0xB0, 0x94,
  0x0C, 0xB0, 0x57, 0x70, 0x4B, 0x0C, 0x60, 0x9B, 0x09, 0x30, 0x3B, 0x0D, 0x77, 0x10, 0x3B, 0x0E,
  0x60, 0xBB, 0x07, 0x30, 0x9B, 0x07, 0x38, 0x52, 0x9D, 0xED, 0xB4, 0x6C, 0x60, 0xDB, 0x05, 0x20,
  0x1C, 0x01, 0x20, 0x50, 0xEE, 0x09, 0x50, 0xDB, 0x03, 0x40, 0x1C, 0x02, 0x20, 0x7B, 0x0A, 0x20,
  0x3F, 0xA0, 0x84, 0x09, 0xB0, 0x84, 0x06, 0xB0, 0xD3, 0x0D, 0xB0, 0x42, 0x0D, 0xFB, 0x03, 0x30,
  0x5B, 0x0E, 0x01, 0x20, 0x10, 0xDB, 0x09, 0x20, 0x4B, 0x0D, 0x20, 0x5C, 0x82, 0x50, 0x3D, 0xB0,
  0xB4, 0x0E, 0xB8, 0x2D, 0x66, 0xCC, 0x03, 0x20, 0xAB, 0x07, 0x20, 0xBB, 0x08, 0x30, 0x3C, 0x02,
  0x30, 0x7F, 0xB0, 0xB2, 0x01, 0xC0, 0x12, 0xC0, 0x14, 0x0B, 0xB0, 0x64, 0x0C, 0xF9, 0x0E, 0x01,
  0x20, 0x7B, 0x09, 0x20, 0x3B, 0x0D, 0x50, 0x7B, 0x0A, 0x40, 0x10, 0xCE, 0x0D, 0x03, 0x30, 0xDB,
  0x03, 0x20, 0x6B, 0x0A, 0x50, 0x3B, 0x0D, 0x68, 0x56, 0xCE, 0xEC, 0x71, 0x30, 0x5B, 0x0C, 0x30,
  0x8B, 0x08, 0x50, 0x1C, 0x77, 0x20, 0xBB, 0x06, 0x30, 0xAB, 0x07, 0x6C, 0x02, 0x77, 0x02, 0xB0,
  0xE4, 0x0B, 0xB0, 0x66, 0x0E, 0xB0, 0x37, 0x70, 0x8B, 0x09, 0x40, 0xBB, 0x05, 0x60, 0xEB, 0x04,
  0x77, 0x0E, 0xB0, 0x24, 0x0C, 0xB0, 0x56, 0x0D, 0xB0, 0x47, 0x60, 0x5B, 0x0B, 0x50, 0xBB, 0x05,
  0x60, 0xDB, 0x04, 0x76, 0x0C, 0xB0, 0x55, 0x0B, 0xB0, 0x56, 0x0E, 0xB0, 0x37, 0x50, 0x3B, 0x0E,
  0x60, 0xAB, 0x06, 0x6C, 0x03, 0x75, 0x09, 0xB0, 0x86, 0x09, 0xB0, 0x76, 0xC0, 0x17, 0x50, 0xEB,
  0x02, 0x60, 0x7B, 0x09, 0x50, 0x2B, 0x0E, 0x75, 0x06, 0xB0, 0xB7, 0x04, 0xB0, 0xB5, 0x05, 0xB0,
  0xC7, 0x50, 0xCB, 0x04, 0x70, 0x1B, 0x0E, 0x50, 0x9B, 0x09, 0x74, 0x03, 0xB0, 0xD7, 0x20, 0xCB,
  0x04, 0x40, 0xEB, 0x04, 0x74, 0x0A, 0xB0, 0x77, 0x20, 0x6B, 0x0C, 0x30, 0x7B, 0x0E, 0x74, 0x01,
  0xC0, 0x17, 0x20, 0x10, 0xEB, 0x81, 0xD8, 0xBC, 0x08, 0x74, 0x07, 0xB0, 0xA7, 0x40, 0x6F, 0xA0,
  0xD0, 0x17, 0x40, 0xDB, 0x03, 0x75, 0x0A, 0xF0, 0xE0, 0x37, 0x40, 0x4B, 0x0D, 0x77, 0x08, 0xD0,
  0xC0, 0x37, 0x77, 0x74, 0x83, 0x15, 0x76, 0x36,
  // "&" (U+0026)
  0x72, 0x84, 0x25, 0x77, 0x53, 0x77, 0x72, 0x05, 0x0D, 0xE0, 0xD0, 0x67, 0x76, 0x09, 0xFB, 0x0A,
  0x77, 0x40, 0x9F, 0xD0, 0x97, 0x72, 0x04, 0xE0, 0x0D, 0xE0, 0x37, 0x71, 0x0B, 0xC0, 0xD0, 0x22,
  0x02, 0x0C, 0xC0, 0xA7, 0x70, 0x1D, 0x02, 0x40, 0x10, 0xEB, 0x0E, 0x77, 0x04, 0xC0, 0xB6, 0x0A,
  0xC0, 0x27, 0x60, 0x5C, 0x08, 0x60, 0x7C, 0x03, 0x76, 0x06, 0xC0, 0x76, 0x06, 0xC0, 0x47, 0x60,
  0x5C, 0x08, 0x60, 0x7C, 0x03, 0x76, 0x04, 0xC0, 0x96, 0x09, 0xC0, 0x27, 0x60, 0x2C, 0x0D, 0x60,
  0xCC, 0x77, 0x10, 0xEC, 0x01, 0x40, 0x2C, 0x0B, 0x77, 0x10, 0x9C, 0x07, 0x40, 0x8C, 0x05, 0x77,
  0x10, 0x3C, 0x0E, 0x30, 0x3C, 0x0D, 0x77, 0x30, 0xBC, 0x82, 0x80, 0x2D, 0xC0, 0x47, 0x73, 0x03,
  0xD0, 0x60, 0xDC, 0x08, 0x77, 0x50, 0x9F, 0xA0, 0xB7, 0x76, 0x01, 0x0E, 0xF0, 0xB7, 0x77, 0x10,
  0xAE, 0x0A, 0x77, 0x70, 0x10, 0xBF, 0x06, 0x77, 0x60, 0x10, 0xDF, 0x90, 0xE0, 0x27, 0x74, 0x01,
  0x0D, 0xFB, 0x0C, 0x71, 0x0D, 0xC0, 0x34, 0x0D, 0xD0, 0x70, 0x6D, 0x08, 0x7D, 0x40, 0xAD, 0x06,
  0x20, 0xAD, 0x04, 0x50, 0x2C, 0x0D, 0x30, 0x4D, 0x07, 0x30, 0x10, 0xDC, 0x0E, 0x01, 0x40, 0x6C,
  0x09, 0x30, 0xCC, 0x0B, 0x50, 0x3D, 0x0B, 0x40, 0x9C, 0x05, 0x20, 0x2D, 0x02, 0x60, 0x7D, 0x06,
  0x30, 0xEC, 0x01, 0x20, 0x6C, 0x0C, 0x71, 0x0B, 0xD8, 0x13, 0x03, 0xC0, 0xC3, 0x09, 0xC0, 0x87,
  0x10, 0x10, 0xEC, 0x81, 0xD0, 0xAC, 0x07, 0x30, 0xBC, 0x06, 0x72, 0x04, 0xD0, 0xAD, 0x01, 0x30,
  0xCC, 0x05, 0x73, 0x08, 0xFA, 0x0A, 0x40, 0xCC, 0x05, 0x74, 0x0C, 0xF9, 0x03, 0x40, 0xBC, 0x06,
  0x74, 0x02, 0x0E, 0xE0, 0xA5, 0x0A, 0xC0, 0x97, 0x50, 0x6E, 0x01, 0x50, 0x6C, 0x0E, 0x75, 0x0C,
  0xE0, 0x55, 0x03, 0xD0, 0x67, 0x30, 0xAF, 0x0E, 0x02, 0x50, 0xCC, 0x0E, 0x03, 0x70, 0x20, 0xCF,
  0xA0, 0xD5, 0x05, 0xD8, 0x1E, 0x71, 0x38, 0x12, 0x8E, 0xD0, 0xCD, 0x0A, 0x50, 0xBF, 0x81, 0xDD,
  0xEF, 0x81, 0x80, 0x9D, 0x07, 0x40, 0x10, 0xDF, 0xF0, 0xE0, 0x63, 0x0D, 0xD0, 0x44, 0x01, 0x0C,
  0xFD, 0x0B, 0x02, 0x40, 0x20, 0xEC, 0x0E, 0x01, 0x50, 0x60, 0xCF, 0x90, 0xB0, 0x47, 0x05, 0xD0,
  0xC7, 0x85, 0x15, 0x67, 0x75, 0x37, 0x73,
  // "'" (U+0027)
  0x05, 0xD0, 0x30, 0x4D, 0x02, 0x03, 0xD0, 0x10, 0x2D, 0x10, 0x1C, 0x0E, 0x2C, 0x0D, 0x2C, 0x0C,
  0x20, 0xDB, 0x0B, 0x20, 0xCB, 0x0A, 0x20, 0xBB, 0x09, 0x20, 0xAB, 0x08, 0x20, 0x9B, 0x07, 0x20,
  0x8B, 0x06, 0x20, 0x7B, 0x05, 0x20, 0x6B, 0x04, 0x20, 0x5B, 0x03, 0x10,
  // "(" (U+0028)
  0x71, 0x01, 0x0D, 0xB0, 0x87, 0x10, 0xAB, 0x0D, 0x71, 0x05, 0xC0, 0x47, 0x01, 0x0E, 0xB0, 0xB7,
  0x10, 0x9C, 0x03, 0x70, 0x2C, 0x0A, 0x71, 0x0A, 0xC0, 0x27, 0x02, 0xC0, 0xB7, 0x10, 0x9C, 0x05,
  0x71, 0x0E, 0xB0, 0xD7, 0x10, 0x5C, 0x08, 0x71, 0x0B, 0xC0, 0x37, 0x01, 0xC0, 0xD7, 0x10, 0x5C,
  0x09, 0x71, 0x09, 0xC0, 0x57, 0x10, 0xEC, 0x01, 0x70, 0x2C, 0x0D, 0x71, 0x05, 0xC0, 0xA7, 0x10,
  0x8C, 0x07, 0x71, 0x0A, 0xC0, 0x57, 0x10, 0xCC, 0x03, 0x71, 0x0E, 0xC0, 0x17, 0x1D, 0x71, 0x01,
  0xC0, 0xE7, 0x10, 0x2C, 0x0D, 0x71, 0x03, 0xC0, 0xD7, 0x10, 0x3C, 0x0C, 0x71, 0x03, 0xC0, 0xC7,
  0x10, 0x2C, 0x0D, 0x71, 0x02, 0xC0, 0xD7, 0x10, 0x1C, 0x0E, 0x72, 0xD0, 0x17, 0x10, 0xDC, 0x02,
  0x71, 0x0B, 0xC0, 0x47, 0x10, 0x9C, 0x07, 0x71, 0x06, 0xC0, 0x97, 0x10, 0x3C, 0x0C, 0x72, 0xD7,
  0x20, 0xCC, 0x04, 0x71, 0x07, 0xC0, 0x87, 0x10, 0x3C, 0x0C, 0x72, 0x0D, 0xC0, 0x27, 0x10, 0x8C,
  0x07, 0x71, 0x02, 0xC0, 0xC7, 0x20, 0xBC, 0x03, 0x71, 0x04, 0xC0, 0xA7, 0x20, 0xCC, 0x01, 0x71,
  0x04, 0xC0, 0x87, 0x20, 0xBC, 0x01, 0x71, 0x02, 0xC0, 0x97, 0x20, 0x7C, 0x03, 0x72, 0x0A, 0xB0,
  0xC7, 0x20, 0x10, 0xDB, 0x07,
  // ")" (U+0029)
  0x0D, 0xB0, 0x97, 0x10, 0x5C, 0x04, 0x71, 0x0A, 0xB0, 0xE0, 0x17, 0x02, 0xC0, 0xA7, 0x10, 0x9C,
  0x03, 0x70, 0x1C, 0x0C, 0x71, 0x09, 0xC0, 0x57, 0x02, 0xC0, 0xC7, 0x10, 0xBC, 0x03, 0x70, 0x5C,
  0x0A, 0x71, 0x0E, 0xB0, 0xE7, 0x10, 0xAC, 0x05, 0x70, 0x4C, 0x0A, 0x71, 0xC0, 0xE7, 0x10, 0xCC,
  0x03, 0x70, 0x8C, 0x07, 0x70, 0x4C, 0x0B, 0x70, 0x1C, 0x0E, 0x71, 0x0E, 0xC0, 0x17, 0x0B, 0xC0,
  0x47, 0x09, 0xC0, 0x67, 0x08, 0xC0, 0x77, 0x06, 0xC0, 0x97, 0x05, 0xC0, 0xA7, 0x04, 0xC0, 0xB7,
  0x04, 0xC0, 0xB7, 0x03, 0xC0, 0xC7, 0x03, 0xC0, 0xC7, 0x04, 0xC0, 0xB7, 0x05, 0xC0, 0xB7, 0x05,
  0xC0, 0xA7, 0x07, 0xC0, 0x87, 0x09, 0xC0, 0x67, 0x0B, 0xC0, 0x57, 0x0D, 0xC0, 0x26, 0x01, 0xD7,
  0x04, 0xC0, 0xC7, 0x07, 0xC0, 0x97, 0x0B, 0xC0, 0x57, 0xD0, 0x16, 0x04, 0xC0, 0xC7, 0x09, 0xC0,
  0x77, 0x0E, 0xC0, 0x16, 0x04, 0xC0, 0xB7, 0x0A, 0xC0, 0x56, 0x01, 0xC0, 0xD7, 0x08, 0xC0, 0x66,
  0x01, 0x0E, 0xB0, 0xD7, 0x08, 0xC0, 0x46, 0x01, 0x0E, 0xB0, 0xA7, 0x09, 0xB0, 0xE0, 0x16, 0x04,
  0xC0, 0x57, 0x0D, 0xB0, 0x97, 0x10,
  // "*" (U+002A)
  0x71, 0x05, 0xC0, 0xD7, 0x73, 0x03, 0xC0, 0xB7, 0x73, 0x01, 0xC0, 0x97, 0x74, 0xC0, 0x87, 0x74,
  0x0D, 0xB0, 0x67, 0x74, 0x0C, 0xB0, 0x47, 0x30, 0x50, 0x16, 0x0A, 0xB0, 0x36, 0x04, 0x03, 0x2A,
  0x81, 0xC8, 0x33, 0x09, 0xB0, 0x12, 0x86, 0x15, 0xAE, 0xF9, 0x02, 0xD8, 0x2E, 0x95, 0x8B, 0x81,
  0x27, 0xCD, 0x81, 0xB0, 0x5F, 0xFE, 0x81, 0xE0, 0x8F, 0xFF, 0x85, 0x15, 0x89, 0xBC, 0xDF, 0xB8,
  0x5E, 0xDB, 0xA9, 0x81, 0x70, 0x10, 0xDD, 0x06, 0x77, 0x10, 0x8E, 0x0E, 0x01, 0x76, 0x04, 0xB0,
  0xE0, 0x8B, 0x0C, 0x75, 0x01, 0x0E, 0xB8, 0x17, 0x0E, 0xB0, 0x87, 0x40, 0xBB, 0x82, 0xE1, 0x07,
  0xC0, 0x57, 0x20, 0x7C, 0x08, 0x20, 0x10, 0xEB, 0x0E, 0x02, 0x70, 0x3D, 0x01, 0x30, 0x8C, 0x0C,
  0x70, 0xCC, 0x09, 0x40, 0x10, 0xEC, 0x07, 0x60, 0x10, 0x9B, 0x02, 0x50, 0x8A, 0x0D, 0x05, 0x72,
  0x81, 0x2B, 0x96, 0x81, 0x1E, 0x76,
  // "+" (U+002B)
  0x73, 0x0E, 0xB0, 0x47, 0x76, 0x0E, 0xB0, 0x47, 0x76, 0x0E, 0xB0, 0x47, 0x76, 0x0E, 0xB0, 0x47,
  0x76, 0x0E, 0xB0, 0x47, 0x76, 0x0E, 0xB0, 0x47, 0x76, 0x0E, 0xB0, 0x47, 0x76, 0x0E, 0xB0, 0x47,
  0x76, 0x0E, 0xB0, 0x47, 0x76, 0x0E, 0xB0, 0x47, 0x76, 0x0E, 0xB0, 0x47, 0x76, 0x0E, 0xB0, 0x47,
  0x30, 0x48, 0x05, 0x50, 0xEB, 0x07, 0x80, 0x55, 0x10, 0xDF, 0xFF, 0xA0, 0x10, 0xDF, 0xFF, 0xA0,
  0x10, 0xDF, 0xFF, 0xA0, 0x10, 0xDF, 0xFF, 0xA0, 0x17, 0x30, 0xEB, 0x04, 0x77, 0x60, 0xEB, 0x04,
  0x77, 0x60, 0xEB, 0x04, 0x77, 0x60, 0xEB, 0x04, 0x77, 0x60, 0xEB, 0x04, 0x77, 0x60, 0xEB, 0x04,
  0x77, 0x60, 0xEB, 0x04, 0x77, 0x60, 0xEB, 0x04, 0x77, 0x60, 0xEB, 0x04, 0x77, 0x60, 0xEB, 0x04,
  0x77, 0x60, 0xEB, 0x04, 0x77, 0x60, 0xEB, 0x04, 0x73,
  // "," (U+002C)
  0x3D, 0x08, 0x20, 0x2D, 0x08, 0x20, 0x4D, 0x04, 0x20, 0x6D, 0x30, 0x9C, 0x0B, 0x30, 0xBC, 0x06,
  0x30, 0xEC, 0x02, 0x20, 0x1C, 0x0D, 0x30, 0x4C, 0x07, 0x30, 0x7C, 0x02, 0x30, 0xAB, 0x0C, 0x40,
  0xDB, 0x06, 0x30, 0x2B, 0x0E, 0x01, 0x30, 0x5B, 0x09, 0x40, 0x9B, 0x03, 0x40,
  // "-" (U+002D)
  0x18, 0x09, 0x15, 0x00, 0x2F, 0xE0, 0x70, 0x2F, 0xE0, 0x70, 0x2F, 0xE0, 0x70, 0x2F, 0xE0, 0x70,
  // "." (U+002E)
  0x28, 0x21, 0x56, 0x33, 0x04, 0x0E, 0xB0, 0x92, 0x0D, 0xD0, 0x30, 0x2E, 0x07, 0x03, 0xE0, 0x80,
  0x2E, 0x81, 0x70, 0xDD, 0x82, 0x30, 0x4E, 0xB0, 0x83, 0x82, 0x16, 0x63, 0x20,
  // "/" (U+002F)
  0x77, 0x10, 0x6C, 0x05, 0x77, 0x10, 0xBB, 0x0E, 0x77, 0x10, 0x2C, 0x09, 0x77, 0x10, 0x7C, 0x04,
  0x77, 0x10, 0xDB, 0x0D, 0x77, 0x10, 0x3C, 0x08, 0x77, 0x10, 0x9C, 0x02, 0x77, 0x10, 0xEB, 0x0C,
  0x77, 0x10, 0x5C, 0x06, 0x77, 0x10, 0xAC, 0x01, 0x77, 0x01, 0xC0, 0xA7, 0x71, 0x06, 0xC0, 0x57,
  0x71, 0x0C, 0xB0, 0xE7, 0x71, 0x02, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x37, 0x71, 0x0D, 0xB0, 0xD7,
  0x71, 0x04, 0xC0, 0x77, 0x71, 0x0A, 0xC0, 0x17, 0x71, 0x0E, 0xB0, 0xB7, 0x71, 0x06, 0xC0, 0x67,
  0x71, 0x0B, 0xB0, 0xE7, 0x71, 0x02, 0xC0, 0xA7, 0x71, 0x07, 0xC0, 0x47, 0x71, 0x0D, 0xB0, 0xE7,
  0x71, 0x03, 0xC0, 0x87, 0x71, 0x09, 0xC0, 0x27, 0x71, 0x0E, 0xB0, 0xC7, 0x71, 0x05, 0xC0, 0x77,
  0x71, 0x0B, 0xC0, 0x17, 0x70, 0x1C, 0x0B, 0x77, 0x10, 0x6C, 0x05, 0x77, 0x10, 0xCB, 0x0E, 0x77,
  0x10, 0x2C, 0x09, 0x77, 0x10, 0x8C, 0x03, 0x77, 0x10, 0xEB, 0x0D, 0x77, 0x10, 0x4C, 0x08, 0x77,
  0x10, 0xAC, 0x02, 0x77, 0x10, 0xEB, 0x0C, 0x77, 0x10, 0x6C, 0x06, 0x77, 0x10, 0xBC, 0x01, 0x77,
  0x02, 0xC0, 0xA7, 0x71, 0x07, 0xC0, 0x47, 0x71, 0x0D, 0xB0, 0xE7, 0x72,
  // "0" (U+0030)
  0x72, 0x84, 0x25, 0x77, 0x63, 0x77, 0x20, 0x60, 0xDE, 0x0D, 0x07, 0x75, 0x01, 0x0B, 0xFB, 0x0C,
  0x02, 0x72, 0x01, 0x0D, 0xFD, 0x0D, 0x01, 0x71, 0x0A, 0xE0, 0x0D, 0xE0, 0xC7, 0x05, 0xD0, 0xA0,
  0x22, 0x01, 0x08, 0xD0, 0x76, 0x0D, 0xC0, 0xA6, 0x07, 0xC0, 0xE5, 0x04, 0xC0, 0xE7, 0x10, 0xBC,
  0x06, 0x40, 0x9C, 0x07, 0x71, 0x04, 0xC0, 0xC4, 0x0E, 0xC0, 0x17, 0x20, 0xEC, 0x02, 0x20, 0x3C,
  0x0D, 0x73, 0x09, 0xC0, 0x62, 0x06, 0xC0, 0x97, 0x30, 0x5C, 0x0A, 0x20, 0x9C, 0x06, 0x73, 0x03,
  0xC0, 0xD2, 0x0C, 0xC0, 0x47, 0x4D, 0x20, 0xEC, 0x02, 0x74, 0x0D, 0xC0, 0x20, 0x1D, 0x75, 0x0C,
  0xC0, 0x40, 0x2C, 0x0E, 0x75, 0x0A, 0xC0, 0x60, 0x3C, 0x0D, 0x75, 0x09, 0xC0, 0x70, 0x4C, 0x0C,
  0x75, 0x08, 0xC0, 0x80, 0x5C, 0x0C, 0x75, 0x08, 0xC0, 0x90, 0x6C, 0x0B, 0x75, 0x07, 0xC0, 0xA0,
  0x6C, 0x0B, 0x75, 0x07, 0xC0, 0xA0, 0x6C, 0x0B, 0x75, 0x07, 0xC0, 0xA0, 0x6C, 0x0B, 0x75, 0x07,
  0xC0, 0xA0, 0x5C, 0x0B, 0x75, 0x07, 0xC0, 0xA0, 0x5C, 0x0C, 0x75, 0x08, 0xC0, 0x90, 0x5C, 0x0C,
  0x75, 0x08, 0xC0, 0x80, 0x4C, 0x0D, 0x75, 0x09, 0xC0, 0x70, 0x2C, 0x0E, 0x75, 0x0A, 0xC0, 0x60,
  0x1D, 0x75, 0x0C, 0xC0, 0x41, 0xD0, 0x17, 0x40, 0xDC, 0x81, 0x20, 0xDC, 0x03, 0x74, 0xD2, 0x0B,
  0xC0, 0x67, 0x30, 0x2C, 0x0D, 0x20, 0x8C, 0x09, 0x73, 0x05, 0xC0, 0xA2, 0x04, 0xC0, 0xC7, 0x30,
  0x9C, 0x06, 0x20, 0x1D, 0x01, 0x72, 0x0D, 0xC0, 0x23, 0x0B, 0xC0, 0x77, 0x10, 0x4C, 0x0C, 0x40,
  0x6C, 0x0E, 0x71, 0x0B, 0xC0, 0x75, 0x0E, 0xC0, 0x96, 0x07, 0xD0, 0x15, 0x07, 0xD0, 0xA0, 0x22,
  0x01, 0x08, 0xD0, 0x87, 0x0C, 0xE0, 0x0D, 0xE0, 0xD7, 0x10, 0x20, 0xEF, 0xD0, 0xE0, 0x37, 0x20,
  0x20, 0xCF, 0xB0, 0xD0, 0x37, 0x50, 0x70, 0xDE, 0x81, 0xE8, 0x17, 0x71, 0x84, 0x25, 0x77, 0x63,
  0x72,
  // "1" (U+0031)
  0x72, 0x03, 0x0E, 0xB0, 0xB7, 0x10, 0x30, 0xEC, 0x0B, 0x70, 0x30, 0xED, 0x0B, 0x60, 0x40, 0xEE,
  0x0B, 0x50, 0x4F, 0x90, 0xB4, 0x05, 0xFA, 0x0B, 0x30, 0x5D, 0x0C, 0xC0, 0xB2, 0x06, 0xD0, 0xC0,
  0x3C, 0x81, 0xB0, 0x6D, 0x81, 0xC1, 0x2C, 0x0B, 0x06, 0xD8, 0x2C, 0x10, 0x3C, 0x81, 0xB3, 0xEB,
  0x0B, 0x30, 0x4C, 0x81, 0xB0, 0x4A, 0x09, 0x40, 0x4C, 0x0B, 0x20, 0x60, 0x85, 0x04, 0xC0, 0xB7,
  0x20, 0x4C, 0x0B, 0x72, 0x04, 0xC0, 0xB7, 0x20, 0x4C, 0x0B, 0x72, 0x04, 0xC0, 0xB7, 0x20, 0x4C,
  0x0B, 0x72, 0x04, 0xC0, 0xB7, 0x20, 0x4C, 0x0B, 0x72, 0x04, 0xC0, 0xB7, 0x20, 0x4C, 0x0B, 0x72,
  0x04, 0xC0, 0xB7, 0x20, 0x4C, 0x0B, 0x72, 0x04, 0xC0, 0xB7, 0x20, 0x4C, 0x0B, 0x72, 0x04, 0xC0,
  0xB7, 0x20, 0x4C, 0x0B, 0x72, 0x04, 0xC0, 0xB7, 0x20, 0x4C, 0x0B, 0x72, 0x04, 0xC0, 0xB7, 0x20,
  0x4C, 0x0B, 0x72, 0x04, 0xC0, 0xB7, 0x20, 0x4C, 0x0B, 0x72, 0x04, 0xC0, 0xB7, 0x20, 0x4C, 0x0B,
  0x72, 0x04, 0xC0, 0xB7, 0x20, 0x4C, 0x0B, 0x72, 0x04, 0xC0, 0xB7, 0x20, 0x4C, 0x0B, 0x72, 0x04,
  0xC0, 0xB7, 0x20, 0x4C, 0x0B, 0x72, 0x04, 0xC0, 0xB0,
  // "2" (U+0032)
  0x78, 0x61, 0x46, 0x77, 0x64, 0x17, 0x70, 0x60, 0xCF, 0x90, 0xC0, 0x67, 0x30, 0x60, 0xEF, 0xD0,
  0xD0, 0x26, 0x02, 0x0C, 0xFF, 0x90, 0xE0, 0x44, 0x02, 0x0E, 0xF9, 0x00, 0xDF, 0x0E, 0x02, 0x40,
  0xCC, 0x81, 0xE8, 0x24, 0x04, 0x0C, 0xD0, 0xB4, 0x02, 0xB0, 0x90, 0x17, 0x10, 0xAD, 0x04, 0x48,
  0x16, 0xF6, 0x74, 0x0D, 0xC0, 0xA5, 0x03, 0x75, 0x06, 0xC0, 0xE7, 0x74, 0x01, 0xD0, 0x17, 0x74,
  0x0E, 0xC0, 0x37, 0x74, 0x0D, 0xC0, 0x47, 0x74, 0x0E, 0xC0, 0x37, 0x74, 0xD0, 0x27, 0x73, 0x01,
  0xD0, 0x17, 0x73, 0x05, 0xC0, 0xE7, 0x74, 0x08, 0xC0, 0xA7, 0x74, 0x0D, 0xC0, 0x67, 0x73, 0x04,
  0xD0, 0x17, 0x73, 0x0B, 0xC0, 0xA7, 0x73, 0x04, 0xD0, 0x47, 0x73, 0x0C, 0xC0, 0xB7, 0x73, 0x07,
  0xD0, 0x37, 0x72, 0x02, 0xD0, 0x97, 0x73, 0x0C, 0xC0, 0xD7, 0x73, 0x08, 0xD0, 0x47, 0x72, 0x04,
  0xD0, 0x87, 0x72, 0x01, 0x0E, 0xC0, 0xC7, 0x73, 0x0B, 0xC0, 0xE0, 0x17, 0x72, 0x08, 0xD0, 0x47,
  0x72, 0x04, 0xD0, 0x77, 0x72, 0x01, 0x0E, 0xC0, 0xB7, 0x73, 0x0C, 0xC0, 0xD0, 0x17, 0x72, 0x08,
  0xD0, 0x37, 0x72, 0x04, 0xD0, 0x67, 0x72, 0x01, 0x0E, 0xC0, 0x97, 0x73, 0x0C, 0xC0, 0xC7, 0x73,
  0x08, 0xC0, 0xE0, 0x17, 0x72, 0x04, 0xD0, 0x47, 0x72, 0x01, 0x0E, 0xC0, 0xB8, 0x09, 0x45, 0x01,
  0x0A, 0xFF, 0xF9, 0x05, 0x0B, 0xFF, 0xF9, 0x05, 0x0B, 0xFF, 0xF9, 0x05, 0x0B, 0xFF, 0xF9, 0x05,
  // "3" (U+0033)
  0x78, 0x61, 0x46, 0x77, 0x65, 0x27, 0x68, 0x11, 0x7D, 0xF9, 0x81, 0xE8, 0x17, 0x10, 0x10, 0x9F,
  0xF0, 0x66, 0x05, 0x0E, 0xFF, 0xA0, 0x84, 0x06, 0xFA, 0x81, 0xDD, 0xEF, 0x06, 0x30, 0x10, 0xEC,
  0x81, 0xC6, 0x14, 0x03, 0x0B, 0xD0, 0xE0, 0x13, 0x05, 0xA0, 0xE0, 0x57, 0x20, 0x7D, 0x08, 0x48,
  0x1A, 0xB1, 0x74, 0x0A, 0xC0, 0xD7, 0x74, 0x03, 0xD0, 0x17, 0x74, 0x0E, 0xC0, 0x37, 0x74, 0x0C,
  0xC0, 0x47, 0x74, 0x0B, 0xC0, 0x57, 0x74, 0x0C, 0xC0, 0x37, 0x74, 0x0E, 0xC0, 0x17, 0x73, 0x03,
  0xC0, 0xD7, 0x74, 0x0A, 0xC0, 0x77, 0x73, 0x04, 0xC0, 0xE0, 0x17, 0x72, 0x03, 0x0E, 0xC0, 0x67,
  0x71, 0x01, 0x08, 0xD0, 0x97, 0x28, 0x52, 0x55, 0x56, 0x7B, 0xE0, 0x77, 0x30, 0x7F, 0xB0, 0xB0,
  0x37, 0x40, 0x7F, 0x90, 0xE0, 0x47, 0x60, 0x7F, 0xB8, 0x1D, 0x71, 0x73, 0x07, 0xFD, 0x0E, 0x04,
  0x76, 0x83, 0x12, 0x47, 0xDE, 0x06, 0x77, 0x30, 0x40, 0xDD, 0x04, 0x77, 0x30, 0x10, 0xDC, 0x0D,
  0x77, 0x40, 0x2D, 0x06, 0x77, 0x40, 0x9C, 0x0C, 0x77, 0x40, 0x4D, 0x77, 0x40, 0x1D, 0x02, 0x77,
  0x4D, 0x03, 0x77, 0x30, 0x1D, 0x03, 0x77, 0x30, 0x2D, 0x02, 0x77, 0x30, 0x5D, 0x01, 0x77, 0x30,
  0x9C, 0x0D, 0x77, 0x30, 0x1D, 0x81, 0x90, 0x17, 0x71, 0x0B, 0xD8, 0x33, 0x09, 0xC4, 0x75, 0x0A,
  0xD0, 0xB2, 0x09, 0xA8, 0x2E, 0x95, 0x25, 0x81, 0x26, 0xDD, 0x0E, 0x02, 0x20, 0x9F, 0x82, 0xED,
  0xDE, 0xF9, 0x05, 0x30, 0x9F, 0xFC, 0x06, 0x40, 0x6F, 0xFA, 0x0C, 0x03, 0x68, 0x21, 0x6B, 0xEF,
  0xA8, 0x1E, 0xA4, 0x75, 0x87, 0x24, 0x66, 0x77, 0x65, 0x37, 0x30,
  // "4" (U+0034)
  0x77, 0x10, 0x3D, 0x05, 0x77, 0x60, 0xBD, 0x05, 0x77, 0x50, 0x5E, 0x05, 0x77, 0x50, 0xDE, 0x05,
  0x77, 0x40, 0x6F, 0x05, 0x77, 0x40, 0xEF, 0x05, 0x77, 0x30, 0x7B, 0x0C, 0xC0, 0x57, 0x72, 0x01,
  0x0E, 0xA0, 0xE0, 0x7C, 0x05, 0x77, 0x20, 0x9B, 0x08, 0x07, 0xC0, 0x57, 0x71, 0x02, 0xC0, 0x20,
  0x8C, 0x05, 0x77, 0x10, 0xAB, 0x81, 0xA0, 0x8C, 0x05, 0x77, 0x03, 0xC8, 0x12, 0x08, 0xC0, 0x57,
  0x70, 0xCB, 0x09, 0x20, 0x9C, 0x05, 0x76, 0x05, 0xC0, 0x12, 0x09, 0xC0, 0x57, 0x60, 0xDB, 0x08,
  0x30, 0x9C, 0x05, 0x75, 0x06, 0xB0, 0xE0, 0x13, 0x09, 0xC0, 0x57, 0x50, 0xEB, 0x07, 0x40, 0x9C,
  0x05, 0x74, 0x08, 0xB0, 0xE5, 0x09, 0xC0, 0x57, 0x30, 0x10, 0xEB, 0x06, 0x50, 0x9C, 0x05, 0x73,
  0x09, 0xB0, 0xD6, 0x09, 0xC0, 0x57, 0x20, 0x2C, 0x05, 0x60, 0x9C, 0x05, 0x72, 0x0A, 0xB0, 0xC7,
  0x09, 0xC0, 0x57, 0x10, 0x3C, 0x04, 0x70, 0x9C, 0x05, 0x71, 0x0C, 0xB0, 0xB7, 0x10, 0x9C, 0x05,
  0x70, 0x5C, 0x03, 0x71, 0x09, 0xC0, 0x57, 0x0D, 0xB0, 0xA7, 0x20, 0x9C, 0x05, 0x60, 0x6C, 0x02,
  0x72, 0x09, 0xC0, 0x56, 0x0E, 0xB0, 0x87, 0x30, 0x9C, 0x05, 0x50, 0x8B, 0x0E, 0x01, 0x73, 0x09,
  0xC0, 0x55, 0x0E, 0xFF, 0xFC, 0x05, 0x0E, 0xFF, 0xFC, 0x05, 0x0E, 0xFF, 0xFC, 0x05, 0x0E, 0xFF,
  0xFC, 0x05, 0x04, 0x80, 0x93, 0x50, 0xBC, 0x84, 0x95, 0x55, 0x51, 0x77, 0x20, 0x9C, 0x05, 0x77,
  0x70, 0x9C, 0x05, 0x77, 0x70, 0x9C, 0x05, 0x77, 0x70, 0x9C, 0x05, 0x77, 0x70, 0x9C, 0x05, 0x77,
  0x70, 0x9C, 0x05, 0x77, 0x70, 0x9C, 0x05, 0x77, 0x70, 0x9C, 0x05, 0x77, 0x70, 0x9C, 0x05, 0x50,
  // "5" (U+0035)
  0x20, 0xEF, 0xFA, 0x0E, 0x5F, 0xFB, 0x0E, 0x40, 0x1F, 0xFB, 0x0E, 0x40, 0x2F, 0xFB, 0x0E, 0x40,
  0x3C, 0x09, 0x80, 0x90, 0x50, 0x44, 0x04, 0xC0, 0x57, 0x73, 0x05, 0xC0, 0x47, 0x73, 0x06, 0xC0,
  0x37, 0x73, 0x07, 0xC0, 0x27, 0x73, 0x08, 0xC7, 0x74, 0x09, 0xC7, 0x74, 0x0A, 0xB0, 0xE7, 0x74,
  0x0B, 0xB0, 0xD7, 0x74, 0x0C, 0xB0, 0xC7, 0x74, 0x0D, 0xB0, 0xB7, 0x74, 0xC0, 0x97, 0x74, 0xC0,
  0x82, 0x84, 0x23, 0x44, 0x21, 0x72, 0x01, 0xC0, 0x0D, 0xF8, 0x1C, 0x71, 0x60, 0x2F, 0xF9, 0x0E,
  0x06, 0x50, 0x3F, 0xFB, 0x09, 0x40, 0x10, 0xCF, 0xFB, 0x09, 0x58, 0x4B, 0xEA, 0x63, 0x12, 0x82,
  0x14, 0x8E, 0xE0, 0x57, 0x72, 0x09, 0xD0, 0xD7, 0x73, 0x08, 0xD0, 0x57, 0x73, 0x0D, 0xC0, 0xB7,
  0x73, 0x06, 0xD7, 0x73, 0x01, 0xD0, 0x37, 0x73, 0x0D, 0xC0, 0x47, 0x73, 0x0C, 0xC0, 0x57, 0x73,
  0x0B, 0xC0, 0x67, 0x73, 0x0C, 0xC0, 0x57, 0x73, 0x0D, 0xC0, 0x47, 0x72, 0x01, 0xD0, 0x27, 0x72,
  0x05, 0xC0, 0xE7, 0x73, 0x0B, 0xC0, 0xA7, 0x72, 0x04, 0xD8, 0x15, 0x01, 0x76, 0x01, 0x0D, 0xC0,
  0xD2, 0x81, 0xC9, 0x27, 0x30, 0x20, 0xDD, 0x06, 0x20, 0xCA, 0x81, 0xB6, 0x35, 0x03, 0x08, 0xE0,
  0xB3, 0x0C, 0xE8, 0x1E, 0xDD, 0xF9, 0x0D, 0x01, 0x30, 0xCF, 0xFA, 0x0C, 0x01, 0x40, 0xAF, 0xF9,
  0x09, 0x78, 0x13, 0x9D, 0xFA, 0x81, 0xD9, 0x27, 0x48, 0x71, 0x35, 0x67, 0x75, 0x42, 0x73,
  // "6" (U+0036)
  0x76, 0x85, 0x35, 0x67, 0x65, 0x37, 0x70, 0x50, 0xBF, 0xA0, 0x37, 0x30, 0x40, 0xDF, 0xC0, 0x37,
  0x20, 0x8F, 0xE0, 0x37, 0x10, 0x8F, 0x90, 0xFD, 0xB0, 0x37, 0x06, 0xE0, 0xA0, 0x45, 0x81, 0x26,
  0x16, 0x02, 0xD0, 0xD0, 0x37, 0x72, 0x0B, 0xC0, 0xD0, 0x17, 0x72, 0x03, 0xD0, 0x27, 0x73, 0x0B,
  0xC0, 0x87, 0x73, 0x01, 0xD0, 0x17, 0x73, 0x06, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x47, 0x74, 0x0E,
  0xB0, 0xE7, 0x74, 0x02, 0xC0, 0xA7, 0x74, 0x05, 0xC0, 0x77, 0x74, 0x08, 0xC0, 0x55, 0x82, 0x34,
  0x42, 0x72, 0x0A, 0xC0, 0x22, 0x02, 0x0A, 0xD8, 0x1E, 0x91, 0x60, 0xCC, 0x20, 0x5F, 0xA0, 0xE0,
  0x55, 0x0D, 0xB8, 0x1E, 0x06, 0xFD, 0x05, 0x4C, 0x0D, 0x02, 0xFF, 0x03, 0x3C, 0x0D, 0x0B, 0xA8,
  0x5C, 0x51, 0x01, 0x4B, 0xD0, 0xC2, 0x01, 0xF0, 0xA7, 0x09, 0xD8, 0x14, 0x02, 0xE0, 0xB7, 0x20,
  0xCC, 0x81, 0xA0, 0x2E, 0x02, 0x72, 0x04, 0xC8, 0x1E, 0x02, 0xD0, 0xA7, 0x40, 0xEC, 0x03, 0x02,
  0xD0, 0x57, 0x40, 0xAC, 0x06, 0x02, 0xD0, 0x27, 0x40, 0x7C, 0x08, 0x01, 0xD0, 0x17, 0x40, 0x5C,
  0x0A, 0x1D, 0x01, 0x74, 0x05, 0xC8, 0x1B, 0x0E, 0xC0, 0x27, 0x40, 0x4C, 0x81, 0xB0, 0xCC, 0x04,
  0x74, 0x05, 0xC8, 0x1A, 0x09, 0xC0, 0x67, 0x40, 0x6C, 0x81, 0x90, 0x6C, 0x09, 0x74, 0x08, 0xC8,
  0x17, 0x03, 0xC0, 0xD7, 0x40, 0xAC, 0x04, 0x20, 0xEC, 0x03, 0x73, 0x0E, 0xC0, 0x12, 0x08, 0xC0,
  0xA7, 0x20, 0x4C, 0x0C, 0x30, 0x2D, 0x04, 0x71, 0x0C, 0xC0, 0x74, 0x0A, 0xC0, 0xD0, 0x16, 0x09,
  0xC0, 0xE5, 0x02, 0x0E, 0xC0, 0xD0, 0x43, 0x03, 0x0B, 0xD0, 0x76, 0x06, 0xE8, 0x1E, 0xDE, 0xE0,
  0xC7, 0x10, 0x8F, 0xE0, 0xD0, 0x17, 0x20, 0x6F, 0xC0, 0xB0, 0x17, 0x40, 0x20, 0x9F, 0x0C, 0x05,
  0x77, 0x28, 0x44, 0x67, 0x65, 0x27, 0x10,
  // "7" (U+0037)
  0x0E, 0xFF, 0xF9, 0x00, 0xEF, 0xFF, 0x90, 0x0E, 0xFF, 0xF9, 0x00, 0xEF, 0xFF, 0x90, 0xD0, 0x48,
  0x09, 0x55, 0x09, 0xC0, 0x97, 0x74, 0x0B, 0xC0, 0x37, 0x73, 0x01, 0xC0, 0xD7, 0x74, 0x07, 0xC0,
  0x77, 0x74, 0x0D, 0xC0, 0x27, 0x73, 0x03, 0xC0, 0xC7, 0x74, 0x09, 0xC0, 0x67, 0x74, 0x0E, 0xC0,
  0x17, 0x73, 0x05, 0xC0, 0xB7, 0x74, 0x0A, 0xC0, 0x57, 0x73, 0x01, 0xC0, 0xE7, 0x74, 0x06, 0xC0,
  0x97, 0x74, 0x0C, 0xC0, 0x47, 0x73, 0x02, 0xC0, 0xE7, 0x74, 0x08, 0xC0, 0x87, 0x74, 0x0E, 0xC0,
  0x37, 0x73, 0x04, 0xC0, 0xD7, 0x74, 0x0A, 0xC0, 0x77, 0x73, 0x01, 0xD0, 0x17, 0x73, 0x06, 0xC0,
  0xB7, 0x74, 0x0C, 0xC0, 0x67, 0x73, 0x02, 0xD0, 0x17, 0x73, 0x08, 0xC0, 0xA7, 0x74, 0x0D, 0xC0,
  0x57, 0x73, 0x04, 0xC0, 0xE7, 0x74, 0x09, 0xC0, 0x97, 0x74, 0x0E, 0xC0, 0x37, 0x73, 0x05, 0xC0,
  0xD7, 0x74, 0x0B, 0xC0, 0x87, 0x73, 0x01, 0xD0, 0x27, 0x73, 0x07, 0xC0, 0xC7, 0x74, 0x0D, 0xC0,
  0x77, 0x73, 0x03, 0xD0, 0x17, 0x73, 0x09, 0xC0, 0xB7, 0x74, 0x0E, 0xC0, 0x57, 0x73, 0x05, 0xD7,
  0x74, 0x0B, 0xC0, 0xA7, 0x73, 0x01, 0xD0, 0x47, 0x73, 0x07, 0xC0, 0xE7, 0x70,
  // "8" (U+0038)
  0x72, 0x85, 0x35, 0x67, 0x64, 0x17, 0x78, 0x13, 0xAE, 0xF0, 0xD0, 0x67, 0x40, 0x9F, 0xD0, 0xD0,
  0x37, 0x10, 0xCF, 0xF9, 0x04, 0x60, 0xBF, 0x81, 0xDD, 0xEE, 0x0E, 0x02, 0x40, 0x5D, 0x0E, 0x06,
  0x40, 0x40, 0xCD, 0x0B, 0x40, 0xCC, 0x0D, 0x01, 0x70, 0xAD, 0x03, 0x20, 0x2D, 0x03, 0x72, 0x0D,
  0xC0, 0x82, 0x05, 0xC0, 0xC7, 0x30, 0x7C, 0x0B, 0x20, 0x7C, 0x08, 0x73, 0x03, 0xC0, 0xD2, 0x08,
  0xC0, 0x67, 0x30, 0x1C, 0x0E, 0x20, 0x8C, 0x06, 0x73, 0x01, 0xC0, 0xD2, 0x06, 0xC0, 0x87, 0x30,
  0x3C, 0x0C, 0x20, 0x3C, 0x0B, 0x73, 0x07, 0xC0, 0x93, 0x0E, 0xC0, 0x27, 0x20, 0xDC, 0x04, 0x30,
  0x8C, 0x0B, 0x71, 0x07, 0xC0, 0xD4, 0x01, 0x0E, 0xC0, 0x96, 0x04, 0xD0, 0x45, 0x05, 0xD0, 0xA4,
  0x06, 0xD0, 0x97, 0x09, 0xD8, 0x2D, 0x31, 0xAD, 0x0A, 0x72, 0x09, 0xE0, 0xED, 0x0A, 0x74, 0x08,
  0xFA, 0x0E, 0x06, 0x76, 0x07, 0xF9, 0x03, 0x76, 0x07, 0xFA, 0x0E, 0x05, 0x73, 0x01, 0x0B, 0xD0,
  0xEE, 0x09, 0x71, 0x01, 0x0D, 0xD8, 0x27, 0x06, 0xED, 0x0C, 0x01, 0x50, 0x10, 0xDC, 0x0D, 0x03,
  0x30, 0x10, 0xBD, 0x0C, 0x01, 0x40, 0xAC, 0x0D, 0x01, 0x60, 0x7D, 0x0C, 0x30, 0x5C, 0x0E, 0x02,
  0x71, 0x06, 0xD0, 0x82, 0x0C, 0xC0, 0x67, 0x30, 0x8D, 0x01, 0x02, 0xC0, 0xE7, 0x50, 0xDC, 0x07,
  0x06, 0xC0, 0xA7, 0x50, 0x6C, 0x0B, 0x09, 0xC0, 0x67, 0x50, 0x2C, 0x0E, 0x0A, 0xC0, 0x57, 0x6D,
  0x0A, 0xC0, 0x57, 0x6D, 0x09, 0xC0, 0x67, 0x50, 0x2C, 0x0E, 0x08, 0xC0, 0x97, 0x50, 0x5C, 0x0C,
  0x04, 0xC0, 0xE7, 0x50, 0xBC, 0x08, 0x1D, 0x08, 0x73, 0x04, 0xD8, 0x14, 0x09, 0xD0, 0x67, 0x10,
  0x30, 0xEC, 0x0C, 0x20, 0x1E, 0x0A, 0x03, 0x40, 0x20, 0x8E, 0x04, 0x30, 0x5F, 0x98, 0x1D, 0xDE,
  0xF0, 0x85, 0x07, 0xFF, 0xA0, 0x97, 0x04, 0x0E, 0xFD, 0x0E, 0x06, 0x73, 0x06, 0x0C, 0xF9, 0x81,
  0xD8, 0x17, 0x78, 0x54, 0x56, 0x76, 0x52, 0x71,
  // "9" (U+0039)
  0x71, 0x85, 0x14, 0x67, 0x75, 0x27, 0x71, 0x03, 0x0A, 0xF0, 0xC0, 0x47, 0x50, 0x8F, 0xC0, 0xA7,
  0x30, 0xAF, 0xE0, 0xC7, 0x10, 0x9E, 0x81, 0xED, 0xDE, 0x0A, 0x60, 0x4D, 0x0C, 0x04, 0x30, 0x20,
  0xAD, 0x05, 0x50, 0xCC, 0x0B, 0x70, 0xAC, 0x0E, 0x40, 0x4C, 0x0E, 0x01, 0x71, 0x0D, 0xC0, 0x63,
  0x09, 0xC0, 0x77, 0x20, 0x4C, 0x0C, 0x30, 0xEC, 0x02, 0x73, 0x0D, 0xC8, 0x12, 0x02, 0xC0, 0xE7,
  0x40, 0x8C, 0x81, 0x60, 0x4C, 0x0B, 0x74, 0x04, 0xC8, 0x1A, 0x06, 0xC0, 0xA7, 0x40, 0x1C, 0x81,
  0xD0, 0x7C, 0x09, 0x75, 0x0E, 0xC1, 0x08, 0xC0, 0x87, 0x50, 0xDC, 0x02, 0x08, 0xC0, 0x97, 0x50,
  0xCC, 0x03, 0x07, 0xC0, 0xA7, 0x50, 0xDC, 0x04, 0x05, 0xC0, 0xC7, 0x50, 0xEC, 0x05, 0x03, 0xC0,
  0xE7, 0x40, 0x3D, 0x05, 0x1D, 0x03, 0x73, 0x08, 0xD8, 0x15, 0x0C, 0xC0, 0xA7, 0x20, 0x10, 0xED,
  0x81, 0x50, 0x7D, 0x03, 0x71, 0x0B, 0xE8, 0x24, 0x01, 0xEC, 0x0E, 0x03, 0x50, 0x10, 0xBF, 0x04,
  0x20, 0x7E, 0x84, 0xB6, 0x56, 0x9E, 0xA0, 0xD0, 0xAC, 0x03, 0x30, 0xCF, 0xE0, 0x30, 0xAC, 0x01,
  0x30, 0x10, 0xDF, 0xC8, 0x16, 0x0B, 0xC5, 0x01, 0x0A, 0xF9, 0x0E, 0x04, 0x20, 0xDB, 0x0E, 0x78,
  0x73, 0x9C, 0xEF, 0xEB, 0x71, 0x3C, 0x0C, 0x77, 0x40, 0x2C, 0x09, 0x77, 0x40, 0x5C, 0x07, 0x77,
  0x40, 0x8C, 0x04, 0x77, 0x40, 0xDC, 0x77, 0x40, 0x1C, 0x0C, 0x77, 0x40, 0x8C, 0x07, 0x77, 0x40,
  0xEC, 0x02, 0x77, 0x30, 0x7C, 0x0B, 0x77, 0x30, 0x2D, 0x04, 0x77, 0x20, 0x20, 0xDC, 0x0C, 0x77,
  0x20, 0x30, 0xED, 0x02, 0x68, 0x12, 0x62, 0x50, 0x30, 0x9E, 0x07, 0x70, 0x4B, 0x81, 0xED, 0xDF,
  0x90, 0x97, 0x10, 0x4F, 0xE0, 0x87, 0x20, 0x4F, 0xC0, 0xD0, 0x47, 0x30, 0x3F, 0xA0, 0xB0, 0x67,
  0x68, 0x61, 0x35, 0x77, 0x65, 0x37, 0x60,
  // ":" (U+003A)
  0x28, 0x21, 0x56, 0x33, 0x04, 0x0E, 0xB0, 0x92, 0x0C, 0xD0, 0x31, 0xE0, 0x70, 0x2E, 0x08, 0x01,
  0xE8, 0x17, 0x0D, 0xD8, 0x23, 0x04, 0xEB, 0x08, 0x38, 0x21, 0x56, 0x38, 0x0A, 0x80, 0x08, 0x21,
  0x56, 0x33, 0x03, 0x0E, 0xB0, 0x92, 0x0C, 0xD0, 0x31, 0xE0, 0x70, 0x2E, 0x08, 0x01, 0xE8, 0x17,
  0x0C, 0xD8, 0x23, 0x03, 0xEB, 0x08, 0x38, 0x21, 0x56, 0x32,
  // ";" (U+003B)
  0x38, 0x21, 0x56, 0x34, 0x04, 0x0E, 0xB0, 0x83, 0x0D, 0xD8, 0x13, 0x02, 0xE8, 0x17, 0x03, 0xE8,
  0x18, 0x02, 0xE0, 0x72, 0x0D, 0xD0, 0x32, 0x04, 0x0E, 0xB0, 0x74, 0x82, 0x16, 0x62, 0x80, 0xAB,
  0x10, 0x02, 0xD0, 0x72, 0x04, 0xD0, 0x62, 0x06, 0xD0, 0x22, 0x09, 0xC0, 0xD3, 0x0B, 0xC0, 0x93,
  0x0E, 0xC0, 0x52, 0x01, 0xD3, 0x04, 0xC0, 0xB3, 0x07, 0xC0, 0x53, 0x0A, 0xC4, 0x0D, 0xB0, 0xA3,
  0x01, 0xC0, 0x43, 0x05, 0xB0, 0xD4, 0x09, 0xB0, 0x74, 0x0C, 0xB0, 0x14,
  // "<" (U+003C)
  0x77, 0x71, 0x81, 0x5D, 0x27, 0x76, 0x04, 0x0C, 0xA0, 0x27, 0x74, 0x04, 0x0C, 0xC0, 0x27, 0x72,
  0x03, 0x0B, 0xE0, 0x27, 0x70, 0x30, 0xBF, 0x0C, 0x01, 0x75, 0x02, 0x0A, 0xF0, 0xC0, 0x47, 0x50,
  0x20, 0x9F, 0x0C, 0x04, 0x75, 0x01, 0x09, 0xF0, 0xC0, 0x47, 0x58, 0x11, 0x8E, 0xE0, 0xC0, 0x47,
  0x60, 0x70, 0xEE, 0x0C, 0x05, 0x76, 0x07, 0x0E, 0xE0, 0xC0, 0x57, 0x60, 0x60, 0xDE, 0x0C, 0x05,
  0x77, 0x0C, 0xE0, 0xD0, 0x57, 0x72, 0x0E, 0xC0, 0xE0, 0x57, 0x74, 0x0E, 0xD0, 0xC0, 0x57, 0x73,
  0x06, 0x0E, 0xE0, 0xD0, 0x67, 0x73, 0x07, 0x0E, 0xE0, 0xD0, 0x67, 0x73, 0x07, 0x0E, 0xE0, 0xE0,
  0x77, 0x73, 0x07, 0x0E, 0xE0, 0xE0, 0x77, 0x73, 0x07, 0x0E, 0xE8, 0x1E, 0x81, 0x77, 0x20, 0x70,
  0xEE, 0x81, 0xE8, 0x17, 0x72, 0x07, 0x0E, 0xF0, 0x90, 0x17, 0x71, 0x81, 0x17, 0xEF, 0x09, 0x77,
  0x28, 0x11, 0x8E, 0xE0, 0x27, 0x73, 0x81, 0x18, 0xEC, 0x02, 0x77, 0x58, 0x11, 0x8E, 0xA0, 0x27,
  0x77, 0x82, 0x18, 0xE2, 0x77, 0x72, 0x01, 0x10,
  // "=" (U+003D)
  0x0B, 0xFF, 0xFA, 0x0B, 0xFF, 0xFA, 0x0B, 0xFF, 0xFA, 0x0B, 0xFF, 0xFA, 0x03, 0x80, 0xA3, 0x58,
  0x0A, 0xC4, 0x00, 0x38, 0x0A, 0x35, 0x0B, 0xFF, 0xFA, 0x0B, 0xFF, 0xFA, 0x0B, 0xFF, 0xFA, 0x0B,
  0xFF, 0xFA,
  // ">" (U+003E)
  0x81, 0xC8, 0x17, 0x77, 0x18, 0x2D, 0xFE, 0x77, 0x77, 0x0D, 0xB0, 0xE0, 0x67, 0x75, 0x0D, 0xD0,
  0xD0, 0x67, 0x73, 0x08, 0xF0, 0xD0, 0x57, 0x72, 0x02, 0x09, 0xF0, 0xC0, 0x47, 0x72, 0x02, 0x09,
  0xF0, 0xC0, 0x47, 0x72, 0x02, 0x0A, 0xF0, 0xB0, 0x37, 0x72, 0x02, 0x0A, 0xF0, 0xA0, 0x27, 0x72,
  0x02, 0x0A, 0xF0, 0xA0, 0x27, 0x72, 0x02, 0x0A, 0xF0, 0x90, 0x17, 0x72, 0x02, 0x0A, 0xF0, 0x90,
  0x17, 0x72, 0x02, 0x0A, 0xE0, 0xE0, 0x27, 0x73, 0x03, 0x0C, 0xD0, 0x37, 0x72, 0x03, 0x0A, 0xE0,
  0x37, 0x70, 0x30, 0xBF, 0x09, 0x01, 0x75, 0x04, 0x0B, 0xF0, 0x90, 0x27, 0x50, 0x40, 0xCF, 0x09,
  0x02, 0x75, 0x05, 0x0C, 0xF0, 0x90, 0x27, 0x50, 0x50, 0xDF, 0x0A, 0x02, 0x75, 0x06, 0x0D, 0xF0,
  0xA0, 0x27, 0x50, 0x60, 0xDF, 0x0A, 0x02, 0x75, 0x06, 0x0E, 0xF0, 0xA0, 0x27, 0x70, 0xDE, 0x0A,
  0x02, 0x77, 0x20, 0xDC, 0x0A, 0x02, 0x77, 0x40, 0xDA, 0x0A, 0x02, 0x77, 0x68, 0x1D, 0xA3, 0x77,
  0x71, 0x02, 0x77, 0x73,
  // "?" (U+003F)
  0x68, 0x52, 0x56, 0x77, 0x53, 0x73, 0x81, 0x39, 0xEF, 0x81, 0xE9, 0x25, 0x03, 0x0B, 0xFE, 0x07,
  0x30, 0x1F, 0xFA, 0x07, 0x30, 0xAE, 0x81, 0xED, 0xEF, 0x04, 0x20, 0x3B, 0x81, 0xB5, 0x13, 0x01,
  0x08, 0xD0, 0xC3, 0x81, 0xCB, 0x27, 0x10, 0x6D, 0x03, 0x20, 0x17, 0x40, 0xBC, 0x07, 0x77, 0x06,
  0xC0, 0xA7, 0x70, 0x3C, 0x0B, 0x77, 0x02, 0xC0, 0xC7, 0x70, 0x3C, 0x0B, 0x77, 0x04, 0xC0, 0xA7,
  0x70, 0x7C, 0x07, 0x77, 0x0D, 0xC0, 0x47, 0x60, 0x4C, 0x0D, 0x77, 0x0C, 0xC0, 0x77, 0x60, 0x8C,
  0x0D, 0x76, 0x05, 0xD0, 0x47, 0x50, 0x30, 0xEC, 0x08, 0x75, 0x01, 0x0E, 0xC0, 0xB7, 0x60, 0xCC,
  0x0D, 0x01, 0x75, 0x07, 0xC0, 0xE0, 0x27, 0x50, 0x10, 0xEC, 0x04, 0x76, 0x07, 0xC0, 0x77, 0x70,
  0xCB, 0x0C, 0x77, 0x1C, 0x05, 0x77, 0x02, 0xB0, 0xE7, 0x71, 0x03, 0xB0, 0xC7, 0x71, 0x04, 0xB0,
  0xA7, 0x71, 0x05, 0xB0, 0x97, 0x71, 0x83, 0x39, 0x99, 0x68, 0x09, 0xB4, 0x08, 0x23, 0x65, 0x17,
  0x71, 0x09, 0xB0, 0xE0, 0x37, 0x60, 0x4D, 0x0C, 0x76, 0x07, 0xE7, 0x60, 0x9E, 0x01, 0x75, 0x07,
  0xE7, 0x60, 0x4D, 0x0C, 0x77, 0x09, 0xB0, 0xE0, 0x37, 0x71, 0x82, 0x36, 0x51, 0x72,
  // "@" (U+0040)
  0x77, 0x89, 0x22, 0x69, 0xCD, 0xEF, 0xDC, 0x96, 0x17, 0x77, 0x30, 0x60, 0xCF, 0xD0, 0xB0, 0x37,
  0x76, 0x04, 0x0D, 0xFF, 0xA0, 0xA0, 0x17, 0x73, 0x0A, 0xFF, 0xD0, 0xD0, 0x37, 0x70, 0x10, 0xCE,
  0x82, 0xB6, 0x31, 0x28, 0x21, 0x37, 0xCD, 0x0E, 0x04, 0x75, 0x01, 0x0D, 0xD0, 0x90, 0x17, 0x30,
  0x30, 0xCC, 0x0E, 0x03, 0x74, 0x0C, 0xC0, 0xD0, 0x37, 0x70, 0x7C, 0x0E, 0x01, 0x72, 0x0A, 0xC0,
  0xB0, 0x17, 0x72, 0x05, 0xC0, 0xA7, 0x10, 0x4C, 0x0C, 0x77, 0x50, 0x7C, 0x04, 0x70, 0xEB, 0x0D,
  0x01, 0x77, 0x60, 0xBB, 0x0C, 0x60, 0x7C, 0x04, 0x77, 0x70, 0x2C, 0x04, 0x50, 0xEB, 0x09, 0x77,
  0x72, 0x09, 0xB0, 0xB4, 0x06, 0xC0, 0x17, 0x18, 0x90, 0x4A, 0xCE, 0xFE, 0xCA, 0x62, 0x50, 0x2C,
  0x01, 0x30, 0xCB, 0x09, 0x70, 0x30, 0xCF, 0xB0, 0xB5, 0x0B, 0xB0, 0x62, 0x02, 0xC0, 0x26, 0x04,
  0xFD, 0x0D, 0x50, 0x6B, 0x0A, 0x20, 0x7B, 0x0C, 0x60, 0x30, 0xEF, 0xD0, 0xD5, 0x02, 0xB0, 0xE2,
  0x0B, 0xB0, 0x76, 0x0C, 0xC0, 0xA0, 0x32, 0x02, 0x0A, 0xB0, 0xC6, 0x0E, 0xB8, 0x11, 0x0E, 0xB0,
  0x35, 0x05, 0xC0, 0x85, 0x07, 0xB0, 0xB6, 0x0C, 0xB0, 0x03, 0xC6, 0x0B, 0xB0, 0xC6, 0x08, 0xB0,
  0xB6, 0x0A, 0xB0, 0x50, 0x6B, 0x0C, 0x50, 0x1C, 0x05, 0x60, 0x9B, 0x0A, 0x60, 0x8B, 0x07, 0x08,
  0xB0, 0x95, 0x06, 0xB0, 0xE7, 0x0A, 0xB0, 0x96, 0x07, 0xB0, 0x70, 0xAB, 0x07, 0x50, 0x8B, 0x0B,
  0x70, 0xBB, 0x09, 0x60, 0x7B, 0x08, 0x0B, 0xB0, 0x55, 0x0B, 0xB0, 0x87, 0x0C, 0xB0, 0x86, 0x07,
  0xB0, 0x80, 0xCB, 0x04, 0x50, 0xDB, 0x06, 0x70, 0xDB, 0x07, 0x60, 0x7B, 0x07, 0x0D, 0xB0, 0x35,
  0x0E, 0xB0, 0x57, 0x0E, 0xB0, 0x76, 0x08, 0xB0, 0x60, 0xEB, 0x02, 0x50, 0xEB, 0x04, 0x7C, 0x06,
  0x60, 0x9B, 0x05, 0x0E, 0xB0, 0x25, 0x0E, 0xB0, 0x46, 0x01, 0xC0, 0x66, 0x0B, 0xB0, 0x30, 0xEB,
  0x02, 0x50, 0xEB, 0x05, 0x60, 0x3C, 0x05, 0x60, 0xEB, 0x01, 0x0D, 0xB0, 0x35, 0x0D, 0xB0, 0x66,
  0x06, 0xC0, 0x55, 0x01, 0xB8, 0x1D, 0x0C, 0xB0, 0x55, 0x0A, 0xB0, 0x96, 0x0A, 0xC0, 0x55, 0x06,
  0xB8, 0x19, 0x0B, 0xB0, 0x65, 0x07, 0xB0, 0xD6, 0x0E, 0xC0, 0x85, 0x0B, 0xB8, 0x15, 0x09, 0xB0,
  0x95, 0x03, 0xC0, 0x64, 0x07, 0xA0, 0xAA, 0x0D, 0x40, 0x4B, 0x0E, 0x20, 0x7B, 0x0C, 0x60, 0xDC,
  0x82, 0x61, 0x17, 0xB0, 0x1B, 0x83, 0xA2, 0x05, 0xEB, 0x08, 0x20, 0x5C, 0x60, 0x5F, 0xB8, 0x19,
  0x0B, 0xFA, 0x0E, 0x01, 0x20, 0x1C, 0x04, 0x60, 0xAF, 0x98, 0x2E, 0x10, 0x3F, 0xA0, 0x44, 0x0D,
  0xB0, 0x97, 0x0A, 0xE0, 0xE0, 0x33, 0x07, 0xF0, 0x55, 0x09, 0xB0, 0xE7, 0x18, 0x55, 0xBE, 0xFD,
  0x92, 0x58, 0x54, 0xBE, 0xFD, 0x92, 0x60, 0x4C, 0x06, 0x77, 0x77, 0x50, 0xDB, 0x0D, 0x77, 0x77,
  0x50, 0x6C, 0x08, 0x77, 0x77, 0x50, 0xDC, 0x04, 0x77, 0x77, 0x40, 0x5C, 0x0E, 0x03, 0x77, 0x77,
  0x40, 0xAC, 0x0E, 0x05, 0x77, 0x20, 0x17, 0x71, 0x0C, 0xD0, 0xA0, 0x27, 0x58, 0x14, 0xAE, 0x77,
  0x10, 0x10, 0xDE, 0x82, 0xB7, 0x31, 0x28, 0x41, 0x24, 0x7A, 0xEA, 0x0E, 0x77, 0x20, 0x10, 0xBF,
  0xFD, 0x0E, 0x77, 0x40, 0x70, 0xEF, 0xFB, 0x0D, 0x77, 0x58, 0x11, 0x8D, 0xFE, 0x0B, 0x05, 0x77,
  0x72, 0x83, 0x37, 0xAD, 0xEA, 0x84, 0xED, 0xB8, 0x51, 0x76,
  // "A" (U+0041)
  0x75, 0x0D, 0xD0, 0x27, 0x77, 0x20, 0x2E, 0x06, 0x77, 0x72, 0x06, 0xE0, 0xB7, 0x77, 0x20, 0xAF,
  0x77, 0x72, 0x0E, 0xF0, 0x47, 0x77, 0x04, 0xC0, 0xCB, 0x09, 0x77, 0x70, 0x8B, 0x0C, 0x09, 0xB0,
  0xD7, 0x77, 0x0D, 0xB0, 0x80, 0x6C, 0x02, 0x77, 0x50, 0x2C, 0x05, 0x02, 0xC0, 0x67, 0x75, 0x06,
  0xC8, 0x12, 0x0E, 0xB0, 0xB7, 0x75, 0x0B, 0xB0, 0xE2, 0x0B, 0xC7, 0x75, 0x0E, 0xB0, 0xB2, 0x07,
  0xC0, 0x47, 0x73, 0x04, 0xC0, 0x72, 0x03, 0xC0, 0x97, 0x73, 0x08, 0xC0, 0x33, 0x0E, 0xB0, 0xD7,
  0x73, 0x0D, 0xB0, 0xE4, 0x0A, 0xC0, 0x27, 0x71, 0x02, 0xC0, 0xA4, 0x06, 0xC0, 0x77, 0x71, 0x06,
  0xC0, 0x64, 0x02, 0xC0, 0xB7, 0x71, 0x0B, 0xC0, 0x25, 0x0D, 0xC7, 0x71, 0x0E, 0xB0, 0xD6, 0x09,
  0xC0, 0x47, 0x60, 0x4C, 0x09, 0x60, 0x5C, 0x09, 0x76, 0x08, 0xC0, 0x56, 0x01, 0xC0, 0xD7, 0x60,
  0xDC, 0x01, 0x70, 0xDC, 0x02, 0x74, 0x02, 0xC0, 0xD7, 0x10, 0x8C, 0x07, 0x74, 0x06, 0xC0, 0x97,
  0x10, 0x4C, 0x0B, 0x74, 0x0B, 0xC0, 0x57, 0x2D, 0x74, 0x0E, 0xFF, 0xD0, 0x57, 0x20, 0x4F, 0xFE,
  0x09, 0x72, 0x08, 0xFF, 0xE0, 0xD7, 0x20, 0xDF, 0xFF, 0x02, 0x70, 0x2D, 0x80, 0x90, 0x50, 0xCC,
  0x07, 0x70, 0x6C, 0x0C, 0x75, 0x07, 0xC0, 0xB7, 0x0B, 0xC0, 0x87, 0x50, 0x2D, 0x01, 0x60, 0xEC,
  0x04, 0x76, 0x0D, 0xC0, 0x55, 0x04, 0xC0, 0xE7, 0x70, 0x9C, 0x09, 0x50, 0x8C, 0x0B, 0x77, 0x05,
  0xC0, 0xE5, 0x0D, 0xC0, 0x67, 0x70, 0x1D, 0x03, 0x30, 0x2D, 0x02, 0x77, 0x10, 0xCC, 0x07, 0x30,
  0x6C, 0x0D, 0x77, 0x20, 0x8C, 0x0C, 0x30, 0xBC, 0x09, 0x77, 0x20, 0x4D, 0x01, 0x20, 0xEC, 0x05,
  0x77, 0x3D, 0x81, 0x50, 0x4D, 0x01, 0x77, 0x30, 0xBC, 0x81, 0x90, 0x8C, 0x0C, 0x77, 0x40, 0x7C,
  0x81, 0xE0, 0xDC, 0x08, 0x77, 0x40, 0x2D, 0x03,
  // "B" (U+0042)
  0x03, 0xFC, 0x84, 0xED, 0xB9, 0x61, 0x71, 0x03, 0xFF, 0xB0, 0xB0, 0x36, 0x03, 0xFF, 0xD0, 0x95,
  0x03, 0xFF, 0xE0, 0xA4, 0x03, 0xD8, 0x02, 0x58, 0x16, 0x8C, 0xF0, 0x73, 0x03, 0xC0, 0xE7, 0x20,
  0x20, 0xBD, 0x0E, 0x01, 0x20, 0x3C, 0x0E, 0x74, 0x0A, 0xD0, 0x62, 0x03, 0xC0, 0xE7, 0x40, 0x10,
  0xEC, 0x0B, 0x20, 0x3C, 0x0E, 0x75, 0x09, 0xC0, 0xE2, 0x03, 0xC0, 0xE7, 0x50, 0x5D, 0x20, 0x3C,
  0x0E, 0x75, 0x03, 0xD2, 0x03, 0xC0, 0xE7, 0x50, 0x3D, 0x20, 0x3C, 0x0E, 0x75, 0x04, 0xC0, 0xE2,
  0x03, 0xC0, 0xE7, 0x50, 0x6C, 0x0C, 0x20, 0x3C, 0x0E, 0x75, 0x0A, 0xC0, 0x92, 0x03, 0xC0, 0xE7,
  0x40, 0x1D, 0x03, 0x20, 0x3C, 0x0E, 0x74, 0x0A, 0xC0, 0xC3, 0x03, 0xC0, 0xE7, 0x20, 0x10, 0xAC,
  0x0E, 0x03, 0x30, 0x3D, 0x80, 0x25, 0x81, 0x67, 0xBD, 0x0E, 0x04, 0x40, 0x3F, 0xFC, 0x0B, 0x02,
  0x50, 0x3F, 0xFA, 0x0B, 0x02, 0x70, 0x3F, 0xFB, 0x81, 0xD8, 0x15, 0x03, 0xFF, 0xD0, 0xE0, 0x64,
  0x03, 0xC0, 0xE7, 0x82, 0x14, 0x9E, 0xD0, 0x93, 0x03, 0xC0, 0xE7, 0x30, 0x10, 0xBD, 0x06, 0x20,
  0x3C, 0x0E, 0x75, 0x0C, 0xC8, 0x2E, 0x10, 0x3C, 0x0E, 0x75, 0x02, 0xD8, 0x16, 0x03, 0xC0, 0xE7,
  0x60, 0xBC, 0x81, 0xB0, 0x3C, 0x0E, 0x76, 0x07, 0xC8, 0x1E, 0x03, 0xC0, 0xE7, 0x60, 0x4D, 0x10,
  0x3C, 0x0E, 0x76, 0x03, 0xD0, 0x10, 0x3C, 0x0E, 0x76, 0x04, 0xD1, 0x03, 0xC0, 0xE7, 0x60, 0x5D,
  0x10, 0x3C, 0x0E, 0x76, 0x08, 0xC8, 0x1D, 0x03, 0xC0, 0xE7, 0x60, 0xDC, 0x81, 0xA0, 0x3C, 0x0E,
  0x75, 0x05, 0xD8, 0x16, 0x03, 0xC0, 0xE7, 0x40, 0x10, 0xEC, 0x0E, 0x20, 0x3C, 0x0E, 0x73, 0x04,
  0x0D, 0xD0, 0x82, 0x03, 0xD8, 0x03, 0x58, 0x16, 0x8C, 0xE0, 0xC3, 0x03, 0xFF, 0xE0, 0xE0, 0x23,
  0x03, 0xFF, 0xD0, 0xC0, 0x24, 0x03, 0xFF, 0xB0, 0xE0, 0x76, 0x03, 0xFE, 0x82, 0xDC, 0x95, 0x71,
  // "C" (U+0043)
  0x76, 0x86, 0x35, 0x67, 0x65, 0x41, 0x77, 0x10, 0x50, 0xBF, 0xA8, 0x1D, 0x83, 0x73, 0x04, 0x0D,
  0xFF, 0x0C, 0x03, 0x70, 0x9F, 0xFB, 0x03, 0x60, 0xBF, 0x98, 0x1E, 0xDE, 0xE0, 0xC6, 0x0A, 0xE0,
  0xB0, 0x55, 0x81, 0x48, 0xEA, 0x05, 0x50, 0x7D, 0x0E, 0x05, 0x73, 0x07, 0x0D, 0x50, 0x2D, 0x0E,
  0x03, 0x77, 0x40, 0xBD, 0x04, 0x77, 0x40, 0x3D, 0x09, 0x77, 0x50, 0xAC, 0x0E, 0x01, 0x77, 0x40,
  0x1D, 0x08, 0x77, 0x50, 0x6D, 0x02, 0x77, 0x50, 0xAC, 0x0C, 0x77, 0x60, 0xEC, 0x08, 0x77, 0x50,
  0x2D, 0x04, 0x77, 0x50, 0x5D, 0x01, 0x77, 0x50, 0x7C, 0x0E, 0x77, 0x60, 0x9C, 0x0C, 0x77, 0x60,
  0xAC, 0x0B, 0x77, 0x60, 0xBC, 0x09, 0x77, 0x60, 0xCC, 0x09, 0x77, 0x60, 0xCC, 0x09, 0x77, 0x60,
  0xCC, 0x09, 0x77, 0x60, 0xBC, 0x0A, 0x77, 0x60, 0xAC, 0x0B, 0x77, 0x60, 0x9C, 0x0C, 0x77, 0x60,
  0x7C, 0x0E, 0x77, 0x60, 0x5D, 0x01, 0x77, 0x50, 0x3D, 0x03, 0x77, 0x6D, 0x07, 0x77, 0x60, 0xCC,
  0x0C, 0x77, 0x60, 0x7D, 0x01, 0x77, 0x50, 0x2D, 0x07, 0x77, 0x60, 0xCC, 0x0E, 0x01, 0x77, 0x50,
  0x5D, 0x08, 0x77, 0x60, 0xDD, 0x03, 0x77, 0x50, 0x4D, 0x0E, 0x02, 0x77, 0x50, 0xAD, 0x0E, 0x05,
  0x74, 0x02, 0x01, 0x60, 0xCE, 0x81, 0xB5, 0x14, 0x84, 0x13, 0x7C, 0xF4, 0x60, 0x20, 0xDF, 0x90,
  0xFD, 0x0E, 0xD0, 0x47, 0x01, 0x0C, 0xFF, 0xA0, 0x47, 0x20, 0x70, 0xEF, 0xF0, 0x47, 0x38, 0x11,
  0x7D, 0xFA, 0x81, 0xD9, 0x37, 0x78, 0x71, 0x46, 0x77, 0x66, 0x41, 0x50,
  // "D" (U+0044)
  0x03, 0xFC, 0x83, 0xED, 0xA7, 0x37, 0x40, 0x3F, 0xFA, 0x0D, 0x07, 0x72, 0x03, 0xFF, 0xC0, 0xD0,
  0x47, 0x03, 0xFF, 0xE0, 0x76, 0x03, 0xD8, 0x02, 0x58, 0x17, 0x9D, 0xF0, 0x85, 0x03, 0xC0, 0xE7,
  0x20, 0x40, 0xCE, 0x06, 0x40, 0x3C, 0x0E, 0x74, 0x08, 0xE0, 0x23, 0x03, 0xC0, 0xE7, 0x50, 0x7D,
  0x0B, 0x30, 0x3C, 0x0E, 0x76, 0x0A, 0xD0, 0x42, 0x03, 0xC0, 0xE7, 0x60, 0x10, 0xEC, 0x0B, 0x20,
  0x3C, 0x0E, 0x77, 0x08, 0xD8, 0x11, 0x03, 0xC0, 0xE7, 0x70, 0x2D, 0x81, 0x60, 0x3C, 0x0E, 0x77,
  0x10, 0xCC, 0x81, 0xB0, 0x3C, 0x0E, 0x77, 0x10, 0x8C, 0x81, 0xE0, 0x3C, 0x0E, 0x77, 0x10, 0x4D,
  0x02, 0x03, 0xC0, 0xE7, 0x71, 0x02, 0xD0, 0x40, 0x3C, 0x0E, 0x77, 0x2D, 0x06, 0x03, 0xC0, 0xE7,
  0x72, 0x0D, 0xC0, 0x80, 0x3C, 0x0E, 0x77, 0x20, 0xCC, 0x09, 0x03, 0xC0, 0xE7, 0x72, 0x0B, 0xC0,
  0x90, 0x3C, 0x0E, 0x77, 0x20, 0xBC, 0x0A, 0x03, 0xC0, 0xE7, 0x72, 0x0B, 0xC0, 0xA0, 0x3C, 0x0E,
  0x77, 0x20, 0xBC, 0x0A, 0x03, 0xC0, 0xE7, 0x72, 0x0C, 0xC0, 0x90, 0x3C, 0x0E, 0x77, 0x20, 0xDC,
  0x08, 0x03, 0xC0, 0xE7, 0x72, 0x0E, 0xC0, 0x70, 0x3C, 0x0E, 0x77, 0x10, 0x1D, 0x05, 0x03, 0xC0,
  0xE7, 0x71, 0x03, 0xD0, 0x03, 0xC0, 0xE7, 0x71, 0x06, 0xD1, 0x03, 0xC0, 0xE7, 0x71, 0x0A, 0xC8,
  0x1C, 0x03, 0xC0, 0xE7, 0x71, 0x0E, 0xC8, 0x19, 0x03, 0xC0, 0xE7, 0x70, 0x4D, 0x81, 0x40, 0x3C,
  0x0E, 0x77, 0x0B, 0xC0, 0xE2, 0x03, 0xC0, 0xE7, 0x60, 0x3D, 0x08, 0x20, 0x3C, 0x0E, 0x76, 0x0D,
  0xD0, 0x12, 0x03, 0xC0, 0xE7, 0x50, 0xAD, 0x08, 0x30, 0x3C, 0x0E, 0x73, 0x01, 0x0B, 0xD0, 0xD4,
  0x03, 0xC0, 0xE7, 0x18, 0x11, 0x7E, 0xE0, 0x34, 0x03, 0xD8, 0x01, 0x58, 0x16, 0x8B, 0xF9, 0x04,
  0x50, 0x3F, 0xFD, 0x0E, 0x04, 0x60, 0x3F, 0xFC, 0x0B, 0x01, 0x70, 0x3F, 0xFA, 0x0B, 0x04, 0x72,
  0x03, 0xFB, 0x84, 0xED, 0xC9, 0x51, 0x74,
  // "E" (U+0045)
  0x03, 0xFF, 0xC0, 0xE0, 0x3F, 0xFC, 0x0E, 0x03, 0xFF, 0xC0, 0xE0, 0x3F, 0xFC, 0x0E, 0x03, 0xD8,
  0x09, 0x15, 0x04, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E,
  0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03,
  0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7,
  0x70, 0x3F, 0xFC, 0x01, 0x03, 0xFF, 0xC0, 0x10, 0x3F, 0xFC, 0x01, 0x03, 0xFF, 0xC0, 0x10, 0x3D,
  0x80, 0x91, 0x51, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E,
  0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03,
  0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7,
  0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3D, 0x80, 0x91, 0x50, 0x40, 0x3F, 0xFC, 0x0E,
  0x03, 0xFF, 0xC0, 0xE0, 0x3F, 0xFC, 0x0E, 0x03, 0xFF, 0xC0, 0xE0,
  // "F" (U+0046)
  0x03, 0xFF, 0xC0, 0xE0, 0x3F, 0xFC, 0x0E, 0x03, 0xFF, 0xC0, 0xE0, 0x3F, 0xFC, 0x0E, 0x03, 0xD8,
  0x09, 0x15, 0x04, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E,
  0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03,
  0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7,
  0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3F, 0xFC, 0x01, 0x03, 0xFF, 0xC0, 0x10, 0x3F,
  0xFC, 0x01, 0x03, 0xFF, 0xC0, 0x10, 0x3D, 0x80, 0x91, 0x51, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E,
  0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03,
  0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7,
  0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C,
  0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77,
  // "G" (U+0047)
  0x77, 0x87, 0x25, 0x67, 0x76, 0x53, 0x17, 0x74, 0x81, 0x5B, 0xEF, 0xA8, 0x1D, 0x94, 0x76, 0x06,
  0x0E, 0xFF, 0x98, 0x1E, 0x81, 0x71, 0x02, 0x0C, 0xFF, 0xD0, 0xA7, 0x04, 0x0E, 0xF9, 0x82, 0xED,
  0xDE, 0xF9, 0x03, 0x60, 0x4F, 0x81, 0xA5, 0x15, 0x81, 0x37, 0xCB, 0x0C, 0x60, 0x20, 0xED, 0x0C,
  0x02, 0x74, 0x82, 0x29, 0xF6, 0x60, 0xCD, 0x09, 0x77, 0x10, 0x26, 0x07, 0xD0, 0x97, 0x77, 0x10,
  0x10, 0xEC, 0x0C, 0x77, 0x72, 0x08, 0xD0, 0x37, 0x77, 0x20, 0xEC, 0x0A, 0x77, 0x72, 0x04, 0xD0,
  0x37, 0x77, 0x20, 0x9C, 0x0D, 0x77, 0x73, 0x0D, 0xC0, 0x87, 0x77, 0x20, 0x1D, 0x04, 0x77, 0x72,
  0x04, 0xD0, 0x27, 0x77, 0x20, 0x7C, 0x0E, 0x77, 0x73, 0x09, 0xC0, 0xC7, 0x77, 0x30, 0xAC, 0x0B,
  0x77, 0x73, 0x0B, 0xC0, 0xA7, 0x77, 0x30, 0xCC, 0x09, 0x74, 0x0B, 0xFC, 0x06, 0x0C, 0xC0, 0x97,
  0x40, 0xBF, 0xC0, 0x60, 0xCC, 0x09, 0x74, 0x0B, 0xFC, 0x06, 0x0B, 0xC0, 0x97, 0x40, 0xBF, 0xC0,
  0x60, 0xAC, 0x0A, 0x74, 0x03, 0x80, 0x25, 0x0B, 0xC0, 0x60, 0x9C, 0x0C, 0x77, 0x40, 0x9C, 0x06,
  0x07, 0xC0, 0xE7, 0x74, 0x09, 0xC0, 0x60, 0x5D, 0x01, 0x77, 0x30, 0x9C, 0x06, 0x02, 0xD0, 0x47,
  0x73, 0x09, 0xC8, 0x16, 0x0E, 0xC0, 0x87, 0x73, 0x09, 0xC8, 0x16, 0x0A, 0xC0, 0xC7, 0x73, 0x09,
  0xC8, 0x16, 0x06, 0xD0, 0x27, 0x72, 0x09, 0xC8, 0x16, 0x01, 0xD0, 0x87, 0x72, 0x09, 0xC0, 0x62,
  0x0A, 0xC0, 0xE0, 0x17, 0x71, 0x09, 0xC0, 0x62, 0x03, 0xD0, 0x97, 0x71, 0x09, 0xC0, 0x63, 0x0B,
  0xD0, 0x57, 0x70, 0x9C, 0x06, 0x30, 0x2E, 0x05, 0x76, 0x09, 0xC0, 0x64, 0x07, 0xE0, 0x87, 0x50,
  0x9C, 0x06, 0x50, 0x9E, 0x81, 0xE8, 0x36, 0x82, 0x14, 0x8E, 0xC0, 0x66, 0x0A, 0xFA, 0x0E, 0x0F,
  0xDF, 0xA0, 0x67, 0x08, 0xFF, 0xF0, 0x67, 0x10, 0x30, 0xCF, 0xFC, 0x0B, 0x03, 0x73, 0x81, 0x3A,
  0xEF, 0xC8, 0x2C, 0x85, 0x17, 0x71, 0x89, 0x02, 0x56, 0x77, 0x66, 0x53, 0x17,
  // "H" (U+0048)
  0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0, 0xE0, 0x3C, 0x0E, 0x77, 0x10, 0x3C, 0x0E, 0x03, 0xC0, 0xE7,
  0x71, 0x03, 0xC0, 0xE0, 0x3C, 0x0E, 0x77, 0x10, 0x3C, 0x0E, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0,
  0xE0, 0x3C, 0x0E, 0x77, 0x10, 0x3C, 0x0E, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0, 0xE0, 0x3C, 0x0E,
  0x77, 0x10, 0x3C, 0x0E, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0, 0xE0, 0x3C, 0x0E, 0x77, 0x10, 0x3C,
  0x0E, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0, 0xE0, 0x3C, 0x0E, 0x77, 0x10, 0x3C, 0x0E, 0x03, 0xC0,
  0xE7, 0x71, 0x03, 0xC0, 0xE0, 0x3C, 0x0E, 0x77, 0x10, 0x3C, 0x0E, 0x03, 0xC0, 0xE7, 0x71, 0x03,
  0xC0, 0xE0, 0x3C, 0x0E, 0x77, 0x10, 0x3C, 0x0E, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0, 0xE0, 0x3C,
  0x0E, 0x77, 0x10, 0x3C, 0x0E, 0x03, 0xD8, 0x09, 0x35, 0x07, 0xC0, 0xE0, 0x3F, 0xFF, 0xC0, 0xE0,
  0x3F, 0xFF, 0xC0, 0xE0, 0x3F, 0xFF, 0xC0, 0xE0, 0x3F, 0xFF, 0xC0, 0xE0, 0x3C, 0x0E, 0x77, 0x10,
  0x3C, 0x0E, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0, 0xE0, 0x3C, 0x0E, 0x77, 0x10, 0x3C, 0x0E, 0x03,
  0xC0, 0xE7, 0x71, 0x03, 0xC0, 0xE0, 0x3C, 0x0E, 0x77, 0x10, 0x3C, 0x0E, 0x03, 0xC0, 0xE7, 0x71,
  0x03, 0xC0, 0xE0, 0x3C, 0x0E, 0x77, 0x10, 0x3C, 0x0E, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0, 0xE0,
  0x3C, 0x0E, 0x77, 0x10, 0x3C, 0x0E, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0, 0xE0, 0x3C, 0x0E, 0x77,
  0x10, 0x3C, 0x0E, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0, 0xE0, 0x3C, 0x0E, 0x77, 0x10, 0x3C, 0x0E,
  0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0, 0xE0, 0x3C, 0x0E, 0x77, 0x10, 0x3C, 0x0E, 0x03, 0xC0, 0xE7,
  0x71, 0x03, 0xC0, 0xE0, 0x3C, 0x0E, 0x77, 0x10, 0x3C, 0x0E, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0,
  0xE0, 0x3C, 0x0E, 0x77, 0x10, 0x3C, 0x0E, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0, 0xE0,
  // "I" (U+0049)
  0x0D, 0xFD, 0x0C, 0x0D, 0xFD, 0x0C, 0x0D, 0xFD, 0x81, 0xC7, 0xDF, 0xB0, 0xC0, 0x72, 0x81, 0x15,
  0xCC, 0x81, 0xB5, 0x16, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C,
  0x08, 0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71,
  0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0,
  0x87, 0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87, 0x10,
  0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08,
  0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71, 0x09,
  0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87,
  0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08, 0x58, 0x13, 0x7B, 0xD8, 0x4E, 0xB7,
  0x30, 0xCF, 0xD0, 0xB0, 0xDF, 0xD0, 0xC0, 0xDF, 0xD0, 0xC0,
  // "J" (U+004A)
  0x71, 0x05, 0xC0, 0xB7, 0x10, 0x5C, 0x0B, 0x71, 0x05, 0xC0, 0xB7, 0x10, 0x5C, 0x0B, 0x71, 0x05,
  0xC0, 0xB7, 0x10, 0x5C, 0x0B, 0x71, 0x05, 0xC0, 0xB7, 0x10, 0x5C, 0x0B, 0x71, 0x05, 0xC0, 0xB7,
  0x10, 0x5C, 0x0B, 0x71, 0x05, 0xC0, 0xB7, 0x10, 0x5C, 0x0B, 0x71, 0x05, 0xC0, 0xB7, 0x10, 0x5C,
  0x0B, 0x71, 0x05, 0xC0, 0xB7, 0x10, 0x5C, 0x0B, 0x71, 0x05, 0xC0, 0xB7, 0x10, 0x5C, 0x0B, 0x71,
  0x05, 0xC0, 0xB7, 0x10, 0x5C, 0x0B, 0x71, 0x05, 0xC0, 0xB7, 0x10, 0x5C, 0x0B, 0x71, 0x05, 0xC0,
  0xB7, 0x10, 0x5C, 0x0B, 0x71, 0x05, 0xC0, 0xB7, 0x10, 0x5C, 0x0B, 0x71, 0x05, 0xC0, 0xB7, 0x10,
  0x5C, 0x0B, 0x71, 0x05, 0xC0, 0xB7, 0x10, 0x5C, 0x0B, 0x71, 0x05, 0xC0, 0xB7, 0x10, 0x5C, 0x0B,
  0x71, 0x05, 0xC0, 0xB7, 0x10, 0x5C, 0x0B, 0x71, 0x05, 0xC0, 0xB7, 0x10, 0x5C, 0x0B, 0x71, 0x05,
  0xC0, 0xB7, 0x10, 0x5C, 0x0B, 0x71, 0x05, 0xC0, 0xB7, 0x10, 0x5C, 0x0B, 0x71, 0x05, 0xC0, 0xB7,
  0x10, 0x5C, 0x0B, 0x71, 0x05, 0xC0, 0xB7, 0x10, 0x6C, 0x0A, 0x71, 0x07, 0xC0, 0x97, 0x10, 0x8C,
  0x08, 0x71, 0x0B, 0xC0, 0x67, 0x01, 0xD0, 0x37, 0x0A, 0xC8, 0x3E, 0x03, 0x51, 0x20, 0x30, 0xAD,
  0x81, 0x80, 0x7F, 0xB8, 0x2E, 0x10, 0x7F, 0xB0, 0x52, 0x07, 0xFA, 0x05, 0x30, 0x50, 0xED, 0x81,
  0xE9, 0x16, 0x83, 0x23, 0x43, 0x27,
  // "K" (U+004B)
  0x03, 0xC0, 0xE7, 0x60, 0x7D, 0x00, 0x3C, 0x0E, 0x75, 0x02, 0xD8, 0x18, 0x03, 0xC0, 0xE7, 0x50,
  0xBC, 0x0D, 0x20, 0x3C, 0x0E, 0x74, 0x06, 0xD0, 0x32, 0x03, 0xC0, 0xE7, 0x30, 0x10, 0xEC, 0x09,
  0x30, 0x3C, 0x0E, 0x73, 0x0A, 0xC0, 0xD4, 0x03, 0xC0, 0xE7, 0x20, 0x4D, 0x04, 0x40, 0x3C, 0x0E,
  0x72, 0x0D, 0xC0, 0x95, 0x03, 0xC0, 0xE7, 0x10, 0x8C, 0x0E, 0x01, 0x50, 0x3C, 0x0E, 0x70, 0x3D,
  0x05, 0x60, 0x3C, 0x0E, 0x70, 0xCC, 0x0A, 0x70, 0x3C, 0x0E, 0x60, 0x6C, 0x0E, 0x01, 0x70, 0x3C,
  0x0E, 0x50, 0x10, 0xEC, 0x05, 0x71, 0x03, 0xC0, 0xE5, 0x0A, 0xC0, 0xB7, 0x20, 0x3C, 0x0E, 0x40,
  0x5C, 0x0E, 0x01, 0x72, 0x03, 0xC0, 0xE3, 0x01, 0x0D, 0xC0, 0x67, 0x30, 0x3C, 0x0E, 0x30, 0x9C,
  0x0B, 0x74, 0x03, 0xC0, 0xE2, 0x03, 0xD0, 0x27, 0x40, 0x3C, 0x0E, 0x20, 0xDC, 0x07, 0x75, 0x03,
  0xC8, 0x1E, 0x08, 0xD0, 0x27, 0x50, 0x3C, 0x0E, 0x03, 0xE0, 0xA7, 0x50, 0x3D, 0x0D, 0xF0, 0x37,
  0x40, 0x3F, 0xE0, 0xB7, 0x40, 0x3F, 0x0E, 0x09, 0xD0, 0x57, 0x30, 0x3E, 0x82, 0xE3, 0x0D, 0xC0,
  0xD7, 0x30, 0x3E, 0x04, 0x20, 0x5D, 0x06, 0x72, 0x03, 0xD0, 0x44, 0x0B, 0xC0, 0xE7, 0x20, 0x3C,
  0x0E, 0x50, 0x3D, 0x08, 0x71, 0x03, 0xC0, 0xE6, 0x0A, 0xC0, 0xE0, 0x17, 0x03, 0xC0, 0xE6, 0x02,
  0xD0, 0x97, 0x03, 0xC0, 0xE7, 0x09, 0xD0, 0x26, 0x03, 0xC0, 0xE7, 0x01, 0x0E, 0xC0, 0xB6, 0x03,
  0xC0, 0xE7, 0x10, 0x7D, 0x04, 0x50, 0x3C, 0x0E, 0x72, 0x0E, 0xC0, 0xC5, 0x03, 0xC0, 0xE7, 0x20,
  0x6D, 0x05, 0x40, 0x3C, 0x0E, 0x73, 0x0D, 0xC0, 0xD4, 0x03, 0xC0, 0xE7, 0x30, 0x4D, 0x07, 0x30,
  0x3C, 0x0E, 0x74, 0x0B, 0xC0, 0xE0, 0x12, 0x03, 0xC0, 0xE7, 0x40, 0x3D, 0x09, 0x20, 0x3C, 0x0E,
  0x75, 0x0A, 0xD8, 0x12, 0x03, 0xC0, 0xE7, 0x50, 0x2D, 0x81, 0xA0, 0x3C, 0x0E, 0x76, 0x09, 0xD0,
  0x03, 0xC0, 0xE7, 0x60, 0x10, 0xEC, 0x0C,
  // "L" (U+004C)
  0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0,
  0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70,
  0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E,
  0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03,
  0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7,
  0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C,
  0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77,
  0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0,
  0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xD8, 0x09, 0x15, 0x04, 0x03, 0xFF, 0xC0, 0xD0, 0x3F, 0xFC,
  0x0D, 0x03, 0xFF, 0xC0, 0xD0, 0x3F, 0xFC, 0x0D,
  // "M" (U+004D)
  0x03, 0xF0, 0x57, 0x77, 0x0D, 0xE0, 0xB0, 0x3F, 0x0A, 0x77, 0x60, 0x2F, 0x0B, 0x03, 0xF0, 0xE7,
  0x76, 0x07, 0xF0, 0xB0, 0x3F, 0x90, 0x47, 0x75, 0x0C, 0xF0, 0xB0, 0x3F, 0x90, 0x97, 0x74, 0x01,
  0xF9, 0x0B, 0x03, 0xF9, 0x0D, 0x77, 0x40, 0x6F, 0x90, 0xB0, 0x3F, 0xA0, 0x37, 0x73, 0x0B, 0xF9,
  0x0B, 0x03, 0xC0, 0x9C, 0x08, 0x77, 0x3C, 0x09, 0xC0, 0xB0, 0x3C, 0x06, 0x0E, 0xB0, 0xC7, 0x72,
  0x05, 0xC0, 0x5C, 0x0B, 0x03, 0xC0, 0x60, 0xAC, 0x02, 0x77, 0x10, 0x9B, 0x0E, 0x01, 0xC0, 0xB0,
  0x3C, 0x07, 0x05, 0xC0, 0x77, 0x71, 0x0E, 0xB0, 0xA0, 0x2C, 0x0B, 0x03, 0xC0, 0x81, 0xC0, 0xB7,
  0x70, 0x4C, 0x05, 0x02, 0xC0, 0xB0, 0x3C, 0x81, 0x90, 0xBC, 0x01, 0x76, 0x08, 0xC1, 0x03, 0xC0,
  0xB0, 0x3C, 0x81, 0x90, 0x6C, 0x05, 0x76, 0x0D, 0xB8, 0x1B, 0x03, 0xC0, 0xB0, 0x3C, 0x81, 0x90,
  0x1C, 0x0A, 0x75, 0x03, 0xC8, 0x16, 0x04, 0xC0, 0xB0, 0x3C, 0x0A, 0x20, 0xBB, 0x0E, 0x75, 0x07,
  0xC8, 0x11, 0x04, 0xC0, 0xB0, 0x3C, 0x0A, 0x20, 0x7C, 0x04, 0x74, 0x0C, 0xB0, 0xB2, 0x04, 0xC0,
  0xB0, 0x3C, 0x0A, 0x20, 0x2C, 0x09, 0x73, 0x01, 0xC0, 0x62, 0x04, 0xC0, 0xB0, 0x3C, 0x0A, 0x30,
  0xCB, 0x0E, 0x73, 0x06, 0xC0, 0x22, 0x04, 0xC0, 0xB0, 0x3C, 0x0A, 0x30, 0x7C, 0x03, 0x72, 0x0B,
  0xB0, 0xC3, 0x04, 0xC0, 0xB0, 0x3C, 0x0A, 0x30, 0x3C, 0x08, 0x71, 0x01, 0xC0, 0x73, 0x04, 0xC0,
  0xB0, 0x3C, 0x0A, 0x40, 0xDB, 0x0D, 0x71, 0x05, 0xC0, 0x23, 0x04, 0xC0, 0xB0, 0x3C, 0x0A, 0x40,
  0x8C, 0x02, 0x70, 0xAB, 0x0D, 0x40, 0x4C, 0x0B, 0x03, 0xC0, 0xA4, 0x03, 0xC0, 0x77, 0x0E, 0xB0,
  0x84, 0x04, 0xC0, 0xB0, 0x3C, 0x0A, 0x50, 0xEB, 0x0C, 0x60, 0x4C, 0x03, 0x40, 0x4C, 0x0B, 0x03,
  0xC0, 0xA5, 0x09, 0xC0, 0x15, 0x09, 0xB0, 0xE5, 0x04, 0xC0, 0xB0, 0x3C, 0x0A, 0x50, 0x4C, 0x06,
  0x50, 0xEB, 0x09, 0x50, 0x4C, 0x0B, 0x03, 0xC0, 0xA6, 0x0E, 0xB0, 0xB4, 0x03, 0xC0, 0x45, 0x04,
  0xC0, 0xB0, 0x3C, 0x0A, 0x60, 0xAC, 0x01, 0x30, 0x8B, 0x0E, 0x60, 0x4C, 0x0B, 0x03, 0xC0, 0xA6,
  0x05, 0xC0, 0x53, 0x0D, 0xB0, 0xA6, 0x04, 0xC0, 0xB0, 0x3C, 0x0A, 0x60, 0x1C, 0x0A, 0x20, 0x2C,
  0x05, 0x60, 0x4C, 0x0B, 0x03, 0xC0, 0xA7, 0x0B, 0xB0, 0xE2, 0x07, 0xC7, 0x04, 0xC0, 0xB0, 0x3C,
  0x0A, 0x70, 0x6C, 0x81, 0x40, 0xCB, 0x0A, 0x70, 0x4C, 0x0B, 0x03, 0xC0, 0xA7, 0x01, 0xC0, 0x90,
  0x1C, 0x05, 0x70, 0x4C, 0x0B, 0x03, 0xC0, 0xA7, 0x10, 0xCB, 0x0D, 0x06, 0xC0, 0x17, 0x04, 0xC0,
  0xB0, 0x3C, 0x0A, 0x71, 0x07, 0xC0, 0xEB, 0x0B, 0x71, 0x04, 0xC0, 0xB0, 0x3C, 0x0A, 0x71, 0x02,
  0xF9, 0x06, 0x71, 0x04, 0xC0, 0xB0, 0x3C, 0x0A, 0x72, 0x0D, 0xF0, 0x17, 0x10, 0x4C, 0x0B, 0x03,
  0xC0, 0xA7, 0x20, 0x8E, 0x0C, 0x72, 0x04, 0xC0, 0xB0, 0x3C, 0x0A, 0x72, 0x03, 0xE0, 0x77, 0x20,
  0x4C, 0x0B, 0x03, 0xC0, 0xA7, 0x30, 0xED, 0x02, 0x72, 0x04, 0xC0, 0xB0, 0x3C, 0x0A, 0x73, 0x09,
  0xC0, 0xD7, 0x30, 0x4C, 0x0B, 0x03, 0xC0, 0xA7, 0x30, 0x4C, 0x08, 0x73, 0x04, 0xC0, 0xB0,
  // "N" (U+004E)
  0x03, 0xE0, 0x37, 0x72, 0xC0, 0xC0, 0x3E, 0x0B, 0x77, 0x2C, 0x0C, 0x03, 0xF0, 0x37, 0x71, 0xC0,
  0xC0, 0x3F, 0x0A, 0x77, 0x1C, 0x0C, 0x03, 0xF9, 0x02, 0x77, 0xC0, 0xC0, 0x3F, 0x90, 0xA7, 0x7C,
  0x0C, 0x03, 0xFA, 0x02, 0x76, 0xC0, 0xC0, 0x3F, 0xA0, 0xA7, 0x6C, 0x0C, 0x03, 0xC0, 0xAD, 0x02,
  0x75, 0xC0, 0xC0, 0x3C, 0x05, 0x0D, 0xC0, 0x97, 0x5C, 0x0C, 0x03, 0xC0, 0x50, 0x6D, 0x02, 0x74,
  0xC0, 0xC0, 0x3C, 0x81, 0x60, 0xDC, 0x09, 0x74, 0xC0, 0xC0, 0x3C, 0x81, 0x70, 0x6D, 0x01, 0x73,
  0xC0, 0xC0, 0x3C, 0x08, 0x20, 0xDC, 0x09, 0x73, 0xC0, 0xC0, 0x3C, 0x08, 0x20, 0x6D, 0x01, 0x72,
  0xC0, 0xC0, 0x3C, 0x09, 0x30, 0xEC, 0x08, 0x72, 0xC0, 0xC0, 0x3C, 0x09, 0x30, 0x7C, 0x0E, 0x01,
  0x71, 0xC0, 0xC0, 0x3C, 0x0A, 0x40, 0xEC, 0x08, 0x71, 0xC0, 0xC0, 0x3C, 0x0A, 0x40, 0x7C, 0x0E,
  0x01, 0x7C, 0x0C, 0x03, 0xC0, 0xA5, 0x0E, 0xC0, 0x87, 0xC0, 0xC0, 0x3C, 0x0A, 0x50, 0x7C, 0x0E,
  0x01, 0x6C, 0x0C, 0x03, 0xC0, 0xA6, 0x0E, 0xC0, 0x76, 0xC0, 0xC0, 0x3C, 0x0A, 0x60, 0x7C, 0x0E,
  0x6C, 0x0C, 0x03, 0xC0, 0xA7, 0x0E, 0xC0, 0x75, 0xC0, 0xC0, 0x3C, 0x0A, 0x70, 0x7C, 0x0E, 0x5C,
  0x0C, 0x03, 0xC0, 0xA7, 0x01, 0x0E, 0xC0, 0x74, 0xC0, 0xC0, 0x3C, 0x0A, 0x71, 0x07, 0xC0, 0xE4,
  0xC0, 0xC0, 0x3C, 0x0A, 0x71, 0x01, 0x0E, 0xC0, 0x63, 0xC0, 0xC0, 0x3C, 0x0A, 0x72, 0x08, 0xC0,
  0xD3, 0xC0, 0xC0, 0x3C, 0x0A, 0x72, 0x01, 0x0E, 0xC0, 0x62, 0xC0, 0xC0, 0x3C, 0x0A, 0x73, 0x08,
  0xC0, 0xD2, 0x0E, 0xB0, 0xC0, 0x3C, 0x0A, 0x73, 0x01, 0x0E, 0xC8, 0x16, 0x0D, 0xB0, 0xC0, 0x3C,
  0x0A, 0x74, 0x08, 0xC8, 0x1D, 0x0D, 0xB0, 0xC0, 0x3C, 0x0A, 0x74, 0x01, 0x0E, 0xC0, 0x50, 0xCB,
  0x0C, 0x03, 0xC0, 0xA7, 0x50, 0x8C, 0x0D, 0x0C, 0xB0, 0xC0, 0x3C, 0x0A, 0x75, 0x01, 0xFA, 0x0C,
  0x03, 0xC0, 0xA7, 0x60, 0x8F, 0x90, 0xC0, 0x3C, 0x0A, 0x76, 0x01, 0xF9, 0x0C, 0x03, 0xC0, 0xA7,
  0x70, 0x9F, 0x0C, 0x03, 0xC0, 0xA7, 0x70, 0x1F, 0x0C, 0x03, 0xC0, 0xA7, 0x71, 0x09, 0xE0, 0xC0,
  0x3C, 0x0A, 0x77, 0x10, 0x1E, 0x0C, 0x03, 0xC0, 0xA7, 0x72, 0x09, 0xD0, 0xC0,
  // "O" (U+004F)
  0x75, 0x85, 0x35, 0x67, 0x65, 0x37, 0x77, 0x05, 0x0B, 0xFA, 0x0B, 0x05, 0x77, 0x20, 0x40, 0xDF,
  0xE0, 0xD0, 0x37, 0x60, 0x8F, 0xFB, 0x07, 0x74, 0x09, 0xF9, 0x81, 0xED, 0xDF, 0x90, 0x87, 0x20,
  0x7E, 0x81, 0xC5, 0x14, 0x04, 0x0A, 0xE0, 0x57, 0x03, 0xE0, 0x77, 0x20, 0x40, 0xEC, 0x0E, 0x02,
  0x60, 0xCD, 0x05, 0x74, 0x03, 0xD0, 0xB5, 0x04, 0xD0, 0x97, 0x60, 0x6D, 0x04, 0x40, 0xBC, 0x0E,
  0x77, 0x10, 0xCC, 0x0B, 0x30, 0x1D, 0x07, 0x77, 0x10, 0x5D, 0x01, 0x20, 0x6D, 0x01, 0x77, 0x20,
  0xEC, 0x07, 0x20, 0xBC, 0x0C, 0x77, 0x30, 0x9C, 0x0B, 0x20, 0xEC, 0x07, 0x77, 0x30, 0x5D, 0x10,
  0x2D, 0x04, 0x77, 0x30, 0x1D, 0x03, 0x05, 0xD0, 0x17, 0x74, 0x0E, 0xC0, 0x60, 0x7C, 0x0E, 0x77,
  0x50, 0xCC, 0x00, 0x9C, 0x0C, 0x77, 0x50, 0xAC, 0x0B, 0x0A, 0xC0, 0xB7, 0x75, 0x09, 0xC0, 0xC0,
  0xBC, 0x0A, 0x77, 0x50, 0x8C, 0x0E, 0x0C, 0xC0, 0x97, 0x75, 0x07, 0xC0, 0xE0, 0xCC, 0x09, 0x77,
  0x50, 0x7D, 0x0C, 0xC0, 0x97, 0x75, 0x06, 0xD0, 0xCC, 0x09, 0x77, 0x50, 0x7D, 0x0B, 0xC0, 0xA7,
  0x75, 0x07, 0xC0, 0xE0, 0xAC, 0x0A, 0x77, 0x50, 0x8C, 0x0E, 0x09, 0xC0, 0xB7, 0x75, 0x09, 0xC0,
  0xC0, 0x7C, 0x0D, 0x77, 0x50, 0xAC, 0x0A, 0x05, 0xD7, 0x75, 0x0C, 0xC0, 0x90, 0x3D, 0x02, 0x77,
  0x40, 0xEC, 0x06, 0x1D, 0x04, 0x77, 0x30, 0x2D, 0x81, 0x30, 0xCC, 0x08, 0x77, 0x30, 0x5D, 0x20,
  0x8C, 0x0C, 0x77, 0x30, 0xAC, 0x0B, 0x20, 0x4D, 0x02, 0x77, 0x20, 0xEC, 0x07, 0x30, 0xDC, 0x09,
  0x77, 0x10, 0x6D, 0x01, 0x30, 0x8C, 0x0E, 0x01, 0x77, 0x0D, 0xC0, 0xB4, 0x01, 0x0E, 0xC0, 0x97,
  0x60, 0x7D, 0x04, 0x50, 0x8D, 0x06, 0x74, 0x04, 0xD0, 0xB7, 0x0D, 0xD0, 0x77, 0x20, 0x5D, 0x0E,
  0x02, 0x70, 0x3E, 0x81, 0xC5, 0x14, 0x04, 0x0B, 0xE0, 0x57, 0x20, 0x5F, 0x90, 0xFD, 0xF9, 0x07,
  0x74, 0x04, 0x0E, 0xFF, 0xA0, 0x77, 0x60, 0x20, 0xBF, 0xE0, 0xD0, 0x37, 0x72, 0x81, 0x4A, 0xEF,
  0x90, 0xB0, 0x57, 0x77, 0x85, 0x35, 0x67, 0x65, 0x37, 0x50,
  // "P" (U+0050)
  0x03, 0xFA, 0x84, 0xED, 0xCA, 0x74, 0x71, 0x03, 0xFF, 0x90, 0xD0, 0x76, 0x03, 0xFF, 0xB0, 0xD0,
  0x34, 0x03, 0xFF, 0xD0, 0x43, 0x03, 0xD8, 0x00, 0x58, 0x26, 0x7A, 0xDE, 0x0E, 0x02, 0x20, 0x3C,
  0x0E, 0x71, 0x05, 0x0E, 0xD0, 0xA2, 0x03, 0xC0, 0xE7, 0x20, 0x10, 0xDD, 0x81, 0x20, 0x3C, 0x0E,
  0x73, 0x03, 0xD8, 0x18, 0x03, 0xC0, 0xE7, 0x40, 0xBC, 0x81, 0xC0, 0x3C, 0x0E, 0x74, 0x06, 0xD1,
  0x03, 0xC0, 0xE7, 0x40, 0x3D, 0x02, 0x03, 0xC0, 0xE7, 0x40, 0x1D, 0x00, 0x3C, 0x0E, 0x74, 0x01,
  0xD0, 0x40, 0x3C, 0x0E, 0x74, 0x01, 0xD0, 0x03, 0xC0, 0xE7, 0x40, 0x2D, 0x02, 0x03, 0xC0, 0xE7,
  0x40, 0x4D, 0x01, 0x03, 0xC0, 0xE7, 0x40, 0x8C, 0x81, 0xD0, 0x3C, 0x0E, 0x74, 0x0D, 0xC8, 0x19,
  0x03, 0xC0, 0xE7, 0x30, 0x6D, 0x81, 0x40, 0x3C, 0x0E, 0x72, 0x03, 0x0E, 0xC0, 0xC2, 0x03, 0xC0,
  0xE7, 0x01, 0x07, 0xE0, 0x42, 0x03, 0xD8, 0x00, 0x58, 0x16, 0x8B, 0xF0, 0x93, 0x03, 0xFF, 0xC0,
  0xB4, 0x03, 0xFF, 0xB0, 0x95, 0x03, 0xFF, 0x90, 0xA0, 0x36, 0x03, 0xFA, 0x84, 0xED, 0xC9, 0x51,
  0x71, 0x03, 0xC0, 0xE7, 0x74, 0x03, 0xC0, 0xE7, 0x74, 0x03, 0xC0, 0xE7, 0x74, 0x03, 0xC0, 0xE7,
  0x74, 0x03, 0xC0, 0xE7, 0x74, 0x03, 0xC0, 0xE7, 0x74, 0x03, 0xC0, 0xE7, 0x74, 0x03, 0xC0, 0xE7,
  0x74, 0x03, 0xC0, 0xE7, 0x74, 0x03, 0xC0, 0xE7, 0x74, 0x03, 0xC0, 0xE7, 0x74, 0x03, 0xC0, 0xE7,
  0x74, 0x03, 0xC0, 0xE7, 0x74, 0x03, 0xC0, 0xE7, 0x74, 0x03, 0xC0, 0xE7, 0x74, 0x03, 0xC0, 0xE7,
  0x74, 0x03, 0xC0, 0xE7, 0x74,
  // "Q" (U+0051)
  0x75, 0x85, 0x35, 0x67, 0x76, 0x37, 0x77, 0x05, 0x0B, 0xFA, 0x0B, 0x05, 0x77, 0x20, 0x40, 0xDF,
  0xE0, 0xD0, 0x47, 0x60, 0x8F, 0xFB, 0x08, 0x74, 0x09, 0xF9, 0x81, 0xED, 0xDF, 0x90, 0x97, 0x20,
  0x7E, 0x81, 0xC5, 0x14, 0x04, 0x0A, 0xE0, 0x77, 0x03, 0xE0, 0x77, 0x20, 0x40, 0xED, 0x03, 0x60,
  0xCD, 0x05, 0x74, 0x03, 0xD0, 0xD5, 0x04, 0xD0, 0x97, 0x60, 0x6D, 0x05, 0x40, 0xBC, 0x0E, 0x77,
  0x10, 0xCC, 0x0C, 0x30, 0x1D, 0x07, 0x77, 0x10, 0x5D, 0x03, 0x20, 0x6D, 0x01, 0x77, 0x20, 0xEC,
  0x08, 0x20, 0xBC, 0x0C, 0x77, 0x30, 0x9C, 0x0D, 0x20, 0xEC, 0x07, 0x77, 0x30, 0x5D, 0x01, 0x02,
  0xD0, 0x47, 0x73, 0x01, 0xD0, 0x40, 0x5D, 0x01, 0x77, 0x40, 0xEC, 0x00, 0x7C, 0x0E, 0x77, 0x50,
  0xCC, 0x00, 0x9C, 0x0C, 0x77, 0x50, 0xAC, 0x0B, 0x0A, 0xC0, 0xB7, 0x75, 0x09, 0xC0, 0xD0, 0xBC,
  0x0A, 0x77, 0x50, 0x8C, 0x0E, 0x0C, 0xC0, 0x97, 0x75, 0x07, 0xD0, 0xCC, 0x09, 0x77, 0x50, 0x7D,
  0x0C, 0xC0, 0x97, 0x75, 0x06, 0xD0, 0xCC, 0x09, 0x77, 0x50, 0x7D, 0x0B, 0xC0, 0xA7, 0x75, 0x07,
  0xC0, 0xE0, 0xAC, 0x0A, 0x77, 0x50, 0x8C, 0x0D, 0x09, 0xC0, 0xB7, 0x75, 0x09, 0xC0, 0xD0, 0x7C,
  0x0D, 0x77, 0x50, 0xAC, 0x0B, 0x05, 0xD7, 0x75, 0x0C, 0xC0, 0x90, 0x3D, 0x02, 0x77, 0x40, 0xEC,
  0x07, 0x1D, 0x04, 0x77, 0x30, 0x2D, 0x81, 0x40, 0xCC, 0x08, 0x77, 0x30, 0x5D, 0x20, 0x8C, 0x0C,
  0x77, 0x30, 0xAC, 0x0C, 0x20, 0x4D, 0x02, 0x77, 0x20, 0xEC, 0x07, 0x30, 0xDC, 0x09, 0x77, 0x10,
  0x6D, 0x02, 0x30, 0x8C, 0x0E, 0x01, 0x77, 0x0D, 0xC0, 0xC4, 0x01, 0xD0, 0x97, 0x60, 0x7D, 0x04,
  0x50, 0x8D, 0x06, 0x74, 0x04, 0xD0, 0xC7, 0x0D, 0xD0, 0x77, 0x20, 0x5E, 0x03, 0x70, 0x3E, 0x81,
  0xC5, 0x14, 0x04, 0x0B, 0xE0, 0x67, 0x20, 0x5F, 0x90, 0xFD, 0xF9, 0x09, 0x74, 0x05, 0xFF, 0xB0,
  0x87, 0x60, 0x20, 0xCF, 0xE0, 0xD0, 0x47, 0x72, 0x04, 0x0B, 0xFB, 0x0E, 0x77, 0x78, 0x33, 0x56,
  0x77, 0xD0, 0x87, 0x77, 0x40, 0x9D, 0x04, 0x77, 0x74, 0x0D, 0xC0, 0xE0, 0x17, 0x77, 0x30, 0x4D,
  0x0B, 0x77, 0x74, 0x0A, 0xD0, 0x67, 0x77, 0x30, 0x10, 0xED, 0x03, 0x77, 0x73, 0x05, 0xD0, 0xD7,
  0x77, 0x40, 0xAD, 0x09, 0x77, 0x73, 0x01, 0x0E, 0xD0, 0x57, 0x77, 0x30, 0x6D, 0x0E, 0x01, 0x10,
  // "R" (U+0052)
  0x03, 0xFA, 0x84, 0xED, 0xCA, 0x74, 0x73, 0x03, 0xFF, 0x98, 0x1E, 0x81, 0x70, 0x3F, 0xFB, 0x0E,
  0x04, 0x60, 0x3F, 0xFD, 0x06, 0x50, 0x3D, 0x80, 0x15, 0x81, 0x69, 0xDF, 0x03, 0x40, 0x3C, 0x0E,
  0x71, 0x03, 0x0C, 0xD0, 0xC4, 0x03, 0xC0, 0xE7, 0x30, 0xBD, 0x04, 0x30, 0x3C, 0x0E, 0x73, 0x01,
  0x0E, 0xC0, 0x93, 0x03, 0xC0, 0xE7, 0x40, 0x8C, 0x0D, 0x30, 0x3C, 0x0E, 0x74, 0x04, 0xD0, 0x12,
  0x03, 0xC0, 0xE7, 0x40, 0x1D, 0x02, 0x20, 0x3C, 0x0E, 0x75, 0xD0, 0x32, 0x03, 0xC0, 0xE7, 0x5D,
  0x04, 0x20, 0x3C, 0x0E, 0x74, 0x01, 0xD0, 0x32, 0x03, 0xC0, 0xE7, 0x40, 0x2D, 0x02, 0x20, 0x3C,
  0x0E, 0x74, 0x06, 0xC0, 0xE3, 0x03, 0xC0, 0xE7, 0x40, 0xBC, 0x0B, 0x30, 0x3C, 0x0E, 0x73, 0x03,
  0xD0, 0x63, 0x03, 0xC0, 0xE7, 0x20, 0x10, 0xDC, 0x0D, 0x40, 0x3C, 0x0E, 0x71, 0x05, 0x0D, 0xD0,
  0x54, 0x03, 0xD8, 0x01, 0x58, 0x16, 0x9D, 0xE0, 0x95, 0x03, 0xFF, 0xC0, 0x96, 0x03, 0xFF, 0xA0,
  0xE0, 0x57, 0x03, 0xFF, 0x90, 0x80, 0x17, 0x10, 0x3F, 0xF9, 0x08, 0x72, 0x03, 0xC0, 0xE5, 0x04,
  0xD0, 0x17, 0x10, 0x3C, 0x0E, 0x60, 0xCC, 0x08, 0x71, 0x03, 0xC0, 0xE6, 0x05, 0xC0, 0xE0, 0x17,
  0x03, 0xC0, 0xE7, 0x0D, 0xC0, 0x87, 0x03, 0xC0, 0xE7, 0x06, 0xC0, 0xE0, 0x16, 0x03, 0xC0, 0xE7,
  0x10, 0xEC, 0x08, 0x60, 0x3C, 0x0E, 0x71, 0x07, 0xC0, 0xE0, 0x15, 0x03, 0xC0, 0xE7, 0x20, 0xEC,
  0x08, 0x50, 0x3C, 0x0E, 0x72, 0x08, 0xC0, 0xE0, 0x14, 0x03, 0xC0, 0xE7, 0x20, 0x1D, 0x08, 0x40,
  0x3C, 0x0E, 0x73, 0x09, 0xC0, 0xE0, 0x13, 0x03, 0xC0, 0xE7, 0x30, 0x2D, 0x08, 0x30, 0x3C, 0x0E,
  0x74, 0x0A, 0xC0, 0xE0, 0x12, 0x03, 0xC0, 0xE7, 0x40, 0x2D, 0x08, 0x20, 0x3C, 0x0E, 0x75, 0x0B,
  0xC8, 0x2E, 0x10, 0x3C, 0x0E, 0x75, 0x03, 0xD8, 0x18, 0x03, 0xC0, 0xE7, 0x60, 0xBC, 0x81, 0xE1,
  0x3C, 0x0E, 0x76, 0x04, 0xD0, 0x80,
  // "S" (U+0053)
  0x72, 0x86, 0x25, 0x67, 0x76, 0x42, 0x75, 0x81, 0x18, 0xDF, 0xA8, 0x1B, 0x72, 0x70, 0x7F, 0xF9,
  0x0C, 0x01, 0x40, 0xBF, 0xFA, 0x0D, 0x40, 0xBF, 0x81, 0xED, 0xDF, 0x07, 0x30, 0x6D, 0x81, 0xE7,
  0x14, 0x81, 0x26, 0xBB, 0x01, 0x30, 0xEC, 0x0D, 0x01, 0x72, 0x81, 0x18, 0xA3, 0x06, 0xD0, 0x27,
  0x72, 0x0B, 0xC0, 0x97, 0x73, 0x0E, 0xC0, 0x47, 0x73, 0xD0, 0x27, 0x72, 0x01, 0xD0, 0x17, 0x72,
  0x01, 0xD0, 0x37, 0x73, 0xD0, 0x57, 0x73, 0x0E, 0xC0, 0xA7, 0x73, 0x0B, 0xD0, 0x47, 0x72, 0x06,
  0xD0, 0xE0, 0x27, 0x71, 0x01, 0x0E, 0xD0, 0xE0, 0x57, 0x71, 0x06, 0xF0, 0xA0, 0x27, 0x70, 0xBF,
  0x90, 0x90, 0x27, 0x60, 0xBF, 0xA0, 0x90, 0x17, 0x50, 0xAF, 0xA0, 0xE0, 0x77, 0x50, 0x50, 0xEF,
  0xA0, 0xC0, 0x17, 0x50, 0x80, 0xEF, 0x90, 0xE0, 0x37, 0x50, 0x10, 0x8F, 0x90, 0xE0, 0x27, 0x60,
  0x10, 0x9F, 0x0D, 0x77, 0x10, 0x30, 0xCE, 0x07, 0x77, 0x20, 0xBD, 0x0E, 0x77, 0x30, 0xCD, 0x04,
  0x77, 0x20, 0x2D, 0x08, 0x77, 0x30, 0xBC, 0x0A, 0x77, 0x30, 0x8C, 0x0B, 0x77, 0x30, 0x6C, 0x0B,
  0x77, 0x30, 0x6C, 0x0B, 0x77, 0x30, 0x7C, 0x09, 0x77, 0x30, 0xBC, 0x06, 0x77, 0x20, 0x2D, 0x00,
  0x17, 0x71, 0x0C, 0xC8, 0x3B, 0x07, 0xC5, 0x75, 0x0A, 0xD8, 0x14, 0x07, 0xA8, 0x2E, 0xA6, 0x35,
  0x81, 0x16, 0xDD, 0x0A, 0x20, 0x7F, 0x82, 0xED, 0xDE, 0xF0, 0xD0, 0x12, 0x07, 0xFF, 0xB0, 0xC0,
  0x13, 0x06, 0xFF, 0xA0, 0x86, 0x82, 0x27, 0xBE, 0xFA, 0x81, 0xE9, 0x27, 0x48, 0x72, 0x45, 0x67,
  0x76, 0x52, 0x72,
  // "T" (U+0054)
  0x06, 0xFF, 0xFB, 0x04, 0x06, 0xFF, 0xFB, 0x04, 0x06, 0xFF, 0xFB, 0x04, 0x06, 0xFF, 0xFB, 0x04,
  0x02, 0x80, 0x55, 0x0A, 0xC0, 0xA8, 0x05, 0x50, 0x17, 0x30, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08,
  0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08,
  0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08,
  0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08,
  0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08,
  0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08,
  0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08,
  0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08,
  0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08,
  0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08,
  0x73,
  // "U" (U+0055)
  0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97,
  0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0,
  0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09,
  0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C,
  0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0,
  0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08,
  0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C,
  0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10,
  0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08,
  0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71,
  0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90,
  0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77,
  0x10, 0x9C, 0x08, 0x07, 0xC0, 0xA7, 0x71, 0x09, 0xC0, 0x70, 0x6C, 0x0B, 0x77, 0x10, 0xAC, 0x06,
  0x04, 0xC0, 0xD7, 0x71, 0x0D, 0xC0, 0x50, 0x1D, 0x01, 0x77, 0xD8, 0x12, 0x0D, 0xC0, 0x67, 0x60,
  0x5C, 0x0E, 0x20, 0x9C, 0x0C, 0x76, 0x0B, 0xC0, 0xA2, 0x03, 0xD0, 0x77, 0x40, 0x5D, 0x04, 0x30,
  0xBD, 0x07, 0x72, 0x04, 0xD0, 0xD4, 0x02, 0xE8, 0x1C, 0x51, 0x40, 0x40, 0xAE, 0x03, 0x50, 0x6F,
  0x98, 0x1E, 0xDD, 0xF9, 0x08, 0x70, 0x6F, 0xFB, 0x08, 0x72, 0x04, 0x0D, 0xFE, 0x0E, 0x05, 0x75,
  0x05, 0x0B, 0xFA, 0x0C, 0x06, 0x77, 0x38, 0x53, 0x56, 0x76, 0x54, 0x73,
  // "V" (U+0056)
  0x0D, 0xC0, 0x87, 0x73, 0x03, 0xD0, 0x30, 0x9C, 0x0C, 0x77, 0x30, 0x7C, 0x81, 0xE0, 0x4D, 0x01,
  0x77, 0x20, 0xBC, 0x0A, 0x2D, 0x04, 0x77, 0x20, 0xEC, 0x05, 0x20, 0xBC, 0x08, 0x77, 0x10, 0x3D,
  0x01, 0x20, 0x7C, 0x0C, 0x77, 0x10, 0x7C, 0x0C, 0x30, 0x3D, 0x01, 0x77, 0x0B, 0xC0, 0x84, 0x0E,
  0xC0, 0x57, 0x7D, 0x04, 0x40, 0xAC, 0x09, 0x76, 0x04, 0xC0, 0xE5, 0x06, 0xC0, 0xD7, 0x60, 0x8C,
  0x0B, 0x50, 0x1D, 0x01, 0x75, 0x0C, 0xC0, 0x66, 0x0D, 0xC0, 0x57, 0x40, 0x1D, 0x02, 0x60, 0x9C,
  0x09, 0x74, 0x05, 0xC0, 0xD7, 0x04, 0xC0, 0xD7, 0x40, 0x9C, 0x09, 0x71, 0xD0, 0x27, 0x30, 0xDC,
  0x05, 0x71, 0x0B, 0xC0, 0x67, 0x20, 0x1D, 0x01, 0x71, 0x07, 0xC0, 0xA7, 0x20, 0x6C, 0x0C, 0x72,
  0x03, 0xC0, 0xE7, 0x20, 0xAC, 0x07, 0x73, 0x0E, 0xC0, 0x37, 0x10, 0xEC, 0x03, 0x73, 0x0A, 0xC0,
  0x77, 0x02, 0xC0, 0xE7, 0x40, 0x6C, 0x0B, 0x70, 0x6C, 0x0A, 0x74, 0x01, 0xC0, 0xE7, 0x0A, 0xC0,
  0x67, 0x50, 0xDC, 0x03, 0x60, 0xEC, 0x01, 0x75, 0x08, 0xC0, 0x75, 0x03, 0xC0, 0xD7, 0x60, 0x4C,
  0x0B, 0x50, 0x7C, 0x08, 0x77, 0xD5, 0x0B, 0xC0, 0x47, 0x70, 0xBC, 0x04, 0x4D, 0x77, 0x10, 0x7C,
  0x08, 0x30, 0x4C, 0x0B, 0x77, 0x10, 0x3C, 0x0C, 0x30, 0x8C, 0x07, 0x77, 0x20, 0xEC, 0x30, 0xCC,
  0x02, 0x77, 0x20, 0xAC, 0x03, 0x2C, 0x0E, 0x77, 0x30, 0x5C, 0x81, 0x70, 0x4C, 0x09, 0x77, 0x30,
  0x1C, 0x81, 0xA0, 0x7C, 0x05, 0x77, 0x40, 0xDB, 0x81, 0xE0, 0xBC, 0x01, 0x77, 0x40, 0x8C, 0x01,
  0x0E, 0xB0, 0xC7, 0x75, 0x04, 0xC0, 0x5C, 0x08, 0x77, 0x6C, 0x0B, 0xC0, 0x37, 0x76, 0x0B, 0xF0,
  0xE7, 0x77, 0x07, 0xF0, 0xA7, 0x77, 0x03, 0xF0, 0x67, 0x77, 0x10, 0xEE, 0x02, 0x77, 0x71, 0x0A,
  0xD0, 0xD7, 0x77, 0x20, 0x5D, 0x09, 0x75,
  // "W" (U+0057)
  0x08, 0xC0, 0xB7, 0x70, 0x2D, 0x77, 0x10, 0xBC, 0x07, 0x04, 0xC0, 0xE7, 0x70, 0x6D, 0x04, 0x77,
  0x0E, 0xC0, 0x30, 0x1D, 0x02, 0x76, 0x09, 0xD0, 0x77, 0x60, 0x3D, 0x20, 0xDC, 0x06, 0x76, 0x0D,
  0xD0, 0xB7, 0x60, 0x6C, 0x0C, 0x20, 0x9C, 0x09, 0x75, 0x01, 0xE0, 0xE7, 0x60, 0x9C, 0x08, 0x20,
  0x6C, 0x0C, 0x75, 0x04, 0xF0, 0x27, 0x50, 0xDC, 0x05, 0x20, 0x2D, 0x75, 0x08, 0xF0, 0x67, 0x40,
  0x1D, 0x01, 0x30, 0xEC, 0x03, 0x74, 0x0B, 0xB0, 0xEB, 0x09, 0x74, 0x04, 0xC0, 0xD4, 0x0B, 0xC0,
  0x77, 0x4C, 0x0A, 0xB0, 0xD7, 0x40, 0x7C, 0x0A, 0x40, 0x7C, 0x0A, 0x73, 0x03, 0xC0, 0x6C, 0x01,
  0x73, 0x0B, 0xC0, 0x74, 0x04, 0xC0, 0xD7, 0x30, 0x7C, 0x02, 0xC0, 0x57, 0x30, 0xEC, 0x03, 0x40,
  0x1D, 0x01, 0x72, 0x0A, 0xB0, 0xC1, 0xC0, 0x87, 0x20, 0x2D, 0x60, 0xDC, 0x04, 0x72, 0x0E, 0xB8,
  0x19, 0x0C, 0xB0, 0xC7, 0x20, 0x5C, 0x0C, 0x60, 0x9C, 0x08, 0x71, 0x02, 0xC8, 0x16, 0x09, 0xC7,
  0x20, 0x8C, 0x08, 0x60, 0x6C, 0x0B, 0x71, 0x05, 0xC8, 0x13, 0x06, 0xC0, 0x37, 0x10, 0xCC, 0x05,
  0x60, 0x2C, 0x0E, 0x71, 0x09, 0xC2, 0x03, 0xC0, 0x77, 0x1D, 0x01, 0x70, 0xEC, 0x02, 0x70, 0xCB,
  0x0C, 0x30, 0xEB, 0x0A, 0x70, 0x3C, 0x0D, 0x71, 0x0B, 0xC0, 0x57, 0xC0, 0x83, 0x0B, 0xB0, 0xE7,
  0x06, 0xC0, 0xA7, 0x10, 0x7C, 0x09, 0x60, 0x4C, 0x05, 0x30, 0x7C, 0x02, 0x60, 0xAC, 0x07, 0x71,
  0x04, 0xC0, 0xC6, 0x07, 0xC0, 0x13, 0x04, 0xC0, 0x66, 0x0D, 0xC0, 0x37, 0x2D, 0x60, 0xBB, 0x0D,
  0x5C, 0x09, 0x50, 0x1D, 0x73, 0x0C, 0xC0, 0x35, 0x0E, 0xB0, 0xA5, 0x0C, 0xB0, 0xD5, 0x04, 0xC0,
  0xC7, 0x30, 0x9C, 0x07, 0x40, 0x2C, 0x06, 0x50, 0x9C, 0x01, 0x40, 0x8C, 0x08, 0x73, 0x05, 0xC0,
  0xA4, 0x06, 0xC0, 0x35, 0x05, 0xC0, 0x44, 0x0B, 0xC0, 0x57, 0x30, 0x2C, 0x0D, 0x40, 0x9B, 0x0E,
  0x60, 0x1C, 0x08, 0x40, 0xEC, 0x01, 0x74, 0x0E, 0xC0, 0x13, 0x0D, 0xB0, 0xB7, 0x0D, 0xB0, 0xB3,
  0x02, 0xC0, 0xD7, 0x50, 0xAC, 0x04, 0x20, 0x1C, 0x08, 0x70, 0xAC, 0x30, 0x5C, 0x0A, 0x75, 0x07,
  0xC0, 0x72, 0x04, 0xC0, 0x47, 0x06, 0xC0, 0x32, 0x09, 0xC0, 0x77, 0x50, 0x3C, 0x0A, 0x20, 0x7C,
  0x01, 0x70, 0x2C, 0x06, 0x20, 0xCC, 0x03, 0x76, 0xC0, 0xD2, 0x0A, 0xB0, 0xD7, 0x20, 0xEB, 0x09,
  0x2D, 0x77, 0x0C, 0xC2, 0x0D, 0xB0, 0x97, 0x20, 0xBB, 0x81, 0xC0, 0x2C, 0x0C, 0x77, 0x08, 0xC0,
  0x30, 0x1C, 0x05, 0x72, 0x07, 0xC1, 0x05, 0xC0, 0x87, 0x70, 0x5C, 0x05, 0x03, 0xC0, 0x27, 0x20,
  0x3C, 0x02, 0x08, 0xC0, 0x57, 0x70, 0x1C, 0x08, 0x06, 0xB0, 0xE7, 0x4C, 0x04, 0x0A, 0xC0, 0x17,
  0x71, 0x0D, 0xB0, 0xA0, 0x9B, 0x0A, 0x74, 0x0C, 0xB0, 0x60, 0xCB, 0x0D, 0x77, 0x20, 0xAB, 0x0C,
  0x0B, 0xB0, 0x77, 0x40, 0x8B, 0x09, 0x0E, 0xB0, 0xA7, 0x72, 0x06, 0xB0, 0xE0, 0xDB, 0x03, 0x74,
  0x04, 0xB0, 0xCC, 0x07, 0x77, 0x20, 0x3F, 0x97, 0x50, 0x1F, 0x90, 0x37, 0x73, 0xF0, 0xC7, 0x60,
  0xDF, 0x77, 0x40, 0xBE, 0x08, 0x76, 0x09, 0xE0, 0xC7, 0x74, 0x08, 0xE0, 0x57, 0x60, 0x5E, 0x08,
  0x77, 0x40, 0x5E, 0x01, 0x76, 0x02, 0xE0, 0x57, 0x74, 0x01, 0xD0, 0xD7, 0x71, 0x0E, 0xD0, 0x17,
  0x20,
  // "X" (U+0058)
  0x10, 0x6D, 0x01, 0x75, 0x03, 0xD0, 0x22, 0x0E, 0xC0, 0x77, 0x50, 0x9C, 0x0B, 0x30, 0x7C, 0x0D,
  0x74, 0x01, 0xD0, 0x43, 0x01, 0x0E, 0xC0, 0x57, 0x30, 0x7C, 0x0C, 0x50, 0x8C, 0x0B, 0x73, 0x0D,
  0xC0, 0x55, 0x01, 0xD0, 0x27, 0x10, 0x5C, 0x0D, 0x70, 0x9C, 0x09, 0x71, 0x0B, 0xC0, 0x67, 0x02,
  0xC0, 0xE0, 0x16, 0x02, 0xC0, 0xE7, 0x20, 0xBC, 0x06, 0x60, 0x9C, 0x08, 0x72, 0x03, 0xC0, 0xD5,
  0x01, 0x0E, 0xC0, 0x17, 0x30, 0xCC, 0x04, 0x40, 0x7C, 0x09, 0x74, 0x05, 0xC0, 0xB4, 0x0D, 0xC0,
  0x27, 0x50, 0xDC, 0x02, 0x20, 0x4C, 0x0A, 0x76, 0x06, 0xC0, 0x82, 0x0B, 0xC0, 0x37, 0x70, 0xEB,
  0x81, 0xE0, 0x2C, 0x0C, 0x77, 0x10, 0x7C, 0x06, 0x08, 0xC0, 0x57, 0x71, 0x01, 0x0E, 0xB0, 0xD0,
  0xEB, 0x0D, 0x77, 0x30, 0x8F, 0x90, 0x67, 0x73, 0x01, 0xF0, 0xE7, 0x75, 0x09, 0xE0, 0x77, 0x75,
  0x02, 0xE0, 0x17, 0x75, 0x05, 0xD0, 0xE7, 0x76, 0x0C, 0xE0, 0x77, 0x74, 0x04, 0xF0, 0xD7, 0x74,
  0x0B, 0xF9, 0x06, 0x77, 0x20, 0x3C, 0x0C, 0xC0, 0xD7, 0x72, 0x0B, 0xC0, 0x40, 0xBC, 0x04, 0x77,
  0x03, 0xC8, 0x1C, 0x04, 0xC0, 0xC7, 0x70, 0xAC, 0x05, 0x20, 0xDC, 0x03, 0x75, 0x02, 0xC0, 0xD3,
  0x06, 0xC0, 0xB7, 0x50, 0xAC, 0x07, 0x40, 0xEC, 0x02, 0x73, 0x02, 0xC0, 0xE5, 0x08, 0xC0, 0xA7,
  0x30, 0x9C, 0x08, 0x50, 0x2D, 0x01, 0x71, 0x01, 0xD0, 0x16, 0x0A, 0xC0, 0x87, 0x10, 0x8C, 0x09,
  0x70, 0x4C, 0x0E, 0x01, 0x60, 0x10, 0xEC, 0x02, 0x71, 0x0C, 0xC0, 0x76, 0x08, 0xC0, 0xB7, 0x20,
  0x6C, 0x0E, 0x60, 0xEC, 0x04, 0x73, 0x0E, 0xC0, 0x64, 0x07, 0xC0, 0xC7, 0x40, 0x8C, 0x0D, 0x40,
  0xEC, 0x05, 0x74, 0x01, 0xD0, 0x52, 0x06, 0xC0, 0xD7, 0x60, 0xAC, 0x0C, 0x20, 0xDC, 0x06, 0x76,
  0x03, 0xD0, 0x40, 0x6C, 0x0E, 0x77, 0x10, 0xCC, 0x0B,
  // "Y" (U+0059)
  0x0C, 0xC0, 0xA7, 0x71, 0x0E, 0xC0, 0x06, 0xD0, 0x17, 0x60, 0x5C, 0x82, 0xE1, 0x0E, 0xC0, 0x67,
  0x60, 0xBC, 0x09, 0x20, 0x9C, 0x0C, 0x75, 0x01, 0xD0, 0x32, 0x02, 0xD0, 0x37, 0x40, 0x7C, 0x0C,
  0x40, 0xCC, 0x09, 0x74, 0x0D, 0xC0, 0x64, 0x05, 0xC0, 0xE7, 0x30, 0x4C, 0x0E, 0x60, 0xEC, 0x05,
  0x72, 0x0A, 0xC0, 0x96, 0x09, 0xC0, 0xB7, 0x10, 0x1D, 0x03, 0x60, 0x2D, 0x02, 0x70, 0x6C, 0x0C,
  0x71, 0x0C, 0xC0, 0x87, 0x0C, 0xC0, 0x57, 0x10, 0x5C, 0x0D, 0x60, 0x3C, 0x0E, 0x73, 0x0E, 0xC0,
  0x45, 0x09, 0xC0, 0x87, 0x30, 0x8C, 0x0A, 0x50, 0xEC, 0x02, 0x73, 0x02, 0xD0, 0x13, 0x05, 0xC0,
  0xB7, 0x50, 0xBC, 0x07, 0x30, 0xBC, 0x05, 0x75, 0x05, 0xC0, 0xD2, 0x01, 0xC0, 0xE7, 0x70, 0xEC,
  0x81, 0x30, 0x7C, 0x08, 0x77, 0x08, 0xC8, 0x19, 0x0D, 0xC0, 0x27, 0x70, 0x2C, 0x0E, 0x05, 0xC0,
  0xB7, 0x72, 0x0B, 0xC0, 0xEC, 0x05, 0x77, 0x20, 0x5F, 0x90, 0xE7, 0x74, 0x0E, 0xF0, 0x87, 0x74,
  0x08, 0xF0, 0x17, 0x74, 0x02, 0xE0, 0xB7, 0x76, 0x0B, 0xD0, 0x47, 0x76, 0x05, 0xC0, 0xE7, 0x77,
  0x04, 0xC0, 0xE7, 0x77, 0x04, 0xC0, 0xE7, 0x77, 0x04, 0xC0, 0xE7, 0x77, 0x04, 0xC0, 0xE7, 0x77,
  0x04, 0xC0, 0xE7, 0x77, 0x04, 0xC0, 0xE7, 0x77, 0x04, 0xC0, 0xE7, 0x77, 0x04, 0xC0, 0xE7, 0x77,
  0x04, 0xC0, 0xE7, 0x77, 0x04, 0xC0, 0xE7, 0x77, 0x04, 0xC0, 0xE7, 0x77, 0x04, 0xC0, 0xE7, 0x77,
  0x04, 0xC0, 0xE7, 0x77, 0x04, 0xC0, 0xE7, 0x77, 0x04, 0xC0, 0xE7, 0x77, 0x04, 0xC0, 0xE7, 0x40,
  // "Z" (U+005A)
  0x10, 0xDF, 0xFE, 0x81, 0x70, 0xDF, 0xFE, 0x81, 0x70, 0xDF, 0xFE, 0x81, 0x70, 0xDF, 0xFE, 0x81,
  0x60, 0x48, 0x09, 0x25, 0x09, 0xD0, 0x27, 0x72, 0x0C, 0xC0, 0xA7, 0x72, 0x04, 0xD0, 0x37, 0x72,
  0x0B, 0xC0, 0xB7, 0x72, 0x03, 0xD0, 0x47, 0x72, 0x0A, 0xC0, 0xC7, 0x72, 0x01, 0xD0, 0x57, 0x72,
  0x08, 0xC0, 0xD7, 0x73, 0x0E, 0xC0, 0x77, 0x72, 0x07, 0xC0, 0xE7, 0x73, 0x0D, 0xC0, 0x87, 0x72,
  0x05, 0xD0, 0x17, 0x72, 0x0C, 0xC0, 0x97, 0x72, 0x04, 0xD0, 0x27, 0x72, 0x0B, 0xC0, 0xB7, 0x72,
  0x02, 0xD0, 0x47, 0x72, 0x0A, 0xC0, 0xC7, 0x72, 0x01, 0xD0, 0x57, 0x72, 0x08, 0xC0, 0xD7, 0x73,
  0x0E, 0xC0, 0x67, 0x72, 0x07, 0xC0, 0xE7, 0x73, 0x0D, 0xC0, 0x87, 0x72, 0x05, 0xD0, 0x17, 0x72,
  0x0C, 0xC0, 0x97, 0x72, 0x04, 0xD0, 0x27, 0x72, 0x0B, 0xC0, 0xA7, 0x72, 0x02, 0xD0, 0x37, 0x72,
  0x09, 0xC0, 0xC7, 0x72, 0x01, 0xD0, 0x47, 0x72, 0x08, 0xC0, 0xD7, 0x73, 0x0E, 0xC0, 0x67, 0x72,
  0x07, 0xC0, 0xE7, 0x73, 0x0D, 0xC0, 0x77, 0x72, 0x05, 0xC0, 0xE0, 0x17, 0x72, 0x0C, 0xC0, 0xB8,
  0x09, 0x35, 0x04, 0x02, 0xFF, 0xF0, 0xE0, 0x3F, 0xFF, 0x0E, 0x03, 0xFF, 0xF0, 0xE0, 0x3F, 0xFF,
  0x0E,
  // "[" (U+005B)
  0x08, 0xFD, 0x04, 0x08, 0xFD, 0x04, 0x08, 0xFD, 0x04, 0x08, 0xFD, 0x04, 0x08, 0xC0, 0x78, 0x03,
  0x50, 0x10, 0x8C, 0x03, 0x71, 0x08, 0xC0, 0x37, 0x10, 0x8C, 0x03, 0x71, 0x08, 0xC0, 0x37, 0x10,
  0x8C, 0x03, 0x71, 0x08, 0xC0, 0x37, 0x10, 0x8C, 0x03, 0x71, 0x08, 0xC0, 0x37, 0x10, 0x8C, 0x03,
  0x71, 0x08, 0xC0, 0x37, 0x10, 0x8C, 0x03, 0x71, 0x08, 0xC0, 0x37, 0x10, 0x8C, 0x03, 0x71, 0x08,
  0xC0, 0x37, 0x10, 0x8C, 0x03, 0x71, 0x08, 0xC0, 0x37, 0x10, 0x8C, 0x03, 0x71, 0x08, 0xC0, 0x37,
  0x10, 0x8C, 0x03, 0x71, 0x08, 0xC0, 0x37, 0x10, 0x8C, 0x03, 0x71, 0x08, 0xC0, 0x37, 0x10, 0x8C,
  0x03, 0x71, 0x08, 0xC0, 0x37, 0x10, 0x8C, 0x03, 0x71, 0x08, 0xC0, 0x37, 0x10, 0x8C, 0x03, 0x71,
  0x08, 0xC0, 0x37, 0x10, 0x8C, 0x03, 0x71, 0x08, 0xC0, 0x37, 0x10, 0x8C, 0x03, 0x71, 0x08, 0xC0,
  0x37, 0x10, 0x8C, 0x03, 0x71, 0x08, 0xC0, 0x37, 0x10, 0x8C, 0x03, 0x71, 0x08, 0xC0, 0x37, 0x10,
  0x8C, 0x03, 0x71, 0x08, 0xC0, 0x37, 0x10, 0x8C, 0x03, 0x71, 0x08, 0xC0, 0x37, 0x10, 0x8C, 0x03,
  0x71, 0x08, 0xC0, 0x37, 0x10, 0x8C, 0x03, 0x71, 0x08, 0xC0, 0x37, 0x10, 0x8F, 0xD0, 0x40, 0x8F,
  0xD0, 0x40, 0x8F, 0xD0, 0x40, 0x8F, 0xD0, 0x40, 0x28, 0x09, 0x05, 0x01,
  // "\" (U+005C)
  0x0D, 0xB0, 0xD7, 0x72, 0x07, 0xC0, 0x37, 0x71, 0x02, 0xC0, 0x97, 0x72, 0x0B, 0xB0, 0xE7, 0x72,
  0x06, 0xC0, 0x57, 0x72, 0xC0, 0xB7, 0x72, 0x0A, 0xC0, 0x17, 0x71, 0x04, 0xC0, 0x77, 0x72, 0x0E,
  0xB0, 0xC7, 0x72, 0x08, 0xC0, 0x37, 0x71, 0x03, 0xC0, 0x87, 0x72, 0x0C, 0xB0, 0xE7, 0x72, 0x07,
  0xC0, 0x47, 0x71, 0x01, 0xC0, 0xA7, 0x72, 0x0B, 0xC0, 0x17, 0x71, 0x05, 0xC0, 0x67, 0x72, 0x0E,
  0xB0, 0xC7, 0x72, 0x09, 0xC0, 0x27, 0x71, 0x04, 0xC0, 0x87, 0x72, 0x0D, 0xB0, 0xD7, 0x72, 0x08,
  0xC0, 0x37, 0x71, 0x02, 0xC0, 0x97, 0x72, 0x0C, 0xB0, 0xE7, 0x72, 0x06, 0xC0, 0x57, 0x71, 0x01,
  0xC0, 0xB7, 0x72, 0x0A, 0xC0, 0x17, 0x71, 0x05, 0xC0, 0x77, 0x72, 0x0E, 0xB0, 0xC7, 0x72, 0x09,
  0xC0, 0x37, 0x71, 0x03, 0xC0, 0x87, 0x72, 0x0D, 0xB0, 0xE7, 0x72, 0x07, 0xC0, 0x47, 0x71, 0x01,
  0xC0, 0xA7, 0x72, 0x0B, 0xC0, 0x17, 0x71, 0x06, 0xC0, 0x67, 0x72, 0x0E, 0xB0, 0xC7, 0x72, 0x0A,
  0xC0, 0x27, 0x71, 0x04, 0xC0, 0x87, 0x72, 0x0E, 0xB0, 0xD7, 0x72, 0x08, 0xC0, 0x37, 0x71, 0x02,
  0xC0, 0x97, 0x72, 0x0C, 0xB0, 0xE7, 0x72, 0x07, 0xC0, 0x50,
  // "]" (U+005D)
  0x04, 0xFD, 0x09, 0x04, 0xFD, 0x09, 0x04, 0xFD, 0x09, 0x04, 0xFD, 0x09, 0x01, 0x80, 0x35, 0x07,
  0xC0, 0x97, 0x10, 0x3C, 0x09, 0x71, 0x03, 0xC0, 0x97, 0x10, 0x3C, 0x09, 0x71, 0x03, 0xC0, 0x97,
  0x10, 0x3C, 0x09, 0x71, 0x03, 0xC0, 0x97, 0x10, 0x3C, 0x09, 0x71, 0x03, 0xC0, 0x97, 0x10, 0x3C,
  0x09, 0x71, 0x03, 0xC0, 0x97, 0x10, 0x3C, 0x09, 0x71, 0x03, 0xC0, 0x97, 0x10, 0x3C, 0x09, 0x71,
  0x03, 0xC0, 0x97, 0x10, 0x3C, 0x09, 0x71, 0x03, 0xC0, 0x97, 0x10, 0x3C, 0x09, 0x71, 0x03, 0xC0,
  0x97, 0x10, 0x3C, 0x09, 0x71, 0x03, 0xC0, 0x97, 0x10, 0x3C, 0x09, 0x71, 0x03, 0xC0, 0x97, 0x10,
  0x3C, 0x09, 0x71, 0x03, 0xC0, 0x97, 0x10, 0x3C, 0x09, 0x71, 0x03, 0xC0, 0x97, 0x10, 0x3C, 0x09,
  0x71, 0x03, 0xC0, 0x97, 0x10, 0x3C, 0x09, 0x71, 0x03, 0xC0, 0x97, 0x10, 0x3C, 0x09, 0x71, 0x03,
  0xC0, 0x97, 0x10, 0x3C, 0x09, 0x71, 0x03, 0xC0, 0x97, 0x10, 0x3C, 0x09, 0x71, 0x03, 0xC0, 0x97,
  0x10, 0x3C, 0x09, 0x71, 0x03, 0xC0, 0x97, 0x10, 0x3C, 0x09, 0x71, 0x03, 0xC0, 0x97, 0x10, 0x3C,
  0x09, 0x71, 0x03, 0xC0, 0x97, 0x10, 0x3C, 0x09, 0x71, 0x03, 0xC0, 0x90, 0x4F, 0xD0, 0x90, 0x4F,
  0xD0, 0x90, 0x4F, 0xD0, 0x90, 0x4F, 0xD0, 0x90, 0x18, 0x09, 0x05, 0x02,
  // "^" (U+005E)
  0x74, 0x82, 0x27, 0x76, 0x77, 0x72, 0x0A, 0xB0, 0x37, 0x77, 0x02, 0xC0, 0xA7, 0x77, 0x09, 0xD0,
  0x27, 0x75, 0x01, 0xE0, 0xA7, 0x75, 0x08, 0xF0, 0x27, 0x73, 0x01, 0x0E, 0xF0, 0x97, 0x73, 0x07,
  0xB0, 0xE0, 0x6C, 0x01, 0x77, 0x20, 0xEB, 0x81, 0x70, 0xDB, 0x09, 0x77, 0x10, 0x6B, 0x82, 0xE1,
  0x06, 0xC0, 0x17, 0x70, 0xDB, 0x09, 0x30, 0xEB, 0x08, 0x76, 0x05, 0xC0, 0x23, 0x07, 0xB0, 0xE0,
  0x17, 0x50, 0xCB, 0x0A, 0x40, 0x10, 0xEB, 0x08, 0x74, 0x04, 0xC0, 0x35, 0x08, 0xB0, 0xE0, 0x17,
  0x30, 0xBB, 0x0B, 0x60, 0x1C, 0x07, 0x72, 0x03, 0xC0, 0x47, 0x09, 0xB0, 0xE7, 0x20, 0xBB, 0x0D,
  0x71, 0x02, 0xC0, 0x77, 0x02, 0xC0, 0x67, 0x20, 0xAB, 0x0E, 0x70, 0xAB, 0x0E, 0x73, 0x03, 0xC0,
  0x65, 0x01, 0xC0, 0x77, 0x40, 0xBB, 0x0D, 0x50, 0x9B, 0x0E, 0x01, 0x74, 0x04, 0xC0, 0x63, 0x01,
  0x0E, 0xB0, 0x97, 0x60, 0xCB, 0x0D, 0x30, 0x8C, 0x02, 0x76, 0x04, 0xC0, 0x52, 0x0E, 0xB0, 0xA7,
  0x71, 0x0D, 0xB8, 0x1D, 0x07, 0xC0, 0x37, 0x71, 0x05, 0xC0, 0x50,
  // "_" (U+005F)
  0x18, 0x0A, 0x65, 0x02, 0x01, 0xFF, 0xFD, 0x07, 0x01, 0xFF, 0xFD, 0x07, 0x01, 0xFF, 0xFD, 0x07,
  0x01, 0xFF, 0xFD, 0x07,
  // "`" (U+0060)
  0x04, 0x80, 0x17, 0x03, 0x50, 0x4D, 0x0D, 0x60, 0x9D, 0x05, 0x60, 0xBC, 0x0D, 0x60, 0x10, 0xDC,
  0x08, 0x60, 0x10, 0xDC, 0x03, 0x60, 0x20, 0xEB, 0x0C, 0x70, 0x20, 0xEB, 0x07, 0x70, 0x20, 0xDB,
  0x03, 0x70, 0x20, 0xDA, 0x0B,
  // "a" (U+0061)
  0x71, 0x85, 0x14, 0x57, 0x76, 0x47, 0x58, 0x12, 0x8D, 0xF9, 0x0B, 0x03, 0x70, 0x20, 0xAF, 0xE0,
  0x76, 0x0D, 0xFF, 0x90, 0x65, 0x06, 0xE8, 0x1E, 0xDE, 0xE0, 0xE0, 0x15, 0x83, 0xEF, 0xD8, 0x34,
  0x02, 0x09, 0xD0, 0x75, 0x06, 0x05, 0x72, 0x09, 0xC0, 0xC7, 0x72, 0x01, 0xD7, 0x73, 0x0B, 0xC0,
  0x37, 0x72, 0x08, 0xC0, 0x57, 0x72, 0x07, 0xC0, 0x67, 0x72, 0x07, 0xC0, 0x67, 0x72, 0x07, 0xC0,
  0x76, 0x84, 0x16, 0x9C, 0xDE, 0xFA, 0x07, 0x40, 0x10, 0x9F, 0xF9, 0x07, 0x30, 0x50, 0xEF, 0xFA,
  0x07, 0x20, 0x5F, 0xFC, 0x81, 0x70, 0x2E, 0x82, 0xD7, 0x31, 0x40, 0x7C, 0x81, 0x70, 0xAD, 0x07,
  0x71, 0x07, 0xC0, 0x70, 0x1D, 0x08, 0x72, 0x07, 0xC0, 0x70, 0x5C, 0x0E, 0x73, 0x07, 0xC0, 0x70,
  0x8C, 0x09, 0x73, 0x08, 0xC0, 0x70, 0x9C, 0x07, 0x73, 0x09, 0xC0, 0x70, 0xAC, 0x06, 0x73, 0x0C,
  0xC0, 0x70, 0xAC, 0x06, 0x72, 0x01, 0xD0, 0x70, 0x9C, 0x08, 0x72, 0x07, 0xD0, 0x70, 0x6C, 0x0D,
  0x71, 0x02, 0x0E, 0xD0, 0x70, 0x2D, 0x06, 0x60, 0x10, 0xDE, 0x81, 0x70, 0xCD, 0x07, 0x38, 0x11,
  0x6E, 0xA0, 0x9C, 0x81, 0x70, 0x5F, 0x00, 0xDC, 0x81, 0xD0, 0xDB, 0x07, 0x20, 0xBF, 0xC8, 0x2E,
  0x20, 0xBB, 0x07, 0x30, 0xCF, 0xA0, 0xE0, 0x32, 0x08, 0xB0, 0x74, 0x08, 0x0E, 0xD8, 0x1E, 0x91,
  0x30, 0x6B, 0x07, 0x68, 0x34, 0x67, 0x64, 0x74,
  // "b" (U+0062)
  0x0B, 0xC0, 0x37, 0x74, 0x0B, 0xC0, 0x37, 0x74, 0x0B, 0xC0, 0x37, 0x74, 0x0B, 0xC0, 0x37, 0x74,
  0x0B, 0xC0, 0x37, 0x74, 0x0B, 0xC0, 0x37, 0x74, 0x0B, 0xC0, 0x37, 0x74, 0x0B, 0xC0, 0x37, 0x74,
  0x0B, 0xC0, 0x37, 0x74, 0x0B, 0xC0, 0x37, 0x74, 0x0B, 0xC0, 0x37, 0x74, 0x0B, 0xC0, 0x37, 0x74,
  0x0B, 0xC0, 0x37, 0x74, 0x0B, 0xC0, 0x34, 0x84, 0x15, 0x77, 0x63, 0x71, 0x0B, 0xC0, 0x32, 0x02,
  0x0A, 0xE0, 0xE0, 0x76, 0x0B, 0xC8, 0x22, 0x05, 0xEF, 0xA0, 0xD0, 0x24, 0x0B, 0xC0, 0x10, 0x4F,
  0xD0, 0xE0, 0x23, 0x0B, 0xC0, 0x20, 0xEC, 0x00, 0xDF, 0x0C, 0x30, 0xBC, 0x0C, 0xA0, 0xC0, 0x54,
  0x05, 0x0D, 0xD0, 0x62, 0x0B, 0xE0, 0xB7, 0x01, 0x0D, 0xC0, 0xE2, 0x0B, 0xD0, 0xE0, 0x17, 0x10,
  0x3D, 0x81, 0x50, 0xBD, 0x07, 0x73, 0x0A, 0xC8, 0x1A, 0x0B, 0xD0, 0x17, 0x30, 0x4C, 0x81, 0xE0,
  0xBC, 0x0C, 0x75, 0xD0, 0x20, 0xBC, 0x0A, 0x75, 0x0C, 0xC0, 0x50, 0xBC, 0x07, 0x75, 0x0A, 0xC0,
  0x70, 0xBC, 0x05, 0x75, 0x08, 0xC0, 0x90, 0xBC, 0x05, 0x75, 0x07, 0xC0, 0xA0, 0xBC, 0x04, 0x75,
  0x06, 0xC0, 0x0B, 0xC0, 0x37, 0x50, 0x6C, 0x00, 0xBC, 0x03, 0x75, 0x06, 0xC0, 0x0B, 0xC0, 0x47,
  0x50, 0x6C, 0x00, 0xBC, 0x04, 0x75, 0x07, 0xC0, 0xA0, 0xBC, 0x05, 0x75, 0x08, 0xC0, 0x90, 0xBC,
  0x07, 0x75, 0x0A, 0xC0, 0x70, 0xBC, 0x09, 0x75, 0x0D, 0xC0, 0x50, 0xBC, 0x0D, 0x74, 0x01, 0xD0,
  0x20, 0xBD, 0x02, 0x73, 0x05, 0xC8, 0x1E, 0x0B, 0xD0, 0x87, 0x30, 0xBC, 0x81, 0xA0, 0xBD, 0x0E,
  0x02, 0x71, 0x03, 0xD8, 0x15, 0x0B, 0xE0, 0xC0, 0x16, 0x01, 0x0D, 0xC0, 0xD2, 0x0B, 0xC0, 0xEA,
  0x0D, 0x06, 0x40, 0x50, 0xDD, 0x06, 0x20, 0xBB, 0x0C, 0x03, 0xD0, 0xE0, 0xDF, 0x0C, 0x30, 0xBB,
  0x81, 0x90, 0x6F, 0xD0, 0xE0, 0x23, 0x0B, 0xB0, 0x62, 0x06, 0xFB, 0x0D, 0x02, 0x40, 0xBB, 0x03,
  0x30, 0x30, 0xBE, 0x0E, 0x08, 0x77, 0x28, 0x41, 0x57, 0x76, 0x47, 0x10,
  // "c" (U+0063)
  0x72, 0x86, 0x14, 0x67, 0x76, 0x41, 0x73, 0x04, 0x0B, 0xF9, 0x81, 0xC7, 0x15, 0x01, 0x0A, 0xFD,
  0x08, 0x40, 0x10, 0xDF, 0xE0, 0x34, 0x0C, 0xF0, 0xE0, 0xDC, 0x0D, 0x40, 0x7D, 0x0D, 0x06, 0x48,
  0x23, 0x9F, 0x83, 0x01, 0x0E, 0xC0, 0xC0, 0x17, 0x00, 0x13, 0x08, 0xC0, 0xE0, 0x17, 0x60, 0xDC,
  0x06, 0x76, 0x03, 0xC0, 0xE7, 0x70, 0x7C, 0x0A, 0x77, 0x0A, 0xC0, 0x67, 0x70, 0xDC, 0x04, 0x77,
  0xD0, 0x17, 0x7D, 0x77, 0x01, 0xD7, 0x70, 0x2C, 0x0E, 0x77, 0x02, 0xC0, 0xE7, 0x70, 0x2D, 0x77,
  0x01, 0xD7, 0x71, 0xD0, 0x17, 0x70, 0xEC, 0x03, 0x77, 0x0C, 0xC0, 0x67, 0x70, 0x9C, 0x0A, 0x77,
  0x05, 0xC0, 0xE7, 0x70, 0x1D, 0x06, 0x77, 0x0B, 0xC0, 0xD0, 0x17, 0x60, 0x4D, 0x0B, 0x72, 0x00,
  0x13, 0x0B, 0xD0, 0xD0, 0x54, 0x83, 0x15, 0xAF, 0x43, 0x01, 0x0E, 0xF8, 0x1D, 0xDE, 0xC0, 0x44,
  0x02, 0x0E, 0xFE, 0x04, 0x50, 0x20, 0xCF, 0xD0, 0x47, 0x05, 0x0B, 0xF8, 0x1E, 0xA3, 0x73, 0x85,
  0x14, 0x67, 0x75, 0x34,
  // "d" (U+0064)
  0x77, 0x50, 0xBC, 0x04, 0x77, 0x50, 0xBC, 0x04, 0x77, 0x50, 0xBC, 0x04, 0x77, 0x50, 0xBC, 0x04,
  0x77, 0x50, 0xBC, 0x04, 0x77, 0x50, 0xBC, 0x04, 0x77, 0x50, 0xBC, 0x04, 0x77, 0x50, 0xBC, 0x04,
  0x77, 0x50, 0xBC, 0x04, 0x77, 0x50, 0xBC, 0x04, 0x77, 0x50, 0xBC, 0x04, 0x77, 0x50, 0xBC, 0x04,
  0x77, 0x50, 0xBC, 0x04, 0x71, 0x84, 0x15, 0x77, 0x63, 0x50, 0xBC, 0x04, 0x60, 0x30, 0xBE, 0x0D,
  0x06, 0x30, 0xBC, 0x04, 0x50, 0x7F, 0xB0, 0xA2, 0x0B, 0xC0, 0x44, 0x07, 0xFD, 0x81, 0xC0, 0xAC,
  0x04, 0x30, 0x4F, 0x81, 0xED, 0xEC, 0x00, 0x9C, 0x04, 0x30, 0xDD, 0x09, 0x02, 0x30, 0x20, 0x9B,
  0x0D, 0xC0, 0x42, 0x05, 0xD0, 0x77, 0x05, 0xF0, 0x42, 0x0C, 0xC0, 0xB7, 0x20, 0x8E, 0x81, 0x40,
  0x1D, 0x03, 0x73, 0x0E, 0xD8, 0x14, 0x06, 0xC0, 0xD7, 0x40, 0x9D, 0x81, 0x40, 0x9C, 0x08, 0x74,
  0x05, 0xD8, 0x14, 0x0C, 0xC0, 0x57, 0x40, 0x1D, 0x81, 0x40, 0xEC, 0x02, 0x75, 0xD0, 0x40, 0x1D,
  0x76, 0x0D, 0xC0, 0x40, 0x1C, 0x0E, 0x76, 0x0C, 0xC0, 0x40, 0x2C, 0x0E, 0x76, 0x0B, 0xC0, 0x40,
  0x3C, 0x0D, 0x76, 0x0B, 0xC0, 0x40, 0x3C, 0x0D, 0x76, 0x0A, 0xC0, 0x40, 0x2C, 0x0E, 0x76, 0x0B,
  0xC0, 0x40, 0x1C, 0x0E, 0x76, 0x0B, 0xC0, 0x40, 0x1D, 0x76, 0x0C, 0xC8, 0x14, 0x0E, 0xC0, 0x27,
  0x50, 0xEC, 0x81, 0x40, 0xCC, 0x05, 0x75, 0xD8, 0x14, 0x0A, 0xC0, 0x87, 0x40, 0x4D, 0x81, 0x40,
  0x6C, 0x0C, 0x74, 0x08, 0xD8, 0x14, 0x02, 0xD0, 0x37, 0x30, 0xED, 0x04, 0x20, 0xCC, 0x0B, 0x72,
  0x07, 0xE0, 0x42, 0x06, 0xD0, 0x77, 0x04, 0xF0, 0x43, 0x0D, 0xD0, 0x90, 0x23, 0x02, 0x09, 0xB0,
  0xCC, 0x04, 0x30, 0x5F, 0x81, 0xED, 0xEC, 0x09, 0x04, 0xC0, 0x44, 0x08, 0xFD, 0x81, 0xC0, 0x2C,
  0x04, 0x50, 0x8F, 0xB0, 0xB0, 0x12, 0xC0, 0x46, 0x03, 0x0B, 0xE0, 0xE0, 0x74, 0x0C, 0xB0, 0x47,
  0x18, 0x41, 0x57, 0x76, 0x37, 0x40,
  // "e" (U+0065)
  0x72, 0x84, 0x25, 0x77, 0x64, 0x77, 0x20, 0x60, 0xDF, 0x09, 0x02, 0x74, 0x02, 0x0D, 0xFC, 0x06,
  0x72, 0x02, 0x0E, 0xFE, 0x07, 0x70, 0x10, 0xDE, 0x0E, 0x0D, 0xF0, 0x46, 0x08, 0xD0, 0x70, 0x13,
  0x04, 0x0D, 0xC0, 0xD5, 0x02, 0xD0, 0x46, 0x01, 0x0D, 0xC0, 0x64, 0x09, 0xC0, 0x77, 0x10, 0x3C,
  0x0D, 0x40, 0xEB, 0x0E, 0x73, 0x0B, 0xC0, 0x32, 0x03, 0xC0, 0x87, 0x30, 0x5C, 0x07, 0x20, 0x7C,
  0x04, 0x73, 0x01, 0xC0, 0xA2, 0x0A, 0xC0, 0x17, 0x40, 0xEB, 0x0D, 0x20, 0xDC, 0x75, 0x0C, 0xC2,
  0xC0, 0xE8, 0x09, 0x05, 0x0C, 0xC2, 0xFF, 0xF9, 0x00, 0x1F, 0xFF, 0x90, 0x10, 0x2F, 0xFF, 0x90,
  0x10, 0x2F, 0xFF, 0x90, 0x10, 0x2C, 0x0C, 0x77, 0x40, 0x1C, 0x0D, 0x77, 0x5C, 0x0E, 0x77, 0x50,
  0xDC, 0x01, 0x77, 0x40, 0xAC, 0x04, 0x77, 0x40, 0x7C, 0x08, 0x77, 0x40, 0x2C, 0x0D, 0x77, 0x50,
  0xDC, 0x06, 0x77, 0x40, 0x6C, 0x0E, 0x01, 0x77, 0x40, 0xEC, 0x0D, 0x02, 0x73, 0x05, 0x0A, 0x50,
  0x5D, 0x81, 0xE7, 0x24, 0x84, 0x14, 0x8E, 0xFC, 0x60, 0x9F, 0x82, 0xED, 0xDE, 0xD0, 0xC7, 0x0A,
  0xFF, 0x90, 0xC7, 0x10, 0x7F, 0xF0, 0x87, 0x28, 0x12, 0x9E, 0xF9, 0x81, 0xC7, 0x17, 0x68, 0x62,
  0x56, 0x76, 0x63, 0x16,
  // "f" (U+0066)
  0x74, 0x83, 0x23, 0x44, 0x17, 0x50, 0x70, 0xDD, 0x81, 0xD9, 0x27, 0x01, 0x0D, 0xFA, 0x04, 0x70,
  0xCF, 0xA0, 0xE7, 0x06, 0xFB, 0x0A, 0x70, 0xDC, 0x85, 0xC3, 0x01, 0x49, 0x56, 0x02, 0xC0, 0xE0,
  0x17, 0x50, 0x6C, 0x09, 0x76, 0x09, 0xC0, 0x67, 0x60, 0xBC, 0x03, 0x76, 0x0D, 0xC0, 0x27, 0x60,
  0xDC, 0x01, 0x76, 0x0E, 0xC0, 0x17, 0x60, 0xEC, 0x01, 0x76, 0x0E, 0xC0, 0x17, 0x38, 0x11, 0x8E,
  0xFC, 0x01, 0x20, 0x20, 0xAF, 0xF0, 0x12, 0x05, 0xFF, 0x90, 0x12, 0x05, 0xFF, 0x90, 0x12, 0x01,
  0x80, 0x05, 0xD8, 0x02, 0x57, 0x10, 0xEC, 0x01, 0x76, 0x0E, 0xC0, 0x17, 0x60, 0xEC, 0x01, 0x76,
  0x0E, 0xC0, 0x17, 0x60, 0xEC, 0x01, 0x76, 0x0E, 0xC0, 0x17, 0x60, 0xEC, 0x01, 0x76, 0x0E, 0xC0,
  0x17, 0x60, 0xEC, 0x01, 0x76, 0x0E, 0xC0, 0x17, 0x60, 0xEC, 0x01, 0x76, 0x0E, 0xC0, 0x17, 0x60,
  0xEC, 0x01, 0x76, 0x0E, 0xC0, 0x17, 0x60, 0xEC, 0x01, 0x76, 0x0E, 0xC0, 0x17, 0x60, 0xEC, 0x01,
  0x76, 0x0E, 0xC0, 0x17, 0x60, 0xEC, 0x01, 0x76, 0x0E, 0xC0, 0x17, 0x60, 0xEC, 0x01, 0x76, 0x0E,
  0xC0, 0x17, 0x60, 0xEC, 0x01, 0x76, 0x0E, 0xC0, 0x17, 0x60, 0xEC, 0x01, 0x76, 0x0E, 0xC0, 0x17,
  0x60, 0xEC, 0x01, 0x71,
  // "g" (U+0067)
  0x71, 0x84, 0x14, 0x77, 0x63, 0x77, 0x30, 0x20, 0xAE, 0x0E, 0x07, 0x40, 0xEB, 0x04, 0x50, 0x6F,
  0xB0, 0xC0, 0x12, 0xC0, 0x44, 0x06, 0xFD, 0x81, 0xC0, 0x3C, 0x04, 0x30, 0x3F, 0x0E, 0x0D, 0xD0,
  0x90, 0x5C, 0x04, 0x30, 0xCD, 0x09, 0x02, 0x30, 0x30, 0xAB, 0x0B, 0xC0, 0x42, 0x04, 0xD0, 0x77,
  0x06, 0xF0, 0x42, 0x0B, 0xC0, 0xB7, 0x20, 0x9E, 0x81, 0x40, 0x1D, 0x03, 0x72, 0x01, 0xE8, 0x14,
  0x05, 0xC0, 0xD7, 0x40, 0xAD, 0x81, 0x40, 0x9C, 0x08, 0x74, 0x05, 0xD8, 0x14, 0x0B, 0xC0, 0x57,
  0x40, 0x2D, 0x81, 0x40, 0xEC, 0x02, 0x75, 0xD0, 0x41, 0xD7, 0x60, 0xDC, 0x04, 0x01, 0xC0, 0xE7,
  0x60, 0xCC, 0x04, 0x02, 0xC0, 0xE7, 0x60, 0xBC, 0x04, 0x03, 0xC0, 0xD7, 0x60, 0xBC, 0x04, 0x03,
  0xC0, 0xD7, 0x60, 0xAC, 0x04, 0x02, 0xC0, 0xE7, 0x60, 0xBC, 0x04, 0x02, 0xC0, 0xE7, 0x60, 0xBC,
  0x04, 0x01, 0xD7, 0x60, 0xCC, 0x81, 0x40, 0xEC, 0x02, 0x75, 0x0E, 0xC8, 0x14, 0x0C, 0xC0, 0x47,
  0x5D, 0x81, 0x40, 0xAC, 0x07, 0x74, 0x04, 0xD8, 0x14, 0x06, 0xC0, 0xB7, 0x40, 0x8D, 0x81, 0x40,
  0x2D, 0x02, 0x73, 0x0E, 0xD0, 0x42, 0x0C, 0xC0, 0xA7, 0x20, 0x7E, 0x04, 0x20, 0x6D, 0x06, 0x70,
  0x5F, 0x04, 0x30, 0xDD, 0x09, 0x02, 0x30, 0x20, 0x9B, 0x0C, 0xC0, 0x43, 0x05, 0xF8, 0x1E, 0xDE,
  0xC0, 0x80, 0x9C, 0x04, 0x40, 0x8F, 0xD8, 0x1B, 0x0A, 0xC0, 0x45, 0x08, 0xFB, 0x0B, 0x20, 0xAC,
  0x04, 0x60, 0x30, 0xBE, 0x0D, 0x06, 0x30, 0xAC, 0x04, 0x71, 0x84, 0x15, 0x77, 0x63, 0x50, 0xAC,
  0x04, 0x77, 0x50, 0xBC, 0x03, 0x77, 0x50, 0xCC, 0x02, 0x77, 0x50, 0xEC, 0x77, 0x50, 0x1C, 0x0D,
  0x77, 0x50, 0x6C, 0x09, 0x77, 0x50, 0xDC, 0x05, 0x30, 0x20, 0x17, 0x60, 0xAC, 0x0E, 0x48, 0x25,
  0xFA, 0x47, 0x20, 0x20, 0xBD, 0x07, 0x40, 0x5C, 0x86, 0xB9, 0x65, 0x56, 0x8B, 0xE0, 0xC5, 0x05,
  0xFF, 0xB0, 0xE0, 0x25, 0x05, 0xFF, 0xA0, 0xD0, 0x26, 0x81, 0x17, 0xDF, 0xD0, 0xE0, 0x77, 0x48,
  0x92, 0x37, 0xAC, 0xEE, 0xFE, 0xDB, 0x84, 0x71,
  // "h" (U+0068)
  0x0B, 0xC0, 0x37, 0x73, 0x0B, 0xC0, 0x37, 0x73, 0x0B, 0xC0, 0x37, 0x73, 0x0B, 0xC0, 0x37, 0x73,
  0x0B, 0xC0, 0x37, 0x73, 0x0B, 0xC0, 0x37, 0x73, 0x0B, 0xC0, 0x37, 0x73, 0x0B, 0xC0, 0x37, 0x73,
  0x0B, 0xC0, 0x37, 0x73, 0x0B, 0xC0, 0x37, 0x73, 0x0B, 0xC0, 0x37, 0x73, 0x0B, 0xC0, 0x37, 0x73,
  0x0B, 0xC0, 0x37, 0x73, 0x0B, 0xC0, 0x34, 0x84, 0x15, 0x77, 0x53, 0x70, 0xBC, 0x03, 0x20, 0x30,
  0xBE, 0x81, 0xE9, 0x14, 0x0B, 0xC8, 0x12, 0x07, 0xFB, 0x0E, 0x03, 0x30, 0xBC, 0x01, 0x07, 0xFD,
  0x0E, 0x01, 0x20, 0xBC, 0x03, 0xD8, 0x1E, 0xDE, 0xE0, 0xA2, 0x0B, 0xB0, 0xE0, 0xDA, 0x0D, 0x05,
  0x40, 0x50, 0xDD, 0x81, 0x20, 0xBE, 0x0B, 0x70, 0x20, 0xEC, 0x81, 0x70, 0xBD, 0x0E, 0x01, 0x71,
  0x08, 0xC8, 0x1B, 0x0B, 0xD0, 0x77, 0x20, 0x3C, 0x81, 0xE0, 0xBD, 0x01, 0x73, 0xD1, 0x0B, 0xC0,
  0xC7, 0x40, 0xEC, 0x01, 0x0B, 0xC0, 0x97, 0x40, 0xDC, 0x02, 0x0B, 0xC0, 0x77, 0x40, 0xCC, 0x02,
  0x0B, 0xC0, 0x57, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x47, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x47, 0x40,
  0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0,
  0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02,
  0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40,
  0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0,
  0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02,
  0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40,
  0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02,
  // "i" (U+0069)
  0x18, 0x31, 0xAE, 0xD7, 0x20, 0xAC, 0x81, 0x30, 0xEC, 0x08, 0x01, 0xD8, 0x19, 0x0E, 0xC8, 0x18,
  0x09, 0xC8, 0x53, 0x01, 0x9E, 0xD6, 0x80, 0xD0, 0x00, 0xBC, 0x81, 0x30, 0xBC, 0x81, 0x30, 0xBC,
  0x81, 0x30, 0xBC, 0x81, 0x30, 0xBC, 0x81, 0x30, 0xBC, 0x81, 0x30, 0xBC, 0x81, 0x30, 0xBC, 0x81,
  0x30, 0xBC, 0x81, 0x30, 0xBC, 0x81, 0x30, 0xBC, 0x81, 0x30, 0xBC, 0x81, 0x30, 0xBC, 0x81, 0x30,
  0xBC, 0x81, 0x30, 0xBC, 0x81, 0x30, 0xBC, 0x81, 0x30, 0xBC, 0x81, 0x30, 0xBC, 0x81, 0x30, 0xBC,
  0x81, 0x30, 0xBC, 0x81, 0x30, 0xBC, 0x81, 0x30, 0xBC, 0x81, 0x30, 0xBC, 0x81, 0x30, 0xBC, 0x81,
  0x30, 0xBC, 0x81, 0x30, 0xBC, 0x81, 0x30, 0xBC, 0x81, 0x30, 0xBC, 0x81, 0x30, 0xBC, 0x81, 0x30,
  0xBC, 0x81, 0x30, 0xBC, 0x81, 0x30, 0xBC, 0x03,
  // "j" (U+006A)
  0x68, 0x31, 0xAE, 0xD7, 0x70, 0xAC, 0x03, 0x60, 0xEC, 0x08, 0x50, 0x1D, 0x09, 0x60, 0xEC, 0x08,
  0x60, 0x9C, 0x03, 0x68, 0x31, 0x9E, 0xD6, 0x80, 0x99, 0x30, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36,
  0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B,
  0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0,
  0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36,
  0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B,
  0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0,
  0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36,
  0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x26, 0x0D, 0xC0, 0x25, 0x01,
  0xD6, 0x09, 0xC8, 0x5C, 0x06, 0x85, 0x5A, 0xD8, 0x17, 0x08, 0xFA, 0x81, 0x10, 0x8F, 0x90, 0x72,
  0x08, 0xF0, 0x83, 0x86, 0x4B, 0xDF, 0xED, 0x93, 0x40,
  // "k" (U+006B)
  0x0B, 0xC0, 0x37, 0x72, 0x0B, 0xC0, 0x37, 0x72, 0x0B, 0xC0, 0x37, 0x72, 0x0B, 0xC0, 0x37, 0x72,
  0x0B, 0xC0, 0x37, 0x72, 0x0B, 0xC0, 0x37, 0x72, 0x0B, 0xC0, 0x37, 0x72, 0x0B, 0xC0, 0x37, 0x72,
  0x0B, 0xC0, 0x37, 0x72, 0x0B, 0xC0, 0x37, 0x72, 0x0B, 0xC0, 0x37, 0x72, 0x0B, 0xC0, 0x37, 0x72,
  0x0B, 0xC0, 0x37, 0x72, 0x0B, 0xC0, 0x37, 0x72, 0x0B, 0xC0, 0x37, 0x20, 0x7C, 0x81, 0xE1, 0xBC,
  0x03, 0x71, 0x03, 0xD8, 0x14, 0x0B, 0xC0, 0x37, 0x10, 0xDC, 0x08, 0x20, 0xBC, 0x03, 0x70, 0x9C,
  0x0C, 0x30, 0xBC, 0x03, 0x60, 0x4C, 0x0E, 0x02, 0x30, 0xBC, 0x03, 0x50, 0x10, 0xDC, 0x05, 0x40,
  0xBC, 0x03, 0x50, 0xAC, 0x09, 0x50, 0xBC, 0x03, 0x40, 0x5C, 0x0D, 0x60, 0xBC, 0x03, 0x30, 0x10,
  0xEC, 0x03, 0x60, 0xBC, 0x03, 0x30, 0xBC, 0x06, 0x70, 0xBC, 0x03, 0x20, 0x7C, 0x0A, 0x71, 0x0B,
  0xC8, 0x12, 0x02, 0xC0, 0xD0, 0x17, 0x10, 0xBC, 0x81, 0x20, 0xCC, 0x04, 0x72, 0x0B, 0xC0, 0x10,
  0x8D, 0x05, 0x72, 0x0B, 0xC0, 0x3E, 0x0D, 0x72, 0x0B, 0xC0, 0xCF, 0x06, 0x71, 0x0B, 0xF0, 0xDC,
  0x0E, 0x71, 0x0B, 0xE8, 0x1B, 0x0D, 0xC0, 0x77, 0x0B, 0xD0, 0xC2, 0x05, 0xC0, 0xE7, 0x0B, 0xC0,
  0xD0, 0x13, 0x0D, 0xC0, 0x76, 0x0B, 0xC0, 0x44, 0x05, 0xC0, 0xE0, 0x15, 0x0B, 0xC0, 0x35, 0x0D,
  0xC0, 0x85, 0x0B, 0xC0, 0x35, 0x05, 0xD0, 0x14, 0x0B, 0xC0, 0x36, 0x0D, 0xC0, 0x94, 0x0B, 0xC0,
  0x36, 0x05, 0xD0, 0x23, 0x0B, 0xC0, 0x37, 0x0C, 0xC0, 0xA3, 0x0B, 0xC0, 0x37, 0x05, 0xD0, 0x22,
  0x0B, 0xC0, 0x37, 0x10, 0xCC, 0x0A, 0x20, 0xBC, 0x03, 0x71, 0x04, 0xD8, 0x13, 0x0B, 0xC0, 0x37,
  0x20, 0xCC, 0x81, 0xB0, 0xBC, 0x03, 0x72, 0x04, 0xD0, 0x40, 0xBC, 0x03, 0x73, 0x0C, 0xC0, 0xC0,
  // "l" (U+006C)
  0x0B, 0xC0, 0x30, 0xBC, 0x03, 0x0B, 0xC0, 0x30, 0xBC, 0x03, 0x0B, 0xC0, 0x30, 0xBC, 0x03, 0x0B,
  0xC0, 0x30, 0xBC, 0x03, 0x0B, 0xC0, 0x30, 0xBC, 0x03, 0x0B, 0xC0, 0x30, 0xBC, 0x03, 0x0B, 0xC0,
  0x30, 0xBC, 0x03, 0x0B, 0xC0, 0x30, 0xBC, 0x03, 0x0B, 0xC0, 0x30, 0xBC, 0x03, 0x0B, 0xC0, 0x30,
  0xBC, 0x03, 0x0B, 0xC0, 0x30, 0xBC, 0x03, 0x0B, 0xC0, 0x30, 0xBC, 0x03, 0x0B, 0xC0, 0x30, 0xBC,
  0x03, 0x0B, 0xC0, 0x30, 0xBC, 0x03, 0x0B, 0xC0, 0x30, 0xBC, 0x03, 0x0B, 0xC0, 0x30, 0xBC, 0x03,
  0x0B, 0xC0, 0x30, 0xBC, 0x03, 0x0B, 0xC0, 0x30, 0xBC, 0x03, 0x0B, 0xC0, 0x30, 0xBC, 0x03, 0x0B,
  0xC0, 0x30, 0xBC, 0x03, 0x0B, 0xC0, 0x30, 0xBC, 0x03, 0x0B, 0xC0, 0x30, 0xBC, 0x03, 0x0B, 0xC0,
  0x30, 0xBC, 0x03,
  // "m" (U+006D)
  0x73, 0x84, 0x26, 0x77, 0x52, 0x73, 0x84, 0x36, 0x76, 0x52, 0x60, 0xBB, 0x05, 0x30, 0x50, 0xDE,
  0x0C, 0x03, 0x60, 0x70, 0xEE, 0x0C, 0x04, 0x40, 0xBB, 0x07, 0x20, 0x9F, 0xB0, 0x63, 0x01, 0x0C,
  0xFB, 0x08, 0x30, 0xBB, 0x81, 0x90, 0x9F, 0xD0, 0x42, 0x0D, 0xFD, 0x06, 0x20, 0xBB, 0x0B, 0x04,
  0xC8, 0x1E, 0xDE, 0xE8, 0x1D, 0x09, 0xC8, 0x1E, 0xDE, 0xE8, 0x2E, 0x10, 0xBB, 0x0E, 0x0D, 0xA0,
  0x90, 0x23, 0x03, 0x0C, 0xD0, 0x8B, 0x09, 0x02, 0x30, 0x30, 0xDD, 0x81, 0x60, 0xBE, 0x07, 0x60,
  0x10, 0xDF, 0x07, 0x60, 0x10, 0xDC, 0x81, 0xC0, 0xBD, 0x0C, 0x71, 0x06, 0xE0, 0xB7, 0x10, 0x6D,
  0x10, 0xBD, 0x05, 0x71, 0x01, 0xE0, 0x47, 0x10, 0x1D, 0x02, 0x0B, 0xD7, 0x30, 0xDC, 0x0E, 0x73,
  0x0C, 0xC0, 0x40, 0xBC, 0x0C, 0x73, 0x0B, 0xC0, 0xB7, 0x30, 0xAC, 0x05, 0x0B, 0xC0, 0x97, 0x30,
  0xAC, 0x08, 0x73, 0x09, 0xC0, 0x60, 0xBC, 0x07, 0x73, 0x0A, 0xC0, 0x67, 0x30, 0x9C, 0x06, 0x0B,
  0xC0, 0x57, 0x30, 0xAC, 0x05, 0x73, 0x09, 0xC0, 0x60, 0xBC, 0x04, 0x73, 0x0A, 0xC0, 0x47, 0x30,
  0x9C, 0x06, 0x0B, 0xC0, 0x47, 0x30, 0xAC, 0x04, 0x73, 0x09, 0xC0, 0x60, 0xBC, 0x03, 0x73, 0x0A,
  0xC0, 0x47, 0x30, 0x9C, 0x06, 0x0B, 0xC0, 0x37, 0x30, 0xAC, 0x04, 0x73, 0x09, 0xC0, 0x60, 0xBC,
  0x03, 0x73, 0x0A, 0xC0, 0x47, 0x30, 0x9C, 0x06, 0x0B, 0xC0, 0x37, 0x30, 0xAC, 0x04, 0x73, 0x09,
  0xC0, 0x60, 0xBC, 0x03, 0x73, 0x0A, 0xC0, 0x47, 0x30, 0x9C, 0x06, 0x0B, 0xC0, 0x37, 0x30, 0xAC,
  0x04, 0x73, 0x09, 0xC0, 0x60, 0xBC, 0x03, 0x73, 0x0A, 0xC0, 0x47, 0x30, 0x9C, 0x06, 0x0B, 0xC0,
  0x37, 0x30, 0xAC, 0x04, 0x73, 0x09, 0xC0, 0x60, 0xBC, 0x03, 0x73, 0x0A, 0xC0, 0x47, 0x30, 0x9C,
  0x06, 0x0B, 0xC0, 0x37, 0x30, 0xAC, 0x04, 0x73, 0x09, 0xC0, 0x60, 0xBC, 0x03, 0x73, 0x0A, 0xC0,
  0x47, 0x30, 0x9C, 0x06, 0x0B, 0xC0, 0x37, 0x30, 0xAC, 0x04, 0x73, 0x09, 0xC0, 0x60, 0xBC, 0x03,
  0x73, 0x0A, 0xC0, 0x47, 0x30, 0x9C, 0x06, 0x0B, 0xC0, 0x37, 0x30, 0xAC, 0x04, 0x73, 0x09, 0xC0,
  0x60, 0xBC, 0x03, 0x73, 0x0A, 0xC0, 0x47, 0x30, 0x9C, 0x06, 0x0B, 0xC0, 0x37, 0x30, 0xAC, 0x04,
  0x73, 0x09, 0xC0, 0x60, 0xBC, 0x03, 0x73, 0x0A, 0xC0, 0x47, 0x30, 0x9C, 0x06,
  // "n" (U+006E)
  0x73, 0x84, 0x15, 0x77, 0x63, 0x70, 0xBB, 0x05, 0x30, 0x30, 0xBE, 0x81, 0xE9, 0x14, 0x0B, 0xB0,
  0x72, 0x07, 0xFB, 0x0E, 0x03, 0x30, 0xBB, 0x81, 0x90, 0x7F, 0xD0, 0xE0, 0x12, 0x0B, 0xB0, 0xB0,
  0x4D, 0x00, 0xDF, 0x0A, 0x20, 0xBB, 0x0E, 0x0D, 0xA0, 0xC0, 0x54, 0x05, 0x0E, 0xD8, 0x12, 0x0B,
  0xE0, 0xA7, 0x03, 0xD8, 0x18, 0x0B, 0xD0, 0xD7, 0x20, 0x9C, 0x81, 0xB0, 0xBD, 0x06, 0x72, 0x04,
  0xC8, 0x1E, 0x0B, 0xD0, 0x17, 0x3D, 0x10, 0xBC, 0x0C, 0x74, 0x0E, 0xC0, 0x10, 0xBC, 0x09, 0x74,
  0x0D, 0xC0, 0x20, 0xBC, 0x07, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x05, 0x74, 0x0C, 0xC0, 0x20, 0xBC,
  0x04, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x04, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0,
  0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74,
  0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC,
  0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0,
  0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74,
  0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC,
  0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0,
  0x20,
  // "o" (U+006F)
  0x72, 0x85, 0x14, 0x67, 0x75, 0x37, 0x72, 0x05, 0x0C, 0xF8, 0x1E, 0x81, 0x74, 0x02, 0x0C, 0xFC,
  0x0E, 0x06, 0x72, 0x02, 0x0E, 0xFF, 0x08, 0x70, 0x10, 0xDF, 0x0D, 0x0E, 0xF0, 0x66, 0x09, 0xD0,
  0xB0, 0x43, 0x81, 0x16, 0xEC, 0x0E, 0x01, 0x40, 0x2D, 0x09, 0x70, 0x20, 0xDC, 0x0A, 0x40, 0xAC,
  0x0C, 0x72, 0x03, 0xD0, 0x23, 0x0E, 0xC0, 0x47, 0x30, 0xAC, 0x08, 0x20, 0x4C, 0x0D, 0x74, 0x04,
  0xC0, 0xD2, 0x08, 0xC0, 0x87, 0x50, 0xEC, 0x81, 0x10, 0xBC, 0x05, 0x75, 0x0B, 0xC8, 0x14, 0x0E,
  0xC0, 0x27, 0x50, 0x8C, 0x07, 0x1D, 0x76, 0x06, 0xC0, 0x90, 0x1C, 0x0E, 0x76, 0x04, 0xC0, 0xA0,
  0x2C, 0x0E, 0x76, 0x04, 0xC0, 0xB0, 0x3C, 0x0D, 0x76, 0x03, 0xC0, 0xC0, 0x3C, 0x0D, 0x76, 0x03,
  0xC0, 0xC0, 0x2C, 0x0E, 0x76, 0x04, 0xC0, 0xB0, 0x1C, 0x0E, 0x76, 0x05, 0xC0, 0xA1, 0xD7, 0x60,
  0x6C, 0x81, 0x90, 0xDC, 0x02, 0x75, 0x08, 0xC8, 0x17, 0x0A, 0xC0, 0x57, 0x50, 0xBC, 0x81, 0x40,
  0x7C, 0x09, 0x75, 0x0E, 0xC8, 0x11, 0x03, 0xC0, 0xD7, 0x40, 0x4C, 0x0C, 0x30, 0xDC, 0x04, 0x73,
  0x0A, 0xC0, 0x63, 0x07, 0xC0, 0xC7, 0x20, 0x4D, 0x01, 0x30, 0x10, 0xEC, 0x09, 0x70, 0x20, 0xDC,
  0x08, 0x50, 0x6D, 0x0B, 0x04, 0x38, 0x11, 0x6E, 0xC0, 0xE0, 0x16, 0x0B, 0xF0, 0xD0, 0xEF, 0x05,
  0x70, 0x10, 0xCF, 0xF0, 0x77, 0x30, 0xAF, 0xC0, 0xE0, 0x67, 0x50, 0x40, 0xBF, 0x81, 0xE8, 0x17,
  0x71, 0x85, 0x14, 0x67, 0x75, 0x37, 0x20,
  // "p" (U+0070)
  0x73, 0x84, 0x15, 0x77, 0x63, 0x71, 0x0B, 0xB0, 0x63, 0x02, 0x0A, 0xE0, 0xE0, 0x86, 0x0B, 0xB0,
  0x82, 0x05, 0x0E, 0xFA, 0x0D, 0x02, 0x40, 0xBB, 0x81, 0xA0, 0x4F, 0xD0, 0xE0, 0x23, 0x0B, 0xB8,
  0x1C, 0x1E, 0xC0, 0x0D, 0xF0, 0xD3, 0x0B, 0xB0, 0xE0, 0xBA, 0x0D, 0x05, 0x40, 0x50, 0xDD, 0x07,
  0x20, 0xBE, 0x0B, 0x70, 0x10, 0xDC, 0x0E, 0x20, 0xBD, 0x0E, 0x01, 0x71, 0x03, 0xD8, 0x16, 0x0B,
  0xD0, 0x77, 0x30, 0xBC, 0x81, 0xB0, 0xBD, 0x01, 0x73, 0x05, 0xD1, 0x0B, 0xC0, 0xD7, 0x40, 0x1D,
  0x03, 0x0B, 0xC0, 0x97, 0x50, 0xCC, 0x06, 0x0B, 0xC0, 0x77, 0x50, 0xAC, 0x08, 0x0B, 0xC0, 0x57,
  0x50, 0x8C, 0x09, 0x0B, 0xC0, 0x47, 0x50, 0x7C, 0x0A, 0x0B, 0xC0, 0x47, 0x50, 0x6C, 0x00, 0xBC,
  0x03, 0x75, 0x06, 0xC0, 0x0B, 0xC0, 0x37, 0x50, 0x6C, 0x00, 0xBC, 0x04, 0x75, 0x06, 0xC0, 0x0B,
  0xC0, 0x47, 0x50, 0x7C, 0x0A, 0x0B, 0xC0, 0x67, 0x50, 0x8C, 0x09, 0x0B, 0xC0, 0x87, 0x50, 0xAC,
  0x07, 0x0B, 0xC0, 0xA7, 0x50, 0xDC, 0x05, 0x0B, 0xC0, 0xD7, 0x40, 0x1D, 0x02, 0x0B, 0xD0, 0x27,
  0x30, 0x5C, 0x81, 0xE0, 0xBD, 0x08, 0x73, 0x0B, 0xC8, 0x19, 0x0B, 0xD0, 0xE0, 0x17, 0x10, 0x4D,
  0x81, 0x40, 0xBE, 0x0C, 0x01, 0x60, 0x10, 0xDC, 0x0D, 0x20, 0xBC, 0x0D, 0xA0, 0xD0, 0x54, 0x05,
  0x0D, 0xD0, 0x52, 0x0B, 0xC0, 0x3D, 0x00, 0xDF, 0x0C, 0x30, 0xBC, 0x02, 0x06, 0xFD, 0x0E, 0x01,
  0x30, 0xBC, 0x81, 0x20, 0x5F, 0xB0, 0xD0, 0x24, 0x0B, 0xC0, 0x32, 0x02, 0x0A, 0xE0, 0xE0, 0x86,
  0x0B, 0xC0, 0x34, 0x84, 0x15, 0x67, 0x64, 0x71, 0x0B, 0xC0, 0x37, 0x74, 0x0B, 0xC0, 0x37, 0x74,
  0x0B, 0xC0, 0x37, 0x74, 0x0B, 0xC0, 0x37, 0x74, 0x0B, 0xC0, 0x37, 0x74, 0x0B, 0xC0, 0x37, 0x74,
  0x0B, 0xC0, 0x37, 0x74, 0x0B, 0xC0, 0x37, 0x74, 0x0B, 0xC0, 0x37, 0x74, 0x0B, 0xC0, 0x37, 0x74,
  0x0B, 0xC0, 0x37, 0x74, 0x0B, 0xC0, 0x37, 0x74, 0x0B, 0xC0, 0x37, 0x74,
  // "q" (U+0071)
  0x71, 0x84, 0x15, 0x77, 0x63, 0x77, 0x30, 0x20, 0xAE, 0x0E, 0x07, 0x40, 0xEB, 0x04, 0x50, 0x6F,
  0xB0, 0xC0, 0x12, 0xC0, 0x44, 0x06, 0xFD, 0x81, 0xC0, 0x2C, 0x04, 0x30, 0x3F, 0x81, 0xED, 0xEC,
  0x08, 0x04, 0xC0, 0x43, 0x0D, 0xD0, 0x90, 0x23, 0x03, 0x09, 0xB0, 0xAC, 0x04, 0x20, 0x6D, 0x07,
  0x70, 0x5F, 0x04, 0x20, 0xCC, 0x0B, 0x72, 0x08, 0xE8, 0x14, 0x02, 0xD0, 0x37, 0x20, 0x1E, 0x81,
  0x40, 0x6C, 0x0D, 0x74, 0x0A, 0xD8, 0x14, 0x09, 0xC0, 0x87, 0x40, 0x5D, 0x81, 0x40, 0xCC, 0x05,
  0x74, 0x02, 0xD8, 0x14, 0x0E, 0xC0, 0x27, 0x5D, 0x04, 0x01, 0xD7, 0x60, 0xDC, 0x04, 0x02, 0xC0,
  0xE7, 0x60, 0xCC, 0x04, 0x03, 0xC0, 0xE7, 0x60, 0xBC, 0x04, 0x03, 0xC0, 0xD7, 0x60, 0xBC, 0x04,
  0x03, 0xC0, 0xD7, 0x60, 0xAC, 0x04, 0x02, 0xC0, 0xE7, 0x60, 0xBC, 0x04, 0x02, 0xC0, 0xE7, 0x60,
  0xBC, 0x04, 0x01, 0xD7, 0x60, 0xCC, 0x81, 0x40, 0xEC, 0x02, 0x75, 0x0E, 0xC8, 0x14, 0x0C, 0xC0,
  0x47, 0x40, 0x1D, 0x81, 0x40, 0xAC, 0x08, 0x74, 0x04, 0xD8, 0x14, 0x07, 0xC0, 0xC7, 0x40, 0x9D,
  0x81, 0x40, 0x2D, 0x03, 0x73, 0x0E, 0xD0, 0x42, 0x0D, 0xC0, 0xB7, 0x20, 0x8E, 0x04, 0x20, 0x6D,
  0x07, 0x70, 0x5F, 0x04, 0x30, 0xDD, 0x0A, 0x02, 0x30, 0x20, 0x9B, 0x0B, 0xC0, 0x43, 0x05, 0xF8,
  0x1E, 0xDE, 0xC0, 0x90, 0x8C, 0x04, 0x40, 0x8F, 0xD8, 0x1C, 0x09, 0xC0, 0x45, 0x08, 0xFB, 0x0B,
  0x20, 0xAC, 0x04, 0x60, 0x30, 0xBE, 0x0D, 0x06, 0x30, 0xBC, 0x04, 0x71, 0x84, 0x15, 0x77, 0x63,
  0x50, 0xBC, 0x04, 0x77, 0x50, 0xBC, 0x04, 0x77, 0x50, 0xBC, 0x04, 0x77, 0x50, 0xBC, 0x04, 0x77,
  0x50, 0xBC, 0x04, 0x77, 0x50, 0xBC, 0x04, 0x77, 0x50, 0xBC, 0x04, 0x77, 0x50, 0xBC, 0x04, 0x77,
  0x50, 0xBC, 0x04, 0x77, 0x50, 0xBC, 0x04, 0x77, 0x50, 0xBC, 0x04, 0x77, 0x50, 0xBC, 0x04, 0x77,
  0x50, 0xBC, 0x04, 0x77, 0x50, 0xBC, 0x04,
  // "r" (U+0072)
  0x73, 0x85, 0x26, 0x76, 0x51, 0xBB, 0x04, 0x30, 0x10, 0xAD, 0x07, 0x0B, 0xB0, 0x52, 0x01, 0x0D,
  0xE0, 0x50, 0xBB, 0x07, 0x20, 0xCF, 0x03, 0x0B, 0xB8, 0x18, 0x08, 0xF9, 0x01, 0x0B, 0xB0, 0xA0,
  0x2C, 0x85, 0xC8, 0x8A, 0xE0, 0xBB, 0x0B, 0x09, 0xA0, 0xD0, 0x34, 0x81, 0x10, 0xBE, 0x0D, 0x01,
  0x70, 0xBE, 0x04, 0x71, 0x0B, 0xD0, 0xA7, 0x20, 0xBD, 0x03, 0x72, 0x0B, 0xC0, 0xE7, 0x30, 0xBC,
  0x0A, 0x73, 0x0B, 0xC0, 0x77, 0x30, 0xBC, 0x05, 0x73, 0x0B, 0xC0, 0x47, 0x30, 0xBC, 0x03, 0x73,
  0x0B, 0xC0, 0x37, 0x30, 0xBC, 0x03, 0x73, 0x0B, 0xC0, 0x37, 0x30, 0xBC, 0x03, 0x73, 0x0B, 0xC0,
  0x37, 0x30, 0xBC, 0x03, 0x73, 0x0B, 0xC0, 0x37, 0x30, 0xBC, 0x03, 0x73, 0x0B, 0xC0, 0x37, 0x30,
  0xBC, 0x03, 0x73, 0x0B, 0xC0, 0x37, 0x30, 0xBC, 0x03, 0x73, 0x0B, 0xC0, 0x37, 0x30, 0xBC, 0x03,
  0x73, 0x0B, 0xC0, 0x37, 0x30, 0xBC, 0x03, 0x73,
  // "s" (U+0073)
  0x78, 0x53, 0x56, 0x76, 0x51, 0x72, 0x81, 0x29, 0xEF, 0x81, 0xD8, 0x35, 0x08, 0xFE, 0x0B, 0x02,
  0x20, 0xAF, 0xF9, 0x81, 0x20, 0x7F, 0x81, 0xDD, 0xED, 0x82, 0xA0, 0x1E, 0xC0, 0xD0, 0x44, 0x81,
  0x15, 0xBA, 0x81, 0x30, 0x5C, 0x0C, 0x72, 0x03, 0x08, 0x20, 0x9C, 0x05, 0x76, 0x0A, 0xC0, 0x17,
  0x60, 0xAC, 0x02, 0x76, 0x09, 0xC0, 0x67, 0x60, 0x5C, 0x0D, 0x01, 0x75, 0x01, 0x0E, 0xC0, 0xD0,
  0x37, 0x50, 0x8E, 0x09, 0x01, 0x74, 0x0B, 0xE0, 0xE0, 0x77, 0x40, 0x9F, 0x0E, 0x06, 0x73, 0x06,
  0x0E, 0xF0, 0xB0, 0x27, 0x20, 0x10, 0xAF, 0x0E, 0x05, 0x73, 0x03, 0x0B, 0xF0, 0x67, 0x40, 0x30,
  0xCE, 0x04, 0x75, 0x07, 0xD0, 0xD7, 0x60, 0x5D, 0x04, 0x76, 0x09, 0xC0, 0x87, 0x60, 0x4C, 0x09,
  0x76, 0x02, 0xC0, 0xA7, 0x60, 0x4C, 0x09, 0x01, 0x75, 0x08, 0xC8, 0x27, 0xA9, 0x27, 0x20, 0x3D,
  0x03, 0x0A, 0xA8, 0x1B, 0x62, 0x48, 0x11, 0x7E, 0xC8, 0x1D, 0x0A, 0xE8, 0x1D, 0xDE, 0xF8, 0x15,
  0x0A, 0xFF, 0x90, 0x82, 0x08, 0xFF, 0x07, 0x48, 0x12, 0x8D, 0xF9, 0x81, 0xE9, 0x27, 0x18, 0x61,
  0x46, 0x77, 0x65, 0x27,
  // "t" (U+0074)
  0x50, 0xDA, 0x07, 0x74, 0x01, 0xB0, 0x77, 0x40, 0x4B, 0x07, 0x74, 0x07, 0xB0, 0x77, 0x40, 0xAB,
  0x07, 0x74, 0x0D, 0xB0, 0x77, 0x4C, 0x07, 0x73, 0x03, 0xC0, 0x77, 0x18, 0x11, 0x8E, 0xFC, 0x10,
  0x9F, 0xF1, 0xFF, 0x91, 0xFF, 0x91, 0x0F, 0x50, 0xAC, 0x0A, 0x80, 0x25, 0x40, 0x8C, 0x07, 0x73,
  0x08, 0xC0, 0x77, 0x30, 0x8C, 0x07, 0x73, 0x08, 0xC0, 0x77, 0x30, 0x8C, 0x07, 0x73, 0x08, 0xC0,
  0x77, 0x30, 0x8C, 0x07, 0x73, 0x08, 0xC0, 0x77, 0x30, 0x8C, 0x07, 0x73, 0x08, 0xC0, 0x77, 0x30,
  0x8C, 0x07, 0x73, 0x08, 0xC0, 0x77, 0x30, 0x8C, 0x07, 0x73, 0x08, 0xC0, 0x77, 0x30, 0x8C, 0x07,
  0x73, 0x08, 0xC0, 0x77, 0x30, 0x8C, 0x07, 0x73, 0x08, 0xC0, 0x77, 0x30, 0x8C, 0x07, 0x73, 0x08,
  0xC0, 0x87, 0x30, 0x7C, 0x0B, 0x73, 0x05, 0xD0, 0x17, 0x20, 0x1D, 0x0C, 0x02, 0x30, 0x02, 0x40,
  0xCE, 0x83, 0xDD, 0xEF, 0x54, 0x04, 0xFB, 0x05, 0x50, 0x8F, 0xA0, 0x56, 0x05, 0x0D, 0xE0, 0xD0,
  0x37, 0x18, 0x43, 0x67, 0x65, 0x22,
  // "u" (U+0075)
  0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D,
  0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D,
  0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D,
  0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D,
  0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x30, 0x1D, 0x0E, 0xC0, 0x17,
  0x30, 0x1D, 0x0E, 0xC0, 0x17, 0x30, 0x3D, 0x0D, 0xC0, 0x17, 0x30, 0x5D, 0x0D, 0xC0, 0x37, 0x30,
  0x8D, 0x0B, 0xC0, 0x57, 0x30, 0xCD, 0x09, 0xC0, 0x87, 0x20, 0x2E, 0x06, 0xC0, 0xD7, 0x20, 0xAE,
  0x02, 0xD0, 0x77, 0x06, 0xF1, 0x0C, 0xD0, 0x80, 0x13, 0x03, 0x0A, 0xB0, 0xDC, 0x10, 0x4F, 0x00,
  0xDD, 0x00, 0x8C, 0x20, 0xAF, 0xD8, 0x1C, 0x06, 0xC3, 0x0B, 0xFB, 0x0B, 0x20, 0x3C, 0x40, 0x60,
  0xDE, 0x0D, 0x06, 0x30, 0x1C, 0x68, 0x42, 0x56, 0x76, 0x27, 0x30,
  // "v" (U+0076)
  0x0A, 0xC0, 0x77, 0x60, 0xCC, 0x06, 0x05, 0xC0, 0xB7, 0x50, 0x1D, 0x00, 0x1D, 0x75, 0x05, 0xC0,
  0xC2, 0x0C, 0xC0, 0x47, 0x40, 0x9C, 0x07, 0x20, 0x7C, 0x08, 0x74, 0x0D, 0xC0, 0x32, 0x03, 0xC0,
  0xC7, 0x30, 0x2C, 0x0E, 0x40, 0xEC, 0x01, 0x72, 0x06, 0xC0, 0x94, 0x09, 0xC0, 0x57, 0x20, 0xAC,
  0x05, 0x40, 0x5C, 0x09, 0x72, 0x0E, 0xC5, 0x01, 0xC0, 0xD7, 0x10, 0x3C, 0x0B, 0x60, 0xBC, 0x02,
  0x70, 0x7C, 0x07, 0x60, 0x7C, 0x06, 0x70, 0xBC, 0x02, 0x60, 0x2C, 0x0A, 0x7C, 0x0D, 0x71, 0x0D,
  0xB0, 0xE6, 0x04, 0xC0, 0x87, 0x10, 0x9C, 0x03, 0x50, 0x8C, 0x04, 0x71, 0x04, 0xC0, 0x75, 0x0C,
  0xB0, 0xE7, 0x3C, 0x0B, 0x40, 0x1C, 0x0A, 0x73, 0x0B, 0xC4, 0x05, 0xC0, 0x67, 0x30, 0x6C, 0x04,
  0x30, 0x9C, 0x01, 0x73, 0x02, 0xC0, 0x83, 0x0D, 0xB0, 0xC7, 0x50, 0xDB, 0x0C, 0x20, 0x1C, 0x07,
  0x75, 0x08, 0xC8, 0x11, 0x06, 0xC0, 0x37, 0x50, 0x4C, 0x81, 0x40, 0xAB, 0x0E, 0x77, 0x0E, 0xB8,
  0x18, 0x0E, 0xB0, 0x97, 0x70, 0xAB, 0x0B, 0x02, 0xC0, 0x57, 0x70, 0x6B, 0x0E, 0x05, 0xC7, 0x71,
  0x01, 0xC0, 0xBB, 0x0B, 0x77, 0x20, 0xCF, 0x06, 0x77, 0x20, 0x8F, 0x02, 0x77, 0x20, 0x3E, 0x0D,
  0x77, 0x40, 0xED, 0x08, 0x77, 0x40, 0xAD, 0x04, 0x72,
  // "w" (U+0077)
  0x04, 0xC0, 0xB7, 0x30, 0x1D, 0x0A, 0x73, 0x01, 0xC0, 0xD0, 0x1C, 0x0E, 0x73, 0x04, 0xD0, 0xE7,
  0x30, 0x4C, 0x81, 0x90, 0xCC, 0x03, 0x72, 0x08, 0xE0, 0x27, 0x20, 0x8C, 0x81, 0x60, 0x9C, 0x06,
  0x72, 0x0C, 0xE0, 0x57, 0x20, 0xBC, 0x81, 0x20, 0x5C, 0x09, 0x72, 0xF0, 0x97, 0x20, 0xEB, 0x0E,
  0x20, 0x1C, 0x0D, 0x71, 0x04, 0xB0, 0xEB, 0x0D, 0x71, 0x03, 0xC0, 0xA3, 0x0D, 0xC0, 0x17, 0x08,
  0xB0, 0x8C, 0x01, 0x70, 0x6C, 0x06, 0x30, 0xAC, 0x04, 0x70, 0xBB, 0x05, 0x0C, 0xB0, 0x57, 0x0A,
  0xC0, 0x33, 0x06, 0xC0, 0x87, 0xC0, 0x30, 0xAB, 0x08, 0x70, 0xDB, 0x0E, 0x40, 0x3C, 0x0B, 0x60,
  0x3C, 0x10, 0x6B, 0x0C, 0x60, 0x1C, 0x0B, 0x50, 0xEB, 0x0E, 0x60, 0x7B, 0x81, 0xC0, 0x3C, 0x60,
  0x4C, 0x07, 0x50, 0xBC, 0x02, 0x50, 0xBB, 0x09, 0x2C, 0x04, 0x50, 0x8C, 0x03, 0x50, 0x7C, 0x06,
  0x50, 0xEB, 0x05, 0x20, 0xCB, 0x07, 0x50, 0xBC, 0x60, 0x4C, 0x09, 0x40, 0x3C, 0x02, 0x20, 0x9B,
  0x0B, 0x50, 0xEB, 0x0B, 0x7C, 0x0D, 0x40, 0x6B, 0x0E, 0x30, 0x6B, 0x0E, 0x40, 0x3C, 0x07, 0x70,
  0xCC, 0x01, 0x30, 0xAB, 0x0A, 0x30, 0x2C, 0x03, 0x30, 0x6C, 0x04, 0x70, 0x8C, 0x04, 0x30, 0xEB,
  0x06, 0x40, 0xEB, 0x06, 0x30, 0xAC, 0x71, 0x05, 0xC0, 0x72, 0x02, 0xC0, 0x24, 0x0B, 0xB0, 0xA3,
  0x0D, 0xB0, 0xC7, 0x10, 0x1C, 0x0A, 0x20, 0x5B, 0x0E, 0x50, 0x7B, 0x0E, 0x20, 0x1C, 0x08, 0x72,
  0x0D, 0xB0, 0xD2, 0x08, 0xB0, 0xB5, 0x04, 0xC8, 0x12, 0x04, 0xC0, 0x47, 0x20, 0x9C, 0x20, 0xCB,
  0x07, 0x6C, 0x81, 0x50, 0x7C, 0x01, 0x72, 0x06, 0xC0, 0x31, 0xC0, 0x36, 0x0C, 0xB8, 0x18, 0x0A,
  0xB0, 0xC7, 0x30, 0x2C, 0x06, 0x02, 0xC7, 0x09, 0xB8, 0x1A, 0x0D, 0xB0, 0x97, 0x40, 0xEB, 0x09,
  0x05, 0xB0, 0xB7, 0x05, 0xB0, 0xD0, 0x1C, 0x05, 0x74, 0x0A, 0xB0, 0xB0, 0x7B, 0x08, 0x70, 0x2C,
  0x04, 0xC0, 0x17, 0x40, 0x7B, 0x0E, 0x0A, 0xB0, 0x47, 0x10, 0xEB, 0x09, 0xB0, 0xD7, 0x50, 0x3C,
  0x0E, 0xB7, 0x20, 0xAB, 0x0E, 0xB0, 0x97, 0x6F, 0x0C, 0x72, 0x07, 0xF0, 0x67, 0x60, 0xBE, 0x08,
  0x72, 0x03, 0xF0, 0x27, 0x60, 0x8E, 0x05, 0x73, 0xE0, 0xE7, 0x70, 0x4E, 0x01, 0x73, 0x0C, 0xD0,
  0xA7, 0x70, 0x1D, 0x0D, 0x74, 0x08, 0xD0, 0x67,
  // "x" (U+0078)
  0x04, 0xD0, 0x17, 0x30, 0xAC, 0x0A, 0x20, 0xBC, 0x09, 0x72, 0x03, 0xD0, 0x22, 0x03, 0xD0, 0x17,
  0x10, 0xAC, 0x09, 0x40, 0xAC, 0x08, 0x70, 0x3D, 0x01, 0x40, 0x2C, 0x0E, 0x01, 0x60, 0xAC, 0x08,
  0x60, 0x9C, 0x08, 0x50, 0x3C, 0x0E, 0x01, 0x60, 0x1C, 0x0E, 0x01, 0x40, 0xAC, 0x07, 0x71, 0x08,
  0xC0, 0x83, 0x03, 0xC0, 0xE7, 0x20, 0x10, 0xEB, 0x0E, 0x01, 0x20, 0xAC, 0x06, 0x73, 0x07, 0xC8,
  0x18, 0x03, 0xC0, 0xD7, 0x50, 0xEB, 0x81, 0xE1, 0xAC, 0x05, 0x75, 0x06, 0xC0, 0xAC, 0x0C, 0x77,
  0x0D, 0xF9, 0x04, 0x77, 0x05, 0xF0, 0xB7, 0x72, 0x0C, 0xE0, 0x37, 0x72, 0x06, 0xD0, 0xB7, 0x73,
  0x0C, 0xD0, 0xD7, 0x72, 0x05, 0xF0, 0x77, 0x71, 0x0D, 0xF0, 0xE0, 0x17, 0x60, 0x6C, 0x0E, 0xC0,
  0x87, 0x60, 0xDC, 0x02, 0x0E, 0xC0, 0x17, 0x40, 0x7C, 0x81, 0x90, 0x6C, 0x09, 0x73, 0x01, 0x0E,
  0xC0, 0x12, 0x0D, 0xC0, 0x27, 0x20, 0x8C, 0x09, 0x30, 0x6C, 0x0A, 0x71, 0x01, 0xD0, 0x14, 0x0D,
  0xC0, 0x37, 0x09, 0xC0, 0x85, 0x06, 0xC0, 0xC6, 0x02, 0xC0, 0xE0, 0x16, 0x0D, 0xC0, 0x55, 0x0A,
  0xC0, 0x87, 0x06, 0xC0, 0xD4, 0x03, 0xC0, 0xE0, 0x17, 0x10, 0xDC, 0x06, 0x30, 0xBC, 0x07, 0x72,
  0x05, 0xC0, 0xE2, 0x04, 0xC0, 0xE0, 0x17, 0x30, 0xDC, 0x81, 0x70, 0xCC, 0x07, 0x74, 0x05, 0xC0,
  0xE0, 0x10,
  // "y" (U+0079)
  0x0A, 0xC0, 0x87, 0x60, 0xBC, 0x06, 0x05, 0xC0, 0xC7, 0x6D, 0x01, 0x1D, 0x01, 0x74, 0x04, 0xC0,
  0xC2, 0x0B, 0xC0, 0x67, 0x40, 0x9C, 0x07, 0x20, 0x6C, 0x0A, 0x74, 0x0D, 0xC0, 0x32, 0x01, 0xC0,
  0xE7, 0x30, 0x2C, 0x0E, 0x40, 0xCC, 0x03, 0x72, 0x06, 0xC0, 0x94, 0x07, 0xC0, 0x87, 0x20, 0xAC,
  0x05, 0x40, 0x2C, 0x0C, 0x72, 0x0E, 0xC6, 0x0D, 0xC0, 0x17, 0x03, 0xC0, 0xB6, 0x08, 0xC0, 0x57,
  0x07, 0xC0, 0x66, 0x04, 0xC0, 0xA7, 0x0C, 0xC0, 0x27, 0x0E, 0xB0, 0xE7, 0xC0, 0xD7, 0x10, 0x9C,
  0x03, 0x50, 0x5C, 0x08, 0x71, 0x05, 0xC0, 0x75, 0x09, 0xC0, 0x37, 0x2C, 0x0C, 0x50, 0xDB, 0x0E,
  0x73, 0x0B, 0xC0, 0x13, 0x02, 0xC0, 0xA7, 0x30, 0x6C, 0x05, 0x30, 0x6C, 0x05, 0x73, 0x01, 0xC0,
  0x93, 0x0A, 0xC0, 0x17, 0x40, 0xCB, 0x0D, 0x30, 0xEB, 0x0B, 0x75, 0x07, 0xC8, 0x12, 0x03, 0xC0,
  0x77, 0x50, 0x2C, 0x81, 0x60, 0x7C, 0x02, 0x76, 0x0D, 0xB8, 0x1A, 0x0B, 0xB0, 0xD7, 0x70, 0x8B,
  0x81, 0xD0, 0xEB, 0x09, 0x77, 0x03, 0xC0, 0x3C, 0x04, 0x77, 0x10, 0xEB, 0x09, 0xB0, 0xE7, 0x72,
  0x09, 0xF0, 0xA7, 0x72, 0x04, 0xF0, 0x67, 0x73, 0xF0, 0x17, 0x73, 0x0A, 0xD0, 0xC7, 0x74, 0x06,
  0xD0, 0x77, 0x74, 0x01, 0xD0, 0x37, 0x74, 0x03, 0xC0, 0xE7, 0x75, 0x07, 0xC0, 0x97, 0x75, 0x0C,
  0xC0, 0x47, 0x74, 0x01, 0xD7, 0x75, 0x06, 0xC0, 0xB7, 0x75, 0x0C, 0xC0, 0x57, 0x74, 0x03, 0xD7,
  0x75, 0x0B, 0xC0, 0x97, 0x74, 0x08, 0xD0, 0x27, 0x58, 0x42, 0x86, 0x56, 0xCD, 0x09, 0x76, 0x03,
  0xFA, 0x0D, 0x01, 0x76, 0x03, 0xF9, 0x0E, 0x03, 0x77, 0x03, 0xF0, 0xD0, 0x37, 0x71, 0x86, 0x1A,
  0xDE, 0xFD, 0xA6, 0x77, 0x30,
  // "z" (U+007A)
  0x10, 0x8F, 0xFA, 0x81, 0x30, 0x8F, 0xFA, 0x81, 0x30, 0x8F, 0xFA, 0x81, 0x30, 0x8F, 0xFA, 0x81,
  0x30, 0x28, 0x06, 0x50, 0xAC, 0x0D, 0x76, 0x0D, 0xC0, 0x57, 0x50, 0x6C, 0x0D, 0x76, 0x0D, 0xC0,
  0x57, 0x50, 0x5C, 0x0D, 0x76, 0x0D, 0xC0, 0x57, 0x50, 0x5C, 0x0D, 0x76, 0x0D, 0xC0, 0x57, 0x50,
  0x5C, 0x0D, 0x76, 0x0D, 0xC0, 0x57, 0x50, 0x5C, 0x0D, 0x76, 0x0C, 0xC0, 0x57, 0x50, 0x5C, 0x0D,
  0x76, 0x0C, 0xC0, 0x57, 0x50, 0x4C, 0x0D, 0x76, 0x0C, 0xC0, 0x67, 0x50, 0x4C, 0x0D, 0x76, 0x0C,
  0xC0, 0x67, 0x50, 0x4C, 0x0D, 0x76, 0x0C, 0xC0, 0x67, 0x50, 0x4C, 0x0D, 0x76, 0x0C, 0xC0, 0x67,
  0x50, 0x4C, 0x0D, 0x76, 0x0B, 0xC0, 0xA8, 0x07, 0x50, 0x03, 0xFF, 0xB0, 0x90, 0x4F, 0xFB, 0x09,
  0x04, 0xFF, 0xB0, 0x90, 0x4F, 0xFB, 0x09,
  // "{" (U+007B)
  0x75, 0x84, 0x38, 0xBD, 0xEA, 0x73, 0x05, 0x0D, 0xD0, 0xA7, 0x20, 0x9F, 0x0A, 0x71, 0x08, 0xF9,
  0x0A, 0x70, 0x3E, 0x82, 0xD8, 0x63, 0x70, 0xAD, 0x05, 0x74, 0x0E, 0xC0, 0x67, 0x40, 0x2C, 0x0E,
  0x75, 0x04, 0xC0, 0xA7, 0x50, 0x5C, 0x09, 0x75, 0x05, 0xC0, 0x87, 0x50, 0x5C, 0x08, 0x75, 0x05,
  0xC0, 0x87, 0x50, 0x5C, 0x08, 0x75, 0x05, 0xC0, 0x87, 0x50, 0x5C, 0x08, 0x75, 0x05, 0xC0, 0x87,
  0x50, 0x5C, 0x08, 0x75, 0x05, 0xC0, 0x87, 0x50, 0x6C, 0x08, 0x75, 0x07, 0xC0, 0x77, 0x50, 0xBC,
  0x04, 0x74, 0x03, 0xD0, 0x17, 0x30, 0x40, 0xEC, 0x09, 0x78, 0x24, 0x68, 0xCD, 0x0D, 0x01, 0x70,
  0xCF, 0x0B, 0x01, 0x71, 0x0C, 0xC8, 0x1D, 0x72, 0x73, 0x0C, 0xD8, 0x1C, 0x71, 0x72, 0x0C, 0xF0,
  0xE0, 0x57, 0x28, 0x21, 0x37, 0xDD, 0x03, 0x75, 0x0B, 0xC0, 0xC7, 0x50, 0x10, 0xEC, 0x02, 0x75,
  0x0A, 0xC0, 0x67, 0x50, 0x7C, 0x07, 0x75, 0x05, 0xC0, 0x87, 0x50, 0x5C, 0x08, 0x75, 0x05, 0xC0,
  0x87, 0x50, 0x5C, 0x08, 0x75, 0x05, 0xC0, 0x87, 0x50, 0x5C, 0x08, 0x75, 0x05, 0xC0, 0x87, 0x50,
  0x5C, 0x08, 0x75, 0x05, 0xC0, 0x87, 0x50, 0x5C, 0x09, 0x75, 0x04, 0xC0, 0xA7, 0x50, 0x3C, 0x0E,
  0x76, 0xD0, 0x67, 0x50, 0xBD, 0x05, 0x74, 0x04, 0xE8, 0x2D, 0x86, 0x37, 0x10, 0xAF, 0x90, 0xA7,
  0x20, 0xBF, 0x0A, 0x73, 0x06, 0x0D, 0xD0, 0xA7, 0x58, 0x44, 0x8B, 0xDE, 0xA0,
  // "|" (U+007C)
  0x84, 0x67, 0x77, 0x5C, 0xB0, 0xB0, 0xCB, 0x0B, 0x0C, 0xB0, 0xB0, 0xCB, 0x0B, 0x0C, 0xB0, 0xB0,
  0xCB, 0x0B, 0x0C, 0xB0, 0xB0, 0xCB, 0x0B, 0x0C, 0xB0, 0xB0, 0xCB, 0x0B, 0x0C, 0xB0, 0xB0, 0xCB,
  0x0B, 0x0C, 0xB0, 0xB0, 0xCB, 0x0B, 0x0C, 0xB0, 0xB0, 0xCB, 0x0B, 0x0C, 0xB0, 0xB0, 0xCB, 0x0B,
  0x0C, 0xB0, 0xB0, 0xCB, 0x0B, 0x0C, 0xB0, 0xB0, 0xCB, 0x0B, 0x0C, 0xB0, 0xB0, 0xCB, 0x0B, 0x0C,
  0xB0, 0xB0, 0xCB, 0x0B, 0x0C, 0xB0, 0xB0, 0xCB, 0x0B, 0x0C, 0xB0, 0xB0, 0xCB, 0x0B, 0x0C, 0xB0,
  0xB0, 0xCB, 0x0B, 0x0C, 0xB0, 0xB0, 0xCB, 0x0B, 0x0C, 0xB0, 0xB0, 0xCB, 0x0B, 0x0C, 0xB0, 0xB0,
  0xCB, 0x0B, 0x0C, 0xB0, 0xB0, 0xCB, 0x0B, 0x0C, 0xB0, 0xB0, 0xCB, 0x0B, 0x0C, 0xB0, 0xB0, 0xCB,
  0x0B, 0x0C, 0xB0, 0xB0, 0xCB, 0x0B, 0x0C, 0xB0, 0xB0, 0xCB, 0x0B, 0x0C, 0xB0, 0xB0, 0xCB, 0x0B,
  0x0C, 0xB0, 0xB0, 0xCB, 0x0B, 0x0C, 0xB0, 0xB0, 0xCB, 0x0B, 0x0C, 0xB0, 0xB0, 0xCB, 0x0B, 0x0C,
  0xB0, 0xB0, 0xCB, 0x0B, 0x0C, 0xB0, 0xB0, 0xCB, 0x0B,
  // "}" (U+007D)
  0x84, 0xAE, 0xDB, 0x83, 0x75, 0x0B, 0xD0, 0xD0, 0x47, 0x30, 0xBF, 0x09, 0x72, 0x0B, 0xF9, 0x08,
  0x71, 0x82, 0x36, 0x8D, 0xE0, 0x27, 0x40, 0x6D, 0x09, 0x75, 0x06, 0xC0, 0xE7, 0x60, 0xEC, 0x02,
  0x75, 0x0A, 0xC0, 0x37, 0x50, 0x9C, 0x04, 0x75, 0x08, 0xC0, 0x47, 0x50, 0x8C, 0x04, 0x75, 0x08,
  0xC0, 0x47, 0x50, 0x8C, 0x04, 0x75, 0x08, 0xC0, 0x47, 0x50, 0x8C, 0x04, 0x75, 0x08, 0xC0, 0x47,
  0x50, 0x8C, 0x04, 0x75, 0x08, 0xC0, 0x47, 0x50, 0x8C, 0x05, 0x75, 0x07, 0xC0, 0x77, 0x50, 0x4C,
  0x0B, 0x75, 0x01, 0xD0, 0x37, 0x50, 0x9C, 0x0D, 0x03, 0x74, 0x01, 0x0D, 0xD8, 0x2C, 0x86, 0x47,
  0x10, 0x10, 0xAF, 0x0C, 0x73, 0x81, 0x28, 0xDC, 0x0C, 0x72, 0x81, 0x17, 0xCD, 0x0C, 0x71, 0x04,
  0x0E, 0xF0, 0xC7, 0x03, 0xD8, 0x2D, 0x73, 0x17, 0x10, 0xCC, 0x0A, 0x74, 0x02, 0xC0, 0xE7, 0x50,
  0x6C, 0x09, 0x75, 0x07, 0xC0, 0x67, 0x50, 0x8C, 0x05, 0x75, 0x08, 0xC0, 0x47, 0x50, 0x8C, 0x04,
  0x75, 0x08, 0xC0, 0x47, 0x50, 0x8C, 0x04, 0x75, 0x08, 0xC0, 0x47, 0x50, 0x8C, 0x04, 0x75, 0x08,
  0xC0, 0x47, 0x50, 0x8C, 0x04, 0x75, 0x08, 0xC0, 0x47, 0x50, 0xAC, 0x03, 0x75, 0x0E, 0xC0, 0x27,
  0x40, 0x6C, 0x0E, 0x74, 0x05, 0xD0, 0xA7, 0x82, 0x36, 0x8D, 0xE0, 0x37, 0x0B, 0xF9, 0x09, 0x71,
  0x0B, 0xF0, 0xA7, 0x20, 0xBD, 0x0D, 0x05, 0x73, 0x84, 0xAE, 0xDB, 0x84, 0x75,
  // "~" (U+007E)
  0x38, 0x65, 0xBD, 0xFE, 0xB7, 0x17, 0x58, 0x33, 0x30, 0x3C, 0xF9, 0x0A, 0x03, 0x72, 0x83, 0x4E,
  0x43, 0xEF, 0xC0, 0xB0, 0x46, 0x07, 0xA0, 0x40, 0xDF, 0xF8, 0x4D, 0x96, 0x57, 0xDB, 0x04, 0x0E,
  0xB8, 0x3A, 0x65, 0x7B, 0xFF, 0x98, 0x34, 0xEF, 0xC2, 0x50, 0x20, 0x9F, 0xD8, 0x29, 0x0E, 0x97,
  0x28, 0x11, 0x8E, 0xF9, 0x07, 0x20, 0x87, 0x58, 0x71, 0x6A, 0xDF, 0xEC, 0x82, 0x30,
  // "¡" (U+00A1)
  0x18, 0x56, 0xDE, 0xC3, 0x06, 0xD0, 0x30, 0xCD, 0x09, 0x0E, 0xD0, 0xB0, 0xED, 0x0B, 0x0C, 0xD0,
  0x90, 0x6D, 0x85, 0x30, 0x6D, 0xEC, 0x48, 0x0C, 0x10, 0x07, 0xB0, 0x22, 0x08, 0xB0, 0x22, 0x09,
  0xB0, 0x32, 0x09, 0xB0, 0x42, 0x0A, 0xB0, 0x42, 0x0B, 0xB0, 0x52, 0x0B, 0xB0, 0x52, 0x0C, 0xB0,
  0x62, 0x0C, 0xB0, 0x72, 0x0D, 0xB0, 0x72, 0x0E, 0xB0, 0x82, 0x0E, 0xB0, 0x82, 0xC0, 0x92, 0xC8,
  0x19, 0x01, 0xC8, 0x1A, 0x01, 0xC8, 0x1B, 0x02, 0xC8, 0x1B, 0x03, 0xC8, 0x1C, 0x03, 0xC8, 0x1C,
  0x04, 0xC8, 0x1D, 0x04, 0xC8, 0x1E, 0x05, 0xC8, 0x1E, 0x06, 0xD1, 0x06, 0xD1, 0x07, 0xD0, 0x10,
  0x8D, 0x01, 0x08, 0xD0, 0x20, 0x9D, 0x02, 0x09, 0xD0, 0x30, 0xAD, 0x03, 0x0B, 0xD0, 0x40,
  // "¢" (U+00A2)
  0x73, 0x0B, 0xA0, 0xB7, 0x72, 0x0B, 0xA0, 0xB7, 0x72, 0x0B, 0xA0, 0xB7, 0x72, 0x0B, 0xA0, 0xB7,
  0x72, 0x0B, 0xA8, 0x1D, 0x31, 0x74, 0x81, 0x39, 0xEE, 0x81, 0xEA, 0x47, 0x0A, 0xFD, 0x08, 0x40,
  0x10, 0xCF, 0xE0, 0x44, 0x0C, 0xFE, 0x0E, 0x40, 0x8D, 0x89, 0x0E, 0x83, 0x10, 0x25, 0xBF, 0x83,
  0x01, 0xD0, 0xC0, 0x27, 0x03, 0x02, 0x30, 0x8C, 0x0E, 0x01, 0x76, 0x0E, 0xC0, 0x67, 0x60, 0x3C,
  0x0E, 0x77, 0x08, 0xC0, 0xA7, 0x70, 0xBC, 0x06, 0x77, 0x0D, 0xC0, 0x37, 0x7D, 0x01, 0x76, 0x02,
  0xD7, 0x70, 0x2C, 0x0E, 0x77, 0x03, 0xC0, 0xD7, 0x70, 0x3C, 0x0D, 0x77, 0x03, 0xC0, 0xD7, 0x70,
  0x3C, 0x0E, 0x77, 0x02, 0xC0, 0xE7, 0x70, 0x1D, 0x01, 0x77, 0x0E, 0xC0, 0x37, 0x70, 0xCC, 0x05,
  0x77, 0x09, 0xC0, 0x97, 0x70, 0x5C, 0x0E, 0x77, 0x01, 0xD0, 0x67, 0x70, 0xBC, 0x0E, 0x01, 0x76,
  0x04, 0xD0, 0xC0, 0x17, 0x10, 0x50, 0x23, 0x0B, 0xD8, 0x1E, 0x72, 0x28, 0x41, 0x48, 0xDF, 0x43,
  0x01, 0x0E, 0xFF, 0x04, 0x40, 0x40, 0xEF, 0xE0, 0x45, 0x02, 0x0C, 0xFC, 0x0E, 0x03, 0x70, 0x50,
  0xBF, 0x81, 0xC7, 0x17, 0x40, 0xBA, 0x0C, 0x03, 0x77, 0x10, 0xBA, 0x0A, 0x77, 0x20, 0xBA, 0x0A,
  0x77, 0x20, 0xBA, 0x0A, 0x77, 0x20, 0xBA, 0x0A, 0x77, 0x20, 0xBA, 0x0A, 0x60,
  // "£" (U+00A3)
  0x75, 0x85, 0x35, 0x77, 0x64, 0x17, 0x78, 0x12, 0xAE, 0xF8, 0x1D, 0x71, 0x73, 0x06, 0xFE, 0x08,
  0x01, 0x70, 0x7F, 0xF9, 0x02, 0x60, 0x3F, 0x81, 0xDD, 0xED, 0x0A, 0x70, 0xBD, 0x07, 0x01, 0x38,
  0x11, 0x6C, 0xA0, 0x36, 0x02, 0xD0, 0x57, 0x10, 0x40, 0x87, 0x06, 0xC0, 0xC7, 0x74, 0x0A, 0xC0,
  0x77, 0x74, 0x0C, 0xC0, 0x57, 0x74, 0x0D, 0xC0, 0x37, 0x74, 0x0E, 0xC0, 0x37, 0x74, 0x0E, 0xC0,
  0x27, 0x74, 0x0E, 0xC0, 0x27, 0x74, 0x0E, 0xC0, 0x27, 0x74, 0x0E, 0xC0, 0x27, 0x74, 0x0E, 0xC0,
  0x27, 0x74, 0x0E, 0xC0, 0x27, 0x74, 0x0E, 0xC0, 0x27, 0x74, 0x0E, 0xC0, 0x27, 0x60, 0xBF, 0xFC,
  0x50, 0xBF, 0xFC, 0x50, 0xBF, 0xFC, 0x50, 0xBF, 0xFC, 0x58, 0x43, 0x55, 0x55, 0xEC, 0x07, 0x80,
  0x45, 0x73, 0x0E, 0xC0, 0x27, 0x74, 0x0E, 0xC0, 0x27, 0x74, 0x0E, 0xC0, 0x27, 0x74, 0x0E, 0xC0,
  0x27, 0x74, 0x0E, 0xC0, 0x27, 0x74, 0x0E, 0xC0, 0x27, 0x74, 0x0E, 0xC0, 0x27, 0x74, 0xD0, 0x17,
  0x73, 0x01, 0xD7, 0x74, 0x03, 0xC0, 0xC7, 0x74, 0x08, 0xC0, 0x87, 0x74, 0x0D, 0xC0, 0x27, 0x73,
  0x07, 0xC0, 0x77, 0x73, 0x05, 0xC0, 0xA7, 0x72, 0x01, 0x08, 0xC0, 0xD8, 0x09, 0x55, 0x09, 0xFF,
  0xFA, 0x09, 0xFF, 0xFA, 0x09, 0xFF, 0xFA, 0x09, 0xFF, 0xFA,
  // "¤" (U+00A4)
  0x20, 0x09, 0x77, 0x58, 0x14, 0xD1, 0x20, 0x9A, 0x07, 0x68, 0x43, 0x67, 0x65, 0x15, 0x84, 0x3E,
  0xFD, 0x16, 0xC0, 0x62, 0x81, 0x19, 0xEE, 0x0B, 0x04, 0x20, 0x30, 0xEB, 0x81, 0xB0, 0xBC, 0x81,
  0x56, 0xEF, 0xB8, 0x1A, 0x3E, 0xB0, 0xE0, 0x22, 0x0C, 0xFF, 0xF9, 0x04, 0x30, 0x10, 0xDF, 0x83,
  0xC9, 0x88, 0xBF, 0x90, 0x55, 0x02, 0x0E, 0xC0, 0xB0, 0x35, 0x01, 0x07, 0xD0, 0x76, 0x02, 0x0E,
  0xB0, 0x87, 0x20, 0x30, 0xEB, 0x08, 0x60, 0xAB, 0x09, 0x74, 0x02, 0x0E, 0xB0, 0x14, 0x01, 0xB0,
  0xC7, 0x60, 0x6B, 0x08, 0x40, 0x7B, 0x04, 0x77, 0x0D, 0xA0, 0xD4, 0x0B, 0xA0, 0xE7, 0x71, 0x07,
  0xB0, 0x13, 0x0D, 0xA0, 0xB7, 0x71, 0x04, 0xB0, 0x33, 0x0E, 0xA0, 0xA7, 0x71, 0x03, 0xB0, 0x43,
  0x0E, 0xA0, 0xA7, 0x71, 0x04, 0xB0, 0x43, 0x0C, 0xA0, 0xC7, 0x71, 0x06, 0xB0, 0x23, 0x09, 0xB0,
  0x17, 0x70, 0xAA, 0x0E, 0x40, 0x5B, 0x07, 0x76, 0x01, 0xB0, 0xB5, 0x0E, 0xB0, 0x27, 0x50, 0xBB,
  0x05, 0x50, 0x7B, 0x0D, 0x01, 0x73, 0x07, 0xB0, 0xD7, 0x0E, 0xB0, 0xD0, 0x37, 0x10, 0xAC, 0x05,
  0x60, 0x7E, 0x81, 0xA4, 0x12, 0x81, 0x37, 0xED, 0x0C, 0x50, 0x6F, 0xFF, 0x0A, 0x30, 0x4C, 0x0D,
  0x0E, 0xFD, 0x0C, 0xC8, 0x19, 0x03, 0xC8, 0x2D, 0x11, 0xAF, 0xA8, 0x2C, 0x30, 0xAC, 0x81, 0x82,
  0xEA, 0x0D, 0x01, 0x38, 0x72, 0x7B, 0xEF, 0xEC, 0x94, 0x40, 0xAB, 0x84, 0x80, 0x3E, 0xE2, 0x77,
  0x48, 0x1B, 0xF9, 0x30, 0x03, 0x77, 0x60, 0x62,
  // "¥" (U+00A5)
  0x01, 0xD0, 0x27, 0x50, 0x1D, 0x81, 0x30, 0xBC, 0x08, 0x75, 0x06, 0xC0, 0xD2, 0x05, 0xC0, 0xD7,
  0x50, 0xBC, 0x07, 0x30, 0xEC, 0x03, 0x73, 0x01, 0xD0, 0x13, 0x09, 0xC0, 0x87, 0x30, 0x6C, 0x0B,
  0x40, 0x3C, 0x0E, 0x73, 0x0C, 0xC0, 0x55, 0x0D, 0xC0, 0x47, 0x10, 0x1C, 0x0E, 0x60, 0x7C, 0x09,
  0x71, 0x07, 0xC0, 0x96, 0x01, 0xC0, 0xE7, 0x10, 0xCC, 0x03, 0x70, 0xBC, 0x04, 0x60, 0x2C, 0x0D,
  0x71, 0x05, 0xC0, 0xA6, 0x07, 0xC0, 0x77, 0x20, 0xEB, 0x0E, 0x60, 0xDC, 0x01, 0x72, 0x09, 0xC0,
  0x54, 0x02, 0xC0, 0xB7, 0x30, 0x3C, 0x0A, 0x40, 0x8C, 0x05, 0x74, 0x0D, 0xC0, 0x13, 0x0D, 0xB0,
  0xE7, 0x50, 0x7C, 0x06, 0x20, 0x3C, 0x09, 0x75, 0x01, 0xC0, 0xB2, 0x08, 0xC0, 0x37, 0x60, 0xBC,
  0x81, 0x10, 0xDB, 0x0C, 0x77, 0x05, 0xC0, 0x60, 0x3C, 0x07, 0x77, 0x10, 0xEB, 0x0C, 0x09, 0xC0,
  0x17, 0x71, 0x09, 0xC0, 0xEB, 0x0A, 0x77, 0x20, 0x3F, 0x90, 0x57, 0x73, 0x0D, 0xE0, 0xE7, 0x50,
  0xDF, 0xFD, 0x01, 0x50, 0xDF, 0xFD, 0x01, 0x50, 0xDF, 0xFD, 0x01, 0x50, 0xDF, 0xFD, 0x01, 0x75,
  0x07, 0xC0, 0x97, 0x76, 0x07, 0xC0, 0x97, 0x76, 0x07, 0xC0, 0x97, 0x76, 0x07, 0xC0, 0x97, 0x60,
  0xDF, 0xFD, 0x01, 0x50, 0xDF, 0xFD, 0x01, 0x50, 0xDF, 0xFD, 0x01, 0x50, 0xDF, 0xFD, 0x01, 0x75,
  0x07, 0xC0, 0x97, 0x76, 0x07, 0xC0, 0x97, 0x76, 0x07, 0xC0, 0x97, 0x76, 0x07, 0xC0, 0x97, 0x76,
  0x07, 0xC0, 0x97, 0x76, 0x07, 0xC0, 0x97, 0x76, 0x07, 0xC0, 0x97, 0x76, 0x07, 0xC0, 0x97, 0x30,
  // "¦" (U+00A6)
  0x0C, 0xB0, 0xB0, 0xCB, 0x0B, 0x0C, 0xB0, 0xB0, 0xCB, 0x0B, 0x0C, 0xB0, 0xB0, 0xCB, 0x0B, 0x0C,
  0xB0, 0xB0, 0xCB, 0x0B, 0x0C, 0xB0, 0xB0, 0xCB, 0x0B, 0x0C, 0xB0, 0xB0, 0xCB, 0x0B, 0x0C, 0xB0,
  0xB0, 0xCB, 0x0B, 0x0C, 0xB0, 0xB0, 0xCB, 0x0B, 0x0C, 0xB0, 0xB0, 0xCB, 0x0B, 0x0C, 0xB0, 0xB0,
  0xCB, 0x0B, 0x0C, 0xB0, 0xB0, 0xCB, 0x0B, 0x0C, 0xB0, 0xB8, 0x09, 0x82, 0x00, 0xCB, 0x0B, 0x0C,
  0xB0, 0xB0, 0xCB, 0x0B, 0x0C, 0xB0, 0xB0, 0xCB, 0x0B, 0x0C, 0xB0, 0xB0, 0xCB, 0x0B, 0x0C, 0xB0,
  0xB0, 0xCB, 0x0B, 0x0C, 0xB0, 0xB0, 0xCB, 0x0B, 0x0C, 0xB0, 0xB0, 0xCB, 0x0B, 0x0C, 0xB0, 0xB0,
  0xCB, 0x0B, 0x0C, 0xB0, 0xB0, 0xCB, 0x0B, 0x0C, 0xB0, 0xB0, 0xCB, 0x0B, 0x0C, 0xB0, 0xB0, 0xCB,
  0x0B, 0x0C, 0xB0, 0xB0, 0xCB, 0x0B,
  // "§" (U+00A7)
  0x68, 0x23, 0x8B, 0xDA, 0x82, 0xEC, 0x95, 0x71, 0x03, 0x0C, 0xFB, 0x81, 0xE8, 0x14, 0x06, 0xFF,
  0x0D, 0x30, 0x4F, 0xF9, 0x08, 0x30, 0xDD, 0x85, 0xA6, 0x55, 0x7A, 0xEB, 0x03, 0x20, 0x4C, 0x0D,
  0x02, 0x78, 0x14, 0xCC, 0x30, 0x8C, 0x03, 0x73, 0x01, 0x30, 0xAB, 0x0E, 0x77, 0x10, 0xAB, 0x0E,
  0x77, 0x10, 0x8C, 0x02, 0x77, 0x04, 0xC0, 0xA7, 0x71, 0x0D, 0xC0, 0xB0, 0x17, 0x60, 0x3D, 0x0E,
  0x07, 0x76, 0x06, 0xE8, 0x1E, 0x71, 0x74, 0x04, 0x0E, 0xE0, 0xE0, 0x87, 0x30, 0x8F, 0xA0, 0xE0,
  0x56, 0x01, 0x0C, 0xC0, 0xCF, 0x09, 0x50, 0xCB, 0x83, 0xD3, 0x02, 0x9E, 0x0A, 0x30, 0x6B, 0x0E,
  0x01, 0x40, 0x20, 0xBD, 0x07, 0x20, 0xDB, 0x07, 0x70, 0x7C, 0x81, 0xE1, 0x1C, 0x03, 0x71, 0x07,
  0xC0, 0x50, 0x2C, 0x02, 0x72, 0x0E, 0xB0, 0x70, 0x2C, 0x05, 0x72, 0x0B, 0xB8, 0x18, 0x0E, 0xB0,
  0xC7, 0x20, 0xAB, 0x81, 0x80, 0xAC, 0x0A, 0x71, 0x0C, 0xB8, 0x15, 0x03, 0xD0, 0xD0, 0x35, 0x03,
  0xC0, 0x12, 0x06, 0xE0, 0xA0, 0x23, 0x0C, 0xB0, 0x94, 0x05, 0x0E, 0xE8, 0x1A, 0x5C, 0xB0, 0xD0,
  0x15, 0x01, 0x0B, 0xFB, 0x0E, 0x03, 0x71, 0x04, 0x0C, 0xF0, 0xE0, 0x27, 0x40, 0x50, 0xDE, 0x0A,
  0x76, 0x06, 0x0E, 0xD0, 0xA7, 0x70, 0x8D, 0x06, 0x77, 0x04, 0xC0, 0xD7, 0x71, 0x08, 0xC0, 0x37,
  0x70, 0x2C, 0x05, 0x77, 0x01, 0xC0, 0x77, 0x70, 0x4C, 0x81, 0x52, 0x57, 0x50, 0xBC, 0x84, 0x33,
  0xFC, 0x61, 0x70, 0x10, 0xAC, 0x81, 0xD0, 0x3C, 0x86, 0xC8, 0x65, 0x56, 0xAE, 0xD8, 0x16, 0x03,
  0xFF, 0xA0, 0xB2, 0x03, 0xFF, 0x90, 0xB4, 0x03, 0x0B, 0xFC, 0x0E, 0x06, 0x78, 0x32, 0x7A, 0xDE,
  0xA8, 0x2E, 0xC9, 0x56,
  // "¨" (U+00A8)
  0x18, 0x27, 0xDE, 0x86, 0x84, 0x4D, 0xEA, 0x13, 0xC0, 0x64, 0x01, 0x0E, 0xB0, 0x90, 0x7C, 0x09,
  0x40, 0x4C, 0x0D, 0x07, 0xC0, 0x94, 0x04, 0xC0, 0xD0, 0x3C, 0x05, 0x40, 0x10, 0xEB, 0x84, 0x90,
  0x6D, 0xE8, 0x68, 0x24, 0xDE, 0xA1,
  // "©" (U+00A9)
  0x77, 0x28, 0x42, 0x59, 0xBD, 0xEA, 0x84, 0xED, 0xB8, 0x51, 0x77, 0x77, 0x81, 0x17, 0xCF, 0xF0,
  0xB0, 0x57, 0x77, 0x30, 0x10, 0x9F, 0xFD, 0x0E, 0x07, 0x77, 0x70, 0x70, 0xED, 0x83, 0xB7, 0x42,
  0x12, 0x83, 0x12, 0x58, 0xCD, 0x0D, 0x04, 0x77, 0x30, 0x10, 0xBC, 0x81, 0xD6, 0x17, 0x58, 0x12,
  0x7E, 0xC0, 0x87, 0x71, 0x02, 0x0D, 0xB0, 0xE0, 0x57, 0x73, 0x01, 0x08, 0xC0, 0xB7, 0x60, 0x20,
  0xEB, 0x0A, 0x01, 0x77, 0x60, 0x30, 0xDB, 0x0C, 0x74, 0x02, 0x0E, 0xB0, 0x87, 0x77, 0x30, 0xBB,
  0x0B, 0x73, 0x0C, 0xB0, 0x67, 0x28, 0x90, 0x37, 0xBD, 0xEF, 0xEC, 0x94, 0x70, 0xAB, 0x08, 0x71,
  0x08, 0xB0, 0x87, 0x10, 0x30, 0xCF, 0xB8, 0x1E, 0x81, 0x50, 0xCB, 0x04, 0x60, 0x2B, 0x0B, 0x71,
  0x08, 0xFF, 0x04, 0x50, 0x10, 0xEA, 0x0D, 0x60, 0xAB, 0x02, 0x70, 0x9F, 0xF0, 0xD7, 0x06, 0xB0,
  0x74, 0x02, 0xB0, 0x87, 0x06, 0xE8, 0x5B, 0x76, 0x56, 0x9D, 0xA0, 0x77, 0x10, 0xCA, 0x0D, 0x40,
  0x9B, 0x01, 0x60, 0x20, 0xEC, 0x0B, 0x02, 0x78, 0x13, 0xA1, 0x71, 0x05, 0xB0, 0x53, 0x0E, 0xA0,
  0x97, 0x09, 0xC0, 0xA7, 0x77, 0x0D, 0xA0, 0xB2, 0x04, 0xB0, 0x46, 0x01, 0x0E, 0xB0, 0xD7, 0x77,
  0x10, 0x8B, 0x20, 0x7A, 0x0E, 0x70, 0x5C, 0x05, 0x77, 0x71, 0x03, 0xB8, 0x14, 0x0B, 0xA0, 0xB7,
  0x09, 0xB0, 0xE7, 0x77, 0x3B, 0x81, 0x70, 0xDA, 0x08, 0x70, 0xCB, 0x0A, 0x77, 0x73, 0x0C, 0xA0,
  0xA1, 0xB0, 0x57, 0x0E, 0xB0, 0x77, 0x77, 0x30, 0xAA, 0x0C, 0x01, 0xB0, 0x47, 0xC0, 0x67, 0x77,
  0x30, 0x9A, 0x0D, 0x01, 0xB0, 0x47, 0xC0, 0x57, 0x77, 0x30, 0x8A, 0x0D, 0x01, 0xB0, 0x47, 0xC0,
  0x67, 0x77, 0x30, 0x8A, 0x0D, 0x1B, 0x04, 0x70, 0xEB, 0x07, 0x77, 0x73, 0x09, 0xA0, 0xD1, 0xB0,
  0x57, 0x0D, 0xB0, 0xA7, 0x77, 0x30, 0xAA, 0x81, 0xC0, 0xDA, 0x08, 0x70, 0xAB, 0x0D, 0x77, 0x73,
  0x0C, 0xA8, 0x1A, 0x0B, 0xA0, 0xB7, 0x07, 0xC0, 0x37, 0x77, 0x2B, 0x81, 0x70, 0x7A, 0x0E, 0x70,
  0x2C, 0x0B, 0x77, 0x71, 0x03, 0xB8, 0x14, 0x03, 0xB0, 0x47, 0x0C, 0xC0, 0x77, 0x77, 0x08, 0xB3,
  0x0E, 0xA0, 0x97, 0x05, 0xD0, 0x80, 0x17, 0x10, 0x50, 0x37, 0x20, 0xDA, 0x0B, 0x30, 0x8B, 0x01,
  0x70, 0xAD, 0x86, 0xEA, 0x75, 0x56, 0x8B, 0xA0, 0x67, 0x10, 0x5B, 0x05, 0x30, 0x2B, 0x08, 0x70,
  0x10, 0xDF, 0xF0, 0x67, 0x10, 0xCA, 0x0E, 0x50, 0xAB, 0x02, 0x70, 0x10, 0xCF, 0xE0, 0x67, 0x06,
  0xB0, 0x75, 0x02, 0xB0, 0xC7, 0x20, 0x70, 0xEF, 0xB0, 0xB0, 0x26, 0x01, 0x0E, 0xA0, 0xD7, 0x07,
  0xB0, 0x97, 0x38, 0x90, 0x59, 0xCD, 0xFE, 0xDB, 0x72, 0x71, 0x0C, 0xB0, 0x57, 0x10, 0xCB, 0x07,
  0x77, 0x75, 0x0B, 0xB0, 0x97, 0x20, 0x10, 0xDB, 0x08, 0x77, 0x73, 0x0B, 0xB0, 0xC7, 0x40, 0x30,
  0xEB, 0x0B, 0x01, 0x77, 0x60, 0x30, 0xCB, 0x0D, 0x01, 0x75, 0x02, 0x0E, 0xB0, 0xE0, 0x67, 0x74,
  0x07, 0xC0, 0xC0, 0x17, 0x70, 0x10, 0xCC, 0x81, 0xD6, 0x17, 0x58, 0x11, 0x7E, 0xC0, 0xA7, 0x74,
  0x07, 0xE8, 0x3B, 0x74, 0x21, 0x28, 0x31, 0x25, 0x8C, 0xD0, 0xE0, 0x57, 0x76, 0x02, 0x0A, 0xFF,
  0xD8, 0x1E, 0x81, 0x77, 0x72, 0x81, 0x28, 0xDF, 0xF8, 0x1C, 0x71, 0x77, 0x77, 0x84, 0x26, 0x9B,
  0xDE, 0xA8, 0x4E, 0xDB, 0x95, 0x17, 0x71,
  // "ª" (U+00AA)
  0x38, 0x90, 0x26, 0xAD, 0xEF, 0xEC, 0x81, 0x50, 0x9F, 0xA0, 0xE0, 0x44, 0x07, 0xB8, 0x2C, 0x99,
  0xCB, 0x0E, 0x02, 0x48, 0x1D, 0x81, 0x40, 0x7B, 0x09, 0x75, 0x0D, 0xA0, 0xD7, 0x50, 0x9B, 0x75,
  0x09, 0xB0, 0x17, 0x40, 0x9B, 0x02, 0x48, 0x26, 0xAD, 0xEF, 0x02, 0x20, 0x50, 0xEF, 0xC8, 0x12,
  0x04, 0xC8, 0x4E, 0xB9, 0x86, 0xBB, 0x81, 0x20, 0xDB, 0x09, 0x50, 0x9B, 0x00, 0x2B, 0x0C, 0x60,
  0x9B, 0x02, 0x04, 0xB0, 0x76, 0x0B, 0xB0, 0x20, 0x4B, 0x06, 0x60, 0xEB, 0x00, 0x2B, 0x08, 0x50,
  0x6C, 0x81, 0x20, 0xEA, 0x0E, 0x01, 0x30, 0x4D, 0x81, 0x20, 0x7B, 0x82, 0xEA, 0x9C, 0xA0, 0xAB,
  0x02, 0x20, 0xBF, 0x81, 0x70, 0xDA, 0x02, 0x38, 0x56, 0xCE, 0xEC, 0x82, 0x28, 0x26, 0xAA, 0x10,
  // "«" (U+00AB)
  0x71, 0x81, 0x2C, 0x57, 0x28, 0x18, 0xA2, 0x73, 0x0D, 0xA0, 0xC0, 0x46, 0x05, 0xB0, 0x97, 0x10,
  0xAC, 0x05, 0x50, 0x20, 0xEB, 0x0C, 0x70, 0x6C, 0x09, 0x60, 0xCC, 0x02, 0x60, 0x3C, 0x0D, 0x01,
  0x50, 0xAC, 0x07, 0x60, 0x10, 0xDC, 0x04, 0x50, 0x6C, 0x0C, 0x70, 0xBC, 0x09, 0x50, 0x3D, 0x02,
  0x60, 0x8C, 0x0D, 0x50, 0x10, 0xEC, 0x07, 0x60, 0x5D, 0x04, 0x50, 0xBC, 0x0C, 0x60, 0x20, 0xEC,
  0x09, 0x50, 0x8D, 0x02, 0x60, 0xCC, 0x0D, 0x50, 0x5D, 0x07, 0x60, 0x9D, 0x03, 0x40, 0x20, 0xEC,
  0x0C, 0x70, 0xCC, 0x0E, 0x01, 0x40, 0x3D, 0x09, 0x70, 0x20, 0xEC, 0x0B, 0x50, 0x9D, 0x04, 0x70,
  0x5D, 0x06, 0x50, 0xCC, 0x0D, 0x01, 0x70, 0x9C, 0x0E, 0x02, 0x40, 0x10, 0xEC, 0x09, 0x71, 0x0C,
  0xC0, 0xB5, 0x04, 0xD0, 0x47, 0x01, 0x0E, 0xC0, 0x65, 0x07, 0xC0, 0xE0, 0x17, 0x04, 0xD0, 0x25,
  0x0A, 0xC0, 0xA7, 0x10, 0x7C, 0x0C, 0x60, 0xDC, 0x05, 0x71, 0x0A, 0xC0, 0x75, 0x02, 0x0E, 0xB0,
  0xE0, 0x17, 0x01, 0x0D, 0xC0, 0x35, 0x05, 0xC0, 0xA7, 0x10, 0x20, 0xEA, 0x0E, 0x06, 0x60, 0x9B,
  0x0C, 0x01, 0x71, 0x82, 0x5F, 0xA1, 0x71, 0x81, 0xCE, 0x67, 0x40, 0x27, 0x30, 0x14,
  // "¬" (U+00AC)
  0x04, 0x80, 0xA2, 0x50, 0x40, 0xDF, 0xFF, 0x90, 0xC0, 0xDF, 0xFF, 0x90, 0xC0, 0xDF, 0xFF, 0x90,
  0xC0, 0xDF, 0xFF, 0x90, 0xC7, 0x75, 0x06, 0xB0, 0xC7, 0x75, 0x06, 0xB0, 0xC7, 0x75, 0x06, 0xB0,
  0xC7, 0x75, 0x06, 0xB0, 0xC7, 0x75, 0x06, 0xB0, 0xC7, 0x75, 0x06, 0xB0, 0xC7, 0x75, 0x06, 0xB0,
  0xC7, 0x75, 0x06, 0xB0, 0xC7, 0x75, 0x06, 0xB0, 0xC7, 0x75, 0x06, 0xB0, 0xC7, 0x75, 0x06, 0xB0,
  0xC7, 0x75, 0x06, 0xB0, 0xC0,
  // "®" (U+00AE)
  0x77, 0x28, 0x42, 0x59, 0xBD, 0xEA, 0x84, 0xED, 0xB8, 0x51, 0x77, 0x77, 0x81, 0x17, 0xCF, 0xF0,
  0xB0, 0x57, 0x77, 0x30, 0x10, 0x9F, 0xFD, 0x0E, 0x07, 0x77, 0x70, 0x70, 0xED, 0x83, 0xB7, 0x42,
  0x12, 0x83, 0x12, 0x58, 0xCD, 0x0D, 0x04, 0x77, 0x30, 0x10, 0xBC, 0x81, 0xD6, 0x17, 0x58, 0x12,
  0x7E, 0xC0, 0x87, 0x71, 0x02, 0x0D, 0xB0, 0xE0, 0x57, 0x73, 0x01, 0x08, 0xC0, 0xB7, 0x60, 0x20,
  0xEB, 0x0A, 0x01, 0x77, 0x60, 0x30, 0xDB, 0x0C, 0x74, 0x02, 0x0E, 0xB0, 0x87, 0x77, 0x30, 0xBB,
  0x0B, 0x73, 0x0C, 0xB0, 0x67, 0x77, 0x50, 0xAB, 0x08, 0x71, 0x08, 0xB0, 0x85, 0x01, 0xF9, 0x83,
  0xED, 0xA6, 0x17, 0x20, 0xCB, 0x04, 0x60, 0x2B, 0x0B, 0x60, 0x1F, 0xE0, 0x87, 0x10, 0x10, 0xEA,
  0x0D, 0x60, 0xAB, 0x02, 0x60, 0x1F, 0xF0, 0xC7, 0x10, 0x6B, 0x07, 0x40, 0x2B, 0x08, 0x70, 0x1F,
  0xF9, 0x09, 0x71, 0x0C, 0xA0, 0xD4, 0x09, 0xB0, 0x17, 0x01, 0xC0, 0x33, 0x81, 0x25, 0xCD, 0x01,
  0x70, 0x5B, 0x05, 0x30, 0xEA, 0x09, 0x71, 0x01, 0xC0, 0x36, 0x0B, 0xC0, 0x57, 0x10, 0xDA, 0x0B,
  0x20, 0x4B, 0x04, 0x71, 0x01, 0xC0, 0x36, 0x02, 0xC0, 0x77, 0x10, 0x8B, 0x20, 0x7A, 0x0E, 0x72,
  0x01, 0xC0, 0x37, 0xC0, 0x87, 0x10, 0x3B, 0x81, 0x40, 0xBA, 0x0B, 0x72, 0x01, 0xC0, 0x37, 0xC0,
  0x77, 0x2B, 0x81, 0x70, 0xDA, 0x08, 0x72, 0x01, 0xC0, 0x36, 0x04, 0xC0, 0x47, 0x20, 0xCA, 0x0A,
  0x1B, 0x05, 0x72, 0x01, 0xC0, 0x35, 0x01, 0x0C, 0xB0, 0xE7, 0x30, 0xAA, 0x0C, 0x01, 0xB0, 0x47,
  0x20, 0x1C, 0x03, 0x38, 0x12, 0x6D, 0xC0, 0x57, 0x30, 0x9A, 0x0D, 0x01, 0xB0, 0x47, 0x20, 0x1F,
  0xF0, 0x67, 0x40, 0x8A, 0x0D, 0x01, 0xB0, 0x47, 0x20, 0x1F, 0xD0, 0xD0, 0x47, 0x50, 0x8A, 0x0D,
  0x1B, 0x04, 0x72, 0x01, 0xFD, 0x05, 0x76, 0x09, 0xA0, 0xD1, 0xB0, 0x57, 0x20, 0x1C, 0x03, 0x30,
  0x8B, 0x0D, 0x76, 0x0A, 0xA8, 0x1C, 0x0D, 0xA0, 0x87, 0x20, 0x1C, 0x03, 0x30, 0x1C, 0x06, 0x75,
  0x0C, 0xA8, 0x1A, 0x0B, 0xA0, 0xB7, 0x20, 0x1C, 0x03, 0x40, 0x9B, 0x0E, 0x75, 0xB8, 0x17, 0x07,
  0xA0, 0xE7, 0x20, 0x1C, 0x03, 0x40, 0x1C, 0x07, 0x73, 0x03, 0xB8, 0x14, 0x03, 0xB0, 0x47, 0x10,
  0x1C, 0x03, 0x50, 0x9B, 0x0E, 0x01, 0x72, 0x08, 0xB3, 0x0E, 0xA0, 0x97, 0x10, 0x1C, 0x03, 0x50,
  0x2C, 0x08, 0x72, 0x0D, 0xA0, 0xB3, 0x08, 0xB0, 0x17, 0x01, 0xC0, 0x36, 0x09, 0xB0, 0xE0, 0x17,
  0x05, 0xB0, 0x53, 0x02, 0xB0, 0x87, 0x01, 0xC0, 0x36, 0x02, 0xC0, 0x97, 0x0C, 0xA0, 0xE5, 0x0A,
  0xB0, 0x26, 0x01, 0xC0, 0x37, 0x0A, 0xC0, 0x25, 0x06, 0xB0, 0x75, 0x02, 0xB0, 0xC6, 0x01, 0xC0,
  0x37, 0x02, 0xC0, 0x94, 0x01, 0x0E, 0xA0, 0xD7, 0x07, 0xB0, 0x96, 0x80, 0x0B, 0x02, 0x71, 0x84,
  0x8B, 0xBB, 0xB1, 0x30, 0xCB, 0x05, 0x71, 0x0C, 0xB0, 0x77, 0x77, 0x50, 0xBB, 0x09, 0x72, 0x01,
  0x0D, 0xB0, 0x87, 0x77, 0x30, 0xBB, 0x0C, 0x74, 0x03, 0x0E, 0xB0, 0xB0, 0x17, 0x76, 0x03, 0x0C,
  0xB0, 0xD0, 0x17, 0x50, 0x20, 0xEB, 0x0E, 0x06, 0x77, 0x40, 0x7C, 0x0C, 0x01, 0x77, 0x01, 0x0C,
  0xC8, 0x1D, 0x61, 0x75, 0x81, 0x17, 0xEC, 0x0A, 0x77, 0x40, 0x7E, 0x83, 0xB7, 0x42, 0x12, 0x83,
  0x12, 0x58, 0xCD, 0x0E, 0x05, 0x77, 0x60, 0x20, 0xAF, 0xFD, 0x81, 0xE8, 0x17, 0x77, 0x28, 0x12,
  0x8D, 0xFF, 0x81, 0xC7, 0x17, 0x77, 0x78, 0x42, 0x69, 0xBD, 0xEA, 0x84, 0xED, 0xB9, 0x51, 0x77,
  0x10,
  // "¯" (U+00AF)
  0x01, 0x80, 0xA7, 0x50, 0x20, 0x3F, 0xFF, 0xE0, 0x70, 0x3F, 0xFF, 0xE0, 0x70, 0x3F, 0xFF, 0xE0,
  0x70, 0x3F, 0xFF, 0xE0, 0x70,
  // "°" (U+00B0)
  0x58, 0x72, 0x8C, 0xEF, 0xEC, 0x82, 0x72, 0x09, 0xFA, 0x09, 0x70, 0xCF, 0xC0, 0xC5, 0x0A, 0xB8,
  0x5D, 0x51, 0x01, 0x5D, 0xB0, 0xA3, 0x04, 0xB0, 0xC0, 0x16, 0x0C, 0xB0, 0x42, 0x0A, 0xB0, 0x37,
  0x02, 0xB0, 0xA2, 0x0E, 0xA0, 0xC7, 0x20, 0xBA, 0x0E, 0x2B, 0x08, 0x72, 0x08, 0xB0, 0x01, 0xB0,
  0x77, 0x20, 0x7B, 0x02, 0x1B, 0x08, 0x72, 0x07, 0xB8, 0x11, 0x0E, 0xA0, 0xB7, 0x20, 0xBA, 0x0E,
  0x20, 0xAB, 0x02, 0x70, 0x2B, 0x0A, 0x20, 0x4B, 0x0C, 0x70, 0xBB, 0x04, 0x30, 0xAB, 0x85, 0xD5,
  0x10, 0x15, 0xCB, 0x0A, 0x50, 0xCF, 0xC0, 0xC7, 0x09, 0xFA, 0x09, 0x72, 0x87, 0x28, 0xCE, 0xFE,
  0xC8, 0x25,
  // "±" (U+00B1)
  0x73, 0x0E, 0xB0, 0x47, 0x76, 0x0E, 0xB0, 0x47, 0x76, 0x0E, 0xB0, 0x47, 0x76, 0x0E, 0xB0, 0x47,
  0x76, 0x0E, 0xB0, 0x47, 0x76, 0x0E, 0xB0, 0x47, 0x76, 0x0E, 0xB0, 0x47, 0x76, 0x0E, 0xB0, 0x47,
  0x76, 0x0E, 0xB0, 0x47, 0x76, 0x0E, 0xB0, 0x47, 0x76, 0x0E, 0xB0, 0x47, 0x76, 0x0E, 0xB0, 0x47,
  0x30, 0x48, 0x05, 0x50, 0xEB, 0x07, 0x80, 0x55, 0x10, 0xDF, 0xFF, 0xA0, 0x10, 0xDF, 0xFF, 0xA0,
  0x10, 0xDF, 0xFF, 0xA0, 0x10, 0xDF, 0xFF, 0xA0, 0x17, 0x30, 0xEB, 0x04, 0x77, 0x60, 0xEB, 0x04,
  0x77, 0x60, 0xEB, 0x04, 0x77, 0x60, 0xEB, 0x04, 0x77, 0x60, 0xEB, 0x04, 0x77, 0x60, 0xEB, 0x04,
  0x77, 0x60, 0xEB, 0x04, 0x77, 0x60, 0xEB, 0x04, 0x77, 0x60, 0xEB, 0x04, 0x77, 0x60, 0xEB, 0x04,
  0x77, 0x60, 0xEB, 0x04, 0x77, 0x60, 0xEB, 0x04, 0x80, 0x9A, 0x10, 0x04, 0x80, 0xA3, 0x51, 0x0D,
  0xFF, 0xFA, 0x02, 0x0D, 0xFF, 0xFA, 0x02, 0x0D, 0xFF, 0xFA, 0x02, 0x0D, 0xFF, 0xFA, 0x02,
  // "²" (U+00B2)
  0x58, 0x43, 0x67, 0x76, 0x37, 0x10, 0x60, 0xDE, 0x0D, 0x06, 0x40, 0x10, 0xCF, 0xB0, 0x92, 0x02,
  0x0D, 0xFD, 0x82, 0x70, 0x1D, 0xB8, 0x48, 0x30, 0x16, 0xEB, 0x0E, 0x28, 0x24, 0xFC, 0x25, 0x03,
  0xC0, 0x42, 0x06, 0x71, 0x0B, 0xB0, 0x77, 0x40, 0x9B, 0x08, 0x74, 0x0A, 0xB0, 0x77, 0x40, 0xCB,
  0x05, 0x73, 0x01, 0xC0, 0x17, 0x30, 0x8B, 0x0B, 0x73, 0x02, 0xC0, 0x37, 0x30, 0xCB, 0x09, 0x73,
  0x09, 0xB0, 0xD7, 0x30, 0x6B, 0x0E, 0x02, 0x72, 0x04, 0xC0, 0x47, 0x20, 0x20, 0xEB, 0x06, 0x72,
  0x01, 0x0D, 0xB0, 0x87, 0x30, 0xCB, 0x0A, 0x73, 0x0B, 0xB0, 0xB7, 0x30, 0x9B, 0x0D, 0x01, 0x72,
  0x07, 0xB0, 0xE0, 0x17, 0x20, 0x5C, 0x0B, 0x80, 0x58, 0x00, 0x7F, 0xF0, 0xE0, 0x7F, 0xF0, 0xE0,
  0x7F, 0xF0, 0xE0,
  // "³" (U+00B3)
  0x38, 0x71, 0x6B, 0xDE, 0xED, 0xA5, 0x70, 0x80, 0xEF, 0x90, 0xC0, 0x23, 0x03, 0x0D, 0xFC, 0x0D,
  0x01, 0x20, 0x4C, 0x83, 0xEA, 0x8A, 0xEC, 0x0A, 0x38, 0x28, 0xFD, 0x55, 0x09, 0xC0, 0x13, 0x08,
  0x71, 0x0C, 0xB0, 0x57, 0x50, 0x8B, 0x06, 0x75, 0x07, 0xB0, 0x57, 0x50, 0xAB, 0x03, 0x74, 0x02,
  0xB0, 0xD7, 0x40, 0x30, 0xDB, 0x05, 0x68, 0x37, 0x88, 0x9C, 0xC0, 0x77, 0x0E, 0xE0, 0xC0, 0x47,
  0x10, 0xEE, 0x0D, 0x06, 0x71, 0x0E, 0xF9, 0x0D, 0x03, 0x73, 0x81, 0x26, 0xDB, 0x0E, 0x01, 0x75,
  0x0C, 0xB0, 0x97, 0x50, 0x2B, 0x0E, 0x76, 0x0D, 0xB0, 0x27, 0x50, 0xCB, 0x03, 0x75, 0x0E, 0xB0,
  0x01, 0x73, 0x05, 0xB8, 0x4E, 0x07, 0xC6, 0x16, 0x05, 0x0E, 0xB8, 0x19, 0x07, 0xB8, 0x4D, 0xA9,
  0x8A, 0xDC, 0x82, 0xE1, 0x07, 0xFE, 0x04, 0x20, 0x40, 0xEF, 0xB0, 0xC0, 0x25, 0x82, 0x48, 0xBE,
  0xA8, 0x2E, 0xC9, 0x35,
  // "´" (U+00B4)
  0x50, 0x28, 0x01, 0x70, 0x65, 0x0A, 0xD0, 0x74, 0x03, 0xD0, 0xC5, 0x0C, 0xC0, 0xE0, 0x14, 0x06,
  0xC0, 0xE0, 0x34, 0x01, 0x0E, 0xC0, 0x45, 0x0A, 0xC0, 0x55, 0x05, 0xC0, 0x55, 0x01, 0x0E, 0xB0,
  0x56, 0x08, 0xA0, 0xE0, 0x47,
  // "µ" (U+00B5)
  0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40,
  0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0,
  0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02,
  0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40,
  0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0,
  0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02,
  0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xDC, 0x02, 0x0B, 0xC0, 0x37, 0x40,
  0xDC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xEC, 0x02, 0x0B, 0xC0, 0x37, 0x4D, 0x02, 0x0B, 0xC0, 0x47,
  0x30, 0x3D, 0x02, 0x0B, 0xC0, 0x57, 0x30, 0x6D, 0x02, 0x0B, 0xC0, 0x77, 0x30, 0xAD, 0x02, 0x0B,
  0xC0, 0xB7, 0x20, 0x1E, 0x02, 0x0B, 0xD0, 0x17, 0x10, 0x8E, 0x02, 0x0B, 0xD0, 0xA7, 0x05, 0xF0,
  0x20, 0xBE, 0x0A, 0x02, 0x30, 0x30, 0x9B, 0x0C, 0xC0, 0x20, 0xBF, 0x98, 0x1D, 0xDE, 0xC0, 0xB0,
  0x5C, 0x02, 0x0B, 0xC0, 0xEF, 0xA8, 0x1E, 0x22, 0xC0, 0x20, 0xBC, 0x04, 0xF9, 0x0E, 0x03, 0x2C,
  0x02, 0x0B, 0xC8, 0x11, 0x3D, 0xD0, 0xB0, 0x23, 0x0D, 0xB0, 0x20, 0xBC, 0x02, 0x28, 0x33, 0x67,
  0x52, 0x73, 0x0B, 0xC0, 0x27, 0x73, 0x0B, 0xC0, 0x37, 0x73, 0x0B, 0xC0, 0x37, 0x73, 0x0B, 0xC0,
  0x37, 0x73, 0x0B, 0xC0, 0x37, 0x73, 0x0B, 0xC0, 0x37, 0x73, 0x0B, 0xC0, 0x37, 0x73, 0x0B, 0xC0,
  0x37, 0x73, 0x0B, 0xC0, 0x37, 0x73, 0x0B, 0xC0, 0x37, 0x73, 0x0B, 0xC0, 0x37, 0x73, 0x0B, 0xC0,
  0x37, 0x73, 0x0B, 0xC0, 0x37, 0x73,
  // "¶" (U+00B6)
  0x68, 0x23, 0x8C, 0xEF, 0xE0, 0xA4, 0x01, 0x0A, 0xFF, 0xB0, 0xA3, 0x01, 0x0D, 0xFF, 0xC0, 0xA3,
  0x0C, 0xFC, 0x0A, 0x40, 0xCA, 0x0A, 0x20, 0x7F, 0xD0, 0xA4, 0x0C, 0xA0, 0xA2, 0x0E, 0xFD, 0x0A,
  0x40, 0xCA, 0x81, 0xA0, 0x5F, 0xE0, 0xA4, 0x0C, 0xA8, 0x1A, 0x0A, 0xFE, 0x0A, 0x40, 0xCA, 0x81,
  0xA0, 0xDF, 0xE0, 0xA4, 0x0C, 0xA0, 0xA0, 0x1F, 0xF0, 0xA4, 0x0C, 0xA0, 0xA0, 0x3F, 0xF0, 0xA4,
  0x0C, 0xA0, 0xA0, 0x4F, 0xF0, 0xA4, 0x0C, 0xA0, 0xA0, 0x5F, 0xF0, 0xA4, 0x0C, 0xA0, 0xA0, 0x6F,
  0xF0, 0xA4, 0x0C, 0xA0, 0xA0, 0x6F, 0xF0, 0xA4, 0x0C, 0xA0, 0xA0, 0x6F, 0xF0, 0xA4, 0x0C, 0xA0,
  0xA0, 0x6F, 0xF0, 0xA4, 0x0C, 0xA0, 0xA0, 0x5F, 0xF0, 0xA4, 0x0C, 0xA0, 0xA0, 0x4F, 0xF0, 0xA4,
  0x0C, 0xA0, 0xA0, 0x2F, 0xF0, 0xA4, 0x0C, 0xA0, 0xA1, 0xFF, 0x0A, 0x40, 0xCA, 0x81, 0xA0, 0xDF,
  0xE0, 0xA4, 0x0C, 0xA8, 0x1A, 0x09, 0xFE, 0x0A, 0x40, 0xCA, 0x81, 0xA0, 0x4F, 0xE0, 0xA4, 0x0C,
  0xA0, 0xA2, 0x0D, 0xFD, 0x0A, 0x40, 0xCA, 0x0A, 0x20, 0x6F, 0xD0, 0xA4, 0x0C, 0xA0, 0xA3, 0x0B,
  0xFC, 0x0A, 0x40, 0xCA, 0x0A, 0x30, 0x10, 0xCF, 0xB0, 0xA4, 0x0C, 0xA0, 0xA5, 0x07, 0x0E, 0xF9,
  0x0A, 0x40, 0xCA, 0x0A, 0x78, 0x43, 0x56, 0x52, 0xCA, 0x0A, 0x40, 0xCA, 0x0A, 0x75, 0x0C, 0xA0,
  0xA4, 0x0C, 0xA0, 0xA7, 0x50, 0xCA, 0x0A, 0x40, 0xCA, 0x0A, 0x75, 0x0C, 0xA0, 0xA4, 0x0C, 0xA0,
  0xA7, 0x50, 0xCA, 0x0A, 0x40, 0xCA, 0x0A, 0x75, 0x0C, 0xA0, 0xA4, 0x0C, 0xA0, 0xA7, 0x50, 0xCA,
  0x0A, 0x40, 0xCA, 0x0A, 0x75, 0x0C, 0xA0, 0xA4, 0x0C, 0xA0, 0xA7, 0x50, 0xCA, 0x0A, 0x40, 0xCA,
  0x0A, 0x75, 0x0C, 0xA0, 0xA4, 0x0C, 0xA0, 0xA7, 0x50, 0xCA, 0x0A, 0x40, 0xCA, 0x0A, 0x75, 0x0C,
  0xA0, 0xA4, 0x0C, 0xA0, 0xA7, 0x50, 0xCA, 0x0A, 0x40, 0xCA, 0x0A, 0x75, 0x0C, 0xA0, 0xA4, 0x0C,
  0xA0, 0xA7, 0x50, 0xCA, 0x0A, 0x40, 0xCA, 0x0A, 0x75, 0x0C, 0xA0, 0xA4, 0x0C, 0xA0, 0xA7, 0x50,
  0xCA, 0x0A, 0x40, 0xCA, 0x0A, 0x75, 0x0C, 0xA0, 0xA4, 0x0C, 0xA0, 0xA7, 0x50, 0xCA, 0x0A, 0x40,
  0xCA, 0x0A, 0x75, 0x0C, 0xA0, 0xA4, 0x0C, 0xA0, 0xA7, 0x50, 0xCA, 0x0A, 0x40, 0xCA, 0x0A, 0x75,
  0x0C, 0xA0, 0xA4, 0x0C, 0xA0, 0xA7, 0x50, 0xCA, 0x0A, 0x40, 0xCA, 0x0A, 0x75, 0x0C, 0xA0, 0xA4,
  0x0B, 0xA0, 0xA0,
  // "·" (U+00B7)
  0x28, 0x21, 0x56, 0x33, 0x04, 0x0E, 0xB0, 0x92, 0x0D, 0xD0, 0x30, 0x2E, 0x07, 0x03, 0xE0, 0x80,
  0x2E, 0x81, 0x70, 0xDD, 0x82, 0x30, 0x4E, 0xB0, 0x83, 0x82, 0x16, 0x63, 0x20,
  // "¸" (U+00B8)
  0x48, 0x22, 0x77, 0x57, 0x10, 0x9A, 0x06, 0x70, 0x1A, 0x0E, 0x71, 0x08, 0xA0, 0xA7, 0x10, 0xEB,
  0x0E, 0x08, 0x50, 0x30, 0xCD, 0x0D, 0x02, 0x60, 0x60, 0xDB, 0x0D, 0x70, 0x10, 0xEB, 0x04, 0x70,
  0x9B, 0x07, 0x70, 0xAB, 0x07, 0x60, 0x10, 0xEB, 0x81, 0x51, 0x22, 0x81, 0x15, 0xCB, 0x81, 0xE0,
  0x5F, 0xA8, 0x16, 0x05, 0xF0, 0xE0, 0x62, 0x81, 0x3C, 0xEA, 0x82, 0xEB, 0x71, 0x30,
  // "¹" (U+00B9)
  0x60, 0x10, 0xBB, 0x06, 0x50, 0x20, 0xDC, 0x06, 0x40, 0x50, 0xED, 0x06, 0x30, 0x8F, 0x82, 0x60,
  0x1B, 0xC0, 0xEB, 0x81, 0x62, 0xDC, 0x0A, 0x06, 0xB0, 0x60, 0x5C, 0x81, 0x60, 0x7B, 0x84, 0x60,
  0x9F, 0xD3, 0x20, 0x8B, 0x06, 0x20, 0x84, 0x08, 0xB0, 0x67, 0x08, 0xB0, 0x67, 0x09, 0xB0, 0x67,
  0x09, 0xB0, 0x67, 0x09, 0xB0, 0x67, 0x09, 0xB0, 0x67, 0x09, 0xB0, 0x67, 0x09, 0xB0, 0x67, 0x09,
  0xB0, 0x67, 0x09, 0xB0, 0x67, 0x09, 0xB0, 0x67, 0x09, 0xB0, 0x67, 0x09, 0xB0, 0x67, 0x09, 0xB0,
  0x67, 0x09, 0xB0, 0x67, 0x09, 0xB0, 0x67, 0x09, 0xB0, 0x67, 0x09, 0xB0, 0x60,
  // "º" (U+00BA)
  0x58, 0x64, 0x9D, 0xEE, 0xD9, 0x47, 0x20, 0xAF, 0x90, 0xA7, 0x0C, 0xB8, 0x2D, 0x99, 0xDB, 0x0C,
  0x50, 0x9B, 0x08, 0x40, 0x7B, 0x09, 0x30, 0x1B, 0x0B, 0x60, 0xBB, 0x01, 0x20, 0x7B, 0x04, 0x60,
  0x4B, 0x07, 0x20, 0xBB, 0x71, 0xB0, 0xB2, 0x0E, 0xA0, 0xD7, 0x10, 0xDA, 0x0E, 0x2B, 0x0B, 0x71,
  0x0C, 0xB1, 0x01, 0xB0, 0xB7, 0x10, 0xBB, 0x00, 0x1B, 0x0B, 0x71, 0x0B, 0xB0, 0x11, 0xB0, 0xB7,
  0x10, 0xCB, 0x20, 0xEA, 0x0D, 0x71, 0x0D, 0xA0, 0xE2, 0x0B, 0xB7, 0x1B, 0x0B, 0x20, 0x7B, 0x04,
  0x60, 0x4B, 0x07, 0x20, 0x1B, 0x0A, 0x60, 0xBB, 0x01, 0x30, 0x8B, 0x07, 0x40, 0x7B, 0x08, 0x50,
  0xCB, 0x82, 0xD9, 0x9D, 0xB0, 0xC7, 0x0A, 0xF9, 0x0B, 0x01, 0x71, 0x86, 0x49, 0xDE, 0xED, 0x94,
  0x50,
  // "»" (U+00BB)
  0x28, 0x16, 0xC1, 0x71, 0x81, 0x2A, 0x87, 0x20, 0x40, 0xDA, 0x0C, 0x70, 0x8B, 0x05, 0x71, 0x05,
  0xC0, 0x96, 0x0C, 0xB0, 0xE0, 0x27, 0x10, 0xAC, 0x05, 0x50, 0x2C, 0x0D, 0x71, 0x01, 0x0E, 0xC0,
  0x35, 0x07, 0xC0, 0xA7, 0x10, 0x5C, 0x0D, 0x01, 0x50, 0xCC, 0x07, 0x71, 0x0A, 0xC0, 0xB5, 0x02,
  0xD0, 0x37, 0x01, 0x0E, 0xC0, 0x75, 0x07, 0xC0, 0xE0, 0x17, 0x05, 0xD0, 0x45, 0x0C, 0xC0, 0xC7,
  0x10, 0xAC, 0x0E, 0x01, 0x40, 0x2D, 0x09, 0x70, 0x10, 0xEC, 0x0C, 0x50, 0x7D, 0x05, 0x70, 0x4D,
  0x09, 0x50, 0xCC, 0x0E, 0x02, 0x60, 0x2D, 0x0B, 0x50, 0x9D, 0x04, 0x60, 0xCC, 0x0E, 0x02, 0x40,
  0x4D, 0x09, 0x60, 0x7D, 0x04, 0x50, 0xDC, 0x0C, 0x60, 0x2D, 0x08, 0x50, 0x9C, 0x0E, 0x02, 0x60,
  0xCC, 0x0B, 0x50, 0x4D, 0x04, 0x60, 0x7C, 0x0D, 0x01, 0x40, 0x10, 0xEC, 0x07, 0x60, 0x2D, 0x03,
  0x50, 0xAC, 0x0B, 0x70, 0xCC, 0x06, 0x50, 0x5C, 0x0D, 0x01, 0x60, 0x8C, 0x09, 0x50, 0x10, 0xEC,
  0x03, 0x60, 0x3C, 0x0C, 0x60, 0xAC, 0x05, 0x70, 0x6B, 0x0E, 0x02, 0x50, 0x10, 0xCB, 0x09, 0x72,
  0x82, 0x2A, 0xF4, 0x71, 0x81, 0x5E, 0xC7, 0x50, 0x27, 0x40, 0x17, 0x20,
  // "¼" (U+00BC)
  0x60, 0x5B, 0x0E, 0x77, 0x40, 0x4B, 0x0E, 0x75, 0x09, 0xC0, 0xE7, 0x74, 0x0C, 0xB0, 0x67, 0x30,
  0x20, 0xCD, 0x0E, 0x77, 0x30, 0x5B, 0x0D, 0x73, 0x04, 0x0E, 0xE0, 0xE7, 0x73, 0x0D, 0xB0, 0x57,
  0x20, 0x8C, 0x0C, 0x0E, 0xA0, 0xE7, 0x72, 0x06, 0xB0, 0xC7, 0x20, 0xBC, 0x81, 0xB1, 0xEA, 0x0E,
  0x77, 0x20, 0xEB, 0x03, 0x72, 0x0B, 0xB0, 0x82, 0xB0, 0xE7, 0x71, 0x08, 0xB0, 0xB7, 0x38, 0x21,
  0xDE, 0x42, 0x01, 0xB0, 0xE7, 0x70, 0x10, 0xEB, 0x02, 0x74, 0x03, 0x01, 0x30, 0x1B, 0x0E, 0x77,
  0x09, 0xB0, 0x97, 0x73, 0x01, 0xB0, 0xE7, 0x60, 0x2C, 0x01, 0x77, 0x30, 0x1B, 0x0E, 0x76, 0x0A,
  0xB0, 0x87, 0x74, 0x01, 0xB0, 0xE7, 0x50, 0x3B, 0x0E, 0x01, 0x77, 0x40, 0x1B, 0x0E, 0x75, 0x0B,
  0xB0, 0x77, 0x75, 0x01, 0xB0, 0xE7, 0x40, 0x4B, 0x0D, 0x77, 0x60, 0x1B, 0x0E, 0x74, 0x0C, 0xB0,
  0x57, 0x76, 0x01, 0xB0, 0xE7, 0x30, 0x6B, 0x0C, 0x77, 0x70, 0x1B, 0x0E, 0x73, 0x0D, 0xB0, 0x47,
  0x77, 0x01, 0xB0, 0xE7, 0x20, 0x7B, 0x0B, 0x70, 0x10, 0xEB, 0x04, 0x72, 0x01, 0xB0, 0xE7, 0x10,
  0x10, 0xEB, 0x03, 0x70, 0xAC, 0x04, 0x72, 0x01, 0xB0, 0xE7, 0x10, 0x8B, 0x0A, 0x70, 0x3D, 0x04,
  0x72, 0x01, 0xB0, 0xE7, 0x01, 0xC0, 0x27, 0x0C, 0xD0, 0x47, 0x20, 0x1B, 0x0E, 0x70, 0x9B, 0x09,
  0x70, 0x6E, 0x04, 0x72, 0x01, 0xB0, 0xE6, 0x02, 0xB0, 0xE0, 0x16, 0x01, 0x0E, 0xA0, 0xDB, 0x04,
  0x72, 0x01, 0xB0, 0xE6, 0x0B, 0xB0, 0x77, 0x09, 0xA0, 0xC0, 0xAB, 0x04, 0x72, 0x01, 0xB0, 0xE5,
  0x03, 0xB0, 0xE7, 0x03, 0xB0, 0x40, 0xBB, 0x04, 0x72, 0x01, 0xB0, 0xE5, 0x0C, 0xB0, 0x67, 0x0B,
  0xA8, 0x1B, 0x0B, 0xB0, 0x47, 0x74, 0x05, 0xB0, 0xD7, 0x05, 0xB8, 0x12, 0x0B, 0xB0, 0x47, 0x74,
  0x0D, 0xB0, 0x57, 0x0D, 0xA0, 0x92, 0x0B, 0xB0, 0x47, 0x73, 0x06, 0xB0, 0xC7, 0x08, 0xA0, 0xE0,
  0x12, 0x0B, 0xB0, 0x47, 0x73, 0x0D, 0xB0, 0x46, 0x02, 0xB0, 0x63, 0x0B, 0xB0, 0x47, 0x72, 0x07,
  0xB0, 0xB7, 0x0B, 0xA0, 0xD4, 0x0B, 0xB0, 0x47, 0x71, 0x01, 0x0E, 0xB0, 0x26, 0x04, 0xB0, 0x44,
  0x0B, 0xB0, 0x47, 0x71, 0x08, 0xB0, 0x97, 0x0D, 0xA0, 0xB5, 0x0B, 0xB0, 0x47, 0x70, 0x2C, 0x01,
  0x60, 0x7B, 0x02, 0x50, 0xBB, 0x04, 0x77, 0x0A, 0xB0, 0x87, 0x0E, 0xFF, 0xA0, 0x87, 0x30, 0x3B,
  0x0E, 0x01, 0x7F, 0xFB, 0x08, 0x73, 0x0B, 0xB0, 0x77, 0x1F, 0xFB, 0x08, 0x72, 0x04, 0xB0, 0xD7,
  0x75, 0x0B, 0xB0, 0x47, 0x50, 0xCB, 0x06, 0x77, 0x50, 0xBB, 0x04, 0x74, 0x05, 0xB0, 0xC7, 0x76,
  0x0B, 0xB0, 0x47, 0x40, 0xDB, 0x04, 0x77, 0x60, 0xBB, 0x04, 0x73, 0x06, 0xB0, 0xB7, 0x77, 0x0B,
  0xB0, 0x47, 0x30, 0xEB, 0x03, 0x77, 0x70, 0xBB, 0x04, 0x30,
  // "½" (U+00BD)
  0x70, 0x8B, 0x0B, 0x77, 0x30, 0x6B, 0x0D, 0x76, 0x02, 0x0C, 0xC0, 0xB7, 0x73, 0x0E, 0xB0, 0x57,
  0x50, 0x40, 0xED, 0x0B, 0x77, 0x20, 0x7B, 0x0C, 0x75, 0x08, 0xF0, 0xB7, 0x71, 0x01, 0x0E, 0xB0,
  0x47, 0x30, 0x10, 0xCC, 0x09, 0xB0, 0xB7, 0x71, 0x09, 0xB0, 0xB7, 0x30, 0x20, 0xEC, 0x06, 0x02,
  0xB0, 0xB7, 0x70, 0x2C, 0x02, 0x74, 0x0B, 0xA8, 0x2D, 0x30, 0x3B, 0x0B, 0x77, 0x0A, 0xB0, 0x97,
  0x58, 0x11, 0xD9, 0x30, 0x4B, 0x0B, 0x76, 0x03, 0xC0, 0x17, 0x74, 0x04, 0xB0, 0xB7, 0x60, 0xBB,
  0x08, 0x77, 0x50, 0x4B, 0x0B, 0x75, 0x04, 0xB0, 0xE0, 0x17, 0x75, 0x04, 0xB0, 0xB7, 0x50, 0xCB,
  0x07, 0x77, 0x60, 0x4B, 0x0B, 0x74, 0x05, 0xB0, 0xD7, 0x77, 0x04, 0xB0, 0xB7, 0x40, 0xDB, 0x06,
  0x77, 0x70, 0x4B, 0x0B, 0x73, 0x06, 0xB0, 0xC7, 0x77, 0x10, 0x4B, 0x0B, 0x73, 0x0E, 0xB0, 0x47,
  0x77, 0x10, 0x4B, 0x0B, 0x72, 0x07, 0xB0, 0xB7, 0x77, 0x20, 0x4B, 0x0B, 0x71, 0x01, 0x0E, 0xB0,
  0x34, 0x86, 0x6B, 0xEF, 0xEC, 0x92, 0x74, 0x04, 0xB0, 0xB7, 0x10, 0x9B, 0x0A, 0x30, 0x40, 0xEF,
  0x90, 0x97, 0x30, 0x4B, 0x0B, 0x70, 0x2C, 0x02, 0x20, 0x8F, 0xC0, 0xA7, 0x20, 0x4B, 0x0B, 0x70,
  0xAB, 0x09, 0x20, 0x7F, 0xE0, 0x57, 0x10, 0x4B, 0x0B, 0x60, 0x3B, 0x0E, 0x01, 0x20, 0x5B, 0x84,
  0xC5, 0x10, 0x29, 0xC0, 0xC7, 0x10, 0x4B, 0x0B, 0x60, 0xBB, 0x07, 0x48, 0x19, 0xF8, 0x60, 0x8C,
  0x71, 0x04, 0xB0, 0xB5, 0x04, 0xB0, 0xE6, 0x06, 0x70, 0x1C, 0x02, 0x70, 0x4B, 0x0B, 0x50, 0xCB,
  0x06, 0x77, 0x10, 0xEB, 0x02, 0x70, 0x4B, 0x0B, 0x40, 0x5B, 0x0D, 0x77, 0x2C, 0x71, 0x04, 0xB0,
  0xB4, 0x0D, 0xB0, 0x57, 0x71, 0x02, 0xB0, 0xD7, 0x72, 0x06, 0xB0, 0xC7, 0x72, 0x07, 0xB0, 0x87,
  0x72, 0x0E, 0xB0, 0x47, 0x72, 0x0D, 0xB0, 0x27, 0x71, 0x07, 0xB0, 0xB7, 0x72, 0x08, 0xB0, 0x97,
  0x71, 0x01, 0x0E, 0xB0, 0x27, 0x71, 0x04, 0xB0, 0xD0, 0x17, 0x71, 0x09, 0xB0, 0x97, 0x71, 0x02,
  0x0E, 0xB0, 0x37, 0x71, 0x02, 0xC0, 0x17, 0x70, 0x10, 0xDB, 0x06, 0x77, 0x20, 0xAB, 0x08, 0x77,
  0x10, 0xCB, 0x08, 0x77, 0x20, 0x3B, 0x0E, 0x01, 0x77, 0x0B, 0xB0, 0xA7, 0x73, 0x0B, 0xB0, 0x77,
  0x70, 0x9B, 0x0B, 0x77, 0x30, 0x4B, 0x0D, 0x77, 0x08, 0xB0, 0xC0, 0x17, 0x73, 0x0C, 0xB0, 0x67,
  0x60, 0x6B, 0x0D, 0x01, 0x77, 0x30, 0x5B, 0x0D, 0x76, 0x05, 0xB0, 0xE0, 0x27, 0x74, 0x0D, 0xB0,
  0x47, 0x50, 0x3B, 0x0E, 0x03, 0x77, 0x40, 0x6B, 0x0B, 0x76, 0x0D, 0xFF, 0x07, 0x71, 0x0E, 0xB0,
  0x37, 0x60, 0xDF, 0xF0, 0x77, 0x07, 0xB0, 0xA7, 0x70, 0xDF, 0xF0, 0x76, 0x01, 0x0E, 0xB0, 0x27,
  0x70, 0xDF, 0xF0, 0x70,
  // "¾" (U+00BE)
  0x48, 0x65, 0xAD, 0xEE, 0xDA, 0x47, 0x76, 0x83, 0x34, 0x44, 0x27, 0x10, 0x50, 0xDF, 0x90, 0xC0,
  0x17, 0x73, 0x02, 0xC0, 0x27, 0x09, 0xFC, 0x0D, 0x01, 0x77, 0x20, 0xAB, 0x09, 0x70, 0x7F, 0xE0,
  0x97, 0x71, 0x03, 0xB0, 0xE0, 0x17, 0x10, 0xDA, 0x85, 0xC6, 0x10, 0x26, 0xEC, 0x01, 0x77, 0x0B,
  0xB0, 0x87, 0x28, 0x14, 0xF6, 0x60, 0x2C, 0x04, 0x76, 0x04, 0xB0, 0xE7, 0x40, 0x17, 0x10, 0xAB,
  0x06, 0x76, 0x0C, 0xB0, 0x67, 0x76, 0x08, 0xB0, 0x67, 0x50, 0x5B, 0x0D, 0x77, 0x70, 0x9B, 0x04,
  0x75, 0x0D, 0xB0, 0x57, 0x77, 0x0D, 0xA0, 0xE7, 0x50, 0x6B, 0x0C, 0x77, 0x70, 0x8B, 0x07, 0x75,
  0x0E, 0xB0, 0x47, 0x74, 0x81, 0x14, 0xAB, 0x0A, 0x75, 0x07, 0xB0, 0xB7, 0x72, 0x0E, 0xF0, 0x87,
  0x50, 0x10, 0xEB, 0x03, 0x77, 0x20, 0xEE, 0x0A, 0x02, 0x75, 0x08, 0xB0, 0xA7, 0x73, 0x0E, 0xF9,
  0x09, 0x73, 0x02, 0xC0, 0x27, 0x77, 0x81, 0x26, 0xDB, 0x0C, 0x72, 0x0A, 0xB0, 0x97, 0x77, 0x40,
  0xBB, 0x07, 0x70, 0x2C, 0x01, 0x77, 0x74, 0x02, 0xB0, 0xE7, 0x0B, 0xB0, 0x87, 0x77, 0x60, 0xEB,
  0x01, 0x50, 0x3B, 0x0E, 0x01, 0x70, 0xCB, 0x07, 0x77, 0x10, 0xDB, 0x03, 0x50, 0xCB, 0x07, 0x70,
  0x6C, 0x07, 0x77, 0x01, 0xC0, 0x24, 0x05, 0xB0, 0xD7, 0x01, 0x0E, 0xC0, 0x73, 0x04, 0x03, 0x72,
  0x09, 0xB0, 0xE5, 0x0D, 0xB0, 0x67, 0x08, 0xD0, 0x73, 0x84, 0x8F, 0xC7, 0x41, 0x28, 0x11, 0x4B,
  0xC0, 0xA4, 0x06, 0xB0, 0xD7, 0x02, 0xA0, 0xEB, 0x07, 0x30, 0x8F, 0xF0, 0x24, 0x0D, 0xB0, 0x57,
  0x0B, 0xA0, 0x9B, 0x07, 0x30, 0x8F, 0xE0, 0x44, 0x07, 0xB0, 0xC7, 0x05, 0xA0, 0xA0, 0x6B, 0x07,
  0x30, 0x30, 0xCF, 0xB0, 0xC0, 0x34, 0x01, 0x0E, 0xB0, 0x47, 0x0D, 0xA0, 0x20, 0x6B, 0x07, 0x58,
  0x23, 0x8B, 0xDA, 0x82, 0xEC, 0x94, 0x60, 0x8B, 0x0B, 0x70, 0x7A, 0x81, 0xA0, 0x6B, 0x07, 0x77,
  0x60, 0x1C, 0x03, 0x60, 0x2B, 0x81, 0x20, 0x7B, 0x07, 0x77, 0x60, 0x9B, 0x0A, 0x70, 0xAA, 0x08,
  0x20, 0x7B, 0x07, 0x77, 0x50, 0x2C, 0x02, 0x60, 0x4A, 0x0E, 0x01, 0x20, 0x7B, 0x07, 0x77, 0x50,
  0xAB, 0x09, 0x70, 0xDA, 0x07, 0x30, 0x7B, 0x07, 0x77, 0x40, 0x3B, 0x0E, 0x01, 0x60, 0x7A, 0x0E,
  0x40, 0x7B, 0x07, 0x77, 0x40, 0xBB, 0x07, 0x60, 0x10, 0xEA, 0x06, 0x40, 0x7B, 0x07, 0x77, 0x30,
  0x4B, 0x0E, 0x70, 0x9A, 0x0D, 0x50, 0x7B, 0x07, 0x77, 0x30, 0xCB, 0x06, 0x60, 0x3B, 0x05, 0x50,
  0x7B, 0x07, 0x77, 0x20, 0x5B, 0x0D, 0x70, 0xBF, 0xFA, 0x0B, 0x76, 0x0D, 0xB0, 0x57, 0x0C, 0xFF,
  0xA0, 0xB7, 0x50, 0x6B, 0x0C, 0x71, 0x0C, 0xFF, 0xA0, 0xB7, 0x50, 0xEB, 0x04, 0x77, 0x40, 0x7B,
  0x07, 0x77, 0x07, 0xB0, 0xB7, 0x75, 0x07, 0xB0, 0x77, 0x60, 0x10, 0xEB, 0x03, 0x77, 0x50, 0x7B,
  0x07, 0x76, 0x09, 0xB0, 0xA7, 0x76, 0x07, 0xB0, 0x77, 0x50, 0x2C, 0x02, 0x77, 0x60, 0x7B, 0x07,
  0x75, 0x0A, 0xB0, 0x97, 0x77, 0x07, 0xB0, 0x73,
  // "¿" (U+00BF)
  0x72, 0x82, 0x15, 0x63, 0x77, 0x10, 0x30, 0xEB, 0x09, 0x77, 0x0C, 0xD0, 0x47, 0x6E, 0x07, 0x75,
  0x01, 0xE0, 0x97, 0x6E, 0x07, 0x76, 0x0C, 0xD0, 0x47, 0x60, 0x30, 0xEB, 0x09, 0x77, 0x18, 0x21,
  0x56, 0x38, 0x09, 0xB4, 0x08, 0x36, 0x99, 0x93, 0x77, 0x10, 0x9B, 0x05, 0x77, 0x10, 0xAB, 0x04,
  0x77, 0x10, 0xCB, 0x03, 0x77, 0x10, 0xEB, 0x02, 0x77, 0x05, 0xC7, 0x71, 0x0C, 0xB0, 0xC7, 0x70,
  0x7C, 0x07, 0x76, 0x04, 0xC0, 0xE0, 0x17, 0x50, 0x20, 0xEC, 0x07, 0x75, 0x01, 0x0D, 0xC0, 0xC7,
  0x60, 0xBC, 0x0E, 0x01, 0x75, 0x08, 0xC0, 0xE0, 0x37, 0x50, 0x4D, 0x05, 0x76, 0x0D, 0xC0, 0x87,
  0x60, 0x7C, 0x0C, 0x77, 0x0D, 0xC0, 0x47, 0x60, 0x4C, 0x0D, 0x77, 0x07, 0xC0, 0x77, 0x70, 0xAC,
  0x04, 0x77, 0x0B, 0xC0, 0x37, 0x70, 0xCC, 0x02, 0x77, 0x0B, 0xC0, 0x37, 0x70, 0xAC, 0x06, 0x77,
  0x07, 0xC0, 0xB7, 0x40, 0x12, 0x03, 0xD0, 0x67, 0x18, 0x12, 0xBC, 0x30, 0xCD, 0x08, 0x01, 0x40,
  0x50, 0xAB, 0x03, 0x20, 0x4F, 0x81, 0xED, 0xEE, 0x0A, 0x30, 0x8F, 0xFA, 0x01, 0x30, 0x7F, 0xE0,
  0xC0, 0x35, 0x02, 0x0A, 0xF9, 0x81, 0xE9, 0x37, 0x38, 0x53, 0x57, 0x76, 0x52, 0x60,
  // "À" (U+00C0)
  0x60, 0x48, 0x01, 0x70, 0x37, 0x77, 0x30, 0x4D, 0x0D, 0x77, 0x74, 0x09, 0xD0, 0x57, 0x77, 0x40,
  0xBC, 0x0D, 0x77, 0x74, 0x01, 0x0D, 0xC0, 0x87, 0x77, 0x40, 0x10, 0xDC, 0x03, 0x77, 0x74, 0x02,
  0x0E, 0xB0, 0xC7, 0x77, 0x50, 0x20, 0xEB, 0x07, 0x77, 0x75, 0x02, 0x0D, 0xB0, 0x37, 0x77, 0x50,
  0x20, 0xDA, 0x0B, 0x80, 0xAA, 0x10, 0x0D, 0xD0, 0x27, 0x77, 0x20, 0x2E, 0x06, 0x77, 0x72, 0x06,
  0xE0, 0xB7, 0x77, 0x20, 0xAF, 0x77, 0x72, 0x0E, 0xF0, 0x47, 0x77, 0x04, 0xC0, 0xCB, 0x09, 0x77,
  0x70, 0x8B, 0x0C, 0x09, 0xB0, 0xD7, 0x77, 0x0D, 0xB0, 0x80, 0x6C, 0x02, 0x77, 0x50, 0x2C, 0x05,
  0x02, 0xC0, 0x67, 0x75, 0x06, 0xC8, 0x12, 0x0E, 0xB0, 0xB7, 0x75, 0x0B, 0xB0, 0xE2, 0x0B, 0xC7,
  0x75, 0x0E, 0xB0, 0xB2, 0x07, 0xC0, 0x47, 0x73, 0x04, 0xC0, 0x72, 0x03, 0xC0, 0x97, 0x73, 0x08,
  0xC0, 0x33, 0x0E, 0xB0, 0xD7, 0x73, 0x0D, 0xB0, 0xE4, 0x0A, 0xC0, 0x27, 0x71, 0x02, 0xC0, 0xA4,
  0x06, 0xC0, 0x77, 0x71, 0x06, 0xC0, 0x64, 0x02, 0xC0, 0xB7, 0x71, 0x0B, 0xC0, 0x25, 0x0D, 0xC7,
  0x71, 0x0E, 0xB0, 0xD6, 0x09, 0xC0, 0x47, 0x60, 0x4C, 0x09, 0x60, 0x5C, 0x09, 0x76, 0x08, 0xC0,
  0x56, 0x01, 0xC0, 0xD7, 0x60, 0xDC, 0x01, 0x70, 0xDC, 0x02, 0x74, 0x02, 0xC0, 0xD7, 0x10, 0x8C,
  0x07, 0x74, 0x06, 0xC0, 0x97, 0x10, 0x4C, 0x0B, 0x74, 0x0B, 0xC0, 0x57, 0x2D, 0x74, 0x0E, 0xFF,
  0xD0, 0x57, 0x20, 0x4F, 0xFE, 0x09, 0x72, 0x08, 0xFF, 0xE0, 0xD7, 0x20, 0xDF, 0xFF, 0x02, 0x70,
  0x2D, 0x80, 0x90, 0x50, 0xCC, 0x07, 0x70, 0x6C, 0x0C, 0x75, 0x07, 0xC0, 0xB7, 0x0B, 0xC0, 0x87,
  0x50, 0x2D, 0x01, 0x60, 0xEC, 0x04, 0x76, 0x0D, 0xC0, 0x55, 0x04, 0xC0, 0xE7, 0x70, 0x9C, 0x09,
  0x50, 0x8C, 0x0B, 0x77, 0x05, 0xC0, 0xE5, 0x0D, 0xC0, 0x67, 0x70, 0x1D, 0x03, 0x30, 0x2D, 0x02,
  0x77, 0x10, 0xCC, 0x07, 0x30, 0x6C, 0x0D, 0x77, 0x20, 0x8C, 0x0C, 0x30, 0xBC, 0x09, 0x77, 0x20,
  0x4D, 0x01, 0x20, 0xEC, 0x05, 0x77, 0x3D, 0x81, 0x50, 0x4D, 0x01, 0x77, 0x30, 0xBC, 0x81, 0x90,
  0x8C, 0x0C, 0x77, 0x40, 0x7C, 0x81, 0xE0, 0xDC, 0x08, 0x77, 0x40, 0x2D, 0x03,
  // "Á" (U+00C1)
  0x77, 0x40, 0x28, 0x01, 0x70, 0x67, 0x77, 0x30, 0xAD, 0x07, 0x77, 0x72, 0x03, 0xD0, 0xC7, 0x77,
  0x30, 0xCC, 0x0E, 0x01, 0x77, 0x72, 0x06, 0xC0, 0xE0, 0x37, 0x77, 0x20, 0x10, 0xEC, 0x04, 0x77,
  0x73, 0x0A, 0xC0, 0x57, 0x77, 0x30, 0x5C, 0x05, 0x77, 0x73, 0x01, 0x0E, 0xB0, 0x57, 0x77, 0x40,
  0x8A, 0x0E, 0x04, 0x80, 0xAA, 0x10, 0x0D, 0xD0, 0x27, 0x77, 0x20, 0x2E, 0x06, 0x77, 0x72, 0x06,
  0xE0, 0xB7, 0x77, 0x20, 0xAF, 0x77, 0x72, 0x0E, 0xF0, 0x47, 0x77, 0x04, 0xC0, 0xCB, 0x09, 0x77,
  0x70, 0x8B, 0x0C, 0x09, 0xB0, 0xD7, 0x77, 0x0D, 0xB0, 0x80, 0x6C, 0x02, 0x77, 0x50, 0x2C, 0x05,
  0x02, 0xC0, 0x67, 0x75, 0x06, 0xC8, 0x12, 0x0E, 0xB0, 0xB7, 0x75, 0x0B, 0xB0, 0xE2, 0x0B, 0xC7,
  0x75, 0x0E, 0xB0, 0xB2, 0x07, 0xC0, 0x47, 0x73, 0x04, 0xC0, 0x72, 0x03, 0xC0, 0x97, 0x73, 0x08,
  0xC0, 0x33, 0x0E, 0xB0, 0xD7, 0x73, 0x0D, 0xB0, 0xE4, 0x0A, 0xC0, 0x27, 0x71, 0x02, 0xC0, 0xA4,
  0x06, 0xC0, 0x77, 0x71, 0x06, 0xC0, 0x64, 0x02, 0xC0, 0xB7, 0x71, 0x0B, 0xC0, 0x25, 0x0D, 0xC7,
  0x71, 0x0E, 0xB0, 0xD6, 0x09, 0xC0, 0x47, 0x60, 0x4C, 0x09, 0x60, 0x5C, 0x09, 0x76, 0x08, 0xC0,
  0x56, 0x01, 0xC0, 0xD7, 0x60, 0xDC, 0x01, 0x70, 0xDC, 0x02, 0x74, 0x02, 0xC0, 0xD7, 0x10, 0x8C,
  0x07, 0x74, 0x06, 0xC0, 0x97, 0x10, 0x4C, 0x0B, 0x74, 0x0B, 0xC0, 0x57, 0x2D, 0x74, 0x0E, 0xFF,
  0xD0, 0x57, 0x20, 0x4F, 0xFE, 0x09, 0x72, 0x08, 0xFF, 0xE0, 0xD7, 0x20, 0xDF, 0xFF, 0x02, 0x70,
  0x2D, 0x80, 0x90, 0x50, 0xCC, 0x07, 0x70, 0x6C, 0x0C, 0x75, 0x07, 0xC0, 0xB7, 0x0B, 0xC0, 0x87,
  0x50, 0x2D, 0x01, 0x60, 0xEC, 0x04, 0x76, 0x0D, 0xC0, 0x55, 0x04, 0xC0, 0xE7, 0x70, 0x9C, 0x09,
  0x50, 0x8C, 0x0B, 0x77, 0x05, 0xC0, 0xE5, 0x0D, 0xC0, 0x67, 0x70, 0x1D, 0x03, 0x30, 0x2D, 0x02,
  0x77, 0x10, 0xCC, 0x07, 0x30, 0x6C, 0x0D, 0x77, 0x20, 0x8C, 0x0C, 0x30, 0xBC, 0x09, 0x77, 0x20,
  0x4D, 0x01, 0x20, 0xEC, 0x05, 0x77, 0x3D, 0x81, 0x50, 0x4D, 0x01, 0x77, 0x30, 0xBC, 0x81, 0x90,
  0x8C, 0x0C, 0x77, 0x40, 0x7C, 0x81, 0xE0, 0xDC, 0x08, 0x77, 0x40, 0x2D, 0x03,
  // "Â" (U+00C2)
  0x75, 0x84, 0x57, 0x77, 0x73, 0x77, 0x73, 0x01, 0xD0, 0xD7, 0x77, 0x30, 0xAE, 0x06, 0x77, 0x71,
  0x04, 0xF0, 0xE0, 0x27, 0x76, 0x01, 0x0D, 0xB0, 0xC0, 0xEB, 0x0B, 0x77, 0x60, 0xAB, 0x82, 0xD1,
  0x2E, 0xB0, 0x77, 0x74, 0x05, 0xB0, 0xD0, 0x12, 0x03, 0x0E, 0xB0, 0x37, 0x72, 0x02, 0x0E, 0xA0,
  0xD0, 0x14, 0x04, 0xB0, 0xD0, 0x17, 0x71, 0x0D, 0xA0, 0xD0, 0x26, 0x04, 0x0E, 0xA0, 0xB7, 0x70,
  0x8A, 0x0D, 0x01, 0x71, 0x03, 0x0D, 0xA0, 0x68, 0x0A, 0x93, 0x00, 0xDD, 0x02, 0x77, 0x72, 0x02,
  0xE0, 0x67, 0x77, 0x20, 0x6E, 0x0B, 0x77, 0x72, 0x0A, 0xF7, 0x77, 0x20, 0xEF, 0x04, 0x77, 0x70,
  0x4C, 0x0C, 0xB0, 0x97, 0x77, 0x08, 0xB0, 0xC0, 0x9B, 0x0D, 0x77, 0x70, 0xDB, 0x08, 0x06, 0xC0,
  0x27, 0x75, 0x02, 0xC0, 0x50, 0x2C, 0x06, 0x77, 0x50, 0x6C, 0x81, 0x20, 0xEB, 0x0B, 0x77, 0x50,
  0xBB, 0x0E, 0x20, 0xBC, 0x77, 0x50, 0xEB, 0x0B, 0x20, 0x7C, 0x04, 0x77, 0x30, 0x4C, 0x07, 0x20,
  0x3C, 0x09, 0x77, 0x30, 0x8C, 0x03, 0x30, 0xEB, 0x0D, 0x77, 0x30, 0xDB, 0x0E, 0x40, 0xAC, 0x02,
  0x77, 0x10, 0x2C, 0x0A, 0x40, 0x6C, 0x07, 0x77, 0x10, 0x6C, 0x06, 0x40, 0x2C, 0x0B, 0x77, 0x10,
  0xBC, 0x02, 0x50, 0xDC, 0x77, 0x10, 0xEB, 0x0D, 0x60, 0x9C, 0x04, 0x76, 0x04, 0xC0, 0x96, 0x05,
  0xC0, 0x97, 0x60, 0x8C, 0x05, 0x60, 0x1C, 0x0D, 0x76, 0x0D, 0xC0, 0x17, 0x0D, 0xC0, 0x27, 0x40,
  0x2C, 0x0D, 0x71, 0x08, 0xC0, 0x77, 0x40, 0x6C, 0x09, 0x71, 0x04, 0xC0, 0xB7, 0x40, 0xBC, 0x05,
  0x72, 0xD7, 0x40, 0xEF, 0xFD, 0x05, 0x72, 0x04, 0xFF, 0xE0, 0x97, 0x20, 0x8F, 0xFE, 0x0D, 0x72,
  0x0D, 0xFF, 0xF0, 0x27, 0x02, 0xD8, 0x09, 0x05, 0x0C, 0xC0, 0x77, 0x06, 0xC0, 0xC7, 0x50, 0x7C,
  0x0B, 0x70, 0xBC, 0x08, 0x75, 0x02, 0xD0, 0x16, 0x0E, 0xC0, 0x47, 0x60, 0xDC, 0x05, 0x50, 0x4C,
  0x0E, 0x77, 0x09, 0xC0, 0x95, 0x08, 0xC0, 0xB7, 0x70, 0x5C, 0x0E, 0x50, 0xDC, 0x06, 0x77, 0x01,
  0xD0, 0x33, 0x02, 0xD0, 0x27, 0x71, 0x0C, 0xC0, 0x73, 0x06, 0xC0, 0xD7, 0x72, 0x08, 0xC0, 0xC3,
  0x0B, 0xC0, 0x97, 0x72, 0x04, 0xD0, 0x12, 0x0E, 0xC0, 0x57, 0x73, 0xD8, 0x15, 0x04, 0xD0, 0x17,
  0x73, 0x0B, 0xC8, 0x19, 0x08, 0xC0, 0xC7, 0x74, 0x07, 0xC8, 0x1E, 0x0D, 0xC0, 0x87, 0x74, 0x02,
  0xD0, 0x30,
  // "Ã" (U+00C3)
  0x71, 0x84, 0x5C, 0xEE, 0xB6, 0x70, 0xBA, 0x05, 0x76, 0x08, 0xE0, 0xE0, 0x74, 0x03, 0xB0, 0x37,
  0x50, 0x3F, 0xA8, 0x3E, 0x96, 0x6E, 0xA0, 0xE7, 0x60, 0xAF, 0xFA, 0x09, 0x75, 0x01, 0xB8, 0x2D,
  0x66, 0xAF, 0xB0, 0x27, 0x50, 0x4A, 0x0E, 0x01, 0x30, 0x10, 0x9F, 0x06, 0x76, 0x07, 0xA0, 0x96,
  0x85, 0x17, 0xCE, 0xEB, 0x48, 0x0A, 0x95, 0x00, 0xDD, 0x02, 0x77, 0x72, 0x02, 0xE0, 0x67, 0x77,
  0x20, 0x6E, 0x0B, 0x77, 0x72, 0x0A, 0xF7, 0x77, 0x20, 0xEF, 0x04, 0x77, 0x70, 0x4C, 0x0C, 0xB0,
  0x97, 0x77, 0x08, 0xB0, 0xC0, 0x9B, 0x0D, 0x77, 0x70, 0xDB, 0x08, 0x06, 0xC0, 0x27, 0x75, 0x02,
  0xC0, 0x50, 0x2C, 0x06, 0x77, 0x50, 0x6C, 0x81, 0x20, 0xEB, 0x0B, 0x77, 0x50, 0xBB, 0x0E, 0x20,
  0xBC, 0x77, 0x50, 0xEB, 0x0B, 0x20, 0x7C, 0x04, 0x77, 0x30, 0x4C, 0x07, 0x20, 0x3C, 0x09, 0x77,
  0x30, 0x8C, 0x03, 0x30, 0xEB, 0x0D, 0x77, 0x30, 0xDB, 0x0E, 0x40, 0xAC, 0x02, 0x77, 0x10, 0x2C,
  0x0A, 0x40, 0x6C, 0x07, 0x77, 0x10, 0x6C, 0x06, 0x40, 0x2C, 0x0B, 0x77, 0x10, 0xBC, 0x02, 0x50,
  0xDC, 0x77, 0x10, 0xEB, 0x0D, 0x60, 0x9C, 0x04, 0x76, 0x04, 0xC0, 0x96, 0x05, 0xC0, 0x97, 0x60,
  0x8C, 0x05, 0x60, 0x1C, 0x0D, 0x76, 0x0D, 0xC0, 0x17, 0x0D, 0xC0, 0x27, 0x40, 0x2C, 0x0D, 0x71,
  0x08, 0xC0, 0x77, 0x40, 0x6C, 0x09, 0x71, 0x04, 0xC0, 0xB7, 0x40, 0xBC, 0x05, 0x72, 0xD7, 0x40,
  0xEF, 0xFD, 0x05, 0x72, 0x04, 0xFF, 0xE0, 0x97, 0x20, 0x8F, 0xFE, 0x0D, 0x72, 0x0D, 0xFF, 0xF0,
  0x27, 0x02, 0xD8, 0x09, 0x05, 0x0C, 0xC0, 0x77, 0x06, 0xC0, 0xC7, 0x50, 0x7C, 0x0B, 0x70, 0xBC,
  0x08, 0x75, 0x02, 0xD0, 0x16, 0x0E, 0xC0, 0x47, 0x60, 0xDC, 0x05, 0x50, 0x4C, 0x0E, 0x77, 0x09,
  0xC0, 0x95, 0x08, 0xC0, 0xB7, 0x70, 0x5C, 0x0E, 0x50, 0xDC, 0x06, 0x77, 0x01, 0xD0, 0x33, 0x02,
  0xD0, 0x27, 0x71, 0x0C, 0xC0, 0x73, 0x06, 0xC0, 0xD7, 0x72, 0x08, 0xC0, 0xC3, 0x0B, 0xC0, 0x97,
  0x72, 0x04, 0xD0, 0x12, 0x0E, 0xC0, 0x57, 0x73, 0xD8, 0x15, 0x04, 0xD0, 0x17, 0x73, 0x0B, 0xC8,
  0x19, 0x08, 0xC0, 0xC7, 0x74, 0x07, 0xC8, 0x1E, 0x0D, 0xC0, 0x87, 0x74, 0x02, 0xD0, 0x30,
  // "Ä" (U+00C4)
  0x71, 0x82, 0x7D, 0xE8, 0x68, 0x34, 0xDE, 0xA1, 0x77, 0x10, 0x3C, 0x06, 0x40, 0x10, 0xEB, 0x09,
  0x77, 0x10, 0x7C, 0x09, 0x40, 0x4C, 0x0D, 0x77, 0x10, 0x7C, 0x09, 0x40, 0x4C, 0x0D, 0x77, 0x10,
  0x3C, 0x05, 0x40, 0x10, 0xEB, 0x09, 0x77, 0x28, 0x26, 0xDE, 0x86, 0x82, 0x4D, 0xEA, 0x80, 0xA9,
  0x50, 0x0D, 0xD0, 0x27, 0x77, 0x20, 0x2E, 0x06, 0x77, 0x72, 0x06, 0xE0, 0xB7, 0x77, 0x20, 0xAF,
  0x77, 0x72, 0x0E, 0xF0, 0x47, 0x77, 0x04, 0xC0, 0xCB, 0x09, 0x77, 0x70, 0x8B, 0x0C, 0x09, 0xB0,
  0xD7, 0x77, 0x0D, 0xB0, 0x80, 0x6C, 0x02, 0x77, 0x50, 0x2C, 0x05, 0x02, 0xC0, 0x67, 0x75, 0x06,
  0xC8, 0x12, 0x0E, 0xB0, 0xB7, 0x75, 0x0B, 0xB0, 0xE2, 0x0B, 0xC7, 0x75, 0x0E, 0xB0, 0xB2, 0x07,
  0xC0, 0x47, 0x73, 0x04, 0xC0, 0x72, 0x03, 0xC0, 0x97, 0x73, 0x08, 0xC0, 0x33, 0x0E, 0xB0, 0xD7,
  0x73, 0x0D, 0xB0, 0xE4, 0x0A, 0xC0, 0x27, 0x71, 0x02, 0xC0, 0xA4, 0x06, 0xC0, 0x77, 0x71, 0x06,
  0xC0, 0x64, 0x02, 0xC0, 0xB7, 0x71, 0x0B, 0xC0, 0x25, 0x0D, 0xC7, 0x71, 0x0E, 0xB0, 0xD6, 0x09,
  0xC0, 0x47, 0x60, 0x4C, 0x09, 0x60, 0x5C, 0x09, 0x76, 0x08, 0xC0, 0x56, 0x01, 0xC0, 0xD7, 0x60,
  0xDC, 0x01, 0x70, 0xDC, 0x02, 0x74, 0x02, 0xC0, 0xD7, 0x10, 0x8C, 0x07, 0x74, 0x06, 0xC0, 0x97,
  0x10, 0x4C, 0x0B, 0x74, 0x0B, 0xC0, 0x57, 0x2D, 0x74, 0x0E, 0xFF, 0xD0, 0x57, 0x20, 0x4F, 0xFE,
  0x09, 0x72, 0x08, 0xFF, 0xE0, 0xD7, 0x20, 0xDF, 0xFF, 0x02, 0x70, 0x2D, 0x80, 0x90, 0x50, 0xCC,
  0x07, 0x70, 0x6C, 0x0C, 0x75, 0x07, 0xC0, 0xB7, 0x0B, 0xC0, 0x87, 0x50, 0x2D, 0x01, 0x60, 0xEC,
  0x04, 0x76, 0x0D, 0xC0, 0x55, 0x04, 0xC0, 0xE7, 0x70, 0x9C, 0x09, 0x50, 0x8C, 0x0B, 0x77, 0x05,
  0xC0, 0xE5, 0x0D, 0xC0, 0x67, 0x70, 0x1D, 0x03, 0x30, 0x2D, 0x02, 0x77, 0x10, 0xCC, 0x07, 0x30,
  0x6C, 0x0D, 0x77, 0x20, 0x8C, 0x0C, 0x30, 0xBC, 0x09, 0x77, 0x20, 0x4D, 0x01, 0x20, 0xEC, 0x05,
  0x77, 0x3D, 0x81, 0x50, 0x4D, 0x01, 0x77, 0x30, 0xBC, 0x81, 0x90, 0x8C, 0x0C, 0x77, 0x40, 0x7C,
  0x81, 0xE0, 0xDC, 0x08, 0x77, 0x40, 0x2D, 0x03,
  // "Å" (U+00C5)
  0x74, 0x86, 0x4A, 0xDF, 0xEC, 0x71, 0x77, 0x71, 0x09, 0xF0, 0xE0, 0x47, 0x76, 0x08, 0xC0, 0xEC,
  0x0E, 0x02, 0x77, 0x40, 0x1B, 0x0B, 0x02, 0x20, 0x50, 0xEA, 0x0B, 0x77, 0x40, 0x6A, 0x0D, 0x50,
  0x5B, 0x77, 0x40, 0x8A, 0x09, 0x6B, 0x02, 0x77, 0x30, 0x8A, 0x09, 0x6B, 0x02, 0x77, 0x30, 0x6A,
  0x0D, 0x50, 0x5A, 0x0E, 0x77, 0x40, 0x2B, 0x84, 0xB2, 0x01, 0x6E, 0xA0, 0xA7, 0x75, 0x08, 0xFA,
  0x0E, 0x02, 0x77, 0x60, 0xAF, 0x90, 0x47, 0x77, 0x10, 0x6E, 0x08, 0x77, 0x72, 0x06, 0xE0, 0xB7,
  0x77, 0x20, 0xAF, 0x77, 0x72, 0x0E, 0xF0, 0x47, 0x77, 0x04, 0xC0, 0xCB, 0x09, 0x77, 0x70, 0x8B,
  0x0C, 0x09, 0xB0, 0xD7, 0x77, 0x0D, 0xB0, 0x80, 0x6C, 0x02, 0x77, 0x50, 0x2C, 0x05, 0x02, 0xC0,
  0x67, 0x75, 0x06, 0xC8, 0x12, 0x0E, 0xB0, 0xB7, 0x75, 0x0B, 0xB0, 0xE2, 0x0B, 0xC7, 0x75, 0x0E,
  0xB0, 0xB2, 0x07, 0xC0, 0x47, 0x73, 0x04, 0xC0, 0x72, 0x03, 0xC0, 0x97, 0x73, 0x08, 0xC0, 0x33,
  0x0E, 0xB0, 0xD7, 0x73, 0x0D, 0xB0, 0xE4, 0x0A, 0xC0, 0x27, 0x71, 0x02, 0xC0, 0xA4, 0x06, 0xC0,
  0x77, 0x71, 0x06, 0xC0, 0x64, 0x02, 0xC0, 0xB7, 0x71, 0x0B, 0xC0, 0x25, 0x0D, 0xC7, 0x71, 0x0E,
  0xB0, 0xD6, 0x09, 0xC0, 0x47, 0x60, 0x4C, 0x09, 0x60, 0x5C, 0x09, 0x76, 0x08, 0xC0, 0x56, 0x01,
  0xC0, 0xD7, 0x60, 0xDC, 0x01, 0x70, 0xDC, 0x02, 0x74, 0x02, 0xC0, 0xD7, 0x10, 0x8C, 0x07, 0x74,
  0x06, 0xC0, 0x97, 0x10, 0x4C, 0x0B, 0x74, 0x0B, 0xC0, 0x57, 0x2D, 0x74, 0x0E, 0xFF, 0xD0, 0x57,
  0x20, 0x4F, 0xFE, 0x09, 0x72, 0x08, 0xFF, 0xE0, 0xD7, 0x20, 0xDF, 0xFF, 0x02, 0x70, 0x2D, 0x80,
  0x90, 0x50, 0xCC, 0x07, 0x70, 0x6C, 0x0C, 0x75, 0x07, 0xC0, 0xB7, 0x0B, 0xC0, 0x87, 0x50, 0x2D,
  0x01, 0x60, 0xEC, 0x04, 0x76, 0x0D, 0xC0, 0x55, 0x04, 0xC0, 0xE7, 0x70, 0x9C, 0x09, 0x50, 0x8C,
  0x0B, 0x77, 0x05, 0xC0, 0xE5, 0x0D, 0xC0, 0x67, 0x70, 0x1D, 0x03, 0x30, 0x2D, 0x02, 0x77, 0x10,
  0xCC, 0x07, 0x30, 0x6C, 0x0D, 0x77, 0x20, 0x8C, 0x0C, 0x30, 0xBC, 0x09, 0x77, 0x20, 0x4D, 0x01,
  0x20, 0xEC, 0x05, 0x77, 0x3D, 0x81, 0x50, 0x4D, 0x01, 0x77, 0x30, 0xBC, 0x81, 0x90, 0x8C, 0x0C,
  0x77, 0x40, 0x7C, 0x81, 0xE0, 0xDC, 0x08, 0x77, 0x40, 0x2D, 0x03,
  // "Æ" (U+00C6)
  0x77, 0x02, 0xFF, 0xFA, 0x0A, 0x77, 0x08, 0xFF, 0xFA, 0x0A, 0x77, 0x0D, 0xFF, 0xFA, 0x0A, 0x76,
  0x03, 0xFF, 0xFB, 0x0A, 0x76, 0x09, 0xC8, 0x17, 0x5D, 0xC0, 0x78, 0x09, 0x05, 0x03, 0x76, 0x0E,
  0xB0, 0xE2, 0x0D, 0xC0, 0x47, 0x77, 0x40, 0x4C, 0x09, 0x20, 0xDC, 0x04, 0x77, 0x74, 0x09, 0xC0,
  0x42, 0x0D, 0xC0, 0x47, 0x77, 0x40, 0xEB, 0x0E, 0x30, 0xDC, 0x04, 0x77, 0x73, 0x05, 0xC0, 0xA3,
  0x0D, 0xC0, 0x47, 0x77, 0x30, 0xAC, 0x04, 0x30, 0xDC, 0x04, 0x77, 0x72, 0x01, 0xC0, 0xE4, 0x0D,
  0xC0, 0x47, 0x77, 0x20, 0x6C, 0x0A, 0x40, 0xDC, 0x04, 0x77, 0x72, 0x0B, 0xC0, 0x54, 0x0D, 0xC0,
  0x47, 0x77, 0x10, 0x1C, 0x0E, 0x50, 0xDC, 0x04, 0x77, 0x71, 0x07, 0xC0, 0xA5, 0x0D, 0xC0, 0x47,
  0x77, 0x10, 0xCC, 0x05, 0x50, 0xDC, 0x04, 0x77, 0x70, 0x2C, 0x0E, 0x60, 0xDC, 0x04, 0x77, 0x70,
  0x7C, 0x0A, 0x60, 0xDF, 0xFA, 0x0C, 0x72, 0x0D, 0xC0, 0x56, 0x0D, 0xFF, 0xA0, 0xC7, 0x10, 0x3C,
  0x0E, 0x70, 0xDF, 0xFA, 0x0C, 0x71, 0x08, 0xC0, 0xA7, 0x0D, 0xFF, 0xA0, 0xC7, 0x10, 0xEC, 0x05,
  0x70, 0xDC, 0x07, 0x80, 0x75, 0x04, 0x70, 0x4C, 0x0E, 0x71, 0x0D, 0xC0, 0x47, 0x75, 0x09, 0xC0,
  0xA7, 0x10, 0xDC, 0x04, 0x77, 0x50, 0xEF, 0xFC, 0x04, 0x77, 0x40, 0x5F, 0xFD, 0x04, 0x77, 0x40,
  0xAF, 0xFD, 0x04, 0x77, 0x4F, 0xFE, 0x04, 0x77, 0x30, 0x5C, 0x0E, 0x80, 0x65, 0x0E, 0xC0, 0x47,
  0x73, 0x0B, 0xC0, 0x97, 0x30, 0xEC, 0x04, 0x77, 0x20, 0x1D, 0x04, 0x73, 0x0E, 0xC0, 0x47, 0x72,
  0x06, 0xC0, 0xE7, 0x40, 0xEC, 0x04, 0x77, 0x20, 0xCC, 0x09, 0x74, 0x0E, 0xC0, 0x47, 0x71, 0x02,
  0xD0, 0x47, 0x40, 0xEC, 0x04, 0x77, 0x10, 0x7C, 0x0E, 0x75, 0x0E, 0xC0, 0x47, 0x71, 0x0D, 0xC0,
  0x97, 0x50, 0xEC, 0x04, 0x77, 0x03, 0xD0, 0x47, 0x50, 0xEC, 0x04, 0x77, 0x08, 0xC0, 0xE7, 0x60,
  0xEC, 0x07, 0x80, 0x90, 0x58, 0x13, 0x0D, 0xC0, 0x97, 0x60, 0xEF, 0xFB, 0x0A, 0x03, 0xD0, 0x37,
  0x60, 0xEF, 0xFB, 0x0A, 0x09, 0xC0, 0xD7, 0x70, 0xEF, 0xFB, 0x0A, 0x0E, 0xC0, 0x87, 0x70, 0xEF,
  0xFB, 0x0A,
  // "Ç" (U+00C7)
  0x76, 0x86, 0x35, 0x67, 0x65, 0x41, 0x77, 0x10, 0x50, 0xBF, 0xA8, 0x1D, 0x83, 0x73, 0x04, 0x0D,
  0xFF, 0x0C, 0x03, 0x70, 0x9F, 0xFB, 0x03, 0x60, 0xBF, 0x98, 0x1E, 0xDE, 0xE0, 0xC6, 0x0A, 0xE0,
  0xB0, 0x55, 0x81, 0x48, 0xEA, 0x05, 0x50, 0x7D, 0x0E, 0x05, 0x73, 0x07, 0x0D, 0x50, 0x2D, 0x0E,
  0x03, 0x77, 0x40, 0xBD, 0x04, 0x77, 0x40, 0x3D, 0x09, 0x77, 0x50, 0xAC, 0x0E, 0x01, 0x77, 0x40,
  0x1D, 0x08, 0x77, 0x50, 0x6D, 0x02, 0x77, 0x50, 0xAC, 0x0C, 0x77, 0x60, 0xEC, 0x08, 0x77, 0x50,
  0x2D, 0x04, 0x77, 0x50, 0x5D, 0x01, 0x77, 0x50, 0x7C, 0x0E, 0x77, 0x60, 0x9C, 0x0C, 0x77, 0x60,
  0xAC, 0x0B, 0x77, 0x60, 0xBC, 0x09, 0x77, 0x60, 0xCC, 0x09, 0x77, 0x60, 0xCC, 0x09, 0x77, 0x60,
  0xCC, 0x09, 0x77, 0x60, 0xBC, 0x0A, 0x77, 0x60, 0xAC, 0x0B, 0x77, 0x60, 0x9C, 0x0C, 0x77, 0x60,
  0x7C, 0x0E, 0x77, 0x60, 0x5D, 0x01, 0x77, 0x50, 0x3D, 0x03, 0x77, 0x6D, 0x07, 0x77, 0x60, 0xCC,
  0x0C, 0x77, 0x60, 0x7D, 0x01, 0x77, 0x50, 0x2D, 0x07, 0x77, 0x60, 0xCC, 0x0E, 0x01, 0x77, 0x50,
  0x5D, 0x08, 0x77, 0x60, 0xDD, 0x03, 0x77, 0x50, 0x4D, 0x0E, 0x02, 0x77, 0x50, 0xAD, 0x0E, 0x05,
  0x74, 0x02, 0x01, 0x60, 0xCE, 0x81, 0xB5, 0x14, 0x84, 0x13, 0x7C, 0xF4, 0x60, 0x20, 0xDF, 0x90,
  0xFD, 0x0E, 0xD0, 0x47, 0x01, 0x0C, 0xFF, 0xA0, 0x47, 0x20, 0x70, 0xEF, 0xF0, 0x47, 0x38, 0x11,
  0x7D, 0xFA, 0x81, 0xD9, 0x37, 0x70, 0x10, 0xEA, 0x83, 0xE6, 0x64, 0x17, 0x73, 0x01, 0xA0, 0xE7,
  0x77, 0x10, 0x8A, 0x0A, 0x77, 0x71, 0x0E, 0xB0, 0xE0, 0x87, 0x75, 0x03, 0x0C, 0xD0, 0xD0, 0x27,
  0x76, 0x06, 0x0D, 0xB0, 0xD7, 0x77, 0x01, 0x0E, 0xB0, 0x47, 0x77, 0x09, 0xB0, 0x77, 0x77, 0x0A,
  0xB0, 0x77, 0x76, 0x01, 0x0E, 0xB0, 0x57, 0x70, 0x10, 0x22, 0x81, 0x15, 0xCB, 0x0E, 0x77, 0x10,
  0x5F, 0xA0, 0x67, 0x71, 0x05, 0xF0, 0xE0, 0x67, 0x72, 0x81, 0x3C, 0xEA, 0x82, 0xEB, 0x71, 0x71,
  // "È" (U+00C8)
  0x20, 0x48, 0x01, 0x70, 0x37, 0x60, 0x4D, 0x0D, 0x77, 0x09, 0xD0, 0x57, 0x70, 0xBC, 0x0D, 0x77,
  0x01, 0x0D, 0xC0, 0x87, 0x70, 0x10, 0xDC, 0x03, 0x77, 0x02, 0x0E, 0xB0, 0xC7, 0x71, 0x02, 0x0E,
  0xB0, 0x77, 0x71, 0x02, 0x0D, 0xB0, 0x37, 0x71, 0x02, 0x0D, 0xA0, 0xB8, 0x09, 0xA2, 0x00, 0x3F,
  0xFC, 0x0E, 0x03, 0xFF, 0xC0, 0xE0, 0x3F, 0xFC, 0x0E, 0x03, 0xFF, 0xC0, 0xE0, 0x3D, 0x80, 0x91,
  0x50, 0x40, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70,
  0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E,
  0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03,
  0xFF, 0xC0, 0x10, 0x3F, 0xFC, 0x01, 0x03, 0xFF, 0xC0, 0x10, 0x3F, 0xFC, 0x01, 0x03, 0xD8, 0x09,
  0x15, 0x10, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70,
  0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E,
  0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03,
  0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xD8, 0x09, 0x15, 0x04, 0x03, 0xFF, 0xC0, 0xE0, 0x3F,
  0xFC, 0x0E, 0x03, 0xFF, 0xC0, 0xE0, 0x3F, 0xFC, 0x0E,
  // "É" (U+00C9)
  0x76, 0x02, 0x80, 0x17, 0x06, 0x76, 0x0A, 0xD0, 0x77, 0x50, 0x3D, 0x0C, 0x76, 0x0C, 0xC0, 0xE0,
  0x17, 0x50, 0x6C, 0x0E, 0x03, 0x75, 0x01, 0x0E, 0xC0, 0x47, 0x60, 0xAC, 0x05, 0x76, 0x05, 0xC0,
  0x57, 0x60, 0x10, 0xEB, 0x05, 0x77, 0x08, 0xA0, 0xE0, 0x48, 0x09, 0xA3, 0x00, 0x3F, 0xFC, 0x0E,
  0x03, 0xFF, 0xC0, 0xE0, 0x3F, 0xFC, 0x0E, 0x03, 0xFF, 0xC0, 0xE0, 0x3D, 0x80, 0x91, 0x50, 0x40,
  0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E,
  0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03,
  0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xFF, 0xC0,
  0x10, 0x3F, 0xFC, 0x01, 0x03, 0xFF, 0xC0, 0x10, 0x3F, 0xFC, 0x01, 0x03, 0xD8, 0x09, 0x15, 0x10,
  0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E,
  0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03,
  0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7,
  0x70, 0x3C, 0x0E, 0x77, 0x03, 0xD8, 0x09, 0x15, 0x04, 0x03, 0xFF, 0xC0, 0xE0, 0x3F, 0xFC, 0x0E,
  0x03, 0xFF, 0xC0, 0xE0, 0x3F, 0xFC, 0x0E,
  // "Ê" (U+00CA)
  0x71, 0x84, 0x57, 0x77, 0x73, 0x76, 0x01, 0xD0, 0xD7, 0x60, 0xAE, 0x06, 0x74, 0x04, 0xF0, 0xE0,
  0x27, 0x20, 0x10, 0xDB, 0x0C, 0x0E, 0xB0, 0xB7, 0x20, 0xAB, 0x82, 0xD1, 0x2E, 0xB0, 0x77, 0x05,
  0xB0, 0xD0, 0x12, 0x03, 0x0E, 0xB0, 0x35, 0x02, 0x0E, 0xA0, 0xD0, 0x14, 0x04, 0xB0, 0xD0, 0x14,
  0x0D, 0xA0, 0xD0, 0x26, 0x04, 0x0E, 0xA0, 0xB3, 0x08, 0xA0, 0xD0, 0x17, 0x10, 0x30, 0xDA, 0x06,
  0x80, 0x99, 0x40, 0x03, 0xFF, 0xC0, 0xE0, 0x3F, 0xFC, 0x0E, 0x03, 0xFF, 0xC0, 0xE0, 0x3F, 0xFC,
  0x0E, 0x03, 0xD8, 0x09, 0x15, 0x04, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7,
  0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C,
  0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77,
  0x03, 0xC0, 0xE7, 0x70, 0x3F, 0xFC, 0x01, 0x03, 0xFF, 0xC0, 0x10, 0x3F, 0xFC, 0x01, 0x03, 0xFF,
  0xC0, 0x10, 0x3D, 0x80, 0x91, 0x51, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7,
  0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C,
  0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77,
  0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3D, 0x80, 0x91, 0x50, 0x40,
  0x3F, 0xFC, 0x0E, 0x03, 0xFF, 0xC0, 0xE0, 0x3F, 0xFC, 0x0E, 0x03, 0xFF, 0xC0, 0xE0,
  // "Ë" (U+00CB)
  0x38, 0x27, 0xDE, 0x86, 0x83, 0x4D, 0xEA, 0x14, 0x03, 0xC0, 0x64, 0x01, 0x0E, 0xB0, 0x94, 0x07,
  0xC0, 0x94, 0x04, 0xC0, 0xD4, 0x07, 0xC0, 0x94, 0x04, 0xC0, 0xD4, 0x03, 0xC0, 0x54, 0x01, 0x0E,
  0xB0, 0x95, 0x82, 0x6D, 0xE8, 0x68, 0x24, 0xDE, 0xA8, 0x09, 0x97, 0x00, 0x3F, 0xFC, 0x0E, 0x03,
  0xFF, 0xC0, 0xE0, 0x3F, 0xFC, 0x0E, 0x03, 0xFF, 0xC0, 0xE0, 0x3D, 0x80, 0x91, 0x50, 0x40, 0x3C,
  0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77,
  0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0,
  0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xFF, 0xC0, 0x10,
  0x3F, 0xFC, 0x01, 0x03, 0xFF, 0xC0, 0x10, 0x3F, 0xFC, 0x01, 0x03, 0xD8, 0x09, 0x15, 0x10, 0x3C,
  0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77,
  0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0,
  0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70,
  0x3C, 0x0E, 0x77, 0x03, 0xD8, 0x09, 0x15, 0x04, 0x03, 0xFF, 0xC0, 0xE0, 0x3F, 0xFC, 0x0E, 0x03,
  0xFF, 0xC0, 0xE0, 0x3F, 0xFC, 0x0E,
  // "Ì" (U+00CC)
  0x04, 0x80, 0x17, 0x03, 0x72, 0x04, 0xD0, 0xD7, 0x30, 0x9D, 0x05, 0x73, 0x0B, 0xC0, 0xD7, 0x30,
  0x10, 0xDC, 0x08, 0x73, 0x01, 0x0D, 0xC0, 0x37, 0x30, 0x20, 0xEB, 0x0C, 0x74, 0x02, 0x0E, 0xB0,
  0x77, 0x40, 0x20, 0xDB, 0x03, 0x74, 0x02, 0x0D, 0xA0, 0xB8, 0x09, 0x82, 0x00, 0xDF, 0xD0, 0xC2,
  0x0D, 0xFD, 0x0C, 0x20, 0xDF, 0xD0, 0xC2, 0x07, 0x0D, 0xFB, 0x0C, 0x07, 0x48, 0x11, 0x5C, 0xC8,
  0x1B, 0x51, 0x71, 0x09, 0xC0, 0x87, 0x30, 0x9C, 0x08, 0x73, 0x09, 0xC0, 0x87, 0x30, 0x9C, 0x08,
  0x73, 0x09, 0xC0, 0x87, 0x30, 0x9C, 0x08, 0x73, 0x09, 0xC0, 0x87, 0x30, 0x9C, 0x08, 0x73, 0x09,
  0xC0, 0x87, 0x30, 0x9C, 0x08, 0x73, 0x09, 0xC0, 0x87, 0x30, 0x9C, 0x08, 0x73, 0x09, 0xC0, 0x87,
  0x30, 0x9C, 0x08, 0x73, 0x09, 0xC0, 0x87, 0x30, 0x9C, 0x08, 0x73, 0x09, 0xC0, 0x87, 0x30, 0x9C,
  0x08, 0x73, 0x09, 0xC0, 0x87, 0x30, 0x9C, 0x08, 0x73, 0x09, 0xC0, 0x87, 0x30, 0x9C, 0x08, 0x73,
  0x09, 0xC0, 0x87, 0x30, 0x9C, 0x08, 0x73, 0x09, 0xC0, 0x87, 0x30, 0x9C, 0x08, 0x73, 0x09, 0xC0,
  0x87, 0x30, 0x9C, 0x08, 0x73, 0x09, 0xC0, 0x87, 0x30, 0x9C, 0x08, 0x73, 0x09, 0xC0, 0x87, 0x30,
  0x9C, 0x08, 0x73, 0x09, 0xC0, 0x87, 0x30, 0x9C, 0x08, 0x78, 0x13, 0x7B, 0xD8, 0x2E, 0xB7, 0x33,
  0x0C, 0xFD, 0x0B, 0x20, 0xDF, 0xD0, 0xC2, 0x0D, 0xFD, 0x0C,
  // "Í" (U+00CD)
  0x73, 0x02, 0x80, 0x17, 0x06, 0x73, 0x0A, 0xD0, 0x77, 0x20, 0x3D, 0x0C, 0x73, 0x0C, 0xC0, 0xE0,
  0x17, 0x20, 0x6C, 0x0E, 0x03, 0x72, 0x01, 0x0E, 0xC0, 0x47, 0x30, 0xAC, 0x05, 0x73, 0x05, 0xC0,
  0x57, 0x30, 0x10, 0xEB, 0x05, 0x74, 0x08, 0xA0, 0xE0, 0x48, 0x09, 0x87, 0x00, 0xDF, 0xD0, 0xC3,
  0x0D, 0xFD, 0x0C, 0x30, 0xDF, 0xD0, 0xC3, 0x07, 0x0D, 0xFB, 0x0C, 0x07, 0x58, 0x11, 0x5C, 0xC8,
  0x1B, 0x51, 0x72, 0x09, 0xC0, 0x87, 0x40, 0x9C, 0x08, 0x74, 0x09, 0xC0, 0x87, 0x40, 0x9C, 0x08,
  0x74, 0x09, 0xC0, 0x87, 0x40, 0x9C, 0x08, 0x74, 0x09, 0xC0, 0x87, 0x40, 0x9C, 0x08, 0x74, 0x09,
  0xC0, 0x87, 0x40, 0x9C, 0x08, 0x74, 0x09, 0xC0, 0x87, 0x40, 0x9C, 0x08, 0x74, 0x09, 0xC0, 0x87,
  0x40, 0x9C, 0x08, 0x74, 0x09, 0xC0, 0x87, 0x40, 0x9C, 0x08, 0x74, 0x09, 0xC0, 0x87, 0x40, 0x9C,
  0x08, 0x74, 0x09, 0xC0, 0x87, 0x40, 0x9C, 0x08, 0x74, 0x09, 0xC0, 0x87, 0x40, 0x9C, 0x08, 0x74,
  0x09, 0xC0, 0x87, 0x40, 0x9C, 0x08, 0x74, 0x09, 0xC0, 0x87, 0x40, 0x9C, 0x08, 0x74, 0x09, 0xC0,
  0x87, 0x40, 0x9C, 0x08, 0x74, 0x09, 0xC0, 0x87, 0x40, 0x9C, 0x08, 0x74, 0x09, 0xC0, 0x87, 0x40,
  0x9C, 0x08, 0x74, 0x09, 0xC0, 0x87, 0x40, 0x9C, 0x08, 0x71, 0x81, 0x37, 0xBD, 0x82, 0xEB, 0x73,
  0x40, 0xCF, 0xD0, 0xB3, 0x0D, 0xFD, 0x0C, 0x30, 0xDF, 0xD0, 0xC3,
  // "Î" (U+00CE)
  0x68, 0x45, 0x77, 0x77, 0x37, 0x40, 0x1D, 0x0D, 0x74, 0x0A, 0xE0, 0x67, 0x20, 0x4F, 0x0E, 0x02,
  0x70, 0x10, 0xDB, 0x0C, 0x0E, 0xB0, 0xB7, 0x0A, 0xB8, 0x2D, 0x12, 0xEB, 0x07, 0x50, 0x5B, 0x0D,
  0x01, 0x20, 0x30, 0xEB, 0x03, 0x30, 0x20, 0xEA, 0x0D, 0x01, 0x40, 0x4B, 0x0D, 0x01, 0x20, 0xDA,
  0x0D, 0x02, 0x60, 0x40, 0xEA, 0x81, 0xB0, 0x8A, 0x0D, 0x01, 0x71, 0x03, 0x0D, 0xA0, 0x68, 0x09,
  0x86, 0x00, 0xDF, 0xD0, 0xC4, 0x0D, 0xFD, 0x0C, 0x40, 0xDF, 0xD0, 0xC4, 0x07, 0x0D, 0xFB, 0x0C,
  0x07, 0x68, 0x11, 0x5C, 0xC8, 0x1B, 0x51, 0x73, 0x09, 0xC0, 0x87, 0x50, 0x9C, 0x08, 0x75, 0x09,
  0xC0, 0x87, 0x50, 0x9C, 0x08, 0x75, 0x09, 0xC0, 0x87, 0x50, 0x9C, 0x08, 0x75, 0x09, 0xC0, 0x87,
  0x50, 0x9C, 0x08, 0x75, 0x09, 0xC0, 0x87, 0x50, 0x9C, 0x08, 0x75, 0x09, 0xC0, 0x87, 0x50, 0x9C,
  0x08, 0x75, 0x09, 0xC0, 0x87, 0x50, 0x9C, 0x08, 0x75, 0x09, 0xC0, 0x87, 0x50, 0x9C, 0x08, 0x75,
  0x09, 0xC0, 0x87, 0x50, 0x9C, 0x08, 0x75, 0x09, 0xC0, 0x87, 0x50, 0x9C, 0x08, 0x75, 0x09, 0xC0,
  0x87, 0x50, 0x9C, 0x08, 0x75, 0x09, 0xC0, 0x87, 0x50, 0x9C, 0x08, 0x75, 0x09, 0xC0, 0x87, 0x50,
  0x9C, 0x08, 0x75, 0x09, 0xC0, 0x87, 0x50, 0x9C, 0x08, 0x75, 0x09, 0xC0, 0x87, 0x50, 0x9C, 0x08,
  0x75, 0x09, 0xC0, 0x87, 0x50, 0x9C, 0x08, 0x75, 0x09, 0xC0, 0x87, 0x50, 0x9C, 0x08, 0x72, 0x81,
  0x37, 0xBD, 0x82, 0xEB, 0x73, 0x50, 0xCF, 0xD0, 0xB4, 0x0D, 0xFD, 0x0C, 0x40, 0xDF, 0xD0, 0xC2,
  // "Ï" (U+00CF)
  0x18, 0x27, 0xDE, 0x86, 0x84, 0x4D, 0xEA, 0x13, 0xC0, 0x64, 0x01, 0x0E, 0xB0, 0x90, 0x7C, 0x09,
  0x40, 0x4C, 0x0D, 0x07, 0xC0, 0x94, 0x04, 0xC0, 0xD0, 0x3C, 0x05, 0x40, 0x10, 0xEB, 0x84, 0x90,
  0x6D, 0xE8, 0x68, 0x24, 0xDE, 0xA8, 0x0F, 0x60, 0x0D, 0xFD, 0x0C, 0x20, 0xDF, 0xD0, 0xC2, 0x0D,
  0xFD, 0x0C, 0x20, 0x70, 0xDF, 0xB0, 0xC0, 0x74, 0x81, 0x15, 0xCC, 0x81, 0xB5, 0x17, 0x10, 0x9C,
  0x08, 0x73, 0x09, 0xC0, 0x87, 0x30, 0x9C, 0x08, 0x73, 0x09, 0xC0, 0x87, 0x30, 0x9C, 0x08, 0x73,
  0x09, 0xC0, 0x87, 0x30, 0x9C, 0x08, 0x73, 0x09, 0xC0, 0x87, 0x30, 0x9C, 0x08, 0x73, 0x09, 0xC0,
  0x87, 0x30, 0x9C, 0x08, 0x73, 0x09, 0xC0, 0x87, 0x30, 0x9C, 0x08, 0x73, 0x09, 0xC0, 0x87, 0x30,
  0x9C, 0x08, 0x73, 0x09, 0xC0, 0x87, 0x30, 0x9C, 0x08, 0x73, 0x09, 0xC0, 0x87, 0x30, 0x9C, 0x08,
  0x73, 0x09, 0xC0, 0x87, 0x30, 0x9C, 0x08, 0x73, 0x09, 0xC0, 0x87, 0x30, 0x9C, 0x08, 0x73, 0x09,
  0xC0, 0x87, 0x30, 0x9C, 0x08, 0x73, 0x09, 0xC0, 0x87, 0x30, 0x9C, 0x08, 0x73, 0x09, 0xC0, 0x87,
  0x30, 0x9C, 0x08, 0x73, 0x09, 0xC0, 0x87, 0x30, 0x9C, 0x08, 0x73, 0x09, 0xC0, 0x87, 0x30, 0x9C,
  0x08, 0x73, 0x09, 0xC0, 0x87, 0x81, 0x37, 0xBD, 0x82, 0xEB, 0x73, 0x30, 0xCF, 0xD0, 0xB2, 0x0D,
  0xFD, 0x0C, 0x20, 0xDF, 0xD0, 0xC1,
  // "Ð" (U+00D0)
  0x30, 0x1F, 0xC8, 0x3E, 0xCA, 0x73, 0x77, 0x01, 0xFF, 0xA0, 0xD0, 0x67, 0x50, 0x1F, 0xFC, 0x0D,
  0x03, 0x73, 0x01, 0xFF, 0xE0, 0x67, 0x20, 0x1D, 0x80, 0x25, 0x81, 0x79, 0xDF, 0x07, 0x71, 0x01,
  0xD0, 0x17, 0x10, 0x40, 0xCE, 0x05, 0x70, 0x1D, 0x01, 0x73, 0x08, 0xD0, 0xE0, 0x26, 0x01, 0xD0,
  0x17, 0x40, 0x7D, 0x0A, 0x60, 0x1D, 0x01, 0x75, 0x0A, 0xD0, 0x35, 0x01, 0xD0, 0x17, 0x50, 0x10,
  0xEC, 0x0A, 0x50, 0x1D, 0x01, 0x76, 0x08, 0xD0, 0x14, 0x01, 0xD0, 0x17, 0x60, 0x2D, 0x05, 0x40,
  0x1D, 0x01, 0x77, 0x0C, 0xC0, 0xA4, 0x01, 0xD0, 0x17, 0x70, 0x8C, 0x0D, 0x40, 0x1D, 0x01, 0x77,
  0x04, 0xD0, 0x13, 0x01, 0xD0, 0x17, 0x70, 0x2D, 0x03, 0x30, 0x1D, 0x01, 0x77, 0x1D, 0x05, 0x30,
  0x1D, 0x01, 0x77, 0x10, 0xDC, 0x07, 0x30, 0x1D, 0x01, 0x77, 0x10, 0xCC, 0x00, 0x8F, 0xF9, 0x05,
  0x71, 0x0B, 0xC0, 0x90, 0x8F, 0xF9, 0x05, 0x71, 0x0B, 0xC0, 0x90, 0x8F, 0xF9, 0x05, 0x71, 0x0B,
  0xC0, 0x90, 0x8F, 0xF9, 0x05, 0x71, 0x0B, 0xC0, 0x90, 0x20, 0xF5, 0xD8, 0x03, 0x50, 0x17, 0x10,
  0xCC, 0x08, 0x30, 0x1D, 0x01, 0x77, 0x10, 0xDC, 0x07, 0x30, 0x1D, 0x01, 0x77, 0x10, 0xEC, 0x06,
  0x30, 0x1D, 0x01, 0x77, 0x01, 0xD0, 0x43, 0x01, 0xD0, 0x17, 0x70, 0x3D, 0x02, 0x30, 0x1D, 0x01,
  0x77, 0x06, 0xC0, 0xE4, 0x01, 0xD0, 0x17, 0x70, 0xAC, 0x0B, 0x40, 0x1D, 0x01, 0x77, 0x0E, 0xC0,
  0x84, 0x01, 0xD0, 0x17, 0x60, 0x4D, 0x03, 0x40, 0x1D, 0x01, 0x76, 0x0B, 0xC0, 0xD5, 0x01, 0xD0,
  0x17, 0x50, 0x3D, 0x07, 0x50, 0x1D, 0x01, 0x75, 0x0D, 0xC0, 0xE0, 0x15, 0x01, 0xD0, 0x17, 0x40,
  0xAD, 0x07, 0x60, 0x1D, 0x01, 0x72, 0x01, 0x0B, 0xD0, 0xC7, 0x01, 0xD0, 0x17, 0x81, 0x17, 0xED,
  0x0E, 0x02, 0x70, 0x1D, 0x80, 0x15, 0x81, 0x68, 0xBF, 0x90, 0x47, 0x10, 0x1F, 0xFD, 0x0E, 0x03,
  0x72, 0x01, 0xFF, 0xC0, 0xA0, 0x17, 0x30, 0x1F, 0xFA, 0x0B, 0x03, 0x75, 0x01, 0xFB, 0x84, 0xED,
  0xB9, 0x51, 0x74,
  // "Ñ" (U+00D1)
  0x71, 0x84, 0x5C, 0xEE, 0xB6, 0x70, 0xBA, 0x05, 0x74, 0x08, 0xE0, 0xE0, 0x74, 0x03, 0xB0, 0x37,
  0x30, 0x3F, 0xA8, 0x3E, 0x96, 0x6E, 0xA0, 0xE7, 0x40, 0xAF, 0xFA, 0x09, 0x73, 0x01, 0xB8, 0x2D,
  0x66, 0xAF, 0xB0, 0x27, 0x30, 0x4A, 0x0E, 0x01, 0x30, 0x10, 0x9F, 0x06, 0x74, 0x07, 0xA0, 0x96,
  0x85, 0x17, 0xCE, 0xEB, 0x48, 0x09, 0xE7, 0x00, 0x3E, 0x03, 0x77, 0x2C, 0x0C, 0x03, 0xE0, 0xB7,
  0x72, 0xC0, 0xC0, 0x3F, 0x03, 0x77, 0x1C, 0x0C, 0x03, 0xF0, 0xA7, 0x71, 0xC0, 0xC0, 0x3F, 0x90,
  0x27, 0x7C, 0x0C, 0x03, 0xF9, 0x0A, 0x77, 0xC0, 0xC0, 0x3F, 0xA0, 0x27, 0x6C, 0x0C, 0x03, 0xFA,
  0x0A, 0x76, 0xC0, 0xC0, 0x3C, 0x0A, 0xD0, 0x27, 0x5C, 0x0C, 0x03, 0xC0, 0x50, 0xDC, 0x09, 0x75,
  0xC0, 0xC0, 0x3C, 0x05, 0x06, 0xD0, 0x27, 0x4C, 0x0C, 0x03, 0xC8, 0x16, 0x0D, 0xC0, 0x97, 0x4C,
  0x0C, 0x03, 0xC8, 0x17, 0x06, 0xD0, 0x17, 0x3C, 0x0C, 0x03, 0xC0, 0x82, 0x0D, 0xC0, 0x97, 0x3C,
  0x0C, 0x03, 0xC0, 0x82, 0x06, 0xD0, 0x17, 0x2C, 0x0C, 0x03, 0xC0, 0x93, 0x0E, 0xC0, 0x87, 0x2C,
  0x0C, 0x03, 0xC0, 0x93, 0x07, 0xC0, 0xE0, 0x17, 0x1C, 0x0C, 0x03, 0xC0, 0xA4, 0x0E, 0xC0, 0x87,
  0x1C, 0x0C, 0x03, 0xC0, 0xA4, 0x07, 0xC0, 0xE0, 0x17, 0xC0, 0xC0, 0x3C, 0x0A, 0x50, 0xEC, 0x08,
  0x7C, 0x0C, 0x03, 0xC0, 0xA5, 0x07, 0xC0, 0xE0, 0x16, 0xC0, 0xC0, 0x3C, 0x0A, 0x60, 0xEC, 0x07,
  0x6C, 0x0C, 0x03, 0xC0, 0xA6, 0x07, 0xC0, 0xE6, 0xC0, 0xC0, 0x3C, 0x0A, 0x70, 0xEC, 0x07, 0x5C,
  0x0C, 0x03, 0xC0, 0xA7, 0x07, 0xC0, 0xE5, 0xC0, 0xC0, 0x3C, 0x0A, 0x70, 0x10, 0xEC, 0x07, 0x4C,
  0x0C, 0x03, 0xC0, 0xA7, 0x10, 0x7C, 0x0E, 0x4C, 0x0C, 0x03, 0xC0, 0xA7, 0x10, 0x10, 0xEC, 0x06,
  0x3C, 0x0C, 0x03, 0xC0, 0xA7, 0x20, 0x8C, 0x0D, 0x3C, 0x0C, 0x03, 0xC0, 0xA7, 0x20, 0x10, 0xEC,
  0x06, 0x2C, 0x0C, 0x03, 0xC0, 0xA7, 0x30, 0x8C, 0x0D, 0x20, 0xEB, 0x0C, 0x03, 0xC0, 0xA7, 0x30,
  0x10, 0xEC, 0x81, 0x60, 0xDB, 0x0C, 0x03, 0xC0, 0xA7, 0x40, 0x8C, 0x81, 0xD0, 0xDB, 0x0C, 0x03,
  0xC0, 0xA7, 0x40, 0x10, 0xEC, 0x05, 0x0C, 0xB0, 0xC0, 0x3C, 0x0A, 0x75, 0x08, 0xC0, 0xD0, 0xCB,
  0x0C, 0x03, 0xC0, 0xA7, 0x50, 0x1F, 0xA0, 0xC0, 0x3C, 0x0A, 0x76, 0x08, 0xF9, 0x0C, 0x03, 0xC0,
  0xA7, 0x60, 0x1F, 0x90, 0xC0, 0x3C, 0x0A, 0x77, 0x09, 0xF0, 0xC0, 0x3C, 0x0A, 0x77, 0x01, 0xF0,
  0xC0, 0x3C, 0x0A, 0x77, 0x10, 0x9E, 0x0C, 0x03, 0xC0, 0xA7, 0x71, 0x01, 0xE0, 0xC0, 0x3C, 0x0A,
  0x77, 0x20, 0x9D, 0x0C,
  // "Ò" (U+00D2)
  0x70, 0x48, 0x01, 0x70, 0x37, 0x77, 0x30, 0x4D, 0x0D, 0x77, 0x74, 0x09, 0xD0, 0x57, 0x77, 0x40,
  0xBC, 0x0D, 0x77, 0x74, 0x01, 0x0D, 0xC0, 0x87, 0x77, 0x40, 0x10, 0xDC, 0x03, 0x77, 0x74, 0x02,
  0x0E, 0xB0, 0xC7, 0x77, 0x50, 0x20, 0xEB, 0x07, 0x77, 0x75, 0x02, 0x0D, 0xB0, 0x37, 0x77, 0x50,
  0x20, 0xDA, 0x0B, 0x80, 0x9E, 0x10, 0x85, 0x35, 0x67, 0x65, 0x37, 0x77, 0x05, 0x0B, 0xFA, 0x0B,
  0x05, 0x77, 0x20, 0x40, 0xDF, 0xE0, 0xD0, 0x37, 0x60, 0x8F, 0xFB, 0x07, 0x74, 0x09, 0xF9, 0x81,
  0xED, 0xDF, 0x90, 0x87, 0x20, 0x7E, 0x81, 0xC5, 0x14, 0x04, 0x0A, 0xE0, 0x57, 0x03, 0xE0, 0x77,
  0x20, 0x40, 0xEC, 0x0E, 0x02, 0x60, 0xCD, 0x05, 0x74, 0x03, 0xD0, 0xB5, 0x04, 0xD0, 0x97, 0x60,
  0x6D, 0x04, 0x40, 0xBC, 0x0E, 0x77, 0x10, 0xCC, 0x0B, 0x30, 0x1D, 0x07, 0x77, 0x10, 0x5D, 0x01,
  0x20, 0x6D, 0x01, 0x77, 0x20, 0xEC, 0x07, 0x20, 0xBC, 0x0C, 0x77, 0x30, 0x9C, 0x0B, 0x20, 0xEC,
  0x07, 0x77, 0x30, 0x5D, 0x10, 0x2D, 0x04, 0x77, 0x30, 0x1D, 0x03, 0x05, 0xD0, 0x17, 0x74, 0x0E,
  0xC0, 0x60, 0x7C, 0x0E, 0x77, 0x50, 0xCC, 0x00, 0x9C, 0x0C, 0x77, 0x50, 0xAC, 0x0B, 0x0A, 0xC0,
  0xB7, 0x75, 0x09, 0xC0, 0xC0, 0xBC, 0x0A, 0x77, 0x50, 0x8C, 0x0E, 0x0C, 0xC0, 0x97, 0x75, 0x07,
  0xC0, 0xE0, 0xCC, 0x09, 0x77, 0x50, 0x7D, 0x0C, 0xC0, 0x97, 0x75, 0x06, 0xD0, 0xCC, 0x09, 0x77,
  0x50, 0x7D, 0x0B, 0xC0, 0xA7, 0x75, 0x07, 0xC0, 0xE0, 0xAC, 0x0A, 0x77, 0x50, 0x8C, 0x0E, 0x09,
  0xC0, 0xB7, 0x75, 0x09, 0xC0, 0xC0, 0x7C, 0x0D, 0x77, 0x50, 0xAC, 0x0A, 0x05, 0xD7, 0x75, 0x0C,
  0xC0, 0x90, 0x3D, 0x02, 0x77, 0x40, 0xEC, 0x06, 0x1D, 0x04, 0x77, 0x30, 0x2D, 0x81, 0x30, 0xCC,
  0x08, 0x77, 0x30, 0x5D, 0x20, 0x8C, 0x0C, 0x77, 0x30, 0xAC, 0x0B, 0x20, 0x4D, 0x02, 0x77, 0x20,
  0xEC, 0x07, 0x30, 0xDC, 0x09, 0x77, 0x10, 0x6D, 0x01, 0x30, 0x8C, 0x0E, 0x01, 0x77, 0x0D, 0xC0,
  0xB4, 0x01, 0x0E, 0xC0, 0x97, 0x60, 0x7D, 0x04, 0x50, 0x8D, 0x06, 0x74, 0x04, 0xD0, 0xB7, 0x0D,
  0xD0, 0x77, 0x20, 0x5D, 0x0E, 0x02, 0x70, 0x3E, 0x81, 0xC5, 0x14, 0x04, 0x0B, 0xE0, 0x57, 0x20,
  0x5F, 0x90, 0xFD, 0xF9, 0x07, 0x74, 0x04, 0x0E, 0xFF, 0xA0, 0x77, 0x60, 0x20, 0xBF, 0xE0, 0xD0,
  0x37, 0x72, 0x81, 0x4A, 0xEF, 0x90, 0xB0, 0x57, 0x77, 0x85, 0x35, 0x67, 0x65, 0x37, 0x50,
  // "Ó" (U+00D3)
  0x77, 0x40, 0x28, 0x01, 0x70, 0x67, 0x77, 0x30, 0xAD, 0x07, 0x77, 0x72, 0x03, 0xD0, 0xC7, 0x77,
  0x30, 0xCC, 0x0E, 0x01, 0x77, 0x72, 0x06, 0xC0, 0xE0, 0x37, 0x77, 0x20, 0x10, 0xEC, 0x04, 0x77,
  0x73, 0x0A, 0xC0, 0x57, 0x77, 0x30, 0x5C, 0x05, 0x77, 0x73, 0x01, 0x0E, 0xB0, 0x57, 0x77, 0x40,
  0x8A, 0x0E, 0x04, 0x80, 0x9E, 0x20, 0x85, 0x35, 0x67, 0x65, 0x37, 0x77, 0x05, 0x0B, 0xFA, 0x0B,
  0x05, 0x77, 0x20, 0x40, 0xDF, 0xE0, 0xD0, 0x37, 0x60, 0x8F, 0xFB, 0x07, 0x74, 0x09, 0xF9, 0x81,
  0xED, 0xDF, 0x90, 0x87, 0x20, 0x7E, 0x81, 0xC5, 0x14, 0x04, 0x0A, 0xE0, 0x57, 0x03, 0xE0, 0x77,
  0x20, 0x40, 0xEC, 0x0E, 0x02, 0x60, 0xCD, 0x05, 0x74, 0x03, 0xD0, 0xB5, 0x04, 0xD0, 0x97, 0x60,
  0x6D, 0x04, 0x40, 0xBC, 0x0E, 0x77, 0x10, 0xCC, 0x0B, 0x30, 0x1D, 0x07, 0x77, 0x10, 0x5D, 0x01,
  0x20, 0x6D, 0x01, 0x77, 0x20, 0xEC, 0x07, 0x20, 0xBC, 0x0C, 0x77, 0x30, 0x9C, 0x0B, 0x20, 0xEC,
  0x07, 0x77, 0x30, 0x5D, 0x10, 0x2D, 0x04, 0x77, 0x30, 0x1D, 0x03, 0x05, 0xD0, 0x17, 0x74, 0x0E,
  0xC0, 0x60, 0x7C, 0x0E, 0x77, 0x50, 0xCC, 0x00, 0x9C, 0x0C, 0x77, 0x50, 0xAC, 0x0B, 0x0A, 0xC0,
  0xB7, 0x75, 0x09, 0xC0, 0xC0, 0xBC, 0x0A, 0x77, 0x50, 0x8C, 0x0E, 0x0C, 0xC0, 0x97, 0x75, 0x07,
  0xC0, 0xE0, 0xCC, 0x09, 0x77, 0x50, 0x7D, 0x0C, 0xC0, 0x97, 0x75, 0x06, 0xD0, 0xCC, 0x09, 0x77,
  0x50, 0x7D, 0x0B, 0xC0, 0xA7, 0x75, 0x07, 0xC0, 0xE0, 0xAC, 0x0A, 0x77, 0x50, 0x8C, 0x0E, 0x09,
  0xC0, 0xB7, 0x75, 0x09, 0xC0, 0xC0, 0x7C, 0x0D, 0x77, 0x50, 0xAC, 0x0A, 0x05, 0xD7, 0x75, 0x0C,
  0xC0, 0x90, 0x3D, 0x02, 0x77, 0x40, 0xEC, 0x06, 0x1D, 0x04, 0x77, 0x30, 0x2D, 0x81, 0x30, 0xCC,
  0x08, 0x77, 0x30, 0x5D, 0x20, 0x8C, 0x0C, 0x77, 0x30, 0xAC, 0x0B, 0x20, 0x4D, 0x02, 0x77, 0x20,
  0xEC, 0x07, 0x30, 0xDC, 0x09, 0x77, 0x10, 0x6D, 0x01, 0x30, 0x8C, 0x0E, 0x01, 0x77, 0x0D, 0xC0,
  0xB4, 0x01, 0x0E, 0xC0, 0x97, 0x60, 0x7D, 0x04, 0x50, 0x8D, 0x06, 0x74, 0x04, 0xD0, 0xB7, 0x0D,
  0xD0, 0x77, 0x20, 0x5D, 0x0E, 0x02, 0x70, 0x3E, 0x81, 0xC5, 0x14, 0x04, 0x0B, 0xE0, 0x57, 0x20,
  0x5F, 0x90, 0xFD, 0xF9, 0x07, 0x74, 0x04, 0x0E, 0xFF, 0xA0, 0x77, 0x60, 0x20, 0xBF, 0xE0, 0xD0,
  0x37, 0x72, 0x81, 0x4A, 0xEF, 0x90, 0xB0, 0x57, 0x77, 0x85, 0x35, 0x67, 0x65, 0x37, 0x50,
  // "Ô" (U+00D4)
  0x76, 0x84, 0x57, 0x77, 0x73, 0x77, 0x73, 0x01, 0xD0, 0xD7, 0x77, 0x30, 0xAE, 0x06, 0x77, 0x71,
  0x04, 0xF0, 0xE0, 0x27, 0x76, 0x01, 0x0D, 0xB0, 0xC0, 0xEB, 0x0B, 0x77, 0x60, 0xAB, 0x82, 0xD1,
  0x2E, 0xB0, 0x77, 0x74, 0x05, 0xB0, 0xD0, 0x12, 0x03, 0x0E, 0xB0, 0x37, 0x72, 0x02, 0x0E, 0xA0,
  0xD0, 0x14, 0x04, 0xB0, 0xD0, 0x17, 0x71, 0x0D, 0xA0, 0xD0, 0x26, 0x04, 0x0E, 0xA0, 0xB7, 0x70,
  0x8A, 0x0D, 0x01, 0x71, 0x03, 0x0D, 0xA0, 0x68, 0x09, 0xD3, 0x08, 0x53, 0x56, 0x76, 0x53, 0x77,
  0x70, 0x50, 0xBF, 0xA0, 0xB0, 0x57, 0x72, 0x04, 0x0D, 0xFE, 0x0D, 0x03, 0x76, 0x08, 0xFF, 0xB0,
  0x77, 0x40, 0x9F, 0x98, 0x1E, 0xDD, 0xF9, 0x08, 0x72, 0x07, 0xE8, 0x1C, 0x51, 0x40, 0x40, 0xAE,
  0x05, 0x70, 0x3E, 0x07, 0x72, 0x04, 0x0E, 0xC0, 0xE0, 0x26, 0x0C, 0xD0, 0x57, 0x40, 0x3D, 0x0B,
  0x50, 0x4D, 0x09, 0x76, 0x06, 0xD0, 0x44, 0x0B, 0xC0, 0xE7, 0x71, 0x0C, 0xC0, 0xB3, 0x01, 0xD0,
  0x77, 0x71, 0x05, 0xD0, 0x12, 0x06, 0xD0, 0x17, 0x72, 0x0E, 0xC0, 0x72, 0x0B, 0xC0, 0xC7, 0x73,
  0x09, 0xC0, 0xB2, 0x0E, 0xC0, 0x77, 0x73, 0x05, 0xD1, 0x02, 0xD0, 0x47, 0x73, 0x01, 0xD0, 0x30,
  0x5D, 0x01, 0x77, 0x40, 0xEC, 0x06, 0x07, 0xC0, 0xE7, 0x75, 0x0C, 0xC0, 0x09, 0xC0, 0xC7, 0x75,
  0x0A, 0xC0, 0xB0, 0xAC, 0x0B, 0x77, 0x50, 0x9C, 0x0C, 0x0B, 0xC0, 0xA7, 0x75, 0x08, 0xC0, 0xE0,
  0xCC, 0x09, 0x77, 0x50, 0x7C, 0x0E, 0x0C, 0xC0, 0x97, 0x75, 0x07, 0xD0, 0xCC, 0x09, 0x77, 0x50,
  0x6D, 0x0C, 0xC0, 0x97, 0x75, 0x07, 0xD0, 0xBC, 0x0A, 0x77, 0x50, 0x7C, 0x0E, 0x0A, 0xC0, 0xA7,
  0x75, 0x08, 0xC0, 0xE0, 0x9C, 0x0B, 0x77, 0x50, 0x9C, 0x0C, 0x07, 0xC0, 0xD7, 0x75, 0x0A, 0xC0,
  0xA0, 0x5D, 0x77, 0x50, 0xCC, 0x09, 0x03, 0xD0, 0x27, 0x74, 0x0E, 0xC0, 0x61, 0xD0, 0x47, 0x73,
  0x02, 0xD8, 0x13, 0x0C, 0xC0, 0x87, 0x73, 0x05, 0xD2, 0x08, 0xC0, 0xC7, 0x73, 0x0A, 0xC0, 0xB2,
  0x04, 0xD0, 0x27, 0x72, 0x0E, 0xC0, 0x73, 0x0D, 0xC0, 0x97, 0x71, 0x06, 0xD0, 0x13, 0x08, 0xC0,
  0xE0, 0x17, 0x70, 0xDC, 0x0B, 0x40, 0x10, 0xEC, 0x09, 0x76, 0x07, 0xD0, 0x45, 0x08, 0xD0, 0x67,
  0x40, 0x4D, 0x0B, 0x70, 0xDD, 0x07, 0x72, 0x05, 0xD0, 0xE0, 0x27, 0x03, 0xE8, 0x1C, 0x51, 0x40,
  0x40, 0xBE, 0x05, 0x72, 0x05, 0xF9, 0x0F, 0xDF, 0x90, 0x77, 0x40, 0x40, 0xEF, 0xFA, 0x07, 0x76,
  0x02, 0x0B, 0xFE, 0x0D, 0x03, 0x77, 0x28, 0x14, 0xAE, 0xF9, 0x0B, 0x05, 0x77, 0x78, 0x53, 0x56,
  0x76, 0x53, 0x75,
  // "Õ" (U+00D5)
  0x72, 0x84, 0x5C, 0xEE, 0xB6, 0x70, 0xBA, 0x05, 0x76, 0x08, 0xE0, 0xE0, 0x74, 0x03, 0xB0, 0x37,
  0x50, 0x3F, 0xA8, 0x3E, 0x96, 0x6E, 0xA0, 0xE7, 0x60, 0xAF, 0xFA, 0x09, 0x75, 0x01, 0xB8, 0x2D,
  0x66, 0xAF, 0xB0, 0x27, 0x50, 0x4A, 0x0E, 0x01, 0x30, 0x10, 0x9F, 0x06, 0x76, 0x07, 0xA0, 0x96,
  0x85, 0x17, 0xCE, 0xEB, 0x48, 0x09, 0xD5, 0x08, 0x53, 0x56, 0x76, 0x53, 0x77, 0x70, 0x50, 0xBF,
  0xA0, 0xB0, 0x57, 0x72, 0x04, 0x0D, 0xFE, 0x0D, 0x03, 0x76, 0x08, 0xFF, 0xB0, 0x77, 0x40, 0x9F,
  0x98, 0x1E, 0xDD, 0xF9, 0x08, 0x72, 0x07, 0xE8, 0x1C, 0x51, 0x40, 0x40, 0xAE, 0x05, 0x70, 0x3E,
  0x07, 0x72, 0x04, 0x0E, 0xC0, 0xE0, 0x26, 0x0C, 0xD0, 0x57, 0x40, 0x3D, 0x0B, 0x50, 0x4D, 0x09,
  0x76, 0x06, 0xD0, 0x44, 0x0B, 0xC0, 0xE7, 0x71, 0x0C, 0xC0, 0xB3, 0x01, 0xD0, 0x77, 0x71, 0x05,
  0xD0, 0x12, 0x06, 0xD0, 0x17, 0x72, 0x0E, 0xC0, 0x72, 0x0B, 0xC0, 0xC7, 0x73, 0x09, 0xC0, 0xB2,
  0x0E, 0xC0, 0x77, 0x73, 0x05, 0xD1, 0x02, 0xD0, 0x47, 0x73, 0x01, 0xD0, 0x30, 0x5D, 0x01, 0x77,
  0x40, 0xEC, 0x06, 0x07, 0xC0, 0xE7, 0x75, 0x0C, 0xC0, 0x09, 0xC0, 0xC7, 0x75, 0x0A, 0xC0, 0xB0,
  0xAC, 0x0B, 0x77, 0x50, 0x9C, 0x0C, 0x0B, 0xC0, 0xA7, 0x75, 0x08, 0xC0, 0xE0, 0xCC, 0x09, 0x77,
  0x50, 0x7C, 0x0E, 0x0C, 0xC0, 0x97, 0x75, 0x07, 0xD0, 0xCC, 0x09, 0x77, 0x50, 0x6D, 0x0C, 0xC0,
  0x97, 0x75, 0x07, 0xD0, 0xBC, 0x0A, 0x77, 0x50, 0x7C, 0x0E, 0x0A, 0xC0, 0xA7, 0x75, 0x08, 0xC0,
  0xE0, 0x9C, 0x0B, 0x77, 0x50, 0x9C, 0x0C, 0x07, 0xC0, 0xD7, 0x75, 0x0A, 0xC0, 0xA0, 0x5D, 0x77,
  0x50, 0xCC, 0x09, 0x03, 0xD0, 0x27, 0x74, 0x0E, 0xC0, 0x61, 0xD0, 0x47, 0x73, 0x02, 0xD8, 0x13,
  0x0C, 0xC0, 0x87, 0x73, 0x05, 0xD2, 0x08, 0xC0, 0xC7, 0x73, 0x0A, 0xC0, 0xB2, 0x04, 0xD0, 0x27,
  0x72, 0x0E, 0xC0, 0x73, 0x0D, 0xC0, 0x97, 0x71, 0x06, 0xD0, 0x13, 0x08, 0xC0, 0xE0, 0x17, 0x70,
  0xDC, 0x0B, 0x40, 0x10, 0xEC, 0x09, 0x76, 0x07, 0xD0, 0x45, 0x08, 0xD0, 0x67, 0x40, 0x4D, 0x0B,
  0x70, 0xDD, 0x07, 0x72, 0x05, 0xD0, 0xE0, 0x27, 0x03, 0xE8, 0x1C, 0x51, 0x40, 0x40, 0xBE, 0x05,
  0x72, 0x05, 0xF9, 0x0F, 0xDF, 0x90, 0x77, 0x40, 0x40, 0xEF, 0xFA, 0x07, 0x76, 0x02, 0x0B, 0xFE,
  0x0D, 0x03, 0x77, 0x28, 0x14, 0xAE, 0xF9, 0x0B, 0x05, 0x77, 0x78, 0x53, 0x56, 0x76, 0x53, 0x75,
  // "Ö" (U+00D6)
  0x72, 0x82, 0x7D, 0xE8, 0x68, 0x34, 0xDE, 0xA1, 0x77, 0x10, 0x3C, 0x06, 0x40, 0x10, 0xEB, 0x09,
  0x77, 0x10, 0x7C, 0x09, 0x40, 0x4C, 0x0D, 0x77, 0x10, 0x7C, 0x09, 0x40, 0x4C, 0x0D, 0x77, 0x10,
  0x3C, 0x05, 0x40, 0x10, 0xEB, 0x09, 0x77, 0x28, 0x26, 0xDE, 0x86, 0x82, 0x4D, 0xEA, 0x80, 0x9D,
  0x50, 0x85, 0x35, 0x67, 0x65, 0x37, 0x77, 0x05, 0x0B, 0xFA, 0x0B, 0x05, 0x77, 0x20, 0x40, 0xDF,
  0xE0, 0xD0, 0x37, 0x60, 0x8F, 0xFB, 0x07, 0x74, 0x09, 0xF9, 0x81, 0xED, 0xDF, 0x90, 0x87, 0x20,
  0x7E, 0x81, 0xC5, 0x14, 0x04, 0x0A, 0xE0, 0x57, 0x03, 0xE0, 0x77, 0x20, 0x40, 0xEC, 0x0E, 0x02,
  0x60, 0xCD, 0x05, 0x74, 0x03, 0xD0, 0xB5, 0x04, 0xD0, 0x97, 0x60, 0x6D, 0x04, 0x40, 0xBC, 0x0E,
  0x77, 0x10, 0xCC, 0x0B, 0x30, 0x1D, 0x07, 0x77, 0x10, 0x5D, 0x01, 0x20, 0x6D, 0x01, 0x77, 0x20,
  0xEC, 0x07, 0x20, 0xBC, 0x0C, 0x77, 0x30, 0x9C, 0x0B, 0x20, 0xEC, 0x07, 0x77, 0x30, 0x5D, 0x10,
  0x2D, 0x04, 0x77, 0x30, 0x1D, 0x03, 0x05, 0xD0, 0x17, 0x74, 0x0E, 0xC0, 0x60, 0x7C, 0x0E, 0x77,
  0x50, 0xCC, 0x00, 0x9C, 0x0C, 0x77, 0x50, 0xAC, 0x0B, 0x0A, 0xC0, 0xB7, 0x75, 0x09, 0xC0, 0xC0,
  0xBC, 0x0A, 0x77, 0x50, 0x8C, 0x0E, 0x0C, 0xC0, 0x97, 0x75, 0x07, 0xC0, 0xE0, 0xCC, 0x09, 0x77,
  0x50, 0x7D, 0x0C, 0xC0, 0x97, 0x75, 0x06, 0xD0, 0xCC, 0x09, 0x77, 0x50, 0x7D, 0x0B, 0xC0, 0xA7,
  0x75, 0x07, 0xC0, 0xE0, 0xAC, 0x0A, 0x77, 0x50, 0x8C, 0x0E, 0x09, 0xC0, 0xB7, 0x75, 0x09, 0xC0,
  0xC0, 0x7C, 0x0D, 0x77, 0x50, 0xAC, 0x0A, 0x05, 0xD7, 0x75, 0x0C, 0xC0, 0x90, 0x3D, 0x02, 0x77,
  0x40, 0xEC, 0x06, 0x1D, 0x04, 0x77, 0x30, 0x2D, 0x81, 0x30, 0xCC, 0x08, 0x77, 0x30, 0x5D, 0x20,
  0x8C, 0x0C, 0x77, 0x30, 0xAC, 0x0B, 0x20, 0x4D, 0x02, 0x77, 0x20, 0xEC, 0x07, 0x30, 0xDC, 0x09,
  0x77, 0x10, 0x6D, 0x01, 0x30, 0x8C, 0x0E, 0x01, 0x77, 0x0D, 0xC0, 0xB4, 0x01, 0x0E, 0xC0, 0x97,
  0x60, 0x7D, 0x04, 0x50, 0x8D, 0x06, 0x74, 0x04, 0xD0, 0xB7, 0x0D, 0xD0, 0x77, 0x20, 0x5D, 0x0E,
  0x02, 0x70, 0x3E, 0x81, 0xC5, 0x14, 0x04, 0x0B, 0xE0, 0x57, 0x20, 0x5F, 0x90, 0xFD, 0xF9, 0x07,
  0x74, 0x04, 0x0E, 0xFF, 0xA0, 0x77, 0x60, 0x20, 0xBF, 0xE0, 0xD0, 0x37, 0x72, 0x81, 0x4A, 0xEF,
  0x90, 0xB0, 0x57, 0x77, 0x85, 0x35, 0x67, 0x65, 0x37, 0x50,
  // "×" (U+00D7)
  0x20, 0x10, 0x87, 0x72, 0x07, 0x05, 0x38, 0x21, 0xDF, 0x97, 0x70, 0x7A, 0x82, 0x50, 0x1C, 0xB0,
  0x97, 0x50, 0x7C, 0x81, 0x62, 0xEC, 0x09, 0x73, 0x07, 0xD8, 0x25, 0x02, 0xEC, 0x09, 0x71, 0x07,
  0xD0, 0x53, 0x02, 0x0E, 0xC0, 0x96, 0x07, 0xD0, 0x55, 0x02, 0x0E, 0xC0, 0x94, 0x07, 0xD0, 0x57,
  0x02, 0x0E, 0xC0, 0x92, 0x07, 0xD0, 0x57, 0x20, 0x20, 0xEC, 0x09, 0x07, 0xD0, 0x57, 0x40, 0x20,
  0xEF, 0xA0, 0x57, 0x60, 0x20, 0xEF, 0x05, 0x77, 0x10, 0x20, 0xED, 0x06, 0x77, 0x20, 0x7E, 0x0A,
  0x77, 0x10, 0x7F, 0x90, 0xA7, 0x60, 0x7D, 0x0E, 0xC0, 0xA7, 0x40, 0x6D, 0x81, 0x53, 0xEC, 0x0A,
  0x72, 0x06, 0xD0, 0x52, 0x03, 0x0E, 0xC0, 0xA7, 0x06, 0xD0, 0x54, 0x03, 0x0E, 0xC0, 0xA5, 0x06,
  0xD0, 0x56, 0x02, 0x0E, 0xC0, 0xA3, 0x06, 0xD0, 0x57, 0x10, 0x20, 0xEC, 0x81, 0xA0, 0x3D, 0x05,
  0x73, 0x02, 0x0E, 0xC8, 0x17, 0x08, 0xB0, 0x57, 0x50, 0x20, 0xDA, 0x0C, 0x38, 0x18, 0xF5, 0x77,
  0x81, 0x2D, 0xC5, 0x03, 0x77, 0x20, 0x20, 0x12,
  // "Ø" (U+00D8)
  0x77, 0x75, 0x81, 0x8C, 0x47, 0x78, 0x53, 0x56, 0x76, 0x53, 0x60, 0x2B, 0x0A, 0x73, 0x05, 0x0B,
  0xF9, 0x81, 0xEA, 0x43, 0x0A, 0xB0, 0xA7, 0x10, 0x40, 0xDF, 0xE8, 0x1C, 0x24, 0xC0, 0x17, 0x08,
  0xFF, 0xB0, 0xDB, 0x08, 0x70, 0x9F, 0x98, 0x1E, 0xDE, 0xFB, 0x0E, 0x70, 0x7E, 0x81, 0xC5, 0x14,
  0x05, 0x0C, 0xF0, 0x66, 0x02, 0xE0, 0x77, 0x20, 0x7E, 0x01, 0x60, 0xBD, 0x05, 0x74, 0x07, 0xD0,
  0xA5, 0x04, 0xD0, 0x97, 0x50, 0x6E, 0x03, 0x40, 0xBC, 0x0E, 0x76, 0x0E, 0xE0, 0xB3, 0x01, 0xD0,
  0x87, 0x50, 0x8F, 0x90, 0x22, 0x06, 0xD0, 0x17, 0x40, 0x2F, 0xA0, 0x72, 0x0A, 0xC0, 0xB7, 0x50,
  0xAB, 0x07, 0x0C, 0xC0, 0xC2, 0x0E, 0xC0, 0x77, 0x40, 0x3B, 0x81, 0xE0, 0x7D, 0x01, 0x02, 0xD0,
  0x37, 0x40, 0xCB, 0x81, 0x60, 0x3D, 0x00, 0x4D, 0x01, 0x73, 0x05, 0xB0, 0xC3, 0xD0, 0x07, 0xC0,
  0xE7, 0x40, 0xDB, 0x04, 0x30, 0xCC, 0x09, 0x08, 0xC0, 0xC7, 0x30, 0x7B, 0x0A, 0x40, 0xAC, 0x0B,
  0x0A, 0xC0, 0xA7, 0x20, 0x10, 0xEB, 0x02, 0x40, 0x9C, 0x0C, 0x0B, 0xC0, 0x97, 0x20, 0x9B, 0x08,
  0x50, 0x7C, 0x0E, 0x0B, 0xC0, 0x97, 0x10, 0x2B, 0x0E, 0x01, 0x50, 0x6C, 0x0E, 0x0C, 0xC0, 0x87,
  0x10, 0xBB, 0x06, 0x60, 0x6D, 0x0C, 0xC0, 0x87, 0x04, 0xB0, 0xD7, 0x05, 0xD0, 0xCC, 0x08, 0x70,
  0xDB, 0x04, 0x70, 0x6D, 0x0B, 0xC0, 0x96, 0x06, 0xB0, 0xB7, 0x10, 0x7C, 0x0E, 0x0B, 0xC0, 0x95,
  0x01, 0x0E, 0xB0, 0x37, 0x10, 0x7C, 0x0E, 0x0A, 0xC0, 0xA5, 0x08, 0xB0, 0x97, 0x20, 0x8C, 0x0D,
  0x08, 0xC0, 0xC4, 0x02, 0xB0, 0xE0, 0x17, 0x20, 0xAC, 0x0B, 0x06, 0xC0, 0xE4, 0x0A, 0xB0, 0x77,
  0x30, 0xCC, 0x09, 0x04, 0xD0, 0x12, 0x03, 0xB0, 0xD7, 0x40, 0xEC, 0x07, 0x01, 0xD0, 0x42, 0x0C,
  0xB0, 0x57, 0x30, 0x1D, 0x81, 0x40, 0xEC, 0x81, 0x80, 0x5B, 0x0C, 0x74, 0x05, 0xD8, 0x11, 0x0A,
  0xC8, 0x1D, 0x0D, 0xB0, 0x37, 0x40, 0x9C, 0x0C, 0x20, 0x5D, 0x0A, 0xB0, 0xA7, 0x50, 0xDC, 0x08,
  0x20, 0x1F, 0xA0, 0x27, 0x40, 0x5D, 0x02, 0x30, 0xAF, 0x08, 0x75, 0x0C, 0xC0, 0xC4, 0x03, 0xE0,
  0xE0, 0x17, 0x40, 0x5D, 0x05, 0x50, 0xBD, 0x09, 0x74, 0x03, 0x0E, 0xC0, 0xC6, 0x02, 0xE0, 0x77,
  0x20, 0x40, 0xED, 0x03, 0x70, 0xDE, 0x81, 0xC5, 0x14, 0x04, 0x0A, 0xE0, 0x77, 0x06, 0xFB, 0x81,
  0xED, 0xDF, 0x90, 0x97, 0x10, 0xEF, 0xFE, 0x08, 0x71, 0x07, 0xB8, 0x1B, 0x3C, 0xFE, 0x0D, 0x04,
  0x71, 0x01, 0x0E, 0xB0, 0x22, 0x04, 0x0A, 0xFA, 0x0B, 0x05, 0x73, 0x09, 0xB0, 0x96, 0x85, 0x35,
  0x67, 0x76, 0x37, 0x78, 0x27, 0xEE, 0x17, 0x77, 0x70, 0x10, 0x37, 0x77, 0x50,
  // "Ù" (U+00D9)
  0x50, 0x48, 0x01, 0x70, 0x37, 0x76, 0x04, 0xD0, 0xD7, 0x77, 0x09, 0xD0, 0x57, 0x77, 0x0B, 0xC0,
  0xD7, 0x77, 0x01, 0x0D, 0xC0, 0x87, 0x77, 0x01, 0x0D, 0xC0, 0x37, 0x77, 0x02, 0x0E, 0xB0, 0xC7,
  0x77, 0x10, 0x20, 0xEB, 0x07, 0x77, 0x71, 0x02, 0x0D, 0xB0, 0x37, 0x77, 0x10, 0x20, 0xDA, 0x0B,
  0x80, 0x9E, 0x20, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09,
  0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97,
  0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0,
  0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09,
  0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C,
  0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0,
  0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08,
  0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C,
  0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10,
  0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08,
  0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71,
  0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90,
  0x8C, 0x09, 0x77, 0x10, 0x9C, 0x08, 0x07, 0xC0, 0xA7, 0x71, 0x09, 0xC0, 0x70, 0x6C, 0x0B, 0x77,
  0x10, 0xAC, 0x06, 0x04, 0xC0, 0xD7, 0x71, 0x0D, 0xC0, 0x50, 0x1D, 0x01, 0x77, 0xD8, 0x12, 0x0D,
  0xC0, 0x67, 0x60, 0x5C, 0x0E, 0x20, 0x9C, 0x0C, 0x76, 0x0B, 0xC0, 0xA2, 0x03, 0xD0, 0x77, 0x40,
  0x5D, 0x04, 0x30, 0xBD, 0x07, 0x72, 0x04, 0xD0, 0xD4, 0x02, 0xE8, 0x1C, 0x51, 0x40, 0x40, 0xAE,
  0x03, 0x50, 0x6F, 0x98, 0x1E, 0xDD, 0xF9, 0x08, 0x70, 0x6F, 0xFB, 0x08, 0x72, 0x04, 0x0D, 0xFE,
  0x0E, 0x05, 0x75, 0x05, 0x0B, 0xFA, 0x0C, 0x06, 0x77, 0x38, 0x53, 0x56, 0x76, 0x54, 0x73,
  // "Ú" (U+00DA)
  0x77, 0x20, 0x28, 0x01, 0x70, 0x67, 0x76, 0x0A, 0xD0, 0x77, 0x75, 0x03, 0xD0, 0xC7, 0x76, 0x0C,
  0xC0, 0xE0, 0x17, 0x75, 0x06, 0xC0, 0xE0, 0x37, 0x75, 0x01, 0x0E, 0xC0, 0x47, 0x76, 0x0A, 0xC0,
  0x57, 0x76, 0x05, 0xC0, 0x57, 0x76, 0x01, 0x0E, 0xB0, 0x57, 0x77, 0x08, 0xA0, 0xE0, 0x48, 0x09,
  0xE3, 0x00, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C,
  0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10,
  0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08,
  0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71,
  0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90,
  0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77,
  0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09,
  0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97,
  0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0,
  0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09,
  0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C,
  0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0,
  0x97, 0x71, 0x09, 0xC0, 0x80, 0x7C, 0x0A, 0x77, 0x10, 0x9C, 0x07, 0x06, 0xC0, 0xB7, 0x71, 0x0A,
  0xC0, 0x60, 0x4C, 0x0D, 0x77, 0x10, 0xDC, 0x05, 0x01, 0xD0, 0x17, 0x7D, 0x81, 0x20, 0xDC, 0x06,
  0x76, 0x05, 0xC0, 0xE2, 0x09, 0xC0, 0xC7, 0x60, 0xBC, 0x0A, 0x20, 0x3D, 0x07, 0x74, 0x05, 0xD0,
  0x43, 0x0B, 0xD0, 0x77, 0x20, 0x4D, 0x0D, 0x40, 0x2E, 0x81, 0xC5, 0x14, 0x04, 0x0A, 0xE0, 0x35,
  0x06, 0xF9, 0x81, 0xED, 0xDF, 0x90, 0x87, 0x06, 0xFF, 0xB0, 0x87, 0x20, 0x40, 0xDF, 0xE0, 0xE0,
  0x57, 0x50, 0x50, 0xBF, 0xA0, 0xC0, 0x67, 0x73, 0x85, 0x35, 0x67, 0x65, 0x47, 0x30,
  // "Û" (U+00DB)
  0x74, 0x84, 0x57, 0x77, 0x73, 0x77, 0x60, 0x1D, 0x0D, 0x77, 0x60, 0xAE, 0x06, 0x77, 0x40, 0x4F,
  0x0E, 0x02, 0x77, 0x20, 0x10, 0xDB, 0x0C, 0x0E, 0xB0, 0xB7, 0x72, 0x0A, 0xB8, 0x2D, 0x12, 0xEB,
  0x07, 0x77, 0x05, 0xB0, 0xD0, 0x12, 0x03, 0x0E, 0xB0, 0x37, 0x50, 0x20, 0xEA, 0x0D, 0x01, 0x40,
  0x4B, 0x0D, 0x01, 0x74, 0x0D, 0xA0, 0xD0, 0x26, 0x04, 0x0E, 0xA0, 0xB7, 0x30, 0x8A, 0x0D, 0x01,
  0x71, 0x03, 0x0D, 0xA0, 0x68, 0x09, 0xD4, 0x00, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0,
  0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08,
  0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C,
  0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10,
  0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08,
  0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71,
  0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90,
  0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77,
  0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09,
  0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97,
  0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0,
  0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09,
  0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x09, 0xC0, 0x80, 0x7C, 0x0A, 0x77, 0x10, 0x9C,
  0x07, 0x06, 0xC0, 0xB7, 0x71, 0x0A, 0xC0, 0x60, 0x4C, 0x0D, 0x77, 0x10, 0xDC, 0x05, 0x01, 0xD0,
  0x17, 0x7D, 0x81, 0x20, 0xDC, 0x06, 0x76, 0x05, 0xC0, 0xE2, 0x09, 0xC0, 0xC7, 0x60, 0xBC, 0x0A,
  0x20, 0x3D, 0x07, 0x74, 0x05, 0xD0, 0x43, 0x0B, 0xD0, 0x77, 0x20, 0x4D, 0x0D, 0x40, 0x2E, 0x81,
  0xC5, 0x14, 0x04, 0x0A, 0xE0, 0x35, 0x06, 0xF9, 0x81, 0xED, 0xDF, 0x90, 0x87, 0x06, 0xFF, 0xB0,
  0x87, 0x20, 0x40, 0xDF, 0xE0, 0xE0, 0x57, 0x50, 0x50, 0xBF, 0xA0, 0xC0, 0x67, 0x73, 0x85, 0x35,
  0x67, 0x65, 0x47, 0x30,
  // "Ü" (U+00DC)
  0x68, 0x27, 0xDE, 0x86, 0x83, 0x4D, 0xEA, 0x17, 0x40, 0x3C, 0x06, 0x40, 0x10, 0xEB, 0x09, 0x74,
  0x07, 0xC0, 0x94, 0x04, 0xC0, 0xD7, 0x40, 0x7C, 0x09, 0x40, 0x4C, 0x0D, 0x74, 0x03, 0xC0, 0x54,
  0x01, 0x0E, 0xB0, 0x97, 0x58, 0x26, 0xDE, 0x86, 0x82, 0x4D, 0xEA, 0x80, 0x9D, 0x70, 0x08, 0xC0,
  0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08,
  0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C,
  0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10,
  0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08,
  0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71,
  0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90,
  0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77,
  0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09,
  0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97,
  0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0,
  0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09,
  0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x9C,
  0x08, 0x07, 0xC0, 0xA7, 0x71, 0x09, 0xC0, 0x70, 0x6C, 0x0B, 0x77, 0x10, 0xAC, 0x06, 0x04, 0xC0,
  0xD7, 0x71, 0x0D, 0xC0, 0x50, 0x1D, 0x01, 0x77, 0xD8, 0x12, 0x0D, 0xC0, 0x67, 0x60, 0x5C, 0x0E,
  0x20, 0x9C, 0x0C, 0x76, 0x0B, 0xC0, 0xA2, 0x03, 0xD0, 0x77, 0x40, 0x5D, 0x04, 0x30, 0xBD, 0x07,
  0x72, 0x04, 0xD0, 0xD4, 0x02, 0xE8, 0x1C, 0x51, 0x40, 0x40, 0xAE, 0x03, 0x50, 0x6F, 0x98, 0x1E,
  0xDD, 0xF9, 0x08, 0x70, 0x6F, 0xFB, 0x08, 0x72, 0x04, 0x0D, 0xFE, 0x0E, 0x05, 0x75, 0x05, 0x0B,
  0xFA, 0x0C, 0x06, 0x77, 0x38, 0x53, 0x56, 0x76, 0x54, 0x73,
  // "Ý" (U+00DD)
  0x77, 0x20, 0x28, 0x01, 0x70, 0x67, 0x76, 0x0A, 0xD0, 0x77, 0x75, 0x03, 0xD0, 0xC7, 0x76, 0x0C,
  0xC0, 0xE0, 0x17, 0x75, 0x06, 0xC0, 0xE0, 0x37, 0x75, 0x01, 0x0E, 0xC0, 0x47, 0x76, 0x0A, 0xC0,
  0x57, 0x76, 0x05, 0xC0, 0x57, 0x76, 0x01, 0x0E, 0xB0, 0x57, 0x77, 0x08, 0xA0, 0xE0, 0x48, 0x09,
  0xE3, 0x00, 0xCC, 0x0A, 0x77, 0x10, 0xEC, 0x00, 0x6D, 0x01, 0x76, 0x05, 0xC8, 0x2E, 0x10, 0xEC,
  0x06, 0x76, 0x0B, 0xC0, 0x92, 0x09, 0xC0, 0xC7, 0x50, 0x1D, 0x03, 0x20, 0x2D, 0x03, 0x74, 0x07,
  0xC0, 0xC4, 0x0C, 0xC0, 0x97, 0x40, 0xDC, 0x06, 0x40, 0x5C, 0x0E, 0x73, 0x04, 0xC0, 0xE6, 0x0E,
  0xC0, 0x57, 0x20, 0xAC, 0x09, 0x60, 0x9C, 0x0B, 0x71, 0x01, 0xD0, 0x36, 0x02, 0xD0, 0x27, 0x06,
  0xC0, 0xC7, 0x10, 0xCC, 0x08, 0x70, 0xCC, 0x05, 0x71, 0x05, 0xC0, 0xD6, 0x03, 0xC0, 0xE7, 0x30,
  0xEC, 0x04, 0x50, 0x9C, 0x08, 0x73, 0x08, 0xC0, 0xA5, 0x0E, 0xC0, 0x27, 0x30, 0x2D, 0x01, 0x30,
  0x5C, 0x0B, 0x75, 0x0B, 0xC0, 0x73, 0x0B, 0xC0, 0x57, 0x50, 0x5C, 0x0D, 0x20, 0x1C, 0x0E, 0x77,
  0x0E, 0xC8, 0x13, 0x07, 0xC0, 0x87, 0x70, 0x8C, 0x81, 0x90, 0xDC, 0x02, 0x77, 0x02, 0xC0, 0xE0,
  0x5C, 0x0B, 0x77, 0x20, 0xBC, 0x0E, 0xC0, 0x57, 0x72, 0x05, 0xF9, 0x0E, 0x77, 0x40, 0xEF, 0x08,
  0x77, 0x40, 0x8F, 0x01, 0x77, 0x40, 0x2E, 0x0B, 0x77, 0x60, 0xBD, 0x04, 0x77, 0x60, 0x5C, 0x0E,
  0x77, 0x70, 0x4C, 0x0E, 0x77, 0x70, 0x4C, 0x0E, 0x77, 0x70, 0x4C, 0x0E, 0x77, 0x70, 0x4C, 0x0E,
  0x77, 0x70, 0x4C, 0x0E, 0x77, 0x70, 0x4C, 0x0E, 0x77, 0x70, 0x4C, 0x0E, 0x77, 0x70, 0x4C, 0x0E,
  0x77, 0x70, 0x4C, 0x0E, 0x77, 0x70, 0x4C, 0x0E, 0x77, 0x70, 0x4C, 0x0E, 0x77, 0x70, 0x4C, 0x0E,
  0x77, 0x70, 0x4C, 0x0E, 0x77, 0x70, 0x4C, 0x0E, 0x77, 0x70, 0x4C, 0x0E, 0x77, 0x70, 0x4C, 0x0E,
  0x74,
  // "Þ" (U+00DE)
  0x03, 0xC0, 0xE7, 0x74, 0x03, 0xC0, 0xE7, 0x74, 0x03, 0xC0, 0xE7, 0x74, 0x03, 0xC0, 0xE7, 0x74,
  0x03, 0xC0, 0xE7, 0x74, 0x03, 0xC0, 0xE7, 0x74, 0x03, 0xC0, 0xE7, 0x74, 0x03, 0xD8, 0x00, 0x58,
  0x14, 0x32, 0x74, 0x03, 0xFE, 0x81, 0xC9, 0x37, 0x03, 0xFF, 0xA0, 0xC0, 0x45, 0x03, 0xFF, 0xC0,
  0x84, 0x03, 0xFF, 0xD0, 0x73, 0x03, 0xC0, 0xE4, 0x83, 0x12, 0x59, 0xEE, 0x04, 0x20, 0x3C, 0x0E,
  0x71, 0x01, 0x0A, 0xD0, 0xC2, 0x03, 0xC0, 0xE7, 0x30, 0xAD, 0x81, 0x40, 0x3C, 0x0E, 0x73, 0x01,
  0xD8, 0x18, 0x03, 0xC0, 0xE7, 0x40, 0x9C, 0x81, 0xC0, 0x3C, 0x0E, 0x74, 0x05, 0xC8, 0x1E, 0x03,
  0xC0, 0xE7, 0x40, 0x3D, 0x10, 0x3C, 0x0E, 0x74, 0x02, 0xD0, 0x10, 0x3C, 0x0E, 0x74, 0x01, 0xD0,
  0x10, 0x3C, 0x0E, 0x74, 0x02, 0xD1, 0x03, 0xC0, 0xE7, 0x40, 0x4C, 0x81, 0xE0, 0x3C, 0x0E, 0x74,
  0x07, 0xC8, 0x1C, 0x03, 0xC0, 0xE7, 0x40, 0xCC, 0x81, 0x80, 0x3C, 0x0E, 0x73, 0x03, 0xD8, 0x14,
  0x03, 0xC0, 0xE7, 0x30, 0xDC, 0x0D, 0x20, 0x3C, 0x0E, 0x71, 0x02, 0x0C, 0xD0, 0x62, 0x03, 0xC0,
  0xE4, 0x82, 0x13, 0x6B, 0xE0, 0xC3, 0x03, 0xFF, 0xC0, 0xE0, 0x13, 0x03, 0xFF, 0xB0, 0xD0, 0x24,
  0x03, 0xFF, 0x90, 0xE0, 0x86, 0x03, 0xFD, 0x82, 0xEB, 0x61, 0x70, 0x3D, 0x80, 0x05, 0x81, 0x43,
  0x17, 0x40, 0x3C, 0x0E, 0x77, 0x40, 0x3C, 0x0E, 0x77, 0x40, 0x3C, 0x0E, 0x77, 0x40, 0x3C, 0x0E,
  0x77, 0x40, 0x3C, 0x0E, 0x77, 0x40, 0x3C, 0x0E, 0x77, 0x40, 0x3C, 0x0E, 0x77, 0x40, 0x3C, 0x0E,
  0x77, 0x40, 0x3C, 0x0E, 0x77, 0x40,
  // "ß" (U+00DF)
  0x71, 0x84, 0x13, 0x44, 0x32, 0x77, 0x28, 0x11, 0x7C, 0xE8, 0x1E, 0xA4, 0x75, 0x06, 0x0E, 0xFC,
  0x0B, 0x02, 0x72, 0x09, 0xFF, 0x0E, 0x02, 0x70, 0x7F, 0xFA, 0x0D, 0x60, 0x3E, 0x08, 0x03, 0x28,
  0x12, 0x6D, 0xD0, 0x75, 0x0A, 0xC0, 0xE0, 0x36, 0x01, 0x0C, 0xC0, 0xC4, 0x01, 0xD0, 0x47, 0x10,
  0x3D, 0x01, 0x30, 0x4C, 0x0C, 0x73, 0x0D, 0xC0, 0x33, 0x08, 0xC0, 0x87, 0x30, 0xBC, 0x04, 0x30,
  0x9C, 0x05, 0x73, 0x0C, 0xC0, 0x33, 0x0A, 0xC0, 0x47, 0x30, 0xEC, 0x01, 0x30, 0xBC, 0x03, 0x72,
  0x04, 0xC0, 0xC4, 0x0B, 0xC0, 0x37, 0x20, 0xCC, 0x06, 0x40, 0xBC, 0x03, 0x71, 0x08, 0xC0, 0xC5,
  0x0B, 0xC0, 0x37, 0x06, 0xC0, 0xE0, 0x35, 0x0B, 0xC0, 0x36, 0x05, 0xD0, 0x56, 0x0B, 0xC0, 0x35,
  0x03, 0xD0, 0x67, 0x0B, 0xC0, 0x35, 0x0D, 0xC0, 0x87, 0x10, 0xBC, 0x03, 0x40, 0x6C, 0x0B, 0x72,
  0x0B, 0xC0, 0x34, 0x0B, 0xC0, 0x37, 0x20, 0xBC, 0x03, 0x40, 0xDC, 0x73, 0x0B, 0xC0, 0x34, 0x0E,
  0xC7, 0x30, 0xBC, 0x03, 0x40, 0xDC, 0x04, 0x72, 0x0B, 0xC0, 0x34, 0x09, 0xC0, 0xB7, 0x20, 0xBC,
  0x03, 0x40, 0x4D, 0x08, 0x71, 0x0B, 0xC0, 0x35, 0x0C, 0xD0, 0x77, 0x0B, 0xC0, 0x35, 0x02, 0xE0,
  0x86, 0x0B, 0xC0, 0x36, 0x05, 0xE0, 0x95, 0x0B, 0xC0, 0x37, 0x06, 0xE0, 0x94, 0x0B, 0xC0, 0x37,
  0x10, 0x6E, 0x08, 0x30, 0xBC, 0x03, 0x72, 0x05, 0xE0, 0x52, 0x0B, 0xC0, 0x37, 0x30, 0x4D, 0x82,
  0xE1, 0x0B, 0xC0, 0x37, 0x40, 0x5D, 0x81, 0x80, 0xBC, 0x03, 0x75, 0x09, 0xC8, 0x1E, 0x0B, 0xC0,
  0x37, 0x50, 0x1D, 0x03, 0x0B, 0xC0, 0x37, 0x60, 0xBC, 0x05, 0x0B, 0xC0, 0x37, 0x60, 0x9C, 0x06,
  0x0B, 0xC0, 0x37, 0x60, 0x8C, 0x05, 0x0B, 0xC0, 0x37, 0x60, 0xAC, 0x04, 0x0B, 0xC0, 0x37, 0x60,
  0xEC, 0x02, 0x0B, 0xC0, 0x32, 0x08, 0x05, 0x71, 0x07, 0xC8, 0x1E, 0x0B, 0xC0, 0x32, 0x83, 0xAF,
  0xD6, 0x13, 0x01, 0x08, 0xD8, 0x18, 0x0B, 0xC0, 0x32, 0x0A, 0xC8, 0x1E, 0xDD, 0xE8, 0x2E, 0x10,
  0xBC, 0x03, 0x20, 0xAF, 0xE0, 0x42, 0x0B, 0xC0, 0x32, 0x0A, 0xFC, 0x0E, 0x05, 0x30, 0xBC, 0x03,
  0x30, 0x60, 0xCF, 0x81, 0xE9, 0x27, 0x71, 0x85, 0x14, 0x67, 0x76, 0x37,
  // "à" (U+00E0)
  0x40, 0x48, 0x01, 0x70, 0x37, 0x71, 0x04, 0xD0, 0xD7, 0x72, 0x09, 0xD0, 0x57, 0x72, 0x0B, 0xC0,
  0xD7, 0x72, 0x01, 0x0D, 0xC0, 0x87, 0x72, 0x01, 0x0D, 0xC0, 0x37, 0x72, 0x02, 0x0E, 0xB0, 0xC7,
  0x73, 0x02, 0x0E, 0xB0, 0x77, 0x73, 0x02, 0x0D, 0xB0, 0x37, 0x73, 0x02, 0x0D, 0xA0, 0xB8, 0x09,
  0xC2, 0x08, 0x51, 0x45, 0x77, 0x64, 0x75, 0x81, 0x28, 0xDF, 0x90, 0xB0, 0x37, 0x02, 0x0A, 0xFE,
  0x07, 0x60, 0xDF, 0xF9, 0x06, 0x50, 0x6E, 0x81, 0xED, 0xEE, 0x0E, 0x01, 0x58, 0x3E, 0xFD, 0x83,
  0x40, 0x20, 0x9D, 0x07, 0x50, 0x60, 0x57, 0x20, 0x9C, 0x0C, 0x77, 0x20, 0x1D, 0x77, 0x30, 0xBC,
  0x03, 0x77, 0x20, 0x8C, 0x05, 0x77, 0x20, 0x7C, 0x06, 0x77, 0x20, 0x7C, 0x06, 0x77, 0x20, 0x7C,
  0x07, 0x68, 0x41, 0x69, 0xCD, 0xEF, 0xA0, 0x74, 0x01, 0x09, 0xFF, 0x90, 0x73, 0x05, 0x0E, 0xFF,
  0xA0, 0x72, 0x05, 0xFF, 0xC8, 0x17, 0x02, 0xE8, 0x2D, 0x73, 0x14, 0x07, 0xC8, 0x17, 0x0A, 0xD0,
  0x77, 0x10, 0x7C, 0x07, 0x01, 0xD0, 0x87, 0x20, 0x7C, 0x07, 0x05, 0xC0, 0xE7, 0x30, 0x7C, 0x07,
  0x08, 0xC0, 0x97, 0x30, 0x8C, 0x07, 0x09, 0xC0, 0x77, 0x30, 0x9C, 0x07, 0x0A, 0xC0, 0x67, 0x30,
  0xCC, 0x07, 0x0A, 0xC0, 0x67, 0x20, 0x1D, 0x07, 0x09, 0xC0, 0x87, 0x20, 0x7D, 0x07, 0x06, 0xC0,
  0xD7, 0x10, 0x20, 0xED, 0x07, 0x02, 0xD0, 0x66, 0x01, 0x0D, 0xE8, 0x17, 0x0C, 0xD0, 0x73, 0x81,
  0x16, 0xEA, 0x09, 0xC8, 0x17, 0x05, 0xF0, 0x0D, 0xC8, 0x1D, 0x0D, 0xB0, 0x72, 0x0B, 0xFC, 0x82,
  0xE2, 0x0B, 0xB0, 0x73, 0x0C, 0xFA, 0x0E, 0x03, 0x20, 0x8B, 0x07, 0x40, 0x80, 0xED, 0x81, 0xE9,
  0x13, 0x06, 0xB0, 0x76, 0x83, 0x46, 0x76, 0x47, 0x40,
  // "á" (U+00E1)
  0x76, 0x02, 0x80, 0x17, 0x06, 0x77, 0x10, 0xAD, 0x07, 0x77, 0x03, 0xD0, 0xC7, 0x71, 0x0C, 0xC0,
  0xE0, 0x17, 0x70, 0x6C, 0x0E, 0x03, 0x77, 0x01, 0x0E, 0xC0, 0x47, 0x71, 0x0A, 0xC0, 0x57, 0x71,
  0x05, 0xC0, 0x57, 0x71, 0x01, 0x0E, 0xB0, 0x57, 0x72, 0x08, 0xA0, 0xE0, 0x48, 0x09, 0xC5, 0x08,
  0x51, 0x45, 0x77, 0x64, 0x75, 0x81, 0x28, 0xDF, 0x90, 0xB0, 0x37, 0x02, 0x0A, 0xFE, 0x07, 0x60,
  0xDF, 0xF9, 0x06, 0x50, 0x6E, 0x81, 0xED, 0xEE, 0x0E, 0x01, 0x58, 0x3E, 0xFD, 0x83, 0x40, 0x20,
  0x9D, 0x07, 0x50, 0x60, 0x57, 0x20, 0x9C, 0x0C, 0x77, 0x20, 0x1D, 0x77, 0x30, 0xBC, 0x03, 0x77,
  0x20, 0x8C, 0x05, 0x77, 0x20, 0x7C, 0x06, 0x77, 0x20, 0x7C, 0x06, 0x77, 0x20, 0x7C, 0x07, 0x68,
  0x41, 0x69, 0xCD, 0xEF, 0xA0, 0x74, 0x01, 0x09, 0xFF, 0x90, 0x73, 0x05, 0x0E, 0xFF, 0xA0, 0x72,
  0x05, 0xFF, 0xC8, 0x17, 0x02, 0xE8, 0x2D, 0x73, 0x14, 0x07, 0xC8, 0x17, 0x0A, 0xD0, 0x77, 0x10,
  0x7C, 0x07, 0x01, 0xD0, 0x87, 0x20, 0x7C, 0x07, 0x05, 0xC0, 0xE7, 0x30, 0x7C, 0x07, 0x08, 0xC0,
  0x97, 0x30, 0x8C, 0x07, 0x09, 0xC0, 0x77, 0x30, 0x9C, 0x07, 0x0A, 0xC0, 0x67, 0x30, 0xCC, 0x07,
  0x0A, 0xC0, 0x67, 0x20, 0x1D, 0x07, 0x09, 0xC0, 0x87, 0x20, 0x7D, 0x07, 0x06, 0xC0, 0xD7, 0x10,
  0x20, 0xED, 0x07, 0x02, 0xD0, 0x66, 0x01, 0x0D, 0xE8, 0x17, 0x0C, 0xD0, 0x73, 0x81, 0x16, 0xEA,
  0x09, 0xC8, 0x17, 0x05, 0xF0, 0x0D, 0xC8, 0x1D, 0x0D, 0xB0, 0x72, 0x0B, 0xFC, 0x82, 0xE2, 0x0B,
  0xB0, 0x73, 0x0C, 0xFA, 0x0E, 0x03, 0x20, 0x8B, 0x07, 0x40, 0x80, 0xED, 0x81, 0xE9, 0x13, 0x06,
  0xB0, 0x76, 0x83, 0x46, 0x76, 0x47, 0x40,
  // "â" (U+00E2)
  0x72, 0x84, 0x57, 0x77, 0x73, 0x77, 0x10, 0x1D, 0x0D, 0x77, 0x10, 0xAE, 0x06, 0x76, 0x04, 0xF0,
  0xE0, 0x27, 0x40, 0x10, 0xDB, 0x0C, 0x0E, 0xB0, 0xB7, 0x40, 0xAB, 0x82, 0xD1, 0x2E, 0xB0, 0x77,
  0x20, 0x5B, 0x0D, 0x01, 0x20, 0x30, 0xEB, 0x03, 0x70, 0x20, 0xEA, 0x0D, 0x01, 0x40, 0x4B, 0x0D,
  0x01, 0x60, 0xDA, 0x0D, 0x02, 0x60, 0x40, 0xEA, 0x0B, 0x50, 0x8A, 0x0D, 0x01, 0x71, 0x03, 0x0D,
  0xA0, 0x68, 0x09, 0xB5, 0x08, 0x51, 0x45, 0x77, 0x64, 0x75, 0x81, 0x28, 0xDF, 0x90, 0xB0, 0x37,
  0x02, 0x0A, 0xFE, 0x07, 0x60, 0xDF, 0xF9, 0x06, 0x50, 0x6E, 0x81, 0xED, 0xEE, 0x0E, 0x01, 0x58,
  0x3E, 0xFD, 0x83, 0x40, 0x20, 0x9D, 0x07, 0x50, 0x60, 0x57, 0x20, 0x9C, 0x0C, 0x77, 0x20, 0x1D,
  0x77, 0x30, 0xBC, 0x03, 0x77, 0x20, 0x8C, 0x05, 0x77, 0x20, 0x7C, 0x06, 0x77, 0x20, 0x7C, 0x06,
  0x77, 0x20, 0x7C, 0x07, 0x68, 0x41, 0x69, 0xCD, 0xEF, 0xA0, 0x74, 0x01, 0x09, 0xFF, 0x90, 0x73,
  0x05, 0x0E, 0xFF, 0xA0, 0x72, 0x05, 0xFF, 0xC8, 0x17, 0x02, 0xE8, 0x2D, 0x73, 0x14, 0x07, 0xC8,
  0x17, 0x0A, 0xD0, 0x77, 0x10, 0x7C, 0x07, 0x01, 0xD0, 0x87, 0x20, 0x7C, 0x07, 0x05, 0xC0, 0xE7,
  0x30, 0x7C, 0x07, 0x08, 0xC0, 0x97, 0x30, 0x8C, 0x07, 0x09, 0xC0, 0x77, 0x30, 0x9C, 0x07, 0x0A,
  0xC0, 0x67, 0x30, 0xCC, 0x07, 0x0A, 0xC0, 0x67, 0x20, 0x1D, 0x07, 0x09, 0xC0, 0x87, 0x20, 0x7D,
  0x07, 0x06, 0xC0, 0xD7, 0x10, 0x20, 0xED, 0x07, 0x02, 0xD0, 0x66, 0x01, 0x0D, 0xE8, 0x17, 0x0C,
  0xD0, 0x73, 0x81, 0x16, 0xEA, 0x09, 0xC8, 0x17, 0x05, 0xF0, 0x0D, 0xC8, 0x1D, 0x0D, 0xB0, 0x72,
  0x0B, 0xFC, 0x82, 0xE2, 0x0B, 0xB0, 0x73, 0x0C, 0xFA, 0x0E, 0x03, 0x20, 0x8B, 0x07, 0x40, 0x80,
  0xED, 0x81, 0xE9, 0x13, 0x06, 0xB0, 0x76, 0x83, 0x46, 0x76, 0x47, 0x40,
  // "ã" (U+00E3)
  0x58, 0x45, 0xCE, 0xEB, 0x67, 0x0B, 0xA0, 0x54, 0x08, 0xE0, 0xE0, 0x74, 0x03, 0xB0, 0x33, 0x03,
  0xFA, 0x83, 0xE9, 0x66, 0xEA, 0x0E, 0x40, 0xAF, 0xFA, 0x09, 0x30, 0x1B, 0x82, 0xD6, 0x6A, 0xFB,
  0x02, 0x30, 0x4A, 0x0E, 0x01, 0x30, 0x10, 0x9F, 0x06, 0x40, 0x7A, 0x09, 0x68, 0x51, 0x7C, 0xEE,
  0xB4, 0x80, 0x9B, 0x70, 0x85, 0x14, 0x57, 0x76, 0x47, 0x58, 0x12, 0x8D, 0xF9, 0x0B, 0x03, 0x70,
  0x20, 0xAF, 0xE0, 0x76, 0x0D, 0xFF, 0x90, 0x65, 0x06, 0xE8, 0x1E, 0xDE, 0xE0, 0xE0, 0x15, 0x83,
  0xEF, 0xD8, 0x34, 0x02, 0x09, 0xD0, 0x75, 0x06, 0x05, 0x72, 0x09, 0xC0, 0xC7, 0x72, 0x01, 0xD7,
  0x73, 0x0B, 0xC0, 0x37, 0x72, 0x08, 0xC0, 0x57, 0x72, 0x07, 0xC0, 0x67, 0x72, 0x07, 0xC0, 0x67,
  0x72, 0x07, 0xC0, 0x76, 0x84, 0x16, 0x9C, 0xDE, 0xFA, 0x07, 0x40, 0x10, 0x9F, 0xF9, 0x07, 0x30,
  0x50, 0xEF, 0xFA, 0x07, 0x20, 0x5F, 0xFC, 0x81, 0x70, 0x2E, 0x82, 0xD7, 0x31, 0x40, 0x7C, 0x81,
  0x70, 0xAD, 0x07, 0x71, 0x07, 0xC0, 0x70, 0x1D, 0x08, 0x72, 0x07, 0xC0, 0x70, 0x5C, 0x0E, 0x73,
  0x07, 0xC0, 0x70, 0x8C, 0x09, 0x73, 0x08, 0xC0, 0x70, 0x9C, 0x07, 0x73, 0x09, 0xC0, 0x70, 0xAC,
  0x06, 0x73, 0x0C, 0xC0, 0x70, 0xAC, 0x06, 0x72, 0x01, 0xD0, 0x70, 0x9C, 0x08, 0x72, 0x07, 0xD0,
  0x70, 0x6C, 0x0D, 0x71, 0x02, 0x0E, 0xD0, 0x70, 0x2D, 0x06, 0x60, 0x10, 0xDE, 0x81, 0x70, 0xCD,
  0x07, 0x38, 0x11, 0x6E, 0xA0, 0x9C, 0x81, 0x70, 0x5F, 0x00, 0xDC, 0x81, 0xD0, 0xDB, 0x07, 0x20,
  0xBF, 0xC8, 0x2E, 0x20, 0xBB, 0x07, 0x30, 0xCF, 0xA0, 0xE0, 0x32, 0x08, 0xB0, 0x74, 0x08, 0x0E,
  0xD8, 0x1E, 0x91, 0x30, 0x6B, 0x07, 0x68, 0x34, 0x67, 0x64, 0x74,
  // "ä" (U+00E4)
  0x58, 0x27, 0xDE, 0x86, 0x83, 0x4D, 0xEA, 0x16, 0x03, 0xC0, 0x64, 0x01, 0x0E, 0xB0, 0x96, 0x07,
  0xC0, 0x94, 0x04, 0xC0, 0xD6, 0x07, 0xC0, 0x94, 0x04, 0xC0, 0xD6, 0x03, 0xC0, 0x54, 0x01, 0x0E,
  0xB0, 0x97, 0x82, 0x6D, 0xE8, 0x68, 0x24, 0xDE, 0xA8, 0x09, 0xB7, 0x08, 0x51, 0x45, 0x77, 0x64,
  0x75, 0x81, 0x28, 0xDF, 0x90, 0xB0, 0x37, 0x02, 0x0A, 0xFE, 0x07, 0x60, 0xDF, 0xF9, 0x06, 0x50,
  0x6E, 0x81, 0xED, 0xEE, 0x0E, 0x01, 0x58, 0x3E, 0xFD, 0x83, 0x40, 0x20, 0x9D, 0x07, 0x50, 0x60,
  0x57, 0x20, 0x9C, 0x0C, 0x77, 0x20, 0x1D, 0x77, 0x30, 0xBC, 0x03, 0x77, 0x20, 0x8C, 0x05, 0x77,
  0x20, 0x7C, 0x06, 0x77, 0x20, 0x7C, 0x06, 0x77, 0x20, 0x7C, 0x07, 0x68, 0x41, 0x69, 0xCD, 0xEF,
  0xA0, 0x74, 0x01, 0x09, 0xFF, 0x90, 0x73, 0x05, 0x0E, 0xFF, 0xA0, 0x72, 0x05, 0xFF, 0xC8, 0x17,
  0x02, 0xE8, 0x2D, 0x73, 0x14, 0x07, 0xC8, 0x17, 0x0A, 0xD0, 0x77, 0x10, 0x7C, 0x07, 0x01, 0xD0,
  0x87, 0x20, 0x7C, 0x07, 0x05, 0xC0, 0xE7, 0x30, 0x7C, 0x07, 0x08, 0xC0, 0x97, 0x30, 0x8C, 0x07,
  0x09, 0xC0, 0x77, 0x30, 0x9C, 0x07, 0x0A, 0xC0, 0x67, 0x30, 0xCC, 0x07, 0x0A, 0xC0, 0x67, 0x20,
  0x1D, 0x07, 0x09, 0xC0, 0x87, 0x20, 0x7D, 0x07, 0x06, 0xC0, 0xD7, 0x10, 0x20, 0xED, 0x07, 0x02,
  0xD0, 0x66, 0x01, 0x0D, 0xE8, 0x17, 0x0C, 0xD0, 0x73, 0x81, 0x16, 0xEA, 0x09, 0xC8, 0x17, 0x05,
  0xF0, 0x0D, 0xC8, 0x1D, 0x0D, 0xB0, 0x72, 0x0B, 0xFC, 0x82, 0xE2, 0x0B, 0xB0, 0x73, 0x0C, 0xFA,
  0x0E, 0x03, 0x20, 0x8B, 0x07, 0x40, 0x80, 0xED, 0x81, 0xE9, 0x13, 0x06, 0xB0, 0x76, 0x83, 0x46,
  0x76, 0x47, 0x40,
  // "å" (U+00E5)
  0x71, 0x86, 0x4A, 0xDF, 0xEC, 0x71, 0x76, 0x09, 0xF0, 0xE0, 0x47, 0x40, 0x8C, 0x0E, 0xC0, 0xE0,
  0x27, 0x20, 0x1B, 0x0B, 0x02, 0x20, 0x50, 0xEA, 0x0B, 0x72, 0x06, 0xA0, 0xD5, 0x05, 0xB7, 0x20,
  0x8A, 0x09, 0x6B, 0x02, 0x71, 0x08, 0xA0, 0x96, 0xB0, 0x27, 0x10, 0x6A, 0x0D, 0x50, 0x5A, 0x0E,
  0x72, 0x02, 0xB8, 0x4B, 0x20, 0x16, 0xEA, 0x0A, 0x73, 0x08, 0xFA, 0x0E, 0x02, 0x74, 0x0A, 0xF0,
  0xE0, 0x47, 0x68, 0x64, 0xAD, 0xFE, 0xC7, 0x18, 0x09, 0xC2, 0x08, 0x51, 0x45, 0x77, 0x64, 0x75,
  0x81, 0x28, 0xDF, 0x90, 0xB0, 0x37, 0x02, 0x0A, 0xFE, 0x07, 0x60, 0xDF, 0xF9, 0x06, 0x50, 0x6E,
  0x81, 0xED, 0xEE, 0x0E, 0x01, 0x58, 0x3E, 0xFD, 0x83, 0x40, 0x20, 0x9D, 0x07, 0x50, 0x60, 0x57,
  0x20, 0x9C, 0x0C, 0x77, 0x20, 0x1D, 0x77, 0x30, 0xBC, 0x03, 0x77, 0x20, 0x8C, 0x05, 0x77, 0x20,
  0x7C, 0x06, 0x77, 0x20, 0x7C, 0x06, 0x77, 0x20, 0x7C, 0x07, 0x68, 0x41, 0x69, 0xCD, 0xEF, 0xA0,
  0x74, 0x01, 0x09, 0xFF, 0x90, 0x73, 0x05, 0x0E, 0xFF, 0xA0, 0x72, 0x05, 0xFF, 0xC8, 0x17, 0x02,
  0xE8, 0x2D, 0x73, 0x14, 0x07, 0xC8, 0x17, 0x0A, 0xD0, 0x77, 0x10, 0x7C, 0x07, 0x01, 0xD0, 0x87,
  0x20, 0x7C, 0x07, 0x05, 0xC0, 0xE7, 0x30, 0x7C, 0x07, 0x08, 0xC0, 0x97, 0x30, 0x8C, 0x07, 0x09,
  0xC0, 0x77, 0x30, 0x9C, 0x07, 0x0A, 0xC0, 0x67, 0x30, 0xCC, 0x07, 0x0A, 0xC0, 0x67, 0x20, 0x1D,
  0x07, 0x09, 0xC0, 0x87, 0x20, 0x7D, 0x07, 0x06, 0xC0, 0xD7, 0x10, 0x20, 0xED, 0x07, 0x02, 0xD0,
  0x66, 0x01, 0x0D, 0xE8, 0x17, 0x0C, 0xD0, 0x73, 0x81, 0x16, 0xEA, 0x09, 0xC8, 0x17, 0x05, 0xF0,
  0x0D, 0xC8, 0x1D, 0x0D, 0xB0, 0x72, 0x0B, 0xFC, 0x82, 0xE2, 0x0B, 0xB0, 0x73, 0x0C, 0xFA, 0x0E,
  0x03, 0x20, 0x8B, 0x07, 0x40, 0x80, 0xED, 0x81, 0xE9, 0x13, 0x06, 0xB0, 0x76, 0x83, 0x46, 0x76,
  0x47, 0x40,
  // "æ" (U+00E6)
  0x71, 0x85, 0x25, 0x67, 0x75, 0x17, 0x38, 0x44, 0x67, 0x64, 0x17, 0x68, 0x14, 0xAE, 0xF0, 0xB0,
  0x35, 0x02, 0x09, 0xF0, 0xA0, 0x37, 0x20, 0x40, 0xDF, 0xD0, 0x63, 0x05, 0x0E, 0xFB, 0x07, 0x70,
  0x2F, 0xF9, 0x81, 0x50, 0x5F, 0xE0, 0x87, 0x0B, 0xE8, 0x1D, 0xDE, 0xD8, 0x1E, 0x2E, 0xD8, 0x1E,
  0xDE, 0xE0, 0x56, 0x04, 0xA8, 0x1C, 0x73, 0x40, 0x50, 0xDC, 0x0E, 0xC0, 0xA0, 0x23, 0x03, 0x0C,
  0xC0, 0xE7, 0x09, 0x04, 0x71, 0x02, 0x0E, 0xF0, 0x87, 0x0B, 0xC0, 0x77, 0x73, 0x07, 0xE0, 0xC7,
  0x10, 0x1C, 0x0D, 0x77, 0x30, 0x2E, 0x05, 0x72, 0x09, 0xC0, 0x37, 0x73, 0x0E, 0xC0, 0xE7, 0x30,
  0x4C, 0x07, 0x77, 0x30, 0xCC, 0x0B, 0x74, 0xC0, 0xA7, 0x73, 0x0C, 0xC0, 0x87, 0x40, 0xDB, 0x0D,
  0x77, 0x30, 0xBC, 0x06, 0x74, 0x0C, 0xC7, 0x38, 0x62, 0x34, 0x55, 0x55, 0xDC, 0x09, 0x80, 0x75,
  0x0C, 0xC6, 0x82, 0x17, 0xBE, 0xFF, 0xFF, 0x90, 0x14, 0x08, 0xFF, 0xFF, 0xD0, 0x12, 0x01, 0x0C,
  0xFF, 0xFF, 0xE0, 0x12, 0x0B, 0xF8, 0x5D, 0xBA, 0xAA, 0xAE, 0xFF, 0xF8, 0x11, 0x06, 0xD8, 0x1E,
  0x61, 0x60, 0xBC, 0x03, 0x77, 0x40, 0xEC, 0x0D, 0x01, 0x71, 0x0B, 0xC0, 0x47, 0x73, 0x03, 0xD0,
  0x27, 0x20, 0xBC, 0x05, 0x77, 0x30, 0x7C, 0x0B, 0x73, 0x0C, 0xC0, 0x87, 0x73, 0x09, 0xC0, 0x77,
  0x30, 0xDC, 0x0B, 0x77, 0x30, 0xAC, 0x06, 0x72, 0x01, 0xD0, 0xE7, 0x73, 0x0A, 0xC0, 0x67, 0x20,
  0x4E, 0x04, 0x77, 0x20, 0x9C, 0x08, 0x72, 0x0A, 0xE0, 0xC7, 0x72, 0x06, 0xC0, 0xC7, 0x10, 0x3F,
  0x90, 0x67, 0x71, 0x03, 0xD0, 0x46, 0x02, 0x0E, 0xA0, 0xD0, 0x6D, 0x04, 0x73, 0x04, 0x09, 0x30,
  0xDC, 0x0E, 0x06, 0x38, 0x11, 0x7E, 0xB8, 0x15, 0x0C, 0xD0, 0x90, 0x34, 0x84, 0x14, 0x8D, 0xFC,
  0x30, 0x6E, 0x81, 0xED, 0xDD, 0x0A, 0x20, 0x20, 0xEE, 0x82, 0xED, 0xDE, 0xD0, 0xC4, 0x0B, 0xFD,
  0x0B, 0x40, 0x30, 0xEF, 0xF0, 0xC4, 0x01, 0x0C, 0xFB, 0x0A, 0x60, 0x20, 0xCF, 0xD0, 0xE0, 0x76,
  0x08, 0x0E, 0xE0, 0xC0, 0x57, 0x20, 0x50, 0xCF, 0x98, 0x1C, 0x71, 0x72, 0x84, 0x46, 0x76, 0x51,
  0x76, 0x86, 0x14, 0x67, 0x76, 0x41, 0x60,
  // "ç" (U+00E7)
  0x72, 0x86, 0x14, 0x67, 0x76, 0x41, 0x73, 0x04, 0x0B, 0xF9, 0x81, 0xC7, 0x15, 0x01, 0x0A, 0xFD,
  0x08, 0x40, 0x10, 0xDF, 0xE0, 0x34, 0x0C, 0xF0, 0xE0, 0xDC, 0x0D, 0x40, 0x7D, 0x0D, 0x06, 0x48,
  0x23, 0x9F, 0x83, 0x01, 0x0E, 0xC0, 0xC0, 0x17, 0x00, 0x13, 0x08, 0xC0, 0xE0, 0x17, 0x60, 0xDC,
  0x06, 0x76, 0x03, 0xC0, 0xE7, 0x70, 0x7C, 0x0A, 0x77, 0x0A, 0xC0, 0x67, 0x70, 0xDC, 0x04, 0x77,
  0xD0, 0x17, 0x7D, 0x77, 0x01, 0xD7, 0x70, 0x2C, 0x0E, 0x77, 0x02, 0xC0, 0xE7, 0x70, 0x2D, 0x77,
  0x01, 0xD7, 0x71, 0xD0, 0x17, 0x70, 0xEC, 0x03, 0x77, 0x0C, 0xC0, 0x67, 0x70, 0x9C, 0x0A, 0x77,
  0x05, 0xC0, 0xE7, 0x70, 0x1D, 0x06, 0x77, 0x0B, 0xC0, 0xD0, 0x17, 0x60, 0x4D, 0x0B, 0x72, 0x00,
  0x13, 0x0B, 0xD0, 0xD0, 0x54, 0x83, 0x15, 0xAF, 0x43, 0x01, 0x0E, 0xF8, 0x1D, 0xDE, 0xC0, 0x44,
  0x02, 0x0E, 0xFE, 0x04, 0x50, 0x20, 0xCF, 0xD0, 0x47, 0x05, 0x0B, 0xF8, 0x1E, 0xA3, 0x73, 0x01,
  0x0E, 0xA8, 0x1D, 0x53, 0x76, 0x01, 0xA0, 0xE7, 0x72, 0x08, 0xA0, 0xA7, 0x72, 0x0E, 0xB0, 0xE0,
  0x87, 0x60, 0x30, 0xCD, 0x0D, 0x02, 0x77, 0x06, 0x0D, 0xB0, 0xD7, 0x71, 0x01, 0x0E, 0xB0, 0x47,
  0x71, 0x09, 0xB0, 0x77, 0x71, 0x0A, 0xB0, 0x77, 0x70, 0x10, 0xEB, 0x05, 0x71, 0x01, 0x02, 0x28,
  0x11, 0x5C, 0xB0, 0xE7, 0x20, 0x5F, 0xA0, 0x67, 0x20, 0x5F, 0x0E, 0x06, 0x73, 0x81, 0x3C, 0xEA,
  0x82, 0xEB, 0x71, 0x50,
  // "è" (U+00E8)
  0x40, 0x48, 0x01, 0x70, 0x37, 0x73, 0x04, 0xD0, 0xD7, 0x74, 0x09, 0xD0, 0x57, 0x74, 0x0B, 0xC0,
  0xD7, 0x74, 0x01, 0x0D, 0xC0, 0x87, 0x74, 0x01, 0x0D, 0xC0, 0x37, 0x74, 0x02, 0x0E, 0xB0, 0xC7,
  0x75, 0x02, 0x0E, 0xB0, 0x77, 0x75, 0x02, 0x0D, 0xB0, 0x37, 0x75, 0x02, 0x0D, 0xA0, 0xB8, 0x09,
  0xD5, 0x08, 0x42, 0x57, 0x76, 0x47, 0x72, 0x06, 0x0D, 0xF0, 0x90, 0x27, 0x40, 0x20, 0xDF, 0xC0,
  0x67, 0x20, 0x20, 0xEF, 0xE0, 0x77, 0x01, 0x0D, 0xE0, 0xE0, 0xDF, 0x04, 0x60, 0x8D, 0x07, 0x01,
  0x30, 0x40, 0xDC, 0x0D, 0x50, 0x2D, 0x04, 0x60, 0x10, 0xDC, 0x06, 0x40, 0x9C, 0x07, 0x71, 0x03,
  0xC0, 0xD4, 0x0E, 0xB0, 0xE7, 0x30, 0xBC, 0x03, 0x20, 0x3C, 0x08, 0x73, 0x05, 0xC0, 0x72, 0x07,
  0xC0, 0x47, 0x30, 0x1C, 0x0A, 0x20, 0xAC, 0x01, 0x74, 0x0E, 0xB0, 0xD2, 0x0D, 0xC7, 0x50, 0xCC,
  0x2C, 0x0E, 0x80, 0x90, 0x50, 0xCC, 0x2F, 0xFF, 0x90, 0x01, 0xFF, 0xF9, 0x01, 0x02, 0xFF, 0xF9,
  0x01, 0x02, 0xFF, 0xF9, 0x01, 0x02, 0xC0, 0xC7, 0x74, 0x01, 0xC0, 0xD7, 0x75, 0xC0, 0xE7, 0x75,
  0x0D, 0xC0, 0x17, 0x74, 0x0A, 0xC0, 0x47, 0x74, 0x07, 0xC0, 0x87, 0x74, 0x02, 0xC0, 0xD7, 0x75,
  0x0D, 0xC0, 0x67, 0x74, 0x06, 0xC0, 0xE0, 0x17, 0x74, 0x0E, 0xC0, 0xD0, 0x27, 0x30, 0x50, 0xA5,
  0x05, 0xD8, 0x1E, 0x72, 0x48, 0x41, 0x48, 0xEF, 0xC6, 0x09, 0xF8, 0x2E, 0xDD, 0xED, 0x0C, 0x70,
  0xAF, 0xF9, 0x0C, 0x71, 0x07, 0xFF, 0x08, 0x72, 0x81, 0x29, 0xEF, 0x98, 0x1C, 0x71, 0x76, 0x86,
  0x25, 0x67, 0x66, 0x31, 0x60,
  // "é" (U+00E9)
  0x76, 0x02, 0x80, 0x17, 0x06, 0x77, 0x30, 0xAD, 0x07, 0x77, 0x20, 0x3D, 0x0C, 0x77, 0x30, 0xCC,
  0x0E, 0x01, 0x77, 0x20, 0x6C, 0x0E, 0x03, 0x77, 0x20, 0x10, 0xEC, 0x04, 0x77, 0x30, 0xAC, 0x05,
  0x77, 0x30, 0x5C, 0x05, 0x77, 0x30, 0x10, 0xEB, 0x05, 0x77, 0x40, 0x8A, 0x0E, 0x04, 0x80, 0x9E,
  0x00, 0x84, 0x25, 0x77, 0x64, 0x77, 0x20, 0x60, 0xDF, 0x09, 0x02, 0x74, 0x02, 0x0D, 0xFC, 0x06,
  0x72, 0x02, 0x0E, 0xFE, 0x07, 0x70, 0x10, 0xDE, 0x0E, 0x0D, 0xF0, 0x46, 0x08, 0xD0, 0x70, 0x13,
  0x04, 0x0D, 0xC0, 0xD5, 0x02, 0xD0, 0x46, 0x01, 0x0D, 0xC0, 0x64, 0x09, 0xC0, 0x77, 0x10, 0x3C,
  0x0D, 0x40, 0xEB, 0x0E, 0x73, 0x0B, 0xC0, 0x32, 0x03, 0xC0, 0x87, 0x30, 0x5C, 0x07, 0x20, 0x7C,
  0x04, 0x73, 0x01, 0xC0, 0xA2, 0x0A, 0xC0, 0x17, 0x40, 0xEB, 0x0D, 0x20, 0xDC, 0x75, 0x0C, 0xC2,
  0xC0, 0xE8, 0x09, 0x05, 0x0C, 0xC2, 0xFF, 0xF9, 0x00, 0x1F, 0xFF, 0x90, 0x10, 0x2F, 0xFF, 0x90,
  0x10, 0x2F, 0xFF, 0x90, 0x10, 0x2C, 0x0C, 0x77, 0x40, 0x1C, 0x0D, 0x77, 0x5C, 0x0E, 0x77, 0x50,
  0xDC, 0x01, 0x77, 0x40, 0xAC, 0x04, 0x77, 0x40, 0x7C, 0x08, 0x77, 0x40, 0x2C, 0x0D, 0x77, 0x50,
  0xDC, 0x06, 0x77, 0x40, 0x6C, 0x0E, 0x01, 0x77, 0x40, 0xEC, 0x0D, 0x02, 0x73, 0x05, 0x0A, 0x50,
  0x5D, 0x81, 0xE7, 0x24, 0x84, 0x14, 0x8E, 0xFC, 0x60, 0x9F, 0x82, 0xED, 0xDE, 0xD0, 0xC7, 0x0A,
  0xFF, 0x90, 0xC7, 0x10, 0x7F, 0xF0, 0x87, 0x28, 0x12, 0x9E, 0xF9, 0x81, 0xC7, 0x17, 0x68, 0x62,
  0x56, 0x76, 0x63, 0x16,
  // "ê" (U+00EA)
  0x72, 0x84, 0x57, 0x77, 0x73, 0x77, 0x30, 0x1D, 0x0D, 0x77, 0x30, 0xAE, 0x06, 0x77, 0x10, 0x4F,
  0x0E, 0x02, 0x76, 0x01, 0x0D, 0xB0, 0xC0, 0xEB, 0x0B, 0x76, 0x0A, 0xB8, 0x2D, 0x12, 0xEB, 0x07,
  0x74, 0x05, 0xB0, 0xD0, 0x12, 0x03, 0x0E, 0xB0, 0x37, 0x20, 0x20, 0xEA, 0x0D, 0x01, 0x40, 0x4B,
  0x0D, 0x01, 0x71, 0x0D, 0xA0, 0xD0, 0x26, 0x04, 0x0E, 0xA0, 0xB7, 0x08, 0xA0, 0xD0, 0x17, 0x10,
  0x30, 0xDA, 0x06, 0x80, 0x9D, 0x00, 0x84, 0x25, 0x77, 0x64, 0x77, 0x20, 0x60, 0xDF, 0x09, 0x02,
  0x74, 0x02, 0x0D, 0xFC, 0x06, 0x72, 0x02, 0x0E, 0xFE, 0x07, 0x70, 0x10, 0xDE, 0x0E, 0x0D, 0xF0,
  0x46, 0x08, 0xD0, 0x70, 0x13, 0x04, 0x0D, 0xC0, 0xD5, 0x02, 0xD0, 0x46, 0x01, 0x0D, 0xC0, 0x64,
  0x09, 0xC0, 0x77, 0x10, 0x3C, 0x0D, 0x40, 0xEB, 0x0E, 0x73, 0x0B, 0xC0, 0x32, 0x03, 0xC0, 0x87,
  0x30, 0x5C, 0x07, 0x20, 0x7C, 0x04, 0x73, 0x01, 0xC0, 0xA2, 0x0A, 0xC0, 0x17, 0x40, 0xEB, 0x0D,
  0x20, 0xDC, 0x75, 0x0C, 0xC2, 0xC0, 0xE8, 0x09, 0x05, 0x0C, 0xC2, 0xFF, 0xF9, 0x00, 0x1F, 0xFF,
  0x90, 0x10, 0x2F, 0xFF, 0x90, 0x10, 0x2F, 0xFF, 0x90, 0x10, 0x2C, 0x0C, 0x77, 0x40, 0x1C, 0x0D,
  0x77, 0x5C, 0x0E, 0x77, 0x50, 0xDC, 0x01, 0x77, 0x40, 0xAC, 0x04, 0x77, 0x40, 0x7C, 0x08, 0x77,
  0x40, 0x2C, 0x0D, 0x77, 0x50, 0xDC, 0x06, 0x77, 0x40, 0x6C, 0x0E, 0x01, 0x77, 0x40, 0xEC, 0x0D,
  0x02, 0x73, 0x05, 0x0A, 0x50, 0x5D, 0x81, 0xE7, 0x24, 0x84, 0x14, 0x8E, 0xFC, 0x60, 0x9F, 0x82,
  0xED, 0xDE, 0xD0, 0xC7, 0x0A, 0xFF, 0x90, 0xC7, 0x10, 0x7F, 0xF0, 0x87, 0x28, 0x12, 0x9E, 0xF9,
  0x81, 0xC7, 0x17, 0x68, 0x62, 0x56, 0x76, 0x63, 0x16,
  // "ë" (U+00EB)
  0x58, 0x27, 0xDE, 0x86, 0x83, 0x4D, 0xEA, 0x17, 0x10, 0x3C, 0x06, 0x40, 0x10, 0xEB, 0x09, 0x71,
  0x07, 0xC0, 0x94, 0x04, 0xC0, 0xD7, 0x10, 0x7C, 0x09, 0x40, 0x4C, 0x0D, 0x71, 0x03, 0xC0, 0x54,
  0x01, 0x0E, 0xB0, 0x97, 0x28, 0x26, 0xDE, 0x86, 0x82, 0x4D, 0xEA, 0x80, 0x9D, 0x20, 0x84, 0x25,
  0x77, 0x64, 0x77, 0x20, 0x60, 0xDF, 0x09, 0x02, 0x74, 0x02, 0x0D, 0xFC, 0x06, 0x72, 0x02, 0x0E,
  0xFE, 0x07, 0x70, 0x10, 0xDE, 0x0E, 0x0D, 0xF0, 0x46, 0x08, 0xD0, 0x70, 0x13, 0x04, 0x0D, 0xC0,
  0xD5, 0x02, 0xD0, 0x46, 0x01, 0x0D, 0xC0, 0x64, 0x09, 0xC0, 0x77, 0x10, 0x3C, 0x0D, 0x40, 0xEB,
  0x0E, 0x73, 0x0B, 0xC0, 0x32, 0x03, 0xC0, 0x87, 0x30, 0x5C, 0x07, 0x20, 0x7C, 0x04, 0x73, 0x01,
  0xC0, 0xA2, 0x0A, 0xC0, 0x17, 0x40, 0xEB, 0x0D, 0x20, 0xDC, 0x75, 0x0C, 0xC2, 0xC0, 0xE8, 0x09,
  0x05, 0x0C, 0xC2, 0xFF, 0xF9, 0x00, 0x1F, 0xFF, 0x90, 0x10, 0x2F, 0xFF, 0x90, 0x10, 0x2F, 0xFF,
  0x90, 0x10, 0x2C, 0x0C, 0x77, 0x40, 0x1C, 0x0D, 0x77, 0x5C, 0x0E, 0x77, 0x50, 0xDC, 0x01, 0x77,
  0x40, 0xAC, 0x04, 0x77, 0x40, 0x7C, 0x08, 0x77, 0x40, 0x2C, 0x0D, 0x77, 0x50, 0xDC, 0x06, 0x77,
  0x40, 0x6C, 0x0E, 0x01, 0x77, 0x40, 0xEC, 0x0D, 0x02, 0x73, 0x05, 0x0A, 0x50, 0x5D, 0x81, 0xE7,
  0x24, 0x84, 0x14, 0x8E, 0xFC, 0x60, 0x9F, 0x82, 0xED, 0xDE, 0xD0, 0xC7, 0x0A, 0xFF, 0x90, 0xC7,
  0x10, 0x7F, 0xF0, 0x87, 0x28, 0x12, 0x9E, 0xF9, 0x81, 0xC7, 0x17, 0x68, 0x62, 0x56, 0x76, 0x63,
  0x16,
  // "ì" (U+00EC)
  0x04, 0x80, 0x17, 0x03, 0x50, 0x4D, 0x0D, 0x60, 0x9D, 0x05, 0x60, 0xBC, 0x0D, 0x60, 0x10, 0xDC,
  0x08, 0x60, 0x10, 0xDC, 0x03, 0x60, 0x20, 0xEB, 0x0C, 0x70, 0x20, 0xEB, 0x07, 0x70, 0x20, 0xDB,
  0x03, 0x70, 0x20, 0xDA, 0x0B, 0x80, 0xF5, 0x00, 0xBC, 0x03, 0x60, 0xBC, 0x03, 0x60, 0xBC, 0x03,
  0x60, 0xBC, 0x03, 0x60, 0xBC, 0x03, 0x60, 0xBC, 0x03, 0x60, 0xBC, 0x03, 0x60, 0xBC, 0x03, 0x60,
  0xBC, 0x03, 0x60, 0xBC, 0x03, 0x60, 0xBC, 0x03, 0x60, 0xBC, 0x03, 0x60, 0xBC, 0x03, 0x60, 0xBC,
  0x03, 0x60, 0xBC, 0x03, 0x60, 0xBC, 0x03, 0x60, 0xBC, 0x03, 0x60, 0xBC, 0x03, 0x60, 0xBC, 0x03,
  0x60, 0xBC, 0x03, 0x60, 0xBC, 0x03, 0x60, 0xBC, 0x03, 0x60, 0xBC, 0x03, 0x60, 0xBC, 0x03, 0x60,
  0xBC, 0x03, 0x60, 0xBC, 0x03, 0x60, 0xBC, 0x03, 0x60, 0xBC, 0x03, 0x60, 0xBC, 0x03, 0x60, 0xBC,
  0x03, 0x60, 0xBC, 0x03, 0x60, 0xBC, 0x03, 0x10,
  // "í" (U+00ED)
  0x50, 0x28, 0x01, 0x70, 0x65, 0x0A, 0xD0, 0x74, 0x03, 0xD0, 0xC5, 0x0C, 0xC0, 0xE0, 0x14, 0x06,
  0xC0, 0xE0, 0x34, 0x01, 0x0E, 0xC0, 0x45, 0x0A, 0xC0, 0x55, 0x05, 0xC0, 0x55, 0x01, 0x0E, 0xB0,
  0x56, 0x08, 0xA0, 0xE0, 0x48, 0x09, 0x80, 0x00, 0xBC, 0x03, 0x60, 0xBC, 0x03, 0x60, 0xBC, 0x03,
  0x60, 0xBC, 0x03, 0x60, 0xBC, 0x03, 0x60, 0xBC, 0x03, 0x60, 0xBC, 0x03, 0x60, 0xBC, 0x03, 0x60,
  0xBC, 0x03, 0x60, 0xBC, 0x03, 0x60, 0xBC, 0x03, 0x60, 0xBC, 0x03, 0x60, 0xBC, 0x03, 0x60, 0xBC,
  0x03, 0x60, 0xBC, 0x03, 0x60, 0xBC, 0x03, 0x60, 0xBC, 0x03, 0x60, 0xBC, 0x03, 0x60, 0xBC, 0x03,
  0x60, 0xBC, 0x03, 0x60, 0xBC, 0x03, 0x60, 0xBC, 0x03, 0x60, 0xBC, 0x03, 0x60, 0xBC, 0x03, 0x60,
  0xBC, 0x03, 0x60, 0xBC, 0x03, 0x60, 0xBC, 0x03, 0x60, 0xBC, 0x03, 0x60, 0xBC, 0x03, 0x60, 0xBC,
  0x03, 0x60, 0xBC, 0x03, 0x60, 0xBC, 0x03, 0x50,
  // "î" (U+00EE)
  0x68, 0x45, 0x77, 0x77, 0x37, 0x40, 0x1D, 0x0D, 0x74, 0x0A, 0xE0, 0x67, 0x20, 0x4F, 0x0E, 0x02,
  0x70, 0x10, 0xDB, 0x0C, 0x0E, 0xB0, 0xB7, 0x0A, 0xB8, 0x2D, 0x12, 0xEB, 0x07, 0x50, 0x5B, 0x0D,
  0x01, 0x20, 0x30, 0xEB, 0x03, 0x30, 0x20, 0xEA, 0x0D, 0x01, 0x40, 0x4B, 0x0D, 0x01, 0x20, 0xDA,
  0x0D, 0x02, 0x60, 0x40, 0xEA, 0x81, 0xB0, 0x8A, 0x0D, 0x01, 0x71, 0x03, 0x0D, 0xA0, 0x68, 0x09,
  0xB4, 0x00, 0xBC, 0x03, 0x75, 0x0B, 0xC0, 0x37, 0x50, 0xBC, 0x03, 0x75, 0x0B, 0xC0, 0x37, 0x50,
  0xBC, 0x03, 0x75, 0x0B, 0xC0, 0x37, 0x50, 0xBC, 0x03, 0x75, 0x0B, 0xC0, 0x37, 0x50, 0xBC, 0x03,
  0x75, 0x0B, 0xC0, 0x37, 0x50, 0xBC, 0x03, 0x75, 0x0B, 0xC0, 0x37, 0x50, 0xBC, 0x03, 0x75, 0x0B,
  0xC0, 0x37, 0x50, 0xBC, 0x03, 0x75, 0x0B, 0xC0, 0x37, 0x50, 0xBC, 0x03, 0x75, 0x0B, 0xC0, 0x37,
  0x50, 0xBC, 0x03, 0x75, 0x0B, 0xC0, 0x37, 0x50, 0xBC, 0x03, 0x75, 0x0B, 0xC0, 0x37, 0x50, 0xBC,
  0x03, 0x75, 0x0B, 0xC0, 0x37, 0x50, 0xBC, 0x03, 0x75, 0x0B, 0xC0, 0x37, 0x50, 0xBC, 0x03, 0x75,
  0x0B, 0xC0, 0x37, 0x50, 0xBC, 0x03, 0x75, 0x0B, 0xC0, 0x37, 0x50, 0xBC, 0x03, 0x75, 0x0B, 0xC0,
  0x36,
  // "ï" (U+00EF)
  0x18, 0x27, 0xDE, 0x86, 0x84, 0x4D, 0xEA, 0x13, 0xC0, 0x64, 0x01, 0x0E, 0xB0, 0x90, 0x7C, 0x09,
  0x40, 0x4C, 0x0D, 0x07, 0xC0, 0x94, 0x04, 0xC0, 0xD0, 0x3C, 0x05, 0x40, 0x10, 0xEB, 0x84, 0x90,
  0x6D, 0xE8, 0x68, 0x24, 0xDE, 0xA8, 0x09, 0xA2, 0x00, 0xBC, 0x03, 0x73, 0x0B, 0xC0, 0x37, 0x30,
  0xBC, 0x03, 0x73, 0x0B, 0xC0, 0x37, 0x30, 0xBC, 0x03, 0x73, 0x0B, 0xC0, 0x37, 0x30, 0xBC, 0x03,
  0x73, 0x0B, 0xC0, 0x37, 0x30, 0xBC, 0x03, 0x73, 0x0B, 0xC0, 0x37, 0x30, 0xBC, 0x03, 0x73, 0x0B,
  0xC0, 0x37, 0x30, 0xBC, 0x03, 0x73, 0x0B, 0xC0, 0x37, 0x30, 0xBC, 0x03, 0x73, 0x0B, 0xC0, 0x37,
  0x30, 0xBC, 0x03, 0x73, 0x0B, 0xC0, 0x37, 0x30, 0xBC, 0x03, 0x73, 0x0B, 0xC0, 0x37, 0x30, 0xBC,
  0x03, 0x73, 0x0B, 0xC0, 0x37, 0x30, 0xBC, 0x03, 0x73, 0x0B, 0xC0, 0x37, 0x30, 0xBC, 0x03, 0x73,
  0x0B, 0xC0, 0x37, 0x30, 0xBC, 0x03, 0x73, 0x0B, 0xC0, 0x37, 0x30, 0xBC, 0x03, 0x73, 0x0B, 0xC0,
  0x37, 0x30, 0xBC, 0x03, 0x73, 0x0B, 0xC0, 0x35,
  // "ð" (U+00F0)
  0x71, 0x02, 0x73, 0x01, 0x75, 0x82, 0x2E, 0xC3, 0x68, 0x21, 0xAE, 0x17, 0x40, 0xCB, 0x09, 0x40,
  0x70, 0xEA, 0x0B, 0x73, 0x05, 0xD8, 0x2D, 0x33, 0xCD, 0x03, 0x73, 0x06, 0x0E, 0xFB, 0x0B, 0x02,
  0x75, 0x02, 0x0D, 0xF0, 0xE0, 0x57, 0x71, 0x01, 0x0E, 0xD0, 0xC0, 0x17, 0x71, 0x03, 0x0D, 0xF0,
  0x37, 0x60, 0x10, 0x9F, 0xA0, 0xE0, 0x27, 0x40, 0x40, 0xEC, 0x81, 0xE5, 0xCC, 0x0C, 0x74, 0x02,
  0xC8, 0x39, 0x10, 0x1E, 0xC0, 0x77, 0x48, 0x27, 0xFD, 0x34, 0x04, 0xD0, 0x27, 0x40, 0x67, 0x09,
  0xC0, 0xA7, 0x75, 0x01, 0x0E, 0xC0, 0x37, 0x75, 0x06, 0xC0, 0xA7, 0x76, 0x0D, 0xC0, 0x17, 0x75,
  0x07, 0xC0, 0x87, 0x76, 0x0E, 0xB0, 0xD7, 0x28, 0x71, 0x6B, 0xDE, 0xED, 0xA6, 0x20, 0xAC, 0x03,
  0x70, 0x7F, 0xA8, 0x1D, 0x46, 0xC0, 0x75, 0x01, 0x0C, 0xFD, 0x07, 0xC0, 0xC5, 0x0C, 0xFF, 0xD4,
  0x09, 0xE8, 0x4B, 0x75, 0x58, 0xDF, 0x90, 0x22, 0x03, 0xD0, 0xD0, 0x36, 0x07, 0xF0, 0x52, 0x0B,
  0xC0, 0xD0, 0x17, 0x10, 0x7E, 0x81, 0x70, 0x1D, 0x04, 0x73, 0x0B, 0xD8, 0x19, 0x07, 0xC0, 0xC7,
  0x40, 0x3D, 0x81, 0xB0, 0xAC, 0x07, 0x75, 0x0C, 0xC8, 0x1C, 0x0D, 0xC0, 0x37, 0x50, 0x8C, 0x0D,
  0x1D, 0x76, 0x05, 0xC0, 0xD0, 0x1C, 0x0E, 0x76, 0x03, 0xC0, 0xE0, 0x2C, 0x0D, 0x76, 0x02, 0xC0,
  0xD0, 0x3C, 0x0C, 0x76, 0x01, 0xC0, 0xD0, 0x3C, 0x0C, 0x76, 0x02, 0xC0, 0xC0, 0x2C, 0x0D, 0x76,
  0x03, 0xC0, 0xB1, 0xD7, 0x60, 0x4C, 0x81, 0x90, 0xDC, 0x02, 0x75, 0x06, 0xC8, 0x16, 0x0A, 0xC0,
  0x67, 0x50, 0xAC, 0x81, 0x30, 0x6C, 0x0A, 0x75, 0x0E, 0xB0, 0xE2, 0x01, 0xD0, 0x27, 0x30, 0x5C,
  0x0A, 0x30, 0xAC, 0x0A, 0x73, 0x0C, 0xC0, 0x43, 0x02, 0xD0, 0x77, 0x10, 0x9C, 0x0C, 0x50, 0x8D,
  0x0B, 0x03, 0x40, 0x40, 0xCD, 0x03, 0x60, 0xCF, 0x00, 0xDF, 0x09, 0x70, 0x10, 0xCF, 0xF0, 0xA7,
  0x30, 0x9F, 0xD0, 0x87, 0x50, 0x30, 0xAF, 0x81, 0xE9, 0x27, 0x71, 0x85, 0x14, 0x67, 0x76, 0x37,
  0x20,
  // "ñ" (U+00F1)
  0x58, 0x45, 0xCE, 0xEB, 0x67, 0x0B, 0xA0, 0x55, 0x08, 0xE0, 0xE0, 0x74, 0x03, 0xB0, 0x34, 0x03,
  0xFA, 0x83, 0xE9, 0x66, 0xEA, 0x0E, 0x50, 0xAF, 0xFA, 0x09, 0x40, 0x1B, 0x82, 0xD6, 0x6A, 0xFB,
  0x02, 0x40, 0x4A, 0x0E, 0x01, 0x30, 0x10, 0x9F, 0x06, 0x50, 0x7A, 0x09, 0x68, 0x51, 0x7C, 0xEE,
  0xB4, 0x80, 0x9C, 0x60, 0x84, 0x15, 0x77, 0x63, 0x70, 0xBB, 0x05, 0x30, 0x30, 0xBE, 0x81, 0xE9,
  0x14, 0x0B, 0xB0, 0x72, 0x07, 0xFB, 0x0E, 0x03, 0x30, 0xBB, 0x81, 0x90, 0x7F, 0xD0, 0xE0, 0x12,
  0x0B, 0xB0, 0xB0, 0x4D, 0x00, 0xDF, 0x0A, 0x20, 0xBB, 0x0E, 0x0D, 0xA0, 0xC0, 0x54, 0x05, 0x0E,
  0xD8, 0x12, 0x0B, 0xE0, 0xA7, 0x03, 0xD8, 0x18, 0x0B, 0xD0, 0xD7, 0x20, 0x9C, 0x81, 0xB0, 0xBD,
  0x06, 0x72, 0x04, 0xC8, 0x1E, 0x0B, 0xD0, 0x17, 0x3D, 0x10, 0xBC, 0x0C, 0x74, 0x0E, 0xC0, 0x10,
  0xBC, 0x09, 0x74, 0x0D, 0xC0, 0x20, 0xBC, 0x07, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x05, 0x74, 0x0C,
  0xC0, 0x20, 0xBC, 0x04, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x04, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03,
  0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20,
  0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C,
  0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03,
  0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20,
  0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C,
  0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03,
  0x74, 0x0C, 0xC0, 0x20,
  // "ò" (U+00F2)
  0x50, 0x48, 0x01, 0x70, 0x37, 0x74, 0x04, 0xD0, 0xD7, 0x75, 0x09, 0xD0, 0x57, 0x75, 0x0B, 0xC0,
  0xD7, 0x75, 0x01, 0x0D, 0xC0, 0x87, 0x75, 0x01, 0x0D, 0xC0, 0x37, 0x75, 0x02, 0x0E, 0xB0, 0xC7,
  0x76, 0x02, 0x0E, 0xB0, 0x77, 0x76, 0x02, 0x0D, 0xB0, 0x37, 0x76, 0x02, 0x0D, 0xA0, 0xB8, 0x09,
  0xE1, 0x08, 0x51, 0x46, 0x77, 0x53, 0x77, 0x20, 0x50, 0xCF, 0x81, 0xE8, 0x17, 0x40, 0x20, 0xCF,
  0xC0, 0xE0, 0x67, 0x20, 0x20, 0xEF, 0xF0, 0x87, 0x01, 0x0D, 0xF0, 0xD0, 0xEF, 0x06, 0x60, 0x9D,
  0x0B, 0x04, 0x38, 0x11, 0x6E, 0xC0, 0xE0, 0x14, 0x02, 0xD0, 0x97, 0x02, 0x0D, 0xC0, 0xA4, 0x0A,
  0xC0, 0xC7, 0x20, 0x3D, 0x02, 0x30, 0xEC, 0x04, 0x73, 0x0A, 0xC0, 0x82, 0x04, 0xC0, 0xD7, 0x40,
  0x4C, 0x0D, 0x20, 0x8C, 0x08, 0x75, 0x0E, 0xC8, 0x11, 0x0B, 0xC0, 0x57, 0x50, 0xBC, 0x81, 0x40,
  0xEC, 0x02, 0x75, 0x08, 0xC0, 0x71, 0xD7, 0x60, 0x6C, 0x09, 0x01, 0xC0, 0xE7, 0x60, 0x4C, 0x0A,
  0x02, 0xC0, 0xE7, 0x60, 0x4C, 0x0B, 0x03, 0xC0, 0xD7, 0x60, 0x3C, 0x0C, 0x03, 0xC0, 0xD7, 0x60,
  0x3C, 0x0C, 0x02, 0xC0, 0xE7, 0x60, 0x4C, 0x0B, 0x01, 0xC0, 0xE7, 0x60, 0x5C, 0x0A, 0x1D, 0x76,
  0x06, 0xC8, 0x19, 0x0D, 0xC0, 0x27, 0x50, 0x8C, 0x81, 0x70, 0xAC, 0x05, 0x75, 0x0B, 0xC8, 0x14,
  0x07, 0xC0, 0x97, 0x50, 0xEC, 0x81, 0x10, 0x3C, 0x0D, 0x74, 0x04, 0xC0, 0xC3, 0x0D, 0xC0, 0x47,
  0x30, 0xAC, 0x06, 0x30, 0x7C, 0x0C, 0x72, 0x04, 0xD0, 0x13, 0x01, 0x0E, 0xC0, 0x97, 0x02, 0x0D,
  0xC0, 0x85, 0x06, 0xD0, 0xB0, 0x43, 0x81, 0x16, 0xEC, 0x0E, 0x01, 0x60, 0xBF, 0x0D, 0x0E, 0xF0,
  0x57, 0x01, 0x0C, 0xFF, 0x07, 0x73, 0x0A, 0xFC, 0x0E, 0x06, 0x75, 0x04, 0x0B, 0xF8, 0x1E, 0x81,
  0x77, 0x18, 0x51, 0x46, 0x77, 0x53, 0x72,
  // "ó" (U+00F3)
  0x77, 0x02, 0x80, 0x17, 0x06, 0x77, 0x40, 0xAD, 0x07, 0x77, 0x30, 0x3D, 0x0C, 0x77, 0x40, 0xCC,
  0x0E, 0x01, 0x77, 0x30, 0x6C, 0x0E, 0x03, 0x77, 0x30, 0x10, 0xEC, 0x04, 0x77, 0x40, 0xAC, 0x05,
  0x77, 0x40, 0x5C, 0x05, 0x77, 0x40, 0x10, 0xEB, 0x05, 0x77, 0x50, 0x8A, 0x0E, 0x04, 0x80, 0x9E,
  0x40, 0x85, 0x14, 0x67, 0x75, 0x37, 0x72, 0x05, 0x0C, 0xF8, 0x1E, 0x81, 0x74, 0x02, 0x0C, 0xFC,
  0x0E, 0x06, 0x72, 0x02, 0x0E, 0xFF, 0x08, 0x70, 0x10, 0xDF, 0x0D, 0x0E, 0xF0, 0x66, 0x09, 0xD0,
  0xB0, 0x43, 0x81, 0x16, 0xEC, 0x0E, 0x01, 0x40, 0x2D, 0x09, 0x70, 0x20, 0xDC, 0x0A, 0x40, 0xAC,
  0x0C, 0x72, 0x03, 0xD0, 0x23, 0x0E, 0xC0, 0x47, 0x30, 0xAC, 0x08, 0x20, 0x4C, 0x0D, 0x74, 0x04,
  0xC0, 0xD2, 0x08, 0xC0, 0x87, 0x50, 0xEC, 0x81, 0x10, 0xBC, 0x05, 0x75, 0x0B, 0xC8, 0x14, 0x0E,
  0xC0, 0x27, 0x50, 0x8C, 0x07, 0x1D, 0x76, 0x06, 0xC0, 0x90, 0x1C, 0x0E, 0x76, 0x04, 0xC0, 0xA0,
  0x2C, 0x0E, 0x76, 0x04, 0xC0, 0xB0, 0x3C, 0x0D, 0x76, 0x03, 0xC0, 0xC0, 0x3C, 0x0D, 0x76, 0x03,
  0xC0, 0xC0, 0x2C, 0x0E, 0x76, 0x04, 0xC0, 0xB0, 0x1C, 0x0E, 0x76, 0x05, 0xC0, 0xA1, 0xD7, 0x60,
  0x6C, 0x81, 0x90, 0xDC, 0x02, 0x75, 0x08, 0xC8, 0x17, 0x0A, 0xC0, 0x57, 0x50, 0xBC, 0x81, 0x40,
  0x7C, 0x09, 0x75, 0x0E, 0xC8, 0x11, 0x03, 0xC0, 0xD7, 0x40, 0x4C, 0x0C, 0x30, 0xDC, 0x04, 0x73,
  0x0A, 0xC0, 0x63, 0x07, 0xC0, 0xC7, 0x20, 0x4D, 0x01, 0x30, 0x10, 0xEC, 0x09, 0x70, 0x20, 0xDC,
  0x08, 0x50, 0x6D, 0x0B, 0x04, 0x38, 0x11, 0x6E, 0xC0, 0xE0, 0x16, 0x0B, 0xF0, 0xD0, 0xEF, 0x05,
  0x70, 0x10, 0xCF, 0xF0, 0x77, 0x30, 0xAF, 0xC0, 0xE0, 0x67, 0x50, 0x40, 0xBF, 0x81, 0xE8, 0x17,
  0x71, 0x85, 0x14, 0x67, 0x75, 0x37, 0x20,
  // "ô" (U+00F4)
  0x73, 0x84, 0x57, 0x77, 0x73, 0x77, 0x40, 0x1D, 0x0D, 0x77, 0x40, 0xAE, 0x06, 0x77, 0x20, 0x4F,
  0x0E, 0x02, 0x77, 0x01, 0x0D, 0xB0, 0xC0, 0xEB, 0x0B, 0x77, 0x0A, 0xB8, 0x2D, 0x12, 0xEB, 0x07,
  0x75, 0x05, 0xB0, 0xD0, 0x12, 0x03, 0x0E, 0xB0, 0x37, 0x30, 0x20, 0xEA, 0x0D, 0x01, 0x40, 0x4B,
  0x0D, 0x01, 0x72, 0x0D, 0xA0, 0xD0, 0x26, 0x04, 0x0E, 0xA0, 0xB7, 0x10, 0x8A, 0x0D, 0x01, 0x71,
  0x03, 0x0D, 0xA0, 0x68, 0x09, 0xD4, 0x08, 0x51, 0x46, 0x77, 0x53, 0x77, 0x20, 0x50, 0xCF, 0x81,
  0xE8, 0x17, 0x40, 0x20, 0xCF, 0xC0, 0xE0, 0x67, 0x20, 0x20, 0xEF, 0xF0, 0x87, 0x01, 0x0D, 0xF0,
  0xD0, 0xEF, 0x06, 0x60, 0x9D, 0x0B, 0x04, 0x38, 0x11, 0x6E, 0xC0, 0xE0, 0x14, 0x02, 0xD0, 0x97,
  0x02, 0x0D, 0xC0, 0xA4, 0x0A, 0xC0, 0xC7, 0x20, 0x3D, 0x02, 0x30, 0xEC, 0x04, 0x73, 0x0A, 0xC0,
  0x82, 0x04, 0xC0, 0xD7, 0x40, 0x4C, 0x0D, 0x20, 0x8C, 0x08, 0x75, 0x0E, 0xC8, 0x11, 0x0B, 0xC0,
  0x57, 0x50, 0xBC, 0x81, 0x40, 0xEC, 0x02, 0x75, 0x08, 0xC0, 0x71, 0xD7, 0x60, 0x6C, 0x09, 0x01,
  0xC0, 0xE7, 0x60, 0x4C, 0x0A, 0x02, 0xC0, 0xE7, 0x60, 0x4C, 0x0B, 0x03, 0xC0, 0xD7, 0x60, 0x3C,
  0x0C, 0x03, 0xC0, 0xD7, 0x60, 0x3C, 0x0C, 0x02, 0xC0, 0xE7, 0x60, 0x4C, 0x0B, 0x01, 0xC0, 0xE7,
  0x60, 0x5C, 0x0A, 0x1D, 0x76, 0x06, 0xC8, 0x19, 0x0D, 0xC0, 0x27, 0x50, 0x8C, 0x81, 0x70, 0xAC,
  0x05, 0x75, 0x0B, 0xC8, 0x14, 0x07, 0xC0, 0x97, 0x50, 0xEC, 0x81, 0x10, 0x3C, 0x0D, 0x74, 0x04,
  0xC0, 0xC3, 0x0D, 0xC0, 0x47, 0x30, 0xAC, 0x06, 0x30, 0x7C, 0x0C, 0x72, 0x04, 0xD0, 0x13, 0x01,
  0x0E, 0xC0, 0x97, 0x02, 0x0D, 0xC0, 0x85, 0x06, 0xD0, 0xB0, 0x43, 0x81, 0x16, 0xEC, 0x0E, 0x01,
  0x60, 0xBF, 0x0D, 0x0E, 0xF0, 0x57, 0x01, 0x0C, 0xFF, 0x07, 0x73, 0x0A, 0xFC, 0x0E, 0x06, 0x75,
  0x04, 0x0B, 0xF8, 0x1E, 0x81, 0x77, 0x18, 0x51, 0x46, 0x77, 0x53, 0x72,
  // "õ" (U+00F5)
  0x68, 0x45, 0xCE, 0xEB, 0x67, 0x0B, 0xA0, 0x57, 0x08, 0xE0, 0xE0, 0x74, 0x03, 0xB0, 0x36, 0x03,
  0xFA, 0x83, 0xE9, 0x66, 0xEA, 0x0E, 0x70, 0xAF, 0xFA, 0x09, 0x60, 0x1B, 0x82, 0xD6, 0x6A, 0xFB,
  0x02, 0x60, 0x4A, 0x0E, 0x01, 0x30, 0x10, 0x9F, 0x06, 0x70, 0x7A, 0x09, 0x68, 0x51, 0x7C, 0xEE,
  0xB4, 0x80, 0x9D, 0x60, 0x85, 0x14, 0x67, 0x75, 0x37, 0x72, 0x05, 0x0C, 0xF8, 0x1E, 0x81, 0x74,
  0x02, 0x0C, 0xFC, 0x0E, 0x06, 0x72, 0x02, 0x0E, 0xFF, 0x08, 0x70, 0x10, 0xDF, 0x0D, 0x0E, 0xF0,
  0x66, 0x09, 0xD0, 0xB0, 0x43, 0x81, 0x16, 0xEC, 0x0E, 0x01, 0x40, 0x2D, 0x09, 0x70, 0x20, 0xDC,
  0x0A, 0x40, 0xAC, 0x0C, 0x72, 0x03, 0xD0, 0x23, 0x0E, 0xC0, 0x47, 0x30, 0xAC, 0x08, 0x20, 0x4C,
  0x0D, 0x74, 0x04, 0xC0, 0xD2, 0x08, 0xC0, 0x87, 0x50, 0xEC, 0x81, 0x10, 0xBC, 0x05, 0x75, 0x0B,
  0xC8, 0x14, 0x0E, 0xC0, 0x27, 0x50, 0x8C, 0x07, 0x1D, 0x76, 0x06, 0xC0, 0x90, 0x1C, 0x0E, 0x76,
  0x04, 0xC0, 0xA0, 0x2C, 0x0E, 0x76, 0x04, 0xC0, 0xB0, 0x3C, 0x0D, 0x76, 0x03, 0xC0, 0xC0, 0x3C,
  0x0D, 0x76, 0x03, 0xC0, 0xC0, 0x2C, 0x0E, 0x76, 0x04, 0xC0, 0xB0, 0x1C, 0x0E, 0x76, 0x05, 0xC0,
  0xA1, 0xD7, 0x60, 0x6C, 0x81, 0x90, 0xDC, 0x02, 0x75, 0x08, 0xC8, 0x17, 0x0A, 0xC0, 0x57, 0x50,
  0xBC, 0x81, 0x40, 0x7C, 0x09, 0x75, 0x0E, 0xC8, 0x11, 0x03, 0xC0, 0xD7, 0x40, 0x4C, 0x0C, 0x30,
  0xDC, 0x04, 0x73, 0x0A, 0xC0, 0x63, 0x07, 0xC0, 0xC7, 0x20, 0x4D, 0x01, 0x30, 0x10, 0xEC, 0x09,
  0x70, 0x20, 0xDC, 0x08, 0x50, 0x6D, 0x0B, 0x04, 0x38, 0x11, 0x6E, 0xC0, 0xE0, 0x16, 0x0B, 0xF0,
  0xD0, 0xEF, 0x05, 0x70, 0x10, 0xCF, 0xF0, 0x77, 0x30, 0xAF, 0xC0, 0xE0, 0x67, 0x50, 0x40, 0xBF,
  0x81, 0xE8, 0x17, 0x71, 0x85, 0x14, 0x67, 0x75, 0x37, 0x20,
  // "ö" (U+00F6)
  0x68, 0x27, 0xDE, 0x86, 0x83, 0x4D, 0xEA, 0x17, 0x20, 0x3C, 0x06, 0x40, 0x10, 0xEB, 0x09, 0x72,
  0x07, 0xC0, 0x94, 0x04, 0xC0, 0xD7, 0x20, 0x7C, 0x09, 0x40, 0x4C, 0x0D, 0x72, 0x03, 0xC0, 0x54,
  0x01, 0x0E, 0xB0, 0x97, 0x38, 0x26, 0xDE, 0x86, 0x82, 0x4D, 0xEA, 0x80, 0x9D, 0x60, 0x85, 0x14,
  0x67, 0x75, 0x37, 0x72, 0x05, 0x0C, 0xF8, 0x1E, 0x81, 0x74, 0x02, 0x0C, 0xFC, 0x0E, 0x06, 0x72,
  0x02, 0x0E, 0xFF, 0x08, 0x70, 0x10, 0xDF, 0x0D, 0x0E, 0xF0, 0x66, 0x09, 0xD0, 0xB0, 0x43, 0x81,
  0x16, 0xEC, 0x0E, 0x01, 0x40, 0x2D, 0x09, 0x70, 0x20, 0xDC, 0x0A, 0x40, 0xAC, 0x0C, 0x72, 0x03,
  0xD0, 0x23, 0x0E, 0xC0, 0x47, 0x30, 0xAC, 0x08, 0x20, 0x4C, 0x0D, 0x74, 0x04, 0xC0, 0xD2, 0x08,
  0xC0, 0x87, 0x50, 0xEC, 0x81, 0x10, 0xBC, 0x05, 0x75, 0x0B, 0xC8, 0x14, 0x0E, 0xC0, 0x27, 0x50,
  0x8C, 0x07, 0x1D, 0x76, 0x06, 0xC0, 0x90, 0x1C, 0x0E, 0x76, 0x04, 0xC0, 0xA0, 0x2C, 0x0E, 0x76,
  0x04, 0xC0, 0xB0, 0x3C, 0x0D, 0x76, 0x03, 0xC0, 0xC0, 0x3C, 0x0D, 0x76, 0x03, 0xC0, 0xC0, 0x2C,
  0x0E, 0x76, 0x04, 0xC0, 0xB0, 0x1C, 0x0E, 0x76, 0x05, 0xC0, 0xA1, 0xD7, 0x60, 0x6C, 0x81, 0x90,
  0xDC, 0x02, 0x75, 0x08, 0xC8, 0x17, 0x0A, 0xC0, 0x57, 0x50, 0xBC, 0x81, 0x40, 0x7C, 0x09, 0x75,
  0x0E, 0xC8, 0x11, 0x03, 0xC0, 0xD7, 0x40, 0x4C, 0x0C, 0x30, 0xDC, 0x04, 0x73, 0x0A, 0xC0, 0x63,
  0x07, 0xC0, 0xC7, 0x20, 0x4D, 0x01, 0x30, 0x10, 0xEC, 0x09, 0x70, 0x20, 0xDC, 0x08, 0x50, 0x6D,
  0x0B, 0x04, 0x38, 0x11, 0x6E, 0xC0, 0xE0, 0x16, 0x0B, 0xF0, 0xD0, 0xEF, 0x05, 0x70, 0x10, 0xCF,
  0xF0, 0x77, 0x30, 0xAF, 0xC0, 0xE0, 0x67, 0x50, 0x40, 0xBF, 0x81, 0xE8, 0x17, 0x71, 0x85, 0x14,
  0x67, 0x75, 0x37, 0x20,
  // "÷" (U+00F7)
  0x73, 0x83, 0x8D, 0xEA, 0x27, 0x75, 0x07, 0xC0, 0xC7, 0x75, 0x0C, 0xD0, 0x27, 0x74, 0x0E, 0xD0,
  0x37, 0x74, 0x0C, 0xD0, 0x27, 0x74, 0x07, 0xC0, 0xC7, 0x76, 0x83, 0x8D, 0xEA, 0x18, 0x09, 0xD2,
  0x00, 0x48, 0x0A, 0x35, 0x10, 0xDF, 0xFF, 0xA0, 0x10, 0xDF, 0xFF, 0xA0, 0x10, 0xDF, 0xFF, 0xA0,
  0x10, 0xDF, 0xFF, 0xA0, 0x18, 0x0A, 0x83, 0x08, 0x38, 0xDE, 0xA2, 0x77, 0x50, 0x7C, 0x0C, 0x77,
  0x50, 0xCD, 0x02, 0x77, 0x40, 0xED, 0x03, 0x77, 0x40, 0xCD, 0x02, 0x77, 0x40, 0x7C, 0x0C, 0x77,
  0x68, 0x38, 0xDE, 0xA2, 0x73,
  // "ø" (U+00F8)
  0x77, 0x70, 0x47, 0x77, 0x28, 0x23, 0xFD, 0x57, 0x38, 0x51, 0x46, 0x76, 0x51, 0x40, 0xBB, 0x03,
  0x70, 0x50, 0xCF, 0x82, 0xC5, 0x04, 0xB0, 0xB6, 0x02, 0x0C, 0xFC, 0x0A, 0x0C, 0xB0, 0x35, 0x02,
  0x0E, 0xFF, 0xA0, 0xB5, 0x01, 0x0D, 0xF0, 0x0D, 0xF9, 0x03, 0x50, 0x9D, 0x0A, 0x03, 0x38, 0x11,
  0x7E, 0xC0, 0xE5, 0x03, 0xD0, 0x77, 0x03, 0xD0, 0x64, 0x0A, 0xC0, 0xA7, 0x10, 0x7D, 0x0E, 0x30,
  0x1D, 0x02, 0x70, 0x10, 0xEE, 0x05, 0x20, 0x6C, 0x0B, 0x71, 0x0A, 0xF0, 0xB2, 0x09, 0xC0, 0x67,
  0x03, 0xB0, 0xB0, 0xEC, 0x20, 0xCC, 0x03, 0x70, 0xCB, 0x02, 0x0A, 0xC0, 0x31, 0xD7, 0x06, 0xB8,
  0x18, 0x08, 0xC0, 0x60, 0x1C, 0x0E, 0x70, 0xEA, 0x0E, 0x20, 0x5C, 0x09, 0x02, 0xC0, 0xC6, 0x08,
  0xB0, 0x62, 0x04, 0xC0, 0xA0, 0x3C, 0x0C, 0x50, 0x2B, 0x0C, 0x30, 0x3C, 0x0B, 0x04, 0xC0, 0xB5,
  0x0B, 0xB0, 0x33, 0x02, 0xC0, 0xC0, 0x4C, 0x0B, 0x40, 0x4B, 0x0A, 0x40, 0x2C, 0x0C, 0x03, 0xC0,
  0xC4, 0x0D, 0xA0, 0xE0, 0x14, 0x03, 0xC0, 0xB0, 0x2C, 0x0C, 0x30, 0x7B, 0x07, 0x50, 0x4C, 0x0A,
  0x01, 0xC0, 0xE2, 0x01, 0x0E, 0xA0, 0xD6, 0x05, 0xC8, 0x19, 0x0E, 0xC8, 0x11, 0x09, 0xB0, 0x56,
  0x07, 0xC8, 0x17, 0x0B, 0xC0, 0x40, 0x3B, 0x0B, 0x70, 0xAC, 0x81, 0x40, 0x8C, 0x08, 0x0B, 0xB0,
  0x27, 0x0E, 0xC8, 0x11, 0x03, 0xC0, 0xEB, 0x09, 0x70, 0x3C, 0x0C, 0x30, 0xDE, 0x0E, 0x01, 0x70,
  0x9C, 0x07, 0x30, 0x7E, 0x06, 0x70, 0x3D, 0x01, 0x40, 0xDC, 0x0E, 0x70, 0x20, 0xDC, 0x09, 0x50,
  0x5D, 0x0B, 0x03, 0x38, 0x11, 0x6E, 0xC0, 0xE0, 0x15, 0x03, 0xF8, 0x1E, 0xDE, 0xF0, 0x56, 0x0B,
  0xFF, 0xA0, 0x76, 0x04, 0xB0, 0xDF, 0xC0, 0xE0, 0x57, 0x0C, 0xB8, 0x12, 0x3A, 0xF8, 0x1E, 0x81,
  0x70, 0x5B, 0x09, 0x38, 0x51, 0x46, 0x77, 0x52, 0x73, 0x0A, 0xB0, 0x27, 0x77, 0x81, 0x6D, 0x97,
  0x77, 0x30, 0x17, 0x76,
  // "ù" (U+00F9)
  0x30, 0x48, 0x01, 0x70, 0x37, 0x71, 0x04, 0xD0, 0xD7, 0x72, 0x09, 0xD0, 0x57, 0x72, 0x0B, 0xC0,
  0xD7, 0x72, 0x01, 0x0D, 0xC0, 0x87, 0x72, 0x01, 0x0D, 0xC0, 0x37, 0x72, 0x02, 0x0E, 0xB0, 0xC7,
  0x73, 0x02, 0x0E, 0xB0, 0x77, 0x73, 0x02, 0x0D, 0xB0, 0x37, 0x73, 0x02, 0x0D, 0xA0, 0xB8, 0x09,
  0xE1, 0x00, 0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01,
  0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01,
  0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01,
  0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01,
  0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x73, 0x01, 0xD0, 0xEC,
  0x01, 0x73, 0x01, 0xD0, 0xEC, 0x01, 0x73, 0x03, 0xD0, 0xDC, 0x01, 0x73, 0x05, 0xD0, 0xDC, 0x03,
  0x73, 0x08, 0xD0, 0xBC, 0x05, 0x73, 0x0C, 0xD0, 0x9C, 0x08, 0x72, 0x02, 0xE0, 0x6C, 0x0D, 0x72,
  0x0A, 0xE0, 0x2D, 0x07, 0x70, 0x6F, 0x10, 0xCD, 0x08, 0x01, 0x30, 0x30, 0xAB, 0x0D, 0xC1, 0x04,
  0xF0, 0x0D, 0xD0, 0x08, 0xC2, 0x0A, 0xFD, 0x81, 0xC0, 0x6C, 0x30, 0xBF, 0xB0, 0xB2, 0x03, 0xC4,
  0x06, 0x0D, 0xE0, 0xD0, 0x63, 0x01, 0xC6, 0x84, 0x25, 0x67, 0x62, 0x73,
  // "ú" (U+00FA)
  0x76, 0x02, 0x80, 0x17, 0x06, 0x77, 0x10, 0xAD, 0x07, 0x77, 0x03, 0xD0, 0xC7, 0x71, 0x0C, 0xC0,
  0xE0, 0x17, 0x70, 0x6C, 0x0E, 0x03, 0x77, 0x01, 0x0E, 0xC0, 0x47, 0x71, 0x0A, 0xC0, 0x57, 0x71,
  0x05, 0xC0, 0x57, 0x71, 0x01, 0x0E, 0xB0, 0x57, 0x72, 0x08, 0xA0, 0xE0, 0x48, 0x09, 0xE3, 0x00,
  0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0,
  0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0,
  0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0,
  0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0,
  0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x73, 0x01, 0xD0, 0xEC, 0x01, 0x73,
  0x01, 0xD0, 0xEC, 0x01, 0x73, 0x03, 0xD0, 0xDC, 0x01, 0x73, 0x05, 0xD0, 0xDC, 0x03, 0x73, 0x08,
  0xD0, 0xBC, 0x05, 0x73, 0x0C, 0xD0, 0x9C, 0x08, 0x72, 0x02, 0xE0, 0x6C, 0x0D, 0x72, 0x0A, 0xE0,
  0x2D, 0x07, 0x70, 0x6F, 0x10, 0xCD, 0x08, 0x01, 0x30, 0x30, 0xAB, 0x0D, 0xC1, 0x04, 0xF0, 0x0D,
  0xD0, 0x08, 0xC2, 0x0A, 0xFD, 0x81, 0xC0, 0x6C, 0x30, 0xBF, 0xB0, 0xB2, 0x03, 0xC4, 0x06, 0x0D,
  0xE0, 0xD0, 0x63, 0x01, 0xC6, 0x84, 0x25, 0x67, 0x62, 0x73,
  // "û" (U+00FB)
  0x71, 0x84, 0x57, 0x77, 0x73, 0x77, 0x10, 0x1D, 0x0D, 0x77, 0x10, 0xAE, 0x06, 0x76, 0x04, 0xF0,
  0xE0, 0x27, 0x40, 0x10, 0xDB, 0x0C, 0x0E, 0xB0, 0xB7, 0x40, 0xAB, 0x82, 0xD1, 0x2E, 0xB0, 0x77,
  0x20, 0x5B, 0x0D, 0x01, 0x20, 0x30, 0xEB, 0x03, 0x70, 0x20, 0xEA, 0x0D, 0x01, 0x40, 0x4B, 0x0D,
  0x01, 0x60, 0xDA, 0x0D, 0x02, 0x60, 0x40, 0xEA, 0x0B, 0x50, 0x8A, 0x0D, 0x01, 0x71, 0x03, 0x0D,
  0xA0, 0x68, 0x09, 0xD4, 0x00, 0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74,
  0xD0, 0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74,
  0xD0, 0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74,
  0xD0, 0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74,
  0xD0, 0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x73,
  0x01, 0xD0, 0xEC, 0x01, 0x73, 0x01, 0xD0, 0xEC, 0x01, 0x73, 0x03, 0xD0, 0xDC, 0x01, 0x73, 0x05,
  0xD0, 0xDC, 0x03, 0x73, 0x08, 0xD0, 0xBC, 0x05, 0x73, 0x0C, 0xD0, 0x9C, 0x08, 0x72, 0x02, 0xE0,
  0x6C, 0x0D, 0x72, 0x0A, 0xE0, 0x2D, 0x07, 0x70, 0x6F, 0x10, 0xCD, 0x08, 0x01, 0x30, 0x30, 0xAB,
  0x0D, 0xC1, 0x04, 0xF0, 0x0D, 0xD0, 0x08, 0xC2, 0x0A, 0xFD, 0x81, 0xC0, 0x6C, 0x30, 0xBF, 0xB0,
  0xB2, 0x03, 0xC4, 0x06, 0x0D, 0xE0, 0xD0, 0x63, 0x01, 0xC6, 0x84, 0x25, 0x67, 0x62, 0x73,
  // "ü" (U+00FC)
  0x48, 0x27, 0xDE, 0x86, 0x83, 0x4D, 0xEA, 0x16, 0x03, 0xC0, 0x64, 0x01, 0x0E, 0xB0, 0x96, 0x07,
  0xC0, 0x94, 0x04, 0xC0, 0xD6, 0x07, 0xC0, 0x94, 0x04, 0xC0, 0xD6, 0x03, 0xC0, 0x54, 0x01, 0x0E,
  0xB0, 0x97, 0x82, 0x6D, 0xE8, 0x68, 0x24, 0xDE, 0xA8, 0x09, 0xD6, 0x00, 0xEC, 0x01, 0x74, 0xD0,
  0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0,
  0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0,
  0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0,
  0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x74, 0xD0,
  0xEC, 0x01, 0x74, 0xD0, 0xEC, 0x01, 0x73, 0x01, 0xD0, 0xEC, 0x01, 0x73, 0x01, 0xD0, 0xEC, 0x01,
  0x73, 0x03, 0xD0, 0xDC, 0x01, 0x73, 0x05, 0xD0, 0xDC, 0x03, 0x73, 0x08, 0xD0, 0xBC, 0x05, 0x73,
  0x0C, 0xD0, 0x9C, 0x08, 0x72, 0x02, 0xE0, 0x6C, 0x0D, 0x72, 0x0A, 0xE0, 0x2D, 0x07, 0x70, 0x6F,
  0x10, 0xCD, 0x08, 0x01, 0x30, 0x30, 0xAB, 0x0D, 0xC1, 0x04, 0xF0, 0x0D, 0xD0, 0x08, 0xC2, 0x0A,
  0xFD, 0x81, 0xC0, 0x6C, 0x30, 0xBF, 0xB0, 0xB2, 0x03, 0xC4, 0x06, 0x0D, 0xE0, 0xD0, 0x63, 0x01,
  0xC6, 0x84, 0x25, 0x67, 0x62, 0x73,
  // "ý" (U+00FD)
  0x77, 0x02, 0x80, 0x17, 0x06, 0x77, 0x40, 0xAD, 0x07, 0x77, 0x30, 0x3D, 0x0C, 0x77, 0x40, 0xCC,
  0x0E, 0x01, 0x77, 0x30, 0x6C, 0x0E, 0x03, 0x77, 0x30, 0x10, 0xEC, 0x04, 0x77, 0x40, 0xAC, 0x05,
  0x77, 0x40, 0x5C, 0x05, 0x77, 0x40, 0x10, 0xEB, 0x05, 0x77, 0x50, 0x8A, 0x0E, 0x04, 0x80, 0xA8,
  0x40, 0x0A, 0xC0, 0x87, 0x60, 0xBC, 0x06, 0x05, 0xC0, 0xC7, 0x6D, 0x01, 0x1D, 0x01, 0x74, 0x04,
  0xC0, 0xC2, 0x0B, 0xC0, 0x67, 0x40, 0x9C, 0x07, 0x20, 0x6C, 0x0A, 0x74, 0x0D, 0xC0, 0x32, 0x01,
  0xC0, 0xE7, 0x30, 0x2C, 0x0E, 0x40, 0xCC, 0x03, 0x72, 0x06, 0xC0, 0x94, 0x07, 0xC0, 0x87, 0x20,
  0xAC, 0x05, 0x40, 0x2C, 0x0C, 0x72, 0x0E, 0xC6, 0x0D, 0xC0, 0x17, 0x03, 0xC0, 0xB6, 0x08, 0xC0,
  0x57, 0x07, 0xC0, 0x66, 0x04, 0xC0, 0xA7, 0x0C, 0xC0, 0x27, 0x0E, 0xB0, 0xE7, 0xC0, 0xD7, 0x10,
  0x9C, 0x03, 0x50, 0x5C, 0x08, 0x71, 0x05, 0xC0, 0x75, 0x09, 0xC0, 0x37, 0x2C, 0x0C, 0x50, 0xDB,
  0x0E, 0x73, 0x0B, 0xC0, 0x13, 0x02, 0xC0, 0xA7, 0x30, 0x6C, 0x05, 0x30, 0x6C, 0x05, 0x73, 0x01,
  0xC0, 0x93, 0x0A, 0xC0, 0x17, 0x40, 0xCB, 0x0D, 0x30, 0xEB, 0x0B, 0x75, 0x07, 0xC8, 0x12, 0x03,
  0xC0, 0x77, 0x50, 0x2C, 0x81, 0x60, 0x7C, 0x02, 0x76, 0x0D, 0xB8, 0x1A, 0x0B, 0xB0, 0xD7, 0x70,
  0x8B, 0x81, 0xD0, 0xEB, 0x09, 0x77, 0x03, 0xC0, 0x3C, 0x04, 0x77, 0x10, 0xEB, 0x09, 0xB0, 0xE7,
  0x72, 0x09, 0xF0, 0xA7, 0x72, 0x04, 0xF0, 0x67, 0x73, 0xF0, 0x17, 0x73, 0x0A, 0xD0, 0xC7, 0x74,
  0x06, 0xD0, 0x77, 0x74, 0x01, 0xD0, 0x37, 0x74, 0x03, 0xC0, 0xE7, 0x75, 0x07, 0xC0, 0x97, 0x75,
  0x0C, 0xC0, 0x47, 0x74, 0x01, 0xD7, 0x75, 0x06, 0xC0, 0xB7, 0x75, 0x0C, 0xC0, 0x57, 0x74, 0x03,
  0xD7, 0x75, 0x0B, 0xC0, 0x97, 0x74, 0x08, 0xD0, 0x27, 0x58, 0x42, 0x86, 0x56, 0xCD, 0x09, 0x76,
  0x03, 0xFA, 0x0D, 0x01, 0x76, 0x03, 0xF9, 0x0E, 0x03, 0x77, 0x03, 0xF0, 0xD0, 0x37, 0x71, 0x86,
  0x1A, 0xDE, 0xFD, 0xA6, 0x77, 0x30,
  // "þ" (U+00FE)
  0x84, 0x57, 0x77, 0x71, 0x77, 0x40, 0xBC, 0x03, 0x77, 0x40, 0xBC, 0x03, 0x77, 0x40, 0xBC, 0x03,
  0x77, 0x40, 0xBC, 0x03, 0x77, 0x40, 0xBC, 0x03, 0x77, 0x40, 0xBC, 0x03, 0x77, 0x40, 0xBC, 0x03,
  0x77, 0x40, 0xBC, 0x03, 0x77, 0x40, 0xBC, 0x03, 0x77, 0x40, 0xBC, 0x03, 0x77, 0x40, 0xBC, 0x03,
  0x77, 0x40, 0xBC, 0x03, 0x77, 0x40, 0xBC, 0x03, 0x77, 0x40, 0xBC, 0x03, 0x48, 0x41, 0x57, 0x76,
  0x37, 0x10, 0xBC, 0x03, 0x20, 0x20, 0xAE, 0x0E, 0x07, 0x60, 0xBC, 0x82, 0x20, 0x5E, 0xFA, 0x0D,
  0x02, 0x40, 0xBC, 0x02, 0x04, 0xFD, 0x0E, 0x02, 0x30, 0xBC, 0x03, 0x0E, 0xC0, 0x0D, 0xF0, 0xC3,
  0x0B, 0xC0, 0xBA, 0x0D, 0x05, 0x40, 0x50, 0xDD, 0x06, 0x20, 0xBE, 0x0B, 0x70, 0x10, 0xCC, 0x0D,
  0x20, 0xBD, 0x0E, 0x01, 0x71, 0x02, 0xD8, 0x15, 0x0B, 0xD0, 0x77, 0x30, 0xAC, 0x81, 0xA0, 0xBD,
  0x01, 0x73, 0x04, 0xC8, 0x1E, 0x0B, 0xC0, 0xC7, 0x5D, 0x02, 0x0B, 0xC0, 0x97, 0x50, 0xCC, 0x05,
  0x0B, 0xC0, 0x77, 0x50, 0xAC, 0x07, 0x0B, 0xC0, 0x57, 0x50, 0x8C, 0x09, 0x0B, 0xC0, 0x47, 0x50,
  0x7C, 0x0A, 0x0B, 0xC0, 0x37, 0x50, 0x6C, 0x00, 0xBC, 0x03, 0x75, 0x06, 0xC0, 0x0B, 0xC0, 0x37,
  0x50, 0x6C, 0x00, 0xBC, 0x04, 0x75, 0x06, 0xC0, 0x0B, 0xC0, 0x47, 0x50, 0x7C, 0x0A, 0x0B, 0xC0,
  0x67, 0x50, 0x8C, 0x09, 0x0B, 0xC0, 0x87, 0x50, 0xBC, 0x07, 0x0B, 0xC0, 0xA7, 0x50, 0xDC, 0x05,
  0x0B, 0xC0, 0xD7, 0x40, 0x1D, 0x02, 0x0B, 0xD0, 0x27, 0x30, 0x5C, 0x81, 0xE0, 0xBD, 0x08, 0x73,
  0x0B, 0xC8, 0x19, 0x0B, 0xD0, 0xE0, 0x17, 0x10, 0x3D, 0x81, 0x40, 0xBE, 0x0C, 0x01, 0x60, 0x10,
  0xDC, 0x0D, 0x20, 0xBC, 0x0D, 0xA0, 0xD0, 0x54, 0x05, 0x0D, 0xD0, 0x52, 0x0B, 0xC0, 0x3D, 0x81,
  0xDD, 0xEE, 0x0C, 0x30, 0xBC, 0x02, 0x06, 0xFD, 0x0E, 0x01, 0x30, 0xBC, 0x82, 0x30, 0x5E, 0xFA,
  0x0D, 0x02, 0x40, 0xBC, 0x04, 0x20, 0x20, 0xAE, 0x0E, 0x08, 0x60, 0xBC, 0x04, 0x48, 0x41, 0x46,
  0x76, 0x47, 0x10, 0xBC, 0x04, 0x77, 0x40, 0xBC, 0x04, 0x77, 0x40, 0xBC, 0x04, 0x77, 0x40, 0xBC,
  0x04, 0x77, 0x40, 0xBC, 0x04, 0x77, 0x40, 0xBC, 0x04, 0x77, 0x40, 0xBC, 0x04, 0x77, 0x40, 0xBC,
  0x04, 0x77, 0x40, 0xBC, 0x04, 0x77, 0x40, 0xBC, 0x04, 0x77, 0x40, 0xBC, 0x04, 0x77, 0x40, 0xBC,
  0x04, 0x77, 0x40, 0xBC, 0x04, 0x77, 0x40,
  // "ÿ" (U+00FF)
  0x58, 0x27, 0xDE, 0x86, 0x83, 0x4D, 0xEA, 0x17, 0x20, 0x3C, 0x06, 0x40, 0x10, 0xEB, 0x09, 0x72,
  0x07, 0xC0, 0x94, 0x04, 0xC0, 0xD7, 0x20, 0x7C, 0x09, 0x40, 0x4C, 0x0D, 0x72, 0x03, 0xC0, 0x54,
  0x01, 0x0E, 0xB0, 0x97, 0x38, 0x26, 0xDE, 0x86, 0x82, 0x4D, 0xEA, 0x80, 0x9F, 0x70, 0x0A, 0xC0,
  0x87, 0x60, 0xBC, 0x06, 0x05, 0xC0, 0xC7, 0x6D, 0x01, 0x1D, 0x01, 0x74, 0x04, 0xC0, 0xC2, 0x0B,
  0xC0, 0x67, 0x40, 0x9C, 0x07, 0x20, 0x6C, 0x0A, 0x74, 0x0D, 0xC0, 0x32, 0x01, 0xC0, 0xE7, 0x30,
  0x2C, 0x0E, 0x40, 0xCC, 0x03, 0x72, 0x06, 0xC0, 0x94, 0x07, 0xC0, 0x87, 0x20, 0xAC, 0x05, 0x40,
  0x2C, 0x0C, 0x72, 0x0E, 0xC6, 0x0D, 0xC0, 0x17, 0x03, 0xC0, 0xB6, 0x08, 0xC0, 0x57, 0x07, 0xC0,
  0x66, 0x04, 0xC0, 0xA7, 0x0C, 0xC0, 0x27, 0x0E, 0xB0, 0xE7, 0xC0, 0xD7, 0x10, 0x9C, 0x03, 0x50,
  0x5C, 0x08, 0x71, 0x05, 0xC0, 0x75, 0x09, 0xC0, 0x37, 0x2C, 0x0C, 0x50, 0xDB, 0x0E, 0x73, 0x0B,
  0xC0, 0x13, 0x02, 0xC0, 0xA7, 0x30, 0x6C, 0x05, 0x30, 0x6C, 0x05, 0x73, 0x01, 0xC0, 0x93, 0x0A,
  0xC0, 0x17, 0x40, 0xCB, 0x0D, 0x30, 0xEB, 0x0B, 0x75, 0x07, 0xC8, 0x12, 0x03, 0xC0, 0x77, 0x50,
  0x2C, 0x81, 0x60, 0x7C, 0x02, 0x76, 0x0D, 0xB8, 0x1A, 0x0B, 0xB0, 0xD7, 0x70, 0x8B, 0x81, 0xD0,
  0xEB, 0x09, 0x77, 0x03, 0xC0, 0x3C, 0x04, 0x77, 0x10, 0xEB, 0x09, 0xB0, 0xE7, 0x72, 0x09, 0xF0,
  0xA7, 0x72, 0x04, 0xF0, 0x67, 0x73, 0xF0, 0x17, 0x73, 0x0A, 0xD0, 0xC7, 0x74, 0x06, 0xD0, 0x77,
  0x74, 0x01, 0xD0, 0x37, 0x74, 0x03, 0xC0, 0xE7, 0x75, 0x07, 0xC0, 0x97, 0x75, 0x0C, 0xC0, 0x47,
  0x74, 0x01, 0xD7, 0x75, 0x06, 0xC0, 0xB7, 0x75, 0x0C, 0xC0, 0x57, 0x74, 0x03, 0xD7, 0x75, 0x0B,
  0xC0, 0x97, 0x74, 0x08, 0xD0, 0x27, 0x58, 0x42, 0x86, 0x56, 0xCD, 0x09, 0x76, 0x03, 0xFA, 0x0D,
  0x01, 0x76, 0x03, 0xF9, 0x0E, 0x03, 0x77, 0x03, 0xF0, 0xD0, 0x37, 0x71, 0x86, 0x1A, 0xDE, 0xFD,
  0xA6, 0x77, 0x30,
  // "Ā" (U+0100)
  0x70, 0x38, 0x09, 0x25, 0x04, 0x77, 0x10, 0x9F, 0xF0, 0xE7, 0x71, 0x09, 0xFF, 0x0E, 0x77, 0x10,
  0x9F, 0xF0, 0xE7, 0x71, 0x09, 0xFF, 0x0E, 0x80, 0xAD, 0x30, 0x0D, 0xD0, 0x27, 0x77, 0x20, 0x2E,
  0x06, 0x77, 0x72, 0x06, 0xE0, 0xB7, 0x77, 0x20, 0xAF, 0x77, 0x72, 0x0E, 0xF0, 0x47, 0x77, 0x04,
  0xC0, 0xCB, 0x09, 0x77, 0x70, 0x8B, 0x0C, 0x09, 0xB0, 0xD7, 0x77, 0x0D, 0xB0, 0x80, 0x6C, 0x02,
  0x77, 0x50, 0x2C, 0x05, 0x02, 0xC0, 0x67, 0x75, 0x06, 0xC8, 0x12, 0x0E, 0xB0, 0xB7, 0x75, 0x0B,
  0xB0, 0xE2, 0x0B, 0xC7, 0x75, 0x0E, 0xB0, 0xB2, 0x07, 0xC0, 0x47, 0x73, 0x04, 0xC0, 0x72, 0x03,
  0xC0, 0x97, 0x73, 0x08, 0xC0, 0x33, 0x0E, 0xB0, 0xD7, 0x73, 0x0D, 0xB0, 0xE4, 0x0A, 0xC0, 0x27,
  0x71, 0x02, 0xC0, 0xA4, 0x06, 0xC0, 0x77, 0x71, 0x06, 0xC0, 0x64, 0x02, 0xC0, 0xB7, 0x71, 0x0B,
  0xC0, 0x25, 0x0D, 0xC7, 0x71, 0x0E, 0xB0, 0xD6, 0x09, 0xC0, 0x47, 0x60, 0x4C, 0x09, 0x60, 0x5C,
  0x09, 0x76, 0x08, 0xC0, 0x56, 0x01, 0xC0, 0xD7, 0x60, 0xDC, 0x01, 0x70, 0xDC, 0x02, 0x74, 0x02,
  0xC0, 0xD7, 0x10, 0x8C, 0x07, 0x74, 0x06, 0xC0, 0x97, 0x10, 0x4C, 0x0B, 0x74, 0x0B, 0xC0, 0x57,
  0x2D, 0x74, 0x0E, 0xFF, 0xD0, 0x57, 0x20, 0x4F, 0xFE, 0x09, 0x72, 0x08, 0xFF, 0xE0, 0xD7, 0x20,
  0xDF, 0xFF, 0x02, 0x70, 0x2D, 0x80, 0x90, 0x50, 0xCC, 0x07, 0x70, 0x6C, 0x0C, 0x75, 0x07, 0xC0,
  0xB7, 0x0B, 0xC0, 0x87, 0x50, 0x2D, 0x01, 0x60, 0xEC, 0x04, 0x76, 0x0D, 0xC0, 0x55, 0x04, 0xC0,
  0xE7, 0x70, 0x9C, 0x09, 0x50, 0x8C, 0x0B, 0x77, 0x05, 0xC0, 0xE5, 0x0D, 0xC0, 0x67, 0x70, 0x1D,
  0x03, 0x30, 0x2D, 0x02, 0x77, 0x10, 0xCC, 0x07, 0x30, 0x6C, 0x0D, 0x77, 0x20, 0x8C, 0x0C, 0x30,
  0xBC, 0x09, 0x77, 0x20, 0x4D, 0x01, 0x20, 0xEC, 0x05, 0x77, 0x3D, 0x81, 0x50, 0x4D, 0x01, 0x77,
  0x30, 0xBC, 0x81, 0x90, 0x8C, 0x0C, 0x77, 0x40, 0x7C, 0x81, 0xE0, 0xDC, 0x08, 0x77, 0x40, 0x2D,
  0x03,
  // "ā" (U+0101)
  0x40, 0x38, 0x09, 0x25, 0x04, 0x60, 0x9F, 0xF0, 0xE6, 0x09, 0xFF, 0x0E, 0x60, 0x9F, 0xF0, 0xE6,
  0x09, 0xFF, 0x0E, 0x80, 0x9B, 0x60, 0x85, 0x14, 0x57, 0x76, 0x47, 0x58, 0x12, 0x8D, 0xF9, 0x0B,
  0x03, 0x70, 0x20, 0xAF, 0xE0, 0x76, 0x0D, 0xFF, 0x90, 0x65, 0x06, 0xE8, 0x1E, 0xDE, 0xE0, 0xE0,
  0x15, 0x83, 0xEF, 0xD8, 0x34, 0x02, 0x09, 0xD0, 0x75, 0x06, 0x05, 0x72, 0x09, 0xC0, 0xC7, 0x72,
  0x01, 0xD7, 0x73, 0x0B, 0xC0, 0x37, 0x72, 0x08, 0xC0, 0x57, 0x72, 0x07, 0xC0, 0x67, 0x72, 0x07,
  0xC0, 0x67, 0x72, 0x07, 0xC0, 0x76, 0x84, 0x16, 0x9C, 0xDE, 0xFA, 0x07, 0x40, 0x10, 0x9F, 0xF9,
  0x07, 0x30, 0x50, 0xEF, 0xFA, 0x07, 0x20, 0x5F, 0xFC, 0x81, 0x70, 0x2E, 0x82, 0xD7, 0x31, 0x40,
  0x7C, 0x81, 0x70, 0xAD, 0x07, 0x71, 0x07, 0xC0, 0x70, 0x1D, 0x08, 0x72, 0x07, 0xC0, 0x70, 0x5C,
  0x0E, 0x73, 0x07, 0xC0, 0x70, 0x8C, 0x09, 0x73, 0x08, 0xC0, 0x70, 0x9C, 0x07, 0x73, 0x09, 0xC0,
  0x70, 0xAC, 0x06, 0x73, 0x0C, 0xC0, 0x70, 0xAC, 0x06, 0x72, 0x01, 0xD0, 0x70, 0x9C, 0x08, 0x72,
  0x07, 0xD0, 0x70, 0x6C, 0x0D, 0x71, 0x02, 0x0E, 0xD0, 0x70, 0x2D, 0x06, 0x60, 0x10, 0xDE, 0x81,
  0x70, 0xCD, 0x07, 0x38, 0x11, 0x6E, 0xA0, 0x9C, 0x81, 0x70, 0x5F, 0x00, 0xDC, 0x81, 0xD0, 0xDB,
  0x07, 0x20, 0xBF, 0xC8, 0x2E, 0x20, 0xBB, 0x07, 0x30, 0xCF, 0xA0, 0xE0, 0x32, 0x08, 0xB0, 0x74,
  0x08, 0x0E, 0xD8, 0x1E, 0x91, 0x30, 0x6B, 0x07, 0x68, 0x34, 0x67, 0x64, 0x74,
  // "Ă" (U+0102)
  0x70, 0x8A, 0x0A, 0x72, 0xB0, 0x27, 0x70, 0x6A, 0x0E, 0x71, 0x06, 0xB0, 0x17, 0x70, 0x3B, 0x0A,
  0x60, 0x30, 0xEA, 0x0C, 0x77, 0x20, 0xDB, 0x84, 0xE8, 0x65, 0x7B, 0xC0, 0x77, 0x72, 0x07, 0xFD,
  0x0E, 0x77, 0x40, 0xBF, 0xC0, 0x37, 0x75, 0x0A, 0xF9, 0x0D, 0x03, 0x77, 0x78, 0x63, 0x9D, 0xEF,
  0xDB, 0x68, 0x0A, 0xD7, 0x00, 0xDD, 0x02, 0x77, 0x72, 0x02, 0xE0, 0x67, 0x77, 0x20, 0x6E, 0x0B,
  0x77, 0x72, 0x0A, 0xF7, 0x77, 0x20, 0xEF, 0x04, 0x77, 0x70, 0x4C, 0x0C, 0xB0, 0x97, 0x77, 0x08,
  0xB0, 0xC0, 0x9B, 0x0D, 0x77, 0x70, 0xDB, 0x08, 0x06, 0xC0, 0x27, 0x75, 0x02, 0xC0, 0x50, 0x2C,
  0x06, 0x77, 0x50, 0x6C, 0x81, 0x20, 0xEB, 0x0B, 0x77, 0x50, 0xBB, 0x0E, 0x20, 0xBC, 0x77, 0x50,
  0xEB, 0x0B, 0x20, 0x7C, 0x04, 0x77, 0x30, 0x4C, 0x07, 0x20, 0x3C, 0x09, 0x77, 0x30, 0x8C, 0x03,
  0x30, 0xEB, 0x0D, 0x77, 0x30, 0xDB, 0x0E, 0x40, 0xAC, 0x02, 0x77, 0x10, 0x2C, 0x0A, 0x40, 0x6C,
  0x07, 0x77, 0x10, 0x6C, 0x06, 0x40, 0x2C, 0x0B, 0x77, 0x10, 0xBC, 0x02, 0x50, 0xDC, 0x77, 0x10,
  0xEB, 0x0D, 0x60, 0x9C, 0x04, 0x76, 0x04, 0xC0, 0x96, 0x05, 0xC0, 0x97, 0x60, 0x8C, 0x05, 0x60,
  0x1C, 0x0D, 0x76, 0x0D, 0xC0, 0x17, 0x0D, 0xC0, 0x27, 0x40, 0x2C, 0x0D, 0x71, 0x08, 0xC0, 0x77,
  0x40, 0x6C, 0x09, 0x71, 0x04, 0xC0, 0xB7, 0x40, 0xBC, 0x05, 0x72, 0xD7, 0x40, 0xEF, 0xFD, 0x05,
  0x72, 0x04, 0xFF, 0xE0, 0x97, 0x20, 0x8F, 0xFE, 0x0D, 0x72, 0x0D, 0xFF, 0xF0, 0x27, 0x02, 0xD8,
  0x09, 0x05, 0x0C, 0xC0, 0x77, 0x06, 0xC0, 0xC7, 0x50, 0x7C, 0x0B, 0x70, 0xBC, 0x08, 0x75, 0x02,
  0xD0, 0x16, 0x0E, 0xC0, 0x47, 0x60, 0xDC, 0x05, 0x50, 0x4C, 0x0E, 0x77, 0x09, 0xC0, 0x95, 0x08,
  0xC0, 0xB7, 0x70, 0x5C, 0x0E, 0x50, 0xDC, 0x06, 0x77, 0x01, 0xD0, 0x33, 0x02, 0xD0, 0x27, 0x71,
  0x0C, 0xC0, 0x73, 0x06, 0xC0, 0xD7, 0x72, 0x08, 0xC0, 0xC3, 0x0B, 0xC0, 0x97, 0x72, 0x04, 0xD0,
  0x12, 0x0E, 0xC0, 0x57, 0x73, 0xD8, 0x15, 0x04, 0xD0, 0x17, 0x73, 0x0B, 0xC8, 0x19, 0x08, 0xC0,
  0xC7, 0x74, 0x07, 0xC8, 0x1E, 0x0D, 0xC0, 0x87, 0x74, 0x02, 0xD0, 0x30,
  // "ă" (U+0103)
  0x40, 0x8A, 0x0A, 0x72, 0xB0, 0x25, 0x06, 0xA0, 0xE7, 0x10, 0x6B, 0x01, 0x50, 0x3B, 0x0A, 0x60,
  0x30, 0xEA, 0x0C, 0x70, 0xDB, 0x84, 0xE8, 0x65, 0x7B, 0xC0, 0x77, 0x07, 0xFD, 0x0E, 0x72, 0x0B,
  0xFC, 0x03, 0x73, 0x0A, 0xF9, 0x0D, 0x03, 0x75, 0x86, 0x39, 0xDE, 0xFD, 0xB6, 0x80, 0x9C, 0x20,
  0x85, 0x14, 0x57, 0x76, 0x47, 0x58, 0x12, 0x8D, 0xF9, 0x0B, 0x03, 0x70, 0x20, 0xAF, 0xE0, 0x76,
  0x0D, 0xFF, 0x90, 0x65, 0x06, 0xE8, 0x1E, 0xDE, 0xE0, 0xE0, 0x15, 0x83, 0xEF, 0xD8, 0x34, 0x02,
  0x09, 0xD0, 0x75, 0x06, 0x05, 0x72, 0x09, 0xC0, 0xC7, 0x72, 0x01, 0xD7, 0x73, 0x0B, 0xC0, 0x37,
  0x72, 0x08, 0xC0, 0x57, 0x72, 0x07, 0xC0, 0x67, 0x72, 0x07, 0xC0, 0x67, 0x72, 0x07, 0xC0, 0x76,
  0x84, 0x16, 0x9C, 0xDE, 0xFA, 0x07, 0x40, 0x10, 0x9F, 0xF9, 0x07, 0x30, 0x50, 0xEF, 0xFA, 0x07,
  0x20, 0x5F, 0xFC, 0x81, 0x70, 0x2E, 0x82, 0xD7, 0x31, 0x40, 0x7C, 0x81, 0x70, 0xAD, 0x07, 0x71,
  0x07, 0xC0, 0x70, 0x1D, 0x08, 0x72, 0x07, 0xC0, 0x70, 0x5C, 0x0E, 0x73, 0x07, 0xC0, 0x70, 0x8C,
  0x09, 0x73, 0x08, 0xC0, 0x70, 0x9C, 0x07, 0x73, 0x09, 0xC0, 0x70, 0xAC, 0x06, 0x73, 0x0C, 0xC0,
  0x70, 0xAC, 0x06, 0x72, 0x01, 0xD0, 0x70, 0x9C, 0x08, 0x72, 0x07, 0xD0, 0x70, 0x6C, 0x0D, 0x71,
  0x02, 0x0E, 0xD0, 0x70, 0x2D, 0x06, 0x60, 0x10, 0xDE, 0x81, 0x70, 0xCD, 0x07, 0x38, 0x11, 0x6E,
  0xA0, 0x9C, 0x81, 0x70, 0x5F, 0x00, 0xDC, 0x81, 0xD0, 0xDB, 0x07, 0x20, 0xBF, 0xC8, 0x2E, 0x20,
  0xBB, 0x07, 0x30, 0xCF, 0xA0, 0xE0, 0x32, 0x08, 0xB0, 0x74, 0x08, 0x0E, 0xD8, 0x1E, 0x91, 0x30,
  0x6B, 0x07, 0x68, 0x34, 0x67, 0x64, 0x74,
  // "Ą" (U+0104)
  0x75, 0x0D, 0xD0, 0x27, 0x77, 0x20, 0x2E, 0x06, 0x77, 0x72, 0x06, 0xE0, 0xB7, 0x77, 0x20, 0xAF,
  0x77, 0x72, 0x0E, 0xF0, 0x47, 0x77, 0x04, 0xC0, 0xCB, 0x09, 0x77, 0x70, 0x8B, 0x0C, 0x09, 0xB0,
  0xD7, 0x77, 0x0D, 0xB0, 0x80, 0x6C, 0x02, 0x77, 0x50, 0x2C, 0x05, 0x02, 0xC0, 0x67, 0x75, 0x06,
  0xC8, 0x12, 0x0E, 0xB0, 0xB7, 0x75, 0x0B, 0xB0, 0xE2, 0x0B, 0xC7, 0x75, 0x0E, 0xB0, 0xB2, 0x07,
  0xC0, 0x47, 0x73, 0x04, 0xC0, 0x72, 0x03, 0xC0, 0x97, 0x73, 0x08, 0xC0, 0x33, 0x0E, 0xB0, 0xD7,
  0x73, 0x0D, 0xB0, 0xE4, 0x0A, 0xC0, 0x27, 0x71, 0x02, 0xC0, 0xA4, 0x06, 0xC0, 0x77, 0x71, 0x06,
  0xC0, 0x64, 0x02, 0xC0, 0xB7, 0x71, 0x0B, 0xC0, 0x25, 0x0D, 0xC7, 0x71, 0x0E, 0xB0, 0xD6, 0x09,
  0xC0, 0x47, 0x60, 0x4C, 0x09, 0x60, 0x5C, 0x09, 0x76, 0x08, 0xC0, 0x56, 0x01, 0xC0, 0xD7, 0x60,
  0xDC, 0x01, 0x70, 0xDC, 0x02, 0x74, 0x02, 0xC0, 0xD7, 0x10, 0x8C, 0x07, 0x74, 0x06, 0xC0, 0x97,
  0x10, 0x4C, 0x0B, 0x74, 0x0B, 0xC0, 0x57, 0x2D, 0x74, 0x0E, 0xFF, 0xD0, 0x57, 0x20, 0x4F, 0xFE,
  0x09, 0x72, 0x08, 0xFF, 0xE0, 0xD7, 0x20, 0xDF, 0xFF, 0x02, 0x70, 0x2D, 0x80, 0x90, 0x50, 0xCC,
  0x07, 0x70, 0x6C, 0x0C, 0x75, 0x07, 0xC0, 0xB7, 0x0B, 0xC0, 0x87, 0x50, 0x2D, 0x01, 0x60, 0xEC,
  0x04, 0x76, 0x0D, 0xC0, 0x55, 0x04, 0xC0, 0xE7, 0x70, 0x9C, 0x09, 0x50, 0x8C, 0x0B, 0x77, 0x05,
  0xC0, 0xE5, 0x0D, 0xC0, 0x67, 0x70, 0x1D, 0x03, 0x30, 0x2D, 0x02, 0x77, 0x10, 0xCC, 0x07, 0x30,
  0x6C, 0x0D, 0x77, 0x20, 0x8C, 0x0C, 0x30, 0xBC, 0x09, 0x77, 0x20, 0x4D, 0x01, 0x20, 0xEC, 0x05,
  0x77, 0x3D, 0x81, 0x50, 0x4D, 0x01, 0x77, 0x30, 0xBC, 0x81, 0x90, 0x8C, 0x0C, 0x77, 0x40, 0x7C,
  0x81, 0xE0, 0xDC, 0x08, 0x77, 0x40, 0xDD, 0x03, 0x77, 0x72, 0x0A, 0xA0, 0xD0, 0x17, 0x77, 0x40,
  0x7B, 0x02, 0x77, 0x74, 0x02, 0xB0, 0x77, 0x77, 0x50, 0xBB, 0x01, 0x77, 0x74, 0x01, 0xB0, 0xB7,
  0x77, 0x50, 0x6B, 0x08, 0x77, 0x75, 0x08, 0xB0, 0x87, 0x77, 0x50, 0x8B, 0x0B, 0x77, 0x75, 0x07,
  0xC8, 0x38, 0x10, 0x11, 0x77, 0x70, 0x4F, 0x90, 0x67, 0x77, 0x10, 0xDF, 0x06, 0x77, 0x71, 0x03,
  0x0E, 0xE0, 0x67, 0x77, 0x28, 0x61, 0x8C, 0xEF, 0xDA, 0x31,
  // "ą" (U+0105)
  0x71, 0x85, 0x14, 0x57, 0x76, 0x47, 0x68, 0x12, 0x8D, 0xF9, 0x0B, 0x03, 0x71, 0x02, 0x0A, 0xFE,
  0x07, 0x70, 0xDF, 0xF9, 0x06, 0x60, 0x6E, 0x81, 0xED, 0xEE, 0x0E, 0x01, 0x68, 0x3E, 0xFD, 0x83,
  0x40, 0x20, 0x9D, 0x07, 0x60, 0x60, 0x57, 0x20, 0x9C, 0x0C, 0x77, 0x30, 0x1D, 0x77, 0x40, 0xBC,
  0x03, 0x77, 0x30, 0x8C, 0x05, 0x77, 0x30, 0x7C, 0x06, 0x77, 0x30, 0x7C, 0x06, 0x77, 0x30, 0x7C,
  0x07, 0x78, 0x41, 0x69, 0xCD, 0xEF, 0xA0, 0x75, 0x01, 0x09, 0xFF, 0x90, 0x74, 0x05, 0x0E, 0xFF,
  0xA0, 0x73, 0x05, 0xFF, 0xC0, 0x72, 0x02, 0xE8, 0x2D, 0x73, 0x14, 0x07, 0xC0, 0x72, 0x0A, 0xD0,
  0x77, 0x10, 0x7C, 0x81, 0x70, 0x1D, 0x08, 0x72, 0x07, 0xC8, 0x17, 0x05, 0xC0, 0xE7, 0x30, 0x7C,
  0x81, 0x70, 0x8C, 0x09, 0x73, 0x08, 0xC8, 0x17, 0x09, 0xC0, 0x77, 0x30, 0x9C, 0x81, 0x70, 0xAC,
  0x06, 0x73, 0x0C, 0xC8, 0x17, 0x0A, 0xC0, 0x67, 0x20, 0x1D, 0x81, 0x70, 0x9C, 0x08, 0x72, 0x07,
  0xD8, 0x17, 0x06, 0xC0, 0xD7, 0x10, 0x20, 0xED, 0x81, 0x70, 0x2D, 0x06, 0x60, 0x10, 0xDE, 0x07,
  0x20, 0xCD, 0x07, 0x38, 0x11, 0x6E, 0xA0, 0x9C, 0x07, 0x20, 0x5F, 0x00, 0xDC, 0x81, 0xD0, 0xDB,
  0x07, 0x30, 0xBF, 0xC8, 0x2E, 0x20, 0xBB, 0x07, 0x40, 0xCF, 0xA0, 0xE0, 0x32, 0x09, 0xB0, 0x75,
  0x08, 0x0E, 0xD8, 0x1E, 0x91, 0x3C, 0x07, 0x78, 0x34, 0x67, 0x64, 0x50, 0xAA, 0x0D, 0x01, 0x77,
  0x30, 0x7B, 0x02, 0x77, 0x30, 0x2B, 0x07, 0x77, 0x40, 0xBB, 0x01, 0x77, 0x30, 0x1B, 0x0B, 0x77,
  0x40, 0x6B, 0x08, 0x77, 0x40, 0x8B, 0x08, 0x77, 0x40, 0x8B, 0x0B, 0x77, 0x40, 0x7C, 0x83, 0x81,
  0x01, 0x17, 0x60, 0x4F, 0x90, 0x67, 0x70, 0xDF, 0x06, 0x77, 0x03, 0x0E, 0xE0, 0x67, 0x71, 0x86,
  0x18, 0xCE, 0xFD, 0xA3,
  // "Ć" (U+0106)
  0x77, 0x30, 0x28, 0x01, 0x70, 0x67, 0x75, 0x0A, 0xD0, 0x77, 0x74, 0x03, 0xD0, 0xC7, 0x75, 0x0C,
  0xC0, 0xE0, 0x17, 0x74, 0x06, 0xC0, 0xE0, 0x37, 0x74, 0x01, 0x0E, 0xC0, 0x47, 0x75, 0x0A, 0xC0,
  0x57, 0x75, 0x05, 0xC0, 0x57, 0x75, 0x01, 0x0E, 0xB0, 0x57, 0x76, 0x08, 0xA0, 0xE0, 0x48, 0x09,
  0xF2, 0x08, 0x63, 0x56, 0x76, 0x54, 0x17, 0x71, 0x05, 0x0B, 0xFA, 0x81, 0xD8, 0x37, 0x30, 0x40,
  0xDF, 0xF0, 0xC0, 0x37, 0x09, 0xFF, 0xB0, 0x36, 0x0B, 0xF9, 0x81, 0xED, 0xEE, 0x0C, 0x60, 0xAE,
  0x0B, 0x05, 0x58, 0x14, 0x8E, 0xA0, 0x55, 0x07, 0xD0, 0xE0, 0x57, 0x30, 0x70, 0xD5, 0x02, 0xD0,
  0xE0, 0x37, 0x74, 0x0B, 0xD0, 0x47, 0x74, 0x03, 0xD0, 0x97, 0x75, 0x0A, 0xC0, 0xE0, 0x17, 0x74,
  0x01, 0xD0, 0x87, 0x75, 0x06, 0xD0, 0x27, 0x75, 0x0A, 0xC0, 0xC7, 0x76, 0x0E, 0xC0, 0x87, 0x75,
  0x02, 0xD0, 0x47, 0x75, 0x05, 0xD0, 0x17, 0x75, 0x07, 0xC0, 0xE7, 0x76, 0x09, 0xC0, 0xC7, 0x76,
  0x0A, 0xC0, 0xB7, 0x76, 0x0B, 0xC0, 0x97, 0x76, 0x0C, 0xC0, 0x97, 0x76, 0x0C, 0xC0, 0x97, 0x76,
  0x0C, 0xC0, 0x97, 0x76, 0x0B, 0xC0, 0xA7, 0x76, 0x0A, 0xC0, 0xB7, 0x76, 0x09, 0xC0, 0xC7, 0x76,
  0x07, 0xC0, 0xE7, 0x76, 0x05, 0xD0, 0x17, 0x75, 0x03, 0xD0, 0x37, 0x76, 0xD0, 0x77, 0x76, 0x0C,
  0xC0, 0xC7, 0x76, 0x07, 0xD0, 0x17, 0x75, 0x02, 0xD0, 0x77, 0x76, 0x0C, 0xC0, 0xE0, 0x17, 0x75,
  0x05, 0xD0, 0x87, 0x76, 0x0D, 0xD0, 0x37, 0x75, 0x04, 0xD0, 0xE0, 0x27, 0x75, 0x0A, 0xD0, 0xE0,
  0x57, 0x40, 0x20, 0x16, 0x0C, 0xE8, 0x1B, 0x51, 0x48, 0x41, 0x37, 0xCF, 0x46, 0x02, 0x0D, 0xF9,
  0x0F, 0xD0, 0xED, 0x04, 0x70, 0x10, 0xCF, 0xFA, 0x04, 0x72, 0x07, 0x0E, 0xFF, 0x04, 0x73, 0x81,
  0x17, 0xDF, 0xA8, 0x1D, 0x93, 0x77, 0x87, 0x14, 0x67, 0x76, 0x64, 0x15,
  // "ć" (U+0107)
  0x76, 0x02, 0x80, 0x17, 0x06, 0x76, 0x0A, 0xD0, 0x77, 0x50, 0x3D, 0x0C, 0x76, 0x0C, 0xC0, 0xE0,
  0x17, 0x50, 0x6C, 0x0E, 0x03, 0x75, 0x01, 0x0E, 0xC0, 0x47, 0x60, 0xAC, 0x05, 0x76, 0x05, 0xC0,
  0x57, 0x60, 0x10, 0xEB, 0x05, 0x77, 0x08, 0xA0, 0xE0, 0x48, 0x09, 0xB4, 0x08, 0x61, 0x46, 0x77,
  0x64, 0x17, 0x30, 0x40, 0xBF, 0x98, 0x1C, 0x71, 0x50, 0x10, 0xAF, 0xD0, 0x84, 0x01, 0x0D, 0xFE,
  0x03, 0x40, 0xCF, 0x0E, 0x0D, 0xC0, 0xD4, 0x07, 0xD0, 0xD0, 0x64, 0x82, 0x39, 0xF8, 0x30, 0x10,
  0xEC, 0x0C, 0x01, 0x70, 0x01, 0x30, 0x8C, 0x0E, 0x01, 0x76, 0x0D, 0xC0, 0x67, 0x60, 0x3C, 0x0E,
  0x77, 0x07, 0xC0, 0xA7, 0x70, 0xAC, 0x06, 0x77, 0x0D, 0xC0, 0x47, 0x7D, 0x01, 0x77, 0xD7, 0x70,
  0x1D, 0x77, 0x02, 0xC0, 0xE7, 0x70, 0x2C, 0x0E, 0x77, 0x02, 0xD7, 0x70, 0x1D, 0x77, 0x1D, 0x01,
  0x77, 0x0E, 0xC0, 0x37, 0x70, 0xCC, 0x06, 0x77, 0x09, 0xC0, 0xA7, 0x70, 0x5C, 0x0E, 0x77, 0x01,
  0xD0, 0x67, 0x70, 0xBC, 0x0D, 0x01, 0x76, 0x04, 0xD0, 0xB7, 0x20, 0x01, 0x30, 0xBD, 0x0D, 0x05,
  0x48, 0x31, 0x5A, 0xF4, 0x30, 0x10, 0xEF, 0x81, 0xDD, 0xEC, 0x04, 0x40, 0x20, 0xEF, 0xE0, 0x45,
  0x02, 0x0C, 0xFD, 0x04, 0x70, 0x50, 0xBF, 0x81, 0xEA, 0x37, 0x38, 0x51, 0x46, 0x77, 0x53, 0x40,
  // "Ĉ" (U+0108)
  0x76, 0x84, 0x57, 0x77, 0x73, 0x77, 0x50, 0x1D, 0x0D, 0x77, 0x50, 0xAE, 0x06, 0x77, 0x30, 0x4F,
  0x0E, 0x02, 0x77, 0x10, 0x10, 0xDB, 0x0C, 0x0E, 0xB0, 0xB7, 0x71, 0x0A, 0xB8, 0x2D, 0x12, 0xEB,
  0x07, 0x76, 0x05, 0xB0, 0xD0, 0x12, 0x03, 0x0E, 0xB0, 0x37, 0x40, 0x20, 0xEA, 0x0D, 0x01, 0x40,
  0x4B, 0x0D, 0x01, 0x73, 0x0D, 0xA0, 0xD0, 0x26, 0x04, 0x0E, 0xA0, 0xB7, 0x20, 0x8A, 0x0D, 0x01,
  0x71, 0x03, 0x0D, 0xA0, 0x68, 0x09, 0xE2, 0x08, 0x63, 0x56, 0x76, 0x54, 0x17, 0x71, 0x05, 0x0B,
  0xFA, 0x81, 0xD8, 0x37, 0x30, 0x40, 0xDF, 0xF0, 0xC0, 0x37, 0x09, 0xFF, 0xB0, 0x36, 0x0B, 0xF9,
  0x81, 0xED, 0xEE, 0x0C, 0x60, 0xAE, 0x0B, 0x05, 0x58, 0x14, 0x8E, 0xA0, 0x55, 0x07, 0xD0, 0xE0,
  0x57, 0x30, 0x70, 0xD5, 0x02, 0xD0, 0xE0, 0x37, 0x74, 0x0B, 0xD0, 0x47, 0x74, 0x03, 0xD0, 0x97,
  0x75, 0x0A, 0xC0, 0xE0, 0x17, 0x74, 0x01, 0xD0, 0x87, 0x75, 0x06, 0xD0, 0x27, 0x75, 0x0A, 0xC0,
  0xC7, 0x76, 0x0E, 0xC0, 0x87, 0x75, 0x02, 0xD0, 0x47, 0x75, 0x05, 0xD0, 0x17, 0x75, 0x07, 0xC0,
  0xE7, 0x76, 0x09, 0xC0, 0xC7, 0x76, 0x0A, 0xC0, 0xB7, 0x76, 0x0B, 0xC0, 0x97, 0x76, 0x0C, 0xC0,
  0x97, 0x76, 0x0C, 0xC0, 0x97, 0x76, 0x0C, 0xC0, 0x97, 0x76, 0x0B, 0xC0, 0xA7, 0x76, 0x0A, 0xC0,
  0xB7, 0x76, 0x09, 0xC0, 0xC7, 0x76, 0x07, 0xC0, 0xE7, 0x76, 0x05, 0xD0, 0x17, 0x75, 0x03, 0xD0,
  0x37, 0x76, 0xD0, 0x77, 0x76, 0x0C, 0xC0, 0xC7, 0x76, 0x07, 0xD0, 0x17, 0x75, 0x02, 0xD0, 0x77,
  0x76, 0x0C, 0xC0, 0xE0, 0x17, 0x75, 0x05, 0xD0, 0x87, 0x76, 0x0D, 0xD0, 0x37, 0x75, 0x04, 0xD0,
  0xE0, 0x27, 0x75, 0x0A, 0xD0, 0xE0, 0x57, 0x40, 0x20, 0x16, 0x0C, 0xE8, 0x1B, 0x51, 0x48, 0x41,
  0x37, 0xCF, 0x46, 0x02, 0x0D, 0xF9, 0x0F, 0xD0, 0xED, 0x04, 0x70, 0x10, 0xCF, 0xFA, 0x04, 0x72,
  0x07, 0x0E, 0xFF, 0x04, 0x73, 0x81, 0x17, 0xDF, 0xA8, 0x1D, 0x93, 0x77, 0x87, 0x14, 0x67, 0x76,
  0x64, 0x15,
  // "ĉ" (U+0109)
  0x72, 0x84, 0x57, 0x77, 0x73, 0x77, 0x01, 0xD0, 0xD7, 0x70, 0xAE, 0x06, 0x75, 0x04, 0xF0, 0xE0,
  0x27, 0x30, 0x10, 0xDB, 0x0C, 0x0E, 0xB0, 0xB7, 0x30, 0xAB, 0x82, 0xD1, 0x2E, 0xB0, 0x77, 0x10,
  0x5B, 0x0D, 0x01, 0x20, 0x30, 0xEB, 0x03, 0x60, 0x20, 0xEA, 0x0D, 0x01, 0x40, 0x4B, 0x0D, 0x01,
  0x50, 0xDA, 0x0D, 0x02, 0x60, 0x40, 0xEA, 0x0B, 0x40, 0x8A, 0x0D, 0x01, 0x71, 0x03, 0x0D, 0xA0,
  0x68, 0x09, 0xB1, 0x08, 0x61, 0x46, 0x77, 0x64, 0x17, 0x40, 0x40, 0xBF, 0x98, 0x1C, 0x71, 0x60,
  0x10, 0xAF, 0xD0, 0x85, 0x01, 0x0D, 0xFE, 0x03, 0x50, 0xCF, 0x0E, 0x0D, 0xC0, 0xD5, 0x07, 0xD0,
  0xD0, 0x64, 0x82, 0x39, 0xF8, 0x40, 0x10, 0xEC, 0x0C, 0x01, 0x70, 0x01, 0x40, 0x8C, 0x0E, 0x01,
  0x77, 0x0D, 0xC0, 0x67, 0x70, 0x3C, 0x0E, 0x77, 0x10, 0x7C, 0x0A, 0x77, 0x10, 0xAC, 0x06, 0x77,
  0x10, 0xDC, 0x04, 0x77, 0x1D, 0x01, 0x77, 0x1D, 0x77, 0x10, 0x1D, 0x77, 0x10, 0x2C, 0x0E, 0x77,
  0x10, 0x2C, 0x0E, 0x77, 0x10, 0x2D, 0x77, 0x10, 0x1D, 0x77, 0x2D, 0x01, 0x77, 0x10, 0xEC, 0x03,
  0x77, 0x10, 0xCC, 0x06, 0x77, 0x10, 0x9C, 0x0A, 0x77, 0x10, 0x5C, 0x0E, 0x77, 0x10, 0x1D, 0x06,
  0x77, 0x10, 0xBC, 0x0D, 0x01, 0x77, 0x04, 0xD0, 0xB7, 0x20, 0x01, 0x40, 0xBD, 0x0D, 0x05, 0x48,
  0x31, 0x5A, 0xF4, 0x40, 0x10, 0xEF, 0x81, 0xDD, 0xEC, 0x04, 0x50, 0x20, 0xEF, 0xE0, 0x46, 0x02,
  0x0C, 0xFD, 0x04, 0x71, 0x05, 0x0B, 0xF8, 0x1E, 0xA3, 0x74, 0x85, 0x14, 0x67, 0x75, 0x35,
  // "Ċ" (U+010A)
  0x76, 0x83, 0x5D, 0xEB, 0x27, 0x76, 0x02, 0xC0, 0xC7, 0x76, 0x07, 0xD0, 0x17, 0x75, 0x08, 0xD0,
  0x27, 0x75, 0x07, 0xD0, 0x17, 0x75, 0x02, 0xC0, 0xB7, 0x77, 0x83, 0x4D, 0xEB, 0x18, 0x0A, 0xA3,
  0x08, 0x63, 0x56, 0x76, 0x54, 0x17, 0x71, 0x05, 0x0B, 0xFA, 0x81, 0xD8, 0x37, 0x30, 0x40, 0xDF,
  0xF0, 0xC0, 0x37, 0x09, 0xFF, 0xB0, 0x36, 0x0B, 0xF9, 0x81, 0xED, 0xEE, 0x0C, 0x60, 0xAE, 0x0B,
  0x05, 0x58, 0x14, 0x8E, 0xA0, 0x55, 0x07, 0xD0, 0xE0, 0x57, 0x30, 0x70, 0xD5, 0x02, 0xD0, 0xE0,
  0x37, 0x74, 0x0B, 0xD0, 0x47, 0x74, 0x03, 0xD0, 0x97, 0x75, 0x0A, 0xC0, 0xE0, 0x17, 0x74, 0x01,
  0xD0, 0x87, 0x75, 0x06, 0xD0, 0x27, 0x75, 0x0A, 0xC0, 0xC7, 0x76, 0x0E, 0xC0, 0x87, 0x75, 0x02,
  0xD0, 0x47, 0x75, 0x05, 0xD0, 0x17, 0x75, 0x07, 0xC0, 0xE7, 0x76, 0x09, 0xC0, 0xC7, 0x76, 0x0A,
  0xC0, 0xB7, 0x76, 0x0B, 0xC0, 0x97, 0x76, 0x0C, 0xC0, 0x97, 0x76, 0x0C, 0xC0, 0x97, 0x76, 0x0C,
  0xC0, 0x97, 0x76, 0x0B, 0xC0, 0xA7, 0x76, 0x0A, 0xC0, 0xB7, 0x76, 0x09, 0xC0, 0xC7, 0x76, 0x07,
  0xC0, 0xE7, 0x76, 0x05, 0xD0, 0x17, 0x75, 0x03, 0xD0, 0x37, 0x76, 0xD0, 0x77, 0x76, 0x0C, 0xC0,
  0xC7, 0x76, 0x07, 0xD0, 0x17, 0x75, 0x02, 0xD0, 0x77, 0x76, 0x0C, 0xC0, 0xE0, 0x17, 0x75, 0x05,
  0xD0, 0x87, 0x76, 0x0D, 0xD0, 0x37, 0x75, 0x04, 0xD0, 0xE0, 0x27, 0x75, 0x0A, 0xD0, 0xE0, 0x57,
  0x40, 0x20, 0x16, 0x0C, 0xE8, 0x1B, 0x51, 0x48, 0x41, 0x37, 0xCF, 0x46, 0x02, 0x0D, 0xF9, 0x0F,
  0xD0, 0xED, 0x04, 0x70, 0x10, 0xCF, 0xFA, 0x04, 0x72, 0x07, 0x0E, 0xFF, 0x04, 0x73, 0x81, 0x17,
  0xDF, 0xA8, 0x1D, 0x93, 0x77, 0x87, 0x14, 0x67, 0x76, 0x64, 0x15,
  // "ċ" (U+010B)
  0x73, 0x83, 0x5D, 0xEB, 0x27, 0x70, 0x2C, 0x0C, 0x77, 0x07, 0xD0, 0x17, 0x60, 0x8D, 0x02, 0x76,
  0x07, 0xD0, 0x17, 0x60, 0x2C, 0x0B, 0x77, 0x18, 0x34, 0xDE, 0xB1, 0x80, 0x9D, 0x60, 0x86, 0x14,
  0x67, 0x76, 0x41, 0x73, 0x04, 0x0B, 0xF9, 0x81, 0xC7, 0x15, 0x01, 0x0A, 0xFD, 0x08, 0x40, 0x10,
  0xDF, 0xE0, 0x34, 0x0C, 0xF0, 0xE0, 0xDC, 0x0D, 0x40, 0x7D, 0x0D, 0x06, 0x48, 0x23, 0x9F, 0x83,
  0x01, 0x0E, 0xC0, 0xC0, 0x17, 0x00, 0x13, 0x08, 0xC0, 0xE0, 0x17, 0x60, 0xDC, 0x06, 0x76, 0x03,
  0xC0, 0xE7, 0x70, 0x7C, 0x0A, 0x77, 0x0A, 0xC0, 0x67, 0x70, 0xDC, 0x04, 0x77, 0xD0, 0x17, 0x7D,
  0x77, 0x01, 0xD7, 0x70, 0x2C, 0x0E, 0x77, 0x02, 0xC0, 0xE7, 0x70, 0x2D, 0x77, 0x01, 0xD7, 0x71,
  0xD0, 0x17, 0x70, 0xEC, 0x03, 0x77, 0x0C, 0xC0, 0x67, 0x70, 0x9C, 0x0A, 0x77, 0x05, 0xC0, 0xE7,
  0x70, 0x1D, 0x06, 0x77, 0x0B, 0xC0, 0xD0, 0x17, 0x60, 0x4D, 0x0B, 0x72, 0x00, 0x13, 0x0B, 0xD0,
  0xD0, 0x54, 0x83, 0x15, 0xAF, 0x43, 0x01, 0x0E, 0xF8, 0x1D, 0xDE, 0xC0, 0x44, 0x02, 0x0E, 0xFE,
  0x04, 0x50, 0x20, 0xCF, 0xD0, 0x47, 0x05, 0x0B, 0xF8, 0x1E, 0xA3, 0x73, 0x85, 0x14, 0x67, 0x75,
  0x34,
  // "Č" (U+010C)
  0x78, 0x24, 0x77, 0x57, 0x38, 0x26, 0x77, 0x37, 0x10, 0x5B, 0x08, 0x71, 0x09, 0xB0, 0x37, 0x20,
  0x8B, 0x08, 0x60, 0xAB, 0x06, 0x74, 0x0C, 0xB0, 0x84, 0x0A, 0xB0, 0x97, 0x50, 0x20, 0xEB, 0x07,
  0x20, 0xAB, 0x0D, 0x77, 0x05, 0xC0, 0x60, 0x9C, 0x02, 0x77, 0x10, 0xAF, 0x90, 0x77, 0x72, 0x01,
  0x0E, 0xE0, 0xB7, 0x74, 0x06, 0xE0, 0x27, 0x75, 0x0C, 0xC0, 0x98, 0x09, 0xF0, 0x08, 0x63, 0x56,
  0x76, 0x54, 0x17, 0x71, 0x05, 0x0B, 0xFA, 0x81, 0xD8, 0x37, 0x30, 0x40, 0xDF, 0xF0, 0xC0, 0x37,
  0x09, 0xFF, 0xB0, 0x36, 0x0B, 0xF9, 0x81, 0xED, 0xEE, 0x0C, 0x60, 0xAE, 0x0B, 0x05, 0x58, 0x14,
  0x8E, 0xA0, 0x55, 0x07, 0xD0, 0xE0, 0x57, 0x30, 0x70, 0xD5, 0x02, 0xD0, 0xE0, 0x37, 0x74, 0x0B,
  0xD0, 0x47, 0x74, 0x03, 0xD0, 0x97, 0x75, 0x0A, 0xC0, 0xE0, 0x17, 0x74, 0x01, 0xD0, 0x87, 0x75,
  0x06, 0xD0, 0x27, 0x75, 0x0A, 0xC0, 0xC7, 0x76, 0x0E, 0xC0, 0x87, 0x75, 0x02, 0xD0, 0x47, 0x75,
  0x05, 0xD0, 0x17, 0x75, 0x07, 0xC0, 0xE7, 0x76, 0x09, 0xC0, 0xC7, 0x76, 0x0A, 0xC0, 0xB7, 0x76,
  0x0B, 0xC0, 0x97, 0x76, 0x0C, 0xC0, 0x97, 0x76, 0x0C, 0xC0, 0x97, 0x76, 0x0C, 0xC0, 0x97, 0x76,
  0x0B, 0xC0, 0xA7, 0x76, 0x0A, 0xC0, 0xB7, 0x76, 0x09, 0xC0, 0xC7, 0x76, 0x07, 0xC0, 0xE7, 0x76,
  0x05, 0xD0, 0x17, 0x75, 0x03, 0xD0, 0x37, 0x76, 0xD0, 0x77, 0x76, 0x0C, 0xC0, 0xC7, 0x76, 0x07,
  0xD0, 0x17, 0x75, 0x02, 0xD0, 0x77, 0x76, 0x0C, 0xC0, 0xE0, 0x17, 0x75, 0x05, 0xD0, 0x87, 0x76,
  0x0D, 0xD0, 0x37, 0x75, 0x04, 0xD0, 0xE0, 0x27, 0x75, 0x0A, 0xD0, 0xE0, 0x57, 0x40, 0x20, 0x16,
  0x0C, 0xE8, 0x1B, 0x51, 0x48, 0x41, 0x37, 0xCF, 0x46, 0x02, 0x0D, 0xF9, 0x0F, 0xD0, 0xED, 0x04,
  0x70, 0x10, 0xCF, 0xFA, 0x04, 0x72, 0x07, 0x0E, 0xFF, 0x04, 0x73, 0x81, 0x17, 0xDF, 0xA8, 0x1D,
  0x93, 0x77, 0x87, 0x14, 0x67, 0x76, 0x64, 0x15,
  // "č" (U+010D)
  0x38, 0x24, 0x77, 0x57, 0x38, 0x26, 0x77, 0x33, 0x05, 0xB0, 0x87, 0x10, 0x9B, 0x03, 0x40, 0x8B,
  0x08, 0x60, 0xAB, 0x06, 0x60, 0xCB, 0x08, 0x40, 0xAB, 0x09, 0x70, 0x20, 0xEB, 0x07, 0x20, 0xAB,
  0x0D, 0x72, 0x05, 0xC0, 0x60, 0x9C, 0x02, 0x73, 0x0A, 0xF9, 0x07, 0x74, 0x01, 0x0E, 0xE0, 0xB7,
  0x60, 0x6E, 0x02, 0x77, 0x0C, 0xC0, 0x98, 0x09, 0xB7, 0x08, 0x61, 0x46, 0x77, 0x64, 0x17, 0x40,
  0x40, 0xBF, 0x98, 0x1C, 0x71, 0x60, 0x10, 0xAF, 0xD0, 0x85, 0x01, 0x0D, 0xFE, 0x03, 0x50, 0xCF,
  0x0E, 0x0D, 0xC0, 0xD5, 0x07, 0xD0, 0xD0, 0x64, 0x82, 0x39, 0xF8, 0x40, 0x10, 0xEC, 0x0C, 0x01,
  0x70, 0x01, 0x40, 0x8C, 0x0E, 0x01, 0x77, 0x0D, 0xC0, 0x67, 0x70, 0x3C, 0x0E, 0x77, 0x10, 0x7C,
  0x0A, 0x77, 0x10, 0xAC, 0x06, 0x77, 0x10, 0xDC, 0x04, 0x77, 0x1D, 0x01, 0x77, 0x1D, 0x77, 0x10,
  0x1D, 0x77, 0x10, 0x2C, 0x0E, 0x77, 0x10, 0x2C, 0x0E, 0x77, 0x10, 0x2D, 0x77, 0x10, 0x1D, 0x77,
  0x2D, 0x01, 0x77, 0x10, 0xEC, 0x03, 0x77, 0x10, 0xCC, 0x06, 0x77, 0x10, 0x9C, 0x0A, 0x77, 0x10,
  0x5C, 0x0E, 0x77, 0x10, 0x1D, 0x06, 0x77, 0x10, 0xBC, 0x0D, 0x01, 0x77, 0x04, 0xD0, 0xB7, 0x20,
  0x01, 0x40, 0xBD, 0x0D, 0x05, 0x48, 0x31, 0x5A, 0xF4, 0x40, 0x10, 0xEF, 0x81, 0xDD, 0xEC, 0x04,
  0x50, 0x20, 0xEF, 0xE0, 0x46, 0x02, 0x0C, 0xFD, 0x04, 0x71, 0x05, 0x0B, 0xF8, 0x1E, 0xA3, 0x74,
  0x85, 0x14, 0x67, 0x75, 0x35,
  // "Ď" (U+010E)
  0x48, 0x24, 0x77, 0x57, 0x38, 0x26, 0x77, 0x37, 0x30, 0x5B, 0x08, 0x71, 0x09, 0xB0, 0x37, 0x40,
  0x8B, 0x08, 0x60, 0xAB, 0x06, 0x76, 0x0C, 0xB0, 0x84, 0x0A, 0xB0, 0x97, 0x70, 0x20, 0xEB, 0x07,
  0x20, 0xAB, 0x0D, 0x77, 0x20, 0x5C, 0x06, 0x09, 0xC0, 0x27, 0x73, 0x0A, 0xF9, 0x07, 0x77, 0x40,
  0x10, 0xEE, 0x0B, 0x77, 0x60, 0x6E, 0x02, 0x77, 0x70, 0xCC, 0x09, 0x80, 0xAA, 0x40, 0x03, 0xFC,
  0x83, 0xED, 0xA7, 0x37, 0x40, 0x3F, 0xFA, 0x0D, 0x07, 0x72, 0x03, 0xFF, 0xC0, 0xD0, 0x47, 0x03,
  0xFF, 0xE0, 0x76, 0x03, 0xD8, 0x02, 0x58, 0x17, 0x9D, 0xF0, 0x85, 0x03, 0xC0, 0xE7, 0x20, 0x40,
  0xCE, 0x06, 0x40, 0x3C, 0x0E, 0x74, 0x08, 0xE0, 0x23, 0x03, 0xC0, 0xE7, 0x50, 0x7D, 0x0B, 0x30,
  0x3C, 0x0E, 0x76, 0x0A, 0xD0, 0x42, 0x03, 0xC0, 0xE7, 0x60, 0x10, 0xEC, 0x0B, 0x20, 0x3C, 0x0E,
  0x77, 0x08, 0xD8, 0x11, 0x03, 0xC0, 0xE7, 0x70, 0x2D, 0x81, 0x60, 0x3C, 0x0E, 0x77, 0x10, 0xCC,
  0x81, 0xB0, 0x3C, 0x0E, 0x77, 0x10, 0x8C, 0x81, 0xE0, 0x3C, 0x0E, 0x77, 0x10, 0x4D, 0x02, 0x03,
  0xC0, 0xE7, 0x71, 0x02, 0xD0, 0x40, 0x3C, 0x0E, 0x77, 0x2D, 0x06, 0x03, 0xC0, 0xE7, 0x72, 0x0D,
  0xC0, 0x80, 0x3C, 0x0E, 0x77, 0x20, 0xCC, 0x09, 0x03, 0xC0, 0xE7, 0x72, 0x0B, 0xC0, 0x90, 0x3C,
  0x0E, 0x77, 0x20, 0xBC, 0x0A, 0x03, 0xC0, 0xE7, 0x72, 0x0B, 0xC0, 0xA0, 0x3C, 0x0E, 0x77, 0x20,
  0xBC, 0x0A, 0x03, 0xC0, 0xE7, 0x72, 0x0C, 0xC0, 0x90, 0x3C, 0x0E, 0x77, 0x20, 0xDC, 0x08, 0x03,
  0xC0, 0xE7, 0x72, 0x0E, 0xC0, 0x70, 0x3C, 0x0E, 0x77, 0x10, 0x1D, 0x05, 0x03, 0xC0, 0xE7, 0x71,
  0x03, 0xD0, 0x03, 0xC0, 0xE7, 0x71, 0x06, 0xD1, 0x03, 0xC0, 0xE7, 0x71, 0x0A, 0xC8, 0x1C, 0x03,
  0xC0, 0xE7, 0x71, 0x0E, 0xC8, 0x19, 0x03, 0xC0, 0xE7, 0x70, 0x4D, 0x81, 0x40, 0x3C, 0x0E, 0x77,
  0x0B, 0xC0, 0xE2, 0x03, 0xC0, 0xE7, 0x60, 0x3D, 0x08, 0x20, 0x3C, 0x0E, 0x76, 0x0D, 0xD0, 0x12,
  0x03, 0xC0, 0xE7, 0x50, 0xAD, 0x08, 0x30, 0x3C, 0x0E, 0x73, 0x01, 0x0B, 0xD0, 0xD4, 0x03, 0xC0,
  0xE7, 0x18, 0x11, 0x7E, 0xE0, 0x34, 0x03, 0xD8, 0x01, 0x58, 0x16, 0x8B, 0xF9, 0x04, 0x50, 0x3F,
  0xFD, 0x0E, 0x04, 0x60, 0x3F, 0xFC, 0x0B, 0x01, 0x70, 0x3F, 0xFA, 0x0B, 0x04, 0x72, 0x03, 0xFB,
  0x84, 0xED, 0xC9, 0x51, 0x74,
  // "ď" (U+010F)
  0x77, 0x50, 0xBC, 0x04, 0x30, 0xBC, 0x06, 0x77, 0x50, 0xBC, 0x04, 0x30, 0xDC, 0x03, 0x77, 0x50,
  0xBC, 0x04, 0x30, 0xEB, 0x0D, 0x77, 0x60, 0xBC, 0x04, 0x20, 0x1C, 0x08, 0x77, 0x60, 0xBC, 0x04,
  0x20, 0x4C, 0x02, 0x77, 0x60, 0xBC, 0x04, 0x20, 0x6B, 0x0B, 0x77, 0x70, 0xBC, 0x04, 0x20, 0x9B,
  0x05, 0x77, 0x70, 0xBC, 0x04, 0x20, 0xCA, 0x0D, 0x77, 0x71, 0x0B, 0xC0, 0x42, 0xB0, 0x67, 0x77,
  0x10, 0xBC, 0x81, 0x40, 0x2A, 0x0C, 0x77, 0x72, 0x0B, 0xC0, 0x47, 0x77, 0x70, 0xBC, 0x04, 0x77,
  0x77, 0x0B, 0xC0, 0x47, 0x73, 0x84, 0x15, 0x77, 0x63, 0x50, 0xBC, 0x04, 0x77, 0x10, 0x30, 0xBE,
  0x0D, 0x06, 0x30, 0xBC, 0x04, 0x77, 0x07, 0xFB, 0x0A, 0x20, 0xBC, 0x04, 0x76, 0x07, 0xFD, 0x81,
  0xC0, 0xAC, 0x04, 0x75, 0x04, 0xF8, 0x1E, 0xDE, 0xC0, 0x09, 0xC0, 0x47, 0x50, 0xDD, 0x09, 0x02,
  0x30, 0x20, 0x9B, 0x0D, 0xC0, 0x47, 0x40, 0x5D, 0x07, 0x70, 0x5F, 0x04, 0x74, 0x0C, 0xC0, 0xB7,
  0x20, 0x8E, 0x04, 0x73, 0x01, 0xD0, 0x37, 0x30, 0xED, 0x04, 0x73, 0x06, 0xC0, 0xD7, 0x40, 0x9D,
  0x04, 0x73, 0x09, 0xC0, 0x87, 0x40, 0x5D, 0x04, 0x73, 0x0C, 0xC0, 0x57, 0x40, 0x1D, 0x04, 0x73,
  0x0E, 0xC0, 0x27, 0x5D, 0x04, 0x72, 0x01, 0xD7, 0x60, 0xDC, 0x04, 0x72, 0x01, 0xC0, 0xE7, 0x60,
  0xCC, 0x04, 0x72, 0x02, 0xC0, 0xE7, 0x60, 0xBC, 0x04, 0x72, 0x03, 0xC0, 0xD7, 0x60, 0xBC, 0x04,
  0x72, 0x03, 0xC0, 0xD7, 0x60, 0xAC, 0x04, 0x72, 0x02, 0xC0, 0xE7, 0x60, 0xBC, 0x04, 0x72, 0x01,
  0xC0, 0xE7, 0x60, 0xBC, 0x04, 0x72, 0x01, 0xD7, 0x60, 0xCC, 0x04, 0x73, 0x0E, 0xC0, 0x27, 0x50,
  0xEC, 0x04, 0x73, 0x0C, 0xC0, 0x57, 0x5D, 0x04, 0x73, 0x0A, 0xC0, 0x87, 0x40, 0x4D, 0x04, 0x73,
  0x06, 0xC0, 0xC7, 0x40, 0x8D, 0x04, 0x73, 0x02, 0xD0, 0x37, 0x30, 0xED, 0x04, 0x74, 0x0C, 0xC0,
  0xB7, 0x20, 0x7E, 0x04, 0x74, 0x06, 0xD0, 0x77, 0x04, 0xF0, 0x47, 0x50, 0xDD, 0x09, 0x02, 0x30,
  0x20, 0x9B, 0x0C, 0xC0, 0x47, 0x50, 0x5F, 0x81, 0xED, 0xEC, 0x09, 0x04, 0xC0, 0x47, 0x60, 0x8F,
  0xD8, 0x1C, 0x02, 0xC0, 0x47, 0x70, 0x8F, 0xB0, 0xB0, 0x12, 0xC0, 0x47, 0x71, 0x03, 0x0B, 0xE0,
  0xE0, 0x74, 0x0C, 0xB0, 0x47, 0x73, 0x84, 0x15, 0x77, 0x63, 0x77, 0x60,
  // "Đ" (U+0110)
  0x30, 0x1F, 0xC8, 0x3E, 0xCA, 0x73, 0x77, 0x01, 0xFF, 0xA0, 0xD0, 0x67, 0x50, 0x1F, 0xFC, 0x0D,
  0x03, 0x73, 0x01, 0xFF, 0xE0, 0x67, 0x20, 0x1D, 0x80, 0x25, 0x81, 0x79, 0xDF, 0x07, 0x71, 0x01,
  0xD0, 0x17, 0x10, 0x40, 0xCE, 0x05, 0x70, 0x1D, 0x01, 0x73, 0x08, 0xD0, 0xE0, 0x26, 0x01, 0xD0,
  0x17, 0x40, 0x7D, 0x0A, 0x60, 0x1D, 0x01, 0x75, 0x0A, 0xD0, 0x35, 0x01, 0xD0, 0x17, 0x50, 0x10,
  0xEC, 0x0A, 0x50, 0x1D, 0x01, 0x76, 0x08, 0xD0, 0x14, 0x01, 0xD0, 0x17, 0x60, 0x2D, 0x05, 0x40,
  0x1D, 0x01, 0x77, 0x0C, 0xC0, 0xA4, 0x01, 0xD0, 0x17, 0x70, 0x8C, 0x0D, 0x40, 0x1D, 0x01, 0x77,
  0x04, 0xD0, 0x13, 0x01, 0xD0, 0x17, 0x70, 0x2D, 0x03, 0x30, 0x1D, 0x01, 0x77, 0x1D, 0x05, 0x30,
  0x1D, 0x01, 0x77, 0x10, 0xDC, 0x07, 0x30, 0x1D, 0x01, 0x77, 0x10, 0xCC, 0x00, 0x8F, 0xF9, 0x05,
  0x71, 0x0B, 0xC0, 0x90, 0x8F, 0xF9, 0x05, 0x71, 0x0B, 0xC0, 0x90, 0x8F, 0xF9, 0x05, 0x71, 0x0B,
  0xC0, 0x90, 0x8F, 0xF9, 0x05, 0x71, 0x0B, 0xC0, 0x90, 0x20, 0xF5, 0xD8, 0x03, 0x50, 0x17, 0x10,
  0xCC, 0x08, 0x30, 0x1D, 0x01, 0x77, 0x10, 0xDC, 0x07, 0x30, 0x1D, 0x01, 0x77, 0x10, 0xEC, 0x06,
  0x30, 0x1D, 0x01, 0x77, 0x01, 0xD0, 0x43, 0x01, 0xD0, 0x17, 0x70, 0x3D, 0x02, 0x30, 0x1D, 0x01,
  0x77, 0x06, 0xC0, 0xE4, 0x01, 0xD0, 0x17, 0x70, 0xAC, 0x0B, 0x40, 0x1D, 0x01, 0x77, 0x0E, 0xC0,
  0x84, 0x01, 0xD0, 0x17, 0x60, 0x4D, 0x03, 0x40, 0x1D, 0x01, 0x76, 0x0B, 0xC0, 0xD5, 0x01, 0xD0,
  0x17, 0x50, 0x3D, 0x07, 0x50, 0x1D, 0x01, 0x75, 0x0D, 0xC0, 0xE0, 0x15, 0x01, 0xD0, 0x17, 0x40,
  0xAD, 0x07, 0x60, 0x1D, 0x01, 0x72, 0x01, 0x0B, 0xD0, 0xC7, 0x01, 0xD0, 0x17, 0x81, 0x17, 0xED,
  0x0E, 0x02, 0x70, 0x1D, 0x80, 0x15, 0x81, 0x68, 0xBF, 0x90, 0x47, 0x10, 0x1F, 0xFD, 0x0E, 0x03,
  0x72, 0x01, 0xFF, 0xC0, 0xA0, 0x17, 0x30, 0x1F, 0xFA, 0x0B, 0x03, 0x75, 0x01, 0xFB, 0x84, 0xED,
  0xB9, 0x51, 0x74,
  // "đ" (U+0111)
  0x77, 0x50, 0xBC, 0x04, 0x77, 0x72, 0x0B, 0xC0, 0x47, 0x77, 0x20, 0xBC, 0x04, 0x77, 0x72, 0x0B,
  0xC0, 0x47, 0x77, 0x20, 0xBC, 0x04, 0x77, 0x04, 0xFF, 0xB0, 0x17, 0x30, 0x4F, 0xFB, 0x01, 0x73,
  0x04, 0xFF, 0xB0, 0x17, 0x30, 0x4F, 0xFB, 0x01, 0x73, 0x01, 0x80, 0x45, 0x0D, 0xC0, 0x80, 0xF5,
  0x77, 0x60, 0xBC, 0x04, 0x77, 0x72, 0x0B, 0xC0, 0x47, 0x77, 0x20, 0xBC, 0x04, 0x77, 0x72, 0x0B,
  0xC0, 0x47, 0x48, 0x64, 0x9D, 0xEF, 0xDA, 0x54, 0x0B, 0xC0, 0x47, 0x20, 0x20, 0xBF, 0x90, 0xD0,
  0x32, 0x0B, 0xC0, 0x47, 0x10, 0x20, 0xEF, 0xC8, 0x14, 0x0A, 0xC0, 0x47, 0x01, 0x0D, 0xFE, 0x03,
  0x09, 0xC0, 0x47, 0x0A, 0xE8, 0x39, 0x65, 0x7A, 0xB0, 0xD0, 0x9C, 0x04, 0x60, 0x2D, 0x0D, 0x02,
  0x50, 0x10, 0xBF, 0x04, 0x60, 0xAC, 0x0E, 0x01, 0x71, 0x0C, 0xE0, 0x46, 0x0E, 0xC0, 0x67, 0x20,
  0x3E, 0x04, 0x50, 0x4C, 0x0E, 0x74, 0x0B, 0xD0, 0x45, 0x09, 0xC0, 0xA7, 0x40, 0x7D, 0x04, 0x50,
  0xBC, 0x07, 0x74, 0x03, 0xD0, 0x45, 0x0E, 0xC0, 0x47, 0x5D, 0x04, 0x5D, 0x02, 0x75, 0x0D, 0xC0,
  0x44, 0x01, 0xD7, 0x60, 0xCC, 0x04, 0x40, 0x2D, 0x76, 0x0B, 0xC0, 0x44, 0x03, 0xC0, 0xE7, 0x60,
  0xBC, 0x04, 0x40, 0x3C, 0x0E, 0x76, 0x0A, 0xC0, 0x44, 0x02, 0xC0, 0xE7, 0x60, 0xBC, 0x04, 0x40,
  0x2D, 0x76, 0x0B, 0xC0, 0x44, 0x01, 0xD0, 0x17, 0x50, 0xCC, 0x04, 0x5D, 0x03, 0x75, 0x0E, 0xC0,
  0x45, 0x0C, 0xC0, 0x57, 0x5D, 0x04, 0x50, 0xAC, 0x08, 0x74, 0x03, 0xD0, 0x45, 0x07, 0xC0, 0xD7,
  0x40, 0x8D, 0x04, 0x50, 0x2D, 0x03, 0x73, 0x0D, 0xD0, 0x46, 0x0D, 0xC0, 0xB7, 0x20, 0x6E, 0x04,
  0x60, 0x6D, 0x07, 0x70, 0x4F, 0x04, 0x70, 0xDD, 0x09, 0x02, 0x30, 0x20, 0x8B, 0x0C, 0xC0, 0x47,
  0x05, 0xF8, 0x1E, 0xDE, 0xC0, 0xA0, 0x5C, 0x04, 0x71, 0x09, 0xFD, 0x81, 0xC0, 0x2C, 0x04, 0x72,
  0x08, 0xFB, 0x0C, 0x01, 0x2C, 0x04, 0x73, 0x03, 0x0B, 0xE0, 0xE0, 0x74, 0x0D, 0xB0, 0x47, 0x58,
  0x41, 0x57, 0x76, 0x37, 0x71,
  // "Ē" (U+0112)
  0x20, 0x38, 0x09, 0x25, 0x04, 0x40, 0x9F, 0xF0, 0xE4, 0x09, 0xFF, 0x0E, 0x40, 0x9F, 0xF0, 0xE4,
  0x09, 0xFF, 0x0E, 0x80, 0x9C, 0x20, 0x03, 0xFF, 0xC0, 0xE0, 0x3F, 0xFC, 0x0E, 0x03, 0xFF, 0xC0,
  0xE0, 0x3F, 0xFC, 0x0E, 0x03, 0xD8, 0x09, 0x15, 0x04, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77,
  0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0,
  0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70,
  0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3F, 0xFC, 0x01, 0x03, 0xFF, 0xC0, 0x10, 0x3F, 0xFC,
  0x01, 0x03, 0xFF, 0xC0, 0x10, 0x3D, 0x80, 0x91, 0x51, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77,
  0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0,
  0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70,
  0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3D, 0x80,
  0x91, 0x50, 0x40, 0x3F, 0xFC, 0x0E, 0x03, 0xFF, 0xC0, 0xE0, 0x3F, 0xFC, 0x0E, 0x03, 0xFF, 0xC0,
  0xE0,
  // "ē" (U+0113)
  0x40, 0x38, 0x09, 0x25, 0x04, 0x71, 0x09, 0xFF, 0x0E, 0x71, 0x09, 0xFF, 0x0E, 0x71, 0x09, 0xFF,
  0x0E, 0x71, 0x09, 0xFF, 0x0E, 0x80, 0x9D, 0x10, 0x84, 0x25, 0x77, 0x64, 0x77, 0x20, 0x60, 0xDF,
  0x09, 0x02, 0x74, 0x02, 0x0D, 0xFC, 0x06, 0x72, 0x02, 0x0E, 0xFE, 0x07, 0x70, 0x10, 0xDE, 0x0E,
  0x0D, 0xF0, 0x46, 0x08, 0xD0, 0x70, 0x13, 0x04, 0x0D, 0xC0, 0xD5, 0x02, 0xD0, 0x46, 0x01, 0x0D,
  0xC0, 0x64, 0x09, 0xC0, 0x77, 0x10, 0x3C, 0x0D, 0x40, 0xEB, 0x0E, 0x73, 0x0B, 0xC0, 0x32, 0x03,
  0xC0, 0x87, 0x30, 0x5C, 0x07, 0x20, 0x7C, 0x04, 0x73, 0x01, 0xC0, 0xA2, 0x0A, 0xC0, 0x17, 0x40,
  0xEB, 0x0D, 0x20, 0xDC, 0x75, 0x0C, 0xC2, 0xC0, 0xE8, 0x09, 0x05, 0x0C, 0xC2, 0xFF, 0xF9, 0x00,
  0x1F, 0xFF, 0x90, 0x10, 0x2F, 0xFF, 0x90, 0x10, 0x2F, 0xFF, 0x90, 0x10, 0x2C, 0x0C, 0x77, 0x40,
  0x1C, 0x0D, 0x77, 0x5C, 0x0E, 0x77, 0x50, 0xDC, 0x01, 0x77, 0x40, 0xAC, 0x04, 0x77, 0x40, 0x7C,
  0x08, 0x77, 0x40, 0x2C, 0x0D, 0x77, 0x50, 0xDC, 0x06, 0x77, 0x40, 0x6C, 0x0E, 0x01, 0x77, 0x40,
  0xEC, 0x0D, 0x02, 0x73, 0x05, 0x0A, 0x50, 0x5D, 0x81, 0xE7, 0x24, 0x84, 0x14, 0x8E, 0xFC, 0x60,
  0x9F, 0x82, 0xED, 0xDE, 0xD0, 0xC7, 0x0A, 0xFF, 0x90, 0xC7, 0x10, 0x7F, 0xF0, 0x87, 0x28, 0x12,
  0x9E, 0xF9, 0x81, 0xC7, 0x17, 0x68, 0x62, 0x56, 0x76, 0x63, 0x16,
  // "Ĕ" (U+0114)
  0x20, 0x8A, 0x0A, 0x72, 0xB0, 0x23, 0x06, 0xA0, 0xE7, 0x10, 0x6B, 0x01, 0x30, 0x3B, 0x0A, 0x60,
  0x30, 0xEA, 0x0C, 0x50, 0xDB, 0x84, 0xE8, 0x65, 0x7B, 0xC0, 0x75, 0x07, 0xFD, 0x0E, 0x70, 0xBF,
  0xC0, 0x37, 0x10, 0xAF, 0x90, 0xD0, 0x37, 0x38, 0x63, 0x9D, 0xEF, 0xDB, 0x68, 0x09, 0xC6, 0x00,
  0x3F, 0xFC, 0x0E, 0x03, 0xFF, 0xC0, 0xE0, 0x3F, 0xFC, 0x0E, 0x03, 0xFF, 0xC0, 0xE0, 0x3D, 0x80,
  0x91, 0x50, 0x40, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7,
  0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C,
  0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77,
  0x03, 0xFF, 0xC0, 0x10, 0x3F, 0xFC, 0x01, 0x03, 0xFF, 0xC0, 0x10, 0x3F, 0xFC, 0x01, 0x03, 0xD8,
  0x09, 0x15, 0x10, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7,
  0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C,
  0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77,
  0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xD8, 0x09, 0x15, 0x04, 0x03, 0xFF, 0xC0, 0xE0,
  0x3F, 0xFC, 0x0E, 0x03, 0xFF, 0xC0, 0xE0, 0x3F, 0xFC, 0x0E,
  // "ĕ" (U+0115)
  0x40, 0x8A, 0x0A, 0x72, 0xB0, 0x27, 0x06, 0xA0, 0xE7, 0x10, 0x6B, 0x01, 0x70, 0x3B, 0x0A, 0x60,
  0x30, 0xEA, 0x0C, 0x72, 0x0D, 0xB8, 0x4E, 0x86, 0x57, 0xBC, 0x07, 0x72, 0x07, 0xFD, 0x0E, 0x74,
  0x0B, 0xFC, 0x03, 0x75, 0x0A, 0xF9, 0x0D, 0x03, 0x77, 0x86, 0x39, 0xDE, 0xFD, 0xB6, 0x80, 0x9D,
  0x50, 0x84, 0x25, 0x77, 0x64, 0x77, 0x20, 0x60, 0xDF, 0x09, 0x02, 0x74, 0x02, 0x0D, 0xFC, 0x06,
  0x72, 0x02, 0x0E, 0xFE, 0x07, 0x70, 0x10, 0xDE, 0x0E, 0x0D, 0xF0, 0x46, 0x08, 0xD0, 0x70, 0x13,
  0x04, 0x0D, 0xC0, 0xD5, 0x02, 0xD0, 0x46, 0x01, 0x0D, 0xC0, 0x64, 0x09, 0xC0, 0x77, 0x10, 0x3C,
  0x0D, 0x40, 0xEB, 0x0E, 0x73, 0x0B, 0xC0, 0x32, 0x03, 0xC0, 0x87, 0x30, 0x5C, 0x07, 0x20, 0x7C,
  0x04, 0x73, 0x01, 0xC0, 0xA2, 0x0A, 0xC0, 0x17, 0x40, 0xEB, 0x0D, 0x20, 0xDC, 0x75, 0x0C, 0xC2,
  0xC0, 0xE8, 0x09, 0x05, 0x0C, 0xC2, 0xFF, 0xF9, 0x00, 0x1F, 0xFF, 0x90, 0x10, 0x2F, 0xFF, 0x90,
  0x10, 0x2F, 0xFF, 0x90, 0x10, 0x2C, 0x0C, 0x77, 0x40, 0x1C, 0x0D, 0x77, 0x5C, 0x0E, 0x77, 0x50,
  0xDC, 0x01, 0x77, 0x40, 0xAC, 0x04, 0x77, 0x40, 0x7C, 0x08, 0x77, 0x40, 0x2C, 0x0D, 0x77, 0x50,
  0xDC, 0x06, 0x77, 0x40, 0x6C, 0x0E, 0x01, 0x77, 0x40, 0xEC, 0x0D, 0x02, 0x73, 0x05, 0x0A, 0x50,
  0x5D, 0x81, 0xE7, 0x24, 0x84, 0x14, 0x8E, 0xFC, 0x60, 0x9F, 0x82, 0xED, 0xDE, 0xD0, 0xC7, 0x0A,
  0xFF, 0x90, 0xC7, 0x10, 0x7F, 0xF0, 0x87, 0x28, 0x12, 0x9E, 0xF9, 0x81, 0xC7, 0x17, 0x68, 0x62,
  0x56, 0x76, 0x63, 0x16,
  // "Ė" (U+0116)
  0x71, 0x83, 0x5D, 0xEB, 0x27, 0x70, 0x2C, 0x0C, 0x77, 0x07, 0xD0, 0x17, 0x60, 0x8D, 0x02, 0x76,
  0x07, 0xD0, 0x17, 0x60, 0x2C, 0x0B, 0x77, 0x18, 0x34, 0xDE, 0xB1, 0x80, 0x9F, 0x30, 0x03, 0xFF,
  0xC0, 0xE0, 0x3F, 0xFC, 0x0E, 0x03, 0xFF, 0xC0, 0xE0, 0x3F, 0xFC, 0x0E, 0x03, 0xD8, 0x09, 0x15,
  0x04, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03,
  0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7,
  0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3F,
  0xFC, 0x01, 0x03, 0xFF, 0xC0, 0x10, 0x3F, 0xFC, 0x01, 0x03, 0xFF, 0xC0, 0x10, 0x3D, 0x80, 0x91,
  0x51, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03,
  0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7,
  0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C,
  0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3D, 0x80, 0x91, 0x50, 0x40, 0x3F, 0xFC, 0x0E, 0x03, 0xFF,
  0xC0, 0xE0, 0x3F, 0xFC, 0x0E, 0x03, 0xFF, 0xC0, 0xE0,
  // "ė" (U+0117)
  0x73, 0x83, 0x5D, 0xEB, 0x27, 0x74, 0x02, 0xC0, 0xC7, 0x74, 0x07, 0xD0, 0x17, 0x73, 0x08, 0xD0,
  0x27, 0x73, 0x07, 0xD0, 0x17, 0x73, 0x02, 0xC0, 0xB7, 0x75, 0x83, 0x4D, 0xEB, 0x18, 0x0A, 0x86,
  0x08, 0x42, 0x57, 0x76, 0x47, 0x72, 0x06, 0x0D, 0xF0, 0x90, 0x27, 0x40, 0x20, 0xDF, 0xC0, 0x67,
  0x20, 0x20, 0xEF, 0xE0, 0x77, 0x01, 0x0D, 0xE0, 0xE0, 0xDF, 0x04, 0x60, 0x8D, 0x07, 0x01, 0x30,
  0x40, 0xDC, 0x0D, 0x50, 0x2D, 0x04, 0x60, 0x10, 0xDC, 0x06, 0x40, 0x9C, 0x07, 0x71, 0x03, 0xC0,
  0xD4, 0x0E, 0xB0, 0xE7, 0x30, 0xBC, 0x03, 0x20, 0x3C, 0x08, 0x73, 0x05, 0xC0, 0x72, 0x07, 0xC0,
  0x47, 0x30, 0x1C, 0x0A, 0x20, 0xAC, 0x01, 0x74, 0x0E, 0xB0, 0xD2, 0x0D, 0xC7, 0x50, 0xCC, 0x2C,
  0x0E, 0x80, 0x90, 0x50, 0xCC, 0x2F, 0xFF, 0x90, 0x01, 0xFF, 0xF9, 0x01, 0x02, 0xFF, 0xF9, 0x01,
  0x02, 0xFF, 0xF9, 0x01, 0x02, 0xC0, 0xC7, 0x74, 0x01, 0xC0, 0xD7, 0x75, 0xC0, 0xE7, 0x75, 0x0D,
  0xC0, 0x17, 0x74, 0x0A, 0xC0, 0x47, 0x74, 0x07, 0xC0, 0x87, 0x74, 0x02, 0xC0, 0xD7, 0x75, 0x0D,
  0xC0, 0x67, 0x74, 0x06, 0xC0, 0xE0, 0x17, 0x74, 0x0E, 0xC0, 0xD0, 0x27, 0x30, 0x50, 0xA5, 0x05,
  0xD8, 0x1E, 0x72, 0x48, 0x41, 0x48, 0xEF, 0xC6, 0x09, 0xF8, 0x2E, 0xDD, 0xED, 0x0C, 0x70, 0xAF,
  0xF9, 0x0C, 0x71, 0x07, 0xFF, 0x08, 0x72, 0x81, 0x29, 0xEF, 0x98, 0x1C, 0x71, 0x76, 0x86, 0x25,
  0x67, 0x66, 0x31, 0x60,
  // "Ę" (U+0118)
  0x03, 0xFF, 0xC0, 0xE0, 0x3F, 0xFC, 0x0E, 0x03, 0xFF, 0xC0, 0xE0, 0x3F, 0xFC, 0x0E, 0x03, 0xD8,
  0x09, 0x15, 0x04, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E,
  0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03,
  0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7,
  0x70, 0x3F, 0xFC, 0x01, 0x03, 0xFF, 0xC0, 0x10, 0x3F, 0xFC, 0x01, 0x03, 0xFF, 0xC0, 0x10, 0x3D,
  0x80, 0x91, 0x51, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E,
  0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03,
  0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7,
  0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3D, 0x80, 0x91, 0x50, 0x40, 0x3F, 0xFC, 0x0E,
  0x03, 0xFF, 0xC0, 0xE0, 0x3F, 0xFC, 0x0E, 0x03, 0xFF, 0xC0, 0xE7, 0x60, 0xAA, 0x0D, 0x01, 0x77,
  0x07, 0xB0, 0x27, 0x70, 0x2B, 0x07, 0x77, 0x10, 0xBB, 0x01, 0x77, 0x01, 0xB0, 0xB7, 0x71, 0x06,
  0xB0, 0x87, 0x71, 0x08, 0xB0, 0x87, 0x71, 0x08, 0xB0, 0xB7, 0x71, 0x07, 0xC8, 0x38, 0x10, 0x11,
  0x73, 0x04, 0xF9, 0x06, 0x74, 0x0D, 0xF0, 0x67, 0x40, 0x30, 0xEE, 0x06, 0x75, 0x86, 0x18, 0xCE,
  0xFD, 0xA3,
  // "ę" (U+0119)
  0x72, 0x84, 0x25, 0x77, 0x64, 0x77, 0x20, 0x60, 0xDF, 0x09, 0x02, 0x74, 0x02, 0x0D, 0xFC, 0x06,
  0x72, 0x02, 0x0E, 0xFE, 0x07, 0x70, 0x10, 0xDE, 0x0E, 0x0D, 0xF0, 0x46, 0x08, 0xD0, 0x70, 0x13,
  0x04, 0x0D, 0xC0, 0xD5, 0x02, 0xD0, 0x46, 0x01, 0x0D, 0xC0, 0x64, 0x09, 0xC0, 0x77, 0x10, 0x3C,
  0x0D, 0x40, 0xEB, 0x0E, 0x73, 0x0B, 0xC0, 0x32, 0x03, 0xC0, 0x87, 0x30, 0x5C, 0x07, 0x20, 0x7C,
  0x04, 0x73, 0x01, 0xC0, 0xA2, 0x0A, 0xC0, 0x17, 0x40, 0xEB, 0x0D, 0x20, 0xDC, 0x75, 0x0C, 0xC2,
  0xC0, 0xE8, 0x09, 0x05, 0x0C, 0xC2, 0xFF, 0xF9, 0x00, 0x1F, 0xFF, 0x90, 0x10, 0x2F, 0xFF, 0x90,
  0x10, 0x2F, 0xFF, 0x90, 0x10, 0x2C, 0x0C, 0x77, 0x40, 0x1C, 0x0D, 0x77, 0x5C, 0x0E, 0x77, 0x50,
  0xDC, 0x01, 0x77, 0x40, 0xAC, 0x04, 0x77, 0x40, 0x7C, 0x08, 0x77, 0x40, 0x2C, 0x0D, 0x77, 0x50,
  0xDC, 0x06, 0x77, 0x40, 0x6C, 0x0E, 0x01, 0x77, 0x40, 0xEC, 0x0D, 0x02, 0x73, 0x05, 0x0A, 0x50,
  0x5D, 0x81, 0xE7, 0x24, 0x84, 0x14, 0x8E, 0xFC, 0x60, 0x9F, 0x82, 0xED, 0xDE, 0xD0, 0xC7, 0x0A,
  0xFF, 0x90, 0xC7, 0x10, 0x7F, 0xF0, 0xA7, 0x28, 0x12, 0x9E, 0xFB, 0x0B, 0x76, 0x85, 0x25, 0x67,
  0x65, 0xEA, 0x0C, 0x77, 0x50, 0xAA, 0x0E, 0x01, 0x77, 0x40, 0x7B, 0x04, 0x77, 0x40, 0x2B, 0x0B,
  0x77, 0x50, 0xAB, 0x03, 0x77, 0x40, 0x1B, 0x0D, 0x77, 0x50, 0x5B, 0x0B, 0x77, 0x50, 0x7B, 0x0A,
  0x77, 0x50, 0x7B, 0x0D, 0x77, 0x50, 0x5C, 0x83, 0x91, 0x01, 0x27, 0x70, 0x1F, 0x90, 0x97, 0x71,
  0x0A, 0xF0, 0x97, 0x71, 0x01, 0x0D, 0xE0, 0x97, 0x73, 0x85, 0x7C, 0xEF, 0xEB, 0x52,
  // "Ě" (U+011A)
  0x28, 0x24, 0x77, 0x57, 0x38, 0x26, 0x77, 0x32, 0x05, 0xB0, 0x87, 0x10, 0x9B, 0x03, 0x30, 0x8B,
  0x08, 0x60, 0xAB, 0x06, 0x50, 0xCB, 0x08, 0x40, 0xAB, 0x09, 0x60, 0x20, 0xEB, 0x07, 0x20, 0xAB,
  0x0D, 0x71, 0x05, 0xC0, 0x60, 0x9C, 0x02, 0x72, 0x0A, 0xF9, 0x07, 0x73, 0x01, 0x0E, 0xE0, 0xB7,
  0x50, 0x6E, 0x02, 0x76, 0x0C, 0xC0, 0x98, 0x09, 0xC6, 0x00, 0x3F, 0xFC, 0x0E, 0x03, 0xFF, 0xC0,
  0xE0, 0x3F, 0xFC, 0x0E, 0x03, 0xFF, 0xC0, 0xE0, 0x3D, 0x80, 0x91, 0x50, 0x40, 0x3C, 0x0E, 0x77,
  0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0,
  0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70,
  0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xFF, 0xC0, 0x10, 0x3F, 0xFC,
  0x01, 0x03, 0xFF, 0xC0, 0x10, 0x3F, 0xFC, 0x01, 0x03, 0xD8, 0x09, 0x15, 0x10, 0x3C, 0x0E, 0x77,
  0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0,
  0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70,
  0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E,
  0x77, 0x03, 0xD8, 0x09, 0x15, 0x04, 0x03, 0xFF, 0xC0, 0xE0, 0x3F, 0xFC, 0x0E, 0x03, 0xFF, 0xC0,
  0xE0, 0x3F, 0xFC, 0x0E,
  // "ě" (U+011B)
  0x38, 0x24, 0x77, 0x57, 0x38, 0x26, 0x77, 0x36, 0x05, 0xB0, 0x87, 0x10, 0x9B, 0x03, 0x70, 0x8B,
  0x08, 0x60, 0xAB, 0x06, 0x72, 0x0C, 0xB0, 0x84, 0x0A, 0xB0, 0x97, 0x30, 0x20, 0xEB, 0x07, 0x20,
  0xAB, 0x0D, 0x75, 0x05, 0xC0, 0x60, 0x9C, 0x02, 0x76, 0x0A, 0xF9, 0x07, 0x77, 0x01, 0x0E, 0xE0,
  0xB7, 0x72, 0x06, 0xE0, 0x27, 0x73, 0x0C, 0xC0, 0x98, 0x09, 0xD6, 0x08, 0x42, 0x57, 0x76, 0x47,
  0x72, 0x06, 0x0D, 0xF0, 0x90, 0x27, 0x40, 0x20, 0xDF, 0xC0, 0x67, 0x20, 0x20, 0xEF, 0xE0, 0x77,
  0x01, 0x0D, 0xE0, 0xE0, 0xDF, 0x04, 0x60, 0x8D, 0x07, 0x01, 0x30, 0x40, 0xDC, 0x0D, 0x50, 0x2D,
  0x04, 0x60, 0x10, 0xDC, 0x06, 0x40, 0x9C, 0x07, 0x71, 0x03, 0xC0, 0xD4, 0x0E, 0xB0, 0xE7, 0x30,
  0xBC, 0x03, 0x20, 0x3C, 0x08, 0x73, 0x05, 0xC0, 0x72, 0x07, 0xC0, 0x47, 0x30, 0x1C, 0x0A, 0x20,
  0xAC, 0x01, 0x74, 0x0E, 0xB0, 0xD2, 0x0D, 0xC7, 0x50, 0xCC, 0x2C, 0x0E, 0x80, 0x90, 0x50, 0xCC,
  0x2F, 0xFF, 0x90, 0x01, 0xFF, 0xF9, 0x01, 0x02, 0xFF, 0xF9, 0x01, 0x02, 0xFF, 0xF9, 0x01, 0x02,
  0xC0, 0xC7, 0x74, 0x01, 0xC0, 0xD7, 0x75, 0xC0, 0xE7, 0x75, 0x0D, 0xC0, 0x17, 0x74, 0x0A, 0xC0,
  0x47, 0x74, 0x07, 0xC0, 0x87, 0x74, 0x02, 0xC0, 0xD7, 0x75, 0x0D, 0xC0, 0x67, 0x74, 0x06, 0xC0,
  0xE0, 0x17, 0x74, 0x0E, 0xC0, 0xD0, 0x27, 0x30, 0x50, 0xA5, 0x05, 0xD8, 0x1E, 0x72, 0x48, 0x41,
  0x48, 0xEF, 0xC6, 0x09, 0xF8, 0x2E, 0xDD, 0xED, 0x0C, 0x70, 0xAF, 0xF9, 0x0C, 0x71, 0x07, 0xFF,
  0x08, 0x72, 0x81, 0x29, 0xEF, 0x98, 0x1C, 0x71, 0x76, 0x86, 0x25, 0x67, 0x66, 0x31, 0x60,
  // "Ĝ" (U+011C)
  0x77, 0x84, 0x57, 0x77, 0x73, 0x77, 0x72, 0x01, 0xD0, 0xD7, 0x77, 0x20, 0xAE, 0x06, 0x77, 0x70,
  0x4F, 0x0E, 0x02, 0x77, 0x50, 0x10, 0xDB, 0x0C, 0x0E, 0xB0, 0xB7, 0x75, 0x0A, 0xB8, 0x2D, 0x12,
  0xEB, 0x07, 0x77, 0x30, 0x5B, 0x0D, 0x01, 0x20, 0x30, 0xEB, 0x03, 0x77, 0x10, 0x20, 0xEA, 0x0D,
  0x01, 0x40, 0x4B, 0x0D, 0x01, 0x77, 0x0D, 0xA0, 0xD0, 0x26, 0x04, 0x0E, 0xA0, 0xB7, 0x60, 0x8A,
  0x0D, 0x01, 0x71, 0x03, 0x0D, 0xA0, 0x68, 0x0A, 0x86, 0x08, 0x72, 0x56, 0x77, 0x65, 0x31, 0x77,
  0x48, 0x15, 0xBE, 0xFA, 0x81, 0xD9, 0x47, 0x60, 0x60, 0xEF, 0xF9, 0x81, 0xE8, 0x17, 0x10, 0x20,
  0xCF, 0xFD, 0x0A, 0x70, 0x40, 0xEF, 0x98, 0x2E, 0xDD, 0xEF, 0x90, 0x36, 0x04, 0xF8, 0x1A, 0x51,
  0x58, 0x13, 0x7C, 0xB0, 0xC6, 0x02, 0x0E, 0xD0, 0xC0, 0x27, 0x48, 0x22, 0x9F, 0x66, 0x0C, 0xD0,
  0x97, 0x71, 0x02, 0x60, 0x7D, 0x09, 0x77, 0x71, 0x01, 0x0E, 0xC0, 0xC7, 0x77, 0x20, 0x8D, 0x03,
  0x77, 0x72, 0x0E, 0xC0, 0xA7, 0x77, 0x20, 0x4D, 0x03, 0x77, 0x72, 0x09, 0xC0, 0xD7, 0x77, 0x30,
  0xDC, 0x08, 0x77, 0x72, 0x01, 0xD0, 0x47, 0x77, 0x20, 0x4D, 0x02, 0x77, 0x72, 0x07, 0xC0, 0xE7,
  0x77, 0x30, 0x9C, 0x0C, 0x77, 0x73, 0x0A, 0xC0, 0xB7, 0x77, 0x30, 0xBC, 0x0A, 0x77, 0x73, 0x0C,
  0xC0, 0x97, 0x40, 0xBF, 0xC0, 0x60, 0xCC, 0x09, 0x74, 0x0B, 0xFC, 0x06, 0x0C, 0xC0, 0x97, 0x40,
  0xBF, 0xC0, 0x60, 0xBC, 0x09, 0x74, 0x0B, 0xFC, 0x06, 0x0A, 0xC0, 0xA7, 0x40, 0x38, 0x02, 0x50,
  0xBC, 0x06, 0x09, 0xC0, 0xC7, 0x74, 0x09, 0xC0, 0x60, 0x7C, 0x0E, 0x77, 0x40, 0x9C, 0x06, 0x05,
  0xD0, 0x17, 0x73, 0x09, 0xC0, 0x60, 0x2D, 0x04, 0x77, 0x30, 0x9C, 0x81, 0x60, 0xEC, 0x08, 0x77,
  0x30, 0x9C, 0x81, 0x60, 0xAC, 0x0C, 0x77, 0x30, 0x9C, 0x81, 0x60, 0x6D, 0x02, 0x77, 0x20, 0x9C,
  0x81, 0x60, 0x1D, 0x08, 0x77, 0x20, 0x9C, 0x06, 0x20, 0xAC, 0x0E, 0x01, 0x77, 0x10, 0x9C, 0x06,
  0x20, 0x3D, 0x09, 0x77, 0x10, 0x9C, 0x06, 0x30, 0xBD, 0x05, 0x77, 0x09, 0xC0, 0x63, 0x02, 0xE0,
  0x57, 0x60, 0x9C, 0x06, 0x40, 0x7E, 0x08, 0x75, 0x09, 0xC0, 0x65, 0x09, 0xE8, 0x1E, 0x83, 0x68,
  0x21, 0x48, 0xEC, 0x06, 0x60, 0xAF, 0xA0, 0xE0, 0xFD, 0xFA, 0x06, 0x70, 0x8F, 0xFF, 0x06, 0x71,
  0x03, 0x0C, 0xFF, 0xC0, 0xB0, 0x37, 0x38, 0x13, 0xAE, 0xFC, 0x82, 0xC8, 0x51, 0x77, 0x18, 0x90,
  0x25, 0x67, 0x76, 0x65, 0x31, 0x70,
  // "ĝ" (U+011D)
  0x74, 0x84, 0x57, 0x77, 0x73, 0x77, 0x40, 0x1D, 0x0D, 0x77, 0x40, 0xAE, 0x06, 0x77, 0x20, 0x4F,
  0x0E, 0x02, 0x77, 0x01, 0x0D, 0xB0, 0xC0, 0xEB, 0x0B, 0x77, 0x0A, 0xB8, 0x2D, 0x12, 0xEB, 0x07,
  0x75, 0x05, 0xB0, 0xD0, 0x12, 0x03, 0x0E, 0xB0, 0x37, 0x30, 0x20, 0xEA, 0x0D, 0x01, 0x40, 0x4B,
  0x0D, 0x01, 0x72, 0x0D, 0xA0, 0xD0, 0x26, 0x04, 0x0E, 0xA0, 0xB7, 0x10, 0x8A, 0x0D, 0x01, 0x71,
  0x03, 0x0D, 0xA0, 0x68, 0x09, 0xD2, 0x08, 0x41, 0x47, 0x76, 0x37, 0x73, 0x02, 0x0A, 0xE0, 0xE0,
  0x74, 0x0E, 0xB0, 0x45, 0x06, 0xFB, 0x0C, 0x01, 0x2C, 0x04, 0x40, 0x6F, 0xD8, 0x1C, 0x03, 0xC0,
  0x43, 0x03, 0xF0, 0xE0, 0xDD, 0x09, 0x05, 0xC0, 0x43, 0x0C, 0xD0, 0x90, 0x23, 0x03, 0x0A, 0xB0,
  0xBC, 0x04, 0x20, 0x4D, 0x07, 0x70, 0x6F, 0x04, 0x20, 0xBC, 0x0B, 0x72, 0x09, 0xE8, 0x14, 0x01,
  0xD0, 0x37, 0x20, 0x1E, 0x81, 0x40, 0x5C, 0x0D, 0x74, 0x0A, 0xD8, 0x14, 0x09, 0xC0, 0x87, 0x40,
  0x5D, 0x81, 0x40, 0xBC, 0x05, 0x74, 0x02, 0xD8, 0x14, 0x0E, 0xC0, 0x27, 0x5D, 0x04, 0x1D, 0x76,
  0x0D, 0xC0, 0x40, 0x1C, 0x0E, 0x76, 0x0C, 0xC0, 0x40, 0x2C, 0x0E, 0x76, 0x0B, 0xC0, 0x40, 0x3C,
  0x0D, 0x76, 0x0B, 0xC0, 0x40, 0x3C, 0x0D, 0x76, 0x0A, 0xC0, 0x40, 0x2C, 0x0E, 0x76, 0x0B, 0xC0,
  0x40, 0x2C, 0x0E, 0x76, 0x0B, 0xC0, 0x40, 0x1D, 0x76, 0x0C, 0xC8, 0x14, 0x0E, 0xC0, 0x27, 0x50,
  0xEC, 0x81, 0x40, 0xCC, 0x04, 0x75, 0xD8, 0x14, 0x0A, 0xC0, 0x77, 0x40, 0x4D, 0x81, 0x40, 0x6C,
  0x0B, 0x74, 0x08, 0xD8, 0x14, 0x02, 0xD0, 0x27, 0x30, 0xED, 0x04, 0x20, 0xCC, 0x0A, 0x72, 0x07,
  0xE0, 0x42, 0x06, 0xD0, 0x67, 0x05, 0xF0, 0x43, 0x0D, 0xD0, 0x90, 0x23, 0x02, 0x09, 0xB0, 0xCC,
  0x04, 0x30, 0x5F, 0x81, 0xED, 0xEC, 0x08, 0x09, 0xC0, 0x44, 0x08, 0xFD, 0x81, 0xB0, 0xAC, 0x04,
  0x50, 0x8F, 0xB0, 0xB2, 0x0A, 0xC0, 0x46, 0x03, 0x0B, 0xE0, 0xD0, 0x63, 0x0A, 0xC0, 0x47, 0x18,
  0x41, 0x57, 0x76, 0x35, 0x0A, 0xC0, 0x47, 0x75, 0x0B, 0xC0, 0x37, 0x75, 0x0C, 0xC0, 0x27, 0x75,
  0x0E, 0xC7, 0x75, 0x01, 0xC0, 0xD7, 0x75, 0x06, 0xC0, 0x97, 0x75, 0x0D, 0xC0, 0x53, 0x02, 0x01,
  0x76, 0x0A, 0xC0, 0xE4, 0x82, 0x5F, 0xA4, 0x72, 0x02, 0x0B, 0xD0, 0x74, 0x05, 0xC8, 0x6B, 0x96,
  0x55, 0x68, 0xBE, 0x0C, 0x50, 0x5F, 0xFB, 0x0E, 0x02, 0x50, 0x5F, 0xFA, 0x0D, 0x02, 0x68, 0x11,
  0x7D, 0xFD, 0x0E, 0x07, 0x74, 0x89, 0x23, 0x7A, 0xCE, 0xEF, 0xED, 0xB8, 0x47, 0x10,
  // "Ğ" (U+011E)
  0x72, 0x08, 0xA0, 0xA7, 0x2B, 0x02, 0x76, 0x06, 0xA0, 0xE7, 0x10, 0x6B, 0x01, 0x76, 0x03, 0xB0,
  0xA6, 0x03, 0x0E, 0xA0, 0xC7, 0x71, 0x0D, 0xB8, 0x4E, 0x86, 0x57, 0xBC, 0x07, 0x77, 0x10, 0x7F,
  0xD0, 0xE7, 0x73, 0x0B, 0xFC, 0x03, 0x77, 0x40, 0xAF, 0x90, 0xD0, 0x37, 0x76, 0x86, 0x39, 0xDE,
  0xFD, 0xB6, 0x80, 0xA9, 0x30, 0x87, 0x25, 0x67, 0x76, 0x53, 0x17, 0x74, 0x81, 0x5B, 0xEF, 0xA8,
  0x1D, 0x94, 0x76, 0x06, 0x0E, 0xFF, 0x98, 0x1E, 0x81, 0x71, 0x02, 0x0C, 0xFF, 0xD0, 0xA7, 0x04,
  0x0E, 0xF9, 0x82, 0xED, 0xDE, 0xF9, 0x03, 0x60, 0x4F, 0x81, 0xA5, 0x15, 0x81, 0x37, 0xCB, 0x0C,
  0x60, 0x20, 0xED, 0x0C, 0x02, 0x74, 0x82, 0x29, 0xF6, 0x60, 0xCD, 0x09, 0x77, 0x10, 0x26, 0x07,
  0xD0, 0x97, 0x77, 0x10, 0x10, 0xEC, 0x0C, 0x77, 0x72, 0x08, 0xD0, 0x37, 0x77, 0x20, 0xEC, 0x0A,
  0x77, 0x72, 0x04, 0xD0, 0x37, 0x77, 0x20, 0x9C, 0x0D, 0x77, 0x73, 0x0D, 0xC0, 0x87, 0x77, 0x20,
  0x1D, 0x04, 0x77, 0x72, 0x04, 0xD0, 0x27, 0x77, 0x20, 0x7C, 0x0E, 0x77, 0x73, 0x09, 0xC0, 0xC7,
  0x77, 0x30, 0xAC, 0x0B, 0x77, 0x73, 0x0B, 0xC0, 0xA7, 0x77, 0x30, 0xCC, 0x09, 0x74, 0x0B, 0xFC,
  0x06, 0x0C, 0xC0, 0x97, 0x40, 0xBF, 0xC0, 0x60, 0xCC, 0x09, 0x74, 0x0B, 0xFC, 0x06, 0x0B, 0xC0,
  0x97, 0x40, 0xBF, 0xC0, 0x60, 0xAC, 0x0A, 0x74, 0x03, 0x80, 0x25, 0x0B, 0xC0, 0x60, 0x9C, 0x0C,
  0x77, 0x40, 0x9C, 0x06, 0x07, 0xC0, 0xE7, 0x74, 0x09, 0xC0, 0x60, 0x5D, 0x01, 0x77, 0x30, 0x9C,
  0x06, 0x02, 0xD0, 0x47, 0x73, 0x09, 0xC8, 0x16, 0x0E, 0xC0, 0x87, 0x73, 0x09, 0xC8, 0x16, 0x0A,
  0xC0, 0xC7, 0x73, 0x09, 0xC8, 0x16, 0x06, 0xD0, 0x27, 0x72, 0x09, 0xC8, 0x16, 0x01, 0xD0, 0x87,
  0x72, 0x09, 0xC0, 0x62, 0x0A, 0xC0, 0xE0, 0x17, 0x71, 0x09, 0xC0, 0x62, 0x03, 0xD0, 0x97, 0x71,
  0x09, 0xC0, 0x63, 0x0B, 0xD0, 0x57, 0x70, 0x9C, 0x06, 0x30, 0x2E, 0x05, 0x76, 0x09, 0xC0, 0x64,
  0x07, 0xE0, 0x87, 0x50, 0x9C, 0x06, 0x50, 0x9E, 0x81, 0xE8, 0x36, 0x82, 0x14, 0x8E, 0xC0, 0x66,
  0x0A, 0xFA, 0x0E, 0x0F, 0xDF, 0xA0, 0x67, 0x08, 0xFF, 0xF0, 0x67, 0x10, 0x30, 0xCF, 0xFC, 0x0B,
  0x03, 0x73, 0x81, 0x3A, 0xEF, 0xC8, 0x2C, 0x85, 0x17, 0x71, 0x89, 0x02, 0x56, 0x77, 0x66, 0x53,
  0x17,
  // "ğ" (U+011F)
  0x50, 0x8A, 0x0A, 0x72, 0xB0, 0x27, 0x10, 0x6A, 0x0E, 0x71, 0x06, 0xB0, 0x17, 0x10, 0x3B, 0x0A,
  0x60, 0x30, 0xEA, 0x0C, 0x73, 0x0D, 0xB8, 0x4E, 0x86, 0x57, 0xBC, 0x07, 0x73, 0x07, 0xFD, 0x0E,
  0x75, 0x0B, 0xFC, 0x03, 0x76, 0x0A, 0xF9, 0x0D, 0x03, 0x77, 0x18, 0x63, 0x9D, 0xEF, 0xDB, 0x68,
  0x09, 0xE0, 0x08, 0x41, 0x47, 0x76, 0x37, 0x73, 0x02, 0x0A, 0xE0, 0xE0, 0x74, 0x0E, 0xB0, 0x45,
  0x06, 0xFB, 0x0C, 0x01, 0x2C, 0x04, 0x40, 0x6F, 0xD8, 0x1C, 0x03, 0xC0, 0x43, 0x03, 0xF0, 0xE0,
  0xDD, 0x09, 0x05, 0xC0, 0x43, 0x0C, 0xD0, 0x90, 0x23, 0x03, 0x0A, 0xB0, 0xBC, 0x04, 0x20, 0x4D,
  0x07, 0x70, 0x6F, 0x04, 0x20, 0xBC, 0x0B, 0x72, 0x09, 0xE8, 0x14, 0x01, 0xD0, 0x37, 0x20, 0x1E,
  0x81, 0x40, 0x5C, 0x0D, 0x74, 0x0A, 0xD8, 0x14, 0x09, 0xC0, 0x87, 0x40, 0x5D, 0x81, 0x40, 0xBC,
  0x05, 0x74, 0x02, 0xD8, 0x14, 0x0E, 0xC0, 0x27, 0x5D, 0x04, 0x1D, 0x76, 0x0D, 0xC0, 0x40, 0x1C,
  0x0E, 0x76, 0x0C, 0xC0, 0x40, 0x2C, 0x0E, 0x76, 0x0B, 0xC0, 0x40, 0x3C, 0x0D, 0x76, 0x0B, 0xC0,
  0x40, 0x3C, 0x0D, 0x76, 0x0A, 0xC0, 0x40, 0x2C, 0x0E, 0x76, 0x0B, 0xC0, 0x40, 0x2C, 0x0E, 0x76,
  0x0B, 0xC0, 0x40, 0x1D, 0x76, 0x0C, 0xC8, 0x14, 0x0E, 0xC0, 0x27, 0x50, 0xEC, 0x81, 0x40, 0xCC,
  0x04, 0x75, 0xD8, 0x14, 0x0A, 0xC0, 0x77, 0x40, 0x4D, 0x81, 0x40, 0x6C, 0x0B, 0x74, 0x08, 0xD8,
  0x14, 0x02, 0xD0, 0x27, 0x30, 0xED, 0x04, 0x20, 0xCC, 0x0A, 0x72, 0x07, 0xE0, 0x42, 0x06, 0xD0,
  0x67, 0x05, 0xF0, 0x43, 0x0D, 0xD0, 0x90, 0x23, 0x02, 0x09, 0xB0, 0xCC, 0x04, 0x30, 0x5F, 0x81,
  0xED, 0xEC, 0x08, 0x09, 0xC0, 0x44, 0x08, 0xFD, 0x81, 0xB0, 0xAC, 0x04, 0x50, 0x8F, 0xB0, 0xB2,
  0x0A, 0xC0, 0x46, 0x03, 0x0B, 0xE0, 0xD0, 0x63, 0x0A, 0xC0, 0x47, 0x18, 0x41, 0x57, 0x76, 0x35,
  0x0A, 0xC0, 0x47, 0x75, 0x0B, 0xC0, 0x37, 0x75, 0x0C, 0xC0, 0x27, 0x75, 0x0E, 0xC7, 0x75, 0x01,
  0xC0, 0xD7, 0x75, 0x06, 0xC0, 0x97, 0x75, 0x0D, 0xC0, 0x53, 0x02, 0x01, 0x76, 0x0A, 0xC0, 0xE4,
  0x82, 0x5F, 0xA4, 0x72, 0x02, 0x0B, 0xD0, 0x74, 0x05, 0xC8, 0x6B, 0x96, 0x55, 0x68, 0xBE, 0x0C,
  0x50, 0x5F, 0xFB, 0x0E, 0x02, 0x50, 0x5F, 0xFA, 0x0D, 0x02, 0x68, 0x11, 0x7D, 0xFD, 0x0E, 0x07,
  0x74, 0x89, 0x23, 0x7A, 0xCE, 0xEF, 0xED, 0xB8, 0x47, 0x10,
  // "Ġ" (U+0120)
  0x77, 0x18, 0x35, 0xDE, 0xB2, 0x77, 0x73, 0x02, 0xC0, 0xC7, 0x77, 0x30, 0x7D, 0x01, 0x77, 0x72,
  0x08, 0xD0, 0x27, 0x77, 0x20, 0x7D, 0x01, 0x77, 0x72, 0x02, 0xC0, 0xB7, 0x77, 0x48, 0x34, 0xDE,
  0xB1, 0x80, 0xAD, 0x20, 0x87, 0x25, 0x67, 0x76, 0x53, 0x17, 0x74, 0x81, 0x5B, 0xEF, 0xA8, 0x1D,
  0x94, 0x76, 0x06, 0x0E, 0xFF, 0x98, 0x1E, 0x81, 0x71, 0x02, 0x0C, 0xFF, 0xD0, 0xA7, 0x04, 0x0E,
  0xF9, 0x82, 0xED, 0xDE, 0xF9, 0x03, 0x60, 0x4F, 0x81, 0xA5, 0x15, 0x81, 0x37, 0xCB, 0x0C, 0x60,
  0x20, 0xED, 0x0C, 0x02, 0x74, 0x82, 0x29, 0xF6, 0x60, 0xCD, 0x09, 0x77, 0x10, 0x26, 0x07, 0xD0,
  0x97, 0x77, 0x10, 0x10, 0xEC, 0x0C, 0x77, 0x72, 0x08, 0xD0, 0x37, 0x77, 0x20, 0xEC, 0x0A, 0x77,
  0x72, 0x04, 0xD0, 0x37, 0x77, 0x20, 0x9C, 0x0D, 0x77, 0x73, 0x0D, 0xC0, 0x87, 0x77, 0x20, 0x1D,
  0x04, 0x77, 0x72, 0x04, 0xD0, 0x27, 0x77, 0x20, 0x7C, 0x0E, 0x77, 0x73, 0x09, 0xC0, 0xC7, 0x77,
  0x30, 0xAC, 0x0B, 0x77, 0x73, 0x0B, 0xC0, 0xA7, 0x77, 0x30, 0xCC, 0x09, 0x74, 0x0B, 0xFC, 0x06,
  0x0C, 0xC0, 0x97, 0x40, 0xBF, 0xC0, 0x60, 0xCC, 0x09, 0x74, 0x0B, 0xFC, 0x06, 0x0B, 0xC0, 0x97,
  0x40, 0xBF, 0xC0, 0x60, 0xAC, 0x0A, 0x74, 0x03, 0x80, 0x25, 0x0B, 0xC0, 0x60, 0x9C, 0x0C, 0x77,
  0x40, 0x9C, 0x06, 0x07, 0xC0, 0xE7, 0x74, 0x09, 0xC0, 0x60, 0x5D, 0x01, 0x77, 0x30, 0x9C, 0x06,
  0x02, 0xD0, 0x47, 0x73, 0x09, 0xC8, 0x16, 0x0E, 0xC0, 0x87, 0x73, 0x09, 0xC8, 0x16, 0x0A, 0xC0,
  0xC7, 0x73, 0x09, 0xC8, 0x16, 0x06, 0xD0, 0x27, 0x72, 0x09, 0xC8, 0x16, 0x01, 0xD0, 0x87, 0x72,
  0x09, 0xC0, 0x62, 0x0A, 0xC0, 0xE0, 0x17, 0x71, 0x09, 0xC0, 0x62, 0x03, 0xD0, 0x97, 0x71, 0x09,
  0xC0, 0x63, 0x0B, 0xD0, 0x57, 0x70, 0x9C, 0x06, 0x30, 0x2E, 0x05, 0x76, 0x09, 0xC0, 0x64, 0x07,
  0xE0, 0x87, 0x50, 0x9C, 0x06, 0x50, 0x9E, 0x81, 0xE8, 0x36, 0x82, 0x14, 0x8E, 0xC0, 0x66, 0x0A,
  0xFA, 0x0E, 0x0F, 0xDF, 0xA0, 0x67, 0x08, 0xFF, 0xF0, 0x67, 0x10, 0x30, 0xCF, 0xFC, 0x0B, 0x03,
  0x73, 0x81, 0x3A, 0xEF, 0xC8, 0x2C, 0x85, 0x17, 0x71, 0x89, 0x02, 0x56, 0x77, 0x66, 0x53, 0x17,
  // "ġ" (U+0121)
  0x74, 0x83, 0x5D, 0xEB, 0x27, 0x75, 0x02, 0xC0, 0xC7, 0x75, 0x07, 0xD0, 0x17, 0x74, 0x08, 0xD0,
  0x27, 0x74, 0x07, 0xD0, 0x17, 0x74, 0x02, 0xC0, 0xB7, 0x76, 0x83, 0x4D, 0xEB, 0x18, 0x0A, 0x92,
  0x08, 0x41, 0x47, 0x76, 0x37, 0x73, 0x02, 0x0A, 0xE0, 0xE0, 0x74, 0x0E, 0xB0, 0x45, 0x06, 0xFB,
  0x0C, 0x01, 0x2C, 0x04, 0x40, 0x6F, 0xD8, 0x1C, 0x03, 0xC0, 0x43, 0x03, 0xF0, 0xE0, 0xDD, 0x09,
  0x05, 0xC0, 0x43, 0x0C, 0xD0, 0x90, 0x23, 0x03, 0x0A, 0xB0, 0xBC, 0x04, 0x20, 0x4D, 0x07, 0x70,
  0x6F, 0x04, 0x20, 0xBC, 0x0B, 0x72, 0x09, 0xE8, 0x14, 0x01, 0xD0, 0x37, 0x20, 0x1E, 0x81, 0x40,
  0x5C, 0x0D, 0x74, 0x0A, 0xD8, 0x14, 0x09, 0xC0, 0x87, 0x40, 0x5D, 0x81, 0x40, 0xBC, 0x05, 0x74,
  0x02, 0xD8, 0x14, 0x0E, 0xC0, 0x27, 0x5D, 0x04, 0x1D, 0x76, 0x0D, 0xC0, 0x40, 0x1C, 0x0E, 0x76,
  0x0C, 0xC0, 0x40, 0x2C, 0x0E, 0x76, 0x0B, 0xC0, 0x40, 0x3C, 0x0D, 0x76, 0x0B, 0xC0, 0x40, 0x3C,
  0x0D, 0x76, 0x0A, 0xC0, 0x40, 0x2C, 0x0E, 0x76, 0x0B, 0xC0, 0x40, 0x2C, 0x0E, 0x76, 0x0B, 0xC0,
  0x40, 0x1D, 0x76, 0x0C, 0xC8, 0x14, 0x0E, 0xC0, 0x27, 0x50, 0xEC, 0x81, 0x40, 0xCC, 0x04, 0x75,
  0xD8, 0x14, 0x0A, 0xC0, 0x77, 0x40, 0x4D, 0x81, 0x40, 0x6C, 0x0B, 0x74, 0x08, 0xD8, 0x14, 0x02,
  0xD0, 0x27, 0x30, 0xED, 0x04, 0x20, 0xCC, 0x0A, 0x72, 0x07, 0xE0, 0x42, 0x06, 0xD0, 0x67, 0x05,
  0xF0, 0x43, 0x0D, 0xD0, 0x90, 0x23, 0x02, 0x09, 0xB0, 0xCC, 0x04, 0x30, 0x5F, 0x81, 0xED, 0xEC,
  0x08, 0x09, 0xC0, 0x44, 0x08, 0xFD, 0x81, 0xB0, 0xAC, 0x04, 0x50, 0x8F, 0xB0, 0xB2, 0x0A, 0xC0,
  0x46, 0x03, 0x0B, 0xE0, 0xD0, 0x63, 0x0A, 0xC0, 0x47, 0x18, 0x41, 0x57, 0x76, 0x35, 0x0A, 0xC0,
  0x47, 0x75, 0x0B, 0xC0, 0x37, 0x75, 0x0C, 0xC0, 0x27, 0x75, 0x0E, 0xC7, 0x75, 0x01, 0xC0, 0xD7,
  0x75, 0x06, 0xC0, 0x97, 0x75, 0x0D, 0xC0, 0x53, 0x02, 0x01, 0x76, 0x0A, 0xC0, 0xE4, 0x82, 0x5F,
  0xA4, 0x72, 0x02, 0x0B, 0xD0, 0x74, 0x05, 0xC8, 0x6B, 0x96, 0x55, 0x68, 0xBE, 0x0C, 0x50, 0x5F,
  0xFB, 0x0E, 0x02, 0x50, 0x5F, 0xFA, 0x0D, 0x02, 0x68, 0x11, 0x7D, 0xFD, 0x0E, 0x07, 0x74, 0x89,
  0x23, 0x7A, 0xCE, 0xEF, 0xED, 0xB8, 0x47, 0x10,
  // "Ģ" (U+0122)
  0x77, 0x87, 0x25, 0x67, 0x76, 0x53, 0x17, 0x74, 0x81, 0x5B, 0xEF, 0xA8, 0x1D, 0x94, 0x76, 0x06,
  0x0E, 0xFF, 0x98, 0x1E, 0x81, 0x71, 0x02, 0x0C, 0xFF, 0xD0, 0xA7, 0x04, 0x0E, 0xF9, 0x82, 0xED,
  0xDE, 0xF9, 0x03, 0x60, 0x4F, 0x81, 0xA5, 0x15, 0x81, 0x37, 0xCB, 0x0C, 0x60, 0x20, 0xED, 0x0C,
  0x02, 0x74, 0x82, 0x29, 0xF6, 0x60, 0xCD, 0x09, 0x77, 0x10, 0x26, 0x07, 0xD0, 0x97, 0x77, 0x10,
  0x10, 0xEC, 0x0C, 0x77, 0x72, 0x08, 0xD0, 0x37, 0x77, 0x20, 0xEC, 0x0A, 0x77, 0x72, 0x04, 0xD0,
  0x37, 0x77, 0x20, 0x9C, 0x0D, 0x77, 0x73, 0x0D, 0xC0, 0x87, 0x77, 0x20, 0x1D, 0x04, 0x77, 0x72,
  0x04, 0xD0, 0x27, 0x77, 0x20, 0x7C, 0x0E, 0x77, 0x73, 0x09, 0xC0, 0xC7, 0x77, 0x30, 0xAC, 0x0B,
  0x77, 0x73, 0x0B, 0xC0, 0xA7, 0x77, 0x30, 0xCC, 0x09, 0x74, 0x0B, 0xFC, 0x06, 0x0C, 0xC0, 0x97,
  0x40, 0xBF, 0xC0, 0x60, 0xCC, 0x09, 0x74, 0x0B, 0xFC, 0x06, 0x0B, 0xC0, 0x97, 0x40, 0xBF, 0xC0,
  0x60, 0xAC, 0x0A, 0x74, 0x03, 0x80, 0x25, 0x0B, 0xC0, 0x60, 0x9C, 0x0C, 0x77, 0x40, 0x9C, 0x06,
  0x07, 0xC0, 0xE7, 0x74, 0x09, 0xC0, 0x60, 0x5D, 0x01, 0x77, 0x30, 0x9C, 0x06, 0x02, 0xD0, 0x47,
  0x73, 0x09, 0xC8, 0x16, 0x0E, 0xC0, 0x87, 0x73, 0x09, 0xC8, 0x16, 0x0A, 0xC0, 0xC7, 0x73, 0x09,
  0xC8, 0x16, 0x06, 0xD0, 0x27, 0x72, 0x09, 0xC8, 0x16, 0x01, 0xD0, 0x87, 0x72, 0x09, 0xC0, 0x62,
  0x0A, 0xC0, 0xE0, 0x17, 0x71, 0x09, 0xC0, 0x62, 0x03, 0xD0, 0x97, 0x71, 0x09, 0xC0, 0x63, 0x0B,
  0xD0, 0x57, 0x70, 0x9C, 0x06, 0x30, 0x2E, 0x05, 0x76, 0x09, 0xC0, 0x64, 0x07, 0xE0, 0x87, 0x50,
  0x9C, 0x06, 0x50, 0x9E, 0x81, 0xE8, 0x36, 0x82, 0x14, 0x8E, 0xC0, 0x66, 0x0A, 0xFA, 0x0E, 0x0F,
  0xDF, 0xA0, 0x67, 0x08, 0xFF, 0xF0, 0x67, 0x10, 0x30, 0xCF, 0xFC, 0x0B, 0x03, 0x73, 0x81, 0x3A,
  0xEF, 0xC8, 0x2C, 0x85, 0x17, 0x71, 0x89, 0x02, 0x56, 0x77, 0x66, 0x53, 0x18, 0x09, 0x96, 0x00,
  0xBC, 0x06, 0x77, 0x73, 0x0D, 0xC0, 0x27, 0x77, 0x20, 0x1C, 0x0C, 0x77, 0x73, 0x04, 0xC0, 0x67,
  0x77, 0x30, 0x7B, 0x0E, 0x77, 0x74, 0x0B, 0xB0, 0x87, 0x77, 0x40, 0xEA, 0x0E, 0x01, 0x77, 0x73,
  0x03, 0xB0, 0x87, 0x77, 0x40, 0x7A, 0x0E, 0x01, 0x77, 0x74, 0x0B, 0xA0, 0x57, 0x60,
  // "ģ" (U+0123)
  0x76, 0x05, 0xA0, 0xD7, 0x76, 0x01, 0x0E, 0xA0, 0x97, 0x76, 0x0A, 0xB0, 0x37, 0x75, 0x03, 0xB0,
  0xE7, 0x76, 0x0A, 0xB0, 0xA7, 0x75, 0x02, 0xC0, 0x57, 0x75, 0x09, 0xC0, 0x17, 0x75, 0x0E, 0xB0,
  0xD7, 0x75, 0x05, 0xC0, 0xB7, 0x75, 0x08, 0xC0, 0x98, 0x09, 0xE2, 0x08, 0x41, 0x47, 0x76, 0x37,
  0x73, 0x02, 0x0A, 0xE0, 0xE0, 0x74, 0x0E, 0xB0, 0x45, 0x06, 0xFB, 0x0C, 0x01, 0x2C, 0x04, 0x40,
  0x6F, 0xD8, 0x1C, 0x03, 0xC0, 0x43, 0x03, 0xF0, 0xE0, 0xDD, 0x09, 0x05, 0xC0, 0x43, 0x0C, 0xD0,
  0x90, 0x23, 0x03, 0x0A, 0xB0, 0xBC, 0x04, 0x20, 0x4D, 0x07, 0x70, 0x6F, 0x04, 0x20, 0xBC, 0x0B,
  0x72, 0x09, 0xE8, 0x14, 0x01, 0xD0, 0x37, 0x20, 0x1E, 0x81, 0x40, 0x5C, 0x0D, 0x74, 0x0A, 0xD8,
  0x14, 0x09, 0xC0, 0x87, 0x40, 0x5D, 0x81, 0x40, 0xBC, 0x05, 0x74, 0x02, 0xD8, 0x14, 0x0E, 0xC0,
  0x27, 0x5D, 0x04, 0x1D, 0x76, 0x0D, 0xC0, 0x40, 0x1C, 0x0E, 0x76, 0x0C, 0xC0, 0x40, 0x2C, 0x0E,
  0x76, 0x0B, 0xC0, 0x40, 0x3C, 0x0D, 0x76, 0x0B, 0xC0, 0x40, 0x3C, 0x0D, 0x76, 0x0A, 0xC0, 0x40,
  0x2C, 0x0E, 0x76, 0x0B, 0xC0, 0x40, 0x2C, 0x0E, 0x76, 0x0B, 0xC0, 0x40, 0x1D, 0x76, 0x0C, 0xC8,
  0x14, 0x0E, 0xC0, 0x27, 0x50, 0xEC, 0x81, 0x40, 0xCC, 0x04, 0x75, 0xD8, 0x14, 0x0A, 0xC0, 0x77,
  0x40, 0x4D, 0x81, 0x40, 0x6C, 0x0B, 0x74, 0x08, 0xD8, 0x14, 0x02, 0xD0, 0x27, 0x30, 0xED, 0x04,
  0x20, 0xCC, 0x0A, 0x72, 0x07, 0xE0, 0x42, 0x06, 0xD0, 0x67, 0x05, 0xF0, 0x43, 0x0D, 0xD0, 0x90,
  0x23, 0x02, 0x09, 0xB0, 0xCC, 0x04, 0x30, 0x5F, 0x81, 0xED, 0xEC, 0x08, 0x09, 0xC0, 0x44, 0x08,
  0xFD, 0x81, 0xB0, 0xAC, 0x04, 0x50, 0x8F, 0xB0, 0xB2, 0x0A, 0xC0, 0x46, 0x03, 0x0B, 0xE0, 0xD0,
  0x63, 0x0A, 0xC0, 0x47, 0x18, 0x41, 0x57, 0x76, 0x35, 0x0A, 0xC0, 0x47, 0x75, 0x0B, 0xC0, 0x37,
  0x75, 0x0C, 0xC0, 0x27, 0x75, 0x0E, 0xC7, 0x75, 0x01, 0xC0, 0xD7, 0x75, 0x06, 0xC0, 0x97, 0x75,
  0x0D, 0xC0, 0x53, 0x02, 0x01, 0x76, 0x0A, 0xC0, 0xE4, 0x82, 0x5F, 0xA4, 0x72, 0x02, 0x0B, 0xD0,
  0x74, 0x05, 0xC8, 0x6B, 0x96, 0x55, 0x68, 0xBE, 0x0C, 0x50, 0x5F, 0xFB, 0x0E, 0x02, 0x50, 0x5F,
  0xFA, 0x0D, 0x02, 0x68, 0x11, 0x7D, 0xFD, 0x0E, 0x07, 0x74, 0x89, 0x23, 0x7A, 0xCE, 0xEF, 0xED,
  0xB8, 0x47, 0x10,
  // "Ĥ" (U+0124)
  0x74, 0x84, 0x57, 0x77, 0x73, 0x77, 0x60, 0x1D, 0x0D, 0x77, 0x60, 0xAE, 0x06, 0x77, 0x40, 0x4F,
  0x0E, 0x02, 0x77, 0x20, 0x10, 0xDB, 0x0C, 0x0E, 0xB0, 0xB7, 0x72, 0x0A, 0xB8, 0x2D, 0x12, 0xEB,
  0x07, 0x77, 0x05, 0xB0, 0xD0, 0x12, 0x03, 0x0E, 0xB0, 0x37, 0x50, 0x20, 0xEA, 0x0D, 0x01, 0x40,
  0x4B, 0x0D, 0x01, 0x74, 0x0D, 0xA0, 0xD0, 0x26, 0x04, 0x0E, 0xA0, 0xB7, 0x30, 0x8A, 0x0D, 0x01,
  0x71, 0x03, 0x0D, 0xA0, 0x68, 0x0A, 0x87, 0x00, 0x3C, 0x0E, 0x77, 0x10, 0x3C, 0x0E, 0x03, 0xC0,
  0xE7, 0x71, 0x03, 0xC0, 0xE0, 0x3C, 0x0E, 0x77, 0x10, 0x3C, 0x0E, 0x03, 0xC0, 0xE7, 0x71, 0x03,
  0xC0, 0xE0, 0x3C, 0x0E, 0x77, 0x10, 0x3C, 0x0E, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0, 0xE0, 0x3C,
  0x0E, 0x77, 0x10, 0x3C, 0x0E, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0, 0xE0, 0x3C, 0x0E, 0x77, 0x10,
  0x3C, 0x0E, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0, 0xE0, 0x3C, 0x0E, 0x77, 0x10, 0x3C, 0x0E, 0x03,
  0xC0, 0xE7, 0x71, 0x03, 0xC0, 0xE0, 0x3C, 0x0E, 0x77, 0x10, 0x3C, 0x0E, 0x03, 0xC0, 0xE7, 0x71,
  0x03, 0xC0, 0xE0, 0x3C, 0x0E, 0x77, 0x10, 0x3C, 0x0E, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0, 0xE0,
  0x3C, 0x0E, 0x77, 0x10, 0x3C, 0x0E, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0, 0xE0, 0x3D, 0x80, 0x93,
  0x50, 0x7C, 0x0E, 0x03, 0xFF, 0xFC, 0x0E, 0x03, 0xFF, 0xFC, 0x0E, 0x03, 0xFF, 0xFC, 0x0E, 0x03,
  0xFF, 0xFC, 0x0E, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0, 0xE0, 0x3C, 0x0E, 0x77, 0x10, 0x3C, 0x0E,
  0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0, 0xE0, 0x3C, 0x0E, 0x77, 0x10, 0x3C, 0x0E, 0x03, 0xC0, 0xE7,
  0x71, 0x03, 0xC0, 0xE0, 0x3C, 0x0E, 0x77, 0x10, 0x3C, 0x0E, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0,
  0xE0, 0x3C, 0x0E, 0x77, 0x10, 0x3C, 0x0E, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0, 0xE0, 0x3C, 0x0E,
  0x77, 0x10, 0x3C, 0x0E, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0, 0xE0, 0x3C, 0x0E, 0x77, 0x10, 0x3C,
  0x0E, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0, 0xE0, 0x3C, 0x0E, 0x77, 0x10, 0x3C, 0x0E, 0x03, 0xC0,
  0xE7, 0x71, 0x03, 0xC0, 0xE0, 0x3C, 0x0E, 0x77, 0x10, 0x3C, 0x0E, 0x03, 0xC0, 0xE7, 0x71, 0x03,
  0xC0, 0xE0, 0x3C, 0x0E, 0x77, 0x10, 0x3C, 0x0E, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0, 0xE0, 0x3C,
  0x0E, 0x77, 0x10, 0x3C, 0x0E,
  // "ĥ" (U+0125)
  0x68, 0x45, 0x77, 0x77, 0x37, 0x77, 0x10, 0x1D, 0x0D, 0x77, 0x71, 0x0A, 0xE0, 0x67, 0x76, 0x04,
  0xF0, 0xE0, 0x27, 0x74, 0x01, 0x0D, 0xB0, 0xC0, 0xEB, 0x0B, 0x77, 0x40, 0xAB, 0x82, 0xD1, 0x2E,
  0xB0, 0x77, 0x72, 0x05, 0xB0, 0xD0, 0x12, 0x03, 0x0E, 0xB0, 0x37, 0x70, 0x20, 0xEA, 0x0D, 0x01,
  0x40, 0x4B, 0x0D, 0x01, 0x76, 0x0D, 0xA0, 0xD0, 0x26, 0x04, 0x0E, 0xA0, 0xB7, 0x50, 0x8A, 0x0D,
  0x01, 0x71, 0x03, 0x0D, 0xA0, 0x68, 0x0A, 0x81, 0x00, 0xBC, 0x03, 0x77, 0x72, 0x0B, 0xC0, 0x37,
  0x77, 0x20, 0xBC, 0x03, 0x77, 0x72, 0x0B, 0xC0, 0x37, 0x77, 0x20, 0xBC, 0x03, 0x77, 0x72, 0x0B,
  0xC0, 0x37, 0x77, 0x20, 0xBC, 0x03, 0x77, 0x72, 0x0B, 0xC0, 0x37, 0x77, 0x20, 0xBC, 0x03, 0x77,
  0x72, 0x0B, 0xC0, 0x37, 0x77, 0x20, 0xBC, 0x03, 0x77, 0x72, 0x0B, 0xC0, 0x37, 0x77, 0x20, 0xBC,
  0x03, 0x77, 0x72, 0x0B, 0xC0, 0x34, 0x84, 0x15, 0x77, 0x53, 0x76, 0x0B, 0xC0, 0x32, 0x03, 0x0B,
  0xE8, 0x1E, 0x91, 0x73, 0x0B, 0xC8, 0x12, 0x07, 0xFB, 0x0E, 0x03, 0x72, 0x0B, 0xC0, 0x10, 0x7F,
  0xD0, 0xE0, 0x17, 0x10, 0xBC, 0x03, 0xD8, 0x1E, 0xDE, 0xE0, 0xA7, 0x10, 0xBB, 0x0E, 0x0D, 0xA0,
  0xD0, 0x54, 0x05, 0x0D, 0xD0, 0x27, 0x0B, 0xE0, 0xB7, 0x02, 0x0E, 0xC0, 0x77, 0x0B, 0xD0, 0xE0,
  0x17, 0x10, 0x8C, 0x0B, 0x70, 0xBD, 0x07, 0x72, 0x03, 0xC0, 0xE7, 0x0B, 0xD0, 0x17, 0x3D, 0x70,
  0xBC, 0x0C, 0x74, 0x0E, 0xC0, 0x16, 0x0B, 0xC0, 0x97, 0x40, 0xDC, 0x02, 0x60, 0xBC, 0x07, 0x74,
  0x0C, 0xC0, 0x26, 0x0B, 0xC0, 0x57, 0x40, 0xCC, 0x02, 0x60, 0xBC, 0x04, 0x74, 0x0C, 0xC0, 0x26,
  0x0B, 0xC0, 0x47, 0x40, 0xCC, 0x02, 0x60, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x26, 0x0B, 0xC0, 0x37,
  0x40, 0xCC, 0x02, 0x60, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x26, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02,
  0x60, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x26, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x60, 0xBC, 0x03,
  0x74, 0x0C, 0xC0, 0x26, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x60, 0xBC, 0x03, 0x74, 0x0C, 0xC0,
  0x26, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x60, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x26, 0x0B, 0xC0,
  0x37, 0x40, 0xCC, 0x02, 0x60, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x26, 0x0B, 0xC0, 0x37, 0x40, 0xCC,
  0x02, 0x60, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x26, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x60, 0xBC,
  0x03, 0x74, 0x0C, 0xC0, 0x20,
  // "Ħ" (U+0126)
  0x50, 0x3C, 0x0E, 0x77, 0x10, 0x4C, 0x0E, 0x73, 0x03, 0xC0, 0xE7, 0x71, 0x04, 0xC0, 0xE7, 0x30,
  0x3C, 0x0E, 0x77, 0x10, 0x4C, 0x0E, 0x73, 0x03, 0xC0, 0xE7, 0x71, 0x04, 0xC0, 0xE7, 0x30, 0x3C,
  0x0E, 0x77, 0x10, 0x4C, 0x0E, 0x73, 0x03, 0xC0, 0xE7, 0x71, 0x04, 0xC0, 0xE7, 0x30, 0x3C, 0x0E,
  0x77, 0x10, 0x4C, 0x0E, 0x50, 0x1F, 0xFF, 0xFF, 0x0B, 0x01, 0xFF, 0xFF, 0xF0, 0xB0, 0x1F, 0xFF,
  0xFF, 0x0B, 0x01, 0xFF, 0xFF, 0xF8, 0x5B, 0x05, 0x55, 0x57, 0xD8, 0x09, 0x35, 0x07, 0xC8, 0x4E,
  0x55, 0x55, 0x35, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0, 0xE7, 0x30, 0x3C, 0x0E, 0x77, 0x10, 0x3C,
  0x0E, 0x73, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0, 0xE7, 0x30, 0x3C, 0x0E, 0x77, 0x10, 0x3C, 0x0E,
  0x73, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0, 0xE7, 0x30, 0x3C, 0x0E, 0x77, 0x10, 0x3C, 0x0E, 0x73,
  0x03, 0xFF, 0xFC, 0x0E, 0x73, 0x03, 0xFF, 0xFC, 0x0E, 0x73, 0x03, 0xFF, 0xFC, 0x0E, 0x73, 0x03,
  0xFF, 0xFC, 0x0E, 0x73, 0x03, 0xC0, 0xE8, 0x09, 0x35, 0x07, 0xC0, 0xE7, 0x30, 0x3C, 0x0E, 0x77,
  0x10, 0x4C, 0x0E, 0x73, 0x03, 0xC0, 0xE7, 0x71, 0x04, 0xC0, 0xE7, 0x30, 0x3C, 0x0E, 0x77, 0x10,
  0x4C, 0x0E, 0x73, 0x03, 0xC0, 0xE7, 0x71, 0x04, 0xC0, 0xE7, 0x30, 0x3C, 0x0E, 0x77, 0x10, 0x4C,
  0x0E, 0x73, 0x03, 0xC0, 0xE7, 0x71, 0x04, 0xC0, 0xE7, 0x30, 0x3C, 0x0E, 0x77, 0x10, 0x4C, 0x0E,
  0x73, 0x03, 0xC0, 0xE7, 0x71, 0x04, 0xC0, 0xE7, 0x30, 0x3C, 0x0E, 0x77, 0x10, 0x4C, 0x0E, 0x73,
  0x03, 0xC0, 0xE7, 0x71, 0x04, 0xC0, 0xE7, 0x30, 0x3C, 0x0E, 0x77, 0x10, 0x4C, 0x0E, 0x73, 0x03,
  0xC0, 0xE7, 0x71, 0x04, 0xC0, 0xE7, 0x30, 0x3C, 0x0E, 0x77, 0x10, 0x4C, 0x0E, 0x73, 0x03, 0xC0,
  0xE7, 0x71, 0x04, 0xC0, 0xE7, 0x30, 0x3C, 0x0E, 0x77, 0x10, 0x4C, 0x0E, 0x73, 0x03, 0xC0, 0xE7,
  0x71, 0x04, 0xC0, 0xE7, 0x30, 0x3C, 0x0E, 0x77, 0x10, 0x4C, 0x0E, 0x73, 0x03, 0xC0, 0xE7, 0x71,
  0x04, 0xC0, 0xE7, 0x30, 0x3C, 0x0E, 0x77, 0x10, 0x4C, 0x0E, 0x73, 0x03, 0xC0, 0xE7, 0x71, 0x04,
  0xC0, 0xE5,
  // "ħ" (U+0127)
  0x40, 0xBC, 0x03, 0x77, 0x70, 0xBC, 0x03, 0x77, 0x70, 0xBC, 0x03, 0x77, 0x70, 0xBC, 0x03, 0x77,
  0x70, 0xBC, 0x03, 0x77, 0x70, 0xBC, 0x03, 0x77, 0x30, 0x8F, 0xFA, 0x0D, 0x72, 0x08, 0xFF, 0xA0,
  0xD7, 0x20, 0x8F, 0xFA, 0x0D, 0x72, 0x08, 0xFF, 0xA0, 0xD7, 0x28, 0x32, 0x55, 0x5C, 0xC0, 0x78,
  0x03, 0x50, 0x47, 0x60, 0xBC, 0x03, 0x77, 0x70, 0xBC, 0x03, 0x77, 0x70, 0xBC, 0x03, 0x77, 0x70,
  0xBC, 0x03, 0x38, 0x73, 0x9D, 0xEF, 0xDB, 0x71, 0x72, 0x0B, 0xC8, 0x23, 0x01, 0xAF, 0xA0, 0x77,
  0x10, 0xBC, 0x81, 0x21, 0xDF, 0xC0, 0x97, 0x0B, 0xC0, 0x10, 0xCF, 0xE0, 0x56, 0x0B, 0xB0, 0xE0,
  0x7B, 0x84, 0xC8, 0x65, 0x7D, 0xD0, 0xE6, 0x0B, 0xE0, 0xE0, 0x56, 0x09, 0xD0, 0x55, 0x0B, 0xE0,
  0x47, 0x10, 0xCC, 0x09, 0x50, 0xBD, 0x09, 0x72, 0x06, 0xC0, 0xC5, 0x0B, 0xD0, 0x37, 0x20, 0x1D,
  0x50, 0xBC, 0x0D, 0x74, 0x0E, 0xC0, 0x14, 0x0B, 0xC0, 0xA7, 0x40, 0xDC, 0x01, 0x40, 0xBC, 0x07,
  0x74, 0x0C, 0xC0, 0x24, 0x0B, 0xC0, 0x57, 0x40, 0xCC, 0x02, 0x40, 0xBC, 0x04, 0x74, 0x0C, 0xC0,
  0x24, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x40, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x24, 0x0B, 0xC0,
  0x27, 0x40, 0xCC, 0x02, 0x40, 0xBC, 0x02, 0x74, 0x0C, 0xC0, 0x24, 0x0B, 0xC0, 0x27, 0x40, 0xCC,
  0x02, 0x40, 0xBC, 0x02, 0x74, 0x0C, 0xC0, 0x24, 0x0B, 0xC0, 0x27, 0x40, 0xCC, 0x02, 0x40, 0xBC,
  0x02, 0x74, 0x0C, 0xC0, 0x24, 0x0B, 0xC0, 0x27, 0x40, 0xCC, 0x02, 0x40, 0xBC, 0x02, 0x74, 0x0C,
  0xC0, 0x24, 0x0B, 0xC0, 0x27, 0x40, 0xCC, 0x02, 0x40, 0xBC, 0x02, 0x74, 0x0C, 0xC0, 0x24, 0x0B,
  0xC0, 0x27, 0x40, 0xCC, 0x02, 0x40, 0xBC, 0x02, 0x74, 0x0C, 0xC0, 0x24, 0x0B, 0xC0, 0x27, 0x40,
  0xCC, 0x02, 0x40, 0xBC, 0x02, 0x74, 0x0C, 0xC0, 0x24, 0x0B, 0xC0, 0x27, 0x40, 0xCC, 0x02, 0x40,
  0xBC, 0x02, 0x74, 0x0C, 0xC0, 0x20,
  // "Ĩ" (U+0128)
  0x38, 0x45, 0xCE, 0xEB, 0x67, 0x0B, 0xA0, 0x52, 0x08, 0xE0, 0xE0, 0x74, 0x03, 0xB8, 0x13, 0x03,
  0xFA, 0x83, 0xE9, 0x66, 0xEA, 0x0E, 0x20, 0xAF, 0xFA, 0x81, 0x90, 0x1B, 0x82, 0xD6, 0x6A, 0xFB,
  0x81, 0x20, 0x4A, 0x0E, 0x01, 0x30, 0x10, 0x9F, 0x06, 0x20, 0x7A, 0x09, 0x68, 0x51, 0x7C, 0xEE,
  0xB4, 0x80, 0x9C, 0x60, 0x0D, 0xFD, 0x0C, 0x60, 0xDF, 0xD0, 0xC6, 0x0D, 0xFD, 0x0C, 0x60, 0x70,
  0xDF, 0xB0, 0xC0, 0x77, 0x18, 0x11, 0x5C, 0xC8, 0x1B, 0x51, 0x75, 0x09, 0xC0, 0x87, 0x70, 0x9C,
  0x08, 0x77, 0x09, 0xC0, 0x87, 0x70, 0x9C, 0x08, 0x77, 0x09, 0xC0, 0x87, 0x70, 0x9C, 0x08, 0x77,
  0x09, 0xC0, 0x87, 0x70, 0x9C, 0x08, 0x77, 0x09, 0xC0, 0x87, 0x70, 0x9C, 0x08, 0x77, 0x09, 0xC0,
  0x87, 0x70, 0x9C, 0x08, 0x77, 0x09, 0xC0, 0x87, 0x70, 0x9C, 0x08, 0x77, 0x09, 0xC0, 0x87, 0x70,
  0x9C, 0x08, 0x77, 0x09, 0xC0, 0x87, 0x70, 0x9C, 0x08, 0x77, 0x09, 0xC0, 0x87, 0x70, 0x9C, 0x08,
  0x77, 0x09, 0xC0, 0x87, 0x70, 0x9C, 0x08, 0x77, 0x09, 0xC0, 0x87, 0x70, 0x9C, 0x08, 0x77, 0x09,
  0xC0, 0x87, 0x70, 0x9C, 0x08, 0x77, 0x09, 0xC0, 0x87, 0x70, 0x9C, 0x08, 0x77, 0x09, 0xC0, 0x87,
  0x70, 0x9C, 0x08, 0x77, 0x09, 0xC0, 0x87, 0x70, 0x9C, 0x08, 0x77, 0x09, 0xC0, 0x87, 0x70, 0x9C,
  0x08, 0x74, 0x81, 0x37, 0xBD, 0x82, 0xEB, 0x73, 0x70, 0xCF, 0xD0, 0xB6, 0x0D, 0xFD, 0x0C, 0x60,
  0xDF, 0xD0, 0xC3,
  // "ĩ" (U+0129)
  0x38, 0x45, 0xCE, 0xEB, 0x67, 0x0B, 0xA0, 0x52, 0x08, 0xE0, 0xE0, 0x74, 0x03, 0xB8, 0x13, 0x03,
  0xFA, 0x83, 0xE9, 0x66, 0xEA, 0x0E, 0x20, 0xAF, 0xFA, 0x81, 0x90, 0x1B, 0x82, 0xD6, 0x6A, 0xFB,
  0x81, 0x20, 0x4A, 0x0E, 0x01, 0x30, 0x10, 0x9F, 0x06, 0x20, 0x7A, 0x09, 0x68, 0x51, 0x7C, 0xEE,
  0xB4, 0x80, 0x9D, 0x20, 0x0B, 0xC0, 0x37, 0x70, 0xBC, 0x03, 0x77, 0x0B, 0xC0, 0x37, 0x70, 0xBC,
  0x03, 0x77, 0x0B, 0xC0, 0x37, 0x70, 0xBC, 0x03, 0x77, 0x0B, 0xC0, 0x37, 0x70, 0xBC, 0x03, 0x77,
  0x0B, 0xC0, 0x37, 0x70, 0xBC, 0x03, 0x77, 0x0B, 0xC0, 0x37, 0x70, 0xBC, 0x03, 0x77, 0x0B, 0xC0,
  0x37, 0x70, 0xBC, 0x03, 0x77, 0x0B, 0xC0, 0x37, 0x70, 0xBC, 0x03, 0x77, 0x0B, 0xC0, 0x37, 0x70,
  0xBC, 0x03, 0x77, 0x0B, 0xC0, 0x37, 0x70, 0xBC, 0x03, 0x77, 0x0B, 0xC0, 0x37, 0x70, 0xBC, 0x03,
  0x77, 0x0B, 0xC0, 0x37, 0x70, 0xBC, 0x03, 0x77, 0x0B, 0xC0, 0x37, 0x70, 0xBC, 0x03, 0x77, 0x0B,
  0xC0, 0x37, 0x70, 0xBC, 0x03, 0x77, 0x0B, 0xC0, 0x37, 0x70, 0xBC, 0x03, 0x77, 0x0B, 0xC0, 0x37,
  0x70, 0xBC, 0x03, 0x70,
  // "Ī" (U+012A)
  0x03, 0x80, 0x92, 0x50, 0x40, 0x9F, 0xF0, 0xE0, 0x9F, 0xF0, 0xE0, 0x9F, 0xF0, 0xE0, 0x9F, 0xF0,
  0xE8, 0x09, 0x95, 0x00, 0xDF, 0xD0, 0xC2, 0x0D, 0xFD, 0x0C, 0x20, 0xDF, 0xD0, 0xC2, 0x07, 0x0D,
  0xFB, 0x0C, 0x07, 0x48, 0x11, 0x5C, 0xC8, 0x1B, 0x51, 0x71, 0x09, 0xC0, 0x87, 0x30, 0x9C, 0x08,
  0x73, 0x09, 0xC0, 0x87, 0x30, 0x9C, 0x08, 0x73, 0x09, 0xC0, 0x87, 0x30, 0x9C, 0x08, 0x73, 0x09,
  0xC0, 0x87, 0x30, 0x9C, 0x08, 0x73, 0x09, 0xC0, 0x87, 0x30, 0x9C, 0x08, 0x73, 0x09, 0xC0, 0x87,
  0x30, 0x9C, 0x08, 0x73, 0x09, 0xC0, 0x87, 0x30, 0x9C, 0x08, 0x73, 0x09, 0xC0, 0x87, 0x30, 0x9C,
  0x08, 0x73, 0x09, 0xC0, 0x87, 0x30, 0x9C, 0x08, 0x73, 0x09, 0xC0, 0x87, 0x30, 0x9C, 0x08, 0x73,
  0x09, 0xC0, 0x87, 0x30, 0x9C, 0x08, 0x73, 0x09, 0xC0, 0x87, 0x30, 0x9C, 0x08, 0x73, 0x09, 0xC0,
  0x87, 0x30, 0x9C, 0x08, 0x73, 0x09, 0xC0, 0x87, 0x30, 0x9C, 0x08, 0x73, 0x09, 0xC0, 0x87, 0x30,
  0x9C, 0x08, 0x73, 0x09, 0xC0, 0x87, 0x30, 0x9C, 0x08, 0x73, 0x09, 0xC0, 0x87, 0x30, 0x9C, 0x08,
  0x78, 0x13, 0x7B, 0xD8, 0x2E, 0xB7, 0x33, 0x0C, 0xFD, 0x0B, 0x20, 0xDF, 0xD0, 0xC2, 0x0D, 0xFD,
  0x0C, 0x10,
  // "ī" (U+012B)
  0x03, 0x80, 0x92, 0x50, 0x40, 0x9F, 0xF0, 0xE0, 0x9F, 0xF0, 0xE0, 0x9F, 0xF0, 0xE0, 0x9F, 0xF0,
  0xE8, 0x09, 0xA1, 0x00, 0xBC, 0x03, 0x73, 0x0B, 0xC0, 0x37, 0x30, 0xBC, 0x03, 0x73, 0x0B, 0xC0,
  0x37, 0x30, 0xBC, 0x03, 0x73, 0x0B, 0xC0, 0x37, 0x30, 0xBC, 0x03, 0x73, 0x0B, 0xC0, 0x37, 0x30,
  0xBC, 0x03, 0x73, 0x0B, 0xC0, 0x37, 0x30, 0xBC, 0x03, 0x73, 0x0B, 0xC0, 0x37, 0x30, 0xBC, 0x03,
  0x73, 0x0B, 0xC0, 0x37, 0x30, 0xBC, 0x03, 0x73, 0x0B, 0xC0, 0x37, 0x30, 0xBC, 0x03, 0x73, 0x0B,
  0xC0, 0x37, 0x30, 0xBC, 0x03, 0x73, 0x0B, 0xC0, 0x37, 0x30, 0xBC, 0x03, 0x73, 0x0B, 0xC0, 0x37,
  0x30, 0xBC, 0x03, 0x73, 0x0B, 0xC0, 0x37, 0x30, 0xBC, 0x03, 0x73, 0x0B, 0xC0, 0x37, 0x30, 0xBC,
  0x03, 0x73, 0x0B, 0xC0, 0x37, 0x30, 0xBC, 0x03, 0x73, 0x0B, 0xC0, 0x37, 0x30, 0xBC, 0x03, 0x73,
  0x0B, 0xC0, 0x35,
  // "Ĭ" (U+012C)
  0x08, 0xA0, 0xA7, 0x2B, 0x02, 0x06, 0xA0, 0xE7, 0x10, 0x6B, 0x01, 0x03, 0xB0, 0xA6, 0x03, 0x0E,
  0xA0, 0xC2, 0x0D, 0xB8, 0x4E, 0x86, 0x57, 0xBC, 0x07, 0x20, 0x7F, 0xD0, 0xE4, 0x0B, 0xFC, 0x03,
  0x50, 0xAF, 0x90, 0xD0, 0x37, 0x86, 0x39, 0xDE, 0xFD, 0xB6, 0x80, 0x9A, 0x70, 0x0D, 0xFD, 0x0C,
  0x30, 0xDF, 0xD0, 0xC3, 0x0D, 0xFD, 0x0C, 0x30, 0x70, 0xDF, 0xB0, 0xC0, 0x75, 0x81, 0x15, 0xCC,
  0x81, 0xB5, 0x17, 0x20, 0x9C, 0x08, 0x74, 0x09, 0xC0, 0x87, 0x40, 0x9C, 0x08, 0x74, 0x09, 0xC0,
  0x87, 0x40, 0x9C, 0x08, 0x74, 0x09, 0xC0, 0x87, 0x40, 0x9C, 0x08, 0x74, 0x09, 0xC0, 0x87, 0x40,
  0x9C, 0x08, 0x74, 0x09, 0xC0, 0x87, 0x40, 0x9C, 0x08, 0x74, 0x09, 0xC0, 0x87, 0x40, 0x9C, 0x08,
  0x74, 0x09, 0xC0, 0x87, 0x40, 0x9C, 0x08, 0x74, 0x09, 0xC0, 0x87, 0x40, 0x9C, 0x08, 0x74, 0x09,
  0xC0, 0x87, 0x40, 0x9C, 0x08, 0x74, 0x09, 0xC0, 0x87, 0x40, 0x9C, 0x08, 0x74, 0x09, 0xC0, 0x87,
  0x40, 0x9C, 0x08, 0x74, 0x09, 0xC0, 0x87, 0x40, 0x9C, 0x08, 0x74, 0x09, 0xC0, 0x87, 0x40, 0x9C,
  0x08, 0x74, 0x09, 0xC0, 0x87, 0x40, 0x9C, 0x08, 0x74, 0x09, 0xC0, 0x87, 0x40, 0x9C, 0x08, 0x74,
  0x09, 0xC0, 0x87, 0x40, 0x9C, 0x08, 0x74, 0x09, 0xC0, 0x87, 0x18, 0x13, 0x7B, 0xD8, 0x2E, 0xB7,
  0x34, 0x0C, 0xFD, 0x0B, 0x30, 0xDF, 0xD0, 0xC3, 0x0D, 0xFD, 0x0C, 0x20,
  // "ĭ" (U+012D)
  0x08, 0xA0, 0xA7, 0x2B, 0x02, 0x06, 0xA0, 0xE7, 0x10, 0x6B, 0x01, 0x03, 0xB0, 0xA6, 0x03, 0x0E,
  0xA0, 0xC2, 0x0D, 0xB8, 0x4E, 0x86, 0x57, 0xBC, 0x07, 0x20, 0x7F, 0xD0, 0xE4, 0x0B, 0xFC, 0x03,
  0x50, 0xAF, 0x90, 0xD0, 0x37, 0x86, 0x39, 0xDE, 0xFD, 0xB6, 0x80, 0x9B, 0x40, 0x0B, 0xC0, 0x37,
  0x40, 0xBC, 0x03, 0x74, 0x0B, 0xC0, 0x37, 0x40, 0xBC, 0x03, 0x74, 0x0B, 0xC0, 0x37, 0x40, 0xBC,
  0x03, 0x74, 0x0B, 0xC0, 0x37, 0x40, 0xBC, 0x03, 0x74, 0x0B, 0xC0, 0x37, 0x40, 0xBC, 0x03, 0x74,
  0x0B, 0xC0, 0x37, 0x40, 0xBC, 0x03, 0x74, 0x0B, 0xC0, 0x37, 0x40, 0xBC, 0x03, 0x74, 0x0B, 0xC0,
  0x37, 0x40, 0xBC, 0x03, 0x74, 0x0B, 0xC0, 0x37, 0x40, 0xBC, 0x03, 0x74, 0x0B, 0xC0, 0x37, 0x40,
  0xBC, 0x03, 0x74, 0x0B, 0xC0, 0x37, 0x40, 0xBC, 0x03, 0x74, 0x0B, 0xC0, 0x37, 0x40, 0xBC, 0x03,
  0x74, 0x0B, 0xC0, 0x37, 0x40, 0xBC, 0x03, 0x74, 0x0B, 0xC0, 0x37, 0x40, 0xBC, 0x03, 0x74, 0x0B,
  0xC0, 0x37, 0x40, 0xBC, 0x03, 0x74, 0x0B, 0xC0, 0x37, 0x40, 0xBC, 0x03, 0x50,
  // "Į" (U+012E)
  0x0D, 0xFD, 0x0C, 0x0D, 0xFD, 0x0C, 0x0D, 0xFD, 0x81, 0xC7, 0xDF, 0xB0, 0xC0, 0x72, 0x81, 0x15,
  0xCC, 0x81, 0xB5, 0x16, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C,
  0x08, 0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71,
  0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0,
  0x87, 0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87, 0x10,
  0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08,
  0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71, 0x09,
  0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87,
  0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08, 0x58, 0x13, 0x7B, 0xD8, 0x4E, 0xB7,
  0x30, 0xCF, 0xD0, 0xB0, 0xDF, 0xD0, 0xC0, 0xDF, 0xD0, 0xC7, 0x0A, 0xA0, 0xD0, 0x17, 0x10, 0x7B,
  0x02, 0x71, 0x02, 0xB0, 0x77, 0x20, 0xBB, 0x01, 0x71, 0x01, 0xB0, 0xB7, 0x20, 0x6B, 0x08, 0x72,
  0x08, 0xB0, 0x87, 0x20, 0x8B, 0x0B, 0x72, 0x07, 0xC8, 0x38, 0x10, 0x11, 0x40, 0x4F, 0x90, 0x65,
  0x0D, 0xF0, 0x65, 0x03, 0x0E, 0xE0, 0x66, 0x86, 0x18, 0xCE, 0xFD, 0xA3,
  // "į" (U+012F)
  0x38, 0x31, 0xAE, 0xD7, 0x50, 0xAC, 0x03, 0x40, 0xEC, 0x08, 0x30, 0x1D, 0x09, 0x40, 0xEC, 0x08,
  0x40, 0x9C, 0x03, 0x48, 0x31, 0x9E, 0xD6, 0x80, 0xF5, 0x00, 0xBC, 0x03, 0x40, 0xBC, 0x03, 0x40,
  0xBC, 0x03, 0x40, 0xBC, 0x03, 0x40, 0xBC, 0x03, 0x40, 0xBC, 0x03, 0x40, 0xBC, 0x03, 0x40, 0xBC,
  0x03, 0x40, 0xBC, 0x03, 0x40, 0xBC, 0x03, 0x40, 0xBC, 0x03, 0x40, 0xBC, 0x03, 0x40, 0xBC, 0x03,
  0x40, 0xBC, 0x03, 0x40, 0xBC, 0x03, 0x40, 0xBC, 0x03, 0x40, 0xBC, 0x03, 0x40, 0xBC, 0x03, 0x40,
  0xBC, 0x03, 0x40, 0xBC, 0x03, 0x40, 0xBC, 0x03, 0x40, 0xBC, 0x03, 0x40, 0xBC, 0x03, 0x40, 0xBC,
  0x03, 0x40, 0xBC, 0x03, 0x40, 0xBC, 0x03, 0x40, 0xBC, 0x03, 0x40, 0xBC, 0x03, 0x40, 0xBC, 0x03,
  0x40, 0xBC, 0x03, 0x40, 0xBC, 0x03, 0x40, 0xBC, 0x04, 0x40, 0xAA, 0x0D, 0x01, 0x40, 0x7B, 0x02,
  0x40, 0x2B, 0x07, 0x50, 0xBB, 0x01, 0x40, 0x1B, 0x0B, 0x50, 0x6B, 0x08, 0x50, 0x8B, 0x08, 0x50,
  0x8B, 0x0B, 0x50, 0x7C, 0x84, 0x81, 0x01, 0x14, 0xF9, 0x81, 0x60, 0xDF, 0x82, 0x60, 0x3E, 0xE0,
  0x62, 0x86, 0x18, 0xCE, 0xFD, 0xA3,
  // "İ" (U+0130)
  0x58, 0x35, 0xDE, 0xB2, 0x71, 0x02, 0xC0, 0xC7, 0x10, 0x7D, 0x01, 0x70, 0x8D, 0x02, 0x70, 0x7D,
  0x01, 0x70, 0x2C, 0x0B, 0x72, 0x83, 0x4D, 0xEB, 0x18, 0x09, 0xA4, 0x00, 0xDF, 0xD0, 0xC0, 0xDF,
  0xD0, 0xC0, 0xDF, 0xD8, 0x1C, 0x7D, 0xFB, 0x0C, 0x07, 0x28, 0x11, 0x5C, 0xC8, 0x1B, 0x51, 0x60,
  0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08,
  0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71, 0x09,
  0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87,
  0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C,
  0x08, 0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71,
  0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0,
  0x87, 0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87, 0x10, 0x9C, 0x08, 0x71, 0x09, 0xC0, 0x87, 0x10,
  0x9C, 0x08, 0x71, 0x09, 0xC0, 0x85, 0x81, 0x37, 0xBD, 0x84, 0xEB, 0x73, 0x0C, 0xFD, 0x0B, 0x0D,
  0xFD, 0x0C, 0x0D, 0xFD, 0x0C,
  // "ı" (U+0131)
  0x0B, 0xC0, 0x30, 0xBC, 0x03, 0x0B, 0xC0, 0x30, 0xBC, 0x03, 0x0B, 0xC0, 0x30, 0xBC, 0x03, 0x0B,
  0xC0, 0x30, 0xBC, 0x03, 0x0B, 0xC0, 0x30, 0xBC, 0x03, 0x0B, 0xC0, 0x30, 0xBC, 0x03, 0x0B, 0xC0,
  0x30, 0xBC, 0x03, 0x0B, 0xC0, 0x30, 0xBC, 0x03, 0x0B, 0xC0, 0x30, 0xBC, 0x03, 0x0B, 0xC0, 0x30,
  0xBC, 0x03, 0x0B, 0xC0, 0x30, 0xBC, 0x03, 0x0B, 0xC0, 0x30, 0xBC, 0x03, 0x0B, 0xC0, 0x30, 0xBC,
  0x03, 0x0B, 0xC0, 0x30, 0xBC, 0x03, 0x0B, 0xC0, 0x30, 0xBC, 0x03, 0x0B, 0xC0, 0x30, 0xBC, 0x03,
  // "Ĳ" (U+0132)
  0x0D, 0xFD, 0x0C, 0x50, 0x5C, 0x0B, 0x0D, 0xFD, 0x0C, 0x50, 0x5C, 0x0B, 0x0D, 0xFD, 0x0C, 0x50,
  0x5C, 0x81, 0xB7, 0xDF, 0xB0, 0xC0, 0x75, 0x05, 0xC0, 0xB2, 0x81, 0x15, 0xCC, 0x81, 0xB5, 0x17,
  0x05, 0xC0, 0xB4, 0x09, 0xC0, 0x87, 0x20, 0x5C, 0x0B, 0x40, 0x9C, 0x08, 0x72, 0x05, 0xC0, 0xB4,
  0x09, 0xC0, 0x87, 0x20, 0x5C, 0x0B, 0x40, 0x9C, 0x08, 0x72, 0x05, 0xC0, 0xB4, 0x09, 0xC0, 0x87,
  0x20, 0x5C, 0x0B, 0x40, 0x9C, 0x08, 0x72, 0x05, 0xC0, 0xB4, 0x09, 0xC0, 0x87, 0x20, 0x5C, 0x0B,
  0x40, 0x9C, 0x08, 0x72, 0x05, 0xC0, 0xB4, 0x09, 0xC0, 0x87, 0x20, 0x5C, 0x0B, 0x40, 0x9C, 0x08,
  0x72, 0x05, 0xC0, 0xB4, 0x09, 0xC0, 0x87, 0x20, 0x5C, 0x0B, 0x40, 0x9C, 0x08, 0x72, 0x05, 0xC0,
  0xB4, 0x09, 0xC0, 0x87, 0x20, 0x5C, 0x0B, 0x40, 0x9C, 0x08, 0x72, 0x05, 0xC0, 0xB4, 0x09, 0xC0,
  0x87, 0x20, 0x5C, 0x0B, 0x40, 0x9C, 0x08, 0x72, 0x05, 0xC0, 0xB4, 0x09, 0xC0, 0x87, 0x20, 0x5C,
  0x0B, 0x40, 0x9C, 0x08, 0x72, 0x05, 0xC0, 0xB4, 0x09, 0xC0, 0x87, 0x20, 0x5C, 0x0B, 0x40, 0x9C,
  0x08, 0x72, 0x05, 0xC0, 0xB4, 0x09, 0xC0, 0x87, 0x20, 0x5C, 0x0B, 0x40, 0x9C, 0x08, 0x72, 0x05,
  0xC0, 0xB4, 0x09, 0xC0, 0x87, 0x20, 0x5C, 0x0B, 0x40, 0x9C, 0x08, 0x72, 0x05, 0xC0, 0xB4, 0x09,
  0xC0, 0x87, 0x20, 0x5C, 0x0B, 0x40, 0x9C, 0x08, 0x72, 0x05, 0xC0, 0xB4, 0x09, 0xC0, 0x87, 0x20,
  0x5C, 0x0B, 0x40, 0x9C, 0x08, 0x72, 0x05, 0xC0, 0xB4, 0x09, 0xC0, 0x87, 0x20, 0x5C, 0x0B, 0x40,
  0x9C, 0x08, 0x72, 0x05, 0xC0, 0xB4, 0x09, 0xC0, 0x87, 0x20, 0x5C, 0x0B, 0x40, 0x9C, 0x08, 0x72,
  0x05, 0xC0, 0xB4, 0x09, 0xC0, 0x87, 0x20, 0x5C, 0x0B, 0x40, 0x9C, 0x08, 0x72, 0x05, 0xC8, 0x3B,
  0x03, 0x7B, 0xD8, 0x2E, 0xB7, 0x36, 0x05, 0xC0, 0xB0, 0xCF, 0xD0, 0xB5, 0x05, 0xC0, 0xB0, 0xDF,
  0xD0, 0xC5, 0x05, 0xC0, 0xB0, 0xDF, 0xD0, 0xC5, 0x05, 0xC0, 0xB7, 0x75, 0x06, 0xC0, 0xA7, 0x75,
  0x07, 0xC0, 0x97, 0x75, 0x08, 0xC0, 0x87, 0x75, 0x0B, 0xC0, 0x67, 0x74, 0x01, 0xD0, 0x37, 0x74,
  0x0A, 0xC0, 0xE7, 0x58, 0x13, 0x51, 0x20, 0x30, 0xAD, 0x08, 0x75, 0x07, 0xFB, 0x0E, 0x01, 0x75,
  0x07, 0xFB, 0x05, 0x76, 0x07, 0xFA, 0x05, 0x77, 0x05, 0x0E, 0xD8, 0x1E, 0x91, 0x77, 0x38, 0x32,
  0x34, 0x32, 0x70,
  // "ĳ" (U+0133)
  0x18, 0x31, 0xAE, 0xD7, 0x72, 0x83, 0x1A, 0xED, 0x72, 0x0A, 0xC0, 0x37, 0x10, 0xAC, 0x81, 0x30,
  0xEC, 0x08, 0x71, 0x0E, 0xC0, 0x80, 0x1D, 0x09, 0x70, 0x1D, 0x81, 0x90, 0xEC, 0x08, 0x71, 0x0E,
  0xC8, 0x18, 0x09, 0xC0, 0x37, 0x10, 0x9C, 0x85, 0x30, 0x19, 0xED, 0x67, 0x28, 0x31, 0x9E, 0xD6,
  0x80, 0x9F, 0x40, 0x0B, 0xC0, 0x37, 0x10, 0xBC, 0x81, 0x30, 0xBC, 0x03, 0x71, 0x0B, 0xC8, 0x13,
  0x0B, 0xC0, 0x37, 0x10, 0xBC, 0x81, 0x30, 0xBC, 0x03, 0x71, 0x0B, 0xC8, 0x13, 0x0B, 0xC0, 0x37,
  0x10, 0xBC, 0x81, 0x30, 0xBC, 0x03, 0x71, 0x0B, 0xC8, 0x13, 0x0B, 0xC0, 0x37, 0x10, 0xBC, 0x81,
  0x30, 0xBC, 0x03, 0x71, 0x0B, 0xC8, 0x13, 0x0B, 0xC0, 0x37, 0x10, 0xBC, 0x81, 0x30, 0xBC, 0x03,
  0x71, 0x0B, 0xC8, 0x13, 0x0B, 0xC0, 0x37, 0x10, 0xBC, 0x81, 0x30, 0xBC, 0x03, 0x71, 0x0B, 0xC8,
  0x13, 0x0B, 0xC0, 0x37, 0x10, 0xBC, 0x81, 0x30, 0xBC, 0x03, 0x71, 0x0B, 0xC8, 0x13, 0x0B, 0xC0,
  0x37, 0x10, 0xBC, 0x81, 0x30, 0xBC, 0x03, 0x71, 0x0B, 0xC8, 0x13, 0x0B, 0xC0, 0x37, 0x10, 0xBC,
  0x81, 0x30, 0xBC, 0x03, 0x71, 0x0B, 0xC8, 0x13, 0x0B, 0xC0, 0x37, 0x10, 0xBC, 0x81, 0x30, 0xBC,
  0x03, 0x71, 0x0B, 0xC8, 0x13, 0x0B, 0xC0, 0x37, 0x10, 0xBC, 0x81, 0x30, 0xBC, 0x03, 0x71, 0x0B,
  0xC8, 0x13, 0x0B, 0xC0, 0x37, 0x10, 0xBC, 0x81, 0x30, 0xBC, 0x03, 0x71, 0x0B, 0xC8, 0x13, 0x0B,
  0xC0, 0x37, 0x10, 0xBC, 0x81, 0x30, 0xBC, 0x03, 0x71, 0x0B, 0xC8, 0x13, 0x0B, 0xC0, 0x37, 0x10,
  0xBC, 0x81, 0x30, 0xBC, 0x03, 0x71, 0x0B, 0xC8, 0x13, 0x0B, 0xC0, 0x37, 0x10, 0xBC, 0x81, 0x30,
  0xBC, 0x03, 0x71, 0x0B, 0xC8, 0x13, 0x0B, 0xC0, 0x37, 0x10, 0xBC, 0x81, 0x30, 0xBC, 0x03, 0x71,
  0x0B, 0xC0, 0x37, 0x71, 0x0B, 0xC0, 0x37, 0x71, 0x0B, 0xC0, 0x37, 0x71, 0x0B, 0xC0, 0x37, 0x71,
  0x0B, 0xC0, 0x37, 0x71, 0x0B, 0xC0, 0x37, 0x71, 0x0B, 0xC0, 0x27, 0x71, 0x0D, 0xC0, 0x27, 0x70,
  0x1D, 0x77, 0x10, 0x9C, 0x0C, 0x73, 0x83, 0x68, 0x55, 0xAD, 0x07, 0x73, 0x08, 0xFA, 0x01, 0x73,
  0x08, 0xF9, 0x07, 0x74, 0x08, 0xF0, 0x87, 0x58, 0x64, 0xBD, 0xFE, 0xD9, 0x34,
  // "Ĵ" (U+0134)
  0x71, 0x84, 0x57, 0x77, 0x73, 0x76, 0x01, 0xD0, 0xD7, 0x60, 0xAE, 0x06, 0x74, 0x04, 0xF0, 0xE0,
  0x27, 0x20, 0x10, 0xDB, 0x0C, 0x0E, 0xB0, 0xB7, 0x20, 0xAB, 0x82, 0xD1, 0x2E, 0xB0, 0x77, 0x05,
  0xB0, 0xD0, 0x12, 0x03, 0x0E, 0xB0, 0x35, 0x02, 0x0E, 0xA0, 0xD0, 0x14, 0x04, 0xB0, 0xD0, 0x14,
  0x0D, 0xA0, 0xD0, 0x26, 0x04, 0x0E, 0xA0, 0xB3, 0x08, 0xA0, 0xD0, 0x17, 0x10, 0x30, 0xDA, 0x06,
  0x80, 0x9D, 0x00, 0x05, 0xC0, 0xB7, 0x70, 0x5C, 0x0B, 0x77, 0x05, 0xC0, 0xB7, 0x70, 0x5C, 0x0B,
  0x77, 0x05, 0xC0, 0xB7, 0x70, 0x5C, 0x0B, 0x77, 0x05, 0xC0, 0xB7, 0x70, 0x5C, 0x0B, 0x77, 0x05,
  0xC0, 0xB7, 0x70, 0x5C, 0x0B, 0x77, 0x05, 0xC0, 0xB7, 0x70, 0x5C, 0x0B, 0x77, 0x05, 0xC0, 0xB7,
  0x70, 0x5C, 0x0B, 0x77, 0x05, 0xC0, 0xB7, 0x70, 0x5C, 0x0B, 0x77, 0x05, 0xC0, 0xB7, 0x70, 0x5C,
  0x0B, 0x77, 0x05, 0xC0, 0xB7, 0x70, 0x5C, 0x0B, 0x77, 0x05, 0xC0, 0xB7, 0x70, 0x5C, 0x0B, 0x77,
  0x05, 0xC0, 0xB7, 0x70, 0x5C, 0x0B, 0x77, 0x05, 0xC0, 0xB7, 0x70, 0x5C, 0x0B, 0x77, 0x05, 0xC0,
  0xB7, 0x70, 0x5C, 0x0B, 0x77, 0x05, 0xC0, 0xB7, 0x70, 0x5C, 0x0B, 0x77, 0x05, 0xC0, 0xB7, 0x70,
  0x5C, 0x0B, 0x77, 0x05, 0xC0, 0xB7, 0x70, 0x5C, 0x0B, 0x77, 0x05, 0xC0, 0xB7, 0x70, 0x5C, 0x0B,
  0x77, 0x05, 0xC0, 0xB7, 0x70, 0x5C, 0x0B, 0x77, 0x05, 0xC0, 0xB7, 0x70, 0x5C, 0x0B, 0x77, 0x05,
  0xC0, 0xB7, 0x70, 0x5C, 0x0B, 0x77, 0x05, 0xC0, 0xB7, 0x70, 0x6C, 0x0A, 0x77, 0x07, 0xC0, 0x97,
  0x70, 0x8C, 0x08, 0x77, 0x0B, 0xC0, 0x67, 0x60, 0x1D, 0x03, 0x76, 0x0A, 0xC0, 0xE7, 0x81, 0x35,
  0x12, 0x03, 0x0A, 0xD0, 0x87, 0x07, 0xFB, 0x0E, 0x01, 0x70, 0x7F, 0xB0, 0x57, 0x10, 0x7F, 0xA0,
  0x57, 0x20, 0x50, 0xED, 0x81, 0xE9, 0x17, 0x58, 0x32, 0x34, 0x32, 0x76,
  // "ĵ" (U+0135)
  0x68, 0x45, 0x77, 0x77, 0x37, 0x40, 0x1D, 0x0D, 0x74, 0x0A, 0xE0, 0x67, 0x20, 0x4F, 0x0E, 0x02,
  0x70, 0x10, 0xDB, 0x0C, 0x0E, 0xB0, 0xB7, 0x0A, 0xB8, 0x2D, 0x12, 0xEB, 0x07, 0x50, 0x5B, 0x0D,
  0x01, 0x20, 0x30, 0xEB, 0x03, 0x30, 0x20, 0xEA, 0x0D, 0x01, 0x40, 0x4B, 0x0D, 0x01, 0x20, 0xDA,
  0x0D, 0x02, 0x60, 0x40, 0xEA, 0x81, 0xB0, 0x8A, 0x0D, 0x01, 0x71, 0x03, 0x0D, 0xA0, 0x68, 0x09,
  0xB4, 0x00, 0xBC, 0x03, 0x75, 0x0B, 0xC0, 0x37, 0x50, 0xBC, 0x03, 0x75, 0x0B, 0xC0, 0x37, 0x50,
  0xBC, 0x03, 0x75, 0x0B, 0xC0, 0x37, 0x50, 0xBC, 0x03, 0x75, 0x0B, 0xC0, 0x37, 0x50, 0xBC, 0x03,
  0x75, 0x0B, 0xC0, 0x37, 0x50, 0xBC, 0x03, 0x75, 0x0B, 0xC0, 0x37, 0x50, 0xBC, 0x03, 0x75, 0x0B,
  0xC0, 0x37, 0x50, 0xBC, 0x03, 0x75, 0x0B, 0xC0, 0x37, 0x50, 0xBC, 0x03, 0x75, 0x0B, 0xC0, 0x37,
  0x50, 0xBC, 0x03, 0x75, 0x0B, 0xC0, 0x37, 0x50, 0xBC, 0x03, 0x75, 0x0B, 0xC0, 0x37, 0x50, 0xBC,
  0x03, 0x75, 0x0B, 0xC0, 0x37, 0x50, 0xBC, 0x03, 0x75, 0x0B, 0xC0, 0x37, 0x50, 0xBC, 0x03, 0x75,
  0x0B, 0xC0, 0x37, 0x50, 0xBC, 0x03, 0x75, 0x0B, 0xC0, 0x37, 0x50, 0xBC, 0x03, 0x75, 0x0B, 0xC0,
  0x37, 0x50, 0xBC, 0x03, 0x75, 0x0B, 0xC0, 0x37, 0x50, 0xBC, 0x03, 0x75, 0x0B, 0xC0, 0x37, 0x50,
  0xBC, 0x03, 0x75, 0x0B, 0xC0, 0x27, 0x50, 0xDC, 0x02, 0x74, 0x01, 0xD7, 0x50, 0x9C, 0x0C, 0x78,
  0x36, 0x85, 0x5A, 0xD0, 0x77, 0x08, 0xFA, 0x01, 0x70, 0x8F, 0x90, 0x77, 0x10, 0x8F, 0x08, 0x72,
  0x86, 0x4B, 0xDF, 0xED, 0x93, 0x73,
  // "Ķ" (U+0136)
  0x03, 0xC0, 0xE7, 0x60, 0x7D, 0x00, 0x3C, 0x0E, 0x75, 0x02, 0xD8, 0x18, 0x03, 0xC0, 0xE7, 0x50,
  0xBC, 0x0D, 0x20, 0x3C, 0x0E, 0x74, 0x06, 0xD0, 0x32, 0x03, 0xC0, 0xE7, 0x30, 0x10, 0xEC, 0x09,
  0x30, 0x3C, 0x0E, 0x73, 0x0A, 0xC0, 0xD4, 0x03, 0xC0, 0xE7, 0x20, 0x4D, 0x04, 0x40, 0x3C, 0x0E,
  0x72, 0x0D, 0xC0, 0x95, 0x03, 0xC0, 0xE7, 0x10, 0x8C, 0x0E, 0x01, 0x50, 0x3C, 0x0E, 0x70, 0x3D,
  0x05, 0x60, 0x3C, 0x0E, 0x70, 0xCC, 0x0A, 0x70, 0x3C, 0x0E, 0x60, 0x6C, 0x0E, 0x01, 0x70, 0x3C,
  0x0E, 0x50, 0x10, 0xEC, 0x05, 0x71, 0x03, 0xC0, 0xE5, 0x0A, 0xC0, 0xB7, 0x20, 0x3C, 0x0E, 0x40,
  0x5C, 0x0E, 0x01, 0x72, 0x03, 0xC0, 0xE3, 0x01, 0x0D, 0xC0, 0x67, 0x30, 0x3C, 0x0E, 0x30, 0x9C,
  0x0B, 0x74, 0x03, 0xC0, 0xE2, 0x03, 0xD0, 0x27, 0x40, 0x3C, 0x0E, 0x20, 0xDC, 0x07, 0x75, 0x03,
  0xC8, 0x1E, 0x08, 0xD0, 0x27, 0x50, 0x3C, 0x0E, 0x03, 0xE0, 0xA7, 0x50, 0x3D, 0x0D, 0xF0, 0x37,
  0x40, 0x3F, 0xE0, 0xB7, 0x40, 0x3F, 0x0E, 0x09, 0xD0, 0x57, 0x30, 0x3E, 0x82, 0xE3, 0x0D, 0xC0,
  0xD7, 0x30, 0x3E, 0x04, 0x20, 0x5D, 0x06, 0x72, 0x03, 0xD0, 0x44, 0x0B, 0xC0, 0xE7, 0x20, 0x3C,
  0x0E, 0x50, 0x3D, 0x08, 0x71, 0x03, 0xC0, 0xE6, 0x0A, 0xC0, 0xE0, 0x17, 0x03, 0xC0, 0xE6, 0x02,
  0xD0, 0x97, 0x03, 0xC0, 0xE7, 0x09, 0xD0, 0x26, 0x03, 0xC0, 0xE7, 0x01, 0x0E, 0xC0, 0xB6, 0x03,
  0xC0, 0xE7, 0x10, 0x7D, 0x04, 0x50, 0x3C, 0x0E, 0x72, 0x0E, 0xC0, 0xC5, 0x03, 0xC0, 0xE7, 0x20,
  0x6D, 0x05, 0x40, 0x3C, 0x0E, 0x73, 0x0D, 0xC0, 0xD4, 0x03, 0xC0, 0xE7, 0x30, 0x4D, 0x07, 0x30,
  0x3C, 0x0E, 0x74, 0x0B, 0xC0, 0xE0, 0x12, 0x03, 0xC0, 0xE7, 0x40, 0x3D, 0x09, 0x20, 0x3C, 0x0E,
  0x75, 0x0A, 0xD8, 0x12, 0x03, 0xC0, 0xE7, 0x50, 0x2D, 0x81, 0xA0, 0x3C, 0x0E, 0x76, 0x09, 0xD0,
  0x03, 0xC0, 0xE7, 0x60, 0x10, 0xEC, 0x0C, 0x80, 0x9A, 0x40, 0x0B, 0xC0, 0x67, 0x76, 0x0D, 0xC0,
  0x27, 0x75, 0x01, 0xC0, 0xC7, 0x76, 0x04, 0xC0, 0x67, 0x76, 0x07, 0xB0, 0xE7, 0x77, 0x0B, 0xB0,
  0x87, 0x77, 0x0E, 0xA0, 0xE0, 0x17, 0x76, 0x03, 0xB0, 0x87, 0x77, 0x07, 0xA0, 0xE0, 0x17, 0x77,
  0x0B, 0xA0, 0x57, 0x70,
  // "ķ" (U+0137)
  0x0B, 0xC0, 0x37, 0x72, 0x0B, 0xC0, 0x37, 0x72, 0x0B, 0xC0, 0x37, 0x72, 0x0B, 0xC0, 0x37, 0x72,
  0x0B, 0xC0, 0x37, 0x72, 0x0B, 0xC0, 0x37, 0x72, 0x0B, 0xC0, 0x37, 0x72, 0x0B, 0xC0, 0x37, 0x72,
  0x0B, 0xC0, 0x37, 0x72, 0x0B, 0xC0, 0x37, 0x72, 0x0B, 0xC0, 0x37, 0x72, 0x0B, 0xC0, 0x37, 0x72,
  0x0B, 0xC0, 0x37, 0x72, 0x0B, 0xC0, 0x37, 0x72, 0x0B, 0xC0, 0x37, 0x20, 0x7C, 0x81, 0xE1, 0xBC,
  0x03, 0x71, 0x03, 0xD8, 0x14, 0x0B, 0xC0, 0x37, 0x10, 0xDC, 0x08, 0x20, 0xBC, 0x03, 0x70, 0x9C,
  0x0C, 0x30, 0xBC, 0x03, 0x60, 0x4C, 0x0E, 0x02, 0x30, 0xBC, 0x03, 0x50, 0x10, 0xDC, 0x05, 0x40,
  0xBC, 0x03, 0x50, 0xAC, 0x09, 0x50, 0xBC, 0x03, 0x40, 0x5C, 0x0D, 0x60, 0xBC, 0x03, 0x30, 0x10,
  0xEC, 0x03, 0x60, 0xBC, 0x03, 0x30, 0xBC, 0x06, 0x70, 0xBC, 0x03, 0x20, 0x7C, 0x0A, 0x71, 0x0B,
  0xC8, 0x12, 0x02, 0xC0, 0xD0, 0x17, 0x10, 0xBC, 0x81, 0x20, 0xCC, 0x04, 0x72, 0x0B, 0xC0, 0x10,
  0x8D, 0x05, 0x72, 0x0B, 0xC0, 0x3E, 0x0D, 0x72, 0x0B, 0xC0, 0xCF, 0x06, 0x71, 0x0B, 0xF0, 0xDC,
  0x0E, 0x71, 0x0B, 0xE8, 0x1B, 0x0D, 0xC0, 0x77, 0x0B, 0xD0, 0xC2, 0x05, 0xC0, 0xE7, 0x0B, 0xC0,
  0xD0, 0x13, 0x0D, 0xC0, 0x76, 0x0B, 0xC0, 0x44, 0x05, 0xC0, 0xE0, 0x15, 0x0B, 0xC0, 0x35, 0x0D,
  0xC0, 0x85, 0x0B, 0xC0, 0x35, 0x05, 0xD0, 0x14, 0x0B, 0xC0, 0x36, 0x0D, 0xC0, 0x94, 0x0B, 0xC0,
  0x36, 0x05, 0xD0, 0x23, 0x0B, 0xC0, 0x37, 0x0C, 0xC0, 0xA3, 0x0B, 0xC0, 0x37, 0x05, 0xD0, 0x22,
  0x0B, 0xC0, 0x37, 0x10, 0xCC, 0x0A, 0x20, 0xBC, 0x03, 0x71, 0x04, 0xD8, 0x13, 0x0B, 0xC0, 0x37,
  0x20, 0xCC, 0x81, 0xB0, 0xBC, 0x03, 0x72, 0x04, 0xD0, 0x40, 0xBC, 0x03, 0x73, 0x0C, 0xC0, 0xC8,
  0x09, 0x86, 0x00, 0xBC, 0x06, 0x77, 0x20, 0xDC, 0x02, 0x77, 0x10, 0x1C, 0x0C, 0x77, 0x20, 0x4C,
  0x06, 0x77, 0x20, 0x7B, 0x0E, 0x77, 0x30, 0xBB, 0x08, 0x77, 0x30, 0xEA, 0x0E, 0x01, 0x77, 0x20,
  0x3B, 0x08, 0x77, 0x30, 0x7A, 0x0E, 0x01, 0x77, 0x30, 0xBA, 0x05, 0x75,
  // "ĸ" (U+0138)
  0x0B, 0xC0, 0x57, 0x20, 0x8C, 0x81, 0xE1, 0xBC, 0x05, 0x71, 0x03, 0xD8, 0x14, 0x0B, 0xC0, 0x57,
  0x10, 0xDC, 0x09, 0x20, 0xBC, 0x05, 0x70, 0x9C, 0x0D, 0x30, 0xBC, 0x05, 0x60, 0x4D, 0x03, 0x30,
  0xBC, 0x05, 0x60, 0xDC, 0x07, 0x40, 0xBC, 0x05, 0x50, 0x9C, 0x0C, 0x50, 0xBC, 0x05, 0x40, 0x4C,
  0x0E, 0x02, 0x50, 0xBC, 0x05, 0x30, 0x10, 0xEC, 0x05, 0x60, 0xBC, 0x05, 0x30, 0xAC, 0x0A, 0x70,
  0xBC, 0x04, 0x20, 0x5C, 0x0D, 0x01, 0x70, 0xBC, 0x82, 0x40, 0x1E, 0xC0, 0x47, 0x10, 0xBC, 0x81,
  0x30, 0xBC, 0x08, 0x72, 0x0B, 0xC0, 0x20, 0x5D, 0x08, 0x72, 0x0B, 0xC0, 0x20, 0xDE, 0x01, 0x71,
  0x0B, 0xC0, 0x9F, 0x09, 0x71, 0x0B, 0xF0, 0xED, 0x01, 0x70, 0xBE, 0x81, 0xE2, 0xBC, 0x09, 0x70,
  0xBD, 0x82, 0xE2, 0x03, 0xD0, 0x26, 0x0B, 0xC0, 0xE0, 0x33, 0x0B, 0xC0, 0x96, 0x0B, 0xC0, 0x64,
  0x03, 0xD0, 0x25, 0x0B, 0xC0, 0x55, 0x0B, 0xC0, 0xA5, 0x0B, 0xC0, 0x55, 0x03, 0xD0, 0x24, 0x0B,
  0xC0, 0x56, 0x0B, 0xC0, 0xA4, 0x0B, 0xC0, 0x56, 0x03, 0xD0, 0x33, 0x0B, 0xC0, 0x57, 0x0B, 0xC0,
  0xB3, 0x0B, 0xC0, 0x57, 0x03, 0xD0, 0x32, 0x0B, 0xC0, 0x57, 0x10, 0xBC, 0x0B, 0x20, 0xBC, 0x05,
  0x71, 0x03, 0xD8, 0x13, 0x0B, 0xC0, 0x57, 0x20, 0xBC, 0x81, 0xB0, 0xBC, 0x05, 0x72, 0x03, 0xD0,
  0x40, 0xBC, 0x05, 0x73, 0x0B, 0xC0, 0xC0,
  // "Ĺ" (U+0139)
  0x50, 0x28, 0x01, 0x70, 0x67, 0x60, 0xAD, 0x07, 0x75, 0x03, 0xD0, 0xC7, 0x60, 0xCC, 0x0E, 0x01,
  0x75, 0x06, 0xC0, 0xE0, 0x37, 0x50, 0x10, 0xEC, 0x04, 0x76, 0x0A, 0xC0, 0x57, 0x60, 0x5C, 0x05,
  0x76, 0x01, 0x0E, 0xB0, 0x57, 0x70, 0x8A, 0x0E, 0x04, 0x80, 0x9D, 0x70, 0x03, 0xC0, 0xE7, 0x70,
  0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E,
  0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03,
  0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7,
  0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C,
  0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77,
  0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0,
  0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70,
  0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E,
  0x77, 0x03, 0xD8, 0x09, 0x15, 0x04, 0x03, 0xFF, 0xC0, 0xD0, 0x3F, 0xFC, 0x0D, 0x03, 0xFF, 0xC0,
  0xD0, 0x3F, 0xFC, 0x0D,
  // "ĺ" (U+013A)
  0x50, 0x28, 0x01, 0x70, 0x65, 0x0A, 0xD0, 0x74, 0x03, 0xD0, 0xC5, 0x0C, 0xC0, 0xE0, 0x14, 0x06,
  0xC0, 0xE0, 0x34, 0x01, 0x0E, 0xC0, 0x45, 0x0A, 0xC0, 0x55, 0x05, 0xC0, 0x55, 0x01, 0x0E, 0xB0,
  0x56, 0x08, 0xA0, 0xE0, 0x48, 0x0E, 0x40, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36,
  0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B,
  0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0,
  0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36,
  0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B,
  0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0,
  0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36,
  0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B,
  0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0, 0x36, 0x0B, 0xC0,
  0x35,
  // "Ļ" (U+013B)
  0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0,
  0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70,
  0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E,
  0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03,
  0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7,
  0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C,
  0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77,
  0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0,
  0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xD8, 0x09, 0x15, 0x04, 0x03, 0xFF, 0xC0, 0xD0, 0x3F, 0xFC,
  0x0D, 0x03, 0xFF, 0xC0, 0xD0, 0x3F, 0xFC, 0x0D, 0x80, 0x98, 0x00, 0x0B, 0xC0, 0x67, 0x70, 0xDC,
  0x02, 0x76, 0x01, 0xC0, 0xC7, 0x70, 0x4C, 0x06, 0x77, 0x07, 0xB0, 0xE7, 0x71, 0x0B, 0xB0, 0x87,
  0x71, 0x0E, 0xA0, 0xE0, 0x17, 0x70, 0x3B, 0x08, 0x77, 0x10, 0x7A, 0x0E, 0x01, 0x77, 0x10, 0xBA,
  0x05, 0x73,
  // "ļ" (U+013C)
  0x10, 0xBC, 0x03, 0x20, 0xBC, 0x03, 0x20, 0xBC, 0x03, 0x20, 0xBC, 0x03, 0x20, 0xBC, 0x03, 0x20,
  0xBC, 0x03, 0x20, 0xBC, 0x03, 0x20, 0xBC, 0x03, 0x20, 0xBC, 0x03, 0x20, 0xBC, 0x03, 0x20, 0xBC,
  0x03, 0x20, 0xBC, 0x03, 0x20, 0xBC, 0x03, 0x20, 0xBC, 0x03, 0x20, 0xBC, 0x03, 0x20, 0xBC, 0x03,
  0x20, 0xBC, 0x03, 0x20, 0xBC, 0x03, 0x20, 0xBC, 0x03, 0x20, 0xBC, 0x03, 0x20, 0xBC, 0x03, 0x20,
  0xBC, 0x03, 0x20, 0xBC, 0x03, 0x20, 0xBC, 0x03, 0x20, 0xBC, 0x03, 0x20, 0xBC, 0x03, 0x20, 0xBC,
  0x03, 0x20, 0xBC, 0x03, 0x20, 0xBC, 0x03, 0x20, 0xBC, 0x03, 0x20, 0xBC, 0x03, 0x20, 0xBC, 0x03,
  0x20, 0xBC, 0x03, 0x20, 0xBC, 0x03, 0x20, 0xBC, 0x03, 0x20, 0xBC, 0x03, 0x20, 0xBC, 0x03, 0x20,
  0xBC, 0x03, 0x20, 0xBC, 0x03, 0x20, 0xBC, 0x03, 0x20, 0xBC, 0x03, 0x20, 0xBC, 0x03, 0x20, 0xBC,
  0x03, 0x20, 0xBC, 0x03, 0x20, 0xBC, 0x03, 0x20, 0xBC, 0x03, 0x77, 0x76, 0x0B, 0xC0, 0x62, 0x0D,
  0xC8, 0x12, 0x01, 0xC0, 0xC2, 0x04, 0xC0, 0x62, 0x07, 0xB0, 0xE3, 0x0B, 0xB0, 0x83, 0x0E, 0xA0,
  0xE0, 0x12, 0x03, 0xB0, 0x83, 0x07, 0xA0, 0xE0, 0x13, 0x0B, 0xA0, 0x54,
  // "Ľ" (U+013D)
  0x03, 0xC0, 0xE7, 0x20, 0xBC, 0x06, 0x03, 0xC0, 0xE7, 0x20, 0xDC, 0x00, 0x3C, 0x0E, 0x72, 0x0E,
  0xB8, 0x1D, 0x03, 0xC0, 0xE7, 0x10, 0x1C, 0x81, 0x80, 0x3C, 0x0E, 0x71, 0x04, 0xC8, 0x12, 0x03,
  0xC0, 0xE7, 0x10, 0x6B, 0x0B, 0x20, 0x3C, 0x0E, 0x71, 0x09, 0xB0, 0x52, 0x03, 0xC0, 0xE7, 0x10,
  0xCA, 0x0D, 0x30, 0x3C, 0x0E, 0x71, 0xB0, 0x63, 0x03, 0xC0, 0xE7, 0x02, 0xA0, 0xC4, 0x03, 0xC0,
  0xE7, 0x71, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0,
  0xE7, 0x71, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0,
  0xE7, 0x71, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0,
  0xE7, 0x71, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0,
  0xE7, 0x71, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0,
  0xE7, 0x71, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0,
  0xE7, 0x71, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xC0, 0xE7, 0x71, 0x03, 0xD8,
  0x09, 0x15, 0x81, 0x40, 0x3F, 0xFC, 0x81, 0xD0, 0x3F, 0xFC, 0x81, 0xD0, 0x3F, 0xFC, 0x81, 0xD0,
  0x3F, 0xFC, 0x0D, 0x10,
  // "ľ" (U+013E)
  0x0B, 0xC0, 0x33, 0x0B, 0xC0, 0x60, 0xBC, 0x03, 0x30, 0xDC, 0x03, 0x0B, 0xC0, 0x33, 0x0E, 0xB8,
  0x1D, 0x0B, 0xC0, 0x32, 0x01, 0xC8, 0x18, 0x0B, 0xC0, 0x32, 0x04, 0xC8, 0x12, 0x0B, 0xC0, 0x32,
  0x06, 0xB0, 0xB2, 0x0B, 0xC0, 0x32, 0x09, 0xB0, 0x52, 0x0B, 0xC0, 0x32, 0x0C, 0xA0, 0xD3, 0x0B,
  0xC0, 0x32, 0xB0, 0x63, 0x0B, 0xC8, 0x13, 0x02, 0xA0, 0xC4, 0x0B, 0xC0, 0x37, 0x20, 0xBC, 0x03,
  0x72, 0x0B, 0xC0, 0x37, 0x20, 0xBC, 0x03, 0x72, 0x0B, 0xC0, 0x37, 0x20, 0xBC, 0x03, 0x72, 0x0B,
  0xC0, 0x37, 0x20, 0xBC, 0x03, 0x72, 0x0B, 0xC0, 0x37, 0x20, 0xBC, 0x03, 0x72, 0x0B, 0xC0, 0x37,
  0x20, 0xBC, 0x03, 0x72, 0x0B, 0xC0, 0x37, 0x20, 0xBC, 0x03, 0x72, 0x0B, 0xC0, 0x37, 0x20, 0xBC,
  0x03, 0x72, 0x0B, 0xC0, 0x37, 0x20, 0xBC, 0x03, 0x72, 0x0B, 0xC0, 0x37, 0x20, 0xBC, 0x03, 0x72,
  0x0B, 0xC0, 0x37, 0x20, 0xBC, 0x03, 0x72, 0x0B, 0xC0, 0x37, 0x20, 0xBC, 0x03, 0x72, 0x0B, 0xC0,
  0x37, 0x20, 0xBC, 0x03, 0x72, 0x0B, 0xC0, 0x37, 0x20, 0xBC, 0x03, 0x72, 0x0B, 0xC0, 0x37, 0x20,
  0xBC, 0x03, 0x72, 0x0B, 0xC0, 0x37, 0x20, 0xBC, 0x03, 0x72, 0x0B, 0xC0, 0x37, 0x20, 0xBC, 0x03,
  0x72, 0x0B, 0xC0, 0x37, 0x20, 0xBC, 0x03, 0x72,
  // "Ŀ" (U+013F)
  0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0,
  0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70,
  0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E,
  0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x83, 0x5D, 0xEB, 0x22, 0x03,
  0xC0, 0xE6, 0x02, 0xC0, 0xC2, 0x03, 0xC0, 0xE6, 0x07, 0xD8, 0x11, 0x03, 0xC0, 0xE6, 0x08, 0xD8,
  0x12, 0x03, 0xC0, 0xE6, 0x07, 0xD8, 0x11, 0x03, 0xC0, 0xE6, 0x02, 0xC0, 0xB2, 0x03, 0xC0, 0xE7,
  0x83, 0x4D, 0xEB, 0x12, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C,
  0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77,
  0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0,
  0xE7, 0x70, 0x3C, 0x0E, 0x77, 0x03, 0xC0, 0xE7, 0x70, 0x3D, 0x80, 0x91, 0x50, 0x40, 0x3F, 0xFC,
  0x0D, 0x03, 0xFF, 0xC0, 0xD0, 0x3F, 0xFC, 0x0D, 0x03, 0xFF, 0xC0, 0xD0,
  // "ŀ" (U+0140)
  0x0B, 0xC0, 0x37, 0x20, 0xBC, 0x03, 0x72, 0x0B, 0xC0, 0x37, 0x20, 0xBC, 0x03, 0x72, 0x0B, 0xC0,
  0x37, 0x20, 0xBC, 0x03, 0x72, 0x0B, 0xC0, 0x37, 0x20, 0xBC, 0x03, 0x72, 0x0B, 0xC0, 0x37, 0x20,
  0xBC, 0x03, 0x72, 0x0B, 0xC0, 0x37, 0x20, 0xBC, 0x03, 0x72, 0x0B, 0xC0, 0x37, 0x20, 0xBC, 0x03,
  0x72, 0x0B, 0xC0, 0x37, 0x20, 0xBC, 0x03, 0x72, 0x0B, 0xC0, 0x37, 0x20, 0xBC, 0x03, 0x72, 0x0B,
  0xC0, 0x33, 0x85, 0x5D, 0xEB, 0x20, 0xBC, 0x03, 0x20, 0x2C, 0x81, 0xC0, 0xBC, 0x03, 0x20, 0x7D,
  0x01, 0x0B, 0xC0, 0x32, 0x08, 0xD0, 0x20, 0xBC, 0x03, 0x20, 0x7D, 0x01, 0x0B, 0xC0, 0x32, 0x02,
  0xC8, 0x1B, 0x0B, 0xC0, 0x33, 0x85, 0x4D, 0xEB, 0x10, 0xBC, 0x03, 0x72, 0x0B, 0xC0, 0x37, 0x20,
  0xBC, 0x03, 0x72, 0x0B, 0xC0, 0x37, 0x20, 0xBC, 0x03, 0x72, 0x0B, 0xC0, 0x37, 0x20, 0xBC, 0x03,
  0x72, 0x0B, 0xC0, 0x37, 0x20, 0xBC, 0x03, 0x72, 0x0B, 0xC0, 0x37, 0x20, 0xBC, 0x03, 0x72, 0x0B,
  0xC0, 0x37, 0x20, 0xBC, 0x03, 0x72, 0x0B, 0xC0, 0x37, 0x20, 0xBC, 0x03, 0x72, 0x0B, 0xC0, 0x37,
  0x20, 0xBC, 0x03, 0x72, 0x0B, 0xC0, 0x37, 0x20, 0xBC, 0x03, 0x72, 0x0B, 0xC0, 0x37, 0x20, 0xBC,
  0x03, 0x72,
  // "Ł" (U+0141)
  0x50, 0xEC, 0x03, 0x77, 0x50, 0xEC, 0x03, 0x77, 0x50, 0xEC, 0x03, 0x77, 0x50, 0xEC, 0x03, 0x77,
  0x50, 0xEC, 0x03, 0x77, 0x50, 0xEC, 0x03, 0x77, 0x50, 0xEC, 0x03, 0x77, 0x50, 0xEC, 0x03, 0x77,
  0x50, 0xEC, 0x03, 0x77, 0x50, 0xEC, 0x03, 0x77, 0x50, 0xEC, 0x03, 0x77, 0x50, 0xEC, 0x03, 0x77,
  0x50, 0xEC, 0x03, 0x77, 0x50, 0xEC, 0x03, 0x77, 0x50, 0xEC, 0x03, 0x77, 0x50, 0xEC, 0x03, 0x77,
  0x50, 0xEC, 0x03, 0x48, 0x11, 0xAA, 0x75, 0x0E, 0xC0, 0x33, 0x06, 0x0E, 0xA0, 0x57, 0x40, 0xEC,
  0x82, 0x30, 0x3C, 0xC0, 0xE0, 0x17, 0x30, 0xEC, 0x04, 0x09, 0xE0, 0xD0, 0x37, 0x30, 0xEF, 0xC0,
  0x87, 0x50, 0xEF, 0xA0, 0xC0, 0x37, 0x60, 0xEF, 0x0E, 0x07, 0x77, 0x01, 0xF0, 0xB0, 0x17, 0x70,
  0x60, 0xED, 0x0E, 0x05, 0x77, 0x01, 0x0B, 0xF0, 0x37, 0x70, 0x60, 0xEF, 0x90, 0x37, 0x70, 0xAF,
  0xA0, 0x37, 0x70, 0x10, 0xEA, 0x0D, 0xD0, 0x37, 0x71, 0x83, 0x4F, 0x80, 0xEC, 0x03, 0x77, 0x20,
  0x12, 0x0E, 0xC0, 0x37, 0x75, 0x0E, 0xC0, 0x37, 0x75, 0x0E, 0xC0, 0x37, 0x75, 0x0E, 0xC0, 0x37,
  0x75, 0x0E, 0xC0, 0x37, 0x75, 0x0E, 0xC0, 0x37, 0x75, 0x0E, 0xC0, 0x37, 0x75, 0x0E, 0xC0, 0x37,
  0x75, 0x0E, 0xC0, 0x78, 0x09, 0x15, 0x60, 0xEF, 0xFC, 0x01, 0x50, 0xEF, 0xFC, 0x01, 0x50, 0xEF,
  0xFC, 0x01, 0x50, 0xEF, 0xFC, 0x01,
  // "ł" (U+0142)
  0x50, 0x8C, 0x07, 0x74, 0x08, 0xC0, 0x77, 0x40, 0x8C, 0x07, 0x74, 0x08, 0xC0, 0x77, 0x40, 0x8C,
  0x07, 0x74, 0x08, 0xC0, 0x77, 0x40, 0x8C, 0x07, 0x74, 0x08, 0xC0, 0x77, 0x40, 0x8C, 0x07, 0x74,
  0x08, 0xC0, 0x77, 0x40, 0x8C, 0x07, 0x74, 0x08, 0xC0, 0x77, 0x40, 0x8C, 0x07, 0x74, 0x08, 0xC0,
  0x77, 0x40, 0x8C, 0x07, 0x74, 0x08, 0xC0, 0x77, 0x40, 0x8C, 0x07, 0x74, 0x08, 0xC0, 0x72, 0x09,
  0x03, 0x70, 0x8C, 0x83, 0x72, 0xCF, 0xD7, 0x08, 0xC0, 0xB0, 0xEB, 0x09, 0x60, 0x8F, 0xA0, 0xE0,
  0x15, 0x08, 0xF9, 0x0B, 0x01, 0x60, 0x8F, 0x07, 0x70, 0x20, 0xDD, 0x0D, 0x03, 0x70, 0x60, 0xED,
  0x0B, 0x01, 0x70, 0xAF, 0x07, 0x60, 0x30, 0xDF, 0x90, 0x76, 0x0B, 0xFA, 0x07, 0x60, 0x20, 0xEA,
  0x0D, 0x0B, 0xC0, 0x77, 0x83, 0x6F, 0x90, 0x8C, 0x07, 0x71, 0x03, 0x20, 0x8C, 0x07, 0x74, 0x08,
  0xC0, 0x77, 0x40, 0x8C, 0x07, 0x74, 0x08, 0xC0, 0x77, 0x40, 0x8C, 0x07, 0x74, 0x08, 0xC0, 0x77,
  0x40, 0x8C, 0x07, 0x74, 0x08, 0xC0, 0x77, 0x40, 0x8C, 0x07, 0x74, 0x08, 0xC0, 0x77, 0x40, 0x8C,
  0x07, 0x74, 0x08, 0xC0, 0x77, 0x40, 0x8C, 0x07, 0x74, 0x08, 0xC0, 0x77, 0x40, 0x8C, 0x07, 0x74,
  0x08, 0xC0, 0x76,
  // "Ń" (U+0143)
  0x77, 0x20, 0x28, 0x01, 0x70, 0x67, 0x77, 0x10, 0xAD, 0x07, 0x77, 0x70, 0x3D, 0x0C, 0x77, 0x71,
  0x0C, 0xC0, 0xE0, 0x17, 0x77, 0x06, 0xC0, 0xE0, 0x37, 0x77, 0x01, 0x0E, 0xC0, 0x47, 0x77, 0x10,
  0xAC, 0x05, 0x77, 0x71, 0x05, 0xC0, 0x57, 0x77, 0x10, 0x10, 0xEB, 0x05, 0x77, 0x72, 0x08, 0xA0,
  0xE0, 0x48, 0x0A, 0xB2, 0x00, 0x3E, 0x03, 0x77, 0x2C, 0x0C, 0x03, 0xE0, 0xB7, 0x72, 0xC0, 0xC0,
  0x3F, 0x03, 0x77, 0x1C, 0x0C, 0x03, 0xF0, 0xA7, 0x71, 0xC0, 0xC0, 0x3F, 0x90, 0x27, 0x7C, 0x0C,
  0x03, 0xF9, 0x0A, 0x77, 0xC0, 0xC0, 0x3F, 0xA0, 0x27, 0x6C, 0x0C, 0x03, 0xFA, 0x0A, 0x76, 0xC0,
  0xC0, 0x3C, 0x0A, 0xD0, 0x27, 0x5C, 0x0C, 0x03, 0xC0, 0x50, 0xDC, 0x09, 0x75, 0xC0, 0xC0, 0x3C,
  0x05, 0x06, 0xD0, 0x27, 0x4C, 0x0C, 0x03, 0xC8, 0x16, 0x0D, 0xC0, 0x97, 0x4C, 0x0C, 0x03, 0xC8,
  0x17, 0x06, 0xD0, 0x17, 0x3C, 0x0C, 0x03, 0xC0, 0x82, 0x0D, 0xC0, 0x97, 0x3C, 0x0C, 0x03, 0xC0,
  0x82, 0x06, 0xD0, 0x17, 0x2C, 0x0C, 0x03, 0xC0, 0x93, 0x0E, 0xC0, 0x87, 0x2C, 0x0C, 0x03, 0xC0,
  0x93, 0x07, 0xC0, 0xE0, 0x17, 0x1C, 0x0C, 0x03, 0xC0, 0xA4, 0x0E, 0xC0, 0x87, 0x1C, 0x0C, 0x03,
  0xC0, 0xA4, 0x07, 0xC0, 0xE0, 0x17, 0xC0, 0xC0, 0x3C, 0x0A, 0x50, 0xEC, 0x08, 0x7C, 0x0C, 0x03,
  0xC0, 0xA5, 0x07, 0xC0, 0xE0, 0x16, 0xC0, 0xC0, 0x3C, 0x0A, 0x60, 0xEC, 0x07, 0x6C, 0x0C, 0x03,
  0xC0, 0xA6, 0x07, 0xC0, 0xE6, 0xC0, 0xC0, 0x3C, 0x0A, 0x70, 0xEC, 0x07, 0x5C, 0x0C, 0x03, 0xC0,
  0xA7, 0x07, 0xC0, 0xE5, 0xC0, 0xC0, 0x3C, 0x0A, 0x70, 0x10, 0xEC, 0x07, 0x4C, 0x0C, 0x03, 0xC0,
  0xA7, 0x10, 0x7C, 0x0E, 0x4C, 0x0C, 0x03, 0xC0, 0xA7, 0x10, 0x10, 0xEC, 0x06, 0x3C, 0x0C, 0x03,
  0xC0, 0xA7, 0x20, 0x8C, 0x0D, 0x3C, 0x0C, 0x03, 0xC0, 0xA7, 0x20, 0x10, 0xEC, 0x06, 0x2C, 0x0C,
  0x03, 0xC0, 0xA7, 0x30, 0x8C, 0x0D, 0x20, 0xEB, 0x0C, 0x03, 0xC0, 0xA7, 0x30, 0x10, 0xEC, 0x81,
  0x60, 0xDB, 0x0C, 0x03, 0xC0, 0xA7, 0x40, 0x8C, 0x81, 0xD0, 0xDB, 0x0C, 0x03, 0xC0, 0xA7, 0x40,
  0x10, 0xEC, 0x05, 0x0C, 0xB0, 0xC0, 0x3C, 0x0A, 0x75, 0x08, 0xC0, 0xD0, 0xCB, 0x0C, 0x03, 0xC0,
  0xA7, 0x50, 0x1F, 0xA0, 0xC0, 0x3C, 0x0A, 0x76, 0x08, 0xF9, 0x0C, 0x03, 0xC0, 0xA7, 0x60, 0x1F,
  0x90, 0xC0, 0x3C, 0x0A, 0x77, 0x09, 0xF0, 0xC0, 0x3C, 0x0A, 0x77, 0x01, 0xF0, 0xC0, 0x3C, 0x0A,
  0x77, 0x10, 0x9E, 0x0C, 0x03, 0xC0, 0xA7, 0x71, 0x01, 0xE0, 0xC0, 0x3C, 0x0A, 0x77, 0x20, 0x9D,
  0x0C,
  // "ń" (U+0144)
  0x76, 0x02, 0x80, 0x17, 0x06, 0x77, 0x20, 0xAD, 0x07, 0x77, 0x10, 0x3D, 0x0C, 0x77, 0x20, 0xCC,
  0x0E, 0x01, 0x77, 0x10, 0x6C, 0x0E, 0x03, 0x77, 0x10, 0x10, 0xEC, 0x04, 0x77, 0x20, 0xAC, 0x05,
  0x77, 0x20, 0x5C, 0x05, 0x77, 0x20, 0x10, 0xEB, 0x05, 0x77, 0x30, 0x8A, 0x0E, 0x04, 0x80, 0x9D,
  0x40, 0x84, 0x15, 0x77, 0x63, 0x70, 0xBB, 0x05, 0x30, 0x30, 0xBE, 0x81, 0xE9, 0x14, 0x0B, 0xB0,
  0x72, 0x07, 0xFB, 0x0E, 0x03, 0x30, 0xBB, 0x81, 0x90, 0x7F, 0xD0, 0xE0, 0x12, 0x0B, 0xB0, 0xB0,
  0x4D, 0x00, 0xDF, 0x0A, 0x20, 0xBB, 0x0E, 0x0D, 0xA0, 0xC0, 0x54, 0x05, 0x0E, 0xD8, 0x12, 0x0B,
  0xE0, 0xA7, 0x03, 0xD8, 0x18, 0x0B, 0xD0, 0xD7, 0x20, 0x9C, 0x81, 0xB0, 0xBD, 0x06, 0x72, 0x04,
  0xC8, 0x1E, 0x0B, 0xD0, 0x17, 0x3D, 0x10, 0xBC, 0x0C, 0x74, 0x0E, 0xC0, 0x10, 0xBC, 0x09, 0x74,
  0x0D, 0xC0, 0x20, 0xBC, 0x07, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x05, 0x74, 0x0C, 0xC0, 0x20, 0xBC,
  0x04, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x04, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0,
  0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74,
  0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC,
  0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0,
  0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74,
  0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC,
  0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0,
  0x20,
  // "Ņ" (U+0145)
  0x03, 0xE0, 0x37, 0x72, 0xC0, 0xC0, 0x3E, 0x0B, 0x77, 0x2C, 0x0C, 0x03, 0xF0, 0x37, 0x71, 0xC0,
  0xC0, 0x3F, 0x0A, 0x77, 0x1C, 0x0C, 0x03, 0xF9, 0x02, 0x77, 0xC0, 0xC0, 0x3F, 0x90, 0xA7, 0x7C,
  0x0C, 0x03, 0xFA, 0x02, 0x76, 0xC0, 0xC0, 0x3F, 0xA0, 0xA7, 0x6C, 0x0C, 0x03, 0xC0, 0xAD, 0x02,
  0x75, 0xC0, 0xC0, 0x3C, 0x05, 0x0D, 0xC0, 0x97, 0x5C, 0x0C, 0x03, 0xC0, 0x50, 0x6D, 0x02, 0x74,
  0xC0, 0xC0, 0x3C, 0x81, 0x60, 0xDC, 0x09, 0x74, 0xC0, 0xC0, 0x3C, 0x81, 0x70, 0x6D, 0x01, 0x73,
  0xC0, 0xC0, 0x3C, 0x08, 0x20, 0xDC, 0x09, 0x73, 0xC0, 0xC0, 0x3C, 0x08, 0x20, 0x6D, 0x01, 0x72,
  0xC0, 0xC0, 0x3C, 0x09, 0x30, 0xEC, 0x08, 0x72, 0xC0, 0xC0, 0x3C, 0x09, 0x30, 0x7C, 0x0E, 0x01,
  0x71, 0xC0, 0xC0, 0x3C, 0x0A, 0x40, 0xEC, 0x08, 0x71, 0xC0, 0xC0, 0x3C, 0x0A, 0x40, 0x7C, 0x0E,
  0x01, 0x7C, 0x0C, 0x03, 0xC0, 0xA5, 0x0E, 0xC0, 0x87, 0xC0, 0xC0, 0x3C, 0x0A, 0x50, 0x7C, 0x0E,
  0x01, 0x6C, 0x0C, 0x03, 0xC0, 0xA6, 0x0E, 0xC0, 0x76, 0xC0, 0xC0, 0x3C, 0x0A, 0x60, 0x7C, 0x0E,
  0x6C, 0x0C, 0x03, 0xC0, 0xA7, 0x0E, 0xC0, 0x75, 0xC0, 0xC0, 0x3C, 0x0A, 0x70, 0x7C, 0x0E, 0x5C,
  0x0C, 0x03, 0xC0, 0xA7, 0x01, 0x0E, 0xC0, 0x74, 0xC0, 0xC0, 0x3C, 0x0A, 0x71, 0x07, 0xC0, 0xE4,
  0xC0, 0xC0, 0x3C, 0x0A, 0x71, 0x01, 0x0E, 0xC0, 0x63, 0xC0, 0xC0, 0x3C, 0x0A, 0x72, 0x08, 0xC0,
  0xD3, 0xC0, 0xC0, 0x3C, 0x0A, 0x72, 0x01, 0x0E, 0xC0, 0x62, 0xC0, 0xC0, 0x3C, 0x0A, 0x73, 0x08,
  0xC0, 0xD2, 0x0E, 0xB0, 0xC0, 0x3C, 0x0A, 0x73, 0x01, 0x0E, 0xC8, 0x16, 0x0D, 0xB0, 0xC0, 0x3C,
  0x0A, 0x74, 0x08, 0xC8, 0x1D, 0x0D, 0xB0, 0xC0, 0x3C, 0x0A, 0x74, 0x01, 0x0E, 0xC0, 0x50, 0xCB,
  0x0C, 0x03, 0xC0, 0xA7, 0x50, 0x8C, 0x0D, 0x0C, 0xB0, 0xC0, 0x3C, 0x0A, 0x75, 0x01, 0xFA, 0x0C,
  0x03, 0xC0, 0xA7, 0x60, 0x8F, 0x90, 0xC0, 0x3C, 0x0A, 0x76, 0x01, 0xF9, 0x0C, 0x03, 0xC0, 0xA7,
  0x70, 0x9F, 0x0C, 0x03, 0xC0, 0xA7, 0x70, 0x1F, 0x0C, 0x03, 0xC0, 0xA7, 0x71, 0x09, 0xE0, 0xC0,
  0x3C, 0x0A, 0x77, 0x10, 0x1E, 0x0C, 0x03, 0xC0, 0xA7, 0x72, 0x09, 0xD0, 0xC8, 0x09, 0xC0, 0x00,
  0xBC, 0x06, 0x77, 0x72, 0x0D, 0xC0, 0x27, 0x77, 0x10, 0x1C, 0x0C, 0x77, 0x72, 0x04, 0xC0, 0x67,
  0x77, 0x20, 0x7B, 0x0E, 0x77, 0x73, 0x0B, 0xB0, 0x87, 0x77, 0x30, 0xEA, 0x0E, 0x01, 0x77, 0x72,
  0x03, 0xB0, 0x87, 0x77, 0x30, 0x7A, 0x0E, 0x01, 0x77, 0x73, 0x0B, 0xA0, 0x57, 0x70,
  // "ņ" (U+0146)
  0x73, 0x84, 0x15, 0x77, 0x63, 0x70, 0xBB, 0x05, 0x30, 0x30, 0xBE, 0x81, 0xE9, 0x14, 0x0B, 0xB0,
  0x72, 0x07, 0xFB, 0x0E, 0x03, 0x30, 0xBB, 0x81, 0x90, 0x7F, 0xD0, 0xE0, 0x12, 0x0B, 0xB0, 0xB0,
  0x4D, 0x00, 0xDF, 0x0A, 0x20, 0xBB, 0x0E, 0x0D, 0xA0, 0xC0, 0x54, 0x05, 0x0E, 0xD8, 0x12, 0x0B,
  0xE0, 0xA7, 0x03, 0xD8, 0x18, 0x0B, 0xD0, 0xD7, 0x20, 0x9C, 0x81, 0xB0, 0xBD, 0x06, 0x72, 0x04,
  0xC8, 0x1E, 0x0B, 0xD0, 0x17, 0x3D, 0x10, 0xBC, 0x0C, 0x74, 0x0E, 0xC0, 0x10, 0xBC, 0x09, 0x74,
  0x0D, 0xC0, 0x20, 0xBC, 0x07, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x05, 0x74, 0x0C, 0xC0, 0x20, 0xBC,
  0x04, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x04, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0,
  0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74,
  0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC,
  0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0,
  0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74,
  0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC,
  0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0,
  0x28, 0x09, 0x92, 0x00, 0xBC, 0x06, 0x77, 0x30, 0xDC, 0x02, 0x77, 0x20, 0x1C, 0x0C, 0x77, 0x30,
  0x4C, 0x06, 0x77, 0x30, 0x7B, 0x0E, 0x77, 0x40, 0xBB, 0x08, 0x77, 0x40, 0xEA, 0x0E, 0x01, 0x77,
  0x30, 0x3B, 0x08, 0x77, 0x40, 0x7A, 0x0E, 0x01, 0x77, 0x40, 0xBA, 0x05, 0x75,
  // "Ň" (U+0147)
  0x68, 0x24, 0x77, 0x57, 0x38, 0x26, 0x77, 0x37, 0x40, 0x5B, 0x08, 0x71, 0x09, 0xB0, 0x37, 0x50,
  0x8B, 0x08, 0x60, 0xAB, 0x06, 0x77, 0x0C, 0xB0, 0x84, 0x0A, 0xB0, 0x97, 0x71, 0x02, 0x0E, 0xB0,
  0x72, 0x0A, 0xB0, 0xD7, 0x73, 0x05, 0xC0, 0x60, 0x9C, 0x02, 0x77, 0x40, 0xAF, 0x90, 0x77, 0x75,
  0x01, 0x0E, 0xE0, 0xB7, 0x77, 0x06, 0xE0, 0x27, 0x77, 0x10, 0xCC, 0x09, 0x80, 0xAB, 0x00, 0x03,
  0xE0, 0x37, 0x72, 0xC0, 0xC0, 0x3E, 0x0B, 0x77, 0x2C, 0x0C, 0x03, 0xF0, 0x37, 0x71, 0xC0, 0xC0,
  0x3F, 0x0A, 0x77, 0x1C, 0x0C, 0x03, 0xF9, 0x02, 0x77, 0xC0, 0xC0, 0x3F, 0x90, 0xA7, 0x7C, 0x0C,
  0x03, 0xFA, 0x02, 0x76, 0xC0, 0xC0, 0x3F, 0xA0, 0xA7, 0x6C, 0x0C, 0x03, 0xC0, 0xAD, 0x02, 0x75,
  0xC0, 0xC0, 0x3C, 0x05, 0x0D, 0xC0, 0x97, 0x5C, 0x0C, 0x03, 0xC0, 0x50, 0x6D, 0x02, 0x74, 0xC0,
  0xC0, 0x3C, 0x81, 0x60, 0xDC, 0x09, 0x74, 0xC0, 0xC0, 0x3C, 0x81, 0x70, 0x6D, 0x01, 0x73, 0xC0,
  0xC0, 0x3C, 0x08, 0x20, 0xDC, 0x09, 0x73, 0xC0, 0xC0, 0x3C, 0x08, 0x20, 0x6D, 0x01, 0x72, 0xC0,
  0xC0, 0x3C, 0x09, 0x30, 0xEC, 0x08, 0x72, 0xC0, 0xC0, 0x3C, 0x09, 0x30, 0x7C, 0x0E, 0x01, 0x71,
  0xC0, 0xC0, 0x3C, 0x0A, 0x40, 0xEC, 0x08, 0x71, 0xC0, 0xC0, 0x3C, 0x0A, 0x40, 0x7C, 0x0E, 0x01,
  0x7C, 0x0C, 0x03, 0xC0, 0xA5, 0x0E, 0xC0, 0x87, 0xC0, 0xC0, 0x3C, 0x0A, 0x50, 0x7C, 0x0E, 0x01,
  0x6C, 0x0C, 0x03, 0xC0, 0xA6, 0x0E, 0xC0, 0x76, 0xC0, 0xC0, 0x3C, 0x0A, 0x60, 0x7C, 0x0E, 0x6C,
  0x0C, 0x03, 0xC0, 0xA7, 0x0E, 0xC0, 0x75, 0xC0, 0xC0, 0x3C, 0x0A, 0x70, 0x7C, 0x0E, 0x5C, 0x0C,
  0x03, 0xC0, 0xA7, 0x01, 0x0E, 0xC0, 0x74, 0xC0, 0xC0, 0x3C, 0x0A, 0x71, 0x07, 0xC0, 0xE4, 0xC0,
  0xC0, 0x3C, 0x0A, 0x71, 0x01, 0x0E, 0xC0, 0x63, 0xC0, 0xC0, 0x3C, 0x0A, 0x72, 0x08, 0xC0, 0xD3,
  0xC0, 0xC0, 0x3C, 0x0A, 0x72, 0x01, 0x0E, 0xC0, 0x62, 0xC0, 0xC0, 0x3C, 0x0A, 0x73, 0x08, 0xC0,
  0xD2, 0x0E, 0xB0, 0xC0, 0x3C, 0x0A, 0x73, 0x01, 0x0E, 0xC8, 0x16, 0x0D, 0xB0, 0xC0, 0x3C, 0x0A,
  0x74, 0x08, 0xC8, 0x1D, 0x0D, 0xB0, 0xC0, 0x3C, 0x0A, 0x74, 0x01, 0x0E, 0xC0, 0x50, 0xCB, 0x0C,
  0x03, 0xC0, 0xA7, 0x50, 0x8C, 0x0D, 0x0C, 0xB0, 0xC0, 0x3C, 0x0A, 0x75, 0x01, 0xFA, 0x0C, 0x03,
  0xC0, 0xA7, 0x60, 0x8F, 0x90, 0xC0, 0x3C, 0x0A, 0x76, 0x01, 0xF9, 0x0C, 0x03, 0xC0, 0xA7, 0x70,
  0x9F, 0x0C, 0x03, 0xC0, 0xA7, 0x70, 0x1F, 0x0C, 0x03, 0xC0, 0xA7, 0x71, 0x09, 0xE0, 0xC0, 0x3C,
  0x0A, 0x77, 0x10, 0x1E, 0x0C, 0x03, 0xC0, 0xA7, 0x72, 0x09, 0xD0, 0xC0,
  // "ň" (U+0148)
  0x38, 0x24, 0x77, 0x57, 0x38, 0x26, 0x77, 0x35, 0x05, 0xB0, 0x87, 0x10, 0x9B, 0x03, 0x60, 0x8B,
  0x08, 0x60, 0xAB, 0x06, 0x71, 0x0C, 0xB0, 0x84, 0x0A, 0xB0, 0x97, 0x20, 0x20, 0xEB, 0x07, 0x20,
  0xAB, 0x0D, 0x74, 0x05, 0xC0, 0x60, 0x9C, 0x02, 0x75, 0x0A, 0xF9, 0x07, 0x76, 0x01, 0x0E, 0xE0,
  0xB7, 0x71, 0x06, 0xE0, 0x27, 0x72, 0x0C, 0xC0, 0x98, 0x09, 0xD2, 0x08, 0x41, 0x57, 0x76, 0x37,
  0x0B, 0xB0, 0x53, 0x03, 0x0B, 0xE8, 0x1E, 0x91, 0x40, 0xBB, 0x07, 0x20, 0x7F, 0xB0, 0xE0, 0x33,
  0x0B, 0xB8, 0x19, 0x07, 0xFD, 0x0E, 0x01, 0x20, 0xBB, 0x0B, 0x04, 0xD0, 0x0D, 0xF0, 0xA2, 0x0B,
  0xB0, 0xE0, 0xDA, 0x0C, 0x05, 0x40, 0x50, 0xED, 0x81, 0x20, 0xBE, 0x0A, 0x70, 0x3D, 0x81, 0x80,
  0xBD, 0x0D, 0x72, 0x09, 0xC8, 0x1B, 0x0B, 0xD0, 0x67, 0x20, 0x4C, 0x81, 0xE0, 0xBD, 0x01, 0x73,
  0xD1, 0x0B, 0xC0, 0xC7, 0x40, 0xEC, 0x01, 0x0B, 0xC0, 0x97, 0x40, 0xDC, 0x02, 0x0B, 0xC0, 0x77,
  0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x57, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x47, 0x40, 0xCC, 0x02, 0x0B,
  0xC0, 0x47, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xCC,
  0x02, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x37,
  0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x0B,
  0xC0, 0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xCC,
  0x02, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x37,
  0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x0B,
  0xC0, 0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02,
  // "ŉ" (U+0149)
  0x3D, 0x09, 0x77, 0x73, 0x01, 0xD0, 0x87, 0x77, 0x30, 0x4D, 0x04, 0x77, 0x73, 0x06, 0xD7, 0x77,
  0x40, 0x8C, 0x0B, 0x77, 0x74, 0x0B, 0xC0, 0x77, 0x77, 0x40, 0xDC, 0x02, 0x77, 0x73, 0x01, 0xC0,
  0xC7, 0x77, 0x40, 0x4C, 0x07, 0x77, 0x74, 0x07, 0xC0, 0x17, 0x77, 0x40, 0xAB, 0x0B, 0x75, 0x84,
  0x15, 0x77, 0x63, 0x71, 0x0D, 0xB0, 0x52, 0x0B, 0xB0, 0x53, 0x03, 0x0B, 0xE8, 0x1E, 0x91, 0x40,
  0x2B, 0x0E, 0x30, 0xBB, 0x07, 0x20, 0x7F, 0xB0, 0xE0, 0x33, 0x05, 0xB0, 0x93, 0x0B, 0xB8, 0x19,
  0x07, 0xFD, 0x0E, 0x01, 0x20, 0x9B, 0x03, 0x30, 0xBB, 0x0B, 0x04, 0xD0, 0x0D, 0xF0, 0xA7, 0x30,
  0xBB, 0x0E, 0x0D, 0xA0, 0xC0, 0x54, 0x05, 0x0E, 0xD0, 0x27, 0x20, 0xBE, 0x0A, 0x70, 0x3D, 0x08,
  0x72, 0x0B, 0xD0, 0xD7, 0x20, 0x9C, 0x0B, 0x72, 0x0B, 0xD0, 0x67, 0x20, 0x4C, 0x0E, 0x72, 0x0B,
  0xD0, 0x17, 0x3D, 0x72, 0x0B, 0xC0, 0xC7, 0x40, 0xEC, 0x01, 0x71, 0x0B, 0xC0, 0x97, 0x40, 0xDC,
  0x02, 0x71, 0x0B, 0xC0, 0x77, 0x40, 0xCC, 0x02, 0x71, 0x0B, 0xC0, 0x57, 0x40, 0xCC, 0x02, 0x71,
  0x0B, 0xC0, 0x47, 0x40, 0xCC, 0x02, 0x71, 0x0B, 0xC0, 0x47, 0x40, 0xCC, 0x02, 0x71, 0x0B, 0xC0,
  0x37, 0x40, 0xCC, 0x02, 0x71, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x71, 0x0B, 0xC0, 0x37, 0x40,
  0xCC, 0x02, 0x71, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x71, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02,
  0x71, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x71, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x71, 0x0B,
  0xC0, 0x37, 0x40, 0xCC, 0x02, 0x71, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x71, 0x0B, 0xC0, 0x37,
  0x40, 0xCC, 0x02, 0x71, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x71, 0x0B, 0xC0, 0x37, 0x40, 0xCC,
  0x02, 0x71, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x71, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x71,
  0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x71, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x71, 0x0B, 0xC0,
  0x37, 0x40, 0xCC, 0x02,
  // "Ŋ" (U+014A)
  0x03, 0xE0, 0x37, 0x72, 0xC0, 0xC0, 0x3E, 0x0B, 0x77, 0x2C, 0x0C, 0x03, 0xF0, 0x47, 0x71, 0xC0,
  0xC0, 0x3F, 0x0C, 0x77, 0x1C, 0x0C, 0x03, 0xF9, 0x04, 0x77, 0xC0, 0xC0, 0x3F, 0x90, 0xC7, 0x7C,
  0x0C, 0x03, 0xFA, 0x05, 0x76, 0xC0, 0xC0, 0x3F, 0xA0, 0xD7, 0x6C, 0x0C, 0x03, 0xC0, 0x7D, 0x05,
  0x75, 0xC0, 0xC0, 0x3C, 0x05, 0x0B, 0xC0, 0xD7, 0x5C, 0x0C, 0x03, 0xC0, 0x60, 0x2D, 0x06, 0x74,
  0xC0, 0xC0, 0x3C, 0x81, 0x70, 0xAC, 0x0D, 0x74, 0xC0, 0xC0, 0x3C, 0x81, 0x80, 0x2D, 0x06, 0x73,
  0xC0, 0xC0, 0x3C, 0x08, 0x20, 0x9C, 0x0E, 0x73, 0xC0, 0xC0, 0x3C, 0x09, 0x20, 0x10, 0xEC, 0x07,
  0x72, 0xC0, 0xC0, 0x3C, 0x09, 0x30, 0x8C, 0x0E, 0x72, 0xC0, 0xC0, 0x3C, 0x09, 0x30, 0x10, 0xEC,
  0x07, 0x71, 0xC0, 0xC0, 0x3C, 0x0A, 0x40, 0x7C, 0x0E, 0x01, 0x7C, 0x0C, 0x03, 0xC0, 0xA5, 0x0E,
  0xC0, 0x87, 0xC0, 0xC0, 0x3C, 0x0A, 0x50, 0x6C, 0x0E, 0x01, 0x6C, 0x0C, 0x03, 0xC0, 0xA6, 0x0D,
  0xC0, 0x86, 0xC0, 0xC0, 0x3C, 0x0A, 0x60, 0x5D, 0x01, 0x5C, 0x0C, 0x03, 0xC0, 0xA7, 0x0C, 0xC0,
  0x95, 0xC0, 0xC0, 0x3C, 0x0A, 0x70, 0x4D, 0x01, 0x4C, 0x0C, 0x03, 0xC0, 0xA7, 0x10, 0xCC, 0x09,
  0x4C, 0x0C, 0x03, 0xC0, 0xA7, 0x10, 0x4D, 0x02, 0x3C, 0x0C, 0x03, 0xC0, 0xA7, 0x20, 0xBC, 0x0A,
  0x3C, 0x0C, 0x03, 0xC0, 0xA7, 0x20, 0x3D, 0x02, 0x2C, 0x0C, 0x03, 0xC0, 0xA7, 0x30, 0xAC, 0x0A,
  0x20, 0xEB, 0x0C, 0x03, 0xC0, 0xA7, 0x30, 0x2D, 0x81, 0x30, 0xDB, 0x0C, 0x03, 0xC0, 0xA7, 0x40,
  0x9C, 0x81, 0xB0, 0xDB, 0x0C, 0x03, 0xC0, 0xA7, 0x40, 0x1D, 0x03, 0x0C, 0xB0, 0xC0, 0x3C, 0x0A,
  0x75, 0x08, 0xC0, 0x0B, 0xB0, 0xC0, 0x3C, 0x0A, 0x75, 0x01, 0x0E, 0xF9, 0x0C, 0x03, 0xC0, 0xA7,
  0x60, 0x7F, 0x90, 0xC0, 0x3C, 0x0A, 0x77, 0x0E, 0xF0, 0xC0, 0x3C, 0x0A, 0x77, 0x06, 0xF0, 0xC0,
  0x3C, 0x0A, 0x77, 0x10, 0xDE, 0x0C, 0x03, 0xC0, 0xA7, 0x71, 0x06, 0xE0, 0xC0, 0x3C, 0x0A, 0x77,
  0x20, 0xDD, 0x0C, 0x03, 0xC0, 0xA7, 0x72, 0x05, 0xD0, 0xC0, 0x3C, 0x0A, 0x77, 0x30, 0xCC, 0x0C,
  0x03, 0xC0, 0xA7, 0x73, 0x04, 0xC0, 0xC7, 0x77, 0x20, 0x1C, 0x0B, 0x77, 0x72, 0x02, 0xC0, 0xB7,
  0x77, 0x20, 0x4C, 0x09, 0x77, 0x72, 0x07, 0xC0, 0x77, 0x77, 0x20, 0xCC, 0x04, 0x77, 0x71, 0x06,
  0xC0, 0xE7, 0x72, 0x85, 0x25, 0x21, 0x02, 0x8D, 0x09, 0x77, 0x20, 0x4F, 0xB0, 0xE0, 0x17, 0x72,
  0x04, 0xFB, 0x06, 0x77, 0x30, 0x4F, 0xA0, 0x67, 0x74, 0x03, 0x0D, 0xD8, 0x1E, 0x92, 0x77, 0x78,
  0x32, 0x34, 0x42, 0x70,
  // "ŋ" (U+014B)
  0x73, 0x84, 0x15, 0x77, 0x54, 0x70, 0xBB, 0x05, 0x30, 0x30, 0xBE, 0x81, 0xE9, 0x14, 0x0B, 0xB0,
  0x72, 0x08, 0xFB, 0x0E, 0x02, 0x30, 0xBB, 0x81, 0x90, 0x8F, 0xD0, 0xE0, 0x12, 0x0B, 0xB0, 0xB0,
  0x4D, 0x00, 0xDF, 0x09, 0x20, 0xBB, 0x0E, 0x0D, 0xA0, 0xC0, 0x44, 0x06, 0x0E, 0xD8, 0x11, 0x0B,
  0xE0, 0x97, 0x03, 0xD8, 0x16, 0x0B, 0xD0, 0xD7, 0x20, 0x9C, 0x81, 0xA0, 0xBD, 0x05, 0x72, 0x04,
  0xC8, 0x1D, 0x0B, 0xD7, 0x4D, 0x10, 0xBC, 0x0B, 0x74, 0x0E, 0xC0, 0x10, 0xBC, 0x08, 0x74, 0x0D,
  0xC0, 0x10, 0xBC, 0x07, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x05, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x04,
  0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x04, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20,
  0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C,
  0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03,
  0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20,
  0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C,
  0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03,
  0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x20, 0xBC, 0x03, 0x74, 0x0C, 0xC0, 0x27,
  0x73, 0x0C, 0xC0, 0x27, 0x73, 0x0C, 0xC0, 0x27, 0x73, 0x0C, 0xC0, 0x27, 0x73, 0x0C, 0xC0, 0x27,
  0x73, 0x0C, 0xC0, 0x27, 0x73, 0x0D, 0xC0, 0x17, 0x73, 0x0E, 0xC7, 0x73, 0x02, 0xC0, 0xD7, 0x73,
  0x0A, 0xC0, 0xA7, 0x58, 0x34, 0x86, 0x5A, 0xD0, 0x57, 0x50, 0x5F, 0x90, 0xE7, 0x60, 0x5F, 0x90,
  0x57, 0x60, 0x5F, 0x07, 0x77, 0x86, 0x2A, 0xDE, 0xED, 0x92, 0x40,
  // "Ō" (U+014C)
  0x70, 0x38, 0x09, 0x25, 0x04, 0x77, 0x10, 0x9F, 0xF0, 0xE7, 0x71, 0x09, 0xFF, 0x0E, 0x77, 0x10,
  0x9F, 0xF0, 0xE7, 0x71, 0x09, 0xFF, 0x0E, 0x80, 0xA9, 0x40, 0x85, 0x35, 0x67, 0x65, 0x37, 0x77,
  0x05, 0x0B, 0xFA, 0x0B, 0x05, 0x77, 0x20, 0x40, 0xDF, 0xE0, 0xD0, 0x37, 0x60, 0x8F, 0xFB, 0x07,
  0x74, 0x09, 0xF9, 0x81, 0xED, 0xDF, 0x90, 0x87, 0x20, 0x7E, 0x81, 0xC5, 0x14, 0x04, 0x0A, 0xE0,
  0x57, 0x03, 0xE0, 0x77, 0x20, 0x40, 0xEC, 0x0E, 0x02, 0x60, 0xCD, 0x05, 0x74, 0x03, 0xD0, 0xB5,
  0x04, 0xD0, 0x97, 0x60, 0x6D, 0x04, 0x40, 0xBC, 0x0E, 0x77, 0x10, 0xCC, 0x0B, 0x30, 0x1D, 0x07,
  0x77, 0x10, 0x5D, 0x01, 0x20, 0x6D, 0x01, 0x77, 0x20, 0xEC, 0x07, 0x20, 0xBC, 0x0C, 0x77, 0x30,
  0x9C, 0x0B, 0x20, 0xEC, 0x07, 0x77, 0x30, 0x5D, 0x10, 0x2D, 0x04, 0x77, 0x30, 0x1D, 0x03, 0x05,
  0xD0, 0x17, 0x74, 0x0E, 0xC0, 0x60, 0x7C, 0x0E, 0x77, 0x50, 0xCC, 0x00, 0x9C, 0x0C, 0x77, 0x50,
  0xAC, 0x0B, 0x0A, 0xC0, 0xB7, 0x75, 0x09, 0xC0, 0xC0, 0xBC, 0x0A, 0x77, 0x50, 0x8C, 0x0E, 0x0C,
  0xC0, 0x97, 0x75, 0x07, 0xC0, 0xE0, 0xCC, 0x09, 0x77, 0x50, 0x7D, 0x0C, 0xC0, 0x97, 0x75, 0x06,
  0xD0, 0xCC, 0x09, 0x77, 0x50, 0x7D, 0x0B, 0xC0, 0xA7, 0x75, 0x07, 0xC0, 0xE0, 0xAC, 0x0A, 0x77,
  0x50, 0x8C, 0x0E, 0x09, 0xC0, 0xB7, 0x75, 0x09, 0xC0, 0xC0, 0x7C, 0x0D, 0x77, 0x50, 0xAC, 0x0A,
  0x05, 0xD7, 0x75, 0x0C, 0xC0, 0x90, 0x3D, 0x02, 0x77, 0x40, 0xEC, 0x06, 0x1D, 0x04, 0x77, 0x30,
  0x2D, 0x81, 0x30, 0xCC, 0x08, 0x77, 0x30, 0x5D, 0x20, 0x8C, 0x0C, 0x77, 0x30, 0xAC, 0x0B, 0x20,
  0x4D, 0x02, 0x77, 0x20, 0xEC, 0x07, 0x30, 0xDC, 0x09, 0x77, 0x10, 0x6D, 0x01, 0x30, 0x8C, 0x0E,
  0x01, 0x77, 0x0D, 0xC0, 0xB4, 0x01, 0x0E, 0xC0, 0x97, 0x60, 0x7D, 0x04, 0x50, 0x8D, 0x06, 0x74,
  0x04, 0xD0, 0xB7, 0x0D, 0xD0, 0x77, 0x20, 0x5D, 0x0E, 0x02, 0x70, 0x3E, 0x81, 0xC5, 0x14, 0x04,
  0x0B, 0xE0, 0x57, 0x20, 0x5F, 0x90, 0xFD, 0xF9, 0x07, 0x74, 0x04, 0x0E, 0xFF, 0xA0, 0x77, 0x60,
  0x20, 0xBF, 0xE0, 0xD0, 0x37, 0x72, 0x81, 0x4A, 0xEF, 0x90, 0xB0, 0x57, 0x77, 0x85, 0x35, 0x67,
  0x65, 0x37, 0x50,
  // "ō" (U+014D)
  0x50, 0x38, 0x09, 0x25, 0x04, 0x72, 0x09, 0xFF, 0x0E, 0x72, 0x09, 0xFF, 0x0E, 0x72, 0x09, 0xFF,
  0x0E, 0x72, 0x09, 0xFF, 0x0E, 0x80, 0x9D, 0x50, 0x85, 0x14, 0x67, 0x75, 0x37, 0x72, 0x05, 0x0C,
  0xF8, 0x1E, 0x81, 0x74, 0x02, 0x0C, 0xFC, 0x0E, 0x06, 0x72, 0x02, 0x0E, 0xFF, 0x08, 0x70, 0x10,
  0xDF, 0x0D, 0x0E, 0xF0, 0x66, 0x09, 0xD0, 0xB0, 0x43, 0x81, 0x16, 0xEC, 0x0E, 0x01, 0x40, 0x2D,
  0x09, 0x70, 0x20, 0xDC, 0x0A, 0x40, 0xAC, 0x0C, 0x72, 0x03, 0xD0, 0x23, 0x0E, 0xC0, 0x47, 0x30,
  0xAC, 0x08, 0x20, 0x4C, 0x0D, 0x74, 0x04, 0xC0, 0xD2, 0x08, 0xC0, 0x87, 0x50, 0xEC, 0x81, 0x10,
  0xBC, 0x05, 0x75, 0x0B, 0xC8, 0x14, 0x0E, 0xC0, 0x27, 0x50, 0x8C, 0x07, 0x1D, 0x76, 0x06, 0xC0,
  0x90, 0x1C, 0x0E, 0x76, 0x04, 0xC0, 0xA0, 0x2C, 0x0E, 0x76, 0x04, 0xC0, 0xB0, 0x3C, 0x0D, 0x76,
  0x03, 0xC0, 0xC0, 0x3C, 0x0D, 0x76, 0x03, 0xC0, 0xC0, 0x2C, 0x0E, 0x76, 0x04, 0xC0, 0xB0, 0x1C,
  0x0E, 0x76, 0x05, 0xC0, 0xA1, 0xD7, 0x60, 0x6C, 0x81, 0x90, 0xDC, 0x02, 0x75, 0x08, 0xC8, 0x17,
  0x0A, 0xC0, 0x57, 0x50, 0xBC, 0x81, 0x40, 0x7C, 0x09, 0x75, 0x0E, 0xC8, 0x11, 0x03, 0xC0, 0xD7,
  0x40, 0x4C, 0x0C, 0x30, 0xDC, 0x04, 0x73, 0x0A, 0xC0, 0x63, 0x07, 0xC0, 0xC7, 0x20, 0x4D, 0x01,
  0x30, 0x10, 0xEC, 0x09, 0x70, 0x20, 0xDC, 0x08, 0x50, 0x6D, 0x0B, 0x04, 0x38, 0x11, 0x6E, 0xC0,
  0xE0, 0x16, 0x0B, 0xF0, 0xD0, 0xEF, 0x05, 0x70, 0x10, 0xCF, 0xF0, 0x77, 0x30, 0xAF, 0xC0, 0xE0,
  0x67, 0x50, 0x40, 0xBF, 0x81, 0xE8, 0x17, 0x71, 0x85, 0x14, 0x67, 0x75, 0x37, 0x20,
  // "Ŏ" (U+014E)
  0x70, 0x8A, 0x0A, 0x72, 0xB0, 0x27, 0x70, 0x6A, 0x0E, 0x71, 0x06, 0xB0, 0x17, 0x70, 0x3B, 0x0A,
  0x60, 0x30, 0xEA, 0x0C, 0x77, 0x20, 0xDB, 0x84, 0xE8, 0x65, 0x7B, 0xC0, 0x77, 0x72, 0x07, 0xFD,
  0x0E, 0x77, 0x40, 0xBF, 0xC0, 0x37, 0x75, 0x0A, 0xF9, 0x0D, 0x03, 0x77, 0x78, 0x63, 0x9D, 0xEF,
  0xDB, 0x68, 0x0A, 0xA0, 0x08, 0x53, 0x56, 0x76, 0x53, 0x77, 0x70, 0x50, 0xBF, 0xA0, 0xB0, 0x57,
  0x72, 0x04, 0x0D, 0xFE, 0x0D, 0x03, 0x76, 0x08, 0xFF, 0xB0, 0x77, 0x40, 0x9F, 0x98, 0x1E, 0xDD,
  0xF9, 0x08, 0x72, 0x07, 0xE8, 0x1C, 0x51, 0x40, 0x40, 0xAE, 0x05, 0x70, 0x3E, 0x07, 0x72, 0x04,
  0x0E, 0xC0, 0xE0, 0x26, 0x0C, 0xD0, 0x57, 0x40, 0x3D, 0x0B, 0x50, 0x4D, 0x09, 0x76, 0x06, 0xD0,
  0x44, 0x0B, 0xC0, 0xE7, 0x71, 0x0C, 0xC0, 0xB3, 0x01, 0xD0, 0x77, 0x71, 0x05, 0xD0, 0x12, 0x06,
  0xD0, 0x17, 0x72, 0x0E, 0xC0, 0x72, 0x0B, 0xC0, 0xC7, 0x73, 0x09, 0xC0, 0xB2, 0x0E, 0xC0, 0x77,
  0x73, 0x05, 0xD1, 0x02, 0xD0, 0x47, 0x73, 0x01, 0xD0, 0x30, 0x5D, 0x01, 0x77, 0x40, 0xEC, 0x06,
  0x07, 0xC0, 0xE7, 0x75, 0x0C, 0xC0, 0x09, 0xC0, 0xC7, 0x75, 0x0A, 0xC0, 0xB0, 0xAC, 0x0B, 0x77,
  0x50, 0x9C, 0x0C, 0x0B, 0xC0, 0xA7, 0x75, 0x08, 0xC0, 0xE0, 0xCC, 0x09, 0x77, 0x50, 0x7C, 0x0E,
  0x0C, 0xC0, 0x97, 0x75, 0x07, 0xD0, 0xCC, 0x09, 0x77, 0x50, 0x6D, 0x0C, 0xC0, 0x97, 0x75, 0x07,
  0xD0, 0xBC, 0x0A, 0x77, 0x50, 0x7C, 0x0E, 0x0A, 0xC0, 0xA7, 0x75, 0x08, 0xC0, 0xE0, 0x9C, 0x0B,
  0x77, 0x50, 0x9C, 0x0C, 0x07, 0xC0, 0xD7, 0x75, 0x0A, 0xC0, 0xA0, 0x5D, 0x77, 0x50, 0xCC, 0x09,
  0x03, 0xD0, 0x27, 0x74, 0x0E, 0xC0, 0x61, 0xD0, 0x47, 0x73, 0x02, 0xD8, 0x13, 0x0C, 0xC0, 0x87,
  0x73, 0x05, 0xD2, 0x08, 0xC0, 0xC7, 0x73, 0x0A, 0xC0, 0xB2, 0x04, 0xD0, 0x27, 0x72, 0x0E, 0xC0,
  0x73, 0x0D, 0xC0, 0x97, 0x71, 0x06, 0xD0, 0x13, 0x08, 0xC0, 0xE0, 0x17, 0x70, 0xDC, 0x0B, 0x40,
  0x10, 0xEC, 0x09, 0x76, 0x07, 0xD0, 0x45, 0x08, 0xD0, 0x67, 0x40, 0x4D, 0x0B, 0x70, 0xDD, 0x07,
  0x72, 0x05, 0xD0, 0xE0, 0x27, 0x03, 0xE8, 0x1C, 0x51, 0x40, 0x40, 0xBE, 0x05, 0x72, 0x05, 0xF9,
  0x0F, 0xDF, 0x90, 0x77, 0x40, 0x40, 0xEF, 0xFA, 0x07, 0x76, 0x02, 0x0B, 0xFE, 0x0D, 0x03, 0x77,
  0x28, 0x14, 0xAE, 0xF9, 0x0B, 0x05, 0x77, 0x78, 0x53, 0x56, 0x76, 0x53, 0x75,
  // "ŏ" (U+014F)
  0x50, 0x8A, 0x0A, 0x72, 0xB0, 0x27, 0x10, 0x6A, 0x0E, 0x71, 0x06, 0xB0, 0x17, 0x10, 0x3B, 0x0A,
  0x60, 0x30, 0xEA, 0x0C, 0x73, 0x0D, 0xB8, 0x4E, 0x86, 0x57, 0xBC, 0x07, 0x73, 0x07, 0xFD, 0x0E,
  0x75, 0x0B, 0xFC, 0x03, 0x76, 0x0A, 0xF9, 0x0D, 0x03, 0x77, 0x18, 0x63, 0x9D, 0xEF, 0xDB, 0x68,
  0x09, 0xE1, 0x08, 0x51, 0x46, 0x77, 0x53, 0x77, 0x20, 0x50, 0xCF, 0x81, 0xE8, 0x17, 0x40, 0x20,
  0xCF, 0xC0, 0xE0, 0x67, 0x20, 0x20, 0xEF, 0xF0, 0x87, 0x01, 0x0D, 0xF0, 0xD0, 0xEF, 0x06, 0x60,
  0x9D, 0x0B, 0x04, 0x38, 0x11, 0x6E, 0xC0, 0xE0, 0x14, 0x02, 0xD0, 0x97, 0x02, 0x0D, 0xC0, 0xA4,
  0x0A, 0xC0, 0xC7, 0x20, 0x3D, 0x02, 0x30, 0xEC, 0x04, 0x73, 0x0A, 0xC0, 0x82, 0x04, 0xC0, 0xD7,
  0x40, 0x4C, 0x0D, 0x20, 0x8C, 0x08, 0x75, 0x0E, 0xC8, 0x11, 0x0B, 0xC0, 0x57, 0x50, 0xBC, 0x81,
  0x40, 0xEC, 0x02, 0x75, 0x08, 0xC0, 0x71, 0xD7, 0x60, 0x6C, 0x09, 0x01, 0xC0, 0xE7, 0x60, 0x4C,
  0x0A, 0x02, 0xC0, 0xE7, 0x60, 0x4C, 0x0B, 0x03, 0xC0, 0xD7, 0x60, 0x3C, 0x0C, 0x03, 0xC0, 0xD7,
  0x60, 0x3C, 0x0C, 0x02, 0xC0, 0xE7, 0x60, 0x4C, 0x0B, 0x01, 0xC0, 0xE7, 0x60, 0x5C, 0x0A, 0x1D,
  0x76, 0x06, 0xC8, 0x19, 0x0D, 0xC0, 0x27, 0x50, 0x8C, 0x81, 0x70, 0xAC, 0x05, 0x75, 0x0B, 0xC8,
  0x14, 0x07, 0xC0, 0x97, 0x50, 0xEC, 0x81, 0x10, 0x3C, 0x0D, 0x74, 0x04, 0xC0, 0xC3, 0x0D, 0xC0,
  0x47, 0x30, 0xAC, 0x06, 0x30, 0x7C, 0x0C, 0x72, 0x04, 0xD0, 0x13, 0x01, 0x0E, 0xC0, 0x97, 0x02,
  0x0D, 0xC0, 0x85, 0x06, 0xD0, 0xB0, 0x43, 0x81, 0x16, 0xEC, 0x0E, 0x01, 0x60, 0xBF, 0x0D, 0x0E,
  0xF0, 0x57, 0x01, 0x0C, 0xFF, 0x07, 0x73, 0x0A, 0xFC, 0x0E, 0x06, 0x75, 0x04, 0x0B, 0xF8, 0x1E,
  0x81, 0x77, 0x18, 0x51, 0x46, 0x77, 0x53, 0x72,
  // "Ő" (U+0150)
  0x76, 0x0E, 0xC0, 0x73, 0x0B, 0xC0, 0xB7, 0x71, 0x06, 0xC0, 0xE0, 0x12, 0x02, 0xD0, 0x47, 0x71,
  0x0D, 0xC0, 0x63, 0x0A, 0xC0, 0x97, 0x71, 0x06, 0xC0, 0xB3, 0x02, 0xC0, 0xD7, 0x72, 0x0D, 0xB0,
  0xD0, 0x13, 0x0A, 0xB0, 0xE0, 0x27, 0x71, 0x07, 0xB0, 0xE0, 0x23, 0x02, 0xC0, 0x57, 0x71, 0x01,
  0x0E, 0xB0, 0x54, 0x0B, 0xB0, 0x77, 0x72, 0x08, 0xB0, 0x74, 0x04, 0xB0, 0x97, 0x72, 0x02, 0xB0,
  0x75, 0x0C, 0xA0, 0xA7, 0x73, 0x08, 0xA0, 0x75, 0x05, 0xA0, 0xA8, 0x0A, 0x96, 0x08, 0x53, 0x56,
  0x76, 0x53, 0x77, 0x70, 0x50, 0xBF, 0xA0, 0xB0, 0x57, 0x72, 0x04, 0x0D, 0xFE, 0x0D, 0x03, 0x76,
  0x08, 0xFF, 0xB0, 0x77, 0x40, 0x9F, 0x98, 0x1E, 0xDD, 0xF9, 0x08, 0x72, 0x07, 0xE8, 0x1C, 0x51,
  0x40, 0x40, 0xAE, 0x05, 0x70, 0x3E, 0x07, 0x72, 0x04, 0x0E, 0xC0, 0xE0, 0x26, 0x0C, 0xD0, 0x57,
  0x40, 0x3D, 0x0B, 0x50, 0x4D, 0x09, 0x76, 0x06, 0xD0, 0x44, 0x0B, 0xC0, 0xE7, 0x71, 0x0C, 0xC0,
  0xB3, 0x01, 0xD0, 0x77, 0x71, 0x05, 0xD0, 0x12, 0x06, 0xD0, 0x17, 0x72, 0x0E, 0xC0, 0x72, 0x0B,
  0xC0, 0xC7, 0x73, 0x09, 0xC0, 0xB2, 0x0E, 0xC0, 0x77, 0x73, 0x05, 0xD1, 0x02, 0xD0, 0x47, 0x73,
  0x01, 0xD0, 0x30, 0x5D, 0x01, 0x77, 0x40, 0xEC, 0x06, 0x07, 0xC0, 0xE7, 0x75, 0x0C, 0xC0, 0x09,
  0xC0, 0xC7, 0x75, 0x0A, 0xC0, 0xB0, 0xAC, 0x0B, 0x77, 0x50, 0x9C, 0x0C, 0x0B, 0xC0, 0xA7, 0x75,
  0x08, 0xC0, 0xE0, 0xCC, 0x09, 0x77, 0x50, 0x7C, 0x0E, 0x0C, 0xC0, 0x97, 0x75, 0x07, 0xD0, 0xCC,
  0x09, 0x77, 0x50, 0x6D, 0x0C, 0xC0, 0x97, 0x75, 0x07, 0xD0, 0xBC, 0x0A, 0x77, 0x50, 0x7C, 0x0E,
  0x0A, 0xC0, 0xA7, 0x75, 0x08, 0xC0, 0xE0, 0x9C, 0x0B, 0x77, 0x50, 0x9C, 0x0C, 0x07, 0xC0, 0xD7,
  0x75, 0x0A, 0xC0, 0xA0, 0x5D, 0x77, 0x50, 0xCC, 0x09, 0x03, 0xD0, 0x27, 0x74, 0x0E, 0xC0, 0x61,
  0xD0, 0x47, 0x73, 0x02, 0xD8, 0x13, 0x0C, 0xC0, 0x87, 0x73, 0x05, 0xD2, 0x08, 0xC0, 0xC7, 0x73,
  0x0A, 0xC0, 0xB2, 0x04, 0xD0, 0x27, 0x72, 0x0E, 0xC0, 0x73, 0x0D, 0xC0, 0x97, 0x71, 0x06, 0xD0,
  0x13, 0x08, 0xC0, 0xE0, 0x17, 0x70, 0xDC, 0x0B, 0x40, 0x10, 0xEC, 0x09, 0x76, 0x07, 0xD0, 0x45,
  0x08, 0xD0, 0x67, 0x40, 0x4D, 0x0B, 0x70, 0xDD, 0x07, 0x72, 0x05, 0xD0, 0xE0, 0x27, 0x03, 0xE8,
  0x1C, 0x51, 0x40, 0x40, 0xBE, 0x05, 0x72, 0x05, 0xF9, 0x0F, 0xDF, 0x90, 0x77, 0x40, 0x40, 0xEF,
  0xFA, 0x07, 0x76, 0x02, 0x0B, 0xFE, 0x0D, 0x03, 0x77, 0x28, 0x14, 0xAE, 0xF9, 0x0B, 0x05, 0x77,
  0x78, 0x53, 0x56, 0x76, 0x53, 0x75,
  // "ő" (U+0151)
  0x73, 0x0E, 0xC0, 0x73, 0x0B, 0xC0, 0xB7, 0x20, 0x6C, 0x0E, 0x01, 0x20, 0x2D, 0x04, 0x72, 0x0D,
  0xC0, 0x63, 0x0A, 0xC0, 0x97, 0x20, 0x6C, 0x0B, 0x30, 0x2C, 0x0D, 0x73, 0x0D, 0xB0, 0xD0, 0x13,
  0x0A, 0xB0, 0xE0, 0x27, 0x20, 0x7B, 0x0E, 0x02, 0x30, 0x2C, 0x05, 0x72, 0x01, 0x0E, 0xB0, 0x54,
  0x0B, 0xB0, 0x77, 0x30, 0x8B, 0x07, 0x40, 0x4B, 0x09, 0x73, 0x02, 0xB0, 0x75, 0x0C, 0xA0, 0xA7,
  0x40, 0x8A, 0x07, 0x50, 0x5A, 0x0A, 0x80, 0x9E, 0x00, 0x85, 0x14, 0x67, 0x75, 0x37, 0x72, 0x05,
  0x0C, 0xF8, 0x1E, 0x81, 0x74, 0x02, 0x0C, 0xFC, 0x0E, 0x06, 0x72, 0x02, 0x0E, 0xFF, 0x08, 0x70,
  0x10, 0xDF, 0x0D, 0x0E, 0xF0, 0x66, 0x09, 0xD0, 0xB0, 0x43, 0x81, 0x16, 0xEC, 0x0E, 0x01, 0x40,
  0x2D, 0x09, 0x70, 0x20, 0xDC, 0x0A, 0x40, 0xAC, 0x0C, 0x72, 0x03, 0xD0, 0x23, 0x0E, 0xC0, 0x47,
  0x30, 0xAC, 0x08, 0x20, 0x4C, 0x0D, 0x74, 0x04, 0xC0, 0xD2, 0x08, 0xC0, 0x87, 0x50, 0xEC, 0x81,
  0x10, 0xBC, 0x05, 0x75, 0x0B, 0xC8, 0x14, 0x0E, 0xC0, 0x27, 0x50, 0x8C, 0x07, 0x1D, 0x76, 0x06,
  0xC0, 0x90, 0x1C, 0x0E, 0x76, 0x04, 0xC0, 0xA0, 0x2C, 0x0E, 0x76, 0x04, 0xC0, 0xB0, 0x3C, 0x0D,
  0x76, 0x03, 0xC0, 0xC0, 0x3C, 0x0D, 0x76, 0x03, 0xC0, 0xC0, 0x2C, 0x0E, 0x76, 0x04, 0xC0, 0xB0,
  0x1C, 0x0E, 0x76, 0x05, 0xC0, 0xA1, 0xD7, 0x60, 0x6C, 0x81, 0x90, 0xDC, 0x02, 0x75, 0x08, 0xC8,
  0x17, 0x0A, 0xC0, 0x57, 0x50, 0xBC, 0x81, 0x40, 0x7C, 0x09, 0x75, 0x0E, 0xC8, 0x11, 0x03, 0xC0,
  0xD7, 0x40, 0x4C, 0x0C, 0x30, 0xDC, 0x04, 0x73, 0x0A, 0xC0, 0x63, 0x07, 0xC0, 0xC7, 0x20, 0x4D,
  0x01, 0x30, 0x10, 0xEC, 0x09, 0x70, 0x20, 0xDC, 0x08, 0x50, 0x6D, 0x0B, 0x04, 0x38, 0x11, 0x6E,
  0xC0, 0xE0, 0x16, 0x0B, 0xF0, 0xD0, 0xEF, 0x05, 0x70, 0x10, 0xCF, 0xF0, 0x77, 0x30, 0xAF, 0xC0,
  0xE0, 0x67, 0x50, 0x40, 0xBF, 0x81, 0xE8, 0x17, 0x71, 0x85, 0x14, 0x67, 0x75, 0x37, 0x20,
  // "Œ" (U+0152)
  0x75, 0x86, 0x14, 0x67, 0x76, 0x52, 0x77, 0x76, 0x81, 0x28, 0xDF, 0xFF, 0xC0, 0xD7, 0x01, 0x09,
  0xFF, 0xFF, 0x0D, 0x60, 0x40, 0xEF, 0xFF, 0xF9, 0x0D, 0x50, 0x4F, 0xA8, 0x1D, 0xDE, 0xFF, 0xD0,
  0xD4, 0x03, 0xE8, 0x1E, 0x73, 0x40, 0x30, 0xDC, 0x08, 0x80, 0x90, 0x50, 0x44, 0x0D, 0xD0, 0x97,
  0x10, 0xCC, 0x04, 0x77, 0x20, 0x8D, 0x08, 0x72, 0x0C, 0xC0, 0x47, 0x71, 0x01, 0xD0, 0xA7, 0x30,
  0xCC, 0x04, 0x77, 0x10, 0x8C, 0x0E, 0x01, 0x73, 0x0C, 0xC0, 0x47, 0x71, 0x0E, 0xC0, 0x87, 0x40,
  0xCC, 0x04, 0x77, 0x04, 0xD0, 0x17, 0x40, 0xCC, 0x04, 0x77, 0x09, 0xC0, 0xC7, 0x50, 0xCC, 0x04,
  0x77, 0x0D, 0xC0, 0x77, 0x50, 0xCC, 0x04, 0x76, 0x01, 0xD0, 0x47, 0x50, 0xCC, 0x04, 0x76, 0x04,
  0xD0, 0x17, 0x50, 0xCC, 0x04, 0x76, 0x06, 0xC0, 0xE7, 0x60, 0xCC, 0x04, 0x76, 0x08, 0xC0, 0xC7,
  0x60, 0xCC, 0x04, 0x76, 0x09, 0xC0, 0xB7, 0x60, 0xCC, 0x04, 0x76, 0x0B, 0xC0, 0xA7, 0x60, 0xCC,
  0x08, 0x80, 0x90, 0x51, 0x0B, 0xC0, 0x97, 0x60, 0xCF, 0xFB, 0x10, 0xCC, 0x09, 0x76, 0x0C, 0xFF,
  0xB1, 0x0C, 0xC0, 0x97, 0x60, 0xCF, 0xFB, 0x10, 0xCC, 0x09, 0x76, 0x0C, 0xFF, 0xB1, 0x0B, 0xC0,
  0x97, 0x60, 0xCC, 0x04, 0x76, 0x0B, 0xC0, 0xA7, 0x60, 0xCC, 0x04, 0x76, 0x09, 0xC0, 0xB7, 0x60,
  0xCC, 0x04, 0x76, 0x08, 0xC0, 0xD7, 0x60, 0xCC, 0x04, 0x76, 0x06, 0xD7, 0x60, 0xCC, 0x04, 0x76,
  0x04, 0xD0, 0x17, 0x50, 0xCC, 0x04, 0x76, 0x01, 0xD0, 0x47, 0x50, 0xCC, 0x04, 0x77, 0x0D, 0xC0,
  0x87, 0x50, 0xCC, 0x04, 0x77, 0x09, 0xC0, 0xC7, 0x50, 0xCC, 0x04, 0x77, 0x04, 0xD0, 0x27, 0x40,
  0xCC, 0x04, 0x77, 0x10, 0xEC, 0x09, 0x74, 0x0C, 0xC0, 0x47, 0x71, 0x08, 0xD0, 0x27, 0x30, 0xCC,
  0x04, 0x77, 0x10, 0x1D, 0x0B, 0x73, 0x0C, 0xC0, 0x47, 0x72, 0x08, 0xD0, 0x97, 0x20, 0xCC, 0x04,
  0x77, 0x20, 0x10, 0xDD, 0x0A, 0x01, 0x70, 0xCC, 0x04, 0x77, 0x30, 0x3E, 0x81, 0xE8, 0x34, 0x01,
  0x0D, 0xC0, 0x88, 0x09, 0x05, 0x04, 0x50, 0x5F, 0xA8, 0x1D, 0xDE, 0xFF, 0xD0, 0xD6, 0x05, 0x0E,
  0xFF, 0xFF, 0x90, 0xD7, 0x02, 0x0A, 0xFF, 0xFF, 0x0D, 0x72, 0x81, 0x29, 0xDF, 0xFF, 0xC0, 0xD7,
  0x58, 0x62, 0x46, 0x77, 0x65, 0x37, 0x74,
  // "œ" (U+0153)
  0x72, 0x85, 0x14, 0x67, 0x75, 0x27, 0x58, 0x43, 0x67, 0x75, 0x27, 0x71, 0x05, 0x0C, 0xF0, 0xC0,
  0x57, 0x10, 0x70, 0xDE, 0x0D, 0x06, 0x74, 0x02, 0x0C, 0xFC, 0x0B, 0x01, 0x40, 0x20, 0xDF, 0xB0,
  0xC0, 0x17, 0x10, 0x20, 0xEF, 0xE0, 0xC3, 0x01, 0x0D, 0xFD, 0x0D, 0x01, 0x60, 0x10, 0xDE, 0x81,
  0xED, 0xEE, 0x0A, 0x20, 0xCD, 0x81, 0xED, 0xEE, 0x0C, 0x60, 0x9D, 0x0A, 0x03, 0x30, 0x10, 0x8D,
  0x04, 0x07, 0xC0, 0xD0, 0x43, 0x01, 0x08, 0xD0, 0x64, 0x02, 0xD0, 0x77, 0x04, 0xC0, 0xD0, 0xEB,
  0x0C, 0x70, 0x5C, 0x0E, 0x40, 0x9C, 0x0B, 0x72, 0x07, 0xF9, 0x01, 0x71, 0x0A, 0xC0, 0x53, 0x0E,
  0xC0, 0x37, 0x30, 0xEE, 0x09, 0x72, 0x03, 0xC0, 0xA2, 0x04, 0xC0, 0xC7, 0x40, 0x8E, 0x03, 0x73,
  0x0D, 0xB0, 0xE2, 0x08, 0xC0, 0x87, 0x40, 0x3D, 0x0E, 0x74, 0x09, 0xC8, 0x12, 0x0B, 0xC0, 0x47,
  0x5D, 0x0B, 0x74, 0x06, 0xC8, 0x14, 0x0E, 0xC0, 0x27, 0x50, 0xDC, 0x09, 0x74, 0x05, 0xC0, 0x61,
  0xD7, 0x60, 0xBC, 0x0A, 0x80, 0x75, 0x08, 0xC0, 0x70, 0x1C, 0x0E, 0x76, 0x09, 0xFF, 0xF0, 0x70,
  0x2C, 0x0E, 0x76, 0x08, 0xFF, 0xF0, 0x70, 0x3C, 0x0D, 0x76, 0x08, 0xFF, 0xF0, 0x70, 0x3C, 0x0D,
  0x76, 0x08, 0xFF, 0xF0, 0x70, 0x2C, 0x0E, 0x76, 0x08, 0xC0, 0x77, 0x73, 0x01, 0xC0, 0xE7, 0x60,
  0x9C, 0x08, 0x77, 0x4D, 0x76, 0x0A, 0xC0, 0x97, 0x74, 0x0D, 0xC0, 0x27, 0x50, 0xCC, 0x0B, 0x77,
  0x40, 0xAC, 0x05, 0x75, 0x0E, 0xC0, 0xD7, 0x74, 0x08, 0xC0, 0x97, 0x40, 0x3E, 0x02, 0x77, 0x30,
  0x3C, 0x0D, 0x74, 0x07, 0xE0, 0x77, 0x74, 0x0D, 0xC0, 0x47, 0x30, 0xDE, 0x0E, 0x77, 0x40, 0x8C,
  0x0C, 0x72, 0x05, 0xF9, 0x09, 0x77, 0x30, 0x10, 0xEC, 0x09, 0x70, 0x30, 0xEB, 0x0E, 0x0D, 0xC0,
  0x77, 0x38, 0x11, 0x83, 0x40, 0x6D, 0x0B, 0x04, 0x30, 0x10, 0x7D, 0x06, 0x05, 0xD0, 0xB0, 0x55,
  0x81, 0x26, 0xBA, 0x03, 0x50, 0xBF, 0x0D, 0x0E, 0xE0, 0xB2, 0x09, 0xF8, 0x1E, 0xDD, 0xE0, 0x35,
  0x01, 0x0C, 0xFE, 0x0D, 0x01, 0x30, 0xBF, 0xF9, 0x03, 0x60, 0x10, 0xAF, 0xC0, 0xB0, 0x15, 0x08,
  0xFE, 0x0B, 0x01, 0x71, 0x04, 0x0B, 0xF0, 0xC0, 0x67, 0x18, 0x12, 0xAE, 0xF8, 0x1E, 0x93, 0x75,
  0x85, 0x14, 0x67, 0x75, 0x27, 0x68, 0x53, 0x67, 0x76, 0x52, 0x60,
  // "Ŕ" (U+0154)
  0x76, 0x02, 0x80, 0x17, 0x06, 0x77, 0x50, 0xAD, 0x07, 0x77, 0x40, 0x3D, 0x0C, 0x77, 0x50, 0xCC,
  0x0E, 0x01, 0x77, 0x40, 0x6C, 0x0E, 0x03, 0x77, 0x40, 0x10, 0xEC, 0x04, 0x77, 0x50, 0xAC, 0x05,
  0x77, 0x50, 0x5C, 0x05, 0x77, 0x50, 0x10, 0xEB, 0x05, 0x77, 0x60, 0x8A, 0x0E, 0x04, 0x80, 0xA9,
  0x30, 0x03, 0xFA, 0x84, 0xED, 0xCA, 0x74, 0x73, 0x03, 0xFF, 0x98, 0x1E, 0x81, 0x70, 0x3F, 0xFB,
  0x0E, 0x04, 0x60, 0x3F, 0xFD, 0x06, 0x50, 0x3D, 0x80, 0x15, 0x81, 0x69, 0xDF, 0x03, 0x40, 0x3C,
  0x0E, 0x71, 0x03, 0x0C, 0xD0, 0xC4, 0x03, 0xC0, 0xE7, 0x30, 0xBD, 0x04, 0x30, 0x3C, 0x0E, 0x73,
  0x01, 0x0E, 0xC0, 0x93, 0x03, 0xC0, 0xE7, 0x40, 0x8C, 0x0D, 0x30, 0x3C, 0x0E, 0x74, 0x04, 0xD0,
  0x12, 0x03, 0xC0, 0xE7, 0x40, 0x1D, 0x02, 0x20, 0x3C, 0x0E, 0x75, 0xD0, 0x32, 0x03, 0xC0, 0xE7,
  0x5D, 0x04, 0x20, 0x3C, 0x0E, 0x74, 0x01, 0xD0, 0x32, 0x03, 0xC0, 0xE7, 0x40, 0x2D, 0x02, 0x20,
  0x3C, 0x0E, 0x74, 0x06, 0xC0, 0xE3, 0x03, 0xC0, 0xE7, 0x40, 0xBC, 0x0B, 0x30, 0x3C, 0x0E, 0x73,
  0x03, 0xD0, 0x63, 0x03, 0xC0, 0xE7, 0x20, 0x10, 0xDC, 0x0D, 0x40, 0x3C, 0x0E, 0x71, 0x05, 0x0D,
  0xD0, 0x54, 0x03, 0xD8, 0x01, 0x58, 0x16, 0x9D, 0xE0, 0x95, 0x03, 0xFF, 0xC0, 0x96, 0x03, 0xFF,
  0xA0, 0xE0, 0x57, 0x03, 0xFF, 0x90, 0x80, 0x17, 0x10, 0x3F, 0xF9, 0x08, 0x72, 0x03, 0xC0, 0xE5,
  0x04, 0xD0, 0x17, 0x10, 0x3C, 0x0E, 0x60, 0xCC, 0x08, 0x71, 0x03, 0xC0, 0xE6, 0x05, 0xC0, 0xE0,
  0x17, 0x03, 0xC0, 0xE7, 0x0D, 0xC0, 0x87, 0x03, 0xC0, 0xE7, 0x06, 0xC0, 0xE0, 0x16, 0x03, 0xC0,
  0xE7, 0x10, 0xEC, 0x08, 0x60, 0x3C, 0x0E, 0x71, 0x07, 0xC0, 0xE0, 0x15, 0x03, 0xC0, 0xE7, 0x20,
  0xEC, 0x08, 0x50, 0x3C, 0x0E, 0x72, 0x08, 0xC0, 0xE0, 0x14, 0x03, 0xC0, 0xE7, 0x20, 0x1D, 0x08,
  0x40, 0x3C, 0x0E, 0x73, 0x09, 0xC0, 0xE0, 0x13, 0x03, 0xC0, 0xE7, 0x30, 0x2D, 0x08, 0x30, 0x3C,
  0x0E, 0x74, 0x0A, 0xC0, 0xE0, 0x12, 0x03, 0xC0, 0xE7, 0x40, 0x2D, 0x08, 0x20, 0x3C, 0x0E, 0x75,
  0x0B, 0xC8, 0x2E, 0x10, 0x3C, 0x0E, 0x75, 0x03, 0xD8, 0x18, 0x03, 0xC0, 0xE7, 0x60, 0xBC, 0x81,
  0xE1, 0x3C, 0x0E, 0x76, 0x04, 0xD0, 0x80,
  // "ŕ" (U+0155)
  0x72, 0x02, 0x80, 0x17, 0x06, 0x72, 0x0A, 0xD0, 0x77, 0x10, 0x3D, 0x0C, 0x72, 0x0C, 0xC0, 0xE0,
  0x17, 0x10, 0x6C, 0x0E, 0x03, 0x71, 0x01, 0x0E, 0xC0, 0x47, 0x20, 0xAC, 0x05, 0x72, 0x05, 0xC0,
  0x57, 0x20, 0x10, 0xEB, 0x05, 0x73, 0x08, 0xA0, 0xE0, 0x48, 0x09, 0x95, 0x08, 0x52, 0x67, 0x65,
  0x1B, 0xB0, 0x43, 0x01, 0x0A, 0xD0, 0x70, 0xBB, 0x05, 0x20, 0x10, 0xDE, 0x05, 0x0B, 0xB0, 0x72,
  0x0C, 0xF0, 0x30, 0xBB, 0x81, 0x80, 0x8F, 0x90, 0x10, 0xBB, 0x0A, 0x02, 0xC8, 0x5C, 0x88, 0xAE,
  0x0B, 0xB0, 0xB0, 0x9A, 0x0D, 0x03, 0x48, 0x11, 0x0B, 0xE0, 0xD0, 0x17, 0x0B, 0xE0, 0x47, 0x10,
  0xBD, 0x0A, 0x72, 0x0B, 0xD0, 0x37, 0x20, 0xBC, 0x0E, 0x73, 0x0B, 0xC0, 0xA7, 0x30, 0xBC, 0x07,
  0x73, 0x0B, 0xC0, 0x57, 0x30, 0xBC, 0x04, 0x73, 0x0B, 0xC0, 0x37, 0x30, 0xBC, 0x03, 0x73, 0x0B,
  0xC0, 0x37, 0x30, 0xBC, 0x03, 0x73, 0x0B, 0xC0, 0x37, 0x30, 0xBC, 0x03, 0x73, 0x0B, 0xC0, 0x37,
  0x30, 0xBC, 0x03, 0x73, 0x0B, 0xC0, 0x37, 0x30, 0xBC, 0x03, 0x73, 0x0B, 0xC0, 0x37, 0x30, 0xBC,
  0x03, 0x73, 0x0B, 0xC0, 0x37, 0x30, 0xBC, 0x03, 0x73, 0x0B, 0xC0, 0x37, 0x30, 0xBC, 0x03, 0x73,
  0x0B, 0xC0, 0x37, 0x30,
  // "Ŗ" (U+0156)
  0x03, 0xFA, 0x84, 0xED, 0xCA, 0x74, 0x73, 0x03, 0xFF, 0x98, 0x1E, 0x81, 0x70, 0x3F, 0xFB, 0x0E,
  0x04, 0x60, 0x3F, 0xFD, 0x06, 0x50, 0x3D, 0x80, 0x15, 0x81, 0x69, 0xDF, 0x03, 0x40, 0x3C, 0x0E,
  0x71, 0x03, 0x0C, 0xD0, 0xC4, 0x03, 0xC0, 0xE7, 0x30, 0xBD, 0x04, 0x30, 0x3C, 0x0E, 0x73, 0x01,
  0x0E, 0xC0, 0x93, 0x03, 0xC0, 0xE7, 0x40, 0x8C, 0x0D, 0x30, 0x3C, 0x0E, 0x74, 0x04, 0xD0, 0x12,
  0x03, 0xC0, 0xE7, 0x40, 0x1D, 0x02, 0x20, 0x3C, 0x0E, 0x75, 0xD0, 0x32, 0x03, 0xC0, 0xE7, 0x5D,
  0x04, 0x20, 0x3C, 0x0E, 0x74, 0x01, 0xD0, 0x32, 0x03, 0xC0, 0xE7, 0x40, 0x2D, 0x02, 0x20, 0x3C,
  0x0E, 0x74, 0x06, 0xC0, 0xE3, 0x03, 0xC0, 0xE7, 0x40, 0xBC, 0x0B, 0x30, 0x3C, 0x0E, 0x73, 0x03,
  0xD0, 0x63, 0x03, 0xC0, 0xE7, 0x20, 0x10, 0xDC, 0x0D, 0x40, 0x3C, 0x0E, 0x71, 0x05, 0x0D, 0xD0,
  0x54, 0x03, 0xD8, 0x01, 0x58, 0x16, 0x9D, 0xE0, 0x95, 0x03, 0xFF, 0xC0, 0x96, 0x03, 0xFF, 0xA0,
  0xE0, 0x57, 0x03, 0xFF, 0x90, 0x80, 0x17, 0x10, 0x3F, 0xF9, 0x08, 0x72, 0x03, 0xC0, 0xE5, 0x04,
  0xD0, 0x17, 0x10, 0x3C, 0x0E, 0x60, 0xCC, 0x08, 0x71, 0x03, 0xC0, 0xE6, 0x05, 0xC0, 0xE0, 0x17,
  0x03, 0xC0, 0xE7, 0x0D, 0xC0, 0x87, 0x03, 0xC0, 0xE7, 0x06, 0xC0, 0xE0, 0x16, 0x03, 0xC0, 0xE7,
  0x10, 0xEC, 0x08, 0x60, 0x3C, 0x0E, 0x71, 0x07, 0xC0, 0xE0, 0x15, 0x03, 0xC0, 0xE7, 0x20, 0xEC,
  0x08, 0x50, 0x3C, 0x0E, 0x72, 0x08, 0xC0, 0xE0, 0x14, 0x03, 0xC0, 0xE7, 0x20, 0x1D, 0x08, 0x40,
  0x3C, 0x0E, 0x73, 0x09, 0xC0, 0xE0, 0x13, 0x03, 0xC0, 0xE7, 0x30, 0x2D, 0x08, 0x30, 0x3C, 0x0E,
  0x74, 0x0A, 0xC0, 0xE0, 0x12, 0x03, 0xC0, 0xE7, 0x40, 0x2D, 0x08, 0x20, 0x3C, 0x0E, 0x75, 0x0B,
  0xC8, 0x2E, 0x10, 0x3C, 0x0E, 0x75, 0x03, 0xD8, 0x18, 0x03, 0xC0, 0xE7, 0x60, 0xBC, 0x81, 0xE1,
  0x3C, 0x0E, 0x76, 0x04, 0xD0, 0x88, 0x09, 0xA4, 0x00, 0xBC, 0x06, 0x77, 0x60, 0xDC, 0x02, 0x77,
  0x50, 0x1C, 0x0C, 0x77, 0x60, 0x4C, 0x06, 0x77, 0x60, 0x7B, 0x0E, 0x77, 0x70, 0xBB, 0x08, 0x77,
  0x70, 0xEA, 0x0E, 0x01, 0x77, 0x60, 0x3B, 0x08, 0x77, 0x70, 0x7A, 0x0E, 0x01, 0x77, 0x70, 0xBA,
  0x05, 0x77,
  // "ŗ" (U+0157)
  0x74, 0x86, 0x26, 0x76, 0x51, 0x0B, 0xB0, 0x43, 0x01, 0x0A, 0xD8, 0x17, 0x0B, 0xB0, 0x52, 0x01,
  0x0D, 0xE8, 0x15, 0x0B, 0xB0, 0x72, 0x0C, 0xF8, 0x13, 0x0B, 0xB8, 0x18, 0x08, 0xF9, 0x81, 0x10,
  0xBB, 0x0A, 0x02, 0xC8, 0x3C, 0x88, 0xAE, 0x20, 0xBB, 0x0B, 0x09, 0xA0, 0xD0, 0x34, 0x01, 0x20,
  0xBE, 0x0D, 0x01, 0x71, 0x0B, 0xE0, 0x47, 0x20, 0xBD, 0x0A, 0x73, 0x0B, 0xD0, 0x37, 0x30, 0xBC,
  0x0E, 0x74, 0x0B, 0xC0, 0xA7, 0x40, 0xBC, 0x07, 0x74, 0x0B, 0xC0, 0x57, 0x40, 0xBC, 0x04, 0x74,
  0x0B, 0xC0, 0x37, 0x40, 0xBC, 0x03, 0x74, 0x0B, 0xC0, 0x37, 0x40, 0xBC, 0x03, 0x74, 0x0B, 0xC0,
  0x37, 0x40, 0xBC, 0x03, 0x74, 0x0B, 0xC0, 0x37, 0x40, 0xBC, 0x03, 0x74, 0x0B, 0xC0, 0x37, 0x40,
  0xBC, 0x03, 0x74, 0x0B, 0xC0, 0x37, 0x40, 0xBC, 0x03, 0x74, 0x0B, 0xC0, 0x37, 0x40, 0xBC, 0x03,
  0x74, 0x0B, 0xC0, 0x37, 0x40, 0xBC, 0x03, 0x74, 0x0B, 0xC0, 0x38, 0x0F, 0x30, 0x0B, 0xC0, 0x67,
  0x40, 0xDC, 0x02, 0x73, 0x01, 0xC0, 0xC7, 0x40, 0x4C, 0x06, 0x74, 0x07, 0xB0, 0xE7, 0x50, 0xBB,
  0x08, 0x75, 0x0E, 0xA0, 0xE0, 0x17, 0x40, 0x3B, 0x08, 0x75, 0x07, 0xA0, 0xE0, 0x17, 0x50, 0xBA,
  0x05, 0x76,
  // "Ř" (U+0158)
  0x28, 0x24, 0x77, 0x57, 0x38, 0x26, 0x77, 0x37, 0x10, 0x5B, 0x08, 0x71, 0x09, 0xB0, 0x37, 0x20,
  0x8B, 0x08, 0x60, 0xAB, 0x06, 0x74, 0x0C, 0xB0, 0x84, 0x0A, 0xB0, 0x97, 0x50, 0x20, 0xEB, 0x07,
  0x20, 0xAB, 0x0D, 0x77, 0x05, 0xC0, 0x60, 0x9C, 0x02, 0x77, 0x10, 0xAF, 0x90, 0x77, 0x72, 0x01,
  0x0E, 0xE0, 0xB7, 0x74, 0x06, 0xE0, 0x27, 0x75, 0x0C, 0xC0, 0x98, 0x0A, 0x92, 0x00, 0x3F, 0xA8,
  0x4E, 0xDC, 0xA7, 0x47, 0x30, 0x3F, 0xF9, 0x81, 0xE8, 0x17, 0x03, 0xFF, 0xB0, 0xE0, 0x46, 0x03,
  0xFF, 0xD0, 0x65, 0x03, 0xD8, 0x01, 0x58, 0x16, 0x9D, 0xF0, 0x34, 0x03, 0xC0, 0xE7, 0x10, 0x30,
  0xCD, 0x0C, 0x40, 0x3C, 0x0E, 0x73, 0x0B, 0xD0, 0x43, 0x03, 0xC0, 0xE7, 0x30, 0x10, 0xEC, 0x09,
  0x30, 0x3C, 0x0E, 0x74, 0x08, 0xC0, 0xD3, 0x03, 0xC0, 0xE7, 0x40, 0x4D, 0x01, 0x20, 0x3C, 0x0E,
  0x74, 0x01, 0xD0, 0x22, 0x03, 0xC0, 0xE7, 0x5D, 0x03, 0x20, 0x3C, 0x0E, 0x75, 0xD0, 0x42, 0x03,
  0xC0, 0xE7, 0x40, 0x1D, 0x03, 0x20, 0x3C, 0x0E, 0x74, 0x02, 0xD0, 0x22, 0x03, 0xC0, 0xE7, 0x40,
  0x6C, 0x0E, 0x30, 0x3C, 0x0E, 0x74, 0x0B, 0xC0, 0xB3, 0x03, 0xC0, 0xE7, 0x30, 0x3D, 0x06, 0x30,
  0x3C, 0x0E, 0x72, 0x01, 0x0D, 0xC0, 0xD4, 0x03, 0xC0, 0xE7, 0x10, 0x50, 0xDD, 0x05, 0x40, 0x3D,
  0x80, 0x15, 0x81, 0x69, 0xDE, 0x09, 0x50, 0x3F, 0xFC, 0x09, 0x60, 0x3F, 0xFA, 0x0E, 0x05, 0x70,
  0x3F, 0xF9, 0x08, 0x01, 0x71, 0x03, 0xFF, 0x90, 0x87, 0x20, 0x3C, 0x0E, 0x50, 0x4D, 0x01, 0x71,
  0x03, 0xC0, 0xE6, 0x0C, 0xC0, 0x87, 0x10, 0x3C, 0x0E, 0x60, 0x5C, 0x0E, 0x01, 0x70, 0x3C, 0x0E,
  0x70, 0xDC, 0x08, 0x70, 0x3C, 0x0E, 0x70, 0x6C, 0x0E, 0x01, 0x60, 0x3C, 0x0E, 0x71, 0x0E, 0xC0,
  0x86, 0x03, 0xC0, 0xE7, 0x10, 0x7C, 0x0E, 0x01, 0x50, 0x3C, 0x0E, 0x72, 0x0E, 0xC0, 0x85, 0x03,
  0xC0, 0xE7, 0x20, 0x8C, 0x0E, 0x01, 0x40, 0x3C, 0x0E, 0x72, 0x01, 0xD0, 0x84, 0x03, 0xC0, 0xE7,
  0x30, 0x9C, 0x0E, 0x01, 0x30, 0x3C, 0x0E, 0x73, 0x02, 0xD0, 0x83, 0x03, 0xC0, 0xE7, 0x40, 0xAC,
  0x0E, 0x01, 0x20, 0x3C, 0x0E, 0x74, 0x02, 0xD0, 0x82, 0x03, 0xC0, 0xE7, 0x50, 0xBC, 0x82, 0xE1,
  0x03, 0xC0, 0xE7, 0x50, 0x3D, 0x81, 0x80, 0x3C, 0x0E, 0x76, 0x0B, 0xC8, 0x1E, 0x13, 0xC0, 0xE7,
  0x60, 0x4D, 0x08,
  // "ř" (U+0159)
  0x82, 0x47, 0x75, 0x73, 0x83, 0x67, 0x73, 0x5B, 0x08, 0x71, 0x09, 0xB8, 0x13, 0x08, 0xB0, 0x86,
  0x0A, 0xB0, 0x63, 0x0C, 0xB0, 0x84, 0x0A, 0xB0, 0x94, 0x02, 0x0E, 0xB0, 0x72, 0x0A, 0xB0, 0xD6,
  0x05, 0xC0, 0x60, 0x9C, 0x02, 0x70, 0xAF, 0x90, 0x77, 0x10, 0x10, 0xEE, 0x0B, 0x73, 0x06, 0xE0,
  0x27, 0x40, 0xCC, 0x09, 0x80, 0x9A, 0x50, 0x84, 0x26, 0x76, 0x51, 0x20, 0xBB, 0x04, 0x30, 0x10,
  0xAD, 0x07, 0x20, 0xBB, 0x05, 0x20, 0x10, 0xDE, 0x05, 0x20, 0xBB, 0x07, 0x20, 0xCF, 0x03, 0x20,
  0xBB, 0x81, 0x80, 0x8F, 0x90, 0x12, 0x0B, 0xB0, 0xA0, 0x2C, 0x83, 0xC8, 0x8A, 0xE3, 0x0B, 0xB0,
  0xB0, 0x9A, 0x0D, 0x03, 0x40, 0x13, 0x0B, 0xE0, 0xD0, 0x17, 0x20, 0xBE, 0x04, 0x73, 0x0B, 0xD0,
  0xA7, 0x40, 0xBD, 0x03, 0x74, 0x0B, 0xC0, 0xE7, 0x50, 0xBC, 0x0A, 0x75, 0x0B, 0xC0, 0x77, 0x50,
  0xBC, 0x05, 0x75, 0x0B, 0xC0, 0x47, 0x50, 0xBC, 0x03, 0x75, 0x0B, 0xC0, 0x37, 0x50, 0xBC, 0x03,
  0x75, 0x0B, 0xC0, 0x37, 0x50, 0xBC, 0x03, 0x75, 0x0B, 0xC0, 0x37, 0x50, 0xBC, 0x03, 0x75, 0x0B,
  0xC0, 0x37, 0x50, 0xBC, 0x03, 0x75, 0x0B, 0xC0, 0x37, 0x50, 0xBC, 0x03, 0x75, 0x0B, 0xC0, 0x37,
  0x50, 0xBC, 0x03, 0x75, 0x0B, 0xC0, 0x37, 0x50, 0xBC, 0x03, 0x75, 0x0B, 0xC0, 0x37, 0x50, 0xBC,
  0x03, 0x74,
  // "Ś" (U+015A)
  0x77, 0x02, 0x80, 0x17, 0x06, 0x77, 0x20, 0xAD, 0x07, 0x77, 0x10, 0x3D, 0x0C, 0x77, 0x20, 0xCC,
  0x0E, 0x01, 0x77, 0x10, 0x6C, 0x0E, 0x03, 0x77, 0x10, 0x10, 0xEC, 0x04, 0x77, 0x20, 0xAC, 0x05,
  0x77, 0x20, 0x5C, 0x05, 0x77, 0x20, 0x10, 0xEB, 0x05, 0x77, 0x30, 0x8A, 0x0E, 0x04, 0x80, 0x9D,
  0x20, 0x86, 0x25, 0x67, 0x76, 0x42, 0x75, 0x81, 0x18, 0xDF, 0xA8, 0x1B, 0x72, 0x70, 0x7F, 0xF9,
  0x0C, 0x01, 0x40, 0xBF, 0xFA, 0x0D, 0x40, 0xBF, 0x81, 0xED, 0xDF, 0x07, 0x30, 0x6D, 0x81, 0xE7,
  0x14, 0x81, 0x26, 0xBB, 0x01, 0x30, 0xEC, 0x0D, 0x01, 0x72, 0x81, 0x18, 0xA3, 0x06, 0xD0, 0x27,
  0x72, 0x0B, 0xC0, 0x97, 0x73, 0x0E, 0xC0, 0x47, 0x73, 0xD0, 0x27, 0x72, 0x01, 0xD0, 0x17, 0x72,
  0x01, 0xD0, 0x37, 0x73, 0xD0, 0x57, 0x73, 0x0E, 0xC0, 0xA7, 0x73, 0x0B, 0xD0, 0x47, 0x72, 0x06,
  0xD0, 0xE0, 0x27, 0x71, 0x01, 0x0E, 0xD0, 0xE0, 0x57, 0x71, 0x06, 0xF0, 0xA0, 0x27, 0x70, 0xBF,
  0x90, 0x90, 0x27, 0x60, 0xBF, 0xA0, 0x90, 0x17, 0x50, 0xAF, 0xA0, 0xE0, 0x77, 0x50, 0x50, 0xEF,
  0xA0, 0xC0, 0x17, 0x50, 0x80, 0xEF, 0x90, 0xE0, 0x37, 0x50, 0x10, 0x8F, 0x90, 0xE0, 0x27, 0x60,
  0x10, 0x9F, 0x0D, 0x77, 0x10, 0x30, 0xCE, 0x07, 0x77, 0x20, 0xBD, 0x0E, 0x77, 0x30, 0xCD, 0x04,
  0x77, 0x20, 0x2D, 0x08, 0x77, 0x30, 0xBC, 0x0A, 0x77, 0x30, 0x8C, 0x0B, 0x77, 0x30, 0x6C, 0x0B,
  0x77, 0x30, 0x6C, 0x0B, 0x77, 0x30, 0x7C, 0x09, 0x77, 0x30, 0xBC, 0x06, 0x77, 0x20, 0x2D, 0x00,
  0x17, 0x71, 0x0C, 0xC8, 0x3B, 0x07, 0xC5, 0x75, 0x0A, 0xD8, 0x14, 0x07, 0xA8, 0x2E, 0xA6, 0x35,
  0x81, 0x16, 0xDD, 0x0A, 0x20, 0x7F, 0x82, 0xED, 0xDE, 0xF0, 0xD0, 0x12, 0x07, 0xFF, 0xB0, 0xC0,
  0x13, 0x06, 0xFF, 0xA0, 0x86, 0x82, 0x27, 0xBE, 0xFA, 0x81, 0xE9, 0x27, 0x48, 0x72, 0x45, 0x67,
  0x76, 0x52, 0x72,
  // "ś" (U+015B)
  0x74, 0x02, 0x80, 0x17, 0x06, 0x75, 0x0A, 0xD0, 0x77, 0x40, 0x3D, 0x0C, 0x75, 0x0C, 0xC0, 0xE0,
  0x17, 0x40, 0x6C, 0x0E, 0x03, 0x74, 0x01, 0x0E, 0xC0, 0x47, 0x50, 0xAC, 0x05, 0x75, 0x05, 0xC0,
  0x57, 0x50, 0x10, 0xEB, 0x05, 0x76, 0x08, 0xA0, 0xE0, 0x48, 0x09, 0xA7, 0x08, 0x53, 0x56, 0x76,
  0x51, 0x72, 0x81, 0x29, 0xEF, 0x81, 0xD8, 0x35, 0x08, 0xFE, 0x0B, 0x02, 0x20, 0xAF, 0xF9, 0x81,
  0x20, 0x7F, 0x81, 0xDD, 0xED, 0x82, 0xA0, 0x1E, 0xC0, 0xD0, 0x44, 0x81, 0x15, 0xBA, 0x81, 0x30,
  0x5C, 0x0C, 0x72, 0x03, 0x08, 0x20, 0x9C, 0x05, 0x76, 0x0A, 0xC0, 0x17, 0x60, 0xAC, 0x02, 0x76,
  0x09, 0xC0, 0x67, 0x60, 0x5C, 0x0D, 0x01, 0x75, 0x01, 0x0E, 0xC0, 0xD0, 0x37, 0x50, 0x8E, 0x09,
  0x01, 0x74, 0x0B, 0xE0, 0xE0, 0x77, 0x40, 0x9F, 0x0E, 0x06, 0x73, 0x06, 0x0E, 0xF0, 0xB0, 0x27,
  0x20, 0x10, 0xAF, 0x0E, 0x05, 0x73, 0x03, 0x0B, 0xF0, 0x67, 0x40, 0x30, 0xCE, 0x04, 0x75, 0x07,
  0xD0, 0xD7, 0x60, 0x5D, 0x04, 0x76, 0x09, 0xC0, 0x87, 0x60, 0x4C, 0x09, 0x76, 0x02, 0xC0, 0xA7,
  0x60, 0x4C, 0x09, 0x01, 0x75, 0x08, 0xC8, 0x27, 0xA9, 0x27, 0x20, 0x3D, 0x03, 0x0A, 0xA8, 0x1B,
  0x62, 0x48, 0x11, 0x7E, 0xC8, 0x1D, 0x0A, 0xE8, 0x1D, 0xDE, 0xF8, 0x15, 0x0A, 0xFF, 0x90, 0x82,
  0x08, 0xFF, 0x07, 0x48, 0x12, 0x8D, 0xF9, 0x81, 0xE9, 0x27, 0x18, 0x61, 0x46, 0x77, 0x65, 0x27,
  // "Ŝ" (U+015C)
  0x72, 0x84, 0x57, 0x77, 0x73, 0x77, 0x20, 0x1D, 0x0D, 0x77, 0x20, 0xAE, 0x06, 0x77, 0x04, 0xF0,
  0xE0, 0x27, 0x50, 0x10, 0xDB, 0x0C, 0x0E, 0xB0, 0xB7, 0x50, 0xAB, 0x82, 0xD1, 0x2E, 0xB0, 0x77,
  0x30, 0x5B, 0x0D, 0x01, 0x20, 0x30, 0xEB, 0x03, 0x71, 0x02, 0x0E, 0xA0, 0xD0, 0x14, 0x04, 0xB0,
  0xD0, 0x17, 0x0D, 0xA0, 0xD0, 0x26, 0x04, 0x0E, 0xA0, 0xB6, 0x08, 0xA0, 0xD0, 0x17, 0x10, 0x30,
  0xDA, 0x06, 0x80, 0x9C, 0x30, 0x86, 0x25, 0x67, 0x76, 0x42, 0x75, 0x81, 0x18, 0xDF, 0xA8, 0x1B,
  0x72, 0x70, 0x7F, 0xF9, 0x0C, 0x01, 0x40, 0xBF, 0xFA, 0x0D, 0x40, 0xBF, 0x81, 0xED, 0xDF, 0x07,
  0x30, 0x6D, 0x81, 0xE7, 0x14, 0x81, 0x26, 0xBB, 0x01, 0x30, 0xEC, 0x0D, 0x01, 0x72, 0x81, 0x18,
  0xA3, 0x06, 0xD0, 0x27, 0x72, 0x0B, 0xC0, 0x97, 0x73, 0x0E, 0xC0, 0x47, 0x73, 0xD0, 0x27, 0x72,
  0x01, 0xD0, 0x17, 0x72, 0x01, 0xD0, 0x37, 0x73, 0xD0, 0x57, 0x73, 0x0E, 0xC0, 0xA7, 0x73, 0x0B,
  0xD0, 0x47, 0x72, 0x06, 0xD0, 0xE0, 0x27, 0x71, 0x01, 0x0E, 0xD0, 0xE0, 0x57, 0x71, 0x06, 0xF0,
  0xA0, 0x27, 0x70, 0xBF, 0x90, 0x90, 0x27, 0x60, 0xBF, 0xA0, 0x90, 0x17, 0x50, 0xAF, 0xA0, 0xE0,
  0x77, 0x50, 0x50, 0xEF, 0xA0, 0xC0, 0x17, 0x50, 0x80, 0xEF, 0x90, 0xE0, 0x37, 0x50, 0x10, 0x8F,
  0x90, 0xE0, 0x27, 0x60, 0x10, 0x9F, 0x0D, 0x77, 0x10, 0x30, 0xCE, 0x07, 0x77, 0x20, 0xBD, 0x0E,
  0x77, 0x30, 0xCD, 0x04, 0x77, 0x20, 0x2D, 0x08, 0x77, 0x30, 0xBC, 0x0A, 0x77, 0x30, 0x8C, 0x0B,
  0x77, 0x30, 0x6C, 0x0B, 0x77, 0x30, 0x6C, 0x0B, 0x77, 0x30, 0x7C, 0x09, 0x77, 0x30, 0xBC, 0x06,
  0x77, 0x20, 0x2D, 0x00, 0x17, 0x71, 0x0C, 0xC8, 0x3B, 0x07, 0xC5, 0x75, 0x0A, 0xD8, 0x14, 0x07,
  0xA8, 0x2E, 0xA6, 0x35, 0x81, 0x16, 0xDD, 0x0A, 0x20, 0x7F, 0x82, 0xED, 0xDE, 0xF0, 0xD0, 0x12,
  0x07, 0xFF, 0xB0, 0xC0, 0x13, 0x06, 0xFF, 0xA0, 0x86, 0x82, 0x27, 0xBE, 0xFA, 0x81, 0xE9, 0x27,
  0x48, 0x72, 0x45, 0x67, 0x76, 0x52, 0x72,
  // "ŝ" (U+015D)
  0x78, 0x45, 0x77, 0x77, 0x37, 0x50, 0x1D, 0x0D, 0x75, 0x0A, 0xE0, 0x67, 0x30, 0x4F, 0x0E, 0x02,
  0x71, 0x01, 0x0D, 0xB0, 0xC0, 0xEB, 0x0B, 0x71, 0x0A, 0xB8, 0x2D, 0x12, 0xEB, 0x07, 0x60, 0x5B,
  0x0D, 0x01, 0x20, 0x30, 0xEB, 0x03, 0x40, 0x20, 0xEA, 0x0D, 0x01, 0x40, 0x4B, 0x0D, 0x01, 0x30,
  0xDA, 0x0D, 0x02, 0x60, 0x40, 0xEA, 0x0B, 0x20, 0x8A, 0x0D, 0x01, 0x71, 0x03, 0x0D, 0xA0, 0x68,
  0x09, 0x97, 0x08, 0x53, 0x56, 0x76, 0x51, 0x72, 0x81, 0x29, 0xEF, 0x81, 0xD8, 0x35, 0x08, 0xFE,
  0x0B, 0x02, 0x20, 0xAF, 0xF9, 0x81, 0x20, 0x7F, 0x81, 0xDD, 0xED, 0x82, 0xA0, 0x1E, 0xC0, 0xD0,
  0x44, 0x81, 0x15, 0xBA, 0x81, 0x30, 0x5C, 0x0C, 0x72, 0x03, 0x08, 0x20, 0x9C, 0x05, 0x76, 0x0A,
  0xC0, 0x17, 0x60, 0xAC, 0x02, 0x76, 0x09, 0xC0, 0x67, 0x60, 0x5C, 0x0D, 0x01, 0x75, 0x01, 0x0E,
  0xC0, 0xD0, 0x37, 0x50, 0x8E, 0x09, 0x01, 0x74, 0x0B, 0xE0, 0xE0, 0x77, 0x40, 0x9F, 0x0E, 0x06,
  0x73, 0x06, 0x0E, 0xF0, 0xB0, 0x27, 0x20, 0x10, 0xAF, 0x0E, 0x05, 0x73, 0x03, 0x0B, 0xF0, 0x67,
  0x40, 0x30, 0xCE, 0x04, 0x75, 0x07, 0xD0, 0xD7, 0x60, 0x5D, 0x04, 0x76, 0x09, 0xC0, 0x87, 0x60,
  0x4C, 0x09, 0x76, 0x02, 0xC0, 0xA7, 0x60, 0x4C, 0x09, 0x01, 0x75, 0x08, 0xC8, 0x27, 0xA9, 0x27,
  0x20, 0x3D, 0x03, 0x0A, 0xA8, 0x1B, 0x62, 0x48, 0x11, 0x7E, 0xC8, 0x1D, 0x0A, 0xE8, 0x1D, 0xDE,
  0xF8, 0x15, 0x0A, 0xFF, 0x90, 0x82, 0x08, 0xFF, 0x07, 0x48, 0x12, 0x8D, 0xF9, 0x81, 0xE9, 0x27,
  0x18, 0x61, 0x46, 0x77, 0x65, 0x27,
  // "Ş" (U+015E)
  0x72, 0x86, 0x25, 0x67, 0x76, 0x42, 0x75, 0x81, 0x18, 0xDF, 0xA8, 0x1B, 0x72, 0x70, 0x7F, 0xF9,
  0x0C, 0x01, 0x40, 0xBF, 0xFA, 0x0D, 0x40, 0xBF, 0x81, 0xED, 0xDF, 0x07, 0x30, 0x6D, 0x81, 0xE7,
  0x14, 0x81, 0x26, 0xBB, 0x01, 0x30, 0xEC, 0x0D, 0x01, 0x72, 0x81, 0x18, 0xA3, 0x06, 0xD0, 0x27,
  0x72, 0x0B, 0xC0, 0x97, 0x73, 0x0E, 0xC0, 0x47, 0x73, 0xD0, 0x27, 0x72, 0x01, 0xD0, 0x17, 0x72,
  0x01, 0xD0, 0x37, 0x73, 0xD0, 0x57, 0x73, 0x0E, 0xC0, 0xA7, 0x73, 0x0B, 0xD0, 0x47, 0x72, 0x06,
  0xD0, 0xE0, 0x27, 0x71, 0x01, 0x0E, 0xD0, 0xE0, 0x57, 0x71, 0x06, 0xF0, 0xA0, 0x27, 0x70, 0xBF,
  0x90, 0x90, 0x27, 0x60, 0xBF, 0xA0, 0x90, 0x17, 0x50, 0xAF, 0xA0, 0xE0, 0x77, 0x50, 0x50, 0xEF,
  0xA0, 0xC0, 0x17, 0x50, 0x80, 0xEF, 0x90, 0xE0, 0x37, 0x50, 0x10, 0x8F, 0x90, 0xE0, 0x27, 0x60,
  0x10, 0x9F, 0x0D, 0x77, 0x10, 0x30, 0xCE, 0x07, 0x77, 0x20, 0xBD, 0x0E, 0x77, 0x30, 0xCD, 0x04,
  0x77, 0x20, 0x2D, 0x08, 0x77, 0x30, 0xBC, 0x0A, 0x77, 0x30, 0x8C, 0x0B, 0x77, 0x30, 0x6C, 0x0B,
  0x77, 0x30, 0x6C, 0x0B, 0x77, 0x30, 0x7C, 0x09, 0x77, 0x30, 0xBC, 0x06, 0x77, 0x20, 0x2D, 0x00,
  0x17, 0x71, 0x0C, 0xC8, 0x3B, 0x07, 0xC5, 0x75, 0x0A, 0xD8, 0x14, 0x07, 0xA8, 0x2E, 0xA6, 0x35,
  0x81, 0x16, 0xDD, 0x0A, 0x20, 0x7F, 0x82, 0xED, 0xDE, 0xF0, 0xD0, 0x12, 0x07, 0xFF, 0xB0, 0xC0,
  0x13, 0x06, 0xFF, 0xA0, 0x86, 0x82, 0x27, 0xBE, 0xFA, 0x81, 0xE9, 0x27, 0x48, 0x22, 0x45, 0x6B,
  0x0C, 0x02, 0x77, 0x30, 0x1A, 0x0E, 0x77, 0x50, 0x8A, 0x0A, 0x77, 0x50, 0xEB, 0x0E, 0x08, 0x77,
  0x20, 0x30, 0xCD, 0x0D, 0x02, 0x77, 0x30, 0x60, 0xDB, 0x0D, 0x77, 0x40, 0x10, 0xEB, 0x04, 0x77,
  0x40, 0x9B, 0x07, 0x77, 0x40, 0xAB, 0x07, 0x77, 0x30, 0x10, 0xEB, 0x05, 0x74, 0x01, 0x02, 0x28,
  0x11, 0x5C, 0xB0, 0xE7, 0x50, 0x5F, 0xA0, 0x67, 0x50, 0x5F, 0x0E, 0x06, 0x76, 0x81, 0x3C, 0xEA,
  0x82, 0xEB, 0x71, 0x72,
  // "ş" (U+015F)
  0x78, 0x53, 0x56, 0x76, 0x51, 0x72, 0x81, 0x29, 0xEF, 0x81, 0xD8, 0x35, 0x08, 0xFE, 0x0B, 0x02,
  0x20, 0xAF, 0xF9, 0x81, 0x20, 0x7F, 0x81, 0xDD, 0xED, 0x82, 0xA0, 0x1E, 0xC0, 0xD0, 0x44, 0x81,
  0x15, 0xBA, 0x81, 0x30, 0x5C, 0x0C, 0x72, 0x03, 0x08, 0x20, 0x9C, 0x05, 0x76, 0x0A, 0xC0, 0x17,
  0x60, 0xAC, 0x02, 0x76, 0x09, 0xC0, 0x67, 0x60, 0x5C, 0x0D, 0x01, 0x75, 0x01, 0x0E, 0xC0, 0xD0,
  0x37, 0x50, 0x8E, 0x09, 0x01, 0x74, 0x0B, 0xE0, 0xE0, 0x77, 0x40, 0x9F, 0x0E, 0x06, 0x73, 0x06,
  0x0E, 0xF0, 0xB0, 0x27, 0x20, 0x10, 0xAF, 0x0E, 0x05, 0x73, 0x03, 0x0B, 0xF0, 0x67, 0x40, 0x30,
  0xCE, 0x04, 0x75, 0x07, 0xD0, 0xD7, 0x60, 0x5D, 0x04, 0x76, 0x09, 0xC0, 0x87, 0x60, 0x4C, 0x09,
  0x76, 0x02, 0xC0, 0xA7, 0x60, 0x4C, 0x09, 0x01, 0x75, 0x08, 0xC8, 0x27, 0xA9, 0x27, 0x20, 0x3D,
  0x03, 0x0A, 0xA8, 0x1B, 0x62, 0x48, 0x11, 0x7E, 0xC8, 0x1D, 0x0A, 0xE8, 0x1D, 0xDE, 0xF8, 0x15,
  0x0A, 0xFF, 0x90, 0x82, 0x08, 0xFF, 0x07, 0x48, 0x12, 0x8D, 0xF9, 0x81, 0xE9, 0x27, 0x18, 0x11,
  0x46, 0xB0, 0xC0, 0x27, 0x60, 0x1A, 0x0E, 0x77, 0x10, 0x8A, 0x0A, 0x77, 0x10, 0xEB, 0x0E, 0x08,
  0x75, 0x03, 0x0C, 0xD0, 0xD0, 0x27, 0x60, 0x60, 0xDB, 0x0D, 0x77, 0x01, 0x0E, 0xB0, 0x47, 0x70,
  0x9B, 0x07, 0x77, 0x0A, 0xB0, 0x77, 0x60, 0x10, 0xEB, 0x05, 0x70, 0x10, 0x22, 0x81, 0x15, 0xCB,
  0x0E, 0x71, 0x05, 0xFA, 0x06, 0x71, 0x05, 0xF0, 0xE0, 0x67, 0x28, 0x13, 0xCE, 0xA8, 0x2E, 0xB7,
  0x17,
  // "Š" (U+0160)
  0x38, 0x24, 0x77, 0x57, 0x38, 0x26, 0x77, 0x35, 0x05, 0xB0, 0x87, 0x10, 0x9B, 0x03, 0x60, 0x8B,
  0x08, 0x60, 0xAB, 0x06, 0x71, 0x0C, 0xB0, 0x84, 0x0A, 0xB0, 0x97, 0x20, 0x20, 0xEB, 0x07, 0x20,
  0xAB, 0x0D, 0x74, 0x05, 0xC0, 0x60, 0x9C, 0x02, 0x75, 0x0A, 0xF9, 0x07, 0x76, 0x01, 0x0E, 0xE0,
  0xB7, 0x71, 0x06, 0xE0, 0x27, 0x72, 0x0C, 0xC0, 0x98, 0x09, 0xD1, 0x08, 0x62, 0x56, 0x77, 0x64,
  0x27, 0x58, 0x11, 0x8D, 0xFA, 0x81, 0xB7, 0x27, 0x07, 0xFF, 0x90, 0xC0, 0x14, 0x0B, 0xFF, 0xA0,
  0xD4, 0x0B, 0xF8, 0x1E, 0xDD, 0xF0, 0x73, 0x06, 0xD8, 0x1E, 0x71, 0x48, 0x12, 0x6B, 0xB0, 0x13,
  0x0E, 0xC0, 0xD0, 0x17, 0x28, 0x11, 0x8A, 0x30, 0x6D, 0x02, 0x77, 0x20, 0xBC, 0x09, 0x77, 0x30,
  0xEC, 0x04, 0x77, 0x3D, 0x02, 0x77, 0x20, 0x1D, 0x01, 0x77, 0x20, 0x1D, 0x03, 0x77, 0x3D, 0x05,
  0x77, 0x30, 0xEC, 0x0A, 0x77, 0x30, 0xBD, 0x04, 0x77, 0x20, 0x6D, 0x0E, 0x02, 0x77, 0x10, 0x10,
  0xED, 0x0E, 0x05, 0x77, 0x10, 0x6F, 0x0A, 0x02, 0x77, 0x0B, 0xF9, 0x09, 0x02, 0x76, 0x0B, 0xFA,
  0x09, 0x01, 0x75, 0x0A, 0xFA, 0x0E, 0x07, 0x75, 0x05, 0x0E, 0xFA, 0x0C, 0x01, 0x75, 0x08, 0x0E,
  0xF9, 0x0E, 0x03, 0x75, 0x01, 0x08, 0xF9, 0x0E, 0x02, 0x76, 0x01, 0x09, 0xF0, 0xD7, 0x71, 0x03,
  0x0C, 0xE0, 0x77, 0x72, 0x0B, 0xD0, 0xE7, 0x73, 0x0C, 0xD0, 0x47, 0x72, 0x02, 0xD0, 0x87, 0x73,
  0x0B, 0xC0, 0xA7, 0x73, 0x08, 0xC0, 0xB7, 0x73, 0x06, 0xC0, 0xB7, 0x73, 0x06, 0xC0, 0xB7, 0x73,
  0x07, 0xC0, 0x97, 0x73, 0x0B, 0xC0, 0x67, 0x72, 0x02, 0xD0, 0x01, 0x77, 0x10, 0xCC, 0x83, 0xB0,
  0x7C, 0x57, 0x50, 0xAD, 0x81, 0x40, 0x7A, 0x82, 0xEA, 0x63, 0x58, 0x11, 0x6D, 0xD0, 0xA2, 0x07,
  0xF8, 0x2E, 0xDD, 0xEF, 0x0D, 0x01, 0x20, 0x7F, 0xFB, 0x0C, 0x01, 0x30, 0x6F, 0xFA, 0x08, 0x68,
  0x22, 0x7B, 0xEF, 0xA8, 0x1E, 0x92, 0x74, 0x87, 0x24, 0x56, 0x77, 0x65, 0x27, 0x20,
  // "š" (U+0161)
  0x18, 0x24, 0x77, 0x57, 0x38, 0x46, 0x77, 0x30, 0x5B, 0x08, 0x71, 0x09, 0xB0, 0x32, 0x08, 0xB0,
  0x86, 0x0A, 0xB0, 0x64, 0x0C, 0xB0, 0x84, 0x0A, 0xB0, 0x95, 0x02, 0x0E, 0xB0, 0x72, 0x0A, 0xB0,
  0xD7, 0x05, 0xC0, 0x60, 0x9C, 0x02, 0x71, 0x0A, 0xF9, 0x07, 0x72, 0x01, 0x0E, 0xE0, 0xB7, 0x40,
  0x6E, 0x02, 0x75, 0x0C, 0xC0, 0x98, 0x09, 0xA5, 0x08, 0x53, 0x56, 0x76, 0x51, 0x72, 0x81, 0x29,
  0xEF, 0x81, 0xD8, 0x35, 0x08, 0xFE, 0x0B, 0x02, 0x20, 0xAF, 0xF9, 0x81, 0x20, 0x7F, 0x81, 0xDD,
  0xED, 0x82, 0xA0, 0x1E, 0xC0, 0xD0, 0x44, 0x81, 0x15, 0xBA, 0x81, 0x30, 0x5C, 0x0C, 0x72, 0x03,
  0x08, 0x20, 0x9C, 0x05, 0x76, 0x0A, 0xC0, 0x17, 0x60, 0xAC, 0x02, 0x76, 0x09, 0xC0, 0x67, 0x60,
  0x5C, 0x0D, 0x01, 0x75, 0x01, 0x0E, 0xC0, 0xD0, 0x37, 0x50, 0x8E, 0x09, 0x01, 0x74, 0x0B, 0xE0,
  0xE0, 0x77, 0x40, 0x9F, 0x0E, 0x06, 0x73, 0x06, 0x0E, 0xF0, 0xB0, 0x27, 0x20, 0x10, 0xAF, 0x0E,
  0x05, 0x73, 0x03, 0x0B, 0xF0, 0x67, 0x40, 0x30, 0xCE, 0x04, 0x75, 0x07, 0xD0, 0xD7, 0x60, 0x5D,
  0x04, 0x76, 0x09, 0xC0, 0x87, 0x60, 0x4C, 0x09, 0x76, 0x02, 0xC0, 0xA7, 0x60, 0x4C, 0x09, 0x01,
  0x75, 0x08, 0xC8, 0x27, 0xA9, 0x27, 0x20, 0x3D, 0x03, 0x0A, 0xA8, 0x1B, 0x62, 0x48, 0x11, 0x7E,
  0xC8, 0x1D, 0x0A, 0xE8, 0x1D, 0xDE, 0xF8, 0x15, 0x0A, 0xFF, 0x90, 0x82, 0x08, 0xFF, 0x07, 0x48,
  0x12, 0x8D, 0xF9, 0x81, 0xE9, 0x27, 0x18, 0x61, 0x46, 0x77, 0x65, 0x27,
  // "Ţ" (U+0162)
  0x06, 0xFF, 0xFB, 0x04, 0x06, 0xFF, 0xFB, 0x04, 0x06, 0xFF, 0xFB, 0x04, 0x06, 0xFF, 0xFB, 0x04,
  0x02, 0x80, 0x55, 0x0A, 0xC0, 0xA8, 0x05, 0x50, 0x17, 0x30, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08,
  0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08,
  0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08,
  0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08,
  0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08,
  0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08,
  0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08,
  0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08,
  0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08,
  0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08, 0x77, 0x60, 0x8C, 0x08,
  0x77, 0x70, 0x9A, 0x06, 0x77, 0x70, 0x1A, 0x0E, 0x77, 0x71, 0x08, 0xA0, 0xA7, 0x77, 0x10, 0xEB,
  0x0E, 0x08, 0x77, 0x50, 0x30, 0xCD, 0x0D, 0x02, 0x77, 0x60, 0x60, 0xDB, 0x0D, 0x77, 0x70, 0x10,
  0xEB, 0x04, 0x77, 0x70, 0x9B, 0x07, 0x77, 0x70, 0xAB, 0x07, 0x77, 0x60, 0x10, 0xEB, 0x05, 0x77,
  0x01, 0x02, 0x28, 0x11, 0x5C, 0xB0, 0xE7, 0x71, 0x05, 0xFA, 0x06, 0x77, 0x10, 0x5F, 0x0E, 0x06,
  0x77, 0x28, 0x13, 0xCE, 0xA8, 0x2E, 0xB7, 0x17, 0x30,
  // "ţ" (U+0163)
  0x50, 0xDA, 0x07, 0x74, 0x01, 0xB0, 0x77, 0x40, 0x4B, 0x07, 0x74, 0x07, 0xB0, 0x77, 0x40, 0xAB,
  0x07, 0x74, 0x0D, 0xB0, 0x77, 0x4C, 0x07, 0x73, 0x03, 0xC0, 0x77, 0x18, 0x11, 0x8E, 0xFC, 0x10,
  0x9F, 0xF1, 0xFF, 0x91, 0xFF, 0x91, 0x0F, 0x50, 0xAC, 0x0A, 0x80, 0x25, 0x40, 0x8C, 0x07, 0x73,
  0x08, 0xC0, 0x77, 0x30, 0x8C, 0x07, 0x73, 0x08, 0xC0, 0x77, 0x30, 0x8C, 0x07, 0x73, 0x08, 0xC0,
  0x77, 0x30, 0x8C, 0x07, 0x73, 0x08, 0xC0, 0x77, 0x30, 0x8C, 0x07, 0x73, 0x08, 0xC0, 0x77, 0x30,
  0x8C, 0x07, 0x73, 0x08, 0xC0, 0x77, 0x30, 0x8C, 0x07, 0x73, 0x08, 0xC0, 0x77, 0x30, 0x8C, 0x07,
  0x73, 0x08, 0xC0, 0x77, 0x30, 0x8C, 0x07, 0x73, 0x08, 0xC0, 0x77, 0x30, 0x8C, 0x07, 0x73, 0x08,
  0xC0, 0x87, 0x30, 0x7C, 0x0B, 0x73, 0x05, 0xD0, 0x17, 0x20, 0x1D, 0x0C, 0x02, 0x30, 0x02, 0x40,
  0xCE, 0x83, 0xDD, 0xEF, 0x54, 0x04, 0xFB, 0x05, 0x50, 0x8F, 0xA0, 0x56, 0x05, 0xF0, 0xD0, 0x37,
  0x0A, 0xA8, 0x2E, 0x65, 0x27, 0x10, 0x1A, 0x0E, 0x75, 0x08, 0xA0, 0xA7, 0x50, 0xEB, 0x0E, 0x08,
  0x72, 0x03, 0x0C, 0xD0, 0xD0, 0x27, 0x30, 0x60, 0xDB, 0x0D, 0x74, 0x01, 0x0E, 0xB0, 0x47, 0x40,
  0x9B, 0x07, 0x74, 0x0A, 0xB0, 0x77, 0x30, 0x10, 0xEB, 0x05, 0x40, 0x10, 0x22, 0x81, 0x15, 0xCB,
  0x0E, 0x50, 0x5F, 0xA0, 0x65, 0x05, 0xF0, 0xE0, 0x66, 0x81, 0x3C, 0xEA, 0x82, 0xEB, 0x71, 0x40,
  // "Ť" (U+0164)
  0x48, 0x24, 0x77, 0x57, 0x38, 0x26, 0x77, 0x37, 0x10, 0x5B, 0x08, 0x71, 0x09, 0xB0, 0x37, 0x20,
  0x8B, 0x08, 0x60, 0xAB, 0x06, 0x74, 0x0C, 0xB0, 0x84, 0x0A, 0xB0, 0x97, 0x50, 0x20, 0xEB, 0x07,
  0x20, 0xAB, 0x0D, 0x77, 0x05, 0xC0, 0x60, 0x9C, 0x02, 0x77, 0x10, 0xAF, 0x90, 0x77, 0x72, 0x01,
  0x0E, 0xE0, 0xB7, 0x74, 0x06, 0xE0, 0x27, 0x75, 0x0C, 0xC0, 0x98, 0x0A, 0x90, 0x00, 0x6F, 0xFF,
  0xB0, 0x40, 0x6F, 0xFF, 0xB0, 0x40, 0x6F, 0xFF, 0xB0, 0x40, 0x6F, 0xFF, 0xB0, 0x40, 0x28, 0x05,
  0x50, 0xAC, 0x0A, 0x80, 0x55, 0x01, 0x73, 0x08, 0xC0, 0x87, 0x76, 0x08, 0xC0, 0x87, 0x76, 0x08,
  0xC0, 0x87, 0x76, 0x08, 0xC0, 0x87, 0x76, 0x08, 0xC0, 0x87, 0x76, 0x08, 0xC0, 0x87, 0x76, 0x08,
  0xC0, 0x87, 0x76, 0x08, 0xC0, 0x87, 0x76, 0x08, 0xC0, 0x87, 0x76, 0x08, 0xC0, 0x87, 0x76, 0x08,
  0xC0, 0x87, 0x76, 0x08, 0xC0, 0x87, 0x76, 0x08, 0xC0, 0x87, 0x76, 0x08, 0xC0, 0x87, 0x76, 0x08,
  0xC0, 0x87, 0x76, 0x08, 0xC0, 0x87, 0x76, 0x08, 0xC0, 0x87, 0x76, 0x08, 0xC0, 0x87, 0x76, 0x08,
  0xC0, 0x87, 0x76, 0x08, 0xC0, 0x87, 0x76, 0x08, 0xC0, 0x87, 0x76, 0x08, 0xC0, 0x87, 0x76, 0x08,
  0xC0, 0x87, 0x76, 0x08, 0xC0, 0x87, 0x76, 0x08, 0xC0, 0x87, 0x76, 0x08, 0xC0, 0x87, 0x76, 0x08,
  0xC0, 0x87, 0x76, 0x08, 0xC0, 0x87, 0x76, 0x08, 0xC0, 0x87, 0x76, 0x08, 0xC0, 0x87, 0x76, 0x08,
  0xC0, 0x87, 0x76, 0x08, 0xC0, 0x87, 0x76, 0x08, 0xC0, 0x87, 0x76, 0x08, 0xC0, 0x87, 0x76, 0x08,
  0xC0, 0x87, 0x76, 0x08, 0xC0, 0x87, 0x76, 0x08, 0xC0, 0x87, 0x76, 0x08, 0xC0, 0x87, 0x30,
  // "ť" (U+0165)
  0x77, 0x30, 0xBC, 0x06, 0x77, 0x30, 0xDC, 0x03, 0x77, 0x30, 0xEB, 0x0D, 0x77, 0x30, 0x1C, 0x08,
  0x77, 0x30, 0x4C, 0x02, 0x77, 0x30, 0x6B, 0x0B, 0x70, 0xDA, 0x07, 0x70, 0x9B, 0x05, 0x60, 0x1B,
  0x07, 0x70, 0xCA, 0x0D, 0x70, 0x4B, 0x07, 0x7B, 0x06, 0x70, 0x7B, 0x07, 0x60, 0x2A, 0x0C, 0x71,
  0x0A, 0xB0, 0x77, 0x74, 0x0D, 0xB0, 0x77, 0x74, 0xC0, 0x77, 0x73, 0x03, 0xC0, 0x77, 0x71, 0x81,
  0x18, 0xEF, 0xC7, 0x10, 0x9F, 0xF7, 0x1F, 0xF9, 0x71, 0xFF, 0x97, 0x10, 0xF5, 0x0A, 0xC0, 0xA8,
  0x02, 0x57, 0x40, 0x8C, 0x07, 0x77, 0x30, 0x8C, 0x07, 0x77, 0x30, 0x8C, 0x07, 0x77, 0x30, 0x8C,
  0x07, 0x77, 0x30, 0x8C, 0x07, 0x77, 0x30, 0x8C, 0x07, 0x77, 0x30, 0x8C, 0x07, 0x77, 0x30, 0x8C,
  0x07, 0x77, 0x30, 0x8C, 0x07, 0x77, 0x30, 0x8C, 0x07, 0x77, 0x30, 0x8C, 0x07, 0x77, 0x30, 0x8C,
  0x07, 0x77, 0x30, 0x8C, 0x07, 0x77, 0x30, 0x8C, 0x07, 0x77, 0x30, 0x8C, 0x07, 0x77, 0x30, 0x8C,
  0x07, 0x77, 0x30, 0x8C, 0x07, 0x77, 0x30, 0x8C, 0x07, 0x77, 0x30, 0x8C, 0x07, 0x77, 0x30, 0x8C,
  0x08, 0x77, 0x30, 0x7C, 0x0B, 0x77, 0x30, 0x5D, 0x01, 0x77, 0x20, 0x1D, 0x0C, 0x02, 0x30, 0x02,
  0x74, 0x0C, 0xE8, 0x3D, 0xDE, 0xF5, 0x74, 0x04, 0xFB, 0x05, 0x75, 0x08, 0xFA, 0x05, 0x76, 0x05,
  0x0D, 0xE0, 0xD0, 0x37, 0x71, 0x84, 0x36, 0x76, 0x52, 0x72,
  // "Ŧ" (U+0166)
  0x06, 0xFF, 0xFB, 0x04, 0x06, 0xFF, 0xFB, 0x04, 0x06, 0xFF, 0xFB, 0x04, 0x06, 0xFF, 0xFB, 0x04,
  0x02, 0x80, 0x55, 0x0B, 0xC0, 0xA8, 0x05, 0x50, 0x17, 0x30, 0x9C, 0x08, 0x77, 0x60, 0x9C, 0x08,
  0x77, 0x60, 0x9C, 0x08, 0x77, 0x60, 0x9C, 0x08, 0x77, 0x60, 0x9C, 0x08, 0x77, 0x60, 0x9C, 0x08,
  0x77, 0x60, 0x9C, 0x08, 0x77, 0x60, 0x9C, 0x08, 0x77, 0x60, 0x9C, 0x08, 0x77, 0x60, 0x9C, 0x08,
  0x77, 0x60, 0x9C, 0x08, 0x77, 0x60, 0x9C, 0x08, 0x77, 0x60, 0x9C, 0x08, 0x77, 0x60, 0x9C, 0x08,
  0x76, 0x08, 0xFF, 0xC0, 0x66, 0x08, 0xFF, 0xC0, 0x66, 0x08, 0xFF, 0xC0, 0x66, 0x08, 0xFF, 0xC0,
  0x66, 0x02, 0x80, 0x25, 0x0B, 0xC0, 0xA8, 0x02, 0x50, 0x27, 0x60, 0x9C, 0x08, 0x77, 0x60, 0x9C,
  0x08, 0x77, 0x60, 0x9C, 0x08, 0x77, 0x60, 0x9C, 0x08, 0x77, 0x60, 0x9C, 0x08, 0x77, 0x60, 0x9C,
  0x08, 0x77, 0x60, 0x9C, 0x08, 0x77, 0x60, 0x9C, 0x08, 0x77, 0x60, 0x9C, 0x08, 0x77, 0x60, 0x9C,
  0x08, 0x77, 0x60, 0x9C, 0x08, 0x77, 0x60, 0x9C, 0x08, 0x77, 0x60, 0x9C, 0x08, 0x77, 0x60, 0x9C,
  0x08, 0x77, 0x60, 0x9C, 0x08, 0x77, 0x60, 0x9C, 0x08, 0x77, 0x60, 0x9C, 0x08, 0x77, 0x60, 0x9C,
  0x08, 0x77, 0x60, 0x9C, 0x08, 0x73,
  // "ŧ" (U+0167)
  0x50, 0xDA, 0x07, 0x74, 0x01, 0xB0, 0x77, 0x40, 0x4B, 0x07, 0x74, 0x07, 0xB0, 0x77, 0x40, 0xAB,
  0x07, 0x74, 0x0D, 0xB0, 0x77, 0x4C, 0x07, 0x73, 0x03, 0xC0, 0x77, 0x18, 0x11, 0x8E, 0xFC, 0x10,
  0x9F, 0xF1, 0xFF, 0x91, 0xFF, 0x91, 0x0F, 0x50, 0xAC, 0x0A, 0x80, 0x25, 0x40, 0x8C, 0x07, 0x73,
  0x08, 0xC0, 0x77, 0x30, 0x8C, 0x07, 0x73, 0x08, 0xC0, 0x77, 0x30, 0x8C, 0x07, 0x78, 0x24, 0x55,
  0xAC, 0x0A, 0x80, 0x15, 0x81, 0x30, 0xCF, 0xE8, 0x1B, 0x0C, 0xFE, 0x81, 0xB0, 0xCF, 0xE8, 0x1B,
  0x0C, 0xFE, 0x0B, 0x40, 0x8C, 0x07, 0x73, 0x08, 0xC0, 0x77, 0x30, 0x8C, 0x07, 0x73, 0x08, 0xC0,
  0x77, 0x30, 0x8C, 0x07, 0x73, 0x08, 0xC0, 0x77, 0x30, 0x8C, 0x07, 0x73, 0x08, 0xC0, 0x77, 0x30,
  0x8C, 0x07, 0x73, 0x07, 0xC0, 0x97, 0x30, 0x6C, 0x0B, 0x73, 0x04, 0xD0, 0x27, 0x20, 0x1D, 0x0C,
  0x02, 0x30, 0x30, 0x24, 0x0B, 0xE8, 0x3D, 0xDE, 0xF5, 0x40, 0x3F, 0xB0, 0x55, 0x07, 0xFA, 0x05,
  0x60, 0x40, 0xDE, 0x0D, 0x03, 0x71, 0x84, 0x36, 0x76, 0x52, 0x20,
  // "Ũ" (U+0168)
  0x78, 0x45, 0xCE, 0xEB, 0x67, 0x0B, 0xA0, 0x57, 0x20, 0x8E, 0x0E, 0x07, 0x40, 0x3B, 0x03, 0x71,
  0x03, 0xFA, 0x83, 0xE9, 0x66, 0xEA, 0x0E, 0x72, 0x0A, 0xFF, 0xA0, 0x97, 0x10, 0x1B, 0x82, 0xD6,
  0x6A, 0xFB, 0x02, 0x71, 0x04, 0xA0, 0xE0, 0x13, 0x01, 0x09, 0xF0, 0x67, 0x20, 0x7A, 0x09, 0x68,
  0x51, 0x7C, 0xEE, 0xB4, 0x80, 0xA9, 0x10, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09,
  0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C,
  0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0,
  0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08,
  0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C,
  0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10,
  0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08,
  0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71,
  0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90,
  0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77,
  0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09,
  0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97,
  0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x9C, 0x08, 0x07, 0xC0, 0xA7, 0x71, 0x09, 0xC0,
  0x70, 0x6C, 0x0B, 0x77, 0x10, 0xAC, 0x06, 0x04, 0xC0, 0xD7, 0x71, 0x0D, 0xC0, 0x50, 0x1D, 0x01,
  0x77, 0xD8, 0x12, 0x0D, 0xC0, 0x67, 0x60, 0x5C, 0x0E, 0x20, 0x9C, 0x0C, 0x76, 0x0B, 0xC0, 0xA2,
  0x03, 0xD0, 0x77, 0x40, 0x5D, 0x04, 0x30, 0xBD, 0x07, 0x72, 0x04, 0xD0, 0xD4, 0x02, 0xE8, 0x1C,
  0x51, 0x40, 0x40, 0xAE, 0x03, 0x50, 0x6F, 0x98, 0x1E, 0xDD, 0xF9, 0x08, 0x70, 0x6F, 0xFB, 0x08,
  0x72, 0x04, 0x0D, 0xFE, 0x0E, 0x05, 0x75, 0x05, 0x0B, 0xFA, 0x0C, 0x06, 0x77, 0x38, 0x53, 0x56,
  0x76, 0x54, 0x73,
  // "ũ" (U+0169)
  0x48, 0x45, 0xCE, 0xEB, 0x67, 0x0B, 0xA0, 0x54, 0x08, 0xE0, 0xE0, 0x74, 0x03, 0xB0, 0x33, 0x03,
  0xFA, 0x83, 0xE9, 0x66, 0xEA, 0x0E, 0x40, 0xAF, 0xFA, 0x09, 0x30, 0x1B, 0x82, 0xD6, 0x6A, 0xFB,
  0x02, 0x30, 0x4A, 0x0E, 0x01, 0x30, 0x10, 0x9F, 0x06, 0x40, 0x7A, 0x09, 0x68, 0x51, 0x7C, 0xEE,
  0xB4, 0x80, 0x9D, 0x60, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D,
  0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D,
  0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D,
  0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D,
  0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x30,
  0x1D, 0x0E, 0xC0, 0x17, 0x30, 0x1D, 0x0E, 0xC0, 0x17, 0x30, 0x3D, 0x0D, 0xC0, 0x17, 0x30, 0x5D,
  0x0D, 0xC0, 0x37, 0x30, 0x8D, 0x0B, 0xC0, 0x57, 0x30, 0xCD, 0x09, 0xC0, 0x87, 0x20, 0x2E, 0x06,
  0xC0, 0xD7, 0x20, 0xAE, 0x02, 0xD0, 0x77, 0x06, 0xF1, 0x0C, 0xD0, 0x80, 0x13, 0x03, 0x0A, 0xB0,
  0xDC, 0x10, 0x4F, 0x00, 0xDD, 0x00, 0x8C, 0x20, 0xAF, 0xD8, 0x1C, 0x06, 0xC3, 0x0B, 0xFB, 0x0B,
  0x20, 0x3C, 0x40, 0x60, 0xDE, 0x0D, 0x06, 0x30, 0x1C, 0x68, 0x42, 0x56, 0x76, 0x27, 0x30,
  // "Ū" (U+016A)
  0x50, 0x38, 0x09, 0x25, 0x04, 0x74, 0x09, 0xFF, 0x0E, 0x74, 0x09, 0xFF, 0x0E, 0x74, 0x09, 0xFF,
  0x0E, 0x74, 0x09, 0xFF, 0x0E, 0x80, 0xA9, 0x10, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C,
  0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10,
  0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08,
  0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71,
  0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90,
  0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77,
  0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09,
  0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97,
  0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0,
  0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09,
  0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C,
  0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0,
  0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x9C, 0x08, 0x07, 0xC0, 0xA7, 0x71, 0x09,
  0xC0, 0x70, 0x6C, 0x0B, 0x77, 0x10, 0xAC, 0x06, 0x04, 0xC0, 0xD7, 0x71, 0x0D, 0xC0, 0x50, 0x1D,
  0x01, 0x77, 0xD8, 0x12, 0x0D, 0xC0, 0x67, 0x60, 0x5C, 0x0E, 0x20, 0x9C, 0x0C, 0x76, 0x0B, 0xC0,
  0xA2, 0x03, 0xD0, 0x77, 0x40, 0x5D, 0x04, 0x30, 0xBD, 0x07, 0x72, 0x04, 0xD0, 0xD4, 0x02, 0xE8,
  0x1C, 0x51, 0x40, 0x40, 0xAE, 0x03, 0x50, 0x6F, 0x98, 0x1E, 0xDD, 0xF9, 0x08, 0x70, 0x6F, 0xFB,
  0x08, 0x72, 0x04, 0x0D, 0xFE, 0x0E, 0x05, 0x75, 0x05, 0x0B, 0xFA, 0x0C, 0x06, 0x77, 0x38, 0x53,
  0x56, 0x76, 0x54, 0x73,
  // "ū" (U+016B)
  0x30, 0x38, 0x09, 0x25, 0x04, 0x60, 0x9F, 0xF0, 0xE6, 0x09, 0xFF, 0x0E, 0x60, 0x9F, 0xF0, 0xE6,
  0x09, 0xFF, 0x0E, 0x80, 0x9D, 0x50, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0,
  0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0,
  0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0,
  0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0,
  0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0,
  0x17, 0x30, 0x1D, 0x0E, 0xC0, 0x17, 0x30, 0x1D, 0x0E, 0xC0, 0x17, 0x30, 0x3D, 0x0D, 0xC0, 0x17,
  0x30, 0x5D, 0x0D, 0xC0, 0x37, 0x30, 0x8D, 0x0B, 0xC0, 0x57, 0x30, 0xCD, 0x09, 0xC0, 0x87, 0x20,
  0x2E, 0x06, 0xC0, 0xD7, 0x20, 0xAE, 0x02, 0xD0, 0x77, 0x06, 0xF1, 0x0C, 0xD0, 0x80, 0x13, 0x03,
  0x0A, 0xB0, 0xDC, 0x10, 0x4F, 0x00, 0xDD, 0x00, 0x8C, 0x20, 0xAF, 0xD8, 0x1C, 0x06, 0xC3, 0x0B,
  0xFB, 0x0B, 0x20, 0x3C, 0x40, 0x60, 0xDE, 0x0D, 0x06, 0x30, 0x1C, 0x68, 0x42, 0x56, 0x76, 0x27,
  0x30,
  // "Ŭ" (U+016C)
  0x50, 0x8A, 0x0A, 0x72, 0xB0, 0x27, 0x30, 0x6A, 0x0E, 0x71, 0x06, 0xB0, 0x17, 0x30, 0x3B, 0x0A,
  0x60, 0x30, 0xEA, 0x0C, 0x75, 0x0D, 0xB8, 0x4E, 0x86, 0x57, 0xBC, 0x07, 0x75, 0x07, 0xFD, 0x0E,
  0x77, 0x0B, 0xFC, 0x03, 0x77, 0x10, 0xAF, 0x90, 0xD0, 0x37, 0x73, 0x86, 0x39, 0xDE, 0xFD, 0xB6,
  0x80, 0xA9, 0x50, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09,
  0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97,
  0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0,
  0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09,
  0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C,
  0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0,
  0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08,
  0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C,
  0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10,
  0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08,
  0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71,
  0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90,
  0x8C, 0x09, 0x77, 0x10, 0x9C, 0x08, 0x07, 0xC0, 0xA7, 0x71, 0x09, 0xC0, 0x70, 0x6C, 0x0B, 0x77,
  0x10, 0xAC, 0x06, 0x04, 0xC0, 0xD7, 0x71, 0x0D, 0xC0, 0x50, 0x1D, 0x01, 0x77, 0xD8, 0x12, 0x0D,
  0xC0, 0x67, 0x60, 0x5C, 0x0E, 0x20, 0x9C, 0x0C, 0x76, 0x0B, 0xC0, 0xA2, 0x03, 0xD0, 0x77, 0x40,
  0x5D, 0x04, 0x30, 0xBD, 0x07, 0x72, 0x04, 0xD0, 0xD4, 0x02, 0xE8, 0x1C, 0x51, 0x40, 0x40, 0xAE,
  0x03, 0x50, 0x6F, 0x98, 0x1E, 0xDD, 0xF9, 0x08, 0x70, 0x6F, 0xFB, 0x08, 0x72, 0x04, 0x0D, 0xFE,
  0x0E, 0x05, 0x75, 0x05, 0x0B, 0xFA, 0x0C, 0x06, 0x77, 0x38, 0x53, 0x56, 0x76, 0x54, 0x73,
  // "ŭ" (U+016D)
  0x30, 0x8A, 0x0A, 0x72, 0xB0, 0x25, 0x06, 0xA0, 0xE7, 0x10, 0x6B, 0x01, 0x50, 0x3B, 0x0A, 0x60,
  0x30, 0xEA, 0x0C, 0x70, 0xDB, 0x84, 0xE8, 0x65, 0x7B, 0xC0, 0x77, 0x07, 0xFD, 0x0E, 0x72, 0x0B,
  0xFC, 0x03, 0x73, 0x0A, 0xF9, 0x0D, 0x03, 0x75, 0x86, 0x39, 0xDE, 0xFD, 0xB6, 0x80, 0x9E, 0x10,
  0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D,
  0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D,
  0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D,
  0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D,
  0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x30, 0x1D, 0x0E, 0xC0, 0x17,
  0x30, 0x1D, 0x0E, 0xC0, 0x17, 0x30, 0x3D, 0x0D, 0xC0, 0x17, 0x30, 0x5D, 0x0D, 0xC0, 0x37, 0x30,
  0x8D, 0x0B, 0xC0, 0x57, 0x30, 0xCD, 0x09, 0xC0, 0x87, 0x20, 0x2E, 0x06, 0xC0, 0xD7, 0x20, 0xAE,
  0x02, 0xD0, 0x77, 0x06, 0xF1, 0x0C, 0xD0, 0x80, 0x13, 0x03, 0x0A, 0xB0, 0xDC, 0x10, 0x4F, 0x00,
  0xDD, 0x00, 0x8C, 0x20, 0xAF, 0xD8, 0x1C, 0x06, 0xC3, 0x0B, 0xFB, 0x0B, 0x20, 0x3C, 0x40, 0x60,
  0xDE, 0x0D, 0x06, 0x30, 0x1C, 0x68, 0x42, 0x56, 0x76, 0x27, 0x30,
  // "Ů" (U+016E)
  0x73, 0x86, 0x4A, 0xDF, 0xEC, 0x71, 0x77, 0x40, 0x9F, 0x0E, 0x04, 0x77, 0x20, 0x8C, 0x0E, 0xC0,
  0xE0, 0x27, 0x70, 0x1B, 0x0B, 0x02, 0x20, 0x50, 0xEA, 0x0B, 0x77, 0x06, 0xA0, 0xD5, 0x05, 0xB7,
  0x70, 0x8A, 0x09, 0x6B, 0x02, 0x76, 0x08, 0xA0, 0x96, 0xB0, 0x27, 0x60, 0x6A, 0x0D, 0x50, 0x5A,
  0x0E, 0x77, 0x02, 0xB8, 0x4B, 0x20, 0x16, 0xEA, 0x0A, 0x77, 0x10, 0x8F, 0xA0, 0xE0, 0x27, 0x72,
  0x0A, 0xF0, 0xE0, 0x47, 0x74, 0x86, 0x4A, 0xDF, 0xEC, 0x71, 0x80, 0xA9, 0x40, 0x08, 0xC0, 0x97,
  0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0,
  0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09,
  0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C,
  0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0,
  0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08,
  0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C,
  0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10,
  0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08,
  0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71,
  0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90,
  0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77,
  0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x9C, 0x08,
  0x07, 0xC0, 0xA7, 0x71, 0x09, 0xC0, 0x70, 0x6C, 0x0B, 0x77, 0x10, 0xAC, 0x06, 0x04, 0xC0, 0xD7,
  0x71, 0x0D, 0xC0, 0x50, 0x1D, 0x01, 0x77, 0xD8, 0x12, 0x0D, 0xC0, 0x67, 0x60, 0x5C, 0x0E, 0x20,
  0x9C, 0x0C, 0x76, 0x0B, 0xC0, 0xA2, 0x03, 0xD0, 0x77, 0x40, 0x5D, 0x04, 0x30, 0xBD, 0x07, 0x72,
  0x04, 0xD0, 0xD4, 0x02, 0xE8, 0x1C, 0x51, 0x40, 0x40, 0xAE, 0x03, 0x50, 0x6F, 0x98, 0x1E, 0xDD,
  0xF9, 0x08, 0x70, 0x6F, 0xFB, 0x08, 0x72, 0x04, 0x0D, 0xFE, 0x0E, 0x05, 0x75, 0x05, 0x0B, 0xFA,
  0x0C, 0x06, 0x77, 0x38, 0x53, 0x56, 0x76, 0x54, 0x73,
  // "ů" (U+016F)
  0x78, 0x64, 0xAD, 0xFE, 0xC7, 0x17, 0x60, 0x9F, 0x0E, 0x04, 0x74, 0x08, 0xC0, 0xEC, 0x0E, 0x02,
  0x72, 0x01, 0xB0, 0xB0, 0x22, 0x05, 0x0E, 0xA0, 0xB7, 0x20, 0x6A, 0x0D, 0x50, 0x5B, 0x72, 0x08,
  0xA0, 0x96, 0xB0, 0x27, 0x10, 0x8A, 0x09, 0x6B, 0x02, 0x71, 0x06, 0xA0, 0xD5, 0x05, 0xA0, 0xE7,
  0x20, 0x2B, 0x84, 0xB2, 0x01, 0x6E, 0xA0, 0xA7, 0x30, 0x8F, 0xA0, 0xE0, 0x27, 0x40, 0xAF, 0x0E,
  0x04, 0x76, 0x86, 0x4A, 0xDF, 0xEC, 0x71, 0x80, 0x9E, 0x10, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0,
  0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0,
  0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0,
  0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0,
  0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x4D, 0x0E, 0xC0,
  0x17, 0x4D, 0x0E, 0xC0, 0x17, 0x30, 0x1D, 0x0E, 0xC0, 0x17, 0x30, 0x1D, 0x0E, 0xC0, 0x17, 0x30,
  0x3D, 0x0D, 0xC0, 0x17, 0x30, 0x5D, 0x0D, 0xC0, 0x37, 0x30, 0x8D, 0x0B, 0xC0, 0x57, 0x30, 0xCD,
  0x09, 0xC0, 0x87, 0x20, 0x2E, 0x06, 0xC0, 0xD7, 0x20, 0xAE, 0x02, 0xD0, 0x77, 0x06, 0xF1, 0x0C,
  0xD0, 0x80, 0x13, 0x03, 0x0A, 0xB0, 0xDC, 0x10, 0x4F, 0x00, 0xDD, 0x00, 0x8C, 0x20, 0xAF, 0xD8,
  0x1C, 0x06, 0xC3, 0x0B, 0xFB, 0x0B, 0x20, 0x3C, 0x40, 0x60, 0xDE, 0x0D, 0x06, 0x30, 0x1C, 0x68,
  0x42, 0x56, 0x76, 0x27, 0x30,
  // "Ű" (U+0170)
  0x74, 0x0E, 0xC0, 0x73, 0x0B, 0xC0, 0xB7, 0x40, 0x6C, 0x0E, 0x01, 0x20, 0x2D, 0x04, 0x74, 0x0D,
  0xC0, 0x63, 0x0A, 0xC0, 0x97, 0x40, 0x6C, 0x0B, 0x30, 0x2C, 0x0D, 0x75, 0x0D, 0xB0, 0xD0, 0x13,
  0x0A, 0xB0, 0xE0, 0x27, 0x40, 0x7B, 0x0E, 0x02, 0x30, 0x2C, 0x05, 0x74, 0x01, 0x0E, 0xB0, 0x54,
  0x0B, 0xB0, 0x77, 0x50, 0x8B, 0x07, 0x40, 0x4B, 0x09, 0x75, 0x02, 0xB0, 0x75, 0x0C, 0xA0, 0xA7,
  0x60, 0x8A, 0x07, 0x50, 0x5A, 0x0A, 0x80, 0xA9, 0x30, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90,
  0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77,
  0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09,
  0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97,
  0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0,
  0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09,
  0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C,
  0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0,
  0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08,
  0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C,
  0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10,
  0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08,
  0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x9C, 0x08, 0x07, 0xC0, 0xA7, 0x71,
  0x09, 0xC0, 0x70, 0x6C, 0x0B, 0x77, 0x10, 0xAC, 0x06, 0x04, 0xC0, 0xD7, 0x71, 0x0D, 0xC0, 0x50,
  0x1D, 0x01, 0x77, 0xD8, 0x12, 0x0D, 0xC0, 0x67, 0x60, 0x5C, 0x0E, 0x20, 0x9C, 0x0C, 0x76, 0x0B,
  0xC0, 0xA2, 0x03, 0xD0, 0x77, 0x40, 0x5D, 0x04, 0x30, 0xBD, 0x07, 0x72, 0x04, 0xD0, 0xD4, 0x02,
  0xE8, 0x1C, 0x51, 0x40, 0x40, 0xAE, 0x03, 0x50, 0x6F, 0x98, 0x1E, 0xDD, 0xF9, 0x08, 0x70, 0x6F,
  0xFB, 0x08, 0x72, 0x04, 0x0D, 0xFE, 0x0E, 0x05, 0x75, 0x05, 0x0B, 0xFA, 0x0C, 0x06, 0x77, 0x38,
  0x53, 0x56, 0x76, 0x54, 0x73,
  // "ű" (U+0171)
  0x72, 0x0E, 0xC0, 0x73, 0x0B, 0xC0, 0xB7, 0x10, 0x6C, 0x0E, 0x01, 0x20, 0x2D, 0x04, 0x71, 0x0D,
  0xC0, 0x63, 0x0A, 0xC0, 0x97, 0x10, 0x6C, 0x0B, 0x30, 0x2C, 0x0D, 0x72, 0x0D, 0xB0, 0xD0, 0x13,
  0x0A, 0xB0, 0xE0, 0x27, 0x10, 0x7B, 0x0E, 0x02, 0x30, 0x2C, 0x05, 0x71, 0x01, 0x0E, 0xB0, 0x54,
  0x0B, 0xB0, 0x77, 0x20, 0x8B, 0x07, 0x40, 0x4B, 0x09, 0x72, 0x02, 0xB0, 0x75, 0x0C, 0xA0, 0xA7,
  0x30, 0x8A, 0x07, 0x50, 0x5A, 0x0A, 0x80, 0x9F, 0x30, 0x0E, 0xC0, 0x17, 0x4D, 0x20, 0xEC, 0x01,
  0x74, 0xD2, 0x0E, 0xC0, 0x17, 0x4D, 0x20, 0xEC, 0x01, 0x74, 0xD2, 0x0E, 0xC0, 0x17, 0x4D, 0x20,
  0xEC, 0x01, 0x74, 0xD2, 0x0E, 0xC0, 0x17, 0x4D, 0x20, 0xEC, 0x01, 0x74, 0xD2, 0x0E, 0xC0, 0x17,
  0x4D, 0x20, 0xEC, 0x01, 0x74, 0xD2, 0x0E, 0xC0, 0x17, 0x4D, 0x20, 0xEC, 0x01, 0x74, 0xD2, 0x0E,
  0xC0, 0x17, 0x4D, 0x20, 0xEC, 0x01, 0x74, 0xD2, 0x0E, 0xC0, 0x17, 0x4D, 0x20, 0xEC, 0x01, 0x74,
  0xD2, 0x0E, 0xC0, 0x17, 0x4D, 0x20, 0xEC, 0x01, 0x74, 0xD2, 0x0E, 0xC0, 0x17, 0x30, 0x1D, 0x20,
  0xEC, 0x01, 0x73, 0x01, 0xD2, 0x0E, 0xC0, 0x17, 0x30, 0x3D, 0x20, 0xDC, 0x01, 0x73, 0x05, 0xD2,
  0x0D, 0xC0, 0x37, 0x30, 0x8D, 0x20, 0xBC, 0x05, 0x73, 0x0C, 0xD2, 0x09, 0xC0, 0x87, 0x20, 0x2E,
  0x20, 0x6C, 0x0D, 0x72, 0x0A, 0xE2, 0x02, 0xD0, 0x77, 0x06, 0xF3, 0x0C, 0xD0, 0x80, 0x13, 0x03,
  0x0A, 0xB0, 0xDC, 0x30, 0x4F, 0x00, 0xDD, 0x00, 0x8C, 0x40, 0xAF, 0xD8, 0x1C, 0x06, 0xC5, 0x0B,
  0xFB, 0x0B, 0x20, 0x3C, 0x60, 0x60, 0xDE, 0x0D, 0x06, 0x30, 0x1C, 0x71, 0x84, 0x25, 0x67, 0x62,
  0x75,
  // "Ų" (U+0172)
  0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97,
  0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0,
  0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09,
  0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C,
  0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0,
  0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08,
  0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C,
  0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10,
  0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08,
  0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71,
  0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90,
  0x8C, 0x09, 0x77, 0x10, 0x8C, 0x09, 0x08, 0xC0, 0x97, 0x71, 0x08, 0xC0, 0x90, 0x8C, 0x09, 0x77,
  0x10, 0x9C, 0x08, 0x07, 0xC0, 0xA7, 0x71, 0x09, 0xC0, 0x80, 0x6C, 0x0B, 0x77, 0x10, 0xAC, 0x07,
  0x04, 0xC0, 0xD7, 0x71, 0x0D, 0xC0, 0x50, 0x1D, 0x01, 0x77, 0xD8, 0x13, 0x0D, 0xC0, 0x67, 0x60,
  0x5D, 0x20, 0x9C, 0x0C, 0x76, 0x0B, 0xC0, 0xB2, 0x03, 0xD0, 0x77, 0x40, 0x5D, 0x06, 0x30, 0xBD,
  0x07, 0x72, 0x04, 0xD0, 0xE4, 0x02, 0xE8, 0x1C, 0x51, 0x40, 0x40, 0xAE, 0x06, 0x50, 0x6F, 0x98,
  0x1E, 0xDD, 0xF9, 0x0A, 0x70, 0x6F, 0xFB, 0x0B, 0x72, 0x04, 0x0D, 0xFF, 0x0B, 0x75, 0x05, 0x0B,
  0xFC, 0x0C, 0x77, 0x28, 0x53, 0x56, 0x76, 0x5C, 0xA0, 0xE0, 0x17, 0x77, 0x05, 0xB0, 0x47, 0x77,
  0x02, 0xB0, 0x97, 0x77, 0x10, 0xBB, 0x01, 0x77, 0x70, 0x4B, 0x0A, 0x77, 0x71, 0x09, 0xB0, 0x57,
  0x77, 0x10, 0xDB, 0x03, 0x77, 0x71, 0xC0, 0x27, 0x77, 0x1C, 0x06, 0x77, 0x71, 0x0D, 0xB8, 0x3E,
  0x40, 0x13, 0x77, 0x40, 0xAF, 0x97, 0x74, 0x03, 0xF9, 0x77, 0x50, 0x7F, 0x77, 0x68, 0x53, 0xAD,
  0xFE, 0xD9, 0x50,
  // "ų" (U+0173)
  0x0E, 0xC0, 0x17, 0x4D, 0x10, 0xEC, 0x01, 0x74, 0xD1, 0x0E, 0xC0, 0x17, 0x4D, 0x10, 0xEC, 0x01,
  0x74, 0xD1, 0x0E, 0xC0, 0x17, 0x4D, 0x10, 0xEC, 0x01, 0x74, 0xD1, 0x0E, 0xC0, 0x17, 0x4D, 0x10,
  0xEC, 0x01, 0x74, 0xD1, 0x0E, 0xC0, 0x17, 0x4D, 0x10, 0xEC, 0x01, 0x74, 0xD1, 0x0E, 0xC0, 0x17,
  0x4D, 0x10, 0xEC, 0x01, 0x74, 0xD1, 0x0E, 0xC0, 0x17, 0x4D, 0x10, 0xEC, 0x01, 0x74, 0xD1, 0x0E,
  0xC0, 0x17, 0x4D, 0x10, 0xEC, 0x01, 0x74, 0xD1, 0x0E, 0xC0, 0x17, 0x4D, 0x10, 0xEC, 0x01, 0x74,
  0xD1, 0x0E, 0xC0, 0x17, 0x30, 0x1D, 0x10, 0xEC, 0x01, 0x73, 0x01, 0xD1, 0x0E, 0xC0, 0x17, 0x30,
  0x3D, 0x10, 0xDC, 0x01, 0x73, 0x05, 0xD1, 0x0D, 0xC0, 0x37, 0x30, 0x8D, 0x10, 0xBC, 0x05, 0x73,
  0x0C, 0xD1, 0x09, 0xC0, 0x87, 0x20, 0x2E, 0x10, 0x6C, 0x0D, 0x72, 0x0A, 0xE1, 0x02, 0xD0, 0x77,
  0x06, 0xF2, 0x0C, 0xD0, 0x80, 0x13, 0x03, 0x0A, 0xB0, 0xDC, 0x20, 0x4F, 0x00, 0xDD, 0x00, 0x8C,
  0x30, 0xAF, 0xD8, 0x1C, 0x06, 0xC4, 0x0B, 0xFB, 0x0B, 0x20, 0x4C, 0x50, 0x60, 0xDE, 0x0D, 0x06,
  0x30, 0xCC, 0x78, 0x42, 0x56, 0x76, 0x24, 0x0A, 0xA0, 0xD0, 0x17, 0x73, 0x07, 0xB0, 0x27, 0x73,
  0x02, 0xB0, 0x77, 0x74, 0x0B, 0xB0, 0x17, 0x73, 0x01, 0xB0, 0xB7, 0x74, 0x06, 0xB0, 0x87, 0x74,
  0x08, 0xB0, 0x87, 0x74, 0x08, 0xB0, 0xB7, 0x74, 0x07, 0xC8, 0x38, 0x10, 0x11, 0x76, 0x04, 0xF9,
  0x06, 0x77, 0x0D, 0xF0, 0x67, 0x70, 0x30, 0xEE, 0x06, 0x77, 0x18, 0x61, 0x8C, 0xEF, 0xDA, 0x30,
  // "Ŵ" (U+0174)
  0x77, 0x78, 0x45, 0x77, 0x77, 0x38, 0x0C, 0x40, 0x01, 0xD0, 0xD8, 0x0C, 0x40, 0x0A, 0xE0, 0x68,
  0x0C, 0x20, 0x04, 0xF0, 0xE0, 0x28, 0x0C, 0x00, 0x01, 0x0D, 0xB0, 0xC0, 0xEB, 0x0B, 0x80, 0xC0,
  0x00, 0xAB, 0x82, 0xD1, 0x2E, 0xB0, 0x77, 0x77, 0x76, 0x05, 0xB0, 0xD0, 0x12, 0x03, 0x0E, 0xB0,
  0x37, 0x77, 0x74, 0x02, 0x0E, 0xA0, 0xD0, 0x14, 0x04, 0xB0, 0xD0, 0x17, 0x77, 0x73, 0x0D, 0xA0,
  0xD0, 0x26, 0x04, 0x0E, 0xA0, 0xB7, 0x77, 0x72, 0x08, 0xA0, 0xD0, 0x17, 0x10, 0x30, 0xDA, 0x06,
  0x80, 0xBE, 0x50, 0x08, 0xC0, 0xB7, 0x70, 0x2D, 0x77, 0x10, 0xBC, 0x07, 0x04, 0xC0, 0xE7, 0x70,
  0x6D, 0x04, 0x77, 0x0E, 0xC0, 0x30, 0x1D, 0x02, 0x76, 0x09, 0xD0, 0x77, 0x60, 0x3D, 0x20, 0xDC,
  0x06, 0x76, 0x0D, 0xD0, 0xB7, 0x60, 0x6C, 0x0C, 0x20, 0x9C, 0x09, 0x75, 0x01, 0xE0, 0xE7, 0x60,
  0x9C, 0x08, 0x20, 0x6C, 0x0C, 0x75, 0x04, 0xF0, 0x27, 0x50, 0xDC, 0x05, 0x20, 0x2D, 0x75, 0x08,
  0xF0, 0x67, 0x40, 0x1D, 0x01, 0x30, 0xEC, 0x03, 0x74, 0x0B, 0xB0, 0xEB, 0x09, 0x74, 0x04, 0xC0,
  0xD4, 0x0B, 0xC0, 0x77, 0x4C, 0x0A, 0xB0, 0xD7, 0x40, 0x7C, 0x0A, 0x40, 0x7C, 0x0A, 0x73, 0x03,
  0xC0, 0x6C, 0x01, 0x73, 0x0B, 0xC0, 0x74, 0x04, 0xC0, 0xD7, 0x30, 0x7C, 0x02, 0xC0, 0x57, 0x30,
  0xEC, 0x03, 0x40, 0x1D, 0x01, 0x72, 0x0A, 0xB0, 0xC1, 0xC0, 0x87, 0x20, 0x2D, 0x60, 0xDC, 0x04,
  0x72, 0x0E, 0xB8, 0x19, 0x0C, 0xB0, 0xC7, 0x20, 0x5C, 0x0C, 0x60, 0x9C, 0x08, 0x71, 0x02, 0xC8,
  0x16, 0x09, 0xC7, 0x20, 0x8C, 0x08, 0x60, 0x6C, 0x0B, 0x71, 0x05, 0xC8, 0x13, 0x06, 0xC0, 0x37,
  0x10, 0xCC, 0x05, 0x60, 0x2C, 0x0E, 0x71, 0x09, 0xC2, 0x03, 0xC0, 0x77, 0x1D, 0x01, 0x70, 0xEC,
  0x02, 0x70, 0xCB, 0x0C, 0x30, 0xEB, 0x0A, 0x70, 0x3C, 0x0D, 0x71, 0x0B, 0xC0, 0x57, 0xC0, 0x83,
  0x0B, 0xB0, 0xE7, 0x06, 0xC0, 0xA7, 0x10, 0x7C, 0x09, 0x60, 0x4C, 0x05, 0x30, 0x7C, 0x02, 0x60,
  0xAC, 0x07, 0x71, 0x04, 0xC0, 0xC6, 0x07, 0xC0, 0x13, 0x04, 0xC0, 0x66, 0x0D, 0xC0, 0x37, 0x2D,
  0x60, 0xBB, 0x0D, 0x5C, 0x09, 0x50, 0x1D, 0x73, 0x0C, 0xC0, 0x35, 0x0E, 0xB0, 0xA5, 0x0C, 0xB0,
  0xD5, 0x04, 0xC0, 0xC7, 0x30, 0x9C, 0x07, 0x40, 0x2C, 0x06, 0x50, 0x9C, 0x01, 0x40, 0x8C, 0x08,
  0x73, 0x05, 0xC0, 0xA4, 0x06, 0xC0, 0x35, 0x05, 0xC0, 0x44, 0x0B, 0xC0, 0x57, 0x30, 0x2C, 0x0D,
  0x40, 0x9B, 0x0E, 0x60, 0x1C, 0x08, 0x40, 0xEC, 0x01, 0x74, 0x0E, 0xC0, 0x13, 0x0D, 0xB0, 0xB7,
  0x0D, 0xB0, 0xB3, 0x02, 0xC0, 0xD7, 0x50, 0xAC, 0x04, 0x20, 0x1C, 0x08, 0x70, 0xAC, 0x30, 0x5C,
  0x0A, 0x75, 0x07, 0xC0, 0x72, 0x04, 0xC0, 0x47, 0x06, 0xC0, 0x32, 0x09, 0xC0, 0x77, 0x50, 0x3C,
  0x0A, 0x20, 0x7C, 0x01, 0x70, 0x2C, 0x06, 0x20, 0xCC, 0x03, 0x76, 0xC0, 0xD2, 0x0A, 0xB0, 0xD7,
  0x20, 0xEB, 0x09, 0x2D, 0x77, 0x0C, 0xC2, 0x0D, 0xB0, 0x97, 0x20, 0xBB, 0x81, 0xC0, 0x2C, 0x0C,
  0x77, 0x08, 0xC0, 0x30, 0x1C, 0x05, 0x72, 0x07, 0xC1, 0x05, 0xC0, 0x87, 0x70, 0x5C, 0x05, 0x03,
  0xC0, 0x27, 0x20, 0x3C, 0x02, 0x08, 0xC0, 0x57, 0x70, 0x1C, 0x08, 0x06, 0xB0, 0xE7, 0x4C, 0x04,
  0x0A, 0xC0, 0x17, 0x71, 0x0D, 0xB0, 0xA0, 0x9B, 0x0A, 0x74, 0x0C, 0xB0, 0x60, 0xCB, 0x0D, 0x77,
  0x20, 0xAB, 0x0C, 0x0B, 0xB0, 0x77, 0x40, 0x8B, 0x09, 0x0E, 0xB0, 0xA7, 0x72, 0x06, 0xB0, 0xE0,
  0xDB, 0x03, 0x74, 0x04, 0xB0, 0xCC, 0x07, 0x77, 0x20, 0x3F, 0x97, 0x50, 0x1F, 0x90, 0x37, 0x73,
  0xF0, 0xC7, 0x60, 0xDF, 0x77, 0x40, 0xBE, 0x08, 0x76, 0x09, 0xE0, 0xC7, 0x74, 0x08, 0xE0, 0x57,
  0x60, 0x5E, 0x08, 0x77, 0x40, 0x5E, 0x01, 0x76, 0x02, 0xE0, 0x57, 0x74, 0x01, 0xD0, 0xD7, 0x71,
  0x0E, 0xD0, 0x17, 0x20,
  // "ŵ" (U+0175)
  0x77, 0x38, 0x45, 0x77, 0x77, 0x37, 0x77, 0x74, 0x01, 0xD0, 0xD7, 0x77, 0x74, 0x0A, 0xE0, 0x67,
  0x77, 0x72, 0x04, 0xF0, 0xE0, 0x27, 0x77, 0x70, 0x10, 0xDB, 0x0C, 0x0E, 0xB0, 0xB7, 0x77, 0x70,
  0xAB, 0x82, 0xD1, 0x2E, 0xB0, 0x77, 0x77, 0x50, 0x5B, 0x0D, 0x01, 0x20, 0x30, 0xEB, 0x03, 0x77,
  0x73, 0x02, 0x0E, 0xA0, 0xD0, 0x14, 0x04, 0xB0, 0xD0, 0x17, 0x77, 0x20, 0xDA, 0x0D, 0x02, 0x60,
  0x40, 0xEA, 0x0B, 0x77, 0x71, 0x08, 0xA0, 0xD0, 0x17, 0x10, 0x30, 0xDA, 0x06, 0x80, 0xB9, 0x10,
  0x04, 0xC0, 0xB7, 0x30, 0x1D, 0x0A, 0x73, 0x01, 0xC0, 0xD0, 0x1C, 0x0E, 0x73, 0x04, 0xD0, 0xE7,
  0x30, 0x4C, 0x81, 0x90, 0xCC, 0x03, 0x72, 0x08, 0xE0, 0x27, 0x20, 0x8C, 0x81, 0x60, 0x9C, 0x06,
  0x72, 0x0C, 0xE0, 0x57, 0x20, 0xBC, 0x81, 0x20, 0x5C, 0x09, 0x72, 0xF0, 0x97, 0x20, 0xEB, 0x0E,
  0x20, 0x1C, 0x0D, 0x71, 0x04, 0xB0, 0xEB, 0x0D, 0x71, 0x03, 0xC0, 0xA3, 0x0D, 0xC0, 0x17, 0x08,
  0xB0, 0x8C, 0x01, 0x70, 0x6C, 0x06, 0x30, 0xAC, 0x04, 0x70, 0xBB, 0x05, 0x0C, 0xB0, 0x57, 0x0A,
  0xC0, 0x33, 0x06, 0xC0, 0x87, 0xC0, 0x30, 0xAB, 0x08, 0x70, 0xDB, 0x0E, 0x40, 0x3C, 0x0B, 0x60,
  0x3C, 0x10, 0x6B, 0x0C, 0x60, 0x1C, 0x0B, 0x50, 0xEB, 0x0E, 0x60, 0x7B, 0x81, 0xC0, 0x3C, 0x60,
  0x4C, 0x07, 0x50, 0xBC, 0x02, 0x50, 0xBB, 0x09, 0x2C, 0x04, 0x50, 0x8C, 0x03, 0x50, 0x7C, 0x06,
  0x50, 0xEB, 0x05, 0x20, 0xCB, 0x07, 0x50, 0xBC, 0x60, 0x4C, 0x09, 0x40, 0x3C, 0x02, 0x20, 0x9B,
  0x0B, 0x50, 0xEB, 0x0B, 0x7C, 0x0D, 0x40, 0x6B, 0x0E, 0x30, 0x6B, 0x0E, 0x40, 0x3C, 0x07, 0x70,
  0xCC, 0x01, 0x30, 0xAB, 0x0A, 0x30, 0x2C, 0x03, 0x30, 0x6C, 0x04, 0x70, 0x8C, 0x04, 0x30, 0xEB,
  0x06, 0x40, 0xEB, 0x06, 0x30, 0xAC, 0x71, 0x05, 0xC0, 0x72, 0x02, 0xC0, 0x24, 0x0B, 0xB0, 0xA3,
  0x0D, 0xB0, 0xC7, 0x10, 0x1C, 0x0A, 0x20, 0x5B, 0x0E, 0x50, 0x7B, 0x0E, 0x20, 0x1C, 0x08, 0x72,
  0x0D, 0xB0, 0xD2, 0x08, 0xB0, 0xB5, 0x04, 0xC8, 0x12, 0x04, 0xC0, 0x47, 0x20, 0x9C, 0x20, 0xCB,
  0x07, 0x6C, 0x81, 0x50, 0x7C, 0x01, 0x72, 0x06, 0xC0, 0x31, 0xC0, 0x36, 0x0C, 0xB8, 0x18, 0x0A,
  0xB0, 0xC7, 0x30, 0x2C, 0x06, 0x02, 0xC7, 0x09, 0xB8, 0x1A, 0x0D, 0xB0, 0x97, 0x40, 0xEB, 0x09,
  0x05, 0xB0, 0xB7, 0x05, 0xB0, 0xD0, 0x1C, 0x05, 0x74, 0x0A, 0xB0, 0xB0, 0x7B, 0x08, 0x70, 0x2C,
  0x04, 0xC0, 0x17, 0x40, 0x7B, 0x0E, 0x0A, 0xB0, 0x47, 0x10, 0xEB, 0x09, 0xB0, 0xD7, 0x50, 0x3C,
  0x0E, 0xB7, 0x20, 0xAB, 0x0E, 0xB0, 0x97, 0x6F, 0x0C, 0x72, 0x07, 0xF0, 0x67, 0x60, 0xBE, 0x08,
  0x72, 0x03, 0xF0, 0x27, 0x60, 0x8E, 0x05, 0x73, 0xE0, 0xE7, 0x70, 0x4E, 0x01, 0x73, 0x0C, 0xD0,
  0xA7, 0x70, 0x1D, 0x0D, 0x74, 0x08, 0xD0, 0x67,
  // "Ŷ" (U+0176)
  0x73, 0x84, 0x57, 0x77, 0x73, 0x77, 0x60, 0x1D, 0x0D, 0x77, 0x60, 0xAE, 0x06, 0x77, 0x40, 0x4F,
  0x0E, 0x02, 0x77, 0x20, 0x10, 0xDB, 0x0C, 0x0E, 0xB0, 0xB7, 0x72, 0x0A, 0xB8, 0x2D, 0x12, 0xEB,
  0x07, 0x77, 0x05, 0xB0, 0xD0, 0x12, 0x03, 0x0E, 0xB0, 0x37, 0x50, 0x20, 0xEA, 0x0D, 0x01, 0x40,
  0x4B, 0x0D, 0x01, 0x74, 0x0D, 0xA0, 0xD0, 0x26, 0x04, 0x0E, 0xA0, 0xB7, 0x30, 0x8A, 0x0D, 0x01,
  0x71, 0x03, 0x0D, 0xA0, 0x68, 0x0A, 0x90, 0x00, 0xCC, 0x0A, 0x77, 0x10, 0xEC, 0x00, 0x6D, 0x01,
  0x76, 0x05, 0xC8, 0x2E, 0x10, 0xEC, 0x06, 0x76, 0x0B, 0xC0, 0x92, 0x09, 0xC0, 0xC7, 0x50, 0x1D,
  0x03, 0x20, 0x2D, 0x03, 0x74, 0x07, 0xC0, 0xC4, 0x0C, 0xC0, 0x97, 0x40, 0xDC, 0x06, 0x40, 0x5C,
  0x0E, 0x73, 0x04, 0xC0, 0xE6, 0x0E, 0xC0, 0x57, 0x20, 0xAC, 0x09, 0x60, 0x9C, 0x0B, 0x71, 0x01,
  0xD0, 0x36, 0x02, 0xD0, 0x27, 0x06, 0xC0, 0xC7, 0x10, 0xCC, 0x08, 0x70, 0xCC, 0x05, 0x71, 0x05,
  0xC0, 0xD6, 0x03, 0xC0, 0xE7, 0x30, 0xEC, 0x04, 0x50, 0x9C, 0x08, 0x73, 0x08, 0xC0, 0xA5, 0x0E,
  0xC0, 0x27, 0x30, 0x2D, 0x01, 0x30, 0x5C, 0x0B, 0x75, 0x0B, 0xC0, 0x73, 0x0B, 0xC0, 0x57, 0x50,
  0x5C, 0x0D, 0x20, 0x1C, 0x0E, 0x77, 0x0E, 0xC8, 0x13, 0x07, 0xC0, 0x87, 0x70, 0x8C, 0x81, 0x90,
  0xDC, 0x02, 0x77, 0x02, 0xC0, 0xE0, 0x5C, 0x0B, 0x77, 0x20, 0xBC, 0x0E, 0xC0, 0x57, 0x72, 0x05,
  0xF9, 0x0E, 0x77, 0x40, 0xEF, 0x08, 0x77, 0x40, 0x8F, 0x01, 0x77, 0x40, 0x2E, 0x0B, 0x77, 0x60,
  0xBD, 0x04, 0x77, 0x60, 0x5C, 0x0E, 0x77, 0x70, 0x4C, 0x0E, 0x77, 0x70, 0x4C, 0x0E, 0x77, 0x70,
  0x4C, 0x0E, 0x77, 0x70, 0x4C, 0x0E, 0x77, 0x70, 0x4C, 0x0E, 0x77, 0x70, 0x4C, 0x0E, 0x77, 0x70,
  0x4C, 0x0E, 0x77, 0x70, 0x4C, 0x0E, 0x77, 0x70, 0x4C, 0x0E, 0x77, 0x70, 0x4C, 0x0E, 0x77, 0x70,
  0x4C, 0x0E, 0x77, 0x70, 0x4C, 0x0E, 0x77, 0x70, 0x4C, 0x0E, 0x77, 0x70, 0x4C, 0x0E, 0x77, 0x70,
  0x4C, 0x0E, 0x77, 0x70, 0x4C, 0x0E, 0x74,
  // "ŷ" (U+0177)
  0x72, 0x84, 0x57, 0x77, 0x73, 0x77, 0x40, 0x1D, 0x0D, 0x77, 0x40, 0xAE, 0x06, 0x77, 0x20, 0x4F,
  0x0E, 0x02, 0x77, 0x01, 0x0D, 0xB0, 0xC0, 0xEB, 0x0B, 0x77, 0x0A, 0xB8, 0x2D, 0x12, 0xEB, 0x07,
  0x75, 0x05, 0xB0, 0xD0, 0x12, 0x03, 0x0E, 0xB0, 0x37, 0x30, 0x20, 0xEA, 0x0D, 0x01, 0x40, 0x4B,
  0x0D, 0x01, 0x72, 0x0D, 0xA0, 0xD0, 0x26, 0x04, 0x0E, 0xA0, 0xB7, 0x10, 0x8A, 0x0D, 0x01, 0x71,
  0x03, 0x0D, 0xA0, 0x68, 0x09, 0xF5, 0x00, 0xAC, 0x08, 0x76, 0x0B, 0xC0, 0x60, 0x5C, 0x0C, 0x76,
  0xD0, 0x11, 0xD0, 0x17, 0x40, 0x4C, 0x0C, 0x20, 0xBC, 0x06, 0x74, 0x09, 0xC0, 0x72, 0x06, 0xC0,
  0xA7, 0x40, 0xDC, 0x03, 0x20, 0x1C, 0x0E, 0x73, 0x02, 0xC0, 0xE4, 0x0C, 0xC0, 0x37, 0x20, 0x6C,
  0x09, 0x40, 0x7C, 0x08, 0x72, 0x0A, 0xC0, 0x54, 0x02, 0xC0, 0xC7, 0x20, 0xEC, 0x60, 0xDC, 0x01,
  0x70, 0x3C, 0x0B, 0x60, 0x8C, 0x05, 0x70, 0x7C, 0x06, 0x60, 0x4C, 0x0A, 0x70, 0xCC, 0x02, 0x70,
  0xEB, 0x0E, 0x7C, 0x0D, 0x71, 0x09, 0xC0, 0x35, 0x05, 0xC0, 0x87, 0x10, 0x5C, 0x07, 0x50, 0x9C,
  0x03, 0x72, 0xC0, 0xC5, 0x0D, 0xB0, 0xE7, 0x30, 0xBC, 0x01, 0x30, 0x2C, 0x0A, 0x73, 0x06, 0xC0,
  0x53, 0x06, 0xC0, 0x57, 0x30, 0x1C, 0x09, 0x30, 0xAC, 0x01, 0x74, 0x0C, 0xB0, 0xD3, 0x0E, 0xB0,
  0xB7, 0x50, 0x7C, 0x81, 0x20, 0x3C, 0x07, 0x75, 0x02, 0xC8, 0x16, 0x07, 0xC0, 0x27, 0x60, 0xDB,
  0x81, 0xA0, 0xBB, 0x0D, 0x77, 0x08, 0xB8, 0x1D, 0x0E, 0xB0, 0x97, 0x70, 0x3C, 0x03, 0xC0, 0x47,
  0x71, 0x0E, 0xB0, 0x9B, 0x0E, 0x77, 0x20, 0x9F, 0x0A, 0x77, 0x20, 0x4F, 0x06, 0x77, 0x3F, 0x01,
  0x77, 0x30, 0xAD, 0x0C, 0x77, 0x40, 0x6D, 0x07, 0x77, 0x40, 0x1D, 0x03, 0x77, 0x40, 0x3C, 0x0E,
  0x77, 0x50, 0x7C, 0x09, 0x77, 0x50, 0xCC, 0x04, 0x77, 0x40, 0x1D, 0x77, 0x50, 0x6C, 0x0B, 0x77,
  0x50, 0xCC, 0x05, 0x77, 0x40, 0x3D, 0x77, 0x50, 0xBC, 0x09, 0x77, 0x40, 0x8D, 0x02, 0x75, 0x84,
  0x28, 0x65, 0x6C, 0xD0, 0x97, 0x60, 0x3F, 0xA0, 0xD0, 0x17, 0x60, 0x3F, 0x90, 0xE0, 0x37, 0x70,
  0x3F, 0x0D, 0x03, 0x77, 0x18, 0x61, 0xAD, 0xEF, 0xDA, 0x67, 0x73,
  // "Ÿ" (U+0178)
  0x68, 0x27, 0xDE, 0x86, 0x83, 0x4D, 0xEA, 0x17, 0x40, 0x3C, 0x06, 0x40, 0x10, 0xEB, 0x09, 0x74,
  0x07, 0xC0, 0x94, 0x04, 0xC0, 0xD7, 0x40, 0x7C, 0x09, 0x40, 0x4C, 0x0D, 0x74, 0x03, 0xC0, 0x54,
  0x01, 0x0E, 0xB0, 0x97, 0x58, 0x26, 0xDE, 0x86, 0x82, 0x4D, 0xEA, 0x80, 0xA9, 0x20, 0x0C, 0xC0,
  0xA7, 0x71, 0x0E, 0xC0, 0x06, 0xD0, 0x17, 0x60, 0x5C, 0x82, 0xE1, 0x0E, 0xC0, 0x67, 0x60, 0xBC,
  0x09, 0x20, 0x9C, 0x0C, 0x75, 0x01, 0xD0, 0x32, 0x02, 0xD0, 0x37, 0x40, 0x7C, 0x0C, 0x40, 0xCC,
  0x09, 0x74, 0x0D, 0xC0, 0x64, 0x05, 0xC0, 0xE7, 0x30, 0x4C, 0x0E, 0x60, 0xEC, 0x05, 0x72, 0x0A,
  0xC0, 0x96, 0x09, 0xC0, 0xB7, 0x10, 0x1D, 0x03, 0x60, 0x2D, 0x02, 0x70, 0x6C, 0x0C, 0x71, 0x0C,
  0xC0, 0x87, 0x0C, 0xC0, 0x57, 0x10, 0x5C, 0x0D, 0x60, 0x3C, 0x0E, 0x73, 0x0E, 0xC0, 0x45, 0x09,
  0xC0, 0x87, 0x30, 0x8C, 0x0A, 0x50, 0xEC, 0x02, 0x73, 0x02, 0xD0, 0x13, 0x05, 0xC0, 0xB7, 0x50,
  0xBC, 0x07, 0x30, 0xBC, 0x05, 0x75, 0x05, 0xC0, 0xD2, 0x01, 0xC0, 0xE7, 0x70, 0xEC, 0x81, 0x30,
  0x7C, 0x08, 0x77, 0x08, 0xC8, 0x19, 0x0D, 0xC0, 0x27, 0x70, 0x2C, 0x0E, 0x05, 0xC0, 0xB7, 0x72,
  0x0B, 0xC0, 0xEC, 0x05, 0x77, 0x20, 0x5F, 0x90, 0xE7, 0x74, 0x0E, 0xF0, 0x87, 0x74, 0x08, 0xF0,
  0x17, 0x74, 0x02, 0xE0, 0xB7, 0x76, 0x0B, 0xD0, 0x47, 0x76, 0x05, 0xC0, 0xE7, 0x77, 0x04, 0xC0,
  0xE7, 0x77, 0x04, 0xC0, 0xE7, 0x77, 0x04, 0xC0, 0xE7, 0x77, 0x04, 0xC0, 0xE7, 0x77, 0x04, 0xC0,
  0xE7, 0x77, 0x04, 0xC0, 0xE7, 0x77, 0x04, 0xC0, 0xE7, 0x77, 0x04, 0xC0, 0xE7, 0x77, 0x04, 0xC0,
  0xE7, 0x77, 0x04, 0xC0, 0xE7, 0x77, 0x04, 0xC0, 0xE7, 0x77, 0x04, 0xC0, 0xE7, 0x77, 0x04, 0xC0,
  0xE7, 0x77, 0x04, 0xC0, 0xE7, 0x77, 0x04, 0xC0, 0xE7, 0x77, 0x04, 0xC0, 0xE7, 0x40,
  // "Ź" (U+0179)
  0x76, 0x02, 0x80, 0x17, 0x06, 0x77, 0x20, 0xAD, 0x07, 0x77, 0x10, 0x3D, 0x0C, 0x77, 0x20, 0xCC,
  0x0E, 0x01, 0x77, 0x10, 0x6C, 0x0E, 0x03, 0x77, 0x10, 0x10, 0xEC, 0x04, 0x77, 0x20, 0xAC, 0x05,
  0x77, 0x20, 0x5C, 0x05, 0x77, 0x20, 0x10, 0xEB, 0x05, 0x77, 0x30, 0x8A, 0x0E, 0x04, 0x80, 0x9F,
  0x20, 0x0D, 0xFF, 0xE8, 0x17, 0x0D, 0xFF, 0xE8, 0x17, 0x0D, 0xFF, 0xE8, 0x17, 0x0D, 0xFF, 0xE8,
  0x16, 0x04, 0x80, 0x92, 0x50, 0x9D, 0x02, 0x77, 0x20, 0xCC, 0x0A, 0x77, 0x20, 0x4D, 0x03, 0x77,
  0x20, 0xBC, 0x0B, 0x77, 0x20, 0x3D, 0x04, 0x77, 0x20, 0xAC, 0x0C, 0x77, 0x20, 0x1D, 0x05, 0x77,
  0x20, 0x8C, 0x0D, 0x77, 0x30, 0xEC, 0x07, 0x77, 0x20, 0x7C, 0x0E, 0x77, 0x30, 0xDC, 0x08, 0x77,
  0x20, 0x5D, 0x01, 0x77, 0x20, 0xCC, 0x09, 0x77, 0x20, 0x4D, 0x02, 0x77, 0x20, 0xBC, 0x0B, 0x77,
  0x20, 0x2D, 0x04, 0x77, 0x20, 0xAC, 0x0C, 0x77, 0x20, 0x1D, 0x05, 0x77, 0x20, 0x8C, 0x0D, 0x77,
  0x30, 0xEC, 0x06, 0x77, 0x20, 0x7C, 0x0E, 0x77, 0x30, 0xDC, 0x08, 0x77, 0x20, 0x5D, 0x01, 0x77,
  0x20, 0xCC, 0x09, 0x77, 0x20, 0x4D, 0x02, 0x77, 0x20, 0xBC, 0x0A, 0x77, 0x20, 0x2D, 0x03, 0x77,
  0x20, 0x9C, 0x0C, 0x77, 0x20, 0x1D, 0x04, 0x77, 0x20, 0x8C, 0x0D, 0x77, 0x30, 0xEC, 0x06, 0x77,
  0x20, 0x7C, 0x0E, 0x77, 0x30, 0xDC, 0x07, 0x77, 0x20, 0x5C, 0x0E, 0x01, 0x77, 0x20, 0xCC, 0x0B,
  0x80, 0x93, 0x50, 0x40, 0x2F, 0xFF, 0x0E, 0x03, 0xFF, 0xF0, 0xE0, 0x3F, 0xFF, 0x0E, 0x03, 0xFF,
  0xF0, 0xE0,
  // "ź" (U+017A)
  0x74, 0x02, 0x80, 0x17, 0x06, 0x75, 0x0A, 0xD0, 0x77, 0x40, 0x3D, 0x0C, 0x75, 0x0C, 0xC0, 0xE0,
  0x17, 0x40, 0x6C, 0x0E, 0x03, 0x74, 0x01, 0x0E, 0xC0, 0x47, 0x50, 0xAC, 0x05, 0x75, 0x05, 0xC0,
  0x57, 0x50, 0x10, 0xEB, 0x05, 0x76, 0x08, 0xA0, 0xE0, 0x48, 0x09, 0xC4, 0x00, 0x8F, 0xFA, 0x81,
  0x30, 0x8F, 0xFA, 0x81, 0x30, 0x8F, 0xFA, 0x81, 0x30, 0x8F, 0xFA, 0x81, 0x30, 0x28, 0x06, 0x50,
  0xAC, 0x0D, 0x76, 0x0D, 0xC0, 0x57, 0x50, 0x6C, 0x0D, 0x76, 0x0D, 0xC0, 0x57, 0x50, 0x5C, 0x0D,
  0x76, 0x0D, 0xC0, 0x57, 0x50, 0x5C, 0x0D, 0x76, 0x0D, 0xC0, 0x57, 0x50, 0x5C, 0x0D, 0x76, 0x0D,
  0xC0, 0x57, 0x50, 0x5C, 0x0D, 0x76, 0x0C, 0xC0, 0x57, 0x50, 0x5C, 0x0D, 0x76, 0x0C, 0xC0, 0x57,
  0x50, 0x4C, 0x0D, 0x76, 0x0C, 0xC0, 0x67, 0x50, 0x4C, 0x0D, 0x76, 0x0C, 0xC0, 0x67, 0x50, 0x4C,
  0x0D, 0x76, 0x0C, 0xC0, 0x67, 0x50, 0x4C, 0x0D, 0x76, 0x0C, 0xC0, 0x67, 0x50, 0x4C, 0x0D, 0x76,
  0x0B, 0xC0, 0xA8, 0x07, 0x50, 0x03, 0xFF, 0xB0, 0x90, 0x4F, 0xFB, 0x09, 0x04, 0xFF, 0xB0, 0x90,
  0x4F, 0xFB, 0x09,
  // "Ż" (U+017B)
  0x73, 0x83, 0x5D, 0xEB, 0x27, 0x73, 0x02, 0xC0, 0xC7, 0x73, 0x07, 0xD0, 0x17, 0x72, 0x08, 0xD0,
  0x27, 0x72, 0x07, 0xD0, 0x17, 0x72, 0x02, 0xC0, 0xB7, 0x74, 0x83, 0x4D, 0xEB, 0x18, 0x0A, 0x97,
  0x00, 0xDF, 0xFE, 0x81, 0x70, 0xDF, 0xFE, 0x81, 0x70, 0xDF, 0xFE, 0x81, 0x70, 0xDF, 0xFE, 0x81,
  0x60, 0x48, 0x09, 0x25, 0x09, 0xD0, 0x27, 0x72, 0x0C, 0xC0, 0xA7, 0x72, 0x04, 0xD0, 0x37, 0x72,
  0x0B, 0xC0, 0xB7, 0x72, 0x03, 0xD0, 0x47, 0x72, 0x0A, 0xC0, 0xC7, 0x72, 0x01, 0xD0, 0x57, 0x72,
  0x08, 0xC0, 0xD7, 0x73, 0x0E, 0xC0, 0x77, 0x72, 0x07, 0xC0, 0xE7, 0x73, 0x0D, 0xC0, 0x87, 0x72,
  0x05, 0xD0, 0x17, 0x72, 0x0C, 0xC0, 0x97, 0x72, 0x04, 0xD0, 0x27, 0x72, 0x0B, 0xC0, 0xB7, 0x72,
  0x02, 0xD0, 0x47, 0x72, 0x0A, 0xC0, 0xC7, 0x72, 0x01, 0xD0, 0x57, 0x72, 0x08, 0xC0, 0xD7, 0x73,
  0x0E, 0xC0, 0x67, 0x72, 0x07, 0xC0, 0xE7, 0x73, 0x0D, 0xC0, 0x87, 0x72, 0x05, 0xD0, 0x17, 0x72,
  0x0C, 0xC0, 0x97, 0x72, 0x04, 0xD0, 0x27, 0x72, 0x0B, 0xC0, 0xA7, 0x72, 0x02, 0xD0, 0x37, 0x72,
  0x09, 0xC0, 0xC7, 0x72, 0x01, 0xD0, 0x47, 0x72, 0x08, 0xC0, 0xD7, 0x73, 0x0E, 0xC0, 0x67, 0x72,
  0x07, 0xC0, 0xE7, 0x73, 0x0D, 0xC0, 0x77, 0x72, 0x05, 0xC0, 0xE0, 0x17, 0x72, 0x0C, 0xC0, 0xB8,
  0x09, 0x35, 0x04, 0x02, 0xFF, 0xF0, 0xE0, 0x3F, 0xFF, 0x0E, 0x03, 0xFF, 0xF0, 0xE0, 0x3F, 0xFF,
  0x0E,
  // "ż" (U+017C)
  0x71, 0x83, 0x5D, 0xEB, 0x27, 0x60, 0x2C, 0x0C, 0x76, 0x07, 0xD0, 0x17, 0x50, 0x8D, 0x02, 0x75,
  0x07, 0xD0, 0x17, 0x50, 0x2C, 0x0B, 0x77, 0x83, 0x4D, 0xEB, 0x18, 0x09, 0xE5, 0x00, 0x8F, 0xFA,
  0x81, 0x30, 0x8F, 0xFA, 0x81, 0x30, 0x8F, 0xFA, 0x81, 0x30, 0x8F, 0xFA, 0x81, 0x30, 0x28, 0x06,
  0x50, 0xAC, 0x0D, 0x76, 0x0D, 0xC0, 0x57, 0x50, 0x6C, 0x0D, 0x76, 0x0D, 0xC0, 0x57, 0x50, 0x5C,
  0x0D, 0x76, 0x0D, 0xC0, 0x57, 0x50, 0x5C, 0x0D, 0x76, 0x0D, 0xC0, 0x57, 0x50, 0x5C, 0x0D, 0x76,
  0x0D, 0xC0, 0x57, 0x50, 0x5C, 0x0D, 0x76, 0x0C, 0xC0, 0x57, 0x50, 0x5C, 0x0D, 0x76, 0x0C, 0xC0,
  0x57, 0x50, 0x4C, 0x0D, 0x76, 0x0C, 0xC0, 0x67, 0x50, 0x4C, 0x0D, 0x76, 0x0C, 0xC0, 0x67, 0x50,
  0x4C, 0x0D, 0x76, 0x0C, 0xC0, 0x67, 0x50, 0x4C, 0x0D, 0x76, 0x0C, 0xC0, 0x67, 0x50, 0x4C, 0x0D,
  0x76, 0x0B, 0xC0, 0xA8, 0x07, 0x50, 0x03, 0xFF, 0xB0, 0x90, 0x4F, 0xFB, 0x09, 0x04, 0xFF, 0xB0,
  0x90, 0x4F, 0xFB, 0x09,
  // "Ž" (U+017D)
  0x38, 0x24, 0x77, 0x57, 0x38, 0x26, 0x77, 0x35, 0x05, 0xB0, 0x87, 0x10, 0x9B, 0x03, 0x60, 0x8B,
  0x08, 0x60, 0xAB, 0x06, 0x71, 0x0C, 0xB0, 0x84, 0x0A, 0xB0, 0x97, 0x20, 0x20, 0xEB, 0x07, 0x20,
  0xAB, 0x0D, 0x74, 0x05, 0xC0, 0x60, 0x9C, 0x02, 0x75, 0x0A, 0xF9, 0x07, 0x76, 0x01, 0x0E, 0xE0,
  0xB7, 0x71, 0x06, 0xE0, 0x27, 0x72, 0x0C, 0xC0, 0x98, 0x09, 0xF0, 0x00, 0xDF, 0xFE, 0x81, 0x70,
  0xDF, 0xFE, 0x81, 0x70, 0xDF, 0xFE, 0x81, 0x70, 0xDF, 0xFE, 0x81, 0x60, 0x48, 0x09, 0x25, 0x09,
  0xD0, 0x27, 0x72, 0x0C, 0xC0, 0xA7, 0x72, 0x04, 0xD0, 0x37, 0x72, 0x0B, 0xC0, 0xB7, 0x72, 0x03,
  0xD0, 0x47, 0x72, 0x0A, 0xC0, 0xC7, 0x72, 0x01, 0xD0, 0x57, 0x72, 0x08, 0xC0, 0xD7, 0x73, 0x0E,
  0xC0, 0x77, 0x72, 0x07, 0xC0, 0xE7, 0x73, 0x0D, 0xC0, 0x87, 0x72, 0x05, 0xD0, 0x17, 0x72, 0x0C,
  0xC0, 0x97, 0x72, 0x04, 0xD0, 0x27, 0x72, 0x0B, 0xC0, 0xB7, 0x72, 0x02, 0xD0, 0x47, 0x72, 0x0A,
  0xC0, 0xC7, 0x72, 0x01, 0xD0, 0x57, 0x72, 0x08, 0xC0, 0xD7, 0x73, 0x0E, 0xC0, 0x67, 0x72, 0x07,
  0xC0, 0xE7, 0x73, 0x0D, 0xC0, 0x87, 0x72, 0x05, 0xD0, 0x17, 0x72, 0x0C, 0xC0, 0x97, 0x72, 0x04,
  0xD0, 0x27, 0x72, 0x0B, 0xC0, 0xA7, 0x72, 0x02, 0xD0, 0x37, 0x72, 0x09, 0xC0, 0xC7, 0x72, 0x01,
  0xD0, 0x47, 0x72, 0x08, 0xC0, 0xD7, 0x73, 0x0E, 0xC0, 0x67, 0x72, 0x07, 0xC0, 0xE7, 0x73, 0x0D,
  0xC0, 0x77, 0x72, 0x05, 0xC0, 0xE0, 0x17, 0x72, 0x0C, 0xC0, 0xB8, 0x09, 0x35, 0x04, 0x02, 0xFF,
  0xF0, 0xE0, 0x3F, 0xFF, 0x0E, 0x03, 0xFF, 0xF0, 0xE0, 0x3F, 0xFF, 0x0E,
  // "ž" (U+017E)
  0x18, 0x24, 0x77, 0x57, 0x38, 0x46, 0x77, 0x30, 0x5B, 0x08, 0x71, 0x09, 0xB0, 0x32, 0x08, 0xB0,
  0x86, 0x0A, 0xB0, 0x64, 0x0C, 0xB0, 0x84, 0x0A, 0xB0, 0x95, 0x02, 0x0E, 0xB0, 0x72, 0x0A, 0xB0,
  0xD7, 0x05, 0xC0, 0x60, 0x9C, 0x02, 0x71, 0x0A, 0xF9, 0x07, 0x72, 0x01, 0x0E, 0xE0, 0xB7, 0x40,
  0x6E, 0x02, 0x75, 0x0C, 0xC0, 0x98, 0x09, 0xC2, 0x00, 0x8F, 0xFA, 0x81, 0x30, 0x8F, 0xFA, 0x81,
  0x30, 0x8F, 0xFA, 0x81, 0x30, 0x8F, 0xFA, 0x81, 0x30, 0x28, 0x06, 0x50, 0xAC, 0x0D, 0x76, 0x0D,
  0xC0, 0x57, 0x50, 0x6C, 0x0D, 0x76, 0x0D, 0xC0, 0x57, 0x50, 0x5C, 0x0D, 0x76, 0x0D, 0xC0, 0x57,
  0x50, 0x5C, 0x0D, 0x76, 0x0D, 0xC0, 0x57, 0x50, 0x5C, 0x0D, 0x76, 0x0D, 0xC0, 0x57, 0x50, 0x5C,
  0x0D, 0x76, 0x0C, 0xC0, 0x57, 0x50, 0x5C, 0x0D, 0x76, 0x0C, 0xC0, 0x57, 0x50, 0x4C, 0x0D, 0x76,
  0x0C, 0xC0, 0x67, 0x50, 0x4C, 0x0D, 0x76, 0x0C, 0xC0, 0x67, 0x50, 0x4C, 0x0D, 0x76, 0x0C, 0xC0,
  0x67, 0x50, 0x4C, 0x0D, 0x76, 0x0C, 0xC0, 0x67, 0x50, 0x4C, 0x0D, 0x76, 0x0B, 0xC0, 0xA8, 0x07,
  0x50, 0x03, 0xFF, 0xB0, 0x90, 0x4F, 0xFB, 0x09, 0x04, 0xFF, 0xB0, 0x90, 0x4F, 0xFB, 0x09,
  // "ſ" (U+017F)
  0x58, 0x76, 0xBD, 0xFE, 0xDA, 0x61, 0x30, 0x40, 0xDF, 0x90, 0xC2, 0x03, 0xFB, 0x07, 0x20, 0xDF,
  0xB8, 0x13, 0x06, 0xD8, 0x4B, 0x65, 0x8E, 0xE2, 0x0B, 0xC0, 0x95, 0x03, 0x2D, 0x01, 0x70, 0x3C,
  0x0C, 0x71, 0x05, 0xC0, 0xA7, 0x10, 0x7C, 0x08, 0x71, 0x08, 0xC0, 0x77, 0x10, 0x8C, 0x07, 0x71,
  0x08, 0xC0, 0x77, 0x10, 0x8C, 0x07, 0x71, 0x08, 0xC0, 0x77, 0x10, 0x8C, 0x07, 0x71, 0x08, 0xC0,
  0x77, 0x10, 0x8C, 0x07, 0x71, 0x08, 0xC0, 0x77, 0x10, 0x8C, 0x07, 0x71, 0x08, 0xC0, 0x77, 0x10,
  0x8C, 0x07, 0x71, 0x08, 0xC0, 0x77, 0x10, 0x8C, 0x07, 0x71, 0x08, 0xC0, 0x77, 0x10, 0x8C, 0x07,
  0x71, 0x08, 0xC0, 0x77, 0x10, 0x8C, 0x07, 0x71, 0x08, 0xC0, 0x77, 0x10, 0x8C, 0x07, 0x71, 0x08,
  0xC0, 0x77, 0x10, 0x8C, 0x07, 0x71, 0x08, 0xC0, 0x77, 0x10, 0x8C, 0x07, 0x71, 0x08, 0xC0, 0x77,
  0x10, 0x8C, 0x07, 0x71, 0x08, 0xC0, 0x77, 0x10, 0x8C, 0x07, 0x71, 0x08, 0xC0, 0x77, 0x10, 0x8C,
  0x07, 0x71, 0x08, 0xC0, 0x77, 0x10, 0x8C, 0x07, 0x71, 0x08, 0xC0, 0x77, 0x10, 0x8C, 0x07, 0x71,
  0x08, 0xC0, 0x77, 0x10, 0x8C, 0x07, 0x71,
  // "Ω" (U+03A9)
  0x77, 0x86, 0x35, 0x67, 0x76, 0x41, 0x77, 0x73, 0x05, 0x0B, 0xFA, 0x81, 0xD8, 0x27, 0x75, 0x05,
  0x0D, 0xFF, 0x09, 0x01, 0x77, 0x20, 0x9F, 0xFB, 0x0E, 0x03, 0x77, 0x0B, 0xF9, 0x81, 0xED, 0xEF,
  0x90, 0xE0, 0x37, 0x50, 0xAE, 0x81, 0xB6, 0x14, 0x81, 0x38, 0xED, 0x0E, 0x02, 0x73, 0x06, 0xD0,
  0xE0, 0x57, 0x20, 0x10, 0xBD, 0x0C, 0x72, 0x01, 0x0E, 0xD0, 0x37, 0x50, 0xBD, 0x06, 0x71, 0x08,
  0xD0, 0x57, 0x60, 0x10, 0xDC, 0x0E, 0x71, 0x0E, 0xC0, 0xC7, 0x71, 0x05, 0xD0, 0x56, 0x04, 0xD0,
  0x47, 0x72, 0x0D, 0xC0, 0xB6, 0x09, 0xC0, 0xD7, 0x73, 0x07, 0xD0, 0x15, 0x0D, 0xC0, 0x97, 0x73,
  0x03, 0xD0, 0x44, 0x01, 0xD0, 0x57, 0x74, 0x0E, 0xC0, 0x84, 0x03, 0xD0, 0x27, 0x74, 0x0B, 0xC0,
  0xA4, 0x06, 0xD7, 0x75, 0x09, 0xC0, 0xC4, 0x07, 0xC0, 0xD7, 0x75, 0x06, 0xC0, 0xE4, 0x08, 0xC0,
  0xC7, 0x75, 0x05, 0xD4, 0x09, 0xC0, 0xB7, 0x75, 0x05, 0xD4, 0x09, 0xC0, 0xB7, 0x75, 0x04, 0xD0,
  0x13, 0x09, 0xC0, 0xB7, 0x75, 0x04, 0xD4, 0x09, 0xC0, 0xB7, 0x75, 0x04, 0xD4, 0x08, 0xC0, 0xC7,
  0x75, 0x05, 0xD4, 0x07, 0xC0, 0xD7, 0x75, 0x06, 0xC0, 0xE4, 0x05, 0xC0, 0xE7, 0x75, 0x07, 0xC0,
  0xC4, 0x03, 0xD7, 0x75, 0x09, 0xC0, 0xA4, 0x01, 0xD0, 0x37, 0x74, 0x0B, 0xC0, 0x85, 0x0D, 0xC0,
  0x57, 0x74, 0x0E, 0xC0, 0x55, 0x0A, 0xC0, 0x87, 0x73, 0x01, 0xD0, 0x15, 0x06, 0xC0, 0xC7, 0x73,
  0x05, 0xC0, 0xD6, 0x01, 0xD0, 0x17, 0x72, 0x09, 0xC0, 0x87, 0x0B, 0xC0, 0x67, 0x72, 0x0D, 0xC0,
  0x37, 0x05, 0xC0, 0xC7, 0x71, 0x04, 0xC0, 0xC7, 0x20, 0xDC, 0x03, 0x77, 0x0A, 0xC0, 0x57, 0x20,
  0x5C, 0x0A, 0x76, 0x02, 0xC0, 0xC7, 0x40, 0xCC, 0x03, 0x75, 0x0B, 0xC0, 0x47, 0x40, 0x3C, 0x0C,
  0x74, 0x05, 0xC0, 0x97, 0x60, 0x6C, 0x09, 0x72, 0x02, 0x0E, 0xB0, 0xD7, 0x71, 0x09, 0xC0, 0x57,
  0x01, 0x0C, 0xB0, 0xE0, 0x27, 0x18, 0x04, 0x50, 0xDC, 0x04, 0x60, 0xCC, 0x07, 0x80, 0x35, 0x00,
  0x2F, 0xE0, 0xE5, 0x07, 0xFE, 0x09, 0x02, 0xFE, 0x0E, 0x50, 0x8F, 0xE0, 0x90, 0x2F, 0xE0, 0xE5,
  0x08, 0xFE, 0x09, 0x02, 0xFE, 0x0E, 0x50, 0x8F, 0xE0, 0x90,
  // "μ" (U+03BC)
  0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40,
  0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0,
  0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02,
  0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40,
  0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0,
  0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02,
  0x0B, 0xC0, 0x37, 0x40, 0xCC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xDC, 0x02, 0x0B, 0xC0, 0x37, 0x40,
  0xDC, 0x02, 0x0B, 0xC0, 0x37, 0x40, 0xEC, 0x02, 0x0B, 0xC0, 0x37, 0x4D, 0x02, 0x0B, 0xC0, 0x47,
  0x30, 0x3D, 0x02, 0x0B, 0xC0, 0x57, 0x30, 0x6D, 0x02, 0x0B, 0xC0, 0x77, 0x30, 0xAD, 0x02, 0x0B,
  0xC0, 0xB7, 0x20, 0x1E, 0x02, 0x0B, 0xD0, 0x17, 0x10, 0x8E, 0x02, 0x0B, 0xD0, 0xA7, 0x05, 0xF0,
  0x20, 0xBE, 0x0A, 0x02, 0x30, 0x30, 0x9B, 0x0C, 0xC0, 0x20, 0xBF, 0x98, 0x1D, 0xDE, 0xC0, 0xB0,
  0x5C, 0x02, 0x0B, 0xC0, 0xEF, 0xA8, 0x1E, 0x22, 0xC0, 0x20, 0xBC, 0x04, 0xF9, 0x0E, 0x03, 0x2C,
  0x02, 0x0B, 0xC8, 0x11, 0x3D, 0xD0, 0xB0, 0x23, 0x0D, 0xB0, 0x20, 0xBC, 0x02, 0x28, 0x33, 0x67,
  0x52, 0x73, 0x0B, 0xC0, 0x27, 0x73, 0x0B, 0xC0, 0x37, 0x73, 0x0B, 0xC0, 0x37, 0x73, 0x0B, 0xC0,
  0x37, 0x73, 0x0B, 0xC0, 0x37, 0x73, 0x0B, 0xC0, 0x37, 0x73, 0x0B, 0xC0, 0x37, 0x73, 0x0B, 0xC0,
  0x37, 0x73, 0x0B, 0xC0, 0x37, 0x73, 0x0B, 0xC0, 0x37, 0x73, 0x0B, 0xC0, 0x37, 0x73, 0x0B, 0xC0,
  0x37, 0x73, 0x0B, 0xC0, 0x37, 0x73,
  // "π" (U+03C0)
  0x20, 0x20, 0xBF, 0xFF, 0xD8, 0x2B, 0x07, 0xEF, 0xFF, 0xE0, 0xB0, 0x7F, 0xFF, 0xF9, 0x0B, 0x08,
  0xFF, 0xFF, 0x98, 0x5B, 0x25, 0x55, 0x58, 0xC0, 0xB8, 0x05, 0x50, 0xAC, 0x84, 0xA5, 0x55, 0x53,
  0x50, 0x5C, 0x09, 0x72, 0x07, 0xC0, 0x77, 0x30, 0x5C, 0x09, 0x72, 0x07, 0xC0, 0x77, 0x30, 0x5C,
  0x09, 0x72, 0x07, 0xC0, 0x77, 0x30, 0x5C, 0x09, 0x72, 0x07, 0xC0, 0x77, 0x30, 0x5C, 0x09, 0x72,
  0x07, 0xC0, 0x77, 0x30, 0x5C, 0x09, 0x72, 0x07, 0xC0, 0x77, 0x30, 0x5C, 0x09, 0x72, 0x07, 0xC0,
  0x77, 0x30, 0x5C, 0x09, 0x72, 0x07, 0xC0, 0x77, 0x30, 0x5C, 0x09, 0x72, 0x07, 0xC0, 0x77, 0x30,
  0x5C, 0x09, 0x72, 0x07, 0xC0, 0x77, 0x30, 0x5C, 0x09, 0x72, 0x07, 0xC0, 0x77, 0x30, 0x5C, 0x09,
  0x72, 0x07, 0xC0, 0x77, 0x30, 0x5C, 0x09, 0x72, 0x07, 0xC0, 0x77, 0x30, 0x5C, 0x09, 0x72, 0x07,
  0xC0, 0x77, 0x30, 0x5C, 0x09, 0x72, 0x07, 0xC0, 0x77, 0x30, 0x5C, 0x09, 0x72, 0x07, 0xC0, 0x77,
  0x30, 0x5C, 0x09, 0x72, 0x07, 0xC0, 0x77, 0x30, 0x5C, 0x09, 0x72, 0x07, 0xC0, 0x77, 0x30, 0x5C,
  0x09, 0x72, 0x07, 0xC0, 0x77, 0x30, 0x5C, 0x09, 0x72, 0x07, 0xC0, 0x77, 0x30, 0x5C, 0x09, 0x72,
  0x07, 0xC0, 0x87, 0x30, 0x5C, 0x09, 0x72, 0x06, 0xC0, 0xA7, 0x30, 0x5C, 0x09, 0x72, 0x04, 0xC0,
  0xE0, 0x17, 0x20, 0x5C, 0x09, 0x72, 0x01, 0xD8, 0x3D, 0x65, 0x82, 0x50, 0x5C, 0x09, 0x73, 0x0B,
  0xF9, 0x03, 0x50, 0x5C, 0x09, 0x73, 0x03, 0xF9, 0x03, 0x50, 0x5C, 0x09, 0x74, 0x07, 0xF0, 0x35,
  0x84, 0x28, 0x88, 0x85, 0x75, 0x86, 0x3A, 0xEF, 0xED, 0x91,
  // "–" (U+2013)
  0x03, 0x80, 0xA4, 0x50, 0x30, 0xBF, 0xFF, 0xB0, 0x0B, 0xFF, 0xFB, 0x00, 0xBF, 0xFF, 0xB0, 0x0B,
  0xFF, 0xFB, 0x0B,
  // "—" (U+2014)
  0x03, 0x80, 0xE2, 0x50, 0x30, 0xB8, 0x0E, 0x2F, 0x00, 0xB8, 0x0E, 0x2F, 0x00, 0xB8, 0x0E, 0x2F,
  0x00, 0xB8, 0x0E, 0x2F, 0x0B,
  // "€" (U+20AC)
  0x77, 0x85, 0x14, 0x67, 0x65, 0x37, 0x73, 0x05, 0x0C, 0xF9, 0x0B, 0x06, 0x75, 0x02, 0x0B, 0xFD,
  0x0E, 0x07, 0x72, 0x03, 0x0E, 0xFF, 0x0C, 0x71, 0x02, 0x0E, 0xE8, 0x1E, 0xDE, 0xE0, 0x57, 0x10,
  0xDD, 0x0A, 0x03, 0x40, 0x50, 0xBA, 0x0D, 0x71, 0x08, 0xD0, 0x57, 0x18, 0x13, 0xC6, 0x70, 0x1D,
  0x07, 0x77, 0x50, 0x8C, 0x0C, 0x77, 0x60, 0xEC, 0x04, 0x77, 0x50, 0x5C, 0x0D, 0x77, 0x60, 0x9C,
  0x07, 0x77, 0x60, 0xEC, 0x03, 0x77, 0x50, 0x1D, 0x77, 0x60, 0x5C, 0x0C, 0x77, 0x60, 0x7C, 0x0A,
  0x77, 0x60, 0x9C, 0x07, 0x77, 0x2F, 0xFE, 0x01, 0x5F, 0xFE, 0x01, 0x5F, 0xFE, 0x01, 0x5F, 0xFE,
  0x01, 0x72, 0xD0, 0x17, 0x76, 0xD0, 0x17, 0x76, 0xD0, 0x17, 0x76, 0xD0, 0x17, 0x72, 0xFF, 0xC0,
  0xC7, 0xFF, 0xC0, 0xC7, 0xFF, 0xC0, 0xC7, 0xFF, 0xC0, 0xC7, 0x40, 0x8C, 0x07, 0x77, 0x60, 0x6C,
  0x0A, 0x77, 0x60, 0x3C, 0x0C, 0x77, 0x7D, 0x01, 0x77, 0x60, 0xBC, 0x05, 0x77, 0x60, 0x7C, 0x0A,
  0x77, 0x60, 0x2D, 0x01, 0x77, 0x60, 0xBC, 0x09, 0x77, 0x60, 0x4D, 0x05, 0x77, 0x60, 0xBD, 0x05,
  0x73, 0x05, 0x02, 0x70, 0x20, 0xED, 0x0A, 0x04, 0x58, 0x34, 0x8D, 0xF4, 0x71, 0x05, 0xF9, 0x81,
  0xDD, 0xED, 0x04, 0x72, 0x07, 0xFF, 0x90, 0x47, 0x30, 0x40, 0xEF, 0xE0, 0x47, 0x50, 0x70, 0xDF,
  0x98, 0x1E, 0xA4, 0x77, 0x18, 0x62, 0x56, 0x77, 0x64, 0x24,
  // "₿" (U+20BF)
  0x50, 0xBA, 0x07, 0x3B, 0x03, 0x75, 0x0B, 0xA0, 0x73, 0xB0, 0x37, 0x50, 0xBA, 0x07, 0x3B, 0x03,
  0x75, 0x0B, 0xA0, 0x73, 0xB0, 0x37, 0x50, 0xBA, 0x07, 0x3B, 0x03, 0x75, 0x0B, 0xA0, 0x73, 0xB0,
  0x37, 0x03, 0xFA, 0x0E, 0x0D, 0xB0, 0x47, 0x03, 0xFF, 0x90, 0xB0, 0x35, 0x03, 0xFF, 0xB0, 0x64,
  0x03, 0xFF, 0xC0, 0x63, 0x03, 0xD8, 0x01, 0x50, 0x70, 0xBF, 0x02, 0x20, 0x3C, 0x0E, 0x70, 0x20,
  0xDD, 0x09, 0x20, 0x3C, 0x0E, 0x71, 0x01, 0x0D, 0xC0, 0xE2, 0x03, 0xC0, 0xE7, 0x20, 0x6D, 0x81,
  0x30, 0x3C, 0x0E, 0x73, 0xD8, 0x16, 0x03, 0xC0, 0xE7, 0x30, 0xDC, 0x81, 0x70, 0x3C, 0x0E, 0x73,
  0x0B, 0xC8, 0x18, 0x03, 0xC0, 0xE7, 0x30, 0xBC, 0x81, 0x80, 0x3C, 0x0E, 0x73, 0x0C, 0xC8, 0x17,
  0x03, 0xC0, 0xE7, 0x30, 0xEC, 0x81, 0x50, 0x3C, 0x0E, 0x72, 0x01, 0xD8, 0x12, 0x03, 0xC0, 0xE7,
  0x20, 0x7C, 0x0D, 0x20, 0x3C, 0x0E, 0x71, 0x01, 0x0E, 0xC0, 0x72, 0x03, 0xC0, 0xE7, 0x01, 0x0C,
  0xC0, 0xD3, 0x03, 0xD8, 0x01, 0x50, 0x60, 0xAD, 0x0E, 0x03, 0x30, 0x3F, 0xFA, 0x0D, 0x03, 0x40,
  0x3F, 0xF9, 0x05, 0x60, 0x3F, 0xFA, 0x0A, 0x02, 0x40, 0x3F, 0xFC, 0x05, 0x30, 0x3C, 0x0E, 0x58,
  0x11, 0x49, 0xE0, 0x52, 0x03, 0xC0, 0xE7, 0x10, 0x20, 0xDC, 0x82, 0xE1, 0x03, 0xC0, 0xE7, 0x20,
  0x3D, 0x81, 0x90, 0x3C, 0x0E, 0x73, 0x09, 0xC8, 0x1E, 0x03, 0xC0, 0xE7, 0x30, 0x4D, 0x02, 0x03,
  0xC0, 0xE7, 0x30, 0x1D, 0x05, 0x03, 0xC0, 0xE7, 0x40, 0xEC, 0x06, 0x03, 0xC0, 0xE7, 0x40, 0xDC,
  0x07, 0x03, 0xC0, 0xE7, 0x40, 0xEC, 0x07, 0x03, 0xC0, 0xE7, 0x4D, 0x06, 0x03, 0xC0, 0xE7, 0x30,
  0x2D, 0x04, 0x03, 0xC0, 0xE7, 0x30, 0x6D, 0x02, 0x03, 0xC0, 0xE7, 0x30, 0xCC, 0x81, 0xD0, 0x3C,
  0x0E, 0x72, 0x06, 0xD8, 0x18, 0x03, 0xC0, 0xE7, 0x10, 0x6E, 0x81, 0x10, 0x3D, 0x80, 0x15, 0x81,
  0x68, 0xDE, 0x08, 0x20, 0x3F, 0xFC, 0x0C, 0x30, 0x3F, 0xFB, 0x0C, 0x01, 0x30, 0x3F, 0xF9, 0x0E,
  0x07, 0x50, 0x3F, 0xF0, 0x77, 0x50, 0xBA, 0x07, 0x3B, 0x03, 0x75, 0x0B, 0xA0, 0x73, 0xB0, 0x37,
  0x50, 0xBA, 0x07, 0x3B, 0x03, 0x75, 0x0B, 0xA0, 0x73, 0xB0, 0x37, 0x50, 0xBA, 0x07, 0x3B, 0x03,
  0x75, 0x0B, 0xA0, 0x73, 0xB0, 0x37,
  // "‘" (U+2018)
  0x40, 0x1B, 0x0B, 0x40, 0x7B, 0x07, 0x40, 0xDB, 0x03, 0x30, 0x4C, 0x40, 0xAB, 0x0C, 0x30, 0x1C,
  0x09, 0x30, 0x6C, 0x05, 0x30, 0xBC, 0x02, 0x20, 0x1D, 0x30, 0x5C, 0x0C, 0x30, 0xAC, 0x0A, 0x30,
  0xEC, 0x07, 0x20, 0x3D, 0x05, 0x20, 0x7D, 0x03, 0x20, 0x8D, 0x01, 0x20,
  // "’" (U+2019)
  0x3D, 0x09, 0x20, 0x1D, 0x08, 0x20, 0x4D, 0x04, 0x20, 0x6D, 0x30, 0x8C, 0x0B, 0x30, 0xBC, 0x07,
  0x30, 0xDC, 0x02, 0x20, 0x1C, 0x0C, 0x30, 0x4C, 0x07, 0x30, 0x7C, 0x01, 0x30, 0xAB, 0x0B, 0x40,
  0xDB, 0x05, 0x30, 0x2B, 0x0E, 0x40, 0x5B, 0x09, 0x40, 0x9B, 0x03, 0x40,
  // "‚" (U+201A)
  0x3D, 0x09, 0x20, 0x1D, 0x08, 0x20, 0x4D, 0x04, 0x20, 0x6D, 0x30, 0x8C, 0x0B, 0x30, 0xBC, 0x07,
  0x30, 0xDC, 0x02, 0x20, 0x1C, 0x0C, 0x30, 0x4C, 0x07, 0x30, 0x7C, 0x01, 0x30, 0xAB, 0x0B, 0x40,
  0xDB, 0x05, 0x30, 0x2B, 0x0E, 0x40, 0x5B, 0x09, 0x40, 0x9B, 0x03, 0x40,
  // "‛" (U+201B)
  0x08, 0xD0, 0x22, 0x07, 0xD0, 0x32, 0x03, 0xD0, 0x53, 0x0E, 0xC0, 0x73, 0x0A, 0xC0, 0xA3, 0x05,
  0xC0, 0xC4, 0xD4, 0x0B, 0xC0, 0x23, 0x05, 0xC0, 0x54, 0x0E, 0xB0, 0x84, 0x09, 0xB0, 0xC4, 0x03,
  0xC5, 0x0C, 0xB0, 0x34, 0x07, 0xB0, 0x74, 0x01, 0xB0, 0xB0,
  // "“" (U+201C)
  0x40, 0x1B, 0x0A, 0x60, 0xDA, 0x0E, 0x40, 0x7B, 0x06, 0x50, 0x4B, 0x0B, 0x40, 0xEB, 0x02, 0x50,
  0xAB, 0x08, 0x30, 0x5B, 0x0E, 0x50, 0x1C, 0x05, 0x30, 0xBB, 0x0B, 0x50, 0x6C, 0x01, 0x20, 0x1C,
  0x08, 0x50, 0xCB, 0x0D, 0x30, 0x6C, 0x05, 0x40, 0x2C, 0x0A, 0x30, 0xBC, 0x02, 0x40, 0x7C, 0x07,
  0x20, 0x1C, 0x0E, 0x50, 0xCC, 0x04, 0x20, 0x6C, 0x0C, 0x40, 0x1D, 0x01, 0x20, 0xAC, 0x09, 0x40,
  0x6C, 0x0E, 0x30, 0xEC, 0x07, 0x40, 0xAC, 0x0B, 0x20, 0x3D, 0x05, 0x40, 0xEC, 0x09, 0x20, 0x7D,
  0x03, 0x30, 0x3D, 0x08, 0x20, 0x8D, 0x01, 0x30, 0x4D, 0x06, 0x20,
  // "”" (U+201D)
  0x3D, 0x09, 0x40, 0xAC, 0x0D, 0x20, 0x2D, 0x08, 0x40, 0xCC, 0x0C, 0x20, 0x4D, 0x04, 0x40, 0xEC,
  0x08, 0x20, 0x6D, 0x40, 0x1D, 0x04, 0x20, 0x8C, 0x0B, 0x40, 0x4D, 0x30, 0xBC, 0x07, 0x40, 0x7C,
  0x0B, 0x30, 0xEC, 0x02, 0x40, 0x9C, 0x06, 0x20, 0x1C, 0x0C, 0x50, 0xCC, 0x01, 0x20, 0x4C, 0x07,
  0x5C, 0x0B, 0x30, 0x7C, 0x01, 0x40, 0x4C, 0x05, 0x30, 0xAB, 0x0B, 0x50, 0x7B, 0x0E, 0x40, 0xDB,
  0x05, 0x50, 0xAB, 0x09, 0x30, 0x2B, 0x0E, 0x60, 0xEB, 0x03, 0x30, 0x5B, 0x09, 0x50, 0x2B, 0x0D,
  0x40, 0x9B, 0x03, 0x50, 0x5B, 0x07, 0x40,
  // "„" (U+201E)
  0x3D, 0x09, 0x40, 0xAC, 0x0D, 0x20, 0x2D, 0x08, 0x40, 0xCC, 0x0C, 0x20, 0x4D, 0x04, 0x40, 0xEC,
  0x08, 0x20, 0x6D, 0x40, 0x1D, 0x04, 0x20, 0x8C, 0x0B, 0x40, 0x4D, 0x30, 0xBC, 0x07, 0x40, 0x7C,
  0x0B, 0x30, 0xEC, 0x02, 0x40, 0x9C, 0x06, 0x20, 0x1C, 0x0C, 0x50, 0xCC, 0x01, 0x20, 0x4C, 0x07,
  0x5C, 0x0B, 0x30, 0x7C, 0x01, 0x40, 0x4C, 0x05, 0x30, 0xAB, 0x0B, 0x50, 0x7B, 0x0E, 0x40, 0xDB,
  0x05, 0x50, 0xAB, 0x09, 0x30, 0x2B, 0x0E, 0x60, 0xEB, 0x03, 0x30, 0x5B, 0x09, 0x50, 0x2B, 0x0D,
  0x40, 0x9B, 0x03, 0x50, 0x5B, 0x07, 0x40,
  // "‟" (U+201F)
  0x08, 0xD0, 0x13, 0x04, 0xD0, 0x62, 0x07, 0xD0, 0x33, 0x03, 0xD0, 0x82, 0x03, 0xD0, 0x54, 0x0E,
  0xC0, 0x93, 0x0E, 0xC0, 0x74, 0x0A, 0xC0, 0xB3, 0x0A, 0xC0, 0xA4, 0x06, 0xC0, 0xE3, 0x05, 0xC0,
  0xC4, 0x01, 0xD0, 0x12, 0x01, 0xD5, 0x0C, 0xC0, 0x43, 0x0B, 0xC0, 0x24, 0x07, 0xC0, 0x73, 0x06,
  0xC0, 0x54, 0x01, 0xC0, 0xA3, 0x01, 0xC0, 0x95, 0x0B, 0xB0, 0xD4, 0x0A, 0xB0, 0xC5, 0x05, 0xC0,
  0x13, 0x04, 0xC6, 0x0E, 0xB0, 0x54, 0x0D, 0xB0, 0x35, 0x09, 0xB0, 0x84, 0x07, 0xB0, 0x75, 0x03,
  0xB0, 0xB4, 0x01, 0xB0, 0xA6, 0x0D, 0xA0, 0xE0,
  // "†" (U+2020)
  0x71, 0x0B, 0xC0, 0xB7, 0x72, 0x0A, 0xC0, 0xA7, 0x72, 0x08, 0xC0, 0x87, 0x72, 0x07, 0xC0, 0x77,
  0x72, 0x05, 0xC0, 0x57, 0x72, 0x04, 0xC0, 0x47, 0x72, 0x03, 0xC0, 0x27, 0x72, 0x01, 0xC0, 0x17,
  0x73, 0xC7, 0x74, 0x0E, 0xA0, 0xD7, 0x74, 0x0D, 0xA0, 0xC7, 0x74, 0x0B, 0xA0, 0xA7, 0x28, 0x90,
  0x8F, 0xEC, 0xBA, 0x87, 0x6C, 0xA8, 0x91, 0xB6, 0x78, 0xAB, 0xCE, 0xFB, 0x8F, 0xFE, 0x0B, 0x08,
  0xFF, 0xE0, 0xB0, 0x8F, 0xFE, 0x86, 0xB4, 0x76, 0x54, 0x31, 0x20, 0xAA, 0x09, 0x28, 0x51, 0x24,
  0x56, 0x75, 0x72, 0x0A, 0xA0, 0xA7, 0x74, 0x0B, 0xA0, 0xA7, 0x74, 0x0C, 0xA0, 0xB7, 0x74, 0x0C,
  0xA0, 0xC7, 0x74, 0x0D, 0xA0, 0xC7, 0x74, 0x0D, 0xA0, 0xD7, 0x74, 0x0E, 0xA0, 0xD7, 0x74, 0xB0,
  0xE7, 0x74, 0xC7, 0x74, 0xC7, 0x73, 0x01, 0xC7, 0x73, 0x01, 0xC0, 0x17, 0x72, 0x02, 0xC0, 0x27,
  0x72, 0x03, 0xC0, 0x27, 0x72, 0x03, 0xC0, 0x37, 0x72, 0x04, 0xC0, 0x37, 0x72, 0x04, 0xC0, 0x47,
  0x72, 0x05, 0xC0, 0x57, 0x72, 0x05, 0xC0, 0x57, 0x72, 0x06, 0xC0, 0x67, 0x72, 0x07, 0xC0, 0x77,
  0x72, 0x07, 0xC0, 0x77, 0x72, 0x08, 0xC0, 0x87, 0x72, 0x08, 0xC0, 0x87, 0x72, 0x09, 0xC0, 0x97,
  0x72, 0x0A, 0xC0, 0xA7, 0x72, 0x0A, 0xC0, 0xA7, 0x72, 0x0B, 0xC0, 0xB7, 0x72, 0x0B, 0xC0, 0xC7,
  0x10,
  // "‡" (U+2021)
  0x71, 0x0B, 0xC0, 0xA7, 0x72, 0x09, 0xC0, 0x97, 0x72, 0x08, 0xC0, 0x77, 0x72, 0x06, 0xC0, 0x57,
  0x72, 0x05, 0xC0, 0x47, 0x72, 0x03, 0xC0, 0x27, 0x72, 0x02, 0xC0, 0x17, 0x73, 0xC7, 0x74, 0x0E,
  0xA0, 0xD7, 0x74, 0x0D, 0xA0, 0xC7, 0x28, 0x12, 0x21, 0x60, 0xBA, 0x0A, 0x68, 0x21, 0x23, 0x9B,
  0x84, 0xEC, 0xBA, 0x8D, 0xA8, 0x4C, 0x8A, 0xBC, 0xEB, 0x0C, 0x09, 0xFF, 0xE0, 0xC0, 0x9F, 0xFE,
  0x0C, 0x09, 0xFF, 0xE0, 0xC7, 0x20, 0xAA, 0x0A, 0x77, 0x40, 0xCA, 0x0B, 0x77, 0x40, 0xEA, 0x0D,
  0x77, 0x4C, 0x77, 0x30, 0x1C, 0x01, 0x77, 0x20, 0x3C, 0x02, 0x77, 0x20, 0x5C, 0x04, 0x77, 0x20,
  0x6C, 0x06, 0x77, 0x20, 0x6C, 0x05, 0x77, 0x20, 0x4C, 0x04, 0x77, 0x20, 0x3C, 0x02, 0x77, 0x20,
  0x1C, 0x77, 0x4B, 0x0E, 0x77, 0x40, 0xEA, 0x0D, 0x77, 0x40, 0xCA, 0x0B, 0x77, 0x40, 0xAA, 0x0A,
  0x72, 0x09, 0xFF, 0xE0, 0xC0, 0x9F, 0xFE, 0x0C, 0x09, 0xFF, 0xE0, 0xC0, 0x9E, 0x81, 0xED, 0xEA,
  0x81, 0xED, 0xEE, 0x85, 0xC4, 0x65, 0x42, 0x13, 0x0B, 0xA0, 0xA3, 0x84, 0x12, 0x35, 0x65, 0x72,
  0x0C, 0xA0, 0xB7, 0x74, 0x0E, 0xA0, 0xD7, 0x74, 0xC7, 0x73, 0x01, 0xC0, 0x17, 0x72, 0x03, 0xC0,
  0x27, 0x72, 0x05, 0xC0, 0x47, 0x72, 0x06, 0xC0, 0x57, 0x72, 0x08, 0xC0, 0x77, 0x72, 0x09, 0xC0,
  0x97, 0x72, 0x0B, 0xC0, 0xA7, 0x10,
  // "•" (U+2022)
  0x38, 0x61, 0x7C, 0xEF, 0xEB, 0x66, 0x05, 0x0E, 0xF0, 0xD0, 0x23, 0x03, 0xFB, 0x0D, 0x01, 0x20,
  0xDF, 0xC8, 0x19, 0x03, 0xFD, 0x81, 0xE0, 0x7F, 0xE0, 0x30, 0x9F, 0xE0, 0x50, 0xAF, 0xE0, 0x70,
  0xBF, 0xE0, 0x70, 0x9F, 0xE0, 0x50, 0x7F, 0xE0, 0x03, 0xFD, 0x0E, 0x20, 0xCF, 0xC0, 0x82, 0x03,
  0xFB, 0x0D, 0x40, 0x40, 0xEF, 0x0C, 0x01, 0x58, 0x61, 0x7C, 0xEF, 0xEB, 0x54,
  // "…" (U+2026)
  0x28, 0x21, 0x56, 0x37, 0x38, 0x21, 0x56, 0x37, 0x38, 0x21, 0x56, 0x33, 0x04, 0x0E, 0xB0, 0x97,
  0x10, 0x40, 0xEB, 0x09, 0x71, 0x04, 0x0E, 0xB0, 0x92, 0x0D, 0xD0, 0x37, 0x0D, 0xD0, 0x37, 0x0D,
  0xD0, 0x30, 0x2E, 0x07, 0x60, 0x2E, 0x07, 0x60, 0x2E, 0x07, 0x03, 0xE0, 0x86, 0x03, 0xE0, 0x86,
  0x03, 0xE0, 0x80, 0x2E, 0x07, 0x60, 0x2E, 0x07, 0x60, 0x2E, 0x81, 0x70, 0xDD, 0x03, 0x70, 0xDD,
  0x03, 0x70, 0xDD, 0x82, 0x30, 0x4E, 0xB0, 0x87, 0x10, 0x40, 0xEB, 0x08, 0x71, 0x04, 0x0E, 0xB0,
  0x83, 0x82, 0x16, 0x63, 0x73, 0x82, 0x16, 0x63, 0x73, 0x82, 0x16, 0x63, 0x20,
  // "‰" (U+2030)
  0x68, 0x24, 0x66, 0x48, 0x0D, 0x70, 0x06, 0x0E, 0xC0, 0xE0, 0x77, 0x60, 0x1C, 0x01, 0x77, 0x77,
  0x10, 0x7F, 0x90, 0x97, 0x50, 0x7B, 0x0A, 0x77, 0x77, 0x10, 0x4F, 0xB0, 0x67, 0x40, 0xDB, 0x03,
  0x77, 0x77, 0x10, 0xCB, 0x82, 0xE9, 0x9E, 0xB0, 0xE7, 0x30, 0x4B, 0x0D, 0x77, 0x77, 0x10, 0x3B,
  0x0E, 0x02, 0x20, 0x20, 0xEB, 0x06, 0x72, 0x0B, 0xB0, 0x67, 0x77, 0x71, 0x08, 0xB0, 0x94, 0x07,
  0xB0, 0xB7, 0x10, 0x1B, 0x0E, 0x01, 0x77, 0x77, 0x10, 0xCB, 0x04, 0x40, 0x2C, 0x71, 0x08, 0xB0,
  0x97, 0x77, 0x72, 0xC0, 0x15, 0x0E, 0xB0, 0x47, 0x0E, 0xB0, 0x37, 0x77, 0x71, 0x02, 0xB0, 0xE6,
  0x0B, 0xB0, 0x66, 0x05, 0xB0, 0xC7, 0x77, 0x72, 0x04, 0xB0, 0xD6, 0x09, 0xB0, 0x86, 0x0B, 0xB0,
  0x57, 0x77, 0x72, 0x05, 0xB0, 0xB6, 0x08, 0xB0, 0x95, 0x02, 0xB0, 0xE7, 0x77, 0x73, 0x05, 0xB0,
  0xB6, 0x08, 0xB0, 0xA5, 0x09, 0xB0, 0x87, 0x77, 0x73, 0x06, 0xB0, 0xB6, 0x07, 0xB0, 0xA5, 0x0E,
  0xB0, 0x27, 0x77, 0x73, 0x06, 0xB0, 0xB6, 0x08, 0xB0, 0xA4, 0x06, 0xB0, 0xB7, 0x77, 0x74, 0x05,
  0xB0, 0xB6, 0x08, 0xB0, 0x94, 0x0C, 0xB0, 0x57, 0x77, 0x74, 0x04, 0xB0, 0xC6, 0x09, 0xB0, 0x93,
  0x03, 0xB0, 0xD7, 0x77, 0x75, 0x03, 0xB0, 0xE6, 0x0B, 0xB0, 0x73, 0x09, 0xB0, 0x73, 0x85, 0x29,
  0xDE, 0xDB, 0x47, 0x48, 0x53, 0xAD, 0xFD, 0x92, 0x6C, 0x60, 0xDB, 0x05, 0x20, 0x1C, 0x01, 0x20,
  0x50, 0xEE, 0x09, 0x72, 0x08, 0xF0, 0x65, 0x0D, 0xB0, 0x34, 0x01, 0xC0, 0x22, 0x07, 0xB0, 0xA2,
  0x03, 0xFA, 0x08, 0x70, 0x7F, 0xA0, 0x54, 0x09, 0xB0, 0x84, 0x06, 0xB0, 0xD3, 0x0D, 0xB0, 0x42,
  0x0D, 0xFB, 0x03, 0x50, 0x2F, 0xB0, 0xE0, 0x13, 0x05, 0xB0, 0xE0, 0x12, 0x01, 0x0D, 0xB0, 0x92,
  0x04, 0xB0, 0xD2, 0x05, 0xC8, 0x25, 0x03, 0xDB, 0x0B, 0x50, 0x8B, 0x82, 0xD3, 0x05, 0xC0, 0x74,
  0x0E, 0xB8, 0x2D, 0x66, 0xCC, 0x03, 0x20, 0xAB, 0x07, 0x20, 0xBB, 0x08, 0x30, 0x3C, 0x02, 0x40,
  0xEB, 0x04, 0x30, 0x6B, 0x0D, 0x40, 0x7F, 0xB0, 0xB2, 0x01, 0xC0, 0x12, 0xC0, 0x14, 0x0B, 0xB0,
  0x63, 0x03, 0xB0, 0xD5, 0x0E, 0xB0, 0x34, 0x0C, 0xF9, 0x0E, 0x01, 0x20, 0x7B, 0x09, 0x20, 0x3B,
  0x0D, 0x50, 0x7B, 0x0A, 0x30, 0x7B, 0x09, 0x50, 0xAB, 0x07, 0x40, 0x10, 0xCE, 0x0D, 0x03, 0x30,
  0xDB, 0x03, 0x20, 0x6B, 0x0A, 0x50, 0x3B, 0x0D, 0x30, 0xAB, 0x06, 0x50, 0x7B, 0x0A, 0x68, 0x56,
  0xCE, 0xEC, 0x71, 0x30, 0x5B, 0x0C, 0x30, 0x8B, 0x08, 0x50, 0x1C, 0x30, 0xCB, 0x04, 0x50, 0x5B,
  0x0C, 0x77, 0x20, 0xBB, 0x06, 0x30, 0xAB, 0x07, 0x6C, 0x02, 0x20, 0xEB, 0x03, 0x50, 0x4B, 0x0E,
  0x77, 0x10, 0x2B, 0x0E, 0x40, 0xBB, 0x06, 0x60, 0xEB, 0x03, 0x2C, 0x02, 0x50, 0x2C, 0x77, 0x10,
  0x8B, 0x09, 0x40, 0xBB, 0x05, 0x60, 0xEB, 0x04, 0x2C, 0x01, 0x50, 0x2C, 0x77, 0x10, 0xEB, 0x02,
  0x40, 0xCB, 0x05, 0x60, 0xDB, 0x04, 0x2C, 0x01, 0x50, 0x2C, 0x01, 0x76, 0x05, 0xB0, 0xB5, 0x0B,
  0xB0, 0x56, 0x0D, 0xB0, 0x42, 0xC0, 0x15, 0x02, 0xC7, 0x70, 0xCB, 0x05, 0x50, 0xBB, 0x05, 0x60,
  0xEB, 0x03, 0x2C, 0x02, 0x50, 0x2C, 0x76, 0x03, 0xB0, 0xE6, 0x0A, 0xB0, 0x66, 0xC0, 0x32, 0x0E,
  0xB0, 0x25, 0x03, 0xB0, 0xE7, 0x60, 0x9B, 0x08, 0x60, 0x9B, 0x07, 0x6C, 0x01, 0x20, 0xCB, 0x03,
  0x50, 0x4B, 0x0D, 0x76, 0x0E, 0xB0, 0x26, 0x07, 0xB0, 0x95, 0x02, 0xB0, 0xE3, 0x0A, 0xB0, 0x55,
  0x06, 0xB0, 0xB7, 0x50, 0x6B, 0x0B, 0x70, 0x4B, 0x0B, 0x50, 0x5B, 0x0C, 0x30, 0x8B, 0x07, 0x50,
  0x9B, 0x08, 0x75, 0x0C, 0xB0, 0x47, 0x01, 0xB0, 0xE5, 0x09, 0xB0, 0x93, 0x04, 0xB0, 0xB5, 0x0C,
  0xB0, 0x57, 0x40, 0x3B, 0x0D, 0x72, 0x0C, 0xB0, 0x44, 0x0E, 0xB0, 0x43, 0x01, 0xC0, 0x13, 0x02,
  0xC0, 0x17, 0x40, 0xAB, 0x07, 0x72, 0x06, 0xB0, 0xC3, 0x07, 0xB0, 0xE5, 0x0A, 0xB0, 0x93, 0x0B,
  0xB0, 0xB7, 0x40, 0x1C, 0x01, 0x72, 0x01, 0x0E, 0xB8, 0x1D, 0x8B, 0xC0, 0x85, 0x04, 0xC8, 0x1B,
  0x8C, 0xC0, 0x47, 0x40, 0x7B, 0x0A, 0x74, 0x06, 0xFA, 0x0D, 0x01, 0x60, 0xAF, 0xA0, 0xA7, 0x50,
  0xDB, 0x03, 0x75, 0x0A, 0xF0, 0xE0, 0x37, 0x01, 0x0D, 0xF0, 0xD0, 0x17, 0x40, 0x4B, 0x0D, 0x77,
  0x08, 0xD0, 0xC0, 0x37, 0x20, 0x10, 0xAD, 0x0A, 0x01, 0x77, 0x77, 0x48, 0x31, 0x57, 0x63, 0x76,
  0x83, 0x25, 0x75, 0x26,
  // "‹" (U+2039)
  0x71, 0x81, 0x2C, 0x57, 0x30, 0xDA, 0x0C, 0x04, 0x70, 0xAC, 0x05, 0x60, 0x6C, 0x09, 0x60, 0x3C,
  0x0D, 0x01, 0x50, 0x10, 0xDC, 0x04, 0x60, 0xBC, 0x09, 0x60, 0x8C, 0x0D, 0x60, 0x5D, 0x04, 0x50,
  0x20, 0xEC, 0x09, 0x60, 0xCC, 0x0D, 0x60, 0x9D, 0x03, 0x60, 0xCC, 0x0E, 0x01, 0x60, 0x20, 0xEC,
  0x0B, 0x70, 0x5D, 0x06, 0x70, 0x9C, 0x0E, 0x02, 0x70, 0xCC, 0x0B, 0x70, 0x10, 0xEC, 0x06, 0x70,
  0x4D, 0x02, 0x70, 0x7C, 0x0C, 0x71, 0x0A, 0xC0, 0x77, 0x01, 0x0D, 0xC0, 0x37, 0x02, 0x0E, 0xA0,
  0xE0, 0x67, 0x18, 0x25, 0xFA, 0x17, 0x30, 0x23,
  // "›" (U+203A)
  0x28, 0x15, 0xC2, 0x71, 0x04, 0x0C, 0xA0, 0xC7, 0x10, 0x5C, 0x0A, 0x71, 0x0A, 0xC0, 0x67, 0x01,
  0x0E, 0xC0, 0x37, 0x05, 0xC0, 0xD0, 0x17, 0x0A, 0xC0, 0xB7, 0x01, 0x0E, 0xC0, 0x87, 0x05, 0xD0,
  0x47, 0x0A, 0xC0, 0xE0, 0x26, 0x01, 0x0E, 0xC0, 0xC7, 0x04, 0xD0, 0x96, 0x02, 0xD0, 0xB6, 0x0C,
  0xC0, 0xE0, 0x25, 0x07, 0xD0, 0x55, 0x02, 0xD0, 0x86, 0x0C, 0xC0, 0xB6, 0x07, 0xC0, 0xE0, 0x15,
  0x02, 0xD0, 0x36, 0x0C, 0xC0, 0x76, 0x08, 0xC0, 0xA6, 0x03, 0xC0, 0xD7, 0x06, 0xB0, 0xE0, 0x27,
  0x18, 0x21, 0xAF, 0x57, 0x40, 0x27, 0x20,
  // "⁄" (U+2044)
  0x77, 0x71, 0x03, 0xB0, 0xE0, 0x17, 0x77, 0x10, 0xBB, 0x08, 0x77, 0x71, 0x04, 0xB0, 0xE0, 0x17,
  0x77, 0x10, 0xCB, 0x07, 0x77, 0x71, 0x05, 0xB0, 0xD7, 0x77, 0x20, 0xDB, 0x05, 0x77, 0x71, 0x06,
  0xB0, 0xC7, 0x77, 0x20, 0xEB, 0x04, 0x77, 0x71, 0x07, 0xB0, 0xB7, 0x77, 0x10, 0x10, 0xEB, 0x03,
  0x77, 0x71, 0x09, 0xB0, 0xA7, 0x77, 0x10, 0x2C, 0x02, 0x77, 0x71, 0x0A, 0xB0, 0x97, 0x77, 0x10,
  0x3B, 0x0E, 0x01, 0x77, 0x71, 0x0B, 0xB0, 0x77, 0x77, 0x10, 0x4B, 0x0E, 0x77, 0x72, 0x0C, 0xB0,
  0x67, 0x77, 0x10, 0x5B, 0x0D, 0x77, 0x72, 0x0D, 0xB0, 0x57, 0x77, 0x10, 0x7B, 0x0C, 0x77, 0x71,
  0x01, 0x0E, 0xB0, 0x47, 0x77, 0x10, 0x8B, 0x0B, 0x77, 0x71, 0x01, 0x0E, 0xB0, 0x37, 0x77, 0x10,
  0x9B, 0x0A, 0x77, 0x71, 0x02, 0xC0, 0x27, 0x77, 0x10, 0xAB, 0x08, 0x77, 0x71, 0x03, 0xB0, 0xE0,
  0x17, 0x77, 0x10, 0xBB, 0x07, 0x77, 0x71, 0x04, 0xB0, 0xE7, 0x77, 0x20, 0xDB, 0x06, 0x77, 0x71,
  0x06, 0xB0, 0xD7, 0x77, 0x20, 0xDB, 0x05, 0x77, 0x71, 0x07, 0xB0, 0xC7, 0x77, 0x10, 0x10, 0xEB,
  0x03, 0x77, 0x71, 0x08, 0xB0, 0xB7, 0x77, 0x10, 0x1C, 0x02, 0x77, 0x71, 0x09, 0xB0, 0x97, 0x77,
  0x10, 0x2C, 0x01, 0x77, 0x71, 0x0B, 0xB0, 0x87, 0x77, 0x10, 0x3B, 0x0E, 0x01, 0x77, 0x71, 0x0C,
  0xB0, 0x77, 0x77, 0x10, 0x5B, 0x0D, 0x77, 0x72, 0x0D, 0xB0, 0x67, 0x77, 0x20,
  // "™" (U+2122)
  0x18, 0x09, 0x21, 0x28, 0x00, 0x17, 0x50, 0xF1, 0x10, 0x2F, 0xF1, 0x01, 0xC0, 0xD7, 0x3C, 0x0C,
  0x02, 0xFF, 0x10, 0x1D, 0x03, 0x71, 0x05, 0xC0, 0xC0, 0x2F, 0xF1, 0x01, 0xD0, 0x87, 0x10, 0xAC,
  0x0C, 0x60, 0xAA, 0x07, 0x60, 0x1D, 0x0C, 0x71, 0x0E, 0xC0, 0xC6, 0x0A, 0xA0, 0x76, 0x01, 0xA0,
  0xEB, 0x02, 0x60, 0x4A, 0x0E, 0xA0, 0xC6, 0x0A, 0xA0, 0x76, 0x01, 0xA0, 0xD0, 0xBA, 0x07, 0x60,
  0x9A, 0x08, 0xA0, 0xC6, 0x0A, 0xA0, 0x76, 0x01, 0xA0, 0xD0, 0x5A, 0x0B, 0x68, 0x2E, 0xFD, 0x6A,
  0x0C, 0x60, 0xAA, 0x07, 0x60, 0x1A, 0x0E, 0x01, 0xB0, 0x14, 0x04, 0xA0, 0x80, 0x6A, 0x0C, 0x60,
  0xAA, 0x07, 0x60, 0x1B, 0x10, 0xBA, 0x06, 0x40, 0x9A, 0x03, 0x06, 0xA0, 0xC6, 0x0A, 0xA0, 0x76,
  0x01, 0xB1, 0x06, 0xA0, 0xA4, 0x83, 0xDF, 0xD0, 0x7A, 0x0C, 0x60, 0xAA, 0x07, 0x60, 0x1B, 0x10,
  0x1B, 0x30, 0x3A, 0x81, 0x80, 0x7A, 0x0C, 0x60, 0xAA, 0x07, 0x60, 0x1B, 0x20, 0xBA, 0x05, 0x20,
  0x8A, 0x81, 0x30, 0x7A, 0x0C, 0x60, 0xAA, 0x07, 0x60, 0x1B, 0x20, 0x6A, 0x09, 0x28, 0x1D, 0xFD,
  0x20, 0x7A, 0x0C, 0x60, 0xAA, 0x07, 0x60, 0x1B, 0x20, 0x1A, 0x81, 0xE0, 0x2A, 0x07, 0x20, 0x7A,
  0x0C, 0x60, 0xAA, 0x07, 0x60, 0x1B, 0x30, 0xCA, 0x04, 0x07, 0xA0, 0x22, 0x07, 0xA0, 0xC6, 0x0A,
  0xA0, 0x76, 0x01, 0xB3, 0x07, 0xA8, 0x29, 0xCF, 0xC3, 0x07, 0xA0, 0xC6, 0x0A, 0xA0, 0x76, 0x01,
  0xB3, 0x02, 0xA0, 0xEA, 0x07, 0x30, 0x7A, 0x0C, 0x60, 0xAA, 0x07, 0x60, 0x1B, 0x40, 0xCC, 0x02,
  0x30, 0x7A, 0x0C, 0x60, 0xAA, 0x07, 0x60, 0x1B, 0x40, 0x7B, 0x0C, 0x40, 0x7A, 0x0C, 0x60, 0xAA,
  0x07, 0x60, 0x1B, 0x40, 0x2B, 0x07, 0x40, 0x7A, 0x0C, 0x60, 0xAA, 0x07, 0x60, 0x1B, 0x50, 0xCA,
  0x01, 0x40, 0x6A, 0x0B,
  // "⅒" (U+2152)
  0x60, 0x10, 0xBB, 0x06, 0x77, 0x20, 0x3B, 0x0E, 0x01, 0x77, 0x76, 0x02, 0x0D, 0xC0, 0x67, 0x72,
  0x0B, 0xB0, 0x87, 0x77, 0x60, 0x50, 0xED, 0x06, 0x77, 0x10, 0x4B, 0x0E, 0x01, 0x77, 0x75, 0x08,
  0xF0, 0x67, 0x71, 0x0C, 0xB0, 0x77, 0x77, 0x40, 0x10, 0xBC, 0x0E, 0xB0, 0x67, 0x70, 0x5B, 0x0D,
  0x77, 0x74, 0x02, 0x0D, 0xC0, 0xA0, 0x6B, 0x06, 0x77, 0x0D, 0xB0, 0x57, 0x77, 0x40, 0x5C, 0x81,
  0x60, 0x7B, 0x06, 0x76, 0x06, 0xB0, 0xC7, 0x77, 0x68, 0x29, 0xFD, 0x32, 0x08, 0xB0, 0x67, 0x60,
  0xEB, 0x04, 0x77, 0x77, 0x08, 0x40, 0x8B, 0x06, 0x75, 0x07, 0xB0, 0xB7, 0x77, 0x76, 0x08, 0xB0,
  0x67, 0x40, 0x10, 0xEB, 0x03, 0x77, 0x77, 0x60, 0x9B, 0x06, 0x74, 0x09, 0xB0, 0xA7, 0x77, 0x77,
  0x09, 0xB0, 0x67, 0x30, 0x2C, 0x02, 0x77, 0x77, 0x70, 0x9B, 0x06, 0x73, 0x0A, 0xB0, 0x98, 0x0C,
  0x00, 0x09, 0xB0, 0x67, 0x20, 0x3B, 0x0E, 0x01, 0x80, 0xC0, 0x00, 0x9B, 0x06, 0x72, 0x0B, 0xB0,
  0x78, 0x0C, 0x10, 0x09, 0xB0, 0x67, 0x10, 0x4B, 0x0E, 0x80, 0xC2, 0x00, 0x9B, 0x06, 0x71, 0x0C,
  0xB0, 0x68, 0x0C, 0x20, 0x09, 0xB0, 0x67, 0x05, 0xB0, 0xD5, 0x01, 0x0B, 0xB0, 0x67, 0x38, 0x33,
  0x68, 0x74, 0x76, 0x09, 0xB0, 0x67, 0x0D, 0xB0, 0x54, 0x02, 0x0D, 0xC0, 0x67, 0x10, 0x40, 0xDD,
  0x0E, 0x07, 0x74, 0x09, 0xB0, 0x66, 0x07, 0xB0, 0xC4, 0x05, 0x0E, 0xD0, 0x67, 0x07, 0xFA, 0x0B,
  0x73, 0x09, 0xB0, 0x65, 0x01, 0x0E, 0xB0, 0x43, 0x08, 0xF0, 0x66, 0x04, 0xFC, 0x09, 0x72, 0x09,
  0xB0, 0x65, 0x08, 0xB0, 0xB2, 0x01, 0x0B, 0xC0, 0xEB, 0x06, 0x60, 0xDB, 0x83, 0xD4, 0x02, 0xAC,
  0x03, 0x71, 0x09, 0xB0, 0x64, 0x01, 0x0E, 0xB8, 0x23, 0x02, 0xDC, 0x0A, 0x06, 0xB0, 0x65, 0x05,
  0xB0, 0xE0, 0x14, 0x0A, 0xB0, 0xA7, 0x10, 0x9B, 0x06, 0x40, 0x9B, 0x0A, 0x20, 0x5C, 0x81, 0x60,
  0x7B, 0x06, 0x50, 0xAB, 0x08, 0x50, 0x2C, 0x01, 0x70, 0x9B, 0x06, 0x30, 0x2C, 0x02, 0x38, 0x29,
  0xFD, 0x32, 0x08, 0xB0, 0x65, 0x0E, 0xB0, 0x36, 0x0C, 0xB0, 0x57, 0x09, 0xB0, 0x63, 0x0A, 0xB0,
  0x85, 0x08, 0x40, 0x8B, 0x06, 0x40, 0x2C, 0x70, 0x8B, 0x09, 0x77, 0x03, 0xB0, 0xE0, 0x17, 0x30,
  0x8B, 0x06, 0x40, 0x4B, 0x0C, 0x70, 0x5B, 0x0B, 0x77, 0x0B, 0xB0, 0x77, 0x40, 0x9B, 0x06, 0x40,
  0x6B, 0x0B, 0x70, 0x3B, 0x0D, 0x76, 0x04, 0xB0, 0xE7, 0x50, 0x9B, 0x06, 0x40, 0x7B, 0x09, 0x70,
  0x2B, 0x0E, 0x76, 0x0D, 0xB0, 0x67, 0x50, 0x9B, 0x06, 0x40, 0x8B, 0x09, 0x70, 0x1C, 0x75, 0x06,
  0xB0, 0xD7, 0x60, 0x9B, 0x06, 0x40, 0x8B, 0x09, 0x70, 0x1C, 0x75, 0x0D, 0xB0, 0x57, 0x60, 0x9B,
  0x06, 0x40, 0x8B, 0x09, 0x70, 0x1C, 0x74, 0x07, 0xB0, 0xC7, 0x70, 0x9B, 0x06, 0x40, 0x7B, 0x09,
  0x70, 0x2C, 0x73, 0x01, 0x0E, 0xB0, 0x37, 0x70, 0x9B, 0x06, 0x40, 0x6B, 0x0A, 0x70, 0x3B, 0x0E,
  0x73, 0x08, 0xB0, 0xB7, 0x71, 0x09, 0xB0, 0x64, 0x04, 0xB0, 0xC7, 0x04, 0xB0, 0xC7, 0x20, 0x1C,
  0x02, 0x77, 0x10, 0x9B, 0x06, 0x40, 0x2B, 0x0E, 0x70, 0x7B, 0x0A, 0x72, 0x09, 0xB0, 0x97, 0x72,
  0x09, 0xB0, 0x65, 0x0E, 0xB0, 0x16, 0x0A, 0xB0, 0x77, 0x10, 0x2C, 0x01, 0x77, 0x20, 0x9B, 0x06,
  0x50, 0xAB, 0x06, 0x60, 0xEB, 0x03, 0x71, 0x0B, 0xB0, 0x87, 0x73, 0x09, 0xB0, 0x65, 0x06, 0xB0,
  0xD5, 0x06, 0xB0, 0xE7, 0x10, 0x3B, 0x0E, 0x01, 0x77, 0x30, 0x9B, 0x06, 0x60, 0xEB, 0x08, 0x30,
  0x30, 0xEB, 0x07, 0x71, 0x0C, 0xB0, 0x77, 0x74, 0x09, 0xB0, 0x66, 0x06, 0xC8, 0x1C, 0x9A, 0xC0,
  0xE0, 0x17, 0x05, 0xB0, 0xD7, 0x75, 0x09, 0xB0, 0x67, 0x0B, 0xFB, 0x04, 0x71, 0x0D, 0xB0, 0x67,
  0x75, 0x09, 0xB0, 0x67, 0x10, 0xAF, 0x0E, 0x04, 0x80, 0xD3, 0x08, 0x64, 0xAD, 0xFE, 0xC7, 0x14,
  // "ﬁ" (U+FB01)
  0x74, 0x83, 0x23, 0x44, 0x17, 0x76, 0x07, 0x0D, 0xD8, 0x1D, 0x92, 0x77, 0x10, 0x10, 0xDF, 0xA0,
  0x42, 0x83, 0x1A, 0xED, 0x77, 0x10, 0xCF, 0xA0, 0xE3, 0x0A, 0xC0, 0x36, 0x06, 0xFB, 0x0A, 0x30,
  0xEC, 0x08, 0x60, 0xDC, 0x85, 0xC3, 0x01, 0x49, 0x52, 0x01, 0xD0, 0x95, 0x02, 0xC0, 0xE0, 0x17,
  0x20, 0xEC, 0x08, 0x50, 0x6C, 0x09, 0x73, 0x09, 0xC0, 0x35, 0x09, 0xC0, 0x67, 0x38, 0x31, 0x9E,
  0xD6, 0x60, 0xBC, 0x03, 0x77, 0x70, 0xDC, 0x02, 0x77, 0x70, 0xDC, 0x01, 0x77, 0x70, 0xEC, 0x01,
  0x77, 0x70, 0xEC, 0x01, 0x77, 0x70, 0xEC, 0x01, 0x77, 0x48, 0x11, 0x8E, 0xFC, 0x01, 0x40, 0xBC,
  0x81, 0x32, 0xAF, 0xF0, 0x14, 0x0B, 0xC0, 0x30, 0x5F, 0xF9, 0x01, 0x40, 0xBC, 0x03, 0x05, 0xFF,
  0x90, 0x14, 0x0B, 0xC0, 0x30, 0x18, 0x00, 0x5D, 0x80, 0x25, 0x50, 0xBC, 0x03, 0x50, 0xEC, 0x01,
  0x73, 0x0B, 0xC0, 0x35, 0x0E, 0xC0, 0x17, 0x30, 0xBC, 0x03, 0x50, 0xEC, 0x01, 0x73, 0x0B, 0xC0,
  0x35, 0x0E, 0xC0, 0x17, 0x30, 0xBC, 0x03, 0x50, 0xEC, 0x01, 0x73, 0x0B, 0xC0, 0x35, 0x0E, 0xC0,
  0x17, 0x30, 0xBC, 0x03, 0x50, 0xEC, 0x01, 0x73, 0x0B, 0xC0, 0x35, 0x0E, 0xC0, 0x17, 0x30, 0xBC,
  0x03, 0x50, 0xEC, 0x01, 0x73, 0x0B, 0xC0, 0x35, 0x0E, 0xC0, 0x17, 0x30, 0xBC, 0x03, 0x50, 0xEC,
  0x01, 0x73, 0x0B, 0xC0, 0x35, 0x0E, 0xC0, 0x17, 0x30, 0xBC, 0x03, 0x50, 0xEC, 0x01, 0x73, 0x0B,
  0xC0, 0x35, 0x0E, 0xC0, 0x17, 0x30, 0xBC, 0x03, 0x50, 0xEC, 0x01, 0x73, 0x0B, 0xC0, 0x35, 0x0E,
  0xC0, 0x17, 0x30, 0xBC, 0x03, 0x50, 0xEC, 0x01, 0x73, 0x0B, 0xC0, 0x35, 0x0E, 0xC0, 0x17, 0x30,
  0xBC, 0x03, 0x50, 0xEC, 0x01, 0x73, 0x0B, 0xC0, 0x35, 0x0E, 0xC0, 0x17, 0x30, 0xBC, 0x03, 0x50,
  0xEC, 0x01, 0x73, 0x0B, 0xC0, 0x35, 0x0E, 0xC0, 0x17, 0x30, 0xBC, 0x03, 0x50, 0xEC, 0x01, 0x73,
  0x0B, 0xC0, 0x35, 0x0E, 0xC0, 0x17, 0x30, 0xBC, 0x03, 0x50, 0xEC, 0x01, 0x73, 0x0B, 0xC0, 0x35,
  0x0E, 0xC0, 0x17, 0x30, 0xBC, 0x03, 0x50, 0xEC, 0x01, 0x73, 0x0B, 0xC0, 0x30,
  // "ﬂ" (U+FB02)
  0x74, 0x83, 0x23, 0x44, 0x17, 0x76, 0x07, 0x0D, 0xD8, 0x1D, 0x92, 0x20, 0xBC, 0x03, 0x70, 0x10,
  0xDF, 0xA0, 0x42, 0x0B, 0xC0, 0x37, 0x0C, 0xFA, 0x0E, 0x30, 0xBC, 0x03, 0x60, 0x6F, 0xB0, 0xA3,
  0x0B, 0xC0, 0x36, 0x0D, 0xC8, 0x5C, 0x30, 0x14, 0x95, 0x30, 0xBC, 0x03, 0x50, 0x2C, 0x0E, 0x01,
  0x72, 0x0B, 0xC0, 0x35, 0x06, 0xC0, 0x97, 0x30, 0xBC, 0x03, 0x50, 0x9C, 0x06, 0x73, 0x0B, 0xC0,
  0x35, 0x0B, 0xC0, 0x37, 0x30, 0xBC, 0x03, 0x50, 0xDC, 0x02, 0x73, 0x0B, 0xC0, 0x35, 0x0D, 0xC0,
  0x17, 0x30, 0xBC, 0x03, 0x50, 0xEC, 0x01, 0x73, 0x0B, 0xC0, 0x35, 0x0E, 0xC0, 0x17, 0x30, 0xBC,
  0x03, 0x50, 0xEC, 0x01, 0x73, 0x0B, 0xC0, 0x32, 0x81, 0x18, 0xEF, 0xC0, 0x14, 0x0B, 0xC8, 0x13,
  0x2A, 0xFF, 0x01, 0x40, 0xBC, 0x03, 0x05, 0xFF, 0x90, 0x14, 0x0B, 0xC0, 0x30, 0x5F, 0xF9, 0x01,
  0x40, 0xBC, 0x03, 0x01, 0x80, 0x05, 0xD8, 0x02, 0x55, 0x0B, 0xC0, 0x35, 0x0E, 0xC0, 0x17, 0x30,
  0xBC, 0x03, 0x50, 0xEC, 0x01, 0x73, 0x0B, 0xC0, 0x35, 0x0E, 0xC0, 0x17, 0x30, 0xBC, 0x03, 0x50,
  0xEC, 0x01, 0x73, 0x0B, 0xC0, 0x35, 0x0E, 0xC0, 0x17, 0x30, 0xBC, 0x03, 0x50, 0xEC, 0x01, 0x73,
  0x0B, 0xC0, 0x35, 0x0E, 0xC0, 0x17, 0x30, 0xBC, 0x03, 0x50, 0xEC, 0x01, 0x73, 0x0B, 0xC0, 0x35,
  0x0E, 0xC0, 0x17, 0x30, 0xBC, 0x03, 0x50, 0xEC, 0x01, 0x73, 0x0B, 0xC0, 0x35, 0x0E, 0xC0, 0x17,
  0x30, 0xBC, 0x03, 0x50, 0xEC, 0x01, 0x73, 0x0B, 0xC0, 0x35, 0x0E, 0xC0, 0x17, 0x30, 0xBC, 0x03,
  0x50, 0xEC, 0x01, 0x73, 0x0B, 0xC0, 0x35, 0x0E, 0xC0, 0x17, 0x30, 0xBC, 0x03, 0x50, 0xEC, 0x01,
  0x73, 0x0B, 0xC0, 0x35, 0x0E, 0xC0, 0x17, 0x30, 0xBC, 0x03, 0x50, 0xEC, 0x01, 0x73, 0x0B, 0xC0,
  0x35, 0x0E, 0xC0, 0x17, 0x30, 0xBC, 0x03, 0x50, 0xEC, 0x01, 0x73, 0x0B, 0xC0, 0x35, 0x0E, 0xC0,
  0x17, 0x30, 0xBC, 0x03, 0x50, 0xEC, 0x01, 0x73, 0x0B, 0xC0, 0x35, 0x0E, 0xC0, 0x17, 0x30, 0xBC,
  0x03, 0x50, 0xEC, 0x01, 0x73, 0x0B, 0xC0, 0x35, 0x0E, 0xC0, 0x17, 0x30, 0xBC, 0x03, 0x50, 0xEC,
  0x01, 0x73, 0x0B, 0xC0, 0x35, 0x0E, 0xC0, 0x17, 0x30, 0xBC, 0x03,
};

const Font& font_NotoSans_Condensed_60() {
  static SmoothFont font(font_NotoSans_Condensed_60_data);
  return font;
}

}  // namespace roo_display
