#include "8.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSansMono-Bold (Noto Sans Mono Bold)
// Generated on Sun Mar 06 15:50:05 CET 2022
static const uint8_t font_NotoSansMono_Bold_8_data[] PROGMEM = {
  
  // Header
  0x01, 0x01, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x5D, 0x00, 0x00,
  0xFE, 0xFE, 0x0C, 0x09, 0x07, 0xFE, 0x03, 0x00, 0x0E, 0x04, 0x05, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x01, 0x01, 0x02, 0x06, 0x05, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x01, 0x04, 0x03, 0x06, 0x05, 0x00, 0x08, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x04, 0x06, 0x05, 0x00, 0x0E, // "#" (U+0023)
  0x00, 0x24, 0x00, 0x01, 0x04, 0x07, 0x05, 0x00, 0x1F, // "$" (U+0024)
  0x00, 0x25, 0x00, 0x01, 0x04, 0x06, 0x05, 0x00, 0x32, // "%" (U+0025)
  0x00, 0x26, 0x00, 0x01, 0x04, 0x06, 0x05, 0x00, 0x44, // "&" (U+0026)
  0x00, 0x27, 0x01, 0x04, 0x02, 0x06, 0x05, 0x00, 0x56, // "'" (U+0027)
  0x00, 0x28, 0x01, 0x00, 0x03, 0x06, 0x05, 0x00, 0x5A, // "(" (U+0028)
  0x00, 0x29, 0x01, 0xFF, 0x03, 0x05, 0x05, 0x00, 0x67, // ")" (U+0029)
  0x00, 0x2A, 0x00, 0x04, 0x04, 0x07, 0x05, 0x00, 0x74, // "*" (U+002A)
  0x00, 0x2B, 0x00, 0x02, 0x04, 0x05, 0x05, 0x00, 0x7F, // "+" (U+002B)
  0x00, 0x2C, 0x01, 0x00, 0x02, 0x02, 0x05, 0x00, 0x89, // "," (U+002C)
  0x00, 0x2D, 0x01, 0x02, 0x03, 0x03, 0x05, 0x00, 0x8D, // "-" (U+002D)
  0x00, 0x2E, 0x01, 0x01, 0x02, 0x01, 0x05, 0x00, 0x91, // "." (U+002E)
  0x00, 0x2F, 0x01, 0x01, 0x03, 0x06, 0x05, 0x00, 0x93, // "/" (U+002F)
  0x00, 0x30, 0x00, 0x01, 0x04, 0x06, 0x05, 0x00, 0x9D, // "0" (U+0030)
  0x00, 0x31, 0x00, 0x01, 0x04, 0x06, 0x05, 0x00, 0xAE, // "1" (U+0031)
  0x00, 0x32, 0x00, 0x01, 0x04, 0x06, 0x05, 0x00, 0xBD, // "2" (U+0032)
  0x00, 0x33, 0x00, 0x01, 0x04, 0x06, 0x05, 0x00, 0xCE, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x01, 0x04, 0x06, 0x05, 0x00, 0xE0, // "4" (U+0034)
  0x00, 0x35, 0x00, 0x01, 0x04, 0x06, 0x05, 0x00, 0xF1, // "5" (U+0035)
  0x00, 0x36, 0x00, 0x01, 0x04, 0x06, 0x05, 0x01, 0x03, // "6" (U+0036)
  0x00, 0x37, 0x00, 0x01, 0x04, 0x06, 0x05, 0x01, 0x14, // "7" (U+0037)
  0x00, 0x38, 0x00, 0x01, 0x04, 0x06, 0x05, 0x01, 0x24, // "8" (U+0038)
  0x00, 0x39, 0x00, 0x01, 0x04, 0x06, 0x05, 0x01, 0x35, // "9" (U+0039)
  0x00, 0x3A, 0x01, 0x01, 0x02, 0x05, 0x05, 0x01, 0x46, // ":" (U+003A)
  0x00, 0x3B, 0x01, 0x00, 0x03, 0x05, 0x05, 0x01, 0x4B, // ";" (U+003B)
  0x00, 0x3C, 0x01, 0x02, 0x04, 0x05, 0x05, 0x01, 0x54, // "<" (U+003C)
  0x00, 0x3D, 0x00, 0x02, 0x04, 0x05, 0x05, 0x01, 0x5D, // "=" (U+003D)
  0x00, 0x3E, 0x00, 0x02, 0x03, 0x05, 0x05, 0x01, 0x69, // ">" (U+003E)
  0x00, 0x3F, 0x00, 0x01, 0x04, 0x06, 0x05, 0x01, 0x73, // "?" (U+003F)
  0x00, 0x40, 0x00, 0xFE, 0x04, 0x06, 0x05, 0x01, 0x85, // "@" (U+0040)
  0x00, 0x41, 0x00, 0x01, 0x04, 0x06, 0x05, 0x01, 0x9C, // "A" (U+0041)
  0x00, 0x42, 0x00, 0x01, 0x04, 0x06, 0x05, 0x01, 0xAE, // "B" (U+0042)
  0x00, 0x43, 0x00, 0x01, 0x04, 0x06, 0x05, 0x01, 0xBF, // "C" (U+0043)
  0x00, 0x44, 0x00, 0x01, 0x04, 0x06, 0x05, 0x01, 0xD0, // "D" (U+0044)
  0x00, 0x45, 0x00, 0x01, 0x04, 0x06, 0x05, 0x01, 0xE1, // "E" (U+0045)
  0x00, 0x46, 0x00, 0x01, 0x04, 0x06, 0x05, 0x01, 0xF0, // "F" (U+0046)
  0x00, 0x47, 0x00, 0x01, 0x04, 0x06, 0x05, 0x01, 0xFF, // "G" (U+0047)
  0x00, 0x48, 0x00, 0x01, 0x04, 0x06, 0x05, 0x02, 0x10, // "H" (U+0048)
  0x00, 0x49, 0x00, 0x01, 0x04, 0x06, 0x05, 0x02, 0x21, // "I" (U+0049)
  0x00, 0x4A, 0x00, 0x01, 0x03, 0x06, 0x05, 0x02, 0x31, // "J" (U+004A)
  0x00, 0x4B, 0x00, 0x01, 0x04, 0x06, 0x05, 0x02, 0x40, // "K" (U+004B)
  0x00, 0x4C, 0x00, 0x01, 0x04, 0x06, 0x05, 0x02, 0x52, // "L" (U+004C)
  0x00, 0x4D, 0x00, 0x01, 0x04, 0x06, 0x05, 0x02, 0x62, // "M" (U+004D)
  0x00, 0x4E, 0x00, 0x01, 0x04, 0x06, 0x05, 0x02, 0x73, // "N" (U+004E)
  0x00, 0x4F, 0x00, 0x01, 0x04, 0x06, 0x05, 0x02, 0x84, // "O" (U+004F)
  0x00, 0x50, 0x00, 0x01, 0x04, 0x06, 0x05, 0x02, 0x95, // "P" (U+0050)
  0x00, 0x51, 0x00, 0xFF, 0x04, 0x06, 0x05, 0x02, 0xA6, // "Q" (U+0051)
  0x00, 0x52, 0x00, 0x01, 0x04, 0x06, 0x05, 0x02, 0xBB, // "R" (U+0052)
  0x00, 0x53, 0x00, 0x01, 0x04, 0x06, 0x05, 0x02, 0xCD, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x04, 0x06, 0x05, 0x02, 0xDF, // "T" (U+0054)
  0x00, 0x55, 0x00, 0x01, 0x04, 0x06, 0x05, 0x02, 0xEC, // "U" (U+0055)
  0x00, 0x56, 0x00, 0x01, 0x04, 0x06, 0x05, 0x02, 0xFD, // "V" (U+0056)
  0x00, 0x57, 0x00, 0x01, 0x04, 0x06, 0x05, 0x03, 0x0F, // "W" (U+0057)
  0x00, 0x58, 0x00, 0x01, 0x04, 0x06, 0x05, 0x03, 0x20, // "X" (U+0058)
  0x00, 0x59, 0x00, 0x01, 0x04, 0x06, 0x05, 0x03, 0x32, // "Y" (U+0059)
  0x00, 0x5A, 0x00, 0x01, 0x04, 0x06, 0x05, 0x03, 0x42, // "Z" (U+005A)
  0x00, 0x5B, 0x01, 0xFE, 0x03, 0x06, 0x05, 0x03, 0x52, // "[" (U+005B)
  0x00, 0x5C, 0x01, 0x01, 0x03, 0x06, 0x05, 0x03, 0x61, // "\" (U+005C)
  0x00, 0x5D, 0x01, 0x00, 0x03, 0x08, 0x05, 0x03, 0x6C, // "]" (U+005D)
  0x00, 0x5E, 0x00, 0x03, 0x04, 0x06, 0x05, 0x03, 0x7B, // "^" (U+005E)
  0x00, 0x5F, 0x00, 0xFE, 0x04, 0xFF, 0x05, 0x03, 0x87, // "_" (U+005F)
  0x00, 0x60, 0x01, 0x06, 0x02, 0x07, 0x05, 0x03, 0x8C, // "`" (U+0060)
  0x00, 0x61, 0x00, 0x01, 0x04, 0x05, 0x05, 0x03, 0x8F, // "a" (U+0061)
  0x00, 0x62, 0x00, 0x01, 0x04, 0x07, 0x05, 0x03, 0x9E, // "b" (U+0062)
  0x00, 0x63, 0x00, 0x01, 0x03, 0x05, 0x05, 0x03, 0xB1, // "c" (U+0063)
  0x00, 0x64, 0x00, 0x01, 0x04, 0x07, 0x05, 0x03, 0xBD, // "d" (U+0064)
  0x00, 0x65, 0x00, 0x01, 0x04, 0x05, 0x05, 0x03, 0xCF, // "e" (U+0065)
  0x00, 0x66, 0x00, 0x01, 0x04, 0x07, 0x05, 0x03, 0xDD, // "f" (U+0066)
  0x00, 0x67, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x03, 0xF0, // "g" (U+0067)
  0x00, 0x68, 0x00, 0x01, 0x04, 0x07, 0x05, 0x04, 0x03, // "h" (U+0068)
  0x00, 0x69, 0x00, 0x01, 0x04, 0x07, 0x05, 0x04, 0x16, // "i" (U+0069)
  0x00, 0x6A, 0x00, 0xFF, 0x03, 0x07, 0x05, 0x04, 0x28, // "j" (U+006A)
  0x00, 0x6B, 0x00, 0x01, 0x04, 0x07, 0x05, 0x04, 0x3C, // "k" (U+006B)
  0x00, 0x6C, 0x00, 0x01, 0x04, 0x07, 0x05, 0x04, 0x50, // "l" (U+006C)
  0x00, 0x6D, 0x00, 0x01, 0x04, 0x05, 0x05, 0x04, 0x64, // "m" (U+006D)
  0x00, 0x6E, 0x00, 0x01, 0x04, 0x05, 0x05, 0x04, 0x72, // "n" (U+006E)
  0x00, 0x6F, 0x00, 0x01, 0x04, 0x05, 0x05, 0x04, 0x80, // "o" (U+006F)
  0x00, 0x70, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x04, 0x8E, // "p" (U+0070)
  0x00, 0x71, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x04, 0xA0, // "q" (U+0071)
  0x00, 0x72, 0x00, 0x01, 0x04, 0x05, 0x05, 0x04, 0xB3, // "r" (U+0072)
  0x00, 0x73, 0x00, 0x01, 0x04, 0x05, 0x05, 0x04, 0xC1, // "s" (U+0073)
  0x00, 0x74, 0x00, 0x01, 0x04, 0x06, 0x05, 0x04, 0xD0, // "t" (U+0074)
  0x00, 0x75, 0x00, 0x01, 0x04, 0x05, 0x05, 0x04, 0xE2, // "u" (U+0075)
  0x00, 0x76, 0x00, 0x01, 0x04, 0x05, 0x05, 0x04, 0xF0, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x01, 0x04, 0x05, 0x05, 0x04, 0xFF, // "w" (U+0077)
  0x00, 0x78, 0x00, 0x01, 0x04, 0x05, 0x05, 0x05, 0x0D, // "x" (U+0078)
  0x00, 0x79, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x05, 0x1C, // "y" (U+0079)
  0x00, 0x7A, 0x00, 0x01, 0x04, 0x05, 0x05, 0x05, 0x30, // "z" (U+007A)
  0x00, 0x7B, 0x01, 0xFF, 0x03, 0x06, 0x05, 0x05, 0x3D, // "{" (U+007B)
  0x00, 0x7C, 0x02, 0xFF, 0x02, 0x07, 0x05, 0x05, 0x4B, // "|" (U+007C)
  0x00, 0x7D, 0x01, 0xFF, 0x03, 0x06, 0x05, 0x05, 0x4D, // "}" (U+007D)
  0x00, 0x7E, 0x00, 0x03, 0x04, 0x04, 0x05, 0x05, 0x5B, // "~" (U+007E)
  0x00, 0xA1, 0x02, 0xFF, 0x03, 0x04, 0x05, 0x05, 0x61, // "¡" (U+00A1)
  0x00, 0xA2, 0x00, 0x01, 0x04, 0x06, 0x05, 0x05, 0x69, // "¢" (U+00A2)
  0x00, 0xA3, 0x00, 0x01, 0x04, 0x06, 0x05, 0x05, 0x79, // "£" (U+00A3)
  0x00, 0xA4, 0x00, 0x01, 0x04, 0x06, 0x05, 0x05, 0x8A, // "¤" (U+00A4)
  0x00, 0xA5, 0x00, 0x01, 0x04, 0x06, 0x05, 0x05, 0x9A, // "¥" (U+00A5)
  0x00, 0xA6, 0x02, 0xFF, 0x02, 0x07, 0x05, 0x05, 0xAB, // "¦" (U+00A6)
  0x00, 0xA7, 0x00, 0x01, 0x03, 0x07, 0x05, 0x05, 0xB0, // "§" (U+00A7)
  0x00, 0xA8, 0x01, 0x07, 0x03, 0x07, 0x05, 0x05, 0xC0, // "¨" (U+00A8)
  0x00, 0xA9, 0x00, 0x01, 0x04, 0x05, 0x05, 0x05, 0xC3, // "©" (U+00A9)
  0x00, 0xAA, 0x01, 0x04, 0x03, 0x06, 0x05, 0x05, 0xD2, // "ª" (U+00AA)
  0x00, 0xAB, 0x00, 0x01, 0x04, 0x04, 0x05, 0x05, 0xD8, // "«" (U+00AB)
  0x00, 0xAC, 0x00, 0x02, 0x04, 0x04, 0x05, 0x05, 0xE4, // "¬" (U+00AC)
  0x00, 0xAE, 0x00, 0x01, 0x04, 0x05, 0x05, 0x05, 0xED, // "®" (U+00AE)
  0x00, 0xAF, 0x01, 0x06, 0x03, 0x07, 0x05, 0x05, 0xFB, // "¯" (U+00AF)
  0x00, 0xB0, 0x01, 0x05, 0x03, 0x07, 0x05, 0x05, 0xFF, // "°" (U+00B0)
  0x00, 0xB1, 0x00, 0x01, 0x04, 0x06, 0x05, 0x06, 0x05, // "±" (U+00B1)
  0x00, 0xB2, 0x01, 0x04, 0x03, 0x07, 0x05, 0x06, 0x11, // "²" (U+00B2)
  0x00, 0xB3, 0x01, 0x04, 0x03, 0x07, 0x05, 0x06, 0x19, // "³" (U+00B3)
  0x00, 0xB4, 0x01, 0x06, 0x03, 0x07, 0x05, 0x06, 0x21, // "´" (U+00B4)
  0x00, 0xB5, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x06, 0x25, // "µ" (U+00B5)
  0x00, 0xB6, 0x00, 0x00, 0x04, 0x07, 0x05, 0x06, 0x37, // "¶" (U+00B6)
  0x00, 0xB7, 0x01, 0x03, 0x02, 0x03, 0x05, 0x06, 0x4D, // "·" (U+00B7)
  0x00, 0xB8, 0x01, 0xFF, 0x03, 0x01, 0x05, 0x06, 0x4F, // "¸" (U+00B8)
  0x00, 0xB9, 0x01, 0x04, 0x03, 0x06, 0x05, 0x06, 0x55, // "¹" (U+00B9)
  0x00, 0xBA, 0x01, 0x04, 0x03, 0x06, 0x05, 0x06, 0x5B, // "º" (U+00BA)
  0x00, 0xBB, 0x00, 0x01, 0x04, 0x04, 0x05, 0x06, 0x61, // "»" (U+00BB)
  0x00, 0xBC, 0x00, 0x00, 0x04, 0x06, 0x05, 0x06, 0x6D, // "¼" (U+00BC)
  0x00, 0xBD, 0x00, 0x00, 0x04, 0x06, 0x05, 0x06, 0x81, // "½" (U+00BD)
  0x00, 0xBE, 0x00, 0x00, 0x04, 0x06, 0x05, 0x06, 0x95, // "¾" (U+00BE)
  0x00, 0xBF, 0x00, 0xFF, 0x04, 0x04, 0x05, 0x06, 0xA8, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x04, 0x08, 0x05, 0x06, 0xBA, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x04, 0x08, 0x05, 0x06, 0xD1, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x01, 0x04, 0x08, 0x05, 0x06, 0xE8, // "Â" (U+00C2)
  0x00, 0xC3, 0x00, 0x01, 0x04, 0x07, 0x05, 0x07, 0x00, // "Ã" (U+00C3)
  0x00, 0xC4, 0x00, 0x01, 0x04, 0x08, 0x05, 0x07, 0x15, // "Ä" (U+00C4)
  0x00, 0xC5, 0x00, 0x01, 0x04, 0x08, 0x05, 0x07, 0x2A, // "Å" (U+00C5)
  0x00, 0xC6, 0x00, 0x01, 0x04, 0x06, 0x05, 0x07, 0x42, // "Æ" (U+00C6)
  0x00, 0xC7, 0x00, 0xFF, 0x04, 0x06, 0x05, 0x07, 0x54, // "Ç" (U+00C7)
  0x00, 0xC8, 0x00, 0x01, 0x04, 0x08, 0x05, 0x07, 0x6B, // "È" (U+00C8)
  0x00, 0xC9, 0x00, 0x01, 0x04, 0x08, 0x05, 0x07, 0x80, // "É" (U+00C9)
  0x00, 0xCA, 0x00, 0x01, 0x04, 0x08, 0x05, 0x07, 0x95, // "Ê" (U+00CA)
  0x00, 0xCB, 0x00, 0x01, 0x04, 0x08, 0x05, 0x07, 0xAA, // "Ë" (U+00CB)
  0x00, 0xCC, 0x00, 0x01, 0x04, 0x08, 0x05, 0x07, 0xBD, // "Ì" (U+00CC)
  0x00, 0xCD, 0x00, 0x01, 0x04, 0x08, 0x05, 0x07, 0xD3, // "Í" (U+00CD)
  0x00, 0xCE, 0x00, 0x01, 0x04, 0x08, 0x05, 0x07, 0xE9, // "Î" (U+00CE)
  0x00, 0xCF, 0x00, 0x01, 0x04, 0x08, 0x05, 0x07, 0xFF, // "Ï" (U+00CF)
  0x00, 0xD0, 0x00, 0x01, 0x04, 0x06, 0x05, 0x08, 0x13, // "Ð" (U+00D0)
  0x00, 0xD1, 0x00, 0x01, 0x04, 0x07, 0x05, 0x08, 0x25, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x00, 0x01, 0x04, 0x08, 0x05, 0x08, 0x38, // "Ò" (U+00D2)
  0x00, 0xD3, 0x00, 0x01, 0x04, 0x08, 0x05, 0x08, 0x4E, // "Ó" (U+00D3)
  0x00, 0xD4, 0x00, 0x01, 0x04, 0x08, 0x05, 0x08, 0x64, // "Ô" (U+00D4)
  0x00, 0xD5, 0x00, 0x01, 0x04, 0x07, 0x05, 0x08, 0x7A, // "Õ" (U+00D5)
  0x00, 0xD6, 0x00, 0x01, 0x04, 0x08, 0x05, 0x08, 0x8D, // "Ö" (U+00D6)
  0x00, 0xD7, 0x00, 0x02, 0x03, 0x05, 0x05, 0x08, 0xA1, // "×" (U+00D7)
  0x00, 0xD8, 0x00, 0x00, 0x04, 0x06, 0x05, 0x08, 0xAB, // "Ø" (U+00D8)
  0x00, 0xD9, 0x00, 0x01, 0x04, 0x08, 0x05, 0x08, 0xBD, // "Ù" (U+00D9)
  0x00, 0xDA, 0x00, 0x01, 0x04, 0x08, 0x05, 0x08, 0xD3, // "Ú" (U+00DA)
  0x00, 0xDB, 0x00, 0x01, 0x04, 0x08, 0x05, 0x08, 0xE9, // "Û" (U+00DB)
  0x00, 0xDC, 0x00, 0x01, 0x04, 0x08, 0x05, 0x08, 0xFF, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x01, 0x04, 0x08, 0x05, 0x09, 0x13, // "Ý" (U+00DD)
  0x00, 0xDE, 0x00, 0x01, 0x04, 0x06, 0x05, 0x09, 0x29, // "Þ" (U+00DE)
  0x00, 0xDF, 0x00, 0x01, 0x04, 0x07, 0x05, 0x09, 0x3A, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x01, 0x04, 0x07, 0x05, 0x09, 0x4D, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x04, 0x07, 0x05, 0x09, 0x61, // "á" (U+00E1)
  0x00, 0xE2, 0x00, 0x01, 0x04, 0x07, 0x05, 0x09, 0x75, // "â" (U+00E2)
  0x00, 0xE3, 0x00, 0x01, 0x04, 0x06, 0x05, 0x09, 0x89, // "ã" (U+00E3)
  0x00, 0xE4, 0x00, 0x01, 0x04, 0x07, 0x05, 0x09, 0x9A, // "ä" (U+00E4)
  0x00, 0xE5, 0x00, 0x01, 0x04, 0x07, 0x05, 0x09, 0xAC, // "å" (U+00E5)
  0x00, 0xE6, 0x00, 0x01, 0x04, 0x05, 0x05, 0x09, 0xC0, // "æ" (U+00E6)
  0x00, 0xE7, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x09, 0xCE, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x01, 0x04, 0x07, 0x05, 0x09, 0xE2, // "è" (U+00E8)
  0x00, 0xE9, 0x00, 0x01, 0x04, 0x07, 0x05, 0x09, 0xF5, // "é" (U+00E9)
  0x00, 0xEA, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x09, // "ê" (U+00EA)
  0x00, 0xEB, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x1D, // "ë" (U+00EB)
  0x00, 0xEC, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x2E, // "ì" (U+00EC)
  0x00, 0xED, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x42, // "í" (U+00ED)
  0x00, 0xEE, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x56, // "î" (U+00EE)
  0x00, 0xEF, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x6A, // "ï" (U+00EF)
  0x00, 0xF0, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0A, 0x7C, // "ð" (U+00F0)
  0x00, 0xF1, 0x00, 0x01, 0x04, 0x06, 0x05, 0x0A, 0x93, // "ñ" (U+00F1)
  0x00, 0xF2, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0A, 0xA4, // "ò" (U+00F2)
  0x00, 0xF3, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0A, 0xB7, // "ó" (U+00F3)
  0x00, 0xF4, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0A, 0xCB, // "ô" (U+00F4)
  0x00, 0xF5, 0x00, 0x01, 0x04, 0x06, 0x05, 0x0A, 0xDF, // "õ" (U+00F5)
  0x00, 0xF6, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0A, 0xF0, // "ö" (U+00F6)
  0x00, 0xF7, 0x00, 0x02, 0x04, 0x05, 0x05, 0x0B, 0x01, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x01, 0x04, 0x05, 0x05, 0x0B, 0x0B, // "ø" (U+00F8)
  0x00, 0xF9, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0B, 0x19, // "ù" (U+00F9)
  0x00, 0xFA, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0B, 0x2D, // "ú" (U+00FA)
  0x00, 0xFB, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0B, 0x40, // "û" (U+00FB)
  0x00, 0xFC, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0B, 0x54, // "ü" (U+00FC)
  0x00, 0xFD, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0B, 0x66, // "ý" (U+00FD)
  0x00, 0xFE, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0B, 0x7F, // "þ" (U+00FE)
  0x00, 0xFF, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0B, 0x96, // "ÿ" (U+00FF)
  0x01, 0x00, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0B, 0xAE, // "Ā" (U+0100)
  0x01, 0x01, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0B, 0xC5, // "ā" (U+0101)
  0x01, 0x02, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0B, 0xD9, // "Ă" (U+0102)
  0x01, 0x03, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0B, 0xF1, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0xFE, 0x05, 0x06, 0x05, 0x0C, 0x05, // "Ą" (U+0104)
  0x01, 0x05, 0x00, 0xFE, 0x04, 0x05, 0x05, 0x0C, 0x20, // "ą" (U+0105)
  0x01, 0x06, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0C, 0x36, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0C, 0x4C, // "ć" (U+0107)
  0x01, 0x08, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0C, 0x5F, // "Ĉ" (U+0108)
  0x01, 0x09, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0C, 0x75, // "ĉ" (U+0109)
  0x01, 0x0A, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0C, 0x89, // "Ċ" (U+010A)
  0x01, 0x0B, 0x00, 0x01, 0x03, 0x07, 0x05, 0x0C, 0x9D, // "ċ" (U+010B)
  0x01, 0x0C, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0C, 0xAB, // "Č" (U+010C)
  0x01, 0x0D, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0C, 0xC1, // "č" (U+010D)
  0x01, 0x0E, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0C, 0xD5, // "Ď" (U+010E)
  0x01, 0x0F, 0x00, 0x01, 0x05, 0x07, 0x05, 0x0C, 0xEB, // "ď" (U+010F)
  0x01, 0x10, 0x00, 0x01, 0x04, 0x06, 0x05, 0x0D, 0x03, // "Đ" (U+0110)
  0x01, 0x11, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0D, 0x15, // "đ" (U+0111)
  0x01, 0x12, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0D, 0x28, // "Ē" (U+0112)
  0x01, 0x13, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0D, 0x3D, // "ē" (U+0113)
  0x01, 0x14, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0D, 0x50, // "Ĕ" (U+0114)
  0x01, 0x15, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0D, 0x65, // "ĕ" (U+0115)
  0x01, 0x16, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0D, 0x79, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0D, 0x8B, // "ė" (U+0117)
  0x01, 0x18, 0x00, 0xFE, 0x04, 0x06, 0x05, 0x0D, 0x9C, // "Ę" (U+0118)
  0x01, 0x19, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x0D, 0xB3, // "ę" (U+0119)
  0x01, 0x1A, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0D, 0xC7, // "Ě" (U+011A)
  0x01, 0x1B, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0D, 0xDC, // "ě" (U+011B)
  0x01, 0x1C, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0D, 0xF0, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0E, 0x06, // "ĝ" (U+011D)
  0x01, 0x1E, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0E, 0x1F, // "Ğ" (U+011E)
  0x01, 0x1F, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0E, 0x35, // "ğ" (U+011F)
  0x01, 0x20, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0E, 0x4E, // "Ġ" (U+0120)
  0x01, 0x21, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0E, 0x61, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0xFE, 0x04, 0x06, 0x05, 0x0E, 0x77, // "Ģ" (U+0122)
  0x01, 0x23, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0E, 0x8C, // "ģ" (U+0123)
  0x01, 0x24, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0E, 0xA1, // "Ĥ" (U+0124)
  0x01, 0x25, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0E, 0xB7, // "ĥ" (U+0125)
  0x01, 0x26, 0x00, 0x01, 0x04, 0x06, 0x05, 0x0E, 0xD0, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0E, 0xE0, // "ħ" (U+0127)
  0x01, 0x28, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0E, 0xF3, // "Ĩ" (U+0128)
  0x01, 0x29, 0x00, 0x01, 0x04, 0x06, 0x05, 0x0F, 0x06, // "ĩ" (U+0129)
  0x01, 0x2A, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0F, 0x17, // "Ī" (U+012A)
  0x01, 0x2B, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0F, 0x2D, // "ī" (U+012B)
  0x01, 0x2C, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0F, 0x41, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0F, 0x57, // "ĭ" (U+012D)
  0x01, 0x2E, 0x00, 0xFE, 0x04, 0x06, 0x05, 0x0F, 0x6B, // "Į" (U+012E)
  0x01, 0x2F, 0x00, 0xFE, 0x04, 0x07, 0x05, 0x0F, 0x82, // "į" (U+012F)
  0x01, 0x30, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0F, 0x9B, // "İ" (U+0130)
  0x01, 0x31, 0x00, 0x01, 0x04, 0x05, 0x05, 0x0F, 0xAE, // "ı" (U+0131)
  0x01, 0x32, 0x00, 0x01, 0x04, 0x06, 0x05, 0x0F, 0xBC, // "Ĳ" (U+0132)
  0x01, 0x33, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0F, 0xCD, // "ĳ" (U+0133)
  0x01, 0x34, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0F, 0xE5, // "Ĵ" (U+0134)
  0x01, 0x35, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0F, 0xFB, // "ĵ" (U+0135)
  0x01, 0x36, 0x00, 0xFE, 0x04, 0x06, 0x05, 0x10, 0x13, // "Ķ" (U+0136)
  0x01, 0x37, 0x00, 0xFE, 0x04, 0x07, 0x05, 0x10, 0x29, // "ķ" (U+0137)
  0x01, 0x38, 0x00, 0x01, 0x04, 0x05, 0x05, 0x10, 0x42, // "ĸ" (U+0138)
  0x01, 0x39, 0x00, 0x01, 0x04, 0x08, 0x05, 0x10, 0x51, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x00, 0x01, 0x04, 0x09, 0x05, 0x10, 0x67, // "ĺ" (U+013A)
  0x01, 0x3B, 0x00, 0xFE, 0x04, 0x06, 0x05, 0x10, 0x81, // "Ļ" (U+013B)
  0x01, 0x3C, 0x00, 0xFE, 0x04, 0x07, 0x05, 0x10, 0x95, // "ļ" (U+013C)
  0x01, 0x3D, 0x00, 0x01, 0x04, 0x06, 0x05, 0x10, 0xAE, // "Ľ" (U+013D)
  0x01, 0x3E, 0x00, 0x01, 0x04, 0x07, 0x05, 0x10, 0xBE, // "ľ" (U+013E)
  0x01, 0x3F, 0x00, 0x01, 0x04, 0x06, 0x05, 0x10, 0xD2, // "Ŀ" (U+013F)
  0x01, 0x40, 0x00, 0x01, 0x04, 0x07, 0x05, 0x10, 0xE2, // "ŀ" (U+0140)
  0x01, 0x41, 0x00, 0x01, 0x04, 0x06, 0x05, 0x10, 0xF6, // "Ł" (U+0141)
  0x01, 0x42, 0x00, 0x01, 0x04, 0x07, 0x05, 0x11, 0x06, // "ł" (U+0142)
  0x01, 0x43, 0x00, 0x01, 0x04, 0x08, 0x05, 0x11, 0x1A, // "Ń" (U+0143)
  0x01, 0x44, 0x00, 0x01, 0x04, 0x07, 0x05, 0x11, 0x30, // "ń" (U+0144)
  0x01, 0x45, 0x00, 0xFE, 0x04, 0x06, 0x05, 0x11, 0x43, // "Ņ" (U+0145)
  0x01, 0x46, 0x00, 0xFE, 0x04, 0x05, 0x05, 0x11, 0x58, // "ņ" (U+0146)
  0x01, 0x47, 0x00, 0x01, 0x04, 0x08, 0x05, 0x11, 0x6B, // "Ň" (U+0147)
  0x01, 0x48, 0x00, 0x01, 0x04, 0x07, 0x05, 0x11, 0x81, // "ň" (U+0148)
  0x01, 0x49, 0xFF, 0x01, 0x04, 0x06, 0x05, 0x11, 0x95, // "ŉ" (U+0149)
  0x01, 0x4A, 0x00, 0xFE, 0x04, 0x06, 0x05, 0x11, 0xA8, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x11, 0xC0, // "ŋ" (U+014B)
  0x01, 0x4C, 0x00, 0x01, 0x04, 0x08, 0x05, 0x11, 0xD4, // "Ō" (U+014C)
  0x01, 0x4D, 0x00, 0x01, 0x04, 0x07, 0x05, 0x11, 0xEA, // "ō" (U+014D)
  0x01, 0x4E, 0x00, 0x01, 0x04, 0x08, 0x05, 0x11, 0xFD, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x00, 0x01, 0x04, 0x07, 0x05, 0x12, 0x13, // "ŏ" (U+014F)
  0x01, 0x50, 0x00, 0x01, 0x04, 0x08, 0x05, 0x12, 0x27, // "Ő" (U+0150)
  0x01, 0x51, 0x00, 0x01, 0x04, 0x07, 0x05, 0x12, 0x3D, // "ő" (U+0151)
  0x01, 0x52, 0x00, 0x01, 0x04, 0x06, 0x05, 0x12, 0x50, // "Œ" (U+0152)
  0x01, 0x53, 0x00, 0x01, 0x04, 0x05, 0x05, 0x12, 0x61, // "œ" (U+0153)
  0x01, 0x54, 0x00, 0x01, 0x04, 0x08, 0x05, 0x12, 0x6F, // "Ŕ" (U+0154)
  0x01, 0x55, 0x00, 0x01, 0x04, 0x07, 0x05, 0x12, 0x86, // "ŕ" (U+0155)
  0x01, 0x56, 0x00, 0xFE, 0x04, 0x06, 0x05, 0x12, 0x99, // "Ŗ" (U+0156)
  0x01, 0x57, 0x00, 0xFE, 0x04, 0x05, 0x05, 0x12, 0xAF, // "ŗ" (U+0157)
  0x01, 0x58, 0x00, 0x01, 0x04, 0x08, 0x05, 0x12, 0xC1, // "Ř" (U+0158)
  0x01, 0x59, 0x00, 0x01, 0x04, 0x07, 0x05, 0x12, 0xD8, // "ř" (U+0159)
  0x01, 0x5A, 0x00, 0x01, 0x04, 0x08, 0x05, 0x12, 0xEC, // "Ś" (U+015A)
  0x01, 0x5B, 0x00, 0x01, 0x04, 0x07, 0x05, 0x13, 0x02, // "ś" (U+015B)
  0x01, 0x5C, 0x00, 0x01, 0x04, 0x08, 0x05, 0x13, 0x16, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x00, 0x01, 0x04, 0x07, 0x05, 0x13, 0x2D, // "ŝ" (U+015D)
  0x01, 0x5E, 0x00, 0xFF, 0x04, 0x06, 0x05, 0x13, 0x42, // "Ş" (U+015E)
  0x01, 0x5F, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x13, 0x59, // "ş" (U+015F)
  0x01, 0x60, 0x00, 0x01, 0x04, 0x08, 0x05, 0x13, 0x6D, // "Š" (U+0160)
  0x01, 0x61, 0x00, 0x01, 0x04, 0x07, 0x05, 0x13, 0x84, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFF, 0x04, 0x06, 0x05, 0x13, 0x99, // "Ţ" (U+0162)
  0x01, 0x63, 0x00, 0xFF, 0x04, 0x06, 0x05, 0x13, 0xAC, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x04, 0x08, 0x05, 0x13, 0xC3, // "Ť" (U+0164)
  0x01, 0x65, 0x00, 0x01, 0x04, 0x07, 0x05, 0x13, 0xD6, // "ť" (U+0165)
  0x01, 0x66, 0x00, 0x01, 0x04, 0x06, 0x05, 0x13, 0xE9, // "Ŧ" (U+0166)
  0x01, 0x67, 0x00, 0x01, 0x04, 0x06, 0x05, 0x13, 0xF9, // "ŧ" (U+0167)
  0x01, 0x68, 0x00, 0x01, 0x04, 0x07, 0x05, 0x14, 0x0B, // "Ũ" (U+0168)
  0x01, 0x69, 0x00, 0x01, 0x04, 0x06, 0x05, 0x14, 0x1E, // "ũ" (U+0169)
  0x01, 0x6A, 0x00, 0x01, 0x04, 0x08, 0x05, 0x14, 0x2F, // "Ū" (U+016A)
  0x01, 0x6B, 0x00, 0x01, 0x04, 0x07, 0x05, 0x14, 0x45, // "ū" (U+016B)
  0x01, 0x6C, 0x00, 0x01, 0x04, 0x08, 0x05, 0x14, 0x59, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x00, 0x01, 0x04, 0x07, 0x05, 0x14, 0x6F, // "ŭ" (U+016D)
  0x01, 0x6E, 0x00, 0x01, 0x04, 0x08, 0x05, 0x14, 0x83, // "Ů" (U+016E)
  0x01, 0x6F, 0x00, 0x01, 0x04, 0x07, 0x05, 0x14, 0x99, // "ů" (U+016F)
  0x01, 0x70, 0x00, 0x01, 0x04, 0x08, 0x05, 0x14, 0xAD, // "Ű" (U+0170)
  0x01, 0x71, 0x00, 0x01, 0x04, 0x07, 0x05, 0x14, 0xC3, // "ű" (U+0171)
  0x01, 0x72, 0x00, 0xFF, 0x04, 0x06, 0x05, 0x14, 0xD6, // "Ų" (U+0172)
  0x01, 0x73, 0x00, 0xFE, 0x04, 0x05, 0x05, 0x14, 0xEC, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x04, 0x08, 0x05, 0x15, 0x02, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x04, 0x07, 0x05, 0x15, 0x18, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x01, 0x04, 0x08, 0x05, 0x15, 0x2C, // "Ŷ" (U+0176)
  0x01, 0x77, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x15, 0x42, // "ŷ" (U+0177)
  0x01, 0x78, 0x00, 0x01, 0x04, 0x08, 0x05, 0x15, 0x5C, // "Ÿ" (U+0178)
  0x01, 0x79, 0x00, 0x01, 0x04, 0x08, 0x05, 0x15, 0x70, // "Ź" (U+0179)
  0x01, 0x7A, 0x00, 0x01, 0x04, 0x07, 0x05, 0x15, 0x85, // "ź" (U+017A)
  0x01, 0x7B, 0x00, 0x01, 0x04, 0x08, 0x05, 0x15, 0x98, // "Ż" (U+017B)
  0x01, 0x7C, 0x00, 0x01, 0x04, 0x07, 0x05, 0x15, 0xAB, // "ż" (U+017C)
  0x01, 0x7D, 0x00, 0x01, 0x04, 0x08, 0x05, 0x15, 0xBB, // "Ž" (U+017D)
  0x01, 0x7E, 0x00, 0x01, 0x04, 0x07, 0x05, 0x15, 0xD1, // "ž" (U+017E)
  0x01, 0x7F, 0x01, 0x01, 0x03, 0x07, 0x05, 0x15, 0xE4, // "ſ" (U+017F)
  0x03, 0xA9, 0x00, 0x01, 0x04, 0x06, 0x05, 0x15, 0xF0, // "Ω" (U+03A9)
  0x03, 0xBC, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x16, 0x01, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x01, 0x04, 0x05, 0x05, 0x16, 0x13, // "π" (U+03C0)
  0x20, 0x13, 0x00, 0x02, 0x03, 0x03, 0x05, 0x16, 0x21, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x02, 0x04, 0x03, 0x05, 0x16, 0x26, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x01, 0x04, 0x06, 0x05, 0x16, 0x2B, // "€" (U+20AC)
  0x20, 0xBF, 0x00, 0x00, 0x04, 0x07, 0x05, 0x16, 0x3D, // "₿" (U+20BF)
  0x20, 0x18, 0x01, 0x04, 0x02, 0x06, 0x05, 0x16, 0x54, // "‘" (U+2018)
  0x20, 0x19, 0x01, 0x04, 0x03, 0x06, 0x05, 0x16, 0x58, // "’" (U+2019)
  0x20, 0x1A, 0x01, 0x00, 0x02, 0x02, 0x05, 0x16, 0x5E, // "‚" (U+201A)
  0x20, 0x1B, 0x01, 0x04, 0x02, 0x06, 0x05, 0x16, 0x62, // "‛" (U+201B)
  0x20, 0x1C, 0x00, 0x04, 0x03, 0x06, 0x05, 0x16, 0x66, // "“" (U+201C)
  0x20, 0x1D, 0x01, 0x04, 0x04, 0x06, 0x05, 0x16, 0x6E, // "”" (U+201D)
  0x20, 0x1E, 0x00, 0x00, 0x03, 0x02, 0x05, 0x16, 0x76, // "„" (U+201E)
  0x20, 0x1F, 0x00, 0x04, 0x03, 0x06, 0x05, 0x16, 0x7E, // "‟" (U+201F)
  0x20, 0x20, 0x00, 0x01, 0x03, 0x07, 0x05, 0x16, 0x86, // "†" (U+2020)
  0x20, 0x21, 0x00, 0x01, 0x03, 0x07, 0x05, 0x16, 0x96, // "‡" (U+2021)
  0x20, 0x22, 0x01, 0x03, 0x03, 0x05, 0x05, 0x16, 0xA6, // "•" (U+2022)
  0x20, 0x26, 0xFF, 0x01, 0x04, 0x01, 0x05, 0x16, 0xAC, // "…" (U+2026)
  0x20, 0x30, 0x00, 0x01, 0x04, 0x06, 0x05, 0x16, 0xB0, // "‰" (U+2030)
  0x20, 0x39, 0x01, 0x01, 0x03, 0x04, 0x05, 0x16, 0xC1, // "‹" (U+2039)
  0x20, 0x3A, 0x01, 0x01, 0x03, 0x04, 0x05, 0x16, 0xC9, // "›" (U+203A)
  0x20, 0x44, 0xFE, 0x01, 0x01, 0x06, 0x00, 0x16, 0xD1, // "⁄" (U+2044)
  0x21, 0x22, 0x00, 0x04, 0x04, 0x06, 0x05, 0x16, 0xDF, // "™" (U+2122)
  0x21, 0x52, 0x02, 0x01, 0x0C, 0x06, 0x0E, 0x16, 0xE8, // "⅒" (U+2152)
  0x22, 0x02, 0x00, 0x01, 0x04, 0x06, 0x05, 0x17, 0x07, // "∂" (U+2202)
  0x22, 0x06, 0x00, 0x01, 0x04, 0x06, 0x05, 0x17, 0x18, // "∆" (U+2206)
  0x22, 0x1A, 0x00, 0x01, 0x04, 0x08, 0x05, 0x17, 0x29, // "√" (U+221A)
  0x22, 0x1E, 0x00, 0x02, 0x04, 0x04, 0x05, 0x17, 0x3D, // "∞" (U+221E)
  0x22, 0x48, 0x00, 0x02, 0x04, 0x05, 0x05, 0x17, 0x46, // "≈" (U+2248)
  0x22, 0x60, 0x00, 0x01, 0x04, 0x05, 0x05, 0x17, 0x52, // "≠" (U+2260)
  0x22, 0x64, 0x00, 0x01, 0x04, 0x06, 0x05, 0x17, 0x5E, // "≤" (U+2264)
  0x22, 0x65, 0x00, 0x01, 0x04, 0x06, 0x05, 0x17, 0x6D, // "≥" (U+2265)
  
  // Kerning pairs
  
  // Glyph data
  // "!" (U+0021)
  0x86, 0x3F, 0x3F, 0x2F, 0x2E, 0x20, 0x20, 0xD0,
  // """ (U+0022)
  0x87, 0xE6, 0xBD, 0x4A, 0x10, 0x10,
  // "#" (U+0023)
  0x18, 0xB2, 0x66, 0xC0, 0x9F, 0xEF, 0xA1, 0xB6, 0x91, 0xCF, 0xEF, 0x61, 0xC9, 0x50, 0x2A, 0xA2,
  0x10,
  // "$" (U+0024)
  0x18, 0x92, 0x3B, 0x40, 0x3D, 0xCA, 0x03, 0xD9, 0x38, 0x90, 0x5E, 0xA0, 0x11, 0x8E, 0x14, 0xA0,
  0xB3, 0x08, 0x20,
  // "%" (U+0025)
  0x89, 0x4A, 0xD1, 0xC1, 0xC9, 0x98, 0x0B, 0xED, 0x12, 0x89, 0x45, 0xBD, 0x60, 0xB8, 0x8B, 0x49,
  0x3E, 0x70,
  // "&" (U+0026)
  0x89, 0x31, 0xDD, 0x10, 0x4B, 0xA3, 0x01, 0xEC, 0x28, 0x95, 0x5D, 0xBB, 0x5A, 0x6A, 0xE0, 0x5E,
  0xCD, 0x50,
  // "'" (U+0027)
  0x84, 0x1E, 0x0D, 0x01,
  // "(" (U+0028)
  0x18, 0x96, 0x94, 0x1D, 0x05, 0x90, 0x78, 0x06, 0x90, 0x2D, 0x20, 0x90, 0x50,
  // ")" (U+0029)
  0x05, 0x0A, 0x28, 0x96, 0xD2, 0x09, 0x60, 0x87, 0x09, 0x50, 0xD2, 0x49, 0x10,
  // "*" (U+002A)
  0x20, 0xC2, 0x87, 0x4A, 0xDB, 0x10, 0x8E, 0x52, 0x81, 0x83, 0x61,
  // "+" (U+002B)
  0x20, 0xD2, 0x87, 0x6E, 0xFE, 0x30, 0x1D, 0x13, 0x0D, 0x20,
  // "," (U+002C)
  0x84, 0x1D, 0x3D, 0x58,
  // "-" (U+002D)
  0x81, 0xBE, 0x80, 0xF1,
  // "." (U+002E)
  0x02, 0x0D,
  // "/" (U+002F)
  0x18, 0x95, 0x2C, 0x08, 0x70, 0xD1, 0x4B, 0x0A, 0x50, 0xE2,
  // "0" (U+0030)
  0x18, 0xB2, 0xBE, 0x80, 0x6C, 0x5F, 0x28, 0x8C, 0xD5, 0x8D, 0x7C, 0x55, 0xE2, 0xE3, 0x0A, 0xE9,
  0x10,
  // "1" (U+0031)
  0x18, 0x68, 0xF2, 0x03, 0xBF, 0x23, 0x90, 0x23, 0x90, 0x23, 0x98, 0x52, 0x01, 0xDF, 0xE3,
  // "2" (U+0032)
  0x89, 0x03, 0xCE, 0xA0, 0x15, 0x2F, 0x32, 0x89, 0x12, 0xE1, 0x01, 0xD5, 0x01, 0xD6, 0x20, 0x8B,
  0x06,
  // "3" (U+0033)
  0x82, 0x2C, 0xEA, 0x20, 0x03, 0x92, 0x81, 0x8F, 0x82, 0x89, 0x31, 0x3F, 0x22, 0x23, 0xF3, 0x5E,
  0xE8, 0x10,
  // "4" (U+0034)
  0x20, 0x90, 0xB2, 0x81, 0x3F, 0xB2, 0x8A, 0x0B, 0xAB, 0x04, 0xB5, 0xB0, 0xAE, 0xEF, 0x71, 0x16,
  0xC1,
  // "5" (U+0035)
  0x01, 0xA8, 0x91, 0xD0, 0x2E, 0x11, 0x04, 0xFB, 0x62, 0x89, 0x32, 0x4F, 0x12, 0x24, 0xF1, 0x4E,
  0xE7, 0x10,
  // "6" (U+0036)
  0x18, 0xB2, 0x6D, 0xE0, 0x3E, 0x31, 0x07, 0xCD, 0xB0, 0x8D, 0x3E, 0x45, 0xC2, 0xE4, 0x0A, 0xEA,
  0x10,
  // "7" (U+0037)
  0x09, 0xB0, 0x62, 0x81, 0x2F, 0x22, 0x07, 0x0A, 0x30, 0xE0, 0x42, 0x05, 0x0D, 0x30, 0xC0, 0x62,
  // "8" (U+0038)
  0x8B, 0x31, 0xBE, 0xA0, 0x4D, 0x2F, 0x10, 0xCC, 0xA0, 0x3D, 0x9D, 0x17, 0xB1, 0xE4, 0x2C, 0xEA,
  0x10,
  // "9" (U+0039)
  0x8B, 0x31, 0xBE, 0x70, 0x7B, 0x2F, 0x28, 0xB1, 0xE5, 0x3E, 0xEE, 0x40, 0x15, 0xE0, 0x2F, 0xC4,
  0x10,
  // ":" (U+003A)
  0x02, 0x0D, 0x60, 0x20, 0xD0,
  // ";" (U+003B)
  0x10, 0xE0, 0x26, 0x86, 0x1D, 0x03, 0xD0, 0x58, 0x10,
  // "<" (U+003C)
  0x28, 0x77, 0x36, 0xC7, 0x0B, 0xA2, 0x28, 0x13, 0xB4,
  // "=" (U+003D)
  0x89, 0x56, 0xEE, 0xE3, 0x01, 0x11, 0x06, 0xEE, 0xE3, 0x10, 0xF1, 0x10,
  // ">" (U+003E)
  0x03, 0x07, 0x38, 0x90, 0x7C, 0x60, 0x3A, 0xB4, 0xB3, 0x10,
  // "?" (U+003F)
  0x82, 0x2C, 0xE9, 0x28, 0x24, 0x2F, 0x12, 0x07, 0x0D, 0x28, 0x13, 0xD1, 0x20, 0x10, 0x33, 0x05,
  0x0B, 0x20,
  // "@" (U+0040)
  0x18, 0xC4, 0x9E, 0xA0, 0x6A, 0x19, 0x6B, 0x5D, 0x7A, 0xCA, 0x77, 0xBC, 0xB6, 0x8A, 0xC8, 0xDE,
  0x59, 0x60, 0x20, 0x1C, 0xFD, 0x30, 0x12,
  // "A" (U+0041)
  0x18, 0x17, 0xF4, 0x28, 0x1B, 0xA8, 0x28, 0xA1, 0xE2, 0xC0, 0x4F, 0xEF, 0x18, 0x81, 0xB5, 0xC4,
  0x08, 0x90,
  // "B" (U+0042)
  0x05, 0xA8, 0xA5, 0xC1, 0x5B, 0x1E, 0x45, 0xFE, 0xC0, 0x5B, 0x2D, 0x55, 0xB1, 0xD6, 0x5A, 0x0B,
  0x01,
  // "C" (U+0043)
  0x18, 0x91, 0x7E, 0xE4, 0x4E, 0x32, 0x08, 0xA3, 0x08, 0x09, 0x38, 0x90, 0x5D, 0x21, 0x10, 0x9E,
  0xE2,
  // "D" (U+0044)
  0x8B, 0x39, 0xFE, 0x80, 0x98, 0x2E, 0x49, 0x70, 0xA7, 0x97, 0x0A, 0x79, 0x83, 0xE3, 0x9F, 0xE7,
  0x10,
  // "E" (U+0045)
  0x05, 0xB8, 0x13, 0x5C, 0x38, 0x92, 0x5F, 0xEE, 0x15, 0xC1, 0x10, 0x5C, 0x30, 0x5B, 0x03,
  // "F" (U+0046)
  0x05, 0xB8, 0x13, 0x5C, 0x38, 0x92, 0x5F, 0xEE, 0x15, 0xC1, 0x10, 0x5B, 0x30, 0x50, 0xB3,
  // "G" (U+0047)
  0x18, 0xB3, 0x9E, 0xD2, 0x6D, 0x21, 0x0A, 0x75, 0xE6, 0xB7, 0x0A, 0x67, 0xC1, 0xA6, 0x0A, 0xEE,
  0x50,
  // "H" (U+0048)
  0x8B, 0x49, 0x80, 0xB6, 0x98, 0x0B, 0x69, 0xFE, 0xF6, 0x98, 0x1B, 0x69, 0x80, 0xB6, 0x98, 0x0B,
  0x60,
  // "I" (U+0049)
  0x04, 0xB8, 0x21, 0x02, 0xE3, 0x02, 0x0E, 0x30, 0x20, 0xE3, 0x02, 0x0E, 0x28, 0x33, 0xEF, 0xD1,
  // "J" (U+004A)
  0x20, 0x30, 0xE2, 0x03, 0x0E, 0x20, 0x30, 0xE2, 0x89, 0x03, 0xE1, 0x17, 0xC4, 0xFE, 0x50,
  // "K" (U+004B)
  0x89, 0x39, 0x71, 0xE3, 0x97, 0xA8, 0x09, 0xBD, 0x28, 0x95, 0x9E, 0xE2, 0x09, 0x78, 0xA0, 0x97,
  0x1E, 0x30,
  // "L" (U+004C)
  0x04, 0x0D, 0x30, 0x40, 0xD3, 0x04, 0x0D, 0x30, 0x40, 0xD3, 0x84, 0x4D, 0x22, 0x04, 0xB0, 0x30,
  // "M" (U+004D)
  0x8B, 0x4A, 0xE1, 0xF7, 0xAE, 0x5F, 0x7A, 0xC9, 0xD7, 0xAB, 0xEB, 0x7A, 0x9F, 0x97, 0xA5, 0x08,
  0x70,
  // "N" (U+004E)
  0x8B, 0x49, 0xF1, 0x96, 0x9D, 0x69, 0x69, 0x9B, 0x96, 0x96, 0xD9, 0x69, 0x69, 0xD6, 0x96, 0x4F,
  0x60,
  // "O" (U+004F)
  0x8B, 0x31, 0xBE, 0x90, 0x8B, 0x2D, 0x4B, 0x70, 0xA7, 0xB7, 0x0A, 0x78, 0xB1, 0xD4, 0x1B, 0xE9,
  0x10,
  // "P" (U+0050)
  0x05, 0xA8, 0x93, 0xB1, 0x5C, 0x1C, 0x65, 0xB0, 0xC6, 0x5A, 0x83, 0xC1, 0x5C, 0x12, 0x05, 0x0B,
  0x30,
  // "Q" (U+0051)
  0x8B, 0x31, 0xBE, 0x90, 0x8B, 0x2D, 0x4B, 0x70, 0xA7, 0xB7, 0x0A, 0x88, 0xB1, 0xD5, 0x1B, 0xFC,
  0x30, 0x40, 0xD4, 0x07, 0x02,
  // "R" (U+0052)
  0x89, 0x15, 0xFE, 0xA0, 0x5C, 0x2F, 0x35, 0xA8, 0x97, 0xA0, 0x5C, 0x99, 0x05, 0xC2, 0xE1, 0x5C,
  0x0B, 0x70,
  // "S" (U+0053)
  0x18, 0x93, 0xBF, 0xD1, 0x4E, 0x13, 0x01, 0xD9, 0x12, 0x89, 0x31, 0x8E, 0x12, 0x21, 0xE4, 0x4E,
  0xEA, 0x10,
  // "T" (U+0054)
  0x0B, 0xB8, 0x18, 0x03, 0x93, 0x02, 0x93, 0x02, 0x93, 0x02, 0x93, 0x02, 0x92,
  // "U" (U+0055)
  0x8B, 0x39, 0x80, 0xB6, 0x98, 0x0B, 0x69, 0x80, 0xB6, 0x98, 0x0B, 0x68, 0xB2, 0xD5, 0x1C, 0xEA,
  0x10,
  // "V" (U+0056)
  0x89, 0x4C, 0x50, 0x98, 0x79, 0x0C, 0x43, 0xD0, 0xE2, 0x81, 0xE5, 0xB2, 0x81, 0xAC, 0x72, 0x81,
  0x6F, 0x21,
  // "W" (U+0057)
  0x8B, 0x4D, 0x20, 0x5A, 0xC6, 0xF6, 0x9B, 0x9E, 0x98, 0xAC, 0xAC, 0x79, 0xE6, 0xE6, 0x8F, 0x3F,
  0x50,
  // "X" (U+0058)
  0x87, 0x7A, 0x0D, 0x30, 0xD8, 0xB2, 0x81, 0x5F, 0x22, 0x89, 0x46, 0xF3, 0x01, 0xE7, 0xC0, 0x89,
  0x0C, 0x50,
  // "Y" (U+0059)
  0x87, 0x99, 0x0C, 0x62, 0xE3, 0xE2, 0x81, 0xBD, 0x82, 0x81, 0x4F, 0x12, 0x02, 0x93, 0x02, 0x92,
  // "Z" (U+005A)
  0x02, 0xB0, 0x32, 0x05, 0x0D, 0x30, 0xD0, 0x42, 0x06, 0x0B, 0x28, 0x11, 0xE3, 0x20, 0x5B, 0x03,
  // "[" (U+005B)
  0x8B, 0x12, 0xFB, 0x2D, 0x02, 0xC0, 0x2C, 0x02, 0xC0, 0x2C, 0x02, 0xC0, 0x2F, 0xB0, 0x11,
  // "\" (U+005C)
  0x86, 0xC2, 0x07, 0x80, 0x1D, 0x28, 0x3B, 0x40, 0x5A, 0x20, 0xE0,
  // "]" (U+005D)
  0x8B, 0x11, 0x10, 0xBF, 0x20, 0xC2, 0x0C, 0x20, 0xC2, 0x0C, 0x20, 0xC2, 0x0D, 0x2B, 0xF2,
  // "^" (U+005E)
  0x10, 0x20, 0xC3, 0x89, 0x49, 0xD4, 0x01, 0xD2, 0xB0, 0x77, 0x0A, 0x30,
  // "_" (U+005F)
  0x80, 0x0E, 0x0B, 0x80, 0x11,
  // "`" (U+0060)
  0x82, 0x63, 0x2C,
  // "a" (U+0061)
  0x82, 0x2D, 0xEA, 0x28, 0xA1, 0x31, 0xE3, 0x3C, 0xEF, 0x48, 0xB4, 0xE4, 0x4E, 0xCC, 0x40,
  // "b" (U+0062)
  0x08, 0x09, 0x30, 0x08, 0x38, 0xA6, 0x8B, 0xDC, 0x08, 0xC1, 0xD5, 0x89, 0x0B, 0x68, 0xC1, 0xD5,
  0x88, 0xDB, 0x10,
  // "c" (U+0063)
  0x18, 0x79, 0xED, 0x4E, 0x22, 0x6B, 0x28, 0x64, 0xE2, 0x30, 0xAE, 0xD0,
  // "d" (U+0064)
  0x30, 0xC0, 0x53, 0x8B, 0x1C, 0x51, 0xDD, 0xD5, 0x8B, 0x1D, 0x5A, 0x80, 0xB5, 0x8B, 0x1D, 0x51,
  0xDC, 0xB5,
  // "e" (U+0065)
  0x18, 0xA6, 0xBE, 0x90, 0x6C, 0x1D, 0x38, 0xFE, 0xF6, 0x6C, 0x33, 0x10, 0x9E, 0xE3,
  // "f" (U+0066)
  0x28, 0x90, 0xCF, 0x70, 0x4E, 0x10, 0x5E, 0xA8, 0x24, 0x05, 0xD3, 0x04, 0x0D, 0x30, 0x40, 0xD3,
  0x04, 0x0D, 0x20,
  // "g" (U+0067)
  0x8C, 0x02, 0xDC, 0xB5, 0x8B, 0x1E, 0x5A, 0x80, 0xB5, 0x8B, 0x1D, 0x52, 0xDD, 0xD5, 0x12, 0x1E,
  0x34, 0xEE, 0x91,
  // "h" (U+0068)
  0x08, 0x09, 0x30, 0x80, 0x93, 0x8A, 0x78, 0xCD, 0xC1, 0x8C, 0x2D, 0x58, 0x90, 0xB6, 0x89, 0x0B,
  0x68, 0x90, 0xB6,
  // "i" (U+0069)
  0x18, 0x11, 0xE1, 0x60, 0x4A, 0x01, 0x28, 0x11, 0xF1, 0x28, 0x11, 0xF1, 0x28, 0x31, 0xF1, 0x06,
  0xB0, 0x50,
  // "j" (U+006A)
  0x20, 0xC0, 0x55, 0x81, 0xEF, 0x62, 0x0B, 0x06, 0x20, 0xB0, 0x62, 0x0B, 0x06, 0x28, 0x7B, 0x62,
  0x2D, 0x59, 0xFB, 0x10,
  // "k" (U+006B)
  0x08, 0x09, 0x30, 0x80, 0x93, 0x89, 0x18, 0x92, 0xE3, 0x8A, 0xC6, 0x08, 0xA8, 0x92, 0x30, 0x8B,
  0x6C, 0x08, 0x90, 0xC6,
  // "l" (U+006C)
  0x03, 0xA0, 0x12, 0x81, 0x2F, 0x12, 0x81, 0x1F, 0x12, 0x81, 0x1F, 0x12, 0x81, 0x1F, 0x12, 0x83,
  0x1F, 0x10, 0x6B, 0x05,
  // "m" (U+006D)
  0x8A, 0x7B, 0xBA, 0xD5, 0xB7, 0xE8, 0x8B, 0x5E, 0x68, 0xB5, 0xE6, 0x8B, 0x5E, 0x68,
  // "n" (U+006E)
  0x8A, 0x78, 0xAE, 0xC1, 0x8D, 0x1D, 0x58, 0x90, 0xB6, 0x89, 0x0B, 0x68, 0x90, 0xB6,
  // "o" (U+006F)
  0x18, 0xA5, 0xBE, 0x90, 0x7B, 0x1D, 0x49, 0x80, 0xB6, 0x7B, 0x1D, 0x40, 0xBF, 0x91,
  // "p" (U+0070)
  0x8B, 0x18, 0xAE, 0xC0, 0x8C, 0x1D, 0x58, 0x90, 0xB7, 0x8C, 0x1D, 0x58, 0xCE, 0xB0, 0x88, 0x30,
  0x80, 0x93,
  // "q" (U+0071)
  0x8A, 0x71, 0xDD, 0xB5, 0x8B, 0x2E, 0x5A, 0x80, 0xB5, 0x8B, 0x1E, 0x51, 0xDC, 0xD5, 0x30, 0xC0,
  0x53, 0x0C, 0x05,
  // "r" (U+0072)
  0x87, 0x6F, 0xAD, 0x80, 0x8D, 0x22, 0x08, 0x09, 0x30, 0x80, 0xA2, 0x09, 0xA0, 0xA1,
  // "s" (U+0073)
  0x87, 0x1B, 0xFC, 0x04, 0xF3, 0x32, 0x89, 0x39, 0xF8, 0x02, 0x24, 0xF1, 0x4E, 0xFA, 0x10,
  // "t" (U+0074)
  0x10, 0x60, 0x92, 0x07, 0x0E, 0xA8, 0x33, 0x09, 0x91, 0x20, 0x09, 0x38, 0x18, 0xB1, 0x28, 0x23,
  0xDF, 0x30,
  // "u" (U+0075)
  0x8A, 0x79, 0x80, 0xC5, 0x98, 0x0C, 0x59, 0x80, 0xC5, 0x8B, 0x2E, 0x53, 0xEC, 0xB5,
  // "v" (U+0076)
  0x89, 0x4A, 0x80, 0xB7, 0x5C, 0x0E, 0x20, 0xF5, 0xC2, 0x81, 0xBD, 0x72, 0x81, 0x5F, 0x21,
  // "w" (U+0077)
  0x8A, 0x7E, 0x10, 0x4B, 0xC5, 0xF5, 0x9A, 0x9E, 0x97, 0x8D, 0x9D, 0x56, 0xF4, 0xF3,
  // "x" (U+0078)
  0x87, 0x7D, 0x1E, 0x50, 0xDC, 0xB2, 0x81, 0x7F, 0x42, 0x87, 0xDC, 0xB0, 0x8C, 0x1E, 0x50,
  // "y" (U+0079)
  0x89, 0x4A, 0x80, 0xB7, 0x4D, 0x0F, 0x20, 0xE7, 0xC2, 0x81, 0x9E, 0x72, 0x85, 0x3F, 0x20, 0x18,
  0xC2, 0x81, 0x8D, 0x32,
  // "z" (U+007A)
  0x05, 0xB0, 0x32, 0x09, 0x0B, 0x28, 0x54, 0xE1, 0x01, 0xE5, 0x20, 0x7B, 0x04,
  // "{" (U+007B)
  0x18, 0x93, 0xAA, 0x0F, 0x21, 0xF0, 0xD8, 0x04, 0xE2, 0x92, 0x98, 0x21, 0x0B, 0xA0,
  // "|" (U+007C)
  0x80, 0x5D,
  // "}" (U+007D)
  0x82, 0xAA, 0x01, 0x92, 0x92, 0x89, 0x3E, 0x40, 0x8D, 0x0F, 0x11, 0xF0, 0xAA, 0x10,
  // "~" (U+007E)
  0x87, 0x1D, 0x66, 0x26, 0x4B, 0xE1,
  // "¡" (U+00A1)
  0x0D, 0x02, 0x28, 0x6E, 0x1F, 0x2F, 0x3F, 0x30,
  // "¢" (U+00A2)
  0x28, 0x90, 0xA3, 0x01, 0xDE, 0xE1, 0x5C, 0x30, 0x50, 0xC4, 0x82, 0xDE, 0xE1, 0x20, 0xA0, 0x21,
  // "£" (U+00A3)
  0x18, 0x93, 0x5E, 0xD1, 0x0B, 0x71, 0x05, 0xFE, 0xA2, 0x81, 0xC6, 0x12, 0x0D, 0x03, 0x20, 0x5B,
  0x04,
  // "¤" (U+00A4)
  0x38, 0xB0, 0x10, 0x4D, 0xED, 0x11, 0xC2, 0xD0, 0x2B, 0x0D, 0x04, 0xEF, 0xE1, 0x11, 0x12, 0x10,
  // "¥" (U+00A5)
  0x87, 0x89, 0x0C, 0x51, 0xE4, 0xD2, 0x89, 0x09, 0xE6, 0x04, 0xEF, 0xE1, 0x4B, 0x83, 0x10, 0x3E,
  0x11,
  // "¦" (U+00A6)
  0x80, 0x0D, 0x18, 0x00, 0xD0,
  // "§" (U+00A7)
  0x18, 0xB1, 0xAE, 0xA0, 0xF2, 0x20, 0xCD, 0x61, 0xE2, 0xE0, 0x6E, 0xA1, 0x24, 0xD1, 0xDE, 0x70,
  // "¨" (U+00A8)
  0x81, 0xC1, 0xB0,
  // "©" (U+00A9)
  0x18, 0x91, 0x89, 0x60, 0x87, 0x96, 0x59, 0xA2, 0x89, 0x08, 0x77, 0x97, 0x50, 0x89, 0x71,
  // "ª" (U+00AA)
  0x87, 0x5A, 0x66, 0x89, 0x78, 0x70,
  // "«" (U+00AB)
  0x18, 0x93, 0x85, 0xB1, 0x4D, 0x99, 0x01, 0xD7, 0xC2, 0x82, 0x33, 0x51,
  // "¬" (U+00AC)
  0x89, 0x06, 0xEE, 0xE2, 0x01, 0x1B, 0x23, 0x06, 0x01,
  // "®" (U+00AE)
  0x18, 0xA5, 0x89, 0x60, 0x87, 0x87, 0x59, 0x7B, 0x28, 0x77, 0x58, 0x50, 0x89, 0x61,
  // "¯" (U+00AF)
  0x81, 0xBE, 0x80, 0xF1,
  // "°" (U+00B0)
  0x87, 0x6D, 0x3B, 0x49, 0x8F, 0x50,
  // "±" (U+00B1)
  0x20, 0xD4, 0x0D, 0x28, 0x76, 0xEF, 0xE3, 0x01, 0xD1, 0x60, 0x6B, 0x03,
  // "²" (U+00B2)
  0x89, 0x26, 0xB3, 0x16, 0x62, 0xB0, 0xAC, 0x80,
  // "³" (U+00B3)
  0x89, 0x27, 0xC3, 0x15, 0x62, 0xD3, 0x8B, 0x50,
  // "´" (U+00B4)
  0x18, 0x34, 0x51, 0xC2,
  // "µ" (U+00B5)
  0x8B, 0x19, 0x80, 0xC5, 0x98, 0x0C, 0x59, 0x80, 0xC5, 0x9B, 0x2E, 0x59, 0xFC, 0xB5, 0x98, 0x30,
  0x90, 0x83,
  // "¶" (U+00B6)
  0x02, 0x0D, 0xA0, 0x60, 0x9A, 0x81, 0x76, 0xAA, 0x81, 0x66, 0x7A, 0x85, 0x66, 0x07, 0xB6, 0x62,
  0x0F, 0x62, 0x0F, 0x62, 0x0F, 0x60,
  // "·" (U+00B7)
  0x02, 0x0D,
  // "¸" (U+00B8)
  0x10, 0x12, 0x83, 0xB1, 0x4B, 0x10,
  // "¹" (U+00B9)
  0x06, 0x0D, 0x28, 0x3B, 0x04, 0xD5,
  // "º" (U+00BA)
  0x87, 0x7B, 0x4C, 0x39, 0x5A, 0x30,
  // "»" (U+00BB)
  0x82, 0x15, 0x33, 0x28, 0x93, 0xC7, 0xD1, 0x09, 0x9D, 0x41, 0xB5, 0x81,
  // "¼" (U+00BC)
  0x09, 0x08, 0x28, 0x90, 0x12, 0x80, 0xB2, 0x7C, 0x86, 0x28, 0x94, 0x2B, 0x61, 0x0B, 0x4C, 0x34,
  0x56, 0xB6, 0x30, 0x11,
  // "½" (U+00BD)
  0x09, 0x08, 0x28, 0x90, 0x12, 0x80, 0xB1, 0x7C, 0xA4, 0x28, 0x76, 0x8C, 0x53, 0xA0, 0x73, 0x28,
  0x13, 0xF9, 0x30, 0x01,
  // "¾" (U+00BE)
  0x04, 0x09, 0x38, 0x72, 0xB0, 0xB2, 0x9D, 0x86, 0x28, 0x94, 0x2B, 0x72, 0x0B, 0x4C, 0x34, 0x56,
  0xB6, 0x30, 0x11,
  // "¿" (U+00BF)
  0x20, 0xB0, 0x53, 0x03, 0x01, 0x28, 0x11, 0xD3, 0x20, 0xD0, 0x72, 0x82, 0x1F, 0x24, 0x28, 0x29,
  0xEC, 0x20,
  // "À" (U+00C0)
  0x10, 0x60, 0x33, 0x02, 0x0C, 0x38, 0x17, 0xF4, 0x28, 0x1B, 0xA8, 0x28, 0xA1, 0xE2, 0xC0, 0x4F,
  0xEF, 0x18, 0x81, 0xB5, 0xC4, 0x08, 0x90,
  // "Á" (U+00C1)
  0x20, 0x40, 0x52, 0x81, 0x1C, 0x22, 0x81, 0x7F, 0x42, 0x81, 0xBA, 0x82, 0x8A, 0x1E, 0x2C, 0x04,
  0xFE, 0xF1, 0x88, 0x1B, 0x5C, 0x40, 0x89,
  // "Â" (U+00C2)
  0x18, 0x12, 0x71, 0x28, 0x1B, 0x79, 0x28, 0x17, 0xF4, 0x28, 0x1B, 0xA8, 0x28, 0xA1, 0xE2, 0xC0,
  0x4F, 0xEF, 0x18, 0x81, 0xB5, 0xC4, 0x08, 0x90,
  // "Ã" (U+00C3)
  0x18, 0x1B, 0xD9, 0x28, 0x17, 0xF4, 0x28, 0x1B, 0xA8, 0x28, 0xA1, 0xE2, 0xC0, 0x4F, 0xEF, 0x18,
  0x81, 0xB5, 0xC4, 0x08, 0x90,
  // "Ä" (U+00C4)
  0x18, 0x1C, 0x1B, 0x78, 0x17, 0xF4, 0x28, 0x1B, 0xA8, 0x28, 0xA1, 0xE2, 0xC0, 0x4F, 0xEF, 0x18,
  0x81, 0xB5, 0xC4, 0x08, 0x90,
  // "Å" (U+00C5)
  0x18, 0x14, 0xD2, 0x28, 0x16, 0xF3, 0x28, 0x17, 0xF4, 0x28, 0x1B, 0xA8, 0x28, 0xA1, 0xE2, 0xC0,
  0x4F, 0xEF, 0x18, 0x81, 0xB5, 0xC4, 0x08, 0x90,
  // "Æ" (U+00C6)
  0x10, 0xAA, 0x89, 0x28, 0x0D, 0x97, 0x02, 0xC8, 0xF6, 0x5A, 0x89, 0x27, 0x09, 0x79, 0x70, 0xC3,
  0x8F, 0x80,
  // "Ç" (U+00C7)
  0x18, 0x91, 0x7E, 0xE4, 0x4E, 0x32, 0x08, 0xA3, 0x08, 0x09, 0x38, 0x90, 0x5D, 0x21, 0x10, 0x9E,
  0xF2, 0x30, 0xB0, 0x12, 0x81, 0x4B, 0x10,
  // "È" (U+00C8)
  0x10, 0x60, 0x33, 0x02, 0x0C, 0x20, 0x5B, 0x81, 0x35, 0xC3, 0x89, 0x25, 0xFE, 0xE1, 0x5C, 0x11,
  0x05, 0xC3, 0x05, 0xB0, 0x30,
  // "É" (U+00C9)
  0x20, 0x40, 0x52, 0x83, 0x1C, 0x20, 0x5B, 0x81, 0x35, 0xC3, 0x89, 0x25, 0xFE, 0xE1, 0x5C, 0x11,
  0x05, 0xC3, 0x05, 0xB0, 0x30,
  // "Ê" (U+00CA)
  0x18, 0x12, 0x71, 0x28, 0x3B, 0x79, 0x05, 0xB8, 0x13, 0x5C, 0x38, 0x92, 0x5F, 0xEE, 0x15, 0xC1,
  0x10, 0x5C, 0x30, 0x5B, 0x03,
  // "Ë" (U+00CB)
  0x18, 0x1C, 0x1B, 0x60, 0x5B, 0x81, 0x35, 0xC3, 0x89, 0x25, 0xFE, 0xE1, 0x5C, 0x11, 0x05, 0xC3,
  0x05, 0xB0, 0x30,
  // "Ì" (U+00CC)
  0x10, 0x60, 0x33, 0x02, 0x0C, 0x20, 0x4B, 0x82, 0x10, 0x2E, 0x30, 0x20, 0xE3, 0x02, 0x0E, 0x30,
  0x20, 0xE2, 0x83, 0x3E, 0xFD, 0x10,
  // "Í" (U+00CD)
  0x20, 0x40, 0x52, 0x83, 0x1C, 0x20, 0x4B, 0x82, 0x10, 0x2E, 0x30, 0x20, 0xE3, 0x02, 0x0E, 0x30,
  0x20, 0xE2, 0x83, 0x3E, 0xFD, 0x10,
  // "Î" (U+00CE)
  0x18, 0x12, 0x71, 0x28, 0x3B, 0x79, 0x04, 0xB8, 0x21, 0x02, 0xE3, 0x02, 0x0E, 0x30, 0x20, 0xE3,
  0x02, 0x0E, 0x28, 0x33, 0xEF, 0xD1,
  // "Ï" (U+00CF)
  0x18, 0x1C, 0x1B, 0x60, 0x4B, 0x82, 0x10, 0x2E, 0x30, 0x20, 0xE3, 0x02, 0x0E, 0x30, 0x20, 0xE2,
  0x83, 0x3E, 0xFD, 0x10,
  // "Ð" (U+00D0)
  0x89, 0x09, 0xFE, 0x80, 0x98, 0x2E, 0x4A, 0x89, 0x75, 0xA7, 0xA8, 0x0A, 0x79, 0x83, 0xE3, 0x9F,
  0xE7, 0x10,
  // "Ñ" (U+00D1)
  0x18, 0xC0, 0xBD, 0x90, 0x9F, 0x19, 0x69, 0xD6, 0x96, 0x99, 0xB9, 0x69, 0x6D, 0x96, 0x96, 0x9D,
  0x69, 0x64, 0xF6,
  // "Ò" (U+00D2)
  0x10, 0x60, 0x33, 0x02, 0x0C, 0x28, 0xB3, 0x1B, 0xE9, 0x08, 0xB2, 0xD4, 0xB7, 0x0A, 0x7B, 0x70,
  0xA7, 0x8B, 0x1D, 0x41, 0xBE, 0x91,
  // "Ó" (U+00D3)
  0x20, 0x40, 0x52, 0x8B, 0x71, 0xC2, 0x01, 0xBE, 0x90, 0x8B, 0x2D, 0x4B, 0x70, 0xA7, 0xB7, 0x0A,
  0x78, 0xB1, 0xD4, 0x1B, 0xE9, 0x10,
  // "Ô" (U+00D4)
  0x18, 0x12, 0x71, 0x28, 0xB7, 0xB7, 0x90, 0x1B, 0xE9, 0x08, 0xB2, 0xD4, 0xB7, 0x0A, 0x7B, 0x70,
  0xA7, 0x8B, 0x1D, 0x41, 0xBE, 0x91,
  // "Õ" (U+00D5)
  0x18, 0xB7, 0xBD, 0x90, 0x1B, 0xE9, 0x08, 0xB2, 0xD4, 0xB7, 0x0A, 0x7B, 0x70, 0xA7, 0x8B, 0x1D,
  0x41, 0xBE, 0x91,
  // "Ö" (U+00D6)
  0x18, 0x1C, 0x1B, 0x68, 0xB3, 0x1B, 0xE9, 0x08, 0xB2, 0xD4, 0xB7, 0x0A, 0x7B, 0x70, 0xA7, 0x8B,
  0x1D, 0x41, 0xBE, 0x91,
  // "×" (U+00D7)
  0x18, 0x95, 0x40, 0x51, 0xCB, 0xA0, 0x8E, 0x52, 0x91, 0xA0,
  // "Ø" (U+00D8)
  0x8B, 0x51, 0xBE, 0xC7, 0x8B, 0x3F, 0x5B, 0x7A, 0xC8, 0xBC, 0x8A, 0x78, 0xE2, 0xD5, 0x9C, 0xE9,
  0x01, 0x40,
  // "Ù" (U+00D9)
  0x10, 0x60, 0x33, 0x02, 0x0C, 0x28, 0xB3, 0x98, 0x0B, 0x69, 0x80, 0xB6, 0x98, 0x0B, 0x69, 0x80,
  0xB6, 0x8B, 0x2D, 0x51, 0xCE, 0xA1,
  // "Ú" (U+00DA)
  0x20, 0x40, 0x52, 0x8B, 0x71, 0xC2, 0x09, 0x80, 0xB6, 0x98, 0x0B, 0x69, 0x80, 0xB6, 0x98, 0x0B,
  0x68, 0xB2, 0xD5, 0x1C, 0xEA, 0x10,
  // "Û" (U+00DB)
  0x18, 0x12, 0x71, 0x28, 0xB7, 0xB7, 0x90, 0x98, 0x0B, 0x69, 0x80, 0xB6, 0x98, 0x0B, 0x69, 0x80,
  0xB6, 0x8B, 0x2D, 0x51, 0xCE, 0xA1,
  // "Ü" (U+00DC)
  0x18, 0x1C, 0x1B, 0x68, 0xB3, 0x98, 0x0B, 0x69, 0x80, 0xB6, 0x98, 0x0B, 0x69, 0x80, 0xB6, 0x8B,
  0x2D, 0x51, 0xCE, 0xA1,
  // "Ý" (U+00DD)
  0x20, 0x40, 0x52, 0x89, 0x31, 0xC2, 0x09, 0x90, 0xC6, 0x2E, 0x3E, 0x28, 0x1B, 0xD8, 0x28, 0x14,
  0xF1, 0x20, 0x29, 0x30, 0x29, 0x20,
  // "Þ" (U+00DE)
  0x05, 0x0B, 0x38, 0x96, 0x5F, 0xEA, 0x05, 0xC2, 0xD6, 0x5B, 0x0C, 0x65, 0xA8, 0x3C, 0x15, 0xC1,
  0x20,
  // "ß" (U+00DF)
  0x8C, 0x11, 0xCE, 0x90, 0x7B, 0x3F, 0x08, 0x88, 0xA0, 0x88, 0xD5, 0x08, 0x85, 0xE3, 0x89, 0x2A,
  0x88, 0x9E, 0xE3,
  // "à" (U+00E0)
  0x10, 0x60, 0x33, 0x02, 0x0C, 0x28, 0x22, 0xDE, 0xA2, 0x8A, 0x13, 0x1E, 0x33, 0xCE, 0xF4, 0x8B,
  0x4E, 0x44, 0xEC, 0xC4,
  // "á" (U+00E1)
  0x20, 0x40, 0x52, 0x86, 0x1C, 0x20, 0x2D, 0xEA, 0x28, 0xA1, 0x31, 0xE3, 0x3C, 0xEF, 0x48, 0xB4,
  0xE4, 0x4E, 0xCC, 0x40,
  // "â" (U+00E2)
  0x18, 0x12, 0x71, 0x28, 0x6B, 0x79, 0x02, 0xDE, 0xA2, 0x8A, 0x13, 0x1E, 0x33, 0xCE, 0xF4, 0x8B,
  0x4E, 0x44, 0xEC, 0xC4,
  // "ã" (U+00E3)
  0x18, 0x6B, 0xD9, 0x02, 0xDE, 0xA2, 0x8A, 0x13, 0x1E, 0x33, 0xCE, 0xF4, 0x8B, 0x4E, 0x44, 0xEC,
  0xC4,
  // "ä" (U+00E4)
  0x18, 0x1C, 0x1B, 0x68, 0x22, 0xDE, 0xA2, 0x8A, 0x13, 0x1E, 0x33, 0xCE, 0xF4, 0x8B, 0x4E, 0x44,
  0xEC, 0xC4,
  // "å" (U+00E5)
  0x18, 0x14, 0xD2, 0x28, 0x66, 0xF3, 0x02, 0xDF, 0xA2, 0x8A, 0x13, 0x1E, 0x33, 0xCE, 0xF4, 0x8B,
  0x4E, 0x44, 0xEC, 0xC4,
  // "æ" (U+00E6)
  0x8A, 0x77, 0xEB, 0xE3, 0x13, 0xF6, 0x98, 0xEF, 0xEA, 0xD7, 0xF4, 0x29, 0xD7, 0xE6,
  // "ç" (U+00E7)
  0x18, 0x91, 0x9E, 0xD0, 0x4E, 0x22, 0x06, 0xB3, 0x82, 0x4E, 0x23, 0x20, 0xA0, 0xE9, 0x40, 0xB0,
  0x12, 0x81, 0x4B, 0x10,
  // "è" (U+00E8)
  0x10, 0x60, 0x33, 0x02, 0x0C, 0x38, 0xA6, 0xBE, 0x90, 0x6C, 0x1D, 0x38, 0xFE, 0xF6, 0x6C, 0x33,
  0x10, 0x9E, 0xE3,
  // "é" (U+00E9)
  0x20, 0x40, 0x52, 0x81, 0x1C, 0x22, 0x8A, 0x6B, 0xE9, 0x06, 0xC1, 0xD3, 0x8F, 0xEF, 0x66, 0xC3,
  0x31, 0x09, 0xEE, 0x30,
  // "ê" (U+00EA)
  0x18, 0x12, 0x71, 0x28, 0x1B, 0x79, 0x28, 0xA6, 0xBE, 0x90, 0x6C, 0x1D, 0x38, 0xFE, 0xF6, 0x6C,
  0x33, 0x10, 0x9E, 0xE3,
  // "ë" (U+00EB)
  0x18, 0x1C, 0x1B, 0x78, 0xA6, 0xBE, 0x90, 0x6C, 0x1D, 0x38, 0xFE, 0xF6, 0x6C, 0x33, 0x10, 0x9E,
  0xE3,
  // "ì" (U+00EC)
  0x10, 0x60, 0x33, 0x02, 0x0C, 0x20, 0x4A, 0x01, 0x28, 0x11, 0xF1, 0x28, 0x11, 0xF1, 0x28, 0x31,
  0xF1, 0x06, 0xB0, 0x50,
  // "í" (U+00ED)
  0x20, 0x40, 0x52, 0x83, 0x1C, 0x20, 0x4A, 0x01, 0x28, 0x11, 0xF1, 0x28, 0x11, 0xF1, 0x28, 0x31,
  0xF1, 0x06, 0xB0, 0x50,
  // "î" (U+00EE)
  0x18, 0x12, 0x71, 0x28, 0x3B, 0x79, 0x04, 0xA0, 0x12, 0x81, 0x1F, 0x12, 0x81, 0x1F, 0x12, 0x83,
  0x1F, 0x10, 0x6B, 0x05,
  // "ï" (U+00EF)
  0x18, 0x1C, 0x1B, 0x60, 0x4A, 0x01, 0x28, 0x11, 0xF1, 0x28, 0x11, 0xF1, 0x28, 0x31, 0xF1, 0x06,
  0xB0, 0x50,
  // "ð" (U+00F0)
  0x18, 0x12, 0x13, 0x28, 0x16, 0xE9, 0x28, 0xB2, 0x77, 0xC0, 0x1B, 0xDE, 0x37, 0xB2, 0xE6, 0xA8,
  0x0B, 0x68, 0xB1, 0xD3, 0x0B, 0xE8, 0x10,
  // "ñ" (U+00F1)
  0x18, 0xB3, 0xBD, 0x90, 0x8A, 0xEC, 0x18, 0xD1, 0xD5, 0x89, 0x0B, 0x68, 0x90, 0xB6, 0x89, 0x0B,
  0x60,
  // "ò" (U+00F2)
  0x10, 0x60, 0x33, 0x02, 0x0C, 0x38, 0xA5, 0xBE, 0x90, 0x7B, 0x1D, 0x49, 0x80, 0xB6, 0x7B, 0x1D,
  0x40, 0xBF, 0x91,
  // "ó" (U+00F3)
  0x20, 0x40, 0x52, 0x81, 0x1C, 0x22, 0x8A, 0x5B, 0xE9, 0x07, 0xB1, 0xD4, 0x98, 0x0B, 0x67, 0xB1,
  0xD4, 0x0B, 0xF9, 0x10,
  // "ô" (U+00F4)
  0x18, 0x12, 0x71, 0x28, 0x1B, 0x79, 0x28, 0xA5, 0xBE, 0x90, 0x7B, 0x1D, 0x49, 0x80, 0xB6, 0x7B,
  0x1D, 0x40, 0xBF, 0x91,
  // "õ" (U+00F5)
  0x18, 0x1B, 0xD9, 0x28, 0xA5, 0xBE, 0x90, 0x7B, 0x1D, 0x49, 0x80, 0xB6, 0x7B, 0x1D, 0x40, 0xBF,
  0x91,
  // "ö" (U+00F6)
  0x18, 0x1C, 0x1B, 0x78, 0xA5, 0xBE, 0x90, 0x7B, 0x1D, 0x49, 0x80, 0xB6, 0x7B, 0x1D, 0x40, 0xBF,
  0x91,
  // "÷" (U+00F7)
  0x20, 0xB2, 0x83, 0x6E, 0xEE, 0x31, 0x0F, 0x13, 0x0B, 0x20,
  // "ø" (U+00F8)
  0x18, 0xA5, 0xBE, 0xD1, 0x7B, 0x7F, 0x4A, 0x9B, 0xB6, 0x7F, 0x5D, 0x43, 0xEE, 0x91,
  // "ù" (U+00F9)
  0x10, 0x60, 0x33, 0x02, 0x0C, 0x28, 0xA7, 0x98, 0x0C, 0x59, 0x80, 0xC5, 0x98, 0x0C, 0x58, 0xB2,
  0xE5, 0x3E, 0xCB, 0x50,
  // "ú" (U+00FA)
  0x20, 0x40, 0x52, 0x8B, 0x31, 0xC2, 0x09, 0x80, 0xC5, 0x98, 0x0C, 0x59, 0x80, 0xC5, 0x8B, 0x2E,
  0x53, 0xEC, 0xB5,
  // "û" (U+00FB)
  0x18, 0x12, 0x71, 0x28, 0xB3, 0xB7, 0x90, 0x98, 0x0C, 0x59, 0x80, 0xC5, 0x98, 0x0C, 0x58, 0xB2,
  0xE5, 0x3E, 0xCB, 0x50,
  // "ü" (U+00FC)
  0x18, 0x1C, 0x1B, 0x68, 0xA7, 0x98, 0x0C, 0x59, 0x80, 0xC5, 0x98, 0x0C, 0x58, 0xB2, 0xE5, 0x3E,
  0xCB, 0x50,
  // "ý" (U+00FD)
  0x20, 0x40, 0x52, 0x8A, 0x01, 0xC2, 0x0A, 0x80, 0xB7, 0x4D, 0x0F, 0x20, 0xE7, 0xC2, 0x81, 0x9E,
  0x72, 0x85, 0x3F, 0x20, 0x18, 0xC2, 0x81, 0x8D, 0x32,
  // "þ" (U+00FE)
  0x08, 0x09, 0x30, 0x08, 0x38, 0xB1, 0x8B, 0xDC, 0x08, 0xC1, 0xD5, 0x89, 0x0B, 0x78, 0xC1, 0xD5,
  0x8C, 0xEB, 0x08, 0x83, 0x08, 0x09, 0x30,
  // "ÿ" (U+00FF)
  0x18, 0x1C, 0x1B, 0x68, 0x94, 0xA8, 0x0B, 0x74, 0xD0, 0xF2, 0x0E, 0x7C, 0x28, 0x19, 0xE7, 0x28,
  0x53, 0xF2, 0x01, 0x8C, 0x28, 0x18, 0xD3, 0x20,
  // "Ā" (U+0100)
  0x18, 0x1B, 0xE8, 0x20, 0xF1, 0x28, 0x17, 0xF4, 0x28, 0x1B, 0xA8, 0x28, 0xA1, 0xE2, 0xC0, 0x4F,
  0xEF, 0x18, 0x81, 0xB5, 0xC4, 0x08, 0x90,
  // "ā" (U+0101)
  0x18, 0x1B, 0xE8, 0x20, 0xF1, 0x18, 0x22, 0xDE, 0xA2, 0x8A, 0x13, 0x1E, 0x33, 0xCE, 0xF4, 0x8B,
  0x4E, 0x44, 0xEC, 0xC4,
  // "Ă" (U+0102)
  0x18, 0x14, 0x04, 0x28, 0x19, 0xF7, 0x28, 0x17, 0xF4, 0x28, 0x1B, 0xA8, 0x28, 0xA1, 0xE2, 0xC0,
  0x4F, 0xEF, 0x18, 0x81, 0xB5, 0xC4, 0x08, 0x90,
  // "ă" (U+0103)
  0x18, 0x14, 0x04, 0x28, 0x69, 0xF7, 0x02, 0xDF, 0xA2, 0x8A, 0x13, 0x1E, 0x33, 0xCE, 0xF4, 0x8B,
  0x4E, 0x44, 0xEC, 0xC4,
  // "Ą" (U+0104)
  0x18, 0x17, 0xF4, 0x38, 0x1B, 0xA8, 0x38, 0x1E, 0x2C, 0x28, 0x97, 0x4F, 0xEF, 0x10, 0x88, 0x1B,
  0x50, 0xC4, 0x08, 0xC4, 0x02, 0x09, 0x48, 0x12, 0xF3, 0x40, 0x11,
  // "ą" (U+0105)
  0x82, 0x2D, 0xEA, 0x28, 0xA1, 0x31, 0xE3, 0x3C, 0xEF, 0x48, 0xB4, 0xE4, 0x4E, 0xCF, 0x42, 0x02,
  0x09, 0x38, 0x12, 0xF3, 0x30, 0x11,
  // "Ć" (U+0106)
  0x30, 0x40, 0x52, 0x89, 0x51, 0xC2, 0x07, 0xEE, 0x44, 0xE3, 0x20, 0x8A, 0x30, 0x80, 0x93, 0x89,
  0x05, 0xD2, 0x11, 0x09, 0xEE, 0x20,
  // "ć" (U+0107)
  0x30, 0x40, 0x52, 0x89, 0x51, 0xC2, 0x09, 0xED, 0x04, 0xE2, 0x20, 0x6B, 0x38, 0x24, 0xE2, 0x32,
  0x81, 0xAE, 0xD1,
  // "Ĉ" (U+0108)
  0x28, 0x12, 0x71, 0x28, 0x95, 0xB7, 0x90, 0x7E, 0xE4, 0x4E, 0x32, 0x08, 0xA3, 0x08, 0x09, 0x38,
  0x90, 0x5D, 0x21, 0x10, 0x9E, 0xE2,
  // "ĉ" (U+0109)
  0x28, 0x12, 0x71, 0x28, 0x95, 0xB7, 0x90, 0x9E, 0xD0, 0x4E, 0x22, 0x06, 0xB3, 0x82, 0x4E, 0x23,
  0x28, 0x1A, 0xED, 0x10,
  // "Ċ" (U+010A)
  0x20, 0x20, 0xD7, 0x89, 0x17, 0xEE, 0x44, 0xE3, 0x20, 0x8A, 0x30, 0x80, 0x93, 0x89, 0x05, 0xD2,
  0x11, 0x09, 0xEE, 0x20,
  // "ċ" (U+010B)
  0x20, 0x20, 0xD5, 0x87, 0x9E, 0xD4, 0xE2, 0x26, 0xB2, 0x86, 0x4E, 0x23, 0x0A, 0xED,
  // "Č" (U+010C)
  0x28, 0x16, 0x15, 0x28, 0x95, 0x7E, 0x40, 0x7E, 0xE4, 0x4E, 0x32, 0x08, 0xA3, 0x08, 0x09, 0x38,
  0x90, 0x5D, 0x21, 0x10, 0x9E, 0xE2,
  // "č" (U+010D)
  0x28, 0x16, 0x15, 0x28, 0x95, 0x7E, 0x40, 0x9E, 0xD0, 0x4E, 0x22, 0x06, 0xB3, 0x82, 0x4E, 0x23,
  0x28, 0x1A, 0xED, 0x10,
  // "Ď" (U+010E)
  0x18, 0x16, 0x15, 0x28, 0xB7, 0x7E, 0x40, 0x9F, 0xE8, 0x09, 0x82, 0xE4, 0x97, 0x0A, 0x79, 0x70,
  0xA7, 0x98, 0x3E, 0x39, 0xFE, 0x71,
  // "ď" (U+010F)
  0x28, 0x22, 0xEB, 0x22, 0x02, 0x0E, 0x28, 0x23, 0xEB, 0xE2, 0x82, 0x99, 0x5E, 0x28, 0x2B, 0x61,
  0xE2, 0x82, 0x99, 0x5E, 0x28, 0x23, 0xEA, 0xE2,
  // "Đ" (U+0110)
  0x89, 0x09, 0xFE, 0x80, 0x98, 0x2E, 0x4A, 0x89, 0x75, 0xA7, 0xA8, 0x0A, 0x79, 0x83, 0xE3, 0x9F,
  0xE7, 0x10,
  // "đ" (U+0111)
  0x30, 0xC0, 0x52, 0x8B, 0x2D, 0xFB, 0x2D, 0xDD, 0x58, 0xB1, 0xD5, 0xA8, 0x0B, 0x58, 0xB1, 0xD5,
  0x1D, 0xCB, 0x50,
  // "Ē" (U+0112)
  0x18, 0x1B, 0xE8, 0x20, 0xF1, 0x10, 0x5B, 0x81, 0x35, 0xC3, 0x89, 0x25, 0xFE, 0xE1, 0x5C, 0x11,
  0x05, 0xC3, 0x05, 0xB0, 0x30,
  // "ē" (U+0113)
  0x18, 0x1B, 0xE8, 0x20, 0xF1, 0x28, 0xA6, 0xBE, 0x90, 0x6C, 0x1D, 0x38, 0xFE, 0xF6, 0x6C, 0x33,
  0x10, 0x9E, 0xE3,
  // "Ĕ" (U+0114)
  0x18, 0x14, 0x04, 0x28, 0x39, 0xF7, 0x05, 0xB8, 0x13, 0x5C, 0x38, 0x92, 0x5F, 0xEE, 0x15, 0xC1,
  0x10, 0x5C, 0x30, 0x5B, 0x03,
  // "ĕ" (U+0115)
  0x18, 0x14, 0x04, 0x28, 0x19, 0xF7, 0x28, 0xA6, 0xBF, 0x90, 0x6C, 0x1D, 0x38, 0xFE, 0xF6, 0x6C,
  0x33, 0x10, 0x9E, 0xE3,
  // "Ė" (U+0116)
  0x10, 0x20, 0xD7, 0x05, 0xB8, 0x13, 0x5C, 0x38, 0x92, 0x5F, 0xEE, 0x15, 0xC1, 0x10, 0x5C, 0x30,
  0x5B, 0x03,
  // "ė" (U+0117)
  0x10, 0x20, 0xD7, 0x18, 0xA6, 0xBE, 0x90, 0x6C, 0x1D, 0x38, 0xFE, 0xF6, 0x6C, 0x33, 0x10, 0x9E,
  0xE3,
  // "Ę" (U+0118)
  0x05, 0xB8, 0x13, 0x5C, 0x38, 0x92, 0x5F, 0xEE, 0x15, 0xC1, 0x10, 0x5C, 0x30, 0x5B, 0x03, 0x20,
  0x20, 0x93, 0x81, 0x2F, 0x33, 0x01, 0x10,
  // "ę" (U+0119)
  0x18, 0xA6, 0xBE, 0x90, 0x6C, 0x1D, 0x38, 0xFE, 0xF6, 0x6C, 0x33, 0x10, 0x9E, 0xF3, 0x20, 0x20,
  0x93, 0x81, 0x2E, 0x20,
  // "Ě" (U+011A)
  0x18, 0x16, 0x15, 0x28, 0x37, 0xE4, 0x05, 0xB8, 0x13, 0x5C, 0x38, 0x92, 0x5F, 0xEE, 0x15, 0xC1,
  0x10, 0x5C, 0x30, 0x5B, 0x03,
  // "ě" (U+011B)
  0x18, 0x16, 0x15, 0x28, 0x17, 0xE4, 0x28, 0xA6, 0xBE, 0x90, 0x6C, 0x1D, 0x38, 0xFE, 0xF6, 0x6C,
  0x33, 0x10, 0x9E, 0xE3,
  // "Ĝ" (U+011C)
  0x28, 0x12, 0x71, 0x28, 0xB7, 0xB7, 0x90, 0x9E, 0xD2, 0x6D, 0x21, 0x0A, 0x75, 0xE6, 0xB7, 0x0A,
  0x67, 0xC1, 0xA6, 0x0A, 0xEE, 0x50,
  // "ĝ" (U+011D)
  0x18, 0x12, 0x71, 0x28, 0xC4, 0xB7, 0x90, 0x2D, 0xCB, 0x58, 0xB1, 0xE5, 0xA8, 0x0B, 0x58, 0xB1,
  0xD5, 0x2D, 0xDD, 0x51, 0x21, 0xE3, 0x4E, 0xE9, 0x10,
  // "Ğ" (U+011E)
  0x28, 0x14, 0x04, 0x28, 0xB7, 0x9F, 0x70, 0x9E, 0xE2, 0x6D, 0x21, 0x0A, 0x75, 0xE6, 0xB7, 0x0A,
  0x67, 0xC1, 0xA6, 0x0A, 0xEE, 0x50,
  // "ğ" (U+011F)
  0x18, 0x14, 0x04, 0x28, 0xC4, 0x9F, 0x70, 0x2D, 0xDB, 0x58, 0xB1, 0xE5, 0xA8, 0x0B, 0x58, 0xB1,
  0xD5, 0x2D, 0xDD, 0x51, 0x21, 0xE3, 0x4E, 0xE9, 0x10,
  // "Ġ" (U+0120)
  0x20, 0x20, 0xD7, 0x8B, 0x39, 0xED, 0x26, 0xD2, 0x10, 0xA7, 0x5E, 0x6B, 0x70, 0xA6, 0x7C, 0x1A,
  0x60, 0xAE, 0xE5,
  // "ġ" (U+0121)
  0x10, 0x20, 0xD7, 0x8C, 0x02, 0xDC, 0xB5, 0x8B, 0x1E, 0x5A, 0x80, 0xB5, 0x8B, 0x1D, 0x52, 0xDD,
  0xD5, 0x12, 0x1E, 0x34, 0xEE, 0x91,
  // "Ģ" (U+0122)
  0x18, 0xB3, 0x9E, 0xD2, 0x6D, 0x21, 0x0A, 0x75, 0xE6, 0xB7, 0x0A, 0x67, 0xC1, 0xA6, 0x0A, 0xEE,
  0x57, 0x09, 0x03, 0x30, 0x12,
  // "ģ" (U+0123)
  0x20, 0xC7, 0x8C, 0x02, 0xDC, 0xB5, 0x8B, 0x1E, 0x5A, 0x80, 0xB5, 0x8B, 0x1D, 0x52, 0xDD, 0xD5,
  0x12, 0x1E, 0x34, 0xEE, 0x91,
  // "Ĥ" (U+0124)
  0x18, 0x12, 0x71, 0x28, 0xC0, 0xB7, 0x90, 0x98, 0x0B, 0x69, 0x80, 0xB6, 0x9F, 0xEF, 0x69, 0x81,
  0xB6, 0x98, 0x0B, 0x69, 0x80, 0xB6,
  // "ĥ" (U+0125)
  0x81, 0x27, 0x12, 0x81, 0xB7, 0x92, 0x08, 0x09, 0x30, 0x80, 0x93, 0x8A, 0x78, 0xCD, 0xC1, 0x8C,
  0x2D, 0x58, 0x90, 0xB6, 0x89, 0x0B, 0x68, 0x90, 0xB6,
  // "Ħ" (U+0126)
  0xA8, 0xB2, 0xEF, 0xB9, 0xA1, 0xC6, 0x8F, 0xEF, 0x58, 0xA1, 0xC5, 0x89, 0x0C, 0x58, 0x90, 0xC5,
  // "ħ" (U+0127)
  0x08, 0x09, 0x3A, 0x0B, 0x28, 0xA7, 0x8C, 0xDC, 0x18, 0xC2, 0xD5, 0x89, 0x0B, 0x68, 0x90, 0xB6,
  0x89, 0x0B, 0x60,
  // "Ĩ" (U+0128)
  0x18, 0x3B, 0xD9, 0x04, 0xB8, 0x21, 0x02, 0xE3, 0x02, 0x0E, 0x30, 0x20, 0xE3, 0x02, 0x0E, 0x28,
  0x33, 0xEF, 0xD1,
  // "ĩ" (U+0129)
  0x18, 0x3B, 0xD9, 0x04, 0xA0, 0x12, 0x81, 0x1F, 0x12, 0x81, 0x1F, 0x12, 0x83, 0x1F, 0x10, 0x6B,
  0x05,
  // "Ī" (U+012A)
  0x18, 0x1B, 0xE8, 0x20, 0xF1, 0x10, 0x4B, 0x82, 0x10, 0x2E, 0x30, 0x20, 0xE3, 0x02, 0x0E, 0x30,
  0x20, 0xE2, 0x83, 0x3E, 0xFD, 0x10,
  // "ī" (U+012B)
  0x18, 0x1B, 0xE8, 0x20, 0xF1, 0x10, 0x4A, 0x01, 0x28, 0x11, 0xF1, 0x28, 0x11, 0xF1, 0x28, 0x31,
  0xF1, 0x06, 0xB0, 0x50,
  // "Ĭ" (U+012C)
  0x18, 0x14, 0x04, 0x28, 0x39, 0xF7, 0x04, 0xB8, 0x21, 0x02, 0xE3, 0x02, 0x0E, 0x30, 0x20, 0xE3,
  0x02, 0x0E, 0x28, 0x33, 0xEF, 0xD1,
  // "ĭ" (U+012D)
  0x18, 0x14, 0x04, 0x28, 0x39, 0xF7, 0x04, 0xA0, 0x12, 0x81, 0x1F, 0x12, 0x81, 0x1F, 0x12, 0x83,
  0x1F, 0x10, 0x6B, 0x05,
  // "Į" (U+012E)
  0x04, 0xB8, 0x21, 0x02, 0xE3, 0x02, 0x0E, 0x30, 0x20, 0xE3, 0x02, 0x0E, 0x28, 0x63, 0xEF, 0xD1,
  0x02, 0x93, 0x81, 0x2F, 0x33, 0x01, 0x20,
  // "į" (U+012F)
  0x18, 0x11, 0xE1, 0x60, 0x4A, 0x01, 0x28, 0x11, 0xF1, 0x28, 0x11, 0xF1, 0x28, 0x31, 0xF1, 0x06,
  0xB0, 0x52, 0x02, 0x09, 0x38, 0x12, 0xF3, 0x30, 0x11,
  // "İ" (U+0130)
  0x10, 0x20, 0xD7, 0x04, 0xB8, 0x21, 0x02, 0xE3, 0x02, 0x0E, 0x30, 0x20, 0xE3, 0x02, 0x0E, 0x28,
  0x33, 0xEF, 0xD1,
  // "ı" (U+0131)
  0x04, 0xA0, 0x12, 0x81, 0x1F, 0x12, 0x81, 0x1F, 0x12, 0x83, 0x1F, 0x10, 0x6B, 0x05,
  // "Ĳ" (U+0132)
  0x8B, 0x34, 0xC0, 0xF1, 0x4C, 0x0F, 0x14, 0xC0, 0xF1, 0x4C, 0x0F, 0x11, 0x24, 0xF0, 0x4F, 0xE7,
  0x10,
  // "ĳ" (U+0133)
  0x83, 0x4D, 0x1E, 0x15, 0x8B, 0x24, 0xD1, 0xF1, 0x4D, 0x1F, 0x14, 0xD1, 0xF1, 0x4D, 0x1F, 0x14,
  0xD1, 0xF1, 0x02, 0x59, 0x28, 0x1E, 0xE7, 0x10,
  // "Ĵ" (U+0134)
  0x28, 0x12, 0x71, 0x28, 0x1B, 0x79, 0x20, 0x30, 0xE3, 0x03, 0x0E, 0x30, 0x30, 0xE3, 0x89, 0x23,
  0xE0, 0x11, 0x7C, 0x04, 0xFE, 0x51,
  // "ĵ" (U+0135)
  0x28, 0x12, 0x71, 0x28, 0x5B, 0x79, 0x0E, 0xF6, 0x30, 0xB0, 0x63, 0x0B, 0x06, 0x30, 0xB0, 0x63,
  0x89, 0x1B, 0x60, 0x22, 0xD5, 0x09, 0xFB, 0x20,
  // "Ķ" (U+0136)
  0x89, 0x39, 0x71, 0xE3, 0x97, 0xA8, 0x09, 0xBD, 0x28, 0x95, 0x9E, 0xE2, 0x09, 0x78, 0xA0, 0x97,
  0x1E, 0x36, 0x09, 0x03, 0x30, 0x13,
  // "ķ" (U+0137)
  0x08, 0x09, 0x30, 0x80, 0x93, 0x89, 0x18, 0x92, 0xE3, 0x8A, 0xC6, 0x08, 0xA8, 0x92, 0x30, 0x8B,
  0x6C, 0x08, 0x90, 0xC6, 0x70, 0x90, 0x33, 0x01, 0x20,
  // "ĸ" (U+0138)
  0x89, 0x18, 0x92, 0xE3, 0x8A, 0xC6, 0x08, 0xA8, 0x92, 0x30, 0x8B, 0x6C, 0x08, 0x90, 0xC6,
  // "Ĺ" (U+0139)
  0x10, 0x40, 0x52, 0x81, 0x1C, 0x22, 0x04, 0x0D, 0x30, 0x40, 0xD3, 0x04, 0x0D, 0x30, 0x40, 0xD3,
  0x84, 0x4D, 0x22, 0x04, 0xB0, 0x30,
  // "ĺ" (U+013A)
  0x20, 0x40, 0x52, 0x83, 0x1C, 0x20, 0x3A, 0x01, 0x28, 0x12, 0xF1, 0x28, 0x11, 0xF1, 0x28, 0x11,
  0xF1, 0x28, 0x11, 0xF1, 0x28, 0x31, 0xF1, 0x06, 0xB0, 0x50,
  // "Ļ" (U+013B)
  0x04, 0x0D, 0x30, 0x40, 0xD3, 0x04, 0x0D, 0x30, 0x40, 0xD3, 0x84, 0x4D, 0x22, 0x04, 0xB0, 0x37,
  0x09, 0x03, 0x30, 0x12,
  // "ļ" (U+013C)
  0x03, 0xA0, 0x12, 0x81, 0x2F, 0x12, 0x81, 0x1F, 0x12, 0x81, 0x1F, 0x12, 0x81, 0x1F, 0x12, 0x83,
  0x1F, 0x10, 0x6B, 0x05, 0x70, 0x90, 0x33, 0x01, 0x20,
  // "Ľ" (U+013D)
  0x85, 0x4D, 0x0D, 0x04, 0xD3, 0x04, 0x0D, 0x30, 0x40, 0xD3, 0x84, 0x4D, 0x22, 0x04, 0xB0, 0x30,
  // "ľ" (U+013E)
  0x87, 0x2B, 0xF7, 0x70, 0x1F, 0x12, 0x81, 0x1F, 0x12, 0x81, 0x1F, 0x12, 0x81, 0x1F, 0x12, 0x83,
  0x2F, 0x20, 0x7B, 0x05,
  // "Ŀ" (U+013F)
  0x04, 0x0D, 0x30, 0x40, 0xD3, 0x04, 0x0D, 0x38, 0x91, 0x4D, 0x2D, 0x04, 0xD2, 0x20, 0x4B, 0x03,
  // "ŀ" (U+0140)
  0x03, 0xA0, 0x12, 0x81, 0x2F, 0x12, 0x81, 0x1F, 0x12, 0x81, 0x1F, 0x12, 0x89, 0x01, 0xF4, 0xD0,
  0x1F, 0x10, 0x6B, 0x05,
  // "Ł" (U+0141)
  0x10, 0xE0, 0x33, 0x0E, 0x04, 0x38, 0x5E, 0xD1, 0x07, 0xF3, 0x38, 0x4E, 0x52, 0x10, 0xEA, 0x08,
  // "ł" (U+0142)
  0x03, 0xA0, 0x12, 0x81, 0x2F, 0x12, 0x81, 0x1F, 0x62, 0x81, 0x3F, 0x92, 0x81, 0xCF, 0x12, 0x83,
  0x1F, 0x10, 0x6B, 0x05,
  // "Ń" (U+0143)
  0x20, 0x40, 0x52, 0x8C, 0x01, 0xC2, 0x09, 0xF1, 0x96, 0x9D, 0x69, 0x69, 0x9B, 0x96, 0x96, 0xD9,
  0x69, 0x69, 0xD6, 0x96, 0x4F, 0x60,
  // "ń" (U+0144)
  0x20, 0x40, 0x52, 0x8B, 0x31, 0xC2, 0x08, 0xAE, 0xC1, 0x8D, 0x1D, 0x58, 0x90, 0xB6, 0x89, 0x0B,
  0x68, 0x90, 0xB6,
  // "Ņ" (U+0145)
  0x8B, 0x49, 0xF1, 0x96, 0x9D, 0x69, 0x69, 0x9B, 0x96, 0x96, 0xD9, 0x69, 0x69, 0xD6, 0x96, 0x4F,
  0x66, 0x09, 0x03, 0x30, 0x13,
  // "ņ" (U+0146)
  0x8A, 0x78, 0xAE, 0xC1, 0x8D, 0x1D, 0x58, 0x90, 0xB6, 0x89, 0x0B, 0x68, 0x90, 0xB6, 0x60, 0x90,
  0x33, 0x01, 0x30,
  // "Ň" (U+0147)
  0x18, 0x16, 0x15, 0x28, 0xC0, 0x7E, 0x40, 0x9F, 0x19, 0x69, 0xD6, 0x96, 0x99, 0xB9, 0x69, 0x6D,
  0x96, 0x96, 0x9D, 0x69, 0x64, 0xF6,
  // "ň" (U+0148)
  0x18, 0x16, 0x15, 0x28, 0xB3, 0x7E, 0x40, 0x8A, 0xEC, 0x18, 0xD1, 0xD5, 0x89, 0x0B, 0x68, 0x90,
  0xB6, 0x89, 0x0B, 0x60,
  // "ŉ" (U+0149)
  0x09, 0x07, 0x48, 0xB4, 0xCA, 0x9D, 0xD1, 0x27, 0xD2, 0xD5, 0x07, 0xA0, 0xB6, 0x07, 0xA0, 0xB6,
  0x07, 0xA0, 0xB6,
  // "Ŋ" (U+014A)
  0x8B, 0x49, 0xF1, 0x96, 0x9D, 0x69, 0x69, 0x9B, 0x96, 0x96, 0xD9, 0x69, 0x69, 0xD6, 0x96, 0x4F,
  0x63, 0x85, 0xA6, 0x01, 0xFD, 0x12, 0x01, 0x20,
  // "ŋ" (U+014B)
  0x8A, 0x78, 0xAE, 0xC1, 0x8D, 0x2D, 0x58, 0x90, 0xB6, 0x89, 0x0B, 0x68, 0x90, 0xB6, 0x30, 0xD0,
  0x52, 0x81, 0xAD, 0x10,
  // "Ō" (U+014C)
  0x18, 0x1B, 0xE8, 0x20, 0xF1, 0x18, 0xB3, 0x1B, 0xE9, 0x08, 0xB2, 0xD4, 0xB7, 0x0A, 0x7B, 0x70,
  0xA7, 0x8B, 0x1D, 0x41, 0xBE, 0x91,
  // "ō" (U+014D)
  0x18, 0x1B, 0xE8, 0x20, 0xF1, 0x28, 0xA5, 0xBE, 0x90, 0x7B, 0x1D, 0x49, 0x80, 0xB6, 0x7B, 0x1D,
  0x40, 0xBF, 0x91,
  // "Ŏ" (U+014E)
  0x18, 0x14, 0x04, 0x28, 0xB7, 0x9F, 0x70, 0x1B, 0xF9, 0x08, 0xB2, 0xD4, 0xB7, 0x0A, 0x7B, 0x70,
  0xA7, 0x8B, 0x1D, 0x41, 0xBE, 0x91,
  // "ŏ" (U+014F)
  0x18, 0x14, 0x04, 0x28, 0x19, 0xF7, 0x28, 0xA5, 0xBF, 0x90, 0x7B, 0x1D, 0x49, 0x80, 0xB6, 0x7B,
  0x1D, 0x40, 0xBF, 0x91,
  // "Ő" (U+0150)
  0x18, 0x19, 0x89, 0x30, 0x12, 0x8B, 0x31, 0xBE, 0x90, 0x8B, 0x2D, 0x4B, 0x70, 0xA7, 0xB7, 0x0A,
  0x78, 0xB1, 0xD4, 0x1B, 0xE9, 0x10,
  // "ő" (U+0151)
  0x18, 0x19, 0x89, 0x30, 0x13, 0x8A, 0x5B, 0xE9, 0x07, 0xB1, 0xD4, 0x98, 0x0B, 0x67, 0xB1, 0xD4,
  0x0B, 0xF9, 0x10,
  // "Œ" (U+0152)
  0x02, 0x0D, 0xA8, 0xA5, 0x99, 0xA8, 0x80, 0xB6, 0x8F, 0x7B, 0x68, 0x90, 0x99, 0x88, 0x02, 0xDA,
  0x09,
  // "œ" (U+0153)
  0x8A, 0x75, 0xE8, 0xE4, 0xB5, 0xF5, 0x9C, 0x1F, 0xEB, 0xB5, 0xF4, 0x24, 0xE8, 0xE7,
  // "Ŕ" (U+0154)
  0x20, 0x40, 0x52, 0x89, 0x51, 0xC2, 0x05, 0xFE, 0xA0, 0x5C, 0x2F, 0x35, 0xA8, 0x97, 0xA0, 0x5C,
  0x99, 0x05, 0xC2, 0xE1, 0x5C, 0x0B, 0x70,
  // "ŕ" (U+0155)
  0x30, 0x40, 0x52, 0x89, 0x21, 0xC2, 0x6F, 0xAD, 0x80, 0x8D, 0x22, 0x08, 0x09, 0x30, 0x80, 0xA2,
  0x09, 0xA0, 0xA1,
  // "Ŗ" (U+0156)
  0x89, 0x15, 0xFE, 0xA0, 0x5C, 0x2F, 0x35, 0xA8, 0x97, 0xA0, 0x5C, 0x99, 0x05, 0xC2, 0xE1, 0x5C,
  0x0B, 0x77, 0x09, 0x03, 0x30, 0x12,
  // "ŗ" (U+0157)
  0x87, 0x6F, 0xAD, 0x80, 0x8D, 0x22, 0x08, 0x09, 0x30, 0x80, 0xA2, 0x09, 0xA0, 0xA7, 0x09, 0x03,
  0x30, 0x13,
  // "Ř" (U+0158)
  0x18, 0x16, 0x15, 0x28, 0x95, 0x7E, 0x40, 0x5F, 0xEA, 0x05, 0xC2, 0xF3, 0x5A, 0x89, 0x7A, 0x05,
  0xC9, 0x90, 0x5C, 0x2E, 0x15, 0xC0, 0xB7,
  // "ř" (U+0159)
  0x28, 0x16, 0x15, 0x28, 0x92, 0x7E, 0x46, 0xFA, 0xD8, 0x08, 0xD2, 0x20, 0x80, 0x93, 0x08, 0x0A,
  0x20, 0x9A, 0x0A, 0x10,
  // "Ś" (U+015A)
  0x30, 0x40, 0x52, 0x89, 0x71, 0xC2, 0x0B, 0xFD, 0x14, 0xE1, 0x30, 0x1D, 0x91, 0x28, 0x93, 0x18,
  0xE1, 0x22, 0x1E, 0x44, 0xEE, 0xA1,
  // "ś" (U+015B)
  0x20, 0x40, 0x52, 0x89, 0x31, 0xC2, 0x01, 0xBF, 0xC0, 0x4F, 0x33, 0x28, 0x93, 0x9F, 0x80, 0x22,
  0x4F, 0x14, 0xEF, 0xA1,
  // "Ŝ" (U+015C)
  0x28, 0x12, 0x71, 0x28, 0x97, 0xB7, 0x90, 0xBF, 0xD1, 0x4E, 0x13, 0x01, 0xD9, 0x12, 0x89, 0x31,
  0x8E, 0x12, 0x21, 0xE4, 0x4E, 0xEA, 0x10,
  // "ŝ" (U+015D)
  0x18, 0x12, 0x71, 0x28, 0x93, 0xB7, 0x90, 0x1B, 0xFC, 0x04, 0xF3, 0x32, 0x89, 0x39, 0xF8, 0x02,
  0x24, 0xF1, 0x4E, 0xFA, 0x10,
  // "Ş" (U+015E)
  0x18, 0x93, 0xBF, 0xD1, 0x4E, 0x13, 0x01, 0xD9, 0x12, 0x89, 0x31, 0x8E, 0x12, 0x21, 0xE4, 0x4E,
  0xFA, 0x30, 0xB0, 0x12, 0x81, 0x4B, 0x11,
  // "ş" (U+015F)
  0x87, 0x1B, 0xFC, 0x04, 0xF3, 0x32, 0x89, 0x39, 0xF8, 0x02, 0x24, 0xF1, 0x4E, 0xFA, 0x30, 0xB0,
  0x12, 0x81, 0x4B, 0x11,
  // "Š" (U+0160)
  0x28, 0x16, 0x15, 0x28, 0x97, 0x7E, 0x40, 0xBF, 0xD1, 0x4E, 0x13, 0x01, 0xD9, 0x12, 0x89, 0x31,
  0x8E, 0x12, 0x21, 0xE4, 0x4E, 0xEA, 0x10,
  // "š" (U+0161)
  0x18, 0x16, 0x15, 0x28, 0x93, 0x7E, 0x40, 0x1B, 0xFC, 0x04, 0xF3, 0x32, 0x89, 0x39, 0xF8, 0x02,
  0x24, 0xF1, 0x4E, 0xFA, 0x10,
  // "Ţ" (U+0162)
  0x0B, 0xB8, 0x18, 0x03, 0x93, 0x02, 0x93, 0x02, 0x93, 0x02, 0x93, 0x02, 0x94, 0x0B, 0x01, 0x28,
  0x14, 0xB1, 0x10,
  // "ţ" (U+0163)
  0x10, 0x60, 0x92, 0x07, 0x0E, 0xA8, 0x33, 0x09, 0x91, 0x20, 0x09, 0x38, 0x18, 0xB1, 0x28, 0x23,
  0xDF, 0x33, 0x0B, 0x01, 0x28, 0x14, 0xB1,
  // "Ť" (U+0164)
  0x18, 0x16, 0x15, 0x28, 0x37, 0xE4, 0x0B, 0xB8, 0x18, 0x03, 0x93, 0x02, 0x93, 0x02, 0x93, 0x02,
  0x93, 0x02, 0x92,
  // "ť" (U+0165)
  0x18, 0x52, 0x39, 0x40, 0x69, 0x20, 0x7B, 0x83, 0x30, 0x99, 0x12, 0x00, 0x93, 0x81, 0x8B, 0x12,
  0x82, 0x3D, 0xF3,
  // "Ŧ" (U+0166)
  0x0B, 0xB8, 0x18, 0x03, 0x92, 0x82, 0x2E, 0xFE, 0x28, 0x14, 0xF1, 0x20, 0x29, 0x30, 0x29, 0x20,
  // "ŧ" (U+0167)
  0x10, 0x60, 0x92, 0x07, 0x0E, 0xA8, 0x53, 0x09, 0x91, 0x08, 0xA8, 0x92, 0xE3, 0x19, 0xB2, 0x10,
  0x3E, 0xF3,
  // "Ũ" (U+0168)
  0x18, 0xB7, 0xBD, 0x90, 0x98, 0x0B, 0x69, 0x80, 0xB6, 0x98, 0x0B, 0x69, 0x80, 0xB6, 0x8B, 0x2D,
  0x51, 0xCE, 0xA1,
  // "ũ" (U+0169)
  0x18, 0xB3, 0xBD, 0x90, 0x98, 0x0C, 0x59, 0x80, 0xC5, 0x98, 0x0C, 0x58, 0xB2, 0xE5, 0x3E, 0xCB,
  0x50,
  // "Ū" (U+016A)
  0x18, 0x1B, 0xE8, 0x20, 0xF1, 0x18, 0xB3, 0x98, 0x0B, 0x69, 0x80, 0xB6, 0x98, 0x0B, 0x69, 0x80,
  0xB6, 0x8B, 0x2D, 0x51, 0xCE, 0xA1,
  // "ū" (U+016B)
  0x18, 0x1B, 0xE8, 0x20, 0xF1, 0x18, 0xA7, 0x98, 0x0C, 0x59, 0x80, 0xC5, 0x98, 0x0C, 0x58, 0xB2,
  0xE5, 0x3E, 0xCB, 0x50,
  // "Ŭ" (U+016C)
  0x18, 0x14, 0x04, 0x28, 0xB7, 0x9F, 0x70, 0x98, 0x0B, 0x69, 0x80, 0xB6, 0x98, 0x0B, 0x69, 0x80,
  0xB6, 0x8B, 0x2D, 0x51, 0xCE, 0xA1,
  // "ŭ" (U+016D)
  0x18, 0x14, 0x04, 0x28, 0xB3, 0x9F, 0x70, 0x98, 0x0C, 0x59, 0x80, 0xC5, 0x98, 0x0C, 0x58, 0xB2,
  0xE5, 0x3E, 0xCB, 0x50,
  // "Ů" (U+016E)
  0x18, 0x14, 0xD2, 0x28, 0xB7, 0x6F, 0x30, 0x98, 0x0B, 0x69, 0x80, 0xB6, 0x98, 0x0B, 0x69, 0x80,
  0xB6, 0x8B, 0x2D, 0x51, 0xCE, 0xA1,
  // "ů" (U+016F)
  0x18, 0x14, 0xD2, 0x28, 0xB3, 0x6F, 0x30, 0x98, 0x0C, 0x59, 0x80, 0xC5, 0x98, 0x0C, 0x58, 0xB2,
  0xE5, 0x3E, 0xCB, 0x50,
  // "Ű" (U+0170)
  0x18, 0x19, 0x89, 0x30, 0x12, 0x8B, 0x39, 0x80, 0xB6, 0x98, 0x0B, 0x69, 0x80, 0xB6, 0x98, 0x0B,
  0x68, 0xB2, 0xD5, 0x1C, 0xEA, 0x10,
  // "ű" (U+0171)
  0x18, 0x19, 0x89, 0x30, 0x12, 0x8A, 0x79, 0x80, 0xC5, 0x98, 0x0C, 0x59, 0x80, 0xC5, 0x8B, 0x2E,
  0x53, 0xEC, 0xB5,
  // "Ų" (U+0172)
  0x8B, 0x39, 0x80, 0xB6, 0x98, 0x0B, 0x69, 0x80, 0xB6, 0x98, 0x0B, 0x68, 0xB2, 0xD4, 0x2C, 0xF8,
  0x20, 0x10, 0x93, 0x81, 0x2E, 0x31,
  // "ų" (U+0173)
  0x8A, 0x79, 0x80, 0xC5, 0x98, 0x0C, 0x59, 0x80, 0xC5, 0x8B, 0x2E, 0x53, 0xEC, 0xE5, 0x20, 0x20,
  0x93, 0x81, 0x2F, 0x33, 0x01, 0x10,
  // "Ŵ" (U+0174)
  0x18, 0x12, 0x71, 0x28, 0xC0, 0xB7, 0x90, 0xD2, 0x05, 0xAC, 0x6F, 0x69, 0xB9, 0xE9, 0x8A, 0xCA,
  0xC7, 0x9E, 0x6E, 0x68, 0xF3, 0xF5,
  // "ŵ" (U+0175)
  0x18, 0x12, 0x71, 0x28, 0xB3, 0xB7, 0x90, 0xE1, 0x04, 0xBC, 0x5F, 0x59, 0xA9, 0xE9, 0x78, 0xD9,
  0xD5, 0x6F, 0x4F, 0x30,
  // "Ŷ" (U+0176)
  0x18, 0x12, 0x71, 0x28, 0x93, 0xB7, 0x90, 0x99, 0x0C, 0x62, 0xE3, 0xE2, 0x81, 0xBD, 0x82, 0x81,
  0x4F, 0x12, 0x02, 0x93, 0x02, 0x92,
  // "ŷ" (U+0177)
  0x18, 0x12, 0x71, 0x28, 0xA0, 0xB7, 0x90, 0xA8, 0x0B, 0x74, 0xD0, 0xF2, 0x0E, 0x7C, 0x28, 0x19,
  0xE7, 0x28, 0x53, 0xF2, 0x01, 0x8C, 0x28, 0x18, 0xD3, 0x20,
  // "Ÿ" (U+0178)
  0x18, 0x1C, 0x1B, 0x68, 0x79, 0x90, 0xC6, 0x2E, 0x3E, 0x28, 0x1B, 0xD8, 0x28, 0x14, 0xF1, 0x20,
  0x29, 0x30, 0x29, 0x20,
  // "Ź" (U+0179)
  0x30, 0x40, 0x52, 0x82, 0x1C, 0x22, 0xB0, 0x32, 0x05, 0x0D, 0x30, 0xD0, 0x42, 0x06, 0x0B, 0x28,
  0x11, 0xE3, 0x20, 0x5B, 0x03,
  // "ź" (U+017A)
  0x20, 0x40, 0x52, 0x83, 0x1C, 0x20, 0x5B, 0x03, 0x20, 0x90, 0xB2, 0x85, 0x4E, 0x10, 0x1E, 0x52,
  0x07, 0xB0, 0x40,
  // "Ż" (U+017B)
  0x20, 0x20, 0xD6, 0x02, 0xB0, 0x32, 0x05, 0x0D, 0x30, 0xD0, 0x42, 0x06, 0x0B, 0x28, 0x11, 0xE3,
  0x20, 0x5B, 0x03,
  // "ż" (U+017C)
  0x10, 0x20, 0xD7, 0x05, 0xB0, 0x32, 0x09, 0x0B, 0x28, 0x54, 0xE1, 0x01, 0xE5, 0x20, 0x7B, 0x04,
  // "Ž" (U+017D)
  0x28, 0x16, 0x15, 0x28, 0x27, 0xE4, 0x2B, 0x03, 0x20, 0x50, 0xD3, 0x0D, 0x04, 0x20, 0x60, 0xB2,
  0x81, 0x1E, 0x32, 0x05, 0xB0, 0x30,
  // "ž" (U+017E)
  0x18, 0x16, 0x15, 0x28, 0x37, 0xE4, 0x05, 0xB0, 0x32, 0x09, 0x0B, 0x28, 0x54, 0xE1, 0x01, 0xE5,
  0x20, 0x7B, 0x04,
  // "ſ" (U+017F)
  0x8A, 0x21, 0xDE, 0x6C, 0x16, 0xB0, 0x6B, 0x06, 0xB0, 0x6B, 0x06, 0xB1,
  // "Ω" (U+03A9)
  0x8B, 0x41, 0xBE, 0x90, 0x8A, 0x1D, 0x4A, 0x60, 0x96, 0x87, 0x0A, 0x43, 0xC1, 0xC1, 0xDF, 0x6F,
  0xA0,
  // "μ" (U+03BC)
  0x8B, 0x19, 0x80, 0xC5, 0x98, 0x0C, 0x59, 0x80, 0xC5, 0x9B, 0x2E, 0x59, 0xFC, 0xB5, 0x98, 0x30,
  0x90, 0x83,
  // "π" (U+03C0)
  0x0C, 0xB8, 0xA3, 0xB2, 0xE4, 0xD0, 0x2E, 0x3D, 0x02, 0xE3, 0xD1, 0x2E, 0x1D, 0xA0,
  // "–" (U+2013)
  0x02, 0x0F, 0xE1, 0x0F, 0x10,
  // "—" (U+2014)
  0x80, 0x0E, 0x0B, 0x80, 0x11,
  // "€" (U+20AC)
  0x18, 0x95, 0x4D, 0xE5, 0x0E, 0x51, 0x19, 0xFE, 0x80, 0xAA, 0x89, 0x29, 0x01, 0xE7, 0x21, 0x04,
  0xDF, 0x40,
  // "₿" (U+20BF)
  0x18, 0x37, 0x51, 0x05, 0xA8, 0xA5, 0xC1, 0x5B, 0x1E, 0x45, 0xFE, 0xC0, 0x5B, 0x2D, 0x55, 0xB1,
  0xD6, 0x5A, 0x84, 0xC1, 0x07, 0x51, 0x10,
  // "‘" (U+2018)
  0x18, 0x3D, 0x3D, 0x01,
  // "’" (U+2019)
  0x19, 0x81, 0x13, 0xC2, 0x01, 0x10,
  // "‚" (U+201A)
  0x84, 0x1D, 0x3D, 0x58,
  // "‛" (U+201B)
  0x84, 0x3D, 0x0D, 0x01,
  // "“" (U+201C)
  0x18, 0x91, 0xD1, 0xD3, 0xD3, 0xD0, 0x10, 0x10,
  // "”" (U+201D)
  0x89, 0x11, 0x01, 0x0D, 0x3D, 0x3D, 0x1D, 0x10,
  // "„" (U+201E)
  0x89, 0x21, 0xD1, 0xD3, 0xD3, 0xD5, 0x85, 0x80,
  // "‟" (U+201F)
  0x18, 0x91, 0x10, 0x13, 0xD3, 0xD0, 0xD1, 0xD0,
  // "†" (U+2020)
  0x10, 0x10, 0xC2, 0x85, 0x2B, 0x22, 0xCE, 0xC2, 0x0A, 0x30, 0xB2, 0x01, 0x0C, 0x20, 0x20, 0xD1,
  // "‡" (U+2021)
  0x18, 0xB0, 0x1D, 0x01, 0x4C, 0x52, 0x9D, 0x90, 0x1D, 0x01, 0x7D, 0x81, 0x5C, 0x60, 0x1D, 0x10,
  // "•" (U+2022)
  0x87, 0x5C, 0x2A, 0xF7, 0x6E, 0x30,
  // "…" (U+2026)
  0x84, 0x2D, 0x3D, 0x3D,
  // "‰" (U+2030)
  0x00, 0xA3, 0x86, 0xAC, 0x94, 0x01, 0xA2, 0x28, 0x95, 0x3B, 0x7C, 0x50, 0xBB, 0xB9, 0x0B, 0x8C,
  0x60,
  // "‹" (U+2039)
  0x18, 0x91, 0xA3, 0x7B, 0x03, 0xD1, 0x04, 0x20,
  // "›" (U+203A)
  0x89, 0x12, 0x40, 0x1D, 0x30, 0xB7, 0x3A, 0x10,
  // "⁄" (U+2044)
  0x20, 0x70, 0x62, 0x0C, 0x20, 0x30, 0x92, 0x09, 0x03, 0x20, 0xC2, 0x06, 0x07, 0x20,
  // "™" (U+2122)
  0x0F, 0x98, 0x92, 0x49, 0x44, 0x9C, 0x93, 0x36, 0x16,
  // "⅒" (U+2152)
  0x40, 0x70, 0x65, 0x06, 0x0D, 0x20, 0xC7, 0x82, 0xB0, 0x39, 0x38, 0x94, 0x7B, 0x44, 0xD5, 0x93,
  0x6D, 0x0C, 0x0B, 0x30, 0xC2, 0x83, 0xB0, 0xC0, 0xB2, 0x87, 0x67, 0x04, 0xD5, 0x6B, 0x40,
  // "∂" (U+2202)
  0x18, 0x17, 0xDA, 0x28, 0xA5, 0x20, 0xD4, 0x09, 0xDD, 0x55, 0xC0, 0xE3, 0x89, 0x4D, 0x03, 0xDC,
  0x31,
  // "∆" (U+2206)
  0x18, 0x16, 0xF3, 0x28, 0xA2, 0xBC, 0x80, 0x1E, 0x3D, 0x05, 0xA0, 0xD2, 0xA7, 0x19, 0x7E, 0xB0,
  0xB0,
  // "√" (U+221A)
  0x40, 0x63, 0x05, 0x09, 0x30, 0x90, 0x43, 0x89, 0x1D, 0x0A, 0x92, 0xB0, 0x1D, 0x76, 0x28, 0x18,
  0xE2, 0x20, 0x30, 0xD2,
  // "∞" (U+221E)
  0x89, 0x57, 0xB6, 0xC4, 0xC3, 0xE3, 0xA7, 0xB7, 0xC4,
  // "≈" (U+2248)
  0x89, 0x53, 0xE7, 0x13, 0x52, 0xAE, 0x27, 0xEE, 0xE4, 0x80, 0x01, 0x10,
  // "≠" (U+2260)
  0x28, 0x25, 0x70, 0x6B, 0x03, 0x20, 0xD2, 0x06, 0xB8, 0x23, 0x08, 0x32,
  // "≤" (U+2264)
  0x40, 0x12, 0x89, 0x34, 0xB6, 0x2B, 0x81, 0x01, 0x8C, 0x61, 0x38, 0x56, 0x64, 0xCC, 0xC6,
  // "≥" (U+2265)
  0x01, 0x48, 0x16, 0xB4, 0x38, 0x91, 0x18, 0xB2, 0x16, 0xC8, 0x16, 0x63, 0x83, 0x6C, 0xCC, 0x40,
};

const Font& font_NotoSansMono_Bold_8() {
  static SmoothFont font(font_NotoSansMono_Bold_8_data);
  return font;
}

}  // namespace roo_display
