#include "18.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSansMono-Bold (Noto Sans Mono Bold)
// Generated on Sun Mar 06 15:50:06 CET 2022
static const uint8_t font_NotoSansMono_Bold_18_data[] PROGMEM = {
  
  // Header
  0x01, 0x01, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x5D, 0x00, 0x00,
  0xFC, 0xFC, 0x1C, 0x12, 0x0E, 0xFC, 0x05, 0x00, 0x20, 0x06, 0x0B, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x03, 0x01, 0x06, 0x0D, 0x0B, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x02, 0x09, 0x08, 0x0D, 0x0B, 0x00, 0x1B, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x00, 0x2F, // "#" (U+0023)
  0x00, 0x24, 0x01, 0x00, 0x09, 0x0E, 0x0B, 0x00, 0x68, // "$" (U+0024)
  0x00, 0x25, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x00, 0xA0, // "%" (U+0025)
  0x00, 0x26, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x00, 0xE7, // "&" (U+0026)
  0x00, 0x27, 0x04, 0x09, 0x06, 0x0D, 0x0B, 0x01, 0x29, // "'" (U+0027)
  0x00, 0x28, 0x03, 0xFE, 0x07, 0x0D, 0x0B, 0x01, 0x32, // "(" (U+0028)
  0x00, 0x29, 0x03, 0xFE, 0x07, 0x0D, 0x0B, 0x01, 0x61, // ")" (U+0029)
  0x00, 0x2A, 0x01, 0x07, 0x09, 0x0E, 0x0B, 0x01, 0x90, // "*" (U+002A)
  0x00, 0x2B, 0x01, 0x03, 0x09, 0x0B, 0x0B, 0x01, 0xB2, // "+" (U+002B)
  0x00, 0x2C, 0x03, 0xFE, 0x06, 0x02, 0x0B, 0x01, 0xCF, // "," (U+002C)
  0x00, 0x2D, 0x02, 0x05, 0x08, 0x07, 0x0B, 0x01, 0xDB, // "-" (U+002D)
  0x00, 0x2E, 0x03, 0x01, 0x06, 0x03, 0x0B, 0x01, 0xE3, // "." (U+002E)
  0x00, 0x2F, 0x02, 0x01, 0x08, 0x0D, 0x0B, 0x01, 0xEA, // "/" (U+002F)
  0x00, 0x30, 0x00, 0x01, 0x09, 0x0D, 0x0B, 0x02, 0x12, // "0" (U+0030)
  0x00, 0x31, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x02, 0x53, // "1" (U+0031)
  0x00, 0x32, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x02, 0x80, // "2" (U+0032)
  0x00, 0x33, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x02, 0xAB, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x02, 0xDE, // "4" (U+0034)
  0x00, 0x35, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x03, 0x14, // "5" (U+0035)
  0x00, 0x36, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x03, 0x44, // "6" (U+0036)
  0x00, 0x37, 0x00, 0x01, 0x09, 0x0D, 0x0B, 0x03, 0x7D, // "7" (U+0037)
  0x00, 0x38, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x03, 0xA7, // "8" (U+0038)
  0x00, 0x39, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x03, 0xE5, // "9" (U+0039)
  0x00, 0x3A, 0x03, 0x01, 0x06, 0x0A, 0x0B, 0x04, 0x1D, // ":" (U+003A)
  0x00, 0x3B, 0x03, 0xFE, 0x07, 0x0A, 0x0B, 0x04, 0x2C, // ";" (U+003B)
  0x00, 0x3C, 0x01, 0x03, 0x09, 0x0B, 0x0B, 0x04, 0x45, // "<" (U+003C)
  0x00, 0x3D, 0x01, 0x04, 0x09, 0x09, 0x0B, 0x04, 0x6A, // "=" (U+003D)
  0x00, 0x3E, 0x01, 0x03, 0x09, 0x0B, 0x0B, 0x04, 0x79, // ">" (U+003E)
  0x00, 0x3F, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x04, 0x9D, // "?" (U+003F)
  0x00, 0x40, 0x00, 0xFF, 0x0A, 0x0D, 0x0B, 0x04, 0xC9, // "@" (U+0040)
  0x00, 0x41, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x05, 0x15, // "A" (U+0041)
  0x00, 0x42, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x05, 0x4E, // "B" (U+0042)
  0x00, 0x43, 0x00, 0x01, 0x09, 0x0D, 0x0B, 0x05, 0x83, // "C" (U+0043)
  0x00, 0x44, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x05, 0xB3, // "D" (U+0044)
  0x00, 0x45, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x05, 0xF5, // "E" (U+0045)
  0x00, 0x46, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x06, 0x1D, // "F" (U+0046)
  0x00, 0x47, 0x00, 0x01, 0x09, 0x0D, 0x0B, 0x06, 0x45, // "G" (U+0047)
  0x00, 0x48, 0x00, 0x01, 0x09, 0x0D, 0x0B, 0x06, 0x7D, // "H" (U+0048)
  0x00, 0x49, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x06, 0xB4, // "I" (U+0049)
  0x00, 0x4A, 0x01, 0x01, 0x08, 0x0D, 0x0B, 0x06, 0xDC, // "J" (U+004A)
  0x00, 0x4B, 0x00, 0x01, 0x09, 0x0D, 0x0B, 0x07, 0x05, // "K" (U+004B)
  0x00, 0x4C, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x07, 0x4A, // "L" (U+004C)
  0x00, 0x4D, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x07, 0x72, // "M" (U+004D)
  0x00, 0x4E, 0x00, 0x01, 0x09, 0x0D, 0x0B, 0x07, 0xBD, // "N" (U+004E)
  0x00, 0x4F, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x08, 0x00, // "O" (U+004F)
  0x00, 0x50, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x08, 0x45, // "P" (U+0050)
  0x00, 0x51, 0x00, 0xFE, 0x0A, 0x0D, 0x0B, 0x08, 0x74, // "Q" (U+0051)
  0x00, 0x52, 0x01, 0x01, 0x0A, 0x0D, 0x0B, 0x08, 0xC2, // "R" (U+0052)
  0x00, 0x53, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x08, 0xFE, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x09, 0x30, // "T" (U+0054)
  0x00, 0x55, 0x00, 0x01, 0x09, 0x0D, 0x0B, 0x09, 0x5F, // "U" (U+0055)
  0x00, 0x56, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x09, 0x9C, // "V" (U+0056)
  0x00, 0x57, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x09, 0xDB, // "W" (U+0057)
  0x00, 0x58, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x0A, 0x24, // "X" (U+0058)
  0x00, 0x59, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x0A, 0x62, // "Y" (U+0059)
  0x00, 0x5A, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x0A, 0x9A, // "Z" (U+005A)
  0x00, 0x5B, 0x04, 0xFD, 0x08, 0x0D, 0x0B, 0x0A, 0xC4, // "[" (U+005B)
  0x00, 0x5C, 0x02, 0x01, 0x08, 0x0D, 0x0B, 0x0A, 0xF4, // "\" (U+005C)
  0x00, 0x5D, 0x02, 0xFE, 0x06, 0x0E, 0x0B, 0x0B, 0x1B, // "]" (U+005D)
  0x00, 0x5E, 0x00, 0x06, 0x09, 0x0D, 0x0B, 0x0B, 0x4B, // "^" (U+005E)
  0x00, 0x5F, 0x00, 0xFE, 0x0A, 0x00, 0x0B, 0x0B, 0x6E, // "_" (U+005F)
  0x00, 0x60, 0x02, 0x0C, 0x06, 0x0E, 0x0B, 0x0B, 0x74, // "`" (U+0060)
  0x00, 0x61, 0x01, 0x01, 0x09, 0x0A, 0x0B, 0x0B, 0x7D, // "a" (U+0061)
  0x00, 0x62, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x0B, 0xA7, // "b" (U+0062)
  0x00, 0x63, 0x01, 0x01, 0x09, 0x0A, 0x0B, 0x0B, 0xD6, // "c" (U+0063)
  0x00, 0x64, 0x00, 0x01, 0x09, 0x0E, 0x0B, 0x0B, 0xFB, // "d" (U+0064)
  0x00, 0x65, 0x01, 0x01, 0x09, 0x0A, 0x0B, 0x0C, 0x3B, // "e" (U+0065)
  0x00, 0x66, 0x01, 0x01, 0x0A, 0x0E, 0x0B, 0x0C, 0x62, // "f" (U+0066)
  0x00, 0x67, 0x00, 0xFD, 0x09, 0x0A, 0x0B, 0x0C, 0x94, // "g" (U+0067)
  0x00, 0x68, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x0C, 0xD9, // "h" (U+0068)
  0x00, 0x69, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x0D, 0x0D, // "i" (U+0069)
  0x00, 0x6A, 0x00, 0xFD, 0x07, 0x0E, 0x0B, 0x0D, 0x30, // "j" (U+006A)
  0x00, 0x6B, 0x01, 0x01, 0x0A, 0x0E, 0x0B, 0x0D, 0x68, // "k" (U+006B)
  0x00, 0x6C, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x0D, 0xA8, // "l" (U+006C)
  0x00, 0x6D, 0x00, 0x01, 0x0A, 0x0A, 0x0B, 0x0D, 0xD5, // "m" (U+006D)
  0x00, 0x6E, 0x01, 0x01, 0x09, 0x0A, 0x0B, 0x0E, 0x11, // "n" (U+006E)
  0x00, 0x6F, 0x00, 0x01, 0x09, 0x0A, 0x0B, 0x0E, 0x3D, // "o" (U+006F)
  0x00, 0x70, 0x01, 0xFD, 0x09, 0x0A, 0x0B, 0x0E, 0x6F, // "p" (U+0070)
  0x00, 0x71, 0x00, 0xFD, 0x09, 0x0A, 0x0B, 0x0E, 0x9F, // "q" (U+0071)
  0x00, 0x72, 0x00, 0x01, 0x0A, 0x0A, 0x0B, 0x0E, 0xDF, // "r" (U+0072)
  0x00, 0x73, 0x01, 0x01, 0x09, 0x0A, 0x0B, 0x0F, 0x07, // "s" (U+0073)
  0x00, 0x74, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x0F, 0x31, // "t" (U+0074)
  0x00, 0x75, 0x00, 0x01, 0x09, 0x0A, 0x0B, 0x0F, 0x5E, // "u" (U+0075)
  0x00, 0x76, 0x00, 0x01, 0x0A, 0x0A, 0x0B, 0x0F, 0x91, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x01, 0x0A, 0x0A, 0x0B, 0x0F, 0xC1, // "w" (U+0077)
  0x00, 0x78, 0x00, 0x01, 0x0A, 0x0A, 0x0B, 0x0F, 0xFA, // "x" (U+0078)
  0x00, 0x79, 0x00, 0xFD, 0x0A, 0x0A, 0x0B, 0x10, 0x2C, // "y" (U+0079)
  0x00, 0x7A, 0x01, 0x01, 0x09, 0x0A, 0x0B, 0x10, 0x69, // "z" (U+007A)
  0x00, 0x7B, 0x02, 0xFD, 0x08, 0x0D, 0x0B, 0x10, 0x8B, // "{" (U+007B)
  0x00, 0x7C, 0x04, 0xFD, 0x06, 0x0E, 0x0B, 0x10, 0xC3, // "|" (U+007C)
  0x00, 0x7D, 0x02, 0xFE, 0x08, 0x0E, 0x0B, 0x10, 0xE0, // "}" (U+007D)
  0x00, 0x7E, 0x01, 0x05, 0x09, 0x08, 0x0B, 0x11, 0x18, // "~" (U+007E)
  0x00, 0xA1, 0x04, 0xFE, 0x07, 0x0A, 0x0B, 0x11, 0x2B, // "¡" (U+00A1)
  0x00, 0xA2, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x11, 0x46, // "¢" (U+00A2)
  0x00, 0xA3, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x11, 0x75, // "£" (U+00A3)
  0x00, 0xA4, 0x01, 0x02, 0x09, 0x0B, 0x0B, 0x11, 0xA3, // "¤" (U+00A4)
  0x00, 0xA5, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x11, 0xCE, // "¥" (U+00A5)
  0x00, 0xA6, 0x04, 0xFD, 0x06, 0x0E, 0x0B, 0x12, 0x05, // "¦" (U+00A6)
  0x00, 0xA7, 0x01, 0x01, 0x08, 0x0E, 0x0B, 0x12, 0x1E, // "§" (U+00A7)
  0x00, 0xA8, 0x02, 0x0C, 0x08, 0x0D, 0x0B, 0x12, 0x56, // "¨" (U+00A8)
  0x00, 0xA9, 0x00, 0x02, 0x0A, 0x0B, 0x0B, 0x12, 0x5F, // "©" (U+00A9)
  0x00, 0xAA, 0x02, 0x07, 0x08, 0x0D, 0x0B, 0x12, 0x97, // "ª" (U+00AA)
  0x00, 0xAB, 0x01, 0x02, 0x09, 0x09, 0x0B, 0x12, 0xB3, // "«" (U+00AB)
  0x00, 0xAC, 0x01, 0x03, 0x09, 0x08, 0x0B, 0x12, 0xDB, // "¬" (U+00AC)
  0x00, 0xAE, 0x00, 0x02, 0x0A, 0x0B, 0x0B, 0x12, 0xEC, // "®" (U+00AE)
  0x00, 0xAF, 0x02, 0x0C, 0x08, 0x0E, 0x0B, 0x13, 0x26, // "¯" (U+00AF)
  0x00, 0xB0, 0x02, 0x08, 0x08, 0x0D, 0x0B, 0x13, 0x2E, // "°" (U+00B0)
  0x00, 0xB1, 0x01, 0x01, 0x09, 0x0B, 0x0B, 0x13, 0x45, // "±" (U+00B1)
  0x00, 0xB2, 0x02, 0x08, 0x08, 0x0F, 0x0B, 0x13, 0x67, // "²" (U+00B2)
  0x00, 0xB3, 0x02, 0x08, 0x07, 0x0F, 0x0B, 0x13, 0x84, // "³" (U+00B3)
  0x00, 0xB4, 0x04, 0x0C, 0x08, 0x0E, 0x0B, 0x13, 0x9E, // "´" (U+00B4)
  0x00, 0xB5, 0x00, 0xFD, 0x09, 0x0A, 0x0B, 0x13, 0xA7, // "µ" (U+00B5)
  0x00, 0xB6, 0x00, 0xFE, 0x09, 0x0E, 0x0B, 0x13, 0xE4, // "¶" (U+00B6)
  0x00, 0xB7, 0x03, 0x06, 0x06, 0x08, 0x0B, 0x14, 0x28, // "·" (U+00B7)
  0x00, 0xB8, 0x03, 0xFC, 0x07, 0x01, 0x0B, 0x14, 0x2F, // "¸" (U+00B8)
  0x00, 0xB9, 0x02, 0x08, 0x08, 0x0F, 0x0B, 0x14, 0x40, // "¹" (U+00B9)
  0x00, 0xBA, 0x02, 0x07, 0x08, 0x0D, 0x0B, 0x14, 0x5B, // "º" (U+00BA)
  0x00, 0xBB, 0x01, 0x02, 0x09, 0x09, 0x0B, 0x14, 0x74, // "»" (U+00BB)
  0x00, 0xBC, 0x00, 0x00, 0x0A, 0x0C, 0x0B, 0x14, 0x9C, // "¼" (U+00BC)
  0x00, 0xBD, 0x00, 0x00, 0x0A, 0x0D, 0x0B, 0x14, 0xE0, // "½" (U+00BD)
  0x00, 0xBE, 0x00, 0x00, 0x0A, 0x0D, 0x0B, 0x15, 0x24, // "¾" (U+00BE)
  0x00, 0xBF, 0x00, 0xFE, 0x08, 0x0A, 0x0B, 0x15, 0x6D, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x0A, 0x11, 0x0B, 0x15, 0x99, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x0A, 0x11, 0x0B, 0x15, 0xDD, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x01, 0x0A, 0x11, 0x0B, 0x16, 0x20, // "Â" (U+00C2)
  0x00, 0xC3, 0x00, 0x01, 0x0A, 0x11, 0x0B, 0x16, 0x67, // "Ã" (U+00C3)
  0x00, 0xC4, 0x00, 0x01, 0x0A, 0x10, 0x0B, 0x16, 0xAF, // "Ä" (U+00C4)
  0x00, 0xC5, 0x00, 0x01, 0x0A, 0x12, 0x0B, 0x16, 0xF3, // "Å" (U+00C5)
  0x00, 0xC6, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x17, 0x3E, // "Æ" (U+00C6)
  0x00, 0xC7, 0x00, 0xFC, 0x09, 0x0D, 0x0B, 0x17, 0x7A, // "Ç" (U+00C7)
  0x00, 0xC8, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x17, 0xBB, // "È" (U+00C8)
  0x00, 0xC9, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x17, 0xED, // "É" (U+00C9)
  0x00, 0xCA, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x18, 0x1F, // "Ê" (U+00CA)
  0x00, 0xCB, 0x01, 0x01, 0x09, 0x10, 0x0B, 0x18, 0x55, // "Ë" (U+00CB)
  0x00, 0xCC, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x18, 0x88, // "Ì" (U+00CC)
  0x00, 0xCD, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x18, 0xBA, // "Í" (U+00CD)
  0x00, 0xCE, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x18, 0xEC, // "Î" (U+00CE)
  0x00, 0xCF, 0x01, 0x01, 0x09, 0x10, 0x0B, 0x19, 0x22, // "Ï" (U+00CF)
  0x00, 0xD0, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x19, 0x55, // "Ð" (U+00D0)
  0x00, 0xD1, 0x00, 0x01, 0x09, 0x11, 0x0B, 0x19, 0x96, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x00, 0x01, 0x0A, 0x11, 0x0B, 0x19, 0xE9, // "Ò" (U+00D2)
  0x00, 0xD3, 0x00, 0x01, 0x0A, 0x11, 0x0B, 0x1A, 0x39, // "Ó" (U+00D3)
  0x00, 0xD4, 0x00, 0x01, 0x0A, 0x11, 0x0B, 0x1A, 0x88, // "Ô" (U+00D4)
  0x00, 0xD5, 0x00, 0x01, 0x0A, 0x11, 0x0B, 0x1A, 0xDB, // "Õ" (U+00D5)
  0x00, 0xD6, 0x00, 0x01, 0x0A, 0x10, 0x0B, 0x1B, 0x30, // "Ö" (U+00D6)
  0x00, 0xD7, 0x01, 0x03, 0x09, 0x0B, 0x0B, 0x1B, 0x80, // "×" (U+00D7)
  0x00, 0xD8, 0x00, 0x00, 0x0A, 0x0E, 0x0B, 0x1B, 0xA7, // "Ø" (U+00D8)
  0x00, 0xD9, 0x00, 0x01, 0x09, 0x11, 0x0B, 0x1B, 0xF4, // "Ù" (U+00D9)
  0x00, 0xDA, 0x00, 0x01, 0x09, 0x11, 0x0B, 0x1C, 0x3B, // "Ú" (U+00DA)
  0x00, 0xDB, 0x00, 0x01, 0x09, 0x11, 0x0B, 0x1C, 0x82, // "Û" (U+00DB)
  0x00, 0xDC, 0x00, 0x01, 0x09, 0x10, 0x0B, 0x1C, 0xCD, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x01, 0x0A, 0x11, 0x0B, 0x1D, 0x15, // "Ý" (U+00DD)
  0x00, 0xDE, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x1D, 0x57, // "Þ" (U+00DE)
  0x00, 0xDF, 0x01, 0x01, 0x0A, 0x0E, 0x0B, 0x1D, 0x86, // "ß" (U+00DF)
  0x00, 0xE0, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x1D, 0xCC, // "à" (U+00E0)
  0x00, 0xE1, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x1E, 0x00, // "á" (U+00E1)
  0x00, 0xE2, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x1E, 0x34, // "â" (U+00E2)
  0x00, 0xE3, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x1E, 0x6C, // "ã" (U+00E3)
  0x00, 0xE4, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x1E, 0xA6, // "ä" (U+00E4)
  0x00, 0xE5, 0x01, 0x01, 0x09, 0x0F, 0x0B, 0x1E, 0xDB, // "å" (U+00E5)
  0x00, 0xE6, 0x00, 0x01, 0x0A, 0x0A, 0x0B, 0x1F, 0x17, // "æ" (U+00E6)
  0x00, 0xE7, 0x01, 0xFC, 0x09, 0x0A, 0x0B, 0x1F, 0x4A, // "ç" (U+00E7)
  0x00, 0xE8, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x1F, 0x80, // "è" (U+00E8)
  0x00, 0xE9, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x1F, 0xB1, // "é" (U+00E9)
  0x00, 0xEA, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x1F, 0xE2, // "ê" (U+00EA)
  0x00, 0xEB, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x20, 0x17, // "ë" (U+00EB)
  0x00, 0xEC, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x20, 0x49, // "ì" (U+00EC)
  0x00, 0xED, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x20, 0x6C, // "í" (U+00ED)
  0x00, 0xEE, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x20, 0x8F, // "î" (U+00EE)
  0x00, 0xEF, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x20, 0xB6, // "ï" (U+00EF)
  0x00, 0xF0, 0x00, 0x01, 0x09, 0x0E, 0x0B, 0x20, 0xDA, // "ð" (U+00F0)
  0x00, 0xF1, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x21, 0x1B, // "ñ" (U+00F1)
  0x00, 0xF2, 0x00, 0x01, 0x09, 0x0E, 0x0B, 0x21, 0x57, // "ò" (U+00F2)
  0x00, 0xF3, 0x00, 0x01, 0x09, 0x0E, 0x0B, 0x21, 0x93, // "ó" (U+00F3)
  0x00, 0xF4, 0x00, 0x01, 0x09, 0x0E, 0x0B, 0x21, 0xCF, // "ô" (U+00F4)
  0x00, 0xF5, 0x00, 0x01, 0x09, 0x0E, 0x0B, 0x22, 0x0E, // "õ" (U+00F5)
  0x00, 0xF6, 0x00, 0x01, 0x09, 0x0D, 0x0B, 0x22, 0x4F, // "ö" (U+00F6)
  0x00, 0xF7, 0x01, 0x03, 0x09, 0x0B, 0x0B, 0x22, 0x8B, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x00, 0x09, 0x0B, 0x0B, 0x22, 0xA0, // "ø" (U+00F8)
  0x00, 0xF9, 0x00, 0x01, 0x09, 0x0E, 0x0B, 0x22, 0xD8, // "ù" (U+00F9)
  0x00, 0xFA, 0x00, 0x01, 0x09, 0x0E, 0x0B, 0x23, 0x15, // "ú" (U+00FA)
  0x00, 0xFB, 0x00, 0x01, 0x09, 0x0E, 0x0B, 0x23, 0x52, // "û" (U+00FB)
  0x00, 0xFC, 0x00, 0x01, 0x09, 0x0D, 0x0B, 0x23, 0x93, // "ü" (U+00FC)
  0x00, 0xFD, 0x00, 0xFD, 0x0A, 0x0E, 0x0B, 0x23, 0xD1, // "ý" (U+00FD)
  0x00, 0xFE, 0x01, 0xFD, 0x09, 0x0E, 0x0B, 0x24, 0x18, // "þ" (U+00FE)
  0x00, 0xFF, 0x00, 0xFD, 0x0A, 0x0D, 0x0B, 0x24, 0x50, // "ÿ" (U+00FF)
  0x01, 0x00, 0x00, 0x01, 0x0A, 0x11, 0x0B, 0x24, 0x98, // "Ā" (U+0100)
  0x01, 0x01, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x24, 0xDA, // "ā" (U+0101)
  0x01, 0x02, 0x00, 0x01, 0x0A, 0x11, 0x0B, 0x25, 0x0E, // "Ă" (U+0102)
  0x01, 0x03, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x25, 0x55, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0xFD, 0x0B, 0x0D, 0x0B, 0x25, 0x8D, // "Ą" (U+0104)
  0x01, 0x05, 0x01, 0xFD, 0x09, 0x0A, 0x0B, 0x25, 0xD5, // "ą" (U+0105)
  0x01, 0x06, 0x00, 0x01, 0x09, 0x11, 0x0B, 0x26, 0x0B, // "Ć" (U+0106)
  0x01, 0x07, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x26, 0x45, // "ć" (U+0107)
  0x01, 0x08, 0x00, 0x01, 0x09, 0x11, 0x0B, 0x26, 0x74, // "Ĉ" (U+0108)
  0x01, 0x09, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x26, 0xB1, // "ĉ" (U+0109)
  0x01, 0x0A, 0x00, 0x01, 0x09, 0x11, 0x0B, 0x26, 0xE4, // "Ċ" (U+010A)
  0x01, 0x0B, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x27, 0x1E, // "ċ" (U+010B)
  0x01, 0x0C, 0x00, 0x01, 0x09, 0x11, 0x0B, 0x27, 0x4D, // "Č" (U+010C)
  0x01, 0x0D, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x27, 0x8A, // "č" (U+010D)
  0x01, 0x0E, 0x00, 0x01, 0x0A, 0x11, 0x0B, 0x27, 0xBD, // "Ď" (U+010E)
  0x01, 0x0F, 0x00, 0x01, 0x0C, 0x0E, 0x0B, 0x28, 0x0D, // "ď" (U+010F)
  0x01, 0x10, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x28, 0x56, // "Đ" (U+0110)
  0x01, 0x11, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x28, 0x97, // "đ" (U+0111)
  0x01, 0x12, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x28, 0xDC, // "Ē" (U+0112)
  0x01, 0x13, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x29, 0x0E, // "ē" (U+0113)
  0x01, 0x14, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x29, 0x3E, // "Ĕ" (U+0114)
  0x01, 0x15, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x29, 0x74, // "ĕ" (U+0115)
  0x01, 0x16, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x29, 0xA9, // "Ė" (U+0116)
  0x01, 0x17, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x29, 0xDB, // "ė" (U+0117)
  0x01, 0x18, 0x01, 0xFD, 0x09, 0x0D, 0x0B, 0x2A, 0x0C, // "Ę" (U+0118)
  0x01, 0x19, 0x01, 0xFD, 0x09, 0x0A, 0x0B, 0x2A, 0x40, // "ę" (U+0119)
  0x01, 0x1A, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x2A, 0x75, // "Ě" (U+011A)
  0x01, 0x1B, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x2A, 0xAB, // "ě" (U+011B)
  0x01, 0x1C, 0x00, 0x01, 0x09, 0x11, 0x0B, 0x2A, 0xE0, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x00, 0xFD, 0x09, 0x0E, 0x0B, 0x2B, 0x26, // "ĝ" (U+011D)
  0x01, 0x1E, 0x00, 0x01, 0x09, 0x11, 0x0B, 0x2B, 0x78, // "Ğ" (U+011E)
  0x01, 0x1F, 0x00, 0xFD, 0x09, 0x0E, 0x0B, 0x2B, 0xBE, // "ğ" (U+011F)
  0x01, 0x20, 0x00, 0x01, 0x09, 0x11, 0x0B, 0x2C, 0x10, // "Ġ" (U+0120)
  0x01, 0x21, 0x00, 0xFD, 0x09, 0x0E, 0x0B, 0x2C, 0x52, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0xFD, 0x09, 0x0D, 0x0B, 0x2C, 0xA1, // "Ģ" (U+0122)
  0x01, 0x23, 0x00, 0xFD, 0x09, 0x0E, 0x0B, 0x2C, 0xE4, // "ģ" (U+0123)
  0x01, 0x24, 0x00, 0x01, 0x09, 0x11, 0x0B, 0x2D, 0x32, // "Ĥ" (U+0124)
  0x01, 0x25, 0xFF, 0x01, 0x09, 0x12, 0x0B, 0x2D, 0x77, // "ĥ" (U+0125)
  0x01, 0x26, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x2D, 0xC0, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x09, 0x0E, 0x0B, 0x2D, 0xF9, // "ħ" (U+0127)
  0x01, 0x28, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x2E, 0x32, // "Ĩ" (U+0128)
  0x01, 0x29, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x2E, 0x6A, // "ĩ" (U+0129)
  0x01, 0x2A, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x2E, 0x92, // "Ī" (U+012A)
  0x01, 0x2B, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x2E, 0xC4, // "ī" (U+012B)
  0x01, 0x2C, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x2E, 0xE6, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x2F, 0x1C, // "ĭ" (U+012D)
  0x01, 0x2E, 0x01, 0xFD, 0x09, 0x0D, 0x0B, 0x2F, 0x43, // "Į" (U+012E)
  0x01, 0x2F, 0x01, 0xFD, 0x09, 0x0E, 0x0B, 0x2F, 0x78, // "į" (U+012F)
  0x01, 0x30, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x2F, 0xA7, // "İ" (U+0130)
  0x01, 0x31, 0x01, 0x01, 0x09, 0x0A, 0x0B, 0x2F, 0xD9, // "ı" (U+0131)
  0x01, 0x32, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x2F, 0xF2, // "Ĳ" (U+0132)
  0x01, 0x33, 0x01, 0xFD, 0x09, 0x0E, 0x0B, 0x30, 0x2A, // "ĳ" (U+0133)
  0x01, 0x34, 0x01, 0x01, 0x0A, 0x11, 0x0B, 0x30, 0x83, // "Ĵ" (U+0134)
  0x01, 0x35, 0x00, 0xFD, 0x09, 0x0E, 0x0B, 0x30, 0xBE, // "ĵ" (U+0135)
  0x01, 0x36, 0x00, 0xFD, 0x09, 0x0D, 0x0B, 0x30, 0xFC, // "Ķ" (U+0136)
  0x01, 0x37, 0x01, 0xFD, 0x0A, 0x0E, 0x0B, 0x31, 0x4C, // "ķ" (U+0137)
  0x01, 0x38, 0x01, 0x01, 0x0A, 0x0A, 0x0B, 0x31, 0x96, // "ĸ" (U+0138)
  0x01, 0x39, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x31, 0xCA, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x01, 0x01, 0x09, 0x12, 0x0B, 0x31, 0xFC, // "ĺ" (U+013A)
  0x01, 0x3B, 0x01, 0xFD, 0x09, 0x0D, 0x0B, 0x32, 0x33, // "Ļ" (U+013B)
  0x01, 0x3C, 0x01, 0xFD, 0x09, 0x0E, 0x0B, 0x32, 0x66, // "ļ" (U+013C)
  0x01, 0x3D, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x32, 0x9D, // "Ľ" (U+013D)
  0x01, 0x3E, 0x01, 0x01, 0x0A, 0x0E, 0x0B, 0x32, 0xCB, // "ľ" (U+013E)
  0x01, 0x3F, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x32, 0xFD, // "Ŀ" (U+013F)
  0x01, 0x40, 0x01, 0x01, 0x0B, 0x0E, 0x0B, 0x33, 0x2B, // "ŀ" (U+0140)
  0x01, 0x41, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x33, 0x64, // "Ł" (U+0141)
  0x01, 0x42, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x33, 0x95, // "ł" (U+0142)
  0x01, 0x43, 0x00, 0x01, 0x09, 0x11, 0x0B, 0x33, 0xC5, // "Ń" (U+0143)
  0x01, 0x44, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x34, 0x12, // "ń" (U+0144)
  0x01, 0x45, 0x00, 0xFD, 0x09, 0x0D, 0x0B, 0x34, 0x48, // "Ņ" (U+0145)
  0x01, 0x46, 0x01, 0xFD, 0x09, 0x0A, 0x0B, 0x34, 0x96, // "ņ" (U+0146)
  0x01, 0x47, 0x00, 0x01, 0x09, 0x11, 0x0B, 0x34, 0xCD, // "Ň" (U+0147)
  0x01, 0x48, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x35, 0x1E, // "ň" (U+0148)
  0x01, 0x49, 0xFE, 0x01, 0x09, 0x0D, 0x0B, 0x35, 0x58, // "ŉ" (U+0149)
  0x01, 0x4A, 0x00, 0xFD, 0x09, 0x0D, 0x0B, 0x35, 0x9D, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x01, 0xFD, 0x09, 0x0A, 0x0B, 0x35, 0xEF, // "ŋ" (U+014B)
  0x01, 0x4C, 0x00, 0x01, 0x0A, 0x11, 0x0B, 0x36, 0x29, // "Ō" (U+014C)
  0x01, 0x4D, 0x00, 0x01, 0x09, 0x0E, 0x0B, 0x36, 0x78, // "ō" (U+014D)
  0x01, 0x4E, 0x00, 0x01, 0x0A, 0x11, 0x0B, 0x36, 0xB3, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x00, 0x01, 0x09, 0x0E, 0x0B, 0x37, 0x06, // "ŏ" (U+014F)
  0x01, 0x50, 0x00, 0x01, 0x0A, 0x11, 0x0B, 0x37, 0x45, // "Ő" (U+0150)
  0x01, 0x51, 0x00, 0x01, 0x09, 0x0E, 0x0B, 0x37, 0x9A, // "ő" (U+0151)
  0x01, 0x52, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x37, 0xDB, // "Œ" (U+0152)
  0x01, 0x53, 0x00, 0x01, 0x0A, 0x0A, 0x0B, 0x38, 0x1B, // "œ" (U+0153)
  0x01, 0x54, 0x01, 0x01, 0x0A, 0x11, 0x0B, 0x38, 0x51, // "Ŕ" (U+0154)
  0x01, 0x55, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x38, 0x97, // "ŕ" (U+0155)
  0x01, 0x56, 0x01, 0xFD, 0x0A, 0x0D, 0x0B, 0x38, 0xC9, // "Ŗ" (U+0156)
  0x01, 0x57, 0x00, 0xFD, 0x0A, 0x0A, 0x0B, 0x39, 0x10, // "ŗ" (U+0157)
  0x01, 0x58, 0x01, 0x01, 0x0A, 0x11, 0x0B, 0x39, 0x43, // "Ř" (U+0158)
  0x01, 0x59, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x39, 0x8D, // "ř" (U+0159)
  0x01, 0x5A, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x39, 0xC3, // "Ś" (U+015A)
  0x01, 0x5B, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x39, 0xFF, // "ś" (U+015B)
  0x01, 0x5C, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x3A, 0x32, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x3A, 0x72, // "ŝ" (U+015D)
  0x01, 0x5E, 0x01, 0xFC, 0x09, 0x0D, 0x0B, 0x3A, 0xA9, // "Ş" (U+015E)
  0x01, 0x5F, 0x01, 0xFC, 0x09, 0x0A, 0x0B, 0x3A, 0xEB, // "ş" (U+015F)
  0x01, 0x60, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x3B, 0x25, // "Š" (U+0160)
  0x01, 0x61, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x3B, 0x65, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFC, 0x0A, 0x0D, 0x0B, 0x3B, 0x9C, // "Ţ" (U+0162)
  0x01, 0x63, 0x01, 0xFC, 0x09, 0x0D, 0x0B, 0x3B, 0xDB, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x0A, 0x11, 0x0B, 0x3C, 0x19, // "Ť" (U+0164)
  0x01, 0x65, 0x01, 0x01, 0x0A, 0x0E, 0x0B, 0x3C, 0x56, // "ť" (U+0165)
  0x01, 0x66, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x3C, 0x8B, // "Ŧ" (U+0166)
  0x01, 0x67, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x3C, 0xBA, // "ŧ" (U+0167)
  0x01, 0x68, 0x00, 0x01, 0x09, 0x11, 0x0B, 0x3C, 0xE8, // "Ũ" (U+0168)
  0x01, 0x69, 0x00, 0x01, 0x09, 0x0E, 0x0B, 0x3D, 0x35, // "ũ" (U+0169)
  0x01, 0x6A, 0x00, 0x01, 0x09, 0x11, 0x0B, 0x3D, 0x78, // "Ū" (U+016A)
  0x01, 0x6B, 0x00, 0x01, 0x09, 0x0E, 0x0B, 0x3D, 0xBF, // "ū" (U+016B)
  0x01, 0x6C, 0x00, 0x01, 0x09, 0x11, 0x0B, 0x3D, 0xFC, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x00, 0x01, 0x09, 0x0E, 0x0B, 0x3E, 0x47, // "ŭ" (U+016D)
  0x01, 0x6E, 0x00, 0x01, 0x09, 0x12, 0x0B, 0x3E, 0x88, // "Ů" (U+016E)
  0x01, 0x6F, 0x00, 0x01, 0x09, 0x0F, 0x0B, 0x3E, 0xD7, // "ů" (U+016F)
  0x01, 0x70, 0x00, 0x01, 0x09, 0x11, 0x0B, 0x3F, 0x1C, // "Ű" (U+0170)
  0x01, 0x71, 0x00, 0x01, 0x09, 0x0E, 0x0B, 0x3F, 0x69, // "ű" (U+0171)
  0x01, 0x72, 0x00, 0xFD, 0x09, 0x0D, 0x0B, 0x3F, 0xAC, // "Ų" (U+0172)
  0x01, 0x73, 0x00, 0xFD, 0x0A, 0x0A, 0x0B, 0x3F, 0xF5, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x0A, 0x11, 0x0B, 0x40, 0x38, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x40, 0x8F, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x01, 0x0A, 0x11, 0x0B, 0x40, 0xD6, // "Ŷ" (U+0176)
  0x01, 0x77, 0x00, 0xFD, 0x0A, 0x0E, 0x0B, 0x41, 0x1C, // "ŷ" (U+0177)
  0x01, 0x78, 0x00, 0x01, 0x0A, 0x10, 0x0B, 0x41, 0x67, // "Ÿ" (U+0178)
  0x01, 0x79, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x41, 0xAA, // "Ź" (U+0179)
  0x01, 0x7A, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x41, 0xDE, // "ź" (U+017A)
  0x01, 0x7B, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x42, 0x0A, // "Ż" (U+017B)
  0x01, 0x7C, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x42, 0x3E, // "ż" (U+017C)
  0x01, 0x7D, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x42, 0x6A, // "Ž" (U+017D)
  0x01, 0x7E, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x42, 0xA2, // "ž" (U+017E)
  0x01, 0x7F, 0x03, 0x01, 0x09, 0x0E, 0x0B, 0x42, 0xD2, // "ſ" (U+017F)
  0x03, 0xA9, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x42, 0xFE, // "Ω" (U+03A9)
  0x03, 0xBC, 0x00, 0xFD, 0x09, 0x0A, 0x0B, 0x43, 0x44, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x01, 0x0A, 0x0A, 0x0B, 0x43, 0x81, // "π" (U+03C0)
  0x20, 0x13, 0x01, 0x05, 0x08, 0x07, 0x0B, 0x43, 0xB7, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x05, 0x0A, 0x07, 0x0B, 0x43, 0xBD, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x43, 0xC3, // "€" (U+20AC)
  0x20, 0xBF, 0x01, 0xFF, 0x09, 0x0F, 0x0B, 0x43, 0xF5, // "₿" (U+20BF)
  0x20, 0x18, 0x03, 0x0A, 0x06, 0x0D, 0x0B, 0x44, 0x38, // "‘" (U+2018)
  0x20, 0x19, 0x03, 0x0A, 0x07, 0x0D, 0x0B, 0x44, 0x41, // "’" (U+2019)
  0x20, 0x1A, 0x03, 0xFE, 0x06, 0x02, 0x0B, 0x44, 0x4C, // "‚" (U+201A)
  0x20, 0x1B, 0x03, 0x0A, 0x06, 0x0D, 0x0B, 0x44, 0x58, // "‛" (U+201B)
  0x20, 0x1C, 0x01, 0x0A, 0x08, 0x0D, 0x0B, 0x44, 0x61, // "“" (U+201C)
  0x20, 0x1D, 0x02, 0x09, 0x09, 0x0C, 0x0B, 0x44, 0x73, // "”" (U+201D)
  0x20, 0x1E, 0x02, 0xFE, 0x08, 0x02, 0x0B, 0x44, 0x85, // "„" (U+201E)
  0x20, 0x1F, 0x01, 0x09, 0x08, 0x0C, 0x0B, 0x44, 0x99, // "‟" (U+201F)
  0x20, 0x20, 0x01, 0x01, 0x08, 0x0E, 0x0B, 0x44, 0xAB, // "†" (U+2020)
  0x20, 0x21, 0x01, 0x01, 0x08, 0x0E, 0x0B, 0x44, 0xD9, // "‡" (U+2021)
  0x20, 0x22, 0x03, 0x05, 0x07, 0x09, 0x0B, 0x45, 0x08, // "•" (U+2022)
  0x20, 0x26, 0xFF, 0x01, 0x0A, 0x03, 0x0B, 0x45, 0x15, // "…" (U+2026)
  0x20, 0x30, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x45, 0x28, // "‰" (U+2030)
  0x20, 0x39, 0x03, 0x02, 0x07, 0x09, 0x0B, 0x45, 0x67, // "‹" (U+2039)
  0x20, 0x3A, 0x03, 0x02, 0x07, 0x09, 0x0B, 0x45, 0x7D, // "›" (U+203A)
  0x20, 0x44, 0xFC, 0x01, 0x03, 0x0D, 0x00, 0x45, 0x93, // "⁄" (U+2044)
  0x21, 0x22, 0x00, 0x07, 0x0A, 0x0D, 0x0B, 0x45, 0xB8, // "™" (U+2122)
  0x21, 0x52, 0x04, 0x01, 0x1C, 0x0D, 0x20, 0x45, 0xDF, // "⅒" (U+2152)
  0x22, 0x02, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x46, 0x60, // "∂" (U+2202)
  0x22, 0x06, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x46, 0x97, // "∆" (U+2206)
  0x22, 0x1A, 0x00, 0x01, 0x0A, 0x10, 0x0B, 0x46, 0xD1, // "√" (U+221A)
  0x22, 0x1E, 0x00, 0x04, 0x0A, 0x09, 0x0B, 0x47, 0x11, // "∞" (U+221E)
  0x22, 0x48, 0x01, 0x04, 0x09, 0x0A, 0x0B, 0x47, 0x34, // "≈" (U+2248)
  0x22, 0x60, 0x01, 0x02, 0x09, 0x0C, 0x0B, 0x47, 0x52, // "≠" (U+2260)
  0x22, 0x64, 0x01, 0x01, 0x09, 0x0C, 0x0B, 0x47, 0x75, // "≤" (U+2264)
  0x22, 0x65, 0x01, 0x01, 0x09, 0x0C, 0x0B, 0x47, 0xA0, // "≥" (U+2265)
  
  // Kerning pairs
  
  // Glyph data
  // "!" (U+0021)
  0x01, 0xA0, 0xE1, 0xA0, 0xD1, 0xA0, 0xC1, 0xA8, 0xA3, 0xC0, 0xEF, 0xB0, 0xDF, 0xA0, 0xDF, 0xA0,
  0xCF, 0x90, 0xBF, 0x85, 0x82, 0xBE, 0x93, 0xB1, 0x81, 0xBE, 0x80,
  // """ (U+0022)
  0x81, 0x9F, 0xC1, 0xA8, 0xB3, 0x68, 0xFB, 0x0E, 0xF5, 0x7F, 0xA0, 0xDF, 0x46, 0xF9, 0x0C, 0xF3,
  0x5F, 0x80, 0xBF, 0x20,
  // "#" (U+0023)
  0x38, 0x43, 0xF9, 0x0D, 0xE5, 0x84, 0x5F, 0x60, 0xFC, 0x58, 0x48, 0xF4, 0x2F, 0xA5, 0x84, 0xAF,
  0x24, 0xF7, 0x20, 0x3F, 0xA0, 0x80, 0x3F, 0xA8, 0x91, 0x80, 0x13, 0xFB, 0x1B, 0xF2, 0x13, 0x84,
  0x4F, 0x80, 0xED, 0x30, 0xBF, 0xA1, 0x0B, 0xFA, 0x18, 0x90, 0x11, 0xBF, 0x27, 0xF7, 0x11, 0x38,
  0x4E, 0xD0, 0x9F, 0x34, 0x83, 0x1F, 0xA0, 0xC9, 0x40,
  // "$" (U+0024)
  0x30, 0x29, 0x58, 0x90, 0x19, 0xEF, 0xEC, 0x70, 0x1D, 0xD8, 0x95, 0xE0, 0x6F, 0xE4, 0xF2, 0x56,
  0x07, 0xFC, 0x29, 0x40, 0x4A, 0x0B, 0x95, 0x08, 0xB0, 0xB0, 0x44, 0x03, 0x0B, 0xB0, 0x84, 0x81,
  0x2F, 0xAA, 0x02, 0x38, 0x92, 0x2F, 0x0E, 0xF5, 0x78, 0x32, 0xF5, 0xA0, 0x30, 0x8E, 0x82, 0xB0,
  0x3B, 0xB0, 0xE0, 0x95, 0x03, 0x97, 0x02, 0x94,
  // "%" (U+0025)
  0x83, 0x1B, 0xEC, 0x22, 0x83, 0x9F, 0x40, 0xAB, 0x83, 0xC0, 0x2F, 0xC2, 0x87, 0xED, 0x2C, 0xF1,
  0x9F, 0x42, 0x86, 0xED, 0x2C, 0xF3, 0xFC, 0x30, 0xAB, 0x82, 0xDA, 0xF4, 0x38, 0x51, 0xBE, 0xC5,
  0xFC, 0x71, 0x81, 0xAF, 0x47, 0x86, 0x2F, 0xC5, 0xEF, 0xB1, 0x38, 0x1A, 0xF5, 0xC0, 0x82, 0x87,
  0x2F, 0xB4, 0xF9, 0x2F, 0xB2, 0x8A, 0x6A, 0xF4, 0x4F, 0x60, 0xFB, 0x02, 0xFB, 0x01, 0xEA, 0x5F,
  0x70, 0xAF, 0x32, 0x82, 0x4D, 0xE9, 0x10,
  // "&" (U+0026)
  0x28, 0x34, 0xCE, 0xC5, 0x50, 0x10, 0xEC, 0x02, 0x48, 0x55, 0xFE, 0x3C, 0xF6, 0x48, 0x55, 0xFC,
  0x0B, 0xF5, 0x40, 0x1A, 0x81, 0x9F, 0xD6, 0x09, 0xA0, 0xE0, 0x25, 0x02, 0x0E, 0xA8, 0x3B, 0x06,
  0xFE, 0x28, 0x1D, 0xFD, 0xA8, 0x47, 0xAF, 0xA0, 0x4A, 0x02, 0x06, 0xC8, 0x35, 0x06, 0xFD, 0x20,
  0xAA, 0x0D, 0x20, 0x5A, 0x81, 0x52, 0x9A, 0x0C, 0x30, 0xEF, 0x07, 0x28, 0x52, 0xBE, 0xEB, 0x39,
  0xA0, 0x30,
  // "'" (U+0027)
  0x89, 0x5C, 0xF9, 0xBF, 0x8A, 0xF7, 0x9F, 0x68, 0xF5,
  // "(" (U+0028)
  0x28, 0x92, 0x5F, 0xC0, 0x1E, 0xF3, 0x06, 0xFB, 0x28, 0x3D, 0xF6, 0x01, 0xA8, 0x31, 0x05, 0xFE,
  0x28, 0x17, 0xFC, 0x28, 0x18, 0xFB, 0x28, 0x18, 0xFB, 0x28, 0x17, 0xFC, 0x28, 0x15, 0xFE, 0x20,
  0x2A, 0x02, 0x28, 0x1D, 0xF6, 0x28, 0x17, 0xFC, 0x28, 0x21, 0xEF, 0x32, 0x81, 0x5F, 0xC0,
  // ")" (U+0029)
  0x81, 0xCF, 0x52, 0x82, 0x3F, 0xE1, 0x28, 0x1C, 0xF7, 0x28, 0x16, 0xFD, 0x20, 0x2A, 0x02, 0x28,
  0x1E, 0xF5, 0x28, 0x1C, 0xF7, 0x28, 0x1B, 0xF8, 0x28, 0x1B, 0xF8, 0x28, 0x1C, 0xF7, 0x28, 0x3E,
  0xF5, 0x02, 0xA8, 0x31, 0x06, 0xFD, 0x28, 0x92, 0xCF, 0x60, 0x3F, 0xE1, 0x0C, 0xF5, 0x20,
  // "*" (U+002A)
  0x38, 0x19, 0xF6, 0x68, 0x18, 0xF5, 0x38, 0x90, 0x39, 0x58, 0xF5, 0x6A, 0x18, 0xF8, 0x24, 0x14,
  0x7A, 0x82, 0xE6, 0x41, 0x28, 0x3B, 0xFA, 0xF8, 0x38, 0x56, 0xFA, 0x0D, 0xF3, 0x38, 0x37, 0x20,
  0x55, 0x20,
  // "+" (U+002B)
  0x38, 0x18, 0xF6, 0x68, 0x18, 0xF6, 0x68, 0x18, 0xF6, 0x30, 0xF1, 0x85, 0x9F, 0x71, 0x10, 0xBF,
  0x08, 0x0B, 0xF0, 0x83, 0x81, 0x8F, 0x66, 0x81, 0x8F, 0x66, 0x81, 0x8F, 0x63,
  // "," (U+002C)
  0x18, 0x59, 0xFE, 0x0C, 0xFA, 0x1A, 0x05, 0x02, 0xA8, 0x21, 0x6F, 0x91,
  // "-" (U+002D)
  0x18, 0x01, 0x11, 0x04, 0xD0, 0x10, 0x4D, 0x01,
  // "." (U+002E)
  0x18, 0x2B, 0xE9, 0x3B, 0x18, 0x1B, 0xE8,
  // "/" (U+002F)
  0x48, 0x16, 0xFC, 0x48, 0x1C, 0xF6, 0x30, 0x3A, 0x01, 0x38, 0x19, 0xFA, 0x48, 0x1E, 0xF4, 0x38,
  0x15, 0xFD, 0x48, 0x1B, 0xF8, 0x30, 0x1A, 0x02, 0x38, 0x17, 0xFB, 0x48, 0x1D, 0xF6, 0x38, 0x13,
  0xFE, 0x48, 0x19, 0xF9, 0x48, 0x1E, 0xF3, 0x40,
  // "0" (U+0030)
  0x28, 0x41, 0x9E, 0xFD, 0x74, 0x0C, 0xD0, 0x92, 0x06, 0xA8, 0x16, 0x2B, 0xA8, 0x33, 0x0B, 0xFC,
  0x20, 0xCA, 0x85, 0x80, 0xEF, 0x80, 0x7B, 0x0B, 0x1A, 0x86, 0x72, 0xEE, 0xCF, 0xD1, 0xA8, 0x56,
  0xBF, 0x6A, 0xFD, 0x1A, 0x87, 0xCF, 0xB0, 0xAF, 0xD0, 0xEB, 0x85, 0x20, 0xCF, 0xB0, 0xBA, 0x07,
  0x28, 0x3E, 0xF8, 0x06, 0xA8, 0x17, 0x29, 0xA0, 0x32, 0x0C, 0xD0, 0xA3, 0x84, 0x19, 0xDF, 0xD7,
  0x20,
  // "1" (U+0031)
  0x20, 0x20, 0xBA, 0x01, 0x20, 0x10, 0x8C, 0x01, 0x20, 0x8D, 0x01, 0x28, 0x21, 0xEA, 0x8A, 0x01,
  0x38, 0x11, 0x07, 0xA0, 0x15, 0x07, 0xA0, 0x15, 0x07, 0xA0, 0x15, 0x07, 0xA0, 0x15, 0x07, 0xA0,
  0x15, 0x07, 0xA0, 0x15, 0x08, 0xA0, 0x23, 0x0D, 0xD0, 0xE0, 0x71, 0xF0, 0x80,
  // "2" (U+0032)
  0x18, 0x74, 0xAE, 0xFD, 0x91, 0x09, 0xE8, 0x6D, 0x05, 0xFB, 0x42, 0x9A, 0x81, 0x60, 0x43, 0x01,
  0xA0, 0x95, 0x03, 0xA0, 0x85, 0x0A, 0xA0, 0x34, 0x06, 0xA0, 0x94, 0x05, 0xA0, 0xC4, 0x05, 0xA0,
  0xB4, 0x04, 0xA0, 0xA4, 0x04, 0xA0, 0xB8, 0x01, 0x10, 0xEF, 0xFB,
  // "3" (U+0033)
  0x18, 0x76, 0xBE, 0xFD, 0x91, 0x08, 0xE0, 0xC2, 0x83, 0xB7, 0x32, 0xAA, 0x02, 0x50, 0x4A, 0x02,
  0x48, 0x22, 0xBF, 0xB3, 0x0D, 0xB0, 0x90, 0x13, 0x0D, 0xB0, 0xC0, 0x53, 0x82, 0x12, 0x4B, 0xA0,
  0x35, 0x01, 0xA0, 0x85, 0x02, 0xA8, 0x58, 0x97, 0x42, 0x3B, 0xA0, 0x50, 0xBE, 0x87, 0xB0, 0x4A,
  0xDE, 0xEC, 0x72,
  // "4" (U+0034)
  0x50, 0x5A, 0x06, 0x60, 0x10, 0xDA, 0x06, 0x60, 0x9B, 0x06, 0x58, 0x13, 0xFB, 0xA0, 0x65, 0x81,
  0xDF, 0x3A, 0x06, 0x48, 0x18, 0xF9, 0x1A, 0x06, 0x38, 0x33, 0xFE, 0x11, 0xA0, 0x63, 0x83, 0xCF,
  0x60, 0x1A, 0x06, 0x20, 0x4F, 0xA0, 0x10, 0x4F, 0xA8, 0x51, 0x01, 0x11, 0x12, 0xA0, 0x70, 0x16,
  0x01, 0xA0, 0x67, 0x01, 0xA0, 0x62,
  // "5" (U+0035)
  0x10, 0xED, 0x0B, 0x2E, 0x81, 0xB0, 0x1A, 0x85, 0x84, 0x44, 0x30, 0x2A, 0x05, 0x50, 0x4A, 0x81,
  0x64, 0x33, 0x05, 0xD8, 0x6D, 0x20, 0x4E, 0xEC, 0xEA, 0x0D, 0x60, 0xBA, 0x04, 0x50, 0x5A, 0x06,
  0x50, 0x6A, 0x85, 0x58, 0x95, 0x46, 0xEA, 0x01, 0x09, 0xE8, 0x76, 0x04, 0xAD, 0xFE, 0xA3, 0x20,
  // "6" (U+0036)
  0x28, 0x41, 0x7C, 0xEF, 0xD2, 0x03, 0x0E, 0xC0, 0xE2, 0x87, 0xDF, 0xE7, 0x32, 0x20, 0x6A, 0x03,
  0x58, 0x92, 0xBF, 0xB6, 0xDF, 0xC4, 0x0E, 0xFD, 0xD0, 0x1B, 0x81, 0x92, 0x7A, 0x08, 0xA0, 0xD3,
  0x84, 0xEF, 0xBE, 0xFB, 0x38, 0x4D, 0xFC, 0xBF, 0xD3, 0x82, 0xEF, 0xA5, 0xA8, 0x18, 0x28, 0xA8,
  0x16, 0x0A, 0xD0, 0xC3, 0x84, 0x7D, 0xFD, 0x91, 0x10,
  // "7" (U+0037)
  0x01, 0xF9, 0x0E, 0x01, 0xF9, 0x0D, 0x18, 0x01, 0x10, 0x4A, 0x08, 0x60, 0x9A, 0x01, 0x58, 0x21,
  0xEF, 0xA6, 0x07, 0xA0, 0x36, 0x81, 0xDF, 0xC6, 0x05, 0xA0, 0x66, 0x81, 0xCF, 0xE6, 0x03, 0xA0,
  0x86, 0x0A, 0xA0, 0x15, 0x02, 0xA0, 0xA6, 0x08, 0xA0, 0x44,
  // "8" (U+0038)
  0x18, 0x90, 0x29, 0xEF, 0xD8, 0x10, 0x1E, 0xD8, 0x1C, 0x07, 0xA8, 0x17, 0x29, 0xA0, 0x40, 0x7A,
  0x81, 0x10, 0x4A, 0x04, 0x03, 0xA8, 0x39, 0x1B, 0xFE, 0x20, 0x7C, 0x0E, 0x03, 0x20, 0x30, 0xEB,
  0x0A, 0x20, 0x3A, 0x0C, 0x08, 0xA8, 0x3C, 0x0B, 0xFD, 0x20, 0x3A, 0x82, 0x7E, 0xF9, 0x38, 0x7C,
  0xFA, 0xCF, 0xE4, 0x26, 0xA0, 0x80, 0x5E, 0x89, 0x0E, 0x10, 0x4B, 0xEF, 0xD9, 0x11,
  // "9" (U+0039)
  0x18, 0x43, 0xAE, 0xFC, 0x62, 0x03, 0xE8, 0x17, 0x0A, 0xA8, 0x15, 0x29, 0xA8, 0x22, 0xEF, 0xB3,
  0xA0, 0x8A, 0x0A, 0x38, 0x7E, 0xFB, 0xDF, 0xE3, 0x08, 0xA0, 0xC0, 0x6D, 0x83, 0xEF, 0xB0, 0x8A,
  0x83, 0xE6, 0xDF, 0xA3, 0x81, 0x10, 0x1A, 0x07, 0x50, 0x9A, 0x84, 0x30, 0x32, 0x39, 0xA8, 0x1A,
  0x02, 0xD8, 0x2C, 0x10, 0x1A, 0x81, 0xEB, 0x63,
  // ":" (U+003A)
  0x18, 0x2B, 0xE9, 0x3B, 0x18, 0x1B, 0xE8, 0x77, 0x38, 0x2B, 0xE9, 0x3B, 0x18, 0x1B, 0xE8,
  // ";" (U+003B)
  0x18, 0x46, 0xED, 0x10, 0xCA, 0x84, 0x50, 0x6E, 0xC1, 0x77, 0x75, 0x81, 0x9F, 0xE2, 0x81, 0xCF,
  0xA2, 0xA8, 0x15, 0x02, 0xA8, 0x31, 0x06, 0xF9, 0x20,
  // "<" (U+003C)
  0x70, 0x70, 0x65, 0x82, 0x7E, 0xF7, 0x30, 0x60, 0xEA, 0x83, 0x91, 0x06, 0xDA, 0x09, 0x01, 0x20,
  0x4A, 0x0D, 0x02, 0x40, 0x10, 0x9A, 0x0D, 0x07, 0x50, 0x20, 0x9A, 0x81, 0xE8, 0x14, 0x01, 0x08,
  0xA0, 0x76, 0x81, 0x18, 0x60,
  // "=" (U+003D)
  0x0B, 0xF0, 0x80, 0xBF, 0x08, 0x80, 0x41, 0x18, 0x04, 0x11, 0x0B, 0xF0, 0x80, 0xBF, 0x08,
  // ">" (U+003E)
  0x06, 0x07, 0x78, 0x27, 0xFE, 0x75, 0x01, 0x09, 0xA0, 0xE0, 0x65, 0x01, 0x09, 0xA0, 0xD0, 0x65,
  0x02, 0x0D, 0xA0, 0x43, 0x07, 0x0D, 0xA8, 0x39, 0x11, 0x8E, 0xA0, 0x90, 0x12, 0x07, 0xA0, 0x80,
  0x14, 0x81, 0x68, 0x16,
  // "?" (U+003F)
  0x18, 0x76, 0xBE, 0xFD, 0x91, 0x05, 0xE0, 0xC2, 0x83, 0xB8, 0x32, 0x9A, 0x04, 0x50, 0x3A, 0x04,
  0x50, 0xAA, 0x01, 0x30, 0x10, 0xBA, 0x06, 0x48, 0x2C, 0xFE, 0x44, 0x03, 0xA0, 0x35, 0x81, 0x3B,
  0xB7, 0x71, 0x82, 0x5E, 0xD2, 0x50, 0xAA, 0x07, 0x58, 0x25, 0xED, 0x23,
  // "@" (U+0040)
  0x38, 0x46, 0xCE, 0xEA, 0x24, 0x86, 0xBE, 0x73, 0x3B, 0xE3, 0x28, 0x19, 0xF3, 0x48, 0xA0, 0xBD,
  0x02, 0xF9, 0x1B, 0xFE, 0xA4, 0xF5, 0x8F, 0x39, 0xC8, 0xE1, 0x1F, 0x9C, 0xE0, 0xFD, 0x1C, 0xE0,
  0xFB, 0xED, 0x2F, 0x80, 0xDD, 0x0F, 0xCF, 0xC3, 0xF7, 0x0E, 0xC1, 0xFB, 0xEC, 0x1F, 0xB5, 0xFE,
  0x6F, 0x8C, 0xE0, 0xCA, 0x0E, 0xB8, 0x95, 0x28, 0xF3, 0x3E, 0xD1, 0xBE, 0x60, 0x1E, 0xB7, 0x28,
  0x65, 0xFA, 0x20, 0x13, 0x74, 0x03, 0x0B, 0xC0, 0xA7, 0x02, 0x01, 0x40,
  // "A" (U+0041)
  0x30, 0x6B, 0x03, 0x60, 0xAB, 0x07, 0x68, 0x3E, 0xFC, 0xFB, 0x50, 0x3A, 0x05, 0xA5, 0x82, 0x7F,
  0xD1, 0xA0, 0x44, 0x85, 0xCF, 0x90, 0xCF, 0x84, 0xA8, 0x35, 0x09, 0xFD, 0x30, 0x5A, 0x81, 0x42,
  0x7A, 0x01, 0x20, 0x9F, 0x06, 0x20, 0xDF, 0x81, 0xA0, 0x2A, 0x05, 0x38, 0x39, 0xFE, 0x06, 0xA0,
  0x13, 0x05, 0xA8, 0x23, 0xAF, 0xD4, 0x01, 0xA0, 0x70,
  // "B" (U+0042)
  0x08, 0xC8, 0x3E, 0xB5, 0x08, 0xF8, 0x55, 0x8F, 0xD1, 0x25, 0xA8, 0x2B, 0x8F, 0xD3, 0x84, 0xDF,
  0xB8, 0xFD, 0x20, 0x3A, 0x07, 0x08, 0xE8, 0x1A, 0x08, 0xE8, 0x6B, 0x18, 0xFD, 0x11, 0x5A, 0x82,
  0xB8, 0xFD, 0x30, 0xAA, 0x81, 0x8F, 0xD3, 0x0B, 0xA8, 0x48, 0xFD, 0x11, 0x5A, 0x0D, 0x08, 0xF0,
  0x50, 0x8C, 0x81, 0xEB, 0x41,
  // "C" (U+0043)
  0x38, 0x51, 0x8C, 0xEE, 0xC7, 0x20, 0x30, 0xED, 0x89, 0x3B, 0x01, 0xEF, 0xE6, 0x22, 0x63, 0x08,
  0xA0, 0x36, 0x81, 0xCF, 0xC7, 0xA0, 0x96, 0x01, 0xA0, 0x87, 0xA0, 0x97, 0x81, 0xEF, 0xB7, 0x0A,
  0xA0, 0x26, 0x03, 0xA8, 0x4D, 0x42, 0x36, 0x62, 0x08, 0xE0, 0x93, 0x85, 0x4B, 0xEF, 0xDA, 0x40,
  // "D" (U+0044)
  0x02, 0xC8, 0x1E, 0xB5, 0x30, 0x2F, 0x09, 0x20, 0x2A, 0x82, 0x71, 0x3B, 0xA8, 0x15, 0x02, 0xA0,
  0x63, 0x83, 0xDF, 0xC0, 0x2A, 0x06, 0x30, 0x9A, 0x01, 0x02, 0xA0, 0x63, 0x06, 0xA0, 0x30, 0x2A,
  0x06, 0x30, 0x6A, 0x03, 0x02, 0xA0, 0x63, 0x07, 0xA0, 0x02, 0xA0, 0x63, 0x09, 0xA1, 0x02, 0xA0,
  0x62, 0x84, 0x1E, 0xFB, 0x02, 0xA8, 0x27, 0x14, 0xCA, 0x81, 0x40, 0x2F, 0x07, 0x20, 0x2C, 0x81,
  0xEA, 0x43,
  // "E" (U+0045)
  0x08, 0xF0, 0x08, 0xF8, 0x28, 0x8F, 0xE8, 0x01, 0x11, 0x81, 0x8F, 0xE6, 0x81, 0x8F, 0xE6, 0x08,
  0xF0, 0x40, 0x8F, 0x82, 0x48, 0xFE, 0x80, 0x11, 0x18, 0x18, 0xFE, 0x68, 0x18, 0xFE, 0x68, 0x18,
  0xFE, 0x80, 0x11, 0x10, 0x8F, 0x00, 0x8F, 0x08,
  // "F" (U+0046)
  0x08, 0xF0, 0x08, 0xF8, 0x28, 0x8F, 0xE8, 0x01, 0x11, 0x81, 0x8F, 0xE6, 0x81, 0x8F, 0xE6, 0x81,
  0x8F, 0xE8, 0x01, 0x11, 0x08, 0xF0, 0x40, 0x8F, 0x82, 0x48, 0xFE, 0x68, 0x18, 0xFE, 0x68, 0x18,
  0xFE, 0x68, 0x18, 0xFE, 0x68, 0x18, 0xFE, 0x60,
  // "G" (U+0047)
  0x38, 0x55, 0xBE, 0xFD, 0xA5, 0x20, 0xAE, 0x81, 0x90, 0x6A, 0x89, 0x0C, 0x42, 0x38, 0x20, 0xEF,
  0xD6, 0x03, 0xA0, 0x76, 0x05, 0xA0, 0x42, 0x80, 0x01, 0x06, 0xA8, 0x12, 0x02, 0xC0, 0x6A, 0x81,
  0x30, 0x2C, 0x04, 0xA0, 0x63, 0x05, 0xA1, 0x81, 0xEF, 0xC3, 0x05, 0xA1, 0x08, 0xA8, 0x2A, 0x32,
  0x7A, 0x20, 0xCF, 0x38, 0x57, 0xCE, 0xFD, 0xB6,
  // "H" (U+0048)
  0x02, 0xA0, 0x63, 0x09, 0xA0, 0x2A, 0x06, 0x30, 0x9A, 0x02, 0xA0, 0x63, 0x09, 0xA0, 0x2A, 0x06,
  0x30, 0x9A, 0x02, 0xA0, 0x63, 0x09, 0xA0, 0x2F, 0xA0, 0x2F, 0xA0, 0x2A, 0x83, 0x71, 0x11, 0xAA,
  0x02, 0xA0, 0x63, 0x09, 0xA0, 0x2A, 0x06, 0x30, 0x9A, 0x02, 0xA0, 0x63, 0x09, 0xA0, 0x2A, 0x06,
  0x30, 0x9A, 0x02, 0xA0, 0x63, 0x09, 0xA0,
  // "I" (U+0049)
  0x05, 0xF0, 0x20, 0x5F, 0x02, 0x28, 0x32, 0xEF, 0xA2, 0x58, 0x1D, 0xF9, 0x68, 0x1D, 0xF9, 0x68,
  0x1D, 0xF9, 0x68, 0x1D, 0xF9, 0x68, 0x1D, 0xF9, 0x68, 0x1D, 0xF9, 0x68, 0x1D, 0xF9, 0x68, 0x1D,
  0xFA, 0x30, 0x40, 0xDD, 0x81, 0xD2, 0x5F, 0x02,
  // "J" (U+004A)
  0x58, 0x1B, 0xFC, 0x58, 0x1B, 0xFC, 0x58, 0x1B, 0xFC, 0x58, 0x1B, 0xFC, 0x58, 0x1B, 0xFC, 0x58,
  0x1B, 0xFC, 0x58, 0x1B, 0xFC, 0x58, 0x1B, 0xFC, 0x58, 0x1B, 0xFC, 0x58, 0x6E, 0xFB, 0x46, 0x44,
  0xAA, 0x00, 0x7D, 0x87, 0xD1, 0x4D, 0xEF, 0xD9, 0x11,
  // "K" (U+004B)
  0x02, 0xA0, 0x52, 0x83, 0x1E, 0xFC, 0x2A, 0x05, 0x20, 0xAA, 0x00, 0x2A, 0x81, 0x50, 0x4A, 0x81,
  0x70, 0x2A, 0x83, 0x50, 0xDF, 0xB2, 0x02, 0xA8, 0x35, 0x9F, 0xE2, 0x20, 0x2A, 0x08, 0xA0, 0x63,
  0x02, 0xD0, 0x73, 0x02, 0xB8, 0x2E, 0xFE, 0x12, 0x02, 0xA0, 0xA0, 0x2A, 0x09, 0x20, 0x2A, 0x81,
  0x50, 0x9A, 0x81, 0x20, 0x2A, 0x81, 0x50, 0x1A, 0x81, 0xA0, 0x2A, 0x05, 0x20, 0x8A, 0x03, 0x02,
  0xA0, 0x52, 0x82, 0x1E, 0xFC,
  // "L" (U+004C)
  0x05, 0xA0, 0x35, 0x05, 0xA0, 0x35, 0x05, 0xA0, 0x35, 0x05, 0xA0, 0x35, 0x05, 0xA0, 0x35, 0x05,
  0xA0, 0x35, 0x05, 0xA0, 0x35, 0x05, 0xA0, 0x35, 0x05, 0xA0, 0x35, 0x05, 0xA0, 0x35, 0x05, 0xA8,
  0x57, 0x44, 0x44, 0x25, 0xF0, 0x80, 0x5F, 0x08,
  // "M" (U+004D)
  0x04, 0xB8, 0x15, 0x05, 0xB0, 0x10, 0x4B, 0x81, 0x70, 0x8B, 0x8B, 0x51, 0x4F, 0xEF, 0x90, 0xBF,
  0xEF, 0x14, 0xFB, 0xFB, 0x0D, 0xCE, 0xF1, 0x4F, 0xBD, 0xE1, 0xFA, 0xA8, 0x71, 0x4F, 0xDB, 0xF4,
  0xF8, 0xA8, 0x71, 0x4F, 0xE8, 0xF9, 0xF6, 0xA8, 0x71, 0x4F, 0xE5, 0xFE, 0xF4, 0xA0, 0x10, 0x4A,
  0x02, 0xA0, 0xE0, 0x3A, 0x01, 0x04, 0xA1, 0x82, 0xEF, 0xB4, 0xA0, 0x10, 0x4A, 0x40, 0x4A, 0x01,
  0x04, 0xA0, 0x13, 0x04, 0xA0, 0x10, 0x4A, 0x01, 0x30, 0x4A, 0x01,
  // "N" (U+004E)
  0x02, 0xB0, 0x82, 0x05, 0xA0, 0x2B, 0x0D, 0x20, 0x5A, 0x02, 0xA8, 0x3E, 0xF2, 0x05, 0xA0, 0x2A,
  0x83, 0xAF, 0x70, 0x5A, 0x02, 0xA8, 0x36, 0xFC, 0x05, 0xA0, 0x2A, 0x02, 0xA0, 0x10, 0x5A, 0x02,
  0xA8, 0x31, 0xAF, 0x65, 0xA0, 0x2A, 0x83, 0x15, 0xFB, 0x5A, 0x02, 0xA0, 0x01, 0xA0, 0x6A, 0x02,
  0xA8, 0x31, 0x0B, 0xFA, 0xA0, 0x2A, 0x83, 0x10, 0x6F, 0xEA, 0x02, 0xA8, 0x11, 0x01, 0xC0, 0x2A,
  0x01, 0x20, 0xBB,
  // "O" (U+004F)
  0x28, 0x52, 0xAE, 0xFD, 0x81, 0x30, 0x20, 0xED, 0x0C, 0x30, 0xAA, 0x81, 0x52, 0x8A, 0x81, 0x70,
  0x1A, 0x09, 0x38, 0x3C, 0xFD, 0x04, 0xA0, 0x53, 0x08, 0xA0, 0x10, 0x6A, 0x03, 0x30, 0x6A, 0x03,
  0x06, 0xA0, 0x33, 0x06, 0xA0, 0x30, 0x6A, 0x03, 0x30, 0x6A, 0x03, 0x04, 0xA0, 0x53, 0x08, 0xA0,
  0x01, 0xA0, 0x93, 0x81, 0xCF, 0xD2, 0x0A, 0xA8, 0x15, 0x28, 0xA0, 0x72, 0x02, 0x0E, 0xD0, 0xC4,
  0x85, 0x2A, 0xEF, 0xD8, 0x12,
  // "P" (U+0050)
  0x08, 0xC8, 0x3E, 0xB5, 0x08, 0xF8, 0x93, 0x58, 0xFE, 0x11, 0x4E, 0xFD, 0x8F, 0xE3, 0x09, 0xA8,
  0x18, 0xFE, 0x30, 0x9A, 0x81, 0x8F, 0xE2, 0x83, 0x4E, 0xFC, 0x8F, 0x05, 0x08, 0xD8, 0x6C, 0x50,
  0x8F, 0xE1, 0x14, 0x81, 0x8F, 0xE6, 0x81, 0x8F, 0xE6, 0x81, 0x8F, 0xE6, 0x81, 0x8F, 0xE6,
  // "Q" (U+0051)
  0x28, 0x52, 0xAE, 0xFD, 0x81, 0x30, 0x20, 0xED, 0x0C, 0x30, 0xAA, 0x81, 0x52, 0x8A, 0x81, 0x70,
  0x1A, 0x09, 0x38, 0x3C, 0xFD, 0x04, 0xA0, 0x53, 0x08, 0xA0, 0x10, 0x6A, 0x03, 0x30, 0x6A, 0x03,
  0x06, 0xA0, 0x33, 0x06, 0xA0, 0x30, 0x6A, 0x03, 0x30, 0x6A, 0x03, 0x04, 0xA0, 0x53, 0x08, 0xA0,
  0x01, 0xA0, 0x93, 0x81, 0xCF, 0xD2, 0x0A, 0xA8, 0x15, 0x28, 0xA0, 0x72, 0x02, 0x0E, 0xD0, 0xC4,
  0x81, 0x2A, 0xEB, 0x01, 0x70, 0x2A, 0x08, 0x71, 0x09, 0xA0, 0x17, 0x02, 0xA0, 0x91,
  // "R" (U+0052)
  0x08, 0xB8, 0x1E, 0xC7, 0x30, 0x8E, 0x0B, 0x20, 0x8A, 0x81, 0x23, 0xBA, 0x81, 0x40, 0x8A, 0x20,
  0x2A, 0x81, 0x80, 0x8A, 0x20, 0x2A, 0x81, 0x70, 0x8A, 0x10, 0x10, 0xAA, 0x81, 0x40, 0x8E, 0x0A,
  0x20, 0x8D, 0x0A, 0x30, 0x8A, 0x82, 0x2B, 0xFD, 0x30, 0x8A, 0x10, 0x2A, 0x07, 0x20, 0x8A, 0x28,
  0x49, 0xFE, 0x10, 0x8A, 0x28, 0x41, 0xEF, 0xA0, 0x8A, 0x30, 0x7A, 0x03,
  // "S" (U+0053)
  0x18, 0x90, 0x18, 0xDF, 0xEC, 0x82, 0x0D, 0xE0, 0x40, 0x5A, 0x85, 0x92, 0x36, 0xA0, 0x7A, 0x03,
  0x50, 0x4A, 0x0A, 0x60, 0xBA, 0x0E, 0x06, 0x50, 0x9B, 0x0D, 0x04, 0x40, 0x30, 0xBB, 0x04, 0x50,
  0x5A, 0x0A, 0x68, 0x7E, 0xFB, 0xA8, 0x42, 0x27, 0xA0, 0x90, 0xBE, 0x89, 0x0D, 0x14, 0xAD, 0xEE,
  0xD8, 0x11,
  // "T" (U+0054)
  0x07, 0xFA, 0x04, 0x07, 0xFA, 0x86, 0x40, 0x11, 0x1E, 0xFB, 0x0F, 0x15, 0x81, 0xEF, 0xA7, 0x18,
  0x1E, 0xFA, 0x71, 0x81, 0xEF, 0xA7, 0x18, 0x1E, 0xFA, 0x71, 0x81, 0xEF, 0xA7, 0x18, 0x1E, 0xFA,
  0x71, 0x81, 0xEF, 0xA7, 0x18, 0x1E, 0xFA, 0x71, 0x81, 0xEF, 0xA7, 0x18, 0x1E, 0xFA, 0x40,
  // "U" (U+0055)
  0x02, 0xA0, 0x63, 0x09, 0xA0, 0x2A, 0x06, 0x30, 0x9A, 0x02, 0xA0, 0x63, 0x09, 0xA0, 0x2A, 0x06,
  0x30, 0x9A, 0x02, 0xA0, 0x63, 0x09, 0xA0, 0x2A, 0x06, 0x30, 0x9A, 0x02, 0xA0, 0x63, 0x09, 0xA0,
  0x2A, 0x06, 0x30, 0x9A, 0x02, 0xA0, 0x73, 0x0A, 0xA0, 0x1A, 0x09, 0x38, 0x3D, 0xFD, 0x0C, 0xA8,
  0x17, 0x48, 0xA8, 0x19, 0x04, 0xE0, 0xE0, 0x12, 0x85, 0x3B, 0xEF, 0xD9, 0x11,
  // "V" (U+0056)
  0x81, 0xAF, 0xE4, 0x02, 0xA0, 0x70, 0x5A, 0x02, 0x30, 0x6A, 0x02, 0x01, 0xA0, 0x63, 0x81, 0xAF,
  0xD2, 0x81, 0xCF, 0xA3, 0x81, 0xDF, 0x92, 0x81, 0x8F, 0xE2, 0x01, 0xA0, 0x52, 0x03, 0xA8, 0x12,
  0x05, 0xA4, 0x85, 0xEF, 0x60, 0x9F, 0xB4, 0x85, 0xAF, 0xA0, 0xDF, 0x74, 0x81, 0x5F, 0xE1, 0xA0,
  0x24, 0x01, 0xA8, 0x15, 0xFD, 0x68, 0x3C, 0xFB, 0xF9, 0x60, 0x7B, 0x04, 0x60, 0x3B, 0x40,
  // "W" (U+0057)
  0x81, 0xCF, 0x75, 0x84, 0xAF, 0x9A, 0xF9, 0x58, 0x4B, 0xF8, 0x9F, 0xA5, 0x89, 0x7D, 0xF7, 0x8F,
  0xB0, 0xEF, 0xB0, 0xEF, 0x57, 0xFD, 0x1A, 0x0D, 0x1A, 0x83, 0x46, 0xFE, 0x3B, 0x01, 0xA8, 0x73,
  0x5F, 0xE5, 0xFB, 0xF3, 0xA8, 0x72, 0x4F, 0xE7, 0xF7, 0xF6, 0xA0, 0x10, 0x3A, 0x83, 0x9F, 0x3F,
  0x9A, 0x10, 0x1A, 0x85, 0xCD, 0x0F, 0xBF, 0xE2, 0x98, 0x6E, 0xEA, 0x0D, 0xDF, 0xD2, 0xB8, 0x18,
  0x0B, 0xA0, 0xC2, 0x0D, 0xA8, 0x16, 0x09, 0xA0, 0xB1,
  // "X" (U+0058)
  0x02, 0xA0, 0x83, 0x81, 0xBF, 0xD2, 0x84, 0x8F, 0xE1, 0x04, 0xA0, 0x53, 0x85, 0xEF, 0x80, 0xBF,
  0xB4, 0x82, 0x6F, 0xE5, 0xA0, 0x35, 0x0C, 0xB0, 0x96, 0x04, 0xA0, 0xE0, 0x17, 0x81, 0xEF, 0xB7,
  0x06, 0xB0, 0x35, 0x84, 0x1E, 0xFD, 0xFC, 0x58, 0x29, 0xFD, 0x2A, 0x06, 0x30, 0x3A, 0x84, 0x50,
  0x9F, 0xE1, 0x28, 0x1B, 0xFC, 0x20, 0x1A, 0x81, 0x80, 0x5A, 0x04, 0x30, 0x8A, 0x02,
  // "Y" (U+0059)
  0x06, 0xA0, 0x43, 0x07, 0xA8, 0x33, 0x0E, 0xFB, 0x38, 0x1D, 0xFB, 0x20, 0x7A, 0x81, 0x20, 0x4A,
  0x04, 0x38, 0x5E, 0xF8, 0x0B, 0xFC, 0x48, 0x28, 0xFE, 0x2A, 0x05, 0x40, 0x1A, 0x81, 0xDF, 0xD6,
  0x09, 0xB0, 0x66, 0x02, 0xA0, 0xE7, 0x18, 0x1D, 0xFB, 0x71, 0x81, 0xDF, 0xB7, 0x18, 0x1D, 0xFB,
  0x71, 0x81, 0xDF, 0xB7, 0x18, 0x1D, 0xFB, 0x40,
  // "Z" (U+005A)
  0x01, 0xF0, 0x70, 0x1F, 0x89, 0x07, 0x01, 0x11, 0x1A, 0xFE, 0x14, 0x03, 0xA0, 0x75, 0x81, 0xBF,
  0xD5, 0x04, 0xA0, 0x55, 0x81, 0xDF, 0xC5, 0x06, 0xA0, 0x35, 0x81, 0xEF, 0xA5, 0x82, 0x8F, 0xE1,
  0x40, 0x1A, 0x85, 0x91, 0x11, 0x10, 0x8F, 0x00, 0x8F, 0x08,
  // "[" (U+005B)
  0x0D, 0xB0, 0x70, 0xDB, 0x87, 0x7D, 0xF6, 0x10, 0xDF, 0x52, 0x81, 0xDF, 0x52, 0x81, 0xDF, 0x52,
  0x81, 0xDF, 0x52, 0x81, 0xDF, 0x52, 0x81, 0xDF, 0x52, 0x81, 0xDF, 0x52, 0x81, 0xDF, 0x52, 0x81,
  0xDF, 0x52, 0x81, 0xDF, 0x52, 0x81, 0xDF, 0x52, 0x0D, 0xB0, 0x70, 0xDB, 0x07, 0x80, 0x01, 0x10,
  // "\" (U+005C)
  0x81, 0xCF, 0x64, 0x81, 0x6F, 0xC4, 0x01, 0xA0, 0x34, 0x81, 0xAF, 0x94, 0x81, 0x4F, 0xE5, 0x81,
  0xDF, 0x54, 0x81, 0x8F, 0xB4, 0x02, 0xA0, 0x14, 0x81, 0xBF, 0x74, 0x81, 0x6F, 0xD5, 0x81, 0xEF,
  0x34, 0x81, 0x9F, 0x94, 0x81, 0x3F, 0xE0,
  // "]" (U+005D)
  0x18, 0x00, 0x10, 0x7B, 0x0D, 0x07, 0xB0, 0xD2, 0x81, 0x5F, 0xD2, 0x81, 0x5F, 0xD2, 0x81, 0x5F,
  0xD2, 0x81, 0x5F, 0xD2, 0x81, 0x5F, 0xD2, 0x81, 0x5F, 0xD2, 0x81, 0x5F, 0xD2, 0x81, 0x5F, 0xD2,
  0x81, 0x5F, 0xD2, 0x81, 0x5F, 0xD2, 0x87, 0x5F, 0xD0, 0x16, 0xFD, 0x7B, 0x0D, 0x07, 0xB0, 0xD0,
  // "^" (U+005E)
  0x48, 0x19, 0xF2, 0x60, 0x1A, 0x0A, 0x60, 0x9B, 0x03, 0x48, 0x41, 0xFE, 0x7F, 0xB4, 0x85, 0x8F,
  0x80, 0xDF, 0x32, 0x86, 0x1E, 0xE1, 0x05, 0xFB, 0x28, 0x18, 0xF8, 0x38, 0x5C, 0xF4, 0x1E, 0xF1,
  0x38, 0x14, 0xFC,
  // "_" (U+005F)
  0x80, 0x71, 0xFB, 0x0C, 0xFB, 0x0C,
  // "`" (U+0060)
  0x04, 0xA0, 0x92, 0x05, 0xA0, 0x32, 0x81, 0x4E, 0xD0,
  // "a" (U+0061)
  0x89, 0x01, 0x7C, 0xEE, 0xD9, 0x20, 0x3E, 0x86, 0xE1, 0x08, 0x52, 0x27, 0xA0, 0x76, 0x85, 0xDF,
  0x90, 0x7C, 0xEC, 0x09, 0x0A, 0xF0, 0x9A, 0x85, 0xB3, 0x11, 0xDF, 0x9A, 0x82, 0xA2, 0x27, 0xA0,
  0x90, 0xBC, 0x89, 0x3E, 0xDF, 0x91, 0xAE, 0xEB, 0x37, 0xF9,
  // "b" (U+0062)
  0xA0, 0x86, 0xA0, 0x86, 0xA0, 0x86, 0xA0, 0x86, 0xA8, 0x47, 0x7D, 0xFC, 0x41, 0xA0, 0xDD, 0x03,
  0xB8, 0x17, 0x27, 0xA0, 0xAA, 0x0B, 0x38, 0x1C, 0xFE, 0xA0, 0x93, 0x09, 0xC0, 0x93, 0x09, 0xC0,
  0xC3, 0x81, 0xCF, 0xEB, 0x81, 0x72, 0x7A, 0x0A, 0xF9, 0x02, 0xA8, 0x43, 0x8D, 0xEC, 0x41,
  // "c" (U+0063)
  0x28, 0x76, 0xCE, 0xFD, 0x92, 0x09, 0xD8, 0x1E, 0x03, 0xA8, 0x5C, 0x42, 0x45, 0x08, 0xA0, 0x35,
  0x81, 0xAF, 0xE6, 0x81, 0xBF, 0xE6, 0x09, 0xA0, 0x25, 0x05, 0xA8, 0x3C, 0x42, 0x49, 0x20, 0xBE,
  0x38, 0x47, 0xCE, 0xFD, 0x81,
  // "d" (U+0064)
  0x78, 0x1B, 0xFC, 0x78, 0x1B, 0xFC, 0x78, 0x1B, 0xFC, 0x78, 0x1B, 0xFC, 0x28, 0x90, 0x5C, 0xFD,
  0x6A, 0xFC, 0x05, 0xD8, 0x3D, 0xFC, 0x0D, 0xA8, 0x16, 0x26, 0xA0, 0xC0, 0x2A, 0x09, 0x38, 0x2B,
  0xFC, 0x3A, 0x06, 0x38, 0x29, 0xFC, 0x3A, 0x06, 0x38, 0x28, 0xFC, 0x2A, 0x08, 0x38, 0x90, 0xBF,
  0xC0, 0xDF, 0xE5, 0x26, 0xA8, 0x1C, 0x06, 0xD8, 0x1D, 0xFC, 0x28, 0x66, 0xDF, 0xC4, 0x5F, 0xC0,
  // "e" (U+0065)
  0x18, 0x90, 0x19, 0xDF, 0xD9, 0x10, 0x1D, 0xD8, 0x1D, 0x19, 0xA8, 0x95, 0x62, 0x5E, 0xF7, 0xEF,
  0xA1, 0x11, 0x9F, 0xCF, 0x90, 0xDF, 0x98, 0x2E, 0xDF, 0x96, 0x08, 0xA8, 0x68, 0x32, 0x36, 0x50,
  0xCE, 0x09, 0x28, 0x57, 0xCE, 0xFD, 0xA4,
  // "f" (U+0066)
  0x38, 0x51, 0x8D, 0xFE, 0xC3, 0x30, 0xAD, 0x01, 0x3A, 0x82, 0xC3, 0x24, 0x30, 0x2A, 0x07, 0x48,
  0x16, 0xBE, 0xD8, 0x19, 0x0C, 0xF8, 0x39, 0x01, 0x14, 0xA0, 0x70, 0xF1, 0x30, 0x2A, 0x06, 0x60,
  0x2A, 0x06, 0x60, 0x2A, 0x06, 0x60, 0x2A, 0x06, 0x60, 0x2A, 0x06, 0x60, 0x2A, 0x06, 0x60, 0x2A,
  0x06, 0x40,
  // "g" (U+0067)
  0x28, 0x90, 0x6D, 0xFC, 0x45, 0xFC, 0x05, 0xD8, 0x90, 0xDF, 0xC0, 0xDF, 0xE5, 0x27, 0xA0, 0xC0,
  0x2A, 0x09, 0x38, 0x2D, 0xFC, 0x3A, 0x06, 0x38, 0x2A, 0xFC, 0x3A, 0x06, 0x38, 0x2A, 0xFC, 0x2A,
  0x09, 0x38, 0x90, 0xCF, 0xC0, 0xDF, 0xE5, 0x27, 0xA8, 0x1C, 0x06, 0xD8, 0x1E, 0xFC, 0x28, 0x66,
  0xDF, 0xD5, 0xCF, 0xC7, 0x89, 0x0E, 0xFB, 0x06, 0x73, 0x22, 0x8A, 0x81, 0x70, 0x9E, 0x0C, 0x28,
  0x55, 0xBE, 0xFE, 0xC7, 0x20,
  // "h" (U+0068)
  0xA0, 0x96, 0xA0, 0x96, 0xA0, 0x96, 0xA0, 0x96, 0xA8, 0x48, 0x6D, 0xFC, 0x61, 0xA0, 0xDD, 0x05,
  0xB8, 0x18, 0x25, 0xA0, 0xBA, 0x0D, 0x38, 0x1C, 0xFD, 0xA0, 0xA3, 0x81, 0xAF, 0xEA, 0x09, 0x38,
  0x1A, 0xFE, 0xA0, 0x93, 0x81, 0xAF, 0xEA, 0x09, 0x38, 0x1A, 0xFE, 0xA0, 0x93, 0x81, 0xAF, 0xEA,
  0x09, 0x38, 0x1A, 0xFE,
  // "i" (U+0069)
  0x38, 0x27, 0xEC, 0x15, 0x0D, 0xA0, 0x35, 0x81, 0x7E, 0xC7, 0x50, 0x6D, 0x30, 0x6D, 0x50, 0x10,
  0xBA, 0x60, 0x9A, 0x60, 0x9A, 0x60, 0x9A, 0x60, 0x9A, 0x60, 0xAA, 0x01, 0x20, 0xA0, 0xDD, 0x81,
  0xEA, 0xEF, 0x0E,
  // "j" (U+006A)
  0x48, 0x21, 0xCE, 0x64, 0x05, 0xA0, 0xC4, 0x82, 0x1D, 0xE6, 0x73, 0x0A, 0xC0, 0xB2, 0x0A, 0xC0,
  0xB3, 0x83, 0x12, 0xEF, 0xB5, 0x81, 0xDF, 0xB5, 0x81, 0xDF, 0xB5, 0x81, 0xDF, 0xB5, 0x81, 0xDF,
  0xB5, 0x81, 0xDF, 0xB5, 0x81, 0xDF, 0xB5, 0x81, 0xEF, 0xB5, 0xA8, 0x4A, 0x26, 0x44, 0xBA, 0x08,
  0x04, 0xD8, 0x7E, 0x12, 0xCE, 0xFE, 0xA2, 0x10,
  // "k" (U+006B)
  0x81, 0xEF, 0xA7, 0x81, 0xEF, 0xA7, 0x81, 0xEF, 0xA7, 0x81, 0xEF, 0xA7, 0x81, 0xEF, 0xA2, 0x8A,
  0x52, 0xEF, 0xC0, 0xEF, 0xA0, 0x1D, 0xFD, 0x10, 0xEF, 0xA0, 0xCF, 0xE2, 0x28, 0x2E, 0xFA, 0x9A,
  0x04, 0x38, 0x1E, 0xFD, 0xA0, 0xD4, 0x0E, 0xD0, 0x83, 0x83, 0xEF, 0xE4, 0x7A, 0x03, 0x28, 0x1E,
  0xFA, 0x28, 0x1D, 0xFD, 0x28, 0x1E, 0xFA, 0x20, 0x3A, 0x83, 0x80, 0xEF, 0xA3, 0x09, 0xA0, 0x30,
  // "l" (U+006C)
  0x04, 0xC0, 0xE3, 0x03, 0x0E, 0xB0, 0xE5, 0x82, 0x2B, 0xFE, 0x68, 0x1A, 0xFE, 0x68, 0x1A, 0xFE,
  0x68, 0x1A, 0xFE, 0x68, 0x1A, 0xFE, 0x68, 0x1A, 0xFE, 0x68, 0x1A, 0xFE, 0x68, 0x1A, 0xFE, 0x68,
  0x1A, 0xFE, 0x68, 0x2B, 0xFE, 0x12, 0x0A, 0x0D, 0xD8, 0x1E, 0xAE, 0xF0, 0xE0,
  // "m" (U+006D)
  0x89, 0x47, 0xF6, 0xAF, 0xB1, 0xBE, 0x80, 0x7F, 0xEB, 0x0C, 0xB1, 0x86, 0x7F, 0xE2, 0xDF, 0xB3,
  0xA8, 0x63, 0x7F, 0xC0, 0xBF, 0x81, 0xA8, 0x63, 0x7F, 0xC0, 0xBF, 0x81, 0xA8, 0x64, 0x7F, 0xC0,
  0xBF, 0x81, 0xA8, 0x64, 0x7F, 0xC0, 0xBF, 0x81, 0xA8, 0x64, 0x7F, 0xC0, 0xBF, 0x81, 0xA8, 0x64,
  0x7F, 0xC0, 0xBF, 0x81, 0xA8, 0x64, 0x7F, 0xC0, 0xBF, 0x81, 0xA0, 0x40,
  // "n" (U+006E)
  0xA8, 0x42, 0x7D, 0xFD, 0x61, 0xA0, 0xDD, 0x05, 0xB8, 0x18, 0x26, 0xA0, 0xBA, 0x0D, 0x38, 0x1C,
  0xFD, 0xA0, 0xA3, 0x81, 0xAF, 0xEA, 0x09, 0x38, 0x1A, 0xFE, 0xA0, 0x93, 0x81, 0xAF, 0xEA, 0x09,
  0x38, 0x1A, 0xFE, 0xA0, 0x93, 0x81, 0xAF, 0xEA, 0x09, 0x38, 0x1A, 0xFE,
  // "o" (U+006F)
  0x28, 0x51, 0x9D, 0xFD, 0x91, 0x20, 0x20, 0xED, 0x82, 0xD1, 0x0B, 0xA8, 0x16, 0x27, 0xA0, 0x90,
  0x1A, 0x09, 0x38, 0x2C, 0xFE, 0x3A, 0x06, 0x30, 0x9A, 0x03, 0xA0, 0x63, 0x09, 0xA0, 0x1A, 0x09,
  0x38, 0x3C, 0xFD, 0x0B, 0xA8, 0x16, 0x27, 0xA8, 0x28, 0x02, 0xED, 0x0D, 0x38, 0x52, 0x9D, 0xFD,
  0x81, 0x10,
  // "p" (U+0070)
  0xA8, 0x42, 0x7D, 0xFC, 0x41, 0xA0, 0xDD, 0x03, 0xB8, 0x17, 0x27, 0xA0, 0xAA, 0x0B, 0x38, 0x1C,
  0xFE, 0xA0, 0x83, 0x0A, 0xC0, 0x93, 0x0A, 0xC0, 0xC3, 0x81, 0xCF, 0xEB, 0x81, 0x72, 0x7A, 0x0A,
  0xA0, 0xED, 0x02, 0xA8, 0x48, 0x7D, 0xFC, 0x31, 0xA0, 0x86, 0xA0, 0x86, 0xA0, 0x86, 0xA0, 0x86,
  // "q" (U+0071)
  0x28, 0x90, 0x6D, 0xFC, 0x54, 0xFC, 0x05, 0xD8, 0x3D, 0xFC, 0x0D, 0xA8, 0x16, 0x28, 0xA0, 0xC0,
  0x2A, 0x0A, 0x38, 0x2D, 0xFC, 0x3A, 0x07, 0x38, 0x2A, 0xFC, 0x3A, 0x07, 0x38, 0x2A, 0xFC, 0x2A,
  0x09, 0x38, 0x3C, 0xFC, 0x0D, 0xA8, 0x15, 0x27, 0xA8, 0x1C, 0x06, 0xD8, 0x1D, 0xFC, 0x28, 0x66,
  0xDF, 0xC5, 0xBF, 0xC7, 0x81, 0xBF, 0xC7, 0x81, 0xBF, 0xC7, 0x81, 0xBF, 0xC7, 0x81, 0xBF, 0xC0,
  // "r" (U+0072)
  0x10, 0xCB, 0x87, 0x63, 0xCF, 0xE5, 0x08, 0xDA, 0x0C, 0xC0, 0x13, 0x0A, 0xA8, 0x2D, 0x42, 0x34,
  0x0A, 0xA0, 0x37, 0x0A, 0xA7, 0x18, 0x1A, 0xFE, 0x71, 0x81, 0xAF, 0xE7, 0x83, 0x1B, 0xFE, 0x14,
  0x03, 0x0D, 0xD0, 0xE0, 0x52, 0x04, 0xF0, 0x72,
  // "s" (U+0073)
  0x18, 0x73, 0xAE, 0xFE, 0xC7, 0x12, 0xF0, 0x10, 0x6A, 0x85, 0x62, 0x36, 0x70, 0x5A, 0x0B, 0x03,
  0x50, 0xBB, 0x0D, 0x07, 0x40, 0x50, 0xCB, 0x0B, 0x50, 0x20, 0xBA, 0x85, 0x47, 0x84, 0x22, 0x9A,
  0x04, 0x08, 0xE8, 0x3E, 0x14, 0xBE, 0xA8, 0x1D, 0x92, 0x10,
  // "t" (U+0074)
  0x28, 0x11, 0x76, 0x68, 0x15, 0xFC, 0x68, 0x17, 0xFC, 0x40, 0x80, 0xCE, 0x07, 0xF9, 0x89, 0x07,
  0x22, 0xCF, 0xD2, 0x22, 0x12, 0x81, 0xCF, 0xC6, 0x81, 0xCF, 0xC6, 0x81, 0xCF, 0xC6, 0x81, 0xCF,
  0xD6, 0x0A, 0xA0, 0x70, 0xF3, 0x20, 0x5D, 0x09, 0x38, 0x45, 0xCE, 0xFD, 0x60,
  // "u" (U+0075)
  0x01, 0xA0, 0x83, 0x82, 0xCF, 0xC1, 0xA0, 0x83, 0x82, 0xCF, 0xC1, 0xA0, 0x83, 0x82, 0xCF, 0xC1,
  0xA0, 0x83, 0x82, 0xCF, 0xC1, 0xA0, 0x83, 0x82, 0xCF, 0xC1, 0xA0, 0x83, 0x82, 0xDF, 0xC1, 0xA0,
  0x92, 0x01, 0xA8, 0x6C, 0x0E, 0xFE, 0x43, 0xAA, 0x81, 0xC0, 0x8D, 0x81, 0xDF, 0xC2, 0x86, 0x8D,
  0xFC, 0x45, 0xFC,
  // "v" (U+0076)
  0x07, 0xA0, 0x53, 0x07, 0xA0, 0x30, 0x1A, 0x09, 0x38, 0x1C, 0xFD, 0x28, 0x1B, 0xFE, 0x20, 0x1A,
  0x08, 0x20, 0x5A, 0x81, 0x40, 0x6A, 0x02, 0x38, 0x5E, 0xF8, 0x0A, 0xFC, 0x48, 0x19, 0xFD, 0x1A,
  0x06, 0x40, 0x4A, 0x07, 0xA0, 0x15, 0x83, 0xDF, 0xDF, 0xA6, 0x08, 0xB0, 0x46, 0x02, 0xA0, 0xE4,
  // "w" (U+0077)
  0x81, 0xDF, 0x75, 0x84, 0x9F, 0xAB, 0xF8, 0x58, 0x97, 0xAF, 0x89, 0xF9, 0x0C, 0xF9, 0x0C, 0xF6,
  0x7F, 0xB1, 0xA8, 0xA6, 0xD0, 0xDF, 0x45, 0xFC, 0x3F, 0xEF, 0x0E, 0xF2, 0x3F, 0xD6, 0xFA, 0xF4,
  0xA2, 0xA8, 0x59, 0xF4, 0xF8, 0xFD, 0x28, 0x7E, 0xFD, 0xD1, 0xFC, 0xFB, 0x20, 0xCA, 0x81, 0xA0,
  0xDA, 0x09, 0x20, 0x9A, 0x81, 0x70, 0xAA, 0x06, 0x10,
  // "x" (U+0078)
  0x02, 0xA0, 0xD2, 0x85, 0x1E, 0xFE, 0x20, 0x7A, 0x81, 0x70, 0x9A, 0x06, 0x38, 0x2C, 0xFE, 0x4A,
  0x0B, 0x40, 0x2C, 0x0E, 0x01, 0x50, 0x7B, 0x05, 0x60, 0x8B, 0x06, 0x50, 0x3A, 0x82, 0xEF, 0xE2,
  0x48, 0x2D, 0xFE, 0x3A, 0x0B, 0x30, 0x9A, 0x81, 0x50, 0x8A, 0x81, 0x60, 0x4A, 0x0C, 0x38, 0x2E,
  0xFE, 0x20,
  // "y" (U+0079)
  0x06, 0xA0, 0x53, 0x08, 0xA0, 0x30, 0x1A, 0x0B, 0x38, 0x1C, 0xFD, 0x20, 0x9A, 0x81, 0x10, 0x1A,
  0x07, 0x20, 0x3A, 0x81, 0x50, 0x6A, 0x02, 0x38, 0x5C, 0xFB, 0x0B, 0xFB, 0x40, 0x6A, 0x01, 0xA0,
  0x65, 0x81, 0xEF, 0x9A, 0x01, 0x50, 0x9B, 0x0A, 0x60, 0x3B, 0x04, 0x78, 0x1D, 0xFE, 0x70, 0x2A,
  0x08, 0x58, 0x14, 0x5D, 0xA0, 0x15, 0x0E, 0xB0, 0x66, 0x82, 0xDF, 0xC5, 0x60,
  // "z" (U+007A)
  0x08, 0xF0, 0x70, 0x8F, 0x84, 0x70, 0x11, 0x14, 0xA0, 0xD4, 0x83, 0x1D, 0xFE, 0x24, 0x0B, 0xA0,
  0x44, 0x08, 0xA0, 0x74, 0x05, 0xA0, 0x94, 0x89, 0x02, 0xEF, 0xD2, 0x11, 0x11, 0xBF, 0x09, 0x0C,
  0xF0, 0x90,
  // "{" (U+007B)
  0x38, 0x26, 0xCE, 0x52, 0x04, 0xB0, 0x52, 0x82, 0x7F, 0xE4, 0x38, 0x17, 0xFC, 0x48, 0x17, 0xFB,
  0x48, 0x18, 0xFB, 0x38, 0x22, 0xDF, 0xA2, 0x08, 0xA0, 0xC0, 0x22, 0x08, 0xA0, 0xB0, 0x12, 0x83,
  0x14, 0xEF, 0x94, 0x81, 0x8F, 0xB4, 0x81, 0x7F, 0xB4, 0x81, 0x7F, 0xB4, 0x82, 0x7F, 0xE2, 0x30,
  0x5B, 0x05, 0x38, 0x28, 0xEF, 0x55, 0x01, 0x10,
  // "|" (U+007C)
  0x8E, 0x49, 0xF6, 0x9F, 0x69, 0xF6, 0x9F, 0x69, 0xF6, 0x9F, 0x69, 0xF6, 0x9F, 0x69, 0xF6, 0x9F,
  0x69, 0xF6, 0x9F, 0x69, 0xF6, 0x9F, 0x69, 0xF6, 0x9F, 0x69, 0xF6, 0x9F, 0x60,
  // "}" (U+007D)
  0x10, 0x15, 0x82, 0x5F, 0xE8, 0x30, 0x5B, 0x04, 0x38, 0x22, 0xEF, 0x74, 0x81, 0xBF, 0x74, 0x81,
  0xBF, 0x74, 0x81, 0xBF, 0x84, 0x83, 0xAF, 0xE4, 0x12, 0x01, 0x0B, 0xA0, 0x82, 0x02, 0x0C, 0xA0,
  0x82, 0x82, 0xAF, 0xD2, 0x38, 0x1B, 0xF8, 0x48, 0x1B, 0xF7, 0x48, 0x1C, 0xF7, 0x38, 0x24, 0xEF,
  0x72, 0x05, 0xB0, 0x42, 0x82, 0x5E, 0xC6, 0x30,
  // "~" (U+007E)
  0x18, 0x2B, 0xEB, 0x22, 0x89, 0x3C, 0x77, 0xD3, 0xAE, 0x42, 0xF4, 0xB8, 0x28, 0x57, 0xEF, 0xB0,
  0x21, 0x40, 0x12,
  // "¡" (U+00A1)
  0x81, 0x8E, 0xB1, 0xB8, 0x23, 0x9F, 0xB5, 0x8A, 0x78, 0xFB, 0x09, 0xFC, 0x0A, 0xFD, 0x0A, 0xFD,
  0x0B, 0xFE, 0x0C, 0xFE, 0x0C, 0xA1, 0x0D, 0xA1, 0x0E, 0xA0, 0x10,
  // "¢" (U+00A2)
  0x40, 0x90, 0xC5, 0x87, 0x28, 0xDE, 0xB8, 0x20, 0x5E, 0x04, 0x02, 0xA8, 0x90, 0xB2, 0x02, 0x60,
  0x7F, 0xE1, 0x58, 0x1A, 0xFC, 0x68, 0x1B, 0xFC, 0x68, 0x29, 0xFE, 0x15, 0x05, 0xA8, 0x6B, 0x20,
  0x16, 0x20, 0xCE, 0x82, 0x40, 0x19, 0xC0, 0xD0, 0x24, 0x81, 0xAD, 0x16, 0x09, 0x0C, 0x30,
  // "£" (U+00A3)
  0x38, 0x48, 0xDF, 0xDA, 0x32, 0x0B, 0xD8, 0x14, 0x01, 0xA8, 0x2B, 0x23, 0x72, 0x02, 0xA0, 0x55,
  0x02, 0xA0, 0x54, 0x08, 0xE8, 0x14, 0x08, 0xE0, 0x42, 0x04, 0xA8, 0x16, 0x11, 0x30, 0x2A, 0x05,
  0x50, 0x4A, 0x02, 0x48, 0x21, 0xCF, 0x98, 0x01, 0x10, 0x8F, 0x0B, 0x08, 0xF0, 0xB0,
  // "¤" (U+00A4)
  0x10, 0x55, 0x89, 0x25, 0x0A, 0xF8, 0xCE, 0xBA, 0xF6, 0x3E, 0x89, 0x4D, 0x10, 0xDF, 0x52, 0x8F,
  0xA0, 0x3F, 0xA3, 0x84, 0xDE, 0x03, 0xFA, 0x30, 0xD9, 0x28, 0x90, 0xEF, 0x52, 0x8F, 0xB0, 0x3E,
  0xD8, 0x93, 0xC1, 0x9F, 0x9D, 0xEC, 0xBF, 0x60, 0x55, 0x06, 0x10,
  // "¥" (U+00A5)
  0x04, 0xA0, 0x53, 0x86, 0x8F, 0xE1, 0x0B, 0xFC, 0x28, 0x21, 0xEF, 0x72, 0x02, 0xA8, 0x35, 0x08,
  0xFD, 0x48, 0x59, 0xFC, 0x1E, 0xF5, 0x48, 0x41, 0xEF, 0xBF, 0xC5, 0x01, 0x09, 0xB0, 0x50, 0x13,
  0x06, 0xF0, 0x32, 0x06, 0xF0, 0x35, 0x81, 0xCF, 0x95, 0x06, 0xF0, 0x32, 0x06, 0xF0, 0x33, 0x85,
  0x11, 0xDF, 0xA1, 0x16, 0x81, 0xCF, 0x94,
  // "¦" (U+00A6)
  0x8A, 0x39, 0xF6, 0x9F, 0x69, 0xF6, 0x9F, 0x69, 0xF6, 0x9F, 0x69, 0xF6, 0x75, 0x8A, 0x39, 0xF6,
  0x9F, 0x69, 0xF6, 0x9F, 0x69, 0xF6, 0x9F, 0x69, 0xF6,
  // "§" (U+00A7)
  0x28, 0x68, 0xDE, 0xDA, 0x30, 0xAD, 0x89, 0x49, 0x0E, 0xF8, 0x24, 0x93, 0x0D, 0xFA, 0x14, 0x03,
  0x0E, 0xA0, 0x90, 0x22, 0x82, 0x7F, 0xCD, 0xA0, 0x51, 0xA8, 0xA3, 0x10, 0x9F, 0xD0, 0xEF, 0x60,
  0x4F, 0xD0, 0x4E, 0xFB, 0xBE, 0x43, 0x06, 0x0D, 0xA0, 0x45, 0x89, 0x2A, 0xFC, 0x1A, 0x52, 0x2B,
  0xFC, 0x2E, 0x86, 0x70, 0x6C, 0xEE, 0xC5, 0x10,
  // "¨" (U+00A8)
  0x89, 0x4B, 0xF7, 0x08, 0xFA, 0xAE, 0x50, 0x7F, 0x80,
  // "©" (U+00A9)
  0x28, 0x52, 0x9D, 0xFD, 0x81, 0x38, 0x73, 0xE8, 0x20, 0x2A, 0xD1, 0x28, 0xB0, 0xD8, 0x2B, 0xED,
  0x2A, 0xA0, 0x4F, 0x1D, 0xB1, 0x30, 0x3F, 0x17, 0xC1, 0xF4, 0x49, 0x84, 0x47, 0xC2, 0xF4, 0x49,
  0x8A, 0x44, 0x4F, 0x1D, 0xA0, 0x10, 0x3F, 0x10, 0xD7, 0x2C, 0xFD, 0x1B, 0xB2, 0x87, 0x4E, 0x81,
  0x03, 0xAD, 0x13, 0x85, 0x2A, 0xEF, 0xD8, 0x12,
  // "ª" (U+00AA)
  0x18, 0x37, 0xDE, 0xD5, 0x28, 0x73, 0x54, 0xBF, 0x10, 0x8E, 0xB8, 0x97, 0x34, 0xFA, 0x39, 0xF3,
  0x5F, 0x72, 0xCF, 0x31, 0xDA, 0x81, 0x8F, 0x32, 0x82, 0x21, 0x03, 0x10,
  // "«" (U+00AB)
  0x28, 0x93, 0x4B, 0x30, 0x7A, 0x20, 0x2E, 0xF7, 0x3A, 0x8B, 0x05, 0x0C, 0xFC, 0x1D, 0xFA, 0x09,
  0xFE, 0x2B, 0xFD, 0x10, 0xAF, 0xE1, 0xCF, 0xD2, 0x86, 0x1D, 0xFA, 0x2E, 0xF8, 0x20, 0x3A, 0x06,
  0x05, 0xA0, 0x42, 0x85, 0x6D, 0x50, 0x8C, 0x30,
  // "¬" (U+00AC)
  0x80, 0x41, 0x10, 0xBF, 0x05, 0x0B, 0xF0, 0x56, 0x81, 0x8F, 0x56, 0x81, 0x8F, 0x56, 0x81, 0x8F,
  0x50,
  // "®" (U+00AE)
  0x28, 0x52, 0x9D, 0xFD, 0x81, 0x38, 0x73, 0xE8, 0x20, 0x2A, 0xD1, 0x28, 0xC2, 0xD8, 0x8F, 0xEA,
  0x0B, 0xA0, 0x4F, 0x18, 0xB1, 0xF5, 0x3F, 0x17, 0xD0, 0x8B, 0x2F, 0x50, 0xF3, 0x7D, 0x08, 0xA0,
  0xC2, 0x98, 0xA4, 0x44, 0xF0, 0x8B, 0x5E, 0x04, 0xF1, 0x0D, 0x78, 0xB0, 0xE6, 0xBB, 0x28, 0x73,
  0xE8, 0x20, 0x3B, 0xD1, 0x38, 0x52, 0xAD, 0xFD, 0x81, 0x20,
  // "¯" (U+00AF)
  0x18, 0x01, 0x11, 0x04, 0xD0, 0x20, 0x4D, 0x02,
  // "°" (U+00B0)
  0x18, 0x63, 0xCE, 0xB2, 0x01, 0xEB, 0x8A, 0x0D, 0x06, 0xF7, 0x2A, 0xF3, 0x6F, 0x72, 0x9F, 0x31,
  0xEB, 0x0D, 0x28, 0x34, 0xCF, 0xC2, 0x10,
  // "±" (U+00B1)
  0x38, 0x18, 0xF6, 0x68, 0x18, 0xF6, 0x30, 0xF1, 0x85, 0x9F, 0x71, 0x10, 0xAF, 0x08, 0x0A, 0xF0,
  0x83, 0x81, 0x8F, 0x66, 0x81, 0x8F, 0x66, 0x81, 0x8F, 0x63, 0x80, 0x41, 0x10, 0xBF, 0x08, 0x0B,
  0xF0, 0x80,
  // "²" (U+00B2)
  0x18, 0x92, 0x6D, 0xFC, 0x20, 0x1E, 0xB9, 0xFB, 0x20, 0x12, 0x90, 0xD4, 0x81, 0x5F, 0xA3, 0x82,
  0x3E, 0xD1, 0x28, 0x23, 0xED, 0x22, 0x86, 0x2E, 0xF9, 0x88, 0x23, 0xD0, 0x40,
  // "³" (U+00B3)
  0x18, 0x91, 0x7D, 0xFC, 0x30, 0xDA, 0x9F, 0xB3, 0x81, 0x2F, 0xA2, 0xA0, 0xC0, 0x12, 0x82, 0x79,
  0xFA, 0x48, 0x94, 0xBF, 0x4D, 0x99, 0xFD, 0x1B, 0xEE, 0xB3,
  // "´" (U+00B4)
  0x10, 0x7A, 0x05, 0x02, 0xA8, 0x36, 0x0C, 0xF5, 0x20,
  // "µ" (U+00B5)
  0x01, 0xA0, 0x83, 0x82, 0xCF, 0xC1, 0xA0, 0x83, 0x82, 0xCF, 0xC1, 0xA0, 0x83, 0x82, 0xCF, 0xC1,
  0xA0, 0x83, 0x82, 0xCF, 0xC1, 0xA0, 0x83, 0x82, 0xCF, 0xC1, 0xA0, 0x83, 0x82, 0xDF, 0xC1, 0xA0,
  0x93, 0xA0, 0xC0, 0x1A, 0x82, 0xE3, 0x2A, 0xA0, 0xC0, 0x1E, 0x82, 0xDF, 0xC1, 0xC8, 0x4C, 0x55,
  0xFC, 0x1A, 0x08, 0x60, 0x1A, 0x08, 0x60, 0x1A, 0x08, 0x60, 0x1A, 0x08, 0x60,
  // "¶" (U+00B6)
  0x20, 0x50, 0xCD, 0x81, 0xE0, 0x7F, 0x81, 0xE0, 0xED, 0x82, 0x48, 0xE2, 0xE8, 0x23, 0x7E, 0x4E,
  0x82, 0x37, 0xE3, 0xE8, 0x23, 0x7E, 0x1E, 0x83, 0x37, 0xE0, 0xCD, 0x84, 0x37, 0xE0, 0x3E, 0xC8,
  0x13, 0x7E, 0x28, 0x61, 0x68, 0x8F, 0x37, 0xE5, 0x83, 0x1F, 0x37, 0xE5, 0x83, 0x1F, 0x37, 0xE5,
  0x83, 0x1F, 0x37, 0xE5, 0x83, 0x1F, 0x37, 0xE5, 0x83, 0x1F, 0x37, 0xE5, 0x83, 0x1F, 0x37, 0xE5,
  0x83, 0x19, 0x24, 0x80,
  // "·" (U+00B7)
  0x18, 0x2B, 0xE9, 0x3B, 0x18, 0x1B, 0xE8,
  // "¸" (U+00B8)
  0x10, 0x10, 0x33, 0x81, 0x8F, 0x32, 0x89, 0x05, 0xDF, 0x21, 0x1A, 0xF4, 0x6A, 0x0C, 0x20, 0x30,
  0x22,
  // "¹" (U+00B9)
  0x28, 0x17, 0xF9, 0x20, 0x10, 0xCA, 0x09, 0x28, 0x31, 0xD7, 0xF9, 0x48, 0x11, 0xF9, 0x48, 0x11,
  0xF9, 0x48, 0x11, 0xF9, 0x38, 0x63, 0x6F, 0xB4, 0x10, 0xEC, 0x05,
  // "º" (U+00BA)
  0x18, 0xB7, 0x4C, 0xEB, 0x20, 0x1E, 0xC5, 0xEC, 0x05, 0xF5, 0x09, 0xF1, 0x5F, 0x50, 0x9F, 0x12,
  0xFA, 0x1D, 0xD2, 0x06, 0xA0, 0xE0, 0x44, 0x02, 0x30,
  // "»" (U+00BB)
  0x85, 0x3C, 0x80, 0x5D, 0x62, 0x04, 0xA0, 0x50, 0x6A, 0x03, 0x28, 0x68, 0xFE, 0x2A, 0xFD, 0x12,
  0x8B, 0x0D, 0xFC, 0x1E, 0xFA, 0x01, 0xDF, 0xB2, 0xEF, 0x90, 0xAF, 0xD1, 0xCF, 0xC0, 0x5A, 0x89,
  0x33, 0x7F, 0xE2, 0x02, 0xA7, 0x03, 0xB4, 0x20,
  // "¼" (U+00BC)
  0x82, 0x19, 0xF6, 0x78, 0x29, 0xDF, 0x64, 0x85, 0x34, 0x01, 0x1F, 0x63, 0x81, 0x6F, 0x83, 0x90,
  0x62, 0x81, 0x3F, 0xB2, 0x87, 0x13, 0xF8, 0x21, 0xDD, 0x12, 0x86, 0x6E, 0xEE, 0xBB, 0xF3, 0x78,
  0x48, 0xF6, 0x15, 0x24, 0x85, 0x5F, 0x90, 0xAF, 0x73, 0x86, 0x2E, 0xC0, 0x6C, 0xF7, 0x28, 0x71,
  0xDE, 0x22, 0xE2, 0xF7, 0x28, 0x93, 0xBF, 0x40, 0x9F, 0xEF, 0xE5, 0x01, 0x13, 0x82, 0x11, 0xF8,
  0x72, 0x08, 0x04, 0x10,
  // "½" (U+00BD)
  0x82, 0x19, 0xF6, 0x78, 0x29, 0xDF, 0x64, 0x85, 0x34, 0x01, 0x1F, 0x63, 0x81, 0x5F, 0x93, 0x90,
  0x62, 0x81, 0x1E, 0xD3, 0x86, 0x2F, 0x81, 0x0B, 0xF3, 0x20, 0x6B, 0x82, 0xB7, 0xF7, 0x78, 0x13,
  0xFB, 0x78, 0x51, 0xDE, 0x7C, 0xE9, 0x48, 0x6A, 0xF5, 0x56, 0x7F, 0x32, 0x81, 0x5F, 0x93, 0x85,
  0x8F, 0x20, 0x2E, 0xD3, 0x81, 0x5F, 0x82, 0x81, 0xCF, 0x32, 0x81, 0x4F, 0x87, 0x10, 0xCB, 0x07,
  0x68, 0x00, 0x20, 0x10,
  // "¾" (U+00BE)
  0x83, 0x2C, 0xED, 0x37, 0x82, 0x71, 0xDA, 0x71, 0x81, 0x1E, 0x82, 0x81, 0x2E, 0xB2, 0x82, 0x6F,
  0xE3, 0x28, 0x93, 0xCE, 0x20, 0x11, 0x0C, 0xC0, 0x9F, 0x62, 0x04, 0xB8, 0x27, 0x5F, 0xA4, 0x86,
  0x12, 0x02, 0xED, 0x11, 0x68, 0x4C, 0xF3, 0x6F, 0x74, 0x85, 0x8F, 0x71, 0xEF, 0x73, 0x86, 0x4F,
  0xB0, 0x99, 0xF7, 0x28, 0x71, 0xED, 0x13, 0xE1, 0xF7, 0x28, 0x93, 0xBF, 0x30, 0x9F, 0xEF, 0xE5,
  0x01, 0x13, 0x82, 0x11, 0xF8, 0x72, 0x08, 0x04, 0x10,
  // "¿" (U+00BF)
  0x38, 0x22, 0xDE, 0x45, 0x07, 0xA0, 0xA5, 0x82, 0x2D, 0xE5, 0x77, 0x18, 0x1B, 0xB3, 0x50, 0x3A,
  0x03, 0x48, 0x24, 0xEF, 0xC4, 0x06, 0xA0, 0xB0, 0x13, 0x01, 0xA0, 0xA5, 0x04, 0xA0, 0x35, 0x04,
  0xA8, 0x38, 0x23, 0x8B, 0x20, 0xCE, 0x87, 0x50, 0x19, 0xDF, 0xEB, 0x61,
  // "À" (U+00C0)
  0x20, 0x4A, 0x09, 0x71, 0x05, 0xA0, 0x37, 0x18, 0x14, 0xED, 0x77, 0x40, 0x6B, 0x03, 0x60, 0xAB,
  0x07, 0x68, 0x3E, 0xFC, 0xFB, 0x50, 0x3A, 0x05, 0xA5, 0x82, 0x7F, 0xD1, 0xA0, 0x44, 0x85, 0xCF,
  0x90, 0xCF, 0x84, 0xA8, 0x35, 0x09, 0xFD, 0x30, 0x5A, 0x81, 0x42, 0x7A, 0x01, 0x20, 0x9F, 0x06,
  0x20, 0xDF, 0x81, 0xA0, 0x2A, 0x05, 0x38, 0x39, 0xFE, 0x06, 0xA0, 0x13, 0x05, 0xA8, 0x23, 0xAF,
  0xD4, 0x01, 0xA0, 0x70,
  // "Á" (U+00C1)
  0x50, 0x7A, 0x05, 0x60, 0x2A, 0x06, 0x78, 0x1C, 0xF5, 0x77, 0x40, 0x6B, 0x03, 0x60, 0xAB, 0x07,
  0x68, 0x3E, 0xFC, 0xFB, 0x50, 0x3A, 0x05, 0xA5, 0x82, 0x7F, 0xD1, 0xA0, 0x44, 0x85, 0xCF, 0x90,
  0xCF, 0x84, 0xA8, 0x35, 0x09, 0xFD, 0x30, 0x5A, 0x81, 0x42, 0x7A, 0x01, 0x20, 0x9F, 0x06, 0x20,
  0xDF, 0x81, 0xA0, 0x2A, 0x05, 0x38, 0x39, 0xFE, 0x06, 0xA0, 0x13, 0x05, 0xA8, 0x23, 0xAF, 0xD4,
  0x01, 0xA0, 0x70,
  // "Â" (U+00C2)
  0x30, 0x2A, 0x0E, 0x02, 0x68, 0x3C, 0xFA, 0xFB, 0x58, 0x59, 0xF5, 0x07, 0xF8, 0x77, 0x20, 0x6B,
  0x03, 0x60, 0xAB, 0x07, 0x68, 0x3E, 0xFC, 0xFB, 0x50, 0x3A, 0x05, 0xA5, 0x82, 0x7F, 0xD1, 0xA0,
  0x44, 0x85, 0xCF, 0x90, 0xCF, 0x84, 0xA8, 0x35, 0x09, 0xFD, 0x30, 0x5A, 0x81, 0x42, 0x7A, 0x01,
  0x20, 0x9F, 0x06, 0x20, 0xDF, 0x81, 0xA0, 0x2A, 0x05, 0x38, 0x39, 0xFE, 0x06, 0xA0, 0x13, 0x05,
  0xA8, 0x23, 0xAF, 0xD4, 0x01, 0xA0, 0x70,
  // "Ã" (U+00C3)
  0x28, 0x51, 0xAA, 0x30, 0x78, 0x40, 0xAB, 0x81, 0xDF, 0x84, 0x85, 0xE7, 0x29, 0xEC, 0x17, 0x72,
  0x06, 0xB0, 0x36, 0x0A, 0xB0, 0x76, 0x83, 0xEF, 0xCF, 0xB5, 0x03, 0xA0, 0x5A, 0x58, 0x27, 0xFD,
  0x1A, 0x04, 0x48, 0x5C, 0xF9, 0x0C, 0xF8, 0x4A, 0x83, 0x50, 0x9F, 0xD3, 0x05, 0xA8, 0x14, 0x27,
  0xA0, 0x12, 0x09, 0xF0, 0x62, 0x0D, 0xF8, 0x1A, 0x02, 0xA0, 0x53, 0x83, 0x9F, 0xE0, 0x6A, 0x01,
  0x30, 0x5A, 0x82, 0x3A, 0xFD, 0x40, 0x1A, 0x07,
  // "Ä" (U+00C4)
  0x28, 0x5B, 0xF7, 0x08, 0xFA, 0x48, 0x5A, 0xE5, 0x07, 0xF8, 0x77, 0x20, 0x6B, 0x03, 0x60, 0xAB,
  0x07, 0x68, 0x3E, 0xFC, 0xFB, 0x50, 0x3A, 0x05, 0xA5, 0x82, 0x7F, 0xD1, 0xA0, 0x44, 0x85, 0xCF,
  0x90, 0xCF, 0x84, 0xA8, 0x35, 0x09, 0xFD, 0x30, 0x5A, 0x81, 0x42, 0x7A, 0x01, 0x20, 0x9F, 0x06,
  0x20, 0xDF, 0x81, 0xA0, 0x2A, 0x05, 0x38, 0x39, 0xFE, 0x06, 0xA0, 0x13, 0x05, 0xA8, 0x23, 0xAF,
  0xD4, 0x01, 0xA0, 0x70,
  // "Å" (U+00C5)
  0x38, 0x22, 0xCE, 0xA7, 0x83, 0xAC, 0x4E, 0x66, 0x83, 0xAA, 0x1E, 0x76, 0x83, 0x3E, 0xFC, 0x17,
  0x10, 0x17, 0x10, 0x6B, 0x03, 0x60, 0xAB, 0x07, 0x68, 0x3E, 0xFC, 0xFB, 0x50, 0x3A, 0x05, 0xA5,
  0x82, 0x7F, 0xD1, 0xA0, 0x44, 0x85, 0xCF, 0x90, 0xCF, 0x84, 0xA8, 0x35, 0x09, 0xFD, 0x30, 0x5A,
  0x81, 0x42, 0x7A, 0x01, 0x20, 0x9F, 0x06, 0x20, 0xDF, 0x81, 0xA0, 0x2A, 0x05, 0x38, 0x39, 0xFE,
  0x06, 0xA0, 0x13, 0x05, 0xA8, 0x23, 0xAF, 0xD4, 0x01, 0xA0, 0x70,
  // "Æ" (U+00C6)
  0x30, 0xDE, 0x04, 0x20, 0x1F, 0x04, 0x28, 0x65, 0xFD, 0x7F, 0xB1, 0x13, 0x84, 0x9F, 0xA6, 0xFB,
  0x58, 0x4C, 0xF7, 0x6F, 0xB4, 0x01, 0xA0, 0x30, 0x6B, 0x0E, 0x20, 0x4A, 0x01, 0x06, 0xB0, 0xE2,
  0x87, 0x8F, 0xD1, 0x7F, 0xB1, 0x12, 0x0B, 0xD0, 0xB4, 0xE0, 0xB3, 0x03, 0xA8, 0x91, 0x20, 0x6F,
  0xB1, 0x10, 0x7F, 0xE2, 0x06, 0xC8, 0x24, 0xAF, 0xB2, 0x06, 0xC0, 0x40,
  // "Ç" (U+00C7)
  0x38, 0x51, 0x8C, 0xEE, 0xC7, 0x20, 0x30, 0xED, 0x89, 0x3B, 0x01, 0xEF, 0xE6, 0x22, 0x63, 0x08,
  0xA0, 0x36, 0x81, 0xCF, 0xC7, 0xA0, 0x96, 0x01, 0xA0, 0x87, 0xA0, 0x97, 0x81, 0xEF, 0xB7, 0x0A,
  0xA0, 0x26, 0x03, 0xA8, 0x4D, 0x42, 0x36, 0x62, 0x08, 0xE0, 0x93, 0x04, 0x0B, 0xA8, 0x1E, 0xA4,
  0x58, 0x18, 0xF3, 0x78, 0x25, 0xDF, 0x25, 0x83, 0x11, 0xAF, 0x45, 0x06, 0xA0, 0xC7, 0x03, 0x02,
  0x30,
  // "È" (U+00C8)
  0x20, 0x4A, 0x09, 0x60, 0x5A, 0x03, 0x68, 0x14, 0xED, 0x74, 0x08, 0xF0, 0x08, 0xF8, 0x28, 0x8F,
  0xE8, 0x01, 0x11, 0x81, 0x8F, 0xE6, 0x81, 0x8F, 0xE6, 0x08, 0xF0, 0x40, 0x8F, 0x82, 0x48, 0xFE,
  0x80, 0x11, 0x18, 0x18, 0xFE, 0x68, 0x18, 0xFE, 0x68, 0x18, 0xFE, 0x80, 0x11, 0x10, 0x8F, 0x00,
  0x8F, 0x08,
  // "É" (U+00C9)
  0x50, 0x7A, 0x05, 0x40, 0x2A, 0x06, 0x58, 0x1C, 0xF5, 0x74, 0x08, 0xF0, 0x08, 0xF8, 0x28, 0x8F,
  0xE8, 0x01, 0x11, 0x81, 0x8F, 0xE6, 0x81, 0x8F, 0xE6, 0x08, 0xF0, 0x40, 0x8F, 0x82, 0x48, 0xFE,
  0x80, 0x11, 0x18, 0x18, 0xFE, 0x68, 0x18, 0xFE, 0x68, 0x18, 0xFE, 0x80, 0x11, 0x10, 0x8F, 0x00,
  0x8F, 0x08,
  // "Ê" (U+00CA)
  0x30, 0x2A, 0x0E, 0x02, 0x48, 0x3C, 0xFA, 0xFB, 0x38, 0x59, 0xF5, 0x07, 0xF8, 0x72, 0x08, 0xF0,
  0x08, 0xF8, 0x28, 0x8F, 0xE8, 0x01, 0x11, 0x81, 0x8F, 0xE6, 0x81, 0x8F, 0xE6, 0x08, 0xF0, 0x40,
  0x8F, 0x82, 0x48, 0xFE, 0x80, 0x11, 0x18, 0x18, 0xFE, 0x68, 0x18, 0xFE, 0x68, 0x18, 0xFE, 0x80,
  0x11, 0x10, 0x8F, 0x00, 0x8F, 0x08,
  // "Ë" (U+00CB)
  0x28, 0x5B, 0xF7, 0x08, 0xFA, 0x28, 0x5A, 0xE5, 0x07, 0xF8, 0x72, 0x08, 0xF0, 0x08, 0xF8, 0x28,
  0x8F, 0xE8, 0x01, 0x11, 0x81, 0x8F, 0xE6, 0x81, 0x8F, 0xE6, 0x08, 0xF0, 0x40, 0x8F, 0x82, 0x48,
  0xFE, 0x80, 0x11, 0x18, 0x18, 0xFE, 0x68, 0x18, 0xFE, 0x68, 0x18, 0xFE, 0x80, 0x11, 0x10, 0x8F,
  0x00, 0x8F, 0x08,
  // "Ì" (U+00CC)
  0x10, 0x4A, 0x09, 0x60, 0x5A, 0x03, 0x68, 0x14, 0xED, 0x75, 0x05, 0xF0, 0x20, 0x5F, 0x02, 0x28,
  0x32, 0xEF, 0xA2, 0x58, 0x1D, 0xF9, 0x68, 0x1D, 0xF9, 0x68, 0x1D, 0xF9, 0x68, 0x1D, 0xF9, 0x68,
  0x1D, 0xF9, 0x68, 0x1D, 0xF9, 0x68, 0x1D, 0xF9, 0x68, 0x1D, 0xFA, 0x30, 0x40, 0xDD, 0x81, 0xD2,
  0x5F, 0x02,
  // "Í" (U+00CD)
  0x40, 0x7A, 0x05, 0x40, 0x2A, 0x06, 0x58, 0x1C, 0xF5, 0x75, 0x05, 0xF0, 0x20, 0x5F, 0x02, 0x28,
  0x32, 0xEF, 0xA2, 0x58, 0x1D, 0xF9, 0x68, 0x1D, 0xF9, 0x68, 0x1D, 0xF9, 0x68, 0x1D, 0xF9, 0x68,
  0x1D, 0xF9, 0x68, 0x1D, 0xF9, 0x68, 0x1D, 0xF9, 0x68, 0x1D, 0xFA, 0x30, 0x40, 0xDD, 0x81, 0xD2,
  0x5F, 0x02,
  // "Î" (U+00CE)
  0x20, 0x2A, 0x0E, 0x02, 0x48, 0x3C, 0xFA, 0xFB, 0x38, 0x59, 0xF5, 0x07, 0xF8, 0x73, 0x05, 0xF0,
  0x20, 0x5F, 0x02, 0x28, 0x32, 0xEF, 0xA2, 0x58, 0x1D, 0xF9, 0x68, 0x1D, 0xF9, 0x68, 0x1D, 0xF9,
  0x68, 0x1D, 0xF9, 0x68, 0x1D, 0xF9, 0x68, 0x1D, 0xF9, 0x68, 0x1D, 0xF9, 0x68, 0x1D, 0xFA, 0x30,
  0x40, 0xDD, 0x81, 0xD2, 0x5F, 0x02,
  // "Ï" (U+00CF)
  0x18, 0x5B, 0xF7, 0x08, 0xFA, 0x28, 0x5A, 0xE5, 0x07, 0xF8, 0x73, 0x05, 0xF0, 0x20, 0x5F, 0x02,
  0x28, 0x32, 0xEF, 0xA2, 0x58, 0x1D, 0xF9, 0x68, 0x1D, 0xF9, 0x68, 0x1D, 0xF9, 0x68, 0x1D, 0xF9,
  0x68, 0x1D, 0xF9, 0x68, 0x1D, 0xF9, 0x68, 0x1D, 0xF9, 0x68, 0x1D, 0xFA, 0x30, 0x40, 0xDD, 0x81,
  0xD2, 0x5F, 0x02,
  // "Ð" (U+00D0)
  0x02, 0xC8, 0x1E, 0xB5, 0x30, 0x2F, 0x09, 0x20, 0x2A, 0x82, 0x71, 0x3B, 0xA8, 0x15, 0x02, 0xA0,
  0x63, 0x83, 0xDF, 0xC0, 0x2A, 0x06, 0x30, 0x9A, 0x01, 0x04, 0xA0, 0x70, 0x12, 0x06, 0xA0, 0x3D,
  0x81, 0x40, 0x6A, 0x03, 0xD8, 0x14, 0x07, 0xA0, 0x02, 0xA0, 0x63, 0x09, 0xA1, 0x02, 0xA0, 0x62,
  0x84, 0x1E, 0xFB, 0x02, 0xA8, 0x27, 0x14, 0xCA, 0x81, 0x40, 0x2F, 0x07, 0x20, 0x2C, 0x81, 0xEA,
  0x43,
  // "Ñ" (U+00D1)
  0x28, 0x51, 0xAA, 0x30, 0x78, 0x30, 0xAB, 0x81, 0xDF, 0x83, 0x85, 0xE7, 0x29, 0xEC, 0x17, 0x40,
  0x2B, 0x08, 0x20, 0x5A, 0x02, 0xB0, 0xD2, 0x05, 0xA0, 0x2A, 0x83, 0xEF, 0x20, 0x5A, 0x02, 0xA8,
  0x3A, 0xF7, 0x05, 0xA0, 0x2A, 0x83, 0x6F, 0xC0, 0x5A, 0x02, 0xA0, 0x2A, 0x01, 0x05, 0xA0, 0x2A,
  0x83, 0x1A, 0xF6, 0x5A, 0x02, 0xA8, 0x31, 0x5F, 0xB5, 0xA0, 0x2A, 0x00, 0x1A, 0x06, 0xA0, 0x2A,
  0x83, 0x10, 0xBF, 0xAA, 0x02, 0xA8, 0x31, 0x06, 0xFE, 0xA0, 0x2A, 0x81, 0x10, 0x1C, 0x02, 0xA0,
  0x12, 0x0B, 0xB0,
  // "Ò" (U+00D2)
  0x20, 0x4A, 0x09, 0x71, 0x05, 0xA0, 0x37, 0x18, 0x14, 0xED, 0x77, 0x38, 0x52, 0xAE, 0xFD, 0x81,
  0x30, 0x20, 0xED, 0x0C, 0x30, 0xAA, 0x81, 0x52, 0x8A, 0x81, 0x70, 0x1A, 0x09, 0x38, 0x3C, 0xFD,
  0x04, 0xA0, 0x53, 0x08, 0xA0, 0x10, 0x6A, 0x03, 0x30, 0x6A, 0x03, 0x06, 0xA0, 0x33, 0x06, 0xA0,
  0x30, 0x6A, 0x03, 0x30, 0x6A, 0x03, 0x04, 0xA0, 0x53, 0x08, 0xA0, 0x01, 0xA0, 0x93, 0x81, 0xCF,
  0xD2, 0x0A, 0xA8, 0x15, 0x28, 0xA0, 0x72, 0x02, 0x0E, 0xD0, 0xC4, 0x85, 0x2A, 0xEF, 0xD8, 0x12,
  // "Ó" (U+00D3)
  0x50, 0x7A, 0x05, 0x60, 0x2A, 0x06, 0x78, 0x1C, 0xF5, 0x77, 0x38, 0x52, 0xAE, 0xFD, 0x81, 0x30,
  0x20, 0xED, 0x0C, 0x30, 0xAA, 0x81, 0x52, 0x8A, 0x81, 0x70, 0x1A, 0x09, 0x38, 0x3C, 0xFD, 0x04,
  0xA0, 0x53, 0x08, 0xA0, 0x10, 0x6A, 0x03, 0x30, 0x6A, 0x03, 0x06, 0xA0, 0x33, 0x06, 0xA0, 0x30,
  0x6A, 0x03, 0x30, 0x6A, 0x03, 0x04, 0xA0, 0x53, 0x08, 0xA0, 0x01, 0xA0, 0x93, 0x81, 0xCF, 0xD2,
  0x0A, 0xA8, 0x15, 0x28, 0xA0, 0x72, 0x02, 0x0E, 0xD0, 0xC4, 0x85, 0x2A, 0xEF, 0xD8, 0x12,
  // "Ô" (U+00D4)
  0x30, 0x2A, 0x0E, 0x02, 0x68, 0x3C, 0xFA, 0xFB, 0x58, 0x59, 0xF5, 0x07, 0xF8, 0x77, 0x18, 0x52,
  0xAE, 0xFD, 0x81, 0x30, 0x20, 0xED, 0x0C, 0x30, 0xAA, 0x81, 0x52, 0x8A, 0x81, 0x70, 0x1A, 0x09,
  0x38, 0x3C, 0xFD, 0x04, 0xA0, 0x53, 0x08, 0xA0, 0x10, 0x6A, 0x03, 0x30, 0x6A, 0x03, 0x06, 0xA0,
  0x33, 0x06, 0xA0, 0x30, 0x6A, 0x03, 0x30, 0x6A, 0x03, 0x04, 0xA0, 0x53, 0x08, 0xA0, 0x01, 0xA0,
  0x93, 0x81, 0xCF, 0xD2, 0x0A, 0xA8, 0x15, 0x28, 0xA0, 0x72, 0x02, 0x0E, 0xD0, 0xC4, 0x85, 0x2A,
  0xEF, 0xD8, 0x12,
  // "Õ" (U+00D5)
  0x28, 0x51, 0xAA, 0x30, 0x78, 0x40, 0xAB, 0x81, 0xDF, 0x84, 0x85, 0xE7, 0x29, 0xEC, 0x17, 0x71,
  0x85, 0x2A, 0xEF, 0xD8, 0x13, 0x02, 0x0E, 0xD0, 0xC3, 0x0A, 0xA8, 0x15, 0x28, 0xA8, 0x17, 0x01,
  0xA0, 0x93, 0x83, 0xCF, 0xD0, 0x4A, 0x05, 0x30, 0x8A, 0x01, 0x06, 0xA0, 0x33, 0x06, 0xA0, 0x30,
  0x6A, 0x03, 0x30, 0x6A, 0x03, 0x06, 0xA0, 0x33, 0x06, 0xA0, 0x30, 0x4A, 0x05, 0x30, 0x8A, 0x00,
  0x1A, 0x09, 0x38, 0x1C, 0xFD, 0x20, 0xAA, 0x81, 0x52, 0x8A, 0x07, 0x20, 0x20, 0xED, 0x0C, 0x48,
  0x52, 0xAE, 0xFD, 0x81, 0x20,
  // "Ö" (U+00D6)
  0x28, 0x5B, 0xF7, 0x08, 0xFA, 0x48, 0x5A, 0xE5, 0x07, 0xF8, 0x77, 0x18, 0x52, 0xAE, 0xFD, 0x81,
  0x30, 0x20, 0xED, 0x0C, 0x30, 0xAA, 0x81, 0x52, 0x8A, 0x81, 0x70, 0x1A, 0x09, 0x38, 0x3C, 0xFD,
  0x04, 0xA0, 0x53, 0x08, 0xA0, 0x10, 0x6A, 0x03, 0x30, 0x6A, 0x03, 0x06, 0xA0, 0x33, 0x06, 0xA0,
  0x30, 0x6A, 0x03, 0x30, 0x6A, 0x03, 0x04, 0xA0, 0x53, 0x08, 0xA0, 0x01, 0xA0, 0x93, 0x81, 0xCF,
  0xD2, 0x0A, 0xA8, 0x15, 0x28, 0xA0, 0x72, 0x02, 0x0E, 0xD0, 0xC4, 0x85, 0x2A, 0xEF, 0xD8, 0x12,
  // "×" (U+00D7)
  0x10, 0x17, 0x81, 0x1D, 0x93, 0x8A, 0x2C, 0xB0, 0x3E, 0xFA, 0x1C, 0xFD, 0x10, 0x3E, 0xFE, 0xFD,
  0x13, 0x04, 0xA0, 0xE0, 0x14, 0x0C, 0xB0, 0x93, 0x8A, 0x2C, 0xFD, 0x4E, 0xF9, 0x03, 0xFC, 0x10,
  0x3E, 0xE1, 0x04, 0x13, 0x03, 0x02, 0x10,
  // "Ø" (U+00D8)
  0x72, 0x03, 0x38, 0x92, 0x2A, 0xEF, 0xD8, 0x8F, 0x50, 0x2E, 0xE0, 0xC2, 0x0A, 0xA8, 0x15, 0x28,
  0xA8, 0x18, 0x01, 0xA0, 0x92, 0x08, 0xA8, 0x1E, 0x04, 0xA8, 0x15, 0x03, 0xC0, 0x10, 0x6A, 0x83,
  0x30, 0xCF, 0x9A, 0x02, 0x06, 0xA8, 0x33, 0x8F, 0x76, 0xA0, 0x30, 0x5A, 0x83, 0x7F, 0xC0, 0x6A,
  0x03, 0x04, 0xC8, 0x12, 0x08, 0xA0, 0x01, 0xB0, 0x72, 0x81, 0xCF, 0xD2, 0x0B, 0xA8, 0x16, 0x28,
  0xA0, 0x72, 0x0D, 0xE0, 0xC2, 0x87, 0x8F, 0x79, 0xDF, 0xD8, 0x13, 0x06, 0x72,
  // "Ù" (U+00D9)
  0x20, 0x4A, 0x09, 0x70, 0x5A, 0x03, 0x78, 0x14, 0xED, 0x76, 0x02, 0xA0, 0x63, 0x09, 0xA0, 0x2A,
  0x06, 0x30, 0x9A, 0x02, 0xA0, 0x63, 0x09, 0xA0, 0x2A, 0x06, 0x30, 0x9A, 0x02, 0xA0, 0x63, 0x09,
  0xA0, 0x2A, 0x06, 0x30, 0x9A, 0x02, 0xA0, 0x63, 0x09, 0xA0, 0x2A, 0x06, 0x30, 0x9A, 0x02, 0xA0,
  0x73, 0x0A, 0xA0, 0x1A, 0x09, 0x38, 0x3D, 0xFD, 0x0C, 0xA8, 0x17, 0x48, 0xA8, 0x19, 0x04, 0xE0,
  0xE0, 0x12, 0x85, 0x3B, 0xEF, 0xD9, 0x11,
  // "Ú" (U+00DA)
  0x50, 0x7A, 0x05, 0x50, 0x2A, 0x06, 0x68, 0x1C, 0xF5, 0x76, 0x02, 0xA0, 0x63, 0x09, 0xA0, 0x2A,
  0x06, 0x30, 0x9A, 0x02, 0xA0, 0x63, 0x09, 0xA0, 0x2A, 0x06, 0x30, 0x9A, 0x02, 0xA0, 0x63, 0x09,
  0xA0, 0x2A, 0x06, 0x30, 0x9A, 0x02, 0xA0, 0x63, 0x09, 0xA0, 0x2A, 0x06, 0x30, 0x9A, 0x02, 0xA0,
  0x73, 0x0A, 0xA0, 0x1A, 0x09, 0x38, 0x3D, 0xFD, 0x0C, 0xA8, 0x17, 0x48, 0xA8, 0x19, 0x04, 0xE0,
  0xE0, 0x12, 0x85, 0x3B, 0xEF, 0xD9, 0x11,
  // "Û" (U+00DB)
  0x30, 0x2A, 0x0E, 0x02, 0x58, 0x3C, 0xFA, 0xFB, 0x48, 0x59, 0xF5, 0x07, 0xF8, 0x74, 0x02, 0xA0,
  0x63, 0x09, 0xA0, 0x2A, 0x06, 0x30, 0x9A, 0x02, 0xA0, 0x63, 0x09, 0xA0, 0x2A, 0x06, 0x30, 0x9A,
  0x02, 0xA0, 0x63, 0x09, 0xA0, 0x2A, 0x06, 0x30, 0x9A, 0x02, 0xA0, 0x63, 0x09, 0xA0, 0x2A, 0x06,
  0x30, 0x9A, 0x02, 0xA0, 0x73, 0x0A, 0xA0, 0x1A, 0x09, 0x38, 0x3D, 0xFD, 0x0C, 0xA8, 0x17, 0x48,
  0xA8, 0x19, 0x04, 0xE0, 0xE0, 0x12, 0x85, 0x3B, 0xEF, 0xD9, 0x11,
  // "Ü" (U+00DC)
  0x28, 0x5B, 0xF7, 0x08, 0xFA, 0x38, 0x5A, 0xE5, 0x07, 0xF8, 0x74, 0x02, 0xA0, 0x63, 0x09, 0xA0,
  0x2A, 0x06, 0x30, 0x9A, 0x02, 0xA0, 0x63, 0x09, 0xA0, 0x2A, 0x06, 0x30, 0x9A, 0x02, 0xA0, 0x63,
  0x09, 0xA0, 0x2A, 0x06, 0x30, 0x9A, 0x02, 0xA0, 0x63, 0x09, 0xA0, 0x2A, 0x06, 0x30, 0x9A, 0x02,
  0xA0, 0x73, 0x0A, 0xA0, 0x1A, 0x09, 0x38, 0x3D, 0xFD, 0x0C, 0xA8, 0x17, 0x48, 0xA8, 0x19, 0x04,
  0xE0, 0xE0, 0x12, 0x85, 0x3B, 0xEF, 0xD9, 0x11,
  // "Ý" (U+00DD)
  0x50, 0x7A, 0x05, 0x60, 0x2A, 0x06, 0x78, 0x1C, 0xF5, 0x77, 0x10, 0x6A, 0x04, 0x30, 0x7A, 0x83,
  0x30, 0xEF, 0xB3, 0x81, 0xDF, 0xB2, 0x07, 0xA8, 0x12, 0x04, 0xA0, 0x43, 0x85, 0xEF, 0x80, 0xBF,
  0xC4, 0x82, 0x8F, 0xE2, 0xA0, 0x54, 0x01, 0xA8, 0x1D, 0xFD, 0x60, 0x9B, 0x06, 0x60, 0x2A, 0x0E,
  0x71, 0x81, 0xDF, 0xB7, 0x18, 0x1D, 0xFB, 0x71, 0x81, 0xDF, 0xB7, 0x18, 0x1D, 0xFB, 0x71, 0x81,
  0xDF, 0xB4,
  // "Þ" (U+00DE)
  0x81, 0x8F, 0xE6, 0x81, 0x8F, 0xE6, 0x08, 0xC8, 0x3E, 0xB5, 0x08, 0xF8, 0x93, 0x58, 0xFE, 0x11,
  0x4E, 0xFD, 0x8F, 0xE3, 0x09, 0xA8, 0x18, 0xFE, 0x30, 0x9A, 0x81, 0x8F, 0xE2, 0x83, 0x4E, 0xFC,
  0x8F, 0x05, 0x08, 0xD8, 0x6C, 0x50, 0x8F, 0xE1, 0x14, 0x81, 0x8F, 0xE6, 0x81, 0x8F, 0xE6,
  // "ß" (U+00DF)
  0x18, 0x43, 0xBD, 0xFD, 0x83, 0x04, 0xE0, 0xB2, 0x84, 0xCF, 0xE4, 0x2A, 0xA0, 0x21, 0xA0, 0x92,
  0x05, 0xA0, 0x21, 0xA8, 0x48, 0x01, 0xDF, 0xB2, 0xA8, 0x48, 0x0D, 0xFC, 0x12, 0xA0, 0x80, 0x4A,
  0x03, 0x3A, 0x08, 0x03, 0xA0, 0xC0, 0x12, 0xA8, 0x18, 0x09, 0xA0, 0xE0, 0x31, 0xA0, 0x82, 0x06,
  0xA0, 0xD1, 0xA0, 0x83, 0x06, 0xA0, 0x3A, 0x83, 0x86, 0x42, 0x9A, 0x02, 0xA0, 0x80, 0x9C, 0x0C,
  0x1A, 0x85, 0x85, 0xDF, 0xDA, 0x11,
  // "à" (U+00E0)
  0x20, 0x4A, 0x09, 0x60, 0x5A, 0x03, 0x68, 0x14, 0xED, 0x74, 0x89, 0x01, 0x7C, 0xEE, 0xD9, 0x20,
  0x3E, 0x86, 0xE1, 0x08, 0x52, 0x27, 0xA0, 0x76, 0x85, 0xDF, 0x90, 0x7C, 0xEC, 0x09, 0x0A, 0xF0,
  0x9A, 0x85, 0xB3, 0x11, 0xDF, 0x9A, 0x82, 0xA2, 0x27, 0xA0, 0x90, 0xBC, 0x89, 0x3E, 0xDF, 0x91,
  0xAE, 0xEB, 0x37, 0xF9,
  // "á" (U+00E1)
  0x50, 0x7A, 0x05, 0x40, 0x2A, 0x06, 0x58, 0x1C, 0xF5, 0x74, 0x89, 0x01, 0x7C, 0xEE, 0xD9, 0x20,
  0x3E, 0x86, 0xE1, 0x08, 0x52, 0x27, 0xA0, 0x76, 0x85, 0xDF, 0x90, 0x7C, 0xEC, 0x09, 0x0A, 0xF0,
  0x9A, 0x85, 0xB3, 0x11, 0xDF, 0x9A, 0x82, 0xA2, 0x27, 0xA0, 0x90, 0xBC, 0x89, 0x3E, 0xDF, 0x91,
  0xAE, 0xEB, 0x37, 0xF9,
  // "â" (U+00E2)
  0x30, 0x2A, 0x0E, 0x02, 0x48, 0x3C, 0xFA, 0xFB, 0x38, 0x59, 0xF5, 0x07, 0xF8, 0x72, 0x89, 0x01,
  0x7C, 0xEE, 0xD9, 0x20, 0x3E, 0x86, 0xE1, 0x08, 0x52, 0x27, 0xA0, 0x76, 0x85, 0xDF, 0x90, 0x7C,
  0xEC, 0x09, 0x0A, 0xF0, 0x9A, 0x85, 0xB3, 0x11, 0xDF, 0x9A, 0x82, 0xA2, 0x27, 0xA0, 0x90, 0xBC,
  0x89, 0x3E, 0xDF, 0x91, 0xAE, 0xEB, 0x37, 0xF9,
  // "ã" (U+00E3)
  0x28, 0x51, 0xAA, 0x30, 0x78, 0x20, 0xAB, 0x81, 0xDF, 0x82, 0x85, 0xE7, 0x29, 0xEC, 0x17, 0x28,
  0x90, 0x17, 0xCE, 0xED, 0x92, 0x03, 0xE8, 0x6E, 0x10, 0x85, 0x22, 0x7A, 0x07, 0x68, 0x5D, 0xF9,
  0x07, 0xCE, 0xC0, 0x90, 0xAF, 0x09, 0xA8, 0x5B, 0x31, 0x1D, 0xF9, 0xA8, 0x2A, 0x22, 0x7A, 0x09,
  0x0B, 0xC8, 0x93, 0xED, 0xF9, 0x1A, 0xEE, 0xB3, 0x7F, 0x90,
  // "ä" (U+00E4)
  0x28, 0x5B, 0xF7, 0x08, 0xFA, 0x28, 0x5A, 0xE5, 0x07, 0xF8, 0x72, 0x89, 0x01, 0x7C, 0xEE, 0xD9,
  0x20, 0x3E, 0x86, 0xE1, 0x08, 0x52, 0x27, 0xA0, 0x76, 0x85, 0xDF, 0x90, 0x7C, 0xEC, 0x09, 0x0A,
  0xF0, 0x9A, 0x85, 0xB3, 0x11, 0xDF, 0x9A, 0x82, 0xA2, 0x27, 0xA0, 0x90, 0xBC, 0x89, 0x3E, 0xDF,
  0x91, 0xAE, 0xEB, 0x37, 0xF9,
  // "å" (U+00E5)
  0x38, 0x22, 0xCE, 0xA5, 0x83, 0xAC, 0x4E, 0x64, 0x83, 0xAA, 0x1E, 0x74, 0x83, 0x3E, 0xFC, 0x16,
  0x01, 0x38, 0x90, 0x17, 0xCE, 0xED, 0x92, 0x03, 0xE8, 0x6E, 0x10, 0x85, 0x22, 0x7A, 0x07, 0x68,
  0x5D, 0xF9, 0x07, 0xCE, 0xC0, 0x90, 0xAF, 0x09, 0xA8, 0x5B, 0x31, 0x1D, 0xF9, 0xA8, 0x2A, 0x22,
  0x7A, 0x09, 0x0B, 0xC8, 0x93, 0xED, 0xF9, 0x1A, 0xEE, 0xB3, 0x7F, 0x90,
  // "æ" (U+00E6)
  0x89, 0x01, 0x9D, 0xEB, 0x4B, 0xEC, 0x32, 0x0E, 0xF0, 0xE2, 0x89, 0x03, 0x23, 0xDF, 0xD2, 0xDF,
  0x53, 0x89, 0x01, 0xBF, 0x91, 0xAF, 0x80, 0xAF, 0x90, 0x90, 0x8F, 0xA8, 0x69, 0xBF, 0xA0, 0xBF,
  0x94, 0x83, 0xBF, 0xA3, 0xEA, 0x83, 0x52, 0x41, 0x8B, 0x0E, 0x0B, 0xC8, 0x92, 0x31, 0xAE, 0xD4,
  0x08, 0xEE, 0xA1,
  // "ç" (U+00E7)
  0x28, 0x76, 0xCE, 0xFD, 0x92, 0x09, 0xD8, 0x1E, 0x03, 0xA8, 0x5C, 0x42, 0x45, 0x08, 0xA0, 0x35,
  0x81, 0xAF, 0xE6, 0x81, 0xBF, 0xE6, 0x09, 0xA0, 0x25, 0x05, 0xA8, 0x3C, 0x42, 0x49, 0x20, 0xBE,
  0x30, 0x70, 0xCA, 0x0D, 0x08, 0x58, 0x18, 0xF3, 0x68, 0x25, 0xDF, 0x24, 0x83, 0x11, 0xAF, 0x44,
  0x06, 0xA0, 0xC6, 0x03, 0x02, 0x30,
  // "è" (U+00E8)
  0x20, 0x4A, 0x09, 0x60, 0x5A, 0x03, 0x68, 0x14, 0xED, 0x75, 0x89, 0x01, 0x9D, 0xFD, 0x91, 0x01,
  0xDD, 0x81, 0xD1, 0x9A, 0x89, 0x56, 0x25, 0xEF, 0x7E, 0xFA, 0x11, 0x19, 0xFC, 0xF9, 0x0D, 0xF9,
  0x82, 0xED, 0xF9, 0x60, 0x8A, 0x86, 0x83, 0x23, 0x65, 0x0C, 0xE0, 0x92, 0x85, 0x7C, 0xEF, 0xDA,
  0x40,
  // "é" (U+00E9)
  0x50, 0x7A, 0x05, 0x40, 0x2A, 0x06, 0x58, 0x1C, 0xF5, 0x75, 0x89, 0x01, 0x9D, 0xFD, 0x91, 0x01,
  0xDD, 0x81, 0xD1, 0x9A, 0x89, 0x56, 0x25, 0xEF, 0x7E, 0xFA, 0x11, 0x19, 0xFC, 0xF9, 0x0D, 0xF9,
  0x82, 0xED, 0xF9, 0x60, 0x8A, 0x86, 0x83, 0x23, 0x65, 0x0C, 0xE0, 0x92, 0x85, 0x7C, 0xEF, 0xDA,
  0x40,
  // "ê" (U+00EA)
  0x30, 0x2A, 0x0E, 0x02, 0x48, 0x3C, 0xFA, 0xFB, 0x38, 0x59, 0xF5, 0x07, 0xF8, 0x73, 0x89, 0x01,
  0x9D, 0xFD, 0x91, 0x01, 0xDD, 0x81, 0xD1, 0x9A, 0x89, 0x56, 0x25, 0xEF, 0x7E, 0xFA, 0x11, 0x19,
  0xFC, 0xF9, 0x0D, 0xF9, 0x82, 0xED, 0xF9, 0x60, 0x8A, 0x86, 0x83, 0x23, 0x65, 0x0C, 0xE0, 0x92,
  0x85, 0x7C, 0xEF, 0xDA, 0x40,
  // "ë" (U+00EB)
  0x28, 0x5B, 0xF7, 0x08, 0xFA, 0x28, 0x5A, 0xE5, 0x07, 0xF8, 0x73, 0x89, 0x01, 0x9D, 0xFD, 0x91,
  0x01, 0xDD, 0x81, 0xD1, 0x9A, 0x89, 0x56, 0x25, 0xEF, 0x7E, 0xFA, 0x11, 0x19, 0xFC, 0xF9, 0x0D,
  0xF9, 0x82, 0xED, 0xF9, 0x60, 0x8A, 0x86, 0x83, 0x23, 0x65, 0x0C, 0xE0, 0x92, 0x85, 0x7C, 0xEF,
  0xDA, 0x40,
  // "ì" (U+00EC)
  0x10, 0x4A, 0x09, 0x60, 0x5A, 0x03, 0x68, 0x14, 0xED, 0x75, 0x06, 0xD3, 0x06, 0xD5, 0x01, 0x0B,
  0xA6, 0x09, 0xA6, 0x09, 0xA6, 0x09, 0xA6, 0x09, 0xA6, 0x0A, 0xA0, 0x12, 0x0A, 0x0D, 0xD8, 0x1E,
  0xAE, 0xF0, 0xE0,
  // "í" (U+00ED)
  0x40, 0x7A, 0x05, 0x40, 0x2A, 0x06, 0x58, 0x1C, 0xF5, 0x75, 0x06, 0xD3, 0x06, 0xD5, 0x01, 0x0B,
  0xA6, 0x09, 0xA6, 0x09, 0xA6, 0x09, 0xA6, 0x09, 0xA6, 0x0A, 0xA0, 0x12, 0x0A, 0x0D, 0xD8, 0x1E,
  0xAE, 0xF0, 0xE0,
  // "î" (U+00EE)
  0x20, 0x2A, 0x0E, 0x02, 0x48, 0x3C, 0xFA, 0xFB, 0x38, 0x59, 0xF5, 0x07, 0xF8, 0x73, 0x06, 0xD3,
  0x06, 0xD5, 0x01, 0x0B, 0xA6, 0x09, 0xA6, 0x09, 0xA6, 0x09, 0xA6, 0x09, 0xA6, 0x0A, 0xA0, 0x12,
  0x0A, 0x0D, 0xD8, 0x1E, 0xAE, 0xF0, 0xE0,
  // "ï" (U+00EF)
  0x18, 0x5B, 0xF7, 0x08, 0xFA, 0x28, 0x5A, 0xE5, 0x07, 0xF8, 0x73, 0x06, 0xD3, 0x06, 0xD5, 0x01,
  0x0B, 0xA6, 0x09, 0xA6, 0x09, 0xA6, 0x09, 0xA6, 0x09, 0xA6, 0x0A, 0xA0, 0x12, 0x0A, 0x0D, 0xD8,
  0x1E, 0xAE, 0xF0, 0xE0,
  // "ð" (U+00F0)
  0x38, 0x47, 0xA2, 0x1A, 0x64, 0x0B, 0xA8, 0x1E, 0xF7, 0x40, 0x40, 0xEA, 0x0A, 0x48, 0x21, 0xFE,
  0x8A, 0x06, 0x48, 0x54, 0x10, 0x7F, 0xE1, 0x28, 0x90, 0x4B, 0xEE, 0xAE, 0xF7, 0x05, 0xF8, 0x6C,
  0x0E, 0xFE, 0x42, 0x6A, 0x0E, 0x02, 0xA0, 0x73, 0x0A, 0xA0, 0x3A, 0x05, 0x30, 0x9A, 0x02, 0xA0,
  0x73, 0x89, 0x0B, 0xFD, 0x0D, 0xFE, 0x42, 0x7A, 0x81, 0x80, 0x4E, 0x0C, 0x38, 0x43, 0xAE, 0xFD,
  0x82,
  // "ñ" (U+00F1)
  0x18, 0x51, 0xAA, 0x30, 0x78, 0x20, 0xAB, 0x81, 0xDF, 0x82, 0x85, 0xE7, 0x29, 0xEC, 0x17, 0x3A,
  0x84, 0x27, 0xDF, 0xD6, 0x1A, 0x0D, 0xD0, 0x5B, 0x81, 0x82, 0x6A, 0x0B, 0xA0, 0xD3, 0x81, 0xCF,
  0xDA, 0x0A, 0x38, 0x1A, 0xFE, 0xA0, 0x93, 0x81, 0xAF, 0xEA, 0x09, 0x38, 0x1A, 0xFE, 0xA0, 0x93,
  0x81, 0xAF, 0xEA, 0x09, 0x38, 0x1A, 0xFE, 0xA0, 0x93, 0x81, 0xAF, 0xE0,
  // "ò" (U+00F2)
  0x20, 0x4A, 0x09, 0x70, 0x5A, 0x03, 0x78, 0x14, 0xED, 0x77, 0x18, 0x51, 0x9D, 0xFD, 0x91, 0x20,
  0x20, 0xED, 0x82, 0xD1, 0x0B, 0xA8, 0x16, 0x27, 0xA0, 0x90, 0x1A, 0x09, 0x38, 0x2C, 0xFE, 0x3A,
  0x06, 0x30, 0x9A, 0x03, 0xA0, 0x63, 0x09, 0xA0, 0x1A, 0x09, 0x38, 0x3C, 0xFD, 0x0B, 0xA8, 0x16,
  0x27, 0xA8, 0x28, 0x02, 0xED, 0x0D, 0x38, 0x52, 0x9D, 0xFD, 0x81, 0x10,
  // "ó" (U+00F3)
  0x50, 0x7A, 0x05, 0x50, 0x2A, 0x06, 0x68, 0x1C, 0xF5, 0x77, 0x18, 0x51, 0x9D, 0xFD, 0x91, 0x20,
  0x20, 0xED, 0x82, 0xD1, 0x0B, 0xA8, 0x16, 0x27, 0xA0, 0x90, 0x1A, 0x09, 0x38, 0x2C, 0xFE, 0x3A,
  0x06, 0x30, 0x9A, 0x03, 0xA0, 0x63, 0x09, 0xA0, 0x1A, 0x09, 0x38, 0x3C, 0xFD, 0x0B, 0xA8, 0x16,
  0x27, 0xA8, 0x28, 0x02, 0xED, 0x0D, 0x38, 0x52, 0x9D, 0xFD, 0x81, 0x10,
  // "ô" (U+00F4)
  0x30, 0x2A, 0x0E, 0x02, 0x58, 0x3C, 0xFA, 0xFB, 0x48, 0x59, 0xF5, 0x07, 0xF8, 0x76, 0x85, 0x19,
  0xDF, 0xD9, 0x12, 0x02, 0x0E, 0xD8, 0x2D, 0x10, 0xBA, 0x81, 0x62, 0x7A, 0x09, 0x01, 0xA0, 0x93,
  0x82, 0xCF, 0xE3, 0xA0, 0x63, 0x09, 0xA0, 0x3A, 0x06, 0x30, 0x9A, 0x01, 0xA0, 0x93, 0x83, 0xCF,
  0xD0, 0xBA, 0x81, 0x62, 0x7A, 0x82, 0x80, 0x2E, 0xD0, 0xD3, 0x85, 0x29, 0xDF, 0xD8, 0x11,
  // "õ" (U+00F5)
  0x28, 0x51, 0xAA, 0x30, 0x78, 0x30, 0xAB, 0x81, 0xDF, 0x83, 0x85, 0xE7, 0x29, 0xEC, 0x17, 0x68,
  0x51, 0x9D, 0xFD, 0x91, 0x20, 0x20, 0xED, 0x82, 0xD1, 0x0B, 0xA8, 0x16, 0x27, 0xA0, 0x90, 0x1A,
  0x09, 0x38, 0x2C, 0xFE, 0x3A, 0x06, 0x30, 0x9A, 0x03, 0xA0, 0x63, 0x09, 0xA0, 0x1A, 0x09, 0x38,
  0x3C, 0xFD, 0x0B, 0xA8, 0x16, 0x27, 0xA8, 0x28, 0x02, 0xED, 0x0D, 0x38, 0x52, 0x9D, 0xFD, 0x81,
  0x10,
  // "ö" (U+00F6)
  0x28, 0x5B, 0xF7, 0x08, 0xFA, 0x38, 0x5A, 0xE5, 0x07, 0xF8, 0x76, 0x85, 0x19, 0xDF, 0xD9, 0x12,
  0x02, 0x0E, 0xD8, 0x2D, 0x10, 0xBA, 0x81, 0x62, 0x7A, 0x09, 0x01, 0xA0, 0x93, 0x82, 0xCF, 0xE3,
  0xA0, 0x63, 0x09, 0xA0, 0x3A, 0x06, 0x30, 0x9A, 0x01, 0xA0, 0x93, 0x83, 0xCF, 0xD0, 0xBA, 0x81,
  0x62, 0x7A, 0x82, 0x80, 0x2E, 0xD0, 0xD3, 0x85, 0x29, 0xDF, 0xD8, 0x11,
  // "÷" (U+00F7)
  0x38, 0x18, 0xE6, 0x68, 0x19, 0xF7, 0x75, 0x0B, 0xF0, 0x80, 0xBF, 0x08, 0x80, 0x41, 0x76, 0x81,
  0x9F, 0x76, 0x81, 0x8E, 0x63,
  // "ø" (U+00F8)
  0x71, 0x02, 0x38, 0x91, 0x19, 0xDF, 0xDA, 0xF3, 0x02, 0xEE, 0x81, 0x10, 0xBA, 0x81, 0x62, 0xDA,
  0x08, 0x01, 0xA8, 0x19, 0x06, 0xB0, 0xD0, 0x3A, 0x83, 0x62, 0xEC, 0xAA, 0x03, 0xA8, 0x36, 0xCE,
  0x29, 0xA0, 0x1A, 0x87, 0xEF, 0x60, 0xCF, 0xD0, 0xBA, 0x81, 0xC2, 0x7A, 0x81, 0x80, 0x3E, 0x0D,
  0x28, 0x66, 0xFB, 0xEF, 0xD8, 0x13, 0x04, 0x70,
  // "ù" (U+00F9)
  0x20, 0x4A, 0x09, 0x70, 0x5A, 0x03, 0x78, 0x14, 0xED, 0x76, 0x01, 0xA0, 0x83, 0x82, 0xCF, 0xC1,
  0xA0, 0x83, 0x82, 0xCF, 0xC1, 0xA0, 0x83, 0x82, 0xCF, 0xC1, 0xA0, 0x83, 0x82, 0xCF, 0xC1, 0xA0,
  0x83, 0x82, 0xCF, 0xC1, 0xA0, 0x83, 0x82, 0xDF, 0xC1, 0xA0, 0x92, 0x01, 0xA8, 0x6C, 0x0E, 0xFE,
  0x43, 0xAA, 0x81, 0xC0, 0x8D, 0x81, 0xDF, 0xC2, 0x86, 0x8D, 0xFC, 0x45, 0xFC,
  // "ú" (U+00FA)
  0x50, 0x7A, 0x05, 0x50, 0x2A, 0x06, 0x68, 0x1C, 0xF5, 0x76, 0x01, 0xA0, 0x83, 0x82, 0xCF, 0xC1,
  0xA0, 0x83, 0x82, 0xCF, 0xC1, 0xA0, 0x83, 0x82, 0xCF, 0xC1, 0xA0, 0x83, 0x82, 0xCF, 0xC1, 0xA0,
  0x83, 0x82, 0xCF, 0xC1, 0xA0, 0x83, 0x82, 0xDF, 0xC1, 0xA0, 0x92, 0x01, 0xA8, 0x6C, 0x0E, 0xFE,
  0x43, 0xAA, 0x81, 0xC0, 0x8D, 0x81, 0xDF, 0xC2, 0x86, 0x8D, 0xFC, 0x45, 0xFC,
  // "û" (U+00FB)
  0x30, 0x2A, 0x0E, 0x02, 0x58, 0x3C, 0xFA, 0xFB, 0x48, 0x59, 0xF5, 0x07, 0xF8, 0x74, 0x01, 0xA0,
  0x83, 0x82, 0xCF, 0xC1, 0xA0, 0x83, 0x82, 0xCF, 0xC1, 0xA0, 0x83, 0x82, 0xCF, 0xC1, 0xA0, 0x83,
  0x82, 0xCF, 0xC1, 0xA0, 0x83, 0x82, 0xCF, 0xC1, 0xA0, 0x83, 0x82, 0xDF, 0xC1, 0xA0, 0x92, 0x01,
  0xA8, 0x6C, 0x0E, 0xFE, 0x43, 0xAA, 0x81, 0xC0, 0x8D, 0x81, 0xDF, 0xC2, 0x86, 0x8D, 0xFC, 0x45,
  0xFC,
  // "ü" (U+00FC)
  0x28, 0x5B, 0xF7, 0x08, 0xFA, 0x38, 0x5A, 0xE5, 0x07, 0xF8, 0x74, 0x01, 0xA0, 0x83, 0x82, 0xCF,
  0xC1, 0xA0, 0x83, 0x82, 0xCF, 0xC1, 0xA0, 0x83, 0x82, 0xCF, 0xC1, 0xA0, 0x83, 0x82, 0xCF, 0xC1,
  0xA0, 0x83, 0x82, 0xCF, 0xC1, 0xA0, 0x83, 0x82, 0xDF, 0xC1, 0xA0, 0x92, 0x01, 0xA8, 0x6C, 0x0E,
  0xFE, 0x43, 0xAA, 0x81, 0xC0, 0x8D, 0x81, 0xDF, 0xC2, 0x86, 0x8D, 0xFC, 0x45, 0xFC,
  // "ý" (U+00FD)
  0x50, 0x7A, 0x05, 0x60, 0x2A, 0x06, 0x78, 0x1C, 0xF5, 0x77, 0x10, 0x6A, 0x05, 0x30, 0x8A, 0x03,
  0x01, 0xA0, 0xB3, 0x81, 0xCF, 0xD2, 0x09, 0xA8, 0x11, 0x01, 0xA0, 0x72, 0x03, 0xA8, 0x15, 0x06,
  0xA0, 0x23, 0x85, 0xCF, 0xB0, 0xBF, 0xB4, 0x06, 0xA0, 0x1A, 0x06, 0x58, 0x1E, 0xF9, 0xA0, 0x15,
  0x09, 0xB0, 0xA6, 0x03, 0xB0, 0x47, 0x81, 0xDF, 0xE7, 0x02, 0xA0, 0x85, 0x81, 0x45, 0xDA, 0x01,
  0x50, 0xEB, 0x06, 0x68, 0x2D, 0xFC, 0x56,
  // "þ" (U+00FE)
  0xA0, 0x86, 0xA0, 0x86, 0xA0, 0x86, 0xA0, 0x86, 0xA8, 0x48, 0x7D, 0xFC, 0x41, 0xA0, 0xDD, 0x03,
  0xB8, 0x17, 0x27, 0xA0, 0xAA, 0x0B, 0x38, 0x1C, 0xFE, 0xA0, 0x83, 0x0A, 0xC0, 0x93, 0x0A, 0xC0,
  0xC3, 0x81, 0xCF, 0xEB, 0x81, 0x72, 0x7A, 0x0A, 0xA0, 0xED, 0x02, 0xA8, 0x48, 0x7D, 0xFC, 0x31,
  0xA0, 0x86, 0xA0, 0x86, 0xA0, 0x86, 0xA0, 0x86,
  // "ÿ" (U+00FF)
  0x28, 0x5B, 0xF7, 0x08, 0xFA, 0x48, 0x5A, 0xE5, 0x07, 0xF8, 0x76, 0x06, 0xA0, 0x53, 0x08, 0xA0,
  0x30, 0x1A, 0x0B, 0x38, 0x1C, 0xFD, 0x20, 0x9A, 0x81, 0x10, 0x1A, 0x07, 0x20, 0x3A, 0x81, 0x50,
  0x6A, 0x02, 0x38, 0x5C, 0xFB, 0x0B, 0xFB, 0x40, 0x6A, 0x01, 0xA0, 0x65, 0x81, 0xEF, 0x9A, 0x01,
  0x50, 0x9B, 0x0A, 0x60, 0x3B, 0x04, 0x78, 0x1D, 0xFE, 0x70, 0x2A, 0x08, 0x58, 0x14, 0x5D, 0xA0,
  0x15, 0x0E, 0xB0, 0x66, 0x82, 0xDF, 0xC5, 0x60,
  // "Ā" (U+0100)
  0x38, 0x01, 0x15, 0x04, 0xD0, 0x24, 0x04, 0xD0, 0x27, 0x72, 0x06, 0xB0, 0x36, 0x0A, 0xB0, 0x76,
  0x83, 0xEF, 0xCF, 0xB5, 0x03, 0xA0, 0x5A, 0x58, 0x27, 0xFD, 0x1A, 0x04, 0x48, 0x5C, 0xF9, 0x0C,
  0xF8, 0x4A, 0x83, 0x50, 0x9F, 0xD3, 0x05, 0xA8, 0x14, 0x27, 0xA0, 0x12, 0x09, 0xF0, 0x62, 0x0D,
  0xF8, 0x1A, 0x02, 0xA0, 0x53, 0x83, 0x9F, 0xE0, 0x6A, 0x01, 0x30, 0x5A, 0x82, 0x3A, 0xFD, 0x40,
  0x1A, 0x07,
  // "ā" (U+0101)
  0x38, 0x01, 0x13, 0x04, 0xD0, 0x22, 0x04, 0xD0, 0x27, 0x28, 0x90, 0x17, 0xCE, 0xED, 0x92, 0x03,
  0xE8, 0x6E, 0x10, 0x85, 0x22, 0x7A, 0x07, 0x68, 0x5D, 0xF9, 0x07, 0xCE, 0xC0, 0x90, 0xAF, 0x09,
  0xA8, 0x5B, 0x31, 0x1D, 0xF9, 0xA8, 0x2A, 0x22, 0x7A, 0x09, 0x0B, 0xC8, 0x93, 0xED, 0xF9, 0x1A,
  0xEE, 0xB3, 0x7F, 0x90,
  // "Ă" (U+0102)
  0x28, 0x57, 0xF5, 0x26, 0xF5, 0x40, 0x2C, 0x0E, 0x01, 0x58, 0x35, 0xDE, 0xC3, 0x77, 0x30, 0x6B,
  0x03, 0x60, 0xAB, 0x07, 0x68, 0x3E, 0xFC, 0xFB, 0x50, 0x3A, 0x05, 0xA5, 0x82, 0x7F, 0xD1, 0xA0,
  0x44, 0x85, 0xCF, 0x90, 0xCF, 0x84, 0xA8, 0x35, 0x09, 0xFD, 0x30, 0x5A, 0x81, 0x42, 0x7A, 0x01,
  0x20, 0x9F, 0x06, 0x20, 0xDF, 0x81, 0xA0, 0x2A, 0x05, 0x38, 0x39, 0xFE, 0x06, 0xA0, 0x13, 0x05,
  0xA8, 0x23, 0xAF, 0xD4, 0x01, 0xA0, 0x70,
  // "ă" (U+0103)
  0x28, 0x57, 0xF5, 0x26, 0xF5, 0x20, 0x2C, 0x0E, 0x01, 0x38, 0x35, 0xDE, 0xC3, 0x73, 0x89, 0x01,
  0x7C, 0xEE, 0xD9, 0x20, 0x3E, 0x86, 0xE1, 0x08, 0x52, 0x27, 0xA0, 0x76, 0x85, 0xDF, 0x90, 0x7C,
  0xEC, 0x09, 0x0A, 0xF0, 0x9A, 0x85, 0xB3, 0x11, 0xDF, 0x9A, 0x82, 0xA2, 0x27, 0xA0, 0x90, 0xBC,
  0x89, 0x3E, 0xDF, 0x91, 0xAE, 0xEB, 0x37, 0xF9,
  // "Ą" (U+0104)
  0x30, 0x6B, 0x03, 0x70, 0xAB, 0x07, 0x78, 0x3E, 0xFC, 0xFB, 0x60, 0x3A, 0x05, 0xA6, 0x82, 0x7F,
  0xD1, 0xA0, 0x45, 0x85, 0xCF, 0x90, 0xCF, 0x85, 0xA8, 0x35, 0x09, 0xFD, 0x40, 0x5A, 0x81, 0x42,
  0x7A, 0x01, 0x30, 0x9F, 0x06, 0x30, 0xDF, 0x0A, 0x20, 0x2A, 0x05, 0x38, 0x19, 0xFE, 0x20, 0x6A,
  0x01, 0x30, 0x5A, 0x83, 0x30, 0xAF, 0xD4, 0x01, 0xA0, 0xD7, 0x20, 0x0C, 0x72, 0x82, 0x2F, 0xC2,
  0x71, 0x01, 0xB0, 0x37, 0x18, 0x26, 0xEE, 0x20,
  // "ą" (U+0105)
  0x89, 0x01, 0x7C, 0xEE, 0xD9, 0x20, 0x3E, 0x86, 0xE1, 0x08, 0x52, 0x27, 0xA0, 0x76, 0x85, 0xDF,
  0x90, 0x7C, 0xEC, 0x09, 0x0A, 0xF0, 0x9A, 0x85, 0xB3, 0x11, 0xDF, 0x9A, 0x82, 0xA2, 0x27, 0xA0,
  0x90, 0xBC, 0x89, 0x0E, 0xDF, 0x91, 0xAE, 0xEB, 0x5A, 0x09, 0x50, 0x0C, 0x68, 0x22, 0xFC, 0x25,
  0x01, 0xB0, 0x35, 0x82, 0x6E, 0xE2,
  // "Ć" (U+0106)
  0x60, 0x7A, 0x05, 0x50, 0x2A, 0x06, 0x68, 0x1C, 0xF5, 0x77, 0x18, 0x51, 0x8C, 0xEE, 0xC7, 0x20,
  0x30, 0xED, 0x89, 0x3B, 0x01, 0xEF, 0xE6, 0x22, 0x63, 0x08, 0xA0, 0x36, 0x81, 0xCF, 0xC7, 0xA0,
  0x96, 0x01, 0xA0, 0x87, 0xA0, 0x97, 0x81, 0xEF, 0xB7, 0x0A, 0xA0, 0x26, 0x03, 0xA8, 0x4D, 0x42,
  0x36, 0x62, 0x08, 0xE0, 0x93, 0x85, 0x4B, 0xEF, 0xDA, 0x40,
  // "ć" (U+0107)
  0x50, 0x7A, 0x05, 0x40, 0x2A, 0x06, 0x58, 0x1C, 0xF5, 0x76, 0x87, 0x6C, 0xEF, 0xD9, 0x20, 0x9D,
  0x81, 0xE0, 0x3A, 0x85, 0xC4, 0x24, 0x50, 0x8A, 0x03, 0x58, 0x1A, 0xFE, 0x68, 0x1B, 0xFE, 0x60,
  0x9A, 0x02, 0x50, 0x5A, 0x83, 0xC4, 0x24, 0x92, 0x0B, 0xE3, 0x84, 0x7C, 0xEF, 0xD8, 0x10,
  // "Ĉ" (U+0108)
  0x40, 0x2A, 0x0E, 0x02, 0x58, 0x3C, 0xFA, 0xFB, 0x48, 0x59, 0xF5, 0x07, 0xF8, 0x76, 0x85, 0x18,
  0xCE, 0xEC, 0x72, 0x03, 0x0E, 0xD8, 0x93, 0xB0, 0x1E, 0xFE, 0x62, 0x26, 0x30, 0x8A, 0x03, 0x68,
  0x1C, 0xFC, 0x7A, 0x09, 0x60, 0x1A, 0x08, 0x7A, 0x09, 0x78, 0x1E, 0xFB, 0x70, 0xAA, 0x02, 0x60,
  0x3A, 0x84, 0xD4, 0x23, 0x66, 0x20, 0x8E, 0x09, 0x38, 0x54, 0xBE, 0xFD, 0xA4,
  // "ĉ" (U+0109)
  0x30, 0x2A, 0x0E, 0x02, 0x48, 0x3C, 0xFA, 0xFB, 0x38, 0x59, 0xF5, 0x07, 0xF8, 0x74, 0x87, 0x6C,
  0xEF, 0xD9, 0x20, 0x9D, 0x81, 0xE0, 0x3A, 0x85, 0xC4, 0x24, 0x50, 0x8A, 0x03, 0x58, 0x1A, 0xFE,
  0x68, 0x1B, 0xFE, 0x60, 0x9A, 0x02, 0x50, 0x5A, 0x83, 0xC4, 0x24, 0x92, 0x0B, 0xE3, 0x84, 0x7C,
  0xEF, 0xD8, 0x10,
  // "Ċ" (U+010A)
  0x58, 0x1B, 0xE9, 0x60, 0x2A, 0x0E, 0x78, 0x1B, 0xF8, 0x77, 0x18, 0x51, 0x8C, 0xEE, 0xC7, 0x20,
  0x30, 0xED, 0x89, 0x3B, 0x01, 0xEF, 0xE6, 0x22, 0x63, 0x08, 0xA0, 0x36, 0x81, 0xCF, 0xC7, 0xA0,
  0x96, 0x01, 0xA0, 0x87, 0xA0, 0x97, 0x81, 0xEF, 0xB7, 0x0A, 0xA0, 0x26, 0x03, 0xA8, 0x4D, 0x42,
  0x36, 0x62, 0x08, 0xE0, 0x93, 0x85, 0x4B, 0xEF, 0xDA, 0x40,
  // "ċ" (U+010B)
  0x48, 0x1B, 0xE9, 0x50, 0x2A, 0x0E, 0x68, 0x1B, 0xF8, 0x76, 0x87, 0x6C, 0xEF, 0xD9, 0x20, 0x9D,
  0x81, 0xE0, 0x3A, 0x85, 0xC4, 0x24, 0x50, 0x8A, 0x03, 0x58, 0x1A, 0xFE, 0x68, 0x1B, 0xFE, 0x60,
  0x9A, 0x02, 0x50, 0x5A, 0x83, 0xC4, 0x24, 0x92, 0x0B, 0xE3, 0x84, 0x7C, 0xEF, 0xD8, 0x10,
  // "Č" (U+010C)
  0x38, 0x5A, 0xE5, 0x08, 0xF7, 0x48, 0x3D, 0xFA, 0xFB, 0x50, 0x3A, 0x0E, 0x01, 0x77, 0x85, 0x18,
  0xCE, 0xEC, 0x72, 0x03, 0x0E, 0xD8, 0x93, 0xB0, 0x1E, 0xFE, 0x62, 0x26, 0x30, 0x8A, 0x03, 0x68,
  0x1C, 0xFC, 0x7A, 0x09, 0x60, 0x1A, 0x08, 0x7A, 0x09, 0x78, 0x1E, 0xFB, 0x70, 0xAA, 0x02, 0x60,
  0x3A, 0x84, 0xD4, 0x23, 0x66, 0x20, 0x8E, 0x09, 0x38, 0x54, 0xBE, 0xFD, 0xA4,
  // "č" (U+010D)
  0x28, 0x5A, 0xE5, 0x08, 0xF7, 0x38, 0x3D, 0xFA, 0xFB, 0x40, 0x3A, 0x0E, 0x01, 0x75, 0x87, 0x6C,
  0xEF, 0xD9, 0x20, 0x9D, 0x81, 0xE0, 0x3A, 0x85, 0xC4, 0x24, 0x50, 0x8A, 0x03, 0x58, 0x1A, 0xFE,
  0x68, 0x1B, 0xFE, 0x60, 0x9A, 0x02, 0x50, 0x5A, 0x83, 0xC4, 0x24, 0x92, 0x0B, 0xE3, 0x84, 0x7C,
  0xEF, 0xD8, 0x10,
  // "Ď" (U+010E)
  0x28, 0x5A, 0xE5, 0x08, 0xF7, 0x58, 0x3D, 0xFA, 0xFB, 0x60, 0x3A, 0x0E, 0x01, 0x77, 0x02, 0xC8,
  0x1E, 0xB5, 0x30, 0x2F, 0x09, 0x20, 0x2A, 0x82, 0x71, 0x3B, 0xA8, 0x15, 0x02, 0xA0, 0x63, 0x83,
  0xDF, 0xC0, 0x2A, 0x06, 0x30, 0x9A, 0x01, 0x02, 0xA0, 0x63, 0x06, 0xA0, 0x30, 0x2A, 0x06, 0x30,
  0x6A, 0x03, 0x02, 0xA0, 0x63, 0x07, 0xA0, 0x02, 0xA0, 0x63, 0x09, 0xA1, 0x02, 0xA0, 0x62, 0x84,
  0x1E, 0xFB, 0x02, 0xA8, 0x27, 0x14, 0xCA, 0x81, 0x40, 0x2F, 0x07, 0x20, 0x2C, 0x81, 0xEA, 0x43,
  // "ď" (U+010F)
  0x68, 0x29, 0xFE, 0x3A, 0x01, 0x68, 0x49, 0xFE, 0x6F, 0x97, 0x84, 0x9F, 0xE8, 0xD1, 0x78, 0x19,
  0xFE, 0x68, 0x59, 0xEE, 0x88, 0xFE, 0x50, 0x9C, 0x81, 0xEF, 0xE4, 0x01, 0xA8, 0x4C, 0x25, 0xEF,
  0xE4, 0x05, 0xA0, 0x52, 0x81, 0xAF, 0xE4, 0x06, 0xA0, 0x32, 0x81, 0x7F, 0xE4, 0x06, 0xA0, 0x32,
  0x81, 0x7F, 0xE4, 0x05, 0xA0, 0x52, 0x81, 0x9F, 0xE4, 0x01, 0xA8, 0x4C, 0x35, 0xEF, 0xE5, 0x0A,
  0xC8, 0x1D, 0xFE, 0x68, 0x5A, 0xED, 0x64, 0xFE, 0x40,
  // "Đ" (U+0110)
  0x02, 0xC8, 0x1E, 0xB5, 0x30, 0x2F, 0x09, 0x20, 0x2A, 0x82, 0x71, 0x3B, 0xA8, 0x15, 0x02, 0xA0,
  0x63, 0x83, 0xDF, 0xC0, 0x2A, 0x06, 0x30, 0x9A, 0x01, 0x04, 0xA0, 0x70, 0x12, 0x06, 0xA0, 0x3D,
  0x81, 0x40, 0x6A, 0x03, 0xD8, 0x14, 0x07, 0xA0, 0x02, 0xA0, 0x63, 0x09, 0xA1, 0x02, 0xA0, 0x62,
  0x84, 0x1E, 0xFB, 0x02, 0xA8, 0x27, 0x14, 0xCA, 0x81, 0x40, 0x2F, 0x07, 0x20, 0x2C, 0x81, 0xEA,
  0x43,
  // "đ" (U+0111)
  0x58, 0x41, 0x1C, 0xFC, 0x14, 0x04, 0xD0, 0xC4, 0x04, 0xD0, 0xC7, 0x81, 0xBF, 0xC3, 0x86, 0x5C,
  0xFD, 0x6A, 0xFC, 0x20, 0x5D, 0x81, 0xDF, 0xC2, 0x0D, 0xA8, 0x16, 0x26, 0xA8, 0x1C, 0x02, 0xA0,
  0x93, 0x83, 0xBF, 0xC0, 0x3A, 0x06, 0x38, 0x39, 0xFC, 0x03, 0xA0, 0x63, 0x83, 0x8F, 0xC0, 0x2A,
  0x08, 0x38, 0x1B, 0xFC, 0x28, 0x4D, 0xFE, 0x52, 0x6A, 0x0C, 0x20, 0x6D, 0x81, 0xDF, 0xC3, 0x86,
  0x6D, 0xFC, 0x45, 0xFC, 0x10,
  // "Ē" (U+0112)
  0x38, 0x01, 0x13, 0x04, 0xD0, 0x22, 0x04, 0xD0, 0x27, 0x20, 0x8F, 0x00, 0x8F, 0x82, 0x88, 0xFE,
  0x80, 0x11, 0x18, 0x18, 0xFE, 0x68, 0x18, 0xFE, 0x60, 0x8F, 0x04, 0x08, 0xF8, 0x24, 0x8F, 0xE8,
  0x01, 0x11, 0x81, 0x8F, 0xE6, 0x81, 0x8F, 0xE6, 0x81, 0x8F, 0xE8, 0x01, 0x11, 0x08, 0xF0, 0x08,
  0xF0, 0x80,
  // "ē" (U+0113)
  0x38, 0x01, 0x13, 0x04, 0xD0, 0x22, 0x04, 0xD0, 0x27, 0x38, 0x90, 0x19, 0xDF, 0xD9, 0x10, 0x1D,
  0xD8, 0x1D, 0x19, 0xA8, 0x95, 0x62, 0x5E, 0xF7, 0xEF, 0xA1, 0x11, 0x9F, 0xCF, 0x90, 0xDF, 0x98,
  0x2E, 0xDF, 0x96, 0x08, 0xA8, 0x68, 0x32, 0x36, 0x50, 0xCE, 0x09, 0x28, 0x57, 0xCE, 0xFD, 0xA4,
  // "Ĕ" (U+0114)
  0x28, 0x57, 0xF5, 0x26, 0xF5, 0x20, 0x2C, 0x0E, 0x01, 0x38, 0x35, 0xDE, 0xC3, 0x73, 0x08, 0xF0,
  0x08, 0xF8, 0x28, 0x8F, 0xE8, 0x01, 0x11, 0x81, 0x8F, 0xE6, 0x81, 0x8F, 0xE6, 0x08, 0xF0, 0x40,
  0x8F, 0x82, 0x48, 0xFE, 0x80, 0x11, 0x18, 0x18, 0xFE, 0x68, 0x18, 0xFE, 0x68, 0x18, 0xFE, 0x80,
  0x11, 0x10, 0x8F, 0x00, 0x8F, 0x08,
  // "ĕ" (U+0115)
  0x28, 0x57, 0xF5, 0x26, 0xF5, 0x20, 0x2C, 0x0E, 0x01, 0x38, 0x35, 0xDE, 0xC3, 0x74, 0x89, 0x01,
  0x9D, 0xFD, 0x91, 0x01, 0xDD, 0x81, 0xD1, 0x9A, 0x89, 0x56, 0x25, 0xEF, 0x7E, 0xFA, 0x11, 0x19,
  0xFC, 0xF9, 0x0D, 0xF9, 0x82, 0xED, 0xF9, 0x60, 0x8A, 0x86, 0x83, 0x23, 0x65, 0x0C, 0xE0, 0x92,
  0x85, 0x7C, 0xEF, 0xDA, 0x40,
  // "Ė" (U+0116)
  0x48, 0x1B, 0xE9, 0x50, 0x2A, 0x0E, 0x68, 0x1B, 0xF8, 0x74, 0x08, 0xF0, 0x08, 0xF8, 0x28, 0x8F,
  0xE8, 0x01, 0x11, 0x81, 0x8F, 0xE6, 0x81, 0x8F, 0xE6, 0x08, 0xF0, 0x40, 0x8F, 0x82, 0x48, 0xFE,
  0x80, 0x11, 0x18, 0x18, 0xFE, 0x68, 0x18, 0xFE, 0x68, 0x18, 0xFE, 0x80, 0x11, 0x10, 0x8F, 0x00,
  0x8F, 0x08,
  // "ė" (U+0117)
  0x48, 0x1B, 0xE9, 0x50, 0x2A, 0x0E, 0x68, 0x1B, 0xF8, 0x75, 0x89, 0x01, 0x9D, 0xFD, 0x91, 0x01,
  0xDD, 0x81, 0xD1, 0x9A, 0x89, 0x56, 0x25, 0xEF, 0x7E, 0xFA, 0x11, 0x19, 0xFC, 0xF9, 0x0D, 0xF9,
  0x82, 0xED, 0xF9, 0x60, 0x8A, 0x86, 0x83, 0x23, 0x65, 0x0C, 0xE0, 0x92, 0x85, 0x7C, 0xEF, 0xDA,
  0x40,
  // "Ę" (U+0118)
  0x08, 0xF0, 0x08, 0xF8, 0x28, 0x8F, 0xE8, 0x01, 0x11, 0x81, 0x8F, 0xE6, 0x81, 0x8F, 0xE6, 0x08,
  0xF0, 0x40, 0x8F, 0x82, 0x48, 0xFE, 0x80, 0x11, 0x18, 0x18, 0xFE, 0x68, 0x18, 0xFE, 0x68, 0x18,
  0xFE, 0x80, 0x11, 0x10, 0x8F, 0x00, 0x8F, 0x08, 0x50, 0x0C, 0x68, 0x22, 0xFC, 0x25, 0x01, 0xB0,
  0x35, 0x82, 0x6E, 0xE2,
  // "ę" (U+0119)
  0x18, 0x90, 0x19, 0xDF, 0xD9, 0x10, 0x1D, 0xD8, 0x1D, 0x19, 0xA8, 0x95, 0x62, 0x5E, 0xF7, 0xEF,
  0xA1, 0x11, 0x9F, 0xCF, 0x90, 0xDF, 0x98, 0x2E, 0xDF, 0x96, 0x08, 0xA8, 0x68, 0x32, 0x36, 0x50,
  0xCE, 0x09, 0x28, 0x17, 0xCE, 0xA0, 0xE0, 0x45, 0x81, 0x6F, 0x26, 0x82, 0xEE, 0x21, 0x50, 0xEA,
  0x05, 0x58, 0x25, 0xDE, 0x40,
  // "Ě" (U+011A)
  0x28, 0x5A, 0xE5, 0x08, 0xF7, 0x38, 0x3D, 0xFA, 0xFB, 0x40, 0x3A, 0x0E, 0x01, 0x73, 0x08, 0xF0,
  0x08, 0xF8, 0x28, 0x8F, 0xE8, 0x01, 0x11, 0x81, 0x8F, 0xE6, 0x81, 0x8F, 0xE6, 0x08, 0xF0, 0x40,
  0x8F, 0x82, 0x48, 0xFE, 0x80, 0x11, 0x18, 0x18, 0xFE, 0x68, 0x18, 0xFE, 0x68, 0x18, 0xFE, 0x80,
  0x11, 0x10, 0x8F, 0x00, 0x8F, 0x08,
  // "ě" (U+011B)
  0x28, 0x5A, 0xE5, 0x08, 0xF7, 0x38, 0x3D, 0xFA, 0xFB, 0x40, 0x3A, 0x0E, 0x01, 0x74, 0x89, 0x01,
  0x9D, 0xFD, 0x91, 0x01, 0xDD, 0x81, 0xD1, 0x9A, 0x89, 0x56, 0x25, 0xEF, 0x7E, 0xFA, 0x11, 0x19,
  0xFC, 0xF9, 0x0D, 0xF9, 0x82, 0xED, 0xF9, 0x60, 0x8A, 0x86, 0x83, 0x23, 0x65, 0x0C, 0xE0, 0x92,
  0x85, 0x7C, 0xEF, 0xDA, 0x40,
  // "Ĝ" (U+011C)
  0x40, 0x2A, 0x0E, 0x02, 0x58, 0x3C, 0xFA, 0xFB, 0x48, 0x59, 0xF5, 0x07, 0xF8, 0x76, 0x85, 0x5B,
  0xEF, 0xDA, 0x52, 0x0A, 0xE8, 0x19, 0x06, 0xA8, 0x90, 0xC4, 0x23, 0x82, 0x0E, 0xFD, 0x60, 0x3A,
  0x07, 0x60, 0x5A, 0x04, 0x28, 0x00, 0x10, 0x6A, 0x81, 0x20, 0x2C, 0x06, 0xA8, 0x13, 0x02, 0xC0,
  0x4A, 0x06, 0x30, 0x5A, 0x18, 0x1E, 0xFC, 0x30, 0x5A, 0x10, 0x8A, 0x82, 0xA3, 0x27, 0xA2, 0x0C,
  0xF3, 0x85, 0x7C, 0xEF, 0xDB, 0x60,
  // "ĝ" (U+011D)
  0x30, 0x2A, 0x0E, 0x02, 0x58, 0x3C, 0xFA, 0xFB, 0x48, 0x59, 0xF5, 0x07, 0xF8, 0x76, 0x89, 0x06,
  0xDF, 0xC4, 0x5F, 0xC0, 0x5D, 0x89, 0x0D, 0xFC, 0x0D, 0xFE, 0x52, 0x7A, 0x0C, 0x02, 0xA0, 0x93,
  0x82, 0xDF, 0xC3, 0xA0, 0x63, 0x82, 0xAF, 0xC3, 0xA0, 0x63, 0x82, 0xAF, 0xC2, 0xA0, 0x93, 0x89,
  0x0C, 0xFC, 0x0D, 0xFE, 0x52, 0x7A, 0x81, 0xC0, 0x6D, 0x81, 0xEF, 0xC2, 0x86, 0x6D, 0xFD, 0x5C,
  0xFC, 0x78, 0x90, 0xEF, 0xB0, 0x67, 0x32, 0x28, 0xA8, 0x17, 0x09, 0xE0, 0xC2, 0x85, 0x5B, 0xEF,
  0xEC, 0x72,
  // "Ğ" (U+011E)
  0x38, 0x57, 0xF5, 0x26, 0xF5, 0x30, 0x2C, 0x0E, 0x01, 0x48, 0x35, 0xDE, 0xC3, 0x77, 0x85, 0x5B,
  0xEF, 0xDA, 0x52, 0x0A, 0xE8, 0x19, 0x06, 0xA8, 0x90, 0xC4, 0x23, 0x82, 0x0E, 0xFD, 0x60, 0x3A,
  0x07, 0x60, 0x5A, 0x04, 0x28, 0x00, 0x10, 0x6A, 0x81, 0x20, 0x2C, 0x06, 0xA8, 0x13, 0x02, 0xC0,
  0x4A, 0x06, 0x30, 0x5A, 0x18, 0x1E, 0xFC, 0x30, 0x5A, 0x10, 0x8A, 0x82, 0xA3, 0x27, 0xA2, 0x0C,
  0xF3, 0x85, 0x7C, 0xEF, 0xDB, 0x60,
  // "ğ" (U+011F)
  0x28, 0x57, 0xF5, 0x26, 0xF5, 0x30, 0x2C, 0x0E, 0x01, 0x48, 0x35, 0xDE, 0xC3, 0x77, 0x89, 0x06,
  0xDF, 0xC4, 0x5F, 0xC0, 0x5D, 0x89, 0x0D, 0xFC, 0x0D, 0xFE, 0x52, 0x7A, 0x0C, 0x02, 0xA0, 0x93,
  0x82, 0xDF, 0xC3, 0xA0, 0x63, 0x82, 0xAF, 0xC3, 0xA0, 0x63, 0x82, 0xAF, 0xC2, 0xA0, 0x93, 0x89,
  0x0C, 0xFC, 0x0D, 0xFE, 0x52, 0x7A, 0x81, 0xC0, 0x6D, 0x81, 0xEF, 0xC2, 0x86, 0x6D, 0xFD, 0x5C,
  0xFC, 0x78, 0x90, 0xEF, 0xB0, 0x67, 0x32, 0x28, 0xA8, 0x17, 0x09, 0xE0, 0xC2, 0x85, 0x5B, 0xEF,
  0xEC, 0x72,
  // "Ġ" (U+0120)
  0x58, 0x1B, 0xE9, 0x60, 0x2A, 0x0E, 0x78, 0x1B, 0xF8, 0x77, 0x18, 0x55, 0xBE, 0xFD, 0xA5, 0x20,
  0xAE, 0x81, 0x90, 0x6A, 0x89, 0x0C, 0x42, 0x38, 0x20, 0xEF, 0xD6, 0x03, 0xA0, 0x76, 0x05, 0xA0,
  0x42, 0x80, 0x01, 0x06, 0xA8, 0x12, 0x02, 0xC0, 0x6A, 0x81, 0x30, 0x2C, 0x04, 0xA0, 0x63, 0x05,
  0xA1, 0x81, 0xEF, 0xC3, 0x05, 0xA1, 0x08, 0xA8, 0x2A, 0x32, 0x7A, 0x20, 0xCF, 0x38, 0x57, 0xCE,
  0xFD, 0xB6,
  // "ġ" (U+0121)
  0x48, 0x1B, 0xE9, 0x60, 0x2A, 0x0E, 0x78, 0x1B, 0xF8, 0x77, 0x18, 0x90, 0x6D, 0xFC, 0x45, 0xFC,
  0x05, 0xD8, 0x90, 0xDF, 0xC0, 0xDF, 0xE5, 0x27, 0xA0, 0xC0, 0x2A, 0x09, 0x38, 0x2D, 0xFC, 0x3A,
  0x06, 0x38, 0x2A, 0xFC, 0x3A, 0x06, 0x38, 0x2A, 0xFC, 0x2A, 0x09, 0x38, 0x90, 0xCF, 0xC0, 0xDF,
  0xE5, 0x27, 0xA8, 0x1C, 0x06, 0xD8, 0x1E, 0xFC, 0x28, 0x66, 0xDF, 0xD5, 0xCF, 0xC7, 0x89, 0x0E,
  0xFB, 0x06, 0x73, 0x22, 0x8A, 0x81, 0x70, 0x9E, 0x0C, 0x28, 0x55, 0xBE, 0xFE, 0xC7, 0x20,
  // "Ģ" (U+0122)
  0x38, 0x55, 0xBE, 0xFD, 0xA5, 0x20, 0xAE, 0x81, 0x90, 0x6A, 0x89, 0x0C, 0x42, 0x38, 0x20, 0xEF,
  0xD6, 0x03, 0xA0, 0x76, 0x05, 0xA0, 0x42, 0x80, 0x01, 0x06, 0xA8, 0x12, 0x02, 0xC0, 0x6A, 0x81,
  0x30, 0x2C, 0x04, 0xA0, 0x63, 0x05, 0xA1, 0x81, 0xEF, 0xC3, 0x05, 0xA1, 0x08, 0xA8, 0x2A, 0x32,
  0x7A, 0x20, 0xCF, 0x38, 0x57, 0xCE, 0xFD, 0xB6, 0x77, 0x82, 0x4D, 0xD1, 0x68, 0x17, 0xF9, 0x78,
  0x1B, 0xE1, 0x30,
  // "ģ" (U+0123)
  0x50, 0xD0, 0xC7, 0x81, 0x7F, 0x87, 0x81, 0xCD, 0x57, 0x71, 0x89, 0x06, 0xDF, 0xC4, 0x5F, 0xC0,
  0x5D, 0x89, 0x0D, 0xFC, 0x0D, 0xFE, 0x52, 0x7A, 0x0C, 0x02, 0xA0, 0x93, 0x82, 0xDF, 0xC3, 0xA0,
  0x63, 0x82, 0xAF, 0xC3, 0xA0, 0x63, 0x82, 0xAF, 0xC2, 0xA0, 0x93, 0x89, 0x0C, 0xFC, 0x0D, 0xFE,
  0x52, 0x7A, 0x81, 0xC0, 0x6D, 0x81, 0xEF, 0xC2, 0x86, 0x6D, 0xFD, 0x5C, 0xFC, 0x78, 0x90, 0xEF,
  0xB0, 0x67, 0x32, 0x28, 0xA8, 0x17, 0x09, 0xE0, 0xC2, 0x85, 0x5B, 0xEF, 0xEC, 0x72,
  // "Ĥ" (U+0124)
  0x30, 0x2A, 0x0E, 0x02, 0x58, 0x3C, 0xFA, 0xFB, 0x48, 0x59, 0xF5, 0x07, 0xF8, 0x74, 0x02, 0xA0,
  0x63, 0x09, 0xA0, 0x2A, 0x06, 0x30, 0x9A, 0x02, 0xA0, 0x63, 0x09, 0xA0, 0x2A, 0x06, 0x30, 0x9A,
  0x02, 0xA0, 0x63, 0x09, 0xA0, 0x2F, 0xA0, 0x2F, 0xA0, 0x2A, 0x83, 0x71, 0x11, 0xAA, 0x02, 0xA0,
  0x63, 0x09, 0xA0, 0x2A, 0x06, 0x30, 0x9A, 0x02, 0xA0, 0x63, 0x09, 0xA0, 0x2A, 0x06, 0x30, 0x9A,
  0x02, 0xA0, 0x63, 0x09, 0xA0,
  // "ĥ" (U+0125)
  0x10, 0x2A, 0x0E, 0x02, 0x68, 0x3C, 0xFA, 0xFB, 0x58, 0x59, 0xF5, 0x07, 0xF8, 0x77, 0x3A, 0x09,
  0x71, 0xA0, 0x97, 0x1A, 0x09, 0x71, 0xA0, 0x97, 0x1A, 0x84, 0x86, 0xDF, 0xC6, 0x3A, 0x0D, 0xD0,
  0x52, 0xB8, 0x18, 0x25, 0xA0, 0xB2, 0xA0, 0xD3, 0x81, 0xCF, 0xD2, 0xA0, 0xA3, 0x81, 0xAF, 0xE2,
  0xA0, 0x93, 0x81, 0xAF, 0xE2, 0xA0, 0x93, 0x81, 0xAF, 0xE2, 0xA0, 0x93, 0x81, 0xAF, 0xE2, 0xA0,
  0x93, 0x81, 0xAF, 0xE2, 0xA0, 0x93, 0x81, 0xAF, 0xE0,
  // "Ħ" (U+0126)
  0x1A, 0x09, 0x38, 0x3C, 0xFC, 0x01, 0xA8, 0x6A, 0x11, 0x1C, 0xFC, 0x1F, 0xB0, 0xCF, 0xB0, 0xC1,
  0xA0, 0x93, 0x81, 0xCF, 0xC2, 0xF9, 0x0C, 0x2F, 0x90, 0xC2, 0xA8, 0x5A, 0x11, 0x1C, 0xFC, 0x2A,
  0x09, 0x38, 0x1C, 0xFC, 0x2A, 0x09, 0x38, 0x1C, 0xFC, 0x2A, 0x09, 0x38, 0x1C, 0xFC, 0x2A, 0x09,
  0x38, 0x1C, 0xFC, 0x2A, 0x09, 0x38, 0x1C, 0xFC, 0x10,
  // "ħ" (U+0127)
  0x1A, 0x09, 0x7A, 0x09, 0x6E, 0x04, 0x3E, 0x04, 0x4A, 0x84, 0x86, 0xDF, 0xC6, 0x2A, 0x0D, 0xD0,
  0x51, 0xB8, 0x18, 0x26, 0xA0, 0xB1, 0xA0, 0xD3, 0x81, 0xCF, 0xD1, 0xA0, 0xA3, 0x81, 0xBF, 0xE1,
  0xA0, 0x93, 0x81, 0xAF, 0xE1, 0xA0, 0x93, 0x81, 0xAF, 0xE1, 0xA0, 0x93, 0x81, 0xAF, 0xE1, 0xA0,
  0x93, 0x81, 0xAF, 0xE1, 0xA0, 0x93, 0x81, 0xAF, 0xE0,
  // "Ĩ" (U+0128)
  0x18, 0x51, 0xAA, 0x30, 0x78, 0x20, 0xAB, 0x81, 0xDF, 0x82, 0x85, 0xE7, 0x29, 0xEC, 0x17, 0x30,
  0x5F, 0x02, 0x05, 0xF0, 0x22, 0x83, 0x2E, 0xFA, 0x25, 0x81, 0xDF, 0x96, 0x81, 0xDF, 0x96, 0x81,
  0xDF, 0x96, 0x81, 0xDF, 0x96, 0x81, 0xDF, 0x96, 0x81, 0xDF, 0x96, 0x81, 0xDF, 0x96, 0x81, 0xDF,
  0xA3, 0x04, 0x0D, 0xD8, 0x1D, 0x25, 0xF0, 0x20,
  // "ĩ" (U+0129)
  0x18, 0x51, 0xAA, 0x30, 0x78, 0x20, 0xAB, 0x81, 0xDF, 0x82, 0x85, 0xE7, 0x29, 0xEC, 0x17, 0x30,
  0x6D, 0x30, 0x6D, 0x50, 0x10, 0xBA, 0x60, 0x9A, 0x60, 0x9A, 0x60, 0x9A, 0x60, 0x9A, 0x60, 0xAA,
  0x01, 0x20, 0xA0, 0xDD, 0x81, 0xEA, 0xEF, 0x0E,
  // "Ī" (U+012A)
  0x28, 0x01, 0x13, 0x04, 0xD0, 0x22, 0x04, 0xD0, 0x27, 0x30, 0x5F, 0x02, 0x05, 0xF0, 0x22, 0x83,
  0x2E, 0xFA, 0x25, 0x81, 0xDF, 0x96, 0x81, 0xDF, 0x96, 0x81, 0xDF, 0x96, 0x81, 0xDF, 0x96, 0x81,
  0xDF, 0x96, 0x81, 0xDF, 0x96, 0x81, 0xDF, 0x96, 0x81, 0xDF, 0xA3, 0x04, 0x0D, 0xD8, 0x1D, 0x25,
  0xF0, 0x20,
  // "ī" (U+012B)
  0x28, 0x01, 0x13, 0x04, 0xD0, 0x22, 0x04, 0xD0, 0x27, 0x30, 0x6D, 0x30, 0x6D, 0x50, 0x10, 0xBA,
  0x60, 0x9A, 0x60, 0x9A, 0x60, 0x9A, 0x60, 0x9A, 0x60, 0xAA, 0x01, 0x20, 0xA0, 0xDD, 0x81, 0xEA,
  0xEF, 0x0E,
  // "Ĭ" (U+012C)
  0x18, 0x57, 0xF5, 0x26, 0xF5, 0x20, 0x2C, 0x0E, 0x01, 0x38, 0x35, 0xDE, 0xC3, 0x74, 0x05, 0xF0,
  0x20, 0x5F, 0x02, 0x28, 0x32, 0xEF, 0xA2, 0x58, 0x1D, 0xF9, 0x68, 0x1D, 0xF9, 0x68, 0x1D, 0xF9,
  0x68, 0x1D, 0xF9, 0x68, 0x1D, 0xF9, 0x68, 0x1D, 0xF9, 0x68, 0x1D, 0xF9, 0x68, 0x1D, 0xFA, 0x30,
  0x40, 0xDD, 0x81, 0xD2, 0x5F, 0x02,
  // "ĭ" (U+012D)
  0x18, 0x57, 0xF5, 0x26, 0xF5, 0x20, 0x2C, 0x0E, 0x01, 0x38, 0x35, 0xDE, 0xC3, 0x74, 0x06, 0xD3,
  0x06, 0xD5, 0x01, 0x0B, 0xA6, 0x09, 0xA6, 0x09, 0xA6, 0x09, 0xA6, 0x09, 0xA6, 0x0A, 0xA0, 0x12,
  0x0A, 0x0D, 0xD8, 0x1E, 0xAE, 0xF0, 0xE0,
  // "Į" (U+012E)
  0x05, 0xF0, 0x20, 0x5F, 0x02, 0x28, 0x32, 0xEF, 0xA2, 0x58, 0x1D, 0xF9, 0x68, 0x1D, 0xF9, 0x68,
  0x1D, 0xF9, 0x68, 0x1D, 0xF9, 0x68, 0x1D, 0xF9, 0x68, 0x1D, 0xF9, 0x68, 0x1D, 0xF9, 0x68, 0x1D,
  0xFA, 0x30, 0x40, 0xDD, 0x81, 0xD2, 0x5F, 0x02, 0x40, 0x0C, 0x68, 0x22, 0xFC, 0x25, 0x01, 0xB0,
  0x35, 0x82, 0x6E, 0xE2, 0x10,
  // "į" (U+012F)
  0x38, 0x27, 0xEC, 0x15, 0x0D, 0xA0, 0x35, 0x81, 0x7E, 0xC7, 0x50, 0x6D, 0x30, 0x6D, 0x50, 0x10,
  0xBA, 0x60, 0x9A, 0x60, 0x9A, 0x60, 0x9A, 0x60, 0x9A, 0x60, 0xAA, 0x01, 0x20, 0xA0, 0xDD, 0x81,
  0xEA, 0xEF, 0x0E, 0x50, 0x0C, 0x68, 0x22, 0xFC, 0x25, 0x01, 0xB0, 0x35, 0x82, 0x6E, 0xE2,
  // "İ" (U+0130)
  0x38, 0x1B, 0xE9, 0x50, 0x2A, 0x0E, 0x68, 0x1B, 0xF8, 0x75, 0x05, 0xF0, 0x20, 0x5F, 0x02, 0x28,
  0x32, 0xEF, 0xA2, 0x58, 0x1D, 0xF9, 0x68, 0x1D, 0xF9, 0x68, 0x1D, 0xF9, 0x68, 0x1D, 0xF9, 0x68,
  0x1D, 0xF9, 0x68, 0x1D, 0xF9, 0x68, 0x1D, 0xF9, 0x68, 0x1D, 0xFA, 0x30, 0x40, 0xDD, 0x81, 0xD2,
  0x5F, 0x02,
  // "ı" (U+0131)
  0x06, 0xD3, 0x06, 0xD5, 0x01, 0x0B, 0xA6, 0x09, 0xA6, 0x09, 0xA6, 0x09, 0xA6, 0x09, 0xA6, 0x0A,
  0xA0, 0x12, 0x0A, 0x0D, 0xD8, 0x1E, 0xAE, 0xF0, 0xE0,
  // "Ĳ" (U+0132)
  0x07, 0xA2, 0x04, 0xA0, 0x40, 0x7A, 0x20, 0x4A, 0x04, 0x07, 0xA2, 0x04, 0xA0, 0x40, 0x7A, 0x20,
  0x4A, 0x04, 0x07, 0xA2, 0x04, 0xA0, 0x40, 0x7A, 0x20, 0x4A, 0x04, 0x07, 0xA2, 0x04, 0xA0, 0x40,
  0x7A, 0x20, 0x4A, 0x04, 0x07, 0xA2, 0x04, 0xA0, 0x35, 0x07, 0xA8, 0x91, 0x23, 0x65, 0x47, 0xEF,
  0xE0, 0x7E, 0x87, 0x60, 0x4C, 0xEF, 0xEB, 0x42,
  // "ĳ" (U+0133)
  0x89, 0x04, 0xED, 0x30, 0x5E, 0xD2, 0x9A, 0x81, 0x70, 0xAA, 0x89, 0x06, 0x4E, 0xD3, 0x05, 0xED,
  0x27, 0x20, 0x6A, 0x81, 0x30, 0x7A, 0x02, 0x06, 0xA8, 0x13, 0x07, 0xA0, 0x20, 0x6A, 0x81, 0x30,
  0x7A, 0x02, 0x06, 0xA8, 0x13, 0x07, 0xA0, 0x20, 0x6A, 0x81, 0x30, 0x7A, 0x02, 0x06, 0xA8, 0x13,
  0x07, 0xA0, 0x20, 0x6A, 0x81, 0x30, 0x7A, 0x02, 0x06, 0xA8, 0x13, 0x07, 0xA0, 0x20, 0x6A, 0x81,
  0x30, 0x7A, 0x02, 0x06, 0xA8, 0x13, 0x07, 0xA0, 0x25, 0x09, 0xA8, 0x41, 0x06, 0x54, 0x7A, 0x0E,
  0x20, 0xDD, 0x07, 0x20, 0x90, 0xDA, 0x0C, 0x06, 0x20,
  // "Ĵ" (U+0134)
  0x40, 0x2A, 0x0E, 0x02, 0x58, 0x3C, 0xFA, 0xFB, 0x48, 0x59, 0xF5, 0x07, 0xF8, 0x77, 0x18, 0x1B,
  0xFC, 0x78, 0x1B, 0xFC, 0x78, 0x1B, 0xFC, 0x78, 0x1B, 0xFC, 0x78, 0x1B, 0xFC, 0x78, 0x1B, 0xFC,
  0x78, 0x1B, 0xFC, 0x78, 0x1B, 0xFC, 0x78, 0x1B, 0xFC, 0x78, 0x1E, 0xFB, 0x28, 0x34, 0x64, 0x4A,
  0xA0, 0x72, 0x07, 0xD0, 0xD0, 0x12, 0x85, 0x4D, 0xEF, 0xD9, 0x13,
  // "ĵ" (U+0135)
  0x40, 0x2A, 0x0E, 0x02, 0x58, 0x3C, 0xFA, 0xFB, 0x48, 0x59, 0xF5, 0x07, 0xF8, 0x75, 0x0A, 0xC0,
  0xB4, 0x0A, 0xC0, 0xB5, 0x83, 0x12, 0xEF, 0xB7, 0x81, 0xDF, 0xB7, 0x81, 0xDF, 0xB7, 0x81, 0xDF,
  0xB7, 0x81, 0xDF, 0xB7, 0x81, 0xDF, 0xB7, 0x81, 0xDF, 0xB7, 0x81, 0xEF, 0xB7, 0xA0, 0xA2, 0x83,
  0x26, 0x44, 0xBA, 0x08, 0x20, 0x4D, 0x0E, 0x01, 0x28, 0x52, 0xCE, 0xFE, 0xA2, 0x30,
  // "Ķ" (U+0136)
  0x02, 0xA0, 0x52, 0x83, 0x1E, 0xFC, 0x2A, 0x05, 0x20, 0xAA, 0x00, 0x2A, 0x81, 0x50, 0x4A, 0x81,
  0x70, 0x2A, 0x83, 0x50, 0xDF, 0xB2, 0x02, 0xA8, 0x35, 0x9F, 0xE2, 0x20, 0x2A, 0x08, 0xA0, 0x63,
  0x02, 0xD0, 0x73, 0x02, 0xB8, 0x2E, 0xFE, 0x12, 0x02, 0xA0, 0xA0, 0x2A, 0x09, 0x20, 0x2A, 0x81,
  0x50, 0x9A, 0x81, 0x20, 0x2A, 0x81, 0x50, 0x1A, 0x81, 0xA0, 0x2A, 0x05, 0x20, 0x8A, 0x03, 0x02,
  0xA0, 0x52, 0x82, 0x1E, 0xFC, 0x77, 0x82, 0x4D, 0xD1, 0x68, 0x17, 0xF9, 0x78, 0x1B, 0xE1, 0x30,
  // "ķ" (U+0137)
  0x81, 0xEF, 0xA7, 0x81, 0xEF, 0xA7, 0x81, 0xEF, 0xA7, 0x81, 0xEF, 0xA7, 0x81, 0xEF, 0xA2, 0x8A,
  0x52, 0xEF, 0xC0, 0xEF, 0xA0, 0x1D, 0xFD, 0x10, 0xEF, 0xA0, 0xCF, 0xE2, 0x28, 0x2E, 0xFA, 0x9A,
  0x04, 0x38, 0x1E, 0xFD, 0xA0, 0xD4, 0x0E, 0xD0, 0x83, 0x83, 0xEF, 0xE4, 0x7A, 0x03, 0x28, 0x1E,
  0xFA, 0x28, 0x1D, 0xFD, 0x28, 0x1E, 0xFA, 0x20, 0x3A, 0x83, 0x80, 0xEF, 0xA3, 0x09, 0xA0, 0x37,
  0x68, 0x24, 0xDD, 0x16, 0x81, 0x7F, 0x97, 0x81, 0xBE, 0x14,
  // "ĸ" (U+0138)
  0x81, 0xEF, 0xA2, 0x8A, 0x52, 0xEF, 0xC0, 0xEF, 0xA0, 0x1D, 0xFD, 0x10, 0xEF, 0xA0, 0xCF, 0xE2,
  0x28, 0x2E, 0xFA, 0x9A, 0x04, 0x38, 0x1E, 0xFD, 0xA0, 0xD4, 0x0E, 0xD0, 0x83, 0x83, 0xEF, 0xE4,
  0x7A, 0x03, 0x28, 0x1E, 0xFA, 0x28, 0x1D, 0xFD, 0x28, 0x1E, 0xFA, 0x20, 0x3A, 0x83, 0x80, 0xEF,
  0xA3, 0x09, 0xA0, 0x30,
  // "Ĺ" (U+0139)
  0x20, 0x7A, 0x05, 0x40, 0x2A, 0x06, 0x58, 0x1C, 0xF5, 0x77, 0x05, 0xA0, 0x35, 0x05, 0xA0, 0x35,
  0x05, 0xA0, 0x35, 0x05, 0xA0, 0x35, 0x05, 0xA0, 0x35, 0x05, 0xA0, 0x35, 0x05, 0xA0, 0x35, 0x05,
  0xA0, 0x35, 0x05, 0xA0, 0x35, 0x05, 0xA0, 0x35, 0x05, 0xA8, 0x57, 0x44, 0x44, 0x25, 0xF0, 0x80,
  0x5F, 0x08,
  // "ĺ" (U+013A)
  0x40, 0x7A, 0x05, 0x40, 0x2A, 0x06, 0x58, 0x1C, 0xF5, 0x75, 0x04, 0xC0, 0xE3, 0x03, 0x0E, 0xB0,
  0xE5, 0x82, 0x2B, 0xFE, 0x68, 0x1A, 0xFE, 0x68, 0x1A, 0xFE, 0x68, 0x1A, 0xFE, 0x68, 0x1A, 0xFE,
  0x68, 0x1A, 0xFE, 0x68, 0x1A, 0xFE, 0x68, 0x1A, 0xFE, 0x68, 0x1A, 0xFE, 0x68, 0x2B, 0xFE, 0x12,
  0x0A, 0x0D, 0xD8, 0x1E, 0xAE, 0xF0, 0xE0,
  // "Ļ" (U+013B)
  0x05, 0xA0, 0x35, 0x05, 0xA0, 0x35, 0x05, 0xA0, 0x35, 0x05, 0xA0, 0x35, 0x05, 0xA0, 0x35, 0x05,
  0xA0, 0x35, 0x05, 0xA0, 0x35, 0x05, 0xA0, 0x35, 0x05, 0xA0, 0x35, 0x05, 0xA0, 0x35, 0x05, 0xA8,
  0x57, 0x44, 0x44, 0x25, 0xF0, 0x80, 0x5F, 0x08, 0x75, 0x82, 0x4D, 0xD1, 0x58, 0x17, 0xF9, 0x68,
  0x1B, 0xE1, 0x30,
  // "ļ" (U+013C)
  0x04, 0xC0, 0xE3, 0x03, 0x0E, 0xB0, 0xE5, 0x82, 0x2B, 0xFE, 0x68, 0x1A, 0xFE, 0x68, 0x1A, 0xFE,
  0x68, 0x1A, 0xFE, 0x68, 0x1A, 0xFE, 0x68, 0x1A, 0xFE, 0x68, 0x1A, 0xFE, 0x68, 0x1A, 0xFE, 0x68,
  0x1A, 0xFE, 0x68, 0x2B, 0xFE, 0x12, 0x0A, 0x0D, 0xD8, 0x1E, 0xAE, 0xF0, 0xE7, 0x58, 0x24, 0xDD,
  0x15, 0x81, 0x7F, 0x96, 0x81, 0xBE, 0x13,
  // "Ľ" (U+013D)
  0x05, 0xA0, 0x32, 0xA0, 0x40, 0x5A, 0x85, 0x30, 0x3F, 0xC0, 0x5A, 0x85, 0x30, 0x5D, 0x30, 0x5A,
  0x03, 0x50, 0x5A, 0x03, 0x50, 0x5A, 0x03, 0x50, 0x5A, 0x03, 0x50, 0x5A, 0x03, 0x50, 0x5A, 0x03,
  0x50, 0x5A, 0x03, 0x50, 0x5A, 0x85, 0x74, 0x44, 0x42, 0x5F, 0x08, 0x05, 0xF0, 0x80,
  // "ľ" (U+013E)
  0x04, 0xC8, 0x5E, 0x0C, 0xF8, 0x3C, 0xB8, 0x3E, 0x0E, 0xE1, 0x38, 0x4B, 0xFE, 0x2D, 0x74, 0x81,
  0xAF, 0xE7, 0x81, 0xAF, 0xE7, 0x81, 0xAF, 0xE7, 0x81, 0xAF, 0xE7, 0x81, 0xAF, 0xE7, 0x81, 0xAF,
  0xE7, 0x81, 0xAF, 0xE7, 0x81, 0xAF, 0xE7, 0x82, 0xBF, 0xE1, 0x30, 0xA0, 0xDD, 0x82, 0xEA, 0x0E,
  0xF0, 0xE1,
  // "Ŀ" (U+013F)
  0x05, 0xA0, 0x35, 0x05, 0xA0, 0x35, 0x05, 0xA0, 0x35, 0x05, 0xA0, 0x35, 0x05, 0xA0, 0x32, 0x82,
  0xBE, 0x95, 0xA8, 0x13, 0x03, 0xB0, 0x5A, 0x03, 0x28, 0x2B, 0xE8, 0x5A, 0x03, 0x50, 0x5A, 0x03,
  0x50, 0x5A, 0x03, 0x50, 0x5A, 0x85, 0x74, 0x44, 0x42, 0x5F, 0x08, 0x05, 0xF0, 0x80,
  // "ŀ" (U+0140)
  0x04, 0xC0, 0xE5, 0x03, 0x0E, 0xB0, 0xE7, 0x82, 0x2B, 0xFE, 0x71, 0x81, 0xAF, 0xE7, 0x18, 0x1A,
  0xFE, 0x71, 0x81, 0xAF, 0xE2, 0x81, 0xBE, 0x93, 0x83, 0xAF, 0xE0, 0x3B, 0x38, 0x1A, 0xFE, 0x28,
  0x1B, 0xE8, 0x38, 0x1A, 0xFE, 0x71, 0x81, 0xAF, 0xE7, 0x18, 0x1A, 0xFE, 0x71, 0x82, 0xBF, 0xE1,
  0x40, 0xA0, 0xDD, 0x0E, 0x0A, 0x20, 0xEF, 0x0E, 0x20,
  // "Ł" (U+0141)
  0x28, 0x1A, 0xFE, 0x71, 0x81, 0xAF, 0xE7, 0x18, 0x1A, 0xFE, 0x71, 0x81, 0xAF, 0xE7, 0x18, 0x3A,
  0xFE, 0x89, 0x60, 0xAC, 0x01, 0x40, 0x10, 0xCA, 0x0B, 0x02, 0x40, 0x10, 0xEA, 0x0E, 0x78, 0x29,
  0xEF, 0xE7, 0x18, 0x1A, 0xFE, 0x71, 0x0A, 0xA8, 0x01, 0x40, 0x12, 0x0A, 0xF0, 0x42, 0x0A, 0xF0,
  0x40,
  // "ł" (U+0142)
  0x04, 0xC0, 0xE3, 0x03, 0x0E, 0xB0, 0xE5, 0x82, 0x2B, 0xFE, 0x68, 0x1A, 0xFE, 0x68, 0x1A, 0xFE,
  0x60, 0xAA, 0x0D, 0x07, 0x40, 0xAB, 0x0B, 0x30, 0x50, 0xEA, 0x06, 0x30, 0x9B, 0x0E, 0x48, 0x35,
  0xDD, 0xFE, 0x68, 0x1A, 0xFE, 0x68, 0x2B, 0xFE, 0x12, 0x0A, 0x0D, 0xD8, 0x1E, 0xAE, 0xF0, 0xE0,
  // "Ń" (U+0143)
  0x50, 0x7A, 0x05, 0x50, 0x2A, 0x06, 0x68, 0x1C, 0xF5, 0x76, 0x02, 0xB0, 0x82, 0x05, 0xA0, 0x2B,
  0x0D, 0x20, 0x5A, 0x02, 0xA8, 0x3E, 0xF2, 0x05, 0xA0, 0x2A, 0x83, 0xAF, 0x70, 0x5A, 0x02, 0xA8,
  0x36, 0xFC, 0x05, 0xA0, 0x2A, 0x02, 0xA0, 0x10, 0x5A, 0x02, 0xA8, 0x31, 0xAF, 0x65, 0xA0, 0x2A,
  0x83, 0x15, 0xFB, 0x5A, 0x02, 0xA0, 0x01, 0xA0, 0x6A, 0x02, 0xA8, 0x31, 0x0B, 0xFA, 0xA0, 0x2A,
  0x83, 0x10, 0x6F, 0xEA, 0x02, 0xA8, 0x11, 0x01, 0xC0, 0x2A, 0x01, 0x20, 0xBB,
  // "ń" (U+0144)
  0x40, 0x7A, 0x05, 0x40, 0x2A, 0x06, 0x58, 0x1C, 0xF5, 0x75, 0xA8, 0x42, 0x7D, 0xFD, 0x61, 0xA0,
  0xDD, 0x05, 0xB8, 0x18, 0x26, 0xA0, 0xBA, 0x0D, 0x38, 0x1C, 0xFD, 0xA0, 0xA3, 0x81, 0xAF, 0xEA,
  0x09, 0x38, 0x1A, 0xFE, 0xA0, 0x93, 0x81, 0xAF, 0xEA, 0x09, 0x38, 0x1A, 0xFE, 0xA0, 0x93, 0x81,
  0xAF, 0xEA, 0x09, 0x38, 0x1A, 0xFE,
  // "Ņ" (U+0145)
  0x02, 0xB0, 0x82, 0x05, 0xA0, 0x2B, 0x0D, 0x20, 0x5A, 0x02, 0xA8, 0x3E, 0xF2, 0x05, 0xA0, 0x2A,
  0x83, 0xAF, 0x70, 0x5A, 0x02, 0xA8, 0x36, 0xFC, 0x05, 0xA0, 0x2A, 0x02, 0xA0, 0x10, 0x5A, 0x02,
  0xA8, 0x31, 0xAF, 0x65, 0xA0, 0x2A, 0x83, 0x15, 0xFB, 0x5A, 0x02, 0xA0, 0x01, 0xA0, 0x6A, 0x02,
  0xA8, 0x31, 0x0B, 0xFA, 0xA0, 0x2A, 0x83, 0x10, 0x6F, 0xEA, 0x02, 0xA8, 0x11, 0x01, 0xC0, 0x2A,
  0x01, 0x20, 0xBB, 0x76, 0x82, 0x4D, 0xD1, 0x68, 0x17, 0xF9, 0x78, 0x1B, 0xE1, 0x40,
  // "ņ" (U+0146)
  0xA8, 0x42, 0x7D, 0xFD, 0x61, 0xA0, 0xDD, 0x05, 0xB8, 0x18, 0x26, 0xA0, 0xBA, 0x0D, 0x38, 0x1C,
  0xFD, 0xA0, 0xA3, 0x81, 0xAF, 0xEA, 0x09, 0x38, 0x1A, 0xFE, 0xA0, 0x93, 0x81, 0xAF, 0xEA, 0x09,
  0x38, 0x1A, 0xFE, 0xA0, 0x93, 0x81, 0xAF, 0xEA, 0x09, 0x38, 0x1A, 0xFE, 0x74, 0x82, 0x4D, 0xD1,
  0x58, 0x17, 0xF9, 0x68, 0x1B, 0xE1, 0x40,
  // "Ň" (U+0147)
  0x28, 0x5A, 0xE5, 0x08, 0xF7, 0x48, 0x3D, 0xFA, 0xFB, 0x50, 0x3A, 0x0E, 0x01, 0x75, 0x02, 0xB0,
  0x82, 0x05, 0xA0, 0x2B, 0x0D, 0x20, 0x5A, 0x02, 0xA8, 0x3E, 0xF2, 0x05, 0xA0, 0x2A, 0x83, 0xAF,
  0x70, 0x5A, 0x02, 0xA8, 0x36, 0xFC, 0x05, 0xA0, 0x2A, 0x02, 0xA0, 0x10, 0x5A, 0x02, 0xA8, 0x31,
  0xAF, 0x65, 0xA0, 0x2A, 0x83, 0x15, 0xFB, 0x5A, 0x02, 0xA0, 0x01, 0xA0, 0x6A, 0x02, 0xA8, 0x31,
  0x0B, 0xFA, 0xA0, 0x2A, 0x83, 0x10, 0x6F, 0xEA, 0x02, 0xA8, 0x11, 0x01, 0xC0, 0x2A, 0x01, 0x20,
  0xBB,
  // "ň" (U+0148)
  0x18, 0x5A, 0xE5, 0x08, 0xF7, 0x38, 0x3D, 0xFA, 0xFB, 0x40, 0x3A, 0x0E, 0x01, 0x74, 0xA8, 0x42,
  0x7D, 0xFD, 0x61, 0xA0, 0xDD, 0x05, 0xB8, 0x18, 0x26, 0xA0, 0xBA, 0x0D, 0x38, 0x1C, 0xFD, 0xA0,
  0xA3, 0x81, 0xAF, 0xEA, 0x09, 0x38, 0x1A, 0xFE, 0xA0, 0x93, 0x81, 0xAF, 0xEA, 0x09, 0x38, 0x1A,
  0xFE, 0xA0, 0x93, 0x81, 0xAF, 0xEA, 0x09, 0x38, 0x1A, 0xFE,
  // "ŉ" (U+0149)
  0x04, 0xA0, 0x47, 0x18, 0x17, 0xFE, 0x72, 0x81, 0xAF, 0x87, 0x28, 0x91, 0xEF, 0x1C, 0xF7, 0x9D,
  0xFD, 0x64, 0x0C, 0xF0, 0x53, 0x0C, 0xA8, 0x1A, 0x25, 0xA0, 0xB3, 0x0C, 0xA0, 0x12, 0x81, 0xCF,
  0xD3, 0x81, 0xCF, 0xD3, 0x81, 0xAF, 0xE3, 0x81, 0xCF, 0xC3, 0x81, 0xAF, 0xE3, 0x81, 0xCF, 0xC3,
  0x81, 0xAF, 0xE3, 0x81, 0xCF, 0xC3, 0x81, 0xAF, 0xE3, 0x81, 0xCF, 0xC3, 0x81, 0xAF, 0xE3, 0x81,
  0xCF, 0xC3, 0x81, 0xAF, 0xE0,
  // "Ŋ" (U+014A)
  0x02, 0xB0, 0x82, 0x05, 0xA0, 0x2B, 0x0D, 0x20, 0x5A, 0x02, 0xA8, 0x3E, 0xF2, 0x05, 0xA0, 0x2A,
  0x83, 0xAF, 0x70, 0x5A, 0x02, 0xA8, 0x36, 0xFC, 0x05, 0xA0, 0x2A, 0x02, 0xA0, 0x10, 0x5A, 0x02,
  0xA8, 0x31, 0xAF, 0x65, 0xA0, 0x2A, 0x83, 0x15, 0xFB, 0x5A, 0x02, 0xA0, 0x01, 0xA0, 0x6A, 0x02,
  0xA8, 0x31, 0x0B, 0xFA, 0xA0, 0x2A, 0x83, 0x10, 0x6F, 0xEA, 0x02, 0xA8, 0x11, 0x01, 0xC0, 0x2A,
  0x01, 0x20, 0xBB, 0x78, 0x13, 0xFE, 0x48, 0x42, 0x23, 0xBF, 0xC4, 0x0B, 0xC0, 0x54, 0x83, 0x9F,
  0xEB, 0x41,
  // "ŋ" (U+014B)
  0xA8, 0x42, 0x7D, 0xFD, 0x61, 0xA0, 0xDD, 0x05, 0xB8, 0x18, 0x26, 0xA0, 0xBA, 0x0D, 0x38, 0x1C,
  0xFD, 0xA0, 0xA3, 0x81, 0xAF, 0xEA, 0x09, 0x38, 0x1A, 0xFE, 0xA0, 0x93, 0x81, 0xAF, 0xEA, 0x09,
  0x38, 0x1A, 0xFE, 0xA0, 0x93, 0x81, 0xAF, 0xEA, 0x09, 0x38, 0x1A, 0xFE, 0x68, 0x1B, 0xFE, 0x48,
  0x32, 0x3E, 0xFC, 0x40, 0xDB, 0x07, 0x48, 0x2B, 0xFE, 0x81,
  // "Ō" (U+014C)
  0x38, 0x01, 0x15, 0x04, 0xD0, 0x24, 0x04, 0xD0, 0x27, 0x71, 0x85, 0x2A, 0xEF, 0xD8, 0x13, 0x02,
  0x0E, 0xD0, 0xC3, 0x0A, 0xA8, 0x15, 0x28, 0xA8, 0x17, 0x01, 0xA0, 0x93, 0x83, 0xCF, 0xD0, 0x4A,
  0x05, 0x30, 0x8A, 0x01, 0x06, 0xA0, 0x33, 0x06, 0xA0, 0x30, 0x6A, 0x03, 0x30, 0x6A, 0x03, 0x06,
  0xA0, 0x33, 0x06, 0xA0, 0x30, 0x4A, 0x05, 0x30, 0x8A, 0x00, 0x1A, 0x09, 0x38, 0x1C, 0xFD, 0x20,
  0xAA, 0x81, 0x52, 0x8A, 0x07, 0x20, 0x20, 0xED, 0x0C, 0x48, 0x52, 0xAE, 0xFD, 0x81, 0x20,
  // "ō" (U+014D)
  0x38, 0x01, 0x14, 0x04, 0xD0, 0x23, 0x04, 0xD0, 0x27, 0x68, 0x51, 0x9D, 0xFD, 0x91, 0x20, 0x20,
  0xED, 0x82, 0xD1, 0x0B, 0xA8, 0x16, 0x27, 0xA0, 0x90, 0x1A, 0x09, 0x38, 0x2C, 0xFE, 0x3A, 0x06,
  0x30, 0x9A, 0x03, 0xA0, 0x63, 0x09, 0xA0, 0x1A, 0x09, 0x38, 0x3C, 0xFD, 0x0B, 0xA8, 0x16, 0x27,
  0xA8, 0x28, 0x02, 0xED, 0x0D, 0x38, 0x52, 0x9D, 0xFD, 0x81, 0x10,
  // "Ŏ" (U+014E)
  0x28, 0x57, 0xF5, 0x26, 0xF5, 0x40, 0x2C, 0x0E, 0x01, 0x58, 0x35, 0xDE, 0xC3, 0x77, 0x28, 0x52,
  0xAE, 0xFD, 0x81, 0x30, 0x20, 0xED, 0x0C, 0x30, 0xAA, 0x81, 0x52, 0x8A, 0x81, 0x70, 0x1A, 0x09,
  0x38, 0x3C, 0xFD, 0x04, 0xA0, 0x53, 0x08, 0xA0, 0x10, 0x6A, 0x03, 0x30, 0x6A, 0x03, 0x06, 0xA0,
  0x33, 0x06, 0xA0, 0x30, 0x6A, 0x03, 0x30, 0x6A, 0x03, 0x04, 0xA0, 0x53, 0x08, 0xA0, 0x01, 0xA0,
  0x93, 0x81, 0xCF, 0xD2, 0x0A, 0xA8, 0x15, 0x28, 0xA0, 0x72, 0x02, 0x0E, 0xD0, 0xC4, 0x85, 0x2A,
  0xEF, 0xD8, 0x12,
  // "ŏ" (U+014F)
  0x28, 0x57, 0xF5, 0x26, 0xF5, 0x30, 0x2C, 0x0E, 0x01, 0x48, 0x35, 0xDE, 0xC3, 0x77, 0x85, 0x19,
  0xDF, 0xD9, 0x12, 0x02, 0x0E, 0xD8, 0x2D, 0x10, 0xBA, 0x81, 0x62, 0x7A, 0x09, 0x01, 0xA0, 0x93,
  0x82, 0xCF, 0xE3, 0xA0, 0x63, 0x09, 0xA0, 0x3A, 0x06, 0x30, 0x9A, 0x01, 0xA0, 0x93, 0x83, 0xCF,
  0xD0, 0xBA, 0x81, 0x62, 0x7A, 0x82, 0x80, 0x2E, 0xD0, 0xD3, 0x85, 0x29, 0xDF, 0xD8, 0x11,
  // "Ő" (U+0150)
  0x38, 0x58, 0xDA, 0x5D, 0xC1, 0x38, 0x52, 0xFD, 0x2D, 0xE3, 0x48, 0x4B, 0xC1, 0x8E, 0x37, 0x72,
  0x85, 0x2A, 0xEF, 0xD8, 0x13, 0x02, 0x0E, 0xD0, 0xC3, 0x0A, 0xA8, 0x15, 0x28, 0xA8, 0x17, 0x01,
  0xA0, 0x93, 0x83, 0xCF, 0xD0, 0x4A, 0x05, 0x30, 0x8A, 0x01, 0x06, 0xA0, 0x33, 0x06, 0xA0, 0x30,
  0x6A, 0x03, 0x30, 0x6A, 0x03, 0x06, 0xA0, 0x33, 0x06, 0xA0, 0x30, 0x4A, 0x05, 0x30, 0x8A, 0x00,
  0x1A, 0x09, 0x38, 0x1C, 0xFD, 0x20, 0xAA, 0x81, 0x52, 0x8A, 0x07, 0x20, 0x20, 0xED, 0x0C, 0x48,
  0x52, 0xAE, 0xFD, 0x81, 0x20,
  // "ő" (U+0151)
  0x38, 0x58, 0xDA, 0x5D, 0xC1, 0x28, 0x52, 0xFD, 0x2D, 0xE3, 0x38, 0x4B, 0xC1, 0x8E, 0x37, 0x78,
  0x51, 0x9D, 0xFD, 0x91, 0x20, 0x20, 0xED, 0x82, 0xD1, 0x0B, 0xA8, 0x16, 0x27, 0xA0, 0x90, 0x1A,
  0x09, 0x38, 0x2C, 0xFE, 0x3A, 0x06, 0x30, 0x9A, 0x03, 0xA0, 0x63, 0x09, 0xA0, 0x1A, 0x09, 0x38,
  0x3C, 0xFD, 0x0B, 0xA8, 0x16, 0x27, 0xA8, 0x28, 0x02, 0xED, 0x0D, 0x38, 0x52, 0x9D, 0xFD, 0x81,
  0x10,
  // "Œ" (U+0152)
  0x20, 0x50, 0xCE, 0x81, 0x60, 0x4F, 0x98, 0x56, 0x0C, 0xFD, 0x38, 0xA8, 0x21, 0x10, 0x2A, 0x81,
  0x60, 0x7A, 0x30, 0x5A, 0x81, 0x30, 0x7A, 0x30, 0x6A, 0x81, 0x10, 0x7C, 0x01, 0x06, 0xA8, 0x11,
  0x07, 0xC0, 0x10, 0x6A, 0x81, 0x10, 0x7A, 0x82, 0x11, 0x05, 0xA8, 0x13, 0x07, 0xA3, 0x02, 0xA8,
  0x15, 0x07, 0xA4, 0x83, 0xDF, 0xC2, 0x8A, 0x00, 0x12, 0x05, 0xF9, 0x06, 0x20, 0x50, 0xCE, 0x06,
  // "œ" (U+0153)
  0x18, 0x73, 0xCE, 0xA1, 0x6E, 0xD4, 0x20, 0xEB, 0x0B, 0xB8, 0x5E, 0x05, 0xFD, 0x3D, 0xA8, 0xA2,
  0x3A, 0xF5, 0x8F, 0x80, 0x8F, 0xC1, 0x6F, 0x89, 0xF7, 0x06, 0xD8, 0x49, 0x9F, 0x70, 0x6D, 0x86,
  0x98, 0xF8, 0x08, 0xFB, 0x48, 0x35, 0xFD, 0x3D, 0xA8, 0x45, 0x24, 0x30, 0xDB, 0x0B, 0xC8, 0x92,
  0x50, 0x2C, 0xEA, 0x16, 0xEE, 0xA1,
  // "Ŕ" (U+0154)
  0x40, 0x7A, 0x05, 0x50, 0x2A, 0x06, 0x68, 0x1C, 0xF5, 0x77, 0x08, 0xB8, 0x1E, 0xC7, 0x30, 0x8E,
  0x0B, 0x20, 0x8A, 0x81, 0x23, 0xBA, 0x81, 0x40, 0x8A, 0x20, 0x2A, 0x81, 0x80, 0x8A, 0x20, 0x2A,
  0x81, 0x70, 0x8A, 0x10, 0x10, 0xAA, 0x81, 0x40, 0x8E, 0x0A, 0x20, 0x8D, 0x0A, 0x30, 0x8A, 0x82,
  0x2B, 0xFD, 0x30, 0x8A, 0x10, 0x2A, 0x07, 0x20, 0x8A, 0x28, 0x49, 0xFE, 0x10, 0x8A, 0x28, 0x41,
  0xEF, 0xA0, 0x8A, 0x30, 0x7A, 0x03,
  // "ŕ" (U+0155)
  0x60, 0x7A, 0x05, 0x60, 0x2A, 0x06, 0x78, 0x1C, 0xF5, 0x77, 0x10, 0xCB, 0x87, 0x63, 0xCF, 0xE5,
  0x08, 0xDA, 0x0C, 0xC0, 0x13, 0x0A, 0xA8, 0x2D, 0x42, 0x34, 0x0A, 0xA0, 0x37, 0x0A, 0xA7, 0x18,
  0x1A, 0xFE, 0x71, 0x81, 0xAF, 0xE7, 0x83, 0x1B, 0xFE, 0x14, 0x03, 0x0D, 0xD0, 0xE0, 0x52, 0x04,
  0xF0, 0x72,
  // "Ŗ" (U+0156)
  0x08, 0xB8, 0x1E, 0xC7, 0x30, 0x8E, 0x0B, 0x20, 0x8A, 0x81, 0x23, 0xBA, 0x81, 0x40, 0x8A, 0x20,
  0x2A, 0x81, 0x80, 0x8A, 0x20, 0x2A, 0x81, 0x70, 0x8A, 0x10, 0x10, 0xAA, 0x81, 0x40, 0x8E, 0x0A,
  0x20, 0x8D, 0x0A, 0x30, 0x8A, 0x82, 0x2B, 0xFD, 0x30, 0x8A, 0x10, 0x2A, 0x07, 0x20, 0x8A, 0x28,
  0x49, 0xFE, 0x10, 0x8A, 0x28, 0x41, 0xEF, 0xA0, 0x8A, 0x30, 0x7A, 0x03, 0x76, 0x82, 0x4D, 0xD1,
  0x68, 0x17, 0xF9, 0x78, 0x1B, 0xE1, 0x40,
  // "ŗ" (U+0157)
  0x10, 0xCB, 0x87, 0x63, 0xCF, 0xE5, 0x08, 0xDA, 0x0C, 0xC0, 0x13, 0x0A, 0xA8, 0x2D, 0x42, 0x34,
  0x0A, 0xA0, 0x37, 0x0A, 0xA7, 0x18, 0x1A, 0xFE, 0x71, 0x81, 0xAF, 0xE7, 0x83, 0x1B, 0xFE, 0x14,
  0x03, 0x0D, 0xD0, 0xE0, 0x52, 0x04, 0xF0, 0x77, 0x72, 0x82, 0x4D, 0xD1, 0x78, 0x17, 0xF9, 0x71,
  0x81, 0xBE, 0x15,
  // "Ř" (U+0158)
  0x18, 0x5A, 0xE5, 0x08, 0xF7, 0x48, 0x3D, 0xFA, 0xFB, 0x50, 0x3A, 0x0E, 0x01, 0x76, 0x08, 0xB8,
  0x1E, 0xC7, 0x30, 0x8E, 0x0B, 0x20, 0x8A, 0x81, 0x23, 0xBA, 0x81, 0x40, 0x8A, 0x20, 0x2A, 0x81,
  0x80, 0x8A, 0x20, 0x2A, 0x81, 0x70, 0x8A, 0x10, 0x10, 0xAA, 0x81, 0x40, 0x8E, 0x0A, 0x20, 0x8D,
  0x0A, 0x30, 0x8A, 0x82, 0x2B, 0xFD, 0x30, 0x8A, 0x10, 0x2A, 0x07, 0x20, 0x8A, 0x28, 0x49, 0xFE,
  0x10, 0x8A, 0x28, 0x41, 0xEF, 0xA0, 0x8A, 0x30, 0x7A, 0x03,
  // "ř" (U+0159)
  0x38, 0x5A, 0xE5, 0x08, 0xF7, 0x58, 0x3D, 0xFA, 0xFB, 0x60, 0x3A, 0x0E, 0x01, 0x77, 0x0C, 0xB8,
  0x76, 0x3C, 0xFE, 0x50, 0x8D, 0xA0, 0xCC, 0x01, 0x30, 0xAA, 0x82, 0xD4, 0x23, 0x40, 0xAA, 0x03,
  0x70, 0xAA, 0x71, 0x81, 0xAF, 0xE7, 0x18, 0x1A, 0xFE, 0x78, 0x31, 0xBF, 0xE1, 0x40, 0x30, 0xDD,
  0x0E, 0x05, 0x20, 0x4F, 0x07, 0x20,
  // "Ś" (U+015A)
  0x50, 0x7A, 0x05, 0x40, 0x2A, 0x06, 0x58, 0x1C, 0xF5, 0x75, 0x89, 0x01, 0x8D, 0xFE, 0xC8, 0x20,
  0xDE, 0x04, 0x05, 0xA8, 0x59, 0x23, 0x6A, 0x07, 0xA0, 0x35, 0x04, 0xA0, 0xA6, 0x0B, 0xA0, 0xE0,
  0x65, 0x09, 0xB0, 0xD0, 0x44, 0x03, 0x0B, 0xB0, 0x45, 0x05, 0xA0, 0xA6, 0x87, 0xEF, 0xBA, 0x84,
  0x22, 0x7A, 0x09, 0x0B, 0xE8, 0x90, 0xD1, 0x4A, 0xDE, 0xED, 0x81, 0x10,
  // "ś" (U+015B)
  0x40, 0x7A, 0x05, 0x40, 0x2A, 0x06, 0x58, 0x1C, 0xF5, 0x76, 0x87, 0x3A, 0xEF, 0xEC, 0x71, 0x2F,
  0x01, 0x06, 0xA8, 0x56, 0x23, 0x67, 0x05, 0xA0, 0xB0, 0x35, 0x0B, 0xB0, 0xD0, 0x74, 0x05, 0x0C,
  0xB0, 0xB5, 0x02, 0x0B, 0xA8, 0x54, 0x78, 0x42, 0x29, 0xA0, 0x40, 0x8E, 0x83, 0xE1, 0x4B, 0xEA,
  0x81, 0xD9, 0x21,
  // "Ŝ" (U+015C)
  0x30, 0x2A, 0x0E, 0x02, 0x48, 0x3C, 0xFA, 0xFB, 0x38, 0x59, 0xF5, 0x07, 0xF8, 0x73, 0x89, 0x01,
  0x8D, 0xFE, 0xC8, 0x20, 0xDE, 0x04, 0x05, 0xA8, 0x59, 0x23, 0x6A, 0x07, 0xA0, 0x35, 0x04, 0xA0,
  0xA6, 0x0B, 0xA0, 0xE0, 0x65, 0x09, 0xB0, 0xD0, 0x44, 0x03, 0x0B, 0xB0, 0x45, 0x05, 0xA0, 0xA6,
  0x87, 0xEF, 0xBA, 0x84, 0x22, 0x7A, 0x09, 0x0B, 0xE8, 0x90, 0xD1, 0x4A, 0xDE, 0xED, 0x81, 0x10,
  // "ŝ" (U+015D)
  0x20, 0x2A, 0x0E, 0x02, 0x48, 0x3C, 0xFA, 0xFB, 0x38, 0x59, 0xF5, 0x07, 0xF8, 0x74, 0x87, 0x3A,
  0xEF, 0xEC, 0x71, 0x2F, 0x01, 0x06, 0xA8, 0x56, 0x23, 0x67, 0x05, 0xA0, 0xB0, 0x35, 0x0B, 0xB0,
  0xD0, 0x74, 0x05, 0x0C, 0xB0, 0xB5, 0x02, 0x0B, 0xA8, 0x54, 0x78, 0x42, 0x29, 0xA0, 0x40, 0x8E,
  0x83, 0xE1, 0x4B, 0xEA, 0x81, 0xD9, 0x21,
  // "Ş" (U+015E)
  0x18, 0x90, 0x18, 0xDF, 0xEC, 0x82, 0x0D, 0xE0, 0x40, 0x5A, 0x85, 0x92, 0x36, 0xA0, 0x7A, 0x03,
  0x50, 0x4A, 0x0A, 0x60, 0xBA, 0x0E, 0x06, 0x50, 0x9B, 0x0D, 0x04, 0x40, 0x30, 0xBB, 0x04, 0x50,
  0x5A, 0x0A, 0x68, 0x7E, 0xFB, 0xA8, 0x42, 0x27, 0xA0, 0x90, 0xBE, 0x83, 0xD1, 0x4A, 0xDA, 0x81,
  0xD8, 0x14, 0x81, 0x8F, 0x36, 0x82, 0x5D, 0xF2, 0x48, 0x31, 0x1A, 0xF4, 0x40, 0x6A, 0x0C, 0x60,
  0x30, 0x24,
  // "ş" (U+015F)
  0x18, 0x73, 0xAE, 0xFE, 0xC7, 0x12, 0xF0, 0x10, 0x6A, 0x85, 0x62, 0x36, 0x70, 0x5A, 0x0B, 0x03,
  0x50, 0xBB, 0x0D, 0x07, 0x40, 0x50, 0xCB, 0x0B, 0x50, 0x20, 0xBA, 0x85, 0x47, 0x84, 0x22, 0x9A,
  0x04, 0x08, 0xE8, 0x3E, 0x14, 0xBE, 0xA8, 0x1E, 0x92, 0x48, 0x18, 0xF3, 0x68, 0x25, 0xDF, 0x24,
  0x83, 0x11, 0xAF, 0x44, 0x06, 0xA0, 0xC6, 0x03, 0x02, 0x40,
  // "Š" (U+0160)
  0x28, 0x5A, 0xE5, 0x08, 0xF7, 0x38, 0x3D, 0xFA, 0xFB, 0x40, 0x3A, 0x0E, 0x01, 0x74, 0x89, 0x01,
  0x8D, 0xFE, 0xC8, 0x20, 0xDE, 0x04, 0x05, 0xA8, 0x59, 0x23, 0x6A, 0x07, 0xA0, 0x35, 0x04, 0xA0,
  0xA6, 0x0B, 0xA0, 0xE0, 0x65, 0x09, 0xB0, 0xD0, 0x44, 0x03, 0x0B, 0xB0, 0x45, 0x05, 0xA0, 0xA6,
  0x87, 0xEF, 0xBA, 0x84, 0x22, 0x7A, 0x09, 0x0B, 0xE8, 0x90, 0xD1, 0x4A, 0xDE, 0xED, 0x81, 0x10,
  // "š" (U+0161)
  0x18, 0x5A, 0xE5, 0x08, 0xF7, 0x38, 0x3D, 0xFA, 0xFB, 0x40, 0x3A, 0x0E, 0x01, 0x75, 0x87, 0x3A,
  0xEF, 0xEC, 0x71, 0x2F, 0x01, 0x06, 0xA8, 0x56, 0x23, 0x67, 0x05, 0xA0, 0xB0, 0x35, 0x0B, 0xB0,
  0xD0, 0x74, 0x05, 0x0C, 0xB0, 0xB5, 0x02, 0x0B, 0xA8, 0x54, 0x78, 0x42, 0x29, 0xA0, 0x40, 0x8E,
  0x83, 0xE1, 0x4B, 0xEA, 0x81, 0xD9, 0x21,
  // "Ţ" (U+0162)
  0x07, 0xFA, 0x04, 0x07, 0xFA, 0x86, 0x40, 0x11, 0x1E, 0xFB, 0x0F, 0x15, 0x81, 0xEF, 0xA7, 0x18,
  0x1E, 0xFA, 0x71, 0x81, 0xEF, 0xA7, 0x18, 0x1E, 0xFA, 0x71, 0x81, 0xEF, 0xA7, 0x18, 0x1E, 0xFA,
  0x71, 0x81, 0xEF, 0xA7, 0x18, 0x1E, 0xFA, 0x71, 0x81, 0xEF, 0xA7, 0x1A, 0x0B, 0x71, 0x81, 0x8F,
  0x37, 0x18, 0x25, 0xDF, 0x26, 0x83, 0x11, 0xAF, 0x46, 0x06, 0xA0, 0xC7, 0x10, 0x30, 0x25,
  // "ţ" (U+0163)
  0x28, 0x11, 0x76, 0x68, 0x15, 0xFC, 0x68, 0x17, 0xFC, 0x40, 0x80, 0xCE, 0x07, 0xF9, 0x89, 0x07,
  0x22, 0xCF, 0xD2, 0x22, 0x12, 0x81, 0xCF, 0xC6, 0x81, 0xCF, 0xC6, 0x81, 0xCF, 0xC6, 0x81, 0xCF,
  0xD6, 0x0A, 0xA0, 0x70, 0xF3, 0x20, 0x5D, 0x09, 0x30, 0x50, 0xCA, 0x0D, 0x06, 0x58, 0x18, 0xF3,
  0x68, 0x25, 0xDF, 0x24, 0x83, 0x11, 0xAF, 0x44, 0x06, 0xA0, 0xC6, 0x03, 0x02, 0x20,
  // "Ť" (U+0164)
  0x28, 0x5A, 0xE5, 0x08, 0xF7, 0x58, 0x3D, 0xFA, 0xFB, 0x60, 0x3A, 0x0E, 0x01, 0x77, 0x07, 0xFA,
  0x04, 0x07, 0xFA, 0x86, 0x40, 0x11, 0x1E, 0xFB, 0x0F, 0x15, 0x81, 0xEF, 0xA7, 0x18, 0x1E, 0xFA,
  0x71, 0x81, 0xEF, 0xA7, 0x18, 0x1E, 0xFA, 0x71, 0x81, 0xEF, 0xA7, 0x18, 0x1E, 0xFA, 0x71, 0x81,
  0xEF, 0xA7, 0x18, 0x1E, 0xFA, 0x71, 0x81, 0xEF, 0xA7, 0x18, 0x1E, 0xFA, 0x40,
  // "ť" (U+0165)
  0x60, 0x2A, 0x02, 0x28, 0x51, 0x65, 0x05, 0xFA, 0x38, 0x55, 0xFC, 0x07, 0xD1, 0x38, 0x17, 0xFC,
  0x50, 0x80, 0xBE, 0x07, 0x1F, 0x98, 0x91, 0x70, 0x22, 0xCF, 0xD2, 0x22, 0x13, 0x81, 0xCF, 0xC7,
  0x81, 0xCF, 0xC7, 0x81, 0xCF, 0xC7, 0x81, 0xCF, 0xD7, 0x0A, 0xA0, 0x70, 0xF3, 0x30, 0x5D, 0x09,
  0x48, 0x45, 0xCE, 0xFD, 0x61,
  // "Ŧ" (U+0166)
  0x07, 0xFA, 0x04, 0x07, 0xFA, 0x86, 0x40, 0x11, 0x1E, 0xFB, 0x0F, 0x15, 0x81, 0xEF, 0xA7, 0x18,
  0x1E, 0xFA, 0x68, 0x51, 0x1E, 0xFB, 0x11, 0x30, 0x1E, 0x0E, 0x30, 0x1E, 0x0E, 0x68, 0x1E, 0xFA,
  0x71, 0x81, 0xEF, 0xA7, 0x18, 0x1E, 0xFA, 0x71, 0x81, 0xEF, 0xA7, 0x18, 0x1E, 0xFA, 0x40,
  // "ŧ" (U+0167)
  0x28, 0x11, 0x76, 0x68, 0x15, 0xFC, 0x68, 0x17, 0xFC, 0x40, 0x80, 0xCE, 0x07, 0xF9, 0x89, 0x07,
  0x22, 0xCF, 0xD2, 0x22, 0x12, 0x81, 0xCF, 0xC4, 0xF9, 0x09, 0xF9, 0x84, 0x91, 0x1C, 0xFD, 0x80,
  0x01, 0x20, 0xBA, 0x82, 0x52, 0x32, 0x20, 0x6D, 0x09, 0x38, 0x46, 0xCE, 0xFD, 0x60,
  // "Ũ" (U+0168)
  0x28, 0x51, 0xAA, 0x30, 0x78, 0x30, 0xAB, 0x81, 0xDF, 0x83, 0x85, 0xE7, 0x29, 0xEC, 0x17, 0x40,
  0x2A, 0x06, 0x30, 0x9A, 0x02, 0xA0, 0x63, 0x09, 0xA0, 0x2A, 0x06, 0x30, 0x9A, 0x02, 0xA0, 0x63,
  0x09, 0xA0, 0x2A, 0x06, 0x30, 0x9A, 0x02, 0xA0, 0x63, 0x09, 0xA0, 0x2A, 0x06, 0x30, 0x9A, 0x02,
  0xA0, 0x63, 0x09, 0xA0, 0x2A, 0x07, 0x30, 0xAA, 0x01, 0xA0, 0x93, 0x83, 0xDF, 0xD0, 0xCA, 0x81,
  0x74, 0x8A, 0x81, 0x90, 0x4E, 0x0E, 0x01, 0x28, 0x53, 0xBE, 0xFD, 0x91, 0x10,
  // "ũ" (U+0169)
  0x28, 0x51, 0xAA, 0x30, 0x78, 0x30, 0xAB, 0x81, 0xDF, 0x83, 0x85, 0xE7, 0x29, 0xEC, 0x17, 0x40,
  0x1A, 0x08, 0x38, 0x2C, 0xFC, 0x1A, 0x08, 0x38, 0x2C, 0xFC, 0x1A, 0x08, 0x38, 0x2C, 0xFC, 0x1A,
  0x08, 0x38, 0x2C, 0xFC, 0x1A, 0x08, 0x38, 0x2C, 0xFC, 0x1A, 0x08, 0x38, 0x2D, 0xFC, 0x1A, 0x09,
  0x20, 0x1A, 0x86, 0xC0, 0xEF, 0xE4, 0x3A, 0xA8, 0x1C, 0x08, 0xD8, 0x1D, 0xFC, 0x28, 0x68, 0xDF,
  0xC4, 0x5F, 0xC0,
  // "Ū" (U+016A)
  0x38, 0x01, 0x14, 0x04, 0xD0, 0x23, 0x04, 0xD0, 0x27, 0x40, 0x2A, 0x06, 0x30, 0x9A, 0x02, 0xA0,
  0x63, 0x09, 0xA0, 0x2A, 0x06, 0x30, 0x9A, 0x02, 0xA0, 0x63, 0x09, 0xA0, 0x2A, 0x06, 0x30, 0x9A,
  0x02, 0xA0, 0x63, 0x09, 0xA0, 0x2A, 0x06, 0x30, 0x9A, 0x02, 0xA0, 0x63, 0x09, 0xA0, 0x2A, 0x07,
  0x30, 0xAA, 0x01, 0xA0, 0x93, 0x83, 0xDF, 0xD0, 0xCA, 0x81, 0x74, 0x8A, 0x81, 0x90, 0x4E, 0x0E,
  0x01, 0x28, 0x53, 0xBE, 0xFD, 0x91, 0x10,
  // "ū" (U+016B)
  0x38, 0x01, 0x14, 0x04, 0xD0, 0x23, 0x04, 0xD0, 0x27, 0x40, 0x1A, 0x08, 0x38, 0x2C, 0xFC, 0x1A,
  0x08, 0x38, 0x2C, 0xFC, 0x1A, 0x08, 0x38, 0x2C, 0xFC, 0x1A, 0x08, 0x38, 0x2C, 0xFC, 0x1A, 0x08,
  0x38, 0x2C, 0xFC, 0x1A, 0x08, 0x38, 0x2D, 0xFC, 0x1A, 0x09, 0x20, 0x1A, 0x86, 0xC0, 0xEF, 0xE4,
  0x3A, 0xA8, 0x1C, 0x08, 0xD8, 0x1D, 0xFC, 0x28, 0x68, 0xDF, 0xC4, 0x5F, 0xC0,
  // "Ŭ" (U+016C)
  0x28, 0x57, 0xF5, 0x26, 0xF5, 0x30, 0x2C, 0x0E, 0x01, 0x48, 0x35, 0xDE, 0xC3, 0x75, 0x02, 0xA0,
  0x63, 0x09, 0xA0, 0x2A, 0x06, 0x30, 0x9A, 0x02, 0xA0, 0x63, 0x09, 0xA0, 0x2A, 0x06, 0x30, 0x9A,
  0x02, 0xA0, 0x63, 0x09, 0xA0, 0x2A, 0x06, 0x30, 0x9A, 0x02, 0xA0, 0x63, 0x09, 0xA0, 0x2A, 0x06,
  0x30, 0x9A, 0x02, 0xA0, 0x73, 0x0A, 0xA0, 0x1A, 0x09, 0x38, 0x3D, 0xFD, 0x0C, 0xA8, 0x17, 0x48,
  0xA8, 0x19, 0x04, 0xE0, 0xE0, 0x12, 0x85, 0x3B, 0xEF, 0xD9, 0x11,
  // "ŭ" (U+016D)
  0x28, 0x57, 0xF5, 0x26, 0xF5, 0x30, 0x2C, 0x0E, 0x01, 0x48, 0x35, 0xDE, 0xC3, 0x75, 0x01, 0xA0,
  0x83, 0x82, 0xCF, 0xC1, 0xA0, 0x83, 0x82, 0xCF, 0xC1, 0xA0, 0x83, 0x82, 0xCF, 0xC1, 0xA0, 0x83,
  0x82, 0xCF, 0xC1, 0xA0, 0x83, 0x82, 0xCF, 0xC1, 0xA0, 0x83, 0x82, 0xDF, 0xC1, 0xA0, 0x92, 0x01,
  0xA8, 0x6C, 0x0E, 0xFE, 0x43, 0xAA, 0x81, 0xC0, 0x8D, 0x81, 0xDF, 0xC2, 0x86, 0x8D, 0xFC, 0x45,
  0xFC,
  // "Ů" (U+016E)
  0x38, 0x22, 0xCE, 0xA6, 0x83, 0xAC, 0x4E, 0x65, 0x83, 0xAA, 0x1E, 0x75, 0x83, 0x3E, 0xFC, 0x17,
  0x01, 0x40, 0x2A, 0x06, 0x30, 0x9A, 0x02, 0xA0, 0x63, 0x09, 0xA0, 0x2A, 0x06, 0x30, 0x9A, 0x02,
  0xA0, 0x63, 0x09, 0xA0, 0x2A, 0x06, 0x30, 0x9A, 0x02, 0xA0, 0x63, 0x09, 0xA0, 0x2A, 0x06, 0x30,
  0x9A, 0x02, 0xA0, 0x63, 0x09, 0xA0, 0x2A, 0x07, 0x30, 0xAA, 0x01, 0xA0, 0x93, 0x83, 0xDF, 0xD0,
  0xCA, 0x81, 0x74, 0x8A, 0x81, 0x90, 0x4E, 0x0E, 0x01, 0x28, 0x53, 0xBE, 0xFD, 0x91, 0x10,
  // "ů" (U+016F)
  0x38, 0x22, 0xCE, 0xA6, 0x83, 0xAC, 0x4E, 0x65, 0x83, 0xAA, 0x1E, 0x75, 0x83, 0x3E, 0xFC, 0x17,
  0x01, 0x40, 0x1A, 0x08, 0x38, 0x2C, 0xFC, 0x1A, 0x08, 0x38, 0x2C, 0xFC, 0x1A, 0x08, 0x38, 0x2C,
  0xFC, 0x1A, 0x08, 0x38, 0x2C, 0xFC, 0x1A, 0x08, 0x38, 0x2C, 0xFC, 0x1A, 0x08, 0x38, 0x2D, 0xFC,
  0x1A, 0x09, 0x20, 0x1A, 0x86, 0xC0, 0xEF, 0xE4, 0x3A, 0xA8, 0x1C, 0x08, 0xD8, 0x1D, 0xFC, 0x28,
  0x68, 0xDF, 0xC4, 0x5F, 0xC0,
  // "Ű" (U+0170)
  0x38, 0x58, 0xDA, 0x5D, 0xC1, 0x28, 0x52, 0xFD, 0x2D, 0xE3, 0x38, 0x4B, 0xC1, 0x8E, 0x37, 0x50,
  0x2A, 0x06, 0x30, 0x9A, 0x02, 0xA0, 0x63, 0x09, 0xA0, 0x2A, 0x06, 0x30, 0x9A, 0x02, 0xA0, 0x63,
  0x09, 0xA0, 0x2A, 0x06, 0x30, 0x9A, 0x02, 0xA0, 0x63, 0x09, 0xA0, 0x2A, 0x06, 0x30, 0x9A, 0x02,
  0xA0, 0x63, 0x09, 0xA0, 0x2A, 0x07, 0x30, 0xAA, 0x01, 0xA0, 0x93, 0x83, 0xDF, 0xD0, 0xCA, 0x81,
  0x74, 0x8A, 0x81, 0x90, 0x4E, 0x0E, 0x01, 0x28, 0x53, 0xBE, 0xFD, 0x91, 0x10,
  // "ű" (U+0171)
  0x38, 0x58, 0xDA, 0x5D, 0xC1, 0x28, 0x52, 0xFD, 0x2D, 0xE3, 0x38, 0x4B, 0xC1, 0x8E, 0x37, 0x50,
  0x1A, 0x08, 0x38, 0x2C, 0xFC, 0x1A, 0x08, 0x38, 0x2C, 0xFC, 0x1A, 0x08, 0x38, 0x2C, 0xFC, 0x1A,
  0x08, 0x38, 0x2C, 0xFC, 0x1A, 0x08, 0x38, 0x2C, 0xFC, 0x1A, 0x08, 0x38, 0x2D, 0xFC, 0x1A, 0x09,
  0x20, 0x1A, 0x86, 0xC0, 0xEF, 0xE4, 0x3A, 0xA8, 0x1C, 0x08, 0xD8, 0x1D, 0xFC, 0x28, 0x68, 0xDF,
  0xC4, 0x5F, 0xC0,
  // "Ų" (U+0172)
  0x02, 0xA0, 0x63, 0x09, 0xA0, 0x2A, 0x06, 0x30, 0x9A, 0x02, 0xA0, 0x63, 0x09, 0xA0, 0x2A, 0x06,
  0x30, 0x9A, 0x02, 0xA0, 0x63, 0x09, 0xA0, 0x2A, 0x06, 0x30, 0x9A, 0x02, 0xA0, 0x63, 0x09, 0xA0,
  0x2A, 0x06, 0x30, 0x9A, 0x02, 0xA0, 0x73, 0x82, 0xAF, 0xE1, 0xA0, 0x93, 0x83, 0xCF, 0xC0, 0xDA,
  0x81, 0x63, 0x8A, 0x81, 0x60, 0x5E, 0x08, 0x38, 0x44, 0xBE, 0xFD, 0x36, 0x81, 0x6E, 0x17, 0x90,
  0xC0, 0x26, 0x01, 0xB0, 0x36, 0x82, 0x7E, 0xE2, 0x20,
  // "ų" (U+0173)
  0x01, 0xA0, 0x83, 0x83, 0xCF, 0xC0, 0x1A, 0x08, 0x38, 0x3C, 0xFC, 0x01, 0xA0, 0x83, 0x83, 0xCF,
  0xC0, 0x1A, 0x08, 0x38, 0x3C, 0xFC, 0x01, 0xA0, 0x83, 0x83, 0xCF, 0xC0, 0x1A, 0x08, 0x38, 0x3D,
  0xFC, 0x01, 0xA0, 0x92, 0x01, 0xA0, 0xC2, 0x84, 0xEF, 0xE4, 0x3A, 0xA0, 0xC2, 0x08, 0xD8, 0x1D,
  0xFC, 0x38, 0x48, 0xDF, 0xC4, 0x7A, 0x71, 0x00, 0xC7, 0x18, 0x22, 0xFC, 0x27, 0x01, 0xB0, 0x37,
  0x82, 0x6E, 0xE2,
  // "Ŵ" (U+0174)
  0x30, 0x2A, 0x0E, 0x02, 0x68, 0x3C, 0xFA, 0xFB, 0x58, 0x59, 0xF5, 0x07, 0xF8, 0x76, 0x81, 0xCF,
  0x75, 0x84, 0xAF, 0x9A, 0xF9, 0x58, 0x4B, 0xF8, 0x9F, 0xA5, 0x89, 0x7D, 0xF7, 0x8F, 0xB0, 0xEF,
  0xB0, 0xEF, 0x57, 0xFD, 0x1A, 0x0D, 0x1A, 0x83, 0x46, 0xFE, 0x3B, 0x01, 0xA8, 0x73, 0x5F, 0xE5,
  0xFB, 0xF3, 0xA8, 0x72, 0x4F, 0xE7, 0xF7, 0xF6, 0xA0, 0x10, 0x3A, 0x83, 0x9F, 0x3F, 0x9A, 0x10,
  0x1A, 0x85, 0xCD, 0x0F, 0xBF, 0xE2, 0x98, 0x6E, 0xEA, 0x0D, 0xDF, 0xD2, 0xB8, 0x18, 0x0B, 0xA0,
  0xC2, 0x0D, 0xA8, 0x16, 0x09, 0xA0, 0xB1,
  // "ŵ" (U+0175)
  0x30, 0x2A, 0x0E, 0x02, 0x68, 0x3C, 0xFA, 0xFB, 0x58, 0x59, 0xF5, 0x07, 0xF8, 0x76, 0x81, 0xDF,
  0x75, 0x84, 0x9F, 0xAB, 0xF8, 0x58, 0x97, 0xAF, 0x89, 0xF9, 0x0C, 0xF9, 0x0C, 0xF6, 0x7F, 0xB1,
  0xA8, 0xA6, 0xD0, 0xDF, 0x45, 0xFC, 0x3F, 0xEF, 0x0E, 0xF2, 0x3F, 0xD6, 0xFA, 0xF4, 0xA2, 0xA8,
  0x59, 0xF4, 0xF8, 0xFD, 0x28, 0x7E, 0xFD, 0xD1, 0xFC, 0xFB, 0x20, 0xCA, 0x81, 0xA0, 0xDA, 0x09,
  0x20, 0x9A, 0x81, 0x70, 0xAA, 0x06, 0x10,
  // "Ŷ" (U+0176)
  0x30, 0x2A, 0x0E, 0x02, 0x68, 0x3C, 0xFA, 0xFB, 0x58, 0x59, 0xF5, 0x07, 0xF8, 0x76, 0x06, 0xA0,
  0x43, 0x07, 0xA8, 0x33, 0x0E, 0xFB, 0x38, 0x1D, 0xFB, 0x20, 0x7A, 0x81, 0x20, 0x4A, 0x04, 0x38,
  0x5E, 0xF8, 0x0B, 0xFC, 0x48, 0x28, 0xFE, 0x2A, 0x05, 0x40, 0x1A, 0x81, 0xDF, 0xD6, 0x09, 0xB0,
  0x66, 0x02, 0xA0, 0xE7, 0x18, 0x1D, 0xFB, 0x71, 0x81, 0xDF, 0xB7, 0x18, 0x1D, 0xFB, 0x71, 0x81,
  0xDF, 0xB7, 0x18, 0x1D, 0xFB, 0x40,
  // "ŷ" (U+0177)
  0x30, 0x2A, 0x0E, 0x02, 0x68, 0x3C, 0xFA, 0xFB, 0x58, 0x59, 0xF5, 0x07, 0xF8, 0x76, 0x06, 0xA0,
  0x53, 0x08, 0xA0, 0x30, 0x1A, 0x0B, 0x38, 0x1C, 0xFD, 0x20, 0x9A, 0x81, 0x10, 0x1A, 0x07, 0x20,
  0x3A, 0x81, 0x50, 0x6A, 0x02, 0x38, 0x5C, 0xFB, 0x0B, 0xFB, 0x40, 0x6A, 0x01, 0xA0, 0x65, 0x81,
  0xEF, 0x9A, 0x01, 0x50, 0x9B, 0x0A, 0x60, 0x3B, 0x04, 0x78, 0x1D, 0xFE, 0x70, 0x2A, 0x08, 0x58,
  0x14, 0x5D, 0xA0, 0x15, 0x0E, 0xB0, 0x66, 0x82, 0xDF, 0xC5, 0x60,
  // "Ÿ" (U+0178)
  0x28, 0x5B, 0xF7, 0x08, 0xFA, 0x48, 0x5A, 0xE5, 0x07, 0xF8, 0x76, 0x06, 0xA0, 0x43, 0x07, 0xA8,
  0x33, 0x0E, 0xFB, 0x38, 0x1D, 0xFB, 0x20, 0x7A, 0x81, 0x20, 0x4A, 0x04, 0x38, 0x5E, 0xF8, 0x0B,
  0xFC, 0x48, 0x28, 0xFE, 0x2A, 0x05, 0x40, 0x1A, 0x81, 0xDF, 0xD6, 0x09, 0xB0, 0x66, 0x02, 0xA0,
  0xE7, 0x18, 0x1D, 0xFB, 0x71, 0x81, 0xDF, 0xB7, 0x18, 0x1D, 0xFB, 0x71, 0x81, 0xDF, 0xB7, 0x18,
  0x1D, 0xFB, 0x40,
  // "Ź" (U+0179)
  0x50, 0x7A, 0x05, 0x40, 0x2A, 0x06, 0x58, 0x1C, 0xF5, 0x74, 0x01, 0xF0, 0x70, 0x1F, 0x89, 0x07,
  0x01, 0x11, 0x1A, 0xFE, 0x14, 0x03, 0xA0, 0x75, 0x81, 0xBF, 0xD5, 0x04, 0xA0, 0x55, 0x81, 0xDF,
  0xC5, 0x06, 0xA0, 0x35, 0x81, 0xEF, 0xA5, 0x82, 0x8F, 0xE1, 0x40, 0x1A, 0x85, 0x91, 0x11, 0x10,
  0x8F, 0x00, 0x8F, 0x08,
  // "ź" (U+017A)
  0x50, 0x7A, 0x05, 0x40, 0x2A, 0x06, 0x58, 0x1C, 0xF5, 0x74, 0x08, 0xF0, 0x70, 0x8F, 0x84, 0x70,
  0x11, 0x14, 0xA0, 0xD4, 0x83, 0x1D, 0xFE, 0x24, 0x0B, 0xA0, 0x44, 0x08, 0xA0, 0x74, 0x05, 0xA0,
  0x94, 0x89, 0x02, 0xEF, 0xD2, 0x11, 0x11, 0xBF, 0x09, 0x0C, 0xF0, 0x90,
  // "Ż" (U+017B)
  0x48, 0x1B, 0xE9, 0x50, 0x2A, 0x0E, 0x68, 0x1B, 0xF8, 0x74, 0x01, 0xF0, 0x70, 0x1F, 0x89, 0x07,
  0x01, 0x11, 0x1A, 0xFE, 0x14, 0x03, 0xA0, 0x75, 0x81, 0xBF, 0xD5, 0x04, 0xA0, 0x55, 0x81, 0xDF,
  0xC5, 0x06, 0xA0, 0x35, 0x81, 0xEF, 0xA5, 0x82, 0x8F, 0xE1, 0x40, 0x1A, 0x85, 0x91, 0x11, 0x10,
  0x8F, 0x00, 0x8F, 0x08,
  // "ż" (U+017C)
  0x48, 0x1B, 0xE9, 0x50, 0x2A, 0x0E, 0x68, 0x1B, 0xF8, 0x74, 0x08, 0xF0, 0x70, 0x8F, 0x84, 0x70,
  0x11, 0x14, 0xA0, 0xD4, 0x83, 0x1D, 0xFE, 0x24, 0x0B, 0xA0, 0x44, 0x08, 0xA0, 0x74, 0x05, 0xA0,
  0x94, 0x89, 0x02, 0xEF, 0xD2, 0x11, 0x11, 0xBF, 0x09, 0x0C, 0xF0, 0x90,
  // "Ž" (U+017D)
  0x28, 0x5A, 0xE5, 0x08, 0xF7, 0x38, 0x3D, 0xFA, 0xFB, 0x40, 0x3A, 0x0E, 0x01, 0x73, 0x01, 0xF0,
  0x70, 0x1F, 0x89, 0x07, 0x01, 0x11, 0x1A, 0xFE, 0x14, 0x03, 0xA0, 0x75, 0x81, 0xBF, 0xD5, 0x04,
  0xA0, 0x55, 0x81, 0xDF, 0xC5, 0x06, 0xA0, 0x35, 0x81, 0xEF, 0xA5, 0x82, 0x8F, 0xE1, 0x40, 0x1A,
  0x85, 0x91, 0x11, 0x10, 0x8F, 0x00, 0x8F, 0x08,
  // "ž" (U+017E)
  0x28, 0x5A, 0xE5, 0x08, 0xF7, 0x38, 0x3D, 0xFA, 0xFB, 0x40, 0x3A, 0x0E, 0x01, 0x73, 0x08, 0xF0,
  0x70, 0x8F, 0x84, 0x70, 0x11, 0x14, 0xA0, 0xD4, 0x83, 0x1D, 0xFE, 0x24, 0x0B, 0xA0, 0x44, 0x08,
  0xA0, 0x74, 0x05, 0xA0, 0x94, 0x89, 0x02, 0xEF, 0xD2, 0x11, 0x11, 0xBF, 0x09, 0x0C, 0xF0, 0x90,
  // "ſ" (U+017F)
  0x18, 0x64, 0xCE, 0xEC, 0x31, 0xEC, 0x01, 0x05, 0xA8, 0x37, 0x24, 0x06, 0xA0, 0x23, 0x06, 0xA0,
  0x23, 0x06, 0xA0, 0x23, 0x06, 0xA0, 0x23, 0x06, 0xA0, 0x23, 0x06, 0xA0, 0x23, 0x06, 0xA0, 0x23,
  0x06, 0xA0, 0x23, 0x06, 0xA0, 0x23, 0x06, 0xA0, 0x23, 0x06, 0xA0, 0x23,
  // "Ω" (U+03A9)
  0x28, 0x42, 0xAE, 0xFD, 0x84, 0x02, 0x0E, 0xD0, 0xC3, 0x0B, 0xA8, 0x16, 0x27, 0xA0, 0x72, 0xA0,
  0x83, 0x83, 0xBF, 0xC0, 0x3A, 0x04, 0x30, 0x7A, 0x10, 0x4A, 0x02, 0x30, 0x5A, 0x10, 0x3A, 0x03,
  0x30, 0x5A, 0x10, 0x1A, 0x04, 0x38, 0x17, 0xFD, 0x28, 0x1C, 0xF6, 0x38, 0x1A, 0xF8, 0x28, 0x15,
  0xFC, 0x28, 0x97, 0x1E, 0xF2, 0x01, 0x1B, 0xF6, 0x0A, 0xF7, 0x10, 0xBB, 0x81, 0xA0, 0xEB, 0x08,
  0x0B, 0xB8, 0x1A, 0x0E, 0xB0, 0x80,
  // "μ" (U+03BC)
  0x01, 0xA0, 0x83, 0x82, 0xCF, 0xC1, 0xA0, 0x83, 0x82, 0xCF, 0xC1, 0xA0, 0x83, 0x82, 0xCF, 0xC1,
  0xA0, 0x83, 0x82, 0xCF, 0xC1, 0xA0, 0x83, 0x82, 0xCF, 0xC1, 0xA0, 0x83, 0x82, 0xDF, 0xC1, 0xA0,
  0x93, 0xA0, 0xC0, 0x1A, 0x82, 0xE3, 0x2A, 0xA0, 0xC0, 0x1E, 0x82, 0xDF, 0xC1, 0xC8, 0x4C, 0x55,
  0xFC, 0x1A, 0x08, 0x60, 0x1A, 0x08, 0x60, 0x1A, 0x08, 0x60, 0x1A, 0x08, 0x60,
  // "π" (U+03C0)
  0x04, 0x0D, 0xF9, 0x0A, 0x0D, 0xFA, 0x81, 0xA1, 0x2A, 0x87, 0x71, 0xCF, 0xB1, 0x10, 0x1A, 0x83,
  0x60, 0xBF, 0xA3, 0x01, 0xA8, 0x36, 0x0B, 0xFA, 0x30, 0x1A, 0x83, 0x60, 0xBF, 0xA3, 0x01, 0xA8,
  0x36, 0x0B, 0xFA, 0x30, 0x1A, 0x87, 0x60, 0xBF, 0xD2, 0x20, 0x1A, 0x81, 0x60, 0x8B, 0x81, 0x90,
  0x1A, 0x85, 0x60, 0x1A, 0xED, 0x60,
  // "–" (U+2013)
  0x18, 0x03, 0x10, 0x3F, 0x03, 0xF0,
  // "—" (U+2014)
  0x80, 0x71, 0xFB, 0x0C, 0xFB, 0x0C,
  // "€" (U+20AC)
  0x48, 0x56, 0xBE, 0xED, 0x81, 0x30, 0xBD, 0x0E, 0x30, 0x8A, 0x83, 0x93, 0x24, 0x53, 0x81, 0xEF,
  0xA6, 0x04, 0xF0, 0x12, 0x04, 0xF0, 0x13, 0x06, 0xA0, 0x70, 0xF3, 0x30, 0x4F, 0x01, 0x20, 0x4F,
  0x01, 0x48, 0x1D, 0xFB, 0x71, 0x07, 0xA8, 0x39, 0x32, 0x35, 0x40, 0xAD, 0x0C, 0x58, 0x46, 0xCE,
  0xFD, 0x81,
  // "₿" (U+20BF)
  0x28, 0x25, 0x31, 0x75, 0x83, 0xB7, 0x2F, 0x12, 0x08, 0xD8, 0x2B, 0x40, 0x8F, 0x85, 0x58, 0xFD,
  0x12, 0x5A, 0x82, 0xB8, 0xFD, 0x38, 0x4D, 0xFB, 0x8F, 0xD2, 0x03, 0xA0, 0x08, 0xE8, 0x1A, 0x08,
  0xE8, 0x6B, 0x18, 0xFD, 0x11, 0x5A, 0x82, 0xB8, 0xFD, 0x30, 0xAA, 0x81, 0x8F, 0xD3, 0x0B, 0xA8,
  0x48, 0xFD, 0x11, 0x5A, 0x0C, 0x08, 0xF0, 0x50, 0x8D, 0x0B, 0x04, 0x38, 0x3B, 0x72, 0xF1, 0x48,
  0x25, 0x31, 0x73,
  // "‘" (U+2018)
  0x28, 0x91, 0xEE, 0x06, 0xFB, 0x0D, 0xF7, 0x2A, 0x04,
  // "’" (U+2019)
  0x10, 0x6A, 0x83, 0x10, 0x9F, 0xC2, 0x85, 0xDF, 0x50, 0x1F, 0xE2,
  // "‚" (U+201A)
  0x18, 0x59, 0xFE, 0x0C, 0xFA, 0x1A, 0x05, 0x02, 0xA8, 0x21, 0x6F, 0x91,
  // "‛" (U+201B)
  0x02, 0xA8, 0x74, 0x0D, 0xF7, 0x06, 0xFB, 0x20, 0x0E,
  // "“" (U+201C)
  0x20, 0x0E, 0x28, 0xA1, 0xEE, 0x06, 0xFB, 0x06, 0xFB, 0x0D, 0xF7, 0x0D, 0xF7, 0x2A, 0x04, 0x02,
  0xA0, 0x40,
  // "”" (U+201D)
  0x04, 0xA0, 0x20, 0x4A, 0x8A, 0x12, 0x8F, 0xD0, 0x8F, 0xD0, 0xBF, 0x60, 0xBF, 0x60, 0xEE, 0x20,
  0x0E, 0x20,
  // "„" (U+201E)
  0x18, 0x93, 0x9F, 0xE9, 0xFE, 0x0C, 0xFA, 0xCF, 0xA1, 0xA0, 0x5A, 0x05, 0x02, 0xA0, 0x3A, 0x85,
  0x16, 0xF9, 0x6F, 0x91,
  // "‟" (U+201F)
  0x02, 0xA0, 0x40, 0x2A, 0x89, 0x74, 0x0D, 0xF7, 0x0D, 0xF7, 0x06, 0xFB, 0x06, 0xFB, 0x20, 0x0E,
  0x20, 0x0E,
  // "†" (U+2020)
  0x38, 0x1C, 0xF6, 0x58, 0x1A, 0xF4, 0x58, 0x18, 0xF2, 0x28, 0x71, 0x54, 0x8F, 0x44, 0x52, 0xE8,
  0x7E, 0x19, 0x7A, 0xF7, 0x89, 0x38, 0x17, 0xF1, 0x58, 0x18, 0xF2, 0x58, 0x19, 0xF2, 0x58, 0x19,
  0xF3, 0x58, 0x1A, 0xF4, 0x58, 0x1B, 0xF5, 0x58, 0x1C, 0xF6, 0x58, 0x1D, 0xF7, 0x20,
  // "‡" (U+2021)
  0x38, 0x1B, 0xF8, 0x58, 0x19, 0xF5, 0x58, 0x17, 0xF3, 0x28, 0x73, 0xB9, 0xBF, 0x9A, 0xB3, 0xF8,
  0x61, 0x32, 0x7F, 0x42, 0x33, 0x81, 0x9F, 0x65, 0x81, 0x9F, 0x63, 0x86, 0x10, 0x6F, 0x30, 0x23,
  0xF8, 0x63, 0xDB, 0xCF, 0xBB, 0xD3, 0x81, 0x6F, 0x35, 0x81, 0x9F, 0x55, 0x81, 0xBF, 0x82,
  // "•" (U+2022)
  0x84, 0x3C, 0xEB, 0x1D, 0xB0, 0xAC, 0x0C, 0x0D, 0xB8, 0x4A, 0x3C, 0xEB, 0x10,
  // "…" (U+2026)
  0x18, 0x92, 0xBE, 0x90, 0xBE, 0x90, 0xBE, 0x93, 0xB0, 0x3B, 0x03, 0xB1, 0x89, 0x1B, 0xE8, 0x0B,
  0xE8, 0x0B, 0xE8,
  // "‰" (U+2030)
  0x82, 0x1C, 0xE7, 0x78, 0x37, 0xE7, 0xF1, 0x68, 0x39, 0xC3, 0xF3, 0x68, 0x78, 0xD5, 0xF2, 0x2D,
  0xD2, 0x28, 0x62, 0xEF, 0xA4, 0xEC, 0x15, 0x82, 0x16, 0xFA, 0x78, 0x18, 0xF7, 0x78, 0x1A, 0xF5,
  0x78, 0x90, 0x14, 0x3C, 0xE7, 0x0A, 0xE9, 0x38, 0x78, 0xE7, 0xF6, 0xF6, 0xF4, 0x28, 0x79, 0xC3,
  0xFA, 0xF0, 0xF6, 0x28, 0x77, 0xE7, 0xF6, 0xF6, 0xF4, 0x28, 0x61, 0xCE, 0x70, 0xAE, 0xA1,
  // "‹" (U+2039)
  0x28, 0xA3, 0x4B, 0x30, 0x2E, 0xF8, 0x1D, 0xFB, 0x0B, 0xFD, 0x10, 0xDF, 0xC2, 0x82, 0x2E, 0xF9,
  0x20, 0x4A, 0x06, 0x28, 0x16, 0xD5,
  // "›" (U+203A)
  0x81, 0x5D, 0x62, 0x06, 0xA0, 0x42, 0x82, 0x9F, 0xE2, 0x28, 0xA3, 0xCF, 0xD0, 0x1D, 0xFB, 0x0B,
  0xFD, 0x18, 0xFE, 0x20, 0x3B, 0x42,
  // "⁄" (U+2044)
  0x58, 0x18, 0xF6, 0x50, 0x0E, 0x58, 0x15, 0xF9, 0x58, 0x1B, 0xF2, 0x48, 0x12, 0xFC, 0x58, 0x18,
  0xF5, 0x50, 0x0E, 0x58, 0x15, 0xF8, 0x58, 0x1C, 0xF2, 0x48, 0x12, 0xFB, 0x58, 0x19, 0xF5, 0x50,
  0x0E, 0x58, 0x16, 0xF8, 0x50,
  // "™" (U+2122)
  0xC8, 0xF0, 0x8F, 0xE0, 0x3F, 0xC3, 0x7E, 0x32, 0xFE, 0x49, 0xEC, 0x05, 0xE0, 0x1F, 0x99, 0xE9,
  0xC0, 0x5E, 0x01, 0xF5, 0xFB, 0x8C, 0x05, 0xE0, 0x1F, 0x29, 0x48, 0xC0, 0x5E, 0x01, 0xF2, 0x28,
  0x38, 0xC0, 0x12, 0x20, 0x23, 0x01, 0x02,
  // "⅒" (U+2152)
  0x28, 0x17, 0xF9, 0x58, 0x18, 0xF6, 0x75, 0x01, 0x0C, 0xA0, 0x95, 0x00, 0xE7, 0x68, 0x31, 0xD7,
  0xF9, 0x48, 0x15, 0xF9, 0x77, 0x18, 0x11, 0xF9, 0x48, 0x1B, 0xF2, 0x77, 0x18, 0x11, 0xF9, 0x38,
  0x12, 0xFC, 0x77, 0x28, 0x11, 0xF9, 0x38, 0x18, 0xF5, 0x28, 0x17, 0xF9, 0x38, 0x36, 0xDF, 0xC3,
  0x28, 0x92, 0x36, 0xFB, 0x41, 0x0E, 0xE0, 0x1C, 0xA0, 0x92, 0x84, 0x3F, 0xD9, 0xEE, 0x20, 0xEC,
  0x89, 0x05, 0x5F, 0x80, 0x1D, 0x7F, 0x92, 0x85, 0x8F, 0x30, 0x5F, 0x57, 0x81, 0xCF, 0x23, 0x81,
  0x1F, 0x92, 0x0A, 0x92, 0x81, 0x2F, 0x76, 0x81, 0x2F, 0xB4, 0x81, 0x1F, 0x92, 0x0A, 0x92, 0x81,
  0x2F, 0x76, 0x81, 0x9F, 0x54, 0x81, 0x1F, 0x92, 0x85, 0x8F, 0x30, 0x6F, 0x56, 0x00, 0xE4, 0x89,
  0x23, 0x6F, 0xB4, 0x12, 0xFD, 0x9E, 0xE6, 0x81, 0x6F, 0x84, 0x0E, 0xC8, 0x55, 0x05, 0xDF, 0xC3,
  0x10,
  // "∂" (U+2202)
  0x20, 0x70, 0xDA, 0x0B, 0x02, 0x3D, 0x0E, 0x01, 0x28, 0x2B, 0x30, 0x6A, 0x07, 0x68, 0x1C, 0xFA,
  0x28, 0x77, 0xDE, 0xBB, 0xFC, 0x0A, 0xE0, 0xC0, 0x5A, 0x81, 0x90, 0x2A, 0x82, 0xAB, 0xFD, 0x3A,
  0x82, 0x8E, 0xF9, 0x20, 0x4A, 0x03, 0xA0, 0x72, 0x87, 0xBF, 0xD0, 0xEF, 0xA1, 0x8A, 0x81, 0x50,
  0x8D, 0x09, 0x38, 0x38, 0xEF, 0xC6, 0x30,
  // "∆" (U+2206)
  0x30, 0x3B, 0x70, 0x8B, 0x05, 0x68, 0x3D, 0xFD, 0xFA, 0x50, 0x3A, 0x06, 0xA5, 0x85, 0x8F, 0xC0,
  0xEF, 0x54, 0x85, 0xDF, 0x70, 0xAF, 0xA3, 0x02, 0xA8, 0x32, 0x05, 0xFE, 0x38, 0x17, 0xFD, 0x20,
  0x1A, 0x04, 0x28, 0x1D, 0xF8, 0x38, 0x3B, 0xFA, 0x02, 0xA0, 0x43, 0x83, 0x7F, 0xE0, 0x7A, 0x83,
  0x32, 0x22, 0x4A, 0x04, 0x0C, 0xFA, 0x09, 0x0C, 0xFA, 0x09,
  // "√" (U+221A)
  0x71, 0x81, 0x17, 0x67, 0x18, 0x16, 0xFA, 0x71, 0x81, 0xBF, 0x57, 0x10, 0xE9, 0x71, 0x81, 0x4F,
  0xB7, 0x18, 0x19, 0xF6, 0x71, 0x81, 0xDF, 0x12, 0x00, 0x13, 0x81, 0x3F, 0xC2, 0x06, 0xA0, 0x92,
  0x81, 0x7F, 0x72, 0x06, 0xA0, 0xE2, 0x81, 0xCF, 0x24, 0x84, 0xAF, 0x51, 0xFD, 0x58, 0x44, 0xFB,
  0x6F, 0x86, 0x83, 0xDF, 0xCF, 0x36, 0x07, 0xA0, 0xE7, 0x01, 0xA0, 0x97, 0x18, 0x1B, 0xF4, 0x40,
  // "∞" (U+221E)
  0x18, 0xF6, 0x9E, 0xD4, 0x06, 0xED, 0x60, 0x7F, 0xDE, 0xF9, 0xFD, 0xEF, 0x3B, 0xF1, 0x1D, 0xFB,
  0x04, 0xF7, 0xBF, 0x10, 0xDF, 0xB0, 0x4F, 0x86, 0xFD, 0xDF, 0xBF, 0xDE, 0xF3, 0x08, 0xED, 0x40,
  0x9E, 0xD6, 0x10,
  // "≈" (U+2248)
  0x89, 0x06, 0xDF, 0xD8, 0x30, 0x38, 0xEF, 0x84, 0xBB, 0x32, 0x5B, 0xA0, 0xE0, 0x52, 0x01, 0x30,
  0x12, 0x08, 0xA8, 0x5E, 0x94, 0x25, 0x9E, 0xF8, 0x90, 0xB9, 0x10, 0x49, 0xDF, 0xD4,
  // "≠" (U+2260)
  0x50, 0x27, 0x18, 0x1E, 0xE2, 0x58, 0x14, 0xFD, 0x20, 0xBF, 0x08, 0x0B, 0xF8, 0xA2, 0x81, 0x22,
  0x8F, 0xB2, 0x21, 0x12, 0x2C, 0xF7, 0x22, 0x1B, 0xF0, 0x80, 0xBF, 0x08, 0x28, 0x1E, 0xF4, 0x58,
  0x11, 0xBD, 0x50,
  // "≤" (U+2264)
  0x71, 0x07, 0x68, 0x17, 0xEE, 0x48, 0x37, 0xEF, 0xE7, 0x28, 0x37, 0xEF, 0xD7, 0x28, 0x36, 0xEF,
  0xD6, 0x40, 0xBA, 0x09, 0x02, 0x50, 0x60, 0xDA, 0x0B, 0x05, 0x50, 0x40, 0xBA, 0x0E, 0x07, 0x58,
  0x22, 0x9F, 0xE7, 0x81, 0x17, 0x98, 0x03, 0xD0, 0xC0, 0xBF, 0x0E,
  // "≥" (U+2265)
  0x07, 0x71, 0x81, 0xEE, 0x76, 0x83, 0x7E, 0xFE, 0x76, 0x83, 0x7D, 0xFE, 0x76, 0x83, 0x6D, 0xFE,
  0x64, 0x02, 0x09, 0xA0, 0xB2, 0x05, 0x0B, 0xA8, 0x3D, 0x60, 0x7E, 0xA0, 0xB0, 0x43, 0x82, 0xEF,
  0x92, 0x50, 0x70, 0x17, 0x0C, 0x80, 0x3D, 0x09, 0x0E, 0xF0, 0xB0,
};

const Font& font_NotoSansMono_Bold_18() {
  static SmoothFont font(font_NotoSansMono_Bold_18_data);
  return font;
}

}  // namespace roo_display
