#include "10.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSansMono-Bold (Noto Sans Mono Bold)
// Generated on Sun Mar 06 15:50:06 CET 2022
static const uint8_t font_NotoSansMono_Bold_10_data[] PROGMEM = {
  
  // Header
  0x01, 0x01, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x5D, 0x00, 0x00,
  0xFE, 0xFE, 0x0F, 0x0B, 0x08, 0xFD, 0x03, 0x00, 0x12, 0x04, 0x06, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x02, 0x01, 0x03, 0x08, 0x06, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x01, 0x06, 0x04, 0x08, 0x06, 0x00, 0x09, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x05, 0x08, 0x06, 0x00, 0x10, // "#" (U+0023)
  0x00, 0x24, 0x00, 0x00, 0x05, 0x08, 0x06, 0x00, 0x29, // "$" (U+0024)
  0x00, 0x25, 0x00, 0x01, 0x05, 0x08, 0x06, 0x00, 0x44, // "%" (U+0025)
  0x00, 0x26, 0x00, 0x01, 0x05, 0x08, 0x06, 0x00, 0x5E, // "&" (U+0026)
  0x00, 0x27, 0x02, 0x06, 0x03, 0x08, 0x06, 0x00, 0x79, // "'" (U+0027)
  0x00, 0x28, 0x01, 0x00, 0x04, 0x08, 0x06, 0x00, 0x7D, // "(" (U+0028)
  0x00, 0x29, 0x01, 0xFE, 0x04, 0x06, 0x06, 0x00, 0x93, // ")" (U+0029)
  0x00, 0x2A, 0x00, 0x04, 0x05, 0x08, 0x06, 0x00, 0xA9, // "*" (U+002A)
  0x00, 0x2B, 0x00, 0x02, 0x05, 0x06, 0x06, 0x00, 0xB9, // "+" (U+002B)
  0x00, 0x2C, 0x02, 0xFF, 0x03, 0x01, 0x06, 0x00, 0xC6, // "," (U+002C)
  0x00, 0x2D, 0x01, 0x02, 0x04, 0x03, 0x06, 0x00, 0xCA, // "-" (U+002D)
  0x00, 0x2E, 0x02, 0x01, 0x03, 0x02, 0x06, 0x00, 0xCF, // "." (U+002E)
  0x00, 0x2F, 0x01, 0x01, 0x04, 0x08, 0x06, 0x00, 0xD2, // "/" (U+002F)
  0x00, 0x30, 0x00, 0x01, 0x05, 0x08, 0x06, 0x00, 0xE4, // "0" (U+0030)
  0x00, 0x31, 0x00, 0x01, 0x05, 0x08, 0x06, 0x00, 0xFE, // "1" (U+0031)
  0x00, 0x32, 0x00, 0x01, 0x05, 0x08, 0x06, 0x01, 0x15, // "2" (U+0032)
  0x00, 0x33, 0x00, 0x01, 0x05, 0x08, 0x06, 0x01, 0x2F, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x01, 0x05, 0x08, 0x06, 0x01, 0x49, // "4" (U+0034)
  0x00, 0x35, 0x00, 0x01, 0x05, 0x08, 0x06, 0x01, 0x62, // "5" (U+0035)
  0x00, 0x36, 0x00, 0x01, 0x05, 0x08, 0x06, 0x01, 0x7C, // "6" (U+0036)
  0x00, 0x37, 0x00, 0x01, 0x05, 0x08, 0x06, 0x01, 0x96, // "7" (U+0037)
  0x00, 0x38, 0x00, 0x01, 0x05, 0x08, 0x06, 0x01, 0xAD, // "8" (U+0038)
  0x00, 0x39, 0x00, 0x01, 0x05, 0x08, 0x06, 0x01, 0xC8, // "9" (U+0039)
  0x00, 0x3A, 0x02, 0x01, 0x03, 0x06, 0x06, 0x01, 0xE3, // ":" (U+003A)
  0x00, 0x3B, 0x02, 0xFF, 0x03, 0x06, 0x06, 0x01, 0xEA, // ";" (U+003B)
  0x00, 0x3C, 0x00, 0x02, 0x05, 0x06, 0x06, 0x01, 0xF2, // "<" (U+003C)
  0x00, 0x3D, 0x00, 0x02, 0x05, 0x05, 0x06, 0x02, 0x01, // "=" (U+003D)
  0x00, 0x3E, 0x00, 0x02, 0x05, 0x06, 0x06, 0x02, 0x0D, // ">" (U+003E)
  0x00, 0x3F, 0x01, 0x01, 0x05, 0x08, 0x06, 0x02, 0x1C, // "?" (U+003F)
  0x00, 0x40, 0x00, 0xFF, 0x05, 0x08, 0x06, 0x02, 0x32, // "@" (U+0040)
  0x00, 0x41, 0x00, 0x01, 0x05, 0x08, 0x06, 0x02, 0x51, // "A" (U+0041)
  0x00, 0x42, 0x00, 0x01, 0x05, 0x08, 0x06, 0x02, 0x6B, // "B" (U+0042)
  0x00, 0x43, 0x00, 0x01, 0x05, 0x08, 0x06, 0x02, 0x86, // "C" (U+0043)
  0x00, 0x44, 0x00, 0x01, 0x05, 0x08, 0x06, 0x02, 0x9E, // "D" (U+0044)
  0x00, 0x45, 0x00, 0x01, 0x05, 0x08, 0x06, 0x02, 0xBA, // "E" (U+0045)
  0x00, 0x46, 0x00, 0x01, 0x05, 0x08, 0x06, 0x02, 0xD1, // "F" (U+0046)
  0x00, 0x47, 0x00, 0x01, 0x05, 0x08, 0x06, 0x02, 0xE8, // "G" (U+0047)
  0x00, 0x48, 0x00, 0x01, 0x05, 0x08, 0x06, 0x03, 0x01, // "H" (U+0048)
  0x00, 0x49, 0x00, 0x01, 0x05, 0x08, 0x06, 0x03, 0x1D, // "I" (U+0049)
  0x00, 0x4A, 0x00, 0x01, 0x04, 0x08, 0x06, 0x03, 0x31, // "J" (U+004A)
  0x00, 0x4B, 0x00, 0x01, 0x05, 0x08, 0x06, 0x03, 0x46, // "K" (U+004B)
  0x00, 0x4C, 0x00, 0x01, 0x05, 0x08, 0x06, 0x03, 0x61, // "L" (U+004C)
  0x00, 0x4D, 0x00, 0x01, 0x05, 0x08, 0x06, 0x03, 0x79, // "M" (U+004D)
  0x00, 0x4E, 0x00, 0x01, 0x05, 0x08, 0x06, 0x03, 0x94, // "N" (U+004E)
  0x00, 0x4F, 0x00, 0x01, 0x05, 0x08, 0x06, 0x03, 0xAE, // "O" (U+004F)
  0x00, 0x50, 0x00, 0x01, 0x05, 0x08, 0x06, 0x03, 0xCA, // "P" (U+0050)
  0x00, 0x51, 0x00, 0xFF, 0x05, 0x08, 0x06, 0x03, 0xE3, // "Q" (U+0051)
  0x00, 0x52, 0x00, 0x01, 0x05, 0x08, 0x06, 0x04, 0x04, // "R" (U+0052)
  0x00, 0x53, 0x00, 0x01, 0x05, 0x08, 0x06, 0x04, 0x1E, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x05, 0x08, 0x06, 0x04, 0x38, // "T" (U+0054)
  0x00, 0x55, 0x00, 0x01, 0x05, 0x08, 0x06, 0x04, 0x4B, // "U" (U+0055)
  0x00, 0x56, 0x00, 0x01, 0x05, 0x08, 0x06, 0x04, 0x68, // "V" (U+0056)
  0x00, 0x57, 0x00, 0x01, 0x05, 0x08, 0x06, 0x04, 0x83, // "W" (U+0057)
  0x00, 0x58, 0x00, 0x01, 0x05, 0x08, 0x06, 0x04, 0x9E, // "X" (U+0058)
  0x00, 0x59, 0x00, 0x01, 0x05, 0x08, 0x06, 0x04, 0xB8, // "Y" (U+0059)
  0x00, 0x5A, 0x00, 0x01, 0x05, 0x08, 0x06, 0x04, 0xCF, // "Z" (U+005A)
  0x00, 0x5B, 0x02, 0xFF, 0x04, 0x08, 0x06, 0x04, 0xE7, // "[" (U+005B)
  0x00, 0x5C, 0x01, 0x01, 0x04, 0x08, 0x06, 0x04, 0xF8, // "\" (U+005C)
  0x00, 0x5D, 0x01, 0xFF, 0x03, 0x08, 0x06, 0x05, 0x0D, // "]" (U+005D)
  0x00, 0x5E, 0x00, 0x04, 0x05, 0x08, 0x06, 0x05, 0x1E, // "^" (U+005E)
  0x00, 0x5F, 0x00, 0xFE, 0x05, 0xFF, 0x06, 0x05, 0x2F, // "_" (U+005F)
  0x00, 0x60, 0x01, 0x08, 0x03, 0x09, 0x06, 0x05, 0x32, // "`" (U+0060)
  0x00, 0x61, 0x00, 0x01, 0x05, 0x06, 0x06, 0x05, 0x36, // "a" (U+0061)
  0x00, 0x62, 0x00, 0x01, 0x05, 0x08, 0x06, 0x05, 0x4A, // "b" (U+0062)
  0x00, 0x63, 0x00, 0x01, 0x05, 0x06, 0x06, 0x05, 0x63, // "c" (U+0063)
  0x00, 0x64, 0x00, 0x01, 0x05, 0x08, 0x06, 0x05, 0x77, // "d" (U+0064)
  0x00, 0x65, 0x00, 0x01, 0x05, 0x06, 0x06, 0x05, 0x90, // "e" (U+0065)
  0x00, 0x66, 0x00, 0x01, 0x05, 0x08, 0x06, 0x05, 0xA4, // "f" (U+0066)
  0x00, 0x67, 0x00, 0xFE, 0x05, 0x06, 0x06, 0x05, 0xBC, // "g" (U+0067)
  0x00, 0x68, 0x00, 0x01, 0x05, 0x08, 0x06, 0x05, 0xDA, // "h" (U+0068)
  0x00, 0x69, 0x00, 0x01, 0x05, 0x08, 0x06, 0x05, 0xF3, // "i" (U+0069)
  0x00, 0x6A, 0x00, 0xFE, 0x04, 0x08, 0x06, 0x06, 0x09, // "j" (U+006A)
  0x00, 0x6B, 0x00, 0x01, 0x05, 0x08, 0x06, 0x06, 0x28, // "k" (U+006B)
  0x00, 0x6C, 0x00, 0x01, 0x05, 0x08, 0x06, 0x06, 0x41, // "l" (U+006C)
  0x00, 0x6D, 0x00, 0x01, 0x05, 0x06, 0x06, 0x06, 0x56, // "m" (U+006D)
  0x00, 0x6E, 0x00, 0x01, 0x05, 0x06, 0x06, 0x06, 0x6A, // "n" (U+006E)
  0x00, 0x6F, 0x00, 0x01, 0x05, 0x06, 0x06, 0x06, 0x7F, // "o" (U+006F)
  0x00, 0x70, 0x00, 0xFE, 0x05, 0x06, 0x06, 0x06, 0x94, // "p" (U+0070)
  0x00, 0x71, 0x00, 0xFE, 0x05, 0x06, 0x06, 0x06, 0xAF, // "q" (U+0071)
  0x00, 0x72, 0x00, 0x01, 0x05, 0x06, 0x06, 0x06, 0xCA, // "r" (U+0072)
  0x00, 0x73, 0x00, 0x01, 0x05, 0x06, 0x06, 0x06, 0xDD, // "s" (U+0073)
  0x00, 0x74, 0x00, 0x01, 0x05, 0x08, 0x06, 0x06, 0xF2, // "t" (U+0074)
  0x00, 0x75, 0x00, 0x01, 0x05, 0x06, 0x06, 0x07, 0x0B, // "u" (U+0075)
  0x00, 0x76, 0x00, 0x01, 0x05, 0x06, 0x06, 0x07, 0x20, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x01, 0x05, 0x06, 0x06, 0x07, 0x34, // "w" (U+0077)
  0x00, 0x78, 0x00, 0x01, 0x05, 0x06, 0x06, 0x07, 0x48, // "x" (U+0078)
  0x00, 0x79, 0x00, 0xFE, 0x05, 0x06, 0x06, 0x07, 0x5D, // "y" (U+0079)
  0x00, 0x7A, 0x00, 0x01, 0x05, 0x06, 0x06, 0x07, 0x7A, // "z" (U+007A)
  0x00, 0x7B, 0x01, 0xFF, 0x04, 0x08, 0x06, 0x07, 0x8D, // "{" (U+007B)
  0x00, 0x7C, 0x02, 0xFE, 0x03, 0x08, 0x06, 0x07, 0xA5, // "|" (U+007C)
  0x00, 0x7D, 0x01, 0xFF, 0x04, 0x08, 0x06, 0x07, 0xA8, // "}" (U+007D)
  0x00, 0x7E, 0x00, 0x03, 0x05, 0x05, 0x06, 0x07, 0xC0, // "~" (U+007E)
  0x00, 0xA1, 0x02, 0xFE, 0x03, 0x05, 0x06, 0x07, 0xCB, // "¡" (U+00A1)
  0x00, 0xA2, 0x00, 0x01, 0x05, 0x08, 0x06, 0x07, 0xD4, // "¢" (U+00A2)
  0x00, 0xA3, 0x00, 0x01, 0x05, 0x08, 0x06, 0x07, 0xEC, // "£" (U+00A3)
  0x00, 0xA4, 0x00, 0x02, 0x05, 0x07, 0x06, 0x08, 0x03, // "¤" (U+00A4)
  0x00, 0xA5, 0x00, 0x01, 0x05, 0x08, 0x06, 0x08, 0x18, // "¥" (U+00A5)
  0x00, 0xA6, 0x02, 0xFE, 0x03, 0x08, 0x06, 0x08, 0x32, // "¦" (U+00A6)
  0x00, 0xA7, 0x01, 0x01, 0x04, 0x08, 0x06, 0x08, 0x37, // "§" (U+00A7)
  0x00, 0xA8, 0x01, 0x07, 0x04, 0x08, 0x06, 0x08, 0x49, // "¨" (U+00A8)
  0x00, 0xA9, 0x00, 0x01, 0x05, 0x07, 0x06, 0x08, 0x4E, // "©" (U+00A9)
  0x00, 0xAA, 0x01, 0x05, 0x04, 0x08, 0x06, 0x08, 0x64, // "ª" (U+00AA)
  0x00, 0xAB, 0x00, 0x01, 0x05, 0x05, 0x06, 0x08, 0x6E, // "«" (U+00AB)
  0x00, 0xAC, 0x00, 0x01, 0x05, 0x04, 0x06, 0x08, 0x80, // "¬" (U+00AC)
  0x00, 0xAE, 0x00, 0x01, 0x05, 0x07, 0x06, 0x08, 0x8B, // "®" (U+00AE)
  0x00, 0xAF, 0x01, 0x07, 0x04, 0x08, 0x06, 0x08, 0xA1, // "¯" (U+00AF)
  0x00, 0xB0, 0x01, 0x04, 0x04, 0x07, 0x06, 0x08, 0xA6, // "°" (U+00B0)
  0x00, 0xB1, 0x00, 0x01, 0x05, 0x07, 0x06, 0x08, 0xB0, // "±" (U+00B1)
  0x00, 0xB2, 0x01, 0x05, 0x04, 0x09, 0x06, 0x08, 0xC3, // "²" (U+00B2)
  0x00, 0xB3, 0x01, 0x05, 0x04, 0x09, 0x06, 0x08, 0xCF, // "³" (U+00B3)
  0x00, 0xB4, 0x02, 0x08, 0x04, 0x09, 0x06, 0x08, 0xDB, // "´" (U+00B4)
  0x00, 0xB5, 0x00, 0xFE, 0x05, 0x06, 0x06, 0x08, 0xDF, // "µ" (U+00B5)
  0x00, 0xB6, 0x00, 0xFF, 0x05, 0x08, 0x06, 0x08, 0xFB, // "¶" (U+00B6)
  0x00, 0xB7, 0x02, 0x04, 0x03, 0x05, 0x06, 0x09, 0x1B, // "·" (U+00B7)
  0x00, 0xB8, 0x02, 0xFE, 0x03, 0x00, 0x06, 0x09, 0x1E, // "¸" (U+00B8)
  0x00, 0xB9, 0x01, 0x05, 0x04, 0x08, 0x06, 0x09, 0x22, // "¹" (U+00B9)
  0x00, 0xBA, 0x01, 0x05, 0x04, 0x08, 0x06, 0x09, 0x2C, // "º" (U+00BA)
  0x00, 0xBB, 0x00, 0x01, 0x05, 0x05, 0x06, 0x09, 0x34, // "»" (U+00BB)
  0x00, 0xBC, 0x00, 0x01, 0x05, 0x08, 0x06, 0x09, 0x46, // "¼" (U+00BC)
  0x00, 0xBD, 0x00, 0x00, 0x05, 0x08, 0x06, 0x09, 0x60, // "½" (U+00BD)
  0x00, 0xBE, 0x00, 0x01, 0x05, 0x08, 0x06, 0x09, 0x7D, // "¾" (U+00BE)
  0x00, 0xBF, 0x00, 0xFE, 0x04, 0x05, 0x06, 0x09, 0x97, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x09, 0xAD, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x09, 0xCC, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x09, 0xEC, // "Â" (U+00C2)
  0x00, 0xC3, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x0A, 0x0C, // "Ã" (U+00C3)
  0x00, 0xC4, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x0A, 0x2E, // "Ä" (U+00C4)
  0x00, 0xC5, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x0A, 0x4E, // "Å" (U+00C5)
  0x00, 0xC6, 0x00, 0x01, 0x05, 0x08, 0x06, 0x0A, 0x6E, // "Æ" (U+00C6)
  0x00, 0xC7, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x0A, 0x89, // "Ç" (U+00C7)
  0x00, 0xC8, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x0A, 0xA9, // "È" (U+00C8)
  0x00, 0xC9, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x0A, 0xC6, // "É" (U+00C9)
  0x00, 0xCA, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x0A, 0xE3, // "Ê" (U+00CA)
  0x00, 0xCB, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x0B, 0x01, // "Ë" (U+00CB)
  0x00, 0xCC, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x0B, 0x1F, // "Ì" (U+00CC)
  0x00, 0xCD, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x0B, 0x38, // "Í" (U+00CD)
  0x00, 0xCE, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x0B, 0x52, // "Î" (U+00CE)
  0x00, 0xCF, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x0B, 0x6C, // "Ï" (U+00CF)
  0x00, 0xD0, 0x00, 0x01, 0x05, 0x08, 0x06, 0x0B, 0x87, // "Ð" (U+00D0)
  0x00, 0xD1, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x0B, 0xA3, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x0B, 0xC6, // "Ò" (U+00D2)
  0x00, 0xD3, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x0B, 0xE7, // "Ó" (U+00D3)
  0x00, 0xD4, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x0C, 0x09, // "Ô" (U+00D4)
  0x00, 0xD5, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x0C, 0x2C, // "Õ" (U+00D5)
  0x00, 0xD6, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x0C, 0x51, // "Ö" (U+00D6)
  0x00, 0xD7, 0x01, 0x02, 0x04, 0x06, 0x06, 0x0C, 0x74, // "×" (U+00D7)
  0x00, 0xD8, 0x00, 0x00, 0x05, 0x09, 0x06, 0x0C, 0x80, // "Ø" (U+00D8)
  0x00, 0xD9, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x0C, 0x9C, // "Ù" (U+00D9)
  0x00, 0xDA, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x0C, 0xBE, // "Ú" (U+00DA)
  0x00, 0xDB, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x0C, 0xE1, // "Û" (U+00DB)
  0x00, 0xDC, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x0D, 0x04, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x0D, 0x27, // "Ý" (U+00DD)
  0x00, 0xDE, 0x00, 0x01, 0x05, 0x08, 0x06, 0x0D, 0x44, // "Þ" (U+00DE)
  0x00, 0xDF, 0x00, 0x01, 0x05, 0x08, 0x06, 0x0D, 0x5D, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x01, 0x05, 0x09, 0x06, 0x0D, 0x77, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x05, 0x09, 0x06, 0x0D, 0x90, // "á" (U+00E1)
  0x00, 0xE2, 0x00, 0x01, 0x05, 0x09, 0x06, 0x0D, 0xAA, // "â" (U+00E2)
  0x00, 0xE3, 0x00, 0x01, 0x05, 0x09, 0x06, 0x0D, 0xC5, // "ã" (U+00E3)
  0x00, 0xE4, 0x00, 0x01, 0x05, 0x08, 0x06, 0x0D, 0xE2, // "ä" (U+00E4)
  0x00, 0xE5, 0x00, 0x01, 0x05, 0x08, 0x06, 0x0D, 0xFD, // "å" (U+00E5)
  0x00, 0xE6, 0x00, 0x01, 0x05, 0x06, 0x06, 0x0E, 0x17, // "æ" (U+00E6)
  0x00, 0xE7, 0x00, 0xFE, 0x05, 0x06, 0x06, 0x0E, 0x2B, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x01, 0x05, 0x09, 0x06, 0x0E, 0x47, // "è" (U+00E8)
  0x00, 0xE9, 0x00, 0x01, 0x05, 0x09, 0x06, 0x0E, 0x60, // "é" (U+00E9)
  0x00, 0xEA, 0x00, 0x01, 0x05, 0x09, 0x06, 0x0E, 0x7A, // "ê" (U+00EA)
  0x00, 0xEB, 0x00, 0x01, 0x05, 0x08, 0x06, 0x0E, 0x94, // "ë" (U+00EB)
  0x00, 0xEC, 0x00, 0x01, 0x05, 0x09, 0x06, 0x0E, 0xAE, // "ì" (U+00EC)
  0x00, 0xED, 0x00, 0x01, 0x05, 0x09, 0x06, 0x0E, 0xC4, // "í" (U+00ED)
  0x00, 0xEE, 0x00, 0x01, 0x05, 0x09, 0x06, 0x0E, 0xDB, // "î" (U+00EE)
  0x00, 0xEF, 0x00, 0x01, 0x05, 0x08, 0x06, 0x0E, 0xF2, // "ï" (U+00EF)
  0x00, 0xF0, 0x00, 0x01, 0x05, 0x08, 0x06, 0x0F, 0x0A, // "ð" (U+00F0)
  0x00, 0xF1, 0x00, 0x01, 0x05, 0x09, 0x06, 0x0F, 0x26, // "ñ" (U+00F1)
  0x00, 0xF2, 0x00, 0x01, 0x05, 0x09, 0x06, 0x0F, 0x44, // "ò" (U+00F2)
  0x00, 0xF3, 0x00, 0x01, 0x05, 0x09, 0x06, 0x0F, 0x5E, // "ó" (U+00F3)
  0x00, 0xF4, 0x00, 0x01, 0x05, 0x09, 0x06, 0x0F, 0x79, // "ô" (U+00F4)
  0x00, 0xF5, 0x00, 0x01, 0x05, 0x09, 0x06, 0x0F, 0x95, // "õ" (U+00F5)
  0x00, 0xF6, 0x00, 0x01, 0x05, 0x08, 0x06, 0x0F, 0xB3, // "ö" (U+00F6)
  0x00, 0xF7, 0x00, 0x01, 0x05, 0x06, 0x06, 0x0F, 0xCF, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x00, 0x05, 0x06, 0x06, 0x0F, 0xDE, // "ø" (U+00F8)
  0x00, 0xF9, 0x00, 0x01, 0x05, 0x09, 0x06, 0x0F, 0xF3, // "ù" (U+00F9)
  0x00, 0xFA, 0x00, 0x01, 0x05, 0x09, 0x06, 0x10, 0x0E, // "ú" (U+00FA)
  0x00, 0xFB, 0x00, 0x01, 0x05, 0x09, 0x06, 0x10, 0x29, // "û" (U+00FB)
  0x00, 0xFC, 0x00, 0x01, 0x05, 0x08, 0x06, 0x10, 0x45, // "ü" (U+00FC)
  0x00, 0xFD, 0x00, 0xFE, 0x05, 0x09, 0x06, 0x10, 0x61, // "ý" (U+00FD)
  0x00, 0xFE, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x10, 0x84, // "þ" (U+00FE)
  0x00, 0xFF, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x10, 0xA3, // "ÿ" (U+00FF)
  0x01, 0x00, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x10, 0xC6, // "Ā" (U+0100)
  0x01, 0x01, 0x00, 0x01, 0x05, 0x08, 0x06, 0x10, 0xE6, // "ā" (U+0101)
  0x01, 0x02, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x11, 0x01, // "Ă" (U+0102)
  0x01, 0x03, 0x00, 0x01, 0x05, 0x09, 0x06, 0x11, 0x23, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x11, 0x40, // "Ą" (U+0104)
  0x01, 0x05, 0x00, 0xFE, 0x05, 0x06, 0x06, 0x11, 0x5F, // "ą" (U+0105)
  0x01, 0x06, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x11, 0x7A, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x01, 0x05, 0x09, 0x06, 0x11, 0x98, // "ć" (U+0107)
  0x01, 0x08, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x11, 0xB2, // "Ĉ" (U+0108)
  0x01, 0x09, 0x00, 0x01, 0x05, 0x09, 0x06, 0x11, 0xD0, // "ĉ" (U+0109)
  0x01, 0x0A, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x11, 0xEB, // "Ċ" (U+010A)
  0x01, 0x0B, 0x00, 0x01, 0x05, 0x08, 0x06, 0x12, 0x07, // "ċ" (U+010B)
  0x01, 0x0C, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x12, 0x1F, // "Č" (U+010C)
  0x01, 0x0D, 0x00, 0x01, 0x05, 0x09, 0x06, 0x12, 0x3E, // "č" (U+010D)
  0x01, 0x0E, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x12, 0x5A, // "Ď" (U+010E)
  0x01, 0x0F, 0x00, 0x01, 0x06, 0x08, 0x06, 0x12, 0x7E, // "ď" (U+010F)
  0x01, 0x10, 0x00, 0x01, 0x05, 0x08, 0x06, 0x12, 0x9C, // "Đ" (U+0110)
  0x01, 0x11, 0x00, 0x01, 0x05, 0x08, 0x06, 0x12, 0xB8, // "đ" (U+0111)
  0x01, 0x12, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x12, 0xD1, // "Ē" (U+0112)
  0x01, 0x13, 0x00, 0x01, 0x05, 0x08, 0x06, 0x12, 0xEF, // "ē" (U+0113)
  0x01, 0x14, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x13, 0x09, // "Ĕ" (U+0114)
  0x01, 0x15, 0x00, 0x01, 0x05, 0x09, 0x06, 0x13, 0x29, // "ĕ" (U+0115)
  0x01, 0x16, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x13, 0x45, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x01, 0x05, 0x08, 0x06, 0x13, 0x61, // "ė" (U+0117)
  0x01, 0x18, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x13, 0x79, // "Ę" (U+0118)
  0x01, 0x19, 0x00, 0xFE, 0x05, 0x06, 0x06, 0x13, 0x97, // "ę" (U+0119)
  0x01, 0x1A, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x13, 0xB3, // "Ě" (U+011A)
  0x01, 0x1B, 0x00, 0x01, 0x05, 0x09, 0x06, 0x13, 0xD2, // "ě" (U+011B)
  0x01, 0x1C, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x13, 0xED, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x00, 0xFE, 0x05, 0x09, 0x06, 0x14, 0x0D, // "ĝ" (U+011D)
  0x01, 0x1E, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x14, 0x32, // "Ğ" (U+011E)
  0x01, 0x1F, 0x00, 0xFE, 0x05, 0x09, 0x06, 0x14, 0x54, // "ğ" (U+011F)
  0x01, 0x20, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x14, 0x7B, // "Ġ" (U+0120)
  0x01, 0x21, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x14, 0x98, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x14, 0xBA, // "Ģ" (U+0122)
  0x01, 0x23, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x14, 0xD8, // "ģ" (U+0123)
  0x01, 0x24, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x14, 0xFB, // "Ĥ" (U+0124)
  0x01, 0x25, 0xFF, 0x01, 0x05, 0x0B, 0x06, 0x15, 0x1D, // "ĥ" (U+0125)
  0x01, 0x26, 0x00, 0x01, 0x05, 0x08, 0x06, 0x15, 0x40, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x05, 0x08, 0x06, 0x15, 0x57, // "ħ" (U+0127)
  0x01, 0x28, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x15, 0x70, // "Ĩ" (U+0128)
  0x01, 0x29, 0x00, 0x01, 0x05, 0x09, 0x06, 0x15, 0x8D, // "ĩ" (U+0129)
  0x01, 0x2A, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x15, 0xA7, // "Ī" (U+012A)
  0x01, 0x2B, 0x00, 0x01, 0x05, 0x08, 0x06, 0x15, 0xC1, // "ī" (U+012B)
  0x01, 0x2C, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x15, 0xD8, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x00, 0x01, 0x05, 0x09, 0x06, 0x15, 0xF5, // "ĭ" (U+012D)
  0x01, 0x2E, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x16, 0x0F, // "Į" (U+012E)
  0x01, 0x2F, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x16, 0x29, // "į" (U+012F)
  0x01, 0x30, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x16, 0x46, // "İ" (U+0130)
  0x01, 0x31, 0x00, 0x01, 0x05, 0x06, 0x06, 0x16, 0x5E, // "ı" (U+0131)
  0x01, 0x32, 0x00, 0x01, 0x05, 0x08, 0x06, 0x16, 0x6F, // "Ĳ" (U+0132)
  0x01, 0x33, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x16, 0x89, // "ĳ" (U+0133)
  0x01, 0x34, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x16, 0xAD, // "Ĵ" (U+0134)
  0x01, 0x35, 0x00, 0xFE, 0x04, 0x09, 0x06, 0x16, 0xCA, // "ĵ" (U+0135)
  0x01, 0x36, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x16, 0xEB, // "Ķ" (U+0136)
  0x01, 0x37, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x17, 0x0B, // "ķ" (U+0137)
  0x01, 0x38, 0x00, 0x01, 0x05, 0x06, 0x06, 0x17, 0x29, // "ĸ" (U+0138)
  0x01, 0x39, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x17, 0x3E, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x17, 0x5D, // "ĺ" (U+013A)
  0x01, 0x3B, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x17, 0x78, // "Ļ" (U+013B)
  0x01, 0x3C, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x17, 0x95, // "ļ" (U+013C)
  0x01, 0x3D, 0x00, 0x01, 0x05, 0x08, 0x06, 0x17, 0xAF, // "Ľ" (U+013D)
  0x01, 0x3E, 0x00, 0x01, 0x05, 0x08, 0x06, 0x17, 0xC8, // "ľ" (U+013E)
  0x01, 0x3F, 0x00, 0x01, 0x05, 0x08, 0x06, 0x17, 0xE0, // "Ŀ" (U+013F)
  0x01, 0x40, 0x00, 0x01, 0x06, 0x08, 0x06, 0x17, 0xF9, // "ŀ" (U+0140)
  0x01, 0x41, 0x00, 0x01, 0x05, 0x08, 0x06, 0x18, 0x12, // "Ł" (U+0141)
  0x01, 0x42, 0x00, 0x01, 0x05, 0x08, 0x06, 0x18, 0x2A, // "ł" (U+0142)
  0x01, 0x43, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x18, 0x42, // "Ń" (U+0143)
  0x01, 0x44, 0x00, 0x01, 0x05, 0x09, 0x06, 0x18, 0x62, // "ń" (U+0144)
  0x01, 0x45, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x18, 0x7D, // "Ņ" (U+0145)
  0x01, 0x46, 0x00, 0xFE, 0x05, 0x06, 0x06, 0x18, 0x9C, // "ņ" (U+0146)
  0x01, 0x47, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x18, 0xB6, // "Ň" (U+0147)
  0x01, 0x48, 0x00, 0x01, 0x05, 0x09, 0x06, 0x18, 0xD7, // "ň" (U+0148)
  0x01, 0x49, 0xFF, 0x01, 0x05, 0x08, 0x06, 0x18, 0xF4, // "ŉ" (U+0149)
  0x01, 0x4A, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x19, 0x10, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x00, 0xFE, 0x05, 0x06, 0x06, 0x19, 0x33, // "ŋ" (U+014B)
  0x01, 0x4C, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x19, 0x51, // "Ō" (U+014C)
  0x01, 0x4D, 0x00, 0x01, 0x05, 0x08, 0x06, 0x19, 0x74, // "ō" (U+014D)
  0x01, 0x4E, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x19, 0x90, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x00, 0x01, 0x05, 0x09, 0x06, 0x19, 0xB5, // "ŏ" (U+014F)
  0x01, 0x50, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x19, 0xD3, // "Ő" (U+0150)
  0x01, 0x51, 0x00, 0x01, 0x05, 0x08, 0x06, 0x19, 0xF6, // "ő" (U+0151)
  0x01, 0x52, 0x00, 0x01, 0x05, 0x08, 0x06, 0x1A, 0x12, // "Œ" (U+0152)
  0x01, 0x53, 0x00, 0x01, 0x05, 0x06, 0x06, 0x1A, 0x2B, // "œ" (U+0153)
  0x01, 0x54, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x1A, 0x40, // "Ŕ" (U+0154)
  0x01, 0x55, 0x00, 0x01, 0x05, 0x09, 0x06, 0x1A, 0x60, // "ŕ" (U+0155)
  0x01, 0x56, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x1A, 0x79, // "Ŗ" (U+0156)
  0x01, 0x57, 0x00, 0xFE, 0x05, 0x06, 0x06, 0x1A, 0x98, // "ŗ" (U+0157)
  0x01, 0x58, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x1A, 0xB0, // "Ř" (U+0158)
  0x01, 0x59, 0x00, 0x01, 0x05, 0x09, 0x06, 0x1A, 0xD2, // "ř" (U+0159)
  0x01, 0x5A, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x1A, 0xED, // "Ś" (U+015A)
  0x01, 0x5B, 0x00, 0x01, 0x05, 0x09, 0x06, 0x1B, 0x0D, // "ś" (U+015B)
  0x01, 0x5C, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x1B, 0x28, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x00, 0x01, 0x05, 0x09, 0x06, 0x1B, 0x48, // "ŝ" (U+015D)
  0x01, 0x5E, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x1B, 0x63, // "Ş" (U+015E)
  0x01, 0x5F, 0x00, 0xFE, 0x05, 0x06, 0x06, 0x1B, 0x84, // "ş" (U+015F)
  0x01, 0x60, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x1B, 0xA0, // "Š" (U+0160)
  0x01, 0x61, 0x00, 0x01, 0x05, 0x09, 0x06, 0x1B, 0xC1, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x1B, 0xDD, // "Ţ" (U+0162)
  0x01, 0x63, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x1B, 0xF7, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x1C, 0x18, // "Ť" (U+0164)
  0x01, 0x65, 0x00, 0x01, 0x05, 0x08, 0x06, 0x1C, 0x32, // "ť" (U+0165)
  0x01, 0x66, 0x00, 0x01, 0x05, 0x08, 0x06, 0x1C, 0x4C, // "Ŧ" (U+0166)
  0x01, 0x67, 0x00, 0x01, 0x05, 0x08, 0x06, 0x1C, 0x61, // "ŧ" (U+0167)
  0x01, 0x68, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x1C, 0x7A, // "Ũ" (U+0168)
  0x01, 0x69, 0x00, 0x01, 0x05, 0x09, 0x06, 0x1C, 0xA0, // "ũ" (U+0169)
  0x01, 0x6A, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x1C, 0xBE, // "Ū" (U+016A)
  0x01, 0x6B, 0x00, 0x01, 0x05, 0x08, 0x06, 0x1C, 0xE1, // "ū" (U+016B)
  0x01, 0x6C, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x1C, 0xFC, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x00, 0x01, 0x05, 0x09, 0x06, 0x1D, 0x22, // "ŭ" (U+016D)
  0x01, 0x6E, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x1D, 0x40, // "Ů" (U+016E)
  0x01, 0x6F, 0x00, 0x01, 0x05, 0x08, 0x06, 0x1D, 0x63, // "ů" (U+016F)
  0x01, 0x70, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x1D, 0x7E, // "Ű" (U+0170)
  0x01, 0x71, 0x00, 0x01, 0x05, 0x08, 0x06, 0x1D, 0xA2, // "ű" (U+0171)
  0x01, 0x72, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x1D, 0xBE, // "Ų" (U+0172)
  0x01, 0x73, 0x00, 0xFE, 0x05, 0x06, 0x06, 0x1D, 0xE2, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x1D, 0xFE, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x05, 0x09, 0x06, 0x1E, 0x1F, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x1E, 0x3A, // "Ŷ" (U+0176)
  0x01, 0x77, 0x00, 0xFE, 0x05, 0x09, 0x06, 0x1E, 0x57, // "ŷ" (U+0177)
  0x01, 0x78, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x1E, 0x7A, // "Ÿ" (U+0178)
  0x01, 0x79, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x1E, 0x97, // "Ź" (U+0179)
  0x01, 0x7A, 0x00, 0x01, 0x05, 0x09, 0x06, 0x1E, 0xB5, // "ź" (U+017A)
  0x01, 0x7B, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x1E, 0xCE, // "Ż" (U+017B)
  0x01, 0x7C, 0x00, 0x01, 0x05, 0x08, 0x06, 0x1E, 0xEA, // "ż" (U+017C)
  0x01, 0x7D, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x1F, 0x01, // "Ž" (U+017D)
  0x01, 0x7E, 0x00, 0x01, 0x05, 0x09, 0x06, 0x1F, 0x20, // "ž" (U+017E)
  0x01, 0x7F, 0x02, 0x01, 0x05, 0x08, 0x06, 0x1F, 0x3A, // "ſ" (U+017F)
  0x03, 0xA9, 0x00, 0x01, 0x05, 0x08, 0x06, 0x1F, 0x4B, // "Ω" (U+03A9)
  0x03, 0xBC, 0x00, 0xFE, 0x05, 0x06, 0x06, 0x1F, 0x67, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x01, 0x05, 0x06, 0x06, 0x1F, 0x83, // "π" (U+03C0)
  0x20, 0x13, 0x01, 0x02, 0x04, 0x03, 0x06, 0x1F, 0x97, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x02, 0x05, 0x03, 0x06, 0x1F, 0x9A, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x01, 0x05, 0x08, 0x06, 0x1F, 0x9D, // "€" (U+20AC)
  0x20, 0xBF, 0x00, 0x00, 0x05, 0x0A, 0x06, 0x1F, 0xB7, // "₿" (U+20BF)
  0x20, 0x18, 0x02, 0x06, 0x03, 0x08, 0x06, 0x1F, 0xD8, // "‘" (U+2018)
  0x20, 0x19, 0x02, 0x06, 0x03, 0x08, 0x06, 0x1F, 0xDC, // "’" (U+2019)
  0x20, 0x1A, 0x02, 0xFF, 0x03, 0x01, 0x06, 0x1F, 0xE0, // "‚" (U+201A)
  0x20, 0x1B, 0x02, 0x06, 0x03, 0x08, 0x06, 0x1F, 0xE4, // "‛" (U+201B)
  0x20, 0x1C, 0x01, 0x06, 0x04, 0x08, 0x06, 0x1F, 0xE8, // "“" (U+201C)
  0x20, 0x1D, 0x01, 0x05, 0x04, 0x07, 0x06, 0x1F, 0xF0, // "”" (U+201D)
  0x20, 0x1E, 0x01, 0xFF, 0x04, 0x01, 0x06, 0x1F, 0xF8, // "„" (U+201E)
  0x20, 0x1F, 0x01, 0x05, 0x04, 0x07, 0x06, 0x20, 0x00, // "‟" (U+201F)
  0x20, 0x20, 0x01, 0x01, 0x04, 0x08, 0x06, 0x20, 0x08, // "†" (U+2020)
  0x20, 0x21, 0x01, 0x01, 0x04, 0x08, 0x06, 0x20, 0x1C, // "‡" (U+2021)
  0x20, 0x22, 0x01, 0x03, 0x04, 0x05, 0x06, 0x20, 0x2F, // "•" (U+2022)
  0x20, 0x26, 0x00, 0x01, 0x05, 0x02, 0x06, 0x20, 0x37, // "…" (U+2026)
  0x20, 0x30, 0x00, 0x01, 0x05, 0x08, 0x06, 0x20, 0x3B, // "‰" (U+2030)
  0x20, 0x39, 0x01, 0x01, 0x04, 0x05, 0x06, 0x20, 0x56, // "‹" (U+2039)
  0x20, 0x3A, 0x01, 0x02, 0x04, 0x06, 0x06, 0x20, 0x62, // "›" (U+203A)
  0x20, 0x44, 0xFE, 0x01, 0x01, 0x08, 0x00, 0x20, 0x6E, // "⁄" (U+2044)
  0x21, 0x22, 0x00, 0x04, 0x05, 0x07, 0x06, 0x20, 0x81, // "™" (U+2122)
  0x21, 0x52, 0x02, 0x01, 0x0F, 0x08, 0x12, 0x20, 0x8F, // "⅒" (U+2152)
  0x22, 0x02, 0x00, 0x01, 0x05, 0x07, 0x06, 0x20, 0xC3, // "∂" (U+2202)
  0x22, 0x06, 0x00, 0x01, 0x05, 0x08, 0x06, 0x20, 0xDB, // "∆" (U+2206)
  0x22, 0x1A, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x20, 0xF4, // "√" (U+221A)
  0x22, 0x1E, 0x00, 0x03, 0x05, 0x05, 0x06, 0x21, 0x11, // "∞" (U+221E)
  0x22, 0x48, 0x00, 0x02, 0x05, 0x06, 0x06, 0x21, 0x1C, // "≈" (U+2248)
  0x22, 0x60, 0x00, 0x01, 0x05, 0x07, 0x06, 0x21, 0x2C, // "≠" (U+2260)
  0x22, 0x64, 0x00, 0x00, 0x05, 0x07, 0x06, 0x21, 0x3D, // "≤" (U+2264)
  0x22, 0x65, 0x00, 0x00, 0x05, 0x07, 0x06, 0x21, 0x54, // "≥" (U+2265)
  
  // Kerning pairs
  
  // Glyph data
  // "!" (U+0021)
  0x80, 0x0C, 0x00, 0xB8, 0x00, 0xA2, 0x82, 0x11, 0xBB,
  // """ (U+0022)
  0x80, 0x0A, 0x80, 0x09, 0x82, 0x76, 0x67,
  // "#" (U+0023)
  0x28, 0x1E, 0x2E, 0x28, 0x42, 0xD3, 0xC0, 0x8C, 0x89, 0x4D, 0x18, 0xB9, 0x92, 0x07, 0x89, 0x60,
  0xDC, 0x89, 0x18, 0x2C, 0x6E, 0x41, 0x0E, 0x2E, 0x20,
  // "$" (U+0024)
  0x20, 0x50, 0x63, 0x09, 0xA8, 0x92, 0xD0, 0x1F, 0x97, 0x50, 0x1F, 0xB5, 0x38, 0x25, 0xEE, 0x53,
  0x89, 0x14, 0xBF, 0x11, 0x55, 0x9F, 0x22, 0xB0, 0x93, 0x00, 0x62,
  // "%" (U+0025)
  0x8A, 0x47, 0xE5, 0x0E, 0x1E, 0x7C, 0x79, 0x0E, 0x4C, 0xD2, 0x07, 0xEB, 0xB4, 0x8A, 0x4C, 0xAF,
  0x80, 0x4C, 0xC7, 0xE0, 0xB5, 0xC7, 0xE2, 0xD0, 0x5E, 0x70,
  // "&" (U+0026)
  0x18, 0x18, 0xE9, 0x28, 0x31, 0xF7, 0xF1, 0x29, 0x06, 0x93, 0x81, 0xBF, 0x72, 0x8A, 0x62, 0xEF,
  0x5C, 0x69, 0xB6, 0xEF, 0x29, 0xC5, 0xED, 0x02, 0xDE, 0x9E, 0x70,
  // "'" (U+0027)
  0x84, 0xAA, 0x99, 0x76,
  // "(" (U+0028)
  0x18, 0x41, 0xE3, 0x07, 0xB2, 0x0C, 0x06, 0x29, 0x83, 0x30, 0x1F, 0x22, 0x90, 0x32, 0x0D, 0x06,
  0x20, 0x80, 0xB2, 0x81, 0x1E, 0x30,
  // ")" (U+0029)
  0x81, 0x3E, 0x12, 0x0B, 0x07, 0x20, 0x60, 0xD2, 0x03, 0x92, 0x83, 0x2F, 0x10, 0x39, 0x20, 0x60,
  0xC2, 0x84, 0xB7, 0x03, 0xE1, 0x10,
  // "*" (U+002A)
  0x20, 0x08, 0x38, 0x96, 0x89, 0xA8, 0x11, 0x8E, 0xE8, 0x10, 0x5C, 0xC5, 0x20, 0xF3, 0x02, 0x10,
  // "+" (U+002B)
  0x20, 0x08, 0x40, 0x08, 0x20, 0x4C, 0x85, 0x41, 0x39, 0xA3, 0x12, 0x00, 0x82,
  // "," (U+002C)
  0x84, 0x9C, 0xC8, 0xE3,
  // "-" (U+002D)
  0x07, 0xA8, 0x37, 0x13, 0x31,
  // "." (U+002E)
  0x82, 0x11, 0xBB,
  // "/" (U+002F)
  0x20, 0x60, 0xC2, 0x87, 0xB7, 0x01, 0xF2, 0x07, 0xC2, 0x87, 0xC7, 0x02, 0xF1, 0x07, 0xC2, 0x0C,
  0x06, 0x20,
  // "0" (U+0030)
  0x18, 0xD4, 0x6D, 0xE5, 0x01, 0xF8, 0x9F, 0x15, 0xF0, 0xCF, 0x57, 0xE5, 0xCE, 0x67, 0xED, 0x4E,
  0x65, 0xFB, 0x0F, 0x51, 0xF8, 0x8F, 0x10, 0x6E, 0xE6, 0x10,
  // "1" (U+0031)
  0x18, 0x13, 0xCE, 0x20, 0x2A, 0x0E, 0x38, 0x15, 0x7E, 0x40, 0x70, 0xE4, 0x07, 0x0E, 0x40, 0x70,
  0xE3, 0x82, 0x29, 0xF3, 0x20, 0xDB, 0x04,
  // "2" (U+0032)
  0x89, 0x21, 0x9E, 0xE7, 0x02, 0xD6, 0x9F, 0x33, 0x81, 0x3F, 0x53, 0x81, 0x9E, 0x12, 0x81, 0x5F,
  0x62, 0x81, 0x3E, 0x82, 0x85, 0x2E, 0xC3, 0x32, 0x6C, 0x08,
  // "3" (U+0033)
  0x83, 0x1A, 0xEE, 0x72, 0x83, 0x85, 0x9F, 0x13, 0x07, 0x0E, 0x20, 0x3A, 0x05, 0x38, 0x23, 0x9F,
  0x23, 0x89, 0x42, 0xF4, 0x37, 0x49, 0xF2, 0x3D, 0xFD, 0x61,
  // "4" (U+0034)
  0x30, 0xE0, 0xA3, 0x81, 0x8F, 0xA2, 0x82, 0x2E, 0xDA, 0x28, 0x92, 0xA9, 0xAA, 0x03, 0xE1, 0xBA,
  0x09, 0xC8, 0x59, 0x23, 0x3B, 0xB2, 0x30, 0x0A, 0x10,
  // "5" (U+0035)
  0x10, 0xDA, 0x0D, 0x28, 0x2E, 0x94, 0x42, 0x90, 0x60, 0x12, 0x01, 0xB0, 0x82, 0x83, 0x43, 0xAF,
  0x23, 0x89, 0x44, 0xF3, 0x28, 0x5B, 0xE0, 0x2D, 0xFC, 0x41,
  // "6" (U+0036)
  0x18, 0x21, 0xAE, 0xE2, 0x86, 0xCD, 0x54, 0x03, 0xF3, 0x38, 0xB3, 0x6F, 0x9F, 0xA0, 0x6F, 0x86,
  0xF4, 0x5F, 0x10, 0xF6, 0x1E, 0x87, 0xF3, 0x04, 0xDE, 0x71,
  // "7" (U+0037)
  0x07, 0xC8, 0x57, 0x13, 0x36, 0xF4, 0x30, 0x90, 0xD4, 0x0E, 0x08, 0x38, 0x16, 0xF2, 0x30, 0xC0,
  0xB3, 0x81, 0x2F, 0x53, 0x09, 0x0E, 0x30,
  // "8" (U+0038)
  0x18, 0xA1, 0x7D, 0xD7, 0x01, 0xF8, 0x8F, 0x10, 0xF8, 0x8F, 0x10, 0x7A, 0x06, 0x28, 0xA4, 0xDC,
  0xDC, 0x05, 0xF1, 0x1F, 0x54, 0xF7, 0x6F, 0x40, 0x8E, 0xE7, 0x10,
  // "9" (U+0039)
  0x18, 0xB3, 0x7E, 0xD4, 0x03, 0xF7, 0x8E, 0x16, 0xF0, 0x1F, 0x55, 0xF4, 0x5F, 0x60, 0xDF, 0xCF,
  0x62, 0x87, 0x23, 0xF3, 0x04, 0x5D, 0xC2, 0x82, 0xEE, 0xA1, 0x10,
  // ":" (U+003A)
  0x82, 0xBB, 0x11, 0x48, 0x21, 0x1B, 0xB0,
  // ";" (U+003B)
  0x82, 0x7D, 0x6B, 0x68, 0x49, 0xCC, 0x8E, 0x30,
  // "<" (U+003C)
  0x38, 0x93, 0x3B, 0x20, 0x3B, 0xD6, 0x01, 0xFC, 0x13, 0x82, 0x29, 0xE8, 0x48, 0x11, 0x92,
  // "=" (U+003D)
  0x04, 0xC8, 0x64, 0x13, 0x33, 0x31, 0x4C, 0x85, 0x41, 0x33, 0x33, 0x10,
  // ">" (U+003E)
  0x81, 0x2B, 0x34, 0x82, 0x6D, 0xB3, 0x38, 0x93, 0x1C, 0xF1, 0x08, 0xE9, 0x20, 0x29, 0x13,
  // "?" (U+003F)
  0x89, 0x0A, 0xED, 0x60, 0xA5, 0x9F, 0x12, 0x85, 0x5F, 0x20, 0x1D, 0xC2, 0x81, 0xBC, 0x12, 0x0C,
  0x05, 0x30, 0x23, 0x81, 0x1E, 0x62,
  // "@" (U+0040)
  0x18, 0xD4, 0x4D, 0xE8, 0x02, 0xE7, 0x5D, 0x69, 0x7B, 0xE9, 0xCD, 0x6C, 0xA6, 0xEE, 0x67, 0x95,
  0xEE, 0x69, 0xB8, 0xDC, 0x6F, 0xCF, 0x77, 0xC4, 0x14, 0x20, 0xAA, 0x0C, 0x30, 0x10, 0x22,
  // "A" (U+0041)
  0x10, 0x1A, 0x38, 0x24, 0xEE, 0x42, 0x82, 0x8B, 0xB8, 0x28, 0x2C, 0x88, 0xC2, 0x98, 0x36, 0x6F,
  0x04, 0xC8, 0x74, 0x8D, 0x33, 0xE8, 0xC9, 0x20, 0xA0, 0xC0,
  // "B" (U+0042)
  0x03, 0xA8, 0x96, 0xEA, 0x03, 0xF5, 0x6F, 0x53, 0xF2, 0x3F, 0x53, 0xB8, 0xA3, 0xB0, 0x3F, 0x55,
  0xF5, 0x3F, 0x20, 0xE8, 0x3F, 0x56, 0xF6, 0x3A, 0x0E, 0x0A, 0x10,
  // "C" (U+0043)
  0x18, 0x94, 0x1B, 0xEE, 0x50, 0xDC, 0x46, 0x24, 0xF3, 0x30, 0x79, 0x40, 0x79, 0x48, 0x15, 0xF2,
  0x38, 0x92, 0x1E, 0xB4, 0x63, 0x03, 0xCF, 0xD3,
  // "D" (U+0044)
  0x08, 0xA8, 0x91, 0xC4, 0x08, 0xE4, 0x9F, 0x28, 0xD2, 0x82, 0xE8, 0x8D, 0x28, 0x2C, 0xA8, 0xD2,
  0x82, 0xC9, 0x8D, 0x28, 0x7E, 0x78, 0xE4, 0xAF, 0x18, 0xA0, 0xD0, 0x41,
  // "E" (U+0045)
  0x03, 0xC8, 0x90, 0x43, 0xF6, 0x33, 0x13, 0xF3, 0x30, 0x3C, 0x89, 0x02, 0x3F, 0x53, 0x30, 0x3F,
  0x33, 0x85, 0x3F, 0x63, 0x31, 0x3C, 0x04,
  // "F" (U+0046)
  0x03, 0xC8, 0x90, 0x43, 0xF6, 0x33, 0x13, 0xF3, 0x38, 0x13, 0xF3, 0x30, 0x3C, 0x89, 0x02, 0x3F,
  0x53, 0x30, 0x3F, 0x33, 0x81, 0x3F, 0x33,
  // "G" (U+0047)
  0x18, 0x93, 0x4C, 0xFD, 0x41, 0xFB, 0x47, 0x17, 0xE4, 0x09, 0x0C, 0x48, 0xA6, 0xAC, 0x0B, 0xF8,
  0x8E, 0x02, 0xC8, 0x2F, 0xA4, 0xD8, 0x05, 0xDF, 0xD5,
  // "H" (U+0048)
  0x08, 0x0E, 0x28, 0x2E, 0x88, 0xE2, 0x82, 0xE8, 0x8E, 0x28, 0x1E, 0x88, 0xC8, 0x78, 0x8E, 0x33,
  0xE8, 0x8E, 0x28, 0x2E, 0x88, 0xE2, 0x82, 0xE8, 0x8E, 0x20, 0xE0, 0x80,
  // "I" (U+0049)
  0x01, 0xC8, 0x41, 0x03, 0xCC, 0x33, 0x00, 0xA4, 0x00, 0xA4, 0x00, 0xA4, 0x00, 0xA3, 0x84, 0x2C,
  0xB2, 0x01, 0xC0, 0x10,
  // "J" (U+004A)
  0x30, 0x80, 0xE3, 0x08, 0x0E, 0x30, 0x80, 0xE3, 0x08, 0x0E, 0x30, 0x80, 0xE3, 0x89, 0x28, 0xD1,
  0x65, 0xDA, 0x2E, 0xEB, 0x20,
  // "K" (U+004B)
  0x8A, 0x48, 0xD0, 0x3F, 0x58, 0xD0, 0xCB, 0x08, 0xD6, 0xE2, 0x08, 0xED, 0x82, 0x08, 0xA0, 0xD2,
  0x8A, 0x08, 0xE3, 0xF5, 0x08, 0xD0, 0xBC, 0x08, 0xD0, 0x3F, 0x50,
  // "L" (U+004C)
  0x81, 0x1F, 0x53, 0x81, 0x1F, 0x53, 0x81, 0x1F, 0x53, 0x81, 0x1F, 0x53, 0x81, 0x1F, 0x53, 0x81,
  0x1F, 0x53, 0x85, 0x1F, 0x95, 0x51, 0x1C, 0x04,
  // "M" (U+004D)
  0x8C, 0x49, 0xF6, 0x5F, 0x99, 0xE8, 0x7F, 0x99, 0xCA, 0xAD, 0x99, 0xBD, 0xCB, 0x99, 0xAE, 0xEA,
  0x99, 0xAC, 0xCA, 0x99, 0xA2, 0x82, 0xA9, 0x9A, 0x20, 0xA0, 0x90,
  // "N" (U+004E)
  0x8D, 0x68, 0xF8, 0x0B, 0x88, 0xED, 0x0B, 0x88, 0xBF, 0x2B, 0x88, 0xBB, 0x6B, 0x88, 0xB7, 0xBB,
  0x88, 0xB2, 0xFB, 0x88, 0xB0, 0xDE, 0x88, 0xB0, 0x9F, 0x80,
  // "O" (U+004F)
  0x18, 0x93, 0x7E, 0xE7, 0x03, 0xF7, 0x7F, 0x38, 0xE2, 0x82, 0xE8, 0xAC, 0x28, 0x2C, 0xAA, 0xC2,
  0x82, 0xCA, 0x8E, 0x28, 0x93, 0xE8, 0x3F, 0x77, 0xF3, 0x07, 0xEE, 0x71,
  // "P" (U+0050)
  0x03, 0xA8, 0xA4, 0xEA, 0x03, 0xF6, 0x5F, 0x63, 0xF3, 0x0D, 0x83, 0xF3, 0x3F, 0x63, 0xB8, 0x4C,
  0x13, 0xF5, 0x22, 0x81, 0x3F, 0x33, 0x81, 0x3F, 0x33,
  // "Q" (U+0051)
  0x18, 0x93, 0x7E, 0xE7, 0x03, 0xF7, 0x7F, 0x38, 0xE2, 0x82, 0xE8, 0xAC, 0x28, 0x2C, 0xAA, 0xC2,
  0x82, 0xCA, 0x8E, 0x28, 0x93, 0xE8, 0x3F, 0x77, 0xF4, 0x07, 0xEF, 0xA4, 0x0A, 0x0C, 0x48, 0x13,
  0xF4,
  // "R" (U+0052)
  0x03, 0xA8, 0xA4, 0xD5, 0x03, 0xF6, 0x9F, 0x13, 0xF3, 0x2F, 0x43, 0xF4, 0x7F, 0x23, 0xB8, 0xA2,
  0x80, 0x3F, 0x6E, 0x60, 0x3F, 0x37, 0xE1, 0x3F, 0x30, 0xE8,
  // "S" (U+0053)
  0x18, 0x94, 0x6D, 0xEC, 0x10, 0xFA, 0x48, 0x01, 0xF7, 0x48, 0x29, 0xFA, 0x13, 0x82, 0x7E, 0xE1,
  0x38, 0x94, 0x3F, 0x63, 0x84, 0x7F, 0x42, 0xCF, 0xD8, 0x10,
  // "T" (U+0054)
  0x0A, 0xC8, 0x5A, 0x23, 0xCC, 0x32, 0x20, 0x0B, 0x40, 0x0B, 0x40, 0x0B, 0x40, 0x0B, 0x40, 0x0B,
  0x40, 0x0B, 0x20,
  // "U" (U+0055)
  0x08, 0x0E, 0x28, 0x2E, 0x88, 0xE2, 0x82, 0xE8, 0x8E, 0x28, 0x2E, 0x88, 0xE2, 0x82, 0xE8, 0x8E,
  0x28, 0x2E, 0x87, 0xE2, 0x89, 0x3E, 0x74, 0xF7, 0x7F, 0x40, 0x8E, 0xE8, 0x10,
  // "V" (U+0056)
  0x0C, 0x0A, 0x28, 0x2A, 0xB8, 0xD2, 0x89, 0x3D, 0x73, 0xF1, 0x1F, 0x30, 0xE5, 0x5E, 0x28, 0x2B,
  0x88, 0xB2, 0x82, 0x7B, 0xB7, 0x28, 0x23, 0xEE, 0x33, 0x00, 0xE2,
  // "W" (U+0057)
  0x0D, 0x06, 0x28, 0x26, 0xDC, 0x72, 0x8C, 0x47, 0xCB, 0x8B, 0xB8, 0xBA, 0x9D, 0xD9, 0xA9, 0xAD,
  0xDA, 0x98, 0xCB, 0xBC, 0x87, 0xE9, 0x9E, 0x76, 0xF7, 0x7F, 0x60,
  // "X" (U+0058)
  0x89, 0x16, 0xE1, 0x1F, 0x60, 0xD7, 0x8D, 0x28, 0x25, 0xEE, 0x53, 0x00, 0xD4, 0x00, 0xE3, 0x89,
  0x37, 0xDD, 0x70, 0x1E, 0x66, 0xE1, 0x8D, 0x20, 0xE0, 0x80,
  // "Y" (U+0059)
  0x09, 0x0E, 0x28, 0x93, 0xD9, 0x2F, 0x44, 0xF2, 0x0B, 0xA9, 0xB2, 0x82, 0x5F, 0xE5, 0x30, 0x0D,
  0x40, 0x0B, 0x40, 0x0B, 0x40, 0x0B, 0x20,
  // "Z" (U+005A)
  0x10, 0xEB, 0x85, 0x40, 0x33, 0xAE, 0x13, 0x0E, 0x08, 0x38, 0x17, 0xE1, 0x30, 0xE0, 0x83, 0x81,
  0x6E, 0x13, 0x84, 0xEA, 0x33, 0x13, 0xC0, 0x40,
  // "[" (U+005B)
  0x8B, 0x4A, 0xFA, 0xAA, 0x2A, 0x80, 0xA8, 0x0A, 0x80, 0xA8, 0x0A, 0x80, 0xA8, 0x0A, 0xFA, 0x23,
  0x20,
  // "\" (U+005C)
  0x0C, 0x06, 0x20, 0x70, 0xB2, 0x81, 0x2F, 0x12, 0x0C, 0x06, 0x20, 0x70, 0xC2, 0x81, 0x1F, 0x22,
  0x0C, 0x07, 0x20, 0x60, 0xC0,
  // "]" (U+005D)
  0x8B, 0x42, 0x32, 0xAF, 0xA0, 0x8A, 0x08, 0xA0, 0x8A, 0x08, 0xA0, 0x8A, 0x08, 0xA2, 0xAA, 0xAF,
  0xA0,
  // "^" (U+005E)
  0x20, 0x90, 0x73, 0x81, 0x1F, 0xE3, 0x82, 0x7A, 0xB6, 0x28, 0x5E, 0x34, 0xD0, 0x5C, 0x20, 0xC0,
  0x50,
  // "_" (U+005F)
  0xE8, 0x02, 0x30,
  // "`" (U+0060)
  0x03, 0x07, 0x20, 0x09,
  // "a" (U+0061)
  0x18, 0x2B, 0xEE, 0x82, 0x85, 0x55, 0x6F, 0x30, 0xBB, 0x8A, 0x15, 0x6F, 0x53, 0xF5, 0x6F, 0x58,
  0xF5, 0x1C, 0xE8, 0xD5,
  // "b" (U+0062)
  0x07, 0x94, 0x07, 0x94, 0x89, 0x37, 0xE9, 0xEA, 0x07, 0xF8, 0x7F, 0x57, 0x92, 0x81, 0xE8, 0x79,
  0x28, 0x93, 0xE8, 0x7F, 0x87, 0xF5, 0x7B, 0x8E, 0xA1,
  // "c" (U+0063)
  0x18, 0x94, 0x4C, 0xFD, 0x10, 0xEB, 0x46, 0x03, 0xF3, 0x38, 0x13, 0xF3, 0x38, 0x31, 0xEB, 0x47,
  0x28, 0x25, 0xDF, 0xC1,
  // "d" (U+0064)
  0x49, 0x07, 0x49, 0x89, 0x57, 0x0A, 0xEA, 0xE7, 0x5F, 0x77, 0xF7, 0x8E, 0x28, 0x2E, 0x78, 0xE2,
  0x89, 0x4D, 0x75, 0xF7, 0x6F, 0x70, 0xBE, 0x9D, 0x70,
  // "e" (U+0065)
  0x18, 0x92, 0x6E, 0xE8, 0x03, 0xF7, 0x6E, 0x47, 0xC8, 0xA1, 0x76, 0xF3, 0x33, 0x12, 0xFA, 0x46,
  0x30, 0x5C, 0xFD, 0x30,
  // "f" (U+0066)
  0x28, 0x25, 0xEF, 0x92, 0x84, 0xDC, 0x42, 0x3D, 0xB8, 0x55, 0x13, 0xEA, 0x31, 0x20, 0xD0, 0x94,
  0x0D, 0x09, 0x40, 0xD0, 0x94, 0x0D, 0x09, 0x20,
  // "g" (U+0067)
  0x18, 0x93, 0xAE, 0x9D, 0x75, 0xF7, 0x7F, 0x78, 0xE2, 0x82, 0xE7, 0x8E, 0x28, 0x94, 0xE7, 0x5F,
  0x77, 0xF7, 0x0A, 0xE9, 0xF7, 0x49, 0x89, 0x26, 0x28, 0x48, 0xF2, 0x2D, 0xFD, 0x61,
  // "h" (U+0068)
  0x07, 0x94, 0x07, 0x94, 0x8A, 0x17, 0xF9, 0xEB, 0x07, 0xF8, 0x6F, 0x67, 0xF1, 0x0F, 0x77, 0x92,
  0x81, 0xE7, 0x79, 0x28, 0x1E, 0x77, 0x92, 0x0E, 0x07,
  // "i" (U+0069)
  0x20, 0x80, 0xD4, 0x01, 0x02, 0x20, 0x1A, 0x0D, 0x38, 0x13, 0xAD, 0x40, 0x90, 0xD4, 0x09, 0x0D,
  0x38, 0x42, 0xAE, 0x20, 0x6C, 0x07,
  // "j" (U+006A)
  0x28, 0x14, 0xE3, 0x30, 0x32, 0x0A, 0xA8, 0x44, 0x02, 0x7F, 0x42, 0x81, 0x2F, 0x42, 0x81, 0x2F,
  0x42, 0x81, 0x2F, 0x42, 0x81, 0x2F, 0x42, 0x89, 0x23, 0xF4, 0x46, 0xAF, 0x17, 0xFE, 0x71,
  // "k" (U+006B)
  0x06, 0x94, 0x06, 0x94, 0x89, 0x66, 0xF0, 0x5F, 0x56, 0xF3, 0xE8, 0x06, 0xFC, 0xD2, 0x8A, 0x06,
  0xFC, 0xF4, 0x06, 0xF0, 0x9D, 0x06, 0xF0, 0x1E, 0x80,
  // "l" (U+006C)
  0x1A, 0x0D, 0x38, 0x11, 0xAD, 0x40, 0x90, 0xD4, 0x09, 0x0D, 0x40, 0x90, 0xD4, 0x09, 0x0D, 0x38,
  0x41, 0xAD, 0x10, 0x6C, 0x07,
  // "m" (U+006D)
  0x8C, 0x2A, 0xAE, 0x7E, 0x6A, 0xBB, 0xCB, 0xAA, 0x89, 0x98, 0xAA, 0x89, 0x98, 0xAA, 0x89, 0x98,
  0xAA, 0x89, 0x98, 0xA0,
  // "n" (U+006E)
  0x8A, 0x17, 0xC9, 0xEB, 0x07, 0xF9, 0x6F, 0x67, 0xF1, 0x0F, 0x77, 0x92, 0x81, 0xE7, 0x79, 0x28,
  0x1E, 0x77, 0x92, 0x0E, 0x07,
  // "o" (U+006F)
  0x18, 0x93, 0x7E, 0xE7, 0x04, 0xF7, 0x7F, 0x48, 0xE2, 0x82, 0xE8, 0x8E, 0x28, 0x93, 0xE8, 0x4F,
  0x77, 0xF4, 0x08, 0xEE, 0x71,
  // "p" (U+0070)
  0x89, 0x37, 0xC9, 0xEA, 0x07, 0xF8, 0x7F, 0x57, 0x92, 0x81, 0xE8, 0x79, 0x28, 0x95, 0xE8, 0x7F,
  0x87, 0xF5, 0x7E, 0xAE, 0x90, 0x79, 0x40, 0x79, 0x40, 0x79, 0x40,
  // "q" (U+0071)
  0x18, 0x93, 0xAE, 0x9C, 0x75, 0xF7, 0x7F, 0x78, 0xE2, 0x82, 0xE7, 0x8E, 0x28, 0x94, 0xE7, 0x5F,
  0x77, 0xF7, 0x0B, 0xE9, 0xE7, 0x49, 0x07, 0x49, 0x07, 0x49, 0x07,
  // "r" (U+0072)
  0x04, 0xA8, 0x93, 0x7E, 0xA0, 0x3F, 0xC4, 0x20, 0x2F, 0x53, 0x81, 0x2F, 0x43, 0x84, 0x5F, 0x71,
  0x09, 0xB0, 0xA1,
  // "s" (U+0073)
  0x18, 0x90, 0x7E, 0xEB, 0x01, 0xF9, 0x47, 0x28, 0x2D, 0xE8, 0x13, 0x89, 0x57, 0xEE, 0x02, 0x74,
  0x8F, 0x22, 0xDF, 0xE8, 0x10,
  // "t" (U+0074)
  0x20, 0x70, 0x14, 0x90, 0x32, 0x05, 0x0E, 0xB8, 0x91, 0x41, 0x6F, 0x64, 0x10, 0x3F, 0x33, 0x81,
  0x3F, 0x33, 0x83, 0x1F, 0x94, 0x22, 0x82, 0x8E, 0xE4,
  // "u" (U+0075)
  0x07, 0x0E, 0x29, 0x81, 0x77, 0xE2, 0x98, 0x17, 0x7E, 0x29, 0x8A, 0x17, 0x7E, 0x01, 0xF7, 0x6F,
  0x69, 0xF7, 0x0B, 0xE9, 0xC7,
  // "v" (U+0076)
  0x09, 0x0E, 0x28, 0x93, 0xD9, 0x4F, 0x32, 0xF4, 0x0E, 0x76, 0xE2, 0x82, 0x9B, 0xB9, 0x28, 0x24,
  0xFE, 0x43, 0x00, 0xE2,
  // "w" (U+0077)
  0x0E, 0x05, 0x28, 0xB6, 0x5E, 0xC7, 0xBB, 0x6C, 0xA8, 0xDD, 0x7A, 0x8A, 0xDD, 0xA8, 0x6E, 0xAA,
  0xE6, 0x4F, 0x88, 0xF4,
  // "x" (U+0078)
  0x89, 0x16, 0xF4, 0x3F, 0x70, 0xCC, 0xBC, 0x20, 0x2A, 0x03, 0x20, 0x3A, 0x03, 0x28, 0x91, 0xCB,
  0xBD, 0x07, 0xF3, 0x3F, 0x70,
  // "y" (U+0079)
  0x09, 0x0E, 0x28, 0x93, 0xD9, 0x4F, 0x32, 0xF4, 0x0E, 0x76, 0xE2, 0x82, 0x9C, 0xAA, 0x28, 0x24,
  0xFE, 0x53, 0x0E, 0x94, 0x00, 0xB2, 0x82, 0x28, 0xF4, 0x28, 0x16, 0xE8, 0x30,
  // "z" (U+007A)
  0x03, 0xC8, 0x54, 0x03, 0x4D, 0xD1, 0x28, 0x17, 0xF3, 0x28, 0x13, 0xF6, 0x28, 0x51, 0xDC, 0x33,
  0x15, 0xC0, 0x50,
  // "{" (U+007B)
  0x18, 0x90, 0x2D, 0x90, 0x7D, 0x30, 0x7B, 0x28, 0x90, 0xAB, 0x09, 0xE4, 0x02, 0xCA, 0x20, 0x70,
  0xB2, 0x07, 0x0D, 0x28, 0x13, 0xF9, 0x20, 0x01,
  // "|" (U+007C)
  0x80, 0xA2, 0x80,
  // "}" (U+007D)
  0x00, 0x12, 0x85, 0x9F, 0x30, 0x1D, 0x72, 0x0B, 0x07, 0x28, 0x90, 0xAC, 0x20, 0x4E, 0x90, 0xBA,
  0x28, 0x90, 0xB7, 0x03, 0xD7, 0x09, 0xD2, 0x10,
  // "~" (U+007E)
  0x18, 0x96, 0xDD, 0x49, 0x34, 0x74, 0xEE, 0x01, 0x10, 0x11, 0x10,
  // "¡" (U+00A1)
  0x82, 0xBB, 0x11, 0x28, 0x00, 0xA0, 0x0B, 0x80, 0x0C,
  // "¢" (U+00A2)
  0x30, 0xC3, 0x05, 0x0E, 0xA8, 0x90, 0x21, 0xE9, 0x13, 0x03, 0xF2, 0x38, 0x13, 0xF2, 0x48, 0x91,
  0xEA, 0x35, 0x10, 0x4D, 0xFE, 0x13, 0x0C, 0x20,
  // "£" (U+00A3)
  0x28, 0x7A, 0xED, 0x20, 0x5F, 0x66, 0x20, 0x79, 0x30, 0x3B, 0x09, 0x28, 0x28, 0xF3, 0x22, 0x07,
  0x0D, 0x48, 0x4C, 0xA3, 0x31, 0x2C, 0x06,
  // "¤" (U+00A4)
  0x10, 0x12, 0x89, 0x31, 0x03, 0xED, 0xDE, 0x20, 0xD7, 0x7D, 0x28, 0x5E, 0x33, 0xE0, 0x2E, 0xA8,
  0x5E, 0x10, 0x41, 0x14, 0x10,
  // "¥" (U+00A5)
  0x08, 0x0D, 0x28, 0x93, 0xE8, 0x1F, 0x55, 0xF1, 0x09, 0xBB, 0x92, 0x02, 0xA8, 0x12, 0x01, 0xC8,
  0x61, 0x03, 0xBB, 0x30, 0x1C, 0x84, 0x10, 0x3B, 0xB3, 0x10,
  // "¦" (U+00A6)
  0x80, 0x48, 0x68, 0x04, 0x80,
  // "§" (U+00A7)
  0x8B, 0x65, 0xDE, 0x8D, 0xA4, 0x57, 0xE8, 0x1C, 0x7A, 0xCB, 0xB7, 0xC0, 0x5D, 0x97, 0x49, 0xDA,
  0xED, 0x50,
  // "¨" (U+00A8)
  0x83, 0xB6, 0x6C, 0x12, 0x01,
  // "©" (U+00A9)
  0x18, 0xB5, 0x8E, 0xE8, 0x05, 0xBD, 0xFA, 0x5A, 0x7A, 0x40, 0xAA, 0x78, 0x11, 0xA7, 0xBD, 0xFB,
  0x70, 0xBA, 0x0B, 0x30, 0x02, 0x20,
  // "ª" (U+00AA)
  0x89, 0x61, 0xBD, 0x33, 0xCD, 0x88, 0x78, 0x83, 0xC9, 0x70,
  // "«" (U+00AB)
  0x18, 0x96, 0x2C, 0x2C, 0x20, 0xD9, 0xBB, 0x03, 0xF6, 0xE6, 0x28, 0x37, 0xD6, 0xE1, 0x28, 0x15,
  0x04, 0x10,
  // "¬" (U+00AC)
  0x04, 0xC8, 0x53, 0x13, 0x33, 0xE3, 0x40, 0xD0, 0x34, 0x02, 0x10,
  // "®" (U+00AE)
  0x18, 0xB5, 0x8E, 0xE8, 0x05, 0xDF, 0xEC, 0x5A, 0x39, 0xA3, 0xAA, 0x2D, 0xC1, 0xA6, 0xB8, 0x8B,
  0x70, 0xBA, 0x0B, 0x30, 0x02, 0x20,
  // "¯" (U+00AF)
  0x08, 0xA8, 0x38, 0x13, 0x31,
  // "°" (U+00B0)
  0x87, 0x2D, 0xD2, 0x89, 0x98, 0x4A, 0x82, 0x40, 0x11, 0x10,
  // "±" (U+00B1)
  0x20, 0x08, 0x40, 0x08, 0x20, 0x4C, 0x85, 0x40, 0x39, 0xA3, 0x12, 0x00, 0x82, 0x85, 0x13, 0x33,
  0x31, 0x4C, 0x04,
  // "²" (U+00B2)
  0x8A, 0x23, 0xCC, 0x11, 0x1A, 0x50, 0x2D, 0x11, 0xC4, 0x06, 0xED, 0x70,
  // "³" (U+00B3)
  0x8A, 0x23, 0xCC, 0x10, 0x1B, 0x40, 0xAD, 0x11, 0x09, 0x65, 0xDC, 0x20,
  // "´" (U+00B4)
  0x18, 0x37, 0x47, 0xB1,
  // "µ" (U+00B5)
  0x07, 0x0E, 0x29, 0x81, 0x77, 0xE2, 0x98, 0x17, 0x7E, 0x29, 0x8A, 0x37, 0x7E, 0x01, 0xF7, 0x7F,
  0x69, 0xF7, 0x7F, 0xE9, 0xC7, 0x7E, 0x40, 0x70, 0xE4, 0x07, 0x0E, 0x40,
  // "¶" (U+00B6)
  0x10, 0x90, 0xEA, 0x07, 0x05, 0xB8, 0x17, 0x78, 0xB8, 0x14, 0x78, 0xB8, 0x14, 0x74, 0xB8, 0x64,
  0x70, 0x48, 0xD4, 0x73, 0x81, 0xB4, 0x73, 0x81, 0xB4, 0x73, 0x81, 0xB4, 0x73, 0x81, 0x83, 0x50,
  // "·" (U+00B7)
  0x82, 0x11, 0xBB,
  // "¸" (U+00B8)
  0x84, 0x43, 0x3E, 0xCA,
  // "¹" (U+00B9)
  0x85, 0x2B, 0xA0, 0x27, 0xA2, 0x85, 0x4A, 0x02, 0xBD, 0x60,
  // "º" (U+00BA)
  0x82, 0x2C, 0xC1, 0x80, 0x47, 0x82, 0x1B, 0xB1,
  // "»" (U+00BB)
  0x18, 0x14, 0x05, 0x28, 0x32, 0xE6, 0xD7, 0x28, 0x96, 0x6E, 0x6F, 0x30, 0xBB, 0x9C, 0x02, 0xC2,
  0xC2, 0x10,
  // "¼" (U+00BC)
  0x07, 0x0D, 0x40, 0x40, 0xC2, 0x89, 0x39, 0x40, 0xC0, 0x6A, 0x08, 0xEA, 0xD1, 0x38, 0x96, 0xC3,
  0x72, 0x09, 0x76, 0xC4, 0x3A, 0x0B, 0xC9, 0x40, 0x60, 0x30,
  // "½" (U+00BD)
  0x07, 0x0D, 0x40, 0x40, 0xC2, 0x89, 0x39, 0x40, 0xC0, 0x6A, 0x07, 0xE9, 0xD1, 0x38, 0x96, 0xC9,
  0xE7, 0x07, 0x92, 0x68, 0x3C, 0x01, 0xA1, 0x38, 0x18, 0xFD, 0x38, 0x11, 0x32,
  // "¾" (U+00BE)
  0x81, 0x6F, 0x73, 0x89, 0x73, 0xF5, 0x08, 0x42, 0x79, 0x5B, 0x09, 0xFA, 0xD1, 0x28, 0x97, 0x3C,
  0x36, 0x10, 0x97, 0x6C, 0x43, 0xA0, 0xBC, 0x94, 0x06, 0x03,
  // "¿" (U+00BF)
  0x28, 0x17, 0xE1, 0x30, 0x23, 0x05, 0x0C, 0x28, 0x11, 0xCB, 0x28, 0x5C, 0xD2, 0x02, 0xF5, 0x28,
  0x90, 0x1F, 0x85, 0xA0, 0x6E, 0xEA,
  // "À" (U+00C0)
  0x10, 0x30, 0x75, 0x00, 0x97, 0x20, 0x1A, 0x38, 0x24, 0xEE, 0x42, 0x82, 0x8B, 0xB8, 0x28, 0x2C,
  0x88, 0xC2, 0x98, 0x36, 0x6F, 0x04, 0xC8, 0x74, 0x8D, 0x33, 0xE8, 0xC9, 0x20, 0xA0, 0xC0,
  // "Á" (U+00C1)
  0x30, 0x70, 0x43, 0x81, 0x7B, 0x17, 0x10, 0x1A, 0x38, 0x24, 0xEE, 0x42, 0x82, 0x8B, 0xB8, 0x28,
  0x2C, 0x88, 0xC2, 0x98, 0x36, 0x6F, 0x04, 0xC8, 0x74, 0x8D, 0x33, 0xE8, 0xC9, 0x20, 0xA0, 0xC0,
  // "Â" (U+00C2)
  0x20, 0x60, 0x73, 0x82, 0x7A, 0x98, 0x71, 0x01, 0xA3, 0x82, 0x4E, 0xE4, 0x28, 0x28, 0xBB, 0x82,
  0x82, 0xC8, 0x8C, 0x29, 0x83, 0x66, 0xF0, 0x4C, 0x87, 0x48, 0xD3, 0x3E, 0x8C, 0x92, 0x0A, 0x0C,
  // "Ã" (U+00C3)
  0x18, 0x26, 0xC1, 0xB2, 0x82, 0xB5, 0xE8, 0x20, 0x15, 0x01, 0xA3, 0x82, 0x4E, 0xE4, 0x28, 0x28,
  0xBB, 0x82, 0x82, 0xC8, 0x8C, 0x29, 0x83, 0x66, 0xF0, 0x4C, 0x87, 0x48, 0xD3, 0x3E, 0x8C, 0x92,
  0x0A, 0x0C,
  // "Ä" (U+00C4)
  0x18, 0x2B, 0x66, 0xC2, 0x01, 0x20, 0x12, 0x01, 0xA3, 0x82, 0x4E, 0xE4, 0x28, 0x28, 0xBB, 0x82,
  0x82, 0xC8, 0x8C, 0x29, 0x83, 0x66, 0xF0, 0x4C, 0x87, 0x48, 0xD3, 0x3E, 0x8C, 0x92, 0x0A, 0x0C,
  // "Å" (U+00C5)
  0x18, 0x11, 0xDD, 0x38, 0x21, 0xFE, 0x12, 0x01, 0xA3, 0x82, 0x4E, 0xE4, 0x28, 0x28, 0xBB, 0x82,
  0x82, 0xC8, 0x8C, 0x29, 0x83, 0x66, 0xF0, 0x4C, 0x87, 0x48, 0xD3, 0x3E, 0x8C, 0x92, 0x0A, 0x0C,
  // "Æ" (U+00C6)
  0x10, 0x4B, 0x89, 0x2A, 0x08, 0xBE, 0x72, 0x0B, 0x8E, 0x42, 0x89, 0x2E, 0x5E, 0xF8, 0x2F, 0x3E,
  0x71, 0x5B, 0x89, 0x44, 0x09, 0xC3, 0xE7, 0x2C, 0x80, 0xEF, 0xA0,
  // "Ç" (U+00C7)
  0x18, 0x94, 0x1B, 0xEE, 0x50, 0xDC, 0x46, 0x24, 0xF3, 0x30, 0x79, 0x40, 0x79, 0x48, 0x15, 0xF2,
  0x38, 0x92, 0x1E, 0xB4, 0x63, 0x03, 0xCF, 0xD3, 0x20, 0x40, 0x34, 0x03, 0x0E, 0x40, 0xC0, 0xA2,
  // "È" (U+00C8)
  0x10, 0x30, 0x75, 0x00, 0x97, 0x10, 0x3C, 0x89, 0x04, 0x3F, 0x63, 0x31, 0x3F, 0x33, 0x03, 0xC8,
  0x90, 0x23, 0xF5, 0x33, 0x03, 0xF3, 0x38, 0x53, 0xF6, 0x33, 0x13, 0xC0, 0x40,
  // "É" (U+00C9)
  0x30, 0x70, 0x43, 0x81, 0x7B, 0x17, 0x03, 0xC8, 0x90, 0x43, 0xF6, 0x33, 0x13, 0xF3, 0x30, 0x3C,
  0x89, 0x02, 0x3F, 0x53, 0x30, 0x3F, 0x33, 0x85, 0x3F, 0x63, 0x31, 0x3C, 0x04,
  // "Ê" (U+00CA)
  0x20, 0x60, 0x73, 0x82, 0x7A, 0x98, 0x70, 0x3C, 0x89, 0x04, 0x3F, 0x63, 0x31, 0x3F, 0x33, 0x03,
  0xC8, 0x90, 0x23, 0xF5, 0x33, 0x03, 0xF3, 0x38, 0x53, 0xF6, 0x33, 0x13, 0xC0, 0x40,
  // "Ë" (U+00CB)
  0x18, 0x2B, 0x66, 0xC2, 0x01, 0x28, 0x11, 0x03, 0xC8, 0x90, 0x43, 0xF6, 0x33, 0x13, 0xF3, 0x30,
  0x3C, 0x89, 0x02, 0x3F, 0x53, 0x30, 0x3F, 0x33, 0x85, 0x3F, 0x63, 0x31, 0x3C, 0x04,
  // "Ì" (U+00CC)
  0x10, 0x30, 0x75, 0x00, 0x97, 0x10, 0x1C, 0x84, 0x10, 0x3C, 0xC3, 0x30, 0x0A, 0x40, 0x0A, 0x40,
  0x0A, 0x40, 0x0A, 0x38, 0x42, 0xCB, 0x20, 0x1C, 0x01,
  // "Í" (U+00CD)
  0x30, 0x70, 0x43, 0x81, 0x7B, 0x17, 0x01, 0xC8, 0x41, 0x03, 0xCC, 0x33, 0x00, 0xA4, 0x00, 0xA4,
  0x00, 0xA4, 0x00, 0xA3, 0x84, 0x2C, 0xB2, 0x01, 0xC0, 0x10,
  // "Î" (U+00CE)
  0x20, 0x60, 0x73, 0x82, 0x7A, 0x98, 0x70, 0x1C, 0x84, 0x10, 0x3C, 0xC3, 0x30, 0x0A, 0x40, 0x0A,
  0x40, 0x0A, 0x40, 0x0A, 0x38, 0x42, 0xCB, 0x20, 0x1C, 0x01,
  // "Ï" (U+00CF)
  0x18, 0x2B, 0x66, 0xC2, 0x01, 0x28, 0x11, 0x01, 0xC8, 0x41, 0x03, 0xCC, 0x33, 0x00, 0xA4, 0x00,
  0xA4, 0x00, 0xA4, 0x00, 0xA3, 0x84, 0x2C, 0xB2, 0x01, 0xC0, 0x10,
  // "Ð" (U+00D0)
  0x08, 0xA8, 0x91, 0xC4, 0x08, 0xE4, 0x9F, 0x28, 0xD2, 0x82, 0xE8, 0x8D, 0x20, 0xC0, 0xAA, 0x89,
  0x7E, 0x0C, 0x9A, 0xE3, 0x0E, 0x78, 0xE4, 0xAF, 0x18, 0xA0, 0xD0, 0x41,
  // "Ñ" (U+00D1)
  0x18, 0x26, 0xC1, 0xB2, 0x82, 0xB5, 0xE8, 0x20, 0x14, 0x8D, 0x68, 0xF8, 0x0B, 0x88, 0xED, 0x0B,
  0x88, 0xBF, 0x2B, 0x88, 0xBB, 0x6B, 0x88, 0xB7, 0xBB, 0x88, 0xB2, 0xFB, 0x88, 0xB0, 0xDE, 0x88,
  0xB0, 0x9F, 0x80,
  // "Ò" (U+00D2)
  0x10, 0x30, 0x75, 0x00, 0x97, 0x28, 0x93, 0x7E, 0xE7, 0x03, 0xF7, 0x7F, 0x38, 0xE2, 0x82, 0xE8,
  0xAC, 0x28, 0x2C, 0xAA, 0xC2, 0x82, 0xCA, 0x8E, 0x28, 0x93, 0xE8, 0x3F, 0x77, 0xF3, 0x07, 0xEE,
  0x71,
  // "Ó" (U+00D3)
  0x30, 0x70, 0x43, 0x81, 0x7B, 0x17, 0x18, 0x93, 0x7E, 0xE7, 0x03, 0xF7, 0x7F, 0x38, 0xE2, 0x82,
  0xE8, 0xAC, 0x28, 0x2C, 0xAA, 0xC2, 0x82, 0xCA, 0x8E, 0x28, 0x93, 0xE8, 0x3F, 0x77, 0xF3, 0x07,
  0xEE, 0x71,
  // "Ô" (U+00D4)
  0x20, 0x60, 0x73, 0x82, 0x7A, 0x98, 0x71, 0x89, 0x37, 0xEE, 0x70, 0x3F, 0x77, 0xF3, 0x8E, 0x28,
  0x2E, 0x8A, 0xC2, 0x82, 0xCA, 0xAC, 0x28, 0x2C, 0xA8, 0xE2, 0x89, 0x3E, 0x83, 0xF7, 0x7F, 0x30,
  0x7E, 0xE7, 0x10,
  // "Õ" (U+00D5)
  0x18, 0x26, 0xC1, 0xB2, 0x82, 0xB5, 0xE8, 0x20, 0x15, 0x89, 0x37, 0xEE, 0x70, 0x3F, 0x77, 0xF3,
  0x8E, 0x28, 0x2E, 0x8A, 0xC2, 0x82, 0xCA, 0xAC, 0x28, 0x2C, 0xA8, 0xE2, 0x89, 0x3E, 0x83, 0xF7,
  0x7F, 0x30, 0x7E, 0xE7, 0x10,
  // "Ö" (U+00D6)
  0x18, 0x2B, 0x66, 0xC2, 0x01, 0x20, 0x12, 0x89, 0x37, 0xEE, 0x70, 0x3F, 0x77, 0xF3, 0x8E, 0x28,
  0x2E, 0x8A, 0xC2, 0x82, 0xCA, 0xAC, 0x28, 0x2C, 0xA8, 0xE2, 0x89, 0x3E, 0x83, 0xF7, 0x7F, 0x30,
  0x7E, 0xE7, 0x10,
  // "×" (U+00D7)
  0x07, 0x28, 0x94, 0x7B, 0xBB, 0xA1, 0xEE, 0x1B, 0xAB, 0xB6, 0x20, 0x60,
  // "Ø" (U+00D8)
  0x58, 0xE0, 0x10, 0x7E, 0xEB, 0x93, 0xF7, 0x8F, 0x48, 0xE0, 0x9F, 0x8A, 0xC3, 0xDC, 0xAA, 0xCC,
  0x4C, 0xA8, 0xFA, 0x0E, 0x84, 0xF8, 0x7F, 0x39, 0xBE, 0xE7, 0x02, 0x50,
  // "Ù" (U+00D9)
  0x10, 0x30, 0x75, 0x00, 0x97, 0x10, 0x80, 0xE2, 0x82, 0xE8, 0x8E, 0x28, 0x2E, 0x88, 0xE2, 0x82,
  0xE8, 0x8E, 0x28, 0x2E, 0x88, 0xE2, 0x82, 0xE8, 0x7E, 0x28, 0x93, 0xE7, 0x4F, 0x77, 0xF4, 0x08,
  0xEE, 0x81,
  // "Ú" (U+00DA)
  0x30, 0x70, 0x43, 0x81, 0x7B, 0x17, 0x08, 0x0E, 0x28, 0x2E, 0x88, 0xE2, 0x82, 0xE8, 0x8E, 0x28,
  0x2E, 0x88, 0xE2, 0x82, 0xE8, 0x8E, 0x28, 0x2E, 0x87, 0xE2, 0x89, 0x3E, 0x74, 0xF7, 0x7F, 0x40,
  0x8E, 0xE8, 0x10,
  // "Û" (U+00DB)
  0x20, 0x60, 0x73, 0x82, 0x7A, 0x98, 0x70, 0x80, 0xE2, 0x82, 0xE8, 0x8E, 0x28, 0x2E, 0x88, 0xE2,
  0x82, 0xE8, 0x8E, 0x28, 0x2E, 0x88, 0xE2, 0x82, 0xE8, 0x7E, 0x28, 0x93, 0xE7, 0x4F, 0x77, 0xF4,
  0x08, 0xEE, 0x81,
  // "Ü" (U+00DC)
  0x18, 0x2B, 0x66, 0xC2, 0x01, 0x28, 0x21, 0x08, 0xE2, 0x82, 0xE8, 0x8E, 0x28, 0x2E, 0x88, 0xE2,
  0x82, 0xE8, 0x8E, 0x28, 0x2E, 0x88, 0xE2, 0x82, 0xE8, 0x7E, 0x28, 0x93, 0xE7, 0x4F, 0x77, 0xF4,
  0x08, 0xEE, 0x81,
  // "Ý" (U+00DD)
  0x30, 0x70, 0x43, 0x81, 0x7B, 0x17, 0x09, 0x0E, 0x28, 0x93, 0xD9, 0x2F, 0x44, 0xF2, 0x0B, 0xA9,
  0xB2, 0x82, 0x5F, 0xE5, 0x30, 0x0D, 0x40, 0x0B, 0x40, 0x0B, 0x40, 0x0B, 0x20,
  // "Þ" (U+00DE)
  0x81, 0x3F, 0x33, 0x81, 0x3F, 0x33, 0x03, 0xB8, 0x95, 0xB1, 0x3F, 0x54, 0xF7, 0x3F, 0x32, 0xE7,
  0x3B, 0x84, 0xD2, 0x3F, 0x52, 0x28, 0x13, 0xF3, 0x30,
  // "ß" (U+00DF)
  0x18, 0xD5, 0x9E, 0xD7, 0x05, 0xF6, 0x9F, 0x17, 0xF0, 0x9D, 0x07, 0xE4, 0xF2, 0x07, 0xE3, 0xF9,
  0x07, 0xE0, 0x4E, 0x87, 0xE4, 0x4D, 0xA7, 0xE7, 0xFD, 0x30,
  // "à" (U+00E0)
  0x10, 0x30, 0x75, 0x00, 0x97, 0x28, 0x2B, 0xEE, 0x82, 0x85, 0x55, 0x6F, 0x30, 0xBB, 0x8A, 0x15,
  0x6F, 0x53, 0xF5, 0x6F, 0x58, 0xF5, 0x1C, 0xE8, 0xD5,
  // "á" (U+00E1)
  0x30, 0x70, 0x43, 0x81, 0x7B, 0x17, 0x18, 0x2B, 0xEE, 0x82, 0x85, 0x55, 0x6F, 0x30, 0xBB, 0x8A,
  0x15, 0x6F, 0x53, 0xF5, 0x6F, 0x58, 0xF5, 0x1C, 0xE8, 0xD5,
  // "â" (U+00E2)
  0x20, 0x60, 0x73, 0x82, 0x7A, 0x98, 0x71, 0x82, 0xBE, 0xE8, 0x28, 0x55, 0x56, 0xF3, 0x0B, 0xB8,
  0xA1, 0x56, 0xF5, 0x3F, 0x56, 0xF5, 0x8F, 0x51, 0xCE, 0x8D, 0x50,
  // "ã" (U+00E3)
  0x18, 0x26, 0xC1, 0xB2, 0x82, 0xB5, 0xE8, 0x20, 0x15, 0x82, 0xBE, 0xE8, 0x28, 0x55, 0x56, 0xF3,
  0x0B, 0xB8, 0xA1, 0x56, 0xF5, 0x3F, 0x56, 0xF5, 0x8F, 0x51, 0xCE, 0x8D, 0x50,
  // "ä" (U+00E4)
  0x18, 0x2B, 0x66, 0xC2, 0x01, 0x20, 0x12, 0x82, 0xBE, 0xE8, 0x28, 0x55, 0x56, 0xF3, 0x0B, 0xB8,
  0xA1, 0x56, 0xF5, 0x3F, 0x56, 0xF5, 0x8F, 0x51, 0xCE, 0x8D, 0x50,
  // "å" (U+00E5)
  0x18, 0x11, 0xDD, 0x38, 0x21, 0xFE, 0x12, 0x0B, 0xA0, 0x82, 0x85, 0x55, 0x6F, 0x30, 0xBB, 0x8A,
  0x15, 0x6F, 0x53, 0xF5, 0x6F, 0x58, 0xF5, 0x1C, 0xE8, 0xD5,
  // "æ" (U+00E6)
  0x89, 0x35, 0xEC, 0xBE, 0x41, 0x4C, 0xC9, 0xB6, 0xC8, 0xA1, 0xDD, 0xAA, 0xB3, 0x3D, 0x9C, 0xE5,
  0x47, 0xE7, 0x9E, 0x80,
  // "ç" (U+00E7)
  0x18, 0x94, 0x4C, 0xFD, 0x10, 0xEB, 0x46, 0x03, 0xF3, 0x38, 0x13, 0xF3, 0x38, 0x31, 0xEB, 0x47,
  0x28, 0x25, 0xDF, 0xC3, 0x04, 0x03, 0x40, 0x30, 0xE4, 0x0C, 0x0A, 0x20,
  // "è" (U+00E8)
  0x10, 0x30, 0x75, 0x00, 0x97, 0x28, 0x92, 0x6E, 0xE8, 0x03, 0xF7, 0x6E, 0x47, 0xC8, 0xA1, 0x76,
  0xF3, 0x33, 0x12, 0xFA, 0x46, 0x30, 0x5C, 0xFD, 0x30,
  // "é" (U+00E9)
  0x30, 0x70, 0x43, 0x81, 0x7B, 0x17, 0x18, 0x92, 0x6E, 0xE8, 0x03, 0xF7, 0x6E, 0x47, 0xC8, 0xA1,
  0x76, 0xF3, 0x33, 0x12, 0xFA, 0x46, 0x30, 0x5C, 0xFD, 0x30,
  // "ê" (U+00EA)
  0x20, 0x60, 0x73, 0x82, 0x7A, 0x98, 0x71, 0x89, 0x26, 0xEE, 0x80, 0x3F, 0x76, 0xE4, 0x7C, 0x8A,
  0x17, 0x6F, 0x33, 0x31, 0x2F, 0xA4, 0x63, 0x05, 0xCF, 0xD3,
  // "ë" (U+00EB)
  0x18, 0x2B, 0x66, 0xC2, 0x01, 0x20, 0x12, 0x89, 0x26, 0xEE, 0x80, 0x3F, 0x76, 0xE4, 0x7C, 0x8A,
  0x17, 0x6F, 0x33, 0x31, 0x2F, 0xA4, 0x63, 0x05, 0xCF, 0xD3,
  // "ì" (U+00EC)
  0x10, 0x30, 0x75, 0x00, 0x97, 0x10, 0x1A, 0x0D, 0x38, 0x13, 0xAD, 0x40, 0x90, 0xD4, 0x09, 0x0D,
  0x38, 0x42, 0xAE, 0x20, 0x6C, 0x07,
  // "í" (U+00ED)
  0x30, 0x70, 0x43, 0x81, 0x7B, 0x17, 0x01, 0xA0, 0xD3, 0x81, 0x3A, 0xD4, 0x09, 0x0D, 0x40, 0x90,
  0xD3, 0x84, 0x2A, 0xE2, 0x06, 0xC0, 0x70,
  // "î" (U+00EE)
  0x20, 0x60, 0x73, 0x82, 0x7A, 0x98, 0x70, 0x1A, 0x0D, 0x38, 0x13, 0xAD, 0x40, 0x90, 0xD4, 0x09,
  0x0D, 0x38, 0x42, 0xAE, 0x20, 0x6C, 0x07,
  // "ï" (U+00EF)
  0x18, 0x2B, 0x66, 0xC2, 0x01, 0x28, 0x11, 0x01, 0xA0, 0xD3, 0x81, 0x3A, 0xD4, 0x09, 0x0D, 0x40,
  0x90, 0xD3, 0x84, 0x2A, 0xE2, 0x06, 0xC0, 0x70,
  // "ð" (U+00F0)
  0x18, 0x22, 0xC7, 0xA2, 0x82, 0x1E, 0xF5, 0x28, 0x22, 0x57, 0xE2, 0x89, 0x3A, 0xFD, 0xF5, 0x6F,
  0x55, 0xF8, 0x8E, 0x28, 0x93, 0xD8, 0x6F, 0x66, 0xF4, 0x09, 0xEE, 0x71,
  // "ñ" (U+00F1)
  0x18, 0x26, 0xC1, 0xB2, 0x82, 0xB5, 0xE8, 0x20, 0x14, 0x8A, 0x17, 0xC9, 0xEB, 0x07, 0xF9, 0x6F,
  0x67, 0xF1, 0x0F, 0x77, 0x92, 0x81, 0xE7, 0x79, 0x28, 0x1E, 0x77, 0x92, 0x0E, 0x07,
  // "ò" (U+00F2)
  0x10, 0x30, 0x75, 0x00, 0x97, 0x28, 0x93, 0x7E, 0xE7, 0x04, 0xF7, 0x7F, 0x48, 0xE2, 0x82, 0xE8,
  0x8E, 0x28, 0x93, 0xE8, 0x4F, 0x77, 0xF4, 0x08, 0xEE, 0x71,
  // "ó" (U+00F3)
  0x30, 0x70, 0x43, 0x81, 0x7B, 0x17, 0x18, 0x93, 0x7E, 0xE7, 0x04, 0xF7, 0x7F, 0x48, 0xE2, 0x82,
  0xE8, 0x8E, 0x28, 0x93, 0xE8, 0x4F, 0x77, 0xF4, 0x08, 0xEE, 0x71,
  // "ô" (U+00F4)
  0x20, 0x60, 0x73, 0x82, 0x7A, 0x98, 0x71, 0x89, 0x37, 0xEE, 0x70, 0x4F, 0x77, 0xF4, 0x8E, 0x28,
  0x2E, 0x88, 0xE2, 0x89, 0x3E, 0x84, 0xF7, 0x7F, 0x40, 0x8E, 0xE7, 0x10,
  // "õ" (U+00F5)
  0x18, 0x26, 0xC1, 0xB2, 0x82, 0xB5, 0xE8, 0x20, 0x15, 0x89, 0x37, 0xEE, 0x70, 0x4F, 0x77, 0xF4,
  0x8E, 0x28, 0x2E, 0x88, 0xE2, 0x89, 0x3E, 0x84, 0xF7, 0x7F, 0x40, 0x8E, 0xE7, 0x10,
  // "ö" (U+00F6)
  0x18, 0x2B, 0x66, 0xC2, 0x01, 0x20, 0x12, 0x89, 0x37, 0xEE, 0x70, 0x4F, 0x77, 0xF4, 0x8E, 0x28,
  0x2E, 0x88, 0xE2, 0x89, 0x3E, 0x84, 0xF7, 0x7F, 0x40, 0x8E, 0xE7, 0x10,
  // "÷" (U+00F7)
  0x20, 0x08, 0x40, 0x01, 0x20, 0x4C, 0x85, 0x41, 0x33, 0x33, 0x12, 0x00, 0x84, 0x00, 0x12,
  // "ø" (U+00F8)
  0x18, 0xC0, 0x7E, 0xEE, 0x14, 0xF7, 0xBF, 0x48, 0xE2, 0xDE, 0x88, 0xEC, 0x4E, 0x84, 0xFC, 0x7F,
  0x41, 0xEE, 0xE7, 0x20, 0x14,
  // "ù" (U+00F9)
  0x10, 0x30, 0x75, 0x00, 0x97, 0x10, 0x70, 0xE2, 0x98, 0x17, 0x7E, 0x29, 0x81, 0x77, 0xE2, 0x98,
  0xA1, 0x77, 0xE0, 0x1F, 0x76, 0xF6, 0x9F, 0x70, 0xBE, 0x9C, 0x70,
  // "ú" (U+00FA)
  0x30, 0x70, 0x43, 0x81, 0x7B, 0x17, 0x07, 0x0E, 0x29, 0x81, 0x77, 0xE2, 0x98, 0x17, 0x7E, 0x29,
  0x8A, 0x17, 0x7E, 0x01, 0xF7, 0x6F, 0x69, 0xF7, 0x0B, 0xE9, 0xC7,
  // "û" (U+00FB)
  0x20, 0x60, 0x73, 0x82, 0x7A, 0x98, 0x70, 0x70, 0xE2, 0x98, 0x17, 0x7E, 0x29, 0x81, 0x77, 0xE2,
  0x98, 0xA1, 0x77, 0xE0, 0x1F, 0x76, 0xF6, 0x9F, 0x70, 0xBE, 0x9C, 0x70,
  // "ü" (U+00FC)
  0x18, 0x2B, 0x66, 0xC2, 0x01, 0x28, 0x21, 0x07, 0xE2, 0x98, 0x17, 0x7E, 0x29, 0x81, 0x77, 0xE2,
  0x98, 0xA1, 0x77, 0xE0, 0x1F, 0x76, 0xF6, 0x9F, 0x70, 0xBE, 0x9C, 0x70,
  // "ý" (U+00FD)
  0x30, 0x70, 0x43, 0x81, 0x7B, 0x17, 0x09, 0x0E, 0x28, 0x93, 0xD9, 0x4F, 0x32, 0xF4, 0x0E, 0x76,
  0xE2, 0x82, 0x9C, 0xAA, 0x28, 0x24, 0xFE, 0x53, 0x0E, 0x94, 0x00, 0xB2, 0x82, 0x28, 0xF4, 0x28,
  0x16, 0xE8, 0x30,
  // "þ" (U+00FE)
  0x07, 0x94, 0x07, 0x94, 0x89, 0x37, 0xE9, 0xEA, 0x07, 0xF8, 0x7F, 0x57, 0x92, 0x81, 0xE8, 0x79,
  0x28, 0x95, 0xE8, 0x7F, 0x87, 0xF5, 0x7E, 0xAE, 0x90, 0x79, 0x40, 0x79, 0x40, 0x79, 0x40,
  // "ÿ" (U+00FF)
  0x18, 0x2B, 0x66, 0xC2, 0x01, 0x28, 0x21, 0x09, 0xE2, 0x89, 0x3D, 0x94, 0xF3, 0x2F, 0x40, 0xE7,
  0x6E, 0x28, 0x29, 0xCA, 0xA2, 0x82, 0x4F, 0xE5, 0x30, 0xE9, 0x40, 0x0B, 0x28, 0x22, 0x8F, 0x42,
  0x81, 0x6E, 0x83,
  // "Ā" (U+0100)
  0x10, 0x8A, 0x08, 0x28, 0x21, 0x33, 0x12, 0x01, 0xA3, 0x82, 0x4E, 0xE4, 0x28, 0x28, 0xBB, 0x82,
  0x82, 0xC8, 0x8C, 0x29, 0x83, 0x66, 0xF0, 0x4C, 0x87, 0x48, 0xD3, 0x3E, 0x8C, 0x92, 0x0A, 0x0C,
  // "ā" (U+0101)
  0x10, 0x8A, 0x08, 0x28, 0x21, 0x33, 0x12, 0x82, 0xBE, 0xE8, 0x28, 0x55, 0x56, 0xF3, 0x0B, 0xB8,
  0xA1, 0x56, 0xF5, 0x3F, 0x56, 0xF5, 0x8F, 0x51, 0xCE, 0x8D, 0x50,
  // "Ă" (U+0102)
  0x18, 0x27, 0x54, 0x72, 0x04, 0xA0, 0x43, 0x00, 0x13, 0x01, 0xA3, 0x82, 0x4E, 0xE4, 0x28, 0x28,
  0xBB, 0x82, 0x82, 0xC8, 0x8C, 0x29, 0x83, 0x66, 0xF0, 0x4C, 0x87, 0x48, 0xD3, 0x3E, 0x8C, 0x92,
  0x0A, 0x0C,
  // "ă" (U+0103)
  0x18, 0x27, 0x54, 0x72, 0x04, 0xA0, 0x43, 0x00, 0x13, 0x82, 0xBE, 0xE8, 0x28, 0x55, 0x56, 0xF3,
  0x0B, 0xB8, 0xA1, 0x56, 0xF5, 0x3F, 0x56, 0xF5, 0x8F, 0x51, 0xCE, 0x8D, 0x50,
  // "Ą" (U+0104)
  0x10, 0x1A, 0x38, 0x24, 0xEE, 0x42, 0x82, 0x8B, 0xB8, 0x28, 0x2C, 0x88, 0xC2, 0x98, 0x36, 0x6F,
  0x04, 0xC8, 0x74, 0x8D, 0x33, 0xE8, 0xC9, 0x20, 0xD9, 0x40, 0xB0, 0x34, 0x0B, 0x95, 0x02,
  // "ą" (U+0105)
  0x18, 0x2B, 0xEE, 0x82, 0x85, 0x55, 0x6F, 0x30, 0xBB, 0x8A, 0x15, 0x6F, 0x53, 0xF5, 0x6F, 0x58,
  0xF5, 0x1C, 0xEB, 0xF5, 0x30, 0xB0, 0x34, 0x0B, 0x95, 0x02, 0x10,
  // "Ć" (U+0106)
  0x40, 0x70, 0x43, 0x81, 0x7B, 0x17, 0x89, 0x41, 0xBE, 0xE5, 0x0D, 0xC4, 0x62, 0x4F, 0x33, 0x07,
  0x94, 0x07, 0x94, 0x81, 0x5F, 0x23, 0x89, 0x21, 0xEB, 0x46, 0x30, 0x3C, 0xFD, 0x30,
  // "ć" (U+0107)
  0x30, 0x70, 0x43, 0x81, 0x7B, 0x17, 0x18, 0x94, 0x4C, 0xFD, 0x10, 0xEB, 0x46, 0x03, 0xF3, 0x38,
  0x13, 0xF3, 0x38, 0x31, 0xEB, 0x47, 0x28, 0x25, 0xDF, 0xC1,
  // "Ĉ" (U+0108)
  0x30, 0x60, 0x73, 0x82, 0x7A, 0x98, 0x78, 0x94, 0x1B, 0xEE, 0x50, 0xDC, 0x46, 0x24, 0xF3, 0x30,
  0x79, 0x40, 0x79, 0x48, 0x15, 0xF2, 0x38, 0x92, 0x1E, 0xB4, 0x63, 0x03, 0xCF, 0xD3,
  // "ĉ" (U+0109)
  0x20, 0x60, 0x73, 0x82, 0x7A, 0x98, 0x71, 0x89, 0x44, 0xCF, 0xD1, 0x0E, 0xB4, 0x60, 0x3F, 0x33,
  0x81, 0x3F, 0x33, 0x83, 0x1E, 0xB4, 0x72, 0x82, 0x5D, 0xFC, 0x10,
  // "Ċ" (U+010A)
  0x30, 0x0B, 0x40, 0x01, 0x28, 0x94, 0x1B, 0xEE, 0x50, 0xDC, 0x46, 0x24, 0xF3, 0x30, 0x79, 0x40,
  0x79, 0x48, 0x15, 0xF2, 0x38, 0x92, 0x1E, 0xB4, 0x63, 0x03, 0xCF, 0xD3,
  // "ċ" (U+010B)
  0x20, 0x0B, 0x40, 0x01, 0x38, 0x94, 0x4C, 0xFD, 0x10, 0xEB, 0x46, 0x03, 0xF3, 0x38, 0x13, 0xF3,
  0x38, 0x31, 0xEB, 0x47, 0x28, 0x25, 0xDF, 0xC1,
  // "Č" (U+010C)
  0x28, 0x25, 0x33, 0x52, 0x82, 0x2E, 0xE2, 0x78, 0x94, 0x1B, 0xEE, 0x50, 0xDC, 0x46, 0x24, 0xF3,
  0x30, 0x79, 0x40, 0x79, 0x48, 0x15, 0xF2, 0x38, 0x92, 0x1E, 0xB4, 0x63, 0x03, 0xCF, 0xD3,
  // "č" (U+010D)
  0x18, 0x25, 0x33, 0x52, 0x82, 0x2E, 0xE2, 0x71, 0x89, 0x44, 0xCF, 0xD1, 0x0E, 0xB4, 0x60, 0x3F,
  0x33, 0x81, 0x3F, 0x33, 0x83, 0x1E, 0xB4, 0x72, 0x82, 0x5D, 0xFC, 0x10,
  // "Ď" (U+010E)
  0x18, 0x25, 0x33, 0x52, 0x82, 0x2E, 0xE2, 0x70, 0x8A, 0x89, 0x1C, 0x40, 0x8E, 0x49, 0xF2, 0x8D,
  0x28, 0x2E, 0x88, 0xD2, 0x82, 0xCA, 0x8D, 0x28, 0x2C, 0x98, 0xD2, 0x87, 0xE7, 0x8E, 0x4A, 0xF1,
  0x8A, 0x0D, 0x04, 0x10,
  // "ď" (U+010F)
  0x38, 0x27, 0xEA, 0x83, 0x87, 0x7E, 0x30, 0x1C, 0xEA, 0xE2, 0x83, 0x7F, 0x5B, 0xE2, 0x83, 0x9C,
  0x06, 0xE2, 0x83, 0xAC, 0x06, 0xE2, 0x83, 0x7F, 0x5B, 0xE2, 0x83, 0x1C, 0xD8, 0xE2,
  // "Đ" (U+0110)
  0x08, 0xA8, 0x91, 0xC4, 0x08, 0xE4, 0x9F, 0x28, 0xD2, 0x82, 0xE8, 0x8D, 0x20, 0xC0, 0xAA, 0x89,
  0x7E, 0x0C, 0x9A, 0xE3, 0x0E, 0x78, 0xE4, 0xAF, 0x18, 0xA0, 0xD0, 0x41,
  // "đ" (U+0111)
  0x49, 0x07, 0x20, 0x6B, 0x18, 0x93, 0xAE, 0xAE, 0x75, 0xF7, 0x7F, 0x78, 0xE2, 0x82, 0xE7, 0x8E,
  0x28, 0x94, 0xD7, 0x5F, 0x76, 0xF7, 0x0B, 0xE9, 0xD7,
  // "Ē" (U+0112)
  0x10, 0x8A, 0x08, 0x28, 0x41, 0x33, 0x10, 0x3C, 0x89, 0x04, 0x3F, 0x63, 0x31, 0x3F, 0x33, 0x03,
  0xC8, 0x90, 0x23, 0xF5, 0x33, 0x03, 0xF3, 0x38, 0x53, 0xF6, 0x33, 0x13, 0xC0, 0x40,
  // "ē" (U+0113)
  0x10, 0x8A, 0x08, 0x28, 0x21, 0x33, 0x12, 0x89, 0x26, 0xEE, 0x80, 0x3F, 0x76, 0xE4, 0x7C, 0x8A,
  0x17, 0x6F, 0x33, 0x31, 0x2F, 0xA4, 0x63, 0x05, 0xCF, 0xD3,
  // "Ĕ" (U+0114)
  0x18, 0x27, 0x54, 0x72, 0x04, 0xA0, 0x43, 0x00, 0x12, 0x03, 0xC8, 0x90, 0x43, 0xF6, 0x33, 0x13,
  0xF3, 0x30, 0x3C, 0x89, 0x02, 0x3F, 0x53, 0x30, 0x3F, 0x33, 0x85, 0x3F, 0x63, 0x31, 0x3C, 0x04,
  // "ĕ" (U+0115)
  0x18, 0x27, 0x54, 0x72, 0x04, 0xA0, 0x43, 0x00, 0x13, 0x89, 0x26, 0xEE, 0x80, 0x3F, 0x76, 0xE4,
  0x7C, 0x8A, 0x17, 0x6F, 0x33, 0x31, 0x2F, 0xA4, 0x63, 0x05, 0xCF, 0xD3,
  // "Ė" (U+0116)
  0x20, 0x0B, 0x40, 0x01, 0x20, 0x3C, 0x89, 0x04, 0x3F, 0x63, 0x31, 0x3F, 0x33, 0x03, 0xC8, 0x90,
  0x23, 0xF5, 0x33, 0x03, 0xF3, 0x38, 0x53, 0xF6, 0x33, 0x13, 0xC0, 0x40,
  // "ė" (U+0117)
  0x20, 0x0B, 0x40, 0x01, 0x38, 0x92, 0x6E, 0xE8, 0x03, 0xF7, 0x6E, 0x47, 0xC8, 0xA1, 0x76, 0xF3,
  0x33, 0x12, 0xFA, 0x46, 0x30, 0x5C, 0xFD, 0x30,
  // "Ę" (U+0118)
  0x03, 0xC8, 0x90, 0x43, 0xF6, 0x33, 0x13, 0xF3, 0x30, 0x3C, 0x89, 0x02, 0x3F, 0x53, 0x30, 0x3F,
  0x33, 0x85, 0x3F, 0x63, 0x31, 0x3C, 0x04, 0x30, 0xB0, 0x34, 0x0B, 0x95, 0x02, 0x10,
  // "ę" (U+0119)
  0x18, 0xA0, 0x6E, 0xE6, 0x03, 0xF9, 0x7F, 0x27, 0xF1, 0x0D, 0x66, 0xC8, 0x90, 0x72, 0xF9, 0x78,
  0x30, 0x5C, 0xA0, 0x43, 0x06, 0x09, 0x40, 0xA0, 0x84, 0x81, 0x5E, 0x20,
  // "Ě" (U+011A)
  0x18, 0x25, 0x33, 0x52, 0x82, 0x2E, 0xE2, 0x70, 0x3C, 0x89, 0x04, 0x3F, 0x63, 0x31, 0x3F, 0x33,
  0x03, 0xC8, 0x90, 0x23, 0xF5, 0x33, 0x03, 0xF3, 0x38, 0x53, 0xF6, 0x33, 0x13, 0xC0, 0x40,
  // "ě" (U+011B)
  0x18, 0x25, 0x33, 0x52, 0x82, 0x2E, 0xE2, 0x71, 0x89, 0x26, 0xEE, 0x80, 0x3F, 0x76, 0xE4, 0x7C,
  0x8A, 0x17, 0x6F, 0x33, 0x31, 0x2F, 0xA4, 0x63, 0x05, 0xCF, 0xD3,
  // "Ĝ" (U+011C)
  0x20, 0x60, 0x73, 0x82, 0x7A, 0x98, 0x71, 0x89, 0x34, 0xCF, 0xD4, 0x1F, 0xB4, 0x71, 0x7E, 0x40,
  0x90, 0xC4, 0x8A, 0x6A, 0xC0, 0xBF, 0x88, 0xE0, 0x2C, 0x82, 0xFA, 0x4D, 0x80, 0x5D, 0xFD, 0x50,
  // "ĝ" (U+011D)
  0x20, 0x60, 0x73, 0x82, 0x7A, 0x98, 0x71, 0x89, 0x3A, 0xE9, 0xD7, 0x5F, 0x77, 0xF7, 0x8E, 0x28,
  0x2E, 0x78, 0xE2, 0x89, 0x4E, 0x75, 0xF7, 0x7F, 0x70, 0xAE, 0x9F, 0x74, 0x98, 0x92, 0x62, 0x84,
  0x8F, 0x22, 0xDF, 0xD6, 0x10,
  // "Ğ" (U+011E)
  0x18, 0x27, 0x54, 0x72, 0x04, 0xA0, 0x43, 0x00, 0x13, 0x89, 0x34, 0xCF, 0xD4, 0x1F, 0xB4, 0x71,
  0x7E, 0x40, 0x90, 0xC4, 0x8A, 0x6A, 0xC0, 0xBF, 0x88, 0xE0, 0x2C, 0x82, 0xFA, 0x4D, 0x80, 0x5D,
  0xFD, 0x50,
  // "ğ" (U+011F)
  0x18, 0x27, 0x54, 0x72, 0x04, 0xA0, 0x43, 0x00, 0x13, 0x89, 0x3A, 0xE9, 0xD7, 0x5F, 0x77, 0xF7,
  0x8E, 0x28, 0x2E, 0x78, 0xE2, 0x89, 0x4E, 0x75, 0xF7, 0x7F, 0x70, 0xAE, 0x9F, 0x74, 0x98, 0x92,
  0x62, 0x84, 0x8F, 0x22, 0xDF, 0xD6, 0x10,
  // "Ġ" (U+0120)
  0x20, 0x0B, 0x40, 0x01, 0x38, 0x93, 0x4C, 0xFD, 0x41, 0xFB, 0x47, 0x17, 0xE4, 0x09, 0x0C, 0x48,
  0xA6, 0xAC, 0x0B, 0xF8, 0x8E, 0x02, 0xC8, 0x2F, 0xA4, 0xD8, 0x05, 0xDF, 0xD5,
  // "ġ" (U+0121)
  0x20, 0x0B, 0x40, 0x01, 0x38, 0x93, 0xAE, 0x9D, 0x75, 0xF7, 0x7F, 0x78, 0xE2, 0x82, 0xE7, 0x8E,
  0x28, 0x94, 0xE7, 0x5F, 0x77, 0xF7, 0x0A, 0xE9, 0xF7, 0x49, 0x89, 0x26, 0x28, 0x48, 0xF2, 0x2D,
  0xFD, 0x61,
  // "Ģ" (U+0122)
  0x18, 0x93, 0x4C, 0xFD, 0x41, 0xFB, 0x47, 0x17, 0xE4, 0x09, 0x0C, 0x48, 0xA6, 0xAC, 0x0B, 0xF8,
  0x8E, 0x02, 0xC8, 0x2F, 0xA4, 0xD8, 0x05, 0xDF, 0xD5, 0x71, 0x0C, 0x05, 0x40, 0x33,
  // "ģ" (U+0123)
  0x20, 0x50, 0xA4, 0x03, 0x02, 0x38, 0x93, 0xAE, 0x9D, 0x75, 0xF7, 0x7F, 0x78, 0xE2, 0x82, 0xE7,
  0x8E, 0x28, 0x94, 0xE7, 0x5F, 0x77, 0xF7, 0x0A, 0xE9, 0xF7, 0x49, 0x89, 0x26, 0x28, 0x48, 0xF2,
  0x2D, 0xFD, 0x61,
  // "Ĥ" (U+0124)
  0x20, 0x60, 0x73, 0x82, 0x7A, 0x98, 0x70, 0x80, 0xE2, 0x82, 0xE8, 0x8E, 0x28, 0x2E, 0x88, 0xE2,
  0x81, 0xE8, 0x8C, 0x87, 0x88, 0xE3, 0x3E, 0x88, 0xE2, 0x82, 0xE8, 0x8E, 0x28, 0x2E, 0x88, 0xE2,
  0x0E, 0x08,
  // "ĥ" (U+0125)
  0x10, 0x60, 0x74, 0x82, 0x7A, 0x98, 0x74, 0x07, 0x95, 0x07, 0x95, 0x83, 0x7F, 0x9E, 0xB2, 0x89,
  0x57, 0xF8, 0x6F, 0x60, 0x7F, 0x10, 0xF7, 0x07, 0x92, 0x82, 0xE7, 0x07, 0x92, 0x82, 0xE7, 0x07,
  0x92, 0x0E, 0x07,
  // "Ħ" (U+0126)
  0x07, 0x92, 0x90, 0x7E, 0x85, 0x8F, 0x44, 0xF8, 0x6C, 0x86, 0x66, 0xF3, 0x3F, 0x66, 0x92, 0x90,
  0x06, 0x92, 0x90, 0x06, 0x92, 0x90, 0x60,
  // "ħ" (U+0127)
  0x07, 0x94, 0xB0, 0x72, 0x8A, 0x17, 0xF8, 0xEB, 0x07, 0xF8, 0x6F, 0x67, 0xF1, 0x0F, 0x77, 0x92,
  0x81, 0xE7, 0x79, 0x28, 0x1E, 0x77, 0x92, 0x0E, 0x07,
  // "Ĩ" (U+0128)
  0x18, 0x26, 0xC1, 0xB2, 0x82, 0xB5, 0xE8, 0x20, 0x14, 0x01, 0xC8, 0x41, 0x03, 0xCC, 0x33, 0x00,
  0xA4, 0x00, 0xA4, 0x00, 0xA4, 0x00, 0xA3, 0x84, 0x2C, 0xB2, 0x01, 0xC0, 0x10,
  // "ĩ" (U+0129)
  0x18, 0x26, 0xC1, 0xB2, 0x82, 0xB5, 0xE8, 0x20, 0x14, 0x01, 0xA0, 0xD3, 0x81, 0x3A, 0xD4, 0x09,
  0x0D, 0x40, 0x90, 0xD3, 0x84, 0x2A, 0xE2, 0x06, 0xC0, 0x70,
  // "Ī" (U+012A)
  0x10, 0x8A, 0x08, 0x28, 0x41, 0x33, 0x10, 0x1C, 0x84, 0x10, 0x3C, 0xC3, 0x30, 0x0A, 0x40, 0x0A,
  0x40, 0x0A, 0x40, 0x0A, 0x38, 0x42, 0xCB, 0x20, 0x1C, 0x01,
  // "ī" (U+012B)
  0x10, 0x8A, 0x08, 0x28, 0x41, 0x33, 0x10, 0x1A, 0x0D, 0x38, 0x13, 0xAD, 0x40, 0x90, 0xD4, 0x09,
  0x0D, 0x38, 0x42, 0xAE, 0x20, 0x6C, 0x07,
  // "Ĭ" (U+012C)
  0x18, 0x27, 0x54, 0x72, 0x04, 0xA0, 0x43, 0x00, 0x12, 0x01, 0xC8, 0x41, 0x03, 0xCC, 0x33, 0x00,
  0xA4, 0x00, 0xA4, 0x00, 0xA4, 0x00, 0xA3, 0x84, 0x2C, 0xB2, 0x01, 0xC0, 0x10,
  // "ĭ" (U+012D)
  0x18, 0x27, 0x54, 0x72, 0x04, 0xA0, 0x43, 0x00, 0x12, 0x01, 0xA0, 0xD3, 0x81, 0x3A, 0xD4, 0x09,
  0x0D, 0x40, 0x90, 0xD3, 0x84, 0x2A, 0xE2, 0x06, 0xC0, 0x70,
  // "Į" (U+012E)
  0x01, 0xC8, 0x41, 0x03, 0xCC, 0x33, 0x00, 0xA4, 0x00, 0xA4, 0x00, 0xA4, 0x00, 0xA3, 0x84, 0x2C,
  0xB2, 0x01, 0xC0, 0x13, 0x0B, 0x03, 0x40, 0xB9, 0x50, 0x21,
  // "į" (U+012F)
  0x20, 0x80, 0xD4, 0x01, 0x02, 0x20, 0x1A, 0x0D, 0x38, 0x13, 0xAD, 0x40, 0x90, 0xD4, 0x09, 0x0D,
  0x38, 0x42, 0xAE, 0x20, 0x6C, 0x07, 0x30, 0xB0, 0x34, 0x0B, 0x95, 0x02, 0x10,
  // "İ" (U+0130)
  0x20, 0x0B, 0x40, 0x01, 0x20, 0x1C, 0x84, 0x10, 0x3C, 0xC3, 0x30, 0x0A, 0x40, 0x0A, 0x40, 0x0A,
  0x40, 0x0A, 0x38, 0x42, 0xCB, 0x20, 0x1C, 0x01,
  // "ı" (U+0131)
  0x01, 0xA0, 0xD3, 0x81, 0x3A, 0xD4, 0x09, 0x0D, 0x40, 0x90, 0xD3, 0x84, 0x2A, 0xE2, 0x06, 0xC0,
  0x70,
  // "Ĳ" (U+0132)
  0x8B, 0x42, 0xF3, 0x4F, 0x22, 0xF3, 0x4F, 0x22, 0xF3, 0x4F, 0x22, 0xF3, 0x4F, 0x22, 0xF3, 0x4F,
  0x23, 0x89, 0x44, 0xF1, 0x17, 0x5B, 0xE0, 0x1E, 0xFC, 0x41,
  // "ĳ" (U+0133)
  0x86, 0x1E, 0x55, 0xE1, 0x02, 0x28, 0xC4, 0x20, 0x1F, 0x55, 0xF1, 0x1F, 0x55, 0xF1, 0x1F, 0x55,
  0xF1, 0x1F, 0x55, 0xF1, 0x1F, 0x55, 0xF1, 0x1F, 0x55, 0xF1, 0x38, 0x66, 0xF1, 0x06, 0x6C, 0xE2,
  0x82, 0xAF, 0xD4, 0x10,
  // "Ĵ" (U+0134)
  0x30, 0x60, 0x73, 0x82, 0x7A, 0x98, 0x72, 0x08, 0x0E, 0x40, 0x80, 0xE4, 0x08, 0x0E, 0x40, 0x80,
  0xE4, 0x08, 0x0E, 0x48, 0x94, 0x8D, 0x01, 0x65, 0xDA, 0x02, 0xEE, 0xB2, 0x10,
  // "ĵ" (U+0135)
  0x20, 0x60, 0x72, 0x82, 0x7A, 0x98, 0x60, 0xAA, 0x84, 0x40, 0x27, 0xF4, 0x28, 0x12, 0xF4, 0x28,
  0x12, 0xF4, 0x28, 0x12, 0xF4, 0x28, 0x12, 0xF4, 0x28, 0x92, 0x3F, 0x44, 0x6A, 0xF1, 0x7F, 0xE7,
  0x10,
  // "Ķ" (U+0136)
  0x8A, 0x48, 0xD0, 0x3F, 0x58, 0xD0, 0xCB, 0x08, 0xD6, 0xE2, 0x08, 0xED, 0x82, 0x08, 0xA0, 0xD2,
  0x8A, 0x08, 0xE3, 0xF5, 0x08, 0xD0, 0xBC, 0x08, 0xD0, 0x3F, 0x57, 0x10, 0xC0, 0x54, 0x03, 0x30,
  // "ķ" (U+0137)
  0x06, 0x94, 0x06, 0x94, 0x89, 0x66, 0xF0, 0x5F, 0x56, 0xF3, 0xE8, 0x06, 0xFC, 0xD2, 0x8A, 0x06,
  0xFC, 0xF4, 0x06, 0xF0, 0x9D, 0x06, 0xF0, 0x1E, 0x87, 0x10, 0xC0, 0x54, 0x03, 0x30,
  // "ĸ" (U+0138)
  0x89, 0x66, 0xF0, 0x5F, 0x56, 0xF3, 0xE8, 0x06, 0xFC, 0xD2, 0x8A, 0x06, 0xFC, 0xF4, 0x06, 0xF0,
  0x9D, 0x06, 0xF0, 0x1E, 0x80,
  // "Ĺ" (U+0139)
  0x20, 0x70, 0x43, 0x81, 0x7B, 0x17, 0x18, 0x11, 0xF5, 0x38, 0x11, 0xF5, 0x38, 0x11, 0xF5, 0x38,
  0x11, 0xF5, 0x38, 0x11, 0xF5, 0x38, 0x11, 0xF5, 0x38, 0x51, 0xF9, 0x55, 0x11, 0xC0, 0x40,
  // "ĺ" (U+013A)
  0x30, 0x70, 0x43, 0x81, 0x7B, 0x17, 0x1A, 0x0D, 0x38, 0x11, 0xAD, 0x40, 0x90, 0xD4, 0x09, 0x0D,
  0x40, 0x90, 0xD4, 0x09, 0x0D, 0x38, 0x41, 0xAD, 0x10, 0x6C, 0x07,
  // "Ļ" (U+013B)
  0x81, 0x1F, 0x53, 0x81, 0x1F, 0x53, 0x81, 0x1F, 0x53, 0x81, 0x1F, 0x53, 0x81, 0x1F, 0x53, 0x81,
  0x1F, 0x53, 0x85, 0x1F, 0x95, 0x51, 0x1C, 0x04, 0x71, 0x0C, 0x05, 0x40, 0x33,
  // "ļ" (U+013C)
  0x1A, 0x0D, 0x38, 0x11, 0xAD, 0x40, 0x90, 0xD4, 0x09, 0x0D, 0x40, 0x90, 0xD4, 0x09, 0x0D, 0x38,
  0x41, 0xAD, 0x10, 0x6C, 0x07, 0x71, 0x0C, 0x05, 0x40, 0x33,
  // "Ľ" (U+013D)
  0x89, 0x51, 0xF5, 0x3E, 0x11, 0xF5, 0x12, 0x01, 0xF5, 0x38, 0x11, 0xF5, 0x38, 0x11, 0xF5, 0x38,
  0x11, 0xF5, 0x38, 0x51, 0xF9, 0x55, 0x11, 0xC0, 0x40,
  // "ľ" (U+013E)
  0x18, 0x3C, 0xED, 0x7A, 0x28, 0x29, 0xD2, 0x12, 0x09, 0x0D, 0x40, 0x90, 0xD4, 0x09, 0x0D, 0x40,
  0x90, 0xD3, 0x84, 0x2B, 0xD3, 0x06, 0xC0, 0x70,
  // "Ŀ" (U+013F)
  0x81, 0x1F, 0x53, 0x81, 0x1F, 0x53, 0x81, 0x1F, 0x53, 0x89, 0x51, 0xF5, 0x01, 0x11, 0xF5, 0x0B,
  0xB1, 0xF5, 0x38, 0x51, 0xF9, 0x55, 0x11, 0xC0, 0x40,
  // "ŀ" (U+0140)
  0x1A, 0x0D, 0x48, 0x11, 0xAD, 0x50, 0x90, 0xD5, 0x83, 0x9D, 0x01, 0x12, 0x83, 0x9D, 0x0B, 0xB2,
  0x09, 0x0D, 0x48, 0x21, 0xAD, 0x12, 0x06, 0xC0, 0x71,
  // "Ł" (U+0141)
  0x10, 0xA0, 0xB4, 0x0A, 0x0B, 0x48, 0x1A, 0xC4, 0x38, 0x1B, 0xFC, 0x28, 0x15, 0xFC, 0x38, 0x11,
  0xCB, 0x48, 0x5A, 0xD5, 0x54, 0x0A, 0xB0, 0xA0,
  // "ł" (U+0142)
  0x1A, 0x0D, 0x38, 0x11, 0xAD, 0x48, 0x19, 0xD1, 0x38, 0x19, 0xFC, 0x28, 0x25, 0xEE, 0x12, 0x81,
  0x6C, 0xD3, 0x84, 0x1A, 0xD1, 0x06, 0xC0, 0x70,
  // "Ń" (U+0143)
  0x30, 0x70, 0x43, 0x81, 0x7B, 0x17, 0x8D, 0x68, 0xF8, 0x0B, 0x88, 0xED, 0x0B, 0x88, 0xBF, 0x2B,
  0x88, 0xBB, 0x6B, 0x88, 0xB7, 0xBB, 0x88, 0xB2, 0xFB, 0x88, 0xB0, 0xDE, 0x88, 0xB0, 0x9F, 0x80,
  // "ń" (U+0144)
  0x30, 0x70, 0x43, 0x81, 0x7B, 0x17, 0x8A, 0x17, 0xC9, 0xEB, 0x07, 0xF9, 0x6F, 0x67, 0xF1, 0x0F,
  0x77, 0x92, 0x81, 0xE7, 0x79, 0x28, 0x1E, 0x77, 0x92, 0x0E, 0x07,
  // "Ņ" (U+0145)
  0x8D, 0x68, 0xF8, 0x0B, 0x88, 0xED, 0x0B, 0x88, 0xBF, 0x2B, 0x88, 0xBB, 0x6B, 0x88, 0xB7, 0xBB,
  0x88, 0xB2, 0xFB, 0x88, 0xB0, 0xDE, 0x88, 0xB0, 0x9F, 0x87, 0x10, 0xC0, 0x54, 0x03, 0x30,
  // "ņ" (U+0146)
  0x8A, 0x17, 0xC9, 0xEB, 0x07, 0xF9, 0x6F, 0x67, 0xF1, 0x0F, 0x77, 0x92, 0x81, 0xE7, 0x79, 0x28,
  0x1E, 0x77, 0x92, 0x0E, 0x07, 0x71, 0x0C, 0x05, 0x40, 0x33,
  // "Ň" (U+0147)
  0x18, 0x25, 0x33, 0x52, 0x82, 0x2E, 0xE2, 0x78, 0xD6, 0x8F, 0x80, 0xB8, 0x8E, 0xD0, 0xB8, 0x8B,
  0xF2, 0xB8, 0x8B, 0xB6, 0xB8, 0x8B, 0x7B, 0xB8, 0x8B, 0x2F, 0xB8, 0x8B, 0x0D, 0xE8, 0x8B, 0x09,
  0xF8,
  // "ň" (U+0148)
  0x18, 0x25, 0x33, 0x52, 0x82, 0x2E, 0xE2, 0x78, 0xA1, 0x7C, 0x9E, 0xB0, 0x7F, 0x96, 0xF6, 0x7F,
  0x10, 0xF7, 0x79, 0x28, 0x1E, 0x77, 0x92, 0x81, 0xE7, 0x79, 0x20, 0xE0, 0x70,
  // "ŉ" (U+0149)
  0x0B, 0x0A, 0x50, 0xD0, 0x65, 0x8D, 0x0D, 0x6D, 0x9E, 0xB1, 0x05, 0xF9, 0x6F, 0x60, 0x5F, 0x20,
  0xF7, 0x05, 0xF1, 0x0E, 0x70, 0x5F, 0x10, 0xE7, 0x05, 0xF1, 0x0E, 0x70,
  // "Ŋ" (U+014A)
  0x8D, 0x68, 0xF8, 0x0B, 0x88, 0xED, 0x0B, 0x88, 0xBF, 0x2B, 0x88, 0xBB, 0x6B, 0x88, 0xB7, 0xBB,
  0x88, 0xB2, 0xFB, 0x88, 0xB0, 0xDE, 0x88, 0xB0, 0x9F, 0x83, 0x81, 0x1C, 0x72, 0x82, 0x9F, 0xD1,
  0x20, 0x10, 0x22,
  // "ŋ" (U+014B)
  0x8A, 0x17, 0xC9, 0xEB, 0x07, 0xF9, 0x6F, 0x57, 0xF1, 0x0F, 0x77, 0x92, 0x81, 0xE7, 0x79, 0x28,
  0x1E, 0x77, 0x92, 0x0E, 0x07, 0x40, 0xE0, 0x73, 0x81, 0x5F, 0x62, 0x82, 0x1F, 0xC1,
  // "Ō" (U+014C)
  0x10, 0x8A, 0x08, 0x28, 0x21, 0x33, 0x12, 0x89, 0x37, 0xEE, 0x70, 0x3F, 0x77, 0xF3, 0x8E, 0x28,
  0x2E, 0x8A, 0xC2, 0x82, 0xCA, 0xAC, 0x28, 0x2C, 0xA8, 0xE2, 0x89, 0x3E, 0x83, 0xF7, 0x7F, 0x30,
  0x7E, 0xE7, 0x10,
  // "ō" (U+014D)
  0x10, 0x8A, 0x08, 0x28, 0x21, 0x33, 0x12, 0x89, 0x37, 0xEE, 0x70, 0x4F, 0x77, 0xF4, 0x8E, 0x28,
  0x2E, 0x88, 0xE2, 0x89, 0x3E, 0x84, 0xF7, 0x7F, 0x40, 0x8E, 0xE7, 0x10,
  // "Ŏ" (U+014E)
  0x18, 0x27, 0x54, 0x72, 0x04, 0xA0, 0x43, 0x00, 0x13, 0x89, 0x37, 0xEE, 0x70, 0x3F, 0x77, 0xF3,
  0x8E, 0x28, 0x2E, 0x8A, 0xC2, 0x82, 0xCA, 0xAC, 0x28, 0x2C, 0xA8, 0xE2, 0x89, 0x3E, 0x83, 0xF7,
  0x7F, 0x30, 0x7E, 0xE7, 0x10,
  // "ŏ" (U+014F)
  0x18, 0x27, 0x54, 0x72, 0x04, 0xA0, 0x43, 0x00, 0x13, 0x89, 0x37, 0xEE, 0x70, 0x4F, 0x77, 0xF4,
  0x8E, 0x28, 0x2E, 0x88, 0xE2, 0x89, 0x3E, 0x84, 0xF7, 0x7F, 0x40, 0x8E, 0xE7, 0x10,
  // "Ő" (U+0150)
  0x18, 0x25, 0xBA, 0x92, 0x81, 0x20, 0x23, 0x89, 0x37, 0xEE, 0x70, 0x3F, 0x77, 0xF3, 0x8E, 0x28,
  0x2E, 0x8A, 0xC2, 0x82, 0xCA, 0xAC, 0x28, 0x2C, 0xA8, 0xE2, 0x89, 0x3E, 0x83, 0xF7, 0x7F, 0x30,
  0x7E, 0xE7, 0x10,
  // "ő" (U+0151)
  0x18, 0x25, 0xBA, 0x92, 0x81, 0x20, 0x23, 0x89, 0x37, 0xEE, 0x70, 0x4F, 0x77, 0xF4, 0x8E, 0x28,
  0x2E, 0x88, 0xE2, 0x89, 0x3E, 0x84, 0xF7, 0x7F, 0x40, 0x8E, 0xE7, 0x10,
  // "Œ" (U+0152)
  0x10, 0x9B, 0x8C, 0x5C, 0x5F, 0x6E, 0x93, 0x9D, 0x0E, 0x70, 0xAB, 0x0E, 0xF9, 0xAB, 0x0E, 0x82,
  0x9C, 0x0E, 0x60, 0x5F, 0x5E, 0x93, 0x0A, 0xB0, 0xC0,
  // "œ" (U+0153)
  0x89, 0x52, 0xDB, 0x7E, 0x59, 0xAB, 0xD8, 0xCB, 0x57, 0xA8, 0xA1, 0xDB, 0x57, 0xC3, 0x39, 0xAB,
  0xE5, 0x52, 0xDB, 0x7E, 0x90,
  // "Ŕ" (U+0154)
  0x30, 0x70, 0x43, 0x81, 0x7B, 0x17, 0x03, 0xA8, 0xA4, 0xD5, 0x03, 0xF6, 0x9F, 0x13, 0xF3, 0x2F,
  0x43, 0xF4, 0x7F, 0x23, 0xB8, 0xA2, 0x80, 0x3F, 0x6E, 0x60, 0x3F, 0x37, 0xE1, 0x3F, 0x30, 0xE8,
  // "ŕ" (U+0155)
  0x30, 0x70, 0x43, 0x81, 0x7B, 0x17, 0x04, 0xA8, 0x93, 0x7E, 0xA0, 0x3F, 0xC4, 0x20, 0x2F, 0x53,
  0x81, 0x2F, 0x43, 0x84, 0x5F, 0x71, 0x09, 0xB0, 0xA1,
  // "Ŗ" (U+0156)
  0x03, 0xA8, 0xA4, 0xD5, 0x03, 0xF6, 0x9F, 0x13, 0xF3, 0x2F, 0x43, 0xF4, 0x7F, 0x23, 0xB8, 0xA2,
  0x80, 0x3F, 0x6E, 0x60, 0x3F, 0x37, 0xE1, 0x3F, 0x30, 0xE8, 0x71, 0x0C, 0x05, 0x40, 0x33,
  // "ŗ" (U+0157)
  0x04, 0xA8, 0x93, 0x7E, 0xA0, 0x3F, 0xC4, 0x20, 0x2F, 0x53, 0x81, 0x2F, 0x43, 0x84, 0x5F, 0x71,
  0x09, 0xB0, 0xA7, 0x20, 0xC0, 0x54, 0x03, 0x30,
  // "Ř" (U+0158)
  0x18, 0x25, 0x33, 0x52, 0x82, 0x2E, 0xE2, 0x70, 0x3A, 0x8A, 0x4D, 0x50, 0x3F, 0x69, 0xF1, 0x3F,
  0x32, 0xF4, 0x3F, 0x47, 0xF2, 0x3B, 0x8A, 0x28, 0x03, 0xF6, 0xE6, 0x03, 0xF3, 0x7E, 0x13, 0xF3,
  0x0E, 0x80,
  // "ř" (U+0159)
  0x18, 0x25, 0x33, 0x52, 0x82, 0x2E, 0xE2, 0x70, 0x4A, 0x89, 0x37, 0xEA, 0x03, 0xFC, 0x42, 0x02,
  0xF5, 0x38, 0x12, 0xF4, 0x38, 0x45, 0xF7, 0x10, 0x9B, 0x0A, 0x10,
  // "Ś" (U+015A)
  0x30, 0x70, 0x43, 0x81, 0x7B, 0x17, 0x18, 0x94, 0x6D, 0xEC, 0x10, 0xFA, 0x48, 0x01, 0xF7, 0x48,
  0x29, 0xFA, 0x13, 0x82, 0x7E, 0xE1, 0x38, 0x94, 0x3F, 0x63, 0x84, 0x7F, 0x42, 0xCF, 0xD8, 0x10,
  // "ś" (U+015B)
  0x30, 0x70, 0x43, 0x81, 0x7B, 0x17, 0x18, 0x90, 0x7E, 0xEB, 0x01, 0xF9, 0x47, 0x28, 0x2D, 0xE8,
  0x13, 0x89, 0x57, 0xEE, 0x02, 0x74, 0x8F, 0x22, 0xDF, 0xE8, 0x10,
  // "Ŝ" (U+015C)
  0x20, 0x60, 0x73, 0x82, 0x7A, 0x98, 0x71, 0x89, 0x46, 0xDE, 0xC1, 0x0F, 0xA4, 0x80, 0x1F, 0x74,
  0x82, 0x9F, 0xA1, 0x38, 0x27, 0xEE, 0x13, 0x89, 0x43, 0xF6, 0x38, 0x47, 0xF4, 0x2C, 0xFD, 0x81,
  // "ŝ" (U+015D)
  0x20, 0x60, 0x73, 0x82, 0x7A, 0x98, 0x71, 0x89, 0x07, 0xEE, 0xB0, 0x1F, 0x94, 0x72, 0x82, 0xDE,
  0x81, 0x38, 0x95, 0x7E, 0xE0, 0x27, 0x48, 0xF2, 0x2D, 0xFE, 0x81,
  // "Ş" (U+015E)
  0x18, 0x94, 0x6D, 0xEC, 0x10, 0xFA, 0x48, 0x01, 0xF7, 0x48, 0x29, 0xFA, 0x13, 0x82, 0x7E, 0xE1,
  0x38, 0x94, 0x3F, 0x63, 0x84, 0x7F, 0x42, 0xCF, 0xD8, 0x30, 0x40, 0x34, 0x03, 0x0E, 0x40, 0xC0,
  0xA2,
  // "ş" (U+015F)
  0x18, 0x90, 0x7E, 0xEB, 0x01, 0xF9, 0x47, 0x28, 0x2D, 0xE8, 0x13, 0x89, 0x57, 0xEE, 0x02, 0x74,
  0x8F, 0x22, 0xDF, 0xE8, 0x30, 0x40, 0x34, 0x03, 0x0E, 0x40, 0xC0, 0xA2,
  // "Š" (U+0160)
  0x18, 0x25, 0x33, 0x52, 0x82, 0x2E, 0xE2, 0x71, 0x89, 0x46, 0xDE, 0xC1, 0x0F, 0xA4, 0x80, 0x1F,
  0x74, 0x82, 0x9F, 0xA1, 0x38, 0x27, 0xEE, 0x13, 0x89, 0x43, 0xF6, 0x38, 0x47, 0xF4, 0x2C, 0xFD,
  0x81,
  // "š" (U+0161)
  0x18, 0x25, 0x33, 0x52, 0x82, 0x2E, 0xE2, 0x71, 0x89, 0x07, 0xEE, 0xB0, 0x1F, 0x94, 0x72, 0x82,
  0xDE, 0x81, 0x38, 0x95, 0x7E, 0xE0, 0x27, 0x48, 0xF2, 0x2D, 0xFE, 0x81,
  // "Ţ" (U+0162)
  0x0A, 0xC8, 0x5A, 0x23, 0xCC, 0x32, 0x20, 0x0B, 0x40, 0x0B, 0x40, 0x0B, 0x40, 0x0B, 0x40, 0x0B,
  0x40, 0x0B, 0x40, 0x40, 0x34, 0x03, 0x0E, 0x40, 0xC0, 0xA2,
  // "ţ" (U+0163)
  0x20, 0x70, 0x14, 0x90, 0x32, 0x05, 0x0E, 0xB8, 0x91, 0x41, 0x6F, 0x64, 0x10, 0x3F, 0x33, 0x81,
  0x3F, 0x33, 0x83, 0x1F, 0x94, 0x22, 0x82, 0x8E, 0xE4, 0x30, 0x40, 0x34, 0x03, 0x0E, 0x40, 0xC0,
  0xA1,
  // "Ť" (U+0164)
  0x18, 0x25, 0x33, 0x52, 0x82, 0x2E, 0xE2, 0x70, 0xAC, 0x85, 0xA2, 0x3C, 0xC3, 0x22, 0x00, 0xB4,
  0x00, 0xB4, 0x00, 0xB4, 0x00, 0xB4, 0x00, 0xB4, 0x00, 0xB2,
  // "ť" (U+0165)
  0x28, 0x24, 0x1B, 0x72, 0x98, 0x33, 0x30, 0x5D, 0xB8, 0x91, 0x41, 0x6F, 0x64, 0x10, 0x3F, 0x33,
  0x81, 0x3F, 0x33, 0x83, 0x1F, 0x94, 0x22, 0x82, 0x8E, 0xE4,
  // "Ŧ" (U+0166)
  0x0A, 0xC8, 0x5A, 0x23, 0xCC, 0x32, 0x20, 0x0B, 0x40, 0x0B, 0x30, 0xEA, 0x0E, 0x28, 0x23, 0xCC,
  0x33, 0x00, 0xB4, 0x00, 0xB2,
  // "ŧ" (U+0167)
  0x20, 0x70, 0x14, 0x90, 0x32, 0x05, 0x0E, 0xB8, 0x64, 0x27, 0xF7, 0x41, 0x7C, 0x89, 0x35, 0x16,
  0xF6, 0x31, 0x01, 0xF9, 0x42, 0x28, 0x28, 0xEE, 0x40,
  // "Ũ" (U+0168)
  0x18, 0x26, 0xC1, 0xB2, 0x82, 0xB5, 0xE8, 0x20, 0x14, 0x08, 0x0E, 0x28, 0x2E, 0x88, 0xE2, 0x82,
  0xE8, 0x8E, 0x28, 0x2E, 0x88, 0xE2, 0x82, 0xE8, 0x8E, 0x28, 0x2E, 0x87, 0xE2, 0x89, 0x3E, 0x74,
  0xF7, 0x7F, 0x40, 0x8E, 0xE8, 0x10,
  // "ũ" (U+0169)
  0x18, 0x26, 0xC1, 0xB2, 0x82, 0xB5, 0xE8, 0x20, 0x14, 0x07, 0x0E, 0x29, 0x81, 0x77, 0xE2, 0x98,
  0x17, 0x7E, 0x29, 0x8A, 0x17, 0x7E, 0x01, 0xF7, 0x6F, 0x69, 0xF7, 0x0B, 0xE9, 0xC7,
  // "Ū" (U+016A)
  0x10, 0x8A, 0x08, 0x28, 0x51, 0x33, 0x10, 0x8E, 0x28, 0x2E, 0x88, 0xE2, 0x82, 0xE8, 0x8E, 0x28,
  0x2E, 0x88, 0xE2, 0x82, 0xE8, 0x8E, 0x28, 0x2E, 0x87, 0xE2, 0x89, 0x3E, 0x74, 0xF7, 0x7F, 0x40,
  0x8E, 0xE8, 0x10,
  // "ū" (U+016B)
  0x10, 0x8A, 0x08, 0x28, 0x51, 0x33, 0x10, 0x7E, 0x29, 0x81, 0x77, 0xE2, 0x98, 0x17, 0x7E, 0x29,
  0x8A, 0x17, 0x7E, 0x01, 0xF7, 0x6F, 0x69, 0xF7, 0x0B, 0xE9, 0xC7,
  // "Ŭ" (U+016C)
  0x18, 0x27, 0x54, 0x72, 0x04, 0xA0, 0x43, 0x00, 0x12, 0x08, 0x0E, 0x28, 0x2E, 0x88, 0xE2, 0x82,
  0xE8, 0x8E, 0x28, 0x2E, 0x88, 0xE2, 0x82, 0xE8, 0x8E, 0x28, 0x2E, 0x87, 0xE2, 0x89, 0x3E, 0x74,
  0xF7, 0x7F, 0x40, 0x8E, 0xE8, 0x10,
  // "ŭ" (U+016D)
  0x18, 0x27, 0x54, 0x72, 0x04, 0xA0, 0x43, 0x00, 0x12, 0x07, 0x0E, 0x29, 0x81, 0x77, 0xE2, 0x98,
  0x17, 0x7E, 0x29, 0x8A, 0x17, 0x7E, 0x01, 0xF7, 0x6F, 0x69, 0xF7, 0x0B, 0xE9, 0xC7,
  // "Ů" (U+016E)
  0x18, 0x11, 0xDD, 0x38, 0x93, 0x1F, 0xE1, 0x08, 0xE1, 0x1E, 0x88, 0xE2, 0x82, 0xE8, 0x8E, 0x28,
  0x2E, 0x88, 0xE2, 0x82, 0xE8, 0x8E, 0x28, 0x2E, 0x87, 0xE2, 0x89, 0x3E, 0x74, 0xF7, 0x7F, 0x40,
  0x8E, 0xE8, 0x10,
  // "ů" (U+016F)
  0x18, 0x11, 0xDD, 0x38, 0x93, 0x1F, 0xE1, 0x07, 0xE1, 0x1F, 0x77, 0xE2, 0x98, 0x17, 0x7E, 0x29,
  0x8A, 0x17, 0x7E, 0x01, 0xF7, 0x6F, 0x69, 0xF7, 0x0B, 0xE9, 0xC7,
  // "Ű" (U+0170)
  0x18, 0x25, 0xBA, 0x92, 0x81, 0x20, 0x22, 0x08, 0x0E, 0x28, 0x2E, 0x88, 0xE2, 0x82, 0xE8, 0x8E,
  0x28, 0x2E, 0x88, 0xE2, 0x82, 0xE8, 0x8E, 0x28, 0x2E, 0x87, 0xE2, 0x89, 0x3E, 0x74, 0xF7, 0x7F,
  0x40, 0x8E, 0xE8, 0x10,
  // "ű" (U+0171)
  0x18, 0x25, 0xBA, 0x92, 0x81, 0x20, 0x22, 0x07, 0x0E, 0x29, 0x81, 0x77, 0xE2, 0x98, 0x17, 0x7E,
  0x29, 0x8A, 0x17, 0x7E, 0x01, 0xF7, 0x6F, 0x69, 0xF7, 0x0B, 0xE9, 0xC7,
  // "Ų" (U+0172)
  0x08, 0x0E, 0x28, 0x2E, 0x88, 0xE2, 0x82, 0xE8, 0x8E, 0x28, 0x2E, 0x88, 0xE2, 0x82, 0xE8, 0x8E,
  0x28, 0x2E, 0x87, 0xE2, 0x89, 0x3E, 0x84, 0xF7, 0x7F, 0x50, 0x9E, 0xFB, 0x30, 0x70, 0x94, 0x0C,
  0x06, 0x40, 0x80, 0xE2,
  // "ų" (U+0173)
  0x07, 0x0E, 0x29, 0x81, 0x77, 0xE2, 0x98, 0x17, 0x7E, 0x29, 0x8A, 0x17, 0x7E, 0x01, 0xF7, 0x6F,
  0x69, 0xF7, 0x0B, 0xEC, 0xF7, 0x30, 0xB0, 0x34, 0x0B, 0x95, 0x02, 0x10,
  // "Ŵ" (U+0174)
  0x20, 0x60, 0x73, 0x82, 0x7A, 0x98, 0x70, 0xD0, 0x62, 0x82, 0x6D, 0xC7, 0x28, 0xC4, 0x7C, 0xB8,
  0xBB, 0x8B, 0xA9, 0xDD, 0x9A, 0x9A, 0xDD, 0xA9, 0x8C, 0xBB, 0xC8, 0x7E, 0x99, 0xE7, 0x6F, 0x77,
  0xF6,
  // "ŵ" (U+0175)
  0x20, 0x60, 0x73, 0x82, 0x7A, 0x98, 0x70, 0xE0, 0x52, 0x8B, 0x65, 0xEC, 0x7B, 0xB6, 0xCA, 0x8D,
  0xD7, 0xA8, 0xAD, 0xDA, 0x86, 0xEA, 0xAE, 0x64, 0xF8, 0x8F, 0x40,
  // "Ŷ" (U+0176)
  0x20, 0x60, 0x73, 0x82, 0x7A, 0x98, 0x70, 0x90, 0xE2, 0x89, 0x3D, 0x92, 0xF4, 0x4F, 0x20, 0xBA,
  0x9B, 0x28, 0x25, 0xFE, 0x53, 0x00, 0xD4, 0x00, 0xB4, 0x00, 0xB4, 0x00, 0xB2,
  // "ŷ" (U+0177)
  0x20, 0x60, 0x73, 0x82, 0x7A, 0x98, 0x70, 0x90, 0xE2, 0x89, 0x3D, 0x94, 0xF3, 0x2F, 0x40, 0xE7,
  0x6E, 0x28, 0x29, 0xCA, 0xA2, 0x82, 0x4F, 0xE5, 0x30, 0xE9, 0x40, 0x0B, 0x28, 0x22, 0x8F, 0x42,
  0x81, 0x6E, 0x83,
  // "Ÿ" (U+0178)
  0x18, 0x2B, 0x66, 0xC2, 0x01, 0x28, 0x21, 0x09, 0xE2, 0x89, 0x3D, 0x92, 0xF4, 0x4F, 0x20, 0xBA,
  0x9B, 0x28, 0x25, 0xFE, 0x53, 0x00, 0xD4, 0x00, 0xB4, 0x00, 0xB4, 0x00, 0xB2,
  // "Ź" (U+0179)
  0x30, 0x70, 0x43, 0x81, 0x7B, 0x17, 0x10, 0xEB, 0x85, 0x40, 0x33, 0xAE, 0x13, 0x0E, 0x08, 0x38,
  0x17, 0xE1, 0x30, 0xE0, 0x83, 0x81, 0x6E, 0x13, 0x84, 0xEA, 0x33, 0x13, 0xC0, 0x40,
  // "ź" (U+017A)
  0x30, 0x70, 0x43, 0x81, 0x7B, 0x17, 0x03, 0xC8, 0x54, 0x03, 0x4D, 0xD1, 0x28, 0x17, 0xF3, 0x28,
  0x13, 0xF6, 0x28, 0x51, 0xDC, 0x33, 0x15, 0xC0, 0x50,
  // "Ż" (U+017B)
  0x20, 0x0B, 0x40, 0x01, 0x30, 0xEB, 0x85, 0x40, 0x33, 0xAE, 0x13, 0x0E, 0x08, 0x38, 0x17, 0xE1,
  0x30, 0xE0, 0x83, 0x81, 0x6E, 0x13, 0x84, 0xEA, 0x33, 0x13, 0xC0, 0x40,
  // "ż" (U+017C)
  0x20, 0x0B, 0x40, 0x01, 0x20, 0x3C, 0x85, 0x40, 0x34, 0xDD, 0x12, 0x81, 0x7F, 0x32, 0x81, 0x3F,
  0x62, 0x85, 0x1D, 0xC3, 0x31, 0x5C, 0x05,
  // "Ž" (U+017D)
  0x18, 0x25, 0x33, 0x52, 0x82, 0x2E, 0xE2, 0x71, 0x0E, 0xB8, 0x54, 0x03, 0x3A, 0xE1, 0x30, 0xE0,
  0x83, 0x81, 0x7E, 0x13, 0x0E, 0x08, 0x38, 0x16, 0xE1, 0x38, 0x4E, 0xA3, 0x31, 0x3C, 0x04,
  // "ž" (U+017E)
  0x18, 0x25, 0x33, 0x52, 0x82, 0x2E, 0xE2, 0x70, 0x3C, 0x85, 0x40, 0x34, 0xDD, 0x12, 0x81, 0x7F,
  0x32, 0x81, 0x3F, 0x62, 0x85, 0x1D, 0xC3, 0x31, 0x5C, 0x05,
  // "ſ" (U+017F)
  0x89, 0x07, 0xEE, 0x1F, 0xA4, 0x0F, 0x62, 0x90, 0x62, 0x90, 0x62, 0x90, 0x62, 0x90, 0x62, 0x90,
  0x62,
  // "Ω" (U+03A9)
  0x18, 0x93, 0x7D, 0xD6, 0x03, 0xF7, 0x7F, 0x27, 0xD2, 0x82, 0xD7, 0x8C, 0x28, 0x2B, 0x87, 0xD2,
  0x82, 0xC7, 0x3E, 0x28, 0x94, 0xE3, 0x3D, 0x77, 0xC3, 0xDF, 0x99, 0xFD,
  // "μ" (U+03BC)
  0x07, 0x0E, 0x29, 0x81, 0x77, 0xE2, 0x98, 0x17, 0x7E, 0x29, 0x8A, 0x37, 0x7F, 0x01, 0xF7, 0x7F,
  0x69, 0xF7, 0x7F, 0xE9, 0xC7, 0x7E, 0x40, 0x70, 0xE4, 0x07, 0x0E, 0x40,
  // "π" (U+03C0)
  0x0A, 0xC8, 0x92, 0xE3, 0xE9, 0xAD, 0x30, 0xE6, 0x8C, 0x28, 0x2E, 0x68, 0xC2, 0x89, 0x1E, 0x68,
  0xE4, 0x0E, 0x63, 0xEC,
  // "–" (U+2013)
  0xC8, 0x00, 0x30,
  // "—" (U+2014)
  0xE8, 0x02, 0x30,
  // "€" (U+20AC)
  0x28, 0x93, 0x7E, 0xE7, 0x06, 0xF6, 0x53, 0x0C, 0x93, 0x09, 0xB8, 0x17, 0x09, 0xB8, 0x57, 0x02,
  0xDA, 0x31, 0x28, 0x37, 0xE6, 0x43, 0x28, 0x28, 0xEE, 0x50,
  // "₿" (U+20BF)
  0x30, 0x13, 0x81, 0x27, 0xA2, 0x03, 0xB8, 0x95, 0xA0, 0x3F, 0x56, 0xF6, 0x3F, 0x23, 0xF5, 0x3B,
  0x8A, 0x3B, 0x03, 0xF5, 0x5F, 0x53, 0xF2, 0x0E, 0x83, 0xF5, 0x6F, 0x63, 0xB0, 0xA2, 0x81, 0x27,
  0xA2,
  // "‘" (U+2018)
  0x84, 0x4D, 0x9A, 0xB6,
  // "’" (U+2019)
  0x84, 0x7E, 0xA9, 0xA4,
  // "‚" (U+201A)
  0x84, 0x9C, 0xC8, 0xE3,
  // "‛" (U+201B)
  0x84, 0xD8, 0x8A, 0x3B,
  // "“" (U+201C)
  0x89, 0x24, 0xD4, 0xD9, 0xA9, 0xAB, 0x6B, 0x60,
  // "”" (U+201D)
  0x89, 0x26, 0xB6, 0xBA, 0x9A, 0x9D, 0x4D, 0x40,
  // "„" (U+201E)
  0x89, 0x29, 0xC9, 0xCC, 0x8C, 0x8E, 0x3E, 0x30,
  // "‟" (U+201F)
  0x89, 0x2B, 0x6B, 0x69, 0xA9, 0xA4, 0xD4, 0xD0,
  // "†" (U+2020)
  0x10, 0xA0, 0x82, 0x89, 0x48, 0x60, 0xDE, 0xDD, 0x38, 0x63, 0x08, 0x62, 0x08, 0x07, 0x20, 0x90,
  0x82, 0x0A, 0x09, 0x10,
  // "‡" (U+2021)
  0x18, 0x94, 0x99, 0x01, 0x77, 0x1F, 0xEE, 0xF0, 0x88, 0x28, 0x94, 0x88, 0x0E, 0xDD, 0xE3, 0x88,
  0x30, 0x99, 0x10,
  // "•" (U+2022)
  0x83, 0x1D, 0xD1, 0x5A, 0x83, 0x51, 0xDD, 0x10,
  // "…" (U+2026)
  0x80, 0x21, 0x80, 0x2B,
  // "‰" (U+2030)
  0x81, 0x7E, 0x13, 0x81, 0xCA, 0x53, 0x83, 0x9F, 0x4B, 0x42, 0x81, 0x3C, 0x32, 0x81, 0x2C, 0x33,
  0x8A, 0x02, 0x8E, 0x5E, 0x80, 0xAC, 0xCC, 0xC0, 0x6E, 0x5E, 0x70,
  // "‹" (U+2039)
  0x18, 0x90, 0x1C, 0x20, 0xCA, 0x03, 0xF4, 0x28, 0x17, 0xE1, 0x20, 0x51,
  // "›" (U+203A)
  0x10, 0x52, 0x81, 0x1E, 0x72, 0x89, 0x04, 0xF3, 0x0A, 0xC0, 0x2C, 0x11,
  // "⁄" (U+2044)
  0x20, 0x30, 0xC2, 0x09, 0x07, 0x28, 0x3E, 0x10, 0x5B, 0x28, 0x3B, 0x50, 0x1E, 0x20, 0x70, 0x92,
  0x0C, 0x04, 0x20,
  // "™" (U+2122)
  0x8A, 0x6D, 0xEA, 0xD2, 0xE1, 0x94, 0xD9, 0xD1, 0x94, 0x9C, 0xB1, 0x93, 0x60, 0xA0,
  // "⅒" (U+2152)
  0x50, 0x30, 0xC7, 0x81, 0x2B, 0xA2, 0x09, 0x07, 0x78, 0x12, 0x7A, 0x20, 0xE0, 0x17, 0x18, 0x34,
  0xA0, 0x5B, 0x48, 0xA0, 0x2C, 0xB2, 0x2B, 0xD6, 0xB5, 0x2B, 0xA0, 0x96, 0x59, 0x38, 0x91, 0x1E,
  0x02, 0x7A, 0x0B, 0x33, 0xB3, 0x07, 0x09, 0x28, 0x54, 0xA0, 0x96, 0x59, 0x38, 0x91, 0xC4, 0x02,
  0xBD, 0x62, 0xCC, 0x20,
  // "∂" (U+2202)
  0x18, 0x23, 0xDE, 0x92, 0x0F, 0x29, 0x8A, 0x64, 0x05, 0xED, 0xE6, 0x1F, 0x72, 0xF6, 0x6F, 0x04,
  0xF2, 0x6F, 0x1B, 0xB2, 0x82, 0xCF, 0xA1, 0x10,
  // "∆" (U+2206)
  0x20, 0x0E, 0x30, 0x4A, 0x03, 0x28, 0x28, 0xDD, 0x82, 0x89, 0x3D, 0x88, 0xD0, 0x2F, 0x44, 0xF2,
  0x6E, 0x28, 0x7E, 0x6B, 0xC4, 0x4C, 0xBE, 0xC0, 0xE0,
  // "√" (U+221A)
  0x40, 0x10, 0x74, 0x05, 0x0C, 0x40, 0x90, 0x84, 0x0D, 0x03, 0x38, 0x94, 0x2E, 0x0A, 0xF1, 0x6A,
  0x02, 0xB6, 0xA6, 0x28, 0x25, 0xBE, 0x12, 0x81, 0x1F, 0xD4, 0x0A, 0x08, 0x20,
  // "∞" (U+221E)
  0x8A, 0x06, 0xE8, 0x8E, 0x7D, 0x4C, 0xC4, 0xC7, 0xE8, 0xAE, 0x60,
  // "≈" (U+2248)
  0x8A, 0x32, 0xDC, 0x42, 0x45, 0x57, 0xDD, 0x32, 0xED, 0x42, 0x45, 0x57, 0xA0, 0x33, 0x00, 0x11,
  // "≠" (U+2260)
  0x30, 0x15, 0x82, 0xB7, 0x04, 0xC8, 0x64, 0x02, 0x9B, 0x20, 0x4C, 0x84, 0x40, 0x7D, 0x22, 0x30,
  0x23,
  // "≤" (U+2264)
  0x50, 0x13, 0x89, 0x36, 0xD5, 0x06, 0xD9, 0x20, 0x5F, 0x91, 0x38, 0x31, 0x8E, 0xA2, 0x48, 0x66,
  0x45, 0xEE, 0xEE, 0x61, 0x80, 0x01, 0x10,
  // "≥" (U+2265)
  0x01, 0x58, 0x15, 0xD6, 0x48, 0x22, 0x9D, 0x63, 0x89, 0x21, 0x9F, 0x52, 0xAE, 0x81, 0x04, 0x64,
  0x84, 0x6E, 0xEE, 0xE5, 0x18, 0x00, 0x11,
};

const Font& font_NotoSansMono_Bold_10() {
  static SmoothFont font(font_NotoSansMono_Bold_10_data);
  return font;
}

}  // namespace roo_display
