#include "18.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSans-CondensedItalic (Noto Sans Condensed Italic)
// Generated on Thu Mar 30 22:28:54 CEST 2023
static const uint8_t font_NotoSans_CondensedItalic_18_data[] PROGMEM = {
  
  // Header
  0x01, 0x01, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x06, 0x9A,
  0xFC, 0xFC, 0x11, 0x12, 0x0E, 0xFC, 0x05, 0x02, 0x11, 0x05, 0x04, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x00, 0x01, 0x04, 0x0D, 0x04, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x01, 0x09, 0x06, 0x0D, 0x06, 0x00, 0x21, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x09, 0x0D, 0x09, 0x00, 0x32, // "#" (U+0023)
  0x00, 0x24, 0x00, 0x00, 0x07, 0x0E, 0x08, 0x00, 0x68, // "$" (U+0024)
  0x00, 0x25, 0x01, 0x01, 0x0B, 0x0D, 0x0C, 0x00, 0x9C, // "%" (U+0025)
  0x00, 0x26, 0x00, 0x01, 0x08, 0x0D, 0x09, 0x00, 0xE9, // "&" (U+0026)
  0x00, 0x27, 0x02, 0x09, 0x04, 0x0D, 0x04, 0x01, 0x23, // "'" (U+0027)
  0x00, 0x28, 0x00, 0xFE, 0x05, 0x0D, 0x05, 0x01, 0x2C, // "(" (U+0028)
  0x00, 0x29, 0xFE, 0xFE, 0x04, 0x0D, 0x05, 0x01, 0x57, // ")" (U+0029)
  0x00, 0x2A, 0x02, 0x08, 0x07, 0x0E, 0x08, 0x01, 0x83, // "*" (U+002A)
  0x00, 0x2B, 0x00, 0x03, 0x08, 0x0B, 0x09, 0x01, 0x9A, // "+" (U+002B)
  0x00, 0x2C, 0xFF, 0xFF, 0x02, 0x03, 0x04, 0x01, 0xB7, // "," (U+002C)
  0x00, 0x2D, 0x00, 0x05, 0x04, 0x06, 0x05, 0x01, 0xC2, // "-" (U+002D)
  0x00, 0x2E, 0x00, 0x01, 0x02, 0x03, 0x04, 0x01, 0xC8, // "." (U+002E)
  0x00, 0x2F, 0xFF, 0x01, 0x07, 0x0D, 0x06, 0x01, 0xCE, // "/" (U+002F)
  0x00, 0x30, 0x00, 0x01, 0x07, 0x0D, 0x08, 0x01, 0xF2, // "0" (U+0030)
  0x00, 0x31, 0x02, 0x01, 0x06, 0x0D, 0x08, 0x02, 0x28, // "1" (U+0031)
  0x00, 0x32, 0xFF, 0x01, 0x07, 0x0D, 0x08, 0x02, 0x4B, // "2" (U+0032)
  0x00, 0x33, 0xFF, 0x01, 0x07, 0x0D, 0x08, 0x02, 0x76, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x01, 0x07, 0x0D, 0x08, 0x02, 0xA1, // "4" (U+0034)
  0x00, 0x35, 0x00, 0x01, 0x07, 0x0D, 0x08, 0x02, 0xCF, // "5" (U+0035)
  0x00, 0x36, 0x00, 0x01, 0x08, 0x0D, 0x08, 0x02, 0xFA, // "6" (U+0036)
  0x00, 0x37, 0x01, 0x01, 0x08, 0x0D, 0x08, 0x03, 0x32, // "7" (U+0037)
  0x00, 0x38, 0x00, 0x01, 0x07, 0x0D, 0x08, 0x03, 0x58, // "8" (U+0038)
  0x00, 0x39, 0x00, 0x01, 0x07, 0x0D, 0x08, 0x03, 0x90, // "9" (U+0039)
  0x00, 0x3A, 0x00, 0x01, 0x03, 0x0A, 0x04, 0x03, 0xC4, // ":" (U+003A)
  0x00, 0x3B, 0xFF, 0xFE, 0x03, 0x0A, 0x04, 0x03, 0xD2, // ";" (U+003B)
  0x00, 0x3C, 0x00, 0x03, 0x08, 0x0B, 0x09, 0x03, 0xEA, // "<" (U+003C)
  0x00, 0x3D, 0x00, 0x04, 0x07, 0x09, 0x09, 0x04, 0x07, // "=" (U+003D)
  0x00, 0x3E, 0x00, 0x03, 0x08, 0x0B, 0x09, 0x04, 0x11, // ">" (U+003E)
  0x00, 0x3F, 0x00, 0x01, 0x06, 0x0D, 0x06, 0x04, 0x30, // "?" (U+003F)
  0x00, 0x40, 0x00, 0xFF, 0x0B, 0x0D, 0x0C, 0x04, 0x56, // "@" (U+0040)
  0x00, 0x41, 0xFF, 0x01, 0x06, 0x0D, 0x08, 0x04, 0xA9, // "A" (U+0041)
  0x00, 0x42, 0x00, 0x01, 0x08, 0x0D, 0x09, 0x04, 0xDA, // "B" (U+0042)
  0x00, 0x43, 0x00, 0x01, 0x08, 0x0D, 0x08, 0x05, 0x16, // "C" (U+0043)
  0x00, 0x44, 0x00, 0x01, 0x09, 0x0D, 0x09, 0x05, 0x40, // "D" (U+0044)
  0x00, 0x45, 0x00, 0x01, 0x07, 0x0D, 0x07, 0x05, 0x80, // "E" (U+0045)
  0x00, 0x46, 0x00, 0x01, 0x08, 0x0D, 0x07, 0x05, 0xA8, // "F" (U+0046)
  0x00, 0x47, 0x00, 0x01, 0x09, 0x0D, 0x0A, 0x05, 0xCE, // "G" (U+0047)
  0x00, 0x48, 0x00, 0x01, 0x09, 0x0D, 0x0A, 0x06, 0x07, // "H" (U+0048)
  0x00, 0x49, 0xFF, 0x01, 0x06, 0x0D, 0x05, 0x06, 0x47, // "I" (U+0049)
  0x00, 0x4A, 0xFD, 0xFD, 0x04, 0x0D, 0x04, 0x06, 0x6D, // "J" (U+004A)
  0x00, 0x4B, 0x00, 0x01, 0x09, 0x0D, 0x08, 0x06, 0x9B, // "K" (U+004B)
  0x00, 0x4C, 0x00, 0x01, 0x05, 0x0D, 0x07, 0x06, 0xD7, // "L" (U+004C)
  0x00, 0x4D, 0x00, 0x01, 0x0C, 0x0D, 0x0D, 0x06, 0xFB, // "M" (U+004D)
  0x00, 0x4E, 0x00, 0x01, 0x0A, 0x0D, 0x0A, 0x07, 0x57, // "N" (U+004E)
  0x00, 0x4F, 0x00, 0x01, 0x09, 0x0D, 0x0A, 0x07, 0xA3, // "O" (U+004F)
  0x00, 0x50, 0x00, 0x01, 0x08, 0x0D, 0x08, 0x07, 0xDF, // "P" (U+0050)
  0x00, 0x51, 0x00, 0xFE, 0x09, 0x0D, 0x0A, 0x08, 0x13, // "Q" (U+0051)
  0x00, 0x52, 0x00, 0x01, 0x08, 0x0D, 0x08, 0x08, 0x59, // "R" (U+0052)
  0x00, 0x53, 0xFF, 0x01, 0x07, 0x0D, 0x07, 0x08, 0x97, // "S" (U+0053)
  0x00, 0x54, 0x01, 0x01, 0x08, 0x0D, 0x07, 0x08, 0xC5, // "T" (U+0054)
  0x00, 0x55, 0x00, 0x01, 0x09, 0x0D, 0x0A, 0x08, 0xE9, // "U" (U+0055)
  0x00, 0x56, 0x01, 0x01, 0x09, 0x0D, 0x08, 0x09, 0x2B, // "V" (U+0056)
  0x00, 0x57, 0x01, 0x01, 0x0E, 0x0D, 0x0D, 0x09, 0x61, // "W" (U+0057)
  0x00, 0x58, 0xFF, 0x01, 0x08, 0x0D, 0x08, 0x09, 0xC0, // "X" (U+0058)
  0x00, 0x59, 0x01, 0x01, 0x08, 0x0D, 0x07, 0x09, 0xF6, // "Y" (U+0059)
  0x00, 0x5A, 0xFF, 0x01, 0x07, 0x0D, 0x07, 0x0A, 0x23, // "Z" (U+005A)
  0x00, 0x5B, 0xFF, 0xFD, 0x06, 0x0D, 0x05, 0x0A, 0x4C, // "[" (U+005B)
  0x00, 0x5C, 0x01, 0x01, 0x04, 0x0D, 0x06, 0x0A, 0x7A, // "\" (U+005C)
  0x00, 0x5D, 0xFE, 0xFD, 0x05, 0x0D, 0x05, 0x0A, 0x99, // "]" (U+005D)
  0x00, 0x5E, 0x00, 0x07, 0x07, 0x0E, 0x08, 0x0A, 0xC6, // "^" (U+005E)
  0x00, 0x5F, 0xFE, 0xFD, 0x04, 0xFE, 0x06, 0x0A, 0xE4, // "_" (U+005F)
  0x00, 0x60, 0x02, 0x0C, 0x05, 0x0E, 0x05, 0x0A, 0xEB, // "`" (U+0060)
  0x00, 0x61, 0x00, 0x01, 0x08, 0x0A, 0x08, 0x0A, 0xF3, // "a" (U+0061)
  0x00, 0x62, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x0B, 0x25, // "b" (U+0062)
  0x00, 0x63, 0x00, 0x01, 0x06, 0x0A, 0x06, 0x0B, 0x5C, // "c" (U+0063)
  0x00, 0x64, 0x00, 0x01, 0x08, 0x0E, 0x08, 0x0B, 0x7D, // "d" (U+0064)
  0x00, 0x65, 0x00, 0x01, 0x06, 0x0A, 0x08, 0x0B, 0xB8, // "e" (U+0065)
  0x00, 0x66, 0xFD, 0xFD, 0x06, 0x0E, 0x05, 0x0B, 0xDB, // "f" (U+0066)
  0x00, 0x67, 0xFF, 0xFD, 0x08, 0x0A, 0x08, 0x0C, 0x12, // "g" (U+0067)
  0x00, 0x68, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x0C, 0x55, // "h" (U+0068)
  0x00, 0x69, 0x00, 0x01, 0x04, 0x0E, 0x04, 0x0C, 0x8D, // "i" (U+0069)
  0x00, 0x6A, 0xFD, 0xFD, 0x04, 0x0E, 0x04, 0x0C, 0xAF, // "j" (U+006A)
  0x00, 0x6B, 0x00, 0x01, 0x07, 0x0E, 0x07, 0x0C, 0xDD, // "k" (U+006B)
  0x00, 0x6C, 0x00, 0x01, 0x04, 0x0E, 0x04, 0x0D, 0x12, // "l" (U+006C)
  0x00, 0x6D, 0x00, 0x01, 0x0B, 0x0A, 0x0C, 0x0D, 0x37, // "m" (U+006D)
  0x00, 0x6E, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x0D, 0x7B, // "n" (U+006E)
  0x00, 0x6F, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x0D, 0xA8, // "o" (U+006F)
  0x00, 0x70, 0xFF, 0xFD, 0x07, 0x0A, 0x08, 0x0D, 0xD4, // "p" (U+0070)
  0x00, 0x71, 0x00, 0xFD, 0x08, 0x0A, 0x08, 0x0E, 0x0F, // "q" (U+0071)
  0x00, 0x72, 0x00, 0x01, 0x06, 0x0A, 0x06, 0x0E, 0x4A, // "r" (U+0072)
  0x00, 0x73, 0xFF, 0x01, 0x06, 0x0A, 0x06, 0x0E, 0x67, // "s" (U+0073)
  0x00, 0x74, 0x00, 0x01, 0x05, 0x0C, 0x05, 0x0E, 0x88, // "t" (U+0074)
  0x00, 0x75, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x0E, 0xAB, // "u" (U+0075)
  0x00, 0x76, 0x01, 0x01, 0x07, 0x0A, 0x07, 0x0E, 0xD8, // "v" (U+0076)
  0x00, 0x77, 0x01, 0x01, 0x0B, 0x0A, 0x0B, 0x0E, 0xFD, // "w" (U+0077)
  0x00, 0x78, 0xFF, 0x01, 0x07, 0x0A, 0x07, 0x0F, 0x37, // "x" (U+0078)
  0x00, 0x79, 0xFE, 0xFD, 0x07, 0x0A, 0x07, 0x0F, 0x60, // "y" (U+0079)
  0x00, 0x7A, 0xFF, 0x01, 0x06, 0x0A, 0x06, 0x0F, 0x97, // "z" (U+007A)
  0x00, 0x7B, 0x00, 0xFD, 0x06, 0x0D, 0x06, 0x0F, 0xB7, // "{" (U+007B)
  0x00, 0x7C, 0x03, 0xFD, 0x04, 0x0E, 0x08, 0x0F, 0xE7, // "|" (U+007C)
  0x00, 0x7D, 0xFF, 0xFD, 0x05, 0x0D, 0x06, 0x0F, 0xFB, // "}" (U+007D)
  0x00, 0x7E, 0x00, 0x06, 0x08, 0x08, 0x09, 0x10, 0x2C, // "~" (U+007E)
  0x00, 0xA1, 0xFF, 0xFD, 0x03, 0x0A, 0x04, 0x10, 0x39, // "¡" (U+00A1)
  0x00, 0xA2, 0x01, 0x01, 0x07, 0x0D, 0x08, 0x10, 0x59, // "¢" (U+00A2)
  0x00, 0xA3, 0xFF, 0x01, 0x08, 0x0D, 0x08, 0x10, 0x7E, // "£" (U+00A3)
  0x00, 0xA4, 0x01, 0x03, 0x08, 0x0B, 0x09, 0x10, 0xA8, // "¤" (U+00A4)
  0x00, 0xA5, 0x00, 0x01, 0x08, 0x0D, 0x08, 0x10, 0xCE, // "¥" (U+00A5)
  0x00, 0xA6, 0x03, 0xFD, 0x04, 0x0E, 0x08, 0x11, 0x02, // "¦" (U+00A6)
  0x00, 0xA7, 0x00, 0x01, 0x07, 0x0E, 0x07, 0x11, 0x14, // "§" (U+00A7)
  0x00, 0xA8, 0x03, 0x0C, 0x07, 0x0D, 0x09, 0x11, 0x49, // "¨" (U+00A8)
  0x00, 0xA9, 0x00, 0x00, 0x0D, 0x0D, 0x0F, 0x11, 0x4F, // "©" (U+00A9)
  0x00, 0xAA, 0x01, 0x08, 0x06, 0x0D, 0x05, 0x11, 0xA9, // "ª" (U+00AA)
  0x00, 0xAB, 0x00, 0x02, 0x07, 0x09, 0x08, 0x11, 0xBD, // "«" (U+00AB)
  0x00, 0xAC, 0x00, 0x03, 0x07, 0x07, 0x09, 0x11, 0xDE, // "¬" (U+00AC)
  0x00, 0xAE, 0x00, 0x00, 0x0D, 0x0D, 0x0F, 0x11, 0xEA, // "®" (U+00AE)
  0x00, 0xAF, 0x01, 0x0E, 0x08, 0x0F, 0x07, 0x12, 0x4C, // "¯" (U+00AF)
  0x00, 0xB0, 0x00, 0x08, 0x05, 0x0D, 0x07, 0x12, 0x50, // "°" (U+00B0)
  0x00, 0xB1, 0x00, 0x01, 0x08, 0x0B, 0x09, 0x12, 0x64, // "±" (U+00B1)
  0x00, 0xB2, 0x01, 0x08, 0x06, 0x10, 0x05, 0x12, 0x86, // "²" (U+00B2)
  0x00, 0xB3, 0x01, 0x07, 0x06, 0x0F, 0x05, 0x12, 0xA3, // "³" (U+00B3)
  0x00, 0xB4, 0x02, 0x0C, 0x05, 0x0E, 0x05, 0x12, 0xBE, // "´" (U+00B4)
  0x00, 0xB5, 0xFF, 0xFD, 0x07, 0x0A, 0x08, 0x12, 0xC5, // "µ" (U+00B5)
  0x00, 0xB6, 0x01, 0xFE, 0x08, 0x0E, 0x09, 0x13, 0x01, // "¶" (U+00B6)
  0x00, 0xB7, 0x01, 0x06, 0x03, 0x08, 0x04, 0x13, 0x47, // "·" (U+00B7)
  0x00, 0xB8, 0xFE, 0xFD, 0x01, 0x01, 0x03, 0x13, 0x4D, // "¸" (U+00B8)
  0x00, 0xB9, 0x02, 0x08, 0x05, 0x0F, 0x05, 0x13, 0x59, // "¹" (U+00B9)
  0x00, 0xBA, 0x01, 0x08, 0x05, 0x0D, 0x05, 0x13, 0x6C, // "º" (U+00BA)
  0x00, 0xBB, 0x00, 0x02, 0x07, 0x09, 0x08, 0x13, 0x7D, // "»" (U+00BB)
  0x00, 0xBC, 0x01, 0x01, 0x0B, 0x0D, 0x0C, 0x13, 0x9E, // "¼" (U+00BC)
  0x00, 0xBD, 0x01, 0x01, 0x0C, 0x0D, 0x0D, 0x13, 0xE4, // "½" (U+00BD)
  0x00, 0xBE, 0x01, 0x01, 0x0C, 0x0D, 0x0D, 0x14, 0x31, // "¾" (U+00BE)
  0x00, 0xBF, 0xFF, 0xFE, 0x05, 0x0A, 0x06, 0x14, 0x7D, // "¿" (U+00BF)
  0x00, 0xC0, 0xFF, 0x01, 0x07, 0x11, 0x08, 0x14, 0xA3, // "À" (U+00C0)
  0x00, 0xC1, 0xFF, 0x01, 0x08, 0x11, 0x08, 0x14, 0xE0, // "Á" (U+00C1)
  0x00, 0xC2, 0xFF, 0x01, 0x07, 0x11, 0x08, 0x15, 0x1F, // "Â" (U+00C2)
  0x00, 0xC3, 0xFF, 0x01, 0x08, 0x10, 0x08, 0x15, 0x5E, // "Ã" (U+00C3)
  0x00, 0xC4, 0xFF, 0x01, 0x07, 0x10, 0x08, 0x15, 0xA0, // "Ä" (U+00C4)
  0x00, 0xC5, 0xFF, 0x01, 0x08, 0x12, 0x08, 0x15, 0xDC, // "Å" (U+00C5)
  0x00, 0xC6, 0xFF, 0x01, 0x0C, 0x0D, 0x0B, 0x16, 0x22, // "Æ" (U+00C6)
  0x00, 0xC7, 0x00, 0xFD, 0x08, 0x0D, 0x08, 0x16, 0x63, // "Ç" (U+00C7)
  0x00, 0xC8, 0x00, 0x01, 0x07, 0x11, 0x07, 0x16, 0x99, // "È" (U+00C8)
  0x00, 0xC9, 0x00, 0x01, 0x08, 0x11, 0x07, 0x16, 0xCA, // "É" (U+00C9)
  0x00, 0xCA, 0x00, 0x01, 0x07, 0x11, 0x07, 0x16, 0xFB, // "Ê" (U+00CA)
  0x00, 0xCB, 0x00, 0x01, 0x07, 0x10, 0x07, 0x17, 0x2E, // "Ë" (U+00CB)
  0x00, 0xCC, 0xFF, 0x01, 0x06, 0x11, 0x05, 0x17, 0x5E, // "Ì" (U+00CC)
  0x00, 0xCD, 0xFF, 0x01, 0x06, 0x11, 0x05, 0x17, 0x8D, // "Í" (U+00CD)
  0x00, 0xCE, 0xFF, 0x01, 0x06, 0x11, 0x05, 0x17, 0xBC, // "Î" (U+00CE)
  0x00, 0xCF, 0xFF, 0x01, 0x06, 0x10, 0x05, 0x17, 0xED, // "Ï" (U+00CF)
  0x00, 0xD0, 0x00, 0x01, 0x09, 0x0D, 0x09, 0x18, 0x1B, // "Ð" (U+00D0)
  0x00, 0xD1, 0x00, 0x01, 0x0A, 0x10, 0x0A, 0x18, 0x5B, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x00, 0x01, 0x09, 0x11, 0x0A, 0x18, 0xB4, // "Ò" (U+00D2)
  0x00, 0xD3, 0x00, 0x01, 0x09, 0x11, 0x0A, 0x18, 0xFB, // "Ó" (U+00D3)
  0x00, 0xD4, 0x00, 0x01, 0x09, 0x11, 0x0A, 0x19, 0x41, // "Ô" (U+00D4)
  0x00, 0xD5, 0x00, 0x01, 0x09, 0x10, 0x0A, 0x19, 0x89, // "Õ" (U+00D5)
  0x00, 0xD6, 0x00, 0x01, 0x09, 0x10, 0x0A, 0x19, 0xD2, // "Ö" (U+00D6)
  0x00, 0xD7, 0x01, 0x04, 0x07, 0x0A, 0x09, 0x1A, 0x17, // "×" (U+00D7)
  0x00, 0xD8, 0x00, 0x00, 0x0A, 0x0E, 0x0A, 0x1A, 0x32, // "Ø" (U+00D8)
  0x00, 0xD9, 0x00, 0x01, 0x09, 0x11, 0x0A, 0x1A, 0x84, // "Ù" (U+00D9)
  0x00, 0xDA, 0x00, 0x01, 0x09, 0x11, 0x0A, 0x1A, 0xD0, // "Ú" (U+00DA)
  0x00, 0xDB, 0x00, 0x01, 0x09, 0x11, 0x0A, 0x1B, 0x1B, // "Û" (U+00DB)
  0x00, 0xDC, 0x00, 0x01, 0x09, 0x10, 0x0A, 0x1B, 0x68, // "Ü" (U+00DC)
  0x00, 0xDD, 0x01, 0x01, 0x08, 0x11, 0x07, 0x1B, 0xB2, // "Ý" (U+00DD)
  0x00, 0xDE, 0x00, 0x01, 0x07, 0x0D, 0x08, 0x1B, 0xE9, // "Þ" (U+00DE)
  0x00, 0xDF, 0xFD, 0xFD, 0x08, 0x0E, 0x08, 0x1C, 0x18, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x01, 0x08, 0x0E, 0x08, 0x1C, 0x6A, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x08, 0x0E, 0x08, 0x1C, 0xA5, // "á" (U+00E1)
  0x00, 0xE2, 0x00, 0x01, 0x08, 0x0E, 0x08, 0x1C, 0xE0, // "â" (U+00E2)
  0x00, 0xE3, 0x00, 0x01, 0x08, 0x0D, 0x08, 0x1D, 0x1D, // "ã" (U+00E3)
  0x00, 0xE4, 0x00, 0x01, 0x08, 0x0D, 0x08, 0x1D, 0x5B, // "ä" (U+00E4)
  0x00, 0xE5, 0x00, 0x01, 0x08, 0x0F, 0x08, 0x1D, 0x95, // "å" (U+00E5)
  0x00, 0xE6, 0x00, 0x01, 0x0B, 0x0A, 0x0C, 0x1D, 0xD7, // "æ" (U+00E6)
  0x00, 0xE7, 0x00, 0xFD, 0x06, 0x0A, 0x06, 0x1E, 0x17, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x01, 0x06, 0x0E, 0x08, 0x1E, 0x45, // "è" (U+00E8)
  0x00, 0xE9, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x1E, 0x71, // "é" (U+00E9)
  0x00, 0xEA, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x1E, 0xA0, // "ê" (U+00EA)
  0x00, 0xEB, 0x00, 0x01, 0x07, 0x0D, 0x08, 0x1E, 0xD1, // "ë" (U+00EB)
  0x00, 0xEC, 0x00, 0x01, 0x04, 0x0E, 0x04, 0x1E, 0xFF, // "ì" (U+00EC)
  0x00, 0xED, 0x00, 0x01, 0x05, 0x0E, 0x04, 0x1F, 0x23, // "í" (U+00ED)
  0x00, 0xEE, 0x00, 0x01, 0x05, 0x0E, 0x04, 0x1F, 0x47, // "î" (U+00EE)
  0x00, 0xEF, 0x00, 0x01, 0x05, 0x0D, 0x04, 0x1F, 0x6D, // "ï" (U+00EF)
  0x00, 0xF0, 0x00, 0x01, 0x07, 0x0F, 0x08, 0x1F, 0x90, // "ð" (U+00F0)
  0x00, 0xF1, 0x00, 0x01, 0x08, 0x0D, 0x08, 0x1F, 0xCB, // "ñ" (U+00F1)
  0x00, 0xF2, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x20, 0x0B, // "ò" (U+00F2)
  0x00, 0xF3, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x20, 0x40, // "ó" (U+00F3)
  0x00, 0xF4, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x20, 0x75, // "ô" (U+00F4)
  0x00, 0xF5, 0x00, 0x01, 0x07, 0x0D, 0x08, 0x20, 0xAC, // "õ" (U+00F5)
  0x00, 0xF6, 0x00, 0x01, 0x07, 0x0D, 0x08, 0x20, 0xE4, // "ö" (U+00F6)
  0x00, 0xF7, 0x00, 0x03, 0x08, 0x0B, 0x09, 0x21, 0x18, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x00, 0x07, 0x0B, 0x08, 0x21, 0x2E, // "ø" (U+00F8)
  0x00, 0xF9, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x21, 0x5C, // "ù" (U+00F9)
  0x00, 0xFA, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x21, 0x92, // "ú" (U+00FA)
  0x00, 0xFB, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x21, 0xC8, // "û" (U+00FB)
  0x00, 0xFC, 0x00, 0x01, 0x07, 0x0D, 0x08, 0x22, 0x00, // "ü" (U+00FC)
  0x00, 0xFD, 0xFE, 0xFD, 0x07, 0x0E, 0x07, 0x22, 0x35, // "ý" (U+00FD)
  0x00, 0xFE, 0xFF, 0xFD, 0x07, 0x0E, 0x08, 0x22, 0x75, // "þ" (U+00FE)
  0x00, 0xFF, 0xFE, 0xFD, 0x07, 0x0D, 0x07, 0x22, 0xBB, // "ÿ" (U+00FF)
  0x01, 0x00, 0xFF, 0x01, 0x08, 0x0F, 0x08, 0x22, 0xFA, // "Ā" (U+0100)
  0x01, 0x01, 0x00, 0x01, 0x08, 0x0C, 0x08, 0x23, 0x36, // "ā" (U+0101)
  0x01, 0x02, 0xFF, 0x01, 0x07, 0x11, 0x08, 0x23, 0x6E, // "Ă" (U+0102)
  0x01, 0x03, 0x00, 0x01, 0x08, 0x0E, 0x08, 0x23, 0xAF, // "ă" (U+0103)
  0x01, 0x04, 0xFF, 0xFC, 0x06, 0x0D, 0x08, 0x23, 0xEE, // "Ą" (U+0104)
  0x01, 0x05, 0x00, 0xFC, 0x08, 0x0A, 0x08, 0x24, 0x2C, // "ą" (U+0105)
  0x01, 0x06, 0x00, 0x01, 0x08, 0x11, 0x08, 0x24, 0x6B, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x01, 0x07, 0x0E, 0x06, 0x24, 0x9E, // "ć" (U+0107)
  0x01, 0x08, 0x00, 0x01, 0x08, 0x11, 0x08, 0x24, 0xC9, // "Ĉ" (U+0108)
  0x01, 0x09, 0x00, 0x01, 0x06, 0x0E, 0x06, 0x24, 0xFE, // "ĉ" (U+0109)
  0x01, 0x0A, 0x00, 0x01, 0x08, 0x10, 0x08, 0x25, 0x2A, // "Ċ" (U+010A)
  0x01, 0x0B, 0x00, 0x01, 0x06, 0x0D, 0x06, 0x25, 0x59, // "ċ" (U+010B)
  0x01, 0x0C, 0x00, 0x01, 0x09, 0x11, 0x08, 0x25, 0x80, // "Č" (U+010C)
  0x01, 0x0D, 0x00, 0x01, 0x08, 0x0E, 0x06, 0x25, 0xB8, // "č" (U+010D)
  0x01, 0x0E, 0x00, 0x01, 0x09, 0x11, 0x09, 0x25, 0xE6, // "Ď" (U+010E)
  0x01, 0x0F, 0x00, 0x01, 0x0B, 0x0E, 0x0A, 0x26, 0x32, // "ď" (U+010F)
  0x01, 0x10, 0x00, 0x01, 0x09, 0x0D, 0x09, 0x26, 0x75, // "Đ" (U+0110)
  0x01, 0x11, 0x00, 0x01, 0x09, 0x0E, 0x08, 0x26, 0xB5, // "đ" (U+0111)
  0x01, 0x12, 0x00, 0x01, 0x07, 0x0F, 0x07, 0x26, 0xF6, // "Ē" (U+0112)
  0x01, 0x13, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x27, 0x24, // "ē" (U+0113)
  0x01, 0x14, 0x00, 0x01, 0x07, 0x11, 0x07, 0x27, 0x50, // "Ĕ" (U+0114)
  0x01, 0x15, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x27, 0x85, // "ĕ" (U+0115)
  0x01, 0x16, 0x00, 0x01, 0x07, 0x10, 0x07, 0x27, 0xB8, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x01, 0x06, 0x0D, 0x08, 0x27, 0xE5, // "ė" (U+0117)
  0x01, 0x18, 0x00, 0xFC, 0x07, 0x0D, 0x07, 0x28, 0x0D, // "Ę" (U+0118)
  0x01, 0x19, 0x00, 0xFD, 0x07, 0x0A, 0x08, 0x28, 0x42, // "ę" (U+0119)
  0x01, 0x1A, 0x00, 0x01, 0x08, 0x11, 0x07, 0x28, 0x76, // "Ě" (U+011A)
  0x01, 0x1B, 0x00, 0x01, 0x08, 0x0E, 0x08, 0x28, 0xA9, // "ě" (U+011B)
  0x01, 0x1C, 0x00, 0x01, 0x09, 0x11, 0x0A, 0x28, 0xDB, // "Ĝ" (U+011C)
  0x01, 0x1D, 0xFF, 0xFD, 0x08, 0x0E, 0x08, 0x29, 0x1F, // "ĝ" (U+011D)
  0x01, 0x1E, 0x00, 0x01, 0x09, 0x11, 0x0A, 0x29, 0x6D, // "Ğ" (U+011E)
  0x01, 0x1F, 0xFF, 0xFD, 0x08, 0x0E, 0x08, 0x29, 0xB3, // "ğ" (U+011F)
  0x01, 0x20, 0x00, 0x01, 0x09, 0x10, 0x0A, 0x2A, 0x03, // "Ġ" (U+0120)
  0x01, 0x21, 0xFF, 0xFD, 0x08, 0x0D, 0x08, 0x2A, 0x43, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0xFD, 0x09, 0x0D, 0x0A, 0x2A, 0x8C, // "Ģ" (U+0122)
  0x01, 0x23, 0xFF, 0xFD, 0x08, 0x0E, 0x08, 0x2A, 0xCE, // "ģ" (U+0123)
  0x01, 0x24, 0x00, 0x01, 0x09, 0x11, 0x0A, 0x2B, 0x1A, // "Ĥ" (U+0124)
  0x01, 0x25, 0x00, 0x01, 0x07, 0x12, 0x08, 0x2B, 0x65, // "ĥ" (U+0125)
  0x01, 0x26, 0x00, 0x01, 0x0A, 0x0D, 0x0A, 0x2B, 0xA8, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x2B, 0xEB, // "ħ" (U+0127)
  0x01, 0x28, 0xFF, 0x01, 0x07, 0x10, 0x05, 0x2C, 0x23, // "Ĩ" (U+0128)
  0x01, 0x29, 0x00, 0x01, 0x05, 0x0D, 0x04, 0x2C, 0x55, // "ĩ" (U+0129)
  0x01, 0x2A, 0xFF, 0x01, 0x06, 0x0F, 0x05, 0x2C, 0x7A, // "Ī" (U+012A)
  0x01, 0x2B, 0x00, 0x01, 0x05, 0x0C, 0x04, 0x2C, 0xA6, // "ī" (U+012B)
  0x01, 0x2C, 0xFF, 0x01, 0x06, 0x11, 0x05, 0x2C, 0xC8, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x00, 0x01, 0x05, 0x0E, 0x04, 0x2C, 0xFB, // "ĭ" (U+012D)
  0x01, 0x2E, 0xFF, 0xFC, 0x06, 0x0D, 0x05, 0x2D, 0x22, // "Į" (U+012E)
  0x01, 0x2F, 0xFF, 0xFC, 0x04, 0x0E, 0x04, 0x2D, 0x55, // "į" (U+012F)
  0x01, 0x30, 0xFF, 0x01, 0x06, 0x10, 0x05, 0x2D, 0x84, // "İ" (U+0130)
  0x01, 0x31, 0x00, 0x01, 0x03, 0x0A, 0x04, 0x2D, 0xAF, // "ı" (U+0131)
  0x01, 0x32, 0xFF, 0xFD, 0x09, 0x0D, 0x09, 0x2D, 0xC5, // "Ĳ" (U+0132)
  0x01, 0x33, 0x00, 0xFD, 0x08, 0x0E, 0x08, 0x2E, 0x17, // "ĳ" (U+0133)
  0x01, 0x34, 0xFD, 0xFD, 0x05, 0x11, 0x04, 0x2E, 0x60, // "Ĵ" (U+0134)
  0x01, 0x35, 0xFD, 0xFD, 0x05, 0x0E, 0x04, 0x2E, 0x99, // "ĵ" (U+0135)
  0x01, 0x36, 0x00, 0xFD, 0x09, 0x0D, 0x08, 0x2E, 0xCB, // "Ķ" (U+0136)
  0x01, 0x37, 0x00, 0xFD, 0x07, 0x0E, 0x07, 0x2F, 0x0F, // "ķ" (U+0137)
  0x01, 0x38, 0x00, 0x01, 0x07, 0x0A, 0x07, 0x2F, 0x4C, // "ĸ" (U+0138)
  0x01, 0x39, 0x00, 0x01, 0x07, 0x11, 0x07, 0x2F, 0x77, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x00, 0x01, 0x06, 0x12, 0x04, 0x2F, 0xA5, // "ĺ" (U+013A)
  0x01, 0x3B, 0x00, 0xFD, 0x05, 0x0D, 0x07, 0x2F, 0xD3, // "Ļ" (U+013B)
  0x01, 0x3C, 0xFF, 0xFD, 0x04, 0x0E, 0x04, 0x2F, 0xFF, // "ļ" (U+013C)
  0x01, 0x3D, 0x00, 0x01, 0x07, 0x0D, 0x07, 0x30, 0x2C, // "Ľ" (U+013D)
  0x01, 0x3E, 0x00, 0x01, 0x07, 0x0E, 0x05, 0x30, 0x55, // "ľ" (U+013E)
  0x01, 0x3F, 0x00, 0x01, 0x05, 0x0D, 0x07, 0x30, 0x7F, // "Ŀ" (U+013F)
  0x01, 0x40, 0x00, 0x01, 0x05, 0x0E, 0x05, 0x30, 0xA4, // "ŀ" (U+0140)
  0x01, 0x41, 0x00, 0x01, 0x05, 0x0D, 0x07, 0x30, 0xCB, // "Ł" (U+0141)
  0x01, 0x42, 0x00, 0x01, 0x04, 0x0E, 0x04, 0x30, 0xF0, // "ł" (U+0142)
  0x01, 0x43, 0x00, 0x01, 0x0A, 0x11, 0x0A, 0x31, 0x14, // "Ń" (U+0143)
  0x01, 0x44, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x31, 0x6A, // "ń" (U+0144)
  0x01, 0x45, 0x00, 0xFD, 0x0A, 0x0D, 0x0A, 0x31, 0xA0, // "Ņ" (U+0145)
  0x01, 0x46, 0x00, 0xFD, 0x07, 0x0A, 0x08, 0x31, 0xF6, // "ņ" (U+0146)
  0x01, 0x47, 0x00, 0x01, 0x0A, 0x11, 0x0A, 0x32, 0x2B, // "Ň" (U+0147)
  0x01, 0x48, 0x00, 0x01, 0x08, 0x0E, 0x08, 0x32, 0x83, // "ň" (U+0148)
  0x01, 0x49, 0x00, 0x01, 0x08, 0x0D, 0x09, 0x32, 0xC2, // "ŉ" (U+0149)
  0x01, 0x4A, 0x00, 0xFD, 0x0A, 0x0D, 0x0A, 0x33, 0x00, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x00, 0xFD, 0x07, 0x0A, 0x08, 0x33, 0x57, // "ŋ" (U+014B)
  0x01, 0x4C, 0x00, 0x01, 0x09, 0x0F, 0x0A, 0x33, 0x90, // "Ō" (U+014C)
  0x01, 0x4D, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x33, 0xD3, // "ō" (U+014D)
  0x01, 0x4E, 0x00, 0x01, 0x09, 0x11, 0x0A, 0x34, 0x05, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x34, 0x4E, // "ŏ" (U+014F)
  0x01, 0x50, 0x00, 0x01, 0x0B, 0x11, 0x0A, 0x34, 0x87, // "Ő" (U+0150)
  0x01, 0x51, 0x00, 0x01, 0x09, 0x0E, 0x08, 0x34, 0xD7, // "ő" (U+0151)
  0x01, 0x52, 0x00, 0x01, 0x0C, 0x0D, 0x0C, 0x35, 0x17, // "Œ" (U+0152)
  0x01, 0x53, 0x00, 0x01, 0x0C, 0x0A, 0x0D, 0x35, 0x5E, // "œ" (U+0153)
  0x01, 0x54, 0x00, 0x01, 0x08, 0x11, 0x08, 0x35, 0xA1, // "Ŕ" (U+0154)
  0x01, 0x55, 0x00, 0x01, 0x06, 0x0E, 0x06, 0x35, 0xE8, // "ŕ" (U+0155)
  0x01, 0x56, 0x00, 0xFD, 0x08, 0x0D, 0x08, 0x36, 0x0E, // "Ŗ" (U+0156)
  0x01, 0x57, 0xFF, 0xFD, 0x06, 0x0A, 0x06, 0x36, 0x54, // "ŗ" (U+0157)
  0x01, 0x58, 0x00, 0x01, 0x08, 0x11, 0x08, 0x36, 0x7A, // "Ř" (U+0158)
  0x01, 0x59, 0x00, 0x01, 0x07, 0x0E, 0x06, 0x36, 0xC3, // "ř" (U+0159)
  0x01, 0x5A, 0xFF, 0x01, 0x08, 0x11, 0x07, 0x36, 0xEC, // "Ś" (U+015A)
  0x01, 0x5B, 0xFF, 0x01, 0x06, 0x0E, 0x06, 0x37, 0x25, // "ś" (U+015B)
  0x01, 0x5C, 0xFF, 0x01, 0x07, 0x11, 0x07, 0x37, 0x4F, // "Ŝ" (U+015C)
  0x01, 0x5D, 0xFF, 0x01, 0x06, 0x0E, 0x06, 0x37, 0x88, // "ŝ" (U+015D)
  0x01, 0x5E, 0xFF, 0xFD, 0x07, 0x0D, 0x07, 0x37, 0xB4, // "Ş" (U+015E)
  0x01, 0x5F, 0xFF, 0xFD, 0x06, 0x0A, 0x06, 0x37, 0xEF, // "ş" (U+015F)
  0x01, 0x60, 0xFF, 0x01, 0x08, 0x11, 0x07, 0x38, 0x1D, // "Š" (U+0160)
  0x01, 0x61, 0xFF, 0x01, 0x07, 0x0E, 0x06, 0x38, 0x58, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFD, 0x08, 0x0D, 0x07, 0x38, 0x85, // "Ţ" (U+0162)
  0x01, 0x63, 0xFF, 0xFD, 0x05, 0x0C, 0x05, 0x38, 0xB7, // "ţ" (U+0163)
  0x01, 0x64, 0x01, 0x01, 0x08, 0x11, 0x07, 0x38, 0xE6, // "Ť" (U+0164)
  0x01, 0x65, 0x00, 0x01, 0x07, 0x0E, 0x05, 0x39, 0x16, // "ť" (U+0165)
  0x01, 0x66, 0x01, 0x01, 0x08, 0x0D, 0x07, 0x39, 0x40, // "Ŧ" (U+0166)
  0x01, 0x67, 0x00, 0x01, 0x05, 0x0C, 0x05, 0x39, 0x66, // "ŧ" (U+0167)
  0x01, 0x68, 0x00, 0x01, 0x09, 0x10, 0x0A, 0x39, 0x8A, // "Ũ" (U+0168)
  0x01, 0x69, 0x00, 0x01, 0x08, 0x0D, 0x08, 0x39, 0xD8, // "ũ" (U+0169)
  0x01, 0x6A, 0x00, 0x01, 0x09, 0x0F, 0x0A, 0x3A, 0x16, // "Ū" (U+016A)
  0x01, 0x6B, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x3A, 0x5E, // "ū" (U+016B)
  0x01, 0x6C, 0x00, 0x01, 0x09, 0x11, 0x0A, 0x3A, 0x91, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x3A, 0xE0, // "ŭ" (U+016D)
  0x01, 0x6E, 0x00, 0x01, 0x09, 0x12, 0x0A, 0x3B, 0x1A, // "Ů" (U+016E)
  0x01, 0x6F, 0x00, 0x01, 0x07, 0x0F, 0x08, 0x3B, 0x6D, // "ů" (U+016F)
  0x01, 0x70, 0x00, 0x01, 0x0B, 0x11, 0x0A, 0x3B, 0xAA, // "Ű" (U+0170)
  0x01, 0x71, 0x00, 0x01, 0x09, 0x0E, 0x08, 0x3B, 0xFC, // "ű" (U+0171)
  0x01, 0x72, 0x00, 0xFC, 0x09, 0x0D, 0x0A, 0x3C, 0x3B, // "Ų" (U+0172)
  0x01, 0x73, 0x00, 0xFC, 0x07, 0x0A, 0x08, 0x3C, 0x8B, // "ų" (U+0173)
  0x01, 0x74, 0x01, 0x01, 0x0E, 0x11, 0x0D, 0x3C, 0xC5, // "Ŵ" (U+0174)
  0x01, 0x75, 0x01, 0x01, 0x0B, 0x0E, 0x0B, 0x3D, 0x31, // "ŵ" (U+0175)
  0x01, 0x76, 0x01, 0x01, 0x08, 0x11, 0x07, 0x3D, 0x77, // "Ŷ" (U+0176)
  0x01, 0x77, 0xFE, 0xFD, 0x07, 0x0E, 0x07, 0x3D, 0xB0, // "ŷ" (U+0177)
  0x01, 0x78, 0x01, 0x01, 0x08, 0x10, 0x07, 0x3D, 0xF2, // "Ÿ" (U+0178)
  0x01, 0x79, 0xFF, 0x01, 0x07, 0x11, 0x07, 0x3E, 0x28, // "Ź" (U+0179)
  0x01, 0x7A, 0xFF, 0x01, 0x06, 0x0E, 0x06, 0x3E, 0x5A, // "ź" (U+017A)
  0x01, 0x7B, 0xFF, 0x01, 0x07, 0x10, 0x07, 0x3E, 0x83, // "Ż" (U+017B)
  0x01, 0x7C, 0xFF, 0x01, 0x06, 0x0D, 0x06, 0x3E, 0xB2, // "ż" (U+017C)
  0x01, 0x7D, 0xFF, 0x01, 0x08, 0x11, 0x07, 0x3E, 0xD8, // "Ž" (U+017D)
  0x01, 0x7E, 0xFF, 0x01, 0x07, 0x0E, 0x06, 0x3F, 0x0D, // "ž" (U+017E)
  0x01, 0x7F, 0xFD, 0xFD, 0x06, 0x0E, 0x04, 0x3F, 0x39, // "ſ" (U+017F)
  0x03, 0xA9, 0xFF, 0x01, 0x09, 0x0D, 0x0A, 0x3F, 0x6F, // "Ω" (U+03A9)
  0x03, 0xBC, 0xFF, 0xFD, 0x07, 0x0A, 0x08, 0x3F, 0xB3, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x01, 0x09, 0x0A, 0x09, 0x3F, 0xEF, // "π" (U+03C0)
  0x20, 0x13, 0x00, 0x05, 0x07, 0x06, 0x08, 0x40, 0x21, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x05, 0x0F, 0x06, 0x11, 0x40, 0x28, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x01, 0x08, 0x0D, 0x08, 0x40, 0x30, // "€" (U+20AC)
  0x20, 0xBF, 0x00, 0xFF, 0x07, 0x0F, 0x08, 0x40, 0x5E, // "₿" (U+20BF)
  0x20, 0x18, 0x01, 0x09, 0x04, 0x0D, 0x03, 0x40, 0xA4, // "‘" (U+2018)
  0x20, 0x19, 0x01, 0x09, 0x04, 0x0D, 0x03, 0x40, 0xB0, // "’" (U+2019)
  0x20, 0x1A, 0xFF, 0xFF, 0x02, 0x03, 0x04, 0x40, 0xBC, // "‚" (U+201A)
  0x20, 0x1B, 0x01, 0x0A, 0x03, 0x0D, 0x03, 0x40, 0xC7, // "‛" (U+201B)
  0x20, 0x1C, 0x01, 0x0A, 0x07, 0x0D, 0x06, 0x40, 0xCF, // "“" (U+201C)
  0x20, 0x1D, 0x01, 0x0A, 0x07, 0x0D, 0x06, 0x40, 0xDE, // "”" (U+201D)
  0x20, 0x1E, 0xFF, 0xFF, 0x04, 0x02, 0x06, 0x40, 0xED, // "„" (U+201E)
  0x20, 0x1F, 0x01, 0x0A, 0x06, 0x0D, 0x06, 0x40, 0xFB, // "‟" (U+201F)
  0x20, 0x20, 0x01, 0x01, 0x07, 0x0E, 0x08, 0x41, 0x09, // "†" (U+2020)
  0x20, 0x21, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x41, 0x31, // "‡" (U+2021)
  0x20, 0x22, 0x01, 0x05, 0x05, 0x09, 0x06, 0x41, 0x5E, // "•" (U+2022)
  0x20, 0x26, 0x00, 0x01, 0x0A, 0x03, 0x0C, 0x41, 0x6C, // "…" (U+2026)
  0x20, 0x30, 0x01, 0x01, 0x10, 0x0D, 0x11, 0x41, 0x7E, // "‰" (U+2030)
  0x20, 0x39, 0x00, 0x02, 0x04, 0x09, 0x05, 0x41, 0xE4, // "‹" (U+2039)
  0x20, 0x3A, 0x00, 0x02, 0x03, 0x09, 0x05, 0x41, 0xF9, // "›" (U+203A)
  0x20, 0x44, 0xFC, 0x01, 0x06, 0x0D, 0x02, 0x42, 0x0B, // "⁄" (U+2044)
  0x21, 0x22, 0x00, 0x07, 0x0A, 0x0D, 0x0C, 0x42, 0x35, // "™" (U+2122)
  0x21, 0x52, 0x01, 0x01, 0x11, 0x0D, 0x11, 0x42, 0x60, // "⅒" (U+2152)
  0xFB, 0x01, 0xFD, 0xFD, 0x09, 0x0E, 0x08, 0x42, 0xC3, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0xFD, 0xFD, 0x09, 0x0E, 0x08, 0x43, 0x17, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x01, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0x61, 0x01, // "a (U+0022 U+0061)
  0x00, 0x22, 0x00, 0x63, 0x01, // "c (U+0022 U+0063)
  0x00, 0x22, 0x00, 0x64, 0x01, // "d (U+0022 U+0064)
  0x00, 0x22, 0x00, 0x65, 0x01, // "e (U+0022 U+0065)
  0x00, 0x22, 0x00, 0x67, 0x01, // "g (U+0022 U+0067)
  0x00, 0x22, 0x00, 0x6D, 0x01, // "m (U+0022 U+006D)
  0x00, 0x22, 0x00, 0x6E, 0x01, // "n (U+0022 U+006E)
  0x00, 0x22, 0x00, 0x6F, 0x01, // "o (U+0022 U+006F)
  0x00, 0x22, 0x00, 0x70, 0x01, // "p (U+0022 U+0070)
  0x00, 0x22, 0x00, 0x71, 0x01, // "q (U+0022 U+0071)
  0x00, 0x22, 0x00, 0x72, 0x01, // "r (U+0022 U+0072)
  0x00, 0x22, 0x00, 0x73, 0x01, // "s (U+0022 U+0073)
  0x00, 0x22, 0x00, 0x75, 0x01, // "u (U+0022 U+0075)
  0x00, 0x22, 0x00, 0xC0, 0x01, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x01, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x01, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x01, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x01, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x01, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xE0, 0x01, // "à (U+0022 U+00E0)
  0x00, 0x22, 0x00, 0xE1, 0x01, // "á (U+0022 U+00E1)
  0x00, 0x22, 0x00, 0xE2, 0x01, // "â (U+0022 U+00E2)
  0x00, 0x22, 0x00, 0xE3, 0x01, // "ã (U+0022 U+00E3)
  0x00, 0x22, 0x00, 0xE4, 0x01, // "ä (U+0022 U+00E4)
  0x00, 0x22, 0x00, 0xE5, 0x01, // "å (U+0022 U+00E5)
  0x00, 0x22, 0x00, 0xE6, 0x01, // "æ (U+0022 U+00E6)
  0x00, 0x22, 0x00, 0xE7, 0x01, // "ç (U+0022 U+00E7)
  0x00, 0x22, 0x00, 0xE8, 0x01, // "è (U+0022 U+00E8)
  0x00, 0x22, 0x00, 0xE9, 0x01, // "é (U+0022 U+00E9)
  0x00, 0x22, 0x00, 0xEA, 0x01, // "ê (U+0022 U+00EA)
  0x00, 0x22, 0x00, 0xEB, 0x01, // "ë (U+0022 U+00EB)
  0x00, 0x22, 0x00, 0xF1, 0x01, // "ñ (U+0022 U+00F1)
  0x00, 0x22, 0x00, 0xF2, 0x01, // "ò (U+0022 U+00F2)
  0x00, 0x22, 0x00, 0xF3, 0x01, // "ó (U+0022 U+00F3)
  0x00, 0x22, 0x00, 0xF4, 0x01, // "ô (U+0022 U+00F4)
  0x00, 0x22, 0x00, 0xF5, 0x01, // "õ (U+0022 U+00F5)
  0x00, 0x22, 0x00, 0xF6, 0x01, // "ö (U+0022 U+00F6)
  0x00, 0x22, 0x00, 0xF8, 0x01, // "ø (U+0022 U+00F8)
  0x00, 0x22, 0x00, 0xF9, 0x01, // "ù (U+0022 U+00F9)
  0x00, 0x22, 0x00, 0xFA, 0x01, // "ú (U+0022 U+00FA)
  0x00, 0x22, 0x00, 0xFB, 0x01, // "û (U+0022 U+00FB)
  0x00, 0x22, 0x00, 0xFC, 0x01, // "ü (U+0022 U+00FC)
  0x00, 0x22, 0x01, 0x00, 0x01, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x01, 0x01, // "ā (U+0022 U+0101)
  0x00, 0x22, 0x01, 0x02, 0x01, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x03, 0x01, // "ă (U+0022 U+0103)
  0x00, 0x22, 0x01, 0x04, 0x01, // "Ą (U+0022 U+0104)
  0x00, 0x22, 0x01, 0x05, 0x01, // "ą (U+0022 U+0105)
  0x00, 0x22, 0x01, 0x07, 0x01, // "ć (U+0022 U+0107)
  0x00, 0x22, 0x01, 0x09, 0x01, // "ĉ (U+0022 U+0109)
  0x00, 0x22, 0x01, 0x0B, 0x01, // "ċ (U+0022 U+010B)
  0x00, 0x22, 0x01, 0x0D, 0x01, // "č (U+0022 U+010D)
  0x00, 0x22, 0x01, 0x0F, 0x01, // "ď (U+0022 U+010F)
  0x00, 0x22, 0x01, 0x11, 0x01, // "đ (U+0022 U+0111)
  0x00, 0x22, 0x01, 0x13, 0x01, // "ē (U+0022 U+0113)
  0x00, 0x22, 0x01, 0x15, 0x01, // "ĕ (U+0022 U+0115)
  0x00, 0x22, 0x01, 0x17, 0x01, // "ė (U+0022 U+0117)
  0x00, 0x22, 0x01, 0x19, 0x01, // "ę (U+0022 U+0119)
  0x00, 0x22, 0x01, 0x1B, 0x01, // "ě (U+0022 U+011B)
  0x00, 0x22, 0x01, 0x1D, 0x01, // "ĝ (U+0022 U+011D)
  0x00, 0x22, 0x01, 0x1F, 0x01, // "ğ (U+0022 U+011F)
  0x00, 0x22, 0x01, 0x21, 0x01, // "ġ (U+0022 U+0121)
  0x00, 0x22, 0x01, 0x23, 0x01, // "ģ (U+0022 U+0123)
  0x00, 0x22, 0x01, 0x38, 0x01, // "ĸ (U+0022 U+0138)
  0x00, 0x22, 0x01, 0x44, 0x01, // "ń (U+0022 U+0144)
  0x00, 0x22, 0x01, 0x46, 0x01, // "ņ (U+0022 U+0146)
  0x00, 0x22, 0x01, 0x48, 0x01, // "ň (U+0022 U+0148)
  0x00, 0x22, 0x01, 0x4B, 0x01, // "ŋ (U+0022 U+014B)
  0x00, 0x22, 0x01, 0x4D, 0x01, // "ō (U+0022 U+014D)
  0x00, 0x22, 0x01, 0x4F, 0x01, // "ŏ (U+0022 U+014F)
  0x00, 0x22, 0x01, 0x51, 0x01, // "ő (U+0022 U+0151)
  0x00, 0x22, 0x01, 0x53, 0x01, // "œ (U+0022 U+0153)
  0x00, 0x22, 0x01, 0x55, 0x01, // "ŕ (U+0022 U+0155)
  0x00, 0x22, 0x01, 0x57, 0x01, // "ŗ (U+0022 U+0157)
  0x00, 0x22, 0x01, 0x5B, 0x01, // "ś (U+0022 U+015B)
  0x00, 0x22, 0x01, 0x5D, 0x01, // "ŝ (U+0022 U+015D)
  0x00, 0x22, 0x01, 0x5F, 0x01, // "ş (U+0022 U+015F)
  0x00, 0x22, 0x01, 0x61, 0x01, // "š (U+0022 U+0161)
  0x00, 0x22, 0x01, 0x69, 0x01, // "ũ (U+0022 U+0169)
  0x00, 0x22, 0x01, 0x6B, 0x01, // "ū (U+0022 U+016B)
  0x00, 0x22, 0x01, 0x6D, 0x01, // "ŭ (U+0022 U+016D)
  0x00, 0x22, 0x01, 0x6F, 0x01, // "ů (U+0022 U+016F)
  0x00, 0x22, 0x01, 0x71, 0x01, // "ű (U+0022 U+0171)
  0x00, 0x22, 0x01, 0x73, 0x01, // "ų (U+0022 U+0173)
  0x00, 0x26, 0x00, 0x54, 0x01, // &T (U+0026 U+0054)
  0x00, 0x26, 0x00, 0x56, 0x01, // &V (U+0026 U+0056)
  0x00, 0x26, 0x00, 0x57, 0x01, // &W (U+0026 U+0057)
  0x00, 0x26, 0x00, 0x59, 0x01, // &Y (U+0026 U+0059)
  0x00, 0x26, 0x00, 0xDD, 0x01, // &Ý (U+0026 U+00DD)
  0x00, 0x26, 0x01, 0x62, 0x01, // &Ţ (U+0026 U+0162)
  0x00, 0x26, 0x01, 0x64, 0x01, // &Ť (U+0026 U+0164)
  0x00, 0x26, 0x01, 0x66, 0x01, // &Ŧ (U+0026 U+0166)
  0x00, 0x26, 0x01, 0x74, 0x01, // &Ŵ (U+0026 U+0174)
  0x00, 0x26, 0x01, 0x76, 0x01, // &Ŷ (U+0026 U+0176)
  0x00, 0x26, 0x01, 0x78, 0x01, // &Ÿ (U+0026 U+0178)
  0x00, 0x27, 0x00, 0x41, 0x01, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0x61, 0x01, // 'a (U+0027 U+0061)
  0x00, 0x27, 0x00, 0x63, 0x01, // 'c (U+0027 U+0063)
  0x00, 0x27, 0x00, 0x64, 0x01, // 'd (U+0027 U+0064)
  0x00, 0x27, 0x00, 0x65, 0x01, // 'e (U+0027 U+0065)
  0x00, 0x27, 0x00, 0x67, 0x01, // 'g (U+0027 U+0067)
  0x00, 0x27, 0x00, 0x6D, 0x01, // 'm (U+0027 U+006D)
  0x00, 0x27, 0x00, 0x6E, 0x01, // 'n (U+0027 U+006E)
  0x00, 0x27, 0x00, 0x6F, 0x01, // 'o (U+0027 U+006F)
  0x00, 0x27, 0x00, 0x70, 0x01, // 'p (U+0027 U+0070)
  0x00, 0x27, 0x00, 0x71, 0x01, // 'q (U+0027 U+0071)
  0x00, 0x27, 0x00, 0x72, 0x01, // 'r (U+0027 U+0072)
  0x00, 0x27, 0x00, 0x73, 0x01, // 's (U+0027 U+0073)
  0x00, 0x27, 0x00, 0x75, 0x01, // 'u (U+0027 U+0075)
  0x00, 0x27, 0x00, 0xC0, 0x01, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x01, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x01, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x01, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x01, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x01, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xE0, 0x01, // 'à (U+0027 U+00E0)
  0x00, 0x27, 0x00, 0xE1, 0x01, // 'á (U+0027 U+00E1)
  0x00, 0x27, 0x00, 0xE2, 0x01, // 'â (U+0027 U+00E2)
  0x00, 0x27, 0x00, 0xE3, 0x01, // 'ã (U+0027 U+00E3)
  0x00, 0x27, 0x00, 0xE4, 0x01, // 'ä (U+0027 U+00E4)
  0x00, 0x27, 0x00, 0xE5, 0x01, // 'å (U+0027 U+00E5)
  0x00, 0x27, 0x00, 0xE6, 0x01, // 'æ (U+0027 U+00E6)
  0x00, 0x27, 0x00, 0xE7, 0x01, // 'ç (U+0027 U+00E7)
  0x00, 0x27, 0x00, 0xE8, 0x01, // 'è (U+0027 U+00E8)
  0x00, 0x27, 0x00, 0xE9, 0x01, // 'é (U+0027 U+00E9)
  0x00, 0x27, 0x00, 0xEA, 0x01, // 'ê (U+0027 U+00EA)
  0x00, 0x27, 0x00, 0xEB, 0x01, // 'ë (U+0027 U+00EB)
  0x00, 0x27, 0x00, 0xF1, 0x01, // 'ñ (U+0027 U+00F1)
  0x00, 0x27, 0x00, 0xF2, 0x01, // 'ò (U+0027 U+00F2)
  0x00, 0x27, 0x00, 0xF3, 0x01, // 'ó (U+0027 U+00F3)
  0x00, 0x27, 0x00, 0xF4, 0x01, // 'ô (U+0027 U+00F4)
  0x00, 0x27, 0x00, 0xF5, 0x01, // 'õ (U+0027 U+00F5)
  0x00, 0x27, 0x00, 0xF6, 0x01, // 'ö (U+0027 U+00F6)
  0x00, 0x27, 0x00, 0xF8, 0x01, // 'ø (U+0027 U+00F8)
  0x00, 0x27, 0x00, 0xF9, 0x01, // 'ù (U+0027 U+00F9)
  0x00, 0x27, 0x00, 0xFA, 0x01, // 'ú (U+0027 U+00FA)
  0x00, 0x27, 0x00, 0xFB, 0x01, // 'û (U+0027 U+00FB)
  0x00, 0x27, 0x00, 0xFC, 0x01, // 'ü (U+0027 U+00FC)
  0x00, 0x27, 0x01, 0x00, 0x01, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x01, 0x01, // 'ā (U+0027 U+0101)
  0x00, 0x27, 0x01, 0x02, 0x01, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x03, 0x01, // 'ă (U+0027 U+0103)
  0x00, 0x27, 0x01, 0x04, 0x01, // 'Ą (U+0027 U+0104)
  0x00, 0x27, 0x01, 0x05, 0x01, // 'ą (U+0027 U+0105)
  0x00, 0x27, 0x01, 0x07, 0x01, // 'ć (U+0027 U+0107)
  0x00, 0x27, 0x01, 0x09, 0x01, // 'ĉ (U+0027 U+0109)
  0x00, 0x27, 0x01, 0x0B, 0x01, // 'ċ (U+0027 U+010B)
  0x00, 0x27, 0x01, 0x0D, 0x01, // 'č (U+0027 U+010D)
  0x00, 0x27, 0x01, 0x0F, 0x01, // 'ď (U+0027 U+010F)
  0x00, 0x27, 0x01, 0x11, 0x01, // 'đ (U+0027 U+0111)
  0x00, 0x27, 0x01, 0x13, 0x01, // 'ē (U+0027 U+0113)
  0x00, 0x27, 0x01, 0x15, 0x01, // 'ĕ (U+0027 U+0115)
  0x00, 0x27, 0x01, 0x17, 0x01, // 'ė (U+0027 U+0117)
  0x00, 0x27, 0x01, 0x19, 0x01, // 'ę (U+0027 U+0119)
  0x00, 0x27, 0x01, 0x1B, 0x01, // 'ě (U+0027 U+011B)
  0x00, 0x27, 0x01, 0x1D, 0x01, // 'ĝ (U+0027 U+011D)
  0x00, 0x27, 0x01, 0x1F, 0x01, // 'ğ (U+0027 U+011F)
  0x00, 0x27, 0x01, 0x21, 0x01, // 'ġ (U+0027 U+0121)
  0x00, 0x27, 0x01, 0x23, 0x01, // 'ģ (U+0027 U+0123)
  0x00, 0x27, 0x01, 0x38, 0x01, // 'ĸ (U+0027 U+0138)
  0x00, 0x27, 0x01, 0x44, 0x01, // 'ń (U+0027 U+0144)
  0x00, 0x27, 0x01, 0x46, 0x01, // 'ņ (U+0027 U+0146)
  0x00, 0x27, 0x01, 0x48, 0x01, // 'ň (U+0027 U+0148)
  0x00, 0x27, 0x01, 0x4B, 0x01, // 'ŋ (U+0027 U+014B)
  0x00, 0x27, 0x01, 0x4D, 0x01, // 'ō (U+0027 U+014D)
  0x00, 0x27, 0x01, 0x4F, 0x01, // 'ŏ (U+0027 U+014F)
  0x00, 0x27, 0x01, 0x51, 0x01, // 'ő (U+0027 U+0151)
  0x00, 0x27, 0x01, 0x53, 0x01, // 'œ (U+0027 U+0153)
  0x00, 0x27, 0x01, 0x55, 0x01, // 'ŕ (U+0027 U+0155)
  0x00, 0x27, 0x01, 0x57, 0x01, // 'ŗ (U+0027 U+0157)
  0x00, 0x27, 0x01, 0x5B, 0x01, // 'ś (U+0027 U+015B)
  0x00, 0x27, 0x01, 0x5D, 0x01, // 'ŝ (U+0027 U+015D)
  0x00, 0x27, 0x01, 0x5F, 0x01, // 'ş (U+0027 U+015F)
  0x00, 0x27, 0x01, 0x61, 0x01, // 'š (U+0027 U+0161)
  0x00, 0x27, 0x01, 0x69, 0x01, // 'ũ (U+0027 U+0169)
  0x00, 0x27, 0x01, 0x6B, 0x01, // 'ū (U+0027 U+016B)
  0x00, 0x27, 0x01, 0x6D, 0x01, // 'ŭ (U+0027 U+016D)
  0x00, 0x27, 0x01, 0x6F, 0x01, // 'ů (U+0027 U+016F)
  0x00, 0x27, 0x01, 0x71, 0x01, // 'ű (U+0027 U+0171)
  0x00, 0x27, 0x01, 0x73, 0x01, // 'ų (U+0027 U+0173)
  0x00, 0x2C, 0x00, 0x43, 0x01, // ,C (U+002C U+0043)
  0x00, 0x2C, 0x00, 0x47, 0x01, // ,G (U+002C U+0047)
  0x00, 0x2C, 0x00, 0x4F, 0x01, // ,O (U+002C U+004F)
  0x00, 0x2C, 0x00, 0x51, 0x01, // ,Q (U+002C U+0051)
  0x00, 0x2C, 0x00, 0x54, 0x01, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x56, 0x01, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x01, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x01, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0xC7, 0x01, // ,Ç (U+002C U+00C7)
  0x00, 0x2C, 0x00, 0xD2, 0x01, // ,Ò (U+002C U+00D2)
  0x00, 0x2C, 0x00, 0xD3, 0x01, // ,Ó (U+002C U+00D3)
  0x00, 0x2C, 0x00, 0xD4, 0x01, // ,Ô (U+002C U+00D4)
  0x00, 0x2C, 0x00, 0xD5, 0x01, // ,Õ (U+002C U+00D5)
  0x00, 0x2C, 0x00, 0xD6, 0x01, // ,Ö (U+002C U+00D6)
  0x00, 0x2C, 0x00, 0xD8, 0x01, // ,Ø (U+002C U+00D8)
  0x00, 0x2C, 0x00, 0xDD, 0x01, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x01, 0x06, 0x01, // ,Ć (U+002C U+0106)
  0x00, 0x2C, 0x01, 0x08, 0x01, // ,Ĉ (U+002C U+0108)
  0x00, 0x2C, 0x01, 0x0A, 0x01, // ,Ċ (U+002C U+010A)
  0x00, 0x2C, 0x01, 0x0C, 0x01, // ,Č (U+002C U+010C)
  0x00, 0x2C, 0x01, 0x1C, 0x01, // ,Ĝ (U+002C U+011C)
  0x00, 0x2C, 0x01, 0x1E, 0x01, // ,Ğ (U+002C U+011E)
  0x00, 0x2C, 0x01, 0x20, 0x01, // ,Ġ (U+002C U+0120)
  0x00, 0x2C, 0x01, 0x22, 0x01, // ,Ģ (U+002C U+0122)
  0x00, 0x2C, 0x01, 0x4C, 0x01, // ,Ō (U+002C U+014C)
  0x00, 0x2C, 0x01, 0x4E, 0x01, // ,Ŏ (U+002C U+014E)
  0x00, 0x2C, 0x01, 0x50, 0x01, // ,Ő (U+002C U+0150)
  0x00, 0x2C, 0x01, 0x52, 0x01, // ,Œ (U+002C U+0152)
  0x00, 0x2C, 0x01, 0x62, 0x01, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x01, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x01, // ,Ŧ (U+002C U+0166)
  0x00, 0x2C, 0x01, 0x74, 0x01, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x76, 0x01, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x78, 0x01, // ,Ÿ (U+002C U+0178)
  0x00, 0x2D, 0x00, 0x54, 0x01, // -T (U+002D U+0054)
  0x00, 0x2D, 0x01, 0x62, 0x01, // -Ţ (U+002D U+0162)
  0x00, 0x2D, 0x01, 0x64, 0x01, // -Ť (U+002D U+0164)
  0x00, 0x2D, 0x01, 0x66, 0x01, // -Ŧ (U+002D U+0166)
  0x00, 0x2E, 0x00, 0x43, 0x01, // .C (U+002E U+0043)
  0x00, 0x2E, 0x00, 0x47, 0x01, // .G (U+002E U+0047)
  0x00, 0x2E, 0x00, 0x4F, 0x01, // .O (U+002E U+004F)
  0x00, 0x2E, 0x00, 0x51, 0x01, // .Q (U+002E U+0051)
  0x00, 0x2E, 0x00, 0x54, 0x01, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x56, 0x01, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x01, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x01, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0xC7, 0x01, // .Ç (U+002E U+00C7)
  0x00, 0x2E, 0x00, 0xD2, 0x01, // .Ò (U+002E U+00D2)
  0x00, 0x2E, 0x00, 0xD3, 0x01, // .Ó (U+002E U+00D3)
  0x00, 0x2E, 0x00, 0xD4, 0x01, // .Ô (U+002E U+00D4)
  0x00, 0x2E, 0x00, 0xD5, 0x01, // .Õ (U+002E U+00D5)
  0x00, 0x2E, 0x00, 0xD6, 0x01, // .Ö (U+002E U+00D6)
  0x00, 0x2E, 0x00, 0xD8, 0x01, // .Ø (U+002E U+00D8)
  0x00, 0x2E, 0x00, 0xDD, 0x01, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x01, 0x06, 0x01, // .Ć (U+002E U+0106)
  0x00, 0x2E, 0x01, 0x08, 0x01, // .Ĉ (U+002E U+0108)
  0x00, 0x2E, 0x01, 0x0A, 0x01, // .Ċ (U+002E U+010A)
  0x00, 0x2E, 0x01, 0x0C, 0x01, // .Č (U+002E U+010C)
  0x00, 0x2E, 0x01, 0x1C, 0x01, // .Ĝ (U+002E U+011C)
  0x00, 0x2E, 0x01, 0x1E, 0x01, // .Ğ (U+002E U+011E)
  0x00, 0x2E, 0x01, 0x20, 0x01, // .Ġ (U+002E U+0120)
  0x00, 0x2E, 0x01, 0x22, 0x01, // .Ģ (U+002E U+0122)
  0x00, 0x2E, 0x01, 0x4C, 0x01, // .Ō (U+002E U+014C)
  0x00, 0x2E, 0x01, 0x4E, 0x01, // .Ŏ (U+002E U+014E)
  0x00, 0x2E, 0x01, 0x50, 0x01, // .Ő (U+002E U+0150)
  0x00, 0x2E, 0x01, 0x52, 0x01, // .Œ (U+002E U+0152)
  0x00, 0x2E, 0x01, 0x62, 0x01, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x01, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x01, // .Ŧ (U+002E U+0166)
  0x00, 0x2E, 0x01, 0x74, 0x01, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x76, 0x01, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x78, 0x01, // .Ÿ (U+002E U+0178)
  0x00, 0x30, 0x20, 0x44, 0x03, // 0⁄ (U+0030 U+2044)
  0x00, 0x31, 0x20, 0x44, 0x03, // 1⁄ (U+0031 U+2044)
  0x00, 0x32, 0x20, 0x44, 0x03, // 2⁄ (U+0032 U+2044)
  0x00, 0x33, 0x20, 0x44, 0x03, // 3⁄ (U+0033 U+2044)
  0x00, 0x34, 0x20, 0x44, 0x03, // 4⁄ (U+0034 U+2044)
  0x00, 0x35, 0x20, 0x44, 0x03, // 5⁄ (U+0035 U+2044)
  0x00, 0x36, 0x20, 0x44, 0x03, // 6⁄ (U+0036 U+2044)
  0x00, 0x37, 0x20, 0x44, 0x03, // 7⁄ (U+0037 U+2044)
  0x00, 0x38, 0x20, 0x44, 0x03, // 8⁄ (U+0038 U+2044)
  0x00, 0x39, 0x20, 0x44, 0x03, // 9⁄ (U+0039 U+2044)
  0x00, 0x41, 0x00, 0x22, 0x01, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x01, // A' (U+0041 U+0027)
  0x00, 0x41, 0x00, 0x54, 0x01, // AT (U+0041 U+0054)
  0x00, 0x41, 0x01, 0x62, 0x01, // AŢ (U+0041 U+0162)
  0x00, 0x41, 0x01, 0x64, 0x01, // AŤ (U+0041 U+0164)
  0x00, 0x41, 0x01, 0x66, 0x01, // AŦ (U+0041 U+0166)
  0x00, 0x41, 0x20, 0x19, 0x01, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1D, 0x01, // A” (U+0041 U+201D)
  0x00, 0x44, 0x00, 0x2C, 0x01, // D, (U+0044 U+002C)
  0x00, 0x44, 0x00, 0x2E, 0x01, // D. (U+0044 U+002E)
  0x00, 0x44, 0x20, 0x1A, 0x01, // D‚ (U+0044 U+201A)
  0x00, 0x44, 0x20, 0x1E, 0x01, // D„ (U+0044 U+201E)
  0x00, 0x44, 0x20, 0x26, 0x01, // D… (U+0044 U+2026)
  0x00, 0x46, 0x00, 0x2C, 0x01, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x01, // F. (U+0046 U+002E)
  0x00, 0x46, 0x20, 0x1A, 0x01, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x01, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x01, // F… (U+0046 U+2026)
  0x00, 0x4C, 0x00, 0x22, 0x01, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x01, // L' (U+004C U+0027)
  0x00, 0x4C, 0x00, 0x54, 0x01, // LT (U+004C U+0054)
  0x00, 0x4C, 0x00, 0x59, 0x01, // LY (U+004C U+0059)
  0x00, 0x4C, 0x00, 0xAB, 0x01, // L« (U+004C U+00AB)
  0x00, 0x4C, 0x00, 0xDD, 0x01, // LÝ (U+004C U+00DD)
  0x00, 0x4C, 0x01, 0x62, 0x01, // LŢ (U+004C U+0162)
  0x00, 0x4C, 0x01, 0x64, 0x01, // LŤ (U+004C U+0164)
  0x00, 0x4C, 0x01, 0x66, 0x01, // LŦ (U+004C U+0166)
  0x00, 0x4C, 0x01, 0x76, 0x01, // LŶ (U+004C U+0176)
  0x00, 0x4C, 0x01, 0x78, 0x01, // LŸ (U+004C U+0178)
  0x00, 0x4C, 0x20, 0x19, 0x01, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1D, 0x01, // L” (U+004C U+201D)
  0x00, 0x4C, 0x20, 0x39, 0x01, // L‹ (U+004C U+2039)
  0x00, 0x4F, 0x00, 0x2C, 0x01, // O, (U+004F U+002C)
  0x00, 0x4F, 0x00, 0x2E, 0x01, // O. (U+004F U+002E)
  0x00, 0x4F, 0x20, 0x1A, 0x01, // O‚ (U+004F U+201A)
  0x00, 0x4F, 0x20, 0x1E, 0x01, // O„ (U+004F U+201E)
  0x00, 0x4F, 0x20, 0x26, 0x01, // O… (U+004F U+2026)
  0x00, 0x50, 0x00, 0x2C, 0x02, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x02, // P. (U+0050 U+002E)
  0x00, 0x50, 0x20, 0x1A, 0x02, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x02, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x02, // P… (U+0050 U+2026)
  0x00, 0x51, 0x00, 0x2C, 0x01, // Q, (U+0051 U+002C)
  0x00, 0x51, 0x00, 0x2E, 0x01, // Q. (U+0051 U+002E)
  0x00, 0x51, 0x20, 0x1A, 0x01, // Q‚ (U+0051 U+201A)
  0x00, 0x51, 0x20, 0x1E, 0x01, // Q„ (U+0051 U+201E)
  0x00, 0x51, 0x20, 0x26, 0x01, // Q… (U+0051 U+2026)
  0x00, 0x54, 0x00, 0x2C, 0x01, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2D, 0x01, // T- (U+0054 U+002D)
  0x00, 0x54, 0x00, 0x2E, 0x01, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0x41, 0x01, // TA (U+0054 U+0041)
  0x00, 0x54, 0x00, 0x61, 0x01, // Ta (U+0054 U+0061)
  0x00, 0x54, 0x00, 0x63, 0x01, // Tc (U+0054 U+0063)
  0x00, 0x54, 0x00, 0x64, 0x01, // Td (U+0054 U+0064)
  0x00, 0x54, 0x00, 0x65, 0x01, // Te (U+0054 U+0065)
  0x00, 0x54, 0x00, 0x67, 0x01, // Tg (U+0054 U+0067)
  0x00, 0x54, 0x00, 0x6D, 0x01, // Tm (U+0054 U+006D)
  0x00, 0x54, 0x00, 0x6E, 0x01, // Tn (U+0054 U+006E)
  0x00, 0x54, 0x00, 0x6F, 0x01, // To (U+0054 U+006F)
  0x00, 0x54, 0x00, 0x70, 0x01, // Tp (U+0054 U+0070)
  0x00, 0x54, 0x00, 0x71, 0x01, // Tq (U+0054 U+0071)
  0x00, 0x54, 0x00, 0x72, 0x01, // Tr (U+0054 U+0072)
  0x00, 0x54, 0x00, 0x73, 0x01, // Ts (U+0054 U+0073)
  0x00, 0x54, 0x00, 0x75, 0x01, // Tu (U+0054 U+0075)
  0x00, 0x54, 0x00, 0x7A, 0x01, // Tz (U+0054 U+007A)
  0x00, 0x54, 0x00, 0xAB, 0x01, // T« (U+0054 U+00AB)
  0x00, 0x54, 0x00, 0xC0, 0x01, // TÀ (U+0054 U+00C0)
  0x00, 0x54, 0x00, 0xC1, 0x01, // TÁ (U+0054 U+00C1)
  0x00, 0x54, 0x00, 0xC2, 0x01, // TÂ (U+0054 U+00C2)
  0x00, 0x54, 0x00, 0xC3, 0x01, // TÃ (U+0054 U+00C3)
  0x00, 0x54, 0x00, 0xC4, 0x01, // TÄ (U+0054 U+00C4)
  0x00, 0x54, 0x00, 0xC5, 0x01, // TÅ (U+0054 U+00C5)
  0x00, 0x54, 0x00, 0xE0, 0x01, // Tà (U+0054 U+00E0)
  0x00, 0x54, 0x00, 0xE1, 0x01, // Tá (U+0054 U+00E1)
  0x00, 0x54, 0x00, 0xE2, 0x01, // Tâ (U+0054 U+00E2)
  0x00, 0x54, 0x00, 0xE3, 0x01, // Tã (U+0054 U+00E3)
  0x00, 0x54, 0x00, 0xE4, 0x01, // Tä (U+0054 U+00E4)
  0x00, 0x54, 0x00, 0xE5, 0x01, // Tå (U+0054 U+00E5)
  0x00, 0x54, 0x00, 0xE6, 0x01, // Tæ (U+0054 U+00E6)
  0x00, 0x54, 0x00, 0xE7, 0x01, // Tç (U+0054 U+00E7)
  0x00, 0x54, 0x00, 0xE8, 0x01, // Tè (U+0054 U+00E8)
  0x00, 0x54, 0x00, 0xE9, 0x01, // Té (U+0054 U+00E9)
  0x00, 0x54, 0x00, 0xEA, 0x01, // Tê (U+0054 U+00EA)
  0x00, 0x54, 0x00, 0xEB, 0x01, // Të (U+0054 U+00EB)
  0x00, 0x54, 0x00, 0xF1, 0x01, // Tñ (U+0054 U+00F1)
  0x00, 0x54, 0x00, 0xF2, 0x01, // Tò (U+0054 U+00F2)
  0x00, 0x54, 0x00, 0xF3, 0x01, // Tó (U+0054 U+00F3)
  0x00, 0x54, 0x00, 0xF4, 0x01, // Tô (U+0054 U+00F4)
  0x00, 0x54, 0x00, 0xF5, 0x01, // Tõ (U+0054 U+00F5)
  0x00, 0x54, 0x00, 0xF6, 0x01, // Tö (U+0054 U+00F6)
  0x00, 0x54, 0x00, 0xF8, 0x01, // Tø (U+0054 U+00F8)
  0x00, 0x54, 0x00, 0xF9, 0x01, // Tù (U+0054 U+00F9)
  0x00, 0x54, 0x00, 0xFA, 0x01, // Tú (U+0054 U+00FA)
  0x00, 0x54, 0x00, 0xFB, 0x01, // Tû (U+0054 U+00FB)
  0x00, 0x54, 0x00, 0xFC, 0x01, // Tü (U+0054 U+00FC)
  0x00, 0x54, 0x01, 0x00, 0x01, // TĀ (U+0054 U+0100)
  0x00, 0x54, 0x01, 0x01, 0x01, // Tā (U+0054 U+0101)
  0x00, 0x54, 0x01, 0x02, 0x01, // TĂ (U+0054 U+0102)
  0x00, 0x54, 0x01, 0x03, 0x01, // Tă (U+0054 U+0103)
  0x00, 0x54, 0x01, 0x04, 0x01, // TĄ (U+0054 U+0104)
  0x00, 0x54, 0x01, 0x05, 0x01, // Tą (U+0054 U+0105)
  0x00, 0x54, 0x01, 0x07, 0x01, // Tć (U+0054 U+0107)
  0x00, 0x54, 0x01, 0x09, 0x01, // Tĉ (U+0054 U+0109)
  0x00, 0x54, 0x01, 0x0B, 0x01, // Tċ (U+0054 U+010B)
  0x00, 0x54, 0x01, 0x0D, 0x01, // Tč (U+0054 U+010D)
  0x00, 0x54, 0x01, 0x0F, 0x01, // Tď (U+0054 U+010F)
  0x00, 0x54, 0x01, 0x11, 0x01, // Tđ (U+0054 U+0111)
  0x00, 0x54, 0x01, 0x13, 0x01, // Tē (U+0054 U+0113)
  0x00, 0x54, 0x01, 0x15, 0x01, // Tĕ (U+0054 U+0115)
  0x00, 0x54, 0x01, 0x17, 0x01, // Tė (U+0054 U+0117)
  0x00, 0x54, 0x01, 0x19, 0x01, // Tę (U+0054 U+0119)
  0x00, 0x54, 0x01, 0x1B, 0x01, // Tě (U+0054 U+011B)
  0x00, 0x54, 0x01, 0x1D, 0x01, // Tĝ (U+0054 U+011D)
  0x00, 0x54, 0x01, 0x1F, 0x01, // Tğ (U+0054 U+011F)
  0x00, 0x54, 0x01, 0x21, 0x01, // Tġ (U+0054 U+0121)
  0x00, 0x54, 0x01, 0x23, 0x01, // Tģ (U+0054 U+0123)
  0x00, 0x54, 0x01, 0x38, 0x01, // Tĸ (U+0054 U+0138)
  0x00, 0x54, 0x01, 0x44, 0x01, // Tń (U+0054 U+0144)
  0x00, 0x54, 0x01, 0x46, 0x01, // Tņ (U+0054 U+0146)
  0x00, 0x54, 0x01, 0x48, 0x01, // Tň (U+0054 U+0148)
  0x00, 0x54, 0x01, 0x4B, 0x01, // Tŋ (U+0054 U+014B)
  0x00, 0x54, 0x01, 0x4D, 0x01, // Tō (U+0054 U+014D)
  0x00, 0x54, 0x01, 0x4F, 0x01, // Tŏ (U+0054 U+014F)
  0x00, 0x54, 0x01, 0x51, 0x01, // Tő (U+0054 U+0151)
  0x00, 0x54, 0x01, 0x53, 0x01, // Tœ (U+0054 U+0153)
  0x00, 0x54, 0x01, 0x55, 0x01, // Tŕ (U+0054 U+0155)
  0x00, 0x54, 0x01, 0x57, 0x01, // Tŗ (U+0054 U+0157)
  0x00, 0x54, 0x01, 0x5B, 0x01, // Tś (U+0054 U+015B)
  0x00, 0x54, 0x01, 0x5D, 0x01, // Tŝ (U+0054 U+015D)
  0x00, 0x54, 0x01, 0x5F, 0x01, // Tş (U+0054 U+015F)
  0x00, 0x54, 0x01, 0x61, 0x01, // Tš (U+0054 U+0161)
  0x00, 0x54, 0x01, 0x69, 0x01, // Tũ (U+0054 U+0169)
  0x00, 0x54, 0x01, 0x6B, 0x01, // Tū (U+0054 U+016B)
  0x00, 0x54, 0x01, 0x6D, 0x01, // Tŭ (U+0054 U+016D)
  0x00, 0x54, 0x01, 0x6F, 0x01, // Tů (U+0054 U+016F)
  0x00, 0x54, 0x01, 0x71, 0x01, // Tű (U+0054 U+0171)
  0x00, 0x54, 0x01, 0x73, 0x01, // Tų (U+0054 U+0173)
  0x00, 0x54, 0x01, 0x7A, 0x01, // Tź (U+0054 U+017A)
  0x00, 0x54, 0x01, 0x7C, 0x01, // Tż (U+0054 U+017C)
  0x00, 0x54, 0x01, 0x7E, 0x01, // Tž (U+0054 U+017E)
  0x00, 0x54, 0x20, 0x13, 0x01, // T– (U+0054 U+2013)
  0x00, 0x54, 0x20, 0x14, 0x01, // T— (U+0054 U+2014)
  0x00, 0x54, 0x20, 0x1A, 0x01, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x01, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x01, // T… (U+0054 U+2026)
  0x00, 0x54, 0x20, 0x39, 0x01, // T‹ (U+0054 U+2039)
  0x00, 0x56, 0x00, 0x2C, 0x01, // V, (U+0056 U+002C)
  0x00, 0x56, 0x00, 0x2E, 0x01, // V. (U+0056 U+002E)
  0x00, 0x56, 0x00, 0xAB, 0x01, // V« (U+0056 U+00AB)
  0x00, 0x56, 0x20, 0x1A, 0x01, // V‚ (U+0056 U+201A)
  0x00, 0x56, 0x20, 0x1E, 0x01, // V„ (U+0056 U+201E)
  0x00, 0x56, 0x20, 0x26, 0x01, // V… (U+0056 U+2026)
  0x00, 0x56, 0x20, 0x39, 0x01, // V‹ (U+0056 U+2039)
  0x00, 0x57, 0x00, 0x2C, 0x01, // W, (U+0057 U+002C)
  0x00, 0x57, 0x00, 0x2E, 0x01, // W. (U+0057 U+002E)
  0x00, 0x57, 0x00, 0xAB, 0x01, // W« (U+0057 U+00AB)
  0x00, 0x57, 0x20, 0x1A, 0x01, // W‚ (U+0057 U+201A)
  0x00, 0x57, 0x20, 0x1E, 0x01, // W„ (U+0057 U+201E)
  0x00, 0x57, 0x20, 0x26, 0x01, // W… (U+0057 U+2026)
  0x00, 0x57, 0x20, 0x39, 0x01, // W‹ (U+0057 U+2039)
  0x00, 0x59, 0x00, 0x2C, 0x01, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x01, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x00, 0x61, 0x01, // Ya (U+0059 U+0061)
  0x00, 0x59, 0x00, 0x63, 0x01, // Yc (U+0059 U+0063)
  0x00, 0x59, 0x00, 0x64, 0x01, // Yd (U+0059 U+0064)
  0x00, 0x59, 0x00, 0x65, 0x01, // Ye (U+0059 U+0065)
  0x00, 0x59, 0x00, 0x6D, 0x01, // Ym (U+0059 U+006D)
  0x00, 0x59, 0x00, 0x6E, 0x01, // Yn (U+0059 U+006E)
  0x00, 0x59, 0x00, 0x6F, 0x01, // Yo (U+0059 U+006F)
  0x00, 0x59, 0x00, 0x70, 0x01, // Yp (U+0059 U+0070)
  0x00, 0x59, 0x00, 0x71, 0x01, // Yq (U+0059 U+0071)
  0x00, 0x59, 0x00, 0x72, 0x01, // Yr (U+0059 U+0072)
  0x00, 0x59, 0x00, 0x75, 0x01, // Yu (U+0059 U+0075)
  0x00, 0x59, 0x00, 0xAB, 0x01, // Y« (U+0059 U+00AB)
  0x00, 0x59, 0x00, 0xBB, 0x01, // Y» (U+0059 U+00BB)
  0x00, 0x59, 0x00, 0xE0, 0x01, // Yà (U+0059 U+00E0)
  0x00, 0x59, 0x00, 0xE1, 0x01, // Yá (U+0059 U+00E1)
  0x00, 0x59, 0x00, 0xE2, 0x01, // Yâ (U+0059 U+00E2)
  0x00, 0x59, 0x00, 0xE3, 0x01, // Yã (U+0059 U+00E3)
  0x00, 0x59, 0x00, 0xE4, 0x01, // Yä (U+0059 U+00E4)
  0x00, 0x59, 0x00, 0xE5, 0x01, // Yå (U+0059 U+00E5)
  0x00, 0x59, 0x00, 0xE6, 0x01, // Yæ (U+0059 U+00E6)
  0x00, 0x59, 0x00, 0xE7, 0x01, // Yç (U+0059 U+00E7)
  0x00, 0x59, 0x00, 0xE8, 0x01, // Yè (U+0059 U+00E8)
  0x00, 0x59, 0x00, 0xE9, 0x01, // Yé (U+0059 U+00E9)
  0x00, 0x59, 0x00, 0xEA, 0x01, // Yê (U+0059 U+00EA)
  0x00, 0x59, 0x00, 0xEB, 0x01, // Yë (U+0059 U+00EB)
  0x00, 0x59, 0x00, 0xF1, 0x01, // Yñ (U+0059 U+00F1)
  0x00, 0x59, 0x00, 0xF2, 0x01, // Yò (U+0059 U+00F2)
  0x00, 0x59, 0x00, 0xF3, 0x01, // Yó (U+0059 U+00F3)
  0x00, 0x59, 0x00, 0xF4, 0x01, // Yô (U+0059 U+00F4)
  0x00, 0x59, 0x00, 0xF5, 0x01, // Yõ (U+0059 U+00F5)
  0x00, 0x59, 0x00, 0xF6, 0x01, // Yö (U+0059 U+00F6)
  0x00, 0x59, 0x00, 0xF8, 0x01, // Yø (U+0059 U+00F8)
  0x00, 0x59, 0x00, 0xF9, 0x01, // Yù (U+0059 U+00F9)
  0x00, 0x59, 0x00, 0xFA, 0x01, // Yú (U+0059 U+00FA)
  0x00, 0x59, 0x00, 0xFB, 0x01, // Yû (U+0059 U+00FB)
  0x00, 0x59, 0x00, 0xFC, 0x01, // Yü (U+0059 U+00FC)
  0x00, 0x59, 0x01, 0x01, 0x01, // Yā (U+0059 U+0101)
  0x00, 0x59, 0x01, 0x03, 0x01, // Yă (U+0059 U+0103)
  0x00, 0x59, 0x01, 0x05, 0x01, // Yą (U+0059 U+0105)
  0x00, 0x59, 0x01, 0x07, 0x01, // Yć (U+0059 U+0107)
  0x00, 0x59, 0x01, 0x09, 0x01, // Yĉ (U+0059 U+0109)
  0x00, 0x59, 0x01, 0x0B, 0x01, // Yċ (U+0059 U+010B)
  0x00, 0x59, 0x01, 0x0D, 0x01, // Yč (U+0059 U+010D)
  0x00, 0x59, 0x01, 0x0F, 0x01, // Yď (U+0059 U+010F)
  0x00, 0x59, 0x01, 0x11, 0x01, // Yđ (U+0059 U+0111)
  0x00, 0x59, 0x01, 0x13, 0x01, // Yē (U+0059 U+0113)
  0x00, 0x59, 0x01, 0x15, 0x01, // Yĕ (U+0059 U+0115)
  0x00, 0x59, 0x01, 0x17, 0x01, // Yė (U+0059 U+0117)
  0x00, 0x59, 0x01, 0x19, 0x01, // Yę (U+0059 U+0119)
  0x00, 0x59, 0x01, 0x1B, 0x01, // Yě (U+0059 U+011B)
  0x00, 0x59, 0x01, 0x38, 0x01, // Yĸ (U+0059 U+0138)
  0x00, 0x59, 0x01, 0x44, 0x01, // Yń (U+0059 U+0144)
  0x00, 0x59, 0x01, 0x46, 0x01, // Yņ (U+0059 U+0146)
  0x00, 0x59, 0x01, 0x48, 0x01, // Yň (U+0059 U+0148)
  0x00, 0x59, 0x01, 0x4B, 0x01, // Yŋ (U+0059 U+014B)
  0x00, 0x59, 0x01, 0x4D, 0x01, // Yō (U+0059 U+014D)
  0x00, 0x59, 0x01, 0x4F, 0x01, // Yŏ (U+0059 U+014F)
  0x00, 0x59, 0x01, 0x51, 0x01, // Yő (U+0059 U+0151)
  0x00, 0x59, 0x01, 0x53, 0x01, // Yœ (U+0059 U+0153)
  0x00, 0x59, 0x01, 0x55, 0x01, // Yŕ (U+0059 U+0155)
  0x00, 0x59, 0x01, 0x57, 0x01, // Yŗ (U+0059 U+0157)
  0x00, 0x59, 0x01, 0x69, 0x01, // Yũ (U+0059 U+0169)
  0x00, 0x59, 0x01, 0x6B, 0x01, // Yū (U+0059 U+016B)
  0x00, 0x59, 0x01, 0x6D, 0x01, // Yŭ (U+0059 U+016D)
  0x00, 0x59, 0x01, 0x6F, 0x01, // Yů (U+0059 U+016F)
  0x00, 0x59, 0x01, 0x71, 0x01, // Yű (U+0059 U+0171)
  0x00, 0x59, 0x01, 0x73, 0x01, // Yų (U+0059 U+0173)
  0x00, 0x59, 0x20, 0x1A, 0x01, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x01, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x01, // Y… (U+0059 U+2026)
  0x00, 0x59, 0x20, 0x39, 0x01, // Y‹ (U+0059 U+2039)
  0x00, 0x59, 0x20, 0x3A, 0x01, // Y› (U+0059 U+203A)
  0x00, 0xAB, 0x00, 0x59, 0x01, // «Y (U+00AB U+0059)
  0x00, 0xAB, 0x00, 0xDD, 0x01, // «Ý (U+00AB U+00DD)
  0x00, 0xAB, 0x01, 0x76, 0x01, // «Ŷ (U+00AB U+0176)
  0x00, 0xAB, 0x01, 0x78, 0x01, // «Ÿ (U+00AB U+0178)
  0x00, 0xBB, 0x00, 0x54, 0x01, // »T (U+00BB U+0054)
  0x00, 0xBB, 0x00, 0x56, 0x01, // »V (U+00BB U+0056)
  0x00, 0xBB, 0x00, 0x57, 0x01, // »W (U+00BB U+0057)
  0x00, 0xBB, 0x00, 0x59, 0x01, // »Y (U+00BB U+0059)
  0x00, 0xBB, 0x00, 0xDD, 0x01, // »Ý (U+00BB U+00DD)
  0x00, 0xBB, 0x01, 0x62, 0x01, // »Ţ (U+00BB U+0162)
  0x00, 0xBB, 0x01, 0x64, 0x01, // »Ť (U+00BB U+0164)
  0x00, 0xBB, 0x01, 0x66, 0x01, // »Ŧ (U+00BB U+0166)
  0x00, 0xBB, 0x01, 0x74, 0x01, // »Ŵ (U+00BB U+0174)
  0x00, 0xBB, 0x01, 0x76, 0x01, // »Ŷ (U+00BB U+0176)
  0x00, 0xBB, 0x01, 0x78, 0x01, // »Ÿ (U+00BB U+0178)
  0x00, 0xBF, 0x00, 0x54, 0x01, // ¿T (U+00BF U+0054)
  0x00, 0xBF, 0x01, 0x62, 0x01, // ¿Ţ (U+00BF U+0162)
  0x00, 0xBF, 0x01, 0x64, 0x01, // ¿Ť (U+00BF U+0164)
  0x00, 0xBF, 0x01, 0x66, 0x01, // ¿Ŧ (U+00BF U+0166)
  0x00, 0xC0, 0x00, 0x22, 0x01, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x01, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x00, 0x54, 0x01, // ÀT (U+00C0 U+0054)
  0x00, 0xC0, 0x01, 0x62, 0x01, // ÀŢ (U+00C0 U+0162)
  0x00, 0xC0, 0x01, 0x64, 0x01, // ÀŤ (U+00C0 U+0164)
  0x00, 0xC0, 0x01, 0x66, 0x01, // ÀŦ (U+00C0 U+0166)
  0x00, 0xC0, 0x20, 0x19, 0x01, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1D, 0x01, // À” (U+00C0 U+201D)
  0x00, 0xC1, 0x00, 0x22, 0x01, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x01, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x00, 0x54, 0x01, // ÁT (U+00C1 U+0054)
  0x00, 0xC1, 0x01, 0x62, 0x01, // ÁŢ (U+00C1 U+0162)
  0x00, 0xC1, 0x01, 0x64, 0x01, // ÁŤ (U+00C1 U+0164)
  0x00, 0xC1, 0x01, 0x66, 0x01, // ÁŦ (U+00C1 U+0166)
  0x00, 0xC1, 0x20, 0x19, 0x01, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1D, 0x01, // Á” (U+00C1 U+201D)
  0x00, 0xC2, 0x00, 0x22, 0x01, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x01, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x00, 0x54, 0x01, // ÂT (U+00C2 U+0054)
  0x00, 0xC2, 0x01, 0x62, 0x01, // ÂŢ (U+00C2 U+0162)
  0x00, 0xC2, 0x01, 0x64, 0x01, // ÂŤ (U+00C2 U+0164)
  0x00, 0xC2, 0x01, 0x66, 0x01, // ÂŦ (U+00C2 U+0166)
  0x00, 0xC2, 0x20, 0x19, 0x01, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1D, 0x01, // Â” (U+00C2 U+201D)
  0x00, 0xC3, 0x00, 0x22, 0x01, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x01, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x00, 0x54, 0x01, // ÃT (U+00C3 U+0054)
  0x00, 0xC3, 0x01, 0x62, 0x01, // ÃŢ (U+00C3 U+0162)
  0x00, 0xC3, 0x01, 0x64, 0x01, // ÃŤ (U+00C3 U+0164)
  0x00, 0xC3, 0x01, 0x66, 0x01, // ÃŦ (U+00C3 U+0166)
  0x00, 0xC3, 0x20, 0x19, 0x01, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1D, 0x01, // Ã” (U+00C3 U+201D)
  0x00, 0xC4, 0x00, 0x22, 0x01, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x01, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x00, 0x54, 0x01, // ÄT (U+00C4 U+0054)
  0x00, 0xC4, 0x01, 0x62, 0x01, // ÄŢ (U+00C4 U+0162)
  0x00, 0xC4, 0x01, 0x64, 0x01, // ÄŤ (U+00C4 U+0164)
  0x00, 0xC4, 0x01, 0x66, 0x01, // ÄŦ (U+00C4 U+0166)
  0x00, 0xC4, 0x20, 0x19, 0x01, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1D, 0x01, // Ä” (U+00C4 U+201D)
  0x00, 0xC5, 0x00, 0x22, 0x01, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x01, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x00, 0x54, 0x01, // ÅT (U+00C5 U+0054)
  0x00, 0xC5, 0x01, 0x62, 0x01, // ÅŢ (U+00C5 U+0162)
  0x00, 0xC5, 0x01, 0x64, 0x01, // ÅŤ (U+00C5 U+0164)
  0x00, 0xC5, 0x01, 0x66, 0x01, // ÅŦ (U+00C5 U+0166)
  0x00, 0xC5, 0x20, 0x19, 0x01, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1D, 0x01, // Å” (U+00C5 U+201D)
  0x00, 0xD0, 0x00, 0x2C, 0x01, // Ð, (U+00D0 U+002C)
  0x00, 0xD0, 0x00, 0x2E, 0x01, // Ð. (U+00D0 U+002E)
  0x00, 0xD0, 0x20, 0x1A, 0x01, // Ð‚ (U+00D0 U+201A)
  0x00, 0xD0, 0x20, 0x1E, 0x01, // Ð„ (U+00D0 U+201E)
  0x00, 0xD0, 0x20, 0x26, 0x01, // Ð… (U+00D0 U+2026)
  0x00, 0xD2, 0x00, 0x2C, 0x01, // Ò, (U+00D2 U+002C)
  0x00, 0xD2, 0x00, 0x2E, 0x01, // Ò. (U+00D2 U+002E)
  0x00, 0xD2, 0x20, 0x1A, 0x01, // Ò‚ (U+00D2 U+201A)
  0x00, 0xD2, 0x20, 0x1E, 0x01, // Ò„ (U+00D2 U+201E)
  0x00, 0xD2, 0x20, 0x26, 0x01, // Ò… (U+00D2 U+2026)
  0x00, 0xD3, 0x00, 0x2C, 0x01, // Ó, (U+00D3 U+002C)
  0x00, 0xD3, 0x00, 0x2E, 0x01, // Ó. (U+00D3 U+002E)
  0x00, 0xD3, 0x20, 0x1A, 0x01, // Ó‚ (U+00D3 U+201A)
  0x00, 0xD3, 0x20, 0x1E, 0x01, // Ó„ (U+00D3 U+201E)
  0x00, 0xD3, 0x20, 0x26, 0x01, // Ó… (U+00D3 U+2026)
  0x00, 0xD4, 0x00, 0x2C, 0x01, // Ô, (U+00D4 U+002C)
  0x00, 0xD4, 0x00, 0x2E, 0x01, // Ô. (U+00D4 U+002E)
  0x00, 0xD4, 0x20, 0x1A, 0x01, // Ô‚ (U+00D4 U+201A)
  0x00, 0xD4, 0x20, 0x1E, 0x01, // Ô„ (U+00D4 U+201E)
  0x00, 0xD4, 0x20, 0x26, 0x01, // Ô… (U+00D4 U+2026)
  0x00, 0xD5, 0x00, 0x2C, 0x01, // Õ, (U+00D5 U+002C)
  0x00, 0xD5, 0x00, 0x2E, 0x01, // Õ. (U+00D5 U+002E)
  0x00, 0xD5, 0x20, 0x1A, 0x01, // Õ‚ (U+00D5 U+201A)
  0x00, 0xD5, 0x20, 0x1E, 0x01, // Õ„ (U+00D5 U+201E)
  0x00, 0xD5, 0x20, 0x26, 0x01, // Õ… (U+00D5 U+2026)
  0x00, 0xD6, 0x00, 0x2C, 0x01, // Ö, (U+00D6 U+002C)
  0x00, 0xD6, 0x00, 0x2E, 0x01, // Ö. (U+00D6 U+002E)
  0x00, 0xD6, 0x20, 0x1A, 0x01, // Ö‚ (U+00D6 U+201A)
  0x00, 0xD6, 0x20, 0x1E, 0x01, // Ö„ (U+00D6 U+201E)
  0x00, 0xD6, 0x20, 0x26, 0x01, // Ö… (U+00D6 U+2026)
  0x00, 0xD8, 0x00, 0x2C, 0x01, // Ø, (U+00D8 U+002C)
  0x00, 0xD8, 0x00, 0x2E, 0x01, // Ø. (U+00D8 U+002E)
  0x00, 0xD8, 0x20, 0x1A, 0x01, // Ø‚ (U+00D8 U+201A)
  0x00, 0xD8, 0x20, 0x1E, 0x01, // Ø„ (U+00D8 U+201E)
  0x00, 0xD8, 0x20, 0x26, 0x01, // Ø… (U+00D8 U+2026)
  0x00, 0xDD, 0x00, 0x2C, 0x01, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x01, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x00, 0x61, 0x01, // Ýa (U+00DD U+0061)
  0x00, 0xDD, 0x00, 0x63, 0x01, // Ýc (U+00DD U+0063)
  0x00, 0xDD, 0x00, 0x64, 0x01, // Ýd (U+00DD U+0064)
  0x00, 0xDD, 0x00, 0x65, 0x01, // Ýe (U+00DD U+0065)
  0x00, 0xDD, 0x00, 0x6D, 0x01, // Ým (U+00DD U+006D)
  0x00, 0xDD, 0x00, 0x6E, 0x01, // Ýn (U+00DD U+006E)
  0x00, 0xDD, 0x00, 0x6F, 0x01, // Ýo (U+00DD U+006F)
  0x00, 0xDD, 0x00, 0x70, 0x01, // Ýp (U+00DD U+0070)
  0x00, 0xDD, 0x00, 0x71, 0x01, // Ýq (U+00DD U+0071)
  0x00, 0xDD, 0x00, 0x72, 0x01, // Ýr (U+00DD U+0072)
  0x00, 0xDD, 0x00, 0x75, 0x01, // Ýu (U+00DD U+0075)
  0x00, 0xDD, 0x00, 0xAB, 0x01, // Ý« (U+00DD U+00AB)
  0x00, 0xDD, 0x00, 0xBB, 0x01, // Ý» (U+00DD U+00BB)
  0x00, 0xDD, 0x00, 0xE0, 0x01, // Ýà (U+00DD U+00E0)
  0x00, 0xDD, 0x00, 0xE1, 0x01, // Ýá (U+00DD U+00E1)
  0x00, 0xDD, 0x00, 0xE2, 0x01, // Ýâ (U+00DD U+00E2)
  0x00, 0xDD, 0x00, 0xE3, 0x01, // Ýã (U+00DD U+00E3)
  0x00, 0xDD, 0x00, 0xE4, 0x01, // Ýä (U+00DD U+00E4)
  0x00, 0xDD, 0x00, 0xE5, 0x01, // Ýå (U+00DD U+00E5)
  0x00, 0xDD, 0x00, 0xE6, 0x01, // Ýæ (U+00DD U+00E6)
  0x00, 0xDD, 0x00, 0xE7, 0x01, // Ýç (U+00DD U+00E7)
  0x00, 0xDD, 0x00, 0xE8, 0x01, // Ýè (U+00DD U+00E8)
  0x00, 0xDD, 0x00, 0xE9, 0x01, // Ýé (U+00DD U+00E9)
  0x00, 0xDD, 0x00, 0xEA, 0x01, // Ýê (U+00DD U+00EA)
  0x00, 0xDD, 0x00, 0xEB, 0x01, // Ýë (U+00DD U+00EB)
  0x00, 0xDD, 0x00, 0xF1, 0x01, // Ýñ (U+00DD U+00F1)
  0x00, 0xDD, 0x00, 0xF2, 0x01, // Ýò (U+00DD U+00F2)
  0x00, 0xDD, 0x00, 0xF3, 0x01, // Ýó (U+00DD U+00F3)
  0x00, 0xDD, 0x00, 0xF4, 0x01, // Ýô (U+00DD U+00F4)
  0x00, 0xDD, 0x00, 0xF5, 0x01, // Ýõ (U+00DD U+00F5)
  0x00, 0xDD, 0x00, 0xF6, 0x01, // Ýö (U+00DD U+00F6)
  0x00, 0xDD, 0x00, 0xF8, 0x01, // Ýø (U+00DD U+00F8)
  0x00, 0xDD, 0x00, 0xF9, 0x01, // Ýù (U+00DD U+00F9)
  0x00, 0xDD, 0x00, 0xFA, 0x01, // Ýú (U+00DD U+00FA)
  0x00, 0xDD, 0x00, 0xFB, 0x01, // Ýû (U+00DD U+00FB)
  0x00, 0xDD, 0x00, 0xFC, 0x01, // Ýü (U+00DD U+00FC)
  0x00, 0xDD, 0x01, 0x01, 0x01, // Ýā (U+00DD U+0101)
  0x00, 0xDD, 0x01, 0x03, 0x01, // Ýă (U+00DD U+0103)
  0x00, 0xDD, 0x01, 0x05, 0x01, // Ýą (U+00DD U+0105)
  0x00, 0xDD, 0x01, 0x07, 0x01, // Ýć (U+00DD U+0107)
  0x00, 0xDD, 0x01, 0x09, 0x01, // Ýĉ (U+00DD U+0109)
  0x00, 0xDD, 0x01, 0x0B, 0x01, // Ýċ (U+00DD U+010B)
  0x00, 0xDD, 0x01, 0x0D, 0x01, // Ýč (U+00DD U+010D)
  0x00, 0xDD, 0x01, 0x0F, 0x01, // Ýď (U+00DD U+010F)
  0x00, 0xDD, 0x01, 0x11, 0x01, // Ýđ (U+00DD U+0111)
  0x00, 0xDD, 0x01, 0x13, 0x01, // Ýē (U+00DD U+0113)
  0x00, 0xDD, 0x01, 0x15, 0x01, // Ýĕ (U+00DD U+0115)
  0x00, 0xDD, 0x01, 0x17, 0x01, // Ýė (U+00DD U+0117)
  0x00, 0xDD, 0x01, 0x19, 0x01, // Ýę (U+00DD U+0119)
  0x00, 0xDD, 0x01, 0x1B, 0x01, // Ýě (U+00DD U+011B)
  0x00, 0xDD, 0x01, 0x38, 0x01, // Ýĸ (U+00DD U+0138)
  0x00, 0xDD, 0x01, 0x44, 0x01, // Ýń (U+00DD U+0144)
  0x00, 0xDD, 0x01, 0x46, 0x01, // Ýņ (U+00DD U+0146)
  0x00, 0xDD, 0x01, 0x48, 0x01, // Ýň (U+00DD U+0148)
  0x00, 0xDD, 0x01, 0x4B, 0x01, // Ýŋ (U+00DD U+014B)
  0x00, 0xDD, 0x01, 0x4D, 0x01, // Ýō (U+00DD U+014D)
  0x00, 0xDD, 0x01, 0x4F, 0x01, // Ýŏ (U+00DD U+014F)
  0x00, 0xDD, 0x01, 0x51, 0x01, // Ýő (U+00DD U+0151)
  0x00, 0xDD, 0x01, 0x53, 0x01, // Ýœ (U+00DD U+0153)
  0x00, 0xDD, 0x01, 0x55, 0x01, // Ýŕ (U+00DD U+0155)
  0x00, 0xDD, 0x01, 0x57, 0x01, // Ýŗ (U+00DD U+0157)
  0x00, 0xDD, 0x01, 0x69, 0x01, // Ýũ (U+00DD U+0169)
  0x00, 0xDD, 0x01, 0x6B, 0x01, // Ýū (U+00DD U+016B)
  0x00, 0xDD, 0x01, 0x6D, 0x01, // Ýŭ (U+00DD U+016D)
  0x00, 0xDD, 0x01, 0x6F, 0x01, // Ýů (U+00DD U+016F)
  0x00, 0xDD, 0x01, 0x71, 0x01, // Ýű (U+00DD U+0171)
  0x00, 0xDD, 0x01, 0x73, 0x01, // Ýų (U+00DD U+0173)
  0x00, 0xDD, 0x20, 0x1A, 0x01, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x01, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x01, // Ý… (U+00DD U+2026)
  0x00, 0xDD, 0x20, 0x39, 0x01, // Ý‹ (U+00DD U+2039)
  0x00, 0xDD, 0x20, 0x3A, 0x01, // Ý› (U+00DD U+203A)
  0x00, 0xDE, 0x00, 0x2C, 0x02, // Þ, (U+00DE U+002C)
  0x00, 0xDE, 0x00, 0x2E, 0x02, // Þ. (U+00DE U+002E)
  0x00, 0xDE, 0x20, 0x1A, 0x02, // Þ‚ (U+00DE U+201A)
  0x00, 0xDE, 0x20, 0x1E, 0x02, // Þ„ (U+00DE U+201E)
  0x00, 0xDE, 0x20, 0x26, 0x02, // Þ… (U+00DE U+2026)
  0x01, 0x00, 0x00, 0x22, 0x01, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x01, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x00, 0x54, 0x01, // ĀT (U+0100 U+0054)
  0x01, 0x00, 0x01, 0x62, 0x01, // ĀŢ (U+0100 U+0162)
  0x01, 0x00, 0x01, 0x64, 0x01, // ĀŤ (U+0100 U+0164)
  0x01, 0x00, 0x01, 0x66, 0x01, // ĀŦ (U+0100 U+0166)
  0x01, 0x00, 0x20, 0x19, 0x01, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1D, 0x01, // Ā” (U+0100 U+201D)
  0x01, 0x02, 0x00, 0x22, 0x01, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x01, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x00, 0x54, 0x01, // ĂT (U+0102 U+0054)
  0x01, 0x02, 0x01, 0x62, 0x01, // ĂŢ (U+0102 U+0162)
  0x01, 0x02, 0x01, 0x64, 0x01, // ĂŤ (U+0102 U+0164)
  0x01, 0x02, 0x01, 0x66, 0x01, // ĂŦ (U+0102 U+0166)
  0x01, 0x02, 0x20, 0x19, 0x01, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1D, 0x01, // Ă” (U+0102 U+201D)
  0x01, 0x04, 0x00, 0x22, 0x01, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x01, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x00, 0x54, 0x01, // ĄT (U+0104 U+0054)
  0x01, 0x04, 0x01, 0x62, 0x01, // ĄŢ (U+0104 U+0162)
  0x01, 0x04, 0x01, 0x64, 0x01, // ĄŤ (U+0104 U+0164)
  0x01, 0x04, 0x01, 0x66, 0x01, // ĄŦ (U+0104 U+0166)
  0x01, 0x04, 0x20, 0x19, 0x01, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1D, 0x01, // Ą” (U+0104 U+201D)
  0x01, 0x0E, 0x00, 0x2C, 0x01, // Ď, (U+010E U+002C)
  0x01, 0x0E, 0x00, 0x2E, 0x01, // Ď. (U+010E U+002E)
  0x01, 0x0E, 0x20, 0x1A, 0x01, // Ď‚ (U+010E U+201A)
  0x01, 0x0E, 0x20, 0x1E, 0x01, // Ď„ (U+010E U+201E)
  0x01, 0x0E, 0x20, 0x26, 0x01, // Ď… (U+010E U+2026)
  0x01, 0x10, 0x00, 0x2C, 0x01, // Đ, (U+0110 U+002C)
  0x01, 0x10, 0x00, 0x2E, 0x01, // Đ. (U+0110 U+002E)
  0x01, 0x10, 0x20, 0x1A, 0x01, // Đ‚ (U+0110 U+201A)
  0x01, 0x10, 0x20, 0x1E, 0x01, // Đ„ (U+0110 U+201E)
  0x01, 0x10, 0x20, 0x26, 0x01, // Đ… (U+0110 U+2026)
  0x01, 0x39, 0x00, 0x22, 0x01, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x01, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x00, 0x54, 0x01, // ĹT (U+0139 U+0054)
  0x01, 0x39, 0x00, 0x59, 0x01, // ĹY (U+0139 U+0059)
  0x01, 0x39, 0x00, 0xAB, 0x01, // Ĺ« (U+0139 U+00AB)
  0x01, 0x39, 0x00, 0xDD, 0x01, // ĹÝ (U+0139 U+00DD)
  0x01, 0x39, 0x01, 0x62, 0x01, // ĹŢ (U+0139 U+0162)
  0x01, 0x39, 0x01, 0x64, 0x01, // ĹŤ (U+0139 U+0164)
  0x01, 0x39, 0x01, 0x66, 0x01, // ĹŦ (U+0139 U+0166)
  0x01, 0x39, 0x01, 0x76, 0x01, // ĹŶ (U+0139 U+0176)
  0x01, 0x39, 0x01, 0x78, 0x01, // ĹŸ (U+0139 U+0178)
  0x01, 0x39, 0x20, 0x19, 0x01, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1D, 0x01, // Ĺ” (U+0139 U+201D)
  0x01, 0x39, 0x20, 0x39, 0x01, // Ĺ‹ (U+0139 U+2039)
  0x01, 0x3B, 0x00, 0x22, 0x01, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x01, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x00, 0x54, 0x01, // ĻT (U+013B U+0054)
  0x01, 0x3B, 0x00, 0x59, 0x01, // ĻY (U+013B U+0059)
  0x01, 0x3B, 0x00, 0xAB, 0x01, // Ļ« (U+013B U+00AB)
  0x01, 0x3B, 0x00, 0xDD, 0x01, // ĻÝ (U+013B U+00DD)
  0x01, 0x3B, 0x01, 0x62, 0x01, // ĻŢ (U+013B U+0162)
  0x01, 0x3B, 0x01, 0x64, 0x01, // ĻŤ (U+013B U+0164)
  0x01, 0x3B, 0x01, 0x66, 0x01, // ĻŦ (U+013B U+0166)
  0x01, 0x3B, 0x01, 0x76, 0x01, // ĻŶ (U+013B U+0176)
  0x01, 0x3B, 0x01, 0x78, 0x01, // ĻŸ (U+013B U+0178)
  0x01, 0x3B, 0x20, 0x19, 0x01, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1D, 0x01, // Ļ” (U+013B U+201D)
  0x01, 0x3B, 0x20, 0x39, 0x01, // Ļ‹ (U+013B U+2039)
  0x01, 0x3D, 0x00, 0x22, 0x01, // Ľ" (U+013D U+0022)
  0x01, 0x3D, 0x00, 0x27, 0x01, // Ľ' (U+013D U+0027)
  0x01, 0x3D, 0x00, 0x54, 0x01, // ĽT (U+013D U+0054)
  0x01, 0x3D, 0x00, 0x59, 0x01, // ĽY (U+013D U+0059)
  0x01, 0x3D, 0x00, 0xAB, 0x01, // Ľ« (U+013D U+00AB)
  0x01, 0x3D, 0x00, 0xDD, 0x01, // ĽÝ (U+013D U+00DD)
  0x01, 0x3D, 0x01, 0x62, 0x01, // ĽŢ (U+013D U+0162)
  0x01, 0x3D, 0x01, 0x64, 0x01, // ĽŤ (U+013D U+0164)
  0x01, 0x3D, 0x01, 0x66, 0x01, // ĽŦ (U+013D U+0166)
  0x01, 0x3D, 0x01, 0x76, 0x01, // ĽŶ (U+013D U+0176)
  0x01, 0x3D, 0x01, 0x78, 0x01, // ĽŸ (U+013D U+0178)
  0x01, 0x3D, 0x20, 0x19, 0x01, // Ľ’ (U+013D U+2019)
  0x01, 0x3D, 0x20, 0x1D, 0x01, // Ľ” (U+013D U+201D)
  0x01, 0x3D, 0x20, 0x39, 0x01, // Ľ‹ (U+013D U+2039)
  0x01, 0x3F, 0x00, 0x22, 0x01, // Ŀ" (U+013F U+0022)
  0x01, 0x3F, 0x00, 0x27, 0x01, // Ŀ' (U+013F U+0027)
  0x01, 0x3F, 0x00, 0x54, 0x01, // ĿT (U+013F U+0054)
  0x01, 0x3F, 0x00, 0x59, 0x01, // ĿY (U+013F U+0059)
  0x01, 0x3F, 0x00, 0xAB, 0x01, // Ŀ« (U+013F U+00AB)
  0x01, 0x3F, 0x00, 0xDD, 0x01, // ĿÝ (U+013F U+00DD)
  0x01, 0x3F, 0x01, 0x62, 0x01, // ĿŢ (U+013F U+0162)
  0x01, 0x3F, 0x01, 0x64, 0x01, // ĿŤ (U+013F U+0164)
  0x01, 0x3F, 0x01, 0x66, 0x01, // ĿŦ (U+013F U+0166)
  0x01, 0x3F, 0x01, 0x76, 0x01, // ĿŶ (U+013F U+0176)
  0x01, 0x3F, 0x01, 0x78, 0x01, // ĿŸ (U+013F U+0178)
  0x01, 0x3F, 0x20, 0x19, 0x01, // Ŀ’ (U+013F U+2019)
  0x01, 0x3F, 0x20, 0x1D, 0x01, // Ŀ” (U+013F U+201D)
  0x01, 0x3F, 0x20, 0x39, 0x01, // Ŀ‹ (U+013F U+2039)
  0x01, 0x41, 0x00, 0x22, 0x01, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x01, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x00, 0x54, 0x01, // ŁT (U+0141 U+0054)
  0x01, 0x41, 0x00, 0x59, 0x01, // ŁY (U+0141 U+0059)
  0x01, 0x41, 0x00, 0xAB, 0x01, // Ł« (U+0141 U+00AB)
  0x01, 0x41, 0x00, 0xDD, 0x01, // ŁÝ (U+0141 U+00DD)
  0x01, 0x41, 0x01, 0x62, 0x01, // ŁŢ (U+0141 U+0162)
  0x01, 0x41, 0x01, 0x64, 0x01, // ŁŤ (U+0141 U+0164)
  0x01, 0x41, 0x01, 0x66, 0x01, // ŁŦ (U+0141 U+0166)
  0x01, 0x41, 0x01, 0x76, 0x01, // ŁŶ (U+0141 U+0176)
  0x01, 0x41, 0x01, 0x78, 0x01, // ŁŸ (U+0141 U+0178)
  0x01, 0x41, 0x20, 0x19, 0x01, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1D, 0x01, // Ł” (U+0141 U+201D)
  0x01, 0x41, 0x20, 0x39, 0x01, // Ł‹ (U+0141 U+2039)
  0x01, 0x4C, 0x00, 0x2C, 0x01, // Ō, (U+014C U+002C)
  0x01, 0x4C, 0x00, 0x2E, 0x01, // Ō. (U+014C U+002E)
  0x01, 0x4C, 0x20, 0x1A, 0x01, // Ō‚ (U+014C U+201A)
  0x01, 0x4C, 0x20, 0x1E, 0x01, // Ō„ (U+014C U+201E)
  0x01, 0x4C, 0x20, 0x26, 0x01, // Ō… (U+014C U+2026)
  0x01, 0x4E, 0x00, 0x2C, 0x01, // Ŏ, (U+014E U+002C)
  0x01, 0x4E, 0x00, 0x2E, 0x01, // Ŏ. (U+014E U+002E)
  0x01, 0x4E, 0x20, 0x1A, 0x01, // Ŏ‚ (U+014E U+201A)
  0x01, 0x4E, 0x20, 0x1E, 0x01, // Ŏ„ (U+014E U+201E)
  0x01, 0x4E, 0x20, 0x26, 0x01, // Ŏ… (U+014E U+2026)
  0x01, 0x50, 0x00, 0x2C, 0x01, // Ő, (U+0150 U+002C)
  0x01, 0x50, 0x00, 0x2E, 0x01, // Ő. (U+0150 U+002E)
  0x01, 0x50, 0x20, 0x1A, 0x01, // Ő‚ (U+0150 U+201A)
  0x01, 0x50, 0x20, 0x1E, 0x01, // Ő„ (U+0150 U+201E)
  0x01, 0x50, 0x20, 0x26, 0x01, // Ő… (U+0150 U+2026)
  0x01, 0x62, 0x00, 0x2C, 0x01, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2D, 0x01, // Ţ- (U+0162 U+002D)
  0x01, 0x62, 0x00, 0x2E, 0x01, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0x41, 0x01, // ŢA (U+0162 U+0041)
  0x01, 0x62, 0x00, 0x61, 0x01, // Ţa (U+0162 U+0061)
  0x01, 0x62, 0x00, 0x63, 0x01, // Ţc (U+0162 U+0063)
  0x01, 0x62, 0x00, 0x64, 0x01, // Ţd (U+0162 U+0064)
  0x01, 0x62, 0x00, 0x65, 0x01, // Ţe (U+0162 U+0065)
  0x01, 0x62, 0x00, 0x67, 0x01, // Ţg (U+0162 U+0067)
  0x01, 0x62, 0x00, 0x6D, 0x01, // Ţm (U+0162 U+006D)
  0x01, 0x62, 0x00, 0x6E, 0x01, // Ţn (U+0162 U+006E)
  0x01, 0x62, 0x00, 0x6F, 0x01, // Ţo (U+0162 U+006F)
  0x01, 0x62, 0x00, 0x70, 0x01, // Ţp (U+0162 U+0070)
  0x01, 0x62, 0x00, 0x71, 0x01, // Ţq (U+0162 U+0071)
  0x01, 0x62, 0x00, 0x72, 0x01, // Ţr (U+0162 U+0072)
  0x01, 0x62, 0x00, 0x73, 0x01, // Ţs (U+0162 U+0073)
  0x01, 0x62, 0x00, 0x75, 0x01, // Ţu (U+0162 U+0075)
  0x01, 0x62, 0x00, 0x7A, 0x01, // Ţz (U+0162 U+007A)
  0x01, 0x62, 0x00, 0xAB, 0x01, // Ţ« (U+0162 U+00AB)
  0x01, 0x62, 0x00, 0xC0, 0x01, // ŢÀ (U+0162 U+00C0)
  0x01, 0x62, 0x00, 0xC1, 0x01, // ŢÁ (U+0162 U+00C1)
  0x01, 0x62, 0x00, 0xC2, 0x01, // ŢÂ (U+0162 U+00C2)
  0x01, 0x62, 0x00, 0xC3, 0x01, // ŢÃ (U+0162 U+00C3)
  0x01, 0x62, 0x00, 0xC4, 0x01, // ŢÄ (U+0162 U+00C4)
  0x01, 0x62, 0x00, 0xC5, 0x01, // ŢÅ (U+0162 U+00C5)
  0x01, 0x62, 0x00, 0xE0, 0x01, // Ţà (U+0162 U+00E0)
  0x01, 0x62, 0x00, 0xE1, 0x01, // Ţá (U+0162 U+00E1)
  0x01, 0x62, 0x00, 0xE2, 0x01, // Ţâ (U+0162 U+00E2)
  0x01, 0x62, 0x00, 0xE3, 0x01, // Ţã (U+0162 U+00E3)
  0x01, 0x62, 0x00, 0xE4, 0x01, // Ţä (U+0162 U+00E4)
  0x01, 0x62, 0x00, 0xE5, 0x01, // Ţå (U+0162 U+00E5)
  0x01, 0x62, 0x00, 0xE6, 0x01, // Ţæ (U+0162 U+00E6)
  0x01, 0x62, 0x00, 0xE7, 0x01, // Ţç (U+0162 U+00E7)
  0x01, 0x62, 0x00, 0xE8, 0x01, // Ţè (U+0162 U+00E8)
  0x01, 0x62, 0x00, 0xE9, 0x01, // Ţé (U+0162 U+00E9)
  0x01, 0x62, 0x00, 0xEA, 0x01, // Ţê (U+0162 U+00EA)
  0x01, 0x62, 0x00, 0xEB, 0x01, // Ţë (U+0162 U+00EB)
  0x01, 0x62, 0x00, 0xF1, 0x01, // Ţñ (U+0162 U+00F1)
  0x01, 0x62, 0x00, 0xF2, 0x01, // Ţò (U+0162 U+00F2)
  0x01, 0x62, 0x00, 0xF3, 0x01, // Ţó (U+0162 U+00F3)
  0x01, 0x62, 0x00, 0xF4, 0x01, // Ţô (U+0162 U+00F4)
  0x01, 0x62, 0x00, 0xF5, 0x01, // Ţõ (U+0162 U+00F5)
  0x01, 0x62, 0x00, 0xF6, 0x01, // Ţö (U+0162 U+00F6)
  0x01, 0x62, 0x00, 0xF8, 0x01, // Ţø (U+0162 U+00F8)
  0x01, 0x62, 0x00, 0xF9, 0x01, // Ţù (U+0162 U+00F9)
  0x01, 0x62, 0x00, 0xFA, 0x01, // Ţú (U+0162 U+00FA)
  0x01, 0x62, 0x00, 0xFB, 0x01, // Ţû (U+0162 U+00FB)
  0x01, 0x62, 0x00, 0xFC, 0x01, // Ţü (U+0162 U+00FC)
  0x01, 0x62, 0x01, 0x00, 0x01, // ŢĀ (U+0162 U+0100)
  0x01, 0x62, 0x01, 0x01, 0x01, // Ţā (U+0162 U+0101)
  0x01, 0x62, 0x01, 0x02, 0x01, // ŢĂ (U+0162 U+0102)
  0x01, 0x62, 0x01, 0x03, 0x01, // Ţă (U+0162 U+0103)
  0x01, 0x62, 0x01, 0x04, 0x01, // ŢĄ (U+0162 U+0104)
  0x01, 0x62, 0x01, 0x05, 0x01, // Ţą (U+0162 U+0105)
  0x01, 0x62, 0x01, 0x07, 0x01, // Ţć (U+0162 U+0107)
  0x01, 0x62, 0x01, 0x09, 0x01, // Ţĉ (U+0162 U+0109)
  0x01, 0x62, 0x01, 0x0B, 0x01, // Ţċ (U+0162 U+010B)
  0x01, 0x62, 0x01, 0x0D, 0x01, // Ţč (U+0162 U+010D)
  0x01, 0x62, 0x01, 0x0F, 0x01, // Ţď (U+0162 U+010F)
  0x01, 0x62, 0x01, 0x11, 0x01, // Ţđ (U+0162 U+0111)
  0x01, 0x62, 0x01, 0x13, 0x01, // Ţē (U+0162 U+0113)
  0x01, 0x62, 0x01, 0x15, 0x01, // Ţĕ (U+0162 U+0115)
  0x01, 0x62, 0x01, 0x17, 0x01, // Ţė (U+0162 U+0117)
  0x01, 0x62, 0x01, 0x19, 0x01, // Ţę (U+0162 U+0119)
  0x01, 0x62, 0x01, 0x1B, 0x01, // Ţě (U+0162 U+011B)
  0x01, 0x62, 0x01, 0x1D, 0x01, // Ţĝ (U+0162 U+011D)
  0x01, 0x62, 0x01, 0x1F, 0x01, // Ţğ (U+0162 U+011F)
  0x01, 0x62, 0x01, 0x21, 0x01, // Ţġ (U+0162 U+0121)
  0x01, 0x62, 0x01, 0x23, 0x01, // Ţģ (U+0162 U+0123)
  0x01, 0x62, 0x01, 0x38, 0x01, // Ţĸ (U+0162 U+0138)
  0x01, 0x62, 0x01, 0x44, 0x01, // Ţń (U+0162 U+0144)
  0x01, 0x62, 0x01, 0x46, 0x01, // Ţņ (U+0162 U+0146)
  0x01, 0x62, 0x01, 0x48, 0x01, // Ţň (U+0162 U+0148)
  0x01, 0x62, 0x01, 0x4B, 0x01, // Ţŋ (U+0162 U+014B)
  0x01, 0x62, 0x01, 0x4D, 0x01, // Ţō (U+0162 U+014D)
  0x01, 0x62, 0x01, 0x4F, 0x01, // Ţŏ (U+0162 U+014F)
  0x01, 0x62, 0x01, 0x51, 0x01, // Ţő (U+0162 U+0151)
  0x01, 0x62, 0x01, 0x53, 0x01, // Ţœ (U+0162 U+0153)
  0x01, 0x62, 0x01, 0x55, 0x01, // Ţŕ (U+0162 U+0155)
  0x01, 0x62, 0x01, 0x57, 0x01, // Ţŗ (U+0162 U+0157)
  0x01, 0x62, 0x01, 0x5B, 0x01, // Ţś (U+0162 U+015B)
  0x01, 0x62, 0x01, 0x5D, 0x01, // Ţŝ (U+0162 U+015D)
  0x01, 0x62, 0x01, 0x5F, 0x01, // Ţş (U+0162 U+015F)
  0x01, 0x62, 0x01, 0x61, 0x01, // Ţš (U+0162 U+0161)
  0x01, 0x62, 0x01, 0x69, 0x01, // Ţũ (U+0162 U+0169)
  0x01, 0x62, 0x01, 0x6B, 0x01, // Ţū (U+0162 U+016B)
  0x01, 0x62, 0x01, 0x6D, 0x01, // Ţŭ (U+0162 U+016D)
  0x01, 0x62, 0x01, 0x6F, 0x01, // Ţů (U+0162 U+016F)
  0x01, 0x62, 0x01, 0x71, 0x01, // Ţű (U+0162 U+0171)
  0x01, 0x62, 0x01, 0x73, 0x01, // Ţų (U+0162 U+0173)
  0x01, 0x62, 0x01, 0x7A, 0x01, // Ţź (U+0162 U+017A)
  0x01, 0x62, 0x01, 0x7C, 0x01, // Ţż (U+0162 U+017C)
  0x01, 0x62, 0x01, 0x7E, 0x01, // Ţž (U+0162 U+017E)
  0x01, 0x62, 0x20, 0x13, 0x01, // Ţ– (U+0162 U+2013)
  0x01, 0x62, 0x20, 0x14, 0x01, // Ţ— (U+0162 U+2014)
  0x01, 0x62, 0x20, 0x1A, 0x01, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x01, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x01, // Ţ… (U+0162 U+2026)
  0x01, 0x62, 0x20, 0x39, 0x01, // Ţ‹ (U+0162 U+2039)
  0x01, 0x64, 0x00, 0x2C, 0x01, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2D, 0x01, // Ť- (U+0164 U+002D)
  0x01, 0x64, 0x00, 0x2E, 0x01, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0x41, 0x01, // ŤA (U+0164 U+0041)
  0x01, 0x64, 0x00, 0x61, 0x01, // Ťa (U+0164 U+0061)
  0x01, 0x64, 0x00, 0x63, 0x01, // Ťc (U+0164 U+0063)
  0x01, 0x64, 0x00, 0x64, 0x01, // Ťd (U+0164 U+0064)
  0x01, 0x64, 0x00, 0x65, 0x01, // Ťe (U+0164 U+0065)
  0x01, 0x64, 0x00, 0x67, 0x01, // Ťg (U+0164 U+0067)
  0x01, 0x64, 0x00, 0x6D, 0x01, // Ťm (U+0164 U+006D)
  0x01, 0x64, 0x00, 0x6E, 0x01, // Ťn (U+0164 U+006E)
  0x01, 0x64, 0x00, 0x6F, 0x01, // Ťo (U+0164 U+006F)
  0x01, 0x64, 0x00, 0x70, 0x01, // Ťp (U+0164 U+0070)
  0x01, 0x64, 0x00, 0x71, 0x01, // Ťq (U+0164 U+0071)
  0x01, 0x64, 0x00, 0x72, 0x01, // Ťr (U+0164 U+0072)
  0x01, 0x64, 0x00, 0x73, 0x01, // Ťs (U+0164 U+0073)
  0x01, 0x64, 0x00, 0x75, 0x01, // Ťu (U+0164 U+0075)
  0x01, 0x64, 0x00, 0x7A, 0x01, // Ťz (U+0164 U+007A)
  0x01, 0x64, 0x00, 0xAB, 0x01, // Ť« (U+0164 U+00AB)
  0x01, 0x64, 0x00, 0xC0, 0x01, // ŤÀ (U+0164 U+00C0)
  0x01, 0x64, 0x00, 0xC1, 0x01, // ŤÁ (U+0164 U+00C1)
  0x01, 0x64, 0x00, 0xC2, 0x01, // ŤÂ (U+0164 U+00C2)
  0x01, 0x64, 0x00, 0xC3, 0x01, // ŤÃ (U+0164 U+00C3)
  0x01, 0x64, 0x00, 0xC4, 0x01, // ŤÄ (U+0164 U+00C4)
  0x01, 0x64, 0x00, 0xC5, 0x01, // ŤÅ (U+0164 U+00C5)
  0x01, 0x64, 0x00, 0xE0, 0x01, // Ťà (U+0164 U+00E0)
  0x01, 0x64, 0x00, 0xE1, 0x01, // Ťá (U+0164 U+00E1)
  0x01, 0x64, 0x00, 0xE2, 0x01, // Ťâ (U+0164 U+00E2)
  0x01, 0x64, 0x00, 0xE3, 0x01, // Ťã (U+0164 U+00E3)
  0x01, 0x64, 0x00, 0xE4, 0x01, // Ťä (U+0164 U+00E4)
  0x01, 0x64, 0x00, 0xE5, 0x01, // Ťå (U+0164 U+00E5)
  0x01, 0x64, 0x00, 0xE6, 0x01, // Ťæ (U+0164 U+00E6)
  0x01, 0x64, 0x00, 0xE7, 0x01, // Ťç (U+0164 U+00E7)
  0x01, 0x64, 0x00, 0xE8, 0x01, // Ťè (U+0164 U+00E8)
  0x01, 0x64, 0x00, 0xE9, 0x01, // Ťé (U+0164 U+00E9)
  0x01, 0x64, 0x00, 0xEA, 0x01, // Ťê (U+0164 U+00EA)
  0x01, 0x64, 0x00, 0xEB, 0x01, // Ťë (U+0164 U+00EB)
  0x01, 0x64, 0x00, 0xF1, 0x01, // Ťñ (U+0164 U+00F1)
  0x01, 0x64, 0x00, 0xF2, 0x01, // Ťò (U+0164 U+00F2)
  0x01, 0x64, 0x00, 0xF3, 0x01, // Ťó (U+0164 U+00F3)
  0x01, 0x64, 0x00, 0xF4, 0x01, // Ťô (U+0164 U+00F4)
  0x01, 0x64, 0x00, 0xF5, 0x01, // Ťõ (U+0164 U+00F5)
  0x01, 0x64, 0x00, 0xF6, 0x01, // Ťö (U+0164 U+00F6)
  0x01, 0x64, 0x00, 0xF8, 0x01, // Ťø (U+0164 U+00F8)
  0x01, 0x64, 0x00, 0xF9, 0x01, // Ťù (U+0164 U+00F9)
  0x01, 0x64, 0x00, 0xFA, 0x01, // Ťú (U+0164 U+00FA)
  0x01, 0x64, 0x00, 0xFB, 0x01, // Ťû (U+0164 U+00FB)
  0x01, 0x64, 0x00, 0xFC, 0x01, // Ťü (U+0164 U+00FC)
  0x01, 0x64, 0x01, 0x00, 0x01, // ŤĀ (U+0164 U+0100)
  0x01, 0x64, 0x01, 0x01, 0x01, // Ťā (U+0164 U+0101)
  0x01, 0x64, 0x01, 0x02, 0x01, // ŤĂ (U+0164 U+0102)
  0x01, 0x64, 0x01, 0x03, 0x01, // Ťă (U+0164 U+0103)
  0x01, 0x64, 0x01, 0x04, 0x01, // ŤĄ (U+0164 U+0104)
  0x01, 0x64, 0x01, 0x05, 0x01, // Ťą (U+0164 U+0105)
  0x01, 0x64, 0x01, 0x07, 0x01, // Ťć (U+0164 U+0107)
  0x01, 0x64, 0x01, 0x09, 0x01, // Ťĉ (U+0164 U+0109)
  0x01, 0x64, 0x01, 0x0B, 0x01, // Ťċ (U+0164 U+010B)
  0x01, 0x64, 0x01, 0x0D, 0x01, // Ťč (U+0164 U+010D)
  0x01, 0x64, 0x01, 0x0F, 0x01, // Ťď (U+0164 U+010F)
  0x01, 0x64, 0x01, 0x11, 0x01, // Ťđ (U+0164 U+0111)
  0x01, 0x64, 0x01, 0x13, 0x01, // Ťē (U+0164 U+0113)
  0x01, 0x64, 0x01, 0x15, 0x01, // Ťĕ (U+0164 U+0115)
  0x01, 0x64, 0x01, 0x17, 0x01, // Ťė (U+0164 U+0117)
  0x01, 0x64, 0x01, 0x19, 0x01, // Ťę (U+0164 U+0119)
  0x01, 0x64, 0x01, 0x1B, 0x01, // Ťě (U+0164 U+011B)
  0x01, 0x64, 0x01, 0x1D, 0x01, // Ťĝ (U+0164 U+011D)
  0x01, 0x64, 0x01, 0x1F, 0x01, // Ťğ (U+0164 U+011F)
  0x01, 0x64, 0x01, 0x21, 0x01, // Ťġ (U+0164 U+0121)
  0x01, 0x64, 0x01, 0x23, 0x01, // Ťģ (U+0164 U+0123)
  0x01, 0x64, 0x01, 0x38, 0x01, // Ťĸ (U+0164 U+0138)
  0x01, 0x64, 0x01, 0x44, 0x01, // Ťń (U+0164 U+0144)
  0x01, 0x64, 0x01, 0x46, 0x01, // Ťņ (U+0164 U+0146)
  0x01, 0x64, 0x01, 0x48, 0x01, // Ťň (U+0164 U+0148)
  0x01, 0x64, 0x01, 0x4B, 0x01, // Ťŋ (U+0164 U+014B)
  0x01, 0x64, 0x01, 0x4D, 0x01, // Ťō (U+0164 U+014D)
  0x01, 0x64, 0x01, 0x4F, 0x01, // Ťŏ (U+0164 U+014F)
  0x01, 0x64, 0x01, 0x51, 0x01, // Ťő (U+0164 U+0151)
  0x01, 0x64, 0x01, 0x53, 0x01, // Ťœ (U+0164 U+0153)
  0x01, 0x64, 0x01, 0x55, 0x01, // Ťŕ (U+0164 U+0155)
  0x01, 0x64, 0x01, 0x57, 0x01, // Ťŗ (U+0164 U+0157)
  0x01, 0x64, 0x01, 0x5B, 0x01, // Ťś (U+0164 U+015B)
  0x01, 0x64, 0x01, 0x5D, 0x01, // Ťŝ (U+0164 U+015D)
  0x01, 0x64, 0x01, 0x5F, 0x01, // Ťş (U+0164 U+015F)
  0x01, 0x64, 0x01, 0x61, 0x01, // Ťš (U+0164 U+0161)
  0x01, 0x64, 0x01, 0x69, 0x01, // Ťũ (U+0164 U+0169)
  0x01, 0x64, 0x01, 0x6B, 0x01, // Ťū (U+0164 U+016B)
  0x01, 0x64, 0x01, 0x6D, 0x01, // Ťŭ (U+0164 U+016D)
  0x01, 0x64, 0x01, 0x6F, 0x01, // Ťů (U+0164 U+016F)
  0x01, 0x64, 0x01, 0x71, 0x01, // Ťű (U+0164 U+0171)
  0x01, 0x64, 0x01, 0x73, 0x01, // Ťų (U+0164 U+0173)
  0x01, 0x64, 0x01, 0x7A, 0x01, // Ťź (U+0164 U+017A)
  0x01, 0x64, 0x01, 0x7C, 0x01, // Ťż (U+0164 U+017C)
  0x01, 0x64, 0x01, 0x7E, 0x01, // Ťž (U+0164 U+017E)
  0x01, 0x64, 0x20, 0x13, 0x01, // Ť– (U+0164 U+2013)
  0x01, 0x64, 0x20, 0x14, 0x01, // Ť— (U+0164 U+2014)
  0x01, 0x64, 0x20, 0x1A, 0x01, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x01, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x01, // Ť… (U+0164 U+2026)
  0x01, 0x64, 0x20, 0x39, 0x01, // Ť‹ (U+0164 U+2039)
  0x01, 0x66, 0x00, 0x2C, 0x01, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2D, 0x01, // Ŧ- (U+0166 U+002D)
  0x01, 0x66, 0x00, 0x2E, 0x01, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0x41, 0x01, // ŦA (U+0166 U+0041)
  0x01, 0x66, 0x00, 0x61, 0x01, // Ŧa (U+0166 U+0061)
  0x01, 0x66, 0x00, 0x63, 0x01, // Ŧc (U+0166 U+0063)
  0x01, 0x66, 0x00, 0x64, 0x01, // Ŧd (U+0166 U+0064)
  0x01, 0x66, 0x00, 0x65, 0x01, // Ŧe (U+0166 U+0065)
  0x01, 0x66, 0x00, 0x67, 0x01, // Ŧg (U+0166 U+0067)
  0x01, 0x66, 0x00, 0x6D, 0x01, // Ŧm (U+0166 U+006D)
  0x01, 0x66, 0x00, 0x6E, 0x01, // Ŧn (U+0166 U+006E)
  0x01, 0x66, 0x00, 0x6F, 0x01, // Ŧo (U+0166 U+006F)
  0x01, 0x66, 0x00, 0x70, 0x01, // Ŧp (U+0166 U+0070)
  0x01, 0x66, 0x00, 0x71, 0x01, // Ŧq (U+0166 U+0071)
  0x01, 0x66, 0x00, 0x72, 0x01, // Ŧr (U+0166 U+0072)
  0x01, 0x66, 0x00, 0x73, 0x01, // Ŧs (U+0166 U+0073)
  0x01, 0x66, 0x00, 0x75, 0x01, // Ŧu (U+0166 U+0075)
  0x01, 0x66, 0x00, 0x7A, 0x01, // Ŧz (U+0166 U+007A)
  0x01, 0x66, 0x00, 0xAB, 0x01, // Ŧ« (U+0166 U+00AB)
  0x01, 0x66, 0x00, 0xC0, 0x01, // ŦÀ (U+0166 U+00C0)
  0x01, 0x66, 0x00, 0xC1, 0x01, // ŦÁ (U+0166 U+00C1)
  0x01, 0x66, 0x00, 0xC2, 0x01, // ŦÂ (U+0166 U+00C2)
  0x01, 0x66, 0x00, 0xC3, 0x01, // ŦÃ (U+0166 U+00C3)
  0x01, 0x66, 0x00, 0xC4, 0x01, // ŦÄ (U+0166 U+00C4)
  0x01, 0x66, 0x00, 0xC5, 0x01, // ŦÅ (U+0166 U+00C5)
  0x01, 0x66, 0x00, 0xE0, 0x01, // Ŧà (U+0166 U+00E0)
  0x01, 0x66, 0x00, 0xE1, 0x01, // Ŧá (U+0166 U+00E1)
  0x01, 0x66, 0x00, 0xE2, 0x01, // Ŧâ (U+0166 U+00E2)
  0x01, 0x66, 0x00, 0xE3, 0x01, // Ŧã (U+0166 U+00E3)
  0x01, 0x66, 0x00, 0xE4, 0x01, // Ŧä (U+0166 U+00E4)
  0x01, 0x66, 0x00, 0xE5, 0x01, // Ŧå (U+0166 U+00E5)
  0x01, 0x66, 0x00, 0xE6, 0x01, // Ŧæ (U+0166 U+00E6)
  0x01, 0x66, 0x00, 0xE7, 0x01, // Ŧç (U+0166 U+00E7)
  0x01, 0x66, 0x00, 0xE8, 0x01, // Ŧè (U+0166 U+00E8)
  0x01, 0x66, 0x00, 0xE9, 0x01, // Ŧé (U+0166 U+00E9)
  0x01, 0x66, 0x00, 0xEA, 0x01, // Ŧê (U+0166 U+00EA)
  0x01, 0x66, 0x00, 0xEB, 0x01, // Ŧë (U+0166 U+00EB)
  0x01, 0x66, 0x00, 0xF1, 0x01, // Ŧñ (U+0166 U+00F1)
  0x01, 0x66, 0x00, 0xF2, 0x01, // Ŧò (U+0166 U+00F2)
  0x01, 0x66, 0x00, 0xF3, 0x01, // Ŧó (U+0166 U+00F3)
  0x01, 0x66, 0x00, 0xF4, 0x01, // Ŧô (U+0166 U+00F4)
  0x01, 0x66, 0x00, 0xF5, 0x01, // Ŧõ (U+0166 U+00F5)
  0x01, 0x66, 0x00, 0xF6, 0x01, // Ŧö (U+0166 U+00F6)
  0x01, 0x66, 0x00, 0xF8, 0x01, // Ŧø (U+0166 U+00F8)
  0x01, 0x66, 0x00, 0xF9, 0x01, // Ŧù (U+0166 U+00F9)
  0x01, 0x66, 0x00, 0xFA, 0x01, // Ŧú (U+0166 U+00FA)
  0x01, 0x66, 0x00, 0xFB, 0x01, // Ŧû (U+0166 U+00FB)
  0x01, 0x66, 0x00, 0xFC, 0x01, // Ŧü (U+0166 U+00FC)
  0x01, 0x66, 0x01, 0x00, 0x01, // ŦĀ (U+0166 U+0100)
  0x01, 0x66, 0x01, 0x01, 0x01, // Ŧā (U+0166 U+0101)
  0x01, 0x66, 0x01, 0x02, 0x01, // ŦĂ (U+0166 U+0102)
  0x01, 0x66, 0x01, 0x03, 0x01, // Ŧă (U+0166 U+0103)
  0x01, 0x66, 0x01, 0x04, 0x01, // ŦĄ (U+0166 U+0104)
  0x01, 0x66, 0x01, 0x05, 0x01, // Ŧą (U+0166 U+0105)
  0x01, 0x66, 0x01, 0x07, 0x01, // Ŧć (U+0166 U+0107)
  0x01, 0x66, 0x01, 0x09, 0x01, // Ŧĉ (U+0166 U+0109)
  0x01, 0x66, 0x01, 0x0B, 0x01, // Ŧċ (U+0166 U+010B)
  0x01, 0x66, 0x01, 0x0D, 0x01, // Ŧč (U+0166 U+010D)
  0x01, 0x66, 0x01, 0x0F, 0x01, // Ŧď (U+0166 U+010F)
  0x01, 0x66, 0x01, 0x11, 0x01, // Ŧđ (U+0166 U+0111)
  0x01, 0x66, 0x01, 0x13, 0x01, // Ŧē (U+0166 U+0113)
  0x01, 0x66, 0x01, 0x15, 0x01, // Ŧĕ (U+0166 U+0115)
  0x01, 0x66, 0x01, 0x17, 0x01, // Ŧė (U+0166 U+0117)
  0x01, 0x66, 0x01, 0x19, 0x01, // Ŧę (U+0166 U+0119)
  0x01, 0x66, 0x01, 0x1B, 0x01, // Ŧě (U+0166 U+011B)
  0x01, 0x66, 0x01, 0x1D, 0x01, // Ŧĝ (U+0166 U+011D)
  0x01, 0x66, 0x01, 0x1F, 0x01, // Ŧğ (U+0166 U+011F)
  0x01, 0x66, 0x01, 0x21, 0x01, // Ŧġ (U+0166 U+0121)
  0x01, 0x66, 0x01, 0x23, 0x01, // Ŧģ (U+0166 U+0123)
  0x01, 0x66, 0x01, 0x38, 0x01, // Ŧĸ (U+0166 U+0138)
  0x01, 0x66, 0x01, 0x44, 0x01, // Ŧń (U+0166 U+0144)
  0x01, 0x66, 0x01, 0x46, 0x01, // Ŧņ (U+0166 U+0146)
  0x01, 0x66, 0x01, 0x48, 0x01, // Ŧň (U+0166 U+0148)
  0x01, 0x66, 0x01, 0x4B, 0x01, // Ŧŋ (U+0166 U+014B)
  0x01, 0x66, 0x01, 0x4D, 0x01, // Ŧō (U+0166 U+014D)
  0x01, 0x66, 0x01, 0x4F, 0x01, // Ŧŏ (U+0166 U+014F)
  0x01, 0x66, 0x01, 0x51, 0x01, // Ŧő (U+0166 U+0151)
  0x01, 0x66, 0x01, 0x53, 0x01, // Ŧœ (U+0166 U+0153)
  0x01, 0x66, 0x01, 0x55, 0x01, // Ŧŕ (U+0166 U+0155)
  0x01, 0x66, 0x01, 0x57, 0x01, // Ŧŗ (U+0166 U+0157)
  0x01, 0x66, 0x01, 0x5B, 0x01, // Ŧś (U+0166 U+015B)
  0x01, 0x66, 0x01, 0x5D, 0x01, // Ŧŝ (U+0166 U+015D)
  0x01, 0x66, 0x01, 0x5F, 0x01, // Ŧş (U+0166 U+015F)
  0x01, 0x66, 0x01, 0x61, 0x01, // Ŧš (U+0166 U+0161)
  0x01, 0x66, 0x01, 0x69, 0x01, // Ŧũ (U+0166 U+0169)
  0x01, 0x66, 0x01, 0x6B, 0x01, // Ŧū (U+0166 U+016B)
  0x01, 0x66, 0x01, 0x6D, 0x01, // Ŧŭ (U+0166 U+016D)
  0x01, 0x66, 0x01, 0x6F, 0x01, // Ŧů (U+0166 U+016F)
  0x01, 0x66, 0x01, 0x71, 0x01, // Ŧű (U+0166 U+0171)
  0x01, 0x66, 0x01, 0x73, 0x01, // Ŧų (U+0166 U+0173)
  0x01, 0x66, 0x01, 0x7A, 0x01, // Ŧź (U+0166 U+017A)
  0x01, 0x66, 0x01, 0x7C, 0x01, // Ŧż (U+0166 U+017C)
  0x01, 0x66, 0x01, 0x7E, 0x01, // Ŧž (U+0166 U+017E)
  0x01, 0x66, 0x20, 0x13, 0x01, // Ŧ– (U+0166 U+2013)
  0x01, 0x66, 0x20, 0x14, 0x01, // Ŧ— (U+0166 U+2014)
  0x01, 0x66, 0x20, 0x1A, 0x01, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x01, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x01, // Ŧ… (U+0166 U+2026)
  0x01, 0x66, 0x20, 0x39, 0x01, // Ŧ‹ (U+0166 U+2039)
  0x01, 0x74, 0x00, 0x2C, 0x01, // Ŵ, (U+0174 U+002C)
  0x01, 0x74, 0x00, 0x2E, 0x01, // Ŵ. (U+0174 U+002E)
  0x01, 0x74, 0x00, 0xAB, 0x01, // Ŵ« (U+0174 U+00AB)
  0x01, 0x74, 0x20, 0x1A, 0x01, // Ŵ‚ (U+0174 U+201A)
  0x01, 0x74, 0x20, 0x1E, 0x01, // Ŵ„ (U+0174 U+201E)
  0x01, 0x74, 0x20, 0x26, 0x01, // Ŵ… (U+0174 U+2026)
  0x01, 0x74, 0x20, 0x39, 0x01, // Ŵ‹ (U+0174 U+2039)
  0x01, 0x76, 0x00, 0x2C, 0x01, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x01, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x00, 0x61, 0x01, // Ŷa (U+0176 U+0061)
  0x01, 0x76, 0x00, 0x63, 0x01, // Ŷc (U+0176 U+0063)
  0x01, 0x76, 0x00, 0x64, 0x01, // Ŷd (U+0176 U+0064)
  0x01, 0x76, 0x00, 0x65, 0x01, // Ŷe (U+0176 U+0065)
  0x01, 0x76, 0x00, 0x6D, 0x01, // Ŷm (U+0176 U+006D)
  0x01, 0x76, 0x00, 0x6E, 0x01, // Ŷn (U+0176 U+006E)
  0x01, 0x76, 0x00, 0x6F, 0x01, // Ŷo (U+0176 U+006F)
  0x01, 0x76, 0x00, 0x70, 0x01, // Ŷp (U+0176 U+0070)
  0x01, 0x76, 0x00, 0x71, 0x01, // Ŷq (U+0176 U+0071)
  0x01, 0x76, 0x00, 0x72, 0x01, // Ŷr (U+0176 U+0072)
  0x01, 0x76, 0x00, 0x75, 0x01, // Ŷu (U+0176 U+0075)
  0x01, 0x76, 0x00, 0xAB, 0x01, // Ŷ« (U+0176 U+00AB)
  0x01, 0x76, 0x00, 0xBB, 0x01, // Ŷ» (U+0176 U+00BB)
  0x01, 0x76, 0x00, 0xE0, 0x01, // Ŷà (U+0176 U+00E0)
  0x01, 0x76, 0x00, 0xE1, 0x01, // Ŷá (U+0176 U+00E1)
  0x01, 0x76, 0x00, 0xE2, 0x01, // Ŷâ (U+0176 U+00E2)
  0x01, 0x76, 0x00, 0xE3, 0x01, // Ŷã (U+0176 U+00E3)
  0x01, 0x76, 0x00, 0xE4, 0x01, // Ŷä (U+0176 U+00E4)
  0x01, 0x76, 0x00, 0xE5, 0x01, // Ŷå (U+0176 U+00E5)
  0x01, 0x76, 0x00, 0xE6, 0x01, // Ŷæ (U+0176 U+00E6)
  0x01, 0x76, 0x00, 0xE7, 0x01, // Ŷç (U+0176 U+00E7)
  0x01, 0x76, 0x00, 0xE8, 0x01, // Ŷè (U+0176 U+00E8)
  0x01, 0x76, 0x00, 0xE9, 0x01, // Ŷé (U+0176 U+00E9)
  0x01, 0x76, 0x00, 0xEA, 0x01, // Ŷê (U+0176 U+00EA)
  0x01, 0x76, 0x00, 0xEB, 0x01, // Ŷë (U+0176 U+00EB)
  0x01, 0x76, 0x00, 0xF1, 0x01, // Ŷñ (U+0176 U+00F1)
  0x01, 0x76, 0x00, 0xF2, 0x01, // Ŷò (U+0176 U+00F2)
  0x01, 0x76, 0x00, 0xF3, 0x01, // Ŷó (U+0176 U+00F3)
  0x01, 0x76, 0x00, 0xF4, 0x01, // Ŷô (U+0176 U+00F4)
  0x01, 0x76, 0x00, 0xF5, 0x01, // Ŷõ (U+0176 U+00F5)
  0x01, 0x76, 0x00, 0xF6, 0x01, // Ŷö (U+0176 U+00F6)
  0x01, 0x76, 0x00, 0xF8, 0x01, // Ŷø (U+0176 U+00F8)
  0x01, 0x76, 0x00, 0xF9, 0x01, // Ŷù (U+0176 U+00F9)
  0x01, 0x76, 0x00, 0xFA, 0x01, // Ŷú (U+0176 U+00FA)
  0x01, 0x76, 0x00, 0xFB, 0x01, // Ŷû (U+0176 U+00FB)
  0x01, 0x76, 0x00, 0xFC, 0x01, // Ŷü (U+0176 U+00FC)
  0x01, 0x76, 0x01, 0x01, 0x01, // Ŷā (U+0176 U+0101)
  0x01, 0x76, 0x01, 0x03, 0x01, // Ŷă (U+0176 U+0103)
  0x01, 0x76, 0x01, 0x05, 0x01, // Ŷą (U+0176 U+0105)
  0x01, 0x76, 0x01, 0x07, 0x01, // Ŷć (U+0176 U+0107)
  0x01, 0x76, 0x01, 0x09, 0x01, // Ŷĉ (U+0176 U+0109)
  0x01, 0x76, 0x01, 0x0B, 0x01, // Ŷċ (U+0176 U+010B)
  0x01, 0x76, 0x01, 0x0D, 0x01, // Ŷč (U+0176 U+010D)
  0x01, 0x76, 0x01, 0x0F, 0x01, // Ŷď (U+0176 U+010F)
  0x01, 0x76, 0x01, 0x11, 0x01, // Ŷđ (U+0176 U+0111)
  0x01, 0x76, 0x01, 0x13, 0x01, // Ŷē (U+0176 U+0113)
  0x01, 0x76, 0x01, 0x15, 0x01, // Ŷĕ (U+0176 U+0115)
  0x01, 0x76, 0x01, 0x17, 0x01, // Ŷė (U+0176 U+0117)
  0x01, 0x76, 0x01, 0x19, 0x01, // Ŷę (U+0176 U+0119)
  0x01, 0x76, 0x01, 0x1B, 0x01, // Ŷě (U+0176 U+011B)
  0x01, 0x76, 0x01, 0x38, 0x01, // Ŷĸ (U+0176 U+0138)
  0x01, 0x76, 0x01, 0x44, 0x01, // Ŷń (U+0176 U+0144)
  0x01, 0x76, 0x01, 0x46, 0x01, // Ŷņ (U+0176 U+0146)
  0x01, 0x76, 0x01, 0x48, 0x01, // Ŷň (U+0176 U+0148)
  0x01, 0x76, 0x01, 0x4B, 0x01, // Ŷŋ (U+0176 U+014B)
  0x01, 0x76, 0x01, 0x4D, 0x01, // Ŷō (U+0176 U+014D)
  0x01, 0x76, 0x01, 0x4F, 0x01, // Ŷŏ (U+0176 U+014F)
  0x01, 0x76, 0x01, 0x51, 0x01, // Ŷő (U+0176 U+0151)
  0x01, 0x76, 0x01, 0x53, 0x01, // Ŷœ (U+0176 U+0153)
  0x01, 0x76, 0x01, 0x55, 0x01, // Ŷŕ (U+0176 U+0155)
  0x01, 0x76, 0x01, 0x57, 0x01, // Ŷŗ (U+0176 U+0157)
  0x01, 0x76, 0x01, 0x69, 0x01, // Ŷũ (U+0176 U+0169)
  0x01, 0x76, 0x01, 0x6B, 0x01, // Ŷū (U+0176 U+016B)
  0x01, 0x76, 0x01, 0x6D, 0x01, // Ŷŭ (U+0176 U+016D)
  0x01, 0x76, 0x01, 0x6F, 0x01, // Ŷů (U+0176 U+016F)
  0x01, 0x76, 0x01, 0x71, 0x01, // Ŷű (U+0176 U+0171)
  0x01, 0x76, 0x01, 0x73, 0x01, // Ŷų (U+0176 U+0173)
  0x01, 0x76, 0x20, 0x1A, 0x01, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x01, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x01, // Ŷ… (U+0176 U+2026)
  0x01, 0x76, 0x20, 0x39, 0x01, // Ŷ‹ (U+0176 U+2039)
  0x01, 0x76, 0x20, 0x3A, 0x01, // Ŷ› (U+0176 U+203A)
  0x01, 0x78, 0x00, 0x2C, 0x01, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x01, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x00, 0x61, 0x01, // Ÿa (U+0178 U+0061)
  0x01, 0x78, 0x00, 0x63, 0x01, // Ÿc (U+0178 U+0063)
  0x01, 0x78, 0x00, 0x64, 0x01, // Ÿd (U+0178 U+0064)
  0x01, 0x78, 0x00, 0x65, 0x01, // Ÿe (U+0178 U+0065)
  0x01, 0x78, 0x00, 0x6D, 0x01, // Ÿm (U+0178 U+006D)
  0x01, 0x78, 0x00, 0x6E, 0x01, // Ÿn (U+0178 U+006E)
  0x01, 0x78, 0x00, 0x6F, 0x01, // Ÿo (U+0178 U+006F)
  0x01, 0x78, 0x00, 0x70, 0x01, // Ÿp (U+0178 U+0070)
  0x01, 0x78, 0x00, 0x71, 0x01, // Ÿq (U+0178 U+0071)
  0x01, 0x78, 0x00, 0x72, 0x01, // Ÿr (U+0178 U+0072)
  0x01, 0x78, 0x00, 0x75, 0x01, // Ÿu (U+0178 U+0075)
  0x01, 0x78, 0x00, 0xAB, 0x01, // Ÿ« (U+0178 U+00AB)
  0x01, 0x78, 0x00, 0xBB, 0x01, // Ÿ» (U+0178 U+00BB)
  0x01, 0x78, 0x00, 0xE0, 0x01, // Ÿà (U+0178 U+00E0)
  0x01, 0x78, 0x00, 0xE1, 0x01, // Ÿá (U+0178 U+00E1)
  0x01, 0x78, 0x00, 0xE2, 0x01, // Ÿâ (U+0178 U+00E2)
  0x01, 0x78, 0x00, 0xE3, 0x01, // Ÿã (U+0178 U+00E3)
  0x01, 0x78, 0x00, 0xE4, 0x01, // Ÿä (U+0178 U+00E4)
  0x01, 0x78, 0x00, 0xE5, 0x01, // Ÿå (U+0178 U+00E5)
  0x01, 0x78, 0x00, 0xE6, 0x01, // Ÿæ (U+0178 U+00E6)
  0x01, 0x78, 0x00, 0xE7, 0x01, // Ÿç (U+0178 U+00E7)
  0x01, 0x78, 0x00, 0xE8, 0x01, // Ÿè (U+0178 U+00E8)
  0x01, 0x78, 0x00, 0xE9, 0x01, // Ÿé (U+0178 U+00E9)
  0x01, 0x78, 0x00, 0xEA, 0x01, // Ÿê (U+0178 U+00EA)
  0x01, 0x78, 0x00, 0xEB, 0x01, // Ÿë (U+0178 U+00EB)
  0x01, 0x78, 0x00, 0xF1, 0x01, // Ÿñ (U+0178 U+00F1)
  0x01, 0x78, 0x00, 0xF2, 0x01, // Ÿò (U+0178 U+00F2)
  0x01, 0x78, 0x00, 0xF3, 0x01, // Ÿó (U+0178 U+00F3)
  0x01, 0x78, 0x00, 0xF4, 0x01, // Ÿô (U+0178 U+00F4)
  0x01, 0x78, 0x00, 0xF5, 0x01, // Ÿõ (U+0178 U+00F5)
  0x01, 0x78, 0x00, 0xF6, 0x01, // Ÿö (U+0178 U+00F6)
  0x01, 0x78, 0x00, 0xF8, 0x01, // Ÿø (U+0178 U+00F8)
  0x01, 0x78, 0x00, 0xF9, 0x01, // Ÿù (U+0178 U+00F9)
  0x01, 0x78, 0x00, 0xFA, 0x01, // Ÿú (U+0178 U+00FA)
  0x01, 0x78, 0x00, 0xFB, 0x01, // Ÿû (U+0178 U+00FB)
  0x01, 0x78, 0x00, 0xFC, 0x01, // Ÿü (U+0178 U+00FC)
  0x01, 0x78, 0x01, 0x01, 0x01, // Ÿā (U+0178 U+0101)
  0x01, 0x78, 0x01, 0x03, 0x01, // Ÿă (U+0178 U+0103)
  0x01, 0x78, 0x01, 0x05, 0x01, // Ÿą (U+0178 U+0105)
  0x01, 0x78, 0x01, 0x07, 0x01, // Ÿć (U+0178 U+0107)
  0x01, 0x78, 0x01, 0x09, 0x01, // Ÿĉ (U+0178 U+0109)
  0x01, 0x78, 0x01, 0x0B, 0x01, // Ÿċ (U+0178 U+010B)
  0x01, 0x78, 0x01, 0x0D, 0x01, // Ÿč (U+0178 U+010D)
  0x01, 0x78, 0x01, 0x0F, 0x01, // Ÿď (U+0178 U+010F)
  0x01, 0x78, 0x01, 0x11, 0x01, // Ÿđ (U+0178 U+0111)
  0x01, 0x78, 0x01, 0x13, 0x01, // Ÿē (U+0178 U+0113)
  0x01, 0x78, 0x01, 0x15, 0x01, // Ÿĕ (U+0178 U+0115)
  0x01, 0x78, 0x01, 0x17, 0x01, // Ÿė (U+0178 U+0117)
  0x01, 0x78, 0x01, 0x19, 0x01, // Ÿę (U+0178 U+0119)
  0x01, 0x78, 0x01, 0x1B, 0x01, // Ÿě (U+0178 U+011B)
  0x01, 0x78, 0x01, 0x38, 0x01, // Ÿĸ (U+0178 U+0138)
  0x01, 0x78, 0x01, 0x44, 0x01, // Ÿń (U+0178 U+0144)
  0x01, 0x78, 0x01, 0x46, 0x01, // Ÿņ (U+0178 U+0146)
  0x01, 0x78, 0x01, 0x48, 0x01, // Ÿň (U+0178 U+0148)
  0x01, 0x78, 0x01, 0x4B, 0x01, // Ÿŋ (U+0178 U+014B)
  0x01, 0x78, 0x01, 0x4D, 0x01, // Ÿō (U+0178 U+014D)
  0x01, 0x78, 0x01, 0x4F, 0x01, // Ÿŏ (U+0178 U+014F)
  0x01, 0x78, 0x01, 0x51, 0x01, // Ÿő (U+0178 U+0151)
  0x01, 0x78, 0x01, 0x53, 0x01, // Ÿœ (U+0178 U+0153)
  0x01, 0x78, 0x01, 0x55, 0x01, // Ÿŕ (U+0178 U+0155)
  0x01, 0x78, 0x01, 0x57, 0x01, // Ÿŗ (U+0178 U+0157)
  0x01, 0x78, 0x01, 0x69, 0x01, // Ÿũ (U+0178 U+0169)
  0x01, 0x78, 0x01, 0x6B, 0x01, // Ÿū (U+0178 U+016B)
  0x01, 0x78, 0x01, 0x6D, 0x01, // Ÿŭ (U+0178 U+016D)
  0x01, 0x78, 0x01, 0x6F, 0x01, // Ÿů (U+0178 U+016F)
  0x01, 0x78, 0x01, 0x71, 0x01, // Ÿű (U+0178 U+0171)
  0x01, 0x78, 0x01, 0x73, 0x01, // Ÿų (U+0178 U+0173)
  0x01, 0x78, 0x20, 0x1A, 0x01, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x01, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x01, // Ÿ… (U+0178 U+2026)
  0x01, 0x78, 0x20, 0x39, 0x01, // Ÿ‹ (U+0178 U+2039)
  0x01, 0x78, 0x20, 0x3A, 0x01, // Ÿ› (U+0178 U+203A)
  0x20, 0x13, 0x00, 0x54, 0x01, // –T (U+2013 U+0054)
  0x20, 0x13, 0x01, 0x62, 0x01, // –Ţ (U+2013 U+0162)
  0x20, 0x13, 0x01, 0x64, 0x01, // –Ť (U+2013 U+0164)
  0x20, 0x13, 0x01, 0x66, 0x01, // –Ŧ (U+2013 U+0166)
  0x20, 0x14, 0x00, 0x54, 0x01, // —T (U+2014 U+0054)
  0x20, 0x14, 0x01, 0x62, 0x01, // —Ţ (U+2014 U+0162)
  0x20, 0x14, 0x01, 0x64, 0x01, // —Ť (U+2014 U+0164)
  0x20, 0x14, 0x01, 0x66, 0x01, // —Ŧ (U+2014 U+0166)
  0x20, 0x18, 0x00, 0x41, 0x01, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0x61, 0x01, // ‘a (U+2018 U+0061)
  0x20, 0x18, 0x00, 0x63, 0x01, // ‘c (U+2018 U+0063)
  0x20, 0x18, 0x00, 0x64, 0x01, // ‘d (U+2018 U+0064)
  0x20, 0x18, 0x00, 0x65, 0x01, // ‘e (U+2018 U+0065)
  0x20, 0x18, 0x00, 0x67, 0x01, // ‘g (U+2018 U+0067)
  0x20, 0x18, 0x00, 0x6D, 0x01, // ‘m (U+2018 U+006D)
  0x20, 0x18, 0x00, 0x6E, 0x01, // ‘n (U+2018 U+006E)
  0x20, 0x18, 0x00, 0x6F, 0x01, // ‘o (U+2018 U+006F)
  0x20, 0x18, 0x00, 0x70, 0x01, // ‘p (U+2018 U+0070)
  0x20, 0x18, 0x00, 0x71, 0x01, // ‘q (U+2018 U+0071)
  0x20, 0x18, 0x00, 0x72, 0x01, // ‘r (U+2018 U+0072)
  0x20, 0x18, 0x00, 0x73, 0x01, // ‘s (U+2018 U+0073)
  0x20, 0x18, 0x00, 0x75, 0x01, // ‘u (U+2018 U+0075)
  0x20, 0x18, 0x00, 0xC0, 0x01, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x01, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x01, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x01, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x01, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x01, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xE0, 0x01, // ‘à (U+2018 U+00E0)
  0x20, 0x18, 0x00, 0xE1, 0x01, // ‘á (U+2018 U+00E1)
  0x20, 0x18, 0x00, 0xE2, 0x01, // ‘â (U+2018 U+00E2)
  0x20, 0x18, 0x00, 0xE3, 0x01, // ‘ã (U+2018 U+00E3)
  0x20, 0x18, 0x00, 0xE4, 0x01, // ‘ä (U+2018 U+00E4)
  0x20, 0x18, 0x00, 0xE5, 0x01, // ‘å (U+2018 U+00E5)
  0x20, 0x18, 0x00, 0xE6, 0x01, // ‘æ (U+2018 U+00E6)
  0x20, 0x18, 0x00, 0xE7, 0x01, // ‘ç (U+2018 U+00E7)
  0x20, 0x18, 0x00, 0xE8, 0x01, // ‘è (U+2018 U+00E8)
  0x20, 0x18, 0x00, 0xE9, 0x01, // ‘é (U+2018 U+00E9)
  0x20, 0x18, 0x00, 0xEA, 0x01, // ‘ê (U+2018 U+00EA)
  0x20, 0x18, 0x00, 0xEB, 0x01, // ‘ë (U+2018 U+00EB)
  0x20, 0x18, 0x00, 0xF1, 0x01, // ‘ñ (U+2018 U+00F1)
  0x20, 0x18, 0x00, 0xF2, 0x01, // ‘ò (U+2018 U+00F2)
  0x20, 0x18, 0x00, 0xF3, 0x01, // ‘ó (U+2018 U+00F3)
  0x20, 0x18, 0x00, 0xF4, 0x01, // ‘ô (U+2018 U+00F4)
  0x20, 0x18, 0x00, 0xF5, 0x01, // ‘õ (U+2018 U+00F5)
  0x20, 0x18, 0x00, 0xF6, 0x01, // ‘ö (U+2018 U+00F6)
  0x20, 0x18, 0x00, 0xF8, 0x01, // ‘ø (U+2018 U+00F8)
  0x20, 0x18, 0x00, 0xF9, 0x01, // ‘ù (U+2018 U+00F9)
  0x20, 0x18, 0x00, 0xFA, 0x01, // ‘ú (U+2018 U+00FA)
  0x20, 0x18, 0x00, 0xFB, 0x01, // ‘û (U+2018 U+00FB)
  0x20, 0x18, 0x00, 0xFC, 0x01, // ‘ü (U+2018 U+00FC)
  0x20, 0x18, 0x01, 0x00, 0x01, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x01, 0x01, // ‘ā (U+2018 U+0101)
  0x20, 0x18, 0x01, 0x02, 0x01, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x03, 0x01, // ‘ă (U+2018 U+0103)
  0x20, 0x18, 0x01, 0x04, 0x01, // ‘Ą (U+2018 U+0104)
  0x20, 0x18, 0x01, 0x05, 0x01, // ‘ą (U+2018 U+0105)
  0x20, 0x18, 0x01, 0x07, 0x01, // ‘ć (U+2018 U+0107)
  0x20, 0x18, 0x01, 0x09, 0x01, // ‘ĉ (U+2018 U+0109)
  0x20, 0x18, 0x01, 0x0B, 0x01, // ‘ċ (U+2018 U+010B)
  0x20, 0x18, 0x01, 0x0D, 0x01, // ‘č (U+2018 U+010D)
  0x20, 0x18, 0x01, 0x0F, 0x01, // ‘ď (U+2018 U+010F)
  0x20, 0x18, 0x01, 0x11, 0x01, // ‘đ (U+2018 U+0111)
  0x20, 0x18, 0x01, 0x13, 0x01, // ‘ē (U+2018 U+0113)
  0x20, 0x18, 0x01, 0x15, 0x01, // ‘ĕ (U+2018 U+0115)
  0x20, 0x18, 0x01, 0x17, 0x01, // ‘ė (U+2018 U+0117)
  0x20, 0x18, 0x01, 0x19, 0x01, // ‘ę (U+2018 U+0119)
  0x20, 0x18, 0x01, 0x1B, 0x01, // ‘ě (U+2018 U+011B)
  0x20, 0x18, 0x01, 0x1D, 0x01, // ‘ĝ (U+2018 U+011D)
  0x20, 0x18, 0x01, 0x1F, 0x01, // ‘ğ (U+2018 U+011F)
  0x20, 0x18, 0x01, 0x21, 0x01, // ‘ġ (U+2018 U+0121)
  0x20, 0x18, 0x01, 0x23, 0x01, // ‘ģ (U+2018 U+0123)
  0x20, 0x18, 0x01, 0x38, 0x01, // ‘ĸ (U+2018 U+0138)
  0x20, 0x18, 0x01, 0x44, 0x01, // ‘ń (U+2018 U+0144)
  0x20, 0x18, 0x01, 0x46, 0x01, // ‘ņ (U+2018 U+0146)
  0x20, 0x18, 0x01, 0x48, 0x01, // ‘ň (U+2018 U+0148)
  0x20, 0x18, 0x01, 0x4B, 0x01, // ‘ŋ (U+2018 U+014B)
  0x20, 0x18, 0x01, 0x4D, 0x01, // ‘ō (U+2018 U+014D)
  0x20, 0x18, 0x01, 0x4F, 0x01, // ‘ŏ (U+2018 U+014F)
  0x20, 0x18, 0x01, 0x51, 0x01, // ‘ő (U+2018 U+0151)
  0x20, 0x18, 0x01, 0x53, 0x01, // ‘œ (U+2018 U+0153)
  0x20, 0x18, 0x01, 0x55, 0x01, // ‘ŕ (U+2018 U+0155)
  0x20, 0x18, 0x01, 0x57, 0x01, // ‘ŗ (U+2018 U+0157)
  0x20, 0x18, 0x01, 0x5B, 0x01, // ‘ś (U+2018 U+015B)
  0x20, 0x18, 0x01, 0x5D, 0x01, // ‘ŝ (U+2018 U+015D)
  0x20, 0x18, 0x01, 0x5F, 0x01, // ‘ş (U+2018 U+015F)
  0x20, 0x18, 0x01, 0x61, 0x01, // ‘š (U+2018 U+0161)
  0x20, 0x18, 0x01, 0x69, 0x01, // ‘ũ (U+2018 U+0169)
  0x20, 0x18, 0x01, 0x6B, 0x01, // ‘ū (U+2018 U+016B)
  0x20, 0x18, 0x01, 0x6D, 0x01, // ‘ŭ (U+2018 U+016D)
  0x20, 0x18, 0x01, 0x6F, 0x01, // ‘ů (U+2018 U+016F)
  0x20, 0x18, 0x01, 0x71, 0x01, // ‘ű (U+2018 U+0171)
  0x20, 0x18, 0x01, 0x73, 0x01, // ‘ų (U+2018 U+0173)
  0x20, 0x19, 0x00, 0x41, 0x01, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0x61, 0x01, // ’a (U+2019 U+0061)
  0x20, 0x19, 0x00, 0x63, 0x01, // ’c (U+2019 U+0063)
  0x20, 0x19, 0x00, 0x64, 0x01, // ’d (U+2019 U+0064)
  0x20, 0x19, 0x00, 0x65, 0x01, // ’e (U+2019 U+0065)
  0x20, 0x19, 0x00, 0x67, 0x01, // ’g (U+2019 U+0067)
  0x20, 0x19, 0x00, 0x6D, 0x01, // ’m (U+2019 U+006D)
  0x20, 0x19, 0x00, 0x6E, 0x01, // ’n (U+2019 U+006E)
  0x20, 0x19, 0x00, 0x6F, 0x01, // ’o (U+2019 U+006F)
  0x20, 0x19, 0x00, 0x70, 0x01, // ’p (U+2019 U+0070)
  0x20, 0x19, 0x00, 0x71, 0x01, // ’q (U+2019 U+0071)
  0x20, 0x19, 0x00, 0x72, 0x01, // ’r (U+2019 U+0072)
  0x20, 0x19, 0x00, 0x73, 0x01, // ’s (U+2019 U+0073)
  0x20, 0x19, 0x00, 0x75, 0x01, // ’u (U+2019 U+0075)
  0x20, 0x19, 0x00, 0xC0, 0x01, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x01, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x01, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x01, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x01, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x01, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xE0, 0x01, // ’à (U+2019 U+00E0)
  0x20, 0x19, 0x00, 0xE1, 0x01, // ’á (U+2019 U+00E1)
  0x20, 0x19, 0x00, 0xE2, 0x01, // ’â (U+2019 U+00E2)
  0x20, 0x19, 0x00, 0xE3, 0x01, // ’ã (U+2019 U+00E3)
  0x20, 0x19, 0x00, 0xE4, 0x01, // ’ä (U+2019 U+00E4)
  0x20, 0x19, 0x00, 0xE5, 0x01, // ’å (U+2019 U+00E5)
  0x20, 0x19, 0x00, 0xE6, 0x01, // ’æ (U+2019 U+00E6)
  0x20, 0x19, 0x00, 0xE7, 0x01, // ’ç (U+2019 U+00E7)
  0x20, 0x19, 0x00, 0xE8, 0x01, // ’è (U+2019 U+00E8)
  0x20, 0x19, 0x00, 0xE9, 0x01, // ’é (U+2019 U+00E9)
  0x20, 0x19, 0x00, 0xEA, 0x01, // ’ê (U+2019 U+00EA)
  0x20, 0x19, 0x00, 0xEB, 0x01, // ’ë (U+2019 U+00EB)
  0x20, 0x19, 0x00, 0xF1, 0x01, // ’ñ (U+2019 U+00F1)
  0x20, 0x19, 0x00, 0xF2, 0x01, // ’ò (U+2019 U+00F2)
  0x20, 0x19, 0x00, 0xF3, 0x01, // ’ó (U+2019 U+00F3)
  0x20, 0x19, 0x00, 0xF4, 0x01, // ’ô (U+2019 U+00F4)
  0x20, 0x19, 0x00, 0xF5, 0x01, // ’õ (U+2019 U+00F5)
  0x20, 0x19, 0x00, 0xF6, 0x01, // ’ö (U+2019 U+00F6)
  0x20, 0x19, 0x00, 0xF8, 0x01, // ’ø (U+2019 U+00F8)
  0x20, 0x19, 0x00, 0xF9, 0x01, // ’ù (U+2019 U+00F9)
  0x20, 0x19, 0x00, 0xFA, 0x01, // ’ú (U+2019 U+00FA)
  0x20, 0x19, 0x00, 0xFB, 0x01, // ’û (U+2019 U+00FB)
  0x20, 0x19, 0x00, 0xFC, 0x01, // ’ü (U+2019 U+00FC)
  0x20, 0x19, 0x01, 0x00, 0x01, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x01, 0x01, // ’ā (U+2019 U+0101)
  0x20, 0x19, 0x01, 0x02, 0x01, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x03, 0x01, // ’ă (U+2019 U+0103)
  0x20, 0x19, 0x01, 0x04, 0x01, // ’Ą (U+2019 U+0104)
  0x20, 0x19, 0x01, 0x05, 0x01, // ’ą (U+2019 U+0105)
  0x20, 0x19, 0x01, 0x07, 0x01, // ’ć (U+2019 U+0107)
  0x20, 0x19, 0x01, 0x09, 0x01, // ’ĉ (U+2019 U+0109)
  0x20, 0x19, 0x01, 0x0B, 0x01, // ’ċ (U+2019 U+010B)
  0x20, 0x19, 0x01, 0x0D, 0x01, // ’č (U+2019 U+010D)
  0x20, 0x19, 0x01, 0x0F, 0x01, // ’ď (U+2019 U+010F)
  0x20, 0x19, 0x01, 0x11, 0x01, // ’đ (U+2019 U+0111)
  0x20, 0x19, 0x01, 0x13, 0x01, // ’ē (U+2019 U+0113)
  0x20, 0x19, 0x01, 0x15, 0x01, // ’ĕ (U+2019 U+0115)
  0x20, 0x19, 0x01, 0x17, 0x01, // ’ė (U+2019 U+0117)
  0x20, 0x19, 0x01, 0x19, 0x01, // ’ę (U+2019 U+0119)
  0x20, 0x19, 0x01, 0x1B, 0x01, // ’ě (U+2019 U+011B)
  0x20, 0x19, 0x01, 0x1D, 0x01, // ’ĝ (U+2019 U+011D)
  0x20, 0x19, 0x01, 0x1F, 0x01, // ’ğ (U+2019 U+011F)
  0x20, 0x19, 0x01, 0x21, 0x01, // ’ġ (U+2019 U+0121)
  0x20, 0x19, 0x01, 0x23, 0x01, // ’ģ (U+2019 U+0123)
  0x20, 0x19, 0x01, 0x38, 0x01, // ’ĸ (U+2019 U+0138)
  0x20, 0x19, 0x01, 0x44, 0x01, // ’ń (U+2019 U+0144)
  0x20, 0x19, 0x01, 0x46, 0x01, // ’ņ (U+2019 U+0146)
  0x20, 0x19, 0x01, 0x48, 0x01, // ’ň (U+2019 U+0148)
  0x20, 0x19, 0x01, 0x4B, 0x01, // ’ŋ (U+2019 U+014B)
  0x20, 0x19, 0x01, 0x4D, 0x01, // ’ō (U+2019 U+014D)
  0x20, 0x19, 0x01, 0x4F, 0x01, // ’ŏ (U+2019 U+014F)
  0x20, 0x19, 0x01, 0x51, 0x01, // ’ő (U+2019 U+0151)
  0x20, 0x19, 0x01, 0x53, 0x01, // ’œ (U+2019 U+0153)
  0x20, 0x19, 0x01, 0x55, 0x01, // ’ŕ (U+2019 U+0155)
  0x20, 0x19, 0x01, 0x57, 0x01, // ’ŗ (U+2019 U+0157)
  0x20, 0x19, 0x01, 0x5B, 0x01, // ’ś (U+2019 U+015B)
  0x20, 0x19, 0x01, 0x5D, 0x01, // ’ŝ (U+2019 U+015D)
  0x20, 0x19, 0x01, 0x5F, 0x01, // ’ş (U+2019 U+015F)
  0x20, 0x19, 0x01, 0x61, 0x01, // ’š (U+2019 U+0161)
  0x20, 0x19, 0x01, 0x69, 0x01, // ’ũ (U+2019 U+0169)
  0x20, 0x19, 0x01, 0x6B, 0x01, // ’ū (U+2019 U+016B)
  0x20, 0x19, 0x01, 0x6D, 0x01, // ’ŭ (U+2019 U+016D)
  0x20, 0x19, 0x01, 0x6F, 0x01, // ’ů (U+2019 U+016F)
  0x20, 0x19, 0x01, 0x71, 0x01, // ’ű (U+2019 U+0171)
  0x20, 0x19, 0x01, 0x73, 0x01, // ’ų (U+2019 U+0173)
  0x20, 0x1A, 0x00, 0x43, 0x01, // ‚C (U+201A U+0043)
  0x20, 0x1A, 0x00, 0x47, 0x01, // ‚G (U+201A U+0047)
  0x20, 0x1A, 0x00, 0x4F, 0x01, // ‚O (U+201A U+004F)
  0x20, 0x1A, 0x00, 0x51, 0x01, // ‚Q (U+201A U+0051)
  0x20, 0x1A, 0x00, 0x54, 0x01, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x56, 0x01, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x01, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x01, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0xC7, 0x01, // ‚Ç (U+201A U+00C7)
  0x20, 0x1A, 0x00, 0xD2, 0x01, // ‚Ò (U+201A U+00D2)
  0x20, 0x1A, 0x00, 0xD3, 0x01, // ‚Ó (U+201A U+00D3)
  0x20, 0x1A, 0x00, 0xD4, 0x01, // ‚Ô (U+201A U+00D4)
  0x20, 0x1A, 0x00, 0xD5, 0x01, // ‚Õ (U+201A U+00D5)
  0x20, 0x1A, 0x00, 0xD6, 0x01, // ‚Ö (U+201A U+00D6)
  0x20, 0x1A, 0x00, 0xD8, 0x01, // ‚Ø (U+201A U+00D8)
  0x20, 0x1A, 0x00, 0xDD, 0x01, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x01, 0x06, 0x01, // ‚Ć (U+201A U+0106)
  0x20, 0x1A, 0x01, 0x08, 0x01, // ‚Ĉ (U+201A U+0108)
  0x20, 0x1A, 0x01, 0x0A, 0x01, // ‚Ċ (U+201A U+010A)
  0x20, 0x1A, 0x01, 0x0C, 0x01, // ‚Č (U+201A U+010C)
  0x20, 0x1A, 0x01, 0x1C, 0x01, // ‚Ĝ (U+201A U+011C)
  0x20, 0x1A, 0x01, 0x1E, 0x01, // ‚Ğ (U+201A U+011E)
  0x20, 0x1A, 0x01, 0x20, 0x01, // ‚Ġ (U+201A U+0120)
  0x20, 0x1A, 0x01, 0x22, 0x01, // ‚Ģ (U+201A U+0122)
  0x20, 0x1A, 0x01, 0x4C, 0x01, // ‚Ō (U+201A U+014C)
  0x20, 0x1A, 0x01, 0x4E, 0x01, // ‚Ŏ (U+201A U+014E)
  0x20, 0x1A, 0x01, 0x50, 0x01, // ‚Ő (U+201A U+0150)
  0x20, 0x1A, 0x01, 0x52, 0x01, // ‚Œ (U+201A U+0152)
  0x20, 0x1A, 0x01, 0x62, 0x01, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x01, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x01, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1A, 0x01, 0x74, 0x01, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x76, 0x01, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x78, 0x01, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x01, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0x61, 0x01, // “a (U+201C U+0061)
  0x20, 0x1C, 0x00, 0x63, 0x01, // “c (U+201C U+0063)
  0x20, 0x1C, 0x00, 0x64, 0x01, // “d (U+201C U+0064)
  0x20, 0x1C, 0x00, 0x65, 0x01, // “e (U+201C U+0065)
  0x20, 0x1C, 0x00, 0x67, 0x01, // “g (U+201C U+0067)
  0x20, 0x1C, 0x00, 0x6D, 0x01, // “m (U+201C U+006D)
  0x20, 0x1C, 0x00, 0x6E, 0x01, // “n (U+201C U+006E)
  0x20, 0x1C, 0x00, 0x6F, 0x01, // “o (U+201C U+006F)
  0x20, 0x1C, 0x00, 0x70, 0x01, // “p (U+201C U+0070)
  0x20, 0x1C, 0x00, 0x71, 0x01, // “q (U+201C U+0071)
  0x20, 0x1C, 0x00, 0x72, 0x01, // “r (U+201C U+0072)
  0x20, 0x1C, 0x00, 0x73, 0x01, // “s (U+201C U+0073)
  0x20, 0x1C, 0x00, 0x75, 0x01, // “u (U+201C U+0075)
  0x20, 0x1C, 0x00, 0xC0, 0x01, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x01, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x01, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x01, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x01, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x01, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xE0, 0x01, // “à (U+201C U+00E0)
  0x20, 0x1C, 0x00, 0xE1, 0x01, // “á (U+201C U+00E1)
  0x20, 0x1C, 0x00, 0xE2, 0x01, // “â (U+201C U+00E2)
  0x20, 0x1C, 0x00, 0xE3, 0x01, // “ã (U+201C U+00E3)
  0x20, 0x1C, 0x00, 0xE4, 0x01, // “ä (U+201C U+00E4)
  0x20, 0x1C, 0x00, 0xE5, 0x01, // “å (U+201C U+00E5)
  0x20, 0x1C, 0x00, 0xE6, 0x01, // “æ (U+201C U+00E6)
  0x20, 0x1C, 0x00, 0xE7, 0x01, // “ç (U+201C U+00E7)
  0x20, 0x1C, 0x00, 0xE8, 0x01, // “è (U+201C U+00E8)
  0x20, 0x1C, 0x00, 0xE9, 0x01, // “é (U+201C U+00E9)
  0x20, 0x1C, 0x00, 0xEA, 0x01, // “ê (U+201C U+00EA)
  0x20, 0x1C, 0x00, 0xEB, 0x01, // “ë (U+201C U+00EB)
  0x20, 0x1C, 0x00, 0xF1, 0x01, // “ñ (U+201C U+00F1)
  0x20, 0x1C, 0x00, 0xF2, 0x01, // “ò (U+201C U+00F2)
  0x20, 0x1C, 0x00, 0xF3, 0x01, // “ó (U+201C U+00F3)
  0x20, 0x1C, 0x00, 0xF4, 0x01, // “ô (U+201C U+00F4)
  0x20, 0x1C, 0x00, 0xF5, 0x01, // “õ (U+201C U+00F5)
  0x20, 0x1C, 0x00, 0xF6, 0x01, // “ö (U+201C U+00F6)
  0x20, 0x1C, 0x00, 0xF8, 0x01, // “ø (U+201C U+00F8)
  0x20, 0x1C, 0x00, 0xF9, 0x01, // “ù (U+201C U+00F9)
  0x20, 0x1C, 0x00, 0xFA, 0x01, // “ú (U+201C U+00FA)
  0x20, 0x1C, 0x00, 0xFB, 0x01, // “û (U+201C U+00FB)
  0x20, 0x1C, 0x00, 0xFC, 0x01, // “ü (U+201C U+00FC)
  0x20, 0x1C, 0x01, 0x00, 0x01, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x01, 0x01, // “ā (U+201C U+0101)
  0x20, 0x1C, 0x01, 0x02, 0x01, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x03, 0x01, // “ă (U+201C U+0103)
  0x20, 0x1C, 0x01, 0x04, 0x01, // “Ą (U+201C U+0104)
  0x20, 0x1C, 0x01, 0x05, 0x01, // “ą (U+201C U+0105)
  0x20, 0x1C, 0x01, 0x07, 0x01, // “ć (U+201C U+0107)
  0x20, 0x1C, 0x01, 0x09, 0x01, // “ĉ (U+201C U+0109)
  0x20, 0x1C, 0x01, 0x0B, 0x01, // “ċ (U+201C U+010B)
  0x20, 0x1C, 0x01, 0x0D, 0x01, // “č (U+201C U+010D)
  0x20, 0x1C, 0x01, 0x0F, 0x01, // “ď (U+201C U+010F)
  0x20, 0x1C, 0x01, 0x11, 0x01, // “đ (U+201C U+0111)
  0x20, 0x1C, 0x01, 0x13, 0x01, // “ē (U+201C U+0113)
  0x20, 0x1C, 0x01, 0x15, 0x01, // “ĕ (U+201C U+0115)
  0x20, 0x1C, 0x01, 0x17, 0x01, // “ė (U+201C U+0117)
  0x20, 0x1C, 0x01, 0x19, 0x01, // “ę (U+201C U+0119)
  0x20, 0x1C, 0x01, 0x1B, 0x01, // “ě (U+201C U+011B)
  0x20, 0x1C, 0x01, 0x1D, 0x01, // “ĝ (U+201C U+011D)
  0x20, 0x1C, 0x01, 0x1F, 0x01, // “ğ (U+201C U+011F)
  0x20, 0x1C, 0x01, 0x21, 0x01, // “ġ (U+201C U+0121)
  0x20, 0x1C, 0x01, 0x23, 0x01, // “ģ (U+201C U+0123)
  0x20, 0x1C, 0x01, 0x38, 0x01, // “ĸ (U+201C U+0138)
  0x20, 0x1C, 0x01, 0x44, 0x01, // “ń (U+201C U+0144)
  0x20, 0x1C, 0x01, 0x46, 0x01, // “ņ (U+201C U+0146)
  0x20, 0x1C, 0x01, 0x48, 0x01, // “ň (U+201C U+0148)
  0x20, 0x1C, 0x01, 0x4B, 0x01, // “ŋ (U+201C U+014B)
  0x20, 0x1C, 0x01, 0x4D, 0x01, // “ō (U+201C U+014D)
  0x20, 0x1C, 0x01, 0x4F, 0x01, // “ŏ (U+201C U+014F)
  0x20, 0x1C, 0x01, 0x51, 0x01, // “ő (U+201C U+0151)
  0x20, 0x1C, 0x01, 0x53, 0x01, // “œ (U+201C U+0153)
  0x20, 0x1C, 0x01, 0x55, 0x01, // “ŕ (U+201C U+0155)
  0x20, 0x1C, 0x01, 0x57, 0x01, // “ŗ (U+201C U+0157)
  0x20, 0x1C, 0x01, 0x5B, 0x01, // “ś (U+201C U+015B)
  0x20, 0x1C, 0x01, 0x5D, 0x01, // “ŝ (U+201C U+015D)
  0x20, 0x1C, 0x01, 0x5F, 0x01, // “ş (U+201C U+015F)
  0x20, 0x1C, 0x01, 0x61, 0x01, // “š (U+201C U+0161)
  0x20, 0x1C, 0x01, 0x69, 0x01, // “ũ (U+201C U+0169)
  0x20, 0x1C, 0x01, 0x6B, 0x01, // “ū (U+201C U+016B)
  0x20, 0x1C, 0x01, 0x6D, 0x01, // “ŭ (U+201C U+016D)
  0x20, 0x1C, 0x01, 0x6F, 0x01, // “ů (U+201C U+016F)
  0x20, 0x1C, 0x01, 0x71, 0x01, // “ű (U+201C U+0171)
  0x20, 0x1C, 0x01, 0x73, 0x01, // “ų (U+201C U+0173)
  0x20, 0x1D, 0x00, 0x41, 0x01, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0x61, 0x01, // ”a (U+201D U+0061)
  0x20, 0x1D, 0x00, 0x63, 0x01, // ”c (U+201D U+0063)
  0x20, 0x1D, 0x00, 0x64, 0x01, // ”d (U+201D U+0064)
  0x20, 0x1D, 0x00, 0x65, 0x01, // ”e (U+201D U+0065)
  0x20, 0x1D, 0x00, 0x67, 0x01, // ”g (U+201D U+0067)
  0x20, 0x1D, 0x00, 0x6D, 0x01, // ”m (U+201D U+006D)
  0x20, 0x1D, 0x00, 0x6E, 0x01, // ”n (U+201D U+006E)
  0x20, 0x1D, 0x00, 0x6F, 0x01, // ”o (U+201D U+006F)
  0x20, 0x1D, 0x00, 0x70, 0x01, // ”p (U+201D U+0070)
  0x20, 0x1D, 0x00, 0x71, 0x01, // ”q (U+201D U+0071)
  0x20, 0x1D, 0x00, 0x72, 0x01, // ”r (U+201D U+0072)
  0x20, 0x1D, 0x00, 0x73, 0x01, // ”s (U+201D U+0073)
  0x20, 0x1D, 0x00, 0x75, 0x01, // ”u (U+201D U+0075)
  0x20, 0x1D, 0x00, 0xC0, 0x01, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x01, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x01, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x01, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x01, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x01, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xE0, 0x01, // ”à (U+201D U+00E0)
  0x20, 0x1D, 0x00, 0xE1, 0x01, // ”á (U+201D U+00E1)
  0x20, 0x1D, 0x00, 0xE2, 0x01, // ”â (U+201D U+00E2)
  0x20, 0x1D, 0x00, 0xE3, 0x01, // ”ã (U+201D U+00E3)
  0x20, 0x1D, 0x00, 0xE4, 0x01, // ”ä (U+201D U+00E4)
  0x20, 0x1D, 0x00, 0xE5, 0x01, // ”å (U+201D U+00E5)
  0x20, 0x1D, 0x00, 0xE6, 0x01, // ”æ (U+201D U+00E6)
  0x20, 0x1D, 0x00, 0xE7, 0x01, // ”ç (U+201D U+00E7)
  0x20, 0x1D, 0x00, 0xE8, 0x01, // ”è (U+201D U+00E8)
  0x20, 0x1D, 0x00, 0xE9, 0x01, // ”é (U+201D U+00E9)
  0x20, 0x1D, 0x00, 0xEA, 0x01, // ”ê (U+201D U+00EA)
  0x20, 0x1D, 0x00, 0xEB, 0x01, // ”ë (U+201D U+00EB)
  0x20, 0x1D, 0x00, 0xF1, 0x01, // ”ñ (U+201D U+00F1)
  0x20, 0x1D, 0x00, 0xF2, 0x01, // ”ò (U+201D U+00F2)
  0x20, 0x1D, 0x00, 0xF3, 0x01, // ”ó (U+201D U+00F3)
  0x20, 0x1D, 0x00, 0xF4, 0x01, // ”ô (U+201D U+00F4)
  0x20, 0x1D, 0x00, 0xF5, 0x01, // ”õ (U+201D U+00F5)
  0x20, 0x1D, 0x00, 0xF6, 0x01, // ”ö (U+201D U+00F6)
  0x20, 0x1D, 0x00, 0xF8, 0x01, // ”ø (U+201D U+00F8)
  0x20, 0x1D, 0x00, 0xF9, 0x01, // ”ù (U+201D U+00F9)
  0x20, 0x1D, 0x00, 0xFA, 0x01, // ”ú (U+201D U+00FA)
  0x20, 0x1D, 0x00, 0xFB, 0x01, // ”û (U+201D U+00FB)
  0x20, 0x1D, 0x00, 0xFC, 0x01, // ”ü (U+201D U+00FC)
  0x20, 0x1D, 0x01, 0x00, 0x01, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x01, 0x01, // ”ā (U+201D U+0101)
  0x20, 0x1D, 0x01, 0x02, 0x01, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x03, 0x01, // ”ă (U+201D U+0103)
  0x20, 0x1D, 0x01, 0x04, 0x01, // ”Ą (U+201D U+0104)
  0x20, 0x1D, 0x01, 0x05, 0x01, // ”ą (U+201D U+0105)
  0x20, 0x1D, 0x01, 0x07, 0x01, // ”ć (U+201D U+0107)
  0x20, 0x1D, 0x01, 0x09, 0x01, // ”ĉ (U+201D U+0109)
  0x20, 0x1D, 0x01, 0x0B, 0x01, // ”ċ (U+201D U+010B)
  0x20, 0x1D, 0x01, 0x0D, 0x01, // ”č (U+201D U+010D)
  0x20, 0x1D, 0x01, 0x0F, 0x01, // ”ď (U+201D U+010F)
  0x20, 0x1D, 0x01, 0x11, 0x01, // ”đ (U+201D U+0111)
  0x20, 0x1D, 0x01, 0x13, 0x01, // ”ē (U+201D U+0113)
  0x20, 0x1D, 0x01, 0x15, 0x01, // ”ĕ (U+201D U+0115)
  0x20, 0x1D, 0x01, 0x17, 0x01, // ”ė (U+201D U+0117)
  0x20, 0x1D, 0x01, 0x19, 0x01, // ”ę (U+201D U+0119)
  0x20, 0x1D, 0x01, 0x1B, 0x01, // ”ě (U+201D U+011B)
  0x20, 0x1D, 0x01, 0x1D, 0x01, // ”ĝ (U+201D U+011D)
  0x20, 0x1D, 0x01, 0x1F, 0x01, // ”ğ (U+201D U+011F)
  0x20, 0x1D, 0x01, 0x21, 0x01, // ”ġ (U+201D U+0121)
  0x20, 0x1D, 0x01, 0x23, 0x01, // ”ģ (U+201D U+0123)
  0x20, 0x1D, 0x01, 0x38, 0x01, // ”ĸ (U+201D U+0138)
  0x20, 0x1D, 0x01, 0x44, 0x01, // ”ń (U+201D U+0144)
  0x20, 0x1D, 0x01, 0x46, 0x01, // ”ņ (U+201D U+0146)
  0x20, 0x1D, 0x01, 0x48, 0x01, // ”ň (U+201D U+0148)
  0x20, 0x1D, 0x01, 0x4B, 0x01, // ”ŋ (U+201D U+014B)
  0x20, 0x1D, 0x01, 0x4D, 0x01, // ”ō (U+201D U+014D)
  0x20, 0x1D, 0x01, 0x4F, 0x01, // ”ŏ (U+201D U+014F)
  0x20, 0x1D, 0x01, 0x51, 0x01, // ”ő (U+201D U+0151)
  0x20, 0x1D, 0x01, 0x53, 0x01, // ”œ (U+201D U+0153)
  0x20, 0x1D, 0x01, 0x55, 0x01, // ”ŕ (U+201D U+0155)
  0x20, 0x1D, 0x01, 0x57, 0x01, // ”ŗ (U+201D U+0157)
  0x20, 0x1D, 0x01, 0x5B, 0x01, // ”ś (U+201D U+015B)
  0x20, 0x1D, 0x01, 0x5D, 0x01, // ”ŝ (U+201D U+015D)
  0x20, 0x1D, 0x01, 0x5F, 0x01, // ”ş (U+201D U+015F)
  0x20, 0x1D, 0x01, 0x61, 0x01, // ”š (U+201D U+0161)
  0x20, 0x1D, 0x01, 0x69, 0x01, // ”ũ (U+201D U+0169)
  0x20, 0x1D, 0x01, 0x6B, 0x01, // ”ū (U+201D U+016B)
  0x20, 0x1D, 0x01, 0x6D, 0x01, // ”ŭ (U+201D U+016D)
  0x20, 0x1D, 0x01, 0x6F, 0x01, // ”ů (U+201D U+016F)
  0x20, 0x1D, 0x01, 0x71, 0x01, // ”ű (U+201D U+0171)
  0x20, 0x1D, 0x01, 0x73, 0x01, // ”ų (U+201D U+0173)
  0x20, 0x1E, 0x00, 0x43, 0x01, // „C (U+201E U+0043)
  0x20, 0x1E, 0x00, 0x47, 0x01, // „G (U+201E U+0047)
  0x20, 0x1E, 0x00, 0x4F, 0x01, // „O (U+201E U+004F)
  0x20, 0x1E, 0x00, 0x51, 0x01, // „Q (U+201E U+0051)
  0x20, 0x1E, 0x00, 0x54, 0x01, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x56, 0x01, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x01, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x01, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0xC7, 0x01, // „Ç (U+201E U+00C7)
  0x20, 0x1E, 0x00, 0xD2, 0x01, // „Ò (U+201E U+00D2)
  0x20, 0x1E, 0x00, 0xD3, 0x01, // „Ó (U+201E U+00D3)
  0x20, 0x1E, 0x00, 0xD4, 0x01, // „Ô (U+201E U+00D4)
  0x20, 0x1E, 0x00, 0xD5, 0x01, // „Õ (U+201E U+00D5)
  0x20, 0x1E, 0x00, 0xD6, 0x01, // „Ö (U+201E U+00D6)
  0x20, 0x1E, 0x00, 0xD8, 0x01, // „Ø (U+201E U+00D8)
  0x20, 0x1E, 0x00, 0xDD, 0x01, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x01, 0x06, 0x01, // „Ć (U+201E U+0106)
  0x20, 0x1E, 0x01, 0x08, 0x01, // „Ĉ (U+201E U+0108)
  0x20, 0x1E, 0x01, 0x0A, 0x01, // „Ċ (U+201E U+010A)
  0x20, 0x1E, 0x01, 0x0C, 0x01, // „Č (U+201E U+010C)
  0x20, 0x1E, 0x01, 0x1C, 0x01, // „Ĝ (U+201E U+011C)
  0x20, 0x1E, 0x01, 0x1E, 0x01, // „Ğ (U+201E U+011E)
  0x20, 0x1E, 0x01, 0x20, 0x01, // „Ġ (U+201E U+0120)
  0x20, 0x1E, 0x01, 0x22, 0x01, // „Ģ (U+201E U+0122)
  0x20, 0x1E, 0x01, 0x4C, 0x01, // „Ō (U+201E U+014C)
  0x20, 0x1E, 0x01, 0x4E, 0x01, // „Ŏ (U+201E U+014E)
  0x20, 0x1E, 0x01, 0x50, 0x01, // „Ő (U+201E U+0150)
  0x20, 0x1E, 0x01, 0x52, 0x01, // „Œ (U+201E U+0152)
  0x20, 0x1E, 0x01, 0x62, 0x01, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x01, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x01, // „Ŧ (U+201E U+0166)
  0x20, 0x1E, 0x01, 0x74, 0x01, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x76, 0x01, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x78, 0x01, // „Ÿ (U+201E U+0178)
  0x20, 0x39, 0x00, 0x59, 0x01, // ‹Y (U+2039 U+0059)
  0x20, 0x39, 0x00, 0xDD, 0x01, // ‹Ý (U+2039 U+00DD)
  0x20, 0x39, 0x01, 0x76, 0x01, // ‹Ŷ (U+2039 U+0176)
  0x20, 0x39, 0x01, 0x78, 0x01, // ‹Ÿ (U+2039 U+0178)
  0x20, 0x3A, 0x00, 0x54, 0x01, // ›T (U+203A U+0054)
  0x20, 0x3A, 0x00, 0x56, 0x01, // ›V (U+203A U+0056)
  0x20, 0x3A, 0x00, 0x57, 0x01, // ›W (U+203A U+0057)
  0x20, 0x3A, 0x00, 0x59, 0x01, // ›Y (U+203A U+0059)
  0x20, 0x3A, 0x00, 0xDD, 0x01, // ›Ý (U+203A U+00DD)
  0x20, 0x3A, 0x01, 0x62, 0x01, // ›Ţ (U+203A U+0162)
  0x20, 0x3A, 0x01, 0x64, 0x01, // ›Ť (U+203A U+0164)
  0x20, 0x3A, 0x01, 0x66, 0x01, // ›Ŧ (U+203A U+0166)
  0x20, 0x3A, 0x01, 0x74, 0x01, // ›Ŵ (U+203A U+0174)
  0x20, 0x3A, 0x01, 0x76, 0x01, // ›Ŷ (U+203A U+0176)
  0x20, 0x3A, 0x01, 0x78, 0x01, // ›Ÿ (U+203A U+0178)
  0x20, 0x44, 0x00, 0x30, 0x03, // ⁄0 (U+2044 U+0030)
  0x20, 0x44, 0x00, 0x31, 0x03, // ⁄1 (U+2044 U+0031)
  0x20, 0x44, 0x00, 0x32, 0x03, // ⁄2 (U+2044 U+0032)
  0x20, 0x44, 0x00, 0x33, 0x03, // ⁄3 (U+2044 U+0033)
  0x20, 0x44, 0x00, 0x34, 0x03, // ⁄4 (U+2044 U+0034)
  0x20, 0x44, 0x00, 0x35, 0x03, // ⁄5 (U+2044 U+0035)
  0x20, 0x44, 0x00, 0x36, 0x03, // ⁄6 (U+2044 U+0036)
  0x20, 0x44, 0x00, 0x37, 0x03, // ⁄7 (U+2044 U+0037)
  0x20, 0x44, 0x00, 0x38, 0x03, // ⁄8 (U+2044 U+0038)
  0x20, 0x44, 0x00, 0x39, 0x03, // ⁄9 (U+2044 U+0039)
  
  // Glyph data
  // "!" (U+0021)
  0x28, 0x12, 0xF8, 0x28, 0x15, 0xF4, 0x20, 0x89, 0x30, 0xB0, 0xC3, 0x0E, 0x08, 0x28, 0x11, 0xF4,
  0x20, 0x49, 0x30, 0x70, 0xC3, 0x0A, 0x08, 0x30, 0x30, 0x23, 0x01, 0x38, 0x18, 0xF2, 0x20, 0x90,
  0xC3,
  // """ (U+0022)
  0x18, 0xB2, 0x8F, 0x0A, 0xD0, 0xAB, 0x0D, 0x90, 0xC7, 0x0F, 0x50, 0xE3, 0x2F, 0x11, 0xF0, 0x4C,
  0x10,
  // "#" (U+0023)
  0x48, 0x3A, 0x70, 0x98, 0x58, 0x3E, 0x30, 0xD3, 0x48, 0x33, 0xE0, 0x2E, 0x58, 0x37, 0xA0, 0x6A,
  0x30, 0x8F, 0x89, 0x01, 0x01, 0x4F, 0x33, 0xF3, 0x23, 0x83, 0x6B, 0x05, 0xB5, 0x83, 0xB6, 0x0B,
  0x63, 0x0B, 0xE0, 0xE2, 0x86, 0x27, 0xC3, 0x7D, 0x32, 0x38, 0x3A, 0x70, 0x98, 0x58, 0x3E, 0x20,
  0xE3, 0x48, 0x34, 0xD0, 0x3D, 0x50,
  // "$" (U+0024)
  0x50, 0xD5, 0x82, 0x15, 0xE4, 0x38, 0x44, 0xEE, 0xEF, 0xC2, 0x89, 0x2E, 0x77, 0x61, 0x30, 0x3F,
  0x1A, 0x33, 0x82, 0x3F, 0x6D, 0x58, 0x1C, 0xFC, 0x68, 0x1B, 0xF9, 0x58, 0x27, 0xAF, 0x64, 0x82,
  0xA2, 0xBA, 0x48, 0x94, 0xC0, 0xB9, 0x07, 0x42, 0xC7, 0xE2, 0x09, 0xA8, 0x1E, 0xA2, 0x38, 0x11,
  0x94, 0x60, 0x90, 0x14,
  // "%" (U+0025)
  0x18, 0x22, 0xCE, 0x43, 0x0E, 0x03, 0x28, 0x2D, 0x89, 0xB2, 0x08, 0x0A, 0x28, 0x74, 0xD0, 0x5C,
  0x02, 0xE1, 0x28, 0x69, 0x80, 0x7A, 0x0B, 0x73, 0x85, 0xC5, 0x0A, 0x74, 0xD4, 0x8C, 0x5E, 0x30,
  0xE3, 0xD5, 0x8E, 0xA0, 0xD5, 0x7C, 0x7B, 0x5D, 0x3E, 0x38, 0xFE, 0x4E, 0x3D, 0x50, 0xD4, 0x02,
  0x09, 0x92, 0x92, 0x90, 0x32, 0x85, 0x3E, 0x15, 0xC0, 0x39, 0x38, 0x6C, 0x60, 0x6B, 0x08, 0xA2,
  0x05, 0x0D, 0x28, 0x35, 0xD5, 0xE3, 0x20, 0xD0, 0x42, 0x82, 0x1C, 0xE5, 0x20,
  // "&" (U+0026)
  0x38, 0x24, 0xDE, 0xA4, 0x84, 0x1E, 0x96, 0xF4, 0x30, 0x69, 0x29, 0x05, 0x38, 0x47, 0xD0, 0x4F,
  0x23, 0x83, 0x6F, 0x2D, 0x84, 0x82, 0x2F, 0xEA, 0x58, 0x18, 0xFE, 0x58, 0xA1, 0xAD, 0x6F, 0x40,
  0xE7, 0x6F, 0x20, 0xCB, 0x5F, 0x1B, 0xA2, 0x85, 0x5F, 0xE7, 0x0D, 0x92, 0x81, 0x1F, 0xD2, 0x89,
  0x7A, 0xE5, 0x5D, 0xDF, 0x30, 0x1B, 0xED, 0x70, 0xEA, 0x10,
  // "'" (U+0027)
  0x89, 0x47, 0xF1, 0x9C, 0x0B, 0x80, 0xE4, 0x0F, 0x11,
  // "(" (U+0028)
  0x40, 0x90, 0xA3, 0x81, 0x6E, 0x12, 0x81, 0x2E, 0x53, 0x09, 0x0C, 0x38, 0x12, 0xF5, 0x30, 0x80,
  0xD4, 0x0D, 0x08, 0x38, 0x12, 0xF4, 0x38, 0x15, 0xF1, 0x30, 0x70, 0xE4, 0x08, 0x0D, 0x40, 0x70,
  0xD4, 0x06, 0x0E, 0x40, 0x49, 0x48, 0x11, 0xF4, 0x40, 0xB0, 0x83,
  // ")" (U+0029)
  0x40, 0xC0, 0x55, 0x08, 0x0A, 0x50, 0x59, 0x58, 0x14, 0xF2, 0x48, 0x13, 0xF3, 0x48, 0x13, 0xF3,
  0x48, 0x14, 0xF2, 0x40, 0x69, 0x50, 0x90, 0xC5, 0x0D, 0x09, 0x48, 0x13, 0xF3, 0x40, 0x90, 0xC4,
  0x81, 0x2F, 0x54, 0x09, 0x0C, 0x48, 0x14, 0xE2, 0x38, 0x11, 0xD5, 0x40,
  // "*" (U+002A)
  0x20, 0x30, 0xA2, 0x82, 0x10, 0x5D, 0x28, 0x6E, 0x98, 0x91, 0x33, 0x8C, 0x18, 0x19, 0xCC, 0x28,
  0x91, 0x8E, 0x1D, 0x60, 0x23, 0x08, 0x81,
  // "+" (U+002B)
  0x38, 0x12, 0xF1, 0x68, 0x12, 0xF1, 0x68, 0x12, 0xF1, 0x68, 0x12, 0xF2, 0x30, 0x1F, 0x87, 0x10,
  0x33, 0x5F, 0x43, 0x34, 0x81, 0x2F, 0x16, 0x81, 0x2F, 0x16, 0x81, 0x2F, 0x13,
  // "," (U+002C)
  0x18, 0x97, 0x17, 0x30, 0x7F, 0x10, 0xCA, 0x02, 0xF2, 0x09, 0x92,
  // "-" (U+002D)
  0x07, 0xB0, 0x60, 0x20, 0xF3, 0x10,
  // "." (U+002E)
  0x18, 0x51, 0x08, 0xF2, 0x9D, 0x10,
  // "/" (U+002F)
  0x68, 0x12, 0xF4, 0x60, 0xA0, 0xB6, 0x81, 0x3F, 0x36, 0x0B, 0x0A, 0x68, 0x14, 0xF2, 0x60, 0xC0,
  0x96, 0x81, 0x5E, 0x16, 0x0D, 0x07, 0x60, 0x60, 0xE7, 0x0E, 0x06, 0x60, 0x80, 0xD6, 0x81, 0x1E,
  0x56, 0x09, 0x0C, 0x70,
  // "0" (U+0030)
  0x38, 0x23, 0xCE, 0xA3, 0x84, 0x2F, 0x95, 0xE7, 0x20, 0x0B, 0x28, 0x4B, 0xB0, 0x3F, 0x42, 0x83,
  0xAC, 0x08, 0xE3, 0x83, 0xBB, 0x0D, 0xA3, 0x83, 0xD9, 0x1F, 0x63, 0x98, 0x26, 0x3F, 0x32, 0x84,
  0x3F, 0x35, 0xF1, 0x28, 0x27, 0xE0, 0x69, 0x38, 0x97, 0xD9, 0x05, 0xF1, 0x05, 0xF2, 0x01, 0xF9,
  0x5E, 0x83, 0x82, 0x6E, 0xE7, 0x30,
  // "1" (U+0031)
  0x28, 0xA0, 0x2D, 0xB0, 0x4E, 0xF8, 0x7F, 0x8F, 0x56, 0x45, 0xF1, 0x20, 0x80, 0xE3, 0x0B, 0x0A,
  0x30, 0xE0, 0x72, 0x81, 0x2F, 0x42, 0x81, 0x6F, 0x12, 0x09, 0x0D, 0x30, 0xC0, 0xA3, 0x90, 0x62,
  0x81, 0x3F, 0x32,
  // "2" (U+0032)
  0x38, 0x32, 0xAE, 0xE9, 0x48, 0x4B, 0xB4, 0x7F, 0x83, 0x01, 0x30, 0xC0, 0xB7, 0x0C, 0x0A, 0x68,
  0x11, 0xF6, 0x60, 0xA0, 0xE6, 0x81, 0x6F, 0x45, 0x81, 0x4F, 0x75, 0x81, 0x2E, 0x95, 0x81, 0x2E,
  0xA5, 0x81, 0x1D, 0xB6, 0x81, 0xCE, 0x40, 0xF3, 0x20, 0x4E, 0x20,
  // "3" (U+0033)
  0x38, 0x43, 0xBE, 0xEA, 0x13, 0x84, 0x98, 0x46, 0xF9, 0x70, 0x0B, 0x70, 0xE0, 0x75, 0x81, 0x3B,
  0xB4, 0x08, 0xA0, 0x65, 0x83, 0x24, 0xBE, 0x26, 0x81, 0x1F, 0x87, 0x0D, 0x09, 0x79, 0x08, 0x68,
  0x91, 0x6F, 0x30, 0x1C, 0x64, 0x7F, 0xA3, 0x83, 0xAE, 0xFD, 0x73,
  // "4" (U+0034)
  0x58, 0x12, 0xEB, 0x58, 0x1C, 0xF8, 0x48, 0x27, 0xBF, 0x53, 0x83, 0x3E, 0x6F, 0x13, 0x82, 0xC6,
  0x7E, 0x38, 0x38, 0xB0, 0xBB, 0x28, 0x43, 0xE1, 0x0E, 0x72, 0x89, 0x4D, 0x60, 0x2F, 0x40, 0x9B,
  0x11, 0x6F, 0x21, 0xF8, 0x64, 0x33, 0x33, 0xDB, 0x35, 0x90, 0x65, 0x81, 0x3F, 0x32,
  // "5" (U+0035)
  0x20, 0x1C, 0x0C, 0x28, 0x45, 0xE3, 0x33, 0x22, 0x00, 0xA6, 0x0E, 0x06, 0x58, 0x13, 0xF2, 0x58,
  0x37, 0xFE, 0xEA, 0x38, 0x43, 0x64, 0x8F, 0x96, 0x0B, 0x0D, 0x60, 0x90, 0xE6, 0x0B, 0x0C, 0x58,
  0x90, 0x3F, 0x60, 0xB6, 0x47, 0xEC, 0x28, 0x39, 0xEF, 0xD8, 0x30,
  // "6" (U+0036)
  0x48, 0x35, 0xCE, 0xE1, 0x38, 0x38, 0xE7, 0x45, 0x38, 0x15, 0xF3, 0x60, 0xE0, 0x86, 0x81, 0x5F,
  0x16, 0x84, 0xAB, 0x8E, 0xE5, 0x38, 0x4E, 0xE8, 0x4C, 0xE2, 0x81, 0x2F, 0x92, 0x85, 0x5F, 0x20,
  0x4F, 0x32, 0x85, 0x5F, 0x10, 0x5F, 0x12, 0x08, 0x0E, 0x28, 0x13, 0xF3, 0x20, 0xD0, 0x93, 0x84,
  0xEB, 0x4B, 0xE2, 0x38, 0x34, 0xDE, 0xB3, 0x30,
  // "7" (U+0037)
  0x01, 0xE8, 0x76, 0x03, 0x33, 0x39, 0xF2, 0x50, 0xD0, 0x95, 0x81, 0x6F, 0x25, 0x0D, 0x09, 0x58,
  0x16, 0xF2, 0x50, 0xD0, 0x95, 0x81, 0x6F, 0x25, 0x0D, 0x09, 0x58, 0x16, 0xF2, 0x50, 0xD0, 0x95,
  0x81, 0x6F, 0x25, 0x0D, 0x09, 0x60,
  // "8" (U+0038)
  0x38, 0x37, 0xDE, 0xB2, 0x28, 0x47, 0xE6, 0x5D, 0xC2, 0x0E, 0x08, 0x20, 0x79, 0x29, 0x06, 0x20,
  0x90, 0xD2, 0x84, 0xDA, 0x02, 0xE5, 0x28, 0x35, 0xF9, 0xE6, 0x38, 0x26, 0xEF, 0x93, 0x89, 0x0A,
  0xD3, 0x5F, 0x50, 0x6E, 0x22, 0x83, 0xBB, 0x0B, 0xB3, 0x83, 0x9D, 0x0C, 0xB3, 0x89, 0x0C, 0xB0,
  0x7F, 0x74, 0xAF, 0x32, 0x83, 0x8D, 0xEC, 0x42,
  // "9" (U+0039)
  0x38, 0x28, 0xEE, 0x83, 0x89, 0x09, 0xE5, 0x7F, 0x50, 0x2F, 0x52, 0x83, 0xD9, 0x08, 0xD3, 0x83,
  0xBA, 0x0B, 0xA3, 0x83, 0xD9, 0x0C, 0xA2, 0x8A, 0x13, 0xF8, 0x0A, 0xE2, 0x2D, 0xF5, 0x03, 0xEF,
  0xE7, 0xF1, 0x38, 0x22, 0x09, 0xC5, 0x81, 0x1E, 0x55, 0x0A, 0x0C, 0x28, 0x45, 0x45, 0xBD, 0x22,
  0x83, 0xAF, 0xE9, 0x13,
  // ":" (U+003A)
  0x18, 0x51, 0xD8, 0x03, 0xF7, 0x20, 0x17, 0x74, 0x01, 0x28, 0x4A, 0xF1, 0x0A, 0xB2,
  // ";" (U+003B)
  0x30, 0xC0, 0x92, 0x81, 0x2F, 0x83, 0x01, 0x77, 0x71, 0x81, 0x14, 0x12, 0x81, 0x7F, 0x12, 0x0C,
  0x0A, 0x28, 0x13, 0xF2, 0x20, 0x09, 0x30, 0x14,
  // "<" (U+003C)
  0x70, 0x46, 0x82, 0x3B, 0xF1, 0x38, 0x32, 0xAF, 0x92, 0x28, 0x32, 0xAF, 0x92, 0x38, 0x21, 0xFD,
  0x26, 0x82, 0x6D, 0xD6, 0x78, 0x26, 0xDE, 0x77, 0x81, 0x6D, 0xE7, 0x10, 0x61,
  // "=" (U+003D)
  0x01, 0xF1, 0x80, 0x33, 0x77, 0x20, 0x1F, 0x18, 0x03, 0x30,
  // ">" (U+003E)
  0x01, 0x03, 0x78, 0x21, 0xFB, 0x36, 0x83, 0x2A, 0xFA, 0x26, 0x83, 0x2A, 0xF9, 0x26, 0x82, 0x3E,
  0xF1, 0x48, 0x26, 0xDD, 0x53, 0x82, 0x7E, 0xD6, 0x38, 0x21, 0xED, 0x65, 0x01, 0x06, 0x70,
  // "?" (U+003F)
  0x18, 0x31, 0x9D, 0xEA, 0x28, 0x43, 0xA5, 0x6F, 0x75, 0x0E, 0x09, 0x48, 0x11, 0xF6, 0x40, 0x90,
  0xD4, 0x81, 0x7E, 0x33, 0x81, 0x5E, 0x34, 0x0E, 0x05, 0x40, 0x50, 0xD5, 0x02, 0x03, 0x50, 0x15,
  0x81, 0x3F, 0x84, 0x81, 0x4E, 0x44,
  // "@" (U+0040)
  0x58, 0x37, 0xDF, 0xE9, 0x58, 0x63, 0xDC, 0x64, 0x6D, 0xB3, 0x81, 0x2E, 0x74, 0x81, 0x1E, 0x42,
  0x89, 0xA4, 0xB8, 0x04, 0xDE, 0xB0, 0x98, 0x04, 0xD0, 0x3E, 0x69, 0xC0, 0x7A, 0x0B, 0x70, 0xB7,
  0x09, 0x80, 0x79, 0x0F, 0x22, 0xF1, 0x0D, 0x50, 0x97, 0x3E, 0x06, 0xB0, 0x1F, 0x10, 0xD3, 0x5C,
  0x08, 0x90, 0x6D, 0x03, 0xE0, 0x6B, 0x08, 0xB2, 0xCE, 0x1C, 0x70, 0x5D, 0x03, 0xA8, 0x24, 0xCF,
  0xA2, 0x84, 0x1F, 0x40, 0x11, 0x20, 0x24, 0x85, 0x9E, 0x51, 0x12, 0x36, 0x09, 0xB0, 0xE0, 0x67,
  0x10, 0x02, 0x60,
  // "A" (U+0041)
  0x58, 0x17, 0xF8, 0x58, 0x1E, 0xF9, 0x48, 0x26, 0xEB, 0x94, 0x82, 0xD9, 0xAA, 0x38, 0x34, 0xF3,
  0xAA, 0x38, 0x3B, 0xC0, 0xAB, 0x28, 0x43, 0xF6, 0x09, 0xC2, 0x86, 0xAF, 0x21, 0xAC, 0x01, 0xD8,
  0x92, 0xD0, 0x8F, 0x54, 0x4B, 0xD0, 0xEB, 0x38, 0x38, 0xE7, 0xF3, 0x38, 0x28, 0xFD, 0xB4, 0x07,
  0x90,
  // "B" (U+0042)
  0x20, 0x2B, 0x0D, 0x07, 0x38, 0x55, 0xF4, 0x49, 0xF5, 0x20, 0x90, 0xE3, 0x0E, 0x09, 0x20, 0xC0,
  0xB3, 0x0E, 0x09, 0x29, 0x08, 0x28, 0x91, 0x3F, 0x50, 0x3F, 0x50, 0x3D, 0xB2, 0x06, 0xC0, 0x93,
  0x85, 0x9E, 0x33, 0x9F, 0x32, 0x0D, 0x0B, 0x30, 0xE0, 0xA2, 0x90, 0x73, 0x84, 0xEA, 0x04, 0xF4,
  0x28, 0x91, 0x3F, 0x60, 0x7F, 0x44, 0x7E, 0xC2, 0x0A, 0xB0, 0xD0, 0x83,
  // "C" (U+0043)
  0x48, 0x35, 0xCE, 0xEA, 0x38, 0x48, 0xF9, 0x46, 0x92, 0x81, 0x4F, 0x66, 0x0D, 0x0B, 0x68, 0x15,
  0xF4, 0x60, 0xA0, 0xE7, 0x0E, 0x0A, 0x79, 0x07, 0x68, 0x11, 0xF6, 0x68, 0x11, 0xF7, 0x70, 0xE0,
  0xB7, 0x84, 0x7F, 0x94, 0x65, 0x48, 0x38, 0xEF, 0xD6, 0x20,
  // "D" (U+0044)
  0x20, 0x2B, 0x0D, 0x06, 0x48, 0x55, 0xF4, 0x4A, 0xF6, 0x30, 0x90, 0xD3, 0x0C, 0x0D, 0x30, 0xC0,
  0xA3, 0x08, 0x93, 0x90, 0x73, 0x85, 0x7F, 0x10, 0x3F, 0x43, 0x08, 0x92, 0x81, 0x6F, 0x13, 0x0A,
  0x0D, 0x20, 0x90, 0xD4, 0x0E, 0x0A, 0x20, 0xD0, 0xA3, 0x81, 0x4F, 0x52, 0x90, 0x63, 0x0B, 0x0D,
  0x28, 0x14, 0xF3, 0x28, 0x17, 0xF3, 0x28, 0x57, 0xF4, 0x5A, 0xF7, 0x30, 0xAA, 0x81, 0xEA, 0x34,
  // "E" (U+0045)
  0x20, 0x2D, 0x28, 0x15, 0xF4, 0x0F, 0x32, 0x09, 0x0E, 0x60, 0xC0, 0xB6, 0x90, 0x85, 0x81, 0x3F,
  0x65, 0x06, 0xC0, 0x92, 0x84, 0x9E, 0x33, 0x31, 0x20, 0xD0, 0xA6, 0x90, 0x75, 0x81, 0x4F, 0x45,
  0x84, 0x7F, 0x43, 0x32, 0x20, 0xAC, 0x08, 0x20,
  // "F" (U+0046)
  0x20, 0x2D, 0x01, 0x28, 0x15, 0xF4, 0x0F, 0x33, 0x09, 0x0D, 0x70, 0xC0, 0xA7, 0x90, 0x76, 0x81,
  0x3F, 0x46, 0x06, 0xC0, 0x83, 0x84, 0x9D, 0x33, 0x31, 0x30, 0xD0, 0x97, 0x90, 0x66, 0x81, 0x4F,
  0x36, 0x07, 0x97, 0x0A, 0x0C, 0x70,
  // "G" (U+0047)
  0x48, 0x44, 0xBE, 0xEC, 0x73, 0x85, 0x7F, 0xA5, 0x59, 0x92, 0x81, 0x5F, 0x77, 0x0D, 0x0B, 0x78,
  0x16, 0xF4, 0x70, 0xB0, 0xD7, 0x10, 0xE0, 0x92, 0x05, 0xB1, 0x81, 0x1F, 0x72, 0x86, 0x13, 0xBC,
  0x02, 0xF6, 0x40, 0xD0, 0x92, 0x90, 0x73, 0x81, 0x1F, 0x62, 0x0D, 0x0B, 0x38, 0x14, 0xF2, 0x28,
  0x56, 0xFA, 0x44, 0xAE, 0x48, 0x46, 0xDF, 0xEC, 0x62,
  // "H" (U+0048)
  0x28, 0x12, 0xF5, 0x30, 0x80, 0xE2, 0x81, 0x5F, 0x23, 0x00, 0xB2, 0x08, 0x0E, 0x40, 0xE0, 0x82,
  0x0C, 0x0B, 0x38, 0x11, 0xF5, 0x29, 0x08, 0x38, 0x92, 0x4F, 0x10, 0x3F, 0x61, 0x11, 0x8E, 0x20,
  0x6E, 0x0A, 0x28, 0x69, 0xE4, 0x44, 0x4F, 0x72, 0x0C, 0x0B, 0x38, 0x12, 0xF4, 0x29, 0x07, 0x38,
  0x55, 0xF1, 0x03, 0xF4, 0x30, 0x90, 0xD2, 0x07, 0x94, 0x0C, 0x09, 0x20, 0xA0, 0xC4, 0x90, 0x62,
  // "I" (U+0049)
  0x20, 0x1B, 0x0E, 0x01, 0x38, 0x11, 0xF8, 0x58, 0x12, 0xF5, 0x58, 0x15, 0xF1, 0x50, 0x80, 0xE6,
  0x0C, 0x0A, 0x69, 0x07, 0x58, 0x13, 0xF4, 0x58, 0x16, 0xF1, 0x50, 0x90, 0xD6, 0x0D, 0x0A, 0x58,
  0x11, 0xF7, 0x40, 0x9B, 0x08, 0x30,
  // "J" (U+004A)
  0x58, 0x12, 0xF5, 0x58, 0x15, 0xF2, 0x50, 0x90, 0xE6, 0x0C, 0x0A, 0x69, 0x07, 0x58, 0x13, 0xF4,
  0x58, 0x16, 0xF1, 0x50, 0x90, 0xD6, 0x0D, 0x09, 0x69, 0x06, 0x58, 0x14, 0xF3, 0x50, 0x79, 0x60,
  0xA0, 0xC6, 0x0E, 0x08, 0x38, 0x31, 0x18, 0xF2, 0x30, 0x9A, 0x06, 0x40, 0x10, 0x36,
  // "K" (U+004B)
  0x28, 0x12, 0xF4, 0x28, 0x16, 0xF4, 0x28, 0x55, 0xF1, 0x03, 0xF7, 0x38, 0x49, 0xE0, 0x1D, 0xB4,
  0x84, 0xCA, 0x0B, 0xD1, 0x49, 0x82, 0x77, 0xF3, 0x48, 0x33, 0xF8, 0xF7, 0x58, 0x36, 0xFE, 0xF4,
  0x58, 0x39, 0xF6, 0xE8, 0x58, 0x3D, 0xA0, 0xBC, 0x59, 0x83, 0x60, 0x7F, 0x13, 0x85, 0x4F, 0x30,
  0x3F, 0x53, 0x07, 0x93, 0x0E, 0x0A, 0x30, 0xA0, 0xC3, 0x0A, 0x0E, 0x30,
  // "L" (U+004C)
  0x28, 0x12, 0xF4, 0x38, 0x15, 0xF1, 0x30, 0x90, 0xD4, 0x0C, 0x0A, 0x49, 0x07, 0x38, 0x13, 0xF4,
  0x38, 0x16, 0xF1, 0x30, 0x90, 0xD4, 0x0D, 0x09, 0x49, 0x06, 0x38, 0x14, 0xF3, 0x38, 0x57, 0xF5,
  0x55, 0x3A, 0xC0, 0x70,
  // "M" (U+004D)
  0x20, 0x2A, 0x58, 0x17, 0xFD, 0x20, 0x5A, 0x01, 0x48, 0x1E, 0xFA, 0x28, 0x29, 0xEF, 0x23, 0x82,
  0x6E, 0xF7, 0x28, 0x2C, 0xAF, 0x33, 0x82, 0xDA, 0xF4, 0x29, 0x81, 0x7F, 0x42, 0x89, 0x16, 0xE7,
  0xF1, 0x03, 0xF3, 0xF5, 0x28, 0x2D, 0x89, 0xD2, 0x89, 0x16, 0xF0, 0xE6, 0x05, 0xF1, 0xC9, 0x28,
  0x91, 0x9C, 0x0D, 0x70, 0xC9, 0x0F, 0x62, 0x89, 0x1D, 0x80, 0xC8, 0x4F, 0x13, 0xF3, 0x29, 0x86,
  0x50, 0xB9, 0xB9, 0x07, 0x92, 0x89, 0x14, 0xF2, 0x0A, 0xDF, 0x20, 0xAC, 0x20, 0x70, 0xE2, 0x81,
  0x9F, 0xA2, 0x0D, 0x09, 0x20, 0xA0, 0xB2, 0x85, 0x8F, 0x20, 0x1F, 0x52,
  // "N" (U+004E)
  0x28, 0x12, 0xFB, 0x40, 0xE0, 0x72, 0x81, 0x5F, 0xE3, 0x81, 0x2F, 0x42, 0x82, 0x9E, 0xF3, 0x28,
  0x15, 0xF1, 0x28, 0x2C, 0x9E, 0x62, 0x08, 0x0D, 0x39, 0x81, 0x6B, 0xA2, 0x0C, 0x0A, 0x28, 0x33,
  0xF3, 0x8D, 0x29, 0x06, 0x28, 0x76, 0xF0, 0x4F, 0x13, 0xF3, 0x28, 0x59, 0xC0, 0x1F, 0x56, 0x93,
  0x0D, 0x09, 0x28, 0x2D, 0x89, 0xC3, 0x90, 0x52, 0x82, 0x9B, 0xB9, 0x28, 0x14, 0xF2, 0x28, 0x25,
  0xFE, 0x62, 0x07, 0x0E, 0x30, 0x2A, 0x02, 0x20, 0xA0, 0xB4, 0x00, 0xE3,
  // "O" (U+004F)
  0x48, 0x36, 0xDF, 0xD5, 0x48, 0x5A, 0xE7, 0x4B, 0xF2, 0x28, 0x16, 0xF4, 0x30, 0xE0, 0x92, 0x0D,
  0x0A, 0x48, 0x4C, 0xB0, 0x5F, 0x34, 0x83, 0xCB, 0x0A, 0xE5, 0x83, 0xDA, 0x0E, 0xA5, 0x98, 0x28,
  0x0F, 0x84, 0x84, 0x4F, 0x42, 0xF6, 0x48, 0x49, 0xE0, 0x1F, 0x64, 0x0E, 0x08, 0x20, 0xE0, 0xA3,
  0x81, 0x9E, 0x12, 0x85, 0x8F, 0x74, 0x9F, 0x54, 0x83, 0x9E, 0xEB, 0x33,
  // "P" (U+0050)
  0x20, 0x2A, 0x81, 0xEB, 0x33, 0x84, 0x5F, 0x45, 0xDE, 0x30, 0x90, 0xE2, 0x81, 0x4F, 0x42, 0x0C,
  0x0B, 0x28, 0x13, 0xF5, 0x29, 0x08, 0x28, 0x55, 0xF3, 0x03, 0xF5, 0x20, 0xB0, 0xE2, 0x85, 0x6F,
  0x22, 0x9F, 0x52, 0x09, 0xB0, 0xD0, 0x53, 0x82, 0xDB, 0x31, 0x59, 0x07, 0x68, 0x14, 0xF3, 0x60,
  0x79, 0x70, 0xA0, 0xC7,
  // "Q" (U+0051)
  0x48, 0x36, 0xDF, 0xD5, 0x48, 0x5A, 0xE7, 0x4B, 0xF2, 0x28, 0x15, 0xF4, 0x30, 0xE0, 0x92, 0x0D,
  0x0A, 0x48, 0x4C, 0xB0, 0x5F, 0x34, 0x83, 0xCB, 0x0A, 0xE5, 0x83, 0xDA, 0x0E, 0xA5, 0x98, 0x28,
  0x0F, 0x84, 0x84, 0x4F, 0x51, 0xF6, 0x48, 0x49, 0xF1, 0x1F, 0x64, 0x0E, 0x0A, 0x20, 0xE0, 0xA3,
  0x81, 0x9F, 0x22, 0x85, 0x9F, 0x74, 0x9F, 0x64, 0x83, 0x9E, 0xFE, 0x57, 0x81, 0x7F, 0x27, 0x81,
  0x1F, 0x97, 0x18, 0x1B, 0xE1, 0x20,
  // "R" (U+0052)
  0x20, 0x2A, 0x81, 0xEC, 0x43, 0x85, 0x5F, 0x45, 0xCE, 0x12, 0x09, 0x0D, 0x28, 0x13, 0xF5, 0x20,
  0xC0, 0xA2, 0x81, 0x3F, 0x42, 0x90, 0x62, 0x89, 0x18, 0xF1, 0x03, 0xF3, 0x16, 0xF8, 0x20, 0x6B,
  0x0E, 0x07, 0x38, 0x39, 0xC3, 0xCB, 0x48, 0x3D, 0x90, 0x8E, 0x49, 0x83, 0x60, 0x5F, 0x32, 0x85,
  0x4F, 0x30, 0x2F, 0x62, 0x07, 0x93, 0x0E, 0x0A, 0x20, 0xA0, 0xC3, 0x0A, 0x0E, 0x20,
  // "S" (U+0053)
  0x48, 0x38, 0xDF, 0xD7, 0x38, 0x4C, 0xE6, 0x48, 0x72, 0x81, 0x4F, 0x46, 0x81, 0x6F, 0x26, 0x81,
  0x5F, 0x67, 0x81, 0xDF, 0x46, 0x82, 0x2E, 0xF5, 0x68, 0x22, 0xDE, 0x16, 0x81, 0x5F, 0x66, 0x81,
  0x2F, 0x66, 0x89, 0x16, 0xF3, 0x01, 0xB6, 0x47, 0xEB, 0x28, 0x41, 0xBE, 0xFD, 0x83,
  // "T" (U+0054)
  0x05, 0xE8, 0x65, 0x13, 0x4F, 0x93, 0x33, 0x81, 0x2F, 0x45, 0x81, 0x5F, 0x15, 0x09, 0x0E, 0x60,
  0xC0, 0xA6, 0x90, 0x75, 0x81, 0x3F, 0x45, 0x81, 0x6F, 0x15, 0x09, 0x0D, 0x60, 0xC0, 0xA6, 0x90,
  0x75, 0x81, 0x3F, 0x45,
  // "U" (U+0055)
  0x28, 0x14, 0xF3, 0x30, 0x90, 0xD2, 0x07, 0x94, 0x0C, 0x0A, 0x20, 0xA0, 0xC4, 0x90, 0x62, 0x0E,
  0x08, 0x38, 0x53, 0xF3, 0x01, 0xF5, 0x30, 0x79, 0x28, 0x15, 0xF2, 0x30, 0xA0, 0xC2, 0x08, 0x0E,
  0x40, 0xD0, 0x92, 0x00, 0xB3, 0x81, 0x1F, 0x52, 0x0E, 0x08, 0x38, 0x55, 0xF2, 0x01, 0xF5, 0x30,
  0x90, 0xD2, 0x81, 0x1F, 0x62, 0x81, 0x1E, 0x83, 0x85, 0xCE, 0x67, 0xDD, 0x13, 0x84, 0x2B, 0xEE,
  0xA1, 0x30,
  // "V" (U+0056)
  0x81, 0x6F, 0x13, 0x84, 0x3F, 0x55, 0xF1, 0x38, 0x4A, 0xD0, 0x5F, 0x22, 0x85, 0x1F, 0x70, 0x4F,
  0x22, 0x08, 0x0E, 0x28, 0x14, 0xF3, 0x20, 0xE0, 0x82, 0x85, 0x3F, 0x30, 0x6F, 0x12, 0x84, 0x2F,
  0x30, 0xDA, 0x38, 0x42, 0xF4, 0x4F, 0x33, 0x83, 0x1F, 0x4B, 0xB4, 0x83, 0x1F, 0x6F, 0x45, 0x90,
  0xB0, 0xD6, 0xA0, 0x66, 0x90, 0xE6,
  // "W" (U+0057)
  0x81, 0x5F, 0x13, 0x0D, 0x0A, 0x38, 0x46, 0xF1, 0x5F, 0x12, 0x81, 0x4F, 0xA3, 0x84, 0xCA, 0x05,
  0xF1, 0x28, 0x1B, 0xFA, 0x28, 0x92, 0x3F, 0x40, 0x5F, 0x10, 0x2F, 0xBA, 0x20, 0x90, 0xD2, 0x86,
  0x5F, 0x10, 0x8B, 0x9A, 0x20, 0xE0, 0x72, 0x89, 0x25, 0xF1, 0x0E, 0x59, 0x90, 0x6F, 0x12, 0x89,
  0x15, 0xF0, 0x5E, 0x09, 0x90, 0xCA, 0x38, 0x91, 0x5F, 0x0B, 0x80, 0x99, 0x3F, 0x33, 0x89, 0x05,
  0xF2, 0xF2, 0x09, 0x99, 0xD4, 0x82, 0x5F, 0x8B, 0x28, 0x29, 0x9E, 0x64, 0x82, 0x5E, 0xD5, 0x28,
  0x1A, 0xDE, 0x58, 0x15, 0xFE, 0x38, 0x1A, 0xF9, 0x58, 0x15, 0xF8, 0x38, 0x1A, 0xF3, 0x50,
  // "X" (U+0058)
  0x30, 0xE0, 0x82, 0x81, 0x1E, 0x83, 0x00, 0xB2, 0x09, 0x0D, 0x48, 0x48, 0xE0, 0x3F, 0x54, 0x83,
  0x4F, 0x2C, 0xB5, 0x83, 0x1F, 0xAF, 0x26, 0x81, 0xDF, 0x77, 0x0D, 0x97, 0x08, 0xA0, 0x25, 0x83,
  0x3F, 0x5F, 0x55, 0x83, 0xCB, 0x0D, 0x94, 0x84, 0x7F, 0x20, 0xBC, 0x38, 0x11, 0xE7, 0x20, 0x89,
  0x30, 0xB0, 0xD3, 0x81, 0x5F, 0x32,
  // "Y" (U+0059)
  0x81, 0x5F, 0x22, 0x84, 0x1E, 0x83, 0xF4, 0x28, 0x90, 0x9E, 0x01, 0xF6, 0x02, 0xF6, 0x28, 0x3E,
  0x80, 0xAC, 0x38, 0x3B, 0xA3, 0xF4, 0x38, 0x29, 0xCB, 0xA4, 0x07, 0xA0, 0x24, 0x81, 0x5F, 0x85,
  0x81, 0x5F, 0x25, 0x08, 0x0E, 0x60, 0x0B, 0x60, 0xE0, 0x85, 0x81, 0x2F, 0x55,
  // "Z" (U+005A)
  0x30, 0xDD, 0x30, 0xF3, 0x81, 0x5F, 0xA6, 0x81, 0xAE, 0x15, 0x81, 0x4F, 0x66, 0x0D, 0x0C, 0x68,
  0x17, 0xF3, 0x58, 0x11, 0xE9, 0x68, 0x1A, 0xE1, 0x58, 0x14, 0xF6, 0x60, 0xD0, 0xC6, 0x81, 0x8F,
  0x25, 0x81, 0x2F, 0xB8, 0x00, 0x32, 0x07, 0xD0, 0x92,
  // "[" (U+005B)
  0x30, 0x1B, 0x04, 0x38, 0x25, 0xF4, 0x34, 0x08, 0x0C, 0x60, 0xB0, 0x96, 0x0E, 0x06, 0x58, 0x12,
  0xF2, 0x50, 0x50, 0xE6, 0x09, 0x0B, 0x60, 0xC0, 0x86, 0x90, 0x55, 0x81, 0x3F, 0x25, 0x06, 0x0E,
  0x60, 0x90, 0xB6, 0x0C, 0x08, 0x69, 0x05, 0x50, 0x3B, 0x02, 0x30, 0x10, 0xF3, 0x40,
  // "\" (U+005C)
  0x81, 0x1F, 0x32, 0x0E, 0x05, 0x20, 0xC0, 0x72, 0x00, 0xA2, 0x08, 0x0C, 0x20, 0x60, 0xE2, 0x04,
  0x92, 0x81, 0x2F, 0x22, 0x90, 0x42, 0x0E, 0x06, 0x20, 0xC0, 0x82, 0x00, 0xA2, 0x08, 0x0C,
  // "]" (U+005D)
  0x40, 0xEA, 0x07, 0x48, 0x23, 0x5F, 0x35, 0x05, 0x96, 0x08, 0x0C, 0x60, 0xB0, 0x96, 0x0E, 0x06,
  0x58, 0x12, 0xF3, 0x50, 0x59, 0x60, 0x80, 0xC6, 0x0C, 0x08, 0x60, 0xE0, 0x55, 0x81, 0x2F, 0x25,
  0x06, 0x0E, 0x60, 0x90, 0xB6, 0x0C, 0x08, 0x30, 0x1B, 0x05, 0x40, 0xF3, 0x40,
  // "^" (U+005E)
  0x40, 0x50, 0x35, 0x81, 0x2F, 0xA5, 0x81, 0xAD, 0xE4, 0x83, 0x3F, 0x2E, 0x53, 0x83, 0xB8, 0x0A,
  0xA2, 0x84, 0x4E, 0x10, 0x4E, 0x20, 0xC0, 0x83, 0x83, 0xE5, 0x6E, 0x13, 0x09, 0x0A,
  // "_" (U+005F)
  0x07, 0xD0, 0x70, 0x18, 0x01, 0x30, 0x10,
  // "`" (U+0060)
  0x81, 0x3E, 0x52, 0x0B, 0x0A, 0x28, 0x12, 0xE1,
  // "a" (U+0061)
  0x28, 0x51, 0xAE, 0xC2, 0xF2, 0x28, 0x4B, 0xD5, 0x8D, 0xE2, 0x81, 0x5F, 0x32, 0x0E, 0x0B, 0x20,
  0xC0, 0xB3, 0x98, 0x38, 0x01, 0xF6, 0x28, 0x51, 0xF5, 0x04, 0xF3, 0x28, 0x55, 0xF2, 0x05, 0xF1,
  0x20, 0xA0, 0xE2, 0x85, 0x6F, 0x10, 0x3F, 0xB2, 0x85, 0x3F, 0x85, 0xCD, 0x73, 0x84, 0x8E, 0xC2,
  0xD4, 0x20,
  // "b" (U+0062)
  0x28, 0x11, 0xF5, 0x58, 0x14, 0xF2, 0x50, 0x70, 0xE6, 0x0A, 0x0C, 0x68, 0xA0, 0xD8, 0x8E, 0xC1,
  0x01, 0xFC, 0x85, 0xE9, 0x04, 0xF9, 0x28, 0x4A, 0xC0, 0x7F, 0x12, 0x83, 0xBC, 0x0B, 0xB3, 0x83,
  0xCA, 0x0E, 0x72, 0x84, 0x1F, 0x72, 0xF5, 0x28, 0x45, 0xF3, 0x5F, 0x52, 0x89, 0x7C, 0xB0, 0x8D,
  0xC4, 0xAF, 0x30, 0xB6, 0x8E, 0xD4, 0x20,
  // "c" (U+0063)
  0x38, 0x29, 0xEE, 0x82, 0x87, 0xBD, 0x55, 0x40, 0x6F, 0x24, 0x0D, 0x0A, 0x48, 0x12, 0xF5, 0x48,
  0x14, 0xF2, 0x48, 0x16, 0xF1, 0x48, 0x15, 0xF2, 0x48, 0x41, 0xFB, 0x47, 0x22, 0x83, 0x5D, 0xEC,
  0x21,
  // "d" (U+0064)
  0x70, 0x69, 0x70, 0x90, 0xC7, 0x0C, 0x09, 0x79, 0x05, 0x28, 0x51, 0xAE, 0xC4, 0xF2, 0x28, 0x4C,
  0xD5, 0x7D, 0xE2, 0x81, 0x5F, 0x32, 0x0E, 0x0B, 0x20, 0xC0, 0xB3, 0x84, 0xE8, 0x01, 0xF6, 0x28,
  0x51, 0xF5, 0x04, 0xF3, 0x28, 0x55, 0xF2, 0x05, 0xF1, 0x20, 0xB0, 0xE2, 0x85, 0x6F, 0x10, 0x3F,
  0xB2, 0x85, 0x3F, 0x95, 0xCE, 0x73, 0x84, 0x8E, 0xC2, 0xE4, 0x20,
  // "e" (U+0065)
  0x38, 0x29, 0xEE, 0x62, 0x8A, 0x2B, 0xC5, 0x9F, 0x06, 0xE1, 0x06, 0xF0, 0xD8, 0x26, 0xE9, 0x2B,
  0x85, 0xE8, 0x05, 0xF4, 0x23, 0x06, 0x95, 0x81, 0x5F, 0x24, 0x84, 0x1E, 0xB4, 0x58, 0x28, 0x34,
  0xDF, 0xD6, 0x10,
  // "f" (U+0066)
  0x68, 0x23, 0xCF, 0x86, 0x82, 0xDB, 0x42, 0x58, 0x13, 0xF2, 0x70, 0x80, 0xE7, 0x0A, 0x0E, 0xA0,
  0x35, 0x82, 0x3F, 0x93, 0x68, 0x12, 0xF4, 0x78, 0x15, 0xF1, 0x70, 0x90, 0xD7, 0x10, 0xC0, 0xA7,
  0x19, 0x06, 0x78, 0x13, 0xF3, 0x70, 0x69, 0x71, 0x0A, 0x0C, 0x71, 0x0D, 0x08, 0x78, 0x12, 0xF4,
  0x68, 0x14, 0xAE, 0x68, 0x22, 0xFD, 0x46,
  // "g" (U+0067)
  0x38, 0x51, 0xAE, 0xC3, 0xF2, 0x38, 0x4B, 0xE5, 0x8D, 0xE3, 0x81, 0x5F, 0x42, 0x0E, 0x0B, 0x30,
  0xC0, 0xB3, 0x90, 0x82, 0x81, 0x1F, 0x62, 0x81, 0x2F, 0x42, 0x81, 0x4F, 0x32, 0x81, 0x5F, 0x12,
  0x81, 0x5F, 0x12, 0x0B, 0x0D, 0x38, 0x56, 0xF1, 0x04, 0xFA, 0x38, 0x53, 0xF9, 0x5C, 0xF7, 0x48,
  0x48, 0xEC, 0x5F, 0x47, 0x06, 0x97, 0x10, 0xC0, 0xB3, 0x85, 0x19, 0x54, 0xAF, 0x33, 0x84, 0x1A,
  0xEE, 0xB3, 0x40,
  // "h" (U+0068)
  0x28, 0x11, 0xF6, 0x58, 0x14, 0xF2, 0x50, 0x70, 0xE6, 0x0A, 0x0B, 0x68, 0xA0, 0xD8, 0x9E, 0xC2,
  0x01, 0xFD, 0x75, 0xF8, 0x04, 0xF7, 0x28, 0x4D, 0x90, 0x7F, 0x12, 0x98, 0x27, 0x0B, 0xB2, 0x84,
  0x3F, 0x40, 0xE8, 0x28, 0x46, 0xF0, 0x2F, 0x52, 0x84, 0x9D, 0x05, 0xF1, 0x28, 0x3C, 0x90, 0x8E,
  0x39, 0x82, 0x60, 0xBB, 0x28, 0x13, 0xF3, 0x10,
  // "i" (U+0069)
  0x28, 0x12, 0xE3, 0x28, 0x14, 0xE2, 0x75, 0x0D, 0x08, 0x28, 0x11, 0xF5, 0x28, 0x14, 0xF1, 0x20,
  0x80, 0xE3, 0x00, 0xB3, 0x0E, 0x07, 0x28, 0x12, 0xF4, 0x28, 0x15, 0xF1, 0x20, 0x80, 0xD3, 0x0B,
  0x0A, 0x30,
  // "j" (U+006A)
  0x58, 0x12, 0xE3, 0x58, 0x14, 0xE2, 0x77, 0x70, 0xE0, 0x85, 0x81, 0x1F, 0x55, 0x81, 0x5F, 0x15,
  0x08, 0x0D, 0x60, 0xB0, 0xA6, 0x0E, 0x07, 0x58, 0x12, 0xF4, 0x50, 0x59, 0x60, 0x90, 0xD6, 0x0C,
  0x09, 0x69, 0x06, 0x58, 0x14, 0xF2, 0x38, 0x21, 0x4C, 0xC4, 0x82, 0x4E, 0xC3, 0x40,
  // "k" (U+006B)
  0x39, 0x06, 0x58, 0x13, 0xF2, 0x50, 0x70, 0xE6, 0x0A, 0x0B, 0x68, 0x93, 0xD8, 0x02, 0xE8, 0x01,
  0xF5, 0x0C, 0xB2, 0x84, 0x4F, 0x29, 0xD1, 0x28, 0x37, 0xD6, 0xF3, 0x38, 0x2B, 0xDF, 0xB4, 0x81,
  0xEE, 0xB9, 0x38, 0x42, 0xF5, 0x3F, 0x42, 0x84, 0x5F, 0x10, 0xF7, 0x20, 0x80, 0xD2, 0x00, 0xB2,
  0x0B, 0x0A, 0x20, 0x79, 0x20,
  // "l" (U+006C)
  0x39, 0x06, 0x28, 0x13, 0xF2, 0x20, 0x70, 0xE3, 0x0A, 0x0B, 0x30, 0xD0, 0x82, 0x81, 0x1F, 0x52,
  0x81, 0x4F, 0x22, 0x07, 0x0E, 0x30, 0x0B, 0x30, 0xE0, 0x82, 0x81, 0x2F, 0x42, 0x81, 0x5F, 0x12,
  0x08, 0x0D, 0x30, 0xB0, 0xA3,
  // "m" (U+006D)
  0x28, 0xB0, 0xD5, 0x9E, 0xC1, 0x6E, 0xD3, 0x01, 0xFB, 0x66, 0xFC, 0xA4, 0xDB, 0x04, 0xF7, 0x29,
  0x0C, 0x28, 0x90, 0xBB, 0x08, 0xF1, 0x02, 0xF5, 0x28, 0x3D, 0x90, 0xBB, 0x28, 0x15, 0xF1, 0x29,
  0x82, 0x60, 0xE8, 0x20, 0x80, 0xD2, 0x84, 0x4F, 0x32, 0xF5, 0x20, 0xB0, 0xA2, 0x84, 0x7F, 0x05,
  0xF1, 0x20, 0xE0, 0x72, 0x83, 0xAC, 0x08, 0xE2, 0x81, 0x2F, 0x42, 0x83, 0xD8, 0x0B, 0xB2, 0x05,
  0x92, 0x81, 0x1F, 0x51,
  // "n" (U+006E)
  0x28, 0xA0, 0xE5, 0x9E, 0xC2, 0x02, 0xFD, 0x85, 0xF9, 0x05, 0xF8, 0x28, 0x4D, 0x90, 0x8F, 0x12,
  0x98, 0x27, 0x0B, 0xC2, 0x84, 0x3F, 0x40, 0xE8, 0x28, 0x46, 0xF1, 0x2F, 0x52, 0x84, 0x9D, 0x05,
  0xF1, 0x28, 0x3D, 0xA0, 0x9E, 0x39, 0x82, 0x60, 0xCB, 0x28, 0x13, 0xF3, 0x10,
  // "o" (U+006F)
  0x28, 0x31, 0x9E, 0xD6, 0x38, 0x90, 0xCD, 0x58, 0xF3, 0x05, 0xF2, 0x28, 0x3E, 0x70, 0xCA, 0x38,
  0x3E, 0x81, 0xF5, 0x39, 0x82, 0x74, 0xF2, 0x28, 0x43, 0xF4, 0x6F, 0x12, 0x84, 0x7F, 0x05, 0xF1,
  0x28, 0x90, 0xE9, 0x01, 0xFA, 0x4B, 0xE1, 0x28, 0x34, 0xDE, 0xB2, 0x20,
  // "p" (U+0070)
  0x38, 0x4E, 0x58, 0xEC, 0x22, 0x85, 0x1F, 0xB8, 0x5E, 0x92, 0x81, 0x5F, 0x92, 0x0A, 0x0C, 0x28,
  0x18, 0xF2, 0x20, 0xA0, 0xC2, 0x00, 0xB3, 0x0C, 0x0A, 0x20, 0xE0, 0x83, 0x98, 0x37, 0x02, 0xF6,
  0x28, 0x55, 0xF3, 0x05, 0xF5, 0x20, 0xC0, 0xB2, 0x85, 0x8E, 0xC4, 0xAF, 0x32, 0x84, 0xC9, 0x7E,
  0xD4, 0x39, 0x07, 0x68, 0x13, 0xF3, 0x60, 0x69, 0x70, 0x90, 0xC7,
  // "q" (U+0071)
  0x28, 0x51, 0xAE, 0xC3, 0xF2, 0x28, 0x4B, 0xD5, 0x8E, 0xE2, 0x81, 0x5F, 0x32, 0x0E, 0x0B, 0x20,
  0xC0, 0xB3, 0x98, 0x38, 0x01, 0xF6, 0x28, 0x51, 0xF4, 0x04, 0xF3, 0x28, 0x55, 0xF1, 0x05, 0xF1,
  0x20, 0xB0, 0xD2, 0x85, 0x6F, 0x10, 0x4F, 0xA2, 0x85, 0x3F, 0x95, 0xCF, 0x73, 0x84, 0x8E, 0xC5,
  0xF4, 0x60, 0x69, 0x70, 0x90, 0xD7, 0x0C, 0x09, 0x79, 0x06, 0x30,
  // "r" (U+0072)
  0x28, 0x91, 0xD4, 0xAF, 0x30, 0x1F, 0xC7, 0x52, 0x81, 0x4F, 0x84, 0x81, 0x8F, 0x14, 0x00, 0xB5,
  0x0E, 0x07, 0x48, 0x12, 0xF4, 0x48, 0x15, 0xF1, 0x40, 0x80, 0xE5, 0x00, 0xB5,
  // "s" (U+0073)
  0x38, 0x39, 0xEE, 0xB2, 0x28, 0x39, 0xE5, 0x5A, 0x30, 0xD0, 0x96, 0x00, 0xC6, 0x81, 0x4F, 0xB6,
  0x81, 0x4F, 0xB6, 0x81, 0x7F, 0x15, 0x89, 0x05, 0xF2, 0x01, 0x95, 0x5D, 0xC3, 0x83, 0xBE, 0xEB,
  0x22,
  // "t" (U+0074)
  0x20, 0x10, 0xE4, 0x07, 0x0B, 0x30, 0x9B, 0x84, 0x30, 0x5F, 0x73, 0x28, 0x14, 0xF2, 0x30, 0x70,
  0xE4, 0x00, 0xB4, 0x0E, 0x08, 0x38, 0x12, 0xF4, 0x38, 0x14, 0xF1, 0x38, 0x25, 0xF6, 0x32, 0x82,
  0x1C, 0xF8, 0x20,
  // "u" (U+0075)
  0x20, 0xE0, 0x72, 0x84, 0x6F, 0x02, 0xF4, 0x28, 0x49, 0xC0, 0x5F, 0x12, 0x83, 0xD9, 0x09, 0xD3,
  0x98, 0x26, 0x0C, 0xA2, 0x84, 0x4F, 0x30, 0xF6, 0x28, 0x48, 0xF0, 0x3F, 0x32, 0x8A, 0x0C, 0xC0,
  0x5F, 0x20, 0x4F, 0x80, 0x4F, 0x86, 0xCF, 0x52, 0x84, 0xAE, 0xB2, 0xF2, 0x10,
  // "v" (U+0076)
  0x90, 0x72, 0x83, 0x1F, 0x6E, 0x72, 0x83, 0x8E, 0x0D, 0x82, 0x89, 0x5E, 0x80, 0xD8, 0x07, 0xF1,
  0x0C, 0x80, 0xD9, 0x28, 0x3B, 0x95, 0xF2, 0x28, 0x2B, 0x9C, 0xB3, 0x82, 0xAC, 0xF3, 0x38, 0x19,
  0xFC, 0x48, 0x19, 0xF5, 0x40,
  // "w" (U+0077)
  0x0E, 0x07, 0x28, 0x91, 0xBF, 0x10, 0x1F, 0x5E, 0x70, 0x1A, 0x8C, 0x21, 0x07, 0xE0, 0xE7, 0x07,
  0xCF, 0x10, 0xD8, 0x0E, 0x70, 0xD6, 0xF1, 0x4F, 0x20, 0xE7, 0x4E, 0x2F, 0x1A, 0xB2, 0x87, 0xE7,
  0xA8, 0x2F, 0x2F, 0x52, 0x86, 0xE8, 0xF2, 0x2F, 0x7D, 0x38, 0x6E, 0xCB, 0x02, 0xFC, 0x73, 0x83,
  0xEF, 0x50, 0x2A, 0x01, 0x30, 0x0E, 0x28, 0x13, 0xFA, 0x40,
  // "x" (U+0078)
  0x20, 0x70, 0xE2, 0x81, 0x5F, 0x32, 0x84, 0x3F, 0x31, 0xE8, 0x48, 0x2E, 0x69, 0xD5, 0x82, 0xBC,
  0xF3, 0x58, 0x17, 0xF9, 0x68, 0x1C, 0xF6, 0x58, 0x27, 0xEC, 0xA4, 0x83, 0x2F, 0x67, 0xE4, 0x84,
  0xCB, 0x03, 0xF3, 0x28, 0x17, 0xF2, 0x20, 0xE0, 0x82,
  // "y" (U+0079)
  0x30, 0xE0, 0x82, 0x81, 0x1E, 0x73, 0x0D, 0x08, 0x28, 0x17, 0xE1, 0x30, 0xC0, 0x92, 0x0D, 0x08,
  0x48, 0x4B, 0xA0, 0x5F, 0x14, 0x83, 0xAA, 0x0C, 0x95, 0x83, 0x9B, 0x4F, 0x25, 0x82, 0x8B, 0xAA,
  0x68, 0x27, 0xCF, 0x36, 0x81, 0x6F, 0xB7, 0x81, 0x5F, 0x37, 0x0A, 0x0C, 0x78, 0x12, 0xF4, 0x58,
  0x22, 0x4D, 0xB6, 0x82, 0x9E, 0xA1, 0x60,
  // "z" (U+007A)
  0x20, 0x6C, 0x03, 0x28, 0x32, 0x33, 0xCC, 0x58, 0x14, 0xF3, 0x50, 0xD0, 0x95, 0x81, 0x8E, 0x14,
  0x81, 0x2F, 0x55, 0x0C, 0x0B, 0x58, 0x16, 0xF2, 0x48, 0x41, 0xEA, 0x33, 0x22, 0x06, 0xC0, 0x82,
  // "{" (U+007B)
  0x48, 0x15, 0xCE, 0x38, 0x22, 0xF9, 0x33, 0x07, 0x0E, 0x50, 0xB0, 0xA5, 0x0E, 0x07, 0x48, 0x13,
  0xF3, 0x38, 0x12, 0xBC, 0x38, 0x27, 0xF9, 0x13, 0x82, 0x29, 0xE1, 0x48, 0x11, 0xF4, 0x48, 0x12,
  0xF3, 0x40, 0x59, 0x50, 0x80, 0xD5, 0x0B, 0x0A, 0x58, 0x1A, 0xD1, 0x48, 0x13, 0xEE, 0x60, 0x23,
  // "|" (U+007C)
  0x8C, 0x2B, 0x8B, 0x8B, 0x8B, 0x8B, 0x8B, 0x8B, 0x8B, 0x8B, 0x8B, 0x8B, 0x8B, 0x8B, 0x8B, 0x8B,
  0x8B, 0x8B, 0x8B, 0x80,
  // "}" (U+007D)
  0x38, 0x1D, 0xC3, 0x48, 0x15, 0xEA, 0x50, 0xA0, 0xB5, 0x0D, 0x08, 0x48, 0x11, 0xF4, 0x48, 0x14,
  0xF1, 0x48, 0x13, 0xF5, 0x58, 0x18, 0xF8, 0x38, 0x28, 0xE6, 0x12, 0x81, 0x1F, 0x54, 0x81, 0x5F,
  0x14, 0x08, 0x0D, 0x50, 0xB0, 0xA5, 0x0E, 0x07, 0x38, 0x21, 0x8F, 0x23, 0x81, 0xEF, 0x74, 0x02,
  0x60,
  // "~" (U+007E)
  0x18, 0x93, 0x9E, 0xE8, 0x31, 0x81, 0x2B, 0x46, 0xCA, 0x0C, 0x60, 0x10, 0x22,
  // "¡" (U+00A1)
  0x30, 0x80, 0xD3, 0x0C, 0x0D, 0x71, 0x04, 0x30, 0x30, 0xE3, 0x06, 0x0B, 0x30, 0xA0, 0x93, 0x0E,
  0x06, 0x28, 0x12, 0xF3, 0x20, 0x69, 0x30, 0xA0, 0xD3, 0x0E, 0x0A, 0x28, 0x12, 0xF8, 0x30, 0x23,
  // "¢" (U+00A2)
  0x40, 0x80, 0x74, 0x82, 0x4C, 0x81, 0x28, 0x79, 0xFE, 0xE7, 0x05, 0xF6, 0x40, 0xD0, 0xB4, 0x81,
  0x3F, 0x54, 0x06, 0x95, 0x08, 0x0E, 0x50, 0x90, 0xD5, 0x83, 0x6F, 0x51, 0x43, 0x0C, 0xA0, 0xE4,
  0x0E, 0x04, 0x40, 0x10, 0xE4,
  // "£" (U+00A3)
  0x58, 0x36, 0xDE, 0xB3, 0x48, 0x45, 0xF7, 0x49, 0x24, 0x0C, 0x0A, 0x78, 0x11, 0xF6, 0x78, 0x14,
  0xF2, 0x70, 0x70, 0xE7, 0xD0, 0x24, 0x83, 0x3E, 0xA3, 0x35, 0x81, 0x1F, 0x57, 0x81, 0x5F, 0x17,
  0x00, 0xB7, 0x85, 0x9E, 0x53, 0x33, 0x12, 0x03, 0xE0, 0x42,
  // "¤" (U+00A4)
  0x03, 0x58, 0xA3, 0x11, 0xAB, 0x8E, 0xD7, 0xD7, 0x0E, 0xC5, 0x5E, 0xB0, 0x2D, 0x12, 0x83, 0x2E,
  0x05, 0xA4, 0x82, 0xD2, 0x4C, 0x38, 0x94, 0x1E, 0x10, 0xE9, 0x12, 0xBB, 0x08, 0xDC, 0xA8, 0x91,
  0xAE, 0x45, 0x10, 0x21, 0x03, 0x30,
  // "¥" (U+00A5)
  0x20, 0xC0, 0x93, 0x0D, 0x09, 0x20, 0x0B, 0x28, 0x16, 0xE1, 0x20, 0x90, 0xC2, 0x0E, 0x08, 0x38,
  0x37, 0xE0, 0x7E, 0x48, 0x35, 0xF0, 0xE6, 0x48, 0x23, 0xF8, 0xD5, 0x01, 0xA0, 0x54, 0x0B, 0x0E,
  0xA0, 0xE0, 0xA3, 0x84, 0x23, 0xF7, 0x21, 0x20, 0x5D, 0x02, 0x28, 0x41, 0x39, 0xE3, 0x35, 0x0A,
  0x0B, 0x70, 0xD0, 0x85,
  // "¦" (U+00A6)
  0x89, 0x4B, 0x8B, 0x8B, 0x8B, 0x8B, 0x8B, 0x8B, 0x87, 0x18, 0x94, 0xB8, 0xB8, 0xB8, 0xB8, 0xB8,
  0xB8, 0xB8,
  // "§" (U+00A7)
  0x38, 0x39, 0xEE, 0xA1, 0x28, 0x48, 0xE5, 0x5B, 0x12, 0x0C, 0x07, 0x60, 0xB0, 0xC6, 0x82, 0x5F,
  0xD3, 0x38, 0x44, 0xE6, 0xBE, 0x22, 0x0C, 0x07, 0x20, 0xE0, 0x62, 0x0C, 0x09, 0x29, 0x04, 0x28,
  0x36, 0xF9, 0xBA, 0x48, 0x14, 0xEE, 0x68, 0x12, 0xF5, 0x60, 0xE0, 0x62, 0x84, 0xA5, 0x4A, 0xE1,
  0x28, 0x39, 0xEE, 0xC3, 0x30,
  // "¨" (U+00A8)
  0x87, 0x7C, 0x09, 0xA1, 0x10, 0x11,
  // "©" (U+00A9)
  0x48, 0x55, 0xBE, 0xFE, 0xA4, 0x58, 0x90, 0x1B, 0xE8, 0x53, 0x59, 0xEA, 0x48, 0x91, 0xCB, 0x13,
  0xCF, 0xEA, 0x1C, 0xB2, 0x8A, 0x16, 0xC0, 0x1E, 0xA4, 0x56, 0x01, 0xD5, 0x0C, 0x40, 0x8D, 0x60,
  0x60, 0xB1, 0x92, 0x0B, 0x09, 0x68, 0x21, 0xF1, 0xE2, 0x0C, 0x08, 0x79, 0x19, 0x20, 0x90, 0xB6,
  0x89, 0x21, 0xF0, 0xD3, 0x03, 0xF7, 0x11, 0x32, 0x83, 0x5C, 0x07, 0xB2, 0x07, 0xB0, 0x92, 0x0C,
  0x06, 0x20, 0xD0, 0x93, 0x03, 0x01, 0x20, 0x90, 0xD3, 0x89, 0x12, 0xDC, 0x52, 0x02, 0x6C, 0xD2,
  0x48, 0x11, 0x8E, 0xB8, 0x1E, 0x81, 0x71, 0x81, 0x23, 0x15,
  // "ª" (U+00AA)
  0x18, 0xC0, 0x5C, 0xBB, 0x32, 0xD0, 0x4F, 0x08, 0x80, 0x4C, 0x0A, 0x50, 0x79, 0x0A, 0x60, 0xD6,
  0x03, 0xDA, 0xB3, 0x10,
  // "«" (U+00AB)
  0x30, 0x22, 0x00, 0x12, 0x8B, 0x22, 0xE5, 0x0C, 0x80, 0x1D, 0x80, 0xAC, 0x01, 0xDB, 0x08, 0xE1,
  0x04, 0xF4, 0x1F, 0x73, 0x83, 0xC9, 0x09, 0xD3, 0x84, 0x5E, 0x12, 0xF3, 0x38, 0x3B, 0x30, 0x85,
  0x10,
  // "¬" (U+00AC)
  0x01, 0xF1, 0x80, 0x13, 0x06, 0x96, 0x04, 0x96, 0x04, 0x96, 0x03, 0x0A,
  // "®" (U+00AE)
  0x48, 0x55, 0xBE, 0xFE, 0xA4, 0x58, 0x90, 0x1B, 0xE9, 0x54, 0x59, 0xEA, 0x48, 0x2C, 0xB1, 0xEA,
  0x83, 0xC3, 0x1C, 0xB2, 0x06, 0x0C, 0x28, 0x92, 0xE7, 0x4B, 0xD0, 0x1D, 0x50, 0xC4, 0x28, 0x2E,
  0x50, 0x59, 0x20, 0x60, 0xB1, 0x93, 0x83, 0xE6, 0x1A, 0xD2, 0x82, 0x1F, 0x1E, 0x30, 0xEA, 0x0E,
  0x04, 0x39, 0x19, 0x38, 0x3E, 0x76, 0xF1, 0x28, 0x31, 0xF0, 0xD3, 0x28, 0x3E, 0x50, 0xB9, 0x28,
  0x35, 0xC0, 0x7B, 0x28, 0x7E, 0x50, 0x3F, 0x30, 0xC6, 0x28, 0x3D, 0x90, 0x31, 0x28, 0x23, 0x29,
  0xD3, 0x89, 0x12, 0xDC, 0x52, 0x02, 0x6C, 0xD2, 0x48, 0x11, 0x8E, 0xB8, 0x1E, 0x81, 0x71, 0x81,
  0x23, 0x15,
  // "¯" (U+00AF)
  0x02, 0xF1, 0x80, 0x33,
  // "°" (U+00B0)
  0x18, 0x92, 0x3C, 0xFC, 0x20, 0xD8, 0x49, 0xC1, 0x92, 0x89, 0x41, 0xF0, 0xE5, 0x17, 0xD0, 0x5E,
  0xFE, 0x43, 0x02, 0x20,
  // "±" (U+00B1)
  0x38, 0x12, 0xF1, 0x68, 0x12, 0xF1, 0x68, 0x12, 0xF1, 0x68, 0x12, 0xF2, 0x30, 0x1F, 0x87, 0x10,
  0x33, 0x5F, 0x43, 0x34, 0x81, 0x2F, 0x16, 0x81, 0x2F, 0x16, 0x81, 0x2F, 0x14, 0x80, 0x33, 0x10,
  0x1F, 0x01,
  // "²" (U+00B2)
  0x18, 0x23, 0xBD, 0x82, 0x83, 0x64, 0x5F, 0x13, 0x81, 0x1F, 0x13, 0x09, 0x0A, 0x38, 0x16, 0xD1,
  0x28, 0x16, 0xD1, 0x28, 0x15, 0xD1, 0x39, 0x0F, 0xE0, 0x31, 0x80, 0x01, 0x20,
  // "³" (U+00B3)
  0x18, 0x25, 0xCD, 0x82, 0x83, 0x43, 0x4F, 0x13, 0x05, 0x0D, 0x28, 0x25, 0xEC, 0x13, 0x81, 0x3D,
  0x54, 0x89, 0x0A, 0x70, 0x40, 0x2E, 0x40, 0xDA, 0x08, 0x30, 0x14,
  // "´" (U+00B4)
  0x18, 0x74, 0xF7, 0x1D, 0x80, 0xA8, 0x20,
  // "µ" (U+00B5)
  0x30, 0xE0, 0x82, 0x06, 0x92, 0x81, 0x2F, 0x52, 0x09, 0x0C, 0x28, 0x15, 0xF1, 0x20, 0xC0, 0x92,
  0x08, 0x0E, 0x39, 0x06, 0x20, 0xC0, 0xB2, 0x81, 0x3F, 0x32, 0x90, 0x72, 0x06, 0x92, 0x81, 0x3F,
  0x42, 0x0B, 0x0C, 0x28, 0x56, 0xF2, 0x02, 0xF9, 0x28, 0x59, 0xF6, 0x3C, 0xF6, 0x28, 0x5D, 0xCE,
  0xD3, 0xF3, 0x29, 0x06, 0x68, 0x14, 0xF3, 0x60, 0x79, 0x70, 0xA0, 0xB7,
  // "¶" (U+00B6)
  0x10, 0x20, 0xCC, 0x81, 0x40, 0xCA, 0x83, 0xE3, 0xC4, 0x3B, 0x83, 0xE0, 0xA4, 0x5B, 0x83, 0xE0,
  0xA4, 0x7B, 0x83, 0xE0, 0xA4, 0x6B, 0x83, 0xE0, 0xA4, 0x3B, 0x84, 0xE0, 0xA4, 0x0C, 0xA8, 0x92,
  0xE0, 0xA4, 0x01, 0x9A, 0xE0, 0xA4, 0x38, 0x31, 0xE0, 0xA4, 0x38, 0x31, 0xE0, 0xA4, 0x38, 0x31,
  0xE0, 0xA4, 0x38, 0x31, 0xE0, 0xA4, 0x38, 0x31, 0xE0, 0xA4, 0x38, 0x31, 0xE0, 0xA4, 0x38, 0x31,
  0xE0, 0xA4, 0x48, 0x23, 0x02, 0x10,
  // "·" (U+00B7)
  0x18, 0x51, 0x08, 0xF2, 0x9D, 0x10,
  // "¸" (U+00B8)
  0x28, 0x45, 0x10, 0x2E, 0x22, 0x89, 0x05, 0xE2, 0x4A, 0xD5, 0xEC, 0x30,
  // "¹" (U+00B9)
  0x28, 0x92, 0x54, 0x1B, 0xF7, 0x86, 0xE3, 0x02, 0x92, 0x05, 0x0C, 0x20, 0x90, 0x82, 0x0C, 0x05,
  0x29, 0x01, 0x10,
  // "º" (U+00BA)
  0x18, 0xB2, 0x4C, 0xC4, 0x2D, 0x03, 0xC7, 0x80, 0x2D, 0xA6, 0x05, 0xA9, 0x70, 0xB4, 0x2C, 0xC7,
  0x10,
  // "»" (U+00BB)
  0x10, 0x01, 0x20, 0x23, 0x83, 0xAA, 0x06, 0xD3, 0x84, 0x4F, 0x21, 0xF5, 0x38, 0x3D, 0x90, 0xAD,
  0x38, 0xA2, 0xCC, 0x08, 0xF1, 0x09, 0xD1, 0x5F, 0x50, 0x6E, 0x23, 0xE6, 0x28, 0x39, 0x30, 0x67,
  0x30,
  // "¼" (U+00BC)
  0x30, 0x50, 0x43, 0x86, 0x2E, 0x30, 0x1B, 0xF7, 0x30, 0xC0, 0x62, 0x82, 0x86, 0xE3, 0x20, 0x80,
  0xA4, 0x02, 0x92, 0x81, 0x4D, 0x14, 0x84, 0x5C, 0x01, 0xE3, 0x58, 0x79, 0x80, 0xB8, 0x05, 0xF1,
  0x28, 0x6C, 0x57, 0xB0, 0x2E, 0xD3, 0x98, 0x55, 0xE1, 0x0C, 0x9A, 0x38, 0x61, 0xD5, 0x09, 0x6A,
  0x63, 0x86, 0xA9, 0x05, 0xA1, 0xD4, 0x20, 0x60, 0xC2, 0x0D, 0xB8, 0x3E, 0x02, 0xE2, 0x40, 0x50,
  0xC2, 0x0C, 0x06, 0x50, 0x30, 0x42,
  // "½" (U+00BD)
  0x30, 0x50, 0x43, 0x81, 0x2E, 0x32, 0x82, 0x1B, 0xF7, 0x30, 0xC0, 0x63, 0x82, 0x86, 0xE3, 0x20,
  0x80, 0xA5, 0x02, 0x92, 0x81, 0x4D, 0x15, 0x87, 0x5C, 0x01, 0xE7, 0xBD, 0x83, 0x89, 0x09, 0x80,
  0xB8, 0x64, 0x5F, 0x12, 0x82, 0xC5, 0x7B, 0x38, 0x11, 0xF1, 0x29, 0x81, 0x5E, 0x13, 0x09, 0x0A,
  0x38, 0x11, 0xD5, 0x38, 0x16, 0xD1, 0x30, 0xA0, 0x93, 0x81, 0x6D, 0x13, 0x06, 0x0C, 0x38, 0x15,
  0xD1, 0x38, 0x12, 0xE2, 0x39, 0x0F, 0xE8, 0x23, 0x0C, 0x64, 0x80, 0x01, 0x20,
  // "¾" (U+00BE)
  0x18, 0x25, 0xCD, 0x84, 0x87, 0x2E, 0x30, 0x43, 0x4F, 0x13, 0x0C, 0x06, 0x40, 0x50, 0xD3, 0x08,
  0x0A, 0x38, 0x25, 0xEC, 0x12, 0x81, 0x4D, 0x14, 0x85, 0x3D, 0x50, 0x1E, 0x36, 0x8A, 0x4A, 0x70,
  0xB8, 0x05, 0xF1, 0x40, 0x2E, 0x47, 0xB0, 0x2E, 0xD0, 0xDA, 0x86, 0x83, 0xE1, 0x0C, 0x9A, 0x28,
  0x90, 0x10, 0x1D, 0x50, 0x96, 0xA6, 0x48, 0x6A, 0x90, 0x5A, 0x1D, 0x43, 0x06, 0x0C, 0x20, 0xDB,
  0x0E, 0x28, 0x12, 0xE2, 0x40, 0x50, 0xC3, 0x0C, 0x06, 0x50, 0x30, 0x42,
  // "¿" (U+00BF)
  0x48, 0x14, 0xE4, 0x48, 0x18, 0xF3, 0x50, 0x15, 0x03, 0x02, 0x50, 0xD0, 0x44, 0x06, 0x0E, 0x48,
  0x13, 0xF5, 0x38, 0x13, 0xE7, 0x40, 0xD0, 0x94, 0x81, 0x6F, 0x14, 0x09, 0x0D, 0x58, 0x47, 0xF6,
  0x5A, 0x32, 0x83, 0xAE, 0xD9, 0x11,
  // "À" (U+00C0)
  0x58, 0x13, 0xE5, 0x70, 0xB0, 0xA7, 0x81, 0x2E, 0x17, 0x78, 0x17, 0xF8, 0x68, 0x1E, 0xF9, 0x58,
  0x26, 0xEB, 0x95, 0x82, 0xD9, 0xAA, 0x48, 0x34, 0xF3, 0xAA, 0x48, 0x3B, 0xC0, 0xAB, 0x38, 0x43,
  0xF6, 0x09, 0xC3, 0x84, 0xAF, 0x21, 0xAC, 0x20, 0x1D, 0x0D, 0x28, 0x58, 0xF5, 0x44, 0xBD, 0x20,
  0xE0, 0xB3, 0x84, 0x8E, 0x07, 0xF3, 0x38, 0x38, 0xF0, 0xDB, 0x40, 0x79, 0x10,
  // "Á" (U+00C1)
  0x78, 0x14, 0xF7, 0x68, 0x11, 0xD8, 0x70, 0xA0, 0x87, 0x73, 0x81, 0x7F, 0x87, 0x81, 0xEF, 0x96,
  0x82, 0x6E, 0xB9, 0x68, 0x2D, 0x9A, 0xA5, 0x83, 0x4F, 0x3A, 0xA5, 0x83, 0xBC, 0x0A, 0xB4, 0x84,
  0x3F, 0x60, 0x9C, 0x48, 0x4A, 0xF2, 0x1A, 0xC3, 0x01, 0xD0, 0xD3, 0x85, 0x8F, 0x54, 0x4B, 0xD3,
  0x0E, 0x0B, 0x30, 0x80, 0xE2, 0x81, 0x7F, 0x33, 0x08, 0x92, 0x0D, 0x0B, 0x40, 0x79, 0x20,
  // "Â" (U+00C2)
  0x58, 0x12, 0xEC, 0x68, 0x2C, 0x9F, 0x24, 0x83, 0xA7, 0x07, 0x97, 0x78, 0x17, 0xF8, 0x68, 0x1E,
  0xF9, 0x58, 0x26, 0xEB, 0x95, 0x82, 0xD9, 0xAA, 0x48, 0x34, 0xF3, 0xAA, 0x48, 0x3B, 0xC0, 0xAB,
  0x38, 0x43, 0xF6, 0x09, 0xC3, 0x84, 0xAF, 0x21, 0xAC, 0x20, 0x1D, 0x0D, 0x28, 0x58, 0xF5, 0x44,
  0xBD, 0x20, 0xE0, 0xB3, 0x84, 0x8E, 0x07, 0xF3, 0x38, 0x38, 0xF0, 0xDB, 0x40, 0x79, 0x10,
  // "Ã" (U+00C3)
  0x48, 0x43, 0xED, 0x36, 0x84, 0x84, 0xB6, 0x8F, 0xE2, 0x40, 0x32, 0x00, 0x16, 0x81, 0x7F, 0x87,
  0x81, 0xEF, 0x96, 0x82, 0x6E, 0xB9, 0x68, 0x2D, 0x9A, 0xA5, 0x83, 0x4F, 0x3A, 0xA5, 0x83, 0xBC,
  0x0A, 0xB4, 0x84, 0x3F, 0x60, 0x9C, 0x48, 0x4A, 0xF2, 0x1A, 0xC3, 0x01, 0xD0, 0xD3, 0x85, 0x8F,
  0x54, 0x4B, 0xD3, 0x0E, 0x0B, 0x30, 0x80, 0xE2, 0x81, 0x7F, 0x33, 0x08, 0x92, 0x0D, 0x0B, 0x40,
  0x79, 0x20,
  // "Ä" (U+00C4)
  0x48, 0x37, 0xC0, 0x9A, 0x48, 0x21, 0x10, 0x17, 0x71, 0x81, 0x7F, 0x86, 0x81, 0xEF, 0x95, 0x82,
  0x6E, 0xB9, 0x58, 0x2D, 0x9A, 0xA4, 0x83, 0x4F, 0x3A, 0xA4, 0x83, 0xBC, 0x0A, 0xB3, 0x84, 0x3F,
  0x60, 0x9C, 0x38, 0x4A, 0xF2, 0x1A, 0xC2, 0x01, 0xD0, 0xD2, 0x85, 0x8F, 0x54, 0x4B, 0xD2, 0x0E,
  0x0B, 0x38, 0x48, 0xE0, 0x7F, 0x33, 0x83, 0x8F, 0x0D, 0xB4, 0x07, 0x91,
  // "Å" (U+00C5)
  0x58, 0x21, 0xCF, 0x76, 0x83, 0x6A, 0x4D, 0x15, 0x83, 0x78, 0x1C, 0x15, 0x82, 0x2E, 0xFA, 0x71,
  0x02, 0x78, 0x17, 0xF8, 0x78, 0x1E, 0xF9, 0x68, 0x26, 0xEB, 0x96, 0x82, 0xD9, 0xAA, 0x58, 0x34,
  0xF3, 0xAA, 0x58, 0x3B, 0xC0, 0xAB, 0x48, 0x43, 0xF6, 0x09, 0xC4, 0x84, 0xAF, 0x21, 0xAC, 0x30,
  0x1D, 0x0D, 0x38, 0x58, 0xF5, 0x44, 0xBD, 0x30, 0xE0, 0xB3, 0x08, 0x0E, 0x28, 0x17, 0xF3, 0x30,
  0x89, 0x20, 0xD0, 0xB4, 0x07, 0x92,
  // "Æ" (U+00C6)
  0x60, 0xAE, 0x01, 0x58, 0x33, 0xF9, 0xF5, 0x0F, 0x36, 0x82, 0xBB, 0x8E, 0x72, 0x83, 0x3F, 0x4B,
  0xC7, 0x28, 0x3B, 0xC0, 0xE9, 0x71, 0x84, 0x4F, 0x51, 0xF6, 0x71, 0x82, 0xCD, 0x04, 0xC0, 0xA4,
  0x89, 0x04, 0xF7, 0x07, 0xE3, 0x33, 0x14, 0x0C, 0xC0, 0xB7, 0x85, 0x5F, 0x73, 0x3E, 0x87, 0x00,
  0xD2, 0x81, 0x2F, 0x46, 0x81, 0x5F, 0x42, 0x84, 0x6F, 0x53, 0x32, 0x30, 0xD0, 0xB3, 0x09, 0xC0,
  0x93,
  // "Ç" (U+00C7)
  0x48, 0x35, 0xCE, 0xEA, 0x38, 0x48, 0xF9, 0x46, 0x92, 0x81, 0x4F, 0x66, 0x0D, 0x0B, 0x68, 0x15,
  0xF4, 0x60, 0xA0, 0xE7, 0x0E, 0x0A, 0x79, 0x07, 0x68, 0x11, 0xF6, 0x68, 0x11, 0xF7, 0x70, 0xE0,
  0xB7, 0x84, 0x7F, 0x94, 0x65, 0x40, 0x8A, 0x0D, 0x06, 0x48, 0x12, 0xE2, 0x70, 0x50, 0xE5, 0x82,
  0x24, 0xAD, 0x58, 0x25, 0xEC, 0x34,
  // "È" (U+00C8)
  0x38, 0x13, 0xE5, 0x60, 0xB0, 0xA6, 0x81, 0x2E, 0x17, 0x40, 0x2D, 0x28, 0x15, 0xF4, 0x0F, 0x32,
  0x09, 0x0E, 0x60, 0xC0, 0xB6, 0x90, 0x85, 0x81, 0x3F, 0x65, 0x06, 0xC0, 0x92, 0x84, 0x9E, 0x33,
  0x31, 0x20, 0xD0, 0xA6, 0x90, 0x75, 0x81, 0x4F, 0x45, 0x84, 0x7F, 0x43, 0x32, 0x20, 0xAC, 0x08,
  0x20,
  // "É" (U+00C9)
  0x68, 0x14, 0xF7, 0x58, 0x11, 0xD8, 0x60, 0xA0, 0x87, 0x60, 0x2D, 0x38, 0x15, 0xF4, 0x0F, 0x33,
  0x09, 0x0E, 0x70, 0xC0, 0xB7, 0x90, 0x86, 0x81, 0x3F, 0x66, 0x06, 0xC0, 0x93, 0x84, 0x9E, 0x33,
  0x31, 0x30, 0xD0, 0xA7, 0x90, 0x76, 0x81, 0x4F, 0x46, 0x84, 0x7F, 0x43, 0x32, 0x30, 0xAC, 0x08,
  0x30,
  // "Ê" (U+00CA)
  0x48, 0x12, 0xEC, 0x58, 0x2C, 0x9F, 0x23, 0x83, 0xA7, 0x07, 0x97, 0x30, 0x2D, 0x28, 0x15, 0xF4,
  0x0F, 0x32, 0x09, 0x0E, 0x60, 0xC0, 0xB6, 0x90, 0x85, 0x81, 0x3F, 0x65, 0x06, 0xC0, 0x92, 0x84,
  0x9E, 0x33, 0x31, 0x20, 0xD0, 0xA6, 0x90, 0x75, 0x81, 0x4F, 0x45, 0x84, 0x7F, 0x43, 0x32, 0x20,
  0xAC, 0x08, 0x20,
  // "Ë" (U+00CB)
  0x38, 0x37, 0xC0, 0x9A, 0x38, 0x21, 0x10, 0x17, 0x40, 0x2D, 0x28, 0x15, 0xF4, 0x0F, 0x32, 0x09,
  0x0E, 0x60, 0xC0, 0xB6, 0x90, 0x85, 0x81, 0x3F, 0x65, 0x06, 0xC0, 0x92, 0x84, 0x9E, 0x33, 0x31,
  0x20, 0xD0, 0xA6, 0x90, 0x75, 0x81, 0x4F, 0x45, 0x84, 0x7F, 0x43, 0x32, 0x20, 0xAC, 0x08, 0x20,
  // "Ì" (U+00CC)
  0x38, 0x13, 0xE5, 0x60, 0xB0, 0xA6, 0x81, 0x2E, 0x17, 0x40, 0x1B, 0x0E, 0x01, 0x38, 0x11, 0xF8,
  0x58, 0x12, 0xF5, 0x58, 0x15, 0xF1, 0x50, 0x80, 0xE6, 0x0C, 0x0A, 0x69, 0x07, 0x58, 0x13, 0xF4,
  0x58, 0x16, 0xF1, 0x50, 0x90, 0xD6, 0x0D, 0x0A, 0x58, 0x11, 0xF7, 0x40, 0x9B, 0x08, 0x30,
  // "Í" (U+00CD)
  0x58, 0x14, 0xF7, 0x48, 0x11, 0xD8, 0x50, 0xA0, 0x87, 0x50, 0x1B, 0x0E, 0x01, 0x38, 0x11, 0xF8,
  0x58, 0x12, 0xF5, 0x58, 0x15, 0xF1, 0x50, 0x80, 0xE6, 0x0C, 0x0A, 0x69, 0x07, 0x58, 0x13, 0xF4,
  0x58, 0x16, 0xF1, 0x50, 0x90, 0xD6, 0x0D, 0x0A, 0x58, 0x11, 0xF7, 0x40, 0x9B, 0x08, 0x30,
  // "Î" (U+00CE)
  0x48, 0x12, 0xEC, 0x58, 0x2C, 0x9F, 0x23, 0x83, 0xA7, 0x07, 0x97, 0x30, 0x1B, 0x0E, 0x01, 0x38,
  0x11, 0xF8, 0x58, 0x12, 0xF5, 0x58, 0x15, 0xF1, 0x50, 0x80, 0xE6, 0x0C, 0x0A, 0x69, 0x07, 0x58,
  0x13, 0xF4, 0x58, 0x16, 0xF1, 0x50, 0x90, 0xD6, 0x0D, 0x0A, 0x58, 0x11, 0xF7, 0x40, 0x9B, 0x08,
  0x30,
  // "Ï" (U+00CF)
  0x38, 0x37, 0xC0, 0x9A, 0x38, 0x21, 0x10, 0x17, 0x40, 0x1B, 0x0E, 0x01, 0x38, 0x11, 0xF8, 0x58,
  0x12, 0xF5, 0x58, 0x15, 0xF1, 0x50, 0x80, 0xE6, 0x0C, 0x0A, 0x69, 0x07, 0x58, 0x13, 0xF4, 0x58,
  0x16, 0xF1, 0x50, 0x90, 0xD6, 0x0D, 0x0A, 0x58, 0x11, 0xF7, 0x40, 0x9B, 0x08, 0x30,
  // "Ð" (U+00D0)
  0x20, 0x2B, 0x0D, 0x06, 0x48, 0x55, 0xF4, 0x4A, 0xF6, 0x30, 0x80, 0xE3, 0x0C, 0x0D, 0x30, 0x0B,
  0x30, 0x89, 0x30, 0xE0, 0x73, 0x85, 0x7F, 0x10, 0x3F, 0x53, 0x82, 0x9F, 0x05, 0xC2, 0x86, 0xBD,
  0x01, 0xAD, 0x33, 0x20, 0xE0, 0xA2, 0x0C, 0x0A, 0x38, 0x14, 0xF5, 0x29, 0x07, 0x30, 0xC0, 0xD2,
  0x81, 0x3F, 0x32, 0x81, 0x7F, 0x52, 0x85, 0x7F, 0x45, 0xAF, 0x73, 0x0A, 0xA8, 0x1E, 0xA3, 0x40,
  // "Ñ" (U+00D1)
  0x48, 0x43, 0xED, 0x36, 0x85, 0x84, 0xB6, 0x8F, 0xE2, 0x50, 0x32, 0x00, 0x14, 0x81, 0x2F, 0xB4,
  0x0E, 0x07, 0x28, 0x15, 0xFE, 0x38, 0x12, 0xF4, 0x28, 0x29, 0xEF, 0x32, 0x81, 0x5F, 0x12, 0x82,
  0xC9, 0xE6, 0x20, 0x80, 0xD3, 0x98, 0x16, 0xBA, 0x20, 0xC0, 0xA2, 0x83, 0x3F, 0x38, 0xD2, 0x90,
  0x62, 0x87, 0x6F, 0x04, 0xF1, 0x3F, 0x32, 0x85, 0x9C, 0x01, 0xF5, 0x69, 0x30, 0xD0, 0x92, 0x82,
  0xD8, 0x9C, 0x39, 0x05, 0x28, 0x29, 0xBB, 0x92, 0x81, 0x4F, 0x22, 0x82, 0x5F, 0xE6, 0x20, 0x70,
  0xE3, 0x02, 0xA0, 0x22, 0x0A, 0x0B, 0x40, 0x0E, 0x30,
  // "Ò" (U+00D2)
  0x58, 0x13, 0xE5, 0x71, 0x0B, 0x0A, 0x71, 0x81, 0x2E, 0x17, 0x71, 0x83, 0x6D, 0xFD, 0x54, 0x85,
  0xAE, 0x74, 0xBF, 0x22, 0x81, 0x6F, 0x43, 0x0E, 0x09, 0x20, 0xD0, 0xA4, 0x84, 0xCB, 0x05, 0xF3,
  0x48, 0x3C, 0xB0, 0xAE, 0x58, 0x3D, 0xA0, 0xEA, 0x59, 0x82, 0x80, 0xF8, 0x48, 0x44, 0xF4, 0x2F,
  0x64, 0x84, 0x9E, 0x01, 0xF6, 0x40, 0xE0, 0x82, 0x0E, 0x0A, 0x38, 0x19, 0xE1, 0x28, 0x58, 0xF7,
  0x49, 0xF5, 0x48, 0x39, 0xEE, 0xB3, 0x30,
  // "Ó" (U+00D3)
  0x78, 0x14, 0xF7, 0x68, 0x11, 0xD8, 0x70, 0xA0, 0x87, 0x72, 0x83, 0x6D, 0xFD, 0x54, 0x85, 0xAE,
  0x74, 0xBF, 0x22, 0x81, 0x6F, 0x43, 0x0E, 0x09, 0x20, 0xD0, 0xA4, 0x84, 0xCB, 0x05, 0xF3, 0x48,
  0x3C, 0xB0, 0xAE, 0x58, 0x3D, 0xA0, 0xEA, 0x59, 0x82, 0x80, 0xF8, 0x48, 0x44, 0xF4, 0x2F, 0x64,
  0x84, 0x9E, 0x01, 0xF6, 0x40, 0xE0, 0x82, 0x0E, 0x0A, 0x38, 0x19, 0xE1, 0x28, 0x58, 0xF7, 0x49,
  0xF5, 0x48, 0x39, 0xEE, 0xB3, 0x30,
  // "Ô" (U+00D4)
  0x58, 0x12, 0xEC, 0x78, 0x2C, 0x9F, 0x25, 0x83, 0xA7, 0x07, 0x97, 0x71, 0x83, 0x6D, 0xFD, 0x54,
  0x85, 0xAE, 0x74, 0xBF, 0x22, 0x81, 0x6F, 0x43, 0x0E, 0x09, 0x20, 0xD0, 0xA4, 0x84, 0xCB, 0x05,
  0xF3, 0x48, 0x3C, 0xB0, 0xAE, 0x58, 0x3D, 0xA0, 0xEA, 0x59, 0x82, 0x80, 0xF8, 0x48, 0x44, 0xF4,
  0x2F, 0x64, 0x84, 0x9E, 0x01, 0xF6, 0x40, 0xE0, 0x82, 0x0E, 0x0A, 0x38, 0x19, 0xE1, 0x28, 0x58,
  0xF7, 0x49, 0xF5, 0x48, 0x39, 0xEE, 0xB3, 0x30,
  // "Õ" (U+00D5)
  0x48, 0x43, 0xED, 0x36, 0x84, 0x84, 0xB6, 0x8F, 0xE2, 0x40, 0x32, 0x00, 0x15, 0x83, 0x6D, 0xFD,
  0x54, 0x85, 0xAE, 0x74, 0xBF, 0x22, 0x81, 0x6F, 0x43, 0x0E, 0x09, 0x20, 0xD0, 0xA4, 0x84, 0xCB,
  0x05, 0xF3, 0x48, 0x3C, 0xB0, 0xAE, 0x58, 0x3D, 0xA0, 0xEA, 0x59, 0x82, 0x80, 0xF8, 0x48, 0x44,
  0xF4, 0x2F, 0x64, 0x84, 0x9E, 0x01, 0xF6, 0x40, 0xE0, 0x82, 0x0E, 0x0A, 0x38, 0x19, 0xE1, 0x28,
  0x58, 0xF7, 0x49, 0xF5, 0x48, 0x39, 0xEE, 0xB3, 0x30,
  // "Ö" (U+00D6)
  0x48, 0x37, 0xC0, 0x9A, 0x58, 0x21, 0x10, 0x17, 0x72, 0x83, 0x6D, 0xFD, 0x54, 0x85, 0xAE, 0x74,
  0xBF, 0x22, 0x81, 0x6F, 0x43, 0x0E, 0x09, 0x20, 0xD0, 0xA4, 0x84, 0xCB, 0x05, 0xF3, 0x48, 0x3C,
  0xB0, 0xAE, 0x58, 0x3D, 0xA0, 0xEA, 0x59, 0x82, 0x80, 0xF8, 0x48, 0x44, 0xF4, 0x2F, 0x64, 0x84,
  0x9E, 0x01, 0xF6, 0x40, 0xE0, 0x82, 0x0E, 0x0A, 0x38, 0x19, 0xE1, 0x28, 0x58, 0xF7, 0x49, 0xF5,
  0x48, 0x39, 0xEE, 0xB3, 0x30,
  // "×" (U+00D7)
  0x07, 0x03, 0x38, 0x95, 0x47, 0x8E, 0x30, 0x4F, 0x70, 0x8E, 0x7F, 0x73, 0x81, 0xAF, 0x93, 0x89,
  0x54, 0xFC, 0xE3, 0x04, 0xF7, 0x08, 0xE3, 0xB7, 0x30, 0x80, 0xA0,
  // "Ø" (U+00D8)
  0x72, 0x04, 0x01, 0x48, 0x56, 0xDE, 0xC6, 0xE3, 0x38, 0x59, 0xE7, 0x5C, 0xF8, 0x38, 0x15, 0xF4,
  0x28, 0x16, 0xF8, 0x30, 0xD0, 0xA2, 0x82, 0x2E, 0xEB, 0x28, 0x15, 0xF3, 0x28, 0x2B, 0x6C, 0xB2,
  0x0A, 0x0E, 0x28, 0x37, 0xB0, 0xEA, 0x28, 0x7E, 0xA0, 0x2D, 0x10, 0xF8, 0x29, 0x89, 0x48, 0x0C,
  0x50, 0x4F, 0x40, 0x1F, 0x67, 0x92, 0x09, 0x0E, 0x28, 0x21, 0xFA, 0xD2, 0x81, 0x1E, 0x83, 0x81,
  0xEF, 0x32, 0x81, 0x9E, 0x13, 0x85, 0xCF, 0x74, 0x9F, 0x53, 0x85, 0x6C, 0x8D, 0xEB, 0x44, 0x04,
  0x02, 0x72,
  // "Ù" (U+00D9)
  0x48, 0x13, 0xE5, 0x71, 0x0B, 0x0A, 0x71, 0x81, 0x2E, 0x17, 0x78, 0x14, 0xF3, 0x30, 0x90, 0xD2,
  0x07, 0x94, 0x0C, 0x0A, 0x20, 0xA0, 0xC4, 0x90, 0x62, 0x0E, 0x08, 0x38, 0x53, 0xF3, 0x01, 0xF5,
  0x30, 0x79, 0x28, 0x15, 0xF2, 0x30, 0xA0, 0xC2, 0x08, 0x0E, 0x40, 0xD0, 0x92, 0x00, 0xB3, 0x81,
  0x1F, 0x52, 0x0E, 0x08, 0x38, 0x55, 0xF2, 0x01, 0xF5, 0x30, 0x90, 0xD2, 0x81, 0x1F, 0x62, 0x81,
  0x1E, 0x83, 0x85, 0xCE, 0x67, 0xDD, 0x13, 0x84, 0x2B, 0xEE, 0xA1, 0x30,
  // "Ú" (U+00DA)
  0x78, 0x14, 0xF7, 0x68, 0x11, 0xD8, 0x70, 0xA0, 0x87, 0x78, 0x14, 0xF3, 0x30, 0x90, 0xD2, 0x07,
  0x94, 0x0C, 0x0A, 0x20, 0xA0, 0xC4, 0x90, 0x62, 0x0E, 0x08, 0x38, 0x53, 0xF3, 0x01, 0xF5, 0x30,
  0x79, 0x28, 0x15, 0xF2, 0x30, 0xA0, 0xC2, 0x08, 0x0E, 0x40, 0xD0, 0x92, 0x00, 0xB3, 0x81, 0x1F,
  0x52, 0x0E, 0x08, 0x38, 0x55, 0xF2, 0x01, 0xF5, 0x30, 0x90, 0xD2, 0x81, 0x1F, 0x62, 0x81, 0x1E,
  0x83, 0x85, 0xCE, 0x67, 0xDD, 0x13, 0x84, 0x2B, 0xEE, 0xA1, 0x30,
  // "Û" (U+00DB)
  0x58, 0x12, 0xEC, 0x78, 0x2C, 0x9F, 0x25, 0x83, 0xA7, 0x07, 0x97, 0x68, 0x14, 0xF3, 0x30, 0x90,
  0xD2, 0x07, 0x94, 0x0C, 0x0A, 0x20, 0xA0, 0xC4, 0x90, 0x62, 0x0E, 0x08, 0x38, 0x53, 0xF3, 0x01,
  0xF5, 0x30, 0x79, 0x28, 0x15, 0xF2, 0x30, 0xA0, 0xC2, 0x08, 0x0E, 0x40, 0xD0, 0x92, 0x00, 0xB3,
  0x81, 0x1F, 0x52, 0x0E, 0x08, 0x38, 0x55, 0xF2, 0x01, 0xF5, 0x30, 0x90, 0xD2, 0x81, 0x1F, 0x62,
  0x81, 0x1E, 0x83, 0x85, 0xCE, 0x67, 0xDD, 0x13, 0x84, 0x2B, 0xEE, 0xA1, 0x30,
  // "Ü" (U+00DC)
  0x48, 0x37, 0xC0, 0x9A, 0x58, 0x21, 0x10, 0x17, 0x78, 0x14, 0xF3, 0x30, 0x90, 0xD2, 0x07, 0x94,
  0x0C, 0x0A, 0x20, 0xA0, 0xC4, 0x90, 0x62, 0x0E, 0x08, 0x38, 0x53, 0xF3, 0x01, 0xF5, 0x30, 0x79,
  0x28, 0x15, 0xF2, 0x30, 0xA0, 0xC2, 0x08, 0x0E, 0x40, 0xD0, 0x92, 0x00, 0xB3, 0x81, 0x1F, 0x52,
  0x0E, 0x08, 0x38, 0x55, 0xF2, 0x01, 0xF5, 0x30, 0x90, 0xD2, 0x81, 0x1F, 0x62, 0x81, 0x1E, 0x83,
  0x85, 0xCE, 0x67, 0xDD, 0x13, 0x84, 0x2B, 0xEE, 0xA1, 0x30,
  // "Ý" (U+00DD)
  0x58, 0x14, 0xF7, 0x48, 0x11, 0xD8, 0x50, 0xA0, 0x87, 0x38, 0x15, 0xF2, 0x28, 0x41, 0xE8, 0x3F,
  0x42, 0x89, 0x09, 0xE0, 0x1F, 0x60, 0x2F, 0x62, 0x83, 0xE8, 0x0A, 0xC3, 0x83, 0xBA, 0x3F, 0x43,
  0x82, 0x9C, 0xBA, 0x40, 0x7A, 0x02, 0x48, 0x15, 0xF8, 0x58, 0x15, 0xF2, 0x50, 0x80, 0xE6, 0x00,
  0xB6, 0x0E, 0x08, 0x58, 0x12, 0xF5, 0x50,
  // "Þ" (U+00DE)
  0x28, 0x12, 0xF4, 0x58, 0x15, 0xF2, 0x50, 0x9A, 0x0E, 0x09, 0x38, 0x4C, 0xA4, 0x8F, 0x82, 0x90,
  0x62, 0x84, 0xBC, 0x03, 0xF3, 0x28, 0x2A, 0xD0, 0x69, 0x38, 0x3C, 0xB0, 0x9D, 0x28, 0x90, 0x3F,
  0x60, 0xDA, 0x14, 0xDC, 0x2C, 0x85, 0xA1, 0x04, 0xF5, 0x24, 0x07, 0x96, 0x0A, 0x0C, 0x60,
  // "ß" (U+00DF)
  0x68, 0x32, 0xBE, 0xD5, 0x68, 0x51, 0xEB, 0x4A, 0xF1, 0x58, 0x56, 0xE1, 0x04, 0xF2, 0x50, 0xB0,
  0xA2, 0x0A, 0x0D, 0x68, 0x4E, 0x70, 0x8E, 0x35, 0x84, 0x2F, 0x45, 0xF4, 0x68, 0x36, 0xF0, 0xC9,
  0x78, 0x39, 0xC0, 0xCC, 0x78, 0x4C, 0x90, 0x5F, 0x66, 0x90, 0x62, 0x81, 0xBE, 0x14, 0x81, 0x3F,
  0x32, 0x81, 0x4F, 0x44, 0x07, 0x0E, 0x38, 0x14, 0xF3, 0x48, 0x5A, 0xB6, 0x54, 0xCD, 0x58, 0x5D,
  0x86, 0xEE, 0xB2, 0x48, 0x11, 0xF5, 0x72, 0x81, 0x5F, 0x17, 0x82, 0x24, 0xDB, 0x71, 0x82, 0x5F,
  0xC2, 0x71,
  // "à" (U+00E0)
  0x38, 0x13, 0xE5, 0x70, 0xB0, 0xA7, 0x81, 0x2E, 0x17, 0x68, 0x51, 0xAE, 0xC2, 0xF2, 0x28, 0x4B,
  0xD5, 0x8D, 0xE2, 0x81, 0x5F, 0x32, 0x0E, 0x0B, 0x20, 0xC0, 0xB3, 0x98, 0x38, 0x01, 0xF6, 0x28,
  0x51, 0xF5, 0x04, 0xF3, 0x28, 0x55, 0xF2, 0x05, 0xF1, 0x20, 0xA0, 0xE2, 0x85, 0x6F, 0x10, 0x3F,
  0xB2, 0x85, 0x3F, 0x85, 0xCD, 0x73, 0x84, 0x8E, 0xC2, 0xD4, 0x20,
  // "á" (U+00E1)
  0x58, 0x14, 0xF7, 0x58, 0x11, 0xD8, 0x60, 0xA0, 0x87, 0x78, 0x51, 0xAE, 0xC2, 0xF2, 0x28, 0x4B,
  0xD5, 0x8D, 0xE2, 0x81, 0x5F, 0x32, 0x0E, 0x0B, 0x20, 0xC0, 0xB3, 0x98, 0x38, 0x01, 0xF6, 0x28,
  0x51, 0xF5, 0x04, 0xF3, 0x28, 0x55, 0xF2, 0x05, 0xF1, 0x20, 0xA0, 0xE2, 0x85, 0x6F, 0x10, 0x3F,
  0xB2, 0x85, 0x3F, 0x85, 0xCD, 0x73, 0x84, 0x8E, 0xC2, 0xD4, 0x20,
  // "â" (U+00E2)
  0x48, 0x12, 0xEC, 0x68, 0x2C, 0x9F, 0x24, 0x83, 0xA7, 0x07, 0x97, 0x58, 0x51, 0xAE, 0xC2, 0xF2,
  0x28, 0x4B, 0xD5, 0x8D, 0xE2, 0x81, 0x5F, 0x32, 0x0E, 0x0B, 0x20, 0xC0, 0xB3, 0x98, 0x38, 0x01,
  0xF6, 0x28, 0x51, 0xF5, 0x04, 0xF3, 0x28, 0x55, 0xF2, 0x05, 0xF1, 0x20, 0xA0, 0xE2, 0x85, 0x6F,
  0x10, 0x3F, 0xB2, 0x85, 0x3F, 0x85, 0xCD, 0x73, 0x84, 0x8E, 0xC2, 0xD4, 0x20,
  // "ã" (U+00E3)
  0x38, 0x43, 0xED, 0x36, 0x83, 0x84, 0xB6, 0x8F, 0xE2, 0x30, 0x32, 0x00, 0x13, 0x85, 0x1A, 0xEC,
  0x2F, 0x22, 0x84, 0xBD, 0x58, 0xDE, 0x28, 0x15, 0xF3, 0x20, 0xE0, 0xB2, 0x0C, 0x0B, 0x39, 0x83,
  0x80, 0x1F, 0x62, 0x85, 0x1F, 0x50, 0x4F, 0x32, 0x85, 0x5F, 0x20, 0x5F, 0x12, 0x0A, 0x0E, 0x28,
  0x56, 0xF1, 0x03, 0xFB, 0x28, 0x53, 0xF8, 0x5C, 0xD7, 0x38, 0x48, 0xEC, 0x2D, 0x42,
  // "ä" (U+00E4)
  0x38, 0x37, 0xC0, 0x9A, 0x48, 0x21, 0x10, 0x17, 0x68, 0x51, 0xAE, 0xC2, 0xF2, 0x28, 0x4B, 0xD5,
  0x8D, 0xE2, 0x81, 0x5F, 0x32, 0x0E, 0x0B, 0x20, 0xC0, 0xB3, 0x98, 0x38, 0x01, 0xF6, 0x28, 0x51,
  0xF5, 0x04, 0xF3, 0x28, 0x55, 0xF2, 0x05, 0xF1, 0x20, 0xA0, 0xE2, 0x85, 0x6F, 0x10, 0x3F, 0xB2,
  0x85, 0x3F, 0x85, 0xCD, 0x73, 0x84, 0x8E, 0xC2, 0xD4, 0x20,
  // "å" (U+00E5)
  0x38, 0x21, 0xCF, 0x75, 0x83, 0x6A, 0x4D, 0x14, 0x83, 0x78, 0x1C, 0x14, 0x82, 0x2E, 0xFA, 0x70,
  0x25, 0x85, 0x1A, 0xEC, 0x2F, 0x22, 0x84, 0xBD, 0x58, 0xDE, 0x28, 0x15, 0xF3, 0x20, 0xE0, 0xB2,
  0x0C, 0x0B, 0x39, 0x83, 0x80, 0x1F, 0x62, 0x85, 0x1F, 0x50, 0x4F, 0x32, 0x85, 0x5F, 0x20, 0x5F,
  0x12, 0x0A, 0x0E, 0x28, 0x56, 0xF1, 0x03, 0xFB, 0x28, 0x53, 0xF8, 0x5C, 0xD7, 0x38, 0x48, 0xEC,
  0x2D, 0x42,
  // "æ" (U+00E6)
  0x28, 0x90, 0x1A, 0xEB, 0x5B, 0x7E, 0xD4, 0x28, 0xA0, 0xBD, 0x59, 0xEE, 0xB4, 0xCD, 0x05, 0xF3,
  0x02, 0xFC, 0x28, 0x39, 0xD0, 0xBB, 0x28, 0x90, 0x2F, 0x52, 0x7F, 0x61, 0xF6, 0x20, 0x4B, 0x84,
  0xD6, 0x04, 0xF3, 0x28, 0x28, 0xD2, 0x13, 0x81, 0x6F, 0x12, 0x0D, 0x0C, 0x58, 0x56, 0xF1, 0x04,
  0xFE, 0x58, 0x91, 0x3F, 0x85, 0xBF, 0xE9, 0x47, 0x72, 0x89, 0x09, 0xEB, 0x3E, 0x4D, 0xEC, 0x41,
  // "ç" (U+00E7)
  0x38, 0x29, 0xEE, 0x82, 0x87, 0xBD, 0x55, 0x40, 0x6F, 0x24, 0x0D, 0x0A, 0x48, 0x12, 0xF5, 0x48,
  0x14, 0xF2, 0x48, 0x16, 0xF1, 0x48, 0x15, 0xF2, 0x48, 0x41, 0xFB, 0x47, 0x22, 0x05, 0xA0, 0xC0,
  0x22, 0x81, 0x2E, 0x25, 0x05, 0x0E, 0x38, 0x22, 0x4A, 0xD3, 0x82, 0x5E, 0xC3, 0x30,
  // "è" (U+00E8)
  0x38, 0x13, 0xE5, 0x50, 0xB0, 0xA5, 0x81, 0x2E, 0x17, 0x38, 0x29, 0xEE, 0x62, 0x8A, 0x2B, 0xC5,
  0x9F, 0x06, 0xE1, 0x06, 0xF0, 0xD8, 0x26, 0xE9, 0x2B, 0x85, 0xE8, 0x05, 0xF4, 0x23, 0x06, 0x95,
  0x81, 0x5F, 0x24, 0x84, 0x1E, 0xB4, 0x58, 0x28, 0x34, 0xDF, 0xD6, 0x10,
  // "é" (U+00E9)
  0x58, 0x14, 0xF7, 0x48, 0x11, 0xD8, 0x50, 0xA0, 0x87, 0x68, 0x29, 0xEE, 0x63, 0x82, 0xBC, 0x59,
  0x92, 0x83, 0x6E, 0x10, 0x69, 0x28, 0x6D, 0x82, 0x6E, 0x90, 0x2B, 0x0E, 0x08, 0x28, 0x25, 0xF4,
  0x24, 0x06, 0x96, 0x81, 0x5F, 0x25, 0x84, 0x1E, 0xB4, 0x58, 0x38, 0x34, 0xDF, 0xD6, 0x20,
  // "ê" (U+00EA)
  0x48, 0x12, 0xEC, 0x58, 0x2C, 0x9F, 0x23, 0x83, 0xA7, 0x07, 0x97, 0x48, 0x29, 0xEE, 0x63, 0x82,
  0xBC, 0x59, 0x92, 0x83, 0x6E, 0x10, 0x69, 0x28, 0x6D, 0x82, 0x6E, 0x90, 0x2B, 0x0E, 0x08, 0x28,
  0x25, 0xF4, 0x24, 0x06, 0x96, 0x81, 0x5F, 0x25, 0x84, 0x1E, 0xB4, 0x58, 0x38, 0x34, 0xDF, 0xD6,
  0x20,
  // "ë" (U+00EB)
  0x38, 0x37, 0xC0, 0x9A, 0x38, 0x21, 0x10, 0x17, 0x58, 0x29, 0xEE, 0x63, 0x82, 0xBC, 0x59, 0x92,
  0x83, 0x6E, 0x10, 0x69, 0x28, 0x6D, 0x82, 0x6E, 0x90, 0x2B, 0x0E, 0x08, 0x28, 0x25, 0xF4, 0x24,
  0x06, 0x96, 0x81, 0x5F, 0x25, 0x84, 0x1E, 0xB4, 0x58, 0x38, 0x34, 0xDF, 0xD6, 0x20,
  // "ì" (U+00EC)
  0x18, 0x13, 0xE5, 0x30, 0xB0, 0xA3, 0x81, 0x2E, 0x17, 0x0D, 0x08, 0x28, 0x11, 0xF5, 0x28, 0x14,
  0xF1, 0x20, 0x80, 0xE3, 0x00, 0xB3, 0x0E, 0x07, 0x28, 0x12, 0xF4, 0x28, 0x15, 0xF1, 0x20, 0x80,
  0xD3, 0x0B, 0x0A, 0x30,
  // "í" (U+00ED)
  0x38, 0x14, 0xF7, 0x28, 0x11, 0xD8, 0x30, 0xA0, 0x87, 0x30, 0xD0, 0x83, 0x81, 0x1F, 0x53, 0x81,
  0x4F, 0x13, 0x08, 0x0E, 0x40, 0x0B, 0x40, 0xE0, 0x73, 0x81, 0x2F, 0x43, 0x81, 0x5F, 0x13, 0x08,
  0x0D, 0x40, 0xB0, 0xA4,
  // "î" (U+00EE)
  0x28, 0x12, 0xEC, 0x38, 0x90, 0xC9, 0xF2, 0x0A, 0x70, 0x79, 0x71, 0x0D, 0x08, 0x38, 0x11, 0xF5,
  0x38, 0x14, 0xF1, 0x30, 0x80, 0xE4, 0x00, 0xB4, 0x0E, 0x07, 0x38, 0x12, 0xF4, 0x38, 0x15, 0xF1,
  0x30, 0x80, 0xD4, 0x0B, 0x0A, 0x40,
  // "ï" (U+00EF)
  0x18, 0x90, 0x7C, 0x09, 0xA0, 0x11, 0x01, 0x72, 0x0D, 0x08, 0x38, 0x11, 0xF5, 0x38, 0x14, 0xF1,
  0x30, 0x80, 0xE4, 0x00, 0xB4, 0x0E, 0x07, 0x38, 0x12, 0xF4, 0x38, 0x15, 0xF1, 0x30, 0x80, 0xD4,
  0x0B, 0x0A, 0x40,
  // "ð" (U+00F0)
  0x40, 0x12, 0x01, 0x38, 0x37, 0xE5, 0xAB, 0x48, 0x1C, 0xF8, 0x38, 0x31, 0xCA, 0xCB, 0x48, 0x34,
  0x04, 0xF1, 0x69, 0x05, 0x28, 0x97, 0x5D, 0xF8, 0xE7, 0x04, 0xF8, 0x4B, 0xE7, 0x0D, 0x92, 0x84,
  0x4F, 0x63, 0xF3, 0x28, 0x23, 0xF4, 0x79, 0x38, 0x35, 0xF1, 0x9D, 0x38, 0x39, 0xC0, 0x8E, 0x28,
  0x90, 0x2E, 0x60, 0x4F, 0x85, 0xCC, 0x38, 0x37, 0xEE, 0xA1, 0x20,
  // "ñ" (U+00F1)
  0x38, 0x43, 0xED, 0x36, 0x83, 0x84, 0xB6, 0x8F, 0xE2, 0x30, 0x32, 0x00, 0x13, 0x84, 0xE5, 0x9E,
  0xC2, 0x28, 0x52, 0xFD, 0x85, 0xF9, 0x28, 0x15, 0xF8, 0x20, 0xD0, 0x92, 0x81, 0x8F, 0x12, 0x90,
  0x72, 0x0B, 0x0C, 0x28, 0x13, 0xF4, 0x20, 0xE0, 0x82, 0x85, 0x6F, 0x10, 0x2F, 0x52, 0x09, 0x0D,
  0x28, 0x15, 0xF1, 0x20, 0xD0, 0xA2, 0x09, 0x0E, 0x39, 0x06, 0x20, 0xC0, 0xB2, 0x81, 0x3F, 0x32,
  // "ò" (U+00F2)
  0x38, 0x13, 0xE5, 0x60, 0xB0, 0xA6, 0x81, 0x2E, 0x17, 0x48, 0x31, 0x9E, 0xD6, 0x38, 0x90, 0xCD,
  0x58, 0xF3, 0x05, 0xF2, 0x28, 0x3E, 0x70, 0xCA, 0x38, 0x3E, 0x81, 0xF5, 0x39, 0x82, 0x74, 0xF2,
  0x28, 0x43, 0xF4, 0x6F, 0x12, 0x84, 0x7F, 0x05, 0xF1, 0x28, 0x90, 0xE9, 0x01, 0xFA, 0x4B, 0xE1,
  0x28, 0x34, 0xDE, 0xB2, 0x20,
  // "ó" (U+00F3)
  0x58, 0x14, 0xF7, 0x48, 0x11, 0xD8, 0x50, 0xA0, 0x87, 0x58, 0x31, 0x9E, 0xD6, 0x38, 0x90, 0xCD,
  0x58, 0xF3, 0x05, 0xF2, 0x28, 0x3E, 0x70, 0xCA, 0x38, 0x3E, 0x81, 0xF5, 0x39, 0x82, 0x74, 0xF2,
  0x28, 0x43, 0xF4, 0x6F, 0x12, 0x84, 0x7F, 0x05, 0xF1, 0x28, 0x90, 0xE9, 0x01, 0xFA, 0x4B, 0xE1,
  0x28, 0x34, 0xDE, 0xB2, 0x20,
  // "ô" (U+00F4)
  0x48, 0x12, 0xEC, 0x58, 0x2C, 0x9F, 0x23, 0x83, 0xA7, 0x07, 0x97, 0x38, 0x31, 0x9E, 0xD6, 0x38,
  0x90, 0xCD, 0x58, 0xF3, 0x05, 0xF2, 0x28, 0x3E, 0x70, 0xCA, 0x38, 0x3E, 0x81, 0xF5, 0x39, 0x82,
  0x74, 0xF2, 0x28, 0x43, 0xF4, 0x6F, 0x12, 0x84, 0x7F, 0x05, 0xF1, 0x28, 0x90, 0xE9, 0x01, 0xFA,
  0x4B, 0xE1, 0x28, 0x34, 0xDE, 0xB2, 0x20,
  // "õ" (U+00F5)
  0x28, 0x43, 0xED, 0x36, 0x82, 0x84, 0xB6, 0x8F, 0xE2, 0x20, 0x32, 0x00, 0x13, 0x83, 0x19, 0xED,
  0x63, 0x89, 0x0C, 0xD5, 0x8F, 0x30, 0x5F, 0x22, 0x83, 0xE7, 0x0C, 0xA3, 0x83, 0xE8, 0x1F, 0x53,
  0x98, 0x27, 0x4F, 0x22, 0x84, 0x3F, 0x46, 0xF1, 0x28, 0x47, 0xF0, 0x5F, 0x12, 0x89, 0x0E, 0x90,
  0x1F, 0xA4, 0xBE, 0x12, 0x83, 0x4D, 0xEB, 0x22,
  // "ö" (U+00F6)
  0x38, 0x37, 0xC0, 0x9A, 0x38, 0x21, 0x10, 0x17, 0x48, 0x31, 0x9E, 0xD6, 0x38, 0x90, 0xCD, 0x58,
  0xF3, 0x05, 0xF2, 0x28, 0x3E, 0x70, 0xCA, 0x38, 0x3E, 0x81, 0xF5, 0x39, 0x82, 0x74, 0xF2, 0x28,
  0x43, 0xF4, 0x6F, 0x12, 0x84, 0x7F, 0x05, 0xF1, 0x28, 0x90, 0xE9, 0x01, 0xFA, 0x4B, 0xE1, 0x28,
  0x34, 0xDE, 0xB2, 0x20,
  // "÷" (U+00F7)
  0x38, 0x14, 0xE3, 0x68, 0x15, 0xF4, 0x70, 0x17, 0x60, 0x1F, 0x01, 0x18, 0x03, 0x35, 0x01, 0x78,
  0x15, 0xF4, 0x68, 0x14, 0xE3, 0x30,
  // "ø" (U+00F8)
  0x70, 0x62, 0x84, 0x19, 0xED, 0x9C, 0x28, 0x98, 0x2C, 0xD5, 0x9F, 0x50, 0x5F, 0x20, 0xAF, 0x80,
  0xCA, 0x05, 0xAD, 0x81, 0xF5, 0x1D, 0x1F, 0x74, 0xF2, 0xA5, 0x2F, 0x46, 0xF6, 0x90, 0x7E, 0x05,
  0xFD, 0x10, 0xD8, 0x01, 0xFB, 0x4B, 0xD1, 0x07, 0xCD, 0xEB, 0x22, 0x08, 0x01, 0x60,
  // "ù" (U+00F9)
  0x38, 0x13, 0xE5, 0x60, 0xB0, 0xA6, 0x81, 0x2E, 0x17, 0x40, 0xE0, 0x72, 0x84, 0x6F, 0x02, 0xF4,
  0x28, 0x49, 0xC0, 0x5F, 0x12, 0x83, 0xD9, 0x09, 0xD3, 0x98, 0x26, 0x0C, 0xA2, 0x84, 0x4F, 0x30,
  0xF6, 0x28, 0x48, 0xF0, 0x3F, 0x32, 0x8A, 0x0C, 0xC0, 0x5F, 0x20, 0x4F, 0x80, 0x4F, 0x86, 0xCF,
  0x52, 0x84, 0xAE, 0xB2, 0xF2, 0x10,
  // "ú" (U+00FA)
  0x58, 0x14, 0xF7, 0x48, 0x11, 0xD8, 0x50, 0xA0, 0x87, 0x50, 0xE0, 0x72, 0x84, 0x6F, 0x02, 0xF4,
  0x28, 0x49, 0xC0, 0x5F, 0x12, 0x83, 0xD9, 0x09, 0xD3, 0x98, 0x26, 0x0C, 0xA2, 0x84, 0x4F, 0x30,
  0xF6, 0x28, 0x48, 0xF0, 0x3F, 0x32, 0x8A, 0x0C, 0xC0, 0x5F, 0x20, 0x4F, 0x80, 0x4F, 0x86, 0xCF,
  0x52, 0x84, 0xAE, 0xB2, 0xF2, 0x10,
  // "û" (U+00FB)
  0x48, 0x12, 0xEC, 0x58, 0x2C, 0x9F, 0x23, 0x83, 0xA7, 0x07, 0x97, 0x30, 0xE0, 0x72, 0x84, 0x6F,
  0x02, 0xF4, 0x28, 0x49, 0xC0, 0x5F, 0x12, 0x83, 0xD9, 0x09, 0xD3, 0x98, 0x26, 0x0C, 0xA2, 0x84,
  0x4F, 0x30, 0xF6, 0x28, 0x48, 0xF0, 0x3F, 0x32, 0x8A, 0x0C, 0xC0, 0x5F, 0x20, 0x4F, 0x80, 0x4F,
  0x86, 0xCF, 0x52, 0x84, 0xAE, 0xB2, 0xF2, 0x10,
  // "ü" (U+00FC)
  0x38, 0x37, 0xC0, 0x9A, 0x38, 0x21, 0x10, 0x17, 0x40, 0xE0, 0x72, 0x84, 0x6F, 0x02, 0xF4, 0x28,
  0x49, 0xC0, 0x5F, 0x12, 0x83, 0xD9, 0x09, 0xD3, 0x98, 0x26, 0x0C, 0xA2, 0x84, 0x4F, 0x30, 0xF6,
  0x28, 0x48, 0xF0, 0x3F, 0x32, 0x8A, 0x0C, 0xC0, 0x5F, 0x20, 0x4F, 0x80, 0x4F, 0x86, 0xCF, 0x52,
  0x84, 0xAE, 0xB2, 0xF2, 0x10,
  // "ý" (U+00FD)
  0x78, 0x14, 0xF7, 0x68, 0x11, 0xD8, 0x70, 0xA0, 0x87, 0x71, 0x0E, 0x08, 0x28, 0x11, 0xE7, 0x30,
  0xD0, 0x82, 0x81, 0x7E, 0x13, 0x0C, 0x09, 0x20, 0xD0, 0x84, 0x84, 0xBA, 0x05, 0xF1, 0x48, 0x3A,
  0xA0, 0xC9, 0x58, 0x39, 0xB4, 0xF2, 0x58, 0x28, 0xBA, 0xA6, 0x82, 0x7C, 0xF3, 0x68, 0x16, 0xFB,
  0x78, 0x15, 0xF3, 0x70, 0xA0, 0xC7, 0x81, 0x2F, 0x45, 0x82, 0x24, 0xDB, 0x68, 0x29, 0xEA, 0x16,
  // "þ" (U+00FE)
  0x49, 0x06, 0x68, 0x13, 0xF2, 0x60, 0x70, 0xE7, 0x0A, 0x0B, 0x78, 0x4D, 0x88, 0xEC, 0x22, 0x85,
  0x1F, 0xD8, 0x5E, 0x92, 0x81, 0x4F, 0x92, 0x0A, 0x0C, 0x28, 0x18, 0xF1, 0x20, 0xA0, 0xC2, 0x00,
  0xB3, 0x0C, 0x0A, 0x20, 0xE0, 0x73, 0x98, 0x37, 0x02, 0xF5, 0x28, 0x55, 0xF3, 0x05, 0xF5, 0x20,
  0xC0, 0xB2, 0x85, 0x8E, 0xC4, 0xAF, 0x32, 0x84, 0xCA, 0x7E, 0xD4, 0x30, 0xE0, 0x66, 0x81, 0x3F,
  0x36, 0x06, 0x97, 0x09, 0x0C, 0x70,
  // "ÿ" (U+00FF)
  0x48, 0x37, 0xC0, 0x9A, 0x58, 0x21, 0x10, 0x17, 0x71, 0x0E, 0x08, 0x28, 0x11, 0xE7, 0x30, 0xD0,
  0x82, 0x81, 0x7E, 0x13, 0x0C, 0x09, 0x20, 0xD0, 0x84, 0x84, 0xBA, 0x05, 0xF1, 0x48, 0x3A, 0xA0,
  0xC9, 0x58, 0x39, 0xB4, 0xF2, 0x58, 0x28, 0xBA, 0xA6, 0x82, 0x7C, 0xF3, 0x68, 0x16, 0xFB, 0x78,
  0x15, 0xF3, 0x70, 0xA0, 0xC7, 0x81, 0x2F, 0x45, 0x82, 0x24, 0xDB, 0x68, 0x29, 0xEA, 0x16,
  // "Ā" (U+0100)
  0x50, 0xDB, 0x09, 0x58, 0x00, 0x30, 0x15, 0x81, 0x7F, 0x87, 0x81, 0xEF, 0x96, 0x82, 0x6E, 0xB9,
  0x68, 0x2D, 0x9A, 0xA5, 0x83, 0x4F, 0x3A, 0xA5, 0x83, 0xBC, 0x0A, 0xB4, 0x84, 0x3F, 0x60, 0x9C,
  0x48, 0x4A, 0xF2, 0x1A, 0xC3, 0x01, 0xD0, 0xD3, 0x85, 0x8F, 0x54, 0x4B, 0xD3, 0x0E, 0x0B, 0x30,
  0x80, 0xE2, 0x81, 0x7F, 0x33, 0x08, 0x92, 0x0D, 0x0B, 0x40, 0x79, 0x20,
  // "ā" (U+0101)
  0x30, 0xDB, 0x09, 0x48, 0x00, 0x30, 0x13, 0x85, 0x1A, 0xEC, 0x2F, 0x22, 0x84, 0xBD, 0x58, 0xDE,
  0x28, 0x15, 0xF3, 0x20, 0xE0, 0xB2, 0x0C, 0x0B, 0x39, 0x83, 0x80, 0x1F, 0x62, 0x85, 0x1F, 0x50,
  0x4F, 0x32, 0x85, 0x5F, 0x20, 0x5F, 0x12, 0x0A, 0x0E, 0x28, 0x56, 0xF1, 0x03, 0xFB, 0x28, 0x53,
  0xF8, 0x5C, 0xD7, 0x38, 0x48, 0xEC, 0x2D, 0x42,
  // "Ă" (U+0102)
  0x40, 0x02, 0x20, 0x34, 0x83, 0x7A, 0x17, 0xA4, 0x83, 0x2E, 0xFD, 0x26, 0x02, 0x78, 0x17, 0xF8,
  0x68, 0x1E, 0xF9, 0x58, 0x26, 0xEB, 0x95, 0x82, 0xD9, 0xAA, 0x48, 0x34, 0xF3, 0xAA, 0x48, 0x3B,
  0xC0, 0xAB, 0x38, 0x43, 0xF6, 0x09, 0xC3, 0x84, 0xAF, 0x21, 0xAC, 0x20, 0x1D, 0x0D, 0x28, 0x58,
  0xF5, 0x44, 0xBD, 0x20, 0xE0, 0xB3, 0x84, 0x8E, 0x07, 0xF3, 0x38, 0x38, 0xF0, 0xDB, 0x40, 0x79,
  0x10,
  // "ă" (U+0103)
  0x30, 0x02, 0x20, 0x34, 0x83, 0x7A, 0x17, 0xA4, 0x83, 0x2E, 0xFD, 0x26, 0x02, 0x58, 0x51, 0xAE,
  0xC2, 0xF2, 0x28, 0x4B, 0xD5, 0x8D, 0xE2, 0x81, 0x5F, 0x32, 0x0E, 0x0B, 0x20, 0xC0, 0xB3, 0x98,
  0x38, 0x01, 0xF6, 0x28, 0x51, 0xF5, 0x04, 0xF3, 0x28, 0x55, 0xF2, 0x05, 0xF1, 0x20, 0xA0, 0xE2,
  0x85, 0x6F, 0x10, 0x3F, 0xB2, 0x85, 0x3F, 0x85, 0xCD, 0x73, 0x84, 0x8E, 0xC2, 0xD4, 0x20,
  // "Ą" (U+0104)
  0x58, 0x17, 0xF8, 0x58, 0x1E, 0xF9, 0x48, 0x26, 0xEB, 0x94, 0x82, 0xD9, 0xAA, 0x38, 0x34, 0xF3,
  0xAA, 0x38, 0x3B, 0xC0, 0xAB, 0x28, 0x43, 0xF6, 0x09, 0xC2, 0x86, 0xAF, 0x21, 0xAC, 0x01, 0xD8,
  0x92, 0xD0, 0x8F, 0x54, 0x4B, 0xD0, 0xEB, 0x38, 0x38, 0xE7, 0xF3, 0x38, 0x28, 0xFD, 0xB4, 0x07,
  0x96, 0x05, 0x06, 0x50, 0x50, 0xB6, 0x0B, 0x09, 0x68, 0x19, 0xF9, 0x60, 0x20, 0x10,
  // "ą" (U+0105)
  0x28, 0x51, 0xAE, 0xC2, 0xF2, 0x28, 0x4B, 0xD5, 0x8D, 0xE2, 0x81, 0x5F, 0x32, 0x0E, 0x0B, 0x20,
  0xC0, 0xB3, 0x98, 0x38, 0x01, 0xF6, 0x28, 0x51, 0xF5, 0x04, 0xF3, 0x28, 0x55, 0xF2, 0x05, 0xF1,
  0x20, 0xA0, 0xE2, 0x85, 0x6F, 0x10, 0x3F, 0xB2, 0x85, 0x3F, 0x85, 0xCD, 0x73, 0x84, 0x8E, 0xC2,
  0xD4, 0x60, 0x50, 0x66, 0x05, 0x0B, 0x70, 0xB0, 0x97, 0x81, 0x9F, 0x97, 0x02, 0x01, 0x30,
  // "Ć" (U+0106)
  0x68, 0x14, 0xF7, 0x58, 0x11, 0xD8, 0x60, 0xA0, 0x87, 0x71, 0x83, 0x5C, 0xEE, 0xA3, 0x84, 0x8F,
  0x94, 0x69, 0x28, 0x14, 0xF6, 0x60, 0xD0, 0xB6, 0x81, 0x5F, 0x46, 0x0A, 0x0E, 0x70, 0xE0, 0xA7,
  0x90, 0x76, 0x81, 0x1F, 0x66, 0x81, 0x1F, 0x77, 0x0E, 0x0B, 0x78, 0x47, 0xF9, 0x46, 0x54, 0x83,
  0x8E, 0xFD, 0x62,
  // "ć" (U+0107)
  0x58, 0x14, 0xF7, 0x48, 0x11, 0xD8, 0x50, 0xA0, 0x87, 0x68, 0x29, 0xEE, 0x83, 0x83, 0xBD, 0x55,
  0x42, 0x81, 0x6F, 0x25, 0x0D, 0x0A, 0x58, 0x12, 0xF5, 0x58, 0x14, 0xF2, 0x58, 0x16, 0xF1, 0x58,
  0x15, 0xF2, 0x58, 0x41, 0xFB, 0x47, 0x23, 0x83, 0x5D, 0xEC, 0x22,
  // "Ĉ" (U+0108)
  0x58, 0x12, 0xEC, 0x68, 0x2C, 0x9F, 0x24, 0x83, 0xA7, 0x07, 0x97, 0x68, 0x35, 0xCE, 0xEA, 0x38,
  0x48, 0xF9, 0x46, 0x92, 0x81, 0x4F, 0x66, 0x0D, 0x0B, 0x68, 0x15, 0xF4, 0x60, 0xA0, 0xE7, 0x0E,
  0x0A, 0x79, 0x07, 0x68, 0x11, 0xF6, 0x68, 0x11, 0xF7, 0x70, 0xE0, 0xB7, 0x84, 0x7F, 0x94, 0x65,
  0x48, 0x38, 0xEF, 0xD6, 0x20,
  // "ĉ" (U+0109)
  0x38, 0x12, 0xEC, 0x48, 0x2C, 0x9F, 0x22, 0x83, 0xA7, 0x07, 0x97, 0x38, 0x29, 0xEE, 0x82, 0x87,
  0xBD, 0x55, 0x40, 0x6F, 0x24, 0x0D, 0x0A, 0x48, 0x12, 0xF5, 0x48, 0x14, 0xF2, 0x48, 0x16, 0xF1,
  0x48, 0x15, 0xF2, 0x48, 0x41, 0xFB, 0x47, 0x22, 0x83, 0x5D, 0xEC, 0x21,
  // "Ċ" (U+010A)
  0x60, 0x70, 0xE7, 0x08, 0x0B, 0x77, 0x83, 0x5C, 0xEE, 0xA3, 0x84, 0x8F, 0x94, 0x69, 0x28, 0x14,
  0xF6, 0x60, 0xD0, 0xB6, 0x81, 0x5F, 0x46, 0x0A, 0x0E, 0x70, 0xE0, 0xA7, 0x90, 0x76, 0x81, 0x1F,
  0x66, 0x81, 0x1F, 0x77, 0x0E, 0x0B, 0x78, 0x47, 0xF9, 0x46, 0x54, 0x83, 0x8E, 0xFD, 0x62,
  // "ċ" (U+010B)
  0x40, 0x70, 0xE5, 0x08, 0x0B, 0x74, 0x82, 0x9E, 0xE8, 0x28, 0x7B, 0xD5, 0x54, 0x06, 0xF2, 0x40,
  0xD0, 0xA4, 0x81, 0x2F, 0x54, 0x81, 0x4F, 0x24, 0x81, 0x6F, 0x14, 0x81, 0x5F, 0x24, 0x84, 0x1F,
  0xB4, 0x72, 0x28, 0x35, 0xDE, 0xC2, 0x10,
  // "Č" (U+010C)
  0x48, 0x43, 0xC0, 0x3C, 0x15, 0x82, 0xC9, 0xE3, 0x68, 0x16, 0xF6, 0x77, 0x28, 0x35, 0xCE, 0xEA,
  0x48, 0x48, 0xF9, 0x46, 0x93, 0x81, 0x4F, 0x67, 0x0D, 0x0B, 0x78, 0x15, 0xF4, 0x70, 0xA0, 0xE7,
  0x10, 0xE0, 0xA7, 0x19, 0x07, 0x78, 0x11, 0xF6, 0x78, 0x11, 0xF7, 0x71, 0x0E, 0x0B, 0x71, 0x84,
  0x7F, 0x94, 0x65, 0x58, 0x38, 0xEF, 0xD6, 0x30,
  // "č" (U+010D)
  0x38, 0x43, 0xC0, 0x3C, 0x14, 0x82, 0xC9, 0xE3, 0x58, 0x16, 0xF6, 0x77, 0x82, 0x9E, 0xE8, 0x48,
  0x3B, 0xD5, 0x54, 0x38, 0x16, 0xF2, 0x60, 0xD0, 0xA6, 0x81, 0x2F, 0x56, 0x81, 0x4F, 0x26, 0x81,
  0x6F, 0x16, 0x81, 0x5F, 0x26, 0x84, 0x1F, 0xB4, 0x72, 0x48, 0x35, 0xDE, 0xC2, 0x30,
  // "Ď" (U+010E)
  0x48, 0x43, 0xC0, 0x3C, 0x15, 0x82, 0xC9, 0xE3, 0x68, 0x16, 0xF6, 0x77, 0x02, 0xB0, 0xD0, 0x64,
  0x85, 0x5F, 0x44, 0xAF, 0x63, 0x09, 0x0D, 0x30, 0xC0, 0xD3, 0x0C, 0x0A, 0x30, 0x89, 0x39, 0x07,
  0x38, 0x57, 0xF1, 0x03, 0xF4, 0x30, 0x89, 0x28, 0x16, 0xF1, 0x30, 0xA0, 0xD2, 0x09, 0x0D, 0x40,
  0xE0, 0xA2, 0x0D, 0x0A, 0x38, 0x14, 0xF5, 0x29, 0x06, 0x30, 0xB0, 0xD2, 0x81, 0x4F, 0x32, 0x81,
  0x7F, 0x32, 0x85, 0x7F, 0x45, 0xAF, 0x73, 0x0A, 0xA8, 0x1E, 0xA3, 0x40,
  // "ď" (U+010F)
  0x78, 0x36, 0xF4, 0xF3, 0x78, 0x29, 0xC9, 0xA7, 0x18, 0x2C, 0x9D, 0x17, 0x19, 0x05, 0x58, 0x51,
  0xAE, 0xC4, 0xF2, 0x58, 0x4C, 0xD5, 0x7D, 0xE5, 0x81, 0x5F, 0x32, 0x0E, 0x0B, 0x50, 0xC0, 0xB3,
  0x0E, 0x08, 0x48, 0x11, 0xF6, 0x28, 0x11, 0xF5, 0x48, 0x14, 0xF3, 0x28, 0x15, 0xF2, 0x48, 0x15,
  0xF1, 0x20, 0xB0, 0xE5, 0x85, 0x6F, 0x10, 0x3F, 0xB5, 0x85, 0x3F, 0x95, 0xCE, 0x76, 0x84, 0x8E,
  0xC2, 0xE4, 0x50,
  // "Đ" (U+0110)
  0x20, 0x2B, 0x0D, 0x06, 0x48, 0x55, 0xF4, 0x4A, 0xF6, 0x30, 0x80, 0xE3, 0x0C, 0x0D, 0x30, 0x0B,
  0x30, 0x89, 0x30, 0xE0, 0x73, 0x85, 0x7F, 0x10, 0x3F, 0x53, 0x82, 0x9F, 0x05, 0xC2, 0x86, 0xBD,
  0x01, 0xAD, 0x33, 0x20, 0xE0, 0xA2, 0x0C, 0x0A, 0x38, 0x14, 0xF5, 0x29, 0x07, 0x30, 0xC0, 0xD2,
  0x81, 0x3F, 0x32, 0x81, 0x7F, 0x52, 0x85, 0x7F, 0x45, 0xAF, 0x73, 0x0A, 0xA8, 0x1E, 0xA3, 0x40,
  // "đ" (U+0111)
  0x70, 0x69, 0x71, 0x08, 0x0D, 0x60, 0xDB, 0x0C, 0x58, 0x32, 0x2F, 0x81, 0x28, 0x51, 0xAE, 0xB4,
  0xF3, 0x38, 0x3C, 0xD5, 0x7D, 0x93, 0x81, 0x5F, 0x32, 0x0E, 0x0C, 0x30, 0xC0, 0xB3, 0x0E, 0x09,
  0x28, 0x11, 0xF6, 0x28, 0x11, 0xF5, 0x28, 0x14, 0xF3, 0x28, 0x15, 0xF2, 0x28, 0x15, 0xF1, 0x20,
  0xB0, 0xE3, 0x85, 0x6F, 0x10, 0x3F, 0xB3, 0x85, 0x3F, 0x95, 0xCE, 0x84, 0x84, 0x8E, 0xC2, 0xE4,
  0x30,
  // "Ē" (U+0112)
  0x30, 0xDB, 0x09, 0x38, 0x00, 0x30, 0x12, 0x02, 0xD2, 0x81, 0x5F, 0x40, 0xF3, 0x20, 0x90, 0xE6,
  0x0C, 0x0B, 0x69, 0x08, 0x58, 0x13, 0xF6, 0x50, 0x6C, 0x09, 0x28, 0x49, 0xE3, 0x33, 0x12, 0x0D,
  0x0A, 0x69, 0x07, 0x58, 0x14, 0xF4, 0x58, 0x47, 0xF4, 0x33, 0x22, 0x0A, 0xC0, 0x82,
  // "ē" (U+0113)
  0x30, 0xDB, 0x09, 0x38, 0x00, 0x30, 0x13, 0x82, 0x9E, 0xE6, 0x38, 0x2B, 0xC5, 0x99, 0x28, 0x36,
  0xE1, 0x06, 0x92, 0x86, 0xD8, 0x26, 0xE9, 0x02, 0xB0, 0xE0, 0x82, 0x82, 0x5F, 0x42, 0x40, 0x69,
  0x68, 0x15, 0xF2, 0x58, 0x41, 0xEB, 0x45, 0x83, 0x83, 0x4D, 0xFD, 0x62,
  // "Ĕ" (U+0114)
  0x30, 0x02, 0x20, 0x33, 0x83, 0x7A, 0x17, 0xA3, 0x83, 0x2E, 0xFD, 0x25, 0x02, 0x40, 0x2D, 0x28,
  0x15, 0xF4, 0x0F, 0x32, 0x09, 0x0E, 0x60, 0xC0, 0xB6, 0x90, 0x85, 0x81, 0x3F, 0x65, 0x06, 0xC0,
  0x92, 0x84, 0x9E, 0x33, 0x31, 0x20, 0xD0, 0xA6, 0x90, 0x75, 0x81, 0x4F, 0x45, 0x84, 0x7F, 0x43,
  0x32, 0x20, 0xAC, 0x08, 0x20,
  // "ĕ" (U+0115)
  0x30, 0x02, 0x20, 0x33, 0x83, 0x7A, 0x17, 0xA3, 0x83, 0x2E, 0xFD, 0x25, 0x02, 0x58, 0x29, 0xEE,
  0x63, 0x82, 0xBC, 0x59, 0x92, 0x83, 0x6E, 0x10, 0x69, 0x28, 0x6D, 0x82, 0x6E, 0x90, 0x2B, 0x0E,
  0x08, 0x28, 0x25, 0xF4, 0x24, 0x06, 0x96, 0x81, 0x5F, 0x25, 0x84, 0x1E, 0xB4, 0x58, 0x38, 0x34,
  0xDF, 0xD6, 0x20,
  // "Ė" (U+0116)
  0x50, 0x70, 0xE6, 0x08, 0x0B, 0x74, 0x02, 0xD2, 0x81, 0x5F, 0x40, 0xF3, 0x20, 0x90, 0xE6, 0x0C,
  0x0B, 0x69, 0x08, 0x58, 0x13, 0xF6, 0x50, 0x6C, 0x09, 0x28, 0x49, 0xE3, 0x33, 0x12, 0x0D, 0x0A,
  0x69, 0x07, 0x58, 0x14, 0xF4, 0x58, 0x47, 0xF4, 0x33, 0x22, 0x0A, 0xC0, 0x82,
  // "ė" (U+0117)
  0x40, 0x70, 0xE5, 0x08, 0x0B, 0x74, 0x82, 0x9E, 0xE6, 0x28, 0xA2, 0xBC, 0x59, 0xF0, 0x6E, 0x10,
  0x6F, 0x0D, 0x82, 0x6E, 0x92, 0xB8, 0x5E, 0x80, 0x5F, 0x42, 0x30, 0x69, 0x58, 0x15, 0xF2, 0x48,
  0x41, 0xEB, 0x45, 0x82, 0x83, 0x4D, 0xFD, 0x61,
  // "Ę" (U+0118)
  0x20, 0x2D, 0x28, 0x15, 0xF4, 0x0F, 0x32, 0x09, 0x0E, 0x60, 0xC0, 0xB6, 0x90, 0x85, 0x81, 0x3F,
  0x65, 0x06, 0xC0, 0x92, 0x84, 0x9E, 0x33, 0x31, 0x20, 0xD0, 0xA6, 0x90, 0x75, 0x81, 0x4F, 0x45,
  0x84, 0x7F, 0x43, 0x32, 0x20, 0xAC, 0x08, 0x50, 0x50, 0x65, 0x05, 0x0B, 0x60, 0xB0, 0x96, 0x81,
  0x9F, 0x96, 0x02, 0x01, 0x30,
  // "ę" (U+0119)
  0x38, 0x29, 0xED, 0x53, 0x83, 0xBD, 0x5A, 0xE2, 0x89, 0x06, 0xF3, 0x05, 0xF1, 0x0D, 0xC2, 0x89,
  0x28, 0xE0, 0x2F, 0x82, 0x8F, 0x60, 0x5B, 0x0D, 0x06, 0x28, 0x26, 0xF4, 0x14, 0x81, 0x5F, 0x15,
  0x84, 0x1E, 0xA4, 0x57, 0x30, 0x40, 0xDA, 0x07, 0x50, 0x90, 0x85, 0x04, 0x0E, 0x68, 0x17, 0xE4,
  0x58, 0x13, 0xED, 0x30,
  // "Ě" (U+011A)
  0x38, 0x43, 0xC0, 0x3C, 0x14, 0x82, 0xC9, 0xE3, 0x58, 0x16, 0xF6, 0x76, 0x02, 0xD3, 0x81, 0x5F,
  0x40, 0xF3, 0x30, 0x90, 0xE7, 0x0C, 0x0B, 0x79, 0x08, 0x68, 0x13, 0xF6, 0x60, 0x6C, 0x09, 0x38,
  0x49, 0xE3, 0x33, 0x13, 0x0D, 0x0A, 0x79, 0x07, 0x68, 0x14, 0xF4, 0x68, 0x47, 0xF4, 0x33, 0x23,
  0x0A, 0xC0, 0x83,
  // "ě" (U+011B)
  0x38, 0x43, 0xC0, 0x3C, 0x14, 0x82, 0xC9, 0xE3, 0x58, 0x16, 0xF6, 0x77, 0x82, 0x9E, 0xE6, 0x48,
  0x2B, 0xC5, 0x99, 0x38, 0x36, 0xE1, 0x06, 0x93, 0x84, 0xD8, 0x26, 0xE9, 0x20, 0x2B, 0x0E, 0x08,
  0x38, 0x25, 0xF4, 0x25, 0x06, 0x97, 0x81, 0x5F, 0x26, 0x84, 0x1E, 0xB4, 0x58, 0x48, 0x34, 0xDF,
  0xD6, 0x30,
  // "Ĝ" (U+011C)
  0x68, 0x12, 0xEC, 0x78, 0x2C, 0x9F, 0x25, 0x83, 0xA7, 0x07, 0x97, 0x78, 0x44, 0xBE, 0xEC, 0x73,
  0x85, 0x7F, 0xA5, 0x59, 0x92, 0x81, 0x5F, 0x77, 0x0D, 0x0B, 0x78, 0x16, 0xF4, 0x70, 0xB0, 0xD7,
  0x10, 0xE0, 0x92, 0x05, 0xB1, 0x81, 0x1F, 0x72, 0x86, 0x13, 0xBC, 0x02, 0xF6, 0x40, 0xD0, 0x92,
  0x90, 0x73, 0x81, 0x1F, 0x62, 0x0D, 0x0B, 0x38, 0x14, 0xF2, 0x28, 0x56, 0xFA, 0x44, 0xAE, 0x48,
  0x46, 0xDF, 0xEC, 0x62,
  // "ĝ" (U+011D)
  0x58, 0x12, 0xEC, 0x78, 0x2C, 0x9F, 0x25, 0x83, 0xA7, 0x07, 0x97, 0x78, 0x51, 0xAE, 0xC3, 0xF2,
  0x38, 0x4B, 0xE5, 0x8D, 0xE3, 0x81, 0x5F, 0x42, 0x0E, 0x0B, 0x30, 0xC0, 0xB3, 0x90, 0x82, 0x81,
  0x1F, 0x62, 0x81, 0x2F, 0x42, 0x81, 0x4F, 0x32, 0x81, 0x5F, 0x12, 0x81, 0x5F, 0x12, 0x0B, 0x0D,
  0x38, 0x56, 0xF1, 0x04, 0xFA, 0x38, 0x53, 0xF9, 0x5C, 0xF7, 0x48, 0x48, 0xEC, 0x5F, 0x47, 0x06,
  0x97, 0x10, 0xC0, 0xB3, 0x85, 0x19, 0x54, 0xAF, 0x33, 0x84, 0x1A, 0xEE, 0xB3, 0x40,
  // "Ğ" (U+011E)
  0x50, 0x02, 0x20, 0x35, 0x83, 0x7A, 0x17, 0xA5, 0x83, 0x2E, 0xFD, 0x27, 0x02, 0x68, 0x44, 0xBE,
  0xEC, 0x73, 0x85, 0x7F, 0xA5, 0x59, 0x92, 0x81, 0x5F, 0x77, 0x0D, 0x0B, 0x78, 0x16, 0xF4, 0x70,
  0xB0, 0xD7, 0x10, 0xE0, 0x92, 0x05, 0xB1, 0x81, 0x1F, 0x72, 0x86, 0x13, 0xBC, 0x02, 0xF6, 0x40,
  0xD0, 0x92, 0x90, 0x73, 0x81, 0x1F, 0x62, 0x0D, 0x0B, 0x38, 0x14, 0xF2, 0x28, 0x56, 0xFA, 0x44,
  0xAE, 0x48, 0x46, 0xDF, 0xEC, 0x62,
  // "ğ" (U+011F)
  0x40, 0x02, 0x20, 0x35, 0x83, 0x7A, 0x17, 0xA5, 0x83, 0x2E, 0xFD, 0x27, 0x02, 0x68, 0x51, 0xAE,
  0xC3, 0xF2, 0x38, 0x4B, 0xE5, 0x8D, 0xE3, 0x81, 0x5F, 0x42, 0x0E, 0x0B, 0x30, 0xC0, 0xB3, 0x90,
  0x82, 0x81, 0x1F, 0x62, 0x81, 0x2F, 0x42, 0x81, 0x4F, 0x32, 0x81, 0x5F, 0x12, 0x81, 0x5F, 0x12,
  0x0B, 0x0D, 0x38, 0x56, 0xF1, 0x04, 0xFA, 0x38, 0x53, 0xF9, 0x5C, 0xF7, 0x48, 0x48, 0xEC, 0x5F,
  0x47, 0x06, 0x97, 0x10, 0xC0, 0xB3, 0x85, 0x19, 0x54, 0xAF, 0x33, 0x84, 0x1A, 0xEE, 0xB3, 0x40,
  // "Ġ" (U+0120)
  0x60, 0x70, 0xE7, 0x10, 0x80, 0xB7, 0x72, 0x84, 0x4B, 0xEE, 0xC7, 0x38, 0x57, 0xFA, 0x55, 0x99,
  0x28, 0x15, 0xF7, 0x70, 0xD0, 0xB7, 0x81, 0x6F, 0x47, 0x0B, 0x0D, 0x71, 0x0E, 0x09, 0x20, 0x5B,
  0x18, 0x11, 0xF7, 0x28, 0x61, 0x3B, 0xC0, 0x2F, 0x64, 0x0D, 0x09, 0x29, 0x07, 0x38, 0x11, 0xF6,
  0x20, 0xD0, 0xB3, 0x81, 0x4F, 0x22, 0x85, 0x6F, 0xA4, 0x4A, 0xE4, 0x84, 0x6D, 0xFE, 0xC6, 0x20,
  // "ġ" (U+0121)
  0x50, 0x70, 0xE7, 0x10, 0x80, 0xB7, 0x72, 0x85, 0x1A, 0xEC, 0x3F, 0x23, 0x84, 0xBE, 0x58, 0xDE,
  0x38, 0x15, 0xF4, 0x20, 0xE0, 0xB3, 0x0C, 0x0B, 0x39, 0x08, 0x28, 0x11, 0xF6, 0x28, 0x12, 0xF4,
  0x28, 0x14, 0xF3, 0x28, 0x15, 0xF1, 0x28, 0x15, 0xF1, 0x20, 0xB0, 0xD3, 0x85, 0x6F, 0x10, 0x4F,
  0xA3, 0x85, 0x3F, 0x95, 0xCF, 0x74, 0x84, 0x8E, 0xC5, 0xF4, 0x70, 0x69, 0x71, 0x0C, 0x0B, 0x38,
  0x51, 0x95, 0x4A, 0xF3, 0x38, 0x41, 0xAE, 0xEB, 0x34,
  // "Ģ" (U+0122)
  0x48, 0x44, 0xBE, 0xEC, 0x73, 0x85, 0x7F, 0xA5, 0x59, 0x92, 0x81, 0x5F, 0x77, 0x0D, 0x0B, 0x78,
  0x16, 0xF4, 0x70, 0xB0, 0xD7, 0x10, 0xE0, 0x92, 0x05, 0xB1, 0x81, 0x1F, 0x72, 0x86, 0x13, 0xBC,
  0x02, 0xF6, 0x40, 0xD0, 0x92, 0x90, 0x73, 0x81, 0x1F, 0x62, 0x0D, 0x0B, 0x38, 0x14, 0xF2, 0x28,
  0x56, 0xFA, 0x44, 0xAE, 0x48, 0x46, 0xDF, 0xEC, 0x67, 0x71, 0x09, 0x0D, 0x78, 0x11, 0xE4, 0x70,
  0x08, 0x60,
  // "ģ" (U+0123)
  0x70, 0xC0, 0x37, 0x08, 0x0B, 0x78, 0x11, 0xE5, 0x77, 0x18, 0x51, 0xAE, 0xC3, 0xF2, 0x38, 0x4B,
  0xE5, 0x8D, 0xE3, 0x81, 0x5F, 0x42, 0x0E, 0x0B, 0x30, 0xC0, 0xB3, 0x90, 0x82, 0x81, 0x1F, 0x62,
  0x81, 0x2F, 0x42, 0x81, 0x4F, 0x32, 0x81, 0x5F, 0x12, 0x81, 0x5F, 0x12, 0x0B, 0x0D, 0x38, 0x56,
  0xF1, 0x04, 0xFA, 0x38, 0x53, 0xF9, 0x5C, 0xF7, 0x48, 0x48, 0xEC, 0x5F, 0x47, 0x06, 0x97, 0x10,
  0xC0, 0xB3, 0x85, 0x19, 0x54, 0xAF, 0x33, 0x84, 0x1A, 0xEE, 0xB3, 0x40,
  // "Ĥ" (U+0124)
  0x58, 0x12, 0xEC, 0x78, 0x2C, 0x9F, 0x25, 0x83, 0xA7, 0x07, 0x97, 0x68, 0x12, 0xF5, 0x30, 0x80,
  0xE2, 0x81, 0x5F, 0x23, 0x00, 0xB2, 0x08, 0x0E, 0x40, 0xE0, 0x82, 0x0C, 0x0B, 0x38, 0x11, 0xF5,
  0x29, 0x08, 0x38, 0x92, 0x4F, 0x10, 0x3F, 0x61, 0x11, 0x8E, 0x20, 0x6E, 0x0A, 0x28, 0x69, 0xE4,
  0x44, 0x4F, 0x72, 0x0C, 0x0B, 0x38, 0x12, 0xF4, 0x29, 0x07, 0x38, 0x55, 0xF1, 0x03, 0xF4, 0x30,
  0x90, 0xD2, 0x07, 0x94, 0x0C, 0x09, 0x20, 0xA0, 0xC4, 0x90, 0x62,
  // "ĥ" (U+0125)
  0x28, 0x12, 0xEC, 0x58, 0x2C, 0x9F, 0x23, 0x83, 0xA7, 0x07, 0x97, 0x58, 0x11, 0xF6, 0x58, 0x14,
  0xF2, 0x50, 0x70, 0xE6, 0x0A, 0x0B, 0x68, 0xA0, 0xD8, 0x9E, 0xC2, 0x01, 0xFD, 0x75, 0xF8, 0x04,
  0xF7, 0x28, 0x4D, 0x90, 0x7F, 0x12, 0x98, 0x27, 0x0B, 0xB2, 0x84, 0x3F, 0x40, 0xE8, 0x28, 0x46,
  0xF0, 0x2F, 0x52, 0x84, 0x9D, 0x05, 0xF1, 0x28, 0x3C, 0x90, 0x8E, 0x39, 0x82, 0x60, 0xBB, 0x28,
  0x13, 0xF3, 0x10,
  // "Ħ" (U+0126)
  0x28, 0x12, 0xF4, 0x30, 0x80, 0xE3, 0x81, 0x6F, 0x13, 0x0C, 0x0B, 0x20, 0xEF, 0x98, 0x92, 0xC0,
  0x2D, 0xA2, 0x22, 0x5F, 0x61, 0x29, 0x07, 0x38, 0x15, 0xF1, 0x28, 0x13, 0xF5, 0x30, 0x80, 0xD3,
  0x06, 0xE0, 0xA3, 0x86, 0xAE, 0x33, 0x33, 0xF7, 0x30, 0xD0, 0xA3, 0x81, 0x2F, 0x32, 0x81, 0x1F,
  0x73, 0x06, 0x93, 0x81, 0x4F, 0x33, 0x09, 0x0D, 0x30, 0x79, 0x40, 0xD0, 0x93, 0x0A, 0x0C, 0x38,
  0x11, 0xF6, 0x30,
  // "ħ" (U+0127)
  0x39, 0x06, 0x58, 0x13, 0xF3, 0x40, 0x8C, 0x01, 0x28, 0x31, 0xAC, 0x22, 0x48, 0x4C, 0x89, 0xEC,
  0x12, 0x98, 0x7D, 0x75, 0xF8, 0x03, 0xF7, 0x28, 0x3D, 0x80, 0x7E, 0x39, 0x82, 0x60, 0xAB, 0x28,
  0x43, 0xF3, 0x0D, 0x72, 0x84, 0x6F, 0x01, 0xF4, 0x28, 0x49, 0xD0, 0x5F, 0x12, 0x83, 0xC9, 0x08,
  0xE3, 0x98, 0x26, 0x0B, 0xB2, 0x81, 0x3F, 0x31,
  // "Ĩ" (U+0128)
  0x38, 0x43, 0xED, 0x36, 0x83, 0x84, 0xB6, 0x8F, 0xE2, 0x30, 0x32, 0x00, 0x13, 0x01, 0xB0, 0xE0,
  0x14, 0x81, 0x1F, 0x86, 0x81, 0x2F, 0x56, 0x81, 0x5F, 0x16, 0x08, 0x0E, 0x70, 0xC0, 0xA7, 0x90,
  0x76, 0x81, 0x3F, 0x46, 0x81, 0x6F, 0x16, 0x09, 0x0D, 0x70, 0xD0, 0xA6, 0x81, 0x1F, 0x75, 0x09,
  0xB0, 0x84,
  // "ĩ" (U+0129)
  0x89, 0x33, 0xED, 0x36, 0x8B, 0x68, 0xFE, 0x23, 0x20, 0x01, 0x30, 0xD0, 0x83, 0x81, 0x1F, 0x53,
  0x81, 0x4F, 0x13, 0x08, 0x0E, 0x40, 0x0B, 0x40, 0xE0, 0x73, 0x81, 0x2F, 0x43, 0x81, 0x5F, 0x13,
  0x08, 0x0D, 0x40, 0xB0, 0xA4,
  // "Ī" (U+012A)
  0x30, 0xDB, 0x09, 0x38, 0x00, 0x30, 0x12, 0x01, 0xB0, 0xE0, 0x13, 0x81, 0x1F, 0x85, 0x81, 0x2F,
  0x55, 0x81, 0x5F, 0x15, 0x08, 0x0E, 0x60, 0xC0, 0xA6, 0x90, 0x75, 0x81, 0x3F, 0x45, 0x81, 0x6F,
  0x15, 0x09, 0x0D, 0x60, 0xD0, 0xA5, 0x81, 0x1F, 0x74, 0x09, 0xB0, 0x83,
  // "ī" (U+012B)
  0x10, 0xDB, 0x85, 0x90, 0x33, 0x33, 0x12, 0x0D, 0x08, 0x38, 0x11, 0xF5, 0x38, 0x14, 0xF1, 0x30,
  0x80, 0xE4, 0x00, 0xB4, 0x0E, 0x07, 0x38, 0x12, 0xF4, 0x38, 0x15, 0xF1, 0x30, 0x80, 0xD4, 0x0B,
  0x0A, 0x40,
  // "Ĭ" (U+012C)
  0x30, 0x02, 0x20, 0x33, 0x83, 0x7A, 0x17, 0xA3, 0x83, 0x2E, 0xFD, 0x25, 0x02, 0x40, 0x1B, 0x0E,
  0x01, 0x38, 0x11, 0xF8, 0x58, 0x12, 0xF5, 0x58, 0x15, 0xF1, 0x50, 0x80, 0xE6, 0x0C, 0x0A, 0x69,
  0x07, 0x58, 0x13, 0xF4, 0x58, 0x16, 0xF1, 0x50, 0x90, 0xD6, 0x0D, 0x0A, 0x58, 0x11, 0xF7, 0x40,
  0x9B, 0x08, 0x30,
  // "ĭ" (U+012D)
  0x10, 0x02, 0x28, 0x93, 0x30, 0x7A, 0x17, 0xA0, 0x2E, 0xFD, 0x23, 0x02, 0x40, 0xD0, 0x83, 0x81,
  0x1F, 0x53, 0x81, 0x4F, 0x13, 0x08, 0x0E, 0x40, 0x0B, 0x40, 0xE0, 0x73, 0x81, 0x2F, 0x43, 0x81,
  0x5F, 0x13, 0x08, 0x0D, 0x40, 0xB0, 0xA4,
  // "Į" (U+012E)
  0x20, 0x1B, 0x0E, 0x01, 0x38, 0x11, 0xF8, 0x58, 0x12, 0xF5, 0x58, 0x15, 0xF1, 0x50, 0x80, 0xE6,
  0x0C, 0x0A, 0x69, 0x07, 0x58, 0x13, 0xF4, 0x58, 0x16, 0xF1, 0x50, 0x90, 0xD6, 0x0D, 0x0A, 0x58,
  0x11, 0xF7, 0x40, 0x9B, 0x08, 0x50, 0x50, 0x65, 0x05, 0x0B, 0x60, 0xB0, 0x96, 0x81, 0x9F, 0x96,
  0x02, 0x01, 0x40,
  // "į" (U+012F)
  0x38, 0x12, 0xE3, 0x38, 0x14, 0xE2, 0x77, 0x10, 0xD0, 0x83, 0x81, 0x1F, 0x53, 0x81, 0x4F, 0x13,
  0x08, 0x0E, 0x40, 0x0B, 0x40, 0xE0, 0x73, 0x81, 0x2F, 0x43, 0x81, 0x5F, 0x13, 0x08, 0x0D, 0x40,
  0xB0, 0xA4, 0x05, 0x06, 0x30, 0x50, 0xB4, 0x0B, 0x09, 0x48, 0x19, 0xF9, 0x40, 0x20, 0x13,
  // "İ" (U+0130)
  0x50, 0x70, 0xE6, 0x08, 0x0B, 0x74, 0x01, 0xB0, 0xE0, 0x13, 0x81, 0x1F, 0x85, 0x81, 0x2F, 0x55,
  0x81, 0x5F, 0x15, 0x08, 0x0E, 0x60, 0xC0, 0xA6, 0x90, 0x75, 0x81, 0x3F, 0x45, 0x81, 0x6F, 0x15,
  0x09, 0x0D, 0x60, 0xD0, 0xA5, 0x81, 0x1F, 0x74, 0x09, 0xB0, 0x83,
  // "ı" (U+0131)
  0x28, 0x93, 0xD8, 0x01, 0xF5, 0x04, 0xF1, 0x08, 0xE2, 0x00, 0xB2, 0x89, 0x3E, 0x70, 0x2F, 0x40,
  0x5F, 0x10, 0x8D, 0x20, 0xB0, 0xA2,
  // "Ĳ" (U+0132)
  0x20, 0x1B, 0x83, 0xE1, 0x2F, 0x53, 0x81, 0x1F, 0x82, 0x81, 0x5F, 0x23, 0x81, 0x2F, 0x52, 0x09,
  0x0E, 0x48, 0x15, 0xF1, 0x20, 0xC0, 0xA4, 0x08, 0x0E, 0x39, 0x07, 0x40, 0xC0, 0xA2, 0x81, 0x3F,
  0x44, 0x90, 0x72, 0x81, 0x6F, 0x13, 0x81, 0x3F, 0x42, 0x09, 0x0D, 0x48, 0x16, 0xF1, 0x20, 0xD0,
  0x94, 0x09, 0x0D, 0x39, 0x06, 0x40, 0xD0, 0xA2, 0x81, 0x4F, 0x33, 0x81, 0x1F, 0x72, 0x07, 0x93,
  0x09, 0xB8, 0x28, 0x0A, 0xC7, 0x20, 0xE0, 0x86, 0x83, 0x11, 0x8F, 0x26, 0x09, 0xA0, 0x67, 0x01,
  0x03, 0x60,
  // "ĳ" (U+0133)
  0x28, 0x52, 0xE3, 0x02, 0xE3, 0x28, 0x54, 0xE2, 0x04, 0xE2, 0x77, 0x60, 0xD0, 0x82, 0x0E, 0x08,
  0x28, 0x51, 0xF5, 0x01, 0xF5, 0x28, 0x54, 0xF1, 0x05, 0xF1, 0x20, 0x80, 0xE2, 0x08, 0x0D, 0x30,
  0x0B, 0x20, 0xB0, 0xA3, 0x0E, 0x07, 0x20, 0xE0, 0x72, 0x85, 0x2F, 0x40, 0x2F, 0x42, 0x83, 0x5F,
  0x10, 0x59, 0x30, 0x80, 0xD2, 0x09, 0x0D, 0x30, 0xB0, 0xA2, 0x0C, 0x09, 0x79, 0x06, 0x68, 0x14,
  0xF2, 0x48, 0x21, 0x4C, 0xC5, 0x82, 0x4E, 0xC3, 0x40,
  // "Ĵ" (U+0134)
  0x58, 0x12, 0xEC, 0x68, 0x2C, 0x9F, 0x24, 0x83, 0xA7, 0x07, 0x97, 0x78, 0x12, 0xF5, 0x68, 0x15,
  0xF2, 0x60, 0x90, 0xE7, 0x0C, 0x0A, 0x79, 0x07, 0x68, 0x13, 0xF4, 0x68, 0x16, 0xF1, 0x60, 0x90,
  0xD7, 0x0D, 0x09, 0x79, 0x06, 0x68, 0x14, 0xF3, 0x60, 0x79, 0x70, 0xA0, 0xC7, 0x0E, 0x08, 0x48,
  0x31, 0x18, 0xF2, 0x40, 0x9A, 0x06, 0x50, 0x10, 0x37,
  // "ĵ" (U+0135)
  0x58, 0x12, 0xEC, 0x68, 0x2C, 0x9F, 0x24, 0x83, 0xA7, 0x07, 0x97, 0x70, 0xE0, 0x86, 0x81, 0x1F,
  0x56, 0x81, 0x5F, 0x16, 0x08, 0x0D, 0x70, 0xB0, 0xA7, 0x0E, 0x07, 0x68, 0x12, 0xF4, 0x60, 0x59,
  0x70, 0x90, 0xD7, 0x0C, 0x09, 0x79, 0x06, 0x68, 0x14, 0xF2, 0x48, 0x21, 0x4C, 0xC5, 0x82, 0x4E,
  0xC3, 0x50,
  // "Ķ" (U+0136)
  0x28, 0x12, 0xF4, 0x28, 0x16, 0xF4, 0x28, 0x55, 0xF1, 0x03, 0xF7, 0x38, 0x49, 0xE0, 0x1D, 0xB4,
  0x84, 0xCA, 0x0B, 0xD1, 0x49, 0x82, 0x77, 0xF3, 0x48, 0x33, 0xF8, 0xF7, 0x58, 0x36, 0xFE, 0xF4,
  0x58, 0x39, 0xF6, 0xE8, 0x58, 0x3D, 0xA0, 0xBC, 0x59, 0x83, 0x60, 0x7F, 0x13, 0x85, 0x4F, 0x30,
  0x3F, 0x53, 0x07, 0x93, 0x0E, 0x0A, 0x30, 0xA0, 0xC3, 0x0A, 0x0E, 0x77, 0x10, 0x90, 0xD7, 0x81,
  0x1E, 0x47, 0x00, 0x87,
  // "ķ" (U+0137)
  0x39, 0x06, 0x58, 0x13, 0xF2, 0x50, 0x70, 0xE6, 0x0A, 0x0B, 0x68, 0x93, 0xD8, 0x02, 0xE8, 0x01,
  0xF5, 0x0C, 0xB2, 0x84, 0x4F, 0x29, 0xD1, 0x28, 0x37, 0xD6, 0xF3, 0x38, 0x2B, 0xDF, 0xB4, 0x81,
  0xEE, 0xB9, 0x38, 0x42, 0xF5, 0x3F, 0x42, 0x84, 0x5F, 0x10, 0xF7, 0x20, 0x80, 0xD2, 0x00, 0xB2,
  0x0B, 0x0A, 0x20, 0x79, 0x75, 0x09, 0x0D, 0x58, 0x11, 0xE4, 0x50, 0x08, 0x50,
  // "ĸ" (U+0138)
  0x28, 0x93, 0xD8, 0x02, 0xE8, 0x01, 0xF5, 0x0C, 0xB2, 0x84, 0x4F, 0x19, 0xD1, 0x28, 0x38, 0xD6,
  0xF3, 0x38, 0x2B, 0xDF, 0xB4, 0x81, 0xEE, 0xB9, 0x38, 0x42, 0xF5, 0x3F, 0x42, 0x84, 0x5F, 0x10,
  0xF7, 0x20, 0x80, 0xD2, 0x00, 0xB2, 0x0B, 0x0A, 0x20, 0x79, 0x20,
  // "Ĺ" (U+0139)
  0x58, 0x14, 0xF7, 0x48, 0x11, 0xD8, 0x50, 0xA0, 0x87, 0x58, 0x12, 0xF4, 0x58, 0x15, 0xF1, 0x50,
  0x90, 0xD6, 0x0C, 0x0A, 0x69, 0x07, 0x58, 0x13, 0xF4, 0x58, 0x16, 0xF1, 0x50, 0x90, 0xD6, 0x0D,
  0x09, 0x69, 0x06, 0x58, 0x14, 0xF3, 0x58, 0x47, 0xF5, 0x55, 0x32, 0x0A, 0xC0, 0x72,
  // "ĺ" (U+013A)
  0x48, 0x14, 0xF7, 0x38, 0x11, 0xD8, 0x40, 0xA0, 0x87, 0x59, 0x06, 0x48, 0x13, 0xF2, 0x40, 0x70,
  0xE5, 0x0A, 0x0B, 0x50, 0xD0, 0x84, 0x81, 0x1F, 0x54, 0x81, 0x4F, 0x24, 0x07, 0x0E, 0x50, 0x0B,
  0x50, 0xE0, 0x84, 0x81, 0x2F, 0x44, 0x81, 0x5F, 0x14, 0x08, 0x0D, 0x50, 0xB0, 0xA5,
  // "Ļ" (U+013B)
  0x28, 0x12, 0xF4, 0x38, 0x15, 0xF1, 0x30, 0x90, 0xD4, 0x0C, 0x0A, 0x49, 0x07, 0x38, 0x13, 0xF4,
  0x38, 0x16, 0xF1, 0x30, 0x90, 0xD4, 0x0D, 0x09, 0x49, 0x06, 0x38, 0x14, 0xF3, 0x38, 0x57, 0xF5,
  0x55, 0x3A, 0xC0, 0x77, 0x09, 0x0D, 0x38, 0x11, 0xE4, 0x30, 0x08, 0x40,
  // "ļ" (U+013C)
  0x49, 0x06, 0x38, 0x13, 0xF2, 0x30, 0x70, 0xE4, 0x0A, 0x0B, 0x40, 0xD0, 0x83, 0x81, 0x1F, 0x53,
  0x81, 0x4F, 0x23, 0x07, 0x0E, 0x40, 0x0B, 0x40, 0xE0, 0x83, 0x81, 0x2F, 0x43, 0x81, 0x5F, 0x13,
  0x08, 0x0D, 0x40, 0xB0, 0xA7, 0x30, 0x90, 0xD3, 0x81, 0x1E, 0x43, 0x00, 0x84,
  // "Ľ" (U+013D)
  0x28, 0x42, 0xF4, 0x3F, 0x32, 0x83, 0x5F, 0x19, 0xA3, 0x83, 0x9D, 0x0D, 0x13, 0x0C, 0x0A, 0x69,
  0x07, 0x58, 0x13, 0xF4, 0x58, 0x16, 0xF1, 0x50, 0x90, 0xD6, 0x0D, 0x09, 0x69, 0x06, 0x58, 0x14,
  0xF3, 0x58, 0x47, 0xF5, 0x55, 0x32, 0x0A, 0xC0, 0x72,
  // "ľ" (U+013E)
  0x39, 0x82, 0x63, 0xF3, 0x28, 0x33, 0xF2, 0x9A, 0x38, 0x37, 0xE1, 0xD1, 0x30, 0xA0, 0xB6, 0x0D,
  0x08, 0x58, 0x11, 0xF5, 0x58, 0x14, 0xF2, 0x50, 0x70, 0xE6, 0x00, 0xB6, 0x0E, 0x08, 0x58, 0x12,
  0xF4, 0x58, 0x15, 0xF1, 0x50, 0x80, 0xD6, 0x0B, 0x0A, 0x60,
  // "Ŀ" (U+013F)
  0x28, 0x12, 0xF4, 0x38, 0x15, 0xF1, 0x30, 0x90, 0xD4, 0x0C, 0x0A, 0x49, 0x07, 0x38, 0x13, 0xF4,
  0x38, 0x94, 0x6F, 0x17, 0xE0, 0x9D, 0x08, 0xB0, 0xD9, 0x49, 0x06, 0x38, 0x14, 0xF3, 0x38, 0x57,
  0xF5, 0x55, 0x3A, 0xC0, 0x70,
  // "ŀ" (U+0140)
  0x39, 0x06, 0x38, 0x13, 0xF2, 0x30, 0x70, 0xE4, 0x0A, 0x0B, 0x40, 0xD0, 0x83, 0x81, 0x1F, 0x53,
  0x81, 0x4F, 0x23, 0x89, 0x47, 0xE0, 0x7E, 0x0B, 0xB0, 0x8B, 0x0E, 0x83, 0x81, 0x2F, 0x43, 0x81,
  0x5F, 0x13, 0x08, 0x0D, 0x40, 0xB0, 0xA4,
  // "Ł" (U+0141)
  0x28, 0x11, 0xF6, 0x38, 0x14, 0xF3, 0x30, 0x79, 0x40, 0xA0, 0xC4, 0x8A, 0x1E, 0x91, 0x10, 0x1F,
  0xBE, 0x60, 0x5F, 0xD3, 0x08, 0xFE, 0x38, 0x19, 0xDB, 0x40, 0xE0, 0x83, 0x81, 0x2F, 0x53, 0x85,
  0x5F, 0x65, 0x53, 0x9C, 0x09,
  // "ł" (U+0142)
  0x30, 0xE0, 0x72, 0x81, 0x2F, 0x42, 0x81, 0x5F, 0x12, 0x09, 0x0D, 0x30, 0xC0, 0xA3, 0x98, 0x28,
  0x50, 0x3A, 0x87, 0x95, 0xEF, 0x30, 0xAC, 0xC3, 0x0C, 0x09, 0x39, 0x06, 0x28, 0x13, 0xF3, 0x20,
  0x69, 0x30, 0xA0, 0xC3,
  // "Ń" (U+0143)
  0x78, 0x14, 0xF7, 0x78, 0x11, 0xD8, 0x71, 0x0A, 0x08, 0x77, 0x28, 0x12, 0xFB, 0x40, 0xE0, 0x72,
  0x81, 0x5F, 0xE3, 0x81, 0x2F, 0x42, 0x82, 0x9E, 0xF3, 0x28, 0x15, 0xF1, 0x28, 0x2C, 0x9E, 0x62,
  0x08, 0x0D, 0x39, 0x81, 0x6B, 0xA2, 0x0C, 0x0A, 0x28, 0x33, 0xF3, 0x8D, 0x29, 0x06, 0x28, 0x76,
  0xF0, 0x4F, 0x13, 0xF3, 0x28, 0x59, 0xC0, 0x1F, 0x56, 0x93, 0x0D, 0x09, 0x28, 0x2D, 0x89, 0xC3,
  0x90, 0x52, 0x82, 0x9B, 0xB9, 0x28, 0x14, 0xF2, 0x28, 0x25, 0xFE, 0x62, 0x07, 0x0E, 0x30, 0x2A,
  0x02, 0x20, 0xA0, 0xB4, 0x00, 0xE3,
  // "ń" (U+0144)
  0x58, 0x14, 0xF7, 0x48, 0x11, 0xD8, 0x50, 0xA0, 0x87, 0x58, 0xA0, 0xE5, 0x9E, 0xC2, 0x02, 0xFD,
  0x85, 0xF9, 0x05, 0xF8, 0x28, 0x4D, 0x90, 0x8F, 0x12, 0x98, 0x27, 0x0B, 0xC2, 0x84, 0x3F, 0x40,
  0xE8, 0x28, 0x46, 0xF1, 0x2F, 0x52, 0x84, 0x9D, 0x05, 0xF1, 0x28, 0x3D, 0xA0, 0x9E, 0x39, 0x82,
  0x60, 0xCB, 0x28, 0x13, 0xF3, 0x10,
  // "Ņ" (U+0145)
  0x28, 0x12, 0xFB, 0x40, 0xE0, 0x72, 0x81, 0x5F, 0xE3, 0x81, 0x2F, 0x42, 0x82, 0x9E, 0xF3, 0x28,
  0x15, 0xF1, 0x28, 0x2C, 0x9E, 0x62, 0x08, 0x0D, 0x39, 0x81, 0x6B, 0xA2, 0x0C, 0x0A, 0x28, 0x33,
  0xF3, 0x8D, 0x29, 0x06, 0x28, 0x76, 0xF0, 0x4F, 0x13, 0xF3, 0x28, 0x59, 0xC0, 0x1F, 0x56, 0x93,
  0x0D, 0x09, 0x28, 0x2D, 0x89, 0xC3, 0x90, 0x52, 0x82, 0x9B, 0xB9, 0x28, 0x14, 0xF2, 0x28, 0x25,
  0xFE, 0x62, 0x07, 0x0E, 0x30, 0x2A, 0x02, 0x20, 0xA0, 0xB4, 0x00, 0xE7, 0x73, 0x09, 0x0D, 0x71,
  0x81, 0x1E, 0x47, 0x10, 0x08, 0x70,
  // "ņ" (U+0146)
  0x28, 0xA0, 0xE5, 0x9E, 0xC2, 0x02, 0xFD, 0x85, 0xF9, 0x05, 0xF8, 0x28, 0x4D, 0x90, 0x8F, 0x12,
  0x98, 0x27, 0x0B, 0xC2, 0x84, 0x3F, 0x40, 0xE8, 0x28, 0x46, 0xF1, 0x2F, 0x52, 0x84, 0x9D, 0x05,
  0xF1, 0x28, 0x3D, 0xA0, 0x9E, 0x39, 0x82, 0x60, 0xCB, 0x28, 0x13, 0xF3, 0x74, 0x09, 0x0D, 0x58,
  0x11, 0xE4, 0x50, 0x08, 0x50,
  // "Ň" (U+0147)
  0x48, 0x43, 0xC0, 0x3C, 0x16, 0x82, 0xC9, 0xE3, 0x78, 0x16, 0xF6, 0x77, 0x28, 0x12, 0xFB, 0x40,
  0xE0, 0x72, 0x81, 0x5F, 0xE3, 0x81, 0x2F, 0x42, 0x82, 0x9E, 0xF3, 0x28, 0x15, 0xF1, 0x28, 0x2C,
  0x9E, 0x62, 0x08, 0x0D, 0x39, 0x81, 0x6B, 0xA2, 0x0C, 0x0A, 0x28, 0x33, 0xF3, 0x8D, 0x29, 0x06,
  0x28, 0x76, 0xF0, 0x4F, 0x13, 0xF3, 0x28, 0x59, 0xC0, 0x1F, 0x56, 0x93, 0x0D, 0x09, 0x28, 0x2D,
  0x89, 0xC3, 0x90, 0x52, 0x82, 0x9B, 0xB9, 0x28, 0x14, 0xF2, 0x28, 0x25, 0xFE, 0x62, 0x07, 0x0E,
  0x30, 0x2A, 0x02, 0x20, 0xA0, 0xB4, 0x00, 0xE3,
  // "ň" (U+0148)
  0x38, 0x43, 0xC0, 0x3C, 0x14, 0x82, 0xC9, 0xE3, 0x58, 0x16, 0xF6, 0x76, 0x84, 0xE5, 0x9E, 0xC2,
  0x28, 0x52, 0xFD, 0x85, 0xF9, 0x28, 0x15, 0xF8, 0x20, 0xD0, 0x92, 0x81, 0x8F, 0x12, 0x90, 0x72,
  0x0B, 0x0C, 0x28, 0x13, 0xF4, 0x20, 0xE0, 0x82, 0x85, 0x6F, 0x10, 0x2F, 0x52, 0x09, 0x0D, 0x28,
  0x15, 0xF1, 0x20, 0xD0, 0xA2, 0x09, 0x0E, 0x39, 0x06, 0x20, 0xC0, 0xB2, 0x81, 0x3F, 0x32,
  // "ŉ" (U+0149)
  0x18, 0x17, 0xF2, 0x60, 0xC0, 0xA6, 0x81, 0x2F, 0x36, 0x8A, 0x09, 0xA0, 0xE5, 0x9E, 0xC2, 0x61,
  0x2F, 0xD8, 0x5F, 0x92, 0x81, 0x5F, 0x82, 0x0D, 0x09, 0x28, 0x18, 0xF1, 0x29, 0x07, 0x20, 0xB0,
  0xC2, 0x81, 0x3F, 0x42, 0x0E, 0x08, 0x28, 0x56, 0xF1, 0x02, 0xF5, 0x20, 0x90, 0xD2, 0x81, 0x5F,
  0x12, 0x0D, 0x0A, 0x20, 0x90, 0xE3, 0x90, 0x62, 0x0C, 0x0B, 0x28, 0x13, 0xF3, 0x10,
  // "Ŋ" (U+014A)
  0x28, 0x12, 0xFB, 0x40, 0xE0, 0x72, 0x05, 0xA3, 0x81, 0x2F, 0x42, 0x82, 0x9E, 0xF3, 0x28, 0x15,
  0xF1, 0x28, 0x2C, 0x9E, 0x72, 0x09, 0x0D, 0x39, 0x81, 0x6A, 0xA2, 0x0C, 0x0A, 0x28, 0x33, 0xF3,
  0x6E, 0x29, 0x06, 0x28, 0x76, 0xF0, 0x3F, 0x23, 0xF3, 0x20, 0x90, 0xC2, 0x81, 0xE6, 0x69, 0x30,
  0xD0, 0x92, 0x82, 0xB9, 0x9C, 0x39, 0x05, 0x28, 0x27, 0xDC, 0x82, 0x81, 0x4F, 0x22, 0x04, 0xA0,
  0x52, 0x07, 0x0E, 0x4A, 0x02, 0x20, 0xA0, 0xB4, 0x0C, 0x0E, 0x72, 0x0B, 0x0A, 0x78, 0x21, 0x5F,
  0x46, 0x06, 0xA0, 0x87, 0x10, 0x30, 0x15,
  // "ŋ" (U+014B)
  0x28, 0xA0, 0xD5, 0x9E, 0xC2, 0x01, 0xFC, 0x85, 0xF9, 0x04, 0xF8, 0x28, 0x4D, 0x90, 0x8F, 0x12,
  0x98, 0x27, 0x0B, 0xB2, 0x84, 0x3F, 0x30, 0xE8, 0x28, 0x46, 0xF0, 0x2F, 0x42, 0x84, 0xAC, 0x05,
  0xF1, 0x28, 0x3D, 0x90, 0x8E, 0x28, 0x41, 0xF5, 0x0B, 0xB2, 0x81, 0x4F, 0x25, 0x07, 0x0E, 0x60,
  0xB0, 0xA4, 0x82, 0x36, 0xF5, 0x48, 0x1B, 0xE8, 0x30,
  // "Ō" (U+014C)
  0x50, 0xDB, 0x09, 0x58, 0x00, 0x30, 0x14, 0x83, 0x6D, 0xFD, 0x54, 0x85, 0xAE, 0x74, 0xBF, 0x22,
  0x81, 0x6F, 0x43, 0x0E, 0x09, 0x20, 0xD0, 0xA4, 0x84, 0xCB, 0x05, 0xF3, 0x48, 0x3C, 0xB0, 0xAE,
  0x58, 0x3D, 0xA0, 0xEA, 0x59, 0x82, 0x80, 0xF8, 0x48, 0x44, 0xF4, 0x2F, 0x64, 0x84, 0x9E, 0x01,
  0xF6, 0x40, 0xE0, 0x82, 0x0E, 0x0A, 0x38, 0x19, 0xE1, 0x28, 0x58, 0xF7, 0x49, 0xF5, 0x48, 0x39,
  0xEE, 0xB3, 0x30,
  // "ō" (U+014D)
  0x30, 0xDB, 0x09, 0x38, 0x00, 0x30, 0x12, 0x83, 0x19, 0xED, 0x63, 0x89, 0x0C, 0xD5, 0x8F, 0x30,
  0x5F, 0x22, 0x83, 0xE7, 0x0C, 0xA3, 0x83, 0xE8, 0x1F, 0x53, 0x98, 0x27, 0x4F, 0x22, 0x84, 0x3F,
  0x46, 0xF1, 0x28, 0x47, 0xF0, 0x5F, 0x12, 0x89, 0x0E, 0x90, 0x1F, 0xA4, 0xBE, 0x12, 0x83, 0x4D,
  0xEB, 0x22,
  // "Ŏ" (U+014E)
  0x40, 0x02, 0x20, 0x35, 0x83, 0x7A, 0x17, 0xA5, 0x83, 0x2E, 0xFD, 0x27, 0x02, 0x78, 0x36, 0xDF,
  0xD5, 0x48, 0x5A, 0xE7, 0x4B, 0xF2, 0x28, 0x16, 0xF4, 0x30, 0xE0, 0x92, 0x0D, 0x0A, 0x48, 0x4C,
  0xB0, 0x5F, 0x34, 0x83, 0xCB, 0x0A, 0xE5, 0x83, 0xDA, 0x0E, 0xA5, 0x98, 0x28, 0x0F, 0x84, 0x84,
  0x4F, 0x42, 0xF6, 0x48, 0x49, 0xE0, 0x1F, 0x64, 0x0E, 0x08, 0x20, 0xE0, 0xA3, 0x81, 0x9E, 0x12,
  0x85, 0x8F, 0x74, 0x9F, 0x54, 0x83, 0x9E, 0xEB, 0x33,
  // "ŏ" (U+014F)
  0x30, 0x02, 0x20, 0x33, 0x83, 0x7A, 0x17, 0xA3, 0x83, 0x2E, 0xFD, 0x25, 0x02, 0x48, 0x31, 0x9E,
  0xD6, 0x38, 0x90, 0xCD, 0x58, 0xF3, 0x05, 0xF2, 0x28, 0x3E, 0x70, 0xCA, 0x38, 0x3E, 0x81, 0xF5,
  0x39, 0x82, 0x74, 0xF2, 0x28, 0x43, 0xF4, 0x6F, 0x12, 0x84, 0x7F, 0x05, 0xF1, 0x28, 0x90, 0xE9,
  0x01, 0xFA, 0x4B, 0xE1, 0x28, 0x34, 0xDE, 0xB2, 0x20,
  // "Ő" (U+0150)
  0x68, 0x44, 0xE4, 0x7D, 0x15, 0x84, 0x1D, 0x63, 0xE3, 0x68, 0x3A, 0x50, 0xC3, 0x77, 0x48, 0x36,
  0xDF, 0xD5, 0x68, 0x5A, 0xE7, 0x4B, 0xF2, 0x48, 0x16, 0xF4, 0x30, 0xE0, 0x94, 0x0D, 0x0A, 0x40,
  0xC0, 0xB3, 0x81, 0x5F, 0x34, 0x0C, 0x0B, 0x30, 0xA0, 0xE5, 0x0D, 0x0A, 0x30, 0xE0, 0xA5, 0x90,
  0x83, 0x90, 0x84, 0x81, 0x4F, 0x42, 0x81, 0x2F, 0x64, 0x09, 0x0E, 0x38, 0x11, 0xF6, 0x40, 0xE0,
  0x84, 0x0E, 0x0A, 0x38, 0x19, 0xE1, 0x48, 0x58, 0xF7, 0x49, 0xF5, 0x68, 0x39, 0xEE, 0xB3, 0x50,
  // "ő" (U+0151)
  0x48, 0x44, 0xE4, 0x7D, 0x13, 0x84, 0x1D, 0x63, 0xE3, 0x48, 0x3A, 0x50, 0xC3, 0x77, 0x83, 0x19,
  0xED, 0x65, 0x84, 0xCD, 0x58, 0xF3, 0x38, 0x15, 0xF2, 0x20, 0xE0, 0x73, 0x0C, 0x0A, 0x30, 0xE0,
  0x82, 0x81, 0x1F, 0x53, 0x90, 0x72, 0x81, 0x4F, 0x22, 0x81, 0x3F, 0x42, 0x81, 0x6F, 0x12, 0x07,
  0x93, 0x81, 0x5F, 0x12, 0x0E, 0x09, 0x38, 0x51, 0xFA, 0x4B, 0xE1, 0x48, 0x34, 0xDE, 0xB2, 0x40,
  // "Œ" (U+0152)
  0x40, 0x70, 0xDE, 0x0A, 0x38, 0x90, 0xBE, 0x74, 0xDB, 0x33, 0x31, 0x28, 0x17, 0xF3, 0x29, 0x07,
  0x60, 0xE0, 0x92, 0x81, 0x3F, 0x35, 0x81, 0x6F, 0x22, 0x06, 0x0E, 0x60, 0xA0, 0xD3, 0x09, 0xC0,
  0x32, 0x0E, 0x0A, 0x30, 0xC0, 0x90, 0xF3, 0x39, 0x07, 0x39, 0x05, 0x58, 0x12, 0xF6, 0x28, 0x13,
  0xF2, 0x58, 0x11, 0xF6, 0x20, 0x79, 0x70, 0xE0, 0xA2, 0x0A, 0x0C, 0x78, 0x90, 0x8F, 0x84, 0xDB,
  0x33, 0x31, 0x40, 0x90, 0xEE, 0x02, 0x20,
  // "œ" (U+0153)
  0x28, 0x90, 0x19, 0xED, 0x50, 0x6D, 0xE8, 0x38, 0x95, 0xCD, 0x58, 0xE8, 0xE5, 0x8F, 0x30, 0x5F,
  0x22, 0x89, 0x0E, 0xF3, 0x03, 0xF3, 0x0C, 0xA3, 0x89, 0x0E, 0xA1, 0x5D, 0xC0, 0x1F, 0x53, 0xB8,
  0x5E, 0x91, 0x04, 0xF2, 0x28, 0x23, 0xF6, 0x24, 0x81, 0x6F, 0x12, 0x81, 0x7F, 0x25, 0x81, 0x5F,
  0x12, 0x81, 0xDF, 0x45, 0x89, 0x11, 0xFA, 0x4B, 0xBB, 0xD5, 0x59, 0x38, 0x90, 0x5D, 0xE9, 0x02,
  0xCF, 0xD8, 0x20,
  // "Ŕ" (U+0154)
  0x68, 0x14, 0xF7, 0x58, 0x11, 0xD8, 0x60, 0xA0, 0x87, 0x60, 0x2A, 0x81, 0xEC, 0x43, 0x85, 0x5F,
  0x45, 0xCE, 0x12, 0x09, 0x0D, 0x28, 0x13, 0xF5, 0x20, 0xC0, 0xA2, 0x81, 0x3F, 0x42, 0x90, 0x62,
  0x89, 0x18, 0xF1, 0x03, 0xF3, 0x16, 0xF8, 0x20, 0x6B, 0x0E, 0x07, 0x38, 0x39, 0xC3, 0xCB, 0x48,
  0x3D, 0x90, 0x8E, 0x49, 0x83, 0x60, 0x5F, 0x32, 0x85, 0x4F, 0x30, 0x2F, 0x62, 0x07, 0x93, 0x0E,
  0x0A, 0x20, 0xA0, 0xC3, 0x0A, 0x0E, 0x20,
  // "ŕ" (U+0155)
  0x48, 0x14, 0xF7, 0x38, 0x11, 0xD8, 0x40, 0xA0, 0x87, 0x48, 0x91, 0xD4, 0xAF, 0x30, 0x1F, 0xC7,
  0x52, 0x81, 0x4F, 0x84, 0x81, 0x8F, 0x14, 0x00, 0xB5, 0x0E, 0x07, 0x48, 0x12, 0xF4, 0x48, 0x15,
  0xF1, 0x40, 0x80, 0xE5, 0x00, 0xB5,
  // "Ŗ" (U+0156)
  0x20, 0x2A, 0x81, 0xEC, 0x43, 0x85, 0x5F, 0x45, 0xCE, 0x12, 0x09, 0x0D, 0x28, 0x13, 0xF5, 0x20,
  0xC0, 0xA2, 0x81, 0x3F, 0x42, 0x90, 0x62, 0x89, 0x18, 0xF1, 0x03, 0xF3, 0x16, 0xF8, 0x20, 0x6B,
  0x0E, 0x07, 0x38, 0x39, 0xC3, 0xCB, 0x48, 0x3D, 0x90, 0x8E, 0x49, 0x83, 0x60, 0x5F, 0x32, 0x85,
  0x4F, 0x30, 0x2F, 0x62, 0x07, 0x93, 0x0E, 0x0A, 0x20, 0xA0, 0xC3, 0x0A, 0x0E, 0x76, 0x09, 0x0D,
  0x68, 0x11, 0xE4, 0x60, 0x08, 0x60,
  // "ŗ" (U+0157)
  0x38, 0x3D, 0x4A, 0xF3, 0x28, 0x31, 0xFC, 0x75, 0x38, 0x14, 0xF8, 0x58, 0x18, 0xF1, 0x50, 0x0B,
  0x60, 0xE0, 0x75, 0x81, 0x2F, 0x45, 0x81, 0x5F, 0x15, 0x08, 0x0E, 0x60, 0x0B, 0x77, 0x09, 0x0D,
  0x58, 0x11, 0xE4, 0x50, 0x08, 0x60,
  // "Ř" (U+0158)
  0x38, 0x43, 0xC0, 0x3C, 0x14, 0x82, 0xC9, 0xE3, 0x58, 0x16, 0xF6, 0x76, 0x02, 0xA8, 0x1E, 0xC4,
  0x38, 0x55, 0xF4, 0x5C, 0xE1, 0x20, 0x90, 0xD2, 0x81, 0x3F, 0x52, 0x0C, 0x0A, 0x28, 0x13, 0xF4,
  0x29, 0x06, 0x28, 0x91, 0x8F, 0x10, 0x3F, 0x31, 0x6F, 0x82, 0x06, 0xB0, 0xE0, 0x73, 0x83, 0x9C,
  0x3C, 0xB4, 0x83, 0xD9, 0x08, 0xE4, 0x98, 0x36, 0x05, 0xF3, 0x28, 0x54, 0xF3, 0x02, 0xF6, 0x20,
  0x79, 0x30, 0xE0, 0xA2, 0x0A, 0x0C, 0x30, 0xA0, 0xE2,
  // "ř" (U+0159)
  0x28, 0x43, 0xC0, 0x3C, 0x13, 0x82, 0xC9, 0xE3, 0x48, 0x16, 0xF6, 0x75, 0x83, 0xD4, 0xAF, 0x32,
  0x83, 0x1F, 0xC7, 0x53, 0x81, 0x4F, 0x85, 0x81, 0x8F, 0x15, 0x00, 0xB6, 0x0E, 0x07, 0x58, 0x12,
  0xF4, 0x58, 0x15, 0xF1, 0x50, 0x80, 0xE6, 0x00, 0xB6,
  // "Ś" (U+015A)
  0x78, 0x14, 0xF7, 0x68, 0x11, 0xD8, 0x70, 0xA0, 0x87, 0x72, 0x83, 0x8D, 0xFD, 0x74, 0x84, 0xCE,
  0x64, 0x87, 0x38, 0x14, 0xF4, 0x78, 0x16, 0xF2, 0x78, 0x15, 0xF6, 0x71, 0x81, 0xDF, 0x47, 0x82,
  0x2E, 0xF5, 0x78, 0x22, 0xDE, 0x17, 0x81, 0x5F, 0x67, 0x81, 0x2F, 0x67, 0x81, 0x6F, 0x32, 0x85,
  0x1B, 0x64, 0x7E, 0xB3, 0x84, 0x1B, 0xEF, 0xD8, 0x40,
  // "ś" (U+015B)
  0x58, 0x14, 0xF7, 0x48, 0x11, 0xD8, 0x50, 0xA0, 0x87, 0x68, 0x39, 0xEE, 0xB2, 0x28, 0x39, 0xE5,
  0x5A, 0x30, 0xD0, 0x96, 0x00, 0xC6, 0x81, 0x4F, 0xB6, 0x81, 0x4F, 0xB6, 0x81, 0x7F, 0x15, 0x89,
  0x05, 0xF2, 0x01, 0x95, 0x5D, 0xC3, 0x83, 0xBE, 0xEB, 0x22,
  // "Ŝ" (U+015C)
  0x58, 0x12, 0xEC, 0x68, 0x2C, 0x9F, 0x24, 0x83, 0xA7, 0x07, 0x97, 0x68, 0x38, 0xDF, 0xD7, 0x38,
  0x4C, 0xE6, 0x48, 0x72, 0x81, 0x4F, 0x46, 0x81, 0x6F, 0x26, 0x81, 0x5F, 0x67, 0x81, 0xDF, 0x46,
  0x82, 0x2E, 0xF5, 0x68, 0x22, 0xDE, 0x16, 0x81, 0x5F, 0x66, 0x81, 0x2F, 0x66, 0x89, 0x16, 0xF3,
  0x01, 0xB6, 0x47, 0xEB, 0x28, 0x41, 0xBE, 0xFD, 0x83,
  // "ŝ" (U+015D)
  0x48, 0x12, 0xEC, 0x58, 0x2C, 0x9F, 0x23, 0x83, 0xA7, 0x07, 0x97, 0x48, 0x39, 0xEE, 0xB2, 0x28,
  0x39, 0xE5, 0x5A, 0x30, 0xD0, 0x96, 0x00, 0xC6, 0x81, 0x4F, 0xB6, 0x81, 0x4F, 0xB6, 0x81, 0x7F,
  0x15, 0x89, 0x05, 0xF2, 0x01, 0x95, 0x5D, 0xC3, 0x83, 0xBE, 0xEB, 0x22,
  // "Ş" (U+015E)
  0x48, 0x38, 0xDF, 0xD7, 0x38, 0x4C, 0xE6, 0x48, 0x72, 0x81, 0x4F, 0x46, 0x81, 0x6F, 0x26, 0x81,
  0x5F, 0x67, 0x81, 0xDF, 0x46, 0x82, 0x2E, 0xF5, 0x68, 0x22, 0xDE, 0x16, 0x81, 0x5F, 0x66, 0x81,
  0x2F, 0x66, 0x89, 0x16, 0xF3, 0x01, 0xB6, 0x47, 0xEB, 0x28, 0x11, 0xBE, 0xA0, 0x85, 0x81, 0x2E,
  0x27, 0x05, 0x0E, 0x58, 0x22, 0x4A, 0xD5, 0x82, 0x5E, 0xC3, 0x40,
  // "ş" (U+015F)
  0x38, 0x39, 0xEE, 0xB2, 0x28, 0x39, 0xE5, 0x5A, 0x30, 0xD0, 0x96, 0x00, 0xC6, 0x81, 0x4F, 0xB6,
  0x81, 0x4F, 0xB6, 0x81, 0x7F, 0x15, 0x89, 0x05, 0xF2, 0x01, 0x95, 0x5D, 0xC3, 0x0B, 0xA0, 0xB0,
  0x23, 0x81, 0x2E, 0x26, 0x05, 0x0E, 0x48, 0x22, 0x4A, 0xD4, 0x82, 0x5E, 0xC3, 0x40,
  // "Š" (U+0160)
  0x48, 0x43, 0xC0, 0x3C, 0x15, 0x82, 0xC9, 0xE3, 0x68, 0x16, 0xF6, 0x77, 0x28, 0x38, 0xDF, 0xD7,
  0x48, 0x4C, 0xE6, 0x48, 0x73, 0x81, 0x4F, 0x47, 0x81, 0x6F, 0x27, 0x81, 0x5F, 0x67, 0x18, 0x1D,
  0xF4, 0x78, 0x22, 0xEF, 0x57, 0x82, 0x2D, 0xE1, 0x78, 0x15, 0xF6, 0x78, 0x12, 0xF6, 0x78, 0x16,
  0xF3, 0x28, 0x51, 0xB6, 0x47, 0xEB, 0x38, 0x41, 0xBE, 0xFD, 0x84,
  // "š" (U+0161)
  0x38, 0x43, 0xC0, 0x3C, 0x14, 0x82, 0xC9, 0xE3, 0x58, 0x16, 0xF6, 0x77, 0x83, 0x9E, 0xEB, 0x23,
  0x83, 0x9E, 0x55, 0xA4, 0x0D, 0x09, 0x70, 0x0C, 0x78, 0x14, 0xFB, 0x78, 0x14, 0xFB, 0x78, 0x17,
  0xF1, 0x68, 0x15, 0xF2, 0x28, 0x41, 0x95, 0x5D, 0xC4, 0x83, 0xBE, 0xEB, 0x23,
  // "Ţ" (U+0162)
  0x10, 0x5E, 0x87, 0x50, 0x13, 0x4F, 0x93, 0x34, 0x81, 0x2F, 0x46, 0x81, 0x5F, 0x16, 0x09, 0x0E,
  0x70, 0xC0, 0xA7, 0x90, 0x76, 0x81, 0x3F, 0x46, 0x81, 0x6F, 0x16, 0x09, 0x0D, 0x70, 0xC0, 0xA7,
  0x90, 0x76, 0x81, 0x3F, 0x56, 0x81, 0x2E, 0x27, 0x05, 0x0E, 0x58, 0x22, 0x4A, 0xD5, 0x82, 0x5E,
  0xC3, 0x50,
  // "ţ" (U+0163)
  0x30, 0x10, 0xE5, 0x07, 0x0B, 0x40, 0x9B, 0x03, 0x28, 0x25, 0xF7, 0x33, 0x81, 0x4F, 0x24, 0x07,
  0x0E, 0x50, 0x0B, 0x50, 0xE0, 0x84, 0x81, 0x2F, 0x44, 0x81, 0x4F, 0x14, 0x82, 0x5F, 0x63, 0x30,
  0x1A, 0x08, 0x38, 0x12, 0xE2, 0x50, 0x50, 0xE3, 0x82, 0x24, 0xAD, 0x38, 0x25, 0xEC, 0x33,
  // "Ť" (U+0164)
  0x28, 0x43, 0xC0, 0x3C, 0x13, 0x82, 0xC9, 0xE3, 0x48, 0x16, 0xF6, 0x73, 0x05, 0xE8, 0x65, 0x13,
  0x4F, 0x93, 0x33, 0x81, 0x2F, 0x45, 0x81, 0x5F, 0x15, 0x09, 0x0E, 0x60, 0xC0, 0xA6, 0x90, 0x75,
  0x81, 0x3F, 0x45, 0x81, 0x6F, 0x15, 0x09, 0x0D, 0x60, 0xC0, 0xA6, 0x90, 0x75, 0x81, 0x3F, 0x45,
  // "ť" (U+0165)
  0x58, 0x13, 0xF3, 0x50, 0x90, 0xA3, 0x83, 0x1E, 0x1D, 0x13, 0x07, 0x0B, 0x50, 0x9B, 0x03, 0x38,
  0x25, 0xF7, 0x34, 0x81, 0x4F, 0x25, 0x07, 0x0E, 0x60, 0x0B, 0x60, 0xE0, 0x85, 0x81, 0x2F, 0x45,
  0x81, 0x4F, 0x15, 0x82, 0x5F, 0x63, 0x48, 0x21, 0xCF, 0x84,
  // "Ŧ" (U+0166)
  0x05, 0xE8, 0x65, 0x13, 0x3F, 0x93, 0x33, 0x81, 0x2F, 0x55, 0x81, 0x5F, 0x25, 0x08, 0x0E, 0x60,
  0x0B, 0x40, 0xCC, 0x07, 0x28, 0x43, 0x5F, 0x73, 0x13, 0x81, 0x5F, 0x25, 0x09, 0x0E, 0x60, 0xC0,
  0xA6, 0x90, 0x75, 0x81, 0x3F, 0x45,
  // "ŧ" (U+0167)
  0x20, 0x10, 0xE4, 0x07, 0x0B, 0x30, 0x9B, 0x84, 0x30, 0x5F, 0x73, 0x28, 0x14, 0xF2, 0x30, 0x79,
  0x30, 0xAB, 0x89, 0x16, 0x02, 0xDA, 0x31, 0x01, 0xF5, 0x38, 0x14, 0xF2, 0x38, 0x25, 0xF6, 0x32,
  0x82, 0x1C, 0xF8, 0x20,
  // "Ũ" (U+0168)
  0x48, 0x43, 0xED, 0x36, 0x84, 0x84, 0xB6, 0x8F, 0xE2, 0x40, 0x32, 0x00, 0x13, 0x81, 0x4F, 0x33,
  0x09, 0x0D, 0x20, 0x79, 0x40, 0xC0, 0xA2, 0x0A, 0x0C, 0x49, 0x06, 0x20, 0xE0, 0x83, 0x85, 0x3F,
  0x30, 0x1F, 0x53, 0x07, 0x92, 0x81, 0x5F, 0x23, 0x0A, 0x0C, 0x20, 0x80, 0xE4, 0x0D, 0x09, 0x20,
  0x0B, 0x38, 0x11, 0xF5, 0x20, 0xE0, 0x83, 0x85, 0x5F, 0x20, 0x1F, 0x53, 0x09, 0x0D, 0x28, 0x11,
  0xF6, 0x28, 0x11, 0xE8, 0x38, 0x5C, 0xE6, 0x7D, 0xD1, 0x38, 0x42, 0xBE, 0xEA, 0x13,
  // "ũ" (U+0169)
  0x38, 0x43, 0xED, 0x36, 0x83, 0x84, 0xB6, 0x8F, 0xE2, 0x30, 0x32, 0x00, 0x13, 0x0E, 0x07, 0x20,
  0x69, 0x28, 0x12, 0xF4, 0x20, 0x90, 0xC2, 0x81, 0x5F, 0x12, 0x0D, 0x09, 0x20, 0x90, 0xD3, 0x90,
  0x62, 0x0C, 0x0A, 0x28, 0x14, 0xF3, 0x29, 0x06, 0x20, 0x89, 0x28, 0x13, 0xF3, 0x20, 0x0C, 0x28,
  0x55, 0xF2, 0x04, 0xF8, 0x28, 0x54, 0xF8, 0x6C, 0xF5, 0x38, 0x4A, 0xEB, 0x2F, 0x22,
  // "Ū" (U+016A)
  0x40, 0xDB, 0x09, 0x58, 0x00, 0x30, 0x13, 0x81, 0x4F, 0x33, 0x09, 0x0D, 0x20, 0x79, 0x40, 0xC0,
  0xA2, 0x0A, 0x0C, 0x49, 0x06, 0x20, 0xE0, 0x83, 0x85, 0x3F, 0x30, 0x1F, 0x53, 0x07, 0x92, 0x81,
  0x5F, 0x23, 0x0A, 0x0C, 0x20, 0x80, 0xE4, 0x0D, 0x09, 0x20, 0x0B, 0x38, 0x11, 0xF5, 0x20, 0xE0,
  0x83, 0x85, 0x5F, 0x20, 0x1F, 0x53, 0x09, 0x0D, 0x28, 0x11, 0xF6, 0x28, 0x11, 0xE8, 0x38, 0x5C,
  0xE6, 0x7D, 0xD1, 0x38, 0x42, 0xBE, 0xEA, 0x13,
  // "ū" (U+016B)
  0x30, 0xDB, 0x09, 0x38, 0x00, 0x30, 0x12, 0x0E, 0x07, 0x28, 0x46, 0xF0, 0x2F, 0x42, 0x84, 0x9C,
  0x05, 0xF1, 0x28, 0x3D, 0x90, 0x9D, 0x39, 0x82, 0x60, 0xCA, 0x28, 0x44, 0xF3, 0x0F, 0x62, 0x84,
  0x8F, 0x03, 0xF3, 0x28, 0xA0, 0xCC, 0x05, 0xF2, 0x04, 0xF8, 0x04, 0xF8, 0x6C, 0xF5, 0x28, 0x4A,
  0xEB, 0x2F, 0x21,
  // "Ŭ" (U+016C)
  0x40, 0x02, 0x20, 0x35, 0x83, 0x7A, 0x17, 0xA5, 0x83, 0x2E, 0xFD, 0x27, 0x02, 0x58, 0x14, 0xF3,
  0x30, 0x90, 0xD2, 0x07, 0x94, 0x0C, 0x0A, 0x20, 0xA0, 0xC4, 0x90, 0x62, 0x0E, 0x08, 0x38, 0x53,
  0xF3, 0x01, 0xF5, 0x30, 0x79, 0x28, 0x15, 0xF2, 0x30, 0xA0, 0xC2, 0x08, 0x0E, 0x40, 0xD0, 0x92,
  0x00, 0xB3, 0x81, 0x1F, 0x52, 0x0E, 0x08, 0x38, 0x55, 0xF2, 0x01, 0xF5, 0x30, 0x90, 0xD2, 0x81,
  0x1F, 0x62, 0x81, 0x1E, 0x83, 0x85, 0xCE, 0x67, 0xDD, 0x13, 0x84, 0x2B, 0xEE, 0xA1, 0x30,
  // "ŭ" (U+016D)
  0x30, 0x02, 0x20, 0x33, 0x83, 0x7A, 0x17, 0xA3, 0x83, 0x2E, 0xFD, 0x25, 0x02, 0x40, 0xE0, 0x72,
  0x84, 0x6F, 0x02, 0xF4, 0x28, 0x49, 0xC0, 0x5F, 0x12, 0x83, 0xD9, 0x09, 0xD3, 0x98, 0x26, 0x0C,
  0xA2, 0x84, 0x4F, 0x30, 0xF6, 0x28, 0x48, 0xF0, 0x3F, 0x32, 0x8A, 0x0C, 0xC0, 0x5F, 0x20, 0x4F,
  0x80, 0x4F, 0x86, 0xCF, 0x52, 0x84, 0xAE, 0xB2, 0xF2, 0x10,
  // "Ů" (U+016E)
  0x48, 0x21, 0xCF, 0x76, 0x83, 0x6A, 0x4D, 0x15, 0x83, 0x78, 0x1C, 0x15, 0x82, 0x2E, 0xFA, 0x71,
  0x02, 0x58, 0x14, 0xF3, 0x30, 0x90, 0xD2, 0x07, 0x94, 0x0C, 0x0A, 0x20, 0xA0, 0xC4, 0x90, 0x62,
  0x0E, 0x08, 0x38, 0x53, 0xF3, 0x01, 0xF5, 0x30, 0x79, 0x28, 0x15, 0xF2, 0x30, 0xA0, 0xC2, 0x08,
  0x0E, 0x40, 0xD0, 0x92, 0x00, 0xB3, 0x81, 0x1F, 0x52, 0x0E, 0x08, 0x38, 0x55, 0xF2, 0x01, 0xF5,
  0x30, 0x90, 0xD2, 0x81, 0x1F, 0x62, 0x81, 0x1E, 0x83, 0x85, 0xCE, 0x67, 0xDD, 0x13, 0x84, 0x2B,
  0xEE, 0xA1, 0x30,
  // "ů" (U+016F)
  0x38, 0x21, 0xCF, 0x74, 0x83, 0x6A, 0x4D, 0x13, 0x83, 0x78, 0x1C, 0x13, 0x82, 0x2E, 0xFA, 0x60,
  0x24, 0x0E, 0x07, 0x28, 0x46, 0xF0, 0x2F, 0x42, 0x84, 0x9C, 0x05, 0xF1, 0x28, 0x3D, 0x90, 0x9D,
  0x39, 0x82, 0x60, 0xCA, 0x28, 0x44, 0xF3, 0x0F, 0x62, 0x84, 0x8F, 0x03, 0xF3, 0x28, 0xA0, 0xCC,
  0x05, 0xF2, 0x04, 0xF8, 0x04, 0xF8, 0x6C, 0xF5, 0x28, 0x4A, 0xEB, 0x2F, 0x21,
  // "Ű" (U+0170)
  0x68, 0x44, 0xE4, 0x7D, 0x15, 0x84, 0x1D, 0x63, 0xE3, 0x68, 0x3A, 0x50, 0xC3, 0x77, 0x28, 0x14,
  0xF3, 0x30, 0x90, 0xD4, 0x07, 0x94, 0x0C, 0x0A, 0x40, 0xA0, 0xC4, 0x90, 0x64, 0x0E, 0x08, 0x38,
  0x13, 0xF3, 0x38, 0x11, 0xF5, 0x30, 0x79, 0x48, 0x15, 0xF2, 0x30, 0xA0, 0xC4, 0x08, 0x0E, 0x40,
  0xD0, 0x94, 0x00, 0xB3, 0x81, 0x1F, 0x54, 0x0E, 0x08, 0x38, 0x15, 0xF2, 0x38, 0x11, 0xF5, 0x30,
  0x90, 0xD4, 0x81, 0x1F, 0x62, 0x81, 0x1E, 0x85, 0x85, 0xCE, 0x67, 0xDD, 0x15, 0x84, 0x2B, 0xEE,
  0xA1, 0x50,
  // "ű" (U+0171)
  0x48, 0x44, 0xE4, 0x7D, 0x13, 0x84, 0x1D, 0x63, 0xE3, 0x48, 0x3A, 0x50, 0xC3, 0x77, 0x0E, 0x07,
  0x20, 0x69, 0x38, 0x12, 0xF4, 0x20, 0x90, 0xC3, 0x81, 0x5F, 0x12, 0x0D, 0x09, 0x30, 0x90, 0xD3,
  0x90, 0x63, 0x0C, 0x0A, 0x28, 0x14, 0xF3, 0x39, 0x06, 0x20, 0x89, 0x38, 0x13, 0xF3, 0x20, 0x0C,
  0x38, 0x55, 0xF2, 0x04, 0xF8, 0x38, 0x54, 0xF8, 0x6C, 0xF5, 0x48, 0x4A, 0xEB, 0x2F, 0x23,
  // "Ų" (U+0172)
  0x28, 0x14, 0xF3, 0x30, 0x90, 0xD2, 0x07, 0x94, 0x0C, 0x0A, 0x20, 0xA0, 0xC4, 0x90, 0x62, 0x0E,
  0x08, 0x38, 0x53, 0xF3, 0x01, 0xF5, 0x30, 0x79, 0x28, 0x15, 0xF2, 0x30, 0xA0, 0xC2, 0x08, 0x0E,
  0x40, 0xD0, 0x92, 0x00, 0xB3, 0x81, 0x1F, 0x52, 0x0E, 0x08, 0x38, 0x55, 0xF2, 0x01, 0xF5, 0x30,
  0x90, 0xD2, 0x81, 0x1F, 0x62, 0x81, 0x1E, 0x83, 0x85, 0xCE, 0x67, 0xDD, 0x13, 0x84, 0x2B, 0xEE,
  0xA1, 0x60, 0x50, 0x67, 0x05, 0x0B, 0x71, 0x0B, 0x09, 0x71, 0x81, 0x9F, 0x97, 0x10, 0x20, 0x15,
  // "ų" (U+0173)
  0x20, 0xE0, 0x72, 0x84, 0x6F, 0x02, 0xF4, 0x28, 0x49, 0xC0, 0x5F, 0x12, 0x83, 0xD9, 0x09, 0xD3,
  0x98, 0x26, 0x0C, 0xA2, 0x84, 0x4F, 0x30, 0xF6, 0x28, 0x48, 0xF0, 0x3F, 0x32, 0x8A, 0x0C, 0xC0,
  0x5F, 0x20, 0x4F, 0x80, 0x4F, 0x86, 0xCF, 0x52, 0x84, 0xAE, 0xB2, 0xF2, 0x50, 0x50, 0x65, 0x05,
  0x0B, 0x60, 0xB0, 0x96, 0x81, 0x9F, 0x96, 0x02, 0x01, 0x20,
  // "Ŵ" (U+0174)
  0x68, 0x12, 0xEC, 0x74, 0x82, 0xC9, 0xF2, 0x72, 0x83, 0xA7, 0x07, 0x97, 0x74, 0x81, 0x5F, 0x13,
  0x0D, 0x0A, 0x38, 0x46, 0xF1, 0x5F, 0x12, 0x81, 0x4F, 0xA3, 0x84, 0xCA, 0x05, 0xF1, 0x28, 0x1B,
  0xFA, 0x28, 0x92, 0x3F, 0x40, 0x5F, 0x10, 0x2F, 0xBA, 0x20, 0x90, 0xD2, 0x86, 0x5F, 0x10, 0x8B,
  0x9A, 0x20, 0xE0, 0x72, 0x89, 0x25, 0xF1, 0x0E, 0x59, 0x90, 0x6F, 0x12, 0x89, 0x15, 0xF0, 0x5E,
  0x09, 0x90, 0xCA, 0x38, 0x91, 0x5F, 0x0B, 0x80, 0x99, 0x3F, 0x33, 0x89, 0x05, 0xF2, 0xF2, 0x09,
  0x99, 0xD4, 0x82, 0x5F, 0x8B, 0x28, 0x29, 0x9E, 0x64, 0x82, 0x5E, 0xD5, 0x28, 0x1A, 0xDE, 0x58,
  0x15, 0xFE, 0x38, 0x1A, 0xF9, 0x58, 0x15, 0xF8, 0x38, 0x1A, 0xF3, 0x50,
  // "ŵ" (U+0175)
  0x48, 0x12, 0xEC, 0x71, 0x82, 0xC9, 0xF2, 0x68, 0x3A, 0x70, 0x79, 0x77, 0x0E, 0x07, 0x28, 0x91,
  0xBF, 0x10, 0x1F, 0x5E, 0x70, 0x1A, 0x8C, 0x21, 0x07, 0xE0, 0xE7, 0x07, 0xCF, 0x10, 0xD8, 0x0E,
  0x70, 0xD6, 0xF1, 0x4F, 0x20, 0xE7, 0x4E, 0x2F, 0x1A, 0xB2, 0x87, 0xE7, 0xA8, 0x2F, 0x2F, 0x52,
  0x86, 0xE8, 0xF2, 0x2F, 0x7D, 0x38, 0x6E, 0xCB, 0x02, 0xFC, 0x73, 0x83, 0xEF, 0x50, 0x2A, 0x01,
  0x30, 0x0E, 0x28, 0x13, 0xFA, 0x40,
  // "Ŷ" (U+0176)
  0x38, 0x12, 0xEC, 0x58, 0x2C, 0x9F, 0x23, 0x83, 0xA7, 0x07, 0x97, 0x28, 0x15, 0xF2, 0x28, 0x41,
  0xE8, 0x3F, 0x42, 0x89, 0x09, 0xE0, 0x1F, 0x60, 0x2F, 0x62, 0x83, 0xE8, 0x0A, 0xC3, 0x83, 0xBA,
  0x3F, 0x43, 0x82, 0x9C, 0xBA, 0x40, 0x7A, 0x02, 0x48, 0x15, 0xF8, 0x58, 0x15, 0xF2, 0x50, 0x80,
  0xE6, 0x00, 0xB6, 0x0E, 0x08, 0x58, 0x12, 0xF5, 0x50,
  // "ŷ" (U+0177)
  0x58, 0x12, 0xEC, 0x78, 0x2C, 0x9F, 0x25, 0x83, 0xA7, 0x07, 0x97, 0x70, 0xE0, 0x82, 0x81, 0x1E,
  0x73, 0x0D, 0x08, 0x28, 0x17, 0xE1, 0x30, 0xC0, 0x92, 0x0D, 0x08, 0x48, 0x4B, 0xA0, 0x5F, 0x14,
  0x83, 0xAA, 0x0C, 0x95, 0x83, 0x9B, 0x4F, 0x25, 0x82, 0x8B, 0xAA, 0x68, 0x27, 0xCF, 0x36, 0x81,
  0x6F, 0xB7, 0x81, 0x5F, 0x37, 0x0A, 0x0C, 0x78, 0x12, 0xF4, 0x58, 0x22, 0x4D, 0xB6, 0x82, 0x9E,
  0xA1, 0x60,
  // "Ÿ" (U+0178)
  0x28, 0x37, 0xC0, 0x9A, 0x38, 0x21, 0x10, 0x17, 0x38, 0x15, 0xF2, 0x28, 0x41, 0xE8, 0x3F, 0x42,
  0x89, 0x09, 0xE0, 0x1F, 0x60, 0x2F, 0x62, 0x83, 0xE8, 0x0A, 0xC3, 0x83, 0xBA, 0x3F, 0x43, 0x82,
  0x9C, 0xBA, 0x40, 0x7A, 0x02, 0x48, 0x15, 0xF8, 0x58, 0x15, 0xF2, 0x50, 0x80, 0xE6, 0x00, 0xB6,
  0x0E, 0x08, 0x58, 0x12, 0xF5, 0x50,
  // "Ź" (U+0179)
  0x68, 0x14, 0xF7, 0x58, 0x11, 0xD8, 0x60, 0xA0, 0x87, 0x70, 0xDD, 0x30, 0xF3, 0x81, 0x5F, 0xA6,
  0x81, 0xAE, 0x15, 0x81, 0x4F, 0x66, 0x0D, 0x0C, 0x68, 0x17, 0xF3, 0x58, 0x11, 0xE9, 0x68, 0x1A,
  0xE1, 0x58, 0x14, 0xF6, 0x60, 0xD0, 0xC6, 0x81, 0x8F, 0x25, 0x81, 0x2F, 0xB8, 0x00, 0x32, 0x07,
  0xD0, 0x92,
  // "ź" (U+017A)
  0x58, 0x14, 0xF7, 0x48, 0x11, 0xD8, 0x50, 0xA0, 0x87, 0x50, 0x6C, 0x03, 0x28, 0x32, 0x33, 0xCC,
  0x58, 0x14, 0xF3, 0x50, 0xD0, 0x95, 0x81, 0x8E, 0x14, 0x81, 0x2F, 0x55, 0x0C, 0x0B, 0x58, 0x16,
  0xF2, 0x48, 0x41, 0xEA, 0x33, 0x22, 0x06, 0xC0, 0x82,
  // "Ż" (U+017B)
  0x50, 0x70, 0xE7, 0x08, 0x0B, 0x77, 0x0D, 0xD3, 0x0F, 0x38, 0x15, 0xFA, 0x68, 0x1A, 0xE1, 0x58,
  0x14, 0xF6, 0x60, 0xD0, 0xC6, 0x81, 0x7F, 0x35, 0x81, 0x1E, 0x96, 0x81, 0xAE, 0x15, 0x81, 0x4F,
  0x66, 0x0D, 0x0C, 0x68, 0x18, 0xF2, 0x58, 0x12, 0xFB, 0x80, 0x03, 0x20, 0x7D, 0x09, 0x20,
  // "ż" (U+017C)
  0x40, 0x70, 0xE6, 0x08, 0x0B, 0x75, 0x06, 0xC0, 0x32, 0x83, 0x23, 0x3C, 0xC5, 0x81, 0x4F, 0x35,
  0x0D, 0x09, 0x58, 0x18, 0xE1, 0x48, 0x12, 0xF5, 0x50, 0xC0, 0xB5, 0x81, 0x6F, 0x24, 0x84, 0x1E,
  0xA3, 0x32, 0x20, 0x6C, 0x08, 0x20,
  // "Ž" (U+017D)
  0x48, 0x43, 0xC0, 0x3C, 0x15, 0x82, 0xC9, 0xE3, 0x68, 0x16, 0xF6, 0x77, 0x10, 0xDD, 0x40, 0xF3,
  0x81, 0x5F, 0xA7, 0x81, 0xAE, 0x16, 0x81, 0x4F, 0x67, 0x0D, 0x0C, 0x78, 0x17, 0xF3, 0x68, 0x11,
  0xE9, 0x78, 0x1A, 0xE1, 0x68, 0x14, 0xF6, 0x70, 0xD0, 0xC7, 0x81, 0x8F, 0x26, 0x81, 0x2F, 0xB8,
  0x00, 0x33, 0x07, 0xD0, 0x93,
  // "ž" (U+017E)
  0x38, 0x43, 0xC0, 0x3C, 0x14, 0x82, 0xC9, 0xE3, 0x58, 0x16, 0xF6, 0x76, 0x06, 0xC0, 0x33, 0x83,
  0x23, 0x3C, 0xC6, 0x81, 0x4F, 0x36, 0x0D, 0x09, 0x68, 0x18, 0xE1, 0x58, 0x12, 0xF5, 0x60, 0xC0,
  0xB6, 0x81, 0x6F, 0x25, 0x84, 0x1E, 0xA3, 0x32, 0x30, 0x6C, 0x08, 0x30,
  // "ſ" (U+017F)
  0x68, 0x25, 0xDE, 0x55, 0x83, 0x1F, 0x95, 0x15, 0x06, 0x97, 0x10, 0xA0, 0xB7, 0x10, 0xE0, 0x87,
  0x81, 0x2F, 0x57, 0x81, 0x5F, 0x17, 0x08, 0x0D, 0x71, 0x0C, 0x0A, 0x71, 0x90, 0x77, 0x81, 0x3F,
  0x37, 0x06, 0x97, 0x10, 0x90, 0xC7, 0x10, 0xD0, 0x97, 0x81, 0x1F, 0x67, 0x81, 0x5F, 0x15, 0x82,
  0x14, 0xCB, 0x68, 0x24, 0xFC, 0x26,
  // "Ω" (U+03A9)
  0x58, 0x37, 0xDF, 0xC5, 0x58, 0x5B, 0xE6, 0x4A, 0xF4, 0x38, 0x18, 0xF2, 0x30, 0xE0, 0xB2, 0x81,
  0x1F, 0x84, 0x0A, 0x0D, 0x28, 0x17, 0xF2, 0x40, 0xA0, 0xD2, 0x0B, 0x0D, 0x50, 0xB0, 0xC2, 0x0E,
  0x0A, 0x50, 0xE0, 0x92, 0x90, 0x84, 0x81, 0x4F, 0x42, 0x90, 0x74, 0x0A, 0x0D, 0x30, 0xD0, 0x93,
  0x81, 0x3F, 0x53, 0x08, 0x0D, 0x30, 0xD0, 0xA2, 0x89, 0x21, 0x35, 0xF5, 0x0C, 0xD4, 0x30, 0x6B,
  0x07, 0x04, 0xB0, 0xC1,
  // "μ" (U+03BC)
  0x30, 0xE0, 0x82, 0x06, 0x92, 0x81, 0x2F, 0x52, 0x09, 0x0C, 0x28, 0x15, 0xF1, 0x20, 0xC0, 0x92,
  0x08, 0x0E, 0x39, 0x06, 0x20, 0xC0, 0xB2, 0x81, 0x3F, 0x32, 0x90, 0x72, 0x06, 0x92, 0x81, 0x3F,
  0x42, 0x0B, 0x0C, 0x28, 0x56, 0xF2, 0x02, 0xF9, 0x28, 0x59, 0xF6, 0x3C, 0xF6, 0x28, 0x5D, 0xCE,
  0xD3, 0xF3, 0x29, 0x06, 0x68, 0x14, 0xF3, 0x60, 0x79, 0x70, 0xA0, 0xB7,
  // "π" (U+03C0)
  0x01, 0x0B, 0xF8, 0x90, 0x10, 0x3E, 0xA3, 0x3E, 0x93, 0x39, 0x83, 0x50, 0x2F, 0x43, 0x85, 0x4F,
  0x20, 0x5F, 0x13, 0x07, 0x0E, 0x20, 0x80, 0xD4, 0x0A, 0x0B, 0x20, 0xB0, 0xA4, 0x0D, 0x08, 0x20,
  0xE0, 0x73, 0x85, 0x1F, 0x50, 0x2F, 0x43, 0x86, 0x4F, 0x20, 0x3F, 0x71, 0x20, 0x70, 0xE3, 0x81,
  0xCE, 0x42,
  // "–" (U+2013)
  0x06, 0xE0, 0xA0, 0x18, 0x02, 0x30, 0x10,
  // "—" (U+2014)
  0x06, 0xFF, 0x0E, 0x01, 0x80, 0x92, 0x30, 0x20,
  // "€" (U+20AC)
  0x48, 0x35, 0xCE, 0xE8, 0x38, 0x48, 0xF8, 0x46, 0x52, 0x81, 0x4F, 0x56, 0x0C, 0x0B, 0x50, 0x2D,
  0x06, 0x28, 0x41, 0x7F, 0x43, 0x34, 0x07, 0x96, 0x0B, 0xC0, 0x73, 0x84, 0x2A, 0xD3, 0x31, 0x40,
  0x80, 0xD7, 0x81, 0x6F, 0x16, 0x84, 0x1F, 0xB4, 0x54, 0x48, 0x35, 0xDF, 0xD5, 0x20,
  // "₿" (U+20BF)
  0x48, 0x27, 0x5A, 0x24, 0x81, 0xA2, 0xC3, 0x02, 0xB0, 0xE0, 0x12, 0x84, 0x5F, 0x46, 0xEB, 0x20,
  0x90, 0xE2, 0x09, 0x92, 0x0C, 0x0B, 0x20, 0x90, 0xE2, 0x90, 0x82, 0x89, 0x2D, 0xB0, 0x3F, 0x51,
  0x9E, 0x30, 0x6B, 0x0E, 0x02, 0x28, 0x49, 0xE3, 0x5E, 0x92, 0x0D, 0x0B, 0x20, 0x89, 0x29, 0x07,
  0x28, 0x48, 0xF0, 0x4F, 0x42, 0x89, 0x2D, 0xC0, 0x7F, 0x45, 0xBF, 0x50, 0xAB, 0x0E, 0x06, 0x38,
  0x29, 0x3C, 0x14, 0x81, 0xC0, 0xC4,
  // "‘" (U+2018)
  0x18, 0x93, 0x1E, 0x10, 0xAA, 0x02, 0xF4, 0x09, 0xE2, 0x06, 0x05, 0x20,
  // "’" (U+2019)
  0x18, 0x93, 0x7F, 0x20, 0xCA, 0x02, 0xF3, 0x09, 0xA2, 0x06, 0x01, 0x20,
  // "‚" (U+201A)
  0x18, 0x97, 0x17, 0x30, 0x7F, 0x10, 0xD9, 0x03, 0xF2, 0x09, 0x82,
  // "‛" (U+201B)
  0x89, 0x23, 0xF5, 0x2F, 0x40, 0xF4, 0x0D, 0x50,
  // "“" (U+201C)
  0x18, 0xA7, 0x1E, 0x22, 0xE1, 0x0A, 0x90, 0xB9, 0x03, 0xF3, 0x4F, 0x20, 0xBC, 0x0C, 0xC2,
  // "”" (U+201D)
  0x18, 0xA7, 0x8F, 0x18, 0xE1, 0x0D, 0x80, 0xE8, 0x05, 0xE1, 0x6E, 0x10, 0xC6, 0x0D, 0x52,
  // "„" (U+201E)
  0x18, 0xA4, 0x9E, 0x0A, 0xE0, 0xE7, 0x1F, 0x76, 0xD0, 0x7D, 0x0D, 0x50, 0xD4, 0x10,
  // "‟" (U+201F)
  0x8A, 0x62, 0xF5, 0x5F, 0x31, 0xF5, 0x4F, 0x20, 0xE5, 0x2F, 0x30, 0xB6, 0x0E, 0x30,
  // "†" (U+2020)
  0x38, 0x15, 0xF2, 0x40, 0x70, 0xD5, 0x00, 0x93, 0x89, 0x34, 0x3B, 0x63, 0x33, 0xFD, 0xFE, 0xF7,
  0x20, 0x20, 0xD5, 0x05, 0x0A, 0x50, 0x90, 0x85, 0x0D, 0x05, 0x48, 0x11, 0xF2, 0x40, 0x59, 0x50,
  0x90, 0xC5, 0x0D, 0x0A, 0x48, 0x11, 0xF7, 0x40,
  // "‡" (U+2021)
  0x48, 0x15, 0xF2, 0x50, 0x70, 0xD6, 0x00, 0x83, 0x89, 0x51, 0x98, 0xCA, 0x86, 0x02, 0x98, 0xF8,
  0x95, 0x30, 0x20, 0xE6, 0x07, 0x0D, 0x60, 0xB0, 0x96, 0x0C, 0x05, 0x38, 0x95, 0x38, 0x7E, 0x78,
  0x30, 0x6A, 0xAD, 0x9A, 0x33, 0x06, 0x0A, 0x60, 0xB0, 0x85, 0x81, 0x1F, 0x74,
  // "•" (U+2022)
  0x18, 0x3B, 0xEB, 0x17, 0xB0, 0x70, 0x9B, 0x09, 0x06, 0xB8, 0x47, 0x0B, 0xEB, 0x10,
  // "…" (U+2026)
  0x10, 0x13, 0x01, 0x38, 0x95, 0x10, 0x8F, 0x20, 0x8F, 0x20, 0x8F, 0x29, 0xD2, 0x09, 0x0D, 0x20,
  0x90, 0xD1,
  // "‰" (U+2030)
  0x18, 0x22, 0xCE, 0x43, 0x0E, 0x03, 0x78, 0x2D, 0x89, 0xB2, 0x08, 0x0A, 0x78, 0x74, 0xD0, 0x5C,
  0x02, 0xE1, 0x78, 0x69, 0x80, 0x7A, 0x0B, 0x77, 0x18, 0x5C, 0x50, 0xA7, 0x4D, 0x72, 0x89, 0x0E,
  0x30, 0xE3, 0xD5, 0x8E, 0xA2, 0x8D, 0x07, 0xEB, 0x0D, 0x57, 0xC7, 0xB5, 0xD3, 0xE3, 0x4E, 0x3D,
  0x58, 0xFE, 0x4E, 0x3D, 0x50, 0xD4, 0xB6, 0x0B, 0x60, 0x20, 0x99, 0x29, 0x29, 0x84, 0x3F, 0x10,
  0xD4, 0x28, 0x94, 0x3E, 0x15, 0xC0, 0x3F, 0x4E, 0x01, 0xF1, 0x28, 0x93, 0xC6, 0x06, 0xB0, 0x8A,
  0x5C, 0x07, 0xC2, 0x05, 0x0D, 0x28, 0x90, 0x5D, 0x5E, 0x34, 0xE5, 0xE4, 0x20, 0xD0, 0x42, 0x82,
  0x1C, 0xE5, 0x28, 0x1B, 0xE7, 0x20,
  // "‹" (U+2039)
  0x30, 0x23, 0x89, 0x12, 0xE5, 0x01, 0xD8, 0x01, 0xCB, 0x28, 0x14, 0xF4, 0x30, 0xC0, 0x93, 0x81,
  0x5E, 0x13, 0x0B, 0x03, 0x10,
  // "›" (U+203A)
  0x10, 0x01, 0x20, 0x0A, 0x28, 0x14, 0xF2, 0x20, 0xD0, 0x92, 0x89, 0x2B, 0xD0, 0x8E, 0x26, 0xE3,
  0x09, 0x42,
  // "⁄" (U+2044)
  0x71, 0x81, 0x2E, 0x37, 0x10, 0xC0, 0x67, 0x10, 0x80, 0xA7, 0x18, 0x14, 0xD1, 0x78, 0x11, 0xE3,
  0x71, 0x0B, 0x08, 0x71, 0x07, 0x0B, 0x71, 0x81, 0x3E, 0x17, 0x81, 0x1D, 0x57, 0x10, 0xA0, 0x97,
  0x10, 0x60, 0xC7, 0x18, 0x12, 0xE2, 0x71, 0x0C, 0x06, 0x72,
  // "™" (U+2122)
  0x85, 0xAE, 0xEE, 0x7D, 0x92, 0x83, 0x7F, 0x01, 0xD2, 0x00, 0xD2, 0x83, 0xCE, 0x01, 0xD2, 0x87,
  0xEA, 0x42, 0xBE, 0x01, 0xD2, 0x87, 0xE5, 0x97, 0x5E, 0x01, 0xD2, 0x87, 0xE0, 0xDB, 0x1E, 0x01,
  0xD2, 0x84, 0xE0, 0xBA, 0x0E, 0x20, 0x52, 0x84, 0x60, 0x33, 0x06,
  // "⅒" (U+2152)
  0x30, 0x50, 0x43, 0x81, 0x2E, 0x37, 0x82, 0x1B, 0xF7, 0x30, 0xC0, 0x67, 0x18, 0x28, 0x6E, 0x32,
  0x08, 0x0A, 0x73, 0x02, 0x92, 0x81, 0x4D, 0x17, 0x38, 0x45, 0xC0, 0x1E, 0x37, 0x48, 0x39, 0x80,
  0xB8, 0x20, 0x50, 0x42, 0x81, 0x9D, 0x93, 0x89, 0x5C, 0x57, 0xB0, 0x1B, 0xF7, 0x08, 0xB3, 0xE3,
  0x29, 0x89, 0x45, 0xE1, 0x08, 0x6E, 0x30, 0xF2, 0x0C, 0x52, 0x81, 0x1D, 0x53, 0x83, 0x2F, 0x05,
  0xD2, 0x0E, 0x03, 0x20, 0xA0, 0x94, 0x89, 0x25, 0xC0, 0x7A, 0x01, 0xF1, 0x06, 0xC5, 0x89, 0x29,
  0x80, 0x98, 0x06, 0xC0, 0x2E, 0x25, 0x89, 0x1C, 0x50, 0x8A, 0x1D, 0x60, 0xC6, 0x69, 0x84, 0x10,
  0x2E, 0xF9, 0x20,
  // "ﬁ" (U+FB01)
  0x68, 0x53, 0xCF, 0x82, 0xE3, 0x68, 0x5D, 0xB4, 0x24, 0xE2, 0x58, 0x13, 0xF2, 0x73, 0x08, 0x0E,
  0x73, 0x0A, 0x0E, 0xA8, 0x23, 0x0D, 0x85, 0x86, 0x3F, 0x93, 0x01, 0xF5, 0x58, 0x12, 0xF4, 0x28,
  0x14, 0xF1, 0x58, 0x15, 0xF1, 0x20, 0x80, 0xE6, 0x09, 0x0D, 0x30, 0x0B, 0x60, 0xC0, 0xA3, 0x0E,
  0x07, 0x69, 0x06, 0x28, 0x12, 0xF4, 0x58, 0x13, 0xF3, 0x28, 0x15, 0xF1, 0x50, 0x69, 0x30, 0x80,
  0xD6, 0x0A, 0x0C, 0x30, 0xB0, 0xA6, 0x0D, 0x08, 0x73, 0x81, 0x2F, 0x47, 0x28, 0x14, 0xAE, 0x72,
  0x82, 0x2F, 0xD4, 0x72,
  // "ﬂ" (U+FB02)
  0x68, 0x53, 0xCF, 0x80, 0xF6, 0x68, 0x5D, 0xB4, 0x23, 0xF2, 0x58, 0x13, 0xF2, 0x20, 0x70, 0xE6,
  0x08, 0x0E, 0x30, 0xA0, 0xB5, 0x0A, 0x0E, 0xA8, 0x23, 0x0D, 0x85, 0x86, 0x3F, 0x93, 0x01, 0xF5,
  0x58, 0x12, 0xF4, 0x28, 0x14, 0xF2, 0x58, 0x15, 0xF1, 0x20, 0x70, 0xE6, 0x09, 0x0D, 0x30, 0x0B,
  0x60, 0xC0, 0xA3, 0x0E, 0x08, 0x69, 0x06, 0x28, 0x12, 0xF4, 0x58, 0x13, 0xF3, 0x28, 0x15, 0xF1,
  0x50, 0x69, 0x30, 0x80, 0xD6, 0x0A, 0x0C, 0x30, 0xB0, 0xA6, 0x0D, 0x08, 0x73, 0x81, 0x2F, 0x47,
  0x28, 0x14, 0xAE, 0x72, 0x82, 0x2F, 0xD4, 0x72,
};

const Font& font_NotoSans_CondensedItalic_18() {
  static SmoothFont font(font_NotoSans_CondensedItalic_18_data);
  return font;
}

}  // namespace roo_display
