#include "10.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSans-CondensedBold (Noto Sans Condensed Bold)
// Generated on Thu Mar 30 22:28:37 CEST 2023
static const uint8_t font_NotoSans_CondensedBold_10_data[] PROGMEM = {
  
  // Header
  0x01, 0x01, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x01, 0x95,
  0xFE, 0xFE, 0x0B, 0x0B, 0x08, 0xFD, 0x03, 0x01, 0x0C, 0x04, 0x03, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x00, 0x01, 0x02, 0x08, 0x03, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x00, 0x06, 0x03, 0x08, 0x05, 0x00, 0x0D, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x05, 0x08, 0x06, 0x00, 0x15, // "#" (U+0023)
  0x00, 0x24, 0x00, 0x00, 0x04, 0x08, 0x05, 0x00, 0x2F, // "$" (U+0024)
  0x00, 0x25, 0x00, 0x01, 0x07, 0x08, 0x08, 0x00, 0x47, // "%" (U+0025)
  0x00, 0x26, 0x00, 0x01, 0x06, 0x08, 0x06, 0x00, 0x6B, // "&" (U+0026)
  0x00, 0x27, 0x00, 0x06, 0x01, 0x08, 0x02, 0x00, 0x88, // "'" (U+0027)
  0x00, 0x28, 0x00, 0x00, 0x02, 0x08, 0x03, 0x00, 0x8C, // "(" (U+0028)
  0x00, 0x29, 0x00, 0x00, 0x02, 0x08, 0x03, 0x00, 0x9C, // ")" (U+0029)
  0x00, 0x2A, 0x00, 0x04, 0x04, 0x08, 0x05, 0x00, 0xAB, // "*" (U+002A)
  0x00, 0x2B, 0x00, 0x02, 0x04, 0x06, 0x05, 0x00, 0xBA, // "+" (U+002B)
  0x00, 0x2C, 0x00, 0x00, 0x01, 0x02, 0x03, 0x00, 0xC4, // "," (U+002C)
  0x00, 0x2D, 0x00, 0x02, 0x02, 0x03, 0x03, 0x00, 0xC8, // "-" (U+002D)
  0x00, 0x2E, 0x00, 0x01, 0x01, 0x02, 0x03, 0x00, 0xCC, // "." (U+002E)
  0x00, 0x2F, 0x00, 0x01, 0x03, 0x08, 0x04, 0x00, 0xCF, // "/" (U+002F)
  0x00, 0x30, 0x00, 0x01, 0x04, 0x08, 0x05, 0x00, 0xE1, // "0" (U+0030)
  0x00, 0x31, 0x00, 0x01, 0x03, 0x08, 0x05, 0x00, 0xF7, // "1" (U+0031)
  0x00, 0x32, 0x00, 0x01, 0x04, 0x08, 0x05, 0x01, 0x0B, // "2" (U+0032)
  0x00, 0x33, 0x00, 0x01, 0x04, 0x08, 0x05, 0x01, 0x22, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x01, 0x04, 0x08, 0x05, 0x01, 0x39, // "4" (U+0034)
  0x00, 0x35, 0x00, 0x01, 0x04, 0x08, 0x05, 0x01, 0x4F, // "5" (U+0035)
  0x00, 0x36, 0x00, 0x01, 0x04, 0x08, 0x05, 0x01, 0x64, // "6" (U+0036)
  0x00, 0x37, 0x00, 0x01, 0x04, 0x08, 0x05, 0x01, 0x7A, // "7" (U+0037)
  0x00, 0x38, 0x00, 0x01, 0x04, 0x08, 0x05, 0x01, 0x90, // "8" (U+0038)
  0x00, 0x39, 0x00, 0x01, 0x04, 0x08, 0x05, 0x01, 0xA6, // "9" (U+0039)
  0x00, 0x3A, 0x00, 0x01, 0x01, 0x06, 0x03, 0x01, 0xBC, // ":" (U+003A)
  0x00, 0x3B, 0x00, 0x00, 0x01, 0x06, 0x03, 0x01, 0xC2, // ";" (U+003B)
  0x00, 0x3C, 0x00, 0x02, 0x04, 0x06, 0x05, 0x01, 0xCA, // "<" (U+003C)
  0x00, 0x3D, 0x00, 0x02, 0x04, 0x05, 0x05, 0x01, 0xD7, // "=" (U+003D)
  0x00, 0x3E, 0x00, 0x02, 0x04, 0x06, 0x05, 0x01, 0xE2, // ">" (U+003E)
  0x00, 0x3F, 0x00, 0x01, 0x03, 0x08, 0x04, 0x01, 0xEF, // "?" (U+003F)
  0x00, 0x40, 0x00, 0xFF, 0x07, 0x08, 0x08, 0x02, 0x01, // "@" (U+0040)
  0x00, 0x41, 0x00, 0x01, 0x05, 0x08, 0x06, 0x02, 0x29, // "A" (U+0041)
  0x00, 0x42, 0x00, 0x01, 0x05, 0x08, 0x06, 0x02, 0x44, // "B" (U+0042)
  0x00, 0x43, 0x00, 0x01, 0x04, 0x08, 0x05, 0x02, 0x5F, // "C" (U+0043)
  0x00, 0x44, 0x00, 0x01, 0x05, 0x08, 0x06, 0x02, 0x74, // "D" (U+0044)
  0x00, 0x45, 0x00, 0x01, 0x04, 0x08, 0x05, 0x02, 0x8E, // "E" (U+0045)
  0x00, 0x46, 0x00, 0x01, 0x04, 0x08, 0x05, 0x02, 0xA3, // "F" (U+0046)
  0x00, 0x47, 0x00, 0x01, 0x05, 0x08, 0x06, 0x02, 0xB8, // "G" (U+0047)
  0x00, 0x48, 0x00, 0x01, 0x05, 0x08, 0x06, 0x02, 0xD1, // "H" (U+0048)
  0x00, 0x49, 0x00, 0x01, 0x03, 0x08, 0x03, 0x02, 0xEB, // "I" (U+0049)
  0x00, 0x4A, 0xFF, 0xFE, 0x02, 0x08, 0x03, 0x02, 0xFD, // "J" (U+004A)
  0x00, 0x4B, 0x00, 0x01, 0x05, 0x08, 0x06, 0x03, 0x14, // "K" (U+004B)
  0x00, 0x4C, 0x00, 0x01, 0x04, 0x08, 0x05, 0x03, 0x2F, // "L" (U+004C)
  0x00, 0x4D, 0x00, 0x01, 0x07, 0x08, 0x08, 0x03, 0x47, // "M" (U+004D)
  0x00, 0x4E, 0x00, 0x01, 0x06, 0x08, 0x07, 0x03, 0x69, // "N" (U+004E)
  0x00, 0x4F, 0x00, 0x01, 0x05, 0x08, 0x07, 0x03, 0x88, // "O" (U+004F)
  0x00, 0x50, 0x00, 0x01, 0x04, 0x08, 0x05, 0x03, 0xA4, // "P" (U+0050)
  0x00, 0x51, 0x00, 0xFF, 0x05, 0x08, 0x07, 0x03, 0xBB, // "Q" (U+0051)
  0x00, 0x52, 0x00, 0x01, 0x05, 0x08, 0x06, 0x03, 0xDC, // "R" (U+0052)
  0x00, 0x53, 0x00, 0x01, 0x04, 0x08, 0x05, 0x03, 0xF6, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x04, 0x08, 0x05, 0x04, 0x0E, // "T" (U+0054)
  0x00, 0x55, 0x00, 0x01, 0x05, 0x08, 0x06, 0x04, 0x26, // "U" (U+0055)
  0x00, 0x56, 0x00, 0x01, 0x05, 0x08, 0x06, 0x04, 0x40, // "V" (U+0056)
  0x00, 0x57, 0x00, 0x01, 0x08, 0x08, 0x08, 0x04, 0x5B, // "W" (U+0057)
  0x00, 0x58, 0x00, 0x01, 0x05, 0x08, 0x05, 0x04, 0x82, // "X" (U+0058)
  0x00, 0x59, 0x00, 0x01, 0x04, 0x08, 0x05, 0x04, 0x9D, // "Y" (U+0059)
  0x00, 0x5A, 0x00, 0x01, 0x04, 0x08, 0x05, 0x04, 0xB5, // "Z" (U+005A)
  0x00, 0x5B, 0x00, 0xFF, 0x02, 0x08, 0x03, 0x04, 0xCB, // "[" (U+005B)
  0x00, 0x5C, 0x00, 0x01, 0x03, 0x08, 0x04, 0x04, 0xDC, // "\" (U+005C)
  0x00, 0x5D, 0x00, 0xFF, 0x02, 0x08, 0x03, 0x04, 0xF1, // "]" (U+005D)
  0x00, 0x5E, 0x00, 0x04, 0x04, 0x08, 0x05, 0x05, 0x02, // "^" (U+005E)
  0x00, 0x5F, 0x00, 0xFE, 0x04, 0xFF, 0x05, 0x05, 0x11, // "_" (U+005F)
  0x00, 0x60, 0x00, 0x08, 0x02, 0x09, 0x03, 0x05, 0x16, // "`" (U+0060)
  0x00, 0x61, 0x00, 0x01, 0x04, 0x06, 0x05, 0x05, 0x1B, // "a" (U+0061)
  0x00, 0x62, 0x00, 0x01, 0x04, 0x08, 0x05, 0x05, 0x2D, // "b" (U+0062)
  0x00, 0x63, 0x00, 0x01, 0x03, 0x06, 0x04, 0x05, 0x42, // "c" (U+0063)
  0x00, 0x64, 0x00, 0x01, 0x04, 0x08, 0x05, 0x05, 0x50, // "d" (U+0064)
  0x00, 0x65, 0x00, 0x01, 0x04, 0x06, 0x05, 0x05, 0x65, // "e" (U+0065)
  0x00, 0x66, 0x00, 0x01, 0x03, 0x08, 0x03, 0x05, 0x76, // "f" (U+0066)
  0x00, 0x67, 0x00, 0xFE, 0x04, 0x06, 0x05, 0x05, 0x88, // "g" (U+0067)
  0x00, 0x68, 0x00, 0x01, 0x04, 0x08, 0x05, 0x05, 0xA1, // "h" (U+0068)
  0x00, 0x69, 0x00, 0x01, 0x01, 0x08, 0x03, 0x05, 0xB6, // "i" (U+0069)
  0x00, 0x6A, 0xFF, 0xFE, 0x01, 0x08, 0x03, 0x05, 0xC0, // "j" (U+006A)
  0x00, 0x6B, 0x00, 0x01, 0x04, 0x08, 0x05, 0x05, 0xD3, // "k" (U+006B)
  0x00, 0x6C, 0x00, 0x01, 0x01, 0x08, 0x03, 0x05, 0xE8, // "l" (U+006C)
  0x00, 0x6D, 0x00, 0x01, 0x07, 0x06, 0x08, 0x05, 0xF2, // "m" (U+006D)
  0x00, 0x6E, 0x00, 0x01, 0x04, 0x06, 0x05, 0x06, 0x0C, // "n" (U+006E)
  0x00, 0x6F, 0x00, 0x01, 0x04, 0x06, 0x05, 0x06, 0x1D, // "o" (U+006F)
  0x00, 0x70, 0x00, 0xFE, 0x04, 0x06, 0x05, 0x06, 0x2E, // "p" (U+0070)
  0x00, 0x71, 0x00, 0xFE, 0x04, 0x06, 0x05, 0x06, 0x44, // "q" (U+0071)
  0x00, 0x72, 0x00, 0x01, 0x03, 0x06, 0x04, 0x06, 0x5C, // "r" (U+0072)
  0x00, 0x73, 0x00, 0x01, 0x03, 0x06, 0x04, 0x06, 0x69, // "s" (U+0073)
  0x00, 0x74, 0x00, 0x01, 0x03, 0x07, 0x04, 0x06, 0x78, // "t" (U+0074)
  0x00, 0x75, 0x00, 0x01, 0x04, 0x06, 0x05, 0x06, 0x88, // "u" (U+0075)
  0x00, 0x76, 0x00, 0x01, 0x04, 0x06, 0x05, 0x06, 0x99, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x01, 0x07, 0x06, 0x07, 0x06, 0xAB, // "w" (U+0077)
  0x00, 0x78, 0x00, 0x01, 0x04, 0x06, 0x05, 0x06, 0xC6, // "x" (U+0078)
  0x00, 0x79, 0x00, 0xFE, 0x04, 0x06, 0x05, 0x06, 0xD8, // "y" (U+0079)
  0x00, 0x7A, 0x00, 0x01, 0x03, 0x06, 0x04, 0x06, 0xF2, // "z" (U+007A)
  0x00, 0x7B, 0x00, 0xFF, 0x03, 0x08, 0x04, 0x07, 0x00, // "{" (U+007B)
  0x00, 0x7C, 0x01, 0xFE, 0x02, 0x08, 0x05, 0x07, 0x17, // "|" (U+007C)
  0x00, 0x7D, 0x00, 0xFF, 0x03, 0x08, 0x04, 0x07, 0x24, // "}" (U+007D)
  0x00, 0x7E, 0x00, 0x03, 0x04, 0x05, 0x05, 0x07, 0x3A, // "~" (U+007E)
  0x00, 0xA1, 0x00, 0x00, 0x02, 0x06, 0x03, 0x07, 0x43, // "¡" (U+00A1)
  0x00, 0xA2, 0x00, 0x01, 0x04, 0x08, 0x05, 0x07, 0x50, // "¢" (U+00A2)
  0x00, 0xA3, 0x00, 0x01, 0x04, 0x08, 0x05, 0x07, 0x68, // "£" (U+00A3)
  0x00, 0xA4, 0x00, 0x02, 0x04, 0x07, 0x06, 0x07, 0x7F, // "¤" (U+00A4)
  0x00, 0xA5, 0x00, 0x01, 0x04, 0x08, 0x05, 0x07, 0x90, // "¥" (U+00A5)
  0x00, 0xA6, 0x01, 0xFE, 0x02, 0x08, 0x05, 0x07, 0xA7, // "¦" (U+00A6)
  0x00, 0xA7, 0x00, 0x01, 0x03, 0x08, 0x04, 0x07, 0xB2, // "§" (U+00A7)
  0x00, 0xA8, 0x01, 0x07, 0x04, 0x08, 0x05, 0x07, 0xC4, // "¨" (U+00A8)
  0x00, 0xA9, 0x00, 0x00, 0x07, 0x08, 0x08, 0x07, 0xC9, // "©" (U+00A9)
  0x00, 0xAA, 0x00, 0x05, 0x02, 0x08, 0x03, 0x07, 0xEE, // "ª" (U+00AA)
  0x00, 0xAB, 0x00, 0x01, 0x04, 0x05, 0x05, 0x07, 0xF6, // "«" (U+00AB)
  0x00, 0xAC, 0x00, 0x01, 0x04, 0x04, 0x05, 0x08, 0x04, // "¬" (U+00AC)
  0x00, 0xAE, 0x00, 0x00, 0x07, 0x08, 0x08, 0x08, 0x0E, // "®" (U+00AE)
  0x00, 0xAF, 0x00, 0x08, 0x04, 0x09, 0x05, 0x08, 0x34, // "¯" (U+00AF)
  0x00, 0xB0, 0x00, 0x05, 0x03, 0x08, 0x04, 0x08, 0x38, // "°" (U+00B0)
  0x00, 0xB1, 0x00, 0x01, 0x04, 0x07, 0x05, 0x08, 0x41, // "±" (U+00B1)
  0x00, 0xB2, 0x00, 0x05, 0x03, 0x09, 0x03, 0x08, 0x50, // "²" (U+00B2)
  0x00, 0xB3, 0x00, 0x05, 0x02, 0x09, 0x03, 0x08, 0x5C, // "³" (U+00B3)
  0x00, 0xB4, 0x00, 0x07, 0x02, 0x08, 0x03, 0x08, 0x65, // "´" (U+00B4)
  0x00, 0xB5, 0x00, 0xFE, 0x04, 0x06, 0x05, 0x08, 0x69, // "µ" (U+00B5)
  0x00, 0xB6, 0x00, 0xFF, 0x04, 0x08, 0x05, 0x08, 0x7F, // "¶" (U+00B6)
  0x00, 0xB7, 0x00, 0x04, 0x01, 0x05, 0x03, 0x08, 0x9D, // "·" (U+00B7)
  0x00, 0xB8, 0xFF, 0xFE, 0x01, 0x00, 0x02, 0x08, 0xA0, // "¸" (U+00B8)
  0x00, 0xB9, 0x00, 0x05, 0x02, 0x08, 0x03, 0x08, 0xA6, // "¹" (U+00B9)
  0x00, 0xBA, 0x00, 0x05, 0x03, 0x08, 0x03, 0x08, 0xAE, // "º" (U+00BA)
  0x00, 0xBB, 0x00, 0x01, 0x05, 0x05, 0x05, 0x08, 0xB8, // "»" (U+00BB)
  0x00, 0xBC, 0x00, 0x01, 0x07, 0x08, 0x08, 0x08, 0xC9, // "¼" (U+00BC)
  0x00, 0xBD, 0x00, 0x00, 0x07, 0x08, 0x08, 0x08, 0xEC, // "½" (U+00BD)
  0x00, 0xBE, 0x00, 0x01, 0x07, 0x08, 0x08, 0x09, 0x14, // "¾" (U+00BE)
  0x00, 0xBF, 0x00, 0xFE, 0x03, 0x05, 0x04, 0x09, 0x38, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x09, 0x4A, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x09, 0x6A, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x09, 0x8A, // "Â" (U+00C2)
  0x00, 0xC3, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x09, 0xAB, // "Ã" (U+00C3)
  0x00, 0xC4, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x09, 0xCE, // "Ä" (U+00C4)
  0x00, 0xC5, 0x00, 0x01, 0x05, 0x09, 0x06, 0x09, 0xEF, // "Å" (U+00C5)
  0x00, 0xC6, 0x00, 0x01, 0x07, 0x08, 0x08, 0x0A, 0x0B, // "Æ" (U+00C6)
  0x00, 0xC7, 0x00, 0xFE, 0x04, 0x08, 0x05, 0x0A, 0x2B, // "Ç" (U+00C7)
  0x00, 0xC8, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x0A, 0x49, // "È" (U+00C8)
  0x00, 0xC9, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x0A, 0x63, // "É" (U+00C9)
  0x00, 0xCA, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x0A, 0x7D, // "Ê" (U+00CA)
  0x00, 0xCB, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x0A, 0x98, // "Ë" (U+00CB)
  0x00, 0xCC, 0x00, 0x01, 0x03, 0x0B, 0x03, 0x0A, 0xB3, // "Ì" (U+00CC)
  0x00, 0xCD, 0x00, 0x01, 0x03, 0x0A, 0x03, 0x0A, 0xCA, // "Í" (U+00CD)
  0x00, 0xCE, 0x00, 0x01, 0x03, 0x0B, 0x03, 0x0A, 0xE0, // "Î" (U+00CE)
  0x00, 0xCF, 0x00, 0x01, 0x03, 0x0A, 0x03, 0x0A, 0xF7, // "Ï" (U+00CF)
  0x00, 0xD0, 0x00, 0x01, 0x05, 0x08, 0x06, 0x0B, 0x0D, // "Ð" (U+00D0)
  0x00, 0xD1, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x0B, 0x28, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x00, 0x01, 0x05, 0x0B, 0x07, 0x0B, 0x50, // "Ò" (U+00D2)
  0x00, 0xD3, 0x00, 0x01, 0x05, 0x0A, 0x07, 0x0B, 0x71, // "Ó" (U+00D3)
  0x00, 0xD4, 0x00, 0x01, 0x05, 0x0B, 0x07, 0x0B, 0x92, // "Ô" (U+00D4)
  0x00, 0xD5, 0x00, 0x01, 0x05, 0x0B, 0x07, 0x0B, 0xB4, // "Õ" (U+00D5)
  0x00, 0xD6, 0x00, 0x01, 0x05, 0x0A, 0x07, 0x0B, 0xD8, // "Ö" (U+00D6)
  0x00, 0xD7, 0x00, 0x02, 0x04, 0x06, 0x05, 0x0B, 0xFA, // "×" (U+00D7)
  0x00, 0xD8, 0x00, 0x00, 0x05, 0x09, 0x07, 0x0C, 0x08, // "Ø" (U+00D8)
  0x00, 0xD9, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x0C, 0x24, // "Ù" (U+00D9)
  0x00, 0xDA, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x0C, 0x44, // "Ú" (U+00DA)
  0x00, 0xDB, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x0C, 0x63, // "Û" (U+00DB)
  0x00, 0xDC, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x0C, 0x83, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x0C, 0xA3, // "Ý" (U+00DD)
  0x00, 0xDE, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0C, 0xC0, // "Þ" (U+00DE)
  0x00, 0xDF, 0x00, 0x01, 0x05, 0x08, 0x06, 0x0C, 0xD6, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0C, 0xF0, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0D, 0x07, // "á" (U+00E1)
  0x00, 0xE2, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0D, 0x1E, // "â" (U+00E2)
  0x00, 0xE3, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0D, 0x36, // "ã" (U+00E3)
  0x00, 0xE4, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0D, 0x4F, // "ä" (U+00E4)
  0x00, 0xE5, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0D, 0x66, // "å" (U+00E5)
  0x00, 0xE6, 0x00, 0x01, 0x07, 0x06, 0x08, 0x0D, 0x80, // "æ" (U+00E6)
  0x00, 0xE7, 0x00, 0xFE, 0x03, 0x06, 0x04, 0x0D, 0x99, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0D, 0xAE, // "è" (U+00E8)
  0x00, 0xE9, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0D, 0xC4, // "é" (U+00E9)
  0x00, 0xEA, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0D, 0xDA, // "ê" (U+00EA)
  0x00, 0xEB, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0D, 0xF1, // "ë" (U+00EB)
  0x00, 0xEC, 0xFF, 0x01, 0x01, 0x09, 0x03, 0x0E, 0x08, // "ì" (U+00EC)
  0x00, 0xED, 0x00, 0x01, 0x02, 0x08, 0x03, 0x0E, 0x17, // "í" (U+00ED)
  0x00, 0xEE, 0xFF, 0x01, 0x02, 0x09, 0x03, 0x0E, 0x25, // "î" (U+00EE)
  0x00, 0xEF, 0x00, 0x01, 0x03, 0x08, 0x03, 0x0E, 0x37, // "ï" (U+00EF)
  0x00, 0xF0, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0E, 0x48, // "ð" (U+00F0)
  0x00, 0xF1, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0E, 0x5E, // "ñ" (U+00F1)
  0x00, 0xF2, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0E, 0x77, // "ò" (U+00F2)
  0x00, 0xF3, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0E, 0x8D, // "ó" (U+00F3)
  0x00, 0xF4, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0E, 0xA3, // "ô" (U+00F4)
  0x00, 0xF5, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0E, 0xBA, // "õ" (U+00F5)
  0x00, 0xF6, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0E, 0xD2, // "ö" (U+00F6)
  0x00, 0xF7, 0x00, 0x01, 0x04, 0x06, 0x05, 0x0E, 0xE8, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x00, 0x04, 0x07, 0x05, 0x0E, 0xF7, // "ø" (U+00F8)
  0x00, 0xF9, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0F, 0x0A, // "ù" (U+00F9)
  0x00, 0xFA, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0F, 0x20, // "ú" (U+00FA)
  0x00, 0xFB, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0F, 0x36, // "û" (U+00FB)
  0x00, 0xFC, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0F, 0x4D, // "ü" (U+00FC)
  0x00, 0xFD, 0x00, 0xFE, 0x04, 0x08, 0x05, 0x0F, 0x63, // "ý" (U+00FD)
  0x00, 0xFE, 0x00, 0xFE, 0x04, 0x08, 0x05, 0x0F, 0x82, // "þ" (U+00FE)
  0x00, 0xFF, 0x00, 0xFE, 0x04, 0x08, 0x05, 0x0F, 0x9C, // "ÿ" (U+00FF)
  0x01, 0x00, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x0F, 0xBB, // "Ā" (U+0100)
  0x01, 0x01, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0F, 0xDC, // "ā" (U+0101)
  0x01, 0x02, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x0F, 0xF3, // "Ă" (U+0102)
  0x01, 0x03, 0x00, 0x01, 0x04, 0x09, 0x05, 0x10, 0x17, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x10, 0x31, // "Ą" (U+0104)
  0x01, 0x05, 0x00, 0xFE, 0x04, 0x06, 0x05, 0x10, 0x53, // "ą" (U+0105)
  0x01, 0x06, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x10, 0x6C, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x01, 0x03, 0x08, 0x04, 0x10, 0x86, // "ć" (U+0107)
  0x01, 0x08, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x10, 0x99, // "Ĉ" (U+0108)
  0x01, 0x09, 0x00, 0x01, 0x03, 0x09, 0x04, 0x10, 0xB4, // "ĉ" (U+0109)
  0x01, 0x0A, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x10, 0xC7, // "Ċ" (U+010A)
  0x01, 0x0B, 0x00, 0x01, 0x03, 0x08, 0x04, 0x10, 0xE0, // "ċ" (U+010B)
  0x01, 0x0C, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x10, 0xF2, // "Č" (U+010C)
  0x01, 0x0D, 0x00, 0x01, 0x03, 0x09, 0x04, 0x11, 0x0E, // "č" (U+010D)
  0x01, 0x0E, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x11, 0x21, // "Ď" (U+010E)
  0x01, 0x0F, 0x00, 0x01, 0x06, 0x08, 0x05, 0x11, 0x42, // "ď" (U+010F)
  0x01, 0x10, 0x00, 0x01, 0x05, 0x08, 0x06, 0x11, 0x60, // "Đ" (U+0110)
  0x01, 0x11, 0x00, 0x01, 0x05, 0x08, 0x05, 0x11, 0x7B, // "đ" (U+0111)
  0x01, 0x12, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x11, 0x95, // "Ē" (U+0112)
  0x01, 0x13, 0x00, 0x01, 0x04, 0x08, 0x05, 0x11, 0xAF, // "ē" (U+0113)
  0x01, 0x14, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x11, 0xC6, // "Ĕ" (U+0114)
  0x01, 0x15, 0x00, 0x01, 0x04, 0x09, 0x05, 0x11, 0xE3, // "ĕ" (U+0115)
  0x01, 0x16, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x11, 0xFC, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x01, 0x04, 0x08, 0x05, 0x12, 0x15, // "ė" (U+0117)
  0x01, 0x18, 0x00, 0xFE, 0x04, 0x08, 0x05, 0x12, 0x2A, // "Ę" (U+0118)
  0x01, 0x19, 0x00, 0xFE, 0x04, 0x06, 0x05, 0x12, 0x46, // "ę" (U+0119)
  0x01, 0x1A, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x12, 0x60, // "Ě" (U+011A)
  0x01, 0x1B, 0x00, 0x01, 0x04, 0x09, 0x05, 0x12, 0x7B, // "ě" (U+011B)
  0x01, 0x1C, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x12, 0x92, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x00, 0xFE, 0x04, 0x09, 0x05, 0x12, 0xB2, // "ĝ" (U+011D)
  0x01, 0x1E, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x12, 0xD1, // "Ğ" (U+011E)
  0x01, 0x1F, 0x00, 0xFE, 0x04, 0x09, 0x05, 0x12, 0xF3, // "ğ" (U+011F)
  0x01, 0x20, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x13, 0x14, // "Ġ" (U+0120)
  0x01, 0x21, 0x00, 0xFE, 0x04, 0x08, 0x05, 0x13, 0x31, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x13, 0x4E, // "Ģ" (U+0122)
  0x01, 0x23, 0x00, 0xFE, 0x04, 0x08, 0x05, 0x13, 0x6D, // "ģ" (U+0123)
  0x01, 0x24, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x13, 0x8A, // "Ĥ" (U+0124)
  0x01, 0x25, 0xFF, 0x01, 0x04, 0x0B, 0x05, 0x13, 0xAA, // "ĥ" (U+0125)
  0x01, 0x26, 0x00, 0x01, 0x06, 0x08, 0x06, 0x13, 0xC8, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x04, 0x08, 0x05, 0x13, 0xE4, // "ħ" (U+0127)
  0x01, 0x28, 0x00, 0x01, 0x03, 0x0B, 0x03, 0x13, 0xF8, // "Ĩ" (U+0128)
  0x01, 0x29, 0xFF, 0x01, 0x02, 0x09, 0x03, 0x14, 0x10, // "ĩ" (U+0129)
  0x01, 0x2A, 0x00, 0x01, 0x03, 0x0A, 0x03, 0x14, 0x22, // "Ī" (U+012A)
  0x01, 0x2B, 0xFF, 0x01, 0x02, 0x08, 0x03, 0x14, 0x38, // "ī" (U+012B)
  0x01, 0x2C, 0x00, 0x01, 0x03, 0x0B, 0x03, 0x14, 0x49, // "Ĭ" (U+012C)
  0x01, 0x2D, 0xFF, 0x01, 0x02, 0x09, 0x03, 0x14, 0x62, // "ĭ" (U+012D)
  0x01, 0x2E, 0x00, 0xFE, 0x03, 0x08, 0x03, 0x14, 0x76, // "Į" (U+012E)
  0x01, 0x2F, 0x00, 0xFE, 0x02, 0x08, 0x03, 0x14, 0x8F, // "į" (U+012F)
  0x01, 0x30, 0x00, 0x01, 0x03, 0x0A, 0x03, 0x14, 0xA2, // "İ" (U+0130)
  0x01, 0x31, 0x00, 0x01, 0x01, 0x06, 0x03, 0x14, 0xB8, // "ı" (U+0131)
  0x01, 0x32, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x14, 0xC0, // "Ĳ" (U+0132)
  0x01, 0x33, 0x00, 0xFE, 0x04, 0x08, 0x05, 0x14, 0xE2, // "ĳ" (U+0133)
  0x01, 0x34, 0xFF, 0xFE, 0x02, 0x0B, 0x03, 0x15, 0x00, // "Ĵ" (U+0134)
  0x01, 0x35, 0xFF, 0xFE, 0x02, 0x09, 0x03, 0x15, 0x1C, // "ĵ" (U+0135)
  0x01, 0x36, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x15, 0x35, // "Ķ" (U+0136)
  0x01, 0x37, 0x00, 0xFE, 0x04, 0x08, 0x05, 0x15, 0x56, // "ķ" (U+0137)
  0x01, 0x38, 0x00, 0x01, 0x04, 0x06, 0x05, 0x15, 0x70, // "ĸ" (U+0138)
  0x01, 0x39, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x15, 0x81, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x00, 0x01, 0x02, 0x0A, 0x03, 0x15, 0x9E, // "ĺ" (U+013A)
  0x01, 0x3B, 0x00, 0xFE, 0x04, 0x08, 0x05, 0x15, 0xAF, // "Ļ" (U+013B)
  0x01, 0x3C, 0x00, 0xFE, 0x01, 0x08, 0x03, 0x15, 0xCC, // "ļ" (U+013C)
  0x01, 0x3D, 0x00, 0x01, 0x04, 0x08, 0x05, 0x15, 0xD9, // "Ľ" (U+013D)
  0x01, 0x3E, 0x00, 0x01, 0x03, 0x08, 0x03, 0x15, 0xF0, // "ľ" (U+013E)
  0x01, 0x3F, 0x00, 0x01, 0x04, 0x08, 0x05, 0x16, 0x01, // "Ŀ" (U+013F)
  0x01, 0x40, 0x00, 0x01, 0x03, 0x08, 0x03, 0x16, 0x18, // "ŀ" (U+0140)
  0x01, 0x41, 0x00, 0x01, 0x04, 0x08, 0x05, 0x16, 0x29, // "Ł" (U+0141)
  0x01, 0x42, 0x00, 0x01, 0x02, 0x08, 0x03, 0x16, 0x40, // "ł" (U+0142)
  0x01, 0x43, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x16, 0x4E, // "Ń" (U+0143)
  0x01, 0x44, 0x00, 0x01, 0x04, 0x08, 0x05, 0x16, 0x73, // "ń" (U+0144)
  0x01, 0x45, 0x00, 0xFE, 0x06, 0x08, 0x07, 0x16, 0x89, // "Ņ" (U+0145)
  0x01, 0x46, 0x00, 0xFE, 0x04, 0x06, 0x05, 0x16, 0xAE, // "ņ" (U+0146)
  0x01, 0x47, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x16, 0xC4, // "Ň" (U+0147)
  0x01, 0x48, 0x00, 0x01, 0x04, 0x09, 0x05, 0x16, 0xEB, // "ň" (U+0148)
  0x01, 0x49, 0x00, 0x01, 0x05, 0x08, 0x07, 0x17, 0x03, // "ŉ" (U+0149)
  0x01, 0x4A, 0x00, 0xFE, 0x06, 0x08, 0x07, 0x17, 0x1C, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x00, 0xFE, 0x04, 0x06, 0x05, 0x17, 0x44, // "ŋ" (U+014B)
  0x01, 0x4C, 0x00, 0x01, 0x05, 0x0A, 0x07, 0x17, 0x5D, // "Ō" (U+014C)
  0x01, 0x4D, 0x00, 0x01, 0x04, 0x08, 0x05, 0x17, 0x7F, // "ō" (U+014D)
  0x01, 0x4E, 0x00, 0x01, 0x05, 0x0B, 0x07, 0x17, 0x95, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x00, 0x01, 0x04, 0x09, 0x05, 0x17, 0xBA, // "ŏ" (U+014F)
  0x01, 0x50, 0x00, 0x01, 0x05, 0x0A, 0x07, 0x17, 0xD3, // "Ő" (U+0150)
  0x01, 0x51, 0x00, 0x01, 0x04, 0x08, 0x05, 0x17, 0xF5, // "ő" (U+0151)
  0x01, 0x52, 0x00, 0x01, 0x07, 0x08, 0x08, 0x18, 0x0B, // "Œ" (U+0152)
  0x01, 0x53, 0x00, 0x01, 0x07, 0x06, 0x08, 0x18, 0x2D, // "œ" (U+0153)
  0x01, 0x54, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x18, 0x47, // "Ŕ" (U+0154)
  0x01, 0x55, 0x00, 0x01, 0x03, 0x08, 0x04, 0x18, 0x67, // "ŕ" (U+0155)
  0x01, 0x56, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x18, 0x78, // "Ŗ" (U+0156)
  0x01, 0x57, 0x00, 0xFE, 0x03, 0x06, 0x04, 0x18, 0x98, // "ŗ" (U+0157)
  0x01, 0x58, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x18, 0xAA, // "Ř" (U+0158)
  0x01, 0x59, 0x00, 0x01, 0x03, 0x09, 0x04, 0x18, 0xCB, // "ř" (U+0159)
  0x01, 0x5A, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x18, 0xDD, // "Ś" (U+015A)
  0x01, 0x5B, 0x00, 0x01, 0x03, 0x08, 0x04, 0x18, 0xFA, // "ś" (U+015B)
  0x01, 0x5C, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x19, 0x0D, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x00, 0x01, 0x03, 0x09, 0x04, 0x19, 0x2B, // "ŝ" (U+015D)
  0x01, 0x5E, 0x00, 0xFE, 0x04, 0x08, 0x05, 0x19, 0x3F, // "Ş" (U+015E)
  0x01, 0x5F, 0x00, 0xFE, 0x03, 0x06, 0x04, 0x19, 0x5F, // "ş" (U+015F)
  0x01, 0x60, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x19, 0x74, // "Š" (U+0160)
  0x01, 0x61, 0x00, 0x01, 0x03, 0x09, 0x04, 0x19, 0x92, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFE, 0x04, 0x08, 0x05, 0x19, 0xA6, // "Ţ" (U+0162)
  0x01, 0x63, 0x00, 0xFE, 0x03, 0x07, 0x04, 0x19, 0xC6, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x19, 0xDD, // "Ť" (U+0164)
  0x01, 0x65, 0x00, 0x01, 0x04, 0x08, 0x04, 0x19, 0xFB, // "ť" (U+0165)
  0x01, 0x66, 0x00, 0x01, 0x04, 0x08, 0x05, 0x1A, 0x12, // "Ŧ" (U+0166)
  0x01, 0x67, 0x00, 0x01, 0x03, 0x07, 0x04, 0x1A, 0x29, // "ŧ" (U+0167)
  0x01, 0x68, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x1A, 0x3A, // "Ũ" (U+0168)
  0x01, 0x69, 0x00, 0x01, 0x04, 0x09, 0x05, 0x1A, 0x5D, // "ũ" (U+0169)
  0x01, 0x6A, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x1A, 0x76, // "Ū" (U+016A)
  0x01, 0x6B, 0x00, 0x01, 0x04, 0x08, 0x05, 0x1A, 0x96, // "ū" (U+016B)
  0x01, 0x6C, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x1A, 0xAC, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x00, 0x01, 0x04, 0x09, 0x05, 0x1A, 0xCF, // "ŭ" (U+016D)
  0x01, 0x6E, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x1A, 0xE8, // "Ů" (U+016E)
  0x01, 0x6F, 0x00, 0x01, 0x04, 0x09, 0x05, 0x1B, 0x0A, // "ů" (U+016F)
  0x01, 0x70, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x1B, 0x23, // "Ű" (U+0170)
  0x01, 0x71, 0x00, 0x01, 0x04, 0x08, 0x05, 0x1B, 0x44, // "ű" (U+0171)
  0x01, 0x72, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x1B, 0x5A, // "Ų" (U+0172)
  0x01, 0x73, 0x00, 0xFE, 0x05, 0x06, 0x05, 0x1B, 0x7C, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x08, 0x0B, 0x08, 0x1B, 0x97, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x07, 0x09, 0x07, 0x1B, 0xC5, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x1B, 0xE7, // "Ŷ" (U+0176)
  0x01, 0x77, 0x00, 0xFE, 0x04, 0x09, 0x05, 0x1C, 0x05, // "ŷ" (U+0177)
  0x01, 0x78, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x1C, 0x25, // "Ÿ" (U+0178)
  0x01, 0x79, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x1C, 0x42, // "Ź" (U+0179)
  0x01, 0x7A, 0x00, 0x01, 0x03, 0x08, 0x04, 0x1C, 0x5E, // "ź" (U+017A)
  0x01, 0x7B, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x1C, 0x70, // "Ż" (U+017B)
  0x01, 0x7C, 0x00, 0x01, 0x03, 0x08, 0x04, 0x1C, 0x8B, // "ż" (U+017C)
  0x01, 0x7D, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x1C, 0x9D, // "Ž" (U+017D)
  0x01, 0x7E, 0x00, 0x01, 0x03, 0x09, 0x04, 0x1C, 0xBA, // "ž" (U+017E)
  0x01, 0x7F, 0x00, 0x01, 0x03, 0x08, 0x03, 0x1C, 0xCD, // "ſ" (U+017F)
  0x03, 0xA9, 0x00, 0x01, 0x06, 0x08, 0x07, 0x1C, 0xDF, // "Ω" (U+03A9)
  0x03, 0xBC, 0x00, 0xFE, 0x04, 0x06, 0x05, 0x1C, 0xFF, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x01, 0x05, 0x06, 0x06, 0x1D, 0x15, // "π" (U+03C0)
  0x20, 0x13, 0x00, 0x02, 0x04, 0x03, 0x05, 0x1D, 0x29, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x02, 0x09, 0x03, 0x0A, 0x1D, 0x2F, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x01, 0x04, 0x08, 0x05, 0x1D, 0x36, // "€" (U+20AC)
  0x20, 0xBF, 0x00, 0x00, 0x04, 0x09, 0x05, 0x1D, 0x4D, // "₿" (U+20BF)
  0x20, 0x18, 0x00, 0x06, 0x01, 0x08, 0x02, 0x1D, 0x69, // "‘" (U+2018)
  0x20, 0x19, 0x00, 0x06, 0x01, 0x08, 0x02, 0x1D, 0x6D, // "’" (U+2019)
  0x20, 0x1A, 0x00, 0x00, 0x01, 0x02, 0x03, 0x1D, 0x71, // "‚" (U+201A)
  0x20, 0x1B, 0x00, 0x06, 0x01, 0x08, 0x02, 0x1D, 0x75, // "‛" (U+201B)
  0x20, 0x1C, 0x00, 0x06, 0x04, 0x08, 0x04, 0x1D, 0x79, // "“" (U+201C)
  0x20, 0x1D, 0x00, 0x06, 0x04, 0x08, 0x04, 0x1D, 0x82, // "”" (U+201D)
  0x20, 0x1E, 0x00, 0x00, 0x04, 0x02, 0x05, 0x1D, 0x8B, // "„" (U+201E)
  0x20, 0x1F, 0x00, 0x06, 0x04, 0x08, 0x04, 0x1D, 0x94, // "‟" (U+201F)
  0x20, 0x20, 0x00, 0x01, 0x04, 0x08, 0x05, 0x1D, 0x9D, // "†" (U+2020)
  0x20, 0x21, 0x00, 0x01, 0x04, 0x08, 0x05, 0x1D, 0xB2, // "‡" (U+2021)
  0x20, 0x22, 0x00, 0x04, 0x03, 0x06, 0x04, 0x1D, 0xC7, // "•" (U+2022)
  0x20, 0x26, 0x00, 0x01, 0x06, 0x02, 0x08, 0x1D, 0xCF, // "…" (U+2026)
  0x20, 0x30, 0x00, 0x01, 0x0B, 0x08, 0x0C, 0x1D, 0xD8, // "‰" (U+2030)
  0x20, 0x39, 0x00, 0x01, 0x02, 0x05, 0x03, 0x1E, 0x07, // "‹" (U+2039)
  0x20, 0x3A, 0x00, 0x01, 0x02, 0x05, 0x03, 0x1E, 0x10, // "›" (U+203A)
  0x20, 0x44, 0xFE, 0x01, 0x02, 0x08, 0x01, 0x1E, 0x19, // "⁄" (U+2044)
  0x21, 0x22, 0x00, 0x04, 0x06, 0x07, 0x07, 0x1E, 0x2E, // "™" (U+2122)
  0x21, 0x52, 0x00, 0x01, 0x0B, 0x08, 0x0B, 0x1E, 0x3E, // "⅒" (U+2152)
  0xFB, 0x01, 0x00, 0x01, 0x04, 0x08, 0x06, 0x1E, 0x6D, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0x00, 0x01, 0x04, 0x08, 0x06, 0x1E, 0x84, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x01, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0xC0, 0x01, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x01, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x01, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x01, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x01, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x01, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xC6, 0x01, // "Æ (U+0022 U+00C6)
  0x00, 0x22, 0x01, 0x00, 0x01, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x02, 0x01, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x04, 0x01, // "Ą (U+0022 U+0104)
  0x00, 0x27, 0x00, 0x41, 0x01, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0xC0, 0x01, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x01, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x01, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x01, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x01, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x01, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xC6, 0x01, // 'Æ (U+0027 U+00C6)
  0x00, 0x27, 0x01, 0x00, 0x01, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x02, 0x01, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x04, 0x01, // 'Ą (U+0027 U+0104)
  0x00, 0x2C, 0x00, 0x54, 0x01, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x01, 0x62, 0x01, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x01, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x01, // ,Ŧ (U+002C U+0166)
  0x00, 0x2E, 0x00, 0x54, 0x01, // .T (U+002E U+0054)
  0x00, 0x2E, 0x01, 0x62, 0x01, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x01, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x01, // .Ŧ (U+002E U+0166)
  0x00, 0x30, 0x20, 0x44, 0x02, // 0⁄ (U+0030 U+2044)
  0x00, 0x31, 0x20, 0x44, 0x02, // 1⁄ (U+0031 U+2044)
  0x00, 0x32, 0x20, 0x44, 0x02, // 2⁄ (U+0032 U+2044)
  0x00, 0x33, 0x20, 0x44, 0x02, // 3⁄ (U+0033 U+2044)
  0x00, 0x34, 0x20, 0x44, 0x02, // 4⁄ (U+0034 U+2044)
  0x00, 0x35, 0x20, 0x44, 0x02, // 5⁄ (U+0035 U+2044)
  0x00, 0x36, 0x20, 0x44, 0x02, // 6⁄ (U+0036 U+2044)
  0x00, 0x37, 0x20, 0x44, 0x02, // 7⁄ (U+0037 U+2044)
  0x00, 0x38, 0x20, 0x44, 0x02, // 8⁄ (U+0038 U+2044)
  0x00, 0x39, 0x20, 0x44, 0x02, // 9⁄ (U+0039 U+2044)
  0x00, 0x41, 0x00, 0x22, 0x01, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x01, // A' (U+0041 U+0027)
  0x00, 0x41, 0x20, 0x19, 0x01, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1D, 0x01, // A” (U+0041 U+201D)
  0x00, 0x46, 0x00, 0x2C, 0x01, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x01, // F. (U+0046 U+002E)
  0x00, 0x46, 0x20, 0x1A, 0x01, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x01, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x01, // F… (U+0046 U+2026)
  0x00, 0x4C, 0x00, 0x22, 0x01, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x01, // L' (U+004C U+0027)
  0x00, 0x4C, 0x20, 0x19, 0x01, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1D, 0x01, // L” (U+004C U+201D)
  0x00, 0x50, 0x00, 0x2C, 0x01, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x01, // P. (U+0050 U+002E)
  0x00, 0x50, 0x20, 0x1A, 0x01, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x01, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x01, // P… (U+0050 U+2026)
  0x00, 0x54, 0x00, 0x61, 0x01, // Ta (U+0054 U+0061)
  0x00, 0x54, 0x00, 0x63, 0x01, // Tc (U+0054 U+0063)
  0x00, 0x54, 0x00, 0x64, 0x01, // Td (U+0054 U+0064)
  0x00, 0x54, 0x00, 0x65, 0x01, // Te (U+0054 U+0065)
  0x00, 0x54, 0x00, 0x67, 0x01, // Tg (U+0054 U+0067)
  0x00, 0x54, 0x00, 0x6F, 0x01, // To (U+0054 U+006F)
  0x00, 0x54, 0x00, 0x71, 0x01, // Tq (U+0054 U+0071)
  0x00, 0x54, 0x00, 0xE0, 0x01, // Tà (U+0054 U+00E0)
  0x00, 0x54, 0x00, 0xE1, 0x01, // Tá (U+0054 U+00E1)
  0x00, 0x54, 0x00, 0xE2, 0x01, // Tâ (U+0054 U+00E2)
  0x00, 0x54, 0x00, 0xE3, 0x01, // Tã (U+0054 U+00E3)
  0x00, 0x54, 0x00, 0xE4, 0x01, // Tä (U+0054 U+00E4)
  0x00, 0x54, 0x00, 0xE5, 0x01, // Tå (U+0054 U+00E5)
  0x00, 0x54, 0x00, 0xE6, 0x01, // Tæ (U+0054 U+00E6)
  0x00, 0x54, 0x00, 0xE7, 0x01, // Tç (U+0054 U+00E7)
  0x00, 0x54, 0x00, 0xE8, 0x01, // Tè (U+0054 U+00E8)
  0x00, 0x54, 0x00, 0xE9, 0x01, // Té (U+0054 U+00E9)
  0x00, 0x54, 0x00, 0xEA, 0x01, // Tê (U+0054 U+00EA)
  0x00, 0x54, 0x00, 0xEB, 0x01, // Të (U+0054 U+00EB)
  0x00, 0x54, 0x00, 0xF2, 0x01, // Tò (U+0054 U+00F2)
  0x00, 0x54, 0x00, 0xF3, 0x01, // Tó (U+0054 U+00F3)
  0x00, 0x54, 0x00, 0xF4, 0x01, // Tô (U+0054 U+00F4)
  0x00, 0x54, 0x00, 0xF5, 0x01, // Tõ (U+0054 U+00F5)
  0x00, 0x54, 0x00, 0xF6, 0x01, // Tö (U+0054 U+00F6)
  0x00, 0x54, 0x00, 0xF8, 0x01, // Tø (U+0054 U+00F8)
  0x00, 0x54, 0x01, 0x01, 0x01, // Tā (U+0054 U+0101)
  0x00, 0x54, 0x01, 0x03, 0x01, // Tă (U+0054 U+0103)
  0x00, 0x54, 0x01, 0x05, 0x01, // Tą (U+0054 U+0105)
  0x00, 0x54, 0x01, 0x07, 0x01, // Tć (U+0054 U+0107)
  0x00, 0x54, 0x01, 0x09, 0x01, // Tĉ (U+0054 U+0109)
  0x00, 0x54, 0x01, 0x0B, 0x01, // Tċ (U+0054 U+010B)
  0x00, 0x54, 0x01, 0x0D, 0x01, // Tč (U+0054 U+010D)
  0x00, 0x54, 0x01, 0x0F, 0x01, // Tď (U+0054 U+010F)
  0x00, 0x54, 0x01, 0x11, 0x01, // Tđ (U+0054 U+0111)
  0x00, 0x54, 0x01, 0x13, 0x01, // Tē (U+0054 U+0113)
  0x00, 0x54, 0x01, 0x15, 0x01, // Tĕ (U+0054 U+0115)
  0x00, 0x54, 0x01, 0x17, 0x01, // Tė (U+0054 U+0117)
  0x00, 0x54, 0x01, 0x19, 0x01, // Tę (U+0054 U+0119)
  0x00, 0x54, 0x01, 0x1B, 0x01, // Tě (U+0054 U+011B)
  0x00, 0x54, 0x01, 0x1D, 0x01, // Tĝ (U+0054 U+011D)
  0x00, 0x54, 0x01, 0x1F, 0x01, // Tğ (U+0054 U+011F)
  0x00, 0x54, 0x01, 0x21, 0x01, // Tġ (U+0054 U+0121)
  0x00, 0x54, 0x01, 0x23, 0x01, // Tģ (U+0054 U+0123)
  0x00, 0x54, 0x01, 0x4D, 0x01, // Tō (U+0054 U+014D)
  0x00, 0x54, 0x01, 0x4F, 0x01, // Tŏ (U+0054 U+014F)
  0x00, 0x54, 0x01, 0x51, 0x01, // Tő (U+0054 U+0151)
  0x00, 0x54, 0x01, 0x53, 0x01, // Tœ (U+0054 U+0153)
  0x00, 0x59, 0x00, 0xAB, 0x01, // Y« (U+0059 U+00AB)
  0x00, 0x59, 0x20, 0x39, 0x01, // Y‹ (U+0059 U+2039)
  0x00, 0x72, 0x00, 0x2C, 0x01, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x01, // r. (U+0072 U+002E)
  0x00, 0x72, 0x20, 0x1A, 0x01, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x01, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x01, // r… (U+0072 U+2026)
  0x00, 0xBB, 0x00, 0x59, 0x01, // »Y (U+00BB U+0059)
  0x00, 0xBB, 0x00, 0xDD, 0x01, // »Ý (U+00BB U+00DD)
  0x00, 0xBB, 0x01, 0x76, 0x01, // »Ŷ (U+00BB U+0176)
  0x00, 0xBB, 0x01, 0x78, 0x01, // »Ÿ (U+00BB U+0178)
  0x00, 0xC0, 0x00, 0x22, 0x01, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x01, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x20, 0x19, 0x01, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1D, 0x01, // À” (U+00C0 U+201D)
  0x00, 0xC1, 0x00, 0x22, 0x01, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x01, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x20, 0x19, 0x01, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1D, 0x01, // Á” (U+00C1 U+201D)
  0x00, 0xC2, 0x00, 0x22, 0x01, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x01, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x20, 0x19, 0x01, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1D, 0x01, // Â” (U+00C2 U+201D)
  0x00, 0xC3, 0x00, 0x22, 0x01, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x01, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x20, 0x19, 0x01, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1D, 0x01, // Ã” (U+00C3 U+201D)
  0x00, 0xC4, 0x00, 0x22, 0x01, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x01, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x20, 0x19, 0x01, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1D, 0x01, // Ä” (U+00C4 U+201D)
  0x00, 0xC5, 0x00, 0x22, 0x01, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x01, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x20, 0x19, 0x01, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1D, 0x01, // Å” (U+00C5 U+201D)
  0x00, 0xDD, 0x00, 0xAB, 0x01, // Ý« (U+00DD U+00AB)
  0x00, 0xDD, 0x20, 0x39, 0x01, // Ý‹ (U+00DD U+2039)
  0x00, 0xDE, 0x00, 0x2C, 0x01, // Þ, (U+00DE U+002C)
  0x00, 0xDE, 0x00, 0x2E, 0x01, // Þ. (U+00DE U+002E)
  0x00, 0xDE, 0x20, 0x1A, 0x01, // Þ‚ (U+00DE U+201A)
  0x00, 0xDE, 0x20, 0x1E, 0x01, // Þ„ (U+00DE U+201E)
  0x00, 0xDE, 0x20, 0x26, 0x01, // Þ… (U+00DE U+2026)
  0x01, 0x00, 0x00, 0x22, 0x01, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x01, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x20, 0x19, 0x01, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1D, 0x01, // Ā” (U+0100 U+201D)
  0x01, 0x02, 0x00, 0x22, 0x01, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x01, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x20, 0x19, 0x01, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1D, 0x01, // Ă” (U+0102 U+201D)
  0x01, 0x04, 0x00, 0x22, 0x01, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x01, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x20, 0x19, 0x01, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1D, 0x01, // Ą” (U+0104 U+201D)
  0x01, 0x39, 0x00, 0x22, 0x01, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x01, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x20, 0x19, 0x01, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1D, 0x01, // Ĺ” (U+0139 U+201D)
  0x01, 0x3B, 0x00, 0x22, 0x01, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x01, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x20, 0x19, 0x01, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1D, 0x01, // Ļ” (U+013B U+201D)
  0x01, 0x3D, 0x00, 0x22, 0x01, // Ľ" (U+013D U+0022)
  0x01, 0x3D, 0x00, 0x27, 0x01, // Ľ' (U+013D U+0027)
  0x01, 0x3D, 0x20, 0x19, 0x01, // Ľ’ (U+013D U+2019)
  0x01, 0x3D, 0x20, 0x1D, 0x01, // Ľ” (U+013D U+201D)
  0x01, 0x3F, 0x00, 0x22, 0x01, // Ŀ" (U+013F U+0022)
  0x01, 0x3F, 0x00, 0x27, 0x01, // Ŀ' (U+013F U+0027)
  0x01, 0x3F, 0x20, 0x19, 0x01, // Ŀ’ (U+013F U+2019)
  0x01, 0x3F, 0x20, 0x1D, 0x01, // Ŀ” (U+013F U+201D)
  0x01, 0x41, 0x00, 0x22, 0x01, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x01, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x20, 0x19, 0x01, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1D, 0x01, // Ł” (U+0141 U+201D)
  0x01, 0x55, 0x00, 0x2C, 0x01, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x01, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x20, 0x1A, 0x01, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x01, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x01, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x01, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x01, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x20, 0x1A, 0x01, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x01, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x01, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x01, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x01, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x20, 0x1A, 0x01, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x01, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x01, // ř… (U+0159 U+2026)
  0x01, 0x62, 0x00, 0x61, 0x01, // Ţa (U+0162 U+0061)
  0x01, 0x62, 0x00, 0x63, 0x01, // Ţc (U+0162 U+0063)
  0x01, 0x62, 0x00, 0x64, 0x01, // Ţd (U+0162 U+0064)
  0x01, 0x62, 0x00, 0x65, 0x01, // Ţe (U+0162 U+0065)
  0x01, 0x62, 0x00, 0x67, 0x01, // Ţg (U+0162 U+0067)
  0x01, 0x62, 0x00, 0x6F, 0x01, // Ţo (U+0162 U+006F)
  0x01, 0x62, 0x00, 0x71, 0x01, // Ţq (U+0162 U+0071)
  0x01, 0x62, 0x00, 0xE0, 0x01, // Ţà (U+0162 U+00E0)
  0x01, 0x62, 0x00, 0xE1, 0x01, // Ţá (U+0162 U+00E1)
  0x01, 0x62, 0x00, 0xE2, 0x01, // Ţâ (U+0162 U+00E2)
  0x01, 0x62, 0x00, 0xE3, 0x01, // Ţã (U+0162 U+00E3)
  0x01, 0x62, 0x00, 0xE4, 0x01, // Ţä (U+0162 U+00E4)
  0x01, 0x62, 0x00, 0xE5, 0x01, // Ţå (U+0162 U+00E5)
  0x01, 0x62, 0x00, 0xE6, 0x01, // Ţæ (U+0162 U+00E6)
  0x01, 0x62, 0x00, 0xE7, 0x01, // Ţç (U+0162 U+00E7)
  0x01, 0x62, 0x00, 0xE8, 0x01, // Ţè (U+0162 U+00E8)
  0x01, 0x62, 0x00, 0xE9, 0x01, // Ţé (U+0162 U+00E9)
  0x01, 0x62, 0x00, 0xEA, 0x01, // Ţê (U+0162 U+00EA)
  0x01, 0x62, 0x00, 0xEB, 0x01, // Ţë (U+0162 U+00EB)
  0x01, 0x62, 0x00, 0xF2, 0x01, // Ţò (U+0162 U+00F2)
  0x01, 0x62, 0x00, 0xF3, 0x01, // Ţó (U+0162 U+00F3)
  0x01, 0x62, 0x00, 0xF4, 0x01, // Ţô (U+0162 U+00F4)
  0x01, 0x62, 0x00, 0xF5, 0x01, // Ţõ (U+0162 U+00F5)
  0x01, 0x62, 0x00, 0xF6, 0x01, // Ţö (U+0162 U+00F6)
  0x01, 0x62, 0x00, 0xF8, 0x01, // Ţø (U+0162 U+00F8)
  0x01, 0x62, 0x01, 0x01, 0x01, // Ţā (U+0162 U+0101)
  0x01, 0x62, 0x01, 0x03, 0x01, // Ţă (U+0162 U+0103)
  0x01, 0x62, 0x01, 0x05, 0x01, // Ţą (U+0162 U+0105)
  0x01, 0x62, 0x01, 0x07, 0x01, // Ţć (U+0162 U+0107)
  0x01, 0x62, 0x01, 0x09, 0x01, // Ţĉ (U+0162 U+0109)
  0x01, 0x62, 0x01, 0x0B, 0x01, // Ţċ (U+0162 U+010B)
  0x01, 0x62, 0x01, 0x0D, 0x01, // Ţč (U+0162 U+010D)
  0x01, 0x62, 0x01, 0x0F, 0x01, // Ţď (U+0162 U+010F)
  0x01, 0x62, 0x01, 0x11, 0x01, // Ţđ (U+0162 U+0111)
  0x01, 0x62, 0x01, 0x13, 0x01, // Ţē (U+0162 U+0113)
  0x01, 0x62, 0x01, 0x15, 0x01, // Ţĕ (U+0162 U+0115)
  0x01, 0x62, 0x01, 0x17, 0x01, // Ţė (U+0162 U+0117)
  0x01, 0x62, 0x01, 0x19, 0x01, // Ţę (U+0162 U+0119)
  0x01, 0x62, 0x01, 0x1B, 0x01, // Ţě (U+0162 U+011B)
  0x01, 0x62, 0x01, 0x1D, 0x01, // Ţĝ (U+0162 U+011D)
  0x01, 0x62, 0x01, 0x1F, 0x01, // Ţğ (U+0162 U+011F)
  0x01, 0x62, 0x01, 0x21, 0x01, // Ţġ (U+0162 U+0121)
  0x01, 0x62, 0x01, 0x23, 0x01, // Ţģ (U+0162 U+0123)
  0x01, 0x62, 0x01, 0x4D, 0x01, // Ţō (U+0162 U+014D)
  0x01, 0x62, 0x01, 0x4F, 0x01, // Ţŏ (U+0162 U+014F)
  0x01, 0x62, 0x01, 0x51, 0x01, // Ţő (U+0162 U+0151)
  0x01, 0x62, 0x01, 0x53, 0x01, // Ţœ (U+0162 U+0153)
  0x01, 0x64, 0x00, 0x61, 0x01, // Ťa (U+0164 U+0061)
  0x01, 0x64, 0x00, 0x63, 0x01, // Ťc (U+0164 U+0063)
  0x01, 0x64, 0x00, 0x64, 0x01, // Ťd (U+0164 U+0064)
  0x01, 0x64, 0x00, 0x65, 0x01, // Ťe (U+0164 U+0065)
  0x01, 0x64, 0x00, 0x67, 0x01, // Ťg (U+0164 U+0067)
  0x01, 0x64, 0x00, 0x6F, 0x01, // Ťo (U+0164 U+006F)
  0x01, 0x64, 0x00, 0x71, 0x01, // Ťq (U+0164 U+0071)
  0x01, 0x64, 0x00, 0xE0, 0x01, // Ťà (U+0164 U+00E0)
  0x01, 0x64, 0x00, 0xE1, 0x01, // Ťá (U+0164 U+00E1)
  0x01, 0x64, 0x00, 0xE2, 0x01, // Ťâ (U+0164 U+00E2)
  0x01, 0x64, 0x00, 0xE3, 0x01, // Ťã (U+0164 U+00E3)
  0x01, 0x64, 0x00, 0xE4, 0x01, // Ťä (U+0164 U+00E4)
  0x01, 0x64, 0x00, 0xE5, 0x01, // Ťå (U+0164 U+00E5)
  0x01, 0x64, 0x00, 0xE6, 0x01, // Ťæ (U+0164 U+00E6)
  0x01, 0x64, 0x00, 0xE7, 0x01, // Ťç (U+0164 U+00E7)
  0x01, 0x64, 0x00, 0xE8, 0x01, // Ťè (U+0164 U+00E8)
  0x01, 0x64, 0x00, 0xE9, 0x01, // Ťé (U+0164 U+00E9)
  0x01, 0x64, 0x00, 0xEA, 0x01, // Ťê (U+0164 U+00EA)
  0x01, 0x64, 0x00, 0xEB, 0x01, // Ťë (U+0164 U+00EB)
  0x01, 0x64, 0x00, 0xF2, 0x01, // Ťò (U+0164 U+00F2)
  0x01, 0x64, 0x00, 0xF3, 0x01, // Ťó (U+0164 U+00F3)
  0x01, 0x64, 0x00, 0xF4, 0x01, // Ťô (U+0164 U+00F4)
  0x01, 0x64, 0x00, 0xF5, 0x01, // Ťõ (U+0164 U+00F5)
  0x01, 0x64, 0x00, 0xF6, 0x01, // Ťö (U+0164 U+00F6)
  0x01, 0x64, 0x00, 0xF8, 0x01, // Ťø (U+0164 U+00F8)
  0x01, 0x64, 0x01, 0x01, 0x01, // Ťā (U+0164 U+0101)
  0x01, 0x64, 0x01, 0x03, 0x01, // Ťă (U+0164 U+0103)
  0x01, 0x64, 0x01, 0x05, 0x01, // Ťą (U+0164 U+0105)
  0x01, 0x64, 0x01, 0x07, 0x01, // Ťć (U+0164 U+0107)
  0x01, 0x64, 0x01, 0x09, 0x01, // Ťĉ (U+0164 U+0109)
  0x01, 0x64, 0x01, 0x0B, 0x01, // Ťċ (U+0164 U+010B)
  0x01, 0x64, 0x01, 0x0D, 0x01, // Ťč (U+0164 U+010D)
  0x01, 0x64, 0x01, 0x0F, 0x01, // Ťď (U+0164 U+010F)
  0x01, 0x64, 0x01, 0x11, 0x01, // Ťđ (U+0164 U+0111)
  0x01, 0x64, 0x01, 0x13, 0x01, // Ťē (U+0164 U+0113)
  0x01, 0x64, 0x01, 0x15, 0x01, // Ťĕ (U+0164 U+0115)
  0x01, 0x64, 0x01, 0x17, 0x01, // Ťė (U+0164 U+0117)
  0x01, 0x64, 0x01, 0x19, 0x01, // Ťę (U+0164 U+0119)
  0x01, 0x64, 0x01, 0x1B, 0x01, // Ťě (U+0164 U+011B)
  0x01, 0x64, 0x01, 0x1D, 0x01, // Ťĝ (U+0164 U+011D)
  0x01, 0x64, 0x01, 0x1F, 0x01, // Ťğ (U+0164 U+011F)
  0x01, 0x64, 0x01, 0x21, 0x01, // Ťġ (U+0164 U+0121)
  0x01, 0x64, 0x01, 0x23, 0x01, // Ťģ (U+0164 U+0123)
  0x01, 0x64, 0x01, 0x4D, 0x01, // Ťō (U+0164 U+014D)
  0x01, 0x64, 0x01, 0x4F, 0x01, // Ťŏ (U+0164 U+014F)
  0x01, 0x64, 0x01, 0x51, 0x01, // Ťő (U+0164 U+0151)
  0x01, 0x64, 0x01, 0x53, 0x01, // Ťœ (U+0164 U+0153)
  0x01, 0x66, 0x00, 0x61, 0x01, // Ŧa (U+0166 U+0061)
  0x01, 0x66, 0x00, 0x63, 0x01, // Ŧc (U+0166 U+0063)
  0x01, 0x66, 0x00, 0x64, 0x01, // Ŧd (U+0166 U+0064)
  0x01, 0x66, 0x00, 0x65, 0x01, // Ŧe (U+0166 U+0065)
  0x01, 0x66, 0x00, 0x67, 0x01, // Ŧg (U+0166 U+0067)
  0x01, 0x66, 0x00, 0x6F, 0x01, // Ŧo (U+0166 U+006F)
  0x01, 0x66, 0x00, 0x71, 0x01, // Ŧq (U+0166 U+0071)
  0x01, 0x66, 0x00, 0xE0, 0x01, // Ŧà (U+0166 U+00E0)
  0x01, 0x66, 0x00, 0xE1, 0x01, // Ŧá (U+0166 U+00E1)
  0x01, 0x66, 0x00, 0xE2, 0x01, // Ŧâ (U+0166 U+00E2)
  0x01, 0x66, 0x00, 0xE3, 0x01, // Ŧã (U+0166 U+00E3)
  0x01, 0x66, 0x00, 0xE4, 0x01, // Ŧä (U+0166 U+00E4)
  0x01, 0x66, 0x00, 0xE5, 0x01, // Ŧå (U+0166 U+00E5)
  0x01, 0x66, 0x00, 0xE6, 0x01, // Ŧæ (U+0166 U+00E6)
  0x01, 0x66, 0x00, 0xE7, 0x01, // Ŧç (U+0166 U+00E7)
  0x01, 0x66, 0x00, 0xE8, 0x01, // Ŧè (U+0166 U+00E8)
  0x01, 0x66, 0x00, 0xE9, 0x01, // Ŧé (U+0166 U+00E9)
  0x01, 0x66, 0x00, 0xEA, 0x01, // Ŧê (U+0166 U+00EA)
  0x01, 0x66, 0x00, 0xEB, 0x01, // Ŧë (U+0166 U+00EB)
  0x01, 0x66, 0x00, 0xF2, 0x01, // Ŧò (U+0166 U+00F2)
  0x01, 0x66, 0x00, 0xF3, 0x01, // Ŧó (U+0166 U+00F3)
  0x01, 0x66, 0x00, 0xF4, 0x01, // Ŧô (U+0166 U+00F4)
  0x01, 0x66, 0x00, 0xF5, 0x01, // Ŧõ (U+0166 U+00F5)
  0x01, 0x66, 0x00, 0xF6, 0x01, // Ŧö (U+0166 U+00F6)
  0x01, 0x66, 0x00, 0xF8, 0x01, // Ŧø (U+0166 U+00F8)
  0x01, 0x66, 0x01, 0x01, 0x01, // Ŧā (U+0166 U+0101)
  0x01, 0x66, 0x01, 0x03, 0x01, // Ŧă (U+0166 U+0103)
  0x01, 0x66, 0x01, 0x05, 0x01, // Ŧą (U+0166 U+0105)
  0x01, 0x66, 0x01, 0x07, 0x01, // Ŧć (U+0166 U+0107)
  0x01, 0x66, 0x01, 0x09, 0x01, // Ŧĉ (U+0166 U+0109)
  0x01, 0x66, 0x01, 0x0B, 0x01, // Ŧċ (U+0166 U+010B)
  0x01, 0x66, 0x01, 0x0D, 0x01, // Ŧč (U+0166 U+010D)
  0x01, 0x66, 0x01, 0x0F, 0x01, // Ŧď (U+0166 U+010F)
  0x01, 0x66, 0x01, 0x11, 0x01, // Ŧđ (U+0166 U+0111)
  0x01, 0x66, 0x01, 0x13, 0x01, // Ŧē (U+0166 U+0113)
  0x01, 0x66, 0x01, 0x15, 0x01, // Ŧĕ (U+0166 U+0115)
  0x01, 0x66, 0x01, 0x17, 0x01, // Ŧė (U+0166 U+0117)
  0x01, 0x66, 0x01, 0x19, 0x01, // Ŧę (U+0166 U+0119)
  0x01, 0x66, 0x01, 0x1B, 0x01, // Ŧě (U+0166 U+011B)
  0x01, 0x66, 0x01, 0x1D, 0x01, // Ŧĝ (U+0166 U+011D)
  0x01, 0x66, 0x01, 0x1F, 0x01, // Ŧğ (U+0166 U+011F)
  0x01, 0x66, 0x01, 0x21, 0x01, // Ŧġ (U+0166 U+0121)
  0x01, 0x66, 0x01, 0x23, 0x01, // Ŧģ (U+0166 U+0123)
  0x01, 0x66, 0x01, 0x4D, 0x01, // Ŧō (U+0166 U+014D)
  0x01, 0x66, 0x01, 0x4F, 0x01, // Ŧŏ (U+0166 U+014F)
  0x01, 0x66, 0x01, 0x51, 0x01, // Ŧő (U+0166 U+0151)
  0x01, 0x66, 0x01, 0x53, 0x01, // Ŧœ (U+0166 U+0153)
  0x01, 0x76, 0x00, 0xAB, 0x01, // Ŷ« (U+0176 U+00AB)
  0x01, 0x76, 0x20, 0x39, 0x01, // Ŷ‹ (U+0176 U+2039)
  0x01, 0x78, 0x00, 0xAB, 0x01, // Ÿ« (U+0178 U+00AB)
  0x01, 0x78, 0x20, 0x39, 0x01, // Ÿ‹ (U+0178 U+2039)
  0x20, 0x18, 0x00, 0x41, 0x01, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0xC0, 0x01, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x01, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x01, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x01, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x01, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x01, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xC6, 0x01, // ‘Æ (U+2018 U+00C6)
  0x20, 0x18, 0x01, 0x00, 0x01, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x02, 0x01, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x04, 0x01, // ‘Ą (U+2018 U+0104)
  0x20, 0x19, 0x00, 0x41, 0x01, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0xC0, 0x01, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x01, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x01, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x01, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x01, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x01, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xC6, 0x01, // ’Æ (U+2019 U+00C6)
  0x20, 0x19, 0x01, 0x00, 0x01, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x02, 0x01, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x04, 0x01, // ’Ą (U+2019 U+0104)
  0x20, 0x1A, 0x00, 0x54, 0x01, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x01, 0x62, 0x01, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x01, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x01, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1C, 0x00, 0x41, 0x01, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0xC0, 0x01, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x01, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x01, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x01, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x01, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x01, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xC6, 0x01, // “Æ (U+201C U+00C6)
  0x20, 0x1C, 0x01, 0x00, 0x01, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x02, 0x01, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x04, 0x01, // “Ą (U+201C U+0104)
  0x20, 0x1D, 0x00, 0x41, 0x01, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0xC0, 0x01, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x01, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x01, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x01, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x01, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x01, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xC6, 0x01, // ”Æ (U+201D U+00C6)
  0x20, 0x1D, 0x01, 0x00, 0x01, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x02, 0x01, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x04, 0x01, // ”Ą (U+201D U+0104)
  0x20, 0x1E, 0x00, 0x54, 0x01, // „T (U+201E U+0054)
  0x20, 0x1E, 0x01, 0x62, 0x01, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x01, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x01, // „Ŧ (U+201E U+0166)
  0x20, 0x3A, 0x00, 0x59, 0x01, // ›Y (U+203A U+0059)
  0x20, 0x3A, 0x00, 0xDD, 0x01, // ›Ý (U+203A U+00DD)
  0x20, 0x3A, 0x01, 0x76, 0x01, // ›Ŷ (U+203A U+0176)
  0x20, 0x3A, 0x01, 0x78, 0x01, // ›Ÿ (U+203A U+0178)
  0x20, 0x44, 0x00, 0x30, 0x02, // ⁄0 (U+2044 U+0030)
  0x20, 0x44, 0x00, 0x31, 0x02, // ⁄1 (U+2044 U+0031)
  0x20, 0x44, 0x00, 0x32, 0x02, // ⁄2 (U+2044 U+0032)
  0x20, 0x44, 0x00, 0x33, 0x02, // ⁄3 (U+2044 U+0033)
  0x20, 0x44, 0x00, 0x34, 0x02, // ⁄4 (U+2044 U+0034)
  0x20, 0x44, 0x00, 0x35, 0x02, // ⁄5 (U+2044 U+0035)
  0x20, 0x44, 0x00, 0x36, 0x02, // ⁄6 (U+2044 U+0036)
  0x20, 0x44, 0x00, 0x37, 0x02, // ⁄7 (U+2044 U+0037)
  0x20, 0x44, 0x00, 0x38, 0x02, // ⁄8 (U+2044 U+0038)
  0x20, 0x44, 0x00, 0x39, 0x02, // ⁄9 (U+2044 U+0039)
  
  // Glyph data
  // "!" (U+0021)
  0x89, 0x46, 0xF1, 0x6F, 0x05, 0xF0, 0x4E, 0x04, 0xE5, 0x82, 0x10, 0x5E, 0x10,
  // """ (U+0022)
  0x89, 0x27, 0xD5, 0xF6, 0xC4, 0xD4, 0x93, 0xB0,
  // "#" (U+0023)
  0x18, 0x22, 0xC5, 0x92, 0x85, 0x4A, 0x77, 0x07, 0xEA, 0x85, 0xE5, 0x19, 0x7C, 0x42, 0x84, 0xA5,
  0xD2, 0x0C, 0xC8, 0x91, 0x12, 0xE5, 0xD2, 0x01, 0xD4, 0xB2,
  // "$" (U+0024)
  0x20, 0xA2, 0x02, 0x0D, 0xA8, 0x74, 0x7C, 0xA4, 0x16, 0xDB, 0x38, 0x1A, 0xFA, 0x38, 0x7B, 0xD7,
  0x42, 0xAB, 0x87, 0xA8, 0x3D, 0x20, 0x1A, 0x20,
  // "%" (U+0025)
  0x84, 0x2E, 0xA0, 0x1D, 0x28, 0x49, 0x9E, 0x27, 0x82, 0x84, 0xA6, 0xC4, 0xD2, 0x28, 0xA6, 0x97,
  0xD7, 0xB8, 0xD3, 0x3F, 0xDA, 0x6E, 0x7A, 0x01, 0x1E, 0x3D, 0x4B, 0x28, 0x47, 0x91, 0xF8, 0xA2,
  0x84, 0xD3, 0x09, 0xE3,
  // "&" (U+0026)
  0x18, 0x17, 0xEB, 0x49, 0x81, 0x7E, 0x53, 0x98, 0x15, 0xF4, 0x38, 0x1A, 0xFB, 0x38, 0xB2, 0x3E,
  0xF9, 0x7E, 0x09, 0xC4, 0xFE, 0x80, 0x9E, 0x4C, 0xF4, 0x02, 0xCE, 0xBB, 0xD1,
  // "'" (U+0027)
  0x84, 0x7D, 0x6C, 0x49,
  // "(" (U+0028)
  0x18, 0xA1, 0x7B, 0x0E, 0x44, 0xE0, 0x7C, 0x08, 0xB0, 0x7C, 0x04, 0xE2, 0x83, 0xE4, 0x07, 0xB0,
  // ")" (U+0029)
  0x8B, 0x08, 0xA0, 0x1F, 0x20, 0xB7, 0x09, 0xA0, 0x8B, 0x09, 0xA0, 0xB8, 0x1F, 0x38, 0xA1,
  // "*" (U+002A)
  0x10, 0x30, 0xE2, 0x89, 0x47, 0x8E, 0x94, 0x5B, 0xF9, 0x31, 0xE9, 0xC2, 0x81, 0x40, 0x31,
  // "+" (U+002B)
  0x29, 0x49, 0x20, 0x9B, 0x84, 0xA1, 0x3F, 0x31, 0x29, 0x20,
  // "," (U+002C)
  0x84, 0x3D, 0x6D, 0x98,
  // "-" (U+002D)
  0x81, 0xAF, 0xC0, 0xF2,
  // "." (U+002E)
  0x18, 0x11, 0x4E,
  // "/" (U+002F)
  0x20, 0x50, 0xC2, 0x87, 0xB7, 0x01, 0xF2, 0x06, 0xC2, 0x87, 0xB7, 0x01, 0xF2, 0x06, 0xC2, 0x0B,
  0x07, 0x20,
  // "0" (U+0030)
  0x18, 0xC4, 0x9E, 0x90, 0x4F, 0x5F, 0x37, 0xD0, 0xD7, 0x9C, 0x0C, 0x99, 0xC0, 0xC9, 0x8C, 0x0D,
  0x74, 0xF5, 0xF4, 0x09, 0xEA, 0x10,
  // "1" (U+0031)
  0x18, 0x91, 0x1C, 0xB0, 0xCF, 0xB3, 0xCA, 0xB2, 0x0A, 0x0B, 0x20, 0xA0, 0xB2, 0x0A, 0x0B, 0x20,
  0xA0, 0xB2, 0x0A, 0x0B,
  // "2" (U+0032)
  0x89, 0x03, 0xCE, 0x90, 0x59, 0x5F, 0x33, 0x90, 0x52, 0x81, 0x5F, 0x22, 0x0D, 0x09, 0x28, 0x90,
  0x9D, 0x10, 0x4F, 0x63, 0x1A, 0xB0, 0x80,
  // "3" (U+0033)
  0x89, 0x04, 0xDE, 0xB0, 0x36, 0x5F, 0x52, 0x85, 0x3F, 0x30, 0xBF, 0x92, 0x82, 0x26, 0xF4, 0x38,
  0x91, 0xE8, 0x64, 0x6F, 0x57, 0xEE, 0x91,
  // "4" (U+0034)
  0x28, 0xA6, 0x7F, 0x10, 0x1E, 0xF1, 0x08, 0xDF, 0x11, 0xE6, 0xF1, 0x89, 0x4F, 0x1C, 0xB8, 0x4D,
  0x22, 0x6F, 0x32, 0x81, 0x4F, 0x10,
  // "5" (U+0035)
  0x03, 0xB8, 0x62, 0x4F, 0x33, 0x05, 0xE3, 0x05, 0xA8, 0x5B, 0x01, 0x45, 0xF5, 0x38, 0x91, 0xD7,
  0x44, 0x5F, 0x55, 0xEE, 0x91,
  // "6" (U+0036)
  0x18, 0x91, 0x4D, 0xF3, 0x1F, 0x83, 0x16, 0xD3, 0x8A, 0x68, 0xCD, 0xD1, 0x9E, 0x4D, 0x88, 0xC0,
  0xB9, 0x4F, 0x5E, 0x70, 0x9E, 0xB1,
  // "7" (U+0037)
  0x0A, 0xB8, 0x4A, 0x23, 0x3E, 0x72, 0x81, 0x3F, 0x22, 0x08, 0x0C, 0x30, 0xD0, 0x82, 0x81, 0x3F,
  0x32, 0x08, 0x0D, 0x30, 0xD0, 0x82,
  // "8" (U+0038)
  0x8C, 0x61, 0xBE, 0xB0, 0x6E, 0x4E, 0x65, 0xE2, 0xE5, 0x0C, 0xFB, 0x03, 0xEB, 0xE2, 0x9B, 0x0C,
  0x99, 0xD4, 0xD8, 0x1C, 0xEB, 0x10,
  // "9" (U+0039)
  0x18, 0xC4, 0xBE, 0x80, 0x7E, 0x5F, 0x49, 0xB0, 0xC8, 0x8D, 0x1E, 0x93, 0xEE, 0xD8, 0x01, 0x1D,
  0x51, 0x38, 0xE0, 0x4F, 0xD4, 0x10,
  // ":" (U+003A)
  0x82, 0x4E, 0x02, 0x58, 0x11, 0x4E,
  // ";" (U+003B)
  0x82, 0x4E, 0x02, 0x48, 0x45, 0xF7, 0xC8, 0x60,
  // "<" (U+003C)
  0x38, 0x90, 0x78, 0x07, 0xEA, 0x29, 0xF6, 0x38, 0x25, 0xCC, 0x43, 0x04, 0x07,
  // "=" (U+003D)
  0x09, 0xB8, 0x5A, 0x23, 0x33, 0x29, 0xB8, 0x4A, 0x12, 0x22, 0x10,
  // ">" (U+003E)
  0x09, 0x07, 0x38, 0x22, 0xAE, 0x73, 0x89, 0x06, 0xF9, 0x4C, 0xC5, 0x07, 0x43,
  // "?" (U+003F)
  0x86, 0x8E, 0xD3, 0x64, 0xBB, 0x28, 0x79, 0xB0, 0x3F, 0x60, 0xBA, 0x20, 0xA0, 0x32, 0x01, 0x30,
  0xD0, 0x51,
  // "@" (U+0040)
  0x28, 0x28, 0xEE, 0x93, 0x8D, 0x49, 0xC4, 0x4B, 0x90, 0x2E, 0x3C, 0xE6, 0xE1, 0x69, 0x99, 0xA7,
  0xB3, 0x87, 0xC3, 0x96, 0xA4, 0x77, 0xC5, 0xC7, 0xD2, 0x5B, 0x6F, 0x9F, 0xB2, 0x83, 0xE7, 0x31,
  0x43, 0x04, 0x0D, 0xA0, 0xB5, 0x02, 0x01, 0x30,
  // "A" (U+0041)
  0x18, 0x12, 0xFD, 0x38, 0x26, 0xEF, 0x22, 0x82, 0xAA, 0xE5, 0x28, 0x92, 0xD7, 0xB9, 0x02, 0xF5,
  0x8D, 0x06, 0xC8, 0x71, 0x9D, 0x34, 0xF5, 0xD9, 0x20, 0xD0, 0x90,
  // "B" (U+0042)
  0x04, 0xA8, 0x96, 0xD7, 0x04, 0xF4, 0xAF, 0x04, 0xF2, 0x7E, 0x04, 0xB8, 0xA3, 0x70, 0x4F, 0x49,
  0xF1, 0x4F, 0x13, 0xF3, 0x4F, 0x48, 0xF1, 0x4A, 0x0E, 0x06, 0x10,
  // "C" (U+0043)
  0x18, 0x92, 0x3D, 0xEA, 0x0E, 0xA4, 0x65, 0xF2, 0x20, 0x79, 0x30, 0x79, 0x38, 0x15, 0xF1, 0x38,
  0x7E, 0xA3, 0x50, 0x5D, 0xF9,
  // "D" (U+0044)
  0x04, 0xA8, 0xC6, 0xC4, 0x04, 0xF4, 0x9F, 0x14, 0xF1, 0x0E, 0x74, 0xF1, 0x0C, 0x94, 0xF1, 0x0D,
  0x94, 0xF1, 0x0E, 0x64, 0xF5, 0x9E, 0x14, 0xA0, 0xC0, 0x41,
  // "E" (U+0045)
  0x04, 0xB8, 0x73, 0x4F, 0x43, 0x04, 0xF2, 0x20, 0x4B, 0x18, 0x64, 0xF4, 0x20, 0x4F, 0x12, 0x84,
  0x4F, 0x43, 0x04, 0xB0, 0x30,
  // "F" (U+0046)
  0x04, 0xB8, 0x72, 0x4F, 0x43, 0x04, 0xF1, 0x28, 0x14, 0xF2, 0x20, 0x4B, 0x18, 0x64, 0xF4, 0x20,
  0x4F, 0x12, 0x81, 0x4F, 0x12,
  // "G" (U+0047)
  0x18, 0x94, 0x2B, 0xED, 0x40, 0xDC, 0x46, 0x25, 0xF2, 0x30, 0x79, 0x48, 0xA6, 0x7F, 0x0C, 0xF9,
  0x5F, 0x22, 0xC9, 0x0E, 0xA3, 0xD9, 0x04, 0xDF, 0xD6,
  // "H" (U+0048)
  0x8A, 0x14, 0xF1, 0x0C, 0x94, 0xF1, 0x0C, 0x94, 0xF2, 0x0C, 0x94, 0xC8, 0xA7, 0x94, 0xF4, 0x2C,
  0x94, 0xF1, 0x0C, 0x94, 0xF1, 0x0C, 0x94, 0xF1, 0x0C, 0x90,
  // "I" (U+0049)
  0x0A, 0xA8, 0x22, 0x1F, 0x82, 0x90, 0x62, 0x90, 0x62, 0x90, 0x62, 0x90, 0x62, 0x98, 0x17, 0x0A,
  0xA0, 0x20,
  // "J" (U+004A)
  0x18, 0xC7, 0x4F, 0x10, 0x4F, 0x10, 0x4F, 0x10, 0x4F, 0x10, 0x4F, 0x10, 0x4F, 0x10, 0x4F, 0x10,
  0x4F, 0x10, 0x7F, 0x09, 0xF9, 0x01, 0x22,
  // "K" (U+004B)
  0x8A, 0x44, 0xF1, 0x3F, 0x44, 0xF1, 0xBB, 0x04, 0xF6, 0xF3, 0x04, 0xFD, 0xB2, 0x8A, 0x64, 0xFE,
  0xE1, 0x04, 0xF3, 0xF7, 0x04, 0xF1, 0x9E, 0x04, 0xF1, 0x2F, 0x60,
  // "L" (U+004C)
  0x81, 0x4F, 0x12, 0x81, 0x4F, 0x12, 0x81, 0x4F, 0x12, 0x81, 0x4F, 0x12, 0x81, 0x4F, 0x12, 0x81,
  0x4F, 0x12, 0x84, 0x4F, 0x54, 0x14, 0xB0, 0x50,
  // "M" (U+004D)
  0x81, 0x4F, 0xC2, 0x82, 0x8F, 0x84, 0xA2, 0x8E, 0x1C, 0xF8, 0x4E, 0xD4, 0x1F, 0xD8, 0x4F, 0xA8,
  0x4C, 0xC8, 0x4F, 0x6C, 0x88, 0xC8, 0x4F, 0x2F, 0xD4, 0xC8, 0x4F, 0x0D, 0xF0, 0xC8, 0x4F, 0x09,
  0xC0, 0xC8,
  // "N" (U+004E)
  0x86, 0x4F, 0x90, 0x3F, 0x14, 0xA8, 0xC2, 0x13, 0xF1, 0x4F, 0xE7, 0x3F, 0x14, 0xF8, 0xD3, 0xF1,
  0x4F, 0x2F, 0x8F, 0x14, 0xF0, 0xAE, 0xF1, 0x4F, 0x04, 0xA0, 0x10, 0x49, 0x28, 0x1C, 0xF1,
  // "O" (U+004F)
  0x18, 0x24, 0xDE, 0xA2, 0x89, 0x2E, 0x94, 0xE8, 0x5F, 0x10, 0x8D, 0x79, 0x28, 0x16, 0xF7, 0x92,
  0x8A, 0x16, 0xF5, 0xF1, 0x08, 0xD1, 0xE9, 0x4E, 0x80, 0x4D, 0xEA, 0x10,
  // "P" (U+0050)
  0x04, 0xA8, 0xA0, 0xD3, 0x4F, 0x4B, 0xC4, 0xF1, 0x7E, 0x4F, 0x2B, 0xC4, 0xA8, 0x3E, 0x44, 0xF4,
  0x28, 0x14, 0xF1, 0x28, 0x14, 0xF1, 0x20,
  // "Q" (U+0051)
  0x18, 0x24, 0xDF, 0xA2, 0x89, 0x2E, 0x94, 0xE8, 0x5F, 0x10, 0x8D, 0x79, 0x28, 0x16, 0xF7, 0x92,
  0x8A, 0x26, 0xF5, 0xF1, 0x08, 0xE1, 0xE9, 0x4E, 0x90, 0x4D, 0xFD, 0x13, 0x81, 0x5F, 0x44, 0x00,
  0x60,
  // "R" (U+0052)
  0x04, 0xA8, 0xA4, 0xC3, 0x04, 0xF5, 0xCC, 0x04, 0xF1, 0x7F, 0x04, 0xF2, 0xAC, 0x04, 0xB8, 0xA2,
  0x30, 0x4F, 0x6F, 0x30, 0x4F, 0x1B, 0xB0, 0x4F, 0x13, 0xF4,
  // "S" (U+0053)
  0x18, 0x92, 0xAE, 0xD2, 0x6E, 0x47, 0x08, 0xE1, 0x28, 0x23, 0xFE, 0x42, 0x82, 0x5E, 0xF2, 0x28,
  0x92, 0x3F, 0x56, 0x56, 0xF3, 0x7E, 0xE7, 0x10,
  // "T" (U+0054)
  0x0D, 0xB8, 0x90, 0x92, 0x7F, 0x31, 0x05, 0xF1, 0x28, 0x15, 0xF1, 0x28, 0x15, 0xF1, 0x28, 0x15,
  0xF1, 0x28, 0x15, 0xF1, 0x28, 0x15, 0xF1, 0x10,
  // "U" (U+0055)
  0x8D, 0x54, 0xF1, 0x0D, 0x84, 0xF1, 0x0D, 0x84, 0xF1, 0x0D, 0x84, 0xF1, 0x0D, 0x84, 0xF1, 0x0D,
  0x84, 0xF1, 0x0E, 0x71, 0xF9, 0x6F, 0x40, 0x6D, 0xE8, 0x10,
  // "V" (U+0056)
  0x0D, 0x08, 0x29, 0x8A, 0x06, 0x9C, 0x03, 0xF2, 0x6F, 0x07, 0xE0, 0x2F, 0x3A, 0xA2, 0x82, 0xD6,
  0xE6, 0x28, 0x2A, 0xBF, 0x22, 0x81, 0x6F, 0xE3, 0x81, 0x2F, 0xA2,
  // "W" (U+0057)
  0x8D, 0x2D, 0x70, 0x8D, 0x02, 0xF3, 0xAA, 0x0B, 0xF0, 0x5F, 0x07, 0xC0, 0xEE, 0x38, 0xD0, 0x4F,
  0x2F, 0xA6, 0xBA, 0x01, 0xF7, 0xC7, 0x9D, 0x72, 0x85, 0xEC, 0x94, 0xCF, 0x42, 0x82, 0xBF, 0x61,
  0xA0, 0x12, 0x84, 0x8F, 0x30, 0xED, 0x20,
  // "X" (U+0058)
  0x89, 0x1A, 0xC0, 0x8E, 0x03, 0xF3, 0xD7, 0x28, 0x2C, 0xCF, 0x12, 0x81, 0x5F, 0xA3, 0x81, 0x6F,
  0xA3, 0x89, 0x7D, 0xBF, 0x20, 0x5F, 0x2D, 0x90, 0xBA, 0x06, 0xF1,
  // "Y" (U+0059)
  0x8A, 0x1C, 0xA0, 0x7E, 0x6F, 0x1D, 0x91, 0xFA, 0xF3, 0x0A, 0xFD, 0x28, 0x14, 0xF7, 0x28, 0x11,
  0xF4, 0x28, 0x11, 0xF4, 0x28, 0x11, 0xF4, 0x10,
  // "Z" (U+005A)
  0x0A, 0xB8, 0x46, 0x23, 0x6F, 0x32, 0x00, 0xB2, 0x81, 0x2F, 0x42, 0x09, 0x0C, 0x28, 0x11, 0xF5,
  0x28, 0x48, 0xE3, 0x31, 0xBB, 0x08,
  // "[" (U+005B)
  0x8B, 0x46, 0xFE, 0x6D, 0x26, 0xC0, 0x6C, 0x06, 0xC0, 0x6C, 0x06, 0xC0, 0x6C, 0x06, 0xFE, 0x12,
  0x20,
  // "\" (U+005C)
  0x0B, 0x07, 0x20, 0x60, 0xC2, 0x81, 0x1F, 0x22, 0x0B, 0x07, 0x20, 0x60, 0xC2, 0x81, 0x1F, 0x22,
  0x0B, 0x07, 0x20, 0x60, 0xC0,
  // "]" (U+005D)
  0x8B, 0x4B, 0xF8, 0x2B, 0x80, 0xA8, 0x0A, 0x80, 0xA8, 0x0A, 0x80, 0xA8, 0x0A, 0x8B, 0xF8, 0x22,
  0x10,
  // "^" (U+005E)
  0x20, 0xE0, 0x22, 0x81, 0x6F, 0x82, 0x89, 0x4C, 0x7E, 0x03, 0xE0, 0xB6, 0xA8, 0x04, 0xD0,
  // "_" (U+005F)
  0xC8, 0x49, 0x22, 0x22, 0x10,
  // "`" (U+0060)
  0x03, 0x07, 0x20, 0xA0, 0x90,
  // "a" (U+0061)
  0x82, 0x1C, 0xEB, 0x28, 0x45, 0x4F, 0x52, 0xDA, 0x89, 0x67, 0x9D, 0x3E, 0x79, 0xD5, 0xF7, 0x3E,
  0xBA, 0x70,
  // "b" (U+0062)
  0x05, 0x93, 0x05, 0x93, 0x8B, 0x45, 0xFA, 0xE4, 0x5F, 0x6B, 0xC5, 0xF0, 0x6F, 0x5F, 0x06, 0xF5,
  0xF6, 0xBC, 0x5D, 0xBE, 0x40,
  // "c" (U+0063)
  0x18, 0x79, 0xEC, 0x5F, 0x44, 0x8C, 0x20, 0x80, 0xC2, 0x86, 0x6F, 0x46, 0x0A, 0xEB,
  // "d" (U+0064)
  0x30, 0x90, 0xB3, 0x8B, 0x68, 0xB0, 0xBD, 0xBB, 0x6F, 0x4D, 0xB8, 0xC0, 0x8B, 0x8C, 0x08, 0xB6,
  0xF4, 0xDB, 0x0B, 0xD9, 0xB0,
  // "e" (U+0065)
  0x18, 0x90, 0xAE, 0xB0, 0x5E, 0x4D, 0x78, 0xB8, 0x96, 0x98, 0xC2, 0x21, 0x5F, 0x54, 0x30, 0x9E,
  0xD3,
  // "f" (U+0066)
  0x18, 0x6B, 0xF5, 0x2F, 0x61, 0xBA, 0x8A, 0x22, 0x5F, 0x50, 0x3F, 0x20, 0x3F, 0x20, 0x3F, 0x20,
  0x3F, 0x21,
  // "g" (U+0067)
  0x18, 0xB3, 0xBD, 0xAB, 0x6F, 0x4D, 0xB8, 0xC0, 0x9B, 0x8C, 0x08, 0xB6, 0xF4, 0xDB, 0x0C, 0xDB,
  0xB3, 0x89, 0x29, 0xB3, 0x64, 0xD7, 0x3D, 0xEA, 0x10,
  // "h" (U+0068)
  0x05, 0x93, 0x05, 0x93, 0x8B, 0x45, 0xEA, 0xE5, 0x5F, 0x6B, 0xC5, 0xF0, 0x7D, 0x5F, 0x07, 0xD5,
  0xF0, 0x7D, 0x5F, 0x07, 0xD0,
  // "i" (U+0069)
  0x89, 0x54, 0xD0, 0x15, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0x90,
  // "j" (U+006A)
  0x10, 0x40, 0xD2, 0x8B, 0x21, 0x05, 0xF0, 0x5F, 0x05, 0xF0, 0x5F, 0x05, 0xF0, 0x5F, 0x05, 0xF1,
  0xAE, 0x5E, 0x70,
  // "k" (U+006B)
  0x05, 0x93, 0x05, 0x93, 0x8B, 0x45, 0xF0, 0xAB, 0x5F, 0x5F, 0x25, 0xED, 0x90, 0x5F, 0xDE, 0x05,
  0xF1, 0xE6, 0x5F, 0x08, 0xE0,
  // "l" (U+006C)
  0x89, 0x55, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0x90,
  // "m" (U+006D)
  0x8D, 0x65, 0xBA, 0xE4, 0xCD, 0x25, 0xF6, 0xCF, 0x4E, 0x75, 0xF0, 0x9C, 0x0C, 0x85, 0xF0, 0x9C,
  0x0C, 0x85, 0xF0, 0x9C, 0x0C, 0x85, 0xF0, 0x9C, 0x0C, 0x80,
  // "n" (U+006E)
  0x8B, 0x45, 0xCA, 0xE5, 0x5F, 0x6B, 0xC5, 0xF0, 0x7D, 0x5F, 0x07, 0xD5, 0xF0, 0x7D, 0x5F, 0x07,
  0xD0,
  // "o" (U+006F)
  0x18, 0xB3, 0xAE, 0xB1, 0x5F, 0x4C, 0x98, 0xC0, 0x8C, 0x8C, 0x08, 0xC5, 0xF4, 0xC9, 0x09, 0xEC,
  0x10,
  // "p" (U+0070)
  0x8B, 0x55, 0xD9, 0xE4, 0x5F, 0x6B, 0xC5, 0xF0, 0x6F, 0x5F, 0x06, 0xF5, 0xF6, 0xBC, 0x5F, 0xAE,
  0x45, 0x93, 0x05, 0x93, 0x05, 0x93,
  // "q" (U+0071)
  0x18, 0xB3, 0xBD, 0xAB, 0x6F, 0x4D, 0xB8, 0xC0, 0x9B, 0x8C, 0x08, 0xB6, 0xF4, 0xDB, 0x0C, 0xDB,
  0xB3, 0x08, 0x0B, 0x30, 0x90, 0xB3, 0x09, 0x0B,
  // "r" (U+0072)
  0x87, 0x5C, 0xA9, 0x5F, 0x72, 0x59, 0x20, 0x59, 0x20, 0x59, 0x20, 0x59, 0x20,
  // "s" (U+0073)
  0x89, 0x13, 0xDE, 0x79, 0xC4, 0x36, 0xF8, 0x28, 0x91, 0x5E, 0x95, 0x4B, 0xB8, 0xFD, 0x40,
  // "t" (U+0074)
  0x18, 0x2E, 0x10, 0x9A, 0x8A, 0x33, 0x5F, 0x40, 0x4F, 0x10, 0x4F, 0x10, 0x3F, 0x61, 0x0C, 0xE3,
  // "u" (U+0075)
  0x8B, 0x46, 0xF0, 0x7D, 0x6F, 0x07, 0xD6, 0xF0, 0x7D, 0x6F, 0x08, 0xD4, 0xF4, 0xCD, 0x0C, 0xE9,
  0xD0,
  // "v" (U+0076)
  0x8A, 0x1D, 0x80, 0xBA, 0x8C, 0x0E, 0x54, 0xF3, 0xF1, 0x0F, 0xAC, 0x28, 0x1B, 0xE8, 0x28, 0x17,
  0xF4, 0x10,
  // "w" (U+0077)
  0x8B, 0x5C, 0x82, 0xF8, 0x2F, 0x29, 0xB5, 0xEB, 0x5E, 0x06, 0xD8, 0x9E, 0x8B, 0x03, 0xFB, 0x4E,
  0xB8, 0x28, 0x4E, 0xF1, 0xCF, 0x42, 0x84, 0xBE, 0x09, 0xF1, 0x10,
  // "x" (U+0078)
  0x87, 0x9C, 0x1F, 0x62, 0xFA, 0xE2, 0x81, 0xAF, 0x72, 0x89, 0x4B, 0xF8, 0x03, 0xF9, 0xE0, 0xAB,
  0x0E, 0x70,
  // "y" (U+0079)
  0x8A, 0x1D, 0x80, 0xBA, 0x8C, 0x0E, 0x64, 0xF3, 0xF2, 0x0F, 0xAD, 0x28, 0x1B, 0xE9, 0x28, 0x17,
  0xF5, 0x28, 0x54, 0xF1, 0x02, 0xBB, 0x28, 0x19, 0xD3, 0x20,
  // "z" (U+007A)
  0x0A, 0xA8, 0x6A, 0x23, 0xF6, 0x07, 0xE2, 0x86, 0xE7, 0x07, 0xE3, 0x2C, 0xA0, 0xB0,
  // "{" (U+007B)
  0x18, 0xA4, 0x5E, 0x60, 0xAB, 0x10, 0xA8, 0x01, 0xC7, 0x0C, 0xE2, 0x03, 0xD7, 0x20, 0xA0, 0x82,
  0x00, 0xA2, 0x81, 0x6F, 0x62, 0x00, 0x10,
  // "|" (U+007C)
  0x8A, 0x44, 0xD4, 0xD4, 0xD4, 0xD4, 0xD4, 0xD4, 0xD4, 0xD4, 0xD4, 0xD4, 0xD0,
  // "}" (U+007D)
  0x85, 0xAD, 0x10, 0x3E, 0x62, 0x0C, 0x06, 0x20, 0xB0, 0x92, 0x8A, 0x25, 0xF8, 0x0B, 0xB1, 0x0C,
  0x60, 0x1D, 0x60, 0xAF, 0x20, 0x13,
  // "~" (U+007E)
  0x89, 0x05, 0xE9, 0x15, 0x74, 0xBF, 0x73, 0x01, 0x10,
  // "¡" (U+00A1)
  0x04, 0x0E, 0x28, 0x97, 0x20, 0x4D, 0x04, 0xE0, 0x5F, 0x06, 0xF0, 0x6F, 0x10,
  // "¢" (U+00A2)
  0x20, 0x90, 0x22, 0x89, 0x27, 0xFE, 0x22, 0xF7, 0x40, 0x4F, 0x12, 0x81, 0x4F, 0x12, 0x89, 0x02,
  0xF6, 0x41, 0x08, 0xFD, 0x22, 0x09, 0x02, 0x10,
  // "£" (U+00A3)
  0x18, 0x92, 0x4E, 0xE5, 0x0B, 0xB4, 0x20, 0xD8, 0x20, 0x9A, 0x84, 0xE0, 0x1D, 0x92, 0x20, 0xD0,
  0x72, 0x84, 0x4F, 0x53, 0x28, 0xB0, 0xA0,
  // "¤" (U+00A4)
  0x10, 0x12, 0x8B, 0x01, 0x5D, 0xEC, 0xD0, 0xD4, 0x98, 0x1D, 0x16, 0x94, 0xEF, 0xEC, 0x12, 0x10,
  0x40,
  // "¥" (U+00A5)
  0x89, 0x4B, 0xB0, 0xBA, 0x5F, 0x2F, 0x50, 0xEB, 0xE2, 0x89, 0x59, 0xF9, 0x05, 0xEF, 0xE5, 0x03,
  0xF2, 0x05, 0xB8, 0x45, 0x15, 0xF5, 0x10,
  // "¦" (U+00A6)
  0x86, 0x4D, 0x4D, 0x4D, 0x4D, 0x68, 0x64, 0xD4, 0xD4, 0xD4, 0xD0,
  // "§" (U+00A7)
  0x8B, 0x62, 0xCE, 0x86, 0xC4, 0x42, 0xE9, 0x16, 0xA9, 0xB5, 0xD8, 0xA0, 0x4D, 0x84, 0x48, 0xC5,
  0xEE, 0x50,
  // "¨" (U+00A8)
  0x85, 0xC3, 0xE1, 0x10, 0x11,
  // "©" (U+00A9)
  0x28, 0x38, 0xEF, 0xB2, 0x28, 0xB1, 0xAA, 0x43, 0x8D, 0x14, 0xA1, 0xCE, 0x66, 0x87, 0x39, 0x93,
  0x20, 0xB8, 0x3B, 0x33, 0x8A, 0x2B, 0x58, 0x97, 0x11, 0x49, 0x0C, 0x9D, 0xFB, 0xD2, 0x01, 0xCA,
  0x0D, 0x03, 0x40, 0x10, 0x23,
  // "ª" (U+00AA)
  0x89, 0x25, 0xCA, 0x27, 0xFB, 0x6F, 0x6B, 0xB0,
  // "«" (U+00AB)
  0x18, 0xA6, 0x68, 0x3B, 0x3F, 0x4D, 0x87, 0xE4, 0xF3, 0x0C, 0x88, 0xC0, 0x23, 0x04,
  // "¬" (U+00AC)
  0x09, 0xB8, 0x49, 0x12, 0x28, 0x93, 0x07, 0x09, 0x30, 0x01,
  // "®" (U+00AE)
  0x28, 0x38, 0xEF, 0xB2, 0x28, 0xB0, 0xAA, 0x43, 0x8D, 0x14, 0xA5, 0xFE, 0x46, 0x87, 0x35, 0xA9,
  0x90, 0xB8, 0x35, 0xA8, 0xA4, 0x40, 0xB5, 0x85, 0xAA, 0x64, 0x90, 0xC9, 0x41, 0x9D, 0x20, 0x1C,
  0xA0, 0xD0, 0x34, 0x01, 0x02, 0x30,
  // "¯" (U+00AF)
  0xC0, 0xC8, 0x01, 0x20,
  // "°" (U+00B0)
  0x89, 0x43, 0xED, 0x19, 0x8A, 0x65, 0xFE, 0x20, 0x12,
  // "±" (U+00B1)
  0x29, 0x49, 0x20, 0x9B, 0x84, 0xA1, 0x3F, 0x31, 0x29, 0x28, 0x42, 0x33, 0x32, 0x9B, 0x0A,
  // "²" (U+00B2)
  0x85, 0x6D, 0x90, 0x22, 0xE2, 0x83, 0x89, 0x04, 0xD2, 0x82, 0xAE, 0xD1,
  // "³" (U+00B3)
  0x89, 0x56, 0xD9, 0x11, 0xD0, 0xE9, 0x10, 0xE8, 0xD9,
  // "´" (U+00B4)
  0x83, 0x2D, 0x51, 0x11,
  // "µ" (U+00B5)
  0x8B, 0x55, 0xF0, 0x7D, 0x5F, 0x07, 0xD5, 0xF0, 0x7D, 0x5F, 0x08, 0xD5, 0xF5, 0xCD, 0x5F, 0xEA,
  0xD5, 0x93, 0x05, 0x93, 0x05, 0x93,
  // "¶" (U+00B6)
  0x10, 0xBA, 0x0B, 0x05, 0xA8, 0x17, 0xB7, 0xA8, 0x15, 0xB7, 0xA8, 0x15, 0xB4, 0xA8, 0x55, 0xB0,
  0x6B, 0x5B, 0x28, 0x16, 0x5B, 0x28, 0x16, 0x5B, 0x28, 0x16, 0x5B, 0x28, 0x14, 0x38,
  // "·" (U+00B7)
  0x18, 0x11, 0x4E,
  // "¸" (U+00B8)
  0x18, 0x66, 0x10, 0x9B, 0x2D, 0x80,
  // "¹" (U+00B9)
  0x89, 0x21, 0xB9, 0x49, 0x90, 0x69, 0x06, 0x90,
  // "º" (U+00BA)
  0x89, 0x54, 0xCA, 0x0A, 0x3C, 0x2A, 0x4C, 0x23, 0xB8, 0x10,
  // "»" (U+00BB)
  0x82, 0x59, 0x2C, 0x28, 0x31, 0xE6, 0xBA, 0x28, 0x95, 0xBB, 0x7E, 0x15, 0xE3, 0xE5, 0x01, 0x30,
  0x42,
  // "¼" (U+00BC)
  0x10, 0xC0, 0x72, 0x87, 0xD3, 0x07, 0xC7, 0x04, 0xC3, 0x83, 0x87, 0x0B, 0x53, 0x89, 0x58, 0x73,
  0xD0, 0x94, 0x08, 0x7A, 0x66, 0xE6, 0x28, 0x42, 0xD2, 0xCB, 0x82, 0x87, 0x97, 0x4E, 0xFE, 0x01,
  0xD3, 0x08, 0x05,
  // "½" (U+00BD)
  0x81, 0x1C, 0x72, 0x87, 0xD2, 0x07, 0xB7, 0x05, 0xA3, 0x83, 0x87, 0x0C, 0x33, 0x89, 0x58, 0x74,
  0xC9, 0xE6, 0x08, 0x7B, 0x54, 0x5B, 0x20, 0x20, 0xD2, 0x0A, 0x06, 0x28, 0x39, 0x70, 0x7A, 0x20,
  0x10, 0xE2, 0x84, 0xEF, 0xE0, 0x12, 0x20, 0xF2,
  // "¾" (U+00BE)
  0x81, 0x5E, 0xA2, 0x87, 0xB5, 0x02, 0x5E, 0x02, 0xD3, 0x98, 0x29, 0x0A, 0x62, 0x8A, 0x62, 0x4E,
  0x2E, 0x06, 0x49, 0xFD, 0x97, 0x4E, 0x70, 0x21, 0xE2, 0xCA, 0x92, 0x81, 0x79, 0x20, 0xFE, 0x20,
  0xC0, 0x22, 0x07, 0x06,
  // "¿" (U+00BF)
  0x10, 0x50, 0xD3, 0x01, 0x20, 0x30, 0xA2, 0x87, 0xAB, 0x06, 0xF3, 0x0B, 0x92, 0x86, 0xBB, 0x46,
  0x3D, 0xE8,
  // "À" (U+00C0)
  0x10, 0x30, 0x75, 0x0A, 0x09, 0x72, 0x81, 0x2F, 0xD3, 0x82, 0x6E, 0xF2, 0x28, 0x2A, 0xAE, 0x52,
  0x89, 0x2D, 0x7B, 0x90, 0x2F, 0x58, 0xD0, 0x6C, 0x87, 0x19, 0xD3, 0x4F, 0x5D, 0x92, 0x0D, 0x09,
  // "Á" (U+00C1)
  0x28, 0x12, 0xD5, 0x30, 0x01, 0x38, 0x12, 0xFD, 0x38, 0x26, 0xEF, 0x22, 0x82, 0xAA, 0xE5, 0x28,
  0x92, 0xD7, 0xB9, 0x02, 0xF5, 0x8D, 0x06, 0xC8, 0x71, 0x9D, 0x34, 0xF5, 0xD9, 0x20, 0xD0, 0x90,
  // "Â" (U+00C2)
  0x20, 0x50, 0x73, 0x82, 0x4B, 0x97, 0x71, 0x81, 0x2F, 0xD3, 0x82, 0x6E, 0xF2, 0x28, 0x2A, 0xAE,
  0x52, 0x89, 0x2D, 0x7B, 0x90, 0x2F, 0x58, 0xD0, 0x6C, 0x87, 0x19, 0xD3, 0x4F, 0x5D, 0x92, 0x0D,
  0x09,
  // "Ã" (U+00C3)
  0x18, 0x23, 0xE4, 0xB2, 0x82, 0x87, 0xD8, 0x20, 0x15, 0x81, 0x2F, 0xD3, 0x82, 0x6E, 0xF2, 0x28,
  0x2A, 0xAE, 0x52, 0x89, 0x2D, 0x7B, 0x90, 0x2F, 0x58, 0xD0, 0x6C, 0x87, 0x19, 0xD3, 0x4F, 0x5D,
  0x92, 0x0D, 0x09,
  // "Ä" (U+00C4)
  0x18, 0x2C, 0x3E, 0x12, 0x81, 0x10, 0x13, 0x81, 0x2F, 0xD3, 0x82, 0x6E, 0xF2, 0x28, 0x2A, 0xAE,
  0x52, 0x89, 0x2D, 0x7B, 0x90, 0x2F, 0x58, 0xD0, 0x6C, 0x87, 0x19, 0xD3, 0x4F, 0x5D, 0x92, 0x0D,
  0x09,
  // "Å" (U+00C5)
  0x18, 0x14, 0xE6, 0x30, 0xBA, 0x30, 0xBA, 0x02, 0x28, 0x2A, 0xCE, 0x52, 0x89, 0x2D, 0x7B, 0x90,
  0x2F, 0x58, 0xD0, 0x6C, 0x87, 0x19, 0xD3, 0x4F, 0x5D, 0x92, 0x0D, 0x09,
  // "Æ" (U+00C6)
  0x20, 0xAC, 0x03, 0x29, 0x82, 0xAF, 0x43, 0x28, 0x35, 0xF5, 0xF2, 0x38, 0x19, 0xC4, 0xB8, 0x90,
  0x10, 0xE8, 0x4F, 0x42, 0x03, 0xC0, 0x12, 0x89, 0x28, 0xE2, 0x6F, 0x43, 0x0D, 0x90, 0x4B, 0x03,
  // "Ç" (U+00C7)
  0x18, 0x92, 0x3D, 0xEA, 0x0E, 0xA4, 0x65, 0xF2, 0x20, 0x79, 0x30, 0x79, 0x38, 0x15, 0xF1, 0x38,
  0x7E, 0xA3, 0x50, 0x5D, 0xF9, 0x20, 0x60, 0x13, 0x09, 0x0B, 0x28, 0x12, 0xD8, 0x10,
  // "È" (U+00C8)
  0x03, 0x07, 0x40, 0xA0, 0x97, 0x04, 0xB8, 0x73, 0x4F, 0x43, 0x04, 0xF2, 0x20, 0x4B, 0x18, 0x64,
  0xF4, 0x20, 0x4F, 0x12, 0x84, 0x4F, 0x43, 0x04, 0xB0, 0x30,
  // "É" (U+00C9)
  0x18, 0x12, 0xD5, 0x20, 0x01, 0x20, 0x4B, 0x87, 0x34, 0xF4, 0x30, 0x4F, 0x22, 0x04, 0xB1, 0x86,
  0x4F, 0x42, 0x04, 0xF1, 0x28, 0x44, 0xF4, 0x30, 0x4B, 0x03,
  // "Ê" (U+00CA)
  0x10, 0x50, 0x72, 0x82, 0x4B, 0x97, 0x60, 0x4B, 0x87, 0x34, 0xF4, 0x30, 0x4F, 0x22, 0x04, 0xB1,
  0x86, 0x4F, 0x42, 0x04, 0xF1, 0x28, 0x44, 0xF4, 0x30, 0x4B, 0x03,
  // "Ë" (U+00CB)
  0x18, 0x90, 0xC3, 0xE1, 0x01, 0x01, 0x04, 0xB8, 0x73, 0x4F, 0x43, 0x04, 0xF2, 0x20, 0x4B, 0x18,
  0x64, 0xF4, 0x20, 0x4F, 0x12, 0x84, 0x4F, 0x43, 0x04, 0xB0, 0x30,
  // "Ì" (U+00CC)
  0x03, 0x07, 0x30, 0xA0, 0x95, 0x0A, 0xA8, 0x22, 0x1F, 0x82, 0x90, 0x62, 0x90, 0x62, 0x90, 0x62,
  0x90, 0x62, 0x98, 0x17, 0x0A, 0xA0, 0x20,
  // "Í" (U+00CD)
  0x18, 0x62, 0xD5, 0x01, 0x10, 0xAA, 0x82, 0x21, 0xF8, 0x29, 0x06, 0x29, 0x06, 0x29, 0x06, 0x29,
  0x06, 0x29, 0x81, 0x70, 0xAA, 0x02,
  // "Î" (U+00CE)
  0x18, 0x55, 0x70, 0x4B, 0x97, 0x40, 0xAA, 0x82, 0x21, 0xF8, 0x29, 0x06, 0x29, 0x06, 0x29, 0x06,
  0x29, 0x06, 0x29, 0x81, 0x70, 0xAA, 0x02,
  // "Ï" (U+00CF)
  0x87, 0xC3, 0xE1, 0x10, 0x10, 0xAA, 0x82, 0x21, 0xF8, 0x29, 0x06, 0x29, 0x06, 0x29, 0x06, 0x29,
  0x06, 0x29, 0x81, 0x70, 0xAA, 0x02,
  // "Ð" (U+00D0)
  0x04, 0xA8, 0x96, 0xC4, 0x04, 0xF4, 0x9F, 0x14, 0xF2, 0x0E, 0x7D, 0xA1, 0x8A, 0x3C, 0x96, 0xF4,
  0x0D, 0x94, 0xF1, 0x0F, 0x64, 0xF5, 0x9E, 0x14, 0xA0, 0xC0, 0x41,
  // "Ñ" (U+00D1)
  0x18, 0x23, 0xE4, 0xB3, 0x82, 0x87, 0xD8, 0x30, 0x15, 0x86, 0x4F, 0x90, 0x3F, 0x14, 0xA8, 0xC2,
  0x13, 0xF1, 0x4F, 0xE7, 0x3F, 0x14, 0xF8, 0xD3, 0xF1, 0x4F, 0x2F, 0x8F, 0x14, 0xF0, 0xAE, 0xF1,
  0x4F, 0x04, 0xA0, 0x10, 0x49, 0x28, 0x1C, 0xF1,
  // "Ò" (U+00D2)
  0x10, 0x30, 0x75, 0x0A, 0x09, 0x72, 0x82, 0x4D, 0xEA, 0x28, 0x92, 0xE9, 0x4E, 0x85, 0xF1, 0x08,
  0xD7, 0x92, 0x81, 0x6F, 0x79, 0x28, 0xA1, 0x6F, 0x5F, 0x10, 0x8D, 0x1E, 0x94, 0xE8, 0x04, 0xDE,
  0xA1,
  // "Ó" (U+00D3)
  0x28, 0x12, 0xD5, 0x30, 0x01, 0x38, 0x24, 0xDE, 0xA2, 0x89, 0x2E, 0x94, 0xE8, 0x5F, 0x10, 0x8D,
  0x79, 0x28, 0x16, 0xF7, 0x92, 0x8A, 0x16, 0xF5, 0xF1, 0x08, 0xD1, 0xE9, 0x4E, 0x80, 0x4D, 0xEA,
  0x10,
  // "Ô" (U+00D4)
  0x20, 0x50, 0x73, 0x82, 0x4B, 0x97, 0x71, 0x82, 0x4D, 0xEA, 0x28, 0x92, 0xE9, 0x4E, 0x85, 0xF1,
  0x08, 0xD7, 0x92, 0x81, 0x6F, 0x79, 0x28, 0xA1, 0x6F, 0x5F, 0x10, 0x8D, 0x1E, 0x94, 0xE8, 0x04,
  0xDE, 0xA1,
  // "Õ" (U+00D5)
  0x18, 0x23, 0xE4, 0xB2, 0x82, 0x87, 0xD8, 0x20, 0x15, 0x82, 0x4D, 0xEA, 0x28, 0x92, 0xE9, 0x4E,
  0x85, 0xF1, 0x08, 0xD7, 0x92, 0x81, 0x6F, 0x79, 0x28, 0xA1, 0x6F, 0x5F, 0x10, 0x8D, 0x1E, 0x94,
  0xE8, 0x04, 0xDE, 0xA1,
  // "Ö" (U+00D6)
  0x28, 0x2C, 0x3E, 0x12, 0x81, 0x10, 0x12, 0x82, 0x4D, 0xEA, 0x28, 0x92, 0xE9, 0x4E, 0x85, 0xF1,
  0x08, 0xD7, 0x92, 0x81, 0x6F, 0x79, 0x28, 0xA1, 0x6F, 0x5F, 0x10, 0x8D, 0x1E, 0x94, 0xE8, 0x04,
  0xDE, 0xA1,
  // "×" (U+00D7)
  0x8A, 0x71, 0x40, 0x41, 0x3E, 0x8E, 0x30, 0x7F, 0x70, 0x3E, 0x7E, 0x31, 0x30, 0x31,
  // "Ø" (U+00D8)
  0x58, 0xD6, 0x10, 0x4D, 0xEC, 0x70, 0xE9, 0x5F, 0x95, 0xF1, 0x5E, 0xE7, 0xE0, 0xC7, 0xF7, 0xE5,
  0x86, 0xF5, 0xFD, 0x18, 0xD1, 0xEB, 0x4E, 0x80, 0xCD, 0xFA, 0x20, 0x34,
  // "Ù" (U+00D9)
  0x10, 0x30, 0x75, 0x0A, 0x09, 0x71, 0x8D, 0x54, 0xF1, 0x0D, 0x84, 0xF1, 0x0D, 0x84, 0xF1, 0x0D,
  0x84, 0xF1, 0x0D, 0x84, 0xF1, 0x0D, 0x84, 0xF1, 0x0E, 0x71, 0xF9, 0x6F, 0x40, 0x6D, 0xE8, 0x10,
  // "Ú" (U+00DA)
  0x28, 0x12, 0xD5, 0x30, 0x01, 0x28, 0xD5, 0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xD8,
  0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xE7, 0x1F, 0x96, 0xF4, 0x06, 0xDE, 0x81,
  // "Û" (U+00DB)
  0x20, 0x50, 0x73, 0x82, 0x4B, 0x97, 0x78, 0xD5, 0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xD8, 0x4F, 0x10,
  0xD8, 0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xE7, 0x1F, 0x96, 0xF4, 0x06, 0xDE, 0x81,
  // "Ü" (U+00DC)
  0x28, 0x2C, 0x3E, 0x12, 0x8E, 0x11, 0x01, 0x04, 0xF1, 0x0D, 0x84, 0xF1, 0x0D, 0x84, 0xF1, 0x0D,
  0x84, 0xF1, 0x0D, 0x84, 0xF1, 0x0D, 0x84, 0xF1, 0x0E, 0x71, 0xF9, 0x6F, 0x40, 0x6D, 0xE8, 0x10,
  // "Ý" (U+00DD)
  0x28, 0x12, 0xD5, 0x28, 0xA4, 0x11, 0x0C, 0xA0, 0x7E, 0x6F, 0x1D, 0x91, 0xFA, 0xF3, 0x0A, 0xFD,
  0x28, 0x14, 0xF7, 0x28, 0x11, 0xF4, 0x28, 0x11, 0xF4, 0x28, 0x11, 0xF4, 0x10,
  // "Þ" (U+00DE)
  0x81, 0x4F, 0x12, 0x81, 0x4F, 0x22, 0x04, 0xA8, 0x93, 0xD4, 0x4F, 0x4B, 0xD4, 0xF2, 0xAC, 0x4B,
  0x87, 0x54, 0xF4, 0x10, 0x4F, 0x12,
  // "ß" (U+00DF)
  0x18, 0xD5, 0x8E, 0xD6, 0x03, 0xF6, 0x9F, 0x05, 0xF0, 0x9C, 0x05, 0xF4, 0xF2, 0x05, 0xF3, 0xF8,
  0x05, 0xF0, 0x5F, 0x55, 0xF3, 0x4E, 0x85, 0xF6, 0xFD, 0x20,
  // "à" (U+00E0)
  0x10, 0x30, 0x74, 0x0A, 0x09, 0x68, 0x21, 0xCE, 0xB2, 0x84, 0x54, 0xF5, 0x2D, 0xA8, 0x96, 0x79,
  0xD3, 0xE7, 0x9D, 0x5F, 0x73, 0xEB, 0xA7,
  // "á" (U+00E1)
  0x18, 0x12, 0xD5, 0x20, 0x01, 0x28, 0x21, 0xCE, 0xB2, 0x84, 0x54, 0xF5, 0x2D, 0xA8, 0x96, 0x79,
  0xD3, 0xE7, 0x9D, 0x5F, 0x73, 0xEB, 0xA7,
  // "â" (U+00E2)
  0x10, 0x50, 0x72, 0x82, 0x4B, 0x97, 0x68, 0x21, 0xCE, 0xB2, 0x84, 0x54, 0xF5, 0x2D, 0xA8, 0x96,
  0x79, 0xD3, 0xE7, 0x9D, 0x5F, 0x73, 0xEB, 0xA7,
  // "ã" (U+00E3)
  0x89, 0x13, 0xE4, 0xB0, 0x87, 0xD8, 0x01, 0x48, 0x21, 0xCE, 0xB2, 0x84, 0x54, 0xF5, 0x2D, 0xA8,
  0x96, 0x79, 0xD3, 0xE7, 0x9D, 0x5F, 0x73, 0xEB, 0xA7,
  // "ä" (U+00E4)
  0x18, 0x93, 0xC3, 0xE1, 0x01, 0x01, 0x01, 0xCE, 0xB2, 0x84, 0x54, 0xF5, 0x2D, 0xA8, 0x96, 0x79,
  0xD3, 0xE7, 0x9D, 0x5F, 0x73, 0xEB, 0xA7,
  // "å" (U+00E5)
  0x18, 0x14, 0xE6, 0x28, 0x18, 0x7B, 0x28, 0x65, 0xF7, 0x01, 0xCF, 0xB2, 0x84, 0x54, 0xF5, 0x2D,
  0xA8, 0x96, 0x79, 0xD3, 0xE7, 0x9D, 0x5F, 0x73, 0xEB, 0xA7,
  // "æ" (U+00E6)
  0x85, 0x1C, 0xEA, 0xCE, 0x72, 0x87, 0x54, 0xFA, 0x6F, 0x12, 0xDD, 0x8A, 0x63, 0x9D, 0x3E, 0x82,
  0x20, 0x9D, 0x5F, 0xC3, 0x60, 0x3E, 0xD3, 0xCF, 0xC1,
  // "ç" (U+00E7)
  0x18, 0x79, 0xEC, 0x5F, 0x44, 0x8C, 0x20, 0x80, 0xC2, 0x86, 0x6F, 0x46, 0x0A, 0xEB, 0x20, 0x60,
  0x12, 0x84, 0x9B, 0x02, 0xD8,
  // "è" (U+00E8)
  0x10, 0x30, 0x74, 0x0A, 0x09, 0x78, 0x90, 0xAE, 0xB0, 0x5E, 0x4D, 0x78, 0xB8, 0x96, 0x98, 0xC2,
  0x21, 0x5F, 0x54, 0x30, 0x9E, 0xD3,
  // "é" (U+00E9)
  0x18, 0x12, 0xD5, 0x20, 0x01, 0x38, 0x90, 0xAE, 0xB0, 0x5E, 0x4D, 0x78, 0xB8, 0x96, 0x98, 0xC2,
  0x21, 0x5F, 0x54, 0x30, 0x9E, 0xD3,
  // "ê" (U+00EA)
  0x10, 0x50, 0x72, 0x82, 0x4B, 0x97, 0x78, 0x90, 0xAE, 0xB0, 0x5E, 0x4D, 0x78, 0xB8, 0x96, 0x98,
  0xC2, 0x21, 0x5F, 0x54, 0x30, 0x9E, 0xD3,
  // "ë" (U+00EB)
  0x18, 0x6C, 0x3E, 0x10, 0x10, 0x12, 0x89, 0x0A, 0xEB, 0x05, 0xE4, 0xD7, 0x8B, 0x89, 0x69, 0x8C,
  0x22, 0x15, 0xF5, 0x43, 0x09, 0xED, 0x30,
  // "ì" (U+00EC)
  0x03, 0x07, 0x20, 0xA0, 0x94, 0x89, 0x65, 0xF0, 0x5F, 0x05, 0xF0, 0x5F, 0x05, 0xF0, 0x59,
  // "í" (U+00ED)
  0x8A, 0x42, 0xD5, 0x11, 0x05, 0xF0, 0x5F, 0x05, 0xF0, 0x5F, 0x05, 0xF0, 0x59, 0x10,
  // "î" (U+00EE)
  0x18, 0x55, 0x70, 0x4B, 0x97, 0x50, 0x59, 0x20, 0x59, 0x20, 0x59, 0x20, 0x59, 0x20, 0x59, 0x20,
  0x59, 0x10,
  // "ï" (U+00EF)
  0x87, 0xC3, 0xE1, 0x10, 0x10, 0x59, 0x20, 0x59, 0x20, 0x59, 0x20, 0x59, 0x20, 0x59, 0x20, 0x59,
  0x20,
  // "ð" (U+00F0)
  0x18, 0x64, 0xAB, 0x10, 0x4F, 0xC2, 0x8B, 0x32, 0x3E, 0x50, 0xBF, 0xEA, 0x7E, 0x4C, 0xD9, 0xC0,
  0x8D, 0x6E, 0x4C, 0x90, 0xAE, 0xB1,
  // "ñ" (U+00F1)
  0x18, 0x91, 0x3E, 0x4B, 0x08, 0x7D, 0x80, 0x13, 0x8B, 0x45, 0xCA, 0xE5, 0x5F, 0x6B, 0xC5, 0xF0,
  0x7D, 0x5F, 0x07, 0xD5, 0xF0, 0x7D, 0x5F, 0x07, 0xD0,
  // "ò" (U+00F2)
  0x10, 0x30, 0x74, 0x0A, 0x09, 0x78, 0xB3, 0xAE, 0xB1, 0x5F, 0x4C, 0x98, 0xC0, 0x8C, 0x8C, 0x08,
  0xC5, 0xF4, 0xC9, 0x09, 0xEC, 0x10,
  // "ó" (U+00F3)
  0x18, 0x12, 0xD5, 0x20, 0x01, 0x38, 0xB3, 0xAE, 0xB1, 0x5F, 0x4C, 0x98, 0xC0, 0x8C, 0x8C, 0x08,
  0xC5, 0xF4, 0xC9, 0x09, 0xEC, 0x10,
  // "ô" (U+00F4)
  0x20, 0x50, 0x72, 0x82, 0x4B, 0x97, 0x68, 0xB3, 0xAE, 0xB1, 0x5F, 0x4C, 0x98, 0xC0, 0x8C, 0x8C,
  0x08, 0xC5, 0xF4, 0xC9, 0x09, 0xEC, 0x10,
  // "õ" (U+00F5)
  0x89, 0x13, 0xE4, 0xB0, 0x87, 0xD8, 0x01, 0x58, 0xB3, 0xAE, 0xB1, 0x5F, 0x4C, 0x98, 0xC0, 0x8C,
  0x8C, 0x08, 0xC5, 0xF4, 0xC9, 0x09, 0xEC, 0x10,
  // "ö" (U+00F6)
  0x18, 0x6C, 0x3E, 0x10, 0x10, 0x12, 0x8B, 0x3A, 0xEB, 0x15, 0xF4, 0xC9, 0x8C, 0x08, 0xC8, 0xC0,
  0x8C, 0x5F, 0x4C, 0x90, 0x9E, 0xC1,
  // "÷" (U+00F7)
  0x18, 0x11, 0xE1, 0x30, 0x22, 0x09, 0xB8, 0x90, 0xA1, 0x22, 0x21, 0x01, 0xE1, 0x30, 0x12,
  // "ø" (U+00F8)
  0x48, 0xB7, 0x10, 0x9E, 0xD6, 0x5E, 0x5F, 0x98, 0xB7, 0xCC, 0x8C, 0xB7, 0xC4, 0xF8, 0xC9, 0x1E,
  0xEB, 0x11, 0x23,
  // "ù" (U+00F9)
  0x10, 0x30, 0x74, 0x0A, 0x09, 0x68, 0xB4, 0x6F, 0x07, 0xD6, 0xF0, 0x7D, 0x6F, 0x07, 0xD6, 0xF0,
  0x8D, 0x4F, 0x4C, 0xD0, 0xCE, 0x9D,
  // "ú" (U+00FA)
  0x28, 0x12, 0xD5, 0x28, 0xB7, 0x11, 0x06, 0xF0, 0x7D, 0x6F, 0x07, 0xD6, 0xF0, 0x7D, 0x6F, 0x08,
  0xD4, 0xF4, 0xCD, 0x0C, 0xE9, 0xD0,
  // "û" (U+00FB)
  0x20, 0x50, 0x72, 0x82, 0x4B, 0x97, 0x58, 0xB4, 0x6F, 0x07, 0xD6, 0xF0, 0x7D, 0x6F, 0x07, 0xD6,
  0xF0, 0x8D, 0x4F, 0x4C, 0xD0, 0xCE, 0x9D,
  // "ü" (U+00FC)
  0x18, 0xC5, 0xC3, 0xE1, 0x01, 0x01, 0x06, 0xF0, 0x7D, 0x6F, 0x07, 0xD6, 0xF0, 0x7D, 0x6F, 0x08,
  0xD4, 0xF4, 0xCD, 0x0C, 0xE9, 0xD0,
  // "ý" (U+00FD)
  0x18, 0x12, 0xD5, 0x20, 0x01, 0x28, 0xA1, 0xD8, 0x0B, 0xA8, 0xC0, 0xE6, 0x4F, 0x3F, 0x20, 0xFA,
  0xD2, 0x81, 0xBE, 0x92, 0x81, 0x7F, 0x52, 0x85, 0x4F, 0x10, 0x2B, 0xB2, 0x81, 0x9D, 0x32,
  // "þ" (U+00FE)
  0x05, 0x93, 0x05, 0x93, 0x8B, 0x55, 0xF9, 0xE4, 0x5F, 0x6B, 0xC5, 0xF0, 0x6F, 0x5F, 0x06, 0xF5,
  0xF6, 0xBC, 0x5F, 0xAE, 0x45, 0x93, 0x05, 0x93, 0x05, 0x93,
  // "ÿ" (U+00FF)
  0x18, 0xB2, 0xC3, 0xE1, 0x01, 0x01, 0x0D, 0x80, 0xBA, 0x8C, 0x0E, 0x64, 0xF3, 0xF2, 0x0F, 0xAD,
  0x28, 0x1B, 0xE9, 0x28, 0x17, 0xF5, 0x28, 0x54, 0xF1, 0x02, 0xBB, 0x28, 0x19, 0xD3, 0x20,
  // "Ā" (U+0100)
  0x10, 0x9A, 0x04, 0x28, 0x11, 0x22, 0x38, 0x12, 0xFD, 0x38, 0x26, 0xEF, 0x22, 0x82, 0xAA, 0xE5,
  0x28, 0x92, 0xD7, 0xB9, 0x02, 0xF5, 0x8D, 0x06, 0xC8, 0x71, 0x9D, 0x34, 0xF5, 0xD9, 0x20, 0xD0,
  0x90,
  // "ā" (U+0101)
  0x10, 0x9A, 0x89, 0x04, 0x01, 0x22, 0x01, 0xCE, 0xB2, 0x84, 0x54, 0xF5, 0x2D, 0xA8, 0x96, 0x79,
  0xD3, 0xE7, 0x9D, 0x5F, 0x73, 0xEB, 0xA7,
  // "Ă" (U+0102)
  0x18, 0x26, 0x55, 0x62, 0x82, 0x3F, 0xE3, 0x30, 0x01, 0x38, 0x12, 0xFD, 0x38, 0x26, 0xEF, 0x22,
  0x82, 0xAA, 0xE5, 0x28, 0x92, 0xD7, 0xB9, 0x02, 0xF5, 0x8D, 0x06, 0xC8, 0x71, 0x9D, 0x34, 0xF5,
  0xD9, 0x20, 0xD0, 0x90,
  // "ă" (U+0103)
  0x18, 0x76, 0x55, 0x60, 0x3F, 0xE3, 0x28, 0x51, 0x10, 0x1C, 0xEB, 0x28, 0x45, 0x4F, 0x52, 0xDA,
  0x89, 0x67, 0x9D, 0x3E, 0x79, 0xD5, 0xF7, 0x3E, 0xBA, 0x70,
  // "Ą" (U+0104)
  0x18, 0x12, 0xFD, 0x38, 0x26, 0xEF, 0x22, 0x82, 0xAA, 0xE5, 0x28, 0x92, 0xD7, 0xB9, 0x02, 0xF5,
  0x8D, 0x06, 0xC8, 0x71, 0x9D, 0x34, 0xF5, 0xD9, 0x29, 0x09, 0x30, 0x70, 0x84, 0x81, 0x6F, 0x34,
  0x02, 0x10,
  // "ą" (U+0105)
  0x82, 0x1C, 0xEB, 0x28, 0x45, 0x4F, 0x52, 0xDA, 0x89, 0x67, 0x9D, 0x3E, 0x79, 0xD5, 0xF7, 0x3E,
  0xCF, 0x72, 0x07, 0x08, 0x38, 0x16, 0xF3, 0x30, 0x21,
  // "Ć" (U+0106)
  0x28, 0x12, 0xD5, 0x20, 0x01, 0x28, 0x92, 0x3D, 0xEA, 0x0E, 0xA4, 0x65, 0xF2, 0x20, 0x79, 0x30,
  0x79, 0x38, 0x15, 0xF1, 0x38, 0x7E, 0xA3, 0x50, 0x5D, 0xF9,
  // "ć" (U+0107)
  0x18, 0x42, 0xD5, 0x01, 0x12, 0x87, 0x9E, 0xC5, 0xF4, 0x48, 0xC2, 0x08, 0x0C, 0x28, 0x66, 0xF4,
  0x60, 0xAE, 0xB0,
  // "Ĉ" (U+0108)
  0x20, 0x50, 0x72, 0x82, 0x4B, 0x97, 0x68, 0x92, 0x3D, 0xEA, 0x0E, 0xA4, 0x65, 0xF2, 0x20, 0x79,
  0x30, 0x79, 0x38, 0x15, 0xF1, 0x38, 0x7E, 0xA3, 0x50, 0x5D, 0xF9,
  // "ĉ" (U+0109)
  0x18, 0x55, 0x70, 0x4B, 0x97, 0x58, 0x79, 0xEC, 0x5F, 0x44, 0x8C, 0x20, 0x80, 0xC2, 0x86, 0x6F,
  0x46, 0x0A, 0xEB,
  // "Ċ" (U+010A)
  0x20, 0x70, 0xB4, 0x01, 0x28, 0x92, 0x3D, 0xEA, 0x0E, 0xA4, 0x65, 0xF2, 0x20, 0x79, 0x30, 0x79,
  0x38, 0x15, 0xF1, 0x38, 0x7E, 0xA3, 0x50, 0x5D, 0xF9,
  // "ċ" (U+010B)
  0x10, 0x70, 0xB3, 0x01, 0x28, 0x79, 0xEC, 0x5F, 0x44, 0x8C, 0x20, 0x80, 0xC2, 0x86, 0x6F, 0x46,
  0x0A, 0xEB,
  // "Č" (U+010C)
  0x18, 0x23, 0x42, 0x52, 0x81, 0xDE, 0x26, 0x89, 0x23, 0xDE, 0xA0, 0xEA, 0x46, 0x5F, 0x22, 0x07,
  0x93, 0x07, 0x93, 0x81, 0x5F, 0x13, 0x87, 0xEA, 0x35, 0x05, 0xDF, 0x90,
  // "č" (U+010D)
  0x86, 0x34, 0x25, 0x0D, 0xE2, 0x58, 0x79, 0xEC, 0x5F, 0x44, 0x8C, 0x20, 0x80, 0xC2, 0x86, 0x6F,
  0x46, 0x0A, 0xEB,
  // "Ď" (U+010E)
  0x18, 0x23, 0x42, 0x53, 0x81, 0xDE, 0x27, 0x04, 0xA8, 0xC6, 0xC4, 0x04, 0xF4, 0x9F, 0x14, 0xF1,
  0x0E, 0x74, 0xF1, 0x0C, 0x94, 0xF1, 0x0D, 0x94, 0xF1, 0x0E, 0x64, 0xF5, 0x9E, 0x14, 0xA0, 0xC0,
  0x41,
  // "ď" (U+010F)
  0x38, 0x29, 0xB6, 0xB3, 0x87, 0x8B, 0x11, 0x0B, 0xDB, 0xB2, 0x83, 0x6F, 0x4D, 0xB2, 0x83, 0x8C,
  0x08, 0xB2, 0x83, 0x8C, 0x08, 0xB2, 0x83, 0x6F, 0x4D, 0xB3, 0x82, 0xBD, 0x9B, 0x20,
  // "Đ" (U+0110)
  0x04, 0xA8, 0x96, 0xC4, 0x04, 0xF4, 0x9F, 0x14, 0xF2, 0x0E, 0x7D, 0xA1, 0x8A, 0x3C, 0x96, 0xF4,
  0x0D, 0x94, 0xF1, 0x0F, 0x64, 0xF5, 0x9E, 0x14, 0xA0, 0xC0, 0x41,
  // "đ" (U+0111)
  0x20, 0xAA, 0x06, 0x28, 0xB7, 0x2A, 0xC1, 0x0B, 0xDB, 0xB0, 0x6F, 0x4D, 0xB0, 0x8C, 0x08, 0xB0,
  0x8C, 0x09, 0xB0, 0x6F, 0x4D, 0xB2, 0x82, 0xBD, 0x9B, 0x10,
  // "Ē" (U+0112)
  0x10, 0x9A, 0x85, 0x40, 0x12, 0x20, 0x4B, 0x87, 0x34, 0xF4, 0x30, 0x4F, 0x22, 0x04, 0xB1, 0x86,
  0x4F, 0x42, 0x04, 0xF1, 0x28, 0x44, 0xF4, 0x30, 0x4B, 0x03,
  // "ē" (U+0113)
  0x10, 0x9A, 0x83, 0x40, 0x12, 0x22, 0x89, 0x0A, 0xEB, 0x05, 0xE4, 0xD7, 0x8B, 0x89, 0x69, 0x8C,
  0x22, 0x15, 0xF5, 0x43, 0x09, 0xED, 0x30,
  // "Ĕ" (U+0114)
  0x87, 0x65, 0x56, 0x03, 0xFE, 0x32, 0x00, 0x12, 0x04, 0xB8, 0x73, 0x4F, 0x43, 0x04, 0xF2, 0x20,
  0x4B, 0x18, 0x64, 0xF4, 0x20, 0x4F, 0x12, 0x84, 0x4F, 0x43, 0x04, 0xB0, 0x30,
  // "ĕ" (U+0115)
  0x18, 0x76, 0x55, 0x60, 0x3F, 0xE3, 0x20, 0x01, 0x28, 0x90, 0xAE, 0xB0, 0x5E, 0x4D, 0x78, 0xB8,
  0x96, 0x98, 0xC2, 0x21, 0x5F, 0x54, 0x30, 0x9E, 0xD3,
  // "Ė" (U+0116)
  0x10, 0x70, 0xB4, 0x01, 0x20, 0x4B, 0x87, 0x34, 0xF4, 0x30, 0x4F, 0x22, 0x04, 0xB1, 0x86, 0x4F,
  0x42, 0x04, 0xF1, 0x28, 0x44, 0xF4, 0x30, 0x4B, 0x03,
  // "ė" (U+0117)
  0x20, 0x70, 0xB4, 0x01, 0x28, 0x90, 0xAE, 0xB0, 0x5E, 0x4D, 0x78, 0xB8, 0x96, 0x98, 0xC2, 0x21,
  0x5F, 0x54, 0x30, 0x9E, 0xD3,
  // "Ę" (U+0118)
  0x04, 0xB8, 0x73, 0x4F, 0x43, 0x04, 0xF2, 0x20, 0x4B, 0x18, 0x64, 0xF4, 0x20, 0x4F, 0x12, 0x84,
  0x4F, 0x43, 0x04, 0xB0, 0x32, 0x07, 0x08, 0x38, 0x16, 0xF3, 0x30, 0x21,
  // "ę" (U+0119)
  0x18, 0x95, 0xAE, 0x90, 0x5F, 0x5E, 0x58, 0xC0, 0xA8, 0x8B, 0x89, 0x19, 0x5E, 0x66, 0x30, 0x9E,
  0xF4, 0x20, 0x20, 0xB3, 0x81, 0x7A, 0x12, 0x81, 0x3E, 0x40,
  // "Ě" (U+011A)
  0x82, 0x34, 0x25, 0x28, 0x1D, 0xE2, 0x60, 0x4B, 0x87, 0x34, 0xF4, 0x30, 0x4F, 0x22, 0x04, 0xB1,
  0x86, 0x4F, 0x42, 0x04, 0xF1, 0x28, 0x44, 0xF4, 0x30, 0x4B, 0x03,
  // "ě" (U+011B)
  0x82, 0x34, 0x25, 0x28, 0x1D, 0xE2, 0x78, 0x90, 0xAE, 0xB0, 0x5E, 0x4D, 0x78, 0xB8, 0x96, 0x98,
  0xC2, 0x21, 0x5F, 0x54, 0x30, 0x9E, 0xD3,
  // "Ĝ" (U+011C)
  0x20, 0x50, 0x73, 0x82, 0x4B, 0x97, 0x71, 0x89, 0x42, 0xBE, 0xD4, 0x0D, 0xC4, 0x62, 0x5F, 0x23,
  0x07, 0x94, 0x8A, 0x67, 0xF0, 0xCF, 0x95, 0xF2, 0x2C, 0x90, 0xEA, 0x3D, 0x90, 0x4D, 0xFD, 0x60,
  // "ĝ" (U+011D)
  0x20, 0x50, 0x72, 0x82, 0x4B, 0x97, 0x68, 0xB3, 0xBD, 0xAB, 0x6F, 0x4D, 0xB8, 0xC0, 0x9B, 0x8C,
  0x08, 0xB6, 0xF4, 0xDB, 0x0C, 0xDB, 0xB3, 0x89, 0x29, 0xB3, 0x64, 0xD7, 0x3D, 0xEA, 0x10,
  // "Ğ" (U+011E)
  0x18, 0x26, 0x55, 0x62, 0x82, 0x3F, 0xE3, 0x30, 0x01, 0x38, 0x94, 0x2B, 0xED, 0x40, 0xDC, 0x46,
  0x25, 0xF2, 0x30, 0x79, 0x48, 0xA6, 0x7F, 0x0C, 0xF9, 0x5F, 0x22, 0xC9, 0x0E, 0xA3, 0xD9, 0x04,
  0xDF, 0xD6,
  // "ğ" (U+011F)
  0x18, 0x76, 0x55, 0x60, 0x3F, 0xE3, 0x20, 0x01, 0x28, 0xB3, 0xBD, 0xAB, 0x6F, 0x4D, 0xB8, 0xC0,
  0x9B, 0x8C, 0x08, 0xB6, 0xF4, 0xDB, 0x0C, 0xDB, 0xB3, 0x89, 0x29, 0xB3, 0x64, 0xD7, 0x3D, 0xEA,
  0x10,
  // "Ġ" (U+0120)
  0x20, 0x70, 0xB5, 0x01, 0x38, 0x94, 0x2B, 0xED, 0x40, 0xDC, 0x46, 0x25, 0xF2, 0x30, 0x79, 0x48,
  0xA6, 0x7F, 0x0C, 0xF9, 0x5F, 0x22, 0xC9, 0x0E, 0xA3, 0xD9, 0x04, 0xDF, 0xD6,
  // "ġ" (U+0121)
  0x20, 0x70, 0xB4, 0x01, 0x28, 0xB3, 0xBD, 0xAB, 0x6F, 0x4D, 0xB8, 0xC0, 0x9B, 0x8C, 0x08, 0xB6,
  0xF4, 0xDB, 0x0C, 0xDB, 0xB3, 0x89, 0x29, 0xB3, 0x64, 0xD7, 0x3D, 0xEA, 0x10,
  // "Ģ" (U+0122)
  0x18, 0x94, 0x2B, 0xED, 0x40, 0xDC, 0x46, 0x25, 0xF2, 0x30, 0x79, 0x48, 0xA6, 0x7F, 0x0C, 0xF9,
  0x5F, 0x22, 0xC9, 0x0E, 0xA3, 0xD9, 0x04, 0xDF, 0xD6, 0x71, 0x01, 0x03, 0x40, 0x70, 0x92,
  // "ģ" (U+0123)
  0x20, 0x40, 0xC3, 0x00, 0x22, 0x8B, 0x3B, 0xDA, 0xB6, 0xF4, 0xDB, 0x8C, 0x09, 0xB8, 0xC0, 0x8B,
  0x6F, 0x4D, 0xB0, 0xCD, 0xBB, 0x38, 0x92, 0x9B, 0x36, 0x4D, 0x73, 0xDE, 0xA1,
  // "Ĥ" (U+0124)
  0x20, 0x50, 0x73, 0x82, 0x4B, 0x97, 0x78, 0xA1, 0x4F, 0x10, 0xC9, 0x4F, 0x10, 0xC9, 0x4F, 0x20,
  0xC9, 0x4C, 0x8A, 0x79, 0x4F, 0x42, 0xC9, 0x4F, 0x10, 0xC9, 0x4F, 0x10, 0xC9, 0x4F, 0x10, 0xC9,
  // "ĥ" (U+0125)
  0x10, 0x50, 0x73, 0x82, 0x4B, 0x97, 0x72, 0x05, 0x94, 0x05, 0x94, 0x8C, 0x15, 0xEA, 0xE5, 0x05,
  0xF6, 0xBC, 0x05, 0xF0, 0x7D, 0x05, 0xF0, 0x7D, 0x05, 0xF0, 0x7D, 0x05, 0xF0, 0x7D,
  // "Ħ" (U+0126)
  0x84, 0x4F, 0x20, 0xCA, 0x1E, 0x87, 0x56, 0xF4, 0x3C, 0xB1, 0x4C, 0x8B, 0x39, 0x04, 0xF4, 0x2C,
  0x90, 0x4F, 0x10, 0xC9, 0x04, 0xF1, 0x0C, 0x90, 0x4F, 0x10, 0xC9, 0x10,
  // "ħ" (U+0127)
  0x05, 0x93, 0xB8, 0xB6, 0x20, 0x5E, 0xAE, 0x55, 0xF6, 0xBC, 0x5F, 0x07, 0xD5, 0xF0, 0x7D, 0x5F,
  0x07, 0xD5, 0xF0, 0x7D,
  // "Ĩ" (U+0128)
  0x87, 0x3E, 0x4B, 0x87, 0xD8, 0x13, 0x0A, 0xA8, 0x22, 0x1F, 0x82, 0x90, 0x62, 0x90, 0x62, 0x90,
  0x62, 0x90, 0x62, 0x98, 0x17, 0x0A, 0xA0, 0x20,
  // "ĩ" (U+0129)
  0x87, 0x3E, 0x4B, 0x87, 0xD8, 0x14, 0x05, 0x92, 0x05, 0x92, 0x05, 0x92, 0x05, 0x92, 0x05, 0x92,
  0x05, 0x91,
  // "Ī" (U+012A)
  0x09, 0xA8, 0x44, 0x12, 0x20, 0xAA, 0x82, 0x21, 0xF8, 0x29, 0x06, 0x29, 0x06, 0x29, 0x06, 0x29,
  0x06, 0x29, 0x81, 0x70, 0xAA, 0x02,
  // "ī" (U+012B)
  0x09, 0xA8, 0x24, 0x12, 0x22, 0x05, 0x92, 0x05, 0x92, 0x05, 0x92, 0x05, 0x92, 0x05, 0x92, 0x05,
  0x91,
  // "Ĭ" (U+012C)
  0x89, 0x36, 0x55, 0x63, 0xFE, 0x30, 0x11, 0x0A, 0xA8, 0x22, 0x1F, 0x82, 0x90, 0x62, 0x90, 0x62,
  0x90, 0x62, 0x90, 0x62, 0x98, 0x17, 0x0A, 0xA0, 0x20,
  // "ĭ" (U+012D)
  0x89, 0x16, 0x55, 0x63, 0xFE, 0x30, 0x11, 0x20, 0x59, 0x20, 0x59, 0x20, 0x59, 0x20, 0x59, 0x20,
  0x59, 0x20, 0x59, 0x10,
  // "Į" (U+012E)
  0x0A, 0xA8, 0x22, 0x1F, 0x82, 0x90, 0x62, 0x90, 0x62, 0x90, 0x62, 0x90, 0x62, 0x98, 0x17, 0x0A,
  0xA8, 0x22, 0x07, 0x82, 0x81, 0x6F, 0x32, 0x02, 0x10,
  // "į" (U+012F)
  0x04, 0x0D, 0x28, 0xB2, 0x10, 0x5F, 0x05, 0xF0, 0x5F, 0x05, 0xF0, 0x5F, 0x06, 0xF0, 0x78, 0x06,
  0xF3, 0x02, 0x10,
  // "İ" (U+0130)
  0x10, 0x70, 0xB3, 0x81, 0x10, 0xAA, 0x82, 0x21, 0xF8, 0x29, 0x06, 0x29, 0x06, 0x29, 0x06, 0x29,
  0x06, 0x29, 0x81, 0x70, 0xAA, 0x02,
  // "ı" (U+0131)
  0x89, 0x15, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0x90,
  // "Ĳ" (U+0132)
  0x0A, 0xA8, 0xC6, 0x6F, 0x11, 0xF8, 0x4F, 0x10, 0xF6, 0x4F, 0x10, 0xF6, 0x4F, 0x10, 0xF6, 0x4F,
  0x10, 0xF6, 0x4F, 0x10, 0xF7, 0x4F, 0x1A, 0xA8, 0x16, 0xF1, 0x30, 0x79, 0x38, 0x19, 0xF9, 0x30,
  0x10, 0x22,
  // "ĳ" (U+0133)
  0x85, 0x4D, 0x04, 0xD0, 0x12, 0x8B, 0x41, 0x5F, 0x05, 0xF5, 0xF0, 0x5F, 0x5F, 0x05, 0xF5, 0xF0,
  0x5F, 0x5F, 0x05, 0xF5, 0xF0, 0x59, 0x30, 0x59, 0x28, 0x11, 0xAE, 0x28, 0x15, 0xE7,
  // "Ĵ" (U+0134)
  0x18, 0x55, 0x70, 0x4B, 0x97, 0x58, 0xC7, 0x4F, 0x10, 0x4F, 0x10, 0x4F, 0x10, 0x4F, 0x10, 0x4F,
  0x10, 0x4F, 0x10, 0x4F, 0x10, 0x4F, 0x10, 0x7F, 0x09, 0xF9, 0x01, 0x22,
  // "ĵ" (U+0135)
  0x18, 0x55, 0x70, 0x4B, 0x97, 0x50, 0x59, 0x20, 0x59, 0x20, 0x59, 0x20, 0x59, 0x20, 0x59, 0x20,
  0x59, 0x28, 0x90, 0x5F, 0x01, 0x9E, 0x05, 0xE7, 0x10,
  // "Ķ" (U+0136)
  0x8A, 0x44, 0xF1, 0x3F, 0x44, 0xF1, 0xBB, 0x04, 0xF6, 0xF3, 0x04, 0xFD, 0xB2, 0x8A, 0x64, 0xFE,
  0xE1, 0x04, 0xF3, 0xF7, 0x04, 0xF1, 0x9E, 0x04, 0xF1, 0x2F, 0x67, 0x10, 0x10, 0x34, 0x07, 0x09,
  0x20,
  // "ķ" (U+0137)
  0x05, 0x93, 0x05, 0x93, 0x8B, 0x45, 0xF0, 0xAB, 0x5F, 0x5F, 0x25, 0xED, 0x90, 0x5F, 0xDE, 0x05,
  0xF1, 0xE6, 0x5F, 0x08, 0xE6, 0x01, 0x03, 0x30, 0x70, 0x92,
  // "ĸ" (U+0138)
  0x8B, 0x45, 0xF0, 0xAB, 0x5F, 0x4F, 0x25, 0xED, 0x90, 0x5F, 0xDD, 0x05, 0xF1, 0xE6, 0x5F, 0x08,
  0xD0,
  // "Ĺ" (U+0139)
  0x81, 0x2D, 0x52, 0x00, 0x13, 0x81, 0x4F, 0x12, 0x81, 0x4F, 0x12, 0x81, 0x4F, 0x12, 0x81, 0x4F,
  0x12, 0x81, 0x4F, 0x12, 0x81, 0x4F, 0x12, 0x84, 0x4F, 0x54, 0x14, 0xB0, 0x50,
  // "ĺ" (U+013A)
  0x8B, 0x22, 0xD5, 0x11, 0x05, 0xF0, 0x5F, 0x05, 0xF0, 0x5F, 0x05, 0xF0, 0x5F, 0x05, 0xF0, 0x59,
  0x10,
  // "Ļ" (U+013B)
  0x81, 0x4F, 0x12, 0x81, 0x4F, 0x12, 0x81, 0x4F, 0x12, 0x81, 0x4F, 0x12, 0x81, 0x4F, 0x12, 0x81,
  0x4F, 0x12, 0x84, 0x4F, 0x54, 0x14, 0xB0, 0x56, 0x01, 0x03, 0x30, 0x70, 0x92,
  // "ļ" (U+013C)
  0x89, 0x55, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0x92, 0x82, 0x13, 0x79,
  // "Ľ" (U+013D)
  0x89, 0x34, 0xF1, 0x6B, 0x4F, 0x11, 0x14, 0xF1, 0x28, 0x14, 0xF1, 0x28, 0x14, 0xF1, 0x28, 0x14,
  0xF1, 0x28, 0x44, 0xF5, 0x41, 0x4B, 0x05,
  // "ľ" (U+013E)
  0x87, 0x5F, 0x6B, 0x5F, 0x11, 0x59, 0x20, 0x59, 0x20, 0x59, 0x20, 0x59, 0x20, 0x59, 0x20, 0x59,
  0x20,
  // "Ŀ" (U+013F)
  0x81, 0x4F, 0x12, 0x81, 0x4F, 0x12, 0x81, 0x4F, 0x12, 0x89, 0x34, 0xF1, 0x7B, 0x4F, 0x10, 0x14,
  0xF1, 0x28, 0x44, 0xF5, 0x41, 0x4B, 0x05,
  // "ŀ" (U+0140)
  0x05, 0x92, 0x05, 0x92, 0x05, 0x92, 0x87, 0x5F, 0x7B, 0x5F, 0x01, 0x59, 0x20, 0x59, 0x20, 0x59,
  0x20,
  // "Ł" (U+0141)
  0x81, 0x2F, 0x32, 0x81, 0x2F, 0x32, 0x89, 0x32, 0xF9, 0x30, 0x2F, 0xE3, 0x0C, 0xF4, 0x28, 0x17,
  0xF3, 0x28, 0x42, 0xF7, 0x42, 0x2B, 0x07,
  // "ł" (U+0142)
  0x8A, 0x63, 0xF2, 0x3F, 0x23, 0xF3, 0x3F, 0xDB, 0xF3, 0x8F, 0x23, 0xF2, 0x3F, 0x20,
  // "Ń" (U+0143)
  0x28, 0x12, 0xD5, 0x40, 0x01, 0x38, 0x64, 0xF9, 0x03, 0xF1, 0x4A, 0x8C, 0x21, 0x3F, 0x14, 0xFE,
  0x73, 0xF1, 0x4F, 0x8D, 0x3F, 0x14, 0xF2, 0xF8, 0xF1, 0x4F, 0x0A, 0xEF, 0x14, 0xF0, 0x4A, 0x01,
  0x04, 0x92, 0x81, 0xCF, 0x10,
  // "ń" (U+0144)
  0x28, 0x12, 0xD5, 0x28, 0xB7, 0x11, 0x05, 0xCA, 0xE5, 0x5F, 0x6B, 0xC5, 0xF0, 0x7D, 0x5F, 0x07,
  0xD5, 0xF0, 0x7D, 0x5F, 0x07, 0xD0,
  // "Ņ" (U+0145)
  0x86, 0x4F, 0x90, 0x3F, 0x14, 0xA8, 0xC2, 0x13, 0xF1, 0x4F, 0xE7, 0x3F, 0x14, 0xF8, 0xD3, 0xF1,
  0x4F, 0x2F, 0x8F, 0x14, 0xF0, 0xAE, 0xF1, 0x4F, 0x04, 0xA0, 0x10, 0x49, 0x28, 0x1C, 0xF1, 0x72,
  0x01, 0x03, 0x50, 0x70, 0x93,
  // "ņ" (U+0146)
  0x8B, 0x45, 0xCA, 0xE5, 0x5F, 0x6B, 0xC5, 0xF0, 0x7D, 0x5F, 0x07, 0xD5, 0xF0, 0x7D, 0x5F, 0x07,
  0xD7, 0x01, 0x03, 0x30, 0x70, 0x91,
  // "Ň" (U+0147)
  0x18, 0x23, 0x42, 0x54, 0x81, 0xDE, 0x27, 0x28, 0x64, 0xF9, 0x03, 0xF1, 0x4A, 0x8C, 0x21, 0x3F,
  0x14, 0xFE, 0x73, 0xF1, 0x4F, 0x8D, 0x3F, 0x14, 0xF2, 0xF8, 0xF1, 0x4F, 0x0A, 0xEF, 0x14, 0xF0,
  0x4A, 0x01, 0x04, 0x92, 0x81, 0xCF, 0x10,
  // "ň" (U+0148)
  0x18, 0x23, 0x42, 0x52, 0x81, 0xDE, 0x25, 0x8B, 0x45, 0xCA, 0xE5, 0x5F, 0x6B, 0xC5, 0xF0, 0x7D,
  0x5F, 0x07, 0xD5, 0xF0, 0x7D, 0x5F, 0x07, 0xD0,
  // "ŉ" (U+0149)
  0x05, 0x0E, 0x40, 0x80, 0xB4, 0x8C, 0x28, 0xBC, 0xAE, 0x50, 0x5F, 0x6B, 0xC0, 0x5F, 0x07, 0xD0,
  0x5F, 0x07, 0xD0, 0x5F, 0x07, 0xD0, 0x5F, 0x07, 0xD0,
  // "Ŋ" (U+014A)
  0x86, 0x4F, 0xA0, 0x3F, 0x14, 0xA8, 0xB3, 0x23, 0xF1, 0x4F, 0xD9, 0x3F, 0x14, 0xF6, 0xF5, 0xF1,
  0x4F, 0x0D, 0xBF, 0x14, 0xF0, 0x6A, 0x01, 0x04, 0x92, 0x82, 0xEF, 0x14, 0x92, 0x81, 0x6F, 0x14,
  0x06, 0x94, 0x81, 0x9F, 0x94, 0x01, 0x02, 0x20,
  // "ŋ" (U+014B)
  0x8B, 0x45, 0xCB, 0xE4, 0x5F, 0x6B, 0xC5, 0xF0, 0x7D, 0x5F, 0x07, 0xD5, 0xF0, 0x7D, 0x5F, 0x07,
  0xD3, 0x07, 0x0D, 0x28, 0x11, 0xAC, 0x28, 0x16, 0xE5,
  // "Ō" (U+014C)
  0x10, 0x9A, 0x04, 0x28, 0x11, 0x22, 0x38, 0x24, 0xDE, 0xA2, 0x89, 0x2E, 0x94, 0xE8, 0x5F, 0x10,
  0x8D, 0x79, 0x28, 0x16, 0xF7, 0x92, 0x8A, 0x16, 0xF5, 0xF1, 0x08, 0xD1, 0xE9, 0x4E, 0x80, 0x4D,
  0xEA, 0x10,
  // "ō" (U+014D)
  0x10, 0x9A, 0x83, 0x40, 0x12, 0x22, 0x8B, 0x3A, 0xEB, 0x15, 0xF4, 0xC9, 0x8C, 0x08, 0xC8, 0xC0,
  0x8C, 0x5F, 0x4C, 0x90, 0x9E, 0xC1,
  // "Ŏ" (U+014E)
  0x18, 0x26, 0x55, 0x62, 0x82, 0x3F, 0xE3, 0x30, 0x01, 0x38, 0x24, 0xDE, 0xA2, 0x89, 0x2E, 0x94,
  0xE8, 0x5F, 0x10, 0x8D, 0x79, 0x28, 0x16, 0xF7, 0x92, 0x8A, 0x16, 0xF5, 0xF1, 0x08, 0xD1, 0xE9,
  0x4E, 0x80, 0x4D, 0xEA, 0x10,
  // "ŏ" (U+014F)
  0x18, 0x76, 0x55, 0x60, 0x3F, 0xE3, 0x20, 0x01, 0x28, 0xB3, 0xAE, 0xB1, 0x5F, 0x4C, 0x98, 0xC0,
  0x8C, 0x8C, 0x08, 0xC5, 0xF4, 0xC9, 0x09, 0xEC, 0x10,
  // "Ő" (U+0150)
  0x28, 0x22, 0xC9, 0xA2, 0x81, 0x10, 0x22, 0x82, 0x4D, 0xEA, 0x28, 0x92, 0xE9, 0x4E, 0x85, 0xF1,
  0x08, 0xD7, 0x92, 0x81, 0x6F, 0x79, 0x28, 0xA1, 0x6F, 0x5F, 0x10, 0x8D, 0x1E, 0x94, 0xE8, 0x04,
  0xDE, 0xA1,
  // "ő" (U+0151)
  0x18, 0x62, 0xC9, 0xA0, 0x10, 0x22, 0x8B, 0x3A, 0xEB, 0x15, 0xF4, 0xC9, 0x8C, 0x08, 0xC8, 0xC0,
  0x8C, 0x5F, 0x4C, 0x90, 0x9E, 0xC1,
  // "Œ" (U+0152)
  0x10, 0x40, 0xDC, 0x89, 0x56, 0x1E, 0x94, 0xF6, 0x31, 0x5F, 0x11, 0xF4, 0x28, 0x27, 0xF0, 0x1B,
  0x89, 0x54, 0x7F, 0x01, 0xF6, 0x20, 0x5F, 0x11, 0xF4, 0x28, 0x91, 0x1E, 0x94, 0xF6, 0x31, 0x04,
  0xDC, 0x06,
  // "œ" (U+0153)
  0x18, 0xA1, 0x9E, 0xA7, 0xEC, 0x15, 0xF4, 0xCF, 0x4C, 0x88, 0xC0, 0x8B, 0x8A, 0x7B, 0x8C, 0x08,
  0xD2, 0x22, 0x5F, 0x4C, 0xF5, 0x44, 0x09, 0xEB, 0x7E, 0xE5,
  // "Ŕ" (U+0154)
  0x28, 0x12, 0xD5, 0x30, 0x01, 0x20, 0x4A, 0x8A, 0x4C, 0x30, 0x4F, 0x5C, 0xC0, 0x4F, 0x17, 0xF0,
  0x4F, 0x2A, 0xC0, 0x4B, 0x8A, 0x23, 0x04, 0xF6, 0xF3, 0x04, 0xF1, 0xBB, 0x04, 0xF1, 0x3F, 0x40,
  // "ŕ" (U+0155)
  0x18, 0x96, 0x2D, 0x50, 0x11, 0x05, 0xCA, 0x95, 0xF7, 0x25, 0x92, 0x05, 0x92, 0x05, 0x92, 0x05,
  0x92,
  // "Ŗ" (U+0156)
  0x04, 0xA8, 0xA4, 0xC3, 0x04, 0xF5, 0xCC, 0x04, 0xF1, 0x7F, 0x04, 0xF2, 0xAC, 0x04, 0xB8, 0xA2,
  0x30, 0x4F, 0x6F, 0x30, 0x4F, 0x1B, 0xB0, 0x4F, 0x13, 0xF4, 0x71, 0x01, 0x03, 0x40, 0x70, 0x92,
  // "ŗ" (U+0157)
  0x87, 0x5C, 0xA9, 0x5F, 0x72, 0x59, 0x20, 0x59, 0x20, 0x59, 0x20, 0x59, 0x60, 0x10, 0x32, 0x07,
  0x09, 0x20,
  // "Ř" (U+0158)
  0x18, 0x23, 0x42, 0x53, 0x81, 0xDE, 0x27, 0x04, 0xA8, 0xA4, 0xC3, 0x04, 0xF5, 0xCC, 0x04, 0xF1,
  0x7F, 0x04, 0xF2, 0xAC, 0x04, 0xB8, 0xA2, 0x30, 0x4F, 0x6F, 0x30, 0x4F, 0x1B, 0xB0, 0x4F, 0x13,
  0xF4,
  // "ř" (U+0159)
  0x86, 0x34, 0x25, 0x0D, 0xE2, 0x48, 0x75, 0xCA, 0x95, 0xF7, 0x25, 0x92, 0x05, 0x92, 0x05, 0x92,
  0x05, 0x92,
  // "Ś" (U+015A)
  0x18, 0x12, 0xD5, 0x20, 0x01, 0x38, 0x92, 0xAE, 0xD2, 0x6E, 0x47, 0x08, 0xE1, 0x28, 0x23, 0xFE,
  0x42, 0x82, 0x5E, 0xF2, 0x28, 0x92, 0x3F, 0x56, 0x56, 0xF3, 0x7E, 0xE7, 0x10,
  // "ś" (U+015B)
  0x18, 0xA0, 0x2D, 0x50, 0x11, 0x03, 0xDE, 0x79, 0xC4, 0x36, 0xF8, 0x28, 0x91, 0x5E, 0x95, 0x4B,
  0xB8, 0xFD, 0x40,
  // "Ŝ" (U+015C)
  0x10, 0x50, 0x72, 0x82, 0x4B, 0x97, 0x78, 0x92, 0xAE, 0xD2, 0x6E, 0x47, 0x08, 0xE1, 0x28, 0x23,
  0xFE, 0x42, 0x82, 0x5E, 0xF2, 0x28, 0x92, 0x3F, 0x56, 0x56, 0xF3, 0x7E, 0xE7, 0x10,
  // "ŝ" (U+015D)
  0x18, 0x55, 0x70, 0x4B, 0x97, 0x48, 0x91, 0x3D, 0xE7, 0x9C, 0x43, 0x6F, 0x82, 0x89, 0x15, 0xE9,
  0x54, 0xBB, 0x8F, 0xD4,
  // "Ş" (U+015E)
  0x18, 0x92, 0xAE, 0xD2, 0x6E, 0x47, 0x08, 0xE1, 0x28, 0x23, 0xFE, 0x42, 0x82, 0x5E, 0xF2, 0x28,
  0x92, 0x3F, 0x56, 0x56, 0xF3, 0x7E, 0xE7, 0x20, 0x60, 0x13, 0x09, 0x0B, 0x28, 0x12, 0xD8, 0x20,
  // "ş" (U+015F)
  0x89, 0x13, 0xDE, 0x79, 0xC4, 0x36, 0xF8, 0x28, 0x94, 0x5E, 0x95, 0x4B, 0xB8, 0xFD, 0x40, 0x61,
  0x28, 0x49, 0xB0, 0x2D, 0x81,
  // "Š" (U+0160)
  0x82, 0x34, 0x25, 0x28, 0x1D, 0xE2, 0x78, 0x92, 0xAE, 0xD2, 0x6E, 0x47, 0x08, 0xE1, 0x28, 0x23,
  0xFE, 0x42, 0x82, 0x5E, 0xF2, 0x28, 0x92, 0x3F, 0x56, 0x56, 0xF3, 0x7E, 0xE7, 0x10,
  // "š" (U+0161)
  0x86, 0x34, 0x25, 0x0D, 0xE2, 0x48, 0x91, 0x3D, 0xE7, 0x9C, 0x43, 0x6F, 0x82, 0x89, 0x15, 0xE9,
  0x54, 0xBB, 0x8F, 0xD4,
  // "Ţ" (U+0162)
  0x0D, 0xB8, 0x90, 0x92, 0x7F, 0x31, 0x05, 0xF1, 0x28, 0x15, 0xF1, 0x28, 0x15, 0xF1, 0x28, 0x15,
  0xF1, 0x28, 0x15, 0xF1, 0x28, 0x15, 0xF1, 0x30, 0x60, 0x13, 0x09, 0x0B, 0x28, 0x12, 0xD8, 0x10,
  // "ţ" (U+0163)
  0x18, 0x2E, 0x10, 0x9A, 0x8A, 0x63, 0x5F, 0x40, 0x4F, 0x10, 0x4F, 0x10, 0x3F, 0x61, 0x0C, 0xE3,
  0x06, 0x12, 0x84, 0x9B, 0x02, 0xD8, 0x10,
  // "Ť" (U+0164)
  0x82, 0x34, 0x25, 0x28, 0x1D, 0xE2, 0x60, 0xDB, 0x89, 0x09, 0x27, 0xF3, 0x10, 0x5F, 0x12, 0x81,
  0x5F, 0x12, 0x81, 0x5F, 0x12, 0x81, 0x5F, 0x12, 0x81, 0x5F, 0x12, 0x81, 0x5F, 0x11,
  // "ť" (U+0165)
  0x38, 0x66, 0xB0, 0xE1, 0x11, 0x9A, 0x83, 0x30, 0x5F, 0x42, 0x81, 0x4F, 0x12, 0x81, 0x4F, 0x12,
  0x82, 0x3F, 0x61, 0x28, 0x1C, 0xE3, 0x10,
  // "Ŧ" (U+0166)
  0x0D, 0xB8, 0x90, 0x92, 0x7F, 0x31, 0x05, 0xF1, 0x28, 0x35, 0xF1, 0x04, 0xB8, 0x31, 0x07, 0xF3,
  0x28, 0x15, 0xF1, 0x28, 0x15, 0xF1, 0x10,
  // "ŧ" (U+0167)
  0x18, 0x2E, 0x10, 0x9A, 0x84, 0x36, 0xF4, 0x0C, 0xA8, 0x93, 0x25, 0xF4, 0x03, 0xF6, 0x10, 0xCE,
  0x30,
  // "Ũ" (U+0168)
  0x18, 0x23, 0xE4, 0xB2, 0x82, 0x87, 0xD8, 0x20, 0x14, 0x8D, 0x54, 0xF1, 0x0D, 0x84, 0xF1, 0x0D,
  0x84, 0xF1, 0x0D, 0x84, 0xF1, 0x0D, 0x84, 0xF1, 0x0D, 0x84, 0xF1, 0x0E, 0x71, 0xF9, 0x6F, 0x40,
  0x6D, 0xE8, 0x10,
  // "ũ" (U+0169)
  0x18, 0x91, 0x3E, 0x4B, 0x08, 0x7D, 0x80, 0x13, 0x8B, 0x46, 0xF0, 0x7D, 0x6F, 0x07, 0xD6, 0xF0,
  0x7D, 0x6F, 0x08, 0xD4, 0xF4, 0xCD, 0x0C, 0xE9, 0xD0,
  // "Ū" (U+016A)
  0x10, 0x9A, 0x04, 0x28, 0x11, 0x22, 0x28, 0xD5, 0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xD8, 0x4F, 0x10,
  0xD8, 0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xE7, 0x1F, 0x96, 0xF4, 0x06, 0xDE, 0x81,
  // "ū" (U+016B)
  0x10, 0x9A, 0x8C, 0x24, 0x01, 0x22, 0x06, 0xF0, 0x7D, 0x6F, 0x07, 0xD6, 0xF0, 0x7D, 0x6F, 0x08,
  0xD4, 0xF4, 0xCD, 0x0C, 0xE9, 0xD0,
  // "Ŭ" (U+016C)
  0x18, 0x26, 0x55, 0x62, 0x82, 0x3F, 0xE3, 0x30, 0x01, 0x28, 0xD5, 0x4F, 0x10, 0xD8, 0x4F, 0x10,
  0xD8, 0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xE7, 0x1F, 0x96, 0xF4,
  0x06, 0xDE, 0x81,
  // "ŭ" (U+016D)
  0x18, 0x76, 0x55, 0x60, 0x3F, 0xE3, 0x28, 0xB7, 0x11, 0x06, 0xF0, 0x7D, 0x6F, 0x07, 0xD6, 0xF0,
  0x7D, 0x6F, 0x08, 0xD4, 0xF4, 0xCD, 0x0C, 0xE9, 0xD0,
  // "Ů" (U+016E)
  0x28, 0x14, 0xE6, 0x38, 0x18, 0x7B, 0x38, 0xE1, 0x5F, 0x70, 0x4F, 0x11, 0xD8, 0x4F, 0x10, 0xD8,
  0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xD8, 0x4F, 0x10, 0xE7, 0x1F, 0x96, 0xF4, 0x06,
  0xDE, 0x81,
  // "ů" (U+016F)
  0x18, 0x14, 0xE6, 0x28, 0x18, 0x7B, 0x28, 0xC0, 0x5F, 0x70, 0x6F, 0x17, 0xD6, 0xF0, 0x7D, 0x6F,
  0x07, 0xD6, 0xF0, 0x8D, 0x4F, 0x4C, 0xD0, 0xCE, 0x9D,
  // "Ű" (U+0170)
  0x18, 0x22, 0xC9, 0xA2, 0x81, 0x10, 0x22, 0x8D, 0x54, 0xF1, 0x0D, 0x84, 0xF1, 0x0D, 0x84, 0xF1,
  0x0D, 0x84, 0xF1, 0x0D, 0x84, 0xF1, 0x0D, 0x84, 0xF1, 0x0E, 0x71, 0xF9, 0x6F, 0x40, 0x6D, 0xE8,
  0x10,
  // "ű" (U+0171)
  0x18, 0xC5, 0x2C, 0x9A, 0x01, 0x02, 0x06, 0xF0, 0x7D, 0x6F, 0x07, 0xD6, 0xF0, 0x7D, 0x6F, 0x08,
  0xD4, 0xF4, 0xCD, 0x0C, 0xE9, 0xD0,
  // "Ų" (U+0172)
  0x8D, 0x54, 0xF1, 0x0D, 0x84, 0xF1, 0x0D, 0x84, 0xF1, 0x0D, 0x84, 0xF1, 0x0D, 0x84, 0xF1, 0x0D,
  0x84, 0xF1, 0x0E, 0x71, 0xF9, 0x6F, 0x50, 0x6D, 0xFC, 0x40, 0xD0, 0x23, 0x81, 0x2E, 0x24, 0x0C,
  0x0A, 0x10,
  // "ų" (U+0173)
  0x8B, 0x36, 0xF0, 0x7D, 0x06, 0xF0, 0x7D, 0x06, 0xF0, 0x7D, 0x06, 0xF0, 0x8D, 0x04, 0xF4, 0xCD,
  0x28, 0x1C, 0xEA, 0x94, 0x07, 0x08, 0x48, 0x16, 0xF3, 0x40, 0x21,
  // "Ŵ" (U+0174)
  0x30, 0x50, 0x76, 0x82, 0x4B, 0x97, 0x75, 0x8D, 0x2D, 0x70, 0x8D, 0x02, 0xF3, 0xAA, 0x0B, 0xF0,
  0x5F, 0x07, 0xC0, 0xEE, 0x38, 0xD0, 0x4F, 0x2F, 0xA6, 0xBA, 0x01, 0xF7, 0xC7, 0x9D, 0x72, 0x85,
  0xEC, 0x94, 0xCF, 0x42, 0x82, 0xBF, 0x61, 0xA0, 0x12, 0x84, 0x8F, 0x30, 0xED, 0x20,
  // "ŵ" (U+0175)
  0x30, 0x50, 0x75, 0x82, 0x4B, 0x97, 0x73, 0x8B, 0x5C, 0x82, 0xF8, 0x2F, 0x29, 0xB5, 0xEB, 0x5E,
  0x06, 0xD8, 0x9E, 0x8B, 0x03, 0xFB, 0x4E, 0xB8, 0x28, 0x4E, 0xF1, 0xCF, 0x42, 0x84, 0xBE, 0x09,
  0xF1, 0x10,
  // "Ŷ" (U+0176)
  0x10, 0x50, 0x72, 0x82, 0x4B, 0x97, 0x68, 0xA1, 0xCA, 0x07, 0xE6, 0xF1, 0xD9, 0x1F, 0xAF, 0x30,
  0xAF, 0xD2, 0x81, 0x4F, 0x72, 0x81, 0x1F, 0x42, 0x81, 0x1F, 0x42, 0x81, 0x1F, 0x41,
  // "ŷ" (U+0177)
  0x10, 0x50, 0x72, 0x82, 0x4B, 0x97, 0x68, 0xA1, 0xD8, 0x0B, 0xA8, 0xC0, 0xE6, 0x4F, 0x3F, 0x20,
  0xFA, 0xD2, 0x81, 0xBE, 0x92, 0x81, 0x7F, 0x52, 0x85, 0x4F, 0x10, 0x2B, 0xB2, 0x81, 0x9D, 0x32,
  // "Ÿ" (U+0178)
  0x18, 0xB2, 0xC3, 0xE1, 0x01, 0x01, 0x0C, 0xA0, 0x7E, 0x6F, 0x1D, 0x91, 0xFA, 0xF3, 0x0A, 0xFD,
  0x28, 0x14, 0xF7, 0x28, 0x11, 0xF4, 0x28, 0x11, 0xF4, 0x28, 0x11, 0xF4, 0x10,
  // "Ź" (U+0179)
  0x18, 0x12, 0xD5, 0x20, 0x01, 0x20, 0xAB, 0x84, 0x62, 0x36, 0xF3, 0x20, 0x0B, 0x28, 0x12, 0xF4,
  0x20, 0x90, 0xC2, 0x81, 0x1F, 0x52, 0x84, 0x8E, 0x33, 0x1B, 0xB0, 0x80,
  // "ź" (U+017A)
  0x18, 0x62, 0xD5, 0x01, 0x10, 0xAA, 0x86, 0xA2, 0x3F, 0x60, 0x7E, 0x28, 0x6E, 0x70, 0x7E, 0x32,
  0xCA, 0x0B,
  // "Ż" (U+017B)
  0x10, 0x70, 0xB4, 0x01, 0x20, 0xAB, 0x84, 0x62, 0x36, 0xF3, 0x20, 0x0B, 0x28, 0x12, 0xF4, 0x20,
  0x90, 0xC2, 0x81, 0x1F, 0x52, 0x84, 0x8E, 0x33, 0x1B, 0xB0, 0x80,
  // "ż" (U+017C)
  0x10, 0x70, 0xB3, 0x81, 0x10, 0xAA, 0x86, 0xA2, 0x3F, 0x60, 0x7E, 0x28, 0x6E, 0x70, 0x7E, 0x32,
  0xCA, 0x0B,
  // "Ž" (U+017D)
  0x82, 0x34, 0x25, 0x28, 0x1D, 0xE2, 0x60, 0xAB, 0x84, 0x62, 0x36, 0xF3, 0x20, 0x0B, 0x28, 0x12,
  0xF4, 0x20, 0x90, 0xC2, 0x81, 0x1F, 0x52, 0x84, 0x8E, 0x33, 0x1B, 0xB0, 0x80,
  // "ž" (U+017E)
  0x86, 0x34, 0x25, 0x0D, 0xE2, 0x40, 0xAA, 0x86, 0xA2, 0x3F, 0x60, 0x7E, 0x28, 0x6E, 0x70, 0x7E,
  0x32, 0xCA, 0x0B,
  // "ſ" (U+017F)
  0x18, 0xB4, 0xBE, 0x43, 0xF5, 0x14, 0xF1, 0x04, 0xF1, 0x04, 0xF1, 0x04, 0xF1, 0x04, 0xF1, 0x04,
  0xF1, 0x10,
  // "Ω" (U+03A9)
  0x18, 0x94, 0x4D, 0xEA, 0x10, 0x1F, 0x94, 0xD9, 0x06, 0x92, 0x83, 0x7E, 0x07, 0xE2, 0x83, 0x5F,
  0x06, 0xE2, 0x8A, 0x36, 0xE0, 0x2F, 0x20, 0x9A, 0x02, 0xAA, 0x2E, 0x50, 0xBF, 0xD5, 0xA0, 0x40,
  // "μ" (U+03BC)
  0x8B, 0x55, 0xF0, 0x7D, 0x5F, 0x07, 0xD5, 0xF0, 0x7D, 0x5F, 0x08, 0xD5, 0xF5, 0xCD, 0x5F, 0xEA,
  0xD5, 0x93, 0x05, 0x93, 0x05, 0x93,
  // "π" (U+03C0)
  0x0B, 0xC8, 0x91, 0xE3, 0xF7, 0x7F, 0x20, 0xF5, 0x59, 0x29, 0x00, 0x59, 0x29, 0x89, 0x05, 0x5F,
  0x40, 0xF5, 0x1D, 0xB0,
  // "–" (U+2013)
  0x0A, 0xB8, 0x4A, 0x12, 0x22, 0x10,
  // "—" (U+2014)
  0x0A, 0xF9, 0x0A, 0x01, 0x80, 0x42, 0x01,
  // "€" (U+20AC)
  0x18, 0x92, 0x2C, 0xE8, 0x0B, 0xB4, 0x40, 0xF4, 0x20, 0xCA, 0x81, 0xB0, 0xCA, 0x84, 0x80, 0x2F,
  0x61, 0x28, 0x7B, 0xB3, 0x40, 0x2D, 0xF7,
  // "₿" (U+20BF)
  0x10, 0xF6, 0x10, 0x4A, 0x89, 0x3D, 0x24, 0xF4, 0xE8, 0x4F, 0x2E, 0x64, 0xA8, 0xA0, 0xE1, 0x4F,
  0x4D, 0x84, 0xF1, 0xAA, 0x4F, 0x4D, 0x84, 0xA0, 0xC0, 0x11, 0x0F, 0x61,
  // "‘" (U+2018)
  0x84, 0x2E, 0x7C, 0x89,
  // "’" (U+2019)
  0x84, 0x5E, 0x8B, 0x85,
  // "‚" (U+201A)
  0x84, 0x5E, 0x8B, 0x85,
  // "‛" (U+201B)
  0x84, 0x9A, 0x6C, 0x1C,
  // "“" (U+201C)
  0x89, 0x42, 0xE1, 0xF1, 0x7C, 0x5E, 0x08, 0x97, 0xA1,
  // "”" (U+201D)
  0x89, 0x45, 0xE4, 0xF1, 0x8B, 0x6D, 0x08, 0x57, 0x71,
  // "„" (U+201E)
  0x89, 0x45, 0xE4, 0xF1, 0x8B, 0x6D, 0x08, 0x57, 0x71,
  // "‟" (U+201F)
  0x89, 0x59, 0xB8, 0xC0, 0x6C, 0x4E, 0x01, 0xC0, 0xC1,
  // "†" (U+2020)
  0x10, 0x29, 0x30, 0x10, 0xE2, 0x89, 0x06, 0xCF, 0xD5, 0x12, 0xD2, 0x12, 0x0E, 0x30, 0x19, 0x30,
  0x29, 0x38, 0x13, 0xF1, 0x10,
  // "‡" (U+2021)
  0x18, 0x52, 0xF1, 0x01, 0x1E, 0x20, 0x70, 0xEA, 0x06, 0x29, 0x49, 0x28, 0x94, 0x7D, 0xFD, 0x61,
  0x2E, 0x21, 0x01, 0xF1, 0x10,
  // "•" (U+2022)
  0x83, 0x3E, 0xD1, 0x7A, 0x83, 0x43, 0xED, 0x10,
  // "…" (U+2026)
  0x10, 0x12, 0x89, 0x01, 0x01, 0x4E, 0x04, 0xE5, 0xE0,
  // "‰" (U+2030)
  0x84, 0x2E, 0xA0, 0x1D, 0x68, 0x49, 0x9E, 0x27, 0x86, 0x84, 0xA6, 0xC4, 0xD2, 0x68, 0xC2, 0x97,
  0xD7, 0xB8, 0xD3, 0x3D, 0x80, 0x3F, 0xDA, 0x6E, 0x7A, 0xA7, 0xE1, 0x01, 0x1E, 0x3D, 0x4B, 0xB4,
  0xD3, 0x28, 0x90, 0x79, 0x1F, 0x8A, 0xA8, 0xE1, 0x28, 0x7D, 0x30, 0x9E, 0x33, 0xE9, 0x10,
  // "‹" (U+2039)
  0x18, 0x56, 0x83, 0xF3, 0x7E, 0x28, 0x3C, 0x80, 0x23,
  // "›" (U+203A)
  0x89, 0x45, 0x90, 0x1E, 0x60, 0xBB, 0x5E, 0x11, 0x31,
  // "⁄" (U+2044)
  0x30, 0x60, 0xA3, 0x0D, 0x03, 0x20, 0x50, 0xB3, 0x0C, 0x04, 0x20, 0x30, 0xC3, 0x0A, 0x05, 0x20,
  0x20, 0xD3, 0x09, 0x07, 0x30,
  // "™" (U+2122)
  0x8B, 0x2C, 0xE9, 0xE1, 0x97, 0x1B, 0x1E, 0x5C, 0x81, 0xB1, 0xAC, 0x98, 0x0A, 0x19, 0xA4, 0x70,
  // "⅒" (U+2152)
  0x50, 0x60, 0xA5, 0x81, 0x1B, 0x92, 0x0D, 0x03, 0x58, 0x44, 0x99, 0x05, 0xB7, 0x83, 0x69, 0x0C,
  0x42, 0x81, 0x3D, 0x92, 0x89, 0x16, 0x93, 0xC1, 0xB9, 0xA5, 0xD2, 0x38, 0x7A, 0x54, 0x99, 0xC4,
  0xC3, 0x20, 0x20, 0xD2, 0x84, 0x69, 0xA5, 0xD2, 0x20, 0x90, 0x72, 0x83, 0x69, 0x3D, 0x91,
  // "ﬁ" (U+FB01)
  0x18, 0x90, 0xBF, 0xAD, 0x2F, 0x61, 0x1B, 0xA8, 0xB0, 0x8F, 0x5F, 0x56, 0xF3, 0xF2, 0x5F, 0x3F,
  0x25, 0xF3, 0xF2, 0x5F, 0x3F, 0x25, 0x90,
  // "ﬂ" (U+FB02)
  0x18, 0x90, 0xBF, 0xBF, 0x2F, 0x66, 0xFB, 0xA8, 0xB0, 0x8F, 0x5F, 0x56, 0xF3, 0xF2, 0x5F, 0x3F,
  0x25, 0xF3, 0xF2, 0x5F, 0x3F, 0x25, 0x90,
};

const Font& font_NotoSans_CondensedBold_10() {
  static SmoothFont font(font_NotoSans_CondensedBold_10_data);
  return font;
}

}  // namespace roo_display
