#include "18.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSansMono-Regular (Noto Sans Mono Regular)
// Generated on Sun Mar 06 15:49:58 CET 2022
static const uint8_t font_NotoSansMono_Regular_18_data[] PROGMEM = {
  
  // Header
  0x01, 0x01, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x5D, 0x00, 0x00,
  0xFC, 0xFC, 0x1C, 0x12, 0x0E, 0xFC, 0x05, 0x00, 0x20, 0x07, 0x0B, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x04, 0x01, 0x06, 0x0D, 0x0B, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x02, 0x09, 0x07, 0x0D, 0x0B, 0x00, 0x15, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x00, 0x26, // "#" (U+0023)
  0x00, 0x24, 0x01, 0x00, 0x09, 0x0E, 0x0B, 0x00, 0x63, // "$" (U+0024)
  0x00, 0x25, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x00, 0xA0, // "%" (U+0025)
  0x00, 0x26, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x00, 0xEA, // "&" (U+0026)
  0x00, 0x27, 0x04, 0x09, 0x06, 0x0D, 0x0B, 0x01, 0x2D, // "'" (U+0027)
  0x00, 0x28, 0x03, 0xFE, 0x07, 0x0D, 0x0B, 0x01, 0x36, // "(" (U+0028)
  0x00, 0x29, 0x03, 0xFE, 0x07, 0x0D, 0x0B, 0x01, 0x63, // ")" (U+0029)
  0x00, 0x2A, 0x01, 0x07, 0x09, 0x0E, 0x0B, 0x01, 0x90, // "*" (U+002A)
  0x00, 0x2B, 0x01, 0x03, 0x09, 0x0B, 0x0B, 0x01, 0xB1, // "+" (U+002B)
  0x00, 0x2C, 0x03, 0xFE, 0x06, 0x02, 0x0B, 0x01, 0xD1, // "," (U+002C)
  0x00, 0x2D, 0x02, 0x05, 0x08, 0x07, 0x0B, 0x01, 0xDD, // "-" (U+002D)
  0x00, 0x2E, 0x04, 0x01, 0x06, 0x03, 0x0B, 0x01, 0xE6, // "." (U+002E)
  0x00, 0x2F, 0x02, 0x01, 0x08, 0x0D, 0x0B, 0x01, 0xEC, // "/" (U+002F)
  0x00, 0x30, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x02, 0x11, // "0" (U+0030)
  0x00, 0x31, 0x02, 0x01, 0x09, 0x0D, 0x0B, 0x02, 0x50, // "1" (U+0031)
  0x00, 0x32, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x02, 0x77, // "2" (U+0032)
  0x00, 0x33, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x02, 0xA5, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x01, 0x09, 0x0D, 0x0B, 0x02, 0xD6, // "4" (U+0034)
  0x00, 0x35, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x03, 0x07, // "5" (U+0035)
  0x00, 0x36, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x03, 0x37, // "6" (U+0036)
  0x00, 0x37, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x03, 0x6E, // "7" (U+0037)
  0x00, 0x38, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x03, 0x95, // "8" (U+0038)
  0x00, 0x39, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x03, 0xD3, // "9" (U+0039)
  0x00, 0x3A, 0x04, 0x01, 0x06, 0x0A, 0x0B, 0x04, 0x0C, // ":" (U+003A)
  0x00, 0x3B, 0x03, 0xFF, 0x06, 0x0A, 0x0B, 0x04, 0x17, // ";" (U+003B)
  0x00, 0x3C, 0x01, 0x03, 0x09, 0x0B, 0x0B, 0x04, 0x2A, // "<" (U+003C)
  0x00, 0x3D, 0x01, 0x04, 0x09, 0x0A, 0x0B, 0x04, 0x49, // "=" (U+003D)
  0x00, 0x3E, 0x01, 0x03, 0x09, 0x0B, 0x0B, 0x04, 0x5D, // ">" (U+003E)
  0x00, 0x3F, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x04, 0x7C, // "?" (U+003F)
  0x00, 0x40, 0x00, 0xFF, 0x0A, 0x0D, 0x0B, 0x04, 0xA6, // "@" (U+0040)
  0x00, 0x41, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x04, 0xF6, // "A" (U+0041)
  0x00, 0x42, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x05, 0x2F, // "B" (U+0042)
  0x00, 0x43, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x05, 0x6A, // "C" (U+0043)
  0x00, 0x44, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x05, 0x95, // "D" (U+0044)
  0x00, 0x45, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x05, 0xCC, // "E" (U+0045)
  0x00, 0x46, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x05, 0xFA, // "F" (U+0046)
  0x00, 0x47, 0x00, 0x01, 0x09, 0x0D, 0x0B, 0x06, 0x26, // "G" (U+0047)
  0x00, 0x48, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x06, 0x60, // "H" (U+0048)
  0x00, 0x49, 0x02, 0x01, 0x08, 0x0D, 0x0B, 0x06, 0x96, // "I" (U+0049)
  0x00, 0x4A, 0x01, 0x01, 0x08, 0x0D, 0x0B, 0x06, 0xBD, // "J" (U+004A)
  0x00, 0x4B, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x06, 0xE6, // "K" (U+004B)
  0x00, 0x4C, 0x02, 0x01, 0x09, 0x0D, 0x0B, 0x07, 0x23, // "L" (U+004C)
  0x00, 0x4D, 0x00, 0x01, 0x09, 0x0D, 0x0B, 0x07, 0x46, // "M" (U+004D)
  0x00, 0x4E, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x07, 0x86, // "N" (U+004E)
  0x00, 0x4F, 0x00, 0x01, 0x09, 0x0D, 0x0B, 0x07, 0xC3, // "O" (U+004F)
  0x00, 0x50, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x07, 0xFF, // "P" (U+0050)
  0x00, 0x51, 0x00, 0xFE, 0x09, 0x0D, 0x0B, 0x08, 0x32, // "Q" (U+0051)
  0x00, 0x52, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x08, 0x77, // "R" (U+0052)
  0x00, 0x53, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x08, 0xB5, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x09, 0x0D, 0x0B, 0x08, 0xE6, // "T" (U+0054)
  0x00, 0x55, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x09, 0x10, // "U" (U+0055)
  0x00, 0x56, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x09, 0x47, // "V" (U+0056)
  0x00, 0x57, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x09, 0x83, // "W" (U+0057)
  0x00, 0x58, 0x00, 0x01, 0x09, 0x0D, 0x0B, 0x09, 0xCC, // "X" (U+0058)
  0x00, 0x59, 0x00, 0x01, 0x09, 0x0D, 0x0B, 0x0A, 0x06, // "Y" (U+0059)
  0x00, 0x5A, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x0A, 0x39, // "Z" (U+005A)
  0x00, 0x5B, 0x04, 0xFD, 0x08, 0x0D, 0x0B, 0x0A, 0x62, // "[" (U+005B)
  0x00, 0x5C, 0x02, 0x01, 0x08, 0x0D, 0x0B, 0x0A, 0x8D, // "\" (U+005C)
  0x00, 0x5D, 0x02, 0xFE, 0x06, 0x0E, 0x0B, 0x0A, 0xB1, // "]" (U+005D)
  0x00, 0x5E, 0x01, 0x06, 0x09, 0x0E, 0x0B, 0x0A, 0xDC, // "^" (U+005E)
  0x00, 0x5F, 0x00, 0xFE, 0x0A, 0x00, 0x0B, 0x0B, 0x00, // "_" (U+005F)
  0x00, 0x60, 0x03, 0x0C, 0x06, 0x0E, 0x0B, 0x0B, 0x07, // "`" (U+0060)
  0x00, 0x61, 0x01, 0x01, 0x09, 0x0A, 0x0B, 0x0B, 0x0F, // "a" (U+0061)
  0x00, 0x62, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x0B, 0x39, // "b" (U+0062)
  0x00, 0x63, 0x01, 0x01, 0x08, 0x0A, 0x0B, 0x0B, 0x6D, // "c" (U+0063)
  0x00, 0x64, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x0B, 0x90, // "d" (U+0064)
  0x00, 0x65, 0x01, 0x01, 0x09, 0x0A, 0x0B, 0x0B, 0xC8, // "e" (U+0065)
  0x00, 0x66, 0x01, 0x01, 0x0A, 0x0E, 0x0B, 0x0B, 0xF2, // "f" (U+0066)
  0x00, 0x67, 0x01, 0xFD, 0x09, 0x0A, 0x0B, 0x0C, 0x23, // "g" (U+0067)
  0x00, 0x68, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x0C, 0x5F, // "h" (U+0068)
  0x00, 0x69, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x0C, 0x9A, // "i" (U+0069)
  0x00, 0x6A, 0x01, 0xFD, 0x07, 0x0E, 0x0B, 0x0C, 0xC4, // "j" (U+006A)
  0x00, 0x6B, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x0C, 0xF8, // "k" (U+006B)
  0x00, 0x6C, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x0D, 0x36, // "l" (U+006C)
  0x00, 0x6D, 0x00, 0x01, 0x09, 0x0A, 0x0B, 0x0D, 0x5A, // "m" (U+006D)
  0x00, 0x6E, 0x01, 0x01, 0x09, 0x0A, 0x0B, 0x0D, 0x8E, // "n" (U+006E)
  0x00, 0x6F, 0x01, 0x01, 0x09, 0x0A, 0x0B, 0x0D, 0xBD, // "o" (U+006F)
  0x00, 0x70, 0x01, 0xFD, 0x09, 0x0A, 0x0B, 0x0D, 0xE9, // "p" (U+0070)
  0x00, 0x71, 0x01, 0xFD, 0x09, 0x0A, 0x0B, 0x0E, 0x1E, // "q" (U+0071)
  0x00, 0x72, 0x01, 0x01, 0x0A, 0x0A, 0x0B, 0x0E, 0x57, // "r" (U+0072)
  0x00, 0x73, 0x01, 0x01, 0x08, 0x0A, 0x0B, 0x0E, 0x7B, // "s" (U+0073)
  0x00, 0x74, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x0E, 0x9F, // "t" (U+0074)
  0x00, 0x75, 0x01, 0x01, 0x09, 0x0A, 0x0B, 0x0E, 0xCB, // "u" (U+0075)
  0x00, 0x76, 0x01, 0x01, 0x09, 0x0A, 0x0B, 0x0E, 0xF6, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x01, 0x0A, 0x0A, 0x0B, 0x0F, 0x20, // "w" (U+0077)
  0x00, 0x78, 0x01, 0x01, 0x09, 0x0A, 0x0B, 0x0F, 0x58, // "x" (U+0078)
  0x00, 0x79, 0x01, 0xFD, 0x09, 0x0A, 0x0B, 0x0F, 0x85, // "y" (U+0079)
  0x00, 0x7A, 0x01, 0x01, 0x09, 0x0A, 0x0B, 0x0F, 0xBB, // "z" (U+007A)
  0x00, 0x7B, 0x02, 0xFD, 0x08, 0x0D, 0x0B, 0x0F, 0xDB, // "{" (U+007B)
  0x00, 0x7C, 0x04, 0xFD, 0x06, 0x0E, 0x0B, 0x10, 0x10, // "|" (U+007C)
  0x00, 0x7D, 0x02, 0xFE, 0x08, 0x0E, 0x0B, 0x10, 0x2D, // "}" (U+007D)
  0x00, 0x7E, 0x01, 0x05, 0x09, 0x08, 0x0B, 0x10, 0x62, // "~" (U+007E)
  0x00, 0xA1, 0x04, 0xFE, 0x06, 0x0A, 0x0B, 0x10, 0x76, // "¡" (U+00A1)
  0x00, 0xA2, 0x01, 0x01, 0x08, 0x0D, 0x0B, 0x10, 0x8B, // "¢" (U+00A2)
  0x00, 0xA3, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x10, 0xB4, // "£" (U+00A3)
  0x00, 0xA4, 0x01, 0x03, 0x09, 0x0B, 0x0B, 0x10, 0xE0, // "¤" (U+00A4)
  0x00, 0xA5, 0x00, 0x01, 0x09, 0x0D, 0x0B, 0x11, 0x0B, // "¥" (U+00A5)
  0x00, 0xA6, 0x04, 0xFD, 0x05, 0x0E, 0x0B, 0x11, 0x41, // "¦" (U+00A6)
  0x00, 0xA7, 0x02, 0x01, 0x08, 0x0E, 0x0B, 0x11, 0x53, // "§" (U+00A7)
  0x00, 0xA8, 0x02, 0x0C, 0x08, 0x0D, 0x0B, 0x11, 0x83, // "¨" (U+00A8)
  0x00, 0xA9, 0x00, 0x02, 0x09, 0x0B, 0x0B, 0x11, 0x8C, // "©" (U+00A9)
  0x00, 0xAA, 0x02, 0x08, 0x07, 0x0D, 0x0B, 0x11, 0xBF, // "ª" (U+00AA)
  0x00, 0xAB, 0x01, 0x02, 0x08, 0x09, 0x0B, 0x11, 0xD3, // "«" (U+00AB)
  0x00, 0xAC, 0x01, 0x03, 0x09, 0x08, 0x0B, 0x11, 0xF4, // "¬" (U+00AC)
  0x00, 0xAE, 0x00, 0x02, 0x09, 0x0B, 0x0B, 0x12, 0x06, // "®" (U+00AE)
  0x00, 0xAF, 0x02, 0x0C, 0x08, 0x0E, 0x0B, 0x12, 0x3B, // "¯" (U+00AF)
  0x00, 0xB0, 0x02, 0x08, 0x08, 0x0D, 0x0B, 0x12, 0x44, // "°" (U+00B0)
  0x00, 0xB1, 0x01, 0x01, 0x09, 0x0B, 0x0B, 0x12, 0x5A, // "±" (U+00B1)
  0x00, 0xB2, 0x02, 0x08, 0x08, 0x10, 0x0B, 0x12, 0x79, // "²" (U+00B2)
  0x00, 0xB3, 0x02, 0x07, 0x07, 0x0F, 0x0B, 0x12, 0x97, // "³" (U+00B3)
  0x00, 0xB4, 0x04, 0x0C, 0x07, 0x0E, 0x0B, 0x12, 0xB3, // "´" (U+00B4)
  0x00, 0xB5, 0x01, 0xFD, 0x09, 0x0A, 0x0B, 0x12, 0xBB, // "µ" (U+00B5)
  0x00, 0xB6, 0x00, 0xFE, 0x09, 0x0E, 0x0B, 0x12, 0xED, // "¶" (U+00B6)
  0x00, 0xB7, 0x04, 0x06, 0x06, 0x08, 0x0B, 0x13, 0x36, // "·" (U+00B7)
  0x00, 0xB8, 0x03, 0xFD, 0x07, 0x01, 0x0B, 0x13, 0x3C, // "¸" (U+00B8)
  0x00, 0xB9, 0x02, 0x08, 0x08, 0x0F, 0x0B, 0x13, 0x49, // "¹" (U+00B9)
  0x00, 0xBA, 0x02, 0x08, 0x07, 0x0D, 0x0B, 0x13, 0x61, // "º" (U+00BA)
  0x00, 0xBB, 0x02, 0x02, 0x09, 0x09, 0x0B, 0x13, 0x76, // "»" (U+00BB)
  0x00, 0xBC, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x13, 0x97, // "¼" (U+00BC)
  0x00, 0xBD, 0x00, 0x00, 0x0A, 0x0D, 0x0B, 0x13, 0xDA, // "½" (U+00BD)
  0x00, 0xBE, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x14, 0x22, // "¾" (U+00BE)
  0x00, 0xBF, 0x00, 0xFE, 0x08, 0x0A, 0x0B, 0x14, 0x6B, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x0A, 0x11, 0x0B, 0x14, 0x95, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x0A, 0x11, 0x0B, 0x14, 0xD9, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x01, 0x0A, 0x11, 0x0B, 0x15, 0x1D, // "Â" (U+00C2)
  0x00, 0xC3, 0x00, 0x01, 0x0A, 0x10, 0x0B, 0x15, 0x63, // "Ã" (U+00C3)
  0x00, 0xC4, 0x00, 0x01, 0x0A, 0x10, 0x0B, 0x15, 0xAA, // "Ä" (U+00C4)
  0x00, 0xC5, 0x00, 0x01, 0x0A, 0x12, 0x0B, 0x15, 0xEE, // "Å" (U+00C5)
  0x00, 0xC6, 0x00, 0x01, 0x09, 0x0D, 0x0B, 0x16, 0x3A, // "Æ" (U+00C6)
  0x00, 0xC7, 0x01, 0xFD, 0x09, 0x0D, 0x0B, 0x16, 0x75, // "Ç" (U+00C7)
  0x00, 0xC8, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x16, 0xAD, // "È" (U+00C8)
  0x00, 0xC9, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x16, 0xE4, // "É" (U+00C9)
  0x00, 0xCA, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x17, 0x1C, // "Ê" (U+00CA)
  0x00, 0xCB, 0x01, 0x01, 0x09, 0x10, 0x0B, 0x17, 0x57, // "Ë" (U+00CB)
  0x00, 0xCC, 0x02, 0x01, 0x08, 0x11, 0x0B, 0x17, 0x90, // "Ì" (U+00CC)
  0x00, 0xCD, 0x02, 0x01, 0x08, 0x11, 0x0B, 0x17, 0xC0, // "Í" (U+00CD)
  0x00, 0xCE, 0x02, 0x01, 0x08, 0x11, 0x0B, 0x17, 0xF1, // "Î" (U+00CE)
  0x00, 0xCF, 0x02, 0x01, 0x08, 0x10, 0x0B, 0x18, 0x24, // "Ï" (U+00CF)
  0x00, 0xD0, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x18, 0x54, // "Ð" (U+00D0)
  0x00, 0xD1, 0x01, 0x01, 0x09, 0x10, 0x0B, 0x18, 0x9B, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x00, 0x01, 0x09, 0x11, 0x0B, 0x18, 0xE7, // "Ò" (U+00D2)
  0x00, 0xD3, 0x00, 0x01, 0x09, 0x11, 0x0B, 0x19, 0x2D, // "Ó" (U+00D3)
  0x00, 0xD4, 0x00, 0x01, 0x09, 0x11, 0x0B, 0x19, 0x73, // "Ô" (U+00D4)
  0x00, 0xD5, 0x00, 0x01, 0x09, 0x10, 0x0B, 0x19, 0xBB, // "Õ" (U+00D5)
  0x00, 0xD6, 0x00, 0x01, 0x09, 0x10, 0x0B, 0x1A, 0x05, // "Ö" (U+00D6)
  0x00, 0xD7, 0x01, 0x03, 0x09, 0x0A, 0x0B, 0x1A, 0x4B, // "×" (U+00D7)
  0x00, 0xD8, 0x00, 0x00, 0x09, 0x0E, 0x0B, 0x1A, 0x6E, // "Ø" (U+00D8)
  0x00, 0xD9, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x1A, 0xB9, // "Ù" (U+00D9)
  0x00, 0xDA, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x1A, 0xFA, // "Ú" (U+00DA)
  0x00, 0xDB, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x1B, 0x3B, // "Û" (U+00DB)
  0x00, 0xDC, 0x01, 0x01, 0x09, 0x10, 0x0B, 0x1B, 0x7F, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x01, 0x09, 0x11, 0x0B, 0x1B, 0xC1, // "Ý" (U+00DD)
  0x00, 0xDE, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x1B, 0xFE, // "Þ" (U+00DE)
  0x00, 0xDF, 0x01, 0x01, 0x0A, 0x0E, 0x0B, 0x1C, 0x31, // "ß" (U+00DF)
  0x00, 0xE0, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x1C, 0x79, // "à" (U+00E0)
  0x00, 0xE1, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x1C, 0xAC, // "á" (U+00E1)
  0x00, 0xE2, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x1C, 0xDF, // "â" (U+00E2)
  0x00, 0xE3, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x1D, 0x15, // "ã" (U+00E3)
  0x00, 0xE4, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x1D, 0x4D, // "ä" (U+00E4)
  0x00, 0xE5, 0x01, 0x01, 0x09, 0x0F, 0x0B, 0x1D, 0x81, // "å" (U+00E5)
  0x00, 0xE6, 0x00, 0x01, 0x0A, 0x0A, 0x0B, 0x1D, 0xBC, // "æ" (U+00E6)
  0x00, 0xE7, 0x01, 0xFD, 0x08, 0x0A, 0x0B, 0x1D, 0xF3, // "ç" (U+00E7)
  0x00, 0xE8, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x1E, 0x23, // "è" (U+00E8)
  0x00, 0xE9, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x1E, 0x56, // "é" (U+00E9)
  0x00, 0xEA, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x1E, 0x89, // "ê" (U+00EA)
  0x00, 0xEB, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x1E, 0xBF, // "ë" (U+00EB)
  0x00, 0xEC, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x1E, 0xF3, // "ì" (U+00EC)
  0x00, 0xED, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x1F, 0x1E, // "í" (U+00ED)
  0x00, 0xEE, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x1F, 0x49, // "î" (U+00EE)
  0x00, 0xEF, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x1F, 0x77, // "ï" (U+00EF)
  0x00, 0xF0, 0x01, 0x01, 0x09, 0x0F, 0x0B, 0x1F, 0xA3, // "ð" (U+00F0)
  0x00, 0xF1, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x1F, 0xE1, // "ñ" (U+00F1)
  0x00, 0xF2, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x20, 0x1D, // "ò" (U+00F2)
  0x00, 0xF3, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x20, 0x52, // "ó" (U+00F3)
  0x00, 0xF4, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x20, 0x87, // "ô" (U+00F4)
  0x00, 0xF5, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x20, 0xBF, // "õ" (U+00F5)
  0x00, 0xF6, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x20, 0xF9, // "ö" (U+00F6)
  0x00, 0xF7, 0x01, 0x03, 0x09, 0x0B, 0x0B, 0x21, 0x2F, // "÷" (U+00F7)
  0x00, 0xF8, 0x01, 0x00, 0x09, 0x0B, 0x0B, 0x21, 0x48, // "ø" (U+00F8)
  0x00, 0xF9, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x21, 0x7E, // "ù" (U+00F9)
  0x00, 0xFA, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x21, 0xB2, // "ú" (U+00FA)
  0x00, 0xFB, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x21, 0xE7, // "û" (U+00FB)
  0x00, 0xFC, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x22, 0x1F, // "ü" (U+00FC)
  0x00, 0xFD, 0x01, 0xFD, 0x09, 0x0E, 0x0B, 0x22, 0x55, // "ý" (U+00FD)
  0x00, 0xFE, 0x01, 0xFD, 0x09, 0x0E, 0x0B, 0x22, 0x95, // "þ" (U+00FE)
  0x00, 0xFF, 0x01, 0xFD, 0x09, 0x0D, 0x0B, 0x22, 0xD2, // "ÿ" (U+00FF)
  0x01, 0x00, 0x00, 0x01, 0x0A, 0x11, 0x0B, 0x23, 0x13, // "Ā" (U+0100)
  0x01, 0x01, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x23, 0x56, // "ā" (U+0101)
  0x01, 0x02, 0x00, 0x01, 0x0A, 0x11, 0x0B, 0x23, 0x89, // "Ă" (U+0102)
  0x01, 0x03, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x23, 0xD1, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0xFC, 0x0A, 0x0D, 0x0B, 0x24, 0x09, // "Ą" (U+0104)
  0x01, 0x05, 0x01, 0xFC, 0x09, 0x0A, 0x0B, 0x24, 0x53, // "ą" (U+0105)
  0x01, 0x06, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x24, 0x8B, // "Ć" (U+0106)
  0x01, 0x07, 0x01, 0x01, 0x08, 0x0E, 0x0B, 0x24, 0xC0, // "ć" (U+0107)
  0x01, 0x08, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x24, 0xED, // "Ĉ" (U+0108)
  0x01, 0x09, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x25, 0x25, // "ĉ" (U+0109)
  0x01, 0x0A, 0x01, 0x01, 0x09, 0x12, 0x0B, 0x25, 0x57, // "Ċ" (U+010A)
  0x01, 0x0B, 0x01, 0x01, 0x08, 0x0F, 0x0B, 0x25, 0x8B, // "ċ" (U+010B)
  0x01, 0x0C, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x25, 0xB7, // "Č" (U+010C)
  0x01, 0x0D, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x25, 0xEF, // "č" (U+010D)
  0x01, 0x0E, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x26, 0x21, // "Ď" (U+010E)
  0x01, 0x0F, 0x00, 0x01, 0x0B, 0x0E, 0x0B, 0x26, 0x65, // "ď" (U+010F)
  0x01, 0x10, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x26, 0xAA, // "Đ" (U+0110)
  0x01, 0x11, 0x01, 0x01, 0x0A, 0x0E, 0x0B, 0x26, 0xF1, // "đ" (U+0111)
  0x01, 0x12, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x27, 0x32, // "Ē" (U+0112)
  0x01, 0x13, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x27, 0x6A, // "ē" (U+0113)
  0x01, 0x14, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x27, 0x9D, // "Ĕ" (U+0114)
  0x01, 0x15, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x27, 0xDA, // "ĕ" (U+0115)
  0x01, 0x16, 0x01, 0x01, 0x09, 0x12, 0x0B, 0x28, 0x12, // "Ė" (U+0116)
  0x01, 0x17, 0x01, 0x01, 0x09, 0x0F, 0x0B, 0x28, 0x49, // "ė" (U+0117)
  0x01, 0x18, 0x01, 0xFC, 0x09, 0x0D, 0x0B, 0x28, 0x7C, // "Ę" (U+0118)
  0x01, 0x19, 0x01, 0xFD, 0x09, 0x0A, 0x0B, 0x28, 0xB8, // "ę" (U+0119)
  0x01, 0x1A, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x28, 0xEE, // "Ě" (U+011A)
  0x01, 0x1B, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x29, 0x29, // "ě" (U+011B)
  0x01, 0x1C, 0x00, 0x01, 0x09, 0x11, 0x0B, 0x29, 0x5F, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x01, 0xFD, 0x09, 0x0E, 0x0B, 0x29, 0xA6, // "ĝ" (U+011D)
  0x01, 0x1E, 0x00, 0x01, 0x09, 0x11, 0x0B, 0x29, 0xEF, // "Ğ" (U+011E)
  0x01, 0x1F, 0x01, 0xFD, 0x09, 0x0E, 0x0B, 0x2A, 0x38, // "ğ" (U+011F)
  0x01, 0x20, 0x00, 0x01, 0x09, 0x12, 0x0B, 0x2A, 0x83, // "Ġ" (U+0120)
  0x01, 0x21, 0x01, 0xFD, 0x09, 0x0F, 0x0B, 0x2A, 0xC7, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0xFD, 0x09, 0x0D, 0x0B, 0x2B, 0x0C, // "Ģ" (U+0122)
  0x01, 0x23, 0x01, 0xFD, 0x09, 0x0E, 0x0B, 0x2B, 0x50, // "ģ" (U+0123)
  0x01, 0x24, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x2B, 0x95, // "Ĥ" (U+0124)
  0x01, 0x25, 0xFF, 0x01, 0x09, 0x12, 0x0B, 0x2B, 0xD8, // "ĥ" (U+0125)
  0x01, 0x26, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x2C, 0x2E, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x09, 0x0E, 0x0B, 0x2C, 0x72, // "ħ" (U+0127)
  0x01, 0x28, 0x02, 0x01, 0x08, 0x10, 0x0B, 0x2C, 0xB4, // "Ĩ" (U+0128)
  0x01, 0x29, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x2C, 0xE7, // "ĩ" (U+0129)
  0x01, 0x2A, 0x02, 0x01, 0x08, 0x11, 0x0B, 0x2D, 0x17, // "Ī" (U+012A)
  0x01, 0x2B, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x2D, 0x47, // "ī" (U+012B)
  0x01, 0x2C, 0x02, 0x01, 0x08, 0x11, 0x0B, 0x2D, 0x72, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x2D, 0xA7, // "ĭ" (U+012D)
  0x01, 0x2E, 0x02, 0xFC, 0x08, 0x0D, 0x0B, 0x2D, 0xD7, // "Į" (U+012E)
  0x01, 0x2F, 0x01, 0xFC, 0x09, 0x0E, 0x0B, 0x2E, 0x0D, // "į" (U+012F)
  0x01, 0x30, 0x02, 0x01, 0x08, 0x12, 0x0B, 0x2E, 0x45, // "İ" (U+0130)
  0x01, 0x31, 0x01, 0x01, 0x09, 0x0A, 0x0B, 0x2E, 0x75, // "ı" (U+0131)
  0x01, 0x32, 0x01, 0x01, 0x08, 0x0D, 0x0B, 0x2E, 0x96, // "Ĳ" (U+0132)
  0x01, 0x33, 0x01, 0xFD, 0x08, 0x0E, 0x0B, 0x2E, 0xC9, // "ĳ" (U+0133)
  0x01, 0x34, 0x01, 0x01, 0x0B, 0x11, 0x0B, 0x2F, 0x0D, // "Ĵ" (U+0134)
  0x01, 0x35, 0x01, 0xFD, 0x09, 0x0E, 0x0B, 0x2F, 0x4A, // "ĵ" (U+0135)
  0x01, 0x36, 0x01, 0xFD, 0x09, 0x0D, 0x0B, 0x2F, 0x84, // "Ķ" (U+0136)
  0x01, 0x37, 0x01, 0xFD, 0x09, 0x0E, 0x0B, 0x2F, 0xCA, // "ķ" (U+0137)
  0x01, 0x38, 0x01, 0x01, 0x09, 0x0A, 0x0B, 0x30, 0x11, // "ĸ" (U+0138)
  0x01, 0x39, 0x02, 0x01, 0x09, 0x11, 0x0B, 0x30, 0x43, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x01, 0x01, 0x09, 0x12, 0x0B, 0x30, 0x70, // "ĺ" (U+013A)
  0x01, 0x3B, 0x02, 0xFD, 0x09, 0x0D, 0x0B, 0x30, 0x9E, // "Ļ" (U+013B)
  0x01, 0x3C, 0x01, 0xFD, 0x09, 0x0E, 0x0B, 0x30, 0xCA, // "ļ" (U+013C)
  0x01, 0x3D, 0x02, 0x01, 0x09, 0x0D, 0x0B, 0x30, 0xF7, // "Ľ" (U+013D)
  0x01, 0x3E, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x31, 0x1F, // "ľ" (U+013E)
  0x01, 0x3F, 0x02, 0x01, 0x09, 0x0D, 0x0B, 0x31, 0x47, // "Ŀ" (U+013F)
  0x01, 0x40, 0x01, 0x01, 0x0B, 0x0E, 0x0B, 0x31, 0x6E, // "ŀ" (U+0140)
  0x01, 0x41, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x31, 0x9E, // "Ł" (U+0141)
  0x01, 0x42, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x31, 0xCB, // "ł" (U+0142)
  0x01, 0x43, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x31, 0xF7, // "Ń" (U+0143)
  0x01, 0x44, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x32, 0x3E, // "ń" (U+0144)
  0x01, 0x45, 0x01, 0xFD, 0x09, 0x0D, 0x0B, 0x32, 0x77, // "Ņ" (U+0145)
  0x01, 0x46, 0x01, 0xFD, 0x09, 0x0A, 0x0B, 0x32, 0xBD, // "ņ" (U+0146)
  0x01, 0x47, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x32, 0xF5, // "Ň" (U+0147)
  0x01, 0x48, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x33, 0x3F, // "ň" (U+0148)
  0x01, 0x49, 0xFF, 0x01, 0x09, 0x0D, 0x0B, 0x33, 0x7B, // "ŉ" (U+0149)
  0x01, 0x4A, 0x01, 0xFD, 0x09, 0x0D, 0x0B, 0x33, 0xC2, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x01, 0xFD, 0x09, 0x0A, 0x0B, 0x34, 0x0C, // "ŋ" (U+014B)
  0x01, 0x4C, 0x00, 0x01, 0x09, 0x11, 0x0B, 0x34, 0x49, // "Ō" (U+014C)
  0x01, 0x4D, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x34, 0x8E, // "ō" (U+014D)
  0x01, 0x4E, 0x00, 0x01, 0x09, 0x11, 0x0B, 0x34, 0xC3, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x35, 0x0D, // "ŏ" (U+014F)
  0x01, 0x50, 0x00, 0x01, 0x09, 0x11, 0x0B, 0x35, 0x47, // "Ő" (U+0150)
  0x01, 0x51, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x35, 0x91, // "ő" (U+0151)
  0x01, 0x52, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x35, 0xCB, // "Œ" (U+0152)
  0x01, 0x53, 0x00, 0x01, 0x0A, 0x0A, 0x0B, 0x36, 0x13, // "œ" (U+0153)
  0x01, 0x54, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x36, 0x4A, // "Ŕ" (U+0154)
  0x01, 0x55, 0x01, 0x01, 0x0A, 0x0E, 0x0B, 0x36, 0x92, // "ŕ" (U+0155)
  0x01, 0x56, 0x01, 0xFD, 0x09, 0x0D, 0x0B, 0x36, 0xC0, // "Ŗ" (U+0156)
  0x01, 0x57, 0x01, 0xFD, 0x0A, 0x0A, 0x0B, 0x37, 0x07, // "ŗ" (U+0157)
  0x01, 0x58, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x37, 0x34, // "Ř" (U+0158)
  0x01, 0x59, 0x01, 0x01, 0x0A, 0x0E, 0x0B, 0x37, 0x7F, // "ř" (U+0159)
  0x01, 0x5A, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x37, 0xB0, // "Ś" (U+015A)
  0x01, 0x5B, 0x01, 0x01, 0x08, 0x0E, 0x0B, 0x37, 0xEA, // "ś" (U+015B)
  0x01, 0x5C, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x38, 0x17, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x01, 0x01, 0x08, 0x0E, 0x0B, 0x38, 0x54, // "ŝ" (U+015D)
  0x01, 0x5E, 0x01, 0xFD, 0x09, 0x0D, 0x0B, 0x38, 0x84, // "Ş" (U+015E)
  0x01, 0x5F, 0x01, 0xFD, 0x08, 0x0A, 0x0B, 0x38, 0xC1, // "ş" (U+015F)
  0x01, 0x60, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x38, 0xF1, // "Š" (U+0160)
  0x01, 0x61, 0x01, 0x01, 0x08, 0x0E, 0x0B, 0x39, 0x2E, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFD, 0x09, 0x0D, 0x0B, 0x39, 0x5E, // "Ţ" (U+0162)
  0x01, 0x63, 0x01, 0xFD, 0x09, 0x0D, 0x0B, 0x39, 0x95, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x09, 0x11, 0x0B, 0x39, 0xCE, // "Ť" (U+0164)
  0x01, 0x65, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x3A, 0x05, // "ť" (U+0165)
  0x01, 0x66, 0x00, 0x01, 0x09, 0x0D, 0x0B, 0x3A, 0x37, // "Ŧ" (U+0166)
  0x01, 0x67, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x3A, 0x65, // "ŧ" (U+0167)
  0x01, 0x68, 0x01, 0x01, 0x09, 0x10, 0x0B, 0x3A, 0x96, // "Ũ" (U+0168)
  0x01, 0x69, 0x01, 0x01, 0x09, 0x0D, 0x0B, 0x3A, 0xDC, // "ũ" (U+0169)
  0x01, 0x6A, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x3B, 0x15, // "Ū" (U+016A)
  0x01, 0x6B, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x3B, 0x56, // "ū" (U+016B)
  0x01, 0x6C, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x3B, 0x8B, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x3B, 0xD1, // "ŭ" (U+016D)
  0x01, 0x6E, 0x01, 0x01, 0x09, 0x12, 0x0B, 0x3C, 0x0B, // "Ů" (U+016E)
  0x01, 0x6F, 0x01, 0x01, 0x09, 0x0F, 0x0B, 0x3C, 0x54, // "ů" (U+016F)
  0x01, 0x70, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x3C, 0x91, // "Ű" (U+0170)
  0x01, 0x71, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x3C, 0xD7, // "ű" (U+0171)
  0x01, 0x72, 0x01, 0xFD, 0x09, 0x0D, 0x0B, 0x3D, 0x10, // "Ų" (U+0172)
  0x01, 0x73, 0x01, 0xFC, 0x09, 0x0A, 0x0B, 0x3D, 0x53, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x0A, 0x11, 0x0B, 0x3D, 0x8C, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x3D, 0xE2, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x01, 0x09, 0x11, 0x0B, 0x3E, 0x27, // "Ŷ" (U+0176)
  0x01, 0x77, 0x01, 0xFD, 0x09, 0x0E, 0x0B, 0x3E, 0x67, // "ŷ" (U+0177)
  0x01, 0x78, 0x00, 0x01, 0x09, 0x10, 0x0B, 0x3E, 0xAA, // "Ÿ" (U+0178)
  0x01, 0x79, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x3E, 0xE8, // "Ź" (U+0179)
  0x01, 0x7A, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x3F, 0x1B, // "ź" (U+017A)
  0x01, 0x7B, 0x01, 0x01, 0x09, 0x12, 0x0B, 0x3F, 0x45, // "Ż" (U+017B)
  0x01, 0x7C, 0x01, 0x01, 0x09, 0x0F, 0x0B, 0x3F, 0x77, // "ż" (U+017C)
  0x01, 0x7D, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x3F, 0xA0, // "Ž" (U+017D)
  0x01, 0x7E, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x3F, 0xD6, // "ž" (U+017E)
  0x01, 0x7F, 0x04, 0x01, 0x09, 0x0E, 0x0B, 0x40, 0x03, // "ſ" (U+017F)
  0x03, 0xA9, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x40, 0x22, // "Ω" (U+03A9)
  0x03, 0xBC, 0x01, 0xFD, 0x09, 0x0A, 0x0B, 0x40, 0x66, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x01, 0x0A, 0x0A, 0x0B, 0x40, 0x98, // "π" (U+03C0)
  0x20, 0x13, 0x01, 0x05, 0x08, 0x07, 0x0B, 0x40, 0xCC, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x05, 0x0A, 0x07, 0x0B, 0x40, 0xD3, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x40, 0xDA, // "€" (U+20AC)
  0x20, 0xBF, 0x01, 0xFF, 0x09, 0x0F, 0x0B, 0x41, 0x0F, // "₿" (U+20BF)
  0x20, 0x18, 0x04, 0x0A, 0x06, 0x0D, 0x0B, 0x41, 0x57, // "‘" (U+2018)
  0x20, 0x19, 0x03, 0x0A, 0x06, 0x0D, 0x0B, 0x41, 0x5F, // "’" (U+2019)
  0x20, 0x1A, 0x03, 0xFE, 0x06, 0x02, 0x0B, 0x41, 0x69, // "‚" (U+201A)
  0x20, 0x1B, 0x04, 0x0A, 0x06, 0x0D, 0x0B, 0x41, 0x75, // "‛" (U+201B)
  0x20, 0x1C, 0x02, 0x0A, 0x08, 0x0D, 0x0B, 0x41, 0x7D, // "“" (U+201C)
  0x20, 0x1D, 0x02, 0x09, 0x08, 0x0C, 0x0B, 0x41, 0x8E, // "”" (U+201D)
  0x20, 0x1E, 0x02, 0xFE, 0x08, 0x02, 0x0B, 0x41, 0x9F, // "„" (U+201E)
  0x20, 0x1F, 0x02, 0x09, 0x08, 0x0C, 0x0B, 0x41, 0xB2, // "‟" (U+201F)
  0x20, 0x20, 0x01, 0x01, 0x08, 0x0E, 0x0B, 0x41, 0xC3, // "†" (U+2020)
  0x20, 0x21, 0x01, 0x01, 0x08, 0x0E, 0x0B, 0x41, 0xEE, // "‡" (U+2021)
  0x20, 0x22, 0x03, 0x05, 0x07, 0x09, 0x0B, 0x42, 0x1E, // "•" (U+2022)
  0x20, 0x26, 0x00, 0x01, 0x0A, 0x03, 0x0B, 0x42, 0x2C, // "…" (U+2026)
  0x20, 0x30, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x42, 0x3D, // "‰" (U+2030)
  0x20, 0x39, 0x03, 0x02, 0x07, 0x09, 0x0B, 0x42, 0x7E, // "‹" (U+2039)
  0x20, 0x3A, 0x03, 0x02, 0x07, 0x09, 0x0B, 0x42, 0x93, // "›" (U+203A)
  0x20, 0x44, 0xFC, 0x01, 0x03, 0x0D, 0x00, 0x42, 0xA8, // "⁄" (U+2044)
  0x21, 0x22, 0xFF, 0x07, 0x0A, 0x0D, 0x0B, 0x42, 0xCB, // "™" (U+2122)
  0x21, 0x52, 0x04, 0x00, 0x1C, 0x0D, 0x20, 0x42, 0xFB, // "⅒" (U+2152)
  0x22, 0x02, 0x00, 0x00, 0x09, 0x0D, 0x0B, 0x43, 0x76, // "∂" (U+2202)
  0x22, 0x06, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x43, 0xB5, // "∆" (U+2206)
  0x22, 0x1A, 0x00, 0x01, 0x0A, 0x10, 0x0B, 0x43, 0xF1, // "√" (U+221A)
  0x22, 0x1E, 0x00, 0x04, 0x0A, 0x09, 0x0B, 0x44, 0x2D, // "∞" (U+221E)
  0x22, 0x48, 0x01, 0x04, 0x09, 0x0A, 0x0B, 0x44, 0x50, // "≈" (U+2248)
  0x22, 0x60, 0x01, 0x02, 0x09, 0x0B, 0x0B, 0x44, 0x6C, // "≠" (U+2260)
  0x22, 0x64, 0x01, 0x00, 0x09, 0x0B, 0x0B, 0x44, 0x90, // "≤" (U+2264)
  0x22, 0x65, 0x01, 0x00, 0x09, 0x0B, 0x0B, 0x44, 0xB7, // "≥" (U+2265)
  
  // Kerning pairs
  
  // Glyph data
  // "!" (U+0021)
  0x8B, 0x18, 0xF5, 0x8F, 0x57, 0xF4, 0x7F, 0x46, 0xF3, 0x6F, 0x35, 0xF2, 0x5F, 0x24, 0xF1, 0x48,
  0x61, 0x09, 0xF6, 0x7E, 0x40,
  // """ (U+0022)
  0x8B, 0x41, 0xF8, 0x0B, 0xD0, 0xF7, 0x0A, 0xC0, 0xE6, 0x09, 0xB0, 0xD5, 0x08, 0xA0, 0xC4, 0x07,
  0x90,
  // "#" (U+0023)
  0x48, 0x3D, 0x70, 0x4E, 0x69, 0x82, 0x40, 0x7B, 0x58, 0x43, 0xF1, 0x0A, 0x83, 0x87, 0x11, 0x6E,
  0x11, 0xD6, 0x12, 0xFA, 0x89, 0x26, 0x03, 0x3C, 0x93, 0x7F, 0x43, 0x13, 0x83, 0xE4, 0x07, 0xC4,
  0x89, 0x11, 0x3F, 0x21, 0xA9, 0x11, 0x09, 0xF9, 0x89, 0x2C, 0x02, 0x3A, 0xC3, 0x4F, 0x63, 0x33,
  0x82, 0xB8, 0x03, 0x96, 0x83, 0xE5, 0x07, 0xC5, 0x84, 0x1F, 0x20, 0xA9, 0x40,
  // "$" (U+0024)
  0x30, 0x40, 0xD6, 0x84, 0x5A, 0xE8, 0x61, 0x28, 0xA4, 0xBF, 0xEF, 0xDF, 0xB0, 0x5F, 0x54, 0xD0,
  0x12, 0x08, 0xF0, 0x4D, 0x48, 0x35, 0xF5, 0x4D, 0x58, 0x3C, 0xFD, 0xE1, 0x50, 0x60, 0xDA, 0x0A,
  0x01, 0x48, 0x34, 0xE8, 0xED, 0x48, 0x44, 0xD0, 0x5F, 0x43, 0x89, 0x74, 0xD0, 0x4F, 0x44, 0x73,
  0x5E, 0x5D, 0xD0, 0x4E, 0xC0, 0xA0, 0x23, 0x81, 0x26, 0xE7, 0x04, 0x0D, 0x40,
  // "%" (U+0025)
  0x83, 0x1B, 0xEB, 0x22, 0x87, 0x5E, 0x10, 0xAD, 0x5B, 0xC2, 0x0C, 0x08, 0x28, 0x7E, 0x60, 0x4F,
  0x05, 0xE1, 0x28, 0x6E, 0x50, 0x3F, 0x1C, 0x83, 0x86, 0xBB, 0x29, 0xD4, 0xF1, 0x38, 0x53, 0xEF,
  0xE4, 0xC8, 0x68, 0x33, 0x14, 0xF1, 0x71, 0x84, 0xC9, 0x5E, 0xFA, 0x48, 0x64, 0xF3, 0xF8, 0x5E,
  0x73, 0x81, 0xC9, 0x49, 0x20, 0x90, 0xB2, 0x82, 0x4F, 0x14, 0x92, 0x09, 0x0B, 0x28, 0x93, 0xB9,
  0x01, 0xE9, 0x6E, 0x70, 0x3F, 0x22, 0x82, 0x4D, 0xE9, 0x10,
  // "&" (U+0026)
  0x28, 0x33, 0xCE, 0xC3, 0x68, 0x3D, 0xC5, 0xCD, 0x58, 0x52, 0xF4, 0x05, 0xF2, 0x48, 0x52, 0xF6,
  0x06, 0xF1, 0x58, 0x3C, 0xB2, 0xE9, 0x68, 0x35, 0xFE, 0xC1, 0x60, 0x5A, 0x02, 0x68, 0x35, 0xFA,
  0xDC, 0x20, 0xC0, 0xA2, 0x89, 0x3E, 0xB0, 0x2E, 0xA2, 0xF6, 0x04, 0xF4, 0x28, 0x24, 0xFD, 0xE2,
  0x81, 0x2F, 0x63, 0x81, 0x9F, 0x93, 0x87, 0xCE, 0x75, 0xAF, 0xCF, 0x42, 0x89, 0x01, 0xAE, 0xEB,
  0x40, 0xCE, 0x10,
  // "'" (U+0027)
  0x89, 0x46, 0xF3, 0x5F, 0x24, 0xF1, 0x3F, 0x02, 0xE1,
  // "(" (U+0028)
  0x28, 0x12, 0xE6, 0x20, 0xB0, 0xC2, 0x81, 0x3F, 0x52, 0x0A, 0x0E, 0x30, 0xE0, 0xA2, 0x81, 0x2F,
  0x72, 0x81, 0x4F, 0x42, 0x81, 0x5F, 0x32, 0x81, 0x5F, 0x32, 0x81, 0x4F, 0x42, 0x81, 0x2F, 0x63,
  0x0E, 0x0A, 0x30, 0xA0, 0xE3, 0x81, 0x4F, 0x53, 0x0B, 0x0C, 0x38, 0x12, 0xE6,
  // ")" (U+0029)
  0x81, 0x6E, 0x23, 0x0C, 0x0B, 0x38, 0x15, 0xF4, 0x30, 0xE0, 0xA3, 0x0A, 0x0E, 0x38, 0x16, 0xF2,
  0x28, 0x14, 0xF4, 0x28, 0x13, 0xF5, 0x28, 0x13, 0xF5, 0x28, 0x14, 0xF4, 0x28, 0x17, 0xF2, 0x20,
  0xA0, 0xE3, 0x0E, 0x0A, 0x28, 0x15, 0xF3, 0x20, 0xC0, 0xB2, 0x81, 0x6E, 0x22,
  // "*" (U+002A)
  0x38, 0x14, 0xF1, 0x60, 0x39, 0x48, 0x95, 0x15, 0x11, 0xE0, 0x37, 0x04, 0xEF, 0xDF, 0xEA, 0x02,
  0x28, 0x31, 0xCE, 0xA1, 0x48, 0x37, 0xE4, 0xF5, 0x38, 0x42, 0xF7, 0x0A, 0xE4, 0x03, 0x20, 0x02,
  0x20,
  // "+" (U+002B)
  0x38, 0x13, 0xF1, 0x68, 0x13, 0xF1, 0x68, 0x13, 0xF1, 0x48, 0x71, 0x14, 0xF2, 0x11, 0x08, 0xF8,
  0x90, 0x52, 0x33, 0x6F, 0x43, 0x31, 0x38, 0x13, 0xF1, 0x68, 0x13, 0xF1, 0x68, 0x13, 0xF1, 0x30,
  // "," (U+002C)
  0x18, 0xA0, 0x4F, 0xB0, 0x7F, 0x60, 0xAF, 0x10, 0xDB, 0x01, 0xF5, 0x10,
  // "-" (U+002D)
  0x18, 0x01, 0x11, 0x04, 0xD0, 0x01, 0x80, 0x13, 0x10,
  // "." (U+002E)
  0x18, 0x61, 0x09, 0xF6, 0x7E, 0x40,
  // "/" (U+002F)
  0x48, 0x11, 0xF6, 0x48, 0x17, 0xF1, 0x40, 0xD0, 0xA4, 0x81, 0x3F, 0x44, 0x09, 0x0E, 0x50, 0xE0,
  0x84, 0x81, 0x5F, 0x24, 0x0B, 0x0C, 0x48, 0x12, 0xF6, 0x48, 0x18, 0xF1, 0x40, 0xD0, 0xA4, 0x81,
  0x4F, 0x44, 0x0A, 0x0D, 0x50,
  // "0" (U+0030)
  0x28, 0x38, 0xDF, 0xD6, 0x38, 0x91, 0xBE, 0x75, 0xAF, 0x70, 0x4F, 0x52, 0x02, 0xA8, 0x11, 0x9E,
  0x38, 0x4B, 0xEF, 0x5C, 0xB2, 0x85, 0x4F, 0x5D, 0x8D, 0x92, 0x8A, 0x1D, 0xB0, 0xCA, 0xE9, 0x08,
  0xF2, 0x0B, 0xAD, 0x92, 0xF8, 0x28, 0x4C, 0xAC, 0xBB, 0xD3, 0x81, 0xD8, 0x9A, 0x04, 0x28, 0x41,
  0xF5, 0x4F, 0xB3, 0x89, 0x18, 0xF1, 0x0B, 0xF8, 0x59, 0xF7, 0x38, 0x38, 0xDF, 0xD6, 0x20,
  // "1" (U+0031)
  0x18, 0x21, 0x8F, 0x93, 0x07, 0x0E, 0xA0, 0x93, 0x83, 0xD9, 0x2D, 0x96, 0x0D, 0x09, 0x60, 0xE0,
  0x96, 0x0E, 0x09, 0x60, 0xE0, 0x96, 0x0E, 0x09, 0x60, 0xE0, 0x96, 0x0E, 0x09, 0x60, 0xE0, 0x93,
  0x87, 0x12, 0x2E, 0xB2, 0x21, 0x9E, 0x05,
  // "2" (U+0032)
  0x18, 0x43, 0xAE, 0xEC, 0x62, 0x86, 0x5F, 0xC6, 0x5A, 0xF8, 0x20, 0x54, 0x0B, 0x0E, 0x78, 0x18,
  0xF1, 0x60, 0xA9, 0x68, 0x11, 0xEB, 0x68, 0x1B, 0xF3, 0x58, 0x18, 0xF7, 0x58, 0x17, 0xF9, 0x58,
  0x17, 0xF9, 0x58, 0x17, 0xF9, 0x58, 0x16, 0xFD, 0x80, 0x15, 0x04, 0x0B, 0xF0, 0xC0,
  // "3" (U+0033)
  0x18, 0x46, 0xBE, 0xED, 0x72, 0x86, 0x4E, 0x96, 0x59, 0xF9, 0x70, 0xA0, 0xE7, 0x0B, 0x0E, 0x48,
  0x31, 0x39, 0xF5, 0x30, 0xCA, 0x0D, 0x04, 0x48, 0x43, 0x45, 0xAF, 0x77, 0x81, 0x8F, 0x26, 0x81,
  0x3F, 0x56, 0x82, 0x4F, 0x61, 0x58, 0xA1, 0xAF, 0x2A, 0xC7, 0x56, 0xBF, 0x80, 0x4B, 0xDF, 0xEB,
  0x52,
  // "4" (U+0034)
  0x50, 0x2A, 0x70, 0xAA, 0x68, 0x14, 0xF9, 0x96, 0x81, 0xD9, 0x79, 0x58, 0x27, 0xE1, 0x79, 0x48,
  0x31, 0xE7, 0x07, 0x94, 0x0A, 0x0D, 0x20, 0x89, 0x38, 0x13, 0xF4, 0x20, 0x89, 0x38, 0x90, 0xCB,
  0x11, 0x18, 0xF2, 0x11, 0xF9, 0x0E, 0x18, 0x01, 0x48, 0x2A, 0xF4, 0x46, 0x08, 0x97, 0x10, 0x89,
  0x20,
  // "5" (U+0035)
  0x10, 0xDD, 0x09, 0x28, 0x5E, 0xA5, 0x55, 0x53, 0x29, 0x07, 0x68, 0x11, 0xF5, 0x68, 0x12, 0xF4,
  0x68, 0x13, 0xFE, 0xA0, 0xD0, 0x73, 0x85, 0x65, 0x45, 0xBF, 0x97, 0x81, 0xBF, 0x16, 0x81, 0x6F,
  0x46, 0x81, 0x6F, 0x46, 0x8A, 0x1B, 0xE1, 0x8A, 0x75, 0x7C, 0xF6, 0x03, 0xBD, 0xFE, 0xB4, 0x20,
  // "6" (U+0036)
  0x28, 0x41, 0x8D, 0xEF, 0x92, 0x85, 0x2E, 0xE8, 0x55, 0x42, 0x81, 0xDD, 0x15, 0x81, 0x5F, 0x56,
  0x09, 0x0E, 0x78, 0x2B, 0xC4, 0xDA, 0x89, 0x5B, 0x30, 0xDD, 0xD6, 0x46, 0xDE, 0x2E, 0xE1, 0x38,
  0x32, 0xF8, 0xDB, 0x58, 0x2D, 0xAA, 0xD5, 0x83, 0xEA, 0x5F, 0x43, 0x89, 0x13, 0xF6, 0x0B, 0xF8,
  0x57, 0xED, 0x38, 0x48, 0xDF, 0xE9, 0x11,
  // "7" (U+0037)
  0x0E, 0xF0, 0xB0, 0x48, 0x02, 0x59, 0x08, 0x68, 0x16, 0xF2, 0x60, 0xD0, 0xB6, 0x81, 0x4F, 0x56,
  0x0A, 0x0E, 0x68, 0x11, 0xF8, 0x68, 0x18, 0xF1, 0x60, 0xE0, 0xA6, 0x81, 0x6F, 0x46, 0x0C, 0x0D,
  0x68, 0x13, 0xF7, 0x68, 0x1A, 0xF1, 0x40,
  // "8" (U+0038)
  0x18, 0x41, 0x9D, 0xFD, 0x83, 0x89, 0x1D, 0xE7, 0x58, 0xFA, 0x04, 0xF5, 0x38, 0x49, 0xF1, 0x4F,
  0x43, 0x84, 0x7F, 0x10, 0xEB, 0x28, 0x11, 0xDB, 0x28, 0x53, 0xED, 0x8E, 0xB1, 0x38, 0x39, 0xFE,
  0xE5, 0x38, 0x91, 0xCD, 0x31, 0x8F, 0x90, 0x8F, 0x23, 0x83, 0x6F, 0x4B, 0xD4, 0x84, 0x1F, 0x8A,
  0xF1, 0x38, 0x91, 0x4F, 0x63, 0xFD, 0x65, 0x8E, 0xD2, 0x85, 0x3A, 0xDF, 0xD8, 0x11,
  // "9" (U+0039)
  0x18, 0x42, 0xAE, 0xEC, 0x62, 0x89, 0x22, 0xED, 0x75, 0xAF, 0x80, 0x9E, 0x13, 0x83, 0x8F, 0x2D,
  0xB4, 0x83, 0x1F, 0x6D, 0xA5, 0x82, 0xE9, 0xBD, 0x48, 0x95, 0x3F, 0xA5, 0xF9, 0x21, 0x5D, 0xEA,
  0x07, 0xEA, 0x82, 0xE4, 0xF9, 0x38, 0x43, 0x30, 0x2F, 0x66, 0x81, 0x7F, 0x25, 0x81, 0x3E, 0xA2,
  0x0F, 0x58, 0x29, 0xFC, 0x12, 0x83, 0x9F, 0xEC, 0x73,
  // ":" (U+003A)
  0x86, 0x7E, 0x48, 0xF6, 0x01, 0x77, 0x86, 0x10, 0x9F, 0x57, 0xE4,
  // ";" (U+003B)
  0x18, 0x52, 0xDA, 0x02, 0xFC, 0x20, 0x17, 0x74, 0x8A, 0x04, 0xFB, 0x07, 0xF6, 0x0A, 0xF1, 0x0D,
  0xB0, 0x1F, 0x51,
  // "<" (U+003C)
  0x70, 0x60, 0x45, 0x82, 0x5D, 0xE3, 0x38, 0x23, 0xCE, 0x73, 0x83, 0x2A, 0xF9, 0x13, 0x82, 0x2F,
  0xD2, 0x68, 0x28, 0xEC, 0x56, 0x83, 0x17, 0xED, 0x66, 0x83, 0x17, 0xED, 0x37, 0x07, 0x04,
  // "=" (U+003D)
  0x18, 0x03, 0x11, 0x0B, 0xF0, 0x80, 0x28, 0x03, 0x30, 0x27, 0x38, 0x03, 0x11, 0x0B, 0xF0, 0x80,
  0x28, 0x03, 0x30, 0x20,
  // ">" (U+003E)
  0x04, 0x06, 0x78, 0x23, 0xED, 0x57, 0x82, 0x7E, 0xB3, 0x68, 0x31, 0x9F, 0xA1, 0x68, 0x22, 0xDF,
  0x24, 0x82, 0x5C, 0xE8, 0x38, 0x36, 0xDE, 0x71, 0x28, 0x33, 0xDE, 0x71, 0x40, 0x40, 0x77,
  // "?" (U+003F)
  0x85, 0x17, 0xCE, 0xEC, 0x72, 0x86, 0x1F, 0xA6, 0x58, 0xFA, 0x20, 0x14, 0x81, 0x8F, 0x16, 0x81,
  0x6F, 0x26, 0x0A, 0x0E, 0x68, 0x17, 0xF6, 0x58, 0x1A, 0xF7, 0x58, 0x17, 0xF4, 0x60, 0xC0, 0xA7,
  0x05, 0x03, 0x77, 0x18, 0x11, 0xFD, 0x68, 0x11, 0xDB, 0x40,
  // "@" (U+0040)
  0x38, 0x46, 0xCE, 0xD9, 0x14, 0x86, 0xBE, 0x85, 0x7D, 0xD1, 0x28, 0x18, 0xE2, 0x48, 0x9A, 0x2C,
  0x90, 0x1E, 0x50, 0x9E, 0xEB, 0x3F, 0x15, 0xE0, 0x9E, 0x6A, 0xF0, 0xD4, 0x8A, 0x0F, 0x60, 0x6E,
  0x0B, 0x6A, 0x83, 0xF3, 0x07, 0xD0, 0xA7, 0xB8, 0x4F, 0x10, 0x8C, 0x0B, 0x7A, 0x93, 0xF2, 0x0B,
  0xC0, 0xC5, 0x8B, 0x0E, 0x83, 0xDD, 0x3F, 0x13, 0xF1, 0x7A, 0x82, 0x59, 0xFA, 0x28, 0x3C, 0xA0,
  0x22, 0x20, 0x33, 0x86, 0x3E, 0xB4, 0x11, 0x36, 0x40, 0x30, 0xBC, 0x09, 0x68, 0x11, 0x32, 0x40,
  // "A" (U+0041)
  0x48, 0x19, 0xF6, 0x71, 0x81, 0xEF, 0xB7, 0x83, 0x4F, 0xAF, 0x16, 0x83, 0x9E, 0x3F, 0x56, 0x83,
  0xEA, 0x0D, 0xA5, 0x83, 0x3F, 0x50, 0x99, 0x58, 0x58, 0xF1, 0x04, 0xF5, 0x48, 0x5D, 0xC2, 0x22,
  0xFA, 0x30, 0x3E, 0x0E, 0x38, 0x78, 0xF6, 0x55, 0x58, 0xF4, 0x20, 0xD0, 0xC4, 0x85, 0x1F, 0x90,
  0x2F, 0x75, 0x84, 0xBE, 0x07, 0xF2, 0x58, 0x15, 0xF4,
  // "B" (U+0042)
  0x04, 0xB8, 0x97, 0xED, 0x81, 0x04, 0xF7, 0x55, 0x8E, 0xD0, 0x4F, 0x33, 0x84, 0x6F, 0x54, 0xF3,
  0x38, 0x43, 0xF6, 0x4F, 0x33, 0x89, 0x35, 0xF4, 0x4F, 0x41, 0x14, 0xDB, 0x04, 0xD8, 0x95, 0xA1,
  0x04, 0xF6, 0x34, 0x6D, 0xE2, 0x4F, 0x33, 0x84, 0x1F, 0xA4, 0xF3, 0x48, 0x3D, 0xC4, 0xF3, 0x38,
  0x93, 0x2F, 0xA4, 0xF7, 0x55, 0x7D, 0xF3, 0x4C, 0x81, 0xDA, 0x21,
  // "C" (U+0043)
  0x28, 0xA2, 0x18, 0xDF, 0xEB, 0x50, 0x2E, 0xE7, 0x56, 0xA7, 0x0C, 0xD1, 0x58, 0x14, 0xF6, 0x68,
  0x19, 0xF1, 0x60, 0xB0, 0xD7, 0x0C, 0x0D, 0x70, 0xB0, 0xD7, 0x09, 0x97, 0x81, 0x5F, 0x57, 0x00,
  0xD7, 0x86, 0x3E, 0xD7, 0x56, 0x94, 0x28, 0x52, 0x9D, 0xFE, 0xB3,
  // "D" (U+0044)
  0x0B, 0xB8, 0x1D, 0x92, 0x28, 0x91, 0xBE, 0x55, 0x8E, 0xE4, 0x0B, 0xD3, 0x84, 0x1C, 0xE1, 0xBD,
  0x48, 0x33, 0xF7, 0xBD, 0x58, 0x2D, 0xCB, 0xD5, 0x82, 0xBE, 0xBD, 0x58, 0x2A, 0xEB, 0xD5, 0x82,
  0xBE, 0xBD, 0x58, 0x2E, 0xBB, 0xD4, 0x83, 0x4F, 0x7B, 0xD3, 0x89, 0x41, 0xDE, 0x1B, 0xE5, 0x58,
  0xEE, 0x30, 0xBA, 0x82, 0xED, 0x81, 0x20,
  // "E" (U+0045)
  0x04, 0xF8, 0x24, 0x4F, 0x88, 0x01, 0x58, 0x21, 0x4F, 0x56, 0x81, 0x4F, 0x56, 0x81, 0x4F, 0x56,
  0x81, 0x4F, 0x58, 0x01, 0x11, 0x04, 0xE8, 0x3E, 0x04, 0xF7, 0x80, 0x13, 0x18, 0x14, 0xF5, 0x68,
  0x14, 0xF5, 0x68, 0x14, 0xF5, 0x68, 0x14, 0xF8, 0x80, 0x15, 0x01, 0x04, 0xF0, 0x40,
  // "F" (U+0046)
  0x04, 0xF8, 0x24, 0x4F, 0x88, 0x01, 0x58, 0x21, 0x4F, 0x56, 0x81, 0x4F, 0x56, 0x81, 0x4F, 0x56,
  0x81, 0x4F, 0x58, 0x01, 0x11, 0x04, 0xE8, 0x3E, 0x04, 0xF7, 0x80, 0x13, 0x18, 0x14, 0xF5, 0x68,
  0x14, 0xF5, 0x68, 0x14, 0xF5, 0x68, 0x14, 0xF5, 0x68, 0x14, 0xF5, 0x60,
  // "G" (U+0047)
  0x38, 0x54, 0xBE, 0xFD, 0x91, 0x28, 0x92, 0x7F, 0xC6, 0x57, 0xC1, 0x03, 0xF9, 0x78, 0x1A, 0xE1,
  0x70, 0xE0, 0xA7, 0x81, 0x1F, 0x83, 0x0F, 0x11, 0x81, 0x2F, 0x72, 0x05, 0xB8, 0x28, 0x2F, 0x82,
  0x86, 0x13, 0x4F, 0x80, 0xFA, 0x59, 0x82, 0x80, 0xCE, 0x59, 0x83, 0x80, 0x6F, 0x84, 0x90, 0x82,
  0x86, 0xAF, 0xB6, 0x57, 0xF8, 0x38, 0x56, 0xCE, 0xFD, 0xA4,
  // "H" (U+0048)
  0x0B, 0x0D, 0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31,
  0xF8, 0xBD, 0x48, 0x93, 0x1F, 0x8B, 0xD1, 0x11, 0x12, 0xF8, 0xBF, 0x89, 0x28, 0xBE, 0x33, 0x33,
  0x4F, 0x8B, 0xD4, 0x83, 0x1F, 0x8B, 0xD4, 0x83, 0x1F, 0x8B, 0xD4, 0x83, 0x1F, 0x8B, 0xD4, 0x83,
  0x1F, 0x8B, 0xD4, 0x81, 0x1F, 0x80,
  // "I" (U+0049)
  0xE8, 0x6C, 0x46, 0xAF, 0x85, 0x32, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81,
  0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F,
  0x22, 0x85, 0x23, 0x9F, 0x63, 0x1E, 0x0C,
  // "J" (U+004A)
  0x58, 0x13, 0xF5, 0x58, 0x13, 0xF5, 0x58, 0x13, 0xF5, 0x58, 0x13, 0xF5, 0x58, 0x13, 0xF5, 0x58,
  0x13, 0xF5, 0x58, 0x13, 0xF5, 0x58, 0x13, 0xF5, 0x58, 0x13, 0xF5, 0x58, 0x15, 0xF4, 0x58, 0x97,
  0x9F, 0x12, 0xA6, 0x59, 0xF9, 0x01, 0xBE, 0xFD, 0x82,
  // "K" (U+004B)
  0x0B, 0x0D, 0x48, 0x37, 0xF5, 0xBD, 0x38, 0x43, 0xFA, 0x0B, 0xD2, 0x81, 0x1D, 0xD2, 0x0B, 0x0D,
  0x28, 0x1A, 0xF3, 0x28, 0x4B, 0xD0, 0x6F, 0x73, 0x83, 0xBD, 0x2E, 0xB4, 0x83, 0xBD, 0xBF, 0xB4,
  0x84, 0xBF, 0xD7, 0xF6, 0x38, 0x5B, 0xE2, 0x0B, 0xE1, 0x20, 0xB0, 0xD2, 0x81, 0x2F, 0xA2, 0x0B,
  0x0D, 0x38, 0x47, 0xF4, 0x0B, 0xD4, 0x83, 0xDD, 0x0B, 0xD4, 0x81, 0x4F, 0x90,
  // "L" (U+004C)
  0x0E, 0x0A, 0x60, 0xE0, 0xA6, 0x0E, 0x0A, 0x60, 0xE0, 0xA6, 0x0E, 0x0A, 0x60, 0xE0, 0xA6, 0x0E,
  0x0A, 0x60, 0xE0, 0xA6, 0x0E, 0x0A, 0x60, 0xE0, 0xA6, 0x0E, 0x0A, 0x60, 0xE0, 0xD8, 0x01, 0x80,
  0x20, 0xEE, 0x04,
  // "M" (U+004D)
  0x01, 0xA0, 0x53, 0x82, 0x9F, 0xE1, 0xA0, 0x93, 0x85, 0xDF, 0xE1, 0xFC, 0xE2, 0x89, 0x93, 0x2F,
  0xBE, 0x1F, 0x8F, 0x30, 0x6E, 0x9E, 0x1F, 0x6E, 0x70, 0xAA, 0x9E, 0x1F, 0x69, 0xB0, 0xE6, 0x9E,
  0x1F, 0x65, 0xF4, 0xF1, 0x9E, 0x1F, 0x60, 0xFD, 0xC0, 0x9E, 0x1F, 0x60, 0xBF, 0x70, 0x9E, 0x1F,
  0x60, 0x5B, 0x30, 0x9E, 0x1F, 0x65, 0x83, 0x9E, 0x1F, 0x65, 0x83, 0x9E, 0x1F, 0x65, 0x09, 0x0E,
  // "N" (U+004E)
  0x81, 0xBF, 0x94, 0x90, 0x80, 0xBA, 0x01, 0x39, 0x83, 0x8B, 0xBE, 0x73, 0x98, 0x38, 0xBB, 0x9D,
  0x39, 0x84, 0x8B, 0xC2, 0xF5, 0x29, 0x84, 0x8B, 0xC0, 0xBB, 0x29, 0x89, 0x28, 0xBC, 0x04, 0xF3,
  0x0F, 0x8B, 0xC2, 0x85, 0xC9, 0x0F, 0x8B, 0xC2, 0x85, 0x6F, 0x1F, 0x8B, 0xC3, 0x84, 0xE7, 0xE8,
  0xBC, 0x38, 0x48, 0xDE, 0x8B, 0xC3, 0x01, 0xA8, 0x18, 0xBC, 0x48, 0x19, 0xF8,
  // "O" (U+004F)
  0x28, 0x41, 0x8D, 0xED, 0x74, 0x85, 0xCE, 0x75, 0x8F, 0x92, 0x81, 0x6F, 0x43, 0x84, 0x7F, 0x30,
  0xCD, 0x48, 0x41, 0xF9, 0x0F, 0x95, 0x83, 0xCC, 0x1F, 0x75, 0x83, 0xBE, 0x2F, 0x75, 0x83, 0xAF,
  0x1F, 0x75, 0x83, 0xBE, 0x0F, 0x95, 0x83, 0xCC, 0x0C, 0xD4, 0x85, 0x1F, 0x90, 0x6F, 0x43, 0x81,
  0x7F, 0x32, 0x85, 0xCE, 0x75, 0x8F, 0x93, 0x84, 0x18, 0xDE, 0xD7, 0x20,
  // "P" (U+0050)
  0x04, 0xC8, 0x96, 0xEA, 0x20, 0x4F, 0x85, 0x58, 0xEE, 0x24, 0xF5, 0x38, 0x43, 0xF9, 0x4F, 0x54,
  0x83, 0xEC, 0x4F, 0x54, 0x83, 0xEB, 0x4F, 0x53, 0x89, 0x32, 0xF8, 0x4F, 0x51, 0x25, 0xDE, 0x14,
  0xD8, 0x7C, 0x30, 0x4F, 0x73, 0x31, 0x38, 0x14, 0xF5, 0x68, 0x14, 0xF5, 0x68, 0x14, 0xF5, 0x68,
  0x14, 0xF5, 0x60,
  // "Q" (U+0051)
  0x28, 0x41, 0x8D, 0xED, 0x64, 0x85, 0xCE, 0x75, 0x8F, 0x92, 0x81, 0x6F, 0x43, 0x84, 0x7F, 0x30,
  0xCD, 0x48, 0x41, 0xF9, 0x0F, 0x95, 0x83, 0xCC, 0x1F, 0x75, 0x83, 0xBE, 0x2F, 0x75, 0x83, 0xAF,
  0x1F, 0x75, 0x83, 0xBE, 0x0F, 0x95, 0x83, 0xCC, 0x0C, 0xD4, 0x85, 0x1F, 0x90, 0x6F, 0x43, 0x81,
  0x7F, 0x32, 0x85, 0xCE, 0x75, 0x8F, 0xA3, 0x81, 0x18, 0xDA, 0x0E, 0x71, 0x81, 0x5F, 0x57, 0x10,
  0xC0, 0xD7, 0x18, 0x14, 0xF7,
  // "R" (U+0052)
  0x04, 0xB8, 0x1E, 0xC7, 0x28, 0x92, 0x4F, 0x85, 0x6A, 0xFA, 0x04, 0xF5, 0x38, 0x4A, 0xF1, 0x4F,
  0x53, 0x84, 0x7F, 0x34, 0xF5, 0x38, 0x93, 0x9F, 0x14, 0xF5, 0x12, 0x7F, 0x80, 0x4C, 0x0E, 0x06,
  0x28, 0x54, 0xF7, 0x39, 0xF3, 0x28, 0x14, 0xF5, 0x20, 0xE0, 0xB2, 0x81, 0x4F, 0x52, 0x85, 0x6F,
  0x40, 0x4F, 0x53, 0x84, 0xDC, 0x04, 0xF5, 0x38, 0x45, 0xF6, 0x4F, 0x54, 0x0C, 0x0E,
  // "S" (U+0053)
  0x28, 0xA1, 0x6C, 0xEE, 0xC8, 0x10, 0x9F, 0x95, 0x69, 0xD0, 0x1F, 0xA6, 0x81, 0x2F, 0x77, 0x81,
  0xED, 0x16, 0x83, 0x6F, 0xE8, 0x15, 0x03, 0x0B, 0xA0, 0x90, 0x15, 0x82, 0x3B, 0xFD, 0x78, 0x17,
  0xF5, 0x68, 0x12, 0xF7, 0x68, 0xA2, 0x6F, 0x57, 0xB8, 0x65, 0x8F, 0xC0, 0x3A, 0xDE, 0xFD, 0x81,
  0x10,
  // "T" (U+0054)
  0x02, 0xFA, 0x10, 0xF5, 0x81, 0x9F, 0x70, 0xF5, 0x48, 0x16, 0xF3, 0x78, 0x16, 0xF3, 0x78, 0x16,
  0xF3, 0x78, 0x16, 0xF3, 0x78, 0x16, 0xF3, 0x78, 0x16, 0xF3, 0x78, 0x16, 0xF3, 0x78, 0x16, 0xF3,
  0x78, 0x16, 0xF3, 0x78, 0x16, 0xF3, 0x78, 0x16, 0xF3, 0x30,
  // "U" (U+0055)
  0x0B, 0x0D, 0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31,
  0xF8, 0xBD, 0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31,
  0xF8, 0xBE, 0x48, 0x21, 0xF8, 0x99, 0x48, 0x43, 0xF6, 0x6F, 0x43, 0x89, 0x17, 0xF2, 0x0D, 0xE7,
  0x58, 0xFA, 0x28, 0x41, 0x9E, 0xFD, 0x82,
  // "V" (U+0056)
  0x81, 0x6F, 0x45, 0x84, 0x7F, 0x21, 0xF9, 0x50, 0xC0, 0xD2, 0x0B, 0x0D, 0x48, 0x11, 0xF8, 0x28,
  0x16, 0xF2, 0x38, 0x15, 0xF3, 0x28, 0x11, 0xF7, 0x30, 0xA0, 0xE4, 0x0C, 0x0B, 0x30, 0xE0, 0x94,
  0x85, 0x7F, 0x10, 0x3F, 0x44, 0x84, 0x2F, 0x50, 0x7E, 0x68, 0x3D, 0xA0, 0xCA, 0x68, 0x38, 0xE1,
  0xF5, 0x68, 0x33, 0xF7, 0xF1, 0x78, 0x1D, 0xEB, 0x71, 0x81, 0x8F, 0x64,
  // "W" (U+0057)
  0x07, 0x96, 0x84, 0x2F, 0x45, 0xF1, 0x58, 0x44, 0xF3, 0x4F, 0x25, 0x89, 0x25, 0xF1, 0x2F, 0x40,
  0x7F, 0x40, 0x69, 0x29, 0x86, 0x50, 0xAF, 0x80, 0x8D, 0x28, 0x7E, 0x70, 0xEA, 0xB0, 0x9C, 0x28,
  0x7C, 0x82, 0xF4, 0xF0, 0xAA, 0x28, 0x7B, 0x95, 0xD0, 0xE3, 0xB9, 0x28, 0x79, 0xB8, 0x90, 0xB7,
  0xC7, 0x28, 0x77, 0xCC, 0x60, 0x7A, 0xD6, 0x28, 0x76, 0xDF, 0x20, 0x4D, 0xE4, 0x28, 0x14, 0xFE,
  0x3A, 0x03, 0x28, 0x12, 0xFB, 0x38, 0x1C, 0xF1, 0x10,
  // "X" (U+0058)
  0x10, 0xC0, 0xD4, 0x85, 0x1F, 0x90, 0x3F, 0x73, 0x81, 0x9E, 0x12, 0x85, 0x9E, 0x10, 0x3F, 0x63,
  0x84, 0x1E, 0x80, 0xBD, 0x58, 0x37, 0xF6, 0xF4, 0x68, 0x1D, 0xFA, 0x78, 0x18, 0xF5, 0x68, 0x21,
  0xEE, 0xC6, 0x83, 0xAD, 0x2F, 0x74, 0x85, 0x4F, 0x50, 0x8E, 0x13, 0x0D, 0x0C, 0x30, 0xD0, 0xA2,
  0x81, 0x7F, 0x33, 0x84, 0x5F, 0x41, 0xEA, 0x50, 0xC0, 0xD0,
  // "Y" (U+0059)
  0x81, 0x2F, 0x95, 0x84, 0xCD, 0x09, 0xF1, 0x38, 0x53, 0xF6, 0x02, 0xF8, 0x30, 0xA0, 0xD3, 0x09,
  0x0E, 0x28, 0x12, 0xF6, 0x38, 0x42, 0xF7, 0x09, 0xD5, 0x83, 0x9D, 0x1F, 0x65, 0x82, 0x2F, 0xCD,
  0x78, 0x19, 0xF6, 0x78, 0x15, 0xF2, 0x78, 0x15, 0xF2, 0x78, 0x15, 0xF2, 0x78, 0x15, 0xF2, 0x78,
  0x15, 0xF2, 0x30,
  // "Z" (U+005A)
  0x10, 0xEE, 0x87, 0x10, 0x45, 0x55, 0x5D, 0xD6, 0x81, 0x3F, 0x66, 0x0B, 0x0D, 0x68, 0x14, 0xF5,
  0x60, 0xD0, 0xC6, 0x81, 0x6F, 0x36, 0x0D, 0x0A, 0x68, 0x17, 0xF2, 0x58, 0x11, 0xE9, 0x68, 0x18,
  0xF1, 0x58, 0x12, 0xFB, 0x80, 0x15, 0x10, 0x4F, 0x01,
  // "[" (U+005B)
  0x0A, 0xB8, 0x65, 0xAE, 0x55, 0x1A, 0xD3, 0x0A, 0x0D, 0x30, 0xA0, 0xD3, 0x0A, 0x0D, 0x30, 0xA0,
  0xD3, 0x0A, 0x0D, 0x30, 0xA0, 0xD3, 0x0A, 0x0D, 0x30, 0xA0, 0xD3, 0x0A, 0x0D, 0x30, 0xA0, 0xD3,
  0x0A, 0x0D, 0x38, 0x4A, 0xD1, 0x10, 0xAB, 0x84, 0x52, 0x33, 0x31,
  // "\" (U+005C)
  0x81, 0x7F, 0x14, 0x81, 0x1F, 0x75, 0x0A, 0x0D, 0x58, 0x14, 0xF3, 0x50, 0xE0, 0x95, 0x08, 0x0E,
  0x58, 0x12, 0xF5, 0x50, 0xC0, 0xB5, 0x81, 0x6F, 0x24, 0x81, 0x1F, 0x75, 0x0A, 0x0D, 0x58, 0x14,
  0xF4, 0x50, 0xD0, 0xA0,
  // "]" (U+005D)
  0x84, 0x13, 0x33, 0x25, 0xB8, 0x4A, 0x01, 0x1D, 0xA3, 0x0D, 0x0A, 0x30, 0xD0, 0xA3, 0x0D, 0x0A,
  0x30, 0xD0, 0xA3, 0x0D, 0x0A, 0x30, 0xD0, 0xA3, 0x0D, 0x0A, 0x30, 0xD0, 0xA3, 0x0D, 0x0A, 0x30,
  0xD0, 0xA3, 0x0D, 0x0A, 0x38, 0x6D, 0xA1, 0x55, 0xEA, 0x5B, 0x0A,
  // "^" (U+005E)
  0x30, 0x20, 0x67, 0x81, 0xAF, 0x25, 0x82, 0x2F, 0xCA, 0x58, 0x39, 0xA3, 0xF2, 0x38, 0x41, 0xF4,
  0x0B, 0xA3, 0x07, 0x0C, 0x28, 0x13, 0xF2, 0x20, 0xE0, 0x63, 0x83, 0xBA, 0x06, 0xE4, 0x83, 0x3F,
  0x2D, 0x85, 0x0B, 0x0A,
  // "_" (U+005F)
  0x80, 0x61, 0x1F, 0xB0, 0xC8, 0x07, 0x30,
  // "`" (U+0060)
  0x81, 0x5F, 0x82, 0x81, 0x8F, 0x22, 0x09, 0x0C,
  // "a" (U+0061)
  0x18, 0x45, 0xBE, 0xFD, 0x83, 0x85, 0xBA, 0x65, 0x8F, 0xA7, 0x08, 0x96, 0x86, 0x15, 0xF2, 0x04,
  0xBE, 0xC8, 0x92, 0x24, 0xFC, 0x64, 0x37, 0xF2, 0xAE, 0x48, 0x35, 0xF2, 0xAD, 0x48, 0xA3, 0xBF,
  0x26, 0xF9, 0x56, 0xCC, 0xF2, 0x07, 0xDF, 0xD7, 0x2F, 0x20,
  // "b" (U+0062)
  0x08, 0x97, 0x08, 0x97, 0x08, 0x97, 0x08, 0x97, 0x8A, 0x38, 0xF1, 0xAE, 0xEA, 0x10, 0x8F, 0xD9,
  0x58, 0xFD, 0x08, 0xF9, 0x38, 0x46, 0xF6, 0x8F, 0x24, 0x90, 0xA0, 0x89, 0x58, 0x1D, 0xC8, 0x95,
  0x83, 0xDC, 0x8F, 0x24, 0x98, 0x2A, 0x8F, 0x93, 0x8A, 0x26, 0xF6, 0x8E, 0xE9, 0x58, 0xFD, 0x08,
  0xC2, 0xBE, 0xEA, 0x11,
  // "c" (U+0063)
  0x28, 0x97, 0x4B, 0xEE, 0xD8, 0x06, 0xFC, 0x75, 0x7A, 0x0E, 0xC5, 0x81, 0x4F, 0x65, 0x81, 0x6F,
  0x35, 0x81, 0x6F, 0x35, 0x81, 0x5F, 0x55, 0x81, 0x1F, 0xB6, 0x85, 0x8F, 0xC6, 0x57, 0xB2, 0x84,
  0x5C, 0xEF, 0xD9,
  // "d" (U+0064)
  0x68, 0x13, 0xF5, 0x68, 0x13, 0xF5, 0x68, 0x13, 0xF5, 0x68, 0xA6, 0x3F, 0x50, 0x3B, 0xEE, 0xA4,
  0xF5, 0x2E, 0xE7, 0x5A, 0xDF, 0x59, 0xF3, 0x38, 0x3B, 0xF5, 0xDD, 0x48, 0x36, 0xF5, 0xFA, 0x48,
  0x34, 0xF5, 0xFA, 0x48, 0x33, 0xF5, 0xDC, 0x48, 0x45, 0xF5, 0x9F, 0x23, 0x8A, 0x3B, 0xF5, 0x2E,
  0xE7, 0x6A, 0xDF, 0x50, 0x2B, 0xEE, 0xA1, 0xF5,
  // "e" (U+0065)
  0x28, 0x47, 0xDF, 0xE9, 0x12, 0x89, 0x1B, 0xF9, 0x57, 0xEC, 0x05, 0xF5, 0x38, 0x34, 0xF5, 0xBE,
  0x80, 0x11, 0x90, 0x90, 0xDF, 0x81, 0xBD, 0xC8, 0x02, 0x38, 0x12, 0xBE, 0x78, 0x16, 0xF6, 0x78,
  0x6B, 0xF9, 0x65, 0x8C, 0x42, 0x85, 0x6C, 0xEE, 0xD9, 0x10,
  // "f" (U+0066)
  0x48, 0x46, 0xDF, 0xEC, 0x13, 0x84, 0x5F, 0xB5, 0x57, 0x48, 0x19, 0xF1, 0x70, 0xA0, 0xE5, 0x81,
  0xAD, 0xED, 0x89, 0x19, 0x04, 0x55, 0xBF, 0x55, 0x53, 0x40, 0xA0, 0xE7, 0x10, 0xA0, 0xE7, 0x10,
  0xA0, 0xE7, 0x10, 0xA0, 0xE7, 0x10, 0xA0, 0xE7, 0x10, 0xA0, 0xE7, 0x10, 0xA0, 0xE7, 0x10, 0xA0,
  0xE5,
  // "g" (U+0067)
  0x18, 0xA2, 0x2B, 0xEE, 0x91, 0xF5, 0x1E, 0xE7, 0x6A, 0xDF, 0x59, 0xF3, 0x38, 0x39, 0xF5, 0xDC,
  0x48, 0x33, 0xF5, 0xFA, 0x48, 0x31, 0xF5, 0xFA, 0x48, 0x31, 0xF5, 0xDC, 0x48, 0x43, 0xF5, 0x9F,
  0x33, 0x8A, 0x39, 0xF5, 0x2E, 0xE7, 0x59, 0xEF, 0x50, 0x2B, 0xEE, 0xB4, 0xF5, 0x68, 0x13, 0xF4,
  0x68, 0xA1, 0x8F, 0x17, 0xB7, 0x56, 0xAF, 0x90, 0x39, 0xDE, 0xFC, 0x72,
  // "h" (U+0068)
  0x81, 0x8F, 0x16, 0x81, 0x8F, 0x16, 0x81, 0x8F, 0x16, 0x81, 0x8F, 0x16, 0x8A, 0x38, 0xF1, 0x9E,
  0xEB, 0x20, 0x8F, 0xBA, 0x67, 0xEE, 0x08, 0xFA, 0x38, 0x47, 0xF5, 0x8F, 0x33, 0x84, 0x3F, 0x68,
  0xF1, 0x38, 0x42, 0xF7, 0x8F, 0x13, 0x84, 0x2F, 0x78, 0xF1, 0x38, 0x42, 0xF7, 0x8F, 0x13, 0x84,
  0x2F, 0x78, 0xF1, 0x38, 0x42, 0xF7, 0x8F, 0x13, 0x81, 0x2F, 0x70,
  // "i" (U+0069)
  0x38, 0x15, 0xE6, 0x68, 0x17, 0xF8, 0x70, 0x17, 0x60, 0x4C, 0x07, 0x48, 0x33, 0x57, 0xF7, 0x68,
  0x11, 0xF7, 0x68, 0x11, 0xF7, 0x68, 0x11, 0xF7, 0x68, 0x11, 0xF7, 0x68, 0x11, 0xF7, 0x68, 0x11,
  0xF7, 0x38, 0x90, 0x12, 0x46, 0xFA, 0x43, 0x18, 0xF0, 0xB0,
  // "j" (U+006A)
  0x48, 0x1B, 0xE1, 0x48, 0x1C, 0xF2, 0x50, 0x17, 0x20, 0x9C, 0x86, 0x20, 0x25, 0x6B, 0xF2, 0x48,
  0x17, 0xF2, 0x48, 0x17, 0xF2, 0x48, 0x17, 0xF2, 0x48, 0x17, 0xF2, 0x48, 0x17, 0xF2, 0x48, 0x17,
  0xF2, 0x48, 0x17, 0xF2, 0x48, 0x17, 0xF2, 0x48, 0x17, 0xF1, 0x48, 0x95, 0xBF, 0x08, 0x65, 0x9F,
  0x80, 0xBE, 0xFD, 0x72,
  // "k" (U+006B)
  0x81, 0x1F, 0x86, 0x81, 0x1F, 0x86, 0x81, 0x1F, 0x86, 0x81, 0x1F, 0x86, 0x81, 0x1F, 0x83, 0x84,
  0x5F, 0x81, 0xF8, 0x28, 0x91, 0x4F, 0xA0, 0x1F, 0x70, 0x2E, 0xB2, 0x85, 0x1F, 0x71, 0xDD, 0x12,
  0x84, 0x1F, 0x7B, 0xF5, 0x38, 0x51, 0xFD, 0xCC, 0xE1, 0x28, 0x51, 0xFD, 0x11, 0xEB, 0x28, 0x11,
  0xF8, 0x28, 0x55, 0xF7, 0x01, 0xF8, 0x38, 0x4A, 0xF3, 0x1F, 0x83, 0x81, 0x1D, 0xD0,
  // "l" (U+006C)
  0x07, 0xC0, 0x93, 0x84, 0x25, 0x55, 0xF9, 0x79, 0x09, 0x79, 0x09, 0x79, 0x09, 0x79, 0x09, 0x79,
  0x09, 0x79, 0x09, 0x79, 0x09, 0x79, 0x09, 0x79, 0x09, 0x79, 0x09, 0x38, 0x90, 0x12, 0x35, 0xFB,
  0x43, 0x18, 0xF0, 0xB0,
  // "m" (U+006D)
  0x89, 0xC2, 0x1F, 0x5D, 0xE5, 0x6E, 0xD2, 0x1F, 0xE6, 0xCE, 0xD6, 0xEA, 0x1F, 0x90, 0x6F, 0x60,
  0x9D, 0x1F, 0x60, 0x4F, 0x30, 0x8E, 0x1F, 0x50, 0x4F, 0x20, 0x8E, 0x1F, 0x50, 0x4F, 0x20, 0x8E,
  0x1F, 0x50, 0x4F, 0x20, 0x8E, 0x1F, 0x50, 0x4F, 0x20, 0x8E, 0x1F, 0x50, 0x4F, 0x20, 0x8E, 0x1F,
  0x50, 0x4F, 0x20, 0x8E,
  // "n" (U+006E)
  0x8A, 0x38, 0xC1, 0xAE, 0xEB, 0x30, 0x8E, 0xC9, 0x57, 0xEE, 0x18, 0xF9, 0x38, 0x46, 0xF4, 0x8F,
  0x33, 0x84, 0x3F, 0x68, 0xF1, 0x38, 0x42, 0xF7, 0x8F, 0x13, 0x84, 0x2F, 0x78, 0xF1, 0x38, 0x42,
  0xF7, 0x8F, 0x13, 0x84, 0x2F, 0x78, 0xF1, 0x38, 0x42, 0xF7, 0x8F, 0x13, 0x81, 0x2F, 0x70,
  // "o" (U+006F)
  0x18, 0x41, 0x9D, 0xFD, 0x72, 0x89, 0x21, 0xDE, 0x75, 0x9F, 0xA0, 0x8F, 0x33, 0x83, 0x7F, 0x4D,
  0xC5, 0x98, 0x19, 0xFA, 0x58, 0x2D, 0xBF, 0xA5, 0x82, 0xDB, 0xDC, 0x59, 0x82, 0xA8, 0xF3, 0x38,
  0x91, 0x7F, 0x50, 0xDE, 0x85, 0x9F, 0xB2, 0x84, 0x19, 0xDF, 0xD7, 0x20,
  // "p" (U+0070)
  0x8A, 0x38, 0xC2, 0xBE, 0xEA, 0x10, 0x8E, 0xD9, 0x58, 0xFD, 0x08, 0xF8, 0x38, 0x45, 0xF6, 0x8F,
  0x24, 0x98, 0x2A, 0x8F, 0x14, 0x83, 0xDC, 0x8F, 0x14, 0x83, 0xDC, 0x8F, 0x34, 0x98, 0x2A, 0x8F,
  0x83, 0x8A, 0x45, 0xF6, 0x8F, 0xD9, 0x58, 0xFD, 0x08, 0xF2, 0xBE, 0xEA, 0x10, 0x89, 0x70, 0x89,
  0x70, 0x89, 0x70, 0x89, 0x70,
  // "q" (U+0071)
  0x18, 0xA2, 0x2A, 0xEE, 0x91, 0xF5, 0x1E, 0xE7, 0x6B, 0xCF, 0x58, 0xF3, 0x38, 0x3B, 0xF5, 0xDC,
  0x48, 0x36, 0xF5, 0xFA, 0x48, 0x34, 0xF5, 0xFA, 0x48, 0x33, 0xF5, 0xDC, 0x48, 0x45, 0xF5, 0x9F,
  0x33, 0x8A, 0x3B, 0xF5, 0x2E, 0xE7, 0x6A, 0xDF, 0x50, 0x2B, 0xEE, 0x94, 0xF5, 0x68, 0x13, 0xF5,
  0x68, 0x13, 0xF5, 0x68, 0x13, 0xF5, 0x68, 0x13, 0xF5,
  // "r" (U+0072)
  0x09, 0xB8, 0x95, 0x63, 0xDF, 0xE2, 0x25, 0x7F, 0x9E, 0x85, 0x94, 0x81, 0xEF, 0x67, 0x00, 0xE7,
  0x10, 0xE0, 0xB7, 0x10, 0xE0, 0xA7, 0x10, 0xE0, 0xA7, 0x10, 0xE0, 0xA5, 0x85, 0x13, 0x4F, 0xC4,
  0x23, 0x0D, 0xE0, 0x72,
  // "s" (U+0073)
  0x28, 0x97, 0x8D, 0xFE, 0xC5, 0x09, 0xF7, 0x56, 0x95, 0x0E, 0xA6, 0x81, 0xBE, 0x55, 0x83, 0x1B,
  0xFD, 0x65, 0x83, 0x3A, 0xFD, 0x35, 0x81, 0x2E, 0xC6, 0x89, 0x7C, 0xC1, 0xD8, 0x55, 0x9F, 0x80,
  0x9D, 0xEE, 0xC7, 0x10,
  // "t" (U+0074)
  0x30, 0x70, 0x16, 0x81, 0x2F, 0x36, 0x81, 0x4F, 0x34, 0x0C, 0x0E, 0xE1, 0x83, 0x55, 0x8F, 0x70,
  0xF5, 0x38, 0x15, 0xF3, 0x68, 0x15, 0xF3, 0x68, 0x15, 0xF3, 0x68, 0x15, 0xF3, 0x68, 0x15, 0xF4,
  0x68, 0x14, 0xF6, 0x78, 0x4E, 0xE7, 0x56, 0x23, 0x84, 0x3B, 0xEF, 0xD3,
  // "u" (U+0075)
  0x0A, 0x94, 0x82, 0x4F, 0x5A, 0x94, 0x82, 0x4F, 0x5A, 0x94, 0x82, 0x4F, 0x5A, 0x94, 0x82, 0x4F,
  0x5A, 0x94, 0x82, 0x4F, 0x5A, 0x94, 0x82, 0x4F, 0x59, 0x94, 0x84, 0x6F, 0x58, 0xF2, 0x38, 0xA3,
  0xCF, 0x53, 0xFD, 0x66, 0xBD, 0xF5, 0x05, 0xCE, 0xE9, 0x1F, 0x50,
  // "v" (U+0076)
  0x0E, 0x09, 0x58, 0x2D, 0xCA, 0xE4, 0x84, 0x3F, 0x64, 0xF4, 0x38, 0x48, 0xF1, 0x0E, 0xA3, 0x0D,
  0x0B, 0x20, 0x90, 0xE2, 0x81, 0x3F, 0x52, 0x84, 0x3F, 0x50, 0x8E, 0x48, 0x3D, 0xA0, 0xD9, 0x48,
  0x38, 0xE4, 0xF4, 0x48, 0x22, 0xFD, 0xD6, 0x81, 0xCF, 0x83,
  // "w" (U+0077)
  0x0A, 0x0D, 0x79, 0x00, 0x79, 0x30, 0x12, 0x8A, 0x52, 0xF4, 0x5F, 0x20, 0xAF, 0x60, 0x5F, 0x22,
  0xF4, 0x0E, 0xEB, 0x07, 0x92, 0x98, 0x66, 0x3F, 0x7E, 0x09, 0xC2, 0x87, 0xD8, 0x7D, 0x1F, 0x3C,
  0xA2, 0x87, 0xBA, 0xB9, 0x0D, 0x7D, 0x72, 0x87, 0x8B, 0xE5, 0x09, 0xAF, 0x52, 0x87, 0x6E, 0xF1,
  0x05, 0xEF, 0x22, 0x81, 0x3F, 0xD2, 0x01, 0xA2,
  // "x" (U+0078)
  0x81, 0xAF, 0x23, 0x84, 0x5F, 0x71, 0xDC, 0x28, 0x11, 0xEB, 0x28, 0x53, 0xF8, 0x0B, 0xE1, 0x38,
  0x38, 0xF9, 0xF4, 0x58, 0x1C, 0xF9, 0x58, 0x21, 0xDF, 0xB5, 0x83, 0xAE, 0x6F, 0x73, 0x89, 0x16,
  0xF5, 0x09, 0xF3, 0x02, 0xEA, 0x38, 0x4D, 0xD0, 0xCD, 0x13, 0x81, 0x3F, 0x90,
  // "y" (U+0079)
  0x0E, 0x09, 0x58, 0x2D, 0xC8, 0xE4, 0x84, 0x3F, 0x62, 0xF6, 0x38, 0x48, 0xF1, 0x0B, 0xC3, 0x0D,
  0x0A, 0x28, 0x54, 0xF3, 0x03, 0xF4, 0x38, 0x3D, 0x90, 0x8E, 0x48, 0x37, 0xE0, 0xD8, 0x48, 0x31,
  0xF7, 0xF2, 0x58, 0x1A, 0xFC, 0x68, 0x14, 0xF6, 0x68, 0x17, 0xF1, 0x60, 0xD0, 0x94, 0x83, 0x45,
  0xBF, 0x24, 0x82, 0xCF, 0xD4, 0x50,
  // "z" (U+007A)
  0x01, 0xF2, 0x80, 0x15, 0x0E, 0x0D, 0x68, 0x19, 0xF3, 0x58, 0x15, 0xF7, 0x58, 0x12, 0xEA, 0x68,
  0x1C, 0xD1, 0x58, 0x18, 0xF3, 0x58, 0x14, 0xF6, 0x58, 0x11, 0xED, 0x80, 0x15, 0x10, 0x5F, 0x02,
  // "{" (U+007B)
  0x38, 0x22, 0xAE, 0x43, 0x82, 0xDE, 0x71, 0x28, 0x13, 0xF5, 0x48, 0x14, 0xF4, 0x48, 0x14, 0xF4,
  0x48, 0x15, 0xF3, 0x38, 0x13, 0xCE, 0x38, 0x27, 0xFB, 0x13, 0x82, 0x26, 0xEB, 0x58, 0x16, 0xF3,
  0x48, 0x14, 0xF4, 0x48, 0x14, 0xF4, 0x48, 0x14, 0xF4, 0x48, 0x13, 0xF5, 0x58, 0x1E, 0xC3, 0x48,
  0x24, 0xDF, 0x45, 0x02, 0x01,
  // "|" (U+007C)
  0x8E, 0x43, 0xF1, 0x3F, 0x13, 0xF1, 0x3F, 0x13, 0xF1, 0x3F, 0x13, 0xF1, 0x3F, 0x13, 0xF1, 0x3F,
  0x13, 0xF1, 0x3F, 0x13, 0xF1, 0x3F, 0x13, 0xF1, 0x3F, 0x13, 0xF1, 0x3F, 0x10,
  // "}" (U+007D)
  0x01, 0x02, 0x58, 0x24, 0xFD, 0x44, 0x81, 0x3C, 0xE5, 0x81, 0x5F, 0x34, 0x81, 0x4F, 0x44, 0x81,
  0x4F, 0x44, 0x81, 0x4F, 0x44, 0x81, 0x3F, 0x65, 0x82, 0xBE, 0x62, 0x38, 0x21, 0xBF, 0x73, 0x81,
  0xEC, 0x33, 0x81, 0x3F, 0x54, 0x81, 0x4F, 0x44, 0x81, 0x4F, 0x44, 0x81, 0x5F, 0x32, 0x82, 0x16,
  0xDD, 0x38, 0x24, 0xEA, 0x23,
  // "~" (U+007E)
  0x18, 0x2A, 0xFC, 0x22, 0x89, 0x3B, 0x54, 0xD4, 0xAE, 0x63, 0xF1, 0x87, 0x20, 0x7A, 0x82, 0x90,
  0x21, 0x30, 0x10, 0x32,
  // "¡" (U+00A1)
  0x86, 0x4E, 0x76, 0xF9, 0x01, 0x48, 0xB1, 0x2F, 0x42, 0xF5, 0x3F, 0x53, 0xF6, 0x3F, 0x64, 0xF7,
  0x4F, 0x75, 0xF8, 0x5F, 0x80,
  // "¢" (U+00A2)
  0x40, 0xA0, 0x84, 0x04, 0x0C, 0xB8, 0x92, 0xC0, 0x5F, 0xC6, 0x46, 0x90, 0xEC, 0x58, 0x13, 0xF6,
  0x58, 0x15, 0xF4, 0x58, 0x15, 0xF3, 0x58, 0x14, 0xF5, 0x69, 0x0A, 0x68, 0x58, 0xF9, 0x31, 0x37,
  0x20, 0x8C, 0x0E, 0x48, 0x1B, 0x92, 0x50, 0xA0, 0x82,
  // "£" (U+00A3)
  0x38, 0x44, 0xCE, 0xD9, 0x12, 0x84, 0x3F, 0xB5, 0x7B, 0x30, 0x89, 0x70, 0xA0, 0xD7, 0x0A, 0x0D,
  0x68, 0x11, 0xBD, 0x0F, 0x12, 0x05, 0xE8, 0x41, 0x01, 0x3C, 0xE0, 0xF3, 0x40, 0xA0, 0xD7, 0x0B,
  0x0C, 0x70, 0xE0, 0x85, 0x89, 0x01, 0xBF, 0x65, 0x55, 0x52, 0x5F, 0x07,
  // "¤" (U+00A4)
  0x01, 0x03, 0x58, 0xA1, 0x40, 0x7E, 0x7C, 0xEB, 0x7F, 0x40, 0xCF, 0x85, 0x9F, 0x92, 0x0D, 0x05,
  0x38, 0x48, 0xB0, 0x2F, 0x13, 0x03, 0x0E, 0x29, 0x03, 0x30, 0x60, 0xD2, 0x89, 0x1A, 0xD4, 0x15,
  0xE8, 0x05, 0xFB, 0xB8, 0x92, 0xCE, 0x23, 0x60, 0x13, 0x10, 0x81,
  // "¥" (U+00A5)
  0x81, 0x2F, 0x85, 0x84, 0xBD, 0x09, 0xE1, 0x38, 0x53, 0xF6, 0x02, 0xF7, 0x30, 0xA0, 0xD3, 0x09,
  0x0E, 0x28, 0x12, 0xF5, 0x38, 0x42, 0xF6, 0x0A, 0xD5, 0x83, 0x9D, 0x3F, 0x54, 0x84, 0x13, 0xFD,
  0xD1, 0x4E, 0x0C, 0x38, 0x55, 0x59, 0xF6, 0x53, 0x3E, 0x0C, 0x38, 0x53, 0x38, 0xF5, 0x33, 0x58,
  0x16, 0xF2, 0x78, 0x16, 0xF2, 0x30,
  // "¦" (U+00A6)
  0x89, 0x34, 0xF4, 0xF4, 0xF4, 0xF4, 0xF4, 0xF4, 0x97, 0x18, 0x93, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F,
  0x4F, 0x49,
  // "§" (U+00A7)
  0x18, 0x95, 0x8D, 0xFE, 0xB4, 0x9E, 0x75, 0x6A, 0x5C, 0xB5, 0x82, 0x8F, 0x81, 0x40, 0xCA, 0x89,
  0x29, 0x20, 0x7D, 0x35, 0xCE, 0x4D, 0x63, 0x80, 0x0B, 0x38, 0x78, 0xB2, 0xCD, 0x75, 0xE4, 0x28,
  0x35, 0xBF, 0xC1, 0x48, 0x13, 0xE9, 0x58, 0x95, 0xBB, 0xD8, 0x65, 0x9F, 0x78, 0xDE, 0xEC, 0x61,
  // "¨" (U+00A8)
  0x89, 0x47, 0xF3, 0x05, 0xF5, 0x6E, 0x20, 0x4E, 0x40,
  // "©" (U+00A9)
  0x20, 0x20, 0xAA, 0x81, 0xE9, 0x12, 0x8C, 0x02, 0xEA, 0x55, 0x6C, 0xD1, 0x0B, 0x72, 0xCF, 0xD1,
  0xA8, 0x1E, 0x0B, 0xA4, 0x50, 0x1D, 0x2B, 0x0E, 0x24, 0x86, 0xE1, 0xD0, 0xC7, 0x12, 0x28, 0xA3,
  0xD0, 0xD5, 0x4E, 0xFE, 0x07, 0x90, 0x4F, 0x73, 0x54, 0xAE, 0x22, 0x05, 0x0D, 0xB0, 0xC0, 0x25,
  0x81, 0x23, 0x13,
  // "ª" (U+00AA)
  0x18, 0x58, 0xCC, 0xC2, 0x01, 0x28, 0xB0, 0x79, 0x07, 0xDC, 0xDA, 0x2F, 0x10, 0x6A, 0x2E, 0x10,
  0xCA, 0x08, 0xCA, 0x79,
  // "«" (U+00AB)
  0x30, 0x43, 0x04, 0x28, 0xB3, 0x3F, 0x60, 0xBD, 0x02, 0xEA, 0x08, 0xE2, 0x0C, 0xC0, 0x5F, 0x50,
  0x3F, 0x70, 0xBE, 0x12, 0x84, 0x7F, 0x31, 0xDB, 0x38, 0x4A, 0xE1, 0x2E, 0x83, 0x83, 0xB5, 0x04,
  0xC0,
  // "¬" (U+00AC)
  0x18, 0x03, 0x11, 0x0A, 0xF0, 0x40, 0x28, 0x01, 0x38, 0x14, 0xF4, 0x79, 0x04, 0x79, 0x04, 0x70,
  0xB0, 0x30,
  // "®" (U+00AE)
  0x20, 0x20, 0xAA, 0x81, 0xE9, 0x12, 0x89, 0x32, 0xEB, 0x75, 0x6C, 0xD1, 0x0B, 0x73, 0xA8, 0xA0,
  0xC1, 0xA8, 0x1E, 0x03, 0xC5, 0xD4, 0x1D, 0x2B, 0x03, 0xA0, 0xC2, 0x86, 0xE1, 0xD0, 0x3C, 0x7B,
  0x28, 0xA3, 0xD0, 0xD5, 0x3A, 0x0A, 0x67, 0x90, 0x4F, 0x83, 0x14, 0xAE, 0x22, 0x05, 0x0D, 0xB0,
  0xC0, 0x25, 0x81, 0x23, 0x13,
  // "¯" (U+00AF)
  0x18, 0x01, 0x11, 0x04, 0xD0, 0x01, 0x80, 0x13, 0x10,
  // "°" (U+00B0)
  0x18, 0x95, 0x4D, 0xFC, 0x20, 0x1E, 0x74, 0x9D, 0x04, 0xC3, 0x98, 0x51, 0x1F, 0x51, 0x7E, 0x20,
  0x7A, 0x0E, 0x05, 0x30, 0x10, 0x33,
  // "±" (U+00B1)
  0x30, 0x49, 0x70, 0x49, 0x70, 0x49, 0x58, 0x71, 0x15, 0xF1, 0x11, 0x09, 0xF8, 0x90, 0x52, 0x33,
  0x7F, 0x43, 0x31, 0x30, 0x49, 0x70, 0x49, 0x76, 0x02, 0x80, 0x35, 0x01, 0x08, 0xF0, 0x50,
  // "²" (U+00B2)
  0x18, 0x35, 0xCE, 0xB2, 0x28, 0x3B, 0x52, 0xAB, 0x50, 0x50, 0xD5, 0x0A, 0x08, 0x40, 0x80, 0xC4,
  0x81, 0x7D, 0x13, 0x81, 0x7C, 0x13, 0x85, 0x2F, 0xEE, 0xEE, 0x21, 0x80, 0x11, 0x10,
  // "³" (U+00B3)
  0x18, 0x91, 0x6C, 0xDB, 0x20, 0x84, 0x3B, 0xA4, 0x86, 0xB9, 0x02, 0xEF, 0xD1, 0x28, 0x21, 0x3B,
  0xB4, 0x82, 0x5F, 0x14, 0x28, 0x29, 0xC2, 0xDA, 0x0C, 0x03, 0x20, 0x13,
  // "´" (U+00B4)
  0x18, 0x90, 0x2F, 0xC0, 0xBD, 0x15, 0xD2, 0x10,
  // "µ" (U+00B5)
  0x0A, 0x94, 0x82, 0x4F, 0x5A, 0x94, 0x82, 0x4F, 0x5A, 0x94, 0x82, 0x4F, 0x5A, 0x94, 0x82, 0x4F,
  0x5A, 0x94, 0x82, 0x4F, 0x5A, 0x94, 0x82, 0x4F, 0x5A, 0x94, 0x84, 0x6F, 0x5A, 0xF2, 0x38, 0xA4,
  0xCF, 0x5A, 0xFD, 0x66, 0xBD, 0xF5, 0xAF, 0xEF, 0xE9, 0x1F, 0x5A, 0x97, 0x0A, 0x97, 0x0A, 0x97,
  0x0A, 0x97,
  // "¶" (U+00B6)
  0x20, 0x60, 0xDD, 0x81, 0xA0, 0x5C, 0x84, 0xD5, 0x8A, 0x0C, 0xC8, 0x2C, 0x05, 0xA1, 0xD8, 0x3C,
  0x05, 0xA1, 0xD8, 0x2C, 0x05, 0xA1, 0xD8, 0x4C, 0x05, 0xA0, 0xEC, 0x84, 0xC0, 0x5A, 0x09, 0xC8,
  0x5C, 0x05, 0xA0, 0x1C, 0xB8, 0x2C, 0x05, 0xA3, 0x85, 0x24, 0x5C, 0x05, 0xA5, 0x83, 0x3C, 0x05,
  0xA5, 0x83, 0x3C, 0x05, 0xA5, 0x83, 0x3C, 0x05, 0xA5, 0x83, 0x3C, 0x05, 0xA5, 0x83, 0x3C, 0x05,
  0xA5, 0x83, 0x3C, 0x05, 0xA5, 0x83, 0x14, 0x01, 0x30,
  // "·" (U+00B7)
  0x18, 0x61, 0x09, 0xF6, 0x7E, 0x40,
  // "¸" (U+00B8)
  0x20, 0x73, 0x07, 0x0C, 0x38, 0x13, 0xAD, 0x38, 0x54, 0xF1, 0x6F, 0xD6, 0x10,
  // "¹" (U+00B9)
  0x28, 0x13, 0x72, 0x28, 0x31, 0xAE, 0xF4, 0x38, 0x29, 0x2E, 0x45, 0x0E, 0x04, 0x50, 0xE0, 0x45,
  0x0E, 0x04, 0x50, 0xE0, 0x43, 0x0B, 0xC0, 0x20,
  // "º" (U+00BA)
  0x18, 0x93, 0x3C, 0xCB, 0x10, 0xE3, 0x07, 0xB2, 0xE2, 0x82, 0x2E, 0x2E, 0x28, 0x94, 0x2E, 0x0D,
  0x40, 0x8A, 0x02, 0xBC, 0x91,
  // "»" (U+00BB)
  0x83, 0xC4, 0x05, 0xB3, 0x84, 0x8E, 0x21, 0xE9, 0x38, 0x4B, 0xD1, 0x3F, 0x72, 0x8B, 0x31, 0xEB,
  0x07, 0xF3, 0x05, 0xF5, 0x0C, 0xC0, 0x2E, 0x80, 0xAE, 0x20, 0xDB, 0x06, 0xF3, 0x20, 0x43, 0x04,
  0x30,
  // "¼" (U+00BC)
  0x82, 0x3B, 0xF1, 0x38, 0x62, 0xF3, 0x09, 0x8F, 0x13, 0x09, 0x0B, 0x49, 0x01, 0x28, 0x12, 0xF3,
  0x49, 0x01, 0x20, 0x0A, 0x59, 0x83, 0x10, 0x3F, 0x23, 0x85, 0x5E, 0xFE, 0x8B, 0x97, 0x18, 0x44,
  0xF1, 0x1A, 0x45, 0x84, 0xC8, 0x0A, 0xF6, 0x48, 0x55, 0xE1, 0x6B, 0xB6, 0x48, 0x5D, 0x72, 0xE1,
  0xB6, 0x38, 0x76, 0xE0, 0x9F, 0xEF, 0xE4, 0x20, 0xD0, 0x62, 0x82, 0x11, 0xC6, 0x20, 0x30, 0x85,
  0x06, 0x03, 0x10,
  // "½" (U+00BD)
  0x82, 0x3B, 0xF1, 0x38, 0x61, 0xF4, 0x09, 0x8F, 0x13, 0x09, 0x0B, 0x49, 0x01, 0x28, 0x11, 0xF4,
  0x49, 0x01, 0x20, 0x90, 0xB5, 0x98, 0x31, 0x01, 0xF4, 0x38, 0x55, 0xEF, 0xE8, 0x9B, 0x71, 0x81,
  0x2F, 0x37, 0x18, 0x49, 0xB6, 0xEF, 0x94, 0x86, 0x2F, 0x37, 0x56, 0xF2, 0x30, 0x90, 0xB3, 0x03,
  0x0E, 0x38, 0x12, 0xF3, 0x28, 0x13, 0xD3, 0x30, 0x90, 0xB2, 0x82, 0x5D, 0x31, 0x28, 0x12, 0xF3,
  0x2C, 0x82, 0x50, 0x13, 0x38, 0x00, 0x30, 0x10,
  // "¾" (U+00BE)
  0x82, 0x3B, 0xDA, 0x38, 0x71, 0xD4, 0x02, 0x62, 0xD7, 0x20, 0x80, 0xC5, 0x84, 0xD6, 0x01, 0xE5,
  0x38, 0x5B, 0xFE, 0x10, 0x8C, 0x48, 0x51, 0x2C, 0x91, 0xE5, 0x30, 0x22, 0x82, 0xB9, 0x8D, 0x48,
  0x56, 0xFE, 0xC3, 0xE5, 0x71, 0x84, 0x7D, 0x01, 0xA4, 0x58, 0x4E, 0x50, 0xAF, 0x64, 0x85, 0x7D,
  0x06, 0xBB, 0x64, 0x85, 0xE6, 0x2E, 0x1B, 0x63, 0x87, 0x7D, 0x09, 0xFE, 0xFE, 0x42, 0x0E, 0x06,
  0x28, 0x21, 0x1C, 0x62, 0x03, 0x08, 0x50, 0x60, 0x31,
  // "¿" (U+00BF)
  0x48, 0x1B, 0xD1, 0x68, 0x1D, 0xF1, 0x77, 0x10, 0x30, 0x57, 0x0A, 0x0B, 0x68, 0x15, 0xF7, 0x58,
  0x17, 0xFA, 0x58, 0x16, 0xF7, 0x60, 0xE0, 0xA6, 0x81, 0x2F, 0x66, 0x81, 0x1F, 0x84, 0x01, 0x28,
  0x6A, 0xF8, 0x57, 0xAF, 0x12, 0x85, 0x7D, 0xEE, 0xC7, 0x10,
  // "À" (U+00C0)
  0x28, 0x15, 0xF8, 0x72, 0x81, 0x8F, 0x27, 0x20, 0x90, 0xC7, 0x76, 0x81, 0x9F, 0x67, 0x18, 0x1E,
  0xFB, 0x78, 0x34, 0xFA, 0xF1, 0x68, 0x39, 0xE3, 0xF5, 0x68, 0x3E, 0xA0, 0xDA, 0x58, 0x33, 0xF5,
  0x09, 0x95, 0x85, 0x8F, 0x10, 0x4F, 0x54, 0x85, 0xDC, 0x22, 0x2F, 0xA3, 0x03, 0xE0, 0xE3, 0x87,
  0x8F, 0x65, 0x55, 0x8F, 0x42, 0x0D, 0x0C, 0x48, 0x51, 0xF9, 0x02, 0xF7, 0x58, 0x4B, 0xE0, 0x7F,
  0x25, 0x81, 0x5F, 0x40,
  // "Á" (U+00C1)
  0x58, 0x12, 0xFC, 0x71, 0x81, 0xBD, 0x17, 0x81, 0x5D, 0x27, 0x75, 0x81, 0x9F, 0x67, 0x18, 0x1E,
  0xFB, 0x78, 0x34, 0xFA, 0xF1, 0x68, 0x39, 0xE3, 0xF5, 0x68, 0x3E, 0xA0, 0xDA, 0x58, 0x33, 0xF5,
  0x09, 0x95, 0x85, 0x8F, 0x10, 0x4F, 0x54, 0x85, 0xDC, 0x22, 0x2F, 0xA3, 0x03, 0xE0, 0xE3, 0x87,
  0x8F, 0x65, 0x55, 0x8F, 0x42, 0x0D, 0x0C, 0x48, 0x51, 0xF9, 0x02, 0xF7, 0x58, 0x4B, 0xE0, 0x7F,
  0x25, 0x81, 0x5F, 0x40,
  // "Â" (U+00C2)
  0x48, 0x1B, 0xF8, 0x78, 0x38, 0xE7, 0xF4, 0x58, 0x55, 0xD2, 0x05, 0xE3, 0x77, 0x38, 0x19, 0xF6,
  0x71, 0x81, 0xEF, 0xB7, 0x83, 0x4F, 0xAF, 0x16, 0x83, 0x9E, 0x3F, 0x56, 0x83, 0xEA, 0x0D, 0xA5,
  0x83, 0x3F, 0x50, 0x99, 0x58, 0x58, 0xF1, 0x04, 0xF5, 0x48, 0x5D, 0xC2, 0x22, 0xFA, 0x30, 0x3E,
  0x0E, 0x38, 0x78, 0xF6, 0x55, 0x58, 0xF4, 0x20, 0xD0, 0xC4, 0x85, 0x1F, 0x90, 0x2F, 0x75, 0x84,
  0xBE, 0x07, 0xF2, 0x58, 0x15, 0xF4,
  // "Ã" (U+00C3)
  0x28, 0x52, 0xDF, 0x82, 0x97, 0x48, 0x5A, 0x95, 0xDF, 0xE1, 0x40, 0x33, 0x02, 0x01, 0x78, 0x19,
  0xF6, 0x71, 0x81, 0xEF, 0xB7, 0x83, 0x4F, 0xAF, 0x16, 0x83, 0x9E, 0x3F, 0x56, 0x83, 0xEA, 0x0D,
  0xA5, 0x83, 0x3F, 0x50, 0x99, 0x58, 0x58, 0xF1, 0x04, 0xF5, 0x48, 0x5D, 0xC2, 0x22, 0xFA, 0x30,
  0x3E, 0x0E, 0x38, 0x78, 0xF6, 0x55, 0x58, 0xF4, 0x20, 0xD0, 0xC4, 0x85, 0x1F, 0x90, 0x2F, 0x75,
  0x84, 0xBE, 0x07, 0xF2, 0x58, 0x15, 0xF4,
  // "Ä" (U+00C4)
  0x28, 0x57, 0xF3, 0x05, 0xF5, 0x48, 0x56, 0xE2, 0x04, 0xE4, 0x77, 0x38, 0x19, 0xF6, 0x71, 0x81,
  0xEF, 0xB7, 0x83, 0x4F, 0xAF, 0x16, 0x83, 0x9E, 0x3F, 0x56, 0x83, 0xEA, 0x0D, 0xA5, 0x83, 0x3F,
  0x50, 0x99, 0x58, 0x58, 0xF1, 0x04, 0xF5, 0x48, 0x5D, 0xC2, 0x22, 0xFA, 0x30, 0x3E, 0x0E, 0x38,
  0x78, 0xF6, 0x55, 0x58, 0xF4, 0x20, 0xD0, 0xC4, 0x85, 0x1F, 0x90, 0x2F, 0x75, 0x84, 0xBE, 0x07,
  0xF2, 0x58, 0x15, 0xF4,
  // "Å" (U+00C5)
  0x38, 0x21, 0xDF, 0xA7, 0x83, 0x7B, 0x5D, 0x46, 0x83, 0x79, 0x2C, 0x46, 0x82, 0x2E, 0xFC, 0x71,
  0x01, 0x03, 0x72, 0x81, 0x9F, 0x67, 0x18, 0x1E, 0xFB, 0x78, 0x34, 0xFA, 0xF1, 0x68, 0x39, 0xE3,
  0xF5, 0x68, 0x3E, 0xA0, 0xDA, 0x58, 0x33, 0xF5, 0x09, 0x95, 0x85, 0x8F, 0x10, 0x4F, 0x54, 0x85,
  0xDC, 0x22, 0x2F, 0xA3, 0x03, 0xE0, 0xE3, 0x87, 0x8F, 0x65, 0x55, 0x8F, 0x42, 0x0D, 0x0C, 0x48,
  0x51, 0xF9, 0x02, 0xF7, 0x58, 0x4B, 0xE0, 0x7F, 0x25, 0x81, 0x5F, 0x40,
  // "Æ" (U+00C6)
  0x30, 0xDD, 0x0C, 0x28, 0x61, 0xF8, 0xFA, 0x55, 0x32, 0x83, 0x5F, 0x2F, 0x85, 0x83, 0x8E, 0x0F,
  0x85, 0x83, 0xBB, 0x0F, 0x85, 0x85, 0xE8, 0x0F, 0x81, 0x12, 0x81, 0x3F, 0x51, 0xC8, 0x93, 0x60,
  0x6F, 0x31, 0xFA, 0x33, 0x10, 0xAC, 0x08, 0x48, 0x4D, 0xB3, 0x4F, 0x83, 0x81, 0x1F, 0x72, 0x90,
  0x83, 0x81, 0x4F, 0x42, 0x98, 0x3A, 0x55, 0x38, 0x93, 0xC0, 0xC0,
  // "Ç" (U+00C7)
  0x28, 0xA2, 0x18, 0xDF, 0xEB, 0x50, 0x2E, 0xE7, 0x56, 0xA7, 0x0C, 0xD1, 0x58, 0x14, 0xF6, 0x68,
  0x19, 0xF1, 0x60, 0xB0, 0xD7, 0x0C, 0x0D, 0x70, 0xB0, 0xD7, 0x09, 0x97, 0x81, 0x5F, 0x57, 0x00,
  0xD7, 0x86, 0x3E, 0xD7, 0x56, 0x94, 0x28, 0x52, 0x9E, 0xFE, 0xB3, 0x40, 0x70, 0xC7, 0x81, 0x3A,
  0xD7, 0x81, 0x4F, 0x14, 0x82, 0x6F, 0xD6, 0x20,
  // "È" (U+00C8)
  0x28, 0x15, 0xF8, 0x78, 0x18, 0xF2, 0x70, 0x90, 0xC7, 0x50, 0x4F, 0x82, 0x44, 0xF8, 0x80, 0x15,
  0x82, 0x14, 0xF5, 0x68, 0x14, 0xF5, 0x68, 0x14, 0xF5, 0x68, 0x14, 0xF5, 0x80, 0x11, 0x10, 0x4E,
  0x83, 0xE0, 0x4F, 0x78, 0x01, 0x31, 0x81, 0x4F, 0x56, 0x81, 0x4F, 0x56, 0x81, 0x4F, 0x56, 0x81,
  0x4F, 0x88, 0x01, 0x50, 0x10, 0x4F, 0x04,
  // "É" (U+00C9)
  0x58, 0x12, 0xFC, 0x68, 0x1B, 0xD1, 0x58, 0x15, 0xD2, 0x74, 0x04, 0xF8, 0x24, 0x4F, 0x88, 0x01,
  0x58, 0x21, 0x4F, 0x56, 0x81, 0x4F, 0x56, 0x81, 0x4F, 0x56, 0x81, 0x4F, 0x58, 0x01, 0x11, 0x04,
  0xE8, 0x3E, 0x04, 0xF7, 0x80, 0x13, 0x18, 0x14, 0xF5, 0x68, 0x14, 0xF5, 0x68, 0x14, 0xF5, 0x68,
  0x14, 0xF8, 0x80, 0x15, 0x01, 0x04, 0xF0, 0x40,
  // "Ê" (U+00CA)
  0x48, 0x1B, 0xF8, 0x58, 0x38, 0xE7, 0xF4, 0x38, 0x55, 0xD2, 0x05, 0xE3, 0x72, 0x04, 0xF8, 0x24,
  0x4F, 0x88, 0x01, 0x58, 0x21, 0x4F, 0x56, 0x81, 0x4F, 0x56, 0x81, 0x4F, 0x56, 0x81, 0x4F, 0x58,
  0x01, 0x11, 0x04, 0xE8, 0x3E, 0x04, 0xF7, 0x80, 0x13, 0x18, 0x14, 0xF5, 0x68, 0x14, 0xF5, 0x68,
  0x14, 0xF5, 0x68, 0x14, 0xF8, 0x80, 0x15, 0x01, 0x04, 0xF0, 0x40,
  // "Ë" (U+00CB)
  0x28, 0x57, 0xF3, 0x05, 0xF5, 0x28, 0x56, 0xE2, 0x04, 0xE4, 0x72, 0x04, 0xF8, 0x24, 0x4F, 0x88,
  0x01, 0x58, 0x21, 0x4F, 0x56, 0x81, 0x4F, 0x56, 0x81, 0x4F, 0x56, 0x81, 0x4F, 0x58, 0x01, 0x11,
  0x04, 0xE8, 0x3E, 0x04, 0xF7, 0x80, 0x13, 0x18, 0x14, 0xF5, 0x68, 0x14, 0xF5, 0x68, 0x14, 0xF5,
  0x68, 0x14, 0xF8, 0x80, 0x15, 0x01, 0x04, 0xF0, 0x40,
  // "Ì" (U+00CC)
  0x81, 0x5F, 0x85, 0x81, 0x8F, 0x25, 0x09, 0x0C, 0x73, 0xE8, 0x6C, 0x46, 0xAF, 0x85, 0x32, 0x81,
  0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F,
  0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x22, 0x85, 0x23, 0x9F, 0x63, 0x1E, 0x0C,
  // "Í" (U+00CD)
  0x38, 0x12, 0xFC, 0x48, 0x1B, 0xD1, 0x38, 0x15, 0xD2, 0x72, 0xE8, 0x6C, 0x46, 0xAF, 0x85, 0x32,
  0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81,
  0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x22, 0x85, 0x23, 0x9F, 0x63, 0x1E,
  0x0C,
  // "Î" (U+00CE)
  0x28, 0x1B, 0xF8, 0x38, 0x93, 0x8E, 0x7F, 0x40, 0x5D, 0x20, 0x5E, 0x37, 0xE8, 0x6C, 0x46, 0xAF,
  0x85, 0x32, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F,
  0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x22, 0x85, 0x23, 0x9F,
  0x63, 0x1E, 0x0C,
  // "Ï" (U+00CF)
  0x89, 0x47, 0xF3, 0x05, 0xF5, 0x6E, 0x20, 0x4E, 0x47, 0xE8, 0x6C, 0x46, 0xAF, 0x85, 0x32, 0x81,
  0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F,
  0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x22, 0x85, 0x23, 0x9F, 0x63, 0x1E, 0x0C,
  // "Ð" (U+00D0)
  0x10, 0x8B, 0x81, 0xDA, 0x34, 0x86, 0x8F, 0x55, 0x7D, 0xF6, 0x38, 0x18, 0xF1, 0x38, 0x1A, 0xF3,
  0x28, 0x18, 0xF1, 0x38, 0x11, 0xEA, 0x28, 0x18, 0xF1, 0x48, 0x6A, 0xE0, 0x19, 0xF2, 0x13, 0x81,
  0x8F, 0x1D, 0x03, 0x28, 0x77, 0xF2, 0x3A, 0xF4, 0x31, 0x28, 0x58, 0xF1, 0x08, 0xF1, 0x40, 0xB0,
  0xE2, 0x81, 0x8F, 0x13, 0x81, 0x1F, 0xA2, 0x81, 0x8F, 0x13, 0x81, 0xBF, 0x32, 0x86, 0x8F, 0x55,
  0x8D, 0xF6, 0x30, 0x8B, 0x81, 0xD9, 0x23,
  // "Ñ" (U+00D1)
  0x18, 0x52, 0xDF, 0x82, 0x97, 0x28, 0x5A, 0x95, 0xDF, 0xE1, 0x20, 0x33, 0x02, 0x01, 0x28, 0x1B,
  0xF9, 0x49, 0x08, 0x0B, 0xA0, 0x13, 0x98, 0x38, 0xBB, 0xE7, 0x39, 0x83, 0x8B, 0xB9, 0xD3, 0x98,
  0x48, 0xBC, 0x2F, 0x52, 0x98, 0x48, 0xBC, 0x0B, 0xB2, 0x98, 0x92, 0x8B, 0xC0, 0x4F, 0x30, 0xF8,
  0xBC, 0x28, 0x5C, 0x90, 0xF8, 0xBC, 0x28, 0x56, 0xF1, 0xF8, 0xBC, 0x38, 0x4E, 0x7E, 0x8B, 0xC3,
  0x84, 0x8D, 0xE8, 0xBC, 0x30, 0x1A, 0x81, 0x8B, 0xC4, 0x81, 0x9F, 0x80,
  // "Ò" (U+00D2)
  0x28, 0x15, 0xF8, 0x71, 0x81, 0x8F, 0x27, 0x10, 0x90, 0xC7, 0x72, 0x84, 0x18, 0xDE, 0xD7, 0x48,
  0x5C, 0xE7, 0x58, 0xF9, 0x28, 0x16, 0xF4, 0x38, 0x47, 0xF3, 0x0C, 0xD4, 0x84, 0x1F, 0x90, 0xF9,
  0x58, 0x3C, 0xC1, 0xF7, 0x58, 0x3B, 0xE2, 0xF7, 0x58, 0x3A, 0xF1, 0xF7, 0x58, 0x3B, 0xE0, 0xF9,
  0x58, 0x3C, 0xC0, 0xCD, 0x48, 0x51, 0xF9, 0x06, 0xF4, 0x38, 0x17, 0xF3, 0x28, 0x5C, 0xE7, 0x58,
  0xF9, 0x38, 0x41, 0x8D, 0xED, 0x72,
  // "Ó" (U+00D3)
  0x58, 0x12, 0xFC, 0x78, 0x1B, 0xD1, 0x68, 0x15, 0xD2, 0x77, 0x18, 0x41, 0x8D, 0xED, 0x74, 0x85,
  0xCE, 0x75, 0x8F, 0x92, 0x81, 0x6F, 0x43, 0x84, 0x7F, 0x30, 0xCD, 0x48, 0x41, 0xF9, 0x0F, 0x95,
  0x83, 0xCC, 0x1F, 0x75, 0x83, 0xBE, 0x2F, 0x75, 0x83, 0xAF, 0x1F, 0x75, 0x83, 0xBE, 0x0F, 0x95,
  0x83, 0xCC, 0x0C, 0xD4, 0x85, 0x1F, 0x90, 0x6F, 0x43, 0x81, 0x7F, 0x32, 0x85, 0xCE, 0x75, 0x8F,
  0x93, 0x84, 0x18, 0xDE, 0xD7, 0x20,
  // "Ô" (U+00D4)
  0x48, 0x1B, 0xF8, 0x68, 0x38, 0xE7, 0xF4, 0x48, 0x55, 0xD2, 0x05, 0xE3, 0x76, 0x84, 0x18, 0xDE,
  0xD7, 0x48, 0x5C, 0xE7, 0x58, 0xF9, 0x28, 0x16, 0xF4, 0x38, 0x47, 0xF3, 0x0C, 0xD4, 0x84, 0x1F,
  0x90, 0xF9, 0x58, 0x3C, 0xC1, 0xF7, 0x58, 0x3B, 0xE2, 0xF7, 0x58, 0x3A, 0xF1, 0xF7, 0x58, 0x3B,
  0xE0, 0xF9, 0x58, 0x3C, 0xC0, 0xCD, 0x48, 0x51, 0xF9, 0x06, 0xF4, 0x38, 0x17, 0xF3, 0x28, 0x5C,
  0xE7, 0x58, 0xF9, 0x38, 0x41, 0x8D, 0xED, 0x72,
  // "Õ" (U+00D5)
  0x28, 0x52, 0xDF, 0x82, 0x97, 0x38, 0x5A, 0x95, 0xDF, 0xE1, 0x30, 0x33, 0x02, 0x01, 0x48, 0x41,
  0x8D, 0xED, 0x74, 0x85, 0xCE, 0x75, 0x8F, 0x92, 0x81, 0x6F, 0x43, 0x84, 0x7F, 0x30, 0xCD, 0x48,
  0x41, 0xF9, 0x0F, 0x95, 0x83, 0xCC, 0x1F, 0x75, 0x83, 0xBE, 0x2F, 0x75, 0x83, 0xAF, 0x1F, 0x75,
  0x83, 0xBE, 0x0F, 0x95, 0x83, 0xCC, 0x0C, 0xD4, 0x85, 0x1F, 0x90, 0x6F, 0x43, 0x81, 0x7F, 0x32,
  0x85, 0xCE, 0x75, 0x8F, 0x93, 0x84, 0x18, 0xDE, 0xD7, 0x20,
  // "Ö" (U+00D6)
  0x28, 0x57, 0xF3, 0x05, 0xF5, 0x38, 0x56, 0xE2, 0x04, 0xE4, 0x76, 0x84, 0x18, 0xDE, 0xD7, 0x48,
  0x5C, 0xE7, 0x58, 0xF9, 0x28, 0x16, 0xF4, 0x38, 0x47, 0xF3, 0x0C, 0xD4, 0x84, 0x1F, 0x90, 0xF9,
  0x58, 0x3C, 0xC1, 0xF7, 0x58, 0x3B, 0xE2, 0xF7, 0x58, 0x3A, 0xF1, 0xF7, 0x58, 0x3B, 0xE0, 0xF9,
  0x58, 0x3C, 0xC0, 0xCD, 0x48, 0x51, 0xF9, 0x06, 0xF4, 0x38, 0x17, 0xF3, 0x28, 0x5C, 0xE7, 0x58,
  0xF9, 0x38, 0x41, 0x8D, 0xED, 0x72,
  // "×" (U+00D7)
  0x81, 0x3E, 0x33, 0x89, 0x15, 0xE1, 0x09, 0xE3, 0x05, 0xF6, 0x38, 0x39, 0xE7, 0xF6, 0x58, 0x1B,
  0xF8, 0x58, 0x35, 0xFC, 0xE3, 0x38, 0x91, 0x5F, 0x60, 0xAE, 0x30, 0x3F, 0x73, 0x83, 0x9E, 0x10,
  0x45, 0x04, 0x10,
  // "Ø" (U+00D8)
  0x71, 0x02, 0x01, 0x28, 0x61, 0x8D, 0xED, 0x7C, 0xA2, 0x83, 0xCE, 0x75, 0x9A, 0x83, 0x20, 0x6F,
  0x43, 0x84, 0xEF, 0x30, 0xCD, 0x38, 0x57, 0xEF, 0x90, 0xF9, 0x28, 0x61, 0xF6, 0xCC, 0x1F, 0x72,
  0x8A, 0x3A, 0xD0, 0xBD, 0x2F, 0x70, 0x3F, 0x40, 0xAE, 0x2F, 0x80, 0xCA, 0x28, 0x6B, 0xE0, 0xF9,
  0x6F, 0x22, 0x85, 0xCC, 0x0D, 0xDE, 0x83, 0x98, 0x39, 0x07, 0xFE, 0x38, 0x92, 0x7F, 0x30, 0x3F,
  0xE8, 0x58, 0xF9, 0x28, 0x5B, 0xC9, 0xDF, 0xD7, 0x30, 0x02, 0x70,
  // "Ù" (U+00D9)
  0x18, 0x15, 0xF8, 0x78, 0x18, 0xF2, 0x70, 0x90, 0xC7, 0x60, 0xB0, 0xD4, 0x83, 0x1F, 0x8B, 0xD4,
  0x83, 0x1F, 0x8B, 0xD4, 0x83, 0x1F, 0x8B, 0xD4, 0x83, 0x1F, 0x8B, 0xD4, 0x83, 0x1F, 0x8B, 0xD4,
  0x83, 0x1F, 0x8B, 0xD4, 0x83, 0x1F, 0x8B, 0xD4, 0x83, 0x1F, 0x8B, 0xE4, 0x82, 0x1F, 0x89, 0x94,
  0x84, 0x3F, 0x66, 0xF4, 0x38, 0x91, 0x7F, 0x20, 0xDE, 0x75, 0x8F, 0xA2, 0x84, 0x19, 0xEF, 0xD8,
  0x20,
  // "Ú" (U+00DA)
  0x48, 0x12, 0xFC, 0x68, 0x1B, 0xD1, 0x58, 0x15, 0xD2, 0x75, 0x0B, 0x0D, 0x48, 0x31, 0xF8, 0xBD,
  0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31, 0xF8, 0xBD,
  0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31, 0xF8, 0xBE, 0x48, 0x21, 0xF8, 0x99,
  0x48, 0x43, 0xF6, 0x6F, 0x43, 0x89, 0x17, 0xF2, 0x0D, 0xE7, 0x58, 0xFA, 0x28, 0x41, 0x9E, 0xFD,
  0x82,
  // "Û" (U+00DB)
  0x38, 0x1B, 0xF8, 0x58, 0x38, 0xE7, 0xF4, 0x38, 0x55, 0xD2, 0x05, 0xE3, 0x73, 0x0B, 0x0D, 0x48,
  0x31, 0xF8, 0xBD, 0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31, 0xF8, 0xBD, 0x48,
  0x31, 0xF8, 0xBD, 0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31, 0xF8, 0xBE, 0x48,
  0x21, 0xF8, 0x99, 0x48, 0x43, 0xF6, 0x6F, 0x43, 0x89, 0x17, 0xF2, 0x0D, 0xE7, 0x58, 0xFA, 0x28,
  0x41, 0x9E, 0xFD, 0x82,
  // "Ü" (U+00DC)
  0x18, 0x57, 0xF3, 0x05, 0xF5, 0x28, 0x56, 0xE2, 0x04, 0xE4, 0x73, 0x0B, 0x0D, 0x48, 0x31, 0xF8,
  0xBD, 0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31, 0xF8,
  0xBD, 0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31, 0xF8, 0xBE, 0x48, 0x21, 0xF8,
  0x99, 0x48, 0x43, 0xF6, 0x6F, 0x43, 0x89, 0x17, 0xF2, 0x0D, 0xE7, 0x58, 0xFA, 0x28, 0x41, 0x9E,
  0xFD, 0x82,
  // "Ý" (U+00DD)
  0x58, 0x12, 0xFC, 0x78, 0x1B, 0xD1, 0x68, 0x15, 0xD2, 0x76, 0x81, 0x2F, 0x95, 0x84, 0xCD, 0x09,
  0xF1, 0x38, 0x53, 0xF6, 0x02, 0xF8, 0x30, 0xA0, 0xD3, 0x09, 0x0E, 0x28, 0x12, 0xF6, 0x38, 0x42,
  0xF7, 0x09, 0xD5, 0x83, 0x9D, 0x1F, 0x65, 0x82, 0x2F, 0xCD, 0x78, 0x19, 0xF6, 0x78, 0x15, 0xF2,
  0x78, 0x15, 0xF2, 0x78, 0x15, 0xF2, 0x78, 0x15, 0xF2, 0x78, 0x15, 0xF2, 0x30,
  // "Þ" (U+00DE)
  0x81, 0x4F, 0x56, 0x83, 0x4F, 0x51, 0x14, 0x04, 0xD8, 0x95, 0xB3, 0x04, 0xF7, 0x34, 0x7E, 0xF2,
  0x4F, 0x53, 0x84, 0x3F, 0x94, 0xF5, 0x48, 0x3E, 0xC4, 0xF5, 0x48, 0x3E, 0xB4, 0xF5, 0x38, 0x93,
  0x2F, 0x84, 0xF5, 0x12, 0x5D, 0xE1, 0x4D, 0x87, 0xC3, 0x04, 0xF7, 0x33, 0x13, 0x81, 0x4F, 0x56,
  0x81, 0x4F, 0x56,
  // "ß" (U+00DF)
  0x18, 0x53, 0xBE, 0xFD, 0x91, 0x28, 0x62, 0xFD, 0x75, 0x8E, 0xD2, 0x81, 0x8F, 0x13, 0x84, 0x8F,
  0x20, 0xAE, 0x40, 0xB0, 0xE2, 0x0A, 0x0E, 0x38, 0x1A, 0xF5, 0x20, 0xA0, 0xE2, 0x81, 0x8F, 0x43,
  0x0A, 0x0E, 0x20, 0xC0, 0xB4, 0x0A, 0x0E, 0x28, 0x18, 0xF8, 0x30, 0xA0, 0xE3, 0x85, 0x8F, 0xC1,
  0x0A, 0xE4, 0x84, 0x4E, 0xC0, 0xAE, 0x58, 0x35, 0xF4, 0xAE, 0x58, 0xA4, 0x5F, 0x4A, 0xE0, 0x89,
  0x66, 0xDE, 0x1A, 0xE0, 0x4C, 0xEE, 0xB3, 0x10,
  // "à" (U+00E0)
  0x18, 0x15, 0xF8, 0x78, 0x18, 0xF2, 0x70, 0x90, 0xC7, 0x78, 0x45, 0xBE, 0xFD, 0x83, 0x85, 0xBA,
  0x65, 0x8F, 0xA7, 0x08, 0x96, 0x86, 0x15, 0xF2, 0x04, 0xBE, 0xC8, 0x92, 0x24, 0xFC, 0x64, 0x37,
  0xF2, 0xAE, 0x48, 0x35, 0xF2, 0xAD, 0x48, 0xA3, 0xBF, 0x26, 0xF9, 0x56, 0xCC, 0xF2, 0x07, 0xDF,
  0xD7, 0x2F, 0x20,
  // "á" (U+00E1)
  0x48, 0x12, 0xFC, 0x68, 0x1B, 0xD1, 0x58, 0x15, 0xD2, 0x76, 0x84, 0x5B, 0xEF, 0xD8, 0x38, 0x5B,
  0xA6, 0x58, 0xFA, 0x70, 0x89, 0x68, 0x61, 0x5F, 0x20, 0x4B, 0xEC, 0x89, 0x22, 0x4F, 0xC6, 0x43,
  0x7F, 0x2A, 0xE4, 0x83, 0x5F, 0x2A, 0xD4, 0x8A, 0x3B, 0xF2, 0x6F, 0x95, 0x6C, 0xCF, 0x20, 0x7D,
  0xFD, 0x72, 0xF2,
  // "â" (U+00E2)
  0x38, 0x1B, 0xF8, 0x58, 0x38, 0xE7, 0xF4, 0x38, 0x55, 0xD2, 0x05, 0xE3, 0x74, 0x84, 0x5B, 0xEF,
  0xD8, 0x38, 0x5B, 0xA6, 0x58, 0xFA, 0x70, 0x89, 0x68, 0x61, 0x5F, 0x20, 0x4B, 0xEC, 0x89, 0x22,
  0x4F, 0xC6, 0x43, 0x7F, 0x2A, 0xE4, 0x83, 0x5F, 0x2A, 0xD4, 0x8A, 0x3B, 0xF2, 0x6F, 0x95, 0x6C,
  0xCF, 0x20, 0x7D, 0xFD, 0x72, 0xF2,
  // "ã" (U+00E3)
  0x18, 0x52, 0xDF, 0x82, 0x97, 0x28, 0x5A, 0x95, 0xDF, 0xE1, 0x20, 0x33, 0x02, 0x01, 0x38, 0x45,
  0xBE, 0xFD, 0x83, 0x85, 0xBA, 0x65, 0x8F, 0xA7, 0x08, 0x96, 0x86, 0x15, 0xF2, 0x04, 0xBE, 0xC8,
  0x92, 0x24, 0xFC, 0x64, 0x37, 0xF2, 0xAE, 0x48, 0x35, 0xF2, 0xAD, 0x48, 0xA3, 0xBF, 0x26, 0xF9,
  0x56, 0xCC, 0xF2, 0x07, 0xDF, 0xD7, 0x2F, 0x20,
  // "ä" (U+00E4)
  0x18, 0x57, 0xF3, 0x05, 0xF5, 0x28, 0x56, 0xE2, 0x04, 0xE4, 0x74, 0x84, 0x5B, 0xEF, 0xD8, 0x38,
  0x5B, 0xA6, 0x58, 0xFA, 0x70, 0x89, 0x68, 0x61, 0x5F, 0x20, 0x4B, 0xEC, 0x89, 0x22, 0x4F, 0xC6,
  0x43, 0x7F, 0x2A, 0xE4, 0x83, 0x5F, 0x2A, 0xD4, 0x8A, 0x3B, 0xF2, 0x6F, 0x95, 0x6C, 0xCF, 0x20,
  0x7D, 0xFD, 0x72, 0xF2,
  // "å" (U+00E5)
  0x28, 0x21, 0xDF, 0xA5, 0x83, 0x7B, 0x5D, 0x44, 0x83, 0x79, 0x2C, 0x44, 0x82, 0x2E, 0xFC, 0x60,
  0x10, 0x35, 0x84, 0x5B, 0xEF, 0xD8, 0x38, 0x5B, 0xA6, 0x58, 0xFA, 0x70, 0x89, 0x68, 0x61, 0x5F,
  0x20, 0x4B, 0xEC, 0x89, 0x22, 0x4F, 0xC6, 0x43, 0x7F, 0x2A, 0xE4, 0x83, 0x5F, 0x2A, 0xD4, 0x8A,
  0x3B, 0xF2, 0x6F, 0x95, 0x6C, 0xCF, 0x20, 0x7D, 0xFD, 0x72, 0xF2,
  // "æ" (U+00E6)
  0x18, 0x76, 0xCE, 0xB1, 0x9E, 0xD3, 0x28, 0x79, 0x76, 0xDD, 0xD6, 0xBD, 0x58, 0x57, 0xF5, 0x03,
  0xF3, 0x38, 0x91, 0x16, 0xF3, 0x12, 0xF5, 0x07, 0xEF, 0x89, 0x46, 0x4F, 0x94, 0x8F, 0x43, 0x33,
  0x18, 0xD2, 0x81, 0x6F, 0x24, 0x09, 0x0D, 0x28, 0x19, 0xF6, 0x48, 0xA4, 0x5F, 0x78, 0xE8, 0xF7,
  0x6A, 0x30, 0x9E, 0xD4, 0x08, 0xEE, 0xB1,
  // "ç" (U+00E7)
  0x28, 0x97, 0x4B, 0xEE, 0xD8, 0x06, 0xFC, 0x75, 0x7A, 0x0E, 0xC5, 0x81, 0x4F, 0x65, 0x81, 0x6F,
  0x35, 0x81, 0x6F, 0x35, 0x81, 0x5F, 0x55, 0x81, 0x1F, 0xB6, 0x85, 0x8F, 0xC6, 0x57, 0xB2, 0x05,
  0x0C, 0xA0, 0xD0, 0x94, 0x07, 0x0C, 0x68, 0x13, 0xAD, 0x68, 0x14, 0xF1, 0x38, 0x26, 0xFD, 0x61,
  // "è" (U+00E8)
  0x18, 0x15, 0xF8, 0x78, 0x18, 0xF2, 0x70, 0x90, 0xC7, 0x71, 0x84, 0x7D, 0xFE, 0x91, 0x28, 0x91,
  0xBF, 0x95, 0x7E, 0xC0, 0x5F, 0x53, 0x83, 0x4F, 0x5B, 0xE8, 0x01, 0x19, 0x09, 0x0D, 0xF8, 0x1B,
  0xDC, 0x80, 0x23, 0x81, 0x2B, 0xE7, 0x81, 0x6F, 0x67, 0x86, 0xBF, 0x96, 0x58, 0xC4, 0x28, 0x56,
  0xCE, 0xED, 0x91,
  // "é" (U+00E9)
  0x48, 0x12, 0xFC, 0x68, 0x1B, 0xD1, 0x58, 0x15, 0xD2, 0x77, 0x84, 0x7D, 0xFE, 0x91, 0x28, 0x91,
  0xBF, 0x95, 0x7E, 0xC0, 0x5F, 0x53, 0x83, 0x4F, 0x5B, 0xE8, 0x01, 0x19, 0x09, 0x0D, 0xF8, 0x1B,
  0xDC, 0x80, 0x23, 0x81, 0x2B, 0xE7, 0x81, 0x6F, 0x67, 0x86, 0xBF, 0x96, 0x58, 0xC4, 0x28, 0x56,
  0xCE, 0xED, 0x91,
  // "ê" (U+00EA)
  0x38, 0x1B, 0xF8, 0x58, 0x38, 0xE7, 0xF4, 0x38, 0x55, 0xD2, 0x05, 0xE3, 0x75, 0x84, 0x7D, 0xFE,
  0x91, 0x28, 0x91, 0xBF, 0x95, 0x7E, 0xC0, 0x5F, 0x53, 0x83, 0x4F, 0x5B, 0xE8, 0x01, 0x19, 0x09,
  0x0D, 0xF8, 0x1B, 0xDC, 0x80, 0x23, 0x81, 0x2B, 0xE7, 0x81, 0x6F, 0x67, 0x86, 0xBF, 0x96, 0x58,
  0xC4, 0x28, 0x56, 0xCE, 0xED, 0x91,
  // "ë" (U+00EB)
  0x18, 0x57, 0xF3, 0x05, 0xF5, 0x28, 0x56, 0xE2, 0x04, 0xE4, 0x75, 0x84, 0x7D, 0xFE, 0x91, 0x28,
  0x91, 0xBF, 0x95, 0x7E, 0xC0, 0x5F, 0x53, 0x83, 0x4F, 0x5B, 0xE8, 0x01, 0x19, 0x09, 0x0D, 0xF8,
  0x1B, 0xDC, 0x80, 0x23, 0x81, 0x2B, 0xE7, 0x81, 0x6F, 0x67, 0x86, 0xBF, 0x96, 0x58, 0xC4, 0x28,
  0x56, 0xCE, 0xED, 0x91,
  // "ì" (U+00EC)
  0x18, 0x15, 0xF8, 0x78, 0x18, 0xF2, 0x70, 0x90, 0xC7, 0x60, 0x4C, 0x07, 0x48, 0x33, 0x57, 0xF7,
  0x68, 0x11, 0xF7, 0x68, 0x11, 0xF7, 0x68, 0x11, 0xF7, 0x68, 0x11, 0xF7, 0x68, 0x11, 0xF7, 0x68,
  0x11, 0xF7, 0x38, 0x90, 0x12, 0x46, 0xFA, 0x43, 0x18, 0xF0, 0xB0,
  // "í" (U+00ED)
  0x48, 0x12, 0xFC, 0x68, 0x1B, 0xD1, 0x58, 0x15, 0xD2, 0x75, 0x04, 0xC0, 0x74, 0x83, 0x35, 0x7F,
  0x76, 0x81, 0x1F, 0x76, 0x81, 0x1F, 0x76, 0x81, 0x1F, 0x76, 0x81, 0x1F, 0x76, 0x81, 0x1F, 0x76,
  0x81, 0x1F, 0x73, 0x89, 0x01, 0x24, 0x6F, 0xA4, 0x31, 0x8F, 0x0B,
  // "î" (U+00EE)
  0x38, 0x1B, 0xF8, 0x58, 0x38, 0xE7, 0xF4, 0x38, 0x55, 0xD2, 0x05, 0xE3, 0x73, 0x04, 0xC0, 0x74,
  0x83, 0x35, 0x7F, 0x76, 0x81, 0x1F, 0x76, 0x81, 0x1F, 0x76, 0x81, 0x1F, 0x76, 0x81, 0x1F, 0x76,
  0x81, 0x1F, 0x76, 0x81, 0x1F, 0x73, 0x89, 0x01, 0x24, 0x6F, 0xA4, 0x31, 0x8F, 0x0B,
  // "ï" (U+00EF)
  0x18, 0x57, 0xF3, 0x05, 0xF5, 0x28, 0x56, 0xE2, 0x04, 0xE4, 0x73, 0x04, 0xC0, 0x74, 0x83, 0x35,
  0x7F, 0x76, 0x81, 0x1F, 0x76, 0x81, 0x1F, 0x76, 0x81, 0x1F, 0x76, 0x81, 0x1F, 0x76, 0x81, 0x1F,
  0x76, 0x81, 0x1F, 0x73, 0x89, 0x01, 0x24, 0x6F, 0xA4, 0x31, 0x8F, 0x0B,
  // "ð" (U+00F0)
  0x20, 0x01, 0x30, 0x13, 0x84, 0x8E, 0x65, 0xDA, 0x40, 0x9A, 0x07, 0x48, 0x38, 0xFA, 0xF8, 0x48,
  0x48, 0x30, 0x5F, 0x47, 0x09, 0x0C, 0x20, 0x30, 0xBA, 0x89, 0x6E, 0x8F, 0x32, 0xED, 0x64, 0x7E,
  0xF8, 0xAF, 0x13, 0x83, 0x3F, 0xAE, 0xB5, 0x82, 0xDC, 0xF9, 0x58, 0x2D, 0xBD, 0xB5, 0x83, 0xE9,
  0x9F, 0x23, 0x89, 0x15, 0xF4, 0x1D, 0xE7, 0x58, 0xFB, 0x28, 0x41, 0x9D, 0xFD, 0x72,
  // "ñ" (U+00F1)
  0x28, 0x52, 0xDF, 0x82, 0x97, 0x28, 0x5A, 0x95, 0xDF, 0xE1, 0x20, 0x33, 0x8A, 0x62, 0x10, 0x8C,
  0x1A, 0xEE, 0xB3, 0x08, 0xEC, 0x95, 0x7E, 0xE1, 0x8F, 0x93, 0x84, 0x6F, 0x48, 0xF3, 0x38, 0x43,
  0xF6, 0x8F, 0x13, 0x84, 0x2F, 0x78, 0xF1, 0x38, 0x42, 0xF7, 0x8F, 0x13, 0x84, 0x2F, 0x78, 0xF1,
  0x38, 0x42, 0xF7, 0x8F, 0x13, 0x84, 0x2F, 0x78, 0xF1, 0x38, 0x12, 0xF7,
  // "ò" (U+00F2)
  0x18, 0x15, 0xF8, 0x78, 0x18, 0xF2, 0x70, 0x90, 0xC7, 0x78, 0x41, 0x9D, 0xFD, 0x72, 0x89, 0x21,
  0xDE, 0x75, 0x9F, 0xA0, 0x8F, 0x33, 0x83, 0x7F, 0x4D, 0xC5, 0x98, 0x19, 0xFA, 0x58, 0x2D, 0xBF,
  0xA5, 0x82, 0xDB, 0xDC, 0x59, 0x82, 0xA8, 0xF3, 0x38, 0x91, 0x7F, 0x50, 0xDE, 0x85, 0x9F, 0xB2,
  0x84, 0x19, 0xDF, 0xD7, 0x20,
  // "ó" (U+00F3)
  0x48, 0x12, 0xFC, 0x68, 0x1B, 0xD1, 0x58, 0x15, 0xD2, 0x76, 0x84, 0x19, 0xDF, 0xD7, 0x28, 0x92,
  0x1D, 0xE7, 0x59, 0xFA, 0x08, 0xF3, 0x38, 0x37, 0xF4, 0xDC, 0x59, 0x81, 0x9F, 0xA5, 0x82, 0xDB,
  0xFA, 0x58, 0x2D, 0xBD, 0xC5, 0x98, 0x2A, 0x8F, 0x33, 0x89, 0x17, 0xF5, 0x0D, 0xE8, 0x59, 0xFB,
  0x28, 0x41, 0x9D, 0xFD, 0x72,
  // "ô" (U+00F4)
  0x38, 0x1B, 0xF8, 0x58, 0x38, 0xE7, 0xF4, 0x38, 0x55, 0xD2, 0x05, 0xE3, 0x74, 0x84, 0x19, 0xDF,
  0xD7, 0x28, 0x92, 0x1D, 0xE7, 0x59, 0xFA, 0x08, 0xF3, 0x38, 0x37, 0xF4, 0xDC, 0x59, 0x81, 0x9F,
  0xA5, 0x82, 0xDB, 0xFA, 0x58, 0x2D, 0xBD, 0xC5, 0x98, 0x2A, 0x8F, 0x33, 0x89, 0x17, 0xF5, 0x0D,
  0xE8, 0x59, 0xFB, 0x28, 0x41, 0x9D, 0xFD, 0x72,
  // "õ" (U+00F5)
  0x18, 0x52, 0xDF, 0x82, 0x97, 0x28, 0x5A, 0x95, 0xDF, 0xE1, 0x20, 0x33, 0x02, 0x01, 0x38, 0x41,
  0x9D, 0xFD, 0x72, 0x89, 0x21, 0xDE, 0x75, 0x9F, 0xA0, 0x8F, 0x33, 0x83, 0x7F, 0x4D, 0xC5, 0x98,
  0x19, 0xFA, 0x58, 0x2D, 0xBF, 0xA5, 0x82, 0xDB, 0xDC, 0x59, 0x82, 0xA8, 0xF3, 0x38, 0x91, 0x7F,
  0x50, 0xDE, 0x85, 0x9F, 0xB2, 0x84, 0x19, 0xDF, 0xD7, 0x20,
  // "ö" (U+00F6)
  0x18, 0x57, 0xF3, 0x05, 0xF5, 0x28, 0x56, 0xE2, 0x04, 0xE4, 0x74, 0x84, 0x19, 0xDF, 0xD7, 0x28,
  0x92, 0x1D, 0xE7, 0x59, 0xFA, 0x08, 0xF3, 0x38, 0x37, 0xF4, 0xDC, 0x59, 0x81, 0x9F, 0xA5, 0x82,
  0xDB, 0xFA, 0x58, 0x2D, 0xBD, 0xC5, 0x98, 0x2A, 0x8F, 0x33, 0x89, 0x17, 0xF5, 0x0D, 0xE8, 0x59,
  0xFB, 0x28, 0x41, 0x9D, 0xFD, 0x72,
  // "÷" (U+00F7)
  0x40, 0x17, 0x81, 0x7F, 0x46, 0x81, 0x6E, 0x34, 0x80, 0x31, 0x10, 0x8F, 0x05, 0x02, 0x80, 0x33,
  0x01, 0x40, 0x17, 0x81, 0x7F, 0x46, 0x81, 0x6E, 0x33,
  // "ø" (U+00F8)
  0x70, 0x22, 0x8A, 0x21, 0x9D, 0xFD, 0x8E, 0x51, 0xDE, 0x75, 0x9F, 0xE0, 0x8F, 0x32, 0x07, 0xA8,
  0x14, 0xDC, 0x28, 0x53, 0xF6, 0xF9, 0xFA, 0x28, 0x90, 0xDA, 0x0D, 0xBF, 0x90, 0x9D, 0x28, 0x5D,
  0xBD, 0xC5, 0xF3, 0x29, 0x83, 0xA8, 0xFE, 0x72, 0x82, 0x7F, 0x51, 0xA8, 0x93, 0x75, 0x9F, 0xB0,
  0x6E, 0x9D, 0xFD, 0x73, 0x02, 0x70,
  // "ù" (U+00F9)
  0x18, 0x15, 0xF8, 0x78, 0x18, 0xF2, 0x70, 0x90, 0xC7, 0x60, 0xA9, 0x48, 0x24, 0xF5, 0xA9, 0x48,
  0x24, 0xF5, 0xA9, 0x48, 0x24, 0xF5, 0xA9, 0x48, 0x24, 0xF5, 0xA9, 0x48, 0x24, 0xF5, 0xA9, 0x48,
  0x24, 0xF5, 0x99, 0x48, 0x46, 0xF5, 0x8F, 0x23, 0x8A, 0x3C, 0xF5, 0x3F, 0xD6, 0x6B, 0xDF, 0x50,
  0x5C, 0xEE, 0x91, 0xF5,
  // "ú" (U+00FA)
  0x48, 0x12, 0xFC, 0x68, 0x1B, 0xD1, 0x58, 0x15, 0xD2, 0x75, 0x0A, 0x94, 0x82, 0x4F, 0x5A, 0x94,
  0x82, 0x4F, 0x5A, 0x94, 0x82, 0x4F, 0x5A, 0x94, 0x82, 0x4F, 0x5A, 0x94, 0x82, 0x4F, 0x5A, 0x94,
  0x82, 0x4F, 0x59, 0x94, 0x84, 0x6F, 0x58, 0xF2, 0x38, 0xA3, 0xCF, 0x53, 0xFD, 0x66, 0xBD, 0xF5,
  0x05, 0xCE, 0xE9, 0x1F, 0x50,
  // "û" (U+00FB)
  0x38, 0x1B, 0xF8, 0x58, 0x38, 0xE7, 0xF4, 0x38, 0x55, 0xD2, 0x05, 0xE3, 0x73, 0x0A, 0x94, 0x82,
  0x4F, 0x5A, 0x94, 0x82, 0x4F, 0x5A, 0x94, 0x82, 0x4F, 0x5A, 0x94, 0x82, 0x4F, 0x5A, 0x94, 0x82,
  0x4F, 0x5A, 0x94, 0x82, 0x4F, 0x59, 0x94, 0x84, 0x6F, 0x58, 0xF2, 0x38, 0xA3, 0xCF, 0x53, 0xFD,
  0x66, 0xBD, 0xF5, 0x05, 0xCE, 0xE9, 0x1F, 0x50,
  // "ü" (U+00FC)
  0x18, 0x57, 0xF3, 0x05, 0xF5, 0x28, 0x56, 0xE2, 0x04, 0xE4, 0x73, 0x0A, 0x94, 0x82, 0x4F, 0x5A,
  0x94, 0x82, 0x4F, 0x5A, 0x94, 0x82, 0x4F, 0x5A, 0x94, 0x82, 0x4F, 0x5A, 0x94, 0x82, 0x4F, 0x5A,
  0x94, 0x82, 0x4F, 0x59, 0x94, 0x84, 0x6F, 0x58, 0xF2, 0x38, 0xA3, 0xCF, 0x53, 0xFD, 0x66, 0xBD,
  0xF5, 0x05, 0xCE, 0xE9, 0x1F, 0x50,
  // "ý" (U+00FD)
  0x48, 0x12, 0xFC, 0x68, 0x1B, 0xD1, 0x58, 0x15, 0xD2, 0x75, 0x0E, 0x09, 0x58, 0x2D, 0xC8, 0xE4,
  0x84, 0x3F, 0x62, 0xF6, 0x38, 0x48, 0xF1, 0x0B, 0xC3, 0x0D, 0x0A, 0x28, 0x54, 0xF3, 0x03, 0xF4,
  0x38, 0x3D, 0x90, 0x8E, 0x48, 0x37, 0xE0, 0xD8, 0x48, 0x31, 0xF7, 0xF2, 0x58, 0x1A, 0xFC, 0x68,
  0x14, 0xF6, 0x68, 0x17, 0xF1, 0x60, 0xD0, 0x94, 0x83, 0x45, 0xBF, 0x24, 0x82, 0xCF, 0xD4, 0x50,
  // "þ" (U+00FE)
  0x08, 0x97, 0x08, 0x97, 0x08, 0x97, 0x08, 0x97, 0x8A, 0x38, 0xF2, 0xBE, 0xEA, 0x10, 0x8F, 0xD9,
  0x58, 0xFD, 0x08, 0xF8, 0x38, 0x45, 0xF6, 0x8F, 0x24, 0x98, 0x2A, 0x8F, 0x14, 0x83, 0xDC, 0x8F,
  0x14, 0x83, 0xDC, 0x8F, 0x34, 0x98, 0x2A, 0x8F, 0x83, 0x8A, 0x45, 0xF6, 0x8F, 0xD9, 0x58, 0xFD,
  0x08, 0xF2, 0xBE, 0xEA, 0x10, 0x89, 0x70, 0x89, 0x70, 0x89, 0x70, 0x89, 0x70,
  // "ÿ" (U+00FF)
  0x18, 0x57, 0xF3, 0x05, 0xF5, 0x28, 0x56, 0xE2, 0x04, 0xE4, 0x73, 0x0E, 0x09, 0x58, 0x2D, 0xC8,
  0xE4, 0x84, 0x3F, 0x62, 0xF6, 0x38, 0x48, 0xF1, 0x0B, 0xC3, 0x0D, 0x0A, 0x28, 0x54, 0xF3, 0x03,
  0xF4, 0x38, 0x3D, 0x90, 0x8E, 0x48, 0x37, 0xE0, 0xD8, 0x48, 0x31, 0xF7, 0xF2, 0x58, 0x1A, 0xFC,
  0x68, 0x14, 0xF6, 0x68, 0x17, 0xF1, 0x60, 0xD0, 0x94, 0x83, 0x45, 0xBF, 0x24, 0x82, 0xCF, 0xD4,
  0x50,
  // "Ā" (U+0100)
  0x38, 0x01, 0x15, 0x04, 0xD0, 0x14, 0x01, 0x80, 0x13, 0x77, 0x48, 0x19, 0xF6, 0x71, 0x81, 0xEF,
  0xB7, 0x83, 0x4F, 0xAF, 0x16, 0x83, 0x9E, 0x3F, 0x56, 0x83, 0xEA, 0x0D, 0xA5, 0x83, 0x3F, 0x50,
  0x99, 0x58, 0x58, 0xF1, 0x04, 0xF5, 0x48, 0x5D, 0xC2, 0x22, 0xFA, 0x30, 0x3E, 0x0E, 0x38, 0x78,
  0xF6, 0x55, 0x58, 0xF4, 0x20, 0xD0, 0xC4, 0x85, 0x1F, 0x90, 0x2F, 0x75, 0x84, 0xBE, 0x07, 0xF2,
  0x58, 0x15, 0xF4,
  // "ā" (U+0101)
  0x28, 0x01, 0x13, 0x04, 0xD0, 0x12, 0x01, 0x80, 0x13, 0x75, 0x84, 0x5B, 0xEF, 0xD8, 0x38, 0x5B,
  0xA6, 0x58, 0xFA, 0x70, 0x89, 0x68, 0x61, 0x5F, 0x20, 0x4B, 0xEC, 0x89, 0x22, 0x4F, 0xC6, 0x43,
  0x7F, 0x2A, 0xE4, 0x83, 0x5F, 0x2A, 0xD4, 0x8A, 0x3B, 0xF2, 0x6F, 0x95, 0x6C, 0xCF, 0x20, 0x7D,
  0xFD, 0x72, 0xF2,
  // "Ă" (U+0102)
  0x20, 0x10, 0x23, 0x03, 0x58, 0x33, 0xE4, 0x16, 0x96, 0x09, 0xB0, 0x67, 0x81, 0x13, 0x17, 0x18,
  0x19, 0xF6, 0x71, 0x81, 0xEF, 0xB7, 0x83, 0x4F, 0xAF, 0x16, 0x83, 0x9E, 0x3F, 0x56, 0x83, 0xEA,
  0x0D, 0xA5, 0x83, 0x3F, 0x50, 0x99, 0x58, 0x58, 0xF1, 0x04, 0xF5, 0x48, 0x5D, 0xC2, 0x22, 0xFA,
  0x30, 0x3E, 0x0E, 0x38, 0x78, 0xF6, 0x55, 0x58, 0xF4, 0x20, 0xD0, 0xC4, 0x85, 0x1F, 0x90, 0x2F,
  0x75, 0x84, 0xBE, 0x07, 0xF2, 0x58, 0x15, 0xF4,
  // "ă" (U+0103)
  0x10, 0x10, 0x23, 0x03, 0x38, 0x33, 0xE4, 0x16, 0x94, 0x09, 0xB0, 0x65, 0x81, 0x13, 0x14, 0x84,
  0x5B, 0xEF, 0xD8, 0x38, 0x5B, 0xA6, 0x58, 0xFA, 0x70, 0x89, 0x68, 0x61, 0x5F, 0x20, 0x4B, 0xEC,
  0x89, 0x22, 0x4F, 0xC6, 0x43, 0x7F, 0x2A, 0xE4, 0x83, 0x5F, 0x2A, 0xD4, 0x8A, 0x3B, 0xF2, 0x6F,
  0x95, 0x6C, 0xCF, 0x20, 0x7D, 0xFD, 0x72, 0xF2,
  // "Ą" (U+0104)
  0x48, 0x19, 0xF6, 0x71, 0x81, 0xEF, 0xB7, 0x83, 0x4F, 0xAF, 0x16, 0x83, 0x9E, 0x3F, 0x56, 0x83,
  0xEA, 0x0D, 0xA5, 0x83, 0x3F, 0x50, 0x99, 0x58, 0x58, 0xF1, 0x04, 0xF5, 0x48, 0x5D, 0xC2, 0x22,
  0xFA, 0x30, 0x3E, 0x0E, 0x38, 0x78, 0xF6, 0x55, 0x58, 0xF4, 0x20, 0xD0, 0xC4, 0x85, 0x1F, 0x90,
  0x2F, 0x75, 0x84, 0xBE, 0x07, 0xF2, 0x58, 0x15, 0xF4, 0x71, 0x81, 0x2D, 0x27, 0x10, 0xB0, 0x67,
  0x29, 0x07, 0x01, 0x71, 0x81, 0xBF, 0xE7, 0x20, 0x30, 0x20,
  // "ą" (U+0105)
  0x18, 0x45, 0xBE, 0xFD, 0x83, 0x85, 0xBA, 0x65, 0x8F, 0xA7, 0x08, 0x96, 0x86, 0x15, 0xF2, 0x04,
  0xBE, 0xC8, 0x92, 0x24, 0xFC, 0x64, 0x37, 0xF2, 0xAE, 0x48, 0x35, 0xF2, 0xAD, 0x48, 0xA3, 0xBF,
  0x26, 0xF9, 0x56, 0xCC, 0xF2, 0x07, 0xDF, 0xD7, 0x2F, 0x36, 0x81, 0x2D, 0x26, 0x0B, 0x06, 0x79,
  0x07, 0x01, 0x68, 0x1B, 0xFE, 0x70, 0x30, 0x20,
  // "Ć" (U+0106)
  0x58, 0x12, 0xFC, 0x68, 0x1B, 0xD1, 0x58, 0x15, 0xD2, 0x76, 0x8A, 0x21, 0x8D, 0xFE, 0xB5, 0x02,
  0xEE, 0x75, 0x6A, 0x70, 0xCD, 0x15, 0x81, 0x4F, 0x66, 0x81, 0x9F, 0x16, 0x0B, 0x0D, 0x70, 0xC0,
  0xD7, 0x0B, 0x0D, 0x70, 0x99, 0x78, 0x15, 0xF5, 0x70, 0x0D, 0x78, 0x63, 0xED, 0x75, 0x69, 0x42,
  0x85, 0x29, 0xDF, 0xEB, 0x30,
  // "ć" (U+0107)
  0x58, 0x12, 0xFC, 0x58, 0x1B, 0xD1, 0x48, 0x15, 0xD2, 0x74, 0x89, 0x74, 0xBE, 0xED, 0x80, 0x6F,
  0xC7, 0x57, 0xA0, 0xEC, 0x58, 0x14, 0xF6, 0x58, 0x16, 0xF3, 0x58, 0x16, 0xF3, 0x58, 0x15, 0xF5,
  0x58, 0x11, 0xFB, 0x68, 0x58, 0xFC, 0x65, 0x7B, 0x28, 0x45, 0xCE, 0xFD, 0x90,
  // "Ĉ" (U+0108)
  0x48, 0x1B, 0xF8, 0x58, 0x38, 0xE7, 0xF4, 0x38, 0x55, 0xD2, 0x05, 0xE3, 0x74, 0x8A, 0x21, 0x8D,
  0xFE, 0xB5, 0x02, 0xEE, 0x75, 0x6A, 0x70, 0xCD, 0x15, 0x81, 0x4F, 0x66, 0x81, 0x9F, 0x16, 0x0B,
  0x0D, 0x70, 0xC0, 0xD7, 0x0B, 0x0D, 0x70, 0x99, 0x78, 0x15, 0xF5, 0x70, 0x0D, 0x78, 0x63, 0xED,
  0x75, 0x69, 0x42, 0x85, 0x29, 0xDF, 0xEB, 0x30,
  // "ĉ" (U+0109)
  0x48, 0x1B, 0xF8, 0x58, 0x38, 0xE7, 0xF4, 0x38, 0x55, 0xD2, 0x05, 0xE3, 0x74, 0x84, 0x4B, 0xEE,
  0xD8, 0x28, 0x56, 0xFC, 0x75, 0x7A, 0x20, 0xE0, 0xC6, 0x81, 0x4F, 0x66, 0x81, 0x6F, 0x36, 0x81,
  0x6F, 0x36, 0x81, 0x5F, 0x56, 0x81, 0x1F, 0xB7, 0x85, 0x8F, 0xC6, 0x57, 0xB3, 0x84, 0x5C, 0xEF,
  0xD9, 0x10,
  // "Ċ" (U+010A)
  0x50, 0x17, 0x81, 0x9F, 0x66, 0x81, 0x7E, 0x47, 0x77, 0x18, 0xA2, 0x18, 0xDF, 0xEB, 0x50, 0x2E,
  0xE7, 0x56, 0xA7, 0x0C, 0xD1, 0x58, 0x14, 0xF6, 0x68, 0x19, 0xF1, 0x60, 0xB0, 0xD7, 0x0C, 0x0D,
  0x70, 0xB0, 0xD7, 0x09, 0x97, 0x81, 0x5F, 0x57, 0x00, 0xD7, 0x86, 0x3E, 0xD7, 0x56, 0x94, 0x28,
  0x52, 0x9D, 0xFE, 0xB3,
  // "ċ" (U+010B)
  0x50, 0x16, 0x81, 0x9F, 0x65, 0x81, 0x7E, 0x47, 0x75, 0x89, 0x74, 0xBE, 0xED, 0x80, 0x6F, 0xC7,
  0x57, 0xA0, 0xEC, 0x58, 0x14, 0xF6, 0x58, 0x16, 0xF3, 0x58, 0x16, 0xF3, 0x58, 0x15, 0xF5, 0x58,
  0x11, 0xFB, 0x68, 0x58, 0xFC, 0x65, 0x7B, 0x28, 0x45, 0xCE, 0xFD, 0x90,
  // "Č" (U+010C)
  0x28, 0x56, 0xD2, 0x05, 0xE3, 0x38, 0x38, 0xE8, 0xF5, 0x58, 0x1B, 0xF8, 0x76, 0x8A, 0x21, 0x8D,
  0xFE, 0xB5, 0x02, 0xEE, 0x75, 0x6A, 0x70, 0xCD, 0x15, 0x81, 0x4F, 0x66, 0x81, 0x9F, 0x16, 0x0B,
  0x0D, 0x70, 0xC0, 0xD7, 0x0B, 0x0D, 0x70, 0x99, 0x78, 0x15, 0xF5, 0x70, 0x0D, 0x78, 0x63, 0xED,
  0x75, 0x69, 0x42, 0x85, 0x29, 0xDF, 0xEB, 0x30,
  // "č" (U+010D)
  0x28, 0x56, 0xD2, 0x05, 0xE3, 0x38, 0x38, 0xE8, 0xF5, 0x58, 0x1B, 0xF8, 0x76, 0x84, 0x4B, 0xEE,
  0xD8, 0x28, 0x56, 0xFC, 0x75, 0x7A, 0x20, 0xE0, 0xC6, 0x81, 0x4F, 0x66, 0x81, 0x6F, 0x36, 0x81,
  0x6F, 0x36, 0x81, 0x5F, 0x56, 0x81, 0x1F, 0xB7, 0x85, 0x8F, 0xC6, 0x57, 0xB3, 0x84, 0x5C, 0xEF,
  0xD9, 0x10,
  // "Ď" (U+010E)
  0x18, 0x56, 0xD2, 0x05, 0xE3, 0x38, 0x38, 0xE8, 0xF5, 0x58, 0x1B, 0xF8, 0x75, 0x0B, 0xB8, 0x1D,
  0x92, 0x28, 0x91, 0xBE, 0x55, 0x8E, 0xE4, 0x0B, 0xD3, 0x84, 0x1C, 0xE1, 0xBD, 0x48, 0x33, 0xF7,
  0xBD, 0x58, 0x2D, 0xCB, 0xD5, 0x82, 0xBE, 0xBD, 0x58, 0x2A, 0xEB, 0xD5, 0x82, 0xBE, 0xBD, 0x58,
  0x2E, 0xBB, 0xD4, 0x83, 0x4F, 0x7B, 0xD3, 0x89, 0x41, 0xDE, 0x1B, 0xE5, 0x58, 0xEE, 0x30, 0xBA,
  0x82, 0xED, 0x81, 0x20,
  // "ď" (U+010F)
  0x79, 0x82, 0x91, 0xF6, 0x79, 0x82, 0x94, 0xE1, 0x79, 0x81, 0x97, 0x77, 0x19, 0x09, 0x58, 0x56,
  0xDF, 0xC3, 0xE9, 0x48, 0x65, 0xFC, 0x67, 0xDE, 0x94, 0x0D, 0x0E, 0x38, 0x17, 0xF9, 0x38, 0x11,
  0xF9, 0x38, 0x12, 0xF9, 0x38, 0x12, 0xF8, 0x49, 0x09, 0x38, 0x12, 0xF7, 0x49, 0x09, 0x38, 0x11,
  0xF9, 0x38, 0x11, 0xF9, 0x40, 0xD0, 0xE3, 0x81, 0x6F, 0x94, 0x86, 0x5F, 0xB6, 0x8E, 0xE9, 0x58,
  0x56, 0xDF, 0xC3, 0xB9, 0x30,
  // "Đ" (U+0110)
  0x10, 0x8B, 0x81, 0xDA, 0x34, 0x86, 0x8F, 0x55, 0x7D, 0xF6, 0x38, 0x18, 0xF1, 0x38, 0x1A, 0xF3,
  0x28, 0x18, 0xF1, 0x38, 0x11, 0xEA, 0x28, 0x18, 0xF1, 0x48, 0x6A, 0xE0, 0x19, 0xF2, 0x13, 0x81,
  0x8F, 0x1D, 0x03, 0x28, 0x77, 0xF2, 0x3A, 0xF4, 0x31, 0x28, 0x58, 0xF1, 0x08, 0xF1, 0x40, 0xB0,
  0xE2, 0x81, 0x8F, 0x13, 0x81, 0x1F, 0xA2, 0x81, 0x8F, 0x13, 0x81, 0xBF, 0x32, 0x86, 0x8F, 0x55,
  0x8D, 0xF6, 0x30, 0x8B, 0x81, 0xD9, 0x23,
  // "đ" (U+0111)
  0x68, 0x13, 0xF5, 0x58, 0x31, 0x14, 0xF6, 0x40, 0x6D, 0x0C, 0x38, 0xB4, 0x13, 0x36, 0xF8, 0x30,
  0x3B, 0xEE, 0xA4, 0xF5, 0x02, 0xEE, 0x75, 0xAD, 0xF5, 0x09, 0xF3, 0x38, 0x4B, 0xF5, 0x0D, 0xC4,
  0x84, 0x6F, 0x50, 0xFA, 0x48, 0x44, 0xF5, 0x0F, 0xA4, 0x84, 0x3F, 0x50, 0xDC, 0x48, 0x55, 0xF5,
  0x09, 0xF2, 0x38, 0x93, 0xBF, 0x50, 0x2E, 0xE7, 0x6B, 0xDF, 0x52, 0x86, 0x3B, 0xEE, 0xA1, 0xF5,
  0x10,
  // "Ē" (U+0112)
  0x38, 0x01, 0x13, 0x04, 0xD0, 0x12, 0x01, 0x80, 0x13, 0x73, 0x04, 0xF8, 0x24, 0x4F, 0x88, 0x01,
  0x58, 0x21, 0x4F, 0x56, 0x81, 0x4F, 0x56, 0x81, 0x4F, 0x56, 0x81, 0x4F, 0x58, 0x01, 0x11, 0x04,
  0xE8, 0x3E, 0x04, 0xF7, 0x80, 0x13, 0x18, 0x14, 0xF5, 0x68, 0x14, 0xF5, 0x68, 0x14, 0xF5, 0x68,
  0x14, 0xF8, 0x80, 0x15, 0x01, 0x04, 0xF0, 0x40,
  // "ē" (U+0113)
  0x28, 0x01, 0x13, 0x04, 0xD0, 0x12, 0x01, 0x80, 0x13, 0x76, 0x84, 0x7D, 0xFE, 0x91, 0x28, 0x91,
  0xBF, 0x95, 0x7E, 0xC0, 0x5F, 0x53, 0x83, 0x4F, 0x5B, 0xE8, 0x01, 0x19, 0x09, 0x0D, 0xF8, 0x1B,
  0xDC, 0x80, 0x23, 0x81, 0x2B, 0xE7, 0x81, 0x6F, 0x67, 0x86, 0xBF, 0x96, 0x58, 0xC4, 0x28, 0x56,
  0xCE, 0xED, 0x91,
  // "Ĕ" (U+0114)
  0x20, 0x10, 0x23, 0x03, 0x38, 0x33, 0xE4, 0x16, 0x94, 0x09, 0xB0, 0x65, 0x81, 0x13, 0x12, 0x04,
  0xF8, 0x24, 0x4F, 0x88, 0x01, 0x58, 0x21, 0x4F, 0x56, 0x81, 0x4F, 0x56, 0x81, 0x4F, 0x56, 0x81,
  0x4F, 0x58, 0x01, 0x11, 0x04, 0xE8, 0x3E, 0x04, 0xF7, 0x80, 0x13, 0x18, 0x14, 0xF5, 0x68, 0x14,
  0xF5, 0x68, 0x14, 0xF5, 0x68, 0x14, 0xF8, 0x80, 0x15, 0x01, 0x04, 0xF0, 0x40,
  // "ĕ" (U+0115)
  0x10, 0x10, 0x23, 0x03, 0x38, 0x33, 0xE4, 0x16, 0x94, 0x09, 0xB0, 0x65, 0x81, 0x13, 0x15, 0x84,
  0x7D, 0xFE, 0x91, 0x28, 0x91, 0xBF, 0x95, 0x7E, 0xC0, 0x5F, 0x53, 0x83, 0x4F, 0x5B, 0xE8, 0x01,
  0x19, 0x09, 0x0D, 0xF8, 0x1B, 0xDC, 0x80, 0x23, 0x81, 0x2B, 0xE7, 0x81, 0x6F, 0x67, 0x86, 0xBF,
  0x96, 0x58, 0xC4, 0x28, 0x56, 0xCE, 0xED, 0x91,
  // "Ė" (U+0116)
  0x50, 0x17, 0x81, 0x9F, 0x66, 0x81, 0x7E, 0x47, 0x76, 0x04, 0xF8, 0x24, 0x4F, 0x88, 0x01, 0x58,
  0x21, 0x4F, 0x56, 0x81, 0x4F, 0x56, 0x81, 0x4F, 0x56, 0x81, 0x4F, 0x58, 0x01, 0x11, 0x04, 0xE8,
  0x3E, 0x04, 0xF7, 0x80, 0x13, 0x18, 0x14, 0xF5, 0x68, 0x14, 0xF5, 0x68, 0x14, 0xF5, 0x68, 0x14,
  0xF8, 0x80, 0x15, 0x01, 0x04, 0xF0, 0x40,
  // "ė" (U+0117)
  0x40, 0x17, 0x81, 0x9F, 0x66, 0x81, 0x7E, 0x47, 0x77, 0x28, 0x47, 0xDF, 0xE9, 0x12, 0x89, 0x1B,
  0xF9, 0x57, 0xEC, 0x05, 0xF5, 0x38, 0x34, 0xF5, 0xBE, 0x80, 0x11, 0x90, 0x90, 0xDF, 0x81, 0xBD,
  0xC8, 0x02, 0x38, 0x12, 0xBE, 0x78, 0x16, 0xF6, 0x78, 0x6B, 0xF9, 0x65, 0x8C, 0x42, 0x85, 0x6C,
  0xEE, 0xD9, 0x10,
  // "Ę" (U+0118)
  0x04, 0xF8, 0x24, 0x4F, 0x88, 0x01, 0x58, 0x21, 0x4F, 0x56, 0x81, 0x4F, 0x56, 0x81, 0x4F, 0x56,
  0x81, 0x4F, 0x58, 0x01, 0x11, 0x04, 0xE8, 0x3E, 0x04, 0xF7, 0x80, 0x13, 0x18, 0x14, 0xF5, 0x68,
  0x14, 0xF5, 0x68, 0x14, 0xF5, 0x68, 0x14, 0xF8, 0x80, 0x15, 0x01, 0x04, 0xF0, 0x45, 0x81, 0x2D,
  0x26, 0x0B, 0x06, 0x79, 0x07, 0x01, 0x68, 0x1B, 0xFE, 0x70, 0x30, 0x21,
  // "ę" (U+0119)
  0x28, 0x47, 0xDF, 0xE9, 0x12, 0x89, 0x1B, 0xF9, 0x57, 0xEC, 0x05, 0xF5, 0x38, 0x34, 0xF5, 0xBE,
  0x80, 0x11, 0x90, 0x90, 0xDF, 0x81, 0xBD, 0xC8, 0x02, 0x38, 0x12, 0xBE, 0x78, 0x16, 0xF6, 0x78,
  0x6B, 0xF9, 0x65, 0x8C, 0x42, 0x81, 0x6C, 0xEA, 0x0E, 0x02, 0x58, 0x13, 0xD1, 0x60, 0xB0, 0x87,
  0x81, 0xCC, 0x56, 0x82, 0x4E, 0xE1,
  // "Ě" (U+011A)
  0x28, 0x56, 0xD2, 0x05, 0xE3, 0x38, 0x38, 0xE8, 0xF5, 0x58, 0x1B, 0xF8, 0x74, 0x04, 0xF8, 0x24,
  0x4F, 0x88, 0x01, 0x58, 0x21, 0x4F, 0x56, 0x81, 0x4F, 0x56, 0x81, 0x4F, 0x56, 0x81, 0x4F, 0x58,
  0x01, 0x11, 0x04, 0xE8, 0x3E, 0x04, 0xF7, 0x80, 0x13, 0x18, 0x14, 0xF5, 0x68, 0x14, 0xF5, 0x68,
  0x14, 0xF5, 0x68, 0x14, 0xF8, 0x80, 0x15, 0x01, 0x04, 0xF0, 0x40,
  // "ě" (U+011B)
  0x18, 0x56, 0xD2, 0x05, 0xE3, 0x38, 0x38, 0xE8, 0xF5, 0x58, 0x1B, 0xF8, 0x77, 0x84, 0x7D, 0xFE,
  0x91, 0x28, 0x91, 0xBF, 0x95, 0x7E, 0xC0, 0x5F, 0x53, 0x83, 0x4F, 0x5B, 0xE8, 0x01, 0x19, 0x09,
  0x0D, 0xF8, 0x1B, 0xDC, 0x80, 0x23, 0x81, 0x2B, 0xE7, 0x81, 0x6F, 0x67, 0x86, 0xBF, 0x96, 0x58,
  0xC4, 0x28, 0x56, 0xCE, 0xED, 0x91,
  // "Ĝ" (U+011C)
  0x58, 0x1B, 0xF8, 0x68, 0x38, 0xE7, 0xF4, 0x48, 0x55, 0xD2, 0x05, 0xE3, 0x76, 0x85, 0x4B, 0xEF,
  0xD9, 0x12, 0x89, 0x27, 0xFC, 0x65, 0x7C, 0x10, 0x3F, 0x97, 0x81, 0xAE, 0x17, 0x0E, 0x0A, 0x78,
  0x11, 0xF8, 0x30, 0xF1, 0x18, 0x12, 0xF7, 0x20, 0x5B, 0x82, 0x82, 0xF8, 0x28, 0x61, 0x34, 0xF8,
  0x0F, 0xA5, 0x98, 0x28, 0x0C, 0xE5, 0x98, 0x38, 0x06, 0xF8, 0x49, 0x08, 0x28, 0x6A, 0xFB, 0x65,
  0x7F, 0x83, 0x85, 0x6C, 0xEF, 0xDA, 0x40,
  // "ĝ" (U+011D)
  0x38, 0x1B, 0xF8, 0x58, 0x38, 0xE7, 0xF4, 0x38, 0x55, 0xD2, 0x05, 0xE3, 0x74, 0x8A, 0x22, 0xBE,
  0xE9, 0x1F, 0x51, 0xEE, 0x76, 0xAD, 0xF5, 0x9F, 0x33, 0x83, 0x9F, 0x5D, 0xC4, 0x83, 0x3F, 0x5F,
  0xA4, 0x83, 0x1F, 0x5F, 0xA4, 0x83, 0x1F, 0x5D, 0xC4, 0x84, 0x3F, 0x59, 0xF3, 0x38, 0xA3, 0x9F,
  0x52, 0xEE, 0x75, 0x9E, 0xF5, 0x02, 0xBE, 0xEB, 0x4F, 0x56, 0x81, 0x3F, 0x46, 0x8A, 0x18, 0xF1,
  0x7B, 0x75, 0x6A, 0xF9, 0x03, 0x9D, 0xEF, 0xC7, 0x20,
  // "Ğ" (U+011E)
  0x30, 0x10, 0x23, 0x03, 0x48, 0x33, 0xE4, 0x16, 0x95, 0x09, 0xB0, 0x66, 0x81, 0x13, 0x15, 0x85,
  0x4B, 0xEF, 0xD9, 0x12, 0x89, 0x27, 0xFC, 0x65, 0x7C, 0x10, 0x3F, 0x97, 0x81, 0xAE, 0x17, 0x0E,
  0x0A, 0x78, 0x11, 0xF8, 0x30, 0xF1, 0x18, 0x12, 0xF7, 0x20, 0x5B, 0x82, 0x82, 0xF8, 0x28, 0x61,
  0x34, 0xF8, 0x0F, 0xA5, 0x98, 0x28, 0x0C, 0xE5, 0x98, 0x38, 0x06, 0xF8, 0x49, 0x08, 0x28, 0x6A,
  0xFB, 0x65, 0x7F, 0x83, 0x85, 0x6C, 0xEF, 0xDA, 0x40,
  // "ğ" (U+011F)
  0x10, 0x10, 0x23, 0x03, 0x38, 0x33, 0xE4, 0x16, 0x94, 0x09, 0xB0, 0x65, 0x81, 0x13, 0x14, 0x8A,
  0x22, 0xBE, 0xE9, 0x1F, 0x51, 0xEE, 0x76, 0xAD, 0xF5, 0x9F, 0x33, 0x83, 0x9F, 0x5D, 0xC4, 0x83,
  0x3F, 0x5F, 0xA4, 0x83, 0x1F, 0x5F, 0xA4, 0x83, 0x1F, 0x5D, 0xC4, 0x84, 0x3F, 0x59, 0xF3, 0x38,
  0xA3, 0x9F, 0x52, 0xEE, 0x75, 0x9E, 0xF5, 0x02, 0xBE, 0xEB, 0x4F, 0x56, 0x81, 0x3F, 0x46, 0x8A,
  0x18, 0xF1, 0x7B, 0x75, 0x6A, 0xF9, 0x03, 0x9D, 0xEF, 0xC7, 0x20,
  // "Ġ" (U+0120)
  0x60, 0x17, 0x18, 0x19, 0xF6, 0x78, 0x17, 0xE4, 0x77, 0x74, 0x85, 0x4B, 0xEF, 0xD9, 0x12, 0x89,
  0x27, 0xFC, 0x65, 0x7C, 0x10, 0x3F, 0x97, 0x81, 0xAE, 0x17, 0x0E, 0x0A, 0x78, 0x11, 0xF8, 0x30,
  0xF1, 0x18, 0x12, 0xF7, 0x20, 0x5B, 0x82, 0x82, 0xF8, 0x28, 0x61, 0x34, 0xF8, 0x0F, 0xA5, 0x98,
  0x28, 0x0C, 0xE5, 0x98, 0x38, 0x06, 0xF8, 0x49, 0x08, 0x28, 0x6A, 0xFB, 0x65, 0x7F, 0x83, 0x85,
  0x6C, 0xEF, 0xDA, 0x40,
  // "ġ" (U+0121)
  0x40, 0x17, 0x81, 0x9F, 0x66, 0x81, 0x7E, 0x47, 0x77, 0x18, 0xA2, 0x2B, 0xEE, 0x91, 0xF5, 0x1E,
  0xE7, 0x6A, 0xDF, 0x59, 0xF3, 0x38, 0x39, 0xF5, 0xDC, 0x48, 0x33, 0xF5, 0xFA, 0x48, 0x31, 0xF5,
  0xFA, 0x48, 0x31, 0xF5, 0xDC, 0x48, 0x43, 0xF5, 0x9F, 0x33, 0x8A, 0x39, 0xF5, 0x2E, 0xE7, 0x59,
  0xEF, 0x50, 0x2B, 0xEE, 0xB4, 0xF5, 0x68, 0x13, 0xF4, 0x68, 0xA1, 0x8F, 0x17, 0xB7, 0x56, 0xAF,
  0x90, 0x39, 0xDE, 0xFC, 0x72,
  // "Ģ" (U+0122)
  0x38, 0x54, 0xBE, 0xFD, 0x91, 0x28, 0x92, 0x7F, 0xC6, 0x57, 0xC1, 0x03, 0xF9, 0x78, 0x1A, 0xE1,
  0x70, 0xE0, 0xA7, 0x81, 0x1F, 0x83, 0x0F, 0x11, 0x81, 0x2F, 0x72, 0x05, 0xB8, 0x28, 0x2F, 0x82,
  0x86, 0x13, 0x4F, 0x80, 0xFA, 0x59, 0x82, 0x80, 0xCE, 0x59, 0x83, 0x80, 0x6F, 0x84, 0x90, 0x82,
  0x86, 0xAF, 0xB6, 0x57, 0xF8, 0x38, 0x56, 0xCE, 0xFD, 0xA4, 0x77, 0x10, 0xC0, 0x97, 0x81, 0x1F,
  0x47, 0x05, 0x0A, 0x40,
  // "ģ" (U+0123)
  0x40, 0xA0, 0x66, 0x81, 0x3F, 0x16, 0x09, 0x0C, 0x77, 0x8A, 0x22, 0xBE, 0xE9, 0x1F, 0x51, 0xEE,
  0x76, 0xAD, 0xF5, 0x9F, 0x33, 0x83, 0x9F, 0x5D, 0xC4, 0x83, 0x3F, 0x5F, 0xA4, 0x83, 0x1F, 0x5F,
  0xA4, 0x83, 0x1F, 0x5D, 0xC4, 0x84, 0x3F, 0x59, 0xF3, 0x38, 0xA3, 0x9F, 0x52, 0xEE, 0x75, 0x9E,
  0xF5, 0x02, 0xBE, 0xEB, 0x4F, 0x56, 0x81, 0x3F, 0x46, 0x8A, 0x18, 0xF1, 0x7B, 0x75, 0x6A, 0xF9,
  0x03, 0x9D, 0xEF, 0xC7, 0x20,
  // "Ĥ" (U+0124)
  0x38, 0x1B, 0xF8, 0x58, 0x38, 0xE7, 0xF4, 0x38, 0x55, 0xD2, 0x05, 0xE3, 0x73, 0x0B, 0x0D, 0x48,
  0x31, 0xF8, 0xBD, 0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31, 0xF8, 0xBD, 0x48,
  0x93, 0x1F, 0x8B, 0xD1, 0x11, 0x12, 0xF8, 0xBF, 0x89, 0x28, 0xBE, 0x33, 0x33, 0x4F, 0x8B, 0xD4,
  0x83, 0x1F, 0x8B, 0xD4, 0x83, 0x1F, 0x8B, 0xD4, 0x83, 0x1F, 0x8B, 0xD4, 0x83, 0x1F, 0x8B, 0xD4,
  0x81, 0x1F, 0x80,
  // "ĥ" (U+0125)
  0x28, 0x1B, 0xF8, 0x78, 0x38, 0xE7, 0xF4, 0x58, 0x55, 0xD2, 0x05, 0xE3, 0x77, 0x38, 0x18, 0xF1,
  0x71, 0x81, 0x8F, 0x17, 0x18, 0x18, 0xF1, 0x71, 0x81, 0x8F, 0x17, 0x18, 0x68, 0xF1, 0x9E, 0xEB,
  0x23, 0x86, 0x8F, 0xBA, 0x67, 0xEE, 0x38, 0x18, 0xFA, 0x38, 0x17, 0xF5, 0x28, 0x18, 0xF3, 0x38,
  0x13, 0xF6, 0x28, 0x18, 0xF1, 0x38, 0x12, 0xF7, 0x28, 0x18, 0xF1, 0x38, 0x12, 0xF7, 0x28, 0x18,
  0xF1, 0x38, 0x12, 0xF7, 0x28, 0x18, 0xF1, 0x38, 0x12, 0xF7, 0x28, 0x18, 0xF1, 0x38, 0x12, 0xF7,
  0x28, 0x18, 0xF1, 0x38, 0x12, 0xF7,
  // "Ħ" (U+0126)
  0x10, 0xB0, 0xD4, 0x89, 0x41, 0xF8, 0x01, 0xBD, 0x11, 0x11, 0x2F, 0x91, 0xFB, 0x89, 0x5C, 0x3C,
  0xE3, 0x33, 0x34, 0xFA, 0x30, 0xBD, 0x48, 0x11, 0xF8, 0x28, 0x7B, 0xD1, 0x11, 0x12, 0xF8, 0x20,
  0xBF, 0x08, 0x28, 0x7B, 0xE3, 0x33, 0x34, 0xF8, 0x20, 0xB0, 0xD4, 0x81, 0x1F, 0x82, 0x0B, 0x0D,
  0x48, 0x11, 0xF8, 0x20, 0xB0, 0xD4, 0x81, 0x1F, 0x82, 0x0B, 0x0D, 0x48, 0x11, 0xF8, 0x20, 0xB0,
  0xD4, 0x81, 0x1F, 0x81,
  // "ħ" (U+0127)
  0x18, 0x18, 0xF1, 0x68, 0x41, 0x9F, 0x21, 0x14, 0xE0, 0x33, 0x84, 0x3A, 0xF4, 0x33, 0x58, 0x68,
  0xF1, 0x9E, 0xEB, 0x22, 0x86, 0x8F, 0xBA, 0x67, 0xEE, 0x28, 0x18, 0xFA, 0x38, 0x57, 0xF5, 0x08,
  0xF3, 0x38, 0x53, 0xF6, 0x08, 0xF1, 0x38, 0x52, 0xF7, 0x08, 0xF1, 0x38, 0x52, 0xF7, 0x08, 0xF1,
  0x38, 0x52, 0xF7, 0x08, 0xF1, 0x38, 0x52, 0xF7, 0x08, 0xF1, 0x38, 0x52, 0xF7, 0x08, 0xF1, 0x38,
  0x12, 0xF7,
  // "Ĩ" (U+0128)
  0x89, 0x52, 0xDF, 0x82, 0x97, 0xA9, 0x5D, 0xFE, 0x13, 0x30, 0x20, 0x11, 0xE8, 0x6C, 0x46, 0xAF,
  0x85, 0x32, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F,
  0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x22, 0x85, 0x23, 0x9F,
  0x63, 0x1E, 0x0C,
  // "ĩ" (U+0129)
  0x18, 0x52, 0xDF, 0x82, 0x97, 0x28, 0x5A, 0x95, 0xDF, 0xE1, 0x20, 0x33, 0x02, 0x01, 0x20, 0x4C,
  0x07, 0x48, 0x33, 0x57, 0xF7, 0x68, 0x11, 0xF7, 0x68, 0x11, 0xF7, 0x68, 0x11, 0xF7, 0x68, 0x11,
  0xF7, 0x68, 0x11, 0xF7, 0x68, 0x11, 0xF7, 0x38, 0x90, 0x12, 0x46, 0xFA, 0x43, 0x18, 0xF0, 0xB0,
  // "Ī" (U+012A)
  0x18, 0x01, 0x11, 0x04, 0xD0, 0x01, 0x80, 0x13, 0x71, 0xE8, 0x6C, 0x46, 0xAF, 0x85, 0x32, 0x81,
  0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F,
  0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x22, 0x85, 0x23, 0x9F, 0x63, 0x1E, 0x0C,
  // "ī" (U+012B)
  0x28, 0x01, 0x13, 0x04, 0xD0, 0x12, 0x01, 0x80, 0x13, 0x74, 0x04, 0xC0, 0x74, 0x83, 0x35, 0x7F,
  0x76, 0x81, 0x1F, 0x76, 0x81, 0x1F, 0x76, 0x81, 0x1F, 0x76, 0x81, 0x1F, 0x76, 0x81, 0x1F, 0x76,
  0x81, 0x1F, 0x73, 0x89, 0x01, 0x24, 0x6F, 0xA4, 0x31, 0x8F, 0x0B,
  // "Ĭ" (U+012C)
  0x01, 0x02, 0x38, 0x53, 0x03, 0xE4, 0x16, 0x92, 0x09, 0xB0, 0x63, 0x81, 0x13, 0x12, 0xE8, 0x6C,
  0x46, 0xAF, 0x85, 0x32, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24,
  0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x22, 0x85,
  0x23, 0x9F, 0x63, 0x1E, 0x0C,
  // "ĭ" (U+012D)
  0x10, 0x10, 0x23, 0x03, 0x38, 0x33, 0xE4, 0x16, 0x94, 0x09, 0xB0, 0x65, 0x81, 0x13, 0x13, 0x04,
  0xC0, 0x74, 0x83, 0x35, 0x7F, 0x76, 0x81, 0x1F, 0x76, 0x81, 0x1F, 0x76, 0x81, 0x1F, 0x76, 0x81,
  0x1F, 0x76, 0x81, 0x1F, 0x76, 0x81, 0x1F, 0x73, 0x89, 0x01, 0x24, 0x6F, 0xA4, 0x31, 0x8F, 0x0B,
  // "Į" (U+012E)
  0xE8, 0x6C, 0x46, 0xAF, 0x85, 0x32, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81,
  0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F,
  0x22, 0x85, 0x23, 0x9F, 0x63, 0x1E, 0x0C, 0x38, 0x12, 0xD2, 0x40, 0xB0, 0x65, 0x90, 0x70, 0x14,
  0x81, 0xBF, 0xE5, 0x03, 0x02, 0x10,
  // "į" (U+012F)
  0x38, 0x15, 0xE6, 0x68, 0x17, 0xF8, 0x70, 0x17, 0x60, 0x4C, 0x07, 0x48, 0x33, 0x57, 0xF7, 0x68,
  0x11, 0xF7, 0x68, 0x11, 0xF7, 0x68, 0x11, 0xF7, 0x68, 0x11, 0xF7, 0x68, 0x11, 0xF7, 0x68, 0x11,
  0xF7, 0x38, 0x90, 0x12, 0x46, 0xFA, 0x43, 0x18, 0xF0, 0xB5, 0x81, 0x2D, 0x26, 0x0B, 0x06, 0x79,
  0x07, 0x01, 0x68, 0x1B, 0xFE, 0x70, 0x30, 0x21,
  // "İ" (U+0130)
  0x30, 0x15, 0x81, 0x9F, 0x64, 0x81, 0x7E, 0x47, 0x72, 0xE8, 0x6C, 0x46, 0xAF, 0x85, 0x32, 0x81,
  0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F,
  0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x24, 0x81, 0x6F, 0x22, 0x85, 0x23, 0x9F, 0x63, 0x1E, 0x0C,
  // "ı" (U+0131)
  0x04, 0xC0, 0x74, 0x83, 0x35, 0x7F, 0x76, 0x81, 0x1F, 0x76, 0x81, 0x1F, 0x76, 0x81, 0x1F, 0x76,
  0x81, 0x1F, 0x76, 0x81, 0x1F, 0x76, 0x81, 0x1F, 0x73, 0x89, 0x01, 0x24, 0x6F, 0xA4, 0x31, 0x8F,
  0x0B,
  // "Ĳ" (U+0132)
  0x81, 0x3F, 0x63, 0x83, 0x9F, 0x3F, 0x63, 0x83, 0x9F, 0x3F, 0x63, 0x83, 0x9F, 0x3F, 0x63, 0x83,
  0x9F, 0x3F, 0x63, 0x83, 0x9F, 0x3F, 0x63, 0x83, 0x9F, 0x3F, 0x63, 0x83, 0x9F, 0x3F, 0x63, 0x83,
  0x9F, 0x3F, 0x63, 0x09, 0x96, 0x0B, 0x0E, 0x58, 0xA0, 0x1E, 0xB2, 0xB7, 0x57, 0xDF, 0x41, 0xBE,
  0xFE, 0xB4, 0x10,
  // "ĳ" (U+0133)
  0x81, 0x1D, 0xC2, 0x84, 0x1E, 0xB1, 0xEE, 0x28, 0x32, 0xFD, 0x01, 0x40, 0x17, 0x30, 0xD0, 0xB3,
  0x83, 0xDB, 0x0D, 0xB3, 0x83, 0xDB, 0x0D, 0xB3, 0x83, 0xDB, 0x0D, 0xB3, 0x83, 0xDB, 0x0D, 0xB3,
  0x83, 0xDB, 0x0D, 0xB3, 0x83, 0xDB, 0x0D, 0xB3, 0x83, 0xDB, 0x0D, 0xB3, 0x83, 0xDB, 0x0D, 0xB3,
  0x83, 0xDB, 0x0D, 0xB3, 0x0D, 0x0B, 0x60, 0xD0, 0xB5, 0x8A, 0x01, 0xF9, 0x05, 0x65, 0x6D, 0xF3,
  0x07, 0xEF, 0xEB, 0x31,
  // "Ĵ" (U+0134)
  0x68, 0x1B, 0xF8, 0x78, 0x38, 0xE7, 0xF4, 0x58, 0x55, 0xD2, 0x05, 0xE3, 0x77, 0x28, 0x13, 0xF5,
  0x71, 0x81, 0x3F, 0x57, 0x18, 0x13, 0xF5, 0x71, 0x81, 0x3F, 0x57, 0x18, 0x13, 0xF5, 0x71, 0x81,
  0x3F, 0x57, 0x18, 0x13, 0xF5, 0x71, 0x81, 0x3F, 0x57, 0x18, 0x13, 0xF5, 0x71, 0x81, 0x5F, 0x47,
  0x18, 0x19, 0xF1, 0x38, 0x52, 0xA6, 0x59, 0xF9, 0x48, 0x41, 0xBE, 0xFD, 0x85,
  // "ĵ" (U+0135)
  0x48, 0x1B, 0xF8, 0x58, 0x38, 0xE7, 0xF4, 0x38, 0x55, 0xD2, 0x05, 0xE3, 0x73, 0x09, 0xC0, 0x23,
  0x84, 0x25, 0x6B, 0xF2, 0x68, 0x17, 0xF2, 0x68, 0x17, 0xF2, 0x68, 0x17, 0xF2, 0x68, 0x17, 0xF2,
  0x68, 0x17, 0xF2, 0x68, 0x17, 0xF2, 0x68, 0x17, 0xF2, 0x68, 0x17, 0xF2, 0x68, 0x17, 0xF1, 0x60,
  0xB9, 0x38, 0x48, 0x65, 0x9F, 0x83, 0x83, 0xBE, 0xFD, 0x74,
  // "Ķ" (U+0136)
  0x0B, 0x0D, 0x48, 0x37, 0xF5, 0xBD, 0x38, 0x43, 0xFA, 0x0B, 0xD2, 0x81, 0x1D, 0xD2, 0x0B, 0x0D,
  0x28, 0x1A, 0xF3, 0x28, 0x4B, 0xD0, 0x6F, 0x73, 0x83, 0xBD, 0x2E, 0xB4, 0x83, 0xBD, 0xBF, 0xB4,
  0x84, 0xBF, 0xD7, 0xF6, 0x38, 0x5B, 0xE2, 0x0B, 0xE1, 0x20, 0xB0, 0xD2, 0x81, 0x2F, 0xA2, 0x0B,
  0x0D, 0x38, 0x47, 0xF4, 0x0B, 0xD4, 0x83, 0xDD, 0x0B, 0xD4, 0x81, 0x4F, 0x97, 0x60, 0xC0, 0x96,
  0x81, 0x1F, 0x46, 0x05, 0x0A, 0x40,
  // "ķ" (U+0137)
  0x81, 0x1F, 0x86, 0x81, 0x1F, 0x86, 0x81, 0x1F, 0x86, 0x81, 0x1F, 0x86, 0x81, 0x1F, 0x83, 0x84,
  0x5F, 0x81, 0xF8, 0x28, 0x91, 0x4F, 0xA0, 0x1F, 0x70, 0x2E, 0xB2, 0x85, 0x1F, 0x71, 0xDD, 0x12,
  0x84, 0x1F, 0x7B, 0xF5, 0x38, 0x51, 0xFD, 0xCC, 0xE1, 0x28, 0x51, 0xFD, 0x11, 0xEB, 0x28, 0x11,
  0xF8, 0x28, 0x55, 0xF7, 0x01, 0xF8, 0x38, 0x4A, 0xF3, 0x1F, 0x83, 0x81, 0x1D, 0xD7, 0x60, 0xC0,
  0x96, 0x81, 0x1F, 0x46, 0x05, 0x0A, 0x40,
  // "ĸ" (U+0138)
  0x81, 0x1F, 0x83, 0x84, 0x5F, 0x81, 0xF8, 0x28, 0x91, 0x4F, 0xA0, 0x1F, 0x70, 0x2E, 0xB2, 0x85,
  0x1F, 0x71, 0xDD, 0x12, 0x84, 0x1F, 0x7C, 0xF5, 0x38, 0x51, 0xFD, 0xCC, 0xE1, 0x28, 0x51, 0xFD,
  0x11, 0xEB, 0x28, 0x11, 0xF8, 0x28, 0x55, 0xF7, 0x01, 0xF8, 0x38, 0x4A, 0xF3, 0x1F, 0x83, 0x81,
  0x1D, 0xD0,
  // "Ĺ" (U+0139)
  0x18, 0x12, 0xFC, 0x58, 0x1B, 0xD1, 0x48, 0x15, 0xD2, 0x76, 0x0E, 0x0A, 0x60, 0xE0, 0xA6, 0x0E,
  0x0A, 0x60, 0xE0, 0xA6, 0x0E, 0x0A, 0x60, 0xE0, 0xA6, 0x0E, 0x0A, 0x60, 0xE0, 0xA6, 0x0E, 0x0A,
  0x60, 0xE0, 0xA6, 0x0E, 0x0A, 0x60, 0xE0, 0xD8, 0x01, 0x80, 0x20, 0xEE, 0x04,
  // "ĺ" (U+013A)
  0x48, 0x12, 0xFC, 0x68, 0x1B, 0xD1, 0x58, 0x15, 0xD2, 0x75, 0x07, 0xC0, 0x93, 0x84, 0x25, 0x55,
  0xF9, 0x79, 0x09, 0x79, 0x09, 0x79, 0x09, 0x79, 0x09, 0x79, 0x09, 0x79, 0x09, 0x79, 0x09, 0x79,
  0x09, 0x79, 0x09, 0x79, 0x09, 0x38, 0x90, 0x12, 0x35, 0xFB, 0x43, 0x18, 0xF0, 0xB0,
  // "Ļ" (U+013B)
  0x0E, 0x0A, 0x60, 0xE0, 0xA6, 0x0E, 0x0A, 0x60, 0xE0, 0xA6, 0x0E, 0x0A, 0x60, 0xE0, 0xA6, 0x0E,
  0x0A, 0x60, 0xE0, 0xA6, 0x0E, 0x0A, 0x60, 0xE0, 0xA6, 0x0E, 0x0A, 0x60, 0xE0, 0xD8, 0x01, 0x80,
  0x20, 0xEE, 0x04, 0x74, 0x0C, 0x09, 0x58, 0x11, 0xF4, 0x50, 0x50, 0xA4,
  // "ļ" (U+013C)
  0x07, 0xC0, 0x93, 0x84, 0x25, 0x55, 0xF9, 0x79, 0x09, 0x79, 0x09, 0x79, 0x09, 0x79, 0x09, 0x79,
  0x09, 0x79, 0x09, 0x79, 0x09, 0x79, 0x09, 0x79, 0x09, 0x79, 0x09, 0x38, 0x90, 0x12, 0x35, 0xFB,
  0x43, 0x18, 0xF0, 0xB7, 0x60, 0xC0, 0x96, 0x81, 0x1F, 0x46, 0x05, 0x0A, 0x40,
  // "Ľ" (U+013D)
  0x0E, 0x0A, 0x38, 0x39, 0xE0, 0xEA, 0x38, 0x3C, 0x80, 0xEA, 0x38, 0x3D, 0x10, 0xEA, 0x60, 0xE0,
  0xA6, 0x0E, 0x0A, 0x60, 0xE0, 0xA6, 0x0E, 0x0A, 0x60, 0xE0, 0xA6, 0x0E, 0x0A, 0x60, 0xE0, 0xA6,
  0x0E, 0x0D, 0x80, 0x18, 0x02, 0x0E, 0xE0, 0x40,
  // "ľ" (U+013E)
  0x07, 0xC8, 0x93, 0x90, 0x8E, 0x25, 0x55, 0xF9, 0x0B, 0x94, 0x98, 0x29, 0x0D, 0x14, 0x90, 0x97,
  0x90, 0x97, 0x90, 0x97, 0x90, 0x97, 0x90, 0x97, 0x90, 0x97, 0x90, 0x97, 0x90, 0x97, 0x90, 0x93,
  0x89, 0x01, 0x23, 0x5F, 0xB4, 0x31, 0x8F, 0x0B,
  // "Ŀ" (U+013F)
  0x0E, 0x0A, 0x60, 0xE0, 0xA6, 0x0E, 0x0A, 0x60, 0xE0, 0xA6, 0x0E, 0x0A, 0x48, 0x21, 0x0E, 0xA3,
  0x83, 0x9F, 0x6E, 0xA3, 0x83, 0x7E, 0x4E, 0xA6, 0x0E, 0x0A, 0x60, 0xE0, 0xA6, 0x0E, 0x0A, 0x60,
  0xE0, 0xD8, 0x01, 0x80, 0x20, 0xEE, 0x04,
  // "ŀ" (U+0140)
  0x07, 0xC0, 0x95, 0x84, 0x25, 0x55, 0xF9, 0x72, 0x90, 0x97, 0x29, 0x09, 0x72, 0x90, 0x97, 0x29,
  0x09, 0x30, 0x15, 0x90, 0x92, 0x81, 0x9F, 0x64, 0x90, 0x92, 0x81, 0x7E, 0x44, 0x90, 0x97, 0x29,
  0x09, 0x72, 0x90, 0x97, 0x29, 0x09, 0x58, 0x71, 0x23, 0x5F, 0xB4, 0x31, 0x20, 0x8F, 0x0B, 0x20,
  // "Ł" (U+0141)
  0x18, 0x13, 0xF6, 0x68, 0x13, 0xF6, 0x68, 0x13, 0xF6, 0x68, 0x13, 0xF6, 0x68, 0x33, 0xF6, 0x01,
  0x48, 0x33, 0xF7, 0x9E, 0x40, 0x3A, 0x0D, 0x04, 0x38, 0x23, 0xCF, 0x95, 0x82, 0xBB, 0xF6, 0x68,
  0x13, 0xF6, 0x68, 0x13, 0xF6, 0x68, 0x90, 0x3F, 0xB8, 0x88, 0x87, 0x03, 0xF0,
  // "ł" (U+0142)
  0x07, 0xC0, 0x93, 0x84, 0x25, 0x55, 0xF9, 0x79, 0x09, 0x79, 0x09, 0x79, 0x09, 0x79, 0x81, 0x97,
  0x55, 0xA0, 0xE0, 0x53, 0x83, 0x19, 0xFB, 0x13, 0x83, 0x2E, 0xDF, 0x95, 0x82, 0x60, 0xF9, 0x79,
  0x09, 0x79, 0x09, 0x38, 0x90, 0x12, 0x35, 0xFB, 0x43, 0x18, 0xF0, 0xB0,
  // "Ń" (U+0143)
  0x48, 0x12, 0xFC, 0x68, 0x1B, 0xD1, 0x58, 0x15, 0xD2, 0x75, 0x81, 0xBF, 0x94, 0x90, 0x80, 0xBA,
  0x01, 0x39, 0x83, 0x8B, 0xBE, 0x73, 0x98, 0x38, 0xBB, 0x9D, 0x39, 0x84, 0x8B, 0xC2, 0xF5, 0x29,
  0x84, 0x8B, 0xC0, 0xBB, 0x29, 0x89, 0x28, 0xBC, 0x04, 0xF3, 0x0F, 0x8B, 0xC2, 0x85, 0xC9, 0x0F,
  0x8B, 0xC2, 0x85, 0x6F, 0x1F, 0x8B, 0xC3, 0x84, 0xE7, 0xE8, 0xBC, 0x38, 0x48, 0xDE, 0x8B, 0xC3,
  0x01, 0xA8, 0x18, 0xBC, 0x48, 0x19, 0xF8,
  // "ń" (U+0144)
  0x58, 0x12, 0xFC, 0x68, 0x1B, 0xD1, 0x58, 0x15, 0xD2, 0x74, 0x8A, 0x38, 0xC1, 0xAE, 0xEB, 0x30,
  0x8E, 0xC9, 0x57, 0xEE, 0x18, 0xF9, 0x38, 0x46, 0xF4, 0x8F, 0x33, 0x84, 0x3F, 0x68, 0xF1, 0x38,
  0x42, 0xF7, 0x8F, 0x13, 0x84, 0x2F, 0x78, 0xF1, 0x38, 0x42, 0xF7, 0x8F, 0x13, 0x84, 0x2F, 0x78,
  0xF1, 0x38, 0x42, 0xF7, 0x8F, 0x13, 0x81, 0x2F, 0x70,
  // "Ņ" (U+0145)
  0x81, 0xBF, 0x94, 0x90, 0x80, 0xBA, 0x01, 0x39, 0x83, 0x8B, 0xBE, 0x73, 0x98, 0x38, 0xBB, 0x9D,
  0x39, 0x84, 0x8B, 0xC2, 0xF5, 0x29, 0x84, 0x8B, 0xC0, 0xBB, 0x29, 0x89, 0x28, 0xBC, 0x04, 0xF3,
  0x0F, 0x8B, 0xC2, 0x85, 0xC9, 0x0F, 0x8B, 0xC2, 0x85, 0x6F, 0x1F, 0x8B, 0xC3, 0x84, 0xE7, 0xE8,
  0xBC, 0x38, 0x48, 0xDE, 0x8B, 0xC3, 0x01, 0xA8, 0x18, 0xBC, 0x48, 0x19, 0xF8, 0x75, 0x0C, 0x09,
  0x68, 0x11, 0xF4, 0x60, 0x50, 0xA5,
  // "ņ" (U+0146)
  0x8A, 0x38, 0xC1, 0xAE, 0xEB, 0x30, 0x8E, 0xC9, 0x57, 0xEE, 0x18, 0xF9, 0x38, 0x46, 0xF4, 0x8F,
  0x33, 0x84, 0x3F, 0x68, 0xF1, 0x38, 0x42, 0xF7, 0x8F, 0x13, 0x84, 0x2F, 0x78, 0xF1, 0x38, 0x42,
  0xF7, 0x8F, 0x13, 0x84, 0x2F, 0x78, 0xF1, 0x38, 0x42, 0xF7, 0x8F, 0x13, 0x81, 0x2F, 0x77, 0x60,
  0xC0, 0x96, 0x81, 0x1F, 0x46, 0x05, 0x0A, 0x40,
  // "Ň" (U+0147)
  0x18, 0x56, 0xD2, 0x05, 0xE3, 0x38, 0x38, 0xE8, 0xF5, 0x58, 0x1B, 0xF8, 0x75, 0x81, 0xBF, 0x94,
  0x90, 0x80, 0xBA, 0x01, 0x39, 0x83, 0x8B, 0xBE, 0x73, 0x98, 0x38, 0xBB, 0x9D, 0x39, 0x84, 0x8B,
  0xC2, 0xF5, 0x29, 0x84, 0x8B, 0xC0, 0xBB, 0x29, 0x89, 0x28, 0xBC, 0x04, 0xF3, 0x0F, 0x8B, 0xC2,
  0x85, 0xC9, 0x0F, 0x8B, 0xC2, 0x85, 0x6F, 0x1F, 0x8B, 0xC3, 0x84, 0xE7, 0xE8, 0xBC, 0x38, 0x48,
  0xDE, 0x8B, 0xC3, 0x01, 0xA8, 0x18, 0xBC, 0x48, 0x19, 0xF8,
  // "ň" (U+0148)
  0x28, 0x56, 0xD2, 0x05, 0xE3, 0x38, 0x38, 0xE8, 0xF5, 0x58, 0x1B, 0xF8, 0x74, 0x8A, 0x38, 0xC1,
  0xAE, 0xEB, 0x30, 0x8E, 0xC9, 0x57, 0xEE, 0x18, 0xF9, 0x38, 0x46, 0xF4, 0x8F, 0x33, 0x84, 0x3F,
  0x68, 0xF1, 0x38, 0x42, 0xF7, 0x8F, 0x13, 0x84, 0x2F, 0x78, 0xF1, 0x38, 0x42, 0xF7, 0x8F, 0x13,
  0x84, 0x2F, 0x78, 0xF1, 0x38, 0x42, 0xF7, 0x8F, 0x13, 0x81, 0x2F, 0x70,
  // "ŉ" (U+0149)
  0x81, 0x1F, 0xD7, 0x18, 0x14, 0xF7, 0x71, 0x81, 0x8F, 0x17, 0x18, 0x90, 0xC9, 0x4F, 0x3A, 0xEE,
  0xB3, 0x38, 0x74, 0xFE, 0x71, 0x2C, 0xE1, 0x28, 0x14, 0xFB, 0x38, 0x15, 0xF4, 0x28, 0x14, 0xF6,
  0x38, 0x12, 0xF6, 0x28, 0x14, 0xF5, 0x38, 0x12, 0xF7, 0x28, 0x14, 0xF5, 0x38, 0x12, 0xF7, 0x28,
  0x14, 0xF5, 0x38, 0x12, 0xF7, 0x28, 0x14, 0xF5, 0x38, 0x12, 0xF7, 0x28, 0x14, 0xF5, 0x38, 0x12,
  0xF7, 0x28, 0x14, 0xF5, 0x38, 0x12, 0xF7,
  // "Ŋ" (U+014A)
  0x81, 0xBF, 0x94, 0x90, 0x80, 0xBA, 0x01, 0x39, 0x83, 0x8B, 0xBE, 0x73, 0x98, 0x38, 0xBB, 0x9D,
  0x39, 0x84, 0x8B, 0xC2, 0xF5, 0x29, 0x84, 0x8B, 0xC0, 0xBB, 0x29, 0x89, 0x28, 0xBC, 0x04, 0xF3,
  0x0F, 0x8B, 0xC2, 0x85, 0xC9, 0x0F, 0x8B, 0xC2, 0x85, 0x6F, 0x1F, 0x8B, 0xC3, 0x84, 0xE7, 0xE8,
  0xBC, 0x38, 0x48, 0xDE, 0x8B, 0xC3, 0x01, 0xA8, 0x18, 0xBC, 0x48, 0x19, 0xF8, 0x79, 0x06, 0x48,
  0x32, 0x29, 0xF2, 0x30, 0x3A, 0x0E, 0x06, 0x50, 0x03, 0x30,
  // "ŋ" (U+014B)
  0x8A, 0x38, 0xC1, 0xAE, 0xEB, 0x30, 0x8E, 0xC9, 0x57, 0xEE, 0x18, 0xF9, 0x38, 0x45, 0xF5, 0x8F,
  0x33, 0x84, 0x3F, 0x68, 0xF1, 0x38, 0x42, 0xF7, 0x8F, 0x13, 0x84, 0x2F, 0x78, 0xF1, 0x38, 0x42,
  0xF7, 0x8F, 0x13, 0x84, 0x2F, 0x78, 0xF1, 0x38, 0x42, 0xF7, 0x8F, 0x13, 0x81, 0x2F, 0x76, 0x81,
  0x2F, 0x76, 0x81, 0x3F, 0x64, 0x83, 0x25, 0xBF, 0x24, 0x82, 0x5F, 0xD6, 0x10,
  // "Ō" (U+014C)
  0x38, 0x01, 0x14, 0x04, 0xD0, 0x13, 0x01, 0x80, 0x13, 0x77, 0x84, 0x18, 0xDE, 0xD7, 0x48, 0x5C,
  0xE7, 0x58, 0xF9, 0x28, 0x16, 0xF4, 0x38, 0x47, 0xF3, 0x0C, 0xD4, 0x84, 0x1F, 0x90, 0xF9, 0x58,
  0x3C, 0xC1, 0xF7, 0x58, 0x3B, 0xE2, 0xF7, 0x58, 0x3A, 0xF1, 0xF7, 0x58, 0x3B, 0xE0, 0xF9, 0x58,
  0x3C, 0xC0, 0xCD, 0x48, 0x51, 0xF9, 0x06, 0xF4, 0x38, 0x17, 0xF3, 0x28, 0x5C, 0xE7, 0x58, 0xF9,
  0x38, 0x41, 0x8D, 0xED, 0x72,
  // "ō" (U+014D)
  0x28, 0x01, 0x13, 0x04, 0xD0, 0x12, 0x01, 0x80, 0x13, 0x75, 0x84, 0x19, 0xDF, 0xD7, 0x28, 0x92,
  0x1D, 0xE7, 0x59, 0xFA, 0x08, 0xF3, 0x38, 0x37, 0xF4, 0xDC, 0x59, 0x81, 0x9F, 0xA5, 0x82, 0xDB,
  0xFA, 0x58, 0x2D, 0xBD, 0xC5, 0x98, 0x2A, 0x8F, 0x33, 0x89, 0x17, 0xF5, 0x0D, 0xE8, 0x59, 0xFB,
  0x28, 0x41, 0x9D, 0xFD, 0x72,
  // "Ŏ" (U+014E)
  0x20, 0x10, 0x23, 0x03, 0x48, 0x33, 0xE4, 0x16, 0x95, 0x09, 0xB0, 0x66, 0x81, 0x13, 0x15, 0x84,
  0x18, 0xDE, 0xD7, 0x48, 0x5C, 0xE7, 0x58, 0xF9, 0x28, 0x16, 0xF4, 0x38, 0x47, 0xF3, 0x0C, 0xD4,
  0x84, 0x1F, 0x90, 0xF9, 0x58, 0x3C, 0xC1, 0xF7, 0x58, 0x3B, 0xE2, 0xF7, 0x58, 0x3A, 0xF1, 0xF7,
  0x58, 0x3B, 0xE0, 0xF9, 0x58, 0x3C, 0xC0, 0xCD, 0x48, 0x51, 0xF9, 0x06, 0xF4, 0x38, 0x17, 0xF3,
  0x28, 0x5C, 0xE7, 0x58, 0xF9, 0x38, 0x41, 0x8D, 0xED, 0x72,
  // "ŏ" (U+014F)
  0x10, 0x10, 0x23, 0x03, 0x38, 0x33, 0xE4, 0x16, 0x94, 0x09, 0xB0, 0x65, 0x81, 0x13, 0x14, 0x84,
  0x19, 0xDF, 0xD7, 0x28, 0x92, 0x1D, 0xE7, 0x59, 0xFA, 0x08, 0xF3, 0x38, 0x37, 0xF4, 0xDC, 0x59,
  0x81, 0x9F, 0xA5, 0x82, 0xDB, 0xFA, 0x58, 0x2D, 0xBD, 0xC5, 0x98, 0x2A, 0x8F, 0x33, 0x89, 0x17,
  0xF5, 0x0D, 0xE8, 0x59, 0xFB, 0x28, 0x41, 0x9D, 0xFD, 0x72,
  // "Ő" (U+0150)
  0x38, 0x4C, 0xC0, 0xAD, 0x13, 0x84, 0x6E, 0x23, 0xF4, 0x38, 0x41, 0xD4, 0x0C, 0x67, 0x71, 0x84,
  0x18, 0xDE, 0xD7, 0x48, 0x5C, 0xE7, 0x58, 0xF9, 0x28, 0x16, 0xF4, 0x38, 0x47, 0xF3, 0x0C, 0xD4,
  0x84, 0x1F, 0x90, 0xF9, 0x58, 0x3C, 0xC1, 0xF7, 0x58, 0x3B, 0xE2, 0xF7, 0x58, 0x3A, 0xF1, 0xF7,
  0x58, 0x3B, 0xE0, 0xF9, 0x58, 0x3C, 0xC0, 0xCD, 0x48, 0x51, 0xF9, 0x06, 0xF4, 0x38, 0x17, 0xF3,
  0x28, 0x5C, 0xE7, 0x58, 0xF9, 0x38, 0x41, 0x8D, 0xED, 0x72,
  // "ő" (U+0151)
  0x28, 0x4C, 0xC0, 0xAD, 0x12, 0x84, 0x6E, 0x23, 0xF4, 0x28, 0x41, 0xD4, 0x0C, 0x67, 0x68, 0x41,
  0x9D, 0xFD, 0x72, 0x89, 0x21, 0xDE, 0x75, 0x9F, 0xA0, 0x8F, 0x33, 0x83, 0x7F, 0x4D, 0xC5, 0x98,
  0x19, 0xFA, 0x58, 0x2D, 0xBF, 0xA5, 0x82, 0xDB, 0xDC, 0x59, 0x82, 0xA8, 0xF3, 0x38, 0x91, 0x7F,
  0x50, 0xDE, 0x85, 0x9F, 0xB2, 0x84, 0x19, 0xDF, 0xD7, 0x20,
  // "Œ" (U+0152)
  0x20, 0x40, 0xCE, 0x89, 0x54, 0x03, 0xFA, 0x5A, 0xF6, 0x55, 0x10, 0xAE, 0x28, 0x16, 0xF2, 0x40,
  0xE0, 0x92, 0x81, 0x6F, 0x23, 0x81, 0x2F, 0x72, 0x87, 0x6F, 0x31, 0x10, 0x3F, 0x62, 0x06, 0xB8,
  0x3E, 0x04, 0xF5, 0x28, 0x76, 0xF5, 0x33, 0x03, 0xF6, 0x28, 0x16, 0xF2, 0x38, 0x12, 0xF7, 0x28,
  0x16, 0xF2, 0x49, 0x09, 0x28, 0x16, 0xF2, 0x40, 0xA0, 0xE2, 0x81, 0x6F, 0x24, 0x89, 0x03, 0xFA,
  0x5A, 0xF6, 0x55, 0x12, 0x05, 0x0D, 0xE0, 0x40,
  // "œ" (U+0153)
  0x18, 0x73, 0xCE, 0xA0, 0x6E, 0xD4, 0x28, 0xA5, 0xDC, 0x6D, 0xAF, 0x7A, 0xE0, 0x5F, 0x20, 0x5F,
  0xA0, 0x1F, 0x38, 0xE2, 0x87, 0x1F, 0x81, 0x1E, 0x69, 0xD3, 0xD8, 0x16, 0x9D, 0x39, 0x85, 0x83,
  0x33, 0x17, 0xE2, 0x81, 0x1F, 0x74, 0x85, 0x4F, 0x30, 0x4F, 0xB5, 0x8A, 0x2D, 0xC6, 0xDA, 0xF9,
  0x5A, 0x10, 0x2C, 0xFA, 0x05, 0xDE, 0x91,
  // "Ŕ" (U+0154)
  0x48, 0x12, 0xFC, 0x68, 0x1B, 0xD1, 0x58, 0x15, 0xD2, 0x75, 0x04, 0xB8, 0x1E, 0xC7, 0x28, 0x92,
  0x4F, 0x85, 0x6A, 0xFA, 0x04, 0xF5, 0x38, 0x4A, 0xF1, 0x4F, 0x53, 0x84, 0x7F, 0x34, 0xF5, 0x38,
  0x93, 0x9F, 0x14, 0xF5, 0x12, 0x7F, 0x80, 0x4C, 0x0E, 0x06, 0x28, 0x54, 0xF7, 0x39, 0xF3, 0x28,
  0x14, 0xF5, 0x20, 0xE0, 0xB2, 0x81, 0x4F, 0x52, 0x85, 0x6F, 0x40, 0x4F, 0x53, 0x84, 0xDC, 0x04,
  0xF5, 0x38, 0x45, 0xF6, 0x4F, 0x54, 0x0C, 0x0E,
  // "ŕ" (U+0155)
  0x58, 0x12, 0xFC, 0x78, 0x1B, 0xD1, 0x68, 0x15, 0xD2, 0x76, 0x09, 0xB8, 0x95, 0x63, 0xDF, 0xE2,
  0x25, 0x7F, 0x9E, 0x85, 0x94, 0x81, 0xEF, 0x67, 0x00, 0xE7, 0x10, 0xE0, 0xB7, 0x10, 0xE0, 0xA7,
  0x10, 0xE0, 0xA7, 0x10, 0xE0, 0xA5, 0x85, 0x13, 0x4F, 0xC4, 0x23, 0x0D, 0xE0, 0x72,
  // "Ŗ" (U+0156)
  0x04, 0xB8, 0x1E, 0xC7, 0x28, 0x92, 0x4F, 0x85, 0x6A, 0xFA, 0x04, 0xF5, 0x38, 0x4A, 0xF1, 0x4F,
  0x53, 0x84, 0x7F, 0x34, 0xF5, 0x38, 0x93, 0x9F, 0x14, 0xF5, 0x12, 0x7F, 0x80, 0x4C, 0x0E, 0x06,
  0x28, 0x54, 0xF7, 0x39, 0xF3, 0x28, 0x14, 0xF5, 0x20, 0xE0, 0xB2, 0x81, 0x4F, 0x52, 0x85, 0x6F,
  0x40, 0x4F, 0x53, 0x84, 0xDC, 0x04, 0xF5, 0x38, 0x45, 0xF6, 0x4F, 0x54, 0x0C, 0x0E, 0x76, 0x0C,
  0x09, 0x68, 0x11, 0xF4, 0x60, 0x50, 0xA4,
  // "ŗ" (U+0157)
  0x09, 0xB8, 0x95, 0x63, 0xDF, 0xE2, 0x25, 0x7F, 0x9E, 0x85, 0x94, 0x81, 0xEF, 0x67, 0x00, 0xE7,
  0x10, 0xE0, 0xB7, 0x10, 0xE0, 0xA7, 0x10, 0xE0, 0xA7, 0x10, 0xE0, 0xA5, 0x85, 0x13, 0x4F, 0xC4,
  0x23, 0x0D, 0xE0, 0x77, 0x71, 0x0C, 0x09, 0x78, 0x11, 0xF4, 0x70, 0x50, 0xA6,
  // "Ř" (U+0158)
  0x18, 0x56, 0xD2, 0x05, 0xE3, 0x38, 0x38, 0xE8, 0xF5, 0x58, 0x1B, 0xF8, 0x75, 0x04, 0xB8, 0x1E,
  0xC7, 0x28, 0x92, 0x4F, 0x85, 0x6A, 0xFA, 0x04, 0xF5, 0x38, 0x4A, 0xF1, 0x4F, 0x53, 0x84, 0x7F,
  0x34, 0xF5, 0x38, 0x93, 0x9F, 0x14, 0xF5, 0x12, 0x7F, 0x80, 0x4C, 0x0E, 0x06, 0x28, 0x54, 0xF7,
  0x39, 0xF3, 0x28, 0x14, 0xF5, 0x20, 0xE0, 0xB2, 0x81, 0x4F, 0x52, 0x85, 0x6F, 0x40, 0x4F, 0x53,
  0x84, 0xDC, 0x04, 0xF5, 0x38, 0x45, 0xF6, 0x4F, 0x54, 0x0C, 0x0E,
  // "ř" (U+0159)
  0x28, 0x56, 0xD2, 0x05, 0xE3, 0x48, 0x38, 0xE8, 0xF5, 0x68, 0x1B, 0xF8, 0x76, 0x09, 0xB8, 0x95,
  0x63, 0xDF, 0xE2, 0x25, 0x7F, 0x9E, 0x85, 0x94, 0x81, 0xEF, 0x67, 0x00, 0xE7, 0x10, 0xE0, 0xB7,
  0x10, 0xE0, 0xA7, 0x10, 0xE0, 0xA7, 0x10, 0xE0, 0xA5, 0x85, 0x13, 0x4F, 0xC4, 0x23, 0x0D, 0xE0,
  0x72,
  // "Ś" (U+015A)
  0x58, 0x12, 0xFC, 0x68, 0x1B, 0xD1, 0x58, 0x15, 0xD2, 0x76, 0x8A, 0x16, 0xCE, 0xEC, 0x81, 0x09,
  0xF9, 0x56, 0x9D, 0x01, 0xFA, 0x68, 0x12, 0xF7, 0x78, 0x1E, 0xD1, 0x68, 0x36, 0xFE, 0x81, 0x50,
  0x30, 0xBA, 0x09, 0x01, 0x58, 0x23, 0xBF, 0xD7, 0x81, 0x7F, 0x56, 0x81, 0x2F, 0x76, 0x8A, 0x26,
  0xF5, 0x7B, 0x86, 0x58, 0xFC, 0x03, 0xAD, 0xEF, 0xD8, 0x11,
  // "ś" (U+015B)
  0x48, 0x12, 0xFC, 0x58, 0x1B, 0xD1, 0x48, 0x15, 0xD2, 0x75, 0x89, 0x78, 0xDF, 0xEC, 0x50, 0x9F,
  0x75, 0x69, 0x50, 0xEA, 0x68, 0x1B, 0xE5, 0x58, 0x31, 0xBF, 0xD6, 0x58, 0x33, 0xAF, 0xD3, 0x58,
  0x12, 0xEC, 0x68, 0x97, 0xCC, 0x1D, 0x85, 0x59, 0xF8, 0x09, 0xDE, 0xEC, 0x71,
  // "Ŝ" (U+015C)
  0x48, 0x1B, 0xF8, 0x58, 0x38, 0xE7, 0xF4, 0x38, 0x55, 0xD2, 0x05, 0xE3, 0x74, 0x8A, 0x16, 0xCE,
  0xEC, 0x81, 0x09, 0xF9, 0x56, 0x9D, 0x01, 0xFA, 0x68, 0x12, 0xF7, 0x78, 0x1E, 0xD1, 0x68, 0x36,
  0xFE, 0x81, 0x50, 0x30, 0xBA, 0x09, 0x01, 0x58, 0x23, 0xBF, 0xD7, 0x81, 0x7F, 0x56, 0x81, 0x2F,
  0x76, 0x8A, 0x26, 0xF5, 0x7B, 0x86, 0x58, 0xFC, 0x03, 0xAD, 0xEF, 0xD8, 0x11,
  // "ŝ" (U+015D)
  0x38, 0x1B, 0xF8, 0x48, 0x38, 0xE7, 0xF4, 0x28, 0x55, 0xD2, 0x05, 0xE3, 0x73, 0x89, 0x78, 0xDF,
  0xEC, 0x50, 0x9F, 0x75, 0x69, 0x50, 0xEA, 0x68, 0x1B, 0xE5, 0x58, 0x31, 0xBF, 0xD6, 0x58, 0x33,
  0xAF, 0xD3, 0x58, 0x12, 0xEC, 0x68, 0x97, 0xCC, 0x1D, 0x85, 0x59, 0xF8, 0x09, 0xDE, 0xEC, 0x71,
  // "Ş" (U+015E)
  0x28, 0xA1, 0x6C, 0xEE, 0xC8, 0x10, 0x9F, 0x95, 0x69, 0xD0, 0x1F, 0xA6, 0x81, 0x2F, 0x77, 0x81,
  0xED, 0x16, 0x83, 0x6F, 0xE8, 0x15, 0x03, 0x0B, 0xA0, 0x90, 0x15, 0x82, 0x3B, 0xFD, 0x78, 0x17,
  0xF5, 0x68, 0x12, 0xF7, 0x68, 0x95, 0x6F, 0x57, 0xB8, 0x65, 0x8F, 0xC0, 0x3A, 0xDA, 0x81, 0xD8,
  0x14, 0x07, 0x0C, 0x78, 0x13, 0xAD, 0x78, 0x14, 0xF1, 0x48, 0x26, 0xFD, 0x63,
  // "ş" (U+015F)
  0x28, 0x97, 0x8D, 0xFE, 0xC5, 0x09, 0xF7, 0x56, 0x95, 0x0E, 0xA6, 0x81, 0xBE, 0x55, 0x83, 0x1B,
  0xFD, 0x65, 0x83, 0x3A, 0xFD, 0x35, 0x81, 0x2E, 0xC6, 0x89, 0x3C, 0xC1, 0xD8, 0x55, 0x9F, 0x80,
  0x9D, 0xA0, 0xC0, 0x74, 0x07, 0x0C, 0x68, 0x13, 0xAD, 0x68, 0x14, 0xF1, 0x38, 0x26, 0xFD, 0x62,
  // "Š" (U+0160)
  0x28, 0x56, 0xD2, 0x05, 0xE3, 0x38, 0x38, 0xE8, 0xF5, 0x58, 0x1B, 0xF8, 0x76, 0x8A, 0x16, 0xCE,
  0xEC, 0x81, 0x09, 0xF9, 0x56, 0x9D, 0x01, 0xFA, 0x68, 0x12, 0xF7, 0x78, 0x1E, 0xD1, 0x68, 0x36,
  0xFE, 0x81, 0x50, 0x30, 0xBA, 0x09, 0x01, 0x58, 0x23, 0xBF, 0xD7, 0x81, 0x7F, 0x56, 0x81, 0x2F,
  0x76, 0x8A, 0x26, 0xF5, 0x7B, 0x86, 0x58, 0xFC, 0x03, 0xAD, 0xEF, 0xD8, 0x11,
  // "š" (U+0161)
  0x18, 0x56, 0xD2, 0x05, 0xE3, 0x28, 0x38, 0xE8, 0xF5, 0x48, 0x1B, 0xF8, 0x75, 0x89, 0x78, 0xDF,
  0xEC, 0x50, 0x9F, 0x75, 0x69, 0x50, 0xEA, 0x68, 0x1B, 0xE5, 0x58, 0x31, 0xBF, 0xD6, 0x58, 0x33,
  0xAF, 0xD3, 0x58, 0x12, 0xEC, 0x68, 0x97, 0xCC, 0x1D, 0x85, 0x59, 0xF8, 0x09, 0xDE, 0xEC, 0x71,
  // "Ţ" (U+0162)
  0x02, 0xFA, 0x10, 0xF5, 0x81, 0x9F, 0x70, 0xF5, 0x48, 0x16, 0xF3, 0x78, 0x16, 0xF3, 0x78, 0x16,
  0xF3, 0x78, 0x16, 0xF3, 0x78, 0x16, 0xF3, 0x78, 0x16, 0xF3, 0x78, 0x16, 0xF3, 0x78, 0x16, 0xF3,
  0x78, 0x16, 0xF3, 0x78, 0x16, 0xF3, 0x78, 0x17, 0xF3, 0x70, 0x70, 0xC7, 0x18, 0x13, 0xAD, 0x71,
  0x81, 0x4F, 0x15, 0x82, 0x6F, 0xD6, 0x30,
  // "ţ" (U+0163)
  0x30, 0x70, 0x16, 0x81, 0x2F, 0x36, 0x81, 0x4F, 0x34, 0x0C, 0x0E, 0xE1, 0x83, 0x55, 0x8F, 0x70,
  0xF5, 0x38, 0x15, 0xF3, 0x68, 0x15, 0xF3, 0x68, 0x15, 0xF3, 0x68, 0x15, 0xF3, 0x68, 0x15, 0xF4,
  0x68, 0x14, 0xF6, 0x78, 0x4E, 0xE7, 0x56, 0x23, 0x03, 0x0B, 0xA0, 0xD0, 0x35, 0x07, 0x0C, 0x78,
  0x13, 0xAD, 0x78, 0x14, 0xF1, 0x48, 0x26, 0xFD, 0x61,
  // "Ť" (U+0164)
  0x28, 0x56, 0xD2, 0x05, 0xE3, 0x48, 0x38, 0xE8, 0xF5, 0x68, 0x1B, 0xF8, 0x76, 0x02, 0xFA, 0x10,
  0xF5, 0x81, 0x9F, 0x70, 0xF5, 0x48, 0x16, 0xF3, 0x78, 0x16, 0xF3, 0x78, 0x16, 0xF3, 0x78, 0x16,
  0xF3, 0x78, 0x16, 0xF3, 0x78, 0x16, 0xF3, 0x78, 0x16, 0xF3, 0x78, 0x16, 0xF3, 0x78, 0x16, 0xF3,
  0x78, 0x16, 0xF3, 0x78, 0x16, 0xF3, 0x30,
  // "ť" (U+0165)
  0x68, 0x16, 0xF1, 0x38, 0x34, 0x10, 0x9A, 0x38, 0x42, 0xF3, 0x0C, 0x23, 0x81, 0x4F, 0x34, 0x0C,
  0x0E, 0xE1, 0x83, 0x55, 0x8F, 0x70, 0xF5, 0x38, 0x15, 0xF3, 0x68, 0x15, 0xF3, 0x68, 0x15, 0xF3,
  0x68, 0x15, 0xF3, 0x68, 0x15, 0xF4, 0x68, 0x14, 0xF6, 0x78, 0x4E, 0xE7, 0x56, 0x23, 0x84, 0x3B,
  0xEF, 0xD3,
  // "Ŧ" (U+0166)
  0x02, 0xFA, 0x10, 0xF5, 0x81, 0x9F, 0x70, 0xF5, 0x48, 0x16, 0xF3, 0x78, 0x16, 0xF3, 0x78, 0x16,
  0xF3, 0x58, 0x51, 0x17, 0xF4, 0x11, 0x20, 0x1E, 0x0D, 0x38, 0x53, 0x38, 0xF6, 0x33, 0x58, 0x16,
  0xF3, 0x78, 0x16, 0xF3, 0x78, 0x16, 0xF3, 0x78, 0x16, 0xF3, 0x78, 0x16, 0xF3, 0x30,
  // "ŧ" (U+0167)
  0x30, 0x70, 0x16, 0x81, 0x2F, 0x36, 0x81, 0x4F, 0x34, 0x0C, 0x0E, 0xE1, 0x83, 0x55, 0x8F, 0x70,
  0xF5, 0x38, 0x15, 0xF3, 0x48, 0x31, 0x16, 0xF4, 0x0F, 0x11, 0xF9, 0x89, 0x04, 0x33, 0x8F, 0x63,
  0x33, 0x12, 0x81, 0x5F, 0x36, 0x81, 0x4F, 0x56, 0x85, 0x1F, 0xD7, 0x56, 0x23, 0x84, 0x4B, 0xEF,
  0xD3,
  // "Ũ" (U+0168)
  0x18, 0x52, 0xDF, 0x82, 0x97, 0x28, 0x5A, 0x95, 0xDF, 0xE1, 0x20, 0x33, 0x02, 0x01, 0x20, 0xB0,
  0xD4, 0x83, 0x1F, 0x8B, 0xD4, 0x83, 0x1F, 0x8B, 0xD4, 0x83, 0x1F, 0x8B, 0xD4, 0x83, 0x1F, 0x8B,
  0xD4, 0x83, 0x1F, 0x8B, 0xD4, 0x83, 0x1F, 0x8B, 0xD4, 0x83, 0x1F, 0x8B, 0xD4, 0x83, 0x1F, 0x8B,
  0xE4, 0x82, 0x1F, 0x89, 0x94, 0x84, 0x3F, 0x66, 0xF4, 0x38, 0x91, 0x7F, 0x20, 0xDE, 0x75, 0x8F,
  0xA2, 0x84, 0x19, 0xEF, 0xD8, 0x20,
  // "ũ" (U+0169)
  0x18, 0x52, 0xDF, 0x82, 0x97, 0x28, 0x5A, 0x95, 0xDF, 0xE1, 0x20, 0x33, 0x02, 0x01, 0x20, 0xA9,
  0x48, 0x24, 0xF5, 0xA9, 0x48, 0x24, 0xF5, 0xA9, 0x48, 0x24, 0xF5, 0xA9, 0x48, 0x24, 0xF5, 0xA9,
  0x48, 0x24, 0xF5, 0xA9, 0x48, 0x24, 0xF5, 0x99, 0x48, 0x46, 0xF5, 0x8F, 0x23, 0x8A, 0x3C, 0xF5,
  0x3F, 0xD6, 0x6B, 0xDF, 0x50, 0x5C, 0xEE, 0x91, 0xF5,
  // "Ū" (U+016A)
  0x28, 0x01, 0x13, 0x04, 0xD0, 0x12, 0x01, 0x80, 0x13, 0x74, 0x0B, 0x0D, 0x48, 0x31, 0xF8, 0xBD,
  0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31, 0xF8, 0xBD,
  0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31, 0xF8, 0xBE, 0x48, 0x21, 0xF8, 0x99,
  0x48, 0x43, 0xF6, 0x6F, 0x43, 0x89, 0x17, 0xF2, 0x0D, 0xE7, 0x58, 0xFA, 0x28, 0x41, 0x9E, 0xFD,
  0x82,
  // "ū" (U+016B)
  0x28, 0x01, 0x13, 0x04, 0xD0, 0x12, 0x01, 0x80, 0x13, 0x74, 0x0A, 0x94, 0x82, 0x4F, 0x5A, 0x94,
  0x82, 0x4F, 0x5A, 0x94, 0x82, 0x4F, 0x5A, 0x94, 0x82, 0x4F, 0x5A, 0x94, 0x82, 0x4F, 0x5A, 0x94,
  0x82, 0x4F, 0x59, 0x94, 0x84, 0x6F, 0x58, 0xF2, 0x38, 0xA3, 0xCF, 0x53, 0xFD, 0x66, 0xBD, 0xF5,
  0x05, 0xCE, 0xE9, 0x1F, 0x50,
  // "Ŭ" (U+016C)
  0x10, 0x10, 0x23, 0x03, 0x38, 0x33, 0xE4, 0x16, 0x94, 0x09, 0xB0, 0x65, 0x81, 0x13, 0x13, 0x0B,
  0x0D, 0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31, 0xF8,
  0xBD, 0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31, 0xF8,
  0xBE, 0x48, 0x21, 0xF8, 0x99, 0x48, 0x43, 0xF6, 0x6F, 0x43, 0x89, 0x17, 0xF2, 0x0D, 0xE7, 0x58,
  0xFA, 0x28, 0x41, 0x9E, 0xFD, 0x82,
  // "ŭ" (U+016D)
  0x10, 0x10, 0x23, 0x03, 0x38, 0x33, 0xE4, 0x16, 0x94, 0x09, 0xB0, 0x65, 0x81, 0x13, 0x13, 0x0A,
  0x94, 0x82, 0x4F, 0x5A, 0x94, 0x82, 0x4F, 0x5A, 0x94, 0x82, 0x4F, 0x5A, 0x94, 0x82, 0x4F, 0x5A,
  0x94, 0x82, 0x4F, 0x5A, 0x94, 0x82, 0x4F, 0x59, 0x94, 0x84, 0x6F, 0x58, 0xF2, 0x38, 0xA3, 0xCF,
  0x53, 0xFD, 0x66, 0xBD, 0xF5, 0x05, 0xCE, 0xE9, 0x1F, 0x50,
  // "Ů" (U+016E)
  0x28, 0x21, 0xDF, 0xA5, 0x83, 0x7B, 0x5D, 0x44, 0x83, 0x79, 0x2C, 0x44, 0x82, 0x2E, 0xFC, 0x60,
  0x10, 0x34, 0x0B, 0x0D, 0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31, 0xF8, 0xBD,
  0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31, 0xF8, 0xBD,
  0x48, 0x31, 0xF8, 0xBE, 0x48, 0x21, 0xF8, 0x99, 0x48, 0x43, 0xF6, 0x6F, 0x43, 0x89, 0x17, 0xF2,
  0x0D, 0xE7, 0x58, 0xFA, 0x28, 0x41, 0x9E, 0xFD, 0x82,
  // "ů" (U+016F)
  0x28, 0x21, 0xDF, 0xA5, 0x83, 0x7B, 0x5D, 0x44, 0x83, 0x79, 0x2C, 0x44, 0x82, 0x2E, 0xFC, 0x60,
  0x10, 0x34, 0x0A, 0x94, 0x82, 0x4F, 0x5A, 0x94, 0x82, 0x4F, 0x5A, 0x94, 0x82, 0x4F, 0x5A, 0x94,
  0x82, 0x4F, 0x5A, 0x94, 0x82, 0x4F, 0x5A, 0x94, 0x82, 0x4F, 0x59, 0x94, 0x84, 0x6F, 0x58, 0xF2,
  0x38, 0xA3, 0xCF, 0x53, 0xFD, 0x66, 0xBD, 0xF5, 0x05, 0xCE, 0xE9, 0x1F, 0x50,
  // "Ű" (U+0170)
  0x28, 0x4C, 0xC0, 0xAD, 0x12, 0x84, 0x6E, 0x23, 0xF4, 0x28, 0x41, 0xD4, 0x0C, 0x67, 0x50, 0xB0,
  0xD4, 0x83, 0x1F, 0x8B, 0xD4, 0x83, 0x1F, 0x8B, 0xD4, 0x83, 0x1F, 0x8B, 0xD4, 0x83, 0x1F, 0x8B,
  0xD4, 0x83, 0x1F, 0x8B, 0xD4, 0x83, 0x1F, 0x8B, 0xD4, 0x83, 0x1F, 0x8B, 0xD4, 0x83, 0x1F, 0x8B,
  0xE4, 0x82, 0x1F, 0x89, 0x94, 0x84, 0x3F, 0x66, 0xF4, 0x38, 0x91, 0x7F, 0x20, 0xDE, 0x75, 0x8F,
  0xA2, 0x84, 0x19, 0xEF, 0xD8, 0x20,
  // "ű" (U+0171)
  0x28, 0x4C, 0xC0, 0xAD, 0x12, 0x84, 0x6E, 0x23, 0xF4, 0x28, 0x41, 0xD4, 0x0C, 0x67, 0x50, 0xA9,
  0x48, 0x24, 0xF5, 0xA9, 0x48, 0x24, 0xF5, 0xA9, 0x48, 0x24, 0xF5, 0xA9, 0x48, 0x24, 0xF5, 0xA9,
  0x48, 0x24, 0xF5, 0xA9, 0x48, 0x24, 0xF5, 0x99, 0x48, 0x46, 0xF5, 0x8F, 0x23, 0x8A, 0x3C, 0xF5,
  0x3F, 0xD6, 0x6B, 0xDF, 0x50, 0x5C, 0xEE, 0x91, 0xF5,
  // "Ų" (U+0172)
  0x0B, 0x0D, 0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31,
  0xF8, 0xBD, 0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31, 0xF8, 0xBD, 0x48, 0x31,
  0xF8, 0xBE, 0x48, 0x21, 0xF8, 0x99, 0x48, 0x43, 0xF6, 0x6F, 0x43, 0x89, 0x17, 0xF2, 0x0D, 0xE7,
  0x58, 0xFA, 0x28, 0x11, 0x9E, 0xA0, 0x75, 0x81, 0x2D, 0x36, 0x0A, 0x08, 0x78, 0x1B, 0xC5, 0x68,
  0x24, 0xDE, 0x22,
  // "ų" (U+0173)
  0x0A, 0x94, 0x82, 0x4F, 0x5A, 0x94, 0x82, 0x4F, 0x5A, 0x94, 0x82, 0x4F, 0x5A, 0x94, 0x82, 0x4F,
  0x5A, 0x94, 0x82, 0x4F, 0x5A, 0x94, 0x82, 0x4F, 0x59, 0x94, 0x84, 0x6F, 0x58, 0xF2, 0x38, 0xA3,
  0xCF, 0x53, 0xFD, 0x66, 0xBD, 0xF5, 0x05, 0xCE, 0xE9, 0x1F, 0x66, 0x81, 0x2D, 0x26, 0x0B, 0x06,
  0x79, 0x07, 0x01, 0x68, 0x1B, 0xFE, 0x70, 0x30, 0x20,
  // "Ŵ" (U+0174)
  0x48, 0x1B, 0xF8, 0x78, 0x38, 0xE7, 0xF4, 0x58, 0x55, 0xD2, 0x05, 0xE3, 0x76, 0x07, 0x96, 0x84,
  0x2F, 0x45, 0xF1, 0x58, 0x44, 0xF3, 0x4F, 0x25, 0x89, 0x25, 0xF1, 0x2F, 0x40, 0x7F, 0x40, 0x69,
  0x29, 0x86, 0x50, 0xAF, 0x80, 0x8D, 0x28, 0x7E, 0x70, 0xEA, 0xB0, 0x9C, 0x28, 0x7C, 0x82, 0xF4,
  0xF0, 0xAA, 0x28, 0x7B, 0x95, 0xD0, 0xE3, 0xB9, 0x28, 0x79, 0xB8, 0x90, 0xB7, 0xC7, 0x28, 0x77,
  0xCC, 0x60, 0x7A, 0xD6, 0x28, 0x76, 0xDF, 0x20, 0x4D, 0xE4, 0x28, 0x14, 0xFE, 0x3A, 0x03, 0x28,
  0x12, 0xFB, 0x38, 0x1C, 0xF1, 0x10,
  // "ŵ" (U+0175)
  0x48, 0x1B, 0xF8, 0x78, 0x38, 0xE7, 0xF4, 0x58, 0x55, 0xD2, 0x05, 0xE3, 0x76, 0x0A, 0x0D, 0x79,
  0x00, 0x79, 0x30, 0x12, 0x8A, 0x52, 0xF4, 0x5F, 0x20, 0xAF, 0x60, 0x5F, 0x22, 0xF4, 0x0E, 0xEB,
  0x07, 0x92, 0x98, 0x66, 0x3F, 0x7E, 0x09, 0xC2, 0x87, 0xD8, 0x7D, 0x1F, 0x3C, 0xA2, 0x87, 0xBA,
  0xB9, 0x0D, 0x7D, 0x72, 0x87, 0x8B, 0xE5, 0x09, 0xAF, 0x52, 0x87, 0x6E, 0xF1, 0x05, 0xEF, 0x22,
  0x81, 0x3F, 0xD2, 0x01, 0xA2,
  // "Ŷ" (U+0176)
  0x48, 0x1B, 0xF8, 0x68, 0x38, 0xE7, 0xF4, 0x48, 0x55, 0xD2, 0x05, 0xE3, 0x74, 0x81, 0x2F, 0x95,
  0x84, 0xCD, 0x09, 0xF1, 0x38, 0x53, 0xF6, 0x02, 0xF8, 0x30, 0xA0, 0xD3, 0x09, 0x0E, 0x28, 0x12,
  0xF6, 0x38, 0x42, 0xF7, 0x09, 0xD5, 0x83, 0x9D, 0x1F, 0x65, 0x82, 0x2F, 0xCD, 0x78, 0x19, 0xF6,
  0x78, 0x15, 0xF2, 0x78, 0x15, 0xF2, 0x78, 0x15, 0xF2, 0x78, 0x15, 0xF2, 0x78, 0x15, 0xF2, 0x30,
  // "ŷ" (U+0177)
  0x38, 0x1B, 0xF8, 0x58, 0x38, 0xE7, 0xF4, 0x38, 0x55, 0xD2, 0x05, 0xE3, 0x73, 0x0E, 0x09, 0x58,
  0x2D, 0xC8, 0xE4, 0x84, 0x3F, 0x62, 0xF6, 0x38, 0x48, 0xF1, 0x0B, 0xC3, 0x0D, 0x0A, 0x28, 0x54,
  0xF3, 0x03, 0xF4, 0x38, 0x3D, 0x90, 0x8E, 0x48, 0x37, 0xE0, 0xD8, 0x48, 0x31, 0xF7, 0xF2, 0x58,
  0x1A, 0xFC, 0x68, 0x14, 0xF6, 0x68, 0x17, 0xF1, 0x60, 0xD0, 0x94, 0x83, 0x45, 0xBF, 0x24, 0x82,
  0xCF, 0xD4, 0x50,
  // "Ÿ" (U+0178)
  0x28, 0x57, 0xF3, 0x05, 0xF5, 0x38, 0x56, 0xE2, 0x04, 0xE4, 0x74, 0x81, 0x2F, 0x95, 0x84, 0xCD,
  0x09, 0xF1, 0x38, 0x53, 0xF6, 0x02, 0xF8, 0x30, 0xA0, 0xD3, 0x09, 0x0E, 0x28, 0x12, 0xF6, 0x38,
  0x42, 0xF7, 0x09, 0xD5, 0x83, 0x9D, 0x1F, 0x65, 0x82, 0x2F, 0xCD, 0x78, 0x19, 0xF6, 0x78, 0x15,
  0xF2, 0x78, 0x15, 0xF2, 0x78, 0x15, 0xF2, 0x78, 0x15, 0xF2, 0x78, 0x15, 0xF2, 0x30,
  // "Ź" (U+0179)
  0x58, 0x12, 0xFC, 0x68, 0x1B, 0xD1, 0x58, 0x15, 0xD2, 0x75, 0x0E, 0xE8, 0x71, 0x04, 0x55, 0x55,
  0xDD, 0x68, 0x13, 0xF6, 0x60, 0xB0, 0xD6, 0x81, 0x4F, 0x56, 0x0D, 0x0C, 0x68, 0x16, 0xF3, 0x60,
  0xD0, 0xA6, 0x81, 0x7F, 0x25, 0x81, 0x1E, 0x96, 0x81, 0x8F, 0x15, 0x81, 0x2F, 0xB8, 0x01, 0x51,
  0x04, 0xF0, 0x10,
  // "ź" (U+017A)
  0x58, 0x12, 0xFC, 0x68, 0x1B, 0xD1, 0x58, 0x15, 0xD2, 0x74, 0x01, 0xF2, 0x80, 0x15, 0x0E, 0x0D,
  0x68, 0x19, 0xF3, 0x58, 0x15, 0xF7, 0x58, 0x12, 0xEA, 0x68, 0x1C, 0xD1, 0x58, 0x18, 0xF3, 0x58,
  0x14, 0xF6, 0x58, 0x11, 0xED, 0x80, 0x15, 0x10, 0x5F, 0x02,
  // "Ż" (U+017B)
  0x50, 0x17, 0x81, 0x9F, 0x66, 0x81, 0x7E, 0x47, 0x77, 0x0E, 0xE8, 0x71, 0x04, 0x55, 0x55, 0xDD,
  0x68, 0x13, 0xF6, 0x60, 0xB0, 0xD6, 0x81, 0x4F, 0x56, 0x0D, 0x0C, 0x68, 0x16, 0xF3, 0x60, 0xD0,
  0xA6, 0x81, 0x7F, 0x25, 0x81, 0x1E, 0x96, 0x81, 0x8F, 0x15, 0x81, 0x2F, 0xB8, 0x01, 0x51, 0x04,
  0xF0, 0x10,
  // "ż" (U+017C)
  0x50, 0x17, 0x81, 0x9F, 0x66, 0x81, 0x7E, 0x47, 0x76, 0x01, 0xF2, 0x80, 0x15, 0x0E, 0x0D, 0x68,
  0x19, 0xF3, 0x58, 0x15, 0xF7, 0x58, 0x12, 0xEA, 0x68, 0x1C, 0xD1, 0x58, 0x18, 0xF3, 0x58, 0x14,
  0xF6, 0x58, 0x11, 0xED, 0x80, 0x15, 0x10, 0x5F, 0x02,
  // "Ž" (U+017D)
  0x28, 0x56, 0xD2, 0x05, 0xE3, 0x38, 0x38, 0xE8, 0xF5, 0x58, 0x1B, 0xF8, 0x75, 0x0E, 0xE8, 0x71,
  0x04, 0x55, 0x55, 0xDD, 0x68, 0x13, 0xF6, 0x60, 0xB0, 0xD6, 0x81, 0x4F, 0x56, 0x0D, 0x0C, 0x68,
  0x16, 0xF3, 0x60, 0xD0, 0xA6, 0x81, 0x7F, 0x25, 0x81, 0x1E, 0x96, 0x81, 0x8F, 0x15, 0x81, 0x2F,
  0xB8, 0x01, 0x51, 0x04, 0xF0, 0x10,
  // "ž" (U+017E)
  0x28, 0x56, 0xD2, 0x05, 0xE3, 0x38, 0x38, 0xE8, 0xF5, 0x58, 0x1B, 0xF8, 0x74, 0x01, 0xF2, 0x80,
  0x15, 0x0E, 0x0D, 0x68, 0x19, 0xF3, 0x58, 0x15, 0xF7, 0x58, 0x12, 0xEA, 0x68, 0x1C, 0xD1, 0x58,
  0x18, 0xF3, 0x58, 0x14, 0xF6, 0x58, 0x11, 0xED, 0x80, 0x15, 0x10, 0x5F, 0x02,
  // "ſ" (U+017F)
  0x18, 0x93, 0x7D, 0xFE, 0x98, 0xF9, 0x56, 0x4E, 0xB4, 0x90, 0x94, 0x90, 0x84, 0x90, 0x84, 0x90,
  0x84, 0x90, 0x84, 0x90, 0x84, 0x90, 0x84, 0x90, 0x84, 0x90, 0x84, 0x90, 0x84, 0x90, 0x84,
  // "Ω" (U+03A9)
  0x28, 0x41, 0x9D, 0xFD, 0x75, 0x85, 0xDE, 0x85, 0x8F, 0xA3, 0x81, 0x8F, 0x43, 0x81, 0x7F, 0x42,
  0x00, 0xD4, 0x81, 0x1F, 0x92, 0x90, 0x95, 0x84, 0xDC, 0x01, 0xF8, 0x58, 0x4B, 0xD0, 0x1F, 0x85,
  0x0B, 0x0D, 0x29, 0x09, 0x50, 0xC0, 0xB2, 0x0B, 0x0C, 0x50, 0xE0, 0x82, 0x81, 0x7F, 0x13, 0x81,
  0x3F, 0x42, 0x81, 0x1E, 0x73, 0x0A, 0x0C, 0x28, 0x92, 0x35, 0xAF, 0x30, 0x6F, 0x75, 0x29, 0xB8,
  0x17, 0x0A, 0xB0, 0x60,
  // "μ" (U+03BC)
  0x0A, 0x94, 0x82, 0x4F, 0x5A, 0x94, 0x82, 0x4F, 0x5A, 0x94, 0x82, 0x4F, 0x5A, 0x94, 0x82, 0x4F,
  0x5A, 0x94, 0x82, 0x4F, 0x5A, 0x94, 0x82, 0x4F, 0x5A, 0x94, 0x84, 0x6F, 0x5A, 0xF2, 0x38, 0xA4,
  0xCF, 0x5A, 0xFD, 0x66, 0xBD, 0xF5, 0xAF, 0xEF, 0xE9, 0x1F, 0x5A, 0x97, 0x0A, 0x97, 0x0A, 0x97,
  0x0A, 0x97,
  // "π" (U+03C0)
  0x02, 0x0C, 0xF9, 0x89, 0x11, 0x15, 0x9F, 0x75, 0x8F, 0x75, 0x38, 0x55, 0xF2, 0x05, 0xF3, 0x48,
  0x55, 0xF2, 0x05, 0xF3, 0x48, 0x55, 0xF2, 0x05, 0xF3, 0x48, 0x55, 0xF2, 0x05, 0xF3, 0x48, 0x55,
  0xF2, 0x05, 0xF3, 0x48, 0x55, 0xF2, 0x05, 0xF3, 0x48, 0x65, 0xF2, 0x03, 0xFA, 0x53, 0x81, 0x5F,
  0x22, 0x81, 0x9E, 0xB1,
  // "–" (U+2013)
  0x18, 0x03, 0x10, 0x3F, 0x18, 0x03, 0x30,
  // "—" (U+2014)
  0x80, 0x61, 0x1F, 0xB0, 0xC8, 0x07, 0x30,
  // "€" (U+20AC)
  0x48, 0x53, 0xAE, 0xED, 0x81, 0x38, 0x65, 0xFC, 0x75, 0x9E, 0x12, 0x81, 0x1E, 0xC7, 0x18, 0x17,
  0xF3, 0x71, 0x0B, 0x0E, 0x70, 0x3F, 0x02, 0x38, 0x13, 0xFB, 0x80, 0x03, 0x30, 0x3F, 0x02, 0x38,
  0x12, 0xBE, 0x80, 0x02, 0x58, 0x16, 0xF3, 0x71, 0x81, 0x1E, 0xC7, 0x28, 0x55, 0xFD, 0x75, 0x7C,
  0x58, 0x43, 0xAE, 0xFD, 0x91,
  // "₿" (U+20BF)
  0x28, 0x1A, 0x71, 0x95, 0x81, 0xA7, 0x19, 0x30, 0x4D, 0x89, 0x59, 0x10, 0x4F, 0x75, 0x58, 0xED,
  0x04, 0xF3, 0x38, 0x46, 0xF5, 0x4F, 0x33, 0x84, 0x3F, 0x64, 0xF3, 0x38, 0x93, 0x5F, 0x44, 0xF4,
  0x11, 0x4D, 0xB0, 0x4D, 0x89, 0x5A, 0x10, 0x4F, 0x63, 0x46, 0xDE, 0x24, 0xF3, 0x38, 0x41, 0xFA,
  0x4F, 0x34, 0x83, 0xDC, 0x4F, 0x33, 0x89, 0x32, 0xF9, 0x4F, 0x75, 0x57, 0xDF, 0x34, 0xD0, 0xA0,
  0x33, 0x81, 0xA7, 0x19, 0x58, 0x1A, 0x61, 0x93,
  // "‘" (U+2018)
  0x18, 0x90, 0xA9, 0x1F, 0x57, 0xF2, 0xDE, 0x10,
  // "’" (U+2019)
  0x18, 0x94, 0x6F, 0x70, 0x9F, 0x20, 0xDC, 0x01, 0xF5, 0x10,
  // "‚" (U+201A)
  0x18, 0xA0, 0x4F, 0xB0, 0x7F, 0x60, 0xAF, 0x10, 0xDB, 0x01, 0xF5, 0x10,
  // "‛" (U+201B)
  0x89, 0x2D, 0xE0, 0x7F, 0x21, 0xF5, 0x09, 0x90,
  // "“" (U+201C)
  0x10, 0xA0, 0x92, 0x8A, 0x0A, 0x91, 0xF5, 0x01, 0xF5, 0x7F, 0x20, 0x7F, 0x2D, 0xE2, 0x0D, 0x0E,
  0x10,
  // "”" (U+201D)
  0x10, 0xE0, 0xD2, 0x8A, 0x0E, 0xD2, 0xF7, 0x02, 0xF7, 0x5F, 0x10, 0x5F, 0x19, 0xA2, 0x09, 0x0A,
  0x10,
  // "„" (U+201E)
  0x18, 0xB7, 0x4F, 0xB4, 0xFB, 0x07, 0xF6, 0x7F, 0x60, 0xAF, 0x1A, 0xF1, 0x0D, 0xB0, 0xDB, 0x01,
  0xF5, 0x1F, 0x51,
  // "‟" (U+201F)
  0x0D, 0x0E, 0x28, 0xA2, 0xDE, 0x07, 0xF2, 0x07, 0xF2, 0x1F, 0x50, 0x1F, 0x50, 0xA9, 0x20, 0xA0,
  0x90,
  // "†" (U+2020)
  0x38, 0x18, 0xF2, 0x50, 0x69, 0x60, 0x40, 0xE4, 0x86, 0x64, 0x5D, 0x35, 0x51, 0xA8, 0x90, 0xEF,
  0xEF, 0xD0, 0x10, 0x2C, 0x20, 0x13, 0x03, 0x0D, 0x60, 0x40, 0xD6, 0x05, 0x0E, 0x60, 0x59, 0x60,
  0x69, 0x68, 0x17, 0xF1, 0x58, 0x18, 0xF2, 0x58, 0x18, 0xF2, 0x20,
  // "‡" (U+2021)
  0x38, 0x17, 0xF3, 0x58, 0x15, 0xF1, 0x50, 0x30, 0xE3, 0x89, 0x61, 0xB9, 0x9E, 0x8A, 0xA1, 0xB9,
  0x9E, 0x8A, 0xA3, 0x04, 0x96, 0x81, 0x6F, 0x25, 0x81, 0x6F, 0x25, 0x04, 0x93, 0x89, 0x61, 0x98,
  0x8E, 0x78, 0x91, 0xCB, 0xBE, 0xAB, 0xB3, 0x03, 0x0E, 0x68, 0x15, 0xF1, 0x58, 0x17, 0xF3, 0x20,
  // "•" (U+2022)
  0x84, 0x1B, 0xE9, 0x07, 0xB0, 0x30, 0x8B, 0x05, 0x06, 0xB8, 0x33, 0x0B, 0xE9, 0x10,
  // "…" (U+2026)
  0x10, 0x13, 0x01, 0x38, 0xA6, 0x10, 0x9F, 0x60, 0x9F, 0x60, 0x9F, 0x67, 0xE4, 0x07, 0xE4, 0x07,
  0xE4,
  // "‰" (U+2030)
  0x82, 0x1B, 0xE7, 0x78, 0x38, 0xD7, 0xF2, 0x68, 0x3A, 0x90, 0xF4, 0x68, 0xA2, 0x9C, 0x4F, 0x30,
  0x2C, 0xD4, 0x02, 0xEF, 0xB0, 0x7F, 0x91, 0x38, 0x41, 0x23, 0xCD, 0x46, 0x82, 0x7F, 0x91, 0x58,
  0x21, 0xBD, 0x47, 0x28, 0x63, 0xEF, 0x60, 0xBF, 0xB3, 0x87, 0xBB, 0x8F, 0x6E, 0x5E, 0x52, 0x87,
  0xD7, 0x3F, 0x9C, 0x0C, 0x72, 0x87, 0xAB, 0x9E, 0x6F, 0x6F, 0x52, 0x86, 0x2D, 0xE5, 0x0A, 0xEA,
  0x10,
  // "‹" (U+2039)
  0x30, 0x43, 0x89, 0x17, 0xF2, 0x05, 0xF5, 0x03, 0xE8, 0x28, 0x17, 0xF3, 0x38, 0x1B, 0xD1, 0x30,
  0xD0, 0xC3, 0x81, 0x2C, 0x20,
  // "›" (U+203A)
  0x81, 0x2C, 0x23, 0x0C, 0x0D, 0x38, 0x11, 0xDB, 0x38, 0x13, 0xF7, 0x28, 0x91, 0x8E, 0x30, 0x5F,
  0x50, 0x2F, 0x73, 0x04, 0x30,
  // "⁄" (U+2044)
  0x58, 0x12, 0xF3, 0x50, 0x90, 0xC6, 0x0E, 0x05, 0x50, 0x60, 0xE6, 0x0D, 0x08, 0x58, 0x14, 0xF1,
  0x50, 0x0A, 0x58, 0x11, 0xF4, 0x50, 0x80, 0xD6, 0x0E, 0x06, 0x50, 0x50, 0xE6, 0x0C, 0x09, 0x58,
  0x13, 0xF2, 0x50,
  // "™" (U+2122)
  0x02, 0xC8, 0x54, 0xFB, 0x02, 0xF9, 0x28, 0x90, 0x7A, 0x01, 0xFE, 0x05, 0xE9, 0x28, 0x90, 0x7A,
  0x01, 0xFB, 0x39, 0xB9, 0x28, 0x90, 0x7A, 0x01, 0xF7, 0x6C, 0x89, 0x28, 0x90, 0x7A, 0x01, 0xF4,
  0xBA, 0x89, 0x28, 0x90, 0x7A, 0x01, 0xF0, 0xF6, 0x89, 0x20, 0x30, 0x42, 0x84, 0x70, 0x61, 0x34,
  // "⅒" (U+2152)
  0x28, 0x13, 0x72, 0x58, 0x12, 0xF3, 0x75, 0x83, 0x1A, 0xEF, 0x45, 0x09, 0x0C, 0x77, 0x82, 0x92,
  0xE4, 0x50, 0xE0, 0x57, 0x72, 0x0E, 0x04, 0x40, 0x60, 0xE7, 0x73, 0x0E, 0x04, 0x40, 0xD0, 0x87,
  0x73, 0x0E, 0x04, 0x38, 0x14, 0xF1, 0x28, 0x13, 0x72, 0x38, 0x34, 0xCD, 0xA1, 0x40, 0xE0, 0x43,
  0x86, 0xAA, 0x01, 0xAE, 0xF4, 0x38, 0x3E, 0x72, 0xAC, 0x20, 0xBC, 0x82, 0x21, 0xF4, 0x28, 0x29,
  0x2E, 0x42, 0x05, 0x0D, 0x28, 0x11, 0xF2, 0x70, 0x80, 0xD5, 0x0E, 0x04, 0x20, 0x70, 0xB3, 0x0D,
  0x04, 0x70, 0xE0, 0x65, 0x0E, 0x04, 0x20, 0x80, 0xA3, 0x0D, 0x04, 0x60, 0x50, 0xE6, 0x0E, 0x04,
  0x20, 0x60, 0xC3, 0x90, 0x36, 0x0C, 0x09, 0x60, 0xE0, 0x42, 0x84, 0x1F, 0x40, 0x7D, 0x68, 0x13,
  0xF2, 0x40, 0xBC, 0x85, 0x20, 0x6E, 0xFE, 0x47, 0x77, 0x10, 0x13,
  // "∂" (U+2202)
  0x30, 0x70, 0xEA, 0x0A, 0x01, 0x48, 0x49, 0x64, 0x8F, 0xB7, 0x18, 0x18, 0xF2, 0x78, 0x13, 0xF5,
  0x38, 0x58, 0xDF, 0xC4, 0xF7, 0x28, 0x92, 0xAF, 0x83, 0x7E, 0xF6, 0x05, 0xF7, 0x38, 0x49, 0xF5,
  0x0C, 0xE4, 0x84, 0x7F, 0x20, 0xFA, 0x48, 0x4B, 0xE0, 0x1F, 0x83, 0x85, 0x2F, 0x90, 0x1F, 0x93,
  0x81, 0xAF, 0x12, 0x85, 0xCE, 0x42, 0x9F, 0x73, 0x03, 0x0D, 0xA0, 0xE0, 0x66, 0x00, 0x35,
  // "∆" (U+2206)
  0x48, 0x19, 0xF5, 0x71, 0x81, 0xEF, 0xB7, 0x83, 0x4F, 0x9F, 0x16, 0x83, 0xAD, 0x2F, 0x66, 0x83,
  0xE8, 0x0B, 0xC5, 0x85, 0x5F, 0x30, 0x6F, 0x24, 0x0B, 0x0D, 0x28, 0x11, 0xF7, 0x38, 0x11, 0xF8,
  0x30, 0xB0, 0xD3, 0x81, 0x6F, 0x23, 0x81, 0x6F, 0x32, 0x0B, 0x0C, 0x48, 0x51, 0xF8, 0x01, 0xF7,
  0x58, 0x4B, 0xD0, 0x7F, 0x88, 0x01, 0x68, 0x2A, 0xF3, 0x9F, 0xA0, 0x60,
  // "√" (U+221A)
  0x72, 0x00, 0x57, 0x20, 0xD0, 0x77, 0x18, 0x13, 0xF2, 0x71, 0x08, 0x0C, 0x72, 0x0D, 0x07, 0x71,
  0x81, 0x3F, 0x17, 0x10, 0x90, 0xB3, 0x00, 0x14, 0x0E, 0x06, 0x20, 0xAA, 0x01, 0x28, 0x13, 0xF1,
  0x28, 0x22, 0x4E, 0x62, 0x09, 0x0B, 0x50, 0xA0, 0xC2, 0x0E, 0x06, 0x58, 0x44, 0xF1, 0x4F, 0x16,
  0x82, 0xE7, 0x9B, 0x78, 0x28, 0xCE, 0x57, 0x03, 0xA7, 0x20, 0xD0, 0xA5,
  // "∞" (U+221E)
  0x18, 0xA5, 0xAE, 0xC4, 0x05, 0xDE, 0x90, 0x9B, 0x36, 0xE8, 0xD4, 0x4E, 0x6D, 0x52, 0x81, 0x6F,
  0x32, 0x89, 0x58, 0xAB, 0xA0, 0x2C, 0xCB, 0x11, 0xC7, 0x2D, 0xA8, 0x17, 0x09, 0xA0, 0xB3, 0x01,
  0x40, 0x01, 0x20,
  // "≈" (U+2248)
  0x89, 0x45, 0xDF, 0xD8, 0x31, 0x47, 0xB7, 0x58, 0xDB, 0x05, 0x58, 0x12, 0x31, 0x73, 0x89, 0x46,
  0xEF, 0xE9, 0x41, 0x58, 0xB6, 0x47, 0xDB, 0x05, 0x58, 0x12, 0x31, 0x10,
  // "≠" (U+2260)
  0x50, 0x30, 0x67, 0x0B, 0x0D, 0x28, 0x00, 0x18, 0x44, 0xF7, 0x11, 0xBF, 0x8A, 0x28, 0x34, 0x47,
  0xF8, 0x44, 0x21, 0x11, 0xBD, 0x21, 0x11, 0xBF, 0x89, 0x48, 0x34, 0xDD, 0x44, 0x44, 0x20, 0x3F,
  0x66, 0x02, 0x09, 0x60,
  // "≤" (U+2264)
  0x70, 0x10, 0x75, 0x82, 0x19, 0xFB, 0x38, 0x31, 0x9F, 0xB4, 0x28, 0x31, 0x9F, 0xA3, 0x38, 0x26,
  0xFA, 0x25, 0x83, 0x4D, 0xE8, 0x26, 0x83, 0x4B, 0xFA, 0x46, 0x83, 0x29, 0xFD, 0x66, 0x81, 0x17,
  0xB7, 0x20, 0x9F, 0x0D, 0x02, 0x80, 0x43,
  // "≥" (U+2265)
  0x07, 0x01, 0x78, 0x2B, 0xF9, 0x16, 0x83, 0x4B, 0xF9, 0x16, 0x83, 0x3A, 0xF9, 0x16, 0x82, 0x2A,
  0xF6, 0x48, 0x32, 0x8E, 0xD4, 0x28, 0x34, 0xAF, 0xB4, 0x28, 0x36, 0xDF, 0x92, 0x48, 0x1B, 0x71,
  0x77, 0x10, 0xDF, 0x09, 0x80, 0x43, 0x02,
};

const Font& font_NotoSansMono_Regular_18() {
  static SmoothFont font(font_NotoSansMono_Regular_18_data);
  return font;
}

}  // namespace roo_display
