#include "12.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSerif-Regular (Noto Serif Regular)
// Generated on Thu Mar 30 22:29:07 CEST 2023
static const uint8_t font_NotoSerif_Regular_12_data[] PROGMEM = {
  
  // Header
  0x01, 0x01, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x06, 0x41,
  0xFE, 0xFE, 0x0E, 0x0D, 0x0A, 0xFD, 0x03, 0x01, 0x0F, 0x05, 0x04, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x01, 0x01, 0x02, 0x09, 0x04, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x00, 0x07, 0x04, 0x09, 0x05, 0x00, 0x0B, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x06, 0x09, 0x07, 0x00, 0x14, // "#" (U+0023)
  0x00, 0x24, 0x00, 0x00, 0x05, 0x0A, 0x07, 0x00, 0x35, // "$" (U+0024)
  0x00, 0x25, 0x00, 0x01, 0x0A, 0x09, 0x0B, 0x00, 0x54, // "%" (U+0025)
  0x00, 0x26, 0x00, 0x01, 0x08, 0x09, 0x09, 0x00, 0x87, // "&" (U+0026)
  0x00, 0x27, 0x00, 0x07, 0x01, 0x09, 0x03, 0x00, 0xB2, // "'" (U+0027)
  0x00, 0x28, 0x00, 0xFF, 0x03, 0x09, 0x04, 0x00, 0xB6, // "(" (U+0028)
  0x00, 0x29, 0x00, 0xFF, 0x03, 0x09, 0x04, 0x00, 0xCE, // ")" (U+0029)
  0x00, 0x2A, 0x00, 0x06, 0x05, 0x0A, 0x06, 0x00, 0xE7, // "*" (U+002A)
  0x00, 0x2B, 0x00, 0x03, 0x05, 0x08, 0x07, 0x00, 0xF8, // "+" (U+002B)
  0x00, 0x2C, 0x00, 0xFF, 0x02, 0x02, 0x03, 0x01, 0x05, // "," (U+002C)
  0x00, 0x2D, 0x00, 0x04, 0x03, 0x04, 0x04, 0x01, 0x0D, // "-" (U+002D)
  0x00, 0x2E, 0x00, 0x01, 0x02, 0x02, 0x03, 0x01, 0x10, // "." (U+002E)
  0x00, 0x2F, 0x00, 0xFF, 0x03, 0x0A, 0x03, 0x01, 0x14, // "/" (U+002F)
  0x00, 0x30, 0x00, 0x01, 0x06, 0x09, 0x07, 0x01, 0x2D, // "0" (U+0030)
  0x00, 0x31, 0x00, 0x01, 0x05, 0x09, 0x07, 0x01, 0x51, // "1" (U+0031)
  0x00, 0x32, 0x00, 0x01, 0x05, 0x09, 0x07, 0x01, 0x6E, // "2" (U+0032)
  0x00, 0x33, 0x00, 0x01, 0x05, 0x09, 0x07, 0x01, 0x8A, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x01, 0x06, 0x09, 0x07, 0x01, 0xA7, // "4" (U+0034)
  0x00, 0x35, 0x00, 0x01, 0x05, 0x09, 0x07, 0x01, 0xC5, // "5" (U+0035)
  0x00, 0x36, 0x00, 0x01, 0x05, 0x09, 0x07, 0x01, 0xE1, // "6" (U+0036)
  0x00, 0x37, 0x00, 0x01, 0x05, 0x09, 0x07, 0x01, 0xFF, // "7" (U+0037)
  0x00, 0x38, 0x00, 0x01, 0x06, 0x09, 0x07, 0x02, 0x17, // "8" (U+0038)
  0x00, 0x39, 0x00, 0x01, 0x05, 0x09, 0x07, 0x02, 0x3B, // "9" (U+0039)
  0x00, 0x3A, 0x01, 0x01, 0x02, 0x07, 0x03, 0x02, 0x58, // ":" (U+003A)
  0x00, 0x3B, 0x00, 0xFF, 0x02, 0x07, 0x03, 0x02, 0x5F, // ";" (U+003B)
  0x00, 0x3C, 0x00, 0x02, 0x05, 0x08, 0x07, 0x02, 0x6B, // "<" (U+003C)
  0x00, 0x3D, 0x00, 0x04, 0x05, 0x07, 0x07, 0x02, 0x7C, // "=" (U+003D)
  0x00, 0x3E, 0x00, 0x02, 0x05, 0x07, 0x07, 0x02, 0x85, // ">" (U+003E)
  0x00, 0x3F, 0x00, 0x01, 0x05, 0x09, 0x06, 0x02, 0x96, // "?" (U+003F)
  0x00, 0x40, 0x00, 0xFF, 0x0A, 0x09, 0x0B, 0x02, 0xB0, // "@" (U+0040)
  0x00, 0x41, 0x00, 0x01, 0x08, 0x09, 0x08, 0x02, 0xEA, // "A" (U+0041)
  0x00, 0x42, 0x00, 0x01, 0x07, 0x09, 0x08, 0x03, 0x0E, // "B" (U+0042)
  0x00, 0x43, 0x00, 0x01, 0x06, 0x09, 0x07, 0x03, 0x39, // "C" (U+0043)
  0x00, 0x44, 0x00, 0x01, 0x07, 0x09, 0x09, 0x03, 0x55, // "D" (U+0044)
  0x00, 0x45, 0x00, 0x01, 0x06, 0x09, 0x07, 0x03, 0x7C, // "E" (U+0045)
  0x00, 0x46, 0x00, 0x01, 0x06, 0x09, 0x07, 0x03, 0x9B, // "F" (U+0046)
  0x00, 0x47, 0x00, 0x01, 0x08, 0x09, 0x09, 0x03, 0xB9, // "G" (U+0047)
  0x00, 0x48, 0x00, 0x01, 0x08, 0x09, 0x0A, 0x03, 0xE2, // "H" (U+0048)
  0x00, 0x49, 0x00, 0x01, 0x03, 0x09, 0x04, 0x04, 0x10, // "I" (U+0049)
  0x00, 0x4A, 0xFF, 0xFE, 0x03, 0x09, 0x04, 0x04, 0x26, // "J" (U+004A)
  0x00, 0x4B, 0x00, 0x01, 0x08, 0x09, 0x08, 0x04, 0x46, // "K" (U+004B)
  0x00, 0x4C, 0x00, 0x01, 0x06, 0x09, 0x07, 0x04, 0x70, // "L" (U+004C)
  0x00, 0x4D, 0x00, 0x01, 0x0A, 0x09, 0x0B, 0x04, 0x8B, // "M" (U+004D)
  0x00, 0x4E, 0x00, 0x01, 0x08, 0x09, 0x09, 0x04, 0xC2, // "N" (U+004E)
  0x00, 0x4F, 0x00, 0x01, 0x08, 0x09, 0x09, 0x04, 0xF1, // "O" (U+004F)
  0x00, 0x50, 0x00, 0x01, 0x06, 0x09, 0x07, 0x05, 0x1B, // "P" (U+0050)
  0x00, 0x51, 0x00, 0xFE, 0x08, 0x09, 0x09, 0x05, 0x3D, // "Q" (U+0051)
  0x00, 0x52, 0x00, 0x01, 0x07, 0x09, 0x08, 0x05, 0x6F, // "R" (U+0052)
  0x00, 0x53, 0x00, 0x01, 0x05, 0x09, 0x07, 0x05, 0x99, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x07, 0x09, 0x07, 0x05, 0xB6, // "T" (U+0054)
  0x00, 0x55, 0x00, 0x01, 0x08, 0x09, 0x09, 0x05, 0xD5, // "U" (U+0055)
  0x00, 0x56, 0x00, 0x01, 0x08, 0x09, 0x08, 0x06, 0x01, // "V" (U+0056)
  0x00, 0x57, 0x00, 0x01, 0x0C, 0x09, 0x0D, 0x06, 0x25, // "W" (U+0057)
  0x00, 0x58, 0x00, 0x01, 0x07, 0x09, 0x08, 0x06, 0x60, // "X" (U+0058)
  0x00, 0x59, 0x00, 0x01, 0x07, 0x09, 0x08, 0x06, 0x83, // "Y" (U+0059)
  0x00, 0x5A, 0x00, 0x01, 0x06, 0x09, 0x07, 0x06, 0xA3, // "Z" (U+005A)
  0x00, 0x5B, 0x01, 0xFF, 0x03, 0x0A, 0x04, 0x06, 0xC3, // "[" (U+005B)
  0x00, 0x5C, 0x00, 0xFF, 0x03, 0x0A, 0x03, 0x06, 0xD7, // "\" (U+005C)
  0x00, 0x5D, 0x00, 0xFF, 0x03, 0x0A, 0x04, 0x06, 0xEF, // "]" (U+005D)
  0x00, 0x5E, 0x00, 0x04, 0x05, 0x09, 0x07, 0x07, 0x09, // "^" (U+005E)
  0x00, 0x5F, 0x00, 0xFF, 0x05, 0xFF, 0x06, 0x07, 0x1A, // "_" (U+005F)
  0x00, 0x60, 0x00, 0x09, 0x02, 0x0A, 0x03, 0x07, 0x1D, // "`" (U+0060)
  0x00, 0x61, 0x00, 0x01, 0x06, 0x07, 0x07, 0x07, 0x21, // "a" (U+0061)
  0x00, 0x62, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x07, 0x3C, // "b" (U+0062)
  0x00, 0x63, 0x00, 0x01, 0x05, 0x07, 0x06, 0x07, 0x60, // "c" (U+0063)
  0x00, 0x64, 0x00, 0x01, 0x07, 0x0A, 0x07, 0x07, 0x76, // "d" (U+0064)
  0x00, 0x65, 0x00, 0x01, 0x05, 0x07, 0x06, 0x07, 0x9F, // "e" (U+0065)
  0x00, 0x66, 0x00, 0x01, 0x05, 0x0A, 0x04, 0x07, 0xB6, // "f" (U+0066)
  0x00, 0x67, 0x00, 0xFE, 0x06, 0x07, 0x06, 0x07, 0xD3, // "g" (U+0067)
  0x00, 0x68, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x07, 0xF8, // "h" (U+0068)
  0x00, 0x69, 0x00, 0x01, 0x03, 0x0A, 0x04, 0x08, 0x21, // "i" (U+0069)
  0x00, 0x6A, 0xFF, 0xFE, 0x02, 0x0A, 0x04, 0x08, 0x38, // "j" (U+006A)
  0x00, 0x6B, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x08, 0x56, // "k" (U+006B)
  0x00, 0x6C, 0x00, 0x01, 0x03, 0x0A, 0x04, 0x08, 0x79, // "l" (U+006C)
  0x00, 0x6D, 0x00, 0x01, 0x0A, 0x07, 0x0B, 0x08, 0x92, // "m" (U+006D)
  0x00, 0x6E, 0x00, 0x01, 0x07, 0x07, 0x08, 0x08, 0xBF, // "n" (U+006E)
  0x00, 0x6F, 0x00, 0x01, 0x06, 0x07, 0x07, 0x08, 0xE0, // "o" (U+006F)
  0x00, 0x70, 0x00, 0xFE, 0x06, 0x07, 0x07, 0x08, 0xFB, // "p" (U+0070)
  0x00, 0x71, 0x00, 0xFE, 0x07, 0x07, 0x07, 0x09, 0x20, // "q" (U+0071)
  0x00, 0x72, 0x00, 0x01, 0x05, 0x07, 0x06, 0x09, 0x4A, // "r" (U+0072)
  0x00, 0x73, 0x00, 0x01, 0x04, 0x07, 0x05, 0x09, 0x5E, // "s" (U+0073)
  0x00, 0x74, 0x00, 0x01, 0x03, 0x09, 0x04, 0x09, 0x72, // "t" (U+0074)
  0x00, 0x75, 0x00, 0x01, 0x07, 0x07, 0x08, 0x09, 0x88, // "u" (U+0075)
  0x00, 0x76, 0x00, 0x01, 0x06, 0x07, 0x07, 0x09, 0xAA, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x01, 0x0A, 0x07, 0x0A, 0x09, 0xC4, // "w" (U+0077)
  0x00, 0x78, 0x00, 0x01, 0x06, 0x07, 0x07, 0x09, 0xEC, // "x" (U+0078)
  0x00, 0x79, 0x00, 0xFE, 0x06, 0x07, 0x07, 0x0A, 0x06, // "y" (U+0079)
  0x00, 0x7A, 0x00, 0x01, 0x05, 0x07, 0x06, 0x0A, 0x27, // "z" (U+007A)
  0x00, 0x7B, 0x00, 0xFF, 0x04, 0x0A, 0x05, 0x0A, 0x3E, // "{" (U+007B)
  0x00, 0x7C, 0x03, 0xFE, 0x03, 0x0A, 0x07, 0x0A, 0x5B, // "|" (U+007C)
  0x00, 0x7D, 0x00, 0xFF, 0x04, 0x0A, 0x05, 0x0A, 0x5E, // "}" (U+007D)
  0x00, 0x7E, 0x00, 0x04, 0x05, 0x05, 0x07, 0x0A, 0x7F, // "~" (U+007E)
  0x00, 0xA1, 0x01, 0xFE, 0x02, 0x06, 0x04, 0x0A, 0x87, // "¡" (U+00A1)
  0x00, 0xA2, 0x01, 0x01, 0x05, 0x09, 0x07, 0x0A, 0x92, // "¢" (U+00A2)
  0x00, 0xA3, 0x00, 0x01, 0x06, 0x09, 0x07, 0x0A, 0xAB, // "£" (U+00A3)
  0x00, 0xA4, 0x01, 0x02, 0x05, 0x08, 0x07, 0x0A, 0xC9, // "¤" (U+00A4)
  0x00, 0xA5, 0x00, 0x01, 0x06, 0x09, 0x07, 0x0A, 0xDC, // "¥" (U+00A5)
  0x00, 0xA6, 0x03, 0xFE, 0x03, 0x0A, 0x07, 0x0A, 0xFC, // "¦" (U+00A6)
  0x00, 0xA7, 0x01, 0x00, 0x05, 0x0A, 0x07, 0x0B, 0x01, // "§" (U+00A7)
  0x00, 0xA8, 0x01, 0x08, 0x05, 0x09, 0x07, 0x0B, 0x20, // "¨" (U+00A8)
  0x00, 0xA9, 0x00, 0x01, 0x09, 0x0A, 0x0A, 0x0B, 0x26, // "©" (U+00A9)
  0x00, 0xAA, 0x00, 0x06, 0x04, 0x09, 0x05, 0x0B, 0x5A, // "ª" (U+00AA)
  0x00, 0xAB, 0x00, 0x02, 0x05, 0x06, 0x06, 0x0B, 0x66, // "«" (U+00AB)
  0x00, 0xAC, 0x00, 0x02, 0x05, 0x05, 0x07, 0x0B, 0x77, // "¬" (U+00AC)
  0x00, 0xAE, 0x00, 0x01, 0x09, 0x0A, 0x0A, 0x0B, 0x80, // "®" (U+00AE)
  0x00, 0xAF, 0x00, 0x0B, 0x05, 0x0B, 0x06, 0x0B, 0xB5, // "¯" (U+00AF)
  0x00, 0xB0, 0x00, 0x06, 0x04, 0x09, 0x05, 0x0B, 0xB8, // "°" (U+00B0)
  0x00, 0xB1, 0x00, 0x01, 0x05, 0x08, 0x07, 0x0B, 0xC4, // "±" (U+00B1)
  0x00, 0xB2, 0x00, 0x06, 0x04, 0x0B, 0x05, 0x0B, 0xD5, // "²" (U+00B2)
  0x00, 0xB3, 0x00, 0x05, 0x04, 0x0A, 0x05, 0x0B, 0xE6, // "³" (U+00B3)
  0x00, 0xB4, 0x00, 0x09, 0x02, 0x0A, 0x03, 0x0B, 0xF7, // "´" (U+00B4)
  0x00, 0xB5, 0x01, 0xFE, 0x06, 0x07, 0x07, 0x0B, 0xFB, // "µ" (U+00B5)
  0x00, 0xB6, 0x00, 0xFF, 0x06, 0x0A, 0x07, 0x0C, 0x1A, // "¶" (U+00B6)
  0x00, 0xB7, 0x00, 0x05, 0x02, 0x06, 0x03, 0x0C, 0x45, // "·" (U+00B7)
  0x00, 0xB8, 0x00, 0xFE, 0x03, 0x00, 0x04, 0x0C, 0x49, // "¸" (U+00B8)
  0x00, 0xB9, 0x00, 0x05, 0x03, 0x0A, 0x05, 0x0C, 0x50, // "¹" (U+00B9)
  0x00, 0xBA, 0x00, 0x06, 0x04, 0x09, 0x05, 0x0C, 0x5D, // "º" (U+00BA)
  0x00, 0xBB, 0x01, 0x02, 0x05, 0x06, 0x06, 0x0C, 0x69, // "»" (U+00BB)
  0x00, 0xBC, 0x00, 0x00, 0x09, 0x09, 0x0A, 0x0C, 0x77, // "¼" (U+00BC)
  0x00, 0xBD, 0x00, 0x01, 0x09, 0x09, 0x0A, 0x0C, 0xA5, // "½" (U+00BD)
  0x00, 0xBE, 0x00, 0x00, 0x09, 0x09, 0x0A, 0x0C, 0xD3, // "¾" (U+00BE)
  0x00, 0xBF, 0x00, 0xFE, 0x05, 0x06, 0x06, 0x0D, 0x03, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x08, 0x0C, 0x08, 0x0D, 0x1D, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x08, 0x0C, 0x08, 0x0D, 0x48, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x01, 0x08, 0x0C, 0x08, 0x0D, 0x72, // "Â" (U+00C2)
  0x00, 0xC3, 0x00, 0x01, 0x08, 0x0C, 0x08, 0x0D, 0x9E, // "Ã" (U+00C3)
  0x00, 0xC4, 0x00, 0x01, 0x08, 0x0B, 0x08, 0x0D, 0xCB, // "Ä" (U+00C4)
  0x00, 0xC5, 0x00, 0x01, 0x08, 0x0C, 0x08, 0x0D, 0xF6, // "Å" (U+00C5)
  0x00, 0xC6, 0x00, 0x01, 0x0A, 0x09, 0x0B, 0x0E, 0x25, // "Æ" (U+00C6)
  0x00, 0xC7, 0x00, 0xFE, 0x06, 0x09, 0x07, 0x0E, 0x55, // "Ç" (U+00C7)
  0x00, 0xC8, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x0E, 0x79, // "È" (U+00C8)
  0x00, 0xC9, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x0E, 0x9F, // "É" (U+00C9)
  0x00, 0xCA, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x0E, 0xC4, // "Ê" (U+00CA)
  0x00, 0xCB, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x0E, 0xEB, // "Ë" (U+00CB)
  0x00, 0xCC, 0x00, 0x01, 0x03, 0x0C, 0x04, 0x0F, 0x12, // "Ì" (U+00CC)
  0x00, 0xCD, 0x00, 0x01, 0x03, 0x0C, 0x04, 0x0F, 0x2E, // "Í" (U+00CD)
  0x00, 0xCE, 0x00, 0x01, 0x03, 0x0C, 0x04, 0x0F, 0x49, // "Î" (U+00CE)
  0x00, 0xCF, 0x00, 0x01, 0x04, 0x0B, 0x04, 0x0F, 0x65, // "Ï" (U+00CF)
  0x00, 0xD0, 0x00, 0x01, 0x07, 0x09, 0x09, 0x0F, 0x83, // "Ð" (U+00D0)
  0x00, 0xD1, 0x00, 0x01, 0x08, 0x0C, 0x09, 0x0F, 0xAB, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x00, 0x01, 0x08, 0x0C, 0x09, 0x0F, 0xE3, // "Ò" (U+00D2)
  0x00, 0xD3, 0x00, 0x01, 0x08, 0x0C, 0x09, 0x10, 0x13, // "Ó" (U+00D3)
  0x00, 0xD4, 0x00, 0x01, 0x08, 0x0C, 0x09, 0x10, 0x43, // "Ô" (U+00D4)
  0x00, 0xD5, 0x00, 0x01, 0x08, 0x0C, 0x09, 0x10, 0x74, // "Õ" (U+00D5)
  0x00, 0xD6, 0x00, 0x01, 0x08, 0x0B, 0x09, 0x10, 0xA6, // "Ö" (U+00D6)
  0x00, 0xD7, 0x01, 0x03, 0x05, 0x07, 0x07, 0x10, 0xD7, // "×" (U+00D7)
  0x00, 0xD8, 0x00, 0x00, 0x08, 0x0A, 0x09, 0x10, 0xE5, // "Ø" (U+00D8)
  0x00, 0xD9, 0x00, 0x01, 0x08, 0x0C, 0x09, 0x11, 0x17, // "Ù" (U+00D9)
  0x00, 0xDA, 0x00, 0x01, 0x08, 0x0C, 0x09, 0x11, 0x4A, // "Ú" (U+00DA)
  0x00, 0xDB, 0x00, 0x01, 0x08, 0x0C, 0x09, 0x11, 0x7C, // "Û" (U+00DB)
  0x00, 0xDC, 0x00, 0x01, 0x08, 0x0B, 0x09, 0x11, 0xB0, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x11, 0xE4, // "Ý" (U+00DD)
  0x00, 0xDE, 0x00, 0x01, 0x06, 0x09, 0x07, 0x12, 0x0A, // "Þ" (U+00DE)
  0x00, 0xDF, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x12, 0x2B, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x12, 0x56, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x12, 0x77, // "á" (U+00E1)
  0x00, 0xE2, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x12, 0x97, // "â" (U+00E2)
  0x00, 0xE3, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x12, 0xB9, // "ã" (U+00E3)
  0x00, 0xE4, 0x00, 0x01, 0x06, 0x09, 0x07, 0x12, 0xDC, // "ä" (U+00E4)
  0x00, 0xE5, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x12, 0xFE, // "å" (U+00E5)
  0x00, 0xE6, 0x00, 0x01, 0x09, 0x07, 0x0A, 0x13, 0x23, // "æ" (U+00E6)
  0x00, 0xE7, 0x00, 0xFE, 0x05, 0x07, 0x06, 0x13, 0x49, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x13, 0x67, // "è" (U+00E8)
  0x00, 0xE9, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x13, 0x84, // "é" (U+00E9)
  0x00, 0xEA, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x13, 0xA1, // "ê" (U+00EA)
  0x00, 0xEB, 0x00, 0x01, 0x05, 0x09, 0x06, 0x13, 0xBF, // "ë" (U+00EB)
  0x00, 0xEC, 0x00, 0x01, 0x03, 0x0A, 0x04, 0x13, 0xDD, // "ì" (U+00EC)
  0x00, 0xED, 0x00, 0x01, 0x03, 0x0A, 0x04, 0x13, 0xF4, // "í" (U+00ED)
  0x00, 0xEE, 0x00, 0x01, 0x03, 0x0A, 0x04, 0x14, 0x0A, // "î" (U+00EE)
  0x00, 0xEF, 0xFF, 0x01, 0x03, 0x09, 0x04, 0x14, 0x21, // "ï" (U+00EF)
  0x00, 0xF0, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x14, 0x39, // "ð" (U+00F0)
  0x00, 0xF1, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x14, 0x5E, // "ñ" (U+00F1)
  0x00, 0xF2, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x14, 0x88, // "ò" (U+00F2)
  0x00, 0xF3, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x14, 0xA9, // "ó" (U+00F3)
  0x00, 0xF4, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x14, 0xC9, // "ô" (U+00F4)
  0x00, 0xF5, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x14, 0xEB, // "õ" (U+00F5)
  0x00, 0xF6, 0x00, 0x01, 0x06, 0x09, 0x07, 0x15, 0x0E, // "ö" (U+00F6)
  0x00, 0xF7, 0x00, 0x02, 0x05, 0x08, 0x07, 0x15, 0x30, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x00, 0x06, 0x08, 0x07, 0x15, 0x3E, // "ø" (U+00F8)
  0x00, 0xF9, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x15, 0x5C, // "ù" (U+00F9)
  0x00, 0xFA, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x15, 0x85, // "ú" (U+00FA)
  0x00, 0xFB, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x15, 0xAD, // "û" (U+00FB)
  0x00, 0xFC, 0x00, 0x01, 0x07, 0x09, 0x08, 0x15, 0xD7, // "ü" (U+00FC)
  0x00, 0xFD, 0x00, 0xFE, 0x06, 0x0A, 0x07, 0x16, 0x01, // "ý" (U+00FD)
  0x00, 0xFE, 0x00, 0xFE, 0x06, 0x0A, 0x07, 0x16, 0x28, // "þ" (U+00FE)
  0x00, 0xFF, 0x00, 0xFE, 0x06, 0x09, 0x07, 0x16, 0x55, // "ÿ" (U+00FF)
  0x01, 0x00, 0x00, 0x01, 0x08, 0x0B, 0x08, 0x16, 0x7E, // "Ā" (U+0100)
  0x01, 0x01, 0x00, 0x01, 0x06, 0x09, 0x07, 0x16, 0xA6, // "ā" (U+0101)
  0x01, 0x02, 0x00, 0x01, 0x08, 0x0D, 0x08, 0x16, 0xC4, // "Ă" (U+0102)
  0x01, 0x03, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x16, 0xF3, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0xFE, 0x08, 0x09, 0x08, 0x17, 0x18, // "Ą" (U+0104)
  0x01, 0x05, 0x00, 0xFE, 0x06, 0x07, 0x07, 0x17, 0x44, // "ą" (U+0105)
  0x01, 0x06, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x17, 0x67, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x17, 0x89, // "ć" (U+0107)
  0x01, 0x08, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x17, 0xA5, // "Ĉ" (U+0108)
  0x01, 0x09, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x17, 0xC8, // "ĉ" (U+0109)
  0x01, 0x0A, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x17, 0xE5, // "Ċ" (U+010A)
  0x01, 0x0B, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x18, 0x07, // "ċ" (U+010B)
  0x01, 0x0C, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x18, 0x23, // "Č" (U+010C)
  0x01, 0x0D, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x18, 0x46, // "č" (U+010D)
  0x01, 0x0E, 0x00, 0x01, 0x07, 0x0C, 0x09, 0x18, 0x63, // "Ď" (U+010E)
  0x01, 0x0F, 0x00, 0x01, 0x07, 0x0A, 0x07, 0x18, 0x92, // "ď" (U+010F)
  0x01, 0x10, 0x00, 0x01, 0x07, 0x09, 0x09, 0x18, 0xBC, // "Đ" (U+0110)
  0x01, 0x11, 0x00, 0x01, 0x07, 0x0A, 0x07, 0x18, 0xE4, // "đ" (U+0111)
  0x01, 0x12, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x19, 0x0E, // "Ē" (U+0112)
  0x01, 0x13, 0x00, 0x01, 0x05, 0x09, 0x06, 0x19, 0x31, // "ē" (U+0113)
  0x01, 0x14, 0x00, 0x01, 0x06, 0x0D, 0x07, 0x19, 0x4C, // "Ĕ" (U+0114)
  0x01, 0x15, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x19, 0x76, // "ĕ" (U+0115)
  0x01, 0x16, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x19, 0x97, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x19, 0xBC, // "ė" (U+0117)
  0x01, 0x18, 0x00, 0xFE, 0x06, 0x09, 0x07, 0x19, 0xD9, // "Ę" (U+0118)
  0x01, 0x19, 0x00, 0xFE, 0x05, 0x07, 0x06, 0x1A, 0x00, // "ę" (U+0119)
  0x01, 0x1A, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x1A, 0x1F, // "Ě" (U+011A)
  0x01, 0x1B, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x1A, 0x46, // "ě" (U+011B)
  0x01, 0x1C, 0x00, 0x01, 0x08, 0x0C, 0x09, 0x1A, 0x64, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x00, 0xFE, 0x06, 0x0A, 0x06, 0x1A, 0x94, // "ĝ" (U+011D)
  0x01, 0x1E, 0x00, 0x01, 0x08, 0x0D, 0x09, 0x1A, 0xC0, // "Ğ" (U+011E)
  0x01, 0x1F, 0x00, 0xFE, 0x06, 0x0B, 0x06, 0x1A, 0xF3, // "ğ" (U+011F)
  0x01, 0x20, 0x00, 0x01, 0x08, 0x0C, 0x09, 0x1B, 0x22, // "Ġ" (U+0120)
  0x01, 0x21, 0x00, 0xFE, 0x06, 0x0A, 0x06, 0x1B, 0x50, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0xFE, 0x08, 0x09, 0x09, 0x1B, 0x7B, // "Ģ" (U+0122)
  0x01, 0x23, 0x00, 0xFE, 0x06, 0x0A, 0x06, 0x1B, 0xA9, // "ģ" (U+0123)
  0x01, 0x24, 0x00, 0x01, 0x08, 0x0C, 0x0A, 0x1B, 0xD3, // "Ĥ" (U+0124)
  0x01, 0x25, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x1C, 0x08, // "ĥ" (U+0125)
  0x01, 0x26, 0x00, 0x01, 0x08, 0x09, 0x0A, 0x1C, 0x38, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x1C, 0x65, // "ħ" (U+0127)
  0x01, 0x28, 0x00, 0x01, 0x04, 0x0C, 0x04, 0x1C, 0x90, // "Ĩ" (U+0128)
  0x01, 0x29, 0xFF, 0x01, 0x03, 0x0A, 0x04, 0x1C, 0xB0, // "ĩ" (U+0129)
  0x01, 0x2A, 0x00, 0x01, 0x03, 0x0B, 0x04, 0x1C, 0xC9, // "Ī" (U+012A)
  0x01, 0x2B, 0x00, 0x01, 0x03, 0x09, 0x04, 0x1C, 0xE2, // "ī" (U+012B)
  0x01, 0x2C, 0x00, 0x01, 0x03, 0x0D, 0x04, 0x1C, 0xF7, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x00, 0x01, 0x03, 0x0B, 0x04, 0x1D, 0x15, // "ĭ" (U+012D)
  0x01, 0x2E, 0x00, 0xFE, 0x03, 0x09, 0x04, 0x1D, 0x2E, // "Į" (U+012E)
  0x01, 0x2F, 0x00, 0xFE, 0x03, 0x0A, 0x04, 0x1D, 0x4B, // "į" (U+012F)
  0x01, 0x30, 0x00, 0x01, 0x03, 0x0C, 0x04, 0x1D, 0x69, // "İ" (U+0130)
  0x01, 0x31, 0x00, 0x01, 0x03, 0x07, 0x04, 0x1D, 0x85, // "ı" (U+0131)
  0x01, 0x32, 0x00, 0xFE, 0x07, 0x09, 0x08, 0x1D, 0x97, // "Ĳ" (U+0132)
  0x01, 0x33, 0x00, 0xFE, 0x06, 0x0A, 0x07, 0x1D, 0xCC, // "ĳ" (U+0133)
  0x01, 0x34, 0xFF, 0xFE, 0x03, 0x0C, 0x04, 0x1D, 0xFB, // "Ĵ" (U+0134)
  0x01, 0x35, 0xFF, 0xFE, 0x02, 0x0A, 0x04, 0x1E, 0x20, // "ĵ" (U+0135)
  0x01, 0x36, 0x00, 0xFE, 0x08, 0x09, 0x08, 0x1E, 0x3E, // "Ķ" (U+0136)
  0x01, 0x37, 0x00, 0xFE, 0x06, 0x0A, 0x07, 0x1E, 0x6D, // "ķ" (U+0137)
  0x01, 0x38, 0x00, 0x01, 0x06, 0x07, 0x07, 0x1E, 0x96, // "ĸ" (U+0138)
  0x01, 0x39, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x1E, 0xB2, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x00, 0x01, 0x03, 0x0C, 0x04, 0x1E, 0xD3, // "ĺ" (U+013A)
  0x01, 0x3B, 0x00, 0xFE, 0x06, 0x09, 0x07, 0x1E, 0xF0, // "Ļ" (U+013B)
  0x01, 0x3C, 0x00, 0xFE, 0x03, 0x0A, 0x04, 0x1F, 0x11, // "ļ" (U+013C)
  0x01, 0x3D, 0x00, 0x01, 0x06, 0x09, 0x07, 0x1F, 0x2F, // "Ľ" (U+013D)
  0x01, 0x3E, 0x00, 0x01, 0x04, 0x0A, 0x04, 0x1F, 0x4D, // "ľ" (U+013E)
  0x01, 0x3F, 0x00, 0x01, 0x06, 0x09, 0x07, 0x1F, 0x68, // "Ŀ" (U+013F)
  0x01, 0x40, 0x00, 0x01, 0x04, 0x0A, 0x04, 0x1F, 0x86, // "ŀ" (U+0140)
  0x01, 0x41, 0x00, 0x01, 0x06, 0x09, 0x07, 0x1F, 0xA1, // "Ł" (U+0141)
  0x01, 0x42, 0x00, 0x01, 0x03, 0x0A, 0x04, 0x1F, 0xBE, // "ł" (U+0142)
  0x01, 0x43, 0x00, 0x01, 0x08, 0x0C, 0x09, 0x1F, 0xD7, // "Ń" (U+0143)
  0x01, 0x44, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x20, 0x0C, // "ń" (U+0144)
  0x01, 0x45, 0x00, 0xFE, 0x08, 0x09, 0x09, 0x20, 0x33, // "Ņ" (U+0145)
  0x01, 0x46, 0x00, 0xFE, 0x07, 0x07, 0x08, 0x20, 0x67, // "ņ" (U+0146)
  0x01, 0x47, 0x00, 0x01, 0x08, 0x0C, 0x09, 0x20, 0x8E, // "Ň" (U+0147)
  0x01, 0x48, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x20, 0xC5, // "ň" (U+0148)
  0x01, 0x49, 0x00, 0x01, 0x09, 0x09, 0x09, 0x20, 0xEE, // "ŉ" (U+0149)
  0x01, 0x4A, 0x00, 0xFE, 0x08, 0x09, 0x09, 0x21, 0x18, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x00, 0xFE, 0x06, 0x07, 0x08, 0x21, 0x4F, // "ŋ" (U+014B)
  0x01, 0x4C, 0x00, 0x01, 0x08, 0x0B, 0x09, 0x21, 0x74, // "Ō" (U+014C)
  0x01, 0x4D, 0x00, 0x01, 0x06, 0x09, 0x07, 0x21, 0xA1, // "ō" (U+014D)
  0x01, 0x4E, 0x00, 0x01, 0x08, 0x0D, 0x09, 0x21, 0xBF, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x21, 0xF3, // "ŏ" (U+014F)
  0x01, 0x50, 0x00, 0x01, 0x08, 0x0C, 0x09, 0x22, 0x18, // "Ő" (U+0150)
  0x01, 0x51, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x22, 0x49, // "ő" (U+0151)
  0x01, 0x52, 0x00, 0x01, 0x0A, 0x09, 0x0C, 0x22, 0x6B, // "Œ" (U+0152)
  0x01, 0x53, 0x00, 0x01, 0x0A, 0x07, 0x0B, 0x22, 0x9F, // "œ" (U+0153)
  0x01, 0x54, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x22, 0xC7, // "Ŕ" (U+0154)
  0x01, 0x55, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x22, 0xF7, // "ŕ" (U+0155)
  0x01, 0x56, 0x00, 0xFE, 0x07, 0x09, 0x08, 0x23, 0x11, // "Ŗ" (U+0156)
  0x01, 0x57, 0x00, 0xFE, 0x05, 0x07, 0x06, 0x23, 0x41, // "ŗ" (U+0157)
  0x01, 0x58, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x23, 0x5A, // "Ř" (U+0158)
  0x01, 0x59, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x23, 0x8C, // "ř" (U+0159)
  0x01, 0x5A, 0x00, 0x01, 0x05, 0x0C, 0x07, 0x23, 0xA7, // "Ś" (U+015A)
  0x01, 0x5B, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x23, 0xCA, // "ś" (U+015B)
  0x01, 0x5C, 0x00, 0x01, 0x05, 0x0C, 0x07, 0x23, 0xE3, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x24, 0x07, // "ŝ" (U+015D)
  0x01, 0x5E, 0x00, 0xFE, 0x05, 0x09, 0x07, 0x24, 0x20, // "Ş" (U+015E)
  0x01, 0x5F, 0x00, 0xFE, 0x04, 0x07, 0x05, 0x24, 0x45, // "ş" (U+015F)
  0x01, 0x60, 0x00, 0x01, 0x05, 0x0C, 0x07, 0x24, 0x60, // "Š" (U+0160)
  0x01, 0x61, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x24, 0x84, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFE, 0x07, 0x09, 0x07, 0x24, 0x9E, // "Ţ" (U+0162)
  0x01, 0x63, 0x00, 0xFE, 0x04, 0x09, 0x04, 0x24, 0xC4, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x07, 0x0C, 0x07, 0x24, 0xE3, // "Ť" (U+0164)
  0x01, 0x65, 0x00, 0x01, 0x04, 0x0A, 0x04, 0x25, 0x09, // "ť" (U+0165)
  0x01, 0x66, 0x00, 0x01, 0x07, 0x09, 0x07, 0x25, 0x24, // "Ŧ" (U+0166)
  0x01, 0x67, 0x00, 0x01, 0x03, 0x09, 0x04, 0x25, 0x45, // "ŧ" (U+0167)
  0x01, 0x68, 0x00, 0x01, 0x08, 0x0C, 0x09, 0x25, 0x5A, // "Ũ" (U+0168)
  0x01, 0x69, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x25, 0x8F, // "ũ" (U+0169)
  0x01, 0x6A, 0x00, 0x01, 0x08, 0x0B, 0x09, 0x25, 0xBA, // "Ū" (U+016A)
  0x01, 0x6B, 0x00, 0x01, 0x07, 0x09, 0x08, 0x25, 0xEA, // "ū" (U+016B)
  0x01, 0x6C, 0x00, 0x01, 0x08, 0x0D, 0x09, 0x26, 0x10, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x00, 0x01, 0x07, 0x0B, 0x08, 0x26, 0x47, // "ŭ" (U+016D)
  0x01, 0x6E, 0x00, 0x01, 0x08, 0x0C, 0x09, 0x26, 0x74, // "Ů" (U+016E)
  0x01, 0x6F, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x26, 0xAB, // "ů" (U+016F)
  0x01, 0x70, 0x00, 0x01, 0x08, 0x0C, 0x09, 0x26, 0xD8, // "Ű" (U+0170)
  0x01, 0x71, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x27, 0x0C, // "ű" (U+0171)
  0x01, 0x72, 0x00, 0xFE, 0x08, 0x09, 0x09, 0x27, 0x36, // "Ų" (U+0172)
  0x01, 0x73, 0x00, 0xFE, 0x07, 0x07, 0x08, 0x27, 0x6B, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x0C, 0x0C, 0x0D, 0x27, 0x96, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x0A, 0x0A, 0x0A, 0x27, 0xDA, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x28, 0x0A, // "Ŷ" (U+0176)
  0x01, 0x77, 0x00, 0xFE, 0x06, 0x0A, 0x07, 0x28, 0x32, // "ŷ" (U+0177)
  0x01, 0x78, 0x00, 0x01, 0x07, 0x0B, 0x08, 0x28, 0x5B, // "Ÿ" (U+0178)
  0x01, 0x79, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x28, 0x83, // "Ź" (U+0179)
  0x01, 0x7A, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x28, 0xA9, // "ź" (U+017A)
  0x01, 0x7B, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x28, 0xC6, // "Ż" (U+017B)
  0x01, 0x7C, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x28, 0xEC, // "ż" (U+017C)
  0x01, 0x7D, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x29, 0x09, // "Ž" (U+017D)
  0x01, 0x7E, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x29, 0x31, // "ž" (U+017E)
  0x01, 0x7F, 0x00, 0x01, 0x04, 0x0A, 0x04, 0x29, 0x4F, // "ſ" (U+017F)
  0x03, 0xA9, 0x00, 0x01, 0x08, 0x09, 0x09, 0x29, 0x6A, // "Ω" (U+03A9)
  0x03, 0xBC, 0x01, 0xFE, 0x06, 0x07, 0x07, 0x29, 0x92, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x01, 0x06, 0x07, 0x08, 0x29, 0xB1, // "π" (U+03C0)
  0x20, 0x13, 0x00, 0x04, 0x05, 0x04, 0x06, 0x29, 0xCE, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x04, 0x0B, 0x04, 0x0C, 0x29, 0xD0, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x01, 0x06, 0x09, 0x07, 0x29, 0xD3, // "€" (U+20AC)
  0x20, 0xBF, 0x00, 0x00, 0x06, 0x0A, 0x07, 0x29, 0xF2, // "₿" (U+20BF)
  0x20, 0x18, 0x00, 0x07, 0x02, 0x0A, 0x03, 0x2A, 0x1D, // "‘" (U+2018)
  0x20, 0x19, 0x00, 0x06, 0x02, 0x09, 0x03, 0x2A, 0x25, // "’" (U+2019)
  0x20, 0x1A, 0x00, 0xFF, 0x02, 0x02, 0x03, 0x2A, 0x2D, // "‚" (U+201A)
  0x20, 0x1B, 0x00, 0x06, 0x02, 0x09, 0x03, 0x2A, 0x35, // "‛" (U+201B)
  0x20, 0x1C, 0x00, 0x07, 0x04, 0x0A, 0x05, 0x2A, 0x3D, // "“" (U+201C)
  0x20, 0x1D, 0x00, 0x06, 0x04, 0x09, 0x05, 0x2A, 0x49, // "”" (U+201D)
  0x20, 0x1E, 0x00, 0xFF, 0x04, 0x02, 0x05, 0x2A, 0x55, // "„" (U+201E)
  0x20, 0x1F, 0x00, 0x06, 0x04, 0x09, 0x05, 0x2A, 0x61, // "‟" (U+201F)
  0x20, 0x20, 0x00, 0x00, 0x04, 0x0A, 0x05, 0x2A, 0x6D, // "†" (U+2020)
  0x20, 0x21, 0x00, 0x00, 0x04, 0x0A, 0x05, 0x2A, 0x87, // "‡" (U+2021)
  0x20, 0x22, 0x00, 0x04, 0x03, 0x07, 0x04, 0x2A, 0xA4, // "•" (U+2022)
  0x20, 0x26, 0x01, 0x01, 0x09, 0x02, 0x0A, 0x2A, 0xAE, // "…" (U+2026)
  0x20, 0x30, 0x00, 0x01, 0x0E, 0x09, 0x0F, 0x2A, 0xB9, // "‰" (U+2030)
  0x20, 0x39, 0x00, 0x02, 0x02, 0x06, 0x04, 0x2A, 0xF9, // "‹" (U+2039)
  0x20, 0x3A, 0x01, 0x02, 0x03, 0x06, 0x04, 0x2B, 0x02, // "›" (U+203A)
  0x20, 0x44, 0xFE, 0x01, 0x02, 0x09, 0x01, 0x2B, 0x0B, // "⁄" (U+2044)
  0x21, 0x22, 0x00, 0x05, 0x09, 0x09, 0x0A, 0x2B, 0x20, // "™" (U+2122)
  0x21, 0x52, 0x00, 0x00, 0x0D, 0x09, 0x0E, 0x2B, 0x3D, // "⅒" (U+2152)
  0xFB, 0x01, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x2B, 0x7B, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x2B, 0xAA, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x01, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0xC0, 0x01, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x01, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x01, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x01, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x01, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x01, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xC6, 0x01, // "Æ (U+0022 U+00C6)
  0x00, 0x22, 0x01, 0x00, 0x01, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x02, 0x01, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x04, 0x01, // "Ą (U+0022 U+0104)
  0x00, 0x27, 0x00, 0x41, 0x01, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0xC0, 0x01, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x01, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x01, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x01, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x01, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x01, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xC6, 0x01, // 'Æ (U+0027 U+00C6)
  0x00, 0x27, 0x01, 0x00, 0x01, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x02, 0x01, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x04, 0x01, // 'Ą (U+0027 U+0104)
  0x00, 0x2A, 0x00, 0x2C, 0x01, // *, (U+002A U+002C)
  0x00, 0x2A, 0x00, 0x2E, 0x01, // *. (U+002A U+002E)
  0x00, 0x2A, 0x00, 0x41, 0x01, // *A (U+002A U+0041)
  0x00, 0x2A, 0x00, 0xC0, 0x01, // *À (U+002A U+00C0)
  0x00, 0x2A, 0x00, 0xC1, 0x01, // *Á (U+002A U+00C1)
  0x00, 0x2A, 0x00, 0xC2, 0x01, // *Â (U+002A U+00C2)
  0x00, 0x2A, 0x00, 0xC3, 0x01, // *Ã (U+002A U+00C3)
  0x00, 0x2A, 0x00, 0xC4, 0x01, // *Ä (U+002A U+00C4)
  0x00, 0x2A, 0x00, 0xC5, 0x01, // *Å (U+002A U+00C5)
  0x00, 0x2A, 0x00, 0xC6, 0x01, // *Æ (U+002A U+00C6)
  0x00, 0x2A, 0x01, 0x00, 0x01, // *Ā (U+002A U+0100)
  0x00, 0x2A, 0x01, 0x02, 0x01, // *Ă (U+002A U+0102)
  0x00, 0x2A, 0x01, 0x04, 0x01, // *Ą (U+002A U+0104)
  0x00, 0x2A, 0x20, 0x1A, 0x01, // *‚ (U+002A U+201A)
  0x00, 0x2A, 0x20, 0x1E, 0x01, // *„ (U+002A U+201E)
  0x00, 0x2A, 0x20, 0x26, 0x01, // *… (U+002A U+2026)
  0x00, 0x2C, 0x00, 0x3F, 0x01, // ,? (U+002C U+003F)
  0x00, 0x2C, 0x00, 0x54, 0x01, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x56, 0x01, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x01, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x01, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0x76, 0x01, // ,v (U+002C U+0076)
  0x00, 0x2C, 0x00, 0x77, 0x01, // ,w (U+002C U+0077)
  0x00, 0x2C, 0x00, 0x79, 0x01, // ,y (U+002C U+0079)
  0x00, 0x2C, 0x00, 0xDD, 0x01, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x00, 0xFD, 0x01, // ,ý (U+002C U+00FD)
  0x00, 0x2C, 0x00, 0xFF, 0x01, // ,ÿ (U+002C U+00FF)
  0x00, 0x2C, 0x01, 0x62, 0x01, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x01, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x01, // ,Ŧ (U+002C U+0166)
  0x00, 0x2C, 0x01, 0x74, 0x01, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x75, 0x01, // ,ŵ (U+002C U+0175)
  0x00, 0x2C, 0x01, 0x76, 0x01, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x77, 0x01, // ,ŷ (U+002C U+0177)
  0x00, 0x2C, 0x01, 0x78, 0x01, // ,Ÿ (U+002C U+0178)
  0x00, 0x2E, 0x00, 0x3F, 0x01, // .? (U+002E U+003F)
  0x00, 0x2E, 0x00, 0x54, 0x01, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x56, 0x01, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x01, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x01, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0x76, 0x01, // .v (U+002E U+0076)
  0x00, 0x2E, 0x00, 0x77, 0x01, // .w (U+002E U+0077)
  0x00, 0x2E, 0x00, 0x79, 0x01, // .y (U+002E U+0079)
  0x00, 0x2E, 0x00, 0xDD, 0x01, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x00, 0xFD, 0x01, // .ý (U+002E U+00FD)
  0x00, 0x2E, 0x00, 0xFF, 0x01, // .ÿ (U+002E U+00FF)
  0x00, 0x2E, 0x01, 0x62, 0x01, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x01, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x01, // .Ŧ (U+002E U+0166)
  0x00, 0x2E, 0x01, 0x74, 0x01, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x75, 0x01, // .ŵ (U+002E U+0175)
  0x00, 0x2E, 0x01, 0x76, 0x01, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x77, 0x01, // .ŷ (U+002E U+0177)
  0x00, 0x2E, 0x01, 0x78, 0x01, // .Ÿ (U+002E U+0178)
  0x00, 0x30, 0x20, 0x44, 0x02, // 0⁄ (U+0030 U+2044)
  0x00, 0x31, 0x20, 0x44, 0x02, // 1⁄ (U+0031 U+2044)
  0x00, 0x32, 0x20, 0x44, 0x02, // 2⁄ (U+0032 U+2044)
  0x00, 0x33, 0x20, 0x44, 0x02, // 3⁄ (U+0033 U+2044)
  0x00, 0x34, 0x20, 0x44, 0x02, // 4⁄ (U+0034 U+2044)
  0x00, 0x35, 0x20, 0x44, 0x02, // 5⁄ (U+0035 U+2044)
  0x00, 0x36, 0x20, 0x44, 0x02, // 6⁄ (U+0036 U+2044)
  0x00, 0x37, 0x20, 0x44, 0x02, // 7⁄ (U+0037 U+2044)
  0x00, 0x38, 0x20, 0x44, 0x02, // 8⁄ (U+0038 U+2044)
  0x00, 0x39, 0x20, 0x44, 0x02, // 9⁄ (U+0039 U+2044)
  0x00, 0x41, 0x00, 0x22, 0x01, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x01, // A' (U+0041 U+0027)
  0x00, 0x41, 0x00, 0x2A, 0x01, // A* (U+0041 U+002A)
  0x00, 0x41, 0x00, 0x3F, 0x01, // A? (U+0041 U+003F)
  0x00, 0x41, 0x00, 0x54, 0x01, // AT (U+0041 U+0054)
  0x00, 0x41, 0x00, 0x56, 0x01, // AV (U+0041 U+0056)
  0x00, 0x41, 0x00, 0x57, 0x01, // AW (U+0041 U+0057)
  0x00, 0x41, 0x00, 0x59, 0x01, // AY (U+0041 U+0059)
  0x00, 0x41, 0x00, 0x76, 0x01, // Av (U+0041 U+0076)
  0x00, 0x41, 0x00, 0x79, 0x01, // Ay (U+0041 U+0079)
  0x00, 0x41, 0x00, 0xDD, 0x01, // AÝ (U+0041 U+00DD)
  0x00, 0x41, 0x00, 0xFD, 0x01, // Aý (U+0041 U+00FD)
  0x00, 0x41, 0x00, 0xFF, 0x01, // Aÿ (U+0041 U+00FF)
  0x00, 0x41, 0x01, 0x62, 0x01, // AŢ (U+0041 U+0162)
  0x00, 0x41, 0x01, 0x64, 0x01, // AŤ (U+0041 U+0164)
  0x00, 0x41, 0x01, 0x66, 0x01, // AŦ (U+0041 U+0166)
  0x00, 0x41, 0x01, 0x74, 0x01, // AŴ (U+0041 U+0174)
  0x00, 0x41, 0x01, 0x76, 0x01, // AŶ (U+0041 U+0176)
  0x00, 0x41, 0x01, 0x77, 0x01, // Aŷ (U+0041 U+0177)
  0x00, 0x41, 0x01, 0x78, 0x01, // AŸ (U+0041 U+0178)
  0x00, 0x41, 0x20, 0x18, 0x01, // A‘ (U+0041 U+2018)
  0x00, 0x41, 0x20, 0x19, 0x01, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1C, 0x01, // A“ (U+0041 U+201C)
  0x00, 0x41, 0x20, 0x1D, 0x01, // A” (U+0041 U+201D)
  0x00, 0x41, 0x21, 0x22, 0x01, // A™ (U+0041 U+2122)
  0x00, 0x44, 0x00, 0xC6, 0x01, // DÆ (U+0044 U+00C6)
  0x00, 0x46, 0x00, 0x2C, 0x01, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x01, // F. (U+0046 U+002E)
  0x00, 0x46, 0x00, 0x41, 0x01, // FA (U+0046 U+0041)
  0x00, 0x46, 0x00, 0xC0, 0x01, // FÀ (U+0046 U+00C0)
  0x00, 0x46, 0x00, 0xC1, 0x01, // FÁ (U+0046 U+00C1)
  0x00, 0x46, 0x00, 0xC2, 0x01, // FÂ (U+0046 U+00C2)
  0x00, 0x46, 0x00, 0xC3, 0x01, // FÃ (U+0046 U+00C3)
  0x00, 0x46, 0x00, 0xC4, 0x01, // FÄ (U+0046 U+00C4)
  0x00, 0x46, 0x00, 0xC5, 0x01, // FÅ (U+0046 U+00C5)
  0x00, 0x46, 0x00, 0xC6, 0x01, // FÆ (U+0046 U+00C6)
  0x00, 0x46, 0x01, 0x00, 0x01, // FĀ (U+0046 U+0100)
  0x00, 0x46, 0x01, 0x02, 0x01, // FĂ (U+0046 U+0102)
  0x00, 0x46, 0x01, 0x04, 0x01, // FĄ (U+0046 U+0104)
  0x00, 0x46, 0x20, 0x1A, 0x01, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x01, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x01, // F… (U+0046 U+2026)
  0x00, 0x4C, 0x00, 0x22, 0x01, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x01, // L' (U+004C U+0027)
  0x00, 0x4C, 0x00, 0x2A, 0x01, // L* (U+004C U+002A)
  0x00, 0x4C, 0x00, 0x3F, 0x01, // L? (U+004C U+003F)
  0x00, 0x4C, 0x00, 0x54, 0x01, // LT (U+004C U+0054)
  0x00, 0x4C, 0x00, 0x56, 0x01, // LV (U+004C U+0056)
  0x00, 0x4C, 0x00, 0x57, 0x01, // LW (U+004C U+0057)
  0x00, 0x4C, 0x00, 0x59, 0x01, // LY (U+004C U+0059)
  0x00, 0x4C, 0x00, 0xDD, 0x01, // LÝ (U+004C U+00DD)
  0x00, 0x4C, 0x01, 0x62, 0x01, // LŢ (U+004C U+0162)
  0x00, 0x4C, 0x01, 0x64, 0x01, // LŤ (U+004C U+0164)
  0x00, 0x4C, 0x01, 0x66, 0x01, // LŦ (U+004C U+0166)
  0x00, 0x4C, 0x01, 0x74, 0x01, // LŴ (U+004C U+0174)
  0x00, 0x4C, 0x01, 0x76, 0x01, // LŶ (U+004C U+0176)
  0x00, 0x4C, 0x01, 0x78, 0x01, // LŸ (U+004C U+0178)
  0x00, 0x4C, 0x20, 0x18, 0x01, // L‘ (U+004C U+2018)
  0x00, 0x4C, 0x20, 0x19, 0x01, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1C, 0x01, // L“ (U+004C U+201C)
  0x00, 0x4C, 0x20, 0x1D, 0x01, // L” (U+004C U+201D)
  0x00, 0x4C, 0x21, 0x22, 0x01, // L™ (U+004C U+2122)
  0x00, 0x4F, 0x00, 0xC6, 0x01, // OÆ (U+004F U+00C6)
  0x00, 0x50, 0x00, 0x2C, 0x01, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x01, // P. (U+0050 U+002E)
  0x00, 0x50, 0x00, 0x41, 0x01, // PA (U+0050 U+0041)
  0x00, 0x50, 0x00, 0xC0, 0x01, // PÀ (U+0050 U+00C0)
  0x00, 0x50, 0x00, 0xC1, 0x01, // PÁ (U+0050 U+00C1)
  0x00, 0x50, 0x00, 0xC2, 0x01, // PÂ (U+0050 U+00C2)
  0x00, 0x50, 0x00, 0xC3, 0x01, // PÃ (U+0050 U+00C3)
  0x00, 0x50, 0x00, 0xC4, 0x01, // PÄ (U+0050 U+00C4)
  0x00, 0x50, 0x00, 0xC5, 0x01, // PÅ (U+0050 U+00C5)
  0x00, 0x50, 0x00, 0xC6, 0x01, // PÆ (U+0050 U+00C6)
  0x00, 0x50, 0x01, 0x00, 0x01, // PĀ (U+0050 U+0100)
  0x00, 0x50, 0x01, 0x02, 0x01, // PĂ (U+0050 U+0102)
  0x00, 0x50, 0x01, 0x04, 0x01, // PĄ (U+0050 U+0104)
  0x00, 0x50, 0x20, 0x1A, 0x01, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x01, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x01, // P… (U+0050 U+2026)
  0x00, 0x51, 0x00, 0xC6, 0x01, // QÆ (U+0051 U+00C6)
  0x00, 0x54, 0x00, 0x2C, 0x01, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2E, 0x01, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0x41, 0x01, // TA (U+0054 U+0041)
  0x00, 0x54, 0x00, 0x63, 0x01, // Tc (U+0054 U+0063)
  0x00, 0x54, 0x00, 0x64, 0x01, // Td (U+0054 U+0064)
  0x00, 0x54, 0x00, 0x65, 0x01, // Te (U+0054 U+0065)
  0x00, 0x54, 0x00, 0x67, 0x01, // Tg (U+0054 U+0067)
  0x00, 0x54, 0x00, 0x6F, 0x01, // To (U+0054 U+006F)
  0x00, 0x54, 0x00, 0x71, 0x01, // Tq (U+0054 U+0071)
  0x00, 0x54, 0x00, 0xC0, 0x01, // TÀ (U+0054 U+00C0)
  0x00, 0x54, 0x00, 0xC1, 0x01, // TÁ (U+0054 U+00C1)
  0x00, 0x54, 0x00, 0xC2, 0x01, // TÂ (U+0054 U+00C2)
  0x00, 0x54, 0x00, 0xC3, 0x01, // TÃ (U+0054 U+00C3)
  0x00, 0x54, 0x00, 0xC4, 0x01, // TÄ (U+0054 U+00C4)
  0x00, 0x54, 0x00, 0xC5, 0x01, // TÅ (U+0054 U+00C5)
  0x00, 0x54, 0x00, 0xC6, 0x01, // TÆ (U+0054 U+00C6)
  0x00, 0x54, 0x00, 0xE7, 0x01, // Tç (U+0054 U+00E7)
  0x00, 0x54, 0x00, 0xE8, 0x01, // Tè (U+0054 U+00E8)
  0x00, 0x54, 0x00, 0xE9, 0x01, // Té (U+0054 U+00E9)
  0x00, 0x54, 0x00, 0xEA, 0x01, // Tê (U+0054 U+00EA)
  0x00, 0x54, 0x00, 0xEB, 0x01, // Të (U+0054 U+00EB)
  0x00, 0x54, 0x00, 0xF0, 0x01, // Tð (U+0054 U+00F0)
  0x00, 0x54, 0x00, 0xF2, 0x01, // Tò (U+0054 U+00F2)
  0x00, 0x54, 0x00, 0xF3, 0x01, // Tó (U+0054 U+00F3)
  0x00, 0x54, 0x00, 0xF4, 0x01, // Tô (U+0054 U+00F4)
  0x00, 0x54, 0x00, 0xF5, 0x01, // Tõ (U+0054 U+00F5)
  0x00, 0x54, 0x00, 0xF6, 0x01, // Tö (U+0054 U+00F6)
  0x00, 0x54, 0x00, 0xF8, 0x01, // Tø (U+0054 U+00F8)
  0x00, 0x54, 0x01, 0x00, 0x01, // TĀ (U+0054 U+0100)
  0x00, 0x54, 0x01, 0x02, 0x01, // TĂ (U+0054 U+0102)
  0x00, 0x54, 0x01, 0x04, 0x01, // TĄ (U+0054 U+0104)
  0x00, 0x54, 0x01, 0x07, 0x01, // Tć (U+0054 U+0107)
  0x00, 0x54, 0x01, 0x09, 0x01, // Tĉ (U+0054 U+0109)
  0x00, 0x54, 0x01, 0x0B, 0x01, // Tċ (U+0054 U+010B)
  0x00, 0x54, 0x01, 0x0D, 0x01, // Tč (U+0054 U+010D)
  0x00, 0x54, 0x01, 0x0F, 0x01, // Tď (U+0054 U+010F)
  0x00, 0x54, 0x01, 0x11, 0x01, // Tđ (U+0054 U+0111)
  0x00, 0x54, 0x01, 0x13, 0x01, // Tē (U+0054 U+0113)
  0x00, 0x54, 0x01, 0x15, 0x01, // Tĕ (U+0054 U+0115)
  0x00, 0x54, 0x01, 0x17, 0x01, // Tė (U+0054 U+0117)
  0x00, 0x54, 0x01, 0x19, 0x01, // Tę (U+0054 U+0119)
  0x00, 0x54, 0x01, 0x1B, 0x01, // Tě (U+0054 U+011B)
  0x00, 0x54, 0x01, 0x1D, 0x01, // Tĝ (U+0054 U+011D)
  0x00, 0x54, 0x01, 0x1F, 0x01, // Tğ (U+0054 U+011F)
  0x00, 0x54, 0x01, 0x21, 0x01, // Tġ (U+0054 U+0121)
  0x00, 0x54, 0x01, 0x23, 0x01, // Tģ (U+0054 U+0123)
  0x00, 0x54, 0x01, 0x4D, 0x01, // Tō (U+0054 U+014D)
  0x00, 0x54, 0x01, 0x4F, 0x01, // Tŏ (U+0054 U+014F)
  0x00, 0x54, 0x01, 0x51, 0x01, // Tő (U+0054 U+0151)
  0x00, 0x54, 0x01, 0x53, 0x01, // Tœ (U+0054 U+0153)
  0x00, 0x54, 0x20, 0x1A, 0x01, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x01, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x01, // T… (U+0054 U+2026)
  0x00, 0x56, 0x00, 0x2C, 0x01, // V, (U+0056 U+002C)
  0x00, 0x56, 0x00, 0x2E, 0x01, // V. (U+0056 U+002E)
  0x00, 0x56, 0x00, 0x40, 0x01, // V@ (U+0056 U+0040)
  0x00, 0x56, 0x00, 0x41, 0x01, // VA (U+0056 U+0041)
  0x00, 0x56, 0x00, 0x61, 0x01, // Va (U+0056 U+0061)
  0x00, 0x56, 0x00, 0x63, 0x01, // Vc (U+0056 U+0063)
  0x00, 0x56, 0x00, 0x64, 0x01, // Vd (U+0056 U+0064)
  0x00, 0x56, 0x00, 0x65, 0x01, // Ve (U+0056 U+0065)
  0x00, 0x56, 0x00, 0x67, 0x01, // Vg (U+0056 U+0067)
  0x00, 0x56, 0x00, 0x6F, 0x01, // Vo (U+0056 U+006F)
  0x00, 0x56, 0x00, 0x71, 0x01, // Vq (U+0056 U+0071)
  0x00, 0x56, 0x00, 0xC0, 0x01, // VÀ (U+0056 U+00C0)
  0x00, 0x56, 0x00, 0xC1, 0x01, // VÁ (U+0056 U+00C1)
  0x00, 0x56, 0x00, 0xC2, 0x01, // VÂ (U+0056 U+00C2)
  0x00, 0x56, 0x00, 0xC3, 0x01, // VÃ (U+0056 U+00C3)
  0x00, 0x56, 0x00, 0xC4, 0x01, // VÄ (U+0056 U+00C4)
  0x00, 0x56, 0x00, 0xC5, 0x01, // VÅ (U+0056 U+00C5)
  0x00, 0x56, 0x00, 0xC6, 0x02, // VÆ (U+0056 U+00C6)
  0x00, 0x56, 0x00, 0xE0, 0x01, // Và (U+0056 U+00E0)
  0x00, 0x56, 0x00, 0xE1, 0x01, // Vá (U+0056 U+00E1)
  0x00, 0x56, 0x00, 0xE2, 0x01, // Vâ (U+0056 U+00E2)
  0x00, 0x56, 0x00, 0xE3, 0x01, // Vã (U+0056 U+00E3)
  0x00, 0x56, 0x00, 0xE4, 0x01, // Vä (U+0056 U+00E4)
  0x00, 0x56, 0x00, 0xE5, 0x01, // Vå (U+0056 U+00E5)
  0x00, 0x56, 0x00, 0xE6, 0x01, // Væ (U+0056 U+00E6)
  0x00, 0x56, 0x00, 0xE7, 0x01, // Vç (U+0056 U+00E7)
  0x00, 0x56, 0x00, 0xE8, 0x01, // Vè (U+0056 U+00E8)
  0x00, 0x56, 0x00, 0xE9, 0x01, // Vé (U+0056 U+00E9)
  0x00, 0x56, 0x00, 0xEA, 0x01, // Vê (U+0056 U+00EA)
  0x00, 0x56, 0x00, 0xEB, 0x01, // Vë (U+0056 U+00EB)
  0x00, 0x56, 0x00, 0xF0, 0x01, // Vð (U+0056 U+00F0)
  0x00, 0x56, 0x00, 0xF2, 0x01, // Vò (U+0056 U+00F2)
  0x00, 0x56, 0x00, 0xF3, 0x01, // Vó (U+0056 U+00F3)
  0x00, 0x56, 0x00, 0xF4, 0x01, // Vô (U+0056 U+00F4)
  0x00, 0x56, 0x00, 0xF5, 0x01, // Võ (U+0056 U+00F5)
  0x00, 0x56, 0x00, 0xF6, 0x01, // Vö (U+0056 U+00F6)
  0x00, 0x56, 0x00, 0xF8, 0x01, // Vø (U+0056 U+00F8)
  0x00, 0x56, 0x01, 0x00, 0x01, // VĀ (U+0056 U+0100)
  0x00, 0x56, 0x01, 0x01, 0x01, // Vā (U+0056 U+0101)
  0x00, 0x56, 0x01, 0x02, 0x01, // VĂ (U+0056 U+0102)
  0x00, 0x56, 0x01, 0x03, 0x01, // Vă (U+0056 U+0103)
  0x00, 0x56, 0x01, 0x04, 0x01, // VĄ (U+0056 U+0104)
  0x00, 0x56, 0x01, 0x05, 0x01, // Vą (U+0056 U+0105)
  0x00, 0x56, 0x01, 0x07, 0x01, // Vć (U+0056 U+0107)
  0x00, 0x56, 0x01, 0x09, 0x01, // Vĉ (U+0056 U+0109)
  0x00, 0x56, 0x01, 0x0B, 0x01, // Vċ (U+0056 U+010B)
  0x00, 0x56, 0x01, 0x0D, 0x01, // Vč (U+0056 U+010D)
  0x00, 0x56, 0x01, 0x0F, 0x01, // Vď (U+0056 U+010F)
  0x00, 0x56, 0x01, 0x11, 0x01, // Vđ (U+0056 U+0111)
  0x00, 0x56, 0x01, 0x13, 0x01, // Vē (U+0056 U+0113)
  0x00, 0x56, 0x01, 0x15, 0x01, // Vĕ (U+0056 U+0115)
  0x00, 0x56, 0x01, 0x17, 0x01, // Vė (U+0056 U+0117)
  0x00, 0x56, 0x01, 0x19, 0x01, // Vę (U+0056 U+0119)
  0x00, 0x56, 0x01, 0x1B, 0x01, // Vě (U+0056 U+011B)
  0x00, 0x56, 0x01, 0x1D, 0x01, // Vĝ (U+0056 U+011D)
  0x00, 0x56, 0x01, 0x1F, 0x01, // Vğ (U+0056 U+011F)
  0x00, 0x56, 0x01, 0x21, 0x01, // Vġ (U+0056 U+0121)
  0x00, 0x56, 0x01, 0x23, 0x01, // Vģ (U+0056 U+0123)
  0x00, 0x56, 0x01, 0x4D, 0x01, // Vō (U+0056 U+014D)
  0x00, 0x56, 0x01, 0x4F, 0x01, // Vŏ (U+0056 U+014F)
  0x00, 0x56, 0x01, 0x51, 0x01, // Vő (U+0056 U+0151)
  0x00, 0x56, 0x01, 0x53, 0x01, // Vœ (U+0056 U+0153)
  0x00, 0x56, 0x20, 0x1A, 0x01, // V‚ (U+0056 U+201A)
  0x00, 0x56, 0x20, 0x1E, 0x01, // V„ (U+0056 U+201E)
  0x00, 0x56, 0x20, 0x26, 0x01, // V… (U+0056 U+2026)
  0x00, 0x57, 0x00, 0x2C, 0x01, // W, (U+0057 U+002C)
  0x00, 0x57, 0x00, 0x2E, 0x01, // W. (U+0057 U+002E)
  0x00, 0x57, 0x00, 0x40, 0x01, // W@ (U+0057 U+0040)
  0x00, 0x57, 0x00, 0x41, 0x01, // WA (U+0057 U+0041)
  0x00, 0x57, 0x00, 0x61, 0x01, // Wa (U+0057 U+0061)
  0x00, 0x57, 0x00, 0x63, 0x01, // Wc (U+0057 U+0063)
  0x00, 0x57, 0x00, 0x64, 0x01, // Wd (U+0057 U+0064)
  0x00, 0x57, 0x00, 0x65, 0x01, // We (U+0057 U+0065)
  0x00, 0x57, 0x00, 0x67, 0x01, // Wg (U+0057 U+0067)
  0x00, 0x57, 0x00, 0x6F, 0x01, // Wo (U+0057 U+006F)
  0x00, 0x57, 0x00, 0x71, 0x01, // Wq (U+0057 U+0071)
  0x00, 0x57, 0x00, 0x73, 0x01, // Ws (U+0057 U+0073)
  0x00, 0x57, 0x00, 0xC0, 0x01, // WÀ (U+0057 U+00C0)
  0x00, 0x57, 0x00, 0xC1, 0x01, // WÁ (U+0057 U+00C1)
  0x00, 0x57, 0x00, 0xC2, 0x01, // WÂ (U+0057 U+00C2)
  0x00, 0x57, 0x00, 0xC3, 0x01, // WÃ (U+0057 U+00C3)
  0x00, 0x57, 0x00, 0xC4, 0x01, // WÄ (U+0057 U+00C4)
  0x00, 0x57, 0x00, 0xC5, 0x01, // WÅ (U+0057 U+00C5)
  0x00, 0x57, 0x00, 0xC6, 0x02, // WÆ (U+0057 U+00C6)
  0x00, 0x57, 0x00, 0xE0, 0x01, // Wà (U+0057 U+00E0)
  0x00, 0x57, 0x00, 0xE1, 0x01, // Wá (U+0057 U+00E1)
  0x00, 0x57, 0x00, 0xE2, 0x01, // Wâ (U+0057 U+00E2)
  0x00, 0x57, 0x00, 0xE3, 0x01, // Wã (U+0057 U+00E3)
  0x00, 0x57, 0x00, 0xE4, 0x01, // Wä (U+0057 U+00E4)
  0x00, 0x57, 0x00, 0xE5, 0x01, // Wå (U+0057 U+00E5)
  0x00, 0x57, 0x00, 0xE6, 0x01, // Wæ (U+0057 U+00E6)
  0x00, 0x57, 0x00, 0xE7, 0x01, // Wç (U+0057 U+00E7)
  0x00, 0x57, 0x00, 0xE8, 0x01, // Wè (U+0057 U+00E8)
  0x00, 0x57, 0x00, 0xE9, 0x01, // Wé (U+0057 U+00E9)
  0x00, 0x57, 0x00, 0xEA, 0x01, // Wê (U+0057 U+00EA)
  0x00, 0x57, 0x00, 0xEB, 0x01, // Wë (U+0057 U+00EB)
  0x00, 0x57, 0x00, 0xF0, 0x01, // Wð (U+0057 U+00F0)
  0x00, 0x57, 0x00, 0xF2, 0x01, // Wò (U+0057 U+00F2)
  0x00, 0x57, 0x00, 0xF3, 0x01, // Wó (U+0057 U+00F3)
  0x00, 0x57, 0x00, 0xF4, 0x01, // Wô (U+0057 U+00F4)
  0x00, 0x57, 0x00, 0xF5, 0x01, // Wõ (U+0057 U+00F5)
  0x00, 0x57, 0x00, 0xF6, 0x01, // Wö (U+0057 U+00F6)
  0x00, 0x57, 0x00, 0xF8, 0x01, // Wø (U+0057 U+00F8)
  0x00, 0x57, 0x01, 0x00, 0x01, // WĀ (U+0057 U+0100)
  0x00, 0x57, 0x01, 0x01, 0x01, // Wā (U+0057 U+0101)
  0x00, 0x57, 0x01, 0x02, 0x01, // WĂ (U+0057 U+0102)
  0x00, 0x57, 0x01, 0x03, 0x01, // Wă (U+0057 U+0103)
  0x00, 0x57, 0x01, 0x04, 0x01, // WĄ (U+0057 U+0104)
  0x00, 0x57, 0x01, 0x05, 0x01, // Wą (U+0057 U+0105)
  0x00, 0x57, 0x01, 0x07, 0x01, // Wć (U+0057 U+0107)
  0x00, 0x57, 0x01, 0x09, 0x01, // Wĉ (U+0057 U+0109)
  0x00, 0x57, 0x01, 0x0B, 0x01, // Wċ (U+0057 U+010B)
  0x00, 0x57, 0x01, 0x0D, 0x01, // Wč (U+0057 U+010D)
  0x00, 0x57, 0x01, 0x0F, 0x01, // Wď (U+0057 U+010F)
  0x00, 0x57, 0x01, 0x11, 0x01, // Wđ (U+0057 U+0111)
  0x00, 0x57, 0x01, 0x13, 0x01, // Wē (U+0057 U+0113)
  0x00, 0x57, 0x01, 0x15, 0x01, // Wĕ (U+0057 U+0115)
  0x00, 0x57, 0x01, 0x17, 0x01, // Wė (U+0057 U+0117)
  0x00, 0x57, 0x01, 0x19, 0x01, // Wę (U+0057 U+0119)
  0x00, 0x57, 0x01, 0x1B, 0x01, // Wě (U+0057 U+011B)
  0x00, 0x57, 0x01, 0x1D, 0x01, // Wĝ (U+0057 U+011D)
  0x00, 0x57, 0x01, 0x1F, 0x01, // Wğ (U+0057 U+011F)
  0x00, 0x57, 0x01, 0x21, 0x01, // Wġ (U+0057 U+0121)
  0x00, 0x57, 0x01, 0x23, 0x01, // Wģ (U+0057 U+0123)
  0x00, 0x57, 0x01, 0x4D, 0x01, // Wō (U+0057 U+014D)
  0x00, 0x57, 0x01, 0x4F, 0x01, // Wŏ (U+0057 U+014F)
  0x00, 0x57, 0x01, 0x51, 0x01, // Wő (U+0057 U+0151)
  0x00, 0x57, 0x01, 0x53, 0x01, // Wœ (U+0057 U+0153)
  0x00, 0x57, 0x01, 0x5B, 0x01, // Wś (U+0057 U+015B)
  0x00, 0x57, 0x01, 0x5D, 0x01, // Wŝ (U+0057 U+015D)
  0x00, 0x57, 0x01, 0x5F, 0x01, // Wş (U+0057 U+015F)
  0x00, 0x57, 0x01, 0x61, 0x01, // Wš (U+0057 U+0161)
  0x00, 0x57, 0x20, 0x1A, 0x01, // W‚ (U+0057 U+201A)
  0x00, 0x57, 0x20, 0x1E, 0x01, // W„ (U+0057 U+201E)
  0x00, 0x57, 0x20, 0x26, 0x01, // W… (U+0057 U+2026)
  0x00, 0x58, 0x00, 0x79, 0x01, // Xy (U+0058 U+0079)
  0x00, 0x58, 0x00, 0xFD, 0x01, // Xý (U+0058 U+00FD)
  0x00, 0x58, 0x00, 0xFF, 0x01, // Xÿ (U+0058 U+00FF)
  0x00, 0x58, 0x01, 0x77, 0x01, // Xŷ (U+0058 U+0177)
  0x00, 0x59, 0x00, 0x2C, 0x01, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x01, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x00, 0x41, 0x01, // YA (U+0059 U+0041)
  0x00, 0x59, 0x00, 0x61, 0x01, // Ya (U+0059 U+0061)
  0x00, 0x59, 0x00, 0x63, 0x01, // Yc (U+0059 U+0063)
  0x00, 0x59, 0x00, 0x64, 0x01, // Yd (U+0059 U+0064)
  0x00, 0x59, 0x00, 0x65, 0x01, // Ye (U+0059 U+0065)
  0x00, 0x59, 0x00, 0x67, 0x01, // Yg (U+0059 U+0067)
  0x00, 0x59, 0x00, 0x6F, 0x01, // Yo (U+0059 U+006F)
  0x00, 0x59, 0x00, 0x71, 0x01, // Yq (U+0059 U+0071)
  0x00, 0x59, 0x00, 0x73, 0x01, // Ys (U+0059 U+0073)
  0x00, 0x59, 0x00, 0xC0, 0x01, // YÀ (U+0059 U+00C0)
  0x00, 0x59, 0x00, 0xC1, 0x01, // YÁ (U+0059 U+00C1)
  0x00, 0x59, 0x00, 0xC2, 0x01, // YÂ (U+0059 U+00C2)
  0x00, 0x59, 0x00, 0xC3, 0x01, // YÃ (U+0059 U+00C3)
  0x00, 0x59, 0x00, 0xC4, 0x01, // YÄ (U+0059 U+00C4)
  0x00, 0x59, 0x00, 0xC5, 0x01, // YÅ (U+0059 U+00C5)
  0x00, 0x59, 0x00, 0xC6, 0x01, // YÆ (U+0059 U+00C6)
  0x00, 0x59, 0x00, 0xE0, 0x01, // Yà (U+0059 U+00E0)
  0x00, 0x59, 0x00, 0xE1, 0x01, // Yá (U+0059 U+00E1)
  0x00, 0x59, 0x00, 0xE2, 0x01, // Yâ (U+0059 U+00E2)
  0x00, 0x59, 0x00, 0xE3, 0x01, // Yã (U+0059 U+00E3)
  0x00, 0x59, 0x00, 0xE4, 0x01, // Yä (U+0059 U+00E4)
  0x00, 0x59, 0x00, 0xE5, 0x01, // Yå (U+0059 U+00E5)
  0x00, 0x59, 0x00, 0xE6, 0x01, // Yæ (U+0059 U+00E6)
  0x00, 0x59, 0x00, 0xE7, 0x01, // Yç (U+0059 U+00E7)
  0x00, 0x59, 0x00, 0xE8, 0x01, // Yè (U+0059 U+00E8)
  0x00, 0x59, 0x00, 0xE9, 0x01, // Yé (U+0059 U+00E9)
  0x00, 0x59, 0x00, 0xEA, 0x01, // Yê (U+0059 U+00EA)
  0x00, 0x59, 0x00, 0xEB, 0x01, // Yë (U+0059 U+00EB)
  0x00, 0x59, 0x00, 0xF0, 0x01, // Yð (U+0059 U+00F0)
  0x00, 0x59, 0x00, 0xF2, 0x01, // Yò (U+0059 U+00F2)
  0x00, 0x59, 0x00, 0xF3, 0x01, // Yó (U+0059 U+00F3)
  0x00, 0x59, 0x00, 0xF4, 0x01, // Yô (U+0059 U+00F4)
  0x00, 0x59, 0x00, 0xF5, 0x01, // Yõ (U+0059 U+00F5)
  0x00, 0x59, 0x00, 0xF6, 0x01, // Yö (U+0059 U+00F6)
  0x00, 0x59, 0x00, 0xF8, 0x01, // Yø (U+0059 U+00F8)
  0x00, 0x59, 0x01, 0x00, 0x01, // YĀ (U+0059 U+0100)
  0x00, 0x59, 0x01, 0x01, 0x01, // Yā (U+0059 U+0101)
  0x00, 0x59, 0x01, 0x02, 0x01, // YĂ (U+0059 U+0102)
  0x00, 0x59, 0x01, 0x03, 0x01, // Yă (U+0059 U+0103)
  0x00, 0x59, 0x01, 0x04, 0x01, // YĄ (U+0059 U+0104)
  0x00, 0x59, 0x01, 0x05, 0x01, // Yą (U+0059 U+0105)
  0x00, 0x59, 0x01, 0x07, 0x01, // Yć (U+0059 U+0107)
  0x00, 0x59, 0x01, 0x09, 0x01, // Yĉ (U+0059 U+0109)
  0x00, 0x59, 0x01, 0x0B, 0x01, // Yċ (U+0059 U+010B)
  0x00, 0x59, 0x01, 0x0D, 0x01, // Yč (U+0059 U+010D)
  0x00, 0x59, 0x01, 0x0F, 0x01, // Yď (U+0059 U+010F)
  0x00, 0x59, 0x01, 0x11, 0x01, // Yđ (U+0059 U+0111)
  0x00, 0x59, 0x01, 0x13, 0x01, // Yē (U+0059 U+0113)
  0x00, 0x59, 0x01, 0x15, 0x01, // Yĕ (U+0059 U+0115)
  0x00, 0x59, 0x01, 0x17, 0x01, // Yė (U+0059 U+0117)
  0x00, 0x59, 0x01, 0x19, 0x01, // Yę (U+0059 U+0119)
  0x00, 0x59, 0x01, 0x1B, 0x01, // Yě (U+0059 U+011B)
  0x00, 0x59, 0x01, 0x1D, 0x01, // Yĝ (U+0059 U+011D)
  0x00, 0x59, 0x01, 0x1F, 0x01, // Yğ (U+0059 U+011F)
  0x00, 0x59, 0x01, 0x21, 0x01, // Yġ (U+0059 U+0121)
  0x00, 0x59, 0x01, 0x23, 0x01, // Yģ (U+0059 U+0123)
  0x00, 0x59, 0x01, 0x4D, 0x01, // Yō (U+0059 U+014D)
  0x00, 0x59, 0x01, 0x4F, 0x01, // Yŏ (U+0059 U+014F)
  0x00, 0x59, 0x01, 0x51, 0x01, // Yő (U+0059 U+0151)
  0x00, 0x59, 0x01, 0x53, 0x01, // Yœ (U+0059 U+0153)
  0x00, 0x59, 0x01, 0x5B, 0x01, // Yś (U+0059 U+015B)
  0x00, 0x59, 0x01, 0x5D, 0x01, // Yŝ (U+0059 U+015D)
  0x00, 0x59, 0x01, 0x5F, 0x01, // Yş (U+0059 U+015F)
  0x00, 0x59, 0x01, 0x61, 0x01, // Yš (U+0059 U+0161)
  0x00, 0x59, 0x20, 0x1A, 0x01, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x01, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x01, // Y… (U+0059 U+2026)
  0x00, 0x62, 0x00, 0x56, 0x01, // bV (U+0062 U+0056)
  0x00, 0x62, 0x00, 0x57, 0x01, // bW (U+0062 U+0057)
  0x00, 0x62, 0x00, 0x59, 0x01, // bY (U+0062 U+0059)
  0x00, 0x62, 0x00, 0xDD, 0x01, // bÝ (U+0062 U+00DD)
  0x00, 0x62, 0x01, 0x74, 0x01, // bŴ (U+0062 U+0174)
  0x00, 0x62, 0x01, 0x76, 0x01, // bŶ (U+0062 U+0176)
  0x00, 0x62, 0x01, 0x78, 0x01, // bŸ (U+0062 U+0178)
  0x00, 0x65, 0x00, 0x56, 0x01, // eV (U+0065 U+0056)
  0x00, 0x65, 0x00, 0x57, 0x01, // eW (U+0065 U+0057)
  0x00, 0x65, 0x00, 0x59, 0x01, // eY (U+0065 U+0059)
  0x00, 0x65, 0x00, 0xDD, 0x01, // eÝ (U+0065 U+00DD)
  0x00, 0x65, 0x01, 0x74, 0x01, // eŴ (U+0065 U+0174)
  0x00, 0x65, 0x01, 0x76, 0x01, // eŶ (U+0065 U+0176)
  0x00, 0x65, 0x01, 0x78, 0x01, // eŸ (U+0065 U+0178)
  0x00, 0x6F, 0x00, 0x56, 0x01, // oV (U+006F U+0056)
  0x00, 0x6F, 0x00, 0x57, 0x01, // oW (U+006F U+0057)
  0x00, 0x6F, 0x00, 0x59, 0x01, // oY (U+006F U+0059)
  0x00, 0x6F, 0x00, 0xDD, 0x01, // oÝ (U+006F U+00DD)
  0x00, 0x6F, 0x01, 0x74, 0x01, // oŴ (U+006F U+0174)
  0x00, 0x6F, 0x01, 0x76, 0x01, // oŶ (U+006F U+0176)
  0x00, 0x6F, 0x01, 0x78, 0x01, // oŸ (U+006F U+0178)
  0x00, 0x70, 0x00, 0x56, 0x01, // pV (U+0070 U+0056)
  0x00, 0x70, 0x00, 0x57, 0x01, // pW (U+0070 U+0057)
  0x00, 0x70, 0x00, 0x59, 0x01, // pY (U+0070 U+0059)
  0x00, 0x70, 0x00, 0xDD, 0x01, // pÝ (U+0070 U+00DD)
  0x00, 0x70, 0x01, 0x74, 0x01, // pŴ (U+0070 U+0174)
  0x00, 0x70, 0x01, 0x76, 0x01, // pŶ (U+0070 U+0176)
  0x00, 0x70, 0x01, 0x78, 0x01, // pŸ (U+0070 U+0178)
  0x00, 0x72, 0x00, 0x2C, 0x02, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x02, // r. (U+0072 U+002E)
  0x00, 0x72, 0x20, 0x1A, 0x02, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x02, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x02, // r… (U+0072 U+2026)
  0x00, 0x73, 0x00, 0x59, 0x01, // sY (U+0073 U+0059)
  0x00, 0x73, 0x00, 0xDD, 0x01, // sÝ (U+0073 U+00DD)
  0x00, 0x73, 0x01, 0x76, 0x01, // sŶ (U+0073 U+0176)
  0x00, 0x73, 0x01, 0x78, 0x01, // sŸ (U+0073 U+0178)
  0x00, 0x76, 0x00, 0x2C, 0x01, // v, (U+0076 U+002C)
  0x00, 0x76, 0x00, 0x2E, 0x01, // v. (U+0076 U+002E)
  0x00, 0x76, 0x00, 0x41, 0x01, // vA (U+0076 U+0041)
  0x00, 0x76, 0x00, 0xC0, 0x01, // vÀ (U+0076 U+00C0)
  0x00, 0x76, 0x00, 0xC1, 0x01, // vÁ (U+0076 U+00C1)
  0x00, 0x76, 0x00, 0xC2, 0x01, // vÂ (U+0076 U+00C2)
  0x00, 0x76, 0x00, 0xC3, 0x01, // vÃ (U+0076 U+00C3)
  0x00, 0x76, 0x00, 0xC4, 0x01, // vÄ (U+0076 U+00C4)
  0x00, 0x76, 0x00, 0xC5, 0x01, // vÅ (U+0076 U+00C5)
  0x00, 0x76, 0x01, 0x00, 0x01, // vĀ (U+0076 U+0100)
  0x00, 0x76, 0x01, 0x02, 0x01, // vĂ (U+0076 U+0102)
  0x00, 0x76, 0x01, 0x04, 0x01, // vĄ (U+0076 U+0104)
  0x00, 0x76, 0x20, 0x1A, 0x01, // v‚ (U+0076 U+201A)
  0x00, 0x76, 0x20, 0x1E, 0x01, // v„ (U+0076 U+201E)
  0x00, 0x76, 0x20, 0x26, 0x01, // v… (U+0076 U+2026)
  0x00, 0x77, 0x00, 0x2C, 0x01, // w, (U+0077 U+002C)
  0x00, 0x77, 0x00, 0x2E, 0x01, // w. (U+0077 U+002E)
  0x00, 0x77, 0x20, 0x1A, 0x01, // w‚ (U+0077 U+201A)
  0x00, 0x77, 0x20, 0x1E, 0x01, // w„ (U+0077 U+201E)
  0x00, 0x77, 0x20, 0x26, 0x01, // w… (U+0077 U+2026)
  0x00, 0x79, 0x00, 0x2C, 0x01, // y, (U+0079 U+002C)
  0x00, 0x79, 0x00, 0x2E, 0x01, // y. (U+0079 U+002E)
  0x00, 0x79, 0x00, 0x41, 0x01, // yA (U+0079 U+0041)
  0x00, 0x79, 0x00, 0xC0, 0x01, // yÀ (U+0079 U+00C0)
  0x00, 0x79, 0x00, 0xC1, 0x01, // yÁ (U+0079 U+00C1)
  0x00, 0x79, 0x00, 0xC2, 0x01, // yÂ (U+0079 U+00C2)
  0x00, 0x79, 0x00, 0xC3, 0x01, // yÃ (U+0079 U+00C3)
  0x00, 0x79, 0x00, 0xC4, 0x01, // yÄ (U+0079 U+00C4)
  0x00, 0x79, 0x00, 0xC5, 0x01, // yÅ (U+0079 U+00C5)
  0x00, 0x79, 0x01, 0x00, 0x01, // yĀ (U+0079 U+0100)
  0x00, 0x79, 0x01, 0x02, 0x01, // yĂ (U+0079 U+0102)
  0x00, 0x79, 0x01, 0x04, 0x01, // yĄ (U+0079 U+0104)
  0x00, 0x79, 0x20, 0x1A, 0x01, // y‚ (U+0079 U+201A)
  0x00, 0x79, 0x20, 0x1E, 0x01, // y„ (U+0079 U+201E)
  0x00, 0x79, 0x20, 0x26, 0x01, // y… (U+0079 U+2026)
  0x00, 0xBF, 0x00, 0x56, 0x01, // ¿V (U+00BF U+0056)
  0x00, 0xBF, 0x00, 0x57, 0x01, // ¿W (U+00BF U+0057)
  0x00, 0xBF, 0x00, 0x59, 0x01, // ¿Y (U+00BF U+0059)
  0x00, 0xBF, 0x00, 0xDD, 0x01, // ¿Ý (U+00BF U+00DD)
  0x00, 0xBF, 0x01, 0x74, 0x01, // ¿Ŵ (U+00BF U+0174)
  0x00, 0xBF, 0x01, 0x76, 0x01, // ¿Ŷ (U+00BF U+0176)
  0x00, 0xBF, 0x01, 0x78, 0x01, // ¿Ÿ (U+00BF U+0178)
  0x00, 0xC0, 0x00, 0x22, 0x01, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x01, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x00, 0x2A, 0x01, // À* (U+00C0 U+002A)
  0x00, 0xC0, 0x00, 0x3F, 0x01, // À? (U+00C0 U+003F)
  0x00, 0xC0, 0x00, 0x54, 0x01, // ÀT (U+00C0 U+0054)
  0x00, 0xC0, 0x00, 0x56, 0x01, // ÀV (U+00C0 U+0056)
  0x00, 0xC0, 0x00, 0x57, 0x01, // ÀW (U+00C0 U+0057)
  0x00, 0xC0, 0x00, 0x59, 0x01, // ÀY (U+00C0 U+0059)
  0x00, 0xC0, 0x00, 0x76, 0x01, // Àv (U+00C0 U+0076)
  0x00, 0xC0, 0x00, 0x79, 0x01, // Ày (U+00C0 U+0079)
  0x00, 0xC0, 0x00, 0xDD, 0x01, // ÀÝ (U+00C0 U+00DD)
  0x00, 0xC0, 0x00, 0xFD, 0x01, // Àý (U+00C0 U+00FD)
  0x00, 0xC0, 0x00, 0xFF, 0x01, // Àÿ (U+00C0 U+00FF)
  0x00, 0xC0, 0x01, 0x62, 0x01, // ÀŢ (U+00C0 U+0162)
  0x00, 0xC0, 0x01, 0x64, 0x01, // ÀŤ (U+00C0 U+0164)
  0x00, 0xC0, 0x01, 0x66, 0x01, // ÀŦ (U+00C0 U+0166)
  0x00, 0xC0, 0x01, 0x74, 0x01, // ÀŴ (U+00C0 U+0174)
  0x00, 0xC0, 0x01, 0x76, 0x01, // ÀŶ (U+00C0 U+0176)
  0x00, 0xC0, 0x01, 0x77, 0x01, // Àŷ (U+00C0 U+0177)
  0x00, 0xC0, 0x01, 0x78, 0x01, // ÀŸ (U+00C0 U+0178)
  0x00, 0xC0, 0x20, 0x18, 0x01, // À‘ (U+00C0 U+2018)
  0x00, 0xC0, 0x20, 0x19, 0x01, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1C, 0x01, // À“ (U+00C0 U+201C)
  0x00, 0xC0, 0x20, 0x1D, 0x01, // À” (U+00C0 U+201D)
  0x00, 0xC0, 0x21, 0x22, 0x01, // À™ (U+00C0 U+2122)
  0x00, 0xC1, 0x00, 0x22, 0x01, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x01, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x00, 0x2A, 0x01, // Á* (U+00C1 U+002A)
  0x00, 0xC1, 0x00, 0x3F, 0x01, // Á? (U+00C1 U+003F)
  0x00, 0xC1, 0x00, 0x54, 0x01, // ÁT (U+00C1 U+0054)
  0x00, 0xC1, 0x00, 0x56, 0x01, // ÁV (U+00C1 U+0056)
  0x00, 0xC1, 0x00, 0x57, 0x01, // ÁW (U+00C1 U+0057)
  0x00, 0xC1, 0x00, 0x59, 0x01, // ÁY (U+00C1 U+0059)
  0x00, 0xC1, 0x00, 0x76, 0x01, // Áv (U+00C1 U+0076)
  0x00, 0xC1, 0x00, 0x79, 0x01, // Áy (U+00C1 U+0079)
  0x00, 0xC1, 0x00, 0xDD, 0x01, // ÁÝ (U+00C1 U+00DD)
  0x00, 0xC1, 0x00, 0xFD, 0x01, // Áý (U+00C1 U+00FD)
  0x00, 0xC1, 0x00, 0xFF, 0x01, // Áÿ (U+00C1 U+00FF)
  0x00, 0xC1, 0x01, 0x62, 0x01, // ÁŢ (U+00C1 U+0162)
  0x00, 0xC1, 0x01, 0x64, 0x01, // ÁŤ (U+00C1 U+0164)
  0x00, 0xC1, 0x01, 0x66, 0x01, // ÁŦ (U+00C1 U+0166)
  0x00, 0xC1, 0x01, 0x74, 0x01, // ÁŴ (U+00C1 U+0174)
  0x00, 0xC1, 0x01, 0x76, 0x01, // ÁŶ (U+00C1 U+0176)
  0x00, 0xC1, 0x01, 0x77, 0x01, // Áŷ (U+00C1 U+0177)
  0x00, 0xC1, 0x01, 0x78, 0x01, // ÁŸ (U+00C1 U+0178)
  0x00, 0xC1, 0x20, 0x18, 0x01, // Á‘ (U+00C1 U+2018)
  0x00, 0xC1, 0x20, 0x19, 0x01, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1C, 0x01, // Á“ (U+00C1 U+201C)
  0x00, 0xC1, 0x20, 0x1D, 0x01, // Á” (U+00C1 U+201D)
  0x00, 0xC1, 0x21, 0x22, 0x01, // Á™ (U+00C1 U+2122)
  0x00, 0xC2, 0x00, 0x22, 0x01, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x01, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x00, 0x2A, 0x01, // Â* (U+00C2 U+002A)
  0x00, 0xC2, 0x00, 0x3F, 0x01, // Â? (U+00C2 U+003F)
  0x00, 0xC2, 0x00, 0x54, 0x01, // ÂT (U+00C2 U+0054)
  0x00, 0xC2, 0x00, 0x56, 0x01, // ÂV (U+00C2 U+0056)
  0x00, 0xC2, 0x00, 0x57, 0x01, // ÂW (U+00C2 U+0057)
  0x00, 0xC2, 0x00, 0x59, 0x01, // ÂY (U+00C2 U+0059)
  0x00, 0xC2, 0x00, 0x76, 0x01, // Âv (U+00C2 U+0076)
  0x00, 0xC2, 0x00, 0x79, 0x01, // Ây (U+00C2 U+0079)
  0x00, 0xC2, 0x00, 0xDD, 0x01, // ÂÝ (U+00C2 U+00DD)
  0x00, 0xC2, 0x00, 0xFD, 0x01, // Âý (U+00C2 U+00FD)
  0x00, 0xC2, 0x00, 0xFF, 0x01, // Âÿ (U+00C2 U+00FF)
  0x00, 0xC2, 0x01, 0x62, 0x01, // ÂŢ (U+00C2 U+0162)
  0x00, 0xC2, 0x01, 0x64, 0x01, // ÂŤ (U+00C2 U+0164)
  0x00, 0xC2, 0x01, 0x66, 0x01, // ÂŦ (U+00C2 U+0166)
  0x00, 0xC2, 0x01, 0x74, 0x01, // ÂŴ (U+00C2 U+0174)
  0x00, 0xC2, 0x01, 0x76, 0x01, // ÂŶ (U+00C2 U+0176)
  0x00, 0xC2, 0x01, 0x77, 0x01, // Âŷ (U+00C2 U+0177)
  0x00, 0xC2, 0x01, 0x78, 0x01, // ÂŸ (U+00C2 U+0178)
  0x00, 0xC2, 0x20, 0x18, 0x01, // Â‘ (U+00C2 U+2018)
  0x00, 0xC2, 0x20, 0x19, 0x01, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1C, 0x01, // Â“ (U+00C2 U+201C)
  0x00, 0xC2, 0x20, 0x1D, 0x01, // Â” (U+00C2 U+201D)
  0x00, 0xC2, 0x21, 0x22, 0x01, // Â™ (U+00C2 U+2122)
  0x00, 0xC3, 0x00, 0x22, 0x01, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x01, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x00, 0x2A, 0x01, // Ã* (U+00C3 U+002A)
  0x00, 0xC3, 0x00, 0x3F, 0x01, // Ã? (U+00C3 U+003F)
  0x00, 0xC3, 0x00, 0x54, 0x01, // ÃT (U+00C3 U+0054)
  0x00, 0xC3, 0x00, 0x56, 0x01, // ÃV (U+00C3 U+0056)
  0x00, 0xC3, 0x00, 0x57, 0x01, // ÃW (U+00C3 U+0057)
  0x00, 0xC3, 0x00, 0x59, 0x01, // ÃY (U+00C3 U+0059)
  0x00, 0xC3, 0x00, 0x76, 0x01, // Ãv (U+00C3 U+0076)
  0x00, 0xC3, 0x00, 0x79, 0x01, // Ãy (U+00C3 U+0079)
  0x00, 0xC3, 0x00, 0xDD, 0x01, // ÃÝ (U+00C3 U+00DD)
  0x00, 0xC3, 0x00, 0xFD, 0x01, // Ãý (U+00C3 U+00FD)
  0x00, 0xC3, 0x00, 0xFF, 0x01, // Ãÿ (U+00C3 U+00FF)
  0x00, 0xC3, 0x01, 0x62, 0x01, // ÃŢ (U+00C3 U+0162)
  0x00, 0xC3, 0x01, 0x64, 0x01, // ÃŤ (U+00C3 U+0164)
  0x00, 0xC3, 0x01, 0x66, 0x01, // ÃŦ (U+00C3 U+0166)
  0x00, 0xC3, 0x01, 0x74, 0x01, // ÃŴ (U+00C3 U+0174)
  0x00, 0xC3, 0x01, 0x76, 0x01, // ÃŶ (U+00C3 U+0176)
  0x00, 0xC3, 0x01, 0x77, 0x01, // Ãŷ (U+00C3 U+0177)
  0x00, 0xC3, 0x01, 0x78, 0x01, // ÃŸ (U+00C3 U+0178)
  0x00, 0xC3, 0x20, 0x18, 0x01, // Ã‘ (U+00C3 U+2018)
  0x00, 0xC3, 0x20, 0x19, 0x01, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1C, 0x01, // Ã“ (U+00C3 U+201C)
  0x00, 0xC3, 0x20, 0x1D, 0x01, // Ã” (U+00C3 U+201D)
  0x00, 0xC3, 0x21, 0x22, 0x01, // Ã™ (U+00C3 U+2122)
  0x00, 0xC4, 0x00, 0x22, 0x01, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x01, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x00, 0x2A, 0x01, // Ä* (U+00C4 U+002A)
  0x00, 0xC4, 0x00, 0x3F, 0x01, // Ä? (U+00C4 U+003F)
  0x00, 0xC4, 0x00, 0x54, 0x01, // ÄT (U+00C4 U+0054)
  0x00, 0xC4, 0x00, 0x56, 0x01, // ÄV (U+00C4 U+0056)
  0x00, 0xC4, 0x00, 0x57, 0x01, // ÄW (U+00C4 U+0057)
  0x00, 0xC4, 0x00, 0x59, 0x01, // ÄY (U+00C4 U+0059)
  0x00, 0xC4, 0x00, 0x76, 0x01, // Äv (U+00C4 U+0076)
  0x00, 0xC4, 0x00, 0x79, 0x01, // Äy (U+00C4 U+0079)
  0x00, 0xC4, 0x00, 0xDD, 0x01, // ÄÝ (U+00C4 U+00DD)
  0x00, 0xC4, 0x00, 0xFD, 0x01, // Äý (U+00C4 U+00FD)
  0x00, 0xC4, 0x00, 0xFF, 0x01, // Äÿ (U+00C4 U+00FF)
  0x00, 0xC4, 0x01, 0x62, 0x01, // ÄŢ (U+00C4 U+0162)
  0x00, 0xC4, 0x01, 0x64, 0x01, // ÄŤ (U+00C4 U+0164)
  0x00, 0xC4, 0x01, 0x66, 0x01, // ÄŦ (U+00C4 U+0166)
  0x00, 0xC4, 0x01, 0x74, 0x01, // ÄŴ (U+00C4 U+0174)
  0x00, 0xC4, 0x01, 0x76, 0x01, // ÄŶ (U+00C4 U+0176)
  0x00, 0xC4, 0x01, 0x77, 0x01, // Äŷ (U+00C4 U+0177)
  0x00, 0xC4, 0x01, 0x78, 0x01, // ÄŸ (U+00C4 U+0178)
  0x00, 0xC4, 0x20, 0x18, 0x01, // Ä‘ (U+00C4 U+2018)
  0x00, 0xC4, 0x20, 0x19, 0x01, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1C, 0x01, // Ä“ (U+00C4 U+201C)
  0x00, 0xC4, 0x20, 0x1D, 0x01, // Ä” (U+00C4 U+201D)
  0x00, 0xC4, 0x21, 0x22, 0x01, // Ä™ (U+00C4 U+2122)
  0x00, 0xC5, 0x00, 0x22, 0x01, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x01, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x00, 0x2A, 0x01, // Å* (U+00C5 U+002A)
  0x00, 0xC5, 0x00, 0x3F, 0x01, // Å? (U+00C5 U+003F)
  0x00, 0xC5, 0x00, 0x54, 0x01, // ÅT (U+00C5 U+0054)
  0x00, 0xC5, 0x00, 0x56, 0x01, // ÅV (U+00C5 U+0056)
  0x00, 0xC5, 0x00, 0x57, 0x01, // ÅW (U+00C5 U+0057)
  0x00, 0xC5, 0x00, 0x59, 0x01, // ÅY (U+00C5 U+0059)
  0x00, 0xC5, 0x00, 0x76, 0x01, // Åv (U+00C5 U+0076)
  0x00, 0xC5, 0x00, 0x79, 0x01, // Åy (U+00C5 U+0079)
  0x00, 0xC5, 0x00, 0xDD, 0x01, // ÅÝ (U+00C5 U+00DD)
  0x00, 0xC5, 0x00, 0xFD, 0x01, // Åý (U+00C5 U+00FD)
  0x00, 0xC5, 0x00, 0xFF, 0x01, // Åÿ (U+00C5 U+00FF)
  0x00, 0xC5, 0x01, 0x62, 0x01, // ÅŢ (U+00C5 U+0162)
  0x00, 0xC5, 0x01, 0x64, 0x01, // ÅŤ (U+00C5 U+0164)
  0x00, 0xC5, 0x01, 0x66, 0x01, // ÅŦ (U+00C5 U+0166)
  0x00, 0xC5, 0x01, 0x74, 0x01, // ÅŴ (U+00C5 U+0174)
  0x00, 0xC5, 0x01, 0x76, 0x01, // ÅŶ (U+00C5 U+0176)
  0x00, 0xC5, 0x01, 0x77, 0x01, // Åŷ (U+00C5 U+0177)
  0x00, 0xC5, 0x01, 0x78, 0x01, // ÅŸ (U+00C5 U+0178)
  0x00, 0xC5, 0x20, 0x18, 0x01, // Å‘ (U+00C5 U+2018)
  0x00, 0xC5, 0x20, 0x19, 0x01, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1C, 0x01, // Å“ (U+00C5 U+201C)
  0x00, 0xC5, 0x20, 0x1D, 0x01, // Å” (U+00C5 U+201D)
  0x00, 0xC5, 0x21, 0x22, 0x01, // Å™ (U+00C5 U+2122)
  0x00, 0xD0, 0x00, 0xC6, 0x01, // ÐÆ (U+00D0 U+00C6)
  0x00, 0xD2, 0x00, 0xC6, 0x01, // ÒÆ (U+00D2 U+00C6)
  0x00, 0xD3, 0x00, 0xC6, 0x01, // ÓÆ (U+00D3 U+00C6)
  0x00, 0xD4, 0x00, 0xC6, 0x01, // ÔÆ (U+00D4 U+00C6)
  0x00, 0xD5, 0x00, 0xC6, 0x01, // ÕÆ (U+00D5 U+00C6)
  0x00, 0xD6, 0x00, 0xC6, 0x01, // ÖÆ (U+00D6 U+00C6)
  0x00, 0xD8, 0x00, 0xC6, 0x01, // ØÆ (U+00D8 U+00C6)
  0x00, 0xDD, 0x00, 0x2C, 0x01, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x01, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x00, 0x41, 0x01, // ÝA (U+00DD U+0041)
  0x00, 0xDD, 0x00, 0x61, 0x01, // Ýa (U+00DD U+0061)
  0x00, 0xDD, 0x00, 0x63, 0x01, // Ýc (U+00DD U+0063)
  0x00, 0xDD, 0x00, 0x64, 0x01, // Ýd (U+00DD U+0064)
  0x00, 0xDD, 0x00, 0x65, 0x01, // Ýe (U+00DD U+0065)
  0x00, 0xDD, 0x00, 0x67, 0x01, // Ýg (U+00DD U+0067)
  0x00, 0xDD, 0x00, 0x6F, 0x01, // Ýo (U+00DD U+006F)
  0x00, 0xDD, 0x00, 0x71, 0x01, // Ýq (U+00DD U+0071)
  0x00, 0xDD, 0x00, 0x73, 0x01, // Ýs (U+00DD U+0073)
  0x00, 0xDD, 0x00, 0xC0, 0x01, // ÝÀ (U+00DD U+00C0)
  0x00, 0xDD, 0x00, 0xC1, 0x01, // ÝÁ (U+00DD U+00C1)
  0x00, 0xDD, 0x00, 0xC2, 0x01, // ÝÂ (U+00DD U+00C2)
  0x00, 0xDD, 0x00, 0xC3, 0x01, // ÝÃ (U+00DD U+00C3)
  0x00, 0xDD, 0x00, 0xC4, 0x01, // ÝÄ (U+00DD U+00C4)
  0x00, 0xDD, 0x00, 0xC5, 0x01, // ÝÅ (U+00DD U+00C5)
  0x00, 0xDD, 0x00, 0xC6, 0x01, // ÝÆ (U+00DD U+00C6)
  0x00, 0xDD, 0x00, 0xE0, 0x01, // Ýà (U+00DD U+00E0)
  0x00, 0xDD, 0x00, 0xE1, 0x01, // Ýá (U+00DD U+00E1)
  0x00, 0xDD, 0x00, 0xE2, 0x01, // Ýâ (U+00DD U+00E2)
  0x00, 0xDD, 0x00, 0xE3, 0x01, // Ýã (U+00DD U+00E3)
  0x00, 0xDD, 0x00, 0xE4, 0x01, // Ýä (U+00DD U+00E4)
  0x00, 0xDD, 0x00, 0xE5, 0x01, // Ýå (U+00DD U+00E5)
  0x00, 0xDD, 0x00, 0xE6, 0x01, // Ýæ (U+00DD U+00E6)
  0x00, 0xDD, 0x00, 0xE7, 0x01, // Ýç (U+00DD U+00E7)
  0x00, 0xDD, 0x00, 0xE8, 0x01, // Ýè (U+00DD U+00E8)
  0x00, 0xDD, 0x00, 0xE9, 0x01, // Ýé (U+00DD U+00E9)
  0x00, 0xDD, 0x00, 0xEA, 0x01, // Ýê (U+00DD U+00EA)
  0x00, 0xDD, 0x00, 0xEB, 0x01, // Ýë (U+00DD U+00EB)
  0x00, 0xDD, 0x00, 0xF0, 0x01, // Ýð (U+00DD U+00F0)
  0x00, 0xDD, 0x00, 0xF2, 0x01, // Ýò (U+00DD U+00F2)
  0x00, 0xDD, 0x00, 0xF3, 0x01, // Ýó (U+00DD U+00F3)
  0x00, 0xDD, 0x00, 0xF4, 0x01, // Ýô (U+00DD U+00F4)
  0x00, 0xDD, 0x00, 0xF5, 0x01, // Ýõ (U+00DD U+00F5)
  0x00, 0xDD, 0x00, 0xF6, 0x01, // Ýö (U+00DD U+00F6)
  0x00, 0xDD, 0x00, 0xF8, 0x01, // Ýø (U+00DD U+00F8)
  0x00, 0xDD, 0x01, 0x00, 0x01, // ÝĀ (U+00DD U+0100)
  0x00, 0xDD, 0x01, 0x01, 0x01, // Ýā (U+00DD U+0101)
  0x00, 0xDD, 0x01, 0x02, 0x01, // ÝĂ (U+00DD U+0102)
  0x00, 0xDD, 0x01, 0x03, 0x01, // Ýă (U+00DD U+0103)
  0x00, 0xDD, 0x01, 0x04, 0x01, // ÝĄ (U+00DD U+0104)
  0x00, 0xDD, 0x01, 0x05, 0x01, // Ýą (U+00DD U+0105)
  0x00, 0xDD, 0x01, 0x07, 0x01, // Ýć (U+00DD U+0107)
  0x00, 0xDD, 0x01, 0x09, 0x01, // Ýĉ (U+00DD U+0109)
  0x00, 0xDD, 0x01, 0x0B, 0x01, // Ýċ (U+00DD U+010B)
  0x00, 0xDD, 0x01, 0x0D, 0x01, // Ýč (U+00DD U+010D)
  0x00, 0xDD, 0x01, 0x0F, 0x01, // Ýď (U+00DD U+010F)
  0x00, 0xDD, 0x01, 0x11, 0x01, // Ýđ (U+00DD U+0111)
  0x00, 0xDD, 0x01, 0x13, 0x01, // Ýē (U+00DD U+0113)
  0x00, 0xDD, 0x01, 0x15, 0x01, // Ýĕ (U+00DD U+0115)
  0x00, 0xDD, 0x01, 0x17, 0x01, // Ýė (U+00DD U+0117)
  0x00, 0xDD, 0x01, 0x19, 0x01, // Ýę (U+00DD U+0119)
  0x00, 0xDD, 0x01, 0x1B, 0x01, // Ýě (U+00DD U+011B)
  0x00, 0xDD, 0x01, 0x1D, 0x01, // Ýĝ (U+00DD U+011D)
  0x00, 0xDD, 0x01, 0x1F, 0x01, // Ýğ (U+00DD U+011F)
  0x00, 0xDD, 0x01, 0x21, 0x01, // Ýġ (U+00DD U+0121)
  0x00, 0xDD, 0x01, 0x23, 0x01, // Ýģ (U+00DD U+0123)
  0x00, 0xDD, 0x01, 0x4D, 0x01, // Ýō (U+00DD U+014D)
  0x00, 0xDD, 0x01, 0x4F, 0x01, // Ýŏ (U+00DD U+014F)
  0x00, 0xDD, 0x01, 0x51, 0x01, // Ýő (U+00DD U+0151)
  0x00, 0xDD, 0x01, 0x53, 0x01, // Ýœ (U+00DD U+0153)
  0x00, 0xDD, 0x01, 0x5B, 0x01, // Ýś (U+00DD U+015B)
  0x00, 0xDD, 0x01, 0x5D, 0x01, // Ýŝ (U+00DD U+015D)
  0x00, 0xDD, 0x01, 0x5F, 0x01, // Ýş (U+00DD U+015F)
  0x00, 0xDD, 0x01, 0x61, 0x01, // Ýš (U+00DD U+0161)
  0x00, 0xDD, 0x20, 0x1A, 0x01, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x01, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x01, // Ý… (U+00DD U+2026)
  0x00, 0xDE, 0x00, 0xC6, 0x01, // ÞÆ (U+00DE U+00C6)
  0x00, 0xDF, 0x00, 0x56, 0x01, // ßV (U+00DF U+0056)
  0x00, 0xDF, 0x00, 0x57, 0x01, // ßW (U+00DF U+0057)
  0x00, 0xDF, 0x00, 0x59, 0x01, // ßY (U+00DF U+0059)
  0x00, 0xDF, 0x00, 0xDD, 0x01, // ßÝ (U+00DF U+00DD)
  0x00, 0xDF, 0x01, 0x74, 0x01, // ßŴ (U+00DF U+0174)
  0x00, 0xDF, 0x01, 0x76, 0x01, // ßŶ (U+00DF U+0176)
  0x00, 0xDF, 0x01, 0x78, 0x01, // ßŸ (U+00DF U+0178)
  0x00, 0xE6, 0x00, 0x56, 0x01, // æV (U+00E6 U+0056)
  0x00, 0xE6, 0x00, 0x57, 0x01, // æW (U+00E6 U+0057)
  0x00, 0xE6, 0x00, 0x59, 0x01, // æY (U+00E6 U+0059)
  0x00, 0xE6, 0x00, 0xDD, 0x01, // æÝ (U+00E6 U+00DD)
  0x00, 0xE6, 0x01, 0x74, 0x01, // æŴ (U+00E6 U+0174)
  0x00, 0xE6, 0x01, 0x76, 0x01, // æŶ (U+00E6 U+0176)
  0x00, 0xE6, 0x01, 0x78, 0x01, // æŸ (U+00E6 U+0178)
  0x00, 0xE8, 0x00, 0x56, 0x01, // èV (U+00E8 U+0056)
  0x00, 0xE8, 0x00, 0x57, 0x01, // èW (U+00E8 U+0057)
  0x00, 0xE8, 0x00, 0x59, 0x01, // èY (U+00E8 U+0059)
  0x00, 0xE8, 0x00, 0xDD, 0x01, // èÝ (U+00E8 U+00DD)
  0x00, 0xE8, 0x01, 0x74, 0x01, // èŴ (U+00E8 U+0174)
  0x00, 0xE8, 0x01, 0x76, 0x01, // èŶ (U+00E8 U+0176)
  0x00, 0xE8, 0x01, 0x78, 0x01, // èŸ (U+00E8 U+0178)
  0x00, 0xE9, 0x00, 0x56, 0x01, // éV (U+00E9 U+0056)
  0x00, 0xE9, 0x00, 0x57, 0x01, // éW (U+00E9 U+0057)
  0x00, 0xE9, 0x00, 0x59, 0x01, // éY (U+00E9 U+0059)
  0x00, 0xE9, 0x00, 0xDD, 0x01, // éÝ (U+00E9 U+00DD)
  0x00, 0xE9, 0x01, 0x74, 0x01, // éŴ (U+00E9 U+0174)
  0x00, 0xE9, 0x01, 0x76, 0x01, // éŶ (U+00E9 U+0176)
  0x00, 0xE9, 0x01, 0x78, 0x01, // éŸ (U+00E9 U+0178)
  0x00, 0xEA, 0x00, 0x56, 0x01, // êV (U+00EA U+0056)
  0x00, 0xEA, 0x00, 0x57, 0x01, // êW (U+00EA U+0057)
  0x00, 0xEA, 0x00, 0x59, 0x01, // êY (U+00EA U+0059)
  0x00, 0xEA, 0x00, 0xDD, 0x01, // êÝ (U+00EA U+00DD)
  0x00, 0xEA, 0x01, 0x74, 0x01, // êŴ (U+00EA U+0174)
  0x00, 0xEA, 0x01, 0x76, 0x01, // êŶ (U+00EA U+0176)
  0x00, 0xEA, 0x01, 0x78, 0x01, // êŸ (U+00EA U+0178)
  0x00, 0xEB, 0x00, 0x56, 0x01, // ëV (U+00EB U+0056)
  0x00, 0xEB, 0x00, 0x57, 0x01, // ëW (U+00EB U+0057)
  0x00, 0xEB, 0x00, 0x59, 0x01, // ëY (U+00EB U+0059)
  0x00, 0xEB, 0x00, 0xDD, 0x01, // ëÝ (U+00EB U+00DD)
  0x00, 0xEB, 0x01, 0x74, 0x01, // ëŴ (U+00EB U+0174)
  0x00, 0xEB, 0x01, 0x76, 0x01, // ëŶ (U+00EB U+0176)
  0x00, 0xEB, 0x01, 0x78, 0x01, // ëŸ (U+00EB U+0178)
  0x00, 0xF0, 0x00, 0x56, 0x01, // ðV (U+00F0 U+0056)
  0x00, 0xF0, 0x00, 0x57, 0x01, // ðW (U+00F0 U+0057)
  0x00, 0xF0, 0x00, 0x59, 0x01, // ðY (U+00F0 U+0059)
  0x00, 0xF0, 0x00, 0xDD, 0x01, // ðÝ (U+00F0 U+00DD)
  0x00, 0xF0, 0x01, 0x74, 0x01, // ðŴ (U+00F0 U+0174)
  0x00, 0xF0, 0x01, 0x76, 0x01, // ðŶ (U+00F0 U+0176)
  0x00, 0xF0, 0x01, 0x78, 0x01, // ðŸ (U+00F0 U+0178)
  0x00, 0xF2, 0x00, 0x56, 0x01, // òV (U+00F2 U+0056)
  0x00, 0xF2, 0x00, 0x57, 0x01, // òW (U+00F2 U+0057)
  0x00, 0xF2, 0x00, 0x59, 0x01, // òY (U+00F2 U+0059)
  0x00, 0xF2, 0x00, 0xDD, 0x01, // òÝ (U+00F2 U+00DD)
  0x00, 0xF2, 0x01, 0x74, 0x01, // òŴ (U+00F2 U+0174)
  0x00, 0xF2, 0x01, 0x76, 0x01, // òŶ (U+00F2 U+0176)
  0x00, 0xF2, 0x01, 0x78, 0x01, // òŸ (U+00F2 U+0178)
  0x00, 0xF3, 0x00, 0x56, 0x01, // óV (U+00F3 U+0056)
  0x00, 0xF3, 0x00, 0x57, 0x01, // óW (U+00F3 U+0057)
  0x00, 0xF3, 0x00, 0x59, 0x01, // óY (U+00F3 U+0059)
  0x00, 0xF3, 0x00, 0xDD, 0x01, // óÝ (U+00F3 U+00DD)
  0x00, 0xF3, 0x01, 0x74, 0x01, // óŴ (U+00F3 U+0174)
  0x00, 0xF3, 0x01, 0x76, 0x01, // óŶ (U+00F3 U+0176)
  0x00, 0xF3, 0x01, 0x78, 0x01, // óŸ (U+00F3 U+0178)
  0x00, 0xF4, 0x00, 0x56, 0x01, // ôV (U+00F4 U+0056)
  0x00, 0xF4, 0x00, 0x57, 0x01, // ôW (U+00F4 U+0057)
  0x00, 0xF4, 0x00, 0x59, 0x01, // ôY (U+00F4 U+0059)
  0x00, 0xF4, 0x00, 0xDD, 0x01, // ôÝ (U+00F4 U+00DD)
  0x00, 0xF4, 0x01, 0x74, 0x01, // ôŴ (U+00F4 U+0174)
  0x00, 0xF4, 0x01, 0x76, 0x01, // ôŶ (U+00F4 U+0176)
  0x00, 0xF4, 0x01, 0x78, 0x01, // ôŸ (U+00F4 U+0178)
  0x00, 0xF5, 0x00, 0x56, 0x01, // õV (U+00F5 U+0056)
  0x00, 0xF5, 0x00, 0x57, 0x01, // õW (U+00F5 U+0057)
  0x00, 0xF5, 0x00, 0x59, 0x01, // õY (U+00F5 U+0059)
  0x00, 0xF5, 0x00, 0xDD, 0x01, // õÝ (U+00F5 U+00DD)
  0x00, 0xF5, 0x01, 0x74, 0x01, // õŴ (U+00F5 U+0174)
  0x00, 0xF5, 0x01, 0x76, 0x01, // õŶ (U+00F5 U+0176)
  0x00, 0xF5, 0x01, 0x78, 0x01, // õŸ (U+00F5 U+0178)
  0x00, 0xF6, 0x00, 0x56, 0x01, // öV (U+00F6 U+0056)
  0x00, 0xF6, 0x00, 0x57, 0x01, // öW (U+00F6 U+0057)
  0x00, 0xF6, 0x00, 0x59, 0x01, // öY (U+00F6 U+0059)
  0x00, 0xF6, 0x00, 0xDD, 0x01, // öÝ (U+00F6 U+00DD)
  0x00, 0xF6, 0x01, 0x74, 0x01, // öŴ (U+00F6 U+0174)
  0x00, 0xF6, 0x01, 0x76, 0x01, // öŶ (U+00F6 U+0176)
  0x00, 0xF6, 0x01, 0x78, 0x01, // öŸ (U+00F6 U+0178)
  0x00, 0xF8, 0x00, 0x56, 0x01, // øV (U+00F8 U+0056)
  0x00, 0xF8, 0x00, 0x57, 0x01, // øW (U+00F8 U+0057)
  0x00, 0xF8, 0x00, 0x59, 0x01, // øY (U+00F8 U+0059)
  0x00, 0xF8, 0x00, 0xDD, 0x01, // øÝ (U+00F8 U+00DD)
  0x00, 0xF8, 0x01, 0x74, 0x01, // øŴ (U+00F8 U+0174)
  0x00, 0xF8, 0x01, 0x76, 0x01, // øŶ (U+00F8 U+0176)
  0x00, 0xF8, 0x01, 0x78, 0x01, // øŸ (U+00F8 U+0178)
  0x00, 0xFD, 0x00, 0x2C, 0x01, // ý, (U+00FD U+002C)
  0x00, 0xFD, 0x00, 0x2E, 0x01, // ý. (U+00FD U+002E)
  0x00, 0xFD, 0x00, 0x41, 0x01, // ýA (U+00FD U+0041)
  0x00, 0xFD, 0x00, 0xC0, 0x01, // ýÀ (U+00FD U+00C0)
  0x00, 0xFD, 0x00, 0xC1, 0x01, // ýÁ (U+00FD U+00C1)
  0x00, 0xFD, 0x00, 0xC2, 0x01, // ýÂ (U+00FD U+00C2)
  0x00, 0xFD, 0x00, 0xC3, 0x01, // ýÃ (U+00FD U+00C3)
  0x00, 0xFD, 0x00, 0xC4, 0x01, // ýÄ (U+00FD U+00C4)
  0x00, 0xFD, 0x00, 0xC5, 0x01, // ýÅ (U+00FD U+00C5)
  0x00, 0xFD, 0x01, 0x00, 0x01, // ýĀ (U+00FD U+0100)
  0x00, 0xFD, 0x01, 0x02, 0x01, // ýĂ (U+00FD U+0102)
  0x00, 0xFD, 0x01, 0x04, 0x01, // ýĄ (U+00FD U+0104)
  0x00, 0xFD, 0x20, 0x1A, 0x01, // ý‚ (U+00FD U+201A)
  0x00, 0xFD, 0x20, 0x1E, 0x01, // ý„ (U+00FD U+201E)
  0x00, 0xFD, 0x20, 0x26, 0x01, // ý… (U+00FD U+2026)
  0x00, 0xFE, 0x00, 0x56, 0x01, // þV (U+00FE U+0056)
  0x00, 0xFE, 0x00, 0x57, 0x01, // þW (U+00FE U+0057)
  0x00, 0xFE, 0x00, 0x59, 0x01, // þY (U+00FE U+0059)
  0x00, 0xFE, 0x00, 0xDD, 0x01, // þÝ (U+00FE U+00DD)
  0x00, 0xFE, 0x01, 0x74, 0x01, // þŴ (U+00FE U+0174)
  0x00, 0xFE, 0x01, 0x76, 0x01, // þŶ (U+00FE U+0176)
  0x00, 0xFE, 0x01, 0x78, 0x01, // þŸ (U+00FE U+0178)
  0x00, 0xFF, 0x00, 0x2C, 0x01, // ÿ, (U+00FF U+002C)
  0x00, 0xFF, 0x00, 0x2E, 0x01, // ÿ. (U+00FF U+002E)
  0x00, 0xFF, 0x00, 0x41, 0x01, // ÿA (U+00FF U+0041)
  0x00, 0xFF, 0x00, 0xC0, 0x01, // ÿÀ (U+00FF U+00C0)
  0x00, 0xFF, 0x00, 0xC1, 0x01, // ÿÁ (U+00FF U+00C1)
  0x00, 0xFF, 0x00, 0xC2, 0x01, // ÿÂ (U+00FF U+00C2)
  0x00, 0xFF, 0x00, 0xC3, 0x01, // ÿÃ (U+00FF U+00C3)
  0x00, 0xFF, 0x00, 0xC4, 0x01, // ÿÄ (U+00FF U+00C4)
  0x00, 0xFF, 0x00, 0xC5, 0x01, // ÿÅ (U+00FF U+00C5)
  0x00, 0xFF, 0x01, 0x00, 0x01, // ÿĀ (U+00FF U+0100)
  0x00, 0xFF, 0x01, 0x02, 0x01, // ÿĂ (U+00FF U+0102)
  0x00, 0xFF, 0x01, 0x04, 0x01, // ÿĄ (U+00FF U+0104)
  0x00, 0xFF, 0x20, 0x1A, 0x01, // ÿ‚ (U+00FF U+201A)
  0x00, 0xFF, 0x20, 0x1E, 0x01, // ÿ„ (U+00FF U+201E)
  0x00, 0xFF, 0x20, 0x26, 0x01, // ÿ… (U+00FF U+2026)
  0x01, 0x00, 0x00, 0x22, 0x01, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x01, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x00, 0x2A, 0x01, // Ā* (U+0100 U+002A)
  0x01, 0x00, 0x00, 0x3F, 0x01, // Ā? (U+0100 U+003F)
  0x01, 0x00, 0x00, 0x54, 0x01, // ĀT (U+0100 U+0054)
  0x01, 0x00, 0x00, 0x56, 0x01, // ĀV (U+0100 U+0056)
  0x01, 0x00, 0x00, 0x57, 0x01, // ĀW (U+0100 U+0057)
  0x01, 0x00, 0x00, 0x59, 0x01, // ĀY (U+0100 U+0059)
  0x01, 0x00, 0x00, 0x76, 0x01, // Āv (U+0100 U+0076)
  0x01, 0x00, 0x00, 0x79, 0x01, // Āy (U+0100 U+0079)
  0x01, 0x00, 0x00, 0xDD, 0x01, // ĀÝ (U+0100 U+00DD)
  0x01, 0x00, 0x00, 0xFD, 0x01, // Āý (U+0100 U+00FD)
  0x01, 0x00, 0x00, 0xFF, 0x01, // Āÿ (U+0100 U+00FF)
  0x01, 0x00, 0x01, 0x62, 0x01, // ĀŢ (U+0100 U+0162)
  0x01, 0x00, 0x01, 0x64, 0x01, // ĀŤ (U+0100 U+0164)
  0x01, 0x00, 0x01, 0x66, 0x01, // ĀŦ (U+0100 U+0166)
  0x01, 0x00, 0x01, 0x74, 0x01, // ĀŴ (U+0100 U+0174)
  0x01, 0x00, 0x01, 0x76, 0x01, // ĀŶ (U+0100 U+0176)
  0x01, 0x00, 0x01, 0x77, 0x01, // Āŷ (U+0100 U+0177)
  0x01, 0x00, 0x01, 0x78, 0x01, // ĀŸ (U+0100 U+0178)
  0x01, 0x00, 0x20, 0x18, 0x01, // Ā‘ (U+0100 U+2018)
  0x01, 0x00, 0x20, 0x19, 0x01, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1C, 0x01, // Ā“ (U+0100 U+201C)
  0x01, 0x00, 0x20, 0x1D, 0x01, // Ā” (U+0100 U+201D)
  0x01, 0x00, 0x21, 0x22, 0x01, // Ā™ (U+0100 U+2122)
  0x01, 0x02, 0x00, 0x22, 0x01, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x01, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x00, 0x2A, 0x01, // Ă* (U+0102 U+002A)
  0x01, 0x02, 0x00, 0x3F, 0x01, // Ă? (U+0102 U+003F)
  0x01, 0x02, 0x00, 0x54, 0x01, // ĂT (U+0102 U+0054)
  0x01, 0x02, 0x00, 0x56, 0x01, // ĂV (U+0102 U+0056)
  0x01, 0x02, 0x00, 0x57, 0x01, // ĂW (U+0102 U+0057)
  0x01, 0x02, 0x00, 0x59, 0x01, // ĂY (U+0102 U+0059)
  0x01, 0x02, 0x00, 0x76, 0x01, // Ăv (U+0102 U+0076)
  0x01, 0x02, 0x00, 0x79, 0x01, // Ăy (U+0102 U+0079)
  0x01, 0x02, 0x00, 0xDD, 0x01, // ĂÝ (U+0102 U+00DD)
  0x01, 0x02, 0x00, 0xFD, 0x01, // Ăý (U+0102 U+00FD)
  0x01, 0x02, 0x00, 0xFF, 0x01, // Ăÿ (U+0102 U+00FF)
  0x01, 0x02, 0x01, 0x62, 0x01, // ĂŢ (U+0102 U+0162)
  0x01, 0x02, 0x01, 0x64, 0x01, // ĂŤ (U+0102 U+0164)
  0x01, 0x02, 0x01, 0x66, 0x01, // ĂŦ (U+0102 U+0166)
  0x01, 0x02, 0x01, 0x74, 0x01, // ĂŴ (U+0102 U+0174)
  0x01, 0x02, 0x01, 0x76, 0x01, // ĂŶ (U+0102 U+0176)
  0x01, 0x02, 0x01, 0x77, 0x01, // Ăŷ (U+0102 U+0177)
  0x01, 0x02, 0x01, 0x78, 0x01, // ĂŸ (U+0102 U+0178)
  0x01, 0x02, 0x20, 0x18, 0x01, // Ă‘ (U+0102 U+2018)
  0x01, 0x02, 0x20, 0x19, 0x01, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1C, 0x01, // Ă“ (U+0102 U+201C)
  0x01, 0x02, 0x20, 0x1D, 0x01, // Ă” (U+0102 U+201D)
  0x01, 0x02, 0x21, 0x22, 0x01, // Ă™ (U+0102 U+2122)
  0x01, 0x04, 0x00, 0x22, 0x01, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x01, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x00, 0x2A, 0x01, // Ą* (U+0104 U+002A)
  0x01, 0x04, 0x00, 0x3F, 0x01, // Ą? (U+0104 U+003F)
  0x01, 0x04, 0x00, 0x54, 0x01, // ĄT (U+0104 U+0054)
  0x01, 0x04, 0x00, 0x56, 0x01, // ĄV (U+0104 U+0056)
  0x01, 0x04, 0x00, 0x57, 0x01, // ĄW (U+0104 U+0057)
  0x01, 0x04, 0x00, 0x59, 0x01, // ĄY (U+0104 U+0059)
  0x01, 0x04, 0x00, 0x76, 0x01, // Ąv (U+0104 U+0076)
  0x01, 0x04, 0x00, 0x79, 0x01, // Ąy (U+0104 U+0079)
  0x01, 0x04, 0x00, 0xDD, 0x01, // ĄÝ (U+0104 U+00DD)
  0x01, 0x04, 0x00, 0xFD, 0x01, // Ąý (U+0104 U+00FD)
  0x01, 0x04, 0x00, 0xFF, 0x01, // Ąÿ (U+0104 U+00FF)
  0x01, 0x04, 0x01, 0x62, 0x01, // ĄŢ (U+0104 U+0162)
  0x01, 0x04, 0x01, 0x64, 0x01, // ĄŤ (U+0104 U+0164)
  0x01, 0x04, 0x01, 0x66, 0x01, // ĄŦ (U+0104 U+0166)
  0x01, 0x04, 0x01, 0x74, 0x01, // ĄŴ (U+0104 U+0174)
  0x01, 0x04, 0x01, 0x76, 0x01, // ĄŶ (U+0104 U+0176)
  0x01, 0x04, 0x01, 0x77, 0x01, // Ąŷ (U+0104 U+0177)
  0x01, 0x04, 0x01, 0x78, 0x01, // ĄŸ (U+0104 U+0178)
  0x01, 0x04, 0x20, 0x18, 0x01, // Ą‘ (U+0104 U+2018)
  0x01, 0x04, 0x20, 0x19, 0x01, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1C, 0x01, // Ą“ (U+0104 U+201C)
  0x01, 0x04, 0x20, 0x1D, 0x01, // Ą” (U+0104 U+201D)
  0x01, 0x04, 0x21, 0x22, 0x01, // Ą™ (U+0104 U+2122)
  0x01, 0x0E, 0x00, 0xC6, 0x01, // ĎÆ (U+010E U+00C6)
  0x01, 0x10, 0x00, 0xC6, 0x01, // ĐÆ (U+0110 U+00C6)
  0x01, 0x13, 0x00, 0x56, 0x01, // ēV (U+0113 U+0056)
  0x01, 0x13, 0x00, 0x57, 0x01, // ēW (U+0113 U+0057)
  0x01, 0x13, 0x00, 0x59, 0x01, // ēY (U+0113 U+0059)
  0x01, 0x13, 0x00, 0xDD, 0x01, // ēÝ (U+0113 U+00DD)
  0x01, 0x13, 0x01, 0x74, 0x01, // ēŴ (U+0113 U+0174)
  0x01, 0x13, 0x01, 0x76, 0x01, // ēŶ (U+0113 U+0176)
  0x01, 0x13, 0x01, 0x78, 0x01, // ēŸ (U+0113 U+0178)
  0x01, 0x15, 0x00, 0x56, 0x01, // ĕV (U+0115 U+0056)
  0x01, 0x15, 0x00, 0x57, 0x01, // ĕW (U+0115 U+0057)
  0x01, 0x15, 0x00, 0x59, 0x01, // ĕY (U+0115 U+0059)
  0x01, 0x15, 0x00, 0xDD, 0x01, // ĕÝ (U+0115 U+00DD)
  0x01, 0x15, 0x01, 0x74, 0x01, // ĕŴ (U+0115 U+0174)
  0x01, 0x15, 0x01, 0x76, 0x01, // ĕŶ (U+0115 U+0176)
  0x01, 0x15, 0x01, 0x78, 0x01, // ĕŸ (U+0115 U+0178)
  0x01, 0x17, 0x00, 0x56, 0x01, // ėV (U+0117 U+0056)
  0x01, 0x17, 0x00, 0x57, 0x01, // ėW (U+0117 U+0057)
  0x01, 0x17, 0x00, 0x59, 0x01, // ėY (U+0117 U+0059)
  0x01, 0x17, 0x00, 0xDD, 0x01, // ėÝ (U+0117 U+00DD)
  0x01, 0x17, 0x01, 0x74, 0x01, // ėŴ (U+0117 U+0174)
  0x01, 0x17, 0x01, 0x76, 0x01, // ėŶ (U+0117 U+0176)
  0x01, 0x17, 0x01, 0x78, 0x01, // ėŸ (U+0117 U+0178)
  0x01, 0x19, 0x00, 0x56, 0x01, // ęV (U+0119 U+0056)
  0x01, 0x19, 0x00, 0x57, 0x01, // ęW (U+0119 U+0057)
  0x01, 0x19, 0x00, 0x59, 0x01, // ęY (U+0119 U+0059)
  0x01, 0x19, 0x00, 0xDD, 0x01, // ęÝ (U+0119 U+00DD)
  0x01, 0x19, 0x01, 0x74, 0x01, // ęŴ (U+0119 U+0174)
  0x01, 0x19, 0x01, 0x76, 0x01, // ęŶ (U+0119 U+0176)
  0x01, 0x19, 0x01, 0x78, 0x01, // ęŸ (U+0119 U+0178)
  0x01, 0x1B, 0x00, 0x56, 0x01, // ěV (U+011B U+0056)
  0x01, 0x1B, 0x00, 0x57, 0x01, // ěW (U+011B U+0057)
  0x01, 0x1B, 0x00, 0x59, 0x01, // ěY (U+011B U+0059)
  0x01, 0x1B, 0x00, 0xDD, 0x01, // ěÝ (U+011B U+00DD)
  0x01, 0x1B, 0x01, 0x74, 0x01, // ěŴ (U+011B U+0174)
  0x01, 0x1B, 0x01, 0x76, 0x01, // ěŶ (U+011B U+0176)
  0x01, 0x1B, 0x01, 0x78, 0x01, // ěŸ (U+011B U+0178)
  0x01, 0x39, 0x00, 0x22, 0x01, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x01, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x00, 0x2A, 0x01, // Ĺ* (U+0139 U+002A)
  0x01, 0x39, 0x00, 0x3F, 0x01, // Ĺ? (U+0139 U+003F)
  0x01, 0x39, 0x00, 0x54, 0x01, // ĹT (U+0139 U+0054)
  0x01, 0x39, 0x00, 0x56, 0x01, // ĹV (U+0139 U+0056)
  0x01, 0x39, 0x00, 0x57, 0x01, // ĹW (U+0139 U+0057)
  0x01, 0x39, 0x00, 0x59, 0x01, // ĹY (U+0139 U+0059)
  0x01, 0x39, 0x00, 0xDD, 0x01, // ĹÝ (U+0139 U+00DD)
  0x01, 0x39, 0x01, 0x62, 0x01, // ĹŢ (U+0139 U+0162)
  0x01, 0x39, 0x01, 0x64, 0x01, // ĹŤ (U+0139 U+0164)
  0x01, 0x39, 0x01, 0x66, 0x01, // ĹŦ (U+0139 U+0166)
  0x01, 0x39, 0x01, 0x74, 0x01, // ĹŴ (U+0139 U+0174)
  0x01, 0x39, 0x01, 0x76, 0x01, // ĹŶ (U+0139 U+0176)
  0x01, 0x39, 0x01, 0x78, 0x01, // ĹŸ (U+0139 U+0178)
  0x01, 0x39, 0x20, 0x18, 0x01, // Ĺ‘ (U+0139 U+2018)
  0x01, 0x39, 0x20, 0x19, 0x01, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1C, 0x01, // Ĺ“ (U+0139 U+201C)
  0x01, 0x39, 0x20, 0x1D, 0x01, // Ĺ” (U+0139 U+201D)
  0x01, 0x39, 0x21, 0x22, 0x01, // Ĺ™ (U+0139 U+2122)
  0x01, 0x3B, 0x00, 0x22, 0x01, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x01, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x00, 0x2A, 0x01, // Ļ* (U+013B U+002A)
  0x01, 0x3B, 0x00, 0x3F, 0x01, // Ļ? (U+013B U+003F)
  0x01, 0x3B, 0x00, 0x54, 0x01, // ĻT (U+013B U+0054)
  0x01, 0x3B, 0x00, 0x56, 0x01, // ĻV (U+013B U+0056)
  0x01, 0x3B, 0x00, 0x57, 0x01, // ĻW (U+013B U+0057)
  0x01, 0x3B, 0x00, 0x59, 0x01, // ĻY (U+013B U+0059)
  0x01, 0x3B, 0x00, 0xDD, 0x01, // ĻÝ (U+013B U+00DD)
  0x01, 0x3B, 0x01, 0x62, 0x01, // ĻŢ (U+013B U+0162)
  0x01, 0x3B, 0x01, 0x64, 0x01, // ĻŤ (U+013B U+0164)
  0x01, 0x3B, 0x01, 0x66, 0x01, // ĻŦ (U+013B U+0166)
  0x01, 0x3B, 0x01, 0x74, 0x01, // ĻŴ (U+013B U+0174)
  0x01, 0x3B, 0x01, 0x76, 0x01, // ĻŶ (U+013B U+0176)
  0x01, 0x3B, 0x01, 0x78, 0x01, // ĻŸ (U+013B U+0178)
  0x01, 0x3B, 0x20, 0x18, 0x01, // Ļ‘ (U+013B U+2018)
  0x01, 0x3B, 0x20, 0x19, 0x01, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1C, 0x01, // Ļ“ (U+013B U+201C)
  0x01, 0x3B, 0x20, 0x1D, 0x01, // Ļ” (U+013B U+201D)
  0x01, 0x3B, 0x21, 0x22, 0x01, // Ļ™ (U+013B U+2122)
  0x01, 0x41, 0x00, 0x22, 0x01, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x01, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x00, 0x2A, 0x01, // Ł* (U+0141 U+002A)
  0x01, 0x41, 0x00, 0x3F, 0x01, // Ł? (U+0141 U+003F)
  0x01, 0x41, 0x00, 0x54, 0x01, // ŁT (U+0141 U+0054)
  0x01, 0x41, 0x00, 0x56, 0x01, // ŁV (U+0141 U+0056)
  0x01, 0x41, 0x00, 0x57, 0x01, // ŁW (U+0141 U+0057)
  0x01, 0x41, 0x00, 0x59, 0x01, // ŁY (U+0141 U+0059)
  0x01, 0x41, 0x00, 0xDD, 0x01, // ŁÝ (U+0141 U+00DD)
  0x01, 0x41, 0x01, 0x62, 0x01, // ŁŢ (U+0141 U+0162)
  0x01, 0x41, 0x01, 0x64, 0x01, // ŁŤ (U+0141 U+0164)
  0x01, 0x41, 0x01, 0x66, 0x01, // ŁŦ (U+0141 U+0166)
  0x01, 0x41, 0x01, 0x74, 0x01, // ŁŴ (U+0141 U+0174)
  0x01, 0x41, 0x01, 0x76, 0x01, // ŁŶ (U+0141 U+0176)
  0x01, 0x41, 0x01, 0x78, 0x01, // ŁŸ (U+0141 U+0178)
  0x01, 0x41, 0x20, 0x18, 0x01, // Ł‘ (U+0141 U+2018)
  0x01, 0x41, 0x20, 0x19, 0x01, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1C, 0x01, // Ł“ (U+0141 U+201C)
  0x01, 0x41, 0x20, 0x1D, 0x01, // Ł” (U+0141 U+201D)
  0x01, 0x41, 0x21, 0x22, 0x01, // Ł™ (U+0141 U+2122)
  0x01, 0x4C, 0x00, 0xC6, 0x01, // ŌÆ (U+014C U+00C6)
  0x01, 0x4D, 0x00, 0x56, 0x01, // ōV (U+014D U+0056)
  0x01, 0x4D, 0x00, 0x57, 0x01, // ōW (U+014D U+0057)
  0x01, 0x4D, 0x00, 0x59, 0x01, // ōY (U+014D U+0059)
  0x01, 0x4D, 0x00, 0xDD, 0x01, // ōÝ (U+014D U+00DD)
  0x01, 0x4D, 0x01, 0x74, 0x01, // ōŴ (U+014D U+0174)
  0x01, 0x4D, 0x01, 0x76, 0x01, // ōŶ (U+014D U+0176)
  0x01, 0x4D, 0x01, 0x78, 0x01, // ōŸ (U+014D U+0178)
  0x01, 0x4E, 0x00, 0xC6, 0x01, // ŎÆ (U+014E U+00C6)
  0x01, 0x4F, 0x00, 0x56, 0x01, // ŏV (U+014F U+0056)
  0x01, 0x4F, 0x00, 0x57, 0x01, // ŏW (U+014F U+0057)
  0x01, 0x4F, 0x00, 0x59, 0x01, // ŏY (U+014F U+0059)
  0x01, 0x4F, 0x00, 0xDD, 0x01, // ŏÝ (U+014F U+00DD)
  0x01, 0x4F, 0x01, 0x74, 0x01, // ŏŴ (U+014F U+0174)
  0x01, 0x4F, 0x01, 0x76, 0x01, // ŏŶ (U+014F U+0176)
  0x01, 0x4F, 0x01, 0x78, 0x01, // ŏŸ (U+014F U+0178)
  0x01, 0x50, 0x00, 0xC6, 0x01, // ŐÆ (U+0150 U+00C6)
  0x01, 0x51, 0x00, 0x56, 0x01, // őV (U+0151 U+0056)
  0x01, 0x51, 0x00, 0x57, 0x01, // őW (U+0151 U+0057)
  0x01, 0x51, 0x00, 0x59, 0x01, // őY (U+0151 U+0059)
  0x01, 0x51, 0x00, 0xDD, 0x01, // őÝ (U+0151 U+00DD)
  0x01, 0x51, 0x01, 0x74, 0x01, // őŴ (U+0151 U+0174)
  0x01, 0x51, 0x01, 0x76, 0x01, // őŶ (U+0151 U+0176)
  0x01, 0x51, 0x01, 0x78, 0x01, // őŸ (U+0151 U+0178)
  0x01, 0x53, 0x00, 0x56, 0x01, // œV (U+0153 U+0056)
  0x01, 0x53, 0x00, 0x57, 0x01, // œW (U+0153 U+0057)
  0x01, 0x53, 0x00, 0x59, 0x01, // œY (U+0153 U+0059)
  0x01, 0x53, 0x00, 0xDD, 0x01, // œÝ (U+0153 U+00DD)
  0x01, 0x53, 0x01, 0x74, 0x01, // œŴ (U+0153 U+0174)
  0x01, 0x53, 0x01, 0x76, 0x01, // œŶ (U+0153 U+0176)
  0x01, 0x53, 0x01, 0x78, 0x01, // œŸ (U+0153 U+0178)
  0x01, 0x55, 0x00, 0x2C, 0x02, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x02, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x20, 0x1A, 0x02, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x02, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x02, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x02, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x02, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x20, 0x1A, 0x02, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x02, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x02, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x02, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x02, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x20, 0x1A, 0x02, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x02, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x02, // ř… (U+0159 U+2026)
  0x01, 0x5B, 0x00, 0x59, 0x01, // śY (U+015B U+0059)
  0x01, 0x5B, 0x00, 0xDD, 0x01, // śÝ (U+015B U+00DD)
  0x01, 0x5B, 0x01, 0x76, 0x01, // śŶ (U+015B U+0176)
  0x01, 0x5B, 0x01, 0x78, 0x01, // śŸ (U+015B U+0178)
  0x01, 0x5D, 0x00, 0x59, 0x01, // ŝY (U+015D U+0059)
  0x01, 0x5D, 0x00, 0xDD, 0x01, // ŝÝ (U+015D U+00DD)
  0x01, 0x5D, 0x01, 0x76, 0x01, // ŝŶ (U+015D U+0176)
  0x01, 0x5D, 0x01, 0x78, 0x01, // ŝŸ (U+015D U+0178)
  0x01, 0x5F, 0x00, 0x59, 0x01, // şY (U+015F U+0059)
  0x01, 0x5F, 0x00, 0xDD, 0x01, // şÝ (U+015F U+00DD)
  0x01, 0x5F, 0x01, 0x76, 0x01, // şŶ (U+015F U+0176)
  0x01, 0x5F, 0x01, 0x78, 0x01, // şŸ (U+015F U+0178)
  0x01, 0x61, 0x00, 0x59, 0x01, // šY (U+0161 U+0059)
  0x01, 0x61, 0x00, 0xDD, 0x01, // šÝ (U+0161 U+00DD)
  0x01, 0x61, 0x01, 0x76, 0x01, // šŶ (U+0161 U+0176)
  0x01, 0x61, 0x01, 0x78, 0x01, // šŸ (U+0161 U+0178)
  0x01, 0x62, 0x00, 0x2C, 0x01, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2E, 0x01, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0x41, 0x01, // ŢA (U+0162 U+0041)
  0x01, 0x62, 0x00, 0x63, 0x01, // Ţc (U+0162 U+0063)
  0x01, 0x62, 0x00, 0x64, 0x01, // Ţd (U+0162 U+0064)
  0x01, 0x62, 0x00, 0x65, 0x01, // Ţe (U+0162 U+0065)
  0x01, 0x62, 0x00, 0x67, 0x01, // Ţg (U+0162 U+0067)
  0x01, 0x62, 0x00, 0x6F, 0x01, // Ţo (U+0162 U+006F)
  0x01, 0x62, 0x00, 0x71, 0x01, // Ţq (U+0162 U+0071)
  0x01, 0x62, 0x00, 0xC0, 0x01, // ŢÀ (U+0162 U+00C0)
  0x01, 0x62, 0x00, 0xC1, 0x01, // ŢÁ (U+0162 U+00C1)
  0x01, 0x62, 0x00, 0xC2, 0x01, // ŢÂ (U+0162 U+00C2)
  0x01, 0x62, 0x00, 0xC3, 0x01, // ŢÃ (U+0162 U+00C3)
  0x01, 0x62, 0x00, 0xC4, 0x01, // ŢÄ (U+0162 U+00C4)
  0x01, 0x62, 0x00, 0xC5, 0x01, // ŢÅ (U+0162 U+00C5)
  0x01, 0x62, 0x00, 0xC6, 0x01, // ŢÆ (U+0162 U+00C6)
  0x01, 0x62, 0x00, 0xE7, 0x01, // Ţç (U+0162 U+00E7)
  0x01, 0x62, 0x00, 0xE8, 0x01, // Ţè (U+0162 U+00E8)
  0x01, 0x62, 0x00, 0xE9, 0x01, // Ţé (U+0162 U+00E9)
  0x01, 0x62, 0x00, 0xEA, 0x01, // Ţê (U+0162 U+00EA)
  0x01, 0x62, 0x00, 0xEB, 0x01, // Ţë (U+0162 U+00EB)
  0x01, 0x62, 0x00, 0xF0, 0x01, // Ţð (U+0162 U+00F0)
  0x01, 0x62, 0x00, 0xF2, 0x01, // Ţò (U+0162 U+00F2)
  0x01, 0x62, 0x00, 0xF3, 0x01, // Ţó (U+0162 U+00F3)
  0x01, 0x62, 0x00, 0xF4, 0x01, // Ţô (U+0162 U+00F4)
  0x01, 0x62, 0x00, 0xF5, 0x01, // Ţõ (U+0162 U+00F5)
  0x01, 0x62, 0x00, 0xF6, 0x01, // Ţö (U+0162 U+00F6)
  0x01, 0x62, 0x00, 0xF8, 0x01, // Ţø (U+0162 U+00F8)
  0x01, 0x62, 0x01, 0x00, 0x01, // ŢĀ (U+0162 U+0100)
  0x01, 0x62, 0x01, 0x02, 0x01, // ŢĂ (U+0162 U+0102)
  0x01, 0x62, 0x01, 0x04, 0x01, // ŢĄ (U+0162 U+0104)
  0x01, 0x62, 0x01, 0x07, 0x01, // Ţć (U+0162 U+0107)
  0x01, 0x62, 0x01, 0x09, 0x01, // Ţĉ (U+0162 U+0109)
  0x01, 0x62, 0x01, 0x0B, 0x01, // Ţċ (U+0162 U+010B)
  0x01, 0x62, 0x01, 0x0D, 0x01, // Ţč (U+0162 U+010D)
  0x01, 0x62, 0x01, 0x0F, 0x01, // Ţď (U+0162 U+010F)
  0x01, 0x62, 0x01, 0x11, 0x01, // Ţđ (U+0162 U+0111)
  0x01, 0x62, 0x01, 0x13, 0x01, // Ţē (U+0162 U+0113)
  0x01, 0x62, 0x01, 0x15, 0x01, // Ţĕ (U+0162 U+0115)
  0x01, 0x62, 0x01, 0x17, 0x01, // Ţė (U+0162 U+0117)
  0x01, 0x62, 0x01, 0x19, 0x01, // Ţę (U+0162 U+0119)
  0x01, 0x62, 0x01, 0x1B, 0x01, // Ţě (U+0162 U+011B)
  0x01, 0x62, 0x01, 0x1D, 0x01, // Ţĝ (U+0162 U+011D)
  0x01, 0x62, 0x01, 0x1F, 0x01, // Ţğ (U+0162 U+011F)
  0x01, 0x62, 0x01, 0x21, 0x01, // Ţġ (U+0162 U+0121)
  0x01, 0x62, 0x01, 0x23, 0x01, // Ţģ (U+0162 U+0123)
  0x01, 0x62, 0x01, 0x4D, 0x01, // Ţō (U+0162 U+014D)
  0x01, 0x62, 0x01, 0x4F, 0x01, // Ţŏ (U+0162 U+014F)
  0x01, 0x62, 0x01, 0x51, 0x01, // Ţő (U+0162 U+0151)
  0x01, 0x62, 0x01, 0x53, 0x01, // Ţœ (U+0162 U+0153)
  0x01, 0x62, 0x20, 0x1A, 0x01, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x01, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x01, // Ţ… (U+0162 U+2026)
  0x01, 0x64, 0x00, 0x2C, 0x01, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2E, 0x01, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0x41, 0x01, // ŤA (U+0164 U+0041)
  0x01, 0x64, 0x00, 0x63, 0x01, // Ťc (U+0164 U+0063)
  0x01, 0x64, 0x00, 0x64, 0x01, // Ťd (U+0164 U+0064)
  0x01, 0x64, 0x00, 0x65, 0x01, // Ťe (U+0164 U+0065)
  0x01, 0x64, 0x00, 0x67, 0x01, // Ťg (U+0164 U+0067)
  0x01, 0x64, 0x00, 0x6F, 0x01, // Ťo (U+0164 U+006F)
  0x01, 0x64, 0x00, 0x71, 0x01, // Ťq (U+0164 U+0071)
  0x01, 0x64, 0x00, 0xC0, 0x01, // ŤÀ (U+0164 U+00C0)
  0x01, 0x64, 0x00, 0xC1, 0x01, // ŤÁ (U+0164 U+00C1)
  0x01, 0x64, 0x00, 0xC2, 0x01, // ŤÂ (U+0164 U+00C2)
  0x01, 0x64, 0x00, 0xC3, 0x01, // ŤÃ (U+0164 U+00C3)
  0x01, 0x64, 0x00, 0xC4, 0x01, // ŤÄ (U+0164 U+00C4)
  0x01, 0x64, 0x00, 0xC5, 0x01, // ŤÅ (U+0164 U+00C5)
  0x01, 0x64, 0x00, 0xC6, 0x01, // ŤÆ (U+0164 U+00C6)
  0x01, 0x64, 0x00, 0xE7, 0x01, // Ťç (U+0164 U+00E7)
  0x01, 0x64, 0x00, 0xE8, 0x01, // Ťè (U+0164 U+00E8)
  0x01, 0x64, 0x00, 0xE9, 0x01, // Ťé (U+0164 U+00E9)
  0x01, 0x64, 0x00, 0xEA, 0x01, // Ťê (U+0164 U+00EA)
  0x01, 0x64, 0x00, 0xEB, 0x01, // Ťë (U+0164 U+00EB)
  0x01, 0x64, 0x00, 0xF0, 0x01, // Ťð (U+0164 U+00F0)
  0x01, 0x64, 0x00, 0xF2, 0x01, // Ťò (U+0164 U+00F2)
  0x01, 0x64, 0x00, 0xF3, 0x01, // Ťó (U+0164 U+00F3)
  0x01, 0x64, 0x00, 0xF4, 0x01, // Ťô (U+0164 U+00F4)
  0x01, 0x64, 0x00, 0xF5, 0x01, // Ťõ (U+0164 U+00F5)
  0x01, 0x64, 0x00, 0xF6, 0x01, // Ťö (U+0164 U+00F6)
  0x01, 0x64, 0x00, 0xF8, 0x01, // Ťø (U+0164 U+00F8)
  0x01, 0x64, 0x01, 0x00, 0x01, // ŤĀ (U+0164 U+0100)
  0x01, 0x64, 0x01, 0x02, 0x01, // ŤĂ (U+0164 U+0102)
  0x01, 0x64, 0x01, 0x04, 0x01, // ŤĄ (U+0164 U+0104)
  0x01, 0x64, 0x01, 0x07, 0x01, // Ťć (U+0164 U+0107)
  0x01, 0x64, 0x01, 0x09, 0x01, // Ťĉ (U+0164 U+0109)
  0x01, 0x64, 0x01, 0x0B, 0x01, // Ťċ (U+0164 U+010B)
  0x01, 0x64, 0x01, 0x0D, 0x01, // Ťč (U+0164 U+010D)
  0x01, 0x64, 0x01, 0x0F, 0x01, // Ťď (U+0164 U+010F)
  0x01, 0x64, 0x01, 0x11, 0x01, // Ťđ (U+0164 U+0111)
  0x01, 0x64, 0x01, 0x13, 0x01, // Ťē (U+0164 U+0113)
  0x01, 0x64, 0x01, 0x15, 0x01, // Ťĕ (U+0164 U+0115)
  0x01, 0x64, 0x01, 0x17, 0x01, // Ťė (U+0164 U+0117)
  0x01, 0x64, 0x01, 0x19, 0x01, // Ťę (U+0164 U+0119)
  0x01, 0x64, 0x01, 0x1B, 0x01, // Ťě (U+0164 U+011B)
  0x01, 0x64, 0x01, 0x1D, 0x01, // Ťĝ (U+0164 U+011D)
  0x01, 0x64, 0x01, 0x1F, 0x01, // Ťğ (U+0164 U+011F)
  0x01, 0x64, 0x01, 0x21, 0x01, // Ťġ (U+0164 U+0121)
  0x01, 0x64, 0x01, 0x23, 0x01, // Ťģ (U+0164 U+0123)
  0x01, 0x64, 0x01, 0x4D, 0x01, // Ťō (U+0164 U+014D)
  0x01, 0x64, 0x01, 0x4F, 0x01, // Ťŏ (U+0164 U+014F)
  0x01, 0x64, 0x01, 0x51, 0x01, // Ťő (U+0164 U+0151)
  0x01, 0x64, 0x01, 0x53, 0x01, // Ťœ (U+0164 U+0153)
  0x01, 0x64, 0x20, 0x1A, 0x01, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x01, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x01, // Ť… (U+0164 U+2026)
  0x01, 0x66, 0x00, 0x2C, 0x01, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2E, 0x01, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0x41, 0x01, // ŦA (U+0166 U+0041)
  0x01, 0x66, 0x00, 0x63, 0x01, // Ŧc (U+0166 U+0063)
  0x01, 0x66, 0x00, 0x64, 0x01, // Ŧd (U+0166 U+0064)
  0x01, 0x66, 0x00, 0x65, 0x01, // Ŧe (U+0166 U+0065)
  0x01, 0x66, 0x00, 0x67, 0x01, // Ŧg (U+0166 U+0067)
  0x01, 0x66, 0x00, 0x6F, 0x01, // Ŧo (U+0166 U+006F)
  0x01, 0x66, 0x00, 0x71, 0x01, // Ŧq (U+0166 U+0071)
  0x01, 0x66, 0x00, 0xC0, 0x01, // ŦÀ (U+0166 U+00C0)
  0x01, 0x66, 0x00, 0xC1, 0x01, // ŦÁ (U+0166 U+00C1)
  0x01, 0x66, 0x00, 0xC2, 0x01, // ŦÂ (U+0166 U+00C2)
  0x01, 0x66, 0x00, 0xC3, 0x01, // ŦÃ (U+0166 U+00C3)
  0x01, 0x66, 0x00, 0xC4, 0x01, // ŦÄ (U+0166 U+00C4)
  0x01, 0x66, 0x00, 0xC5, 0x01, // ŦÅ (U+0166 U+00C5)
  0x01, 0x66, 0x00, 0xC6, 0x01, // ŦÆ (U+0166 U+00C6)
  0x01, 0x66, 0x00, 0xE7, 0x01, // Ŧç (U+0166 U+00E7)
  0x01, 0x66, 0x00, 0xE8, 0x01, // Ŧè (U+0166 U+00E8)
  0x01, 0x66, 0x00, 0xE9, 0x01, // Ŧé (U+0166 U+00E9)
  0x01, 0x66, 0x00, 0xEA, 0x01, // Ŧê (U+0166 U+00EA)
  0x01, 0x66, 0x00, 0xEB, 0x01, // Ŧë (U+0166 U+00EB)
  0x01, 0x66, 0x00, 0xF0, 0x01, // Ŧð (U+0166 U+00F0)
  0x01, 0x66, 0x00, 0xF2, 0x01, // Ŧò (U+0166 U+00F2)
  0x01, 0x66, 0x00, 0xF3, 0x01, // Ŧó (U+0166 U+00F3)
  0x01, 0x66, 0x00, 0xF4, 0x01, // Ŧô (U+0166 U+00F4)
  0x01, 0x66, 0x00, 0xF5, 0x01, // Ŧõ (U+0166 U+00F5)
  0x01, 0x66, 0x00, 0xF6, 0x01, // Ŧö (U+0166 U+00F6)
  0x01, 0x66, 0x00, 0xF8, 0x01, // Ŧø (U+0166 U+00F8)
  0x01, 0x66, 0x01, 0x00, 0x01, // ŦĀ (U+0166 U+0100)
  0x01, 0x66, 0x01, 0x02, 0x01, // ŦĂ (U+0166 U+0102)
  0x01, 0x66, 0x01, 0x04, 0x01, // ŦĄ (U+0166 U+0104)
  0x01, 0x66, 0x01, 0x07, 0x01, // Ŧć (U+0166 U+0107)
  0x01, 0x66, 0x01, 0x09, 0x01, // Ŧĉ (U+0166 U+0109)
  0x01, 0x66, 0x01, 0x0B, 0x01, // Ŧċ (U+0166 U+010B)
  0x01, 0x66, 0x01, 0x0D, 0x01, // Ŧč (U+0166 U+010D)
  0x01, 0x66, 0x01, 0x0F, 0x01, // Ŧď (U+0166 U+010F)
  0x01, 0x66, 0x01, 0x11, 0x01, // Ŧđ (U+0166 U+0111)
  0x01, 0x66, 0x01, 0x13, 0x01, // Ŧē (U+0166 U+0113)
  0x01, 0x66, 0x01, 0x15, 0x01, // Ŧĕ (U+0166 U+0115)
  0x01, 0x66, 0x01, 0x17, 0x01, // Ŧė (U+0166 U+0117)
  0x01, 0x66, 0x01, 0x19, 0x01, // Ŧę (U+0166 U+0119)
  0x01, 0x66, 0x01, 0x1B, 0x01, // Ŧě (U+0166 U+011B)
  0x01, 0x66, 0x01, 0x1D, 0x01, // Ŧĝ (U+0166 U+011D)
  0x01, 0x66, 0x01, 0x1F, 0x01, // Ŧğ (U+0166 U+011F)
  0x01, 0x66, 0x01, 0x21, 0x01, // Ŧġ (U+0166 U+0121)
  0x01, 0x66, 0x01, 0x23, 0x01, // Ŧģ (U+0166 U+0123)
  0x01, 0x66, 0x01, 0x4D, 0x01, // Ŧō (U+0166 U+014D)
  0x01, 0x66, 0x01, 0x4F, 0x01, // Ŧŏ (U+0166 U+014F)
  0x01, 0x66, 0x01, 0x51, 0x01, // Ŧő (U+0166 U+0151)
  0x01, 0x66, 0x01, 0x53, 0x01, // Ŧœ (U+0166 U+0153)
  0x01, 0x66, 0x20, 0x1A, 0x01, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x01, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x01, // Ŧ… (U+0166 U+2026)
  0x01, 0x74, 0x00, 0x2C, 0x01, // Ŵ, (U+0174 U+002C)
  0x01, 0x74, 0x00, 0x2E, 0x01, // Ŵ. (U+0174 U+002E)
  0x01, 0x74, 0x00, 0x40, 0x01, // Ŵ@ (U+0174 U+0040)
  0x01, 0x74, 0x00, 0x41, 0x01, // ŴA (U+0174 U+0041)
  0x01, 0x74, 0x00, 0x61, 0x01, // Ŵa (U+0174 U+0061)
  0x01, 0x74, 0x00, 0x63, 0x01, // Ŵc (U+0174 U+0063)
  0x01, 0x74, 0x00, 0x64, 0x01, // Ŵd (U+0174 U+0064)
  0x01, 0x74, 0x00, 0x65, 0x01, // Ŵe (U+0174 U+0065)
  0x01, 0x74, 0x00, 0x67, 0x01, // Ŵg (U+0174 U+0067)
  0x01, 0x74, 0x00, 0x6F, 0x01, // Ŵo (U+0174 U+006F)
  0x01, 0x74, 0x00, 0x71, 0x01, // Ŵq (U+0174 U+0071)
  0x01, 0x74, 0x00, 0x73, 0x01, // Ŵs (U+0174 U+0073)
  0x01, 0x74, 0x00, 0xC0, 0x01, // ŴÀ (U+0174 U+00C0)
  0x01, 0x74, 0x00, 0xC1, 0x01, // ŴÁ (U+0174 U+00C1)
  0x01, 0x74, 0x00, 0xC2, 0x01, // ŴÂ (U+0174 U+00C2)
  0x01, 0x74, 0x00, 0xC3, 0x01, // ŴÃ (U+0174 U+00C3)
  0x01, 0x74, 0x00, 0xC4, 0x01, // ŴÄ (U+0174 U+00C4)
  0x01, 0x74, 0x00, 0xC5, 0x01, // ŴÅ (U+0174 U+00C5)
  0x01, 0x74, 0x00, 0xC6, 0x02, // ŴÆ (U+0174 U+00C6)
  0x01, 0x74, 0x00, 0xE0, 0x01, // Ŵà (U+0174 U+00E0)
  0x01, 0x74, 0x00, 0xE1, 0x01, // Ŵá (U+0174 U+00E1)
  0x01, 0x74, 0x00, 0xE2, 0x01, // Ŵâ (U+0174 U+00E2)
  0x01, 0x74, 0x00, 0xE3, 0x01, // Ŵã (U+0174 U+00E3)
  0x01, 0x74, 0x00, 0xE4, 0x01, // Ŵä (U+0174 U+00E4)
  0x01, 0x74, 0x00, 0xE5, 0x01, // Ŵå (U+0174 U+00E5)
  0x01, 0x74, 0x00, 0xE6, 0x01, // Ŵæ (U+0174 U+00E6)
  0x01, 0x74, 0x00, 0xE7, 0x01, // Ŵç (U+0174 U+00E7)
  0x01, 0x74, 0x00, 0xE8, 0x01, // Ŵè (U+0174 U+00E8)
  0x01, 0x74, 0x00, 0xE9, 0x01, // Ŵé (U+0174 U+00E9)
  0x01, 0x74, 0x00, 0xEA, 0x01, // Ŵê (U+0174 U+00EA)
  0x01, 0x74, 0x00, 0xEB, 0x01, // Ŵë (U+0174 U+00EB)
  0x01, 0x74, 0x00, 0xF0, 0x01, // Ŵð (U+0174 U+00F0)
  0x01, 0x74, 0x00, 0xF2, 0x01, // Ŵò (U+0174 U+00F2)
  0x01, 0x74, 0x00, 0xF3, 0x01, // Ŵó (U+0174 U+00F3)
  0x01, 0x74, 0x00, 0xF4, 0x01, // Ŵô (U+0174 U+00F4)
  0x01, 0x74, 0x00, 0xF5, 0x01, // Ŵõ (U+0174 U+00F5)
  0x01, 0x74, 0x00, 0xF6, 0x01, // Ŵö (U+0174 U+00F6)
  0x01, 0x74, 0x00, 0xF8, 0x01, // Ŵø (U+0174 U+00F8)
  0x01, 0x74, 0x01, 0x00, 0x01, // ŴĀ (U+0174 U+0100)
  0x01, 0x74, 0x01, 0x01, 0x01, // Ŵā (U+0174 U+0101)
  0x01, 0x74, 0x01, 0x02, 0x01, // ŴĂ (U+0174 U+0102)
  0x01, 0x74, 0x01, 0x03, 0x01, // Ŵă (U+0174 U+0103)
  0x01, 0x74, 0x01, 0x04, 0x01, // ŴĄ (U+0174 U+0104)
  0x01, 0x74, 0x01, 0x05, 0x01, // Ŵą (U+0174 U+0105)
  0x01, 0x74, 0x01, 0x07, 0x01, // Ŵć (U+0174 U+0107)
  0x01, 0x74, 0x01, 0x09, 0x01, // Ŵĉ (U+0174 U+0109)
  0x01, 0x74, 0x01, 0x0B, 0x01, // Ŵċ (U+0174 U+010B)
  0x01, 0x74, 0x01, 0x0D, 0x01, // Ŵč (U+0174 U+010D)
  0x01, 0x74, 0x01, 0x0F, 0x01, // Ŵď (U+0174 U+010F)
  0x01, 0x74, 0x01, 0x11, 0x01, // Ŵđ (U+0174 U+0111)
  0x01, 0x74, 0x01, 0x13, 0x01, // Ŵē (U+0174 U+0113)
  0x01, 0x74, 0x01, 0x15, 0x01, // Ŵĕ (U+0174 U+0115)
  0x01, 0x74, 0x01, 0x17, 0x01, // Ŵė (U+0174 U+0117)
  0x01, 0x74, 0x01, 0x19, 0x01, // Ŵę (U+0174 U+0119)
  0x01, 0x74, 0x01, 0x1B, 0x01, // Ŵě (U+0174 U+011B)
  0x01, 0x74, 0x01, 0x1D, 0x01, // Ŵĝ (U+0174 U+011D)
  0x01, 0x74, 0x01, 0x1F, 0x01, // Ŵğ (U+0174 U+011F)
  0x01, 0x74, 0x01, 0x21, 0x01, // Ŵġ (U+0174 U+0121)
  0x01, 0x74, 0x01, 0x23, 0x01, // Ŵģ (U+0174 U+0123)
  0x01, 0x74, 0x01, 0x4D, 0x01, // Ŵō (U+0174 U+014D)
  0x01, 0x74, 0x01, 0x4F, 0x01, // Ŵŏ (U+0174 U+014F)
  0x01, 0x74, 0x01, 0x51, 0x01, // Ŵő (U+0174 U+0151)
  0x01, 0x74, 0x01, 0x53, 0x01, // Ŵœ (U+0174 U+0153)
  0x01, 0x74, 0x01, 0x5B, 0x01, // Ŵś (U+0174 U+015B)
  0x01, 0x74, 0x01, 0x5D, 0x01, // Ŵŝ (U+0174 U+015D)
  0x01, 0x74, 0x01, 0x5F, 0x01, // Ŵş (U+0174 U+015F)
  0x01, 0x74, 0x01, 0x61, 0x01, // Ŵš (U+0174 U+0161)
  0x01, 0x74, 0x20, 0x1A, 0x01, // Ŵ‚ (U+0174 U+201A)
  0x01, 0x74, 0x20, 0x1E, 0x01, // Ŵ„ (U+0174 U+201E)
  0x01, 0x74, 0x20, 0x26, 0x01, // Ŵ… (U+0174 U+2026)
  0x01, 0x75, 0x00, 0x2C, 0x01, // ŵ, (U+0175 U+002C)
  0x01, 0x75, 0x00, 0x2E, 0x01, // ŵ. (U+0175 U+002E)
  0x01, 0x75, 0x20, 0x1A, 0x01, // ŵ‚ (U+0175 U+201A)
  0x01, 0x75, 0x20, 0x1E, 0x01, // ŵ„ (U+0175 U+201E)
  0x01, 0x75, 0x20, 0x26, 0x01, // ŵ… (U+0175 U+2026)
  0x01, 0x76, 0x00, 0x2C, 0x01, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x01, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x00, 0x41, 0x01, // ŶA (U+0176 U+0041)
  0x01, 0x76, 0x00, 0x61, 0x01, // Ŷa (U+0176 U+0061)
  0x01, 0x76, 0x00, 0x63, 0x01, // Ŷc (U+0176 U+0063)
  0x01, 0x76, 0x00, 0x64, 0x01, // Ŷd (U+0176 U+0064)
  0x01, 0x76, 0x00, 0x65, 0x01, // Ŷe (U+0176 U+0065)
  0x01, 0x76, 0x00, 0x67, 0x01, // Ŷg (U+0176 U+0067)
  0x01, 0x76, 0x00, 0x6F, 0x01, // Ŷo (U+0176 U+006F)
  0x01, 0x76, 0x00, 0x71, 0x01, // Ŷq (U+0176 U+0071)
  0x01, 0x76, 0x00, 0x73, 0x01, // Ŷs (U+0176 U+0073)
  0x01, 0x76, 0x00, 0xC0, 0x01, // ŶÀ (U+0176 U+00C0)
  0x01, 0x76, 0x00, 0xC1, 0x01, // ŶÁ (U+0176 U+00C1)
  0x01, 0x76, 0x00, 0xC2, 0x01, // ŶÂ (U+0176 U+00C2)
  0x01, 0x76, 0x00, 0xC3, 0x01, // ŶÃ (U+0176 U+00C3)
  0x01, 0x76, 0x00, 0xC4, 0x01, // ŶÄ (U+0176 U+00C4)
  0x01, 0x76, 0x00, 0xC5, 0x01, // ŶÅ (U+0176 U+00C5)
  0x01, 0x76, 0x00, 0xC6, 0x01, // ŶÆ (U+0176 U+00C6)
  0x01, 0x76, 0x00, 0xE0, 0x01, // Ŷà (U+0176 U+00E0)
  0x01, 0x76, 0x00, 0xE1, 0x01, // Ŷá (U+0176 U+00E1)
  0x01, 0x76, 0x00, 0xE2, 0x01, // Ŷâ (U+0176 U+00E2)
  0x01, 0x76, 0x00, 0xE3, 0x01, // Ŷã (U+0176 U+00E3)
  0x01, 0x76, 0x00, 0xE4, 0x01, // Ŷä (U+0176 U+00E4)
  0x01, 0x76, 0x00, 0xE5, 0x01, // Ŷå (U+0176 U+00E5)
  0x01, 0x76, 0x00, 0xE6, 0x01, // Ŷæ (U+0176 U+00E6)
  0x01, 0x76, 0x00, 0xE7, 0x01, // Ŷç (U+0176 U+00E7)
  0x01, 0x76, 0x00, 0xE8, 0x01, // Ŷè (U+0176 U+00E8)
  0x01, 0x76, 0x00, 0xE9, 0x01, // Ŷé (U+0176 U+00E9)
  0x01, 0x76, 0x00, 0xEA, 0x01, // Ŷê (U+0176 U+00EA)
  0x01, 0x76, 0x00, 0xEB, 0x01, // Ŷë (U+0176 U+00EB)
  0x01, 0x76, 0x00, 0xF0, 0x01, // Ŷð (U+0176 U+00F0)
  0x01, 0x76, 0x00, 0xF2, 0x01, // Ŷò (U+0176 U+00F2)
  0x01, 0x76, 0x00, 0xF3, 0x01, // Ŷó (U+0176 U+00F3)
  0x01, 0x76, 0x00, 0xF4, 0x01, // Ŷô (U+0176 U+00F4)
  0x01, 0x76, 0x00, 0xF5, 0x01, // Ŷõ (U+0176 U+00F5)
  0x01, 0x76, 0x00, 0xF6, 0x01, // Ŷö (U+0176 U+00F6)
  0x01, 0x76, 0x00, 0xF8, 0x01, // Ŷø (U+0176 U+00F8)
  0x01, 0x76, 0x01, 0x00, 0x01, // ŶĀ (U+0176 U+0100)
  0x01, 0x76, 0x01, 0x01, 0x01, // Ŷā (U+0176 U+0101)
  0x01, 0x76, 0x01, 0x02, 0x01, // ŶĂ (U+0176 U+0102)
  0x01, 0x76, 0x01, 0x03, 0x01, // Ŷă (U+0176 U+0103)
  0x01, 0x76, 0x01, 0x04, 0x01, // ŶĄ (U+0176 U+0104)
  0x01, 0x76, 0x01, 0x05, 0x01, // Ŷą (U+0176 U+0105)
  0x01, 0x76, 0x01, 0x07, 0x01, // Ŷć (U+0176 U+0107)
  0x01, 0x76, 0x01, 0x09, 0x01, // Ŷĉ (U+0176 U+0109)
  0x01, 0x76, 0x01, 0x0B, 0x01, // Ŷċ (U+0176 U+010B)
  0x01, 0x76, 0x01, 0x0D, 0x01, // Ŷč (U+0176 U+010D)
  0x01, 0x76, 0x01, 0x0F, 0x01, // Ŷď (U+0176 U+010F)
  0x01, 0x76, 0x01, 0x11, 0x01, // Ŷđ (U+0176 U+0111)
  0x01, 0x76, 0x01, 0x13, 0x01, // Ŷē (U+0176 U+0113)
  0x01, 0x76, 0x01, 0x15, 0x01, // Ŷĕ (U+0176 U+0115)
  0x01, 0x76, 0x01, 0x17, 0x01, // Ŷė (U+0176 U+0117)
  0x01, 0x76, 0x01, 0x19, 0x01, // Ŷę (U+0176 U+0119)
  0x01, 0x76, 0x01, 0x1B, 0x01, // Ŷě (U+0176 U+011B)
  0x01, 0x76, 0x01, 0x1D, 0x01, // Ŷĝ (U+0176 U+011D)
  0x01, 0x76, 0x01, 0x1F, 0x01, // Ŷğ (U+0176 U+011F)
  0x01, 0x76, 0x01, 0x21, 0x01, // Ŷġ (U+0176 U+0121)
  0x01, 0x76, 0x01, 0x23, 0x01, // Ŷģ (U+0176 U+0123)
  0x01, 0x76, 0x01, 0x4D, 0x01, // Ŷō (U+0176 U+014D)
  0x01, 0x76, 0x01, 0x4F, 0x01, // Ŷŏ (U+0176 U+014F)
  0x01, 0x76, 0x01, 0x51, 0x01, // Ŷő (U+0176 U+0151)
  0x01, 0x76, 0x01, 0x53, 0x01, // Ŷœ (U+0176 U+0153)
  0x01, 0x76, 0x01, 0x5B, 0x01, // Ŷś (U+0176 U+015B)
  0x01, 0x76, 0x01, 0x5D, 0x01, // Ŷŝ (U+0176 U+015D)
  0x01, 0x76, 0x01, 0x5F, 0x01, // Ŷş (U+0176 U+015F)
  0x01, 0x76, 0x01, 0x61, 0x01, // Ŷš (U+0176 U+0161)
  0x01, 0x76, 0x20, 0x1A, 0x01, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x01, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x01, // Ŷ… (U+0176 U+2026)
  0x01, 0x77, 0x00, 0x2C, 0x01, // ŷ, (U+0177 U+002C)
  0x01, 0x77, 0x00, 0x2E, 0x01, // ŷ. (U+0177 U+002E)
  0x01, 0x77, 0x00, 0x41, 0x01, // ŷA (U+0177 U+0041)
  0x01, 0x77, 0x00, 0xC0, 0x01, // ŷÀ (U+0177 U+00C0)
  0x01, 0x77, 0x00, 0xC1, 0x01, // ŷÁ (U+0177 U+00C1)
  0x01, 0x77, 0x00, 0xC2, 0x01, // ŷÂ (U+0177 U+00C2)
  0x01, 0x77, 0x00, 0xC3, 0x01, // ŷÃ (U+0177 U+00C3)
  0x01, 0x77, 0x00, 0xC4, 0x01, // ŷÄ (U+0177 U+00C4)
  0x01, 0x77, 0x00, 0xC5, 0x01, // ŷÅ (U+0177 U+00C5)
  0x01, 0x77, 0x01, 0x00, 0x01, // ŷĀ (U+0177 U+0100)
  0x01, 0x77, 0x01, 0x02, 0x01, // ŷĂ (U+0177 U+0102)
  0x01, 0x77, 0x01, 0x04, 0x01, // ŷĄ (U+0177 U+0104)
  0x01, 0x77, 0x20, 0x1A, 0x01, // ŷ‚ (U+0177 U+201A)
  0x01, 0x77, 0x20, 0x1E, 0x01, // ŷ„ (U+0177 U+201E)
  0x01, 0x77, 0x20, 0x26, 0x01, // ŷ… (U+0177 U+2026)
  0x01, 0x78, 0x00, 0x2C, 0x01, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x01, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x00, 0x41, 0x01, // ŸA (U+0178 U+0041)
  0x01, 0x78, 0x00, 0x61, 0x01, // Ÿa (U+0178 U+0061)
  0x01, 0x78, 0x00, 0x63, 0x01, // Ÿc (U+0178 U+0063)
  0x01, 0x78, 0x00, 0x64, 0x01, // Ÿd (U+0178 U+0064)
  0x01, 0x78, 0x00, 0x65, 0x01, // Ÿe (U+0178 U+0065)
  0x01, 0x78, 0x00, 0x67, 0x01, // Ÿg (U+0178 U+0067)
  0x01, 0x78, 0x00, 0x6F, 0x01, // Ÿo (U+0178 U+006F)
  0x01, 0x78, 0x00, 0x71, 0x01, // Ÿq (U+0178 U+0071)
  0x01, 0x78, 0x00, 0x73, 0x01, // Ÿs (U+0178 U+0073)
  0x01, 0x78, 0x00, 0xC0, 0x01, // ŸÀ (U+0178 U+00C0)
  0x01, 0x78, 0x00, 0xC1, 0x01, // ŸÁ (U+0178 U+00C1)
  0x01, 0x78, 0x00, 0xC2, 0x01, // ŸÂ (U+0178 U+00C2)
  0x01, 0x78, 0x00, 0xC3, 0x01, // ŸÃ (U+0178 U+00C3)
  0x01, 0x78, 0x00, 0xC4, 0x01, // ŸÄ (U+0178 U+00C4)
  0x01, 0x78, 0x00, 0xC5, 0x01, // ŸÅ (U+0178 U+00C5)
  0x01, 0x78, 0x00, 0xC6, 0x01, // ŸÆ (U+0178 U+00C6)
  0x01, 0x78, 0x00, 0xE0, 0x01, // Ÿà (U+0178 U+00E0)
  0x01, 0x78, 0x00, 0xE1, 0x01, // Ÿá (U+0178 U+00E1)
  0x01, 0x78, 0x00, 0xE2, 0x01, // Ÿâ (U+0178 U+00E2)
  0x01, 0x78, 0x00, 0xE3, 0x01, // Ÿã (U+0178 U+00E3)
  0x01, 0x78, 0x00, 0xE4, 0x01, // Ÿä (U+0178 U+00E4)
  0x01, 0x78, 0x00, 0xE5, 0x01, // Ÿå (U+0178 U+00E5)
  0x01, 0x78, 0x00, 0xE6, 0x01, // Ÿæ (U+0178 U+00E6)
  0x01, 0x78, 0x00, 0xE7, 0x01, // Ÿç (U+0178 U+00E7)
  0x01, 0x78, 0x00, 0xE8, 0x01, // Ÿè (U+0178 U+00E8)
  0x01, 0x78, 0x00, 0xE9, 0x01, // Ÿé (U+0178 U+00E9)
  0x01, 0x78, 0x00, 0xEA, 0x01, // Ÿê (U+0178 U+00EA)
  0x01, 0x78, 0x00, 0xEB, 0x01, // Ÿë (U+0178 U+00EB)
  0x01, 0x78, 0x00, 0xF0, 0x01, // Ÿð (U+0178 U+00F0)
  0x01, 0x78, 0x00, 0xF2, 0x01, // Ÿò (U+0178 U+00F2)
  0x01, 0x78, 0x00, 0xF3, 0x01, // Ÿó (U+0178 U+00F3)
  0x01, 0x78, 0x00, 0xF4, 0x01, // Ÿô (U+0178 U+00F4)
  0x01, 0x78, 0x00, 0xF5, 0x01, // Ÿõ (U+0178 U+00F5)
  0x01, 0x78, 0x00, 0xF6, 0x01, // Ÿö (U+0178 U+00F6)
  0x01, 0x78, 0x00, 0xF8, 0x01, // Ÿø (U+0178 U+00F8)
  0x01, 0x78, 0x01, 0x00, 0x01, // ŸĀ (U+0178 U+0100)
  0x01, 0x78, 0x01, 0x01, 0x01, // Ÿā (U+0178 U+0101)
  0x01, 0x78, 0x01, 0x02, 0x01, // ŸĂ (U+0178 U+0102)
  0x01, 0x78, 0x01, 0x03, 0x01, // Ÿă (U+0178 U+0103)
  0x01, 0x78, 0x01, 0x04, 0x01, // ŸĄ (U+0178 U+0104)
  0x01, 0x78, 0x01, 0x05, 0x01, // Ÿą (U+0178 U+0105)
  0x01, 0x78, 0x01, 0x07, 0x01, // Ÿć (U+0178 U+0107)
  0x01, 0x78, 0x01, 0x09, 0x01, // Ÿĉ (U+0178 U+0109)
  0x01, 0x78, 0x01, 0x0B, 0x01, // Ÿċ (U+0178 U+010B)
  0x01, 0x78, 0x01, 0x0D, 0x01, // Ÿč (U+0178 U+010D)
  0x01, 0x78, 0x01, 0x0F, 0x01, // Ÿď (U+0178 U+010F)
  0x01, 0x78, 0x01, 0x11, 0x01, // Ÿđ (U+0178 U+0111)
  0x01, 0x78, 0x01, 0x13, 0x01, // Ÿē (U+0178 U+0113)
  0x01, 0x78, 0x01, 0x15, 0x01, // Ÿĕ (U+0178 U+0115)
  0x01, 0x78, 0x01, 0x17, 0x01, // Ÿė (U+0178 U+0117)
  0x01, 0x78, 0x01, 0x19, 0x01, // Ÿę (U+0178 U+0119)
  0x01, 0x78, 0x01, 0x1B, 0x01, // Ÿě (U+0178 U+011B)
  0x01, 0x78, 0x01, 0x1D, 0x01, // Ÿĝ (U+0178 U+011D)
  0x01, 0x78, 0x01, 0x1F, 0x01, // Ÿğ (U+0178 U+011F)
  0x01, 0x78, 0x01, 0x21, 0x01, // Ÿġ (U+0178 U+0121)
  0x01, 0x78, 0x01, 0x23, 0x01, // Ÿģ (U+0178 U+0123)
  0x01, 0x78, 0x01, 0x4D, 0x01, // Ÿō (U+0178 U+014D)
  0x01, 0x78, 0x01, 0x4F, 0x01, // Ÿŏ (U+0178 U+014F)
  0x01, 0x78, 0x01, 0x51, 0x01, // Ÿő (U+0178 U+0151)
  0x01, 0x78, 0x01, 0x53, 0x01, // Ÿœ (U+0178 U+0153)
  0x01, 0x78, 0x01, 0x5B, 0x01, // Ÿś (U+0178 U+015B)
  0x01, 0x78, 0x01, 0x5D, 0x01, // Ÿŝ (U+0178 U+015D)
  0x01, 0x78, 0x01, 0x5F, 0x01, // Ÿş (U+0178 U+015F)
  0x01, 0x78, 0x01, 0x61, 0x01, // Ÿš (U+0178 U+0161)
  0x01, 0x78, 0x20, 0x1A, 0x01, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x01, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x01, // Ÿ… (U+0178 U+2026)
  0x20, 0x18, 0x00, 0x41, 0x01, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0xC0, 0x01, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x01, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x01, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x01, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x01, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x01, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xC6, 0x02, // ‘Æ (U+2018 U+00C6)
  0x20, 0x18, 0x01, 0x00, 0x01, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x02, 0x01, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x04, 0x01, // ‘Ą (U+2018 U+0104)
  0x20, 0x19, 0x00, 0x41, 0x01, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0x73, 0x01, // ’s (U+2019 U+0073)
  0x20, 0x19, 0x00, 0xC0, 0x01, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x01, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x01, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x01, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x01, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x01, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x01, 0x00, 0x01, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x02, 0x01, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x04, 0x01, // ’Ą (U+2019 U+0104)
  0x20, 0x19, 0x01, 0x5B, 0x01, // ’ś (U+2019 U+015B)
  0x20, 0x19, 0x01, 0x5D, 0x01, // ’ŝ (U+2019 U+015D)
  0x20, 0x19, 0x01, 0x5F, 0x01, // ’ş (U+2019 U+015F)
  0x20, 0x19, 0x01, 0x61, 0x01, // ’š (U+2019 U+0161)
  0x20, 0x1A, 0x00, 0x3F, 0x01, // ‚? (U+201A U+003F)
  0x20, 0x1A, 0x00, 0x54, 0x01, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x56, 0x01, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x01, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x01, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0x76, 0x01, // ‚v (U+201A U+0076)
  0x20, 0x1A, 0x00, 0x77, 0x01, // ‚w (U+201A U+0077)
  0x20, 0x1A, 0x00, 0x79, 0x01, // ‚y (U+201A U+0079)
  0x20, 0x1A, 0x00, 0xDD, 0x01, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x00, 0xFD, 0x01, // ‚ý (U+201A U+00FD)
  0x20, 0x1A, 0x00, 0xFF, 0x01, // ‚ÿ (U+201A U+00FF)
  0x20, 0x1A, 0x01, 0x62, 0x01, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x01, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x01, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1A, 0x01, 0x74, 0x01, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x75, 0x01, // ‚ŵ (U+201A U+0175)
  0x20, 0x1A, 0x01, 0x76, 0x01, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x77, 0x01, // ‚ŷ (U+201A U+0177)
  0x20, 0x1A, 0x01, 0x78, 0x01, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x01, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0xC0, 0x01, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x01, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x01, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x01, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x01, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x01, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xC6, 0x02, // “Æ (U+201C U+00C6)
  0x20, 0x1C, 0x01, 0x00, 0x01, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x02, 0x01, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x04, 0x01, // “Ą (U+201C U+0104)
  0x20, 0x1D, 0x00, 0x41, 0x01, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0x73, 0x01, // ”s (U+201D U+0073)
  0x20, 0x1D, 0x00, 0xC0, 0x01, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x01, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x01, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x01, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x01, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x01, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x01, 0x00, 0x01, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x02, 0x01, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x04, 0x01, // ”Ą (U+201D U+0104)
  0x20, 0x1D, 0x01, 0x5B, 0x01, // ”ś (U+201D U+015B)
  0x20, 0x1D, 0x01, 0x5D, 0x01, // ”ŝ (U+201D U+015D)
  0x20, 0x1D, 0x01, 0x5F, 0x01, // ”ş (U+201D U+015F)
  0x20, 0x1D, 0x01, 0x61, 0x01, // ”š (U+201D U+0161)
  0x20, 0x1E, 0x00, 0x3F, 0x01, // „? (U+201E U+003F)
  0x20, 0x1E, 0x00, 0x54, 0x01, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x56, 0x01, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x01, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x01, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0x76, 0x01, // „v (U+201E U+0076)
  0x20, 0x1E, 0x00, 0x77, 0x01, // „w (U+201E U+0077)
  0x20, 0x1E, 0x00, 0x79, 0x01, // „y (U+201E U+0079)
  0x20, 0x1E, 0x00, 0xDD, 0x01, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x00, 0xFD, 0x01, // „ý (U+201E U+00FD)
  0x20, 0x1E, 0x00, 0xFF, 0x01, // „ÿ (U+201E U+00FF)
  0x20, 0x1E, 0x01, 0x62, 0x01, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x01, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x01, // „Ŧ (U+201E U+0166)
  0x20, 0x1E, 0x01, 0x74, 0x01, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x75, 0x01, // „ŵ (U+201E U+0175)
  0x20, 0x1E, 0x01, 0x76, 0x01, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x77, 0x01, // „ŷ (U+201E U+0177)
  0x20, 0x1E, 0x01, 0x78, 0x01, // „Ÿ (U+201E U+0178)
  0x20, 0x26, 0x00, 0x3F, 0x01, // …? (U+2026 U+003F)
  0x20, 0x26, 0x00, 0x54, 0x01, // …T (U+2026 U+0054)
  0x20, 0x26, 0x00, 0x56, 0x01, // …V (U+2026 U+0056)
  0x20, 0x26, 0x00, 0x57, 0x01, // …W (U+2026 U+0057)
  0x20, 0x26, 0x00, 0x59, 0x01, // …Y (U+2026 U+0059)
  0x20, 0x26, 0x00, 0x76, 0x01, // …v (U+2026 U+0076)
  0x20, 0x26, 0x00, 0x77, 0x01, // …w (U+2026 U+0077)
  0x20, 0x26, 0x00, 0x79, 0x01, // …y (U+2026 U+0079)
  0x20, 0x26, 0x00, 0xDD, 0x01, // …Ý (U+2026 U+00DD)
  0x20, 0x26, 0x00, 0xFD, 0x01, // …ý (U+2026 U+00FD)
  0x20, 0x26, 0x00, 0xFF, 0x01, // …ÿ (U+2026 U+00FF)
  0x20, 0x26, 0x01, 0x62, 0x01, // …Ţ (U+2026 U+0162)
  0x20, 0x26, 0x01, 0x64, 0x01, // …Ť (U+2026 U+0164)
  0x20, 0x26, 0x01, 0x66, 0x01, // …Ŧ (U+2026 U+0166)
  0x20, 0x26, 0x01, 0x74, 0x01, // …Ŵ (U+2026 U+0174)
  0x20, 0x26, 0x01, 0x75, 0x01, // …ŵ (U+2026 U+0175)
  0x20, 0x26, 0x01, 0x76, 0x01, // …Ŷ (U+2026 U+0176)
  0x20, 0x26, 0x01, 0x77, 0x01, // …ŷ (U+2026 U+0177)
  0x20, 0x26, 0x01, 0x78, 0x01, // …Ÿ (U+2026 U+0178)
  0x20, 0x44, 0x00, 0x30, 0x02, // ⁄0 (U+2044 U+0030)
  0x20, 0x44, 0x00, 0x31, 0x02, // ⁄1 (U+2044 U+0031)
  0x20, 0x44, 0x00, 0x32, 0x02, // ⁄2 (U+2044 U+0032)
  0x20, 0x44, 0x00, 0x33, 0x02, // ⁄3 (U+2044 U+0033)
  0x20, 0x44, 0x00, 0x34, 0x02, // ⁄4 (U+2044 U+0034)
  0x20, 0x44, 0x00, 0x35, 0x02, // ⁄5 (U+2044 U+0035)
  0x20, 0x44, 0x00, 0x36, 0x02, // ⁄6 (U+2044 U+0036)
  0x20, 0x44, 0x00, 0x37, 0x02, // ⁄7 (U+2044 U+0037)
  0x20, 0x44, 0x00, 0x38, 0x02, // ⁄8 (U+2044 U+0038)
  0x20, 0x44, 0x00, 0x39, 0x02, // ⁄9 (U+2044 U+0039)
  
  // Glyph data
  // "!" (U+0021)
  0x89, 0x2A, 0xA9, 0x98, 0x87, 0x76, 0x65, 0x52, 0x82, 0x77, 0x99,
  // """ (U+0022)
  0x87, 0x3D, 0x0F, 0x22, 0xB0, 0xD2, 0x81, 0x90, 0xA1,
  // "#" (U+0023)
  0x28, 0x28, 0x22, 0x83, 0x89, 0x7B, 0x05, 0x50, 0x3B, 0xEB, 0xEB, 0x40, 0x19, 0x0A, 0x38, 0x23,
  0x70, 0xB3, 0x82, 0x65, 0x0B, 0x28, 0x48, 0xDC, 0xCD, 0xB2, 0x82, 0xA0, 0x55, 0x38, 0x2B, 0x08,
  0x22,
  // "$" (U+0024)
  0x30, 0x93, 0x89, 0x54, 0xBD, 0xC3, 0x0E, 0x29, 0x68, 0x0D, 0x59, 0x38, 0x23, 0xEC, 0x24, 0x8A,
  0x3C, 0xE5, 0x16, 0x09, 0x5C, 0x3E, 0x19, 0x7A, 0x07, 0xBE, 0x91, 0x30, 0x95, 0x04, 0x20,
  // "%" (U+0025)
  0x18, 0x19, 0xC9, 0x20, 0x20, 0x93, 0x86, 0x3C, 0x0C, 0x30, 0x92, 0x38, 0x56, 0xA0, 0x96, 0x1A,
  0x48, 0xA3, 0x6A, 0x09, 0x68, 0x4A, 0xB4, 0x03, 0xD0, 0xD4, 0xA7, 0x91, 0xE2, 0x89, 0x07, 0xC7,
  0x84, 0xA6, 0x0E, 0x24, 0x85, 0xB0, 0xA5, 0x0D, 0x23, 0x85, 0x75, 0x07, 0x81, 0xE4, 0x0B, 0x28,
  0x21, 0xBC, 0x61,
  // "&" (U+0026)
  0x18, 0x32, 0xCB, 0xD5, 0x48, 0x38, 0xA0, 0x5B, 0x48, 0x34, 0xA0, 0x66, 0x48, 0xA6, 0x1D, 0x92,
  0x0A, 0xD4, 0x1E, 0x6C, 0x90, 0xC2, 0x06, 0xB0, 0x1D, 0x7B, 0x20, 0x70, 0xA2, 0x81, 0x2E, 0x92,
  0x86, 0x4D, 0x10, 0x1B, 0xE3, 0x28, 0x66, 0xCB, 0xA1, 0x7F, 0x90,
  // "'" (U+0027)
  0x84, 0x3D, 0x2B, 0x09,
  // "(" (U+0028)
  0x28, 0x36, 0x70, 0x5A, 0x28, 0x2D, 0x30, 0x29, 0x20, 0x49, 0x20, 0x40, 0xE2, 0x03, 0x93, 0x90,
  0x22, 0x09, 0x07, 0x28, 0x11, 0xB3, 0x30, 0x40,
  // ")" (U+0029)
  0x05, 0x07, 0x30, 0x08, 0x28, 0x11, 0xF1, 0x20, 0xE0, 0x42, 0x0C, 0x06, 0x20, 0xC0, 0x62, 0x0D,
  0x05, 0x29, 0x89, 0x02, 0x05, 0xC0, 0x2B, 0x20, 0x33,
  // "*" (U+002A)
  0x20, 0x70, 0x62, 0x8A, 0x05, 0xB7, 0x6C, 0x30, 0x5E, 0xD4, 0x05, 0xB7, 0x6C, 0x32, 0x07, 0x06,
  0x20,
  // "+" (U+002B)
  0x30, 0xA5, 0x0A, 0x50, 0xA2, 0x84, 0x2B, 0xBE, 0xBA, 0x30, 0xA5, 0x0A, 0x20,
  // "," (U+002C)
  0x89, 0x13, 0xE2, 0x1C, 0x40, 0x90, 0x41, 0x10,
  // "-" (U+002D)
  0x82, 0x8B, 0xB4,
  // "." (U+002E)
  0x84, 0x1B, 0x12, 0xE2,
  // "/" (U+002F)
  0x20, 0x05, 0x20, 0x90, 0x12, 0x0A, 0x20, 0x10, 0x92, 0x00, 0x52, 0x08, 0x02, 0x20, 0xA3, 0x09,
  0x20, 0x40, 0x62, 0x08, 0x02, 0x20, 0xA3, 0x05, 0x30,
  // "0" (U+0030)
  0x18, 0x23, 0xCC, 0xA3, 0x86, 0xD4, 0x09, 0x90, 0x3E, 0x28, 0x33, 0xE0, 0x6D, 0x28, 0x32, 0xF1,
  0x6C, 0x28, 0x31, 0xF2, 0x6D, 0x28, 0x32, 0xF1, 0x3E, 0x20, 0x40, 0xE2, 0x83, 0xD4, 0x09, 0x82,
  0x82, 0x3C, 0xCA, 0x20,
  // "1" (U+0031)
  0x28, 0x75, 0xE2, 0x01, 0xB7, 0xF2, 0x28, 0x22, 0x1F, 0x23, 0x81, 0x1F, 0x23, 0x81, 0x1F, 0x23,
  0x81, 0x1F, 0x23, 0x81, 0x1F, 0x23, 0x81, 0x1F, 0x32, 0x83, 0x9D, 0xFE, 0x80,
  // "2" (U+0032)
  0x18, 0x93, 0x7D, 0xCA, 0x11, 0xF1, 0x0B, 0x80, 0x62, 0x00, 0x94, 0x0C, 0x03, 0x30, 0x50, 0x93,
  0x02, 0x0A, 0x38, 0x61, 0xA1, 0x01, 0x0A, 0x22, 0x0B, 0x04, 0xC0, 0xE0,
  // "3" (U+0033)
  0x18, 0x93, 0x7D, 0xCB, 0x11, 0xF1, 0x0A, 0x90, 0x62, 0x00, 0x93, 0x81, 0x2C, 0x22, 0x82, 0x9E,
  0x81, 0x40, 0xA0, 0xB4, 0x82, 0x4F, 0x3A, 0x28, 0x68, 0xB0, 0xAC, 0xCA, 0x10,
  // "4" (U+0034)
  0x30, 0x69, 0x50, 0xA9, 0x40, 0x80, 0x49, 0x38, 0x12, 0x81, 0x93, 0x81, 0xA1, 0x19, 0x28, 0x24,
  0x60, 0x19, 0x28, 0x5A, 0xBB, 0xCF, 0xB6, 0x38, 0x11, 0xF1, 0x38, 0x34, 0xDF, 0xD2,
  // "5" (U+0035)
  0x18, 0x5A, 0xBB, 0xC6, 0x09, 0x28, 0x21, 0x40, 0x95, 0x82, 0xDB, 0xC7, 0x28, 0x31, 0x01, 0xD7,
  0x40, 0x70, 0xC4, 0x82, 0x7B, 0x39, 0x28, 0x5B, 0x71, 0xBC, 0xC8, 0x10,
  // "6" (U+0036)
  0x28, 0x93, 0x9C, 0xC6, 0x08, 0x90, 0x39, 0x0E, 0x23, 0x89, 0x32, 0xF7, 0xBA, 0x23, 0xF3, 0x07,
  0xC3, 0x92, 0x8A, 0x22, 0xF0, 0xF1, 0x02, 0xF0, 0xA7, 0x06, 0xB0, 0x1B, 0xCB, 0x20,
  // "7" (U+0037)
  0x86, 0x3E, 0xBB, 0xCF, 0x44, 0x20, 0x50, 0xB4, 0x0A, 0x05, 0x40, 0xE4, 0x05, 0x0A, 0x40, 0xA0,
  0x54, 0x0E, 0x40, 0x50, 0xA4, 0x0B, 0x05, 0x20,
  // "8" (U+0038)
  0x18, 0x35, 0xCC, 0xB1, 0x29, 0x84, 0x20, 0x79, 0x01, 0x92, 0x05, 0x0B, 0x28, 0x3A, 0xA2, 0xA3,
  0x28, 0x21, 0xDE, 0xA2, 0x87, 0x1D, 0x20, 0xAB, 0x06, 0xB3, 0x98, 0x51, 0x4E, 0x10, 0x3E, 0x28,
  0x37, 0xCB, 0xB3, 0x10,
  // "9" (U+0039)
  0x18, 0x93, 0x6C, 0xC9, 0x02, 0xF1, 0x0A, 0x75, 0xD2, 0x89, 0x45, 0xC3, 0xF1, 0x07, 0xE0, 0x6C,
  0xA8, 0xE4, 0x05, 0x0C, 0x48, 0x93, 0x89, 0x07, 0x01, 0xD3, 0x09, 0xCC, 0x51,
  // ":" (U+003A)
  0x82, 0xD5, 0xA4, 0x68, 0x2A, 0x4D, 0x50,
  // ";" (U+003B)
  0x18, 0x3D, 0x50, 0xA4, 0x73, 0x89, 0x09, 0x20, 0xD7, 0x06, 0x43, 0x61,
  // "<" (U+003C)
  0x50, 0x14, 0x07, 0x0A, 0x28, 0x56, 0xB4, 0x01, 0xD6, 0x48, 0x14, 0xB6, 0x58, 0x16, 0xB5, 0x50,
  0x60,
  // "=" (U+003D)
  0x84, 0x2B, 0xBB, 0xBA, 0x75, 0x84, 0x2B, 0xBB, 0xBA,
  // ">" (U+003E)
  0x81, 0x2B, 0x55, 0x81, 0x7B, 0x44, 0x81, 0x1A, 0xA2, 0x86, 0x18, 0xA2, 0x07, 0xB3, 0x20, 0x20,
  0x44,
  // "?" (U+003F)
  0x89, 0x42, 0xCC, 0xC5, 0x08, 0x90, 0x1F, 0x10, 0x12, 0x90, 0x23, 0x06, 0x0C, 0x38, 0x18, 0xA1,
  0x30, 0xA5, 0x03, 0x48, 0x11, 0xB2, 0x38, 0x11, 0xE3, 0x20,
  // "@" (U+0040)
  0x38, 0x42, 0x9B, 0xBC, 0x74, 0x81, 0x5C, 0x33, 0x06, 0x09, 0x28, 0xF6, 0x2D, 0x15, 0xCB, 0xB0,
  0x92, 0x0A, 0x53, 0xD1, 0x2C, 0x05, 0x50, 0xE0, 0xA7, 0x05, 0x90, 0x55, 0x2C, 0x0C, 0x40, 0x87,
  0x08, 0x33, 0xB0, 0xA6, 0x0B, 0x71, 0xB0, 0x1D, 0x02, 0xBA, 0x1A, 0xA2, 0x20, 0xC0, 0x47, 0x28,
  0x13, 0xD5, 0x28, 0x11, 0x65, 0x48, 0x42, 0x9B, 0xBA, 0x43,
  // "A" (U+0041)
  0x30, 0x60, 0xD7, 0x81, 0xAD, 0x45, 0x82, 0x19, 0x89, 0x58, 0x27, 0x43, 0xE5, 0x0B, 0x20, 0xD0,
  0x53, 0x84, 0x3C, 0x99, 0xCA, 0x30, 0x80, 0x22, 0x81, 0x2F, 0x12, 0x0D, 0x48, 0x4E, 0x60, 0xDF,
  0xB2, 0x82, 0xAF, 0xE5,
  // "B" (U+0042)
  0x84, 0x6E, 0xEB, 0xC9, 0x30, 0x60, 0xC2, 0x0B, 0x08, 0x20, 0x60, 0xC2, 0x08, 0x0B, 0x20, 0x60,
  0xC2, 0x0C, 0x06, 0x28, 0x36, 0xEB, 0xEB, 0x30, 0x60, 0xC2, 0x07, 0x0B, 0x20, 0x60, 0xC2, 0x84,
  0x3F, 0x10, 0x6C, 0x28, 0x90, 0x6E, 0x06, 0xEE, 0xBB, 0xB3, 0x10,
  // "C" (U+0043)
  0x28, 0x66, 0xCC, 0xD6, 0x07, 0xC2, 0x83, 0x5D, 0x0E, 0x43, 0x82, 0x13, 0xF1, 0x40, 0x49, 0x58,
  0x13, 0xF2, 0x59, 0x04, 0x50, 0x80, 0xC3, 0x06, 0x28, 0x37, 0xCB, 0xB5,
  // "D" (U+0044)
  0x85, 0x6E, 0xEB, 0xDC, 0x42, 0x06, 0x0C, 0x28, 0x44, 0xF3, 0x06, 0xC3, 0x83, 0xAB, 0x06, 0xC3,
  0x83, 0x6E, 0x06, 0xC3, 0x83, 0x5F, 0x06, 0xC3, 0x83, 0x6E, 0x06, 0xC3, 0x83, 0xAA, 0x06, 0xC2,
  0x89, 0x05, 0xF3, 0x6E, 0xEB, 0xCB, 0x41,
  // "E" (U+0045)
  0x89, 0x04, 0xDE, 0x88, 0xC7, 0x06, 0xC2, 0x83, 0x38, 0x06, 0xC3, 0x82, 0x20, 0x6C, 0x58, 0x36,
  0xEB, 0xB8, 0x20, 0x60, 0xC5, 0x06, 0x0C, 0x50, 0x60, 0xC3, 0x86, 0xB4, 0xDE, 0x88, 0x9E,
  // "F" (U+0046)
  0x89, 0x06, 0xEE, 0xBB, 0xE7, 0x06, 0xC2, 0x83, 0x38, 0x06, 0xC3, 0x82, 0x20, 0x6C, 0x58, 0x36,
  0xEB, 0xB8, 0x20, 0x60, 0xC5, 0x06, 0x0C, 0x50, 0x60, 0xD4, 0x83, 0x6E, 0xFC, 0x22,
  // "G" (U+0047)
  0x28, 0x45, 0xBC, 0xDB, 0x22, 0x81, 0x6D, 0x12, 0x0B, 0x05, 0x20, 0xE0, 0x56, 0x81, 0x3F, 0x16,
  0x04, 0x93, 0x85, 0xAD, 0xD4, 0x3F, 0x13, 0x0C, 0x08, 0x20, 0xE0, 0x53, 0x0B, 0x07, 0x28, 0x17,
  0xD2, 0x20, 0xB0, 0x73, 0x84, 0x5C, 0xCB, 0xB3, 0x10,
  // "H" (U+0048)
  0x89, 0x26, 0xEF, 0xC0, 0x5E, 0xFD, 0x06, 0xD3, 0x05, 0x0E, 0x20, 0x60, 0xC3, 0x04, 0x0E, 0x20,
  0x60, 0xC3, 0x04, 0x0E, 0x28, 0x56, 0xEB, 0xBB, 0xCE, 0x20, 0x60, 0xC3, 0x04, 0x0E, 0x20, 0x60,
  0xC3, 0x04, 0x0E, 0x20, 0x60, 0xD3, 0x89, 0x25, 0xE0, 0x6E, 0xFC, 0x05, 0xEF, 0xD0,
  // "I" (U+0049)
  0x85, 0x6E, 0xFC, 0x06, 0xD2, 0x06, 0x0C, 0x20, 0x60, 0xC2, 0x06, 0x0C, 0x20, 0x60, 0xC2, 0x06,
  0x0C, 0x28, 0x56, 0xD0, 0x6E, 0xFC,
  // "J" (U+004A)
  0x18, 0x26, 0xEF, 0xC2, 0x06, 0x0D, 0x30, 0x60, 0xC3, 0x06, 0x0C, 0x30, 0x60, 0xC3, 0x06, 0x0C,
  0x30, 0x60, 0xC3, 0x06, 0x0C, 0x30, 0x60, 0xC3, 0x06, 0x0C, 0x38, 0x5A, 0x80, 0x1C, 0xA1, 0x10,
  // "K" (U+004B)
  0x86, 0x6E, 0xFC, 0x08, 0xFD, 0x20, 0x60, 0xD2, 0x04, 0x0B, 0x38, 0x36, 0xC0, 0x1A, 0x48, 0x36,
  0xC0, 0xB1, 0x48, 0x36, 0xCA, 0xF2, 0x48, 0x36, 0xE2, 0xAD, 0x48, 0x46, 0xC0, 0x1E, 0x93, 0x06,
  0x0D, 0x28, 0x65, 0xF6, 0x06, 0xEF, 0xC2, 0x81, 0x8E, 0x70,
  // "L" (U+004C)
  0x82, 0x4D, 0xF9, 0x40, 0x60, 0xC5, 0x06, 0x0C, 0x50, 0x60, 0xC5, 0x06, 0x0C, 0x50, 0x60, 0xC5,
  0x06, 0x0C, 0x38, 0x27, 0x06, 0xC3, 0x86, 0xB4, 0xDE, 0x88, 0xAE,
  // "M" (U+004D)
  0x82, 0x6E, 0xF5, 0x30, 0x1A, 0x83, 0x90, 0x6D, 0xB3, 0x81, 0x5D, 0xA2, 0x82, 0x68, 0xF1, 0x28,
  0x1B, 0x8A, 0x28, 0x76, 0x5D, 0x60, 0x1A, 0x7A, 0x28, 0x76, 0x57, 0xB0, 0x65, 0x7A, 0x28, 0x76,
  0x52, 0xF1, 0xB0, 0x7A, 0x28, 0x76, 0x50, 0xC9, 0x90, 0x7A, 0x28, 0xA3, 0x65, 0x06, 0xF4, 0x07,
  0xA0, 0x6E, 0xE2, 0x1E, 0x04, 0xEF, 0x90,
  // "N" (U+004E)
  0x89, 0x36, 0xEE, 0x10, 0x2D, 0xFA, 0x06, 0xF9, 0x20, 0x10, 0xB2, 0x82, 0x69, 0xF3, 0x20, 0xA2,
  0x82, 0x65, 0xAC, 0x20, 0xA2, 0x85, 0x65, 0x1E, 0x70, 0xA2, 0x85, 0x65, 0x06, 0xF2, 0xA2, 0x06,
  0x05, 0x28, 0x1B, 0xCA, 0x20, 0x60, 0x52, 0x86, 0x2F, 0xA0, 0x6E, 0xE5, 0x20, 0x70, 0xA1,
  // "O" (U+004F)
  0x28, 0x37, 0xCB, 0xC5, 0x30, 0x80, 0xC2, 0x81, 0x1D, 0x62, 0x90, 0x43, 0x84, 0x6D, 0x03, 0xF1,
  0x38, 0x23, 0xF1, 0x49, 0x48, 0x42, 0xF3, 0x3F, 0x13, 0x84, 0x3F, 0x10, 0xF4, 0x30, 0x60, 0xD2,
  0x08, 0x0C, 0x28, 0x11, 0xD6, 0x38, 0x37, 0xCC, 0xC5, 0x20,
  // "P" (U+0050)
  0x84, 0x6E, 0xEB, 0xC9, 0x20, 0x60, 0xC2, 0x83, 0xC7, 0x06, 0xC2, 0x83, 0x8B, 0x06, 0xC2, 0x89,
  0x59, 0xA0, 0x6C, 0x01, 0xE5, 0x06, 0xEB, 0xB5, 0x20, 0x60, 0xC5, 0x06, 0x0C, 0x48, 0x36, 0xEF,
  0xC2, 0x20,
  // "Q" (U+0051)
  0x28, 0x37, 0xCB, 0xB5, 0x30, 0x80, 0xB2, 0x81, 0x1C, 0x52, 0x90, 0x43, 0x84, 0x6D, 0x03, 0xF1,
  0x38, 0x23, 0xF1, 0x49, 0x48, 0x42, 0xF3, 0x4F, 0x13, 0x84, 0x2F, 0x21, 0xF3, 0x30, 0x50, 0xE2,
  0x0A, 0x09, 0x30, 0xB0, 0x73, 0x83, 0xAB, 0x8B, 0x85, 0x81, 0x1F, 0x57, 0x0B, 0x0A, 0x78, 0x21,
  0xBC, 0x21,
  // "R" (U+0052)
  0x85, 0x6E, 0xEB, 0xC9, 0x12, 0x06, 0x0C, 0x20, 0xB0, 0x82, 0x06, 0x0C, 0x20, 0x80, 0xB2, 0x06,
  0x0C, 0x20, 0xC0, 0x52, 0x83, 0x6E, 0xCF, 0x53, 0x83, 0x6C, 0x0D, 0x93, 0x84, 0x6C, 0x04, 0xF3,
  0x20, 0x60, 0xD2, 0x89, 0x1B, 0xC0, 0x6E, 0xFC, 0x02, 0xCC,
  // "S" (U+0053)
  0x18, 0x93, 0x5C, 0xCB, 0x22, 0xE1, 0x09, 0x73, 0xE2, 0x01, 0x20, 0xD0, 0x94, 0x82, 0x19, 0xE7,
  0x48, 0x32, 0xC9, 0x14, 0x28, 0x24, 0xD5, 0xC2, 0x86, 0x7A, 0x0A, 0xCB, 0xA1,
  // "T" (U+0054)
  0x87, 0xBD, 0xBF, 0xCC, 0xF1, 0xB2, 0x84, 0xE4, 0x0A, 0x12, 0x28, 0x2E, 0x40, 0x24, 0x0E, 0x04,
  0x60, 0xE0, 0x46, 0x0E, 0x04, 0x60, 0xE0, 0x46, 0x0E, 0x04, 0x48, 0x32, 0xDF, 0xE6, 0x20,
  // "U" (U+0055)
  0x0A, 0xA8, 0x78, 0x07, 0xFE, 0x50, 0xB8, 0x30, 0x70, 0x42, 0x0A, 0x08, 0x30, 0x70, 0x42, 0x0A,
  0x08, 0x30, 0x70, 0x42, 0x0A, 0x08, 0x30, 0x70, 0x42, 0x0A, 0x08, 0x30, 0x70, 0x42, 0x0A, 0x08,
  0x30, 0x70, 0x32, 0x06, 0x0D, 0x30, 0xB0, 0x13, 0x83, 0x8C, 0xBB, 0x42,
  // "V" (U+0056)
  0x89, 0x2D, 0xFE, 0x30, 0xAF, 0xD1, 0x0E, 0x53, 0x0C, 0x01, 0x20, 0x09, 0x20, 0x10, 0xA3, 0x04,
  0x0E, 0x20, 0x60, 0x54, 0x82, 0xE4, 0x0B, 0x58, 0x29, 0x91, 0xA5, 0x82, 0x3E, 0x64, 0x60, 0xE0,
  0xC7, 0x08, 0x09, 0x40,
  // "W" (U+0057)
  0x84, 0xBF, 0xE4, 0x01, 0x92, 0x85, 0x5E, 0xE5, 0x0D, 0x72, 0x81, 0x5F, 0x42, 0x07, 0x06, 0x20,
  0x80, 0xA2, 0x81, 0x9C, 0x92, 0x0A, 0x01, 0x20, 0x40, 0xE2, 0x81, 0xB5, 0xD2, 0x0B, 0x48, 0x7E,
  0x41, 0x91, 0xF1, 0x38, 0x48, 0x7A, 0x85, 0x50, 0xC5, 0x73, 0x48, 0x66, 0xC9, 0x10, 0x79, 0xB5,
  0x81, 0x1F, 0xA2, 0x81, 0x3D, 0xA6, 0x0C, 0x08, 0x30, 0xE0, 0x63,
  // "X" (U+0058)
  0x09, 0xA8, 0x65, 0x1D, 0xF6, 0x08, 0xE2, 0x08, 0x05, 0x38, 0x2D, 0x72, 0x94, 0x81, 0x4F, 0xA6,
  0x00, 0xB5, 0x82, 0x39, 0xE5, 0x48, 0x3A, 0x05, 0xE1, 0x20, 0xA0, 0x42, 0x89, 0x1C, 0xA0, 0xCF,
  0xC0, 0x5E, 0xFA,
  // "Y" (U+0059)
  0x89, 0x1D, 0xFD, 0x24, 0xEF, 0x61, 0xE6, 0x20, 0x60, 0x82, 0x06, 0x0D, 0x20, 0xA4, 0x82, 0xC6,
  0x55, 0x48, 0x13, 0xDA, 0x60, 0xD0, 0x66, 0x0C, 0x05, 0x60, 0xD0, 0x64, 0x83, 0x1C, 0xFE, 0x72,
  // "Z" (U+005A)
  0x87, 0x4E, 0x99, 0xAF, 0x55, 0x62, 0x82, 0x8C, 0x01, 0x28, 0x12, 0xF4, 0x40, 0xB0, 0xA4, 0x81,
  0x4F, 0x24, 0x0D, 0x08, 0x40, 0x60, 0xE3, 0x82, 0x21, 0xE6, 0x28, 0x72, 0x87, 0xF9, 0x99, 0xC8,
  // "[" (U+005B)
  0x8C, 0x2C, 0xEA, 0xC6, 0x0C, 0x50, 0xC5, 0x0C, 0x50, 0xC5, 0x0C, 0x50, 0xC5, 0x0C, 0x50, 0xC5,
  0x0C, 0x70, 0xAD, 0xA0,
  // "\" (U+005C)
  0x0A, 0x30, 0x90, 0x12, 0x06, 0x04, 0x20, 0x20, 0x83, 0x0A, 0x30, 0xA3, 0x06, 0x04, 0x20, 0x30,
  0x73, 0x0A, 0x30, 0xA3, 0x07, 0x03, 0x20, 0x02,
  // "]" (U+005D)
  0x8D, 0x66, 0xDF, 0x10, 0x1F, 0x10, 0x1F, 0x10, 0x1F, 0x10, 0x1F, 0x10, 0x1F, 0x10, 0x1F, 0x10,
  0x1F, 0x10, 0x1F, 0x10, 0x1F, 0x10, 0x2F, 0x16, 0xDD, 0x10,
  // "^" (U+005E)
  0x30, 0x44, 0x05, 0x0D, 0x48, 0x1B, 0x47, 0x28, 0x23, 0x80, 0xB2, 0x85, 0xA1, 0x06, 0x62, 0x93,
  0x0B,
  // "_" (U+005F)
  0x80, 0x1B, 0x06,
  // "`" (U+0060)
  0x84, 0x3E, 0x10, 0x48,
  // "a" (U+0061)
  0x18, 0x26, 0xDC, 0xB3, 0x83, 0xC3, 0x0C, 0x55, 0x0A, 0x07, 0x28, 0x95, 0x7B, 0xBE, 0x70, 0x4E,
  0x10, 0xA7, 0x05, 0xC2, 0x0D, 0x07, 0x28, 0x4B, 0xC9, 0x7E, 0x20,
  // "b" (U+0062)
  0x81, 0x9F, 0x65, 0x0B, 0x06, 0x50, 0xA0, 0x65, 0x83, 0xA7, 0xAC, 0x92, 0x0A, 0x0B, 0x28, 0x3C,
  0x50, 0xA7, 0x28, 0x38, 0x90, 0xA6, 0x28, 0x37, 0xA0, 0xA7, 0x28, 0x38, 0x90, 0xBC, 0x28, 0x6C,
  0x59, 0xF5, 0xBC, 0x91,
  // "c" (U+0063)
  0x18, 0x93, 0x4C, 0xCB, 0x10, 0xE3, 0x0C, 0x53, 0xE2, 0x82, 0x10, 0x5D, 0x40, 0x30, 0xE5, 0x89,
  0x1E, 0x40, 0x13, 0x03, 0xCB, 0xB1,
  // "d" (U+0064)
  0x38, 0x21, 0xDF, 0x15, 0x81, 0x1F, 0x16, 0x90, 0x12, 0x84, 0x5C, 0xB6, 0xF1, 0x28, 0x7E, 0x30,
  0x7F, 0x10, 0x3E, 0x28, 0x42, 0xF1, 0x04, 0xD2, 0x84, 0x1F, 0x10, 0x3E, 0x28, 0x12, 0xF1, 0x28,
  0x4E, 0x30, 0x6F, 0x12, 0x85, 0x5C, 0xB5, 0xED, 0x10,
  // "e" (U+0065)
  0x18, 0x23, 0xCC, 0xA2, 0x85, 0xE3, 0x0A, 0x73, 0xE2, 0x89, 0x06, 0xB4, 0xEB, 0xBC, 0xB3, 0xD5,
  0x0D, 0x03, 0x28, 0x53, 0x03, 0xBB, 0xB2,
  // "f" (U+0066)
  0x28, 0x93, 0xAC, 0xD1, 0x05, 0xA0, 0x81, 0x08, 0x93, 0x83, 0x7D, 0xDB, 0x32, 0x08, 0x09, 0x40,
  0x80, 0x94, 0x08, 0x09, 0x40, 0x80, 0x94, 0x08, 0x09, 0x30, 0x8A, 0x0C, 0x20,
  // "g" (U+0067)
  0x18, 0x95, 0x5C, 0xC9, 0xC2, 0x0E, 0x11, 0xE1, 0x02, 0xE2, 0x0E, 0x03, 0x28, 0x3E, 0x21, 0xE1,
  0x28, 0x26, 0xDB, 0x53, 0x0B, 0x68, 0x69, 0xCB, 0xA3, 0x06, 0x72, 0x83, 0x3D, 0x0A, 0x62, 0x87,
  0x4C, 0x02, 0xBB, 0xBA, 0x21,
  // "h" (U+0068)
  0x81, 0x9F, 0x66, 0x0B, 0x06, 0x60, 0xA0, 0x66, 0x83, 0xA8, 0xAD, 0x83, 0x00, 0xA2, 0x0E, 0x02,
  0x20, 0xA0, 0x72, 0x0C, 0x04, 0x20, 0xA0, 0x62, 0x0C, 0x05, 0x20, 0xA0, 0x62, 0x0C, 0x05, 0x20,
  0xB0, 0x72, 0x89, 0x1C, 0x50, 0x9F, 0xE5, 0x0C, 0xE3,
  // "i" (U+0069)
  0x10, 0x90, 0x72, 0x07, 0x05, 0x58, 0x17, 0xF8, 0x20, 0x90, 0x82, 0x09, 0x08, 0x20, 0x90, 0x82,
  0x09, 0x08, 0x28, 0x29, 0x90, 0x8A, 0x08,
  // "j" (U+006A)
  0x20, 0xB0, 0x52, 0x09, 0x04, 0x58, 0x19, 0xF6, 0x20, 0xB0, 0x62, 0x0A, 0x06, 0x20, 0xA0, 0x62,
  0x0A, 0x06, 0x20, 0xA0, 0x62, 0x0A, 0x06, 0x20, 0xB0, 0x52, 0x83, 0xE3, 0x1D, 0x81,
  // "k" (U+006B)
  0x81, 0x9F, 0x65, 0x0B, 0x06, 0x50, 0xA0, 0x65, 0x89, 0x2A, 0x60, 0xDF, 0x70, 0xA6, 0x0A, 0x52,
  0x82, 0xA6, 0x86, 0x38, 0x2A, 0xCE, 0x73, 0x83, 0xA7, 0x3F, 0x22, 0x89, 0x3B, 0x70, 0x9C, 0x09,
  0xFE, 0x51, 0xCD,
  // "l" (U+006C)
  0x81, 0xAF, 0x62, 0x0B, 0x06, 0x20, 0xA0, 0x62, 0x0A, 0x06, 0x20, 0xA0, 0x62, 0x0A, 0x06, 0x20,
  0xA0, 0x62, 0x0A, 0x06, 0x28, 0x5B, 0x70, 0xAF, 0xE6,
  // "m" (U+006D)
  0x89, 0x06, 0xF7, 0x9C, 0x94, 0xAD, 0x52, 0x09, 0x0C, 0x28, 0x3E, 0x80, 0x4E, 0x20, 0x09, 0x28,
  0x2C, 0x50, 0x19, 0x20, 0x90, 0x82, 0x82, 0xC5, 0x01, 0x92, 0x09, 0x08, 0x28, 0x2C, 0x50, 0x19,
  0x20, 0x09, 0x28, 0x5C, 0x50, 0x1F, 0x18, 0xA8, 0x67, 0x0C, 0xE3, 0x1F, 0xD0,
  // "n" (U+006E)
  0x84, 0x7F, 0x79, 0xCA, 0x30, 0x90, 0xC2, 0x0D, 0x04, 0x20, 0x09, 0x20, 0xA0, 0x62, 0x09, 0x08,
  0x20, 0xA0, 0x62, 0x09, 0x08, 0x20, 0xA0, 0x62, 0x00, 0x92, 0x82, 0xA7, 0x08, 0xA8, 0x36, 0x0A,
  0xE4,
  // "o" (U+006F)
  0x18, 0x33, 0xBB, 0xB2, 0x28, 0x6E, 0x30, 0x5C, 0x03, 0xE3, 0x98, 0x12, 0x4D, 0x38, 0x2E, 0x33,
  0xE3, 0x98, 0x52, 0x0D, 0x30, 0x4D, 0x28, 0x33, 0xBB, 0xB3, 0x10,
  // "p" (U+0070)
  0x84, 0xAF, 0x6A, 0xC9, 0x20, 0x0B, 0x28, 0x3C, 0x50, 0xA7, 0x28, 0x38, 0x90, 0xA6, 0x28, 0x37,
  0xA0, 0xA7, 0x28, 0x38, 0x90, 0xAC, 0x28, 0x6C, 0x50, 0xA8, 0xBC, 0x92, 0x0A, 0x06, 0x50, 0xB0,
  0x74, 0x82, 0x9F, 0xE5, 0x30,
  // "q" (U+0071)
  0x18, 0x97, 0x5C, 0xB6, 0xDD, 0x10, 0xE3, 0x07, 0xF1, 0x03, 0xE2, 0x84, 0x2F, 0x10, 0x4D, 0x28,
  0x41, 0xF1, 0x03, 0xE2, 0x81, 0x2F, 0x12, 0x84, 0xE3, 0x06, 0xF1, 0x28, 0x45, 0xCB, 0x6F, 0x15,
  0x81, 0x1F, 0x15, 0x81, 0x1F, 0x14, 0x83, 0x5D, 0xFD, 0x10,
  // "r" (U+0072)
  0x89, 0x57, 0xF6, 0xAE, 0x40, 0x9D, 0x07, 0x30, 0x99, 0x40, 0x90, 0x84, 0x09, 0x08, 0x40, 0x09,
  0x30, 0x7A, 0x0A, 0x20,
  // "s" (U+0073)
  0x18, 0x92, 0xAB, 0xD4, 0x4A, 0x05, 0x62, 0xD3, 0x38, 0xA1, 0x3C, 0xB2, 0x01, 0x06, 0xB6, 0x70,
  0x3C, 0x2C, 0xBC, 0x30,
  // "t" (U+0074)
  0x18, 0x94, 0x22, 0x01, 0xB4, 0x08, 0xFC, 0x90, 0xD4, 0x20, 0xD0, 0x42, 0x0D, 0x04, 0x20, 0xD0,
  0x42, 0x0C, 0x05, 0x28, 0x16, 0xDA,
  // "u" (U+0075)
  0x85, 0x9F, 0x60, 0xAF, 0x52, 0x0B, 0x06, 0x20, 0xD0, 0x52, 0x0A, 0x06, 0x20, 0xC0, 0x52, 0x0A,
  0x06, 0x20, 0xC0, 0x52, 0x0A, 0x06, 0x20, 0xC0, 0x52, 0x84, 0x89, 0x02, 0xF5, 0x28, 0x52, 0xCB,
  0x9A, 0xE4,
  // "v" (U+0076)
  0x89, 0x0D, 0xFD, 0x08, 0xFC, 0x1F, 0x32, 0x0C, 0x28, 0x3A, 0x70, 0x18, 0x28, 0x35, 0xC0, 0x63,
  0x38, 0x1E, 0x2A, 0x48, 0x1A, 0x97, 0x48, 0x14, 0xF2, 0x20,
  // "w" (U+0077)
  0x8A, 0x3D, 0xFC, 0x03, 0xD0, 0x2E, 0xE3, 0x1F, 0x20, 0x8F, 0x20, 0x65, 0x28, 0x7C, 0x50, 0xA9,
  0x70, 0x91, 0x28, 0x67, 0x92, 0x85, 0xC0, 0xA3, 0x86, 0x3D, 0x63, 0x0E, 0x47, 0x40, 0xE0, 0xA2,
  0x81, 0xAC, 0x24, 0x0A, 0x09, 0x20, 0x60, 0xD3,
  // "x" (U+0078)
  0x89, 0x39, 0xFE, 0x5E, 0xF6, 0x07, 0xC0, 0x84, 0x38, 0x1B, 0x97, 0x48, 0x13, 0xF3, 0x48, 0x29,
  0x5D, 0x12, 0x89, 0x38, 0x40, 0x9A, 0x0C, 0xFC, 0x2E, 0xFB,
  // "y" (U+0079)
  0x89, 0x0D, 0xFC, 0x09, 0xFA, 0x1E, 0x32, 0x0D, 0x28, 0x39, 0x80, 0x38, 0x28, 0x33, 0xE0, 0x83,
  0x38, 0x1C, 0x4B, 0x48, 0x16, 0xC8, 0x50, 0xE0, 0x34, 0x01, 0x0C, 0x50, 0xB0, 0x63, 0x81, 0x6D,
  0x84,
  // "z" (U+007A)
  0x89, 0x13, 0xEB, 0xBF, 0x54, 0x40, 0x7C, 0x38, 0x11, 0xE3, 0x30, 0xA0, 0x93, 0x04, 0x0E, 0x48,
  0x91, 0xD5, 0x03, 0x66, 0xFB, 0xBD, 0x60,
  // "{" (U+007B)
  0x28, 0x17, 0xD6, 0x20, 0xE0, 0x43, 0x90, 0x23, 0x90, 0x22, 0x85, 0x3F, 0x10, 0x5F, 0x63, 0x03,
  0x0E, 0x49, 0x02, 0x39, 0x02, 0x39, 0x03, 0x30, 0xD0, 0x53, 0x81, 0x4C, 0x60,
  // "|" (U+007C)
  0x80, 0x91, 0xA0,
  // "}" (U+007D)
  0x81, 0x4D, 0x93, 0x81, 0x2F, 0x12, 0x81, 0x1F, 0x12, 0x81, 0x1F, 0x13, 0x0E, 0x05, 0x38, 0x15,
  0xE6, 0x20, 0xD0, 0x53, 0x90, 0x22, 0x81, 0x1F, 0x12, 0x81, 0x1F, 0x12, 0x03, 0x92, 0x81, 0x4C,
  0x62,
  // "~" (U+007E)
  0x18, 0x91, 0xAB, 0x50, 0xA3, 0x60, 0x8B, 0x60,
  // "¡" (U+00A1)
  0x82, 0x99, 0x77, 0x28, 0x92, 0x55, 0x66, 0x77, 0x88, 0x99, 0xAA,
  // "¢" (U+00A2)
  0x20, 0x92, 0x89, 0x32, 0xCD, 0xC8, 0xB6, 0x93, 0xBF, 0x29, 0x29, 0x01, 0x09, 0x28, 0x1E, 0x39,
  0x28, 0x90, 0x9A, 0x90, 0x60, 0x8E, 0xB5, 0x20, 0x92,
  // "£" (U+00A3)
  0x18, 0x31, 0xBB, 0xD5, 0x28, 0x39, 0x70, 0x4B, 0x20, 0xB0, 0x55, 0x00, 0x84, 0x83, 0x4C, 0xEB,
  0x94, 0x0E, 0x01, 0x50, 0xD0, 0x14, 0x81, 0x3A, 0x22, 0x86, 0x11, 0xA9, 0xBD, 0xA2,
  // "¤" (U+00A4)
  0x02, 0x38, 0x92, 0x2C, 0xBC, 0xB9, 0x92, 0x07, 0x5A, 0x28, 0x92, 0x28, 0x93, 0x08, 0x5B, 0x9B,
  0x99, 0x40, 0x10,
  // "¥" (U+00A5)
  0x89, 0x3C, 0xFD, 0x0A, 0xF8, 0x0D, 0x50, 0x2A, 0x28, 0x35, 0xC0, 0x81, 0x38, 0x1C, 0x67, 0x38,
  0x3A, 0xCF, 0xC7, 0x30, 0x29, 0x48, 0x3A, 0xCF, 0xB7, 0x30, 0x39, 0x48, 0x35, 0xDF, 0xD2, 0x10,
  // "¦" (U+00A6)
  0x80, 0x1A, 0x38, 0x01, 0xA0,
  // "§" (U+00A7)
  0x8C, 0x12, 0xBC, 0xB1, 0xA3, 0x0A, 0x4B, 0x50, 0x10, 0x8E, 0x91, 0x0B, 0x2A, 0xE4, 0xD6, 0x05,
  0xD3, 0xDC, 0x5A, 0x28, 0x27, 0xE5, 0x42, 0x89, 0x14, 0x8B, 0x40, 0x65, 0x3B, 0xB8, 0x10,
  // "¨" (U+00A8)
  0x87, 0x2B, 0x0D, 0x10, 0x10, 0x11,
  // "©" (U+00A9)
  0x28, 0x41, 0x8B, 0xB9, 0x23, 0x81, 0x2B, 0x32, 0x81, 0x2B, 0x32, 0x8A, 0x5B, 0x12, 0x99, 0x70,
  0xB0, 0x29, 0x0D, 0x10, 0x80, 0x64, 0x46, 0x4B, 0x48, 0x44, 0x64, 0x64, 0xB4, 0x8A, 0x34, 0x62,
  0x90, 0xD1, 0x04, 0x07, 0x40, 0xB1, 0x39, 0x96, 0x0B, 0x28, 0x12, 0xB3, 0x28, 0x12, 0xB3, 0x38,
  0x41, 0x8B, 0xB9, 0x22,
  // "ª" (U+00AA)
  0x8A, 0x21, 0xC8, 0x80, 0x1A, 0x7D, 0x08, 0x83, 0xD0, 0x4C, 0x7D, 0x20,
  // "«" (U+00AB)
  0x28, 0x95, 0xA0, 0x92, 0x09, 0x76, 0xA0, 0x2F, 0x2E, 0x42, 0x82, 0x97, 0x6A, 0x38, 0x2A, 0x09,
  0x20,
  // "¬" (U+00AC)
  0x84, 0x2B, 0xBB, 0xBC, 0x50, 0xB5, 0x0B, 0x50, 0x40,
  // "®" (U+00AE)
  0x28, 0x41, 0x8B, 0xB9, 0x23, 0x81, 0x2B, 0x32, 0x81, 0x2B, 0x32, 0x8F, 0x0B, 0x39, 0x87, 0x30,
  0xB0, 0x29, 0x07, 0x60, 0xD0, 0x64, 0x46, 0x07, 0x60, 0xD0, 0x46, 0x46, 0x07, 0xBD, 0x30, 0x46,
  0x29, 0x07, 0x67, 0x90, 0x74, 0x0B, 0x39, 0x91, 0x95, 0xB2, 0x81, 0x2B, 0x32, 0x81, 0x2B, 0x33,
  0x84, 0x18, 0xBB, 0x92, 0x20,
  // "¯" (U+00AF)
  0x80, 0x1B, 0x06,
  // "°" (U+00B0)
  0x18, 0xA0, 0x9B, 0x60, 0x58, 0x0B, 0x15, 0x80, 0xA1, 0x09, 0xB7, 0x10,
  // "±" (U+00B1)
  0x30, 0xA5, 0x0A, 0x50, 0xA2, 0x84, 0x2B, 0xBE, 0xBA, 0x30, 0xA5, 0x0A, 0x71, 0x84, 0x2B, 0xBB,
  0xBA,
  // "²" (U+00B2)
  0x86, 0x19, 0x85, 0x04, 0x71, 0x93, 0x02, 0x0C, 0x30, 0x90, 0x32, 0x87, 0x83, 0x21, 0x5C, 0xBD,
  0x20,
  // "³" (U+00B3)
  0x87, 0x19, 0x94, 0x05, 0x82, 0xE3, 0x03, 0x0C, 0x28, 0x93, 0x4C, 0x60, 0x31, 0x0E, 0x23, 0x99,
  0x61,
  // "´" (U+00B4)
  0x18, 0x2B, 0x74, 0x81,
  // "µ" (U+00B5)
  0x0C, 0x04, 0x29, 0x81, 0x1C, 0x42, 0x98, 0x11, 0xC4, 0x29, 0x81, 0x1C, 0x42, 0x98, 0xA2, 0x1D,
  0x40, 0x1F, 0x1D, 0x70, 0x6F, 0x1C, 0xBB, 0x79, 0xAD, 0x50, 0xE0, 0x54, 0x0A, 0x09, 0x40,
  // "¶" (U+00B6)
  0x10, 0xBA, 0x82, 0xBF, 0xB6, 0xA8, 0x3E, 0x0B, 0x07, 0xA8, 0x3E, 0x0B, 0x05, 0xA8, 0x1E, 0x0B,
  0x28, 0x3D, 0xFE, 0x0B, 0x38, 0x22, 0xB0, 0xB4, 0x81, 0xB0, 0xB4, 0x81, 0xB0, 0xB4, 0x81, 0xB0,
  0xB4, 0x81, 0xB0, 0xB4, 0x81, 0xC0, 0xC3, 0x83, 0xCC, 0x0C, 0xB0,
  // "·" (U+00B7)
  0x84, 0x1B, 0x12, 0xE2,
  // "¸" (U+00B8)
  0x10, 0x06, 0x38, 0x3D, 0x23, 0xBA, 0x10,
  // "¹" (U+00B9)
  0x28, 0x23, 0x02, 0x79, 0x20, 0x19, 0x20, 0x19, 0x28, 0x51, 0xF0, 0x17, 0xA6,
  // "º" (U+00BA)
  0x8A, 0x11, 0xB8, 0xA0, 0x78, 0x0B, 0x47, 0x80, 0xB4, 0x1B, 0x8A, 0x10,
  // "»" (U+00BB)
  0x8A, 0x6A, 0x0A, 0x10, 0x78, 0x5B, 0x02, 0xF2, 0xE5, 0x79, 0x4B, 0x0A, 0x0A, 0x11,
  // "¼" (U+00BC)
  0x20, 0x33, 0x02, 0x0A, 0x20, 0x20, 0x79, 0x30, 0x90, 0x33, 0x01, 0x92, 0x01, 0x0A, 0x40, 0x19,
  0x20, 0x80, 0x34, 0x8A, 0x01, 0xF0, 0x1B, 0x03, 0x10, 0x17, 0xA6, 0x74, 0x3D, 0x65, 0x83, 0xB2,
  0x7A, 0x64, 0x85, 0x65, 0x88, 0xDA, 0x43, 0x0B, 0x30, 0xA0, 0x67, 0x81, 0x3A, 0x81,
  // "½" (U+00BD)
  0x20, 0x32, 0x02, 0x0A, 0x30, 0x20, 0x79, 0x20, 0x90, 0x34, 0x83, 0x1F, 0x01, 0xA5, 0x86, 0x1F,
  0x08, 0x49, 0x85, 0x28, 0x94, 0x1F, 0x1B, 0x47, 0x1F, 0x01, 0x7A, 0xE4, 0x20, 0x20, 0xC4, 0x0B,
  0x30, 0x90, 0x33, 0x06, 0x05, 0x28, 0x28, 0x32, 0x12, 0x0B, 0x28, 0x35, 0xCB, 0xD2,
  // "¾" (U+00BE)
  0x82, 0x19, 0x94, 0x20, 0x20, 0xA2, 0x82, 0x58, 0x2E, 0x20, 0x90, 0x34, 0x83, 0x3C, 0x01, 0xA4,
  0x84, 0x4C, 0x60, 0x83, 0x38, 0xA1, 0x31, 0x0E, 0x3B, 0x03, 0x10, 0x39, 0x96, 0x74, 0x3D, 0x65,
  0x83, 0xB2, 0x7A, 0x64, 0x85, 0x65, 0x88, 0xDA, 0x43, 0x0B, 0x30, 0xA0, 0x67, 0x81, 0x3A, 0x81,
  // "¿" (U+00BF)
  0x28, 0x13, 0xD1, 0x38, 0x12, 0xB1, 0x40, 0x35, 0x0A, 0x38, 0x11, 0xA8, 0x30, 0xC0, 0x63, 0x02,
  0x92, 0x89, 0x41, 0x01, 0xF1, 0x09, 0x80, 0x5B, 0xCC, 0x20,
  // "À" (U+00C0)
  0x28, 0x13, 0xE1, 0x70, 0x40, 0x87, 0x72, 0x06, 0x0D, 0x78, 0x1A, 0xD4, 0x58, 0x21, 0x98, 0x95,
  0x82, 0x74, 0x3E, 0x50, 0xB2, 0x0D, 0x05, 0x38, 0x43, 0xC9, 0x9C, 0xA3, 0x08, 0x02, 0x28, 0x12,
  0xF1, 0x20, 0xD4, 0x84, 0xE6, 0x0D, 0xFB, 0x28, 0x2A, 0xFE, 0x50,
  // "Á" (U+00C1)
  0x40, 0xB0, 0x76, 0x04, 0x08, 0x77, 0x20, 0x60, 0xD7, 0x81, 0xAD, 0x45, 0x82, 0x19, 0x89, 0x58,
  0x27, 0x43, 0xE5, 0x0B, 0x20, 0xD0, 0x53, 0x84, 0x3C, 0x99, 0xCA, 0x30, 0x80, 0x22, 0x81, 0x2F,
  0x12, 0x0D, 0x48, 0x4E, 0x60, 0xDF, 0xB2, 0x82, 0xAF, 0xE5,
  // "Â" (U+00C2)
  0x38, 0x19, 0xE2, 0x58, 0x24, 0x82, 0x97, 0x71, 0x06, 0x0D, 0x78, 0x1A, 0xD4, 0x58, 0x21, 0x98,
  0x95, 0x82, 0x74, 0x3E, 0x50, 0xB2, 0x0D, 0x05, 0x38, 0x43, 0xC9, 0x9C, 0xA3, 0x08, 0x02, 0x28,
  0x12, 0xF1, 0x20, 0xD4, 0x84, 0xE6, 0x0D, 0xFB, 0x28, 0x2A, 0xFE, 0x50,
  // "Ã" (U+00C3)
  0x28, 0x31, 0xBA, 0x36, 0x48, 0x35, 0x16, 0xC4, 0x77, 0x06, 0x0D, 0x78, 0x1A, 0xD4, 0x58, 0x21,
  0x98, 0x95, 0x82, 0x74, 0x3E, 0x50, 0xB2, 0x0D, 0x05, 0x38, 0x43, 0xC9, 0x9C, 0xA3, 0x08, 0x02,
  0x28, 0x12, 0xF1, 0x20, 0xD4, 0x84, 0xE6, 0x0D, 0xFB, 0x28, 0x2A, 0xFE, 0x50,
  // "Ä" (U+00C4)
  0x28, 0x32, 0xB0, 0xD1, 0x58, 0x11, 0x01, 0x60, 0x60, 0xD7, 0x81, 0xAD, 0x45, 0x82, 0x19, 0x89,
  0x58, 0x27, 0x43, 0xE5, 0x0B, 0x20, 0xD0, 0x53, 0x84, 0x3C, 0x99, 0xCA, 0x30, 0x80, 0x22, 0x81,
  0x2F, 0x12, 0x0D, 0x48, 0x4E, 0x60, 0xDF, 0xB2, 0x82, 0xAF, 0xE5,
  // "Å" (U+00C5)
  0x38, 0x17, 0xA2, 0x58, 0x21, 0x80, 0x95, 0x82, 0x19, 0x28, 0x68, 0x18, 0xF1, 0x68, 0x19, 0xD3,
  0x58, 0x21, 0x98, 0x95, 0x82, 0x74, 0x3E, 0x50, 0xB2, 0x0D, 0x05, 0x38, 0x43, 0xC9, 0x9C, 0xA3,
  0x08, 0x02, 0x28, 0x12, 0xF1, 0x20, 0xD4, 0x84, 0xE6, 0x0D, 0xFB, 0x28, 0x2A, 0xFE, 0x50,
  // "Æ" (U+00C6)
  0x38, 0x61, 0xBD, 0xD8, 0x8C, 0x74, 0x81, 0x97, 0xB2, 0x04, 0x07, 0x38, 0x23, 0x57, 0xB3, 0x02,
  0x38, 0x29, 0x07, 0xB6, 0x86, 0x36, 0x07, 0xEB, 0xB7, 0x30, 0xFB, 0x0D, 0x0B, 0x50, 0x30, 0x72,
  0x07, 0x0B, 0x38, 0x12, 0x0B, 0x30, 0x70, 0xB3, 0x89, 0x2B, 0xAF, 0x80, 0x5D, 0xD8, 0x8A, 0xD0,
  // "Ç" (U+00C7)
  0x28, 0x66, 0xCC, 0xD6, 0x07, 0xC2, 0x83, 0x5D, 0x0E, 0x43, 0x82, 0x13, 0xF1, 0x40, 0x49, 0x58,
  0x13, 0xF2, 0x59, 0x04, 0x50, 0x80, 0xC3, 0x06, 0x28, 0x37, 0xCB, 0xB5, 0x30, 0x06, 0x60, 0xC0,
  0x33, 0x81, 0x2B, 0xA2,
  // "È" (U+00C8)
  0x28, 0x13, 0xE1, 0x50, 0x40, 0x87, 0x28, 0x90, 0x4D, 0xE8, 0x8C, 0x70, 0x6C, 0x28, 0x33, 0x80,
  0x6C, 0x38, 0x22, 0x06, 0xC5, 0x83, 0x6E, 0xBB, 0x82, 0x06, 0x0C, 0x50, 0x60, 0xC5, 0x06, 0x0C,
  0x38, 0x6B, 0x4D, 0xE8, 0x89, 0xE0,
  // "É" (U+00C9)
  0x40, 0xB0, 0x74, 0x04, 0x08, 0x72, 0x89, 0x04, 0xDE, 0x88, 0xC7, 0x06, 0xC2, 0x83, 0x38, 0x06,
  0xC3, 0x82, 0x20, 0x6C, 0x58, 0x36, 0xEB, 0xB8, 0x20, 0x60, 0xC5, 0x06, 0x0C, 0x50, 0x60, 0xC3,
  0x86, 0xB4, 0xDE, 0x88, 0x9E,
  // "Ê" (U+00CA)
  0x38, 0x19, 0xE2, 0x38, 0x24, 0x82, 0x97, 0x18, 0x90, 0x4D, 0xE8, 0x8C, 0x70, 0x6C, 0x28, 0x33,
  0x80, 0x6C, 0x38, 0x22, 0x06, 0xC5, 0x83, 0x6E, 0xBB, 0x82, 0x06, 0x0C, 0x50, 0x60, 0xC5, 0x06,
  0x0C, 0x38, 0x6B, 0x4D, 0xE8, 0x89, 0xE0,
  // "Ë" (U+00CB)
  0x18, 0x32, 0xB0, 0xD1, 0x38, 0x11, 0x01, 0x28, 0x90, 0x4D, 0xE8, 0x8C, 0x70, 0x6C, 0x28, 0x33,
  0x80, 0x6C, 0x38, 0x22, 0x06, 0xC5, 0x83, 0x6E, 0xBB, 0x82, 0x06, 0x0C, 0x50, 0x60, 0xC5, 0x06,
  0x0C, 0x38, 0x6B, 0x4D, 0xE8, 0x89, 0xE0,
  // "Ì" (U+00CC)
  0x81, 0x3E, 0x12, 0x04, 0x08, 0x58, 0x56, 0xEF, 0xC0, 0x6D, 0x20, 0x60, 0xC2, 0x06, 0x0C, 0x20,
  0x60, 0xC2, 0x06, 0x0C, 0x20, 0x60, 0xC2, 0x85, 0x6D, 0x06, 0xEF, 0xC0,
  // "Í" (U+00CD)
  0x28, 0x3B, 0x70, 0x48, 0x58, 0x56, 0xEF, 0xC0, 0x6D, 0x20, 0x60, 0xC2, 0x06, 0x0C, 0x20, 0x60,
  0xC2, 0x06, 0x0C, 0x20, 0x60, 0xC2, 0x85, 0x6D, 0x06, 0xEF, 0xC0,
  // "Î" (U+00CE)
  0x18, 0x59, 0xE2, 0x48, 0x29, 0x48, 0x56, 0xEF, 0xC0, 0x6D, 0x20, 0x60, 0xC2, 0x06, 0x0C, 0x20,
  0x60, 0xC2, 0x06, 0x0C, 0x20, 0x60, 0xC2, 0x85, 0x6D, 0x06, 0xEF, 0xC0,
  // "Ï" (U+00CF)
  0x89, 0x42, 0xB0, 0xD1, 0x01, 0x01, 0x06, 0xEF, 0xC2, 0x06, 0x0D, 0x30, 0x60, 0xC3, 0x06, 0x0C,
  0x30, 0x60, 0xC3, 0x06, 0x0C, 0x30, 0x60, 0xC3, 0x06, 0x0D, 0x28, 0x26, 0xEF, 0xC1,
  // "Ð" (U+00D0)
  0x85, 0x6E, 0xEB, 0xDC, 0x42, 0x06, 0x0C, 0x28, 0x44, 0xF3, 0x06, 0xC3, 0x83, 0xAB, 0x06, 0xC3,
  0x89, 0x36, 0xE6, 0xDE, 0xB9, 0x05, 0xF0, 0x6C, 0x38, 0x36, 0xE0, 0x6C, 0x38, 0x3A, 0xA0, 0x6C,
  0x28, 0x90, 0x5F, 0x36, 0xEE, 0xBC, 0xB4, 0x10,
  // "Ñ" (U+00D1)
  0x28, 0x31, 0xBA, 0x36, 0x48, 0x35, 0x16, 0xC4, 0x74, 0x89, 0x36, 0xEE, 0x10, 0x2D, 0xFA, 0x06,
  0xF9, 0x20, 0x10, 0xB2, 0x82, 0x69, 0xF3, 0x20, 0xA2, 0x82, 0x65, 0xAC, 0x20, 0xA2, 0x85, 0x65,
  0x1E, 0x70, 0xA2, 0x85, 0x65, 0x06, 0xF2, 0xA2, 0x06, 0x05, 0x28, 0x1B, 0xCA, 0x20, 0x60, 0x52,
  0x86, 0x2F, 0xA0, 0x6E, 0xE5, 0x20, 0x70, 0xA1,
  // "Ò" (U+00D2)
  0x28, 0x13, 0xE1, 0x70, 0x40, 0x87, 0x71, 0x83, 0x7C, 0xBC, 0x53, 0x08, 0x0C, 0x28, 0x11, 0xD6,
  0x29, 0x04, 0x38, 0x46, 0xD0, 0x3F, 0x13, 0x82, 0x3F, 0x14, 0x94, 0x84, 0x2F, 0x33, 0xF1, 0x38,
  0x43, 0xF1, 0x0F, 0x43, 0x06, 0x0D, 0x20, 0x80, 0xC2, 0x81, 0x1D, 0x63, 0x83, 0x7C, 0xCC, 0x52,
  // "Ó" (U+00D3)
  0x40, 0xB0, 0x76, 0x04, 0x08, 0x77, 0x18, 0x37, 0xCB, 0xC5, 0x30, 0x80, 0xC2, 0x81, 0x1D, 0x62,
  0x90, 0x43, 0x84, 0x6D, 0x03, 0xF1, 0x38, 0x23, 0xF1, 0x49, 0x48, 0x42, 0xF3, 0x3F, 0x13, 0x84,
  0x3F, 0x10, 0xF4, 0x30, 0x60, 0xD2, 0x08, 0x0C, 0x28, 0x11, 0xD6, 0x38, 0x37, 0xCC, 0xC5, 0x20,
  // "Ô" (U+00D4)
  0x38, 0x19, 0xE2, 0x58, 0x24, 0x82, 0x97, 0x78, 0x37, 0xCB, 0xC5, 0x30, 0x80, 0xC2, 0x81, 0x1D,
  0x62, 0x90, 0x43, 0x84, 0x6D, 0x03, 0xF1, 0x38, 0x23, 0xF1, 0x49, 0x48, 0x42, 0xF3, 0x3F, 0x13,
  0x84, 0x3F, 0x10, 0xF4, 0x30, 0x60, 0xD2, 0x08, 0x0C, 0x28, 0x11, 0xD6, 0x38, 0x37, 0xCC, 0xC5,
  0x20,
  // "Õ" (U+00D5)
  0x28, 0x31, 0xBA, 0x36, 0x48, 0x35, 0x16, 0xC4, 0x76, 0x83, 0x7C, 0xBC, 0x53, 0x08, 0x0C, 0x28,
  0x11, 0xD6, 0x29, 0x04, 0x38, 0x46, 0xD0, 0x3F, 0x13, 0x82, 0x3F, 0x14, 0x94, 0x84, 0x2F, 0x33,
  0xF1, 0x38, 0x43, 0xF1, 0x0F, 0x43, 0x06, 0x0D, 0x20, 0x80, 0xC2, 0x81, 0x1D, 0x63, 0x83, 0x7C,
  0xCC, 0x52,
  // "Ö" (U+00D6)
  0x28, 0x32, 0xB0, 0xD1, 0x58, 0x11, 0x01, 0x58, 0x37, 0xCB, 0xC5, 0x30, 0x80, 0xC2, 0x81, 0x1D,
  0x62, 0x90, 0x43, 0x84, 0x6D, 0x03, 0xF1, 0x38, 0x23, 0xF1, 0x49, 0x48, 0x42, 0xF3, 0x3F, 0x13,
  0x84, 0x3F, 0x10, 0xF4, 0x30, 0x60, 0xD2, 0x08, 0x0C, 0x28, 0x11, 0xD6, 0x38, 0x37, 0xCC, 0xC5,
  0x20,
  // "×" (U+00D7)
  0x07, 0x28, 0xA4, 0x16, 0x59, 0x1B, 0x20, 0x7E, 0x20, 0x1B, 0x79, 0x0B, 0x20, 0x58,
  // "Ø" (U+00D8)
  0x60, 0x60, 0x43, 0x07, 0x0C, 0x0F, 0xB3, 0x08, 0x0C, 0x28, 0x14, 0xF4, 0x29, 0x04, 0x28, 0x94,
  0xA7, 0xD0, 0x3F, 0x10, 0x56, 0x3F, 0x14, 0x92, 0x8A, 0x0A, 0x02, 0xF3, 0x3F, 0x16, 0x40, 0x3F,
  0x21, 0xF5, 0x92, 0x05, 0x0D, 0x28, 0x59, 0xE3, 0x01, 0xC6, 0x28, 0x41, 0xCC, 0xBC, 0x63, 0x03,
  0x02, 0x60,
  // "Ù" (U+00D9)
  0x28, 0x13, 0xE1, 0x70, 0x40, 0x87, 0x60, 0xAA, 0x87, 0x80, 0x7F, 0xE5, 0x0B, 0x83, 0x07, 0x04,
  0x20, 0xA0, 0x83, 0x07, 0x04, 0x20, 0xA0, 0x83, 0x07, 0x04, 0x20, 0xA0, 0x83, 0x07, 0x04, 0x20,
  0xA0, 0x83, 0x07, 0x04, 0x20, 0xA0, 0x83, 0x07, 0x03, 0x20, 0x60, 0xD3, 0x0B, 0x01, 0x38, 0x38,
  0xCB, 0xB4, 0x20,
  // "Ú" (U+00DA)
  0x40, 0xB0, 0x76, 0x04, 0x08, 0x76, 0x0A, 0xA8, 0x78, 0x07, 0xFE, 0x50, 0xB8, 0x30, 0x70, 0x42,
  0x0A, 0x08, 0x30, 0x70, 0x42, 0x0A, 0x08, 0x30, 0x70, 0x42, 0x0A, 0x08, 0x30, 0x70, 0x42, 0x0A,
  0x08, 0x30, 0x70, 0x42, 0x0A, 0x08, 0x30, 0x70, 0x32, 0x06, 0x0D, 0x30, 0xB0, 0x13, 0x83, 0x8C,
  0xBB, 0x42,
  // "Û" (U+00DB)
  0x38, 0x19, 0xE2, 0x58, 0x24, 0x82, 0x97, 0x50, 0xAA, 0x87, 0x80, 0x7F, 0xE5, 0x0B, 0x83, 0x07,
  0x04, 0x20, 0xA0, 0x83, 0x07, 0x04, 0x20, 0xA0, 0x83, 0x07, 0x04, 0x20, 0xA0, 0x83, 0x07, 0x04,
  0x20, 0xA0, 0x83, 0x07, 0x04, 0x20, 0xA0, 0x83, 0x07, 0x03, 0x20, 0x60, 0xD3, 0x0B, 0x01, 0x38,
  0x38, 0xCB, 0xB4, 0x20,
  // "Ü" (U+00DC)
  0x28, 0x32, 0xB0, 0xD1, 0x58, 0x11, 0x01, 0x30, 0xAA, 0x87, 0x80, 0x7F, 0xE5, 0x0B, 0x83, 0x07,
  0x04, 0x20, 0xA0, 0x83, 0x07, 0x04, 0x20, 0xA0, 0x83, 0x07, 0x04, 0x20, 0xA0, 0x83, 0x07, 0x04,
  0x20, 0xA0, 0x83, 0x07, 0x04, 0x20, 0xA0, 0x83, 0x07, 0x03, 0x20, 0x60, 0xD3, 0x0B, 0x01, 0x38,
  0x38, 0xCB, 0xB4, 0x20,
  // "Ý" (U+00DD)
  0x40, 0xB0, 0x75, 0x04, 0x08, 0x74, 0x89, 0x1D, 0xFD, 0x24, 0xEF, 0x61, 0xE6, 0x20, 0x60, 0x82,
  0x06, 0x0D, 0x20, 0xA4, 0x82, 0xC6, 0x55, 0x48, 0x13, 0xDA, 0x60, 0xD0, 0x66, 0x0C, 0x05, 0x60,
  0xD0, 0x64, 0x83, 0x1C, 0xFE, 0x72,
  // "Þ" (U+00DE)
  0x82, 0x6E, 0xFB, 0x48, 0x36, 0xEB, 0xB7, 0x28, 0x76, 0xC0, 0x1D, 0x70, 0x6C, 0x28, 0x38, 0xB0,
  0x6C, 0x28, 0x95, 0x8A, 0x06, 0xC0, 0x1D, 0x50, 0x6E, 0xBB, 0x62, 0x06, 0x0D, 0x48, 0x26, 0xEF,
  0xC3,
  // "ß" (U+00DF)
  0x28, 0x29, 0xBC, 0x83, 0x06, 0x0C, 0x20, 0xC0, 0x42, 0x00, 0x82, 0x89, 0x08, 0x80, 0x6D, 0x81,
  0xCB, 0x72, 0x82, 0x98, 0x69, 0x48, 0x39, 0x84, 0xD2, 0x38, 0x49, 0x80, 0x5E, 0x72, 0x8A, 0x49,
  0x81, 0x01, 0xE1, 0x09, 0x89, 0x30, 0xD2, 0x8F, 0x84, 0xCC, 0x81,
  // "à" (U+00E0)
  0x18, 0x13, 0xE1, 0x50, 0x40, 0x87, 0x48, 0x26, 0xDC, 0xB3, 0x83, 0xC3, 0x0C, 0x55, 0x0A, 0x07,
  0x28, 0x95, 0x7B, 0xBE, 0x70, 0x4E, 0x10, 0xA7, 0x05, 0xC2, 0x0D, 0x07, 0x28, 0x4B, 0xC9, 0x7E,
  0x20,
  // "á" (U+00E1)
  0x30, 0xB0, 0x74, 0x04, 0x08, 0x74, 0x82, 0x6D, 0xCB, 0x38, 0x3C, 0x30, 0xC5, 0x50, 0xA0, 0x72,
  0x89, 0x57, 0xBB, 0xE7, 0x04, 0xE1, 0x0A, 0x70, 0x5C, 0x20, 0xD0, 0x72, 0x84, 0xBC, 0x97, 0xE2,
  // "â" (U+00E2)
  0x28, 0x19, 0xE2, 0x38, 0x24, 0x82, 0x97, 0x38, 0x26, 0xDC, 0xB3, 0x83, 0xC3, 0x0C, 0x55, 0x0A,
  0x07, 0x28, 0x95, 0x7B, 0xBE, 0x70, 0x4E, 0x10, 0xA7, 0x05, 0xC2, 0x0D, 0x07, 0x28, 0x4B, 0xC9,
  0x7E, 0x20,
  // "ã" (U+00E3)
  0x18, 0x31, 0xBA, 0x36, 0x28, 0x35, 0x16, 0xC4, 0x72, 0x82, 0x6D, 0xCB, 0x38, 0x3C, 0x30, 0xC5,
  0x50, 0xA0, 0x72, 0x89, 0x57, 0xBB, 0xE7, 0x04, 0xE1, 0x0A, 0x70, 0x5C, 0x20, 0xD0, 0x72, 0x84,
  0xBC, 0x97, 0xE2,
  // "ä" (U+00E4)
  0x18, 0x32, 0xB0, 0xD1, 0x38, 0x11, 0x01, 0x38, 0x26, 0xDC, 0xB3, 0x83, 0xC3, 0x0C, 0x55, 0x0A,
  0x07, 0x28, 0x95, 0x7B, 0xBE, 0x70, 0x4E, 0x10, 0xA7, 0x05, 0xC2, 0x0D, 0x07, 0x28, 0x4B, 0xC9,
  0x7E, 0x20,
  // "å" (U+00E5)
  0x18, 0x21, 0xBB, 0x13, 0x82, 0x65, 0x56, 0x38, 0x21, 0xBB, 0x13, 0x82, 0x6D, 0xCB, 0x38, 0x3C,
  0x30, 0xC5, 0x50, 0xA0, 0x72, 0x89, 0x57, 0xBB, 0xE7, 0x04, 0xE1, 0x0A, 0x70, 0x5C, 0x20, 0xD0,
  0x72, 0x84, 0xBC, 0x97, 0xE2,
  // "æ" (U+00E6)
  0x18, 0x66, 0xDC, 0x96, 0xCC, 0x62, 0x87, 0xC3, 0x0C, 0xD0, 0x1E, 0x24, 0x0A, 0x09, 0x28, 0xA0,
  0xB6, 0x07, 0xBB, 0xED, 0xBB, 0xD6, 0x4E, 0x10, 0xA8, 0x40, 0x50, 0xC2, 0x0C, 0x0D, 0x28, 0x91,
  0x21, 0x0B, 0xCA, 0x27, 0xDB, 0x91,
  // "ç" (U+00E7)
  0x18, 0x93, 0x4C, 0xCB, 0x10, 0xE3, 0x0C, 0x53, 0xE2, 0x82, 0x10, 0x5D, 0x40, 0x30, 0xE5, 0x89,
  0x1E, 0x40, 0x13, 0x03, 0xCB, 0xB1, 0x20, 0x06, 0x50, 0xD0, 0x22, 0x81, 0x3B, 0xA2,
  // "è" (U+00E8)
  0x18, 0x13, 0xE1, 0x40, 0x40, 0x87, 0x28, 0x23, 0xCC, 0xA2, 0x85, 0xE3, 0x0A, 0x73, 0xE2, 0x89,
  0x06, 0xB4, 0xEB, 0xBC, 0xB3, 0xD5, 0x0D, 0x03, 0x28, 0x53, 0x03, 0xBB, 0xB2,
  // "é" (U+00E9)
  0x30, 0xB0, 0x73, 0x04, 0x08, 0x72, 0x82, 0x3C, 0xCA, 0x28, 0x5E, 0x30, 0xA7, 0x3E, 0x28, 0x90,
  0x6B, 0x4E, 0xBB, 0xCB, 0x3D, 0x50, 0xD0, 0x32, 0x85, 0x30, 0x3B, 0xBB, 0x20,
  // "ê" (U+00EA)
  0x28, 0x19, 0xE2, 0x28, 0x24, 0x82, 0x97, 0x18, 0x23, 0xCC, 0xA2, 0x85, 0xE3, 0x0A, 0x73, 0xE2,
  0x89, 0x06, 0xB4, 0xEB, 0xBC, 0xB3, 0xD5, 0x0D, 0x03, 0x28, 0x53, 0x03, 0xBB, 0xB2,
  // "ë" (U+00EB)
  0x18, 0x32, 0xB0, 0xD1, 0x28, 0x11, 0x01, 0x28, 0x23, 0xCC, 0xA2, 0x85, 0xE3, 0x0A, 0x73, 0xE2,
  0x89, 0x06, 0xB4, 0xEB, 0xBC, 0xB3, 0xD5, 0x0D, 0x03, 0x28, 0x53, 0x03, 0xBB, 0xB2,
  // "ì" (U+00EC)
  0x81, 0x3E, 0x12, 0x04, 0x08, 0x58, 0x17, 0xF8, 0x20, 0x90, 0x82, 0x09, 0x08, 0x20, 0x90, 0x82,
  0x09, 0x08, 0x28, 0x29, 0x90, 0x8A, 0x08,
  // "í" (U+00ED)
  0x28, 0x3B, 0x70, 0x48, 0x58, 0x17, 0xF8, 0x20, 0x90, 0x82, 0x09, 0x08, 0x20, 0x90, 0x82, 0x09,
  0x08, 0x28, 0x29, 0x90, 0x8A, 0x08,
  // "î" (U+00EE)
  0x18, 0x59, 0xE2, 0x48, 0x29, 0x48, 0x17, 0xF8, 0x20, 0x90, 0x82, 0x09, 0x08, 0x20, 0x90, 0x82,
  0x09, 0x08, 0x28, 0x29, 0x90, 0x8A, 0x08,
  // "ï" (U+00EF)
  0x87, 0x2B, 0x0D, 0x10, 0x10, 0x12, 0x81, 0x7F, 0x83, 0x09, 0x08, 0x30, 0x90, 0x83, 0x09, 0x08,
  0x30, 0x90, 0x83, 0x00, 0x92, 0x08, 0xA0, 0x80,
  // "ð" (U+00F0)
  0x18, 0x31, 0xB6, 0x84, 0x38, 0x15, 0xDA, 0x48, 0x24, 0x0A, 0x52, 0x83, 0x2A, 0xBC, 0xC2, 0x86,
  0xD4, 0x06, 0xF1, 0x3E, 0x39, 0x81, 0x34, 0xD3, 0x82, 0xE3, 0x3E, 0x39, 0x85, 0x10, 0xE3, 0x04,
  0xC2, 0x83, 0x3B, 0xBB, 0x21,
  // "ñ" (U+00F1)
  0x18, 0x31, 0xBA, 0x36, 0x38, 0x35, 0x16, 0xC4, 0x73, 0x84, 0x7F, 0x79, 0xCA, 0x30, 0x90, 0xC2,
  0x0D, 0x04, 0x20, 0x09, 0x20, 0xA0, 0x62, 0x09, 0x08, 0x20, 0xA0, 0x62, 0x09, 0x08, 0x20, 0xA0,
  0x62, 0x00, 0x92, 0x82, 0xA7, 0x08, 0xA8, 0x36, 0x0A, 0xE4,
  // "ò" (U+00F2)
  0x18, 0x13, 0xE1, 0x50, 0x40, 0x87, 0x48, 0x33, 0xBB, 0xB2, 0x28, 0x6E, 0x30, 0x5C, 0x03, 0xE3,
  0x98, 0x12, 0x4D, 0x38, 0x2E, 0x33, 0xE3, 0x98, 0x52, 0x0D, 0x30, 0x4D, 0x28, 0x33, 0xBB, 0xB3,
  0x10,
  // "ó" (U+00F3)
  0x40, 0xB0, 0x74, 0x04, 0x08, 0x73, 0x83, 0x3B, 0xBB, 0x22, 0x86, 0xE3, 0x05, 0xC0, 0x3E, 0x39,
  0x81, 0x24, 0xD3, 0x82, 0xE3, 0x3E, 0x39, 0x85, 0x20, 0xD3, 0x04, 0xD2, 0x83, 0x3B, 0xBB, 0x31,
  // "ô" (U+00F4)
  0x28, 0x19, 0xE2, 0x38, 0x24, 0x82, 0x97, 0x38, 0x33, 0xBB, 0xB2, 0x28, 0x6E, 0x30, 0x5C, 0x03,
  0xE3, 0x98, 0x12, 0x4D, 0x38, 0x2E, 0x33, 0xE3, 0x98, 0x52, 0x0D, 0x30, 0x4D, 0x28, 0x33, 0xBB,
  0xB3, 0x10,
  // "õ" (U+00F5)
  0x18, 0x31, 0xBA, 0x36, 0x28, 0x35, 0x16, 0xC4, 0x72, 0x83, 0x3B, 0xBB, 0x22, 0x86, 0xE3, 0x05,
  0xC0, 0x3E, 0x39, 0x81, 0x24, 0xD3, 0x82, 0xE3, 0x3E, 0x39, 0x85, 0x20, 0xD3, 0x04, 0xD2, 0x83,
  0x3B, 0xBB, 0x31,
  // "ö" (U+00F6)
  0x18, 0x32, 0xB0, 0xD1, 0x38, 0x11, 0x01, 0x38, 0x33, 0xBB, 0xB2, 0x28, 0x6E, 0x30, 0x5C, 0x03,
  0xE3, 0x98, 0x12, 0x4D, 0x38, 0x2E, 0x33, 0xE3, 0x98, 0x52, 0x0D, 0x30, 0x4D, 0x28, 0x33, 0xBB,
  0xB3, 0x10,
  // "÷" (U+00F7)
  0x20, 0x20, 0xC5, 0x01, 0x71, 0x84, 0x2B, 0xBB, 0xBA, 0x71, 0x02, 0x0C, 0x50, 0x12,
  // "ø" (U+00F8)
  0x50, 0x52, 0x83, 0x3B, 0xBB, 0x92, 0x8B, 0x7D, 0x30, 0xAB, 0x03, 0xE0, 0x37, 0xF1, 0x5D, 0x0A,
  0x0E, 0x34, 0xD7, 0x40, 0xF2, 0x0E, 0x90, 0x4D, 0x28, 0x39, 0xCB, 0xB3, 0x20, 0x45,
  // "ù" (U+00F9)
  0x18, 0x13, 0xE1, 0x60, 0x40, 0x87, 0x58, 0x59, 0xF6, 0x0A, 0xF5, 0x20, 0xB0, 0x62, 0x0D, 0x05,
  0x20, 0xA0, 0x62, 0x0C, 0x05, 0x20, 0xA0, 0x62, 0x0C, 0x05, 0x20, 0xA0, 0x62, 0x0C, 0x05, 0x28,
  0x48, 0x90, 0x2F, 0x52, 0x85, 0x2C, 0xB9, 0xAE, 0x40,
  // "ú" (U+00FA)
  0x40, 0xB0, 0x75, 0x04, 0x08, 0x74, 0x85, 0x9F, 0x60, 0xAF, 0x52, 0x0B, 0x06, 0x20, 0xD0, 0x52,
  0x0A, 0x06, 0x20, 0xC0, 0x52, 0x0A, 0x06, 0x20, 0xC0, 0x52, 0x0A, 0x06, 0x20, 0xC0, 0x52, 0x84,
  0x89, 0x02, 0xF5, 0x28, 0x52, 0xCB, 0x9A, 0xE4,
  // "û" (U+00FB)
  0x38, 0x19, 0xE2, 0x48, 0x24, 0x82, 0x97, 0x38, 0x59, 0xF6, 0x0A, 0xF5, 0x20, 0xB0, 0x62, 0x0D,
  0x05, 0x20, 0xA0, 0x62, 0x0C, 0x05, 0x20, 0xA0, 0x62, 0x0C, 0x05, 0x20, 0xA0, 0x62, 0x0C, 0x05,
  0x28, 0x48, 0x90, 0x2F, 0x52, 0x85, 0x2C, 0xB9, 0xAE, 0x40,
  // "ü" (U+00FC)
  0x18, 0x32, 0xB0, 0xD1, 0x48, 0x11, 0x01, 0x38, 0x59, 0xF6, 0x0A, 0xF5, 0x20, 0xB0, 0x62, 0x0D,
  0x05, 0x20, 0xA0, 0x62, 0x0C, 0x05, 0x20, 0xA0, 0x62, 0x0C, 0x05, 0x20, 0xA0, 0x62, 0x0C, 0x05,
  0x28, 0x48, 0x90, 0x2F, 0x52, 0x85, 0x2C, 0xB9, 0xAE, 0x40,
  // "ý" (U+00FD)
  0x30, 0xB0, 0x74, 0x04, 0x08, 0x73, 0x89, 0x0D, 0xFC, 0x09, 0xFA, 0x1E, 0x32, 0x0D, 0x28, 0x39,
  0x80, 0x38, 0x28, 0x33, 0xE0, 0x83, 0x38, 0x1C, 0x4B, 0x48, 0x16, 0xC8, 0x50, 0xE0, 0x34, 0x01,
  0x0C, 0x50, 0xB0, 0x63, 0x81, 0x6D, 0x84,
  // "þ" (U+00FE)
  0x81, 0x9F, 0x65, 0x0B, 0x06, 0x50, 0xA0, 0x65, 0x83, 0xA7, 0xAC, 0x92, 0x0A, 0x0B, 0x28, 0x3C,
  0x50, 0xA7, 0x28, 0x38, 0x90, 0xA6, 0x28, 0x37, 0xA0, 0xA7, 0x28, 0x38, 0x90, 0xAC, 0x28, 0x6C,
  0x50, 0xA8, 0xBC, 0x92, 0x0A, 0x06, 0x50, 0xB0, 0x74, 0x82, 0x9F, 0xE5, 0x30,
  // "ÿ" (U+00FF)
  0x18, 0x32, 0xB0, 0xD1, 0x38, 0x11, 0x01, 0x28, 0x90, 0xDF, 0xC0, 0x9F, 0xA1, 0xE3, 0x20, 0xD2,
  0x83, 0x98, 0x03, 0x82, 0x83, 0x3E, 0x08, 0x33, 0x81, 0xC4, 0xB4, 0x81, 0x6C, 0x85, 0x0E, 0x03,
  0x40, 0x10, 0xC5, 0x0B, 0x06, 0x38, 0x16, 0xD8, 0x40,
  // "Ā" (U+0100)
  0x20, 0x60, 0xFB, 0x77, 0x10, 0x60, 0xD7, 0x81, 0xAD, 0x45, 0x82, 0x19, 0x89, 0x58, 0x27, 0x43,
  0xE5, 0x0B, 0x20, 0xD0, 0x53, 0x84, 0x3C, 0x99, 0xCA, 0x30, 0x80, 0x22, 0x81, 0x2F, 0x12, 0x0D,
  0x48, 0x4E, 0x60, 0xDF, 0xB2, 0x82, 0xAF, 0xE5,
  // "ā" (U+0101)
  0x10, 0x60, 0xFB, 0x73, 0x82, 0x6D, 0xCB, 0x38, 0x3C, 0x30, 0xC5, 0x50, 0xA0, 0x72, 0x89, 0x57,
  0xBB, 0xE7, 0x04, 0xE1, 0x0A, 0x70, 0x5C, 0x20, 0xD0, 0x72, 0x84, 0xBC, 0x97, 0xE2,
  // "Ă" (U+0102)
  0x20, 0x12, 0x01, 0x58, 0x26, 0x40, 0x96, 0x81, 0xAB, 0x37, 0x71, 0x06, 0x0D, 0x78, 0x1A, 0xD4,
  0x58, 0x21, 0x98, 0x95, 0x82, 0x74, 0x3E, 0x50, 0xB2, 0x0D, 0x05, 0x38, 0x43, 0xC9, 0x9C, 0xA3,
  0x08, 0x02, 0x28, 0x12, 0xF1, 0x20, 0xD4, 0x84, 0xE6, 0x0D, 0xFB, 0x28, 0x2A, 0xFE, 0x50,
  // "ă" (U+0103)
  0x10, 0x12, 0x01, 0x38, 0x26, 0x40, 0x94, 0x81, 0xAB, 0x37, 0x38, 0x26, 0xDC, 0xB3, 0x83, 0xC3,
  0x0C, 0x55, 0x0A, 0x07, 0x28, 0x95, 0x7B, 0xBE, 0x70, 0x4E, 0x10, 0xA7, 0x05, 0xC2, 0x0D, 0x07,
  0x28, 0x4B, 0xC9, 0x7E, 0x20,
  // "Ą" (U+0104)
  0x30, 0x60, 0xD7, 0x81, 0xAD, 0x45, 0x82, 0x19, 0x89, 0x58, 0x27, 0x43, 0xE5, 0x0B, 0x20, 0xD0,
  0x53, 0x84, 0x3C, 0x99, 0xCA, 0x30, 0x80, 0x22, 0x81, 0x2F, 0x12, 0x0D, 0x48, 0x4E, 0x60, 0xDF,
  0xB2, 0x0A, 0xA0, 0x56, 0x06, 0x05, 0x70, 0xD0, 0x27, 0x81, 0x7C, 0x70,
  // "ą" (U+0105)
  0x18, 0x26, 0xDC, 0xB3, 0x83, 0xC3, 0x0C, 0x55, 0x0A, 0x07, 0x28, 0x95, 0x7B, 0xBE, 0x70, 0x4E,
  0x10, 0xA7, 0x05, 0xC2, 0x0D, 0x07, 0x28, 0x4B, 0xC9, 0x8E, 0x23, 0x06, 0x05, 0x50, 0xD0, 0x25,
  0x81, 0x7C, 0x71,
  // "Ć" (U+0106)
  0x40, 0xB0, 0x74, 0x04, 0x08, 0x74, 0x86, 0x6C, 0xCD, 0x60, 0x7C, 0x28, 0x35, 0xD0, 0xE4, 0x38,
  0x21, 0x3F, 0x14, 0x04, 0x95, 0x81, 0x3F, 0x25, 0x90, 0x45, 0x08, 0x0C, 0x30, 0x62, 0x83, 0x7C,
  0xBB, 0x50,
  // "ć" (U+0107)
  0x30, 0xB0, 0x73, 0x04, 0x08, 0x72, 0x89, 0x34, 0xCC, 0xB1, 0x0E, 0x30, 0xC5, 0x3E, 0x28, 0x21,
  0x05, 0xD4, 0x03, 0x0E, 0x58, 0x91, 0xE4, 0x01, 0x30, 0x3C, 0xBB, 0x10,
  // "Ĉ" (U+0108)
  0x38, 0x19, 0xE2, 0x38, 0x24, 0x82, 0x97, 0x38, 0x66, 0xCC, 0xD6, 0x07, 0xC2, 0x83, 0x5D, 0x0E,
  0x43, 0x82, 0x13, 0xF1, 0x40, 0x49, 0x58, 0x13, 0xF2, 0x59, 0x04, 0x50, 0x80, 0xC3, 0x06, 0x28,
  0x37, 0xCB, 0xB5,
  // "ĉ" (U+0109)
  0x28, 0x19, 0xE2, 0x28, 0x24, 0x82, 0x97, 0x18, 0x93, 0x4C, 0xCB, 0x10, 0xE3, 0x0C, 0x53, 0xE2,
  0x82, 0x10, 0x5D, 0x40, 0x30, 0xE5, 0x89, 0x1E, 0x40, 0x13, 0x03, 0xCB, 0xB1,
  // "Ċ" (U+010A)
  0x30, 0x40, 0x85, 0x06, 0x0A, 0x74, 0x86, 0x6C, 0xCD, 0x60, 0x7C, 0x28, 0x35, 0xD0, 0xE4, 0x38,
  0x21, 0x3F, 0x14, 0x04, 0x95, 0x81, 0x3F, 0x25, 0x90, 0x45, 0x08, 0x0C, 0x30, 0x62, 0x83, 0x7C,
  0xBB, 0x50,
  // "ċ" (U+010B)
  0x20, 0x40, 0x84, 0x06, 0x0A, 0x72, 0x89, 0x34, 0xCC, 0xB1, 0x0E, 0x30, 0xC5, 0x3E, 0x28, 0x21,
  0x05, 0xD4, 0x03, 0x0E, 0x58, 0x91, 0xE4, 0x01, 0x30, 0x3C, 0xBB, 0x10,
  // "Č" (U+010C)
  0x28, 0x24, 0x82, 0xA4, 0x81, 0x9E, 0x27, 0x38, 0x66, 0xCC, 0xD6, 0x07, 0xC2, 0x83, 0x5D, 0x0E,
  0x43, 0x82, 0x13, 0xF1, 0x40, 0x49, 0x58, 0x13, 0xF2, 0x59, 0x04, 0x50, 0x80, 0xC3, 0x06, 0x28,
  0x37, 0xCB, 0xB5,
  // "č" (U+010D)
  0x18, 0x24, 0x82, 0xA3, 0x81, 0x9E, 0x27, 0x18, 0x93, 0x4C, 0xCB, 0x10, 0xE3, 0x0C, 0x53, 0xE2,
  0x82, 0x10, 0x5D, 0x40, 0x30, 0xE5, 0x89, 0x1E, 0x40, 0x13, 0x03, 0xCB, 0xB1,
  // "Ď" (U+010E)
  0x28, 0x24, 0x82, 0xA5, 0x81, 0x9E, 0x27, 0x38, 0x56, 0xEE, 0xBD, 0xC4, 0x20, 0x60, 0xC2, 0x84,
  0x4F, 0x30, 0x6C, 0x38, 0x3A, 0xB0, 0x6C, 0x38, 0x36, 0xE0, 0x6C, 0x38, 0x35, 0xF0, 0x6C, 0x38,
  0x36, 0xE0, 0x6C, 0x38, 0x3A, 0xA0, 0x6C, 0x28, 0x90, 0x5F, 0x36, 0xEE, 0xBC, 0xB4, 0x10,
  // "ď" (U+010F)
  0x38, 0x31, 0xDF, 0x1E, 0x48, 0x21, 0xF4, 0x75, 0x90, 0x12, 0x84, 0x5C, 0xB6, 0xF1, 0x28, 0x7E,
  0x30, 0x7F, 0x10, 0x3E, 0x28, 0x42, 0xF1, 0x04, 0xD2, 0x84, 0x1F, 0x10, 0x3E, 0x28, 0x12, 0xF1,
  0x28, 0x4E, 0x30, 0x6F, 0x12, 0x85, 0x5C, 0xB5, 0xED, 0x10,
  // "Đ" (U+0110)
  0x85, 0x6E, 0xEB, 0xDC, 0x42, 0x06, 0x0C, 0x28, 0x44, 0xF3, 0x06, 0xC3, 0x83, 0xAB, 0x06, 0xC3,
  0x89, 0x36, 0xE6, 0xDE, 0xB9, 0x05, 0xF0, 0x6C, 0x38, 0x36, 0xE0, 0x6C, 0x38, 0x3A, 0xA0, 0x6C,
  0x28, 0x90, 0x5F, 0x36, 0xEE, 0xBC, 0xB4, 0x10,
  // "đ" (U+0111)
  0x38, 0x21, 0xCF, 0x13, 0x84, 0x1B, 0xBF, 0xB1, 0x59, 0x01, 0x28, 0x45, 0xCB, 0x6F, 0x12, 0x87,
  0xE3, 0x07, 0xF1, 0x03, 0xE2, 0x84, 0x2F, 0x10, 0x4D, 0x28, 0x41, 0xF1, 0x03, 0xE2, 0x81, 0x2F,
  0x12, 0x84, 0xE3, 0x06, 0xF1, 0x28, 0x55, 0xCB, 0x5E, 0xD1,
  // "Ē" (U+0112)
  0x20, 0x60, 0xFB, 0x71, 0x89, 0x04, 0xDE, 0x88, 0xC7, 0x06, 0xC2, 0x83, 0x38, 0x06, 0xC3, 0x82,
  0x20, 0x6C, 0x58, 0x36, 0xEB, 0xB8, 0x20, 0x60, 0xC5, 0x06, 0x0C, 0x50, 0x60, 0xC3, 0x86, 0xB4,
  0xDE, 0x88, 0x9E,
  // "ē" (U+0113)
  0x10, 0x60, 0xFB, 0x71, 0x82, 0x3C, 0xCA, 0x28, 0x5E, 0x30, 0xA7, 0x3E, 0x28, 0x90, 0x6B, 0x4E,
  0xBB, 0xCB, 0x3D, 0x50, 0xD0, 0x32, 0x85, 0x30, 0x3B, 0xBB, 0x20,
  // "Ĕ" (U+0114)
  0x20, 0x12, 0x01, 0x38, 0x26, 0x40, 0x94, 0x81, 0xAB, 0x37, 0x18, 0x90, 0x4D, 0xE8, 0x8C, 0x70,
  0x6C, 0x28, 0x33, 0x80, 0x6C, 0x38, 0x22, 0x06, 0xC5, 0x83, 0x6E, 0xBB, 0x82, 0x06, 0x0C, 0x50,
  0x60, 0xC5, 0x06, 0x0C, 0x38, 0x6B, 0x4D, 0xE8, 0x89, 0xE0,
  // "ĕ" (U+0115)
  0x10, 0x12, 0x01, 0x28, 0x26, 0x40, 0x93, 0x81, 0xAB, 0x37, 0x18, 0x23, 0xCC, 0xA2, 0x85, 0xE3,
  0x0A, 0x73, 0xE2, 0x89, 0x06, 0xB4, 0xEB, 0xBC, 0xB3, 0xD5, 0x0D, 0x03, 0x28, 0x53, 0x03, 0xBB,
  0xB2,
  // "Ė" (U+0116)
  0x30, 0x40, 0x85, 0x06, 0x0A, 0x72, 0x89, 0x04, 0xDE, 0x88, 0xC7, 0x06, 0xC2, 0x83, 0x38, 0x06,
  0xC3, 0x82, 0x20, 0x6C, 0x58, 0x36, 0xEB, 0xB8, 0x20, 0x60, 0xC5, 0x06, 0x0C, 0x50, 0x60, 0xC3,
  0x86, 0xB4, 0xDE, 0x88, 0x9E,
  // "ė" (U+0117)
  0x20, 0x40, 0x84, 0x06, 0x0A, 0x72, 0x82, 0x3C, 0xCA, 0x28, 0x5E, 0x30, 0xA7, 0x3E, 0x28, 0x90,
  0x6B, 0x4E, 0xBB, 0xCB, 0x3D, 0x50, 0xD0, 0x32, 0x85, 0x30, 0x3B, 0xBB, 0x20,
  // "Ę" (U+0118)
  0x89, 0x04, 0xDE, 0x88, 0xC7, 0x06, 0xC2, 0x83, 0x38, 0x06, 0xC3, 0x82, 0x20, 0x6C, 0x58, 0x36,
  0xEB, 0xB8, 0x20, 0x60, 0xC5, 0x06, 0x0C, 0x50, 0x60, 0xC3, 0x86, 0xB4, 0xDE, 0x88, 0xAE, 0x40,
  0xA0, 0x14, 0x03, 0x0C, 0x68, 0x1A, 0xC3,
  // "ę" (U+0119)
  0x18, 0x23, 0xCC, 0xA2, 0x85, 0xE3, 0x0A, 0x73, 0xE2, 0x89, 0x06, 0xB4, 0xEB, 0xBC, 0xB3, 0xD5,
  0x0D, 0x03, 0x28, 0x53, 0x03, 0xBC, 0xD4, 0x30, 0xC0, 0x23, 0x02, 0x0D, 0x58, 0x1B, 0xC3,
  // "Ě" (U+011A)
  0x18, 0x24, 0x82, 0xA4, 0x81, 0x9E, 0x27, 0x28, 0x90, 0x4D, 0xE8, 0x8C, 0x70, 0x6C, 0x28, 0x33,
  0x80, 0x6C, 0x38, 0x22, 0x06, 0xC5, 0x83, 0x6E, 0xBB, 0x82, 0x06, 0x0C, 0x50, 0x60, 0xC5, 0x06,
  0x0C, 0x38, 0x6B, 0x4D, 0xE8, 0x89, 0xE0,
  // "ě" (U+011B)
  0x18, 0x24, 0x82, 0xA3, 0x81, 0x9E, 0x27, 0x18, 0x23, 0xCC, 0xA2, 0x85, 0xE3, 0x0A, 0x73, 0xE2,
  0x89, 0x06, 0xB4, 0xEB, 0xBC, 0xB3, 0xD5, 0x0D, 0x03, 0x28, 0x53, 0x03, 0xBB, 0xB2,
  // "Ĝ" (U+011C)
  0x38, 0x19, 0xE2, 0x58, 0x24, 0x82, 0x97, 0x78, 0x45, 0xBC, 0xDB, 0x22, 0x81, 0x6D, 0x12, 0x0B,
  0x05, 0x20, 0xE0, 0x56, 0x81, 0x3F, 0x16, 0x04, 0x93, 0x85, 0xAD, 0xD4, 0x3F, 0x13, 0x0C, 0x08,
  0x20, 0xE0, 0x53, 0x0B, 0x07, 0x28, 0x17, 0xD2, 0x20, 0xB0, 0x73, 0x84, 0x5C, 0xCB, 0xB3, 0x10,
  // "ĝ" (U+011D)
  0x28, 0x19, 0xE2, 0x38, 0x24, 0x82, 0x97, 0x38, 0x95, 0x5C, 0xC9, 0xC2, 0x0E, 0x11, 0xE1, 0x02,
  0xE2, 0x0E, 0x03, 0x28, 0x3E, 0x21, 0xE1, 0x28, 0x26, 0xDB, 0x53, 0x0B, 0x68, 0x69, 0xCB, 0xA3,
  0x06, 0x72, 0x83, 0x3D, 0x0A, 0x62, 0x87, 0x4C, 0x02, 0xBB, 0xBA, 0x21,
  // "Ğ" (U+011E)
  0x30, 0x12, 0x01, 0x58, 0x26, 0x40, 0x96, 0x81, 0xAB, 0x37, 0x68, 0x45, 0xBC, 0xDB, 0x22, 0x81,
  0x6D, 0x12, 0x0B, 0x05, 0x20, 0xE0, 0x56, 0x81, 0x3F, 0x16, 0x04, 0x93, 0x85, 0xAD, 0xD4, 0x3F,
  0x13, 0x0C, 0x08, 0x20, 0xE0, 0x53, 0x0B, 0x07, 0x28, 0x17, 0xD2, 0x20, 0xB0, 0x73, 0x84, 0x5C,
  0xCB, 0xB3, 0x10,
  // "ğ" (U+011F)
  0x10, 0x12, 0x01, 0x38, 0x26, 0x40, 0x94, 0x81, 0xAB, 0x37, 0x38, 0x95, 0x5C, 0xC9, 0xC2, 0x0E,
  0x11, 0xE1, 0x02, 0xE2, 0x0E, 0x03, 0x28, 0x3E, 0x21, 0xE1, 0x28, 0x26, 0xDB, 0x53, 0x0B, 0x68,
  0x69, 0xCB, 0xA3, 0x06, 0x72, 0x83, 0x3D, 0x0A, 0x62, 0x87, 0x4C, 0x02, 0xBB, 0xBA, 0x21,
  // "Ġ" (U+0120)
  0x40, 0x40, 0x87, 0x06, 0x0A, 0x77, 0x84, 0x5B, 0xCD, 0xB2, 0x28, 0x16, 0xD1, 0x20, 0xB0, 0x52,
  0x0E, 0x05, 0x68, 0x13, 0xF1, 0x60, 0x49, 0x38, 0x5A, 0xDD, 0x43, 0xF1, 0x30, 0xC0, 0x82, 0x0E,
  0x05, 0x30, 0xB0, 0x72, 0x81, 0x7D, 0x22, 0x0B, 0x07, 0x38, 0x45, 0xCC, 0xBB, 0x31,
  // "ġ" (U+0121)
  0x20, 0x40, 0x85, 0x06, 0x0A, 0x74, 0x89, 0x55, 0xCC, 0x9C, 0x20, 0xE1, 0x1E, 0x10, 0x2E, 0x20,
  0xE0, 0x32, 0x83, 0xE2, 0x1E, 0x12, 0x82, 0x6D, 0xB5, 0x30, 0xB6, 0x86, 0x9C, 0xBA, 0x30, 0x67,
  0x28, 0x33, 0xD0, 0xA6, 0x28, 0x74, 0xC0, 0x2B, 0xBB, 0xA2, 0x10,
  // "Ģ" (U+0122)
  0x28, 0x45, 0xBC, 0xDB, 0x22, 0x81, 0x6D, 0x12, 0x0B, 0x05, 0x20, 0xE0, 0x56, 0x81, 0x3F, 0x16,
  0x04, 0x93, 0x85, 0xAD, 0xD4, 0x3F, 0x13, 0x0C, 0x08, 0x20, 0xE0, 0x53, 0x0B, 0x07, 0x28, 0x17,
  0xD2, 0x20, 0xB0, 0x73, 0x84, 0x5C, 0xCB, 0xB3, 0x77, 0x00, 0x87, 0x0A, 0x01, 0x30,
  // "ģ" (U+0123)
  0x30, 0xB5, 0x04, 0x0C, 0x74, 0x89, 0x55, 0xCC, 0x9C, 0x20, 0xE1, 0x1E, 0x10, 0x2E, 0x20, 0xE0,
  0x32, 0x83, 0xE2, 0x1E, 0x12, 0x82, 0x6D, 0xB5, 0x30, 0xB6, 0x86, 0x9C, 0xBA, 0x30, 0x67, 0x28,
  0x33, 0xD0, 0xA6, 0x28, 0x74, 0xC0, 0x2B, 0xBB, 0xA2, 0x10,
  // "Ĥ" (U+0124)
  0x48, 0x19, 0xE2, 0x58, 0x24, 0x82, 0x97, 0x48, 0x92, 0x6E, 0xFC, 0x05, 0xEF, 0xD0, 0x6D, 0x30,
  0x50, 0xE2, 0x06, 0x0C, 0x30, 0x40, 0xE2, 0x06, 0x0C, 0x30, 0x40, 0xE2, 0x85, 0x6E, 0xBB, 0xBC,
  0xE2, 0x06, 0x0C, 0x30, 0x40, 0xE2, 0x06, 0x0C, 0x30, 0x40, 0xE2, 0x06, 0x0D, 0x38, 0x92, 0x5E,
  0x06, 0xEF, 0xC0, 0x5E, 0xFD,
  // "ĥ" (U+0125)
  0x28, 0x19, 0xE2, 0x48, 0x24, 0x82, 0x93, 0x81, 0x9F, 0x66, 0x0B, 0x06, 0x60, 0xA0, 0x66, 0x83,
  0xA8, 0xAD, 0x83, 0x00, 0xA2, 0x0E, 0x02, 0x20, 0xA0, 0x72, 0x0C, 0x04, 0x20, 0xA0, 0x62, 0x0C,
  0x05, 0x20, 0xA0, 0x62, 0x0C, 0x05, 0x20, 0xB0, 0x72, 0x89, 0x1C, 0x50, 0x9F, 0xE5, 0x0C, 0xE3,
  // "Ħ" (U+0126)
  0x89, 0x26, 0xEF, 0xC0, 0x5E, 0xFD, 0x06, 0xC3, 0x89, 0x55, 0xE0, 0x6D, 0xEB, 0xBB, 0xCF, 0xB0,
  0x6C, 0x30, 0x40, 0xE2, 0x85, 0x6E, 0xBB, 0xBC, 0xE2, 0x06, 0x0C, 0x30, 0x40, 0xE2, 0x06, 0x0C,
  0x30, 0x40, 0xE2, 0x06, 0x0D, 0x38, 0x92, 0x5E, 0x06, 0xEF, 0xC0, 0x5E, 0xFD,
  // "ħ" (U+0127)
  0x81, 0xAF, 0x66, 0x0C, 0x06, 0x58, 0x39, 0xED, 0xB5, 0x48, 0x3A, 0x8A, 0xD8, 0x38, 0x4A, 0xB0,
  0x1E, 0x22, 0x0A, 0x07, 0x20, 0xC0, 0x42, 0x0A, 0x06, 0x20, 0xC0, 0x52, 0x0A, 0x06, 0x20, 0xC0,
  0x52, 0x0B, 0x07, 0x28, 0x91, 0xC5, 0x09, 0xFE, 0x50, 0xCE, 0x30,
  // "Ĩ" (U+0128)
  0x89, 0x01, 0xBA, 0x36, 0x51, 0x6C, 0x45, 0x82, 0x6E, 0xFC, 0x20, 0x60, 0xD3, 0x06, 0x0C, 0x30,
  0x60, 0xC3, 0x06, 0x0C, 0x30, 0x60, 0xC3, 0x06, 0x0C, 0x30, 0x60, 0xD2, 0x82, 0x6E, 0xFC, 0x10,
  // "ĩ" (U+0129)
  0x89, 0x01, 0xBA, 0x36, 0x51, 0x6C, 0x46, 0x81, 0x7F, 0x83, 0x09, 0x08, 0x30, 0x90, 0x83, 0x09,
  0x08, 0x30, 0x90, 0x83, 0x00, 0x92, 0x08, 0xA0, 0x80,
  // "Ī" (U+012A)
  0x06, 0x0F, 0xB4, 0x85, 0x6E, 0xFC, 0x06, 0xD2, 0x06, 0x0C, 0x20, 0x60, 0xC2, 0x06, 0x0C, 0x20,
  0x60, 0xC2, 0x06, 0x0C, 0x28, 0x56, 0xD0, 0x6E, 0xFC,
  // "ī" (U+012B)
  0x06, 0x0F, 0xB4, 0x81, 0x7F, 0x82, 0x09, 0x08, 0x20, 0x90, 0x82, 0x09, 0x08, 0x20, 0x90, 0x82,
  0x82, 0x99, 0x08, 0xA0, 0x80,
  // "Ĭ" (U+012C)
  0x01, 0x28, 0x71, 0x64, 0x09, 0x0A, 0xB3, 0x48, 0x56, 0xEF, 0xC0, 0x6D, 0x20, 0x60, 0xC2, 0x06,
  0x0C, 0x20, 0x60, 0xC2, 0x06, 0x0C, 0x20, 0x60, 0xC2, 0x85, 0x6D, 0x06, 0xEF, 0xC0,
  // "ĭ" (U+012D)
  0x01, 0x28, 0x71, 0x64, 0x09, 0x0A, 0xB3, 0x48, 0x17, 0xF8, 0x20, 0x90, 0x82, 0x09, 0x08, 0x20,
  0x90, 0x82, 0x09, 0x08, 0x28, 0x29, 0x90, 0x8A, 0x08,
  // "Į" (U+012E)
  0x85, 0x6E, 0xFC, 0x06, 0xD2, 0x06, 0x0C, 0x20, 0x60, 0xC2, 0x06, 0x0C, 0x20, 0x60, 0xC2, 0x06,
  0x0C, 0x28, 0x93, 0x6D, 0x06, 0xEF, 0xC0, 0xA1, 0x03, 0xC3, 0x81, 0xAC, 0x30,
  // "į" (U+012F)
  0x10, 0x90, 0x72, 0x07, 0x05, 0x58, 0x17, 0xF8, 0x20, 0x90, 0x82, 0x09, 0x08, 0x20, 0x90, 0x82,
  0x09, 0x08, 0x28, 0x29, 0x90, 0x8A, 0x85, 0x80, 0xA1, 0x03, 0xC3, 0x81, 0xAC, 0x30,
  // "İ" (U+0130)
  0x10, 0x40, 0x82, 0x06, 0x0A, 0x58, 0x56, 0xEF, 0xC0, 0x6D, 0x20, 0x60, 0xC2, 0x06, 0x0C, 0x20,
  0x60, 0xC2, 0x06, 0x0C, 0x20, 0x60, 0xC2, 0x85, 0x6D, 0x06, 0xEF, 0xC0,
  // "ı" (U+0131)
  0x81, 0x7F, 0x82, 0x09, 0x08, 0x20, 0x90, 0x82, 0x09, 0x08, 0x20, 0x90, 0x82, 0x82, 0x99, 0x08,
  0xA0, 0x80,
  // "Ĳ" (U+0132)
  0x89, 0x16, 0xEF, 0xC6, 0xEF, 0xC0, 0x6D, 0x20, 0x60, 0xD2, 0x06, 0x0C, 0x20, 0x60, 0xC2, 0x06,
  0x0C, 0x20, 0x60, 0xC2, 0x06, 0x0C, 0x20, 0x60, 0xC2, 0x06, 0x0C, 0x20, 0x60, 0xC2, 0x06, 0x0C,
  0x20, 0x60, 0xC2, 0x06, 0x0D, 0x28, 0x90, 0x6C, 0x06, 0xEF, 0xC0, 0x6C, 0x60, 0x60, 0xC6, 0x0A,
  0x08, 0x48, 0x21, 0xCA, 0x11,
  // "ĳ" (U+0133)
  0x10, 0x90, 0x72, 0x83, 0xB5, 0x07, 0x52, 0x09, 0x04, 0x78, 0x90, 0x7F, 0x80, 0x9F, 0x60, 0x98,
  0x28, 0x3B, 0x60, 0x98, 0x28, 0x3A, 0x60, 0x98, 0x28, 0x3A, 0x60, 0x98, 0x28, 0x3A, 0x60, 0x99,
  0x28, 0x1A, 0x68, 0xA8, 0x28, 0x0A, 0x65, 0x0B, 0x05, 0x50, 0xE0, 0x33, 0x81, 0x1D, 0x81,
  // "Ĵ" (U+0134)
  0x28, 0x69, 0xE2, 0x04, 0x82, 0x96, 0x82, 0x6E, 0xFC, 0x20, 0x60, 0xD3, 0x06, 0x0C, 0x30, 0x60,
  0xC3, 0x06, 0x0C, 0x30, 0x60, 0xC3, 0x06, 0x0C, 0x30, 0x60, 0xC3, 0x06, 0x0C, 0x30, 0x60, 0xC3,
  0x85, 0xA8, 0x01, 0xCA, 0x11,
  // "ĵ" (U+0135)
  0x18, 0x59, 0xE2, 0x48, 0x29, 0x58, 0x19, 0xF6, 0x20, 0xB0, 0x62, 0x0A, 0x06, 0x20, 0xA0, 0x62,
  0x0A, 0x06, 0x20, 0xA0, 0x62, 0x0A, 0x06, 0x20, 0xB0, 0x52, 0x83, 0xE3, 0x1D, 0x81,
  // "Ķ" (U+0136)
  0x86, 0x6E, 0xFC, 0x08, 0xFD, 0x20, 0x60, 0xD2, 0x04, 0x0B, 0x38, 0x36, 0xC0, 0x1A, 0x48, 0x36,
  0xC0, 0xB1, 0x48, 0x36, 0xCA, 0xF2, 0x48, 0x36, 0xE2, 0xAD, 0x48, 0x46, 0xC0, 0x1E, 0x93, 0x06,
  0x0D, 0x28, 0x65, 0xF6, 0x06, 0xEF, 0xC2, 0x81, 0x8E, 0x77, 0x50, 0x08, 0x70, 0xA0, 0x14,
  // "ķ" (U+0137)
  0x81, 0x9F, 0x65, 0x0B, 0x06, 0x50, 0xA0, 0x65, 0x89, 0x2A, 0x60, 0xDF, 0x70, 0xA6, 0x0A, 0x52,
  0x82, 0xA6, 0x86, 0x38, 0x2A, 0xCE, 0x73, 0x83, 0xA7, 0x3F, 0x22, 0x89, 0x3B, 0x70, 0x9C, 0x09,
  0xFE, 0x51, 0xCD, 0x73, 0x00, 0x85, 0x0A, 0x01, 0x20,
  // "ĸ" (U+0138)
  0x89, 0x39, 0xF6, 0x0D, 0xF7, 0x0B, 0x60, 0xA5, 0x28, 0x2A, 0x68, 0x63, 0x82, 0xAC, 0xE7, 0x38,
  0x3A, 0x73, 0xF2, 0x28, 0x93, 0xB7, 0x09, 0xC0, 0x9F, 0xE5, 0x1C, 0xD0,
  // "Ĺ" (U+0139)
  0x20, 0xB0, 0x74, 0x04, 0x08, 0x74, 0x82, 0x4D, 0xF9, 0x40, 0x60, 0xC5, 0x06, 0x0C, 0x50, 0x60,
  0xC5, 0x06, 0x0C, 0x50, 0x60, 0xC5, 0x06, 0x0C, 0x38, 0x27, 0x06, 0xC3, 0x86, 0xB4, 0xDE, 0x88,
  0xAE,
  // "ĺ" (U+013A)
  0x28, 0x7B, 0x70, 0x48, 0x0A, 0xF6, 0x20, 0xB0, 0x62, 0x0A, 0x06, 0x20, 0xA0, 0x62, 0x0A, 0x06,
  0x20, 0xA0, 0x62, 0x0A, 0x06, 0x20, 0xA0, 0x62, 0x85, 0xB7, 0x0A, 0xFE, 0x60,
  // "Ļ" (U+013B)
  0x82, 0x4D, 0xF9, 0x40, 0x60, 0xC5, 0x06, 0x0C, 0x50, 0x60, 0xC5, 0x06, 0x0C, 0x50, 0x60, 0xC5,
  0x06, 0x0C, 0x38, 0x27, 0x06, 0xC3, 0x86, 0xB4, 0xDE, 0x88, 0xAE, 0x73, 0x00, 0x85, 0x0A, 0x01,
  0x20,
  // "ļ" (U+013C)
  0x81, 0xAF, 0x62, 0x0B, 0x06, 0x20, 0xA0, 0x62, 0x0A, 0x06, 0x20, 0xA0, 0x62, 0x0A, 0x06, 0x20,
  0xA0, 0x62, 0x0A, 0x06, 0x28, 0x5B, 0x70, 0xAF, 0xE6, 0x50, 0x08, 0x20, 0xA0, 0x11,
  // "Ľ" (U+013D)
  0x89, 0x04, 0xDF, 0x90, 0xA4, 0x06, 0xC2, 0x09, 0x20, 0x60, 0xC5, 0x06, 0x0C, 0x50, 0x60, 0xC5,
  0x06, 0x0C, 0x50, 0x60, 0xC3, 0x82, 0x70, 0x6C, 0x38, 0x6B, 0x4D, 0xE8, 0x8A, 0xE0,
  // "ľ" (U+013E)
  0x87, 0xAF, 0x69, 0x50, 0xB6, 0x92, 0x0A, 0x06, 0x30, 0xA0, 0x63, 0x0A, 0x06, 0x30, 0xA0, 0x63,
  0x0A, 0x06, 0x30, 0xA0, 0x63, 0x0B, 0x07, 0x28, 0x2A, 0xFE, 0x61,
  // "Ŀ" (U+013F)
  0x82, 0x4D, 0xF9, 0x40, 0x60, 0xC5, 0x06, 0x0C, 0x50, 0x60, 0xC2, 0x83, 0x48, 0x06, 0xC2, 0x83,
  0x6A, 0x06, 0xC5, 0x06, 0x0C, 0x38, 0x27, 0x06, 0xC3, 0x86, 0xB4, 0xDE, 0x88, 0xAE,
  // "ŀ" (U+0140)
  0x81, 0xAF, 0x63, 0x0B, 0x06, 0x30, 0xA0, 0x63, 0x0A, 0x06, 0x38, 0x92, 0xA6, 0x48, 0x0A, 0x66,
  0xA0, 0xA6, 0x30, 0xA0, 0x63, 0x0B, 0x07, 0x28, 0x2A, 0xFE, 0x61,
  // "Ł" (U+0141)
  0x82, 0x4D, 0xF9, 0x40, 0x60, 0xC5, 0x06, 0x0C, 0x58, 0x26, 0xC6, 0x73, 0x81, 0x7E, 0x43, 0x81,
  0x5B, 0xC5, 0x06, 0x0C, 0x38, 0x27, 0x06, 0xC3, 0x86, 0xB4, 0xDE, 0x88, 0xAE,
  // "ł" (U+0142)
  0x81, 0x8F, 0x92, 0x08, 0x09, 0x20, 0x80, 0x92, 0x08, 0x09, 0x28, 0x90, 0x8A, 0x50, 0xAC, 0x25,
  0xB9, 0x20, 0x80, 0x92, 0x82, 0x8A, 0x08, 0xA0, 0x90,
  // "Ń" (U+0143)
  0x50, 0xB0, 0x76, 0x04, 0x08, 0x75, 0x89, 0x36, 0xEE, 0x10, 0x2D, 0xFA, 0x06, 0xF9, 0x20, 0x10,
  0xB2, 0x82, 0x69, 0xF3, 0x20, 0xA2, 0x82, 0x65, 0xAC, 0x20, 0xA2, 0x85, 0x65, 0x1E, 0x70, 0xA2,
  0x85, 0x65, 0x06, 0xF2, 0xA2, 0x06, 0x05, 0x28, 0x1B, 0xCA, 0x20, 0x60, 0x52, 0x86, 0x2F, 0xA0,
  0x6E, 0xE5, 0x20, 0x70, 0xA1,
  // "ń" (U+0144)
  0x40, 0xB0, 0x75, 0x04, 0x08, 0x74, 0x84, 0x7F, 0x79, 0xCA, 0x30, 0x90, 0xC2, 0x0D, 0x04, 0x20,
  0x09, 0x20, 0xA0, 0x62, 0x09, 0x08, 0x20, 0xA0, 0x62, 0x09, 0x08, 0x20, 0xA0, 0x62, 0x00, 0x92,
  0x82, 0xA7, 0x08, 0xA8, 0x36, 0x0A, 0xE4,
  // "Ņ" (U+0145)
  0x89, 0x36, 0xEE, 0x10, 0x2D, 0xFA, 0x06, 0xF9, 0x20, 0x10, 0xB2, 0x82, 0x69, 0xF3, 0x20, 0xA2,
  0x82, 0x65, 0xAC, 0x20, 0xA2, 0x85, 0x65, 0x1E, 0x70, 0xA2, 0x85, 0x65, 0x06, 0xF2, 0xA2, 0x06,
  0x05, 0x28, 0x1B, 0xCA, 0x20, 0x60, 0x52, 0x86, 0x2F, 0xA0, 0x6E, 0xE5, 0x20, 0x70, 0xA7, 0x70,
  0x08, 0x70, 0xA0, 0x13,
  // "ņ" (U+0146)
  0x84, 0x7F, 0x79, 0xCA, 0x30, 0x90, 0xC2, 0x0D, 0x04, 0x20, 0x09, 0x20, 0xA0, 0x62, 0x09, 0x08,
  0x20, 0xA0, 0x62, 0x09, 0x08, 0x20, 0xA0, 0x62, 0x00, 0x92, 0x82, 0xA7, 0x08, 0xA8, 0x36, 0x0A,
  0xE4, 0x74, 0x00, 0x86, 0x0A, 0x01, 0x30,
  // "Ň" (U+0147)
  0x38, 0x24, 0x82, 0xA6, 0x81, 0x9E, 0x27, 0x48, 0x93, 0x6E, 0xE1, 0x02, 0xDF, 0xA0, 0x6F, 0x92,
  0x01, 0x0B, 0x28, 0x26, 0x9F, 0x32, 0x0A, 0x28, 0x26, 0x5A, 0xC2, 0x0A, 0x28, 0x56, 0x51, 0xE7,
  0x0A, 0x28, 0x56, 0x50, 0x6F, 0x2A, 0x20, 0x60, 0x52, 0x81, 0xBC, 0xA2, 0x06, 0x05, 0x28, 0x62,
  0xFA, 0x06, 0xEE, 0x52, 0x07, 0x0A, 0x10,
  // "ň" (U+0148)
  0x28, 0x24, 0x82, 0xA5, 0x81, 0x9E, 0x27, 0x38, 0x47, 0xF7, 0x9C, 0xA3, 0x09, 0x0C, 0x20, 0xD0,
  0x42, 0x00, 0x92, 0x0A, 0x06, 0x20, 0x90, 0x82, 0x0A, 0x06, 0x20, 0x90, 0x82, 0x0A, 0x06, 0x20,
  0x09, 0x28, 0x2A, 0x70, 0x8A, 0x83, 0x60, 0xAE, 0x40,
  // "ŉ" (U+0149)
  0x81, 0x3E, 0x27, 0x81, 0x1C, 0x47, 0x18, 0x59, 0x8F, 0x79, 0xCA, 0x28, 0x34, 0x10, 0x9C, 0x20,
  0xD0, 0x44, 0x00, 0x92, 0x0A, 0x06, 0x40, 0x90, 0x82, 0x0A, 0x06, 0x40, 0x90, 0x82, 0x0A, 0x06,
  0x40, 0x09, 0x20, 0xA0, 0x73, 0x08, 0xA8, 0x36, 0x0A, 0xE4,
  // "Ŋ" (U+014A)
  0x89, 0x36, 0xEE, 0x10, 0x2D, 0xFA, 0x06, 0xF9, 0x20, 0x10, 0xB2, 0x82, 0x69, 0xF4, 0x20, 0xA2,
  0x82, 0x65, 0xAD, 0x20, 0xA2, 0x85, 0x65, 0x1E, 0x80, 0xA2, 0x85, 0x65, 0x05, 0xF3, 0xA2, 0x06,
  0x05, 0x28, 0x1A, 0xDA, 0x20, 0x60, 0x52, 0x86, 0x1E, 0xA0, 0x6E, 0xE5, 0x20, 0x50, 0xA7, 0x01,
  0x0A, 0x70, 0x40, 0x86, 0x81, 0x5C, 0x21,
  // "ŋ" (U+014B)
  0x84, 0x7F, 0x79, 0xCA, 0x20, 0x90, 0xC2, 0x83, 0xD4, 0x09, 0x92, 0x83, 0xA6, 0x09, 0x82, 0x83,
  0xA6, 0x09, 0x82, 0x83, 0xA6, 0x09, 0x92, 0x81, 0xA6, 0x8A, 0x82, 0x70, 0xA6, 0x50, 0xB0, 0x65,
  0x0D, 0x03, 0x40, 0xC0, 0x91,
  // "Ō" (U+014C)
  0x20, 0x60, 0xFB, 0x77, 0x83, 0x7C, 0xBC, 0x53, 0x08, 0x0C, 0x28, 0x11, 0xD6, 0x29, 0x04, 0x38,
  0x46, 0xD0, 0x3F, 0x13, 0x82, 0x3F, 0x14, 0x94, 0x84, 0x2F, 0x33, 0xF1, 0x38, 0x43, 0xF1, 0x0F,
  0x43, 0x06, 0x0D, 0x20, 0x80, 0xC2, 0x81, 0x1D, 0x63, 0x83, 0x7C, 0xCC, 0x52,
  // "ō" (U+014D)
  0x10, 0x60, 0xFB, 0x73, 0x83, 0x3B, 0xBB, 0x22, 0x86, 0xE3, 0x05, 0xC0, 0x3E, 0x39, 0x81, 0x24,
  0xD3, 0x82, 0xE3, 0x3E, 0x39, 0x85, 0x20, 0xD3, 0x04, 0xD2, 0x83, 0x3B, 0xBB, 0x31,
  // "Ŏ" (U+014E)
  0x20, 0x12, 0x01, 0x58, 0x26, 0x40, 0x96, 0x81, 0xAB, 0x37, 0x78, 0x37, 0xCB, 0xC5, 0x30, 0x80,
  0xC2, 0x81, 0x1D, 0x62, 0x90, 0x43, 0x84, 0x6D, 0x03, 0xF1, 0x38, 0x23, 0xF1, 0x49, 0x48, 0x42,
  0xF3, 0x3F, 0x13, 0x84, 0x3F, 0x10, 0xF4, 0x30, 0x60, 0xD2, 0x08, 0x0C, 0x28, 0x11, 0xD6, 0x38,
  0x37, 0xCC, 0xC5, 0x20,
  // "ŏ" (U+014F)
  0x10, 0x12, 0x01, 0x38, 0x26, 0x40, 0x94, 0x81, 0xAB, 0x37, 0x38, 0x33, 0xBB, 0xB2, 0x28, 0x6E,
  0x30, 0x5C, 0x03, 0xE3, 0x98, 0x12, 0x4D, 0x38, 0x2E, 0x33, 0xE3, 0x98, 0x52, 0x0D, 0x30, 0x4D,
  0x28, 0x33, 0xBB, 0xB3, 0x10,
  // "Ő" (U+0150)
  0x38, 0x2C, 0x69, 0x94, 0x82, 0x48, 0x2A, 0x77, 0x83, 0x7C, 0xBC, 0x53, 0x08, 0x0C, 0x28, 0x11,
  0xD6, 0x29, 0x04, 0x38, 0x46, 0xD0, 0x3F, 0x13, 0x82, 0x3F, 0x14, 0x94, 0x84, 0x2F, 0x33, 0xF1,
  0x38, 0x43, 0xF1, 0x0F, 0x43, 0x06, 0x0D, 0x20, 0x80, 0xC2, 0x81, 0x1D, 0x63, 0x83, 0x7C, 0xCC,
  0x52,
  // "ő" (U+0151)
  0x28, 0x2C, 0x69, 0x92, 0x82, 0x48, 0x2A, 0x73, 0x83, 0x3B, 0xBB, 0x22, 0x86, 0xE3, 0x05, 0xC0,
  0x3E, 0x39, 0x81, 0x24, 0xD3, 0x82, 0xE3, 0x3E, 0x39, 0x85, 0x20, 0xD3, 0x04, 0xD2, 0x83, 0x3B,
  0xBB, 0x31,
  // "Œ" (U+0152)
  0x28, 0x92, 0x7C, 0xBE, 0xEB, 0xBE, 0x80, 0x8C, 0x20, 0x50, 0xD2, 0x83, 0x38, 0x0F, 0x42, 0x05,
  0x0D, 0x38, 0x23, 0x3F, 0x12, 0x05, 0x0D, 0x40, 0x49, 0x38, 0x75, 0xE9, 0x97, 0x03, 0xF1, 0x20,
  0x50, 0xD5, 0x90, 0x42, 0x05, 0x0D, 0x38, 0x21, 0x08, 0xB2, 0x05, 0x0D, 0x30, 0xB2, 0x87, 0x7B,
  0x9C, 0xE9, 0x9B, 0xE0,
  // "œ" (U+0153)
  0x18, 0x73, 0xBB, 0xB1, 0x9C, 0xC3, 0x28, 0x92, 0xE3, 0x04, 0xEA, 0x04, 0xD0, 0x3E, 0x39, 0x05,
  0x29, 0x81, 0x24, 0xD3, 0x86, 0xEC, 0xBB, 0xD3, 0x3E, 0x39, 0x05, 0x58, 0x4D, 0x30, 0x5F, 0xA2,
  0x04, 0x28, 0x73, 0xBC, 0xB3, 0x9C, 0xB7, 0x10,
  // "Ŕ" (U+0154)
  0x40, 0xB0, 0x75, 0x04, 0x08, 0x74, 0x85, 0x6E, 0xEB, 0xC9, 0x12, 0x06, 0x0C, 0x20, 0xB0, 0x82,
  0x06, 0x0C, 0x20, 0x80, 0xB2, 0x06, 0x0C, 0x20, 0xC0, 0x52, 0x83, 0x6E, 0xCF, 0x53, 0x83, 0x6C,
  0x0D, 0x93, 0x84, 0x6C, 0x04, 0xF3, 0x20, 0x60, 0xD2, 0x89, 0x1B, 0xC0, 0x6E, 0xFC, 0x02, 0xCC,
  // "ŕ" (U+0155)
  0x30, 0xB0, 0x73, 0x04, 0x08, 0x71, 0x89, 0x57, 0xF6, 0xAE, 0x40, 0x9D, 0x07, 0x30, 0x99, 0x40,
  0x90, 0x84, 0x09, 0x08, 0x40, 0x09, 0x30, 0x7A, 0x0A, 0x20,
  // "Ŗ" (U+0156)
  0x85, 0x6E, 0xEB, 0xC9, 0x12, 0x06, 0x0C, 0x20, 0xB0, 0x82, 0x06, 0x0C, 0x20, 0x80, 0xB2, 0x06,
  0x0C, 0x20, 0xC0, 0x52, 0x83, 0x6E, 0xCF, 0x53, 0x83, 0x6C, 0x0D, 0x93, 0x84, 0x6C, 0x04, 0xF3,
  0x20, 0x60, 0xD2, 0x89, 0x1B, 0xC0, 0x6E, 0xFC, 0x02, 0xCC, 0x74, 0x00, 0x86, 0x0A, 0x01, 0x30,
  // "ŗ" (U+0157)
  0x89, 0x57, 0xF6, 0xAE, 0x40, 0x9D, 0x07, 0x30, 0x99, 0x40, 0x90, 0x84, 0x09, 0x08, 0x40, 0x09,
  0x30, 0x7A, 0x0A, 0x72, 0x00, 0x84, 0x0A, 0x01, 0x30,
  // "Ř" (U+0158)
  0x18, 0x24, 0x82, 0xA5, 0x81, 0x9E, 0x27, 0x48, 0x56, 0xEE, 0xBC, 0x91, 0x20, 0x60, 0xC2, 0x0B,
  0x08, 0x20, 0x60, 0xC2, 0x08, 0x0B, 0x20, 0x60, 0xC2, 0x0C, 0x05, 0x28, 0x36, 0xEC, 0xF5, 0x38,
  0x36, 0xC0, 0xD9, 0x38, 0x46, 0xC0, 0x4F, 0x32, 0x06, 0x0D, 0x28, 0x91, 0xBC, 0x06, 0xEF, 0xC0,
  0x2C, 0xC0,
  // "ř" (U+0159)
  0x82, 0x48, 0x2A, 0x38, 0x19, 0xE2, 0x71, 0x89, 0x57, 0xF6, 0xAE, 0x40, 0x9D, 0x07, 0x30, 0x99,
  0x40, 0x90, 0x84, 0x09, 0x08, 0x40, 0x09, 0x30, 0x7A, 0x0A, 0x20,
  // "Ś" (U+015A)
  0x30, 0xB0, 0x73, 0x04, 0x08, 0x72, 0x89, 0x35, 0xCC, 0xB2, 0x2E, 0x10, 0x97, 0x3E, 0x20, 0x12,
  0x0D, 0x09, 0x48, 0x21, 0x9E, 0x74, 0x83, 0x2C, 0x91, 0x42, 0x82, 0x4D, 0x5C, 0x28, 0x67, 0xA0,
  0xAC, 0xBA, 0x10,
  // "ś" (U+015B)
  0x30, 0xB0, 0x72, 0x04, 0x08, 0x78, 0x92, 0xAB, 0xD4, 0x4A, 0x05, 0x62, 0xD3, 0x38, 0xA1, 0x3C,
  0xB2, 0x01, 0x06, 0xB6, 0x70, 0x3C, 0x2C, 0xBC, 0x30,
  // "Ŝ" (U+015C)
  0x28, 0x19, 0xE2, 0x28, 0x24, 0x82, 0x97, 0x18, 0x93, 0x5C, 0xCB, 0x22, 0xE1, 0x09, 0x73, 0xE2,
  0x01, 0x20, 0xD0, 0x94, 0x82, 0x19, 0xE7, 0x48, 0x32, 0xC9, 0x14, 0x28, 0x24, 0xD5, 0xC2, 0x86,
  0x7A, 0x0A, 0xCB, 0xA1,
  // "ŝ" (U+015D)
  0x28, 0x69, 0xE2, 0x04, 0x82, 0x96, 0x89, 0x2A, 0xBD, 0x44, 0xA0, 0x56, 0x2D, 0x33, 0x8A, 0x13,
  0xCB, 0x20, 0x10, 0x6B, 0x67, 0x03, 0xC2, 0xCB, 0xC3,
  // "Ş" (U+015E)
  0x18, 0x93, 0x5C, 0xCB, 0x22, 0xE1, 0x09, 0x73, 0xE2, 0x01, 0x20, 0xD0, 0x94, 0x82, 0x19, 0xE7,
  0x48, 0x32, 0xC9, 0x14, 0x28, 0x24, 0xD5, 0xC2, 0x86, 0x7A, 0x0A, 0xCB, 0xA1, 0x20, 0x06, 0x50,
  0xD0, 0x22, 0x81, 0x3B, 0xA2,
  // "ş" (U+015F)
  0x18, 0x92, 0xAB, 0xD4, 0x4A, 0x05, 0x62, 0xD3, 0x38, 0xA1, 0x3C, 0xB2, 0x01, 0x06, 0xB6, 0x70,
  0x3C, 0x2C, 0xBC, 0x32, 0x00, 0x64, 0x84, 0xD2, 0x03, 0xBA, 0x10,
  // "Š" (U+0160)
  0x18, 0x24, 0x82, 0xA3, 0x81, 0x9E, 0x27, 0x18, 0x93, 0x5C, 0xCB, 0x22, 0xE1, 0x09, 0x73, 0xE2,
  0x01, 0x20, 0xD0, 0x94, 0x82, 0x19, 0xE7, 0x48, 0x32, 0xC9, 0x14, 0x28, 0x24, 0xD5, 0xC2, 0x86,
  0x7A, 0x0A, 0xCB, 0xA1,
  // "š" (U+0161)
  0x18, 0x24, 0x82, 0xA2, 0x81, 0x9E, 0x26, 0x89, 0x2A, 0xBD, 0x44, 0xA0, 0x56, 0x2D, 0x33, 0x8A,
  0x13, 0xCB, 0x20, 0x10, 0x6B, 0x67, 0x03, 0xC2, 0xCB, 0xC3,
  // "Ţ" (U+0162)
  0x87, 0xBD, 0xBF, 0xCC, 0xF1, 0xB2, 0x84, 0xE4, 0x0A, 0x12, 0x28, 0x2E, 0x40, 0x24, 0x0E, 0x04,
  0x60, 0xE0, 0x46, 0x0E, 0x04, 0x60, 0xE0, 0x46, 0x0E, 0x04, 0x48, 0x32, 0xDF, 0xE6, 0x50, 0x06,
  0x70, 0xC0, 0x34, 0x81, 0x2B, 0xA3,
  // "ţ" (U+0163)
  0x10, 0x02, 0x28, 0x11, 0xB4, 0x28, 0x28, 0xFC, 0x92, 0x0D, 0x04, 0x30, 0xD0, 0x43, 0x0D, 0x04,
  0x30, 0xD0, 0x43, 0x0C, 0x05, 0x38, 0x16, 0xDA, 0x30, 0x06, 0x48, 0x4C, 0x30, 0x2B, 0xA1,
  // "Ť" (U+0164)
  0x18, 0x24, 0x82, 0xA5, 0x81, 0x9E, 0x27, 0x48, 0x7B, 0xDB, 0xFC, 0xCF, 0x1B, 0x28, 0x4E, 0x40,
  0xA1, 0x22, 0x82, 0xE4, 0x02, 0x40, 0xE0, 0x46, 0x0E, 0x04, 0x60, 0xE0, 0x46, 0x0E, 0x04, 0x60,
  0xE0, 0x44, 0x83, 0x2D, 0xFE, 0x62,
  // "ť" (U+0165)
  0x38, 0x90, 0x95, 0x04, 0x29, 0x01, 0xC4, 0x28, 0x28, 0xFC, 0x92, 0x0D, 0x04, 0x30, 0xD0, 0x43,
  0x0D, 0x04, 0x30, 0xD0, 0x43, 0x0C, 0x05, 0x38, 0x16, 0xDA, 0x10,
  // "Ŧ" (U+0166)
  0x87, 0xBD, 0xBF, 0xCC, 0xF1, 0xB2, 0x84, 0xE4, 0x0A, 0x12, 0x28, 0x2E, 0x40, 0x14, 0x0E, 0x04,
  0x48, 0x4A, 0xBF, 0xCB, 0x34, 0x0E, 0x04, 0x60, 0xE0, 0x46, 0x0E, 0x04, 0x48, 0x32, 0xDF, 0xE6,
  0x20,
  // "ŧ" (U+0167)
  0x18, 0xA4, 0x22, 0x01, 0xB4, 0x08, 0xFC, 0x90, 0xD4, 0x07, 0xFC, 0x80, 0xD4, 0x20, 0xD0, 0x42,
  0x0C, 0x05, 0x28, 0x15, 0xDA,
  // "Ũ" (U+0168)
  0x28, 0x31, 0xBA, 0x36, 0x48, 0x35, 0x16, 0xC4, 0x74, 0x0A, 0xA8, 0x78, 0x07, 0xFE, 0x50, 0xB8,
  0x30, 0x70, 0x42, 0x0A, 0x08, 0x30, 0x70, 0x42, 0x0A, 0x08, 0x30, 0x70, 0x42, 0x0A, 0x08, 0x30,
  0x70, 0x42, 0x0A, 0x08, 0x30, 0x70, 0x42, 0x0A, 0x08, 0x30, 0x70, 0x32, 0x06, 0x0D, 0x30, 0xB0,
  0x13, 0x83, 0x8C, 0xBB, 0x42,
  // "ũ" (U+0169)
  0x18, 0x31, 0xBA, 0x36, 0x38, 0x35, 0x16, 0xC4, 0x73, 0x85, 0x9F, 0x60, 0xAF, 0x52, 0x0B, 0x06,
  0x20, 0xD0, 0x52, 0x0A, 0x06, 0x20, 0xC0, 0x52, 0x0A, 0x06, 0x20, 0xC0, 0x52, 0x0A, 0x06, 0x20,
  0xC0, 0x52, 0x84, 0x89, 0x02, 0xF5, 0x28, 0x52, 0xCB, 0x9A, 0xE4,
  // "Ū" (U+016A)
  0x20, 0x60, 0xFB, 0x75, 0x0A, 0xA8, 0x78, 0x07, 0xFE, 0x50, 0xB8, 0x30, 0x70, 0x42, 0x0A, 0x08,
  0x30, 0x70, 0x42, 0x0A, 0x08, 0x30, 0x70, 0x42, 0x0A, 0x08, 0x30, 0x70, 0x42, 0x0A, 0x08, 0x30,
  0x70, 0x42, 0x0A, 0x08, 0x30, 0x70, 0x32, 0x06, 0x0D, 0x30, 0xB0, 0x13, 0x83, 0x8C, 0xBB, 0x42,
  // "ū" (U+016B)
  0x10, 0x60, 0xFB, 0x74, 0x85, 0x9F, 0x60, 0xAF, 0x52, 0x0B, 0x06, 0x20, 0xD0, 0x52, 0x0A, 0x06,
  0x20, 0xC0, 0x52, 0x0A, 0x06, 0x20, 0xC0, 0x52, 0x0A, 0x06, 0x20, 0xC0, 0x52, 0x84, 0x89, 0x02,
  0xF5, 0x28, 0x52, 0xCB, 0x9A, 0xE4,
  // "Ŭ" (U+016C)
  0x20, 0x12, 0x01, 0x58, 0x26, 0x40, 0x96, 0x81, 0xAB, 0x37, 0x50, 0xAA, 0x87, 0x80, 0x7F, 0xE5,
  0x0B, 0x83, 0x07, 0x04, 0x20, 0xA0, 0x83, 0x07, 0x04, 0x20, 0xA0, 0x83, 0x07, 0x04, 0x20, 0xA0,
  0x83, 0x07, 0x04, 0x20, 0xA0, 0x83, 0x07, 0x04, 0x20, 0xA0, 0x83, 0x07, 0x03, 0x20, 0x60, 0xD3,
  0x0B, 0x01, 0x38, 0x38, 0xCB, 0xB4, 0x20,
  // "ŭ" (U+016D)
  0x20, 0x12, 0x01, 0x48, 0x26, 0x40, 0x95, 0x81, 0xAB, 0x37, 0x38, 0x59, 0xF6, 0x0A, 0xF5, 0x20,
  0xB0, 0x62, 0x0D, 0x05, 0x20, 0xA0, 0x62, 0x0C, 0x05, 0x20, 0xA0, 0x62, 0x0C, 0x05, 0x20, 0xA0,
  0x62, 0x0C, 0x05, 0x28, 0x48, 0x90, 0x2F, 0x52, 0x85, 0x2C, 0xB9, 0xAE, 0x40,
  // "Ů" (U+016E)
  0x28, 0x21, 0xBB, 0x15, 0x82, 0x65, 0x56, 0x58, 0x21, 0xBB, 0x13, 0x0A, 0xA8, 0x78, 0x07, 0xFE,
  0x50, 0xB8, 0x30, 0x70, 0x42, 0x0A, 0x08, 0x30, 0x70, 0x42, 0x0A, 0x08, 0x30, 0x70, 0x42, 0x0A,
  0x08, 0x30, 0x70, 0x42, 0x0A, 0x08, 0x30, 0x70, 0x42, 0x0A, 0x08, 0x30, 0x70, 0x32, 0x06, 0x0D,
  0x30, 0xB0, 0x13, 0x83, 0x8C, 0xBB, 0x42,
  // "ů" (U+016F)
  0x28, 0x21, 0xBB, 0x14, 0x82, 0x65, 0x56, 0x48, 0x21, 0xBB, 0x12, 0x85, 0x9F, 0x60, 0xAF, 0x52,
  0x0B, 0x06, 0x20, 0xD0, 0x52, 0x0A, 0x06, 0x20, 0xC0, 0x52, 0x0A, 0x06, 0x20, 0xC0, 0x52, 0x0A,
  0x06, 0x20, 0xC0, 0x52, 0x84, 0x89, 0x02, 0xF5, 0x28, 0x52, 0xCB, 0x9A, 0xE4,
  // "Ű" (U+0170)
  0x38, 0x2C, 0x69, 0x94, 0x82, 0x48, 0x2A, 0x75, 0x0A, 0xA8, 0x78, 0x07, 0xFE, 0x50, 0xB8, 0x30,
  0x70, 0x42, 0x0A, 0x08, 0x30, 0x70, 0x42, 0x0A, 0x08, 0x30, 0x70, 0x42, 0x0A, 0x08, 0x30, 0x70,
  0x42, 0x0A, 0x08, 0x30, 0x70, 0x42, 0x0A, 0x08, 0x30, 0x70, 0x32, 0x06, 0x0D, 0x30, 0xB0, 0x13,
  0x83, 0x8C, 0xBB, 0x42,
  // "ű" (U+0171)
  0x38, 0x2C, 0x69, 0x93, 0x82, 0x48, 0x2A, 0x73, 0x85, 0x9F, 0x60, 0xAF, 0x52, 0x0B, 0x06, 0x20,
  0xD0, 0x52, 0x0A, 0x06, 0x20, 0xC0, 0x52, 0x0A, 0x06, 0x20, 0xC0, 0x52, 0x0A, 0x06, 0x20, 0xC0,
  0x52, 0x84, 0x89, 0x02, 0xF5, 0x28, 0x52, 0xCB, 0x9A, 0xE4,
  // "Ų" (U+0172)
  0x0A, 0xA8, 0x78, 0x07, 0xFE, 0x50, 0xB8, 0x30, 0x70, 0x42, 0x0A, 0x08, 0x30, 0x70, 0x42, 0x0A,
  0x08, 0x30, 0x70, 0x42, 0x0A, 0x08, 0x30, 0x70, 0x42, 0x0A, 0x08, 0x30, 0x70, 0x42, 0x0A, 0x08,
  0x30, 0x70, 0x32, 0x06, 0x0D, 0x30, 0xB0, 0x13, 0x83, 0x8C, 0xBC, 0x46, 0x0A, 0x01, 0x60, 0x30,
  0xC7, 0x18, 0x1A, 0xC3, 0x20,
  // "ų" (U+0173)
  0x85, 0x9F, 0x60, 0xAF, 0x52, 0x0B, 0x06, 0x20, 0xD0, 0x52, 0x0A, 0x06, 0x20, 0xC0, 0x52, 0x0A,
  0x06, 0x20, 0xC0, 0x52, 0x0A, 0x06, 0x20, 0xC0, 0x52, 0x84, 0x89, 0x02, 0xF5, 0x28, 0x52, 0xCB,
  0x9B, 0xE4, 0x40, 0x60, 0x56, 0x0D, 0x02, 0x68, 0x17, 0xC7, 0x10,
  // "Ŵ" (U+0174)
  0x58, 0x19, 0xE2, 0x72, 0x82, 0x48, 0x29, 0x77, 0x48, 0x4B, 0xFE, 0x40, 0x19, 0x28, 0x55, 0xEE,
  0x50, 0xD7, 0x28, 0x15, 0xF4, 0x20, 0x70, 0x62, 0x08, 0x0A, 0x28, 0x19, 0xC9, 0x20, 0xA0, 0x12,
  0x04, 0x0E, 0x28, 0x1B, 0x5D, 0x20, 0xB4, 0x87, 0xE4, 0x19, 0x1F, 0x13, 0x84, 0x87, 0xA8, 0x55,
  0x0C, 0x57, 0x34, 0x86, 0x6C, 0x91, 0x07, 0x9B, 0x58, 0x11, 0xFA, 0x28, 0x13, 0xDA, 0x60, 0xC0,
  0x83, 0x0E, 0x06, 0x30,
  // "ŵ" (U+0175)
  0x48, 0x19, 0xE2, 0x78, 0x24, 0x82, 0x97, 0x71, 0x8A, 0x3D, 0xFC, 0x03, 0xD0, 0x2E, 0xE3, 0x1F,
  0x20, 0x8F, 0x20, 0x65, 0x28, 0x7C, 0x50, 0xA9, 0x70, 0x91, 0x28, 0x67, 0x92, 0x85, 0xC0, 0xA3,
  0x86, 0x3D, 0x63, 0x0E, 0x47, 0x40, 0xE0, 0xA2, 0x81, 0xAC, 0x24, 0x0A, 0x09, 0x20, 0x60, 0xD3,
  // "Ŷ" (U+0176)
  0x38, 0x19, 0xE2, 0x48, 0x24, 0x82, 0x97, 0x38, 0x91, 0xDF, 0xD2, 0x4E, 0xF6, 0x1E, 0x62, 0x06,
  0x08, 0x20, 0x60, 0xD2, 0x0A, 0x48, 0x2C, 0x65, 0x54, 0x81, 0x3D, 0xA6, 0x0D, 0x06, 0x60, 0xC0,
  0x56, 0x0D, 0x06, 0x48, 0x31, 0xCF, 0xE7, 0x20,
  // "ŷ" (U+0177)
  0x28, 0x19, 0xE2, 0x38, 0x24, 0x82, 0x97, 0x28, 0x90, 0xDF, 0xC0, 0x9F, 0xA1, 0xE3, 0x20, 0xD2,
  0x83, 0x98, 0x03, 0x82, 0x83, 0x3E, 0x08, 0x33, 0x81, 0xC4, 0xB4, 0x81, 0x6C, 0x85, 0x0E, 0x03,
  0x40, 0x10, 0xC5, 0x0B, 0x06, 0x38, 0x16, 0xD8, 0x40,
  // "Ÿ" (U+0178)
  0x18, 0x32, 0xB0, 0xD1, 0x48, 0x11, 0x01, 0x38, 0x91, 0xDF, 0xD2, 0x4E, 0xF6, 0x1E, 0x62, 0x06,
  0x08, 0x20, 0x60, 0xD2, 0x0A, 0x48, 0x2C, 0x65, 0x54, 0x81, 0x3D, 0xA6, 0x0D, 0x06, 0x60, 0xC0,
  0x56, 0x0D, 0x06, 0x48, 0x31, 0xCF, 0xE7, 0x20,
  // "Ź" (U+0179)
  0x30, 0xB0, 0x74, 0x04, 0x08, 0x73, 0x87, 0x4E, 0x99, 0xAF, 0x55, 0x62, 0x82, 0x8C, 0x01, 0x28,
  0x12, 0xF4, 0x40, 0xB0, 0xA4, 0x81, 0x4F, 0x24, 0x0D, 0x08, 0x40, 0x60, 0xE3, 0x82, 0x21, 0xE6,
  0x28, 0x72, 0x87, 0xF9, 0x99, 0xC8,
  // "ź" (U+017A)
  0x30, 0xB0, 0x73, 0x04, 0x08, 0x71, 0x89, 0x13, 0xEB, 0xBF, 0x54, 0x40, 0x7C, 0x38, 0x11, 0xE3,
  0x30, 0xA0, 0x93, 0x04, 0x0E, 0x48, 0x91, 0xD5, 0x03, 0x66, 0xFB, 0xBD, 0x60,
  // "Ż" (U+017B)
  0x30, 0x40, 0x85, 0x06, 0x0A, 0x72, 0x87, 0x4E, 0x99, 0xAF, 0x55, 0x62, 0x82, 0x8C, 0x01, 0x28,
  0x12, 0xF4, 0x40, 0xB0, 0xA4, 0x81, 0x4F, 0x24, 0x0D, 0x08, 0x40, 0x60, 0xE3, 0x82, 0x21, 0xE6,
  0x28, 0x72, 0x87, 0xF9, 0x99, 0xC8,
  // "ż" (U+017C)
  0x20, 0x40, 0x84, 0x06, 0x0A, 0x71, 0x89, 0x13, 0xEB, 0xBF, 0x54, 0x40, 0x7C, 0x38, 0x11, 0xE3,
  0x30, 0xA0, 0x93, 0x04, 0x0E, 0x48, 0x91, 0xD5, 0x03, 0x66, 0xFB, 0xBD, 0x60,
  // "Ž" (U+017D)
  0x18, 0x24, 0x82, 0xA4, 0x81, 0x9E, 0x27, 0x28, 0x74, 0xE9, 0x9A, 0xF5, 0x56, 0x28, 0x28, 0xC0,
  0x12, 0x81, 0x2F, 0x44, 0x0B, 0x0A, 0x48, 0x14, 0xF2, 0x40, 0xD0, 0x84, 0x06, 0x0E, 0x38, 0x22,
  0x1E, 0x62, 0x87, 0x28, 0x7F, 0x99, 0x9C, 0x80,
  // "ž" (U+017E)
  0x18, 0x24, 0x82, 0xA3, 0x81, 0x9E, 0x27, 0x89, 0x13, 0xEB, 0xBF, 0x54, 0x40, 0x7C, 0x38, 0x11,
  0xE3, 0x30, 0xA0, 0x93, 0x04, 0x0E, 0x48, 0x91, 0xD5, 0x03, 0x66, 0xFB, 0xBD, 0x60,
  // "ſ" (U+017F)
  0x18, 0x92, 0x1B, 0xCC, 0x08, 0x80, 0x90, 0xA6, 0x30, 0xA0, 0x63, 0x0A, 0x06, 0x30, 0xA0, 0x63,
  0x0A, 0x06, 0x30, 0xA0, 0x63, 0x0B, 0x07, 0x28, 0x2A, 0xFE, 0xA1,
  // "Ω" (U+03A9)
  0x28, 0x38, 0xCB, 0xC8, 0x30, 0x0A, 0x38, 0x4A, 0xA0, 0x1F, 0x33, 0x84, 0x3F, 0x23, 0xF1, 0x38,
  0x41, 0xF4, 0x1F, 0x23, 0x84, 0x2F, 0x20, 0xA9, 0x38, 0xA4, 0x9A, 0x01, 0x07, 0xB1, 0xB7, 0x01,
  0x76, 0x08, 0x28, 0x06, 0x76, 0xB0, 0x3B, 0x07,
  // "μ" (U+03BC)
  0x0C, 0x04, 0x29, 0x81, 0x1C, 0x42, 0x98, 0x11, 0xC4, 0x29, 0x81, 0x1C, 0x42, 0x98, 0xA2, 0x1D,
  0x40, 0x1F, 0x1D, 0x70, 0x6F, 0x1C, 0xBB, 0x79, 0xAD, 0x50, 0xE0, 0x54, 0x0A, 0x09, 0x40,
  // "π" (U+03C0)
  0x89, 0x03, 0xBE, 0xBB, 0xEB, 0x50, 0xB2, 0x0A, 0x28, 0x31, 0xA0, 0x1A, 0x28, 0x33, 0xA0, 0x2A,
  0x28, 0x34, 0x90, 0x2A, 0x28, 0x78, 0x70, 0x3B, 0x06, 0xD2, 0x20, 0xD0, 0xA0,
  // "–" (U+2013)
  0x80, 0x2B,
  // "—" (U+2014)
  0x80, 0x90, 0xB0,
  // "€" (U+20AC)
  0x28, 0x95, 0x6C, 0xCB, 0x10, 0x3E, 0x10, 0xA3, 0x08, 0x94, 0x83, 0x6E, 0xDB, 0xB3, 0x0A, 0x07,
  0x48, 0x36, 0xED, 0xB6, 0x30, 0x70, 0xA5, 0x84, 0x2E, 0x30, 0x11, 0x28, 0x34, 0xCB, 0xA1,
  // "₿" (U+20BF)
  0x28, 0x19, 0x53, 0x28, 0x46, 0xFD, 0xCC, 0x22, 0x83, 0xA8, 0x08, 0xB2, 0x83, 0xA8, 0x06, 0xD2,
  0x83, 0xA8, 0x0A, 0x82, 0x83, 0xAD, 0xCD, 0x12, 0x83, 0xA8, 0x05, 0xD2, 0x8A, 0x1A, 0x80, 0x2F,
  0x20, 0xA8, 0x04, 0xF0, 0x6F, 0xDB, 0xC5, 0x38, 0x19, 0x53, 0x20,
  // "‘" (U+2018)
  0x18, 0x91, 0x14, 0x09, 0x04, 0xC1, 0x2E, 0x30,
  // "’" (U+2019)
  0x89, 0x13, 0xE2, 0x1C, 0x40, 0x90, 0x41, 0x10,
  // "‚" (U+201A)
  0x89, 0x13, 0xE2, 0x1C, 0x40, 0x90, 0x41, 0x10,
  // "‛" (U+201B)
  0x86, 0x2E, 0x34, 0xC1, 0x09, 0x20, 0x10, 0x40,
  // "“" (U+201C)
  0x18, 0xA1, 0x14, 0x05, 0x09, 0x07, 0x34, 0xC1, 0xD4, 0x2E, 0x3B, 0x90,
  // "”" (U+201D)
  0x8A, 0x13, 0xE2, 0xC7, 0x1C, 0x47, 0xA0, 0x90, 0x64, 0x41, 0x14, 0x10,
  // "„" (U+201E)
  0x8A, 0x13, 0xE2, 0xC7, 0x1C, 0x47, 0xA0, 0x90, 0x64, 0x41, 0x13, 0x10,
  // "‟" (U+201F)
  0x8A, 0x22, 0xE3, 0xA9, 0x4C, 0x1D, 0x40, 0x90, 0x73, 0x01, 0x40, 0x50,
  // "†" (U+2020)
  0x20, 0xC0, 0x33, 0x89, 0x3B, 0x10, 0x21, 0x91, 0x36, 0x9C, 0x8A, 0x20, 0xD0, 0x43, 0x0E, 0x04,
  0x30, 0xC0, 0x23, 0x0B, 0x01, 0x30, 0xA4, 0x09, 0x40, 0x82,
  // "‡" (U+2021)
  0x20, 0xC0, 0x33, 0x86, 0xA1, 0x07, 0xAB, 0x9C, 0x28, 0x1C, 0x21, 0x20, 0xC0, 0x23, 0x06, 0x40,
  0xB0, 0x23, 0x86, 0xC2, 0x08, 0xBB, 0x9D, 0x20, 0xA0, 0x13, 0x0C, 0x03, 0x10,
  // "•" (U+2022)
  0x83, 0x1C, 0xE4, 0x5A, 0x0A, 0x05, 0xA8, 0x3A, 0x1C, 0xE4,
  // "…" (U+2026)
  0x8A, 0x0B, 0x40, 0x59, 0x01, 0xB2, 0xD5, 0x07, 0xB0, 0x1D, 0x30,
  // "‰" (U+2030)
  0x18, 0x19, 0xC9, 0x20, 0x20, 0x97, 0x86, 0x3C, 0x0C, 0x30, 0x92, 0x78, 0x56, 0xA0, 0x96, 0x1A,
  0x71, 0x8D, 0x36, 0xA0, 0x96, 0x84, 0xAB, 0x40, 0x2B, 0xB2, 0x3D, 0x0D, 0x4A, 0x79, 0x1E, 0x0B,
  0x55, 0xA0, 0x7C, 0x78, 0x4A, 0x60, 0xE2, 0xE1, 0x2D, 0x48, 0x91, 0xB0, 0xA5, 0x0D, 0x2E, 0x12,
  0xE3, 0x89, 0x27, 0x50, 0x78, 0x1E, 0x0B, 0x45, 0xB3, 0x0B, 0x28, 0x71, 0xBC, 0x60, 0x3C, 0xC3,
  // "‹" (U+2039)
  0x28, 0x90, 0xA0, 0x97, 0x2F, 0x10, 0x97, 0x20, 0xA0,
  // "›" (U+203A)
  0x0A, 0x28, 0x90, 0x79, 0x01, 0xF2, 0x79, 0x0A, 0x20,
  // "⁄" (U+2044)
  0x30, 0x20, 0xA3, 0x09, 0x03, 0x20, 0x10, 0xA3, 0x08, 0x03, 0x20, 0x10, 0xB3, 0x07, 0x04, 0x30,
  0xB3, 0x06, 0x05, 0x30, 0xB4,
  // "™" (U+2122)
  0x84, 0x67, 0x87, 0x66, 0x28, 0x91, 0xA2, 0x24, 0x72, 0x4B, 0x04, 0xC2, 0x86, 0x47, 0x04, 0x74,
  0x5B, 0x28, 0x64, 0x70, 0x42, 0xB4, 0xB2, 0x87, 0x68, 0x06, 0x36, 0x19, 0x20,
  // "⅒" (U+2152)
  0x20, 0x33, 0x02, 0x0A, 0x60, 0x20, 0x79, 0x30, 0x90, 0x37, 0x01, 0x92, 0x01, 0x0A, 0x71, 0x01,
  0x92, 0x08, 0x03, 0x71, 0x83, 0x1F, 0x01, 0xB2, 0x8A, 0x23, 0x07, 0x85, 0x01, 0x7A, 0x67, 0x42,
  0x7F, 0x4B, 0x0D, 0x14, 0x0B, 0x28, 0x51, 0xF7, 0x80, 0xB5, 0x30, 0x60, 0x52, 0x85, 0x1F, 0x78,
  0x0B, 0x43, 0x0B, 0x38, 0x51, 0xF4, 0xB0, 0xD1, 0x68, 0x51, 0x7A, 0x77, 0x85, 0x10,
  // "ﬁ" (U+FB01)
  0x28, 0x37, 0xBC, 0xD3, 0x20, 0x40, 0xD2, 0x09, 0x05, 0x20, 0x70, 0x95, 0x85, 0x7D, 0xDB, 0xBD,
  0xA2, 0x08, 0x09, 0x20, 0x70, 0xA2, 0x08, 0x09, 0x20, 0x70, 0xA2, 0x08, 0x09, 0x20, 0x70, 0xA2,
  0x08, 0x09, 0x20, 0x70, 0xA2, 0x08, 0x09, 0x28, 0x27, 0xA0, 0x8A, 0x83, 0x95, 0xEF, 0x90,
  // "ﬂ" (U+FB02)
  0x28, 0x37, 0xBC, 0xF9, 0x20, 0x40, 0xD2, 0x00, 0x92, 0x07, 0x09, 0x28, 0x90, 0x79, 0x07, 0xDD,
  0xB4, 0x79, 0x20, 0x80, 0x92, 0x07, 0x09, 0x20, 0x80, 0x92, 0x07, 0x09, 0x20, 0x80, 0x92, 0x07,
  0x09, 0x20, 0x80, 0x92, 0x07, 0x09, 0x20, 0x80, 0x92, 0x82, 0x8A, 0x08, 0xA0, 0x90, 0x6A, 0x09,
};

const Font& font_NotoSerif_Regular_12() {
  static SmoothFont font(font_NotoSerif_Regular_12_data);
  return font;
}

}  // namespace roo_display
