#include "12.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSans-CondensedBold (Noto Sans Condensed Bold)
// Generated on Thu Mar 30 22:28:37 CEST 2023
static const uint8_t font_NotoSans_CondensedBold_12_data[] PROGMEM = {
  
  // Header
  0x01, 0x01, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x02, 0xB5,
  0xFE, 0xFD, 0x0D, 0x0D, 0x0A, 0xFD, 0x04, 0x01, 0x0E, 0x03, 0x03, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x00, 0x01, 0x02, 0x09, 0x03, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x00, 0x07, 0x04, 0x09, 0x05, 0x00, 0x0F, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x06, 0x09, 0x07, 0x00, 0x18, // "#" (U+0023)
  0x00, 0x24, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x00, 0x36, // "$" (U+0024)
  0x00, 0x25, 0x00, 0x01, 0x09, 0x09, 0x0A, 0x00, 0x56, // "%" (U+0025)
  0x00, 0x26, 0x00, 0x01, 0x07, 0x09, 0x08, 0x00, 0x87, // "&" (U+0026)
  0x00, 0x27, 0x00, 0x07, 0x02, 0x09, 0x03, 0x00, 0xAD, // "'" (U+0027)
  0x00, 0x28, 0x00, 0xFF, 0x03, 0x09, 0x04, 0x00, 0xB3, // "(" (U+0028)
  0x00, 0x29, 0x00, 0xFF, 0x03, 0x09, 0x04, 0x00, 0xCC, // ")" (U+0029)
  0x00, 0x2A, 0x00, 0x05, 0x05, 0x0A, 0x06, 0x00, 0xE5, // "*" (U+002A)
  0x00, 0x2B, 0x00, 0x02, 0x05, 0x07, 0x06, 0x00, 0xF8, // "+" (U+002B)
  0x00, 0x2C, 0x00, 0xFF, 0x02, 0x01, 0x03, 0x01, 0x0A, // "," (U+002C)
  0x00, 0x2D, 0x00, 0x03, 0x03, 0x05, 0x04, 0x01, 0x10, // "-" (U+002D)
  0x00, 0x2E, 0x00, 0x01, 0x02, 0x02, 0x03, 0x01, 0x17, // "." (U+002E)
  0x00, 0x2F, 0x00, 0x01, 0x04, 0x09, 0x05, 0x01, 0x1B, // "/" (U+002F)
  0x00, 0x30, 0x00, 0x01, 0x05, 0x09, 0x06, 0x01, 0x33, // "0" (U+0030)
  0x00, 0x31, 0x00, 0x01, 0x04, 0x09, 0x06, 0x01, 0x50, // "1" (U+0031)
  0x00, 0x32, 0x00, 0x01, 0x05, 0x09, 0x06, 0x01, 0x6B, // "2" (U+0032)
  0x00, 0x33, 0x00, 0x01, 0x05, 0x09, 0x06, 0x01, 0x88, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x01, 0x05, 0x09, 0x06, 0x01, 0xA6, // "4" (U+0034)
  0x00, 0x35, 0x00, 0x01, 0x05, 0x09, 0x06, 0x01, 0xC1, // "5" (U+0035)
  0x00, 0x36, 0x00, 0x01, 0x05, 0x09, 0x06, 0x01, 0xDD, // "6" (U+0036)
  0x00, 0x37, 0x00, 0x01, 0x05, 0x09, 0x06, 0x01, 0xFB, // "7" (U+0037)
  0x00, 0x38, 0x00, 0x01, 0x05, 0x09, 0x06, 0x02, 0x16, // "8" (U+0038)
  0x00, 0x39, 0x00, 0x01, 0x05, 0x09, 0x06, 0x02, 0x34, // "9" (U+0039)
  0x00, 0x3A, 0x00, 0x01, 0x02, 0x07, 0x03, 0x02, 0x51, // ":" (U+003A)
  0x00, 0x3B, 0x00, 0x00, 0x02, 0x07, 0x03, 0x02, 0x5A, // ";" (U+003B)
  0x00, 0x3C, 0x00, 0x02, 0x05, 0x08, 0x06, 0x02, 0x65, // "<" (U+003C)
  0x00, 0x3D, 0x00, 0x03, 0x05, 0x08, 0x06, 0x02, 0x79, // "=" (U+003D)
  0x00, 0x3E, 0x00, 0x02, 0x05, 0x08, 0x06, 0x02, 0x89, // ">" (U+003E)
  0x00, 0x3F, 0x00, 0x01, 0x04, 0x09, 0x05, 0x02, 0x9D, // "?" (U+003F)
  0x00, 0x40, 0x00, 0xFF, 0x08, 0x09, 0x09, 0x02, 0xB4, // "@" (U+0040)
  0x00, 0x41, 0x00, 0x01, 0x06, 0x09, 0x07, 0x02, 0xE5, // "A" (U+0041)
  0x00, 0x42, 0x00, 0x01, 0x06, 0x09, 0x07, 0x03, 0x05, // "B" (U+0042)
  0x00, 0x43, 0x00, 0x01, 0x05, 0x09, 0x06, 0x03, 0x26, // "C" (U+0043)
  0x00, 0x44, 0x00, 0x01, 0x06, 0x09, 0x07, 0x03, 0x42, // "D" (U+0044)
  0x00, 0x45, 0x00, 0x01, 0x04, 0x09, 0x06, 0x03, 0x65, // "E" (U+0045)
  0x00, 0x46, 0x00, 0x01, 0x04, 0x09, 0x05, 0x03, 0x7B, // "F" (U+0046)
  0x00, 0x47, 0x00, 0x01, 0x06, 0x09, 0x07, 0x03, 0x93, // "G" (U+0047)
  0x00, 0x48, 0x00, 0x01, 0x06, 0x09, 0x08, 0x03, 0xB6, // "H" (U+0048)
  0x00, 0x49, 0x00, 0x01, 0x03, 0x09, 0x04, 0x03, 0xDA, // "I" (U+0049)
  0x00, 0x4A, 0xFF, 0xFE, 0x02, 0x09, 0x03, 0x03, 0xEF, // "J" (U+004A)
  0x00, 0x4B, 0x00, 0x01, 0x06, 0x09, 0x07, 0x04, 0x09, // "K" (U+004B)
  0x00, 0x4C, 0x00, 0x01, 0x05, 0x09, 0x05, 0x04, 0x2B, // "L" (U+004C)
  0x00, 0x4D, 0x00, 0x01, 0x08, 0x09, 0x0A, 0x04, 0x46, // "M" (U+004D)
  0x00, 0x4E, 0x00, 0x01, 0x07, 0x09, 0x08, 0x04, 0x71, // "N" (U+004E)
  0x00, 0x4F, 0x00, 0x01, 0x07, 0x09, 0x08, 0x04, 0x99, // "O" (U+004F)
  0x00, 0x50, 0x00, 0x01, 0x05, 0x09, 0x06, 0x04, 0xC1, // "P" (U+0050)
  0x00, 0x51, 0x00, 0xFF, 0x07, 0x09, 0x08, 0x04, 0xDD, // "Q" (U+0051)
  0x00, 0x52, 0x00, 0x01, 0x06, 0x09, 0x07, 0x05, 0x0B, // "R" (U+0052)
  0x00, 0x53, 0x00, 0x01, 0x05, 0x09, 0x06, 0x05, 0x2D, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x05, 0x09, 0x06, 0x05, 0x4A, // "T" (U+0054)
  0x00, 0x55, 0x00, 0x01, 0x06, 0x09, 0x07, 0x05, 0x5F, // "U" (U+0055)
  0x00, 0x56, 0x00, 0x01, 0x06, 0x09, 0x07, 0x05, 0x80, // "V" (U+0056)
  0x00, 0x57, 0x00, 0x01, 0x09, 0x09, 0x0A, 0x05, 0xA0, // "W" (U+0057)
  0x00, 0x58, 0x00, 0x01, 0x06, 0x09, 0x06, 0x05, 0xD2, // "X" (U+0058)
  0x00, 0x59, 0x00, 0x01, 0x06, 0x09, 0x06, 0x05, 0xF4, // "Y" (U+0059)
  0x00, 0x5A, 0x00, 0x01, 0x05, 0x09, 0x06, 0x06, 0x11, // "Z" (U+005A)
  0x00, 0x5B, 0x00, 0xFE, 0x03, 0x09, 0x04, 0x06, 0x2D, // "[" (U+005B)
  0x00, 0x5C, 0x00, 0x01, 0x04, 0x09, 0x05, 0x06, 0x47, // "\" (U+005C)
  0x00, 0x5D, 0x00, 0xFE, 0x03, 0x09, 0x04, 0x06, 0x5E, // "]" (U+005D)
  0x00, 0x5E, 0x00, 0x04, 0x05, 0x09, 0x06, 0x06, 0x78, // "^" (U+005E)
  0x00, 0x5F, 0x00, 0xFE, 0x05, 0x00, 0x05, 0x06, 0x8C, // "_" (U+005F)
  0x00, 0x60, 0x00, 0x09, 0x03, 0x0A, 0x04, 0x06, 0x93, // "`" (U+0060)
  0x00, 0x61, 0x00, 0x01, 0x05, 0x07, 0x06, 0x06, 0x99, // "a" (U+0061)
  0x00, 0x62, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x06, 0xB1, // "b" (U+0062)
  0x00, 0x63, 0x00, 0x01, 0x04, 0x07, 0x05, 0x06, 0xD1, // "c" (U+0063)
  0x00, 0x64, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x06, 0xE6, // "d" (U+0064)
  0x00, 0x65, 0x00, 0x01, 0x05, 0x07, 0x06, 0x07, 0x03, // "e" (U+0065)
  0x00, 0x66, 0x00, 0x01, 0x04, 0x0A, 0x04, 0x07, 0x1A, // "f" (U+0066)
  0x00, 0x67, 0x00, 0xFE, 0x05, 0x07, 0x06, 0x07, 0x32, // "g" (U+0067)
  0x00, 0x68, 0x00, 0x01, 0x05, 0x0A, 0x07, 0x07, 0x52, // "h" (U+0068)
  0x00, 0x69, 0x00, 0x01, 0x02, 0x0A, 0x03, 0x07, 0x72, // "i" (U+0069)
  0x00, 0x6A, 0xFF, 0xFE, 0x02, 0x0A, 0x03, 0x07, 0x83, // "j" (U+006A)
  0x00, 0x6B, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x07, 0x9E, // "k" (U+006B)
  0x00, 0x6C, 0x00, 0x01, 0x02, 0x0A, 0x03, 0x07, 0xBE, // "l" (U+006C)
  0x00, 0x6D, 0x00, 0x01, 0x09, 0x07, 0x0A, 0x07, 0xCF, // "m" (U+006D)
  0x00, 0x6E, 0x00, 0x01, 0x05, 0x07, 0x07, 0x07, 0xF5, // "n" (U+006E)
  0x00, 0x6F, 0x00, 0x01, 0x05, 0x07, 0x06, 0x08, 0x0C, // "o" (U+006F)
  0x00, 0x70, 0x00, 0xFE, 0x05, 0x07, 0x06, 0x08, 0x23, // "p" (U+0070)
  0x00, 0x71, 0x00, 0xFE, 0x05, 0x07, 0x06, 0x08, 0x42, // "q" (U+0071)
  0x00, 0x72, 0x00, 0x01, 0x04, 0x07, 0x05, 0x08, 0x60, // "r" (U+0072)
  0x00, 0x73, 0x00, 0x01, 0x04, 0x07, 0x05, 0x08, 0x75, // "s" (U+0073)
  0x00, 0x74, 0x00, 0x01, 0x03, 0x09, 0x04, 0x08, 0x8A, // "t" (U+0074)
  0x00, 0x75, 0x00, 0x01, 0x05, 0x07, 0x07, 0x08, 0x9F, // "u" (U+0075)
  0x00, 0x76, 0x00, 0x01, 0x05, 0x07, 0x06, 0x08, 0xB6, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x01, 0x08, 0x07, 0x09, 0x08, 0xCE, // "w" (U+0077)
  0x00, 0x78, 0x00, 0x01, 0x05, 0x07, 0x06, 0x08, 0xF1, // "x" (U+0078)
  0x00, 0x79, 0x00, 0xFE, 0x05, 0x07, 0x06, 0x09, 0x08, // "y" (U+0079)
  0x00, 0x7A, 0x00, 0x01, 0x04, 0x07, 0x05, 0x09, 0x28, // "z" (U+007A)
  0x00, 0x7B, 0x00, 0xFE, 0x04, 0x09, 0x04, 0x09, 0x3C, // "{" (U+007B)
  0x00, 0x7C, 0x02, 0xFE, 0x03, 0x0A, 0x05, 0x09, 0x5E, // "|" (U+007C)
  0x00, 0x7D, 0x00, 0xFE, 0x04, 0x09, 0x04, 0x09, 0x6D, // "}" (U+007D)
  0x00, 0x7E, 0x00, 0x04, 0x05, 0x06, 0x06, 0x09, 0x8E, // "~" (U+007E)
  0x00, 0xA1, 0x00, 0xFF, 0x02, 0x07, 0x03, 0x09, 0x98, // "¡" (U+00A1)
  0x00, 0xA2, 0x00, 0x01, 0x05, 0x09, 0x06, 0x09, 0xA7, // "¢" (U+00A2)
  0x00, 0xA3, 0x00, 0x01, 0x05, 0x09, 0x06, 0x09, 0xC4, // "£" (U+00A3)
  0x00, 0xA4, 0x00, 0x02, 0x05, 0x08, 0x07, 0x09, 0xE0, // "¤" (U+00A4)
  0x00, 0xA5, 0x00, 0x01, 0x05, 0x09, 0x06, 0x09, 0xF6, // "¥" (U+00A5)
  0x00, 0xA6, 0x02, 0xFE, 0x03, 0x0A, 0x05, 0x0A, 0x13, // "¦" (U+00A6)
  0x00, 0xA7, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x0A, 0x21, // "§" (U+00A7)
  0x00, 0xA8, 0x01, 0x08, 0x04, 0x09, 0x06, 0x0A, 0x3D, // "¨" (U+00A8)
  0x00, 0xA9, 0x00, 0x00, 0x09, 0x0A, 0x0A, 0x0A, 0x42, // "©" (U+00A9)
  0x00, 0xAA, 0x00, 0x06, 0x03, 0x09, 0x04, 0x0A, 0x77, // "ª" (U+00AA)
  0x00, 0xAB, 0x00, 0x01, 0x05, 0x06, 0x07, 0x0A, 0x81, // "«" (U+00AB)
  0x00, 0xAC, 0x00, 0x02, 0x05, 0x06, 0x06, 0x0A, 0x95, // "¬" (U+00AC)
  0x00, 0xAE, 0x00, 0x00, 0x09, 0x0A, 0x0A, 0x0A, 0xA2, // "®" (U+00AE)
  0x00, 0xAF, 0x00, 0x0A, 0x05, 0x0C, 0x06, 0x0A, 0xD7, // "¯" (U+00AF)
  0x00, 0xB0, 0x00, 0x05, 0x04, 0x0A, 0x05, 0x0A, 0xDE, // "°" (U+00B0)
  0x00, 0xB1, 0x00, 0x01, 0x05, 0x08, 0x06, 0x0A, 0xEE, // "±" (U+00B1)
  0x00, 0xB2, 0x00, 0x05, 0x03, 0x0A, 0x04, 0x0B, 0x06, // "²" (U+00B2)
  0x00, 0xB3, 0x00, 0x05, 0x03, 0x0A, 0x04, 0x0B, 0x14, // "³" (U+00B3)
  0x00, 0xB4, 0x00, 0x08, 0x02, 0x0A, 0x04, 0x0B, 0x22, // "´" (U+00B4)
  0x00, 0xB5, 0x00, 0xFE, 0x05, 0x07, 0x07, 0x0B, 0x27, // "µ" (U+00B5)
  0x00, 0xB6, 0x00, 0xFF, 0x05, 0x0A, 0x07, 0x0B, 0x46, // "¶" (U+00B6)
  0x00, 0xB7, 0x00, 0x04, 0x02, 0x05, 0x03, 0x0B, 0x6C, // "·" (U+00B7)
  0x00, 0xB8, 0xFF, 0xFE, 0x02, 0x00, 0x02, 0x0B, 0x70, // "¸" (U+00B8)
  0x00, 0xB9, 0x00, 0x06, 0x03, 0x0A, 0x04, 0x0B, 0x78, // "¹" (U+00B9)
  0x00, 0xBA, 0x00, 0x06, 0x03, 0x09, 0x04, 0x0B, 0x84, // "º" (U+00BA)
  0x00, 0xBB, 0x00, 0x01, 0x06, 0x06, 0x07, 0x0B, 0x8E, // "»" (U+00BB)
  0x00, 0xBC, 0x00, 0x00, 0x09, 0x09, 0x0A, 0x0B, 0xA5, // "¼" (U+00BC)
  0x00, 0xBD, 0x00, 0x00, 0x09, 0x08, 0x0A, 0x0B, 0xD7, // "½" (U+00BD)
  0x00, 0xBE, 0x00, 0x00, 0x09, 0x0A, 0x0A, 0x0C, 0x06, // "¾" (U+00BE)
  0x00, 0xBF, 0x00, 0xFE, 0x04, 0x06, 0x05, 0x0C, 0x3B, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x0C, 0x52, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x0C, 0x78, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x0C, 0x9F, // "Â" (U+00C2)
  0x00, 0xC3, 0x00, 0x01, 0x06, 0x0D, 0x07, 0x0C, 0xC6, // "Ã" (U+00C3)
  0x00, 0xC4, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x0C, 0xF3, // "Ä" (U+00C4)
  0x00, 0xC5, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x0D, 0x1A, // "Å" (U+00C5)
  0x00, 0xC6, 0x00, 0x01, 0x08, 0x09, 0x09, 0x0D, 0x44, // "Æ" (U+00C6)
  0x00, 0xC7, 0x00, 0xFE, 0x05, 0x09, 0x06, 0x0D, 0x6D, // "Ç" (U+00C7)
  0x00, 0xC8, 0x00, 0x01, 0x04, 0x0C, 0x06, 0x0D, 0x92, // "È" (U+00C8)
  0x00, 0xC9, 0x00, 0x01, 0x04, 0x0C, 0x06, 0x0D, 0xAE, // "É" (U+00C9)
  0x00, 0xCA, 0x00, 0x01, 0x04, 0x0C, 0x06, 0x0D, 0xCB, // "Ê" (U+00CA)
  0x00, 0xCB, 0x00, 0x01, 0x04, 0x0B, 0x06, 0x0D, 0xE8, // "Ë" (U+00CB)
  0x00, 0xCC, 0x00, 0x01, 0x03, 0x0C, 0x04, 0x0E, 0x04, // "Ì" (U+00CC)
  0x00, 0xCD, 0x00, 0x01, 0x03, 0x0C, 0x04, 0x0E, 0x1F, // "Í" (U+00CD)
  0x00, 0xCE, 0x00, 0x01, 0x04, 0x0C, 0x04, 0x0E, 0x3A, // "Î" (U+00CE)
  0x00, 0xCF, 0x00, 0x01, 0x03, 0x0B, 0x04, 0x0E, 0x59, // "Ï" (U+00CF)
  0x00, 0xD0, 0x00, 0x01, 0x06, 0x09, 0x07, 0x0E, 0x73, // "Ð" (U+00D0)
  0x00, 0xD1, 0x00, 0x01, 0x07, 0x0D, 0x08, 0x0E, 0x95, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x0E, 0xCA, // "Ò" (U+00D2)
  0x00, 0xD3, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x0E, 0xF9, // "Ó" (U+00D3)
  0x00, 0xD4, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x0F, 0x28, // "Ô" (U+00D4)
  0x00, 0xD5, 0x00, 0x01, 0x07, 0x0D, 0x08, 0x0F, 0x58, // "Õ" (U+00D5)
  0x00, 0xD6, 0x00, 0x01, 0x07, 0x0B, 0x08, 0x0F, 0x8D, // "Ö" (U+00D6)
  0x00, 0xD7, 0x00, 0x02, 0x05, 0x07, 0x06, 0x0F, 0xBC, // "×" (U+00D7)
  0x00, 0xD8, 0x00, 0x00, 0x07, 0x0A, 0x08, 0x0F, 0xD0, // "Ø" (U+00D8)
  0x00, 0xD9, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x0F, 0xFB, // "Ù" (U+00D9)
  0x00, 0xDA, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x10, 0x23, // "Ú" (U+00DA)
  0x00, 0xDB, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x10, 0x4C, // "Û" (U+00DB)
  0x00, 0xDC, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x10, 0x75, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x01, 0x06, 0x0C, 0x06, 0x10, 0x9D, // "Ý" (U+00DD)
  0x00, 0xDE, 0x00, 0x01, 0x05, 0x09, 0x06, 0x10, 0xC1, // "Þ" (U+00DE)
  0x00, 0xDF, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x10, 0xDD, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x11, 0x03, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x11, 0x21, // "á" (U+00E1)
  0x00, 0xE2, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x11, 0x40, // "â" (U+00E2)
  0x00, 0xE3, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x11, 0x5F, // "ã" (U+00E3)
  0x00, 0xE4, 0x00, 0x01, 0x05, 0x09, 0x06, 0x11, 0x82, // "ä" (U+00E4)
  0x00, 0xE5, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x11, 0xA1, // "å" (U+00E5)
  0x00, 0xE6, 0x00, 0x01, 0x08, 0x07, 0x09, 0x11, 0xC6, // "æ" (U+00E6)
  0x00, 0xE7, 0x00, 0xFE, 0x04, 0x07, 0x05, 0x11, 0xE7, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x12, 0x04, // "è" (U+00E8)
  0x00, 0xE9, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x12, 0x21, // "é" (U+00E9)
  0x00, 0xEA, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x12, 0x3F, // "ê" (U+00EA)
  0x00, 0xEB, 0x00, 0x01, 0x05, 0x09, 0x06, 0x12, 0x5D, // "ë" (U+00EB)
  0x00, 0xEC, 0xFF, 0x01, 0x02, 0x0A, 0x03, 0x12, 0x7B, // "ì" (U+00EC)
  0x00, 0xED, 0x00, 0x01, 0x02, 0x0A, 0x03, 0x12, 0x90, // "í" (U+00ED)
  0x00, 0xEE, 0xFF, 0x01, 0x03, 0x0A, 0x03, 0x12, 0xA0, // "î" (U+00EE)
  0x00, 0xEF, 0xFF, 0x01, 0x02, 0x09, 0x03, 0x12, 0xBC, // "ï" (U+00EF)
  0x00, 0xF0, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x12, 0xD0, // "ð" (U+00F0)
  0x00, 0xF1, 0x00, 0x01, 0x05, 0x0B, 0x07, 0x12, 0xF0, // "ñ" (U+00F1)
  0x00, 0xF2, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x13, 0x11, // "ò" (U+00F2)
  0x00, 0xF3, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x13, 0x2E, // "ó" (U+00F3)
  0x00, 0xF4, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x13, 0x4C, // "ô" (U+00F4)
  0x00, 0xF5, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x13, 0x6A, // "õ" (U+00F5)
  0x00, 0xF6, 0x00, 0x01, 0x05, 0x09, 0x06, 0x13, 0x8C, // "ö" (U+00F6)
  0x00, 0xF7, 0x00, 0x02, 0x05, 0x08, 0x06, 0x13, 0xAA, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x00, 0x05, 0x08, 0x06, 0x13, 0xBC, // "ø" (U+00F8)
  0x00, 0xF9, 0x00, 0x01, 0x05, 0x0A, 0x07, 0x13, 0xD6, // "ù" (U+00F9)
  0x00, 0xFA, 0x00, 0x01, 0x05, 0x0A, 0x07, 0x13, 0xF3, // "ú" (U+00FA)
  0x00, 0xFB, 0x00, 0x01, 0x05, 0x0A, 0x07, 0x14, 0x11, // "û" (U+00FB)
  0x00, 0xFC, 0x00, 0x01, 0x05, 0x09, 0x07, 0x14, 0x2F, // "ü" (U+00FC)
  0x00, 0xFD, 0x00, 0xFE, 0x05, 0x0A, 0x06, 0x14, 0x4C, // "ý" (U+00FD)
  0x00, 0xFE, 0x00, 0xFE, 0x05, 0x0A, 0x06, 0x14, 0x74, // "þ" (U+00FE)
  0x00, 0xFF, 0x00, 0xFE, 0x05, 0x09, 0x06, 0x14, 0x9C, // "ÿ" (U+00FF)
  0x01, 0x00, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x14, 0xC3, // "Ā" (U+0100)
  0x01, 0x01, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x14, 0xEA, // "ā" (U+0101)
  0x01, 0x02, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x15, 0x09, // "Ă" (U+0102)
  0x01, 0x03, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x15, 0x33, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0xFD, 0x06, 0x09, 0x07, 0x15, 0x54, // "Ą" (U+0104)
  0x01, 0x05, 0x00, 0xFD, 0x05, 0x07, 0x06, 0x15, 0x7F, // "ą" (U+0105)
  0x01, 0x06, 0x00, 0x01, 0x05, 0x0C, 0x06, 0x15, 0xA2, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x15, 0xC5, // "ć" (U+0107)
  0x01, 0x08, 0x00, 0x01, 0x05, 0x0C, 0x06, 0x15, 0xE1, // "Ĉ" (U+0108)
  0x01, 0x09, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x16, 0x05, // "ĉ" (U+0109)
  0x01, 0x0A, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x16, 0x20, // "Ċ" (U+010A)
  0x01, 0x0B, 0x00, 0x01, 0x04, 0x09, 0x05, 0x16, 0x41, // "ċ" (U+010B)
  0x01, 0x0C, 0x00, 0x01, 0x05, 0x0C, 0x06, 0x16, 0x5B, // "Č" (U+010C)
  0x01, 0x0D, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x16, 0x7F, // "č" (U+010D)
  0x01, 0x0E, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x16, 0x9A, // "Ď" (U+010E)
  0x01, 0x0F, 0x00, 0x01, 0x07, 0x0A, 0x06, 0x16, 0xC5, // "ď" (U+010F)
  0x01, 0x10, 0x00, 0x01, 0x06, 0x09, 0x07, 0x16, 0xED, // "Đ" (U+0110)
  0x01, 0x11, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x17, 0x0F, // "đ" (U+0111)
  0x01, 0x12, 0x00, 0x01, 0x04, 0x0C, 0x06, 0x17, 0x33, // "Ē" (U+0112)
  0x01, 0x13, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x17, 0x51, // "ē" (U+0113)
  0x01, 0x14, 0x00, 0x01, 0x05, 0x0C, 0x06, 0x17, 0x6F, // "Ĕ" (U+0114)
  0x01, 0x15, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x17, 0x93, // "ĕ" (U+0115)
  0x01, 0x16, 0x00, 0x01, 0x04, 0x0B, 0x06, 0x17, 0xB3, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x01, 0x05, 0x09, 0x06, 0x17, 0xCE, // "ė" (U+0117)
  0x01, 0x18, 0x00, 0xFD, 0x04, 0x09, 0x06, 0x17, 0xE9, // "Ę" (U+0118)
  0x01, 0x19, 0x00, 0xFE, 0x05, 0x07, 0x06, 0x18, 0x0B, // "ę" (U+0119)
  0x01, 0x1A, 0x00, 0x01, 0x04, 0x0C, 0x06, 0x18, 0x2A, // "Ě" (U+011A)
  0x01, 0x1B, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x18, 0x46, // "ě" (U+011B)
  0x01, 0x1C, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x18, 0x64, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x00, 0xFE, 0x05, 0x0A, 0x06, 0x18, 0x8E, // "ĝ" (U+011D)
  0x01, 0x1E, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x18, 0xB5, // "Ğ" (U+011E)
  0x01, 0x1F, 0x00, 0xFE, 0x05, 0x0A, 0x06, 0x18, 0xE2, // "ğ" (U+011F)
  0x01, 0x20, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x19, 0x0B, // "Ġ" (U+0120)
  0x01, 0x21, 0x00, 0xFE, 0x05, 0x09, 0x06, 0x19, 0x32, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0xFE, 0x06, 0x09, 0x07, 0x19, 0x56, // "Ģ" (U+0122)
  0x01, 0x23, 0x00, 0xFE, 0x05, 0x0A, 0x06, 0x19, 0x7F, // "ģ" (U+0123)
  0x01, 0x24, 0x00, 0x01, 0x06, 0x0C, 0x08, 0x19, 0xA5, // "Ĥ" (U+0124)
  0x01, 0x25, 0xFF, 0x01, 0x05, 0x0D, 0x07, 0x19, 0xD1, // "ĥ" (U+0125)
  0x01, 0x26, 0x00, 0x01, 0x07, 0x09, 0x08, 0x19, 0xFC, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x05, 0x0A, 0x07, 0x1A, 0x21, // "ħ" (U+0127)
  0x01, 0x28, 0xFF, 0x01, 0x03, 0x0D, 0x04, 0x1A, 0x41, // "Ĩ" (U+0128)
  0x01, 0x29, 0xFF, 0x01, 0x03, 0x0B, 0x03, 0x1A, 0x63, // "ĩ" (U+0129)
  0x01, 0x2A, 0x00, 0x01, 0x03, 0x0C, 0x04, 0x1A, 0x82, // "Ī" (U+012A)
  0x01, 0x2B, 0xFF, 0x01, 0x02, 0x0A, 0x03, 0x1A, 0x9D, // "ī" (U+012B)
  0x01, 0x2C, 0x00, 0x01, 0x04, 0x0C, 0x04, 0x1A, 0xB2, // "Ĭ" (U+012C)
  0x01, 0x2D, 0xFF, 0x01, 0x03, 0x0A, 0x03, 0x1A, 0xD3, // "ĭ" (U+012D)
  0x01, 0x2E, 0x00, 0xFD, 0x03, 0x09, 0x04, 0x1A, 0xF1, // "Į" (U+012E)
  0x01, 0x2F, 0x00, 0xFD, 0x02, 0x0A, 0x03, 0x1B, 0x10, // "į" (U+012F)
  0x01, 0x30, 0x00, 0x01, 0x03, 0x0B, 0x04, 0x1B, 0x27, // "İ" (U+0130)
  0x01, 0x31, 0x00, 0x01, 0x02, 0x07, 0x03, 0x1B, 0x41, // "ı" (U+0131)
  0x01, 0x32, 0x00, 0xFE, 0x06, 0x09, 0x08, 0x1B, 0x4D, // "Ĳ" (U+0132)
  0x01, 0x33, 0x00, 0xFE, 0x05, 0x0A, 0x06, 0x1B, 0x78, // "ĳ" (U+0133)
  0x01, 0x34, 0xFF, 0xFE, 0x03, 0x0C, 0x03, 0x1B, 0xA1, // "Ĵ" (U+0134)
  0x01, 0x35, 0xFF, 0xFE, 0x03, 0x0A, 0x03, 0x1B, 0xCB, // "ĵ" (U+0135)
  0x01, 0x36, 0x00, 0xFE, 0x06, 0x09, 0x07, 0x1B, 0xEF, // "Ķ" (U+0136)
  0x01, 0x37, 0x00, 0xFE, 0x05, 0x0A, 0x06, 0x1C, 0x17, // "ķ" (U+0137)
  0x01, 0x38, 0x00, 0x01, 0x05, 0x07, 0x06, 0x1C, 0x3E, // "ĸ" (U+0138)
  0x01, 0x39, 0x00, 0x01, 0x05, 0x0C, 0x05, 0x1C, 0x55, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x00, 0x01, 0x02, 0x0D, 0x03, 0x1C, 0x78, // "ĺ" (U+013A)
  0x01, 0x3B, 0x00, 0xFE, 0x05, 0x09, 0x05, 0x1C, 0x8D, // "Ļ" (U+013B)
  0x01, 0x3C, 0x00, 0xFE, 0x02, 0x0A, 0x03, 0x1C, 0xAF, // "ļ" (U+013C)
  0x01, 0x3D, 0x00, 0x01, 0x05, 0x09, 0x05, 0x1C, 0xC4, // "Ľ" (U+013D)
  0x01, 0x3E, 0x00, 0x01, 0x04, 0x0A, 0x03, 0x1C, 0xE0, // "ľ" (U+013E)
  0x01, 0x3F, 0x00, 0x01, 0x05, 0x09, 0x05, 0x1C, 0xFE, // "Ŀ" (U+013F)
  0x01, 0x40, 0x00, 0x01, 0x04, 0x0A, 0x04, 0x1D, 0x1A, // "ŀ" (U+0140)
  0x01, 0x41, 0x00, 0x01, 0x05, 0x09, 0x06, 0x1D, 0x38, // "Ł" (U+0141)
  0x01, 0x42, 0x00, 0x01, 0x03, 0x0A, 0x03, 0x1D, 0x50, // "ł" (U+0142)
  0x01, 0x43, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x1D, 0x67, // "Ń" (U+0143)
  0x01, 0x44, 0x00, 0x01, 0x05, 0x0A, 0x07, 0x1D, 0x96, // "ń" (U+0144)
  0x01, 0x45, 0x00, 0xFE, 0x07, 0x09, 0x08, 0x1D, 0xB4, // "Ņ" (U+0145)
  0x01, 0x46, 0x00, 0xFE, 0x05, 0x07, 0x07, 0x1D, 0xE2, // "ņ" (U+0146)
  0x01, 0x47, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x1D, 0xFF, // "Ň" (U+0147)
  0x01, 0x48, 0x00, 0x01, 0x05, 0x0A, 0x07, 0x1E, 0x2F, // "ň" (U+0148)
  0x01, 0x49, 0x00, 0x01, 0x06, 0x09, 0x08, 0x1E, 0x4D, // "ŉ" (U+0149)
  0x01, 0x4A, 0x00, 0xFE, 0x07, 0x09, 0x08, 0x1E, 0x6D, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x00, 0xFE, 0x05, 0x07, 0x07, 0x1E, 0x9D, // "ŋ" (U+014B)
  0x01, 0x4C, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x1E, 0xBC, // "Ō" (U+014C)
  0x01, 0x4D, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x1E, 0xEC, // "ō" (U+014D)
  0x01, 0x4E, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x1F, 0x0A, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x1F, 0x3C, // "ŏ" (U+014F)
  0x01, 0x50, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x1F, 0x5C, // "Ő" (U+0150)
  0x01, 0x51, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x1F, 0x8E, // "ő" (U+0151)
  0x01, 0x52, 0x00, 0x01, 0x08, 0x09, 0x09, 0x1F, 0xAE, // "Œ" (U+0152)
  0x01, 0x53, 0x00, 0x01, 0x09, 0x07, 0x0A, 0x1F, 0xD9, // "œ" (U+0153)
  0x01, 0x54, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x20, 0x00, // "Ŕ" (U+0154)
  0x01, 0x55, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x20, 0x2A, // "ŕ" (U+0155)
  0x01, 0x56, 0x00, 0xFE, 0x06, 0x09, 0x07, 0x20, 0x46, // "Ŗ" (U+0156)
  0x01, 0x57, 0x00, 0xFE, 0x04, 0x07, 0x05, 0x20, 0x6F, // "ŗ" (U+0157)
  0x01, 0x58, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x20, 0x8A, // "Ř" (U+0158)
  0x01, 0x59, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x20, 0xB4, // "ř" (U+0159)
  0x01, 0x5A, 0x00, 0x01, 0x05, 0x0C, 0x06, 0x20, 0xCF, // "Ś" (U+015A)
  0x01, 0x5B, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x20, 0xF3, // "ś" (U+015B)
  0x01, 0x5C, 0x00, 0x01, 0x05, 0x0C, 0x06, 0x21, 0x0F, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x21, 0x33, // "ŝ" (U+015D)
  0x01, 0x5E, 0x00, 0xFE, 0x05, 0x09, 0x06, 0x21, 0x4E, // "Ş" (U+015E)
  0x01, 0x5F, 0x00, 0xFE, 0x04, 0x07, 0x05, 0x21, 0x73, // "ş" (U+015F)
  0x01, 0x60, 0x00, 0x01, 0x05, 0x0C, 0x06, 0x21, 0x8F, // "Š" (U+0160)
  0x01, 0x61, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x21, 0xB3, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFE, 0x05, 0x09, 0x06, 0x21, 0xCE, // "Ţ" (U+0162)
  0x01, 0x63, 0x00, 0xFE, 0x03, 0x09, 0x04, 0x21, 0xEB, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x05, 0x0C, 0x06, 0x22, 0x07, // "Ť" (U+0164)
  0x01, 0x65, 0x00, 0x01, 0x05, 0x0A, 0x04, 0x22, 0x23, // "ť" (U+0165)
  0x01, 0x66, 0x00, 0x01, 0x05, 0x09, 0x06, 0x22, 0x41, // "Ŧ" (U+0166)
  0x01, 0x67, 0x00, 0x01, 0x03, 0x09, 0x04, 0x22, 0x59, // "ŧ" (U+0167)
  0x01, 0x68, 0x00, 0x01, 0x06, 0x0D, 0x07, 0x22, 0x6F, // "Ũ" (U+0168)
  0x01, 0x69, 0x00, 0x01, 0x05, 0x0B, 0x07, 0x22, 0x9E, // "ũ" (U+0169)
  0x01, 0x6A, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x22, 0xBF, // "Ū" (U+016A)
  0x01, 0x6B, 0x00, 0x01, 0x05, 0x0A, 0x07, 0x22, 0xE8, // "ū" (U+016B)
  0x01, 0x6C, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x23, 0x06, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x00, 0x01, 0x05, 0x0A, 0x07, 0x23, 0x32, // "ŭ" (U+016D)
  0x01, 0x6E, 0x00, 0x01, 0x06, 0x0D, 0x07, 0x23, 0x53, // "Ů" (U+016E)
  0x01, 0x6F, 0x00, 0x01, 0x05, 0x0B, 0x07, 0x23, 0x82, // "ů" (U+016F)
  0x01, 0x70, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x23, 0xA6, // "Ű" (U+0170)
  0x01, 0x71, 0x00, 0x01, 0x05, 0x0A, 0x07, 0x23, 0xD1, // "ű" (U+0171)
  0x01, 0x72, 0x00, 0xFE, 0x06, 0x09, 0x07, 0x23, 0xF0, // "Ų" (U+0172)
  0x01, 0x73, 0x00, 0xFD, 0x05, 0x07, 0x07, 0x24, 0x1A, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x09, 0x0C, 0x0A, 0x24, 0x3C, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x08, 0x0A, 0x09, 0x24, 0x76, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x01, 0x06, 0x0C, 0x06, 0x24, 0xA1, // "Ŷ" (U+0176)
  0x01, 0x77, 0x00, 0xFE, 0x05, 0x0A, 0x06, 0x24, 0xC6, // "ŷ" (U+0177)
  0x01, 0x78, 0x00, 0x01, 0x06, 0x0B, 0x06, 0x24, 0xEE, // "Ÿ" (U+0178)
  0x01, 0x79, 0x00, 0x01, 0x05, 0x0C, 0x06, 0x25, 0x12, // "Ź" (U+0179)
  0x01, 0x7A, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x25, 0x35, // "ź" (U+017A)
  0x01, 0x7B, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x25, 0x50, // "Ż" (U+017B)
  0x01, 0x7C, 0x00, 0x01, 0x04, 0x09, 0x05, 0x25, 0x71, // "ż" (U+017C)
  0x01, 0x7D, 0x00, 0x01, 0x05, 0x0C, 0x06, 0x25, 0x8A, // "Ž" (U+017D)
  0x01, 0x7E, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x25, 0xAD, // "ž" (U+017E)
  0x01, 0x7F, 0x00, 0x01, 0x03, 0x0A, 0x04, 0x25, 0xC7, // "ſ" (U+017F)
  0x03, 0xA9, 0x00, 0x01, 0x07, 0x09, 0x08, 0x25, 0xDD, // "Ω" (U+03A9)
  0x03, 0xBC, 0x00, 0xFE, 0x05, 0x07, 0x07, 0x26, 0x06, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x01, 0x07, 0x07, 0x07, 0x26, 0x25, // "π" (U+03C0)
  0x20, 0x13, 0x00, 0x03, 0x05, 0x05, 0x06, 0x26, 0x41, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x03, 0x0B, 0x05, 0x0C, 0x26, 0x49, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x01, 0x05, 0x09, 0x06, 0x26, 0x53, // "€" (U+20AC)
  0x20, 0xBF, 0x00, 0xFF, 0x05, 0x0A, 0x06, 0x26, 0x70, // "₿" (U+20BF)
  0x20, 0x18, 0x00, 0x07, 0x02, 0x09, 0x03, 0x26, 0x95, // "‘" (U+2018)
  0x20, 0x19, 0x00, 0x07, 0x02, 0x09, 0x03, 0x26, 0x9B, // "’" (U+2019)
  0x20, 0x1A, 0x00, 0x00, 0x02, 0x02, 0x03, 0x26, 0xA1, // "‚" (U+201A)
  0x20, 0x1B, 0x00, 0x07, 0x02, 0x09, 0x03, 0x26, 0xA7, // "‛" (U+201B)
  0x20, 0x1C, 0x00, 0x07, 0x04, 0x09, 0x05, 0x26, 0xAD, // "“" (U+201C)
  0x20, 0x1D, 0x00, 0x07, 0x04, 0x09, 0x05, 0x26, 0xB6, // "”" (U+201D)
  0x20, 0x1E, 0x00, 0x00, 0x04, 0x02, 0x06, 0x26, 0xBF, // "„" (U+201E)
  0x20, 0x1F, 0x00, 0x07, 0x04, 0x09, 0x05, 0x26, 0xC8, // "‟" (U+201F)
  0x20, 0x20, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x26, 0xD1, // "†" (U+2020)
  0x20, 0x21, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x26, 0xEE, // "‡" (U+2021)
  0x20, 0x22, 0x00, 0x04, 0x03, 0x07, 0x05, 0x27, 0x0C, // "•" (U+2022)
  0x20, 0x26, 0x00, 0x01, 0x08, 0x02, 0x0A, 0x27, 0x16, // "…" (U+2026)
  0x20, 0x30, 0x00, 0x01, 0x0D, 0x09, 0x0E, 0x27, 0x21, // "‰" (U+2030)
  0x20, 0x39, 0x00, 0x01, 0x03, 0x06, 0x04, 0x27, 0x5F, // "‹" (U+2039)
  0x20, 0x3A, 0x00, 0x01, 0x03, 0x06, 0x04, 0x27, 0x6D, // "›" (U+203A)
  0x20, 0x44, 0xFE, 0x01, 0x03, 0x09, 0x01, 0x27, 0x7B, // "⁄" (U+2044)
  0x21, 0x22, 0x00, 0x05, 0x07, 0x0A, 0x09, 0x27, 0x94, // "™" (U+2122)
  0x21, 0x52, 0x00, 0x01, 0x0C, 0x09, 0x0D, 0x27, 0xAD, // "⅒" (U+2152)
  0xFB, 0x01, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x27, 0xE3, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x28, 0x08, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x01, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0x63, 0x01, // "c (U+0022 U+0063)
  0x00, 0x22, 0x00, 0x64, 0x01, // "d (U+0022 U+0064)
  0x00, 0x22, 0x00, 0x65, 0x01, // "e (U+0022 U+0065)
  0x00, 0x22, 0x00, 0x6F, 0x01, // "o (U+0022 U+006F)
  0x00, 0x22, 0x00, 0x71, 0x01, // "q (U+0022 U+0071)
  0x00, 0x22, 0x00, 0xC0, 0x01, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x01, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x01, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x01, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x01, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x01, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xC6, 0x01, // "Æ (U+0022 U+00C6)
  0x00, 0x22, 0x00, 0xE0, 0x01, // "à (U+0022 U+00E0)
  0x00, 0x22, 0x00, 0xE7, 0x01, // "ç (U+0022 U+00E7)
  0x00, 0x22, 0x00, 0xE8, 0x01, // "è (U+0022 U+00E8)
  0x00, 0x22, 0x00, 0xE9, 0x01, // "é (U+0022 U+00E9)
  0x00, 0x22, 0x00, 0xEA, 0x01, // "ê (U+0022 U+00EA)
  0x00, 0x22, 0x00, 0xEB, 0x01, // "ë (U+0022 U+00EB)
  0x00, 0x22, 0x00, 0xF2, 0x01, // "ò (U+0022 U+00F2)
  0x00, 0x22, 0x00, 0xF3, 0x01, // "ó (U+0022 U+00F3)
  0x00, 0x22, 0x00, 0xF4, 0x01, // "ô (U+0022 U+00F4)
  0x00, 0x22, 0x00, 0xF5, 0x01, // "õ (U+0022 U+00F5)
  0x00, 0x22, 0x00, 0xF6, 0x01, // "ö (U+0022 U+00F6)
  0x00, 0x22, 0x00, 0xF8, 0x01, // "ø (U+0022 U+00F8)
  0x00, 0x22, 0x01, 0x00, 0x01, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x02, 0x01, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x04, 0x01, // "Ą (U+0022 U+0104)
  0x00, 0x22, 0x01, 0x07, 0x01, // "ć (U+0022 U+0107)
  0x00, 0x22, 0x01, 0x09, 0x01, // "ĉ (U+0022 U+0109)
  0x00, 0x22, 0x01, 0x0B, 0x01, // "ċ (U+0022 U+010B)
  0x00, 0x22, 0x01, 0x0D, 0x01, // "č (U+0022 U+010D)
  0x00, 0x22, 0x01, 0x0F, 0x01, // "ď (U+0022 U+010F)
  0x00, 0x22, 0x01, 0x11, 0x01, // "đ (U+0022 U+0111)
  0x00, 0x22, 0x01, 0x13, 0x01, // "ē (U+0022 U+0113)
  0x00, 0x22, 0x01, 0x15, 0x01, // "ĕ (U+0022 U+0115)
  0x00, 0x22, 0x01, 0x17, 0x01, // "ė (U+0022 U+0117)
  0x00, 0x22, 0x01, 0x19, 0x01, // "ę (U+0022 U+0119)
  0x00, 0x22, 0x01, 0x1B, 0x01, // "ě (U+0022 U+011B)
  0x00, 0x22, 0x01, 0x4D, 0x01, // "ō (U+0022 U+014D)
  0x00, 0x22, 0x01, 0x4F, 0x01, // "ŏ (U+0022 U+014F)
  0x00, 0x22, 0x01, 0x51, 0x01, // "ő (U+0022 U+0151)
  0x00, 0x22, 0x01, 0x53, 0x01, // "œ (U+0022 U+0153)
  0x00, 0x27, 0x00, 0x41, 0x01, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0x63, 0x01, // 'c (U+0027 U+0063)
  0x00, 0x27, 0x00, 0x64, 0x01, // 'd (U+0027 U+0064)
  0x00, 0x27, 0x00, 0x65, 0x01, // 'e (U+0027 U+0065)
  0x00, 0x27, 0x00, 0x6F, 0x01, // 'o (U+0027 U+006F)
  0x00, 0x27, 0x00, 0x71, 0x01, // 'q (U+0027 U+0071)
  0x00, 0x27, 0x00, 0xC0, 0x01, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x01, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x01, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x01, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x01, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x01, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xC6, 0x01, // 'Æ (U+0027 U+00C6)
  0x00, 0x27, 0x00, 0xE0, 0x01, // 'à (U+0027 U+00E0)
  0x00, 0x27, 0x00, 0xE7, 0x01, // 'ç (U+0027 U+00E7)
  0x00, 0x27, 0x00, 0xE8, 0x01, // 'è (U+0027 U+00E8)
  0x00, 0x27, 0x00, 0xE9, 0x01, // 'é (U+0027 U+00E9)
  0x00, 0x27, 0x00, 0xEA, 0x01, // 'ê (U+0027 U+00EA)
  0x00, 0x27, 0x00, 0xEB, 0x01, // 'ë (U+0027 U+00EB)
  0x00, 0x27, 0x00, 0xF2, 0x01, // 'ò (U+0027 U+00F2)
  0x00, 0x27, 0x00, 0xF3, 0x01, // 'ó (U+0027 U+00F3)
  0x00, 0x27, 0x00, 0xF4, 0x01, // 'ô (U+0027 U+00F4)
  0x00, 0x27, 0x00, 0xF5, 0x01, // 'õ (U+0027 U+00F5)
  0x00, 0x27, 0x00, 0xF6, 0x01, // 'ö (U+0027 U+00F6)
  0x00, 0x27, 0x00, 0xF8, 0x01, // 'ø (U+0027 U+00F8)
  0x00, 0x27, 0x01, 0x00, 0x01, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x02, 0x01, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x04, 0x01, // 'Ą (U+0027 U+0104)
  0x00, 0x27, 0x01, 0x07, 0x01, // 'ć (U+0027 U+0107)
  0x00, 0x27, 0x01, 0x09, 0x01, // 'ĉ (U+0027 U+0109)
  0x00, 0x27, 0x01, 0x0B, 0x01, // 'ċ (U+0027 U+010B)
  0x00, 0x27, 0x01, 0x0D, 0x01, // 'č (U+0027 U+010D)
  0x00, 0x27, 0x01, 0x0F, 0x01, // 'ď (U+0027 U+010F)
  0x00, 0x27, 0x01, 0x11, 0x01, // 'đ (U+0027 U+0111)
  0x00, 0x27, 0x01, 0x13, 0x01, // 'ē (U+0027 U+0113)
  0x00, 0x27, 0x01, 0x15, 0x01, // 'ĕ (U+0027 U+0115)
  0x00, 0x27, 0x01, 0x17, 0x01, // 'ė (U+0027 U+0117)
  0x00, 0x27, 0x01, 0x19, 0x01, // 'ę (U+0027 U+0119)
  0x00, 0x27, 0x01, 0x1B, 0x01, // 'ě (U+0027 U+011B)
  0x00, 0x27, 0x01, 0x4D, 0x01, // 'ō (U+0027 U+014D)
  0x00, 0x27, 0x01, 0x4F, 0x01, // 'ŏ (U+0027 U+014F)
  0x00, 0x27, 0x01, 0x51, 0x01, // 'ő (U+0027 U+0151)
  0x00, 0x27, 0x01, 0x53, 0x01, // 'œ (U+0027 U+0153)
  0x00, 0x2C, 0x00, 0x54, 0x01, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x56, 0x01, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x01, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x01, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0xDD, 0x01, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x01, 0x62, 0x01, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x01, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x01, // ,Ŧ (U+002C U+0166)
  0x00, 0x2C, 0x01, 0x74, 0x01, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x76, 0x01, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x78, 0x01, // ,Ÿ (U+002C U+0178)
  0x00, 0x2E, 0x00, 0x54, 0x01, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x56, 0x01, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x01, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x01, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0xDD, 0x01, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x01, 0x62, 0x01, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x01, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x01, // .Ŧ (U+002E U+0166)
  0x00, 0x2E, 0x01, 0x74, 0x01, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x76, 0x01, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x78, 0x01, // .Ÿ (U+002E U+0178)
  0x00, 0x30, 0x20, 0x44, 0x02, // 0⁄ (U+0030 U+2044)
  0x00, 0x31, 0x20, 0x44, 0x02, // 1⁄ (U+0031 U+2044)
  0x00, 0x32, 0x20, 0x44, 0x02, // 2⁄ (U+0032 U+2044)
  0x00, 0x33, 0x20, 0x44, 0x02, // 3⁄ (U+0033 U+2044)
  0x00, 0x34, 0x20, 0x44, 0x02, // 4⁄ (U+0034 U+2044)
  0x00, 0x35, 0x20, 0x44, 0x02, // 5⁄ (U+0035 U+2044)
  0x00, 0x36, 0x20, 0x44, 0x02, // 6⁄ (U+0036 U+2044)
  0x00, 0x37, 0x20, 0x44, 0x02, // 7⁄ (U+0037 U+2044)
  0x00, 0x38, 0x20, 0x44, 0x02, // 8⁄ (U+0038 U+2044)
  0x00, 0x39, 0x20, 0x44, 0x02, // 9⁄ (U+0039 U+2044)
  0x00, 0x41, 0x00, 0x22, 0x01, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x01, // A' (U+0041 U+0027)
  0x00, 0x41, 0x20, 0x19, 0x01, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1D, 0x01, // A” (U+0041 U+201D)
  0x00, 0x46, 0x00, 0x2C, 0x01, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x01, // F. (U+0046 U+002E)
  0x00, 0x46, 0x20, 0x1A, 0x01, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x01, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x01, // F… (U+0046 U+2026)
  0x00, 0x4C, 0x00, 0x22, 0x01, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x01, // L' (U+004C U+0027)
  0x00, 0x4C, 0x20, 0x19, 0x01, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1D, 0x01, // L” (U+004C U+201D)
  0x00, 0x50, 0x00, 0x2C, 0x01, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x01, // P. (U+0050 U+002E)
  0x00, 0x50, 0x20, 0x1A, 0x01, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x01, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x01, // P… (U+0050 U+2026)
  0x00, 0x54, 0x00, 0x2C, 0x01, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2E, 0x01, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0x61, 0x01, // Ta (U+0054 U+0061)
  0x00, 0x54, 0x00, 0x63, 0x01, // Tc (U+0054 U+0063)
  0x00, 0x54, 0x00, 0x64, 0x01, // Td (U+0054 U+0064)
  0x00, 0x54, 0x00, 0x65, 0x01, // Te (U+0054 U+0065)
  0x00, 0x54, 0x00, 0x67, 0x01, // Tg (U+0054 U+0067)
  0x00, 0x54, 0x00, 0x6F, 0x01, // To (U+0054 U+006F)
  0x00, 0x54, 0x00, 0x71, 0x01, // Tq (U+0054 U+0071)
  0x00, 0x54, 0x00, 0x73, 0x01, // Ts (U+0054 U+0073)
  0x00, 0x54, 0x00, 0xAB, 0x01, // T« (U+0054 U+00AB)
  0x00, 0x54, 0x00, 0xE0, 0x01, // Tà (U+0054 U+00E0)
  0x00, 0x54, 0x00, 0xE1, 0x01, // Tá (U+0054 U+00E1)
  0x00, 0x54, 0x00, 0xE2, 0x01, // Tâ (U+0054 U+00E2)
  0x00, 0x54, 0x00, 0xE3, 0x01, // Tã (U+0054 U+00E3)
  0x00, 0x54, 0x00, 0xE4, 0x01, // Tä (U+0054 U+00E4)
  0x00, 0x54, 0x00, 0xE5, 0x01, // Tå (U+0054 U+00E5)
  0x00, 0x54, 0x00, 0xE6, 0x01, // Tæ (U+0054 U+00E6)
  0x00, 0x54, 0x00, 0xE7, 0x01, // Tç (U+0054 U+00E7)
  0x00, 0x54, 0x00, 0xE8, 0x01, // Tè (U+0054 U+00E8)
  0x00, 0x54, 0x00, 0xE9, 0x01, // Té (U+0054 U+00E9)
  0x00, 0x54, 0x00, 0xEA, 0x01, // Tê (U+0054 U+00EA)
  0x00, 0x54, 0x00, 0xEB, 0x01, // Të (U+0054 U+00EB)
  0x00, 0x54, 0x00, 0xF2, 0x01, // Tò (U+0054 U+00F2)
  0x00, 0x54, 0x00, 0xF3, 0x01, // Tó (U+0054 U+00F3)
  0x00, 0x54, 0x00, 0xF4, 0x01, // Tô (U+0054 U+00F4)
  0x00, 0x54, 0x00, 0xF5, 0x01, // Tõ (U+0054 U+00F5)
  0x00, 0x54, 0x00, 0xF6, 0x01, // Tö (U+0054 U+00F6)
  0x00, 0x54, 0x00, 0xF8, 0x01, // Tø (U+0054 U+00F8)
  0x00, 0x54, 0x01, 0x01, 0x01, // Tā (U+0054 U+0101)
  0x00, 0x54, 0x01, 0x03, 0x01, // Tă (U+0054 U+0103)
  0x00, 0x54, 0x01, 0x05, 0x01, // Tą (U+0054 U+0105)
  0x00, 0x54, 0x01, 0x07, 0x01, // Tć (U+0054 U+0107)
  0x00, 0x54, 0x01, 0x09, 0x01, // Tĉ (U+0054 U+0109)
  0x00, 0x54, 0x01, 0x0B, 0x01, // Tċ (U+0054 U+010B)
  0x00, 0x54, 0x01, 0x0D, 0x01, // Tč (U+0054 U+010D)
  0x00, 0x54, 0x01, 0x0F, 0x01, // Tď (U+0054 U+010F)
  0x00, 0x54, 0x01, 0x11, 0x01, // Tđ (U+0054 U+0111)
  0x00, 0x54, 0x01, 0x13, 0x01, // Tē (U+0054 U+0113)
  0x00, 0x54, 0x01, 0x15, 0x01, // Tĕ (U+0054 U+0115)
  0x00, 0x54, 0x01, 0x17, 0x01, // Tė (U+0054 U+0117)
  0x00, 0x54, 0x01, 0x19, 0x01, // Tę (U+0054 U+0119)
  0x00, 0x54, 0x01, 0x1B, 0x01, // Tě (U+0054 U+011B)
  0x00, 0x54, 0x01, 0x1D, 0x01, // Tĝ (U+0054 U+011D)
  0x00, 0x54, 0x01, 0x1F, 0x01, // Tğ (U+0054 U+011F)
  0x00, 0x54, 0x01, 0x21, 0x01, // Tġ (U+0054 U+0121)
  0x00, 0x54, 0x01, 0x23, 0x01, // Tģ (U+0054 U+0123)
  0x00, 0x54, 0x01, 0x4D, 0x01, // Tō (U+0054 U+014D)
  0x00, 0x54, 0x01, 0x4F, 0x01, // Tŏ (U+0054 U+014F)
  0x00, 0x54, 0x01, 0x51, 0x01, // Tő (U+0054 U+0151)
  0x00, 0x54, 0x01, 0x53, 0x01, // Tœ (U+0054 U+0153)
  0x00, 0x54, 0x01, 0x5B, 0x01, // Tś (U+0054 U+015B)
  0x00, 0x54, 0x01, 0x5F, 0x01, // Tş (U+0054 U+015F)
  0x00, 0x54, 0x20, 0x1A, 0x01, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x01, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x01, // T… (U+0054 U+2026)
  0x00, 0x54, 0x20, 0x39, 0x01, // T‹ (U+0054 U+2039)
  0x00, 0x59, 0x00, 0x2C, 0x01, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x01, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x00, 0xAB, 0x01, // Y« (U+0059 U+00AB)
  0x00, 0x59, 0x20, 0x1A, 0x01, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x01, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x01, // Y… (U+0059 U+2026)
  0x00, 0x59, 0x20, 0x39, 0x01, // Y‹ (U+0059 U+2039)
  0x00, 0x72, 0x00, 0x2C, 0x01, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x01, // r. (U+0072 U+002E)
  0x00, 0x72, 0x20, 0x1A, 0x01, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x01, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x01, // r… (U+0072 U+2026)
  0x00, 0xBB, 0x00, 0x54, 0x01, // »T (U+00BB U+0054)
  0x00, 0xBB, 0x00, 0x59, 0x01, // »Y (U+00BB U+0059)
  0x00, 0xBB, 0x00, 0xDD, 0x01, // »Ý (U+00BB U+00DD)
  0x00, 0xBB, 0x01, 0x62, 0x01, // »Ţ (U+00BB U+0162)
  0x00, 0xBB, 0x01, 0x64, 0x01, // »Ť (U+00BB U+0164)
  0x00, 0xBB, 0x01, 0x66, 0x01, // »Ŧ (U+00BB U+0166)
  0x00, 0xBB, 0x01, 0x76, 0x01, // »Ŷ (U+00BB U+0176)
  0x00, 0xBB, 0x01, 0x78, 0x01, // »Ÿ (U+00BB U+0178)
  0x00, 0xC0, 0x00, 0x22, 0x01, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x01, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x20, 0x19, 0x01, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1D, 0x01, // À” (U+00C0 U+201D)
  0x00, 0xC1, 0x00, 0x22, 0x01, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x01, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x20, 0x19, 0x01, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1D, 0x01, // Á” (U+00C1 U+201D)
  0x00, 0xC2, 0x00, 0x22, 0x01, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x01, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x20, 0x19, 0x01, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1D, 0x01, // Â” (U+00C2 U+201D)
  0x00, 0xC3, 0x00, 0x22, 0x01, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x01, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x20, 0x19, 0x01, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1D, 0x01, // Ã” (U+00C3 U+201D)
  0x00, 0xC4, 0x00, 0x22, 0x01, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x01, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x20, 0x19, 0x01, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1D, 0x01, // Ä” (U+00C4 U+201D)
  0x00, 0xC5, 0x00, 0x22, 0x01, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x01, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x20, 0x19, 0x01, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1D, 0x01, // Å” (U+00C5 U+201D)
  0x00, 0xDD, 0x00, 0x2C, 0x01, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x01, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x00, 0xAB, 0x01, // Ý« (U+00DD U+00AB)
  0x00, 0xDD, 0x20, 0x1A, 0x01, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x01, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x01, // Ý… (U+00DD U+2026)
  0x00, 0xDD, 0x20, 0x39, 0x01, // Ý‹ (U+00DD U+2039)
  0x00, 0xDE, 0x00, 0x2C, 0x01, // Þ, (U+00DE U+002C)
  0x00, 0xDE, 0x00, 0x2E, 0x01, // Þ. (U+00DE U+002E)
  0x00, 0xDE, 0x20, 0x1A, 0x01, // Þ‚ (U+00DE U+201A)
  0x00, 0xDE, 0x20, 0x1E, 0x01, // Þ„ (U+00DE U+201E)
  0x00, 0xDE, 0x20, 0x26, 0x01, // Þ… (U+00DE U+2026)
  0x01, 0x00, 0x00, 0x22, 0x01, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x01, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x20, 0x19, 0x01, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1D, 0x01, // Ā” (U+0100 U+201D)
  0x01, 0x02, 0x00, 0x22, 0x01, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x01, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x20, 0x19, 0x01, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1D, 0x01, // Ă” (U+0102 U+201D)
  0x01, 0x04, 0x00, 0x22, 0x01, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x01, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x20, 0x19, 0x01, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1D, 0x01, // Ą” (U+0104 U+201D)
  0x01, 0x39, 0x00, 0x22, 0x01, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x01, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x20, 0x19, 0x01, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1D, 0x01, // Ĺ” (U+0139 U+201D)
  0x01, 0x3B, 0x00, 0x22, 0x01, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x01, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x20, 0x19, 0x01, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1D, 0x01, // Ļ” (U+013B U+201D)
  0x01, 0x3D, 0x00, 0x22, 0x01, // Ľ" (U+013D U+0022)
  0x01, 0x3D, 0x00, 0x27, 0x01, // Ľ' (U+013D U+0027)
  0x01, 0x3D, 0x20, 0x19, 0x01, // Ľ’ (U+013D U+2019)
  0x01, 0x3D, 0x20, 0x1D, 0x01, // Ľ” (U+013D U+201D)
  0x01, 0x3F, 0x00, 0x22, 0x01, // Ŀ" (U+013F U+0022)
  0x01, 0x3F, 0x00, 0x27, 0x01, // Ŀ' (U+013F U+0027)
  0x01, 0x3F, 0x20, 0x19, 0x01, // Ŀ’ (U+013F U+2019)
  0x01, 0x3F, 0x20, 0x1D, 0x01, // Ŀ” (U+013F U+201D)
  0x01, 0x41, 0x00, 0x22, 0x01, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x01, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x20, 0x19, 0x01, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1D, 0x01, // Ł” (U+0141 U+201D)
  0x01, 0x55, 0x00, 0x2C, 0x01, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x01, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x20, 0x1A, 0x01, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x01, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x01, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x01, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x01, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x20, 0x1A, 0x01, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x01, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x01, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x01, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x01, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x20, 0x1A, 0x01, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x01, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x01, // ř… (U+0159 U+2026)
  0x01, 0x62, 0x00, 0x2C, 0x01, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2E, 0x01, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0x61, 0x01, // Ţa (U+0162 U+0061)
  0x01, 0x62, 0x00, 0x63, 0x01, // Ţc (U+0162 U+0063)
  0x01, 0x62, 0x00, 0x64, 0x01, // Ţd (U+0162 U+0064)
  0x01, 0x62, 0x00, 0x65, 0x01, // Ţe (U+0162 U+0065)
  0x01, 0x62, 0x00, 0x67, 0x01, // Ţg (U+0162 U+0067)
  0x01, 0x62, 0x00, 0x6F, 0x01, // Ţo (U+0162 U+006F)
  0x01, 0x62, 0x00, 0x71, 0x01, // Ţq (U+0162 U+0071)
  0x01, 0x62, 0x00, 0x73, 0x01, // Ţs (U+0162 U+0073)
  0x01, 0x62, 0x00, 0xAB, 0x01, // Ţ« (U+0162 U+00AB)
  0x01, 0x62, 0x00, 0xE0, 0x01, // Ţà (U+0162 U+00E0)
  0x01, 0x62, 0x00, 0xE1, 0x01, // Ţá (U+0162 U+00E1)
  0x01, 0x62, 0x00, 0xE2, 0x01, // Ţâ (U+0162 U+00E2)
  0x01, 0x62, 0x00, 0xE3, 0x01, // Ţã (U+0162 U+00E3)
  0x01, 0x62, 0x00, 0xE4, 0x01, // Ţä (U+0162 U+00E4)
  0x01, 0x62, 0x00, 0xE5, 0x01, // Ţå (U+0162 U+00E5)
  0x01, 0x62, 0x00, 0xE6, 0x01, // Ţæ (U+0162 U+00E6)
  0x01, 0x62, 0x00, 0xE7, 0x01, // Ţç (U+0162 U+00E7)
  0x01, 0x62, 0x00, 0xE8, 0x01, // Ţè (U+0162 U+00E8)
  0x01, 0x62, 0x00, 0xE9, 0x01, // Ţé (U+0162 U+00E9)
  0x01, 0x62, 0x00, 0xEA, 0x01, // Ţê (U+0162 U+00EA)
  0x01, 0x62, 0x00, 0xEB, 0x01, // Ţë (U+0162 U+00EB)
  0x01, 0x62, 0x00, 0xF2, 0x01, // Ţò (U+0162 U+00F2)
  0x01, 0x62, 0x00, 0xF3, 0x01, // Ţó (U+0162 U+00F3)
  0x01, 0x62, 0x00, 0xF4, 0x01, // Ţô (U+0162 U+00F4)
  0x01, 0x62, 0x00, 0xF5, 0x01, // Ţõ (U+0162 U+00F5)
  0x01, 0x62, 0x00, 0xF6, 0x01, // Ţö (U+0162 U+00F6)
  0x01, 0x62, 0x00, 0xF8, 0x01, // Ţø (U+0162 U+00F8)
  0x01, 0x62, 0x01, 0x01, 0x01, // Ţā (U+0162 U+0101)
  0x01, 0x62, 0x01, 0x03, 0x01, // Ţă (U+0162 U+0103)
  0x01, 0x62, 0x01, 0x05, 0x01, // Ţą (U+0162 U+0105)
  0x01, 0x62, 0x01, 0x07, 0x01, // Ţć (U+0162 U+0107)
  0x01, 0x62, 0x01, 0x09, 0x01, // Ţĉ (U+0162 U+0109)
  0x01, 0x62, 0x01, 0x0B, 0x01, // Ţċ (U+0162 U+010B)
  0x01, 0x62, 0x01, 0x0D, 0x01, // Ţč (U+0162 U+010D)
  0x01, 0x62, 0x01, 0x0F, 0x01, // Ţď (U+0162 U+010F)
  0x01, 0x62, 0x01, 0x11, 0x01, // Ţđ (U+0162 U+0111)
  0x01, 0x62, 0x01, 0x13, 0x01, // Ţē (U+0162 U+0113)
  0x01, 0x62, 0x01, 0x15, 0x01, // Ţĕ (U+0162 U+0115)
  0x01, 0x62, 0x01, 0x17, 0x01, // Ţė (U+0162 U+0117)
  0x01, 0x62, 0x01, 0x19, 0x01, // Ţę (U+0162 U+0119)
  0x01, 0x62, 0x01, 0x1B, 0x01, // Ţě (U+0162 U+011B)
  0x01, 0x62, 0x01, 0x1D, 0x01, // Ţĝ (U+0162 U+011D)
  0x01, 0x62, 0x01, 0x1F, 0x01, // Ţğ (U+0162 U+011F)
  0x01, 0x62, 0x01, 0x21, 0x01, // Ţġ (U+0162 U+0121)
  0x01, 0x62, 0x01, 0x23, 0x01, // Ţģ (U+0162 U+0123)
  0x01, 0x62, 0x01, 0x4D, 0x01, // Ţō (U+0162 U+014D)
  0x01, 0x62, 0x01, 0x4F, 0x01, // Ţŏ (U+0162 U+014F)
  0x01, 0x62, 0x01, 0x51, 0x01, // Ţő (U+0162 U+0151)
  0x01, 0x62, 0x01, 0x53, 0x01, // Ţœ (U+0162 U+0153)
  0x01, 0x62, 0x01, 0x5B, 0x01, // Ţś (U+0162 U+015B)
  0x01, 0x62, 0x01, 0x5F, 0x01, // Ţş (U+0162 U+015F)
  0x01, 0x62, 0x20, 0x1A, 0x01, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x01, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x01, // Ţ… (U+0162 U+2026)
  0x01, 0x62, 0x20, 0x39, 0x01, // Ţ‹ (U+0162 U+2039)
  0x01, 0x64, 0x00, 0x2C, 0x01, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2E, 0x01, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0x61, 0x01, // Ťa (U+0164 U+0061)
  0x01, 0x64, 0x00, 0x63, 0x01, // Ťc (U+0164 U+0063)
  0x01, 0x64, 0x00, 0x64, 0x01, // Ťd (U+0164 U+0064)
  0x01, 0x64, 0x00, 0x65, 0x01, // Ťe (U+0164 U+0065)
  0x01, 0x64, 0x00, 0x67, 0x01, // Ťg (U+0164 U+0067)
  0x01, 0x64, 0x00, 0x6F, 0x01, // Ťo (U+0164 U+006F)
  0x01, 0x64, 0x00, 0x71, 0x01, // Ťq (U+0164 U+0071)
  0x01, 0x64, 0x00, 0x73, 0x01, // Ťs (U+0164 U+0073)
  0x01, 0x64, 0x00, 0xAB, 0x01, // Ť« (U+0164 U+00AB)
  0x01, 0x64, 0x00, 0xE0, 0x01, // Ťà (U+0164 U+00E0)
  0x01, 0x64, 0x00, 0xE1, 0x01, // Ťá (U+0164 U+00E1)
  0x01, 0x64, 0x00, 0xE2, 0x01, // Ťâ (U+0164 U+00E2)
  0x01, 0x64, 0x00, 0xE3, 0x01, // Ťã (U+0164 U+00E3)
  0x01, 0x64, 0x00, 0xE4, 0x01, // Ťä (U+0164 U+00E4)
  0x01, 0x64, 0x00, 0xE5, 0x01, // Ťå (U+0164 U+00E5)
  0x01, 0x64, 0x00, 0xE6, 0x01, // Ťæ (U+0164 U+00E6)
  0x01, 0x64, 0x00, 0xE7, 0x01, // Ťç (U+0164 U+00E7)
  0x01, 0x64, 0x00, 0xE8, 0x01, // Ťè (U+0164 U+00E8)
  0x01, 0x64, 0x00, 0xE9, 0x01, // Ťé (U+0164 U+00E9)
  0x01, 0x64, 0x00, 0xEA, 0x01, // Ťê (U+0164 U+00EA)
  0x01, 0x64, 0x00, 0xEB, 0x01, // Ťë (U+0164 U+00EB)
  0x01, 0x64, 0x00, 0xF2, 0x01, // Ťò (U+0164 U+00F2)
  0x01, 0x64, 0x00, 0xF3, 0x01, // Ťó (U+0164 U+00F3)
  0x01, 0x64, 0x00, 0xF4, 0x01, // Ťô (U+0164 U+00F4)
  0x01, 0x64, 0x00, 0xF5, 0x01, // Ťõ (U+0164 U+00F5)
  0x01, 0x64, 0x00, 0xF6, 0x01, // Ťö (U+0164 U+00F6)
  0x01, 0x64, 0x00, 0xF8, 0x01, // Ťø (U+0164 U+00F8)
  0x01, 0x64, 0x01, 0x01, 0x01, // Ťā (U+0164 U+0101)
  0x01, 0x64, 0x01, 0x03, 0x01, // Ťă (U+0164 U+0103)
  0x01, 0x64, 0x01, 0x05, 0x01, // Ťą (U+0164 U+0105)
  0x01, 0x64, 0x01, 0x07, 0x01, // Ťć (U+0164 U+0107)
  0x01, 0x64, 0x01, 0x09, 0x01, // Ťĉ (U+0164 U+0109)
  0x01, 0x64, 0x01, 0x0B, 0x01, // Ťċ (U+0164 U+010B)
  0x01, 0x64, 0x01, 0x0D, 0x01, // Ťč (U+0164 U+010D)
  0x01, 0x64, 0x01, 0x0F, 0x01, // Ťď (U+0164 U+010F)
  0x01, 0x64, 0x01, 0x11, 0x01, // Ťđ (U+0164 U+0111)
  0x01, 0x64, 0x01, 0x13, 0x01, // Ťē (U+0164 U+0113)
  0x01, 0x64, 0x01, 0x15, 0x01, // Ťĕ (U+0164 U+0115)
  0x01, 0x64, 0x01, 0x17, 0x01, // Ťė (U+0164 U+0117)
  0x01, 0x64, 0x01, 0x19, 0x01, // Ťę (U+0164 U+0119)
  0x01, 0x64, 0x01, 0x1B, 0x01, // Ťě (U+0164 U+011B)
  0x01, 0x64, 0x01, 0x1D, 0x01, // Ťĝ (U+0164 U+011D)
  0x01, 0x64, 0x01, 0x1F, 0x01, // Ťğ (U+0164 U+011F)
  0x01, 0x64, 0x01, 0x21, 0x01, // Ťġ (U+0164 U+0121)
  0x01, 0x64, 0x01, 0x23, 0x01, // Ťģ (U+0164 U+0123)
  0x01, 0x64, 0x01, 0x4D, 0x01, // Ťō (U+0164 U+014D)
  0x01, 0x64, 0x01, 0x4F, 0x01, // Ťŏ (U+0164 U+014F)
  0x01, 0x64, 0x01, 0x51, 0x01, // Ťő (U+0164 U+0151)
  0x01, 0x64, 0x01, 0x53, 0x01, // Ťœ (U+0164 U+0153)
  0x01, 0x64, 0x01, 0x5B, 0x01, // Ťś (U+0164 U+015B)
  0x01, 0x64, 0x01, 0x5F, 0x01, // Ťş (U+0164 U+015F)
  0x01, 0x64, 0x20, 0x1A, 0x01, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x01, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x01, // Ť… (U+0164 U+2026)
  0x01, 0x64, 0x20, 0x39, 0x01, // Ť‹ (U+0164 U+2039)
  0x01, 0x66, 0x00, 0x2C, 0x01, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2E, 0x01, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0x61, 0x01, // Ŧa (U+0166 U+0061)
  0x01, 0x66, 0x00, 0x63, 0x01, // Ŧc (U+0166 U+0063)
  0x01, 0x66, 0x00, 0x64, 0x01, // Ŧd (U+0166 U+0064)
  0x01, 0x66, 0x00, 0x65, 0x01, // Ŧe (U+0166 U+0065)
  0x01, 0x66, 0x00, 0x67, 0x01, // Ŧg (U+0166 U+0067)
  0x01, 0x66, 0x00, 0x6F, 0x01, // Ŧo (U+0166 U+006F)
  0x01, 0x66, 0x00, 0x71, 0x01, // Ŧq (U+0166 U+0071)
  0x01, 0x66, 0x00, 0x73, 0x01, // Ŧs (U+0166 U+0073)
  0x01, 0x66, 0x00, 0xAB, 0x01, // Ŧ« (U+0166 U+00AB)
  0x01, 0x66, 0x00, 0xE0, 0x01, // Ŧà (U+0166 U+00E0)
  0x01, 0x66, 0x00, 0xE1, 0x01, // Ŧá (U+0166 U+00E1)
  0x01, 0x66, 0x00, 0xE2, 0x01, // Ŧâ (U+0166 U+00E2)
  0x01, 0x66, 0x00, 0xE3, 0x01, // Ŧã (U+0166 U+00E3)
  0x01, 0x66, 0x00, 0xE4, 0x01, // Ŧä (U+0166 U+00E4)
  0x01, 0x66, 0x00, 0xE5, 0x01, // Ŧå (U+0166 U+00E5)
  0x01, 0x66, 0x00, 0xE6, 0x01, // Ŧæ (U+0166 U+00E6)
  0x01, 0x66, 0x00, 0xE7, 0x01, // Ŧç (U+0166 U+00E7)
  0x01, 0x66, 0x00, 0xE8, 0x01, // Ŧè (U+0166 U+00E8)
  0x01, 0x66, 0x00, 0xE9, 0x01, // Ŧé (U+0166 U+00E9)
  0x01, 0x66, 0x00, 0xEA, 0x01, // Ŧê (U+0166 U+00EA)
  0x01, 0x66, 0x00, 0xEB, 0x01, // Ŧë (U+0166 U+00EB)
  0x01, 0x66, 0x00, 0xF2, 0x01, // Ŧò (U+0166 U+00F2)
  0x01, 0x66, 0x00, 0xF3, 0x01, // Ŧó (U+0166 U+00F3)
  0x01, 0x66, 0x00, 0xF4, 0x01, // Ŧô (U+0166 U+00F4)
  0x01, 0x66, 0x00, 0xF5, 0x01, // Ŧõ (U+0166 U+00F5)
  0x01, 0x66, 0x00, 0xF6, 0x01, // Ŧö (U+0166 U+00F6)
  0x01, 0x66, 0x00, 0xF8, 0x01, // Ŧø (U+0166 U+00F8)
  0x01, 0x66, 0x01, 0x01, 0x01, // Ŧā (U+0166 U+0101)
  0x01, 0x66, 0x01, 0x03, 0x01, // Ŧă (U+0166 U+0103)
  0x01, 0x66, 0x01, 0x05, 0x01, // Ŧą (U+0166 U+0105)
  0x01, 0x66, 0x01, 0x07, 0x01, // Ŧć (U+0166 U+0107)
  0x01, 0x66, 0x01, 0x09, 0x01, // Ŧĉ (U+0166 U+0109)
  0x01, 0x66, 0x01, 0x0B, 0x01, // Ŧċ (U+0166 U+010B)
  0x01, 0x66, 0x01, 0x0D, 0x01, // Ŧč (U+0166 U+010D)
  0x01, 0x66, 0x01, 0x0F, 0x01, // Ŧď (U+0166 U+010F)
  0x01, 0x66, 0x01, 0x11, 0x01, // Ŧđ (U+0166 U+0111)
  0x01, 0x66, 0x01, 0x13, 0x01, // Ŧē (U+0166 U+0113)
  0x01, 0x66, 0x01, 0x15, 0x01, // Ŧĕ (U+0166 U+0115)
  0x01, 0x66, 0x01, 0x17, 0x01, // Ŧė (U+0166 U+0117)
  0x01, 0x66, 0x01, 0x19, 0x01, // Ŧę (U+0166 U+0119)
  0x01, 0x66, 0x01, 0x1B, 0x01, // Ŧě (U+0166 U+011B)
  0x01, 0x66, 0x01, 0x1D, 0x01, // Ŧĝ (U+0166 U+011D)
  0x01, 0x66, 0x01, 0x1F, 0x01, // Ŧğ (U+0166 U+011F)
  0x01, 0x66, 0x01, 0x21, 0x01, // Ŧġ (U+0166 U+0121)
  0x01, 0x66, 0x01, 0x23, 0x01, // Ŧģ (U+0166 U+0123)
  0x01, 0x66, 0x01, 0x4D, 0x01, // Ŧō (U+0166 U+014D)
  0x01, 0x66, 0x01, 0x4F, 0x01, // Ŧŏ (U+0166 U+014F)
  0x01, 0x66, 0x01, 0x51, 0x01, // Ŧő (U+0166 U+0151)
  0x01, 0x66, 0x01, 0x53, 0x01, // Ŧœ (U+0166 U+0153)
  0x01, 0x66, 0x01, 0x5B, 0x01, // Ŧś (U+0166 U+015B)
  0x01, 0x66, 0x01, 0x5F, 0x01, // Ŧş (U+0166 U+015F)
  0x01, 0x66, 0x20, 0x1A, 0x01, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x01, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x01, // Ŧ… (U+0166 U+2026)
  0x01, 0x66, 0x20, 0x39, 0x01, // Ŧ‹ (U+0166 U+2039)
  0x01, 0x76, 0x00, 0x2C, 0x01, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x01, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x00, 0xAB, 0x01, // Ŷ« (U+0176 U+00AB)
  0x01, 0x76, 0x20, 0x1A, 0x01, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x01, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x01, // Ŷ… (U+0176 U+2026)
  0x01, 0x76, 0x20, 0x39, 0x01, // Ŷ‹ (U+0176 U+2039)
  0x01, 0x78, 0x00, 0x2C, 0x01, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x01, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x00, 0xAB, 0x01, // Ÿ« (U+0178 U+00AB)
  0x01, 0x78, 0x20, 0x1A, 0x01, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x01, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x01, // Ÿ… (U+0178 U+2026)
  0x01, 0x78, 0x20, 0x39, 0x01, // Ÿ‹ (U+0178 U+2039)
  0x20, 0x18, 0x00, 0x41, 0x01, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0x63, 0x01, // ‘c (U+2018 U+0063)
  0x20, 0x18, 0x00, 0x64, 0x01, // ‘d (U+2018 U+0064)
  0x20, 0x18, 0x00, 0x65, 0x01, // ‘e (U+2018 U+0065)
  0x20, 0x18, 0x00, 0x6F, 0x01, // ‘o (U+2018 U+006F)
  0x20, 0x18, 0x00, 0x71, 0x01, // ‘q (U+2018 U+0071)
  0x20, 0x18, 0x00, 0xC0, 0x01, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x01, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x01, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x01, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x01, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x01, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xC6, 0x01, // ‘Æ (U+2018 U+00C6)
  0x20, 0x18, 0x00, 0xE0, 0x01, // ‘à (U+2018 U+00E0)
  0x20, 0x18, 0x00, 0xE7, 0x01, // ‘ç (U+2018 U+00E7)
  0x20, 0x18, 0x00, 0xE8, 0x01, // ‘è (U+2018 U+00E8)
  0x20, 0x18, 0x00, 0xE9, 0x01, // ‘é (U+2018 U+00E9)
  0x20, 0x18, 0x00, 0xEA, 0x01, // ‘ê (U+2018 U+00EA)
  0x20, 0x18, 0x00, 0xEB, 0x01, // ‘ë (U+2018 U+00EB)
  0x20, 0x18, 0x00, 0xF2, 0x01, // ‘ò (U+2018 U+00F2)
  0x20, 0x18, 0x00, 0xF3, 0x01, // ‘ó (U+2018 U+00F3)
  0x20, 0x18, 0x00, 0xF4, 0x01, // ‘ô (U+2018 U+00F4)
  0x20, 0x18, 0x00, 0xF5, 0x01, // ‘õ (U+2018 U+00F5)
  0x20, 0x18, 0x00, 0xF6, 0x01, // ‘ö (U+2018 U+00F6)
  0x20, 0x18, 0x00, 0xF8, 0x01, // ‘ø (U+2018 U+00F8)
  0x20, 0x18, 0x01, 0x00, 0x01, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x02, 0x01, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x04, 0x01, // ‘Ą (U+2018 U+0104)
  0x20, 0x18, 0x01, 0x07, 0x01, // ‘ć (U+2018 U+0107)
  0x20, 0x18, 0x01, 0x09, 0x01, // ‘ĉ (U+2018 U+0109)
  0x20, 0x18, 0x01, 0x0B, 0x01, // ‘ċ (U+2018 U+010B)
  0x20, 0x18, 0x01, 0x0D, 0x01, // ‘č (U+2018 U+010D)
  0x20, 0x18, 0x01, 0x0F, 0x01, // ‘ď (U+2018 U+010F)
  0x20, 0x18, 0x01, 0x11, 0x01, // ‘đ (U+2018 U+0111)
  0x20, 0x18, 0x01, 0x13, 0x01, // ‘ē (U+2018 U+0113)
  0x20, 0x18, 0x01, 0x15, 0x01, // ‘ĕ (U+2018 U+0115)
  0x20, 0x18, 0x01, 0x17, 0x01, // ‘ė (U+2018 U+0117)
  0x20, 0x18, 0x01, 0x19, 0x01, // ‘ę (U+2018 U+0119)
  0x20, 0x18, 0x01, 0x1B, 0x01, // ‘ě (U+2018 U+011B)
  0x20, 0x18, 0x01, 0x4D, 0x01, // ‘ō (U+2018 U+014D)
  0x20, 0x18, 0x01, 0x4F, 0x01, // ‘ŏ (U+2018 U+014F)
  0x20, 0x18, 0x01, 0x51, 0x01, // ‘ő (U+2018 U+0151)
  0x20, 0x18, 0x01, 0x53, 0x01, // ‘œ (U+2018 U+0153)
  0x20, 0x19, 0x00, 0x41, 0x01, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0x63, 0x01, // ’c (U+2019 U+0063)
  0x20, 0x19, 0x00, 0x64, 0x01, // ’d (U+2019 U+0064)
  0x20, 0x19, 0x00, 0x65, 0x01, // ’e (U+2019 U+0065)
  0x20, 0x19, 0x00, 0x6F, 0x01, // ’o (U+2019 U+006F)
  0x20, 0x19, 0x00, 0x71, 0x01, // ’q (U+2019 U+0071)
  0x20, 0x19, 0x00, 0xC0, 0x01, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x01, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x01, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x01, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x01, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x01, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xC6, 0x01, // ’Æ (U+2019 U+00C6)
  0x20, 0x19, 0x00, 0xE0, 0x01, // ’à (U+2019 U+00E0)
  0x20, 0x19, 0x00, 0xE7, 0x01, // ’ç (U+2019 U+00E7)
  0x20, 0x19, 0x00, 0xE8, 0x01, // ’è (U+2019 U+00E8)
  0x20, 0x19, 0x00, 0xE9, 0x01, // ’é (U+2019 U+00E9)
  0x20, 0x19, 0x00, 0xEA, 0x01, // ’ê (U+2019 U+00EA)
  0x20, 0x19, 0x00, 0xEB, 0x01, // ’ë (U+2019 U+00EB)
  0x20, 0x19, 0x00, 0xF2, 0x01, // ’ò (U+2019 U+00F2)
  0x20, 0x19, 0x00, 0xF3, 0x01, // ’ó (U+2019 U+00F3)
  0x20, 0x19, 0x00, 0xF4, 0x01, // ’ô (U+2019 U+00F4)
  0x20, 0x19, 0x00, 0xF5, 0x01, // ’õ (U+2019 U+00F5)
  0x20, 0x19, 0x00, 0xF6, 0x01, // ’ö (U+2019 U+00F6)
  0x20, 0x19, 0x00, 0xF8, 0x01, // ’ø (U+2019 U+00F8)
  0x20, 0x19, 0x01, 0x00, 0x01, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x02, 0x01, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x04, 0x01, // ’Ą (U+2019 U+0104)
  0x20, 0x19, 0x01, 0x07, 0x01, // ’ć (U+2019 U+0107)
  0x20, 0x19, 0x01, 0x09, 0x01, // ’ĉ (U+2019 U+0109)
  0x20, 0x19, 0x01, 0x0B, 0x01, // ’ċ (U+2019 U+010B)
  0x20, 0x19, 0x01, 0x0D, 0x01, // ’č (U+2019 U+010D)
  0x20, 0x19, 0x01, 0x0F, 0x01, // ’ď (U+2019 U+010F)
  0x20, 0x19, 0x01, 0x11, 0x01, // ’đ (U+2019 U+0111)
  0x20, 0x19, 0x01, 0x13, 0x01, // ’ē (U+2019 U+0113)
  0x20, 0x19, 0x01, 0x15, 0x01, // ’ĕ (U+2019 U+0115)
  0x20, 0x19, 0x01, 0x17, 0x01, // ’ė (U+2019 U+0117)
  0x20, 0x19, 0x01, 0x19, 0x01, // ’ę (U+2019 U+0119)
  0x20, 0x19, 0x01, 0x1B, 0x01, // ’ě (U+2019 U+011B)
  0x20, 0x19, 0x01, 0x4D, 0x01, // ’ō (U+2019 U+014D)
  0x20, 0x19, 0x01, 0x4F, 0x01, // ’ŏ (U+2019 U+014F)
  0x20, 0x19, 0x01, 0x51, 0x01, // ’ő (U+2019 U+0151)
  0x20, 0x19, 0x01, 0x53, 0x01, // ’œ (U+2019 U+0153)
  0x20, 0x1A, 0x00, 0x54, 0x01, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x56, 0x01, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x01, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x01, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0xDD, 0x01, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x01, 0x62, 0x01, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x01, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x01, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1A, 0x01, 0x74, 0x01, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x76, 0x01, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x78, 0x01, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x01, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0x63, 0x01, // “c (U+201C U+0063)
  0x20, 0x1C, 0x00, 0x64, 0x01, // “d (U+201C U+0064)
  0x20, 0x1C, 0x00, 0x65, 0x01, // “e (U+201C U+0065)
  0x20, 0x1C, 0x00, 0x6F, 0x01, // “o (U+201C U+006F)
  0x20, 0x1C, 0x00, 0x71, 0x01, // “q (U+201C U+0071)
  0x20, 0x1C, 0x00, 0xC0, 0x01, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x01, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x01, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x01, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x01, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x01, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xC6, 0x01, // “Æ (U+201C U+00C6)
  0x20, 0x1C, 0x00, 0xE0, 0x01, // “à (U+201C U+00E0)
  0x20, 0x1C, 0x00, 0xE7, 0x01, // “ç (U+201C U+00E7)
  0x20, 0x1C, 0x00, 0xE8, 0x01, // “è (U+201C U+00E8)
  0x20, 0x1C, 0x00, 0xE9, 0x01, // “é (U+201C U+00E9)
  0x20, 0x1C, 0x00, 0xEA, 0x01, // “ê (U+201C U+00EA)
  0x20, 0x1C, 0x00, 0xEB, 0x01, // “ë (U+201C U+00EB)
  0x20, 0x1C, 0x00, 0xF2, 0x01, // “ò (U+201C U+00F2)
  0x20, 0x1C, 0x00, 0xF3, 0x01, // “ó (U+201C U+00F3)
  0x20, 0x1C, 0x00, 0xF4, 0x01, // “ô (U+201C U+00F4)
  0x20, 0x1C, 0x00, 0xF5, 0x01, // “õ (U+201C U+00F5)
  0x20, 0x1C, 0x00, 0xF6, 0x01, // “ö (U+201C U+00F6)
  0x20, 0x1C, 0x00, 0xF8, 0x01, // “ø (U+201C U+00F8)
  0x20, 0x1C, 0x01, 0x00, 0x01, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x02, 0x01, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x04, 0x01, // “Ą (U+201C U+0104)
  0x20, 0x1C, 0x01, 0x07, 0x01, // “ć (U+201C U+0107)
  0x20, 0x1C, 0x01, 0x09, 0x01, // “ĉ (U+201C U+0109)
  0x20, 0x1C, 0x01, 0x0B, 0x01, // “ċ (U+201C U+010B)
  0x20, 0x1C, 0x01, 0x0D, 0x01, // “č (U+201C U+010D)
  0x20, 0x1C, 0x01, 0x0F, 0x01, // “ď (U+201C U+010F)
  0x20, 0x1C, 0x01, 0x11, 0x01, // “đ (U+201C U+0111)
  0x20, 0x1C, 0x01, 0x13, 0x01, // “ē (U+201C U+0113)
  0x20, 0x1C, 0x01, 0x15, 0x01, // “ĕ (U+201C U+0115)
  0x20, 0x1C, 0x01, 0x17, 0x01, // “ė (U+201C U+0117)
  0x20, 0x1C, 0x01, 0x19, 0x01, // “ę (U+201C U+0119)
  0x20, 0x1C, 0x01, 0x1B, 0x01, // “ě (U+201C U+011B)
  0x20, 0x1C, 0x01, 0x4D, 0x01, // “ō (U+201C U+014D)
  0x20, 0x1C, 0x01, 0x4F, 0x01, // “ŏ (U+201C U+014F)
  0x20, 0x1C, 0x01, 0x51, 0x01, // “ő (U+201C U+0151)
  0x20, 0x1C, 0x01, 0x53, 0x01, // “œ (U+201C U+0153)
  0x20, 0x1D, 0x00, 0x41, 0x01, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0x63, 0x01, // ”c (U+201D U+0063)
  0x20, 0x1D, 0x00, 0x64, 0x01, // ”d (U+201D U+0064)
  0x20, 0x1D, 0x00, 0x65, 0x01, // ”e (U+201D U+0065)
  0x20, 0x1D, 0x00, 0x6F, 0x01, // ”o (U+201D U+006F)
  0x20, 0x1D, 0x00, 0x71, 0x01, // ”q (U+201D U+0071)
  0x20, 0x1D, 0x00, 0xC0, 0x01, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x01, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x01, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x01, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x01, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x01, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xC6, 0x01, // ”Æ (U+201D U+00C6)
  0x20, 0x1D, 0x00, 0xE0, 0x01, // ”à (U+201D U+00E0)
  0x20, 0x1D, 0x00, 0xE7, 0x01, // ”ç (U+201D U+00E7)
  0x20, 0x1D, 0x00, 0xE8, 0x01, // ”è (U+201D U+00E8)
  0x20, 0x1D, 0x00, 0xE9, 0x01, // ”é (U+201D U+00E9)
  0x20, 0x1D, 0x00, 0xEA, 0x01, // ”ê (U+201D U+00EA)
  0x20, 0x1D, 0x00, 0xEB, 0x01, // ”ë (U+201D U+00EB)
  0x20, 0x1D, 0x00, 0xF2, 0x01, // ”ò (U+201D U+00F2)
  0x20, 0x1D, 0x00, 0xF3, 0x01, // ”ó (U+201D U+00F3)
  0x20, 0x1D, 0x00, 0xF4, 0x01, // ”ô (U+201D U+00F4)
  0x20, 0x1D, 0x00, 0xF5, 0x01, // ”õ (U+201D U+00F5)
  0x20, 0x1D, 0x00, 0xF6, 0x01, // ”ö (U+201D U+00F6)
  0x20, 0x1D, 0x00, 0xF8, 0x01, // ”ø (U+201D U+00F8)
  0x20, 0x1D, 0x01, 0x00, 0x01, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x02, 0x01, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x04, 0x01, // ”Ą (U+201D U+0104)
  0x20, 0x1D, 0x01, 0x07, 0x01, // ”ć (U+201D U+0107)
  0x20, 0x1D, 0x01, 0x09, 0x01, // ”ĉ (U+201D U+0109)
  0x20, 0x1D, 0x01, 0x0B, 0x01, // ”ċ (U+201D U+010B)
  0x20, 0x1D, 0x01, 0x0D, 0x01, // ”č (U+201D U+010D)
  0x20, 0x1D, 0x01, 0x0F, 0x01, // ”ď (U+201D U+010F)
  0x20, 0x1D, 0x01, 0x11, 0x01, // ”đ (U+201D U+0111)
  0x20, 0x1D, 0x01, 0x13, 0x01, // ”ē (U+201D U+0113)
  0x20, 0x1D, 0x01, 0x15, 0x01, // ”ĕ (U+201D U+0115)
  0x20, 0x1D, 0x01, 0x17, 0x01, // ”ė (U+201D U+0117)
  0x20, 0x1D, 0x01, 0x19, 0x01, // ”ę (U+201D U+0119)
  0x20, 0x1D, 0x01, 0x1B, 0x01, // ”ě (U+201D U+011B)
  0x20, 0x1D, 0x01, 0x4D, 0x01, // ”ō (U+201D U+014D)
  0x20, 0x1D, 0x01, 0x4F, 0x01, // ”ŏ (U+201D U+014F)
  0x20, 0x1D, 0x01, 0x51, 0x01, // ”ő (U+201D U+0151)
  0x20, 0x1D, 0x01, 0x53, 0x01, // ”œ (U+201D U+0153)
  0x20, 0x1E, 0x00, 0x54, 0x01, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x56, 0x01, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x01, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x01, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0xDD, 0x01, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x01, 0x62, 0x01, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x01, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x01, // „Ŧ (U+201E U+0166)
  0x20, 0x1E, 0x01, 0x74, 0x01, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x76, 0x01, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x78, 0x01, // „Ÿ (U+201E U+0178)
  0x20, 0x3A, 0x00, 0x54, 0x01, // ›T (U+203A U+0054)
  0x20, 0x3A, 0x00, 0x59, 0x01, // ›Y (U+203A U+0059)
  0x20, 0x3A, 0x00, 0xDD, 0x01, // ›Ý (U+203A U+00DD)
  0x20, 0x3A, 0x01, 0x62, 0x01, // ›Ţ (U+203A U+0162)
  0x20, 0x3A, 0x01, 0x64, 0x01, // ›Ť (U+203A U+0164)
  0x20, 0x3A, 0x01, 0x66, 0x01, // ›Ŧ (U+203A U+0166)
  0x20, 0x3A, 0x01, 0x76, 0x01, // ›Ŷ (U+203A U+0176)
  0x20, 0x3A, 0x01, 0x78, 0x01, // ›Ÿ (U+203A U+0178)
  0x20, 0x44, 0x00, 0x30, 0x02, // ⁄0 (U+2044 U+0030)
  0x20, 0x44, 0x00, 0x31, 0x02, // ⁄1 (U+2044 U+0031)
  0x20, 0x44, 0x00, 0x32, 0x02, // ⁄2 (U+2044 U+0032)
  0x20, 0x44, 0x00, 0x33, 0x02, // ⁄3 (U+2044 U+0033)
  0x20, 0x44, 0x00, 0x34, 0x02, // ⁄4 (U+2044 U+0034)
  0x20, 0x44, 0x00, 0x35, 0x02, // ⁄5 (U+2044 U+0035)
  0x20, 0x44, 0x00, 0x36, 0x02, // ⁄6 (U+2044 U+0036)
  0x20, 0x44, 0x00, 0x37, 0x02, // ⁄7 (U+2044 U+0037)
  0x20, 0x44, 0x00, 0x38, 0x02, // ⁄8 (U+2044 U+0038)
  0x20, 0x44, 0x00, 0x39, 0x02, // ⁄9 (U+2044 U+0039)
  
  // Glyph data
  // "!" (U+0021)
  0x8A, 0x05, 0xF7, 0x4F, 0x73, 0xF6, 0x3F, 0x52, 0xF5, 0x1F, 0x43, 0x84, 0x2F, 0x52, 0xE5,
  // """ (U+0022)
  0x89, 0x55, 0xF4, 0xDB, 0x4F, 0x3C, 0xA2, 0xF1, 0xA9,
  // "#" (U+0023)
  0x28, 0x2B, 0x69, 0x93, 0x82, 0xD4, 0xB7, 0x39, 0x83, 0x3C, 0x50, 0x6D, 0x87, 0x62, 0x8D, 0x6F,
  0x51, 0xBD, 0x85, 0x13, 0xBA, 0xAC, 0x42, 0x82, 0xC6, 0x98, 0x38, 0x2E, 0x3C, 0x62,
  // "$" (U+0024)
  0x20, 0x50, 0x63, 0x89, 0x59, 0xEF, 0xC2, 0x5F, 0xBA, 0xA1, 0x6F, 0x66, 0x28, 0x21, 0xEF, 0x93,
  0x83, 0x1A, 0xFD, 0x12, 0x89, 0x15, 0x8F, 0x75, 0x67, 0x9F, 0x66, 0xB0, 0xC2, 0x81, 0x28, 0x82,
  // "%" (U+0025)
  0x86, 0x1C, 0xE4, 0x01, 0xF2, 0x28, 0x57, 0xEB, 0xC0, 0x8B, 0x38, 0x59, 0xA5, 0xE0, 0xE4, 0x38,
  0x91, 0x8C, 0x8D, 0x5D, 0x7E, 0x80, 0x2A, 0x89, 0x77, 0xC8, 0xF7, 0xF2, 0x01, 0x33, 0xF4, 0xF1,
  0xF4, 0x38, 0x59, 0x93, 0xF1, 0xF4, 0x38, 0x5E, 0x30, 0xFA, 0xF2, 0x20, 0x60, 0xC2, 0x81, 0x7E,
  0x81,
  // "&" (U+0026)
  0x18, 0x24, 0xDE, 0x94, 0x83, 0xDD, 0xAF, 0x33, 0x83, 0xCB, 0x6F, 0x23, 0x06, 0xA0, 0x83, 0x01,
  0x0C, 0xA8, 0x96, 0x38, 0xF1, 0x7F, 0x7E, 0xDD, 0xD0, 0x9F, 0x14, 0xA8, 0x46, 0x06, 0xFA, 0x8A,
  0x07, 0x28, 0x59, 0xEE, 0x9C, 0xF3,
  // "'" (U+0027)
  0x87, 0x5F, 0x44, 0xF3, 0x2F, 0x10,
  // "(" (U+0028)
  0x18, 0x42, 0xF5, 0x09, 0xD2, 0x8B, 0x0E, 0x70, 0x3F, 0x30, 0x6F, 0x10, 0x7F, 0x10, 0x6F, 0x10,
  0x4F, 0x30, 0x1F, 0x72, 0x0A, 0x0D, 0x28, 0x12, 0xF5,
  // ")" (U+0029)
  0x07, 0x0D, 0x30, 0xE0, 0x72, 0x0A, 0x0D, 0x28, 0xA4, 0x6F, 0x10, 0x4F, 0x30, 0x3F, 0x40, 0x4F,
  0x40, 0x6F, 0x10, 0xAD, 0x28, 0x3E, 0x70, 0x7D, 0x20,
  // "*" (U+002A)
  0x20, 0xD0, 0x82, 0x86, 0x45, 0xC8, 0x71, 0x8E, 0xA8, 0x5D, 0x40, 0x7E, 0xE2, 0x28, 0x2D, 0x6B,
  0x94, 0x01, 0x20,
  // "+" (U+002B)
  0x20, 0x90, 0xA2, 0x85, 0x11, 0xAA, 0x11, 0x8C, 0x85, 0x92, 0x4B, 0xB4, 0x22, 0x09, 0x0A, 0x40,
  0x90, 0xA2,
  // "," (U+002C)
  0x86, 0x2F, 0x74, 0xF3, 0x7D, 0x10,
  // "-" (U+002D)
  0x0F, 0x11, 0x0A, 0xA8, 0x36, 0x34, 0x41,
  // "." (U+002E)
  0x84, 0x2F, 0x52, 0xE5,
  // "/" (U+002F)
  0x30, 0xD0, 0x92, 0x81, 0x3F, 0x32, 0x08, 0x0D, 0x30, 0xE0, 0x82, 0x81, 0x4F, 0x22, 0x0A, 0x0C,
  0x30, 0xE0, 0x72, 0x81, 0x5F, 0x12, 0x00, 0xB3,
  // "0" (U+0030)
  0x18, 0xE2, 0x6E, 0xE5, 0x01, 0xFB, 0xCF, 0x16, 0xF3, 0x4F, 0x58, 0xF2, 0x2F, 0x78, 0xF1, 0x2F,
  0x88, 0xF2, 0x2F, 0x76, 0xF3, 0x4F, 0x51, 0xFB, 0xBF, 0x10, 0x6E, 0xE5, 0x10,
  // "1" (U+0031)
  0x28, 0x36, 0xF7, 0x06, 0xA8, 0x91, 0x72, 0xFA, 0xF7, 0x04, 0x2F, 0x72, 0x81, 0x2F, 0x72, 0x81,
  0x2F, 0x72, 0x81, 0x2F, 0x72, 0x81, 0x2F, 0x72, 0x81, 0x2F, 0x70,
  // "2" (U+0032)
  0x8A, 0x01, 0xAE, 0xD5, 0x05, 0xE7, 0xCF, 0x10, 0x10, 0x6F, 0x43, 0x81, 0x9F, 0x12, 0x81, 0x2F,
  0xA3, 0x81, 0xCE, 0x12, 0x81, 0x9F, 0x42, 0x85, 0x5F, 0xC6, 0x62, 0x9C, 0x07,
  // "3" (U+0033)
  0x89, 0x23, 0xBE, 0xE6, 0x03, 0xC7, 0xCF, 0x23, 0x86, 0x6F, 0x30, 0x13, 0xBD, 0x28, 0x27, 0xFE,
  0x42, 0x83, 0x25, 0xBF, 0x33, 0x89, 0x44, 0xF6, 0x78, 0x7C, 0xF3, 0x6D, 0xFD, 0x61,
  // "4" (U+0034)
  0x30, 0x0E, 0x38, 0x17, 0xFE, 0x20, 0x10, 0xFE, 0x28, 0xA0, 0x8D, 0xBE, 0x01, 0xE5, 0xBE, 0x08,
  0xD2, 0xBE, 0x1C, 0xC8, 0x5C, 0x34, 0x4C, 0xE3, 0x30, 0xB0, 0xE1,
  // "5" (U+0035)
  0x1C, 0x18, 0x90, 0x1F, 0x96, 0x60, 0x2F, 0x51, 0x20, 0x4B, 0x86, 0x90, 0x16, 0x5C, 0xF3, 0x38,
  0x14, 0xF6, 0x38, 0x94, 0x5F, 0x55, 0x97, 0xDE, 0x14, 0xDF, 0xC4, 0x10,
  // "6" (U+0036)
  0x18, 0x95, 0x1A, 0xEF, 0x10, 0xCE, 0x87, 0x12, 0xF4, 0x12, 0x8C, 0x16, 0xFA, 0xFC, 0x07, 0xFA,
  0x8F, 0x58, 0xF2, 0x1F, 0x86, 0xF3, 0x1F, 0x71, 0xFB, 0xAF, 0x30, 0x5D, 0xE7, 0x10,
  // "7" (U+0037)
  0x09, 0xC8, 0x59, 0x36, 0x68, 0xF6, 0x38, 0x18, 0xF1, 0x30, 0xD0, 0xB3, 0x81, 0x3F, 0x63, 0x81,
  0x9F, 0x13, 0x0E, 0x0B, 0x38, 0x15, 0xF6, 0x38, 0x1A, 0xF1, 0x20,
  // "8" (U+0038)
  0x18, 0xA4, 0x8E, 0xE8, 0x04, 0xFB, 0xBF, 0x35, 0xF4, 0x4F, 0x40, 0xDC, 0xDD, 0x20, 0x8A, 0x87,
  0x60, 0x4F, 0x89, 0xF4, 0x89, 0x29, 0x89, 0x28, 0x6F, 0x99, 0xF6, 0x09, 0xEE, 0x91,
  // "9" (U+0039)
  0x18, 0xC1, 0x8E, 0xD4, 0x05, 0xF9, 0xBF, 0x18, 0xF1, 0x3F, 0x67, 0xF5, 0x7F, 0x72, 0xEF, 0xCF,
  0x70, 0x13, 0x3F, 0x63, 0x89, 0x47, 0xF2, 0x17, 0x8F, 0xB0, 0x2F, 0xEA, 0x11,
  // ":" (U+003A)
  0x84, 0x2E, 0x53, 0xE6, 0x72, 0x84, 0x2F, 0x63, 0xE5,
  // ";" (U+003B)
  0x84, 0x2E, 0x53, 0xE6, 0x72, 0x86, 0x2F, 0x75, 0xF3, 0x7D, 0x10,
  // "<" (U+003C)
  0x50, 0x13, 0x89, 0x33, 0xB9, 0x03, 0xBF, 0xA2, 0x8F, 0xB2, 0x28, 0x32, 0xAF, 0xB4, 0x38, 0x22,
  0x9F, 0x84, 0x01, 0x04,
  // "=" (U+003D)
  0x80, 0x21, 0x08, 0xC8, 0x59, 0x24, 0x44, 0x42, 0x80, 0x21, 0x08, 0xC8, 0x59, 0x24, 0x44, 0x42,
  // ">" (U+003E)
  0x01, 0x58, 0x18, 0xB3, 0x38, 0x32, 0xAF, 0xB3, 0x38, 0x94, 0x1B, 0xF8, 0x04, 0xBF, 0xA2, 0x8F,
  0x92, 0x20, 0x40, 0x14,
  // "?" (U+003F)
  0x89, 0x07, 0xDE, 0xA0, 0x89, 0x9F, 0x72, 0x81, 0x1F, 0x82, 0x85, 0x9F, 0x20, 0x6F, 0x52, 0x09,
  0x0B, 0x71, 0x0A, 0x0D, 0x30, 0xA0, 0xC2,
  // "@" (U+0040)
  0x28, 0x33, 0xBE, 0xE9, 0x38, 0x53, 0xFB, 0x78, 0xEB, 0x28, 0xF3, 0xC9, 0x5D, 0xD7, 0xE5, 0x3F,
  0x2E, 0x9C, 0x88, 0x96, 0xC4, 0xE0, 0xA8, 0x6B, 0x7B, 0x6D, 0x0C, 0x76, 0xA6, 0xD4, 0xE3, 0xE9,
  0xA8, 0x3F, 0x3D, 0xF8, 0xFE, 0x20, 0xBE, 0x66, 0x27, 0x22, 0x01, 0x0B, 0xB0, 0xD5, 0x81, 0x24,
  0x33,
  // "A" (U+0041)
  0x28, 0x1C, 0xFA, 0x49, 0x00, 0xE3, 0x83, 0x4F, 0x9F, 0x22, 0x83, 0x8F, 0x3F, 0x62, 0x89, 0x4C,
  0xC0, 0xEB, 0x01, 0xFD, 0x8D, 0xE0, 0x5D, 0x89, 0x03, 0x9F, 0x20, 0x4F, 0x7D, 0xE3, 0x90, 0xB0,
  // "B" (U+0042)
  0x02, 0xB8, 0xA7, 0xC4, 0x02, 0xFB, 0x7E, 0xE0, 0x2F, 0x80, 0x9F, 0x12, 0xF9, 0x2D, 0xD0, 0x2C,
  0x8A, 0x65, 0x02, 0xFA, 0x5C, 0xF1, 0x2F, 0x80, 0x7F, 0x42, 0xFB, 0x6D, 0xF1, 0x2B, 0x0D, 0x05,
  0x10,
  // "C" (U+0043)
  0x28, 0x93, 0x9E, 0xE9, 0x0A, 0xF9, 0x89, 0x1F, 0xA3, 0x81, 0x5F, 0x63, 0x81, 0x6F, 0x53, 0x81,
  0x4F, 0x63, 0x81, 0x2F, 0xA4, 0x89, 0x1B, 0xF9, 0x78, 0x01, 0xAE, 0xE8,
  // "D" (U+0044)
  0x02, 0xB8, 0xA2, 0xB3, 0x02, 0xFB, 0x7E, 0xE1, 0x2F, 0x80, 0x4F, 0x82, 0xF8, 0x29, 0x82, 0xB2,
  0xF8, 0x29, 0x82, 0xC2, 0xF8, 0x29, 0x89, 0x6A, 0x2F, 0x80, 0x5F, 0x72, 0xFB, 0x8E, 0xE1, 0x2A,
  0x81, 0xEB, 0x21,
  // "E" (U+0045)
  0x02, 0xC8, 0x62, 0xFB, 0x66, 0x2F, 0x82, 0x84, 0x2F, 0x91, 0x12, 0xB8, 0x7D, 0x2F, 0xA4, 0x32,
  0xF8, 0x28, 0x42, 0xFB, 0x66, 0x2C,
  // "F" (U+0046)
  0x02, 0xC8, 0x62, 0xFB, 0x66, 0x2F, 0x82, 0x84, 0x2F, 0x91, 0x12, 0xB8, 0x7D, 0x2F, 0xA4, 0x32,
  0xF8, 0x28, 0x12, 0xF8, 0x28, 0x12, 0xF8, 0x20,
  // "G" (U+0047)
  0x28, 0x95, 0x7D, 0xFC, 0x40, 0x9F, 0xB7, 0xA3, 0x1F, 0xB4, 0x89, 0x15, 0xF6, 0x01, 0x11, 0x6F,
  0x52, 0xA8, 0x91, 0xA4, 0xF6, 0x04, 0xFA, 0x1F, 0xA2, 0x89, 0x6E, 0xA0, 0xAF, 0x97, 0xFA, 0x01,
  0xAE, 0xED, 0x60,
  // "H" (U+0048)
  0x81, 0x2F, 0x82, 0x83, 0xEB, 0x2F, 0x82, 0x83, 0xEB, 0x2F, 0x82, 0x89, 0x0E, 0xB2, 0xF9, 0x11,
  0xEB, 0x2D, 0x89, 0x1B, 0x2F, 0xA4, 0x4E, 0xB2, 0xF8, 0x28, 0x3E, 0xB2, 0xF8, 0x28, 0x3E, 0xB2,
  0xF8, 0x20, 0xE0, 0xB0,
  // "I" (U+0049)
  0x09, 0xA8, 0x6C, 0x1D, 0xE2, 0x0C, 0xE2, 0x0C, 0x0E, 0x20, 0xC0, 0xE2, 0x0C, 0x0E, 0x28, 0x6C,
  0xE0, 0x1D, 0xE1, 0x9A, 0x0C,
  // "J" (U+004A)
  0x18, 0xC6, 0x2F, 0x80, 0x2F, 0x80, 0x2F, 0x80, 0x2F, 0x80, 0x2F, 0x80, 0x2F, 0x80, 0x2F, 0x80,
  0x2F, 0x80, 0x2F, 0x80, 0x5F, 0x7B, 0xA8, 0x22, 0x57, 0x21,
  // "K" (U+004B)
  0x8B, 0x02, 0xF8, 0x06, 0xF6, 0x2F, 0x81, 0xEC, 0x02, 0xF8, 0x9F, 0x30, 0x2F, 0xBF, 0xA2, 0x02,
  0xB0, 0x92, 0x8B, 0x22, 0xFD, 0xCF, 0x10, 0x2F, 0x84, 0xF8, 0x02, 0xF8, 0x0D, 0xE1, 0x2F, 0x80,
  0x6F, 0x70,
  // "L" (U+004C)
  0x81, 0x2F, 0x83, 0x81, 0x2F, 0x83, 0x81, 0x2F, 0x83, 0x81, 0x2F, 0x83, 0x81, 0x2F, 0x83, 0x81,
  0x2F, 0x83, 0x81, 0x2F, 0x83, 0x85, 0x2F, 0xC8, 0x81, 0x2C, 0x03,
  // "M" (U+004D)
  0x02, 0xA0, 0x42, 0x06, 0xA0, 0x2A, 0x09, 0x20, 0xBA, 0x82, 0x2F, 0xED, 0x28, 0xE6, 0xEE, 0xF2,
  0xFA, 0xF1, 0x4F, 0xAF, 0x2F, 0x7F, 0x68, 0xC8, 0xF2, 0xF6, 0xBA, 0xC8, 0x9F, 0x2F, 0x67, 0xEF,
  0x49, 0xF2, 0xF6, 0x3F, 0xE0, 0x9F, 0x2F, 0x60, 0xEB, 0x09, 0x90,
  // "N" (U+004E)
  0x02, 0xA8, 0x42, 0x04, 0xF4, 0x2A, 0x8D, 0x08, 0x04, 0xF4, 0x2F, 0xEE, 0x14, 0xF4, 0x2F, 0x9F,
  0x74, 0xF4, 0x2F, 0x6B, 0xE4, 0xF4, 0x2F, 0x65, 0xF9, 0xF4, 0x2F, 0x60, 0xDA, 0x84, 0x42, 0xF6,
  0x06, 0xA8, 0x24, 0x2F, 0x62, 0x81, 0xEF, 0x40,
  // "O" (U+004F)
  0x18, 0x31, 0xAE, 0xE9, 0x38, 0x90, 0xBF, 0x89, 0xF9, 0x02, 0xFA, 0x28, 0x4C, 0xF0, 0x4F, 0x62,
  0x84, 0x8F, 0x36, 0xF5, 0x28, 0x47, 0xF3, 0x5F, 0x62, 0x84, 0x8F, 0x22, 0xFA, 0x20, 0xC9, 0x28,
  0x4B, 0xF8, 0x9F, 0x82, 0x83, 0x1A, 0xEE, 0x92,
  // "P" (U+0050)
  0x02, 0xA8, 0xA4, 0xEB, 0x22, 0xFB, 0x8F, 0xB2, 0xF8, 0x0C, 0xE2, 0xF9, 0x3E, 0xC2, 0xB8, 0x4E,
  0x42, 0xFA, 0x42, 0x81, 0x2F, 0x83, 0x81, 0x2F, 0x83, 0x81, 0x2F, 0x83,
  // "Q" (U+0051)
  0x18, 0x31, 0xAE, 0xE9, 0x38, 0x90, 0xBF, 0x89, 0xF8, 0x02, 0xFA, 0x28, 0x4C, 0xE0, 0x4F, 0x62,
  0x84, 0x8F, 0x26, 0xF5, 0x28, 0x47, 0xF3, 0x5F, 0x62, 0x84, 0x8F, 0x22, 0xFA, 0x20, 0xC9, 0x28,
  0x4B, 0xF8, 0x9F, 0x92, 0x83, 0x1A, 0xEF, 0xC6, 0x81, 0xBF, 0x25, 0x81, 0x2E, 0xC1,
  // "R" (U+0052)
  0x02, 0xA8, 0xB0, 0xEB, 0x20, 0x2F, 0xB8, 0xFC, 0x02, 0xF8, 0x0C, 0xE0, 0x2F, 0x93, 0xEC, 0x02,
  0xB8, 0x6E, 0x30, 0x2F, 0xAB, 0xE2, 0x8A, 0x32, 0xF8, 0x4F, 0x70, 0x2F, 0x80, 0xDE, 0x02, 0xF8,
  0x06, 0xF6,
  // "S" (U+0053)
  0x18, 0x94, 0x7E, 0xEB, 0x14, 0xFB, 0x7C, 0x07, 0xF4, 0x38, 0x24, 0xFD, 0x33, 0x09, 0xA0, 0x73,
  0x82, 0x4E, 0xF1, 0x38, 0x94, 0x7F, 0x38, 0xA7, 0xDE, 0x05, 0xDF, 0xD4, 0x10,
  // "T" (U+0054)
  0x0C, 0xC8, 0x57, 0x56, 0xFC, 0x63, 0x29, 0x0A, 0x49, 0x0A, 0x49, 0x0A, 0x49, 0x0A, 0x49, 0x0A,
  0x49, 0x0A, 0x49, 0x0A, 0x20,
  // "U" (U+0055)
  0x8F, 0x42, 0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F, 0x92, 0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F, 0x92,
  0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F, 0x91, 0xF9, 0x02, 0xF8, 0x0D, 0xF9, 0xCF, 0x40, 0x2B, 0xED,
  0x61,
  // "V" (U+0056)
  0x00, 0xD2, 0x8A, 0x53, 0xF7, 0x9F, 0x10, 0x7F, 0x35, 0xF5, 0x0A, 0xE0, 0x1F, 0x80, 0xEB, 0x28,
  0x3C, 0xC2, 0xF7, 0x28, 0x38, 0xF6, 0xF3, 0x28, 0x24, 0xFC, 0xE4, 0xA0, 0xA4, 0x81, 0xCF, 0x62,
  // "W" (U+0057)
  0x0D, 0x0B, 0x20, 0xD0, 0xC2, 0x82, 0xCD, 0xAE, 0x2A, 0x29, 0x83, 0xA7, 0xF2, 0x4A, 0x8A, 0x43,
  0x2F, 0x74, 0xF5, 0x7D, 0xD6, 0x5F, 0x31, 0xF7, 0xAA, 0xB9, 0x89, 0x28, 0x6D, 0xAD, 0x78, 0xCB,
  0xD2, 0x86, 0xAD, 0xF4, 0x4E, 0xDA, 0x20, 0x7A, 0x00, 0x1A, 0x06, 0x28, 0x14, 0xFD, 0x28, 0x1D,
  0xF3, 0x10,
  // "X" (U+0058)
  0x89, 0x39, 0xF2, 0x0C, 0xE0, 0x2F, 0x93, 0xF7, 0x28, 0x3A, 0xEA, 0xE1, 0x20, 0x3A, 0x09, 0x48,
  0x1E, 0xF4, 0x30, 0x5A, 0x0A, 0x38, 0x95, 0xCD, 0x9F, 0x20, 0x4F, 0x72, 0xF9, 0x0B, 0xE2, 0x81,
  0xAF, 0x20,
  // "Y" (U+0059)
  0x0C, 0x0E, 0x28, 0x7B, 0xE1, 0x6F, 0x51, 0xF9, 0x28, 0x3E, 0xB7, 0xF3, 0x28, 0x29, 0xFE, 0xC3,
  0x02, 0xA0, 0x54, 0x0C, 0x95, 0x0B, 0x0E, 0x50, 0xB0, 0xE5, 0x0B, 0x0E, 0x30,
  // "Z" (U+005A)
  0x0A, 0xC8, 0x55, 0x46, 0x6C, 0xF2, 0x28, 0x11, 0xFA, 0x38, 0x18, 0xF2, 0x28, 0x11, 0xFA, 0x38,
  0x18, 0xF2, 0x28, 0x11, 0xEA, 0x38, 0x58, 0xF9, 0x66, 0x2B, 0xC0, 0x60,
  // "[" (U+005B)
  0x04, 0xA8, 0xC4, 0x74, 0xF8, 0x34, 0xF2, 0x04, 0xF2, 0x04, 0xF2, 0x04, 0xF2, 0x04, 0xF2, 0x04,
  0xF2, 0x04, 0xF2, 0x04, 0xF4, 0x04, 0xA8, 0x37, 0x14, 0x42,
  // "\" (U+005C)
  0x00, 0xB3, 0x81, 0x5F, 0x13, 0x0E, 0x06, 0x30, 0xA0, 0xC3, 0x81, 0x4F, 0x23, 0x0E, 0x08, 0x30,
  0x80, 0xD3, 0x81, 0x3F, 0x33, 0x0D, 0x09,
  // "]" (U+005D)
  0x0B, 0xA8, 0xC4, 0x14, 0xAF, 0x10, 0x6F, 0x10, 0x6F, 0x10, 0x6F, 0x10, 0x6F, 0x10, 0x6F, 0x10,
  0x6F, 0x10, 0x6F, 0x11, 0x7F, 0x1B, 0xA8, 0x21, 0x34, 0x41,
  // "^" (U+005E)
  0x20, 0x30, 0x44, 0x0C, 0x0E, 0x38, 0x23, 0xFE, 0x72, 0x89, 0x3B, 0xA7, 0xD0, 0x2F, 0x31, 0xE6,
  0x9C, 0x20, 0x80, 0xD0,
  // "_" (U+005F)
  0x80, 0x21, 0xD0, 0x78, 0x01, 0x40, 0x20,
  // "`" (U+0060)
  0x81, 0x3F, 0x92, 0x81, 0x4E, 0x30,
  // "a" (U+0061)
  0x18, 0x29, 0xEE, 0x82, 0x83, 0x97, 0xBF, 0x22, 0x84, 0x16, 0xF5, 0x2D, 0xB8, 0xA1, 0x58, 0xF7,
  0x7F, 0x58, 0xF8, 0xCF, 0x52, 0xDE, 0x6E, 0x50,
  // "b" (U+0062)
  0x81, 0x3F, 0x53, 0x81, 0x3F, 0x53, 0x81, 0x3F, 0x53, 0x8D, 0x03, 0xF8, 0xDD, 0x23, 0xFD, 0x7F,
  0xA3, 0xF7, 0x0B, 0xE3, 0xF5, 0x0A, 0xF3, 0xF7, 0x0B, 0xE3, 0xFD, 0x7F, 0xA3, 0xF7, 0xEC, 0x20,
  // "c" (U+0063)
  0x18, 0x92, 0x5D, 0xE9, 0x1F, 0xC7, 0x66, 0xF3, 0x28, 0x17, 0xF2, 0x28, 0x16, 0xF3, 0x28, 0x90,
  0x2F, 0xC7, 0x80, 0x6D, 0xE8,
  // "d" (U+0064)
  0x40, 0xD0, 0xB4, 0x0D, 0x0B, 0x48, 0xD2, 0xDB, 0x08, 0xE9, 0xDB, 0x3F, 0xB9, 0xFB, 0x6F, 0x30,
  0xEB, 0x7F, 0x10, 0xDB, 0x6F, 0x30, 0xEB, 0x3F, 0xB9, 0xFB, 0x08, 0xE9, 0xBB,
  // "e" (U+0065)
  0x18, 0xA0, 0x5D, 0xE6, 0x02, 0xFB, 0x9F, 0x26, 0xF4, 0x2F, 0x77, 0xC8, 0xA1, 0x86, 0xF6, 0x44,
  0x22, 0xFB, 0x68, 0x20, 0x5D, 0xFC, 0x10,
  // "f" (U+0066)
  0x18, 0x65, 0xEE, 0x10, 0xDD, 0x72, 0x90, 0x92, 0x0A, 0xA8, 0x4C, 0x06, 0xFB, 0x52, 0x90, 0x93,
  0x90, 0x93, 0x90, 0x93, 0x90, 0x93, 0x90, 0x92,
  // "g" (U+0067)
  0x18, 0xC7, 0x8E, 0xAB, 0xB3, 0xFB, 0x9F, 0xB6, 0xF3, 0x0E, 0xB7, 0xF2, 0x0D, 0xB6, 0xF3, 0x0E,
  0xB3, 0xFB, 0x9F, 0xB0, 0x8E, 0x9D, 0xB4, 0x89, 0x3E, 0x92, 0xA7, 0xAF, 0x51, 0xCF, 0xD7, 0x10,
  // "h" (U+0068)
  0x81, 0x3F, 0x53, 0x81, 0x3F, 0x53, 0x81, 0x3F, 0x53, 0x8D, 0x03, 0xF8, 0xDD, 0x33, 0xFD, 0x7F,
  0xA3, 0xF7, 0x0C, 0xC3, 0xF6, 0x0C, 0xD3, 0xF5, 0x0C, 0xD3, 0xF5, 0x0C, 0xD3, 0xF5, 0x0C, 0xD0,
  // "i" (U+0069)
  0x84, 0x2E, 0x40, 0x51, 0x38, 0xA3, 0x3F, 0x63, 0xF6, 0x3F, 0x63, 0xF6, 0x3F, 0x63, 0xF6, 0x3F,
  0x60,
  // "j" (U+006A)
  0x18, 0x12, 0xE4, 0x20, 0x50, 0x15, 0x8C, 0x43, 0xF6, 0x03, 0xF6, 0x03, 0xF6, 0x03, 0xF6, 0x03,
  0xF6, 0x03, 0xF6, 0x03, 0xF6, 0x04, 0xF5, 0x3B, 0xF4, 0x6E, 0xA1,
  // "k" (U+006B)
  0x81, 0x3F, 0x53, 0x81, 0x3F, 0x53, 0x81, 0x3F, 0x53, 0x8A, 0x13, 0xF5, 0x1E, 0xC3, 0xF5, 0x9E,
  0x23, 0xF9, 0xF6, 0x03, 0xB8, 0xA2, 0x60, 0x3F, 0xAC, 0xD0, 0x3F, 0x54, 0xF7, 0x3F, 0x50, 0xCE,
  // "l" (U+006C)
  0x8B, 0x43, 0xF5, 0x3F, 0x53, 0xF5, 0x3F, 0x53, 0xF5, 0x3F, 0x53, 0xF5, 0x3F, 0x53, 0xF5, 0x3F,
  0x50,
  // "m" (U+006D)
  0x89, 0x43, 0xF6, 0xDD, 0x3B, 0xE6, 0x03, 0xFD, 0x8A, 0x8E, 0x48, 0xDE, 0x03, 0xF7, 0x0E, 0xC0,
  0x8F, 0x13, 0xF6, 0x0D, 0xB0, 0x8F, 0x13, 0xF5, 0x0D, 0xB0, 0x8F, 0x13, 0xF5, 0x0D, 0xB0, 0x8F,
  0x13, 0xF5, 0x0D, 0xB0, 0x8F, 0x10,
  // "n" (U+006E)
  0x8D, 0x03, 0xF6, 0xDD, 0x33, 0xFD, 0x7F, 0xA3, 0xF7, 0x0C, 0xC3, 0xF6, 0x0C, 0xD3, 0xF5, 0x0C,
  0xD3, 0xF5, 0x0C, 0xD3, 0xF5, 0x0C, 0xD0,
  // "o" (U+006F)
  0x18, 0xC6, 0x5D, 0xE8, 0x02, 0xFB, 0x9F, 0x66, 0xF3, 0x0D, 0xB7, 0xF2, 0x0C, 0xD6, 0xF3, 0x0E,
  0xB1, 0xFB, 0x9F, 0x70, 0x5D, 0xE9, 0x10,
  // "p" (U+0070)
  0x8D, 0x33, 0xF6, 0xDC, 0x23, 0xFD, 0x8F, 0xA3, 0xF7, 0x0B, 0xE3, 0xF5, 0x0A, 0xF3, 0xF7, 0x0B,
  0xE3, 0xFD, 0x7F, 0xA3, 0xF9, 0xDC, 0x23, 0xF5, 0x38, 0x13, 0xF5, 0x38, 0x13, 0xF5, 0x30,
  // "q" (U+0071)
  0x18, 0xC7, 0x8E, 0xAB, 0xB2, 0xFB, 0x9F, 0xB6, 0xF3, 0x0E, 0xB7, 0xF2, 0x0D, 0xB6, 0xF3, 0x0E,
  0xB3, 0xFB, 0x9F, 0xB0, 0x8E, 0x9D, 0xB4, 0x0D, 0x0B, 0x40, 0xD0, 0xB4, 0x0D, 0x0B,
  // "r" (U+0072)
  0x89, 0x33, 0xF5, 0xE5, 0x3F, 0xE7, 0x23, 0xF8, 0x28, 0x13, 0xF6, 0x28, 0x13, 0xF6, 0x28, 0x13,
  0xF6, 0x28, 0x13, 0xF6, 0x20,
  // "s" (U+0073)
  0x89, 0x31, 0xBE, 0xC3, 0x8F, 0x7A, 0x27, 0xF7, 0x28, 0x31, 0xBF, 0xC1, 0x28, 0x93, 0x6F, 0x77,
  0x88, 0xF7, 0x6E, 0xEB, 0x10,
  // "t" (U+0074)
  0x10, 0x50, 0x42, 0x82, 0xD8, 0x09, 0xA8, 0x96, 0xD6, 0xFB, 0x51, 0xF8, 0x01, 0xF8, 0x01, 0xF8,
  0x29, 0x84, 0xC7, 0x08, 0xEC,
  // "u" (U+0075)
  0x8D, 0x04, 0xF5, 0x0C, 0xC4, 0xF5, 0x0C, 0xC4, 0xF5, 0x0C, 0xC4, 0xF5, 0x0C, 0xC3, 0xF6, 0x0D,
  0xC1, 0xFB, 0x7F, 0xC0, 0x8E, 0xB9, 0xC0,
  // "v" (U+0076)
  0x89, 0x6C, 0xC0, 0x1F, 0x98, 0xF1, 0x4F, 0x44, 0xF4, 0x89, 0x28, 0x2E, 0x8C, 0xB2, 0x82, 0xAB,
  0xF7, 0x20, 0x6A, 0x02, 0x28, 0x11, 0xFD, 0x20,
  // "w" (U+0077)
  0x8C, 0x1C, 0xC0, 0x9F, 0x60, 0xE9, 0x9F, 0x0C, 0xE9, 0x2F, 0x65, 0xF3, 0xFA, 0xC5, 0xF2, 0x2F,
  0x8F, 0x5F, 0x8E, 0x28, 0x5E, 0xCD, 0x1F, 0xCB, 0x28, 0x5B, 0xFB, 0x0E, 0xF8, 0x28, 0x57, 0xF8,
  0x0B, 0xF4, 0x10,
  // "x" (U+0078)
  0x89, 0x19, 0xF2, 0x6F, 0x52, 0xF9, 0xDD, 0x20, 0x9A, 0x05, 0x20, 0x4A, 0x30, 0xAA, 0x89, 0x46,
  0x02, 0xF7, 0xCD, 0x0A, 0xF1, 0x5F, 0x60,
  // "y" (U+0079)
  0x89, 0x6C, 0xD0, 0x1F, 0x98, 0xF2, 0x4F, 0x43, 0xF6, 0x89, 0x28, 0x2E, 0x9C, 0xB2, 0x82, 0x9D,
  0xF7, 0x20, 0x4A, 0x02, 0x39, 0x0D, 0x38, 0x11, 0xF9, 0x28, 0x24, 0xBF, 0x32, 0x81, 0x8E, 0x73,
  // "z" (U+007A)
  0x09, 0xB8, 0x46, 0x36, 0xBF, 0x32, 0x0E, 0x0B, 0x28, 0x17, 0xF3, 0x20, 0xE0, 0xB2, 0x84, 0x7F,
  0x96, 0x3B, 0xB0, 0x80,
  // "{" (U+007B)
  0x18, 0x61, 0xBE, 0x10, 0x5F, 0x92, 0x81, 0x6F, 0x12, 0x84, 0x6F, 0x10, 0x2B, 0x92, 0x81, 0xBF,
  0x62, 0x81, 0x4C, 0xE3, 0x07, 0x93, 0x81, 0x6F, 0x12, 0x81, 0x6F, 0x52, 0x82, 0x2E, 0xF1, 0x20,
  0x10, 0x41,
  // "|" (U+007C)
  0x8B, 0x0E, 0x6E, 0x6E, 0x6E, 0x6E, 0x6E, 0x6E, 0x6E, 0x6E, 0x6E, 0x6E, 0x6E, 0x6E, 0x60,
  // "}" (U+007D)
  0x81, 0x9D, 0x52, 0x81, 0x4D, 0xD3, 0x09, 0x0E, 0x30, 0x90, 0xE3, 0x81, 0x7F, 0x42, 0x89, 0x21,
  0xDF, 0x30, 0x6F, 0x71, 0x08, 0xE3, 0x09, 0x0E, 0x28, 0x11, 0xBD, 0x28, 0x19, 0xF9, 0x20, 0x02,
  0x30,
  // "~" (U+007E)
  0x87, 0x5F, 0xE6, 0x37, 0x85, 0x9A, 0x07, 0x30, 0x10, 0x31,
  // "¡" (U+00A1)
  0x84, 0x2E, 0x53, 0xF6, 0x38, 0xA0, 0x1F, 0x42, 0xF4, 0x3F, 0x53, 0xF6, 0x4F, 0x75, 0xF7,
  // "¢" (U+00A2)
  0x20, 0x20, 0xC3, 0x89, 0x44, 0xEF, 0xE1, 0x0E, 0xD5, 0x60, 0x2F, 0x83, 0x81, 0x3F, 0x73, 0x83,
  0x1F, 0xA0, 0x12, 0x81, 0xCF, 0xD9, 0x28, 0x21, 0x9E, 0x73, 0x01, 0x0C, 0x20,
  // "£" (U+00A3)
  0x28, 0x92, 0xAE, 0xD3, 0x06, 0xF9, 0x91, 0x09, 0x93, 0x85, 0x1A, 0xF2, 0x10, 0x7B, 0x85, 0xB0,
  0x2B, 0xF4, 0x32, 0x0A, 0x0E, 0x38, 0x53, 0xFB, 0x66, 0x47, 0xC0, 0x90,
  // "¤" (U+00A4)
  0x10, 0x23, 0x8B, 0x02, 0x3E, 0xBE, 0xBD, 0x0C, 0xC7, 0xE7, 0x0F, 0x20, 0x79, 0x0C, 0x72, 0xC7,
  0x2C, 0x85, 0xB0, 0x51, 0x31, 0x50,
  // "¥" (U+00A5)
  0x89, 0x7A, 0xF0, 0x1F, 0xA5, 0xF5, 0x5F, 0x50, 0xEA, 0xBE, 0x20, 0xAA, 0x09, 0x20, 0x4A, 0x82,
  0x30, 0x3E, 0xA8, 0x1E, 0x33, 0xC8, 0x53, 0x14, 0xDD, 0x41, 0x20, 0x0C, 0x20,
  // "¦" (U+00A6)
  0x89, 0x0E, 0x6E, 0x6E, 0x6E, 0x6E, 0x66, 0x89, 0x0E, 0x6E, 0x6E, 0x6E, 0x6E, 0x60,
  // "§" (U+00A7)
  0x18, 0x92, 0x9E, 0xD4, 0x4F, 0x8A, 0x43, 0xF6, 0x38, 0x96, 0xDF, 0xB1, 0x5D, 0x2D, 0x95, 0xF6,
  0xB8, 0x07, 0xA0, 0x22, 0x89, 0x32, 0xE7, 0x69, 0x7E, 0x73, 0xDE, 0xB1,
  // "¨" (U+00A8)
  0x86, 0xAA, 0x6D, 0x11, 0x02,
  // "©" (U+00A9)
  0x40, 0x01, 0x60, 0x50, 0xDA, 0x0C, 0x04, 0x38, 0x65, 0xF9, 0x56, 0x9F, 0x52, 0x81, 0xD3, 0x7A,
  0x8A, 0x08, 0x4E, 0x05, 0x92, 0xF7, 0x54, 0x0A, 0x46, 0x64, 0xD4, 0x89, 0x68, 0x55, 0x83, 0xF5,
  0x22, 0x09, 0x41, 0xE1, 0xAA, 0x89, 0x38, 0x2E, 0x10, 0x9D, 0x65, 0x67, 0xE7, 0x30, 0x8B, 0x0E,
  0x07, 0x58, 0x11, 0x43, 0x40,
  // "ª" (U+00AA)
  0x89, 0x63, 0xDE, 0x41, 0x6B, 0x9A, 0x9A, 0x96, 0xD9, 0x90,
  // "«" (U+00AB)
  0x18, 0xB3, 0x1C, 0x25, 0xB0, 0xCD, 0x2E, 0x97, 0xF4, 0xBE, 0x12, 0xE9, 0x5F, 0x50, 0x5F, 0x39,
  0xE2, 0x03, 0x20, 0x20,
  // "¬" (U+00AC)
  0x80, 0x21, 0x08, 0xC8, 0x58, 0x24, 0x44, 0xC8, 0x40, 0xB0, 0x84, 0x09, 0x06,
  // "®" (U+00AE)
  0x40, 0x01, 0x60, 0x50, 0xDA, 0x0C, 0x04, 0x38, 0x65, 0xFA, 0x76, 0x9F, 0x52, 0x81, 0xD3, 0xCA,
  0x8A, 0x06, 0x4E, 0x05, 0x90, 0xC9, 0xBB, 0x0A, 0x46, 0x60, 0xCA, 0x8B, 0x75, 0x08, 0x55, 0x80,
  0xC8, 0xE4, 0x09, 0x41, 0xE1, 0xB5, 0x5C, 0x2E, 0x10, 0x9D, 0x62, 0x26, 0xE7, 0x30, 0x8B, 0x0E,
  0x07, 0x58, 0x11, 0x43, 0x40,
  // "¯" (U+00AF)
  0x80, 0x21, 0xD0, 0xC8, 0x01, 0x40, 0x30,
  // "°" (U+00B0)
  0x20, 0x12, 0x8A, 0x11, 0xDF, 0x80, 0x7B, 0x6F, 0x18, 0xA3, 0xF1, 0x2E, 0xFA, 0x20, 0x10, 0x32,
  // "±" (U+00B1)
  0x20, 0x90, 0xA2, 0x85, 0x11, 0xAA, 0x11, 0x8C, 0x85, 0x92, 0x4B, 0xB4, 0x22, 0x09, 0x0A, 0x40,
  0x90, 0xA2, 0x85, 0x36, 0x66, 0x63, 0x8C, 0x09,
  // "²" (U+00B2)
  0x8A, 0x24, 0xCD, 0x33, 0x3C, 0x80, 0x2E, 0x32, 0xD5, 0x0A, 0xFE, 0xA8, 0x00, 0x10,
  // "³" (U+00B3)
  0x89, 0x74, 0xDC, 0x32, 0x3B, 0x70, 0xCE, 0x21, 0x1A, 0x98, 0xA8, 0x15, 0x01, 0x20,
  // "´" (U+00B4)
  0x28, 0x41, 0x1D, 0xA2, 0x31,
  // "µ" (U+00B5)
  0x8D, 0x33, 0xF5, 0x0C, 0xC3, 0xF5, 0x0C, 0xC3, 0xF5, 0x0C, 0xC3, 0xF5, 0x0C, 0xC3, 0xF6, 0x0E,
  0xC3, 0xFC, 0x9F, 0xC3, 0xFD, 0xD9, 0xC3, 0xF5, 0x38, 0x13, 0xF5, 0x38, 0x13, 0xF5, 0x30,
  // "¶" (U+00B6)
  0x10, 0x80, 0xEA, 0x0B, 0x02, 0xB8, 0x18, 0xB5, 0xB8, 0x13, 0xB6, 0xB8, 0x13, 0xB5, 0xB8, 0x13,
  0xB1, 0xB8, 0x63, 0xB0, 0x38, 0xE3, 0xB3, 0x81, 0xD3, 0xB3, 0x81, 0xD3, 0xB3, 0x81, 0xD3, 0xB3,
  0x81, 0xD3, 0xB3, 0x81, 0x51, 0x40,
  // "·" (U+00B7)
  0x84, 0x2F, 0x52, 0xE5,
  // "¸" (U+00B8)
  0x18, 0x90, 0x99, 0x01, 0x8F, 0x32, 0xEB, 0x10,
  // "¹" (U+00B9)
  0x18, 0xA1, 0x7F, 0x14, 0xBF, 0x10, 0x1F, 0x10, 0x1F, 0x10, 0x1F, 0x10,
  // "º" (U+00BA)
  0x89, 0x62, 0xDD, 0x49, 0x85, 0xC9, 0x85, 0xB2, 0xCC, 0x40,
  // "»" (U+00BB)
  0x83, 0x4C, 0x07, 0x92, 0x84, 0x1E, 0xA4, 0xF6, 0x28, 0xA1, 0x6F, 0x5B, 0xE1, 0x0B, 0xD2, 0xEA,
  0x05, 0xF3, 0x9D, 0x12, 0x03, 0x20, 0x22,
  // "¼" (U+00BC)
  0x10, 0x99, 0x30, 0xB0, 0x82, 0x06, 0x0B, 0x92, 0x81, 0x3E, 0x13, 0x03, 0x92, 0x0B, 0x08, 0x48,
  0x63, 0xF0, 0x3F, 0x16, 0x92, 0x86, 0x3F, 0x0A, 0x91, 0xED, 0x48, 0x42, 0xF1, 0x99, 0xD4, 0x85,
  0xA9, 0x2D, 0x8E, 0x22, 0x82, 0x2F, 0x25, 0xB0, 0x82, 0x09, 0x0A, 0x28, 0x11, 0x6D, 0x30, 0x15,
  0x01, 0x10,
  // "½" (U+00BD)
  0x10, 0x99, 0x30, 0xD0, 0x62, 0x06, 0x0A, 0x92, 0x07, 0x0D, 0x40, 0x39, 0x20, 0xE0, 0x54, 0x8A,
  0x13, 0xF0, 0x7C, 0x7D, 0xC1, 0x03, 0xF1, 0xE4, 0x53, 0xF4, 0x30, 0x80, 0xB2, 0x06, 0x0C, 0x38,
  0x51, 0xF3, 0x06, 0xD3, 0x30, 0x90, 0xA2, 0x0D, 0xA0, 0x72, 0x04, 0x01, 0x20, 0xF4, 0x02,
  // "¾" (U+00BE)
  0x70, 0x12, 0x82, 0x4E, 0xF5, 0x20, 0xA0, 0x92, 0x86, 0x27, 0xC8, 0x02, 0xF2, 0x38, 0x4C, 0xE2,
  0x0A, 0xA3, 0x89, 0x12, 0x6B, 0xA2, 0xF2, 0x37, 0x08, 0xA8, 0x37, 0x9A, 0x0C, 0x92, 0x85, 0x32,
  0x1F, 0x37, 0x99, 0x48, 0x58, 0xB1, 0xD7, 0xF3, 0x28, 0x21, 0xE4, 0x3B, 0x09, 0x20, 0x70, 0xC2,
  0x01, 0x04, 0x97, 0x20, 0x11,
  // "¿" (U+00BF)
  0x20, 0xC0, 0xA3, 0x0D, 0x0B, 0x71, 0x0B, 0x09, 0x28, 0x55, 0xF6, 0x03, 0xFA, 0x28, 0x18, 0xF1,
  0x28, 0x90, 0x7F, 0x88, 0x81, 0xBE, 0xD7,
  // "À" (U+00C0)
  0x18, 0x13, 0xF9, 0x58, 0x14, 0xE3, 0x74, 0x81, 0xCF, 0xA4, 0x90, 0x0E, 0x38, 0x34, 0xF9, 0xF2,
  0x28, 0x38, 0xF3, 0xF6, 0x28, 0x94, 0xCC, 0x0E, 0xB0, 0x1F, 0xD8, 0xDE, 0x05, 0xD8, 0x90, 0x39,
  0xF2, 0x04, 0xF7, 0xDE, 0x39, 0x0B,
  // "Á" (U+00C1)
  0x40, 0x14, 0x81, 0x1D, 0xA4, 0x02, 0x03, 0x58, 0x1C, 0xFA, 0x49, 0x00, 0xE3, 0x83, 0x4F, 0x9F,
  0x22, 0x83, 0x8F, 0x3F, 0x62, 0x89, 0x4C, 0xC0, 0xEB, 0x01, 0xFD, 0x8D, 0xE0, 0x5D, 0x89, 0x03,
  0x9F, 0x20, 0x4F, 0x7D, 0xE3, 0x90, 0xB0,
  // "Â" (U+00C2)
  0x28, 0x18, 0xFA, 0x38, 0x34, 0xD3, 0xD5, 0x73, 0x81, 0xCF, 0xA4, 0x90, 0x0E, 0x38, 0x34, 0xF9,
  0xF2, 0x28, 0x38, 0xF3, 0xF6, 0x28, 0x94, 0xCC, 0x0E, 0xB0, 0x1F, 0xD8, 0xDE, 0x05, 0xD8, 0x90,
  0x39, 0xF2, 0x04, 0xF7, 0xDE, 0x39, 0x0B,
  // "Ã" (U+00C3)
  0x50, 0x12, 0x83, 0x2F, 0xA7, 0x92, 0x83, 0x6A, 0xBF, 0x42, 0x82, 0x11, 0x02, 0x48, 0x1C, 0xFA,
  0x49, 0x00, 0xE3, 0x83, 0x4F, 0x9F, 0x22, 0x83, 0x8F, 0x3F, 0x62, 0x89, 0x4C, 0xC0, 0xEB, 0x01,
  0xFD, 0x8D, 0xE0, 0x5D, 0x89, 0x03, 0x9F, 0x20, 0x4F, 0x7D, 0xE3, 0x90, 0xB0,
  // "Ä" (U+00C4)
  0x18, 0x2A, 0xA6, 0xD3, 0x82, 0x11, 0x02, 0x48, 0x1C, 0xFA, 0x49, 0x00, 0xE3, 0x83, 0x4F, 0x9F,
  0x22, 0x83, 0x8F, 0x3F, 0x62, 0x89, 0x4C, 0xC0, 0xEB, 0x01, 0xFD, 0x8D, 0xE0, 0x5D, 0x89, 0x03,
  0x9F, 0x20, 0x4F, 0x7D, 0xE3, 0x90, 0xB0,
  // "Å" (U+00C5)
  0x28, 0x23, 0xED, 0x13, 0x82, 0x7B, 0xC4, 0x38, 0x24, 0xFE, 0x13, 0x81, 0xCF, 0xB4, 0x90, 0x0E,
  0x38, 0x34, 0xF9, 0xF2, 0x28, 0x38, 0xF3, 0xF6, 0x28, 0x94, 0xCC, 0x0E, 0xB0, 0x1F, 0xD8, 0xDE,
  0x05, 0xD8, 0x90, 0x39, 0xF2, 0x04, 0xF7, 0xDE, 0x39, 0x0B,
  // "Æ" (U+00C6)
  0x20, 0x3D, 0x0A, 0x28, 0x58, 0xFB, 0xF7, 0x64, 0x28, 0x3D, 0xA8, 0xF2, 0x38, 0xA1, 0x3F, 0x58,
  0xF3, 0x11, 0x08, 0xF2, 0x9F, 0xDD, 0x60, 0xDC, 0x02, 0x28, 0x53, 0xF8, 0x4A, 0xF2, 0x28, 0x91,
  0x8F, 0x20, 0x8F, 0x76, 0x4D, 0xE2, 0x08, 0xB0, 0xA0,
  // "Ç" (U+00C7)
  0x28, 0x93, 0x9E, 0xE9, 0x0A, 0xF9, 0x89, 0x1F, 0xA3, 0x81, 0x5F, 0x63, 0x81, 0x6F, 0x53, 0x81,
  0x4F, 0x63, 0x81, 0x2F, 0xA4, 0x89, 0x1B, 0xF9, 0x78, 0x01, 0xAF, 0xE8, 0x30, 0x09, 0x38, 0x21,
  0x8F, 0x32, 0x81, 0x2E, 0xB1,
  // "È" (U+00C8)
  0x81, 0x3F, 0x93, 0x81, 0x4E, 0x36, 0x02, 0xC8, 0x62, 0xFB, 0x66, 0x2F, 0x82, 0x84, 0x2F, 0x91,
  0x12, 0xB8, 0x7D, 0x2F, 0xA4, 0x32, 0xF8, 0x28, 0x42, 0xFB, 0x66, 0x2C,
  // "É" (U+00C9)
  0x40, 0x12, 0x81, 0x1D, 0xA2, 0x82, 0x23, 0x02, 0xC8, 0x62, 0xFB, 0x66, 0x2F, 0x82, 0x84, 0x2F,
  0x91, 0x12, 0xB8, 0x7D, 0x2F, 0xA4, 0x32, 0xF8, 0x28, 0x42, 0xFB, 0x66, 0x2C,
  // "Ê" (U+00CA)
  0x18, 0x78, 0xFA, 0x04, 0xD3, 0xD5, 0x50, 0x2C, 0x86, 0x2F, 0xB6, 0x62, 0xF8, 0x28, 0x42, 0xF9,
  0x11, 0x2B, 0x87, 0xD2, 0xFA, 0x43, 0x2F, 0x82, 0x84, 0x2F, 0xB6, 0x62, 0xC0,
  // "Ë" (U+00CB)
  0x18, 0x90, 0xAA, 0x6D, 0x01, 0x10, 0x22, 0xC8, 0x62, 0xFB, 0x66, 0x2F, 0x82, 0x84, 0x2F, 0x91,
  0x12, 0xB8, 0x7D, 0x2F, 0xA4, 0x32, 0xF8, 0x28, 0x42, 0xFB, 0x66, 0x2C,
  // "Ì" (U+00CC)
  0x81, 0x3F, 0x92, 0x81, 0x4E, 0x34, 0x09, 0xA8, 0x6C, 0x1D, 0xE2, 0x0C, 0xE2, 0x0C, 0x0E, 0x20,
  0xC0, 0xE2, 0x0C, 0x0E, 0x28, 0x6C, 0xE0, 0x1D, 0xE1, 0x9A, 0x0C,
  // "Í" (U+00CD)
  0x38, 0x90, 0x10, 0x1D, 0xA0, 0x23, 0x09, 0xA8, 0x6C, 0x1D, 0xE2, 0x0C, 0xE2, 0x0C, 0x0E, 0x20,
  0xC0, 0xE2, 0x0C, 0x0E, 0x28, 0x6C, 0xE0, 0x1D, 0xE1, 0x9A, 0x0C,
  // "Î" (U+00CE)
  0x18, 0x78, 0xFA, 0x04, 0xD3, 0xD5, 0x50, 0x9A, 0x84, 0xC0, 0x1D, 0xE2, 0x20, 0xC0, 0xE3, 0x0C,
  0x0E, 0x30, 0xC0, 0xE3, 0x0C, 0x0E, 0x30, 0xC0, 0xE2, 0x84, 0x1D, 0xE1, 0x09, 0xA0, 0xC1,
  // "Ï" (U+00CF)
  0x87, 0xAA, 0x6D, 0x11, 0x02, 0x9A, 0x86, 0xC1, 0xDE, 0x20, 0xCE, 0x20, 0xC0, 0xE2, 0x0C, 0x0E,
  0x20, 0xC0, 0xE2, 0x86, 0xCE, 0x01, 0xDE, 0x19, 0xA0, 0xC0,
  // "Ð" (U+00D0)
  0x02, 0xB8, 0xA7, 0xB3, 0x02, 0xFB, 0x7E, 0xE1, 0x2F, 0x80, 0x4F, 0x83, 0xF9, 0x10, 0xFB, 0xDA,
  0x8B, 0x09, 0x0F, 0xC5, 0xFA, 0x20, 0xFA, 0x2F, 0x80, 0x5F, 0x72, 0xFB, 0x8E, 0xE1, 0x2A, 0x81,
  0xEB, 0x21,
  // "Ñ" (U+00D1)
  0x60, 0x13, 0x83, 0x2F, 0xA7, 0x93, 0x83, 0x6A, 0xBF, 0x43, 0x82, 0x11, 0x02, 0x20, 0x2A, 0x84,
  0x20, 0x4F, 0x42, 0xA8, 0xD0, 0x80, 0x4F, 0x42, 0xFE, 0xE1, 0x4F, 0x42, 0xF9, 0xF7, 0x4F, 0x42,
  0xF6, 0xBE, 0x4F, 0x42, 0xF6, 0x5F, 0x9F, 0x42, 0xF6, 0x0D, 0xA8, 0x44, 0x2F, 0x60, 0x6A, 0x82,
  0x42, 0xF6, 0x28, 0x1E, 0xF4,
  // "Ò" (U+00D2)
  0x18, 0x13, 0xF9, 0x68, 0x14, 0xE3, 0x75, 0x83, 0x1A, 0xEE, 0x93, 0x89, 0x0B, 0xF8, 0x9F, 0x90,
  0x2F, 0xA2, 0x84, 0xCF, 0x04, 0xF6, 0x28, 0x48, 0xF3, 0x6F, 0x52, 0x84, 0x7F, 0x35, 0xF6, 0x28,
  0x48, 0xF2, 0x2F, 0xA2, 0x0C, 0x92, 0x84, 0xBF, 0x89, 0xF8, 0x28, 0x31, 0xAE, 0xE9, 0x20,
  // "Ó" (U+00D3)
  0x50, 0x15, 0x81, 0x1D, 0xA5, 0x02, 0x03, 0x48, 0x31, 0xAE, 0xE9, 0x38, 0x90, 0xBF, 0x89, 0xF9,
  0x02, 0xFA, 0x28, 0x4C, 0xF0, 0x4F, 0x62, 0x84, 0x8F, 0x36, 0xF5, 0x28, 0x47, 0xF3, 0x5F, 0x62,
  0x84, 0x8F, 0x22, 0xFA, 0x20, 0xC9, 0x28, 0x4B, 0xF8, 0x9F, 0x82, 0x83, 0x1A, 0xEE, 0x92,
  // "Ô" (U+00D4)
  0x28, 0x18, 0xFA, 0x48, 0x34, 0xD3, 0xD5, 0x74, 0x83, 0x1A, 0xEE, 0x93, 0x89, 0x0B, 0xF8, 0x9F,
  0x90, 0x2F, 0xA2, 0x84, 0xCF, 0x04, 0xF6, 0x28, 0x48, 0xF3, 0x6F, 0x52, 0x84, 0x7F, 0x35, 0xF6,
  0x28, 0x48, 0xF2, 0x2F, 0xA2, 0x0C, 0x92, 0x84, 0xBF, 0x89, 0xF8, 0x28, 0x31, 0xAE, 0xE9, 0x20,
  // "Õ" (U+00D5)
  0x50, 0x13, 0x83, 0x2F, 0xA7, 0x93, 0x83, 0x6A, 0xBF, 0x43, 0x82, 0x11, 0x02, 0x48, 0x31, 0xAE,
  0xE9, 0x38, 0x90, 0xBF, 0x89, 0xF9, 0x02, 0xFA, 0x28, 0x4C, 0xF0, 0x4F, 0x62, 0x84, 0x8F, 0x36,
  0xF5, 0x28, 0x47, 0xF3, 0x5F, 0x62, 0x84, 0x8F, 0x22, 0xFA, 0x20, 0xC9, 0x28, 0x4B, 0xF8, 0x9F,
  0x82, 0x83, 0x1A, 0xEE, 0x92,
  // "Ö" (U+00D6)
  0x28, 0x2A, 0xA6, 0xD4, 0x82, 0x11, 0x02, 0x38, 0x31, 0xAE, 0xE9, 0x38, 0x90, 0xBF, 0x89, 0xF9,
  0x02, 0xFA, 0x28, 0x4C, 0xF0, 0x4F, 0x62, 0x84, 0x8F, 0x36, 0xF5, 0x28, 0x47, 0xF3, 0x5F, 0x62,
  0x84, 0x8F, 0x22, 0xFA, 0x20, 0xC9, 0x28, 0x4B, 0xF8, 0x9F, 0x82, 0x83, 0x1A, 0xEE, 0x92,
  // "×" (U+00D7)
  0x10, 0x72, 0x89, 0x07, 0x12, 0xE9, 0x9E, 0x30, 0x3A, 0x03, 0x28, 0x91, 0x9E, 0xE9, 0x03, 0xE3,
  0x3E, 0x34, 0x01, 0x10,
  // "Ø" (U+00D8)
  0x60, 0x12, 0x84, 0x1A, 0xEE, 0xB9, 0x28, 0x92, 0xBF, 0x89, 0xF9, 0x02, 0xF9, 0x07, 0xA1, 0x8A,
  0x74, 0xF5, 0x1D, 0x9F, 0x36, 0xF4, 0x87, 0x7F, 0x34, 0xF7, 0xD0, 0x8F, 0x22, 0xA8, 0x26, 0x0C,
  0xE2, 0x84, 0xBF, 0x89, 0xF8, 0x28, 0x3B, 0xCE, 0xE9, 0x30, 0x46,
  // "Ù" (U+00D9)
  0x18, 0x13, 0xF9, 0x58, 0x14, 0xE3, 0x72, 0x8F, 0x42, 0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F, 0x92,
  0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F, 0x92, 0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F, 0x91, 0xF9, 0x02,
  0xF8, 0x0D, 0xF9, 0xCF, 0x40, 0x2B, 0xED, 0x61,
  // "Ú" (U+00DA)
  0x40, 0x14, 0x81, 0x1D, 0xA4, 0x02, 0x03, 0x38, 0xF4, 0x2F, 0x80, 0x1F, 0x92, 0xF8, 0x01, 0xF9,
  0x2F, 0x80, 0x1F, 0x92, 0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F, 0x92, 0xF8, 0x01, 0xF9, 0x1F, 0x90,
  0x2F, 0x80, 0xDF, 0x9C, 0xF4, 0x02, 0xBE, 0xD6, 0x10,
  // "Û" (U+00DB)
  0x28, 0x18, 0xFA, 0x38, 0x34, 0xD3, 0xD5, 0x71, 0x8F, 0x42, 0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F,
  0x92, 0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F, 0x92, 0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F, 0x91, 0xF9,
  0x02, 0xF8, 0x0D, 0xF9, 0xCF, 0x40, 0x2B, 0xED, 0x61,
  // "Ü" (U+00DC)
  0x28, 0x2A, 0xA6, 0xD3, 0x89, 0x81, 0x11, 0x02, 0x02, 0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F, 0x92,
  0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F, 0x92, 0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F, 0x91, 0xF9, 0x02,
  0xF8, 0x0D, 0xF9, 0xCF, 0x40, 0x2B, 0xED, 0x61,
  // "Ý" (U+00DD)
  0x40, 0x14, 0x81, 0x1D, 0xA4, 0x02, 0x03, 0x30, 0xC0, 0xE2, 0x87, 0xBE, 0x16, 0xF5, 0x1F, 0x92,
  0x83, 0xEB, 0x7F, 0x32, 0x82, 0x9F, 0xEC, 0x30, 0x2A, 0x05, 0x40, 0xC9, 0x50, 0xB0, 0xE5, 0x0B,
  0x0E, 0x50, 0xB0, 0xE3,
  // "Þ" (U+00DE)
  0x81, 0x2F, 0x83, 0x82, 0x2F, 0x91, 0x20, 0x2B, 0x8A, 0x3D, 0x22, 0xFA, 0x6F, 0xB2, 0xF8, 0x0C,
  0xD2, 0xF9, 0x4E, 0xB2, 0xB8, 0x4E, 0x32, 0xFA, 0x42, 0x81, 0x2F, 0x83,
  // "ß" (U+00DF)
  0x18, 0x33, 0xCE, 0xC4, 0x28, 0xA7, 0xED, 0x7E, 0xE0, 0x3F, 0x60, 0xAF, 0x03, 0xF5, 0x3F, 0x80,
  0x3F, 0x5C, 0xD2, 0x8C, 0x13, 0xF5, 0xBF, 0x60, 0x3F, 0x52, 0xDF, 0x43, 0xF5, 0x01, 0xFA, 0x3F,
  0x6A, 0x8F, 0x83, 0xF5, 0xCF, 0xC1,
  // "à" (U+00E0)
  0x18, 0x13, 0xF9, 0x48, 0x14, 0xE3, 0x71, 0x82, 0x9E, 0xE8, 0x28, 0x39, 0x7B, 0xF2, 0x28, 0x41,
  0x6F, 0x52, 0xDB, 0x8A, 0x15, 0x8F, 0x77, 0xF5, 0x8F, 0x8C, 0xF5, 0x2D, 0xE6, 0xE5,
  // "á" (U+00E1)
  0x40, 0x13, 0x81, 0x1D, 0xA3, 0x02, 0x03, 0x38, 0x29, 0xEE, 0x82, 0x83, 0x97, 0xBF, 0x22, 0x84,
  0x16, 0xF5, 0x2D, 0xB8, 0xA1, 0x58, 0xF7, 0x7F, 0x58, 0xF8, 0xCF, 0x52, 0xDE, 0x6E, 0x50,
  // "â" (U+00E2)
  0x28, 0x18, 0xFA, 0x28, 0x34, 0xD3, 0xD5, 0x78, 0x29, 0xEE, 0x82, 0x83, 0x97, 0xBF, 0x22, 0x84,
  0x16, 0xF5, 0x2D, 0xB8, 0xA1, 0x58, 0xF7, 0x7F, 0x58, 0xF8, 0xCF, 0x52, 0xDE, 0x6E, 0x50,
  // "ã" (U+00E3)
  0x58, 0xA0, 0x10, 0x2F, 0xA7, 0x90, 0x6A, 0xBF, 0x40, 0x11, 0x02, 0x28, 0x29, 0xEE, 0x82, 0x83,
  0x97, 0xBF, 0x22, 0x84, 0x16, 0xF5, 0x2D, 0xB8, 0xA1, 0x58, 0xF7, 0x7F, 0x58, 0xF8, 0xCF, 0x52,
  0xDE, 0x6E, 0x50,
  // "ä" (U+00E4)
  0x18, 0x2A, 0xA6, 0xD2, 0x82, 0x11, 0x02, 0x28, 0x29, 0xEE, 0x82, 0x83, 0x97, 0xBF, 0x22, 0x84,
  0x16, 0xF5, 0x2D, 0xB8, 0xA1, 0x58, 0xF7, 0x7F, 0x58, 0xF8, 0xCF, 0x52, 0xDE, 0x6E, 0x50,
  // "å" (U+00E5)
  0x18, 0x23, 0xED, 0x12, 0x82, 0x7B, 0xC4, 0x28, 0x24, 0xFE, 0x13, 0x02, 0x01, 0x38, 0x29, 0xEE,
  0x82, 0x83, 0x97, 0xBF, 0x22, 0x84, 0x16, 0xF5, 0x2D, 0xB8, 0xA1, 0x58, 0xF7, 0x7F, 0x58, 0xF8,
  0xCF, 0x52, 0xDE, 0x6E, 0x50,
  // "æ" (U+00E6)
  0x18, 0x59, 0xED, 0x6C, 0xE9, 0x28, 0x69, 0x7B, 0xFC, 0x8F, 0x52, 0x87, 0x16, 0xF6, 0x1D, 0x92,
  0xDE, 0x8B, 0x2B, 0x8F, 0x78, 0xF8, 0x44, 0x38, 0xF8, 0xCE, 0xC7, 0x84, 0x1C, 0xE8, 0x2C, 0xFD,
  0x30,
  // "ç" (U+00E7)
  0x18, 0x92, 0x5D, 0xE9, 0x1F, 0xC7, 0x66, 0xF3, 0x28, 0x17, 0xF2, 0x28, 0x16, 0xF3, 0x28, 0x90,
  0x2F, 0xC7, 0x80, 0x6D, 0xE8, 0x20, 0x09, 0x28, 0x61, 0x8F, 0x30, 0x2E, 0xB1,
  // "è" (U+00E8)
  0x18, 0x13, 0xF9, 0x48, 0x14, 0xE3, 0x71, 0x8A, 0x05, 0xDE, 0x60, 0x2F, 0xB9, 0xF2, 0x6F, 0x42,
  0xF7, 0x7C, 0x8A, 0x18, 0x6F, 0x64, 0x42, 0x2F, 0xB6, 0x82, 0x05, 0xDF, 0xC1,
  // "é" (U+00E9)
  0x40, 0x13, 0x81, 0x1D, 0xA3, 0x02, 0x03, 0x38, 0xA0, 0x5D, 0xE6, 0x02, 0xFB, 0x9F, 0x26, 0xF4,
  0x2F, 0x77, 0xC8, 0xA1, 0x86, 0xF6, 0x44, 0x22, 0xFB, 0x68, 0x20, 0x5D, 0xFC, 0x10,
  // "ê" (U+00EA)
  0x18, 0x18, 0xFA, 0x28, 0x34, 0xD3, 0xD5, 0x71, 0x8A, 0x05, 0xDE, 0x60, 0x2F, 0xB9, 0xF2, 0x6F,
  0x42, 0xF7, 0x7C, 0x8A, 0x18, 0x6F, 0x64, 0x42, 0x2F, 0xB6, 0x82, 0x05, 0xDF, 0xC1,
  // "ë" (U+00EB)
  0x18, 0x2A, 0xA6, 0xD2, 0x82, 0x11, 0x02, 0x28, 0xA0, 0x5D, 0xE6, 0x02, 0xFB, 0x9F, 0x26, 0xF4,
  0x2F, 0x77, 0xC8, 0xA1, 0x86, 0xF6, 0x44, 0x22, 0xFB, 0x68, 0x20, 0x5D, 0xFC, 0x10,
  // "ì" (U+00EC)
  0x81, 0x3F, 0x92, 0x81, 0x4E, 0x35, 0x8B, 0x13, 0xF6, 0x03, 0xF6, 0x03, 0xF6, 0x03, 0xF6, 0x03,
  0xF6, 0x03, 0xF6, 0x03, 0xF6,
  // "í" (U+00ED)
  0x28, 0xB2, 0x11, 0xDA, 0x23, 0x03, 0xF6, 0x3F, 0x63, 0xF6, 0x3F, 0x63, 0xF6, 0x3F, 0x63, 0xF6,
  // "î" (U+00EE)
  0x18, 0x78, 0xFA, 0x04, 0xD3, 0xD5, 0x68, 0x13, 0xF6, 0x28, 0x13, 0xF6, 0x28, 0x13, 0xF6, 0x28,
  0x13, 0xF6, 0x28, 0x13, 0xF6, 0x28, 0x13, 0xF6, 0x28, 0x13, 0xF6, 0x10,
  // "ï" (U+00EF)
  0x8C, 0x2A, 0xA6, 0xD1, 0x10, 0x20, 0x3F, 0x60, 0x3F, 0x60, 0x3F, 0x60, 0x3F, 0x60, 0x3F, 0x60,
  0x3F, 0x60, 0x3F, 0x60,
  // "ð" (U+00F0)
  0x28, 0x15, 0x15, 0x28, 0x21, 0xDF, 0xA2, 0x82, 0x2E, 0xEB, 0x38, 0xC5, 0x35, 0xF4, 0x09, 0xFE,
  0xF9, 0x4F, 0xA6, 0xFC, 0x7F, 0x20, 0xDD, 0x7F, 0x30, 0xDB, 0x3F, 0xB8, 0xF6, 0x06, 0xDE, 0x91,
  // "ñ" (U+00F1)
  0x58, 0xF3, 0x10, 0x2F, 0xA7, 0x90, 0x6A, 0xBF, 0x40, 0x11, 0x02, 0x03, 0xF6, 0xDD, 0x33, 0xFD,
  0x7F, 0xA3, 0xF7, 0x0C, 0xC3, 0xF6, 0x0C, 0xD3, 0xF5, 0x0C, 0xD3, 0xF5, 0x0C, 0xD3, 0xF5, 0x0C,
  0xD0,
  // "ò" (U+00F2)
  0x18, 0x13, 0xF9, 0x48, 0x14, 0xE3, 0x71, 0x8C, 0x65, 0xDE, 0x80, 0x2F, 0xB9, 0xF6, 0x6F, 0x30,
  0xDB, 0x7F, 0x20, 0xCD, 0x6F, 0x30, 0xEB, 0x1F, 0xB9, 0xF7, 0x05, 0xDE, 0x91,
  // "ó" (U+00F3)
  0x40, 0x13, 0x81, 0x1D, 0xA3, 0x02, 0x03, 0x38, 0xC6, 0x5D, 0xE8, 0x02, 0xFB, 0x9F, 0x66, 0xF3,
  0x0D, 0xB7, 0xF2, 0x0C, 0xD6, 0xF3, 0x0E, 0xB1, 0xFB, 0x9F, 0x70, 0x5D, 0xE9, 0x10,
  // "ô" (U+00F4)
  0x28, 0x18, 0xFA, 0x28, 0x34, 0xD3, 0xD5, 0x78, 0xC6, 0x5D, 0xE8, 0x02, 0xFB, 0x9F, 0x66, 0xF3,
  0x0D, 0xB7, 0xF2, 0x0C, 0xD6, 0xF3, 0x0E, 0xB1, 0xFB, 0x9F, 0x70, 0x5D, 0xE9, 0x10,
  // "õ" (U+00F5)
  0x58, 0xA0, 0x10, 0x2F, 0xA7, 0x90, 0x6A, 0xBF, 0x40, 0x11, 0x02, 0x28, 0xC6, 0x5D, 0xE8, 0x02,
  0xFB, 0x9F, 0x66, 0xF3, 0x0D, 0xB7, 0xF2, 0x0C, 0xD6, 0xF3, 0x0E, 0xB1, 0xFB, 0x9F, 0x70, 0x5D,
  0xE9, 0x10,
  // "ö" (U+00F6)
  0x18, 0x2A, 0xA6, 0xD2, 0x82, 0x11, 0x02, 0x28, 0xC6, 0x5D, 0xE8, 0x02, 0xFB, 0x9F, 0x66, 0xF3,
  0x0D, 0xB7, 0xF2, 0x0C, 0xD6, 0xF3, 0x0E, 0xB1, 0xFB, 0x9F, 0x70, 0x5D, 0xE9, 0x10,
  // "÷" (U+00F7)
  0x20, 0x0A, 0x28, 0x51, 0x13, 0x31, 0x18, 0xC8, 0x59, 0x24, 0x44, 0x42, 0x71, 0x00, 0xA4, 0x01,
  0x02, 0x20,
  // "ø" (U+00F8)
  0x40, 0x12, 0x8C, 0x65, 0xDE, 0xD5, 0x2F, 0xBA, 0xF5, 0x6F, 0x2B, 0xEB, 0x7F, 0x5A, 0xBD, 0x6F,
  0xD2, 0xDB, 0x1E, 0xD8, 0xF6, 0x0D, 0xDE, 0x92, 0x04, 0x40,
  // "ù" (U+00F9)
  0x18, 0x13, 0xF9, 0x48, 0x14, 0xE3, 0x78, 0xD0, 0x4F, 0x50, 0xCC, 0x4F, 0x50, 0xCC, 0x4F, 0x50,
  0xCC, 0x4F, 0x50, 0xCC, 0x3F, 0x60, 0xDC, 0x1F, 0xB7, 0xFC, 0x08, 0xEB, 0x9C,
  // "ú" (U+00FA)
  0x40, 0x13, 0x81, 0x1D, 0xA3, 0x02, 0x03, 0x28, 0xD0, 0x4F, 0x50, 0xCC, 0x4F, 0x50, 0xCC, 0x4F,
  0x50, 0xCC, 0x4F, 0x50, 0xCC, 0x3F, 0x60, 0xDC, 0x1F, 0xB7, 0xFC, 0x08, 0xEB, 0x9C,
  // "û" (U+00FB)
  0x28, 0x18, 0xFA, 0x28, 0x34, 0xD3, 0xD5, 0x68, 0xD0, 0x4F, 0x50, 0xCC, 0x4F, 0x50, 0xCC, 0x4F,
  0x50, 0xCC, 0x4F, 0x50, 0xCC, 0x3F, 0x60, 0xDC, 0x1F, 0xB7, 0xFC, 0x08, 0xEB, 0x9C,
  // "ü" (U+00FC)
  0x18, 0x2A, 0xA6, 0xD2, 0x8D, 0x51, 0x10, 0x20, 0x4F, 0x50, 0xCC, 0x4F, 0x50, 0xCC, 0x4F, 0x50,
  0xCC, 0x4F, 0x50, 0xCC, 0x3F, 0x60, 0xDC, 0x1F, 0xB7, 0xFC, 0x08, 0xEB, 0x9C,
  // "ý" (U+00FD)
  0x40, 0x13, 0x81, 0x1D, 0xA3, 0x02, 0x03, 0x28, 0x96, 0xCD, 0x01, 0xF9, 0x8F, 0x24, 0xF4, 0x3F,
  0x68, 0x92, 0x82, 0xE9, 0xCB, 0x28, 0x29, 0xDF, 0x72, 0x04, 0xA0, 0x23, 0x90, 0xD3, 0x81, 0x1F,
  0x92, 0x82, 0x4B, 0xF3, 0x28, 0x18, 0xE7, 0x30,
  // "þ" (U+00FE)
  0x81, 0x3F, 0x53, 0x81, 0x3F, 0x53, 0x81, 0x3F, 0x53, 0x8D, 0x33, 0xF9, 0xDC, 0x23, 0xFD, 0x7F,
  0xA3, 0xF7, 0x0B, 0xE3, 0xF5, 0x0A, 0xF3, 0xF7, 0x0B, 0xE3, 0xFD, 0x7F, 0xA3, 0xF9, 0xDD, 0x23,
  0xF6, 0x38, 0x13, 0xF6, 0x38, 0x13, 0xF6, 0x30,
  // "ÿ" (U+00FF)
  0x18, 0x2A, 0xA6, 0xD2, 0x8A, 0x31, 0x10, 0x20, 0xCD, 0x01, 0xF9, 0x8F, 0x24, 0xF4, 0x3F, 0x68,
  0x92, 0x82, 0xE9, 0xCB, 0x28, 0x29, 0xDF, 0x72, 0x04, 0xA0, 0x23, 0x90, 0xD3, 0x81, 0x1F, 0x92,
  0x82, 0x4B, 0xF3, 0x28, 0x18, 0xE7, 0x30,
  // "Ā" (U+0100)
  0x18, 0x00, 0x13, 0x08, 0xB3, 0x02, 0x0F, 0x44, 0x81, 0xCF, 0xA4, 0x90, 0x0E, 0x38, 0x34, 0xF9,
  0xF2, 0x28, 0x38, 0xF3, 0xF6, 0x28, 0x94, 0xCC, 0x0E, 0xB0, 0x1F, 0xD8, 0xDE, 0x05, 0xD8, 0x90,
  0x39, 0xF2, 0x04, 0xF7, 0xDE, 0x39, 0x0B,
  // "ā" (U+0101)
  0x18, 0x00, 0x12, 0x08, 0xB2, 0x02, 0x0F, 0x42, 0x82, 0x9E, 0xE8, 0x28, 0x39, 0x7B, 0xF2, 0x28,
  0x41, 0x6F, 0x52, 0xDB, 0x8A, 0x15, 0x8F, 0x77, 0xF5, 0x8F, 0x8C, 0xF5, 0x2D, 0xE6, 0xE5,
  // "Ă" (U+0102)
  0x18, 0x35, 0x72, 0x92, 0x28, 0x22, 0xEF, 0xC4, 0x01, 0x03, 0x58, 0x1C, 0xFA, 0x49, 0x00, 0xE3,
  0x83, 0x4F, 0x9F, 0x22, 0x83, 0x8F, 0x3F, 0x62, 0x89, 0x4C, 0xC0, 0xEB, 0x01, 0xFD, 0x8D, 0xE0,
  0x5D, 0x89, 0x03, 0x9F, 0x20, 0x4F, 0x7D, 0xE3, 0x90, 0xB0,
  // "ă" (U+0103)
  0x18, 0x90, 0x57, 0x29, 0x20, 0x2E, 0xFC, 0x30, 0x10, 0x33, 0x82, 0x9E, 0xE8, 0x28, 0x39, 0x7B,
  0xF2, 0x28, 0x41, 0x6F, 0x52, 0xDB, 0x8A, 0x15, 0x8F, 0x77, 0xF5, 0x8F, 0x8C, 0xF5, 0x2D, 0xE6,
  0xE5,
  // "Ą" (U+0104)
  0x28, 0x1C, 0xFA, 0x49, 0x00, 0xE3, 0x83, 0x4F, 0x9F, 0x22, 0x83, 0x8F, 0x3F, 0x62, 0x89, 0x4C,
  0xC0, 0xEB, 0x01, 0xFD, 0x8D, 0xE0, 0x5D, 0x89, 0x03, 0x9F, 0x20, 0x4F, 0x7D, 0xE3, 0x90, 0xC4,
  0x81, 0x1D, 0x14, 0x81, 0x7C, 0x14, 0x81, 0x5F, 0xA5, 0x03, 0x02,
  // "ą" (U+0105)
  0x18, 0x29, 0xEE, 0x82, 0x83, 0x97, 0xBF, 0x22, 0x84, 0x16, 0xF5, 0x2D, 0xB8, 0xA1, 0x58, 0xF7,
  0x7F, 0x58, 0xF8, 0xCF, 0x52, 0xDE, 0x6F, 0x53, 0x81, 0x1D, 0x13, 0x81, 0x7C, 0x13, 0x81, 0x5F,
  0xA4, 0x03, 0x02,
  // "Ć" (U+0106)
  0x40, 0x13, 0x81, 0x1D, 0xA3, 0x02, 0x03, 0x48, 0x93, 0x9E, 0xE9, 0x0A, 0xF9, 0x89, 0x1F, 0xA3,
  0x81, 0x5F, 0x63, 0x81, 0x6F, 0x53, 0x81, 0x4F, 0x63, 0x81, 0x2F, 0xA4, 0x89, 0x1B, 0xF9, 0x78,
  0x01, 0xAE, 0xE8,
  // "ć" (U+0107)
  0x40, 0x12, 0x81, 0x1D, 0xA2, 0x02, 0x03, 0x28, 0x92, 0x5D, 0xE9, 0x1F, 0xC7, 0x66, 0xF3, 0x28,
  0x17, 0xF2, 0x28, 0x16, 0xF3, 0x28, 0x90, 0x2F, 0xC7, 0x80, 0x6D, 0xE8,
  // "Ĉ" (U+0108)
  0x28, 0x18, 0xFA, 0x28, 0x34, 0xD3, 0xD5, 0x71, 0x89, 0x39, 0xEE, 0x90, 0xAF, 0x98, 0x91, 0xFA,
  0x38, 0x15, 0xF6, 0x38, 0x16, 0xF5, 0x38, 0x14, 0xF6, 0x38, 0x12, 0xFA, 0x48, 0x91, 0xBF, 0x97,
  0x80, 0x1A, 0xEE, 0x80,
  // "ĉ" (U+0109)
  0x18, 0x78, 0xFA, 0x04, 0xD3, 0xD5, 0x68, 0x92, 0x5D, 0xE9, 0x1F, 0xC7, 0x66, 0xF3, 0x28, 0x17,
  0xF2, 0x28, 0x16, 0xF3, 0x28, 0x90, 0x2F, 0xC7, 0x80, 0x6D, 0xE8,
  // "Ċ" (U+010A)
  0x38, 0x16, 0xF2, 0x40, 0x33, 0x89, 0x39, 0xEE, 0x90, 0xAF, 0x98, 0x91, 0xFA, 0x38, 0x15, 0xF6,
  0x38, 0x16, 0xF5, 0x38, 0x14, 0xF6, 0x38, 0x12, 0xFA, 0x48, 0x91, 0xBF, 0x97, 0x80, 0x1A, 0xEE,
  0x80,
  // "ċ" (U+010B)
  0x28, 0x16, 0xF2, 0x30, 0x32, 0x89, 0x25, 0xDE, 0x91, 0xFC, 0x76, 0x6F, 0x32, 0x81, 0x7F, 0x22,
  0x81, 0x6F, 0x32, 0x89, 0x02, 0xFC, 0x78, 0x06, 0xDE, 0x80,
  // "Č" (U+010C)
  0x18, 0x34, 0xD3, 0xD5, 0x28, 0x18, 0xFA, 0x72, 0x89, 0x39, 0xEE, 0x90, 0xAF, 0x98, 0x91, 0xFA,
  0x38, 0x15, 0xF6, 0x38, 0x16, 0xF5, 0x38, 0x14, 0xF6, 0x38, 0x12, 0xFA, 0x48, 0x91, 0xBF, 0x97,
  0x80, 0x1A, 0xEE, 0x80,
  // "č" (U+010D)
  0x87, 0x4D, 0x3D, 0x50, 0x8F, 0xA7, 0x89, 0x25, 0xDE, 0x91, 0xFC, 0x76, 0x6F, 0x32, 0x81, 0x7F,
  0x22, 0x81, 0x6F, 0x32, 0x89, 0x02, 0xFC, 0x78, 0x06, 0xDE, 0x80,
  // "Ď" (U+010E)
  0x18, 0x34, 0xD3, 0xD5, 0x38, 0x18, 0xFA, 0x72, 0x02, 0xB8, 0xA2, 0xB3, 0x02, 0xFB, 0x7E, 0xE1,
  0x2F, 0x80, 0x4F, 0x82, 0xF8, 0x29, 0x82, 0xB2, 0xF8, 0x29, 0x82, 0xC2, 0xF8, 0x29, 0x89, 0x6A,
  0x2F, 0x80, 0x5F, 0x72, 0xFB, 0x8E, 0xE1, 0x2A, 0x81, 0xEB, 0x21,
  // "ď" (U+010F)
  0x48, 0x2D, 0xCF, 0x54, 0x81, 0xDC, 0x55, 0x0D, 0x0B, 0x38, 0x38, 0xE9, 0xDB, 0x28, 0x43, 0xFB,
  0x9F, 0xB2, 0x84, 0x6F, 0x30, 0xEB, 0x28, 0x47, 0xF1, 0x0D, 0xB2, 0x84, 0x6F, 0x30, 0xEB, 0x28,
  0x43, 0xFB, 0x9F, 0xB3, 0x83, 0x8E, 0x9B, 0xB2,
  // "Đ" (U+0110)
  0x02, 0xB8, 0xA7, 0xB3, 0x02, 0xFB, 0x7E, 0xE1, 0x2F, 0x80, 0x4F, 0x83, 0xF9, 0x10, 0xFB, 0xDA,
  0x8B, 0x09, 0x0F, 0xC5, 0xFA, 0x20, 0xFA, 0x2F, 0x80, 0x5F, 0x72, 0xFB, 0x8E, 0xE1, 0x2A, 0x81,
  0xEB, 0x21,
  // "đ" (U+0111)
  0x38, 0x21, 0xEB, 0x12, 0x03, 0xB0, 0x72, 0x8D, 0x41, 0x4E, 0xC2, 0x08, 0xE9, 0xDB, 0x03, 0xFB,
  0x9F, 0xB0, 0x6F, 0x30, 0xEB, 0x07, 0xF1, 0x0D, 0xB0, 0x6F, 0x30, 0xEB, 0x03, 0xFB, 0x9F, 0xB2,
  0x83, 0x8E, 0x9B, 0xB1,
  // "Ē" (U+0112)
  0x18, 0x00, 0x11, 0x08, 0xB1, 0x83, 0x24, 0x44, 0x2C, 0x86, 0x2F, 0xB6, 0x62, 0xF8, 0x28, 0x42,
  0xF9, 0x11, 0x2B, 0x87, 0xD2, 0xFA, 0x43, 0x2F, 0x82, 0x84, 0x2F, 0xB6, 0x62, 0xC0,
  // "ē" (U+0113)
  0x18, 0x00, 0x12, 0x08, 0xB2, 0x02, 0x0F, 0x42, 0x8A, 0x05, 0xDE, 0x60, 0x2F, 0xB9, 0xF2, 0x6F,
  0x42, 0xF7, 0x7C, 0x8A, 0x18, 0x6F, 0x64, 0x42, 0x2F, 0xB6, 0x82, 0x05, 0xDF, 0xC1,
  // "Ĕ" (U+0114)
  0x18, 0x90, 0x57, 0x29, 0x20, 0x2E, 0xFC, 0x30, 0x10, 0x32, 0x02, 0xC1, 0x87, 0x2F, 0xB6, 0x60,
  0x2F, 0x83, 0x85, 0x2F, 0x91, 0x10, 0x2B, 0x89, 0x1D, 0x02, 0xFA, 0x43, 0x02, 0xF8, 0x38, 0x52,
  0xFB, 0x66, 0x02, 0xC1,
  // "ĕ" (U+0115)
  0x18, 0x90, 0x57, 0x29, 0x20, 0x2E, 0xFC, 0x30, 0x10, 0x33, 0x8A, 0x05, 0xDE, 0x60, 0x2F, 0xB9,
  0xF2, 0x6F, 0x42, 0xF7, 0x7C, 0x8A, 0x18, 0x6F, 0x64, 0x42, 0x2F, 0xB6, 0x82, 0x05, 0xDF, 0xC1,
  // "Ė" (U+0116)
  0x28, 0x16, 0xF2, 0x38, 0x13, 0x02, 0xC8, 0x62, 0xFB, 0x66, 0x2F, 0x82, 0x84, 0x2F, 0x91, 0x12,
  0xB8, 0x7D, 0x2F, 0xA4, 0x32, 0xF8, 0x28, 0x42, 0xFB, 0x66, 0x2C,
  // "ė" (U+0117)
  0x28, 0x16, 0xF2, 0x40, 0x33, 0x8A, 0x05, 0xDE, 0x60, 0x2F, 0xB9, 0xF2, 0x6F, 0x42, 0xF7, 0x7C,
  0x8A, 0x18, 0x6F, 0x64, 0x42, 0x2F, 0xB6, 0x82, 0x05, 0xDF, 0xC1,
  // "Ę" (U+0118)
  0x02, 0xC8, 0x62, 0xFB, 0x66, 0x2F, 0x82, 0x84, 0x2F, 0x91, 0x12, 0xB8, 0x7D, 0x2F, 0xA4, 0x32,
  0xF8, 0x28, 0x42, 0xFB, 0x66, 0x2C, 0x28, 0x11, 0xD1, 0x28, 0x17, 0xC1, 0x28, 0x15, 0xFA, 0x30,
  0x30, 0x20,
  // "ę" (U+0119)
  0x18, 0xA0, 0x5D, 0xE6, 0x02, 0xFB, 0x9F, 0x26, 0xF4, 0x2F, 0x77, 0xC8, 0xA1, 0x86, 0xF6, 0x44,
  0x22, 0xFB, 0x68, 0x20, 0x5D, 0xFE, 0x23, 0x09, 0x06, 0x49, 0x09, 0x01, 0x38, 0x1A, 0xF2,
  // "Ě" (U+011A)
  0x87, 0x4D, 0x3D, 0x50, 0x8F, 0xA6, 0x02, 0xC8, 0x62, 0xFB, 0x66, 0x2F, 0x82, 0x84, 0x2F, 0x91,
  0x12, 0xB8, 0x7D, 0x2F, 0xA4, 0x32, 0xF8, 0x28, 0x42, 0xFB, 0x66, 0x2C,
  // "ě" (U+011B)
  0x83, 0x4D, 0x3D, 0x52, 0x81, 0x8F, 0xA7, 0x28, 0xA0, 0x5D, 0xE6, 0x02, 0xFB, 0x9F, 0x26, 0xF4,
  0x2F, 0x77, 0xC8, 0xA1, 0x86, 0xF6, 0x44, 0x22, 0xFB, 0x68, 0x20, 0x5D, 0xFC, 0x10,
  // "Ĝ" (U+011C)
  0x38, 0x18, 0xFA, 0x38, 0x34, 0xD3, 0xD5, 0x72, 0x89, 0x57, 0xDF, 0xC4, 0x09, 0xFB, 0x7A, 0x31,
  0xFB, 0x48, 0x91, 0x5F, 0x60, 0x11, 0x16, 0xF5, 0x2A, 0x89, 0x1A, 0x4F, 0x60, 0x4F, 0xA1, 0xFA,
  0x28, 0x96, 0xEA, 0x0A, 0xF9, 0x7F, 0xA0, 0x1A, 0xEE, 0xD6,
  // "ĝ" (U+011D)
  0x28, 0x18, 0xFA, 0x28, 0x34, 0xD3, 0xD5, 0x78, 0xC7, 0x8E, 0xAB, 0xB3, 0xFB, 0x9F, 0xB6, 0xF3,
  0x0E, 0xB7, 0xF2, 0x0D, 0xB6, 0xF3, 0x0E, 0xB3, 0xFB, 0x9F, 0xB0, 0x8E, 0x9D, 0xB4, 0x89, 0x3E,
  0x92, 0xA7, 0xAF, 0x51, 0xCF, 0xD7, 0x10,
  // "Ğ" (U+011E)
  0x28, 0x35, 0x72, 0x92, 0x28, 0x22, 0xEF, 0xC4, 0x01, 0x03, 0x48, 0x95, 0x7D, 0xFC, 0x40, 0x9F,
  0xB7, 0xA3, 0x1F, 0xB4, 0x89, 0x15, 0xF6, 0x01, 0x11, 0x6F, 0x52, 0xA8, 0x91, 0xA4, 0xF6, 0x04,
  0xFA, 0x1F, 0xA2, 0x89, 0x6E, 0xA0, 0xAF, 0x97, 0xFA, 0x01, 0xAE, 0xED, 0x60,
  // "ğ" (U+011F)
  0x18, 0x90, 0x57, 0x29, 0x20, 0x2E, 0xFC, 0x30, 0x10, 0x33, 0x8C, 0x78, 0xEA, 0xBB, 0x3F, 0xB9,
  0xFB, 0x6F, 0x30, 0xEB, 0x7F, 0x20, 0xDB, 0x6F, 0x30, 0xEB, 0x3F, 0xB9, 0xFB, 0x08, 0xE9, 0xDB,
  0x48, 0x93, 0xE9, 0x2A, 0x7A, 0xF5, 0x1C, 0xFD, 0x71,
  // "Ġ" (U+0120)
  0x38, 0x16, 0xF2, 0x50, 0x34, 0x89, 0x57, 0xDF, 0xC4, 0x09, 0xFB, 0x7A, 0x31, 0xFB, 0x48, 0x91,
  0x5F, 0x60, 0x11, 0x16, 0xF5, 0x2A, 0x89, 0x1A, 0x4F, 0x60, 0x4F, 0xA1, 0xFA, 0x28, 0x96, 0xEA,
  0x0A, 0xF9, 0x7F, 0xA0, 0x1A, 0xEE, 0xD6,
  // "ġ" (U+0121)
  0x28, 0x16, 0xF2, 0x40, 0x33, 0x8C, 0x78, 0xEA, 0xBB, 0x3F, 0xB9, 0xFB, 0x6F, 0x30, 0xEB, 0x7F,
  0x20, 0xDB, 0x6F, 0x30, 0xEB, 0x3F, 0xB9, 0xFB, 0x08, 0xE9, 0xDB, 0x48, 0x93, 0xE9, 0x2A, 0x7A,
  0xF5, 0x1C, 0xFD, 0x71,
  // "Ģ" (U+0122)
  0x28, 0x95, 0x7D, 0xFC, 0x40, 0x9F, 0xB7, 0xA3, 0x1F, 0xB4, 0x89, 0x15, 0xF6, 0x01, 0x11, 0x6F,
  0x52, 0xA8, 0x91, 0xA4, 0xF6, 0x04, 0xFA, 0x1F, 0xA2, 0x89, 0x6E, 0xA0, 0xAF, 0x97, 0xFA, 0x01,
  0xAE, 0xED, 0x67, 0x30, 0x60, 0x34, 0x81, 0x3E, 0x12,
  // "ģ" (U+0123)
  0x30, 0xD0, 0x53, 0x81, 0x26, 0x17, 0x18, 0xC7, 0x8E, 0xAB, 0xB3, 0xFB, 0x9F, 0xB6, 0xF3, 0x0E,
  0xB7, 0xF2, 0x0D, 0xB6, 0xF3, 0x0E, 0xB3, 0xFB, 0x9F, 0xB0, 0x8E, 0x9D, 0xB4, 0x89, 0x3E, 0x92,
  0xA7, 0xAF, 0x51, 0xCF, 0xD7, 0x10,
  // "Ĥ" (U+0124)
  0x28, 0x18, 0xFA, 0x38, 0x34, 0xD3, 0xD5, 0x71, 0x81, 0x2F, 0x82, 0x83, 0xEB, 0x2F, 0x82, 0x83,
  0xEB, 0x2F, 0x82, 0x89, 0x0E, 0xB2, 0xF9, 0x11, 0xEB, 0x2D, 0x89, 0x1B, 0x2F, 0xA4, 0x4E, 0xB2,
  0xF8, 0x28, 0x3E, 0xB2, 0xF8, 0x28, 0x3E, 0xB2, 0xF8, 0x20, 0xE0, 0xB0,
  // "ĥ" (U+0125)
  0x18, 0x18, 0xFA, 0x38, 0x34, 0xD3, 0xD5, 0x73, 0x81, 0x3F, 0x54, 0x81, 0x3F, 0x54, 0x81, 0x3F,
  0x54, 0x8D, 0x63, 0xF8, 0xDD, 0x30, 0x3F, 0xD7, 0xFA, 0x03, 0xF7, 0x0C, 0xC0, 0x3F, 0x60, 0xCD,
  0x03, 0xF5, 0x0C, 0xD0, 0x3F, 0x50, 0xCD, 0x03, 0xF5, 0x0C, 0xD0,
  // "Ħ" (U+0126)
  0x86, 0x3F, 0x91, 0x1E, 0xC1, 0xF8, 0xA0, 0xA6, 0xFA, 0x44, 0xEC, 0x32, 0xF9, 0x11, 0xEB, 0x02,
  0xD8, 0x93, 0xB0, 0x2F, 0xA4, 0x4E, 0xB0, 0x2F, 0x82, 0x84, 0xEB, 0x02, 0xF8, 0x28, 0x4E, 0xB0,
  0x2F, 0x82, 0x0E, 0x0B, 0x10,
  // "ħ" (U+0127)
  0x82, 0x5F, 0x71, 0x2B, 0x0B, 0x28, 0x27, 0xF8, 0x32, 0x8D, 0x03, 0xF8, 0xDD, 0x33, 0xFD, 0x8F,
  0xA3, 0xF7, 0x0D, 0xC3, 0xF6, 0x0C, 0xD3, 0xF5, 0x0C, 0xD3, 0xF5, 0x0C, 0xD3, 0xF5, 0x0C, 0xD0,
  // "Ĩ" (U+0128)
  0x48, 0x95, 0x12, 0xFA, 0x79, 0x6A, 0xBF, 0x41, 0x10, 0x22, 0x09, 0xA8, 0x4C, 0x01, 0xDE, 0x22,
  0x0C, 0x0E, 0x30, 0xC0, 0xE3, 0x0C, 0x0E, 0x30, 0xC0, 0xE3, 0x0C, 0x0E, 0x28, 0x41, 0xDE, 0x10,
  0x9A, 0x0C,
  // "ĩ" (U+0129)
  0x48, 0x95, 0x12, 0xFA, 0x79, 0x6A, 0xBF, 0x41, 0x10, 0x22, 0x81, 0x3F, 0x62, 0x81, 0x3F, 0x62,
  0x81, 0x3F, 0x62, 0x81, 0x3F, 0x62, 0x81, 0x3F, 0x62, 0x81, 0x3F, 0x62, 0x81, 0x3F, 0x61,
  // "Ī" (U+012A)
  0x80, 0x01, 0x08, 0xB8, 0x32, 0x44, 0x49, 0xA8, 0x6C, 0x1D, 0xE2, 0x0C, 0xE2, 0x0C, 0x0E, 0x20,
  0xC0, 0xE2, 0x0C, 0x0E, 0x28, 0x6C, 0xE0, 0x1D, 0xE1, 0x9A, 0x0C,
  // "ī" (U+012B)
  0x80, 0x01, 0x08, 0xB8, 0xB6, 0x24, 0x44, 0x03, 0xF6, 0x03, 0xF6, 0x03, 0xF6, 0x03, 0xF6, 0x03,
  0xF6, 0x03, 0xF6, 0x03, 0xF6,
  // "Ĭ" (U+012C)
  0x87, 0x57, 0x29, 0x22, 0xEF, 0xC2, 0x01, 0x03, 0x20, 0x9A, 0x84, 0xC0, 0x1D, 0xE2, 0x20, 0xC0,
  0xE3, 0x0C, 0x0E, 0x30, 0xC0, 0xE3, 0x0C, 0x0E, 0x30, 0xC0, 0xE2, 0x84, 0x1D, 0xE1, 0x09, 0xA0,
  0xC1,
  // "ĭ" (U+012D)
  0x87, 0x57, 0x29, 0x22, 0xEF, 0xC2, 0x01, 0x03, 0x38, 0x13, 0xF6, 0x28, 0x13, 0xF6, 0x28, 0x13,
  0xF6, 0x28, 0x13, 0xF6, 0x28, 0x13, 0xF6, 0x28, 0x13, 0xF6, 0x28, 0x13, 0xF6, 0x10,
  // "Į" (U+012E)
  0x09, 0xA8, 0x6C, 0x1D, 0xE2, 0x0C, 0xE2, 0x0C, 0x0E, 0x20, 0xC0, 0xE2, 0x0C, 0x0E, 0x28, 0x6C,
  0xE0, 0x1D, 0xE1, 0x9A, 0x89, 0x3C, 0x01, 0xD1, 0x07, 0xC1, 0x05, 0xFA, 0x20, 0x30, 0x20,
  // "į" (U+012F)
  0x84, 0x2E, 0x40, 0x51, 0x38, 0xB7, 0x3F, 0x63, 0xF6, 0x3F, 0x63, 0xF6, 0x3F, 0x63, 0xF6, 0x3F,
  0x61, 0xD1, 0x7C, 0x15, 0xFA, 0x03, 0x20,
  // "İ" (U+0130)
  0x18, 0x16, 0xF2, 0x28, 0x13, 0x09, 0xA8, 0x6C, 0x1D, 0xE2, 0x0C, 0xE2, 0x0C, 0x0E, 0x20, 0xC0,
  0xE2, 0x0C, 0x0E, 0x28, 0x6C, 0xE0, 0x1D, 0xE1, 0x9A, 0x0C,
  // "ı" (U+0131)
  0x8A, 0x33, 0xF6, 0x3F, 0x63, 0xF6, 0x3F, 0x63, 0xF6, 0x3F, 0x63, 0xF6,
  // "Ĳ" (U+0132)
  0x09, 0xA8, 0xE4, 0xC2, 0xF8, 0x1D, 0xE2, 0x2F, 0x80, 0xCE, 0x02, 0xF8, 0x0C, 0xE0, 0x2F, 0x80,
  0xCE, 0x02, 0xF8, 0x0C, 0xE0, 0x2F, 0x80, 0xCE, 0x02, 0xF8, 0x1D, 0xE1, 0x2F, 0x89, 0xA8, 0x2C,
  0x2F, 0x84, 0x81, 0x5F, 0x73, 0x0B, 0xA0, 0x23, 0x81, 0x57, 0x21,
  // "ĳ" (U+0133)
  0x89, 0x22, 0xE4, 0x2E, 0x40, 0x51, 0x05, 0x16, 0x8D, 0x03, 0xF6, 0x3F, 0x63, 0xF6, 0x3F, 0x63,
  0xF6, 0x3F, 0x63, 0xF6, 0x3F, 0x63, 0xF6, 0x3F, 0x63, 0xF6, 0x3F, 0x63, 0xF6, 0x3F, 0x63, 0x81,
  0x4F, 0x52, 0x82, 0x3B, 0xF4, 0x28, 0x16, 0xEA, 0x10,
  // "Ĵ" (U+0134)
  0x18, 0x78, 0xFA, 0x04, 0xD3, 0xD5, 0x68, 0x12, 0xF8, 0x28, 0x12, 0xF8, 0x28, 0x12, 0xF8, 0x28,
  0x12, 0xF8, 0x28, 0x12, 0xF8, 0x28, 0x12, 0xF8, 0x28, 0x12, 0xF8, 0x28, 0x12, 0xF8, 0x28, 0x12,
  0xF8, 0x28, 0x35, 0xF7, 0x0B, 0xA8, 0x32, 0x05, 0x72, 0x20,
  // "ĵ" (U+0135)
  0x18, 0x78, 0xFA, 0x04, 0xD3, 0xD5, 0x68, 0x13, 0xF6, 0x28, 0x13, 0xF6, 0x28, 0x13, 0xF6, 0x28,
  0x13, 0xF6, 0x28, 0x13, 0xF6, 0x28, 0x13, 0xF6, 0x28, 0x13, 0xF6, 0x28, 0x92, 0x3F, 0x50, 0x3A,
  0xF4, 0x06, 0xFA, 0x20,
  // "Ķ" (U+0136)
  0x8B, 0x02, 0xF8, 0x06, 0xF6, 0x2F, 0x81, 0xEC, 0x02, 0xF8, 0x9F, 0x30, 0x2F, 0xBF, 0xA2, 0x02,
  0xB0, 0x92, 0x8B, 0x22, 0xFD, 0xCF, 0x10, 0x2F, 0x84, 0xF8, 0x02, 0xF8, 0x0D, 0xE1, 0x2F, 0x80,
  0x6F, 0x77, 0x30, 0x60, 0x34, 0x81, 0x3E, 0x12,
  // "ķ" (U+0137)
  0x81, 0x3F, 0x53, 0x81, 0x3F, 0x53, 0x81, 0x3F, 0x53, 0x8A, 0x13, 0xF5, 0x1E, 0xC3, 0xF5, 0x9E,
  0x23, 0xF9, 0xF6, 0x03, 0xB8, 0xA2, 0x60, 0x3F, 0xAC, 0xD0, 0x3F, 0x54, 0xF7, 0x3F, 0x50, 0xCE,
  0x72, 0x06, 0x03, 0x38, 0x13, 0xE1, 0x10,
  // "ĸ" (U+0138)
  0x8A, 0x13, 0xF5, 0x0D, 0xC3, 0xF5, 0x8F, 0x23, 0xF8, 0xF7, 0x03, 0xB8, 0xA2, 0x60, 0x3F, 0xAC,
  0xD0, 0x3F, 0x54, 0xF6, 0x3F, 0x50, 0xCE,
  // "Ĺ" (U+0139)
  0x20, 0x13, 0x81, 0x1D, 0xA3, 0x02, 0x03, 0x48, 0x12, 0xF8, 0x38, 0x12, 0xF8, 0x38, 0x12, 0xF8,
  0x38, 0x12, 0xF8, 0x38, 0x12, 0xF8, 0x38, 0x12, 0xF8, 0x38, 0x12, 0xF8, 0x38, 0x52, 0xFC, 0x88,
  0x12, 0xC0, 0x30,
  // "ĺ" (U+013A)
  0x28, 0xC3, 0x11, 0xDA, 0x23, 0x03, 0xF5, 0x3F, 0x53, 0xF5, 0x3F, 0x53, 0xF5, 0x3F, 0x53, 0xF5,
  0x3F, 0x53, 0xF5, 0x3F, 0x50,
  // "Ļ" (U+013B)
  0x81, 0x2F, 0x83, 0x81, 0x2F, 0x83, 0x81, 0x2F, 0x83, 0x81, 0x2F, 0x83, 0x81, 0x2F, 0x83, 0x81,
  0x2F, 0x83, 0x81, 0x2F, 0x83, 0x85, 0x2F, 0xC8, 0x81, 0x2C, 0x03, 0x71, 0x06, 0x03, 0x38, 0x13,
  0xE1, 0x20,
  // "ļ" (U+013C)
  0x8B, 0x43, 0xF5, 0x3F, 0x53, 0xF5, 0x3F, 0x53, 0xF5, 0x3F, 0x53, 0xF5, 0x3F, 0x53, 0xF5, 0x3F,
  0x54, 0x83, 0x63, 0x3E, 0x10,
  // "Ľ" (U+013D)
  0x89, 0x52, 0xF8, 0x1F, 0x52, 0xF8, 0x15, 0x02, 0xF8, 0x38, 0x12, 0xF8, 0x38, 0x12, 0xF8, 0x38,
  0x12, 0xF8, 0x38, 0x12, 0xF8, 0x38, 0x52, 0xFC, 0x88, 0x12, 0xC0, 0x30,
  // "ľ" (U+013E)
  0x89, 0x33, 0xF7, 0xF5, 0x3F, 0x75, 0x03, 0xF5, 0x28, 0x13, 0xF5, 0x28, 0x13, 0xF5, 0x28, 0x13,
  0xF5, 0x28, 0x13, 0xF5, 0x28, 0x13, 0xF5, 0x28, 0x13, 0xF5, 0x28, 0x13, 0xF5, 0x20,
  // "Ŀ" (U+013F)
  0x81, 0x2F, 0x83, 0x81, 0x2F, 0x83, 0x81, 0x2F, 0x83, 0x81, 0x2F, 0x83, 0x89, 0x52, 0xF8, 0x6F,
  0x22, 0xF8, 0x03, 0x02, 0xF8, 0x38, 0x52, 0xFC, 0x88, 0x12, 0xC0, 0x30,
  // "ŀ" (U+0140)
  0x81, 0x3F, 0x52, 0x81, 0x3F, 0x52, 0x81, 0x3F, 0x52, 0x81, 0x3F, 0x52, 0x81, 0x3F, 0x52, 0x89,
  0x33, 0xFC, 0xF2, 0x3F, 0x63, 0x03, 0xF5, 0x28, 0x13, 0xF5, 0x28, 0x13, 0xF5, 0x20,
  // "Ł" (U+0141)
  0x19, 0x0A, 0x49, 0x0A, 0x49, 0x0B, 0x04, 0x3B, 0x84, 0x20, 0x4F, 0xD3, 0x28, 0x1D, 0xFA, 0x38,
  0x11, 0xFA, 0x49, 0x82, 0xD8, 0x82, 0x1C, 0x05,
  // "ł" (U+0142)
  0x89, 0x71, 0xF8, 0x01, 0xF8, 0x01, 0xF8, 0x01, 0xFB, 0x21, 0xA8, 0xA2, 0x7A, 0xFA, 0x0C, 0xF8,
  0x01, 0xF8, 0x01, 0xF8, 0x01, 0xF8, 0x10,
  // "Ń" (U+0143)
  0x50, 0x15, 0x81, 0x1D, 0xA5, 0x02, 0x03, 0x30, 0x2A, 0x84, 0x20, 0x4F, 0x42, 0xA8, 0xD0, 0x80,
  0x4F, 0x42, 0xFE, 0xE1, 0x4F, 0x42, 0xF9, 0xF7, 0x4F, 0x42, 0xF6, 0xBE, 0x4F, 0x42, 0xF6, 0x5F,
  0x9F, 0x42, 0xF6, 0x0D, 0xA8, 0x44, 0x2F, 0x60, 0x6A, 0x82, 0x42, 0xF6, 0x28, 0x1E, 0xF4,
  // "ń" (U+0144)
  0x40, 0x13, 0x81, 0x1D, 0xA3, 0x02, 0x03, 0x28, 0xD0, 0x3F, 0x6D, 0xD3, 0x3F, 0xD7, 0xFA, 0x3F,
  0x70, 0xCC, 0x3F, 0x60, 0xCD, 0x3F, 0x50, 0xCD, 0x3F, 0x50, 0xCD, 0x3F, 0x50, 0xCD,
  // "Ņ" (U+0145)
  0x02, 0xA8, 0x42, 0x04, 0xF4, 0x2A, 0x8D, 0x08, 0x04, 0xF4, 0x2F, 0xEE, 0x14, 0xF4, 0x2F, 0x9F,
  0x74, 0xF4, 0x2F, 0x6B, 0xE4, 0xF4, 0x2F, 0x65, 0xF9, 0xF4, 0x2F, 0x60, 0xDA, 0x84, 0x42, 0xF6,
  0x06, 0xA8, 0x24, 0x2F, 0x62, 0x81, 0xEF, 0x47, 0x40, 0x60, 0x35, 0x81, 0x3E, 0x13,
  // "ņ" (U+0146)
  0x8D, 0x03, 0xF6, 0xDD, 0x33, 0xFD, 0x7F, 0xA3, 0xF7, 0x0C, 0xC3, 0xF6, 0x0C, 0xD3, 0xF5, 0x0C,
  0xD3, 0xF5, 0x0C, 0xD3, 0xF5, 0x0C, 0xD7, 0x20, 0x60, 0x33, 0x81, 0x3E, 0x11,
  // "Ň" (U+0147)
  0x28, 0x34, 0xD3, 0xD5, 0x48, 0x18, 0xFA, 0x73, 0x02, 0xA8, 0x42, 0x04, 0xF4, 0x2A, 0x8D, 0x08,
  0x04, 0xF4, 0x2F, 0xEE, 0x14, 0xF4, 0x2F, 0x9F, 0x74, 0xF4, 0x2F, 0x6B, 0xE4, 0xF4, 0x2F, 0x65,
  0xF9, 0xF4, 0x2F, 0x60, 0xDA, 0x84, 0x42, 0xF6, 0x06, 0xA8, 0x24, 0x2F, 0x62, 0x81, 0xEF, 0x40,
  // "ň" (U+0148)
  0x18, 0x34, 0xD3, 0xD5, 0x28, 0x18, 0xFA, 0x78, 0xD0, 0x3F, 0x6D, 0xD3, 0x3F, 0xD7, 0xFA, 0x3F,
  0x70, 0xCC, 0x3F, 0x60, 0xCD, 0x3F, 0x50, 0xCD, 0x3F, 0x50, 0xCD, 0x3F, 0x50, 0xCD,
  // "ŉ" (U+0149)
  0x81, 0x3F, 0x54, 0x81, 0x6F, 0x14, 0x09, 0xA8, 0xD4, 0x6D, 0xD3, 0x03, 0xFD, 0x7F, 0xA0, 0x3F,
  0x70, 0xCC, 0x03, 0xF6, 0x0C, 0xD0, 0x3F, 0x50, 0xCD, 0x03, 0xF5, 0x0C, 0xD0, 0x3F, 0x50, 0xCD,
  // "Ŋ" (U+014A)
  0x02, 0xA8, 0x42, 0x04, 0xF4, 0x2A, 0x8D, 0x0A, 0x04, 0xF4, 0x2F, 0xEF, 0x24, 0xF4, 0x2F, 0x7F,
  0xA4, 0xF4, 0x2F, 0x69, 0xF7, 0xF4, 0x2F, 0x61, 0xEE, 0xF4, 0x2F, 0x60, 0x8A, 0x89, 0x24, 0x2F,
  0x60, 0x1E, 0xF4, 0x2F, 0x62, 0x81, 0x7F, 0x44, 0x82, 0x28, 0xF2, 0x4A, 0x0B, 0x50, 0x40, 0x32,
  // "ŋ" (U+014B)
  0x8D, 0x03, 0xF6, 0xDD, 0x33, 0xFD, 0x7F, 0xA3, 0xF7, 0x0C, 0xC3, 0xF6, 0x0C, 0xD3, 0xF5, 0x0C,
  0xD3, 0xF5, 0x0C, 0xD3, 0xF5, 0x0C, 0xD4, 0x0C, 0x0D, 0x38, 0x16, 0xEA, 0x38, 0x1D, 0xE3,
  // "Ō" (U+014C)
  0x28, 0x00, 0x14, 0x08, 0xB4, 0x02, 0x0F, 0x43, 0x83, 0x1A, 0xEE, 0x93, 0x89, 0x0B, 0xF8, 0x9F,
  0x90, 0x2F, 0xA2, 0x84, 0xCF, 0x04, 0xF6, 0x28, 0x48, 0xF3, 0x6F, 0x52, 0x84, 0x7F, 0x35, 0xF6,
  0x28, 0x48, 0xF2, 0x2F, 0xA2, 0x0C, 0x92, 0x84, 0xBF, 0x89, 0xF8, 0x28, 0x31, 0xAE, 0xE9, 0x20,
  // "ō" (U+014D)
  0x18, 0x00, 0x12, 0x08, 0xB2, 0x02, 0x0F, 0x42, 0x8C, 0x65, 0xDE, 0x80, 0x2F, 0xB9, 0xF6, 0x6F,
  0x30, 0xDB, 0x7F, 0x20, 0xCD, 0x6F, 0x30, 0xEB, 0x1F, 0xB9, 0xF7, 0x05, 0xDE, 0x91,
  // "Ŏ" (U+014E)
  0x28, 0x35, 0x72, 0x92, 0x38, 0x22, 0xEF, 0xC5, 0x01, 0x03, 0x48, 0x31, 0xAE, 0xE9, 0x38, 0x90,
  0xBF, 0x89, 0xF9, 0x02, 0xFA, 0x28, 0x4C, 0xF0, 0x4F, 0x62, 0x84, 0x8F, 0x36, 0xF5, 0x28, 0x47,
  0xF3, 0x5F, 0x62, 0x84, 0x8F, 0x22, 0xFA, 0x20, 0xC9, 0x28, 0x4B, 0xF8, 0x9F, 0x82, 0x83, 0x1A,
  0xEE, 0x92,
  // "ŏ" (U+014F)
  0x18, 0x90, 0x57, 0x29, 0x20, 0x2E, 0xFC, 0x30, 0x10, 0x33, 0x8C, 0x65, 0xDE, 0x80, 0x2F, 0xB9,
  0xF6, 0x6F, 0x30, 0xDB, 0x7F, 0x20, 0xCD, 0x6F, 0x30, 0xEB, 0x1F, 0xB9, 0xF7, 0x05, 0xDE, 0x91,
  // "Ő" (U+0150)
  0x38, 0x00, 0x13, 0x83, 0x1D, 0x7D, 0x73, 0x82, 0x22, 0x12, 0x38, 0x31, 0xAE, 0xE9, 0x38, 0x90,
  0xBF, 0x89, 0xF9, 0x02, 0xFA, 0x28, 0x4C, 0xF0, 0x4F, 0x62, 0x84, 0x8F, 0x36, 0xF5, 0x28, 0x47,
  0xF3, 0x5F, 0x62, 0x84, 0x8F, 0x22, 0xFA, 0x20, 0xC9, 0x28, 0x4B, 0xF8, 0x9F, 0x82, 0x83, 0x1A,
  0xEE, 0x92,
  // "ő" (U+0151)
  0x28, 0x00, 0x11, 0x89, 0x01, 0xD7, 0xD7, 0x02, 0x21, 0x22, 0x8C, 0x65, 0xDE, 0x80, 0x2F, 0xB9,
  0xF6, 0x6F, 0x30, 0xDB, 0x7F, 0x20, 0xCD, 0x6F, 0x30, 0xEB, 0x1F, 0xB9, 0xF7, 0x05, 0xDE, 0x91,
  // "Œ" (U+0152)
  0x18, 0x11, 0xAE, 0xC8, 0x97, 0xD0, 0xBF, 0x89, 0xF9, 0x65, 0x2F, 0x90, 0x4F, 0x52, 0x89, 0x45,
  0xF6, 0x04, 0xF6, 0x11, 0x6F, 0x50, 0x4B, 0x89, 0x7B, 0x5F, 0x60, 0x4F, 0x84, 0x32, 0xF9, 0x04,
  0xF5, 0x38, 0x92, 0xBF, 0x89, 0xF9, 0x65, 0x01, 0xAE, 0xC0, 0xD0,
  // "œ" (U+0153)
  0x18, 0x93, 0x5D, 0xE7, 0x7E, 0xD3, 0x02, 0xFB, 0x9A, 0x8A, 0x18, 0xCD, 0x06, 0xF3, 0x0D, 0xD1,
  0x5F, 0x27, 0xF2, 0x0C, 0xC8, 0x95, 0x46, 0xF3, 0x0E, 0xD4, 0x44, 0x12, 0xFB, 0x9A, 0x81, 0x97,
  0x92, 0x86, 0x5D, 0xE7, 0x6D, 0xEA, 0x10,
  // "Ŕ" (U+0154)
  0x40, 0x14, 0x81, 0x1D, 0xA4, 0x02, 0x03, 0x30, 0x2A, 0x8B, 0x0E, 0xB2, 0x02, 0xFB, 0x8F, 0xC0,
  0x2F, 0x80, 0xCE, 0x02, 0xF9, 0x3E, 0xC0, 0x2B, 0x86, 0xE3, 0x02, 0xFA, 0xBE, 0x28, 0xA3, 0x2F,
  0x84, 0xF7, 0x02, 0xF8, 0x0D, 0xE0, 0x2F, 0x80, 0x6F, 0x60,
  // "ŕ" (U+0155)
  0x30, 0x12, 0x81, 0x1D, 0xA2, 0x02, 0x03, 0x28, 0x93, 0x3F, 0x5E, 0x53, 0xFE, 0x72, 0x3F, 0x82,
  0x81, 0x3F, 0x62, 0x81, 0x3F, 0x62, 0x81, 0x3F, 0x62, 0x81, 0x3F, 0x62,
  // "Ŗ" (U+0156)
  0x02, 0xA8, 0xB0, 0xEB, 0x20, 0x2F, 0xB8, 0xFC, 0x02, 0xF8, 0x0C, 0xE0, 0x2F, 0x93, 0xEC, 0x02,
  0xB8, 0x6E, 0x30, 0x2F, 0xAB, 0xE2, 0x8A, 0x32, 0xF8, 0x4F, 0x70, 0x2F, 0x80, 0xDE, 0x02, 0xF8,
  0x06, 0xF6, 0x73, 0x06, 0x03, 0x48, 0x13, 0xE1, 0x20,
  // "ŗ" (U+0157)
  0x89, 0x33, 0xF5, 0xE5, 0x3F, 0xE7, 0x23, 0xF8, 0x28, 0x13, 0xF6, 0x28, 0x13, 0xF6, 0x28, 0x13,
  0xF6, 0x28, 0x13, 0xF6, 0x71, 0x06, 0x03, 0x28, 0x13, 0xE1, 0x20,
  // "Ř" (U+0158)
  0x18, 0x34, 0xD3, 0xD5, 0x38, 0x18, 0xFA, 0x72, 0x02, 0xA8, 0xB0, 0xEB, 0x20, 0x2F, 0xB8, 0xFC,
  0x02, 0xF8, 0x0C, 0xE0, 0x2F, 0x93, 0xEC, 0x02, 0xB8, 0x6E, 0x30, 0x2F, 0xAB, 0xE2, 0x8A, 0x32,
  0xF8, 0x4F, 0x70, 0x2F, 0x80, 0xDE, 0x02, 0xF8, 0x06, 0xF6,
  // "ř" (U+0159)
  0x87, 0x4D, 0x3D, 0x50, 0x8F, 0xA6, 0x89, 0x33, 0xF5, 0xE5, 0x3F, 0xE7, 0x23, 0xF8, 0x28, 0x13,
  0xF6, 0x28, 0x13, 0xF6, 0x28, 0x13, 0xF6, 0x28, 0x13, 0xF6, 0x20,
  // "Ś" (U+015A)
  0x40, 0x13, 0x81, 0x1D, 0xA3, 0x02, 0x03, 0x38, 0x94, 0x7E, 0xEB, 0x14, 0xFB, 0x7C, 0x07, 0xF4,
  0x38, 0x24, 0xFD, 0x33, 0x09, 0xA0, 0x73, 0x82, 0x4E, 0xF1, 0x38, 0x94, 0x7F, 0x38, 0xA7, 0xDE,
  0x05, 0xDF, 0xD4, 0x10,
  // "ś" (U+015B)
  0x30, 0x12, 0x81, 0x1D, 0xA2, 0x02, 0x03, 0x28, 0x93, 0x1B, 0xEC, 0x38, 0xF7, 0xA2, 0x7F, 0x72,
  0x83, 0x1B, 0xFC, 0x12, 0x89, 0x36, 0xF7, 0x78, 0x8F, 0x76, 0xEE, 0xB1,
  // "Ŝ" (U+015C)
  0x18, 0x18, 0xFA, 0x28, 0x34, 0xD3, 0xD5, 0x71, 0x89, 0x47, 0xEE, 0xB1, 0x4F, 0xB7, 0xC0, 0x7F,
  0x43, 0x82, 0x4F, 0xD3, 0x30, 0x9A, 0x07, 0x38, 0x24, 0xEF, 0x13, 0x89, 0x47, 0xF3, 0x8A, 0x7D,
  0xE0, 0x5D, 0xFD, 0x41,
  // "ŝ" (U+015D)
  0x18, 0x78, 0xFA, 0x04, 0xD3, 0xD5, 0x58, 0x93, 0x1B, 0xEC, 0x38, 0xF7, 0xA2, 0x7F, 0x72, 0x83,
  0x1B, 0xFC, 0x12, 0x89, 0x36, 0xF7, 0x78, 0x8F, 0x76, 0xEE, 0xB1,
  // "Ş" (U+015E)
  0x18, 0x94, 0x7E, 0xEB, 0x14, 0xFB, 0x7C, 0x07, 0xF4, 0x38, 0x24, 0xFD, 0x33, 0x09, 0xA0, 0x73,
  0x82, 0x4E, 0xF1, 0x38, 0x94, 0x7F, 0x38, 0xA7, 0xDE, 0x05, 0xDF, 0xD4, 0x30, 0x09, 0x38, 0x21,
  0x8F, 0x32, 0x81, 0x2E, 0xB2,
  // "ş" (U+015F)
  0x89, 0x31, 0xBE, 0xC3, 0x8F, 0x7A, 0x27, 0xF7, 0x28, 0x31, 0xBF, 0xC1, 0x28, 0x96, 0x6F, 0x77,
  0x88, 0xF7, 0x6E, 0xFB, 0x10, 0x99, 0x28, 0x61, 0x8F, 0x30, 0x2E, 0xB2,
  // "Š" (U+0160)
  0x83, 0x4D, 0x3D, 0x52, 0x81, 0x8F, 0xA7, 0x28, 0x94, 0x7E, 0xEB, 0x14, 0xFB, 0x7C, 0x07, 0xF4,
  0x38, 0x24, 0xFD, 0x33, 0x09, 0xA0, 0x73, 0x82, 0x4E, 0xF1, 0x38, 0x94, 0x7F, 0x38, 0xA7, 0xDE,
  0x05, 0xDF, 0xD4, 0x10,
  // "š" (U+0161)
  0x87, 0x4D, 0x3D, 0x50, 0x8F, 0xA6, 0x89, 0x31, 0xBE, 0xC3, 0x8F, 0x7A, 0x27, 0xF7, 0x28, 0x31,
  0xBF, 0xC1, 0x28, 0x93, 0x6F, 0x77, 0x88, 0xF7, 0x6E, 0xEB, 0x10,
  // "Ţ" (U+0162)
  0x0C, 0xC8, 0x57, 0x56, 0xFC, 0x63, 0x29, 0x0A, 0x49, 0x0A, 0x49, 0x0A, 0x49, 0x0A, 0x49, 0x0A,
  0x49, 0x0A, 0x49, 0x0A, 0x40, 0x09, 0x38, 0x21, 0x8F, 0x32, 0x81, 0x2E, 0xB2,
  // "ţ" (U+0163)
  0x10, 0x50, 0x42, 0x82, 0xD8, 0x09, 0xA8, 0x96, 0xD6, 0xFB, 0x51, 0xF8, 0x01, 0xF8, 0x01, 0xF8,
  0x29, 0x89, 0x7C, 0x70, 0x8F, 0xC0, 0x99, 0x01, 0x8F, 0x32, 0xEB, 0x10,
  // "Ť" (U+0164)
  0x83, 0x4D, 0x3D, 0x52, 0x81, 0x8F, 0xA7, 0x10, 0xCC, 0x85, 0x75, 0x6F, 0xC6, 0x32, 0x90, 0xA4,
  0x90, 0xA4, 0x90, 0xA4, 0x90, 0xA4, 0x90, 0xA4, 0x90, 0xA4, 0x90, 0xA2,
  // "ť" (U+0165)
  0x38, 0x61, 0xF5, 0x05, 0x41, 0x52, 0x0D, 0x08, 0x30, 0x9A, 0x0D, 0x28, 0x26, 0xFB, 0x52, 0x81,
  0x1F, 0x83, 0x81, 0x1F, 0x83, 0x81, 0x1F, 0x84, 0x90, 0xC0, 0x73, 0x81, 0x8E, 0xC2,
  // "Ŧ" (U+0166)
  0x0C, 0xC8, 0x57, 0x56, 0xFC, 0x63, 0x29, 0x0A, 0x38, 0x41, 0xFB, 0x10, 0x2B, 0x0D, 0x28, 0x24,
  0xFC, 0x43, 0x90, 0xA4, 0x90, 0xA4, 0x90, 0xA2,
  // "ŧ" (U+0167)
  0x10, 0x50, 0x42, 0x82, 0xD8, 0x09, 0xA8, 0x90, 0xD6, 0xFB, 0x53, 0xF8, 0x1B, 0xA8, 0x93, 0xB4,
  0xFA, 0x30, 0xFC, 0x70, 0x9F, 0xC0,
  // "Ũ" (U+0168)
  0x50, 0x12, 0x83, 0x2F, 0xA7, 0x92, 0x83, 0x6A, 0xBF, 0x42, 0x82, 0x11, 0x02, 0x28, 0xF4, 0x2F,
  0x80, 0x1F, 0x92, 0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F, 0x92, 0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F,
  0x92, 0xF8, 0x01, 0xF9, 0x1F, 0x90, 0x2F, 0x80, 0xDF, 0x9C, 0xF4, 0x02, 0xBE, 0xD6, 0x10,
  // "ũ" (U+0169)
  0x58, 0xF3, 0x10, 0x2F, 0xA7, 0x90, 0x6A, 0xBF, 0x40, 0x11, 0x02, 0x04, 0xF5, 0x0C, 0xC4, 0xF5,
  0x0C, 0xC4, 0xF5, 0x0C, 0xC4, 0xF5, 0x0C, 0xC3, 0xF6, 0x0D, 0xC1, 0xFB, 0x7F, 0xC0, 0x8E, 0xB9,
  0xC0,
  // "Ū" (U+016A)
  0x18, 0x00, 0x13, 0x08, 0xB3, 0x02, 0x0F, 0x42, 0x8F, 0x42, 0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F,
  0x92, 0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F, 0x92, 0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F, 0x91, 0xF9,
  0x02, 0xF8, 0x0D, 0xF9, 0xCF, 0x40, 0x2B, 0xED, 0x61,
  // "ū" (U+016B)
  0x18, 0x00, 0x12, 0x08, 0xB2, 0x8D, 0x52, 0x44, 0x40, 0x4F, 0x50, 0xCC, 0x4F, 0x50, 0xCC, 0x4F,
  0x50, 0xCC, 0x4F, 0x50, 0xCC, 0x3F, 0x60, 0xDC, 0x1F, 0xB7, 0xFC, 0x08, 0xEB, 0x9C,
  // "Ŭ" (U+016C)
  0x18, 0x35, 0x72, 0x92, 0x28, 0x22, 0xEF, 0xC4, 0x01, 0x03, 0x38, 0xF4, 0x2F, 0x80, 0x1F, 0x92,
  0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F, 0x92, 0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F, 0x92, 0xF8, 0x01,
  0xF9, 0x1F, 0x90, 0x2F, 0x80, 0xDF, 0x9C, 0xF4, 0x02, 0xBE, 0xD6, 0x10,
  // "ŭ" (U+016D)
  0x18, 0x90, 0x57, 0x29, 0x20, 0x2E, 0xFC, 0x30, 0x10, 0x32, 0x8D, 0x04, 0xF5, 0x0C, 0xC4, 0xF5,
  0x0C, 0xC4, 0xF5, 0x0C, 0xC4, 0xF5, 0x0C, 0xC3, 0xF6, 0x0D, 0xC1, 0xFB, 0x7F, 0xC0, 0x8E, 0xB9,
  0xC0,
  // "Ů" (U+016E)
  0x28, 0x23, 0xED, 0x13, 0x82, 0x7B, 0xC4, 0x38, 0x24, 0xFE, 0x14, 0x02, 0x01, 0x28, 0xF4, 0x2F,
  0x80, 0x1F, 0x92, 0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F, 0x92, 0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F,
  0x92, 0xF8, 0x01, 0xF9, 0x1F, 0x90, 0x2F, 0x80, 0xDF, 0x9C, 0xF4, 0x02, 0xBE, 0xD6, 0x10,
  // "ů" (U+016F)
  0x18, 0x23, 0xED, 0x12, 0x82, 0x7B, 0xC4, 0x28, 0x24, 0xFE, 0x13, 0x02, 0x01, 0x28, 0xD0, 0x4F,
  0x50, 0xCC, 0x4F, 0x50, 0xCC, 0x4F, 0x50, 0xCC, 0x4F, 0x50, 0xCC, 0x3F, 0x60, 0xDC, 0x1F, 0xB7,
  0xFC, 0x08, 0xEB, 0x9C,
  // "Ű" (U+0170)
  0x38, 0x00, 0x12, 0x83, 0x1D, 0x7D, 0x72, 0x89, 0x81, 0x22, 0x12, 0x02, 0xF8, 0x01, 0xF9, 0x2F,
  0x80, 0x1F, 0x92, 0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F, 0x92, 0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F,
  0x91, 0xF9, 0x02, 0xF8, 0x0D, 0xF9, 0xCF, 0x40, 0x2B, 0xED, 0x61,
  // "ű" (U+0171)
  0x28, 0x00, 0x11, 0x8E, 0x31, 0xD7, 0xD7, 0x02, 0x21, 0x20, 0x4F, 0x50, 0xCC, 0x4F, 0x50, 0xCC,
  0x4F, 0x50, 0xCC, 0x4F, 0x50, 0xCC, 0x3F, 0x60, 0xDC, 0x1F, 0xB7, 0xFC, 0x08, 0xEB, 0x9C,
  // "Ų" (U+0172)
  0x8F, 0x42, 0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F, 0x92, 0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F, 0x92,
  0xF8, 0x01, 0xF9, 0x2F, 0x80, 0x1F, 0x91, 0xF9, 0x02, 0xF8, 0x0D, 0xF9, 0xCF, 0x30, 0x2B, 0xEF,
  0x74, 0x03, 0x0C, 0x58, 0x18, 0xC4, 0x48, 0x14, 0xE8, 0x10,
  // "ų" (U+0173)
  0x8D, 0x04, 0xF5, 0x0C, 0xC4, 0xF5, 0x0C, 0xC4, 0xF5, 0x0C, 0xC4, 0xF5, 0x0C, 0xC3, 0xF6, 0x0D,
  0xC1, 0xFB, 0x7F, 0xC0, 0x8E, 0xBA, 0xC3, 0x81, 0x1D, 0x13, 0x81, 0x7C, 0x13, 0x81, 0x5F, 0xA4,
  0x03, 0x02,
  // "Ŵ" (U+0174)
  0x38, 0x18, 0xFA, 0x68, 0x34, 0xD3, 0xD5, 0x76, 0x0D, 0x0B, 0x20, 0xD0, 0xC2, 0x82, 0xCD, 0xAE,
  0x2A, 0x29, 0x83, 0xA7, 0xF2, 0x4A, 0x8A, 0x43, 0x2F, 0x74, 0xF5, 0x7D, 0xD6, 0x5F, 0x31, 0xF7,
  0xAA, 0xB9, 0x89, 0x28, 0x6D, 0xAD, 0x78, 0xCB, 0xD2, 0x86, 0xAD, 0xF4, 0x4E, 0xDA, 0x20, 0x7A,
  0x00, 0x1A, 0x06, 0x28, 0x14, 0xFD, 0x28, 0x1D, 0xF3, 0x10,
  // "ŵ" (U+0175)
  0x38, 0x18, 0xFA, 0x58, 0x34, 0xD3, 0xD5, 0x74, 0x8C, 0x1C, 0xC0, 0x9F, 0x60, 0xE9, 0x9F, 0x0C,
  0xE9, 0x2F, 0x65, 0xF3, 0xFA, 0xC5, 0xF2, 0x2F, 0x8F, 0x5F, 0x8E, 0x28, 0x5E, 0xCD, 0x1F, 0xCB,
  0x28, 0x5B, 0xFB, 0x0E, 0xF8, 0x28, 0x57, 0xF8, 0x0B, 0xF4, 0x10,
  // "Ŷ" (U+0176)
  0x28, 0x18, 0xFA, 0x38, 0x34, 0xD3, 0xD5, 0x71, 0x0C, 0x0E, 0x28, 0x7B, 0xE1, 0x6F, 0x51, 0xF9,
  0x28, 0x3E, 0xB7, 0xF3, 0x28, 0x29, 0xFE, 0xC3, 0x02, 0xA0, 0x54, 0x0C, 0x95, 0x0B, 0x0E, 0x50,
  0xB0, 0xE5, 0x0B, 0x0E, 0x30,
  // "ŷ" (U+0177)
  0x18, 0x18, 0xFA, 0x28, 0x34, 0xD3, 0xD5, 0x78, 0x96, 0xCD, 0x01, 0xF9, 0x8F, 0x24, 0xF4, 0x3F,
  0x68, 0x92, 0x82, 0xE9, 0xCB, 0x28, 0x29, 0xDF, 0x72, 0x04, 0xA0, 0x23, 0x90, 0xD3, 0x81, 0x1F,
  0x92, 0x82, 0x4B, 0xF3, 0x28, 0x18, 0xE7, 0x30,
  // "Ÿ" (U+0178)
  0x18, 0x2A, 0xA6, 0xD3, 0x82, 0x11, 0x02, 0x20, 0xC0, 0xE2, 0x87, 0xBE, 0x16, 0xF5, 0x1F, 0x92,
  0x83, 0xEB, 0x7F, 0x32, 0x82, 0x9F, 0xEC, 0x30, 0x2A, 0x05, 0x40, 0xC9, 0x50, 0xB0, 0xE5, 0x0B,
  0x0E, 0x50, 0xB0, 0xE3,
  // "Ź" (U+0179)
  0x30, 0x13, 0x81, 0x1D, 0xA3, 0x02, 0x03, 0x30, 0xAC, 0x85, 0x54, 0x66, 0xCF, 0x22, 0x81, 0x1F,
  0xA3, 0x81, 0x8F, 0x22, 0x81, 0x1F, 0xA3, 0x81, 0x8F, 0x22, 0x81, 0x1E, 0xA3, 0x85, 0x8F, 0x96,
  0x62, 0xBC, 0x06,
  // "ź" (U+017A)
  0x30, 0x12, 0x81, 0x1D, 0xA2, 0x02, 0x03, 0x20, 0x9B, 0x84, 0x63, 0x6B, 0xF3, 0x20, 0xE0, 0xB2,
  0x81, 0x7F, 0x32, 0x0E, 0x0B, 0x28, 0x47, 0xF9, 0x63, 0xBB, 0x08,
  // "Ż" (U+017B)
  0x28, 0x16, 0xF2, 0x40, 0x32, 0x0A, 0xC8, 0x55, 0x46, 0x6C, 0xF2, 0x28, 0x11, 0xFA, 0x38, 0x18,
  0xF2, 0x28, 0x11, 0xFA, 0x38, 0x18, 0xF2, 0x28, 0x11, 0xEA, 0x38, 0x58, 0xF9, 0x66, 0x2B, 0xC0,
  0x60,
  // "ż" (U+017C)
  0x18, 0x16, 0xF2, 0x30, 0x32, 0x09, 0xB8, 0x46, 0x36, 0xBF, 0x32, 0x0E, 0x0B, 0x28, 0x17, 0xF3,
  0x20, 0xE0, 0xB2, 0x84, 0x7F, 0x96, 0x3B, 0xB0, 0x80,
  // "Ž" (U+017D)
  0x83, 0x4D, 0x3D, 0x52, 0x81, 0x8F, 0xA7, 0x10, 0xAC, 0x85, 0x54, 0x66, 0xCF, 0x22, 0x81, 0x1F,
  0xA3, 0x81, 0x8F, 0x22, 0x81, 0x1F, 0xA3, 0x81, 0x8F, 0x22, 0x81, 0x1E, 0xA3, 0x85, 0x8F, 0x96,
  0x62, 0xBC, 0x06,
  // "ž" (U+017E)
  0x87, 0x4D, 0x3D, 0x50, 0x8F, 0xA6, 0x09, 0xB8, 0x46, 0x36, 0xBF, 0x32, 0x0E, 0x0B, 0x28, 0x17,
  0xF3, 0x20, 0xE0, 0xB2, 0x84, 0x7F, 0x96, 0x3B, 0xB0, 0x80,
  // "ſ" (U+017F)
  0x18, 0xC4, 0x7E, 0xD0, 0xFC, 0x72, 0xF7, 0x02, 0xF7, 0x02, 0xF7, 0x02, 0xF7, 0x02, 0xF7, 0x02,
  0xF7, 0x02, 0xF7, 0x02, 0xF7, 0x10,
  // "Ω" (U+03A9)
  0x18, 0x31, 0xAE, 0xD9, 0x38, 0x90, 0xCF, 0x89, 0xF9, 0x03, 0xF8, 0x28, 0x4B, 0xF1, 0x6F, 0x52,
  0x84, 0x7F, 0x35, 0xF4, 0x28, 0x47, 0xF3, 0x3F, 0x62, 0x08, 0x92, 0x0C, 0x0B, 0x28, 0x92, 0xD9,
  0x04, 0x8F, 0x58, 0xF7, 0x3B, 0xA0, 0x60, 0x9A, 0x08,
  // "μ" (U+03BC)
  0x8D, 0x33, 0xF5, 0x0C, 0xC3, 0xF5, 0x0C, 0xC3, 0xF5, 0x0C, 0xC3, 0xF5, 0x0C, 0xC3, 0xF6, 0x0E,
  0xC3, 0xFC, 0x9F, 0xC3, 0xFD, 0xD9, 0xC3, 0xF5, 0x38, 0x13, 0xF5, 0x38, 0x13, 0xF5, 0x30,
  // "π" (U+03C0)
  0x09, 0xE8, 0x61, 0x5D, 0xD6, 0xCF, 0x62, 0x82, 0xCC, 0x0A, 0x93, 0x82, 0xCC, 0x0A, 0x93, 0x82,
  0xCC, 0x0A, 0x93, 0x84, 0xCC, 0x09, 0xF8, 0x28, 0x4C, 0xC0, 0x3E, 0xD1,
  // "–" (U+2013)
  0x80, 0x21, 0x09, 0xC8, 0x59, 0x24, 0x44, 0x42,
  // "—" (U+2014)
  0x80, 0x90, 0x10, 0x9F, 0xB0, 0x90, 0x28, 0x06, 0x40, 0x20,
  // "€" (U+20AC)
  0x28, 0x97, 0x9E, 0xE7, 0x08, 0xF8, 0x85, 0x1E, 0xC1, 0x10, 0xBB, 0x87, 0x80, 0x5F, 0xB6, 0x20,
  0xBB, 0x85, 0x30, 0x3D, 0xC4, 0x12, 0x83, 0x8F, 0x87, 0x62, 0x82, 0xAE, 0xE6,
  // "₿" (U+20BF)
  0x18, 0x41, 0xAA, 0x10, 0x2B, 0x8A, 0x39, 0x02, 0xFA, 0xAF, 0x52, 0xF7, 0x2F, 0x72, 0xF8, 0x7F,
  0x42, 0xB8, 0xA3, 0xC0, 0x2F, 0x97, 0xF7, 0x2F, 0x70, 0xF9, 0x2F, 0xA9, 0xF7, 0x2B, 0x0A, 0x28,
  0x21, 0xAA, 0x13, 0x00, 0x22,
  // "‘" (U+2018)
  0x18, 0x4E, 0x64, 0xF3, 0x89, 0x10,
  // "’" (U+2019)
  0x86, 0x3F, 0x56, 0xF1, 0x9B, 0x10,
  // "‚" (U+201A)
  0x86, 0x3F, 0x56, 0xF1, 0x9B, 0x10,
  // "‛" (U+201B)
  0x87, 0x8F, 0x04, 0xF2, 0x0E, 0x60,
  // "“" (U+201C)
  0x18, 0x94, 0xE6, 0x6E, 0x4F, 0x3C, 0xB8, 0xF1, 0xF9,
  // "”" (U+201D)
  0x89, 0x53, 0xF5, 0xBE, 0x6F, 0x1D, 0xA9, 0xB1, 0xF4,
  // "„" (U+201E)
  0x89, 0x53, 0xF5, 0xBE, 0x6F, 0x1D, 0xA9, 0xB1, 0xF4,
  // "‟" (U+201F)
  0x89, 0x58, 0xF1, 0xF9, 0x4F, 0x3C, 0xB0, 0xE6, 0x6E,
  // "†" (U+2020)
  0x20, 0xC0, 0xA4, 0x0B, 0x08, 0x28, 0x92, 0x25, 0xB9, 0x51, 0x5E, 0xEE, 0xE4, 0x20, 0x90, 0x74,
  0x0A, 0x08, 0x40, 0xB0, 0x84, 0x0B, 0x09, 0x40, 0xC0, 0xA4, 0x0D, 0x0B, 0x20,
  // "‡" (U+2021)
  0x20, 0x0B, 0x40, 0x09, 0x28, 0x92, 0x4A, 0xCC, 0xA3, 0x4A, 0xCC, 0xA3, 0x20, 0xA0, 0x94, 0x0A,
  0x09, 0x28, 0x92, 0x4A, 0xCC, 0xA3, 0x4A, 0xCC, 0xA3, 0x20, 0x09, 0x40, 0x0B, 0x20,
  // "•" (U+2022)
  0x18, 0x2B, 0xE7, 0x5A, 0x0E, 0x05, 0xA8, 0x3E, 0x0B, 0xE6,
  // "…" (U+2026)
  0x8A, 0x02, 0xF5, 0x2F, 0x52, 0xF5, 0x2E, 0x52, 0xE5, 0x2E, 0x50,
  // "‰" (U+2030)
  0x86, 0x1C, 0xE4, 0x01, 0xF2, 0x68, 0x57, 0xEB, 0xC0, 0x8B, 0x78, 0x59, 0xA5, 0xE0, 0xE4, 0x78,
  0x95, 0x8C, 0x8D, 0x5D, 0x7E, 0x80, 0x6E, 0x90, 0x2A, 0x8A, 0x77, 0xC8, 0xF7, 0xF2, 0xE7, 0xF3,
  0x01, 0x33, 0xF4, 0xF1, 0xF6, 0xF2, 0xD6, 0x38, 0x91, 0x99, 0x3F, 0x1F, 0x6F, 0x3D, 0x63, 0x89,
  0x1E, 0x30, 0xFA, 0xF2, 0xEA, 0xF3, 0x20, 0x60, 0xC2, 0x85, 0x7E, 0x80, 0x5E, 0xA1,
  // "‹" (U+2039)
  0x18, 0x94, 0x1C, 0x20, 0xCD, 0x07, 0xF4, 0x02, 0xE9, 0x28, 0x15, 0xF3, 0x20, 0x31,
  // "›" (U+203A)
  0x04, 0x0C, 0x28, 0x11, 0xEA, 0x28, 0x90, 0x6F, 0x50, 0xBD, 0x15, 0xF3, 0x20, 0x32,
  // "⁄" (U+2044)
  0x38, 0x11, 0xE3, 0x30, 0x80, 0xB3, 0x81, 0x1E, 0x43, 0x08, 0x0C, 0x38, 0x11, 0xE4, 0x30, 0x70,
  0xC4, 0x0E, 0x04, 0x30, 0x70, 0xC4, 0x0E, 0x05, 0x40,
  // "™" (U+2122)
  0x0F, 0x14, 0x01, 0x0D, 0xA8, 0xC3, 0x9E, 0x08, 0xD3, 0xE5, 0x8F, 0x2C, 0xD0, 0xD1, 0x8B, 0x8B,
  0xD0, 0xD1, 0x86, 0xE6, 0xD0, 0xA0, 0x64, 0x91, 0x90,
  // "⅒" (U+2152)
  0x58, 0x11, 0xE3, 0x68, 0x47, 0xF1, 0x08, 0xB6, 0x85, 0x4B, 0xF1, 0x1E, 0x47, 0x83, 0x1F, 0x18,
  0xC7, 0x18, 0xA7, 0x1F, 0x3E, 0x47, 0xF1, 0x2C, 0xD3, 0x01, 0xF9, 0xC4, 0xBF, 0x19, 0xB8, 0xB3,
  0x89, 0x0E, 0x40, 0x1F, 0x1B, 0x85, 0xE2, 0x07, 0x0C, 0x28, 0x51, 0xF1, 0x99, 0x7C, 0x20, 0xE0,
  0x52, 0x85, 0x1F, 0x13, 0xEF, 0x50,
  // "ﬁ" (U+FB01)
  0x18, 0x96, 0x5E, 0xE4, 0xE4, 0x0D, 0xD7, 0x05, 0x10, 0xF9, 0x40, 0xAA, 0x8D, 0x4C, 0x3F, 0x66,
  0xFB, 0x53, 0xF6, 0x0F, 0x90, 0x3F, 0x60, 0xF9, 0x03, 0xF6, 0x0F, 0x90, 0x3F, 0x60, 0xF9, 0x03,
  0xF6, 0x0F, 0x90, 0x3F, 0x60,
  // "ﬂ" (U+FB02)
  0x18, 0xA3, 0x5E, 0xE5, 0xF5, 0x0D, 0xD7, 0x3F, 0x50, 0xF9, 0x03, 0xF5, 0xAA, 0x8D, 0x4C, 0x3F,
  0x56, 0xFB, 0x53, 0xF5, 0x0F, 0x90, 0x3F, 0x50, 0xF9, 0x03, 0xF5, 0x0F, 0x90, 0x3F, 0x50, 0xF9,
  0x03, 0xF5, 0x0F, 0x90, 0x3F, 0x50,
};

const Font& font_NotoSans_CondensedBold_12() {
  static SmoothFont font(font_NotoSans_CondensedBold_12_data);
  return font;
}

}  // namespace roo_display
