#include "8.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSans-BoldItalic (Noto Sans Bold Italic)
// Generated on Thu Mar 30 22:28:17 CEST 2023
static const uint8_t font_NotoSans_BoldItalic_8_data[] PROGMEM = {
  
  // Header
  0x01, 0x01, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x01, 0x7A,
  0xFE, 0xFE, 0x09, 0x09, 0x07, 0xFE, 0x03, 0x01, 0x0A, 0x03, 0x02, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x00, 0x01, 0x02, 0x06, 0x02, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x00, 0x04, 0x03, 0x06, 0x04, 0x00, 0x0A, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x05, 0x06, 0x05, 0x00, 0x12, // "#" (U+0023)
  0x00, 0x24, 0x00, 0x01, 0x04, 0x07, 0x04, 0x00, 0x25, // "$" (U+0024)
  0x00, 0x25, 0x00, 0x01, 0x06, 0x06, 0x07, 0x00, 0x39, // "%" (U+0025)
  0x00, 0x26, 0x00, 0x01, 0x05, 0x06, 0x06, 0x00, 0x50, // "&" (U+0026)
  0x00, 0x27, 0x00, 0x04, 0x01, 0x06, 0x02, 0x00, 0x65, // "'" (U+0027)
  0x00, 0x28, 0x00, 0xFF, 0x02, 0x06, 0x03, 0x00, 0x69, // "(" (U+0028)
  0x00, 0x29, 0xFF, 0xFF, 0x02, 0x06, 0x03, 0x00, 0x77, // ")" (U+0029)
  0x00, 0x2A, 0x00, 0x03, 0x04, 0x06, 0x04, 0x00, 0x89, // "*" (U+002A)
  0x00, 0x2B, 0x00, 0x02, 0x04, 0x05, 0x05, 0x00, 0x95, // "+" (U+002B)
  0x00, 0x2C, 0xFF, 0x00, 0x01, 0x02, 0x02, 0x00, 0xA1, // "," (U+002C)
  0x00, 0x2D, 0x00, 0x02, 0x02, 0x03, 0x03, 0x00, 0xA7, // "-" (U+002D)
  0x00, 0x2E, 0x00, 0x01, 0x01, 0x01, 0x02, 0x00, 0xAB, // "." (U+002E)
  0x00, 0x2F, 0xFF, 0x01, 0x03, 0x06, 0x03, 0x00, 0xAD, // "/" (U+002F)
  0x00, 0x30, 0x00, 0x01, 0x04, 0x06, 0x04, 0x00, 0xBE, // "0" (U+0030)
  0x00, 0x31, 0x00, 0x01, 0x03, 0x06, 0x04, 0x00, 0xCF, // "1" (U+0031)
  0x00, 0x32, 0xFF, 0x01, 0x04, 0x06, 0x04, 0x00, 0xDE, // "2" (U+0032)
  0x00, 0x33, 0x00, 0x01, 0x04, 0x06, 0x04, 0x00, 0xF1, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x01, 0x04, 0x06, 0x04, 0x01, 0x03, // "4" (U+0034)
  0x00, 0x35, 0x00, 0x01, 0x04, 0x06, 0x04, 0x01, 0x14, // "5" (U+0035)
  0x00, 0x36, 0x00, 0x01, 0x04, 0x06, 0x04, 0x01, 0x26, // "6" (U+0036)
  0x00, 0x37, 0x00, 0x01, 0x04, 0x06, 0x04, 0x01, 0x37, // "7" (U+0037)
  0x00, 0x38, 0x00, 0x01, 0x04, 0x06, 0x04, 0x01, 0x48, // "8" (U+0038)
  0x00, 0x39, 0x00, 0x01, 0x04, 0x06, 0x04, 0x01, 0x59, // "9" (U+0039)
  0x00, 0x3A, 0x00, 0x01, 0x02, 0x05, 0x02, 0x01, 0x6A, // ":" (U+003A)
  0x00, 0x3B, 0xFF, 0x00, 0x02, 0x05, 0x02, 0x01, 0x70, // ";" (U+003B)
  0x00, 0x3C, 0x00, 0x02, 0x04, 0x05, 0x05, 0x01, 0x7A, // "<" (U+003C)
  0x00, 0x3D, 0x00, 0x02, 0x04, 0x05, 0x05, 0x01, 0x85, // "=" (U+003D)
  0x00, 0x3E, 0x00, 0x02, 0x04, 0x05, 0x05, 0x01, 0x91, // ">" (U+003E)
  0x00, 0x3F, 0x00, 0x01, 0x03, 0x06, 0x04, 0x01, 0x9B, // "?" (U+003F)
  0x00, 0x40, 0x00, 0xFF, 0x06, 0x06, 0x07, 0x01, 0xA9, // "@" (U+0040)
  0x00, 0x41, 0xFF, 0x01, 0x04, 0x06, 0x05, 0x01, 0xC5, // "A" (U+0041)
  0x00, 0x42, 0x00, 0x01, 0x04, 0x06, 0x05, 0x01, 0xD8, // "B" (U+0042)
  0x00, 0x43, 0x00, 0x01, 0x04, 0x06, 0x05, 0x01, 0xE9, // "C" (U+0043)
  0x00, 0x44, 0x00, 0x01, 0x05, 0x06, 0x05, 0x01, 0xFA, // "D" (U+0044)
  0x00, 0x45, 0x00, 0x01, 0x04, 0x06, 0x04, 0x02, 0x0E, // "E" (U+0045)
  0x00, 0x46, 0x00, 0x01, 0x04, 0x06, 0x04, 0x02, 0x1F, // "F" (U+0046)
  0x00, 0x47, 0x00, 0x01, 0x05, 0x06, 0x06, 0x02, 0x2F, // "G" (U+0047)
  0x00, 0x48, 0x00, 0x01, 0x05, 0x06, 0x06, 0x02, 0x43, // "H" (U+0048)
  0x00, 0x49, 0xFF, 0x01, 0x03, 0x06, 0x03, 0x02, 0x57, // "I" (U+0049)
  0x00, 0x4A, 0xFE, 0xFE, 0x02, 0x06, 0x03, 0x02, 0x69, // "J" (U+004A)
  0x00, 0x4B, 0x00, 0x01, 0x05, 0x06, 0x05, 0x02, 0x7E, // "K" (U+004B)
  0x00, 0x4C, 0x00, 0x01, 0x03, 0x06, 0x04, 0x02, 0x93, // "L" (U+004C)
  0x00, 0x4D, 0x00, 0x01, 0x06, 0x06, 0x07, 0x02, 0xA1, // "M" (U+004D)
  0x00, 0x4E, 0x00, 0x01, 0x05, 0x06, 0x06, 0x02, 0xB8, // "N" (U+004E)
  0x00, 0x4F, 0x00, 0x01, 0x05, 0x06, 0x06, 0x02, 0xCC, // "O" (U+004F)
  0x00, 0x50, 0x00, 0x01, 0x04, 0x06, 0x05, 0x02, 0xE1, // "P" (U+0050)
  0x00, 0x51, 0x00, 0xFF, 0x05, 0x06, 0x06, 0x02, 0xF1, // "Q" (U+0051)
  0x00, 0x52, 0x00, 0x01, 0x04, 0x06, 0x05, 0x03, 0x0C, // "R" (U+0052)
  0x00, 0x53, 0x00, 0x01, 0x04, 0x06, 0x04, 0x03, 0x1E, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x04, 0x06, 0x04, 0x03, 0x2F, // "T" (U+0054)
  0x00, 0x55, 0x00, 0x01, 0x05, 0x06, 0x06, 0x03, 0x3F, // "U" (U+0055)
  0x00, 0x56, 0x00, 0x01, 0x05, 0x06, 0x05, 0x03, 0x52, // "V" (U+0056)
  0x00, 0x57, 0x00, 0x01, 0x07, 0x06, 0x07, 0x03, 0x65, // "W" (U+0057)
  0x00, 0x58, 0xFF, 0x01, 0x05, 0x06, 0x05, 0x03, 0x7F, // "X" (U+0058)
  0x00, 0x59, 0x00, 0x01, 0x04, 0x06, 0x05, 0x03, 0x95, // "Y" (U+0059)
  0x00, 0x5A, 0xFF, 0x01, 0x04, 0x06, 0x04, 0x03, 0xA6, // "Z" (U+005A)
  0x00, 0x5B, 0x00, 0xFE, 0x03, 0x06, 0x03, 0x03, 0xB9, // "[" (U+005B)
  0x00, 0x5C, 0x00, 0x01, 0x02, 0x06, 0x03, 0x03, 0xCE, // "\" (U+005C)
  0x00, 0x5D, 0xFF, 0xFE, 0x02, 0x06, 0x03, 0x03, 0xD9, // "]" (U+005D)
  0x00, 0x5E, 0x00, 0x03, 0x04, 0x06, 0x04, 0x03, 0xEE, // "^" (U+005E)
  0x00, 0x5F, 0xFF, 0xFF, 0x02, 0xFF, 0x03, 0x03, 0xFA, // "_" (U+005F)
  0x00, 0x60, 0x01, 0x06, 0x02, 0x07, 0x03, 0x03, 0xFD, // "`" (U+0060)
  0x00, 0x61, 0x00, 0x01, 0x04, 0x05, 0x05, 0x04, 0x00, // "a" (U+0061)
  0x00, 0x62, 0x00, 0x01, 0x04, 0x07, 0x05, 0x04, 0x0E, // "b" (U+0062)
  0x00, 0x63, 0x00, 0x01, 0x03, 0x05, 0x04, 0x04, 0x21, // "c" (U+0063)
  0x00, 0x64, 0x00, 0x01, 0x04, 0x07, 0x05, 0x04, 0x2D, // "d" (U+0064)
  0x00, 0x65, 0x00, 0x01, 0x04, 0x05, 0x04, 0x04, 0x3F, // "e" (U+0065)
  0x00, 0x66, 0xFF, 0xFF, 0x03, 0x07, 0x03, 0x04, 0x4E, // "f" (U+0066)
  0x00, 0x67, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x04, 0x67, // "g" (U+0067)
  0x00, 0x68, 0x00, 0x01, 0x04, 0x07, 0x05, 0x04, 0x7A, // "h" (U+0068)
  0x00, 0x69, 0x00, 0x01, 0x02, 0x07, 0x02, 0x04, 0x8D, // "i" (U+0069)
  0x00, 0x6A, 0xFF, 0xFF, 0x02, 0x07, 0x02, 0x04, 0x99, // "j" (U+006A)
  0x00, 0x6B, 0x00, 0x01, 0x04, 0x07, 0x05, 0x04, 0xAB, // "k" (U+006B)
  0x00, 0x6C, 0x00, 0x01, 0x02, 0x07, 0x02, 0x04, 0xBF, // "l" (U+006C)
  0x00, 0x6D, 0x00, 0x01, 0x06, 0x05, 0x07, 0x04, 0xCB, // "m" (U+006D)
  0x00, 0x6E, 0x00, 0x01, 0x04, 0x05, 0x05, 0x04, 0xDE, // "n" (U+006E)
  0x00, 0x6F, 0x00, 0x01, 0x04, 0x05, 0x05, 0x04, 0xEC, // "o" (U+006F)
  0x00, 0x70, 0xFF, 0xFF, 0x04, 0x05, 0x05, 0x04, 0xFA, // "p" (U+0070)
  0x00, 0x71, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x05, 0x0F, // "q" (U+0071)
  0x00, 0x72, 0x00, 0x01, 0x03, 0x05, 0x03, 0x05, 0x22, // "r" (U+0072)
  0x00, 0x73, 0x00, 0x01, 0x03, 0x05, 0x04, 0x05, 0x2D, // "s" (U+0073)
  0x00, 0x74, 0x00, 0x01, 0x03, 0x06, 0x03, 0x05, 0x39, // "t" (U+0074)
  0x00, 0x75, 0x00, 0x01, 0x04, 0x05, 0x05, 0x05, 0x47, // "u" (U+0075)
  0x00, 0x76, 0x00, 0x01, 0x04, 0x05, 0x04, 0x05, 0x55, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x01, 0x06, 0x05, 0x06, 0x05, 0x63, // "w" (U+0077)
  0x00, 0x78, 0xFF, 0x01, 0x04, 0x05, 0x04, 0x05, 0x76, // "x" (U+0078)
  0x00, 0x79, 0xFF, 0xFF, 0x04, 0x05, 0x04, 0x05, 0x87, // "y" (U+0079)
  0x00, 0x7A, 0xFF, 0x01, 0x03, 0x05, 0x04, 0x05, 0x9D, // "z" (U+007A)
  0x00, 0x7B, 0x00, 0xFE, 0x03, 0x06, 0x03, 0x05, 0xAB, // "{" (U+007B)
  0x00, 0x7C, 0x01, 0xFF, 0x02, 0x07, 0x04, 0x05, 0xBF, // "|" (U+007C)
  0x00, 0x7D, 0xFF, 0xFF, 0x02, 0x06, 0x03, 0x05, 0xCA, // "}" (U+007D)
  0x00, 0x7E, 0x00, 0x02, 0x04, 0x03, 0x05, 0x05, 0xDD, // "~" (U+007E)
  0x00, 0xA1, 0xFF, 0x00, 0x01, 0x05, 0x02, 0x05, 0xE3, // "¡" (U+00A1)
  0x00, 0xA2, 0x00, 0x01, 0x04, 0x06, 0x04, 0x05, 0xED, // "¢" (U+00A2)
  0x00, 0xA3, 0x00, 0x01, 0x04, 0x06, 0x04, 0x05, 0xFD, // "£" (U+00A3)
  0x00, 0xA4, 0x00, 0x01, 0x03, 0x06, 0x04, 0x06, 0x0F, // "¤" (U+00A4)
  0x00, 0xA5, 0x00, 0x01, 0x04, 0x06, 0x04, 0x06, 0x1C, // "¥" (U+00A5)
  0x00, 0xA6, 0x01, 0xFF, 0x02, 0x07, 0x04, 0x06, 0x2D, // "¦" (U+00A6)
  0x00, 0xA7, 0x00, 0x01, 0x03, 0x07, 0x04, 0x06, 0x38, // "§" (U+00A7)
  0x00, 0xA8, 0x01, 0x07, 0x04, 0x07, 0x04, 0x06, 0x48, // "¨" (U+00A8)
  0x00, 0xA9, 0x00, 0x01, 0x06, 0x07, 0x07, 0x06, 0x4B, // "©" (U+00A9)
  0x00, 0xAA, 0x00, 0x04, 0x03, 0x06, 0x03, 0x06, 0x66, // "ª" (U+00AA)
  0x00, 0xAB, 0x00, 0x01, 0x04, 0x04, 0x05, 0x06, 0x6E, // "«" (U+00AB)
  0x00, 0xAC, 0x00, 0x02, 0x04, 0x04, 0x05, 0x06, 0x7A, // "¬" (U+00AC)
  0x00, 0xAE, 0x00, 0x01, 0x06, 0x07, 0x07, 0x06, 0x83, // "®" (U+00AE)
  0x00, 0xAF, 0x00, 0x07, 0x04, 0x08, 0x04, 0x06, 0x9D, // "¯" (U+00AF)
  0x00, 0xB0, 0x00, 0x04, 0x02, 0x06, 0x03, 0x06, 0xA3, // "°" (U+00B0)
  0x00, 0xB1, 0x00, 0x01, 0x04, 0x05, 0x05, 0x06, 0xA9, // "±" (U+00B1)
  0x00, 0xB2, 0x00, 0x04, 0x03, 0x07, 0x03, 0x06, 0xB7, // "²" (U+00B2)
  0x00, 0xB3, 0x00, 0x04, 0x03, 0x07, 0x03, 0x06, 0xC1, // "³" (U+00B3)
  0x00, 0xB4, 0x01, 0x06, 0x02, 0x07, 0x03, 0x06, 0xCB, // "´" (U+00B4)
  0x00, 0xB5, 0xFF, 0xFF, 0x04, 0x05, 0x05, 0x06, 0xCE, // "µ" (U+00B5)
  0x00, 0xB6, 0x00, 0x00, 0x04, 0x07, 0x05, 0x06, 0xE3, // "¶" (U+00B6)
  0x00, 0xB7, 0x00, 0x03, 0x01, 0x03, 0x02, 0x06, 0xFB, // "·" (U+00B7)
  0x00, 0xB8, 0xFF, 0xFF, 0x00, 0x01, 0x02, 0x06, 0xFD, // "¸" (U+00B8)
  0x00, 0xB9, 0x01, 0x04, 0x02, 0x06, 0x03, 0x07, 0x01, // "¹" (U+00B9)
  0x00, 0xBA, 0x00, 0x04, 0x03, 0x06, 0x03, 0x07, 0x05, // "º" (U+00BA)
  0x00, 0xBB, 0x00, 0x01, 0x04, 0x04, 0x05, 0x07, 0x0D, // "»" (U+00BB)
  0x00, 0xBC, 0x01, 0x01, 0x06, 0x06, 0x07, 0x07, 0x19, // "¼" (U+00BC)
  0x00, 0xBD, 0x01, 0x01, 0x06, 0x06, 0x07, 0x07, 0x2C, // "½" (U+00BD)
  0x00, 0xBE, 0x00, 0x01, 0x06, 0x06, 0x07, 0x07, 0x3F, // "¾" (U+00BE)
  0x00, 0xBF, 0x00, 0xFF, 0x03, 0x04, 0x04, 0x07, 0x57, // "¿" (U+00BF)
  0x00, 0xC0, 0xFF, 0x01, 0x04, 0x08, 0x05, 0x07, 0x65, // "À" (U+00C0)
  0x00, 0xC1, 0xFF, 0x01, 0x04, 0x08, 0x05, 0x07, 0x7C, // "Á" (U+00C1)
  0x00, 0xC2, 0xFF, 0x01, 0x04, 0x08, 0x05, 0x07, 0x94, // "Â" (U+00C2)
  0x00, 0xC3, 0xFF, 0x01, 0x04, 0x07, 0x05, 0x07, 0xAD, // "Ã" (U+00C3)
  0x00, 0xC4, 0xFF, 0x01, 0x05, 0x08, 0x05, 0x07, 0xC3, // "Ä" (U+00C4)
  0x00, 0xC5, 0xFF, 0x01, 0x04, 0x08, 0x05, 0x07, 0xDC, // "Å" (U+00C5)
  0x00, 0xC6, 0xFF, 0x01, 0x07, 0x06, 0x07, 0x07, 0xF4, // "Æ" (U+00C6)
  0x00, 0xC7, 0x00, 0xFF, 0x04, 0x06, 0x05, 0x08, 0x0F, // "Ç" (U+00C7)
  0x00, 0xC8, 0x00, 0x01, 0x04, 0x08, 0x04, 0x08, 0x25, // "È" (U+00C8)
  0x00, 0xC9, 0x00, 0x01, 0x04, 0x08, 0x04, 0x08, 0x3A, // "É" (U+00C9)
  0x00, 0xCA, 0x00, 0x01, 0x04, 0x08, 0x04, 0x08, 0x4F, // "Ê" (U+00CA)
  0x00, 0xCB, 0x00, 0x01, 0x04, 0x08, 0x04, 0x08, 0x65, // "Ë" (U+00CB)
  0x00, 0xCC, 0xFF, 0x01, 0x03, 0x08, 0x03, 0x08, 0x79, // "Ì" (U+00CC)
  0x00, 0xCD, 0xFF, 0x01, 0x03, 0x08, 0x03, 0x08, 0x8F, // "Í" (U+00CD)
  0x00, 0xCE, 0xFF, 0x01, 0x03, 0x08, 0x03, 0x08, 0xA5, // "Î" (U+00CE)
  0x00, 0xCF, 0xFF, 0x01, 0x04, 0x08, 0x03, 0x08, 0xBC, // "Ï" (U+00CF)
  0x00, 0xD0, 0x00, 0x01, 0x05, 0x06, 0x05, 0x08, 0xD1, // "Ð" (U+00D0)
  0x00, 0xD1, 0x00, 0x01, 0x05, 0x07, 0x06, 0x08, 0xE5, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x00, 0x01, 0x05, 0x08, 0x06, 0x08, 0xFC, // "Ò" (U+00D2)
  0x00, 0xD3, 0x00, 0x01, 0x05, 0x08, 0x06, 0x09, 0x15, // "Ó" (U+00D3)
  0x00, 0xD4, 0x00, 0x01, 0x05, 0x08, 0x06, 0x09, 0x2F, // "Ô" (U+00D4)
  0x00, 0xD5, 0x00, 0x01, 0x05, 0x07, 0x06, 0x09, 0x4A, // "Õ" (U+00D5)
  0x00, 0xD6, 0x00, 0x01, 0x05, 0x08, 0x06, 0x09, 0x62, // "Ö" (U+00D6)
  0x00, 0xD7, 0x00, 0x02, 0x03, 0x05, 0x05, 0x09, 0x7B, // "×" (U+00D7)
  0x00, 0xD8, 0x00, 0x01, 0x05, 0x06, 0x06, 0x09, 0x85, // "Ø" (U+00D8)
  0x00, 0xD9, 0x00, 0x01, 0x05, 0x08, 0x06, 0x09, 0x99, // "Ù" (U+00D9)
  0x00, 0xDA, 0x00, 0x01, 0x05, 0x08, 0x06, 0x09, 0xB0, // "Ú" (U+00DA)
  0x00, 0xDB, 0x00, 0x01, 0x05, 0x08, 0x06, 0x09, 0xC8, // "Û" (U+00DB)
  0x00, 0xDC, 0x00, 0x01, 0x05, 0x08, 0x06, 0x09, 0xE1, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x01, 0x04, 0x08, 0x05, 0x09, 0xF8, // "Ý" (U+00DD)
  0x00, 0xDE, 0x00, 0x01, 0x04, 0x06, 0x05, 0x0A, 0x0E, // "Þ" (U+00DE)
  0x00, 0xDF, 0xFF, 0xFF, 0x04, 0x07, 0x05, 0x0A, 0x1F, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x3B, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x4D, // "á" (U+00E1)
  0x00, 0xE2, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x60, // "â" (U+00E2)
  0x00, 0xE3, 0x00, 0x01, 0x04, 0x06, 0x05, 0x0A, 0x74, // "ã" (U+00E3)
  0x00, 0xE4, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x84, // "ä" (U+00E4)
  0x00, 0xE5, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x96, // "å" (U+00E5)
  0x00, 0xE6, 0x00, 0x01, 0x06, 0x05, 0x07, 0x0A, 0xA9, // "æ" (U+00E6)
  0x00, 0xE7, 0x00, 0xFF, 0x03, 0x05, 0x04, 0x0A, 0xBC, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x01, 0x04, 0x07, 0x04, 0x0A, 0xCD, // "è" (U+00E8)
  0x00, 0xE9, 0x00, 0x01, 0x04, 0x07, 0x04, 0x0A, 0xE0, // "é" (U+00E9)
  0x00, 0xEA, 0x00, 0x01, 0x04, 0x07, 0x04, 0x0A, 0xF4, // "ê" (U+00EA)
  0x00, 0xEB, 0x00, 0x01, 0x04, 0x07, 0x04, 0x0B, 0x09, // "ë" (U+00EB)
  0x00, 0xEC, 0x00, 0x01, 0x02, 0x07, 0x02, 0x0B, 0x1C, // "ì" (U+00EC)
  0x00, 0xED, 0x00, 0x01, 0x02, 0x07, 0x02, 0x0B, 0x29, // "í" (U+00ED)
  0x00, 0xEE, 0x00, 0x01, 0x02, 0x07, 0x02, 0x0B, 0x35, // "î" (U+00EE)
  0x00, 0xEF, 0x00, 0x01, 0x03, 0x07, 0x02, 0x0B, 0x41, // "ï" (U+00EF)
  0x00, 0xF0, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0B, 0x50, // "ð" (U+00F0)
  0x00, 0xF1, 0x00, 0x01, 0x04, 0x06, 0x05, 0x0B, 0x66, // "ñ" (U+00F1)
  0x00, 0xF2, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0B, 0x76, // "ò" (U+00F2)
  0x00, 0xF3, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0B, 0x88, // "ó" (U+00F3)
  0x00, 0xF4, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0B, 0x9B, // "ô" (U+00F4)
  0x00, 0xF5, 0x00, 0x01, 0x04, 0x06, 0x05, 0x0B, 0xAF, // "õ" (U+00F5)
  0x00, 0xF6, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0B, 0xC0, // "ö" (U+00F6)
  0x00, 0xF7, 0x00, 0x02, 0x04, 0x05, 0x05, 0x0B, 0xD2, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x00, 0x04, 0x05, 0x05, 0x0B, 0xDE, // "ø" (U+00F8)
  0x00, 0xF9, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0B, 0xED, // "ù" (U+00F9)
  0x00, 0xFA, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0B, 0xFF, // "ú" (U+00FA)
  0x00, 0xFB, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0C, 0x12, // "û" (U+00FB)
  0x00, 0xFC, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0C, 0x26, // "ü" (U+00FC)
  0x00, 0xFD, 0xFF, 0xFF, 0x04, 0x07, 0x04, 0x0C, 0x38, // "ý" (U+00FD)
  0x00, 0xFE, 0xFF, 0xFF, 0x04, 0x07, 0x05, 0x0C, 0x53, // "þ" (U+00FE)
  0x00, 0xFF, 0xFF, 0xFF, 0x04, 0x07, 0x04, 0x0C, 0x6C, // "ÿ" (U+00FF)
  0x01, 0x00, 0xFF, 0x01, 0x04, 0x07, 0x05, 0x0C, 0x85, // "Ā" (U+0100)
  0x01, 0x01, 0x00, 0x01, 0x04, 0x06, 0x05, 0x0C, 0x9B, // "ā" (U+0101)
  0x01, 0x02, 0xFF, 0x01, 0x04, 0x09, 0x05, 0x0C, 0xAB, // "Ă" (U+0102)
  0x01, 0x03, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0C, 0xC5, // "ă" (U+0103)
  0x01, 0x04, 0xFF, 0xFF, 0x04, 0x06, 0x05, 0x0C, 0xDB, // "Ą" (U+0104)
  0x01, 0x05, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x0C, 0xF3, // "ą" (U+0105)
  0x01, 0x06, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0D, 0x07, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0D, 0x1C, // "ć" (U+0107)
  0x01, 0x08, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0D, 0x2C, // "Ĉ" (U+0108)
  0x01, 0x09, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0D, 0x42, // "ĉ" (U+0109)
  0x01, 0x0A, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0D, 0x52, // "Ċ" (U+010A)
  0x01, 0x0B, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0D, 0x66, // "ċ" (U+010B)
  0x01, 0x0C, 0x00, 0x01, 0x05, 0x08, 0x05, 0x0D, 0x74, // "Č" (U+010C)
  0x01, 0x0D, 0x00, 0x01, 0x04, 0x07, 0x04, 0x0D, 0x8C, // "č" (U+010D)
  0x01, 0x0E, 0x00, 0x01, 0x05, 0x08, 0x05, 0x0D, 0x9F, // "Ď" (U+010E)
  0x01, 0x0F, 0x00, 0x01, 0x06, 0x07, 0x05, 0x0D, 0xB8, // "ď" (U+010F)
  0x01, 0x10, 0x00, 0x01, 0x05, 0x06, 0x05, 0x0D, 0xD1, // "Đ" (U+0110)
  0x01, 0x11, 0x00, 0x01, 0x05, 0x07, 0x05, 0x0D, 0xE5, // "đ" (U+0111)
  0x01, 0x12, 0x00, 0x01, 0x04, 0x07, 0x04, 0x0D, 0xFB, // "Ē" (U+0112)
  0x01, 0x13, 0x00, 0x01, 0x04, 0x06, 0x04, 0x0E, 0x0E, // "ē" (U+0113)
  0x01, 0x14, 0x00, 0x01, 0x04, 0x09, 0x04, 0x0E, 0x1F, // "Ĕ" (U+0114)
  0x01, 0x15, 0x00, 0x01, 0x04, 0x08, 0x04, 0x0E, 0x37, // "ĕ" (U+0115)
  0x01, 0x16, 0x00, 0x01, 0x04, 0x08, 0x04, 0x0E, 0x4E, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x01, 0x04, 0x07, 0x04, 0x0E, 0x61, // "ė" (U+0117)
  0x01, 0x18, 0x00, 0xFF, 0x04, 0x06, 0x04, 0x0E, 0x73, // "Ę" (U+0118)
  0x01, 0x19, 0x00, 0xFF, 0x04, 0x05, 0x04, 0x0E, 0x89, // "ę" (U+0119)
  0x01, 0x1A, 0x00, 0x01, 0x05, 0x08, 0x04, 0x0E, 0x9E, // "Ě" (U+011A)
  0x01, 0x1B, 0x00, 0x01, 0x04, 0x07, 0x04, 0x0E, 0xB7, // "ě" (U+011B)
  0x01, 0x1C, 0x00, 0x01, 0x05, 0x08, 0x06, 0x0E, 0xCB, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0E, 0xE5, // "ĝ" (U+011D)
  0x01, 0x1E, 0x00, 0x01, 0x05, 0x09, 0x06, 0x0E, 0xFE, // "Ğ" (U+011E)
  0x01, 0x1F, 0x00, 0xFF, 0x04, 0x08, 0x05, 0x0F, 0x1A, // "ğ" (U+011F)
  0x01, 0x20, 0x00, 0x01, 0x05, 0x08, 0x06, 0x0F, 0x35, // "Ġ" (U+0120)
  0x01, 0x21, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0F, 0x4C, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0xFE, 0x05, 0x06, 0x06, 0x0F, 0x62, // "Ģ" (U+0122)
  0x01, 0x23, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0F, 0x7B, // "ģ" (U+0123)
  0x01, 0x24, 0x00, 0x01, 0x05, 0x08, 0x06, 0x0F, 0x91, // "Ĥ" (U+0124)
  0x01, 0x25, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0F, 0xAB, // "ĥ" (U+0125)
  0x01, 0x26, 0x00, 0x01, 0x06, 0x06, 0x06, 0x0F, 0xC4, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0F, 0xDC, // "ħ" (U+0127)
  0x01, 0x28, 0xFF, 0x01, 0x03, 0x07, 0x03, 0x0F, 0xF0, // "Ĩ" (U+0128)
  0x01, 0x29, 0x00, 0x01, 0x02, 0x06, 0x02, 0x10, 0x04, // "ĩ" (U+0129)
  0x01, 0x2A, 0xFF, 0x01, 0x03, 0x07, 0x03, 0x10, 0x0F, // "Ī" (U+012A)
  0x01, 0x2B, 0x00, 0x01, 0x03, 0x06, 0x02, 0x10, 0x23, // "ī" (U+012B)
  0x01, 0x2C, 0xFF, 0x01, 0x03, 0x09, 0x03, 0x10, 0x31, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x00, 0x01, 0x02, 0x08, 0x02, 0x10, 0x4A, // "ĭ" (U+012D)
  0x01, 0x2E, 0xFF, 0xFF, 0x03, 0x06, 0x03, 0x10, 0x58, // "Į" (U+012E)
  0x01, 0x2F, 0xFF, 0xFF, 0x02, 0x07, 0x02, 0x10, 0x6F, // "į" (U+012F)
  0x01, 0x30, 0xFF, 0x01, 0x03, 0x08, 0x03, 0x10, 0x82, // "İ" (U+0130)
  0x01, 0x31, 0x00, 0x01, 0x02, 0x05, 0x02, 0x10, 0x96, // "ı" (U+0131)
  0x01, 0x32, 0xFF, 0xFE, 0x05, 0x06, 0x06, 0x10, 0x9F, // "Ĳ" (U+0132)
  0x01, 0x33, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x10, 0xBF, // "ĳ" (U+0133)
  0x01, 0x34, 0xFE, 0xFE, 0x03, 0x08, 0x03, 0x10, 0xD6, // "Ĵ" (U+0134)
  0x01, 0x35, 0xFF, 0xFF, 0x02, 0x07, 0x02, 0x10, 0xF2, // "ĵ" (U+0135)
  0x01, 0x36, 0x00, 0xFE, 0x05, 0x06, 0x05, 0x11, 0x06, // "Ķ" (U+0136)
  0x01, 0x37, 0x00, 0xFE, 0x04, 0x07, 0x05, 0x11, 0x20, // "ķ" (U+0137)
  0x01, 0x38, 0x00, 0x01, 0x04, 0x05, 0x05, 0x11, 0x38, // "ĸ" (U+0138)
  0x01, 0x39, 0x00, 0x01, 0x03, 0x08, 0x04, 0x11, 0x47, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x00, 0x01, 0x03, 0x09, 0x02, 0x11, 0x59, // "ĺ" (U+013A)
  0x01, 0x3B, 0x00, 0xFE, 0x03, 0x06, 0x04, 0x11, 0x6E, // "Ļ" (U+013B)
  0x01, 0x3C, 0xFF, 0xFE, 0x02, 0x07, 0x02, 0x11, 0x81, // "ļ" (U+013C)
  0x01, 0x3D, 0x00, 0x01, 0x04, 0x06, 0x04, 0x11, 0x96, // "Ľ" (U+013D)
  0x01, 0x3E, 0x00, 0x01, 0x03, 0x07, 0x03, 0x11, 0xA7, // "ľ" (U+013E)
  0x01, 0x3F, 0x00, 0x01, 0x04, 0x06, 0x04, 0x11, 0xB7, // "Ŀ" (U+013F)
  0x01, 0x40, 0x00, 0x01, 0x03, 0x07, 0x03, 0x11, 0xC8, // "ŀ" (U+0140)
  0x01, 0x41, 0x00, 0x01, 0x03, 0x06, 0x04, 0x11, 0xD8, // "Ł" (U+0141)
  0x01, 0x42, 0x00, 0x01, 0x02, 0x07, 0x03, 0x11, 0xE6, // "ł" (U+0142)
  0x01, 0x43, 0x00, 0x01, 0x05, 0x08, 0x06, 0x11, 0xF2, // "Ń" (U+0143)
  0x01, 0x44, 0x00, 0x01, 0x04, 0x07, 0x05, 0x12, 0x0B, // "ń" (U+0144)
  0x01, 0x45, 0x00, 0xFE, 0x05, 0x06, 0x06, 0x12, 0x1E, // "Ņ" (U+0145)
  0x01, 0x46, 0x00, 0xFE, 0x04, 0x05, 0x05, 0x12, 0x36, // "ņ" (U+0146)
  0x01, 0x47, 0x00, 0x01, 0x05, 0x08, 0x06, 0x12, 0x48, // "Ň" (U+0147)
  0x01, 0x48, 0x00, 0x01, 0x04, 0x07, 0x05, 0x12, 0x61, // "ň" (U+0148)
  0x01, 0x49, 0x00, 0x01, 0x05, 0x06, 0x06, 0x12, 0x74, // "ŉ" (U+0149)
  0x01, 0x4A, 0x00, 0xFE, 0x05, 0x06, 0x06, 0x12, 0x88, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x12, 0xA3, // "ŋ" (U+014B)
  0x01, 0x4C, 0x00, 0x01, 0x05, 0x07, 0x06, 0x12, 0xB7, // "Ō" (U+014C)
  0x01, 0x4D, 0x00, 0x01, 0x04, 0x06, 0x05, 0x12, 0xCE, // "ō" (U+014D)
  0x01, 0x4E, 0x00, 0x01, 0x05, 0x09, 0x06, 0x12, 0xDE, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x00, 0x01, 0x04, 0x08, 0x05, 0x12, 0xFB, // "ŏ" (U+014F)
  0x01, 0x50, 0x00, 0x01, 0x06, 0x08, 0x06, 0x13, 0x11, // "Ő" (U+0150)
  0x01, 0x51, 0x00, 0x01, 0x05, 0x07, 0x05, 0x13, 0x2E, // "ő" (U+0151)
  0x01, 0x52, 0x00, 0x01, 0x07, 0x06, 0x07, 0x13, 0x45, // "Œ" (U+0152)
  0x01, 0x53, 0x00, 0x01, 0x06, 0x05, 0x07, 0x13, 0x5D, // "œ" (U+0153)
  0x01, 0x54, 0x00, 0x01, 0x04, 0x08, 0x05, 0x13, 0x71, // "Ŕ" (U+0154)
  0x01, 0x55, 0x00, 0x01, 0x03, 0x07, 0x03, 0x13, 0x87, // "ŕ" (U+0155)
  0x01, 0x56, 0x00, 0xFE, 0x04, 0x06, 0x05, 0x13, 0x97, // "Ŗ" (U+0156)
  0x01, 0x57, 0xFF, 0xFE, 0x03, 0x05, 0x03, 0x13, 0xAD, // "ŗ" (U+0157)
  0x01, 0x58, 0x00, 0x01, 0x05, 0x08, 0x05, 0x13, 0xBE, // "Ř" (U+0158)
  0x01, 0x59, 0x00, 0x01, 0x04, 0x07, 0x03, 0x13, 0xD8, // "ř" (U+0159)
  0x01, 0x5A, 0x00, 0x01, 0x04, 0x08, 0x04, 0x13, 0xEA, // "Ś" (U+015A)
  0x01, 0x5B, 0x00, 0x01, 0x03, 0x07, 0x04, 0x14, 0x00, // "ś" (U+015B)
  0x01, 0x5C, 0x00, 0x01, 0x04, 0x08, 0x04, 0x14, 0x10, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x00, 0x01, 0x03, 0x07, 0x04, 0x14, 0x27, // "ŝ" (U+015D)
  0x01, 0x5E, 0x00, 0xFF, 0x04, 0x06, 0x04, 0x14, 0x37, // "Ş" (U+015E)
  0x01, 0x5F, 0x00, 0xFF, 0x03, 0x05, 0x04, 0x14, 0x4C, // "ş" (U+015F)
  0x01, 0x60, 0x00, 0x01, 0x04, 0x08, 0x04, 0x14, 0x5C, // "Š" (U+0160)
  0x01, 0x61, 0x00, 0x01, 0x04, 0x07, 0x04, 0x14, 0x72, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFF, 0x04, 0x06, 0x04, 0x14, 0x86, // "Ţ" (U+0162)
  0x01, 0x63, 0x00, 0xFF, 0x03, 0x06, 0x03, 0x14, 0x9B, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x04, 0x08, 0x04, 0x14, 0xAE, // "Ť" (U+0164)
  0x01, 0x65, 0x00, 0x01, 0x04, 0x07, 0x03, 0x14, 0xC3, // "ť" (U+0165)
  0x01, 0x66, 0x00, 0x01, 0x04, 0x06, 0x04, 0x14, 0xD6, // "Ŧ" (U+0166)
  0x01, 0x67, 0x00, 0x01, 0x03, 0x06, 0x03, 0x14, 0xE7, // "ŧ" (U+0167)
  0x01, 0x68, 0x00, 0x01, 0x05, 0x07, 0x06, 0x14, 0xF5, // "Ũ" (U+0168)
  0x01, 0x69, 0x00, 0x01, 0x04, 0x06, 0x05, 0x15, 0x0B, // "ũ" (U+0169)
  0x01, 0x6A, 0x00, 0x01, 0x05, 0x07, 0x06, 0x15, 0x1B, // "Ū" (U+016A)
  0x01, 0x6B, 0x00, 0x01, 0x04, 0x06, 0x05, 0x15, 0x31, // "ū" (U+016B)
  0x01, 0x6C, 0x00, 0x01, 0x05, 0x09, 0x06, 0x15, 0x41, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x00, 0x01, 0x04, 0x08, 0x05, 0x15, 0x5C, // "ŭ" (U+016D)
  0x01, 0x6E, 0x00, 0x01, 0x05, 0x08, 0x06, 0x15, 0x72, // "Ů" (U+016E)
  0x01, 0x6F, 0x00, 0x01, 0x04, 0x07, 0x05, 0x15, 0x8A, // "ů" (U+016F)
  0x01, 0x70, 0x00, 0x01, 0x05, 0x08, 0x06, 0x15, 0x9D, // "Ű" (U+0170)
  0x01, 0x71, 0x00, 0x01, 0x05, 0x07, 0x05, 0x15, 0xB6, // "ű" (U+0171)
  0x01, 0x72, 0x00, 0xFF, 0x05, 0x06, 0x06, 0x15, 0xCD, // "Ų" (U+0172)
  0x01, 0x73, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x15, 0xE6, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x07, 0x08, 0x07, 0x15, 0xFA, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x06, 0x07, 0x06, 0x16, 0x1A, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x01, 0x04, 0x08, 0x05, 0x16, 0x33, // "Ŷ" (U+0176)
  0x01, 0x77, 0xFF, 0xFF, 0x04, 0x07, 0x04, 0x16, 0x4A, // "ŷ" (U+0177)
  0x01, 0x78, 0x00, 0x01, 0x04, 0x08, 0x05, 0x16, 0x66, // "Ÿ" (U+0178)
  0x01, 0x79, 0xFF, 0x01, 0x04, 0x08, 0x04, 0x16, 0x7B, // "Ź" (U+0179)
  0x01, 0x7A, 0xFF, 0x01, 0x03, 0x07, 0x04, 0x16, 0x93, // "ź" (U+017A)
  0x01, 0x7B, 0xFF, 0x01, 0x04, 0x08, 0x04, 0x16, 0xA5, // "Ż" (U+017B)
  0x01, 0x7C, 0xFF, 0x01, 0x03, 0x07, 0x04, 0x16, 0xBB, // "ż" (U+017C)
  0x01, 0x7D, 0xFF, 0x01, 0x05, 0x08, 0x04, 0x16, 0xCB, // "Ž" (U+017D)
  0x01, 0x7E, 0xFF, 0x01, 0x04, 0x07, 0x04, 0x16, 0xE3, // "ž" (U+017E)
  0x01, 0x7F, 0xFF, 0xFF, 0x03, 0x07, 0x03, 0x16, 0xF6, // "ſ" (U+017F)
  0x03, 0xA9, 0xFF, 0x01, 0x05, 0x06, 0x06, 0x17, 0x0E, // "Ω" (U+03A9)
  0x03, 0xBC, 0xFF, 0xFF, 0x04, 0x05, 0x05, 0x17, 0x26, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x01, 0x05, 0x05, 0x06, 0x17, 0x3B, // "π" (U+03C0)
  0x20, 0x13, 0x00, 0x02, 0x03, 0x03, 0x04, 0x17, 0x4B, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x02, 0x07, 0x03, 0x08, 0x17, 0x50, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x01, 0x04, 0x06, 0x04, 0x17, 0x57, // "€" (U+20AC)
  0x20, 0xBF, 0x00, 0x00, 0x04, 0x07, 0x04, 0x17, 0x69, // "₿" (U+20BF)
  0x20, 0x18, 0x00, 0x04, 0x02, 0x06, 0x02, 0x17, 0x7F, // "‘" (U+2018)
  0x20, 0x19, 0x00, 0x04, 0x02, 0x06, 0x02, 0x17, 0x85, // "’" (U+2019)
  0x20, 0x1A, 0xFF, 0x00, 0x01, 0x02, 0x02, 0x17, 0x8A, // "‚" (U+201A)
  0x20, 0x1B, 0x00, 0x04, 0x01, 0x06, 0x02, 0x17, 0x90, // "‛" (U+201B)
  0x20, 0x1C, 0x00, 0x04, 0x03, 0x06, 0x03, 0x17, 0x94, // "“" (U+201C)
  0x20, 0x1D, 0x00, 0x04, 0x03, 0x06, 0x03, 0x17, 0x9B, // "”" (U+201D)
  0x20, 0x1E, 0xFF, 0x00, 0x02, 0x02, 0x04, 0x17, 0xA3, // "„" (U+201E)
  0x20, 0x1F, 0x00, 0x04, 0x03, 0x06, 0x03, 0x17, 0xAB, // "‟" (U+201F)
  0x20, 0x20, 0x00, 0x01, 0x03, 0x07, 0x04, 0x17, 0xB3, // "†" (U+2020)
  0x20, 0x21, 0x00, 0x01, 0x03, 0x07, 0x04, 0x17, 0xC4, // "‡" (U+2021)
  0x20, 0x22, 0x00, 0x03, 0x02, 0x05, 0x03, 0x17, 0xD3, // "•" (U+2022)
  0x20, 0x26, 0x00, 0x01, 0x05, 0x01, 0x07, 0x17, 0xD9, // "…" (U+2026)
  0x20, 0x30, 0x00, 0x01, 0x09, 0x06, 0x0A, 0x17, 0xDD, // "‰" (U+2030)
  0x20, 0x39, 0x00, 0x01, 0x02, 0x04, 0x03, 0x17, 0xFC, // "‹" (U+2039)
  0x20, 0x3A, 0x00, 0x01, 0x02, 0x04, 0x03, 0x18, 0x03, // "›" (U+203A)
  0x20, 0x44, 0xFE, 0x01, 0x02, 0x06, 0x01, 0x18, 0x0A, // "⁄" (U+2044)
  0x21, 0x22, 0x00, 0x03, 0x05, 0x06, 0x06, 0x18, 0x1A, // "™" (U+2122)
  0x21, 0x52, 0x01, 0x01, 0x09, 0x06, 0x0A, 0x18, 0x28, // "⅒" (U+2152)
  0xFB, 0x01, 0xFF, 0xFF, 0x05, 0x07, 0x05, 0x18, 0x43, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0xFF, 0xFF, 0x05, 0x07, 0x05, 0x18, 0x63, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x01, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0xC0, 0x01, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x01, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x01, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x01, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x01, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x01, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x01, 0x00, 0x01, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x02, 0x01, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x04, 0x01, // "Ą (U+0022 U+0104)
  0x00, 0x27, 0x00, 0x41, 0x01, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0xC0, 0x01, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x01, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x01, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x01, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x01, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x01, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x01, 0x00, 0x01, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x02, 0x01, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x04, 0x01, // 'Ą (U+0027 U+0104)
  0x00, 0x2C, 0x00, 0x54, 0x01, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x01, 0x62, 0x01, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x01, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x01, // ,Ŧ (U+002C U+0166)
  0x00, 0x2E, 0x00, 0x54, 0x01, // .T (U+002E U+0054)
  0x00, 0x2E, 0x01, 0x62, 0x01, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x01, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x01, // .Ŧ (U+002E U+0166)
  0x00, 0x30, 0x20, 0x44, 0x01, // 0⁄ (U+0030 U+2044)
  0x00, 0x31, 0x20, 0x44, 0x01, // 1⁄ (U+0031 U+2044)
  0x00, 0x32, 0x20, 0x44, 0x01, // 2⁄ (U+0032 U+2044)
  0x00, 0x33, 0x20, 0x44, 0x01, // 3⁄ (U+0033 U+2044)
  0x00, 0x34, 0x20, 0x44, 0x01, // 4⁄ (U+0034 U+2044)
  0x00, 0x35, 0x20, 0x44, 0x01, // 5⁄ (U+0035 U+2044)
  0x00, 0x36, 0x20, 0x44, 0x01, // 6⁄ (U+0036 U+2044)
  0x00, 0x37, 0x20, 0x44, 0x01, // 7⁄ (U+0037 U+2044)
  0x00, 0x38, 0x20, 0x44, 0x01, // 8⁄ (U+0038 U+2044)
  0x00, 0x39, 0x20, 0x44, 0x01, // 9⁄ (U+0039 U+2044)
  0x00, 0x41, 0x00, 0x22, 0x01, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x01, // A' (U+0041 U+0027)
  0x00, 0x41, 0x20, 0x19, 0x01, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1D, 0x01, // A” (U+0041 U+201D)
  0x00, 0x4C, 0x00, 0x22, 0x01, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x01, // L' (U+004C U+0027)
  0x00, 0x4C, 0x20, 0x19, 0x01, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1D, 0x01, // L” (U+004C U+201D)
  0x00, 0x50, 0x00, 0x2C, 0x01, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x01, // P. (U+0050 U+002E)
  0x00, 0x50, 0x20, 0x1A, 0x01, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x01, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x01, // P… (U+0050 U+2026)
  0x00, 0x54, 0x00, 0x61, 0x01, // Ta (U+0054 U+0061)
  0x00, 0x54, 0x00, 0x63, 0x01, // Tc (U+0054 U+0063)
  0x00, 0x54, 0x00, 0x64, 0x01, // Td (U+0054 U+0064)
  0x00, 0x54, 0x00, 0x65, 0x01, // Te (U+0054 U+0065)
  0x00, 0x54, 0x00, 0x67, 0x01, // Tg (U+0054 U+0067)
  0x00, 0x54, 0x00, 0x6F, 0x01, // To (U+0054 U+006F)
  0x00, 0x54, 0x00, 0x71, 0x01, // Tq (U+0054 U+0071)
  0x00, 0x54, 0x00, 0xE0, 0x01, // Tà (U+0054 U+00E0)
  0x00, 0x54, 0x00, 0xE1, 0x01, // Tá (U+0054 U+00E1)
  0x00, 0x54, 0x00, 0xE2, 0x01, // Tâ (U+0054 U+00E2)
  0x00, 0x54, 0x00, 0xE3, 0x01, // Tã (U+0054 U+00E3)
  0x00, 0x54, 0x00, 0xE4, 0x01, // Tä (U+0054 U+00E4)
  0x00, 0x54, 0x00, 0xE5, 0x01, // Tå (U+0054 U+00E5)
  0x00, 0x54, 0x00, 0xE6, 0x01, // Tæ (U+0054 U+00E6)
  0x00, 0x54, 0x00, 0xE7, 0x01, // Tç (U+0054 U+00E7)
  0x00, 0x54, 0x00, 0xE8, 0x01, // Tè (U+0054 U+00E8)
  0x00, 0x54, 0x00, 0xE9, 0x01, // Té (U+0054 U+00E9)
  0x00, 0x54, 0x00, 0xEA, 0x01, // Tê (U+0054 U+00EA)
  0x00, 0x54, 0x00, 0xEB, 0x01, // Të (U+0054 U+00EB)
  0x00, 0x54, 0x00, 0xF2, 0x01, // Tò (U+0054 U+00F2)
  0x00, 0x54, 0x00, 0xF3, 0x01, // Tó (U+0054 U+00F3)
  0x00, 0x54, 0x00, 0xF4, 0x01, // Tô (U+0054 U+00F4)
  0x00, 0x54, 0x00, 0xF5, 0x01, // Tõ (U+0054 U+00F5)
  0x00, 0x54, 0x00, 0xF6, 0x01, // Tö (U+0054 U+00F6)
  0x00, 0x54, 0x00, 0xF8, 0x01, // Tø (U+0054 U+00F8)
  0x00, 0x54, 0x01, 0x01, 0x01, // Tā (U+0054 U+0101)
  0x00, 0x54, 0x01, 0x03, 0x01, // Tă (U+0054 U+0103)
  0x00, 0x54, 0x01, 0x05, 0x01, // Tą (U+0054 U+0105)
  0x00, 0x54, 0x01, 0x07, 0x01, // Tć (U+0054 U+0107)
  0x00, 0x54, 0x01, 0x09, 0x01, // Tĉ (U+0054 U+0109)
  0x00, 0x54, 0x01, 0x0B, 0x01, // Tċ (U+0054 U+010B)
  0x00, 0x54, 0x01, 0x0D, 0x01, // Tč (U+0054 U+010D)
  0x00, 0x54, 0x01, 0x0F, 0x01, // Tď (U+0054 U+010F)
  0x00, 0x54, 0x01, 0x11, 0x01, // Tđ (U+0054 U+0111)
  0x00, 0x54, 0x01, 0x13, 0x01, // Tē (U+0054 U+0113)
  0x00, 0x54, 0x01, 0x15, 0x01, // Tĕ (U+0054 U+0115)
  0x00, 0x54, 0x01, 0x17, 0x01, // Tė (U+0054 U+0117)
  0x00, 0x54, 0x01, 0x19, 0x01, // Tę (U+0054 U+0119)
  0x00, 0x54, 0x01, 0x1B, 0x01, // Tě (U+0054 U+011B)
  0x00, 0x54, 0x01, 0x1D, 0x01, // Tĝ (U+0054 U+011D)
  0x00, 0x54, 0x01, 0x1F, 0x01, // Tğ (U+0054 U+011F)
  0x00, 0x54, 0x01, 0x21, 0x01, // Tġ (U+0054 U+0121)
  0x00, 0x54, 0x01, 0x23, 0x01, // Tģ (U+0054 U+0123)
  0x00, 0x54, 0x01, 0x4D, 0x01, // Tō (U+0054 U+014D)
  0x00, 0x54, 0x01, 0x4F, 0x01, // Tŏ (U+0054 U+014F)
  0x00, 0x54, 0x01, 0x51, 0x01, // Tő (U+0054 U+0151)
  0x00, 0x54, 0x01, 0x53, 0x01, // Tœ (U+0054 U+0153)
  0x00, 0x72, 0x00, 0x2C, 0x01, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x01, // r. (U+0072 U+002E)
  0x00, 0x72, 0x20, 0x1A, 0x01, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x01, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x01, // r… (U+0072 U+2026)
  0x00, 0xC0, 0x00, 0x22, 0x01, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x01, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x20, 0x19, 0x01, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1D, 0x01, // À” (U+00C0 U+201D)
  0x00, 0xC1, 0x00, 0x22, 0x01, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x01, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x20, 0x19, 0x01, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1D, 0x01, // Á” (U+00C1 U+201D)
  0x00, 0xC2, 0x00, 0x22, 0x01, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x01, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x20, 0x19, 0x01, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1D, 0x01, // Â” (U+00C2 U+201D)
  0x00, 0xC3, 0x00, 0x22, 0x01, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x01, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x20, 0x19, 0x01, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1D, 0x01, // Ã” (U+00C3 U+201D)
  0x00, 0xC4, 0x00, 0x22, 0x01, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x01, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x20, 0x19, 0x01, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1D, 0x01, // Ä” (U+00C4 U+201D)
  0x00, 0xC5, 0x00, 0x22, 0x01, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x01, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x20, 0x19, 0x01, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1D, 0x01, // Å” (U+00C5 U+201D)
  0x00, 0xDE, 0x00, 0x2C, 0x01, // Þ, (U+00DE U+002C)
  0x00, 0xDE, 0x00, 0x2E, 0x01, // Þ. (U+00DE U+002E)
  0x00, 0xDE, 0x20, 0x1A, 0x01, // Þ‚ (U+00DE U+201A)
  0x00, 0xDE, 0x20, 0x1E, 0x01, // Þ„ (U+00DE U+201E)
  0x00, 0xDE, 0x20, 0x26, 0x01, // Þ… (U+00DE U+2026)
  0x01, 0x00, 0x00, 0x22, 0x01, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x01, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x20, 0x19, 0x01, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1D, 0x01, // Ā” (U+0100 U+201D)
  0x01, 0x02, 0x00, 0x22, 0x01, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x01, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x20, 0x19, 0x01, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1D, 0x01, // Ă” (U+0102 U+201D)
  0x01, 0x04, 0x00, 0x22, 0x01, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x01, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x20, 0x19, 0x01, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1D, 0x01, // Ą” (U+0104 U+201D)
  0x01, 0x39, 0x00, 0x22, 0x01, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x01, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x20, 0x19, 0x01, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1D, 0x01, // Ĺ” (U+0139 U+201D)
  0x01, 0x3B, 0x00, 0x22, 0x01, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x01, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x20, 0x19, 0x01, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1D, 0x01, // Ļ” (U+013B U+201D)
  0x01, 0x3D, 0x00, 0x22, 0x01, // Ľ" (U+013D U+0022)
  0x01, 0x3D, 0x00, 0x27, 0x01, // Ľ' (U+013D U+0027)
  0x01, 0x3D, 0x20, 0x19, 0x01, // Ľ’ (U+013D U+2019)
  0x01, 0x3D, 0x20, 0x1D, 0x01, // Ľ” (U+013D U+201D)
  0x01, 0x3F, 0x00, 0x22, 0x01, // Ŀ" (U+013F U+0022)
  0x01, 0x3F, 0x00, 0x27, 0x01, // Ŀ' (U+013F U+0027)
  0x01, 0x3F, 0x20, 0x19, 0x01, // Ŀ’ (U+013F U+2019)
  0x01, 0x3F, 0x20, 0x1D, 0x01, // Ŀ” (U+013F U+201D)
  0x01, 0x41, 0x00, 0x22, 0x01, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x01, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x20, 0x19, 0x01, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1D, 0x01, // Ł” (U+0141 U+201D)
  0x01, 0x55, 0x00, 0x2C, 0x01, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x01, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x20, 0x1A, 0x01, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x01, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x01, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x01, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x01, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x20, 0x1A, 0x01, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x01, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x01, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x01, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x01, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x20, 0x1A, 0x01, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x01, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x01, // ř… (U+0159 U+2026)
  0x01, 0x62, 0x00, 0x61, 0x01, // Ţa (U+0162 U+0061)
  0x01, 0x62, 0x00, 0x63, 0x01, // Ţc (U+0162 U+0063)
  0x01, 0x62, 0x00, 0x64, 0x01, // Ţd (U+0162 U+0064)
  0x01, 0x62, 0x00, 0x65, 0x01, // Ţe (U+0162 U+0065)
  0x01, 0x62, 0x00, 0x67, 0x01, // Ţg (U+0162 U+0067)
  0x01, 0x62, 0x00, 0x6F, 0x01, // Ţo (U+0162 U+006F)
  0x01, 0x62, 0x00, 0x71, 0x01, // Ţq (U+0162 U+0071)
  0x01, 0x62, 0x00, 0xE0, 0x01, // Ţà (U+0162 U+00E0)
  0x01, 0x62, 0x00, 0xE1, 0x01, // Ţá (U+0162 U+00E1)
  0x01, 0x62, 0x00, 0xE2, 0x01, // Ţâ (U+0162 U+00E2)
  0x01, 0x62, 0x00, 0xE3, 0x01, // Ţã (U+0162 U+00E3)
  0x01, 0x62, 0x00, 0xE4, 0x01, // Ţä (U+0162 U+00E4)
  0x01, 0x62, 0x00, 0xE5, 0x01, // Ţå (U+0162 U+00E5)
  0x01, 0x62, 0x00, 0xE6, 0x01, // Ţæ (U+0162 U+00E6)
  0x01, 0x62, 0x00, 0xE7, 0x01, // Ţç (U+0162 U+00E7)
  0x01, 0x62, 0x00, 0xE8, 0x01, // Ţè (U+0162 U+00E8)
  0x01, 0x62, 0x00, 0xE9, 0x01, // Ţé (U+0162 U+00E9)
  0x01, 0x62, 0x00, 0xEA, 0x01, // Ţê (U+0162 U+00EA)
  0x01, 0x62, 0x00, 0xEB, 0x01, // Ţë (U+0162 U+00EB)
  0x01, 0x62, 0x00, 0xF2, 0x01, // Ţò (U+0162 U+00F2)
  0x01, 0x62, 0x00, 0xF3, 0x01, // Ţó (U+0162 U+00F3)
  0x01, 0x62, 0x00, 0xF4, 0x01, // Ţô (U+0162 U+00F4)
  0x01, 0x62, 0x00, 0xF5, 0x01, // Ţõ (U+0162 U+00F5)
  0x01, 0x62, 0x00, 0xF6, 0x01, // Ţö (U+0162 U+00F6)
  0x01, 0x62, 0x00, 0xF8, 0x01, // Ţø (U+0162 U+00F8)
  0x01, 0x62, 0x01, 0x01, 0x01, // Ţā (U+0162 U+0101)
  0x01, 0x62, 0x01, 0x03, 0x01, // Ţă (U+0162 U+0103)
  0x01, 0x62, 0x01, 0x05, 0x01, // Ţą (U+0162 U+0105)
  0x01, 0x62, 0x01, 0x07, 0x01, // Ţć (U+0162 U+0107)
  0x01, 0x62, 0x01, 0x09, 0x01, // Ţĉ (U+0162 U+0109)
  0x01, 0x62, 0x01, 0x0B, 0x01, // Ţċ (U+0162 U+010B)
  0x01, 0x62, 0x01, 0x0D, 0x01, // Ţč (U+0162 U+010D)
  0x01, 0x62, 0x01, 0x0F, 0x01, // Ţď (U+0162 U+010F)
  0x01, 0x62, 0x01, 0x11, 0x01, // Ţđ (U+0162 U+0111)
  0x01, 0x62, 0x01, 0x13, 0x01, // Ţē (U+0162 U+0113)
  0x01, 0x62, 0x01, 0x15, 0x01, // Ţĕ (U+0162 U+0115)
  0x01, 0x62, 0x01, 0x17, 0x01, // Ţė (U+0162 U+0117)
  0x01, 0x62, 0x01, 0x19, 0x01, // Ţę (U+0162 U+0119)
  0x01, 0x62, 0x01, 0x1B, 0x01, // Ţě (U+0162 U+011B)
  0x01, 0x62, 0x01, 0x1D, 0x01, // Ţĝ (U+0162 U+011D)
  0x01, 0x62, 0x01, 0x1F, 0x01, // Ţğ (U+0162 U+011F)
  0x01, 0x62, 0x01, 0x21, 0x01, // Ţġ (U+0162 U+0121)
  0x01, 0x62, 0x01, 0x23, 0x01, // Ţģ (U+0162 U+0123)
  0x01, 0x62, 0x01, 0x4D, 0x01, // Ţō (U+0162 U+014D)
  0x01, 0x62, 0x01, 0x4F, 0x01, // Ţŏ (U+0162 U+014F)
  0x01, 0x62, 0x01, 0x51, 0x01, // Ţő (U+0162 U+0151)
  0x01, 0x62, 0x01, 0x53, 0x01, // Ţœ (U+0162 U+0153)
  0x01, 0x64, 0x00, 0x61, 0x01, // Ťa (U+0164 U+0061)
  0x01, 0x64, 0x00, 0x63, 0x01, // Ťc (U+0164 U+0063)
  0x01, 0x64, 0x00, 0x64, 0x01, // Ťd (U+0164 U+0064)
  0x01, 0x64, 0x00, 0x65, 0x01, // Ťe (U+0164 U+0065)
  0x01, 0x64, 0x00, 0x67, 0x01, // Ťg (U+0164 U+0067)
  0x01, 0x64, 0x00, 0x6F, 0x01, // Ťo (U+0164 U+006F)
  0x01, 0x64, 0x00, 0x71, 0x01, // Ťq (U+0164 U+0071)
  0x01, 0x64, 0x00, 0xE0, 0x01, // Ťà (U+0164 U+00E0)
  0x01, 0x64, 0x00, 0xE1, 0x01, // Ťá (U+0164 U+00E1)
  0x01, 0x64, 0x00, 0xE2, 0x01, // Ťâ (U+0164 U+00E2)
  0x01, 0x64, 0x00, 0xE3, 0x01, // Ťã (U+0164 U+00E3)
  0x01, 0x64, 0x00, 0xE4, 0x01, // Ťä (U+0164 U+00E4)
  0x01, 0x64, 0x00, 0xE5, 0x01, // Ťå (U+0164 U+00E5)
  0x01, 0x64, 0x00, 0xE6, 0x01, // Ťæ (U+0164 U+00E6)
  0x01, 0x64, 0x00, 0xE7, 0x01, // Ťç (U+0164 U+00E7)
  0x01, 0x64, 0x00, 0xE8, 0x01, // Ťè (U+0164 U+00E8)
  0x01, 0x64, 0x00, 0xE9, 0x01, // Ťé (U+0164 U+00E9)
  0x01, 0x64, 0x00, 0xEA, 0x01, // Ťê (U+0164 U+00EA)
  0x01, 0x64, 0x00, 0xEB, 0x01, // Ťë (U+0164 U+00EB)
  0x01, 0x64, 0x00, 0xF2, 0x01, // Ťò (U+0164 U+00F2)
  0x01, 0x64, 0x00, 0xF3, 0x01, // Ťó (U+0164 U+00F3)
  0x01, 0x64, 0x00, 0xF4, 0x01, // Ťô (U+0164 U+00F4)
  0x01, 0x64, 0x00, 0xF5, 0x01, // Ťõ (U+0164 U+00F5)
  0x01, 0x64, 0x00, 0xF6, 0x01, // Ťö (U+0164 U+00F6)
  0x01, 0x64, 0x00, 0xF8, 0x01, // Ťø (U+0164 U+00F8)
  0x01, 0x64, 0x01, 0x01, 0x01, // Ťā (U+0164 U+0101)
  0x01, 0x64, 0x01, 0x03, 0x01, // Ťă (U+0164 U+0103)
  0x01, 0x64, 0x01, 0x05, 0x01, // Ťą (U+0164 U+0105)
  0x01, 0x64, 0x01, 0x07, 0x01, // Ťć (U+0164 U+0107)
  0x01, 0x64, 0x01, 0x09, 0x01, // Ťĉ (U+0164 U+0109)
  0x01, 0x64, 0x01, 0x0B, 0x01, // Ťċ (U+0164 U+010B)
  0x01, 0x64, 0x01, 0x0D, 0x01, // Ťč (U+0164 U+010D)
  0x01, 0x64, 0x01, 0x0F, 0x01, // Ťď (U+0164 U+010F)
  0x01, 0x64, 0x01, 0x11, 0x01, // Ťđ (U+0164 U+0111)
  0x01, 0x64, 0x01, 0x13, 0x01, // Ťē (U+0164 U+0113)
  0x01, 0x64, 0x01, 0x15, 0x01, // Ťĕ (U+0164 U+0115)
  0x01, 0x64, 0x01, 0x17, 0x01, // Ťė (U+0164 U+0117)
  0x01, 0x64, 0x01, 0x19, 0x01, // Ťę (U+0164 U+0119)
  0x01, 0x64, 0x01, 0x1B, 0x01, // Ťě (U+0164 U+011B)
  0x01, 0x64, 0x01, 0x1D, 0x01, // Ťĝ (U+0164 U+011D)
  0x01, 0x64, 0x01, 0x1F, 0x01, // Ťğ (U+0164 U+011F)
  0x01, 0x64, 0x01, 0x21, 0x01, // Ťġ (U+0164 U+0121)
  0x01, 0x64, 0x01, 0x23, 0x01, // Ťģ (U+0164 U+0123)
  0x01, 0x64, 0x01, 0x4D, 0x01, // Ťō (U+0164 U+014D)
  0x01, 0x64, 0x01, 0x4F, 0x01, // Ťŏ (U+0164 U+014F)
  0x01, 0x64, 0x01, 0x51, 0x01, // Ťő (U+0164 U+0151)
  0x01, 0x64, 0x01, 0x53, 0x01, // Ťœ (U+0164 U+0153)
  0x01, 0x66, 0x00, 0x61, 0x01, // Ŧa (U+0166 U+0061)
  0x01, 0x66, 0x00, 0x63, 0x01, // Ŧc (U+0166 U+0063)
  0x01, 0x66, 0x00, 0x64, 0x01, // Ŧd (U+0166 U+0064)
  0x01, 0x66, 0x00, 0x65, 0x01, // Ŧe (U+0166 U+0065)
  0x01, 0x66, 0x00, 0x67, 0x01, // Ŧg (U+0166 U+0067)
  0x01, 0x66, 0x00, 0x6F, 0x01, // Ŧo (U+0166 U+006F)
  0x01, 0x66, 0x00, 0x71, 0x01, // Ŧq (U+0166 U+0071)
  0x01, 0x66, 0x00, 0xE0, 0x01, // Ŧà (U+0166 U+00E0)
  0x01, 0x66, 0x00, 0xE1, 0x01, // Ŧá (U+0166 U+00E1)
  0x01, 0x66, 0x00, 0xE2, 0x01, // Ŧâ (U+0166 U+00E2)
  0x01, 0x66, 0x00, 0xE3, 0x01, // Ŧã (U+0166 U+00E3)
  0x01, 0x66, 0x00, 0xE4, 0x01, // Ŧä (U+0166 U+00E4)
  0x01, 0x66, 0x00, 0xE5, 0x01, // Ŧå (U+0166 U+00E5)
  0x01, 0x66, 0x00, 0xE6, 0x01, // Ŧæ (U+0166 U+00E6)
  0x01, 0x66, 0x00, 0xE7, 0x01, // Ŧç (U+0166 U+00E7)
  0x01, 0x66, 0x00, 0xE8, 0x01, // Ŧè (U+0166 U+00E8)
  0x01, 0x66, 0x00, 0xE9, 0x01, // Ŧé (U+0166 U+00E9)
  0x01, 0x66, 0x00, 0xEA, 0x01, // Ŧê (U+0166 U+00EA)
  0x01, 0x66, 0x00, 0xEB, 0x01, // Ŧë (U+0166 U+00EB)
  0x01, 0x66, 0x00, 0xF2, 0x01, // Ŧò (U+0166 U+00F2)
  0x01, 0x66, 0x00, 0xF3, 0x01, // Ŧó (U+0166 U+00F3)
  0x01, 0x66, 0x00, 0xF4, 0x01, // Ŧô (U+0166 U+00F4)
  0x01, 0x66, 0x00, 0xF5, 0x01, // Ŧõ (U+0166 U+00F5)
  0x01, 0x66, 0x00, 0xF6, 0x01, // Ŧö (U+0166 U+00F6)
  0x01, 0x66, 0x00, 0xF8, 0x01, // Ŧø (U+0166 U+00F8)
  0x01, 0x66, 0x01, 0x01, 0x01, // Ŧā (U+0166 U+0101)
  0x01, 0x66, 0x01, 0x03, 0x01, // Ŧă (U+0166 U+0103)
  0x01, 0x66, 0x01, 0x05, 0x01, // Ŧą (U+0166 U+0105)
  0x01, 0x66, 0x01, 0x07, 0x01, // Ŧć (U+0166 U+0107)
  0x01, 0x66, 0x01, 0x09, 0x01, // Ŧĉ (U+0166 U+0109)
  0x01, 0x66, 0x01, 0x0B, 0x01, // Ŧċ (U+0166 U+010B)
  0x01, 0x66, 0x01, 0x0D, 0x01, // Ŧč (U+0166 U+010D)
  0x01, 0x66, 0x01, 0x0F, 0x01, // Ŧď (U+0166 U+010F)
  0x01, 0x66, 0x01, 0x11, 0x01, // Ŧđ (U+0166 U+0111)
  0x01, 0x66, 0x01, 0x13, 0x01, // Ŧē (U+0166 U+0113)
  0x01, 0x66, 0x01, 0x15, 0x01, // Ŧĕ (U+0166 U+0115)
  0x01, 0x66, 0x01, 0x17, 0x01, // Ŧė (U+0166 U+0117)
  0x01, 0x66, 0x01, 0x19, 0x01, // Ŧę (U+0166 U+0119)
  0x01, 0x66, 0x01, 0x1B, 0x01, // Ŧě (U+0166 U+011B)
  0x01, 0x66, 0x01, 0x1D, 0x01, // Ŧĝ (U+0166 U+011D)
  0x01, 0x66, 0x01, 0x1F, 0x01, // Ŧğ (U+0166 U+011F)
  0x01, 0x66, 0x01, 0x21, 0x01, // Ŧġ (U+0166 U+0121)
  0x01, 0x66, 0x01, 0x23, 0x01, // Ŧģ (U+0166 U+0123)
  0x01, 0x66, 0x01, 0x4D, 0x01, // Ŧō (U+0166 U+014D)
  0x01, 0x66, 0x01, 0x4F, 0x01, // Ŧŏ (U+0166 U+014F)
  0x01, 0x66, 0x01, 0x51, 0x01, // Ŧő (U+0166 U+0151)
  0x01, 0x66, 0x01, 0x53, 0x01, // Ŧœ (U+0166 U+0153)
  0x20, 0x18, 0x00, 0x41, 0x01, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0xC0, 0x01, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x01, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x01, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x01, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x01, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x01, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x01, 0x00, 0x01, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x02, 0x01, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x04, 0x01, // ‘Ą (U+2018 U+0104)
  0x20, 0x19, 0x00, 0x41, 0x01, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0xC0, 0x01, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x01, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x01, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x01, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x01, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x01, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x01, 0x00, 0x01, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x02, 0x01, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x04, 0x01, // ’Ą (U+2019 U+0104)
  0x20, 0x1A, 0x00, 0x54, 0x01, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x01, 0x62, 0x01, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x01, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x01, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1C, 0x00, 0x41, 0x01, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0xC0, 0x01, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x01, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x01, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x01, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x01, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x01, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x01, 0x00, 0x01, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x02, 0x01, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x04, 0x01, // “Ą (U+201C U+0104)
  0x20, 0x1D, 0x00, 0x41, 0x01, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0xC0, 0x01, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x01, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x01, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x01, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x01, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x01, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x01, 0x00, 0x01, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x02, 0x01, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x04, 0x01, // ”Ą (U+201D U+0104)
  0x20, 0x1E, 0x00, 0x54, 0x01, // „T (U+201E U+0054)
  0x20, 0x1E, 0x01, 0x62, 0x01, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x01, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x01, // „Ŧ (U+201E U+0166)
  0x20, 0x44, 0x00, 0x30, 0x01, // ⁄0 (U+2044 U+0030)
  0x20, 0x44, 0x00, 0x31, 0x01, // ⁄1 (U+2044 U+0031)
  0x20, 0x44, 0x00, 0x32, 0x01, // ⁄2 (U+2044 U+0032)
  0x20, 0x44, 0x00, 0x33, 0x01, // ⁄3 (U+2044 U+0033)
  0x20, 0x44, 0x00, 0x34, 0x01, // ⁄4 (U+2044 U+0034)
  0x20, 0x44, 0x00, 0x35, 0x01, // ⁄5 (U+2044 U+0035)
  0x20, 0x44, 0x00, 0x36, 0x01, // ⁄6 (U+2044 U+0036)
  0x20, 0x44, 0x00, 0x37, 0x01, // ⁄7 (U+2044 U+0037)
  0x20, 0x44, 0x00, 0x38, 0x01, // ⁄8 (U+2044 U+0038)
  0x20, 0x44, 0x00, 0x39, 0x01, // ⁄9 (U+2044 U+0039)
  
  // Glyph data
  // "!" (U+0021)
  0x18, 0x90, 0xD6, 0x0F, 0x23, 0xE0, 0x5A, 0x40, 0xB0, 0x41,
  // """ (U+0022)
  0x18, 0x90, 0xE7, 0x92, 0xB8, 0x50, 0x11, 0x10,
  // "#" (U+0023)
  0x28, 0x4C, 0x57, 0x05, 0xEA, 0x8A, 0x6E, 0x20, 0x96, 0xD2, 0x0B, 0xFE, 0xFA, 0x02, 0xC7, 0x71,
  0x03, 0x99, 0x32,
  // "$" (U+0024)
  0x18, 0x36, 0xDC, 0x21, 0xA8, 0x3E, 0x21, 0xF9, 0x38, 0x90, 0x6F, 0x80, 0x21, 0xAF, 0x0B, 0xA0,
  0x92, 0x08, 0x01, 0x20,
  // "%" (U+0025)
  0x8C, 0x71, 0xCD, 0x13, 0xA0, 0x79, 0xD2, 0xC1, 0x06, 0xFA, 0x9B, 0xD4, 0x01, 0x5A, 0xE8, 0x80,
  0x1C, 0x3C, 0xA5, 0x0B, 0x30, 0xDB, 0x10,
  // "&" (U+0026)
  0x18, 0x22, 0xDD, 0x22, 0x82, 0x98, 0xB6, 0x28, 0xA4, 0x8D, 0xC1, 0x04, 0xDD, 0x5C, 0x4A, 0x95,
  0xF9, 0x05, 0xEE, 0xBC, 0x10,
  // "'" (U+0027)
  0x18, 0x3E, 0x2B, 0x01,
  // "(" (U+0028)
  0x18, 0xA4, 0x2D, 0x0B, 0x43, 0xD0, 0x78, 0x0A, 0x60, 0xA5, 0x09, 0x60, 0x49, 0x10,
  // ")" (U+0029)
  0x20, 0xD3, 0x0B, 0x04, 0x20, 0xA0, 0x62, 0x0B, 0x05, 0x28, 0x3D, 0x30, 0x3D, 0x28, 0x39, 0x60,
  0x3B, 0x20,
  // "*" (U+002A)
  0x18, 0xA0, 0x29, 0x40, 0x2C, 0xE9, 0x50, 0xAD, 0x72, 0x04, 0x36, 0x10,
  // "+" (U+002B)
  0x10, 0x10, 0xC2, 0x87, 0x8E, 0xFE, 0x41, 0x2C, 0x12, 0x01, 0x0C, 0x20,
  // "," (U+002C)
  0x18, 0x51, 0x10, 0xD3, 0x3B, 0x10,
  // "-" (U+002D)
  0x83, 0xAE, 0x41, 0x11,
  // "." (U+002E)
  0x0B, 0x04,
  // "/" (U+002F)
  0x30, 0x70, 0xA3, 0x0E, 0x02, 0x20, 0x70, 0x92, 0x81, 0x1E, 0x22, 0x08, 0x09, 0x28, 0x11, 0xE1,
  0x20,
  // "0" (U+0030)
  0x18, 0xB2, 0x6E, 0xC0, 0x3E, 0x3E, 0x48, 0xA0, 0xD4, 0xA7, 0x1F, 0x2A, 0x88, 0xC0, 0x4E, 0xD2,
  0x10,
  // "1" (U+0031)
  0x18, 0x91, 0x1B, 0xC1, 0xED, 0x90, 0x2B, 0x62, 0x82, 0xE2, 0x02, 0x92, 0x06, 0x0C, 0x10,
  // "2" (U+0032)
  0x28, 0x1A, 0xEB, 0x38, 0x26, 0x2F, 0x33, 0x04, 0x0E, 0x38, 0x14, 0xE3, 0x28, 0x15, 0xD3, 0x20,
  0x1B, 0x0A, 0x10,
  // "3" (U+0033)
  0x18, 0x93, 0xAE, 0xC1, 0x02, 0x2F, 0x30, 0x9F, 0x72, 0x89, 0x31, 0x7D, 0x04, 0x18, 0xC0, 0xCF,
  0xD3, 0x10,
  // "4" (U+0034)
  0x28, 0x44, 0xF3, 0x01, 0xD9, 0x28, 0x91, 0xB9, 0xD0, 0x79, 0x7A, 0x0F, 0xEA, 0x0F, 0x10, 0xE0,
  0x41,
  // "5" (U+0035)
  0x10, 0xAA, 0x89, 0x04, 0x0E, 0x21, 0x03, 0xFD, 0x62, 0x89, 0x32, 0x7E, 0x03, 0x18, 0xC0, 0xBF,
  0xD3, 0x10,
  // "6" (U+0036)
  0x18, 0xB2, 0x2B, 0xE6, 0x0D, 0x61, 0x06, 0xDC, 0xA0, 0x9B, 0x4F, 0x19, 0x95, 0xE0, 0x3D, 0xD4,
  0x10,
  // "7" (U+0037)
  0x02, 0xB8, 0x49, 0x01, 0x2E, 0x32, 0x0A, 0x09, 0x28, 0x13, 0xE1, 0x20, 0xC0, 0x72, 0x06, 0x0D,
  0x30,
  // "8" (U+0038)
  0x18, 0xB2, 0x7E, 0xC1, 0x0F, 0x4D, 0x50, 0xBB, 0xB0, 0x5C, 0x9B, 0x0B, 0x85, 0xE0, 0x5E, 0xD6,
  0x10,
  // "9" (U+0039)
  0x18, 0xB2, 0x9E, 0xB0, 0x5D, 0x2F, 0x37, 0xB1, 0xF3, 0x3F, 0xDF, 0x01, 0x2A, 0x90, 0x9E, 0xA1,
  0x10,
  // ":" (U+003A)
  0x81, 0x1D, 0x17, 0x20, 0xB0, 0x41,
  // ";" (U+003B)
  0x18, 0x11, 0xD1, 0x72, 0x00, 0x12, 0x83, 0xD3, 0x03, 0xB2,
  // "<" (U+003C)
  0x28, 0x92, 0x19, 0x41, 0x9B, 0x40, 0x5D, 0x71, 0x38, 0x16, 0xC3,
  // "=" (U+003D)
  0x89, 0x58, 0xEE, 0xE4, 0x11, 0x11, 0x08, 0xEE, 0xE4, 0x80, 0x01, 0x10,
  // ">" (U+003E)
  0x00, 0x74, 0x81, 0x6C, 0x72, 0x85, 0x29, 0xD2, 0x7B, 0x42,
  // "?" (U+003F)
  0x89, 0x51, 0xCE, 0x80, 0x45, 0xD0, 0x1C, 0x70, 0xB6, 0x20, 0x32, 0x03, 0x0C, 0x20,
  // "@" (U+0040)
  0x18, 0x31, 0x9E, 0xEA, 0x20, 0xB0, 0xCA, 0x8B, 0x2B, 0x85, 0x9D, 0x3D, 0x2B, 0x95, 0xC3, 0xB6,
  0x99, 0x5D, 0xBD, 0xD2, 0x5C, 0x10, 0x33, 0x09, 0xA0, 0xC5, 0x01, 0x30,
  // "A" (U+0041)
  0x30, 0xB9, 0x38, 0x23, 0xBD, 0x12, 0x84, 0xB3, 0xC3, 0x03, 0xB8, 0x74, 0x0B, 0x62, 0xB6, 0x3E,
  0x20, 0x90, 0x70,
  // "B" (U+0042)
  0x18, 0xB2, 0xAF, 0xE8, 0x0D, 0x48, 0xC1, 0xFE, 0xE3, 0x4D, 0x2D, 0x67, 0xB1, 0xD6, 0xAF, 0xE9,
  0x10,
  // "C" (U+0043)
  0x18, 0x91, 0x2B, 0xEC, 0x0D, 0x81, 0x35, 0xD3, 0x07, 0x0B, 0x38, 0x26, 0xD2, 0x22, 0x82, 0xAE,
  0xD1,
  // "D" (U+0044)
  0x18, 0x2A, 0xFE, 0x62, 0x8B, 0x1D, 0x55, 0xF0, 0x1F, 0x11, 0xF2, 0x4E, 0x04, 0xF0, 0x7B, 0x2C,
  0x90, 0xAF, 0xE9, 0x20,
  // "E" (U+0045)
  0x10, 0xAA, 0x8A, 0x17, 0x0D, 0x51, 0x01, 0xFE, 0xD0, 0x4D, 0x11, 0x07, 0xB1, 0x20, 0xAA, 0x07,
  0x10,
  // "F" (U+0046)
  0x10, 0xAA, 0x8A, 0x07, 0x0D, 0x41, 0x01, 0xFE, 0xC0, 0x4C, 0x11, 0x07, 0xA3, 0x0A, 0x07, 0x30,
  // "G" (U+0047)
  0x18, 0xB2, 0x1A, 0xED, 0x30, 0xD9, 0x22, 0x05, 0xE2, 0xEE, 0x07, 0xB0, 0x6D, 0x06, 0xD2, 0x7B,
  0x28, 0x2A, 0xED, 0x61,
  // "H" (U+0048)
  0x18, 0x92, 0xA7, 0x0A, 0x80, 0xD4, 0x0E, 0x51, 0xC8, 0xA0, 0x24, 0xD2, 0x6E, 0x07, 0xA0, 0x7B,
  0x0A, 0x70, 0xA8, 0x10,
  // "I" (U+0049)
  0x10, 0x1A, 0x05, 0x20, 0xA0, 0x83, 0x0D, 0x04, 0x28, 0x11, 0xF1, 0x20, 0x40, 0xE2, 0x82, 0x1E,
  0xF4, 0x10,
  // "J" (U+004A)
  0x30, 0x09, 0x30, 0xC0, 0x63, 0x0E, 0x03, 0x20, 0x29, 0x30, 0x50, 0xC3, 0x08, 0x09, 0x38, 0x4C,
  0x60, 0x3F, 0xC3, 0x01, 0x30,
  // "K" (U+004B)
  0x18, 0x95, 0xA7, 0x3E, 0x30, 0xD5, 0xD7, 0x01, 0xFC, 0xA2, 0x82, 0x4F, 0xD8, 0x28, 0x27, 0xA5,
  0xD2, 0x83, 0xA7, 0x0F, 0x41,
  // "L" (U+004C)
  0x10, 0xA0, 0x72, 0x87, 0xD4, 0x01, 0xF1, 0x04, 0xD2, 0x83, 0x7B, 0x11, 0xAA, 0x07,
  // "M" (U+004D)
  0x10, 0xA9, 0x28, 0xC2, 0xCE, 0x0D, 0xE1, 0x4E, 0xC1, 0xFC, 0x2B, 0xB8, 0x4C, 0xB6, 0xBB, 0x57,
  0x9A, 0xE3, 0xE2, 0xA5, 0x9B, 0x1E, 0x10,
  // "N" (U+004E)
  0x18, 0xC0, 0xAE, 0x01, 0xE0, 0xDE, 0x44, 0xC1, 0xE8, 0x87, 0x84, 0xC3, 0xDA, 0x57, 0x90, 0xEE,
  0x2A, 0x50, 0x9E, 0x10,
  // "O" (U+004F)
  0x18, 0x93, 0x2C, 0xEB, 0x10, 0xD8, 0x2D, 0x75, 0xE2, 0x82, 0xA8, 0x7B, 0x28, 0x5D, 0x66, 0xD2,
  0x6E, 0x28, 0x2A, 0xED, 0x31,
  // "P" (U+0050)
  0x18, 0xA4, 0xAF, 0xE5, 0x0D, 0x57, 0xD1, 0xF2, 0x7C, 0x4F, 0xED, 0x37, 0xB1, 0x20, 0xA0, 0x83,
  // "Q" (U+0051)
  0x18, 0x93, 0x2C, 0xEB, 0x10, 0xD8, 0x2D, 0x75, 0xE2, 0x82, 0xA8, 0x7B, 0x28, 0x5D, 0x66, 0xD2,
  0x6E, 0x28, 0x2A, 0xFE, 0x33, 0x81, 0x1E, 0x34, 0x05, 0x04, 0x10,
  // "R" (U+0052)
  0x18, 0x90, 0xAF, 0xD4, 0x0D, 0x4B, 0x91, 0xA8, 0x97, 0xC2, 0x4C, 0x99, 0x07, 0x94, 0xE0, 0xA7,
  0x0F, 0x40,
  // "S" (U+0053)
  0x18, 0x68, 0xED, 0x21, 0xF3, 0x32, 0x0E, 0x09, 0x38, 0x93, 0x2D, 0x70, 0x31, 0xAA, 0x0A, 0xFC,
  0x21,
  // "T" (U+0054)
  0x03, 0xB8, 0x3B, 0x01, 0xF2, 0x20, 0x30, 0xE3, 0x07, 0x0B, 0x30, 0xA0, 0x83, 0x0D, 0x05, 0x20,
  // "U" (U+0055)
  0x18, 0xB7, 0xB7, 0x0A, 0x70, 0xE3, 0x0E, 0x42, 0xF0, 0x1F, 0x15, 0xD0, 0x5D, 0x06, 0xD2, 0xB8,
  0x01, 0xCF, 0xB2,
  // "V" (U+0056)
  0x89, 0x73, 0xD0, 0x1E, 0x32, 0xE0, 0x7A, 0x01, 0xF0, 0xE3, 0x29, 0x07, 0x0B, 0x38, 0x1E, 0xD3,
  0x30, 0xC0, 0xB3,
  // "W" (U+0057)
  0x8C, 0x44, 0xD0, 0x7D, 0x07, 0xA3, 0xD0, 0xDD, 0x0D, 0x43, 0xD4, 0xBD, 0x4D, 0x02, 0xDB, 0x5E,
  0xA6, 0x02, 0xED, 0x0E, 0xE2, 0x84, 0x1F, 0x60, 0xF9, 0x20,
  // "X" (U+0058)
  0x28, 0x3E, 0x33, 0xE2, 0x28, 0x2A, 0x8C, 0x63, 0x81, 0x5F, 0xB4, 0x81, 0x9F, 0x73, 0x82, 0x5D,
  0x6D, 0x28, 0x42, 0xE3, 0x1F, 0x31,
  // "Y" (U+0059)
  0x89, 0x42, 0xF0, 0x6D, 0x0D, 0x4E, 0x40, 0xAE, 0x92, 0x81, 0x6E, 0x12, 0x07, 0x0A, 0x30, 0xB0,
  0x72,
  // "Z" (U+005A)
  0x10, 0x1B, 0x09, 0x28, 0x21, 0x6E, 0x12, 0x81, 0x2E, 0x43, 0x0C, 0x08, 0x38, 0x19, 0xC1, 0x20,
  0x2B, 0x0A, 0x10,
  // "[" (U+005B)
  0x18, 0x7B, 0xF1, 0x0E, 0x20, 0x1D, 0x20, 0x40, 0xB2, 0x07, 0x08, 0x20, 0xA0, 0x52, 0x0D, 0x02,
  0x29, 0x0B, 0x20, 0x01, 0x20,
  // "\" (U+005C)
  0x01, 0x0E, 0x28, 0x94, 0xE1, 0x0C, 0x30, 0x95, 0x07, 0x80, 0x5A,
  // "]" (U+005D)
  0x18, 0x12, 0xFA, 0x20, 0x70, 0x82, 0x0A, 0x05, 0x20, 0xD0, 0x22, 0x0E, 0x20, 0x30, 0xC2, 0x87,
  0x69, 0x06, 0xF6, 0x01, 0x12,
  // "^" (U+005E)
  0x20, 0xB0, 0x32, 0x81, 0x5C, 0x82, 0x87, 0xC1, 0xC0, 0x86, 0x0C, 0x10,
  // "_" (U+005F)
  0x82, 0x69, 0x95,
  // "`" (U+0060)
  0x82, 0x78, 0x01,
  // "a" (U+0061)
  0x18, 0xA5, 0x9E, 0xA7, 0x4E, 0x3E, 0x58, 0x90, 0xE2, 0x9A, 0x6E, 0x04, 0xEB, 0xC1,
  // "b" (U+0062)
  0x10, 0xA0, 0x83, 0x0D, 0x05, 0x39, 0x8A, 0x4B, 0xD1, 0x3F, 0x3D, 0x56, 0xB0, 0xD4, 0x9B, 0x4F,
  0x1B, 0xAE, 0x61,
  // "c" (U+0063)
  0x18, 0x78, 0xEB, 0x4E, 0x22, 0x89, 0x28, 0x69, 0xA2, 0x13, 0xDE, 0x30,
  // "d" (U+0064)
  0x30, 0x40, 0xD3, 0x8B, 0x07, 0xA0, 0x9E, 0xC7, 0x4E, 0x3E, 0x58, 0x90, 0xE2, 0x9A, 0x6E, 0x04,
  0xEB, 0xC1,
  // "e" (U+0065)
  0x18, 0x90, 0x7E, 0xC0, 0x4E, 0x3E, 0x38, 0xA8, 0x91, 0xA0, 0x9B, 0x22, 0x03, 0xDE, 0x61,
  // "f" (U+0066)
  0x28, 0x13, 0xDA, 0x28, 0x39, 0x91, 0x05, 0xA8, 0x32, 0x01, 0xF3, 0x20, 0x30, 0xE3, 0x06, 0x0B,
  0x30, 0x90, 0x82, 0x81, 0x1D, 0x52, 0x0C, 0x0B, 0x30,
  // "g" (U+0067)
  0x18, 0xB7, 0x9E, 0xA7, 0x4E, 0x3E, 0x58, 0x90, 0xE2, 0x9A, 0x6E, 0x04, 0xEC, 0xB0, 0x31, 0xB7,
  0x0B, 0xFB, 0x11,
  // "h" (U+0068)
  0x10, 0xA0, 0x83, 0x0D, 0x05, 0x39, 0x8A, 0x4B, 0xE2, 0x3F, 0x4D, 0x66, 0xC0, 0xD4, 0x99, 0x1F,
  0x1B, 0x64, 0xE1,
  // "i" (U+0069)
  0x10, 0x90, 0x64, 0x98, 0x92, 0x23, 0xE0, 0x6C, 0x09, 0x90, 0xB6, 0x10,
  // "j" (U+006A)
  0x20, 0x90, 0x66, 0x98, 0x22, 0x03, 0xE2, 0x06, 0x0B, 0x20, 0x09, 0x28, 0x7C, 0x60, 0x2F, 0x20,
  0xE9, 0x20,
  // "k" (U+006B)
  0x10, 0xA0, 0x73, 0x0D, 0x05, 0x39, 0x87, 0x2C, 0x73, 0xEA, 0x90, 0x6A, 0x89, 0x11, 0x09, 0xBC,
  0x70, 0xB6, 0x6D, 0x10,
  // "l" (U+006C)
  0x18, 0xA1, 0xA7, 0x0D, 0x50, 0xF2, 0x3E, 0x06, 0xC0, 0x99, 0x0B, 0x61,
  // "m" (U+006D)
  0x18, 0xC0, 0xE9, 0xE5, 0xE8, 0x3F, 0x4D, 0xB7, 0xC6, 0xC0, 0xE4, 0x7A, 0x99, 0x1F, 0x0A, 0x7B,
  0x64, 0xD0, 0xD4,
  // "n" (U+006E)
  0x18, 0xA5, 0xE9, 0xE2, 0x3F, 0x4D, 0x66, 0xC0, 0xD4, 0x99, 0x1F, 0x1B, 0x64, 0xE1,
  // "o" (U+006F)
  0x18, 0xA5, 0x8E, 0xB0, 0x4E, 0x3E, 0x48, 0x90, 0xE3, 0x8A, 0x5E, 0x02, 0xDD, 0x51,
  // "p" (U+0070)
  0x28, 0xB1, 0xEA, 0xD1, 0x03, 0xF3, 0xD5, 0x06, 0xB0, 0xD4, 0x09, 0xB4, 0xF1, 0x0C, 0xBE, 0x62,
  0x0E, 0x03, 0x30, 0x29, 0x40,
  // "q" (U+0071)
  0x18, 0xA5, 0x9E, 0xA7, 0x4E, 0x3E, 0x58, 0x90, 0xE2, 0x9A, 0x6E, 0x04, 0xEC, 0xB3, 0x09, 0x08,
  0x30, 0xC0, 0x51,
  // "r" (U+0072)
  0x18, 0x7E, 0xA8, 0x3F, 0x40, 0x6C, 0x20, 0x09, 0x20, 0xB0, 0x62,
  // "s" (U+0073)
  0x8A, 0x12, 0xDE, 0x56, 0xD2, 0x11, 0xCC, 0x03, 0x2F, 0x2C, 0xFA, 0x10,
  // "t" (U+0074)
  0x18, 0x27, 0x60, 0x6A, 0x85, 0x52, 0xF1, 0x05, 0xD2, 0x85, 0x7B, 0x10, 0x5E, 0x91,
  // "u" (U+0075)
  0x8A, 0x61, 0xF1, 0x99, 0x3E, 0x0B, 0x66, 0xB0, 0xE3, 0x8A, 0x6F, 0x04, 0xE9, 0xD1,
  // "v" (U+0076)
  0x8A, 0x08, 0x90, 0xD5, 0x6A, 0x5D, 0x05, 0xBC, 0x50, 0x3D, 0xD2, 0x81, 0x1F, 0x62,
  // "w" (U+0077)
  0x8B, 0x77, 0x94, 0xF2, 0xA7, 0x79, 0xAD, 0x4E, 0x16, 0xAD, 0xA9, 0xA0, 0x5E, 0x8A, 0xE4, 0x05,
  0xF2, 0xAD, 0x20,
  // "x" (U+0078)
  0x18, 0x33, 0xE2, 0xE4, 0x28, 0x1D, 0xD8, 0x30, 0xA0, 0xE3, 0x89, 0x04, 0xEE, 0x20, 0x1E, 0x4A,
  0x81,
  // "y" (U+0079)
  0x18, 0x90, 0x89, 0x0E, 0x50, 0x6A, 0x5D, 0x28, 0x24, 0xCC, 0x52, 0x81, 0x2E, 0xD4, 0x90, 0x63,
  0x06, 0x0D, 0x38, 0x18, 0xD4, 0x30,
  // "z" (U+007A)
  0x10, 0x3A, 0x0A, 0x28, 0x13, 0xE3, 0x20, 0xC0, 0x62, 0x83, 0x8B, 0x10, 0x1B, 0x10,
  // "{" (U+007B)
  0x18, 0x42, 0xD4, 0x08, 0x92, 0x83, 0xD3, 0x0E, 0x92, 0x07, 0x0A, 0x20, 0x40, 0xB2, 0x07, 0x09,
  0x20, 0x49, 0x30, 0x12,
  // "|" (U+007C)
  0x8A, 0x03, 0x93, 0x93, 0x93, 0x93, 0x93, 0x93, 0x93, 0x93, 0x90,
  // "}" (U+007D)
  0x18, 0x13, 0xE2, 0x20, 0xC0, 0x32, 0x0D, 0x02, 0x28, 0x7A, 0xC0, 0x4C, 0x20, 0x78, 0x28, 0x4B,
  0x50, 0x5D, 0x11,
  // "~" (U+007E)
  0x83, 0x8E, 0xEE, 0x48, 0x00, 0x11,
  // "¡" (U+00A1)
  0x10, 0x10, 0xD4, 0x89, 0x16, 0x80, 0xA6, 0x0E, 0x42, 0xF1,
  // "¢" (U+00A2)
  0x20, 0x07, 0x28, 0x5A, 0xFE, 0x12, 0xF2, 0x20, 0x50, 0xD3, 0x82, 0x2E, 0xF8, 0x20, 0x60, 0x52,
  // "£" (U+00A3)
  0x18, 0x90, 0x1C, 0xF8, 0x07, 0xC1, 0x16, 0xA8, 0x93, 0x90, 0x1E, 0x51, 0x06, 0xD1, 0x10, 0xEA,
  0x0E, 0x10,
  // "¤" (U+00A4)
  0x38, 0x94, 0x15, 0xDE, 0xD2, 0xB3, 0xB2, 0xA1, 0xB4, 0xA8, 0x3D, 0x11, 0x12,
  // "¥" (U+00A5)
  0x89, 0x61, 0xF0, 0x7B, 0x0D, 0x4E, 0x10, 0x9E, 0x60, 0x4A, 0x81, 0xB0, 0x8A, 0x83, 0x80, 0x1C,
  0x72,
  // "¦" (U+00A6)
  0x86, 0x39, 0x39, 0x39, 0x39, 0x28, 0x63, 0x93, 0x93, 0x93, 0x90,
  // "§" (U+00A7)
  0x18, 0xB0, 0x8E, 0xB0, 0xE4, 0x30, 0xCD, 0x35, 0xA7, 0x81, 0xBE, 0x13, 0x1E, 0x2B, 0xEA, 0x10,
  // "¨" (U+00A8)
  0x82, 0x38, 0xA1,
  // "©" (U+00A9)
  0x18, 0x21, 0x88, 0x63, 0x87, 0x96, 0x96, 0x80, 0x62, 0xA2, 0x83, 0x71, 0x82, 0x82, 0x83, 0x53,
  0x62, 0x92, 0x86, 0x71, 0x19, 0x69, 0x69, 0x28, 0x21, 0x88, 0x72,
  // "ª" (U+00AA)
  0x89, 0x11, 0xBB, 0x45, 0x7A, 0x12, 0xA9, 0x10,
  // "«" (U+00AB)
  0x18, 0x93, 0x95, 0xA3, 0x7C, 0x9B, 0x06, 0xB8, 0xA2, 0x81, 0x61, 0x61,
  // "¬" (U+00AC)
  0x89, 0x08, 0xEE, 0xE4, 0x11, 0x19, 0x43, 0x05, 0x02,
  // "®" (U+00AE)
  0x18, 0x21, 0x88, 0x63, 0x8B, 0x79, 0xAA, 0x58, 0x06, 0x1A, 0x37, 0x71, 0x80, 0xBC, 0x15, 0x36,
  0x1A, 0x55, 0x71, 0x19, 0x40, 0x79, 0x28, 0x21, 0x88, 0x72,
  // "¯" (U+00AF)
  0x83, 0x2E, 0xEE, 0xC1, 0x80, 0x01,
  // "°" (U+00B0)
  0x87, 0x3D, 0x99, 0x5D, 0x5F, 0xB0,
  // "±" (U+00B1)
  0x10, 0x10, 0xC2, 0x87, 0x8E, 0xFE, 0x41, 0x2C, 0x12, 0x83, 0x1C, 0x10, 0x9B, 0x04,
  // "²" (U+00B2)
  0x18, 0x94, 0xAC, 0x20, 0x1B, 0x40, 0x97, 0x06, 0xDC, 0x10,
  // "³" (U+00B3)
  0x18, 0x94, 0x9C, 0x20, 0x19, 0x50, 0x8D, 0x04, 0xCA, 0x10,
  // "´" (U+00B4)
  0x82, 0x27, 0xC4,
  // "µ" (U+00B5)
  0x29, 0x8B, 0x02, 0x8A, 0x03, 0xE0, 0xB7, 0x06, 0xC0, 0xE4, 0x09, 0xB4, 0xF1, 0x0C, 0xEA, 0xE2,
  0x0E, 0x03, 0x30, 0x29, 0x40,
  // "¶" (U+00B6)
  0x10, 0xBA, 0x0A, 0x05, 0xA8, 0x17, 0xA6, 0xA8, 0x16, 0x93, 0xA8, 0x56, 0x90, 0x6A, 0x69, 0x28,
  0x13, 0x69, 0x28, 0x13, 0x69, 0x28, 0x13, 0x69,
  // "·" (U+00B7)
  0x0B, 0x04,
  // "¸" (U+00B8)
  0x18, 0x31, 0x2C, 0x9A,
  // "¹" (U+00B9)
  0x84, 0x8E, 0x6B, 0x77,
  // "º" (U+00BA)
  0x18, 0x90, 0xAC, 0x04, 0x8B, 0x11, 0xA7, 0x10,
  // "»" (U+00BB)
  0x82, 0x3B, 0x49, 0x29, 0x89, 0x15, 0xF1, 0x8B, 0xA9, 0x05, 0x06, 0x20,
  // "¼" (U+00BC)
  0x38, 0xB6, 0x3B, 0x08, 0xE0, 0xC3, 0x16, 0xB9, 0x8E, 0x37, 0xCB, 0xAD, 0x01, 0xC7, 0xBE, 0x3A,
  0x30, 0x14, 0x10,
  // "½" (U+00BD)
  0x38, 0xB6, 0x3B, 0x08, 0xE0, 0xC1, 0x06, 0xB9, 0xFC, 0x27, 0xC9, 0x1B, 0x41, 0xC1, 0x97, 0x0A,
  0x36, 0xDC, 0x10,
  // "¾" (U+00BE)
  0x18, 0x39, 0xC2, 0x3B, 0x28, 0xA1, 0x19, 0x5C, 0x31, 0x08, 0xD9, 0x8E, 0x34, 0xCF, 0xBA, 0xD2,
  0x89, 0x21, 0xC7, 0xBE, 0x30, 0xA3, 0x01, 0x41,
  // "¿" (U+00BF)
  0x20, 0xC0, 0x32, 0x03, 0x28, 0x95, 0x6B, 0x07, 0xC1, 0x0D, 0x54, 0x08, 0xEC, 0x10,
  // "À" (U+00C0)
  0x30, 0x70, 0x85, 0x01, 0x40, 0xB9, 0x38, 0x23, 0xBD, 0x12, 0x84, 0xB3, 0xC3, 0x03, 0xB8, 0x74,
  0x0B, 0x62, 0xB6, 0x3E, 0x20, 0x90, 0x70,
  // "Á" (U+00C1)
  0x40, 0x20, 0x74, 0x0C, 0x04, 0x30, 0xB9, 0x38, 0x23, 0xBD, 0x12, 0x84, 0xB3, 0xC3, 0x03, 0xB8,
  0x74, 0x0B, 0x62, 0xB6, 0x3E, 0x20, 0x90, 0x70,
  // "Â" (U+00C2)
  0x38, 0x16, 0xB9, 0x38, 0x11, 0x01, 0x30, 0xB9, 0x38, 0x23, 0xBD, 0x12, 0x84, 0xB3, 0xC3, 0x03,
  0xB8, 0x74, 0x0B, 0x62, 0xB6, 0x3E, 0x20, 0x90, 0x70,
  // "Ã" (U+00C3)
  0x38, 0x1B, 0xED, 0x30, 0xD9, 0x38, 0x23, 0xBD, 0x12, 0x84, 0xB3, 0xC3, 0x03, 0xB8, 0x74, 0x0B,
  0x62, 0xB6, 0x3E, 0x20, 0x90, 0x70,
  // "Ä" (U+00C4)
  0x38, 0x23, 0x8A, 0x17, 0x30, 0xB9, 0x48, 0x23, 0xBD, 0x13, 0x82, 0xB3, 0xC3, 0x20, 0x3B, 0x04,
  0x28, 0x6B, 0x62, 0xB6, 0x03, 0xE2, 0x09, 0x07, 0x10,
  // "Å" (U+00C5)
  0x30, 0x70, 0x94, 0x07, 0x08, 0x40, 0xB9, 0x38, 0x23, 0xBD, 0x12, 0x84, 0xB3, 0xC3, 0x03, 0xB8,
  0x74, 0x0B, 0x62, 0xB6, 0x3E, 0x20, 0x90, 0x70,
  // "Æ" (U+00C6)
  0x30, 0x2C, 0x05, 0x38, 0x3C, 0x7F, 0x21, 0x38, 0x45, 0xA5, 0xFE, 0xA2, 0x84, 0x1E, 0xEF, 0xA1,
  0x38, 0x49, 0x81, 0xC8, 0x12, 0x83, 0x3E, 0x10, 0xDA, 0x05, 0x10,
  // "Ç" (U+00C7)
  0x18, 0x91, 0x2B, 0xEC, 0x0D, 0x81, 0x35, 0xD3, 0x07, 0x0B, 0x38, 0x26, 0xD2, 0x22, 0x85, 0xBF,
  0xD1, 0x02, 0xC3, 0x09, 0x0A, 0x20,
  // "È" (U+00C8)
  0x20, 0x70, 0x84, 0x01, 0x20, 0xAA, 0x8A, 0x17, 0x0D, 0x51, 0x01, 0xFE, 0xD0, 0x4D, 0x11, 0x07,
  0xB1, 0x20, 0xAA, 0x07, 0x10,
  // "É" (U+00C9)
  0x30, 0x20, 0x73, 0x82, 0xC4, 0x0A, 0xA8, 0xA1, 0x70, 0xD5, 0x10, 0x1F, 0xED, 0x04, 0xD1, 0x10,
  0x7B, 0x12, 0x0A, 0xA0, 0x71,
  // "Ê" (U+00CA)
  0x28, 0x16, 0xB9, 0x28, 0x31, 0x01, 0x0A, 0xA8, 0xA1, 0x70, 0xD5, 0x10, 0x1F, 0xED, 0x04, 0xD1,
  0x10, 0x7B, 0x12, 0x0A, 0xA0, 0x71,
  // "Ë" (U+00CB)
  0x18, 0x23, 0x8A, 0x16, 0x0A, 0xA8, 0xA1, 0x70, 0xD5, 0x10, 0x1F, 0xED, 0x04, 0xD1, 0x10, 0x7B,
  0x12, 0x0A, 0xA0, 0x71,
  // "Ì" (U+00CC)
  0x20, 0x70, 0x84, 0x01, 0x20, 0x1A, 0x05, 0x20, 0xA0, 0x83, 0x0D, 0x04, 0x28, 0x11, 0xF1, 0x20,
  0x40, 0xE2, 0x82, 0x1E, 0xF4, 0x10,
  // "Í" (U+00CD)
  0x30, 0x20, 0x73, 0x82, 0xC4, 0x01, 0xA0, 0x52, 0x0A, 0x08, 0x30, 0xD0, 0x42, 0x81, 0x1F, 0x12,
  0x04, 0x0E, 0x28, 0x21, 0xEF, 0x41,
  // "Î" (U+00CE)
  0x28, 0x16, 0xB9, 0x28, 0x31, 0x01, 0x01, 0xA0, 0x52, 0x0A, 0x08, 0x30, 0xD0, 0x42, 0x81, 0x1F,
  0x12, 0x04, 0x0E, 0x28, 0x21, 0xEF, 0x41,
  // "Ï" (U+00CF)
  0x28, 0x23, 0x8A, 0x17, 0x01, 0xA0, 0x53, 0x0A, 0x08, 0x40, 0xD0, 0x43, 0x81, 0x1F, 0x13, 0x04,
  0x0E, 0x38, 0x21, 0xEF, 0x42,
  // "Ð" (U+00D0)
  0x18, 0x2B, 0xFE, 0x62, 0x8B, 0x1E, 0x45, 0xF0, 0xAF, 0xD1, 0xF2, 0x6D, 0x14, 0xF0, 0x8A, 0x2C,
  0x90, 0xBF, 0xE9, 0x20,
  // "Ñ" (U+00D1)
  0x28, 0x1B, 0xED, 0x28, 0xC0, 0xAF, 0x21, 0xE0, 0xDE, 0x44, 0xC1, 0xE8, 0x87, 0x84, 0xC3, 0xDA,
  0x57, 0x90, 0xEE, 0x2A, 0x50, 0x9E, 0x10,
  // "Ò" (U+00D2)
  0x30, 0x70, 0x85, 0x01, 0x28, 0x93, 0x2C, 0xEB, 0x10, 0xD8, 0x2D, 0x75, 0xE2, 0x82, 0xA8, 0x7B,
  0x28, 0x5D, 0x66, 0xD2, 0x6E, 0x28, 0x2A, 0xED, 0x31,
  // "Ó" (U+00D3)
  0x30, 0x20, 0x74, 0x0C, 0x04, 0x28, 0x93, 0x2C, 0xEB, 0x10, 0xD8, 0x2D, 0x75, 0xE2, 0x82, 0xA8,
  0x7B, 0x28, 0x5D, 0x66, 0xD2, 0x6E, 0x28, 0x2A, 0xED, 0x31,
  // "Ô" (U+00D4)
  0x28, 0x16, 0xB9, 0x38, 0x11, 0x01, 0x28, 0x93, 0x2C, 0xEB, 0x10, 0xD8, 0x2D, 0x75, 0xE2, 0x82,
  0xA8, 0x7B, 0x28, 0x5D, 0x66, 0xD2, 0x6E, 0x28, 0x2A, 0xED, 0x31,
  // "Õ" (U+00D5)
  0x28, 0x1B, 0xED, 0x28, 0x93, 0x2E, 0xFB, 0x10, 0xD8, 0x2D, 0x75, 0xE2, 0x82, 0xA8, 0x7B, 0x28,
  0x5D, 0x66, 0xD2, 0x6E, 0x28, 0x2A, 0xED, 0x31,
  // "Ö" (U+00D6)
  0x28, 0x23, 0x8A, 0x17, 0x89, 0x32, 0xCE, 0xB1, 0x0D, 0x82, 0xD7, 0x5E, 0x28, 0x2A, 0x87, 0xB2,
  0x85, 0xD6, 0x6D, 0x26, 0xE2, 0x82, 0xAE, 0xD3, 0x10,
  // "×" (U+00D7)
  0x89, 0x61, 0x40, 0x51, 0xCA, 0x90, 0x9E, 0x42, 0x91, 0xA0,
  // "Ø" (U+00D8)
  0x18, 0xC0, 0x2C, 0xFD, 0x70, 0xD8, 0x5F, 0x75, 0xD1, 0xBA, 0x87, 0xBB, 0x2C, 0x66, 0xF7, 0x6E,
  0x05, 0xDF, 0xD3, 0x10,
  // "Ù" (U+00D9)
  0x20, 0x70, 0x85, 0x01, 0x38, 0xB7, 0xB7, 0x0A, 0x70, 0xE3, 0x0E, 0x42, 0xF0, 0x1F, 0x15, 0xD0,
  0x5D, 0x06, 0xD2, 0xB8, 0x01, 0xCF, 0xB2,
  // "Ú" (U+00DA)
  0x30, 0x20, 0x74, 0x0C, 0x04, 0x28, 0xB7, 0xB7, 0x0A, 0x70, 0xE3, 0x0E, 0x42, 0xF0, 0x1F, 0x15,
  0xD0, 0x5D, 0x06, 0xD2, 0xB8, 0x01, 0xCF, 0xB2,
  // "Û" (U+00DB)
  0x28, 0x16, 0xB9, 0x38, 0x11, 0x01, 0x28, 0xB7, 0xB7, 0x0A, 0x70, 0xE3, 0x0E, 0x42, 0xF0, 0x1F,
  0x15, 0xD0, 0x5D, 0x06, 0xD2, 0xB8, 0x01, 0xCF, 0xB2,
  // "Ü" (U+00DC)
  0x28, 0x23, 0x8A, 0x17, 0x8B, 0x7B, 0x70, 0xA7, 0x0E, 0x30, 0xE4, 0x2F, 0x01, 0xF1, 0x5D, 0x05,
  0xD0, 0x6D, 0x2B, 0x80, 0x1C, 0xFB, 0x20,
  // "Ý" (U+00DD)
  0x20, 0x20, 0x73, 0x89, 0x7C, 0x40, 0x2F, 0x06, 0xD0, 0xD4, 0xE4, 0x0A, 0xE9, 0x28, 0x16, 0xE1,
  0x20, 0x70, 0xA3, 0x0B, 0x07, 0x20,
  // "Þ" (U+00DE)
  0x10, 0xA0, 0x83, 0x89, 0x5D, 0xEC, 0x21, 0xF4, 0xB8, 0x4E, 0x0B, 0x87, 0xA8, 0x3C, 0x1A, 0x91,
  0x20,
  // "ß" (U+00DF)
  0x28, 0x23, 0xDE, 0x92, 0x81, 0xC8, 0x59, 0x29, 0x86, 0x3B, 0x90, 0x3E, 0x7D, 0x28, 0xA2, 0x6C,
  0x2E, 0x70, 0x9A, 0x28, 0xC0, 0xC7, 0xEE, 0x52, 0xF3, 0x39, 0x0A, 0x40,
  // "à" (U+00E0)
  0x20, 0x70, 0x84, 0x01, 0x28, 0xA5, 0x9E, 0xA7, 0x4E, 0x3E, 0x58, 0x90, 0xE2, 0x9A, 0x6E, 0x04,
  0xEB, 0xC1,
  // "á" (U+00E1)
  0x20, 0x20, 0x73, 0x0C, 0x04, 0x28, 0xA5, 0x9E, 0xA7, 0x4E, 0x3E, 0x58, 0x90, 0xE2, 0x9A, 0x6E,
  0x04, 0xEB, 0xC1,
  // "â" (U+00E2)
  0x18, 0x16, 0xB9, 0x28, 0x11, 0x01, 0x28, 0xA5, 0x9E, 0xA7, 0x4E, 0x3E, 0x58, 0x90, 0xE2, 0x9A,
  0x6E, 0x04, 0xEB, 0xC1,
  // "ã" (U+00E3)
  0x28, 0xB1, 0xBE, 0xD0, 0x9F, 0xC8, 0x4E, 0x3E, 0x58, 0x90, 0xE2, 0x9A, 0x6E, 0x04, 0xEB, 0xC1,
  // "ä" (U+00E4)
  0x18, 0x23, 0x8A, 0x16, 0x8A, 0x59, 0xEA, 0x74, 0xE3, 0xE5, 0x89, 0x0E, 0x29, 0xA6, 0xE0, 0x4E,
  0xBC, 0x10,
  // "å" (U+00E5)
  0x20, 0x70, 0x93, 0x07, 0x08, 0x28, 0xA5, 0x9E, 0xA7, 0x4E, 0x3E, 0x58, 0x90, 0xE2, 0x9A, 0x6E,
  0x04, 0xEB, 0xC1,
  // "æ" (U+00E6)
  0x18, 0xC0, 0x9E, 0xAC, 0xE7, 0x4E, 0x3F, 0x88, 0xB8, 0x90, 0xFD, 0xB2, 0x9A, 0x6F, 0x42, 0x04,
  0xEA, 0xDE, 0xD1,
  // "ç" (U+00E7)
  0x18, 0x78, 0xEB, 0x4E, 0x22, 0x89, 0x28, 0x91, 0x9A, 0x21, 0x3E, 0xF3, 0x02, 0xC2, 0x09, 0x0A,
  0x10,
  // "è" (U+00E8)
  0x20, 0x70, 0x84, 0x01, 0x28, 0x90, 0x7E, 0xC0, 0x4E, 0x3E, 0x38, 0xA8, 0x91, 0xA0, 0x9B, 0x22,
  0x03, 0xDE, 0x61,
  // "é" (U+00E9)
  0x20, 0x20, 0x73, 0x0C, 0x04, 0x28, 0x90, 0x7E, 0xC0, 0x4E, 0x3E, 0x38, 0xA8, 0x91, 0xA0, 0x9B,
  0x22, 0x03, 0xDE, 0x61,
  // "ê" (U+00EA)
  0x18, 0x16, 0xB9, 0x28, 0x11, 0x01, 0x28, 0x90, 0x7E, 0xC0, 0x4E, 0x3E, 0x38, 0xA8, 0x91, 0xA0,
  0x9B, 0x22, 0x03, 0xDE, 0x61,
  // "ë" (U+00EB)
  0x18, 0x23, 0x8A, 0x16, 0x89, 0x07, 0xEC, 0x04, 0xE3, 0xE3, 0x8A, 0x89, 0x1A, 0x09, 0xB2, 0x20,
  0x3D, 0xE6, 0x10,
  // "ì" (U+00EC)
  0x10, 0x70, 0x82, 0x89, 0x51, 0x0F, 0x23, 0xE0, 0x6C, 0x09, 0x90, 0xB6, 0x10,
  // "í" (U+00ED)
  0x18, 0xA1, 0x27, 0x0C, 0x40, 0xF2, 0x3E, 0x06, 0xC0, 0x99, 0x0B, 0x61,
  // "î" (U+00EE)
  0x8A, 0x26, 0xB9, 0x10, 0x10, 0xF2, 0x3E, 0x06, 0xC0, 0x99, 0x0B, 0x61,
  // "ï" (U+00EF)
  0x82, 0x38, 0xA1, 0x59, 0x82, 0x20, 0x3E, 0x20, 0x60, 0xC2, 0x00, 0x92, 0x0B, 0x06, 0x20,
  // "ð" (U+00F0)
  0x28, 0x13, 0x01, 0x28, 0xB6, 0xDD, 0x30, 0x28, 0xE1, 0x0A, 0xDD, 0x46, 0xD4, 0xF4, 0xA8, 0x0F,
  0x3A, 0x96, 0xD0, 0x3D, 0xE3, 0x10,
  // "ñ" (U+00F1)
  0x28, 0xB1, 0xBE, 0xD0, 0xEB, 0xF3, 0x3F, 0x4D, 0x66, 0xC0, 0xD4, 0x99, 0x1F, 0x1B, 0x64, 0xE1,
  // "ò" (U+00F2)
  0x20, 0x70, 0x84, 0x01, 0x28, 0xA5, 0x8E, 0xB0, 0x4E, 0x3E, 0x48, 0x90, 0xE3, 0x8A, 0x5E, 0x02,
  0xDD, 0x51,
  // "ó" (U+00F3)
  0x20, 0x20, 0x73, 0x0C, 0x04, 0x28, 0xA5, 0x8E, 0xB0, 0x4E, 0x3E, 0x48, 0x90, 0xE3, 0x8A, 0x5E,
  0x02, 0xDD, 0x51,
  // "ô" (U+00F4)
  0x18, 0x16, 0xB9, 0x28, 0x11, 0x01, 0x28, 0xA5, 0x8E, 0xB0, 0x4E, 0x3E, 0x48, 0x90, 0xE3, 0x8A,
  0x5E, 0x02, 0xDD, 0x51,
  // "õ" (U+00F5)
  0x18, 0x1B, 0xED, 0x28, 0xA5, 0xAF, 0xB0, 0x4E, 0x3E, 0x48, 0x90, 0xE3, 0x8A, 0x5E, 0x02, 0xDD,
  0x51,
  // "ö" (U+00F6)
  0x18, 0x23, 0x8A, 0x16, 0x8A, 0x58, 0xEB, 0x04, 0xE3, 0xE4, 0x89, 0x0E, 0x38, 0xA5, 0xE0, 0x2D,
  0xD5, 0x10,
  // "÷" (U+00F7)
  0x10, 0x10, 0xB2, 0x83, 0x8E, 0xEE, 0x48, 0x00, 0x12, 0x01, 0x0B, 0x20,
  // "ø" (U+00F8)
  0x18, 0xA7, 0x8E, 0xD3, 0x4D, 0x7F, 0x38, 0xBC, 0xE4, 0x9E, 0x6E, 0x08, 0xED, 0x50, 0x14,
  // "ù" (U+00F9)
  0x20, 0x70, 0x84, 0x8B, 0x01, 0x01, 0xF1, 0x99, 0x3E, 0x0B, 0x66, 0xB0, 0xE3, 0x8A, 0x6F, 0x04,
  0xE9, 0xD1,
  // "ú" (U+00FA)
  0x20, 0x20, 0x73, 0x8B, 0x1C, 0x40, 0x1F, 0x19, 0x93, 0xE0, 0xB6, 0x6B, 0x0E, 0x38, 0xA6, 0xF0,
  0x4E, 0x9D, 0x10,
  // "û" (U+00FB)
  0x18, 0x16, 0xB9, 0x28, 0xB2, 0x10, 0x10, 0x1F, 0x19, 0x93, 0xE0, 0xB6, 0x6B, 0x0E, 0x38, 0xA6,
  0xF0, 0x4E, 0x9D, 0x10,
  // "ü" (U+00FC)
  0x18, 0x23, 0x8A, 0x15, 0x8A, 0x61, 0xF1, 0x99, 0x3E, 0x0B, 0x66, 0xB0, 0xE3, 0x8A, 0x6F, 0x04,
  0xE9, 0xD1,
  // "ý" (U+00FD)
  0x30, 0x20, 0x74, 0x0C, 0x04, 0x28, 0x90, 0x89, 0x0E, 0x50, 0x6A, 0x5D, 0x28, 0x24, 0xCC, 0x52,
  0x81, 0x2E, 0xD4, 0x90, 0x63, 0x06, 0x0D, 0x38, 0x18, 0xD4, 0x30,
  // "þ" (U+00FE)
  0x20, 0xA0, 0x84, 0x0D, 0x05, 0x49, 0x8B, 0x0B, 0xD1, 0x03, 0xE3, 0xD5, 0x06, 0xB0, 0xD4, 0x09,
  0xB4, 0xF1, 0x0C, 0xBE, 0x62, 0x90, 0x33, 0x02, 0x94,
  // "ÿ" (U+00FF)
  0x28, 0x23, 0x8A, 0x17, 0x89, 0x08, 0x90, 0xE5, 0x06, 0xA5, 0xD2, 0x82, 0x4C, 0xC5, 0x28, 0x12,
  0xED, 0x49, 0x06, 0x30, 0x60, 0xD3, 0x81, 0x8D, 0x43,
  // "Ā" (U+0100)
  0x38, 0x1E, 0xE5, 0x30, 0xD9, 0x38, 0x23, 0xBD, 0x12, 0x84, 0xB3, 0xC3, 0x03, 0xB8, 0x74, 0x0B,
  0x62, 0xB6, 0x3E, 0x20, 0x90, 0x70,
  // "ā" (U+0101)
  0x28, 0xB1, 0xEE, 0x50, 0x9F, 0xC8, 0x4E, 0x3E, 0x58, 0x90, 0xE2, 0x9A, 0x6E, 0x04, 0xEB, 0xC1,
  // "Ă" (U+0102)
  0x38, 0x14, 0x04, 0x38, 0x1A, 0xF8, 0x40, 0x14, 0x0B, 0x93, 0x82, 0x3B, 0xD1, 0x28, 0x4B, 0x3C,
  0x30, 0x3B, 0x87, 0x40, 0xB6, 0x2B, 0x63, 0xE2, 0x09, 0x07,
  // "ă" (U+0103)
  0x28, 0x14, 0x04, 0x28, 0x1A, 0xF8, 0x30, 0x12, 0x8A, 0x59, 0xEA, 0x74, 0xE3, 0xE5, 0x89, 0x0E,
  0x29, 0xA6, 0xE0, 0x4E, 0xBC, 0x10,
  // "Ą" (U+0104)
  0x30, 0xB9, 0x38, 0x23, 0xBD, 0x12, 0x84, 0xB3, 0xC3, 0x03, 0xB8, 0x74, 0x0B, 0x62, 0xB6, 0x3E,
  0x20, 0xA0, 0x83, 0x02, 0x0A, 0x48, 0x12, 0xC1,
  // "ą" (U+0105)
  0x18, 0xA5, 0x9E, 0xA7, 0x4E, 0x3E, 0x58, 0x90, 0xE2, 0x9A, 0x6E, 0x04, 0xEC, 0xC2, 0x02, 0x0A,
  0x38, 0x12, 0xC1, 0x10,
  // "Ć" (U+0106)
  0x30, 0x20, 0x73, 0x89, 0x4C, 0x40, 0x2B, 0xEC, 0x0D, 0x81, 0x35, 0xD3, 0x07, 0x0B, 0x38, 0x26,
  0xD2, 0x22, 0x82, 0xAE, 0xD1,
  // "ć" (U+0107)
  0x20, 0x20, 0x72, 0x89, 0x2C, 0x40, 0x8E, 0xB4, 0xE2, 0x28, 0x92, 0x86, 0x9A, 0x21, 0x3D, 0xE3,
  // "Ĉ" (U+0108)
  0x28, 0x16, 0xB9, 0x28, 0x95, 0x10, 0x10, 0x2B, 0xEC, 0x0D, 0x81, 0x35, 0xD3, 0x07, 0x0B, 0x38,
  0x26, 0xD2, 0x22, 0x82, 0xAE, 0xD1,
  // "ĉ" (U+0109)
  0x18, 0x97, 0x6B, 0x90, 0x10, 0x10, 0x8E, 0xB4, 0xE2, 0x28, 0x92, 0x86, 0x9A, 0x21, 0x3D, 0xE3,
  // "Ċ" (U+010A)
  0x30, 0xB0, 0x26, 0x89, 0x12, 0xBE, 0xC0, 0xD8, 0x13, 0x5D, 0x30, 0x70, 0xB3, 0x82, 0x6D, 0x22,
  0x28, 0x2A, 0xED, 0x10,
  // "ċ" (U+010B)
  0x20, 0xB0, 0x25, 0x87, 0x8E, 0xB4, 0xE2, 0x28, 0x92, 0x86, 0x9A, 0x21, 0x3D, 0xE3,
  // "Č" (U+010C)
  0x28, 0x28, 0x9A, 0x13, 0x01, 0x38, 0x22, 0xBE, 0xC2, 0x85, 0xD8, 0x13, 0x05, 0xD4, 0x07, 0x0B,
  0x48, 0x26, 0xD2, 0x23, 0x82, 0xAE, 0xD1, 0x10,
  // "č" (U+010D)
  0x18, 0x28, 0x9A, 0x12, 0x01, 0x38, 0x91, 0x8E, 0xB0, 0x4E, 0x22, 0x08, 0x93, 0x87, 0x9A, 0x21,
  0x03, 0xDE, 0x31,
  // "Ď" (U+010E)
  0x28, 0x28, 0x9A, 0x13, 0x01, 0x38, 0x2A, 0xFE, 0x62, 0x8B, 0x1D, 0x55, 0xF0, 0x1F, 0x11, 0xF2,
  0x4E, 0x04, 0xF0, 0x7B, 0x2C, 0x90, 0xAF, 0xE9, 0x20,
  // "ď" (U+010F)
  0x38, 0x24, 0xDA, 0x43, 0x07, 0x0A, 0x38, 0x29, 0xEC, 0x72, 0x83, 0x4E, 0x3E, 0x52, 0x83, 0x89,
  0x0E, 0x22, 0x82, 0x9A, 0x6E, 0x38, 0x24, 0xEB, 0xC3,
  // "Đ" (U+0110)
  0x18, 0x2B, 0xFE, 0x62, 0x8B, 0x1E, 0x45, 0xF0, 0xAF, 0xD1, 0xF2, 0x6D, 0x14, 0xF0, 0x8A, 0x2C,
  0x90, 0xBF, 0xE9, 0x20,
  // "đ" (U+0111)
  0x30, 0x40, 0xE3, 0x8B, 0x07, 0xEF, 0x40, 0xAE, 0xC8, 0x04, 0xE2, 0xE5, 0x08, 0x90, 0xF2, 0x09,
  0xA6, 0xE2, 0x82, 0x3E, 0xBC, 0x20,
  // "Ē" (U+0112)
  0x28, 0x3E, 0xE5, 0x0A, 0xA8, 0xA1, 0x80, 0xD5, 0x10, 0x1F, 0xED, 0x04, 0xD1, 0x10, 0x7B, 0x12,
  0x0A, 0xA0, 0x71,
  // "ē" (U+0113)
  0x28, 0x94, 0xEE, 0x50, 0x7F, 0xE1, 0x4E, 0x3E, 0x38, 0xA8, 0x91, 0xA0, 0x9B, 0x22, 0x03, 0xDE,
  0x61,
  // "Ĕ" (U+0114)
  0x28, 0x14, 0x04, 0x28, 0x1A, 0xF8, 0x30, 0x12, 0x0A, 0xA8, 0xA1, 0x70, 0xD5, 0x10, 0x1F, 0xED,
  0x04, 0xD1, 0x10, 0x7B, 0x12, 0x0A, 0xA0, 0x71,
  // "ĕ" (U+0115)
  0x18, 0x14, 0x04, 0x28, 0x1A, 0xF8, 0x30, 0x13, 0x89, 0x07, 0xEC, 0x04, 0xE3, 0xE3, 0x8A, 0x89,
  0x1A, 0x09, 0xB2, 0x20, 0x3D, 0xE6, 0x10,
  // "Ė" (U+0116)
  0x20, 0xB0, 0x27, 0x0A, 0xA8, 0xA1, 0x70, 0xD5, 0x10, 0x1F, 0xED, 0x04, 0xD1, 0x10, 0x7B, 0x12,
  0x0A, 0xA0, 0x71,
  // "ė" (U+0117)
  0x20, 0xB0, 0x27, 0x89, 0x07, 0xEC, 0x04, 0xE3, 0xE3, 0x8A, 0x89, 0x1A, 0x09, 0xB2, 0x20, 0x3D,
  0xE6, 0x10,
  // "Ę" (U+0118)
  0x10, 0xAA, 0x8A, 0x17, 0x0D, 0x51, 0x01, 0xFE, 0xD0, 0x4D, 0x11, 0x07, 0xB1, 0x20, 0xAA, 0x08,
  0x20, 0x20, 0xA3, 0x81, 0x2C, 0x11,
  // "ę" (U+0119)
  0x18, 0x90, 0x7E, 0xC0, 0x4E, 0x3E, 0x38, 0xA8, 0x91, 0xA0, 0x9B, 0x22, 0x03, 0xDF, 0x72, 0x02,
  0x09, 0x38, 0x14, 0xE1, 0x10,
  // "Ě" (U+011A)
  0x28, 0x28, 0x9A, 0x13, 0x01, 0x30, 0xAA, 0x07, 0x28, 0x1D, 0x51, 0x28, 0x21, 0xFE, 0xD2, 0x82,
  0x4D, 0x11, 0x28, 0x17, 0xB1, 0x30, 0xAA, 0x07, 0x20,
  // "ě" (U+011B)
  0x18, 0x28, 0x9A, 0x12, 0x01, 0x38, 0x90, 0x7E, 0xC0, 0x4E, 0x3E, 0x38, 0xA8, 0x91, 0xA0, 0x9B,
  0x22, 0x03, 0xDE, 0x61,
  // "Ĝ" (U+011C)
  0x28, 0x16, 0xB9, 0x38, 0x11, 0x01, 0x28, 0xB2, 0x1A, 0xED, 0x30, 0xD9, 0x22, 0x05, 0xE2, 0xEE,
  0x07, 0xB0, 0x6D, 0x06, 0xD2, 0x7B, 0x28, 0x2A, 0xED, 0x61,
  // "ĝ" (U+011D)
  0x18, 0x16, 0xB9, 0x28, 0x11, 0x01, 0x28, 0xB7, 0x9E, 0xA7, 0x4E, 0x3E, 0x58, 0x90, 0xE2, 0x9A,
  0x6E, 0x04, 0xEC, 0xB0, 0x31, 0xB7, 0x0B, 0xFB, 0x11,
  // "Ğ" (U+011E)
  0x28, 0x14, 0x04, 0x38, 0x1A, 0xF8, 0x40, 0x13, 0x8B, 0x21, 0xAE, 0xD3, 0x0D, 0x92, 0x20, 0x5E,
  0x2E, 0xE0, 0x7B, 0x06, 0xD0, 0x6D, 0x27, 0xB2, 0x82, 0xAE, 0xD6, 0x10,
  // "ğ" (U+011F)
  0x18, 0x14, 0x04, 0x28, 0x1A, 0xF8, 0x30, 0x13, 0x8B, 0x79, 0xEA, 0x74, 0xE3, 0xE5, 0x89, 0x0E,
  0x29, 0xA6, 0xE0, 0x4E, 0xCB, 0x03, 0x1B, 0x70, 0xBF, 0xB1, 0x10,
  // "Ġ" (U+0120)
  0x30, 0xB0, 0x27, 0x18, 0xB2, 0x1A, 0xED, 0x30, 0xD9, 0x22, 0x05, 0xE2, 0xEE, 0x07, 0xB0, 0x6D,
  0x06, 0xD2, 0x7B, 0x28, 0x2A, 0xED, 0x61,
  // "ġ" (U+0121)
  0x20, 0xB0, 0x27, 0x8B, 0x79, 0xEA, 0x74, 0xE3, 0xE5, 0x89, 0x0E, 0x29, 0xA6, 0xE0, 0x4E, 0xCB,
  0x03, 0x1B, 0x70, 0xBF, 0xB1, 0x10,
  // "Ģ" (U+0122)
  0x18, 0xB2, 0x1A, 0xED, 0x30, 0xD9, 0x22, 0x05, 0xE2, 0xEE, 0x07, 0xB0, 0x6D, 0x06, 0xD2, 0x7B,
  0x28, 0x2A, 0xED, 0x67, 0x10, 0x30, 0xA4, 0x01, 0x40,
  // "ģ" (U+0123)
  0x20, 0x40, 0xA7, 0x8B, 0x79, 0xEA, 0x74, 0xE3, 0xE5, 0x89, 0x0E, 0x29, 0xA6, 0xE0, 0x4E, 0xCB,
  0x03, 0x1B, 0x70, 0xBF, 0xB1, 0x10,
  // "Ĥ" (U+0124)
  0x28, 0x16, 0xB9, 0x38, 0x11, 0x01, 0x28, 0x92, 0xA7, 0x0A, 0x80, 0xD4, 0x0E, 0x51, 0xC8, 0xA0,
  0x24, 0xD2, 0x6E, 0x07, 0xA0, 0x7B, 0x0A, 0x70, 0xA8, 0x10,
  // "ĥ" (U+0125)
  0x18, 0x16, 0xB9, 0x28, 0x11, 0x01, 0x20, 0xA0, 0x83, 0x0D, 0x05, 0x39, 0x8A, 0x4B, 0xE2, 0x3F,
  0x4D, 0x66, 0xC0, 0xD4, 0x99, 0x1F, 0x1B, 0x64, 0xE1,
  // "Ħ" (U+0126)
  0x8A, 0x07, 0xFE, 0xDF, 0xE1, 0x0F, 0x30, 0xE3, 0x02, 0xFE, 0xE9, 0x28, 0x35, 0xD1, 0x6D, 0x28,
  0x38, 0xA0, 0x7A, 0x28, 0x3B, 0x70, 0xA8, 0x20,
  // "ħ" (U+0127)
  0x10, 0x90, 0x82, 0x82, 0x5F, 0xE7, 0x28, 0xA5, 0xEC, 0xE2, 0x2F, 0x4D, 0x55, 0xC0, 0xE3, 0x89,
  0x1F, 0x1B, 0x64, 0xD1,
  // "Ĩ" (U+0128)
  0x28, 0x3B, 0xED, 0x01, 0xA0, 0x52, 0x0A, 0x08, 0x30, 0xD0, 0x42, 0x81, 0x1F, 0x12, 0x04, 0x0E,
  0x28, 0x21, 0xEF, 0x41,
  // "ĩ" (U+0129)
  0x89, 0x7B, 0xED, 0x2F, 0x23, 0xE0, 0x6C, 0x09, 0x90, 0xB6, 0x10,
  // "Ī" (U+012A)
  0x28, 0x3E, 0xE5, 0x01, 0xA0, 0x52, 0x0A, 0x08, 0x30, 0xD0, 0x42, 0x81, 0x1F, 0x12, 0x04, 0x0E,
  0x28, 0x21, 0xEF, 0x41,
  // "ī" (U+012B)
  0x18, 0x7E, 0xE5, 0x0F, 0x40, 0x3E, 0x20, 0x60, 0xC2, 0x00, 0x92, 0x0B, 0x06, 0x20,
  // "Ĭ" (U+012C)
  0x28, 0x14, 0x04, 0x28, 0x1A, 0xF8, 0x30, 0x12, 0x01, 0xA0, 0x52, 0x0A, 0x08, 0x30, 0xD0, 0x42,
  0x81, 0x1F, 0x12, 0x04, 0x0E, 0x28, 0x21, 0xEF, 0x41,
  // "ĭ" (U+012D)
  0x86, 0x40, 0x4A, 0xF8, 0x01, 0x29, 0x89, 0x22, 0x3E, 0x06, 0xC0, 0x99, 0x0B, 0x61,
  // "Į" (U+012E)
  0x10, 0x1A, 0x05, 0x20, 0xA0, 0x83, 0x0D, 0x04, 0x28, 0x11, 0xF1, 0x20, 0x40, 0xE2, 0x82, 0x1E,
  0xF5, 0x20, 0x20, 0xA3, 0x81, 0x2C, 0x11,
  // "į" (U+012F)
  0x20, 0x90, 0x66, 0x98, 0x22, 0x03, 0xE2, 0x06, 0x0C, 0x20, 0x09, 0x28, 0x3C, 0x60, 0x2A, 0x28,
  0x12, 0xC1, 0x10,
  // "İ" (U+0130)
  0x30, 0xB0, 0x26, 0x01, 0xA0, 0x52, 0x0A, 0x08, 0x30, 0xD0, 0x42, 0x81, 0x1F, 0x12, 0x04, 0x0E,
  0x28, 0x21, 0xEF, 0x41,
  // "ı" (U+0131)
  0x19, 0x89, 0x22, 0x3E, 0x06, 0xC0, 0x99, 0x0B, 0x61,
  // "Ĳ" (U+0132)
  0x10, 0x1A, 0x81, 0x59, 0x92, 0x83, 0xA8, 0x0C, 0x62, 0x89, 0x0D, 0x40, 0xE3, 0x01, 0xF1, 0x29,
  0x28, 0x92, 0x4E, 0x05, 0xC0, 0x1E, 0xF4, 0x89, 0x50, 0xC0, 0x63, 0x81, 0x3F, 0xC5, 0x01, 0x30,
  // "ĳ" (U+0133)
  0x18, 0x29, 0x69, 0x66, 0x98, 0xA4, 0x2F, 0x23, 0xE3, 0xE0, 0x6C, 0x6B, 0x09, 0x99, 0x90, 0xB6,
  0xC6, 0x28, 0x12, 0xF2, 0x20, 0xE0, 0x92,
  // "Ĵ" (U+0134)
  0x38, 0x16, 0xB9, 0x38, 0x11, 0x01, 0x30, 0x09, 0x40, 0xC0, 0x64, 0x0E, 0x03, 0x30, 0x29, 0x40,
  0x50, 0xC4, 0x08, 0x09, 0x40, 0xC0, 0x62, 0x81, 0x3F, 0xC4, 0x01, 0x40,
  // "ĵ" (U+0135)
  0x18, 0x56, 0xB9, 0x01, 0x01, 0x29, 0x82, 0x20, 0x3E, 0x20, 0x60, 0xC2, 0x00, 0x92, 0x87, 0xC6,
  0x02, 0xF2, 0x0E, 0xA2,
  // "Ķ" (U+0136)
  0x18, 0x95, 0xA7, 0x3E, 0x30, 0xD5, 0xD7, 0x01, 0xFC, 0xA2, 0x82, 0x4F, 0xD8, 0x28, 0x27, 0xA5,
  0xD2, 0x83, 0xA7, 0x0F, 0x47, 0x10, 0x30, 0xA4, 0x01, 0x40,
  // "ķ" (U+0137)
  0x10, 0xA0, 0x73, 0x0D, 0x05, 0x39, 0x87, 0x2C, 0x73, 0xEA, 0x90, 0x6A, 0x89, 0x11, 0x09, 0xBC,
  0x70, 0xB6, 0x6D, 0x60, 0x30, 0xA3, 0x01, 0x40,
  // "ĸ" (U+0138)
  0x19, 0x87, 0x2C, 0x73, 0xE9, 0x90, 0x6A, 0x89, 0x11, 0x09, 0xBC, 0x70, 0xB6, 0x6D, 0x10,
  // "Ĺ" (U+0139)
  0x20, 0x20, 0x72, 0x83, 0xC4, 0x0A, 0x72, 0x87, 0xD4, 0x01, 0xF1, 0x04, 0xD2, 0x83, 0x7B, 0x11,
  0xAA, 0x07,
  // "ĺ" (U+013A)
  0x20, 0x20, 0x72, 0x83, 0xC4, 0x0A, 0x72, 0x0D, 0x05, 0x29, 0x82, 0x20, 0x3E, 0x20, 0x60, 0xC2,
  0x00, 0x92, 0x0B, 0x06, 0x20,
  // "Ļ" (U+013B)
  0x10, 0xA0, 0x72, 0x87, 0xD4, 0x01, 0xF1, 0x04, 0xD2, 0x83, 0x7B, 0x11, 0xAA, 0x07, 0x40, 0x30,
  0xA2, 0x01, 0x30,
  // "ļ" (U+013C)
  0x20, 0xA0, 0x72, 0x0D, 0x05, 0x29, 0x82, 0x20, 0x3E, 0x20, 0x60, 0xC2, 0x00, 0x92, 0x0B, 0x06,
  0x50, 0x30, 0xA2, 0x01, 0x30,
  // "Ľ" (U+013D)
  0x18, 0x5A, 0x7B, 0x30, 0xD4, 0x28, 0x11, 0xF1, 0x20, 0x40, 0xD3, 0x84, 0x7B, 0x11, 0x0A, 0xA0,
  0x71,
  // "ľ" (U+013E)
  0x18, 0x4A, 0xAC, 0x0D, 0x52, 0x98, 0x22, 0x03, 0xE2, 0x06, 0x0C, 0x20, 0x09, 0x20, 0xB0, 0x62,
  // "Ŀ" (U+013F)
  0x10, 0xA0, 0x73, 0x0D, 0x04, 0x28, 0x51, 0xF1, 0xB2, 0x4D, 0x38, 0x47, 0xB1, 0x10, 0xAA, 0x07,
  0x10,
  // "ŀ" (U+0140)
  0x10, 0xA0, 0x72, 0x0D, 0x05, 0x29, 0x86, 0x20, 0x3E, 0xB2, 0x6C, 0x20, 0x09, 0x20, 0xB0, 0x62,
  // "Ł" (U+0141)
  0x10, 0xA0, 0x72, 0x87, 0xD5, 0x01, 0xFD, 0x0C, 0xD2, 0x83, 0x7B, 0x11, 0xAA, 0x07,
  // "ł" (U+0142)
  0x18, 0xA1, 0x89, 0x0B, 0x60, 0xE5, 0x3F, 0x9C, 0xD0, 0x7A, 0x0A, 0x71,
  // "Ń" (U+0143)
  0x30, 0x20, 0x74, 0x0C, 0x04, 0x28, 0xC0, 0xAE, 0x01, 0xE0, 0xDE, 0x44, 0xC1, 0xE8, 0x87, 0x84,
  0xC3, 0xDA, 0x57, 0x90, 0xEE, 0x2A, 0x50, 0x9E, 0x10,
  // "ń" (U+0144)
  0x20, 0x20, 0x73, 0x0C, 0x04, 0x28, 0xA5, 0xE9, 0xE2, 0x3F, 0x4D, 0x66, 0xC0, 0xD4, 0x99, 0x1F,
  0x1B, 0x64, 0xE1,
  // "Ņ" (U+0145)
  0x18, 0xC0, 0xAE, 0x01, 0xE0, 0xDE, 0x44, 0xC1, 0xE8, 0x87, 0x84, 0xC3, 0xDA, 0x57, 0x90, 0xEE,
  0x2A, 0x50, 0x9E, 0x71, 0x03, 0x0A, 0x40, 0x14,
  // "ņ" (U+0146)
  0x18, 0xA5, 0xE9, 0xE2, 0x3F, 0x4D, 0x66, 0xC0, 0xD4, 0x99, 0x1F, 0x1B, 0x64, 0xE6, 0x03, 0x0A,
  0x30, 0x14,
  // "Ň" (U+0147)
  0x28, 0x28, 0x9A, 0x13, 0x01, 0x38, 0xC0, 0xAE, 0x01, 0xE0, 0xDE, 0x44, 0xC1, 0xE8, 0x87, 0x84,
  0xC3, 0xDA, 0x57, 0x90, 0xEE, 0x2A, 0x50, 0x9E, 0x10,
  // "ň" (U+0148)
  0x18, 0x28, 0x9A, 0x12, 0x01, 0x38, 0xA5, 0xE9, 0xE2, 0x3F, 0x4D, 0x66, 0xC0, 0xD4, 0x99, 0x1F,
  0x1B, 0x64, 0xE1,
  // "ŉ" (U+0149)
  0x10, 0xE0, 0x23, 0x8B, 0x35, 0xAE, 0x9E, 0x21, 0x4F, 0x4D, 0x60, 0x6C, 0x0D, 0x40, 0x99, 0x1F,
  0x10, 0xB6, 0x4E, 0x10,
  // "Ŋ" (U+014A)
  0x18, 0xB7, 0xAD, 0x01, 0xF0, 0xDE, 0x34, 0xC1, 0xE8, 0x97, 0x94, 0xC2, 0xEB, 0x67, 0x90, 0xCF,
  0x3A, 0x50, 0x69, 0x40, 0x70, 0xC3, 0x81, 0xDE, 0x43, 0x01, 0x30,
  // "ŋ" (U+014B)
  0x18, 0xA5, 0xD9, 0xE2, 0x3F, 0x4D, 0x66, 0xC0, 0xE4, 0x99, 0x1F, 0x1B, 0x64, 0xD3, 0x09, 0x0A,
  0x28, 0x18, 0xE3, 0x10,
  // "Ō" (U+014C)
  0x38, 0x97, 0xEE, 0x50, 0x2C, 0xFD, 0x10, 0xD8, 0x2D, 0x75, 0xE2, 0x82, 0xA8, 0x7B, 0x28, 0x5D,
  0x66, 0xD2, 0x6E, 0x28, 0x2A, 0xED, 0x31,
  // "ō" (U+014D)
  0x28, 0xB1, 0xEE, 0x50, 0x8F, 0xD0, 0x4E, 0x3E, 0x48, 0x90, 0xE3, 0x8A, 0x5E, 0x02, 0xDD, 0x51,
  // "Ŏ" (U+014E)
  0x28, 0x14, 0x04, 0x38, 0x1A, 0xF8, 0x40, 0x13, 0x89, 0x32, 0xCE, 0xB1, 0x0D, 0x82, 0xD7, 0x5E,
  0x28, 0x2A, 0x87, 0xB2, 0x85, 0xD6, 0x6D, 0x26, 0xE2, 0x82, 0xAE, 0xD3, 0x10,
  // "ŏ" (U+014F)
  0x18, 0x14, 0x04, 0x28, 0x1A, 0xF8, 0x30, 0x13, 0x8A, 0x58, 0xEB, 0x04, 0xE3, 0xE4, 0x89, 0x0E,
  0x38, 0xA5, 0xE0, 0x2D, 0xD5, 0x10,
  // "Ő" (U+0150)
  0x38, 0x28, 0x8B, 0x23, 0x00, 0x13, 0x83, 0x2C, 0xEB, 0x12, 0x86, 0xD8, 0x2D, 0x70, 0x5E, 0x28,
  0x3A, 0x80, 0x7B, 0x28, 0x6D, 0x60, 0x6D, 0x26, 0xE3, 0x82, 0xAE, 0xD3, 0x20,
  // "ő" (U+0151)
  0x28, 0x28, 0x8B, 0x22, 0x00, 0x13, 0x81, 0x8E, 0xB2, 0x89, 0x64, 0xE3, 0xE4, 0x08, 0x90, 0xE3,
  0x08, 0xA5, 0xE2, 0x82, 0x2D, 0xD5, 0x20,
  // "Œ" (U+0152)
  0x10, 0x20, 0xCC, 0x8B, 0x55, 0x0D, 0x82, 0xF3, 0x10, 0x5E, 0x03, 0xFE, 0xB0, 0x7B, 0x06, 0xB1,
  0x10, 0x6D, 0x1A, 0x91, 0x30, 0xAC, 0x05, 0x10,
  // "œ" (U+0153)
  0x18, 0x95, 0x9E, 0x9B, 0xE7, 0x5D, 0x3F, 0x97, 0xC9, 0x91, 0xA8, 0x96, 0xE5, 0x9A, 0x5F, 0x62,
  0x13, 0xDD, 0x9E, 0xD2,
  // "Ŕ" (U+0154)
  0x30, 0x20, 0x73, 0x89, 0x3C, 0x40, 0xAF, 0xD4, 0x0D, 0x4B, 0x91, 0xA8, 0x97, 0xC2, 0x4C, 0x99,
  0x07, 0x94, 0xE0, 0xA7, 0x0F, 0x40,
  // "ŕ" (U+0155)
  0x20, 0x20, 0x72, 0x89, 0x2C, 0x40, 0xEA, 0x83, 0xF4, 0x06, 0xC2, 0x00, 0x92, 0x0B, 0x06, 0x20,
  // "Ŗ" (U+0156)
  0x18, 0x90, 0xAF, 0xD4, 0x0D, 0x4B, 0x91, 0xA8, 0x97, 0xC2, 0x4C, 0x99, 0x07, 0x94, 0xE0, 0xA7,
  0x0F, 0x46, 0x03, 0x0A, 0x30, 0x13,
  // "ŗ" (U+0157)
  0x28, 0x5E, 0xA8, 0x03, 0xF4, 0x20, 0x60, 0xC3, 0x00, 0x93, 0x0B, 0x06, 0x70, 0x30, 0xA3, 0x01,
  0x40,
  // "Ř" (U+0158)
  0x28, 0x28, 0x9A, 0x13, 0x01, 0x38, 0x2A, 0xFD, 0x42, 0x84, 0xD4, 0xB9, 0x01, 0xA8, 0x5C, 0x20,
  0x4C, 0x99, 0x28, 0x27, 0x94, 0xE2, 0x83, 0xA7, 0x0F, 0x41,
  // "ř" (U+0159)
  0x18, 0x28, 0x9A, 0x12, 0x01, 0x38, 0x5E, 0xA8, 0x03, 0xF4, 0x20, 0x60, 0xC3, 0x00, 0x93, 0x0B,
  0x06, 0x30,
  // "Ś" (U+015A)
  0x20, 0x20, 0x73, 0x0C, 0x04, 0x28, 0x68, 0xED, 0x21, 0xF3, 0x32, 0x0E, 0x09, 0x38, 0x93, 0x2D,
  0x70, 0x31, 0xAA, 0x0A, 0xFC, 0x21,
  // "ś" (U+015B)
  0x20, 0x20, 0x72, 0x8A, 0x3C, 0x42, 0xDE, 0x56, 0xD2, 0x11, 0xCC, 0x03, 0x2F, 0x2C, 0xFA, 0x10,
  // "Ŝ" (U+015C)
  0x18, 0x16, 0xB9, 0x28, 0x11, 0x01, 0x28, 0x68, 0xED, 0x21, 0xF3, 0x32, 0x0E, 0x09, 0x38, 0x93,
  0x2D, 0x70, 0x31, 0xAA, 0x0A, 0xFC, 0x21,
  // "ŝ" (U+015D)
  0x18, 0xB0, 0x6B, 0x90, 0x10, 0x12, 0xDE, 0x56, 0xD2, 0x11, 0xCC, 0x03, 0x2F, 0x2C, 0xFA, 0x10,
  // "Ş" (U+015E)
  0x18, 0x68, 0xED, 0x21, 0xF3, 0x32, 0x0E, 0x09, 0x38, 0x96, 0x2D, 0x70, 0x31, 0xAA, 0x0B, 0xFC,
  0x20, 0x2C, 0x30, 0x90, 0xA3,
  // "ş" (U+015F)
  0x8A, 0x42, 0xDE, 0x56, 0xD2, 0x11, 0xCC, 0x03, 0x2F, 0x2C, 0xFA, 0x02, 0xC2, 0x09, 0x0A, 0x20,
  // "Š" (U+0160)
  0x18, 0x28, 0x9A, 0x12, 0x01, 0x38, 0x68, 0xED, 0x21, 0xF3, 0x32, 0x0E, 0x09, 0x38, 0x93, 0x2D,
  0x70, 0x31, 0xAA, 0x0A, 0xFC, 0x21,
  // "š" (U+0161)
  0x18, 0x28, 0x9A, 0x12, 0x01, 0x28, 0x93, 0x2D, 0xE5, 0x06, 0xD2, 0x10, 0x1C, 0xC2, 0x86, 0x32,
  0xF2, 0x0C, 0xFA, 0x20,
  // "Ţ" (U+0162)
  0x03, 0xB8, 0x3B, 0x01, 0xF2, 0x20, 0x30, 0xE3, 0x07, 0x0B, 0x30, 0xA0, 0x83, 0x0E, 0x05, 0x20,
  0x20, 0xC3, 0x09, 0x0A, 0x30,
  // "ţ" (U+0163)
  0x18, 0x27, 0x60, 0x6A, 0x85, 0x52, 0xF1, 0x05, 0xD2, 0x89, 0x07, 0xB1, 0x05, 0xF9, 0x02, 0xC2,
  0x09, 0x0A, 0x20,
  // "Ť" (U+0164)
  0x18, 0x28, 0x9A, 0x12, 0x01, 0x20, 0x3B, 0x83, 0xB0, 0x1F, 0x22, 0x03, 0x0E, 0x30, 0x70, 0xB3,
  0x0A, 0x08, 0x30, 0xD0, 0x52,
  // "ť" (U+0165)
  0x38, 0x3C, 0x10, 0x76, 0x20, 0x6A, 0x83, 0x50, 0x2F, 0x12, 0x05, 0x0D, 0x38, 0x17, 0xB1, 0x28,
  0x15, 0xE9, 0x20,
  // "Ŧ" (U+0166)
  0x03, 0xB8, 0x90, 0xB0, 0x2F, 0x20, 0x3E, 0xFA, 0x28, 0x19, 0xA1, 0x20, 0xA0, 0x73, 0x0D, 0x04,
  0x20,
  // "ŧ" (U+0167)
  0x18, 0x27, 0x60, 0x6A, 0x89, 0x65, 0x2F, 0x10, 0xBF, 0xB0, 0x7C, 0x20, 0x5E, 0x91,
  // "Ũ" (U+0168)
  0x28, 0x1B, 0xED, 0x28, 0xB7, 0xB9, 0x1B, 0x70, 0xE3, 0x0E, 0x42, 0xF0, 0x1F, 0x15, 0xD0, 0x5D,
  0x06, 0xD2, 0xB8, 0x01, 0xCF, 0xB2,
  // "ũ" (U+0169)
  0x28, 0xB1, 0xBE, 0xD1, 0xF3, 0xA9, 0x3E, 0x0B, 0x66, 0xB0, 0xE3, 0x8A, 0x6F, 0x04, 0xE9, 0xD1,
  // "Ū" (U+016A)
  0x28, 0x1E, 0xE5, 0x28, 0xB7, 0xB9, 0x1B, 0x70, 0xE3, 0x0E, 0x42, 0xF0, 0x1F, 0x15, 0xD0, 0x5D,
  0x06, 0xD2, 0xB8, 0x01, 0xCF, 0xB2,
  // "ū" (U+016B)
  0x28, 0xB1, 0xEE, 0x51, 0xF3, 0xA9, 0x3E, 0x0B, 0x66, 0xB0, 0xE3, 0x8A, 0x6F, 0x04, 0xE9, 0xD1,
  // "Ŭ" (U+016C)
  0x28, 0x14, 0x04, 0x38, 0x1A, 0xF8, 0x40, 0x13, 0x8B, 0x7B, 0x70, 0xA7, 0x0E, 0x30, 0xE4, 0x2F,
  0x01, 0xF1, 0x5D, 0x05, 0xD0, 0x6D, 0x2B, 0x80, 0x1C, 0xFB, 0x20,
  // "ŭ" (U+016D)
  0x28, 0x14, 0x04, 0x28, 0x1A, 0xF8, 0x38, 0xB0, 0x10, 0x1F, 0x19, 0x93, 0xE0, 0xB6, 0x6B, 0x0E,
  0x38, 0xA6, 0xF0, 0x4E, 0x9D, 0x10,
  // "Ů" (U+016E)
  0x30, 0x70, 0x94, 0x07, 0x08, 0x28, 0xB7, 0xB7, 0x0A, 0x70, 0xE3, 0x0E, 0x42, 0xF0, 0x1F, 0x15,
  0xD0, 0x5D, 0x06, 0xD2, 0xB8, 0x01, 0xCF, 0xB2,
  // "ů" (U+016F)
  0x20, 0x70, 0x93, 0x8B, 0x17, 0x80, 0x1F, 0x19, 0x93, 0xE0, 0xB6, 0x6B, 0x0E, 0x38, 0xA6, 0xF0,
  0x4E, 0x9D, 0x10,
  // "Ű" (U+0170)
  0x28, 0x28, 0x8B, 0x22, 0x00, 0x13, 0x8B, 0x7B, 0x70, 0xA7, 0x0E, 0x30, 0xE4, 0x2F, 0x01, 0xF1,
  0x5D, 0x05, 0xD0, 0x6D, 0x2B, 0x80, 0x1C, 0xFB, 0x20,
  // "ű" (U+0171)
  0x28, 0x28, 0x8B, 0x22, 0x00, 0x12, 0x8A, 0x31, 0xF1, 0x99, 0x03, 0xE0, 0xB6, 0x06, 0xB0, 0xE3,
  0x08, 0xA6, 0x92, 0x82, 0x4E, 0x9D, 0x20,
  // "Ų" (U+0172)
  0x18, 0xB7, 0xB7, 0x0A, 0x70, 0xE3, 0x0E, 0x42, 0xF0, 0x1F, 0x15, 0xD0, 0x5D, 0x06, 0xD2, 0xB8,
  0x01, 0xCF, 0xB3, 0x02, 0x0A, 0x48, 0x12, 0xC1, 0x20,
  // "ų" (U+0173)
  0x8A, 0x61, 0xF1, 0x99, 0x3E, 0x0B, 0x66, 0xB0, 0xE3, 0x8A, 0x6F, 0x04, 0xE9, 0xD2, 0x02, 0x0A,
  0x38, 0x12, 0xC1, 0x10,
  // "Ŵ" (U+0174)
  0x38, 0x16, 0xB9, 0x58, 0x11, 0x01, 0x28, 0xC4, 0x4D, 0x07, 0xD0, 0x7A, 0x3D, 0x0D, 0xD0, 0xD4,
  0x3D, 0x4B, 0xD4, 0xD0, 0x2D, 0xB5, 0xEA, 0x60, 0x2E, 0xD0, 0xEE, 0x28, 0x41, 0xF6, 0x0F, 0x92,
  // "ŵ" (U+0175)
  0x28, 0x16, 0xB9, 0x48, 0x11, 0x01, 0x28, 0xB7, 0x79, 0x4F, 0x2A, 0x77, 0x9A, 0xD4, 0xE1, 0x6A,
  0xDA, 0x9A, 0x05, 0xE8, 0xAE, 0x40, 0x5F, 0x2A, 0xD2,
  // "Ŷ" (U+0176)
  0x18, 0x16, 0xB9, 0x28, 0xA0, 0x10, 0x10, 0x2F, 0x06, 0xD0, 0xD4, 0xE4, 0x0A, 0xE9, 0x28, 0x16,
  0xE1, 0x20, 0x70, 0xA3, 0x0B, 0x07, 0x20,
  // "ŷ" (U+0177)
  0x28, 0x16, 0xB9, 0x38, 0x11, 0x01, 0x28, 0x90, 0x89, 0x0E, 0x50, 0x6A, 0x5D, 0x28, 0x24, 0xCC,
  0x52, 0x81, 0x2E, 0xD4, 0x90, 0x63, 0x06, 0x0D, 0x38, 0x18, 0xD4, 0x30,
  // "Ÿ" (U+0178)
  0x18, 0x23, 0x8A, 0x15, 0x89, 0x42, 0xF0, 0x6D, 0x0D, 0x4E, 0x40, 0xAE, 0x92, 0x81, 0x6E, 0x12,
  0x07, 0x0A, 0x30, 0xB0, 0x72,
  // "Ź" (U+0179)
  0x30, 0x20, 0x74, 0x0C, 0x04, 0x20, 0x1B, 0x09, 0x28, 0x21, 0x6E, 0x12, 0x81, 0x2E, 0x43, 0x0C,
  0x08, 0x38, 0x19, 0xC1, 0x20, 0x2B, 0x0A, 0x10,
  // "ź" (U+017A)
  0x30, 0x20, 0x73, 0x82, 0xC4, 0x03, 0xA0, 0xA2, 0x81, 0x3E, 0x32, 0x0C, 0x06, 0x28, 0x38, 0xB1,
  0x01, 0xB1,
  // "Ż" (U+017B)
  0x30, 0xB0, 0x27, 0x10, 0x1B, 0x09, 0x28, 0x21, 0x6E, 0x12, 0x81, 0x2E, 0x43, 0x0C, 0x08, 0x38,
  0x19, 0xC1, 0x20, 0x2B, 0x0A, 0x10,
  // "ż" (U+017C)
  0x30, 0xB0, 0x26, 0x03, 0xA0, 0xA2, 0x81, 0x3E, 0x32, 0x0C, 0x06, 0x28, 0x38, 0xB1, 0x01, 0xB1,
  // "Ž" (U+017D)
  0x38, 0x28, 0x9A, 0x14, 0x01, 0x30, 0x1B, 0x09, 0x38, 0x21, 0x6E, 0x13, 0x81, 0x2E, 0x44, 0x0C,
  0x08, 0x48, 0x19, 0xC1, 0x30, 0x2B, 0x0A, 0x20,
  // "ž" (U+017E)
  0x28, 0x28, 0x9A, 0x13, 0x01, 0x30, 0x3A, 0x0A, 0x38, 0x13, 0xE3, 0x30, 0xC0, 0x63, 0x81, 0x8B,
  0x12, 0x01, 0xB2,
  // "ſ" (U+017F)
  0x28, 0x14, 0xE9, 0x28, 0x1B, 0x71, 0x20, 0xE0, 0x32, 0x02, 0x93, 0x05, 0x0D, 0x30, 0x80, 0xA3,
  0x0B, 0x07, 0x28, 0x12, 0xE3, 0x20, 0xE0, 0xA3,
  // "Ω" (U+03A9)
  0x28, 0x95, 0x4C, 0xFB, 0x10, 0x1E, 0x61, 0xC9, 0x05, 0xD2, 0x83, 0x8A, 0x05, 0xC2, 0x89, 0x0B,
  0x60, 0x1D, 0x26, 0xA0, 0x1A, 0x04, 0xA0, 0x50,
  // "μ" (U+03BC)
  0x29, 0x8B, 0x02, 0x8A, 0x03, 0xE0, 0xB7, 0x06, 0xC0, 0xE4, 0x09, 0xB4, 0xF1, 0x0C, 0xEA, 0xE2,
  0x0E, 0x03, 0x30, 0x29, 0x40,
  // "π" (U+03C0)
  0x06, 0xC8, 0x4C, 0x0C, 0x68, 0xA2, 0x89, 0x7E, 0x3B, 0x70, 0x2F, 0x0D, 0x60, 0x5D, 0x0A, 0xE1,
  // "–" (U+2013)
  0x82, 0xAE, 0xE8, 0x0F, 0x11,
  // "—" (U+2014)
  0x0A, 0x80, 0x2E, 0x06, 0x80, 0x31, 0x10,
  // "€" (U+20AC)
  0x18, 0x95, 0x1A, 0xE9, 0x09, 0xB1, 0x17, 0xFE, 0x80, 0xBA, 0x84, 0x20, 0x4F, 0x42, 0x28, 0x1A,
  0xFA, 0x10,
  // "₿" (U+20BF)
  0x20, 0x07, 0x28, 0x90, 0xAF, 0xE2, 0x0D, 0x4E, 0x51, 0xA8, 0xA2, 0xA0, 0x4C, 0x6E, 0x07, 0x96,
  0xE0, 0xAF, 0xE5, 0x02, 0x65, 0x20,
  // "‘" (U+2018)
  0x18, 0x5C, 0x24, 0xC0, 0x11, 0x10,
  // "’" (U+2019)
  0x18, 0x4E, 0x25, 0xA0, 0x12,
  // "‚" (U+201A)
  0x18, 0x51, 0x10, 0xD3, 0x3B, 0x10,
  // "‛" (U+201B)
  0x84, 0x1E, 0x0E, 0x01,
  // "“" (U+201C)
  0x18, 0x5C, 0x4D, 0x4C, 0x88, 0x0F, 0x11,
  // "”" (U+201D)
  0x18, 0x90, 0xE6, 0xD5, 0xA9, 0x61, 0x01, 0x10,
  // "„" (U+201E)
  0x18, 0x91, 0x11, 0x20, 0xD5, 0xE3, 0xB7, 0x70,
  // "‟" (U+201F)
  0x89, 0x21, 0xE6, 0x90, 0xD3, 0xA0, 0x10, 0x10,
  // "†" (U+2020)
  0x28, 0x93, 0xC3, 0x01, 0xC2, 0x2C, 0xEC, 0x03, 0x82, 0x07, 0x05, 0x20, 0xB0, 0x32, 0x0E, 0x01,
  0x10,
  // "‡" (U+2021)
  0x28, 0xA7, 0xB3, 0x05, 0xC5, 0x2A, 0xD9, 0x04, 0xA0, 0x5A, 0xB4, 0x4B, 0x73, 0x0D, 0x11,
  // "•" (U+2022)
  0x87, 0x2C, 0x56, 0xFB, 0x3E, 0x70,
  // "…" (U+2026)
  0x84, 0xB4, 0xB4, 0xB4,
  // "‰" (U+2030)
  0x84, 0x1C, 0xD1, 0x3A, 0x48, 0x47, 0x9D, 0x2C, 0x14, 0x8C, 0x56, 0xFA, 0x9B, 0xD4, 0x8D, 0x20,
  0x15, 0xAE, 0x8A, 0xD9, 0x60, 0x1C, 0x3C, 0xAA, 0xBB, 0x40, 0xB3, 0x0D, 0xB2, 0xEA, 0x10,
  // "‹" (U+2039)
  0x18, 0x59, 0x47, 0xC0, 0x6B, 0x20, 0x61,
  // "›" (U+203A)
  0x03, 0x0B, 0x29, 0x83, 0x28, 0xB0, 0x52,
  // "⁄" (U+2044)
  0x30, 0x30, 0xB3, 0x0C, 0x01, 0x20, 0x90, 0x52, 0x04, 0x09, 0x20, 0x10, 0xC3, 0x0A, 0x03, 0x30,
  // "™" (U+2122)
  0x8A, 0x66, 0x86, 0x52, 0x61, 0x76, 0x86, 0x81, 0x76, 0x76, 0x80, 0x11, 0x01, 0x10,
  // "⅒" (U+2152)
  0x30, 0x30, 0xB4, 0x83, 0x8E, 0x0C, 0x14, 0x82, 0x6B, 0x95, 0x28, 0xB3, 0x7C, 0x37, 0xCA, 0x8E,
  0x1D, 0x77, 0x1C, 0x16, 0xB3, 0xBA, 0x4A, 0x30, 0x77, 0x0C, 0xA1,
  // "ﬁ" (U+FB01)
  0x28, 0x33, 0xDA, 0x96, 0x28, 0x19, 0x91, 0x30, 0x5A, 0x87, 0x3F, 0x20, 0x1F, 0x33, 0xE2, 0x83,
  0x3E, 0x06, 0xC2, 0x83, 0x6B, 0x09, 0x92, 0x87, 0x98, 0x0B, 0x60, 0x1D, 0x54, 0x0C, 0x0B, 0x50,
  // "ﬂ" (U+FB02)
  0x28, 0x33, 0xDA, 0xA7, 0x28, 0x59, 0x91, 0xD5, 0x05, 0xA8, 0x73, 0xF2, 0x01, 0xF3, 0x3E, 0x28,
  0x33, 0xE0, 0x6C, 0x28, 0x36, 0xB0, 0x99, 0x28, 0x79, 0x80, 0xB6, 0x01, 0xD5, 0x40, 0xC0, 0xB5,
};

const Font& font_NotoSans_BoldItalic_8() {
  static SmoothFont font(font_NotoSans_BoldItalic_8_data);
  return font;
}

}  // namespace roo_display
