#include "8.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSans-Bold (Noto Sans Bold)
// Generated on Thu Mar 30 22:28:08 CEST 2023
static const uint8_t font_NotoSans_Bold_8_data[] PROGMEM = {
  
  // Header
  0x01, 0x01, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x01, 0xE0,
  0xFE, 0xFE, 0x09, 0x09, 0x07, 0xFE, 0x03, 0x01, 0x0A, 0x03, 0x02, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x00, 0x01, 0x01, 0x06, 0x02, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x00, 0x04, 0x03, 0x06, 0x04, 0x00, 0x08, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x04, 0x06, 0x05, 0x00, 0x10, // "#" (U+0023)
  0x00, 0x24, 0x00, 0x01, 0x04, 0x07, 0x05, 0x00, 0x21, // "$" (U+0024)
  0x00, 0x25, 0x00, 0x01, 0x06, 0x06, 0x07, 0x00, 0x35, // "%" (U+0025)
  0x00, 0x26, 0x00, 0x01, 0x05, 0x06, 0x06, 0x00, 0x4E, // "&" (U+0026)
  0x00, 0x27, 0x00, 0x04, 0x01, 0x06, 0x02, 0x00, 0x63, // "'" (U+0027)
  0x00, 0x28, 0x00, 0x00, 0x02, 0x06, 0x03, 0x00, 0x67, // "(" (U+0028)
  0x00, 0x29, 0x00, 0x00, 0x02, 0x06, 0x03, 0x00, 0x74, // ")" (U+0029)
  0x00, 0x2A, 0x00, 0x04, 0x03, 0x07, 0x04, 0x00, 0x81, // "*" (U+002A)
  0x00, 0x2B, 0x00, 0x02, 0x04, 0x05, 0x05, 0x00, 0x8B, // "+" (U+002B)
  0x00, 0x2C, 0x00, 0x00, 0x01, 0x02, 0x02, 0x00, 0x97, // "," (U+002C)
  0x00, 0x2D, 0x00, 0x02, 0x02, 0x03, 0x03, 0x00, 0x9B, // "-" (U+002D)
  0x00, 0x2E, 0x00, 0x01, 0x01, 0x01, 0x02, 0x00, 0x9F, // "." (U+002E)
  0x00, 0x2F, 0x00, 0x01, 0x03, 0x06, 0x03, 0x00, 0xA1, // "/" (U+002F)
  0x00, 0x30, 0x00, 0x01, 0x04, 0x06, 0x05, 0x00, 0xAF, // "0" (U+0030)
  0x00, 0x31, 0x00, 0x01, 0x03, 0x06, 0x05, 0x00, 0xC0, // "1" (U+0031)
  0x00, 0x32, 0x00, 0x01, 0x04, 0x06, 0x05, 0x00, 0xCF, // "2" (U+0032)
  0x00, 0x33, 0x00, 0x01, 0x04, 0x06, 0x05, 0x00, 0xE1, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x01, 0x04, 0x06, 0x05, 0x00, 0xF3, // "4" (U+0034)
  0x00, 0x35, 0x00, 0x01, 0x04, 0x06, 0x05, 0x01, 0x04, // "5" (U+0035)
  0x00, 0x36, 0x00, 0x01, 0x04, 0x06, 0x05, 0x01, 0x15, // "6" (U+0036)
  0x00, 0x37, 0x00, 0x01, 0x04, 0x06, 0x05, 0x01, 0x26, // "7" (U+0037)
  0x00, 0x38, 0x00, 0x01, 0x04, 0x06, 0x05, 0x01, 0x36, // "8" (U+0038)
  0x00, 0x39, 0x00, 0x01, 0x04, 0x06, 0x05, 0x01, 0x47, // "9" (U+0039)
  0x00, 0x3A, 0x00, 0x01, 0x01, 0x05, 0x02, 0x01, 0x58, // ":" (U+003A)
  0x00, 0x3B, 0x00, 0x00, 0x01, 0x05, 0x02, 0x01, 0x5D, // ";" (U+003B)
  0x00, 0x3C, 0x00, 0x02, 0x04, 0x05, 0x05, 0x01, 0x63, // "<" (U+003C)
  0x00, 0x3D, 0x00, 0x02, 0x04, 0x05, 0x05, 0x01, 0x6E, // "=" (U+003D)
  0x00, 0x3E, 0x00, 0x02, 0x04, 0x05, 0x05, 0x01, 0x7A, // ">" (U+003E)
  0x00, 0x3F, 0x00, 0x01, 0x03, 0x06, 0x04, 0x01, 0x85, // "?" (U+003F)
  0x00, 0x40, 0x00, 0xFF, 0x06, 0x06, 0x07, 0x01, 0x93, // "@" (U+0040)
  0x00, 0x41, 0x00, 0x01, 0x05, 0x06, 0x06, 0x01, 0xB0, // "A" (U+0041)
  0x00, 0x42, 0x00, 0x01, 0x04, 0x06, 0x05, 0x01, 0xC4, // "B" (U+0042)
  0x00, 0x43, 0x00, 0x01, 0x04, 0x06, 0x05, 0x01, 0xD5, // "C" (U+0043)
  0x00, 0x44, 0x00, 0x01, 0x05, 0x06, 0x06, 0x01, 0xE6, // "D" (U+0044)
  0x00, 0x45, 0x00, 0x01, 0x03, 0x06, 0x04, 0x01, 0xFB, // "E" (U+0045)
  0x00, 0x46, 0x00, 0x01, 0x03, 0x06, 0x04, 0x02, 0x07, // "F" (U+0046)
  0x00, 0x47, 0x00, 0x01, 0x05, 0x06, 0x06, 0x02, 0x14, // "G" (U+0047)
  0x00, 0x48, 0x00, 0x01, 0x05, 0x06, 0x06, 0x02, 0x28, // "H" (U+0048)
  0x00, 0x49, 0x00, 0x01, 0x02, 0x06, 0x03, 0x02, 0x3E, // "I" (U+0049)
  0x00, 0x4A, 0xFF, 0xFF, 0x01, 0x06, 0x03, 0x02, 0x49, // "J" (U+004A)
  0x00, 0x4B, 0x00, 0x01, 0x05, 0x06, 0x05, 0x02, 0x57, // "K" (U+004B)
  0x00, 0x4C, 0x00, 0x01, 0x04, 0x06, 0x05, 0x02, 0x6C, // "L" (U+004C)
  0x00, 0x4D, 0x00, 0x01, 0x06, 0x06, 0x08, 0x02, 0x7C, // "M" (U+004D)
  0x00, 0x4E, 0x00, 0x01, 0x05, 0x06, 0x07, 0x02, 0x93, // "N" (U+004E)
  0x00, 0x4F, 0x00, 0x01, 0x05, 0x06, 0x06, 0x02, 0xA7, // "O" (U+004F)
  0x00, 0x50, 0x00, 0x01, 0x04, 0x06, 0x05, 0x02, 0xBC, // "P" (U+0050)
  0x00, 0x51, 0x00, 0xFF, 0x05, 0x06, 0x06, 0x02, 0xCD, // "Q" (U+0051)
  0x00, 0x52, 0x00, 0x01, 0x05, 0x06, 0x05, 0x02, 0xE8, // "R" (U+0052)
  0x00, 0x53, 0x00, 0x01, 0x03, 0x06, 0x04, 0x02, 0xFD, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x04, 0x06, 0x05, 0x03, 0x0C, // "T" (U+0054)
  0x00, 0x55, 0x00, 0x01, 0x05, 0x06, 0x06, 0x03, 0x1C, // "U" (U+0055)
  0x00, 0x56, 0x00, 0x01, 0x04, 0x06, 0x05, 0x03, 0x32, // "V" (U+0056)
  0x00, 0x57, 0x00, 0x01, 0x07, 0x06, 0x08, 0x03, 0x43, // "W" (U+0057)
  0x00, 0x58, 0x00, 0x01, 0x05, 0x06, 0x05, 0x03, 0x5E, // "X" (U+0058)
  0x00, 0x59, 0x00, 0x01, 0x04, 0x06, 0x05, 0x03, 0x73, // "Y" (U+0059)
  0x00, 0x5A, 0x00, 0x01, 0x04, 0x06, 0x05, 0x03, 0x85, // "Z" (U+005A)
  0x00, 0x5B, 0x00, 0xFE, 0x02, 0x06, 0x03, 0x03, 0x96, // "[" (U+005B)
  0x00, 0x5C, 0x00, 0x01, 0x03, 0x06, 0x03, 0x03, 0xA5, // "\" (U+005C)
  0x00, 0x5D, 0x00, 0xFE, 0x02, 0x06, 0x03, 0x03, 0xB4, // "]" (U+005D)
  0x00, 0x5E, 0x00, 0x03, 0x04, 0x06, 0x05, 0x03, 0xC3, // "^" (U+005E)
  0x00, 0x5F, 0x00, 0xFF, 0x03, 0xFF, 0x03, 0x03, 0xCF, // "_" (U+005F)
  0x00, 0x60, 0x00, 0x06, 0x02, 0x07, 0x03, 0x03, 0xD2, // "`" (U+0060)
  0x00, 0x61, 0x00, 0x01, 0x04, 0x05, 0x05, 0x03, 0xD7, // "a" (U+0061)
  0x00, 0x62, 0x00, 0x01, 0x04, 0x07, 0x05, 0x03, 0xE6, // "b" (U+0062)
  0x00, 0x63, 0x00, 0x01, 0x03, 0x05, 0x04, 0x03, 0xF9, // "c" (U+0063)
  0x00, 0x64, 0x00, 0x01, 0x04, 0x07, 0x05, 0x04, 0x05, // "d" (U+0064)
  0x00, 0x65, 0x00, 0x01, 0x04, 0x05, 0x05, 0x04, 0x17, // "e" (U+0065)
  0x00, 0x66, 0x00, 0x01, 0x03, 0x07, 0x03, 0x04, 0x25, // "f" (U+0066)
  0x00, 0x67, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x04, 0x34, // "g" (U+0067)
  0x00, 0x68, 0x00, 0x01, 0x04, 0x07, 0x05, 0x04, 0x47, // "h" (U+0068)
  0x00, 0x69, 0x00, 0x01, 0x01, 0x07, 0x02, 0x04, 0x5A, // "i" (U+0069)
  0x00, 0x6A, 0xFF, 0xFF, 0x01, 0x07, 0x02, 0x04, 0x63, // "j" (U+006A)
  0x00, 0x6B, 0x00, 0x01, 0x04, 0x07, 0x05, 0x04, 0x72, // "k" (U+006B)
  0x00, 0x6C, 0x00, 0x01, 0x01, 0x07, 0x02, 0x04, 0x86, // "l" (U+006C)
  0x00, 0x6D, 0x00, 0x01, 0x07, 0x05, 0x08, 0x04, 0x8F, // "m" (U+006D)
  0x00, 0x6E, 0x00, 0x01, 0x04, 0x05, 0x05, 0x04, 0xA5, // "n" (U+006E)
  0x00, 0x6F, 0x00, 0x01, 0x04, 0x05, 0x05, 0x04, 0xB3, // "o" (U+006F)
  0x00, 0x70, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x04, 0xC1, // "p" (U+0070)
  0x00, 0x71, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x04, 0xD3, // "q" (U+0071)
  0x00, 0x72, 0x00, 0x01, 0x03, 0x05, 0x04, 0x04, 0xE6, // "r" (U+0072)
  0x00, 0x73, 0x00, 0x01, 0x03, 0x05, 0x04, 0x04, 0xF2, // "s" (U+0073)
  0x00, 0x74, 0x00, 0x01, 0x03, 0x06, 0x03, 0x04, 0xFE, // "t" (U+0074)
  0x00, 0x75, 0x00, 0x01, 0x04, 0x05, 0x05, 0x05, 0x0D, // "u" (U+0075)
  0x00, 0x76, 0x00, 0x01, 0x04, 0x05, 0x05, 0x05, 0x1B, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x01, 0x06, 0x05, 0x07, 0x05, 0x2A, // "w" (U+0077)
  0x00, 0x78, 0x00, 0x01, 0x04, 0x05, 0x05, 0x05, 0x3E, // "x" (U+0078)
  0x00, 0x79, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x05, 0x4D, // "y" (U+0079)
  0x00, 0x7A, 0x00, 0x01, 0x03, 0x05, 0x04, 0x05, 0x61, // "z" (U+007A)
  0x00, 0x7B, 0x00, 0xFE, 0x02, 0x06, 0x03, 0x05, 0x6D, // "{" (U+007B)
  0x00, 0x7C, 0x01, 0xFF, 0x02, 0x07, 0x04, 0x05, 0x7C, // "|" (U+007C)
  0x00, 0x7D, 0x00, 0xFE, 0x02, 0x06, 0x03, 0x05, 0x87, // "}" (U+007D)
  0x00, 0x7E, 0x00, 0x02, 0x04, 0x03, 0x05, 0x05, 0x96, // "~" (U+007E)
  0x00, 0xA1, 0x00, 0x00, 0x01, 0x05, 0x02, 0x05, 0x9C, // "¡" (U+00A1)
  0x00, 0xA2, 0x00, 0x01, 0x03, 0x06, 0x05, 0x05, 0xA4, // "¢" (U+00A2)
  0x00, 0xA3, 0x00, 0x01, 0x04, 0x06, 0x05, 0x05, 0xB1, // "£" (U+00A3)
  0x00, 0xA4, 0x00, 0x01, 0x03, 0x06, 0x05, 0x05, 0xC1, // "¤" (U+00A4)
  0x00, 0xA5, 0x00, 0x01, 0x04, 0x06, 0x05, 0x05, 0xCE, // "¥" (U+00A5)
  0x00, 0xA6, 0x01, 0xFF, 0x02, 0x07, 0x04, 0x05, 0xE0, // "¦" (U+00A6)
  0x00, 0xA7, 0x00, 0x01, 0x03, 0x07, 0x04, 0x05, 0xEB, // "§" (U+00A7)
  0x00, 0xA8, 0x01, 0x07, 0x03, 0x07, 0x05, 0x05, 0xFB, // "¨" (U+00A8)
  0x00, 0xA9, 0x00, 0x01, 0x06, 0x07, 0x07, 0x05, 0xFE, // "©" (U+00A9)
  0x00, 0xAA, 0x00, 0x04, 0x02, 0x06, 0x03, 0x06, 0x19, // "ª" (U+00AA)
  0x00, 0xAB, 0x00, 0x01, 0x04, 0x04, 0x05, 0x06, 0x1F, // "«" (U+00AB)
  0x00, 0xAC, 0x00, 0x02, 0x04, 0x04, 0x05, 0x06, 0x2B, // "¬" (U+00AC)
  0x00, 0xAE, 0x00, 0x01, 0x06, 0x07, 0x07, 0x06, 0x34, // "®" (U+00AE)
  0x00, 0xAF, 0x00, 0x07, 0x03, 0x08, 0x04, 0x06, 0x4E, // "¯" (U+00AF)
  0x00, 0xB0, 0x00, 0x04, 0x02, 0x06, 0x03, 0x06, 0x52, // "°" (U+00B0)
  0x00, 0xB1, 0x00, 0x01, 0x04, 0x05, 0x05, 0x06, 0x58, // "±" (U+00B1)
  0x00, 0xB2, 0x00, 0x04, 0x02, 0x07, 0x03, 0x06, 0x66, // "²" (U+00B2)
  0x00, 0xB3, 0x00, 0x04, 0x02, 0x07, 0x03, 0x06, 0x6E, // "³" (U+00B3)
  0x00, 0xB4, 0x00, 0x06, 0x02, 0x07, 0x03, 0x06, 0x76, // "´" (U+00B4)
  0x00, 0xB5, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x06, 0x7A, // "µ" (U+00B5)
  0x00, 0xB6, 0x00, 0x00, 0x04, 0x07, 0x05, 0x06, 0x8C, // "¶" (U+00B6)
  0x00, 0xB7, 0x00, 0x03, 0x01, 0x03, 0x02, 0x06, 0xA5, // "·" (U+00B7)
  0x00, 0xB8, 0xFF, 0xFF, 0x01, 0x01, 0x02, 0x06, 0xA7, // "¸" (U+00B8)
  0x00, 0xB9, 0x00, 0x04, 0x02, 0x06, 0x03, 0x06, 0xAD, // "¹" (U+00B9)
  0x00, 0xBA, 0x00, 0x04, 0x02, 0x06, 0x03, 0x06, 0xB3, // "º" (U+00BA)
  0x00, 0xBB, 0x00, 0x01, 0x04, 0x04, 0x05, 0x06, 0xB9, // "»" (U+00BB)
  0x00, 0xBC, 0x00, 0x01, 0x06, 0x06, 0x07, 0x06, 0xC5, // "¼" (U+00BC)
  0x00, 0xBD, 0x00, 0x00, 0x06, 0x06, 0x07, 0x06, 0xDD, // "½" (U+00BD)
  0x00, 0xBE, 0x00, 0x01, 0x06, 0x07, 0x07, 0x06, 0xF8, // "¾" (U+00BE)
  0x00, 0xBF, 0x00, 0xFF, 0x03, 0x04, 0x04, 0x07, 0x15, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x05, 0x08, 0x06, 0x07, 0x23, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x05, 0x08, 0x06, 0x07, 0x3C, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x01, 0x05, 0x08, 0x06, 0x07, 0x55, // "Â" (U+00C2)
  0x00, 0xC3, 0x00, 0x01, 0x05, 0x07, 0x06, 0x07, 0x6F, // "Ã" (U+00C3)
  0x00, 0xC4, 0x00, 0x01, 0x05, 0x08, 0x06, 0x07, 0x87, // "Ä" (U+00C4)
  0x00, 0xC5, 0x00, 0x01, 0x05, 0x07, 0x06, 0x07, 0x9F, // "Å" (U+00C5)
  0x00, 0xC6, 0x00, 0x01, 0x07, 0x06, 0x08, 0x07, 0xB6, // "Æ" (U+00C6)
  0x00, 0xC7, 0x00, 0xFF, 0x04, 0x06, 0x05, 0x07, 0xCF, // "Ç" (U+00C7)
  0x00, 0xC8, 0x00, 0x01, 0x03, 0x08, 0x04, 0x07, 0xE6, // "È" (U+00C8)
  0x00, 0xC9, 0x00, 0x01, 0x03, 0x08, 0x04, 0x07, 0xF7, // "É" (U+00C9)
  0x00, 0xCA, 0x00, 0x01, 0x03, 0x08, 0x04, 0x08, 0x07, // "Ê" (U+00CA)
  0x00, 0xCB, 0x00, 0x01, 0x03, 0x08, 0x04, 0x08, 0x18, // "Ë" (U+00CB)
  0x00, 0xCC, 0x00, 0x01, 0x02, 0x08, 0x03, 0x08, 0x28, // "Ì" (U+00CC)
  0x00, 0xCD, 0x00, 0x01, 0x03, 0x08, 0x03, 0x08, 0x36, // "Í" (U+00CD)
  0x00, 0xCE, 0x00, 0x01, 0x03, 0x08, 0x03, 0x08, 0x48, // "Î" (U+00CE)
  0x00, 0xCF, 0x00, 0x01, 0x02, 0x08, 0x03, 0x08, 0x5A, // "Ï" (U+00CF)
  0x00, 0xD0, 0x00, 0x01, 0x05, 0x06, 0x06, 0x08, 0x68, // "Ð" (U+00D0)
  0x00, 0xD1, 0x00, 0x01, 0x05, 0x07, 0x07, 0x08, 0x7C, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x00, 0x01, 0x05, 0x08, 0x06, 0x08, 0x93, // "Ò" (U+00D2)
  0x00, 0xD3, 0x00, 0x01, 0x05, 0x08, 0x06, 0x08, 0xAD, // "Ó" (U+00D3)
  0x00, 0xD4, 0x00, 0x01, 0x05, 0x08, 0x06, 0x08, 0xC7, // "Ô" (U+00D4)
  0x00, 0xD5, 0x00, 0x01, 0x05, 0x07, 0x06, 0x08, 0xE2, // "Õ" (U+00D5)
  0x00, 0xD6, 0x00, 0x01, 0x05, 0x08, 0x06, 0x08, 0xFB, // "Ö" (U+00D6)
  0x00, 0xD7, 0x00, 0x02, 0x03, 0x05, 0x05, 0x09, 0x14, // "×" (U+00D7)
  0x00, 0xD8, 0x00, 0x00, 0x05, 0x06, 0x06, 0x09, 0x1E, // "Ø" (U+00D8)
  0x00, 0xD9, 0x00, 0x01, 0x05, 0x08, 0x06, 0x09, 0x33, // "Ù" (U+00D9)
  0x00, 0xDA, 0x00, 0x01, 0x05, 0x08, 0x06, 0x09, 0x4E, // "Ú" (U+00DA)
  0x00, 0xDB, 0x00, 0x01, 0x05, 0x08, 0x06, 0x09, 0x69, // "Û" (U+00DB)
  0x00, 0xDC, 0x00, 0x01, 0x05, 0x08, 0x06, 0x09, 0x84, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x01, 0x04, 0x08, 0x05, 0x09, 0x9D, // "Ý" (U+00DD)
  0x00, 0xDE, 0x00, 0x01, 0x04, 0x06, 0x05, 0x09, 0xB5, // "Þ" (U+00DE)
  0x00, 0xDF, 0x00, 0x01, 0x05, 0x07, 0x06, 0x09, 0xC5, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x01, 0x04, 0x07, 0x05, 0x09, 0xDC, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x04, 0x07, 0x05, 0x09, 0xEF, // "á" (U+00E1)
  0x00, 0xE2, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x03, // "â" (U+00E2)
  0x00, 0xE3, 0x00, 0x01, 0x04, 0x06, 0x05, 0x0A, 0x17, // "ã" (U+00E3)
  0x00, 0xE4, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x28, // "ä" (U+00E4)
  0x00, 0xE5, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x3A, // "å" (U+00E5)
  0x00, 0xE6, 0x00, 0x01, 0x06, 0x05, 0x07, 0x0A, 0x4E, // "æ" (U+00E6)
  0x00, 0xE7, 0x00, 0xFF, 0x03, 0x05, 0x04, 0x0A, 0x61, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x72, // "è" (U+00E8)
  0x00, 0xE9, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x85, // "é" (U+00E9)
  0x00, 0xEA, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x99, // "ê" (U+00EA)
  0x00, 0xEB, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0A, 0xAC, // "ë" (U+00EB)
  0x00, 0xEC, 0xFF, 0x01, 0x01, 0x07, 0x02, 0x0A, 0xBE, // "ì" (U+00EC)
  0x00, 0xED, 0x00, 0x01, 0x02, 0x07, 0x02, 0x0A, 0xCB, // "í" (U+00ED)
  0x00, 0xEE, 0xFF, 0x01, 0x02, 0x07, 0x02, 0x0A, 0xD7, // "î" (U+00EE)
  0x00, 0xEF, 0x00, 0x01, 0x02, 0x07, 0x02, 0x0A, 0xE9, // "ï" (U+00EF)
  0x00, 0xF0, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0A, 0xF5, // "ð" (U+00F0)
  0x00, 0xF1, 0x00, 0x01, 0x04, 0x06, 0x05, 0x0B, 0x0C, // "ñ" (U+00F1)
  0x00, 0xF2, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0B, 0x1D, // "ò" (U+00F2)
  0x00, 0xF3, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0B, 0x30, // "ó" (U+00F3)
  0x00, 0xF4, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0B, 0x43, // "ô" (U+00F4)
  0x00, 0xF5, 0x00, 0x01, 0x04, 0x06, 0x05, 0x0B, 0x57, // "õ" (U+00F5)
  0x00, 0xF6, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0B, 0x68, // "ö" (U+00F6)
  0x00, 0xF7, 0x00, 0x02, 0x04, 0x05, 0x05, 0x0B, 0x79, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x00, 0x04, 0x05, 0x05, 0x0B, 0x85, // "ø" (U+00F8)
  0x00, 0xF9, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0B, 0x95, // "ù" (U+00F9)
  0x00, 0xFA, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0B, 0xA8, // "ú" (U+00FA)
  0x00, 0xFB, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0B, 0xBB, // "û" (U+00FB)
  0x00, 0xFC, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0B, 0xCE, // "ü" (U+00FC)
  0x00, 0xFD, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0B, 0xE0, // "ý" (U+00FD)
  0x00, 0xFE, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0B, 0xFA, // "þ" (U+00FE)
  0x00, 0xFF, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0C, 0x11, // "ÿ" (U+00FF)
  0x01, 0x00, 0x00, 0x01, 0x05, 0x07, 0x06, 0x0C, 0x29, // "Ā" (U+0100)
  0x01, 0x01, 0x00, 0x01, 0x04, 0x06, 0x05, 0x0C, 0x40, // "ā" (U+0101)
  0x01, 0x02, 0x00, 0x01, 0x05, 0x09, 0x06, 0x0C, 0x51, // "Ă" (U+0102)
  0x01, 0x03, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0C, 0x6E, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0xFE, 0x05, 0x06, 0x06, 0x0C, 0x85, // "Ą" (U+0104)
  0x01, 0x05, 0x00, 0xFE, 0x04, 0x05, 0x05, 0x0C, 0xA0, // "ą" (U+0105)
  0x01, 0x06, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0C, 0xB6, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0C, 0xCC, // "ć" (U+0107)
  0x01, 0x08, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0C, 0xDC, // "Ĉ" (U+0108)
  0x01, 0x09, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0C, 0xF2, // "ĉ" (U+0109)
  0x01, 0x0A, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0D, 0x02, // "Ċ" (U+010A)
  0x01, 0x0B, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0D, 0x16, // "ċ" (U+010B)
  0x01, 0x0C, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0D, 0x25, // "Č" (U+010C)
  0x01, 0x0D, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0D, 0x3B, // "č" (U+010D)
  0x01, 0x0E, 0x00, 0x01, 0x05, 0x08, 0x06, 0x0D, 0x4B, // "Ď" (U+010E)
  0x01, 0x0F, 0x00, 0x01, 0x05, 0x07, 0x05, 0x0D, 0x67, // "ď" (U+010F)
  0x01, 0x10, 0x00, 0x01, 0x05, 0x06, 0x06, 0x0D, 0x7D, // "Đ" (U+0110)
  0x01, 0x11, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0D, 0x91, // "đ" (U+0111)
  0x01, 0x12, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0D, 0xA4, // "Ē" (U+0112)
  0x01, 0x13, 0x00, 0x01, 0x04, 0x06, 0x05, 0x0D, 0xB3, // "ē" (U+0113)
  0x01, 0x14, 0x00, 0x01, 0x04, 0x09, 0x04, 0x0D, 0xC4, // "Ĕ" (U+0114)
  0x01, 0x15, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0D, 0xDB, // "ĕ" (U+0115)
  0x01, 0x16, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0D, 0xF1, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0E, 0x00, // "ė" (U+0117)
  0x01, 0x18, 0x00, 0xFE, 0x03, 0x06, 0x04, 0x0E, 0x11, // "Ę" (U+0118)
  0x01, 0x19, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x0E, 0x24, // "ę" (U+0119)
  0x01, 0x1A, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0E, 0x38, // "Ě" (U+011A)
  0x01, 0x1B, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0E, 0x49, // "ě" (U+011B)
  0x01, 0x1C, 0x00, 0x01, 0x05, 0x08, 0x06, 0x0E, 0x5C, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0E, 0x75, // "ĝ" (U+011D)
  0x01, 0x1E, 0x00, 0x01, 0x05, 0x09, 0x06, 0x0E, 0x8D, // "Ğ" (U+011E)
  0x01, 0x1F, 0x00, 0xFF, 0x04, 0x08, 0x05, 0x0E, 0xA9, // "ğ" (U+011F)
  0x01, 0x20, 0x00, 0x01, 0x05, 0x08, 0x06, 0x0E, 0xC4, // "Ġ" (U+0120)
  0x01, 0x21, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0E, 0xDB, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0xFF, 0x05, 0x06, 0x06, 0x0E, 0xF1, // "Ģ" (U+0122)
  0x01, 0x23, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0F, 0x08, // "ģ" (U+0123)
  0x01, 0x24, 0x00, 0x01, 0x05, 0x08, 0x06, 0x0F, 0x1D, // "Ĥ" (U+0124)
  0x01, 0x25, 0xFF, 0x01, 0x04, 0x09, 0x05, 0x0F, 0x38, // "ĥ" (U+0125)
  0x01, 0x26, 0x00, 0x01, 0x06, 0x06, 0x06, 0x0F, 0x53, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0F, 0x6B, // "ħ" (U+0127)
  0x01, 0x28, 0x00, 0x01, 0x03, 0x07, 0x03, 0x0F, 0x7F, // "Ĩ" (U+0128)
  0x01, 0x29, 0xFF, 0x01, 0x02, 0x06, 0x02, 0x0F, 0x8F, // "ĩ" (U+0129)
  0x01, 0x2A, 0x00, 0x01, 0x02, 0x07, 0x03, 0x0F, 0x9E, // "Ī" (U+012A)
  0x01, 0x2B, 0x00, 0x01, 0x02, 0x06, 0x02, 0x0F, 0xAA, // "ī" (U+012B)
  0x01, 0x2C, 0x00, 0x01, 0x03, 0x09, 0x03, 0x0F, 0xB5, // "Ĭ" (U+012C)
  0x01, 0x2D, 0xFF, 0x01, 0x02, 0x08, 0x02, 0x0F, 0xCA, // "ĭ" (U+012D)
  0x01, 0x2E, 0x00, 0xFE, 0x02, 0x06, 0x03, 0x0F, 0xDE, // "Į" (U+012E)
  0x01, 0x2F, 0x00, 0xFE, 0x01, 0x07, 0x02, 0x0F, 0xEE, // "į" (U+012F)
  0x01, 0x30, 0x00, 0x01, 0x02, 0x08, 0x03, 0x0F, 0xFA, // "İ" (U+0130)
  0x01, 0x31, 0x00, 0x01, 0x01, 0x05, 0x02, 0x10, 0x08, // "ı" (U+0131)
  0x01, 0x32, 0x00, 0xFF, 0x04, 0x06, 0x06, 0x10, 0x0F, // "Ĳ" (U+0132)
  0x01, 0x33, 0x00, 0xFF, 0x03, 0x07, 0x05, 0x10, 0x25, // "ĳ" (U+0133)
  0x01, 0x34, 0xFF, 0xFF, 0x02, 0x08, 0x03, 0x10, 0x39, // "Ĵ" (U+0134)
  0x01, 0x35, 0xFF, 0xFF, 0x02, 0x07, 0x02, 0x10, 0x52, // "ĵ" (U+0135)
  0x01, 0x36, 0x00, 0xFF, 0x05, 0x06, 0x05, 0x10, 0x68, // "Ķ" (U+0136)
  0x01, 0x37, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x10, 0x81, // "ķ" (U+0137)
  0x01, 0x38, 0x00, 0x01, 0x04, 0x05, 0x05, 0x10, 0x98, // "ĸ" (U+0138)
  0x01, 0x39, 0x00, 0x01, 0x04, 0x08, 0x05, 0x10, 0xA6, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x00, 0x01, 0x02, 0x09, 0x02, 0x10, 0xBB, // "ĺ" (U+013A)
  0x01, 0x3B, 0x00, 0xFF, 0x04, 0x06, 0x05, 0x10, 0xCA, // "Ļ" (U+013B)
  0x01, 0x3C, 0x00, 0xFF, 0x01, 0x07, 0x02, 0x10, 0xDD, // "ļ" (U+013C)
  0x01, 0x3D, 0x00, 0x01, 0x04, 0x06, 0x05, 0x10, 0xE8, // "Ľ" (U+013D)
  0x01, 0x3E, 0x00, 0x01, 0x03, 0x07, 0x02, 0x10, 0xF8, // "ľ" (U+013E)
  0x01, 0x3F, 0x00, 0x01, 0x04, 0x06, 0x05, 0x11, 0x09, // "Ŀ" (U+013F)
  0x01, 0x40, 0x00, 0x01, 0x03, 0x07, 0x03, 0x11, 0x19, // "ŀ" (U+0140)
  0x01, 0x41, 0x00, 0x01, 0x04, 0x06, 0x05, 0x11, 0x2A, // "Ł" (U+0141)
  0x01, 0x42, 0x00, 0x01, 0x02, 0x07, 0x02, 0x11, 0x3B, // "ł" (U+0142)
  0x01, 0x43, 0x00, 0x01, 0x05, 0x08, 0x07, 0x11, 0x47, // "Ń" (U+0143)
  0x01, 0x44, 0x00, 0x01, 0x04, 0x07, 0x05, 0x11, 0x60, // "ń" (U+0144)
  0x01, 0x45, 0x00, 0xFF, 0x05, 0x06, 0x07, 0x11, 0x73, // "Ņ" (U+0145)
  0x01, 0x46, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x11, 0x8A, // "ņ" (U+0146)
  0x01, 0x47, 0x00, 0x01, 0x05, 0x08, 0x07, 0x11, 0x9B, // "Ň" (U+0147)
  0x01, 0x48, 0x00, 0x01, 0x04, 0x07, 0x05, 0x11, 0xB5, // "ň" (U+0148)
  0x01, 0x49, 0x00, 0x01, 0x05, 0x06, 0x06, 0x11, 0xC8, // "ŉ" (U+0149)
  0x01, 0x4A, 0x00, 0xFE, 0x05, 0x06, 0x07, 0x11, 0xDB, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x11, 0xF7, // "ŋ" (U+014B)
  0x01, 0x4C, 0x00, 0x01, 0x05, 0x07, 0x06, 0x12, 0x0A, // "Ō" (U+014C)
  0x01, 0x4D, 0x00, 0x01, 0x04, 0x06, 0x05, 0x12, 0x22, // "ō" (U+014D)
  0x01, 0x4E, 0x00, 0x01, 0x05, 0x09, 0x06, 0x12, 0x33, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x00, 0x01, 0x04, 0x08, 0x05, 0x12, 0x51, // "ŏ" (U+014F)
  0x01, 0x50, 0x00, 0x01, 0x05, 0x08, 0x06, 0x12, 0x67, // "Ő" (U+0150)
  0x01, 0x51, 0x00, 0x01, 0x04, 0x07, 0x05, 0x12, 0x83, // "ő" (U+0151)
  0x01, 0x52, 0x00, 0x01, 0x07, 0x06, 0x08, 0x12, 0x97, // "Œ" (U+0152)
  0x01, 0x53, 0x00, 0x01, 0x07, 0x05, 0x08, 0x12, 0xB0, // "œ" (U+0153)
  0x01, 0x54, 0x00, 0x01, 0x05, 0x08, 0x05, 0x12, 0xC6, // "Ŕ" (U+0154)
  0x01, 0x55, 0x00, 0x01, 0x03, 0x07, 0x04, 0x12, 0xE0, // "ŕ" (U+0155)
  0x01, 0x56, 0x00, 0xFF, 0x05, 0x06, 0x05, 0x12, 0xF0, // "Ŗ" (U+0156)
  0x01, 0x57, 0x00, 0xFF, 0x03, 0x05, 0x04, 0x13, 0x08, // "ŗ" (U+0157)
  0x01, 0x58, 0x00, 0x01, 0x05, 0x08, 0x05, 0x13, 0x17, // "Ř" (U+0158)
  0x01, 0x59, 0x00, 0x01, 0x03, 0x07, 0x04, 0x13, 0x33, // "ř" (U+0159)
  0x01, 0x5A, 0x00, 0x01, 0x03, 0x08, 0x04, 0x13, 0x43, // "Ś" (U+015A)
  0x01, 0x5B, 0x00, 0x01, 0x03, 0x07, 0x04, 0x13, 0x55, // "ś" (U+015B)
  0x01, 0x5C, 0x00, 0x01, 0x03, 0x08, 0x04, 0x13, 0x64, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x00, 0x01, 0x03, 0x07, 0x04, 0x13, 0x77, // "ŝ" (U+015D)
  0x01, 0x5E, 0x00, 0xFF, 0x03, 0x06, 0x04, 0x13, 0x87, // "Ş" (U+015E)
  0x01, 0x5F, 0x00, 0xFF, 0x03, 0x05, 0x04, 0x13, 0x9A, // "ş" (U+015F)
  0x01, 0x60, 0x00, 0x01, 0x03, 0x08, 0x04, 0x13, 0xAA, // "Š" (U+0160)
  0x01, 0x61, 0x00, 0x01, 0x03, 0x07, 0x04, 0x13, 0xBD, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFF, 0x04, 0x06, 0x05, 0x13, 0xCD, // "Ţ" (U+0162)
  0x01, 0x63, 0x00, 0xFF, 0x03, 0x06, 0x03, 0x13, 0xE2, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x04, 0x08, 0x05, 0x13, 0xF5, // "Ť" (U+0164)
  0x01, 0x65, 0x00, 0x01, 0x04, 0x07, 0x03, 0x14, 0x0B, // "ť" (U+0165)
  0x01, 0x66, 0x00, 0x01, 0x04, 0x06, 0x05, 0x14, 0x1E, // "Ŧ" (U+0166)
  0x01, 0x67, 0x00, 0x01, 0x03, 0x06, 0x03, 0x14, 0x2F, // "ŧ" (U+0167)
  0x01, 0x68, 0x00, 0x01, 0x05, 0x07, 0x06, 0x14, 0x3D, // "Ũ" (U+0168)
  0x01, 0x69, 0x00, 0x01, 0x04, 0x06, 0x05, 0x14, 0x56, // "ũ" (U+0169)
  0x01, 0x6A, 0x00, 0x01, 0x05, 0x07, 0x06, 0x14, 0x67, // "Ū" (U+016A)
  0x01, 0x6B, 0x00, 0x01, 0x04, 0x06, 0x05, 0x14, 0x80, // "ū" (U+016B)
  0x01, 0x6C, 0x00, 0x01, 0x05, 0x09, 0x06, 0x14, 0x91, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x00, 0x01, 0x04, 0x08, 0x05, 0x14, 0xB0, // "ŭ" (U+016D)
  0x01, 0x6E, 0x00, 0x01, 0x05, 0x08, 0x06, 0x14, 0xC6, // "Ů" (U+016E)
  0x01, 0x6F, 0x00, 0x01, 0x04, 0x07, 0x05, 0x14, 0xE1, // "ů" (U+016F)
  0x01, 0x70, 0x00, 0x01, 0x05, 0x08, 0x06, 0x14, 0xF5, // "Ű" (U+0170)
  0x01, 0x71, 0x00, 0x01, 0x04, 0x07, 0x05, 0x15, 0x11, // "ű" (U+0171)
  0x01, 0x72, 0x00, 0xFF, 0x05, 0x06, 0x06, 0x15, 0x24, // "Ų" (U+0172)
  0x01, 0x73, 0x00, 0xFE, 0x04, 0x05, 0x05, 0x15, 0x3E, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x07, 0x08, 0x08, 0x15, 0x53, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x06, 0x07, 0x07, 0x15, 0x74, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x01, 0x04, 0x08, 0x05, 0x15, 0x8E, // "Ŷ" (U+0176)
  0x01, 0x77, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x15, 0xA5, // "ŷ" (U+0177)
  0x01, 0x78, 0x00, 0x01, 0x04, 0x08, 0x05, 0x15, 0xBE, // "Ÿ" (U+0178)
  0x01, 0x79, 0x00, 0x01, 0x04, 0x08, 0x05, 0x15, 0xD4, // "Ź" (U+0179)
  0x01, 0x7A, 0x00, 0x01, 0x03, 0x07, 0x04, 0x15, 0xEA, // "ź" (U+017A)
  0x01, 0x7B, 0x00, 0x01, 0x04, 0x08, 0x05, 0x15, 0xFA, // "Ż" (U+017B)
  0x01, 0x7C, 0x00, 0x01, 0x03, 0x07, 0x04, 0x16, 0x0E, // "ż" (U+017C)
  0x01, 0x7D, 0x00, 0x01, 0x04, 0x08, 0x05, 0x16, 0x1D, // "Ž" (U+017D)
  0x01, 0x7E, 0x00, 0x01, 0x03, 0x07, 0x04, 0x16, 0x34, // "ž" (U+017E)
  0x01, 0x7F, 0x00, 0x01, 0x03, 0x07, 0x03, 0x16, 0x44, // "ſ" (U+017F)
  0x03, 0xA9, 0x00, 0x01, 0x06, 0x06, 0x06, 0x16, 0x55, // "Ω" (U+03A9)
  0x03, 0xBC, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x16, 0x6D, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x01, 0x05, 0x05, 0x06, 0x16, 0x7F, // "π" (U+03C0)
  0x20, 0x13, 0x00, 0x02, 0x03, 0x03, 0x04, 0x16, 0x90, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x02, 0x07, 0x03, 0x08, 0x16, 0x95, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x01, 0x04, 0x06, 0x05, 0x16, 0x9B, // "€" (U+20AC)
  0x20, 0xBF, 0x00, 0x00, 0x04, 0x07, 0x05, 0x16, 0xAC, // "₿" (U+20BF)
  0x20, 0x18, 0x00, 0x04, 0x01, 0x06, 0x02, 0x16, 0xC3, // "‘" (U+2018)
  0x20, 0x19, 0x00, 0x04, 0x01, 0x06, 0x02, 0x16, 0xC7, // "’" (U+2019)
  0x20, 0x1A, 0x00, 0xFF, 0x01, 0x01, 0x02, 0x16, 0xCB, // "‚" (U+201A)
  0x20, 0x1B, 0x00, 0x04, 0x01, 0x06, 0x02, 0x16, 0xCF, // "‛" (U+201B)
  0x20, 0x1C, 0x00, 0x04, 0x03, 0x06, 0x04, 0x16, 0xD3, // "“" (U+201C)
  0x20, 0x1D, 0x00, 0x04, 0x03, 0x06, 0x04, 0x16, 0xDB, // "”" (U+201D)
  0x20, 0x1E, 0x00, 0xFF, 0x03, 0x01, 0x04, 0x16, 0xE3, // "„" (U+201E)
  0x20, 0x1F, 0x00, 0x04, 0x03, 0x06, 0x04, 0x16, 0xEB, // "‟" (U+201F)
  0x20, 0x20, 0x00, 0x01, 0x03, 0x07, 0x04, 0x16, 0xF2, // "†" (U+2020)
  0x20, 0x21, 0x00, 0x01, 0x03, 0x07, 0x04, 0x17, 0x03, // "‡" (U+2021)
  0x20, 0x22, 0x00, 0x03, 0x02, 0x05, 0x03, 0x17, 0x13, // "•" (U+2022)
  0x20, 0x26, 0x00, 0x01, 0x06, 0x01, 0x07, 0x17, 0x19, // "…" (U+2026)
  0x20, 0x30, 0x00, 0x01, 0x09, 0x06, 0x0A, 0x17, 0x1E, // "‰" (U+2030)
  0x20, 0x39, 0x00, 0x01, 0x02, 0x04, 0x03, 0x17, 0x3D, // "‹" (U+2039)
  0x20, 0x3A, 0x00, 0x01, 0x02, 0x04, 0x03, 0x17, 0x45, // "›" (U+203A)
  0x20, 0x44, 0xFE, 0x01, 0x02, 0x06, 0x01, 0x17, 0x4D, // "⁄" (U+2044)
  0x21, 0x22, 0x00, 0x03, 0x05, 0x06, 0x06, 0x17, 0x5D, // "™" (U+2122)
  0x21, 0x52, 0x00, 0x01, 0x08, 0x06, 0x09, 0x17, 0x6B, // "⅒" (U+2152)
  0xFB, 0x01, 0x00, 0x01, 0x04, 0x07, 0x06, 0x17, 0x87, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0x00, 0x01, 0x04, 0x07, 0x06, 0x17, 0x9B, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x01, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0xC0, 0x01, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x01, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x01, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x01, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x01, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x01, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xC6, 0x01, // "Æ (U+0022 U+00C6)
  0x00, 0x22, 0x01, 0x00, 0x01, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x02, 0x01, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x04, 0x01, // "Ą (U+0022 U+0104)
  0x00, 0x27, 0x00, 0x41, 0x01, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0xC0, 0x01, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x01, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x01, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x01, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x01, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x01, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xC6, 0x01, // 'Æ (U+0027 U+00C6)
  0x00, 0x27, 0x01, 0x00, 0x01, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x02, 0x01, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x04, 0x01, // 'Ą (U+0027 U+0104)
  0x00, 0x2C, 0x00, 0x54, 0x01, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x01, 0x62, 0x01, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x01, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x01, // ,Ŧ (U+002C U+0166)
  0x00, 0x2E, 0x00, 0x54, 0x01, // .T (U+002E U+0054)
  0x00, 0x2E, 0x01, 0x62, 0x01, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x01, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x01, // .Ŧ (U+002E U+0166)
  0x00, 0x30, 0x20, 0x44, 0x02, // 0⁄ (U+0030 U+2044)
  0x00, 0x31, 0x20, 0x44, 0x02, // 1⁄ (U+0031 U+2044)
  0x00, 0x32, 0x20, 0x44, 0x02, // 2⁄ (U+0032 U+2044)
  0x00, 0x33, 0x20, 0x44, 0x02, // 3⁄ (U+0033 U+2044)
  0x00, 0x34, 0x20, 0x44, 0x02, // 4⁄ (U+0034 U+2044)
  0x00, 0x35, 0x20, 0x44, 0x02, // 5⁄ (U+0035 U+2044)
  0x00, 0x36, 0x20, 0x44, 0x02, // 6⁄ (U+0036 U+2044)
  0x00, 0x37, 0x20, 0x44, 0x02, // 7⁄ (U+0037 U+2044)
  0x00, 0x38, 0x20, 0x44, 0x02, // 8⁄ (U+0038 U+2044)
  0x00, 0x39, 0x20, 0x44, 0x02, // 9⁄ (U+0039 U+2044)
  0x00, 0x41, 0x00, 0x22, 0x01, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x01, // A' (U+0041 U+0027)
  0x00, 0x41, 0x00, 0x54, 0x01, // AT (U+0041 U+0054)
  0x00, 0x41, 0x01, 0x62, 0x01, // AŢ (U+0041 U+0162)
  0x00, 0x41, 0x01, 0x64, 0x01, // AŤ (U+0041 U+0164)
  0x00, 0x41, 0x01, 0x66, 0x01, // AŦ (U+0041 U+0166)
  0x00, 0x41, 0x20, 0x19, 0x01, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1D, 0x01, // A” (U+0041 U+201D)
  0x00, 0x4C, 0x00, 0x22, 0x01, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x01, // L' (U+004C U+0027)
  0x00, 0x4C, 0x20, 0x19, 0x01, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1D, 0x01, // L” (U+004C U+201D)
  0x00, 0x50, 0x00, 0x2C, 0x01, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x01, // P. (U+0050 U+002E)
  0x00, 0x50, 0x20, 0x1A, 0x01, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x01, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x01, // P… (U+0050 U+2026)
  0x00, 0x54, 0x00, 0x41, 0x01, // TA (U+0054 U+0041)
  0x00, 0x54, 0x00, 0x61, 0x01, // Ta (U+0054 U+0061)
  0x00, 0x54, 0x00, 0x63, 0x01, // Tc (U+0054 U+0063)
  0x00, 0x54, 0x00, 0x64, 0x01, // Td (U+0054 U+0064)
  0x00, 0x54, 0x00, 0x65, 0x01, // Te (U+0054 U+0065)
  0x00, 0x54, 0x00, 0x67, 0x01, // Tg (U+0054 U+0067)
  0x00, 0x54, 0x00, 0x6F, 0x01, // To (U+0054 U+006F)
  0x00, 0x54, 0x00, 0x71, 0x01, // Tq (U+0054 U+0071)
  0x00, 0x54, 0x00, 0xC0, 0x01, // TÀ (U+0054 U+00C0)
  0x00, 0x54, 0x00, 0xC1, 0x01, // TÁ (U+0054 U+00C1)
  0x00, 0x54, 0x00, 0xC2, 0x01, // TÂ (U+0054 U+00C2)
  0x00, 0x54, 0x00, 0xC3, 0x01, // TÃ (U+0054 U+00C3)
  0x00, 0x54, 0x00, 0xC4, 0x01, // TÄ (U+0054 U+00C4)
  0x00, 0x54, 0x00, 0xC5, 0x01, // TÅ (U+0054 U+00C5)
  0x00, 0x54, 0x00, 0xE0, 0x01, // Tà (U+0054 U+00E0)
  0x00, 0x54, 0x00, 0xE1, 0x01, // Tá (U+0054 U+00E1)
  0x00, 0x54, 0x00, 0xE2, 0x01, // Tâ (U+0054 U+00E2)
  0x00, 0x54, 0x00, 0xE3, 0x01, // Tã (U+0054 U+00E3)
  0x00, 0x54, 0x00, 0xE4, 0x01, // Tä (U+0054 U+00E4)
  0x00, 0x54, 0x00, 0xE5, 0x01, // Tå (U+0054 U+00E5)
  0x00, 0x54, 0x00, 0xE6, 0x01, // Tæ (U+0054 U+00E6)
  0x00, 0x54, 0x00, 0xE7, 0x01, // Tç (U+0054 U+00E7)
  0x00, 0x54, 0x00, 0xE8, 0x01, // Tè (U+0054 U+00E8)
  0x00, 0x54, 0x00, 0xE9, 0x01, // Té (U+0054 U+00E9)
  0x00, 0x54, 0x00, 0xEA, 0x01, // Tê (U+0054 U+00EA)
  0x00, 0x54, 0x00, 0xEB, 0x01, // Të (U+0054 U+00EB)
  0x00, 0x54, 0x00, 0xF2, 0x01, // Tò (U+0054 U+00F2)
  0x00, 0x54, 0x00, 0xF3, 0x01, // Tó (U+0054 U+00F3)
  0x00, 0x54, 0x00, 0xF4, 0x01, // Tô (U+0054 U+00F4)
  0x00, 0x54, 0x00, 0xF5, 0x01, // Tõ (U+0054 U+00F5)
  0x00, 0x54, 0x00, 0xF6, 0x01, // Tö (U+0054 U+00F6)
  0x00, 0x54, 0x00, 0xF8, 0x01, // Tø (U+0054 U+00F8)
  0x00, 0x54, 0x01, 0x00, 0x01, // TĀ (U+0054 U+0100)
  0x00, 0x54, 0x01, 0x01, 0x01, // Tā (U+0054 U+0101)
  0x00, 0x54, 0x01, 0x02, 0x01, // TĂ (U+0054 U+0102)
  0x00, 0x54, 0x01, 0x03, 0x01, // Tă (U+0054 U+0103)
  0x00, 0x54, 0x01, 0x04, 0x01, // TĄ (U+0054 U+0104)
  0x00, 0x54, 0x01, 0x05, 0x01, // Tą (U+0054 U+0105)
  0x00, 0x54, 0x01, 0x07, 0x01, // Tć (U+0054 U+0107)
  0x00, 0x54, 0x01, 0x09, 0x01, // Tĉ (U+0054 U+0109)
  0x00, 0x54, 0x01, 0x0B, 0x01, // Tċ (U+0054 U+010B)
  0x00, 0x54, 0x01, 0x0D, 0x01, // Tč (U+0054 U+010D)
  0x00, 0x54, 0x01, 0x0F, 0x01, // Tď (U+0054 U+010F)
  0x00, 0x54, 0x01, 0x11, 0x01, // Tđ (U+0054 U+0111)
  0x00, 0x54, 0x01, 0x13, 0x01, // Tē (U+0054 U+0113)
  0x00, 0x54, 0x01, 0x15, 0x01, // Tĕ (U+0054 U+0115)
  0x00, 0x54, 0x01, 0x17, 0x01, // Tė (U+0054 U+0117)
  0x00, 0x54, 0x01, 0x19, 0x01, // Tę (U+0054 U+0119)
  0x00, 0x54, 0x01, 0x1B, 0x01, // Tě (U+0054 U+011B)
  0x00, 0x54, 0x01, 0x1D, 0x01, // Tĝ (U+0054 U+011D)
  0x00, 0x54, 0x01, 0x1F, 0x01, // Tğ (U+0054 U+011F)
  0x00, 0x54, 0x01, 0x21, 0x01, // Tġ (U+0054 U+0121)
  0x00, 0x54, 0x01, 0x23, 0x01, // Tģ (U+0054 U+0123)
  0x00, 0x54, 0x01, 0x4D, 0x01, // Tō (U+0054 U+014D)
  0x00, 0x54, 0x01, 0x4F, 0x01, // Tŏ (U+0054 U+014F)
  0x00, 0x54, 0x01, 0x51, 0x01, // Tő (U+0054 U+0151)
  0x00, 0x54, 0x01, 0x53, 0x01, // Tœ (U+0054 U+0153)
  0x00, 0x59, 0x00, 0xAB, 0x01, // Y« (U+0059 U+00AB)
  0x00, 0x59, 0x20, 0x39, 0x01, // Y‹ (U+0059 U+2039)
  0x00, 0x72, 0x00, 0x2C, 0x01, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x01, // r. (U+0072 U+002E)
  0x00, 0x72, 0x20, 0x1A, 0x01, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x01, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x01, // r… (U+0072 U+2026)
  0x00, 0xBB, 0x00, 0x59, 0x01, // »Y (U+00BB U+0059)
  0x00, 0xBB, 0x00, 0xDD, 0x01, // »Ý (U+00BB U+00DD)
  0x00, 0xBB, 0x01, 0x76, 0x01, // »Ŷ (U+00BB U+0176)
  0x00, 0xBB, 0x01, 0x78, 0x01, // »Ÿ (U+00BB U+0178)
  0x00, 0xC0, 0x00, 0x22, 0x01, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x01, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x00, 0x54, 0x01, // ÀT (U+00C0 U+0054)
  0x00, 0xC0, 0x01, 0x62, 0x01, // ÀŢ (U+00C0 U+0162)
  0x00, 0xC0, 0x01, 0x64, 0x01, // ÀŤ (U+00C0 U+0164)
  0x00, 0xC0, 0x01, 0x66, 0x01, // ÀŦ (U+00C0 U+0166)
  0x00, 0xC0, 0x20, 0x19, 0x01, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1D, 0x01, // À” (U+00C0 U+201D)
  0x00, 0xC1, 0x00, 0x22, 0x01, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x01, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x00, 0x54, 0x01, // ÁT (U+00C1 U+0054)
  0x00, 0xC1, 0x01, 0x62, 0x01, // ÁŢ (U+00C1 U+0162)
  0x00, 0xC1, 0x01, 0x64, 0x01, // ÁŤ (U+00C1 U+0164)
  0x00, 0xC1, 0x01, 0x66, 0x01, // ÁŦ (U+00C1 U+0166)
  0x00, 0xC1, 0x20, 0x19, 0x01, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1D, 0x01, // Á” (U+00C1 U+201D)
  0x00, 0xC2, 0x00, 0x22, 0x01, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x01, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x00, 0x54, 0x01, // ÂT (U+00C2 U+0054)
  0x00, 0xC2, 0x01, 0x62, 0x01, // ÂŢ (U+00C2 U+0162)
  0x00, 0xC2, 0x01, 0x64, 0x01, // ÂŤ (U+00C2 U+0164)
  0x00, 0xC2, 0x01, 0x66, 0x01, // ÂŦ (U+00C2 U+0166)
  0x00, 0xC2, 0x20, 0x19, 0x01, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1D, 0x01, // Â” (U+00C2 U+201D)
  0x00, 0xC3, 0x00, 0x22, 0x01, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x01, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x00, 0x54, 0x01, // ÃT (U+00C3 U+0054)
  0x00, 0xC3, 0x01, 0x62, 0x01, // ÃŢ (U+00C3 U+0162)
  0x00, 0xC3, 0x01, 0x64, 0x01, // ÃŤ (U+00C3 U+0164)
  0x00, 0xC3, 0x01, 0x66, 0x01, // ÃŦ (U+00C3 U+0166)
  0x00, 0xC3, 0x20, 0x19, 0x01, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1D, 0x01, // Ã” (U+00C3 U+201D)
  0x00, 0xC4, 0x00, 0x22, 0x01, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x01, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x00, 0x54, 0x01, // ÄT (U+00C4 U+0054)
  0x00, 0xC4, 0x01, 0x62, 0x01, // ÄŢ (U+00C4 U+0162)
  0x00, 0xC4, 0x01, 0x64, 0x01, // ÄŤ (U+00C4 U+0164)
  0x00, 0xC4, 0x01, 0x66, 0x01, // ÄŦ (U+00C4 U+0166)
  0x00, 0xC4, 0x20, 0x19, 0x01, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1D, 0x01, // Ä” (U+00C4 U+201D)
  0x00, 0xC5, 0x00, 0x22, 0x01, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x01, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x00, 0x54, 0x01, // ÅT (U+00C5 U+0054)
  0x00, 0xC5, 0x01, 0x62, 0x01, // ÅŢ (U+00C5 U+0162)
  0x00, 0xC5, 0x01, 0x64, 0x01, // ÅŤ (U+00C5 U+0164)
  0x00, 0xC5, 0x01, 0x66, 0x01, // ÅŦ (U+00C5 U+0166)
  0x00, 0xC5, 0x20, 0x19, 0x01, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1D, 0x01, // Å” (U+00C5 U+201D)
  0x00, 0xDD, 0x00, 0xAB, 0x01, // Ý« (U+00DD U+00AB)
  0x00, 0xDD, 0x20, 0x39, 0x01, // Ý‹ (U+00DD U+2039)
  0x00, 0xDE, 0x00, 0x2C, 0x01, // Þ, (U+00DE U+002C)
  0x00, 0xDE, 0x00, 0x2E, 0x01, // Þ. (U+00DE U+002E)
  0x00, 0xDE, 0x20, 0x1A, 0x01, // Þ‚ (U+00DE U+201A)
  0x00, 0xDE, 0x20, 0x1E, 0x01, // Þ„ (U+00DE U+201E)
  0x00, 0xDE, 0x20, 0x26, 0x01, // Þ… (U+00DE U+2026)
  0x01, 0x00, 0x00, 0x22, 0x01, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x01, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x00, 0x54, 0x01, // ĀT (U+0100 U+0054)
  0x01, 0x00, 0x01, 0x62, 0x01, // ĀŢ (U+0100 U+0162)
  0x01, 0x00, 0x01, 0x64, 0x01, // ĀŤ (U+0100 U+0164)
  0x01, 0x00, 0x01, 0x66, 0x01, // ĀŦ (U+0100 U+0166)
  0x01, 0x00, 0x20, 0x19, 0x01, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1D, 0x01, // Ā” (U+0100 U+201D)
  0x01, 0x02, 0x00, 0x22, 0x01, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x01, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x00, 0x54, 0x01, // ĂT (U+0102 U+0054)
  0x01, 0x02, 0x01, 0x62, 0x01, // ĂŢ (U+0102 U+0162)
  0x01, 0x02, 0x01, 0x64, 0x01, // ĂŤ (U+0102 U+0164)
  0x01, 0x02, 0x01, 0x66, 0x01, // ĂŦ (U+0102 U+0166)
  0x01, 0x02, 0x20, 0x19, 0x01, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1D, 0x01, // Ă” (U+0102 U+201D)
  0x01, 0x04, 0x00, 0x22, 0x01, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x01, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x00, 0x54, 0x01, // ĄT (U+0104 U+0054)
  0x01, 0x04, 0x01, 0x62, 0x01, // ĄŢ (U+0104 U+0162)
  0x01, 0x04, 0x01, 0x64, 0x01, // ĄŤ (U+0104 U+0164)
  0x01, 0x04, 0x01, 0x66, 0x01, // ĄŦ (U+0104 U+0166)
  0x01, 0x04, 0x20, 0x19, 0x01, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1D, 0x01, // Ą” (U+0104 U+201D)
  0x01, 0x39, 0x00, 0x22, 0x01, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x01, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x20, 0x19, 0x01, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1D, 0x01, // Ĺ” (U+0139 U+201D)
  0x01, 0x3B, 0x00, 0x22, 0x01, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x01, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x20, 0x19, 0x01, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1D, 0x01, // Ļ” (U+013B U+201D)
  0x01, 0x3D, 0x00, 0x22, 0x01, // Ľ" (U+013D U+0022)
  0x01, 0x3D, 0x00, 0x27, 0x01, // Ľ' (U+013D U+0027)
  0x01, 0x3D, 0x20, 0x19, 0x01, // Ľ’ (U+013D U+2019)
  0x01, 0x3D, 0x20, 0x1D, 0x01, // Ľ” (U+013D U+201D)
  0x01, 0x3F, 0x00, 0x22, 0x01, // Ŀ" (U+013F U+0022)
  0x01, 0x3F, 0x00, 0x27, 0x01, // Ŀ' (U+013F U+0027)
  0x01, 0x3F, 0x20, 0x19, 0x01, // Ŀ’ (U+013F U+2019)
  0x01, 0x3F, 0x20, 0x1D, 0x01, // Ŀ” (U+013F U+201D)
  0x01, 0x41, 0x00, 0x22, 0x01, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x01, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x20, 0x19, 0x01, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1D, 0x01, // Ł” (U+0141 U+201D)
  0x01, 0x55, 0x00, 0x2C, 0x01, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x01, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x20, 0x1A, 0x01, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x01, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x01, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x01, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x01, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x20, 0x1A, 0x01, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x01, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x01, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x01, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x01, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x20, 0x1A, 0x01, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x01, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x01, // ř… (U+0159 U+2026)
  0x01, 0x62, 0x00, 0x41, 0x01, // ŢA (U+0162 U+0041)
  0x01, 0x62, 0x00, 0x61, 0x01, // Ţa (U+0162 U+0061)
  0x01, 0x62, 0x00, 0x63, 0x01, // Ţc (U+0162 U+0063)
  0x01, 0x62, 0x00, 0x64, 0x01, // Ţd (U+0162 U+0064)
  0x01, 0x62, 0x00, 0x65, 0x01, // Ţe (U+0162 U+0065)
  0x01, 0x62, 0x00, 0x67, 0x01, // Ţg (U+0162 U+0067)
  0x01, 0x62, 0x00, 0x6F, 0x01, // Ţo (U+0162 U+006F)
  0x01, 0x62, 0x00, 0x71, 0x01, // Ţq (U+0162 U+0071)
  0x01, 0x62, 0x00, 0xC0, 0x01, // ŢÀ (U+0162 U+00C0)
  0x01, 0x62, 0x00, 0xC1, 0x01, // ŢÁ (U+0162 U+00C1)
  0x01, 0x62, 0x00, 0xC2, 0x01, // ŢÂ (U+0162 U+00C2)
  0x01, 0x62, 0x00, 0xC3, 0x01, // ŢÃ (U+0162 U+00C3)
  0x01, 0x62, 0x00, 0xC4, 0x01, // ŢÄ (U+0162 U+00C4)
  0x01, 0x62, 0x00, 0xC5, 0x01, // ŢÅ (U+0162 U+00C5)
  0x01, 0x62, 0x00, 0xE0, 0x01, // Ţà (U+0162 U+00E0)
  0x01, 0x62, 0x00, 0xE1, 0x01, // Ţá (U+0162 U+00E1)
  0x01, 0x62, 0x00, 0xE2, 0x01, // Ţâ (U+0162 U+00E2)
  0x01, 0x62, 0x00, 0xE3, 0x01, // Ţã (U+0162 U+00E3)
  0x01, 0x62, 0x00, 0xE4, 0x01, // Ţä (U+0162 U+00E4)
  0x01, 0x62, 0x00, 0xE5, 0x01, // Ţå (U+0162 U+00E5)
  0x01, 0x62, 0x00, 0xE6, 0x01, // Ţæ (U+0162 U+00E6)
  0x01, 0x62, 0x00, 0xE7, 0x01, // Ţç (U+0162 U+00E7)
  0x01, 0x62, 0x00, 0xE8, 0x01, // Ţè (U+0162 U+00E8)
  0x01, 0x62, 0x00, 0xE9, 0x01, // Ţé (U+0162 U+00E9)
  0x01, 0x62, 0x00, 0xEA, 0x01, // Ţê (U+0162 U+00EA)
  0x01, 0x62, 0x00, 0xEB, 0x01, // Ţë (U+0162 U+00EB)
  0x01, 0x62, 0x00, 0xF2, 0x01, // Ţò (U+0162 U+00F2)
  0x01, 0x62, 0x00, 0xF3, 0x01, // Ţó (U+0162 U+00F3)
  0x01, 0x62, 0x00, 0xF4, 0x01, // Ţô (U+0162 U+00F4)
  0x01, 0x62, 0x00, 0xF5, 0x01, // Ţõ (U+0162 U+00F5)
  0x01, 0x62, 0x00, 0xF6, 0x01, // Ţö (U+0162 U+00F6)
  0x01, 0x62, 0x00, 0xF8, 0x01, // Ţø (U+0162 U+00F8)
  0x01, 0x62, 0x01, 0x00, 0x01, // ŢĀ (U+0162 U+0100)
  0x01, 0x62, 0x01, 0x01, 0x01, // Ţā (U+0162 U+0101)
  0x01, 0x62, 0x01, 0x02, 0x01, // ŢĂ (U+0162 U+0102)
  0x01, 0x62, 0x01, 0x03, 0x01, // Ţă (U+0162 U+0103)
  0x01, 0x62, 0x01, 0x04, 0x01, // ŢĄ (U+0162 U+0104)
  0x01, 0x62, 0x01, 0x05, 0x01, // Ţą (U+0162 U+0105)
  0x01, 0x62, 0x01, 0x07, 0x01, // Ţć (U+0162 U+0107)
  0x01, 0x62, 0x01, 0x09, 0x01, // Ţĉ (U+0162 U+0109)
  0x01, 0x62, 0x01, 0x0B, 0x01, // Ţċ (U+0162 U+010B)
  0x01, 0x62, 0x01, 0x0D, 0x01, // Ţč (U+0162 U+010D)
  0x01, 0x62, 0x01, 0x0F, 0x01, // Ţď (U+0162 U+010F)
  0x01, 0x62, 0x01, 0x11, 0x01, // Ţđ (U+0162 U+0111)
  0x01, 0x62, 0x01, 0x13, 0x01, // Ţē (U+0162 U+0113)
  0x01, 0x62, 0x01, 0x15, 0x01, // Ţĕ (U+0162 U+0115)
  0x01, 0x62, 0x01, 0x17, 0x01, // Ţė (U+0162 U+0117)
  0x01, 0x62, 0x01, 0x19, 0x01, // Ţę (U+0162 U+0119)
  0x01, 0x62, 0x01, 0x1B, 0x01, // Ţě (U+0162 U+011B)
  0x01, 0x62, 0x01, 0x1D, 0x01, // Ţĝ (U+0162 U+011D)
  0x01, 0x62, 0x01, 0x1F, 0x01, // Ţğ (U+0162 U+011F)
  0x01, 0x62, 0x01, 0x21, 0x01, // Ţġ (U+0162 U+0121)
  0x01, 0x62, 0x01, 0x23, 0x01, // Ţģ (U+0162 U+0123)
  0x01, 0x62, 0x01, 0x4D, 0x01, // Ţō (U+0162 U+014D)
  0x01, 0x62, 0x01, 0x4F, 0x01, // Ţŏ (U+0162 U+014F)
  0x01, 0x62, 0x01, 0x51, 0x01, // Ţő (U+0162 U+0151)
  0x01, 0x62, 0x01, 0x53, 0x01, // Ţœ (U+0162 U+0153)
  0x01, 0x64, 0x00, 0x41, 0x01, // ŤA (U+0164 U+0041)
  0x01, 0x64, 0x00, 0x61, 0x01, // Ťa (U+0164 U+0061)
  0x01, 0x64, 0x00, 0x63, 0x01, // Ťc (U+0164 U+0063)
  0x01, 0x64, 0x00, 0x64, 0x01, // Ťd (U+0164 U+0064)
  0x01, 0x64, 0x00, 0x65, 0x01, // Ťe (U+0164 U+0065)
  0x01, 0x64, 0x00, 0x67, 0x01, // Ťg (U+0164 U+0067)
  0x01, 0x64, 0x00, 0x6F, 0x01, // Ťo (U+0164 U+006F)
  0x01, 0x64, 0x00, 0x71, 0x01, // Ťq (U+0164 U+0071)
  0x01, 0x64, 0x00, 0xC0, 0x01, // ŤÀ (U+0164 U+00C0)
  0x01, 0x64, 0x00, 0xC1, 0x01, // ŤÁ (U+0164 U+00C1)
  0x01, 0x64, 0x00, 0xC2, 0x01, // ŤÂ (U+0164 U+00C2)
  0x01, 0x64, 0x00, 0xC3, 0x01, // ŤÃ (U+0164 U+00C3)
  0x01, 0x64, 0x00, 0xC4, 0x01, // ŤÄ (U+0164 U+00C4)
  0x01, 0x64, 0x00, 0xC5, 0x01, // ŤÅ (U+0164 U+00C5)
  0x01, 0x64, 0x00, 0xE0, 0x01, // Ťà (U+0164 U+00E0)
  0x01, 0x64, 0x00, 0xE1, 0x01, // Ťá (U+0164 U+00E1)
  0x01, 0x64, 0x00, 0xE2, 0x01, // Ťâ (U+0164 U+00E2)
  0x01, 0x64, 0x00, 0xE3, 0x01, // Ťã (U+0164 U+00E3)
  0x01, 0x64, 0x00, 0xE4, 0x01, // Ťä (U+0164 U+00E4)
  0x01, 0x64, 0x00, 0xE5, 0x01, // Ťå (U+0164 U+00E5)
  0x01, 0x64, 0x00, 0xE6, 0x01, // Ťæ (U+0164 U+00E6)
  0x01, 0x64, 0x00, 0xE7, 0x01, // Ťç (U+0164 U+00E7)
  0x01, 0x64, 0x00, 0xE8, 0x01, // Ťè (U+0164 U+00E8)
  0x01, 0x64, 0x00, 0xE9, 0x01, // Ťé (U+0164 U+00E9)
  0x01, 0x64, 0x00, 0xEA, 0x01, // Ťê (U+0164 U+00EA)
  0x01, 0x64, 0x00, 0xEB, 0x01, // Ťë (U+0164 U+00EB)
  0x01, 0x64, 0x00, 0xF2, 0x01, // Ťò (U+0164 U+00F2)
  0x01, 0x64, 0x00, 0xF3, 0x01, // Ťó (U+0164 U+00F3)
  0x01, 0x64, 0x00, 0xF4, 0x01, // Ťô (U+0164 U+00F4)
  0x01, 0x64, 0x00, 0xF5, 0x01, // Ťõ (U+0164 U+00F5)
  0x01, 0x64, 0x00, 0xF6, 0x01, // Ťö (U+0164 U+00F6)
  0x01, 0x64, 0x00, 0xF8, 0x01, // Ťø (U+0164 U+00F8)
  0x01, 0x64, 0x01, 0x00, 0x01, // ŤĀ (U+0164 U+0100)
  0x01, 0x64, 0x01, 0x01, 0x01, // Ťā (U+0164 U+0101)
  0x01, 0x64, 0x01, 0x02, 0x01, // ŤĂ (U+0164 U+0102)
  0x01, 0x64, 0x01, 0x03, 0x01, // Ťă (U+0164 U+0103)
  0x01, 0x64, 0x01, 0x04, 0x01, // ŤĄ (U+0164 U+0104)
  0x01, 0x64, 0x01, 0x05, 0x01, // Ťą (U+0164 U+0105)
  0x01, 0x64, 0x01, 0x07, 0x01, // Ťć (U+0164 U+0107)
  0x01, 0x64, 0x01, 0x09, 0x01, // Ťĉ (U+0164 U+0109)
  0x01, 0x64, 0x01, 0x0B, 0x01, // Ťċ (U+0164 U+010B)
  0x01, 0x64, 0x01, 0x0D, 0x01, // Ťč (U+0164 U+010D)
  0x01, 0x64, 0x01, 0x0F, 0x01, // Ťď (U+0164 U+010F)
  0x01, 0x64, 0x01, 0x11, 0x01, // Ťđ (U+0164 U+0111)
  0x01, 0x64, 0x01, 0x13, 0x01, // Ťē (U+0164 U+0113)
  0x01, 0x64, 0x01, 0x15, 0x01, // Ťĕ (U+0164 U+0115)
  0x01, 0x64, 0x01, 0x17, 0x01, // Ťė (U+0164 U+0117)
  0x01, 0x64, 0x01, 0x19, 0x01, // Ťę (U+0164 U+0119)
  0x01, 0x64, 0x01, 0x1B, 0x01, // Ťě (U+0164 U+011B)
  0x01, 0x64, 0x01, 0x1D, 0x01, // Ťĝ (U+0164 U+011D)
  0x01, 0x64, 0x01, 0x1F, 0x01, // Ťğ (U+0164 U+011F)
  0x01, 0x64, 0x01, 0x21, 0x01, // Ťġ (U+0164 U+0121)
  0x01, 0x64, 0x01, 0x23, 0x01, // Ťģ (U+0164 U+0123)
  0x01, 0x64, 0x01, 0x4D, 0x01, // Ťō (U+0164 U+014D)
  0x01, 0x64, 0x01, 0x4F, 0x01, // Ťŏ (U+0164 U+014F)
  0x01, 0x64, 0x01, 0x51, 0x01, // Ťő (U+0164 U+0151)
  0x01, 0x64, 0x01, 0x53, 0x01, // Ťœ (U+0164 U+0153)
  0x01, 0x66, 0x00, 0x41, 0x01, // ŦA (U+0166 U+0041)
  0x01, 0x66, 0x00, 0x61, 0x01, // Ŧa (U+0166 U+0061)
  0x01, 0x66, 0x00, 0x63, 0x01, // Ŧc (U+0166 U+0063)
  0x01, 0x66, 0x00, 0x64, 0x01, // Ŧd (U+0166 U+0064)
  0x01, 0x66, 0x00, 0x65, 0x01, // Ŧe (U+0166 U+0065)
  0x01, 0x66, 0x00, 0x67, 0x01, // Ŧg (U+0166 U+0067)
  0x01, 0x66, 0x00, 0x6F, 0x01, // Ŧo (U+0166 U+006F)
  0x01, 0x66, 0x00, 0x71, 0x01, // Ŧq (U+0166 U+0071)
  0x01, 0x66, 0x00, 0xC0, 0x01, // ŦÀ (U+0166 U+00C0)
  0x01, 0x66, 0x00, 0xC1, 0x01, // ŦÁ (U+0166 U+00C1)
  0x01, 0x66, 0x00, 0xC2, 0x01, // ŦÂ (U+0166 U+00C2)
  0x01, 0x66, 0x00, 0xC3, 0x01, // ŦÃ (U+0166 U+00C3)
  0x01, 0x66, 0x00, 0xC4, 0x01, // ŦÄ (U+0166 U+00C4)
  0x01, 0x66, 0x00, 0xC5, 0x01, // ŦÅ (U+0166 U+00C5)
  0x01, 0x66, 0x00, 0xE0, 0x01, // Ŧà (U+0166 U+00E0)
  0x01, 0x66, 0x00, 0xE1, 0x01, // Ŧá (U+0166 U+00E1)
  0x01, 0x66, 0x00, 0xE2, 0x01, // Ŧâ (U+0166 U+00E2)
  0x01, 0x66, 0x00, 0xE3, 0x01, // Ŧã (U+0166 U+00E3)
  0x01, 0x66, 0x00, 0xE4, 0x01, // Ŧä (U+0166 U+00E4)
  0x01, 0x66, 0x00, 0xE5, 0x01, // Ŧå (U+0166 U+00E5)
  0x01, 0x66, 0x00, 0xE6, 0x01, // Ŧæ (U+0166 U+00E6)
  0x01, 0x66, 0x00, 0xE7, 0x01, // Ŧç (U+0166 U+00E7)
  0x01, 0x66, 0x00, 0xE8, 0x01, // Ŧè (U+0166 U+00E8)
  0x01, 0x66, 0x00, 0xE9, 0x01, // Ŧé (U+0166 U+00E9)
  0x01, 0x66, 0x00, 0xEA, 0x01, // Ŧê (U+0166 U+00EA)
  0x01, 0x66, 0x00, 0xEB, 0x01, // Ŧë (U+0166 U+00EB)
  0x01, 0x66, 0x00, 0xF2, 0x01, // Ŧò (U+0166 U+00F2)
  0x01, 0x66, 0x00, 0xF3, 0x01, // Ŧó (U+0166 U+00F3)
  0x01, 0x66, 0x00, 0xF4, 0x01, // Ŧô (U+0166 U+00F4)
  0x01, 0x66, 0x00, 0xF5, 0x01, // Ŧõ (U+0166 U+00F5)
  0x01, 0x66, 0x00, 0xF6, 0x01, // Ŧö (U+0166 U+00F6)
  0x01, 0x66, 0x00, 0xF8, 0x01, // Ŧø (U+0166 U+00F8)
  0x01, 0x66, 0x01, 0x00, 0x01, // ŦĀ (U+0166 U+0100)
  0x01, 0x66, 0x01, 0x01, 0x01, // Ŧā (U+0166 U+0101)
  0x01, 0x66, 0x01, 0x02, 0x01, // ŦĂ (U+0166 U+0102)
  0x01, 0x66, 0x01, 0x03, 0x01, // Ŧă (U+0166 U+0103)
  0x01, 0x66, 0x01, 0x04, 0x01, // ŦĄ (U+0166 U+0104)
  0x01, 0x66, 0x01, 0x05, 0x01, // Ŧą (U+0166 U+0105)
  0x01, 0x66, 0x01, 0x07, 0x01, // Ŧć (U+0166 U+0107)
  0x01, 0x66, 0x01, 0x09, 0x01, // Ŧĉ (U+0166 U+0109)
  0x01, 0x66, 0x01, 0x0B, 0x01, // Ŧċ (U+0166 U+010B)
  0x01, 0x66, 0x01, 0x0D, 0x01, // Ŧč (U+0166 U+010D)
  0x01, 0x66, 0x01, 0x0F, 0x01, // Ŧď (U+0166 U+010F)
  0x01, 0x66, 0x01, 0x11, 0x01, // Ŧđ (U+0166 U+0111)
  0x01, 0x66, 0x01, 0x13, 0x01, // Ŧē (U+0166 U+0113)
  0x01, 0x66, 0x01, 0x15, 0x01, // Ŧĕ (U+0166 U+0115)
  0x01, 0x66, 0x01, 0x17, 0x01, // Ŧė (U+0166 U+0117)
  0x01, 0x66, 0x01, 0x19, 0x01, // Ŧę (U+0166 U+0119)
  0x01, 0x66, 0x01, 0x1B, 0x01, // Ŧě (U+0166 U+011B)
  0x01, 0x66, 0x01, 0x1D, 0x01, // Ŧĝ (U+0166 U+011D)
  0x01, 0x66, 0x01, 0x1F, 0x01, // Ŧğ (U+0166 U+011F)
  0x01, 0x66, 0x01, 0x21, 0x01, // Ŧġ (U+0166 U+0121)
  0x01, 0x66, 0x01, 0x23, 0x01, // Ŧģ (U+0166 U+0123)
  0x01, 0x66, 0x01, 0x4D, 0x01, // Ŧō (U+0166 U+014D)
  0x01, 0x66, 0x01, 0x4F, 0x01, // Ŧŏ (U+0166 U+014F)
  0x01, 0x66, 0x01, 0x51, 0x01, // Ŧő (U+0166 U+0151)
  0x01, 0x66, 0x01, 0x53, 0x01, // Ŧœ (U+0166 U+0153)
  0x01, 0x76, 0x00, 0xAB, 0x01, // Ŷ« (U+0176 U+00AB)
  0x01, 0x76, 0x20, 0x39, 0x01, // Ŷ‹ (U+0176 U+2039)
  0x01, 0x78, 0x00, 0xAB, 0x01, // Ÿ« (U+0178 U+00AB)
  0x01, 0x78, 0x20, 0x39, 0x01, // Ÿ‹ (U+0178 U+2039)
  0x20, 0x18, 0x00, 0x41, 0x01, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0xC0, 0x01, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x01, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x01, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x01, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x01, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x01, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xC6, 0x01, // ‘Æ (U+2018 U+00C6)
  0x20, 0x18, 0x01, 0x00, 0x01, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x02, 0x01, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x04, 0x01, // ‘Ą (U+2018 U+0104)
  0x20, 0x19, 0x00, 0x41, 0x01, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0xC0, 0x01, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x01, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x01, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x01, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x01, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x01, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xC6, 0x01, // ’Æ (U+2019 U+00C6)
  0x20, 0x19, 0x01, 0x00, 0x01, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x02, 0x01, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x04, 0x01, // ’Ą (U+2019 U+0104)
  0x20, 0x1A, 0x00, 0x54, 0x01, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x01, 0x62, 0x01, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x01, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x01, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1C, 0x00, 0x41, 0x01, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0xC0, 0x01, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x01, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x01, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x01, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x01, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x01, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xC6, 0x01, // “Æ (U+201C U+00C6)
  0x20, 0x1C, 0x01, 0x00, 0x01, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x02, 0x01, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x04, 0x01, // “Ą (U+201C U+0104)
  0x20, 0x1D, 0x00, 0x41, 0x01, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0xC0, 0x01, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x01, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x01, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x01, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x01, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x01, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xC6, 0x01, // ”Æ (U+201D U+00C6)
  0x20, 0x1D, 0x01, 0x00, 0x01, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x02, 0x01, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x04, 0x01, // ”Ą (U+201D U+0104)
  0x20, 0x1E, 0x00, 0x54, 0x01, // „T (U+201E U+0054)
  0x20, 0x1E, 0x01, 0x62, 0x01, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x01, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x01, // „Ŧ (U+201E U+0166)
  0x20, 0x3A, 0x00, 0x59, 0x01, // ›Y (U+203A U+0059)
  0x20, 0x3A, 0x00, 0xDD, 0x01, // ›Ý (U+203A U+00DD)
  0x20, 0x3A, 0x01, 0x76, 0x01, // ›Ŷ (U+203A U+0176)
  0x20, 0x3A, 0x01, 0x78, 0x01, // ›Ÿ (U+203A U+0178)
  0x20, 0x44, 0x00, 0x30, 0x02, // ⁄0 (U+2044 U+0030)
  0x20, 0x44, 0x00, 0x31, 0x02, // ⁄1 (U+2044 U+0031)
  0x20, 0x44, 0x00, 0x32, 0x02, // ⁄2 (U+2044 U+0032)
  0x20, 0x44, 0x00, 0x33, 0x02, // ⁄3 (U+2044 U+0033)
  0x20, 0x44, 0x00, 0x34, 0x02, // ⁄4 (U+2044 U+0034)
  0x20, 0x44, 0x00, 0x35, 0x02, // ⁄5 (U+2044 U+0035)
  0x20, 0x44, 0x00, 0x36, 0x02, // ⁄6 (U+2044 U+0036)
  0x20, 0x44, 0x00, 0x37, 0x02, // ⁄7 (U+2044 U+0037)
  0x20, 0x44, 0x00, 0x38, 0x02, // ⁄8 (U+2044 U+0038)
  0x20, 0x44, 0x00, 0x39, 0x02, // ⁄9 (U+2044 U+0039)
  
  // Glyph data
  // "!" (U+0021)
  0x86, 0x7C, 0x7B, 0x6A, 0x5A, 0x20, 0x60, 0xA0,
  // """ (U+0022)
  0x89, 0x16, 0x8C, 0x35, 0x7B, 0x20, 0x11, 0x10,
  // "#" (U+0023)
  0x18, 0x44, 0x99, 0x37, 0xEA, 0x8A, 0x2E, 0x1A, 0x5C, 0x1C, 0xFE, 0xFA, 0x1D, 0x68, 0x11, 0xB7,
  0x51,
  // "$" (U+0024)
  0x18, 0x92, 0x3A, 0x30, 0x7E, 0xDD, 0x08, 0xC8, 0x38, 0x90, 0x8F, 0x90, 0x20, 0x9F, 0x38, 0xA0,
  0xC2, 0x01, 0x08, 0x20,
  // "%" (U+0025)
  0x89, 0x26, 0xE8, 0x08, 0x50, 0xB7, 0xE1, 0xC2, 0x89, 0x47, 0xFA, 0x99, 0xD7, 0x01, 0x2C, 0xA8,
  0xD2, 0x89, 0x2A, 0x4A, 0x7D, 0x03, 0xB0, 0x5E, 0x70,
  // "&" (U+0026)
  0x18, 0x1A, 0xE9, 0x28, 0x12, 0xF3, 0x93, 0x81, 0xDD, 0x92, 0x8A, 0x04, 0xDC, 0x6A, 0x89, 0xB2,
  0xEE, 0x13, 0xDF, 0xBD, 0x80,
  // "'" (U+0027)
  0x84, 0x68, 0x57, 0x01,
  // "(" (U+0028)
  0x18, 0x96, 0xC2, 0x5B, 0x09, 0x70, 0xA5, 0x09, 0x70, 0x5B, 0x20, 0xC0, 0x20,
  // ")" (U+0029)
  0x07, 0x08, 0x28, 0x96, 0xE1, 0x0B, 0x40, 0xA5, 0x0B, 0x40, 0xE1, 0x68, 0x10,
  // "*" (U+002A)
  0x18, 0x95, 0x49, 0x07, 0x9B, 0xA3, 0xBE, 0x51, 0xD8, 0x60,
  // "+" (U+002B)
  0x10, 0x20, 0xB2, 0x87, 0x9E, 0xFE, 0x31, 0x3B, 0x12, 0x02, 0x0B, 0x20,
  // "," (U+002C)
  0x18, 0x31, 0x79, 0xA4,
  // "-" (U+002D)
  0x83, 0xBE, 0x51, 0x11,
  // "." (U+002E)
  0x06, 0x0A,
  // "/" (U+002F)
  0x28, 0x3E, 0x10, 0x5B, 0x28, 0x3A, 0x50, 0x1E, 0x20, 0x60, 0xA2, 0x0B, 0x04, 0x20,
  // "0" (U+0030)
  0x8B, 0x31, 0xCE, 0x70, 0x8B, 0x3F, 0x1A, 0x70, 0xE3, 0xA7, 0x0E, 0x37, 0xB3, 0xF1, 0x1B, 0xE7,
  0x10,
  // "1" (U+0031)
  0x18, 0x91, 0x4E, 0x44, 0xDE, 0x40, 0x1D, 0x42, 0x0E, 0x04, 0x20, 0xE0, 0x42, 0x0E, 0x04,
  // "2" (U+0032)
  0x89, 0x04, 0xDE, 0x80, 0x35, 0x3F, 0x12, 0x05, 0x0E, 0x28, 0x90, 0x2E, 0x40, 0x2D, 0x51, 0x0A,
  0xB0, 0x40,
  // "3" (U+0033)
  0x86, 0x5D, 0xEA, 0x01, 0x24, 0x92, 0x81, 0xBF, 0x62, 0x89, 0x31, 0x5F, 0x23, 0x14, 0xF2, 0x8E,
  0xE8, 0x10,
  // "4" (U+0034)
  0x20, 0xA0, 0xB2, 0x81, 0x3F, 0xB2, 0x8A, 0x0C, 0xAB, 0x07, 0x86, 0xB0, 0xDE, 0xEF, 0x61, 0x17,
  0xC1,
  // "5" (U+0035)
  0x05, 0xA8, 0x3C, 0x06, 0xB1, 0x28, 0xA1, 0x7E, 0xD7, 0x01, 0x25, 0xF1, 0x21, 0x4F, 0x17, 0xEE,
  0x71,
  // "6" (U+0036)
  0x18, 0xB2, 0x7D, 0xD0, 0x5D, 0x21, 0x09, 0xBD, 0xA0, 0xAA, 0x3F, 0x38, 0xB2, 0xF3, 0x1C, 0xE9,
  0x10,
  // "7" (U+0037)
  0x0C, 0xB8, 0x44, 0x01, 0x3E, 0x12, 0x00, 0x92, 0x81, 0x1E, 0x32, 0x07, 0x0C, 0x30, 0xD0, 0x52,
  // "8" (U+0038)
  0x8B, 0x32, 0xCE, 0x90, 0x7B, 0x3F, 0x02, 0xDB, 0x80, 0x5C, 0x9C, 0x0A, 0x92, 0xE3, 0x4D, 0xEA,
  0x10,
  // "9" (U+0039)
  0x8B, 0x32, 0xCE, 0x70, 0x99, 0x3F, 0x1A, 0x81, 0xF4, 0x5F, 0xDE, 0x20, 0x26, 0xD0, 0x5F, 0xC3,
  0x10,
  // ":" (U+003A)
  0x06, 0x0A, 0x60, 0x60, 0xA0,
  // ";" (U+003B)
  0x06, 0x0A, 0x58, 0x31, 0x79, 0xA4,
  // "<" (U+003C)
  0x28, 0x92, 0x29, 0x32, 0x9B, 0x40, 0x6D, 0x61, 0x38, 0x17, 0xC2,
  // "=" (U+003D)
  0x89, 0x59, 0xEE, 0xE3, 0x11, 0x11, 0x09, 0xEE, 0xE3, 0x80, 0x01, 0x10,
  // ">" (U+003E)
  0x08, 0x06, 0x38, 0x21, 0x7C, 0x62, 0x85, 0x3A, 0xC1, 0x8A, 0x42,
  // "?" (U+003F)
  0x89, 0x59, 0xED, 0x33, 0x2A, 0x80, 0x2D, 0x40, 0xC5, 0x20, 0x33, 0x0D, 0x02, 0x10,
  // "@" (U+0040)
  0x18, 0x31, 0xAE, 0xE7, 0x20, 0xD0, 0xCA, 0x8B, 0x3D, 0x65, 0x8D, 0x2C, 0x4B, 0x85, 0xD0, 0xE4,
  0xB8, 0x5B, 0xFA, 0xF4, 0x3D, 0x20, 0x12, 0x28, 0x37, 0xEF, 0xE4, 0x40, 0x13,
  // "A" (U+0041)
  0x18, 0x12, 0xFA, 0x38, 0x17, 0x9E, 0x38, 0x4C, 0x3A, 0x50, 0x2B, 0x89, 0x0A, 0x07, 0xA2, 0x3E,
  0x0C, 0x62, 0x0D, 0x05,
  // "B" (U+0042)
  0x04, 0xA8, 0xA5, 0xD5, 0x4E, 0x19, 0xB4, 0xFE, 0xF5, 0x4E, 0x28, 0xC4, 0xE1, 0x8D, 0x4A, 0x0D,
  0x05,
  // "C" (U+0043)
  0x18, 0x91, 0x6D, 0xE8, 0x3F, 0x42, 0x37, 0xC3, 0x07, 0x0B, 0x38, 0x90, 0x4F, 0x41, 0x20, 0x7E,
  0xE7,
  // "D" (U+0044)
  0x04, 0xA8, 0x91, 0xD5, 0x04, 0xE1, 0x5F, 0x24, 0xE2, 0x82, 0xD6, 0x4E, 0x28, 0x7D, 0x54, 0xE1,
  0x6E, 0x14, 0xA0, 0xC0, 0x41,
  // "E" (U+0045)
  0x04, 0xB8, 0x97, 0x4E, 0x11, 0x4F, 0xEC, 0x4E, 0x11, 0x4E, 0x11, 0x4B,
  // "F" (U+0046)
  0x04, 0xB8, 0x94, 0x4E, 0x10, 0x4F, 0xEC, 0x4E, 0x11, 0x4E, 0x20, 0x40, 0xE2,
  // "G" (U+0047)
  0x18, 0xC1, 0x5D, 0xFC, 0x03, 0xF6, 0x12, 0x07, 0xC1, 0xEE, 0x27, 0xC0, 0x2F, 0x23, 0xF5, 0x2F,
  0x20, 0x7D, 0xFD, 0x10,
  // "H" (U+0048)
  0x04, 0x0E, 0x28, 0x2C, 0x64, 0xE2, 0x89, 0x6C, 0x64, 0xFE, 0xEF, 0x64, 0xE1, 0x1D, 0x64, 0xE2,
  0x82, 0xC6, 0x4E, 0x20, 0xC0, 0x60,
  // "I" (U+0049)
  0x8A, 0x0B, 0xFC, 0x1F, 0x20, 0xF2, 0x0F, 0x20, 0xF2, 0xAF, 0xB0,
  // "J" (U+004A)
  0x18, 0xA5, 0x4E, 0x04, 0xE0, 0x4E, 0x04, 0xE0, 0x4E, 0x04, 0xE0, 0x6D, 0x8F, 0x60,
  // "K" (U+004B)
  0x89, 0x64, 0xE0, 0x6D, 0x04, 0xE3, 0xE3, 0x04, 0xED, 0x72, 0x82, 0x4F, 0xCC, 0x28, 0x92, 0x4E,
  0x0E, 0x60, 0x4E, 0x05, 0xE1,
  // "L" (U+004C)
  0x04, 0x0E, 0x30, 0x40, 0xE3, 0x04, 0x0E, 0x30, 0x40, 0xE3, 0x84, 0x4E, 0x11, 0x04, 0xB0, 0x30,
  // "M" (U+004D)
  0x81, 0x4F, 0x82, 0x8C, 0x3E, 0xC4, 0xEC, 0x04, 0xEC, 0x4C, 0xE1, 0x9A, 0xC4, 0xC9, 0x6D, 0x5C,
  0x4C, 0x5D, 0xB4, 0xC4, 0xC0, 0xF6, 0x4C,
  // "N" (U+004E)
  0x8C, 0x24, 0xF8, 0x04, 0xC4, 0xEE, 0x14, 0xC4, 0xBA, 0x94, 0xC4, 0xC2, 0xF7, 0xC4, 0xC0, 0x9E,
  0xC4, 0xC0, 0x1E, 0xC0,
  // "O" (U+004F)
  0x18, 0x93, 0x7E, 0xEA, 0x13, 0xF4, 0x2C, 0x97, 0xC2, 0x82, 0x6D, 0x7C, 0x28, 0x94, 0x6D, 0x3F,
  0x42, 0xC9, 0x07, 0xEE, 0xA1,
  // "P" (U+0050)
  0x04, 0xA8, 0x93, 0xC2, 0x4E, 0x1C, 0x84, 0xE0, 0xB8, 0x4A, 0x83, 0xD2, 0x4E, 0x12, 0x04, 0x0E,
  0x30,
  // "Q" (U+0051)
  0x18, 0x93, 0x7E, 0xEA, 0x13, 0xF4, 0x2C, 0x97, 0xC2, 0x82, 0x6D, 0x7C, 0x28, 0x94, 0x6D, 0x3F,
  0x42, 0xC9, 0x07, 0xEF, 0xC1, 0x38, 0x15, 0xE2, 0x40, 0x60, 0x50,
  // "R" (U+0052)
  0x04, 0xA8, 0xA1, 0xD3, 0x04, 0xE1, 0xB9, 0x04, 0xFE, 0xD3, 0x04, 0xE4, 0xE2, 0x89, 0x24, 0xE0,
  0xC7, 0x04, 0xE0, 0x4E, 0x10,
  // "S" (U+0053)
  0x89, 0x12, 0xCE, 0xB7, 0xB1, 0x34, 0xE8, 0x28, 0x91, 0x3C, 0xC3, 0x24, 0xF7, 0xEE, 0x70,
  // "T" (U+0054)
  0x0D, 0xB8, 0x37, 0x05, 0xE1, 0x20, 0x40, 0xE3, 0x04, 0x0E, 0x30, 0x40, 0xE3, 0x04, 0x0E, 0x20,
  // "U" (U+0055)
  0x04, 0x0D, 0x28, 0x2D, 0x54, 0xD2, 0x82, 0xD5, 0x4D, 0x28, 0x2D, 0x54, 0xD2, 0x89, 0x3D, 0x52,
  0xF4, 0x3F, 0x30, 0x7E, 0xE8, 0x10,
  // "V" (U+0056)
  0x8A, 0x6D, 0x50, 0x2F, 0x8A, 0x07, 0xB3, 0xE0, 0xC6, 0x0D, 0x5F, 0x10, 0x8C, 0xB2, 0x81, 0x3F,
  0x61,
  // "W" (U+0057)
  0x8B, 0x5D, 0x40, 0xC8, 0x08, 0x99, 0x81, 0xEC, 0x0C, 0x56, 0xB4, 0xAE, 0x1F, 0x12, 0xE8, 0x6B,
  0x8D, 0x28, 0x4E, 0xD3, 0x7D, 0x92, 0x84, 0xAE, 0x03, 0xF6, 0x10,
  // "X" (U+0058)
  0x89, 0x19, 0xB0, 0x5D, 0x01, 0xE4, 0xD4, 0x28, 0x15, 0xFB, 0x38, 0x17, 0xFB, 0x28, 0x92, 0x1E,
  0x3D, 0x50, 0xA9, 0x05, 0xE1,
  // "Y" (U+0059)
  0x89, 0x4B, 0x80, 0x8B, 0x3F, 0x3F, 0x30, 0xBE, 0xA2, 0x81, 0x3F, 0x32, 0x81, 0x1F, 0x12, 0x81,
  0x1F, 0x11,
  // "Z" (U+005A)
  0x0B, 0xB8, 0x35, 0x01, 0x6D, 0x28, 0x11, 0xE4, 0x20, 0xA0, 0x92, 0x84, 0x5D, 0x11, 0x0C, 0xB0,
  0x60,
  // "[" (U+005B)
  0x8B, 0x06, 0xF7, 0x69, 0x06, 0x90, 0x69, 0x06, 0x90, 0x69, 0x06, 0x90, 0x6F, 0x60, 0x11,
  // "\" (U+005C)
  0x0C, 0x04, 0x20, 0x60, 0xA2, 0x01, 0x0E, 0x30, 0xB0, 0x52, 0x05, 0x0B, 0x30, 0xE0, 0x10,
  // "]" (U+005D)
  0x8A, 0x4C, 0xF1, 0x0E, 0x10, 0xE1, 0x0E, 0x10, 0xE1, 0x0E, 0x10, 0xE1, 0xB9, 0x0F, 0x11,
  // "^" (U+005E)
  0x10, 0x50, 0xA3, 0x89, 0x4B, 0xC2, 0x02, 0xB3, 0xA0, 0x94, 0x0B, 0x20,
  // "_" (U+005F)
  0x0F, 0x90, 0x20,
  // "`" (U+0060)
  0x04, 0x06, 0x20, 0xB0, 0x40,
  // "a" (U+0061)
  0x82, 0x1C, 0xEA, 0x28, 0xA1, 0x42, 0xF3, 0x3C, 0xEF, 0x39, 0xC4, 0xF3, 0x5E, 0xBC, 0x30,
  // "b" (U+0062)
  0x05, 0x0C, 0x30, 0x50, 0xC3, 0x8A, 0x75, 0xDC, 0xD2, 0x5E, 0x2B, 0x85, 0xC0, 0x8A, 0x5E, 0x2B,
  0x85, 0xAC, 0xD2,
  // "c" (U+0063)
  0x89, 0x01, 0xBF, 0x97, 0xC1, 0x29, 0x92, 0x86, 0x7C, 0x13, 0x1B, 0xF9,
  // "d" (U+0064)
  0x30, 0xB0, 0x63, 0x8B, 0x1B, 0x61, 0xCD, 0xC6, 0x7C, 0x2D, 0x69, 0x90, 0xA6, 0x7C, 0x1D, 0x61,
  0xDD, 0xB6,
  // "e" (U+0065)
  0x8A, 0x71, 0xBE, 0x90, 0x7C, 0x2E, 0x39, 0xFE, 0xF5, 0x7C, 0x34, 0x11, 0xBF, 0xD1,
  // "f" (U+0066)
  0x18, 0x6B, 0xE4, 0x2F, 0x20, 0xBA, 0x18, 0x33, 0xF1, 0x02, 0x92, 0x02, 0x92, 0x02, 0x92,
  // "g" (U+0067)
  0x8C, 0x01, 0xCD, 0xB6, 0x7C, 0x2D, 0x69, 0x90, 0xA6, 0x7C, 0x1D, 0x61, 0xDD, 0xD6, 0x12, 0x2E,
  0x54, 0xEE, 0xA1,
  // "h" (U+0068)
  0x05, 0x0C, 0x30, 0x50, 0xC3, 0x8A, 0x75, 0xDC, 0xE3, 0x5F, 0x2A, 0x95, 0xC0, 0x8A, 0x5C, 0x08,
  0xA5, 0xC0, 0x8A,
  // "i" (U+0069)
  0x04, 0x0B, 0x28, 0x90, 0x5C, 0x5C, 0x5C, 0x5C, 0x5C,
  // "j" (U+006A)
  0x10, 0x40, 0xB4, 0x8A, 0x25, 0xC0, 0x5C, 0x05, 0xC0, 0x5C, 0x05, 0xC0, 0x7C, 0x7E, 0x50,
  // "k" (U+006B)
  0x05, 0x0C, 0x30, 0x50, 0xC3, 0x89, 0x15, 0xC0, 0xD7, 0x5C, 0xAA, 0x05, 0xA8, 0x92, 0x50, 0x5D,
  0x6E, 0x15, 0xC0, 0xB9,
  // "l" (U+006C)
  0x89, 0x45, 0xC5, 0xC5, 0xC5, 0xC5, 0xC5, 0xC5, 0xC0,
  // "m" (U+006D)
  0x8C, 0x65, 0xAC, 0xD5, 0xEB, 0x05, 0xE2, 0xCB, 0x2F, 0x35, 0xC0, 0xA8, 0x0E, 0x35, 0xC0, 0xA8,
  0x0E, 0x35, 0xC0, 0xA8, 0x0E, 0x30,
  // "n" (U+006E)
  0x8A, 0x75, 0xBC, 0xE3, 0x5F, 0x2A, 0x95, 0xC0, 0x8A, 0x5C, 0x08, 0xA5, 0xC0, 0x8A,
  // "o" (U+006F)
  0x18, 0xA5, 0xBE, 0xA0, 0x7C, 0x1D, 0x69, 0x90, 0xA8, 0x7C, 0x1D, 0x60, 0xBE, 0xA1,
  // "p" (U+0070)
  0x8B, 0x15, 0xCC, 0xD2, 0x5E, 0x2B, 0x85, 0xC0, 0x8A, 0x5E, 0x2B, 0x85, 0xDD, 0xD2, 0x5C, 0x30,
  0x50, 0xC3,
  // "q" (U+0071)
  0x8A, 0x71, 0xCD, 0xC6, 0x7C, 0x2D, 0x69, 0x90, 0xA6, 0x7C, 0x1D, 0x61, 0xDD, 0xD6, 0x30, 0xB0,
  0x63, 0x0B, 0x06,
  // "r" (U+0072)
  0x89, 0x05, 0xBC, 0x65, 0xF3, 0x05, 0xC2, 0x05, 0x0C, 0x20, 0x50, 0xC2,
  // "s" (U+0073)
  0x8A, 0x24, 0xEE, 0x69, 0xB2, 0x12, 0xBD, 0x33, 0x1A, 0x97, 0xFD, 0x40,
  // "t" (U+0074)
  0x10, 0xD2, 0x0A, 0xA8, 0x12, 0x4E, 0x20, 0x30, 0xE2, 0x81, 0x3F, 0x12, 0x81, 0xCE, 0x20,
  // "u" (U+0075)
  0x8A, 0x76, 0xC0, 0x89, 0x6C, 0x08, 0x96, 0xC0, 0x89, 0x5D, 0x0B, 0x91, 0xCE, 0xA9,
  // "v" (U+0076)
  0x89, 0x4D, 0x60, 0xD5, 0x7A, 0x2F, 0x12, 0xE7, 0xB2, 0x81, 0xDD, 0x52, 0x81, 0x7F, 0x11,
  // "w" (U+0077)
  0x8B, 0x1C, 0x55, 0xF3, 0x89, 0x89, 0x8C, 0x6B, 0x64, 0xCC, 0x59, 0xE2, 0x1E, 0xC1, 0xDD, 0x28,
  0x3C, 0xA0, 0xD9, 0x10,
  // "x" (U+0078)
  0x87, 0x9B, 0x1F, 0x31, 0xEC, 0xA2, 0x89, 0x49, 0xF3, 0x01, 0xEB, 0xA0, 0xAA, 0x1E, 0x40,
  // "y" (U+0079)
  0x89, 0x4C, 0x60, 0xD5, 0x7B, 0x2F, 0x11, 0xF8, 0xA2, 0x81, 0xBE, 0x52, 0x06, 0x92, 0x81, 0x19,
  0xA2, 0x81, 0xBD, 0x22,
  // "z" (U+007A)
  0x0A, 0xA8, 0x94, 0x90, 0x2E, 0x30, 0xA8, 0x05, 0xD1, 0x0B, 0xA0, 0xA0,
  // "{" (U+007B)
  0x18, 0xA5, 0x9C, 0x0D, 0x40, 0xE2, 0xDA, 0x03, 0xE1, 0x0D, 0x20, 0xD3, 0x09, 0xC2, 0x01,
  // "|" (U+007C)
  0x8A, 0x03, 0x93, 0x93, 0x93, 0x93, 0x93, 0x93, 0x93, 0x93, 0x90,
  // "}" (U+007D)
  0x82, 0xAB, 0x02, 0x92, 0x98, 0x52, 0x08, 0xF0, 0xE5, 0x19, 0x29, 0x18, 0x2A, 0xC0, 0x12,
  // "~" (U+007E)
  0x83, 0x9E, 0xEE, 0x38, 0x00, 0x11,
  // "¡" (U+00A1)
  0x06, 0x0A, 0x28, 0x65, 0x96, 0xA7, 0xB8, 0xC0,
  // "¢" (U+00A2)
  0x28, 0x6B, 0x21, 0xEE, 0xD6, 0xD2, 0x05, 0x0D, 0x38, 0x1C, 0xFD, 0x20, 0xB1,
  // "£" (U+00A3)
  0x18, 0xA7, 0x8E, 0xD1, 0x0E, 0x52, 0x09, 0xFE, 0x90, 0x1F, 0x41, 0x03, 0xE1, 0x10, 0xAB, 0x06,
  // "¤" (U+00A4)
  0x38, 0x94, 0x15, 0xDE, 0xD2, 0xB3, 0xB2, 0xA1, 0xB4, 0xA8, 0x3D, 0x11, 0x12,
  // "¥" (U+00A5)
  0x87, 0xB7, 0x0D, 0x43, 0xD5, 0xC2, 0x83, 0xBE, 0x40, 0x3A, 0x81, 0xB0, 0x3A, 0x0C, 0x28, 0x15,
  0xD1, 0x10,
  // "¦" (U+00A6)
  0x86, 0x39, 0x39, 0x39, 0x39, 0x28, 0x63, 0x93, 0x93, 0x93, 0x90,
  // "§" (U+00A7)
  0x8B, 0x23, 0xDE, 0x47, 0x92, 0x13, 0xEB, 0x17, 0x77, 0x61, 0xAE, 0x33, 0x19, 0x66, 0xED, 0x20,
  // "¨" (U+00A8)
  0x81, 0xB4, 0x90,
  // "©" (U+00A9)
  0x18, 0x21, 0x88, 0x63, 0x87, 0x96, 0x96, 0x80, 0x62, 0xA2, 0x83, 0x71, 0x82, 0x82, 0x83, 0x53,
  0x62, 0x92, 0x86, 0x71, 0x19, 0x69, 0x69, 0x28, 0x21, 0x88, 0x72,
  // "ª" (U+00AA)
  0x87, 0x5A, 0x76, 0x8B, 0x68, 0x70,
  // "«" (U+00AB)
  0x18, 0xA1, 0x95, 0xA4, 0x6C, 0x7B, 0x03, 0xE5, 0xD2, 0x04, 0x34, 0x20,
  // "¬" (U+00AC)
  0x89, 0x09, 0xEE, 0xE3, 0x11, 0x1A, 0x33, 0x05, 0x02,
  // "®" (U+00AE)
  0x18, 0x21, 0x88, 0x63, 0x8B, 0x79, 0xAA, 0x58, 0x06, 0x1A, 0x37, 0x71, 0x80, 0xBC, 0x15, 0x36,
  0x1A, 0x55, 0x71, 0x19, 0x40, 0x79, 0x28, 0x21, 0x88, 0x72,
  // "¯" (U+00AF)
  0x80, 0x0E, 0x80, 0x01,
  // "°" (U+00B0)
  0x87, 0x3D, 0x99, 0x5D, 0x5F, 0xB0,
  // "±" (U+00B1)
  0x10, 0x20, 0xB2, 0x87, 0x9E, 0xFE, 0x31, 0x3B, 0x12, 0x83, 0x3B, 0x10, 0xAB, 0x03,
  // "²" (U+00B2)
  0x89, 0x27, 0xC5, 0x16, 0x82, 0xC1, 0xAD, 0x90,
  // "³" (U+00B3)
  0x89, 0x26, 0xC4, 0x14, 0x82, 0xD4, 0x8C, 0x70,
  // "´" (U+00B4)
  0x18, 0x27, 0x36, 0xA1,
  // "µ" (U+00B5)
  0x8B, 0x15, 0xC0, 0x8A, 0x5C, 0x08, 0xA5, 0xC0, 0x8A, 0x5E, 0x2C, 0xA5, 0xEE, 0xBA, 0x5C, 0x30,
  0x50, 0xC3,
  // "¶" (U+00B6)
  0x01, 0x0C, 0xA0, 0x80, 0x7A, 0x81, 0x68, 0x8A, 0x81, 0x58, 0x6A, 0x85, 0x58, 0x06, 0xB5, 0x82,
  0x81, 0x55, 0x82, 0x81, 0x55, 0x82, 0x81, 0x55, 0x80,
  // "·" (U+00B7)
  0x06, 0x0A,
  // "¸" (U+00B8)
  0x10, 0x12, 0x83, 0x96, 0x1B, 0x50,
  // "¹" (U+00B9)
  0x87, 0x3D, 0x41, 0x94, 0x09, 0x40,
  // "º" (U+00BA)
  0x87, 0x6B, 0x7B, 0x1C, 0x4B, 0x50,
  // "»" (U+00BB)
  0x82, 0x59, 0x68, 0x28, 0x93, 0xC6, 0xD5, 0x3E, 0x5D, 0x23, 0x43, 0x31,
  // "¼" (U+00BC)
  0x89, 0x25, 0xE1, 0x0C, 0x10, 0x1C, 0x15, 0x83, 0x89, 0x3C, 0x1C, 0x4F, 0x10, 0xC8, 0x8B, 0xE1,
  0x28, 0x6C, 0x5C, 0xE6, 0x07, 0x72, 0x0D, 0x01,
  // "½" (U+00BD)
  0x89, 0x25, 0xE1, 0x0C, 0x10, 0x1C, 0x15, 0x93, 0x89, 0x3C, 0x1C, 0x9D, 0x50, 0xC7, 0x85, 0x87,
  0x28, 0x2C, 0x12, 0xB2, 0x86, 0x67, 0x0C, 0xEA, 0x01, 0x20, 0xF1,
  // "¾" (U+00BE)
  0x89, 0x25, 0xC5, 0x06, 0x50, 0x13, 0xA0, 0xD2, 0x83, 0x1D, 0x56, 0x82, 0x89, 0x42, 0x1C, 0xC3,
  0xE3, 0x6C, 0xB9, 0xAD, 0x32, 0x86, 0xB5, 0xCE, 0x80, 0x3A, 0x20, 0xB0, 0x30,
  // "¿" (U+00BF)
  0x10, 0x20, 0xD3, 0x03, 0x28, 0x95, 0x5C, 0x04, 0xD2, 0x09, 0xA1, 0x33, 0xDE, 0x90,
  // "À" (U+00C0)
  0x10, 0x40, 0x65, 0x0B, 0x04, 0x38, 0x12, 0xFA, 0x38, 0x17, 0x9E, 0x38, 0x4C, 0x3A, 0x50, 0x2B,
  0x89, 0x0A, 0x07, 0xA2, 0x3E, 0x0C, 0x62, 0x0D, 0x05,
  // "Á" (U+00C1)
  0x30, 0x70, 0x33, 0x06, 0x0A, 0x38, 0x12, 0xFA, 0x38, 0x17, 0x9E, 0x38, 0x4C, 0x3A, 0x50, 0x2B,
  0x89, 0x0A, 0x07, 0xA2, 0x3E, 0x0C, 0x62, 0x0D, 0x05,
  // "Â" (U+00C2)
  0x20, 0x06, 0x38, 0x25, 0xAA, 0x62, 0x81, 0x2F, 0xA3, 0x81, 0x79, 0xE3, 0x84, 0xC3, 0xA5, 0x02,
  0xB8, 0x90, 0xA0, 0x7A, 0x23, 0xE0, 0xC6, 0x20, 0xD0, 0x50,
  // "Ã" (U+00C3)
  0x18, 0x26, 0xEE, 0x52, 0x81, 0x3F, 0xB3, 0x81, 0x79, 0xE3, 0x84, 0xC3, 0xA5, 0x02, 0xB8, 0x90,
  0xA0, 0x7A, 0x23, 0xE0, 0xC6, 0x20, 0xD0, 0x50,
  // "Ä" (U+00C4)
  0x18, 0x1B, 0x49, 0x72, 0x81, 0x2F, 0xA3, 0x81, 0x79, 0xE3, 0x84, 0xC3, 0xA5, 0x02, 0xB8, 0x90,
  0xA0, 0x7A, 0x23, 0xE0, 0xC6, 0x20, 0xD0, 0x50,
  // "Å" (U+00C5)
  0x18, 0x15, 0x91, 0x38, 0x18, 0xFB, 0x38, 0x17, 0x9E, 0x38, 0x4C, 0x3A, 0x50, 0x2B, 0x89, 0x0A,
  0x07, 0xA2, 0x3E, 0x0C, 0x62, 0x0D, 0x05,
  // "Æ" (U+00C6)
  0x20, 0xAC, 0x86, 0x20, 0x1E, 0x5E, 0x11, 0x28, 0x47, 0x84, 0xFE, 0xE2, 0x80, 0x0E, 0x89, 0x51,
  0x10, 0x5B, 0x15, 0xE1, 0x10, 0xC6, 0x04, 0xB0, 0x20,
  // "Ç" (U+00C7)
  0x18, 0x91, 0x6D, 0xE8, 0x3F, 0x42, 0x37, 0xC3, 0x07, 0x0B, 0x38, 0x54, 0xF4, 0x12, 0x07, 0xA0,
  0x72, 0x09, 0x06, 0x28, 0x11, 0xB5, 0x10,
  // "È" (U+00C8)
  0x10, 0x40, 0x63, 0x81, 0xB4, 0x4B, 0x89, 0x74, 0xE1, 0x14, 0xFE, 0xC4, 0xE1, 0x14, 0xE1, 0x14,
  0xB0,
  // "É" (U+00C9)
  0x28, 0x57, 0x30, 0x6A, 0x04, 0xB8, 0x97, 0x4E, 0x11, 0x4F, 0xEC, 0x4E, 0x11, 0x4E, 0x11, 0x4B,
  // "Ê" (U+00CA)
  0x18, 0x66, 0x60, 0x5A, 0xA6, 0x4B, 0x89, 0x74, 0xE1, 0x14, 0xFE, 0xC4, 0xE1, 0x14, 0xE1, 0x14,
  0xB0,
  // "Ë" (U+00CB)
  0x18, 0x1B, 0x49, 0x40, 0x4B, 0x89, 0x74, 0xE1, 0x14, 0xFE, 0xC4, 0xE1, 0x14, 0xE1, 0x14, 0xB0,
  // "Ì" (U+00CC)
  0x04, 0x06, 0x28, 0xA2, 0xB4, 0xBF, 0xC1, 0xF2, 0x0F, 0x20, 0xF2, 0x0F, 0x2A, 0xFB,
  // "Í" (U+00CD)
  0x28, 0x93, 0x73, 0x06, 0xA0, 0xBF, 0xC0, 0x1F, 0x22, 0x90, 0x22, 0x90, 0x22, 0x98, 0x32, 0x0A,
  0xFB, 0x10,
  // "Î" (U+00CE)
  0x18, 0x94, 0x66, 0x05, 0xAA, 0x6B, 0xFC, 0x01, 0xF2, 0x29, 0x02, 0x29, 0x02, 0x29, 0x83, 0x20,
  0xAF, 0xB1,
  // "Ï" (U+00CF)
  0x81, 0xB4, 0x93, 0x8A, 0x0B, 0xFC, 0x1F, 0x20, 0xF2, 0x0F, 0x20, 0xF2, 0xAF, 0xB0,
  // "Ð" (U+00D0)
  0x04, 0xA8, 0xB2, 0xD5, 0x04, 0xE1, 0x5F, 0x2C, 0xFC, 0x0D, 0x65, 0xE1, 0x0D, 0x54, 0xE1, 0x6E,
  0x14, 0xA0, 0xC0, 0x41,
  // "Ñ" (U+00D1)
  0x18, 0xC7, 0x6E, 0xE5, 0x04, 0xFA, 0x14, 0xC4, 0xEE, 0x14, 0xC4, 0xBA, 0x94, 0xC4, 0xC2, 0xF7,
  0xC4, 0xC0, 0x9E, 0xC4, 0xC0, 0x1E, 0xC0,
  // "Ò" (U+00D2)
  0x10, 0x40, 0x65, 0x0B, 0x04, 0x38, 0x93, 0x7E, 0xEA, 0x13, 0xF4, 0x2C, 0x97, 0xC2, 0x82, 0x6D,
  0x7C, 0x28, 0x94, 0x6D, 0x3F, 0x42, 0xC9, 0x07, 0xEE, 0xA1,
  // "Ó" (U+00D3)
  0x30, 0x70, 0x33, 0x06, 0x0A, 0x38, 0x93, 0x7E, 0xEA, 0x13, 0xF4, 0x2C, 0x97, 0xC2, 0x82, 0x6D,
  0x7C, 0x28, 0x94, 0x6D, 0x3F, 0x42, 0xC9, 0x07, 0xEE, 0xA1,
  // "Ô" (U+00D4)
  0x20, 0x06, 0x38, 0x25, 0xAA, 0x62, 0x89, 0x37, 0xEE, 0xA1, 0x3F, 0x42, 0xC9, 0x7C, 0x28, 0x26,
  0xD7, 0xC2, 0x89, 0x46, 0xD3, 0xF4, 0x2C, 0x90, 0x7E, 0xEA, 0x10,
  // "Õ" (U+00D5)
  0x18, 0x26, 0xEE, 0x52, 0x08, 0xA8, 0x90, 0xA1, 0x3F, 0x42, 0xC9, 0x7C, 0x28, 0x26, 0xD7, 0xC2,
  0x89, 0x46, 0xD3, 0xF4, 0x2C, 0x90, 0x7E, 0xEA, 0x10,
  // "Ö" (U+00D6)
  0x28, 0x1B, 0x49, 0x71, 0x89, 0x37, 0xEE, 0xA1, 0x3F, 0x42, 0xC9, 0x7C, 0x28, 0x26, 0xD7, 0xC2,
  0x89, 0x46, 0xD3, 0xF4, 0x2C, 0x90, 0x7E, 0xEA, 0x10,
  // "×" (U+00D7)
  0x89, 0x61, 0x30, 0x51, 0xCB, 0x80, 0xAE, 0x33, 0x82, 0xA0,
  // "Ø" (U+00D8)
  0x18, 0xC3, 0x7E, 0xED, 0x43, 0xF4, 0x6F, 0x87, 0xC0, 0xC8, 0xC7, 0xC8, 0x56, 0xD3, 0xFB, 0x2C,
  0x90, 0xDD, 0xEA, 0x10, 0x14,
  // "Ù" (U+00D9)
  0x10, 0x40, 0x65, 0x0B, 0x04, 0x20, 0x40, 0xD2, 0x82, 0xD5, 0x4D, 0x28, 0x2D, 0x54, 0xD2, 0x82,
  0xD5, 0x4D, 0x28, 0x93, 0xD5, 0x2F, 0x43, 0xF3, 0x07, 0xEE, 0x81,
  // "Ú" (U+00DA)
  0x30, 0x70, 0x33, 0x06, 0x0A, 0x20, 0x40, 0xD2, 0x82, 0xD5, 0x4D, 0x28, 0x2D, 0x54, 0xD2, 0x82,
  0xD5, 0x4D, 0x28, 0x93, 0xD5, 0x2F, 0x43, 0xF3, 0x07, 0xEE, 0x81,
  // "Û" (U+00DB)
  0x20, 0x06, 0x38, 0x55, 0xAA, 0x60, 0x4D, 0x28, 0x2D, 0x54, 0xD2, 0x82, 0xD5, 0x4D, 0x28, 0x2D,
  0x54, 0xD2, 0x89, 0x3D, 0x52, 0xF4, 0x3F, 0x30, 0x7E, 0xE8, 0x10,
  // "Ü" (U+00DC)
  0x28, 0x1B, 0x49, 0x70, 0x40, 0xD2, 0x82, 0xD5, 0x4D, 0x28, 0x2D, 0x54, 0xD2, 0x82, 0xD5, 0x4D,
  0x28, 0x93, 0xD5, 0x2F, 0x43, 0xF3, 0x07, 0xEE, 0x81,
  // "Ý" (U+00DD)
  0x20, 0x70, 0x32, 0x06, 0x0A, 0x28, 0x94, 0xB8, 0x08, 0xB3, 0xF3, 0xF3, 0x0B, 0xEA, 0x28, 0x13,
  0xF3, 0x28, 0x11, 0xF1, 0x28, 0x11, 0xF1, 0x10,
  // "Þ" (U+00DE)
  0x04, 0x0E, 0x38, 0xA5, 0x4F, 0xEB, 0x14, 0xE2, 0xB8, 0x4E, 0x0A, 0x84, 0xFE, 0xE2, 0x4E, 0x12,
  // "ß" (U+00DF)
  0x18, 0xC7, 0x9E, 0xD5, 0x04, 0xE2, 0x8C, 0x05, 0xC1, 0xC6, 0x05, 0xC5, 0xE1, 0x05, 0xC0, 0x9E,
  0x15, 0xC2, 0x1E, 0x55, 0xC7, 0xFC, 0x10,
  // "à" (U+00E0)
  0x10, 0x40, 0x64, 0x85, 0xB4, 0x01, 0xCE, 0xA2, 0x8A, 0x14, 0x2F, 0x33, 0xCE, 0xF3, 0x9C, 0x4F,
  0x35, 0xEB, 0xC3,
  // "á" (U+00E1)
  0x20, 0x70, 0x32, 0x06, 0x0A, 0x28, 0x21, 0xCE, 0xA2, 0x8A, 0x14, 0x2F, 0x33, 0xCE, 0xF3, 0x9C,
  0x4F, 0x35, 0xEB, 0xC3,
  // "â" (U+00E2)
  0x10, 0x06, 0x28, 0x75, 0xAA, 0x60, 0x1C, 0xEA, 0x28, 0xA1, 0x42, 0xF3, 0x3C, 0xEF, 0x39, 0xC4,
  0xF3, 0x5E, 0xBC, 0x30,
  // "ã" (U+00E3)
  0x87, 0x6E, 0xE5, 0x02, 0xEF, 0xA2, 0x8A, 0x14, 0x2F, 0x33, 0xCE, 0xF3, 0x9C, 0x4F, 0x35, 0xEB,
  0xC3,
  // "ä" (U+00E4)
  0x18, 0x1B, 0x49, 0x68, 0x21, 0xCE, 0xA2, 0x8A, 0x14, 0x2F, 0x33, 0xCE, 0xF3, 0x9C, 0x4F, 0x35,
  0xEB, 0xC3,
  // "å" (U+00E5)
  0x18, 0x15, 0x91, 0x28, 0x65, 0x91, 0x01, 0xCE, 0xA2, 0x8A, 0x14, 0x2F, 0x33, 0xCE, 0xF3, 0x9C,
  0x4F, 0x35, 0xEB, 0xC3,
  // "æ" (U+00E6)
  0x8C, 0x11, 0xCE, 0x9D, 0xE4, 0x03, 0x3F, 0x75, 0xC3, 0xCE, 0xFE, 0xEF, 0x9C, 0x5F, 0x83, 0x44,
  0xED, 0x4C, 0xF9,
  // "ç" (U+00E7)
  0x89, 0x01, 0xBF, 0x97, 0xC1, 0x29, 0x92, 0x86, 0x7C, 0x13, 0x1B, 0xF9, 0x28, 0x49, 0x60, 0x1B,
  0x50,
  // "è" (U+00E8)
  0x10, 0x40, 0x64, 0x8B, 0x2B, 0x40, 0x1B, 0xE9, 0x07, 0xC2, 0xE3, 0x9F, 0xEF, 0x57, 0xC3, 0x41,
  0x1B, 0xFD, 0x10,
  // "é" (U+00E9)
  0x20, 0x70, 0x32, 0x06, 0x0A, 0x28, 0xA7, 0x1B, 0xE9, 0x07, 0xC2, 0xE3, 0x9F, 0xEF, 0x57, 0xC3,
  0x41, 0x1B, 0xFD, 0x10,
  // "ê" (U+00EA)
  0x10, 0x06, 0x28, 0xB4, 0x5A, 0xA6, 0x01, 0xBE, 0x90, 0x7C, 0x2E, 0x39, 0xFE, 0xF5, 0x7C, 0x34,
  0x11, 0xBF, 0xD1,
  // "ë" (U+00EB)
  0x18, 0x1B, 0x49, 0x68, 0xA7, 0x1B, 0xE9, 0x07, 0xC2, 0xE3, 0x9F, 0xEF, 0x57, 0xC3, 0x41, 0x1B,
  0xFD, 0x10,
  // "ì" (U+00EC)
  0x04, 0x06, 0x28, 0x97, 0xB4, 0x05, 0xC0, 0x5C, 0x05, 0xC0, 0x5C, 0x05, 0xC0,
  // "í" (U+00ED)
  0x18, 0xA1, 0x73, 0x6A, 0x05, 0xC0, 0x5C, 0x05, 0xC0, 0x5C, 0x05, 0xC1,
  // "î" (U+00EE)
  0x18, 0x90, 0x66, 0x05, 0xAA, 0x60, 0x5C, 0x20, 0x50, 0xC2, 0x05, 0x0C, 0x20, 0x50, 0xC2, 0x05,
  0x0C, 0x10,
  // "ï" (U+00EF)
  0x81, 0xB4, 0x93, 0x89, 0x45, 0xC0, 0x5C, 0x05, 0xC0, 0x5C, 0x05, 0xC1,
  // "ð" (U+00F0)
  0x18, 0x11, 0x13, 0x28, 0x15, 0xEB, 0x28, 0xB2, 0x67, 0xD0, 0x1B, 0xDE, 0x57, 0xC2, 0xD8, 0x99,
  0x0A, 0x87, 0xC2, 0xD5, 0x0B, 0xEA, 0x10,
  // "ñ" (U+00F1)
  0x18, 0xB3, 0x6E, 0xE5, 0x5C, 0xEF, 0x35, 0xF2, 0xA9, 0x5C, 0x08, 0xA5, 0xC0, 0x8A, 0x5C, 0x08,
  0xA0,
  // "ò" (U+00F2)
  0x10, 0x40, 0x64, 0x0B, 0x04, 0x28, 0xA5, 0xBE, 0xA0, 0x7C, 0x1D, 0x69, 0x90, 0xA8, 0x7C, 0x1D,
  0x60, 0xBE, 0xA1,
  // "ó" (U+00F3)
  0x20, 0x70, 0x32, 0x06, 0x0A, 0x38, 0xA5, 0xBE, 0xA0, 0x7C, 0x1D, 0x69, 0x90, 0xA8, 0x7C, 0x1D,
  0x60, 0xBE, 0xA1,
  // "ô" (U+00F4)
  0x10, 0x06, 0x28, 0x25, 0xAA, 0x62, 0x8A, 0x5B, 0xEA, 0x07, 0xC1, 0xD6, 0x99, 0x0A, 0x87, 0xC1,
  0xD6, 0x0B, 0xEA, 0x10,
  // "õ" (U+00F5)
  0x18, 0xB2, 0x6E, 0xE5, 0x0C, 0xFC, 0x07, 0xC1, 0xD6, 0x99, 0x0A, 0x87, 0xC1, 0xD6, 0x0B, 0xEA,
  0x10,
  // "ö" (U+00F6)
  0x18, 0x1B, 0x49, 0x78, 0xA5, 0xBE, 0xA0, 0x7C, 0x1D, 0x69, 0x90, 0xA8, 0x7C, 0x1D, 0x60, 0xBE,
  0xA1,
  // "÷" (U+00F7)
  0x10, 0x20, 0xA2, 0x83, 0x9E, 0xEE, 0x38, 0x00, 0x12, 0x02, 0x0A, 0x20,
  // "ø" (U+00F8)
  0x18, 0xA5, 0xBE, 0xD1, 0x7C, 0x6F, 0x69, 0x9C, 0xA8, 0x7F, 0x7D, 0x62, 0xEF, 0xA2, 0x01, 0x30,
  // "ù" (U+00F9)
  0x10, 0x40, 0x64, 0x8B, 0x2B, 0x40, 0x6C, 0x08, 0x96, 0xC0, 0x89, 0x6C, 0x08, 0x95, 0xD0, 0xB9,
  0x1C, 0xEA, 0x90,
  // "ú" (U+00FA)
  0x30, 0x70, 0x32, 0x8B, 0x26, 0xA0, 0x6C, 0x08, 0x96, 0xC0, 0x89, 0x6C, 0x08, 0x95, 0xD0, 0xB9,
  0x1C, 0xEA, 0x90,
  // "û" (U+00FB)
  0x20, 0x06, 0x28, 0xB3, 0x5A, 0xA6, 0x6C, 0x08, 0x96, 0xC0, 0x89, 0x6C, 0x08, 0x95, 0xD0, 0xB9,
  0x1C, 0xEA, 0x90,
  // "ü" (U+00FC)
  0x18, 0x1B, 0x49, 0x68, 0xA7, 0x6C, 0x08, 0x96, 0xC0, 0x89, 0x6C, 0x08, 0x95, 0xD0, 0xB9, 0x1C,
  0xEA, 0x90,
  // "ý" (U+00FD)
  0x20, 0x70, 0x32, 0x06, 0x0A, 0x28, 0x94, 0xC6, 0x0D, 0x57, 0xB2, 0xF1, 0x1F, 0x8A, 0x28, 0x1B,
  0xE5, 0x20, 0x69, 0x28, 0x11, 0x9A, 0x28, 0x1B, 0xD2, 0x20,
  // "þ" (U+00FE)
  0x05, 0x0C, 0x30, 0x50, 0xC3, 0x8B, 0x15, 0xDC, 0xD2, 0x5E, 0x2B, 0x85, 0xC0, 0x8A, 0x5E, 0x2B,
  0x85, 0xDD, 0xD2, 0x5C, 0x30, 0x50, 0xC3,
  // "ÿ" (U+00FF)
  0x18, 0x1B, 0x49, 0x68, 0x94, 0xC6, 0x0D, 0x57, 0xB2, 0xF1, 0x1F, 0x8A, 0x28, 0x1B, 0xE5, 0x20,
  0x69, 0x28, 0x11, 0x9A, 0x28, 0x1B, 0xD2, 0x20,
  // "Ā" (U+0100)
  0x18, 0x1A, 0xEE, 0x38, 0x13, 0xFC, 0x38, 0x17, 0x9E, 0x38, 0x4C, 0x3A, 0x50, 0x2B, 0x89, 0x0A,
  0x07, 0xA2, 0x3E, 0x0C, 0x62, 0x0D, 0x05,
  // "ā" (U+0101)
  0x18, 0x6A, 0xEE, 0x01, 0xEF, 0xC2, 0x8A, 0x14, 0x2F, 0x33, 0xCE, 0xF3, 0x9C, 0x4F, 0x35, 0xEB,
  0xC3,
  // "Ă" (U+0102)
  0x18, 0x23, 0x02, 0x22, 0x82, 0x5E, 0xD1, 0x30, 0x14, 0x81, 0x2F, 0xA3, 0x81, 0x79, 0xE3, 0x84,
  0xC3, 0xA5, 0x02, 0xB8, 0x90, 0xA0, 0x7A, 0x23, 0xE0, 0xC6, 0x20, 0xD0, 0x50,
  // "ă" (U+0103)
  0x18, 0x73, 0x02, 0x20, 0x5E, 0xD1, 0x20, 0x12, 0x82, 0x1C, 0xEA, 0x28, 0xA1, 0x42, 0xF3, 0x3C,
  0xEF, 0x39, 0xC4, 0xF3, 0x5E, 0xBC, 0x30,
  // "Ą" (U+0104)
  0x18, 0x12, 0xFA, 0x38, 0x17, 0x9E, 0x38, 0x4C, 0x3A, 0x50, 0x2B, 0x89, 0x0A, 0x07, 0xA2, 0x3E,
  0x0C, 0x62, 0x90, 0x53, 0x07, 0x03, 0x40, 0x80, 0xD5, 0x01, 0x10,
  // "ą" (U+0105)
  0x82, 0x1C, 0xEA, 0x28, 0xA1, 0x42, 0xF3, 0x3C, 0xEF, 0x39, 0xC4, 0xF3, 0x5E, 0xBF, 0x32, 0x07,
  0x03, 0x30, 0x80, 0xD4, 0x01, 0x10,
  // "Ć" (U+0106)
  0x30, 0x70, 0x32, 0x06, 0x0A, 0x28, 0x91, 0x6D, 0xE8, 0x3F, 0x42, 0x37, 0xC3, 0x07, 0x0B, 0x38,
  0x90, 0x4F, 0x41, 0x20, 0x7E, 0xE7,
  // "ć" (U+0107)
  0x28, 0x96, 0x73, 0x06, 0xA0, 0x1B, 0xF9, 0x7C, 0x12, 0x99, 0x28, 0x67, 0xC1, 0x31, 0xBF, 0x90,
  // "Ĉ" (U+0108)
  0x20, 0x06, 0x28, 0x96, 0x5A, 0xA6, 0x06, 0xDE, 0x83, 0xF4, 0x23, 0x7C, 0x30, 0x70, 0xB3, 0x89,
  0x04, 0xF4, 0x12, 0x07, 0xEE, 0x70,
  // "ĉ" (U+0109)
  0x18, 0x97, 0x66, 0x05, 0xAA, 0x61, 0xBF, 0x97, 0xC1, 0x29, 0x92, 0x86, 0x7C, 0x13, 0x1B, 0xF9,
  // "Ċ" (U+010A)
  0x20, 0x80, 0x77, 0x89, 0x16, 0xDE, 0x83, 0xF4, 0x23, 0x7C, 0x30, 0x70, 0xB3, 0x89, 0x04, 0xF4,
  0x12, 0x07, 0xEE, 0x70,
  // "ċ" (U+010B)
  0x10, 0x80, 0x75, 0x89, 0x01, 0xBF, 0x97, 0xC1, 0x29, 0x92, 0x86, 0x7C, 0x13, 0x1B, 0xF9,
  // "Č" (U+010C)
  0x18, 0xA3, 0x43, 0x34, 0x01, 0xDD, 0x10, 0x6D, 0xE8, 0x3F, 0x42, 0x37, 0xC3, 0x07, 0x0B, 0x38,
  0x90, 0x4F, 0x41, 0x20, 0x7E, 0xE7,
  // "č" (U+010D)
  0x8A, 0x04, 0x33, 0x41, 0xDD, 0x11, 0xBF, 0x97, 0xC1, 0x29, 0x92, 0x86, 0x7C, 0x13, 0x1B, 0xF9,
  // "Ď" (U+010E)
  0x18, 0x24, 0x33, 0x42, 0x84, 0x1D, 0xD1, 0x04, 0xA8, 0x91, 0xD5, 0x04, 0xE1, 0x5F, 0x24, 0xE2,
  0x82, 0xD6, 0x4E, 0x28, 0x7D, 0x54, 0xE1, 0x6E, 0x14, 0xA0, 0xC0, 0x41,
  // "ď" (U+010F)
  0x38, 0x1B, 0x9C, 0x38, 0xB6, 0xB7, 0x01, 0xCD, 0xC6, 0x07, 0xC2, 0xD6, 0x09, 0x90, 0xA6, 0x07,
  0xC1, 0xD6, 0x01, 0xDD, 0xB6, 0x10,
  // "Đ" (U+0110)
  0x04, 0xA8, 0xB2, 0xD5, 0x04, 0xE1, 0x5F, 0x2C, 0xFC, 0x0D, 0x65, 0xE1, 0x0D, 0x54, 0xE1, 0x6E,
  0x14, 0xA0, 0xC0, 0x41,
  // "đ" (U+0111)
  0x30, 0xB0, 0x62, 0x0E, 0xA8, 0xA7, 0x1C, 0xDD, 0x67, 0xC2, 0xD6, 0x99, 0x0A, 0x67, 0xC1, 0xD6,
  0x1D, 0xDB, 0x60,
  // "Ē" (U+0112)
  0x18, 0x2A, 0xEE, 0x4B, 0x89, 0x74, 0xE1, 0x14, 0xFE, 0xC4, 0xE1, 0x14, 0xE1, 0x14, 0xB0,
  // "ē" (U+0113)
  0x18, 0xB3, 0xAE, 0xE0, 0x1D, 0xFB, 0x07, 0xC2, 0xE3, 0x9F, 0xEF, 0x57, 0xC3, 0x41, 0x1B, 0xFD,
  0x10,
  // "Ĕ" (U+0114)
  0x18, 0x73, 0x02, 0x20, 0x5E, 0xD1, 0x20, 0x12, 0x04, 0xB1, 0x8A, 0x34, 0xE1, 0x10, 0x4F, 0xEC,
  0x04, 0xE1, 0x10, 0x4E, 0x11, 0x04, 0xB1,
  // "ĕ" (U+0115)
  0x18, 0x73, 0x02, 0x20, 0x5E, 0xD1, 0x20, 0x12, 0x8A, 0x71, 0xBE, 0x90, 0x7C, 0x2E, 0x39, 0xFE,
  0xF5, 0x7C, 0x34, 0x11, 0xBF, 0xD1,
  // "Ė" (U+0116)
  0x10, 0x80, 0x75, 0x04, 0xB8, 0x97, 0x4E, 0x11, 0x4F, 0xEC, 0x4E, 0x11, 0x4E, 0x11, 0x4B,
  // "ė" (U+0117)
  0x10, 0x80, 0x77, 0x8A, 0x71, 0xBE, 0x90, 0x7C, 0x2E, 0x39, 0xFE, 0xF5, 0x7C, 0x34, 0x11, 0xBF,
  0xD1,
  // "Ę" (U+0118)
  0x04, 0xB8, 0x97, 0x4E, 0x11, 0x4F, 0xEC, 0x4E, 0x11, 0x4E, 0x11, 0x4B, 0x20, 0x70, 0x32, 0x08,
  0x0D, 0x30, 0x10,
  // "ę" (U+0119)
  0x8A, 0x41, 0xBE, 0x90, 0x7C, 0x2E, 0x39, 0xFE, 0xF5, 0x7C, 0x34, 0x11, 0xBA, 0x01, 0x20, 0x40,
  0x73, 0x05, 0x0E, 0x10,
  // "Ě" (U+011A)
  0x87, 0x43, 0x34, 0x1D, 0xD1, 0x4B, 0x89, 0x74, 0xE1, 0x14, 0xFE, 0xC4, 0xE1, 0x14, 0xE1, 0x14,
  0xB0,
  // "ě" (U+011B)
  0x8C, 0x14, 0x33, 0x40, 0x1D, 0xD1, 0x01, 0xBE, 0x90, 0x7C, 0x2E, 0x39, 0xFE, 0xF5, 0x7C, 0x34,
  0x11, 0xBF, 0xD1,
  // "Ĝ" (U+011C)
  0x20, 0x06, 0x38, 0x25, 0xAA, 0x62, 0x8C, 0x15, 0xDF, 0xC0, 0x3F, 0x61, 0x20, 0x7C, 0x1E, 0xE2,
  0x7C, 0x02, 0xF2, 0x3F, 0x52, 0xF2, 0x07, 0xDF, 0xD1,
  // "ĝ" (U+011D)
  0x20, 0x06, 0x28, 0xC4, 0x5A, 0xA6, 0x1C, 0xDB, 0x67, 0xC2, 0xD6, 0x99, 0x0A, 0x67, 0xC1, 0xD6,
  0x1D, 0xDD, 0x61, 0x22, 0xE5, 0x4E, 0xEA, 0x10,
  // "Ğ" (U+011E)
  0x18, 0x23, 0x02, 0x22, 0x82, 0x5E, 0xD1, 0x30, 0x14, 0x8C, 0x15, 0xDF, 0xC0, 0x3F, 0x61, 0x20,
  0x7C, 0x1E, 0xE2, 0x7C, 0x02, 0xF2, 0x3F, 0x52, 0xF2, 0x07, 0xDF, 0xD1,
  // "ğ" (U+011F)
  0x18, 0x73, 0x02, 0x20, 0x5E, 0xD1, 0x20, 0x12, 0x8C, 0x01, 0xCD, 0xB6, 0x7C, 0x2D, 0x69, 0x90,
  0xA6, 0x7C, 0x1D, 0x61, 0xDD, 0xD6, 0x12, 0x2E, 0x54, 0xEE, 0xA1,
  // "Ġ" (U+0120)
  0x20, 0x80, 0x77, 0x28, 0xC1, 0x5D, 0xFC, 0x03, 0xF6, 0x12, 0x07, 0xC1, 0xEE, 0x27, 0xC0, 0x2F,
  0x23, 0xF5, 0x2F, 0x20, 0x7D, 0xFD, 0x10,
  // "ġ" (U+0121)
  0x20, 0x80, 0x76, 0x8C, 0x01, 0xCD, 0xB6, 0x7C, 0x2D, 0x69, 0x90, 0xA6, 0x7C, 0x1D, 0x61, 0xDD,
  0xD6, 0x12, 0x2E, 0x54, 0xEE, 0xA1,
  // "Ģ" (U+0122)
  0x18, 0xC1, 0x5D, 0xFC, 0x03, 0xF6, 0x12, 0x07, 0xC1, 0xEE, 0x27, 0xC0, 0x2F, 0x23, 0xF5, 0x2F,
  0x20, 0x7D, 0xFD, 0x17, 0x10, 0x60, 0x72,
  // "ģ" (U+0123)
  0x20, 0xD7, 0x8C, 0x01, 0xCD, 0xB6, 0x7C, 0x2D, 0x69, 0x90, 0xA6, 0x7C, 0x1D, 0x61, 0xDD, 0xD6,
  0x12, 0x2E, 0x54, 0xEE, 0xA1,
  // "Ĥ" (U+0124)
  0x20, 0x06, 0x38, 0x55, 0xAA, 0x60, 0x4E, 0x28, 0x2C, 0x64, 0xE2, 0x89, 0x6C, 0x64, 0xFE, 0xEF,
  0x64, 0xE1, 0x1D, 0x64, 0xE2, 0x82, 0xC6, 0x4E, 0x20, 0xC0, 0x60,
  // "ĥ" (U+0125)
  0x10, 0x06, 0x38, 0x25, 0xAA, 0x63, 0x05, 0x0C, 0x40, 0x50, 0xC4, 0x8B, 0x35, 0xDC, 0xE3, 0x05,
  0xF2, 0xA9, 0x05, 0xC0, 0x8A, 0x05, 0xC0, 0x8A, 0x05, 0xC0, 0x8A,
  // "Ħ" (U+0126)
  0x8B, 0x4E, 0xFE, 0xEF, 0xE1, 0x5E, 0x11, 0xD7, 0x04, 0xFE, 0xEF, 0x60, 0x4E, 0x11, 0xD6, 0x04,
  0xE2, 0x83, 0xC6, 0x04, 0xE2, 0x0C, 0x06, 0x10,
  // "ħ" (U+0127)
  0x05, 0x0C, 0x38, 0x1E, 0xFE, 0x28, 0xA7, 0x5C, 0xBE, 0x35, 0xF2, 0xA9, 0x5C, 0x08, 0xA5, 0xC0,
  0x8A, 0x5C, 0x08, 0xA0,
  // "Ĩ" (U+0128)
  0x89, 0x16, 0xEE, 0x5C, 0xFD, 0x01, 0xF2, 0x29, 0x02, 0x29, 0x02, 0x29, 0x83, 0x20, 0xAF, 0xB1,
  // "ĩ" (U+0129)
  0x85, 0x6E, 0xE5, 0x17, 0xD2, 0x05, 0x0C, 0x20, 0x50, 0xC2, 0x05, 0x0C, 0x20, 0x50, 0xC1,
  // "Ī" (U+012A)
  0x8A, 0x3A, 0xEE, 0xCF, 0xE1, 0xF2, 0x0F, 0x20, 0xF2, 0x0F, 0x2A, 0xFB,
  // "ī" (U+012B)
  0x89, 0x7A, 0xEE, 0x7E, 0x15, 0xC0, 0x5C, 0x05, 0xC0, 0x5C, 0x10,
  // "Ĭ" (U+012C)
  0x89, 0x03, 0x02, 0x25, 0xED, 0x10, 0x12, 0x85, 0xBF, 0xC0, 0x1F, 0x22, 0x90, 0x22, 0x90, 0x22,
  0x98, 0x32, 0x0A, 0xFB, 0x10,
  // "ĭ" (U+012D)
  0x89, 0x03, 0x02, 0x25, 0xED, 0x10, 0x13, 0x05, 0x0C, 0x20, 0x50, 0xC2, 0x05, 0x0C, 0x20, 0x50,
  0xC2, 0x05, 0x0C, 0x10,
  // "Į" (U+012E)
  0x89, 0x6B, 0xFC, 0x1F, 0x20, 0xF2, 0x0F, 0x20, 0xF2, 0xAA, 0x18, 0x37, 0x30, 0x8D, 0x20, 0x10,
  // "į" (U+012F)
  0x04, 0x0B, 0x28, 0x96, 0x5C, 0x5C, 0x5C, 0x5C, 0x6F, 0x73, 0x8D, 0x01,
  // "İ" (U+0130)
  0x10, 0x80, 0x73, 0x8A, 0x0B, 0xFC, 0x1F, 0x20, 0xF2, 0x0F, 0x20, 0xF2, 0xAF, 0xB0,
  // "ı" (U+0131)
  0x89, 0x05, 0xC5, 0xC5, 0xC5, 0xC5, 0xC0,
  // "Ĳ" (U+0132)
  0x8B, 0x4B, 0xFC, 0x4E, 0x1F, 0x24, 0xE0, 0xF2, 0x4E, 0x0F, 0x24, 0xE0, 0xF2, 0x4E, 0xAF, 0xB4,
  0xE3, 0x06, 0x0D, 0x28, 0x18, 0xF6,
  // "ĳ" (U+0133)
  0x82, 0x4B, 0x4B, 0x48, 0xA2, 0x5C, 0x5C, 0x5C, 0x5C, 0x5C, 0x5C, 0x5C, 0x5C, 0x5C, 0x5C, 0x28,
  0x47, 0xC0, 0x7E, 0x50,
  // "Ĵ" (U+0134)
  0x18, 0x90, 0x66, 0x05, 0xAA, 0x60, 0x4E, 0x20, 0x40, 0xE2, 0x04, 0x0E, 0x20, 0x40, 0xE2, 0x04,
  0x0E, 0x20, 0x40, 0xE2, 0x84, 0x6D, 0x08, 0xF6, 0x10,
  // "ĵ" (U+0135)
  0x18, 0x90, 0x66, 0x05, 0xAA, 0x60, 0x5C, 0x20, 0x50, 0xC2, 0x05, 0x0C, 0x20, 0x50, 0xC2, 0x05,
  0x0C, 0x28, 0x47, 0xC0, 0x7E, 0x51,
  // "Ķ" (U+0136)
  0x89, 0x64, 0xE0, 0x6D, 0x04, 0xE3, 0xE3, 0x04, 0xED, 0x72, 0x82, 0x4F, 0xCC, 0x28, 0x92, 0x4E,
  0x0E, 0x60, 0x4E, 0x05, 0xE1, 0x71, 0x0B, 0x02, 0x20,
  // "ķ" (U+0137)
  0x05, 0x0C, 0x30, 0x50, 0xC3, 0x89, 0x15, 0xC0, 0xD7, 0x5C, 0xAA, 0x05, 0xA8, 0x92, 0x50, 0x5D,
  0x6E, 0x15, 0xC0, 0xB9, 0x60, 0x10, 0xC2,
  // "ĸ" (U+0138)
  0x8A, 0x75, 0xC0, 0xC7, 0x5C, 0x8B, 0x05, 0xEF, 0x50, 0x5D, 0x7D, 0x05, 0xC0, 0xB9,
  // "Ĺ" (U+0139)
  0x10, 0x70, 0x32, 0x06, 0x0A, 0x30, 0x40, 0xE3, 0x04, 0x0E, 0x30, 0x40, 0xE3, 0x04, 0x0E, 0x38,
  0x44, 0xE1, 0x10, 0x4B, 0x03,
  // "ĺ" (U+013A)
  0x18, 0xA7, 0x73, 0x6A, 0x05, 0xC0, 0x5C, 0x05, 0xC0, 0x5C, 0x05, 0xC0, 0x5C, 0x05, 0xC1,
  // "Ļ" (U+013B)
  0x04, 0x0E, 0x30, 0x40, 0xE3, 0x04, 0x0E, 0x30, 0x40, 0xE3, 0x84, 0x4E, 0x11, 0x04, 0xB0, 0x36,
  0x01, 0x0C, 0x20,
  // "ļ" (U+013C)
  0x89, 0x45, 0xC5, 0xC5, 0xC5, 0xC5, 0xC5, 0xC5, 0xC2, 0x05, 0x09,
  // "Ľ" (U+013D)
  0x85, 0x4E, 0x0B, 0x34, 0xE3, 0x04, 0x0E, 0x30, 0x40, 0xE3, 0x84, 0x4E, 0x11, 0x04, 0xB0, 0x30,
  // "ľ" (U+013E)
  0x84, 0x5C, 0xC2, 0x5C, 0x20, 0x50, 0xC2, 0x05, 0x0C, 0x20, 0x50, 0xC2, 0x05, 0x0C, 0x20, 0x50,
  0xC2,
  // "Ŀ" (U+013F)
  0x04, 0x0E, 0x38, 0x54, 0xE0, 0x87, 0x4E, 0x30, 0x40, 0xE3, 0x84, 0x4E, 0x11, 0x04, 0xB0, 0x30,
  // "ŀ" (U+0140)
  0x05, 0x0C, 0x20, 0x50, 0xC2, 0x84, 0x5C, 0x87, 0x5C, 0x20, 0x50, 0xC2, 0x05, 0x0C, 0x20, 0x50,
  0xC2,
  // "Ł" (U+0141)
  0x04, 0x0E, 0x38, 0x14, 0xE1, 0x28, 0x14, 0xFA, 0x20, 0xB0, 0xE3, 0x84, 0x4E, 0x11, 0x04, 0xB0,
  0x30,
  // "ł" (U+0142)
  0x8A, 0x25, 0xC0, 0x5C, 0x05, 0xD0, 0x6F, 0x5D, 0xC0, 0x5C, 0x05, 0xC1,
  // "Ń" (U+0143)
  0x30, 0x70, 0x33, 0x06, 0x0A, 0x28, 0xC2, 0x4F, 0x80, 0x4C, 0x4E, 0xE1, 0x4C, 0x4B, 0xA9, 0x4C,
  0x4C, 0x2F, 0x7C, 0x4C, 0x09, 0xEC, 0x4C, 0x01, 0xEC,
  // "ń" (U+0144)
  0x30, 0x70, 0x32, 0x8B, 0x26, 0xA0, 0x5B, 0xCE, 0x35, 0xF2, 0xA9, 0x5C, 0x08, 0xA5, 0xC0, 0x8A,
  0x5C, 0x08, 0xA0,
  // "Ņ" (U+0145)
  0x8C, 0x24, 0xF8, 0x04, 0xC4, 0xEE, 0x14, 0xC4, 0xBA, 0x94, 0xC4, 0xC2, 0xF7, 0xC4, 0xC0, 0x9E,
  0xC4, 0xC0, 0x1E, 0xC7, 0x10, 0x40, 0x92,
  // "ņ" (U+0146)
  0x8A, 0x75, 0xBC, 0xE3, 0x5F, 0x2A, 0x95, 0xC0, 0x8A, 0x5C, 0x08, 0xA5, 0xC0, 0x8A, 0x70, 0xD0,
  0x11,
  // "Ň" (U+0147)
  0x18, 0x24, 0x33, 0x42, 0x8C, 0x71, 0xDD, 0x10, 0x4F, 0x80, 0x4C, 0x4E, 0xE1, 0x4C, 0x4B, 0xA9,
  0x4C, 0x4C, 0x2F, 0x7C, 0x4C, 0x09, 0xEC, 0x4C, 0x01, 0xEC,
  // "ň" (U+0148)
  0x18, 0xC0, 0x43, 0x34, 0x01, 0xDD, 0x15, 0xBC, 0xE3, 0x5F, 0x2A, 0x95, 0xC0, 0x8A, 0x5C, 0x08,
  0xA5, 0xC0, 0x8A,
  // "ŉ" (U+0149)
  0x09, 0x08, 0x48, 0xB4, 0xC8, 0xBC, 0xE3, 0x25, 0xF2, 0xA9, 0x05, 0xC0, 0x8A, 0x05, 0xC0, 0x8A,
  0x05, 0xC0, 0x8A,
  // "Ŋ" (U+014A)
  0x8B, 0x64, 0xF9, 0x04, 0xC4, 0xEF, 0x34, 0xC4, 0xC9, 0xD5, 0xC4, 0xC0, 0xDC, 0xC4, 0xC0, 0x4F,
  0xC4, 0xC2, 0x09, 0x0C, 0x40, 0x60, 0xB3, 0x81, 0xCF, 0x53, 0x01, 0x20,
  // "ŋ" (U+014B)
  0x8A, 0x75, 0xAC, 0xE3, 0x5F, 0x2B, 0x95, 0xC0, 0x8A, 0x5C, 0x08, 0xA5, 0xC0, 0x8A, 0x30, 0x09,
  0x28, 0x17, 0xE4,
  // "Ō" (U+014C)
  0x28, 0x1A, 0xEE, 0x20, 0x7A, 0x89, 0x0C, 0x13, 0xF4, 0x2C, 0x97, 0xC2, 0x82, 0x6D, 0x7C, 0x28,
  0x94, 0x6D, 0x3F, 0x42, 0xC9, 0x07, 0xEE, 0xA1,
  // "ō" (U+014D)
  0x18, 0x1A, 0xEE, 0x28, 0xA5, 0xCF, 0xC0, 0x7C, 0x1D, 0x69, 0x90, 0xA8, 0x7C, 0x1D, 0x60, 0xBE,
  0xA1,
  // "Ŏ" (U+014E)
  0x18, 0x23, 0x02, 0x22, 0x82, 0x5E, 0xD1, 0x30, 0x14, 0x89, 0x37, 0xEE, 0xA1, 0x3F, 0x42, 0xC9,
  0x7C, 0x28, 0x26, 0xD7, 0xC2, 0x89, 0x46, 0xD3, 0xF4, 0x2C, 0x90, 0x7E, 0xEA, 0x10,
  // "ŏ" (U+014F)
  0x18, 0x73, 0x02, 0x20, 0x5E, 0xD1, 0x20, 0x13, 0x8A, 0x5B, 0xEA, 0x07, 0xC1, 0xD6, 0x99, 0x0A,
  0x87, 0xC1, 0xD6, 0x0B, 0xEA, 0x10,
  // "Ő" (U+0150)
  0x28, 0x23, 0xAA, 0x52, 0x81, 0x10, 0x12, 0x89, 0x37, 0xEE, 0xA1, 0x3F, 0x42, 0xC9, 0x7C, 0x28,
  0x26, 0xD7, 0xC2, 0x89, 0x46, 0xD3, 0xF4, 0x2C, 0x90, 0x7E, 0xEA, 0x10,
  // "ő" (U+0151)
  0x18, 0x63, 0xAA, 0x50, 0x10, 0x12, 0x8A, 0x5B, 0xEA, 0x07, 0xC1, 0xD6, 0x99, 0x0A, 0x87, 0xC1,
  0xD6, 0x0B, 0xEA, 0x10,
  // "Œ" (U+0152)
  0x10, 0x70, 0xEC, 0x8B, 0x64, 0x4F, 0x32, 0xF2, 0x10, 0x7B, 0x01, 0xFE, 0xE2, 0x7B, 0x01, 0xF3,
  0x10, 0x4F, 0x32, 0xF2, 0x12, 0x07, 0x0E, 0xC0, 0x40,
  // "œ" (U+0153)
  0x8C, 0x61, 0xBE, 0x9A, 0xEA, 0x07, 0xC1, 0xDC, 0x2C, 0x59, 0x90, 0xAF, 0xEF, 0x77, 0xC1, 0xDC,
  0x34, 0x20, 0xBE, 0xA9, 0xED, 0x20,
  // "Ŕ" (U+0154)
  0x30, 0x70, 0x33, 0x06, 0x0A, 0x20, 0x4A, 0x8A, 0x1D, 0x30, 0x4E, 0x1B, 0x90, 0x4F, 0xED, 0x30,
  0x4E, 0x4E, 0x28, 0x92, 0x4E, 0x0C, 0x70, 0x4E, 0x04, 0xE1,
  // "ŕ" (U+0155)
  0x28, 0x96, 0x73, 0x06, 0xA0, 0x5B, 0xC6, 0x5F, 0x30, 0x5C, 0x20, 0x50, 0xC2, 0x05, 0x0C, 0x20,
  // "Ŗ" (U+0156)
  0x04, 0xA8, 0xA1, 0xD3, 0x04, 0xE1, 0xB9, 0x04, 0xFE, 0xD3, 0x04, 0xE4, 0xE2, 0x89, 0x24, 0xE0,
  0xC7, 0x04, 0xE0, 0x4E, 0x17, 0x10, 0xA0, 0x32,
  // "ŗ" (U+0157)
  0x89, 0x05, 0xBC, 0x65, 0xF3, 0x05, 0xC2, 0x05, 0x0C, 0x20, 0x50, 0xC6, 0x04, 0x09, 0x20,
  // "Ř" (U+0158)
  0x18, 0x24, 0x33, 0x42, 0x84, 0x1D, 0xD1, 0x04, 0xA8, 0xA1, 0xD3, 0x04, 0xE1, 0xB9, 0x04, 0xFE,
  0xD3, 0x04, 0xE4, 0xE2, 0x89, 0x24, 0xE0, 0xC7, 0x04, 0xE0, 0x4E, 0x10,
  // "ř" (U+0159)
  0x8A, 0x04, 0x33, 0x41, 0xDD, 0x15, 0xBC, 0x65, 0xF3, 0x05, 0xC2, 0x05, 0x0C, 0x20, 0x50, 0xC2,
  // "Ś" (U+015A)
  0x28, 0x97, 0x73, 0x06, 0xA0, 0x2C, 0xEB, 0x7B, 0x13, 0x4E, 0x82, 0x89, 0x13, 0xCC, 0x32, 0x4F,
  0x7E, 0xE7,
  // "ś" (U+015B)
  0x28, 0xB0, 0x73, 0x06, 0xA0, 0x4E, 0xE6, 0x9B, 0x21, 0x2B, 0xD3, 0x31, 0xA9, 0x7F, 0xD4,
  // "Ŝ" (U+015C)
  0x18, 0xA0, 0x66, 0x05, 0xAA, 0x62, 0xCE, 0xB7, 0xB1, 0x34, 0xE8, 0x28, 0x91, 0x3C, 0xC3, 0x24,
  0xF7, 0xEE, 0x70,
  // "ŝ" (U+015D)
  0x18, 0xB1, 0x66, 0x05, 0xAA, 0x64, 0xEE, 0x69, 0xB2, 0x12, 0xBD, 0x33, 0x1A, 0x97, 0xFD, 0x40,
  // "Ş" (U+015E)
  0x89, 0x12, 0xCE, 0xB7, 0xB1, 0x34, 0xE8, 0x28, 0xA0, 0x3C, 0xC3, 0x24, 0xF7, 0xFE, 0x70, 0x96,
  0x01, 0xB5, 0x10,
  // "ş" (U+015F)
  0x8B, 0x14, 0xEE, 0x69, 0xB2, 0x12, 0xBD, 0x33, 0x1A, 0x97, 0xFE, 0x40, 0x96, 0x01, 0xB5, 0x10,
  // "Š" (U+0160)
  0x8A, 0x14, 0x33, 0x41, 0xDD, 0x12, 0xCE, 0xB7, 0xB1, 0x34, 0xE8, 0x28, 0x91, 0x3C, 0xC3, 0x24,
  0xF7, 0xEE, 0x70,
  // "š" (U+0161)
  0x8B, 0x24, 0x33, 0x41, 0xDD, 0x14, 0xEE, 0x69, 0xB2, 0x12, 0xBD, 0x33, 0x1A, 0x97, 0xFD, 0x40,
  // "Ţ" (U+0162)
  0x0D, 0xB8, 0x37, 0x05, 0xE1, 0x20, 0x40, 0xE3, 0x04, 0x0E, 0x30, 0x40, 0xE3, 0x04, 0x94, 0x09,
  0x06, 0x28, 0x11, 0xB5, 0x10,
  // "ţ" (U+0163)
  0x10, 0xD2, 0x0A, 0xA8, 0x12, 0x4E, 0x20, 0x30, 0xE2, 0x81, 0x3F, 0x12, 0x89, 0x0E, 0xF2, 0x09,
  0x60, 0x1B, 0x51,
  // "Ť" (U+0164)
  0x89, 0x14, 0x33, 0x40, 0x1D, 0xD1, 0x0D, 0xB8, 0x37, 0x05, 0xE1, 0x20, 0x40, 0xE3, 0x04, 0x0E,
  0x30, 0x40, 0xE3, 0x04, 0x0E, 0x20,
  // "ť" (U+0165)
  0x18, 0x44, 0x0A, 0x40, 0xE3, 0x0A, 0xA8, 0x22, 0x04, 0xE3, 0x03, 0x0E, 0x38, 0x13, 0xF1, 0x38,
  0x1C, 0xE2, 0x10,
  // "Ŧ" (U+0166)
  0x0D, 0xB8, 0x90, 0x70, 0x5E, 0x10, 0x3E, 0xFC, 0x28, 0x15, 0xE1, 0x20, 0x40, 0xE3, 0x04, 0x0E,
  0x20,
  // "ŧ" (U+0167)
  0x10, 0xD2, 0x0A, 0xA8, 0x12, 0x4E, 0x28, 0x92, 0xBF, 0xE0, 0x4F, 0x30, 0x1D, 0xE2,
  // "Ũ" (U+0168)
  0x18, 0x93, 0x6E, 0xE5, 0x04, 0xF1, 0x1D, 0x54, 0xD2, 0x82, 0xD5, 0x4D, 0x28, 0x2D, 0x54, 0xD2,
  0x89, 0x3D, 0x52, 0xF4, 0x3F, 0x30, 0x7E, 0xE8, 0x10,
  // "ũ" (U+0169)
  0x18, 0xB3, 0x6E, 0xE5, 0x6D, 0x1A, 0x96, 0xC0, 0x89, 0x6C, 0x08, 0x95, 0xD0, 0xB9, 0x1C, 0xEA,
  0x90,
  // "Ū" (U+016A)
  0x18, 0x1A, 0xEE, 0x28, 0x64, 0xF1, 0x1D, 0x54, 0xD2, 0x82, 0xD5, 0x4D, 0x28, 0x2D, 0x54, 0xD2,
  0x89, 0x3D, 0x52, 0xF4, 0x3F, 0x30, 0x7E, 0xE8, 0x10,
  // "ū" (U+016B)
  0x18, 0xB3, 0xAE, 0xE0, 0x6D, 0x1A, 0x96, 0xC0, 0x89, 0x6C, 0x08, 0x95, 0xD0, 0xB9, 0x1C, 0xEA,
  0x90,
  // "Ŭ" (U+016C)
  0x18, 0x23, 0x02, 0x22, 0x82, 0x5E, 0xD1, 0x30, 0x13, 0x04, 0x0D, 0x28, 0x2D, 0x54, 0xD2, 0x82,
  0xD5, 0x4D, 0x28, 0x2D, 0x54, 0xD2, 0x89, 0x3D, 0x52, 0xF4, 0x3F, 0x30, 0x7E, 0xE8, 0x10,
  // "ŭ" (U+016D)
  0x18, 0x73, 0x02, 0x20, 0x5E, 0xD1, 0x20, 0x12, 0x8A, 0x76, 0xC0, 0x89, 0x6C, 0x08, 0x96, 0xC0,
  0x89, 0x5D, 0x0B, 0x91, 0xCE, 0xA9,
  // "Ů" (U+016E)
  0x28, 0x15, 0x91, 0x38, 0x45, 0x91, 0x04, 0xD2, 0x82, 0xD5, 0x4D, 0x28, 0x2D, 0x54, 0xD2, 0x82,
  0xD5, 0x4D, 0x28, 0x93, 0xD5, 0x2F, 0x43, 0xF3, 0x07, 0xEE, 0x81,
  // "ů" (U+016F)
  0x18, 0x15, 0x91, 0x28, 0xB3, 0x59, 0x10, 0x6C, 0x08, 0x96, 0xC0, 0x89, 0x6C, 0x08, 0x95, 0xD0,
  0xB9, 0x1C, 0xEA, 0x90,
  // "Ű" (U+0170)
  0x28, 0x23, 0xAA, 0x52, 0x84, 0x10, 0x10, 0x4D, 0x28, 0x2D, 0x54, 0xD2, 0x82, 0xD5, 0x4D, 0x28,
  0x2D, 0x54, 0xD2, 0x89, 0x3D, 0x52, 0xF4, 0x3F, 0x30, 0x7E, 0xE8, 0x10,
  // "ű" (U+0171)
  0x18, 0xC0, 0x3A, 0xA5, 0x01, 0x01, 0x06, 0xC0, 0x89, 0x6C, 0x08, 0x96, 0xC0, 0x89, 0x5D, 0x0B,
  0x91, 0xCE, 0xA9,
  // "Ų" (U+0172)
  0x04, 0x0D, 0x28, 0x2D, 0x54, 0xD2, 0x82, 0xD5, 0x4D, 0x28, 0x2D, 0x54, 0xD2, 0x89, 0x3D, 0x52,
  0xF4, 0x3F, 0x20, 0x7E, 0xF7, 0x40, 0xB5, 0x0B, 0x09, 0x10,
  // "ų" (U+0173)
  0x8A, 0x76, 0xC0, 0x89, 0x6C, 0x08, 0x96, 0xC0, 0x89, 0x5D, 0x0B, 0x91, 0xCE, 0xBD, 0x30, 0x70,
  0x33, 0x08, 0x0D, 0x40, 0x10,
  // "Ŵ" (U+0174)
  0x30, 0x06, 0x58, 0x25, 0xAA, 0x62, 0x8B, 0x5D, 0x40, 0xC8, 0x08, 0x99, 0x81, 0xEC, 0x0C, 0x56,
  0xB4, 0xAE, 0x1F, 0x12, 0xE8, 0x6B, 0x8D, 0x28, 0x4E, 0xD3, 0x7D, 0x92, 0x84, 0xAE, 0x03, 0xF6,
  0x10,
  // "ŵ" (U+0175)
  0x20, 0x06, 0x48, 0x25, 0xAA, 0x62, 0x8B, 0x1C, 0x55, 0xF3, 0x89, 0x89, 0x8C, 0x6B, 0x64, 0xCC,
  0x59, 0xE2, 0x1E, 0xC1, 0xDD, 0x28, 0x3C, 0xA0, 0xD9, 0x10,
  // "Ŷ" (U+0176)
  0x10, 0x06, 0x28, 0xA1, 0x5A, 0xA6, 0x0B, 0x80, 0x8B, 0x3F, 0x3F, 0x30, 0xBE, 0xA2, 0x81, 0x3F,
  0x32, 0x81, 0x1F, 0x12, 0x81, 0x1F, 0x11,
  // "ŷ" (U+0177)
  0x10, 0x06, 0x28, 0xA1, 0x5A, 0xA6, 0x0C, 0x60, 0xD5, 0x7B, 0x2F, 0x11, 0xF8, 0xA2, 0x81, 0xBE,
  0x52, 0x06, 0x92, 0x81, 0x19, 0xA2, 0x81, 0xBD, 0x22,
  // "Ÿ" (U+0178)
  0x18, 0x1B, 0x49, 0x68, 0x94, 0xB8, 0x08, 0xB3, 0xF3, 0xF3, 0x0B, 0xEA, 0x28, 0x13, 0xF3, 0x28,
  0x11, 0xF1, 0x28, 0x11, 0xF1, 0x10,
  // "Ź" (U+0179)
  0x20, 0x70, 0x32, 0x06, 0x0A, 0x20, 0xBB, 0x83, 0x50, 0x16, 0xD2, 0x81, 0x1E, 0x42, 0x0A, 0x09,
  0x28, 0x45, 0xD1, 0x10, 0xCB, 0x06,
  // "ź" (U+017A)
  0x28, 0x57, 0x30, 0x6A, 0x0A, 0xA8, 0x94, 0x90, 0x2E, 0x30, 0xA8, 0x05, 0xD1, 0x0B, 0xA0, 0xA0,
  // "Ż" (U+017B)
  0x10, 0x80, 0x77, 0x0B, 0xB8, 0x35, 0x01, 0x6D, 0x28, 0x11, 0xE4, 0x20, 0xA0, 0x92, 0x84, 0x5D,
  0x11, 0x0C, 0xB0, 0x60,
  // "ż" (U+017C)
  0x10, 0x80, 0x75, 0x0A, 0xA8, 0x94, 0x90, 0x2E, 0x30, 0xA8, 0x05, 0xD1, 0x0B, 0xA0, 0xA0,
  // "Ž" (U+017D)
  0x89, 0x14, 0x33, 0x40, 0x1D, 0xD1, 0x0B, 0xB8, 0x35, 0x01, 0x6D, 0x28, 0x11, 0xE4, 0x20, 0xA0,
  0x92, 0x84, 0x5D, 0x11, 0x0C, 0xB0, 0x60,
  // "ž" (U+017E)
  0x87, 0x43, 0x34, 0x1D, 0xD1, 0xAA, 0x89, 0x49, 0x02, 0xE3, 0x0A, 0x80, 0x5D, 0x10, 0xBA, 0x0A,
  // "ſ" (U+017F)
  0x89, 0x01, 0xCE, 0x15, 0xD2, 0x05, 0xC2, 0x05, 0x0C, 0x20, 0x50, 0xC2, 0x05, 0x0C, 0x20, 0x50,
  0xC2,
  // "Ω" (U+03A9)
  0x18, 0x95, 0x8E, 0xEA, 0x10, 0x5E, 0x32, 0xCA, 0x08, 0xB2, 0x83, 0x6C, 0x06, 0xC2, 0x89, 0x48,
  0xA0, 0x1C, 0x42, 0xC3, 0x0C, 0xFB, 0x6A, 0x01,
  // "μ" (U+03BC)
  0x8B, 0x15, 0xC0, 0x8A, 0x5C, 0x08, 0xA5, 0xC0, 0x8A, 0x5E, 0x2C, 0xA5, 0xEE, 0xBA, 0x5C, 0x30,
  0x50, 0xC3,
  // "π" (U+03C0)
  0x0B, 0xC8, 0x49, 0x0F, 0x38, 0xB2, 0x98, 0x13, 0x7B, 0x29, 0x81, 0x37, 0xC2, 0x98, 0x23, 0x3E,
  0x70,
  // "–" (U+2013)
  0x82, 0xAE, 0xEA, 0x80, 0x01,
  // "—" (U+2014)
  0x0A, 0x80, 0x2E, 0x0A, 0x80, 0x41,
  // "€" (U+20AC)
  0x18, 0xA0, 0x4D, 0xE4, 0x0E, 0x52, 0x0A, 0xFC, 0x60, 0xAF, 0xC3, 0x28, 0x7E, 0x51, 0x10, 0x5D,
  0xE3,
  // "₿" (U+20BF)
  0x18, 0x36, 0x61, 0x04, 0xA8, 0x6A, 0x04, 0xE3, 0xF1, 0x4A, 0x89, 0x3C, 0x04, 0xE3, 0xF3, 0x4E,
  0x2F, 0x34, 0xA0, 0xA2, 0x81, 0x66, 0x11,
  // "‘" (U+2018)
  0x83, 0x68, 0xB5, 0x21,
  // "’" (U+2019)
  0x83, 0x98, 0xC3, 0x21,
  // "‚" (U+201A)
  0x83, 0x98, 0xC3, 0x21,
  // "‛" (U+201B)
  0x84, 0xC5, 0x77, 0x01,
  // "“" (U+201C)
  0x89, 0x16, 0x89, 0x5B, 0x5E, 0x22, 0x02, 0x10,
  // "”" (U+201D)
  0x89, 0x19, 0x8C, 0x5C, 0x3E, 0x02, 0x01, 0x10,
  // "„" (U+201E)
  0x89, 0x19, 0x8C, 0x5C, 0x3E, 0x02, 0x01, 0x10,
  // "‟" (U+201F)
  0x86, 0xC5, 0xE2, 0x77, 0x95, 0x10, 0xF1,
  // "†" (U+2020)
  0x18, 0x94, 0x77, 0x01, 0x67, 0x16, 0xDD, 0x80, 0x56, 0x20, 0x06, 0x20, 0x60, 0x72, 0x07, 0x08,
  0x10,
  // "‡" (U+2021)
  0x18, 0xB0, 0x68, 0x03, 0x79, 0x35, 0xBB, 0x70, 0x68, 0x05, 0xAB, 0x63, 0x89, 0x40, 0x68, 0x10,
  // "•" (U+2022)
  0x87, 0x3C, 0x39, 0xF9, 0x5E, 0x50,
  // "…" (U+2026)
  0x85, 0x6A, 0x6A, 0x06, 0xA0,
  // "‰" (U+2030)
  0x84, 0x6E, 0x80, 0x85, 0x48, 0x3B, 0x7E, 0x1C, 0x58, 0xA2, 0x7F, 0xA9, 0x9D, 0x74, 0xD7, 0x01,
  0x2C, 0xA8, 0xDA, 0x7E, 0x28, 0xA0, 0xA4, 0xA7, 0xDA, 0x7E, 0x03, 0xB0, 0x5E, 0x74, 0xE8,
  // "‹" (U+2039)
  0x18, 0x91, 0x95, 0x6C, 0x03, 0xE2, 0x04, 0x30,
  // "›" (U+203A)
  0x05, 0x09, 0x28, 0x5C, 0x53, 0xE2, 0x34, 0x10,
  // "⁄" (U+2044)
  0x30, 0x90, 0x42, 0x02, 0x0B, 0x30, 0xA0, 0x32, 0x03, 0x0B, 0x30, 0xB0, 0x32, 0x04, 0x0A, 0x30,
  // "™" (U+2122)
  0x8A, 0x66, 0x86, 0x52, 0x61, 0x76, 0x86, 0x81, 0x76, 0x76, 0x80, 0x11, 0x01, 0x10,
  // "⅒" (U+2152)
  0x40, 0x90, 0x43, 0x83, 0x3D, 0x42, 0xB4, 0x8A, 0x01, 0x94, 0xA3, 0x05, 0xC5, 0x09, 0x7B, 0x3D,
  0xF5, 0xC2, 0x89, 0x0B, 0x31, 0x9F, 0x5C, 0x04, 0xA2, 0x82, 0x99, 0xC5,
  // "ﬁ" (U+FB01)
  0x18, 0x5B, 0xE9, 0xB2, 0xF2, 0x20, 0xBA, 0x8A, 0x46, 0xC3, 0xF1, 0x5C, 0x2F, 0x05, 0xC2, 0xF0,
  0x5C, 0x2F, 0x05, 0xC0,
  // "ﬂ" (U+FB02)
  0x18, 0x90, 0xBE, 0xAC, 0x2F, 0x26, 0xCB, 0xA8, 0xA4, 0x6C, 0x3F, 0x15, 0xC2, 0xF0, 0x5C, 0x2F,
  0x05, 0xC2, 0xF0, 0x5C,
};

const Font& font_NotoSans_Bold_8() {
  static SmoothFont font(font_NotoSans_Bold_8_data);
  return font;
}

}  // namespace roo_display
