#include "60.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSansMono-Bold (Noto Sans Mono Bold)
// Generated on Sun Mar 06 15:50:06 CET 2022
static const uint8_t font_NotoSansMono_Bold_60_data[] PROGMEM = {
  
  // Header
  0x01, 0x01, 0x04, 0x02, 0x01, 0x03, 0x01, 0x01, 0x5D, 0x00, 0x00,
  0xF4, 0xF3, 0x5E, 0x3C, 0x2D, 0xF2, 0x0F, 0x00, 0x6C, 0x10, 0x24, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x0C, 0x00, 0x17, 0x2A, 0x24, 0x00, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x07, 0x1C, 0x1C, 0x2A, 0x24, 0x00, 0x00, 0x81, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x23, 0x2A, 0x24, 0x00, 0x00, 0xD7, // "#" (U+0023)
  0x00, 0x24, 0x04, 0xFE, 0x1F, 0x2E, 0x24, 0x00, 0x01, 0xDD, // "$" (U+0024)
  0x00, 0x25, 0x00, 0x00, 0x23, 0x2B, 0x24, 0x00, 0x03, 0x02, // "%" (U+0025)
  0x00, 0x26, 0x01, 0x00, 0x22, 0x2B, 0x24, 0x00, 0x04, 0x6D, // "&" (U+0026)
  0x00, 0x27, 0x0D, 0x1C, 0x16, 0x2A, 0x24, 0x00, 0x05, 0x92, // "'" (U+0027)
  0x00, 0x28, 0x0B, 0xF7, 0x1A, 0x2A, 0x24, 0x00, 0x05, 0xBC, // "(" (U+0028)
  0x00, 0x29, 0x09, 0xF8, 0x18, 0x2B, 0x24, 0x00, 0x06, 0x62, // ")" (U+0029)
  0x00, 0x2A, 0x04, 0x14, 0x1F, 0x2D, 0x24, 0x00, 0x07, 0x08, // "*" (U+002A)
  0x00, 0x2B, 0x04, 0x08, 0x1F, 0x23, 0x24, 0x00, 0x07, 0xA9, // "+" (U+002B)
  0x00, 0x2C, 0x0B, 0xF8, 0x17, 0x08, 0x24, 0x00, 0x08, 0x18, // "," (U+002C)
  0x00, 0x2D, 0x09, 0x0D, 0x1A, 0x13, 0x24, 0x00, 0x08, 0x4B, // "-" (U+002D)
  0x00, 0x2E, 0x0C, 0x00, 0x17, 0x0A, 0x24, 0x00, 0x08, 0x51, // "." (U+002E)
  0x00, 0x2F, 0x06, 0x01, 0x1D, 0x2A, 0x24, 0x00, 0x08, 0x78, // "/" (U+002F)
  0x00, 0x30, 0x03, 0x00, 0x20, 0x2B, 0x24, 0x00, 0x09, 0x22, // "0" (U+0030)
  0x00, 0x31, 0x04, 0x01, 0x1F, 0x2A, 0x24, 0x00, 0x0A, 0x4B, // "1" (U+0031)
  0x00, 0x32, 0x03, 0x01, 0x21, 0x2B, 0x24, 0x00, 0x0B, 0x14, // "2" (U+0032)
  0x00, 0x33, 0x04, 0x00, 0x20, 0x2B, 0x24, 0x00, 0x0C, 0x06, // "3" (U+0033)
  0x00, 0x34, 0x02, 0x01, 0x21, 0x2A, 0x24, 0x00, 0x0C, 0xFE, // "4" (U+0034)
  0x00, 0x35, 0x04, 0x00, 0x1F, 0x2A, 0x24, 0x00, 0x0D, 0xEC, // "5" (U+0035)
  0x00, 0x36, 0x03, 0x00, 0x20, 0x2A, 0x24, 0x00, 0x0E, 0xD2, // "6" (U+0036)
  0x00, 0x37, 0x03, 0x01, 0x20, 0x2A, 0x24, 0x00, 0x0F, 0xE6, // "7" (U+0037)
  0x00, 0x38, 0x03, 0x00, 0x20, 0x2B, 0x24, 0x00, 0x10, 0x8F, // "8" (U+0038)
  0x00, 0x39, 0x03, 0x00, 0x20, 0x2B, 0x24, 0x00, 0x11, 0xB0, // "9" (U+0039)
  0x00, 0x3A, 0x0C, 0x00, 0x17, 0x21, 0x24, 0x00, 0x12, 0xC6, // ":" (U+003A)
  0x00, 0x3B, 0x0B, 0xF8, 0x18, 0x21, 0x24, 0x00, 0x13, 0x16, // ";" (U+003B)
  0x00, 0x3C, 0x05, 0x07, 0x1E, 0x25, 0x24, 0x00, 0x13, 0x75, // "<" (U+003C)
  0x00, 0x3D, 0x04, 0x0C, 0x1F, 0x1F, 0x24, 0x00, 0x14, 0x1C, // "=" (U+003D)
  0x00, 0x3E, 0x05, 0x07, 0x1E, 0x25, 0x24, 0x00, 0x14, 0x53, // ">" (U+003E)
  0x00, 0x3F, 0x05, 0x00, 0x1F, 0x2B, 0x24, 0x00, 0x14, 0xF9, // "?" (U+003F)
  0x00, 0x40, 0x00, 0xFB, 0x23, 0x2A, 0x24, 0x00, 0x15, 0xCF, // "@" (U+0040)
  0x00, 0x41, 0x00, 0x01, 0x23, 0x2A, 0x24, 0x00, 0x17, 0x7A, // "A" (U+0041)
  0x00, 0x42, 0x04, 0x01, 0x21, 0x2A, 0x24, 0x00, 0x18, 0x73, // "B" (U+0042)
  0x00, 0x43, 0x03, 0x00, 0x21, 0x2B, 0x24, 0x00, 0x19, 0x7A, // "C" (U+0043)
  0x00, 0x44, 0x02, 0x01, 0x22, 0x2A, 0x24, 0x00, 0x1A, 0x6A, // "D" (U+0044)
  0x00, 0x45, 0x04, 0x01, 0x1F, 0x2A, 0x24, 0x00, 0x1B, 0x8D, // "E" (U+0045)
  0x00, 0x46, 0x04, 0x01, 0x1F, 0x2A, 0x24, 0x00, 0x1C, 0x48, // "F" (U+0046)
  0x00, 0x47, 0x01, 0x00, 0x21, 0x2B, 0x24, 0x00, 0x1D, 0x05, // "G" (U+0047)
  0x00, 0x48, 0x02, 0x01, 0x21, 0x2A, 0x24, 0x00, 0x1E, 0x23, // "H" (U+0048)
  0x00, 0x49, 0x05, 0x01, 0x1E, 0x2A, 0x24, 0x00, 0x1F, 0x25, // "I" (U+0049)
  0x00, 0x4A, 0x05, 0x00, 0x1D, 0x2A, 0x24, 0x00, 0x1F, 0xE6, // "J" (U+004A)
  0x00, 0x4B, 0x02, 0x01, 0x21, 0x2A, 0x24, 0x00, 0x20, 0xB6, // "K" (U+004B)
  0x00, 0x4C, 0x05, 0x01, 0x1F, 0x2A, 0x24, 0x00, 0x21, 0xE2, // "L" (U+004C)
  0x00, 0x4D, 0x02, 0x01, 0x21, 0x2A, 0x24, 0x00, 0x22, 0x9B, // "M" (U+004D)
  0x00, 0x4E, 0x02, 0x01, 0x21, 0x2A, 0x24, 0x00, 0x23, 0xF2, // "N" (U+004E)
  0x00, 0x4F, 0x01, 0x00, 0x22, 0x2B, 0x24, 0x00, 0x25, 0x16, // "O" (U+004F)
  0x00, 0x50, 0x04, 0x01, 0x21, 0x2A, 0x24, 0x00, 0x26, 0x41, // "P" (U+0050)
  0x00, 0x51, 0x01, 0xF6, 0x22, 0x2B, 0x24, 0x00, 0x27, 0x32, // "Q" (U+0051)
  0x00, 0x52, 0x04, 0x01, 0x22, 0x2A, 0x24, 0x00, 0x28, 0x8F, // "R" (U+0052)
  0x00, 0x53, 0x04, 0x00, 0x20, 0x2B, 0x24, 0x00, 0x29, 0xA9, // "S" (U+0053)
  0x00, 0x54, 0x01, 0x01, 0x22, 0x2A, 0x24, 0x00, 0x2A, 0xA5, // "T" (U+0054)
  0x00, 0x55, 0x02, 0x00, 0x21, 0x2A, 0x24, 0x00, 0x2B, 0x73, // "U" (U+0055)
  0x00, 0x56, 0x00, 0x01, 0x23, 0x2A, 0x24, 0x00, 0x2C, 0x94, // "V" (U+0056)
  0x00, 0x57, 0x00, 0x01, 0x23, 0x2A, 0x24, 0x00, 0x2D, 0xA3, // "W" (U+0057)
  0x00, 0x58, 0x01, 0x01, 0x22, 0x2A, 0x24, 0x00, 0x2F, 0x17, // "X" (U+0058)
  0x00, 0x59, 0x01, 0x01, 0x22, 0x2A, 0x24, 0x00, 0x30, 0x23, // "Y" (U+0059)
  0x00, 0x5A, 0x04, 0x01, 0x1F, 0x2A, 0x24, 0x00, 0x31, 0x19, // "Z" (U+005A)
  0x00, 0x5B, 0x0D, 0xF7, 0x1C, 0x2A, 0x24, 0x00, 0x31, 0xD7, // "[" (U+005B)
  0x00, 0x5C, 0x06, 0x01, 0x1D, 0x2A, 0x24, 0x00, 0x32, 0x6E, // "\" (U+005C)
  0x00, 0x5D, 0x07, 0xF9, 0x16, 0x2C, 0x24, 0x00, 0x33, 0x15, // "]" (U+005D)
  0x00, 0x5E, 0x02, 0x11, 0x21, 0x2B, 0x24, 0x00, 0x33, 0xAC, // "^" (U+005E)
  0x00, 0x5F, 0x00, 0xF6, 0x23, 0xFC, 0x24, 0x00, 0x34, 0x50, // "_" (U+005F)
  0x00, 0x60, 0x08, 0x25, 0x17, 0x2E, 0x24, 0x00, 0x34, 0x56, // "`" (U+0060)
  0x00, 0x61, 0x03, 0x00, 0x20, 0x21, 0x24, 0x00, 0x34, 0x7E, // "a" (U+0061)
  0x00, 0x62, 0x03, 0x00, 0x21, 0x2D, 0x24, 0x00, 0x35, 0x59, // "b" (U+0062)
  0x00, 0x63, 0x04, 0x00, 0x1E, 0x21, 0x24, 0x00, 0x36, 0x82, // "c" (U+0063)
  0x00, 0x64, 0x02, 0x00, 0x20, 0x2D, 0x24, 0x00, 0x37, 0x39, // "d" (U+0064)
  0x00, 0x65, 0x03, 0x00, 0x20, 0x21, 0x24, 0x00, 0x38, 0x62, // "e" (U+0065)
  0x00, 0x66, 0x04, 0x01, 0x22, 0x2D, 0x24, 0x00, 0x39, 0x18, // "f" (U+0066)
  0x00, 0x67, 0x02, 0xF3, 0x20, 0x21, 0x24, 0x00, 0x39, 0xF1, // "g" (U+0067)
  0x00, 0x68, 0x03, 0x01, 0x20, 0x2D, 0x24, 0x00, 0x3B, 0x34, // "h" (U+0068)
  0x00, 0x69, 0x03, 0x01, 0x20, 0x2E, 0x24, 0x00, 0x3C, 0x24, // "i" (U+0069)
  0x00, 0x6A, 0x02, 0xF3, 0x19, 0x2F, 0x24, 0x00, 0x3C, 0xF2, // "j" (U+006A)
  0x00, 0x6B, 0x03, 0x01, 0x22, 0x2D, 0x24, 0x00, 0x3D, 0xEB, // "k" (U+006B)
  0x00, 0x6C, 0x03, 0x01, 0x20, 0x2D, 0x24, 0x00, 0x3F, 0x16, // "l" (U+006C)
  0x00, 0x6D, 0x01, 0x01, 0x22, 0x21, 0x24, 0x00, 0x3F, 0xE7, // "m" (U+006D)
  0x00, 0x6E, 0x03, 0x01, 0x20, 0x21, 0x24, 0x00, 0x40, 0xF7, // "n" (U+006E)
  0x00, 0x6F, 0x02, 0x00, 0x21, 0x21, 0x24, 0x00, 0x41, 0xBA, // "o" (U+006F)
  0x00, 0x70, 0x03, 0xF3, 0x21, 0x21, 0x24, 0x00, 0x42, 0xA2, // "p" (U+0070)
  0x00, 0x71, 0x02, 0xF3, 0x20, 0x21, 0x24, 0x00, 0x43, 0xCF, // "q" (U+0071)
  0x00, 0x72, 0x02, 0x01, 0x22, 0x21, 0x24, 0x00, 0x44, 0xFA, // "r" (U+0072)
  0x00, 0x73, 0x04, 0x00, 0x1F, 0x21, 0x24, 0x00, 0x45, 0xA7, // "s" (U+0073)
  0x00, 0x74, 0x03, 0x00, 0x1F, 0x29, 0x24, 0x00, 0x46, 0x71, // "t" (U+0074)
  0x00, 0x75, 0x03, 0x00, 0x20, 0x20, 0x24, 0x00, 0x47, 0x38, // "u" (U+0075)
  0x00, 0x76, 0x01, 0x01, 0x22, 0x20, 0x24, 0x00, 0x47, 0xFC, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x01, 0x23, 0x20, 0x24, 0x00, 0x48, 0xCA, // "w" (U+0077)
  0x00, 0x78, 0x01, 0x01, 0x22, 0x20, 0x24, 0x00, 0x49, 0xE2, // "x" (U+0078)
  0x00, 0x79, 0x01, 0xF3, 0x22, 0x20, 0x24, 0x00, 0x4A, 0xC0, // "y" (U+0079)
  0x00, 0x7A, 0x03, 0x01, 0x20, 0x20, 0x24, 0x00, 0x4B, 0xD9, // "z" (U+007A)
  0x00, 0x7B, 0x08, 0xF6, 0x1B, 0x2A, 0x24, 0x00, 0x4C, 0x72, // "{" (U+007B)
  0x00, 0x7C, 0x0E, 0xF3, 0x15, 0x2D, 0x24, 0x00, 0x4D, 0x2E, // "|" (U+007C)
  0x00, 0x7D, 0x08, 0xF8, 0x1B, 0x2C, 0x24, 0x00, 0x4D, 0xC2, // "}" (U+007D)
  0x00, 0x7E, 0x04, 0x11, 0x1F, 0x1B, 0x24, 0x00, 0x4E, 0x7D, // "~" (U+007E)
  0x00, 0xA1, 0x0C, 0xF7, 0x17, 0x21, 0x24, 0x00, 0x4E, 0xDC, // "¡" (U+00A1)
  0x00, 0xA2, 0x04, 0x00, 0x1F, 0x2A, 0x24, 0x00, 0x4F, 0x5E, // "¢" (U+00A2)
  0x00, 0xA3, 0x04, 0x01, 0x20, 0x2B, 0x24, 0x00, 0x50, 0x3E, // "£" (U+00A3)
  0x00, 0xA4, 0x03, 0x09, 0x20, 0x24, 0x24, 0x00, 0x51, 0x06, // "¤" (U+00A4)
  0x00, 0xA5, 0x01, 0x01, 0x22, 0x2A, 0x24, 0x00, 0x51, 0xCA, // "¥" (U+00A5)
  0x00, 0xA6, 0x0E, 0xF3, 0x15, 0x2D, 0x24, 0x00, 0x52, 0xBB, // "¦" (U+00A6)
  0x00, 0xA7, 0x06, 0x00, 0x1D, 0x2D, 0x24, 0x00, 0x53, 0x36, // "§" (U+00A7)
  0x00, 0xA8, 0x06, 0x25, 0x1D, 0x2D, 0x24, 0x00, 0x54, 0x42, // "¨" (U+00A8)
  0x00, 0xA9, 0x01, 0x06, 0x22, 0x25, 0x24, 0x00, 0x54, 0x81, // "©" (U+00A9)
  0x00, 0xAA, 0x08, 0x17, 0x1B, 0x2B, 0x24, 0x00, 0x55, 0xAF, // "ª" (U+00AA)
  0x00, 0xAB, 0x03, 0x04, 0x20, 0x1E, 0x24, 0x00, 0x56, 0x27, // "«" (U+00AB)
  0x00, 0xAC, 0x04, 0x08, 0x1F, 0x18, 0x24, 0x00, 0x56, 0xF7, // "¬" (U+00AC)
  0x00, 0xAE, 0x01, 0x06, 0x22, 0x25, 0x24, 0x00, 0x57, 0x3D, // "®" (U+00AE)
  0x00, 0xAF, 0x08, 0x26, 0x1B, 0x2B, 0x24, 0x00, 0x58, 0x79, // "¯" (U+00AF)
  0x00, 0xB0, 0x08, 0x19, 0x1B, 0x2B, 0x24, 0x00, 0x58, 0x8C, // "°" (U+00B0)
  0x00, 0xB1, 0x04, 0x01, 0x1F, 0x25, 0x24, 0x00, 0x58, 0xF5, // "±" (U+00B1)
  0x00, 0xB2, 0x09, 0x1A, 0x1B, 0x33, 0x24, 0x00, 0x59, 0x82, // "²" (U+00B2)
  0x00, 0xB3, 0x09, 0x19, 0x1A, 0x33, 0x24, 0x00, 0x59, 0xF6, // "³" (U+00B3)
  0x00, 0xB4, 0x0D, 0x25, 0x1C, 0x2E, 0x24, 0x00, 0x5A, 0x79, // "´" (U+00B4)
  0x00, 0xB5, 0x03, 0xF3, 0x20, 0x20, 0x24, 0x00, 0x5A, 0xA0, // "µ" (U+00B5)
  0x00, 0xB6, 0x02, 0xF9, 0x20, 0x2D, 0x24, 0x00, 0x5B, 0x82, // "¶" (U+00B6)
  0x00, 0xB7, 0x0C, 0x10, 0x17, 0x1A, 0x24, 0x00, 0x5C, 0xBB, // "·" (U+00B7)
  0x00, 0xB8, 0x0B, 0xF3, 0x18, 0x01, 0x24, 0x00, 0x5C, 0xE2, // "¸" (U+00B8)
  0x00, 0xB9, 0x08, 0x1A, 0x1B, 0x33, 0x24, 0x00, 0x5D, 0x1F, // "¹" (U+00B9)
  0x00, 0xBA, 0x08, 0x17, 0x1B, 0x2B, 0x24, 0x00, 0x5D, 0x7B, // "º" (U+00BA)
  0x00, 0xBB, 0x03, 0x04, 0x20, 0x1E, 0x24, 0x00, 0x5D, 0xEC, // "»" (U+00BB)
  0x00, 0xBC, 0x00, 0x01, 0x22, 0x2B, 0x24, 0x00, 0x5E, 0xBC, // "¼" (U+00BC)
  0x00, 0xBD, 0x00, 0x01, 0x22, 0x2A, 0x24, 0x00, 0x5F, 0xFA, // "½" (U+00BD)
  0x00, 0xBE, 0x02, 0x01, 0x22, 0x2B, 0x24, 0x00, 0x61, 0x26, // "¾" (U+00BE)
  0x00, 0xBF, 0x03, 0xF6, 0x1D, 0x21, 0x24, 0x00, 0x62, 0x6E, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x23, 0x38, 0x24, 0x00, 0x63, 0x45, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x23, 0x38, 0x24, 0x00, 0x64, 0x75, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x01, 0x23, 0x38, 0x24, 0x00, 0x65, 0xA4, // "Â" (U+00C2)
  0x00, 0xC3, 0x00, 0x01, 0x23, 0x37, 0x24, 0x00, 0x66, 0xE2, // "Ã" (U+00C3)
  0x00, 0xC4, 0x00, 0x01, 0x23, 0x37, 0x24, 0x00, 0x68, 0x1B, // "Ä" (U+00C4)
  0x00, 0xC5, 0x00, 0x01, 0x23, 0x3C, 0x24, 0x00, 0x69, 0x5C, // "Å" (U+00C5)
  0x00, 0xC6, 0x00, 0x01, 0x22, 0x2A, 0x24, 0x00, 0x6A, 0xAE, // "Æ" (U+00C6)
  0x00, 0xC7, 0x03, 0xF3, 0x21, 0x2B, 0x24, 0x00, 0x6B, 0xB5, // "Ç" (U+00C7)
  0x00, 0xC8, 0x04, 0x01, 0x1F, 0x38, 0x24, 0x00, 0x6C, 0xE9, // "È" (U+00C8)
  0x00, 0xC9, 0x04, 0x01, 0x1F, 0x38, 0x24, 0x00, 0x6D, 0xD6, // "É" (U+00C9)
  0x00, 0xCA, 0x04, 0x01, 0x1F, 0x38, 0x24, 0x00, 0x6E, 0xC3, // "Ê" (U+00CA)
  0x00, 0xCB, 0x04, 0x01, 0x1F, 0x37, 0x24, 0x00, 0x6F, 0xBF, // "Ë" (U+00CB)
  0x00, 0xCC, 0x05, 0x01, 0x1E, 0x38, 0x24, 0x00, 0x70, 0xBD, // "Ì" (U+00CC)
  0x00, 0xCD, 0x05, 0x01, 0x1E, 0x38, 0x24, 0x00, 0x71, 0xB0, // "Í" (U+00CD)
  0x00, 0xCE, 0x05, 0x01, 0x1E, 0x38, 0x24, 0x00, 0x72, 0xA3, // "Î" (U+00CE)
  0x00, 0xCF, 0x05, 0x01, 0x1E, 0x37, 0x24, 0x00, 0x73, 0xA3, // "Ï" (U+00CF)
  0x00, 0xD0, 0x00, 0x01, 0x22, 0x2A, 0x24, 0x00, 0x74, 0xA7, // "Ð" (U+00D0)
  0x00, 0xD1, 0x02, 0x01, 0x21, 0x37, 0x24, 0x00, 0x75, 0xC9, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x01, 0x00, 0x22, 0x38, 0x24, 0x00, 0x77, 0x2D, // "Ò" (U+00D2)
  0x00, 0xD3, 0x01, 0x00, 0x22, 0x38, 0x24, 0x00, 0x78, 0x8E, // "Ó" (U+00D3)
  0x00, 0xD4, 0x01, 0x00, 0x22, 0x38, 0x24, 0x00, 0x79, 0xEF, // "Ô" (U+00D4)
  0x00, 0xD5, 0x01, 0x00, 0x22, 0x37, 0x24, 0x00, 0x7B, 0x5E, // "Õ" (U+00D5)
  0x00, 0xD6, 0x01, 0x00, 0x22, 0x37, 0x24, 0x00, 0x7C, 0xC8, // "Ö" (U+00D6)
  0x00, 0xD7, 0x05, 0x09, 0x1F, 0x23, 0x24, 0x00, 0x7E, 0x39, // "×" (U+00D7)
  0x00, 0xD8, 0x01, 0xFE, 0x22, 0x2C, 0x24, 0x00, 0x7E, 0xF4, // "Ø" (U+00D8)
  0x00, 0xD9, 0x02, 0x00, 0x21, 0x38, 0x24, 0x00, 0x80, 0x59, // "Ù" (U+00D9)
  0x00, 0xDA, 0x02, 0x00, 0x21, 0x38, 0x24, 0x00, 0x81, 0xB1, // "Ú" (U+00DA)
  0x00, 0xDB, 0x02, 0x00, 0x21, 0x38, 0x24, 0x00, 0x83, 0x07, // "Û" (U+00DB)
  0x00, 0xDC, 0x02, 0x00, 0x21, 0x37, 0x24, 0x00, 0x84, 0x6B, // "Ü" (U+00DC)
  0x00, 0xDD, 0x01, 0x01, 0x22, 0x38, 0x24, 0x00, 0x85, 0xD3, // "Ý" (U+00DD)
  0x00, 0xDE, 0x04, 0x01, 0x21, 0x2A, 0x24, 0x00, 0x87, 0x00, // "Þ" (U+00DE)
  0x00, 0xDF, 0x03, 0x00, 0x22, 0x2E, 0x24, 0x00, 0x87, 0xF1, // "ß" (U+00DF)
  0x00, 0xE0, 0x03, 0x00, 0x20, 0x2E, 0x24, 0x00, 0x89, 0x43, // "à" (U+00E0)
  0x00, 0xE1, 0x03, 0x00, 0x20, 0x2E, 0x24, 0x00, 0x8A, 0x51, // "á" (U+00E1)
  0x00, 0xE2, 0x03, 0x00, 0x20, 0x2E, 0x24, 0x00, 0x8B, 0x5D, // "â" (U+00E2)
  0x00, 0xE3, 0x03, 0x00, 0x20, 0x2D, 0x24, 0x00, 0x8C, 0x79, // "ã" (U+00E3)
  0x00, 0xE4, 0x03, 0x00, 0x20, 0x2D, 0x24, 0x00, 0x8D, 0x92, // "ä" (U+00E4)
  0x00, 0xE5, 0x03, 0x00, 0x20, 0x32, 0x24, 0x00, 0x8E, 0xB0, // "å" (U+00E5)
  0x00, 0xE6, 0x00, 0x00, 0x23, 0x21, 0x24, 0x00, 0x8F, 0xDE, // "æ" (U+00E6)
  0x00, 0xE7, 0x04, 0xF3, 0x1E, 0x21, 0x24, 0x00, 0x90, 0xDA, // "ç" (U+00E7)
  0x00, 0xE8, 0x03, 0x00, 0x20, 0x2E, 0x24, 0x00, 0x91, 0xCF, // "è" (U+00E8)
  0x00, 0xE9, 0x03, 0x00, 0x20, 0x2E, 0x24, 0x00, 0x92, 0xB9, // "é" (U+00E9)
  0x00, 0xEA, 0x03, 0x00, 0x20, 0x2E, 0x24, 0x00, 0x93, 0xA1, // "ê" (U+00EA)
  0x00, 0xEB, 0x03, 0x00, 0x20, 0x2D, 0x24, 0x00, 0x94, 0x99, // "ë" (U+00EB)
  0x00, 0xEC, 0x03, 0x01, 0x20, 0x2E, 0x24, 0x00, 0x95, 0x93, // "ì" (U+00EC)
  0x00, 0xED, 0x03, 0x01, 0x20, 0x2E, 0x24, 0x00, 0x96, 0x5E, // "í" (U+00ED)
  0x00, 0xEE, 0x03, 0x01, 0x20, 0x2E, 0x24, 0x00, 0x97, 0x27, // "î" (U+00EE)
  0x00, 0xEF, 0x03, 0x01, 0x20, 0x2D, 0x24, 0x00, 0x98, 0x00, // "ï" (U+00EF)
  0x00, 0xF0, 0x02, 0x00, 0x21, 0x2E, 0x24, 0x00, 0x98, 0xDB, // "ð" (U+00F0)
  0x00, 0xF1, 0x03, 0x01, 0x20, 0x2D, 0x24, 0x00, 0x9A, 0x1D, // "ñ" (U+00F1)
  0x00, 0xF2, 0x02, 0x00, 0x21, 0x2E, 0x24, 0x00, 0x9B, 0x1E, // "ò" (U+00F2)
  0x00, 0xF3, 0x02, 0x00, 0x21, 0x2E, 0x24, 0x00, 0x9C, 0x3C, // "ó" (U+00F3)
  0x00, 0xF4, 0x02, 0x00, 0x21, 0x2E, 0x24, 0x00, 0x9D, 0x58, // "ô" (U+00F4)
  0x00, 0xF5, 0x02, 0x00, 0x21, 0x2D, 0x24, 0x00, 0x9E, 0x82, // "õ" (U+00F5)
  0x00, 0xF6, 0x02, 0x00, 0x21, 0x2D, 0x24, 0x00, 0x9F, 0xA9, // "ö" (U+00F6)
  0x00, 0xF7, 0x04, 0x07, 0x1F, 0x24, 0x24, 0x00, 0xA0, 0xD7, // "÷" (U+00F7)
  0x00, 0xF8, 0x02, 0xFF, 0x21, 0x22, 0x24, 0x00, 0xA1, 0x39, // "ø" (U+00F8)
  0x00, 0xF9, 0x03, 0x00, 0x20, 0x2E, 0x24, 0x00, 0xA2, 0x42, // "ù" (U+00F9)
  0x00, 0xFA, 0x03, 0x00, 0x20, 0x2E, 0x24, 0x00, 0xA3, 0x3A, // "ú" (U+00FA)
  0x00, 0xFB, 0x03, 0x00, 0x20, 0x2E, 0x24, 0x00, 0xA4, 0x30, // "û" (U+00FB)
  0x00, 0xFC, 0x03, 0x00, 0x20, 0x2D, 0x24, 0x00, 0xA5, 0x36, // "ü" (U+00FC)
  0x00, 0xFD, 0x01, 0xF3, 0x22, 0x2E, 0x24, 0x00, 0xA6, 0x3E, // "ý" (U+00FD)
  0x00, 0xFE, 0x03, 0xF3, 0x21, 0x2D, 0x24, 0x00, 0xA7, 0x8E, // "þ" (U+00FE)
  0x00, 0xFF, 0x01, 0xF3, 0x22, 0x2D, 0x24, 0x00, 0xA8, 0xF3, // "ÿ" (U+00FF)
  0x01, 0x00, 0x00, 0x01, 0x23, 0x35, 0x24, 0x00, 0xAA, 0x53, // "Ā" (U+0100)
  0x01, 0x01, 0x03, 0x00, 0x20, 0x2B, 0x24, 0x00, 0xAB, 0x6C, // "ā" (U+0101)
  0x01, 0x02, 0x00, 0x01, 0x23, 0x38, 0x24, 0x00, 0xAC, 0x63, // "Ă" (U+0102)
  0x01, 0x03, 0x03, 0x00, 0x20, 0x2E, 0x24, 0x00, 0xAD, 0xA5, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0xF3, 0x24, 0x2A, 0x24, 0x00, 0xAE, 0xC4, // "Ą" (U+0104)
  0x01, 0x05, 0x03, 0xF3, 0x20, 0x21, 0x24, 0x00, 0xB0, 0x07, // "ą" (U+0105)
  0x01, 0x06, 0x03, 0x00, 0x21, 0x38, 0x24, 0x00, 0xB1, 0x20, // "Ć" (U+0106)
  0x01, 0x07, 0x04, 0x00, 0x1E, 0x2E, 0x24, 0x00, 0xB2, 0x41, // "ć" (U+0107)
  0x01, 0x08, 0x03, 0x00, 0x21, 0x38, 0x24, 0x00, 0xB3, 0x2A, // "Ĉ" (U+0108)
  0x01, 0x09, 0x04, 0x00, 0x1F, 0x2E, 0x24, 0x00, 0xB4, 0x5B, // "ĉ" (U+0109)
  0x01, 0x0A, 0x03, 0x00, 0x21, 0x38, 0x24, 0x00, 0xB5, 0x53, // "Ċ" (U+010A)
  0x01, 0x0B, 0x04, 0x00, 0x1E, 0x2E, 0x24, 0x00, 0xB6, 0x79, // "ċ" (U+010B)
  0x01, 0x0C, 0x03, 0x00, 0x21, 0x38, 0x24, 0x00, 0xB7, 0x66, // "Č" (U+010C)
  0x01, 0x0D, 0x04, 0x00, 0x1E, 0x2E, 0x24, 0x00, 0xB8, 0x9B, // "č" (U+010D)
  0x01, 0x0E, 0x02, 0x01, 0x22, 0x38, 0x24, 0x00, 0xB9, 0x95, // "Ď" (U+010E)
  0x01, 0x0F, 0x01, 0x00, 0x28, 0x2D, 0x24, 0x00, 0xBB, 0x00, // "ď" (U+010F)
  0x01, 0x10, 0x00, 0x01, 0x22, 0x2A, 0x24, 0x00, 0xBC, 0x50, // "Đ" (U+0110)
  0x01, 0x11, 0x02, 0x00, 0x23, 0x2D, 0x24, 0x00, 0xBD, 0x72, // "đ" (U+0111)
  0x01, 0x12, 0x04, 0x01, 0x1F, 0x35, 0x24, 0x00, 0xBE, 0x97, // "Ē" (U+0112)
  0x01, 0x13, 0x03, 0x00, 0x20, 0x2B, 0x24, 0x00, 0xBF, 0x6F, // "ē" (U+0113)
  0x01, 0x14, 0x04, 0x01, 0x1F, 0x38, 0x24, 0x00, 0xC0, 0x42, // "Ĕ" (U+0114)
  0x01, 0x15, 0x03, 0x00, 0x20, 0x2E, 0x24, 0x00, 0xC1, 0x40, // "ĕ" (U+0115)
  0x01, 0x16, 0x04, 0x01, 0x1F, 0x38, 0x24, 0x00, 0xC2, 0x3A, // "Ė" (U+0116)
  0x01, 0x17, 0x03, 0x00, 0x20, 0x2E, 0x24, 0x00, 0xC3, 0x2B, // "ė" (U+0117)
  0x01, 0x18, 0x04, 0xF3, 0x1F, 0x2A, 0x24, 0x00, 0xC4, 0x17, // "Ę" (U+0118)
  0x01, 0x19, 0x03, 0xF3, 0x20, 0x21, 0x24, 0x00, 0xC5, 0x0E, // "ę" (U+0119)
  0x01, 0x1A, 0x04, 0x01, 0x1F, 0x38, 0x24, 0x00, 0xC6, 0x04, // "Ě" (U+011A)
  0x01, 0x1B, 0x03, 0x00, 0x20, 0x2E, 0x24, 0x00, 0xC7, 0x03, // "ě" (U+011B)
  0x01, 0x1C, 0x01, 0x00, 0x21, 0x38, 0x24, 0x00, 0xC7, 0xFF, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x02, 0xF3, 0x20, 0x2E, 0x24, 0x00, 0xC9, 0x5F, // "ĝ" (U+011D)
  0x01, 0x1E, 0x01, 0x00, 0x21, 0x38, 0x24, 0x00, 0xCA, 0xE4, // "Ğ" (U+011E)
  0x01, 0x1F, 0x02, 0xF3, 0x20, 0x2E, 0x24, 0x00, 0xCC, 0x47, // "ğ" (U+011F)
  0x01, 0x20, 0x01, 0x00, 0x21, 0x38, 0x24, 0x00, 0xCD, 0xCE, // "Ġ" (U+0120)
  0x01, 0x21, 0x02, 0xF3, 0x20, 0x2E, 0x24, 0x00, 0xCF, 0x24, // "ġ" (U+0121)
  0x01, 0x22, 0x01, 0xF4, 0x21, 0x2B, 0x24, 0x00, 0xD0, 0x9D, // "Ģ" (U+0122)
  0x01, 0x23, 0x02, 0xF3, 0x20, 0x2E, 0x24, 0x00, 0xD1, 0xE9, // "ģ" (U+0123)
  0x01, 0x24, 0x02, 0x01, 0x21, 0x38, 0x24, 0x00, 0xD3, 0x5A, // "Ĥ" (U+0124)
  0x01, 0x25, 0xFD, 0x01, 0x20, 0x3B, 0x24, 0x00, 0xD4, 0xA0, // "ĥ" (U+0125)
  0x01, 0x26, 0x00, 0x01, 0x23, 0x2A, 0x24, 0x00, 0xD5, 0xEA, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x20, 0x2D, 0x24, 0x00, 0xD6, 0xEA, // "ħ" (U+0127)
  0x01, 0x28, 0x05, 0x01, 0x1E, 0x37, 0x24, 0x00, 0xD7, 0xE5, // "Ĩ" (U+0128)
  0x01, 0x29, 0x03, 0x01, 0x20, 0x2D, 0x24, 0x00, 0xD8, 0xE1, // "ĩ" (U+0129)
  0x01, 0x2A, 0x05, 0x01, 0x1E, 0x35, 0x24, 0x00, 0xD9, 0xB7, // "Ī" (U+012A)
  0x01, 0x2B, 0x03, 0x01, 0x20, 0x2B, 0x24, 0x00, 0xDA, 0x93, // "ī" (U+012B)
  0x01, 0x2C, 0x05, 0x01, 0x1E, 0x38, 0x24, 0x00, 0xDB, 0x47, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x03, 0x01, 0x20, 0x2E, 0x24, 0x00, 0xDC, 0x49, // "ĭ" (U+012D)
  0x01, 0x2E, 0x05, 0xF3, 0x1E, 0x2A, 0x24, 0x00, 0xDD, 0x24, // "Į" (U+012E)
  0x01, 0x2F, 0x03, 0xF3, 0x20, 0x2E, 0x24, 0x00, 0xDE, 0x20, // "į" (U+012F)
  0x01, 0x30, 0x05, 0x01, 0x1E, 0x38, 0x24, 0x00, 0xDF, 0x2E, // "İ" (U+0130)
  0x01, 0x31, 0x03, 0x01, 0x20, 0x20, 0x24, 0x00, 0xE0, 0x24, // "ı" (U+0131)
  0x01, 0x32, 0x05, 0x00, 0x1E, 0x2A, 0x24, 0x00, 0xE0, 0xBB, // "Ĳ" (U+0132)
  0x01, 0x33, 0x04, 0xF3, 0x1F, 0x2F, 0x24, 0x00, 0xE1, 0xAC, // "ĳ" (U+0133)
  0x01, 0x34, 0x05, 0x00, 0x24, 0x38, 0x24, 0x00, 0xE3, 0x0A, // "Ĵ" (U+0134)
  0x01, 0x35, 0x02, 0xF3, 0x20, 0x2E, 0x24, 0x00, 0xE4, 0x33, // "ĵ" (U+0135)
  0x01, 0x36, 0x02, 0xF4, 0x21, 0x2A, 0x24, 0x00, 0xE5, 0x56, // "Ķ" (U+0136)
  0x01, 0x37, 0x03, 0xF4, 0x22, 0x2D, 0x24, 0x00, 0xE6, 0xB2, // "ķ" (U+0137)
  0x01, 0x38, 0x03, 0x01, 0x22, 0x20, 0x24, 0x00, 0xE8, 0x0D, // "ĸ" (U+0138)
  0x01, 0x39, 0x05, 0x01, 0x1F, 0x38, 0x24, 0x00, 0xE8, 0xF7, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x03, 0x01, 0x20, 0x3B, 0x24, 0x00, 0xE9, 0xE2, // "ĺ" (U+013A)
  0x01, 0x3B, 0x05, 0xF4, 0x1F, 0x2A, 0x24, 0x00, 0xEA, 0xE5, // "Ļ" (U+013B)
  0x01, 0x3C, 0x03, 0xF4, 0x20, 0x2D, 0x24, 0x00, 0xEB, 0xC9, // "ļ" (U+013C)
  0x01, 0x3D, 0x05, 0x01, 0x1F, 0x2A, 0x24, 0x00, 0xEC, 0xC7, // "Ľ" (U+013D)
  0x01, 0x3E, 0x03, 0x01, 0x23, 0x2D, 0x24, 0x00, 0xED, 0x95, // "ľ" (U+013E)
  0x01, 0x3F, 0x05, 0x01, 0x20, 0x2A, 0x24, 0x00, 0xEE, 0x8F, // "Ŀ" (U+013F)
  0x01, 0x40, 0x03, 0x01, 0x29, 0x2D, 0x24, 0x00, 0xEF, 0x6A, // "ŀ" (U+0140)
  0x01, 0x41, 0x02, 0x01, 0x22, 0x2A, 0x24, 0x00, 0xF0, 0x80, // "Ł" (U+0141)
  0x01, 0x42, 0x03, 0x01, 0x20, 0x2D, 0x24, 0x00, 0xF1, 0x5A, // "ł" (U+0142)
  0x01, 0x43, 0x02, 0x01, 0x21, 0x38, 0x24, 0x00, 0xF2, 0x3C, // "Ń" (U+0143)
  0x01, 0x44, 0x03, 0x01, 0x20, 0x2E, 0x24, 0x00, 0xF3, 0x95, // "ń" (U+0144)
  0x01, 0x45, 0x02, 0xF4, 0x21, 0x2A, 0x24, 0x00, 0xF4, 0x89, // "Ņ" (U+0145)
  0x01, 0x46, 0x03, 0xF4, 0x20, 0x21, 0x24, 0x00, 0xF5, 0xDD, // "ņ" (U+0146)
  0x01, 0x47, 0x02, 0x01, 0x21, 0x38, 0x24, 0x00, 0xF6, 0xCD, // "Ň" (U+0147)
  0x01, 0x48, 0x03, 0x01, 0x20, 0x2E, 0x24, 0x00, 0xF8, 0x38, // "ň" (U+0148)
  0x01, 0x49, 0xF9, 0x01, 0x20, 0x2A, 0x24, 0x00, 0xF9, 0x40, // "ŉ" (U+0149)
  0x01, 0x4A, 0x02, 0xF5, 0x21, 0x2A, 0x24, 0x00, 0xFA, 0x6B, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x03, 0xF3, 0x20, 0x21, 0x24, 0x00, 0xFB, 0xD1, // "ŋ" (U+014B)
  0x01, 0x4C, 0x01, 0x00, 0x22, 0x35, 0x24, 0x00, 0xFC, 0xD5, // "Ō" (U+014C)
  0x01, 0x4D, 0x02, 0x00, 0x21, 0x2B, 0x24, 0x00, 0xFE, 0x1D, // "ō" (U+014D)
  0x01, 0x4E, 0x01, 0x00, 0x22, 0x38, 0x24, 0x00, 0xFF, 0x21, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x02, 0x00, 0x21, 0x2E, 0x24, 0x01, 0x00, 0x92, // "ŏ" (U+014F)
  0x01, 0x50, 0x01, 0x00, 0x22, 0x38, 0x24, 0x01, 0x01, 0xBE, // "Ő" (U+0150)
  0x01, 0x51, 0x02, 0x00, 0x21, 0x2E, 0x24, 0x01, 0x03, 0x34, // "ő" (U+0151)
  0x01, 0x52, 0x01, 0x00, 0x22, 0x2B, 0x24, 0x01, 0x04, 0x64, // "Œ" (U+0152)
  0x01, 0x53, 0x01, 0x00, 0x23, 0x21, 0x24, 0x01, 0x05, 0x83, // "œ" (U+0153)
  0x01, 0x54, 0x04, 0x01, 0x22, 0x38, 0x24, 0x01, 0x06, 0x95, // "Ŕ" (U+0154)
  0x01, 0x55, 0x02, 0x01, 0x22, 0x2E, 0x24, 0x01, 0x07, 0xE2, // "ŕ" (U+0155)
  0x01, 0x56, 0x04, 0xF4, 0x22, 0x2A, 0x24, 0x01, 0x08, 0xC4, // "Ŗ" (U+0156)
  0x01, 0x57, 0x02, 0xF4, 0x22, 0x21, 0x24, 0x01, 0x0A, 0x0D, // "ŗ" (U+0157)
  0x01, 0x58, 0x04, 0x01, 0x22, 0x38, 0x24, 0x01, 0x0A, 0xE9, // "Ř" (U+0158)
  0x01, 0x59, 0x02, 0x01, 0x22, 0x2E, 0x24, 0x01, 0x0C, 0x49, // "ř" (U+0159)
  0x01, 0x5A, 0x04, 0x00, 0x20, 0x38, 0x24, 0x01, 0x0D, 0x3C, // "Ś" (U+015A)
  0x01, 0x5B, 0x04, 0x00, 0x1F, 0x2E, 0x24, 0x01, 0x0E, 0x6A, // "ś" (U+015B)
  0x01, 0x5C, 0x04, 0x00, 0x20, 0x38, 0x24, 0x01, 0x0F, 0x65, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x04, 0x00, 0x1F, 0x2E, 0x24, 0x01, 0x10, 0xA2, // "ŝ" (U+015D)
  0x01, 0x5E, 0x04, 0xF3, 0x20, 0x2B, 0x24, 0x01, 0x11, 0xAC, // "Ş" (U+015E)
  0x01, 0x5F, 0x04, 0xF3, 0x1F, 0x21, 0x24, 0x01, 0x12, 0xEB, // "ş" (U+015F)
  0x01, 0x60, 0x04, 0x00, 0x20, 0x38, 0x24, 0x01, 0x13, 0xF5, // "Š" (U+0160)
  0x01, 0x61, 0x04, 0x00, 0x1F, 0x2E, 0x24, 0x01, 0x15, 0x36, // "š" (U+0161)
  0x01, 0x62, 0x01, 0xF3, 0x22, 0x2A, 0x24, 0x01, 0x16, 0x43, // "Ţ" (U+0162)
  0x01, 0x63, 0x03, 0xF3, 0x1F, 0x29, 0x24, 0x01, 0x17, 0x5B, // "ţ" (U+0163)
  0x01, 0x64, 0x01, 0x01, 0x22, 0x38, 0x24, 0x01, 0x18, 0x64, // "Ť" (U+0164)
  0x01, 0x65, 0x03, 0x00, 0x22, 0x2E, 0x24, 0x01, 0x19, 0x7A, // "ť" (U+0165)
  0x01, 0x66, 0x01, 0x01, 0x22, 0x2A, 0x24, 0x01, 0x1A, 0x72, // "Ŧ" (U+0166)
  0x01, 0x67, 0x03, 0x00, 0x1F, 0x29, 0x24, 0x01, 0x1B, 0x43, // "ŧ" (U+0167)
  0x01, 0x68, 0x02, 0x00, 0x21, 0x37, 0x24, 0x01, 0x1C, 0x03, // "Ũ" (U+0168)
  0x01, 0x69, 0x03, 0x00, 0x20, 0x2D, 0x24, 0x01, 0x1D, 0x64, // "ũ" (U+0169)
  0x01, 0x6A, 0x02, 0x00, 0x21, 0x35, 0x24, 0x01, 0x1E, 0x67, // "Ū" (U+016A)
  0x01, 0x6B, 0x03, 0x00, 0x20, 0x2B, 0x24, 0x01, 0x1F, 0xA5, // "ū" (U+016B)
  0x01, 0x6C, 0x02, 0x00, 0x21, 0x38, 0x24, 0x01, 0x20, 0x86, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x03, 0x00, 0x20, 0x2E, 0x24, 0x01, 0x21, 0xEC, // "ŭ" (U+016D)
  0x01, 0x6E, 0x02, 0x00, 0x21, 0x3C, 0x24, 0x01, 0x22, 0xF5, // "Ů" (U+016E)
  0x01, 0x6F, 0x03, 0x00, 0x20, 0x32, 0x24, 0x01, 0x24, 0x6C, // "ů" (U+016F)
  0x01, 0x70, 0x02, 0x00, 0x21, 0x38, 0x24, 0x01, 0x25, 0x84, // "Ű" (U+0170)
  0x01, 0x71, 0x03, 0x00, 0x20, 0x2E, 0x24, 0x01, 0x26, 0xEE, // "ű" (U+0171)
  0x01, 0x72, 0x02, 0xF3, 0x21, 0x2A, 0x24, 0x01, 0x27, 0xFB, // "Ų" (U+0172)
  0x01, 0x73, 0x03, 0xF3, 0x20, 0x20, 0x24, 0x01, 0x29, 0x58, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x23, 0x38, 0x24, 0x01, 0x2A, 0x59, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x23, 0x2E, 0x24, 0x01, 0x2C, 0x13, // "ŵ" (U+0175)
  0x01, 0x76, 0x01, 0x01, 0x22, 0x38, 0x24, 0x01, 0x2D, 0x71, // "Ŷ" (U+0176)
  0x01, 0x77, 0x01, 0xF3, 0x22, 0x2E, 0x24, 0x01, 0x2E, 0xAB, // "ŷ" (U+0177)
  0x01, 0x78, 0x01, 0x01, 0x22, 0x37, 0x24, 0x01, 0x30, 0x09, // "Ÿ" (U+0178)
  0x01, 0x79, 0x04, 0x01, 0x1F, 0x38, 0x24, 0x01, 0x31, 0x46, // "Ź" (U+0179)
  0x01, 0x7A, 0x03, 0x01, 0x20, 0x2E, 0x24, 0x01, 0x32, 0x36, // "ź" (U+017A)
  0x01, 0x7B, 0x04, 0x01, 0x1F, 0x38, 0x24, 0x01, 0x33, 0x01, // "Ż" (U+017B)
  0x01, 0x7C, 0x03, 0x01, 0x20, 0x2E, 0x24, 0x01, 0x33, 0xF5, // "ż" (U+017C)
  0x01, 0x7D, 0x04, 0x01, 0x1F, 0x38, 0x24, 0x01, 0x34, 0xC4, // "Ž" (U+017D)
  0x01, 0x7E, 0x03, 0x01, 0x20, 0x2E, 0x24, 0x01, 0x35, 0xC6, // "ž" (U+017E)
  0x01, 0x7F, 0x0B, 0x01, 0x1F, 0x2D, 0x24, 0x01, 0x36, 0xA5, // "ſ" (U+017F)
  0x03, 0xA9, 0x00, 0x00, 0x23, 0x2B, 0x24, 0x01, 0x37, 0x62, // "Ω" (U+03A9)
  0x03, 0xBC, 0x03, 0xF3, 0x20, 0x20, 0x24, 0x01, 0x38, 0x84, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x00, 0x23, 0x20, 0x24, 0x01, 0x39, 0x66, // "π" (U+03C0)
  0x20, 0x13, 0x06, 0x0D, 0x1D, 0x13, 0x24, 0x01, 0x3A, 0x34, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x0D, 0x23, 0x13, 0x24, 0x01, 0x3A, 0x3A, // "—" (U+2014)
  0x20, 0xAC, 0x02, 0x00, 0x22, 0x2A, 0x24, 0x01, 0x3A, 0x40, // "€" (U+20AC)
  0x20, 0xBF, 0x04, 0xFB, 0x21, 0x31, 0x24, 0x01, 0x3B, 0x29, // "₿" (U+20BF)
  0x20, 0x18, 0x0C, 0x1C, 0x17, 0x2A, 0x24, 0x01, 0x3C, 0x88, // "‘" (U+2018)
  0x20, 0x19, 0x0C, 0x1C, 0x18, 0x2A, 0x24, 0x01, 0x3C, 0xB5, // "’" (U+2019)
  0x20, 0x1A, 0x0B, 0xF8, 0x17, 0x08, 0x24, 0x01, 0x3C, 0xE4, // "‚" (U+201A)
  0x20, 0x1B, 0x0C, 0x1C, 0x17, 0x2A, 0x24, 0x01, 0x3D, 0x17, // "‛" (U+201B)
  0x20, 0x1C, 0x05, 0x1C, 0x1E, 0x2A, 0x24, 0x01, 0x3D, 0x43, // "“" (U+201C)
  0x20, 0x1D, 0x05, 0x1E, 0x1E, 0x2C, 0x24, 0x01, 0x3D, 0x9D, // "”" (U+201D)
  0x20, 0x1E, 0x06, 0xF8, 0x1F, 0x08, 0x24, 0x01, 0x3D, 0xF7, // "„" (U+201E)
  0x20, 0x1F, 0x05, 0x1E, 0x1E, 0x2C, 0x24, 0x01, 0x3E, 0x5C, // "‟" (U+201F)
  0x20, 0x20, 0x06, 0x01, 0x1D, 0x2D, 0x24, 0x01, 0x3E, 0xB5, // "†" (U+2020)
  0x20, 0x21, 0x05, 0x01, 0x1E, 0x2D, 0x24, 0x01, 0x3F, 0x7C, // "‡" (U+2021)
  0x20, 0x22, 0x09, 0x0E, 0x1A, 0x1F, 0x24, 0x01, 0x40, 0x5D, // "•" (U+2022)
  0x20, 0x26, 0x00, 0x00, 0x23, 0x0A, 0x24, 0x01, 0x40, 0xA5, // "…" (U+2026)
  0x20, 0x30, 0x01, 0x00, 0x22, 0x2B, 0x24, 0x01, 0x41, 0x19, // "‰" (U+2030)
  0x20, 0x39, 0x09, 0x04, 0x1A, 0x1E, 0x24, 0x01, 0x42, 0x87, // "‹" (U+2039)
  0x20, 0x3A, 0x09, 0x05, 0x1A, 0x1F, 0x24, 0x01, 0x42, 0xF9, // "›" (U+203A)
  0x20, 0x44, 0xF4, 0x01, 0x0B, 0x2A, 0x00, 0x01, 0x43, 0x6B, // "⁄" (U+2044)
  0x21, 0x22, 0x00, 0x17, 0x23, 0x2B, 0x24, 0x01, 0x44, 0x18, // "™" (U+2122)
  0x21, 0x52, 0x0E, 0x00, 0x5E, 0x2B, 0x6C, 0x01, 0x44, 0xEA, // "⅒" (U+2152)
  0x22, 0x02, 0x03, 0x00, 0x20, 0x2B, 0x24, 0x01, 0x47, 0x17, // "∂" (U+2202)
  0x22, 0x06, 0x00, 0x00, 0x23, 0x2A, 0x24, 0x01, 0x48, 0x30, // "∆" (U+2206)
  0x22, 0x1A, 0x01, 0x01, 0x24, 0x33, 0x24, 0x01, 0x49, 0x2D, // "√" (U+221A)
  0x22, 0x1E, 0x00, 0x0C, 0x23, 0x1F, 0x24, 0x01, 0x4A, 0x40, // "∞" (U+221E)
  0x22, 0x48, 0x03, 0x0B, 0x20, 0x1F, 0x24, 0x01, 0x4A, 0xFB, // "≈" (U+2248)
  0x22, 0x60, 0x04, 0x04, 0x1F, 0x27, 0x24, 0x01, 0x4B, 0x95, // "≠" (U+2260)
  0x22, 0x64, 0x03, 0x01, 0x20, 0x27, 0x24, 0x01, 0x4C, 0x2A, // "≤" (U+2264)
  0x22, 0x65, 0x03, 0x01, 0x20, 0x27, 0x24, 0x01, 0x4D, 0x03, // "≥" (U+2265)
  
  // Kerning pairs
  
  // Glyph data
  // "!" (U+0021)
  0x1F, 0xB0, 0x11, 0xFB, 0x20, 0xEF, 0xA2, 0x0D, 0xF9, 0x0E, 0x20, 0xDF, 0x90, 0xD2, 0x0C, 0xF9,
  0x0D, 0x20, 0xBF, 0x90, 0xC2, 0x0B, 0xF9, 0x0B, 0x20, 0xAF, 0x90, 0xB2, 0x09, 0xF9, 0x0A, 0x20,
  0x8F, 0x90, 0x92, 0x08, 0xF9, 0x09, 0x20, 0x7F, 0x90, 0x82, 0x06, 0xF9, 0x07, 0x20, 0x6F, 0x90,
  0x62, 0x05, 0xF9, 0x06, 0x20, 0x4F, 0x90, 0x52, 0x04, 0xF9, 0x04, 0x20, 0x3F, 0x90, 0x42, 0x02,
  0xF9, 0x03, 0x20, 0x1F, 0x90, 0x22, 0x01, 0xF9, 0x02, 0x3F, 0x90, 0x13, 0xF9, 0x40, 0xEF, 0x40,
  0xDE, 0x0E, 0x40, 0xDE, 0x0E, 0x40, 0xCE, 0x0D, 0x80, 0xE1, 0x08, 0x42, 0x57, 0x75, 0x15, 0x0A,
  0xE0, 0x83, 0x0A, 0xF9, 0x81, 0x80, 0x2F, 0xB0, 0x10, 0x5F, 0xB0, 0x40, 0x6F, 0xB0, 0x05, 0xFB,
  0x04, 0x01, 0xFA, 0x82, 0xE1, 0x09, 0xF9, 0x07, 0x30, 0x8D, 0x0E, 0x07, 0x58, 0x41, 0x57, 0x75,
  0x13,
  // """ (U+0022)
  0x02, 0xF9, 0x01, 0x20, 0x1F, 0x90, 0x20, 0x1F, 0x94, 0xF9, 0x01, 0x1F, 0x0E, 0x40, 0xEF, 0x20,
  0xEE, 0x0D, 0x40, 0xDE, 0x0E, 0x20, 0xDE, 0x0C, 0x40, 0xCE, 0x0D, 0x20, 0xCE, 0x0B, 0x40, 0xBE,
  0x0C, 0x20, 0xBE, 0x0A, 0x40, 0xAE, 0x0B, 0x20, 0x9E, 0x08, 0x40, 0x8E, 0x09, 0x20, 0x8E, 0x07,
  0x40, 0x7E, 0x08, 0x20, 0x7E, 0x06, 0x40, 0x6E, 0x07, 0x20, 0x6E, 0x05, 0x40, 0x5E, 0x06, 0x20,
  0x5E, 0x04, 0x40, 0x4E, 0x05, 0x20, 0x3E, 0x02, 0x40, 0x3E, 0x03, 0x20, 0x2E, 0x01, 0x40, 0x1E,
  0x02, 0x20, 0x1E, 0x6E, 0x01, 0x10,
  // "#" (U+0023)
  0x75, 0x03, 0xD0, 0xC5, 0xD0, 0xE7, 0x74, 0x06, 0xD0, 0x94, 0x03, 0xD0, 0xC7, 0x74, 0x09, 0xD0,
  0x74, 0x05, 0xD0, 0x97, 0x74, 0x0C, 0xD0, 0x44, 0x08, 0xD0, 0x77, 0x74, 0x0E, 0xD0, 0x14, 0x0B,
  0xD0, 0x47, 0x73, 0x02, 0xD0, 0xE5, 0x0D, 0xD0, 0x17, 0x73, 0x05, 0xD0, 0xB4, 0x01, 0xD0, 0xE7,
  0x74, 0x07, 0xD0, 0x84, 0x03, 0xD0, 0xB7, 0x74, 0x0A, 0xD0, 0x54, 0x06, 0xD0, 0x87, 0x74, 0x0D,
  0xD0, 0x34, 0x09, 0xD0, 0x67, 0x74, 0xE5, 0x0C, 0xD0, 0x37, 0x20, 0x5F, 0xFF, 0xFC, 0x01, 0x20,
  0x5F, 0xFF, 0xFC, 0x01, 0x20, 0x5F, 0xFF, 0xFC, 0x01, 0x20, 0x5F, 0xFF, 0xFC, 0x01, 0x20, 0x5F,
  0xFF, 0xFC, 0x01, 0x20, 0x5F, 0xFF, 0xFC, 0x01, 0x72, 0x02, 0xD0, 0xE5, 0x0E, 0xD0, 0x17, 0x73,
  0x04, 0xD0, 0xB4, 0x01, 0xD0, 0xE7, 0x74, 0x07, 0xD0, 0x94, 0x03, 0xD0, 0xB7, 0x74, 0x09, 0xD0,
  0x64, 0x06, 0xD0, 0x97, 0x74, 0x0C, 0xD0, 0x34, 0x09, 0xD0, 0x67, 0x74, 0xE0, 0x14, 0x0B, 0xD0,
  0x37, 0x73, 0x02, 0xD0, 0xD5, 0x0E, 0xD0, 0x17, 0x20, 0x1F, 0xFF, 0xFC, 0x05, 0x20, 0x1F, 0xFF,
  0xFC, 0x05, 0x20, 0x1F, 0xFF, 0xFC, 0x05, 0x20, 0x1F, 0xFF, 0xFC, 0x05, 0x20, 0x1F, 0xFF, 0xFC,
  0x05, 0x20, 0x1F, 0xFF, 0xFC, 0x05, 0x72, 0x04, 0xD0, 0xB4, 0x02, 0xE7, 0x74, 0x06, 0xD0, 0x84,
  0x04, 0xD0, 0xC7, 0x74, 0x09, 0xD0, 0x64, 0x07, 0xD0, 0xA7, 0x74, 0x0B, 0xD0, 0x34, 0x09, 0xD0,
  0x77, 0x74, 0x0E, 0xD0, 0x14, 0x0C, 0xD0, 0x57, 0x74, 0xD0, 0xE5, 0x0E, 0xD0, 0x27, 0x73, 0x03,
  0xD0, 0xC4, 0x01, 0xE7, 0x74, 0x05, 0xD0, 0x94, 0x04, 0xD0, 0xD7, 0x74, 0x08, 0xD0, 0x74, 0x06,
  0xD0, 0xA7, 0x74, 0x0A, 0xD0, 0x54, 0x09, 0xD0, 0x77, 0x74, 0x0C, 0xD0, 0x24, 0x0C, 0xD0, 0x57,
  0x74, 0xE5, 0x0E, 0xD0, 0x27, 0x50,
  // "$" (U+0024)
  0x75, 0x0C, 0xB0, 0x17, 0x77, 0x20, 0xCB, 0x01, 0x77, 0x72, 0x0C, 0xB0, 0x17, 0x77, 0x20, 0xCB,
  0x01, 0x77, 0x68, 0x24, 0x8A, 0xEB, 0x84, 0xCB, 0xA8, 0x41, 0x75, 0x81, 0x29, 0xEF, 0xE8, 0x1C,
  0x61, 0x71, 0x08, 0xFF, 0xD0, 0x80, 0x14, 0x01, 0x0C, 0xFF, 0xF0, 0x83, 0x01, 0x0C, 0xFF, 0xF9,
  0x03, 0x30, 0x9F, 0xFF, 0x90, 0xC3, 0x02, 0xFF, 0xFA, 0x07, 0x30, 0x8F, 0x98, 0x1B, 0x6D, 0xB8,
  0x34, 0x58, 0xBE, 0xC0, 0x13, 0x0D, 0xF0, 0x62, 0x0C, 0xB0, 0x14, 0x82, 0x49, 0xEB, 0x4F, 0x0B,
  0x30, 0xCB, 0x01, 0x70, 0x23, 0x01, 0xF0, 0x83, 0x0C, 0xB0, 0x17, 0x40, 0x1F, 0x07, 0x30, 0xCB,
  0x01, 0x75, 0xF0, 0xB3, 0x0C, 0xB0, 0x17, 0x50, 0xDF, 0x07, 0x20, 0xCB, 0x01, 0x75, 0x09, 0xF9,
  0x81, 0xB2, 0xCB, 0x01, 0x75, 0x03, 0xFF, 0x01, 0x76, 0x0A, 0xFE, 0x02, 0x77, 0x0C, 0xFD, 0x81,
  0xE9, 0x37, 0x50, 0x10, 0xBF, 0xF0, 0xC0, 0x47, 0x50, 0x8F, 0xF9, 0x0C, 0x03, 0x74, 0x02, 0x0B,
  0xFF, 0x90, 0x87, 0x50, 0x30, 0xBF, 0xF0, 0xA7, 0x60, 0x20, 0x9F, 0xE0, 0x87, 0x70, 0xCF, 0xE0,
  0x27, 0x60, 0xCB, 0x0B, 0xFA, 0x09, 0x76, 0x0C, 0xB8, 0x11, 0x3D, 0xF0, 0xE7, 0x60, 0xCB, 0x82,
  0x10, 0x1E, 0xF0, 0x17, 0x50, 0xCB, 0x01, 0x20, 0x7F, 0x02, 0x75, 0x0C, 0xB0, 0x12, 0x05, 0xF0,
  0x27, 0x50, 0xCB, 0x01, 0x20, 0x6F, 0x83, 0x12, 0xE7, 0x17, 0x10, 0xCB, 0x01, 0x20, 0xBE, 0x81,
  0xD0, 0x2B, 0x0A, 0x04, 0x60, 0xCB, 0x81, 0x10, 0x7F, 0x81, 0x90, 0x2D, 0x85, 0xEA, 0x63, 0x10,
  0xCB, 0x07, 0x0B, 0xF9, 0x81, 0x30, 0x2F, 0xFF, 0xB0, 0xA2, 0x02, 0xFF, 0xFA, 0x0D, 0x01, 0x20,
  0x2F, 0xFF, 0x90, 0xD0, 0x23, 0x01, 0xFF, 0xF0, 0xB0, 0x15, 0x81, 0x17, 0xCF, 0xFA, 0x0C, 0x05,
  0x73, 0x85, 0x15, 0x8A, 0xCD, 0xED, 0x82, 0xDA, 0x72, 0x77, 0x60, 0xCB, 0x01, 0x77, 0x72, 0x0C,
  0xB0, 0x17, 0x77, 0x20, 0xCB, 0x01, 0x77, 0x72, 0x0C, 0xB0, 0x17, 0x77, 0x20, 0xCB, 0x01, 0x77,
  0x72, 0x0C, 0xB0, 0x17, 0x40,
  // "%" (U+0025)
  0x68, 0x44, 0x67, 0x64, 0x17, 0x77, 0x68, 0x11, 0x8E, 0xE0, 0xA0, 0x27, 0x40, 0xCD, 0x09, 0x60,
  0x20, 0xDF, 0xB0, 0x47, 0x20, 0x5E, 0x01, 0x50, 0x10, 0xEF, 0xD0, 0x37, 0x10, 0xDD, 0x08, 0x60,
  0xAF, 0xE0, 0xD7, 0x06, 0xD0, 0xE0, 0x15, 0x02, 0xE8, 0x1B, 0x8A, 0xE0, 0x46, 0x0D, 0xD0, 0x86,
  0x07, 0xD0, 0xA3, 0x08, 0xD0, 0xA5, 0x06, 0xD0, 0xE0, 0x16, 0x0B, 0xD0, 0x33, 0x01, 0xD0, 0xD5,
  0x0E, 0xD0, 0x77, 0x0D, 0xD5, 0x0D, 0xD4, 0x07, 0xD0, 0xE7, 0x10, 0xEC, 0x0E, 0x50, 0xBD, 0x01,
  0x30, 0xED, 0x06, 0x71, 0xD0, 0xD5, 0x0B, 0xD0, 0x22, 0x08, 0xD0, 0xD7, 0x20, 0xEC, 0x0E, 0x50,
  0xCD, 0x82, 0x10, 0x1E, 0xD0, 0x67, 0x20, 0xDD, 0x01, 0x40, 0xED, 0x20, 0x8D, 0x0D, 0x73, 0x09,
  0xD0, 0x53, 0x03, 0xD8, 0x1C, 0x01, 0xE0, 0x57, 0x30, 0x5D, 0x83, 0xE4, 0x02, 0xDD, 0x81, 0x80,
  0x9D, 0x0C, 0x75, 0x0E, 0xFF, 0x00, 0x2E, 0x04, 0x75, 0x06, 0xFE, 0x81, 0x90, 0x9D, 0x0C, 0x77,
  0x09, 0xFC, 0x81, 0xC0, 0x2E, 0x04, 0x77, 0x10, 0x7F, 0xA0, 0x92, 0x0A, 0xD0, 0xB7, 0x73, 0x87,
  0x17, 0xCE, 0xFE, 0xC8, 0x32, 0x03, 0xE0, 0x37, 0x77, 0x70, 0xBD, 0x0B, 0x77, 0x77, 0x03, 0xE0,
  0x37, 0x77, 0x70, 0xBD, 0x0A, 0x77, 0x77, 0x04, 0xE0, 0x22, 0x87, 0x28, 0xCE, 0xFD, 0xB7, 0x17,
  0x73, 0x0C, 0xD0, 0x92, 0x08, 0xF9, 0x0E, 0x06, 0x77, 0x10, 0x5E, 0x81, 0x20, 0x9F, 0xC0, 0x87,
  0x70, 0xDD, 0x81, 0x90, 0x6F, 0xE0, 0x47, 0x50, 0x5E, 0x81, 0x10, 0xEF, 0xE0, 0xD7, 0x50, 0xDD,
  0x81, 0x80, 0x6D, 0x83, 0xD3, 0x04, 0xED, 0x03, 0x73, 0x06, 0xD8, 0x2E, 0x10, 0xAD, 0x04, 0x30,
  0x7D, 0x08, 0x73, 0x0D, 0xD0, 0x72, 0x0E, 0xC0, 0xE4, 0x02, 0xD0, 0xB7, 0x20, 0x7D, 0x0E, 0x01,
  0x2D, 0x0C, 0x5D, 0x0D, 0x72, 0x0E, 0xD0, 0x72, 0x01, 0xD0, 0xB5, 0x0E, 0xC0, 0xE7, 0x10, 0x7D,
  0x0E, 0x30, 0x2D, 0x0B, 0x50, 0xDD, 0x70, 0x10, 0xED, 0x06, 0x30, 0x1D, 0x0B, 0x50, 0xEC, 0x0E,
  0x70, 0x8D, 0x0D, 0x5D, 0x0D, 0x5D, 0x0D, 0x60, 0x10, 0xED, 0x06, 0x50, 0xDD, 0x01, 0x30, 0x4D,
  0x0A, 0x60, 0x9D, 0x0D, 0x60, 0x9D, 0x08, 0x30, 0xBD, 0x07, 0x50, 0x2E, 0x05, 0x60, 0x3E, 0x81,
  0xB8, 0xCE, 0x01, 0x50, 0x9D, 0x0C, 0x71, 0x0B, 0xFE, 0x09, 0x50, 0x2E, 0x04, 0x71, 0x02, 0x0E,
  0xFC, 0x0D, 0x01, 0x50, 0xAD, 0x0C, 0x73, 0x03, 0x0E, 0xFA, 0x0D, 0x02, 0x50, 0x3E, 0x04, 0x74,
  0x01, 0x09, 0xE8, 0x1E, 0x81, 0x77, 0x77, 0x83, 0x46, 0x76, 0x46,
  // "&" (U+0026)
  0x74, 0x84, 0x36, 0x77, 0x53, 0x77, 0x74, 0x81, 0x19, 0xEF, 0x0A, 0x03, 0x77, 0x70, 0x5F, 0xD0,
  0x97, 0x75, 0x06, 0xFF, 0x0A, 0x77, 0x30, 0x3F, 0xFA, 0x07, 0x77, 0x20, 0xBF, 0xFA, 0x0E, 0x01,
  0x77, 0x02, 0xF9, 0x81, 0xA8, 0xCF, 0x05, 0x77, 0x06, 0xF0, 0x33, 0x0B, 0xE0, 0xA7, 0x70, 0x9E,
  0x0A, 0x40, 0x4E, 0x0C, 0x77, 0x0A, 0xE0, 0x74, 0x01, 0xE0, 0xD7, 0x70, 0xBE, 0x06, 0x40, 0x1E,
  0x0D, 0x77, 0x0B, 0xE0, 0x84, 0x04, 0xE0, 0xB7, 0x70, 0xAE, 0x0A, 0x40, 0x9E, 0x08, 0x77, 0x07,
  0xE0, 0xE3, 0x03, 0xF0, 0x37, 0x70, 0x3F, 0x82, 0x50, 0x2E, 0xE0, 0xB7, 0x72, 0x0D, 0xE8, 0x1D,
  0x2D, 0xF0, 0x37, 0x72, 0x06, 0xFF, 0x90, 0x97, 0x74, 0x0D, 0xFE, 0x0C, 0x77, 0x50, 0x6F, 0xD0,
  0xE0, 0x27, 0x76, 0x0C, 0xFB, 0x0E, 0x03, 0x77, 0x70, 0x9F, 0xA0, 0xE0, 0x37, 0x77, 0x09, 0xFB,
  0x07, 0x60, 0x5F, 0x05, 0x60, 0xAF, 0xC0, 0xE0, 0x25, 0x08, 0xF0, 0x25, 0x09, 0xFE, 0x0D, 0x50,
  0xCE, 0x0E, 0x50, 0x6F, 0xF9, 0x0A, 0x30, 0x1F, 0x0B, 0x40, 0x2F, 0xFB, 0x07, 0x20, 0x6F, 0x06,
  0x40, 0xBF, 0x81, 0xE3, 0x8F, 0x98, 0x14, 0x0B, 0xF0, 0x23, 0x03, 0xF9, 0x04, 0x20, 0xCF, 0x0E,
  0x04, 0xF0, 0xD4, 0x08, 0xF0, 0x73, 0x02, 0x0E, 0xFF, 0x90, 0x74, 0x0D, 0xE0, 0xE5, 0x04, 0xFF,
  0x90, 0x14, 0xF0, 0xA6, 0x08, 0xFE, 0x0A, 0x40, 0x2F, 0x08, 0x70, 0xCF, 0xD0, 0x34, 0x02, 0xF0,
  0x87, 0x01, 0x0E, 0xFB, 0x0A, 0x50, 0x2F, 0x0B, 0x71, 0x04, 0xFA, 0x0E, 0x01, 0x6F, 0x90, 0x37,
  0x01, 0x0D, 0xF9, 0x0B, 0x70, 0xDF, 0x0D, 0x02, 0x50, 0x50, 0xDF, 0xB0, 0x66, 0x09, 0xFA, 0x83,
  0xA7, 0x79, 0xEF, 0xE0, 0x25, 0x04, 0xFF, 0xFE, 0x0D, 0x60, 0xCF, 0xFF, 0xE0, 0xA5, 0x02, 0x0E,
  0xFF, 0xFE, 0x06, 0x50, 0x4F, 0xFB, 0x0A, 0x05, 0xFA, 0x03, 0x50, 0x30, 0xDF, 0xE0, 0xC0, 0x52,
  0x07, 0xF9, 0x0D, 0x01, 0x60, 0x60, 0xCF, 0x98, 0x1D, 0x93, 0x50, 0xBF, 0x90, 0xA7, 0x18, 0x61,
  0x46, 0x77, 0x64, 0x27, 0x74,
  // "'" (U+0027)
  0x02, 0xF9, 0x00, 0x1F, 0x92, 0xF0, 0xE2, 0x0E, 0xE0, 0xD2, 0x0D, 0xE0, 0xC2, 0x0C, 0xE0, 0xB2,
  0x0B, 0xE0, 0xA2, 0x09, 0xE0, 0x82, 0x08, 0xE0, 0x72, 0x07, 0xE0, 0x62, 0x06, 0xE0, 0x52, 0x05,
  0xE0, 0x42, 0x03, 0xE0, 0x22, 0x02, 0xE0, 0x12, 0x01, 0xE2,
  // "(" (U+0028)
  0x71, 0x07, 0xE0, 0xA7, 0x03, 0xE0, 0xE0, 0x17, 0x0D, 0xE0, 0x57, 0x08, 0xE0, 0xC7, 0x02, 0xF0,
  0x37, 0x0A, 0xE0, 0xA7, 0x02, 0xF0, 0x37, 0x0A, 0xE0, 0xB7, 0x02, 0xF0, 0x57, 0x08, 0xE0, 0xE7,
  0x10, 0xDE, 0x09, 0x70, 0x4F, 0x03, 0x70, 0x9E, 0x0E, 0x71, 0x0D, 0xE0, 0xA7, 0x02, 0xF0, 0x57,
  0x06, 0xF0, 0x17, 0x09, 0xE0, 0xE7, 0x10, 0xCE, 0x0B, 0x71, 0xF0, 0x87, 0x01, 0xF0, 0x67, 0x03,
  0xF0, 0x47, 0x05, 0xF0, 0x37, 0x07, 0xF0, 0x17, 0x07, 0xF7, 0x10, 0x8F, 0x71, 0x08, 0xF7, 0x10,
  0x9F, 0x71, 0x08, 0xF7, 0x10, 0x7F, 0x71, 0x07, 0xF0, 0x17, 0x06, 0xF0, 0x27, 0x04, 0xF0, 0x47,
  0x02, 0xF0, 0x67, 0x1F, 0x08, 0x71, 0x0D, 0xE0, 0xB7, 0x10, 0xAE, 0x0E, 0x71, 0x07, 0xF0, 0x27,
  0x03, 0xF0, 0x67, 0x10, 0xEE, 0x0A, 0x71, 0x0A, 0xE0, 0xE7, 0x10, 0x5F, 0x04, 0x71, 0x0E, 0xE0,
  0x97, 0x10, 0x9E, 0x0E, 0x71, 0x03, 0xF0, 0x57, 0x10, 0xBE, 0x0C, 0x71, 0x04, 0xF0, 0x47, 0x10,
  0xBE, 0x0B, 0x71, 0x03, 0xF0, 0x47, 0x10, 0x9E, 0x0C, 0x71, 0x01, 0x0D, 0xE0, 0x57, 0x10, 0x3E,
  0x0E, 0x01, 0x71, 0x07, 0xE0, 0x90,
  // ")" (U+0029)
  0x09, 0xE0, 0x77, 0x10, 0x10, 0xEE, 0x03, 0x71, 0x05, 0xE0, 0xD0, 0x17, 0x10, 0xCE, 0x09, 0x71,
  0x04, 0xF0, 0x37, 0x10, 0xBE, 0x0B, 0x71, 0x04, 0xF0, 0x47, 0x10, 0xDE, 0x0B, 0x71, 0x06, 0xF0,
  0x37, 0x10, 0xEE, 0x09, 0x71, 0x0A, 0xE0, 0xE7, 0x10, 0x4F, 0x05, 0x71, 0x0E, 0xE0, 0xA7, 0x10,
  0xAE, 0x0E, 0x71, 0x06, 0xF0, 0x37, 0x02, 0xF0, 0x77, 0x10, 0xEE, 0x0A, 0x71, 0x0B, 0xE0, 0xD7,
  0x10, 0x8F, 0x71, 0x06, 0xF0, 0x27, 0x04, 0xF0, 0x47, 0x02, 0xF0, 0x67, 0x01, 0xF0, 0x77, 0x1F,
  0x07, 0x71, 0xF0, 0x87, 0x1F, 0x09, 0x71, 0xF0, 0x87, 0x1F, 0x08, 0x71, 0xF0, 0x77, 0x01, 0xF0,
  0x77, 0x03, 0xF0, 0x57, 0x04, 0xF0, 0x37, 0x06, 0xF0, 0x17, 0x08, 0xF7, 0x10, 0xBE, 0x0C, 0x71,
  0x0E, 0xE0, 0x97, 0x02, 0xF0, 0x67, 0x06, 0xF0, 0x27, 0x0A, 0xE0, 0xD7, 0x10, 0xEE, 0x08, 0x70,
  0x3F, 0x04, 0x70, 0x9E, 0x0D, 0x71, 0x0E, 0xE0, 0x77, 0x05, 0xF0, 0x27, 0x0B, 0xE0, 0xA7, 0x03,
  0xF0, 0x27, 0x0A, 0xE0, 0xA7, 0x03, 0xF0, 0x27, 0x0C, 0xE0, 0x87, 0x05, 0xE0, 0xD7, 0x01, 0x0E,
  0xE0, 0x37, 0x0A, 0xE0, 0x77, 0x10,
  // "*" (U+002A)
  0x73, 0x06, 0xE0, 0x77, 0x76, 0x05, 0xE0, 0x67, 0x76, 0x04, 0xE0, 0x57, 0x76, 0x03, 0xE0, 0x37,
  0x76, 0x01, 0xE0, 0x27, 0x77, 0xE0, 0x17, 0x77, 0x0E, 0xD7, 0x58, 0x11, 0x84, 0x70, 0xDC, 0x0D,
  0x68, 0x21, 0x59, 0x32, 0x05, 0xB8, 0x1C, 0x73, 0x30, 0xCC, 0x0C, 0x38, 0x14, 0x8C, 0xB0, 0x72,
  0x08, 0xE8, 0x2E, 0xB7, 0xCC, 0x82, 0xC6, 0xBE, 0xE0, 0xA2, 0x0C, 0xFF, 0xFB, 0x0D, 0x2F, 0xFF,
  0xD0, 0x10, 0x4F, 0xFF, 0xD8, 0x34, 0x3A, 0xCE, 0xFF, 0xF8, 0x1D, 0xB4, 0x58, 0x32, 0x46, 0x8D,
  0xF9, 0x84, 0xD9, 0x75, 0x31, 0x75, 0x01, 0x0E, 0xF9, 0x0E, 0x02, 0x77, 0x20, 0xCF, 0xB0, 0xC7,
  0x71, 0x09, 0xD0, 0xC0, 0xDD, 0x09, 0x76, 0x05, 0xE0, 0x30, 0x5E, 0x06, 0x74, 0x02, 0x0E, 0xD0,
  0xB2, 0x0C, 0xE0, 0x37, 0x30, 0xDE, 0x03, 0x20, 0x4E, 0x0D, 0x01, 0x71, 0x0A, 0xE0, 0xA4, 0x0B,
  0xE0, 0xB7, 0x01, 0x0C, 0xE0, 0x24, 0x03, 0xE0, 0xC0, 0x17, 0x10, 0x50, 0xEB, 0x09, 0x60, 0xAB,
  0x0E, 0x06, 0x75, 0x08, 0xA0, 0x16, 0x02, 0xA0, 0x90, 0x17, 0x70, 0x20, 0x57, 0x10, 0x60, 0x37,
  0x10,
  // "+" (U+002B)
  0x73, 0x01, 0xE0, 0x47, 0x76, 0x01, 0xE0, 0x47, 0x76, 0x01, 0xE0, 0x47, 0x76, 0x01, 0xE0, 0x47,
  0x76, 0x01, 0xE0, 0x47, 0x76, 0x01, 0xE0, 0x47, 0x76, 0x01, 0xE0, 0x47, 0x76, 0x01, 0xE0, 0x47,
  0x76, 0x01, 0xE0, 0x47, 0x76, 0x01, 0xE0, 0x47, 0x76, 0x01, 0xE0, 0x47, 0x30, 0xCF, 0xFF, 0xD0,
  0x0C, 0xFF, 0xFD, 0x00, 0xCF, 0xFF, 0xD0, 0x0C, 0xFF, 0xFD, 0x00, 0xCF, 0xFF, 0xD0, 0x0C, 0xFF,
  0xFD, 0x0C, 0x73, 0x01, 0xE0, 0x47, 0x76, 0x01, 0xE0, 0x47, 0x76, 0x01, 0xE0, 0x47, 0x76, 0x01,
  0xE0, 0x47, 0x76, 0x01, 0xE0, 0x47, 0x76, 0x01, 0xE0, 0x47, 0x76, 0x01, 0xE0, 0x47, 0x76, 0x01,
  0xE0, 0x47, 0x76, 0x01, 0xE0, 0x47, 0x76, 0x01, 0xE0, 0x47, 0x76, 0x01, 0xE0, 0x47, 0x30,
  // "," (U+002C)
  0x30, 0x3F, 0x90, 0x53, 0x05, 0xF9, 0x04, 0x30, 0x8F, 0x94, 0x0B, 0xF0, 0xB4, 0x0D, 0xF0, 0x74,
  0xF9, 0x03, 0x30, 0x3F, 0x0D, 0x40, 0x6F, 0x09, 0x40, 0x9F, 0x04, 0x40, 0xCE, 0x0E, 0x50, 0xEE,
  0x09, 0x40, 0x2F, 0x04, 0x40, 0x5E, 0x0D, 0x50, 0x8E, 0x08, 0x50, 0xBE, 0x02, 0x5E, 0x0B, 0x50,
  0x3E, 0x04, 0x50,
  // "-" (U+002D)
  0x80, 0x96, 0xE8, 0x09, 0xD0, 0xF0,
  // "." (U+002E)
  0x38, 0x42, 0x57, 0x75, 0x15, 0x0A, 0xE0, 0x83, 0x0A, 0xF9, 0x81, 0x80, 0x2F, 0xB0, 0x10, 0x5F,
  0xB0, 0x40, 0x6F, 0xB0, 0x05, 0xFB, 0x04, 0x01, 0xFA, 0x82, 0xE1, 0x09, 0xF9, 0x07, 0x30, 0x8D,
  0x0E, 0x07, 0x58, 0x41, 0x57, 0x75, 0x13,
  // "/" (U+002F)
  0x77, 0x20, 0xAE, 0x0C, 0x77, 0x10, 0x1F, 0x06, 0x77, 0x10, 0x7E, 0x0E, 0x77, 0x20, 0xDE, 0x09,
  0x77, 0x10, 0x4F, 0x03, 0x77, 0x10, 0xAE, 0x0D, 0x77, 0x10, 0x1F, 0x07, 0x77, 0x10, 0x7F, 0x01,
  0x77, 0x10, 0xDE, 0x0A, 0x77, 0x10, 0x3F, 0x04, 0x77, 0x10, 0x9E, 0x0D, 0x77, 0x20, 0xEE, 0x07,
  0x77, 0x10, 0x6F, 0x01, 0x77, 0x10, 0xCE, 0x0B, 0x77, 0x10, 0x3F, 0x05, 0x77, 0x10, 0x9E, 0x0E,
  0x77, 0x20, 0xEE, 0x08, 0x77, 0x10, 0x5F, 0x02, 0x77, 0x10, 0xBE, 0x0B, 0x77, 0x10, 0x2F, 0x05,
  0x77, 0x10, 0x8E, 0x0E, 0x77, 0x20, 0xEE, 0x09, 0x77, 0x10, 0x5F, 0x03, 0x77, 0x10, 0xBE, 0x0C,
  0x77, 0x10, 0x2F, 0x06, 0x77, 0x10, 0x8E, 0x0E, 0x77, 0x20, 0xDE, 0x09, 0x77, 0x10, 0x4F, 0x03,
  0x77, 0x10, 0xAE, 0x0D, 0x77, 0x10, 0x1F, 0x07, 0x77, 0x10, 0x7F, 0x01, 0x77, 0x10, 0xDE, 0x0A,
  0x77, 0x10, 0x4F, 0x04, 0x77, 0x10, 0xAE, 0x0D, 0x77, 0x10, 0x1F, 0x07, 0x77, 0x10, 0x7F, 0x01,
  0x77, 0x10, 0xDE, 0x0B, 0x77, 0x10, 0x3F, 0x05, 0x77, 0x10, 0x9E, 0x0E, 0x77, 0x20, 0xEE, 0x08,
  0x77, 0x10, 0x6F, 0x02, 0x77, 0x10, 0xCE, 0x0B, 0x77, 0x20,
  // "0" (U+0030)
  0x74, 0x86, 0x35, 0x67, 0x76, 0x41, 0x77, 0x58, 0x14, 0xAE, 0xF9, 0x81, 0xD8, 0x27, 0x70, 0x20,
  0xBF, 0xF0, 0x97, 0x50, 0x40, 0xEF, 0xFA, 0x0D, 0x02, 0x72, 0x04, 0xFF, 0xD0, 0xD0, 0x27, 0x02,
  0x0E, 0xFF, 0xE0, 0xC7, 0x0B, 0xFF, 0xF9, 0x08, 0x50, 0x5F, 0xB8, 0x2A, 0x87, 0xBF, 0xB0, 0x24,
  0x0C, 0xF9, 0x0B, 0x01, 0x40, 0x20, 0xDF, 0x90, 0x93, 0x03, 0xF9, 0x0C, 0x70, 0x3F, 0xA3, 0x08,
  0xF9, 0x03, 0x70, 0xAF, 0xA0, 0x52, 0x0C, 0xF0, 0xC7, 0x05, 0xFB, 0x81, 0xA0, 0x1F, 0x90, 0x77,
  0x0D, 0xFB, 0x81, 0xE0, 0x4F, 0x90, 0x36, 0x08, 0xFD, 0x02, 0x07, 0xF9, 0x60, 0x3F, 0xE0, 0x50,
  0x9F, 0x0C, 0x60, 0xCF, 0xE0, 0x80, 0xBF, 0x0B, 0x50, 0x6F, 0xF0, 0xA0, 0xCF, 0x09, 0x40, 0x10,
  0xED, 0x0E, 0x0D, 0xF0, 0xC0, 0xDF, 0x08, 0x40, 0xAE, 0x07, 0x0A, 0xF0, 0xD0, 0xEF, 0x07, 0x30,
  0x4E, 0x81, 0xC0, 0xAF, 0x0E, 0xF9, 0x07, 0x30, 0xDE, 0x81, 0x30, 0x9F, 0x0E, 0xF9, 0x06, 0x20,
  0x8E, 0x08, 0x20, 0x9F, 0xFA, 0x81, 0x60, 0x2E, 0x0D, 0x30, 0x9F, 0xFA, 0x81, 0x60, 0xBE, 0x04,
  0x30, 0x9F, 0x00, 0xEF, 0x00, 0x6E, 0x0A, 0x40, 0x9F, 0x0E, 0x0D, 0xF0, 0x80, 0xED, 0x0E, 0x01,
  0x40, 0xAF, 0x0D, 0x0C, 0xFF, 0x06, 0x50, 0xBF, 0x0C, 0x0A, 0xFE, 0x0B, 0x60, 0xCF, 0x0B, 0x08,
  0xFE, 0x02, 0x60, 0xEF, 0x09, 0x06, 0xFD, 0x07, 0x60, 0x1F, 0x90, 0x60, 0x3F, 0xC0, 0xD7, 0x04,
  0xF9, 0x81, 0x30, 0xEF, 0xB0, 0x37, 0x08, 0xF9, 0x20, 0xBF, 0xA0, 0x97, 0x10, 0xCF, 0x0C, 0x20,
  0x6F, 0x90, 0xE0, 0x17, 0x03, 0xF9, 0x08, 0x20, 0x1F, 0x90, 0xB7, 0x10, 0xCF, 0x90, 0x23, 0x09,
  0xF9, 0x0A, 0x01, 0x40, 0x10, 0xBF, 0x90, 0xC4, 0x02, 0xFA, 0x83, 0xE9, 0x78, 0xAF, 0xB0, 0x45,
  0x09, 0xFF, 0xF9, 0x0B, 0x70, 0xDF, 0xFE, 0x0E, 0x01, 0x70, 0x20, 0xEF, 0xFD, 0x04, 0x72, 0x02,
  0x0D, 0xFF, 0xA0, 0xE0, 0x47, 0x40, 0x10, 0x9F, 0xF0, 0xB0, 0x27, 0x78, 0x12, 0x8D, 0xF9, 0x81,
  0xEA, 0x47, 0x75, 0x86, 0x24, 0x67, 0x76, 0x52, 0x74,
  // "1" (U+0031)
  0x74, 0x05, 0x0D, 0xE0, 0xB7, 0x73, 0x04, 0x0C, 0xF9, 0x0B, 0x77, 0x10, 0x30, 0xBF, 0xB0, 0xB7,
  0x60, 0x20, 0xAF, 0xD0, 0xB7, 0x40, 0x10, 0x8F, 0xF0, 0xB7, 0x30, 0x70, 0xEF, 0xF9, 0x0B, 0x71,
  0x06, 0x0E, 0xFF, 0xB0, 0xB7, 0x10, 0x8F, 0xFC, 0x0B, 0x72, 0x0E, 0xFF, 0xB0, 0xB7, 0x20, 0x6F,
  0x90, 0xE0, 0xDF, 0x0B, 0x73, 0x0C, 0xE8, 0x1A, 0x1B, 0xF0, 0xB7, 0x30, 0x3C, 0x0C, 0x03, 0x20,
  0xCF, 0x0B, 0x74, 0x82, 0xAF, 0xD5, 0x40, 0xCF, 0x0B, 0x74, 0x02, 0x06, 0x60, 0xDF, 0x0B, 0x77,
  0x50, 0xDF, 0x0B, 0x77, 0x50, 0xEF, 0x0B, 0x77, 0x50, 0xEF, 0x0B, 0x77, 0x50, 0xEF, 0x0B, 0x77,
  0x50, 0xEF, 0x0B, 0x77, 0x50, 0xEF, 0x0B, 0x77, 0x50, 0xEF, 0x0B, 0x77, 0x50, 0xEF, 0x0B, 0x77,
  0x50, 0xEF, 0x0B, 0x77, 0x50, 0xEF, 0x0B, 0x77, 0x50, 0xEF, 0x0B, 0x77, 0x50, 0xEF, 0x0B, 0x77,
  0x50, 0xEF, 0x0B, 0x77, 0x50, 0xEF, 0x0B, 0x77, 0x50, 0xEF, 0x0B, 0x77, 0x50, 0xEF, 0x0B, 0x77,
  0x50, 0xEF, 0x0B, 0x77, 0x50, 0xEF, 0x0B, 0x77, 0x50, 0xEF, 0x0B, 0x77, 0x50, 0xEF, 0x0B, 0x77,
  0x50, 0xEF, 0x0B, 0x75, 0x85, 0x13, 0x46, 0x79, 0xBF, 0x98, 0x5E, 0xA9, 0x75, 0x42, 0x40, 0x3F,
  0xFF, 0xB0, 0xB2, 0x03, 0xFF, 0xFB, 0x0C, 0x20, 0x3F, 0xFF, 0xB0, 0xC2, 0x03, 0xFF, 0xFB, 0x0C,
  0x20, 0x3F, 0xFF, 0xB0, 0xC2, 0x03, 0xFF, 0xFB, 0x0C,
  // "2" (U+0032)
  0x74, 0x87, 0x35, 0x67, 0x76, 0x53, 0x17, 0x74, 0x81, 0x38, 0xDF, 0xB8, 0x1C, 0x71, 0x76, 0x05,
  0x0C, 0xFF, 0xA0, 0x87, 0x30, 0x20, 0xCF, 0xFD, 0x0D, 0x02, 0x70, 0x7F, 0xFF, 0x90, 0xE0, 0x34,
  0x01, 0x0B, 0xFF, 0xFB, 0x0D, 0x01, 0x30, 0x5F, 0xFF, 0xD0, 0x94, 0x08, 0xFA, 0x84, 0xEA, 0x87,
  0x8B, 0xFC, 0x02, 0x40, 0xAE, 0x0C, 0x05, 0x60, 0x20, 0xCF, 0xA0, 0x85, 0x0C, 0xB0, 0xE0, 0x67,
  0x30, 0xDF, 0x90, 0xC5, 0x83, 0x1D, 0xFC, 0x27, 0x40, 0x5F, 0xA6, 0x02, 0x09, 0x77, 0xFA, 0x01,
  0x77, 0x70, 0xEF, 0x90, 0x27, 0x77, 0x0E, 0xF9, 0x01, 0x77, 0x60, 0x1F, 0x90, 0xE7, 0x77, 0x05,
  0xF9, 0x0C, 0x77, 0x70, 0xAF, 0x90, 0x87, 0x76, 0x03, 0xFA, 0x03, 0x77, 0x60, 0xCF, 0x90, 0xB7,
  0x76, 0x08, 0xFA, 0x03, 0x77, 0x50, 0x5F, 0xA0, 0x97, 0x75, 0x03, 0x0E, 0xF9, 0x0D, 0x01, 0x77,
  0x40, 0x20, 0xEF, 0xA0, 0x37, 0x74, 0x02, 0x0D, 0xFA, 0x06, 0x77, 0x40, 0x10, 0xDF, 0xA0, 0x87,
  0x74, 0x01, 0x0D, 0xFA, 0x08, 0x77, 0x40, 0x10, 0xDF, 0xA0, 0x87, 0x74, 0x01, 0x0D, 0xFA, 0x07,
  0x77, 0x40, 0x10, 0xDF, 0xA0, 0x67, 0x74, 0x01, 0x0D, 0xFA, 0x05, 0x77, 0x40, 0x10, 0xDF, 0x90,
  0xE0, 0x47, 0x74, 0x01, 0x0D, 0xF9, 0x0D, 0x02, 0x77, 0x40, 0x10, 0xDF, 0x90, 0xC0, 0x17, 0x74,
  0x01, 0x0D, 0xF9, 0x0B, 0x77, 0x50, 0x10, 0xDF, 0x90, 0x97, 0x75, 0x01, 0x0D, 0xF9, 0x0A, 0x77,
  0x50, 0x10, 0xCF, 0xB8, 0x09, 0x6E, 0x04, 0x08, 0xFF, 0xFF, 0x90, 0x40, 0x9F, 0xFF, 0xF9, 0x04,
  0x09, 0xFF, 0xFF, 0x90, 0x40, 0x9F, 0xFF, 0xF9, 0x04, 0x09, 0xFF, 0xFF, 0x90, 0x40, 0x9F, 0xFF,
  0xF9, 0x04,
  // "3" (U+0033)
  0x72, 0x87, 0x14, 0x56, 0x77, 0x64, 0x27, 0x72, 0x82, 0x16, 0xAD, 0xFA, 0x81, 0xEA, 0x57, 0x40,
  0x40, 0xAF, 0xFA, 0x0D, 0x05, 0x70, 0x40, 0xCF, 0xFE, 0x0A, 0x50, 0x8F, 0xFF, 0xA0, 0xB4, 0x03,
  0xFF, 0xFB, 0x07, 0x40, 0x8F, 0xFF, 0xB0, 0x14, 0x0D, 0xF8, 0x4D, 0x98, 0x78, 0xBF, 0xB0, 0x64,
  0x04, 0xC8, 0x1D, 0x72, 0x60, 0x20, 0xDF, 0x90, 0xA5, 0x82, 0xAF, 0xC4, 0x73, 0x02, 0xF9, 0x0B,
  0x50, 0x10, 0x57, 0x60, 0xBF, 0x0C, 0x77, 0x60, 0x7F, 0x0B, 0x77, 0x60, 0x7F, 0x0A, 0x77, 0x60,
  0x9F, 0x06, 0x77, 0x60, 0xDF, 0x01, 0x77, 0x50, 0x8F, 0x0A, 0x77, 0x50, 0x8F, 0x0E, 0x01, 0x77,
  0x83, 0x12, 0x59, 0xEF, 0x90, 0x57, 0x30, 0x7F, 0xFA, 0x06, 0x74, 0x07, 0xFF, 0x0C, 0x03, 0x75,
  0x07, 0xFC, 0x81, 0xEA, 0x47, 0x70, 0x7F, 0xC8, 0x2D, 0xA6, 0x27, 0x60, 0x7F, 0xF9, 0x0C, 0x05,
  0x74, 0x07, 0xFF, 0xB0, 0xB0, 0x17, 0x20, 0x70, 0xFE, 0xFF, 0x90, 0xD0, 0x17, 0x78, 0x31, 0x25,
  0x9E, 0xFA, 0x0A, 0x77, 0x50, 0x8F, 0xA0, 0x37, 0x75, 0x09, 0xF9, 0x09, 0x77, 0x50, 0x1F, 0x90,
  0xD7, 0x76, 0x0D, 0xF9, 0x77, 0x60, 0xCF, 0x90, 0x17, 0x75, 0x0D, 0xF9, 0x77, 0x50, 0x1F, 0xA7,
  0x75, 0x07, 0xF9, 0x83, 0xC0, 0xA9, 0x37, 0x70, 0x30, 0xEF, 0x98, 0x19, 0x0B, 0xA8, 0x2D, 0x84,
  0x17, 0x20, 0x60, 0xEF, 0xA8, 0x14, 0x0B, 0xE8, 0x7D, 0xB9, 0x87, 0x78, 0xBE, 0xFB, 0x0D, 0x20,
  0xBF, 0xFF, 0xC0, 0x42, 0x0B, 0xFF, 0xFB, 0x08, 0x30, 0xBF, 0xFF, 0xA0, 0x94, 0x0B, 0xFF, 0xF9,
  0x07, 0x50, 0x40, 0xBF, 0xFD, 0x0A, 0x02, 0x72, 0x82, 0x48, 0xBE, 0xFB, 0x82, 0xEB, 0x61, 0x77,
  0x18, 0x90, 0x13, 0x56, 0x77, 0x76, 0x42, 0x75,
  // "4" (U+0034)
  0x77, 0x30, 0x5F, 0x90, 0x17, 0x77, 0x01, 0x0E, 0xF9, 0x01, 0x77, 0x70, 0xAF, 0xA0, 0x17, 0x76,
  0x04, 0xFB, 0x01, 0x77, 0x50, 0x10, 0xDF, 0xB0, 0x17, 0x75, 0x09, 0xFC, 0x01, 0x77, 0x40, 0x4F,
  0xD0, 0x17, 0x74, 0x0D, 0xFD, 0x01, 0x77, 0x30, 0x9F, 0xE0, 0x17, 0x72, 0x03, 0xD0, 0x0E, 0xF0,
  0x17, 0x72, 0x0D, 0xD0, 0x80, 0xDF, 0x01, 0x77, 0x10, 0x8D, 0x81, 0xE1, 0xEF, 0x01, 0x77, 0x03,
  0xE8, 0x17, 0x0E, 0xF0, 0x17, 0x70, 0xCD, 0x0D, 0x2F, 0x90, 0x17, 0x60, 0x7E, 0x04, 0x2F, 0x90,
  0x17, 0x50, 0x2E, 0x0A, 0x20, 0x1F, 0x90, 0x17, 0x50, 0xCD, 0x0E, 0x01, 0x20, 0x2F, 0x90, 0x17,
  0x40, 0x7E, 0x07, 0x30, 0x2F, 0x90, 0x17, 0x30, 0x2E, 0x0D, 0x40, 0x3F, 0x90, 0x17, 0x30, 0xCE,
  0x04, 0x40, 0x3F, 0x90, 0x17, 0x20, 0x6E, 0x0A, 0x50, 0x3F, 0x90, 0x17, 0x10, 0x20, 0xEE, 0x02,
  0x50, 0x3F, 0x90, 0x17, 0x10, 0xBE, 0x07, 0x60, 0x3F, 0x90, 0x17, 0x06, 0xE0, 0xD7, 0x03, 0xF9,
  0x01, 0x60, 0x10, 0xEE, 0x04, 0x70, 0x3F, 0x90, 0x16, 0x0B, 0xE0, 0xA7, 0x10, 0x3F, 0x90, 0x15,
  0x05, 0xF9, 0x80, 0x5E, 0xF9, 0x80, 0x1E, 0x08, 0x09, 0xFF, 0xFF, 0xA0, 0x09, 0xFF, 0xFF, 0xA0,
  0x09, 0xFF, 0xFF, 0xA0, 0x09, 0xFF, 0xFF, 0xA0, 0x09, 0xFF, 0xFF, 0xA0, 0x09, 0xFF, 0xFF, 0xA0,
  0x97, 0x73, 0x03, 0xF9, 0x01, 0x77, 0x71, 0x03, 0xF9, 0x01, 0x77, 0x71, 0x03, 0xF9, 0x01, 0x77,
  0x71, 0x03, 0xF9, 0x01, 0x77, 0x71, 0x03, 0xF9, 0x01, 0x77, 0x71, 0x03, 0xF9, 0x01, 0x77, 0x71,
  0x03, 0xF9, 0x01, 0x77, 0x71, 0x03, 0xF9, 0x01, 0x77, 0x71, 0x03, 0xF9, 0x01, 0x50,
  // "5" (U+0035)
  0x20, 0x1F, 0xFF, 0x90, 0x24, 0x02, 0xFF, 0xF9, 0x02, 0x40, 0x3F, 0xFF, 0x90, 0x24, 0x05, 0xFF,
  0xF9, 0x02, 0x40, 0x6F, 0xFF, 0x90, 0x24, 0x07, 0xFF, 0xF9, 0x02, 0x40, 0x8F, 0x98, 0x09, 0x2E,
  0x02, 0x40, 0x9F, 0x0B, 0x77, 0x50, 0xBF, 0x0A, 0x77, 0x50, 0xCF, 0x08, 0x77, 0x50, 0xDF, 0x07,
  0x77, 0x50, 0xEF, 0x06, 0x77, 0x5F, 0x90, 0x57, 0x74, 0x01, 0xF9, 0x04, 0x77, 0x40, 0x2F, 0x90,
  0x27, 0x74, 0x04, 0xF9, 0x89, 0x07, 0x8A, 0xCC, 0xCB, 0x85, 0x17, 0x20, 0x5F, 0xFC, 0x09, 0x02,
  0x70, 0x6F, 0xFE, 0x08, 0x60, 0x7F, 0xFF, 0x0B, 0x50, 0x8F, 0xFF, 0x90, 0xA4, 0x0A, 0xFF, 0xFA,
  0x06, 0x30, 0x7F, 0xFF, 0xA0, 0xE0, 0x13, 0x02, 0x0A, 0xA8, 0x7D, 0x97, 0x43, 0x35, 0x8C, 0xFC,
  0x07, 0x50, 0x03, 0x72, 0x05, 0x0E, 0xFA, 0x0C, 0x77, 0x30, 0x30, 0xEF, 0xA0, 0x17, 0x73, 0x06,
  0xFA, 0x04, 0x77, 0x40, 0xEF, 0x90, 0x67, 0x74, 0x0B, 0xF9, 0x07, 0x77, 0x40, 0xAF, 0x90, 0x77,
  0x74, 0x0A, 0xF9, 0x06, 0x77, 0x40, 0xBF, 0x90, 0x57, 0x74, 0x0E, 0xF9, 0x02, 0x77, 0x30, 0x5F,
  0x98, 0x3E, 0x06, 0x92, 0x76, 0x01, 0x0D, 0xF9, 0x81, 0x90, 0x6A, 0x81, 0xC7, 0x37, 0x20, 0x50,
  0xDF, 0xA8, 0x13, 0x06, 0xE8, 0x6C, 0xA8, 0x77, 0x8A, 0xDF, 0xB0, 0xA2, 0x06, 0xFF, 0xFA, 0x0E,
  0x02, 0x20, 0x6F, 0xFF, 0xA0, 0x43, 0x06, 0xFF, 0xF0, 0xE0, 0x44, 0x06, 0xFF, 0xE0, 0xC0, 0x25,
  0x03, 0x0B, 0xFF, 0xB0, 0xD0, 0x67, 0x28, 0x21, 0x6A, 0xEF, 0xB8, 0x1D, 0x94, 0x77, 0x18, 0x90,
  0x13, 0x56, 0x77, 0x65, 0x31, 0x75,
  // "6" (U+0036)
  0x77, 0x85, 0x36, 0x9B, 0xDE, 0xEC, 0x0E, 0x07, 0x77, 0x81, 0x39, 0xEF, 0xD0, 0xA7, 0x50, 0x40,
  0xCF, 0xF9, 0x0A, 0x73, 0x01, 0x0A, 0xFF, 0xB0, 0xA7, 0x20, 0x20, 0xDF, 0xFC, 0x0A, 0x71, 0x02,
  0x0E, 0xFF, 0xD0, 0xA7, 0x01, 0x0D, 0xFF, 0xE0, 0xA7, 0x0B, 0xFB, 0x83, 0xE9, 0x52, 0x13, 0x82,
  0x12, 0x55, 0x60, 0x6F, 0xA0, 0xD0, 0x67, 0x74, 0x0E, 0xF9, 0x0B, 0x01, 0x77, 0x40, 0x6F, 0x90,
  0xB7, 0x76, 0x0D, 0xF0, 0xE0, 0x17, 0x75, 0x03, 0xF9, 0x06, 0x77, 0x60, 0x7F, 0x0D, 0x77, 0x70,
  0xCF, 0x08, 0x38, 0x90, 0x16, 0xAD, 0xEE, 0xCB, 0x73, 0x71, 0xF9, 0x04, 0x20, 0x8F, 0xB0, 0xC0,
  0x35, 0x02, 0xF9, 0x10, 0x10, 0xCF, 0xE0, 0x74, 0x05, 0xF8, 0x1D, 0x1D, 0xFF, 0x90, 0x83, 0x07,
  0xF0, 0xB0, 0xAF, 0xFB, 0x04, 0x20, 0x8F, 0xFF, 0xD0, 0xD2, 0x09, 0xFF, 0xFE, 0x81, 0x50, 0xAF,
  0xC8, 0x5D, 0x61, 0x01, 0x5C, 0xFA, 0x81, 0xB0, 0xAF, 0xB0, 0xA7, 0x0B, 0xFA, 0x01, 0x0A, 0xFA,
  0x0B, 0x71, 0x01, 0x0E, 0xF9, 0x04, 0x0A, 0xFA, 0x02, 0x72, 0x09, 0xF9, 0x07, 0x09, 0xF9, 0x0B,
  0x73, 0x04, 0xF9, 0x00, 0x8F, 0x90, 0x77, 0x30, 0x2F, 0x90, 0x90, 0x6F, 0x90, 0x57, 0x30, 0x1F,
  0x90, 0xA0, 0x4F, 0x90, 0x47, 0x30, 0x1F, 0x90, 0x90, 0x1F, 0x90, 0x57, 0x30, 0x2F, 0x98, 0x18,
  0x0D, 0xF0, 0x87, 0x30, 0x4F, 0x98, 0x17, 0x09, 0xF0, 0xC7, 0x30, 0x7F, 0x98, 0x14, 0x04, 0xF9,
  0x03, 0x72, 0x0C, 0xF9, 0x01, 0x20, 0xEF, 0x0D, 0x01, 0x70, 0x5F, 0x90, 0xC3, 0x07, 0xF9, 0x0C,
  0x02, 0x50, 0x5F, 0xA0, 0x64, 0x0D, 0xFA, 0x83, 0xB8, 0x78, 0xCF, 0xA0, 0xE5, 0x04, 0xFF, 0xFA,
  0x06, 0x60, 0x8F, 0xFF, 0x0B, 0x71, 0x09, 0xFF, 0xD0, 0xD0, 0x17, 0x20, 0x8F, 0xFB, 0x0B, 0x01,
  0x74, 0x03, 0x0C, 0xFE, 0x0E, 0x07, 0x77, 0x10, 0x50, 0xAF, 0xA0, 0xB0, 0x77, 0x76, 0x85, 0x35,
  0x77, 0x65, 0x47, 0x40,
  // "7" (U+0037)
  0x80, 0xAD, 0x7F, 0x80, 0xA1, 0xEF, 0xA0, 0x77, 0x76, 0x0D, 0xF9, 0x01, 0x77, 0x50, 0x4F, 0x90,
  0x97, 0x76, 0x0B, 0xF9, 0x02, 0x77, 0x50, 0x3F, 0x90, 0xB7, 0x76, 0x0A, 0xF9, 0x04, 0x77, 0x50,
  0x2F, 0x90, 0xD7, 0x76, 0x09, 0xF9, 0x06, 0x77, 0x50, 0x1F, 0x90, 0xE7, 0x76, 0x08, 0xF9, 0x08,
  0x77, 0x60, 0xEF, 0x90, 0x17, 0x75, 0x06, 0xF9, 0x09, 0x77, 0x60, 0xDF, 0x90, 0x37, 0x75, 0x05,
  0xF9, 0x0B, 0x77, 0x60, 0xCF, 0x90, 0x47, 0x75, 0x04, 0xF9, 0x0D, 0x77, 0x60, 0xBF, 0x90, 0x67,
  0x75, 0x03, 0xF9, 0x0E, 0x77, 0x60, 0xAF, 0x90, 0x87, 0x75, 0x01, 0xFA, 0x01, 0x77, 0x50, 0x8F,
  0x90, 0xA7, 0x75, 0x01, 0x0E, 0xF9, 0x03, 0x77, 0x50, 0x7F, 0x90, 0xB7, 0x76, 0x0E, 0xF9, 0x05,
  0x77, 0x50, 0x6F, 0x90, 0xD7, 0x76, 0x0D, 0xF9, 0x06, 0x77, 0x50, 0x5F, 0x90, 0xE7, 0x76, 0x0C,
  0xF9, 0x08, 0x77, 0x50, 0x3F, 0xA0, 0x27, 0x75, 0x0A, 0xF9, 0x0A, 0x77, 0x50, 0x2F, 0xA0, 0x37,
  0x75, 0x09, 0xF9, 0x0C, 0x77, 0x50, 0x1F, 0xA0, 0x57, 0x75, 0x08, 0xF9, 0x0D, 0x77, 0x60, 0xEF,
  0x90, 0x77, 0x75, 0x07, 0xF9, 0x0E, 0x01, 0x77, 0x10,
  // "8" (U+0038)
  0x74, 0x86, 0x25, 0x67, 0x76, 0x53, 0x77, 0x58, 0x15, 0xAE, 0xFA, 0x0B, 0x06, 0x77, 0x06, 0x0E,
  0xFF, 0x0E, 0x07, 0x73, 0x01, 0x0B, 0xFF, 0xC0, 0xC0, 0x17, 0x10, 0xCF, 0xFE, 0x0D, 0x01, 0x60,
  0xAF, 0xFF, 0x90, 0xB5, 0x04, 0xFF, 0xFB, 0x04, 0x40, 0xAF, 0xA8, 0x4E, 0x97, 0x7A, 0xEF, 0xA0,
  0xA4, 0x0E, 0xF9, 0x0A, 0x50, 0x10, 0xAF, 0x90, 0xE3, 0x01, 0xF9, 0x0D, 0x71, 0x0C, 0xF9, 0x01,
  0x20, 0x1F, 0x90, 0x77, 0x10, 0x7F, 0x90, 0x12, 0x01, 0xF9, 0x06, 0x71, 0x06, 0xF9, 0x01, 0x30,
  0xEF, 0x07, 0x71, 0x07, 0xF0, 0xE4, 0x0B, 0xF0, 0xC7, 0x10, 0xCF, 0x0B, 0x40, 0x6F, 0x90, 0x66,
  0x05, 0xF9, 0x05, 0x40, 0x10, 0xEF, 0x90, 0x64, 0x04, 0xF9, 0x0D, 0x60, 0x7F, 0xA8, 0x29, 0x10,
  0x8F, 0xA0, 0x47, 0x0B, 0xFA, 0x0E, 0x0D, 0xFA, 0x06, 0x71, 0x01, 0x0C, 0xFF, 0xC0, 0x67, 0x30,
  0x10, 0xBF, 0xF9, 0x0D, 0x03, 0x76, 0x08, 0xFE, 0x07, 0x77, 0x01, 0x09, 0xFE, 0x0D, 0x04, 0x75,
  0x04, 0x0E, 0xFF, 0xA0, 0xA7, 0x30, 0x7F, 0xFD, 0x0D, 0x02, 0x70, 0x8F, 0xB0, 0xBF, 0xB0, 0xE0,
  0x35, 0x05, 0xFA, 0x83, 0xC3, 0x02, 0xCF, 0xA0, 0xE0, 0x13, 0x01, 0x0E, 0xF9, 0x09, 0x50, 0x7F,
  0xA0, 0xB3, 0x07, 0xF9, 0x09, 0x70, 0x40, 0xEF, 0x90, 0x52, 0x0D, 0xF0, 0xD7, 0x20, 0x4F, 0x98,
  0x1C, 0x02, 0xF9, 0x05, 0x73, 0x08, 0xF9, 0x01, 0x05, 0xF9, 0x01, 0x73, 0x02, 0xF9, 0x04, 0x06,
  0xF0, 0xE7, 0x5F, 0x90, 0x06, 0xF9, 0x75, 0xF9, 0x06, 0x05, 0xF9, 0x04, 0x73, 0x04, 0xF9, 0x05,
  0x04, 0xF9, 0x0C, 0x73, 0x0C, 0xF9, 0x02, 0x1F, 0xA0, 0xC0, 0x26, 0x02, 0x0C, 0xF9, 0x0E, 0x20,
  0xBF, 0xB8, 0x4C, 0x87, 0x78, 0xCF, 0xB0, 0x82, 0x04, 0xFF, 0xFC, 0x0E, 0x01, 0x30, 0x9F, 0xFF,
  0xB0, 0x55, 0x0B, 0xFF, 0xF9, 0x06, 0x70, 0x9F, 0xFD, 0x0E, 0x05, 0x72, 0x04, 0x0C, 0xFF, 0xA0,
  0x90, 0x17, 0x58, 0x13, 0x9D, 0xFB, 0x81, 0xB6, 0x17, 0x73, 0x87, 0x13, 0x56, 0x77, 0x65, 0x37,
  0x40,
  // "9" (U+0039)
  0x74, 0x85, 0x45, 0x67, 0x75, 0x37, 0x75, 0x81, 0x17, 0xCF, 0xA0, 0xB0, 0x57, 0x71, 0x08, 0x0E,
  0xFE, 0x0C, 0x03, 0x74, 0x01, 0x0C, 0xFF, 0xB0, 0x87, 0x20, 0x10, 0xDF, 0xFD, 0x09, 0x71, 0x0C,
  0xFF, 0xF0, 0x86, 0x08, 0xFF, 0xFA, 0x04, 0x40, 0x1F, 0xB8, 0x3C, 0x87, 0x8B, 0xFA, 0x0D, 0x40,
  0x8F, 0x90, 0xE0, 0x55, 0x02, 0x0C, 0xF9, 0x07, 0x30, 0xDF, 0x90, 0x47, 0x10, 0xCF, 0x0E, 0x20,
  0x2F, 0x90, 0xB7, 0x20, 0x2F, 0x98, 0x14, 0x05, 0xF9, 0x06, 0x73, 0x0B, 0xF8, 0x19, 0x08, 0xF9,
  0x03, 0x73, 0x07, 0xF8, 0x1D, 0x09, 0xF9, 0x01, 0x73, 0x05, 0xF9, 0x01, 0x0A, 0xF9, 0x01, 0x73,
  0x04, 0xF9, 0x04, 0x0A, 0xF9, 0x01, 0x73, 0x05, 0xF9, 0x06, 0x09, 0xF9, 0x03, 0x73, 0x09, 0xF9,
  0x00, 0x8F, 0x90, 0x77, 0x30, 0xDF, 0x90, 0x90, 0x5F, 0x90, 0xD7, 0x20, 0x7F, 0xA0, 0xA0, 0x2F,
  0xA0, 0x87, 0x06, 0xFB, 0x81, 0xA0, 0xDF, 0xA0, 0xA0, 0x33, 0x04, 0x0B, 0xFC, 0x81, 0xA0, 0x7F,
  0xFF, 0xE8, 0x2A, 0x01, 0xEF, 0xFF, 0xD0, 0x92, 0x06, 0xFF, 0xB0, 0xB0, 0xCF, 0x08, 0x30, 0xAF,
  0xF9, 0x81, 0xE1, 0xDF, 0x07, 0x40, 0x9F, 0xE0, 0xD0, 0x21, 0xF9, 0x05, 0x50, 0x50, 0xDF, 0xB8,
  0x2A, 0x10, 0x2F, 0x90, 0x27, 0x82, 0x49, 0xCD, 0xA8, 0x2D, 0xB7, 0x23, 0x06, 0xF9, 0x77, 0x70,
  0xAF, 0x0C, 0x77, 0x60, 0x1F, 0x90, 0x87, 0x76, 0x07, 0xF9, 0x04, 0x77, 0x50, 0x10, 0xEF, 0x0E,
  0x77, 0x60, 0xAF, 0x90, 0x87, 0x75, 0x08, 0xFA, 0x01, 0x77, 0x30, 0x10, 0x9F, 0xA0, 0x87, 0x72,
  0x81, 0x27, 0xEF, 0xA0, 0xD7, 0x89, 0x0C, 0xCA, 0x87, 0x78, 0x9A, 0xDF, 0xD0, 0x47, 0x0C, 0xFF,
  0xE0, 0x67, 0x10, 0xCF, 0xFD, 0x07, 0x72, 0x0C, 0xFF, 0xB0, 0xE0, 0x57, 0x30, 0xCF, 0xFA, 0x0A,
  0x02, 0x74, 0x0C, 0xFF, 0x0A, 0x03, 0x76, 0x0C, 0xFB, 0x82, 0xDA, 0x61, 0x77, 0x10, 0x30, 0x68,
  0x01, 0x78, 0x26, 0x53, 0x17, 0x72,
  // ":" (U+003A)
  0x38, 0x42, 0x57, 0x75, 0x15, 0x0A, 0xE0, 0x83, 0x0A, 0xF9, 0x81, 0x80, 0x2F, 0xB0, 0x10, 0x5F,
  0xB0, 0x40, 0x6F, 0xB0, 0x05, 0xFB, 0x04, 0x01, 0xFA, 0x82, 0xE1, 0x09, 0xF9, 0x07, 0x30, 0x8D,
  0x0E, 0x07, 0x58, 0x41, 0x57, 0x75, 0x18, 0x0A, 0xA2, 0x08, 0x42, 0x57, 0x75, 0x15, 0x0A, 0xE0,
  0x83, 0x0A, 0xF9, 0x81, 0x80, 0x2F, 0xB0, 0x10, 0x5F, 0xB0, 0x40, 0x6F, 0xB0, 0x05, 0xFB, 0x04,
  0x01, 0xFA, 0x82, 0xE1, 0x09, 0xF9, 0x07, 0x30, 0x8D, 0x0E, 0x07, 0x58, 0x41, 0x57, 0x75, 0x13,
  // ";" (U+003B)
  0x68, 0x34, 0x77, 0x62, 0x70, 0x60, 0xED, 0x0B, 0x01, 0x40, 0x5F, 0x90, 0xC4, 0x0D, 0xFA, 0x05,
  0x20, 0x1F, 0xB0, 0x92, 0x01, 0xFB, 0x0A, 0x3F, 0xB0, 0x93, 0x0C, 0xFA, 0x05, 0x30, 0x4F, 0x90,
  0xC5, 0x05, 0x0E, 0xD0, 0xA0, 0x17, 0x83, 0x46, 0x76, 0x28, 0x0B, 0x86, 0x00, 0x3F, 0x90, 0x54,
  0x05, 0xF9, 0x04, 0x40, 0x8F, 0x95, 0x0B, 0xF0, 0xB5, 0x0D, 0xF0, 0x75, 0xF9, 0x03, 0x40, 0x3F,
  0x0D, 0x50, 0x6F, 0x09, 0x50, 0x9F, 0x04, 0x50, 0xCE, 0x0E, 0x60, 0xEE, 0x09, 0x50, 0x2F, 0x04,
  0x50, 0x5E, 0x0D, 0x60, 0x8E, 0x08, 0x60, 0xBE, 0x02, 0x6E, 0x0B, 0x60, 0x3E, 0x04, 0x60,
  // "<" (U+003C)
  0x77, 0x74, 0x05, 0x77, 0x72, 0x81, 0x6D, 0xE7, 0x77, 0x05, 0x0D, 0xA0, 0xE7, 0x75, 0x05, 0x0D,
  0xC0, 0xE7, 0x73, 0x04, 0x0C, 0xE0, 0xE7, 0x71, 0x04, 0x0C, 0xF9, 0x0E, 0x76, 0x03, 0x0B, 0xFB,
  0x0E, 0x74, 0x03, 0x0B, 0xFD, 0x09, 0x72, 0x02, 0x0A, 0xFD, 0x09, 0x02, 0x71, 0x02, 0x0A, 0xFD,
  0x09, 0x01, 0x71, 0x02, 0x09, 0xFD, 0x08, 0x01, 0x71, 0x01, 0x09, 0xFC, 0x81, 0xE8, 0x17, 0x10,
  0x10, 0x8F, 0xC8, 0x1E, 0x81, 0x72, 0x07, 0x0E, 0xFB, 0x81, 0xE8, 0x17, 0x40, 0xEF, 0xA8, 0x1E,
  0x81, 0x76, 0x0E, 0xF9, 0x0B, 0x01, 0x77, 0x10, 0xEF, 0xA0, 0xB0, 0x47, 0x70, 0xDF, 0xC0, 0xC0,
  0x57, 0x58, 0x11, 0x8E, 0xFC, 0x0D, 0x06, 0x75, 0x81, 0x18, 0xEF, 0xC8, 0x1E, 0x71, 0x75, 0x07,
  0x0E, 0xFC, 0x81, 0xE9, 0x27, 0x50, 0x70, 0xEF, 0xD0, 0xA0, 0x37, 0x50, 0x60, 0xDF, 0xD0, 0xB0,
  0x47, 0x50, 0x60, 0xDF, 0xD0, 0xB7, 0x60, 0x50, 0xDF, 0xB0, 0xE7, 0x71, 0x05, 0x0C, 0xF9, 0x0E,
  0x77, 0x30, 0x50, 0xCE, 0x0E, 0x77, 0x50, 0x40, 0xCC, 0x0E, 0x77, 0x70, 0x40, 0xBA, 0x0E, 0x77,
  0x72, 0x81, 0x3B, 0xE7, 0x77, 0x40, 0x20,
  // "=" (U+003D)
  0x0C, 0xFF, 0xFD, 0x00, 0xCF, 0xFF, 0xD0, 0x0C, 0xFF, 0xFD, 0x00, 0xCF, 0xFF, 0xD0, 0x0C, 0xFF,
  0xFD, 0x00, 0xCF, 0xFF, 0xD0, 0xC0, 0xB8, 0x0A, 0x6E, 0x0B, 0x80, 0xAC, 0x40, 0x0B, 0x80, 0xA6,
  0xE0, 0xB0, 0xCF, 0xFF, 0xD0, 0x0C, 0xFF, 0xFD, 0x00, 0xCF, 0xFF, 0xD0, 0x0C, 0xFF, 0xFD, 0x00,
  0xCF, 0xFF, 0xD0, 0x0C, 0xFF, 0xFD, 0x0C,
  // ">" (U+003E)
  0x05, 0x77, 0x74, 0x81, 0xED, 0x67, 0x77, 0x20, 0xEA, 0x0D, 0x05, 0x77, 0x70, 0xEC, 0x0D, 0x05,
  0x77, 0x50, 0xEE, 0x0C, 0x04, 0x77, 0x30, 0xEF, 0x90, 0xC0, 0x47, 0x71, 0x0E, 0xFB, 0x0B, 0x03,
  0x76, 0x09, 0xFD, 0x0B, 0x03, 0x75, 0x02, 0x09, 0xFD, 0x0A, 0x02, 0x75, 0x01, 0x09, 0xFD, 0x0A,
  0x02, 0x75, 0x01, 0x09, 0xFD, 0x09, 0x02, 0x75, 0x81, 0x18, 0xEF, 0xC0, 0x90, 0x17, 0x58, 0x11,
  0x8E, 0xFC, 0x08, 0x01, 0x75, 0x81, 0x18, 0xEF, 0xB0, 0xE0, 0x77, 0x68, 0x11, 0x8E, 0xFA, 0x0E,
  0x77, 0x10, 0x10, 0xBF, 0x90, 0xE7, 0x70, 0x40, 0xBF, 0xA0, 0xE7, 0x50, 0x50, 0xCF, 0xC0, 0xD7,
  0x30, 0x60, 0xDF, 0xC8, 0x1E, 0x81, 0x78, 0x11, 0x7E, 0xFC, 0x81, 0xE8, 0x17, 0x81, 0x29, 0xEF,
  0xC0, 0xE0, 0x77, 0x10, 0x30, 0xAF, 0xD0, 0xE0, 0x77, 0x10, 0x40, 0xBF, 0xD0, 0xD0, 0x67, 0x20,
  0xBF, 0xD0, 0xD0, 0x67, 0x40, 0xEF, 0xB0, 0xD0, 0x57, 0x60, 0xEF, 0x90, 0xC0, 0x57, 0x71, 0x0E,
  0xE0, 0xC0, 0x57, 0x73, 0x0E, 0xC0, 0xC0, 0x47, 0x75, 0x0E, 0xA0, 0xB0, 0x47, 0x77, 0x81, 0xEB,
  0x37, 0x77, 0x20, 0x27, 0x77, 0x40,
  // "?" (U+003F)
  0x72, 0x86, 0x35, 0x56, 0x77, 0x53, 0x77, 0x18, 0x14, 0x9C, 0xFB, 0x81, 0xC6, 0x17, 0x18, 0x13,
  0x9E, 0xFF, 0x90, 0xE0, 0x75, 0x04, 0x0B, 0xFF, 0xE0, 0xC0, 0x13, 0x0E, 0xFF, 0xF9, 0x0C, 0x30,
  0x7F, 0xFF, 0xA0, 0xA3, 0x0E, 0xFF, 0xFA, 0x03, 0x20, 0x7F, 0x85, 0xDA, 0x87, 0x8A, 0xEF, 0xA0,
  0xA3, 0x0E, 0xB8, 0x1C, 0x71, 0x60, 0x10, 0x8F, 0x90, 0xE3, 0x82, 0x6F, 0xA3, 0x74, 0x0B, 0xF9,
  0x01, 0x30, 0x17, 0x60, 0x5F, 0x90, 0x27, 0x73, 0x04, 0xF9, 0x02, 0x77, 0x30, 0x6F, 0x90, 0x17,
  0x73, 0x0A, 0xF0, 0xE7, 0x73, 0x03, 0xF9, 0x0B, 0x77, 0x20, 0x20, 0xEF, 0x90, 0x57, 0x71, 0x03,
  0x0E, 0xF9, 0x0D, 0x77, 0x10, 0x6F, 0xA0, 0xE0, 0x37, 0x60, 0x10, 0xAF, 0xB0, 0x47, 0x60, 0x20,
  0xDF, 0xA0, 0xE0, 0x37, 0x60, 0x20, 0xDF, 0xA0, 0xC0, 0x27, 0x70, 0xCF, 0xA0, 0x97, 0x71, 0x08,
  0xFA, 0x06, 0x77, 0x20, 0xEF, 0x0E, 0x03, 0x77, 0x20, 0x4F, 0x0E, 0x02, 0x77, 0x30, 0x7F, 0x08,
  0x77, 0x40, 0x8F, 0x03, 0x77, 0x40, 0x8F, 0x02, 0x77, 0x40, 0x9F, 0x02, 0x77, 0x40, 0x28, 0x03,
  0x48, 0x09, 0xC2, 0x08, 0x34, 0x67, 0x63, 0x77, 0x60, 0x60, 0xED, 0x0B, 0x02, 0x77, 0x30, 0x4F,
  0x90, 0xD7, 0x73, 0x0C, 0xFA, 0x06, 0x77, 0x2F, 0xB0, 0xA7, 0x72, 0xFB, 0x0B, 0x77, 0x2F, 0xB0,
  0xA7, 0x72, 0x0B, 0xFA, 0x06, 0x77, 0x20, 0x3F, 0x90, 0xC7, 0x74, 0x04, 0x0D, 0xD0, 0xB0, 0x17,
  0x76, 0x83, 0x46, 0x76, 0x27, 0x60,
  // "@" (U+0040)
  0x77, 0x89, 0x14, 0x8B, 0xDE, 0xFE, 0xDB, 0x73, 0x77, 0x71, 0x81, 0x29, 0xEF, 0xC0, 0xC0, 0x57,
  0x75, 0x08, 0xFF, 0xA0, 0xC0, 0x27, 0x71, 0x02, 0x0D, 0xFF, 0xC0, 0xE0, 0x57, 0x60, 0x40, 0xEF,
  0xFF, 0x05, 0x74, 0x04, 0xF9, 0x87, 0xB6, 0x21, 0x01, 0x38, 0xDF, 0x04, 0x72, 0x02, 0x0E, 0xE0,
  0xA0, 0x27, 0x20, 0x7E, 0x0E, 0x01, 0x71, 0x0D, 0xE0, 0x67, 0x50, 0x30, 0xED, 0x0A, 0x70, 0x8E,
  0x05, 0x77, 0x04, 0xE0, 0x35, 0x02, 0xE0, 0x67, 0x72, 0x07, 0xD0, 0xB5, 0x0A, 0xD0, 0xA7, 0x74,
  0x0D, 0xD0, 0x23, 0x02, 0xE0, 0x17, 0x74, 0x06, 0xD0, 0x83, 0x09, 0xD0, 0x86, 0x81, 0x4A, 0xDA,
  0x83, 0xEC, 0x95, 0x14, 0xD0, 0xD3, 0x0E, 0xD0, 0x14, 0x02, 0x0C, 0xFB, 0x0C, 0x06, 0x20, 0xBD,
  0x81, 0x20, 0x4D, 0x0A, 0x40, 0x30, 0xEF, 0xD0, 0xB2, 0x07, 0xD8, 0x16, 0x09, 0xD0, 0x53, 0x01,
  0x0E, 0xFE, 0x0A, 0x20, 0x4D, 0x81, 0x80, 0xDD, 0x40, 0xBF, 0xF0, 0x92, 0x01, 0xD0, 0xA0, 0x2D,
  0x0B, 0x30, 0x3E, 0x82, 0x71, 0x06, 0xD0, 0x83, 0xD0, 0xC0, 0x5D, 0x08, 0x30, 0xAD, 0x07, 0x30,
  0x4D, 0x07, 0x30, 0xEC, 0x0D, 0x07, 0xD0, 0x53, 0xD0, 0xD4, 0x05, 0xD0, 0x73, 0x0D, 0xC0, 0xE0,
  0xAD, 0x03, 0x20, 0x4D, 0x08, 0x40, 0x6D, 0x06, 0x30, 0xCD, 0x0B, 0xD0, 0x12, 0x07, 0xD0, 0x44,
  0x07, 0xD0, 0x53, 0x0C, 0xC0, 0xE0, 0xDD, 0x30, 0x9D, 0x01, 0x40, 0x7D, 0x04, 0x30, 0xDC, 0x0D,
  0x0E, 0xC0, 0xE3, 0x0B, 0xD5, 0x08, 0xD0, 0x33, 0x0D, 0xC0, 0xC0, 0xEC, 0x0E, 0x30, 0xBC, 0x0E,
  0x50, 0x9D, 0x02, 0x30, 0xEC, 0x0B, 0xD0, 0xD3, 0x0B, 0xC0, 0xE5, 0x0B, 0xD0, 0x22, 0x01, 0xD0,
  0x9D, 0x0E, 0x30, 0xAD, 0x50, 0xDD, 0x01, 0x20, 0x3D, 0x05, 0x0E, 0xD3, 0x09, 0xD0, 0x13, 0x01,
  0xE0, 0x12, 0x06, 0xD0, 0x20, 0xDD, 0x30, 0x6D, 0x03, 0x30, 0x5E, 0x01, 0x20, 0x9C, 0x81, 0xE0,
  0xCD, 0x01, 0x20, 0x3D, 0x08, 0x30, 0xAE, 0x04, 0x20, 0xEC, 0x81, 0x90, 0xAD, 0x04, 0x30, 0xEC,
  0x82, 0xE4, 0x07, 0xF8, 0x1B, 0x18, 0xD8, 0x13, 0x08, 0xD0, 0x73, 0x08, 0xFF, 0xF9, 0x0B, 0x20,
  0x5D, 0x0A, 0x30, 0x10, 0xEF, 0xB0, 0xEF, 0xB0, 0x22, 0x01, 0xD0, 0xE4, 0x06, 0xFA, 0x09, 0x04,
  0xFA, 0x05, 0x40, 0xDD, 0x04, 0x40, 0x7F, 0x09, 0x20, 0x7F, 0x06, 0x50, 0x8D, 0x09, 0x58, 0x53,
  0x9D, 0xFD, 0xA3, 0x48, 0x54, 0xBE, 0xFD, 0x92, 0x60, 0x2E, 0x02, 0x77, 0x77, 0x10, 0xCD, 0x0B,
  0x77, 0x77, 0x10, 0x4E, 0x05, 0x77, 0x77, 0x10, 0xBD, 0x0E, 0x03, 0x77, 0x77, 0x02, 0x0E, 0xD0,
  0xE0, 0x57, 0x73, 0x04, 0x73, 0x05, 0xF0, 0x90, 0x17, 0x58, 0x24, 0x9E, 0xB7, 0x40, 0x7F, 0x98,
  0x2A, 0x63, 0x12, 0x84, 0x12, 0x47, 0xAE, 0xB0, 0xB7, 0x50, 0x7F, 0xFF, 0x90, 0xB7, 0x60, 0x40,
  0xEF, 0xFE, 0x0B, 0x77, 0x01, 0x09, 0xFF, 0xD0, 0x97, 0x72, 0x81, 0x29, 0xEF, 0xE8, 0x1E, 0x92,
  0x77, 0x68, 0x93, 0x47, 0xAD, 0xEE, 0xFE, 0xDC, 0x97, 0x37, 0x30,
  // "A" (U+0041)
  0x75, 0x0B, 0xFB, 0x0A, 0x77, 0x73, 0xFC, 0x0E, 0x77, 0x72, 0x04, 0xFD, 0x03, 0x77, 0x71, 0x08,
  0xFD, 0x07, 0x77, 0x71, 0x0D, 0xFD, 0x0C, 0x77, 0x70, 0x1F, 0xF0, 0x17, 0x76, 0x06, 0xFF, 0x05,
  0x77, 0x60, 0xAE, 0x00, 0xBE, 0x09, 0x77, 0x60, 0xEE, 0x00, 0x8E, 0x0E, 0x77, 0x50, 0x3F, 0x00,
  0x4F, 0x03, 0x77, 0x40, 0x8F, 0x2F, 0x07, 0x77, 0x40, 0xCE, 0x0C, 0x20, 0xCE, 0x0B, 0x77, 0x30,
  0x1F, 0x08, 0x20, 0x8F, 0x01, 0x77, 0x20, 0x5F, 0x04, 0x20, 0x4F, 0x05, 0x77, 0x20, 0xAF, 0x4F,
  0x09, 0x77, 0x20, 0xEE, 0x0B, 0x40, 0xCE, 0x0D, 0x77, 0x10, 0x3F, 0x07, 0x40, 0x8F, 0x02, 0x77,
  0x07, 0xF0, 0x34, 0x04, 0xF0, 0x77, 0x70, 0xCE, 0x0E, 0x6F, 0x0B, 0x76, 0x01, 0xF0, 0xA6, 0x0C,
  0xF7, 0x60, 0x5F, 0x06, 0x60, 0x8F, 0x04, 0x75, 0x09, 0xF0, 0x26, 0x04, 0xF0, 0x97, 0x50, 0xEE,
  0x0E, 0x71, 0xF0, 0xD7, 0x40, 0x3F, 0x09, 0x71, 0x0B, 0xF0, 0x27, 0x30, 0x7F, 0x98, 0x04, 0xEF,
  0x90, 0x77, 0x30, 0xBF, 0xFF, 0xB0, 0xB7, 0x3F, 0xFF, 0xD7, 0x20, 0x5F, 0xFF, 0xD0, 0x47, 0x10,
  0x9F, 0xFF, 0xD0, 0x97, 0x10, 0xDF, 0xFF, 0xD0, 0xD7, 0x02, 0xFF, 0xFF, 0x02, 0x60, 0x7F, 0x09,
  0x75, 0x0B, 0xF0, 0x66, 0x0B, 0xF0, 0x57, 0x50, 0x8F, 0x0B, 0x6F, 0x90, 0x17, 0x50, 0x4F, 0x0E,
  0x50, 0x4F, 0x0D, 0x76, 0x01, 0xF9, 0x04, 0x40, 0x9F, 0x09, 0x77, 0x0C, 0xF0, 0x84, 0x0D, 0xF0,
  0x57, 0x70, 0x9F, 0x0D, 0x30, 0x2F, 0x90, 0x27, 0x70, 0x5F, 0x90, 0x22, 0x06, 0xF0, 0xD7, 0x71,
  0x01, 0xF9, 0x06, 0x20, 0xAF, 0x0A, 0x77, 0x20, 0xDF, 0x0A, 0x20, 0xEF, 0x06, 0x77, 0x20, 0xAF,
  0x81, 0xE0, 0x4F, 0x90, 0x27, 0x72, 0x06, 0xF9, 0x04,
  // "B" (U+0042)
  0x03, 0xFF, 0x85, 0xED, 0xDA, 0x85, 0x17, 0x10, 0x3F, 0xFF, 0x0C, 0x05, 0x60, 0x3F, 0xFF, 0xA0,
  0xD0, 0x34, 0x03, 0xFF, 0xFC, 0x05, 0x30, 0x3F, 0xFF, 0xD0, 0x22, 0x03, 0xFF, 0xFD, 0x0B, 0x20,
  0x3F, 0x98, 0x01, 0xEF, 0xF8, 0x11, 0x03, 0xF0, 0xE7, 0x81, 0x37, 0xEF, 0xA8, 0x16, 0x03, 0xF0,
  0xE7, 0x20, 0x20, 0xEF, 0x98, 0x18, 0x03, 0xF0, 0xE7, 0x30, 0x7F, 0x98, 0x1A, 0x03, 0xF0, 0xE7,
  0x30, 0x3F, 0x98, 0x1A, 0x03, 0xF0, 0xE7, 0x30, 0x2F, 0x98, 0x19, 0x03, 0xF0, 0xE7, 0x30, 0x3F,
  0x98, 0x16, 0x03, 0xF0, 0xE7, 0x30, 0x7F, 0x98, 0x13, 0x03, 0xF0, 0xE7, 0x20, 0x20, 0xEF, 0x0C,
  0x20, 0x3F, 0x0E, 0x68, 0x21, 0x37, 0xEF, 0x90, 0x42, 0x03, 0xFF, 0xFC, 0x09, 0x30, 0x3F, 0xFF,
  0xB0, 0x94, 0x03, 0xFF, 0xF9, 0x0B, 0x04, 0x50, 0x3F, 0xFF, 0x0A, 0x03, 0x60, 0x3F, 0xFF, 0xA0,
  0xC0, 0x34, 0x03, 0xFF, 0xFC, 0x07, 0x30, 0x3F, 0x98, 0x02, 0xEF, 0xD0, 0x72, 0x03, 0xF0, 0xE7,
  0x81, 0x25, 0xCF, 0xA8, 0x13, 0x03, 0xF0, 0xE7, 0x30, 0xBF, 0x98, 0x1B, 0x03, 0xF0, 0xE7, 0x30,
  0x1F, 0xA0, 0x10, 0x3F, 0x0E, 0x74, 0x0B, 0xF9, 0x04, 0x03, 0xF0, 0xE7, 0x40, 0x8F, 0x90, 0x70,
  0x3F, 0x0E, 0x74, 0x07, 0xF9, 0x08, 0x03, 0xF0, 0xE7, 0x40, 0x7F, 0x90, 0x80, 0x3F, 0x0E, 0x74,
  0x09, 0xF9, 0x07, 0x03, 0xF0, 0xE7, 0x40, 0xCF, 0x90, 0x60, 0x3F, 0x0E, 0x73, 0x03, 0xFA, 0x04,
  0x03, 0xF0, 0xE7, 0x30, 0xCF, 0x98, 0x1E, 0x03, 0xF0, 0xE7, 0x81, 0x15, 0xDF, 0xA8, 0x1A, 0x03,
  0xF9, 0x80, 0x2E, 0xFE, 0x81, 0x30, 0x3F, 0xFF, 0xD0, 0xA2, 0x03, 0xFF, 0xFC, 0x0D, 0x01, 0x20,
  0x3F, 0xFF, 0xB0, 0xD0, 0x23, 0x03, 0xFF, 0xFA, 0x0A, 0x01, 0x40, 0x3F, 0xFF, 0x0B, 0x04, 0x60,
  0x3F, 0xF9, 0x84, 0xED, 0xC9, 0x62, 0x71,
  // "C" (U+0043)
  0x77, 0x28, 0x73, 0x56, 0x77, 0x65, 0x41, 0x77, 0x48, 0x14, 0x9D, 0xFB, 0x82, 0xEA, 0x51, 0x75,
  0x07, 0x0E, 0xFF, 0xA8, 0x1E, 0x92, 0x71, 0x05, 0x0E, 0xFF, 0xE0, 0x47, 0x09, 0xFF, 0xF0, 0xD7,
  0x0B, 0xFF, 0xF9, 0x07, 0x60, 0xCF, 0xFF, 0x90, 0xE0, 0x15, 0x09, 0xFC, 0x86, 0xDA, 0x87, 0x78,
  0xAD, 0xC0, 0x95, 0x05, 0xFB, 0x0A, 0x03, 0x71, 0x83, 0x38, 0xEF, 0x25, 0x0D, 0xF9, 0x0E, 0x04,
  0x76, 0x05, 0x50, 0x7F, 0x90, 0xE0, 0x37, 0x76, 0x0D, 0xF9, 0x05, 0x77, 0x60, 0x4F, 0x90, 0xB7,
  0x77, 0x0A, 0xF9, 0x04, 0x77, 0x70, 0xEF, 0x0D, 0x77, 0x70, 0x3F, 0x90, 0x97, 0x77, 0x06, 0xF9,
  0x05, 0x77, 0x70, 0x9F, 0x90, 0x37, 0x77, 0x0B, 0xF9, 0x77, 0x71, 0x0D, 0xF0, 0xE7, 0x77, 0x10,
  0xDF, 0x0D, 0x77, 0x71, 0x0E, 0xF0, 0xD7, 0x77, 0x1F, 0x90, 0xC7, 0x77, 0x1F, 0x90, 0xD7, 0x77,
  0x10, 0xEF, 0x0E, 0x77, 0x71, 0x0D, 0xF0, 0xE7, 0x77, 0x10, 0xCF, 0x90, 0x17, 0x77, 0x0A, 0xF9,
  0x03, 0x77, 0x70, 0x8F, 0x90, 0x67, 0x77, 0x05, 0xF9, 0x0A, 0x77, 0x70, 0x1F, 0x90, 0xE7, 0x77,
  0x10, 0xCF, 0x90, 0x67, 0x77, 0x07, 0xF9, 0x0E, 0x77, 0x70, 0x2F, 0xA0, 0xA7, 0x77, 0x0A, 0xFA,
  0x0A, 0x77, 0x04, 0x09, 0x40, 0x2F, 0xB8, 0x1E, 0x61, 0x71, 0x83, 0x38, 0xDF, 0xE5, 0x08, 0xFD,
  0x86, 0xB9, 0x87, 0x89, 0xBE, 0xC0, 0xE6, 0x0C, 0xFF, 0xFA, 0x0E, 0x60, 0x10, 0xDF, 0xFF, 0x90,
  0xE7, 0x02, 0x0D, 0xFF, 0xF0, 0xE7, 0x20, 0xAF, 0xFE, 0x0E, 0x73, 0x04, 0x0C, 0xFF, 0xB0, 0xE0,
  0x97, 0x58, 0x13, 0x8D, 0xFC, 0x81, 0xC8, 0x47, 0x74, 0x87, 0x35, 0x67, 0x76, 0x64, 0x27, 0x10,
  // "D" (U+0044)
  0x04, 0xFF, 0x83, 0xED, 0xB8, 0x47, 0x60, 0x4F, 0xFD, 0x81, 0xEA, 0x37, 0x30, 0x4F, 0xFF, 0x90,
  0xA0, 0x27, 0x10, 0x4F, 0xFF, 0xA0, 0xE0, 0x57, 0x04, 0xFF, 0xFC, 0x07, 0x60, 0x4F, 0xFF, 0xD0,
  0x75, 0x04, 0xFA, 0x80, 0x0E, 0xFF, 0x05, 0x40, 0x4F, 0x90, 0x45, 0x81, 0x25, 0xAF, 0xB0, 0xE0,
  0x13, 0x04, 0xF9, 0x04, 0x71, 0x02, 0x0C, 0xFA, 0x09, 0x30, 0x4F, 0x90, 0x47, 0x30, 0xBF, 0xA0,
  0x12, 0x04, 0xF9, 0x04, 0x74, 0x0D, 0xF9, 0x08, 0x20, 0x4F, 0x90, 0x47, 0x40, 0x5F, 0x90, 0xD2,
  0x04, 0xF9, 0x04, 0x75, 0x0D, 0xF9, 0x81, 0x20, 0x4F, 0x90, 0x47, 0x50, 0x8F, 0x98, 0x17, 0x04,
  0xF9, 0x04, 0x75, 0x04, 0xF9, 0x81, 0xA0, 0x4F, 0x90, 0x47, 0x50, 0x1F, 0x98, 0x1C, 0x04, 0xF9,
  0x04, 0x76, 0x0E, 0xF8, 0x1E, 0x04, 0xF9, 0x04, 0x76, 0x0C, 0xF9, 0x10, 0x4F, 0x90, 0x47, 0x60,
  0xBF, 0x90, 0x20, 0x4F, 0x90, 0x47, 0x60, 0xAF, 0x90, 0x20, 0x4F, 0x90, 0x47, 0x60, 0x9F, 0x90,
  0x30, 0x4F, 0x90, 0x47, 0x60, 0xAF, 0x90, 0x20, 0x4F, 0x90, 0x47, 0x60, 0xBF, 0x90, 0x20, 0x4F,
  0x90, 0x47, 0x60, 0xBF, 0x90, 0x10, 0x4F, 0x90, 0x47, 0x60, 0xDF, 0x91, 0x04, 0xF9, 0x04, 0x76,
  0xF9, 0x81, 0xD0, 0x4F, 0x90, 0x47, 0x50, 0x2F, 0x98, 0x1A, 0x04, 0xF9, 0x04, 0x75, 0x06, 0xF9,
  0x81, 0x80, 0x4F, 0x90, 0x47, 0x50, 0xBF, 0x98, 0x14, 0x04, 0xF9, 0x04, 0x74, 0x01, 0xF9, 0x0E,
  0x20, 0x4F, 0x90, 0x47, 0x40, 0x9F, 0x90, 0xA2, 0x04, 0xF9, 0x04, 0x73, 0x03, 0xFA, 0x04, 0x20,
  0x4F, 0x90, 0x47, 0x20, 0x20, 0xEF, 0x90, 0xC3, 0x04, 0xF9, 0x04, 0x71, 0x06, 0x0E, 0xFA, 0x04,
  0x30, 0x4F, 0x90, 0x44, 0x82, 0x13, 0x8D, 0xFB, 0x09, 0x40, 0x4F, 0xA0, 0xFE, 0xFF, 0x0D, 0x01,
  0x40, 0x4F, 0xFF, 0xC0, 0xE0, 0x25, 0x04, 0xFF, 0xFB, 0x0D, 0x02, 0x60, 0x4F, 0xFF, 0xA0, 0xB0,
  0x17, 0x04, 0xFF, 0xF0, 0xE0, 0x67, 0x20, 0x4F, 0xFD, 0x0C, 0x06, 0x74, 0x04, 0xFE, 0x84, 0xED,
  0xC9, 0x62, 0x76,
  // "E" (U+0045)
  0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C,
  0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xF9, 0x80, 0x96, 0xE0, 0xB0, 0x3F, 0x90,
  0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40,
  0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03,
  0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xFF, 0xFC, 0x81, 0xE0, 0x3F, 0xFF, 0xC8, 0x1E, 0x03,
  0xFF, 0xFC, 0x81, 0xE0, 0x3F, 0xFF, 0xC8, 0x1E, 0x03, 0xFF, 0xFC, 0x81, 0xE0, 0x3F, 0xFF, 0xC8,
  0x1E, 0x03, 0xF9, 0x80, 0x95, 0xE8, 0x1D, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74,
  0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90,
  0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40,
  0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x80,
  0x96, 0xE0, 0xB0, 0x3F, 0xFF, 0xD0, 0xC0, 0x3F, 0xFF, 0xD0, 0xC0, 0x3F, 0xFF, 0xD0, 0xC0, 0x3F,
  0xFF, 0xD0, 0xC0, 0x3F, 0xFF, 0xD0, 0xC0, 0x3F, 0xFF, 0xD0, 0xC0,
  // "F" (U+0046)
  0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C,
  0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xF9, 0x80, 0x96, 0xE0, 0xB0, 0x3F, 0x90,
  0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40,
  0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03,
  0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03,
  0xF9, 0x80, 0x95, 0xE8, 0x1D, 0x03, 0xFF, 0xFC, 0x81, 0xE0, 0x3F, 0xFF, 0xC8, 0x1E, 0x03, 0xFF,
  0xFC, 0x81, 0xE0, 0x3F, 0xFF, 0xC8, 0x1E, 0x03, 0xFF, 0xFC, 0x81, 0xE0, 0x3F, 0xFF, 0xC8, 0x1E,
  0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90,
  0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40,
  0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03,
  0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03,
  0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40,
  // "G" (U+0047)
  0x77, 0x18, 0x90, 0x13, 0x56, 0x77, 0x65, 0x42, 0x77, 0x68, 0x13, 0x9D, 0xFC, 0x81, 0xC8, 0x47,
  0x70, 0x50, 0xDF, 0xFB, 0x81, 0xE8, 0x27, 0x20, 0x20, 0xCF, 0xFF, 0x0B, 0x71, 0x05, 0x0E, 0xFF,
  0xF9, 0x05, 0x70, 0x6F, 0xFF, 0xA0, 0xD7, 0x05, 0xFF, 0xFB, 0x07, 0x60, 0x20, 0xEF, 0xC8, 0x6E,
  0xA9, 0x77, 0x8A, 0xDD, 0x01, 0x60, 0xBF, 0xB0, 0xB0, 0x47, 0x18, 0x31, 0x5B, 0xFA, 0x60, 0x5F,
  0xA0, 0xE0, 0x57, 0x60, 0x03, 0x60, 0xDF, 0x90, 0xE0, 0x37, 0x77, 0x04, 0xFA, 0x04, 0x77, 0x71,
  0x0A, 0xF9, 0x0A, 0x77, 0x72, 0xFA, 0x02, 0x77, 0x71, 0x04, 0xF9, 0x0B, 0x77, 0x72, 0x08, 0xF9,
  0x06, 0x77, 0x72, 0x0A, 0xF9, 0x01, 0x77, 0x72, 0x0D, 0xF0, 0xE7, 0x77, 0x3F, 0x90, 0xB7, 0x77,
  0x20, 0x1F, 0x90, 0xA7, 0x10, 0x78, 0x09, 0x1E, 0x04, 0x02, 0xF9, 0x09, 0x71, 0x07, 0xFE, 0x04,
  0x02, 0xF9, 0x08, 0x71, 0x07, 0xFE, 0x04, 0x03, 0xF9, 0x07, 0x71, 0x07, 0xFE, 0x04, 0x02, 0xF9,
  0x08, 0x71, 0x07, 0xFE, 0x04, 0x02, 0xF9, 0x09, 0x71, 0x07, 0xFE, 0x04, 0x01, 0xF9, 0x0A, 0x71,
  0x07, 0xFE, 0x04, 0x1F, 0x90, 0xD7, 0x70, 0x8F, 0x81, 0x40, 0xDF, 0x97, 0x70, 0x8F, 0x81, 0x40,
  0xAF, 0x90, 0x37, 0x60, 0x8F, 0x81, 0x40, 0x7F, 0x90, 0x87, 0x60, 0x8F, 0x81, 0x40, 0x3F, 0x90,
  0xD7, 0x60, 0x8F, 0x04, 0x20, 0xEF, 0x90, 0x67, 0x50, 0x8F, 0x04, 0x20, 0x9F, 0x90, 0xD7, 0x50,
  0x8F, 0x04, 0x20, 0x2F, 0xA0, 0xB7, 0x40, 0x8F, 0x04, 0x30, 0xBF, 0xA0, 0x97, 0x30, 0x8F, 0x04,
  0x30, 0x2F, 0xB0, 0xD0, 0x57, 0x10, 0x8F, 0x04, 0x40, 0x8F, 0xC8, 0x6E, 0xA8, 0x77, 0x8A, 0xDF,
  0x90, 0x45, 0x0C, 0xFF, 0xFD, 0x04, 0x50, 0x10, 0xDF, 0xFF, 0xC0, 0x46, 0x01, 0x0C, 0xFF, 0xFB,
  0x04, 0x71, 0x09, 0xFF, 0xFA, 0x04, 0x72, 0x03, 0x0B, 0xFF, 0xD8, 0x1D, 0x71, 0x74, 0x81, 0x27,
  0xCF, 0xD8, 0x2E, 0xA7, 0x37, 0x74, 0x89, 0x13, 0x56, 0x77, 0x76, 0x65, 0x31, 0x70,
  // "H" (U+0048)
  0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06,
  0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9,
  0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90,
  0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F,
  0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9,
  0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06,
  0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xFF, 0xFF, 0xA0, 0x04, 0xFF, 0xFF, 0xA0,
  0x04, 0xFF, 0xFF, 0xA0, 0x04, 0xFF, 0xFF, 0xA0, 0x04, 0xFF, 0xFF, 0xA0, 0x04, 0xFF, 0xFF, 0xA0,
  0x04, 0xFA, 0x80, 0x90, 0xEF, 0xA0, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67,
  0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90,
  0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06,
  0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9,
  0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90,
  0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F,
  0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9,
  0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06,
  0xF9, 0x04,
  // "I" (U+0049)
  0x09, 0xFF, 0xFB, 0x00, 0x9F, 0xFF, 0xB0, 0x09, 0xFF, 0xFB, 0x00, 0x9F, 0xFF, 0xB0, 0x09, 0xFF,
  0xFB, 0x00, 0x9F, 0xFF, 0xB8, 0x79, 0x13, 0x57, 0x8A, 0xCE, 0xFB, 0x86, 0xDC, 0xA8, 0x75, 0x31,
  0x71, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F,
  0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77,
  0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9,
  0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72,
  0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90,
  0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20,
  0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01,
  0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x38, 0x51,
  0x24, 0x68, 0x9C, 0xF9, 0x85, 0xB9, 0x76, 0x42, 0x12, 0x08, 0x0E, 0xFF, 0xF9, 0x81, 0xE8, 0x9F,
  0xFF, 0xB0, 0x09, 0xFF, 0xFB, 0x00, 0x9F, 0xFF, 0xB0, 0x09, 0xFF, 0xFB, 0x00, 0x9F, 0xFF, 0xB0,
  0x90,
  // "J" (U+004A)
  0x77, 0x10, 0x1F, 0x90, 0x67, 0x71, 0x01, 0xF9, 0x06, 0x77, 0x10, 0x1F, 0x90, 0x67, 0x71, 0x01,
  0xF9, 0x06, 0x77, 0x10, 0x1F, 0x90, 0x67, 0x71, 0x01, 0xF9, 0x06, 0x77, 0x10, 0x1F, 0x90, 0x67,
  0x71, 0x01, 0xF9, 0x06, 0x77, 0x10, 0x1F, 0x90, 0x67, 0x71, 0x01, 0xF9, 0x06, 0x77, 0x10, 0x1F,
  0x90, 0x67, 0x71, 0x01, 0xF9, 0x06, 0x77, 0x10, 0x1F, 0x90, 0x67, 0x71, 0x01, 0xF9, 0x06, 0x77,
  0x10, 0x1F, 0x90, 0x67, 0x71, 0x01, 0xF9, 0x06, 0x77, 0x10, 0x1F, 0x90, 0x67, 0x71, 0x01, 0xF9,
  0x06, 0x77, 0x10, 0x1F, 0x90, 0x67, 0x71, 0x01, 0xF9, 0x06, 0x77, 0x10, 0x1F, 0x90, 0x67, 0x71,
  0x01, 0xF9, 0x06, 0x77, 0x10, 0x1F, 0x90, 0x67, 0x71, 0x01, 0xF9, 0x06, 0x77, 0x10, 0x1F, 0x90,
  0x67, 0x71, 0x01, 0xF9, 0x06, 0x77, 0x10, 0x1F, 0x90, 0x67, 0x71, 0x01, 0xF9, 0x06, 0x77, 0x10,
  0x2F, 0x90, 0x57, 0x71, 0x03, 0xF9, 0x04, 0x77, 0x10, 0x5F, 0x90, 0x37, 0x71, 0x09, 0xF9, 0x01,
  0x77, 0x01, 0x0E, 0xF0, 0xC7, 0x71, 0x0A, 0xF9, 0x83, 0x90, 0x64, 0x17, 0x20, 0x20, 0xBF, 0xA8,
  0x14, 0x0E, 0xA8, 0x7E, 0xCA, 0x97, 0x77, 0x9C, 0xFB, 0x0C, 0x20, 0xEF, 0xFF, 0x05, 0x20, 0xEF,
  0xFE, 0x0A, 0x30, 0xEF, 0xFD, 0x0D, 0x01, 0x30, 0xEF, 0xFC, 0x0C, 0x01, 0x40, 0xEF, 0xFA, 0x0E,
  0x07, 0x68, 0x16, 0xAD, 0xFC, 0x81, 0xEA, 0x57, 0x58, 0x90, 0x34, 0x67, 0x77, 0x76, 0x42, 0x74,
  // "K" (U+004B)
  0x04, 0xF9, 0x03, 0x75, 0x0D, 0xF9, 0x09, 0x04, 0xF9, 0x03, 0x74, 0x09, 0xF9, 0x81, 0xD0, 0x4F,
  0x90, 0x37, 0x30, 0x4F, 0xA8, 0x13, 0x04, 0xF9, 0x03, 0x73, 0x0D, 0xF9, 0x07, 0x20, 0x4F, 0x90,
  0x37, 0x20, 0x9F, 0x90, 0xB3, 0x04, 0xF9, 0x03, 0x71, 0x04, 0xF9, 0x0E, 0x01, 0x30, 0x4F, 0x90,
  0x37, 0x01, 0x0D, 0xF9, 0x04, 0x40, 0x4F, 0x90, 0x37, 0x0A, 0xF9, 0x09, 0x50, 0x4F, 0x90, 0x36,
  0x04, 0xF9, 0x0D, 0x60, 0x4F, 0x90, 0x35, 0x01, 0x0E, 0xF9, 0x03, 0x60, 0x4F, 0x90, 0x35, 0x0A,
  0xF9, 0x07, 0x70, 0x4F, 0x90, 0x34, 0x05, 0xF9, 0x0B, 0x71, 0x04, 0xF9, 0x03, 0x30, 0x10, 0xEF,
  0x0E, 0x01, 0x71, 0x04, 0xF9, 0x03, 0x30, 0xAF, 0x90, 0x47, 0x20, 0x4F, 0x90, 0x32, 0x05, 0xF9,
  0x09, 0x73, 0x04, 0xF9, 0x82, 0x30, 0x1E, 0xF0, 0xD7, 0x40, 0x4F, 0x98, 0x13, 0x09, 0xF9, 0x03,
  0x74, 0x04, 0xF9, 0x00, 0x3F, 0x90, 0x77, 0x50, 0x4F, 0x90, 0x30, 0xCF, 0x0B, 0x76, 0x04, 0xF9,
  0x08, 0xF9, 0x0C, 0x76, 0x04, 0xFF, 0xC0, 0x57, 0x50, 0x4F, 0xFC, 0x0D, 0x75, 0x04, 0xFF, 0xD0,
  0x77, 0x40, 0x4F, 0xFD, 0x0E, 0x01, 0x73, 0x04, 0xFF, 0xE0, 0x97, 0x30, 0x4F, 0xB8, 0x1E, 0x5D,
  0xF9, 0x03, 0x72, 0x04, 0xFA, 0x82, 0xE3, 0x05, 0xF9, 0x0B, 0x72, 0x04, 0xF9, 0x0D, 0x02, 0x30,
  0xCF, 0x90, 0x57, 0x10, 0x4F, 0x90, 0x34, 0x04, 0xF9, 0x0D, 0x71, 0x04, 0xF9, 0x03, 0x50, 0xBF,
  0x90, 0x77, 0x04, 0xF9, 0x03, 0x50, 0x3F, 0x90, 0xE0, 0x16, 0x04, 0xF9, 0x03, 0x60, 0xAF, 0x90,
  0x96, 0x04, 0xF9, 0x03, 0x60, 0x2F, 0xA0, 0x35, 0x04, 0xF9, 0x03, 0x70, 0x8F, 0x90, 0xB5, 0x04,
  0xF9, 0x03, 0x70, 0x10, 0xEF, 0x90, 0x54, 0x04, 0xF9, 0x03, 0x71, 0x07, 0xF9, 0x0D, 0x40, 0x4F,
  0x90, 0x37, 0x20, 0xDF, 0x90, 0x73, 0x04, 0xF9, 0x03, 0x72, 0x06, 0xF9, 0x0E, 0x01, 0x20, 0x4F,
  0x90, 0x37, 0x30, 0xCF, 0x90, 0x92, 0x04, 0xF9, 0x03, 0x73, 0x04, 0xFA, 0x81, 0x20, 0x4F, 0x90,
  0x37, 0x40, 0xBF, 0x98, 0x1B, 0x04, 0xF9, 0x03, 0x74, 0x03, 0xFA, 0x04,
  // "L" (U+004C)
  0x09, 0xF9, 0x01, 0x77, 0x30, 0x9F, 0x90, 0x17, 0x73, 0x09, 0xF9, 0x01, 0x77, 0x30, 0x9F, 0x90,
  0x17, 0x73, 0x09, 0xF9, 0x01, 0x77, 0x30, 0x9F, 0x90, 0x17, 0x73, 0x09, 0xF9, 0x01, 0x77, 0x30,
  0x9F, 0x90, 0x17, 0x73, 0x09, 0xF9, 0x01, 0x77, 0x30, 0x9F, 0x90, 0x17, 0x73, 0x09, 0xF9, 0x01,
  0x77, 0x30, 0x9F, 0x90, 0x17, 0x73, 0x09, 0xF9, 0x01, 0x77, 0x30, 0x9F, 0x90, 0x17, 0x73, 0x09,
  0xF9, 0x01, 0x77, 0x30, 0x9F, 0x90, 0x17, 0x73, 0x09, 0xF9, 0x01, 0x77, 0x30, 0x9F, 0x90, 0x17,
  0x73, 0x09, 0xF9, 0x01, 0x77, 0x30, 0x9F, 0x90, 0x17, 0x73, 0x09, 0xF9, 0x01, 0x77, 0x30, 0x9F,
  0x90, 0x17, 0x73, 0x09, 0xF9, 0x01, 0x77, 0x30, 0x9F, 0x90, 0x17, 0x73, 0x09, 0xF9, 0x01, 0x77,
  0x30, 0x9F, 0x90, 0x17, 0x73, 0x09, 0xF9, 0x01, 0x77, 0x30, 0x9F, 0x90, 0x17, 0x73, 0x09, 0xF9,
  0x01, 0x77, 0x30, 0x9F, 0x90, 0x17, 0x73, 0x09, 0xF9, 0x01, 0x77, 0x30, 0x9F, 0x90, 0x17, 0x73,
  0x09, 0xF9, 0x01, 0x77, 0x30, 0x9F, 0x90, 0x17, 0x73, 0x09, 0xFF, 0xFC, 0x0C, 0x09, 0xFF, 0xFC,
  0x0C, 0x09, 0xFF, 0xFC, 0x0C, 0x09, 0xFF, 0xFC, 0x0C, 0x09, 0xFF, 0xFC, 0x0C, 0x09, 0xFF, 0xFC,
  0x0C, 0x09, 0xFF, 0xFC, 0x0C, 0x09, 0xFF, 0xFC, 0x0C,
  // "M" (U+004D)
  0x09, 0xFC, 0x03, 0x70, 0xBF, 0xB0, 0x80, 0x9F, 0xC0, 0x57, 0x0D, 0xFB, 0x08, 0x09, 0xFC, 0x08,
  0x60, 0x1F, 0xC0, 0x80, 0x9F, 0xC0, 0xA6, 0x04, 0xFC, 0x08, 0x09, 0xFC, 0x0D, 0x60, 0x6F, 0xC0,
  0x80, 0x9F, 0xD6, 0x09, 0xFC, 0x08, 0x09, 0xFD, 0x02, 0x50, 0xCF, 0xC0, 0x80, 0x9D, 0x0E, 0xE0,
  0x45, 0xD0, 0xAE, 0x08, 0x09, 0xD0, 0xB0, 0xCD, 0x07, 0x40, 0x2D, 0x07, 0xE0, 0x80, 0x9D, 0x0D,
  0x09, 0xD0, 0x94, 0x05, 0xD0, 0x5E, 0x08, 0x09, 0xD0, 0xE0, 0x6D, 0x0B, 0x40, 0x8D, 0x04, 0xE0,
  0x80, 0x9E, 0x03, 0xD0, 0xE4, 0x0B, 0xC0, 0xD0, 0x4E, 0x08, 0x09, 0xE0, 0x1E, 0x01, 0x30, 0xDC,
  0x0A, 0x05, 0xE0, 0x80, 0x9E, 0x02, 0x0C, 0xD0, 0x32, 0x01, 0xD0, 0x80, 0x6E, 0x08, 0x09, 0xE0,
  0x30, 0x9D, 0x06, 0x20, 0x4D, 0x05, 0x07, 0xE0, 0x80, 0x9E, 0x05, 0x06, 0xD0, 0x82, 0x06, 0xD0,
  0x20, 0x8E, 0x08, 0x09, 0xE0, 0x60, 0x3D, 0x0A, 0x20, 0x9D, 0x10, 0x9E, 0x08, 0x09, 0xE0, 0x71,
  0xD0, 0xD2, 0x0C, 0xC8, 0x1C, 0x09, 0xE0, 0x80, 0x9E, 0x81, 0x80, 0xDD, 0x2D, 0x81, 0x90, 0xAE,
  0x08, 0x09, 0xE8, 0x19, 0x0A, 0xD0, 0x02, 0xD8, 0x17, 0x0B, 0xE0, 0x80, 0x9E, 0x81, 0xA0, 0x7D,
  0x04, 0x05, 0xD8, 0x14, 0x0C, 0xE0, 0x80, 0x9E, 0x81, 0xB0, 0x4D, 0x07, 0x08, 0xD8, 0x11, 0x0D,
  0xE0, 0x80, 0x9E, 0x81, 0xC0, 0x1D, 0x09, 0x0B, 0xC0, 0xE2, 0x0E, 0xE0, 0x80, 0x9E, 0x0D, 0x20,
  0xDC, 0x0C, 0x0E, 0xC0, 0xB2, 0xF0, 0x80, 0x9E, 0x0E, 0x20, 0xAF, 0xB0, 0x92, 0xF0, 0x80, 0x9F,
  0x20, 0x7F, 0xB8, 0x16, 0x01, 0xF0, 0x80, 0x9F, 0x20, 0x4F, 0xB8, 0x13, 0x01, 0xF0, 0x80, 0x9F,
  0x81, 0x10, 0x1F, 0xB2, 0x02, 0xF0, 0x80, 0x9F, 0x01, 0x20, 0xDF, 0x90, 0xD2, 0x03, 0xF0, 0x80,
  0x9F, 0x02, 0x20, 0xAF, 0x90, 0xA2, 0x03, 0xF0, 0x80, 0x9F, 0x02, 0x20, 0x7F, 0x90, 0x82, 0x03,
  0xF0, 0x80, 0x9F, 0x02, 0x20, 0x4F, 0x90, 0x52, 0x04, 0xF0, 0x80, 0x9F, 0x03, 0x77, 0x04, 0xF0,
  0x80, 0x9F, 0x03, 0x77, 0x04, 0xF0, 0x80, 0x9F, 0x03, 0x77, 0x04, 0xF0, 0x80, 0x9F, 0x03, 0x77,
  0x04, 0xF0, 0x80, 0x9F, 0x03, 0x77, 0x04, 0xF0, 0x80, 0x9F, 0x03, 0x77, 0x04, 0xF0, 0x80, 0x9F,
  0x03, 0x77, 0x04, 0xF0, 0x80, 0x9F, 0x03, 0x77, 0x04, 0xF0, 0x80, 0x9F, 0x03, 0x77, 0x04, 0xF0,
  0x80, 0x9F, 0x03, 0x77, 0x04, 0xF0, 0x80,
  // "N" (U+004E)
  0x04, 0xFC, 0x0A, 0x73, 0x06, 0xF0, 0x04, 0xFD, 0x73, 0x06, 0xF0, 0x04, 0xFD, 0x05, 0x72, 0x06,
  0xF0, 0x04, 0xFD, 0x0A, 0x72, 0x06, 0xF0, 0x04, 0xFE, 0x72, 0x06, 0xF0, 0x04, 0xFE, 0x05, 0x71,
  0x06, 0xF0, 0x04, 0xFE, 0x0A, 0x71, 0x06, 0xF0, 0x04, 0xFF, 0x71, 0x06, 0xF0, 0x04, 0xE0, 0xD0,
  0xCE, 0x05, 0x70, 0x6F, 0x00, 0x4E, 0x0E, 0x07, 0xE0, 0xA7, 0x06, 0xF0, 0x04, 0xF0, 0x2E, 0x0E,
  0x70, 0x6F, 0x00, 0x4F, 0x10, 0xCE, 0x05, 0x60, 0x6F, 0x00, 0x4F, 0x01, 0x07, 0xE0, 0xA6, 0x06,
  0xF0, 0x04, 0xF0, 0x20, 0x1E, 0x0E, 0x60, 0x6F, 0x00, 0x4F, 0x81, 0x30, 0xCE, 0x05, 0x50, 0x6F,
  0x00, 0x4F, 0x81, 0x40, 0x7E, 0x0A, 0x50, 0x6F, 0x00, 0x4F, 0x81, 0x40, 0x1E, 0x0E, 0x50, 0x6F,
  0x00, 0x4F, 0x05, 0x20, 0xCE, 0x05, 0x40, 0x6F, 0x00, 0x4F, 0x05, 0x20, 0x7E, 0x0A, 0x40, 0x6F,
  0x00, 0x4F, 0x06, 0x20, 0x2E, 0x0E, 0x40, 0x6F, 0x00, 0x4F, 0x06, 0x30, 0xCE, 0x05, 0x30, 0x6F,
  0x00, 0x4F, 0x06, 0x30, 0x7E, 0x0A, 0x30, 0x6F, 0x00, 0x4F, 0x06, 0x30, 0x2E, 0x0E, 0x30, 0x6F,
  0x00, 0x4F, 0x06, 0x40, 0xCE, 0x05, 0x20, 0x6F, 0x00, 0x4F, 0x06, 0x40, 0x7E, 0x0A, 0x20, 0x6F,
  0x00, 0x4F, 0x06, 0x40, 0x2E, 0x0E, 0x20, 0x5F, 0x00, 0x4F, 0x06, 0x50, 0xCE, 0x81, 0x50, 0x5F,
  0x00, 0x4F, 0x06, 0x50, 0x7E, 0x81, 0xA0, 0x4F, 0x00, 0x4F, 0x06, 0x50, 0x2E, 0x81, 0xE0, 0x4F,
  0x00, 0x4F, 0x06, 0x60, 0xCE, 0x05, 0x03, 0xF0, 0x04, 0xF0, 0x66, 0x07, 0xE0, 0xA0, 0x3F, 0x00,
  0x4F, 0x06, 0x60, 0x2E, 0x0E, 0x02, 0xF0, 0x04, 0xF0, 0x67, 0x0C, 0xE0, 0x6F, 0x00, 0x4F, 0x06,
  0x70, 0x7E, 0x0B, 0xF0, 0x04, 0xF0, 0x67, 0x02, 0xFF, 0x00, 0x4F, 0x06, 0x71, 0x0C, 0xFE, 0x00,
  0x4F, 0x06, 0x71, 0x07, 0xFE, 0x00, 0x4F, 0x06, 0x71, 0x02, 0xFE, 0x00, 0x4F, 0x06, 0x72, 0x0C,
  0xFD, 0x00, 0x4F, 0x06, 0x72, 0x07, 0xFD, 0x00, 0x4F, 0x06, 0x72, 0x02, 0xFD, 0x00, 0x4F, 0x06,
  0x73, 0x0C, 0xFC, 0x04,
  // "O" (U+004F)
  0x76, 0x86, 0x35, 0x67, 0x76, 0x53, 0x77, 0x72, 0x81, 0x5B, 0xEF, 0x98, 0x1E, 0xB5, 0x77, 0x40,
  0x60, 0xDF, 0xF0, 0xE0, 0x67, 0x71, 0x0A, 0xFF, 0xC0, 0xA0, 0x17, 0x40, 0x10, 0xCF, 0xFE, 0x0C,
  0x01, 0x73, 0x0B, 0xFF, 0xF9, 0x0B, 0x72, 0x07, 0xFF, 0xFB, 0x07, 0x70, 0x2F, 0xB8, 0x4E, 0xA8,
  0x8A, 0xEF, 0xA0, 0xE0, 0x16, 0x09, 0xFA, 0x08, 0x60, 0x8F, 0xA0, 0x95, 0x01, 0xFA, 0x07, 0x71,
  0x06, 0xFA, 0x01, 0x40, 0x7F, 0x90, 0xB7, 0x30, 0xBF, 0x90, 0x64, 0x0C, 0xF9, 0x03, 0x73, 0x03,
  0xF9, 0x0C, 0x30, 0x1F, 0x90, 0xD7, 0x50, 0xDF, 0x90, 0x12, 0x05, 0xF9, 0x08, 0x75, 0x08, 0xF9,
  0x05, 0x20, 0x8F, 0x90, 0x57, 0x50, 0x4F, 0x90, 0x82, 0x0B, 0xF9, 0x01, 0x75, 0x01, 0xF9, 0x0B,
  0x20, 0xDF, 0x97, 0x7F, 0x90, 0xD2, 0xF9, 0x0D, 0x77, 0x0D, 0xF9, 0x10, 0x1F, 0x90, 0xB7, 0x70,
  0xBF, 0x91, 0x02, 0xF9, 0x0A, 0x77, 0x0B, 0xF9, 0x00, 0x2F, 0x90, 0xA7, 0x70, 0xAF, 0x90, 0x20,
  0x3F, 0x90, 0x97, 0x70, 0x9F, 0x90, 0x20, 0x3F, 0x90, 0x97, 0x70, 0xAF, 0x90, 0x02, 0xF9, 0x0A,
  0x77, 0x0A, 0xF9, 0x00, 0x2F, 0x90, 0xA7, 0x70, 0xBF, 0x90, 0x20, 0x1F, 0x90, 0xB7, 0x70, 0xBF,
  0x92, 0xF9, 0x0D, 0x77, 0x0D, 0xF9, 0x20, 0xDF, 0x0E, 0x77, 0xF9, 0x0D, 0x20, 0xBF, 0x90, 0x17,
  0x50, 0x1F, 0x90, 0xB2, 0x08, 0xF9, 0x04, 0x75, 0x05, 0xF9, 0x08, 0x20, 0x5F, 0x90, 0x87, 0x50,
  0x8F, 0x90, 0x52, 0x01, 0xF9, 0x0D, 0x75, 0x0D, 0xF9, 0x01, 0x30, 0xCF, 0x90, 0x37, 0x30, 0x3F,
  0x90, 0xC4, 0x07, 0xF9, 0x0B, 0x73, 0x0B, 0xF9, 0x07, 0x40, 0x1F, 0xA0, 0x67, 0x10, 0x6F, 0xA0,
  0x15, 0x09, 0xFA, 0x08, 0x60, 0x8F, 0xA0, 0x96, 0x02, 0xFB, 0x84, 0xE9, 0x77, 0x9E, 0xFB, 0x01,
  0x70, 0x7F, 0xFF, 0xB0, 0x77, 0x20, 0xBF, 0xFF, 0x90, 0xB7, 0x30, 0x10, 0xCF, 0xFE, 0x0C, 0x01,
  0x74, 0x01, 0x0B, 0xFF, 0xC0, 0xB0, 0x17, 0x70, 0x60, 0xEF, 0xF0, 0xE0, 0x67, 0x74, 0x05, 0x0B,
  0xFB, 0x0B, 0x05, 0x77, 0x72, 0x86, 0x35, 0x67, 0x76, 0x53, 0x76,
  // "P" (U+0050)
  0x03, 0xFF, 0x98, 0x4E, 0xDB, 0x85, 0x17, 0x10, 0x3F, 0xFF, 0x0B, 0x04, 0x60, 0x3F, 0xFF, 0xA0,
  0xA0, 0x14, 0x03, 0xFF, 0xFB, 0x0D, 0x02, 0x30, 0x3F, 0xFF, 0xC0, 0xD0, 0x12, 0x03, 0xFF, 0xFD,
  0x0A, 0x20, 0x3F, 0x98, 0x02, 0xEF, 0xE8, 0x13, 0x03, 0xF9, 0x03, 0x68, 0x11, 0x5C, 0xFA, 0x81,
  0xA0, 0x3F, 0x90, 0x37, 0x20, 0x9F, 0x98, 0x1E, 0x03, 0xF9, 0x03, 0x73, 0x0D, 0xF9, 0x00, 0x3F,
  0x90, 0x37, 0x30, 0x7F, 0x90, 0x60, 0x3F, 0x90, 0x37, 0x30, 0x3F, 0x90, 0x70, 0x3F, 0x90, 0x37,
  0x30, 0x1F, 0x90, 0x80, 0x3F, 0x90, 0x37, 0x30, 0x1F, 0x90, 0x80, 0x3F, 0x90, 0x37, 0x30, 0x2F,
  0x90, 0x80, 0x3F, 0x90, 0x37, 0x30, 0x5F, 0x90, 0x60, 0x3F, 0x90, 0x37, 0x30, 0xAF, 0x90, 0x40,
  0x3F, 0x90, 0x37, 0x20, 0x4F, 0xA0, 0x10, 0x3F, 0x90, 0x37, 0x10, 0x40, 0xEF, 0x98, 0x1B, 0x03,
  0xF9, 0x03, 0x58, 0x12, 0x5B, 0xFB, 0x81, 0x60, 0x3F, 0xFF, 0xD0, 0xD2, 0x03, 0xFF, 0xFD, 0x05,
  0x20, 0x3F, 0xFF, 0xC0, 0x93, 0x03, 0xFF, 0xFB, 0x09, 0x40, 0x3F, 0xFF, 0x90, 0xE0, 0x65, 0x03,
  0xFF, 0xE8, 0x1E, 0x71, 0x60, 0x3F, 0x98, 0x03, 0xE8, 0x3D, 0xC9, 0x73, 0x72, 0x03, 0xF9, 0x03,
  0x77, 0x60, 0x3F, 0x90, 0x37, 0x76, 0x03, 0xF9, 0x03, 0x77, 0x60, 0x3F, 0x90, 0x37, 0x76, 0x03,
  0xF9, 0x03, 0x77, 0x60, 0x3F, 0x90, 0x37, 0x76, 0x03, 0xF9, 0x03, 0x77, 0x60, 0x3F, 0x90, 0x37,
  0x76, 0x03, 0xF9, 0x03, 0x77, 0x60, 0x3F, 0x90, 0x37, 0x76, 0x03, 0xF9, 0x03, 0x77, 0x60, 0x3F,
  0x90, 0x37, 0x76, 0x03, 0xF9, 0x03, 0x77, 0x60, 0x3F, 0x90, 0x37, 0x76, 0x03, 0xF9, 0x03, 0x77,
  0x60,
  // "Q" (U+0051)
  0x76, 0x86, 0x35, 0x67, 0x76, 0x53, 0x77, 0x72, 0x81, 0x5B, 0xEF, 0x98, 0x1E, 0xB5, 0x77, 0x40,
  0x60, 0xDF, 0xF0, 0xD0, 0x67, 0x71, 0x0A, 0xFF, 0xC0, 0xA7, 0x50, 0x10, 0xCF, 0xFE, 0x0C, 0x01,
  0x73, 0x0B, 0xFF, 0xF9, 0x0B, 0x72, 0x07, 0xFF, 0xFB, 0x07, 0x70, 0x2F, 0xB8, 0x4E, 0xA8, 0x8A,
  0xEF, 0xA0, 0xE0, 0x16, 0x09, 0xFA, 0x08, 0x60, 0x8F, 0xA0, 0x95, 0x01, 0xFA, 0x07, 0x71, 0x06,
  0xFA, 0x01, 0x40, 0x7F, 0x90, 0xB7, 0x30, 0xBF, 0x90, 0x64, 0x0C, 0xF9, 0x03, 0x73, 0x03, 0xF9,
  0x0C, 0x30, 0x1F, 0x90, 0xD7, 0x50, 0xDF, 0x90, 0x12, 0x05, 0xF9, 0x08, 0x75, 0x08, 0xF9, 0x04,
  0x20, 0x8F, 0x90, 0x57, 0x50, 0x4F, 0x90, 0x82, 0x0B, 0xF9, 0x01, 0x75, 0x01, 0xF9, 0x0B, 0x20,
  0xDF, 0x97, 0x7F, 0x90, 0xD2, 0xF9, 0x0D, 0x77, 0x0D, 0xF9, 0x10, 0x1F, 0x90, 0xB7, 0x70, 0xBF,
  0x91, 0x02, 0xF9, 0x0A, 0x77, 0x0B, 0xF9, 0x01, 0x02, 0xF9, 0x0A, 0x77, 0x0A, 0xF9, 0x02, 0x03,
  0xF9, 0x09, 0x77, 0x09, 0xF9, 0x02, 0x03, 0xF9, 0x09, 0x77, 0x0A, 0xF9, 0x00, 0x2F, 0x90, 0xA7,
  0x70, 0xAF, 0x90, 0x02, 0xF9, 0x0A, 0x77, 0x0B, 0xF9, 0x00, 0x1F, 0x90, 0xB7, 0x70, 0xBF, 0x90,
  0x11, 0xF9, 0x0D, 0x77, 0x0D, 0xF9, 0x20, 0xDF, 0x0E, 0x77, 0xF9, 0x0D, 0x20, 0xBF, 0x90, 0x17,
  0x50, 0x1F, 0x90, 0xB2, 0x08, 0xF9, 0x04, 0x75, 0x05, 0xF9, 0x08, 0x20, 0x5F, 0x90, 0x87, 0x50,
  0x8F, 0x90, 0x52, 0x01, 0xF9, 0x0D, 0x75, 0x0D, 0xF9, 0x02, 0x30, 0xCF, 0x90, 0x37, 0x30, 0x3F,
  0x90, 0xD4, 0x07, 0xF9, 0x0B, 0x73, 0x0B, 0xF9, 0x08, 0x40, 0x1F, 0xA0, 0x67, 0x10, 0x6F, 0xA0,
  0x25, 0x09, 0xFA, 0x08, 0x60, 0x8F, 0xA0, 0xB6, 0x02, 0xFB, 0x84, 0xE9, 0x77, 0x9E, 0xFB, 0x03,
  0x70, 0x7F, 0xFF, 0xB0, 0x97, 0x20, 0xBF, 0xFF, 0x90, 0xD7, 0x30, 0x10, 0xCF, 0xFE, 0x0D, 0x01,
  0x74, 0x01, 0x0B, 0xFF, 0xC0, 0xC0, 0x17, 0x70, 0x60, 0xEF, 0xF9, 0x0A, 0x77, 0x40, 0x50, 0xBF,
  0xE0, 0xD7, 0x77, 0x83, 0x35, 0x67, 0x8F, 0x90, 0x77, 0x77, 0x40, 0xBF, 0x0E, 0x01, 0x77, 0x73,
  0x04, 0xF9, 0x09, 0x77, 0x74, 0x0B, 0xF9, 0x02, 0x77, 0x73, 0x03, 0xF9, 0x0B, 0x77, 0x74, 0x0B,
  0xF9, 0x04, 0x77, 0x73, 0x03, 0xF9, 0x0C, 0x77, 0x74, 0x0B, 0xF9, 0x06, 0x77, 0x73, 0x03, 0xF9,
  0x0D, 0x77, 0x74, 0x0A, 0xF9, 0x07, 0x77, 0x73, 0x02, 0x80, 0x47, 0x06, 0x20,
  // "R" (U+0052)
  0x03, 0xFD, 0x84, 0xED, 0xCA, 0x73, 0x75, 0x03, 0xFF, 0xC8, 0x1E, 0x82, 0x72, 0x03, 0xFF, 0xF0,
  0x87, 0x10, 0x3F, 0xFF, 0x90, 0xD0, 0x16, 0x03, 0xFF, 0xFA, 0x0D, 0x01, 0x50, 0x3F, 0xFF, 0xB0,
  0xC5, 0x03, 0xFA, 0x00, 0xEF, 0xF0, 0x54, 0x03, 0xF9, 0x07, 0x48, 0x13, 0x6C, 0xFA, 0x0D, 0x40,
  0x3F, 0x90, 0x77, 0x07, 0xFA, 0x03, 0x30, 0x3F, 0x90, 0x77, 0x10, 0x9F, 0x90, 0x73, 0x03, 0xF9,
  0x07, 0x71, 0x03, 0xF9, 0x0A, 0x30, 0x3F, 0x90, 0x77, 0x2F, 0x90, 0xB3, 0x03, 0xF9, 0x07, 0x72,
  0x0E, 0xF0, 0xD3, 0x03, 0xF9, 0x07, 0x72, 0xF9, 0x0C, 0x30, 0x3F, 0x90, 0x77, 0x10, 0x1F, 0x90,
  0xB3, 0x03, 0xF9, 0x07, 0x71, 0x06, 0xF9, 0x08, 0x30, 0x3F, 0x90, 0x77, 0x10, 0xDF, 0x90, 0x53,
  0x03, 0xF9, 0x07, 0x60, 0x10, 0xBF, 0x90, 0xE4, 0x03, 0xF9, 0x07, 0x38, 0x21, 0x38, 0xEF, 0xA0,
  0x94, 0x03, 0xFF, 0xFB, 0x0E, 0x01, 0x40, 0x3F, 0xFF, 0xB0, 0x45, 0x03, 0xFF, 0xFA, 0x05, 0x60,
  0x3F, 0xFF, 0x0E, 0x04, 0x70, 0x3F, 0xFE, 0x09, 0x01, 0x71, 0x03, 0xFF, 0xD0, 0xC7, 0x30, 0x3F,
  0xA0, 0xFE, 0xF9, 0x06, 0x72, 0x03, 0xF9, 0x07, 0x30, 0xBF, 0x0E, 0x01, 0x71, 0x03, 0xF9, 0x07,
  0x30, 0x3F, 0x90, 0x97, 0x10, 0x3F, 0x90, 0x74, 0x0A, 0xF9, 0x02, 0x70, 0x3F, 0x90, 0x74, 0x02,
  0xF9, 0x0B, 0x70, 0x3F, 0x90, 0x75, 0x08, 0xF9, 0x05, 0x60, 0x3F, 0x90, 0x75, 0x01, 0x0E, 0xF0,
  0xD6, 0x03, 0xF9, 0x07, 0x60, 0x6F, 0x90, 0x85, 0x03, 0xF9, 0x07, 0x70, 0xDF, 0x90, 0x24, 0x03,
  0xF9, 0x07, 0x70, 0x5F, 0x90, 0xA4, 0x03, 0xF9, 0x07, 0x71, 0x0B, 0xF9, 0x04, 0x30, 0x3F, 0x90,
  0x77, 0x10, 0x3F, 0x90, 0xD3, 0x03, 0xF9, 0x07, 0x72, 0x0A, 0xF9, 0x07, 0x20, 0x3F, 0x90, 0x77,
  0x20, 0x1F, 0x98, 0x2E, 0x10, 0x3F, 0x90, 0x77, 0x30, 0x8F, 0x98, 0x19, 0x03, 0xF9, 0x07, 0x74,
  0x0E, 0xF9, 0x00, 0x3F, 0x90, 0x77, 0x40, 0x6F, 0x90, 0xC0,
  // "S" (U+0053)
  0x74, 0x87, 0x35, 0x67, 0x76, 0x54, 0x27, 0x72, 0x81, 0x27, 0xCF, 0xC8, 0x2D, 0xA6, 0x27, 0x20,
  0x10, 0xAF, 0xFC, 0x0C, 0x06, 0x60, 0x50, 0xEF, 0xFF, 0x0B, 0x40, 0x6F, 0xFF, 0xA0, 0x63, 0x03,
  0xFF, 0xFA, 0x0E, 0x40, 0xCF, 0xFF, 0xA0, 0x83, 0x03, 0xFB, 0x86, 0xEA, 0x77, 0x89, 0xCE, 0xE0,
  0x23, 0x08, 0xFA, 0x07, 0x71, 0x81, 0x38, 0xDA, 0x0B, 0x40, 0xBF, 0x90, 0x87, 0x58, 0x14, 0xA5,
  0x40, 0xDF, 0x90, 0x27, 0x75, 0x0E, 0xF0, 0xE7, 0x76, 0x0E, 0xF9, 0x77, 0x60, 0xCF, 0x90, 0x27,
  0x75, 0x0A, 0xF9, 0x0A, 0x77, 0x50, 0x5F, 0xA0, 0x87, 0x75, 0x0E, 0xFA, 0x0C, 0x03, 0x77, 0x30,
  0x7F, 0xC0, 0xB0, 0x37, 0x72, 0x0B, 0xFD, 0x0B, 0x03, 0x77, 0x01, 0x0D, 0xFE, 0x0B, 0x03, 0x76,
  0x01, 0x0C, 0xFF, 0x0A, 0x02, 0x76, 0x0A, 0xFF, 0x90, 0x87, 0x60, 0x50, 0xEF, 0xF0, 0xD0, 0x37,
  0x50, 0x10, 0x9F, 0xF9, 0x05, 0x76, 0x02, 0x0B, 0xFF, 0x05, 0x77, 0x03, 0x0B, 0xFE, 0x02, 0x77,
  0x10, 0x30, 0xBF, 0xC0, 0xB7, 0x73, 0x04, 0x0C, 0xFB, 0x02, 0x77, 0x40, 0xAF, 0xA0, 0x67, 0x75,
  0x0B, 0xF9, 0x09, 0x77, 0x50, 0x5F, 0x90, 0xA7, 0x75, 0x03, 0xF9, 0x0A, 0x77, 0x50, 0x4F, 0x98,
  0x19, 0x62, 0x77, 0x30, 0x7F, 0x98, 0x37, 0xCF, 0xA4, 0x77, 0x01, 0x0E, 0xF9, 0x04, 0x0C, 0xB8,
  0x2E, 0x94, 0x17, 0x20, 0x50, 0xDF, 0x98, 0x1E, 0x0C, 0xF8, 0x7D, 0xA9, 0x87, 0x78, 0xBE, 0xFB,
  0x81, 0x80, 0xCF, 0xFF, 0xC8, 0x2E, 0x10, 0xCF, 0xFF, 0xC0, 0x42, 0x0C, 0xFF, 0xFB, 0x05, 0x30,
  0xCF, 0xFF, 0x90, 0xD0, 0x34, 0x81, 0x28, 0xEF, 0xFC, 0x0D, 0x07, 0x72, 0x82, 0x37, 0xBE, 0xFC,
  0x81, 0xD9, 0x47, 0x71, 0x89, 0x11, 0x35, 0x67, 0x77, 0x65, 0x31, 0x74,
  // "T" (U+0054)
  0x03, 0xFF, 0xFF, 0xC0, 0x03, 0xFF, 0xFF, 0xC0, 0x03, 0xFF, 0xFF, 0xC0, 0x03, 0xFF, 0xFF, 0xC0,
  0x03, 0xFF, 0xFF, 0xC0, 0x03, 0xFF, 0xFF, 0xC0, 0x03, 0x80, 0x7E, 0xFB, 0x80, 0x7E, 0x03, 0x75,
  0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05,
  0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9,
  0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04,
  0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77,
  0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73,
  0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05,
  0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9,
  0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04,
  0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77,
  0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73,
  0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x75,
  // "U" (U+0055)
  0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06,
  0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9,
  0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90,
  0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F,
  0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9,
  0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06,
  0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F,
  0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50,
  0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04,
  0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75,
  0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00,
  0x4F, 0x90, 0x67, 0x50, 0x7F, 0x90, 0x40, 0x3F, 0x90, 0x77, 0x50, 0x7F, 0x90, 0x30, 0x2F, 0x90,
  0x97, 0x50, 0x9F, 0x90, 0x20, 0x1F, 0x90, 0xC7, 0x50, 0xCF, 0x98, 0x11, 0x0E, 0xF9, 0x01, 0x73,
  0x01, 0xF9, 0x0D, 0x20, 0xAF, 0x90, 0x67, 0x30, 0x6F, 0x90, 0x92, 0x06, 0xF9, 0x0E, 0x02, 0x71,
  0x01, 0x0E, 0xF9, 0x06, 0x20, 0x1F, 0xA0, 0xD0, 0x46, 0x03, 0x0D, 0xF9, 0x0E, 0x40, 0x9F, 0xB8,
  0x4D, 0x97, 0x79, 0xCF, 0xB0, 0x74, 0x02, 0x0E, 0xFF, 0xFB, 0x0D, 0x01, 0x50, 0x5F, 0xFF, 0xB0,
  0x37, 0x07, 0xFF, 0xF9, 0x06, 0x72, 0x05, 0x0E, 0xFF, 0xC0, 0xE0, 0x47, 0x40, 0x20, 0xAF, 0xFA,
  0x09, 0x01, 0x77, 0x81, 0x28, 0xCF, 0xB8, 0x1C, 0x81, 0x77, 0x68, 0x63, 0x56, 0x77, 0x65, 0x37,
  0x50,
  // "V" (U+0056)
  0x04, 0xF9, 0x07, 0x77, 0x20, 0x9F, 0x98, 0x13, 0x0E, 0xF0, 0xB7, 0x72, 0x0D, 0xF0, 0xE2, 0x0A,
  0xF9, 0x77, 0x10, 0x1F, 0x90, 0xA2, 0x05, 0xF9, 0x04, 0x77, 0x05, 0xF9, 0x05, 0x20, 0x1F, 0x90,
  0x87, 0x70, 0x9F, 0x90, 0x13, 0x0B, 0xF0, 0xC7, 0x70, 0xDF, 0x0B, 0x40, 0x7F, 0x90, 0x17, 0x50,
  0x2F, 0x90, 0x74, 0x02, 0xF9, 0x05, 0x75, 0x06, 0xF9, 0x02, 0x50, 0xDF, 0x09, 0x75, 0x0A, 0xF0,
  0xD6, 0x08, 0xF0, 0xD7, 0x50, 0xEF, 0x08, 0x60, 0x4F, 0x90, 0x27, 0x30, 0x2F, 0x90, 0x47, 0x0E,
  0xF0, 0x67, 0x30, 0x6F, 0x0E, 0x71, 0x0A, 0xF0, 0xA7, 0x30, 0xAF, 0x0A, 0x71, 0x05, 0xF0, 0xE7,
  0x30, 0xEF, 0x05, 0x71, 0x01, 0xF9, 0x03, 0x71, 0x02, 0xF9, 0x01, 0x72, 0x0C, 0xF0, 0x77, 0x10,
  0x6F, 0x0C, 0x73, 0x07, 0xF0, 0xB7, 0x10, 0xAF, 0x07, 0x73, 0x02, 0xF9, 0x71, 0x0E, 0xF0, 0x27,
  0x40, 0xDF, 0x04, 0x60, 0x3F, 0x0D, 0x75, 0x09, 0xF0, 0x86, 0x07, 0xF0, 0x97, 0x50, 0x4F, 0x0C,
  0x60, 0xBF, 0x04, 0x76, 0x0E, 0xF0, 0x15, 0x0E, 0xE0, 0xE7, 0x70, 0xAF, 0x05, 0x40, 0x3F, 0x0A,
  0x77, 0x06, 0xF0, 0x94, 0x07, 0xF0, 0x57, 0x70, 0x1F, 0x0D, 0x40, 0xBF, 0x01, 0x77, 0x10, 0xCF,
  0x02, 0x30, 0xEE, 0x0C, 0x77, 0x20, 0x7F, 0x06, 0x20, 0x2F, 0x07, 0x77, 0x20, 0x3F, 0x09, 0x20,
  0x5F, 0x02, 0x77, 0x30, 0xDE, 0x0C, 0x20, 0x9E, 0x0D, 0x77, 0x40, 0x9F, 0x20, 0xCE, 0x09, 0x77,
  0x40, 0x4F, 0x03, 0x1F, 0x04, 0x77, 0x50, 0xEE, 0x07, 0x02, 0xE0, 0xE7, 0x76, 0x0A, 0xE0, 0x90,
  0x5E, 0x0A, 0x77, 0x60, 0x6E, 0x0C, 0x07, 0xE0, 0x67, 0x76, 0x01, 0xFF, 0x01, 0x77, 0x70, 0xCF,
  0xD0, 0xC7, 0x77, 0x10, 0x7F, 0xD0, 0x77, 0x77, 0x10, 0x3F, 0xD0, 0x37, 0x77, 0x20, 0xDF, 0xB0,
  0xD7, 0x77, 0x30, 0x9F, 0xB0, 0x97, 0x77, 0x30, 0x4F, 0xB0, 0x47, 0x77, 0x4F, 0xB7, 0x60,
  // "W" (U+0057)
  0x05, 0xF0, 0x37, 0x74, 0x03, 0xF0, 0x50, 0x4F, 0x04, 0x77, 0x40, 0x4F, 0x04, 0x03, 0xF0, 0x67,
  0x74, 0x05, 0xF0, 0x30, 0x2F, 0x07, 0x77, 0x40, 0x6F, 0x02, 0x01, 0xF0, 0x97, 0x74, 0x07, 0xF0,
  0x11, 0xF0, 0xA7, 0x74, 0x08, 0xF2, 0x0E, 0xE0, 0xC7, 0x74, 0x0A, 0xE0, 0xE2, 0x0D, 0xE0, 0xD7,
  0x74, 0x0B, 0xE0, 0xD2, 0x0B, 0xF7, 0x74, 0x0C, 0xE0, 0xC2, 0x0A, 0xF0, 0x17, 0x73, 0x0D, 0xE0,
  0xB2, 0x09, 0xF0, 0x23, 0x02, 0xF9, 0x04, 0x40, 0xEE, 0x0A, 0x20, 0x8F, 0x03, 0x30, 0x4F, 0x90,
  0x64, 0xF0, 0x92, 0x07, 0xF0, 0x53, 0x07, 0xF9, 0x09, 0x30, 0x1F, 0x07, 0x20, 0x5F, 0x06, 0x30,
  0x9F, 0x90, 0xB3, 0x02, 0xF0, 0x62, 0x04, 0xF0, 0x73, 0x0C, 0xF9, 0x0D, 0x30, 0x3F, 0x05, 0x20,
  0x3F, 0x08, 0x30, 0xEF, 0xA3, 0x04, 0xF0, 0x42, 0x02, 0xF0, 0x92, 0x01, 0xFB, 0x03, 0x20, 0x5F,
  0x03, 0x20, 0x1F, 0x0A, 0x20, 0x4F, 0xB0, 0x52, 0x06, 0xF0, 0x23, 0xF0, 0xB2, 0x06, 0xD0, 0xEC,
  0x07, 0x20, 0x7F, 0x01, 0x30, 0xEE, 0x0B, 0x20, 0x9C, 0x0C, 0x0A, 0xC0, 0xA2, 0x08, 0xF4, 0x0D,
  0xE0, 0xC2, 0x0B, 0xC0, 0xA0, 0x8C, 0x0C, 0x20, 0x9E, 0x0E, 0x40, 0xCE, 0x0D, 0x20, 0xEC, 0x08,
  0x06, 0xC0, 0xE2, 0x0A, 0xE0, 0xD4, 0x0A, 0xE8, 0x1D, 0x01, 0xD0, 0x60, 0x4D, 0x81, 0x10, 0xAE,
  0x0C, 0x40, 0x9E, 0x81, 0xD0, 0x3D, 0x04, 0x02, 0xD8, 0x14, 0x0B, 0xE0, 0xB4, 0x08, 0xE8, 0x1D,
  0x05, 0xD0, 0x21, 0xD8, 0x16, 0x0B, 0xE0, 0xA4, 0x07, 0xE8, 0x1D, 0x07, 0xD2, 0x0D, 0xC8, 0x19,
  0x0B, 0xE0, 0x94, 0x06, 0xE8, 0x1E, 0x0A, 0xC0, 0xC2, 0x0B, 0xC8, 0x1B, 0x0A, 0xE0, 0x74, 0x05,
  0xE8, 0x1E, 0x0C, 0xC0, 0xA2, 0x09, 0xC8, 0x1E, 0x0A, 0xE0, 0x64, 0x03, 0xE8, 0x1E, 0x0E, 0xC0,
  0x72, 0x07, 0xD0, 0x10, 0xAE, 0x05, 0x40, 0x2E, 0x0E, 0x01, 0xD0, 0x52, 0x04, 0xD0, 0x40, 0x9E,
  0x04, 0x40, 0x1E, 0x0E, 0x03, 0xD0, 0x32, 0x02, 0xD0, 0x60, 0x9E, 0x03, 0x5E, 0x0D, 0x05, 0xD4,
  0xD0, 0x90, 0x8E, 0x02, 0x50, 0xED, 0x0D, 0x07, 0xC0, 0xD4, 0x0D, 0xC0, 0xB0, 0x8E, 0x01, 0x50,
  0xDD, 0x0D, 0x09, 0xC0, 0xB4, 0x0A, 0xC0, 0xE0, 0x7E, 0x60, 0xCD, 0x0C, 0x0B, 0xC0, 0x94, 0x08,
  0xD0, 0x8D, 0x0E, 0x60, 0xBF, 0xC0, 0x64, 0x06, 0xFC, 0x0D, 0x60, 0x9F, 0xC0, 0x44, 0x03, 0xFC,
  0x0C, 0x60, 0x8F, 0xC0, 0x24, 0x01, 0xFC, 0x0B, 0x60, 0x7F, 0xC6, 0x0E, 0xFB, 0x0A, 0x60, 0x6F,
  0xB0, 0xC6, 0x0C, 0xFB, 0x09, 0x60, 0x5F, 0xB0, 0xA6, 0x09, 0xFB, 0x07, 0x60, 0x4F, 0xB0, 0x86,
  0x07, 0xFB, 0x06, 0x30,
  // "X" (U+0058)
  0x10, 0xAF, 0x90, 0x27, 0x50, 0x4F, 0x90, 0xA2, 0x01, 0x0E, 0xF0, 0xB7, 0x50, 0xCF, 0x0E, 0x01,
  0x30, 0x7F, 0x90, 0x37, 0x30, 0x5F, 0x90, 0x75, 0x0D, 0xF0, 0xB7, 0x30, 0xDF, 0x0D, 0x60, 0x5F,
  0x90, 0x47, 0x10, 0x5F, 0x90, 0x47, 0x0B, 0xF0, 0xC7, 0x10, 0xDF, 0x0B, 0x71, 0x02, 0xF9, 0x05,
  0x60, 0x6F, 0x90, 0x27, 0x20, 0x8F, 0x0D, 0x60, 0xDF, 0x08, 0x73, 0x01, 0x0E, 0xF0, 0x64, 0x07,
  0xF0, 0xE7, 0x50, 0x6F, 0x0D, 0x40, 0xEF, 0x05, 0x76, 0x0C, 0xF0, 0x72, 0x07, 0xF0, 0xC7, 0x70,
  0x3F, 0x82, 0xE0, 0x1E, 0xF0, 0x37, 0x71, 0x09, 0xF0, 0x70, 0x8F, 0x09, 0x77, 0x20, 0x10, 0xEE,
  0x00, 0xEE, 0x0E, 0x01, 0x77, 0x30, 0x7F, 0xF0, 0x67, 0x75, 0x0D, 0xFD, 0x0C, 0x77, 0x60, 0x4F,
  0xD0, 0x47, 0x77, 0x0B, 0xFB, 0x0A, 0x77, 0x71, 0x02, 0xFB, 0x01, 0x77, 0x72, 0x08, 0xF9, 0x07,
  0x77, 0x73, 0x01, 0xF9, 0x01, 0x77, 0x73, 0x08, 0xF9, 0x09, 0x77, 0x72, 0x02, 0xFB, 0x03, 0x77,
  0x71, 0x0B, 0xFB, 0x0B, 0x77, 0x70, 0x5F, 0xD0, 0x57, 0x76, 0x0D, 0xFD, 0x0E, 0x77, 0x50, 0x8F,
  0xF0, 0x87, 0x73, 0x02, 0xF0, 0xEF, 0x90, 0x27, 0x72, 0x0B, 0xF0, 0x60, 0x8F, 0x0B, 0x77, 0x10,
  0x5F, 0x82, 0xD0, 0x1E, 0xF0, 0x57, 0x70, 0xDF, 0x04, 0x20, 0x7F, 0x0D, 0x76, 0x08, 0xF0, 0xC4,
  0x0E, 0xF0, 0x87, 0x40, 0x2F, 0x90, 0x34, 0x06, 0xF9, 0x02, 0x73, 0x0B, 0xF0, 0xA6, 0x0D, 0xF0,
  0xB7, 0x20, 0x4F, 0x90, 0x26, 0x05, 0xF9, 0x05, 0x71, 0x0D, 0xF0, 0x97, 0x10, 0xCF, 0x0D, 0x70,
  0x7F, 0x0E, 0x01, 0x71, 0x04, 0xF9, 0x08, 0x50, 0x2F, 0x90, 0x87, 0x30, 0xBF, 0x90, 0x24, 0x0B,
  0xF0, 0xE7, 0x40, 0x3F, 0x90, 0xB3, 0x04, 0xF9, 0x06, 0x75, 0x0A, 0xF9, 0x04, 0x20, 0xDF, 0x0D,
  0x76, 0x02, 0xF9, 0x81, 0xD0, 0x7F, 0x90, 0x57, 0x70, 0x9F, 0x90, 0x70,
  // "Y" (U+0059)
  0x08, 0xF9, 0x09, 0x77, 0x08, 0xF9, 0x08, 0x01, 0xF9, 0x0E, 0x77, 0x0E, 0xF9, 0x81, 0x10, 0x9F,
  0x90, 0x67, 0x50, 0x5F, 0x90, 0x92, 0x01, 0xF9, 0x0D, 0x75, 0x0C, 0xF9, 0x02, 0x30, 0x9F, 0x90,
  0x47, 0x30, 0x3F, 0x90, 0x94, 0x02, 0xF9, 0x0B, 0x73, 0x0A, 0xF9, 0x02, 0x50, 0xAF, 0x90, 0x27,
  0x10, 0x1F, 0x90, 0xA6, 0x02, 0xF9, 0x09, 0x71, 0x07, 0xF9, 0x02, 0x70, 0xAF, 0x0E, 0x71, 0x0D,
  0xF0, 0xA7, 0x10, 0x3F, 0x90, 0x66, 0x05, 0xF9, 0x03, 0x72, 0x0B, 0xF0, 0xD6, 0x0B, 0xF0, 0xB7,
  0x30, 0x3F, 0x90, 0x44, 0x03, 0xF9, 0x04, 0x74, 0x0B, 0xF0, 0xB4, 0x09, 0xF0, 0xC7, 0x50, 0x4F,
  0x90, 0x22, 0x01, 0xF9, 0x04, 0x76, 0x0C, 0xF0, 0x82, 0x07, 0xF0, 0xC7, 0x70, 0x4F, 0x0E, 0x20,
  0xDF, 0x05, 0x77, 0x10, 0xCF, 0x06, 0x04, 0xF0, 0xD7, 0x72, 0x05, 0xF0, 0xD0, 0xBF, 0x05, 0x77,
  0x30, 0xDF, 0xF0, 0xD7, 0x74, 0x05, 0xFF, 0x06, 0x77, 0x50, 0xDF, 0xD0, 0xD7, 0x76, 0x06, 0xFD,
  0x06, 0x77, 0x70, 0xDF, 0xB0, 0xE7, 0x77, 0x10, 0x6F, 0xB0, 0x77, 0x77, 0x20, 0xEF, 0x90, 0xE7,
  0x77, 0x30, 0x7F, 0x90, 0x87, 0x77, 0x30, 0x4F, 0x90, 0x57, 0x77, 0x30, 0x4F, 0x90, 0x57, 0x77,
  0x30, 0x4F, 0x90, 0x57, 0x77, 0x30, 0x4F, 0x90, 0x57, 0x77, 0x30, 0x4F, 0x90, 0x57, 0x77, 0x30,
  0x4F, 0x90, 0x57, 0x77, 0x30, 0x4F, 0x90, 0x57, 0x77, 0x30, 0x4F, 0x90, 0x57, 0x77, 0x30, 0x4F,
  0x90, 0x57, 0x77, 0x30, 0x4F, 0x90, 0x57, 0x77, 0x30, 0x4F, 0x90, 0x57, 0x77, 0x30, 0x4F, 0x90,
  0x57, 0x77, 0x30, 0x4F, 0x90, 0x57, 0x77, 0x30, 0x4F, 0x90, 0x57, 0x77, 0x30, 0x4F, 0x90, 0x57,
  0x77, 0x30, 0x4F, 0x90, 0x57, 0x50,
  // "Z" (U+005A)
  0x20, 0xAF, 0xFF, 0xB0, 0xA2, 0x0A, 0xFF, 0xFB, 0x0A, 0x20, 0xAF, 0xFF, 0xB0, 0xA2, 0x0A, 0xFF,
  0xFB, 0x0A, 0x20, 0xAF, 0xFF, 0xB0, 0xA2, 0x0A, 0xFF, 0xFB, 0x09, 0x20, 0xA8, 0x09, 0x3E, 0xFA,
  0x02, 0x77, 0x30, 0x5F, 0x90, 0x87, 0x74, 0x0D, 0xF0, 0xE7, 0x74, 0x08, 0xF9, 0x05, 0x77, 0x30,
  0x1F, 0x90, 0xC7, 0x74, 0x0A, 0xF9, 0x03, 0x77, 0x30, 0x3F, 0x90, 0x97, 0x74, 0x0C, 0xF0, 0xE0,
  0x17, 0x73, 0x06, 0xF9, 0x06, 0x77, 0x30, 0x10, 0xEF, 0x0C, 0x77, 0x40, 0x8F, 0x90, 0x37, 0x73,
  0x02, 0xF9, 0x0A, 0x77, 0x40, 0xBF, 0x0E, 0x01, 0x77, 0x30, 0x4F, 0x90, 0x77, 0x74, 0x0D, 0xF0,
  0xD7, 0x74, 0x07, 0xF9, 0x04, 0x77, 0x30, 0x10, 0xEF, 0x0B, 0x77, 0x40, 0x9F, 0x90, 0x27, 0x73,
  0x03, 0xF9, 0x08, 0x77, 0x40, 0xBF, 0x0E, 0x77, 0x40, 0x5F, 0x90, 0x57, 0x74, 0x0D, 0xF0, 0xC7,
  0x74, 0x07, 0xF9, 0x03, 0x77, 0x30, 0x10, 0xEF, 0x09, 0x77, 0x40, 0xAF, 0x0E, 0x01, 0x77, 0x30,
  0x3F, 0x90, 0x67, 0x74, 0x0C, 0xF0, 0xC7, 0x74, 0x06, 0xF9, 0x03, 0x77, 0x40, 0xEF, 0x0A, 0x77,
  0x40, 0x8F, 0xA8, 0x09, 0x4E, 0x0B, 0x01, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF,
  0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C,
  // "[" (U+005B)
  0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x03,
  0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0,
  0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37,
  0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03,
  0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0,
  0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37,
  0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03,
  0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0,
  0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x03, 0xFF, 0x00, 0x3F,
  0xF0, 0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x30,
  // "\" (U+005C)
  0x0C, 0xE0, 0xA7, 0x72, 0x06, 0xF0, 0x17, 0x72, 0x0E, 0xE0, 0x77, 0x72, 0x09, 0xE0, 0xD7, 0x72,
  0x03, 0xF0, 0x47, 0x72, 0x0D, 0xE0, 0xA7, 0x72, 0x07, 0xF0, 0x17, 0x71, 0x01, 0xF0, 0x67, 0x72,
  0x0A, 0xE0, 0xD7, 0x72, 0x04, 0xF0, 0x37, 0x72, 0x0D, 0xE0, 0x97, 0x72, 0x07, 0xE0, 0xE7, 0x72,
  0x01, 0xF0, 0x67, 0x72, 0x0B, 0xE0, 0xC7, 0x72, 0x05, 0xF0, 0x37, 0x72, 0x0E, 0xE0, 0x97, 0x72,
  0x08, 0xE0, 0xE7, 0x72, 0x02, 0xF0, 0x57, 0x72, 0x0B, 0xE0, 0xB7, 0x72, 0x05, 0xF0, 0x27, 0x72,
  0x0E, 0xE0, 0x87, 0x72, 0x09, 0xE0, 0xE7, 0x72, 0x03, 0xF0, 0x57, 0x72, 0x0C, 0xE0, 0xB7, 0x72,
  0x06, 0xF0, 0x27, 0x72, 0x0E, 0xE0, 0x77, 0x72, 0x09, 0xE0, 0xD7, 0x72, 0x03, 0xF0, 0x47, 0x72,
  0x0D, 0xE0, 0xA7, 0x72, 0x07, 0xF0, 0x17, 0x71, 0x01, 0xF0, 0x77, 0x72, 0x0A, 0xE0, 0xD7, 0x72,
  0x04, 0xF0, 0x47, 0x72, 0x0D, 0xE0, 0xA7, 0x72, 0x07, 0xF0, 0x17, 0x71, 0x01, 0xF0, 0x67, 0x72,
  0x0B, 0xE0, 0xD7, 0x72, 0x05, 0xF0, 0x37, 0x72, 0x0E, 0xE0, 0x97, 0x72, 0x08, 0xE0, 0xE7, 0x72,
  0x02, 0xF0, 0x67, 0x72, 0x0B, 0xE0, 0xC0,
  // "]" (U+005D)
  0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x37,
  0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03,
  0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0,
  0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37,
  0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03,
  0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0,
  0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37,
  0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03,
  0xF0, 0x37, 0x03, 0xF0, 0x37, 0x03, 0xF0, 0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x03, 0xFF, 0x00, 0x3F,
  0xF0, 0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x30,
  // "^" (U+005E)
  0x76, 0x83, 0x57, 0x77, 0x57, 0x77, 0x50, 0x10, 0xEC, 0x02, 0x77, 0x74, 0x07, 0xD0, 0xA7, 0x77,
  0x40, 0xEE, 0x03, 0x77, 0x72, 0x07, 0xF0, 0xB7, 0x77, 0x20, 0xEF, 0x90, 0x47, 0x77, 0x07, 0xFA,
  0x0C, 0x77, 0x70, 0xEF, 0xB0, 0x47, 0x75, 0x07, 0xFC, 0x0C, 0x77, 0x50, 0xEF, 0xD0, 0x57, 0x73,
  0x07, 0xE0, 0xAE, 0x0D, 0x77, 0x30, 0xED, 0x81, 0xE0, 0xAE, 0x06, 0x77, 0x10, 0x6E, 0x81, 0x70,
  0x2E, 0x0E, 0x77, 0x10, 0xDD, 0x0E, 0x01, 0x20, 0x9E, 0x07, 0x76, 0x06, 0xE0, 0x83, 0x01, 0xE0,
  0xE0, 0x17, 0x50, 0xDD, 0x0E, 0x01, 0x40, 0x8E, 0x08, 0x74, 0x06, 0xE0, 0x85, 0x01, 0x0E, 0xD0,
  0xE0, 0x17, 0x30, 0xDE, 0x01, 0x60, 0x7E, 0x09, 0x72, 0x06, 0xE0, 0x97, 0x10, 0xEE, 0x02, 0x71,
  0x0D, 0xE0, 0x27, 0x10, 0x6E, 0x09, 0x70, 0x6E, 0x09, 0x73, 0x0D, 0xE0, 0x26, 0x0D, 0xE0, 0x27,
  0x30, 0x6E, 0x0A, 0x50, 0x5E, 0x0A, 0x75, 0x0D, 0xE0, 0x34, 0x0D, 0xE0, 0x27, 0x50, 0x5E, 0x0B,
  0x30, 0x5E, 0x0A, 0x77, 0x0C, 0xE0, 0x42, 0x0D, 0xE0, 0x37, 0x70, 0x4E, 0x81, 0xC0, 0x5E, 0x0B,
  0x77, 0x20, 0xBE, 0x05,
  // "_" (U+005F)
  0x80, 0xC0, 0xE8, 0x0B, 0xA4, 0xF0,
  // "`" (U+0060)
  0x06, 0x80, 0x47, 0x06, 0x60, 0x6F, 0xA0, 0x36, 0x07, 0xF9, 0x0C, 0x70, 0x7F, 0x90, 0x77, 0x06,
  0xF9, 0x03, 0x70, 0x5F, 0x0D, 0x71, 0x04, 0x0E, 0xE0, 0x87, 0x10, 0x30, 0xEE, 0x04, 0x71, 0x02,
  0x0D, 0xD0, 0xE0, 0x17, 0x10, 0x10, 0xBD, 0x08,
  // "a" (U+0061)
  0x73, 0x87, 0x35, 0x56, 0x77, 0x65, 0x37, 0x73, 0x81, 0x59, 0xDF, 0xC8, 0x1D, 0x82, 0x73, 0x03,
  0x0A, 0xFF, 0xC0, 0xB0, 0x37, 0x0B, 0xFF, 0xF9, 0x08, 0x60, 0x7F, 0xFF, 0xA0, 0x95, 0x01, 0x0E,
  0xFF, 0xFA, 0x05, 0x50, 0x8F, 0xFF, 0xA0, 0xE5, 0x01, 0x0E, 0xC8, 0x7E, 0xCA, 0x87, 0x77, 0x9C,
  0xFB, 0x05, 0x58, 0x38, 0xFB, 0x63, 0x72, 0x02, 0x0B, 0xF9, 0x0A, 0x77, 0x70, 0xCF, 0x0D, 0x77,
  0x70, 0x5F, 0x97, 0x77, 0x03, 0xF9, 0x01, 0x77, 0x60, 0x2F, 0x90, 0x17, 0x84, 0x47, 0xAC, 0xDE,
  0xFF, 0xA0, 0x14, 0x81, 0x19, 0xEF, 0xFF, 0x90, 0x13, 0x07, 0x0E, 0xFF, 0xFB, 0x01, 0x20, 0x8F,
  0xFF, 0xD8, 0x11, 0x05, 0xFF, 0xFE, 0x81, 0x10, 0xEF, 0xA8, 0x19, 0x52, 0x60, 0x2F, 0x90, 0x10,
  0x5F, 0x90, 0xC0, 0x17, 0x20, 0x2F, 0x90, 0x10, 0xAF, 0x0E, 0x01, 0x73, 0x03, 0xF9, 0x01, 0x0C,
  0xF0, 0x97, 0x40, 0x4F, 0x90, 0x10, 0xEF, 0x07, 0x74, 0x08, 0xF9, 0x01, 0xF9, 0x08, 0x73, 0x01,
  0x0E, 0xF9, 0x01, 0x0E, 0xF0, 0xD7, 0x20, 0x10, 0xCF, 0xA0, 0x10, 0xDF, 0x90, 0xA0, 0x16, 0x05,
  0x0E, 0xFB, 0x01, 0x09, 0xFB, 0x84, 0xB8, 0x78, 0xAE, 0xFD, 0x01, 0x05, 0xFF, 0xFF, 0x81, 0x10,
  0xDF, 0xFC, 0x00, 0xEF, 0x81, 0x10, 0x5F, 0xFB, 0x81, 0xE3, 0x9F, 0x01, 0x20, 0x9F, 0xF9, 0x82,
  0xD3, 0x04, 0xF0, 0x13, 0x08, 0xFE, 0x0A, 0x01, 0x30, 0xEE, 0x01, 0x48, 0x12, 0xAE, 0xF8, 0x1E,
  0x92, 0x50, 0xAE, 0x01, 0x78, 0x53, 0x56, 0x76, 0x52, 0x77, 0x20,
  // "b" (U+0062)
  0x0A, 0xF0, 0xC7, 0x77, 0x10, 0xAF, 0x0C, 0x77, 0x71, 0x0A, 0xF0, 0xC7, 0x77, 0x10, 0xAF, 0x0C,
  0x77, 0x71, 0x0A, 0xF0, 0xC7, 0x77, 0x10, 0xAF, 0x0C, 0x77, 0x71, 0x0A, 0xF0, 0xC7, 0x77, 0x10,
  0xAF, 0x0C, 0x77, 0x71, 0x0A, 0xF0, 0xC7, 0x77, 0x10, 0xAF, 0x0C, 0x77, 0x71, 0x0A, 0xF0, 0xC7,
  0x77, 0x10, 0xAF, 0x0C, 0x77, 0x71, 0x0A, 0xF0, 0xB6, 0x85, 0x25, 0x77, 0x65, 0x17, 0x20, 0xAF,
  0x0B, 0x38, 0x11, 0x8E, 0xF0, 0xD0, 0x67, 0x0A, 0xF0, 0xA2, 0x07, 0xFD, 0x0D, 0x03, 0x50, 0xAF,
  0x81, 0x90, 0xBF, 0xF0, 0xE0, 0x34, 0x0A, 0xF0, 0x70, 0xAF, 0xFA, 0x0E, 0x02, 0x30, 0xAF, 0x0E,
  0xFF, 0xC0, 0xC3, 0x0A, 0xFF, 0xFE, 0x06, 0x20, 0xAF, 0xD8, 0x3A, 0x87, 0x9D, 0xFB, 0x0D, 0x20,
  0xAF, 0xB0, 0xA0, 0x15, 0x04, 0x0E, 0xFA, 0x81, 0x40, 0xAF, 0xA0, 0xA7, 0x10, 0x20, 0xEF, 0x98,
  0x18, 0x0A, 0xF9, 0x0E, 0x01, 0x72, 0x07, 0xF9, 0x81, 0xD0, 0xAF, 0x90, 0x87, 0x40, 0xEF, 0x90,
  0x10, 0xAF, 0x90, 0x37, 0x40, 0xAF, 0x90, 0x40, 0xAF, 0x90, 0x17, 0x40, 0x7F, 0x90, 0x50, 0xAF,
  0x0E, 0x75, 0x05, 0xF9, 0x07, 0x0A, 0xF0, 0xD7, 0x50, 0x4F, 0x90, 0x80, 0xAF, 0x0C, 0x75, 0x03,
  0xF9, 0x08, 0x0A, 0xF0, 0xD7, 0x50, 0x3F, 0x90, 0x80, 0xAF, 0x0D, 0x75, 0x04, 0xF9, 0x08, 0x0A,
  0xF9, 0x75, 0x05, 0xF9, 0x07, 0x0A, 0xF9, 0x02, 0x74, 0x08, 0xF9, 0x05, 0x0A, 0xF9, 0x05, 0x74,
  0x0B, 0xF9, 0x03, 0x0A, 0xF9, 0x0A, 0x73, 0x01, 0xFA, 0x10, 0xAF, 0xA0, 0x27, 0x20, 0x8F, 0x98,
  0x1C, 0x0A, 0xFA, 0x0C, 0x71, 0x03, 0x0E, 0xF9, 0x81, 0x70, 0xAF, 0xB0, 0xB0, 0x25, 0x04, 0x0E,
  0xFA, 0x81, 0x20, 0xAF, 0xD8, 0x3B, 0x87, 0x8D, 0xFB, 0x0B, 0x20, 0xAF, 0xFF, 0xE0, 0x42, 0x0A,
  0xFF, 0xFD, 0x0A, 0x30, 0xAF, 0xFF, 0xC0, 0xD0, 0x13, 0x0A, 0xE8, 0x1E, 0x18, 0xFF, 0x90, 0xD0,
  0x24, 0x0A, 0xE0, 0x82, 0x05, 0x0D, 0xFD, 0x0B, 0x01, 0x50, 0xAE, 0x02, 0x40, 0x50, 0xBF, 0x90,
  0xC0, 0x57, 0x77, 0x18, 0x53, 0x56, 0x76, 0x41, 0x72,
  // "c" (U+0063)
  0x75, 0x89, 0x02, 0x46, 0x77, 0x76, 0x53, 0x17, 0x68, 0x21, 0x6B, 0xEF, 0xB8, 0x2D, 0xA6, 0x17,
  0x81, 0x18, 0xEF, 0xFB, 0x0B, 0x50, 0x40, 0xEF, 0xFD, 0x0C, 0x40, 0x5F, 0xFF, 0x06, 0x30, 0x4F,
  0xFF, 0x90, 0x12, 0x01, 0x0E, 0xFF, 0xF0, 0xA3, 0x09, 0xFC, 0x85, 0xC9, 0x77, 0x8A, 0xCC, 0x04,
  0x20, 0x2F, 0xB0, 0xA0, 0x27, 0x18, 0x14, 0xAD, 0x30, 0x8F, 0xA0, 0x67, 0x72, 0x0D, 0xF9, 0x09,
  0x77, 0x20, 0x2F, 0xA0, 0x17, 0x72, 0x05, 0xF9, 0x0A, 0x77, 0x30, 0x8F, 0x90, 0x67, 0x73, 0x0A,
  0xF9, 0x03, 0x77, 0x30, 0xBF, 0x90, 0x17, 0x73, 0x0B, 0xF9, 0x77, 0x40, 0xCF, 0x97, 0x74, 0x0B,
  0xF9, 0x01, 0x77, 0x30, 0xAF, 0x90, 0x27, 0x73, 0x09, 0xF9, 0x05, 0x77, 0x30, 0x7F, 0x90, 0x97,
  0x73, 0x03, 0xF9, 0x0E, 0x77, 0x4F, 0xA0, 0x87, 0x73, 0x0B, 0xFA, 0x06, 0x75, 0x83, 0x3B, 0x20,
  0x5F, 0xB0, 0x90, 0x27, 0x81, 0x16, 0xBA, 0x02, 0x20, 0xDF, 0xC8, 0x5C, 0x97, 0x78, 0xAD, 0xD0,
  0x22, 0x05, 0xFF, 0xFA, 0x02, 0x30, 0x9F, 0xFF, 0x90, 0x24, 0x0B, 0xFF, 0xF0, 0x25, 0x09, 0xFF,
  0xE0, 0x26, 0x04, 0x0C, 0xFF, 0xB0, 0xA0, 0x17, 0x18, 0x13, 0x9D, 0xFB, 0x82, 0xEB, 0x71, 0x76,
  0x89, 0x01, 0x35, 0x67, 0x77, 0x64, 0x26,
  // "d" (U+0064)
  0x77, 0x71, 0x0C, 0xF0, 0xA7, 0x77, 0x10, 0xCF, 0x0A, 0x77, 0x71, 0x0C, 0xF0, 0xA7, 0x77, 0x10,
  0xCF, 0x0A, 0x77, 0x71, 0x0C, 0xF0, 0xA7, 0x77, 0x10, 0xCF, 0x0A, 0x77, 0x71, 0x0C, 0xF0, 0xA7,
  0x77, 0x10, 0xCF, 0x0A, 0x77, 0x71, 0x0C, 0xF0, 0xA7, 0x77, 0x10, 0xCF, 0x0A, 0x77, 0x71, 0x0C,
  0xF0, 0xA7, 0x77, 0x10, 0xBF, 0x0A, 0x73, 0x85, 0x35, 0x77, 0x64, 0x15, 0x0A, 0xF0, 0xA7, 0x04,
  0x0A, 0xF9, 0x0C, 0x06, 0x30, 0x9F, 0x0A, 0x50, 0x10, 0xAF, 0xD8, 0x2C, 0x20, 0x7F, 0x0A, 0x40,
  0x20, 0xDF, 0xF8, 0x1E, 0x35, 0xF0, 0xA3, 0x01, 0x0D, 0xFF, 0xA0, 0xE0, 0x5F, 0x0A, 0x30, 0xBF,
  0xFC, 0x0E, 0xF0, 0xA2, 0x05, 0xFF, 0xFE, 0x0A, 0x20, 0xCF, 0xB8, 0x4E, 0xA8, 0x78, 0xBF, 0xC8,
  0x1A, 0x03, 0xFB, 0x08, 0x60, 0x20, 0xDF, 0xA8, 0x1A, 0x08, 0xFA, 0x05, 0x71, 0x02, 0x0E, 0xF9,
  0x81, 0xA0, 0xDF, 0x90, 0xA7, 0x30, 0x5F, 0x90, 0xA1, 0xFA, 0x02, 0x74, 0x0E, 0xF0, 0xA0, 0x3F,
  0x90, 0xC7, 0x50, 0xAF, 0x0A, 0x05, 0xF9, 0x09, 0x75, 0x07, 0xF0, 0xA0, 0x7F, 0x90, 0x67, 0x50,
  0x4F, 0x0A, 0x08, 0xF9, 0x04, 0x75, 0x03, 0xF0, 0xA0, 0x8F, 0x90, 0x47, 0x50, 0x3F, 0x0A, 0x09,
  0xF9, 0x03, 0x75, 0x02, 0xF0, 0xA0, 0x8F, 0x90, 0x47, 0x50, 0x2F, 0x0A, 0x07, 0xF9, 0x05, 0x75,
  0x03, 0xF0, 0xA0, 0x5F, 0x90, 0x77, 0x50, 0x5F, 0x0A, 0x03, 0xF9, 0x0A, 0x75, 0x08, 0xF0, 0xA0,
  0x1F, 0x90, 0xE7, 0x50, 0xDF, 0x81, 0xA0, 0xDF, 0x90, 0x67, 0x30, 0x4F, 0x98, 0x1A, 0x09, 0xF9,
  0x0E, 0x02, 0x71, 0x01, 0x0D, 0xF9, 0x81, 0xA0, 0x4F, 0xA0, 0xD0, 0x46, 0x04, 0x0D, 0xFA, 0x0A,
  0x20, 0xDF, 0xB8, 0x4D, 0x97, 0x79, 0xDF, 0xC0, 0xA2, 0x06, 0xFF, 0xFE, 0x0A, 0x30, 0xCF, 0xFC,
  0x0E, 0xF0, 0xA3, 0x02, 0x0E, 0xFF, 0xA0, 0x06, 0xF0, 0xA4, 0x04, 0x0E, 0xFF, 0x08, 0x20, 0xEE,
  0x0A, 0x50, 0x30, 0xDF, 0xC0, 0xE0, 0x63, 0x08, 0xE0, 0xA7, 0x07, 0x0D, 0xF8, 0x1E, 0x81, 0x40,
  0x2E, 0x0A, 0x72, 0x85, 0x25, 0x67, 0x75, 0x27, 0x71,
  // "e" (U+0065)
  0x74, 0x87, 0x14, 0x66, 0x76, 0x54, 0x17, 0x74, 0x81, 0x28, 0xDF, 0xA8, 0x1C, 0x82, 0x76, 0x02,
  0x0A, 0xFF, 0x90, 0xA0, 0x17, 0x30, 0x60, 0xEF, 0xFB, 0x0E, 0x04, 0x71, 0x07, 0xFF, 0xF0, 0x56,
  0x06, 0xFF, 0xF9, 0x0E, 0x02, 0x40, 0x3F, 0xFF, 0xB0, 0xD4, 0x0C, 0xFB, 0x84, 0xB8, 0x77, 0xAE,
  0xFA, 0x06, 0x20, 0x5F, 0xA0, 0x80, 0x16, 0x06, 0x0E, 0xF0, 0xD2, 0x0B, 0xF9, 0x04, 0x72, 0x03,
  0x0E, 0xF0, 0x30, 0x1F, 0x90, 0x77, 0x40, 0x6F, 0x07, 0x05, 0xF0, 0xE7, 0x50, 0x1F, 0x0A, 0x09,
  0xF0, 0xB7, 0x60, 0xDE, 0x0C, 0x0B, 0xFF, 0xFF, 0x00, 0xDF, 0xFF, 0xF9, 0x0E, 0x80, 0x9A, 0x5F,
  0x0E, 0xFF, 0xFF, 0x90, 0xDF, 0x07, 0x77, 0x70, 0xBF, 0x0A, 0x77, 0x70, 0x8F, 0x0E, 0x77, 0x70,
  0x4F, 0x90, 0x77, 0x77, 0x0E, 0xF9, 0x04, 0x77, 0x60, 0x9F, 0xA0, 0x67, 0x71, 0x02, 0x08, 0x20,
  0x2F, 0xB0, 0xC0, 0x57, 0x38, 0x14, 0x8D, 0xA3, 0x08, 0xFD, 0x86, 0xC9, 0x87, 0x78, 0xAD, 0xE4,
  0x0C, 0xFF, 0xFC, 0x40, 0x10, 0xDF, 0xFF, 0xB5, 0x01, 0x0C, 0xFF, 0xFA, 0x70, 0x8F, 0xFF, 0x97,
  0x10, 0x20, 0xAF, 0xFC, 0x0D, 0x07, 0x73, 0x82, 0x16, 0xBE, 0xFC, 0x81, 0xC8, 0x37, 0x72, 0x89,
  0x02, 0x46, 0x77, 0x76, 0x64, 0x27,
  // "f" (U+0066)
  0x77, 0x18, 0x94, 0x37, 0xAC, 0xDE, 0xFE, 0xEC, 0xB8, 0x53, 0x77, 0x10, 0x60, 0xDF, 0xF0, 0xE0,
  0x77, 0x40, 0x10, 0xBF, 0xFB, 0x06, 0x73, 0x01, 0x0C, 0xFF, 0xC0, 0x17, 0x30, 0xAF, 0xFC, 0x0A,
  0x73, 0x02, 0xFF, 0xD0, 0x57, 0x30, 0x8F, 0xFC, 0x0E, 0x74, 0x0C, 0xFA, 0x81, 0xB4, 0x13, 0x82,
  0x24, 0x87, 0x74, 0xFA, 0x09, 0x77, 0x60, 0x1F, 0x90, 0xE7, 0x77, 0x02, 0xF9, 0x09, 0x77, 0x70,
  0x3F, 0x90, 0x77, 0x77, 0x03, 0xF9, 0x07, 0x77, 0x38, 0x31, 0x58, 0xBE, 0xFF, 0xD3, 0x82, 0x47,
  0xAE, 0xFF, 0xFB, 0x30, 0xEF, 0xFF, 0xE3, 0x0E, 0xFF, 0xFE, 0x30, 0xEF, 0xFF, 0xE3, 0x0E, 0xFF,
  0xFE, 0x30, 0xD8, 0x04, 0xEF, 0xA8, 0x06, 0xE7, 0x40, 0x3F, 0x90, 0x77, 0x77, 0x03, 0xF9, 0x07,
  0x77, 0x70, 0x3F, 0x90, 0x77, 0x77, 0x03, 0xF9, 0x07, 0x77, 0x70, 0x3F, 0x90, 0x77, 0x77, 0x03,
  0xF9, 0x07, 0x77, 0x70, 0x3F, 0x90, 0x77, 0x77, 0x03, 0xF9, 0x07, 0x77, 0x70, 0x3F, 0x90, 0x77,
  0x77, 0x03, 0xF9, 0x07, 0x77, 0x70, 0x3F, 0x90, 0x77, 0x77, 0x03, 0xF9, 0x07, 0x77, 0x70, 0x3F,
  0x90, 0x77, 0x77, 0x03, 0xF9, 0x07, 0x77, 0x70, 0x3F, 0x90, 0x77, 0x77, 0x03, 0xF9, 0x07, 0x77,
  0x70, 0x3F, 0x90, 0x77, 0x77, 0x03, 0xF9, 0x07, 0x77, 0x70, 0x3F, 0x90, 0x77, 0x77, 0x03, 0xF9,
  0x07, 0x77, 0x70, 0x3F, 0x90, 0x77, 0x77, 0x03, 0xF9, 0x07, 0x77, 0x70, 0x3F, 0x90, 0x77, 0x77,
  0x03, 0xF9, 0x07, 0x77, 0x70, 0x3F, 0x90, 0x77, 0x60,
  // "g" (U+0067)
  0x72, 0x85, 0x14, 0x67, 0x75, 0x37, 0x77, 0x10, 0x50, 0xCF, 0x81, 0xE8, 0x14, 0x02, 0xE0, 0xA5,
  0x01, 0x0C, 0xFC, 0x0E, 0x06, 0x30, 0x8E, 0x0A, 0x40, 0x20, 0xEF, 0xF0, 0x92, 0x0E, 0xE0, 0xA3,
  0x01, 0x0E, 0xFF, 0xA0, 0x80, 0x6F, 0x0A, 0x30, 0xAF, 0xFF, 0xD0, 0xA2, 0x04, 0xFF, 0xFE, 0x0A,
  0x20, 0xCF, 0xB8, 0x4D, 0x97, 0x79, 0xDF, 0xC8, 0x1A, 0x03, 0xFA, 0x0E, 0x05, 0x60, 0x60, 0xEF,
  0xA8, 0x1A, 0x08, 0xFA, 0x03, 0x71, 0x04, 0xFA, 0x81, 0xA0, 0xDF, 0x90, 0x87, 0x30, 0x9F, 0x90,
  0xA1, 0xFA, 0x01, 0x73, 0x03, 0xF9, 0x0A, 0x03, 0xF9, 0x0B, 0x75, 0x0E, 0xF0, 0xA0, 0x6F, 0x90,
  0x87, 0x50, 0xBF, 0x0A, 0x07, 0xF9, 0x05, 0x75, 0x09, 0xF0, 0xA0, 0x7F, 0x90, 0x47, 0x50, 0x8F,
  0x0A, 0x08, 0xF9, 0x03, 0x75, 0x07, 0xF0, 0xA0, 0x8F, 0x90, 0x37, 0x50, 0x7F, 0x0A, 0x08, 0xF9,
  0x04, 0x75, 0x07, 0xF0, 0xA0, 0x7F, 0x90, 0x57, 0x50, 0x8F, 0x0A, 0x06, 0xF9, 0x08, 0x75, 0x09,
  0xF0, 0xA0, 0x3F, 0x90, 0xB7, 0x50, 0xCF, 0x0A, 0x1F, 0xA0, 0x17, 0x30, 0x1F, 0x98, 0x1A, 0x0D,
  0xF9, 0x08, 0x73, 0x08, 0xF9, 0x81, 0xA0, 0x8F, 0xA0, 0x37, 0x10, 0x3F, 0xA8, 0x1A, 0x03, 0xFA,
  0x0E, 0x05, 0x60, 0x40, 0xEF, 0xA0, 0xA2, 0x0C, 0xFB, 0x84, 0xD9, 0x77, 0x9D, 0xFC, 0x0A, 0x20,
  0x4F, 0xFF, 0xE0, 0xA3, 0x0A, 0xFF, 0xFD, 0x0A, 0x30, 0x10, 0xDF, 0xFA, 0x09, 0x0D, 0xF0, 0xA4,
  0x02, 0x0E, 0xFF, 0x81, 0xA0, 0xEF, 0x0A, 0x50, 0x10, 0xBF, 0xD0, 0x82, 0xF9, 0x0A, 0x70, 0x50,
  0xBF, 0x81, 0xE9, 0x23, 0xF9, 0x0A, 0x72, 0x85, 0x14, 0x67, 0x76, 0x35, 0x01, 0xF9, 0x0A, 0x77,
  0x70, 0x2F, 0x90, 0x97, 0x77, 0x04, 0xF9, 0x07, 0x77, 0x70, 0x8F, 0x90, 0x52, 0x01, 0x02, 0x77,
  0x20, 0x10, 0xEF, 0x90, 0x12, 0x83, 0x4F, 0xC6, 0x27, 0x50, 0x20, 0xDF, 0x90, 0xB3, 0x04, 0xC8,
  0x3D, 0x96, 0x41, 0x48, 0x11, 0x49, 0xFB, 0x05, 0x30, 0x4F, 0xFF, 0xC0, 0xC4, 0x04, 0xFF, 0xFC,
  0x03, 0x40, 0x4F, 0xFF, 0xB0, 0x55, 0x04, 0xFF, 0xF9, 0x0E, 0x05, 0x60, 0x4F, 0xFF, 0x0B, 0x02,
  0x78, 0x11, 0x7C, 0xFF, 0xA8, 0x1E, 0xA3, 0x75, 0x86, 0x14, 0x7A, 0xBD, 0xEE, 0xA8, 0x4E, 0xDC,
  0xA7, 0x37, 0x30,
  // "h" (U+0068)
  0x0A, 0xF9, 0x77, 0x70, 0xAF, 0x97, 0x77, 0x0A, 0xF9, 0x77, 0x70, 0xAF, 0x97, 0x77, 0x0A, 0xF9,
  0x77, 0x70, 0xAF, 0x97, 0x77, 0x0A, 0xF9, 0x77, 0x70, 0xAF, 0x97, 0x77, 0x0A, 0xF9, 0x77, 0x70,
  0xAF, 0x97, 0x77, 0x0A, 0xF9, 0x77, 0x70, 0xAF, 0x0E, 0x77, 0x70, 0xAF, 0x0E, 0x68, 0x53, 0x57,
  0x76, 0x53, 0x71, 0x0A, 0xF0, 0xD3, 0x81, 0x18, 0xEF, 0x81, 0xEB, 0x35, 0x0A, 0xF0, 0xD2, 0x04,
  0x0E, 0xFD, 0x0B, 0x01, 0x30, 0xAF, 0x81, 0xD0, 0x5F, 0xF9, 0x0D, 0x01, 0x20, 0xAF, 0x0C, 0x03,
  0xFF, 0xB0, 0xC2, 0x0A, 0xF9, 0x0E, 0xFF, 0xC8, 0x17, 0x0A, 0xFF, 0xFE, 0x81, 0xE0, 0xAF, 0xD8,
  0x4C, 0x87, 0x7A, 0xEF, 0xB0, 0x50, 0xAF, 0xB0, 0xD0, 0x35, 0x01, 0x0A, 0xFA, 0x08, 0x0A, 0xFA,
  0x0D, 0x01, 0x71, 0x0B, 0xF9, 0x0C, 0x0A, 0xFA, 0x05, 0x72, 0x04, 0xF9, 0x0D, 0x0A, 0xF9, 0x0D,
  0x74, 0xF9, 0x0E, 0x0A, 0xF9, 0x09, 0x74, 0x0C, 0xF9, 0x0A, 0xF9, 0x05, 0x74, 0x0B, 0xF9, 0x0A,
  0xF9, 0x03, 0x74, 0x0A, 0xF9, 0x0A, 0xF9, 0x01, 0x74, 0x0A, 0xF9, 0x0A, 0xF9, 0x75, 0x0A, 0xF9,
  0x0A, 0xF9, 0x75, 0x0A, 0xF9, 0x0A, 0xF9, 0x75, 0x0A, 0xF9, 0x0A, 0xF9, 0x75, 0x0A, 0xF9, 0x0A,
  0xF9, 0x75, 0x0A, 0xF9, 0x0A, 0xF9, 0x75, 0x0A, 0xF9, 0x0A, 0xF9, 0x75, 0x0A, 0xF9, 0x0A, 0xF9,
  0x75, 0x0A, 0xF9, 0x0A, 0xF9, 0x75, 0x0A, 0xF9, 0x0A, 0xF9, 0x75, 0x0A, 0xF9, 0x0A, 0xF9, 0x75,
  0x0A, 0xF9, 0x0A, 0xF9, 0x75, 0x0A, 0xF9, 0x0A, 0xF9, 0x75, 0x0A, 0xF9, 0x0A, 0xF9, 0x75, 0x0A,
  0xF9, 0x0A, 0xF9, 0x75, 0x0A, 0xF9, 0x0A, 0xF9, 0x75, 0x0A, 0xF9, 0x0A, 0xF9, 0x75, 0x0A, 0xF9,
  // "i" (U+0069)
  0x75, 0x81, 0x29, 0xDA, 0x81, 0xD9, 0x27, 0x77, 0x03, 0x0E, 0xE0, 0xE0, 0x37, 0x76, 0x0C, 0xF9,
  0x0C, 0x77, 0x50, 0x2F, 0xB0, 0x27, 0x74, 0x04, 0xFB, 0x04, 0x77, 0x40, 0x4F, 0xB0, 0x37, 0x74,
  0x02, 0xFB, 0x01, 0x77, 0x50, 0xCF, 0x90, 0xC7, 0x76, 0x03, 0x0E, 0xE0, 0xE0, 0x27, 0x77, 0x81,
  0x29, 0xDA, 0x81, 0xD8, 0x18, 0x0A, 0x80, 0x00, 0xCF, 0xFB, 0x03, 0x74, 0x0C, 0xFF, 0xB0, 0x37,
  0x40, 0xCF, 0xFB, 0x03, 0x74, 0x0C, 0xFF, 0xB0, 0x37, 0x40, 0xCF, 0xFB, 0x03, 0x74, 0x0C, 0xFF,
  0xB0, 0x37, 0x48, 0x61, 0x35, 0x78, 0xAC, 0xDF, 0xB0, 0x37, 0x76, 0x08, 0xF9, 0x03, 0x77, 0x60,
  0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03,
  0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07,
  0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37,
  0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F,
  0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x78, 0x41, 0x35, 0x8A, 0xDF,
  0xB8, 0x3C, 0x96, 0x41, 0x48, 0x31, 0x69, 0xBE, 0xFF, 0xF8, 0x3E, 0xB8, 0x56, 0xFF, 0xFF, 0x90,
  0x6F, 0xFF, 0xF9, 0x06, 0xFF, 0xFF, 0x90, 0x6F, 0xFF, 0xF9, 0x06, 0xFF, 0xFF, 0x90,
  // "j" (U+006A)
  0x77, 0x18, 0x63, 0xAD, 0xFE, 0xC8, 0x17, 0x71, 0x05, 0xF0, 0xD0, 0x17, 0x60, 0x10, 0xEF, 0x90,
  0x97, 0x60, 0x5F, 0xA0, 0xE7, 0x60, 0x7F, 0xB7, 0x60, 0x7F, 0xB7, 0x60, 0x5F, 0xA0, 0xE7, 0x60,
  0x10, 0xEF, 0x90, 0x97, 0x70, 0x6F, 0x0D, 0x01, 0x77, 0x18, 0x53, 0xAE, 0xFE, 0xC7, 0x80, 0x9F,
  0x30, 0x04, 0xFF, 0xB0, 0xB5, 0x04, 0xFF, 0xB0, 0xB5, 0x04, 0xFF, 0xB0, 0xB5, 0x04, 0xFF, 0xB0,
  0xB5, 0x04, 0xFF, 0xB0, 0xB5, 0x04, 0xFF, 0xB0, 0xB6, 0x85, 0x46, 0x79, 0xBC, 0xEF, 0xB0, 0xB7,
  0x70, 0x20, 0xEF, 0x0B, 0x77, 0x10, 0xEF, 0x0B, 0x77, 0x10, 0xEF, 0x0B, 0x77, 0x10, 0xEF, 0x0B,
  0x77, 0x10, 0xEF, 0x0B, 0x77, 0x10, 0xEF, 0x0B, 0x77, 0x10, 0xEF, 0x0B, 0x77, 0x10, 0xEF, 0x0B,
  0x77, 0x10, 0xEF, 0x0B, 0x77, 0x10, 0xEF, 0x0B, 0x77, 0x10, 0xEF, 0x0B, 0x77, 0x10, 0xEF, 0x0B,
  0x77, 0x10, 0xEF, 0x0B, 0x77, 0x10, 0xEF, 0x0B, 0x77, 0x10, 0xEF, 0x0B, 0x77, 0x10, 0xEF, 0x0B,
  0x77, 0x10, 0xEF, 0x0B, 0x77, 0x10, 0xEF, 0x0B, 0x77, 0x10, 0xEF, 0x0B, 0x77, 0x10, 0xEF, 0x0B,
  0x77, 0x10, 0xEF, 0x0B, 0x77, 0x10, 0xEF, 0x0B, 0x77, 0x10, 0xEF, 0x0B, 0x77, 0x10, 0xEF, 0x0B,
  0x77, 0x10, 0xEF, 0x0B, 0x77, 0x1F, 0x90, 0xB7, 0x70, 0x1F, 0x90, 0xA7, 0x70, 0x3F, 0x90, 0x97,
  0x70, 0x7F, 0x90, 0x87, 0x70, 0xDF, 0x90, 0x67, 0x60, 0xAF, 0xA8, 0x52, 0x9C, 0x86, 0x32, 0x48,
  0x12, 0x6D, 0xFA, 0x81, 0xE0, 0x9F, 0xFF, 0x81, 0x70, 0x9F, 0xFE, 0x82, 0xE1, 0x09, 0xFF, 0xE0,
  0x52, 0x09, 0xFF, 0xD0, 0x73, 0x09, 0xFF, 0xB0, 0xE0, 0x54, 0x07, 0xFF, 0x98, 0x1E, 0x81, 0x78,
  0x94, 0x46, 0x9B, 0xCE, 0xEF, 0xED, 0xDA, 0x74, 0x71,
  // "k" (U+006B)
  0x06, 0xF9, 0x04, 0x77, 0x71, 0x06, 0xF9, 0x04, 0x77, 0x71, 0x06, 0xF9, 0x04, 0x77, 0x71, 0x06,
  0xF9, 0x04, 0x77, 0x71, 0x06, 0xF9, 0x04, 0x77, 0x71, 0x06, 0xF9, 0x04, 0x77, 0x71, 0x06, 0xF9,
  0x04, 0x77, 0x71, 0x06, 0xF9, 0x04, 0x77, 0x71, 0x06, 0xF9, 0x04, 0x77, 0x71, 0x06, 0xF9, 0x04,
  0x77, 0x71, 0x06, 0xF9, 0x04, 0x77, 0x71, 0x06, 0xF9, 0x04, 0x77, 0x71, 0x06, 0xF9, 0x04, 0x77,
  0x71, 0x06, 0xF9, 0x04, 0x73, 0x03, 0xFA, 0x81, 0xC0, 0x6F, 0x90, 0x47, 0x20, 0x20, 0xEF, 0x98,
  0x2D, 0x10, 0x6F, 0x90, 0x47, 0x10, 0x10, 0xDF, 0x90, 0xE0, 0x22, 0x06, 0xF9, 0x04, 0x71, 0x0B,
  0xF9, 0x0E, 0x03, 0x30, 0x6F, 0x90, 0x47, 0x0A, 0xFA, 0x04, 0x40, 0x6F, 0x90, 0x46, 0x08, 0xFA,
  0x05, 0x50, 0x6F, 0x90, 0x45, 0x05, 0xFA, 0x07, 0x60, 0x6F, 0x90, 0x44, 0x04, 0xFA, 0x08, 0x70,
  0x6F, 0x90, 0x43, 0x02, 0x0E, 0xF9, 0x0A, 0x71, 0x06, 0xF9, 0x04, 0x20, 0x10, 0xDF, 0x90, 0xB7,
  0x20, 0x6F, 0x90, 0x32, 0x0B, 0xF9, 0x0C, 0x73, 0x06, 0xF9, 0x81, 0x20, 0x9F, 0x90, 0xD0, 0x17,
  0x30, 0x6F, 0x90, 0x10, 0x6F, 0x90, 0xE0, 0x27, 0x40, 0x6F, 0x81, 0xE2, 0xEF, 0x90, 0x77, 0x50,
  0x6F, 0x0D, 0x0C, 0xFA, 0x0E, 0x02, 0x74, 0x06, 0xFF, 0xD0, 0xB7, 0x40, 0x6F, 0xFE, 0x07, 0x73,
  0x06, 0xFF, 0xF0, 0x27, 0x20, 0x6F, 0xD0, 0xEF, 0x90, 0xC7, 0x20, 0x6F, 0xC8, 0x1B, 0x18, 0xF9,
  0x08, 0x71, 0x06, 0xFB, 0x08, 0x30, 0xDF, 0x90, 0x37, 0x06, 0xF9, 0x0E, 0x04, 0x40, 0x3F, 0x90,
  0xD7, 0x06, 0xF9, 0x04, 0x60, 0x8F, 0x90, 0x96, 0x06, 0xF9, 0x04, 0x70, 0xDF, 0x90, 0x45, 0x06,
  0xF9, 0x04, 0x70, 0x3F, 0x90, 0xD5, 0x06, 0xF9, 0x04, 0x71, 0x09, 0xF9, 0x09, 0x40, 0x6F, 0x90,
  0x47, 0x20, 0xDF, 0x90, 0x53, 0x06, 0xF9, 0x04, 0x72, 0x04, 0xF9, 0x0E, 0x01, 0x20, 0x6F, 0x90,
  0x47, 0x30, 0x9F, 0x90, 0xA2, 0x06, 0xF9, 0x04, 0x74, 0x0D, 0xF9, 0x81, 0x50, 0x6F, 0x90, 0x47,
  0x40, 0x4F, 0x98, 0x1E, 0x16, 0xF9, 0x04, 0x75, 0x09, 0xF9, 0x0B,
  // "l" (U+006C)
  0x20, 0x4F, 0xFB, 0x01, 0x74, 0x04, 0xFF, 0xB0, 0x17, 0x40, 0x4F, 0xFB, 0x01, 0x74, 0x04, 0xFF,
  0xB0, 0x17, 0x40, 0x4F, 0xFB, 0x01, 0x74, 0x04, 0xFF, 0xB0, 0x17, 0x68, 0x23, 0x69, 0xCF, 0xD0,
  0x17, 0x74, 0x81, 0x36, 0xCF, 0x90, 0x17, 0x76, 0x09, 0xF9, 0x01, 0x77, 0x60, 0x9F, 0x90, 0x17,
  0x76, 0x09, 0xF9, 0x01, 0x77, 0x60, 0x9F, 0x90, 0x17, 0x76, 0x09, 0xF9, 0x01, 0x77, 0x60, 0x9F,
  0x90, 0x17, 0x76, 0x09, 0xF9, 0x01, 0x77, 0x60, 0x9F, 0x90, 0x17, 0x76, 0x09, 0xF9, 0x01, 0x77,
  0x60, 0x9F, 0x90, 0x17, 0x76, 0x09, 0xF9, 0x01, 0x77, 0x60, 0x9F, 0x90, 0x17, 0x76, 0x09, 0xF9,
  0x01, 0x77, 0x60, 0x9F, 0x90, 0x17, 0x76, 0x09, 0xF9, 0x01, 0x77, 0x60, 0x9F, 0x90, 0x17, 0x76,
  0x09, 0xF9, 0x01, 0x77, 0x60, 0x9F, 0x90, 0x17, 0x76, 0x09, 0xF9, 0x01, 0x77, 0x60, 0x9F, 0x90,
  0x17, 0x76, 0x09, 0xF9, 0x01, 0x77, 0x60, 0x9F, 0x90, 0x17, 0x76, 0x09, 0xF9, 0x01, 0x77, 0x60,
  0x9F, 0x90, 0x17, 0x76, 0x09, 0xF9, 0x01, 0x77, 0x60, 0x9F, 0x90, 0x17, 0x76, 0x09, 0xF9, 0x01,
  0x77, 0x60, 0x9F, 0x90, 0x17, 0x76, 0x09, 0xF9, 0x01, 0x77, 0x60, 0x9F, 0x90, 0x17, 0x78, 0x41,
  0x36, 0x8B, 0xDF, 0xA8, 0x4E, 0xC9, 0x63, 0x14, 0x83, 0x16, 0x9B, 0xEF, 0xFF, 0x83, 0xDB, 0x85,
  0x6F, 0xFF, 0xF9, 0x06, 0xFF, 0xFF, 0x90, 0x6F, 0xFF, 0xF9, 0x06, 0xFF, 0xFF, 0x90, 0x6F, 0xFF,
  0xF9,
  // "m" (U+006D)
  0x75, 0x83, 0x47, 0x75, 0x27, 0x84, 0x15, 0x76, 0x51, 0x40, 0x3D, 0x0C, 0x30, 0x70, 0xED, 0x0A,
  0x50, 0x8E, 0x07, 0x30, 0x3E, 0x20, 0x7F, 0x90, 0xB3, 0x0A, 0xF9, 0x07, 0x20, 0x3E, 0x04, 0x02,
  0xFB, 0x81, 0x50, 0x7F, 0xA8, 0x2E, 0x10, 0x3E, 0x08, 0x0A, 0xFB, 0x81, 0xB1, 0xEF, 0xB8, 0x15,
  0x03, 0xFF, 0xD0, 0x9F, 0xC8, 0x19, 0x03, 0xFF, 0xFF, 0xB8, 0x1C, 0x03, 0xF9, 0x82, 0xD7, 0x8D,
  0xFA, 0x81, 0xA7, 0xAF, 0x81, 0xE0, 0x3F, 0x0D, 0x30, 0x2F, 0x90, 0x83, 0x0A, 0xF1, 0x03, 0xF0,
  0x84, 0x0D, 0xF0, 0x13, 0x05, 0xF0, 0x10, 0x3F, 0x06, 0x40, 0xCE, 0x0E, 0x40, 0x4F, 0x02, 0x03,
  0xF0, 0x44, 0x0C, 0xE0, 0xD4, 0x04, 0xF0, 0x20, 0x3F, 0x04, 0x40, 0xCE, 0x0D, 0x40, 0x4F, 0x00,
  0x3F, 0x04, 0x40, 0xCE, 0x0D, 0x40, 0x4F, 0x00, 0x3F, 0x04, 0x40, 0xCE, 0x0D, 0x40, 0x4F, 0x00,
  0x3F, 0x04, 0x40, 0xCE, 0x0D, 0x40, 0x4F, 0x00, 0x3F, 0x04, 0x40, 0xCE, 0x0D, 0x40, 0x4F, 0x00,
  0x3F, 0x04, 0x40, 0xCE, 0x0D, 0x40, 0x4F, 0x00, 0x3F, 0x04, 0x40, 0xCE, 0x0D, 0x40, 0x4F, 0x00,
  0x3F, 0x04, 0x40, 0xCE, 0x0D, 0x40, 0x4F, 0x00, 0x3F, 0x04, 0x40, 0xCE, 0x0D, 0x40, 0x4F, 0x00,
  0x3F, 0x04, 0x40, 0xCE, 0x0D, 0x40, 0x4F, 0x00, 0x3F, 0x04, 0x40, 0xCE, 0x0D, 0x40, 0x4F, 0x00,
  0x3F, 0x04, 0x40, 0xCE, 0x0D, 0x40, 0x4F, 0x00, 0x3F, 0x04, 0x40, 0xCE, 0x0D, 0x40, 0x4F, 0x00,
  0x3F, 0x04, 0x40, 0xCE, 0x0D, 0x40, 0x4F, 0x00, 0x3F, 0x04, 0x40, 0xCE, 0x0D, 0x40, 0x4F, 0x00,
  0x3F, 0x04, 0x40, 0xCE, 0x0D, 0x40, 0x4F, 0x00, 0x3F, 0x04, 0x40, 0xCE, 0x0D, 0x40, 0x4F, 0x00,
  0x3F, 0x04, 0x40, 0xCE, 0x0D, 0x40, 0x4F, 0x00, 0x3F, 0x04, 0x40, 0xCE, 0x0D, 0x40, 0x4F, 0x00,
  0x3F, 0x04, 0x40, 0xCE, 0x0D, 0x40, 0x4F, 0x00, 0x3F, 0x04, 0x40, 0xCE, 0x0D, 0x40, 0x4F, 0x03,
  // "n" (U+006E)
  0x77, 0x18, 0x53, 0x56, 0x76, 0x53, 0x71, 0x0A, 0xE0, 0x14, 0x81, 0x39, 0xEF, 0x90, 0xB0, 0x45,
  0x0A, 0xE0, 0x63, 0x09, 0xFE, 0x0B, 0x01, 0x30, 0xAE, 0x82, 0xC0, 0x1C, 0xFF, 0x90, 0xD0, 0x22,
  0x0A, 0xF0, 0x20, 0xBF, 0xFB, 0x0C, 0x20, 0xAF, 0x0E, 0xFF, 0xD8, 0x17, 0x0A, 0xFF, 0xFE, 0x81,
  0xE0, 0xAF, 0xD8, 0x3D, 0x97, 0x8A, 0xFC, 0x05, 0x0A, 0xFB, 0x0E, 0x04, 0x50, 0x10, 0xBF, 0xA0,
  0x90, 0xAF, 0xB0, 0x37, 0x10, 0xDF, 0x90, 0xC0, 0xAF, 0xA0, 0x77, 0x20, 0x5F, 0x90, 0xD0, 0xAF,
  0x90, 0xE0, 0x17, 0x3F, 0x90, 0xE0, 0xAF, 0x90, 0xA7, 0x40, 0xCF, 0x90, 0xAF, 0x90, 0x67, 0x40,
  0xBF, 0x90, 0xAF, 0x90, 0x47, 0x40, 0xAF, 0x90, 0xAF, 0x90, 0x17, 0x40, 0xAF, 0x90, 0xAF, 0x97,
  0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50,
  0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF,
  0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90,
  0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF,
  0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97,
  0x50, 0xAF, 0x90,
  // "o" (U+006F)
  0x75, 0x86, 0x24, 0x67, 0x76, 0x53, 0x77, 0x78, 0x14, 0x9E, 0xFA, 0x0B, 0x06, 0x77, 0x20, 0x40,
  0xCF, 0xF0, 0xE0, 0x67, 0x60, 0x9F, 0xFC, 0x0C, 0x01, 0x72, 0x01, 0x0C, 0xFF, 0xE0, 0xD0, 0x27,
  0x10, 0xCF, 0xFF, 0x90, 0xD0, 0x16, 0x09, 0xFF, 0xFB, 0x0B, 0x50, 0x3F, 0xB8, 0x4E, 0x98, 0x79,
  0xDF, 0xB0, 0x54, 0x0C, 0xFA, 0x07, 0x60, 0x50, 0xEF, 0x90, 0xD3, 0x03, 0xFA, 0x05, 0x71, 0x03,
  0xFA, 0x05, 0x20, 0x9F, 0x90, 0xA7, 0x30, 0x9F, 0x90, 0xA2, 0x0D, 0xF9, 0x02, 0x73, 0x01, 0xF9,
  0x81, 0xE0, 0x2F, 0x90, 0xC7, 0x50, 0xCF, 0x90, 0x20, 0x4F, 0x90, 0x87, 0x50, 0x8F, 0x90, 0x50,
  0x6F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x70, 0x8F, 0x90, 0x47, 0x50, 0x4F, 0x90, 0x08, 0xF9, 0x03,
  0x75, 0x03, 0xF9, 0x00, 0x8F, 0x90, 0x37, 0x50, 0x3F, 0x90, 0x08, 0xF9, 0x04, 0x75, 0x04, 0xF9,
  0x08, 0x07, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x07, 0x05, 0xF9, 0x08, 0x75, 0x08, 0xF9, 0x04, 0x02,
  0xF9, 0x0C, 0x75, 0x0C, 0xF9, 0x81, 0x20, 0xEF, 0x90, 0x27, 0x30, 0x1F, 0x90, 0xD2, 0x09, 0xF9,
  0x0A, 0x73, 0x09, 0xF9, 0x09, 0x20, 0x4F, 0xA0, 0x57, 0x10, 0x4F, 0xA0, 0x33, 0x0C, 0xFA, 0x07,
  0x60, 0x50, 0xEF, 0x90, 0xC4, 0x04, 0xFB, 0x84, 0xE9, 0x77, 0x9D, 0xFB, 0x04, 0x50, 0xAF, 0xFF,
  0xB0, 0xA7, 0x0D, 0xFF, 0xF9, 0x0D, 0x01, 0x70, 0x10, 0xDF, 0xFE, 0x0D, 0x02, 0x72, 0x01, 0x0B,
  0xFF, 0xC0, 0xB0, 0x17, 0x50, 0x60, 0xDF, 0xF0, 0xE0, 0x67, 0x72, 0x05, 0x0A, 0xFB, 0x0B, 0x06,
  0x77, 0x78, 0x62, 0x56, 0x77, 0x65, 0x37, 0x50,
  // "p" (U+0070)
  0x77, 0x18, 0x52, 0x56, 0x76, 0x52, 0x72, 0x0A, 0xE0, 0x14, 0x81, 0x18, 0xDF, 0x0D, 0x06, 0x70,
  0xAE, 0x06, 0x30, 0x8F, 0xD0, 0xD0, 0x35, 0x0A, 0xE0, 0xC2, 0x0B, 0xFF, 0x0E, 0x04, 0x40, 0xAF,
  0x02, 0x0A, 0xFF, 0xA0, 0xE0, 0x23, 0x0A, 0xF0, 0xEF, 0xFC, 0x0C, 0x30, 0xAF, 0xFF, 0xE0, 0x62,
  0x0A, 0xFD, 0x83, 0xB8, 0x78, 0xCF, 0xB0, 0xD2, 0x0A, 0xFB, 0x0B, 0x02, 0x50, 0x40, 0xEF, 0xA8,
  0x14, 0x0A, 0xFA, 0x0B, 0x71, 0x03, 0xFA, 0x81, 0x80, 0xAF, 0x90, 0xE0, 0x17, 0x20, 0x8F, 0x98,
  0x1D, 0x0A, 0xF9, 0x08, 0x73, 0x02, 0xFA, 0x01, 0x0A, 0xF9, 0x03, 0x74, 0x0D, 0xF9, 0x03, 0x0A,
  0xF9, 0x75, 0x0A, 0xF9, 0x05, 0x0A, 0xF0, 0xD7, 0x50, 0x8F, 0x90, 0x70, 0xAF, 0x0D, 0x75, 0x07,
  0xF9, 0x08, 0x0A, 0xF0, 0xC7, 0x50, 0x6F, 0x90, 0x80, 0xAF, 0x0D, 0x75, 0x06, 0xF9, 0x08, 0x0A,
  0xF0, 0xD7, 0x50, 0x7F, 0x90, 0x70, 0xAF, 0x0E, 0x75, 0x08, 0xF9, 0x06, 0x0A, 0xF9, 0x02, 0x74,
  0x0A, 0xF9, 0x05, 0x0A, 0xF9, 0x05, 0x74, 0x0D, 0xF9, 0x03, 0x0A, 0xF9, 0x0A, 0x73, 0x01, 0xFA,
  0x10, 0xAF, 0xA0, 0x27, 0x20, 0x8F, 0x98, 0x1C, 0x0A, 0xFA, 0x0C, 0x71, 0x02, 0x0E, 0xF9, 0x81,
  0x80, 0xAF, 0xB0, 0xC0, 0x25, 0x03, 0x0D, 0xFA, 0x81, 0x20, 0xAF, 0xD8, 0x3B, 0x87, 0x8C, 0xFB,
  0x0C, 0x20, 0xAF, 0xFF, 0xE0, 0x32, 0x0A, 0xFF, 0xFD, 0x09, 0x30, 0xAF, 0x0B, 0x0E, 0xFF, 0xA0,
  0xD0, 0x13, 0x0A, 0xF8, 0x18, 0x2D, 0xFF, 0x0D, 0x01, 0x40, 0xAF, 0x82, 0xA0, 0x1A, 0xFD, 0x0A,
  0x01, 0x50, 0xAF, 0x0B, 0x38, 0x13, 0xAE, 0xF0, 0xB0, 0x47, 0x0A, 0xF0, 0xC6, 0x85, 0x35, 0x77,
  0x64, 0x17, 0x20, 0xAF, 0x0C, 0x77, 0x71, 0x0A, 0xF0, 0xC7, 0x77, 0x10, 0xAF, 0x0C, 0x77, 0x71,
  0x0A, 0xF0, 0xC7, 0x77, 0x10, 0xAF, 0x0C, 0x77, 0x71, 0x0A, 0xF0, 0xC7, 0x77, 0x10, 0xAF, 0x0C,
  0x77, 0x71, 0x0A, 0xF0, 0xC7, 0x77, 0x10, 0xAF, 0x0C, 0x77, 0x71, 0x0A, 0xF0, 0xC7, 0x77, 0x10,
  0xAF, 0x0C, 0x77, 0x71, 0x0A, 0xF0, 0xC7, 0x77, 0x10, 0xAF, 0x0C, 0x77, 0x71,
  // "q" (U+0071)
  0x72, 0x85, 0x14, 0x67, 0x76, 0x37, 0x77, 0x10, 0x50, 0xCF, 0x90, 0xA0, 0x34, 0x01, 0xE0, 0xA5,
  0x02, 0x0C, 0xFD, 0x0B, 0x01, 0x20, 0x5E, 0x0A, 0x40, 0x30, 0xEF, 0xF8, 0x2E, 0x20, 0xAE, 0x0A,
  0x30, 0x10, 0xEF, 0xFA, 0x81, 0xE2, 0xEE, 0x0A, 0x30, 0xBF, 0xFF, 0xD0, 0xA2, 0x05, 0xFF, 0xFE,
  0x0A, 0x20, 0xDF, 0xB8, 0x4D, 0x97, 0x7A, 0xEF, 0xC8, 0x1A, 0x03, 0xFB, 0x06, 0x60, 0x8F, 0xB8,
  0x1A, 0x08, 0xFA, 0x05, 0x71, 0x06, 0xFA, 0x81, 0xA0, 0xDF, 0x90, 0xB7, 0x30, 0xBF, 0x90, 0xA1,
  0xFA, 0x03, 0x73, 0x04, 0xF9, 0x0A, 0x03, 0xF9, 0x0E, 0x75, 0x0E, 0xF0, 0xA0, 0x5F, 0x90, 0xB7,
  0x50, 0xBF, 0x0A, 0x07, 0xF9, 0x08, 0x75, 0x08, 0xF0, 0xA0, 0x8F, 0x90, 0x77, 0x50, 0x7F, 0x0A,
  0x08, 0xF9, 0x06, 0x75, 0x06, 0xF0, 0xA0, 0x9F, 0x90, 0x67, 0x50, 0x6F, 0x0A, 0x08, 0xF9, 0x07,
  0x75, 0x06, 0xF0, 0xA0, 0x7F, 0x90, 0x87, 0x50, 0x7F, 0x0A, 0x06, 0xF9, 0x0A, 0x75, 0x09, 0xF0,
  0xA0, 0x4F, 0x90, 0xD7, 0x50, 0xCF, 0x0A, 0x01, 0xFA, 0x02, 0x73, 0x02, 0xF9, 0x81, 0xA0, 0xDF,
  0x90, 0x97, 0x30, 0x9F, 0x98, 0x1A, 0x09, 0xFA, 0x04, 0x71, 0x03, 0xFA, 0x81, 0xA0, 0x4F, 0xA0,
  0xE0, 0x56, 0x05, 0x0E, 0xFA, 0x0A, 0x20, 0xDF, 0xB8, 0x4D, 0x97, 0x79, 0xDF, 0xC0, 0xA2, 0x06,
  0xFF, 0xFE, 0x0A, 0x30, 0xDF, 0xFC, 0x0E, 0xF0, 0xA3, 0x02, 0x0E, 0xFF, 0xA0, 0xA0, 0x8F, 0x0A,
  0x40, 0x40, 0xEF, 0xF8, 0x1B, 0x09, 0xF0, 0xA5, 0x03, 0x0D, 0xFD, 0x08, 0x20, 0xBF, 0x0A, 0x70,
  0x70, 0xDF, 0x81, 0xE8, 0x23, 0x0C, 0xF0, 0xA7, 0x28, 0x52, 0x56, 0x77, 0x52, 0x60, 0xCF, 0x0A,
  0x77, 0x71, 0x0C, 0xF0, 0xA7, 0x77, 0x10, 0xCF, 0x0A, 0x77, 0x71, 0x0C, 0xF0, 0xA7, 0x77, 0x10,
  0xCF, 0x0A, 0x77, 0x71, 0x0C, 0xF0, 0xA7, 0x77, 0x10, 0xCF, 0x0A, 0x77, 0x71, 0x0C, 0xF0, 0xA7,
  0x77, 0x10, 0xCF, 0x0A, 0x77, 0x71, 0x0C, 0xF0, 0xA7, 0x77, 0x10, 0xCF, 0x0A, 0x77, 0x71, 0x0C,
  0xF0, 0xA7, 0x77, 0x10, 0xCF, 0x0A, 0x77, 0x71, 0x0C, 0xF0, 0xA0,
  // "r" (U+0072)
  0x77, 0x73, 0x85, 0x35, 0x77, 0x65, 0x34, 0x0E, 0xFD, 0x0A, 0x58, 0x11, 0x8E, 0xF9, 0x09, 0x20,
  0xEF, 0xD0, 0xE4, 0x05, 0x0E, 0xFB, 0x0A, 0x20, 0xEF, 0xE0, 0x22, 0x07, 0xFD, 0x05, 0x20, 0xEF,
  0xE8, 0x16, 0x06, 0xFE, 0x01, 0x20, 0xEF, 0xE0, 0x90, 0x2F, 0xE0, 0xC3, 0x0E, 0xFE, 0x0E, 0x0D,
  0xFE, 0x07, 0x48, 0x43, 0x57, 0x9B, 0xDF, 0xFF, 0x90, 0x37, 0x3F, 0xF8, 0x6C, 0x98, 0x89, 0xCF,
  0xD7, 0x4F, 0xD0, 0x90, 0x17, 0x03, 0x74, 0xFC, 0x05, 0x77, 0x7F, 0xB0, 0x77, 0x77, 0x1F, 0xA0,
  0xD7, 0x77, 0x2F, 0xA0, 0x67, 0x77, 0x2F, 0xA0, 0x17, 0x77, 0x2F, 0x90, 0xD7, 0x77, 0x3F, 0x90,
  0xB7, 0x77, 0x3F, 0x90, 0xA7, 0x77, 0x3F, 0x90, 0xA7, 0x77, 0x3F, 0x90, 0xA7, 0x77, 0x3F, 0x90,
  0xA7, 0x77, 0x3F, 0x90, 0xA7, 0x77, 0x3F, 0x90, 0xA7, 0x77, 0x3F, 0x90, 0xA7, 0x77, 0x3F, 0x90,
  0xA7, 0x77, 0x3F, 0x90, 0xA7, 0x75, 0x83, 0x14, 0x8B, 0xEF, 0xA8, 0x2D, 0xA7, 0x37, 0x48, 0x22,
  0x7A, 0xEF, 0xFD, 0x82, 0xD9, 0x61, 0x60, 0x8F, 0xFF, 0xC0, 0x46, 0x08, 0xFF, 0xFC, 0x04, 0x60,
  0x8F, 0xFF, 0xC0, 0x46, 0x08, 0xFF, 0xFC, 0x04, 0x60, 0x8F, 0xFF, 0xC0, 0x46,
  // "s" (U+0073)
  0x73, 0x87, 0x34, 0x56, 0x76, 0x65, 0x37, 0x71, 0x81, 0x28, 0xBF, 0xC8, 0x2E, 0xA6, 0x37, 0x10,
  0x20, 0xAF, 0xFC, 0x81, 0xD8, 0x24, 0x04, 0x0E, 0xFF, 0xF0, 0xE3, 0x03, 0xFF, 0xFA, 0x08, 0x30,
  0xDF, 0xFF, 0xA0, 0x22, 0x05, 0xFF, 0xFA, 0x0A, 0x30, 0xAF, 0xA8, 0x6C, 0x87, 0x78, 0x9B, 0xDE,
  0x04, 0x30, 0xDF, 0x90, 0x47, 0x18, 0x41, 0x58, 0xDF, 0xD4, 0x0E, 0xF0, 0xE7, 0x60, 0x30, 0x44,
  0x0E, 0xF9, 0x02, 0x77, 0x40, 0xCF, 0x90, 0xD0, 0x37, 0x73, 0x09, 0xFB, 0x81, 0xC6, 0x17, 0x70,
  0x3F, 0xE0, 0xA0, 0x57, 0x60, 0x8F, 0xF8, 0x1E, 0x93, 0x74, 0x0A, 0xFF, 0xA0, 0xC0, 0x47, 0x30,
  0x7F, 0xFB, 0x0B, 0x02, 0x72, 0x02, 0x0A, 0xFF, 0xB0, 0x57, 0x38, 0x12, 0x9E, 0xFF, 0x90, 0x47,
  0x50, 0x60, 0xCF, 0xE0, 0xE0, 0x17, 0x68, 0x13, 0x9E, 0xFC, 0x08, 0x77, 0x20, 0x50, 0xCF, 0xA0,
  0xD7, 0x74, 0x07, 0xFA, 0x01, 0x77, 0x40, 0xDF, 0x98, 0x32, 0x3D, 0x72, 0x77, 0x0C, 0xF9, 0x02,
  0x03, 0xB8, 0x2C, 0x84, 0x17, 0x20, 0x5F, 0xA1, 0x03, 0xF8, 0x7D, 0xB9, 0x87, 0x78, 0x9D, 0xFA,
  0x81, 0xE0, 0x3F, 0xFF, 0xC8, 0x18, 0x03, 0xFF, 0xFC, 0x81, 0x20, 0x3F, 0xFF, 0xB0, 0x62, 0x03,
  0xFF, 0xFA, 0x06, 0x30, 0x20, 0xDF, 0xFE, 0x0B, 0x03, 0x68, 0x23, 0x7B, 0xEF, 0xE8, 0x1B, 0x72,
  0x75, 0x89, 0x21, 0x34, 0x66, 0x77, 0x76, 0x54, 0x17, 0x30,
  // "t" (U+0074)
  0x72, 0x02, 0x80, 0x27, 0x02, 0x77, 0x70, 0x6E, 0x05, 0x77, 0x70, 0x8E, 0x05, 0x77, 0x70, 0xBE,
  0x05, 0x77, 0x70, 0xEE, 0x05, 0x77, 0x60, 0x1F, 0x05, 0x77, 0x60, 0x3F, 0x05, 0x77, 0x60, 0x6F,
  0x05, 0x77, 0x60, 0x9F, 0x05, 0x77, 0x28, 0x22, 0x69, 0xDF, 0xFE, 0x83, 0xA3, 0x7B, 0xEF, 0xFF,
  0xB0, 0xA0, 0xCF, 0xFF, 0xE0, 0xA0, 0xCF, 0xFF, 0xE0, 0xA0, 0xCF, 0xFF, 0xE0, 0xA0, 0xCF, 0xFF,
  0xE0, 0xA0, 0xC8, 0x02, 0xEF, 0xB8, 0x07, 0xE0, 0xA7, 0x04, 0xF9, 0x05, 0x77, 0x50, 0x4F, 0x90,
  0x57, 0x75, 0x04, 0xF9, 0x05, 0x77, 0x50, 0x4F, 0x90, 0x57, 0x75, 0x04, 0xF9, 0x05, 0x77, 0x50,
  0x4F, 0x90, 0x57, 0x75, 0x04, 0xF9, 0x05, 0x77, 0x50, 0x4F, 0x90, 0x57, 0x75, 0x04, 0xF9, 0x05,
  0x77, 0x50, 0x4F, 0x90, 0x57, 0x75, 0x04, 0xF9, 0x05, 0x77, 0x50, 0x4F, 0x90, 0x57, 0x75, 0x04,
  0xF9, 0x05, 0x77, 0x50, 0x4F, 0x90, 0x67, 0x75, 0x04, 0xF9, 0x07, 0x77, 0x50, 0x3F, 0x90, 0xA7,
  0x75, 0x01, 0xFA, 0x02, 0x77, 0x50, 0xEF, 0x90, 0xD0, 0x37, 0x10, 0x10, 0x37, 0x10, 0xAF, 0xB8,
  0x6C, 0x97, 0x78, 0x9B, 0xEA, 0x71, 0x05, 0xFF, 0xE7, 0x20, 0xCF, 0xFD, 0x72, 0x03, 0xFF, 0xD7,
  0x30, 0x5F, 0xFC, 0x74, 0x02, 0x0C, 0xFF, 0xA7, 0x68, 0x14, 0xAE, 0xFB, 0x81, 0xDA, 0x57, 0x72,
  0x89, 0x02, 0x46, 0x67, 0x76, 0x53, 0x13,
  // "u" (U+0075)
  0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9,
  0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A,
  0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75,
  0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9,
  0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A,
  0xF9, 0x0A, 0x74, 0x01, 0xF9, 0x0A, 0xF9, 0x0A, 0x74, 0x01, 0xF9, 0x0A, 0xF9, 0x0A, 0x74, 0x03,
  0xF9, 0x0A, 0xF9, 0x0B, 0x74, 0x06, 0xF9, 0x0A, 0xF9, 0x0C, 0x74, 0x08, 0xF9, 0x0A, 0x0E, 0xF9,
  0x74, 0x0D, 0xF9, 0x0A, 0x0D, 0xF9, 0x04, 0x72, 0x04, 0xFA, 0x0A, 0x0C, 0xF9, 0x0B, 0x71, 0x01,
  0x0D, 0xFA, 0x0A, 0x09, 0xFA, 0x08, 0x60, 0x30, 0xCF, 0xB0, 0xA0, 0x5F, 0xB8, 0x4D, 0x97, 0x78,
  0xCF, 0xD8, 0x1A, 0x0E, 0xFF, 0xFE, 0x81, 0xA0, 0x7F, 0xFD, 0x0E, 0xF0, 0xA2, 0x0C, 0xFF, 0xB0,
  0xA0, 0x2F, 0x0A, 0x20, 0x20, 0xDF, 0xF9, 0x0B, 0x20, 0xCE, 0x0A, 0x30, 0x10, 0xBF, 0xD0, 0xE0,
  0x73, 0x06, 0xE0, 0xA5, 0x04, 0x0B, 0xF9, 0x81, 0xD8, 0x14, 0x01, 0xE0, 0xA7, 0x18, 0x54, 0x57,
  0x76, 0x41, 0x77, 0x10,
  // "v" (U+0076)
  0x09, 0xF9, 0x0B, 0x77, 0x08, 0xF9, 0x09, 0x03, 0xFA, 0x01, 0x76, 0x0D, 0xF9, 0x81, 0x30, 0xDF,
  0x90, 0x57, 0x50, 0x2F, 0x90, 0xD2, 0x07, 0xF9, 0x0A, 0x75, 0x07, 0xF9, 0x07, 0x20, 0x1F, 0xA7,
  0x50, 0xCF, 0x90, 0x13, 0x0B, 0xF9, 0x05, 0x73, 0x02, 0xF9, 0x0A, 0x40, 0x5F, 0x90, 0xA7, 0x30,
  0x7F, 0x90, 0x45, 0x0E, 0xF0, 0xE7, 0x30, 0xCF, 0x0E, 0x60, 0x8F, 0x90, 0x57, 0x10, 0x1F, 0x90,
  0x86, 0x02, 0xF9, 0x0A, 0x71, 0x06, 0xF9, 0x02, 0x70, 0xCF, 0x0E, 0x71, 0x0B, 0xF0, 0xC7, 0x10,
  0x6F, 0x90, 0x46, 0x01, 0xF9, 0x06, 0x71, 0x01, 0xF9, 0x09, 0x60, 0x6F, 0x0E, 0x73, 0x0A, 0xF0,
  0xE6, 0x0B, 0xF0, 0x97, 0x30, 0x4F, 0x90, 0x44, 0x01, 0xF9, 0x03, 0x74, 0x0D, 0xF0, 0x94, 0x05,
  0xF0, 0xD7, 0x50, 0x8F, 0x0E, 0x40, 0xAF, 0x07, 0x75, 0x02, 0xF9, 0x03, 0x3F, 0x90, 0x17, 0x60,
  0xBF, 0x08, 0x20, 0x5F, 0x0B, 0x77, 0x05, 0xF0, 0xD2, 0x09, 0xF0, 0x57, 0x71, 0x0E, 0xF8, 0x12,
  0x0D, 0xE0, 0xE7, 0x72, 0x09, 0xF0, 0x60, 0x2F, 0x08, 0x77, 0x20, 0x3F, 0x09, 0x05, 0xF0, 0x37,
  0x73, 0x0D, 0xE0, 0xC0, 0x8E, 0x0C, 0x77, 0x40, 0x7F, 0x0B, 0xE0, 0x67, 0x74, 0x01, 0xFF, 0x01,
  0x77, 0x50, 0xBF, 0xD0, 0xA7, 0x76, 0x05, 0xFD, 0x04, 0x77, 0x70, 0xEF, 0xB0, 0xD7, 0x77, 0x10,
  0x9F, 0xB0, 0x87, 0x77, 0x10, 0x3F, 0xB0, 0x27, 0x77, 0x20, 0xCF, 0x90, 0xB7, 0x50,
  // "w" (U+0077)
  0x0B, 0xF0, 0x27, 0x75, 0xF0, 0xC0, 0x9F, 0x03, 0x77, 0x40, 0x1F, 0x0A, 0x07, 0xF0, 0x47, 0x74,
  0x02, 0xF0, 0x70, 0x4F, 0x06, 0x77, 0x40, 0x3F, 0x05, 0x02, 0xF0, 0x75, 0x0B, 0xE0, 0xD5, 0x05,
  0xF0, 0x31, 0xF0, 0x95, 0x0E, 0xF0, 0x14, 0x06, 0xF8, 0x11, 0x0D, 0xE0, 0xA4, 0x02, 0xF9, 0x04,
  0x40, 0x8E, 0x0E, 0x20, 0xBE, 0x0C, 0x40, 0x5F, 0x90, 0x74, 0x09, 0xE0, 0xC2, 0x09, 0xE0, 0xD4,
  0x08, 0xF9, 0x0A, 0x40, 0xAE, 0x0A, 0x20, 0x6E, 0x0E, 0x40, 0xBF, 0x90, 0xD4, 0x0C, 0xE0, 0x72,
  0x04, 0xF4, 0x0E, 0xFA, 0x01, 0x30, 0xDE, 0x05, 0x20, 0x2F, 0x02, 0x20, 0x2F, 0xB0, 0x43, 0xF0,
  0x33, 0xF0, 0x32, 0x05, 0xFB, 0x07, 0x20, 0x1F, 0x01, 0x30, 0xDE, 0x05, 0x20, 0x8C, 0x00, 0xDC,
  0x0A, 0x20, 0x2E, 0x0E, 0x40, 0xBE, 0x06, 0x20, 0xBC, 0x00, 0xBC, 0x0D, 0x20, 0x4E, 0x0C, 0x40,
  0x9E, 0x07, 0x20, 0xEC, 0x00, 0x8D, 0x81, 0x10, 0x5E, 0x09, 0x40, 0x6E, 0x81, 0x90, 0x2D, 0x00,
  0x6D, 0x81, 0x40, 0x6E, 0x07, 0x40, 0x4E, 0x81, 0xA0, 0x5D, 0x00, 0x3D, 0x81, 0x70, 0x7E, 0x05,
  0x40, 0x2E, 0x81, 0xC0, 0x7D, 0x00, 0x1D, 0x81, 0x90, 0x9E, 0x03, 0x5E, 0x81, 0xD0, 0xAC, 0x0E,
  0x20, 0xEC, 0x81, 0xC0, 0xAE, 0x01, 0x50, 0xDE, 0x10, 0xCC, 0x0B, 0x20, 0xBC, 0x81, 0xE0, 0xBD,
  0x0E, 0x60, 0xBE, 0x01, 0x0E, 0xC0, 0x82, 0x08, 0xD0, 0x10, 0xCD, 0x0C, 0x60, 0x8E, 0x04, 0xD0,
  0x52, 0x05, 0xD0, 0x40, 0xED, 0x09, 0x60, 0x6E, 0x07, 0xD0, 0x22, 0x02, 0xD0, 0x7E, 0x07, 0x60,
  0x4E, 0x0C, 0xC0, 0xE4, 0xD0, 0xCE, 0x05, 0x60, 0x2F, 0xC0, 0xC4, 0x0C, 0xFC, 0x03, 0x7F, 0xC0,
  0x94, 0x09, 0xFC, 0x71, 0x0D, 0xFB, 0x06, 0x40, 0x7F, 0xB0, 0xE7, 0x10, 0xBF, 0xB0, 0x34, 0x04,
  0xFB, 0x0B, 0x71, 0x08, 0xFB, 0x50, 0x1F, 0xB0, 0x97, 0x10, 0x6F, 0xA0, 0xD6, 0x0E, 0xFA, 0x07,
  0x71, 0x04, 0xFA, 0x0A, 0x60, 0xBF, 0xA0, 0x54,
  // "x" (U+0078)
  0x10, 0xDF, 0xA0, 0x77, 0x40, 0xDF, 0xA8, 0x16, 0x03, 0xFA, 0x0E, 0x01, 0x72, 0x08, 0xFA, 0x0B,
  0x30, 0x7F, 0xA0, 0xA7, 0x10, 0x3F, 0xA0, 0xE0, 0x14, 0x0C, 0xFA, 0x03, 0x70, 0xCF, 0xA0, 0x45,
  0x02, 0x0E, 0xF9, 0x0C, 0x60, 0x6F, 0xA0, 0x87, 0x06, 0xFA, 0x06, 0x40, 0x10, 0xEF, 0x90, 0xC7,
  0x20, 0xAF, 0x90, 0xE0, 0x13, 0x09, 0xFA, 0x02, 0x72, 0x01, 0x0E, 0xF9, 0x09, 0x20, 0x3F, 0xA0,
  0x67, 0x40, 0x4F, 0xA8, 0x12, 0x0D, 0xF9, 0x0A, 0x76, 0x09, 0xF9, 0x0B, 0x07, 0xF9, 0x0E, 0x01,
  0x77, 0x0D, 0xFF, 0xB0, 0x47, 0x71, 0x03, 0xFF, 0xA0, 0x87, 0x73, 0x07, 0xFF, 0x0C, 0x77, 0x50,
  0xCF, 0xD0, 0xE0, 0x27, 0x75, 0x02, 0x0E, 0xFC, 0x06, 0x77, 0x70, 0x6F, 0xB0, 0xB7, 0x77, 0x10,
  0xBF, 0xB0, 0xE0, 0x17, 0x76, 0x07, 0xFD, 0x0B, 0x77, 0x50, 0x3F, 0xF0, 0x67, 0x74, 0x0D, 0xFF,
  0x0E, 0x02, 0x77, 0x20, 0x9F, 0xFA, 0x0C, 0x77, 0x10, 0x4F, 0xA0, 0xDF, 0x90, 0x77, 0x60, 0x10,
  0xEF, 0x90, 0x80, 0x3F, 0xA0, 0x37, 0x50, 0xBF, 0x90, 0xD2, 0x09, 0xF9, 0x0D, 0x74, 0x07, 0xFA,
  0x04, 0x20, 0x10, 0xEF, 0x90, 0x97, 0x20, 0x2F, 0xA0, 0xA4, 0x07, 0xFA, 0x04, 0x71, 0x0D, 0xF9,
  0x0E, 0x01, 0x50, 0xDF, 0x90, 0xD0, 0x16, 0x09, 0xFA, 0x06, 0x60, 0x4F, 0xA0, 0xA5, 0x04, 0xFA,
  0x0C, 0x71, 0x0A, 0xFA, 0x05, 0x30, 0x10, 0xEF, 0xA0, 0x37, 0x10, 0x2F, 0xA0, 0xE0, 0x12, 0x0B,
  0xFA, 0x08, 0x73, 0x08, 0xFA, 0x81, 0xB0, 0x6F, 0xA0, 0xD7, 0x50, 0xDF, 0xA0, 0x70,
  // "y" (U+0079)
  0x09, 0xF9, 0x0D, 0x77, 0x0B, 0xF9, 0x09, 0x03, 0xFA, 0x03, 0x76, 0xFA, 0x81, 0x30, 0xCF, 0x90,
  0x87, 0x50, 0x4F, 0x90, 0xD2, 0x05, 0xF9, 0x0D, 0x75, 0x09, 0xF9, 0x07, 0x30, 0xEF, 0x90, 0x37,
  0x40, 0xEF, 0x90, 0x13, 0x08, 0xF9, 0x08, 0x73, 0x03, 0xF9, 0x0B, 0x40, 0x2F, 0x90, 0xD7, 0x30,
  0x8F, 0x90, 0x55, 0x0B, 0xF9, 0x03, 0x72, 0x0C, 0xF0, 0xE6, 0x05, 0xF9, 0x09, 0x71, 0x02, 0xF9,
  0x09, 0x70, 0xEF, 0x0E, 0x71, 0x06, 0xF9, 0x03, 0x70, 0x8F, 0x90, 0x47, 0x0B, 0xF0, 0xD7, 0x10,
  0x2F, 0x90, 0x97, 0xF9, 0x07, 0x72, 0x0B, 0xF0, 0xE6, 0x05, 0xF9, 0x01, 0x72, 0x05, 0xF9, 0x04,
  0x50, 0x9F, 0x0B, 0x74, 0x0E, 0xF0, 0x95, 0x0E, 0xF0, 0x57, 0x40, 0x8F, 0x0E, 0x40, 0x3F, 0x0E,
  0x75, 0x02, 0xF9, 0x04, 0x30, 0x8F, 0x09, 0x76, 0x0B, 0xF0, 0xA3, 0x0D, 0xF0, 0x37, 0x60, 0x4F,
  0x0E, 0x20, 0x2F, 0x0D, 0x77, 0x10, 0xDF, 0x81, 0x40, 0x6F, 0x07, 0x77, 0x10, 0x7F, 0x81, 0x80,
  0xBF, 0x01, 0x77, 0x10, 0x1F, 0x81, 0xC0, 0xEE, 0x0B, 0x77, 0x30, 0xAF, 0x03, 0xF0, 0x57, 0x73,
  0x04, 0xF0, 0x9E, 0x0E, 0x77, 0x50, 0xDF, 0xE0, 0x97, 0x75, 0x07, 0xFE, 0x03, 0x77, 0x50, 0x1F,
  0xD0, 0xD7, 0x77, 0x0A, 0xFC, 0x07, 0x77, 0x70, 0x4F, 0xC0, 0x17, 0x77, 0x10, 0xDF, 0xA0, 0xB7,
  0x77, 0x20, 0x7F, 0xA0, 0x57, 0x77, 0x20, 0x1F, 0x90, 0xE7, 0x77, 0x30, 0x1F, 0x90, 0x97, 0x77,
  0x30, 0x7F, 0x90, 0x37, 0x77, 0x30, 0xDF, 0x0C, 0x77, 0x73, 0x06, 0xF9, 0x06, 0x77, 0x72, 0x01,
  0x0E, 0xF0, 0xE7, 0x77, 0x20, 0x10, 0xCF, 0x90, 0x67, 0x72, 0x01, 0x02, 0x38, 0x12, 0x7E, 0xF9,
  0x0D, 0x77, 0x30, 0x7F, 0xF9, 0x04, 0x77, 0x30, 0x7F, 0xF0, 0x97, 0x74, 0x07, 0xFE, 0x0C, 0x77,
  0x50, 0x7F, 0xD0, 0xC0, 0x17, 0x75, 0x07, 0xFC, 0x0A, 0x77, 0x70, 0x7F, 0xA0, 0xC0, 0x57, 0x77,
  0x18, 0x90, 0x4B, 0xDE, 0xFE, 0xDC, 0x84, 0x77, 0x71,
  // "z" (U+007A)
  0x10, 0x3F, 0xFF, 0xD0, 0x82, 0x03, 0xFF, 0xFD, 0x08, 0x20, 0x3F, 0xFF, 0xD0, 0x82, 0x03, 0xFF,
  0xFD, 0x08, 0x20, 0x3F, 0xFF, 0xD0, 0x82, 0x03, 0xFF, 0xFD, 0x08, 0x20, 0x38, 0x09, 0x3E, 0xFB,
  0x0E, 0x02, 0x77, 0x40, 0xCF, 0xA0, 0x37, 0x74, 0x0B, 0xFA, 0x05, 0x77, 0x40, 0x8F, 0xA0, 0x77,
  0x74, 0x06, 0xFA, 0x09, 0x77, 0x40, 0x4F, 0xA0, 0xB7, 0x74, 0x02, 0x0E, 0xF9, 0x0C, 0x77, 0x40,
  0x10, 0xDF, 0x90, 0xD0, 0x17, 0x74, 0x0B, 0xF9, 0x0E, 0x02, 0x77, 0x40, 0x9F, 0xA0, 0x47, 0x74,
  0x07, 0xFA, 0x06, 0x77, 0x40, 0x5F, 0xA0, 0x87, 0x74, 0x03, 0x0E, 0xF9, 0x0A, 0x77, 0x40, 0x10,
  0xEF, 0x90, 0xC7, 0x75, 0x0C, 0xF9, 0x0D, 0x01, 0x77, 0x40, 0xAF, 0x90, 0xE0, 0x27, 0x74, 0x08,
  0xFA, 0x03, 0x77, 0x40, 0x6F, 0xA0, 0x57, 0x74, 0x04, 0xFA, 0x07, 0x77, 0x40, 0x20, 0xEF, 0xA8,
  0x09, 0x5E, 0x81, 0x10, 0xDF, 0xFF, 0xE0, 0x01, 0xFF, 0xFF, 0x00, 0x1F, 0xFF, 0xF0, 0x01, 0xFF,
  0xFF, 0x00, 0x1F, 0xFF, 0xF0, 0x01, 0xFF, 0xFF, 0x01,
  // "{" (U+007B)
  0x75, 0x86, 0x37, 0x9C, 0xDE, 0xFC, 0x73, 0x06, 0x0D, 0xF0, 0xC7, 0x20, 0xBF, 0xA0, 0xC7, 0x10,
  0x9F, 0xB0, 0xC7, 0x03, 0xFC, 0x0C, 0x70, 0x8F, 0xC0, 0xC7, 0x0C, 0xFC, 0x0B, 0x70, 0xEF, 0x81,
  0xE7, 0x27, 0x2F, 0x90, 0x37, 0x4F, 0x0B, 0x75, 0xF0, 0x97, 0x5F, 0x08, 0x75, 0xF0, 0x87, 0x5F,
  0x08, 0x75, 0xF0, 0x87, 0x5F, 0x08, 0x75, 0xF0, 0x87, 0x5F, 0x08, 0x74, 0x01, 0xF0, 0x87, 0x40,
  0x3F, 0x08, 0x74, 0x09, 0xF0, 0x77, 0x30, 0x6F, 0x90, 0x57, 0x81, 0x25, 0xBF, 0x90, 0xE0, 0x15,
  0x0B, 0xFD, 0x08, 0x60, 0xCF, 0xC0, 0xA7, 0x0C, 0xFA, 0x0D, 0x05, 0x71, 0x0C, 0xF0, 0xB0, 0x37,
  0x30, 0xCF, 0xA0, 0xA0, 0x37, 0x10, 0xCF, 0xC0, 0x87, 0x0C, 0xFD, 0x07, 0x78, 0x21, 0x36, 0xCF,
  0x90, 0xE7, 0x40, 0x8F, 0x90, 0x57, 0x40, 0xAF, 0x07, 0x74, 0x04, 0xF0, 0x87, 0x40, 0x1F, 0x08,
  0x75, 0xF0, 0x87, 0x5F, 0x08, 0x75, 0xF0, 0x87, 0x5F, 0x08, 0x75, 0xF0, 0x87, 0x5F, 0x08, 0x75,
  0xF0, 0x87, 0x5F, 0x09, 0x75, 0xF0, 0xB7, 0x5F, 0x90, 0x27, 0x40, 0xEF, 0x81, 0xE7, 0x27, 0x20,
  0xCF, 0xC0, 0xB7, 0x08, 0xFC, 0x0C, 0x70, 0x3F, 0xC0, 0xC7, 0x10, 0xAF, 0xB0, 0xC7, 0x20, 0xBF,
  0xA0, 0xC7, 0x30, 0x60, 0xDF, 0x0C, 0x75, 0x86, 0x37, 0xAC, 0xDE, 0xFC,
  // "|" (U+007C)
  0x05, 0xE0, 0x40, 0x5E, 0x04, 0x05, 0xE0, 0x40, 0x5E, 0x04, 0x05, 0xE0, 0x40, 0x5E, 0x04, 0x05,
  0xE0, 0x40, 0x5E, 0x04, 0x05, 0xE0, 0x40, 0x5E, 0x04, 0x05, 0xE0, 0x40, 0x5E, 0x04, 0x05, 0xE0,
  0x40, 0x5E, 0x04, 0x05, 0xE0, 0x40, 0x5E, 0x04, 0x05, 0xE0, 0x40, 0x5E, 0x04, 0x05, 0xE0, 0x40,
  0x5E, 0x04, 0x05, 0xE0, 0x40, 0x5E, 0x04, 0x05, 0xE0, 0x40, 0x5E, 0x04, 0x05, 0xE0, 0x40, 0x5E,
  0x04, 0x05, 0xE0, 0x40, 0x5E, 0x04, 0x05, 0xE0, 0x40, 0x5E, 0x04, 0x05, 0xE0, 0x40, 0x5E, 0x04,
  0x05, 0xE0, 0x40, 0x5E, 0x04, 0x05, 0xE0, 0x40, 0x5E, 0x04, 0x05, 0xE0, 0x40, 0x5E, 0x04, 0x05,
  0xE0, 0x40, 0x5E, 0x04, 0x05, 0xE0, 0x40, 0x5E, 0x04, 0x05, 0xE0, 0x40, 0x5E, 0x04, 0x05, 0xE0,
  0x40, 0x5E, 0x04, 0x05, 0xE0, 0x40, 0x5E, 0x04, 0x05, 0xE0, 0x40, 0x5E, 0x04, 0x05, 0xE0, 0x40,
  0x5E, 0x04, 0x05, 0xE0, 0x40, 0x5E, 0x04, 0x05, 0xE0, 0x40, 0x5E, 0x04, 0x05, 0xE0, 0x40, 0x5E,
  0x04, 0x05, 0xE0, 0x40,
  // "}" (U+007D)
  0x86, 0xCF, 0xED, 0xC9, 0x73, 0x75, 0x0C, 0xF0, 0xD0, 0x67, 0x30, 0xCF, 0xA0, 0xB7, 0x20, 0xCF,
  0xB0, 0xA7, 0x10, 0xCF, 0xC0, 0x37, 0x0C, 0xFC, 0x08, 0x70, 0xBF, 0xC0, 0xC7, 0x28, 0x12, 0x7E,
  0xF0, 0xE7, 0x40, 0x3F, 0x97, 0x50, 0xBF, 0x75, 0x09, 0xF7, 0x50, 0x8F, 0x75, 0x08, 0xF7, 0x50,
  0x8F, 0x75, 0x08, 0xF7, 0x50, 0x8F, 0x75, 0x08, 0xF7, 0x50, 0x8F, 0x75, 0x08, 0xF0, 0x17, 0x40,
  0x8F, 0x04, 0x74, 0x07, 0xF0, 0xA7, 0x40, 0x5F, 0x90, 0x87, 0x40, 0xEF, 0x98, 0x2C, 0x63, 0x17,
  0x07, 0xFD, 0x0C, 0x70, 0x8F, 0xC0, 0xC7, 0x10, 0x40, 0xBF, 0xA0, 0xC7, 0x30, 0x30, 0xBF, 0x0C,
  0x71, 0x05, 0x0D, 0xFA, 0x0C, 0x70, 0xAF, 0xC0, 0xC6, 0x08, 0xFD, 0x0B, 0x50, 0x10, 0xEF, 0x98,
  0x1B, 0x52, 0x70, 0x5F, 0x90, 0x67, 0x30, 0x7F, 0x09, 0x74, 0x08, 0xF0, 0x37, 0x40, 0x8F, 0x75,
  0x08, 0xF7, 0x50, 0x8F, 0x75, 0x08, 0xF7, 0x50, 0x8F, 0x75, 0x08, 0xF7, 0x50, 0x8F, 0x75, 0x08,
  0xF7, 0x50, 0x9F, 0x75, 0x0B, 0xF7, 0x40, 0x3F, 0x97, 0x28, 0x12, 0x7E, 0xF0, 0xE7, 0x0B, 0xFC,
  0x0C, 0x70, 0xCF, 0xC0, 0x87, 0x0C, 0xFC, 0x03, 0x70, 0xCF, 0xB0, 0xA7, 0x10, 0xCF, 0xA0, 0xB7,
  0x20, 0xCF, 0x0D, 0x06, 0x73, 0x86, 0xCF, 0xED, 0xCA, 0x73, 0x75,
  // "~" (U+007E)
  0x48, 0x64, 0xAD, 0xFE, 0xC8, 0x27, 0x40, 0x8B, 0x0D, 0x30, 0xAF, 0x90, 0x87, 0x30, 0x9B, 0x0C,
  0x20, 0x9F, 0xB0, 0xC0, 0x17, 0x10, 0xBB, 0x81, 0xA0, 0x5F, 0xD0, 0xD0, 0x17, 0x0E, 0xB8, 0x17,
  0x0C, 0xC8, 0x26, 0x11, 0x7D, 0x0D, 0x02, 0x50, 0x3C, 0x04, 0x03, 0xC0, 0x64, 0x03, 0x0E, 0xC0,
  0xE0, 0x34, 0x0A, 0xC0, 0x10, 0x7B, 0x0E, 0x60, 0x20, 0xDC, 0x83, 0xE7, 0x11, 0x8C, 0x81, 0xB0,
  0xBB, 0x0A, 0x70, 0x10, 0xDF, 0xD8, 0x13, 0x0D, 0xB0, 0x77, 0x10, 0x10, 0xBF, 0xB0, 0x92, 0x0E,
  0xB0, 0x67, 0x30, 0x70, 0xEF, 0x09, 0x3C, 0x05, 0x74, 0x86, 0x17, 0xCE, 0xFD, 0xA4, 0x40,
  // "¡" (U+00A1)
  0x38, 0x41, 0x57, 0x75, 0x15, 0x07, 0x0E, 0xD0, 0x83, 0x07, 0xF9, 0x82, 0x80, 0x1E, 0xFA, 0x01,
  0x04, 0xFB, 0x05, 0x06, 0xFB, 0x06, 0x04, 0xFB, 0x05, 0x01, 0xFB, 0x81, 0x20, 0x8F, 0x90, 0xA3,
  0x08, 0xE0, 0xA5, 0x84, 0x15, 0x77, 0x52, 0x80, 0xE1, 0x00, 0xDE, 0x0C, 0x40, 0xEE, 0x0D, 0x40,
  0xEE, 0x0D, 0x4F, 0x0E, 0x4F, 0x93, 0x01, 0xF9, 0x30, 0x2F, 0x90, 0x12, 0x02, 0xF9, 0x01, 0x20,
  0x3F, 0x90, 0x22, 0x04, 0xF9, 0x03, 0x20, 0x4F, 0x90, 0x32, 0x05, 0xF9, 0x04, 0x20, 0x6F, 0x90,
  0x52, 0x07, 0xF9, 0x06, 0x20, 0x7F, 0x90, 0x62, 0x08, 0xF9, 0x07, 0x20, 0x9F, 0x90, 0x82, 0x09,
  0xF9, 0x08, 0x20, 0xAF, 0x90, 0x92, 0x0B, 0xF9, 0x0A, 0x20, 0xBF, 0x90, 0xA2, 0x0C, 0xF9, 0x0B,
  0x20, 0xDF, 0x90, 0xC2, 0x0D, 0xF9, 0x0D, 0x20, 0xEF, 0x90, 0xD2, 0xFA, 0x0E, 0x2F, 0xB1, 0x01,
  0xFB, 0x10,
  // "¢" (U+00A2)
  0x76, 0x01, 0xC0, 0xB7, 0x77, 0x10, 0x1C, 0x0B, 0x77, 0x71, 0x01, 0xC0, 0xB7, 0x77, 0x10, 0x1C,
  0x0B, 0x77, 0x71, 0x03, 0xC8, 0x3D, 0x76, 0x52, 0x77, 0x81, 0x28, 0xCF, 0xD8, 0x1B, 0x71, 0x71,
  0x04, 0x0C, 0xFF, 0xC0, 0x75, 0x01, 0x0A, 0xFF, 0xE0, 0x64, 0x01, 0x0D, 0xFF, 0xF0, 0x13, 0x01,
  0x0D, 0xFF, 0xF0, 0xA4, 0x0B, 0xFF, 0xF9, 0x05, 0x30, 0x7F, 0xB8, 0x90, 0xB6, 0x21, 0x01, 0x25,
  0x7C, 0xA0, 0xE4, 0x0E, 0xF9, 0x0C, 0x03, 0x73, 0x81, 0x17, 0x83, 0x06, 0xF9, 0x0B, 0x77, 0x40,
  0xCF, 0x0E, 0x01, 0x77, 0x4F, 0x90, 0x77, 0x74, 0x04, 0xF9, 0x01, 0x77, 0x40, 0x7F, 0x0D, 0x77,
  0x50, 0x9F, 0x0A, 0x77, 0x50, 0xAF, 0x08, 0x77, 0x50, 0xBF, 0x08, 0x77, 0x50, 0xBF, 0x07, 0x77,
  0x50, 0xAF, 0x08, 0x77, 0x50, 0x9F, 0x09, 0x77, 0x50, 0x8F, 0x0D, 0x77, 0x50, 0x5F, 0x90, 0x17,
  0x74, 0x02, 0xF9, 0x07, 0x77, 0x50, 0xEF, 0x0D, 0x01, 0x77, 0x40, 0x8F, 0x90, 0xB7, 0x71, 0x01,
  0x20, 0x2F, 0xA0, 0xC0, 0x27, 0x48, 0x13, 0xAE, 0x30, 0xAF, 0xB8, 0x2A, 0x52, 0x12, 0x83, 0x13,
  0x69, 0xEA, 0x0E, 0x30, 0x10, 0xEF, 0xFF, 0x90, 0xE4, 0x05, 0xFF, 0xF9, 0x0E, 0x50, 0x6F, 0xFF,
  0x0E, 0x60, 0x50, 0xEF, 0xFD, 0x0E, 0x70, 0x10, 0x9F, 0xFC, 0x0B, 0x72, 0x81, 0x27, 0xCF, 0xD8,
  0x1D, 0x83, 0x77, 0x03, 0x06, 0xC8, 0x3E, 0x86, 0x41, 0x77, 0x40, 0x1C, 0x0B, 0x77, 0x71, 0x01,
  0xC0, 0xB7, 0x77, 0x10, 0x1C, 0x0B, 0x77, 0x71, 0x01, 0xC0, 0xB7, 0x77, 0x10, 0x1C, 0x0B, 0x72,
  // "£" (U+00A3)
  0x77, 0x86, 0x25, 0x67, 0x76, 0x52, 0x77, 0x48, 0x13, 0x9E, 0xFA, 0x81, 0xC7, 0x27, 0x50, 0x20,
  0xBF, 0xF9, 0x0B, 0x05, 0x72, 0x04, 0x0E, 0xFF, 0xB0, 0xA7, 0x10, 0x4F, 0xFD, 0x04, 0x71, 0x0E,
  0xFF, 0xC0, 0xD7, 0x10, 0x7F, 0xFD, 0x07, 0x71, 0x0D, 0xFA, 0x84, 0xD9, 0x77, 0x9C, 0xC0, 0x27,
  0x02, 0xFA, 0x07, 0x68, 0x21, 0x6C, 0xB7, 0x10, 0x5F, 0x90, 0x77, 0x30, 0x17, 0x10, 0x7F, 0x90,
  0x17, 0x75, 0x08, 0xF0, 0xD7, 0x76, 0x08, 0xF0, 0xC7, 0x76, 0x09, 0xF0, 0xC7, 0x76, 0x09, 0xF0,
  0xC7, 0x76, 0x09, 0xF0, 0xC7, 0x76, 0x09, 0xF0, 0xC7, 0x76, 0x09, 0xF0, 0xC7, 0x71, 0x03, 0xFF,
  0xF9, 0x09, 0x50, 0x3F, 0xFF, 0x90, 0x95, 0x03, 0xFF, 0xF9, 0x09, 0x50, 0x3F, 0xFF, 0x90, 0x95,
  0x03, 0xFF, 0xF9, 0x09, 0x50, 0x3F, 0xFF, 0x90, 0x97, 0x30, 0x9F, 0x0C, 0x77, 0x60, 0x9F, 0x0C,
  0x77, 0x60, 0x9F, 0x0C, 0x77, 0x60, 0x9F, 0x0C, 0x77, 0x60, 0x9F, 0x0C, 0x77, 0x60, 0x9F, 0x0B,
  0x77, 0x60, 0xBF, 0x09, 0x77, 0x60, 0xDF, 0x05, 0x77, 0x50, 0x3F, 0x0E, 0x77, 0x60, 0xBF, 0x05,
  0x77, 0x50, 0x8F, 0x07, 0x77, 0x50, 0xAF, 0x06, 0x77, 0x40, 0x10, 0xDF, 0x98, 0x09, 0x6E, 0x06,
  0x02, 0xFF, 0xFE, 0x06, 0x02, 0xFF, 0xFE, 0x06, 0x02, 0xFF, 0xFE, 0x06, 0x02, 0xFF, 0xFE, 0x06,
  0x02, 0xFF, 0xFE, 0x06, 0x02, 0xFF, 0xFE, 0x06,
  // "¤" (U+00A4)
  0x40, 0xB0, 0x57, 0x74, 0x06, 0x0A, 0x60, 0x10, 0xCA, 0x05, 0x77, 0x20, 0x6A, 0x0B, 0x40, 0x10,
  0xCC, 0x05, 0x28, 0x90, 0x27, 0xBD, 0xFE, 0xDA, 0x61, 0x20, 0x7C, 0x83, 0xC1, 0x01, 0xCE, 0x07,
  0x0A, 0xFB, 0x08, 0x07, 0xE8, 0x2D, 0x11, 0xCF, 0xFF, 0xD0, 0xA3, 0x0B, 0xFF, 0xFB, 0x09, 0x50,
  0xBF, 0xFF, 0x90, 0x97, 0x0A, 0xFF, 0xE0, 0x97, 0x10, 0xBE, 0x81, 0xD6, 0x22, 0x81, 0x27, 0xDE,
  0x0B, 0x70, 0x3E, 0x0B, 0x01, 0x60, 0x10, 0xBE, 0x03, 0x60, 0x9D, 0x0E, 0x01, 0x71, 0x01, 0x0D,
  0xD0, 0x96, 0x0E, 0xD0, 0x67, 0x30, 0x6D, 0x0D, 0x50, 0x1E, 0x01, 0x73, 0x01, 0xE5, 0x03, 0xE7,
  0x5E, 0x02, 0x40, 0x3E, 0x75, 0xE0, 0x24, 0x02, 0xE0, 0x17, 0x30, 0x1E, 0x01, 0x50, 0xED, 0x06,
  0x73, 0x06, 0xD0, 0xD6, 0x0A, 0xD0, 0xD7, 0x20, 0x10, 0xDD, 0x09, 0x60, 0x5E, 0x0B, 0x01, 0x60,
  0x10, 0xCE, 0x04, 0x70, 0xCE, 0x81, 0xE7, 0x22, 0x81, 0x27, 0xEE, 0x0C, 0x71, 0x09, 0xFF, 0xE0,
  0x87, 0x09, 0xFF, 0xF9, 0x07, 0x50, 0xAF, 0xFF, 0xB0, 0x73, 0x0B, 0xFF, 0xFD, 0x82, 0x70, 0x1C,
  0xE0, 0x80, 0xCF, 0xB0, 0x09, 0xE0, 0xB2, 0x01, 0x0C, 0xC0, 0x52, 0x89, 0x03, 0x8B, 0xEF, 0xED,
  0xA6, 0x12, 0x08, 0xC0, 0xB4, 0x01, 0x0C, 0xA0, 0x57, 0x72, 0x08, 0xA0, 0xB6, 0x81, 0x1B, 0x57,
  0x74, 0x07, 0x0B, 0x40,
  // "¥" (U+00A5)
  0x03, 0xF9, 0x08, 0x77, 0x08, 0xF9, 0x81, 0x30, 0xBF, 0x0E, 0x77, 0x0E, 0xF0, 0xB2, 0x03, 0xF9,
  0x07, 0x75, 0x07, 0xF9, 0x02, 0x30, 0xAF, 0x0D, 0x75, 0x0D, 0xF0, 0xA4, 0x02, 0xF9, 0x05, 0x73,
  0x06, 0xF9, 0x02, 0x50, 0xAF, 0x0D, 0x73, 0x0D, 0xF0, 0x96, 0x02, 0xF9, 0x04, 0x71, 0x04, 0xF9,
  0x01, 0x70, 0x9F, 0x0B, 0x71, 0x0B, 0xF0, 0x87, 0x10, 0x1F, 0x90, 0x36, 0x03, 0xF0, 0xE0, 0x17,
  0x20, 0x9F, 0x0A, 0x60, 0xAF, 0x07, 0x73, 0x01, 0xF9, 0x02, 0x40, 0x2F, 0x0E, 0x75, 0x08, 0xF0,
  0x94, 0x09, 0xF0, 0x67, 0x50, 0x10, 0xEF, 0x01, 0x20, 0x1F, 0x0D, 0x77, 0x08, 0xF0, 0x82, 0x08,
  0xF0, 0x67, 0x70, 0x10, 0xEE, 0x0E, 0x20, 0xEE, 0x0D, 0x77, 0x20, 0x7F, 0x00, 0x7F, 0x05, 0x77,
  0x30, 0xEE, 0x00, 0xDE, 0x0C, 0x77, 0x40, 0x7F, 0xF0, 0x47, 0x75, 0x0D, 0xFD, 0x0B, 0x77, 0x60,
  0x6F, 0xD0, 0x37, 0x77, 0x0D, 0xFB, 0x0B, 0x77, 0x10, 0xBF, 0xFF, 0xB0, 0xB7, 0x10, 0xBF, 0xFF,
  0xB0, 0xB7, 0x10, 0xBF, 0xFF, 0xB0, 0xB7, 0x10, 0xBF, 0xFF, 0xB0, 0xB7, 0x10, 0xBF, 0xFF, 0xB0,
  0xB7, 0x72, 0x01, 0xF9, 0x01, 0x77, 0x73, 0x01, 0xF9, 0x01, 0x77, 0x73, 0x01, 0xF9, 0x01, 0x77,
  0x73, 0x01, 0xF9, 0x01, 0x77, 0x20, 0xBF, 0xFF, 0xB0, 0xB7, 0x10, 0xBF, 0xFF, 0xB0, 0xB7, 0x10,
  0xBF, 0xFF, 0xB0, 0xB7, 0x10, 0xBF, 0xFF, 0xB0, 0xB7, 0x10, 0xBF, 0xFF, 0xB0, 0xB7, 0x72, 0x01,
  0xF9, 0x01, 0x77, 0x73, 0x01, 0xF9, 0x01, 0x77, 0x73, 0x01, 0xF9, 0x01, 0x77, 0x73, 0x01, 0xF9,
  0x01, 0x77, 0x73, 0x01, 0xF9, 0x01, 0x77, 0x73, 0x01, 0xF9, 0x01, 0x77, 0x73, 0x01, 0xF9, 0x01,
  0x75,
  // "¦" (U+00A6)
  0x05, 0xE0, 0x40, 0x5E, 0x04, 0x05, 0xE0, 0x40, 0x5E, 0x04, 0x05, 0xE0, 0x40, 0x5E, 0x04, 0x05,
  0xE0, 0x40, 0x5E, 0x04, 0x05, 0xE0, 0x40, 0x5E, 0x04, 0x05, 0xE0, 0x40, 0x5E, 0x04, 0x05, 0xE0,
  0x40, 0x5E, 0x04, 0x05, 0xE0, 0x40, 0x5E, 0x04, 0x05, 0xE0, 0x40, 0x5E, 0x04, 0x05, 0xE0, 0x40,
  0x5E, 0x04, 0x05, 0xE0, 0x40, 0x5E, 0x04, 0x05, 0xE0, 0x40, 0x5E, 0x04, 0x80, 0x9A, 0x40, 0x05,
  0xE0, 0x40, 0x5E, 0x04, 0x05, 0xE0, 0x40, 0x5E, 0x04, 0x05, 0xE0, 0x40, 0x5E, 0x04, 0x05, 0xE0,
  0x40, 0x5E, 0x04, 0x05, 0xE0, 0x40, 0x5E, 0x04, 0x05, 0xE0, 0x40, 0x5E, 0x04, 0x05, 0xE0, 0x40,
  0x5E, 0x04, 0x05, 0xE0, 0x40, 0x5E, 0x04, 0x05, 0xE0, 0x40, 0x5E, 0x04, 0x05, 0xE0, 0x40, 0x5E,
  0x04, 0x05, 0xE0, 0x40, 0x5E, 0x04, 0x05, 0xE0, 0x40, 0x5E, 0x04,
  // "§" (U+00A7)
  0x78, 0x93, 0x58, 0xBD, 0xEF, 0xEE, 0xDB, 0x85, 0x17, 0x18, 0x11, 0x9E, 0xFE, 0x81, 0xD8, 0x24,
  0x06, 0xFF, 0xD0, 0x42, 0x08, 0xFF, 0xD0, 0xD2, 0x04, 0xFF, 0xE0, 0x62, 0x0C, 0xF8, 0x6A, 0x41,
  0x01, 0x25, 0xAC, 0x0E, 0x20, 0x2F, 0x0A, 0x71, 0x83, 0x17, 0xEF, 0x72, 0x05, 0xF0, 0x57, 0x38,
  0x11, 0x81, 0x20, 0x5F, 0x06, 0x77, 0x10, 0x4F, 0x0D, 0x01, 0x77, 0x01, 0xF9, 0x0D, 0x04, 0x77,
  0x09, 0xFA, 0x0B, 0x04, 0x75, 0x01, 0x0D, 0xFB, 0x0D, 0x06, 0x74, 0x02, 0x0E, 0xFC, 0x81, 0xE8,
  0x17, 0x20, 0x20, 0xCF, 0xD0, 0xE0, 0x77, 0x10, 0x10, 0xAF, 0xF0, 0xC0, 0x25, 0x02, 0x0E, 0xFF,
  0xA0, 0xE0, 0x43, 0x01, 0x0D, 0xE0, 0x0C, 0xFB, 0x0E, 0x03, 0x20, 0xBE, 0x09, 0x20, 0x30, 0xAF,
  0xA8, 0x1C, 0x03, 0xE0, 0xD5, 0x02, 0x0B, 0xF9, 0x04, 0x08, 0xE0, 0x77, 0x09, 0xF0, 0x90, 0xAE,
  0x06, 0x71, 0x0D, 0xE0, 0xC0, 0xBE, 0x09, 0x71, 0x07, 0xE0, 0xD0, 0xAE, 0x0E, 0x02, 0x70, 0x5E,
  0x0C, 0x07, 0xF0, 0xD0, 0x26, 0x06, 0xE0, 0xA0, 0x2F, 0xA0, 0x75, 0x0C, 0xE8, 0x16, 0x09, 0xFA,
  0x0E, 0x07, 0x20, 0x7E, 0x0E, 0x30, 0xBF, 0xB0, 0xE0, 0xAF, 0x04, 0x40, 0x8F, 0xFB, 0x06, 0x60,
  0x40, 0xDF, 0xE0, 0xE0, 0x47, 0x20, 0x60, 0xEF, 0xD0, 0x67, 0x40, 0x60, 0xDF, 0xC0, 0x87, 0x50,
  0x50, 0xBF, 0xB0, 0x57, 0x60, 0x30, 0xCF, 0x90, 0xD7, 0x71, 0x07, 0xF9, 0x04, 0x77, 0x10, 0x9F,
  0x07, 0x77, 0x10, 0x3F, 0x08, 0x02, 0x77, 0x03, 0xF8, 0x27, 0xCC, 0x57, 0x50, 0x8F, 0x04, 0x0C,
  0xA8, 0x2E, 0x94, 0x17, 0x06, 0xF8, 0x1E, 0x0C, 0xE8, 0x5D, 0xA9, 0x78, 0xAE, 0xF9, 0x81, 0x70,
  0xCF, 0xFE, 0x0B, 0x20, 0xCF, 0xFD, 0x0A, 0x30, 0x70, 0xEF, 0xFA, 0x0D, 0x05, 0x68, 0x15, 0x9D,
  0xFB, 0x81, 0xEB, 0x57, 0x48, 0x90, 0x13, 0x56, 0x77, 0x76, 0x52, 0x72,
  // "¨" (U+00A8)
  0x28, 0x43, 0xBE, 0xFC, 0x57, 0x18, 0x43, 0xBE, 0xFC, 0x63, 0x04, 0xE0, 0x86, 0x04, 0xE0, 0x92,
  0x0D, 0xF0, 0x25, 0x0D, 0xF0, 0x20, 0x1F, 0x90, 0x64, 0x01, 0xF9, 0x06, 0x02, 0xF9, 0x07, 0x40,
  0x2F, 0x90, 0x70, 0x1F, 0x90, 0x54, 0x01, 0xF9, 0x81, 0x60, 0xCF, 0x01, 0x50, 0xCF, 0x81, 0x20,
  0x4E, 0x07, 0x60, 0x3E, 0x08, 0x38, 0x43, 0xBE, 0xFC, 0x57, 0x18, 0x43, 0xBE, 0xFC, 0x52,
  // "©" (U+00A9)
  0x74, 0x83, 0x37, 0xAD, 0xEA, 0x83, 0xED, 0xA7, 0x37, 0x76, 0x07, 0x0D, 0xFD, 0x0D, 0x07, 0x77,
  0x20, 0x50, 0xEF, 0xFA, 0x0E, 0x05, 0x76, 0x0A, 0xFF, 0xE0, 0xA7, 0x30, 0x10, 0xCE, 0x82, 0xB6,
  0x31, 0x28, 0x21, 0x36, 0xBE, 0x0B, 0x72, 0x0B, 0xD0, 0xA0, 0x27, 0x30, 0x20, 0x9D, 0x0A, 0x70,
  0x8C, 0x0E, 0x05, 0x38, 0x73, 0x8C, 0xDF, 0xED, 0xA5, 0x20, 0x40, 0xEC, 0x07, 0x50, 0x3C, 0x0E,
  0x03, 0x20, 0x10, 0xAF, 0xA8, 0x3E, 0x30, 0x2E, 0xC0, 0x24, 0x0B, 0xC0, 0x52, 0x02, 0x0D, 0xFB,
  0x0E, 0x30, 0x3C, 0x0A, 0x30, 0x3C, 0x0A, 0x30, 0xCF, 0xC0, 0x94, 0x08, 0xC0, 0x22, 0x08, 0xC0,
  0x22, 0x07, 0xD0, 0xA0, 0x32, 0x82, 0x37, 0xE3, 0x40, 0x10, 0xEB, 0x07, 0x20, 0xDB, 0x0B, 0x30,
  0xDC, 0x08, 0x76, 0x09, 0xB8, 0x1C, 0x01, 0xC0, 0x62, 0x03, 0xC0, 0xD7, 0x70, 0x5C, 0x10, 0x4C,
  0x02, 0x20, 0x7C, 0x07, 0x77, 0x02, 0xC0, 0x30, 0x5C, 0x30, 0x9C, 0x03, 0x77, 0x1C, 0x05, 0x06,
  0xC3, 0x0A, 0xC0, 0x27, 0x71, 0x0E, 0xB0, 0x06, 0xB0, 0xE3, 0x0A, 0xC0, 0x17, 0x71, 0xC0, 0x60,
  0x5C, 0x30, 0x9C, 0x02, 0x77, 0x1C, 0x05, 0x03, 0xC0, 0x22, 0x07, 0xC0, 0x57, 0x70, 0x3C, 0x04,
  0x01, 0xC0, 0x52, 0x04, 0xC0, 0xA7, 0x70, 0x6C, 0x81, 0x10, 0xDB, 0x0A, 0x30, 0xEC, 0x04, 0x76,
  0x0B, 0xB0, 0xE2, 0x08, 0xC0, 0x12, 0x08, 0xD0, 0x80, 0x22, 0x82, 0x24, 0x99, 0x40, 0x2C, 0x09,
  0x20, 0x2C, 0x09, 0x30, 0xDF, 0xC0, 0xA4, 0x0A, 0xC0, 0x43, 0x0B, 0xC0, 0x42, 0x02, 0x0E, 0xFB,
  0x0A, 0x30, 0x5C, 0x0C, 0x40, 0x3C, 0x0E, 0x02, 0x20, 0x20, 0xBF, 0xA0, 0xA2, 0x03, 0xD0, 0x45,
  0x09, 0xC0, 0xE0, 0x43, 0x87, 0x38, 0xCE, 0xFE, 0xDA, 0x52, 0x05, 0xD0, 0x97, 0x0C, 0xD0, 0x90,
  0x17, 0x30, 0x20, 0xAD, 0x0C, 0x71, 0x01, 0x0C, 0xE8, 0x2A, 0x63, 0x12, 0x82, 0x13, 0x6B, 0xE0,
  0xC0, 0x17, 0x20, 0x10, 0xBF, 0xFE, 0x0A, 0x76, 0x07, 0xFF, 0xB0, 0xE0, 0x67, 0x71, 0x81, 0x18,
  0xEF, 0xD0, 0xD0, 0x77, 0x76, 0x83, 0x48, 0xBD, 0xEA, 0x83, 0xEC, 0xA7, 0x37, 0x40,
  // "ª" (U+00AA)
  0x58, 0x91, 0x37, 0xAD, 0xEF, 0xED, 0xB7, 0x16, 0x81, 0x18, 0xEF, 0xC0, 0x85, 0x06, 0xFF, 0x09,
  0x50, 0xEF, 0xF0, 0x54, 0x06, 0xA8, 0x5C, 0x74, 0x34, 0x6D, 0xD0, 0xC5, 0x08, 0x02, 0x70, 0xDD,
  0x01, 0x76, 0x07, 0xD0, 0x47, 0x60, 0x5D, 0x05, 0x48, 0x41, 0x59, 0xBD, 0xEF, 0xA0, 0x52, 0x01,
  0x09, 0xFF, 0x98, 0x25, 0x01, 0xDF, 0xFA, 0x81, 0x50, 0xBD, 0x81, 0xB4, 0x13, 0x05, 0xD0, 0x50,
  0x1D, 0x0D, 0x60, 0x5D, 0x05, 0x04, 0xD0, 0x76, 0x08, 0xD0, 0x50, 0x6D, 0x06, 0x60, 0xDD, 0x00,
  0x5D, 0x09, 0x50, 0xAE, 0x05, 0x03, 0xE8, 0x38, 0x33, 0x6C, 0xF8, 0x15, 0x0D, 0xFD, 0x0D, 0xC8,
  0x15, 0x04, 0xFC, 0x0B, 0x02, 0xC0, 0x52, 0x05, 0x0E, 0xF9, 0x08, 0x20, 0xCB, 0x05, 0x38, 0x71,
  0x8C, 0xEF, 0xDC, 0x72, 0x38, 0x35, 0x99, 0x93,
  // "«" (U+00AB)
  0x73, 0x0B, 0x07, 0x73, 0x81, 0x1C, 0x67, 0x70, 0x9A, 0x0E, 0x06, 0x71, 0x0B, 0xA0, 0xD0, 0x57,
  0x40, 0x5D, 0x0D, 0x05, 0x50, 0x7D, 0x0C, 0x04, 0x71, 0x02, 0x0E, 0xF0, 0x43, 0x04, 0xF9, 0x02,
  0x70, 0xCF, 0x0A, 0x30, 0x10, 0xEF, 0x07, 0x70, 0x9F, 0x0D, 0x01, 0x30, 0xBF, 0x0C, 0x70, 0x5F,
  0x90, 0x43, 0x08, 0xF9, 0x02, 0x60, 0x20, 0xEF, 0x08, 0x30, 0x4F, 0x90, 0x67, 0x0D, 0xF0, 0xD3,
  0x01, 0x0E, 0xF0, 0xB7, 0x09, 0xF9, 0x03, 0x30, 0xCF, 0x0E, 0x01, 0x60, 0x6F, 0x90, 0x73, 0x08,
  0xF9, 0x05, 0x60, 0x3F, 0x90, 0xC3, 0x05, 0xF9, 0x0A, 0x70, 0xDF, 0x0E, 0x02, 0x20, 0x20, 0xEF,
  0x0E, 0x01, 0x60, 0x6F, 0x90, 0x83, 0x08, 0xF9, 0x06, 0x70, 0x10, 0xEF, 0x0E, 0x01, 0x20, 0x3F,
  0x90, 0xD7, 0x10, 0x4F, 0x90, 0xA3, 0x06, 0xF9, 0x09, 0x71, 0x07, 0xF9, 0x06, 0x30, 0xAF, 0x90,
  0x47, 0x10, 0xBF, 0x0E, 0x02, 0x30, 0xDF, 0x0E, 0x01, 0x70, 0x10, 0xDF, 0x0C, 0x30, 0x20, 0xEF,
  0x0A, 0x71, 0x03, 0xF9, 0x07, 0x30, 0x5F, 0x90, 0x57, 0x10, 0x7F, 0x90, 0x33, 0x09, 0xF0, 0xE0,
  0x17, 0x10, 0xAF, 0x0D, 0x40, 0xCF, 0x0B, 0x71, 0x01, 0x0D, 0xF0, 0x93, 0x02, 0x0E, 0xF0, 0x67,
  0x10, 0x3F, 0x90, 0x43, 0x05, 0xF9, 0x02, 0x71, 0x06, 0xD0, 0xE0, 0x75, 0x09, 0xD0, 0xD0, 0x57,
  0x30, 0xAB, 0x08, 0x01, 0x70, 0xCA, 0x0E, 0x07, 0x76, 0x81, 0xD9, 0x17, 0x28, 0x22, 0xD8, 0x14,
  // "¬" (U+00AC)
  0x0C, 0xFF, 0xFD, 0x03, 0x0C, 0xFF, 0xFD, 0x03, 0x0C, 0xFF, 0xFD, 0x03, 0x0C, 0xFF, 0xFD, 0x03,
  0x0C, 0xFF, 0xFD, 0x03, 0x0C, 0xFF, 0xFD, 0x03, 0x77, 0x60, 0x3E, 0x03, 0x77, 0x60, 0x3E, 0x03,
  0x77, 0x60, 0x3E, 0x03, 0x77, 0x60, 0x3E, 0x03, 0x77, 0x60, 0x3E, 0x03, 0x77, 0x60, 0x3E, 0x03,
  0x77, 0x60, 0x3E, 0x03, 0x77, 0x60, 0x3E, 0x03, 0x77, 0x60, 0x3E, 0x03, 0x77, 0x60, 0x3E, 0x03,
  0x77, 0x60, 0x18, 0x02, 0x70, 0x10,
  // "®" (U+00AE)
  0x74, 0x83, 0x37, 0xAD, 0xEA, 0x83, 0xED, 0xA7, 0x37, 0x76, 0x06, 0x0D, 0xFD, 0x0D, 0x06, 0x77,
  0x20, 0x50, 0xEF, 0xFA, 0x0D, 0x04, 0x76, 0x09, 0xFF, 0xE0, 0x97, 0x40, 0xBE, 0x82, 0xB6, 0x31,
  0x28, 0x21, 0x36, 0xBE, 0x0A, 0x72, 0x0B, 0xD0, 0xA0, 0x27, 0x30, 0x20, 0x9D, 0x09, 0x70, 0x7D,
  0x05, 0x07, 0xE8, 0x2E, 0xDA, 0x53, 0x04, 0x0E, 0xC0, 0x65, 0x02, 0xD8, 0x14, 0x07, 0xFB, 0x0C,
  0x01, 0x20, 0x20, 0xEB, 0x0E, 0x01, 0x40, 0xAC, 0x06, 0x20, 0x7F, 0xC0, 0xD3, 0x03, 0xC0, 0x93,
  0x02, 0xC0, 0xB3, 0x07, 0xB0, 0xD2, 0x02, 0x0A, 0xC0, 0x63, 0x09, 0xC0, 0x12, 0x07, 0xC0, 0x33,
  0x07, 0xB0, 0xD4, 0x0E, 0xB0, 0xA3, 0x01, 0xC0, 0x62, 0x0C, 0xB0, 0xC4, 0x07, 0xB0, 0xD4, 0x0C,
  0xB0, 0xC4, 0x0A, 0xB0, 0xB2, 0xC0, 0x74, 0x07, 0xB0, 0xD4, 0x0D, 0xB0, 0xC4, 0x05, 0xC1, 0x03,
  0xC0, 0x34, 0x07, 0xB0, 0xD3, 0x02, 0xC0, 0xA4, 0x03, 0xC0, 0x20, 0x4C, 0x01, 0x40, 0x7B, 0x0D,
  0x20, 0x40, 0xCC, 0x05, 0x40, 0x1C, 0x04, 0x05, 0xC5, 0x07, 0xFC, 0x0C, 0x6C, 0x00, 0x5C, 0x50,
  0x7F, 0xB0, 0xC0, 0x26, 0xC0, 0x50, 0x4C, 0x01, 0x40, 0x7F, 0xB0, 0x26, 0x01, 0xC0, 0x40, 0x2C,
  0x03, 0x40, 0x7B, 0x0D, 0x20, 0xBB, 0x08, 0x60, 0x3C, 0x03, 0x1C, 0x06, 0x40, 0x7B, 0x0D, 0x20,
  0x5B, 0x0E, 0x60, 0x7C, 0x20, 0xBB, 0x0B, 0x40, 0x7B, 0x0D, 0x30, 0xEB, 0x07, 0x50, 0xCB, 0x0D,
  0x20, 0x7C, 0x02, 0x30, 0x7B, 0x0D, 0x30, 0x8B, 0x0D, 0x40, 0x3C, 0x08, 0x20, 0x1C, 0x09, 0x30,
  0x7B, 0x0D, 0x30, 0x2C, 0x05, 0x30, 0xBC, 0x03, 0x30, 0xAC, 0x04, 0x20, 0x7B, 0x0D, 0x40, 0xBB,
  0x0C, 0x20, 0x5C, 0x0B, 0x40, 0x2C, 0x86, 0xE2, 0x07, 0xEE, 0xEC, 0x48, 0x55, 0xEE, 0xEE, 0x43,
  0xD0, 0x45, 0x08, 0xC0, 0xE0, 0x47, 0x70, 0x5D, 0x09, 0x70, 0xBD, 0x09, 0x01, 0x73, 0x02, 0x0A,
  0xD0, 0xC7, 0x10, 0x10, 0xCE, 0x82, 0xA6, 0x31, 0x28, 0x21, 0x36, 0xBE, 0x0D, 0x01, 0x73, 0x0B,
  0xFF, 0xE0, 0xB0, 0x17, 0x50, 0x60, 0xEF, 0xFA, 0x0E, 0x06, 0x77, 0x18, 0x11, 0x8E, 0xFD, 0x81,
  0xD7, 0x17, 0x75, 0x83, 0x48, 0xBD, 0xEA, 0x83, 0xED, 0xA7, 0x37, 0x40,
  // "¯" (U+00AF)
  0x01, 0xFF, 0xC0, 0x01, 0xFF, 0xC0, 0x01, 0xFF, 0xC0, 0x01, 0xFF, 0xC0, 0x01, 0xFF, 0xC0, 0x01,
  0xFF, 0xC0, 0x10,
  // "°" (U+00B0)
  0x68, 0x15, 0xAD, 0xA8, 0x1D, 0xA5, 0x73, 0x03, 0x0D, 0xF9, 0x0D, 0x03, 0x70, 0x6F, 0xD0, 0x75,
  0x05, 0xFF, 0x05, 0x30, 0x20, 0xEF, 0xF9, 0x02, 0x20, 0xAD, 0x0D, 0x04, 0x20, 0x40, 0xCD, 0x81,
  0xB0, 0x1D, 0x0D, 0x01, 0x50, 0xCD, 0x01, 0x05, 0xD0, 0x46, 0x03, 0xD0, 0x50, 0x7C, 0x0E, 0x71,
  0x0E, 0xC0, 0x08, 0xC0, 0xD7, 0x10, 0xCC, 0x09, 0x07, 0xC0, 0xE7, 0x10, 0xEC, 0x08, 0x05, 0xD0,
  0x46, 0x02, 0xD0, 0x60, 0x1D, 0x0C, 0x60, 0xBD, 0x81, 0x20, 0xAD, 0x0C, 0x04, 0x20, 0x30, 0xBD,
  0x0C, 0x20, 0x2F, 0xFA, 0x04, 0x30, 0x6F, 0xF0, 0x85, 0x07, 0xFD, 0x0A, 0x70, 0x40, 0xEF, 0x90,
  0xE0, 0x67, 0x38, 0x16, 0xAD, 0xA8, 0x2D, 0xB7, 0x15,
  // "±" (U+00B1)
  0x73, 0x01, 0xE0, 0x47, 0x76, 0x01, 0xE0, 0x47, 0x76, 0x01, 0xE0, 0x47, 0x76, 0x01, 0xE0, 0x47,
  0x76, 0x01, 0xE0, 0x47, 0x76, 0x01, 0xE0, 0x47, 0x76, 0x01, 0xE0, 0x47, 0x76, 0x01, 0xE0, 0x47,
  0x76, 0x01, 0xE0, 0x47, 0x76, 0x01, 0xE0, 0x47, 0x76, 0x01, 0xE0, 0x47, 0x30, 0xAF, 0xFF, 0xD0,
  0xC0, 0xAF, 0xFF, 0xD0, 0xC0, 0xAF, 0xFF, 0xD0, 0xC0, 0xAF, 0xFF, 0xD0, 0xC0, 0xAF, 0xFF, 0xD0,
  0xC0, 0xAF, 0xFF, 0xD0, 0xC7, 0x30, 0x1E, 0x04, 0x77, 0x60, 0x1E, 0x04, 0x77, 0x60, 0x1E, 0x04,
  0x77, 0x60, 0x1E, 0x04, 0x77, 0x60, 0x1E, 0x04, 0x77, 0x60, 0x1E, 0x04, 0x77, 0x60, 0x1E, 0x04,
  0x77, 0x60, 0x1E, 0x04, 0x77, 0x60, 0x1E, 0x04, 0x77, 0x60, 0x1E, 0x04, 0x77, 0x60, 0x1E, 0x04,
  0x80, 0xF6, 0x00, 0xB8, 0x0A, 0x6E, 0x0B, 0x0C, 0xFF, 0xFD, 0x00, 0xCF, 0xFF, 0xD0, 0x0C, 0xFF,
  0xFD, 0x00, 0xCF, 0xFF, 0xD0, 0x0C, 0xFF, 0xFD, 0x00, 0xCF, 0xFF, 0xD0, 0xC0,
  // "²" (U+00B2)
  0x48, 0x23, 0x8C, 0xEA, 0x82, 0xEC, 0x93, 0x70, 0x40, 0xCF, 0xB0, 0xA0, 0x14, 0x0A, 0xFE, 0x0C,
  0x30, 0xBF, 0xF9, 0x07, 0x20, 0x4F, 0xF9, 0x0D, 0x30, 0x9B, 0x84, 0xB4, 0x10, 0x3B, 0xE0, 0x23,
  0x81, 0xDF, 0x66, 0xE0, 0x43, 0x03, 0x04, 0x70, 0xCD, 0x04, 0x75, 0x0D, 0xD0, 0x37, 0x5E, 0x02,
  0x74, 0x06, 0xD0, 0xD7, 0x40, 0x10, 0xED, 0x07, 0x74, 0x0C, 0xD0, 0xD7, 0x40, 0xBE, 0x03, 0x72,
  0x01, 0x0C, 0xE0, 0x57, 0x20, 0x10, 0xCE, 0x05, 0x72, 0x01, 0x0C, 0xE0, 0x57, 0x20, 0x10, 0xDE,
  0x04, 0x72, 0x01, 0x0D, 0xD0, 0xE0, 0x47, 0x20, 0x10, 0xDD, 0x0E, 0x03, 0x72, 0x01, 0x0D, 0xD0,
  0xE0, 0x47, 0x30, 0xBF, 0xFB, 0x09, 0x0B, 0xFF, 0xB0, 0x90, 0xBF, 0xFB, 0x09, 0x0B, 0xFF, 0xB0,
  0x90, 0xBF, 0xFB, 0x09,
  // "³" (U+00B3)
  0x48, 0x90, 0x38, 0xCD, 0xEE, 0xDB, 0x61, 0x60, 0x50, 0xDF, 0xA0, 0xE0, 0x63, 0x01, 0x0C, 0xFE,
  0x09, 0x20, 0xBF, 0xF9, 0x81, 0x50, 0x3F, 0xF9, 0x0C, 0x20, 0x7B, 0x84, 0x94, 0x21, 0x3B, 0xE0,
  0x12, 0x81, 0xBB, 0x26, 0x0E, 0xD0, 0x22, 0x01, 0x71, 0x0B, 0xD0, 0x27, 0x40, 0xCC, 0x0E, 0x74,
  0x04, 0xD0, 0x97, 0x18, 0x21, 0x37, 0xEC, 0x0D, 0x01, 0x50, 0x9F, 0xA0, 0xD0, 0x26, 0x09, 0xF0,
  0xE0, 0x77, 0x10, 0x9F, 0x81, 0xD7, 0x17, 0x09, 0xFB, 0x08, 0x60, 0x9F, 0xC0, 0x97, 0x28, 0x11,
  0x39, 0xE0, 0x47, 0x40, 0x8D, 0x0A, 0x74, 0x02, 0xD0, 0xD0, 0x27, 0x30, 0x2E, 0x81, 0xD9, 0x27,
  0x10, 0x7D, 0x0E, 0x0D, 0xA8, 0x6C, 0x74, 0x21, 0x13, 0x9E, 0x0B, 0x0D, 0xFF, 0xA0, 0x60, 0xDF,
  0xF9, 0x81, 0xC0, 0xDF, 0xF8, 0x3C, 0x10, 0x4B, 0xFD, 0x08, 0x58, 0x32, 0x6A, 0xCE, 0xA8, 0x3E,
  0xCA, 0x61, 0x40,
  // "´" (U+00B4)
  0x60, 0x68, 0x04, 0x70, 0x65, 0x04, 0xFA, 0x05, 0x50, 0xDF, 0x90, 0x65, 0x08, 0xF9, 0x06, 0x50,
  0x3F, 0x90, 0x56, 0x0D, 0xF0, 0x46, 0x09, 0xE0, 0xE0, 0x46, 0x05, 0xE0, 0xE0, 0x36, 0x02, 0x0E,
  0xD0, 0xC0, 0x17, 0x09, 0xD0, 0xA7, 0x20,
  // "µ" (U+00B5)
  0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9,
  0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A,
  0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75,
  0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9,
  0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A,
  0xF9, 0x0A, 0x74, 0x01, 0xF9, 0x0A, 0xF9, 0x0A, 0x74, 0x01, 0xF9, 0x0A, 0xF9, 0x0A, 0x74, 0x03,
  0xF9, 0x0A, 0xF9, 0x0B, 0x74, 0x06, 0xF9, 0x0A, 0xF9, 0x0C, 0x74, 0x08, 0xF9, 0x0A, 0xFA, 0x74,
  0x0D, 0xF9, 0x0A, 0xFA, 0x04, 0x72, 0x04, 0xFA, 0x0A, 0xFA, 0x0B, 0x71, 0x01, 0x0D, 0xFA, 0x0A,
  0xFB, 0x08, 0x60, 0x30, 0xCF, 0xB0, 0xAF, 0xC8, 0x4D, 0x97, 0x78, 0xCF, 0xD0, 0xAF, 0xFF, 0xF9,
  0x0A, 0xFF, 0xF0, 0xEF, 0x0A, 0xFF, 0xE0, 0xA0, 0x2F, 0x0A, 0xFF, 0xD0, 0xB2, 0x0C, 0xE0, 0xAF,
  0xFB, 0x0E, 0x07, 0x30, 0x6E, 0x0A, 0xFF, 0x98, 0x1D, 0x81, 0x40, 0x1E, 0x0A, 0xF9, 0x85, 0xC6,
  0x77, 0x64, 0x17, 0x71, 0xF9, 0x0A, 0x77, 0x7F, 0x90, 0xA7, 0x77, 0xF9, 0x0A, 0x77, 0x7F, 0x90,
  0xA7, 0x77, 0xF9, 0x0A, 0x77, 0x7F, 0x90, 0xA7, 0x77, 0xF9, 0x0A, 0x77, 0x7F, 0x90, 0xA7, 0x77,
  0xF9, 0x0A, 0x77, 0x7F, 0x90, 0xA7, 0x77, 0xF9, 0x0A, 0x77, 0x7F, 0x90, 0xA7, 0x77, 0xF9, 0x0A,
  0x77, 0x70,
  // "¶" (U+00B6)
  0x71, 0x84, 0x15, 0x9C, 0xDE, 0xFF, 0xB6, 0x03, 0x0A, 0xFF, 0xFA, 0x50, 0x9F, 0xFF, 0xC3, 0x01,
  0x0C, 0xFF, 0xFD, 0x30, 0xCF, 0xFF, 0xE2, 0x08, 0xFF, 0xD0, 0x13, 0x09, 0xC1, 0x01, 0xFF, 0xE0,
  0x13, 0x09, 0xC1, 0x07, 0xFF, 0xE0, 0x13, 0x09, 0xC1, 0x0C, 0xFF, 0xE0, 0x13, 0x09, 0xC0, 0x1F,
  0xFF, 0x01, 0x30, 0x9C, 0x03, 0xFF, 0xF0, 0x13, 0x09, 0xC0, 0x6F, 0xFF, 0x01, 0x30, 0x9C, 0x07,
  0xFF, 0xF0, 0x13, 0x09, 0xC0, 0x8F, 0xFF, 0x01, 0x30, 0x9C, 0x09, 0xFF, 0xF0, 0x13, 0x09, 0xC0,
  0x8F, 0xFF, 0x01, 0x30, 0x9C, 0x08, 0xFF, 0xF0, 0x13, 0x09, 0xC0, 0x7F, 0xFF, 0x01, 0x30, 0x9C,
  0x05, 0xFF, 0xF0, 0x13, 0x09, 0xC0, 0x3F, 0xFF, 0x01, 0x30, 0x9C, 0x1F, 0xFF, 0x01, 0x30, 0x9C,
  0x10, 0xBF, 0xFE, 0x01, 0x30, 0x9C, 0x10, 0x5F, 0xFE, 0x01, 0x30, 0x9C, 0x20, 0xDF, 0xFD, 0x01,
  0x30, 0x9C, 0x20, 0x5F, 0xFD, 0x01, 0x30, 0x9C, 0x30, 0x9F, 0xFC, 0x01, 0x30, 0x9C, 0x40, 0x7F,
  0xFB, 0x01, 0x30, 0x9C, 0x50, 0x40, 0xCF, 0xF9, 0x01, 0x30, 0x9C, 0x78, 0x14, 0x9D, 0xF0, 0xEC,
  0x01, 0x30, 0x9C, 0x73, 0x86, 0x13, 0x45, 0x43, 0x16, 0xC0, 0x13, 0x09, 0xC7, 0x73, 0x06, 0xC0,
  0x13, 0x09, 0xC7, 0x73, 0x06, 0xC0, 0x13, 0x09, 0xC7, 0x73, 0x06, 0xC0, 0x13, 0x09, 0xC7, 0x73,
  0x06, 0xC0, 0x13, 0x09, 0xC7, 0x73, 0x06, 0xC0, 0x13, 0x09, 0xC7, 0x73, 0x06, 0xC0, 0x13, 0x09,
  0xC7, 0x73, 0x06, 0xC0, 0x13, 0x09, 0xC7, 0x73, 0x06, 0xC0, 0x13, 0x09, 0xC7, 0x73, 0x06, 0xC0,
  0x13, 0x09, 0xC7, 0x73, 0x06, 0xC0, 0x13, 0x09, 0xC7, 0x73, 0x06, 0xC0, 0x13, 0x09, 0xC7, 0x73,
  0x06, 0xC0, 0x13, 0x09, 0xC7, 0x73, 0x06, 0xC0, 0x13, 0x09, 0xC7, 0x73, 0x06, 0xC0, 0x13, 0x09,
  0xC7, 0x73, 0x06, 0xC0, 0x13, 0x09, 0xC7, 0x73, 0x06, 0xC0, 0x13, 0x09, 0xC7, 0x73, 0x06, 0xC0,
  0x13, 0x09, 0xC7, 0x73, 0x06, 0xC0, 0x13, 0x09, 0xC7, 0x73, 0x06, 0xC0, 0x13, 0x09, 0xC7, 0x73,
  0x06, 0xC0, 0x13, 0x09, 0xC7, 0x73, 0x06, 0xC0, 0x13, 0x09, 0xC7, 0x73, 0x06, 0xC0, 0x13, 0x09,
  0xC7, 0x73, 0x03, 0x80, 0x07, 0x40, 0x48, 0x00, 0x70,
  // "·" (U+00B7)
  0x38, 0x42, 0x57, 0x75, 0x15, 0x0A, 0xE0, 0x83, 0x0A, 0xF9, 0x81, 0x80, 0x2F, 0xB0, 0x10, 0x5F,
  0xB0, 0x40, 0x6F, 0xB0, 0x05, 0xFB, 0x04, 0x01, 0xFA, 0x82, 0xE1, 0x09, 0xF9, 0x07, 0x30, 0x8D,
  0x0E, 0x07, 0x58, 0x41, 0x57, 0x75, 0x13,
  // "¸" (U+00B8)
  0x48, 0x41, 0x77, 0x77, 0x27, 0x10, 0x7C, 0x01, 0x71, 0x0D, 0xB0, 0xB7, 0x10, 0x4D, 0x0A, 0x03,
  0x60, 0xBF, 0x08, 0x50, 0xC0, 0xEF, 0x08, 0x60, 0x40, 0xCE, 0x01, 0x70, 0xED, 0x06, 0x70, 0xBD,
  0x07, 0x70, 0xED, 0x82, 0x70, 0x52, 0x20, 0x30, 0xBE, 0x05, 0x01, 0xFC, 0x81, 0xE0, 0x1F, 0xC8,
  0x15, 0x01, 0xFA, 0x0E, 0x05, 0x38, 0x90, 0x9C, 0xEE, 0xFE, 0xDA, 0x61, 0x30,
  // "¹" (U+00B9)
  0x71, 0x05, 0x0E, 0xC7, 0x50, 0x10, 0xAE, 0x74, 0x04, 0x0D, 0xF7, 0x30, 0x9F, 0xA7, 0x10, 0x30,
  0xDF, 0xB7, 0x08, 0xFD, 0x60, 0x10, 0xEF, 0xD7, 0x05, 0xD0, 0x70, 0x9D, 0x71, 0x0B, 0xA8, 0x2C,
  0x20, 0x9D, 0x71, 0x81, 0x2E, 0x73, 0x0A, 0xD7, 0x70, 0xAD, 0x77, 0x0B, 0xD7, 0x70, 0xBD, 0x77,
  0x0B, 0xD7, 0x70, 0xBD, 0x77, 0x0B, 0xD7, 0x70, 0xBD, 0x77, 0x0B, 0xD7, 0x70, 0xBD, 0x77, 0x0B,
  0xD7, 0x70, 0xBD, 0x74, 0x82, 0x23, 0x4C, 0xD8, 0x26, 0x43, 0x14, 0x09, 0x0E, 0xFF, 0x90, 0xC2,
  0x0B, 0xFF, 0xA0, 0xE2, 0x0B, 0xFF, 0xA0, 0xE2, 0x0B, 0xFF, 0xA0, 0xE0,
  // "º" (U+00BA)
  0x68, 0x66, 0xAD, 0xEE, 0xDA, 0x57, 0x30, 0x60, 0xEF, 0x90, 0xC0, 0x37, 0x08, 0xFD, 0x05, 0x50,
  0x6F, 0xF0, 0x33, 0x01, 0x0E, 0xD8, 0x28, 0x34, 0x9D, 0x0D, 0x30, 0x7D, 0x07, 0x40, 0x9D, 0x05,
  0x20, 0xDC, 0x0E, 0x50, 0x1D, 0x81, 0xB0, 0x1D, 0x0A, 0x60, 0xCC, 0x81, 0xE0, 0x3D, 0x08, 0x60,
  0x9D, 0x02, 0x04, 0xD0, 0x66, 0x08, 0xD0, 0x30, 0x5D, 0x06, 0x60, 0x8D, 0x00, 0x4D, 0x06, 0x60,
  0x8D, 0x00, 0x3D, 0x08, 0x60, 0xAD, 0x02, 0x1D, 0x0A, 0x60, 0xCD, 0x20, 0xCC, 0x0E, 0x50, 0x1D,
  0x0B, 0x20, 0x7D, 0x07, 0x40, 0x9D, 0x06, 0x30, 0xED, 0x82, 0x83, 0x49, 0xD0, 0xE4, 0x05, 0xFF,
  0x04, 0x50, 0x7F, 0xD0, 0x77, 0x05, 0x0D, 0xF9, 0x0D, 0x05, 0x73, 0x86, 0x6A, 0xDF, 0xED, 0xA5,
  0x60,
  // "»" (U+00BB)
  0x48, 0x21, 0x8D, 0x27, 0x28, 0x11, 0x9D, 0x76, 0x07, 0x0E, 0xA0, 0xC7, 0x01, 0x08, 0xB0, 0xA7,
  0x30, 0x50, 0xDD, 0x09, 0x50, 0x70, 0xED, 0x06, 0x71, 0x02, 0xF9, 0x05, 0x30, 0x4F, 0x90, 0x37,
  0x10, 0x6F, 0x0E, 0x02, 0x30, 0x9F, 0x0D, 0x01, 0x71, 0x0B, 0xF0, 0xC4, 0x0D, 0xF0, 0xA7, 0x10,
  0x10, 0xEF, 0x09, 0x30, 0x3F, 0x90, 0x77, 0x10, 0x5F, 0x90, 0x53, 0x07, 0xF9, 0x03, 0x71, 0x0A,
  0xF0, 0xE0, 0x23, 0x0C, 0xF0, 0xD0, 0x17, 0x01, 0x0E, 0xF0, 0xD3, 0x02, 0x0E, 0xF0, 0xB7, 0x10,
  0x4F, 0x90, 0xA3, 0x06, 0xF9, 0x07, 0x71, 0x09, 0xF9, 0x06, 0x30, 0xBF, 0x90, 0x47, 0x10, 0xDF,
  0x90, 0x32, 0x01, 0x0E, 0xF0, 0xE0, 0x17, 0x06, 0xF9, 0x08, 0x30, 0x8F, 0x90, 0x66, 0x01, 0x0E,
  0xF0, 0xE0, 0x22, 0x02, 0x0E, 0xF0, 0xD7, 0x0A, 0xF9, 0x05, 0x30, 0xCF, 0x90, 0x36, 0x05, 0xF9,
  0x08, 0x30, 0x7F, 0x90, 0x66, 0x01, 0x0E, 0xF0, 0xC3, 0x03, 0xF9, 0x09, 0x70, 0xBF, 0x0E, 0x01,
  0x30, 0xDF, 0x0D, 0x70, 0x6F, 0x90, 0x43, 0x08, 0xF0, 0xE0, 0x26, 0x02, 0xF9, 0x08, 0x30, 0x4F,
  0x90, 0x57, 0x0C, 0xF0, 0xB3, 0x01, 0x0D, 0xF0, 0x97, 0x07, 0xF0, 0xE0, 0x13, 0x0A, 0xF0, 0xC7,
  0x02, 0xF9, 0x04, 0x30, 0x4F, 0x0E, 0x02, 0x71, 0x04, 0x0C, 0xD0, 0x75, 0x05, 0x0D, 0xD0, 0x57,
  0x40, 0x50, 0xDA, 0x0B, 0x71, 0x06, 0x0E, 0xA0, 0x87, 0x78, 0x16, 0xC1, 0x73, 0x07, 0x0B, 0x73,
  // "¼" (U+00BC)
  0x60, 0x8C, 0x05, 0x77, 0x76, 0x05, 0x0E, 0xD0, 0x57, 0x77, 0x40, 0x30, 0xCF, 0x05, 0x77, 0x72,
  0x01, 0x09, 0xFA, 0x05, 0x77, 0x72, 0x03, 0xFB, 0x05, 0x77, 0x73, 0x09, 0xC0, 0xBC, 0x05, 0x77,
  0x18, 0x03, 0x22, 0x84, 0x1E, 0xFD, 0x35, 0xC0, 0x57, 0x70, 0x3E, 0x06, 0x30, 0x60, 0x72, 0x06,
  0xC0, 0x57, 0x70, 0xDD, 0x0A, 0x71, 0x06, 0xC0, 0x57, 0x60, 0xAD, 0x0D, 0x72, 0x06, 0xC0, 0x57,
  0x50, 0x6E, 0x03, 0x72, 0x07, 0xC0, 0x57, 0x40, 0x3E, 0x06, 0x73, 0x07, 0xC0, 0x57, 0x30, 0x10,
  0xDD, 0x0A, 0x74, 0x07, 0xC0, 0x57, 0x30, 0xAD, 0x0D, 0x75, 0x07, 0xC0, 0x57, 0x20, 0x7D, 0x0E,
  0x02, 0x75, 0x07, 0xC0, 0x57, 0x10, 0x3E, 0x06, 0x76, 0x07, 0xC0, 0x57, 0x01, 0x0D, 0xD0, 0x97,
  0x38, 0x2B, 0xCD, 0xEF, 0x81, 0xDC, 0x93, 0x0B, 0xD0, 0xC7, 0x30, 0x1F, 0xE0, 0xD2, 0x07, 0xD0,
  0xE0, 0x27, 0x30, 0x1F, 0xE8, 0x1D, 0x04, 0xE0, 0x57, 0x40, 0x1F, 0xE8, 0x1D, 0x1E, 0xD0, 0x97,
  0x77, 0x60, 0xBD, 0x0C, 0x77, 0x76, 0x08, 0xD0, 0xE0, 0x27, 0x77, 0x50, 0x4E, 0x05, 0x48, 0x45,
  0x66, 0x66, 0x37, 0x72, 0x01, 0x0E, 0xD0, 0x94, 0x04, 0xD0, 0x87, 0x72, 0x0C, 0xD0, 0xC5, 0x0D,
  0xD0, 0x87, 0x71, 0x08, 0xD0, 0xE0, 0x24, 0x09, 0xE0, 0x87, 0x70, 0x4E, 0x05, 0x40, 0x4F, 0x08,
  0x76, 0x02, 0x0E, 0xD0, 0x85, 0x0D, 0xF0, 0x87, 0x60, 0xCD, 0x0C, 0x50, 0x9B, 0x0A, 0xC0, 0x87,
  0x50, 0x9D, 0x0E, 0x01, 0x40, 0x3B, 0x0E, 0x04, 0xC0, 0x87, 0x40, 0x5E, 0x04, 0x50, 0xDB, 0x05,
  0x04, 0xC0, 0x87, 0x30, 0x20, 0xED, 0x08, 0x50, 0x8B, 0x81, 0xA0, 0x4C, 0x08, 0x73, 0x0C, 0xD0,
  0xB5, 0x03, 0xB8, 0x2E, 0x10, 0x4C, 0x08, 0x72, 0x09, 0xD0, 0xE0, 0x15, 0x0D, 0xB0, 0x52, 0x04,
  0xC0, 0x87, 0x10, 0x5E, 0x04, 0x50, 0x8B, 0x0A, 0x30, 0x4C, 0x08, 0x70, 0x20, 0xED, 0x08, 0x6F,
  0xFA, 0x0A, 0x40, 0xDD, 0x0B, 0x60, 0x1F, 0xFA, 0x0A, 0x30, 0xAD, 0x0E, 0x01, 0x60, 0x1F, 0xFA,
  0x0A, 0x38, 0x02, 0x50, 0x27, 0x01, 0xFF, 0xA0, 0xA7, 0x77, 0x50, 0x4C, 0x08, 0x77, 0x77, 0x10,
  0x4C, 0x08, 0x77, 0x77, 0x10, 0x4C, 0x08, 0x77, 0x77, 0x18, 0x42, 0x77, 0x77, 0x43,
  // "½" (U+00BD)
  0x60, 0x8C, 0x05, 0x77, 0x76, 0x05, 0x0E, 0xD0, 0x57, 0x77, 0x40, 0x30, 0xCF, 0x05, 0x77, 0x72,
  0x01, 0x09, 0xFA, 0x05, 0x77, 0x72, 0x03, 0xFB, 0x05, 0x77, 0x73, 0x09, 0xC0, 0xBC, 0x05, 0x77,
  0x18, 0x03, 0x22, 0x84, 0x1E, 0xFD, 0x35, 0xC0, 0x57, 0x70, 0x3E, 0x06, 0x30, 0x60, 0x72, 0x06,
  0xC0, 0x57, 0x60, 0x10, 0xDD, 0x0A, 0x71, 0x06, 0xC0, 0x57, 0x60, 0xAD, 0x0D, 0x72, 0x06, 0xC0,
  0x57, 0x50, 0x7D, 0x0E, 0x02, 0x72, 0x07, 0xC0, 0x57, 0x40, 0x3E, 0x05, 0x73, 0x07, 0xC0, 0x57,
  0x30, 0x10, 0xED, 0x09, 0x74, 0x07, 0xC0, 0x57, 0x30, 0xBD, 0x0C, 0x75, 0x07, 0xC0, 0x57, 0x20,
  0x8D, 0x0E, 0x02, 0x75, 0x07, 0xC0, 0x57, 0x10, 0x4E, 0x04, 0x76, 0x07, 0xC0, 0x57, 0x01, 0x0E,
  0xD0, 0x87, 0x38, 0x2B, 0xCD, 0xEF, 0x81, 0xDC, 0x93, 0x0C, 0xD0, 0xB7, 0x30, 0x1F, 0xE0, 0xD2,
  0x09, 0xD0, 0xE0, 0x17, 0x30, 0x1F, 0xE8, 0x1D, 0x05, 0xE0, 0x47, 0x40, 0x1F, 0xE8, 0x1D, 0x2E,
  0xD0, 0x77, 0x77, 0x60, 0xDD, 0x0B, 0x77, 0x76, 0x0A, 0xD0, 0xD0, 0x17, 0x77, 0x50, 0x6E, 0x89,
  0x13, 0x02, 0x7C, 0xDF, 0xEC, 0x92, 0x77, 0x20, 0x3E, 0x81, 0x61, 0xAF, 0xA0, 0x77, 0x70, 0x10,
  0xDD, 0x81, 0xA3, 0xEF, 0xC0, 0x57, 0x60, 0xBD, 0x82, 0xD0, 0x1E, 0xFC, 0x0D, 0x75, 0x07, 0xD0,
  0xE0, 0x22, 0x03, 0xA8, 0x3C, 0x40, 0x18, 0xD0, 0x27, 0x30, 0x4E, 0x05, 0x40, 0x70, 0x95, 0x0E,
  0xC0, 0x37, 0x20, 0x10, 0xED, 0x09, 0x75, 0x0E, 0xC0, 0x37, 0x20, 0xBD, 0x0C, 0x75, 0x03, 0xD7,
  0x20, 0x8D, 0x0E, 0x02, 0x75, 0x0C, 0xC0, 0xA7, 0x10, 0x5E, 0x05, 0x75, 0x0A, 0xC0, 0xE0, 0x27,
  0x02, 0x0E, 0xD0, 0x87, 0x50, 0xAD, 0x05, 0x71, 0x0C, 0xD0, 0xC7, 0x50, 0xAD, 0x07, 0x71, 0x09,
  0xD0, 0xE0, 0x17, 0x40, 0xAD, 0x08, 0x71, 0x05, 0xE0, 0x47, 0x40, 0x9D, 0x08, 0x71, 0x02, 0x0E,
  0xD0, 0x77, 0x40, 0x9D, 0x07, 0x72, 0x0D, 0xD0, 0xB7, 0x40, 0x9C, 0x0E, 0x05, 0x77, 0x76, 0x05,
  0xFF, 0x77, 0x60, 0x5F, 0xF7, 0x76, 0x05, 0xFF, 0x77, 0x60, 0x5F, 0xF0,
  // "¾" (U+00BE)
  0x28, 0x71, 0x7B, 0xDE, 0xFD, 0xA5, 0x77, 0x72, 0x09, 0xFA, 0x0D, 0x02, 0x77, 0x60, 0xDF, 0xC0,
  0xD0, 0x17, 0x75, 0x05, 0xFD, 0x07, 0x77, 0x68, 0x69, 0xFC, 0x61, 0x02, 0xCC, 0x0A, 0x77, 0x70,
  0x55, 0x04, 0xC0, 0xA7, 0x77, 0x60, 0x5C, 0x07, 0x73, 0x01, 0x0C, 0x80, 0x1D, 0x08, 0x78, 0x11,
  0x4D, 0xC0, 0x27, 0x30, 0xAD, 0x0D, 0x50, 0xAF, 0x90, 0x57, 0x30, 0x7D, 0x0E, 0x02, 0x50, 0xAE,
  0x0D, 0x02, 0x73, 0x03, 0xE0, 0x56, 0x0A, 0xF0, 0xC0, 0x47, 0x10, 0x10, 0xED, 0x09, 0x70, 0xAF,
  0xA0, 0x57, 0x0B, 0xD0, 0xC7, 0x50, 0x20, 0x8C, 0x0D, 0x60, 0x8D, 0x0E, 0x02, 0x77, 0x0C, 0xC0,
  0x24, 0x04, 0xE0, 0x46, 0x04, 0x71, 0x0D, 0xC0, 0x33, 0x01, 0x0E, 0xD0, 0x87, 0x83, 0xCE, 0x84,
  0x12, 0x02, 0x09, 0xD0, 0x13, 0x0C, 0xD0, 0xB7, 0x10, 0xCF, 0xD0, 0xB3, 0x09, 0xD0, 0xE0, 0x17,
  0x10, 0xCF, 0xC0, 0xE0, 0x22, 0x05, 0xE0, 0x47, 0x20, 0xAF, 0xB0, 0xD0, 0x32, 0x02, 0x0E, 0xD0,
  0x77, 0x48, 0x23, 0x8B, 0xEA, 0x82, 0xEC, 0x95, 0x40, 0xCD, 0x0B, 0x77, 0x74, 0x09, 0xD0, 0xD0,
  0x17, 0x77, 0x30, 0x6E, 0x03, 0x77, 0x73, 0x03, 0xE0, 0x74, 0x84, 0x9A, 0xAA, 0xA5, 0x77, 0x01,
  0x0D, 0xD0, 0xA4, 0x06, 0xD0, 0x87, 0x70, 0xAD, 0x0D, 0x01, 0x30, 0x10, 0xED, 0x08, 0x76, 0x07,
  0xE0, 0x34, 0x0B, 0xE0, 0x87, 0x50, 0x3E, 0x06, 0x40, 0x5F, 0x08, 0x74, 0x01, 0x0D, 0xD0, 0x94,
  0x01, 0x0E, 0xF0, 0x87, 0x40, 0xBD, 0x0C, 0x50, 0xAB, 0x09, 0xC0, 0x87, 0x30, 0x8D, 0x0E, 0x02,
  0x40, 0x4B, 0x0D, 0x04, 0xC0, 0x87, 0x20, 0x4E, 0x05, 0x40, 0x10, 0xDB, 0x00, 0x4C, 0x08, 0x71,
  0x01, 0x0E, 0xD0, 0x95, 0x09, 0xB8, 0x19, 0x04, 0xC0, 0x87, 0x10, 0xCD, 0x0C, 0x50, 0x4B, 0x82,
  0xD1, 0x04, 0xC0, 0x87, 0x09, 0xD0, 0xE0, 0x25, 0x0D, 0xB0, 0x42, 0x04, 0xC0, 0x86, 0x05, 0xE0,
  0x45, 0x08, 0xB0, 0x93, 0x04, 0xC0, 0x85, 0x02, 0x0E, 0xD0, 0x86, 0xFF, 0xA0, 0xA2, 0x0C, 0xD0,
  0xB6, 0x01, 0xFF, 0xA8, 0x1A, 0x09, 0xD0, 0xE0, 0x16, 0x01, 0xFF, 0xA0, 0xA1, 0x80, 0x25, 0x02,
  0x70, 0x1F, 0xFA, 0x0A, 0x77, 0x73, 0x04, 0xC0, 0x87, 0x77, 0x60, 0x4C, 0x08, 0x77, 0x76, 0x04,
  0xC0, 0x87, 0x77, 0x68, 0x42, 0x77, 0x77, 0x43,
  // "¿" (U+00BF)
  0x76, 0x83, 0x26, 0x76, 0x47, 0x76, 0x01, 0x0B, 0xD0, 0xD0, 0x47, 0x74, 0x0C, 0xF9, 0x03, 0x77,
  0x20, 0x6F, 0xA0, 0xB7, 0x72, 0x0A, 0xFB, 0x77, 0x20, 0xBF, 0xB7, 0x72, 0x0A, 0xFB, 0x77, 0x20,
  0x6F, 0xA0, 0xB7, 0x73, 0x0D, 0xF9, 0x04, 0x77, 0x30, 0x20, 0xCD, 0x0E, 0x06, 0x77, 0x68, 0x33,
  0x67, 0x64, 0x80, 0x9C, 0x20, 0x80, 0x34, 0x02, 0x77, 0x40, 0x2F, 0x09, 0x77, 0x40, 0x2F, 0x08,
  0x77, 0x40, 0x4F, 0x08, 0x77, 0x40, 0x8F, 0x07, 0x77, 0x30, 0x20, 0xEF, 0x04, 0x77, 0x20, 0x30,
  0xEF, 0x0E, 0x77, 0x20, 0x6F, 0xA0, 0x87, 0x71, 0x09, 0xFA, 0x0C, 0x77, 0x02, 0x0C, 0xFA, 0x0D,
  0x02, 0x76, 0x03, 0x0E, 0xFA, 0x0D, 0x02, 0x76, 0x04, 0xFB, 0x0A, 0x01, 0x76, 0x03, 0x0E, 0xFA,
  0x07, 0x77, 0x10, 0xDF, 0x90, 0xE0, 0x37, 0x71, 0x05, 0xF9, 0x0E, 0x02, 0x77, 0x20, 0xBF, 0x90,
  0x37, 0x73, 0x0E, 0xF0, 0xA7, 0x73, 0x01, 0xF9, 0x06, 0x77, 0x30, 0x2F, 0x90, 0x47, 0x73, 0x02,
  0xF9, 0x05, 0x76, 0x01, 0x30, 0x1F, 0x90, 0xB7, 0x48, 0x23, 0xAF, 0x63, 0x0E, 0xF9, 0x08, 0x01,
  0x68, 0x11, 0x7C, 0xB0, 0xE3, 0x0A, 0xFA, 0x85, 0xEA, 0x87, 0x8A, 0xDF, 0x07, 0x20, 0x3F, 0xFF,
  0xA0, 0xE3, 0x0A, 0xFF, 0xFA, 0x07, 0x20, 0x10, 0xDF, 0xFF, 0x90, 0xE3, 0x01, 0x0C, 0xFF, 0xE0,
  0xB0, 0x45, 0x07, 0x0E, 0xFF, 0x98, 0x1E, 0x93, 0x71, 0x81, 0x17, 0xCF, 0xB8, 0x1C, 0x94, 0x77,
  0x18, 0x63, 0x57, 0x77, 0x65, 0x37, 0x20,
  // "À" (U+00C0)
  0x71, 0x06, 0x80, 0x47, 0x06, 0x77, 0x75, 0x06, 0xFA, 0x03, 0x77, 0x75, 0x07, 0xF9, 0x0C, 0x77,
  0x76, 0x07, 0xF9, 0x07, 0x77, 0x76, 0x06, 0xF9, 0x03, 0x77, 0x76, 0x05, 0xF0, 0xD7, 0x77, 0x70,
  0x40, 0xEE, 0x08, 0x77, 0x77, 0x03, 0x0E, 0xE0, 0x47, 0x77, 0x70, 0x20, 0xDD, 0x0E, 0x01, 0x77,
  0x77, 0x01, 0x0B, 0xD0, 0x88, 0x0A, 0xC4, 0x00, 0xBF, 0xB0, 0xA7, 0x77, 0x3F, 0xC0, 0xE7, 0x77,
  0x20, 0x4F, 0xD0, 0x37, 0x77, 0x10, 0x8F, 0xD0, 0x77, 0x77, 0x10, 0xDF, 0xD0, 0xC7, 0x77, 0x01,
  0xFF, 0x01, 0x77, 0x60, 0x6F, 0xF0, 0x57, 0x76, 0x0A, 0xE0, 0x0B, 0xE0, 0x97, 0x76, 0x0E, 0xE0,
  0x08, 0xE0, 0xE7, 0x75, 0x03, 0xF0, 0x04, 0xF0, 0x37, 0x74, 0x08, 0xF2, 0xF0, 0x77, 0x74, 0x0C,
  0xE0, 0xC2, 0x0C, 0xE0, 0xB7, 0x73, 0x01, 0xF0, 0x82, 0x08, 0xF0, 0x17, 0x72, 0x05, 0xF0, 0x42,
  0x04, 0xF0, 0x57, 0x72, 0x0A, 0xF4, 0xF0, 0x97, 0x72, 0x0E, 0xE0, 0xB4, 0x0C, 0xE0, 0xD7, 0x71,
  0x03, 0xF0, 0x74, 0x08, 0xF0, 0x27, 0x70, 0x7F, 0x03, 0x40, 0x4F, 0x07, 0x77, 0x0C, 0xE0, 0xE6,
  0xF0, 0xB7, 0x60, 0x1F, 0x0A, 0x60, 0xCF, 0x76, 0x05, 0xF0, 0x66, 0x08, 0xF0, 0x47, 0x50, 0x9F,
  0x02, 0x60, 0x4F, 0x09, 0x75, 0x0E, 0xE0, 0xE7, 0x1F, 0x0D, 0x74, 0x03, 0xF0, 0x97, 0x10, 0xBF,
  0x02, 0x73, 0x07, 0xF9, 0x80, 0x4E, 0xF9, 0x07, 0x73, 0x0B, 0xFF, 0xFB, 0x0B, 0x73, 0xFF, 0xFD,
  0x72, 0x05, 0xFF, 0xFD, 0x04, 0x71, 0x09, 0xFF, 0xFD, 0x09, 0x71, 0x0D, 0xFF, 0xFD, 0x0D, 0x70,
  0x2F, 0xFF, 0xF0, 0x26, 0x07, 0xF0, 0x97, 0x50, 0xBF, 0x06, 0x60, 0xBF, 0x05, 0x75, 0x08, 0xF0,
  0xB6, 0xF9, 0x01, 0x75, 0x04, 0xF0, 0xE5, 0x04, 0xF0, 0xD7, 0x60, 0x1F, 0x90, 0x44, 0x09, 0xF0,
  0x97, 0x70, 0xCF, 0x08, 0x40, 0xDF, 0x05, 0x77, 0x09, 0xF0, 0xD3, 0x02, 0xF9, 0x02, 0x77, 0x05,
  0xF9, 0x02, 0x20, 0x6F, 0x0D, 0x77, 0x10, 0x1F, 0x90, 0x62, 0x0A, 0xF0, 0xA7, 0x72, 0x0D, 0xF0,
  0xA2, 0x0E, 0xF0, 0x67, 0x72, 0x0A, 0xF8, 0x1E, 0x04, 0xF9, 0x02, 0x77, 0x20, 0x6F, 0x90, 0x40,
  // "Á" (U+00C1)
  0x77, 0x50, 0x68, 0x04, 0x70, 0x67, 0x77, 0x40, 0x4F, 0xA0, 0x57, 0x77, 0x40, 0xDF, 0x90, 0x67,
  0x77, 0x40, 0x8F, 0x90, 0x67, 0x77, 0x40, 0x3F, 0x90, 0x57, 0x77, 0x50, 0xDF, 0x04, 0x77, 0x75,
  0x09, 0xE0, 0xE0, 0x47, 0x77, 0x50, 0x5E, 0x0E, 0x03, 0x77, 0x75, 0x02, 0x0E, 0xD0, 0xC0, 0x17,
  0x77, 0x60, 0x9D, 0x0A, 0x80, 0xAD, 0x00, 0x0B, 0xFB, 0x0A, 0x77, 0x73, 0xFC, 0x0E, 0x77, 0x72,
  0x04, 0xFD, 0x03, 0x77, 0x71, 0x08, 0xFD, 0x07, 0x77, 0x71, 0x0D, 0xFD, 0x0C, 0x77, 0x70, 0x1F,
  0xF0, 0x17, 0x76, 0x06, 0xFF, 0x05, 0x77, 0x60, 0xAE, 0x00, 0xBE, 0x09, 0x77, 0x60, 0xEE, 0x00,
  0x8E, 0x0E, 0x77, 0x50, 0x3F, 0x00, 0x4F, 0x03, 0x77, 0x40, 0x8F, 0x2F, 0x07, 0x77, 0x40, 0xCE,
  0x0C, 0x20, 0xCE, 0x0B, 0x77, 0x30, 0x1F, 0x08, 0x20, 0x8F, 0x01, 0x77, 0x20, 0x5F, 0x04, 0x20,
  0x4F, 0x05, 0x77, 0x20, 0xAF, 0x4F, 0x09, 0x77, 0x20, 0xEE, 0x0B, 0x40, 0xCE, 0x0D, 0x77, 0x10,
  0x3F, 0x07, 0x40, 0x8F, 0x02, 0x77, 0x07, 0xF0, 0x34, 0x04, 0xF0, 0x77, 0x70, 0xCE, 0x0E, 0x6F,
  0x0B, 0x76, 0x01, 0xF0, 0xA6, 0x0C, 0xF7, 0x60, 0x5F, 0x06, 0x60, 0x8F, 0x04, 0x75, 0x09, 0xF0,
  0x26, 0x04, 0xF0, 0x97, 0x50, 0xEE, 0x0E, 0x71, 0xF0, 0xD7, 0x40, 0x3F, 0x09, 0x71, 0x0B, 0xF0,
  0x27, 0x30, 0x7F, 0x98, 0x04, 0xEF, 0x90, 0x77, 0x30, 0xBF, 0xFF, 0xB0, 0xB7, 0x3F, 0xFF, 0xD7,
  0x20, 0x5F, 0xFF, 0xD0, 0x47, 0x10, 0x9F, 0xFF, 0xD0, 0x97, 0x10, 0xDF, 0xFF, 0xD0, 0xD7, 0x02,
  0xFF, 0xFF, 0x02, 0x60, 0x7F, 0x09, 0x75, 0x0B, 0xF0, 0x66, 0x0B, 0xF0, 0x57, 0x50, 0x8F, 0x0B,
  0x6F, 0x90, 0x17, 0x50, 0x4F, 0x0E, 0x50, 0x4F, 0x0D, 0x76, 0x01, 0xF9, 0x04, 0x40, 0x9F, 0x09,
  0x77, 0x0C, 0xF0, 0x84, 0x0D, 0xF0, 0x57, 0x70, 0x9F, 0x0D, 0x30, 0x2F, 0x90, 0x27, 0x70, 0x5F,
  0x90, 0x22, 0x06, 0xF0, 0xD7, 0x71, 0x01, 0xF9, 0x06, 0x20, 0xAF, 0x0A, 0x77, 0x20, 0xDF, 0x0A,
  0x20, 0xEF, 0x06, 0x77, 0x20, 0xAF, 0x81, 0xE0, 0x4F, 0x90, 0x27, 0x72, 0x06, 0xF9, 0x04,
  // "Â" (U+00C2)
  0x76, 0x02, 0x80, 0x47, 0x06, 0x77, 0x75, 0x0C, 0xFA, 0x04, 0x77, 0x73, 0x07, 0xFB, 0x0D, 0x77,
  0x72, 0x03, 0xFD, 0x09, 0x77, 0x70, 0x10, 0xDF, 0xE0, 0x57, 0x76, 0x0A, 0xE0, 0xA0, 0x5E, 0x0E,
  0x02, 0x77, 0x40, 0x7E, 0x0A, 0x20, 0x5E, 0x0D, 0x01, 0x77, 0x20, 0x4E, 0x09, 0x40, 0x40, 0xED,
  0x0B, 0x77, 0x10, 0x30, 0xED, 0x07, 0x60, 0x30, 0xDD, 0x08, 0x77, 0x0C, 0xC0, 0xE0, 0x47, 0x10,
  0x10, 0xBD, 0x02, 0x80, 0xAB, 0x60, 0x0B, 0xFB, 0x0A, 0x77, 0x73, 0xFC, 0x0E, 0x77, 0x72, 0x04,
  0xFD, 0x03, 0x77, 0x71, 0x08, 0xFD, 0x07, 0x77, 0x71, 0x0D, 0xFD, 0x0C, 0x77, 0x70, 0x1F, 0xF0,
  0x17, 0x76, 0x06, 0xFF, 0x05, 0x77, 0x60, 0xAE, 0x00, 0xBE, 0x09, 0x77, 0x60, 0xEE, 0x00, 0x8E,
  0x0E, 0x77, 0x50, 0x3F, 0x00, 0x4F, 0x03, 0x77, 0x40, 0x8F, 0x2F, 0x07, 0x77, 0x40, 0xCE, 0x0C,
  0x20, 0xCE, 0x0B, 0x77, 0x30, 0x1F, 0x08, 0x20, 0x8F, 0x01, 0x77, 0x20, 0x5F, 0x04, 0x20, 0x4F,
  0x05, 0x77, 0x20, 0xAF, 0x4F, 0x09, 0x77, 0x20, 0xEE, 0x0B, 0x40, 0xCE, 0x0D, 0x77, 0x10, 0x3F,
  0x07, 0x40, 0x8F, 0x02, 0x77, 0x07, 0xF0, 0x34, 0x04, 0xF0, 0x77, 0x70, 0xCE, 0x0E, 0x6F, 0x0B,
  0x76, 0x01, 0xF0, 0xA6, 0x0C, 0xF7, 0x60, 0x5F, 0x06, 0x60, 0x8F, 0x04, 0x75, 0x09, 0xF0, 0x26,
  0x04, 0xF0, 0x97, 0x50, 0xEE, 0x0E, 0x71, 0xF0, 0xD7, 0x40, 0x3F, 0x09, 0x71, 0x0B, 0xF0, 0x27,
  0x30, 0x7F, 0x98, 0x04, 0xEF, 0x90, 0x77, 0x30, 0xBF, 0xFF, 0xB0, 0xB7, 0x3F, 0xFF, 0xD7, 0x20,
  0x5F, 0xFF, 0xD0, 0x47, 0x10, 0x9F, 0xFF, 0xD0, 0x97, 0x10, 0xDF, 0xFF, 0xD0, 0xD7, 0x02, 0xFF,
  0xFF, 0x02, 0x60, 0x7F, 0x09, 0x75, 0x0B, 0xF0, 0x66, 0x0B, 0xF0, 0x57, 0x50, 0x8F, 0x0B, 0x6F,
  0x90, 0x17, 0x50, 0x4F, 0x0E, 0x50, 0x4F, 0x0D, 0x76, 0x01, 0xF9, 0x04, 0x40, 0x9F, 0x09, 0x77,
  0x0C, 0xF0, 0x84, 0x0D, 0xF0, 0x57, 0x70, 0x9F, 0x0D, 0x30, 0x2F, 0x90, 0x27, 0x70, 0x5F, 0x90,
  0x22, 0x06, 0xF0, 0xD7, 0x71, 0x01, 0xF9, 0x06, 0x20, 0xAF, 0x0A, 0x77, 0x20, 0xDF, 0x0A, 0x20,
  0xEF, 0x06, 0x77, 0x20, 0xAF, 0x81, 0xE0, 0x4F, 0x90, 0x27, 0x72, 0x06, 0xF9, 0x04,
  // "Ã" (U+00C3)
  0x73, 0x85, 0x4B, 0xEE, 0xD9, 0x37, 0x01, 0xC0, 0x57, 0x71, 0x09, 0xF0, 0xC0, 0x45, 0x06, 0xC0,
  0x37, 0x70, 0x6F, 0xB8, 0x4C, 0x62, 0x03, 0xEC, 0x01, 0x77, 0x0E, 0xFF, 0xD0, 0xD7, 0x70, 0x6F,
  0xFE, 0x08, 0x77, 0x0C, 0xFF, 0xE0, 0x17, 0x7C, 0x84, 0xD3, 0x02, 0x7D, 0xFB, 0x06, 0x77, 0x03,
  0xC0, 0x55, 0x05, 0x0C, 0xF0, 0x87, 0x71, 0x05, 0xC7, 0x18, 0x54, 0x9D, 0xEE, 0xA4, 0x80, 0xAC,
  0x20, 0x0B, 0xFB, 0x0A, 0x77, 0x73, 0xFC, 0x0E, 0x77, 0x72, 0x04, 0xFD, 0x03, 0x77, 0x71, 0x08,
  0xFD, 0x07, 0x77, 0x71, 0x0D, 0xFD, 0x0C, 0x77, 0x70, 0x1F, 0xF0, 0x17, 0x76, 0x06, 0xFF, 0x05,
  0x77, 0x60, 0xAE, 0x00, 0xBE, 0x09, 0x77, 0x60, 0xEE, 0x00, 0x8E, 0x0E, 0x77, 0x50, 0x3F, 0x00,
  0x4F, 0x03, 0x77, 0x40, 0x8F, 0x2F, 0x07, 0x77, 0x40, 0xCE, 0x0C, 0x20, 0xCE, 0x0B, 0x77, 0x30,
  0x1F, 0x08, 0x20, 0x8F, 0x01, 0x77, 0x20, 0x5F, 0x04, 0x20, 0x4F, 0x05, 0x77, 0x20, 0xAF, 0x4F,
  0x09, 0x77, 0x20, 0xEE, 0x0B, 0x40, 0xCE, 0x0D, 0x77, 0x10, 0x3F, 0x07, 0x40, 0x8F, 0x02, 0x77,
  0x07, 0xF0, 0x34, 0x04, 0xF0, 0x77, 0x70, 0xCE, 0x0E, 0x6F, 0x0B, 0x76, 0x01, 0xF0, 0xA6, 0x0C,
  0xF7, 0x60, 0x5F, 0x06, 0x60, 0x8F, 0x04, 0x75, 0x09, 0xF0, 0x26, 0x04, 0xF0, 0x97, 0x50, 0xEE,
  0x0E, 0x71, 0xF0, 0xD7, 0x40, 0x3F, 0x09, 0x71, 0x0B, 0xF0, 0x27, 0x30, 0x7F, 0x98, 0x04, 0xEF,
  0x90, 0x77, 0x30, 0xBF, 0xFF, 0xB0, 0xB7, 0x3F, 0xFF, 0xD7, 0x20, 0x5F, 0xFF, 0xD0, 0x47, 0x10,
  0x9F, 0xFF, 0xD0, 0x97, 0x10, 0xDF, 0xFF, 0xD0, 0xD7, 0x02, 0xFF, 0xFF, 0x02, 0x60, 0x7F, 0x09,
  0x75, 0x0B, 0xF0, 0x66, 0x0B, 0xF0, 0x57, 0x50, 0x8F, 0x0B, 0x6F, 0x90, 0x17, 0x50, 0x4F, 0x0E,
  0x50, 0x4F, 0x0D, 0x76, 0x01, 0xF9, 0x04, 0x40, 0x9F, 0x09, 0x77, 0x0C, 0xF0, 0x84, 0x0D, 0xF0,
  0x57, 0x70, 0x9F, 0x0D, 0x30, 0x2F, 0x90, 0x27, 0x70, 0x5F, 0x90, 0x22, 0x06, 0xF0, 0xD7, 0x71,
  0x01, 0xF9, 0x06, 0x20, 0xAF, 0x0A, 0x77, 0x20, 0xDF, 0x0A, 0x20, 0xEF, 0x06, 0x77, 0x20, 0xAF,
  0x81, 0xE0, 0x4F, 0x90, 0x27, 0x72, 0x06, 0xF9, 0x04,
  // "Ä" (U+00C4)
  0x71, 0x84, 0x3B, 0xEF, 0xC5, 0x71, 0x84, 0x3B, 0xEF, 0xC6, 0x77, 0x10, 0x4E, 0x08, 0x60, 0x4E,
  0x09, 0x77, 0x0D, 0xF0, 0x25, 0x0D, 0xF0, 0x27, 0x50, 0x1F, 0x90, 0x64, 0x01, 0xF9, 0x06, 0x75,
  0x02, 0xF9, 0x07, 0x40, 0x2F, 0x90, 0x77, 0x50, 0x1F, 0x90, 0x54, 0x01, 0xF9, 0x06, 0x76, 0x0C,
  0xF0, 0x15, 0x0C, 0xF0, 0x27, 0x60, 0x4E, 0x07, 0x60, 0x3E, 0x08, 0x77, 0x18, 0x43, 0xBE, 0xFC,
  0x57, 0x18, 0x43, 0xBE, 0xFC, 0x58, 0x0A, 0xC0, 0x00, 0xBF, 0xB0, 0xA7, 0x77, 0x3F, 0xC0, 0xE7,
  0x77, 0x20, 0x4F, 0xD0, 0x37, 0x77, 0x10, 0x8F, 0xD0, 0x77, 0x77, 0x10, 0xDF, 0xD0, 0xC7, 0x77,
  0x01, 0xFF, 0x01, 0x77, 0x60, 0x6F, 0xF0, 0x57, 0x76, 0x0A, 0xE0, 0x0B, 0xE0, 0x97, 0x76, 0x0E,
  0xE0, 0x08, 0xE0, 0xE7, 0x75, 0x03, 0xF0, 0x04, 0xF0, 0x37, 0x74, 0x08, 0xF2, 0xF0, 0x77, 0x74,
  0x0C, 0xE0, 0xC2, 0x0C, 0xE0, 0xB7, 0x73, 0x01, 0xF0, 0x82, 0x08, 0xF0, 0x17, 0x72, 0x05, 0xF0,
  0x42, 0x04, 0xF0, 0x57, 0x72, 0x0A, 0xF4, 0xF0, 0x97, 0x72, 0x0E, 0xE0, 0xB4, 0x0C, 0xE0, 0xD7,
  0x71, 0x03, 0xF0, 0x74, 0x08, 0xF0, 0x27, 0x70, 0x7F, 0x03, 0x40, 0x4F, 0x07, 0x77, 0x0C, 0xE0,
  0xE6, 0xF0, 0xB7, 0x60, 0x1F, 0x0A, 0x60, 0xCF, 0x76, 0x05, 0xF0, 0x66, 0x08, 0xF0, 0x47, 0x50,
  0x9F, 0x02, 0x60, 0x4F, 0x09, 0x75, 0x0E, 0xE0, 0xE7, 0x1F, 0x0D, 0x74, 0x03, 0xF0, 0x97, 0x10,
  0xBF, 0x02, 0x73, 0x07, 0xF9, 0x80, 0x4E, 0xF9, 0x07, 0x73, 0x0B, 0xFF, 0xFB, 0x0B, 0x73, 0xFF,
  0xFD, 0x72, 0x05, 0xFF, 0xFD, 0x04, 0x71, 0x09, 0xFF, 0xFD, 0x09, 0x71, 0x0D, 0xFF, 0xFD, 0x0D,
  0x70, 0x2F, 0xFF, 0xF0, 0x26, 0x07, 0xF0, 0x97, 0x50, 0xBF, 0x06, 0x60, 0xBF, 0x05, 0x75, 0x08,
  0xF0, 0xB6, 0xF9, 0x01, 0x75, 0x04, 0xF0, 0xE5, 0x04, 0xF0, 0xD7, 0x60, 0x1F, 0x90, 0x44, 0x09,
  0xF0, 0x97, 0x70, 0xCF, 0x08, 0x40, 0xDF, 0x05, 0x77, 0x09, 0xF0, 0xD3, 0x02, 0xF9, 0x02, 0x77,
  0x05, 0xF9, 0x02, 0x20, 0x6F, 0x0D, 0x77, 0x10, 0x1F, 0x90, 0x62, 0x0A, 0xF0, 0xA7, 0x72, 0x0D,
  0xF0, 0xA2, 0x0E, 0xF0, 0x67, 0x72, 0x0A, 0xF8, 0x1E, 0x04, 0xF9, 0x02, 0x77, 0x20, 0x6F, 0x90,
  0x40,
  // "Å" (U+00C5)
  0x77, 0x86, 0x4A, 0xDF, 0xEC, 0x82, 0x77, 0x76, 0x0A, 0xF9, 0x07, 0x77, 0x74, 0x0B, 0xFB, 0x08,
  0x77, 0x72, 0x06, 0xFD, 0x04, 0x77, 0x71, 0x0C, 0xC8, 0x26, 0x11, 0x8C, 0x0B, 0x77, 0x70, 0x1C,
  0x07, 0x40, 0xAC, 0x77, 0x70, 0x2C, 0x03, 0x40, 0x5C, 0x01, 0x77, 0x60, 0x2C, 0x03, 0x40, 0x5C,
  0x01, 0x77, 0x60, 0x1C, 0x07, 0x40, 0xAB, 0x0E, 0x77, 0x71, 0x0C, 0xB8, 0x3E, 0x51, 0x18, 0xC0,
  0xB7, 0x77, 0x10, 0x6F, 0xD0, 0x47, 0x77, 0x20, 0xBF, 0xB0, 0x87, 0x77, 0x40, 0xAF, 0x90, 0x87,
  0x77, 0x68, 0x64, 0xAD, 0xFE, 0xD9, 0x28, 0x0A, 0xC6, 0x00, 0xBF, 0xB0, 0xA7, 0x77, 0x3F, 0xC0,
  0xE7, 0x77, 0x20, 0x4F, 0xD0, 0x37, 0x77, 0x10, 0x8F, 0xD0, 0x77, 0x77, 0x10, 0xDF, 0xD0, 0xC7,
  0x77, 0x01, 0xFF, 0x01, 0x77, 0x60, 0x6F, 0xF0, 0x57, 0x76, 0x0A, 0xE0, 0x0B, 0xE0, 0x97, 0x76,
  0x0E, 0xE0, 0x08, 0xE0, 0xE7, 0x75, 0x03, 0xF0, 0x04, 0xF0, 0x37, 0x74, 0x08, 0xF2, 0xF0, 0x77,
  0x74, 0x0C, 0xE0, 0xC2, 0x0C, 0xE0, 0xB7, 0x73, 0x01, 0xF0, 0x82, 0x08, 0xF0, 0x17, 0x72, 0x05,
  0xF0, 0x42, 0x04, 0xF0, 0x57, 0x72, 0x0A, 0xF4, 0xF0, 0x97, 0x72, 0x0E, 0xE0, 0xB4, 0x0C, 0xE0,
  0xD7, 0x71, 0x03, 0xF0, 0x74, 0x08, 0xF0, 0x27, 0x70, 0x7F, 0x03, 0x40, 0x4F, 0x07, 0x77, 0x0C,
  0xE0, 0xE6, 0xF0, 0xB7, 0x60, 0x1F, 0x0A, 0x60, 0xCF, 0x76, 0x05, 0xF0, 0x66, 0x08, 0xF0, 0x47,
  0x50, 0x9F, 0x02, 0x60, 0x4F, 0x09, 0x75, 0x0E, 0xE0, 0xE7, 0x1F, 0x0D, 0x74, 0x03, 0xF0, 0x97,
  0x10, 0xBF, 0x02, 0x73, 0x07, 0xF9, 0x80, 0x4E, 0xF9, 0x07, 0x73, 0x0B, 0xFF, 0xFB, 0x0B, 0x73,
  0xFF, 0xFD, 0x72, 0x05, 0xFF, 0xFD, 0x04, 0x71, 0x09, 0xFF, 0xFD, 0x09, 0x71, 0x0D, 0xFF, 0xFD,
  0x0D, 0x70, 0x2F, 0xFF, 0xF0, 0x26, 0x07, 0xF0, 0x97, 0x50, 0xBF, 0x06, 0x60, 0xBF, 0x05, 0x75,
  0x08, 0xF0, 0xB6, 0xF9, 0x01, 0x75, 0x04, 0xF0, 0xE5, 0x04, 0xF0, 0xD7, 0x60, 0x1F, 0x90, 0x44,
  0x09, 0xF0, 0x97, 0x70, 0xCF, 0x08, 0x40, 0xDF, 0x05, 0x77, 0x09, 0xF0, 0xD3, 0x02, 0xF9, 0x02,
  0x77, 0x05, 0xF9, 0x02, 0x20, 0x6F, 0x0D, 0x77, 0x10, 0x1F, 0x90, 0x62, 0x0A, 0xF0, 0xA7, 0x72,
  0x0D, 0xF0, 0xA2, 0x0E, 0xF0, 0x67, 0x72, 0x0A, 0xF8, 0x1E, 0x04, 0xF9, 0x02, 0x77, 0x20, 0x6F,
  0x90, 0x40,
  // "Æ" (U+00C6)
  0x73, 0x05, 0xFF, 0xFA, 0x03, 0x73, 0x08, 0xFF, 0xFA, 0x03, 0x73, 0x0C, 0xFF, 0xFA, 0x03, 0x72,
  0x01, 0xFF, 0xFB, 0x03, 0x72, 0x04, 0xFF, 0xFB, 0x03, 0x72, 0x08, 0xFF, 0xFB, 0x03, 0x72, 0x0C,
  0xF0, 0xEF, 0x98, 0x04, 0xE0, 0x37, 0x2F, 0x81, 0x40, 0x7E, 0x0C, 0x77, 0x30, 0x4F, 0x81, 0x10,
  0x7E, 0x0C, 0x77, 0x30, 0x7E, 0x0D, 0x20, 0x7E, 0x0C, 0x77, 0x30, 0xBE, 0x09, 0x20, 0x7E, 0x0C,
  0x77, 0x3F, 0x06, 0x20, 0x7E, 0x0C, 0x77, 0x20, 0x3F, 0x02, 0x20, 0x7E, 0x0C, 0x77, 0x20, 0x7E,
  0x0E, 0x30, 0x7E, 0x0C, 0x77, 0x20, 0xBE, 0x0B, 0x30, 0x7E, 0x0C, 0x77, 0x20, 0xEE, 0x07, 0x30,
  0x7E, 0x0C, 0x77, 0x10, 0x3F, 0x04, 0x30, 0x7F, 0xF0, 0x17, 0x07, 0xF0, 0x13, 0x07, 0xFF, 0x01,
  0x70, 0xAE, 0x0C, 0x40, 0x7F, 0xF0, 0x17, 0x0E, 0xE0, 0x94, 0x07, 0xFF, 0x01, 0x60, 0x2F, 0x05,
  0x40, 0x7F, 0xF0, 0x16, 0x06, 0xF0, 0x24, 0x07, 0xFF, 0x01, 0x60, 0xAE, 0x0E, 0x50, 0x7F, 0x80,
  0x3E, 0x01, 0x60, 0xEE, 0x0A, 0x50, 0x7E, 0x0C, 0x76, 0x02, 0xFF, 0xE0, 0xC7, 0x60, 0x6F, 0xFE,
  0x0C, 0x76, 0x09, 0xFF, 0xE0, 0xC7, 0x60, 0xDF, 0xFE, 0x0C, 0x75, 0x02, 0xFF, 0xF0, 0xC7, 0x50,
  0x5F, 0xFF, 0x0C, 0x75, 0x09, 0xF8, 0x03, 0xEF, 0x0C, 0x75, 0x0D, 0xE0, 0xD7, 0x07, 0xE0, 0xC7,
  0x40, 0x1F, 0x0A, 0x70, 0x7E, 0x0C, 0x74, 0x05, 0xF0, 0x67, 0x07, 0xE0, 0xC7, 0x40, 0x9F, 0x03,
  0x70, 0x7E, 0x0C, 0x74, 0x0C, 0xF7, 0x10, 0x7F, 0x80, 0x4E, 0x81, 0x30, 0x1F, 0x0C, 0x71, 0x07,
  0xFF, 0x98, 0x13, 0x04, 0xF0, 0x97, 0x10, 0x7F, 0xF9, 0x81, 0x30, 0x8F, 0x05, 0x71, 0x07, 0xFF,
  0x98, 0x13, 0x0C, 0xF0, 0x27, 0x10, 0x7F, 0xF9, 0x03, 0x1F, 0x0E, 0x72, 0x07, 0xFF, 0x90, 0x30,
  0x4F, 0x0B, 0x72, 0x07, 0xFF, 0x90, 0x30,
  // "Ç" (U+00C7)
  0x77, 0x28, 0x73, 0x56, 0x77, 0x65, 0x41, 0x77, 0x48, 0x14, 0x9D, 0xFB, 0x82, 0xEA, 0x51, 0x75,
  0x07, 0x0E, 0xFF, 0xA8, 0x1E, 0x92, 0x71, 0x05, 0x0E, 0xFF, 0xE0, 0x47, 0x09, 0xFF, 0xF0, 0xD7,
  0x0B, 0xFF, 0xF9, 0x07, 0x60, 0xCF, 0xFF, 0x90, 0xE0, 0x15, 0x09, 0xFC, 0x86, 0xDA, 0x87, 0x78,
  0xAD, 0xC0, 0x95, 0x05, 0xFB, 0x0A, 0x03, 0x71, 0x83, 0x38, 0xEF, 0x25, 0x0D, 0xF9, 0x0E, 0x04,
  0x76, 0x05, 0x50, 0x7F, 0x90, 0xE0, 0x37, 0x76, 0x0D, 0xF9, 0x05, 0x77, 0x60, 0x4F, 0x90, 0xB7,
  0x77, 0x0A, 0xF9, 0x04, 0x77, 0x70, 0xEF, 0x0D, 0x77, 0x70, 0x3F, 0x90, 0x97, 0x77, 0x06, 0xF9,
  0x05, 0x77, 0x70, 0x9F, 0x90, 0x37, 0x77, 0x0B, 0xF9, 0x77, 0x71, 0x0D, 0xF0, 0xE7, 0x77, 0x10,
  0xDF, 0x0D, 0x77, 0x71, 0x0E, 0xF0, 0xD7, 0x77, 0x1F, 0x90, 0xC7, 0x77, 0x1F, 0x90, 0xD7, 0x77,
  0x10, 0xEF, 0x0E, 0x77, 0x71, 0x0D, 0xF0, 0xE7, 0x77, 0x10, 0xCF, 0x90, 0x17, 0x77, 0x0A, 0xF9,
  0x03, 0x77, 0x70, 0x8F, 0x90, 0x67, 0x77, 0x05, 0xF9, 0x0A, 0x77, 0x70, 0x1F, 0x90, 0xE7, 0x77,
  0x10, 0xCF, 0x90, 0x67, 0x77, 0x07, 0xF9, 0x0E, 0x77, 0x70, 0x2F, 0xA0, 0xA7, 0x77, 0x0A, 0xFA,
  0x0A, 0x77, 0x04, 0x09, 0x40, 0x2F, 0xB8, 0x1E, 0x61, 0x71, 0x83, 0x38, 0xDF, 0xE5, 0x08, 0xFD,
  0x86, 0xB9, 0x87, 0x89, 0xBE, 0xC0, 0xE6, 0x0C, 0xFF, 0xFA, 0x0E, 0x60, 0x10, 0xDF, 0xFF, 0x90,
  0xE7, 0x02, 0x0D, 0xFF, 0xF0, 0xE7, 0x20, 0xAF, 0xFE, 0x0E, 0x73, 0x04, 0x0C, 0xFF, 0xB0, 0xE0,
  0x97, 0x58, 0x13, 0x8D, 0xFC, 0x81, 0xC8, 0x47, 0x74, 0x0A, 0xC8, 0x28, 0x64, 0x27, 0x77, 0x10,
  0xDB, 0x0B, 0x77, 0x74, 0x04, 0xD0, 0xA0, 0x37, 0x77, 0x20, 0xBF, 0x08, 0x77, 0x71, 0x0C, 0x0E,
  0xF0, 0x87, 0x77, 0x20, 0x40, 0xCE, 0x01, 0x77, 0x73, 0x0E, 0xD0, 0x67, 0x77, 0x30, 0xBD, 0x07,
  0x77, 0x73, 0x0E, 0xD0, 0x77, 0x74, 0x05, 0x02, 0x20, 0x30, 0xBE, 0x05, 0x77, 0x30, 0x1F, 0xC0,
  0xE7, 0x74, 0x01, 0xFC, 0x05, 0x77, 0x40, 0x1F, 0xA0, 0xE0, 0x57, 0x76, 0x89, 0x09, 0xCE, 0xEF,
  0xED, 0xA6, 0x17, 0x30,
  // "È" (U+00C8)
  0x40, 0x68, 0x04, 0x70, 0x67, 0x74, 0x06, 0xFA, 0x03, 0x77, 0x40, 0x7F, 0x90, 0xC7, 0x75, 0x07,
  0xF9, 0x07, 0x77, 0x50, 0x6F, 0x90, 0x37, 0x75, 0x05, 0xF0, 0xD7, 0x76, 0x04, 0x0E, 0xE0, 0x87,
  0x76, 0x03, 0x0E, 0xE0, 0x47, 0x76, 0x02, 0x0D, 0xD0, 0xE0, 0x17, 0x76, 0x01, 0x0B, 0xD0, 0x88,
  0x09, 0xE4, 0x00, 0x3F, 0xFF, 0xD0, 0xC0, 0x3F, 0xFF, 0xD0, 0xC0, 0x3F, 0xFF, 0xD0, 0xC0, 0x3F,
  0xFF, 0xD0, 0xC0, 0x3F, 0xFF, 0xD0, 0xC0, 0x3F, 0xFF, 0xD0, 0xC0, 0x3F, 0x98, 0x09, 0x6E, 0x0B,
  0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90,
  0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40,
  0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0xFF, 0xC8, 0x1E, 0x03, 0xFF, 0xFC,
  0x81, 0xE0, 0x3F, 0xFF, 0xC8, 0x1E, 0x03, 0xFF, 0xFC, 0x81, 0xE0, 0x3F, 0xFF, 0xC8, 0x1E, 0x03,
  0xFF, 0xFC, 0x81, 0xE0, 0x3F, 0x98, 0x09, 0x5E, 0x81, 0xD0, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9,
  0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74,
  0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90,
  0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40,
  0x3F, 0x98, 0x09, 0x6E, 0x0B, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD,
  0x0C, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C,
  // "É" (U+00C9)
  0x77, 0x10, 0x68, 0x04, 0x70, 0x67, 0x73, 0x04, 0xFA, 0x05, 0x77, 0x30, 0xDF, 0x90, 0x67, 0x73,
  0x08, 0xF9, 0x06, 0x77, 0x30, 0x3F, 0x90, 0x57, 0x74, 0x0D, 0xF0, 0x47, 0x74, 0x09, 0xE0, 0xE0,
  0x47, 0x74, 0x05, 0xE0, 0xE0, 0x37, 0x74, 0x02, 0x0E, 0xD0, 0xC0, 0x17, 0x75, 0x09, 0xD0, 0xA8,
  0x09, 0xF0, 0x00, 0x3F, 0xFF, 0xD0, 0xC0, 0x3F, 0xFF, 0xD0, 0xC0, 0x3F, 0xFF, 0xD0, 0xC0, 0x3F,
  0xFF, 0xD0, 0xC0, 0x3F, 0xFF, 0xD0, 0xC0, 0x3F, 0xFF, 0xD0, 0xC0, 0x3F, 0x98, 0x09, 0x6E, 0x0B,
  0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90,
  0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40,
  0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0xFF, 0xC8, 0x1E, 0x03, 0xFF, 0xFC,
  0x81, 0xE0, 0x3F, 0xFF, 0xC8, 0x1E, 0x03, 0xFF, 0xFC, 0x81, 0xE0, 0x3F, 0xFF, 0xC8, 0x1E, 0x03,
  0xFF, 0xFC, 0x81, 0xE0, 0x3F, 0x98, 0x09, 0x5E, 0x81, 0xD0, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9,
  0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74,
  0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90,
  0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40,
  0x3F, 0x98, 0x09, 0x6E, 0x0B, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD,
  0x0C, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C,
  // "Ê" (U+00CA)
  0x72, 0x02, 0x80, 0x47, 0x06, 0x77, 0x40, 0xCF, 0xA0, 0x47, 0x72, 0x07, 0xFB, 0x0D, 0x77, 0x10,
  0x3F, 0xD0, 0x97, 0x60, 0x10, 0xDF, 0xE0, 0x57, 0x50, 0xAE, 0x0A, 0x05, 0xE0, 0xE0, 0x27, 0x30,
  0x7E, 0x0A, 0x20, 0x5E, 0x0D, 0x01, 0x71, 0x04, 0xE0, 0x94, 0x04, 0x0E, 0xD0, 0xB7, 0x03, 0x0E,
  0xD0, 0x76, 0x03, 0x0D, 0xD0, 0x86, 0x0C, 0xC0, 0xE0, 0x47, 0x10, 0x10, 0xBD, 0x02, 0x80, 0x9D,
  0x60, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD,
  0x0C, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xF9, 0x80, 0x96, 0xE0, 0xB0, 0x3F,
  0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77,
  0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9,
  0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xFF, 0xFC, 0x81, 0xE0, 0x3F, 0xFF, 0xC8, 0x1E,
  0x03, 0xFF, 0xFC, 0x81, 0xE0, 0x3F, 0xFF, 0xC8, 0x1E, 0x03, 0xFF, 0xFC, 0x81, 0xE0, 0x3F, 0xFF,
  0xC8, 0x1E, 0x03, 0xF9, 0x80, 0x95, 0xE8, 0x1D, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37,
  0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F,
  0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77,
  0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9,
  0x80, 0x96, 0xE0, 0xB0, 0x3F, 0xFF, 0xD0, 0xC0, 0x3F, 0xFF, 0xD0, 0xC0, 0x3F, 0xFF, 0xD0, 0xC0,
  0x3F, 0xFF, 0xD0, 0xC0, 0x3F, 0xFF, 0xD0, 0xC0, 0x3F, 0xFF, 0xD0, 0xC0,
  // "Ë" (U+00CB)
  0x48, 0x43, 0xBE, 0xFC, 0x57, 0x18, 0x43, 0xBE, 0xFC, 0x67, 0x04, 0xE0, 0x86, 0x04, 0xE0, 0x96,
  0x0D, 0xF0, 0x25, 0x0D, 0xF0, 0x24, 0x01, 0xF9, 0x06, 0x40, 0x1F, 0x90, 0x64, 0x02, 0xF9, 0x07,
  0x40, 0x2F, 0x90, 0x74, 0x01, 0xF9, 0x05, 0x40, 0x1F, 0x90, 0x65, 0x0C, 0xF0, 0x15, 0x0C, 0xF0,
  0x25, 0x04, 0xE0, 0x76, 0x03, 0xE0, 0x87, 0x84, 0x3B, 0xEF, 0xC5, 0x71, 0x84, 0x3B, 0xEF, 0xC5,
  0x80, 0x9E, 0x00, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C, 0x03,
  0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xF9, 0x80, 0x96, 0xE0,
  0xB0, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9,
  0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74,
  0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xFF, 0xFC, 0x81, 0xE0, 0x3F, 0xFF,
  0xC8, 0x1E, 0x03, 0xFF, 0xFC, 0x81, 0xE0, 0x3F, 0xFF, 0xC8, 0x1E, 0x03, 0xFF, 0xFC, 0x81, 0xE0,
  0x3F, 0xFF, 0xC8, 0x1E, 0x03, 0xF9, 0x80, 0x95, 0xE8, 0x1D, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F,
  0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77,
  0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9,
  0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74,
  0x03, 0xF9, 0x80, 0x96, 0xE0, 0xB0, 0x3F, 0xFF, 0xD0, 0xC0, 0x3F, 0xFF, 0xD0, 0xC0, 0x3F, 0xFF,
  0xD0, 0xC0, 0x3F, 0xFF, 0xD0, 0xC0, 0x3F, 0xFF, 0xD0, 0xC0, 0x3F, 0xFF, 0xD0, 0xC0,
  // "Ì" (U+00CC)
  0x30, 0x68, 0x04, 0x70, 0x67, 0x72, 0x06, 0xFA, 0x03, 0x77, 0x20, 0x7F, 0x90, 0xC7, 0x73, 0x07,
  0xF9, 0x07, 0x77, 0x30, 0x6F, 0x90, 0x37, 0x73, 0x05, 0xF0, 0xD7, 0x74, 0x04, 0x0E, 0xE0, 0x87,
  0x74, 0x03, 0x0E, 0xE0, 0x47, 0x74, 0x02, 0x0D, 0xD0, 0xE0, 0x17, 0x74, 0x01, 0x0B, 0xD0, 0x88,
  0x09, 0xD3, 0x00, 0x9F, 0xFF, 0xB0, 0x09, 0xFF, 0xFB, 0x00, 0x9F, 0xFF, 0xB0, 0x09, 0xFF, 0xFB,
  0x00, 0x9F, 0xFF, 0xB0, 0x09, 0xFF, 0xFB, 0x87, 0x91, 0x35, 0x78, 0xAC, 0xEF, 0xB8, 0x6D, 0xCA,
  0x87, 0x53, 0x17, 0x10, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17,
  0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F,
  0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77,
  0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9,
  0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72,
  0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90,
  0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20,
  0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01,
  0x73, 0x85, 0x12, 0x46, 0x89, 0xCF, 0x98, 0x5B, 0x97, 0x64, 0x21, 0x20, 0x80, 0xEF, 0xFF, 0x98,
  0x1E, 0x89, 0xFF, 0xFB, 0x00, 0x9F, 0xFF, 0xB0, 0x09, 0xFF, 0xFB, 0x00, 0x9F, 0xFF, 0xB0, 0x09,
  0xFF, 0xFB, 0x09,
  // "Í" (U+00CD)
  0x77, 0x06, 0x80, 0x47, 0x06, 0x77, 0x10, 0x4F, 0xA0, 0x57, 0x71, 0x0D, 0xF9, 0x06, 0x77, 0x10,
  0x8F, 0x90, 0x67, 0x71, 0x03, 0xF9, 0x05, 0x77, 0x20, 0xDF, 0x04, 0x77, 0x20, 0x9E, 0x0E, 0x04,
  0x77, 0x20, 0x5E, 0x0E, 0x03, 0x77, 0x20, 0x20, 0xED, 0x0C, 0x01, 0x77, 0x30, 0x9D, 0x0A, 0x80,
  0x9D, 0x70, 0x09, 0xFF, 0xFB, 0x00, 0x9F, 0xFF, 0xB0, 0x09, 0xFF, 0xFB, 0x00, 0x9F, 0xFF, 0xB0,
  0x09, 0xFF, 0xFB, 0x00, 0x9F, 0xFF, 0xB8, 0x79, 0x13, 0x57, 0x8A, 0xCE, 0xFB, 0x86, 0xDC, 0xA8,
  0x75, 0x31, 0x71, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77,
  0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9,
  0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72,
  0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90,
  0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20,
  0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01,
  0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04,
  0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17,
  0x38, 0x51, 0x24, 0x68, 0x9C, 0xF9, 0x85, 0xB9, 0x76, 0x42, 0x12, 0x08, 0x0E, 0xFF, 0xF9, 0x81,
  0xE8, 0x9F, 0xFF, 0xB0, 0x09, 0xFF, 0xFB, 0x00, 0x9F, 0xFF, 0xB0, 0x09, 0xFF, 0xFB, 0x00, 0x9F,
  0xFF, 0xB0, 0x90,
  // "Î" (U+00CE)
  0x71, 0x02, 0x80, 0x47, 0x06, 0x77, 0x20, 0xCF, 0xA0, 0x47, 0x70, 0x7F, 0xB0, 0xD7, 0x60, 0x3F,
  0xD0, 0x97, 0x40, 0x10, 0xDF, 0xE0, 0x57, 0x30, 0xAE, 0x0A, 0x05, 0xE0, 0xE0, 0x27, 0x10, 0x7E,
  0x0A, 0x20, 0x5E, 0x0D, 0x01, 0x60, 0x4E, 0x09, 0x40, 0x40, 0xED, 0x0B, 0x50, 0x30, 0xED, 0x07,
  0x60, 0x30, 0xDD, 0x08, 0x40, 0xCC, 0x0E, 0x04, 0x71, 0x01, 0x0B, 0xD0, 0x28, 0x09, 0xC5, 0x00,
  0x9F, 0xFF, 0xB0, 0x09, 0xFF, 0xFB, 0x00, 0x9F, 0xFF, 0xB0, 0x09, 0xFF, 0xFB, 0x00, 0x9F, 0xFF,
  0xB0, 0x09, 0xFF, 0xFB, 0x87, 0x91, 0x35, 0x78, 0xAC, 0xEF, 0xB8, 0x6D, 0xCA, 0x87, 0x53, 0x17,
  0x10, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9,
  0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72,
  0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90,
  0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20,
  0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01,
  0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04,
  0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17,
  0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x73, 0x85, 0x12,
  0x46, 0x89, 0xCF, 0x98, 0x5B, 0x97, 0x64, 0x21, 0x20, 0x80, 0xEF, 0xFF, 0x98, 0x1E, 0x89, 0xFF,
  0xFB, 0x00, 0x9F, 0xFF, 0xB0, 0x09, 0xFF, 0xFB, 0x00, 0x9F, 0xFF, 0xB0, 0x09, 0xFF, 0xFB, 0x09,
  // "Ï" (U+00CF)
  0x38, 0x43, 0xBE, 0xFC, 0x57, 0x18, 0x43, 0xBE, 0xFC, 0x65, 0x04, 0xE0, 0x86, 0x04, 0xE0, 0x94,
  0x0D, 0xF0, 0x25, 0x0D, 0xF0, 0x22, 0x01, 0xF9, 0x06, 0x40, 0x1F, 0x90, 0x62, 0x02, 0xF9, 0x07,
  0x40, 0x2F, 0x90, 0x72, 0x01, 0xF9, 0x05, 0x40, 0x1F, 0x90, 0x63, 0x0C, 0xF0, 0x15, 0x0C, 0xF0,
  0x23, 0x04, 0xE0, 0x76, 0x03, 0xE0, 0x85, 0x84, 0x3B, 0xEF, 0xC5, 0x71, 0x84, 0x3B, 0xEF, 0xC5,
  0x80, 0x9C, 0x70, 0x09, 0xFF, 0xFB, 0x00, 0x9F, 0xFF, 0xB0, 0x09, 0xFF, 0xFB, 0x00, 0x9F, 0xFF,
  0xB0, 0x09, 0xFF, 0xFB, 0x00, 0x9F, 0xFF, 0xB8, 0x79, 0x13, 0x57, 0x8A, 0xCE, 0xFB, 0x86, 0xDC,
  0xA8, 0x75, 0x31, 0x71, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01,
  0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04,
  0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17,
  0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F,
  0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77,
  0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9,
  0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72,
  0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90,
  0x17, 0x38, 0x51, 0x24, 0x68, 0x9C, 0xF9, 0x85, 0xB9, 0x76, 0x42, 0x12, 0x08, 0x0E, 0xFF, 0xF9,
  0x81, 0xE8, 0x9F, 0xFF, 0xB0, 0x09, 0xFF, 0xFB, 0x00, 0x9F, 0xFF, 0xB0, 0x09, 0xFF, 0xFB, 0x00,
  0x9F, 0xFF, 0xB0, 0x90,
  // "Ð" (U+00D0)
  0x20, 0x4F, 0xF8, 0x3E, 0xDB, 0x84, 0x77, 0x10, 0x4F, 0xFD, 0x81, 0xEA, 0x37, 0x50, 0x4F, 0xFF,
  0x90, 0xA0, 0x27, 0x30, 0x4F, 0xFF, 0xA0, 0xE0, 0x57, 0x20, 0x4F, 0xFF, 0xC0, 0x77, 0x10, 0x4F,
  0xFF, 0xD0, 0x77, 0x04, 0xFA, 0x80, 0x0E, 0xFF, 0x05, 0x60, 0x4F, 0x90, 0x45, 0x81, 0x25, 0xAF,
  0xB0, 0xE0, 0x15, 0x04, 0xF9, 0x04, 0x71, 0x02, 0x0C, 0xFA, 0x09, 0x50, 0x4F, 0x90, 0x47, 0x30,
  0xBF, 0xA0, 0x14, 0x04, 0xF9, 0x04, 0x74, 0x0D, 0xF9, 0x08, 0x40, 0x4F, 0x90, 0x47, 0x40, 0x5F,
  0x90, 0xD4, 0x04, 0xF9, 0x04, 0x75, 0x0D, 0xF9, 0x02, 0x30, 0x4F, 0x90, 0x47, 0x50, 0x8F, 0x90,
  0x73, 0x04, 0xF9, 0x04, 0x75, 0x04, 0xF9, 0x0A, 0x30, 0x4F, 0x90, 0x47, 0x50, 0x1F, 0x90, 0xC3,
  0x04, 0xF9, 0x04, 0x76, 0x0E, 0xF0, 0xE3, 0x04, 0xF9, 0x04, 0x76, 0x0C, 0xF9, 0x10, 0x0E, 0xFB,
  0x80, 0x1E, 0x09, 0x70, 0xBF, 0x90, 0x2F, 0xFB, 0x09, 0x70, 0xAF, 0x90, 0x2F, 0xFB, 0x09, 0x70,
  0x9F, 0x90, 0x3F, 0xFB, 0x09, 0x70, 0xAF, 0x90, 0x2F, 0xFB, 0x09, 0x70, 0xBF, 0x90, 0x2F, 0xFB,
  0x09, 0x70, 0xBF, 0x90, 0x1F, 0xFB, 0x09, 0x70, 0xDF, 0x93, 0x04, 0xF9, 0x04, 0x76, 0xF9, 0x0D,
  0x30, 0x4F, 0x90, 0x47, 0x50, 0x2F, 0x90, 0xA3, 0x04, 0xF9, 0x04, 0x75, 0x06, 0xF9, 0x08, 0x30,
  0x4F, 0x90, 0x47, 0x50, 0xBF, 0x90, 0x43, 0x04, 0xF9, 0x04, 0x74, 0x01, 0xF9, 0x0E, 0x40, 0x4F,
  0x90, 0x47, 0x40, 0x9F, 0x90, 0xA4, 0x04, 0xF9, 0x04, 0x73, 0x03, 0xFA, 0x04, 0x40, 0x4F, 0x90,
  0x47, 0x20, 0x20, 0xEF, 0x90, 0xC5, 0x04, 0xF9, 0x04, 0x71, 0x06, 0x0E, 0xFA, 0x04, 0x50, 0x4F,
  0x90, 0x44, 0x82, 0x13, 0x8D, 0xFB, 0x09, 0x60, 0x4F, 0xA0, 0xFE, 0xFF, 0x0D, 0x01, 0x60, 0x4F,
  0xFF, 0xC0, 0xE0, 0x27, 0x04, 0xFF, 0xFB, 0x0D, 0x02, 0x71, 0x04, 0xFF, 0xFA, 0x0B, 0x01, 0x72,
  0x04, 0xFF, 0xF0, 0xE0, 0x67, 0x40, 0x4F, 0xFD, 0x0C, 0x06, 0x76, 0x04, 0xFE, 0x84, 0xED, 0xC9,
  0x62, 0x76,
  // "Ñ" (U+00D1)
  0x71, 0x85, 0x4B, 0xEE, 0xD9, 0x37, 0x01, 0xC0, 0x57, 0x40, 0x9F, 0x0C, 0x04, 0x50, 0x6C, 0x03,
  0x73, 0x06, 0xFB, 0x84, 0xC6, 0x20, 0x3E, 0xC0, 0x17, 0x30, 0xEF, 0xFD, 0x0D, 0x73, 0x06, 0xFF,
  0xE0, 0x87, 0x30, 0xCF, 0xFE, 0x01, 0x73, 0xC8, 0x4D, 0x30, 0x27, 0xDF, 0xB0, 0x67, 0x30, 0x3C,
  0x05, 0x50, 0x50, 0xCF, 0x08, 0x74, 0x05, 0xC7, 0x18, 0x54, 0x9D, 0xEE, 0xA4, 0x80, 0xA8, 0x40,
  0x04, 0xFC, 0x0A, 0x73, 0x06, 0xF0, 0x04, 0xFD, 0x73, 0x06, 0xF0, 0x04, 0xFD, 0x05, 0x72, 0x06,
  0xF0, 0x04, 0xFD, 0x0A, 0x72, 0x06, 0xF0, 0x04, 0xFE, 0x72, 0x06, 0xF0, 0x04, 0xFE, 0x05, 0x71,
  0x06, 0xF0, 0x04, 0xFE, 0x0A, 0x71, 0x06, 0xF0, 0x04, 0xFF, 0x71, 0x06, 0xF0, 0x04, 0xE0, 0xD0,
  0xCE, 0x05, 0x70, 0x6F, 0x00, 0x4E, 0x0E, 0x07, 0xE0, 0xA7, 0x06, 0xF0, 0x04, 0xF0, 0x2E, 0x0E,
  0x70, 0x6F, 0x00, 0x4F, 0x10, 0xCE, 0x05, 0x60, 0x6F, 0x00, 0x4F, 0x01, 0x07, 0xE0, 0xA6, 0x06,
  0xF0, 0x04, 0xF0, 0x20, 0x1E, 0x0E, 0x60, 0x6F, 0x00, 0x4F, 0x81, 0x30, 0xCE, 0x05, 0x50, 0x6F,
  0x00, 0x4F, 0x81, 0x40, 0x7E, 0x0A, 0x50, 0x6F, 0x00, 0x4F, 0x81, 0x40, 0x1E, 0x0E, 0x50, 0x6F,
  0x00, 0x4F, 0x05, 0x20, 0xCE, 0x05, 0x40, 0x6F, 0x00, 0x4F, 0x05, 0x20, 0x7E, 0x0A, 0x40, 0x6F,
  0x00, 0x4F, 0x06, 0x20, 0x2E, 0x0E, 0x40, 0x6F, 0x00, 0x4F, 0x06, 0x30, 0xCE, 0x05, 0x30, 0x6F,
  0x00, 0x4F, 0x06, 0x30, 0x7E, 0x0A, 0x30, 0x6F, 0x00, 0x4F, 0x06, 0x30, 0x2E, 0x0E, 0x30, 0x6F,
  0x00, 0x4F, 0x06, 0x40, 0xCE, 0x05, 0x20, 0x6F, 0x00, 0x4F, 0x06, 0x40, 0x7E, 0x0A, 0x20, 0x6F,
  0x00, 0x4F, 0x06, 0x40, 0x2E, 0x0E, 0x20, 0x5F, 0x00, 0x4F, 0x06, 0x50, 0xCE, 0x81, 0x50, 0x5F,
  0x00, 0x4F, 0x06, 0x50, 0x7E, 0x81, 0xA0, 0x4F, 0x00, 0x4F, 0x06, 0x50, 0x2E, 0x81, 0xE0, 0x4F,
  0x00, 0x4F, 0x06, 0x60, 0xCE, 0x05, 0x03, 0xF0, 0x04, 0xF0, 0x66, 0x07, 0xE0, 0xA0, 0x3F, 0x00,
  0x4F, 0x06, 0x60, 0x2E, 0x0E, 0x02, 0xF0, 0x04, 0xF0, 0x67, 0x0C, 0xE0, 0x6F, 0x00, 0x4F, 0x06,
  0x70, 0x7E, 0x0B, 0xF0, 0x04, 0xF0, 0x67, 0x02, 0xFF, 0x00, 0x4F, 0x06, 0x71, 0x0C, 0xFE, 0x00,
  0x4F, 0x06, 0x71, 0x07, 0xFE, 0x00, 0x4F, 0x06, 0x71, 0x02, 0xFE, 0x00, 0x4F, 0x06, 0x72, 0x0C,
  0xFD, 0x00, 0x4F, 0x06, 0x72, 0x07, 0xFD, 0x00, 0x4F, 0x06, 0x72, 0x02, 0xFD, 0x00, 0x4F, 0x06,
  0x73, 0x0C, 0xFC, 0x04,
  // "Ò" (U+00D2)
  0x70, 0x68, 0x04, 0x70, 0x67, 0x77, 0x30, 0x6F, 0xA0, 0x37, 0x77, 0x30, 0x7F, 0x90, 0xC7, 0x77,
  0x40, 0x7F, 0x90, 0x77, 0x77, 0x40, 0x6F, 0x90, 0x37, 0x77, 0x40, 0x5F, 0x0D, 0x77, 0x75, 0x04,
  0x0E, 0xE0, 0x87, 0x77, 0x50, 0x30, 0xEE, 0x04, 0x77, 0x75, 0x02, 0x0D, 0xD0, 0xE0, 0x17, 0x77,
  0x50, 0x10, 0xBD, 0x08, 0x80, 0x9F, 0x20, 0x86, 0x35, 0x67, 0x76, 0x53, 0x77, 0x72, 0x81, 0x5B,
  0xEF, 0x98, 0x1E, 0xB5, 0x77, 0x40, 0x60, 0xDF, 0xF0, 0xE0, 0x67, 0x71, 0x0A, 0xFF, 0xC0, 0xA0,
  0x17, 0x40, 0x10, 0xCF, 0xFE, 0x0C, 0x01, 0x73, 0x0B, 0xFF, 0xF9, 0x0B, 0x72, 0x07, 0xFF, 0xFB,
  0x07, 0x70, 0x2F, 0xB8, 0x4E, 0xA8, 0x8A, 0xEF, 0xA0, 0xE0, 0x16, 0x09, 0xFA, 0x08, 0x60, 0x8F,
  0xA0, 0x95, 0x01, 0xFA, 0x07, 0x71, 0x06, 0xFA, 0x01, 0x40, 0x7F, 0x90, 0xB7, 0x30, 0xBF, 0x90,
  0x64, 0x0C, 0xF9, 0x03, 0x73, 0x03, 0xF9, 0x0C, 0x30, 0x1F, 0x90, 0xD7, 0x50, 0xDF, 0x90, 0x12,
  0x05, 0xF9, 0x08, 0x75, 0x08, 0xF9, 0x05, 0x20, 0x8F, 0x90, 0x57, 0x50, 0x4F, 0x90, 0x82, 0x0B,
  0xF9, 0x01, 0x75, 0x01, 0xF9, 0x0B, 0x20, 0xDF, 0x97, 0x7F, 0x90, 0xD2, 0xF9, 0x0D, 0x77, 0x0D,
  0xF9, 0x10, 0x1F, 0x90, 0xB7, 0x70, 0xBF, 0x91, 0x02, 0xF9, 0x0A, 0x77, 0x0B, 0xF9, 0x00, 0x2F,
  0x90, 0xA7, 0x70, 0xAF, 0x90, 0x20, 0x3F, 0x90, 0x97, 0x70, 0x9F, 0x90, 0x20, 0x3F, 0x90, 0x97,
  0x70, 0xAF, 0x90, 0x02, 0xF9, 0x0A, 0x77, 0x0A, 0xF9, 0x00, 0x2F, 0x90, 0xA7, 0x70, 0xBF, 0x90,
  0x20, 0x1F, 0x90, 0xB7, 0x70, 0xBF, 0x92, 0xF9, 0x0D, 0x77, 0x0D, 0xF9, 0x20, 0xDF, 0x0E, 0x77,
  0xF9, 0x0D, 0x20, 0xBF, 0x90, 0x17, 0x50, 0x1F, 0x90, 0xB2, 0x08, 0xF9, 0x04, 0x75, 0x05, 0xF9,
  0x08, 0x20, 0x5F, 0x90, 0x87, 0x50, 0x8F, 0x90, 0x52, 0x01, 0xF9, 0x0D, 0x75, 0x0D, 0xF9, 0x01,
  0x30, 0xCF, 0x90, 0x37, 0x30, 0x3F, 0x90, 0xC4, 0x07, 0xF9, 0x0B, 0x73, 0x0B, 0xF9, 0x07, 0x40,
  0x1F, 0xA0, 0x67, 0x10, 0x6F, 0xA0, 0x15, 0x09, 0xFA, 0x08, 0x60, 0x8F, 0xA0, 0x96, 0x02, 0xFB,
  0x84, 0xE9, 0x77, 0x9E, 0xFB, 0x01, 0x70, 0x7F, 0xFF, 0xB0, 0x77, 0x20, 0xBF, 0xFF, 0x90, 0xB7,
  0x30, 0x10, 0xCF, 0xFE, 0x0C, 0x01, 0x74, 0x01, 0x0B, 0xFF, 0xC0, 0xB0, 0x17, 0x70, 0x60, 0xEF,
  0xF0, 0xE0, 0x67, 0x74, 0x05, 0x0B, 0xFB, 0x0B, 0x05, 0x77, 0x72, 0x86, 0x35, 0x67, 0x76, 0x53,
  0x76,
  // "Ó" (U+00D3)
  0x77, 0x40, 0x68, 0x04, 0x70, 0x67, 0x77, 0x20, 0x4F, 0xA0, 0x57, 0x77, 0x20, 0xDF, 0x90, 0x67,
  0x77, 0x20, 0x8F, 0x90, 0x67, 0x77, 0x20, 0x3F, 0x90, 0x57, 0x77, 0x30, 0xDF, 0x04, 0x77, 0x73,
  0x09, 0xE0, 0xE0, 0x47, 0x77, 0x30, 0x5E, 0x0E, 0x03, 0x77, 0x73, 0x02, 0x0E, 0xD0, 0xC0, 0x17,
  0x77, 0x40, 0x9D, 0x0A, 0x80, 0x9F, 0x60, 0x86, 0x35, 0x67, 0x76, 0x53, 0x77, 0x72, 0x81, 0x5B,
  0xEF, 0x98, 0x1E, 0xB5, 0x77, 0x40, 0x60, 0xDF, 0xF0, 0xE0, 0x67, 0x71, 0x0A, 0xFF, 0xC0, 0xA0,
  0x17, 0x40, 0x10, 0xCF, 0xFE, 0x0C, 0x01, 0x73, 0x0B, 0xFF, 0xF9, 0x0B, 0x72, 0x07, 0xFF, 0xFB,
  0x07, 0x70, 0x2F, 0xB8, 0x4E, 0xA8, 0x8A, 0xEF, 0xA0, 0xE0, 0x16, 0x09, 0xFA, 0x08, 0x60, 0x8F,
  0xA0, 0x95, 0x01, 0xFA, 0x07, 0x71, 0x06, 0xFA, 0x01, 0x40, 0x7F, 0x90, 0xB7, 0x30, 0xBF, 0x90,
  0x64, 0x0C, 0xF9, 0x03, 0x73, 0x03, 0xF9, 0x0C, 0x30, 0x1F, 0x90, 0xD7, 0x50, 0xDF, 0x90, 0x12,
  0x05, 0xF9, 0x08, 0x75, 0x08, 0xF9, 0x05, 0x20, 0x8F, 0x90, 0x57, 0x50, 0x4F, 0x90, 0x82, 0x0B,
  0xF9, 0x01, 0x75, 0x01, 0xF9, 0x0B, 0x20, 0xDF, 0x97, 0x7F, 0x90, 0xD2, 0xF9, 0x0D, 0x77, 0x0D,
  0xF9, 0x10, 0x1F, 0x90, 0xB7, 0x70, 0xBF, 0x91, 0x02, 0xF9, 0x0A, 0x77, 0x0B, 0xF9, 0x00, 0x2F,
  0x90, 0xA7, 0x70, 0xAF, 0x90, 0x20, 0x3F, 0x90, 0x97, 0x70, 0x9F, 0x90, 0x20, 0x3F, 0x90, 0x97,
  0x70, 0xAF, 0x90, 0x02, 0xF9, 0x0A, 0x77, 0x0A, 0xF9, 0x00, 0x2F, 0x90, 0xA7, 0x70, 0xBF, 0x90,
  0x20, 0x1F, 0x90, 0xB7, 0x70, 0xBF, 0x92, 0xF9, 0x0D, 0x77, 0x0D, 0xF9, 0x20, 0xDF, 0x0E, 0x77,
  0xF9, 0x0D, 0x20, 0xBF, 0x90, 0x17, 0x50, 0x1F, 0x90, 0xB2, 0x08, 0xF9, 0x04, 0x75, 0x05, 0xF9,
  0x08, 0x20, 0x5F, 0x90, 0x87, 0x50, 0x8F, 0x90, 0x52, 0x01, 0xF9, 0x0D, 0x75, 0x0D, 0xF9, 0x01,
  0x30, 0xCF, 0x90, 0x37, 0x30, 0x3F, 0x90, 0xC4, 0x07, 0xF9, 0x0B, 0x73, 0x0B, 0xF9, 0x07, 0x40,
  0x1F, 0xA0, 0x67, 0x10, 0x6F, 0xA0, 0x15, 0x09, 0xFA, 0x08, 0x60, 0x8F, 0xA0, 0x96, 0x02, 0xFB,
  0x84, 0xE9, 0x77, 0x9E, 0xFB, 0x01, 0x70, 0x7F, 0xFF, 0xB0, 0x77, 0x20, 0xBF, 0xFF, 0x90, 0xB7,
  0x30, 0x10, 0xCF, 0xFE, 0x0C, 0x01, 0x74, 0x01, 0x0B, 0xFF, 0xC0, 0xB0, 0x17, 0x70, 0x60, 0xEF,
  0xF0, 0xE0, 0x67, 0x74, 0x05, 0x0B, 0xFB, 0x0B, 0x05, 0x77, 0x72, 0x86, 0x35, 0x67, 0x76, 0x53,
  0x76,
  // "Ô" (U+00D4)
  0x75, 0x02, 0x80, 0x47, 0x06, 0x77, 0x73, 0x0C, 0xFA, 0x04, 0x77, 0x71, 0x07, 0xFB, 0x0D, 0x77,
  0x70, 0x3F, 0xD0, 0x97, 0x75, 0x01, 0x0D, 0xFE, 0x05, 0x77, 0x40, 0xAE, 0x0A, 0x05, 0xE0, 0xE0,
  0x27, 0x72, 0x07, 0xE0, 0xA2, 0x05, 0xE0, 0xD0, 0x17, 0x70, 0x4E, 0x09, 0x40, 0x40, 0xED, 0x0B,
  0x76, 0x03, 0x0E, 0xD0, 0x76, 0x03, 0x0D, 0xD0, 0x87, 0x50, 0xCC, 0x0E, 0x04, 0x71, 0x01, 0x0B,
  0xD0, 0x28, 0x09, 0xE4, 0x08, 0x63, 0x56, 0x77, 0x65, 0x37, 0x77, 0x28, 0x15, 0xBE, 0xF9, 0x81,
  0xEB, 0x57, 0x74, 0x06, 0x0D, 0xFF, 0x0E, 0x06, 0x77, 0x10, 0xAF, 0xFC, 0x0A, 0x01, 0x74, 0x01,
  0x0C, 0xFF, 0xE0, 0xC0, 0x17, 0x30, 0xBF, 0xFF, 0x90, 0xB7, 0x20, 0x7F, 0xFF, 0xB0, 0x77, 0x02,
  0xFB, 0x84, 0xEA, 0x88, 0xAE, 0xFA, 0x0E, 0x01, 0x60, 0x9F, 0xA0, 0x86, 0x08, 0xFA, 0x09, 0x50,
  0x1F, 0xA0, 0x77, 0x10, 0x6F, 0xA0, 0x14, 0x07, 0xF9, 0x0B, 0x73, 0x0B, 0xF9, 0x06, 0x40, 0xCF,
  0x90, 0x37, 0x30, 0x3F, 0x90, 0xC3, 0x01, 0xF9, 0x0D, 0x75, 0x0D, 0xF9, 0x01, 0x20, 0x5F, 0x90,
  0x87, 0x50, 0x8F, 0x90, 0x52, 0x08, 0xF9, 0x05, 0x75, 0x04, 0xF9, 0x08, 0x20, 0xBF, 0x90, 0x17,
  0x50, 0x1F, 0x90, 0xB2, 0x0D, 0xF9, 0x77, 0xF9, 0x0D, 0x2F, 0x90, 0xD7, 0x70, 0xDF, 0x91, 0x01,
  0xF9, 0x0B, 0x77, 0x0B, 0xF9, 0x10, 0x2F, 0x90, 0xA7, 0x70, 0xBF, 0x90, 0x02, 0xF9, 0x0A, 0x77,
  0x0A, 0xF9, 0x02, 0x03, 0xF9, 0x09, 0x77, 0x09, 0xF9, 0x02, 0x03, 0xF9, 0x09, 0x77, 0x0A, 0xF9,
  0x00, 0x2F, 0x90, 0xA7, 0x70, 0xAF, 0x90, 0x02, 0xF9, 0x0A, 0x77, 0x0B, 0xF9, 0x02, 0x01, 0xF9,
  0x0B, 0x77, 0x0B, 0xF9, 0x2F, 0x90, 0xD7, 0x70, 0xDF, 0x92, 0x0D, 0xF0, 0xE7, 0x7F, 0x90, 0xD2,
  0x0B, 0xF9, 0x01, 0x75, 0x01, 0xF9, 0x0B, 0x20, 0x8F, 0x90, 0x47, 0x50, 0x5F, 0x90, 0x82, 0x05,
  0xF9, 0x08, 0x75, 0x08, 0xF9, 0x05, 0x20, 0x1F, 0x90, 0xD7, 0x50, 0xDF, 0x90, 0x13, 0x0C, 0xF9,
  0x03, 0x73, 0x03, 0xF9, 0x0C, 0x40, 0x7F, 0x90, 0xB7, 0x30, 0xBF, 0x90, 0x74, 0x01, 0xFA, 0x06,
  0x71, 0x06, 0xFA, 0x01, 0x50, 0x9F, 0xA0, 0x86, 0x08, 0xFA, 0x09, 0x60, 0x2F, 0xB8, 0x4E, 0x97,
  0x79, 0xEF, 0xB0, 0x17, 0x07, 0xFF, 0xFB, 0x07, 0x72, 0x0B, 0xFF, 0xF9, 0x0B, 0x73, 0x01, 0x0C,
  0xFF, 0xE0, 0xC0, 0x17, 0x40, 0x10, 0xBF, 0xFC, 0x0B, 0x01, 0x77, 0x06, 0x0E, 0xFF, 0x0E, 0x06,
  0x77, 0x40, 0x50, 0xBF, 0xB0, 0xB0, 0x57, 0x77, 0x28, 0x63, 0x56, 0x77, 0x65, 0x37, 0x60,
  // "Õ" (U+00D5)
  0x72, 0x85, 0x4B, 0xEE, 0xD9, 0x37, 0x01, 0xC0, 0x57, 0x60, 0x9F, 0x0C, 0x04, 0x50, 0x6C, 0x03,
  0x75, 0x06, 0xFB, 0x84, 0xC6, 0x20, 0x3E, 0xC0, 0x17, 0x50, 0xEF, 0xFD, 0x0D, 0x75, 0x06, 0xFF,
  0xE0, 0x87, 0x50, 0xCF, 0xFE, 0x01, 0x75, 0xC8, 0x4D, 0x30, 0x27, 0xDF, 0xB0, 0x67, 0x50, 0x3C,
  0x05, 0x50, 0x50, 0xCF, 0x08, 0x76, 0x05, 0xC7, 0x18, 0x54, 0x9D, 0xEE, 0xA4, 0x80, 0x9F, 0x00,
  0x86, 0x35, 0x67, 0x76, 0x53, 0x77, 0x72, 0x81, 0x5B, 0xEF, 0x98, 0x1E, 0xB5, 0x77, 0x40, 0x60,
  0xDF, 0xF0, 0xE0, 0x67, 0x71, 0x0A, 0xFF, 0xC0, 0xA0, 0x17, 0x40, 0x10, 0xCF, 0xFE, 0x0C, 0x01,
  0x73, 0x0B, 0xFF, 0xF9, 0x0B, 0x72, 0x07, 0xFF, 0xFB, 0x07, 0x70, 0x2F, 0xB8, 0x4E, 0xA8, 0x8A,
  0xEF, 0xA0, 0xE0, 0x16, 0x09, 0xFA, 0x08, 0x60, 0x8F, 0xA0, 0x95, 0x01, 0xFA, 0x07, 0x71, 0x06,
  0xFA, 0x01, 0x40, 0x7F, 0x90, 0xB7, 0x30, 0xBF, 0x90, 0x64, 0x0C, 0xF9, 0x03, 0x73, 0x03, 0xF9,
  0x0C, 0x30, 0x1F, 0x90, 0xD7, 0x50, 0xDF, 0x90, 0x12, 0x05, 0xF9, 0x08, 0x75, 0x08, 0xF9, 0x05,
  0x20, 0x8F, 0x90, 0x57, 0x50, 0x4F, 0x90, 0x82, 0x0B, 0xF9, 0x01, 0x75, 0x01, 0xF9, 0x0B, 0x20,
  0xDF, 0x97, 0x7F, 0x90, 0xD2, 0xF9, 0x0D, 0x77, 0x0D, 0xF9, 0x10, 0x1F, 0x90, 0xB7, 0x70, 0xBF,
  0x91, 0x02, 0xF9, 0x0A, 0x77, 0x0B, 0xF9, 0x00, 0x2F, 0x90, 0xA7, 0x70, 0xAF, 0x90, 0x20, 0x3F,
  0x90, 0x97, 0x70, 0x9F, 0x90, 0x20, 0x3F, 0x90, 0x97, 0x70, 0xAF, 0x90, 0x02, 0xF9, 0x0A, 0x77,
  0x0A, 0xF9, 0x00, 0x2F, 0x90, 0xA7, 0x70, 0xBF, 0x90, 0x20, 0x1F, 0x90, 0xB7, 0x70, 0xBF, 0x92,
  0xF9, 0x0D, 0x77, 0x0D, 0xF9, 0x20, 0xDF, 0x0E, 0x77, 0xF9, 0x0D, 0x20, 0xBF, 0x90, 0x17, 0x50,
  0x1F, 0x90, 0xB2, 0x08, 0xF9, 0x04, 0x75, 0x05, 0xF9, 0x08, 0x20, 0x5F, 0x90, 0x87, 0x50, 0x8F,
  0x90, 0x52, 0x01, 0xF9, 0x0D, 0x75, 0x0D, 0xF9, 0x01, 0x30, 0xCF, 0x90, 0x37, 0x30, 0x3F, 0x90,
  0xC4, 0x07, 0xF9, 0x0B, 0x73, 0x0B, 0xF9, 0x07, 0x40, 0x1F, 0xA0, 0x67, 0x10, 0x6F, 0xA0, 0x15,
  0x09, 0xFA, 0x08, 0x60, 0x8F, 0xA0, 0x96, 0x02, 0xFB, 0x84, 0xE9, 0x77, 0x9E, 0xFB, 0x01, 0x70,
  0x7F, 0xFF, 0xB0, 0x77, 0x20, 0xBF, 0xFF, 0x90, 0xB7, 0x30, 0x10, 0xCF, 0xFE, 0x0C, 0x01, 0x74,
  0x01, 0x0B, 0xFF, 0xC0, 0xB0, 0x17, 0x70, 0x60, 0xEF, 0xF0, 0xE0, 0x67, 0x74, 0x05, 0x0B, 0xFB,
  0x0B, 0x05, 0x77, 0x72, 0x86, 0x35, 0x67, 0x76, 0x53, 0x76,
  // "Ö" (U+00D6)
  0x78, 0x43, 0xBE, 0xFC, 0x57, 0x18, 0x43, 0xBE, 0xFC, 0x67, 0x60, 0x4E, 0x08, 0x60, 0x4E, 0x09,
  0x75, 0x0D, 0xF0, 0x25, 0x0D, 0xF0, 0x27, 0x30, 0x1F, 0x90, 0x64, 0x01, 0xF9, 0x06, 0x73, 0x02,
  0xF9, 0x07, 0x40, 0x2F, 0x90, 0x77, 0x30, 0x1F, 0x90, 0x54, 0x01, 0xF9, 0x06, 0x74, 0x0C, 0xF0,
  0x15, 0x0C, 0xF0, 0x27, 0x40, 0x4E, 0x07, 0x60, 0x3E, 0x08, 0x76, 0x84, 0x3B, 0xEF, 0xC5, 0x71,
  0x84, 0x3B, 0xEF, 0xC5, 0x80, 0x9E, 0x60, 0x86, 0x35, 0x67, 0x76, 0x53, 0x77, 0x72, 0x81, 0x5B,
  0xEF, 0x98, 0x1E, 0xB5, 0x77, 0x40, 0x60, 0xDF, 0xF0, 0xE0, 0x67, 0x71, 0x0A, 0xFF, 0xC0, 0xA0,
  0x17, 0x40, 0x10, 0xCF, 0xFE, 0x0C, 0x01, 0x73, 0x0B, 0xFF, 0xF9, 0x0B, 0x72, 0x07, 0xFF, 0xFB,
  0x07, 0x70, 0x2F, 0xB8, 0x4E, 0xA8, 0x8A, 0xEF, 0xA0, 0xE0, 0x16, 0x09, 0xFA, 0x08, 0x60, 0x8F,
  0xA0, 0x95, 0x01, 0xFA, 0x07, 0x71, 0x06, 0xFA, 0x01, 0x40, 0x7F, 0x90, 0xB7, 0x30, 0xBF, 0x90,
  0x64, 0x0C, 0xF9, 0x03, 0x73, 0x03, 0xF9, 0x0C, 0x30, 0x1F, 0x90, 0xD7, 0x50, 0xDF, 0x90, 0x12,
  0x05, 0xF9, 0x08, 0x75, 0x08, 0xF9, 0x05, 0x20, 0x8F, 0x90, 0x57, 0x50, 0x4F, 0x90, 0x82, 0x0B,
  0xF9, 0x01, 0x75, 0x01, 0xF9, 0x0B, 0x20, 0xDF, 0x97, 0x7F, 0x90, 0xD2, 0xF9, 0x0D, 0x77, 0x0D,
  0xF9, 0x10, 0x1F, 0x90, 0xB7, 0x70, 0xBF, 0x91, 0x02, 0xF9, 0x0A, 0x77, 0x0B, 0xF9, 0x00, 0x2F,
  0x90, 0xA7, 0x70, 0xAF, 0x90, 0x20, 0x3F, 0x90, 0x97, 0x70, 0x9F, 0x90, 0x20, 0x3F, 0x90, 0x97,
  0x70, 0xAF, 0x90, 0x02, 0xF9, 0x0A, 0x77, 0x0A, 0xF9, 0x00, 0x2F, 0x90, 0xA7, 0x70, 0xBF, 0x90,
  0x20, 0x1F, 0x90, 0xB7, 0x70, 0xBF, 0x92, 0xF9, 0x0D, 0x77, 0x0D, 0xF9, 0x20, 0xDF, 0x0E, 0x77,
  0xF9, 0x0D, 0x20, 0xBF, 0x90, 0x17, 0x50, 0x1F, 0x90, 0xB2, 0x08, 0xF9, 0x04, 0x75, 0x05, 0xF9,
  0x08, 0x20, 0x5F, 0x90, 0x87, 0x50, 0x8F, 0x90, 0x52, 0x01, 0xF9, 0x0D, 0x75, 0x0D, 0xF9, 0x01,
  0x30, 0xCF, 0x90, 0x37, 0x30, 0x3F, 0x90, 0xC4, 0x07, 0xF9, 0x0B, 0x73, 0x0B, 0xF9, 0x07, 0x40,
  0x1F, 0xA0, 0x67, 0x10, 0x6F, 0xA0, 0x15, 0x09, 0xFA, 0x08, 0x60, 0x8F, 0xA0, 0x96, 0x02, 0xFB,
  0x84, 0xE9, 0x77, 0x9E, 0xFB, 0x01, 0x70, 0x7F, 0xFF, 0xB0, 0x77, 0x20, 0xBF, 0xFF, 0x90, 0xB7,
  0x30, 0x10, 0xCF, 0xFE, 0x0C, 0x01, 0x74, 0x01, 0x0B, 0xFF, 0xC0, 0xB0, 0x17, 0x70, 0x60, 0xEF,
  0xF0, 0xE0, 0x67, 0x74, 0x05, 0x0B, 0xFB, 0x0B, 0x05, 0x77, 0x72, 0x86, 0x35, 0x67, 0x76, 0x53,
  0x76,
  // "×" (U+00D7)
  0x40, 0x27, 0x72, 0x02, 0x71, 0x81, 0x7F, 0x47, 0x78, 0x14, 0xF8, 0x60, 0x7B, 0x04, 0x75, 0x04,
  0xB0, 0x84, 0x06, 0xD0, 0x47, 0x30, 0x5D, 0x08, 0x20, 0x6F, 0x05, 0x71, 0x05, 0xF8, 0x18, 0x0D,
  0xF9, 0x05, 0x60, 0x5F, 0x98, 0x2D, 0x11, 0xDF, 0x90, 0x54, 0x05, 0xF9, 0x0D, 0x01, 0x20, 0x10,
  0xDF, 0x90, 0x62, 0x06, 0xF9, 0x0D, 0x01, 0x40, 0x10, 0xDF, 0x90, 0x06, 0xF9, 0x0D, 0x01, 0x60,
  0x10, 0xDF, 0xFA, 0x0D, 0x01, 0x71, 0x01, 0x0D, 0xFF, 0x0D, 0x01, 0x73, 0x01, 0x0D, 0xFD, 0x0D,
  0x01, 0x75, 0x01, 0x0D, 0xFB, 0x0D, 0x01, 0x77, 0x01, 0x0E, 0xF9, 0x0D, 0x01, 0x77, 0x10, 0x5F,
  0xB0, 0x47, 0x70, 0x5F, 0xD0, 0x47, 0x50, 0x5F, 0xF0, 0x47, 0x30, 0x5F, 0xFA, 0x04, 0x71, 0x05,
  0xF9, 0x00, 0xDF, 0x90, 0x46, 0x04, 0xF9, 0x82, 0xD1, 0x1D, 0xF0, 0xE0, 0x44, 0x04, 0xF9, 0x0C,
  0x01, 0x20, 0x10, 0xDF, 0x0E, 0x03, 0x20, 0x4F, 0x90, 0xC0, 0x14, 0x01, 0x0D, 0xF8, 0x2E, 0x30,
  0xDF, 0x0C, 0x01, 0x60, 0x10, 0xDF, 0x82, 0xD0, 0x2E, 0xD0, 0xC0, 0x17, 0x10, 0x10, 0xDD, 0x0E,
  0x02, 0x20, 0x20, 0xEB, 0x0C, 0x01, 0x73, 0x01, 0x0D, 0xB0, 0xE0, 0x24, 0x83, 0x2E, 0xFC, 0x17,
  0x58, 0x31, 0xDF, 0xE2, 0x68, 0x13, 0xB1, 0x77, 0x81, 0x1B, 0x24,
  // "Ø" (U+00D8)
  0x77, 0x77, 0x10, 0x90, 0x77, 0x72, 0x86, 0x35, 0x67, 0x76, 0x52, 0x70, 0x5A, 0x0C, 0x03, 0x74,
  0x81, 0x5B, 0xEF, 0x98, 0x1E, 0xB5, 0x30, 0x10, 0xEC, 0x09, 0x71, 0x05, 0x0D, 0xFF, 0x82, 0xE6,
  0x0B, 0xD0, 0xC7, 0x0A, 0xFF, 0xC0, 0xED, 0x0E, 0x02, 0x60, 0xBF, 0xFF, 0xC0, 0x56, 0x0A, 0xFF,
  0xFC, 0x09, 0x60, 0x6F, 0xFF, 0xC0, 0xD6, 0x01, 0x0E, 0xFA, 0x84, 0xEA, 0x87, 0xAE, 0xFB, 0x06,
  0x60, 0x8F, 0xA0, 0x86, 0x09, 0xFA, 0x0B, 0x50, 0x10, 0xEF, 0x90, 0x77, 0x10, 0x9F, 0xA0, 0x34,
  0x06, 0xF9, 0x0C, 0x72, 0x03, 0xFA, 0x09, 0x40, 0xBF, 0x90, 0x37, 0x20, 0xDF, 0xA0, 0xD4, 0xF9,
  0x0D, 0x72, 0x08, 0xFC, 0x02, 0x20, 0x4F, 0x90, 0x87, 0x10, 0x4F, 0xD0, 0x62, 0x07, 0xF9, 0x05,
  0x71, 0x0D, 0xFD, 0x09, 0x20, 0xAF, 0x90, 0x17, 0x09, 0xFE, 0x0B, 0x20, 0xDF, 0x97, 0x04, 0xFF,
  0x0D, 0x20, 0xEF, 0x0D, 0x60, 0x10, 0xDD, 0x09, 0x0D, 0xF9, 0x2F, 0x90, 0xB6, 0x0A, 0xD8, 0x1D,
  0x1C, 0xF9, 0x10, 0x1F, 0x90, 0xA5, 0x05, 0xE8, 0x14, 0x0A, 0xF9, 0x01, 0x02, 0xF9, 0x0A, 0x40,
  0x10, 0xED, 0x09, 0x20, 0xAF, 0x90, 0x02, 0xF9, 0x09, 0x40, 0xAD, 0x0D, 0x30, 0x9F, 0x90, 0x20,
  0x3F, 0x90, 0x93, 0x05, 0xE0, 0x43, 0x09, 0xF9, 0x00, 0x2F, 0x90, 0xA2, 0x01, 0x0E, 0xD0, 0x94,
  0x0A, 0xF9, 0x02, 0x01, 0xF9, 0x0A, 0x20, 0xBD, 0x0D, 0x50, 0xAF, 0x90, 0x01, 0xF9, 0x81, 0xB0,
  0x6E, 0x03, 0x50, 0xBF, 0x92, 0xF9, 0x81, 0xD1, 0xED, 0x08, 0x60, 0xDF, 0x0E, 0x20, 0xDF, 0x0E,
  0x0B, 0xD0, 0xD7, 0x0E, 0xF0, 0xC2, 0x0B, 0xFF, 0x03, 0x60, 0x1F, 0x90, 0xA2, 0x09, 0xFE, 0x08,
  0x70, 0x4F, 0x90, 0x72, 0x06, 0xFD, 0x0D, 0x71, 0x07, 0xF9, 0x04, 0x20, 0x2F, 0xD0, 0x37, 0x10,
  0xCF, 0x90, 0x13, 0x0E, 0xFB, 0x08, 0x71, 0x03, 0xF9, 0x0B, 0x40, 0x9F, 0xA0, 0xC7, 0x20, 0xBF,
  0x90, 0x64, 0x04, 0xFA, 0x07, 0x71, 0x06, 0xF9, 0x0E, 0x01, 0x50, 0xCF, 0xA0, 0x76, 0x07, 0xFA,
  0x08, 0x60, 0x5F, 0xB8, 0x4E, 0x97, 0x79, 0xEF, 0xA0, 0xE0, 0x16, 0x08, 0xFF, 0xFC, 0x06, 0x60,
  0x4F, 0xFF, 0xC0, 0xA6, 0x01, 0x0E, 0xFF, 0xFB, 0x0C, 0x70, 0xBF, 0xFF, 0xB0, 0xA7, 0x07, 0xE8,
  0x13, 0x7E, 0xFF, 0x0D, 0x05, 0x71, 0x0D, 0xD0, 0x72, 0x81, 0x16, 0xBF, 0xA8, 0x1E, 0xB5, 0x73,
  0x01, 0x09, 0xB0, 0xC7, 0x86, 0x35, 0x67, 0x76, 0x53, 0x77, 0x18, 0x24, 0xEF, 0x27, 0x77, 0x73,
  0x01, 0x04, 0x77, 0x77, 0x10,
  // "Ù" (U+00D9)
  0x60, 0x68, 0x04, 0x70, 0x67, 0x77, 0x10, 0x6F, 0xA0, 0x37, 0x77, 0x10, 0x7F, 0x90, 0xC7, 0x77,
  0x20, 0x7F, 0x90, 0x77, 0x77, 0x20, 0x6F, 0x90, 0x37, 0x77, 0x20, 0x5F, 0x0D, 0x77, 0x73, 0x04,
  0x0E, 0xE0, 0x87, 0x77, 0x30, 0x30, 0xEE, 0x04, 0x77, 0x73, 0x02, 0x0D, 0xD0, 0xE0, 0x17, 0x77,
  0x30, 0x10, 0xBD, 0x08, 0x80, 0xA8, 0x60, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90,
  0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F,
  0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9,
  0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06,
  0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F,
  0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50,
  0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04,
  0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75,
  0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00,
  0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67,
  0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90,
  0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x7F, 0x90, 0x40, 0x3F, 0x90,
  0x77, 0x50, 0x7F, 0x90, 0x30, 0x2F, 0x90, 0x97, 0x50, 0x9F, 0x90, 0x20, 0x1F, 0x90, 0xC7, 0x50,
  0xCF, 0x98, 0x11, 0x0E, 0xF9, 0x01, 0x73, 0x01, 0xF9, 0x0D, 0x20, 0xAF, 0x90, 0x67, 0x30, 0x6F,
  0x90, 0x92, 0x06, 0xF9, 0x0E, 0x02, 0x71, 0x01, 0x0E, 0xF9, 0x06, 0x20, 0x1F, 0xA0, 0xD0, 0x46,
  0x03, 0x0D, 0xF9, 0x0E, 0x40, 0x9F, 0xB8, 0x4D, 0x97, 0x79, 0xCF, 0xB0, 0x74, 0x02, 0x0E, 0xFF,
  0xFB, 0x0D, 0x01, 0x50, 0x5F, 0xFF, 0xB0, 0x37, 0x07, 0xFF, 0xF9, 0x06, 0x72, 0x05, 0x0E, 0xFF,
  0xC0, 0xE0, 0x47, 0x40, 0x20, 0xAF, 0xFA, 0x09, 0x01, 0x77, 0x81, 0x28, 0xCF, 0xB8, 0x1C, 0x81,
  0x77, 0x68, 0x63, 0x56, 0x77, 0x65, 0x37, 0x50,
  // "Ú" (U+00DA)
  0x77, 0x30, 0x68, 0x04, 0x70, 0x67, 0x77, 0x04, 0xFA, 0x05, 0x77, 0x70, 0xDF, 0x90, 0x67, 0x77,
  0x08, 0xF9, 0x06, 0x77, 0x70, 0x3F, 0x90, 0x57, 0x77, 0x10, 0xDF, 0x04, 0x77, 0x71, 0x09, 0xE0,
  0xE0, 0x47, 0x77, 0x10, 0x5E, 0x0E, 0x03, 0x77, 0x71, 0x02, 0x0E, 0xD0, 0xC0, 0x17, 0x77, 0x20,
  0x9D, 0x0A, 0x80, 0xA9, 0x20, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50,
  0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04,
  0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75,
  0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00,
  0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67,
  0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90,
  0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06,
  0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9,
  0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90,
  0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F,
  0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9,
  0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x7F, 0x90, 0x40, 0x3F, 0x90, 0x77, 0x50,
  0x7F, 0x90, 0x30, 0x2F, 0x90, 0x97, 0x50, 0x9F, 0x90, 0x20, 0x1F, 0x90, 0xC7, 0x50, 0xCF, 0x98,
  0x11, 0x0E, 0xF9, 0x01, 0x73, 0x01, 0xF9, 0x0D, 0x20, 0xAF, 0x90, 0x67, 0x30, 0x6F, 0x90, 0x92,
  0x06, 0xF9, 0x0E, 0x02, 0x71, 0x01, 0x0E, 0xF9, 0x06, 0x20, 0x1F, 0xA0, 0xD0, 0x46, 0x03, 0x0D,
  0xF9, 0x0E, 0x40, 0x9F, 0xB8, 0x4D, 0x97, 0x79, 0xCF, 0xB0, 0x74, 0x02, 0x0E, 0xFF, 0xFB, 0x0D,
  0x01, 0x50, 0x5F, 0xFF, 0xB0, 0x37, 0x07, 0xFF, 0xF9, 0x06, 0x72, 0x05, 0x0E, 0xFF, 0xC0, 0xE0,
  0x47, 0x40, 0x20, 0xAF, 0xFA, 0x09, 0x01, 0x77, 0x81, 0x28, 0xCF, 0xB8, 0x1C, 0x81, 0x77, 0x68,
  0x63, 0x56, 0x77, 0x65, 0x37, 0x50,
  // "Û" (U+00DB)
  0x74, 0x02, 0x80, 0x47, 0x06, 0x77, 0x71, 0x0C, 0xFA, 0x04, 0x77, 0x60, 0x7F, 0xB0, 0xD7, 0x75,
  0x03, 0xFD, 0x09, 0x77, 0x30, 0x10, 0xDF, 0xE0, 0x57, 0x72, 0x0A, 0xE0, 0xA0, 0x5E, 0x0E, 0x02,
  0x77, 0x07, 0xE0, 0xA2, 0x05, 0xE0, 0xD0, 0x17, 0x50, 0x4E, 0x09, 0x40, 0x40, 0xED, 0x0B, 0x74,
  0x03, 0x0E, 0xD0, 0x76, 0x03, 0x0D, 0xD0, 0x87, 0x30, 0xCC, 0x0E, 0x04, 0x71, 0x01, 0x0B, 0xD0,
  0x28, 0x0A, 0x80, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9,
  0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90,
  0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F,
  0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9,
  0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06,
  0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F,
  0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50,
  0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04,
  0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75,
  0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00,
  0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67,
  0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x07, 0xF9, 0x04, 0x03, 0xF9, 0x07, 0x75, 0x07, 0xF9,
  0x03, 0x02, 0xF9, 0x09, 0x75, 0x09, 0xF9, 0x02, 0x01, 0xF9, 0x0C, 0x75, 0x0C, 0xF9, 0x81, 0x10,
  0xEF, 0x90, 0x17, 0x30, 0x1F, 0x90, 0xD2, 0x0A, 0xF9, 0x06, 0x73, 0x06, 0xF9, 0x09, 0x20, 0x6F,
  0x90, 0xE0, 0x27, 0x10, 0x10, 0xEF, 0x90, 0x62, 0x01, 0xFA, 0x0D, 0x04, 0x60, 0x30, 0xDF, 0x90,
  0xE4, 0x09, 0xFB, 0x84, 0xD9, 0x77, 0x9C, 0xFB, 0x07, 0x40, 0x20, 0xEF, 0xFF, 0xB0, 0xD0, 0x15,
  0x05, 0xFF, 0xFB, 0x03, 0x70, 0x7F, 0xFF, 0x90, 0x67, 0x20, 0x50, 0xEF, 0xFC, 0x0E, 0x04, 0x74,
  0x02, 0x0A, 0xFF, 0xA0, 0x90, 0x17, 0x78, 0x12, 0x8C, 0xFB, 0x81, 0xC8, 0x17, 0x76, 0x86, 0x35,
  0x67, 0x76, 0x53, 0x75,
  // "Ü" (U+00DC)
  0x68, 0x43, 0xBE, 0xFC, 0x57, 0x18, 0x43, 0xBE, 0xFC, 0x67, 0x40, 0x4E, 0x08, 0x60, 0x4E, 0x09,
  0x73, 0x0D, 0xF0, 0x25, 0x0D, 0xF0, 0x27, 0x10, 0x1F, 0x90, 0x64, 0x01, 0xF9, 0x06, 0x71, 0x02,
  0xF9, 0x07, 0x40, 0x2F, 0x90, 0x77, 0x10, 0x1F, 0x90, 0x54, 0x01, 0xF9, 0x06, 0x72, 0x0C, 0xF0,
  0x15, 0x0C, 0xF0, 0x27, 0x20, 0x4E, 0x07, 0x60, 0x3E, 0x08, 0x74, 0x84, 0x3B, 0xEF, 0xC5, 0x71,
  0x84, 0x3B, 0xEF, 0xC5, 0x80, 0xA8, 0x20, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90,
  0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F,
  0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9,
  0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06,
  0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F,
  0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50,
  0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04,
  0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75,
  0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00,
  0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67,
  0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90,
  0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x7F, 0x90, 0x40, 0x3F, 0x90,
  0x77, 0x50, 0x7F, 0x90, 0x30, 0x2F, 0x90, 0x97, 0x50, 0x9F, 0x90, 0x20, 0x1F, 0x90, 0xC7, 0x50,
  0xCF, 0x98, 0x11, 0x0E, 0xF9, 0x01, 0x73, 0x01, 0xF9, 0x0D, 0x20, 0xAF, 0x90, 0x67, 0x30, 0x6F,
  0x90, 0x92, 0x06, 0xF9, 0x0E, 0x02, 0x71, 0x01, 0x0E, 0xF9, 0x06, 0x20, 0x1F, 0xA0, 0xD0, 0x46,
  0x03, 0x0D, 0xF9, 0x0E, 0x40, 0x9F, 0xB8, 0x4D, 0x97, 0x79, 0xCF, 0xB0, 0x74, 0x02, 0x0E, 0xFF,
  0xFB, 0x0D, 0x01, 0x50, 0x5F, 0xFF, 0xB0, 0x37, 0x07, 0xFF, 0xF9, 0x06, 0x72, 0x05, 0x0E, 0xFF,
  0xC0, 0xE0, 0x47, 0x40, 0x20, 0xAF, 0xFA, 0x09, 0x01, 0x77, 0x81, 0x28, 0xCF, 0xB8, 0x1C, 0x81,
  0x77, 0x68, 0x63, 0x56, 0x77, 0x65, 0x37, 0x50,
  // "Ý" (U+00DD)
  0x77, 0x40, 0x68, 0x04, 0x70, 0x67, 0x77, 0x20, 0x4F, 0xA0, 0x57, 0x77, 0x20, 0xDF, 0x90, 0x67,
  0x77, 0x20, 0x8F, 0x90, 0x67, 0x77, 0x20, 0x3F, 0x90, 0x57, 0x77, 0x30, 0xDF, 0x04, 0x77, 0x73,
  0x09, 0xE0, 0xE0, 0x47, 0x77, 0x30, 0x5E, 0x0E, 0x03, 0x77, 0x73, 0x02, 0x0E, 0xD0, 0xC0, 0x17,
  0x77, 0x40, 0x9D, 0x0A, 0x80, 0xAA, 0x30, 0x08, 0xF9, 0x09, 0x77, 0x08, 0xF9, 0x08, 0x01, 0xF9,
  0x0E, 0x77, 0x0E, 0xF9, 0x81, 0x10, 0x9F, 0x90, 0x67, 0x50, 0x5F, 0x90, 0x92, 0x01, 0xF9, 0x0D,
  0x75, 0x0C, 0xF9, 0x02, 0x30, 0x9F, 0x90, 0x47, 0x30, 0x3F, 0x90, 0x94, 0x02, 0xF9, 0x0B, 0x73,
  0x0A, 0xF9, 0x02, 0x50, 0xAF, 0x90, 0x27, 0x10, 0x1F, 0x90, 0xA6, 0x02, 0xF9, 0x09, 0x71, 0x07,
  0xF9, 0x02, 0x70, 0xAF, 0x0E, 0x71, 0x0D, 0xF0, 0xA7, 0x10, 0x3F, 0x90, 0x66, 0x05, 0xF9, 0x03,
  0x72, 0x0B, 0xF0, 0xD6, 0x0B, 0xF0, 0xB7, 0x30, 0x3F, 0x90, 0x44, 0x03, 0xF9, 0x04, 0x74, 0x0B,
  0xF0, 0xB4, 0x09, 0xF0, 0xC7, 0x50, 0x4F, 0x90, 0x22, 0x01, 0xF9, 0x04, 0x76, 0x0C, 0xF0, 0x82,
  0x07, 0xF0, 0xC7, 0x70, 0x4F, 0x0E, 0x20, 0xDF, 0x05, 0x77, 0x10, 0xCF, 0x06, 0x04, 0xF0, 0xD7,
  0x72, 0x05, 0xF0, 0xD0, 0xBF, 0x05, 0x77, 0x30, 0xDF, 0xF0, 0xD7, 0x74, 0x05, 0xFF, 0x06, 0x77,
  0x50, 0xDF, 0xD0, 0xD7, 0x76, 0x06, 0xFD, 0x06, 0x77, 0x70, 0xDF, 0xB0, 0xE7, 0x77, 0x10, 0x6F,
  0xB0, 0x77, 0x77, 0x20, 0xEF, 0x90, 0xE7, 0x77, 0x30, 0x7F, 0x90, 0x87, 0x77, 0x30, 0x4F, 0x90,
  0x57, 0x77, 0x30, 0x4F, 0x90, 0x57, 0x77, 0x30, 0x4F, 0x90, 0x57, 0x77, 0x30, 0x4F, 0x90, 0x57,
  0x77, 0x30, 0x4F, 0x90, 0x57, 0x77, 0x30, 0x4F, 0x90, 0x57, 0x77, 0x30, 0x4F, 0x90, 0x57, 0x77,
  0x30, 0x4F, 0x90, 0x57, 0x77, 0x30, 0x4F, 0x90, 0x57, 0x77, 0x30, 0x4F, 0x90, 0x57, 0x77, 0x30,
  0x4F, 0x90, 0x57, 0x77, 0x30, 0x4F, 0x90, 0x57, 0x77, 0x30, 0x4F, 0x90, 0x57, 0x77, 0x30, 0x4F,
  0x90, 0x57, 0x77, 0x30, 0x4F, 0x90, 0x57, 0x77, 0x30, 0x4F, 0x90, 0x57, 0x50,
  // "Þ" (U+00DE)
  0x03, 0xF9, 0x03, 0x77, 0x60, 0x3F, 0x90, 0x37, 0x76, 0x03, 0xF9, 0x03, 0x77, 0x60, 0x3F, 0x90,
  0x37, 0x76, 0x03, 0xF9, 0x03, 0x77, 0x60, 0x3F, 0x90, 0x37, 0x76, 0x03, 0xF9, 0x03, 0x77, 0x60,
  0x3F, 0xF9, 0x84, 0xED, 0xB8, 0x51, 0x71, 0x03, 0xFF, 0xF0, 0xB0, 0x46, 0x03, 0xFF, 0xFA, 0x0A,
  0x01, 0x40, 0x3F, 0xFF, 0xB0, 0xD0, 0x23, 0x03, 0xFF, 0xFC, 0x0D, 0x01, 0x20, 0x3F, 0xFF, 0xD0,
  0xA2, 0x03, 0xF9, 0x80, 0x2E, 0xFE, 0x81, 0x30, 0x3F, 0x90, 0x36, 0x81, 0x15, 0xCF, 0xA8, 0x1A,
  0x03, 0xF9, 0x03, 0x72, 0x09, 0xF9, 0x81, 0xE0, 0x3F, 0x90, 0x37, 0x30, 0xDF, 0x90, 0x03, 0xF9,
  0x03, 0x73, 0x07, 0xF9, 0x06, 0x03, 0xF9, 0x03, 0x73, 0x03, 0xF9, 0x07, 0x03, 0xF9, 0x03, 0x73,
  0x01, 0xF9, 0x08, 0x03, 0xF9, 0x03, 0x73, 0x01, 0xF9, 0x08, 0x03, 0xF9, 0x03, 0x73, 0x02, 0xF9,
  0x08, 0x03, 0xF9, 0x03, 0x73, 0x05, 0xF9, 0x06, 0x03, 0xF9, 0x03, 0x73, 0x0A, 0xF9, 0x04, 0x03,
  0xF9, 0x03, 0x72, 0x04, 0xFA, 0x01, 0x03, 0xF9, 0x03, 0x71, 0x04, 0x0E, 0xF9, 0x81, 0xB0, 0x3F,
  0x90, 0x35, 0x81, 0x25, 0xBF, 0xB8, 0x16, 0x03, 0xFF, 0xFD, 0x0D, 0x20, 0x3F, 0xFF, 0xD0, 0x52,
  0x03, 0xFF, 0xFC, 0x09, 0x30, 0x3F, 0xFF, 0xB0, 0x94, 0x03, 0xFF, 0xF9, 0x0E, 0x06, 0x50, 0x3F,
  0xFE, 0x81, 0xE7, 0x16, 0x03, 0xF9, 0x80, 0x3E, 0x83, 0xDC, 0x97, 0x37, 0x20, 0x3F, 0x90, 0x37,
  0x76, 0x03, 0xF9, 0x03, 0x77, 0x60, 0x3F, 0x90, 0x37, 0x76, 0x03, 0xF9, 0x03, 0x77, 0x60, 0x3F,
  0x90, 0x37, 0x76, 0x03, 0xF9, 0x03, 0x77, 0x60, 0x3F, 0x90, 0x37, 0x76, 0x03, 0xF9, 0x03, 0x77,
  0x60,
  // "ß" (U+00DF)
  0x71, 0x89, 0x31, 0x58, 0xBC, 0xDE, 0xED, 0xB8, 0x51, 0x77, 0x30, 0x30, 0xAF, 0xE0, 0xA0, 0x37,
  0x60, 0x10, 0xAF, 0xFB, 0x0A, 0x01, 0x73, 0x02, 0x0D, 0xFF, 0xD0, 0xD0, 0x27, 0x10, 0x10, 0xDF,
  0xFF, 0x0D, 0x01, 0x70, 0xBF, 0xFF, 0xA0, 0xA6, 0x05, 0xFF, 0xFC, 0x02, 0x50, 0xCF, 0xA8, 0x59,
  0x41, 0x01, 0x4A, 0xFA, 0x07, 0x40, 0x1F, 0xA0, 0x57, 0x06, 0xF9, 0x0B, 0x40, 0x5F, 0x90, 0x97,
  0x20, 0xDF, 0x0C, 0x40, 0x8F, 0x90, 0x27, 0x20, 0xAF, 0x0C, 0x40, 0x9F, 0x0E, 0x73, 0x0B, 0xF0,
  0xB4, 0x0A, 0xF0, 0xC7, 0x30, 0xEF, 0x08, 0x40, 0xAF, 0x0B, 0x72, 0x07, 0xF9, 0x02, 0x40, 0xAF,
  0x0B, 0x71, 0x04, 0xF9, 0x09, 0x50, 0xAF, 0x0B, 0x70, 0x5F, 0x90, 0xD0, 0x15, 0x0A, 0xF0, 0xB6,
  0x06, 0xF9, 0x0E, 0x02, 0x60, 0xAF, 0x0B, 0x50, 0x7F, 0x90, 0xE0, 0x37, 0x0A, 0xF0, 0xB4, 0x04,
  0xF9, 0x0D, 0x02, 0x71, 0x0A, 0xF0, 0xB4, 0x0D, 0xF0, 0xC0, 0x17, 0x20, 0xAF, 0x0B, 0x30, 0x3F,
  0x90, 0x27, 0x30, 0xAF, 0x0B, 0x30, 0x7F, 0x0C, 0x74, 0x0A, 0xF0, 0xB3, 0x08, 0xF0, 0xE7, 0x40,
  0xAF, 0x0B, 0x30, 0x8F, 0x90, 0x97, 0x30, 0xAF, 0x0B, 0x30, 0x5F, 0xA0, 0xA0, 0x17, 0x10, 0xAF,
  0x0B, 0x40, 0xEF, 0xA0, 0xD0, 0x37, 0x0A, 0xF0, 0xB4, 0x07, 0xFC, 0x06, 0x60, 0xAF, 0x0B, 0x50,
  0xBF, 0xC0, 0xA5, 0x0A, 0xF0, 0xB6, 0x0C, 0xFC, 0x0B, 0x40, 0xAF, 0x0B, 0x70, 0xAF, 0xC0, 0xB3,
  0x0A, 0xF0, 0xB7, 0x10, 0x7F, 0xC0, 0x92, 0x0A, 0xF0, 0xB7, 0x20, 0x30, 0xDF, 0xB8, 0x13, 0x0A,
  0xF0, 0xB7, 0x40, 0x9F, 0xA8, 0x1A, 0x0A, 0xF0, 0xB7, 0x50, 0x7F, 0x98, 0x1E, 0x0A, 0xF0, 0xB7,
  0x60, 0xBF, 0x90, 0x20, 0xAF, 0x0B, 0x76, 0x05, 0xF9, 0x03, 0x0A, 0xF0, 0xB7, 0x60, 0x5F, 0x90,
  0x30, 0xAF, 0x0B, 0x20, 0x04, 0x72, 0x09, 0xF9, 0x02, 0x0A, 0xF0, 0xB2, 0x82, 0x6F, 0xB5, 0x60,
  0x4F, 0xA0, 0x10, 0xAF, 0x0B, 0x20, 0x6B, 0x84, 0xEB, 0x87, 0x8B, 0xFA, 0x81, 0xC0, 0xAF, 0x0B,
  0x20, 0x6F, 0xFC, 0x81, 0x80, 0xAF, 0x0B, 0x20, 0x6F, 0xFB, 0x82, 0xE1, 0x0A, 0xF0, 0xB2, 0x06,
  0xFF, 0xB0, 0x72, 0x0A, 0xF0, 0xB2, 0x06, 0xFF, 0xA0, 0x93, 0x0A, 0xF0, 0xB2, 0x05, 0xFF, 0x0E,
  0x06, 0x40, 0xAF, 0x0B, 0x38, 0x12, 0x9D, 0xFA, 0x81, 0xC7, 0x17, 0x76, 0x86, 0x24, 0x67, 0x76,
  0x54, 0x72,
  // "à" (U+00E0)
  0x50, 0x68, 0x04, 0x70, 0x67, 0x76, 0x06, 0xFA, 0x03, 0x77, 0x60, 0x7F, 0x90, 0xC7, 0x77, 0x07,
  0xF9, 0x07, 0x77, 0x70, 0x6F, 0x90, 0x37, 0x77, 0x05, 0xF0, 0xD7, 0x77, 0x10, 0x40, 0xEE, 0x08,
  0x77, 0x71, 0x03, 0x0E, 0xE0, 0x47, 0x77, 0x10, 0x20, 0xDD, 0x0E, 0x01, 0x77, 0x71, 0x01, 0x0B,
  0xD0, 0x88, 0x09, 0xD1, 0x08, 0x73, 0x55, 0x67, 0x76, 0x53, 0x77, 0x38, 0x15, 0x9D, 0xFC, 0x81,
  0xD8, 0x27, 0x30, 0x30, 0xAF, 0xFC, 0x0B, 0x03, 0x70, 0xBF, 0xFF, 0x90, 0x86, 0x07, 0xFF, 0xFA,
  0x09, 0x50, 0x10, 0xEF, 0xFF, 0xA0, 0x55, 0x08, 0xFF, 0xFA, 0x0E, 0x50, 0x10, 0xEC, 0x87, 0xEC,
  0xA8, 0x77, 0x79, 0xCF, 0xB0, 0x55, 0x83, 0x8F, 0xB6, 0x37, 0x20, 0x20, 0xBF, 0x90, 0xA7, 0x77,
  0x0C, 0xF0, 0xD7, 0x77, 0x05, 0xF9, 0x77, 0x70, 0x3F, 0x90, 0x17, 0x76, 0x02, 0xF9, 0x01, 0x78,
  0x44, 0x7A, 0xCD, 0xEF, 0xFA, 0x01, 0x48, 0x11, 0x9E, 0xFF, 0xF9, 0x01, 0x30, 0x70, 0xEF, 0xFF,
  0xB0, 0x12, 0x08, 0xFF, 0xFD, 0x81, 0x10, 0x5F, 0xFF, 0xE8, 0x11, 0x0E, 0xFA, 0x81, 0x95, 0x26,
  0x02, 0xF9, 0x01, 0x05, 0xF9, 0x0C, 0x01, 0x72, 0x02, 0xF9, 0x01, 0x0A, 0xF0, 0xE0, 0x17, 0x30,
  0x3F, 0x90, 0x10, 0xCF, 0x09, 0x74, 0x04, 0xF9, 0x01, 0x0E, 0xF0, 0x77, 0x40, 0x8F, 0x90, 0x1F,
  0x90, 0x87, 0x30, 0x10, 0xEF, 0x90, 0x10, 0xEF, 0x0D, 0x72, 0x01, 0x0C, 0xFA, 0x01, 0x0D, 0xF9,
  0x0A, 0x01, 0x60, 0x50, 0xEF, 0xB0, 0x10, 0x9F, 0xB8, 0x4B, 0x87, 0x8A, 0xEF, 0xD0, 0x10, 0x5F,
  0xFF, 0xF8, 0x11, 0x0D, 0xFF, 0xC0, 0x0E, 0xF8, 0x11, 0x05, 0xFF, 0xB8, 0x1E, 0x39, 0xF0, 0x12,
  0x09, 0xFF, 0x98, 0x2D, 0x30, 0x4F, 0x01, 0x30, 0x8F, 0xE0, 0xA0, 0x13, 0x0E, 0xE0, 0x14, 0x81,
  0x2A, 0xEF, 0x81, 0xE9, 0x25, 0x0A, 0xE0, 0x17, 0x85, 0x35, 0x67, 0x65, 0x27, 0x72,
  // "á" (U+00E1)
  0x77, 0x20, 0x68, 0x04, 0x70, 0x67, 0x75, 0x04, 0xFA, 0x05, 0x77, 0x50, 0xDF, 0x90, 0x67, 0x75,
  0x08, 0xF9, 0x06, 0x77, 0x50, 0x3F, 0x90, 0x57, 0x76, 0x0D, 0xF0, 0x47, 0x76, 0x09, 0xE0, 0xE0,
  0x47, 0x76, 0x05, 0xE0, 0xE0, 0x37, 0x76, 0x02, 0x0E, 0xD0, 0xC0, 0x17, 0x77, 0x09, 0xD0, 0xA8,
  0x09, 0xD5, 0x08, 0x73, 0x55, 0x67, 0x76, 0x53, 0x77, 0x38, 0x15, 0x9D, 0xFC, 0x81, 0xD8, 0x27,
  0x30, 0x30, 0xAF, 0xFC, 0x0B, 0x03, 0x70, 0xBF, 0xFF, 0x90, 0x86, 0x07, 0xFF, 0xFA, 0x09, 0x50,
  0x10, 0xEF, 0xFF, 0xA0, 0x55, 0x08, 0xFF, 0xFA, 0x0E, 0x50, 0x10, 0xEC, 0x87, 0xEC, 0xA8, 0x77,
  0x79, 0xCF, 0xB0, 0x55, 0x83, 0x8F, 0xB6, 0x37, 0x20, 0x20, 0xBF, 0x90, 0xA7, 0x77, 0x0C, 0xF0,
  0xD7, 0x77, 0x05, 0xF9, 0x77, 0x70, 0x3F, 0x90, 0x17, 0x76, 0x02, 0xF9, 0x01, 0x78, 0x44, 0x7A,
  0xCD, 0xEF, 0xFA, 0x01, 0x48, 0x11, 0x9E, 0xFF, 0xF9, 0x01, 0x30, 0x70, 0xEF, 0xFF, 0xB0, 0x12,
  0x08, 0xFF, 0xFD, 0x81, 0x10, 0x5F, 0xFF, 0xE8, 0x11, 0x0E, 0xFA, 0x81, 0x95, 0x26, 0x02, 0xF9,
  0x01, 0x05, 0xF9, 0x0C, 0x01, 0x72, 0x02, 0xF9, 0x01, 0x0A, 0xF0, 0xE0, 0x17, 0x30, 0x3F, 0x90,
  0x10, 0xCF, 0x09, 0x74, 0x04, 0xF9, 0x01, 0x0E, 0xF0, 0x77, 0x40, 0x8F, 0x90, 0x1F, 0x90, 0x87,
  0x30, 0x10, 0xEF, 0x90, 0x10, 0xEF, 0x0D, 0x72, 0x01, 0x0C, 0xFA, 0x01, 0x0D, 0xF9, 0x0A, 0x01,
  0x60, 0x50, 0xEF, 0xB0, 0x10, 0x9F, 0xB8, 0x4B, 0x87, 0x8A, 0xEF, 0xD0, 0x10, 0x5F, 0xFF, 0xF8,
  0x11, 0x0D, 0xFF, 0xC0, 0x0E, 0xF8, 0x11, 0x05, 0xFF, 0xB8, 0x1E, 0x39, 0xF0, 0x12, 0x09, 0xFF,
  0x98, 0x2D, 0x30, 0x4F, 0x01, 0x30, 0x8F, 0xE0, 0xA0, 0x13, 0x0E, 0xE0, 0x14, 0x81, 0x2A, 0xEF,
  0x81, 0xE9, 0x25, 0x0A, 0xE0, 0x17, 0x85, 0x35, 0x67, 0x65, 0x27, 0x72,
  // "â" (U+00E2)
  0x73, 0x02, 0x80, 0x47, 0x06, 0x77, 0x60, 0xCF, 0xA0, 0x47, 0x74, 0x07, 0xFB, 0x0D, 0x77, 0x30,
  0x3F, 0xD0, 0x97, 0x71, 0x01, 0x0D, 0xFE, 0x05, 0x77, 0x0A, 0xE0, 0xA0, 0x5E, 0x0E, 0x02, 0x75,
  0x07, 0xE0, 0xA2, 0x05, 0xE0, 0xD0, 0x17, 0x30, 0x4E, 0x09, 0x40, 0x40, 0xED, 0x0B, 0x72, 0x03,
  0x0E, 0xD0, 0x76, 0x03, 0x0D, 0xD0, 0x87, 0x10, 0xCC, 0x0E, 0x04, 0x71, 0x01, 0x0B, 0xD0, 0x28,
  0x09, 0xC3, 0x08, 0x73, 0x55, 0x67, 0x76, 0x53, 0x77, 0x38, 0x15, 0x9D, 0xFC, 0x81, 0xD8, 0x27,
  0x30, 0x30, 0xAF, 0xFC, 0x0B, 0x03, 0x70, 0xBF, 0xFF, 0x90, 0x86, 0x07, 0xFF, 0xFA, 0x09, 0x50,
  0x10, 0xEF, 0xFF, 0xA0, 0x55, 0x08, 0xFF, 0xFA, 0x0E, 0x50, 0x10, 0xEC, 0x87, 0xEC, 0xA8, 0x77,
  0x79, 0xCF, 0xB0, 0x55, 0x83, 0x8F, 0xB6, 0x37, 0x20, 0x20, 0xBF, 0x90, 0xA7, 0x77, 0x0C, 0xF0,
  0xD7, 0x77, 0x05, 0xF9, 0x77, 0x70, 0x3F, 0x90, 0x17, 0x76, 0x02, 0xF9, 0x01, 0x78, 0x44, 0x7A,
  0xCD, 0xEF, 0xFA, 0x01, 0x48, 0x11, 0x9E, 0xFF, 0xF9, 0x01, 0x30, 0x70, 0xEF, 0xFF, 0xB0, 0x12,
  0x08, 0xFF, 0xFD, 0x81, 0x10, 0x5F, 0xFF, 0xE8, 0x11, 0x0E, 0xFA, 0x81, 0x95, 0x26, 0x02, 0xF9,
  0x01, 0x05, 0xF9, 0x0C, 0x01, 0x72, 0x02, 0xF9, 0x01, 0x0A, 0xF0, 0xE0, 0x17, 0x30, 0x3F, 0x90,
  0x10, 0xCF, 0x09, 0x74, 0x04, 0xF9, 0x01, 0x0E, 0xF0, 0x77, 0x40, 0x8F, 0x90, 0x1F, 0x90, 0x87,
  0x30, 0x10, 0xEF, 0x90, 0x10, 0xEF, 0x0D, 0x72, 0x01, 0x0C, 0xFA, 0x01, 0x0D, 0xF9, 0x0A, 0x01,
  0x60, 0x50, 0xEF, 0xB0, 0x10, 0x9F, 0xB8, 0x4B, 0x87, 0x8A, 0xEF, 0xD0, 0x10, 0x5F, 0xFF, 0xF8,
  0x11, 0x0D, 0xFF, 0xC0, 0x0E, 0xF8, 0x11, 0x05, 0xFF, 0xB8, 0x1E, 0x39, 0xF0, 0x12, 0x09, 0xFF,
  0x98, 0x2D, 0x30, 0x4F, 0x01, 0x30, 0x8F, 0xE0, 0xA0, 0x13, 0x0E, 0xE0, 0x14, 0x81, 0x2A, 0xEF,
  0x81, 0xE9, 0x25, 0x0A, 0xE0, 0x17, 0x85, 0x35, 0x67, 0x65, 0x27, 0x72,
  // "ã" (U+00E3)
  0x78, 0x54, 0xBE, 0xED, 0x93, 0x70, 0x1C, 0x05, 0x72, 0x09, 0xF0, 0xC0, 0x45, 0x06, 0xC0, 0x37,
  0x10, 0x6F, 0xB8, 0x4C, 0x62, 0x03, 0xEC, 0x01, 0x71, 0x0E, 0xFF, 0xD0, 0xD7, 0x10, 0x6F, 0xFE,
  0x08, 0x71, 0x0C, 0xFF, 0xE0, 0x17, 0x1C, 0x84, 0xD3, 0x02, 0x7D, 0xFB, 0x06, 0x71, 0x03, 0xC0,
  0x55, 0x05, 0x0C, 0xF0, 0x87, 0x20, 0x5C, 0x71, 0x85, 0x49, 0xDE, 0xEA, 0x48, 0x09, 0xC7, 0x08,
  0x73, 0x55, 0x67, 0x76, 0x53, 0x77, 0x38, 0x15, 0x9D, 0xFC, 0x81, 0xD8, 0x27, 0x30, 0x30, 0xAF,
  0xFC, 0x0B, 0x03, 0x70, 0xBF, 0xFF, 0x90, 0x86, 0x07, 0xFF, 0xFA, 0x09, 0x50, 0x10, 0xEF, 0xFF,
  0xA0, 0x55, 0x08, 0xFF, 0xFA, 0x0E, 0x50, 0x10, 0xEC, 0x87, 0xEC, 0xA8, 0x77, 0x79, 0xCF, 0xB0,
  0x55, 0x83, 0x8F, 0xB6, 0x37, 0x20, 0x20, 0xBF, 0x90, 0xA7, 0x77, 0x0C, 0xF0, 0xD7, 0x77, 0x05,
  0xF9, 0x77, 0x70, 0x3F, 0x90, 0x17, 0x76, 0x02, 0xF9, 0x01, 0x78, 0x44, 0x7A, 0xCD, 0xEF, 0xFA,
  0x01, 0x48, 0x11, 0x9E, 0xFF, 0xF9, 0x01, 0x30, 0x70, 0xEF, 0xFF, 0xB0, 0x12, 0x08, 0xFF, 0xFD,
  0x81, 0x10, 0x5F, 0xFF, 0xE8, 0x11, 0x0E, 0xFA, 0x81, 0x95, 0x26, 0x02, 0xF9, 0x01, 0x05, 0xF9,
  0x0C, 0x01, 0x72, 0x02, 0xF9, 0x01, 0x0A, 0xF0, 0xE0, 0x17, 0x30, 0x3F, 0x90, 0x10, 0xCF, 0x09,
  0x74, 0x04, 0xF9, 0x01, 0x0E, 0xF0, 0x77, 0x40, 0x8F, 0x90, 0x1F, 0x90, 0x87, 0x30, 0x10, 0xEF,
  0x90, 0x10, 0xEF, 0x0D, 0x72, 0x01, 0x0C, 0xFA, 0x01, 0x0D, 0xF9, 0x0A, 0x01, 0x60, 0x50, 0xEF,
  0xB0, 0x10, 0x9F, 0xB8, 0x4B, 0x87, 0x8A, 0xEF, 0xD0, 0x10, 0x5F, 0xFF, 0xF8, 0x11, 0x0D, 0xFF,
  0xC0, 0x0E, 0xF8, 0x11, 0x05, 0xFF, 0xB8, 0x1E, 0x39, 0xF0, 0x12, 0x09, 0xFF, 0x98, 0x2D, 0x30,
  0x4F, 0x01, 0x30, 0x8F, 0xE0, 0xA0, 0x13, 0x0E, 0xE0, 0x14, 0x81, 0x2A, 0xEF, 0x81, 0xE9, 0x25,
  0x0A, 0xE0, 0x17, 0x85, 0x35, 0x67, 0x65, 0x27, 0x72,
  // "ä" (U+00E4)
  0x58, 0x43, 0xBE, 0xFC, 0x57, 0x18, 0x43, 0xBE, 0xFC, 0x67, 0x20, 0x4E, 0x08, 0x60, 0x4E, 0x09,
  0x71, 0x0D, 0xF0, 0x25, 0x0D, 0xF0, 0x26, 0x01, 0xF9, 0x06, 0x40, 0x1F, 0x90, 0x66, 0x02, 0xF9,
  0x07, 0x40, 0x2F, 0x90, 0x76, 0x01, 0xF9, 0x05, 0x40, 0x1F, 0x90, 0x67, 0x0C, 0xF0, 0x15, 0x0C,
  0xF0, 0x27, 0x04, 0xE0, 0x76, 0x03, 0xE0, 0x87, 0x28, 0x43, 0xBE, 0xFC, 0x57, 0x18, 0x43, 0xBE,
  0xFC, 0x58, 0x09, 0xC5, 0x08, 0x73, 0x55, 0x67, 0x76, 0x53, 0x77, 0x38, 0x15, 0x9D, 0xFC, 0x81,
  0xD8, 0x27, 0x30, 0x30, 0xAF, 0xFC, 0x0B, 0x03, 0x70, 0xBF, 0xFF, 0x90, 0x86, 0x07, 0xFF, 0xFA,
  0x09, 0x50, 0x10, 0xEF, 0xFF, 0xA0, 0x55, 0x08, 0xFF, 0xFA, 0x0E, 0x50, 0x10, 0xEC, 0x87, 0xEC,
  0xA8, 0x77, 0x79, 0xCF, 0xB0, 0x55, 0x83, 0x8F, 0xB6, 0x37, 0x20, 0x20, 0xBF, 0x90, 0xA7, 0x77,
  0x0C, 0xF0, 0xD7, 0x77, 0x05, 0xF9, 0x77, 0x70, 0x3F, 0x90, 0x17, 0x76, 0x02, 0xF9, 0x01, 0x78,
  0x44, 0x7A, 0xCD, 0xEF, 0xFA, 0x01, 0x48, 0x11, 0x9E, 0xFF, 0xF9, 0x01, 0x30, 0x70, 0xEF, 0xFF,
  0xB0, 0x12, 0x08, 0xFF, 0xFD, 0x81, 0x10, 0x5F, 0xFF, 0xE8, 0x11, 0x0E, 0xFA, 0x81, 0x95, 0x26,
  0x02, 0xF9, 0x01, 0x05, 0xF9, 0x0C, 0x01, 0x72, 0x02, 0xF9, 0x01, 0x0A, 0xF0, 0xE0, 0x17, 0x30,
  0x3F, 0x90, 0x10, 0xCF, 0x09, 0x74, 0x04, 0xF9, 0x01, 0x0E, 0xF0, 0x77, 0x40, 0x8F, 0x90, 0x1F,
  0x90, 0x87, 0x30, 0x10, 0xEF, 0x90, 0x10, 0xEF, 0x0D, 0x72, 0x01, 0x0C, 0xFA, 0x01, 0x0D, 0xF9,
  0x0A, 0x01, 0x60, 0x50, 0xEF, 0xB0, 0x10, 0x9F, 0xB8, 0x4B, 0x87, 0x8A, 0xEF, 0xD0, 0x10, 0x5F,
  0xFF, 0xF8, 0x11, 0x0D, 0xFF, 0xC0, 0x0E, 0xF8, 0x11, 0x05, 0xFF, 0xB8, 0x1E, 0x39, 0xF0, 0x12,
  0x09, 0xFF, 0x98, 0x2D, 0x30, 0x4F, 0x01, 0x30, 0x8F, 0xE0, 0xA0, 0x13, 0x0E, 0xE0, 0x14, 0x81,
  0x2A, 0xEF, 0x81, 0xE9, 0x25, 0x0A, 0xE0, 0x17, 0x85, 0x35, 0x67, 0x65, 0x27, 0x72,
  // "å" (U+00E5)
  0x74, 0x86, 0x4A, 0xDF, 0xEC, 0x82, 0x77, 0x70, 0xAF, 0x90, 0x77, 0x75, 0x0B, 0xFB, 0x08, 0x77,
  0x30, 0x6F, 0xD0, 0x47, 0x72, 0x0C, 0xC8, 0x26, 0x11, 0x8C, 0x0B, 0x77, 0x10, 0x1C, 0x07, 0x40,
  0xAC, 0x77, 0x10, 0x2C, 0x03, 0x40, 0x5C, 0x01, 0x77, 0x02, 0xC0, 0x34, 0x05, 0xC0, 0x17, 0x70,
  0x1C, 0x07, 0x40, 0xAB, 0x0E, 0x77, 0x20, 0xCB, 0x83, 0xE5, 0x11, 0x8C, 0x0B, 0x77, 0x20, 0x6F,
  0xD0, 0x47, 0x73, 0x0B, 0xFB, 0x08, 0x77, 0x50, 0xAF, 0x90, 0x87, 0x77, 0x86, 0x4A, 0xDF, 0xED,
  0x92, 0x80, 0x9D, 0x30, 0x87, 0x35, 0x56, 0x77, 0x65, 0x37, 0x73, 0x81, 0x59, 0xDF, 0xC8, 0x1D,
  0x82, 0x73, 0x03, 0x0A, 0xFF, 0xC0, 0xB0, 0x37, 0x0B, 0xFF, 0xF9, 0x08, 0x60, 0x7F, 0xFF, 0xA0,
  0x95, 0x01, 0x0E, 0xFF, 0xFA, 0x05, 0x50, 0x8F, 0xFF, 0xA0, 0xE5, 0x01, 0x0E, 0xC8, 0x7E, 0xCA,
  0x87, 0x77, 0x9C, 0xFB, 0x05, 0x58, 0x38, 0xFB, 0x63, 0x72, 0x02, 0x0B, 0xF9, 0x0A, 0x77, 0x70,
  0xCF, 0x0D, 0x77, 0x70, 0x5F, 0x97, 0x77, 0x03, 0xF9, 0x01, 0x77, 0x60, 0x2F, 0x90, 0x17, 0x84,
  0x47, 0xAC, 0xDE, 0xFF, 0xA0, 0x14, 0x81, 0x19, 0xEF, 0xFF, 0x90, 0x13, 0x07, 0x0E, 0xFF, 0xFB,
  0x01, 0x20, 0x8F, 0xFF, 0xD8, 0x11, 0x05, 0xFF, 0xFE, 0x81, 0x10, 0xEF, 0xA8, 0x19, 0x52, 0x60,
  0x2F, 0x90, 0x10, 0x5F, 0x90, 0xC0, 0x17, 0x20, 0x2F, 0x90, 0x10, 0xAF, 0x0E, 0x01, 0x73, 0x03,
  0xF9, 0x01, 0x0C, 0xF0, 0x97, 0x40, 0x4F, 0x90, 0x10, 0xEF, 0x07, 0x74, 0x08, 0xF9, 0x01, 0xF9,
  0x08, 0x73, 0x01, 0x0E, 0xF9, 0x01, 0x0E, 0xF0, 0xD7, 0x20, 0x10, 0xCF, 0xA0, 0x10, 0xDF, 0x90,
  0xA0, 0x16, 0x05, 0x0E, 0xFB, 0x01, 0x09, 0xFB, 0x84, 0xB8, 0x78, 0xAE, 0xFD, 0x01, 0x05, 0xFF,
  0xFF, 0x81, 0x10, 0xDF, 0xFC, 0x00, 0xEF, 0x81, 0x10, 0x5F, 0xFB, 0x81, 0xE3, 0x9F, 0x01, 0x20,
  0x9F, 0xF9, 0x82, 0xD3, 0x04, 0xF0, 0x13, 0x08, 0xFE, 0x0A, 0x01, 0x30, 0xEE, 0x01, 0x48, 0x12,
  0xAE, 0xF8, 0x1E, 0x92, 0x50, 0xAE, 0x01, 0x78, 0x53, 0x56, 0x76, 0x52, 0x77, 0x20,
  // "æ" (U+00E6)
  0x78, 0x51, 0x46, 0x77, 0x53, 0x72, 0x84, 0x36, 0x76, 0x51, 0x74, 0x81, 0x38, 0xDF, 0x81, 0xE9,
  0x23, 0x81, 0x18, 0xEE, 0x0B, 0x03, 0x70, 0x30, 0xBF, 0xE8, 0x27, 0x04, 0xEF, 0xB0, 0x66, 0x08,
  0xFF, 0x90, 0xCF, 0xE0, 0x55, 0x01, 0x0E, 0xFF, 0xFF, 0x0E, 0x02, 0x50, 0x8F, 0xFF, 0xF9, 0x0A,
  0x50, 0x1F, 0xFF, 0xFA, 0x01, 0x50, 0x9A, 0x84, 0xC9, 0x77, 0x9D, 0xFB, 0x82, 0xD8, 0x8D, 0xF0,
  0x65, 0x01, 0x05, 0x70, 0x7F, 0x90, 0xD0, 0x12, 0x01, 0x0D, 0xE0, 0xB7, 0x71, 0x0C, 0xF0, 0x74,
  0x06, 0xE0, 0xE7, 0x71, 0x09, 0xF0, 0x14, 0x02, 0xF0, 0x27, 0x70, 0x9F, 0x6F, 0x03, 0x77, 0x09,
  0xE0, 0xD6, 0x0D, 0xE0, 0x56, 0x82, 0x69, 0xDE, 0xFF, 0xFC, 0x05, 0x40, 0x70, 0xEF, 0xFF, 0xF9,
  0x06, 0x30, 0xBF, 0xFF, 0xFB, 0x06, 0x20, 0x9F, 0xFF, 0xFC, 0x81, 0x60, 0x3F, 0xFF, 0xFD, 0x81,
  0x60, 0x9F, 0x81, 0xE6, 0x12, 0x09, 0xE0, 0xA7, 0x71, 0x0E, 0xF0, 0x24, 0x09, 0xE0, 0xC7, 0x70,
  0x2F, 0x09, 0x50, 0x9E, 0x0E, 0x77, 0x04, 0xF0, 0x55, 0x0A, 0xF0, 0x27, 0x60, 0x5F, 0x03, 0x50,
  0xBF, 0x08, 0x76, 0x06, 0xF0, 0x45, 0x0E, 0xF0, 0xE0, 0x17, 0x50, 0x5F, 0x06, 0x40, 0x4F, 0xA0,
  0xB7, 0x20, 0x42, 0x04, 0xF0, 0xD0, 0x13, 0x0C, 0xFB, 0x0C, 0x02, 0x50, 0x10, 0x99, 0x20, 0x1F,
  0x98, 0x2D, 0x88, 0xDF, 0xE8, 0x3B, 0x87, 0x8B, 0xB3, 0x0E, 0xFF, 0xFF, 0xC3, 0x09, 0xFF, 0x90,
  0x5F, 0xFA, 0x30, 0x2F, 0xF8, 0x16, 0x07, 0xFF, 0x94, 0x08, 0xFD, 0x09, 0x30, 0x8F, 0xF5, 0x09,
  0xFB, 0x09, 0x50, 0x50, 0xEF, 0xC0, 0x76, 0x05, 0x0D, 0xE0, 0xC0, 0x57, 0x81, 0x18, 0xDF, 0x0A,
  0x02, 0x72, 0x84, 0x25, 0x77, 0x52, 0x75, 0x84, 0x25, 0x77, 0x64, 0x60,
  // "ç" (U+00E7)
  0x75, 0x89, 0x02, 0x46, 0x77, 0x76, 0x53, 0x17, 0x68, 0x21, 0x6B, 0xEF, 0xB8, 0x2D, 0xA6, 0x17,
  0x81, 0x18, 0xEF, 0xFB, 0x0B, 0x50, 0x40, 0xEF, 0xFD, 0x0C, 0x40, 0x5F, 0xFF, 0x06, 0x30, 0x4F,
  0xFF, 0x90, 0x12, 0x01, 0x0E, 0xFF, 0xF0, 0xA3, 0x09, 0xFC, 0x85, 0xC9, 0x77, 0x8A, 0xCC, 0x04,
  0x20, 0x2F, 0xB0, 0xA0, 0x27, 0x18, 0x14, 0xAD, 0x30, 0x8F, 0xA0, 0x67, 0x72, 0x0D, 0xF9, 0x09,
  0x77, 0x20, 0x2F, 0xA0, 0x17, 0x72, 0x05, 0xF9, 0x0A, 0x77, 0x30, 0x8F, 0x90, 0x67, 0x73, 0x0A,
  0xF9, 0x03, 0x77, 0x30, 0xBF, 0x90, 0x17, 0x73, 0x0B, 0xF9, 0x77, 0x40, 0xCF, 0x97, 0x74, 0x0B,
  0xF9, 0x01, 0x77, 0x30, 0xAF, 0x90, 0x27, 0x73, 0x09, 0xF9, 0x05, 0x77, 0x30, 0x7F, 0x90, 0x97,
  0x73, 0x03, 0xF9, 0x0E, 0x77, 0x4F, 0xA0, 0x87, 0x73, 0x0B, 0xFA, 0x06, 0x75, 0x83, 0x3B, 0x20,
  0x5F, 0xB0, 0x90, 0x27, 0x81, 0x16, 0xBA, 0x02, 0x20, 0xDF, 0xC8, 0x5C, 0x97, 0x78, 0xAD, 0xD0,
  0x22, 0x05, 0xFF, 0xFA, 0x02, 0x30, 0x9F, 0xFF, 0x90, 0x24, 0x0B, 0xFF, 0xF0, 0x25, 0x09, 0xFF,
  0xE0, 0x26, 0x04, 0x0C, 0xFF, 0xB0, 0xA0, 0x17, 0x18, 0x13, 0x9D, 0xFB, 0x82, 0xEB, 0x71, 0x76,
  0x81, 0x13, 0xCC, 0x81, 0x74, 0x27, 0x75, 0x0D, 0xB0, 0xB7, 0x77, 0x04, 0xD0, 0xA0, 0x37, 0x75,
  0x0B, 0xF0, 0x87, 0x74, 0x0C, 0x0E, 0xF0, 0x87, 0x75, 0x04, 0x0C, 0xE0, 0x17, 0x76, 0x0E, 0xD0,
  0x67, 0x76, 0x0B, 0xD0, 0x77, 0x76, 0x0E, 0xD0, 0x77, 0x70, 0x50, 0x22, 0x03, 0x0B, 0xE0, 0x57,
  0x60, 0x1F, 0xC0, 0xE7, 0x70, 0x1F, 0xC0, 0x57, 0x70, 0x1F, 0xA0, 0xE0, 0x57, 0x72, 0x89, 0x09,
  0xCE, 0xEF, 0xED, 0xA6, 0x17,
  // "è" (U+00E8)
  0x60, 0x68, 0x04, 0x70, 0x67, 0x76, 0x06, 0xFA, 0x03, 0x77, 0x60, 0x7F, 0x90, 0xC7, 0x77, 0x07,
  0xF9, 0x07, 0x77, 0x70, 0x6F, 0x90, 0x37, 0x77, 0x05, 0xF0, 0xD7, 0x77, 0x10, 0x40, 0xEE, 0x08,
  0x77, 0x71, 0x03, 0x0E, 0xE0, 0x47, 0x77, 0x10, 0x20, 0xDD, 0x0E, 0x01, 0x77, 0x71, 0x01, 0x0B,
  0xD0, 0x88, 0x09, 0xD1, 0x08, 0x71, 0x46, 0x67, 0x65, 0x41, 0x77, 0x48, 0x12, 0x8D, 0xFA, 0x81,
  0xC8, 0x27, 0x60, 0x20, 0xAF, 0xF9, 0x0A, 0x01, 0x73, 0x06, 0x0E, 0xFF, 0xB0, 0xE0, 0x47, 0x10,
  0x7F, 0xFF, 0x05, 0x60, 0x6F, 0xFF, 0x90, 0xE0, 0x24, 0x03, 0xFF, 0xFB, 0x0D, 0x40, 0xCF, 0xB8,
  0x4B, 0x87, 0x7A, 0xEF, 0xA0, 0x62, 0x05, 0xFA, 0x08, 0x01, 0x60, 0x60, 0xEF, 0x0D, 0x20, 0xBF,
  0x90, 0x47, 0x20, 0x30, 0xEF, 0x03, 0x01, 0xF9, 0x07, 0x74, 0x06, 0xF0, 0x70, 0x5F, 0x0E, 0x75,
  0x01, 0xF0, 0xA0, 0x9F, 0x0B, 0x76, 0x0D, 0xE0, 0xC0, 0xBF, 0xFF, 0xF0, 0x0D, 0xFF, 0xFF, 0x90,
  0xE8, 0x09, 0xA5, 0xF0, 0xEF, 0xFF, 0xF9, 0x0D, 0xF0, 0x77, 0x77, 0x0B, 0xF0, 0xA7, 0x77, 0x08,
  0xF0, 0xE7, 0x77, 0x04, 0xF9, 0x07, 0x77, 0x70, 0xEF, 0x90, 0x47, 0x76, 0x09, 0xFA, 0x06, 0x77,
  0x10, 0x20, 0x82, 0x02, 0xFB, 0x0C, 0x05, 0x73, 0x81, 0x48, 0xDA, 0x30, 0x8F, 0xD8, 0x6C, 0x98,
  0x77, 0x8A, 0xDE, 0x40, 0xCF, 0xFF, 0xC4, 0x01, 0x0D, 0xFF, 0xFB, 0x50, 0x10, 0xCF, 0xFF, 0xA7,
  0x08, 0xFF, 0xF9, 0x71, 0x02, 0x0A, 0xFF, 0xC0, 0xD0, 0x77, 0x38, 0x21, 0x6B, 0xEF, 0xC8, 0x1C,
  0x83, 0x77, 0x28, 0x90, 0x24, 0x67, 0x77, 0x66, 0x42, 0x70,
  // "é" (U+00E9)
  0x77, 0x30, 0x68, 0x04, 0x70, 0x67, 0x75, 0x04, 0xFA, 0x05, 0x77, 0x50, 0xDF, 0x90, 0x67, 0x75,
  0x08, 0xF9, 0x06, 0x77, 0x50, 0x3F, 0x90, 0x57, 0x76, 0x0D, 0xF0, 0x47, 0x76, 0x09, 0xE0, 0xE0,
  0x47, 0x76, 0x05, 0xE0, 0xE0, 0x37, 0x76, 0x02, 0x0E, 0xD0, 0xC0, 0x17, 0x77, 0x09, 0xD0, 0xA8,
  0x09, 0xD5, 0x08, 0x71, 0x46, 0x67, 0x65, 0x41, 0x77, 0x48, 0x12, 0x8D, 0xFA, 0x81, 0xC8, 0x27,
  0x60, 0x20, 0xAF, 0xF9, 0x0A, 0x01, 0x73, 0x06, 0x0E, 0xFF, 0xB0, 0xE0, 0x47, 0x10, 0x7F, 0xFF,
  0x05, 0x60, 0x6F, 0xFF, 0x90, 0xE0, 0x24, 0x03, 0xFF, 0xFB, 0x0D, 0x40, 0xCF, 0xB8, 0x4B, 0x87,
  0x7A, 0xEF, 0xA0, 0x62, 0x05, 0xFA, 0x08, 0x01, 0x60, 0x60, 0xEF, 0x0D, 0x20, 0xBF, 0x90, 0x47,
  0x20, 0x30, 0xEF, 0x03, 0x01, 0xF9, 0x07, 0x74, 0x06, 0xF0, 0x70, 0x5F, 0x0E, 0x75, 0x01, 0xF0,
  0xA0, 0x9F, 0x0B, 0x76, 0x0D, 0xE0, 0xC0, 0xBF, 0xFF, 0xF0, 0x0D, 0xFF, 0xFF, 0x90, 0xE8, 0x09,
  0xA5, 0xF0, 0xEF, 0xFF, 0xF9, 0x0D, 0xF0, 0x77, 0x77, 0x0B, 0xF0, 0xA7, 0x77, 0x08, 0xF0, 0xE7,
  0x77, 0x04, 0xF9, 0x07, 0x77, 0x70, 0xEF, 0x90, 0x47, 0x76, 0x09, 0xFA, 0x06, 0x77, 0x10, 0x20,
  0x82, 0x02, 0xFB, 0x0C, 0x05, 0x73, 0x81, 0x48, 0xDA, 0x30, 0x8F, 0xD8, 0x6C, 0x98, 0x77, 0x8A,
  0xDE, 0x40, 0xCF, 0xFF, 0xC4, 0x01, 0x0D, 0xFF, 0xFB, 0x50, 0x10, 0xCF, 0xFF, 0xA7, 0x08, 0xFF,
  0xF9, 0x71, 0x02, 0x0A, 0xFF, 0xC0, 0xD0, 0x77, 0x38, 0x21, 0x6B, 0xEF, 0xC8, 0x1C, 0x83, 0x77,
  0x28, 0x90, 0x24, 0x67, 0x77, 0x66, 0x42, 0x70,
  // "ê" (U+00EA)
  0x74, 0x02, 0x80, 0x47, 0x06, 0x77, 0x60, 0xCF, 0xA0, 0x47, 0x74, 0x07, 0xFB, 0x0D, 0x77, 0x30,
  0x3F, 0xD0, 0x97, 0x71, 0x01, 0x0D, 0xFE, 0x05, 0x77, 0x0A, 0xE0, 0xA0, 0x5E, 0x0E, 0x02, 0x75,
  0x07, 0xE0, 0xA2, 0x05, 0xE0, 0xD0, 0x17, 0x30, 0x4E, 0x09, 0x40, 0x40, 0xED, 0x0B, 0x72, 0x03,
  0x0E, 0xD0, 0x76, 0x03, 0x0D, 0xD0, 0x87, 0x10, 0xCC, 0x0E, 0x04, 0x71, 0x01, 0x0B, 0xD0, 0x28,
  0x09, 0xC3, 0x08, 0x71, 0x46, 0x67, 0x65, 0x41, 0x77, 0x48, 0x12, 0x8D, 0xFA, 0x81, 0xC8, 0x27,
  0x60, 0x20, 0xAF, 0xF9, 0x0A, 0x01, 0x73, 0x06, 0x0E, 0xFF, 0xB0, 0xE0, 0x47, 0x10, 0x7F, 0xFF,
  0x05, 0x60, 0x6F, 0xFF, 0x90, 0xE0, 0x24, 0x03, 0xFF, 0xFB, 0x0D, 0x40, 0xCF, 0xB8, 0x4B, 0x87,
  0x7A, 0xEF, 0xA0, 0x62, 0x05, 0xFA, 0x08, 0x01, 0x60, 0x60, 0xEF, 0x0D, 0x20, 0xBF, 0x90, 0x47,
  0x20, 0x30, 0xEF, 0x03, 0x01, 0xF9, 0x07, 0x74, 0x06, 0xF0, 0x70, 0x5F, 0x0E, 0x75, 0x01, 0xF0,
  0xA0, 0x9F, 0x0B, 0x76, 0x0D, 0xE0, 0xC0, 0xBF, 0xFF, 0xF0, 0x0D, 0xFF, 0xFF, 0x90, 0xE8, 0x09,
  0xA5, 0xF0, 0xEF, 0xFF, 0xF9, 0x0D, 0xF0, 0x77, 0x77, 0x0B, 0xF0, 0xA7, 0x77, 0x08, 0xF0, 0xE7,
  0x77, 0x04, 0xF9, 0x07, 0x77, 0x70, 0xEF, 0x90, 0x47, 0x76, 0x09, 0xFA, 0x06, 0x77, 0x10, 0x20,
  0x82, 0x02, 0xFB, 0x0C, 0x05, 0x73, 0x81, 0x48, 0xDA, 0x30, 0x8F, 0xD8, 0x6C, 0x98, 0x77, 0x8A,
  0xDE, 0x40, 0xCF, 0xFF, 0xC4, 0x01, 0x0D, 0xFF, 0xFB, 0x50, 0x10, 0xCF, 0xFF, 0xA7, 0x08, 0xFF,
  0xF9, 0x71, 0x02, 0x0A, 0xFF, 0xC0, 0xD0, 0x77, 0x38, 0x21, 0x6B, 0xEF, 0xC8, 0x1C, 0x83, 0x77,
  0x28, 0x90, 0x24, 0x67, 0x77, 0x66, 0x42, 0x70,
  // "ë" (U+00EB)
  0x68, 0x43, 0xBE, 0xFC, 0x57, 0x18, 0x43, 0xBE, 0xFC, 0x67, 0x20, 0x4E, 0x08, 0x60, 0x4E, 0x09,
  0x71, 0x0D, 0xF0, 0x25, 0x0D, 0xF0, 0x26, 0x01, 0xF9, 0x06, 0x40, 0x1F, 0x90, 0x66, 0x02, 0xF9,
  0x07, 0x40, 0x2F, 0x90, 0x76, 0x01, 0xF9, 0x05, 0x40, 0x1F, 0x90, 0x67, 0x0C, 0xF0, 0x15, 0x0C,
  0xF0, 0x27, 0x04, 0xE0, 0x76, 0x03, 0xE0, 0x87, 0x28, 0x43, 0xBE, 0xFC, 0x57, 0x18, 0x43, 0xBE,
  0xFC, 0x58, 0x09, 0xC5, 0x08, 0x71, 0x46, 0x67, 0x65, 0x41, 0x77, 0x48, 0x12, 0x8D, 0xFA, 0x81,
  0xC8, 0x27, 0x60, 0x20, 0xAF, 0xF9, 0x0A, 0x01, 0x73, 0x06, 0x0E, 0xFF, 0xB0, 0xE0, 0x47, 0x10,
  0x7F, 0xFF, 0x05, 0x60, 0x6F, 0xFF, 0x90, 0xE0, 0x24, 0x03, 0xFF, 0xFB, 0x0D, 0x40, 0xCF, 0xB8,
  0x4B, 0x87, 0x7A, 0xEF, 0xA0, 0x62, 0x05, 0xFA, 0x08, 0x01, 0x60, 0x60, 0xEF, 0x0D, 0x20, 0xBF,
  0x90, 0x47, 0x20, 0x30, 0xEF, 0x03, 0x01, 0xF9, 0x07, 0x74, 0x06, 0xF0, 0x70, 0x5F, 0x0E, 0x75,
  0x01, 0xF0, 0xA0, 0x9F, 0x0B, 0x76, 0x0D, 0xE0, 0xC0, 0xBF, 0xFF, 0xF0, 0x0D, 0xFF, 0xFF, 0x90,
  0xE8, 0x09, 0xA5, 0xF0, 0xEF, 0xFF, 0xF9, 0x0D, 0xF0, 0x77, 0x77, 0x0B, 0xF0, 0xA7, 0x77, 0x08,
  0xF0, 0xE7, 0x77, 0x04, 0xF9, 0x07, 0x77, 0x70, 0xEF, 0x90, 0x47, 0x76, 0x09, 0xFA, 0x06, 0x77,
  0x10, 0x20, 0x82, 0x02, 0xFB, 0x0C, 0x05, 0x73, 0x81, 0x48, 0xDA, 0x30, 0x8F, 0xD8, 0x6C, 0x98,
  0x77, 0x8A, 0xDE, 0x40, 0xCF, 0xFF, 0xC4, 0x01, 0x0D, 0xFF, 0xFB, 0x50, 0x10, 0xCF, 0xFF, 0xA7,
  0x08, 0xFF, 0xF9, 0x71, 0x02, 0x0A, 0xFF, 0xC0, 0xD0, 0x77, 0x38, 0x21, 0x6B, 0xEF, 0xC8, 0x1C,
  0x83, 0x77, 0x28, 0x90, 0x24, 0x67, 0x77, 0x66, 0x42, 0x70,
  // "ì" (U+00EC)
  0x50, 0x68, 0x04, 0x70, 0x67, 0x76, 0x06, 0xFA, 0x03, 0x77, 0x60, 0x7F, 0x90, 0xC7, 0x77, 0x07,
  0xF9, 0x07, 0x77, 0x70, 0x6F, 0x90, 0x37, 0x77, 0x05, 0xF0, 0xD7, 0x77, 0x10, 0x40, 0xEE, 0x08,
  0x77, 0x71, 0x03, 0x0E, 0xE0, 0x47, 0x77, 0x10, 0x20, 0xDD, 0x0E, 0x01, 0x77, 0x71, 0x01, 0x0B,
  0xD0, 0x88, 0x09, 0xF7, 0x00, 0xCF, 0xFB, 0x03, 0x74, 0x0C, 0xFF, 0xB0, 0x37, 0x40, 0xCF, 0xFB,
  0x03, 0x74, 0x0C, 0xFF, 0xB0, 0x37, 0x40, 0xCF, 0xFB, 0x03, 0x74, 0x0C, 0xFF, 0xB0, 0x37, 0x48,
  0x61, 0x35, 0x78, 0xAC, 0xDF, 0xB0, 0x37, 0x76, 0x08, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37,
  0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F,
  0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77,
  0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9,
  0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76,
  0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x78, 0x41, 0x35, 0x8A, 0xDF, 0xB8, 0x3C, 0x96,
  0x41, 0x48, 0x31, 0x69, 0xBE, 0xFF, 0xF8, 0x3E, 0xB8, 0x56, 0xFF, 0xFF, 0x90, 0x6F, 0xFF, 0xF9,
  0x06, 0xFF, 0xFF, 0x90, 0x6F, 0xFF, 0xF9, 0x06, 0xFF, 0xFF, 0x90,
  // "í" (U+00ED)
  0x77, 0x20, 0x68, 0x04, 0x70, 0x67, 0x75, 0x04, 0xFA, 0x05, 0x77, 0x50, 0xDF, 0x90, 0x67, 0x75,
  0x08, 0xF9, 0x06, 0x77, 0x50, 0x3F, 0x90, 0x57, 0x76, 0x0D, 0xF0, 0x47, 0x76, 0x09, 0xE0, 0xE0,
  0x47, 0x76, 0x05, 0xE0, 0xE0, 0x37, 0x76, 0x02, 0x0E, 0xD0, 0xC0, 0x17, 0x77, 0x09, 0xD0, 0xA8,
  0x0A, 0x83, 0x00, 0xCF, 0xFB, 0x03, 0x74, 0x0C, 0xFF, 0xB0, 0x37, 0x40, 0xCF, 0xFB, 0x03, 0x74,
  0x0C, 0xFF, 0xB0, 0x37, 0x40, 0xCF, 0xFB, 0x03, 0x74, 0x0C, 0xFF, 0xB0, 0x37, 0x48, 0x61, 0x35,
  0x78, 0xAC, 0xDF, 0xB0, 0x37, 0x76, 0x08, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07,
  0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37,
  0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F,
  0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77,
  0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9,
  0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x78, 0x41, 0x35, 0x8A, 0xDF, 0xB8, 0x3C, 0x96, 0x41, 0x48,
  0x31, 0x69, 0xBE, 0xFF, 0xF8, 0x3E, 0xB8, 0x56, 0xFF, 0xFF, 0x90, 0x6F, 0xFF, 0xF9, 0x06, 0xFF,
  0xFF, 0x90, 0x6F, 0xFF, 0xF9, 0x06, 0xFF, 0xFF, 0x90,
  // "î" (U+00EE)
  0x73, 0x02, 0x80, 0x47, 0x06, 0x77, 0x60, 0xCF, 0xA0, 0x47, 0x74, 0x07, 0xFB, 0x0D, 0x77, 0x30,
  0x3F, 0xD0, 0x97, 0x71, 0x01, 0x0D, 0xFE, 0x05, 0x77, 0x0A, 0xE0, 0xA0, 0x5E, 0x0E, 0x02, 0x75,
  0x07, 0xE0, 0xA2, 0x05, 0xE0, 0xD0, 0x17, 0x30, 0x4E, 0x09, 0x40, 0x40, 0xED, 0x0B, 0x72, 0x03,
  0x0E, 0xD0, 0x76, 0x03, 0x0D, 0xD0, 0x87, 0x10, 0xCC, 0x0E, 0x04, 0x71, 0x01, 0x0B, 0xD0, 0x28,
  0x09, 0xF1, 0x00, 0xCF, 0xFB, 0x03, 0x74, 0x0C, 0xFF, 0xB0, 0x37, 0x40, 0xCF, 0xFB, 0x03, 0x74,
  0x0C, 0xFF, 0xB0, 0x37, 0x40, 0xCF, 0xFB, 0x03, 0x74, 0x0C, 0xFF, 0xB0, 0x37, 0x48, 0x61, 0x35,
  0x78, 0xAC, 0xDF, 0xB0, 0x37, 0x76, 0x08, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07,
  0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37,
  0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F,
  0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77,
  0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9,
  0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x78, 0x41, 0x35, 0x8A, 0xDF, 0xB8, 0x3C, 0x96, 0x41, 0x48,
  0x31, 0x69, 0xBE, 0xFF, 0xF8, 0x3E, 0xB8, 0x56, 0xFF, 0xFF, 0x90, 0x6F, 0xFF, 0xF9, 0x06, 0xFF,
  0xFF, 0x90, 0x6F, 0xFF, 0xF9, 0x06, 0xFF, 0xFF, 0x90,
  // "ï" (U+00EF)
  0x58, 0x43, 0xBE, 0xFC, 0x57, 0x18, 0x43, 0xBE, 0xFC, 0x67, 0x20, 0x4E, 0x08, 0x60, 0x4E, 0x09,
  0x71, 0x0D, 0xF0, 0x25, 0x0D, 0xF0, 0x26, 0x01, 0xF9, 0x06, 0x40, 0x1F, 0x90, 0x66, 0x02, 0xF9,
  0x07, 0x40, 0x2F, 0x90, 0x76, 0x01, 0xF9, 0x05, 0x40, 0x1F, 0x90, 0x67, 0x0C, 0xF0, 0x15, 0x0C,
  0xF0, 0x27, 0x04, 0xE0, 0x76, 0x03, 0xE0, 0x87, 0x28, 0x43, 0xBE, 0xFC, 0x57, 0x18, 0x43, 0xBE,
  0xFC, 0x58, 0x09, 0xF3, 0x00, 0xCF, 0xFB, 0x03, 0x74, 0x0C, 0xFF, 0xB0, 0x37, 0x40, 0xCF, 0xFB,
  0x03, 0x74, 0x0C, 0xFF, 0xB0, 0x37, 0x40, 0xCF, 0xFB, 0x03, 0x74, 0x0C, 0xFF, 0xB0, 0x37, 0x48,
  0x61, 0x35, 0x78, 0xAC, 0xDF, 0xB0, 0x37, 0x76, 0x08, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37,
  0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F,
  0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77,
  0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9,
  0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76,
  0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x78, 0x41, 0x35, 0x8A, 0xDF, 0xB8, 0x3C, 0x96,
  0x41, 0x48, 0x31, 0x69, 0xBE, 0xFF, 0xF8, 0x3E, 0xB8, 0x56, 0xFF, 0xFF, 0x90, 0x6F, 0xFF, 0xF9,
  0x06, 0xFF, 0xFF, 0x90, 0x6F, 0xFF, 0xF9, 0x06, 0xFF, 0xFF, 0x90,
  // "ð" (U+00F0)
  0x73, 0x04, 0x03, 0x75, 0x05, 0x77, 0x28, 0x31, 0xEF, 0xB4, 0x71, 0x82, 0x2B, 0xF9, 0x77, 0x10,
  0x9C, 0x0C, 0x03, 0x50, 0x8C, 0x04, 0x76, 0x02, 0xF8, 0x39, 0x10, 0x5E, 0xD0, 0xD7, 0x60, 0xBF,
  0x90, 0xE0, 0xCF, 0x90, 0x87, 0x50, 0xBF, 0xFB, 0x08, 0x77, 0x05, 0x0D, 0xFE, 0x0B, 0x02, 0x77,
  0x30, 0x8F, 0xB0, 0xD0, 0x57, 0x75, 0x08, 0xFB, 0x0E, 0x02, 0x77, 0x30, 0x40, 0xDF, 0xD0, 0xE0,
  0x27, 0x70, 0x20, 0xAF, 0xF9, 0x0D, 0x01, 0x76, 0x0A, 0xF9, 0x09, 0xF9, 0x0B, 0x76, 0x02, 0x0E,
  0xD8, 0x2B, 0x20, 0x5F, 0x90, 0x77, 0x60, 0x7B, 0x0D, 0x05, 0x40, 0x6F, 0x90, 0x27, 0x68, 0x1C,
  0xF8, 0x70, 0x9F, 0x0B, 0x76, 0x02, 0x03, 0x72, 0x0C, 0xF0, 0x57, 0x77, 0x20, 0x2F, 0x0C, 0x75,
  0x89, 0x34, 0x9B, 0xEE, 0xFE, 0xDA, 0x72, 0x08, 0xF0, 0x47, 0x20, 0x70, 0xEF, 0xC8, 0x1A, 0x2E,
  0xE0, 0xA7, 0x04, 0x0D, 0xFF, 0x0D, 0x0B, 0xF0, 0x15, 0x06, 0xFF, 0xFC, 0x05, 0x40, 0x5F, 0xFF,
  0xD0, 0x93, 0x02, 0x0E, 0xFF, 0xFD, 0x0D, 0x30, 0xBF, 0xA8, 0x6A, 0x51, 0x01, 0x26, 0xDF, 0xC8,
  0x11, 0x03, 0xFA, 0x05, 0x71, 0x09, 0xFB, 0x81, 0x30, 0x9F, 0x90, 0x87, 0x30, 0xBF, 0xA8, 0x15,
  0x0E, 0xF0, 0xE7, 0x40, 0x2F, 0xA0, 0x70, 0x2F, 0x90, 0xA7, 0x50, 0xAF, 0x90, 0x70, 0x5F, 0x90,
  0x67, 0x50, 0x6F, 0x90, 0x80, 0x7F, 0x90, 0x47, 0x50, 0x3F, 0x90, 0x90, 0x8F, 0x90, 0x37, 0x50,
  0x2F, 0x90, 0x80, 0x9F, 0x90, 0x27, 0x50, 0x3F, 0x90, 0x70, 0x8F, 0x90, 0x37, 0x50, 0x3F, 0x90,
  0x60, 0x7F, 0x90, 0x37, 0x50, 0x5F, 0x90, 0x30, 0x5F, 0x90, 0x67, 0x50, 0x8F, 0x90, 0x10, 0x3F,
  0x90, 0x97, 0x50, 0xCF, 0x0C, 0x20, 0xEF, 0x0E, 0x74, 0x01, 0xF9, 0x08, 0x20, 0xAF, 0x90, 0x67,
  0x30, 0x8F, 0x90, 0x22, 0x04, 0xF9, 0x0E, 0x02, 0x71, 0x04, 0xF9, 0x0A, 0x40, 0xBF, 0x90, 0xD0,
  0x46, 0x06, 0x0E, 0xF9, 0x02, 0x40, 0x2F, 0xB8, 0x4D, 0x98, 0x8A, 0xEF, 0xA0, 0x76, 0x06, 0xFF,
  0xFA, 0x0B, 0x71, 0x06, 0xFF, 0xF0, 0xB7, 0x30, 0x40, 0xEF, 0xFC, 0x08, 0x75, 0x01, 0x09, 0xFF,
  0x90, 0xC0, 0x37, 0x71, 0x81, 0x17, 0xCF, 0xA8, 0x1E, 0x94, 0x77, 0x68, 0x71, 0x35, 0x67, 0x76,
  0x42, 0x75,
  // "ñ" (U+00F1)
  0x78, 0x54, 0xBE, 0xED, 0x93, 0x70, 0x1C, 0x05, 0x72, 0x09, 0xF0, 0xC0, 0x45, 0x06, 0xC0, 0x37,
  0x10, 0x6F, 0xB8, 0x4C, 0x62, 0x03, 0xEC, 0x01, 0x71, 0x0E, 0xFF, 0xD0, 0xD7, 0x10, 0x6F, 0xFE,
  0x08, 0x71, 0x0C, 0xFF, 0xE0, 0x17, 0x1C, 0x84, 0xD3, 0x02, 0x7D, 0xFB, 0x06, 0x71, 0x03, 0xC0,
  0x55, 0x05, 0x0C, 0xF0, 0x87, 0x20, 0x5C, 0x71, 0x85, 0x49, 0xDE, 0xEA, 0x48, 0x09, 0xD4, 0x08,
  0x53, 0x56, 0x76, 0x53, 0x71, 0x0A, 0xE0, 0x14, 0x81, 0x39, 0xEF, 0x90, 0xB0, 0x45, 0x0A, 0xE0,
  0x63, 0x09, 0xFE, 0x0B, 0x01, 0x30, 0xAE, 0x82, 0xC0, 0x1C, 0xFF, 0x90, 0xD0, 0x22, 0x0A, 0xF0,
  0x20, 0xBF, 0xFB, 0x0C, 0x20, 0xAF, 0x0E, 0xFF, 0xD8, 0x17, 0x0A, 0xFF, 0xFE, 0x81, 0xE0, 0xAF,
  0xD8, 0x3D, 0x97, 0x8A, 0xFC, 0x05, 0x0A, 0xFB, 0x0E, 0x04, 0x50, 0x10, 0xBF, 0xA0, 0x90, 0xAF,
  0xB0, 0x37, 0x10, 0xDF, 0x90, 0xC0, 0xAF, 0xA0, 0x77, 0x20, 0x5F, 0x90, 0xD0, 0xAF, 0x90, 0xE0,
  0x17, 0x3F, 0x90, 0xE0, 0xAF, 0x90, 0xA7, 0x40, 0xCF, 0x90, 0xAF, 0x90, 0x67, 0x40, 0xBF, 0x90,
  0xAF, 0x90, 0x47, 0x40, 0xAF, 0x90, 0xAF, 0x90, 0x17, 0x40, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF,
  0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90,
  0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF,
  0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97,
  0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50,
  0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF,
  0x90,
  // "ò" (U+00F2)
  0x60, 0x68, 0x04, 0x70, 0x67, 0x77, 0x10, 0x6F, 0xA0, 0x37, 0x77, 0x10, 0x7F, 0x90, 0xC7, 0x77,
  0x20, 0x7F, 0x90, 0x77, 0x77, 0x20, 0x6F, 0x90, 0x37, 0x77, 0x20, 0x5F, 0x0D, 0x77, 0x73, 0x04,
  0x0E, 0xE0, 0x87, 0x77, 0x30, 0x30, 0xEE, 0x04, 0x77, 0x73, 0x02, 0x0D, 0xD0, 0xE0, 0x17, 0x77,
  0x30, 0x10, 0xBD, 0x08, 0x80, 0x9E, 0x20, 0x86, 0x24, 0x67, 0x76, 0x53, 0x77, 0x78, 0x14, 0x9E,
  0xFA, 0x0B, 0x06, 0x77, 0x20, 0x40, 0xCF, 0xF0, 0xE0, 0x67, 0x60, 0x9F, 0xFC, 0x0C, 0x01, 0x72,
  0x01, 0x0C, 0xFF, 0xE0, 0xD0, 0x27, 0x10, 0xCF, 0xFF, 0x90, 0xD0, 0x16, 0x09, 0xFF, 0xFB, 0x0B,
  0x50, 0x3F, 0xB8, 0x4E, 0x98, 0x79, 0xDF, 0xB0, 0x54, 0x0C, 0xFA, 0x07, 0x60, 0x50, 0xEF, 0x90,
  0xD3, 0x03, 0xFA, 0x05, 0x71, 0x03, 0xFA, 0x05, 0x20, 0x9F, 0x90, 0xA7, 0x30, 0x9F, 0x90, 0xA2,
  0x0D, 0xF9, 0x02, 0x73, 0x01, 0xF9, 0x81, 0xE0, 0x2F, 0x90, 0xC7, 0x50, 0xCF, 0x90, 0x20, 0x4F,
  0x90, 0x87, 0x50, 0x8F, 0x90, 0x50, 0x6F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x70, 0x8F, 0x90, 0x47,
  0x50, 0x4F, 0x90, 0x08, 0xF9, 0x03, 0x75, 0x03, 0xF9, 0x00, 0x8F, 0x90, 0x37, 0x50, 0x3F, 0x90,
  0x08, 0xF9, 0x04, 0x75, 0x04, 0xF9, 0x08, 0x07, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x07, 0x05, 0xF9,
  0x08, 0x75, 0x08, 0xF9, 0x04, 0x02, 0xF9, 0x0C, 0x75, 0x0C, 0xF9, 0x81, 0x20, 0xEF, 0x90, 0x27,
  0x30, 0x1F, 0x90, 0xD2, 0x09, 0xF9, 0x0A, 0x73, 0x09, 0xF9, 0x09, 0x20, 0x4F, 0xA0, 0x57, 0x10,
  0x4F, 0xA0, 0x33, 0x0C, 0xFA, 0x07, 0x60, 0x50, 0xEF, 0x90, 0xC4, 0x04, 0xFB, 0x84, 0xE9, 0x77,
  0x9D, 0xFB, 0x04, 0x50, 0xAF, 0xFF, 0xB0, 0xA7, 0x0D, 0xFF, 0xF9, 0x0D, 0x01, 0x70, 0x10, 0xDF,
  0xFE, 0x0D, 0x02, 0x72, 0x01, 0x0B, 0xFF, 0xC0, 0xB0, 0x17, 0x50, 0x60, 0xDF, 0xF0, 0xE0, 0x67,
  0x72, 0x05, 0x0A, 0xFB, 0x0B, 0x06, 0x77, 0x78, 0x62, 0x56, 0x77, 0x65, 0x37, 0x50,
  // "ó" (U+00F3)
  0x77, 0x30, 0x68, 0x04, 0x70, 0x67, 0x77, 0x04, 0xFA, 0x05, 0x77, 0x70, 0xDF, 0x90, 0x67, 0x77,
  0x08, 0xF9, 0x06, 0x77, 0x70, 0x3F, 0x90, 0x57, 0x77, 0x10, 0xDF, 0x04, 0x77, 0x71, 0x09, 0xE0,
  0xE0, 0x47, 0x77, 0x10, 0x5E, 0x0E, 0x03, 0x77, 0x71, 0x02, 0x0E, 0xD0, 0xC0, 0x17, 0x77, 0x20,
  0x9D, 0x0A, 0x80, 0x9E, 0x60, 0x86, 0x24, 0x67, 0x76, 0x53, 0x77, 0x78, 0x14, 0x9E, 0xFA, 0x0B,
  0x06, 0x77, 0x20, 0x40, 0xCF, 0xF0, 0xE0, 0x67, 0x60, 0x9F, 0xFC, 0x0C, 0x01, 0x72, 0x01, 0x0C,
  0xFF, 0xE0, 0xD0, 0x27, 0x10, 0xCF, 0xFF, 0x90, 0xD0, 0x16, 0x09, 0xFF, 0xFB, 0x0B, 0x50, 0x3F,
  0xB8, 0x4E, 0x98, 0x79, 0xDF, 0xB0, 0x54, 0x0C, 0xFA, 0x07, 0x60, 0x50, 0xEF, 0x90, 0xD3, 0x03,
  0xFA, 0x05, 0x71, 0x03, 0xFA, 0x05, 0x20, 0x9F, 0x90, 0xA7, 0x30, 0x9F, 0x90, 0xA2, 0x0D, 0xF9,
  0x02, 0x73, 0x01, 0xF9, 0x81, 0xE0, 0x2F, 0x90, 0xC7, 0x50, 0xCF, 0x90, 0x20, 0x4F, 0x90, 0x87,
  0x50, 0x8F, 0x90, 0x50, 0x6F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x70, 0x8F, 0x90, 0x47, 0x50, 0x4F,
  0x90, 0x08, 0xF9, 0x03, 0x75, 0x03, 0xF9, 0x00, 0x8F, 0x90, 0x37, 0x50, 0x3F, 0x90, 0x08, 0xF9,
  0x04, 0x75, 0x04, 0xF9, 0x08, 0x07, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x07, 0x05, 0xF9, 0x08, 0x75,
  0x08, 0xF9, 0x04, 0x02, 0xF9, 0x0C, 0x75, 0x0C, 0xF9, 0x81, 0x20, 0xEF, 0x90, 0x27, 0x30, 0x1F,
  0x90, 0xD2, 0x09, 0xF9, 0x0A, 0x73, 0x09, 0xF9, 0x09, 0x20, 0x4F, 0xA0, 0x57, 0x10, 0x4F, 0xA0,
  0x33, 0x0C, 0xFA, 0x07, 0x60, 0x50, 0xEF, 0x90, 0xC4, 0x04, 0xFB, 0x84, 0xE9, 0x77, 0x9D, 0xFB,
  0x04, 0x50, 0xAF, 0xFF, 0xB0, 0xA7, 0x0D, 0xFF, 0xF9, 0x0D, 0x01, 0x70, 0x10, 0xDF, 0xFE, 0x0D,
  0x02, 0x72, 0x01, 0x0B, 0xFF, 0xC0, 0xB0, 0x17, 0x50, 0x60, 0xDF, 0xF0, 0xE0, 0x67, 0x72, 0x05,
  0x0A, 0xFB, 0x0B, 0x06, 0x77, 0x78, 0x62, 0x56, 0x77, 0x65, 0x37, 0x50,
  // "ô" (U+00F4)
  0x74, 0x02, 0x80, 0x47, 0x06, 0x77, 0x71, 0x0C, 0xFA, 0x04, 0x77, 0x60, 0x7F, 0xB0, 0xD7, 0x75,
  0x03, 0xFD, 0x09, 0x77, 0x30, 0x10, 0xDF, 0xE0, 0x57, 0x72, 0x0A, 0xE0, 0xA0, 0x5E, 0x0E, 0x02,
  0x77, 0x07, 0xE0, 0xA2, 0x05, 0xE0, 0xD0, 0x17, 0x50, 0x4E, 0x09, 0x40, 0x40, 0xED, 0x0B, 0x74,
  0x03, 0x0E, 0xD0, 0x76, 0x03, 0x0D, 0xD0, 0x87, 0x30, 0xCC, 0x0E, 0x04, 0x71, 0x01, 0x0B, 0xD0,
  0x28, 0x09, 0xD4, 0x08, 0x62, 0x46, 0x77, 0x65, 0x37, 0x77, 0x81, 0x49, 0xEF, 0xA0, 0xB0, 0x67,
  0x72, 0x04, 0x0C, 0xFF, 0x0E, 0x06, 0x76, 0x09, 0xFF, 0xC0, 0xC0, 0x17, 0x20, 0x10, 0xCF, 0xFE,
  0x0D, 0x02, 0x71, 0x0C, 0xFF, 0xF9, 0x0D, 0x01, 0x60, 0x9F, 0xFF, 0xB0, 0xB5, 0x03, 0xFB, 0x84,
  0xE9, 0x87, 0x9D, 0xFB, 0x05, 0x40, 0xCF, 0xA0, 0x76, 0x05, 0x0E, 0xF9, 0x0D, 0x30, 0x3F, 0xA0,
  0x57, 0x10, 0x3F, 0xA0, 0x52, 0x09, 0xF9, 0x0A, 0x73, 0x09, 0xF9, 0x0A, 0x20, 0xDF, 0x90, 0x27,
  0x30, 0x1F, 0x98, 0x1E, 0x02, 0xF9, 0x0C, 0x75, 0x0C, 0xF9, 0x02, 0x04, 0xF9, 0x08, 0x75, 0x08,
  0xF9, 0x05, 0x06, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x07, 0x08, 0xF9, 0x04, 0x75, 0x04, 0xF9, 0x00,
  0x8F, 0x90, 0x37, 0x50, 0x3F, 0x90, 0x08, 0xF9, 0x03, 0x75, 0x03, 0xF9, 0x00, 0x8F, 0x90, 0x47,
  0x50, 0x4F, 0x90, 0x80, 0x7F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x70, 0x5F, 0x90, 0x87, 0x50, 0x8F,
  0x90, 0x40, 0x2F, 0x90, 0xC7, 0x50, 0xCF, 0x98, 0x12, 0x0E, 0xF9, 0x02, 0x73, 0x01, 0xF9, 0x0D,
  0x20, 0x9F, 0x90, 0xA7, 0x30, 0x9F, 0x90, 0x92, 0x04, 0xFA, 0x05, 0x71, 0x04, 0xFA, 0x03, 0x30,
  0xCF, 0xA0, 0x76, 0x05, 0x0E, 0xF9, 0x0C, 0x40, 0x4F, 0xB8, 0x4E, 0x97, 0x79, 0xDF, 0xB0, 0x45,
  0x0A, 0xFF, 0xFB, 0x0A, 0x70, 0xDF, 0xFF, 0x90, 0xD0, 0x17, 0x01, 0x0D, 0xFF, 0xE0, 0xD0, 0x27,
  0x20, 0x10, 0xBF, 0xFC, 0x0B, 0x01, 0x75, 0x06, 0x0D, 0xFF, 0x0E, 0x06, 0x77, 0x20, 0x50, 0xAF,
  0xB0, 0xB0, 0x67, 0x77, 0x86, 0x25, 0x67, 0x76, 0x53, 0x75,
  // "õ" (U+00F5)
  0x71, 0x85, 0x4B, 0xEE, 0xD9, 0x37, 0x01, 0xC0, 0x57, 0x40, 0x9F, 0x0C, 0x04, 0x50, 0x6C, 0x03,
  0x73, 0x06, 0xFB, 0x84, 0xC6, 0x20, 0x3E, 0xC0, 0x17, 0x30, 0xEF, 0xFD, 0x0D, 0x73, 0x06, 0xFF,
  0xE0, 0x87, 0x30, 0xCF, 0xFE, 0x01, 0x73, 0xC8, 0x4D, 0x30, 0x27, 0xDF, 0xB0, 0x67, 0x30, 0x3C,
  0x05, 0x50, 0x50, 0xCF, 0x08, 0x74, 0x05, 0xC7, 0x18, 0x54, 0x9D, 0xEE, 0xA4, 0x80, 0x9E, 0x00,
  0x86, 0x24, 0x67, 0x76, 0x53, 0x77, 0x78, 0x14, 0x9E, 0xFA, 0x0B, 0x06, 0x77, 0x20, 0x40, 0xCF,
  0xF0, 0xE0, 0x67, 0x60, 0x9F, 0xFC, 0x0C, 0x01, 0x72, 0x01, 0x0C, 0xFF, 0xE0, 0xD0, 0x27, 0x10,
  0xCF, 0xFF, 0x90, 0xD0, 0x16, 0x09, 0xFF, 0xFB, 0x0B, 0x50, 0x3F, 0xB8, 0x4E, 0x98, 0x79, 0xDF,
  0xB0, 0x54, 0x0C, 0xFA, 0x07, 0x60, 0x50, 0xEF, 0x90, 0xD3, 0x03, 0xFA, 0x05, 0x71, 0x03, 0xFA,
  0x05, 0x20, 0x9F, 0x90, 0xA7, 0x30, 0x9F, 0x90, 0xA2, 0x0D, 0xF9, 0x02, 0x73, 0x01, 0xF9, 0x81,
  0xE0, 0x2F, 0x90, 0xC7, 0x50, 0xCF, 0x90, 0x20, 0x4F, 0x90, 0x87, 0x50, 0x8F, 0x90, 0x50, 0x6F,
  0x90, 0x67, 0x50, 0x6F, 0x90, 0x70, 0x8F, 0x90, 0x47, 0x50, 0x4F, 0x90, 0x08, 0xF9, 0x03, 0x75,
  0x03, 0xF9, 0x00, 0x8F, 0x90, 0x37, 0x50, 0x3F, 0x90, 0x08, 0xF9, 0x04, 0x75, 0x04, 0xF9, 0x08,
  0x07, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x07, 0x05, 0xF9, 0x08, 0x75, 0x08, 0xF9, 0x04, 0x02, 0xF9,
  0x0C, 0x75, 0x0C, 0xF9, 0x81, 0x20, 0xEF, 0x90, 0x27, 0x30, 0x1F, 0x90, 0xD2, 0x09, 0xF9, 0x0A,
  0x73, 0x09, 0xF9, 0x09, 0x20, 0x4F, 0xA0, 0x57, 0x10, 0x4F, 0xA0, 0x33, 0x0C, 0xFA, 0x07, 0x60,
  0x50, 0xEF, 0x90, 0xC4, 0x04, 0xFB, 0x84, 0xE9, 0x77, 0x9D, 0xFB, 0x04, 0x50, 0xAF, 0xFF, 0xB0,
  0xA7, 0x0D, 0xFF, 0xF9, 0x0D, 0x01, 0x70, 0x10, 0xDF, 0xFE, 0x0D, 0x02, 0x72, 0x01, 0x0B, 0xFF,
  0xC0, 0xB0, 0x17, 0x50, 0x60, 0xDF, 0xF0, 0xE0, 0x67, 0x72, 0x05, 0x0A, 0xFB, 0x0B, 0x06, 0x77,
  0x78, 0x62, 0x56, 0x77, 0x65, 0x37, 0x50,
  // "ö" (U+00F6)
  0x68, 0x43, 0xBE, 0xFC, 0x57, 0x18, 0x43, 0xBE, 0xFC, 0x67, 0x40, 0x4E, 0x08, 0x60, 0x4E, 0x09,
  0x73, 0x0D, 0xF0, 0x25, 0x0D, 0xF0, 0x27, 0x10, 0x1F, 0x90, 0x64, 0x01, 0xF9, 0x06, 0x71, 0x02,
  0xF9, 0x07, 0x40, 0x2F, 0x90, 0x77, 0x10, 0x1F, 0x90, 0x54, 0x01, 0xF9, 0x06, 0x72, 0x0C, 0xF0,
  0x15, 0x0C, 0xF0, 0x27, 0x20, 0x4E, 0x07, 0x60, 0x3E, 0x08, 0x74, 0x84, 0x3B, 0xEF, 0xC5, 0x71,
  0x84, 0x3B, 0xEF, 0xC5, 0x80, 0x9D, 0x60, 0x86, 0x24, 0x67, 0x76, 0x53, 0x77, 0x78, 0x14, 0x9E,
  0xFA, 0x0B, 0x06, 0x77, 0x20, 0x40, 0xCF, 0xF0, 0xE0, 0x67, 0x60, 0x9F, 0xFC, 0x0C, 0x01, 0x72,
  0x01, 0x0C, 0xFF, 0xE0, 0xD0, 0x27, 0x10, 0xCF, 0xFF, 0x90, 0xD0, 0x16, 0x09, 0xFF, 0xFB, 0x0B,
  0x50, 0x3F, 0xB8, 0x4E, 0x98, 0x79, 0xDF, 0xB0, 0x54, 0x0C, 0xFA, 0x07, 0x60, 0x50, 0xEF, 0x90,
  0xD3, 0x03, 0xFA, 0x05, 0x71, 0x03, 0xFA, 0x05, 0x20, 0x9F, 0x90, 0xA7, 0x30, 0x9F, 0x90, 0xA2,
  0x0D, 0xF9, 0x02, 0x73, 0x01, 0xF9, 0x81, 0xE0, 0x2F, 0x90, 0xC7, 0x50, 0xCF, 0x90, 0x20, 0x4F,
  0x90, 0x87, 0x50, 0x8F, 0x90, 0x50, 0x6F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x70, 0x8F, 0x90, 0x47,
  0x50, 0x4F, 0x90, 0x08, 0xF9, 0x03, 0x75, 0x03, 0xF9, 0x00, 0x8F, 0x90, 0x37, 0x50, 0x3F, 0x90,
  0x08, 0xF9, 0x04, 0x75, 0x04, 0xF9, 0x08, 0x07, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x07, 0x05, 0xF9,
  0x08, 0x75, 0x08, 0xF9, 0x04, 0x02, 0xF9, 0x0C, 0x75, 0x0C, 0xF9, 0x81, 0x20, 0xEF, 0x90, 0x27,
  0x30, 0x1F, 0x90, 0xD2, 0x09, 0xF9, 0x0A, 0x73, 0x09, 0xF9, 0x09, 0x20, 0x4F, 0xA0, 0x57, 0x10,
  0x4F, 0xA0, 0x33, 0x0C, 0xFA, 0x07, 0x60, 0x50, 0xEF, 0x90, 0xC4, 0x04, 0xFB, 0x84, 0xE9, 0x77,
  0x9D, 0xFB, 0x04, 0x50, 0xAF, 0xFF, 0xB0, 0xA7, 0x0D, 0xFF, 0xF9, 0x0D, 0x01, 0x70, 0x10, 0xDF,
  0xFE, 0x0D, 0x02, 0x72, 0x01, 0x0B, 0xFF, 0xC0, 0xB0, 0x17, 0x50, 0x60, 0xDF, 0xF0, 0xE0, 0x67,
  0x72, 0x05, 0x0A, 0xFB, 0x0B, 0x06, 0x77, 0x78, 0x62, 0x56, 0x77, 0x65, 0x37, 0x50,
  // "÷" (U+00F7)
  0x74, 0x84, 0x3B, 0xEE, 0xB4, 0x77, 0x70, 0x3E, 0x04, 0x77, 0x60, 0xBE, 0x0C, 0x77, 0x60, 0xEF,
  0x77, 0x6F, 0x97, 0x76, 0x0E, 0xF7, 0x76, 0x0A, 0xE0, 0xB7, 0x76, 0x03, 0xE0, 0x37, 0x77, 0x84,
  0x3B, 0xEE, 0xB3, 0x80, 0x9B, 0x30, 0x0C, 0xFF, 0xFD, 0x00, 0xCF, 0xFF, 0xD0, 0x0C, 0xFF, 0xFD,
  0x00, 0xCF, 0xFF, 0xD0, 0x0C, 0xFF, 0xFD, 0x00, 0xCF, 0xFF, 0xD0, 0xC8, 0x09, 0xB3, 0x08, 0x43,
  0xBE, 0xEB, 0x47, 0x77, 0x03, 0xE0, 0x47, 0x76, 0x0B, 0xE0, 0xC7, 0x76, 0x0E, 0xF7, 0x76, 0xF9,
  0x77, 0x60, 0xEF, 0x77, 0x60, 0xAE, 0x0B, 0x77, 0x60, 0x3E, 0x03, 0x77, 0x78, 0x43, 0xBE, 0xEB,
  0x37, 0x40,
  // "ø" (U+00F8)
  0x77, 0x74, 0x06, 0x77, 0x48, 0x62, 0x46, 0x77, 0x65, 0x34, 0x82, 0x7F, 0xC2, 0x76, 0x81, 0x49,
  0xEF, 0x98, 0x2E, 0xA5, 0x3C, 0x06, 0x73, 0x04, 0x0C, 0xFF, 0xE0, 0x67, 0x10, 0x9F, 0xFF, 0x0D,
  0x70, 0x10, 0xCF, 0xFF, 0x90, 0x37, 0x0C, 0xFF, 0xF9, 0x0D, 0x70, 0x9F, 0xFF, 0xB0, 0x85, 0x03,
  0xFB, 0x84, 0xE9, 0x87, 0x9D, 0xFB, 0x04, 0x40, 0xCF, 0xA0, 0x75, 0x01, 0x0E, 0xFA, 0x0B, 0x30,
  0x3F, 0xA0, 0x56, 0x0A, 0xFC, 0x02, 0x20, 0x9F, 0x90, 0xA6, 0x06, 0xFD, 0x09, 0x20, 0xDF, 0x90,
  0x25, 0x02, 0x0E, 0xFD, 0x81, 0xD0, 0x2F, 0x90, 0xC6, 0x0C, 0xFF, 0x02, 0x04, 0xF9, 0x08, 0x50,
  0x7D, 0x0D, 0x09, 0xF9, 0x05, 0x07, 0xF9, 0x06, 0x40, 0x3E, 0x03, 0x05, 0xF9, 0x06, 0x08, 0xF9,
  0x04, 0x40, 0xDD, 0x81, 0x80, 0x4F, 0x90, 0x08, 0xF9, 0x03, 0x30, 0x9D, 0x0C, 0x20, 0x3F, 0x90,
  0x80, 0x9F, 0x90, 0x32, 0x05, 0xD0, 0xE0, 0x22, 0x03, 0xF9, 0x00, 0x8F, 0x98, 0x24, 0x01, 0xED,
  0x06, 0x30, 0x4F, 0x90, 0x80, 0x7F, 0x98, 0x16, 0x0B, 0xD0, 0xA4, 0x06, 0xF9, 0x07, 0x05, 0xF9,
  0x09, 0x07, 0xD0, 0xD0, 0x14, 0x08, 0xF9, 0x04, 0x02, 0xF9, 0x0D, 0xE0, 0x45, 0x0C, 0xF9, 0x81,
  0x20, 0xEF, 0xE0, 0x85, 0x01, 0xF9, 0x0E, 0x20, 0xAF, 0xD0, 0xC6, 0x09, 0xF9, 0x09, 0x20, 0x4F,
  0xC0, 0xE0, 0x25, 0x04, 0xFA, 0x04, 0x30, 0xCF, 0xB0, 0x65, 0x05, 0x0E, 0xF9, 0x0D, 0x40, 0x4F,
  0xB8, 0x4E, 0xA7, 0x79, 0xDF, 0xB0, 0x45, 0x09, 0xFF, 0xFB, 0x0A, 0x70, 0xCF, 0xFF, 0x90, 0xD0,
  0x17, 0x0B, 0xFF, 0xF0, 0xD0, 0x27, 0x06, 0xFF, 0xF0, 0xB0, 0x17, 0x02, 0x0E, 0xFF, 0xD0, 0xE0,
  0x67, 0x20, 0x20, 0xDC, 0x82, 0x95, 0xAE, 0xFA, 0x0B, 0x06, 0x76, 0x08, 0xA0, 0xD4, 0x86, 0x25,
  0x67, 0x76, 0x53, 0x77, 0x38, 0x13, 0xD3, 0x77, 0x73,
  // "ù" (U+00F9)
  0x50, 0x68, 0x04, 0x70, 0x67, 0x76, 0x06, 0xFA, 0x03, 0x77, 0x60, 0x7F, 0x90, 0xC7, 0x77, 0x07,
  0xF9, 0x07, 0x77, 0x70, 0x6F, 0x90, 0x37, 0x77, 0x05, 0xF0, 0xD7, 0x77, 0x10, 0x40, 0xEE, 0x08,
  0x77, 0x71, 0x03, 0x0E, 0xE0, 0x47, 0x77, 0x10, 0x20, 0xDD, 0x0E, 0x01, 0x77, 0x71, 0x01, 0x0B,
  0xD0, 0x88, 0x09, 0xF5, 0x0F, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90,
  0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7,
  0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F,
  0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90,
  0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF,
  0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x40, 0x1F, 0x90, 0xAF, 0x90, 0xA7, 0x40, 0x1F, 0x90,
  0xAF, 0x90, 0xA7, 0x40, 0x3F, 0x90, 0xAF, 0x90, 0xB7, 0x40, 0x6F, 0x90, 0xAF, 0x90, 0xC7, 0x40,
  0x8F, 0x90, 0xA0, 0xEF, 0x97, 0x40, 0xDF, 0x90, 0xA0, 0xDF, 0x90, 0x47, 0x20, 0x4F, 0xA0, 0xA0,
  0xCF, 0x90, 0xB7, 0x10, 0x10, 0xDF, 0xA0, 0xA0, 0x9F, 0xA0, 0x86, 0x03, 0x0C, 0xFB, 0x0A, 0x05,
  0xFB, 0x84, 0xD9, 0x77, 0x8C, 0xFD, 0x81, 0xA0, 0xEF, 0xFF, 0xE8, 0x1A, 0x07, 0xFF, 0xD0, 0xEF,
  0x0A, 0x20, 0xCF, 0xFB, 0x0A, 0x02, 0xF0, 0xA2, 0x02, 0x0D, 0xFF, 0x90, 0xB2, 0x0C, 0xE0, 0xA3,
  0x01, 0x0B, 0xFD, 0x0E, 0x07, 0x30, 0x6E, 0x0A, 0x50, 0x40, 0xBF, 0x98, 0x1D, 0x81, 0x40, 0x1E,
  0x0A, 0x71, 0x85, 0x45, 0x77, 0x64, 0x17, 0x71,
  // "ú" (U+00FA)
  0x77, 0x20, 0x68, 0x04, 0x70, 0x67, 0x75, 0x04, 0xFA, 0x05, 0x77, 0x50, 0xDF, 0x90, 0x67, 0x75,
  0x08, 0xF9, 0x06, 0x77, 0x50, 0x3F, 0x90, 0x57, 0x76, 0x0D, 0xF0, 0x47, 0x76, 0x09, 0xE0, 0xE0,
  0x47, 0x76, 0x05, 0xE0, 0xE0, 0x37, 0x76, 0x02, 0x0E, 0xD0, 0xC0, 0x17, 0x77, 0x09, 0xD0, 0xA8,
  0x0A, 0x81, 0x0F, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F,
  0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90,
  0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF,
  0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90,
  0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7,
  0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x40, 0x1F, 0x90, 0xAF, 0x90, 0xA7, 0x40, 0x1F, 0x90, 0xAF, 0x90,
  0xA7, 0x40, 0x3F, 0x90, 0xAF, 0x90, 0xB7, 0x40, 0x6F, 0x90, 0xAF, 0x90, 0xC7, 0x40, 0x8F, 0x90,
  0xA0, 0xEF, 0x97, 0x40, 0xDF, 0x90, 0xA0, 0xDF, 0x90, 0x47, 0x20, 0x4F, 0xA0, 0xA0, 0xCF, 0x90,
  0xB7, 0x10, 0x10, 0xDF, 0xA0, 0xA0, 0x9F, 0xA0, 0x86, 0x03, 0x0C, 0xFB, 0x0A, 0x05, 0xFB, 0x84,
  0xD9, 0x77, 0x8C, 0xFD, 0x81, 0xA0, 0xEF, 0xFF, 0xE8, 0x1A, 0x07, 0xFF, 0xD0, 0xEF, 0x0A, 0x20,
  0xCF, 0xFB, 0x0A, 0x02, 0xF0, 0xA2, 0x02, 0x0D, 0xFF, 0x90, 0xB2, 0x0C, 0xE0, 0xA3, 0x01, 0x0B,
  0xFD, 0x0E, 0x07, 0x30, 0x6E, 0x0A, 0x50, 0x40, 0xBF, 0x98, 0x1D, 0x81, 0x40, 0x1E, 0x0A, 0x71,
  0x85, 0x45, 0x77, 0x64, 0x17, 0x71,
  // "û" (U+00FB)
  0x73, 0x02, 0x80, 0x47, 0x06, 0x77, 0x60, 0xCF, 0xA0, 0x47, 0x74, 0x07, 0xFB, 0x0D, 0x77, 0x30,
  0x3F, 0xD0, 0x97, 0x71, 0x01, 0x0D, 0xFE, 0x05, 0x77, 0x0A, 0xE0, 0xA0, 0x5E, 0x0E, 0x02, 0x75,
  0x07, 0xE0, 0xA2, 0x05, 0xE0, 0xD0, 0x17, 0x30, 0x4E, 0x09, 0x40, 0x40, 0xED, 0x0B, 0x72, 0x03,
  0x0E, 0xD0, 0x76, 0x03, 0x0D, 0xD0, 0x87, 0x10, 0xCC, 0x0E, 0x04, 0x71, 0x01, 0x0B, 0xD0, 0x28,
  0x09, 0xE7, 0x0F, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F,
  0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90,
  0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF,
  0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90,
  0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7,
  0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x40, 0x1F, 0x90, 0xAF, 0x90, 0xA7, 0x40, 0x1F, 0x90, 0xAF, 0x90,
  0xA7, 0x40, 0x3F, 0x90, 0xAF, 0x90, 0xB7, 0x40, 0x6F, 0x90, 0xAF, 0x90, 0xC7, 0x40, 0x8F, 0x90,
  0xA0, 0xEF, 0x97, 0x40, 0xDF, 0x90, 0xA0, 0xDF, 0x90, 0x47, 0x20, 0x4F, 0xA0, 0xA0, 0xCF, 0x90,
  0xB7, 0x10, 0x10, 0xDF, 0xA0, 0xA0, 0x9F, 0xA0, 0x86, 0x03, 0x0C, 0xFB, 0x0A, 0x05, 0xFB, 0x84,
  0xD9, 0x77, 0x8C, 0xFD, 0x81, 0xA0, 0xEF, 0xFF, 0xE8, 0x1A, 0x07, 0xFF, 0xD0, 0xEF, 0x0A, 0x20,
  0xCF, 0xFB, 0x0A, 0x02, 0xF0, 0xA2, 0x02, 0x0D, 0xFF, 0x90, 0xB2, 0x0C, 0xE0, 0xA3, 0x01, 0x0B,
  0xFD, 0x0E, 0x07, 0x30, 0x6E, 0x0A, 0x50, 0x40, 0xBF, 0x98, 0x1D, 0x81, 0x40, 0x1E, 0x0A, 0x71,
  0x85, 0x45, 0x77, 0x64, 0x17, 0x71,
  // "ü" (U+00FC)
  0x58, 0x43, 0xBE, 0xFC, 0x57, 0x18, 0x43, 0xBE, 0xFC, 0x67, 0x20, 0x4E, 0x08, 0x60, 0x4E, 0x09,
  0x71, 0x0D, 0xF0, 0x25, 0x0D, 0xF0, 0x26, 0x01, 0xF9, 0x06, 0x40, 0x1F, 0x90, 0x66, 0x02, 0xF9,
  0x07, 0x40, 0x2F, 0x90, 0x76, 0x01, 0xF9, 0x05, 0x40, 0x1F, 0x90, 0x67, 0x0C, 0xF0, 0x15, 0x0C,
  0xF0, 0x27, 0x04, 0xE0, 0x76, 0x03, 0xE0, 0x87, 0x28, 0x43, 0xBE, 0xFC, 0x57, 0x18, 0x43, 0xBE,
  0xFC, 0x58, 0x09, 0xF1, 0x0F, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90,
  0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7,
  0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F,
  0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90,
  0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF,
  0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x40, 0x1F, 0x90, 0xAF, 0x90, 0xA7, 0x40, 0x1F, 0x90,
  0xAF, 0x90, 0xA7, 0x40, 0x3F, 0x90, 0xAF, 0x90, 0xB7, 0x40, 0x6F, 0x90, 0xAF, 0x90, 0xC7, 0x40,
  0x8F, 0x90, 0xA0, 0xEF, 0x97, 0x40, 0xDF, 0x90, 0xA0, 0xDF, 0x90, 0x47, 0x20, 0x4F, 0xA0, 0xA0,
  0xCF, 0x90, 0xB7, 0x10, 0x10, 0xDF, 0xA0, 0xA0, 0x9F, 0xA0, 0x86, 0x03, 0x0C, 0xFB, 0x0A, 0x05,
  0xFB, 0x84, 0xD9, 0x77, 0x8C, 0xFD, 0x81, 0xA0, 0xEF, 0xFF, 0xE8, 0x1A, 0x07, 0xFF, 0xD0, 0xEF,
  0x0A, 0x20, 0xCF, 0xFB, 0x0A, 0x02, 0xF0, 0xA2, 0x02, 0x0D, 0xFF, 0x90, 0xB2, 0x0C, 0xE0, 0xA3,
  0x01, 0x0B, 0xFD, 0x0E, 0x07, 0x30, 0x6E, 0x0A, 0x50, 0x40, 0xBF, 0x98, 0x1D, 0x81, 0x40, 0x1E,
  0x0A, 0x71, 0x85, 0x45, 0x77, 0x64, 0x17, 0x71,
  // "ý" (U+00FD)
  0x77, 0x40, 0x68, 0x04, 0x70, 0x67, 0x77, 0x20, 0x4F, 0xA0, 0x57, 0x77, 0x20, 0xDF, 0x90, 0x67,
  0x77, 0x20, 0x8F, 0x90, 0x67, 0x77, 0x20, 0x3F, 0x90, 0x57, 0x77, 0x30, 0xDF, 0x04, 0x77, 0x73,
  0x09, 0xE0, 0xE0, 0x47, 0x77, 0x30, 0x5E, 0x0E, 0x03, 0x77, 0x73, 0x02, 0x0E, 0xD0, 0xC0, 0x17,
  0x77, 0x40, 0x9D, 0x0A, 0x80, 0xAA, 0x30, 0x09, 0xF9, 0x0D, 0x77, 0x0B, 0xF9, 0x09, 0x03, 0xFA,
  0x03, 0x76, 0xFA, 0x81, 0x30, 0xCF, 0x90, 0x87, 0x50, 0x4F, 0x90, 0xD2, 0x05, 0xF9, 0x0D, 0x75,
  0x09, 0xF9, 0x07, 0x30, 0xEF, 0x90, 0x37, 0x40, 0xEF, 0x90, 0x13, 0x08, 0xF9, 0x08, 0x73, 0x03,
  0xF9, 0x0B, 0x40, 0x2F, 0x90, 0xD7, 0x30, 0x8F, 0x90, 0x55, 0x0B, 0xF9, 0x03, 0x72, 0x0C, 0xF0,
  0xE6, 0x05, 0xF9, 0x09, 0x71, 0x02, 0xF9, 0x09, 0x70, 0xEF, 0x0E, 0x71, 0x06, 0xF9, 0x03, 0x70,
  0x8F, 0x90, 0x47, 0x0B, 0xF0, 0xD7, 0x10, 0x2F, 0x90, 0x97, 0xF9, 0x07, 0x72, 0x0B, 0xF0, 0xE6,
  0x05, 0xF9, 0x01, 0x72, 0x05, 0xF9, 0x04, 0x50, 0x9F, 0x0B, 0x74, 0x0E, 0xF0, 0x95, 0x0E, 0xF0,
  0x57, 0x40, 0x8F, 0x0E, 0x40, 0x3F, 0x0E, 0x75, 0x02, 0xF9, 0x04, 0x30, 0x8F, 0x09, 0x76, 0x0B,
  0xF0, 0xA3, 0x0D, 0xF0, 0x37, 0x60, 0x4F, 0x0E, 0x20, 0x2F, 0x0D, 0x77, 0x10, 0xDF, 0x81, 0x40,
  0x6F, 0x07, 0x77, 0x10, 0x7F, 0x81, 0x80, 0xBF, 0x01, 0x77, 0x10, 0x1F, 0x81, 0xC0, 0xEE, 0x0B,
  0x77, 0x30, 0xAF, 0x03, 0xF0, 0x57, 0x73, 0x04, 0xF0, 0x9E, 0x0E, 0x77, 0x50, 0xDF, 0xE0, 0x97,
  0x75, 0x07, 0xFE, 0x03, 0x77, 0x50, 0x1F, 0xD0, 0xD7, 0x77, 0x0A, 0xFC, 0x07, 0x77, 0x70, 0x4F,
  0xC0, 0x17, 0x77, 0x10, 0xDF, 0xA0, 0xB7, 0x77, 0x20, 0x7F, 0xA0, 0x57, 0x77, 0x20, 0x1F, 0x90,
  0xE7, 0x77, 0x30, 0x1F, 0x90, 0x97, 0x77, 0x30, 0x7F, 0x90, 0x37, 0x77, 0x30, 0xDF, 0x0C, 0x77,
  0x73, 0x06, 0xF9, 0x06, 0x77, 0x72, 0x01, 0x0E, 0xF0, 0xE7, 0x77, 0x20, 0x10, 0xCF, 0x90, 0x67,
  0x72, 0x01, 0x02, 0x38, 0x12, 0x7E, 0xF9, 0x0D, 0x77, 0x30, 0x7F, 0xF9, 0x04, 0x77, 0x30, 0x7F,
  0xF0, 0x97, 0x74, 0x07, 0xFE, 0x0C, 0x77, 0x50, 0x7F, 0xD0, 0xC0, 0x17, 0x75, 0x07, 0xFC, 0x0A,
  0x77, 0x70, 0x7F, 0xA0, 0xC0, 0x57, 0x77, 0x18, 0x90, 0x4B, 0xDE, 0xFE, 0xDC, 0x84, 0x77, 0x71,
  // "þ" (U+00FE)
  0x0A, 0xF0, 0xC7, 0x77, 0x10, 0xAF, 0x0C, 0x77, 0x71, 0x0A, 0xF0, 0xC7, 0x77, 0x10, 0xAF, 0x0C,
  0x77, 0x71, 0x0A, 0xF0, 0xC7, 0x77, 0x10, 0xAF, 0x0C, 0x77, 0x71, 0x0A, 0xF0, 0xC7, 0x77, 0x10,
  0xAF, 0x0C, 0x77, 0x71, 0x0A, 0xF0, 0xC7, 0x77, 0x10, 0xAF, 0x0C, 0x77, 0x71, 0x0A, 0xF0, 0xC7,
  0x77, 0x10, 0xAF, 0x0C, 0x77, 0x71, 0x0A, 0xF0, 0xC6, 0x85, 0x25, 0x67, 0x65, 0x27, 0x20, 0xAF,
  0x0B, 0x38, 0x11, 0x8D, 0xF0, 0xD0, 0x67, 0x0A, 0xF0, 0xB2, 0x07, 0xFD, 0x0D, 0x03, 0x50, 0xAF,
  0x81, 0xA0, 0xBF, 0xF0, 0xE0, 0x44, 0x0A, 0xF0, 0x80, 0xAF, 0xFA, 0x0E, 0x02, 0x30, 0xAF, 0x0E,
  0xFF, 0xC0, 0xC3, 0x0A, 0xFF, 0xFE, 0x06, 0x20, 0xAF, 0xD8, 0x3B, 0x87, 0x8C, 0xFB, 0x0D, 0x20,
  0xAF, 0xB0, 0xB0, 0x25, 0x04, 0x0E, 0xFA, 0x81, 0x40, 0xAF, 0xA0, 0xB7, 0x10, 0x3F, 0xA8, 0x18,
  0x0A, 0xF9, 0x0E, 0x01, 0x72, 0x08, 0xF9, 0x81, 0xD0, 0xAF, 0x90, 0x87, 0x30, 0x2F, 0xA0, 0x10,
  0xAF, 0x90, 0x37, 0x40, 0xDF, 0x90, 0x30, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0x50, 0xAF, 0x0D, 0x75,
  0x08, 0xF9, 0x07, 0x0A, 0xF0, 0xD7, 0x50, 0x7F, 0x90, 0x80, 0xAF, 0x0C, 0x75, 0x06, 0xF9, 0x08,
  0x0A, 0xF0, 0xD7, 0x50, 0x6F, 0x90, 0x80, 0xAF, 0x0D, 0x75, 0x07, 0xF9, 0x07, 0x0A, 0xF0, 0xE7,
  0x50, 0x8F, 0x90, 0x60, 0xAF, 0x90, 0x27, 0x40, 0xAF, 0x90, 0x50, 0xAF, 0x90, 0x57, 0x40, 0xDF,
  0x90, 0x30, 0xAF, 0x90, 0xA7, 0x30, 0x1F, 0xA1, 0x0A, 0xFA, 0x02, 0x72, 0x08, 0xF9, 0x81, 0xC0,
  0xAF, 0xA0, 0xC7, 0x10, 0x20, 0xEF, 0x98, 0x18, 0x0A, 0xFB, 0x0C, 0x02, 0x50, 0x30, 0xDF, 0xA8,
  0x12, 0x0A, 0xFD, 0x83, 0xB8, 0x78, 0xCF, 0xB0, 0xC2, 0x0A, 0xFF, 0xFE, 0x03, 0x20, 0xAF, 0xFF,
  0xD0, 0x93, 0x0A, 0xF0, 0xB0, 0xEF, 0xFA, 0x0D, 0x01, 0x30, 0xAF, 0x81, 0x82, 0xDF, 0xF0, 0xD0,
  0x14, 0x0A, 0xF8, 0x2A, 0x01, 0xAF, 0xD0, 0xA0, 0x15, 0x0A, 0xF0, 0xB3, 0x81, 0x3A, 0xEF, 0x0B,
  0x04, 0x70, 0xAF, 0x0C, 0x68, 0x53, 0x57, 0x76, 0x41, 0x72, 0x0A, 0xF0, 0xC7, 0x77, 0x10, 0xAF,
  0x0C, 0x77, 0x71, 0x0A, 0xF0, 0xC7, 0x77, 0x10, 0xAF, 0x0C, 0x77, 0x71, 0x0A, 0xF0, 0xC7, 0x77,
  0x10, 0xAF, 0x0C, 0x77, 0x71, 0x0A, 0xF0, 0xC7, 0x77, 0x10, 0xAF, 0x0C, 0x77, 0x71, 0x0A, 0xF0,
  0xC7, 0x77, 0x10, 0xAF, 0x0C, 0x77, 0x71, 0x0A, 0xF0, 0xC7, 0x77, 0x10, 0xAF, 0x0C, 0x77, 0x71,
  0x0A, 0xF0, 0xC7, 0x77, 0x10,
  // "ÿ" (U+00FF)
  0x78, 0x43, 0xBE, 0xFC, 0x57, 0x18, 0x43, 0xBE, 0xFC, 0x67, 0x60, 0x4E, 0x08, 0x60, 0x4E, 0x09,
  0x75, 0x0D, 0xF0, 0x25, 0x0D, 0xF0, 0x27, 0x30, 0x1F, 0x90, 0x64, 0x01, 0xF9, 0x06, 0x73, 0x02,
  0xF9, 0x07, 0x40, 0x2F, 0x90, 0x77, 0x30, 0x1F, 0x90, 0x54, 0x01, 0xF9, 0x06, 0x74, 0x0C, 0xF0,
  0x15, 0x0C, 0xF0, 0x27, 0x40, 0x4E, 0x07, 0x60, 0x3E, 0x08, 0x76, 0x84, 0x3B, 0xEF, 0xC5, 0x71,
  0x84, 0x3B, 0xEF, 0xC5, 0x80, 0xA9, 0x30, 0x09, 0xF9, 0x0D, 0x77, 0x0B, 0xF9, 0x09, 0x03, 0xFA,
  0x03, 0x76, 0xFA, 0x81, 0x30, 0xCF, 0x90, 0x87, 0x50, 0x4F, 0x90, 0xD2, 0x05, 0xF9, 0x0D, 0x75,
  0x09, 0xF9, 0x07, 0x30, 0xEF, 0x90, 0x37, 0x40, 0xEF, 0x90, 0x13, 0x08, 0xF9, 0x08, 0x73, 0x03,
  0xF9, 0x0B, 0x40, 0x2F, 0x90, 0xD7, 0x30, 0x8F, 0x90, 0x55, 0x0B, 0xF9, 0x03, 0x72, 0x0C, 0xF0,
  0xE6, 0x05, 0xF9, 0x09, 0x71, 0x02, 0xF9, 0x09, 0x70, 0xEF, 0x0E, 0x71, 0x06, 0xF9, 0x03, 0x70,
  0x8F, 0x90, 0x47, 0x0B, 0xF0, 0xD7, 0x10, 0x2F, 0x90, 0x97, 0xF9, 0x07, 0x72, 0x0B, 0xF0, 0xE6,
  0x05, 0xF9, 0x01, 0x72, 0x05, 0xF9, 0x04, 0x50, 0x9F, 0x0B, 0x74, 0x0E, 0xF0, 0x95, 0x0E, 0xF0,
  0x57, 0x40, 0x8F, 0x0E, 0x40, 0x3F, 0x0E, 0x75, 0x02, 0xF9, 0x04, 0x30, 0x8F, 0x09, 0x76, 0x0B,
  0xF0, 0xA3, 0x0D, 0xF0, 0x37, 0x60, 0x4F, 0x0E, 0x20, 0x2F, 0x0D, 0x77, 0x10, 0xDF, 0x81, 0x40,
  0x6F, 0x07, 0x77, 0x10, 0x7F, 0x81, 0x80, 0xBF, 0x01, 0x77, 0x10, 0x1F, 0x81, 0xC0, 0xEE, 0x0B,
  0x77, 0x30, 0xAF, 0x03, 0xF0, 0x57, 0x73, 0x04, 0xF0, 0x9E, 0x0E, 0x77, 0x50, 0xDF, 0xE0, 0x97,
  0x75, 0x07, 0xFE, 0x03, 0x77, 0x50, 0x1F, 0xD0, 0xD7, 0x77, 0x0A, 0xFC, 0x07, 0x77, 0x70, 0x4F,
  0xC0, 0x17, 0x77, 0x10, 0xDF, 0xA0, 0xB7, 0x77, 0x20, 0x7F, 0xA0, 0x57, 0x77, 0x20, 0x1F, 0x90,
  0xE7, 0x77, 0x30, 0x1F, 0x90, 0x97, 0x77, 0x30, 0x7F, 0x90, 0x37, 0x77, 0x30, 0xDF, 0x0C, 0x77,
  0x73, 0x06, 0xF9, 0x06, 0x77, 0x72, 0x01, 0x0E, 0xF0, 0xE7, 0x77, 0x20, 0x10, 0xCF, 0x90, 0x67,
  0x72, 0x01, 0x02, 0x38, 0x12, 0x7E, 0xF9, 0x0D, 0x77, 0x30, 0x7F, 0xF9, 0x04, 0x77, 0x30, 0x7F,
  0xF0, 0x97, 0x74, 0x07, 0xFE, 0x0C, 0x77, 0x50, 0x7F, 0xD0, 0xC0, 0x17, 0x75, 0x07, 0xFC, 0x0A,
  0x77, 0x70, 0x7F, 0xA0, 0xC0, 0x57, 0x77, 0x18, 0x90, 0x4B, 0xDE, 0xFE, 0xDC, 0x84, 0x77, 0x71,
  // "Ā" (U+0100)
  0x71, 0x01, 0xFF, 0xC0, 0x17, 0x72, 0x01, 0xFF, 0xC0, 0x17, 0x72, 0x01, 0xFF, 0xC0, 0x17, 0x72,
  0x01, 0xFF, 0xC0, 0x17, 0x72, 0x01, 0xFF, 0xC0, 0x17, 0x72, 0x01, 0xFF, 0xC0, 0x18, 0x0B, 0x84,
  0x00, 0xBF, 0xB0, 0xA7, 0x77, 0x3F, 0xC0, 0xE7, 0x77, 0x20, 0x4F, 0xD0, 0x37, 0x77, 0x10, 0x8F,
  0xD0, 0x77, 0x77, 0x10, 0xDF, 0xD0, 0xC7, 0x77, 0x01, 0xFF, 0x01, 0x77, 0x60, 0x6F, 0xF0, 0x57,
  0x76, 0x0A, 0xE0, 0x0B, 0xE0, 0x97, 0x76, 0x0E, 0xE0, 0x08, 0xE0, 0xE7, 0x75, 0x03, 0xF0, 0x04,
  0xF0, 0x37, 0x74, 0x08, 0xF2, 0xF0, 0x77, 0x74, 0x0C, 0xE0, 0xC2, 0x0C, 0xE0, 0xB7, 0x73, 0x01,
  0xF0, 0x82, 0x08, 0xF0, 0x17, 0x72, 0x05, 0xF0, 0x42, 0x04, 0xF0, 0x57, 0x72, 0x0A, 0xF4, 0xF0,
  0x97, 0x72, 0x0E, 0xE0, 0xB4, 0x0C, 0xE0, 0xD7, 0x71, 0x03, 0xF0, 0x74, 0x08, 0xF0, 0x27, 0x70,
  0x7F, 0x03, 0x40, 0x4F, 0x07, 0x77, 0x0C, 0xE0, 0xE6, 0xF0, 0xB7, 0x60, 0x1F, 0x0A, 0x60, 0xCF,
  0x76, 0x05, 0xF0, 0x66, 0x08, 0xF0, 0x47, 0x50, 0x9F, 0x02, 0x60, 0x4F, 0x09, 0x75, 0x0E, 0xE0,
  0xE7, 0x1F, 0x0D, 0x74, 0x03, 0xF0, 0x97, 0x10, 0xBF, 0x02, 0x73, 0x07, 0xF9, 0x80, 0x4E, 0xF9,
  0x07, 0x73, 0x0B, 0xFF, 0xFB, 0x0B, 0x73, 0xFF, 0xFD, 0x72, 0x05, 0xFF, 0xFD, 0x04, 0x71, 0x09,
  0xFF, 0xFD, 0x09, 0x71, 0x0D, 0xFF, 0xFD, 0x0D, 0x70, 0x2F, 0xFF, 0xF0, 0x26, 0x07, 0xF0, 0x97,
  0x50, 0xBF, 0x06, 0x60, 0xBF, 0x05, 0x75, 0x08, 0xF0, 0xB6, 0xF9, 0x01, 0x75, 0x04, 0xF0, 0xE5,
  0x04, 0xF0, 0xD7, 0x60, 0x1F, 0x90, 0x44, 0x09, 0xF0, 0x97, 0x70, 0xCF, 0x08, 0x40, 0xDF, 0x05,
  0x77, 0x09, 0xF0, 0xD3, 0x02, 0xF9, 0x02, 0x77, 0x05, 0xF9, 0x02, 0x20, 0x6F, 0x0D, 0x77, 0x10,
  0x1F, 0x90, 0x62, 0x0A, 0xF0, 0xA7, 0x72, 0x0D, 0xF0, 0xA2, 0x0E, 0xF0, 0x67, 0x72, 0x0A, 0xF8,
  0x1E, 0x04, 0xF9, 0x02, 0x77, 0x20, 0x6F, 0x90, 0x40,
  // "ā" (U+0101)
  0x50, 0x1F, 0xFC, 0x01, 0x73, 0x01, 0xFF, 0xC0, 0x17, 0x30, 0x1F, 0xFC, 0x01, 0x73, 0x01, 0xFF,
  0xC0, 0x17, 0x30, 0x1F, 0xFC, 0x01, 0x73, 0x01, 0xFF, 0xC0, 0x18, 0x0A, 0x83, 0x08, 0x73, 0x55,
  0x67, 0x76, 0x53, 0x77, 0x38, 0x15, 0x9D, 0xFC, 0x81, 0xD8, 0x27, 0x30, 0x30, 0xAF, 0xFC, 0x0B,
  0x03, 0x70, 0xBF, 0xFF, 0x90, 0x86, 0x07, 0xFF, 0xFA, 0x09, 0x50, 0x10, 0xEF, 0xFF, 0xA0, 0x55,
  0x08, 0xFF, 0xFA, 0x0E, 0x50, 0x10, 0xEC, 0x87, 0xEC, 0xA8, 0x77, 0x79, 0xCF, 0xB0, 0x55, 0x83,
  0x8F, 0xB6, 0x37, 0x20, 0x20, 0xBF, 0x90, 0xA7, 0x77, 0x0C, 0xF0, 0xD7, 0x77, 0x05, 0xF9, 0x77,
  0x70, 0x3F, 0x90, 0x17, 0x76, 0x02, 0xF9, 0x01, 0x78, 0x44, 0x7A, 0xCD, 0xEF, 0xFA, 0x01, 0x48,
  0x11, 0x9E, 0xFF, 0xF9, 0x01, 0x30, 0x70, 0xEF, 0xFF, 0xB0, 0x12, 0x08, 0xFF, 0xFD, 0x81, 0x10,
  0x5F, 0xFF, 0xE8, 0x11, 0x0E, 0xFA, 0x81, 0x95, 0x26, 0x02, 0xF9, 0x01, 0x05, 0xF9, 0x0C, 0x01,
  0x72, 0x02, 0xF9, 0x01, 0x0A, 0xF0, 0xE0, 0x17, 0x30, 0x3F, 0x90, 0x10, 0xCF, 0x09, 0x74, 0x04,
  0xF9, 0x01, 0x0E, 0xF0, 0x77, 0x40, 0x8F, 0x90, 0x1F, 0x90, 0x87, 0x30, 0x10, 0xEF, 0x90, 0x10,
  0xEF, 0x0D, 0x72, 0x01, 0x0C, 0xFA, 0x01, 0x0D, 0xF9, 0x0A, 0x01, 0x60, 0x50, 0xEF, 0xB0, 0x10,
  0x9F, 0xB8, 0x4B, 0x87, 0x8A, 0xEF, 0xD0, 0x10, 0x5F, 0xFF, 0xF8, 0x11, 0x0D, 0xFF, 0xC0, 0x0E,
  0xF8, 0x11, 0x05, 0xFF, 0xB8, 0x1E, 0x39, 0xF0, 0x12, 0x09, 0xFF, 0x98, 0x2D, 0x30, 0x4F, 0x01,
  0x30, 0x8F, 0xE0, 0xA0, 0x13, 0x0E, 0xE0, 0x14, 0x81, 0x2A, 0xEF, 0x81, 0xE9, 0x25, 0x0A, 0xE0,
  0x17, 0x85, 0x35, 0x67, 0x65, 0x27, 0x72,
  // "Ă" (U+0102)
  0x71, 0x84, 0x67, 0x77, 0x71, 0x72, 0x84, 0x57, 0x77, 0x71, 0x77, 0x10, 0xCC, 0x04, 0x72, 0x0E,
  0xC0, 0x27, 0x71, 0x0A, 0xC0, 0xC7, 0x10, 0x7D, 0x77, 0x20, 0x6D, 0x86, 0xD7, 0x21, 0x02, 0x5B,
  0xD0, 0xB7, 0x72, 0x01, 0xFF, 0xC0, 0x57, 0x73, 0x09, 0xFF, 0xA0, 0xC7, 0x74, 0x01, 0x0D, 0xFF,
  0x0E, 0x02, 0x77, 0x50, 0x20, 0xDF, 0xD0, 0xE0, 0x37, 0x77, 0x10, 0x9F, 0xB0, 0xA0, 0x17, 0x77,
  0x38, 0x90, 0x17, 0xBD, 0xEF, 0xDB, 0x72, 0x80, 0xAC, 0x50, 0x0B, 0xFB, 0x0A, 0x77, 0x73, 0xFC,
  0x0E, 0x77, 0x72, 0x04, 0xFD, 0x03, 0x77, 0x71, 0x08, 0xFD, 0x07, 0x77, 0x71, 0x0D, 0xFD, 0x0C,
  0x77, 0x70, 0x1F, 0xF0, 0x17, 0x76, 0x06, 0xFF, 0x05, 0x77, 0x60, 0xAE, 0x00, 0xBE, 0x09, 0x77,
  0x60, 0xEE, 0x00, 0x8E, 0x0E, 0x77, 0x50, 0x3F, 0x00, 0x4F, 0x03, 0x77, 0x40, 0x8F, 0x2F, 0x07,
  0x77, 0x40, 0xCE, 0x0C, 0x20, 0xCE, 0x0B, 0x77, 0x30, 0x1F, 0x08, 0x20, 0x8F, 0x01, 0x77, 0x20,
  0x5F, 0x04, 0x20, 0x4F, 0x05, 0x77, 0x20, 0xAF, 0x4F, 0x09, 0x77, 0x20, 0xEE, 0x0B, 0x40, 0xCE,
  0x0D, 0x77, 0x10, 0x3F, 0x07, 0x40, 0x8F, 0x02, 0x77, 0x07, 0xF0, 0x34, 0x04, 0xF0, 0x77, 0x70,
  0xCE, 0x0E, 0x6F, 0x0B, 0x76, 0x01, 0xF0, 0xA6, 0x0C, 0xF7, 0x60, 0x5F, 0x06, 0x60, 0x8F, 0x04,
  0x75, 0x09, 0xF0, 0x26, 0x04, 0xF0, 0x97, 0x50, 0xEE, 0x0E, 0x71, 0xF0, 0xD7, 0x40, 0x3F, 0x09,
  0x71, 0x0B, 0xF0, 0x27, 0x30, 0x7F, 0x98, 0x04, 0xEF, 0x90, 0x77, 0x30, 0xBF, 0xFF, 0xB0, 0xB7,
  0x3F, 0xFF, 0xD7, 0x20, 0x5F, 0xFF, 0xD0, 0x47, 0x10, 0x9F, 0xFF, 0xD0, 0x97, 0x10, 0xDF, 0xFF,
  0xD0, 0xD7, 0x02, 0xFF, 0xFF, 0x02, 0x60, 0x7F, 0x09, 0x75, 0x0B, 0xF0, 0x66, 0x0B, 0xF0, 0x57,
  0x50, 0x8F, 0x0B, 0x6F, 0x90, 0x17, 0x50, 0x4F, 0x0E, 0x50, 0x4F, 0x0D, 0x76, 0x01, 0xF9, 0x04,
  0x40, 0x9F, 0x09, 0x77, 0x0C, 0xF0, 0x84, 0x0D, 0xF0, 0x57, 0x70, 0x9F, 0x0D, 0x30, 0x2F, 0x90,
  0x27, 0x70, 0x5F, 0x90, 0x22, 0x06, 0xF0, 0xD7, 0x71, 0x01, 0xF9, 0x06, 0x20, 0xAF, 0x0A, 0x77,
  0x20, 0xDF, 0x0A, 0x20, 0xEF, 0x06, 0x77, 0x20, 0xAF, 0x81, 0xE0, 0x4F, 0x90, 0x27, 0x72, 0x06,
  0xF9, 0x04,
  // "ă" (U+0103)
  0x58, 0x46, 0x77, 0x77, 0x17, 0x28, 0x45, 0x77, 0x77, 0x17, 0x20, 0xCC, 0x04, 0x72, 0x0E, 0xC0,
  0x27, 0x20, 0xAC, 0x0C, 0x71, 0x07, 0xD7, 0x30, 0x6D, 0x86, 0xD7, 0x21, 0x02, 0x5B, 0xD0, 0xB7,
  0x30, 0x1F, 0xFC, 0x05, 0x74, 0x09, 0xFF, 0xA0, 0xC7, 0x50, 0x10, 0xDF, 0xF0, 0xE0, 0x27, 0x60,
  0x20, 0xDF, 0xD0, 0xE0, 0x37, 0x72, 0x09, 0xFB, 0x0A, 0x01, 0x77, 0x48, 0x90, 0x17, 0xBD, 0xEF,
  0xDB, 0x72, 0x80, 0x9D, 0x20, 0x87, 0x35, 0x56, 0x77, 0x65, 0x37, 0x73, 0x81, 0x59, 0xDF, 0xC8,
  0x1D, 0x82, 0x73, 0x03, 0x0A, 0xFF, 0xC0, 0xB0, 0x37, 0x0B, 0xFF, 0xF9, 0x08, 0x60, 0x7F, 0xFF,
  0xA0, 0x95, 0x01, 0x0E, 0xFF, 0xFA, 0x05, 0x50, 0x8F, 0xFF, 0xA0, 0xE5, 0x01, 0x0E, 0xC8, 0x7E,
  0xCA, 0x87, 0x77, 0x9C, 0xFB, 0x05, 0x58, 0x38, 0xFB, 0x63, 0x72, 0x02, 0x0B, 0xF9, 0x0A, 0x77,
  0x70, 0xCF, 0x0D, 0x77, 0x70, 0x5F, 0x97, 0x77, 0x03, 0xF9, 0x01, 0x77, 0x60, 0x2F, 0x90, 0x17,
  0x84, 0x47, 0xAC, 0xDE, 0xFF, 0xA0, 0x14, 0x81, 0x19, 0xEF, 0xFF, 0x90, 0x13, 0x07, 0x0E, 0xFF,
  0xFB, 0x01, 0x20, 0x8F, 0xFF, 0xD8, 0x11, 0x05, 0xFF, 0xFE, 0x81, 0x10, 0xEF, 0xA8, 0x19, 0x52,
  0x60, 0x2F, 0x90, 0x10, 0x5F, 0x90, 0xC0, 0x17, 0x20, 0x2F, 0x90, 0x10, 0xAF, 0x0E, 0x01, 0x73,
  0x03, 0xF9, 0x01, 0x0C, 0xF0, 0x97, 0x40, 0x4F, 0x90, 0x10, 0xEF, 0x07, 0x74, 0x08, 0xF9, 0x01,
  0xF9, 0x08, 0x73, 0x01, 0x0E, 0xF9, 0x01, 0x0E, 0xF0, 0xD7, 0x20, 0x10, 0xCF, 0xA0, 0x10, 0xDF,
  0x90, 0xA0, 0x16, 0x05, 0x0E, 0xFB, 0x01, 0x09, 0xFB, 0x84, 0xB8, 0x78, 0xAE, 0xFD, 0x01, 0x05,
  0xFF, 0xFF, 0x81, 0x10, 0xDF, 0xFC, 0x00, 0xEF, 0x81, 0x10, 0x5F, 0xFB, 0x81, 0xE3, 0x9F, 0x01,
  0x20, 0x9F, 0xF9, 0x82, 0xD3, 0x04, 0xF0, 0x13, 0x08, 0xFE, 0x0A, 0x01, 0x30, 0xEE, 0x01, 0x48,
  0x12, 0xAE, 0xF8, 0x1E, 0x92, 0x50, 0xAE, 0x01, 0x78, 0x53, 0x56, 0x76, 0x52, 0x77, 0x20,
  // "Ą" (U+0104)
  0x75, 0x0B, 0xFB, 0x0A, 0x77, 0x74, 0xFC, 0x0E, 0x77, 0x73, 0x04, 0xFD, 0x03, 0x77, 0x72, 0x08,
  0xFD, 0x07, 0x77, 0x72, 0x0D, 0xFD, 0x0C, 0x77, 0x71, 0x01, 0xFF, 0x01, 0x77, 0x70, 0x6F, 0xF0,
  0x57, 0x77, 0x0A, 0xE0, 0x0B, 0xE0, 0x97, 0x77, 0x0E, 0xE0, 0x08, 0xE0, 0xE7, 0x76, 0x03, 0xF0,
  0x04, 0xF0, 0x37, 0x75, 0x08, 0xF2, 0xF0, 0x77, 0x75, 0x0C, 0xE0, 0xC2, 0x0C, 0xE0, 0xB7, 0x74,
  0x01, 0xF0, 0x82, 0x08, 0xF0, 0x17, 0x73, 0x05, 0xF0, 0x42, 0x04, 0xF0, 0x57, 0x73, 0x0A, 0xF4,
  0xF0, 0x97, 0x73, 0x0E, 0xE0, 0xB4, 0x0C, 0xE0, 0xD7, 0x72, 0x03, 0xF0, 0x74, 0x08, 0xF0, 0x27,
  0x71, 0x07, 0xF0, 0x34, 0x04, 0xF0, 0x77, 0x71, 0x0C, 0xE0, 0xE6, 0xF0, 0xB7, 0x70, 0x1F, 0x0A,
  0x60, 0xCF, 0x77, 0x05, 0xF0, 0x66, 0x08, 0xF0, 0x47, 0x60, 0x9F, 0x02, 0x60, 0x4F, 0x09, 0x76,
  0x0E, 0xE0, 0xE7, 0x1F, 0x0D, 0x75, 0x03, 0xF0, 0x97, 0x10, 0xBF, 0x02, 0x74, 0x07, 0xF9, 0x80,
  0x4E, 0xF9, 0x07, 0x74, 0x0B, 0xFF, 0xFB, 0x0B, 0x74, 0xFF, 0xFD, 0x73, 0x05, 0xFF, 0xFD, 0x04,
  0x72, 0x09, 0xFF, 0xFD, 0x09, 0x72, 0x0D, 0xFF, 0xFD, 0x0D, 0x71, 0x02, 0xFF, 0xFF, 0x02, 0x70,
  0x7F, 0x09, 0x75, 0x0B, 0xF0, 0x67, 0x0B, 0xF0, 0x57, 0x50, 0x8F, 0x0B, 0x7F, 0x90, 0x17, 0x50,
  0x4F, 0x0E, 0x60, 0x4F, 0x0D, 0x76, 0x01, 0xF9, 0x04, 0x50, 0x9F, 0x09, 0x77, 0x0C, 0xF0, 0x85,
  0x0D, 0xF0, 0x57, 0x70, 0x9F, 0x0D, 0x40, 0x2F, 0x90, 0x27, 0x70, 0x5F, 0x90, 0x23, 0x06, 0xF0,
  0xD7, 0x71, 0x01, 0xF9, 0x06, 0x30, 0xAF, 0x0A, 0x77, 0x20, 0xDF, 0x0A, 0x30, 0xEF, 0x06, 0x77,
  0x20, 0xAF, 0x0E, 0x20, 0x4F, 0x90, 0x27, 0x72, 0x06, 0xF9, 0x04, 0x77, 0x77, 0x20, 0x30, 0xEC,
  0x03, 0x77, 0x77, 0x10, 0x4D, 0x05, 0x77, 0x77, 0x10, 0x3D, 0x07, 0x77, 0x77, 0x20, 0xDC, 0x0C,
  0x77, 0x77, 0x20, 0x7D, 0x04, 0x77, 0x77, 0x20, 0xDD, 0x77, 0x77, 0x20, 0x2D, 0x0D, 0x77, 0x77,
  0x20, 0x3E, 0x77, 0x77, 0x20, 0x3E, 0x83, 0xA1, 0x02, 0x57, 0x77, 0x5F, 0xC7, 0x77, 0x50, 0xAF,
  0xB7, 0x77, 0x50, 0x20, 0xEF, 0xA7, 0x77, 0x60, 0x30, 0xEF, 0x97, 0x77, 0x71, 0x81, 0x6B, 0xEA,
  0x81, 0xDB, 0x70,
  // "ą" (U+0105)
  0x73, 0x87, 0x35, 0x56, 0x77, 0x65, 0x37, 0x73, 0x81, 0x59, 0xDF, 0xC8, 0x1D, 0x82, 0x73, 0x03,
  0x0A, 0xFF, 0xC0, 0xB0, 0x37, 0x0B, 0xFF, 0xF9, 0x08, 0x60, 0x7F, 0xFF, 0xA0, 0x95, 0x01, 0x0E,
  0xFF, 0xFA, 0x05, 0x50, 0x8F, 0xFF, 0xA0, 0xE5, 0x01, 0x0E, 0xC8, 0x7E, 0xCA, 0x87, 0x77, 0x9C,
  0xFB, 0x05, 0x58, 0x38, 0xFB, 0x63, 0x72, 0x02, 0x0B, 0xF9, 0x0A, 0x77, 0x70, 0xCF, 0x0D, 0x77,
  0x70, 0x5F, 0x97, 0x77, 0x03, 0xF9, 0x01, 0x77, 0x60, 0x2F, 0x90, 0x17, 0x84, 0x47, 0xAC, 0xDE,
  0xFF, 0xA0, 0x14, 0x81, 0x19, 0xEF, 0xFF, 0x90, 0x13, 0x07, 0x0E, 0xFF, 0xFB, 0x01, 0x20, 0x8F,
  0xFF, 0xD8, 0x11, 0x05, 0xFF, 0xFE, 0x81, 0x10, 0xEF, 0xA8, 0x19, 0x52, 0x60, 0x2F, 0x90, 0x10,
  0x5F, 0x90, 0xC0, 0x17, 0x20, 0x2F, 0x90, 0x10, 0xAF, 0x0E, 0x01, 0x73, 0x03, 0xF9, 0x01, 0x0C,
  0xF0, 0x97, 0x40, 0x4F, 0x90, 0x10, 0xEF, 0x07, 0x74, 0x08, 0xF9, 0x01, 0xF9, 0x08, 0x73, 0x01,
  0x0E, 0xF9, 0x01, 0x0E, 0xF0, 0xD7, 0x20, 0x10, 0xCF, 0xA0, 0x10, 0xDF, 0x90, 0xA0, 0x16, 0x05,
  0x0E, 0xFB, 0x01, 0x09, 0xFB, 0x84, 0xB8, 0x78, 0xAE, 0xFD, 0x01, 0x05, 0xFF, 0xFF, 0x81, 0x10,
  0xDF, 0xFC, 0x00, 0xEF, 0x81, 0x10, 0x5F, 0xFB, 0x81, 0xE3, 0x9F, 0x01, 0x20, 0x9F, 0xF9, 0x82,
  0xD3, 0x04, 0xF0, 0x13, 0x08, 0xFE, 0x0A, 0x01, 0x30, 0xEE, 0x01, 0x48, 0x12, 0xAE, 0xF8, 0x1E,
  0x92, 0x50, 0xBE, 0x01, 0x78, 0x53, 0x56, 0x76, 0x52, 0x70, 0x30, 0xEC, 0x03, 0x77, 0x71, 0x04,
  0xD0, 0x57, 0x77, 0x10, 0x3D, 0x07, 0x77, 0x72, 0x0D, 0xC0, 0xC7, 0x77, 0x20, 0x7D, 0x04, 0x77,
  0x72, 0x0D, 0xD7, 0x77, 0x20, 0x2D, 0x0D, 0x77, 0x72, 0x03, 0xE7, 0x77, 0x20, 0x3E, 0x83, 0xA1,
  0x02, 0x57, 0x75, 0xFC, 0x77, 0x50, 0xAF, 0xB7, 0x75, 0x02, 0x0E, 0xFA, 0x77, 0x60, 0x30, 0xEF,
  0x97, 0x77, 0x18, 0x16, 0xBE, 0xA8, 0x1D, 0xB7, 0x10,
  // "Ć" (U+0106)
  0x77, 0x50, 0x68, 0x04, 0x70, 0x67, 0x76, 0x04, 0xFA, 0x05, 0x77, 0x60, 0xDF, 0x90, 0x67, 0x76,
  0x08, 0xF9, 0x06, 0x77, 0x60, 0x3F, 0x90, 0x57, 0x77, 0x0D, 0xF0, 0x47, 0x77, 0x09, 0xE0, 0xE0,
  0x47, 0x77, 0x05, 0xE0, 0xE0, 0x37, 0x77, 0x02, 0x0E, 0xD0, 0xC0, 0x17, 0x77, 0x10, 0x9D, 0x0A,
  0x80, 0x9E, 0x40, 0x87, 0x35, 0x67, 0x76, 0x54, 0x17, 0x74, 0x81, 0x49, 0xDF, 0xB8, 0x2E, 0xA5,
  0x17, 0x50, 0x70, 0xEF, 0xFA, 0x81, 0xE9, 0x27, 0x10, 0x50, 0xEF, 0xFE, 0x04, 0x70, 0x9F, 0xFF,
  0x0D, 0x70, 0xBF, 0xFF, 0x90, 0x76, 0x0C, 0xFF, 0xF9, 0x0E, 0x01, 0x50, 0x9F, 0xC8, 0x6D, 0xA8,
  0x77, 0x8A, 0xDC, 0x09, 0x50, 0x5F, 0xB0, 0xA0, 0x37, 0x18, 0x33, 0x8E, 0xF2, 0x50, 0xDF, 0x90,
  0xE0, 0x47, 0x60, 0x55, 0x07, 0xF9, 0x0E, 0x03, 0x77, 0x60, 0xDF, 0x90, 0x57, 0x76, 0x04, 0xF9,
  0x0B, 0x77, 0x70, 0xAF, 0x90, 0x47, 0x77, 0x0E, 0xF0, 0xD7, 0x77, 0x03, 0xF9, 0x09, 0x77, 0x70,
  0x6F, 0x90, 0x57, 0x77, 0x09, 0xF9, 0x03, 0x77, 0x70, 0xBF, 0x97, 0x77, 0x10, 0xDF, 0x0E, 0x77,
  0x71, 0x0D, 0xF0, 0xD7, 0x77, 0x10, 0xEF, 0x0D, 0x77, 0x71, 0xF9, 0x0C, 0x77, 0x71, 0xF9, 0x0D,
  0x77, 0x71, 0x0E, 0xF0, 0xE7, 0x77, 0x10, 0xDF, 0x0E, 0x77, 0x71, 0x0C, 0xF9, 0x01, 0x77, 0x70,
  0xAF, 0x90, 0x37, 0x77, 0x08, 0xF9, 0x06, 0x77, 0x70, 0x5F, 0x90, 0xA7, 0x77, 0x01, 0xF9, 0x0E,
  0x77, 0x71, 0x0C, 0xF9, 0x06, 0x77, 0x70, 0x7F, 0x90, 0xE7, 0x77, 0x02, 0xFA, 0x0A, 0x77, 0x70,
  0xAF, 0xA0, 0xA7, 0x70, 0x40, 0x94, 0x02, 0xFB, 0x81, 0xE6, 0x17, 0x18, 0x33, 0x8D, 0xFE, 0x50,
  0x8F, 0xD8, 0x6B, 0x98, 0x78, 0x9B, 0xEC, 0x0E, 0x60, 0xCF, 0xFF, 0xA0, 0xE6, 0x01, 0x0D, 0xFF,
  0xF9, 0x0E, 0x70, 0x20, 0xDF, 0xFF, 0x0E, 0x72, 0x0A, 0xFF, 0xE0, 0xE7, 0x30, 0x40, 0xCF, 0xFB,
  0x0E, 0x09, 0x75, 0x81, 0x38, 0xDF, 0xC8, 0x1C, 0x84, 0x77, 0x48, 0x73, 0x56, 0x77, 0x66, 0x42,
  0x71,
  // "ć" (U+0107)
  0x77, 0x30, 0x68, 0x04, 0x70, 0x67, 0x72, 0x04, 0xFA, 0x05, 0x77, 0x20, 0xDF, 0x90, 0x67, 0x72,
  0x08, 0xF9, 0x06, 0x77, 0x20, 0x3F, 0x90, 0x57, 0x73, 0x0D, 0xF0, 0x47, 0x73, 0x09, 0xE0, 0xE0,
  0x47, 0x73, 0x05, 0xE0, 0xE0, 0x37, 0x73, 0x02, 0x0E, 0xD0, 0xC0, 0x17, 0x74, 0x09, 0xD0, 0xA8,
  0x09, 0xC2, 0x08, 0x90, 0x24, 0x67, 0x77, 0x65, 0x31, 0x76, 0x82, 0x16, 0xBE, 0xFB, 0x82, 0xDA,
  0x61, 0x78, 0x11, 0x8E, 0xFF, 0xB0, 0xB5, 0x04, 0x0E, 0xFF, 0xD0, 0xC4, 0x05, 0xFF, 0xF0, 0x63,
  0x04, 0xFF, 0xF9, 0x01, 0x20, 0x10, 0xEF, 0xFF, 0x0A, 0x30, 0x9F, 0xC8, 0x5C, 0x97, 0x78, 0xAC,
  0xC0, 0x42, 0x02, 0xFB, 0x0A, 0x02, 0x71, 0x81, 0x4A, 0xD3, 0x08, 0xFA, 0x06, 0x77, 0x20, 0xDF,
  0x90, 0x97, 0x72, 0x02, 0xFA, 0x01, 0x77, 0x20, 0x5F, 0x90, 0xA7, 0x73, 0x08, 0xF9, 0x06, 0x77,
  0x30, 0xAF, 0x90, 0x37, 0x73, 0x0B, 0xF9, 0x01, 0x77, 0x30, 0xBF, 0x97, 0x74, 0x0C, 0xF9, 0x77,
  0x40, 0xBF, 0x90, 0x17, 0x73, 0x0A, 0xF9, 0x02, 0x77, 0x30, 0x9F, 0x90, 0x57, 0x73, 0x07, 0xF9,
  0x09, 0x77, 0x30, 0x3F, 0x90, 0xE7, 0x74, 0xFA, 0x08, 0x77, 0x30, 0xBF, 0xA0, 0x67, 0x58, 0x33,
  0xB2, 0x05, 0xFB, 0x09, 0x02, 0x78, 0x11, 0x6B, 0xA0, 0x22, 0x0D, 0xFC, 0x85, 0xC9, 0x77, 0x8A,
  0xDD, 0x02, 0x20, 0x5F, 0xFF, 0xA0, 0x23, 0x09, 0xFF, 0xF9, 0x02, 0x40, 0xBF, 0xFF, 0x02, 0x50,
  0x9F, 0xFE, 0x02, 0x60, 0x40, 0xCF, 0xFB, 0x0A, 0x01, 0x71, 0x81, 0x39, 0xDF, 0xB8, 0x2E, 0xB7,
  0x17, 0x68, 0x90, 0x13, 0x56, 0x77, 0x76, 0x42, 0x60,
  // "Ĉ" (U+0108)
  0x76, 0x02, 0x80, 0x47, 0x06, 0x77, 0x70, 0xCF, 0xA0, 0x47, 0x75, 0x07, 0xFB, 0x0D, 0x77, 0x40,
  0x3F, 0xD0, 0x97, 0x72, 0x01, 0x0D, 0xFE, 0x05, 0x77, 0x10, 0xAE, 0x0A, 0x05, 0xE0, 0xE0, 0x27,
  0x60, 0x7E, 0x0A, 0x20, 0x5E, 0x0D, 0x01, 0x74, 0x04, 0xE0, 0x94, 0x04, 0x0E, 0xD0, 0xB7, 0x30,
  0x30, 0xED, 0x07, 0x60, 0x30, 0xDD, 0x08, 0x72, 0x0C, 0xC0, 0xE0, 0x47, 0x10, 0x10, 0xBD, 0x02,
  0x80, 0x9D, 0x20, 0x87, 0x35, 0x67, 0x76, 0x54, 0x17, 0x74, 0x81, 0x49, 0xDF, 0xB8, 0x2E, 0xA5,
  0x17, 0x50, 0x70, 0xEF, 0xFA, 0x81, 0xE9, 0x27, 0x10, 0x50, 0xEF, 0xFE, 0x04, 0x70, 0x9F, 0xFF,
  0x0D, 0x70, 0xBF, 0xFF, 0x90, 0x76, 0x0C, 0xFF, 0xF9, 0x0E, 0x01, 0x50, 0x9F, 0xC8, 0x6D, 0xA8,
  0x77, 0x8A, 0xDC, 0x09, 0x50, 0x5F, 0xB0, 0xA0, 0x37, 0x18, 0x33, 0x8E, 0xF2, 0x50, 0xDF, 0x90,
  0xE0, 0x47, 0x60, 0x55, 0x07, 0xF9, 0x0E, 0x03, 0x77, 0x60, 0xDF, 0x90, 0x57, 0x76, 0x04, 0xF9,
  0x0B, 0x77, 0x70, 0xAF, 0x90, 0x47, 0x77, 0x0E, 0xF0, 0xD7, 0x77, 0x03, 0xF9, 0x09, 0x77, 0x70,
  0x6F, 0x90, 0x57, 0x77, 0x09, 0xF9, 0x03, 0x77, 0x70, 0xBF, 0x97, 0x77, 0x10, 0xDF, 0x0E, 0x77,
  0x71, 0x0D, 0xF0, 0xD7, 0x77, 0x10, 0xEF, 0x0D, 0x77, 0x71, 0xF9, 0x0C, 0x77, 0x71, 0xF9, 0x0D,
  0x77, 0x71, 0x0E, 0xF0, 0xE7, 0x77, 0x10, 0xDF, 0x0E, 0x77, 0x71, 0x0C, 0xF9, 0x01, 0x77, 0x70,
  0xAF, 0x90, 0x37, 0x77, 0x08, 0xF9, 0x06, 0x77, 0x70, 0x5F, 0x90, 0xA7, 0x77, 0x01, 0xF9, 0x0E,
  0x77, 0x71, 0x0C, 0xF9, 0x06, 0x77, 0x70, 0x7F, 0x90, 0xE7, 0x77, 0x02, 0xFA, 0x0A, 0x77, 0x70,
  0xAF, 0xA0, 0xA7, 0x70, 0x40, 0x94, 0x02, 0xFB, 0x81, 0xE6, 0x17, 0x18, 0x33, 0x8D, 0xFE, 0x50,
  0x8F, 0xD8, 0x6B, 0x98, 0x78, 0x9B, 0xEC, 0x0E, 0x60, 0xCF, 0xFF, 0xA0, 0xE6, 0x01, 0x0D, 0xFF,
  0xF9, 0x0E, 0x70, 0x20, 0xDF, 0xFF, 0x0E, 0x72, 0x0A, 0xFF, 0xE0, 0xE7, 0x30, 0x40, 0xCF, 0xFB,
  0x0E, 0x09, 0x75, 0x81, 0x38, 0xDF, 0xC8, 0x1C, 0x84, 0x77, 0x48, 0x73, 0x56, 0x77, 0x66, 0x42,
  0x71,
  // "ĉ" (U+0109)
  0x74, 0x02, 0x80, 0x47, 0x06, 0x77, 0x40, 0xCF, 0xA0, 0x47, 0x72, 0x07, 0xFB, 0x0D, 0x77, 0x10,
  0x3F, 0xD0, 0x97, 0x60, 0x10, 0xDF, 0xE0, 0x57, 0x50, 0xAE, 0x0A, 0x05, 0xE0, 0xE0, 0x27, 0x30,
  0x7E, 0x0A, 0x20, 0x5E, 0x0D, 0x01, 0x71, 0x04, 0xE0, 0x94, 0x04, 0x0E, 0xD0, 0xB7, 0x03, 0x0E,
  0xD0, 0x76, 0x03, 0x0D, 0xD0, 0x86, 0x0C, 0xC0, 0xE0, 0x47, 0x10, 0x10, 0xBD, 0x02, 0x80, 0x9B,
  0x40, 0x89, 0x02, 0x46, 0x77, 0x76, 0x53, 0x17, 0x78, 0x21, 0x6B, 0xEF, 0xB8, 0x2D, 0xA6, 0x17,
  0x18, 0x11, 0x8E, 0xFF, 0xB0, 0xB6, 0x04, 0x0E, 0xFF, 0xD0, 0xC5, 0x05, 0xFF, 0xF0, 0x64, 0x04,
  0xFF, 0xF9, 0x01, 0x30, 0x10, 0xEF, 0xFF, 0x0A, 0x40, 0x9F, 0xC8, 0x5C, 0x97, 0x78, 0xAC, 0xC0,
  0x43, 0x02, 0xFB, 0x0A, 0x02, 0x71, 0x81, 0x4A, 0xD4, 0x08, 0xFA, 0x06, 0x77, 0x30, 0xDF, 0x90,
  0x97, 0x73, 0x02, 0xFA, 0x01, 0x77, 0x30, 0x5F, 0x90, 0xA7, 0x74, 0x08, 0xF9, 0x06, 0x77, 0x40,
  0xAF, 0x90, 0x37, 0x74, 0x0B, 0xF9, 0x01, 0x77, 0x40, 0xBF, 0x97, 0x75, 0x0C, 0xF9, 0x77, 0x50,
  0xBF, 0x90, 0x17, 0x74, 0x0A, 0xF9, 0x02, 0x77, 0x40, 0x9F, 0x90, 0x57, 0x74, 0x07, 0xF9, 0x09,
  0x77, 0x40, 0x3F, 0x90, 0xE7, 0x75, 0xFA, 0x08, 0x77, 0x40, 0xBF, 0xA0, 0x67, 0x58, 0x13, 0xB2,
  0x20, 0x5F, 0xB0, 0x90, 0x27, 0x81, 0x16, 0xBA, 0x02, 0x30, 0xDF, 0xC8, 0x5C, 0x97, 0x78, 0xAD,
  0xD0, 0x23, 0x05, 0xFF, 0xFA, 0x02, 0x40, 0x9F, 0xFF, 0x90, 0x25, 0x0B, 0xFF, 0xF0, 0x26, 0x09,
  0xFF, 0xE0, 0x27, 0x04, 0x0C, 0xFF, 0xB0, 0xA0, 0x17, 0x28, 0x13, 0x9D, 0xFB, 0x82, 0xEB, 0x71,
  0x77, 0x89, 0x01, 0x35, 0x67, 0x77, 0x64, 0x27,
  // "Ċ" (U+010A)
  0x77, 0x81, 0x29, 0xDA, 0x81, 0xD9, 0x27, 0x77, 0x10, 0x30, 0xEE, 0x0E, 0x03, 0x77, 0x70, 0xDF,
  0x90, 0xC7, 0x76, 0x02, 0xFB, 0x01, 0x77, 0x50, 0x4F, 0xB0, 0x37, 0x75, 0x04, 0xFB, 0x03, 0x77,
  0x50, 0x2F, 0xB0, 0x17, 0x76, 0x0D, 0xF9, 0x0B, 0x77, 0x70, 0x4F, 0x0E, 0x02, 0x77, 0x71, 0x81,
  0x29, 0xDA, 0x81, 0xD8, 0x18, 0x09, 0xE2, 0x08, 0x73, 0x56, 0x77, 0x65, 0x41, 0x77, 0x48, 0x14,
  0x9D, 0xFB, 0x82, 0xEA, 0x51, 0x75, 0x07, 0x0E, 0xFF, 0xA8, 0x1E, 0x92, 0x71, 0x05, 0x0E, 0xFF,
  0xE0, 0x47, 0x09, 0xFF, 0xF0, 0xD7, 0x0B, 0xFF, 0xF9, 0x07, 0x60, 0xCF, 0xFF, 0x90, 0xE0, 0x15,
  0x09, 0xFC, 0x86, 0xDA, 0x87, 0x78, 0xAD, 0xC0, 0x95, 0x05, 0xFB, 0x0A, 0x03, 0x71, 0x83, 0x38,
  0xEF, 0x25, 0x0D, 0xF9, 0x0E, 0x04, 0x76, 0x05, 0x50, 0x7F, 0x90, 0xE0, 0x37, 0x76, 0x0D, 0xF9,
  0x05, 0x77, 0x60, 0x4F, 0x90, 0xB7, 0x77, 0x0A, 0xF9, 0x04, 0x77, 0x70, 0xEF, 0x0D, 0x77, 0x70,
  0x3F, 0x90, 0x97, 0x77, 0x06, 0xF9, 0x05, 0x77, 0x70, 0x9F, 0x90, 0x37, 0x77, 0x0B, 0xF9, 0x77,
  0x71, 0x0D, 0xF0, 0xE7, 0x77, 0x10, 0xDF, 0x0D, 0x77, 0x71, 0x0E, 0xF0, 0xD7, 0x77, 0x1F, 0x90,
  0xC7, 0x77, 0x1F, 0x90, 0xD7, 0x77, 0x10, 0xEF, 0x0E, 0x77, 0x71, 0x0D, 0xF0, 0xE7, 0x77, 0x10,
  0xCF, 0x90, 0x17, 0x77, 0x0A, 0xF9, 0x03, 0x77, 0x70, 0x8F, 0x90, 0x67, 0x77, 0x05, 0xF9, 0x0A,
  0x77, 0x70, 0x1F, 0x90, 0xE7, 0x77, 0x10, 0xCF, 0x90, 0x67, 0x77, 0x07, 0xF9, 0x0E, 0x77, 0x70,
  0x2F, 0xA0, 0xA7, 0x77, 0x0A, 0xFA, 0x0A, 0x77, 0x04, 0x09, 0x40, 0x2F, 0xB8, 0x1E, 0x61, 0x71,
  0x83, 0x38, 0xDF, 0xE5, 0x08, 0xFD, 0x86, 0xB9, 0x87, 0x89, 0xBE, 0xC0, 0xE6, 0x0C, 0xFF, 0xFA,
  0x0E, 0x60, 0x10, 0xDF, 0xFF, 0x90, 0xE7, 0x02, 0x0D, 0xFF, 0xF0, 0xE7, 0x20, 0xAF, 0xFE, 0x0E,
  0x73, 0x04, 0x0C, 0xFF, 0xB0, 0xE0, 0x97, 0x58, 0x13, 0x8D, 0xFC, 0x81, 0xC8, 0x47, 0x74, 0x87,
  0x35, 0x67, 0x76, 0x64, 0x27, 0x10,
  // "ċ" (U+010B)
  0x75, 0x81, 0x29, 0xDA, 0x81, 0xD9, 0x27, 0x74, 0x03, 0x0E, 0xE0, 0xE0, 0x37, 0x73, 0x0D, 0xF9,
  0x0C, 0x77, 0x20, 0x2F, 0xB0, 0x17, 0x71, 0x04, 0xFB, 0x03, 0x77, 0x10, 0x4F, 0xB0, 0x37, 0x71,
  0x02, 0xFB, 0x01, 0x77, 0x20, 0xDF, 0x90, 0xB7, 0x73, 0x04, 0xF0, 0xE0, 0x27, 0x74, 0x81, 0x29,
  0xDA, 0x81, 0xD8, 0x18, 0x09, 0xC0, 0x08, 0x90, 0x24, 0x67, 0x77, 0x65, 0x31, 0x76, 0x82, 0x16,
  0xBE, 0xFB, 0x82, 0xDA, 0x61, 0x78, 0x11, 0x8E, 0xFF, 0xB0, 0xB5, 0x04, 0x0E, 0xFF, 0xD0, 0xC4,
  0x05, 0xFF, 0xF0, 0x63, 0x04, 0xFF, 0xF9, 0x01, 0x20, 0x10, 0xEF, 0xFF, 0x0A, 0x30, 0x9F, 0xC8,
  0x5C, 0x97, 0x78, 0xAC, 0xC0, 0x42, 0x02, 0xFB, 0x0A, 0x02, 0x71, 0x81, 0x4A, 0xD3, 0x08, 0xFA,
  0x06, 0x77, 0x20, 0xDF, 0x90, 0x97, 0x72, 0x02, 0xFA, 0x01, 0x77, 0x20, 0x5F, 0x90, 0xA7, 0x73,
  0x08, 0xF9, 0x06, 0x77, 0x30, 0xAF, 0x90, 0x37, 0x73, 0x0B, 0xF9, 0x01, 0x77, 0x30, 0xBF, 0x97,
  0x74, 0x0C, 0xF9, 0x77, 0x40, 0xBF, 0x90, 0x17, 0x73, 0x0A, 0xF9, 0x02, 0x77, 0x30, 0x9F, 0x90,
  0x57, 0x73, 0x07, 0xF9, 0x09, 0x77, 0x30, 0x3F, 0x90, 0xE7, 0x74, 0xFA, 0x08, 0x77, 0x30, 0xBF,
  0xA0, 0x67, 0x58, 0x33, 0xB2, 0x05, 0xFB, 0x09, 0x02, 0x78, 0x11, 0x6B, 0xA0, 0x22, 0x0D, 0xFC,
  0x85, 0xC9, 0x77, 0x8A, 0xDD, 0x02, 0x20, 0x5F, 0xFF, 0xA0, 0x23, 0x09, 0xFF, 0xF9, 0x02, 0x40,
  0xBF, 0xFF, 0x02, 0x50, 0x9F, 0xFE, 0x02, 0x60, 0x40, 0xCF, 0xFB, 0x0A, 0x01, 0x71, 0x81, 0x39,
  0xDF, 0xB8, 0x2E, 0xB7, 0x17, 0x68, 0x90, 0x13, 0x56, 0x77, 0x76, 0x42, 0x60,
  // "Č" (U+010C)
  0x78, 0x01, 0x70, 0x57, 0x30, 0x58, 0x01, 0x77, 0x20, 0xBD, 0x09, 0x71, 0x09, 0xD0, 0xB7, 0x30,
  0xCD, 0x0C, 0x01, 0x40, 0x20, 0xCD, 0x0D, 0x01, 0x73, 0x01, 0x0E, 0xD0, 0xD0, 0x22, 0x03, 0x0E,
  0xD0, 0xE0, 0x27, 0x50, 0x4E, 0x82, 0xE2, 0x3E, 0xE0, 0x47, 0x70, 0x7E, 0x0D, 0x0E, 0xE0, 0x87,
  0x72, 0x0B, 0xFD, 0x0B, 0x77, 0x30, 0x10, 0xEF, 0xB0, 0xE0, 0x17, 0x74, 0x05, 0xFB, 0x05, 0x77,
  0x60, 0xAF, 0x90, 0xA8, 0x09, 0xE1, 0x08, 0x73, 0x56, 0x77, 0x65, 0x41, 0x77, 0x48, 0x14, 0x9D,
  0xFB, 0x82, 0xEA, 0x51, 0x75, 0x07, 0x0E, 0xFF, 0xA8, 0x1E, 0x92, 0x71, 0x05, 0x0E, 0xFF, 0xE0,
  0x47, 0x09, 0xFF, 0xF0, 0xD7, 0x0B, 0xFF, 0xF9, 0x07, 0x60, 0xCF, 0xFF, 0x90, 0xE0, 0x15, 0x09,
  0xFC, 0x86, 0xDA, 0x87, 0x78, 0xAD, 0xC0, 0x95, 0x05, 0xFB, 0x0A, 0x03, 0x71, 0x83, 0x38, 0xEF,
  0x25, 0x0D, 0xF9, 0x0E, 0x04, 0x76, 0x05, 0x50, 0x7F, 0x90, 0xE0, 0x37, 0x76, 0x0D, 0xF9, 0x05,
  0x77, 0x60, 0x4F, 0x90, 0xB7, 0x77, 0x0A, 0xF9, 0x04, 0x77, 0x70, 0xEF, 0x0D, 0x77, 0x70, 0x3F,
  0x90, 0x97, 0x77, 0x06, 0xF9, 0x05, 0x77, 0x70, 0x9F, 0x90, 0x37, 0x77, 0x0B, 0xF9, 0x77, 0x71,
  0x0D, 0xF0, 0xE7, 0x77, 0x10, 0xDF, 0x0D, 0x77, 0x71, 0x0E, 0xF0, 0xD7, 0x77, 0x1F, 0x90, 0xC7,
  0x77, 0x1F, 0x90, 0xD7, 0x77, 0x10, 0xEF, 0x0E, 0x77, 0x71, 0x0D, 0xF0, 0xE7, 0x77, 0x10, 0xCF,
  0x90, 0x17, 0x77, 0x0A, 0xF9, 0x03, 0x77, 0x70, 0x8F, 0x90, 0x67, 0x77, 0x05, 0xF9, 0x0A, 0x77,
  0x70, 0x1F, 0x90, 0xE7, 0x77, 0x10, 0xCF, 0x90, 0x67, 0x77, 0x07, 0xF9, 0x0E, 0x77, 0x70, 0x2F,
  0xA0, 0xA7, 0x77, 0x0A, 0xFA, 0x0A, 0x77, 0x04, 0x09, 0x40, 0x2F, 0xB8, 0x1E, 0x61, 0x71, 0x83,
  0x38, 0xDF, 0xE5, 0x08, 0xFD, 0x86, 0xB9, 0x87, 0x89, 0xBE, 0xC0, 0xE6, 0x0C, 0xFF, 0xFA, 0x0E,
  0x60, 0x10, 0xDF, 0xFF, 0x90, 0xE7, 0x02, 0x0D, 0xFF, 0xF0, 0xE7, 0x20, 0xAF, 0xFE, 0x0E, 0x73,
  0x04, 0x0C, 0xFF, 0xB0, 0xE0, 0x97, 0x58, 0x13, 0x8D, 0xFC, 0x81, 0xC8, 0x47, 0x74, 0x87, 0x35,
  0x67, 0x76, 0x64, 0x27, 0x10,
  // "č" (U+010D)
  0x58, 0x01, 0x70, 0x57, 0x30, 0x58, 0x01, 0x75, 0x0B, 0xD0, 0x97, 0x10, 0x9D, 0x0B, 0x60, 0xCD,
  0x0C, 0x01, 0x40, 0x20, 0xCD, 0x0D, 0x01, 0x60, 0x10, 0xED, 0x0D, 0x02, 0x20, 0x30, 0xED, 0x0E,
  0x02, 0x71, 0x04, 0xE8, 0x2E, 0x23, 0xEE, 0x04, 0x73, 0x07, 0xE0, 0xD0, 0xEE, 0x08, 0x75, 0x0B,
  0xFD, 0x0B, 0x76, 0x01, 0x0E, 0xFB, 0x0E, 0x01, 0x77, 0x05, 0xFB, 0x05, 0x77, 0x20, 0xAF, 0x90,
  0xA8, 0x09, 0xB7, 0x08, 0x90, 0x24, 0x67, 0x77, 0x65, 0x31, 0x76, 0x82, 0x16, 0xBE, 0xFB, 0x82,
  0xDA, 0x61, 0x78, 0x11, 0x8E, 0xFF, 0xB0, 0xB5, 0x04, 0x0E, 0xFF, 0xD0, 0xC4, 0x05, 0xFF, 0xF0,
  0x63, 0x04, 0xFF, 0xF9, 0x01, 0x20, 0x10, 0xEF, 0xFF, 0x0A, 0x30, 0x9F, 0xC8, 0x5C, 0x97, 0x78,
  0xAC, 0xC0, 0x42, 0x02, 0xFB, 0x0A, 0x02, 0x71, 0x81, 0x4A, 0xD3, 0x08, 0xFA, 0x06, 0x77, 0x20,
  0xDF, 0x90, 0x97, 0x72, 0x02, 0xFA, 0x01, 0x77, 0x20, 0x5F, 0x90, 0xA7, 0x73, 0x08, 0xF9, 0x06,
  0x77, 0x30, 0xAF, 0x90, 0x37, 0x73, 0x0B, 0xF9, 0x01, 0x77, 0x30, 0xBF, 0x97, 0x74, 0x0C, 0xF9,
  0x77, 0x40, 0xBF, 0x90, 0x17, 0x73, 0x0A, 0xF9, 0x02, 0x77, 0x30, 0x9F, 0x90, 0x57, 0x73, 0x07,
  0xF9, 0x09, 0x77, 0x30, 0x3F, 0x90, 0xE7, 0x74, 0xFA, 0x08, 0x77, 0x30, 0xBF, 0xA0, 0x67, 0x58,
  0x33, 0xB2, 0x05, 0xFB, 0x09, 0x02, 0x78, 0x11, 0x6B, 0xA0, 0x22, 0x0D, 0xFC, 0x85, 0xC9, 0x77,
  0x8A, 0xDD, 0x02, 0x20, 0x5F, 0xFF, 0xA0, 0x23, 0x09, 0xFF, 0xF9, 0x02, 0x40, 0xBF, 0xFF, 0x02,
  0x50, 0x9F, 0xFE, 0x02, 0x60, 0x40, 0xCF, 0xFB, 0x0A, 0x01, 0x71, 0x81, 0x39, 0xDF, 0xB8, 0x2E,
  0xB7, 0x17, 0x68, 0x90, 0x13, 0x56, 0x77, 0x76, 0x42, 0x60,
  // "Ď" (U+010E)
  0x48, 0x01, 0x70, 0x57, 0x30, 0x58, 0x01, 0x77, 0x40, 0xBD, 0x09, 0x71, 0x09, 0xD0, 0xB7, 0x50,
  0xCD, 0x0C, 0x01, 0x40, 0x20, 0xCD, 0x0D, 0x01, 0x75, 0x01, 0x0E, 0xD0, 0xD0, 0x22, 0x03, 0x0E,
  0xD0, 0xE0, 0x27, 0x70, 0x4E, 0x82, 0xE2, 0x3E, 0xE0, 0x47, 0x72, 0x07, 0xE0, 0xD0, 0xEE, 0x08,
  0x77, 0x40, 0xBF, 0xD0, 0xB7, 0x75, 0x01, 0x0E, 0xFB, 0x0E, 0x01, 0x77, 0x60, 0x5F, 0xB0, 0x57,
  0x77, 0x10, 0xAF, 0x90, 0xA8, 0x0A, 0x95, 0x00, 0x4F, 0xF8, 0x3E, 0xDB, 0x84, 0x76, 0x04, 0xFF,
  0xD8, 0x1E, 0xA3, 0x73, 0x04, 0xFF, 0xF9, 0x0A, 0x02, 0x71, 0x04, 0xFF, 0xFA, 0x0E, 0x05, 0x70,
  0x4F, 0xFF, 0xC0, 0x76, 0x04, 0xFF, 0xFD, 0x07, 0x50, 0x4F, 0xA8, 0x00, 0xEF, 0xF0, 0x54, 0x04,
  0xF9, 0x04, 0x58, 0x12, 0x5A, 0xFB, 0x0E, 0x01, 0x30, 0x4F, 0x90, 0x47, 0x10, 0x20, 0xCF, 0xA0,
  0x93, 0x04, 0xF9, 0x04, 0x73, 0x0B, 0xFA, 0x01, 0x20, 0x4F, 0x90, 0x47, 0x40, 0xDF, 0x90, 0x82,
  0x04, 0xF9, 0x04, 0x74, 0x05, 0xF9, 0x0D, 0x20, 0x4F, 0x90, 0x47, 0x50, 0xDF, 0x98, 0x12, 0x04,
  0xF9, 0x04, 0x75, 0x08, 0xF9, 0x81, 0x70, 0x4F, 0x90, 0x47, 0x50, 0x4F, 0x98, 0x1A, 0x04, 0xF9,
  0x04, 0x75, 0x01, 0xF9, 0x81, 0xC0, 0x4F, 0x90, 0x47, 0x60, 0xEF, 0x81, 0xE0, 0x4F, 0x90, 0x47,
  0x60, 0xCF, 0x91, 0x04, 0xF9, 0x04, 0x76, 0x0B, 0xF9, 0x02, 0x04, 0xF9, 0x04, 0x76, 0x0A, 0xF9,
  0x02, 0x04, 0xF9, 0x04, 0x76, 0x09, 0xF9, 0x03, 0x04, 0xF9, 0x04, 0x76, 0x0A, 0xF9, 0x02, 0x04,
  0xF9, 0x04, 0x76, 0x0B, 0xF9, 0x02, 0x04, 0xF9, 0x04, 0x76, 0x0B, 0xF9, 0x01, 0x04, 0xF9, 0x04,
  0x76, 0x0D, 0xF9, 0x10, 0x4F, 0x90, 0x47, 0x6F, 0x98, 0x1D, 0x04, 0xF9, 0x04, 0x75, 0x02, 0xF9,
  0x81, 0xA0, 0x4F, 0x90, 0x47, 0x50, 0x6F, 0x98, 0x18, 0x04, 0xF9, 0x04, 0x75, 0x0B, 0xF9, 0x81,
  0x40, 0x4F, 0x90, 0x47, 0x40, 0x1F, 0x90, 0xE2, 0x04, 0xF9, 0x04, 0x74, 0x09, 0xF9, 0x0A, 0x20,
  0x4F, 0x90, 0x47, 0x30, 0x3F, 0xA0, 0x42, 0x04, 0xF9, 0x04, 0x72, 0x02, 0x0E, 0xF9, 0x0C, 0x30,
  0x4F, 0x90, 0x47, 0x10, 0x60, 0xEF, 0xA0, 0x43, 0x04, 0xF9, 0x04, 0x48, 0x21, 0x38, 0xDF, 0xB0,
  0x94, 0x04, 0xFA, 0x0F, 0xEF, 0xF0, 0xD0, 0x14, 0x04, 0xFF, 0xFC, 0x0E, 0x02, 0x50, 0x4F, 0xFF,
  0xB0, 0xD0, 0x26, 0x04, 0xFF, 0xFA, 0x0B, 0x01, 0x70, 0x4F, 0xFF, 0x0E, 0x06, 0x72, 0x04, 0xFF,
  0xD0, 0xC0, 0x67, 0x40, 0x4F, 0xE8, 0x4E, 0xDC, 0x96, 0x27, 0x60,
  // "ď" (U+010F)
  0x77, 0x60, 0xCF, 0x0A, 0x20, 0x4F, 0x0B, 0x77, 0x60, 0xCF, 0x0A, 0x20, 0x6F, 0x05, 0x77, 0x60,
  0xCF, 0x0A, 0x20, 0x9E, 0x0D, 0x77, 0x70, 0xCF, 0x0A, 0x20, 0xCE, 0x05, 0x77, 0x70, 0xCF, 0x0A,
  0x2E, 0x0C, 0x77, 0x71, 0x0C, 0xF8, 0x1A, 0x04, 0xE0, 0x37, 0x77, 0x10, 0xCF, 0x81, 0xA0, 0x7D,
  0x0A, 0x77, 0x72, 0x0C, 0xF8, 0x1A, 0x0C, 0xC0, 0xE0, 0x17, 0x77, 0x20, 0xCF, 0x0A, 0x1D, 0x05,
  0x77, 0x73, 0x0C, 0xF0, 0xA7, 0x77, 0x73, 0x0C, 0xF0, 0xA7, 0x77, 0x73, 0x0B, 0xF0, 0xA7, 0x76,
  0x84, 0x25, 0x67, 0x64, 0x50, 0xAF, 0x0A, 0x77, 0x40, 0x60, 0xDF, 0x09, 0x01, 0x20, 0x9F, 0x0A,
  0x77, 0x20, 0x20, 0xCF, 0xB8, 0x2E, 0x30, 0x7F, 0x0A, 0x77, 0x10, 0x20, 0xEF, 0xE0, 0x30, 0x5F,
  0x0A, 0x77, 0x10, 0xDF, 0xF0, 0xE0, 0x5F, 0x0A, 0x77, 0x09, 0xFF, 0xA0, 0xEF, 0x0A, 0x76, 0x02,
  0xFF, 0xFC, 0x0A, 0x76, 0x09, 0xFA, 0x84, 0xEA, 0x77, 0x9E, 0xFB, 0x0A, 0x76, 0x0E, 0xF9, 0x0C,
  0x01, 0x50, 0x9F, 0xA0, 0xA7, 0x50, 0x3F, 0x90, 0xE0, 0x17, 0x0B, 0xF9, 0x0A, 0x75, 0x08, 0xF9,
  0x08, 0x71, 0x03, 0xF9, 0x0A, 0x75, 0x0B, 0xF9, 0x02, 0x72, 0x0D, 0xF0, 0xA7, 0x50, 0xDF, 0x0E,
  0x73, 0x09, 0xF0, 0xA7, 0x5F, 0x90, 0xC7, 0x30, 0x6F, 0x0A, 0x74, 0x01, 0xF9, 0x0B, 0x73, 0x04,
  0xF0, 0xA7, 0x40, 0x2F, 0x90, 0xA7, 0x30, 0x3F, 0x0A, 0x74, 0x02, 0xF9, 0x09, 0x73, 0x02, 0xF0,
  0xA7, 0x40, 0x3F, 0x90, 0xA7, 0x30, 0x2F, 0x0A, 0x74, 0x02, 0xF9, 0x0A, 0x73, 0x02, 0xF0, 0xA7,
  0x40, 0x1F, 0x90, 0xB7, 0x30, 0x3F, 0x0A, 0x75, 0xF9, 0x0D, 0x73, 0x05, 0xF0, 0xA7, 0x50, 0xDF,
  0x97, 0x30, 0x7F, 0x0A, 0x75, 0x0B, 0xF9, 0x04, 0x72, 0x0C, 0xF0, 0xA7, 0x50, 0x8F, 0x90, 0xA7,
  0x10, 0x3F, 0x90, 0xA7, 0x50, 0x4F, 0xA0, 0x37, 0x0C, 0xF9, 0x0A, 0x76, 0x0E, 0xF9, 0x0D, 0x02,
  0x40, 0x10, 0xBF, 0xA0, 0xA7, 0x60, 0x9F, 0xB8, 0x3A, 0x77, 0xAE, 0xFB, 0x0A, 0x76, 0x03, 0xFF,
  0xFC, 0x0A, 0x77, 0x0A, 0xFF, 0xA0, 0xEF, 0x0A, 0x77, 0x01, 0x0E, 0xFF, 0x00, 0x6F, 0x0A, 0x77,
  0x10, 0x4F, 0xE0, 0x92, 0x0E, 0xE0, 0xA7, 0x72, 0x04, 0x0E, 0xFB, 0x08, 0x30, 0x8E, 0x0A, 0x77,
  0x38, 0x11, 0x9E, 0xE0, 0xB0, 0x34, 0x02, 0xE0, 0xA7, 0x76, 0x84, 0x46, 0x77, 0x51, 0x77, 0x74,
  // "Đ" (U+0110)
  0x20, 0x4F, 0xF8, 0x3E, 0xDB, 0x84, 0x77, 0x10, 0x4F, 0xFD, 0x81, 0xEA, 0x37, 0x50, 0x4F, 0xFF,
  0x90, 0xA0, 0x27, 0x30, 0x4F, 0xFF, 0xA0, 0xE0, 0x57, 0x20, 0x4F, 0xFF, 0xC0, 0x77, 0x10, 0x4F,
  0xFF, 0xD0, 0x77, 0x04, 0xFA, 0x80, 0x0E, 0xFF, 0x05, 0x60, 0x4F, 0x90, 0x45, 0x81, 0x25, 0xAF,
  0xB0, 0xE0, 0x15, 0x04, 0xF9, 0x04, 0x71, 0x02, 0x0C, 0xFA, 0x09, 0x50, 0x4F, 0x90, 0x47, 0x30,
  0xBF, 0xA0, 0x14, 0x04, 0xF9, 0x04, 0x74, 0x0D, 0xF9, 0x08, 0x40, 0x4F, 0x90, 0x47, 0x40, 0x5F,
  0x90, 0xD4, 0x04, 0xF9, 0x04, 0x75, 0x0D, 0xF9, 0x02, 0x30, 0x4F, 0x90, 0x47, 0x50, 0x8F, 0x90,
  0x73, 0x04, 0xF9, 0x04, 0x75, 0x04, 0xF9, 0x0A, 0x30, 0x4F, 0x90, 0x47, 0x50, 0x1F, 0x90, 0xC3,
  0x04, 0xF9, 0x04, 0x76, 0x0E, 0xF0, 0xE3, 0x04, 0xF9, 0x04, 0x76, 0x0C, 0xF9, 0x10, 0x0E, 0xFB,
  0x80, 0x1E, 0x09, 0x70, 0xBF, 0x90, 0x2F, 0xFB, 0x09, 0x70, 0xAF, 0x90, 0x2F, 0xFB, 0x09, 0x70,
  0x9F, 0x90, 0x3F, 0xFB, 0x09, 0x70, 0xAF, 0x90, 0x2F, 0xFB, 0x09, 0x70, 0xBF, 0x90, 0x2F, 0xFB,
  0x09, 0x70, 0xBF, 0x90, 0x1F, 0xFB, 0x09, 0x70, 0xDF, 0x93, 0x04, 0xF9, 0x04, 0x76, 0xF9, 0x0D,
  0x30, 0x4F, 0x90, 0x47, 0x50, 0x2F, 0x90, 0xA3, 0x04, 0xF9, 0x04, 0x75, 0x06, 0xF9, 0x08, 0x30,
  0x4F, 0x90, 0x47, 0x50, 0xBF, 0x90, 0x43, 0x04, 0xF9, 0x04, 0x74, 0x01, 0xF9, 0x0E, 0x40, 0x4F,
  0x90, 0x47, 0x40, 0x9F, 0x90, 0xA4, 0x04, 0xF9, 0x04, 0x73, 0x03, 0xFA, 0x04, 0x40, 0x4F, 0x90,
  0x47, 0x20, 0x20, 0xEF, 0x90, 0xC5, 0x04, 0xF9, 0x04, 0x71, 0x06, 0x0E, 0xFA, 0x04, 0x50, 0x4F,
  0x90, 0x44, 0x82, 0x13, 0x8D, 0xFB, 0x09, 0x60, 0x4F, 0xA0, 0xFE, 0xFF, 0x0D, 0x01, 0x60, 0x4F,
  0xFF, 0xC0, 0xE0, 0x27, 0x04, 0xFF, 0xFB, 0x0D, 0x02, 0x71, 0x04, 0xFF, 0xFA, 0x0B, 0x01, 0x72,
  0x04, 0xFF, 0xF0, 0xE0, 0x67, 0x40, 0x4F, 0xFD, 0x0C, 0x06, 0x76, 0x04, 0xFE, 0x84, 0xED, 0xC9,
  0x62, 0x76,
  // "đ" (U+0111)
  0x77, 0x71, 0x0C, 0xF0, 0xA7, 0x77, 0x40, 0xCF, 0x0A, 0x77, 0x74, 0x0C, 0xF0, 0xA7, 0x77, 0x40,
  0xCF, 0x0A, 0x77, 0x20, 0x5F, 0xFE, 0x76, 0x05, 0xFF, 0xE7, 0x60, 0x5F, 0xFE, 0x76, 0x05, 0xFF,
  0xE7, 0x60, 0x5F, 0xFE, 0x76, 0x05, 0xFF, 0xE7, 0x77, 0x10, 0xCF, 0x0A, 0x77, 0x74, 0x0C, 0xF0,
  0xA7, 0x77, 0x40, 0xBF, 0x0A, 0x74, 0x89, 0x03, 0x8B, 0xDE, 0xFE, 0xC9, 0x44, 0x0A, 0xF0, 0xA7,
  0x20, 0x30, 0xCF, 0xB0, 0xD0, 0x52, 0x09, 0xF0, 0xA7, 0x10, 0x7F, 0xF8, 0x19, 0x07, 0xF0, 0xA7,
  0x09, 0xFF, 0xA0, 0x90, 0x4F, 0x0A, 0x60, 0x6F, 0xFC, 0x0A, 0xF0, 0xA5, 0x01, 0x0E, 0xFF, 0xFD,
  0x0A, 0x50, 0x9F, 0xFF, 0xE0, 0xA4, 0x01, 0xFB, 0x81, 0xE7, 0x23, 0x03, 0x0A, 0xFB, 0x0A, 0x40,
  0x6F, 0xA0, 0xB0, 0x17, 0x06, 0xFA, 0x0A, 0x40, 0xBF, 0x90, 0xD7, 0x30, 0x9F, 0x90, 0xA4, 0xFA,
  0x05, 0x73, 0x02, 0xF9, 0x0A, 0x30, 0x2F, 0x90, 0xE7, 0x50, 0xBF, 0x0A, 0x30, 0x5F, 0x90, 0xA7,
  0x50, 0x8F, 0x0A, 0x30, 0x7F, 0x90, 0x77, 0x50, 0x5F, 0x0A, 0x30, 0x8F, 0x90, 0x57, 0x50, 0x4F,
  0x0A, 0x30, 0x8F, 0x90, 0x47, 0x50, 0x3F, 0x0A, 0x30, 0x9F, 0x90, 0x37, 0x50, 0x2F, 0x0A, 0x30,
  0x8F, 0x90, 0x47, 0x50, 0x2F, 0x0A, 0x30, 0x7F, 0x90, 0x47, 0x50, 0x3F, 0x0A, 0x30, 0x6F, 0x90,
  0x67, 0x50, 0x4F, 0x0A, 0x30, 0x4F, 0x90, 0x97, 0x50, 0x7F, 0x0A, 0x30, 0x1F, 0x90, 0xE7, 0x50,
  0xCF, 0x0A, 0x40, 0xEF, 0x90, 0x57, 0x30, 0x3F, 0x90, 0xA4, 0x09, 0xF9, 0x0D, 0x01, 0x71, 0x01,
  0x0D, 0xF9, 0x0A, 0x40, 0x5F, 0xA0, 0xD0, 0x46, 0x03, 0x0D, 0xFA, 0x0A, 0x50, 0xEF, 0xB8, 0x4D,
  0x97, 0x79, 0xCF, 0xC0, 0xA5, 0x07, 0xFF, 0xFE, 0x0A, 0x60, 0xDF, 0xFC, 0x0E, 0xF0, 0xA6, 0x03,
  0xFF, 0xB0, 0x06, 0xF0, 0xA7, 0x04, 0xFF, 0x90, 0x82, 0x0E, 0xE0, 0xA7, 0x10, 0x30, 0xDF, 0xC0,
  0xE0, 0x63, 0x08, 0xE0, 0xA7, 0x30, 0x70, 0xDF, 0x81, 0xE8, 0x14, 0x02, 0xE0, 0xA7, 0x58, 0x52,
  0x56, 0x77, 0x52, 0x77, 0x40,
  // "Ē" (U+0112)
  0x40, 0x1F, 0xFC, 0x01, 0x71, 0x01, 0xFF, 0xC0, 0x17, 0x10, 0x1F, 0xFC, 0x01, 0x71, 0x01, 0xFF,
  0xC0, 0x17, 0x10, 0x1F, 0xFC, 0x01, 0x71, 0x01, 0xFF, 0xC0, 0x18, 0x0A, 0x94, 0x00, 0x3F, 0xFF,
  0xD0, 0xC0, 0x3F, 0xFF, 0xD0, 0xC0, 0x3F, 0xFF, 0xD0, 0xC0, 0x3F, 0xFF, 0xD0, 0xC0, 0x3F, 0xFF,
  0xD0, 0xC0, 0x3F, 0xFF, 0xD0, 0xC0, 0x3F, 0x98, 0x09, 0x6E, 0x0B, 0x03, 0xF9, 0x03, 0x77, 0x40,
  0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03,
  0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03,
  0xF9, 0x03, 0x77, 0x40, 0x3F, 0xFF, 0xC8, 0x1E, 0x03, 0xFF, 0xFC, 0x81, 0xE0, 0x3F, 0xFF, 0xC8,
  0x1E, 0x03, 0xFF, 0xFC, 0x81, 0xE0, 0x3F, 0xFF, 0xC8, 0x1E, 0x03, 0xFF, 0xFC, 0x81, 0xE0, 0x3F,
  0x98, 0x09, 0x5E, 0x81, 0xD0, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90,
  0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40,
  0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03,
  0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x98, 0x09, 0x6E, 0x0B,
  0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C,
  0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C,
  // "ē" (U+0113)
  0x60, 0x1F, 0xFC, 0x01, 0x73, 0x01, 0xFF, 0xC0, 0x17, 0x30, 0x1F, 0xFC, 0x01, 0x73, 0x01, 0xFF,
  0xC0, 0x17, 0x30, 0x1F, 0xFC, 0x01, 0x73, 0x01, 0xFF, 0xC0, 0x18, 0x0A, 0x83, 0x08, 0x71, 0x46,
  0x67, 0x65, 0x41, 0x77, 0x48, 0x12, 0x8D, 0xFA, 0x81, 0xC8, 0x27, 0x60, 0x20, 0xAF, 0xF9, 0x0A,
  0x01, 0x73, 0x06, 0x0E, 0xFF, 0xB0, 0xE0, 0x47, 0x10, 0x7F, 0xFF, 0x05, 0x60, 0x6F, 0xFF, 0x90,
  0xE0, 0x24, 0x03, 0xFF, 0xFB, 0x0D, 0x40, 0xCF, 0xB8, 0x4B, 0x87, 0x7A, 0xEF, 0xA0, 0x62, 0x05,
  0xFA, 0x08, 0x01, 0x60, 0x60, 0xEF, 0x0D, 0x20, 0xBF, 0x90, 0x47, 0x20, 0x30, 0xEF, 0x03, 0x01,
  0xF9, 0x07, 0x74, 0x06, 0xF0, 0x70, 0x5F, 0x0E, 0x75, 0x01, 0xF0, 0xA0, 0x9F, 0x0B, 0x76, 0x0D,
  0xE0, 0xC0, 0xBF, 0xFF, 0xF0, 0x0D, 0xFF, 0xFF, 0x90, 0xE8, 0x09, 0xA5, 0xF0, 0xEF, 0xFF, 0xF9,
  0x0D, 0xF0, 0x77, 0x77, 0x0B, 0xF0, 0xA7, 0x77, 0x08, 0xF0, 0xE7, 0x77, 0x04, 0xF9, 0x07, 0x77,
  0x70, 0xEF, 0x90, 0x47, 0x76, 0x09, 0xFA, 0x06, 0x77, 0x10, 0x20, 0x82, 0x02, 0xFB, 0x0C, 0x05,
  0x73, 0x81, 0x48, 0xDA, 0x30, 0x8F, 0xD8, 0x6C, 0x98, 0x77, 0x8A, 0xDE, 0x40, 0xCF, 0xFF, 0xC4,
  0x01, 0x0D, 0xFF, 0xFB, 0x50, 0x10, 0xCF, 0xFF, 0xA7, 0x08, 0xFF, 0xF9, 0x71, 0x02, 0x0A, 0xFF,
  0xC0, 0xD0, 0x77, 0x38, 0x21, 0x6B, 0xEF, 0xC8, 0x1C, 0x83, 0x77, 0x28, 0x90, 0x24, 0x67, 0x77,
  0x66, 0x42, 0x70,
  // "Ĕ" (U+0114)
  0x48, 0x46, 0x77, 0x77, 0x17, 0x28, 0x45, 0x77, 0x77, 0x17, 0x0C, 0xC0, 0x47, 0x20, 0xEC, 0x02,
  0x70, 0xAC, 0x0C, 0x71, 0x07, 0xD7, 0x10, 0x6D, 0x86, 0xD7, 0x21, 0x02, 0x5B, 0xD0, 0xB7, 0x10,
  0x1F, 0xFC, 0x05, 0x72, 0x09, 0xFF, 0xA0, 0xC7, 0x30, 0x10, 0xDF, 0xF0, 0xE0, 0x27, 0x40, 0x20,
  0xDF, 0xD0, 0xE0, 0x37, 0x70, 0x9F, 0xB0, 0xA0, 0x17, 0x72, 0x89, 0x01, 0x7B, 0xDE, 0xFD, 0xB7,
  0x28, 0x09, 0xE5, 0x00, 0x3F, 0xFF, 0xD0, 0xC0, 0x3F, 0xFF, 0xD0, 0xC0, 0x3F, 0xFF, 0xD0, 0xC0,
  0x3F, 0xFF, 0xD0, 0xC0, 0x3F, 0xFF, 0xD0, 0xC0, 0x3F, 0xFF, 0xD0, 0xC0, 0x3F, 0x98, 0x09, 0x6E,
  0x0B, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F,
  0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77,
  0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0xFF, 0xC8, 0x1E, 0x03, 0xFF,
  0xFC, 0x81, 0xE0, 0x3F, 0xFF, 0xC8, 0x1E, 0x03, 0xFF, 0xFC, 0x81, 0xE0, 0x3F, 0xFF, 0xC8, 0x1E,
  0x03, 0xFF, 0xFC, 0x81, 0xE0, 0x3F, 0x98, 0x09, 0x5E, 0x81, 0xD0, 0x3F, 0x90, 0x37, 0x74, 0x03,
  0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37,
  0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F,
  0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77,
  0x40, 0x3F, 0x98, 0x09, 0x6E, 0x0B, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF,
  0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C,
  // "ĕ" (U+0115)
  0x68, 0x46, 0x77, 0x77, 0x17, 0x28, 0x45, 0x77, 0x77, 0x17, 0x20, 0xCC, 0x04, 0x72, 0x0E, 0xC0,
  0x27, 0x20, 0xAC, 0x0C, 0x71, 0x07, 0xD7, 0x30, 0x6D, 0x86, 0xD7, 0x21, 0x02, 0x5B, 0xD0, 0xB7,
  0x30, 0x1F, 0xFC, 0x05, 0x74, 0x09, 0xFF, 0xA0, 0xC7, 0x50, 0x10, 0xDF, 0xF0, 0xE0, 0x27, 0x60,
  0x20, 0xDF, 0xD0, 0xE0, 0x37, 0x72, 0x09, 0xFB, 0x0A, 0x01, 0x77, 0x48, 0x90, 0x17, 0xBD, 0xEF,
  0xDB, 0x72, 0x80, 0x9D, 0x20, 0x87, 0x14, 0x66, 0x76, 0x54, 0x17, 0x74, 0x81, 0x28, 0xDF, 0xA8,
  0x1C, 0x82, 0x76, 0x02, 0x0A, 0xFF, 0x90, 0xA0, 0x17, 0x30, 0x60, 0xEF, 0xFB, 0x0E, 0x04, 0x71,
  0x07, 0xFF, 0xF0, 0x56, 0x06, 0xFF, 0xF9, 0x0E, 0x02, 0x40, 0x3F, 0xFF, 0xB0, 0xD4, 0x0C, 0xFB,
  0x84, 0xB8, 0x77, 0xAE, 0xFA, 0x06, 0x20, 0x5F, 0xA0, 0x80, 0x16, 0x06, 0x0E, 0xF0, 0xD2, 0x0B,
  0xF9, 0x04, 0x72, 0x03, 0x0E, 0xF0, 0x30, 0x1F, 0x90, 0x77, 0x40, 0x6F, 0x07, 0x05, 0xF0, 0xE7,
  0x50, 0x1F, 0x0A, 0x09, 0xF0, 0xB7, 0x60, 0xDE, 0x0C, 0x0B, 0xFF, 0xFF, 0x00, 0xDF, 0xFF, 0xF9,
  0x0E, 0x80, 0x9A, 0x5F, 0x0E, 0xFF, 0xFF, 0x90, 0xDF, 0x07, 0x77, 0x70, 0xBF, 0x0A, 0x77, 0x70,
  0x8F, 0x0E, 0x77, 0x70, 0x4F, 0x90, 0x77, 0x77, 0x0E, 0xF9, 0x04, 0x77, 0x60, 0x9F, 0xA0, 0x67,
  0x71, 0x02, 0x08, 0x20, 0x2F, 0xB0, 0xC0, 0x57, 0x38, 0x14, 0x8D, 0xA3, 0x08, 0xFD, 0x86, 0xC9,
  0x87, 0x78, 0xAD, 0xE4, 0x0C, 0xFF, 0xFC, 0x40, 0x10, 0xDF, 0xFF, 0xB5, 0x01, 0x0C, 0xFF, 0xFA,
  0x70, 0x8F, 0xFF, 0x97, 0x10, 0x20, 0xAF, 0xFC, 0x0D, 0x07, 0x73, 0x82, 0x16, 0xBE, 0xFC, 0x81,
  0xC8, 0x37, 0x72, 0x89, 0x02, 0x46, 0x77, 0x76, 0x64, 0x27,
  // "Ė" (U+0116)
  0x73, 0x81, 0x29, 0xDA, 0x81, 0xD9, 0x27, 0x75, 0x03, 0x0E, 0xE0, 0xE0, 0x37, 0x74, 0x0D, 0xF9,
  0x0C, 0x77, 0x30, 0x2F, 0xB0, 0x17, 0x72, 0x04, 0xFB, 0x03, 0x77, 0x20, 0x4F, 0xB0, 0x37, 0x72,
  0x02, 0xFB, 0x01, 0x77, 0x30, 0xDF, 0x90, 0xB7, 0x74, 0x04, 0xF0, 0xE0, 0x27, 0x75, 0x81, 0x29,
  0xDA, 0x81, 0xD8, 0x18, 0x09, 0xE6, 0x00, 0x3F, 0xFF, 0xD0, 0xC0, 0x3F, 0xFF, 0xD0, 0xC0, 0x3F,
  0xFF, 0xD0, 0xC0, 0x3F, 0xFF, 0xD0, 0xC0, 0x3F, 0xFF, 0xD0, 0xC0, 0x3F, 0xFF, 0xD0, 0xC0, 0x3F,
  0x98, 0x09, 0x6E, 0x0B, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03,
  0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03,
  0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0xFF, 0xC8,
  0x1E, 0x03, 0xFF, 0xFC, 0x81, 0xE0, 0x3F, 0xFF, 0xC8, 0x1E, 0x03, 0xFF, 0xFC, 0x81, 0xE0, 0x3F,
  0xFF, 0xC8, 0x1E, 0x03, 0xFF, 0xFC, 0x81, 0xE0, 0x3F, 0x98, 0x09, 0x5E, 0x81, 0xD0, 0x3F, 0x90,
  0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40,
  0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03,
  0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03,
  0xF9, 0x03, 0x77, 0x40, 0x3F, 0x98, 0x09, 0x6E, 0x0B, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD,
  0x0C, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD,
  0x0C,
  // "ė" (U+0117)
  0x75, 0x81, 0x29, 0xDA, 0x81, 0xD9, 0x27, 0x77, 0x03, 0x0E, 0xE0, 0xE0, 0x37, 0x76, 0x0D, 0xF9,
  0x0C, 0x77, 0x50, 0x2F, 0xB0, 0x17, 0x74, 0x04, 0xFB, 0x03, 0x77, 0x40, 0x4F, 0xB0, 0x37, 0x74,
  0x02, 0xFB, 0x01, 0x77, 0x50, 0xDF, 0x90, 0xB7, 0x76, 0x04, 0xF0, 0xE0, 0x27, 0x77, 0x81, 0x29,
  0xDA, 0x81, 0xD8, 0x18, 0x09, 0xD3, 0x08, 0x71, 0x46, 0x67, 0x65, 0x41, 0x77, 0x48, 0x12, 0x8D,
  0xFA, 0x81, 0xC8, 0x27, 0x60, 0x20, 0xAF, 0xF9, 0x0A, 0x01, 0x73, 0x06, 0x0E, 0xFF, 0xB0, 0xE0,
  0x47, 0x10, 0x7F, 0xFF, 0x05, 0x60, 0x6F, 0xFF, 0x90, 0xE0, 0x24, 0x03, 0xFF, 0xFB, 0x0D, 0x40,
  0xCF, 0xB8, 0x4B, 0x87, 0x7A, 0xEF, 0xA0, 0x62, 0x05, 0xFA, 0x08, 0x01, 0x60, 0x60, 0xEF, 0x0D,
  0x20, 0xBF, 0x90, 0x47, 0x20, 0x30, 0xEF, 0x03, 0x01, 0xF9, 0x07, 0x74, 0x06, 0xF0, 0x70, 0x5F,
  0x0E, 0x75, 0x01, 0xF0, 0xA0, 0x9F, 0x0B, 0x76, 0x0D, 0xE0, 0xC0, 0xBF, 0xFF, 0xF0, 0x0D, 0xFF,
  0xFF, 0x90, 0xE8, 0x09, 0xA5, 0xF0, 0xEF, 0xFF, 0xF9, 0x0D, 0xF0, 0x77, 0x77, 0x0B, 0xF0, 0xA7,
  0x77, 0x08, 0xF0, 0xE7, 0x77, 0x04, 0xF9, 0x07, 0x77, 0x70, 0xEF, 0x90, 0x47, 0x76, 0x09, 0xFA,
  0x06, 0x77, 0x10, 0x20, 0x82, 0x02, 0xFB, 0x0C, 0x05, 0x73, 0x81, 0x48, 0xDA, 0x30, 0x8F, 0xD8,
  0x6C, 0x98, 0x77, 0x8A, 0xDE, 0x40, 0xCF, 0xFF, 0xC4, 0x01, 0x0D, 0xFF, 0xFB, 0x50, 0x10, 0xCF,
  0xFF, 0xA7, 0x08, 0xFF, 0xF9, 0x71, 0x02, 0x0A, 0xFF, 0xC0, 0xD0, 0x77, 0x38, 0x21, 0x6B, 0xEF,
  0xC8, 0x1C, 0x83, 0x77, 0x28, 0x90, 0x24, 0x67, 0x77, 0x66, 0x42, 0x70,
  // "Ę" (U+0118)
  0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C,
  0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xF9, 0x80, 0x96, 0xE0, 0xB0, 0x3F, 0x90,
  0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40,
  0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03,
  0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xFF, 0xFC, 0x81, 0xE0, 0x3F, 0xFF, 0xC8, 0x1E, 0x03,
  0xFF, 0xFC, 0x81, 0xE0, 0x3F, 0xFF, 0xC8, 0x1E, 0x03, 0xFF, 0xFC, 0x81, 0xE0, 0x3F, 0xFF, 0xC8,
  0x1E, 0x03, 0xF9, 0x80, 0x95, 0xE8, 0x1D, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74,
  0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90,
  0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40,
  0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x80,
  0x96, 0xE0, 0xB0, 0x3F, 0xFF, 0xD0, 0xC0, 0x3F, 0xFF, 0xD0, 0xC0, 0x3F, 0xFF, 0xD0, 0xC0, 0x3F,
  0xFF, 0xD0, 0xC0, 0x3F, 0xFF, 0xD0, 0xC0, 0x3F, 0xFF, 0xD0, 0xC7, 0x74, 0x03, 0x0E, 0xC0, 0x37,
  0x76, 0x04, 0xD0, 0x57, 0x76, 0x03, 0xD0, 0x77, 0x77, 0x0D, 0xC0, 0xC7, 0x77, 0x07, 0xD0, 0x47,
  0x77, 0x0D, 0xD7, 0x77, 0x02, 0xD0, 0xD7, 0x77, 0x03, 0xE7, 0x77, 0x03, 0xE8, 0x3A, 0x10, 0x25,
  0x77, 0x3F, 0xC7, 0x73, 0x0A, 0xFB, 0x77, 0x30, 0x20, 0xEF, 0xA7, 0x74, 0x03, 0x0E, 0xF9, 0x77,
  0x68, 0x16, 0xBE, 0xA8, 0x1D, 0xB7, 0x20,
  // "ę" (U+0119)
  0x74, 0x87, 0x14, 0x66, 0x76, 0x54, 0x17, 0x74, 0x81, 0x28, 0xDF, 0xA8, 0x1C, 0x82, 0x76, 0x02,
  0x0A, 0xFF, 0x90, 0xA0, 0x17, 0x30, 0x60, 0xEF, 0xFB, 0x0E, 0x04, 0x71, 0x07, 0xFF, 0xF0, 0x56,
  0x06, 0xFF, 0xF9, 0x0E, 0x02, 0x40, 0x3F, 0xFF, 0xB0, 0xD4, 0x0C, 0xFB, 0x84, 0xB8, 0x77, 0xAE,
  0xFA, 0x06, 0x20, 0x5F, 0xA0, 0x80, 0x16, 0x06, 0x0E, 0xF0, 0xD2, 0x0B, 0xF9, 0x04, 0x72, 0x03,
  0x0E, 0xF0, 0x30, 0x1F, 0x90, 0x77, 0x40, 0x6F, 0x07, 0x05, 0xF0, 0xE7, 0x50, 0x1F, 0x0A, 0x09,
  0xF0, 0xB7, 0x60, 0xDE, 0x0C, 0x0B, 0xFF, 0xFF, 0x00, 0xDF, 0xFF, 0xF9, 0x0E, 0x80, 0x9A, 0x5F,
  0x0E, 0xFF, 0xFF, 0x90, 0xDF, 0x07, 0x77, 0x70, 0xBF, 0x0A, 0x77, 0x70, 0x8F, 0x0E, 0x77, 0x70,
  0x4F, 0x90, 0x77, 0x77, 0x0E, 0xF9, 0x04, 0x77, 0x60, 0x9F, 0xA0, 0x67, 0x71, 0x02, 0x08, 0x20,
  0x2F, 0xB0, 0xC0, 0x57, 0x38, 0x14, 0x8D, 0xA3, 0x08, 0xFD, 0x86, 0xC9, 0x87, 0x78, 0xAD, 0xE4,
  0x0C, 0xFF, 0xFC, 0x40, 0x10, 0xDF, 0xFF, 0xB5, 0x01, 0x0C, 0xFF, 0xFA, 0x70, 0x8F, 0xFF, 0x97,
  0x10, 0x20, 0xAF, 0xFD, 0x09, 0x73, 0x82, 0x16, 0xBE, 0xFE, 0x0E, 0x05, 0x77, 0x18, 0x52, 0x46,
  0x77, 0x78, 0xD0, 0xE0, 0x27, 0x77, 0x10, 0xAC, 0x0E, 0x02, 0x77, 0x71, 0x06, 0xD0, 0x47, 0x77,
  0x10, 0x10, 0xEC, 0x0B, 0x77, 0x72, 0x07, 0xD0, 0x47, 0x77, 0x20, 0xCD, 0x01, 0x77, 0x72, 0x0E,
  0xD0, 0x17, 0x77, 0x2E, 0x04, 0x77, 0x72, 0xE8, 0x4D, 0x30, 0x14, 0x17, 0x74, 0x0C, 0xFB, 0x03,
  0x77, 0x40, 0x6F, 0xB0, 0x37, 0x75, 0x0C, 0xFA, 0x03, 0x77, 0x50, 0x10, 0xBF, 0x90, 0x37, 0x77,
  0x87, 0x4A, 0xDE, 0xFD, 0xB8, 0x11,
  // "Ě" (U+011A)
  0x38, 0x01, 0x70, 0x57, 0x30, 0x58, 0x01, 0x76, 0x0B, 0xD0, 0x97, 0x10, 0x9D, 0x0B, 0x70, 0xCD,
  0x0C, 0x01, 0x40, 0x20, 0xCD, 0x0D, 0x01, 0x70, 0x10, 0xED, 0x0D, 0x02, 0x20, 0x30, 0xED, 0x0E,
  0x02, 0x72, 0x04, 0xE8, 0x2E, 0x23, 0xEE, 0x04, 0x74, 0x07, 0xE0, 0xD0, 0xEE, 0x08, 0x76, 0x0B,
  0xFD, 0x0B, 0x77, 0x01, 0x0E, 0xFB, 0x0E, 0x01, 0x77, 0x10, 0x5F, 0xB0, 0x57, 0x73, 0x0A, 0xF9,
  0x0A, 0x80, 0x9E, 0x50, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C,
  0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xF9, 0x80, 0x96,
  0xE0, 0xB0, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03,
  0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37,
  0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xFF, 0xFC, 0x81, 0xE0, 0x3F,
  0xFF, 0xC8, 0x1E, 0x03, 0xFF, 0xFC, 0x81, 0xE0, 0x3F, 0xFF, 0xC8, 0x1E, 0x03, 0xFF, 0xFC, 0x81,
  0xE0, 0x3F, 0xFF, 0xC8, 0x1E, 0x03, 0xF9, 0x80, 0x95, 0xE8, 0x1D, 0x03, 0xF9, 0x03, 0x77, 0x40,
  0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03,
  0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03,
  0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x40, 0x3F, 0x90, 0x37,
  0x74, 0x03, 0xF9, 0x80, 0x96, 0xE0, 0xB0, 0x3F, 0xFF, 0xD0, 0xC0, 0x3F, 0xFF, 0xD0, 0xC0, 0x3F,
  0xFF, 0xD0, 0xC0, 0x3F, 0xFF, 0xD0, 0xC0, 0x3F, 0xFF, 0xD0, 0xC0, 0x3F, 0xFF, 0xD0, 0xC0,
  // "ě" (U+011B)
  0x58, 0x01, 0x70, 0x57, 0x30, 0x58, 0x01, 0x77, 0x10, 0xBD, 0x09, 0x71, 0x09, 0xD0, 0xB7, 0x20,
  0xCD, 0x0C, 0x01, 0x40, 0x20, 0xCD, 0x0D, 0x01, 0x72, 0x01, 0x0E, 0xD0, 0xD0, 0x22, 0x03, 0x0E,
  0xD0, 0xE0, 0x27, 0x40, 0x4E, 0x82, 0xE2, 0x3E, 0xE0, 0x47, 0x60, 0x7E, 0x0D, 0x0E, 0xE0, 0x87,
  0x71, 0x0B, 0xFD, 0x0B, 0x77, 0x20, 0x10, 0xEF, 0xB0, 0xE0, 0x17, 0x73, 0x05, 0xFB, 0x05, 0x77,
  0x50, 0xAF, 0x90, 0xA8, 0x09, 0xD2, 0x08, 0x71, 0x46, 0x67, 0x65, 0x41, 0x77, 0x48, 0x12, 0x8D,
  0xFA, 0x81, 0xC8, 0x27, 0x60, 0x20, 0xAF, 0xF9, 0x0A, 0x01, 0x73, 0x06, 0x0E, 0xFF, 0xB0, 0xE0,
  0x47, 0x10, 0x7F, 0xFF, 0x05, 0x60, 0x6F, 0xFF, 0x90, 0xE0, 0x24, 0x03, 0xFF, 0xFB, 0x0D, 0x40,
  0xCF, 0xB8, 0x4B, 0x87, 0x7A, 0xEF, 0xA0, 0x62, 0x05, 0xFA, 0x08, 0x01, 0x60, 0x60, 0xEF, 0x0D,
  0x20, 0xBF, 0x90, 0x47, 0x20, 0x30, 0xEF, 0x03, 0x01, 0xF9, 0x07, 0x74, 0x06, 0xF0, 0x70, 0x5F,
  0x0E, 0x75, 0x01, 0xF0, 0xA0, 0x9F, 0x0B, 0x76, 0x0D, 0xE0, 0xC0, 0xBF, 0xFF, 0xF0, 0x0D, 0xFF,
  0xFF, 0x90, 0xE8, 0x09, 0xA5, 0xF0, 0xEF, 0xFF, 0xF9, 0x0D, 0xF0, 0x77, 0x77, 0x0B, 0xF0, 0xA7,
  0x77, 0x08, 0xF0, 0xE7, 0x77, 0x04, 0xF9, 0x07, 0x77, 0x70, 0xEF, 0x90, 0x47, 0x76, 0x09, 0xFA,
  0x06, 0x77, 0x10, 0x20, 0x82, 0x02, 0xFB, 0x0C, 0x05, 0x73, 0x81, 0x48, 0xDA, 0x30, 0x8F, 0xD8,
  0x6C, 0x98, 0x77, 0x8A, 0xDE, 0x40, 0xCF, 0xFF, 0xC4, 0x01, 0x0D, 0xFF, 0xFB, 0x50, 0x10, 0xCF,
  0xFF, 0xA7, 0x08, 0xFF, 0xF9, 0x71, 0x02, 0x0A, 0xFF, 0xC0, 0xD0, 0x77, 0x38, 0x21, 0x6B, 0xEF,
  0xC8, 0x1C, 0x83, 0x77, 0x28, 0x90, 0x24, 0x67, 0x77, 0x66, 0x42, 0x70,
  // "Ĝ" (U+011C)
  0x77, 0x02, 0x80, 0x47, 0x06, 0x77, 0x72, 0x0C, 0xFA, 0x04, 0x77, 0x70, 0x7F, 0xB0, 0xD7, 0x76,
  0x03, 0xFD, 0x09, 0x77, 0x40, 0x10, 0xDF, 0xE0, 0x57, 0x73, 0x0A, 0xE0, 0xA0, 0x5E, 0x0E, 0x02,
  0x77, 0x10, 0x7E, 0x0A, 0x20, 0x5E, 0x0D, 0x01, 0x76, 0x04, 0xE0, 0x94, 0x04, 0x0E, 0xD0, 0xB7,
  0x50, 0x30, 0xED, 0x07, 0x60, 0x30, 0xDD, 0x08, 0x74, 0x0C, 0xC0, 0xE0, 0x47, 0x10, 0x10, 0xBD,
  0x02, 0x80, 0x9E, 0x00, 0x89, 0x01, 0x35, 0x67, 0x76, 0x54, 0x27, 0x76, 0x81, 0x39, 0xDF, 0xC8,
  0x1C, 0x84, 0x77, 0x05, 0x0D, 0xFF, 0xB8, 0x1E, 0x82, 0x72, 0x02, 0x0C, 0xFF, 0xF0, 0xB7, 0x10,
  0x50, 0xEF, 0xFF, 0x90, 0x57, 0x06, 0xFF, 0xFA, 0x0D, 0x70, 0x5F, 0xFF, 0xB0, 0x76, 0x02, 0x0E,
  0xFC, 0x86, 0xEA, 0x97, 0x78, 0xAD, 0xD0, 0x16, 0x0B, 0xFB, 0x0B, 0x04, 0x71, 0x83, 0x15, 0xBF,
  0xA6, 0x05, 0xFA, 0x0E, 0x05, 0x76, 0x00, 0x36, 0x0D, 0xF9, 0x0E, 0x03, 0x77, 0x70, 0x4F, 0xA0,
  0x47, 0x77, 0x10, 0xAF, 0x90, 0xA7, 0x77, 0x2F, 0xA0, 0x27, 0x77, 0x10, 0x4F, 0x90, 0xB7, 0x77,
  0x20, 0x8F, 0x90, 0x67, 0x77, 0x20, 0xAF, 0x90, 0x17, 0x77, 0x20, 0xDF, 0x0E, 0x77, 0x73, 0xF9,
  0x0B, 0x77, 0x72, 0x01, 0xF9, 0x0A, 0x71, 0x07, 0x80, 0x91, 0xE0, 0x40, 0x2F, 0x90, 0x97, 0x10,
  0x7F, 0xE0, 0x40, 0x2F, 0x90, 0x87, 0x10, 0x7F, 0xE0, 0x40, 0x3F, 0x90, 0x77, 0x10, 0x7F, 0xE0,
  0x40, 0x2F, 0x90, 0x87, 0x10, 0x7F, 0xE0, 0x40, 0x2F, 0x90, 0x97, 0x10, 0x7F, 0xE0, 0x40, 0x1F,
  0x90, 0xA7, 0x10, 0x7F, 0xE0, 0x41, 0xF9, 0x0D, 0x77, 0x08, 0xF8, 0x14, 0x0D, 0xF9, 0x77, 0x08,
  0xF8, 0x14, 0x0A, 0xF9, 0x03, 0x76, 0x08, 0xF8, 0x14, 0x07, 0xF9, 0x08, 0x76, 0x08, 0xF8, 0x14,
  0x03, 0xF9, 0x0D, 0x76, 0x08, 0xF0, 0x42, 0x0E, 0xF9, 0x06, 0x75, 0x08, 0xF0, 0x42, 0x09, 0xF9,
  0x0D, 0x75, 0x08, 0xF0, 0x42, 0x02, 0xFA, 0x0B, 0x74, 0x08, 0xF0, 0x43, 0x0B, 0xFA, 0x09, 0x73,
  0x08, 0xF0, 0x43, 0x02, 0xFB, 0x0D, 0x05, 0x71, 0x08, 0xF0, 0x44, 0x08, 0xFC, 0x86, 0xEA, 0x87,
  0x78, 0xAD, 0xF9, 0x04, 0x50, 0xCF, 0xFF, 0xD0, 0x45, 0x01, 0x0D, 0xFF, 0xFC, 0x04, 0x60, 0x10,
  0xCF, 0xFF, 0xB0, 0x47, 0x10, 0x9F, 0xFF, 0xA0, 0x47, 0x20, 0x30, 0xBF, 0xFD, 0x81, 0xD7, 0x17,
  0x48, 0x12, 0x7C, 0xFD, 0x82, 0xEA, 0x73, 0x77, 0x48, 0x91, 0x35, 0x67, 0x77, 0x66, 0x53, 0x17,
  // "ĝ" (U+011D)
  0x74, 0x02, 0x80, 0x47, 0x06, 0x77, 0x70, 0xCF, 0xA0, 0x47, 0x75, 0x07, 0xFB, 0x0D, 0x77, 0x40,
  0x3F, 0xD0, 0x97, 0x72, 0x01, 0x0D, 0xFE, 0x05, 0x77, 0x10, 0xAE, 0x0A, 0x05, 0xE0, 0xE0, 0x27,
  0x60, 0x7E, 0x0A, 0x20, 0x5E, 0x0D, 0x01, 0x74, 0x04, 0xE0, 0x94, 0x04, 0x0E, 0xD0, 0xB7, 0x30,
  0x30, 0xED, 0x07, 0x60, 0x30, 0xDD, 0x08, 0x72, 0x0C, 0xC0, 0xE0, 0x47, 0x10, 0x10, 0xBD, 0x02,
  0x80, 0x9C, 0x50, 0x85, 0x14, 0x67, 0x75, 0x37, 0x77, 0x10, 0x50, 0xCF, 0x81, 0xE8, 0x14, 0x02,
  0xE0, 0xA5, 0x01, 0x0C, 0xFC, 0x0E, 0x06, 0x30, 0x8E, 0x0A, 0x40, 0x20, 0xEF, 0xF0, 0x92, 0x0E,
  0xE0, 0xA3, 0x01, 0x0E, 0xFF, 0xA0, 0x80, 0x6F, 0x0A, 0x30, 0xAF, 0xFF, 0xD0, 0xA2, 0x04, 0xFF,
  0xFE, 0x0A, 0x20, 0xCF, 0xB8, 0x4D, 0x97, 0x79, 0xDF, 0xC8, 0x1A, 0x03, 0xFA, 0x0E, 0x05, 0x60,
  0x60, 0xEF, 0xA8, 0x1A, 0x08, 0xFA, 0x03, 0x71, 0x04, 0xFA, 0x81, 0xA0, 0xDF, 0x90, 0x87, 0x30,
  0x9F, 0x90, 0xA1, 0xFA, 0x01, 0x73, 0x03, 0xF9, 0x0A, 0x03, 0xF9, 0x0B, 0x75, 0x0E, 0xF0, 0xA0,
  0x6F, 0x90, 0x87, 0x50, 0xBF, 0x0A, 0x07, 0xF9, 0x05, 0x75, 0x09, 0xF0, 0xA0, 0x7F, 0x90, 0x47,
  0x50, 0x8F, 0x0A, 0x08, 0xF9, 0x03, 0x75, 0x07, 0xF0, 0xA0, 0x8F, 0x90, 0x37, 0x50, 0x7F, 0x0A,
  0x08, 0xF9, 0x04, 0x75, 0x07, 0xF0, 0xA0, 0x7F, 0x90, 0x57, 0x50, 0x8F, 0x0A, 0x06, 0xF9, 0x08,
  0x75, 0x09, 0xF0, 0xA0, 0x3F, 0x90, 0xB7, 0x50, 0xCF, 0x0A, 0x1F, 0xA0, 0x17, 0x30, 0x1F, 0x98,
  0x1A, 0x0D, 0xF9, 0x08, 0x73, 0x08, 0xF9, 0x81, 0xA0, 0x8F, 0xA0, 0x37, 0x10, 0x3F, 0xA8, 0x1A,
  0x03, 0xFA, 0x0E, 0x05, 0x60, 0x40, 0xEF, 0xA0, 0xA2, 0x0C, 0xFB, 0x84, 0xD9, 0x77, 0x9D, 0xFC,
  0x0A, 0x20, 0x4F, 0xFF, 0xE0, 0xA3, 0x0A, 0xFF, 0xFD, 0x0A, 0x30, 0x10, 0xDF, 0xFA, 0x09, 0x0D,
  0xF0, 0xA4, 0x02, 0x0E, 0xFF, 0x81, 0xA0, 0xEF, 0x0A, 0x50, 0x10, 0xBF, 0xD0, 0x82, 0xF9, 0x0A,
  0x70, 0x50, 0xBF, 0x81, 0xE9, 0x23, 0xF9, 0x0A, 0x72, 0x85, 0x14, 0x67, 0x76, 0x35, 0x01, 0xF9,
  0x0A, 0x77, 0x70, 0x2F, 0x90, 0x97, 0x77, 0x04, 0xF9, 0x07, 0x77, 0x70, 0x8F, 0x90, 0x52, 0x01,
  0x02, 0x77, 0x20, 0x10, 0xEF, 0x90, 0x12, 0x83, 0x4F, 0xC6, 0x27, 0x50, 0x20, 0xDF, 0x90, 0xB3,
  0x04, 0xC8, 0x3D, 0x96, 0x41, 0x48, 0x11, 0x49, 0xFB, 0x05, 0x30, 0x4F, 0xFF, 0xC0, 0xC4, 0x04,
  0xFF, 0xFC, 0x03, 0x40, 0x4F, 0xFF, 0xB0, 0x55, 0x04, 0xFF, 0xF9, 0x0E, 0x05, 0x60, 0x4F, 0xFF,
  0x0B, 0x02, 0x78, 0x11, 0x7C, 0xFF, 0xA8, 0x1E, 0xA3, 0x75, 0x86, 0x14, 0x7A, 0xBD, 0xEE, 0xA8,
  0x4E, 0xDC, 0xA7, 0x37, 0x30,
  // "Ğ" (U+011E)
  0x72, 0x84, 0x67, 0x77, 0x71, 0x72, 0x84, 0x57, 0x77, 0x71, 0x75, 0x0C, 0xC0, 0x47, 0x20, 0xEC,
  0x02, 0x75, 0x0A, 0xC0, 0xC7, 0x10, 0x7D, 0x76, 0x06, 0xD8, 0x6D, 0x72, 0x10, 0x25, 0xBD, 0x0B,
  0x76, 0x01, 0xFF, 0xC0, 0x57, 0x70, 0x9F, 0xFA, 0x0C, 0x77, 0x10, 0x10, 0xDF, 0xF0, 0xE0, 0x27,
  0x72, 0x02, 0x0D, 0xFD, 0x0E, 0x03, 0x77, 0x50, 0x9F, 0xB0, 0xA0, 0x17, 0x77, 0x89, 0x01, 0x7B,
  0xDE, 0xFD, 0xB7, 0x28, 0x09, 0xE7, 0x08, 0x90, 0x13, 0x56, 0x77, 0x65, 0x42, 0x77, 0x68, 0x13,
  0x9D, 0xFC, 0x81, 0xC8, 0x47, 0x70, 0x50, 0xDF, 0xFB, 0x81, 0xE8, 0x27, 0x20, 0x20, 0xCF, 0xFF,
  0x0B, 0x71, 0x05, 0x0E, 0xFF, 0xF9, 0x05, 0x70, 0x6F, 0xFF, 0xA0, 0xD7, 0x05, 0xFF, 0xFB, 0x07,
  0x60, 0x20, 0xEF, 0xC8, 0x6E, 0xA9, 0x77, 0x8A, 0xDD, 0x01, 0x60, 0xBF, 0xB0, 0xB0, 0x47, 0x18,
  0x31, 0x5B, 0xFA, 0x60, 0x5F, 0xA0, 0xE0, 0x57, 0x60, 0x03, 0x60, 0xDF, 0x90, 0xE0, 0x37, 0x77,
  0x04, 0xFA, 0x04, 0x77, 0x71, 0x0A, 0xF9, 0x0A, 0x77, 0x72, 0xFA, 0x02, 0x77, 0x71, 0x04, 0xF9,
  0x0B, 0x77, 0x72, 0x08, 0xF9, 0x06, 0x77, 0x72, 0x0A, 0xF9, 0x01, 0x77, 0x72, 0x0D, 0xF0, 0xE7,
  0x77, 0x3F, 0x90, 0xB7, 0x77, 0x20, 0x1F, 0x90, 0xA7, 0x10, 0x78, 0x09, 0x1E, 0x04, 0x02, 0xF9,
  0x09, 0x71, 0x07, 0xFE, 0x04, 0x02, 0xF9, 0x08, 0x71, 0x07, 0xFE, 0x04, 0x03, 0xF9, 0x07, 0x71,
  0x07, 0xFE, 0x04, 0x02, 0xF9, 0x08, 0x71, 0x07, 0xFE, 0x04, 0x02, 0xF9, 0x09, 0x71, 0x07, 0xFE,
  0x04, 0x01, 0xF9, 0x0A, 0x71, 0x07, 0xFE, 0x04, 0x1F, 0x90, 0xD7, 0x70, 0x8F, 0x81, 0x40, 0xDF,
  0x97, 0x70, 0x8F, 0x81, 0x40, 0xAF, 0x90, 0x37, 0x60, 0x8F, 0x81, 0x40, 0x7F, 0x90, 0x87, 0x60,
  0x8F, 0x81, 0x40, 0x3F, 0x90, 0xD7, 0x60, 0x8F, 0x04, 0x20, 0xEF, 0x90, 0x67, 0x50, 0x8F, 0x04,
  0x20, 0x9F, 0x90, 0xD7, 0x50, 0x8F, 0x04, 0x20, 0x2F, 0xA0, 0xB7, 0x40, 0x8F, 0x04, 0x30, 0xBF,
  0xA0, 0x97, 0x30, 0x8F, 0x04, 0x30, 0x2F, 0xB0, 0xD0, 0x57, 0x10, 0x8F, 0x04, 0x40, 0x8F, 0xC8,
  0x6E, 0xA8, 0x77, 0x8A, 0xDF, 0x90, 0x45, 0x0C, 0xFF, 0xFD, 0x04, 0x50, 0x10, 0xDF, 0xFF, 0xC0,
  0x46, 0x01, 0x0C, 0xFF, 0xFB, 0x04, 0x71, 0x09, 0xFF, 0xFA, 0x04, 0x72, 0x03, 0x0B, 0xFF, 0xD8,
  0x1D, 0x71, 0x74, 0x81, 0x27, 0xCF, 0xD8, 0x2E, 0xA7, 0x37, 0x74, 0x89, 0x13, 0x56, 0x77, 0x76,
  0x65, 0x31, 0x70,
  // "ğ" (U+011F)
  0x68, 0x46, 0x77, 0x77, 0x17, 0x28, 0x45, 0x77, 0x77, 0x17, 0x30, 0xCC, 0x04, 0x72, 0x0E, 0xC0,
  0x27, 0x30, 0xAC, 0x0C, 0x71, 0x07, 0xD7, 0x40, 0x6D, 0x86, 0xD7, 0x21, 0x02, 0x5B, 0xD0, 0xB7,
  0x40, 0x1F, 0xFC, 0x05, 0x75, 0x09, 0xFF, 0xA0, 0xC7, 0x60, 0x10, 0xDF, 0xF0, 0xE0, 0x27, 0x70,
  0x20, 0xDF, 0xD0, 0xE0, 0x37, 0x73, 0x09, 0xFB, 0x0A, 0x01, 0x77, 0x58, 0x90, 0x17, 0xBD, 0xEF,
  0xDB, 0x72, 0x80, 0x9D, 0x40, 0x85, 0x14, 0x67, 0x75, 0x37, 0x77, 0x10, 0x50, 0xCF, 0x81, 0xE8,
  0x14, 0x02, 0xE0, 0xA5, 0x01, 0x0C, 0xFC, 0x0E, 0x06, 0x30, 0x8E, 0x0A, 0x40, 0x20, 0xEF, 0xF0,
  0x92, 0x0E, 0xE0, 0xA3, 0x01, 0x0E, 0xFF, 0xA0, 0x80, 0x6F, 0x0A, 0x30, 0xAF, 0xFF, 0xD0, 0xA2,
  0x04, 0xFF, 0xFE, 0x0A, 0x20, 0xCF, 0xB8, 0x4D, 0x97, 0x79, 0xDF, 0xC8, 0x1A, 0x03, 0xFA, 0x0E,
  0x05, 0x60, 0x60, 0xEF, 0xA8, 0x1A, 0x08, 0xFA, 0x03, 0x71, 0x04, 0xFA, 0x81, 0xA0, 0xDF, 0x90,
  0x87, 0x30, 0x9F, 0x90, 0xA1, 0xFA, 0x01, 0x73, 0x03, 0xF9, 0x0A, 0x03, 0xF9, 0x0B, 0x75, 0x0E,
  0xF0, 0xA0, 0x6F, 0x90, 0x87, 0x50, 0xBF, 0x0A, 0x07, 0xF9, 0x05, 0x75, 0x09, 0xF0, 0xA0, 0x7F,
  0x90, 0x47, 0x50, 0x8F, 0x0A, 0x08, 0xF9, 0x03, 0x75, 0x07, 0xF0, 0xA0, 0x8F, 0x90, 0x37, 0x50,
  0x7F, 0x0A, 0x08, 0xF9, 0x04, 0x75, 0x07, 0xF0, 0xA0, 0x7F, 0x90, 0x57, 0x50, 0x8F, 0x0A, 0x06,
  0xF9, 0x08, 0x75, 0x09, 0xF0, 0xA0, 0x3F, 0x90, 0xB7, 0x50, 0xCF, 0x0A, 0x1F, 0xA0, 0x17, 0x30,
  0x1F, 0x98, 0x1A, 0x0D, 0xF9, 0x08, 0x73, 0x08, 0xF9, 0x81, 0xA0, 0x8F, 0xA0, 0x37, 0x10, 0x3F,
  0xA8, 0x1A, 0x03, 0xFA, 0x0E, 0x05, 0x60, 0x40, 0xEF, 0xA0, 0xA2, 0x0C, 0xFB, 0x84, 0xD9, 0x77,
  0x9D, 0xFC, 0x0A, 0x20, 0x4F, 0xFF, 0xE0, 0xA3, 0x0A, 0xFF, 0xFD, 0x0A, 0x30, 0x10, 0xDF, 0xFA,
  0x09, 0x0D, 0xF0, 0xA4, 0x02, 0x0E, 0xFF, 0x81, 0xA0, 0xEF, 0x0A, 0x50, 0x10, 0xBF, 0xD0, 0x82,
  0xF9, 0x0A, 0x70, 0x50, 0xBF, 0x81, 0xE9, 0x23, 0xF9, 0x0A, 0x72, 0x85, 0x14, 0x67, 0x76, 0x35,
  0x01, 0xF9, 0x0A, 0x77, 0x70, 0x2F, 0x90, 0x97, 0x77, 0x04, 0xF9, 0x07, 0x77, 0x70, 0x8F, 0x90,
  0x52, 0x01, 0x02, 0x77, 0x20, 0x10, 0xEF, 0x90, 0x12, 0x83, 0x4F, 0xC6, 0x27, 0x50, 0x20, 0xDF,
  0x90, 0xB3, 0x04, 0xC8, 0x3D, 0x96, 0x41, 0x48, 0x11, 0x49, 0xFB, 0x05, 0x30, 0x4F, 0xFF, 0xC0,
  0xC4, 0x04, 0xFF, 0xFC, 0x03, 0x40, 0x4F, 0xFF, 0xB0, 0x55, 0x04, 0xFF, 0xF9, 0x0E, 0x05, 0x60,
  0x4F, 0xFF, 0x0B, 0x02, 0x78, 0x11, 0x7C, 0xFF, 0xA8, 0x1E, 0xA3, 0x75, 0x86, 0x14, 0x7A, 0xBD,
  0xEE, 0xA8, 0x4E, 0xDC, 0xA7, 0x37, 0x30,
  // "Ġ" (U+0120)
  0x77, 0x18, 0x12, 0x9D, 0xA8, 0x1D, 0x92, 0x77, 0x73, 0x03, 0x0E, 0xE0, 0xE0, 0x37, 0x77, 0x20,
  0xDF, 0x90, 0xC7, 0x77, 0x10, 0x2F, 0xB0, 0x17, 0x77, 0x04, 0xFB, 0x03, 0x77, 0x70, 0x4F, 0xB0,
  0x37, 0x77, 0x02, 0xFB, 0x01, 0x77, 0x71, 0x0D, 0xF9, 0x0B, 0x77, 0x72, 0x04, 0xF0, 0xE0, 0x27,
  0x77, 0x38, 0x12, 0x9D, 0xA8, 0x1D, 0x81, 0x80, 0x9F, 0x00, 0x89, 0x01, 0x35, 0x67, 0x76, 0x54,
  0x27, 0x76, 0x81, 0x39, 0xDF, 0xC8, 0x1C, 0x84, 0x77, 0x05, 0x0D, 0xFF, 0xB8, 0x1E, 0x82, 0x72,
  0x02, 0x0C, 0xFF, 0xF0, 0xB7, 0x10, 0x50, 0xEF, 0xFF, 0x90, 0x57, 0x06, 0xFF, 0xFA, 0x0D, 0x70,
  0x5F, 0xFF, 0xB0, 0x76, 0x02, 0x0E, 0xFC, 0x86, 0xEA, 0x97, 0x78, 0xAD, 0xD0, 0x16, 0x0B, 0xFB,
  0x0B, 0x04, 0x71, 0x83, 0x15, 0xBF, 0xA6, 0x05, 0xFA, 0x0E, 0x05, 0x76, 0x00, 0x36, 0x0D, 0xF9,
  0x0E, 0x03, 0x77, 0x70, 0x4F, 0xA0, 0x47, 0x77, 0x10, 0xAF, 0x90, 0xA7, 0x77, 0x2F, 0xA0, 0x27,
  0x77, 0x10, 0x4F, 0x90, 0xB7, 0x77, 0x20, 0x8F, 0x90, 0x67, 0x77, 0x20, 0xAF, 0x90, 0x17, 0x77,
  0x20, 0xDF, 0x0E, 0x77, 0x73, 0xF9, 0x0B, 0x77, 0x72, 0x01, 0xF9, 0x0A, 0x71, 0x07, 0x80, 0x91,
  0xE0, 0x40, 0x2F, 0x90, 0x97, 0x10, 0x7F, 0xE0, 0x40, 0x2F, 0x90, 0x87, 0x10, 0x7F, 0xE0, 0x40,
  0x3F, 0x90, 0x77, 0x10, 0x7F, 0xE0, 0x40, 0x2F, 0x90, 0x87, 0x10, 0x7F, 0xE0, 0x40, 0x2F, 0x90,
  0x97, 0x10, 0x7F, 0xE0, 0x40, 0x1F, 0x90, 0xA7, 0x10, 0x7F, 0xE0, 0x41, 0xF9, 0x0D, 0x77, 0x08,
  0xF8, 0x14, 0x0D, 0xF9, 0x77, 0x08, 0xF8, 0x14, 0x0A, 0xF9, 0x03, 0x76, 0x08, 0xF8, 0x14, 0x07,
  0xF9, 0x08, 0x76, 0x08, 0xF8, 0x14, 0x03, 0xF9, 0x0D, 0x76, 0x08, 0xF0, 0x42, 0x0E, 0xF9, 0x06,
  0x75, 0x08, 0xF0, 0x42, 0x09, 0xF9, 0x0D, 0x75, 0x08, 0xF0, 0x42, 0x02, 0xFA, 0x0B, 0x74, 0x08,
  0xF0, 0x43, 0x0B, 0xFA, 0x09, 0x73, 0x08, 0xF0, 0x43, 0x02, 0xFB, 0x0D, 0x05, 0x71, 0x08, 0xF0,
  0x44, 0x08, 0xFC, 0x86, 0xEA, 0x87, 0x78, 0xAD, 0xF9, 0x04, 0x50, 0xCF, 0xFF, 0xD0, 0x45, 0x01,
  0x0D, 0xFF, 0xFC, 0x04, 0x60, 0x10, 0xCF, 0xFF, 0xB0, 0x47, 0x10, 0x9F, 0xFF, 0xA0, 0x47, 0x20,
  0x30, 0xBF, 0xFD, 0x81, 0xD7, 0x17, 0x48, 0x12, 0x7C, 0xFD, 0x82, 0xEA, 0x73, 0x77, 0x48, 0x91,
  0x35, 0x67, 0x77, 0x66, 0x53, 0x17,
  // "ġ" (U+0121)
  0x75, 0x81, 0x29, 0xDA, 0x81, 0xD9, 0x27, 0x77, 0x10, 0x30, 0xEE, 0x0E, 0x03, 0x77, 0x70, 0xDF,
  0x90, 0xC7, 0x76, 0x02, 0xFB, 0x01, 0x77, 0x50, 0x4F, 0xB0, 0x37, 0x75, 0x04, 0xFB, 0x03, 0x77,
  0x50, 0x2F, 0xB0, 0x17, 0x76, 0x0D, 0xF9, 0x0B, 0x77, 0x70, 0x4F, 0x0E, 0x02, 0x77, 0x71, 0x81,
  0x29, 0xDA, 0x81, 0xD8, 0x18, 0x09, 0xD5, 0x08, 0x51, 0x46, 0x77, 0x53, 0x77, 0x71, 0x05, 0x0C,
  0xF8, 0x1E, 0x81, 0x40, 0x2E, 0x0A, 0x50, 0x10, 0xCF, 0xC0, 0xE0, 0x63, 0x08, 0xE0, 0xA4, 0x02,
  0x0E, 0xFF, 0x09, 0x20, 0xEE, 0x0A, 0x30, 0x10, 0xEF, 0xFA, 0x08, 0x06, 0xF0, 0xA3, 0x0A, 0xFF,
  0xFD, 0x0A, 0x20, 0x4F, 0xFF, 0xE0, 0xA2, 0x0C, 0xFB, 0x84, 0xD9, 0x77, 0x9D, 0xFC, 0x81, 0xA0,
  0x3F, 0xA0, 0xE0, 0x56, 0x06, 0x0E, 0xFA, 0x81, 0xA0, 0x8F, 0xA0, 0x37, 0x10, 0x4F, 0xA8, 0x1A,
  0x0D, 0xF9, 0x08, 0x73, 0x09, 0xF9, 0x0A, 0x1F, 0xA0, 0x17, 0x30, 0x3F, 0x90, 0xA0, 0x3F, 0x90,
  0xB7, 0x50, 0xEF, 0x0A, 0x06, 0xF9, 0x08, 0x75, 0x0B, 0xF0, 0xA0, 0x7F, 0x90, 0x57, 0x50, 0x9F,
  0x0A, 0x07, 0xF9, 0x04, 0x75, 0x08, 0xF0, 0xA0, 0x8F, 0x90, 0x37, 0x50, 0x7F, 0x0A, 0x08, 0xF9,
  0x03, 0x75, 0x07, 0xF0, 0xA0, 0x8F, 0x90, 0x47, 0x50, 0x7F, 0x0A, 0x07, 0xF9, 0x05, 0x75, 0x08,
  0xF0, 0xA0, 0x6F, 0x90, 0x87, 0x50, 0x9F, 0x0A, 0x03, 0xF9, 0x0B, 0x75, 0x0C, 0xF0, 0xA1, 0xFA,
  0x01, 0x73, 0x01, 0xF9, 0x81, 0xA0, 0xDF, 0x90, 0x87, 0x30, 0x8F, 0x98, 0x1A, 0x08, 0xFA, 0x03,
  0x71, 0x03, 0xFA, 0x81, 0xA0, 0x3F, 0xA0, 0xE0, 0x56, 0x04, 0x0E, 0xFA, 0x0A, 0x20, 0xCF, 0xB8,
  0x4D, 0x97, 0x79, 0xDF, 0xC0, 0xA2, 0x04, 0xFF, 0xFE, 0x0A, 0x30, 0xAF, 0xFF, 0xD0, 0xA3, 0x01,
  0x0D, 0xFF, 0xA0, 0x90, 0xDF, 0x0A, 0x40, 0x20, 0xEF, 0xF8, 0x1A, 0x0E, 0xF0, 0xA5, 0x01, 0x0B,
  0xFD, 0x08, 0x2F, 0x90, 0xA7, 0x05, 0x0B, 0xF8, 0x1E, 0x92, 0x3F, 0x90, 0xA7, 0x28, 0x51, 0x46,
  0x77, 0x63, 0x50, 0x1F, 0x90, 0xA7, 0x77, 0x02, 0xF9, 0x09, 0x77, 0x70, 0x4F, 0x90, 0x77, 0x77,
  0x08, 0xF9, 0x05, 0x20, 0x10, 0x27, 0x72, 0x01, 0x0E, 0xF9, 0x01, 0x28, 0x34, 0xFC, 0x62, 0x75,
  0x02, 0x0D, 0xF9, 0x0B, 0x30, 0x4C, 0x83, 0xD9, 0x64, 0x14, 0x81, 0x14, 0x9F, 0xB0, 0x53, 0x04,
  0xFF, 0xFC, 0x0C, 0x40, 0x4F, 0xFF, 0xC0, 0x34, 0x04, 0xFF, 0xFB, 0x05, 0x50, 0x4F, 0xFF, 0x90,
  0xE0, 0x56, 0x04, 0xFF, 0xF0, 0xB0, 0x27, 0x81, 0x17, 0xCF, 0xFA, 0x81, 0xEA, 0x37, 0x58, 0x61,
  0x47, 0xAB, 0xDE, 0xEA, 0x84, 0xED, 0xCA, 0x73, 0x73,
  // "Ģ" (U+0122)
  0x77, 0x18, 0x90, 0x13, 0x56, 0x77, 0x65, 0x42, 0x77, 0x68, 0x13, 0x9D, 0xFC, 0x81, 0xC8, 0x47,
  0x70, 0x50, 0xDF, 0xFB, 0x81, 0xE8, 0x27, 0x20, 0x20, 0xCF, 0xFF, 0x0B, 0x71, 0x05, 0x0E, 0xFF,
  0xF9, 0x05, 0x70, 0x6F, 0xFF, 0xA0, 0xD7, 0x05, 0xFF, 0xFB, 0x07, 0x60, 0x20, 0xEF, 0xC8, 0x6E,
  0xA9, 0x77, 0x8A, 0xDD, 0x01, 0x60, 0xBF, 0xB0, 0xB0, 0x47, 0x18, 0x31, 0x5B, 0xFA, 0x60, 0x5F,
  0xA0, 0xE0, 0x57, 0x60, 0x03, 0x60, 0xDF, 0x90, 0xE0, 0x37, 0x77, 0x04, 0xFA, 0x04, 0x77, 0x71,
  0x0A, 0xF9, 0x0A, 0x77, 0x72, 0xFA, 0x02, 0x77, 0x71, 0x04, 0xF9, 0x0B, 0x77, 0x72, 0x08, 0xF9,
  0x06, 0x77, 0x72, 0x0A, 0xF9, 0x01, 0x77, 0x72, 0x0D, 0xF0, 0xE7, 0x77, 0x3F, 0x90, 0xB7, 0x77,
  0x20, 0x1F, 0x90, 0xA7, 0x10, 0x78, 0x09, 0x1E, 0x04, 0x02, 0xF9, 0x09, 0x71, 0x07, 0xFE, 0x04,
  0x02, 0xF9, 0x08, 0x71, 0x07, 0xFE, 0x04, 0x03, 0xF9, 0x07, 0x71, 0x07, 0xFE, 0x04, 0x02, 0xF9,
  0x08, 0x71, 0x07, 0xFE, 0x04, 0x02, 0xF9, 0x09, 0x71, 0x07, 0xFE, 0x04, 0x01, 0xF9, 0x0A, 0x71,
  0x07, 0xFE, 0x04, 0x1F, 0x90, 0xD7, 0x70, 0x8F, 0x81, 0x40, 0xDF, 0x97, 0x70, 0x8F, 0x81, 0x40,
  0xAF, 0x90, 0x37, 0x60, 0x8F, 0x81, 0x40, 0x7F, 0x90, 0x87, 0x60, 0x8F, 0x81, 0x40, 0x3F, 0x90,
  0xD7, 0x60, 0x8F, 0x04, 0x20, 0xEF, 0x90, 0x67, 0x50, 0x8F, 0x04, 0x20, 0x9F, 0x90, 0xD7, 0x50,
  0x8F, 0x04, 0x20, 0x2F, 0xA0, 0xB7, 0x40, 0x8F, 0x04, 0x30, 0xBF, 0xA0, 0x97, 0x30, 0x8F, 0x04,
  0x30, 0x2F, 0xB0, 0xD0, 0x57, 0x10, 0x8F, 0x04, 0x40, 0x8F, 0xC8, 0x6E, 0xA8, 0x77, 0x8A, 0xDF,
  0x90, 0x45, 0x0C, 0xFF, 0xFD, 0x04, 0x50, 0x10, 0xDF, 0xFF, 0xC0, 0x46, 0x01, 0x0C, 0xFF, 0xFB,
  0x04, 0x71, 0x09, 0xFF, 0xFA, 0x04, 0x72, 0x03, 0x0B, 0xFF, 0xD8, 0x1D, 0x71, 0x74, 0x81, 0x27,
  0xCF, 0xD8, 0x2E, 0xA7, 0x37, 0x74, 0x89, 0x13, 0x56, 0x77, 0x76, 0x65, 0x31, 0x80, 0x9A, 0x30,
  0x02, 0xF0, 0xD7, 0x77, 0x30, 0x4F, 0x08, 0x77, 0x73, 0x07, 0xF0, 0x17, 0x77, 0x30, 0xAE, 0x09,
  0x77, 0x74, 0x0D, 0xE0, 0x27, 0x77, 0x30, 0x1E, 0x09, 0x77, 0x74, 0x04, 0xE0, 0x17, 0x77, 0x40,
  0x7D, 0x08, 0x77, 0x75, 0x0B, 0xC0, 0xD7, 0x77, 0x60, 0xEC, 0x05, 0x77,
  // "ģ" (U+0123)
  0x77, 0x10, 0x5C, 0x0E, 0x77, 0x74, 0x0D, 0xC0, 0xB7, 0x77, 0x30, 0x7D, 0x07, 0x77, 0x72, 0x01,
  0x0E, 0xD0, 0x47, 0x77, 0x20, 0x9E, 0x77, 0x72, 0x02, 0xE0, 0xC7, 0x77, 0x20, 0x9E, 0x09, 0x77,
  0x71, 0x01, 0xF0, 0x67, 0x77, 0x10, 0x8F, 0x04, 0x77, 0x71, 0x0D, 0xF0, 0x28, 0x09, 0xD5, 0x08,
  0x51, 0x46, 0x77, 0x53, 0x77, 0x71, 0x05, 0x0C, 0xF8, 0x1E, 0x81, 0x40, 0x2E, 0x0A, 0x50, 0x10,
  0xCF, 0xC0, 0xE0, 0x63, 0x08, 0xE0, 0xA4, 0x02, 0x0E, 0xFF, 0x09, 0x20, 0xEE, 0x0A, 0x30, 0x10,
  0xEF, 0xFA, 0x08, 0x06, 0xF0, 0xA3, 0x0A, 0xFF, 0xFD, 0x0A, 0x20, 0x4F, 0xFF, 0xE0, 0xA2, 0x0C,
  0xFB, 0x84, 0xD9, 0x77, 0x9D, 0xFC, 0x81, 0xA0, 0x3F, 0xA0, 0xE0, 0x56, 0x06, 0x0E, 0xFA, 0x81,
  0xA0, 0x8F, 0xA0, 0x37, 0x10, 0x4F, 0xA8, 0x1A, 0x0D, 0xF9, 0x08, 0x73, 0x09, 0xF9, 0x0A, 0x1F,
  0xA0, 0x17, 0x30, 0x3F, 0x90, 0xA0, 0x3F, 0x90, 0xB7, 0x50, 0xEF, 0x0A, 0x06, 0xF9, 0x08, 0x75,
  0x0B, 0xF0, 0xA0, 0x7F, 0x90, 0x57, 0x50, 0x9F, 0x0A, 0x07, 0xF9, 0x04, 0x75, 0x08, 0xF0, 0xA0,
  0x8F, 0x90, 0x37, 0x50, 0x7F, 0x0A, 0x08, 0xF9, 0x03, 0x75, 0x07, 0xF0, 0xA0, 0x8F, 0x90, 0x47,
  0x50, 0x7F, 0x0A, 0x07, 0xF9, 0x05, 0x75, 0x08, 0xF0, 0xA0, 0x6F, 0x90, 0x87, 0x50, 0x9F, 0x0A,
  0x03, 0xF9, 0x0B, 0x75, 0x0C, 0xF0, 0xA1, 0xFA, 0x01, 0x73, 0x01, 0xF9, 0x81, 0xA0, 0xDF, 0x90,
  0x87, 0x30, 0x8F, 0x98, 0x1A, 0x08, 0xFA, 0x03, 0x71, 0x03, 0xFA, 0x81, 0xA0, 0x3F, 0xA0, 0xE0,
  0x56, 0x04, 0x0E, 0xFA, 0x0A, 0x20, 0xCF, 0xB8, 0x4D, 0x97, 0x79, 0xDF, 0xC0, 0xA2, 0x04, 0xFF,
  0xFE, 0x0A, 0x30, 0xAF, 0xFF, 0xD0, 0xA3, 0x01, 0x0D, 0xFF, 0xA0, 0x90, 0xDF, 0x0A, 0x40, 0x20,
  0xEF, 0xF8, 0x1A, 0x0E, 0xF0, 0xA5, 0x01, 0x0B, 0xFD, 0x08, 0x2F, 0x90, 0xA7, 0x05, 0x0B, 0xF8,
  0x1E, 0x92, 0x3F, 0x90, 0xA7, 0x28, 0x51, 0x46, 0x77, 0x63, 0x50, 0x1F, 0x90, 0xA7, 0x77, 0x02,
  0xF9, 0x09, 0x77, 0x70, 0x4F, 0x90, 0x77, 0x77, 0x08, 0xF9, 0x05, 0x20, 0x10, 0x27, 0x72, 0x01,
  0x0E, 0xF9, 0x01, 0x28, 0x34, 0xFC, 0x62, 0x75, 0x02, 0x0D, 0xF9, 0x0B, 0x30, 0x4C, 0x83, 0xD9,
  0x64, 0x14, 0x81, 0x14, 0x9F, 0xB0, 0x53, 0x04, 0xFF, 0xFC, 0x0C, 0x40, 0x4F, 0xFF, 0xC0, 0x34,
  0x04, 0xFF, 0xFB, 0x05, 0x50, 0x4F, 0xFF, 0x90, 0xE0, 0x56, 0x04, 0xFF, 0xF0, 0xB0, 0x27, 0x81,
  0x17, 0xCF, 0xFA, 0x81, 0xEA, 0x37, 0x58, 0x61, 0x47, 0xAB, 0xDE, 0xEA, 0x84, 0xED, 0xCA, 0x73,
  0x73,
  // "Ĥ" (U+0124)
  0x74, 0x02, 0x80, 0x47, 0x06, 0x77, 0x71, 0x0C, 0xFA, 0x04, 0x77, 0x60, 0x7F, 0xB0, 0xD7, 0x75,
  0x03, 0xFD, 0x09, 0x77, 0x30, 0x10, 0xDF, 0xE0, 0x57, 0x72, 0x0A, 0xE0, 0xA0, 0x5E, 0x0E, 0x02,
  0x77, 0x07, 0xE0, 0xA2, 0x05, 0xE0, 0xD0, 0x17, 0x50, 0x4E, 0x09, 0x40, 0x40, 0xED, 0x0B, 0x74,
  0x03, 0x0E, 0xD0, 0x76, 0x03, 0x0D, 0xD0, 0x87, 0x30, 0xCC, 0x0E, 0x04, 0x71, 0x01, 0x0B, 0xD0,
  0x28, 0x0A, 0x80, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9,
  0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90,
  0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F,
  0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9,
  0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06,
  0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F,
  0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0xFF, 0xFA, 0x00,
  0x4F, 0xFF, 0xFA, 0x00, 0x4F, 0xFF, 0xFA, 0x00, 0x4F, 0xFF, 0xFA, 0x00, 0x4F, 0xFF, 0xFA, 0x00,
  0x4F, 0xFF, 0xFA, 0x00, 0x4F, 0xA8, 0x09, 0x0E, 0xFA, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90,
  0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06,
  0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9,
  0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90,
  0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F,
  0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9,
  0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06,
  0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F,
  0x90, 0x67, 0x50, 0x6F, 0x90, 0x40,
  // "ĥ" (U+0125)
  0x60, 0x28, 0x04, 0x70, 0x67, 0x77, 0x50, 0xCF, 0xA0, 0x47, 0x77, 0x30, 0x7F, 0xB0, 0xD7, 0x77,
  0x20, 0x3F, 0xD0, 0x97, 0x77, 0x01, 0x0D, 0xFE, 0x05, 0x77, 0x60, 0xAE, 0x0A, 0x05, 0xE0, 0xE0,
  0x27, 0x74, 0x07, 0xE0, 0xA2, 0x05, 0xE0, 0xD0, 0x17, 0x72, 0x04, 0xE0, 0x94, 0x04, 0x0E, 0xD0,
  0xB7, 0x71, 0x03, 0x0E, 0xD0, 0x76, 0x03, 0x0D, 0xD0, 0x87, 0x70, 0xCC, 0x0E, 0x04, 0x71, 0x01,
  0x0B, 0xD0, 0x28, 0x0A, 0xB7, 0x00, 0xAF, 0x97, 0x77, 0x60, 0xAF, 0x97, 0x77, 0x60, 0xAF, 0x97,
  0x77, 0x60, 0xAF, 0x97, 0x77, 0x60, 0xAF, 0x97, 0x77, 0x60, 0xAF, 0x97, 0x77, 0x60, 0xAF, 0x97,
  0x77, 0x60, 0xAF, 0x97, 0x77, 0x60, 0xAF, 0x97, 0x77, 0x60, 0xAF, 0x97, 0x77, 0x60, 0xAF, 0x97,
  0x77, 0x60, 0xAF, 0x0E, 0x77, 0x76, 0x0A, 0xF0, 0xE6, 0x85, 0x35, 0x77, 0x65, 0x37, 0x70, 0xAF,
  0x0D, 0x38, 0x11, 0x8E, 0xF8, 0x1E, 0xB3, 0x74, 0x0A, 0xF0, 0xD2, 0x04, 0x0E, 0xFD, 0x0B, 0x01,
  0x72, 0x0A, 0xF8, 0x1D, 0x05, 0xFF, 0x90, 0xD0, 0x17, 0x10, 0xAF, 0x0C, 0x03, 0xFF, 0xB0, 0xC7,
  0x10, 0xAF, 0x90, 0xEF, 0xFC, 0x07, 0x70, 0xAF, 0xFF, 0xE0, 0xE7, 0x0A, 0xFD, 0x84, 0xC8, 0x77,
  0xAE, 0xFB, 0x05, 0x60, 0xAF, 0xB0, 0xD0, 0x35, 0x01, 0x0A, 0xFA, 0x08, 0x60, 0xAF, 0xA0, 0xD0,
  0x17, 0x10, 0xBF, 0x90, 0xC6, 0x0A, 0xFA, 0x05, 0x72, 0x04, 0xF9, 0x0D, 0x60, 0xAF, 0x90, 0xD7,
  0x4F, 0x90, 0xE6, 0x0A, 0xF9, 0x09, 0x74, 0x0C, 0xF9, 0x60, 0xAF, 0x90, 0x57, 0x40, 0xBF, 0x96,
  0x0A, 0xF9, 0x03, 0x74, 0x0A, 0xF9, 0x60, 0xAF, 0x90, 0x17, 0x40, 0xAF, 0x96, 0x0A, 0xF9, 0x75,
  0x0A, 0xF9, 0x60, 0xAF, 0x97, 0x50, 0xAF, 0x96, 0x0A, 0xF9, 0x75, 0x0A, 0xF9, 0x60, 0xAF, 0x97,
  0x50, 0xAF, 0x96, 0x0A, 0xF9, 0x75, 0x0A, 0xF9, 0x60, 0xAF, 0x97, 0x50, 0xAF, 0x96, 0x0A, 0xF9,
  0x75, 0x0A, 0xF9, 0x60, 0xAF, 0x97, 0x50, 0xAF, 0x96, 0x0A, 0xF9, 0x75, 0x0A, 0xF9, 0x60, 0xAF,
  0x97, 0x50, 0xAF, 0x96, 0x0A, 0xF9, 0x75, 0x0A, 0xF9, 0x60, 0xAF, 0x97, 0x50, 0xAF, 0x96, 0x0A,
  0xF9, 0x75, 0x0A, 0xF9, 0x60, 0xAF, 0x97, 0x50, 0xAF, 0x96, 0x0A, 0xF9, 0x75, 0x0A, 0xF9, 0x60,
  0xAF, 0x97, 0x50, 0xAF, 0x96, 0x0A, 0xF9, 0x75, 0x0A, 0xF9,
  // "Ħ" (U+0126)
  0x30, 0x9F, 0x90, 0x17, 0x30, 0x1F, 0x90, 0x96, 0x09, 0xF9, 0x01, 0x73, 0x01, 0xF9, 0x09, 0x60,
  0x9F, 0x90, 0x17, 0x30, 0x1F, 0x90, 0x96, 0x09, 0xF9, 0x01, 0x73, 0x01, 0xF9, 0x09, 0x60, 0x9F,
  0x90, 0x17, 0x30, 0x1F, 0x90, 0x93, 0x80, 0xBA, 0x4F, 0x30, 0x9F, 0x90, 0x17, 0x30, 0x1F, 0x90,
  0x96, 0x09, 0xF9, 0x01, 0x73, 0x01, 0xF9, 0x09, 0x60, 0x9F, 0x90, 0x17, 0x30, 0x1F, 0x90, 0x96,
  0x09, 0xF9, 0x01, 0x73, 0x01, 0xF9, 0x09, 0x60, 0x9F, 0x90, 0x17, 0x30, 0x1F, 0x90, 0x96, 0x09,
  0xFF, 0xFF, 0x09, 0x60, 0x9F, 0xFF, 0xF0, 0x96, 0x09, 0xFF, 0xFF, 0x09, 0x60, 0x9F, 0xFF, 0xF0,
  0x96, 0x09, 0xFF, 0xFF, 0x09, 0x60, 0x9F, 0xFF, 0xF0, 0x96, 0x09, 0xF9, 0x80, 0x90, 0xEF, 0x90,
  0x96, 0x09, 0xF9, 0x01, 0x73, 0x01, 0xF9, 0x09, 0x60, 0x9F, 0x90, 0x17, 0x30, 0x1F, 0x90, 0x96,
  0x09, 0xF9, 0x01, 0x73, 0x01, 0xF9, 0x09, 0x60, 0x9F, 0x90, 0x17, 0x30, 0x1F, 0x90, 0x96, 0x09,
  0xF9, 0x01, 0x73, 0x01, 0xF9, 0x09, 0x60, 0x9F, 0x90, 0x17, 0x30, 0x1F, 0x90, 0x96, 0x09, 0xF9,
  0x01, 0x73, 0x01, 0xF9, 0x09, 0x60, 0x9F, 0x90, 0x17, 0x30, 0x1F, 0x90, 0x96, 0x09, 0xF9, 0x01,
  0x73, 0x01, 0xF9, 0x09, 0x60, 0x9F, 0x90, 0x17, 0x30, 0x1F, 0x90, 0x96, 0x09, 0xF9, 0x01, 0x73,
  0x01, 0xF9, 0x09, 0x60, 0x9F, 0x90, 0x17, 0x30, 0x1F, 0x90, 0x96, 0x09, 0xF9, 0x01, 0x73, 0x01,
  0xF9, 0x09, 0x60, 0x9F, 0x90, 0x17, 0x30, 0x1F, 0x90, 0x96, 0x09, 0xF9, 0x01, 0x73, 0x01, 0xF9,
  0x09, 0x60, 0x9F, 0x90, 0x17, 0x30, 0x1F, 0x90, 0x96, 0x09, 0xF9, 0x01, 0x73, 0x01, 0xF9, 0x09,
  0x60, 0x9F, 0x90, 0x17, 0x30, 0x1F, 0x90, 0x96, 0x09, 0xF9, 0x01, 0x73, 0x01, 0xF9, 0x09, 0x30,
  // "ħ" (U+0127)
  0x30, 0xAF, 0x97, 0x77, 0x30, 0xAF, 0x97, 0x77, 0x30, 0xAF, 0x97, 0x77, 0x30, 0xAF, 0x97, 0x77,
  0xFF, 0xE0, 0xD7, 0x5F, 0xFE, 0x0D, 0x75, 0xFF, 0xE0, 0xD7, 0x5F, 0xFE, 0x0D, 0x75, 0xFF, 0xE0,
  0xD7, 0x5F, 0xFE, 0x0D, 0x77, 0x10, 0xAF, 0x97, 0x77, 0x30, 0xAF, 0x0E, 0x77, 0x73, 0x0A, 0xF0,
  0xE7, 0x77, 0x30, 0xAF, 0x0E, 0x48, 0x91, 0x16, 0xAD, 0xEF, 0xED, 0xB7, 0x37, 0x20, 0xAF, 0x0D,
  0x30, 0x70, 0xEF, 0xB0, 0xB0, 0x37, 0x0A, 0xF8, 0x2D, 0x01, 0xBF, 0xF0, 0x66, 0x0A, 0xF8, 0x1D,
  0x0C, 0xFF, 0xA0, 0x65, 0x0A, 0xF0, 0xD0, 0x9F, 0xFC, 0x03, 0x40, 0xAF, 0xFF, 0xE0, 0xB4, 0x0A,
  0xFF, 0xFF, 0x02, 0x30, 0xAF, 0xC8, 0x1B, 0x41, 0x20, 0x30, 0x8F, 0xB0, 0x73, 0x0A, 0xFB, 0x06,
  0x70, 0x3F, 0xA0, 0xA3, 0x0A, 0xFA, 0x09, 0x72, 0x07, 0xF9, 0x0D, 0x30, 0xAF, 0xA0, 0x17, 0x20,
  0x1F, 0x90, 0xE3, 0x0A, 0xF9, 0x0B, 0x74, 0x0D, 0xF9, 0x30, 0xAF, 0x90, 0x77, 0x40, 0xBF, 0x93,
  0x0A, 0xF9, 0x04, 0x74, 0x0B, 0xF9, 0x30, 0xAF, 0x90, 0x27, 0x40, 0xAF, 0x93, 0x0A, 0xF9, 0x01,
  0x74, 0x0A, 0xF9, 0x30, 0xAF, 0x97, 0x50, 0xAF, 0x93, 0x0A, 0xF9, 0x75, 0x0A, 0xF9, 0x30, 0xAF,
  0x97, 0x50, 0xAF, 0x93, 0x0A, 0xF9, 0x75, 0x0A, 0xF9, 0x30, 0xAF, 0x97, 0x50, 0xAF, 0x93, 0x0A,
  0xF9, 0x75, 0x0A, 0xF9, 0x30, 0xAF, 0x97, 0x50, 0xAF, 0x93, 0x0A, 0xF9, 0x75, 0x0A, 0xF9, 0x30,
  0xAF, 0x97, 0x50, 0xAF, 0x93, 0x0A, 0xF9, 0x75, 0x0A, 0xF9, 0x30, 0xAF, 0x97, 0x50, 0xAF, 0x93,
  0x0A, 0xF9, 0x75, 0x0A, 0xF9, 0x30, 0xAF, 0x97, 0x50, 0xAF, 0x93, 0x0A, 0xF9, 0x75, 0x0A, 0xF9,
  0x30, 0xAF, 0x97, 0x50, 0xAF, 0x93, 0x0A, 0xF9, 0x75, 0x0A, 0xF9,
  // "Ĩ" (U+0128)
  0x58, 0x54, 0xBE, 0xED, 0x93, 0x70, 0x1C, 0x05, 0x50, 0x9F, 0x0C, 0x04, 0x50, 0x6C, 0x03, 0x40,
  0x6F, 0xB8, 0x4C, 0x62, 0x03, 0xEC, 0x01, 0x40, 0xEF, 0xFD, 0x0D, 0x40, 0x6F, 0xFE, 0x08, 0x40,
  0xCF, 0xFE, 0x01, 0x4C, 0x84, 0xD3, 0x02, 0x7D, 0xFB, 0x06, 0x40, 0x3C, 0x05, 0x50, 0x50, 0xCF,
  0x08, 0x50, 0x5C, 0x71, 0x85, 0x49, 0xDE, 0xEA, 0x48, 0x09, 0xD1, 0x00, 0x9F, 0xFF, 0xB0, 0x09,
  0xFF, 0xFB, 0x00, 0x9F, 0xFF, 0xB0, 0x09, 0xFF, 0xFB, 0x00, 0x9F, 0xFF, 0xB0, 0x09, 0xFF, 0xFB,
  0x87, 0x91, 0x35, 0x78, 0xAC, 0xEF, 0xB8, 0x6D, 0xCA, 0x87, 0x53, 0x17, 0x10, 0x4F, 0x90, 0x17,
  0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F,
  0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77,
  0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9,
  0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72,
  0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90,
  0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20,
  0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01,
  0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x73, 0x85, 0x12, 0x46, 0x89, 0xCF, 0x98,
  0x5B, 0x97, 0x64, 0x21, 0x20, 0x80, 0xEF, 0xFF, 0x98, 0x1E, 0x89, 0xFF, 0xFB, 0x00, 0x9F, 0xFF,
  0xB0, 0x09, 0xFF, 0xFB, 0x00, 0x9F, 0xFF, 0xB0, 0x09, 0xFF, 0xFB, 0x09,
  // "ĩ" (U+0129)
  0x78, 0x54, 0xBE, 0xED, 0x93, 0x70, 0x1C, 0x05, 0x72, 0x09, 0xF0, 0xC0, 0x45, 0x06, 0xC0, 0x37,
  0x10, 0x6F, 0xB8, 0x4C, 0x62, 0x03, 0xEC, 0x01, 0x71, 0x0E, 0xFF, 0xD0, 0xD7, 0x10, 0x6F, 0xFE,
  0x08, 0x71, 0x0C, 0xFF, 0xE0, 0x17, 0x1C, 0x84, 0xD3, 0x02, 0x7D, 0xFB, 0x06, 0x71, 0x03, 0xC0,
  0x55, 0x05, 0x0C, 0xF0, 0x87, 0x20, 0x5C, 0x71, 0x85, 0x49, 0xDE, 0xEA, 0x48, 0x09, 0xF5, 0x00,
  0xCF, 0xFB, 0x03, 0x74, 0x0C, 0xFF, 0xB0, 0x37, 0x40, 0xCF, 0xFB, 0x03, 0x74, 0x0C, 0xFF, 0xB0,
  0x37, 0x40, 0xCF, 0xFB, 0x03, 0x74, 0x0C, 0xFF, 0xB0, 0x37, 0x48, 0x61, 0x35, 0x78, 0xAC, 0xDF,
  0xB0, 0x37, 0x76, 0x08, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77,
  0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9,
  0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76,
  0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90,
  0x37, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x60,
  0x7F, 0x90, 0x37, 0x78, 0x41, 0x35, 0x8A, 0xDF, 0xB8, 0x3C, 0x96, 0x41, 0x48, 0x31, 0x69, 0xBE,
  0xFF, 0xF8, 0x3E, 0xB8, 0x56, 0xFF, 0xFF, 0x90, 0x6F, 0xFF, 0xF9, 0x06, 0xFF, 0xFF, 0x90, 0x6F,
  0xFF, 0xF9, 0x06, 0xFF, 0xFF, 0x90,
  // "Ī" (U+012A)
  0x30, 0x1F, 0xFC, 0x01, 0x60, 0x1F, 0xFC, 0x01, 0x60, 0x1F, 0xFC, 0x01, 0x60, 0x1F, 0xFC, 0x01,
  0x60, 0x1F, 0xFC, 0x01, 0x60, 0x1F, 0xFC, 0x01, 0x80, 0xA8, 0x10, 0x09, 0xFF, 0xFB, 0x00, 0x9F,
  0xFF, 0xB0, 0x09, 0xFF, 0xFB, 0x00, 0x9F, 0xFF, 0xB0, 0x09, 0xFF, 0xFB, 0x00, 0x9F, 0xFF, 0xB8,
  0x79, 0x13, 0x57, 0x8A, 0xCE, 0xFB, 0x86, 0xDC, 0xA8, 0x75, 0x31, 0x71, 0x04, 0xF9, 0x01, 0x77,
  0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9,
  0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72,
  0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90,
  0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20,
  0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01,
  0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04,
  0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17,
  0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x38, 0x51, 0x24, 0x68, 0x9C, 0xF9, 0x85,
  0xB9, 0x76, 0x42, 0x12, 0x08, 0x0E, 0xFF, 0xF9, 0x81, 0xE8, 0x9F, 0xFF, 0xB0, 0x09, 0xFF, 0xFB,
  0x00, 0x9F, 0xFF, 0xB0, 0x09, 0xFF, 0xFB, 0x00, 0x9F, 0xFF, 0xB0, 0x90,
  // "ī" (U+012B)
  0x50, 0x1F, 0xFC, 0x01, 0x73, 0x01, 0xFF, 0xC0, 0x17, 0x30, 0x1F, 0xFC, 0x01, 0x73, 0x01, 0xFF,
  0xC0, 0x17, 0x30, 0x1F, 0xFC, 0x01, 0x73, 0x01, 0xFF, 0xC0, 0x18, 0x0A, 0xB1, 0x00, 0xCF, 0xFB,
  0x03, 0x74, 0x0C, 0xFF, 0xB0, 0x37, 0x40, 0xCF, 0xFB, 0x03, 0x74, 0x0C, 0xFF, 0xB0, 0x37, 0x40,
  0xCF, 0xFB, 0x03, 0x74, 0x0C, 0xFF, 0xB0, 0x37, 0x48, 0x61, 0x35, 0x78, 0xAC, 0xDF, 0xB0, 0x37,
  0x76, 0x08, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F,
  0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77,
  0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9,
  0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76,
  0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90,
  0x37, 0x78, 0x41, 0x35, 0x8A, 0xDF, 0xB8, 0x3C, 0x96, 0x41, 0x48, 0x31, 0x69, 0xBE, 0xFF, 0xF8,
  0x3E, 0xB8, 0x56, 0xFF, 0xFF, 0x90, 0x6F, 0xFF, 0xF9, 0x06, 0xFF, 0xFF, 0x90, 0x6F, 0xFF, 0xF9,
  0x06, 0xFF, 0xFF, 0x90,
  // "Ĭ" (U+012C)
  0x38, 0x46, 0x77, 0x77, 0x17, 0x28, 0x45, 0x77, 0x77, 0x15, 0x0C, 0xC0, 0x47, 0x20, 0xEC, 0x02,
  0x50, 0xAC, 0x0C, 0x71, 0x07, 0xD6, 0x06, 0xD8, 0x6D, 0x72, 0x10, 0x25, 0xBD, 0x0B, 0x60, 0x1F,
  0xFC, 0x05, 0x70, 0x9F, 0xFA, 0x0C, 0x71, 0x01, 0x0D, 0xFF, 0x0E, 0x02, 0x72, 0x02, 0x0D, 0xFD,
  0x0E, 0x03, 0x75, 0x09, 0xFB, 0x0A, 0x01, 0x77, 0x89, 0x01, 0x7B, 0xDE, 0xFD, 0xB7, 0x28, 0x09,
  0xD4, 0x00, 0x9F, 0xFF, 0xB0, 0x09, 0xFF, 0xFB, 0x00, 0x9F, 0xFF, 0xB0, 0x09, 0xFF, 0xFB, 0x00,
  0x9F, 0xFF, 0xB0, 0x09, 0xFF, 0xFB, 0x87, 0x91, 0x35, 0x78, 0xAC, 0xEF, 0xB8, 0x6D, 0xCA, 0x87,
  0x53, 0x17, 0x10, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72,
  0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90,
  0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20,
  0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01,
  0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04,
  0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17,
  0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F,
  0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x73,
  0x85, 0x12, 0x46, 0x89, 0xCF, 0x98, 0x5B, 0x97, 0x64, 0x21, 0x20, 0x80, 0xEF, 0xFF, 0x98, 0x1E,
  0x89, 0xFF, 0xFB, 0x00, 0x9F, 0xFF, 0xB0, 0x09, 0xFF, 0xFB, 0x00, 0x9F, 0xFF, 0xB0, 0x09, 0xFF,
  0xFB, 0x09,
  // "ĭ" (U+012D)
  0x58, 0x46, 0x77, 0x77, 0x17, 0x28, 0x45, 0x77, 0x77, 0x17, 0x20, 0xCC, 0x04, 0x72, 0x0E, 0xC0,
  0x27, 0x20, 0xAC, 0x0C, 0x71, 0x07, 0xD7, 0x30, 0x6D, 0x86, 0xD7, 0x21, 0x02, 0x5B, 0xD0, 0xB7,
  0x30, 0x1F, 0xFC, 0x05, 0x74, 0x09, 0xFF, 0xA0, 0xC7, 0x50, 0x10, 0xDF, 0xF0, 0xE0, 0x27, 0x60,
  0x20, 0xDF, 0xD0, 0xE0, 0x37, 0x72, 0x09, 0xFB, 0x0A, 0x01, 0x77, 0x48, 0x90, 0x17, 0xBD, 0xEF,
  0xDB, 0x72, 0x80, 0xA8, 0x00, 0x0C, 0xFF, 0xB0, 0x37, 0x40, 0xCF, 0xFB, 0x03, 0x74, 0x0C, 0xFF,
  0xB0, 0x37, 0x40, 0xCF, 0xFB, 0x03, 0x74, 0x0C, 0xFF, 0xB0, 0x37, 0x40, 0xCF, 0xFB, 0x03, 0x74,
  0x86, 0x13, 0x57, 0x8A, 0xCD, 0xFB, 0x03, 0x77, 0x60, 0x8F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03,
  0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07,
  0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37,
  0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F,
  0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77,
  0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x84, 0x13, 0x58, 0xAD, 0xFB, 0x83, 0xC9,
  0x64, 0x14, 0x83, 0x16, 0x9B, 0xEF, 0xFF, 0x83, 0xEB, 0x85, 0x6F, 0xFF, 0xF9, 0x06, 0xFF, 0xFF,
  0x90, 0x6F, 0xFF, 0xF9, 0x06, 0xFF, 0xFF, 0x90, 0x6F, 0xFF, 0xF9,
  // "Į" (U+012E)
  0x09, 0xFF, 0xFB, 0x00, 0x9F, 0xFF, 0xB0, 0x09, 0xFF, 0xFB, 0x00, 0x9F, 0xFF, 0xB0, 0x09, 0xFF,
  0xFB, 0x00, 0x9F, 0xFF, 0xB8, 0x79, 0x13, 0x57, 0x8A, 0xCE, 0xFB, 0x86, 0xDC, 0xA8, 0x75, 0x31,
  0x71, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F,
  0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77,
  0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9,
  0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72,
  0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90,
  0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20,
  0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01,
  0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x38, 0x51,
  0x24, 0x68, 0x9C, 0xF9, 0x85, 0xB9, 0x76, 0x42, 0x12, 0x08, 0x0E, 0xFF, 0xF9, 0x81, 0xE8, 0x9F,
  0xFF, 0xB0, 0x09, 0xFF, 0xFB, 0x00, 0x9F, 0xFF, 0xB0, 0x09, 0xFF, 0xFB, 0x00, 0x9F, 0xFF, 0xB0,
  0x97, 0x70, 0x30, 0xEC, 0x03, 0x77, 0x40, 0x4D, 0x05, 0x77, 0x40, 0x3D, 0x07, 0x77, 0x50, 0xDC,
  0x0C, 0x77, 0x50, 0x7D, 0x04, 0x77, 0x50, 0xDD, 0x77, 0x50, 0x2D, 0x0D, 0x77, 0x50, 0x3E, 0x77,
  0x50, 0x3E, 0x83, 0xA1, 0x02, 0x57, 0x71, 0xFC, 0x77, 0x10, 0xAF, 0xB7, 0x71, 0x02, 0x0E, 0xFA,
  0x77, 0x20, 0x30, 0xEF, 0x97, 0x74, 0x81, 0x6B, 0xEA, 0x81, 0xDB, 0x74,
  // "į" (U+012F)
  0x75, 0x81, 0x29, 0xDA, 0x81, 0xD9, 0x27, 0x77, 0x03, 0x0E, 0xE0, 0xE0, 0x37, 0x76, 0x0C, 0xF9,
  0x0C, 0x77, 0x50, 0x2F, 0xB0, 0x27, 0x74, 0x04, 0xFB, 0x04, 0x77, 0x40, 0x4F, 0xB0, 0x37, 0x74,
  0x02, 0xFB, 0x01, 0x77, 0x50, 0xCF, 0x90, 0xC7, 0x76, 0x03, 0x0E, 0xE0, 0xE0, 0x27, 0x77, 0x81,
  0x29, 0xDA, 0x81, 0xD8, 0x18, 0x0A, 0x80, 0x00, 0xCF, 0xFB, 0x03, 0x74, 0x0C, 0xFF, 0xB0, 0x37,
  0x40, 0xCF, 0xFB, 0x03, 0x74, 0x0C, 0xFF, 0xB0, 0x37, 0x40, 0xCF, 0xFB, 0x03, 0x74, 0x0C, 0xFF,
  0xB0, 0x37, 0x48, 0x61, 0x35, 0x78, 0xAC, 0xDF, 0xB0, 0x37, 0x76, 0x08, 0xF9, 0x03, 0x77, 0x60,
  0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03,
  0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07,
  0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37,
  0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F,
  0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x78, 0x41, 0x35, 0x8A, 0xDF,
  0xB8, 0x3C, 0x96, 0x41, 0x48, 0x31, 0x69, 0xBE, 0xFF, 0xF8, 0x3E, 0xB8, 0x56, 0xFF, 0xFF, 0x90,
  0x6F, 0xFF, 0xF9, 0x06, 0xFF, 0xFF, 0x90, 0x6F, 0xFF, 0xF9, 0x06, 0xFF, 0xFF, 0x97, 0x75, 0x03,
  0x0E, 0xC0, 0x37, 0x77, 0x10, 0x4D, 0x05, 0x77, 0x71, 0x03, 0xD0, 0x77, 0x77, 0x20, 0xDC, 0x0C,
  0x77, 0x72, 0x07, 0xD0, 0x47, 0x77, 0x20, 0xDD, 0x77, 0x72, 0x02, 0xD0, 0xD7, 0x77, 0x20, 0x3E,
  0x77, 0x72, 0x03, 0xE8, 0x3A, 0x10, 0x25, 0x77, 0x5F, 0xC7, 0x75, 0x0A, 0xFB, 0x77, 0x50, 0x20,
  0xEF, 0xA7, 0x76, 0x03, 0x0E, 0xF9, 0x77, 0x71, 0x81, 0x6B, 0xEA, 0x81, 0xDB, 0x73,
  // "İ" (U+0130)
  0x72, 0x81, 0x29, 0xDA, 0x81, 0xD9, 0x27, 0x73, 0x03, 0x0E, 0xE0, 0xE0, 0x37, 0x72, 0x0D, 0xF9,
  0x0C, 0x77, 0x10, 0x2F, 0xB0, 0x17, 0x70, 0x4F, 0xB0, 0x37, 0x70, 0x4F, 0xB0, 0x37, 0x70, 0x2F,
  0xB0, 0x17, 0x71, 0x0D, 0xF9, 0x0B, 0x77, 0x20, 0x4F, 0x0E, 0x02, 0x77, 0x38, 0x12, 0x9D, 0xA8,
  0x1D, 0x81, 0x80, 0x9D, 0x50, 0x09, 0xFF, 0xFB, 0x00, 0x9F, 0xFF, 0xB0, 0x09, 0xFF, 0xFB, 0x00,
  0x9F, 0xFF, 0xB0, 0x09, 0xFF, 0xFB, 0x00, 0x9F, 0xFF, 0xB8, 0x79, 0x13, 0x57, 0x8A, 0xCE, 0xFB,
  0x86, 0xDC, 0xA8, 0x75, 0x31, 0x71, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04,
  0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17,
  0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F,
  0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77,
  0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9,
  0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72,
  0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90,
  0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x17, 0x72, 0x04, 0xF9, 0x01, 0x77, 0x20,
  0x4F, 0x90, 0x17, 0x38, 0x51, 0x24, 0x68, 0x9C, 0xF9, 0x85, 0xB9, 0x76, 0x42, 0x12, 0x08, 0x0E,
  0xFF, 0xF9, 0x81, 0xE8, 0x9F, 0xFF, 0xB0, 0x09, 0xFF, 0xFB, 0x00, 0x9F, 0xFF, 0xB0, 0x09, 0xFF,
  0xFB, 0x00, 0x9F, 0xFF, 0xB0, 0x90,
  // "ı" (U+0131)
  0x20, 0xCF, 0xFB, 0x03, 0x74, 0x0C, 0xFF, 0xB0, 0x37, 0x40, 0xCF, 0xFB, 0x03, 0x74, 0x0C, 0xFF,
  0xB0, 0x37, 0x40, 0xCF, 0xFB, 0x03, 0x74, 0x0C, 0xFF, 0xB0, 0x37, 0x48, 0x61, 0x35, 0x78, 0xAC,
  0xDF, 0xB0, 0x37, 0x76, 0x08, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03,
  0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07,
  0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37,
  0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F,
  0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x76, 0x07, 0xF9, 0x03, 0x77,
  0x60, 0x7F, 0x90, 0x37, 0x78, 0x41, 0x35, 0x8A, 0xDF, 0xB8, 0x3C, 0x96, 0x41, 0x48, 0x31, 0x69,
  0xBE, 0xFF, 0xF8, 0x3E, 0xB8, 0x56, 0xFF, 0xFF, 0x90, 0x6F, 0xFF, 0xF9, 0x06, 0xFF, 0xFF, 0x90,
  0x6F, 0xFF, 0xF9, 0x06, 0xFF, 0xFF, 0x90,
  // "Ĳ" (U+0132)
  0x0E, 0xF0, 0x67, 0x10, 0x9F, 0x00, 0xEF, 0x06, 0x71, 0x09, 0xF0, 0x0E, 0xF0, 0x67, 0x10, 0x9F,
  0x00, 0xEF, 0x06, 0x71, 0x09, 0xF0, 0x0E, 0xF0, 0x67, 0x10, 0x9F, 0x00, 0xEF, 0x06, 0x71, 0x09,
  0xF0, 0x0E, 0xF0, 0x67, 0x10, 0x9F, 0x00, 0xEF, 0x06, 0x71, 0x09, 0xF0, 0x0E, 0xF0, 0x67, 0x10,
  0x9F, 0x00, 0xEF, 0x06, 0x71, 0x09, 0xF0, 0x0E, 0xF0, 0x67, 0x10, 0x9F, 0x00, 0xEF, 0x06, 0x71,
  0x09, 0xF0, 0x0E, 0xF0, 0x67, 0x10, 0x9F, 0x00, 0xEF, 0x06, 0x71, 0x09, 0xF0, 0x0E, 0xF0, 0x67,
  0x10, 0x9F, 0x00, 0xEF, 0x06, 0x71, 0x09, 0xF0, 0x0E, 0xF0, 0x67, 0x10, 0x9F, 0x00, 0xEF, 0x06,
  0x71, 0x09, 0xF0, 0x0E, 0xF0, 0x67, 0x10, 0x9F, 0x00, 0xEF, 0x06, 0x71, 0x09, 0xF0, 0x0E, 0xF0,
  0x67, 0x10, 0x9F, 0x00, 0xEF, 0x06, 0x71, 0x09, 0xF0, 0x0E, 0xF0, 0x67, 0x10, 0x9F, 0x00, 0xEF,
  0x06, 0x71, 0x09, 0xF0, 0x0E, 0xF0, 0x67, 0x10, 0x9F, 0x00, 0xEF, 0x06, 0x71, 0x09, 0xF0, 0x0E,
  0xF0, 0x67, 0x10, 0x9F, 0x00, 0xEF, 0x06, 0x71, 0x09, 0xF0, 0xD0, 0xEF, 0x06, 0x71, 0x0A, 0xF0,
  0xC0, 0xEF, 0x06, 0x71, 0x0B, 0xF0, 0xB7, 0x73, 0x0D, 0xF0, 0xA7, 0x72, 0x02, 0xF9, 0x08, 0x77,
  0x20, 0x9F, 0x90, 0x47, 0x71, 0x04, 0xFA, 0x82, 0x15, 0x41, 0x73, 0x01, 0x08, 0xFA, 0x81, 0xB0,
  0xDA, 0x89, 0x0E, 0xCA, 0x98, 0x77, 0x79, 0xCF, 0xC8, 0x14, 0x0D, 0xFF, 0xF9, 0x0C, 0x20, 0xDF,
  0xFF, 0x0E, 0x02, 0x20, 0xDF, 0xFF, 0x05, 0x30, 0xDF, 0xFD, 0x0E, 0x05, 0x40, 0xDF, 0xFC, 0x0A,
  0x01, 0x58, 0x15, 0x9D, 0xFE, 0x81, 0xC7, 0x17, 0x48, 0x91, 0x23, 0x56, 0x77, 0x77, 0x64, 0x27,
  0x40,
  // "ĳ" (U+0133)
  0x28, 0x63, 0xAD, 0xFE, 0xC8, 0x17, 0x18, 0x61, 0x8C, 0xEF, 0xDA, 0x33, 0x05, 0xF0, 0xD0, 0x16,
  0x01, 0x0D, 0xF8, 0x26, 0x01, 0xEF, 0x90, 0xA6, 0x09, 0xF9, 0x81, 0xE1, 0x5F, 0xA0, 0xE6, 0x0E,
  0xFA, 0x05, 0x07, 0xFB, 0x01, 0x40, 0x1F, 0xB0, 0x07, 0xFB, 0x01, 0x40, 0x1F, 0xB0, 0x70, 0x5F,
  0xA0, 0xE6, 0x0E, 0xFA, 0x81, 0x41, 0xEF, 0x90, 0x96, 0x0A, 0xF9, 0x0E, 0x20, 0x6F, 0x0D, 0x01,
  0x60, 0x10, 0xDF, 0x05, 0x38, 0x53, 0xAE, 0xFE, 0xC7, 0x72, 0x81, 0x18, 0xDA, 0x81, 0xDA, 0x38,
  0x0A, 0x93, 0x00, 0xAF, 0x97, 0x02, 0xF9, 0x08, 0x20, 0xAF, 0x97, 0x02, 0xF9, 0x08, 0x20, 0xAF,
  0x97, 0x02, 0xF9, 0x08, 0x20, 0xAF, 0x97, 0x02, 0xF9, 0x08, 0x20, 0xAF, 0x97, 0x02, 0xF9, 0x08,
  0x20, 0xAF, 0x97, 0x02, 0xF9, 0x08, 0x20, 0xAF, 0x97, 0x02, 0xF9, 0x08, 0x20, 0xAF, 0x97, 0x02,
  0xF9, 0x08, 0x20, 0xAF, 0x97, 0x02, 0xF9, 0x08, 0x20, 0xAF, 0x97, 0x02, 0xF9, 0x08, 0x20, 0xAF,
  0x97, 0x02, 0xF9, 0x08, 0x20, 0xAF, 0x97, 0x02, 0xF9, 0x08, 0x20, 0xAF, 0x97, 0x02, 0xF9, 0x08,
  0x20, 0xAF, 0x97, 0x02, 0xF9, 0x08, 0x20, 0xAF, 0x97, 0x02, 0xF9, 0x08, 0x20, 0xAF, 0x97, 0x02,
  0xF9, 0x08, 0x20, 0xAF, 0x97, 0x02, 0xF9, 0x08, 0x20, 0xAF, 0x97, 0x02, 0xF9, 0x08, 0x20, 0xAF,
  0x97, 0x02, 0xF9, 0x08, 0x20, 0xAF, 0x97, 0x02, 0xF9, 0x08, 0x20, 0xAF, 0x97, 0x02, 0xF9, 0x08,
  0x20, 0xAF, 0x97, 0x02, 0xF9, 0x08, 0x20, 0xAF, 0x97, 0x02, 0xF9, 0x08, 0x20, 0xAF, 0x97, 0x02,
  0xF9, 0x08, 0x20, 0xAF, 0x97, 0x02, 0xF9, 0x08, 0x20, 0xAF, 0x97, 0x02, 0xF9, 0x08, 0x20, 0xAF,
  0x97, 0x02, 0xF9, 0x08, 0x20, 0xAF, 0x97, 0x02, 0xF9, 0x08, 0x20, 0xAF, 0x97, 0x02, 0xF9, 0x08,
  0x20, 0xAF, 0x97, 0x02, 0xF9, 0x08, 0x20, 0xAF, 0x97, 0x02, 0xF9, 0x08, 0x20, 0xAF, 0x97, 0x02,
  0xF9, 0x08, 0x77, 0x40, 0x3F, 0x90, 0x87, 0x74, 0x04, 0xF9, 0x07, 0x77, 0x40, 0x6F, 0x90, 0x67,
  0x74, 0x0B, 0xF9, 0x05, 0x77, 0x30, 0x2F, 0xA0, 0x37, 0x72, 0x01, 0x0C, 0xF9, 0x0E, 0x58, 0x4B,
  0xB8, 0x53, 0x14, 0x81, 0x37, 0xEF, 0xA0, 0xB5, 0x0C, 0xFF, 0xF0, 0x45, 0x0C, 0xFF, 0xE0, 0xC6,
  0x0C, 0xFF, 0xD0, 0xE0, 0x36, 0x0C, 0xFF, 0xD0, 0x57, 0x0C, 0xFF, 0xB0, 0xD0, 0x37, 0x10, 0xAF,
  0xF9, 0x0D, 0x07, 0x74, 0x85, 0x14, 0x79, 0xBD, 0xEA, 0x84, 0xED, 0xCA, 0x73, 0x72,
  // "Ĵ" (U+0134)
  0x77, 0x10, 0x28, 0x04, 0x70, 0x67, 0x77, 0x10, 0xCF, 0xA0, 0x47, 0x76, 0x07, 0xFB, 0x0D, 0x77,
  0x50, 0x3F, 0xD0, 0x97, 0x73, 0x01, 0x0D, 0xFE, 0x05, 0x77, 0x20, 0xAE, 0x0A, 0x05, 0xE0, 0xE0,
  0x27, 0x70, 0x7E, 0x0A, 0x20, 0x5E, 0x0D, 0x01, 0x75, 0x04, 0xE0, 0x94, 0x04, 0x0E, 0xD0, 0xB7,
  0x40, 0x30, 0xED, 0x07, 0x60, 0x30, 0xDD, 0x08, 0x73, 0x0C, 0xC0, 0xE0, 0x47, 0x10, 0x10, 0xBD,
  0x02, 0x80, 0xA9, 0x30, 0x01, 0xF9, 0x06, 0x77, 0x71, 0x01, 0xF9, 0x06, 0x77, 0x71, 0x01, 0xF9,
  0x06, 0x77, 0x71, 0x01, 0xF9, 0x06, 0x77, 0x71, 0x01, 0xF9, 0x06, 0x77, 0x71, 0x01, 0xF9, 0x06,
  0x77, 0x71, 0x01, 0xF9, 0x06, 0x77, 0x71, 0x01, 0xF9, 0x06, 0x77, 0x71, 0x01, 0xF9, 0x06, 0x77,
  0x71, 0x01, 0xF9, 0x06, 0x77, 0x71, 0x01, 0xF9, 0x06, 0x77, 0x71, 0x01, 0xF9, 0x06, 0x77, 0x71,
  0x01, 0xF9, 0x06, 0x77, 0x71, 0x01, 0xF9, 0x06, 0x77, 0x71, 0x01, 0xF9, 0x06, 0x77, 0x71, 0x01,
  0xF9, 0x06, 0x77, 0x71, 0x01, 0xF9, 0x06, 0x77, 0x71, 0x01, 0xF9, 0x06, 0x77, 0x71, 0x01, 0xF9,
  0x06, 0x77, 0x71, 0x01, 0xF9, 0x06, 0x77, 0x71, 0x01, 0xF9, 0x06, 0x77, 0x71, 0x01, 0xF9, 0x06,
  0x77, 0x71, 0x01, 0xF9, 0x06, 0x77, 0x71, 0x01, 0xF9, 0x06, 0x77, 0x71, 0x01, 0xF9, 0x06, 0x77,
  0x71, 0x01, 0xF9, 0x06, 0x77, 0x71, 0x01, 0xF9, 0x06, 0x77, 0x71, 0x01, 0xF9, 0x06, 0x77, 0x71,
  0x02, 0xF9, 0x05, 0x77, 0x71, 0x03, 0xF9, 0x04, 0x77, 0x71, 0x05, 0xF9, 0x03, 0x77, 0x71, 0x09,
  0xF9, 0x01, 0x77, 0x70, 0x10, 0xEF, 0x0C, 0x77, 0x71, 0x0A, 0xF9, 0x09, 0x71, 0x81, 0x64, 0x17,
  0x20, 0x20, 0xBF, 0xA0, 0x47, 0x10, 0xEA, 0x87, 0xEC, 0xA9, 0x77, 0x79, 0xCF, 0xB0, 0xC7, 0x20,
  0xEF, 0xFF, 0x05, 0x72, 0x0E, 0xFF, 0xE0, 0xA7, 0x30, 0xEF, 0xFD, 0x0D, 0x01, 0x73, 0x0E, 0xFF,
  0xC0, 0xC0, 0x17, 0x40, 0xEF, 0xFA, 0x0E, 0x07, 0x76, 0x81, 0x6A, 0xDF, 0xC8, 0x1E, 0xA5, 0x77,
  0x58, 0x90, 0x34, 0x67, 0x77, 0x76, 0x42, 0x77, 0x40,
  // "ĵ" (U+0135)
  0x77, 0x02, 0x80, 0x47, 0x06, 0x77, 0x70, 0xCF, 0xA0, 0x47, 0x75, 0x07, 0xFB, 0x0D, 0x77, 0x40,
  0x3F, 0xD0, 0x97, 0x72, 0x01, 0x0D, 0xFE, 0x05, 0x77, 0x10, 0xAE, 0x0A, 0x05, 0xE0, 0xE0, 0x27,
  0x60, 0x7E, 0x0A, 0x20, 0x5E, 0x0D, 0x01, 0x74, 0x04, 0xE0, 0x94, 0x04, 0x0E, 0xD0, 0xB7, 0x30,
  0x30, 0xED, 0x07, 0x60, 0x30, 0xDD, 0x08, 0x72, 0x0C, 0xC0, 0xE0, 0x47, 0x10, 0x10, 0xBD, 0x02,
  0x80, 0x9F, 0x50, 0x04, 0xFF, 0xB0, 0xB7, 0x50, 0x4F, 0xFB, 0x0B, 0x75, 0x04, 0xFF, 0xB0, 0xB7,
  0x50, 0x4F, 0xFB, 0x0B, 0x75, 0x04, 0xFF, 0xB0, 0xB7, 0x50, 0x4F, 0xFB, 0x0B, 0x76, 0x85, 0x46,
  0x79, 0xBC, 0xEF, 0xB0, 0xB7, 0x77, 0x02, 0x0E, 0xF0, 0xB7, 0x77, 0x10, 0xEF, 0x0B, 0x77, 0x71,
  0x0E, 0xF0, 0xB7, 0x77, 0x10, 0xEF, 0x0B, 0x77, 0x71, 0x0E, 0xF0, 0xB7, 0x77, 0x10, 0xEF, 0x0B,
  0x77, 0x71, 0x0E, 0xF0, 0xB7, 0x77, 0x10, 0xEF, 0x0B, 0x77, 0x71, 0x0E, 0xF0, 0xB7, 0x77, 0x10,
  0xEF, 0x0B, 0x77, 0x71, 0x0E, 0xF0, 0xB7, 0x77, 0x10, 0xEF, 0x0B, 0x77, 0x71, 0x0E, 0xF0, 0xB7,
  0x77, 0x10, 0xEF, 0x0B, 0x77, 0x71, 0x0E, 0xF0, 0xB7, 0x77, 0x10, 0xEF, 0x0B, 0x77, 0x71, 0x0E,
  0xF0, 0xB7, 0x77, 0x10, 0xEF, 0x0B, 0x77, 0x71, 0x0E, 0xF0, 0xB7, 0x77, 0x10, 0xEF, 0x0B, 0x77,
  0x71, 0x0E, 0xF0, 0xB7, 0x77, 0x10, 0xEF, 0x0B, 0x77, 0x71, 0x0E, 0xF0, 0xB7, 0x77, 0x10, 0xEF,
  0x0B, 0x77, 0x71, 0x0E, 0xF0, 0xB7, 0x77, 0x1F, 0x90, 0xB7, 0x77, 0x01, 0xF9, 0x0A, 0x77, 0x70,
  0x3F, 0x90, 0x97, 0x77, 0x07, 0xF9, 0x08, 0x77, 0x70, 0xDF, 0x90, 0x67, 0x76, 0x0A, 0xFA, 0x02,
  0x78, 0x49, 0xC8, 0x63, 0x24, 0x81, 0x26, 0xDF, 0xA0, 0xE7, 0x10, 0x9F, 0xFF, 0x07, 0x71, 0x09,
  0xFF, 0xE0, 0xE0, 0x17, 0x10, 0x9F, 0xFE, 0x05, 0x72, 0x09, 0xFF, 0xD0, 0x77, 0x30, 0x9F, 0xFB,
  0x0E, 0x05, 0x74, 0x07, 0xFF, 0x98, 0x1E, 0x81, 0x77, 0x89, 0x44, 0x69, 0xBC, 0xEE, 0xFE, 0xDD,
  0xA7, 0x47, 0x71,
  // "Ķ" (U+0136)
  0x04, 0xF9, 0x03, 0x75, 0x0D, 0xF9, 0x09, 0x04, 0xF9, 0x03, 0x74, 0x09, 0xF9, 0x81, 0xD0, 0x4F,
  0x90, 0x37, 0x30, 0x4F, 0xA8, 0x13, 0x04, 0xF9, 0x03, 0x73, 0x0D, 0xF9, 0x07, 0x20, 0x4F, 0x90,
  0x37, 0x20, 0x9F, 0x90, 0xB3, 0x04, 0xF9, 0x03, 0x71, 0x04, 0xF9, 0x0E, 0x01, 0x30, 0x4F, 0x90,
  0x37, 0x01, 0x0D, 0xF9, 0x04, 0x40, 0x4F, 0x90, 0x37, 0x0A, 0xF9, 0x09, 0x50, 0x4F, 0x90, 0x36,
  0x04, 0xF9, 0x0D, 0x60, 0x4F, 0x90, 0x35, 0x01, 0x0E, 0xF9, 0x03, 0x60, 0x4F, 0x90, 0x35, 0x0A,
  0xF9, 0x07, 0x70, 0x4F, 0x90, 0x34, 0x05, 0xF9, 0x0B, 0x71, 0x04, 0xF9, 0x03, 0x30, 0x10, 0xEF,
  0x0E, 0x01, 0x71, 0x04, 0xF9, 0x03, 0x30, 0xAF, 0x90, 0x47, 0x20, 0x4F, 0x90, 0x32, 0x05, 0xF9,
  0x09, 0x73, 0x04, 0xF9, 0x82, 0x30, 0x1E, 0xF0, 0xD7, 0x40, 0x4F, 0x98, 0x13, 0x09, 0xF9, 0x03,
  0x74, 0x04, 0xF9, 0x00, 0x3F, 0x90, 0x77, 0x50, 0x4F, 0x90, 0x30, 0xCF, 0x0B, 0x76, 0x04, 0xF9,
  0x08, 0xF9, 0x0C, 0x76, 0x04, 0xFF, 0xC0, 0x57, 0x50, 0x4F, 0xFC, 0x0D, 0x75, 0x04, 0xFF, 0xD0,
  0x77, 0x40, 0x4F, 0xFD, 0x0E, 0x01, 0x73, 0x04, 0xFF, 0xE0, 0x97, 0x30, 0x4F, 0xB8, 0x1E, 0x5D,
  0xF9, 0x03, 0x72, 0x04, 0xFA, 0x82, 0xE3, 0x05, 0xF9, 0x0B, 0x72, 0x04, 0xF9, 0x0D, 0x02, 0x30,
  0xCF, 0x90, 0x57, 0x10, 0x4F, 0x90, 0x34, 0x04, 0xF9, 0x0D, 0x71, 0x04, 0xF9, 0x03, 0x50, 0xBF,
  0x90, 0x77, 0x04, 0xF9, 0x03, 0x50, 0x3F, 0x90, 0xE0, 0x16, 0x04, 0xF9, 0x03, 0x60, 0xAF, 0x90,
  0x96, 0x04, 0xF9, 0x03, 0x60, 0x2F, 0xA0, 0x35, 0x04, 0xF9, 0x03, 0x70, 0x8F, 0x90, 0xB5, 0x04,
  0xF9, 0x03, 0x70, 0x10, 0xEF, 0x90, 0x54, 0x04, 0xF9, 0x03, 0x71, 0x07, 0xF9, 0x0D, 0x40, 0x4F,
  0x90, 0x37, 0x20, 0xDF, 0x90, 0x73, 0x04, 0xF9, 0x03, 0x72, 0x06, 0xF9, 0x0E, 0x01, 0x20, 0x4F,
  0x90, 0x37, 0x30, 0xCF, 0x90, 0x92, 0x04, 0xF9, 0x03, 0x73, 0x04, 0xFA, 0x81, 0x20, 0x4F, 0x90,
  0x37, 0x40, 0xBF, 0x98, 0x1B, 0x04, 0xF9, 0x03, 0x74, 0x03, 0xFA, 0x04, 0x80, 0x9C, 0x70, 0x02,
  0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x08, 0x77, 0x72, 0x07, 0xF0, 0x17, 0x77, 0x20, 0xAE, 0x09, 0x77,
  0x73, 0x0D, 0xE0, 0x27, 0x77, 0x20, 0x1E, 0x09, 0x77, 0x73, 0x04, 0xE0, 0x17, 0x77, 0x30, 0x7D,
  0x08, 0x77, 0x74, 0x0B, 0xC0, 0xD7, 0x77, 0x50, 0xEC, 0x05, 0x77, 0x20,
  // "ķ" (U+0137)
  0x06, 0xF9, 0x04, 0x77, 0x71, 0x06, 0xF9, 0x04, 0x77, 0x71, 0x06, 0xF9, 0x04, 0x77, 0x71, 0x06,
  0xF9, 0x04, 0x77, 0x71, 0x06, 0xF9, 0x04, 0x77, 0x71, 0x06, 0xF9, 0x04, 0x77, 0x71, 0x06, 0xF9,
  0x04, 0x77, 0x71, 0x06, 0xF9, 0x04, 0x77, 0x71, 0x06, 0xF9, 0x04, 0x77, 0x71, 0x06, 0xF9, 0x04,
  0x77, 0x71, 0x06, 0xF9, 0x04, 0x77, 0x71, 0x06, 0xF9, 0x04, 0x77, 0x71, 0x06, 0xF9, 0x04, 0x77,
  0x71, 0x06, 0xF9, 0x04, 0x73, 0x03, 0xFA, 0x81, 0xC0, 0x6F, 0x90, 0x47, 0x20, 0x20, 0xEF, 0x98,
  0x2D, 0x10, 0x6F, 0x90, 0x47, 0x10, 0x10, 0xDF, 0x90, 0xE0, 0x22, 0x06, 0xF9, 0x04, 0x71, 0x0B,
  0xF9, 0x0E, 0x03, 0x30, 0x6F, 0x90, 0x47, 0x0A, 0xFA, 0x04, 0x40, 0x6F, 0x90, 0x46, 0x08, 0xFA,
  0x05, 0x50, 0x6F, 0x90, 0x45, 0x05, 0xFA, 0x07, 0x60, 0x6F, 0x90, 0x44, 0x04, 0xFA, 0x08, 0x70,
  0x6F, 0x90, 0x43, 0x02, 0x0E, 0xF9, 0x0A, 0x71, 0x06, 0xF9, 0x04, 0x20, 0x10, 0xDF, 0x90, 0xB7,
  0x20, 0x6F, 0x90, 0x32, 0x0B, 0xF9, 0x0C, 0x73, 0x06, 0xF9, 0x81, 0x20, 0x9F, 0x90, 0xD0, 0x17,
  0x30, 0x6F, 0x90, 0x10, 0x6F, 0x90, 0xE0, 0x27, 0x40, 0x6F, 0x81, 0xE2, 0xEF, 0x90, 0x77, 0x50,
  0x6F, 0x0D, 0x0C, 0xFA, 0x0E, 0x02, 0x74, 0x06, 0xFF, 0xD0, 0xB7, 0x40, 0x6F, 0xFE, 0x07, 0x73,
  0x06, 0xFF, 0xF0, 0x27, 0x20, 0x6F, 0xD0, 0xEF, 0x90, 0xC7, 0x20, 0x6F, 0xC8, 0x1B, 0x18, 0xF9,
  0x08, 0x71, 0x06, 0xFB, 0x08, 0x30, 0xDF, 0x90, 0x37, 0x06, 0xF9, 0x0E, 0x04, 0x40, 0x3F, 0x90,
  0xD7, 0x06, 0xF9, 0x04, 0x60, 0x8F, 0x90, 0x96, 0x06, 0xF9, 0x04, 0x70, 0xDF, 0x90, 0x45, 0x06,
  0xF9, 0x04, 0x70, 0x3F, 0x90, 0xD5, 0x06, 0xF9, 0x04, 0x71, 0x09, 0xF9, 0x09, 0x40, 0x6F, 0x90,
  0x47, 0x20, 0xDF, 0x90, 0x53, 0x06, 0xF9, 0x04, 0x72, 0x04, 0xF9, 0x0E, 0x01, 0x20, 0x6F, 0x90,
  0x47, 0x30, 0x9F, 0x90, 0xA2, 0x06, 0xF9, 0x04, 0x74, 0x0D, 0xF9, 0x81, 0x50, 0x6F, 0x90, 0x47,
  0x40, 0x4F, 0x98, 0x1E, 0x16, 0xF9, 0x04, 0x75, 0x09, 0xF9, 0x0B, 0x80, 0x9C, 0x70, 0x02, 0xF0,
  0xD7, 0x77, 0x20, 0x4F, 0x08, 0x77, 0x72, 0x07, 0xF0, 0x17, 0x77, 0x20, 0xAE, 0x09, 0x77, 0x73,
  0x0D, 0xE0, 0x27, 0x77, 0x20, 0x1E, 0x09, 0x77, 0x73, 0x04, 0xE0, 0x17, 0x77, 0x30, 0x7D, 0x08,
  0x77, 0x74, 0x0B, 0xC0, 0xD7, 0x77, 0x50, 0xEC, 0x05, 0x77, 0x20,
  // "ĸ" (U+0138)
  0x06, 0xF9, 0x04, 0x73, 0x03, 0xFA, 0x81, 0xC0, 0x6F, 0x90, 0x47, 0x20, 0x20, 0xEF, 0x98, 0x2D,
  0x10, 0x6F, 0x90, 0x47, 0x10, 0x10, 0xDF, 0x90, 0xE0, 0x22, 0x06, 0xF9, 0x04, 0x71, 0x0B, 0xF9,
  0x0E, 0x03, 0x30, 0x6F, 0x90, 0x47, 0x0A, 0xFA, 0x04, 0x40, 0x6F, 0x90, 0x46, 0x08, 0xFA, 0x05,
  0x50, 0x6F, 0x90, 0x45, 0x05, 0xFA, 0x07, 0x60, 0x6F, 0x90, 0x44, 0x04, 0xFA, 0x08, 0x70, 0x6F,
  0x90, 0x43, 0x02, 0x0E, 0xF9, 0x0A, 0x71, 0x06, 0xF9, 0x04, 0x20, 0x10, 0xDF, 0x90, 0xB7, 0x20,
  0x6F, 0x90, 0x32, 0x0B, 0xF9, 0x0C, 0x73, 0x06, 0xF9, 0x81, 0x20, 0x9F, 0x90, 0xD0, 0x17, 0x30,
  0x6F, 0x90, 0x10, 0x6F, 0x90, 0xE0, 0x27, 0x40, 0x6F, 0x81, 0xE2, 0xEF, 0x90, 0x77, 0x50, 0x6F,
  0x0D, 0x0C, 0xFA, 0x0E, 0x02, 0x74, 0x06, 0xFF, 0xD0, 0xB7, 0x40, 0x6F, 0xFE, 0x07, 0x73, 0x06,
  0xFF, 0xF0, 0x27, 0x20, 0x6F, 0xD0, 0xEF, 0x90, 0xC7, 0x20, 0x6F, 0xC8, 0x1B, 0x18, 0xF9, 0x08,
  0x71, 0x06, 0xFB, 0x08, 0x30, 0xDF, 0x90, 0x37, 0x06, 0xF9, 0x0E, 0x04, 0x40, 0x3F, 0x90, 0xD7,
  0x06, 0xF9, 0x04, 0x60, 0x8F, 0x90, 0x96, 0x06, 0xF9, 0x04, 0x70, 0xDF, 0x90, 0x45, 0x06, 0xF9,
  0x04, 0x70, 0x3F, 0x90, 0xD5, 0x06, 0xF9, 0x04, 0x71, 0x09, 0xF9, 0x09, 0x40, 0x6F, 0x90, 0x47,
  0x20, 0xDF, 0x90, 0x53, 0x06, 0xF9, 0x04, 0x72, 0x04, 0xF9, 0x0E, 0x01, 0x20, 0x6F, 0x90, 0x47,
  0x30, 0x9F, 0x90, 0xA2, 0x06, 0xF9, 0x04, 0x74, 0x0D, 0xF9, 0x81, 0x50, 0x6F, 0x90, 0x47, 0x40,
  0x4F, 0x98, 0x1E, 0x16, 0xF9, 0x04, 0x75, 0x09, 0xF9, 0x0B,
  // "Ĺ" (U+0139)
  0x60, 0x68, 0x04, 0x70, 0x67, 0x72, 0x04, 0xFA, 0x05, 0x77, 0x20, 0xDF, 0x90, 0x67, 0x72, 0x08,
  0xF9, 0x06, 0x77, 0x20, 0x3F, 0x90, 0x57, 0x73, 0x0D, 0xF0, 0x47, 0x73, 0x09, 0xE0, 0xE0, 0x47,
  0x73, 0x05, 0xE0, 0xE0, 0x37, 0x73, 0x02, 0x0E, 0xD0, 0xC0, 0x17, 0x74, 0x09, 0xD0, 0xA8, 0x09,
  0xF4, 0x00, 0x9F, 0x90, 0x17, 0x73, 0x09, 0xF9, 0x01, 0x77, 0x30, 0x9F, 0x90, 0x17, 0x73, 0x09,
  0xF9, 0x01, 0x77, 0x30, 0x9F, 0x90, 0x17, 0x73, 0x09, 0xF9, 0x01, 0x77, 0x30, 0x9F, 0x90, 0x17,
  0x73, 0x09, 0xF9, 0x01, 0x77, 0x30, 0x9F, 0x90, 0x17, 0x73, 0x09, 0xF9, 0x01, 0x77, 0x30, 0x9F,
  0x90, 0x17, 0x73, 0x09, 0xF9, 0x01, 0x77, 0x30, 0x9F, 0x90, 0x17, 0x73, 0x09, 0xF9, 0x01, 0x77,
  0x30, 0x9F, 0x90, 0x17, 0x73, 0x09, 0xF9, 0x01, 0x77, 0x30, 0x9F, 0x90, 0x17, 0x73, 0x09, 0xF9,
  0x01, 0x77, 0x30, 0x9F, 0x90, 0x17, 0x73, 0x09, 0xF9, 0x01, 0x77, 0x30, 0x9F, 0x90, 0x17, 0x73,
  0x09, 0xF9, 0x01, 0x77, 0x30, 0x9F, 0x90, 0x17, 0x73, 0x09, 0xF9, 0x01, 0x77, 0x30, 0x9F, 0x90,
  0x17, 0x73, 0x09, 0xF9, 0x01, 0x77, 0x30, 0x9F, 0x90, 0x17, 0x73, 0x09, 0xF9, 0x01, 0x77, 0x30,
  0x9F, 0x90, 0x17, 0x73, 0x09, 0xF9, 0x01, 0x77, 0x30, 0x9F, 0x90, 0x17, 0x73, 0x09, 0xF9, 0x01,
  0x77, 0x30, 0x9F, 0x90, 0x17, 0x73, 0x09, 0xF9, 0x01, 0x77, 0x30, 0x9F, 0xFF, 0xC0, 0xC0, 0x9F,
  0xFF, 0xC0, 0xC0, 0x9F, 0xFF, 0xC0, 0xC0, 0x9F, 0xFF, 0xC0, 0xC0, 0x9F, 0xFF, 0xC0, 0xC0, 0x9F,
  0xFF, 0xC0, 0xC0, 0x9F, 0xFF, 0xC0, 0xC0, 0x9F, 0xFF, 0xC0, 0xC0,
  // "ĺ" (U+013A)
  0x77, 0x20, 0x68, 0x04, 0x70, 0x67, 0x75, 0x04, 0xFA, 0x05, 0x77, 0x50, 0xDF, 0x90, 0x67, 0x75,
  0x08, 0xF9, 0x06, 0x77, 0x50, 0x3F, 0x90, 0x57, 0x76, 0x0D, 0xF0, 0x47, 0x76, 0x09, 0xE0, 0xE0,
  0x47, 0x76, 0x05, 0xE0, 0xE0, 0x37, 0x76, 0x02, 0x0E, 0xD0, 0xC0, 0x17, 0x77, 0x09, 0xD0, 0xA8,
  0x0A, 0x83, 0x00, 0x4F, 0xFB, 0x01, 0x74, 0x04, 0xFF, 0xB0, 0x17, 0x40, 0x4F, 0xFB, 0x01, 0x74,
  0x04, 0xFF, 0xB0, 0x17, 0x40, 0x4F, 0xFB, 0x01, 0x74, 0x04, 0xFF, 0xB0, 0x17, 0x68, 0x23, 0x69,
  0xCF, 0xD0, 0x17, 0x74, 0x81, 0x36, 0xCF, 0x90, 0x17, 0x76, 0x09, 0xF9, 0x01, 0x77, 0x60, 0x9F,
  0x90, 0x17, 0x76, 0x09, 0xF9, 0x01, 0x77, 0x60, 0x9F, 0x90, 0x17, 0x76, 0x09, 0xF9, 0x01, 0x77,
  0x60, 0x9F, 0x90, 0x17, 0x76, 0x09, 0xF9, 0x01, 0x77, 0x60, 0x9F, 0x90, 0x17, 0x76, 0x09, 0xF9,
  0x01, 0x77, 0x60, 0x9F, 0x90, 0x17, 0x76, 0x09, 0xF9, 0x01, 0x77, 0x60, 0x9F, 0x90, 0x17, 0x76,
  0x09, 0xF9, 0x01, 0x77, 0x60, 0x9F, 0x90, 0x17, 0x76, 0x09, 0xF9, 0x01, 0x77, 0x60, 0x9F, 0x90,
  0x17, 0x76, 0x09, 0xF9, 0x01, 0x77, 0x60, 0x9F, 0x90, 0x17, 0x76, 0x09, 0xF9, 0x01, 0x77, 0x60,
  0x9F, 0x90, 0x17, 0x76, 0x09, 0xF9, 0x01, 0x77, 0x60, 0x9F, 0x90, 0x17, 0x76, 0x09, 0xF9, 0x01,
  0x77, 0x60, 0x9F, 0x90, 0x17, 0x76, 0x09, 0xF9, 0x01, 0x77, 0x60, 0x9F, 0x90, 0x17, 0x76, 0x09,
  0xF9, 0x01, 0x77, 0x60, 0x9F, 0x90, 0x17, 0x76, 0x09, 0xF9, 0x01, 0x77, 0x60, 0x9F, 0x90, 0x17,
  0x78, 0x41, 0x36, 0x8B, 0xDF, 0xA8, 0x4E, 0xC9, 0x63, 0x14, 0x83, 0x16, 0x9B, 0xEF, 0xFF, 0x83,
  0xDB, 0x85, 0x6F, 0xFF, 0xF9, 0x06, 0xFF, 0xFF, 0x90, 0x6F, 0xFF, 0xF9, 0x06, 0xFF, 0xFF, 0x90,
  0x6F, 0xFF, 0xF9,
  // "Ļ" (U+013B)
  0x09, 0xF9, 0x01, 0x77, 0x30, 0x9F, 0x90, 0x17, 0x73, 0x09, 0xF9, 0x01, 0x77, 0x30, 0x9F, 0x90,
  0x17, 0x73, 0x09, 0xF9, 0x01, 0x77, 0x30, 0x9F, 0x90, 0x17, 0x73, 0x09, 0xF9, 0x01, 0x77, 0x30,
  0x9F, 0x90, 0x17, 0x73, 0x09, 0xF9, 0x01, 0x77, 0x30, 0x9F, 0x90, 0x17, 0x73, 0x09, 0xF9, 0x01,
  0x77, 0x30, 0x9F, 0x90, 0x17, 0x73, 0x09, 0xF9, 0x01, 0x77, 0x30, 0x9F, 0x90, 0x17, 0x73, 0x09,
  0xF9, 0x01, 0x77, 0x30, 0x9F, 0x90, 0x17, 0x73, 0x09, 0xF9, 0x01, 0x77, 0x30, 0x9F, 0x90, 0x17,
  0x73, 0x09, 0xF9, 0x01, 0x77, 0x30, 0x9F, 0x90, 0x17, 0x73, 0x09, 0xF9, 0x01, 0x77, 0x30, 0x9F,
  0x90, 0x17, 0x73, 0x09, 0xF9, 0x01, 0x77, 0x30, 0x9F, 0x90, 0x17, 0x73, 0x09, 0xF9, 0x01, 0x77,
  0x30, 0x9F, 0x90, 0x17, 0x73, 0x09, 0xF9, 0x01, 0x77, 0x30, 0x9F, 0x90, 0x17, 0x73, 0x09, 0xF9,
  0x01, 0x77, 0x30, 0x9F, 0x90, 0x17, 0x73, 0x09, 0xF9, 0x01, 0x77, 0x30, 0x9F, 0x90, 0x17, 0x73,
  0x09, 0xF9, 0x01, 0x77, 0x30, 0x9F, 0x90, 0x17, 0x73, 0x09, 0xFF, 0xFC, 0x0C, 0x09, 0xFF, 0xFC,
  0x0C, 0x09, 0xFF, 0xFC, 0x0C, 0x09, 0xFF, 0xFC, 0x0C, 0x09, 0xFF, 0xFC, 0x0C, 0x09, 0xFF, 0xFC,
  0x0C, 0x09, 0xFF, 0xFC, 0x0C, 0x09, 0xFF, 0xFC, 0x0C, 0x80, 0x9A, 0x70, 0x02, 0xF0, 0xD7, 0x74,
  0x04, 0xF0, 0x87, 0x74, 0x07, 0xF0, 0x17, 0x74, 0x0A, 0xE0, 0x97, 0x75, 0x0D, 0xE0, 0x27, 0x74,
  0x01, 0xE0, 0x97, 0x75, 0x04, 0xE0, 0x17, 0x75, 0x07, 0xD0, 0x87, 0x76, 0x0B, 0xC0, 0xD7, 0x77,
  0x0E, 0xC0, 0x57, 0x50,
  // "ļ" (U+013C)
  0x20, 0x4F, 0xFB, 0x01, 0x74, 0x04, 0xFF, 0xB0, 0x17, 0x40, 0x4F, 0xFB, 0x01, 0x74, 0x04, 0xFF,
  0xB0, 0x17, 0x40, 0x4F, 0xFB, 0x01, 0x74, 0x04, 0xFF, 0xB0, 0x17, 0x68, 0x23, 0x69, 0xCF, 0xD0,
  0x17, 0x74, 0x81, 0x36, 0xCF, 0x90, 0x17, 0x76, 0x09, 0xF9, 0x01, 0x77, 0x60, 0x9F, 0x90, 0x17,
  0x76, 0x09, 0xF9, 0x01, 0x77, 0x60, 0x9F, 0x90, 0x17, 0x76, 0x09, 0xF9, 0x01, 0x77, 0x60, 0x9F,
  0x90, 0x17, 0x76, 0x09, 0xF9, 0x01, 0x77, 0x60, 0x9F, 0x90, 0x17, 0x76, 0x09, 0xF9, 0x01, 0x77,
  0x60, 0x9F, 0x90, 0x17, 0x76, 0x09, 0xF9, 0x01, 0x77, 0x60, 0x9F, 0x90, 0x17, 0x76, 0x09, 0xF9,
  0x01, 0x77, 0x60, 0x9F, 0x90, 0x17, 0x76, 0x09, 0xF9, 0x01, 0x77, 0x60, 0x9F, 0x90, 0x17, 0x76,
  0x09, 0xF9, 0x01, 0x77, 0x60, 0x9F, 0x90, 0x17, 0x76, 0x09, 0xF9, 0x01, 0x77, 0x60, 0x9F, 0x90,
  0x17, 0x76, 0x09, 0xF9, 0x01, 0x77, 0x60, 0x9F, 0x90, 0x17, 0x76, 0x09, 0xF9, 0x01, 0x77, 0x60,
  0x9F, 0x90, 0x17, 0x76, 0x09, 0xF9, 0x01, 0x77, 0x60, 0x9F, 0x90, 0x17, 0x76, 0x09, 0xF9, 0x01,
  0x77, 0x60, 0x9F, 0x90, 0x17, 0x76, 0x09, 0xF9, 0x01, 0x77, 0x60, 0x9F, 0x90, 0x17, 0x78, 0x41,
  0x36, 0x8B, 0xDF, 0xA8, 0x4E, 0xC9, 0x63, 0x14, 0x83, 0x16, 0x9B, 0xEF, 0xFF, 0x83, 0xDB, 0x85,
  0x6F, 0xFF, 0xF9, 0x06, 0xFF, 0xFF, 0x90, 0x6F, 0xFF, 0xF9, 0x06, 0xFF, 0xFF, 0x90, 0x6F, 0xFF,
  0xF9, 0x80, 0x9C, 0x10, 0x02, 0xF0, 0xD7, 0x77, 0x04, 0xF0, 0x87, 0x77, 0x07, 0xF0, 0x17, 0x77,
  0x0A, 0xE0, 0x97, 0x77, 0x10, 0xDE, 0x02, 0x77, 0x70, 0x1E, 0x09, 0x77, 0x71, 0x04, 0xE0, 0x17,
  0x77, 0x10, 0x7D, 0x08, 0x77, 0x72, 0x0B, 0xC0, 0xD7, 0x77, 0x30, 0xEC, 0x05, 0x77,
  // "Ľ" (U+013D)
  0x09, 0xF9, 0x01, 0x71, 0x08, 0xF0, 0x70, 0x9F, 0x90, 0x17, 0x10, 0xAF, 0x02, 0x09, 0xF9, 0x01,
  0x71, 0x0D, 0xE8, 0x1A, 0x09, 0xF9, 0x01, 0x71, 0xF8, 0x13, 0x09, 0xF9, 0x01, 0x70, 0x3E, 0x0B,
  0x20, 0x9F, 0x90, 0x17, 0x06, 0xE0, 0x32, 0x09, 0xF9, 0x01, 0x70, 0xAD, 0x0B, 0x30, 0x9F, 0x90,
  0x17, 0x0D, 0xD0, 0x33, 0x09, 0xF9, 0x01, 0x60, 0x1D, 0x09, 0x40, 0x9F, 0x90, 0x16, 0x04, 0xC0,
  0xE0, 0x14, 0x09, 0xF9, 0x01, 0x77, 0x30, 0x9F, 0x90, 0x17, 0x73, 0x09, 0xF9, 0x01, 0x77, 0x30,
  0x9F, 0x90, 0x17, 0x73, 0x09, 0xF9, 0x01, 0x77, 0x30, 0x9F, 0x90, 0x17, 0x73, 0x09, 0xF9, 0x01,
  0x77, 0x30, 0x9F, 0x90, 0x17, 0x73, 0x09, 0xF9, 0x01, 0x77, 0x30, 0x9F, 0x90, 0x17, 0x73, 0x09,
  0xF9, 0x01, 0x77, 0x30, 0x9F, 0x90, 0x17, 0x73, 0x09, 0xF9, 0x01, 0x77, 0x30, 0x9F, 0x90, 0x17,
  0x73, 0x09, 0xF9, 0x01, 0x77, 0x30, 0x9F, 0x90, 0x17, 0x73, 0x09, 0xF9, 0x01, 0x77, 0x30, 0x9F,
  0x90, 0x17, 0x73, 0x09, 0xF9, 0x01, 0x77, 0x30, 0x9F, 0x90, 0x17, 0x73, 0x09, 0xF9, 0x01, 0x77,
  0x30, 0x9F, 0x90, 0x17, 0x73, 0x09, 0xF9, 0x01, 0x77, 0x30, 0x9F, 0x90, 0x17, 0x73, 0x09, 0xFF,
  0xFC, 0x0C, 0x09, 0xFF, 0xFC, 0x0C, 0x09, 0xFF, 0xFC, 0x0C, 0x09, 0xFF, 0xFC, 0x0C, 0x09, 0xFF,
  0xFC, 0x0C, 0x09, 0xFF, 0xFC, 0x0C, 0x09, 0xFF, 0xFC, 0x0C, 0x09, 0xFF, 0xFC, 0x0C,
  // "ľ" (U+013E)
  0x20, 0x4F, 0xFB, 0x01, 0x30, 0x5F, 0x0A, 0x20, 0x4F, 0xFB, 0x01, 0x30, 0x8F, 0x04, 0x20, 0x4F,
  0xFB, 0x01, 0x30, 0xBE, 0x0C, 0x30, 0x4F, 0xFB, 0x01, 0x30, 0xEE, 0x04, 0x30, 0x4F, 0xFB, 0x01,
  0x20, 0x2E, 0x0B, 0x58, 0x24, 0x79, 0xCF, 0xE0, 0x12, 0x05, 0xE0, 0x27, 0x38, 0x23, 0x69, 0xDF,
  0x90, 0x12, 0x09, 0xD0, 0x87, 0x70, 0x9F, 0x90, 0x12, 0x0D, 0xC0, 0xD7, 0x71, 0x09, 0xF9, 0x81,
  0x10, 0x1D, 0x03, 0x77, 0x10, 0x9F, 0x90, 0x17, 0x77, 0x20, 0x9F, 0x90, 0x17, 0x77, 0x20, 0x9F,
  0x90, 0x17, 0x77, 0x20, 0x9F, 0x90, 0x17, 0x77, 0x20, 0x9F, 0x90, 0x17, 0x77, 0x20, 0x9F, 0x90,
  0x17, 0x77, 0x20, 0x9F, 0x90, 0x17, 0x77, 0x20, 0x9F, 0x90, 0x17, 0x77, 0x20, 0x9F, 0x90, 0x17,
  0x77, 0x20, 0x9F, 0x90, 0x17, 0x77, 0x20, 0x9F, 0x90, 0x17, 0x77, 0x20, 0x9F, 0x90, 0x17, 0x77,
  0x20, 0x9F, 0x90, 0x17, 0x77, 0x20, 0x9F, 0x90, 0x17, 0x77, 0x20, 0x9F, 0x90, 0x17, 0x77, 0x20,
  0x9F, 0x90, 0x17, 0x77, 0x20, 0x9F, 0x90, 0x17, 0x77, 0x20, 0x9F, 0x90, 0x17, 0x77, 0x20, 0x9F,
  0x90, 0x17, 0x77, 0x20, 0x9F, 0x90, 0x17, 0x77, 0x20, 0x9F, 0x90, 0x17, 0x77, 0x20, 0x9F, 0x90,
  0x17, 0x77, 0x20, 0x9F, 0x90, 0x17, 0x77, 0x20, 0x9F, 0x90, 0x17, 0x77, 0x20, 0x9F, 0x90, 0x17,
  0x77, 0x20, 0x9F, 0x90, 0x17, 0x77, 0x20, 0x9F, 0x90, 0x17, 0x77, 0x20, 0x9F, 0x90, 0x17, 0x77,
  0x20, 0x9F, 0x90, 0x27, 0x73, 0x83, 0x25, 0x7A, 0xCF, 0xC8, 0x3D, 0xB8, 0x52, 0x78, 0x22, 0x7A,
  0xDF, 0xFF, 0xA8, 0x1C, 0x96, 0x30, 0x6F, 0xFF, 0xF9, 0x30, 0x6F, 0xFF, 0xF9, 0x30, 0x6F, 0xFF,
  0xF9, 0x30, 0x6F, 0xFF, 0xF9, 0x30, 0x6F, 0xFF, 0xF9, 0x30,
  // "Ŀ" (U+013F)
  0x09, 0xF9, 0x01, 0x77, 0x40, 0x9F, 0x90, 0x17, 0x74, 0x09, 0xF9, 0x01, 0x77, 0x40, 0x9F, 0x90,
  0x17, 0x74, 0x09, 0xF9, 0x01, 0x77, 0x40, 0x9F, 0x90, 0x17, 0x74, 0x09, 0xF9, 0x01, 0x77, 0x40,
  0x9F, 0x90, 0x17, 0x74, 0x09, 0xF9, 0x01, 0x77, 0x40, 0x9F, 0x90, 0x17, 0x74, 0x09, 0xF9, 0x01,
  0x77, 0x40, 0x9F, 0x90, 0x17, 0x74, 0x09, 0xF9, 0x01, 0x77, 0x40, 0x9F, 0x90, 0x17, 0x74, 0x09,
  0xF9, 0x01, 0x72, 0x84, 0x25, 0x77, 0x51, 0x30, 0x9F, 0x90, 0x17, 0x10, 0xAE, 0x08, 0x20, 0x9F,
  0x90, 0x17, 0x0A, 0xF9, 0x81, 0x80, 0x9F, 0x90, 0x16, 0x02, 0xFB, 0x01, 0x09, 0xF9, 0x01, 0x60,
  0x5F, 0xB0, 0x40, 0x9F, 0x90, 0x16, 0x06, 0xFB, 0x05, 0x09, 0xF9, 0x01, 0x60, 0x5F, 0xB0, 0x40,
  0x9F, 0x90, 0x16, 0x01, 0xFA, 0x81, 0xE1, 0x9F, 0x90, 0x17, 0x09, 0xF9, 0x81, 0x70, 0x9F, 0x90,
  0x17, 0x10, 0x8D, 0x0E, 0x07, 0x20, 0x9F, 0x90, 0x17, 0x28, 0x41, 0x57, 0x75, 0x13, 0x09, 0xF9,
  0x01, 0x77, 0x40, 0x9F, 0x90, 0x17, 0x74, 0x09, 0xF9, 0x01, 0x77, 0x40, 0x9F, 0x90, 0x17, 0x74,
  0x09, 0xF9, 0x01, 0x77, 0x40, 0x9F, 0x90, 0x17, 0x74, 0x09, 0xF9, 0x01, 0x77, 0x40, 0x9F, 0x90,
  0x17, 0x74, 0x09, 0xF9, 0x01, 0x77, 0x40, 0x9F, 0xFF, 0xC8, 0x1C, 0x09, 0xFF, 0xFC, 0x81, 0xC0,
  0x9F, 0xFF, 0xC8, 0x1C, 0x09, 0xFF, 0xFC, 0x81, 0xC0, 0x9F, 0xFF, 0xC8, 0x1C, 0x09, 0xFF, 0xFC,
  0x81, 0xC0, 0x9F, 0xFF, 0xC8, 0x1C, 0x09, 0xFF, 0xFC, 0x0C, 0x10,
  // "ŀ" (U+0140)
  0x20, 0x4F, 0xFB, 0x01, 0x77, 0x60, 0x4F, 0xFB, 0x01, 0x77, 0x60, 0x4F, 0xFB, 0x01, 0x77, 0x60,
  0x4F, 0xFB, 0x01, 0x77, 0x60, 0x4F, 0xFB, 0x01, 0x77, 0x60, 0x4F, 0xFB, 0x01, 0x77, 0x71, 0x82,
  0x36, 0x9C, 0xFD, 0x01, 0x77, 0x76, 0x81, 0x36, 0xCF, 0x90, 0x17, 0x77, 0x71, 0x09, 0xF9, 0x01,
  0x77, 0x77, 0x10, 0x9F, 0x90, 0x17, 0x77, 0x71, 0x09, 0xF9, 0x01, 0x77, 0x77, 0x10, 0x9F, 0x90,
  0x17, 0x77, 0x71, 0x09, 0xF9, 0x01, 0x77, 0x77, 0x10, 0x9F, 0x90, 0x17, 0x77, 0x71, 0x09, 0xF9,
  0x01, 0x77, 0x77, 0x10, 0x9F, 0x90, 0x17, 0x77, 0x71, 0x09, 0xF9, 0x01, 0x77, 0x77, 0x10, 0x9F,
  0x90, 0x17, 0x28, 0x42, 0x57, 0x75, 0x17, 0x70, 0x9F, 0x90, 0x17, 0x10, 0xAE, 0x08, 0x76, 0x09,
  0xF9, 0x01, 0x70, 0xAF, 0x90, 0x87, 0x50, 0x9F, 0x90, 0x16, 0x02, 0xFB, 0x01, 0x74, 0x09, 0xF9,
  0x01, 0x60, 0x5F, 0xB0, 0x47, 0x40, 0x9F, 0x90, 0x16, 0x06, 0xFB, 0x05, 0x74, 0x09, 0xF9, 0x01,
  0x60, 0x5F, 0xB0, 0x47, 0x40, 0x9F, 0x90, 0x16, 0x01, 0xFA, 0x0E, 0x01, 0x74, 0x09, 0xF9, 0x01,
  0x70, 0x9F, 0x90, 0x77, 0x50, 0x9F, 0x90, 0x17, 0x10, 0x8D, 0x0E, 0x07, 0x76, 0x09, 0xF9, 0x01,
  0x72, 0x84, 0x15, 0x77, 0x51, 0x77, 0x09, 0xF9, 0x01, 0x77, 0x77, 0x10, 0x9F, 0x90, 0x17, 0x77,
  0x71, 0x09, 0xF9, 0x01, 0x77, 0x77, 0x10, 0x9F, 0x90, 0x17, 0x77, 0x71, 0x09, 0xF9, 0x01, 0x77,
  0x77, 0x10, 0x9F, 0x90, 0x17, 0x77, 0x71, 0x09, 0xF9, 0x01, 0x77, 0x77, 0x10, 0x9F, 0x90, 0x17,
  0x77, 0x71, 0x09, 0xF9, 0x01, 0x77, 0x77, 0x10, 0x9F, 0x90, 0x17, 0x77, 0x28, 0x41, 0x36, 0x8B,
  0xDF, 0xA8, 0x4E, 0xC9, 0x63, 0x17, 0x68, 0x31, 0x69, 0xBE, 0xFF, 0xF8, 0x2D, 0xB8, 0x57, 0x20,
  0x6F, 0xFF, 0xF9, 0x72, 0x06, 0xFF, 0xFF, 0x97, 0x20, 0x6F, 0xFF, 0xF9, 0x72, 0x06, 0xFF, 0xFF,
  0x97, 0x20, 0x6F, 0xFF, 0xF9, 0x72,
  // "Ł" (U+0141)
  0x50, 0x3F, 0x90, 0x77, 0x77, 0x20, 0x3F, 0x90, 0x77, 0x77, 0x20, 0x3F, 0x90, 0x77, 0x77, 0x20,
  0x3F, 0x90, 0x77, 0x77, 0x20, 0x3F, 0x90, 0x77, 0x77, 0x20, 0x3F, 0x90, 0x77, 0x77, 0x20, 0x3F,
  0x90, 0x77, 0x77, 0x20, 0x3F, 0x90, 0x77, 0x77, 0x20, 0x3F, 0x90, 0x77, 0x77, 0x20, 0x3F, 0x90,
  0x77, 0x77, 0x20, 0x3F, 0x90, 0x77, 0x77, 0x20, 0x3F, 0x90, 0x77, 0x77, 0x20, 0x3F, 0x90, 0x73,
  0x02, 0x01, 0x77, 0x40, 0x3F, 0x98, 0x47, 0x01, 0x8F, 0x97, 0x74, 0x03, 0xF9, 0x81, 0x75, 0xEB,
  0x03, 0x77, 0x30, 0x3F, 0xF0, 0xC7, 0x73, 0x03, 0xFF, 0x90, 0x67, 0x72, 0x03, 0xFF, 0x90, 0xE0,
  0x17, 0x71, 0x03, 0xFF, 0x0D, 0x05, 0x77, 0x20, 0x3F, 0xD0, 0xE0, 0x77, 0x74, 0x09, 0xFC, 0x0A,
  0x01, 0x77, 0x30, 0x60, 0xEF, 0xB0, 0xC0, 0x37, 0x73, 0x03, 0x0C, 0xFC, 0x09, 0x77, 0x40, 0x5F,
  0xE0, 0x77, 0x75, 0x0D, 0xFD, 0x07, 0x77, 0x50, 0x5F, 0xD0, 0x77, 0x76, 0x0B, 0xFC, 0x07, 0x77,
  0x60, 0x2A, 0x0B, 0xF9, 0x07, 0x77, 0x78, 0x16, 0x33, 0xF9, 0x07, 0x77, 0x72, 0x03, 0xF9, 0x07,
  0x77, 0x72, 0x03, 0xF9, 0x07, 0x77, 0x72, 0x03, 0xF9, 0x07, 0x77, 0x72, 0x03, 0xF9, 0x07, 0x77,
  0x72, 0x03, 0xF9, 0x07, 0x77, 0x72, 0x03, 0xFF, 0xFD, 0x03, 0x50, 0x3F, 0xFF, 0xD0, 0x35, 0x03,
  0xFF, 0xFD, 0x03, 0x50, 0x3F, 0xFF, 0xD0, 0x35, 0x03, 0xFF, 0xFD, 0x03, 0x50, 0x3F, 0xFF, 0xD0,
  0x35, 0x03, 0xFF, 0xFD, 0x03, 0x50, 0x3F, 0xFF, 0xD0, 0x30,
  // "ł" (U+0142)
  0x20, 0x4F, 0xFB, 0x01, 0x74, 0x04, 0xFF, 0xB0, 0x17, 0x40, 0x4F, 0xFB, 0x01, 0x74, 0x04, 0xFF,
  0xB0, 0x17, 0x40, 0x4F, 0xFB, 0x01, 0x74, 0x04, 0xFF, 0xB0, 0x17, 0x68, 0x23, 0x69, 0xCF, 0xD0,
  0x17, 0x74, 0x81, 0x36, 0xCF, 0x90, 0x17, 0x76, 0x09, 0xF9, 0x01, 0x77, 0x60, 0x9F, 0x90, 0x17,
  0x76, 0x09, 0xF9, 0x01, 0x77, 0x60, 0x9F, 0x90, 0x17, 0x76, 0x09, 0xF9, 0x01, 0x77, 0x60, 0x9F,
  0x90, 0x17, 0x76, 0x09, 0xF9, 0x01, 0x77, 0x60, 0x9F, 0x90, 0x12, 0x04, 0x77, 0x30, 0x9F, 0x98,
  0x31, 0x1A, 0xF7, 0x77, 0x20, 0x9F, 0x90, 0x80, 0xEB, 0x02, 0x77, 0x10, 0x9F, 0xE0, 0xB7, 0x71,
  0x09, 0xFF, 0x05, 0x77, 0x09, 0xFF, 0x0D, 0x77, 0x09, 0xFE, 0x0D, 0x04, 0x77, 0x09, 0xFC, 0x0E,
  0x07, 0x77, 0x10, 0x7F, 0xC0, 0xA0, 0x17, 0x70, 0x40, 0xDF, 0xB0, 0xC0, 0x37, 0x70, 0x20, 0xBF,
  0xD0, 0x17, 0x70, 0x8F, 0xF0, 0x17, 0x60, 0xCF, 0xF9, 0x01, 0x76, 0x06, 0xFF, 0x90, 0x17, 0x70,
  0xCF, 0xF0, 0x17, 0x70, 0x3C, 0x0C, 0x0B, 0xF9, 0x01, 0x77, 0x18, 0x49, 0xFE, 0x50, 0x9F, 0x90,
  0x17, 0x71, 0x01, 0x08, 0x30, 0x9F, 0x90, 0x17, 0x76, 0x09, 0xF9, 0x01, 0x77, 0x60, 0x9F, 0x90,
  0x17, 0x76, 0x09, 0xF9, 0x01, 0x77, 0x60, 0x9F, 0x90, 0x17, 0x76, 0x09, 0xF9, 0x01, 0x77, 0x84,
  0x13, 0x68, 0xBD, 0xFA, 0x84, 0xEC, 0x96, 0x31, 0x48, 0x31, 0x69, 0xBE, 0xFF, 0xF8, 0x3D, 0xB8,
  0x56, 0xFF, 0xFF, 0x90, 0x6F, 0xFF, 0xF9, 0x06, 0xFF, 0xFF, 0x90, 0x6F, 0xFF, 0xF9, 0x06, 0xFF,
  0xFF, 0x90,
  // "Ń" (U+0143)
  0x77, 0x30, 0x68, 0x04, 0x70, 0x67, 0x77, 0x04, 0xFA, 0x05, 0x77, 0x70, 0xDF, 0x90, 0x67, 0x77,
  0x08, 0xF9, 0x06, 0x77, 0x70, 0x3F, 0x90, 0x57, 0x77, 0x10, 0xDF, 0x04, 0x77, 0x71, 0x09, 0xE0,
  0xE0, 0x47, 0x77, 0x10, 0x5E, 0x0E, 0x03, 0x77, 0x71, 0x02, 0x0E, 0xD0, 0xC0, 0x17, 0x77, 0x20,
  0x9D, 0x0A, 0x80, 0xA9, 0x20, 0x04, 0xFC, 0x0A, 0x73, 0x06, 0xF0, 0x04, 0xFD, 0x73, 0x06, 0xF0,
  0x04, 0xFD, 0x05, 0x72, 0x06, 0xF0, 0x04, 0xFD, 0x0A, 0x72, 0x06, 0xF0, 0x04, 0xFE, 0x72, 0x06,
  0xF0, 0x04, 0xFE, 0x05, 0x71, 0x06, 0xF0, 0x04, 0xFE, 0x0A, 0x71, 0x06, 0xF0, 0x04, 0xFF, 0x71,
  0x06, 0xF0, 0x04, 0xE0, 0xD0, 0xCE, 0x05, 0x70, 0x6F, 0x00, 0x4E, 0x0E, 0x07, 0xE0, 0xA7, 0x06,
  0xF0, 0x04, 0xF0, 0x2E, 0x0E, 0x70, 0x6F, 0x00, 0x4F, 0x10, 0xCE, 0x05, 0x60, 0x6F, 0x00, 0x4F,
  0x01, 0x07, 0xE0, 0xA6, 0x06, 0xF0, 0x04, 0xF0, 0x20, 0x1E, 0x0E, 0x60, 0x6F, 0x00, 0x4F, 0x81,
  0x30, 0xCE, 0x05, 0x50, 0x6F, 0x00, 0x4F, 0x81, 0x40, 0x7E, 0x0A, 0x50, 0x6F, 0x00, 0x4F, 0x81,
  0x40, 0x1E, 0x0E, 0x50, 0x6F, 0x00, 0x4F, 0x05, 0x20, 0xCE, 0x05, 0x40, 0x6F, 0x00, 0x4F, 0x05,
  0x20, 0x7E, 0x0A, 0x40, 0x6F, 0x00, 0x4F, 0x06, 0x20, 0x2E, 0x0E, 0x40, 0x6F, 0x00, 0x4F, 0x06,
  0x30, 0xCE, 0x05, 0x30, 0x6F, 0x00, 0x4F, 0x06, 0x30, 0x7E, 0x0A, 0x30, 0x6F, 0x00, 0x4F, 0x06,
  0x30, 0x2E, 0x0E, 0x30, 0x6F, 0x00, 0x4F, 0x06, 0x40, 0xCE, 0x05, 0x20, 0x6F, 0x00, 0x4F, 0x06,
  0x40, 0x7E, 0x0A, 0x20, 0x6F, 0x00, 0x4F, 0x06, 0x40, 0x2E, 0x0E, 0x20, 0x5F, 0x00, 0x4F, 0x06,
  0x50, 0xCE, 0x81, 0x50, 0x5F, 0x00, 0x4F, 0x06, 0x50, 0x7E, 0x81, 0xA0, 0x4F, 0x00, 0x4F, 0x06,
  0x50, 0x2E, 0x81, 0xE0, 0x4F, 0x00, 0x4F, 0x06, 0x60, 0xCE, 0x05, 0x03, 0xF0, 0x04, 0xF0, 0x66,
  0x07, 0xE0, 0xA0, 0x3F, 0x00, 0x4F, 0x06, 0x60, 0x2E, 0x0E, 0x02, 0xF0, 0x04, 0xF0, 0x67, 0x0C,
  0xE0, 0x6F, 0x00, 0x4F, 0x06, 0x70, 0x7E, 0x0B, 0xF0, 0x04, 0xF0, 0x67, 0x02, 0xFF, 0x00, 0x4F,
  0x06, 0x71, 0x0C, 0xFE, 0x00, 0x4F, 0x06, 0x71, 0x07, 0xFE, 0x00, 0x4F, 0x06, 0x71, 0x02, 0xFE,
  0x00, 0x4F, 0x06, 0x72, 0x0C, 0xFD, 0x00, 0x4F, 0x06, 0x72, 0x07, 0xFD, 0x00, 0x4F, 0x06, 0x72,
  0x02, 0xFD, 0x00, 0x4F, 0x06, 0x73, 0x0C, 0xFC, 0x04,
  // "ń" (U+0144)
  0x77, 0x20, 0x68, 0x04, 0x70, 0x67, 0x75, 0x04, 0xFA, 0x05, 0x77, 0x50, 0xDF, 0x90, 0x67, 0x75,
  0x08, 0xF9, 0x06, 0x77, 0x50, 0x3F, 0x90, 0x57, 0x76, 0x0D, 0xF0, 0x47, 0x76, 0x09, 0xE0, 0xE0,
  0x47, 0x76, 0x05, 0xE0, 0xE0, 0x37, 0x76, 0x02, 0x0E, 0xD0, 0xC0, 0x17, 0x77, 0x09, 0xD0, 0xA8,
  0x09, 0xE2, 0x08, 0x53, 0x56, 0x76, 0x53, 0x71, 0x0A, 0xE0, 0x14, 0x81, 0x39, 0xEF, 0x90, 0xB0,
  0x45, 0x0A, 0xE0, 0x63, 0x09, 0xFE, 0x0B, 0x01, 0x30, 0xAE, 0x82, 0xC0, 0x1C, 0xFF, 0x90, 0xD0,
  0x22, 0x0A, 0xF0, 0x20, 0xBF, 0xFB, 0x0C, 0x20, 0xAF, 0x0E, 0xFF, 0xD8, 0x17, 0x0A, 0xFF, 0xFE,
  0x81, 0xE0, 0xAF, 0xD8, 0x3D, 0x97, 0x8A, 0xFC, 0x05, 0x0A, 0xFB, 0x0E, 0x04, 0x50, 0x10, 0xBF,
  0xA0, 0x90, 0xAF, 0xB0, 0x37, 0x10, 0xDF, 0x90, 0xC0, 0xAF, 0xA0, 0x77, 0x20, 0x5F, 0x90, 0xD0,
  0xAF, 0x90, 0xE0, 0x17, 0x3F, 0x90, 0xE0, 0xAF, 0x90, 0xA7, 0x40, 0xCF, 0x90, 0xAF, 0x90, 0x67,
  0x40, 0xBF, 0x90, 0xAF, 0x90, 0x47, 0x40, 0xAF, 0x90, 0xAF, 0x90, 0x17, 0x40, 0xAF, 0x90, 0xAF,
  0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97,
  0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50,
  0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF,
  0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90,
  0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF,
  0x97, 0x50, 0xAF, 0x90,
  // "Ņ" (U+0145)
  0x04, 0xFC, 0x0A, 0x73, 0x06, 0xF0, 0x04, 0xFD, 0x73, 0x06, 0xF0, 0x04, 0xFD, 0x05, 0x72, 0x06,
  0xF0, 0x04, 0xFD, 0x0A, 0x72, 0x06, 0xF0, 0x04, 0xFE, 0x72, 0x06, 0xF0, 0x04, 0xFE, 0x05, 0x71,
  0x06, 0xF0, 0x04, 0xFE, 0x0A, 0x71, 0x06, 0xF0, 0x04, 0xFF, 0x71, 0x06, 0xF0, 0x04, 0xE0, 0xD0,
  0xCE, 0x05, 0x70, 0x6F, 0x00, 0x4E, 0x0E, 0x07, 0xE0, 0xA7, 0x06, 0xF0, 0x04, 0xF0, 0x2E, 0x0E,
  0x70, 0x6F, 0x00, 0x4F, 0x10, 0xCE, 0x05, 0x60, 0x6F, 0x00, 0x4F, 0x01, 0x07, 0xE0, 0xA6, 0x06,
  0xF0, 0x04, 0xF0, 0x20, 0x1E, 0x0E, 0x60, 0x6F, 0x00, 0x4F, 0x81, 0x30, 0xCE, 0x05, 0x50, 0x6F,
  0x00, 0x4F, 0x81, 0x40, 0x7E, 0x0A, 0x50, 0x6F, 0x00, 0x4F, 0x81, 0x40, 0x1E, 0x0E, 0x50, 0x6F,
  0x00, 0x4F, 0x05, 0x20, 0xCE, 0x05, 0x40, 0x6F, 0x00, 0x4F, 0x05, 0x20, 0x7E, 0x0A, 0x40, 0x6F,
  0x00, 0x4F, 0x06, 0x20, 0x2E, 0x0E, 0x40, 0x6F, 0x00, 0x4F, 0x06, 0x30, 0xCE, 0x05, 0x30, 0x6F,
  0x00, 0x4F, 0x06, 0x30, 0x7E, 0x0A, 0x30, 0x6F, 0x00, 0x4F, 0x06, 0x30, 0x2E, 0x0E, 0x30, 0x6F,
  0x00, 0x4F, 0x06, 0x40, 0xCE, 0x05, 0x20, 0x6F, 0x00, 0x4F, 0x06, 0x40, 0x7E, 0x0A, 0x20, 0x6F,
  0x00, 0x4F, 0x06, 0x40, 0x2E, 0x0E, 0x20, 0x5F, 0x00, 0x4F, 0x06, 0x50, 0xCE, 0x81, 0x50, 0x5F,
  0x00, 0x4F, 0x06, 0x50, 0x7E, 0x81, 0xA0, 0x4F, 0x00, 0x4F, 0x06, 0x50, 0x2E, 0x81, 0xE0, 0x4F,
  0x00, 0x4F, 0x06, 0x60, 0xCE, 0x05, 0x03, 0xF0, 0x04, 0xF0, 0x66, 0x07, 0xE0, 0xA0, 0x3F, 0x00,
  0x4F, 0x06, 0x60, 0x2E, 0x0E, 0x02, 0xF0, 0x04, 0xF0, 0x67, 0x0C, 0xE0, 0x6F, 0x00, 0x4F, 0x06,
  0x70, 0x7E, 0x0B, 0xF0, 0x04, 0xF0, 0x67, 0x02, 0xFF, 0x00, 0x4F, 0x06, 0x71, 0x0C, 0xFE, 0x00,
  0x4F, 0x06, 0x71, 0x07, 0xFE, 0x00, 0x4F, 0x06, 0x71, 0x02, 0xFE, 0x00, 0x4F, 0x06, 0x72, 0x0C,
  0xFD, 0x00, 0x4F, 0x06, 0x72, 0x07, 0xFD, 0x00, 0x4F, 0x06, 0x72, 0x02, 0xFD, 0x00, 0x4F, 0x06,
  0x73, 0x0C, 0xFC, 0x04, 0x80, 0x9C, 0x70, 0x02, 0xF0, 0xD7, 0x77, 0x20, 0x4F, 0x08, 0x77, 0x72,
  0x07, 0xF0, 0x17, 0x77, 0x20, 0xAE, 0x09, 0x77, 0x73, 0x0D, 0xE0, 0x27, 0x77, 0x20, 0x1E, 0x09,
  0x77, 0x73, 0x04, 0xE0, 0x17, 0x77, 0x30, 0x7D, 0x08, 0x77, 0x74, 0x0B, 0xC0, 0xD7, 0x77, 0x50,
  0xEC, 0x05, 0x77, 0x20,
  // "ņ" (U+0146)
  0x77, 0x18, 0x53, 0x56, 0x76, 0x53, 0x71, 0x0A, 0xE0, 0x14, 0x81, 0x39, 0xEF, 0x90, 0xB0, 0x45,
  0x0A, 0xE0, 0x63, 0x09, 0xFE, 0x0B, 0x01, 0x30, 0xAE, 0x82, 0xC0, 0x1C, 0xFF, 0x90, 0xD0, 0x22,
  0x0A, 0xF0, 0x20, 0xBF, 0xFB, 0x0C, 0x20, 0xAF, 0x0E, 0xFF, 0xD8, 0x17, 0x0A, 0xFF, 0xFE, 0x81,
  0xE0, 0xAF, 0xD8, 0x3D, 0x97, 0x8A, 0xFC, 0x05, 0x0A, 0xFB, 0x0E, 0x04, 0x50, 0x10, 0xBF, 0xA0,
  0x90, 0xAF, 0xB0, 0x37, 0x10, 0xDF, 0x90, 0xC0, 0xAF, 0xA0, 0x77, 0x20, 0x5F, 0x90, 0xD0, 0xAF,
  0x90, 0xE0, 0x17, 0x3F, 0x90, 0xE0, 0xAF, 0x90, 0xA7, 0x40, 0xCF, 0x90, 0xAF, 0x90, 0x67, 0x40,
  0xBF, 0x90, 0xAF, 0x90, 0x47, 0x40, 0xAF, 0x90, 0xAF, 0x90, 0x17, 0x40, 0xAF, 0x90, 0xAF, 0x97,
  0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50,
  0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF,
  0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90,
  0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF,
  0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97,
  0x50, 0xAF, 0x98, 0x09, 0xC0, 0x00, 0x2F, 0x0D, 0x77, 0x70, 0x4F, 0x08, 0x77, 0x70, 0x7F, 0x01,
  0x77, 0x70, 0xAE, 0x09, 0x77, 0x71, 0x0D, 0xE0, 0x27, 0x77, 0x01, 0xE0, 0x97, 0x77, 0x10, 0x4E,
  0x01, 0x77, 0x71, 0x07, 0xD0, 0x87, 0x77, 0x20, 0xBC, 0x0D, 0x77, 0x73, 0x0E, 0xC0, 0x57, 0x71,
  // "Ň" (U+0147)
  0x58, 0x01, 0x70, 0x57, 0x30, 0x58, 0x01, 0x77, 0x30, 0xBD, 0x09, 0x71, 0x09, 0xD0, 0xB7, 0x40,
  0xCD, 0x0C, 0x01, 0x40, 0x20, 0xCD, 0x0D, 0x01, 0x74, 0x01, 0x0E, 0xD0, 0xD0, 0x22, 0x03, 0x0E,
  0xD0, 0xE0, 0x27, 0x60, 0x4E, 0x82, 0xE2, 0x3E, 0xE0, 0x47, 0x71, 0x07, 0xE0, 0xD0, 0xEE, 0x08,
  0x77, 0x30, 0xBF, 0xD0, 0xB7, 0x74, 0x01, 0x0E, 0xFB, 0x0E, 0x01, 0x77, 0x50, 0x5F, 0xB0, 0x57,
  0x77, 0x0A, 0xF9, 0x0A, 0x80, 0xA8, 0x70, 0x04, 0xFC, 0x0A, 0x73, 0x06, 0xF0, 0x04, 0xFD, 0x73,
  0x06, 0xF0, 0x04, 0xFD, 0x05, 0x72, 0x06, 0xF0, 0x04, 0xFD, 0x0A, 0x72, 0x06, 0xF0, 0x04, 0xFE,
  0x72, 0x06, 0xF0, 0x04, 0xFE, 0x05, 0x71, 0x06, 0xF0, 0x04, 0xFE, 0x0A, 0x71, 0x06, 0xF0, 0x04,
  0xFF, 0x71, 0x06, 0xF0, 0x04, 0xE0, 0xD0, 0xCE, 0x05, 0x70, 0x6F, 0x00, 0x4E, 0x0E, 0x07, 0xE0,
  0xA7, 0x06, 0xF0, 0x04, 0xF0, 0x2E, 0x0E, 0x70, 0x6F, 0x00, 0x4F, 0x10, 0xCE, 0x05, 0x60, 0x6F,
  0x00, 0x4F, 0x01, 0x07, 0xE0, 0xA6, 0x06, 0xF0, 0x04, 0xF0, 0x20, 0x1E, 0x0E, 0x60, 0x6F, 0x00,
  0x4F, 0x81, 0x30, 0xCE, 0x05, 0x50, 0x6F, 0x00, 0x4F, 0x81, 0x40, 0x7E, 0x0A, 0x50, 0x6F, 0x00,
  0x4F, 0x81, 0x40, 0x1E, 0x0E, 0x50, 0x6F, 0x00, 0x4F, 0x05, 0x20, 0xCE, 0x05, 0x40, 0x6F, 0x00,
  0x4F, 0x05, 0x20, 0x7E, 0x0A, 0x40, 0x6F, 0x00, 0x4F, 0x06, 0x20, 0x2E, 0x0E, 0x40, 0x6F, 0x00,
  0x4F, 0x06, 0x30, 0xCE, 0x05, 0x30, 0x6F, 0x00, 0x4F, 0x06, 0x30, 0x7E, 0x0A, 0x30, 0x6F, 0x00,
  0x4F, 0x06, 0x30, 0x2E, 0x0E, 0x30, 0x6F, 0x00, 0x4F, 0x06, 0x40, 0xCE, 0x05, 0x20, 0x6F, 0x00,
  0x4F, 0x06, 0x40, 0x7E, 0x0A, 0x20, 0x6F, 0x00, 0x4F, 0x06, 0x40, 0x2E, 0x0E, 0x20, 0x5F, 0x00,
  0x4F, 0x06, 0x50, 0xCE, 0x81, 0x50, 0x5F, 0x00, 0x4F, 0x06, 0x50, 0x7E, 0x81, 0xA0, 0x4F, 0x00,
  0x4F, 0x06, 0x50, 0x2E, 0x81, 0xE0, 0x4F, 0x00, 0x4F, 0x06, 0x60, 0xCE, 0x05, 0x03, 0xF0, 0x04,
  0xF0, 0x66, 0x07, 0xE0, 0xA0, 0x3F, 0x00, 0x4F, 0x06, 0x60, 0x2E, 0x0E, 0x02, 0xF0, 0x04, 0xF0,
  0x67, 0x0C, 0xE0, 0x6F, 0x00, 0x4F, 0x06, 0x70, 0x7E, 0x0B, 0xF0, 0x04, 0xF0, 0x67, 0x02, 0xFF,
  0x00, 0x4F, 0x06, 0x71, 0x0C, 0xFE, 0x00, 0x4F, 0x06, 0x71, 0x07, 0xFE, 0x00, 0x4F, 0x06, 0x71,
  0x02, 0xFE, 0x00, 0x4F, 0x06, 0x72, 0x0C, 0xFD, 0x00, 0x4F, 0x06, 0x72, 0x07, 0xFD, 0x00, 0x4F,
  0x06, 0x72, 0x02, 0xFD, 0x00, 0x4F, 0x06, 0x73, 0x0C, 0xFC, 0x04,
  // "ň" (U+0148)
  0x48, 0x01, 0x70, 0x57, 0x30, 0x58, 0x01, 0x77, 0x10, 0xBD, 0x09, 0x71, 0x09, 0xD0, 0xB7, 0x20,
  0xCD, 0x0C, 0x01, 0x40, 0x20, 0xCD, 0x0D, 0x01, 0x72, 0x01, 0x0E, 0xD0, 0xD0, 0x22, 0x03, 0x0E,
  0xD0, 0xE0, 0x27, 0x40, 0x4E, 0x82, 0xE2, 0x3E, 0xE0, 0x47, 0x60, 0x7E, 0x0D, 0x0E, 0xE0, 0x87,
  0x71, 0x0B, 0xFD, 0x0B, 0x77, 0x20, 0x10, 0xEF, 0xB0, 0xE0, 0x17, 0x73, 0x05, 0xFB, 0x05, 0x77,
  0x50, 0xAF, 0x90, 0xA8, 0x09, 0xD7, 0x08, 0x53, 0x56, 0x76, 0x53, 0x71, 0x0A, 0xE0, 0x14, 0x81,
  0x39, 0xEF, 0x90, 0xB0, 0x45, 0x0A, 0xE0, 0x63, 0x09, 0xFE, 0x0B, 0x01, 0x30, 0xAE, 0x82, 0xC0,
  0x1C, 0xFF, 0x90, 0xD0, 0x22, 0x0A, 0xF0, 0x20, 0xBF, 0xFB, 0x0C, 0x20, 0xAF, 0x0E, 0xFF, 0xD8,
  0x17, 0x0A, 0xFF, 0xFE, 0x81, 0xE0, 0xAF, 0xD8, 0x3D, 0x97, 0x8A, 0xFC, 0x05, 0x0A, 0xFB, 0x0E,
  0x04, 0x50, 0x10, 0xBF, 0xA0, 0x90, 0xAF, 0xB0, 0x37, 0x10, 0xDF, 0x90, 0xC0, 0xAF, 0xA0, 0x77,
  0x20, 0x5F, 0x90, 0xD0, 0xAF, 0x90, 0xE0, 0x17, 0x3F, 0x90, 0xE0, 0xAF, 0x90, 0xA7, 0x40, 0xCF,
  0x90, 0xAF, 0x90, 0x67, 0x40, 0xBF, 0x90, 0xAF, 0x90, 0x47, 0x40, 0xAF, 0x90, 0xAF, 0x90, 0x17,
  0x40, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50,
  0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF,
  0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90,
  0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF,
  0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97,
  0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90,
  // "ŉ" (U+0149)
  0x3F, 0x90, 0x87, 0x77, 0x72, 0x02, 0xF9, 0x07, 0x77, 0x77, 0x20, 0x4F, 0x90, 0x37, 0x77, 0x72,
  0x07, 0xF0, 0xE7, 0x77, 0x73, 0x09, 0xF0, 0x97, 0x77, 0x73, 0x0C, 0xF0, 0x47, 0x77, 0x73, 0xF0,
  0xE7, 0x77, 0x73, 0x03, 0xF0, 0x97, 0x77, 0x73, 0x06, 0xF0, 0x37, 0x77, 0x73, 0x09, 0xE0, 0xD7,
  0x72, 0x86, 0x14, 0x67, 0x75, 0x41, 0x71, 0x0C, 0xE8, 0x17, 0x01, 0xE0, 0xA5, 0x05, 0x0B, 0xF9,
  0x0C, 0x05, 0x6F, 0x81, 0x10, 0x1E, 0x0E, 0x30, 0x10, 0xBF, 0xD0, 0xC0, 0x23, 0x04, 0xE0, 0x92,
  0x01, 0xF8, 0x24, 0x02, 0xDF, 0xF0, 0xE0, 0x22, 0x07, 0xE0, 0x32, 0x01, 0xF8, 0x19, 0x0D, 0xFF,
  0xA0, 0xD2, 0x0B, 0xD0, 0xC3, 0x01, 0xF0, 0xE0, 0xAF, 0xFC, 0x08, 0x74, 0x01, 0xFF, 0xFE, 0x0E,
  0x74, 0x01, 0xFD, 0x84, 0xEA, 0x87, 0x9E, 0xFB, 0x05, 0x73, 0x01, 0xFC, 0x0A, 0x60, 0xAF, 0xA0,
  0x97, 0x30, 0x1F, 0xB0, 0xA7, 0x10, 0xCF, 0x90, 0xC7, 0x30, 0x1F, 0xA0, 0xE0, 0x17, 0x10, 0x4F,
  0x90, 0xD7, 0x30, 0x1F, 0xA0, 0x97, 0x3F, 0x90, 0xE7, 0x30, 0x1F, 0xA0, 0x47, 0x30, 0xCF, 0x97,
  0x30, 0x1F, 0xA7, 0x40, 0xBF, 0x97, 0x30, 0x1F, 0x90, 0xD7, 0x40, 0xAF, 0x97, 0x30, 0x1F, 0x90,
  0xB7, 0x40, 0xAF, 0x97, 0x30, 0x1F, 0x90, 0xA7, 0x40, 0xAF, 0x97, 0x30, 0x1F, 0x90, 0x97, 0x40,
  0xAF, 0x97, 0x30, 0x1F, 0x90, 0x97, 0x40, 0xAF, 0x97, 0x30, 0x1F, 0x90, 0x97, 0x40, 0xAF, 0x97,
  0x30, 0x1F, 0x90, 0x97, 0x40, 0xAF, 0x97, 0x30, 0x1F, 0x90, 0x97, 0x40, 0xAF, 0x97, 0x30, 0x1F,
  0x90, 0x97, 0x40, 0xAF, 0x97, 0x30, 0x1F, 0x90, 0x97, 0x40, 0xAF, 0x97, 0x30, 0x1F, 0x90, 0x97,
  0x40, 0xAF, 0x97, 0x30, 0x1F, 0x90, 0x97, 0x40, 0xAF, 0x97, 0x30, 0x1F, 0x90, 0x97, 0x40, 0xAF,
  0x97, 0x30, 0x1F, 0x90, 0x97, 0x40, 0xAF, 0x97, 0x30, 0x1F, 0x90, 0x97, 0x40, 0xAF, 0x97, 0x30,
  0x1F, 0x90, 0x97, 0x40, 0xAF, 0x97, 0x30, 0x1F, 0x90, 0x97, 0x40, 0xAF, 0x97, 0x30, 0x1F, 0x90,
  0x97, 0x40, 0xAF, 0x97, 0x30, 0x1F, 0x90, 0x97, 0x40, 0xAF, 0x90,
  // "Ŋ" (U+014A)
  0x04, 0xFC, 0x0A, 0x73, 0x06, 0xF0, 0x04, 0xFD, 0x73, 0x06, 0xF0, 0x04, 0xFD, 0x05, 0x72, 0x06,
  0xF0, 0x04, 0xFD, 0x0A, 0x72, 0x06, 0xF0, 0x04, 0xFE, 0x72, 0x06, 0xF0, 0x04, 0xFE, 0x05, 0x71,
  0x06, 0xF0, 0x04, 0xFE, 0x0A, 0x71, 0x06, 0xF0, 0x04, 0xFF, 0x71, 0x06, 0xF0, 0x04, 0xE0, 0xD0,
  0xCE, 0x05, 0x70, 0x6F, 0x00, 0x4E, 0x0E, 0x07, 0xE0, 0xA7, 0x06, 0xF0, 0x04, 0xF0, 0x2E, 0x0E,
  0x70, 0x6F, 0x00, 0x4F, 0x10, 0xCE, 0x05, 0x60, 0x6F, 0x00, 0x4F, 0x01, 0x07, 0xE0, 0xA6, 0x06,
  0xF0, 0x04, 0xF0, 0x20, 0x1E, 0x0E, 0x60, 0x6F, 0x00, 0x4F, 0x81, 0x30, 0xCE, 0x05, 0x50, 0x6F,
  0x00, 0x4F, 0x81, 0x40, 0x7E, 0x0A, 0x50, 0x6F, 0x00, 0x4F, 0x81, 0x40, 0x1E, 0x0E, 0x50, 0x6F,
  0x00, 0x4F, 0x05, 0x20, 0xCE, 0x05, 0x40, 0x6F, 0x00, 0x4F, 0x05, 0x20, 0x7E, 0x0A, 0x40, 0x6F,
  0x00, 0x4F, 0x06, 0x20, 0x2E, 0x0E, 0x40, 0x6F, 0x00, 0x4F, 0x06, 0x30, 0xCE, 0x05, 0x30, 0x6F,
  0x00, 0x4F, 0x06, 0x30, 0x7E, 0x0A, 0x30, 0x6F, 0x00, 0x4F, 0x06, 0x30, 0x2E, 0x0E, 0x30, 0x6F,
  0x00, 0x4F, 0x06, 0x40, 0xCE, 0x05, 0x20, 0x6F, 0x00, 0x4F, 0x06, 0x40, 0x7E, 0x0A, 0x20, 0x6F,
  0x00, 0x4F, 0x06, 0x40, 0x2E, 0x0E, 0x20, 0x5F, 0x00, 0x4F, 0x06, 0x50, 0xCE, 0x81, 0x50, 0x5F,
  0x00, 0x4F, 0x06, 0x50, 0x7E, 0x81, 0xA0, 0x4F, 0x00, 0x4F, 0x06, 0x50, 0x2E, 0x81, 0xE0, 0x4F,
  0x00, 0x4F, 0x06, 0x60, 0xCE, 0x05, 0x03, 0xF0, 0x04, 0xF0, 0x66, 0x07, 0xE0, 0xA0, 0x3F, 0x00,
  0x4F, 0x06, 0x60, 0x2E, 0x0E, 0x02, 0xF0, 0x04, 0xF0, 0x67, 0x0C, 0xE0, 0x6F, 0x00, 0x4F, 0x06,
  0x70, 0x7E, 0x0B, 0xF0, 0x04, 0xF0, 0x67, 0x02, 0xFF, 0x00, 0x4F, 0x06, 0x71, 0x0C, 0xFE, 0x00,
  0x4F, 0x06, 0x71, 0x07, 0xFE, 0x00, 0x4F, 0x06, 0x71, 0x02, 0xFE, 0x00, 0x4F, 0x06, 0x72, 0x0C,
  0xFD, 0x00, 0x4F, 0x06, 0x72, 0x07, 0xFD, 0x00, 0x4F, 0x06, 0x72, 0x02, 0xFD, 0x00, 0x4F, 0x06,
  0x73, 0x0C, 0xFC, 0x04, 0x77, 0x73, 0x0D, 0xE0, 0x37, 0x77, 0x3F, 0x02, 0x77, 0x72, 0x03, 0xF7,
  0x77, 0x30, 0xAE, 0x0C, 0x77, 0x72, 0x08, 0xF0, 0x87, 0x68, 0x25, 0x53, 0x12, 0x82, 0x13, 0x7D,
  0xF9, 0x03, 0x76, 0x0B, 0xFF, 0xA0, 0xA7, 0x70, 0xBF, 0xF9, 0x0E, 0x01, 0x77, 0x0B, 0xFF, 0x0E,
  0x02, 0x77, 0x10, 0xBF, 0xE0, 0xB0, 0x27, 0x72, 0x0B, 0xFC, 0x0C, 0x05, 0x77, 0x48, 0x92, 0x59,
  0xCD, 0xEF, 0xED, 0xCA, 0x62, 0x71,
  // "ŋ" (U+014B)
  0x77, 0x18, 0x53, 0x56, 0x76, 0x53, 0x71, 0x0A, 0xE0, 0x14, 0x81, 0x39, 0xEF, 0x90, 0xB0, 0x45,
  0x0A, 0xE0, 0x63, 0x09, 0xFE, 0x0B, 0x01, 0x30, 0xAE, 0x82, 0xC0, 0x1C, 0xFF, 0x90, 0xD0, 0x22,
  0x0A, 0xF0, 0x20, 0xBF, 0xFB, 0x0C, 0x20, 0xAF, 0x0E, 0xFF, 0xD8, 0x17, 0x0A, 0xFF, 0xFE, 0x81,
  0xE0, 0xAF, 0xD8, 0x3D, 0x97, 0x8A, 0xFC, 0x05, 0x0A, 0xFB, 0x0E, 0x04, 0x50, 0x10, 0xBF, 0xA0,
  0x90, 0xAF, 0xB0, 0x37, 0x10, 0xDF, 0x90, 0xC0, 0xAF, 0xA0, 0x77, 0x20, 0x5F, 0x90, 0xD0, 0xAF,
  0x90, 0xE0, 0x17, 0x3F, 0x90, 0xE0, 0xAF, 0x90, 0xA7, 0x40, 0xCF, 0x90, 0xAF, 0x90, 0x67, 0x40,
  0xBF, 0x90, 0xAF, 0x90, 0x47, 0x40, 0xAF, 0x90, 0xAF, 0x90, 0x17, 0x40, 0xAF, 0x90, 0xAF, 0x97,
  0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50,
  0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF,
  0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90,
  0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF,
  0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97, 0x50, 0xAF, 0x90, 0xAF, 0x97,
  0x50, 0xAF, 0x97, 0x77, 0x0A, 0xF9, 0x77, 0x70, 0xAF, 0x97, 0x77, 0x0B, 0xF9, 0x77, 0x70, 0xCF,
  0x97, 0x77, 0x0E, 0xF0, 0xE7, 0x76, 0x05, 0xF9, 0x0D, 0x77, 0x04, 0x02, 0x20, 0x10, 0x7F, 0xA0,
  0xA7, 0x70, 0xDF, 0xF0, 0x67, 0x70, 0xDF, 0xF0, 0x17, 0x70, 0xDF, 0xE0, 0x87, 0x71, 0x0D, 0xFD,
  0x0D, 0x77, 0x20, 0xDF, 0xC0, 0xD0, 0x17, 0x72, 0x0D, 0xFB, 0x09, 0x77, 0x48, 0x91, 0x59, 0xBD,
  0xEF, 0xED, 0xB7, 0x15,
  // "Ō" (U+014C)
  0x70, 0x1F, 0xFC, 0x01, 0x77, 0x01, 0xFF, 0xC0, 0x17, 0x70, 0x1F, 0xFC, 0x01, 0x77, 0x01, 0xFF,
  0xC0, 0x17, 0x70, 0x1F, 0xFC, 0x01, 0x77, 0x01, 0xFF, 0xC0, 0x18, 0x0A, 0xB0, 0x08, 0x63, 0x56,
  0x77, 0x65, 0x37, 0x77, 0x28, 0x15, 0xBE, 0xF9, 0x81, 0xEB, 0x57, 0x74, 0x06, 0x0D, 0xFF, 0x0E,
  0x06, 0x77, 0x10, 0xAF, 0xFC, 0x0A, 0x01, 0x74, 0x01, 0x0C, 0xFF, 0xE0, 0xC0, 0x17, 0x30, 0xBF,
  0xFF, 0x90, 0xB7, 0x20, 0x7F, 0xFF, 0xB0, 0x77, 0x02, 0xFB, 0x84, 0xEA, 0x88, 0xAE, 0xFA, 0x0E,
  0x01, 0x60, 0x9F, 0xA0, 0x86, 0x08, 0xFA, 0x09, 0x50, 0x1F, 0xA0, 0x77, 0x10, 0x6F, 0xA0, 0x14,
  0x07, 0xF9, 0x0B, 0x73, 0x0B, 0xF9, 0x06, 0x40, 0xCF, 0x90, 0x37, 0x30, 0x3F, 0x90, 0xC3, 0x01,
  0xF9, 0x0D, 0x75, 0x0D, 0xF9, 0x01, 0x20, 0x5F, 0x90, 0x87, 0x50, 0x8F, 0x90, 0x52, 0x08, 0xF9,
  0x05, 0x75, 0x04, 0xF9, 0x08, 0x20, 0xBF, 0x90, 0x17, 0x50, 0x1F, 0x90, 0xB2, 0x0D, 0xF9, 0x77,
  0xF9, 0x0D, 0x2F, 0x90, 0xD7, 0x70, 0xDF, 0x91, 0x01, 0xF9, 0x0B, 0x77, 0x0B, 0xF9, 0x10, 0x2F,
  0x90, 0xA7, 0x70, 0xBF, 0x90, 0x02, 0xF9, 0x0A, 0x77, 0x0A, 0xF9, 0x02, 0x03, 0xF9, 0x09, 0x77,
  0x09, 0xF9, 0x02, 0x03, 0xF9, 0x09, 0x77, 0x0A, 0xF9, 0x00, 0x2F, 0x90, 0xA7, 0x70, 0xAF, 0x90,
  0x02, 0xF9, 0x0A, 0x77, 0x0B, 0xF9, 0x02, 0x01, 0xF9, 0x0B, 0x77, 0x0B, 0xF9, 0x2F, 0x90, 0xD7,
  0x70, 0xDF, 0x92, 0x0D, 0xF0, 0xE7, 0x7F, 0x90, 0xD2, 0x0B, 0xF9, 0x01, 0x75, 0x01, 0xF9, 0x0B,
  0x20, 0x8F, 0x90, 0x47, 0x50, 0x5F, 0x90, 0x82, 0x05, 0xF9, 0x08, 0x75, 0x08, 0xF9, 0x05, 0x20,
  0x1F, 0x90, 0xD7, 0x50, 0xDF, 0x90, 0x13, 0x0C, 0xF9, 0x03, 0x73, 0x03, 0xF9, 0x0C, 0x40, 0x7F,
  0x90, 0xB7, 0x30, 0xBF, 0x90, 0x74, 0x01, 0xFA, 0x06, 0x71, 0x06, 0xFA, 0x01, 0x50, 0x9F, 0xA0,
  0x86, 0x08, 0xFA, 0x09, 0x60, 0x2F, 0xB8, 0x4E, 0x97, 0x79, 0xEF, 0xB0, 0x17, 0x07, 0xFF, 0xFB,
  0x07, 0x72, 0x0B, 0xFF, 0xF9, 0x0B, 0x73, 0x01, 0x0C, 0xFF, 0xE0, 0xC0, 0x17, 0x40, 0x10, 0xBF,
  0xFC, 0x0B, 0x01, 0x77, 0x06, 0x0E, 0xFF, 0x0E, 0x06, 0x77, 0x40, 0x50, 0xBF, 0xB0, 0xB0, 0x57,
  0x77, 0x28, 0x63, 0x56, 0x77, 0x65, 0x37, 0x60,
  // "ō" (U+014D)
  0x60, 0x1F, 0xFC, 0x01, 0x75, 0x01, 0xFF, 0xC0, 0x17, 0x50, 0x1F, 0xFC, 0x01, 0x75, 0x01, 0xFF,
  0xC0, 0x17, 0x50, 0x1F, 0xFC, 0x01, 0x75, 0x01, 0xFF, 0xC0, 0x18, 0x0A, 0x96, 0x08, 0x62, 0x46,
  0x77, 0x65, 0x37, 0x77, 0x81, 0x49, 0xEF, 0xA0, 0xB0, 0x67, 0x72, 0x04, 0x0C, 0xFF, 0x0E, 0x06,
  0x76, 0x09, 0xFF, 0xC0, 0xC0, 0x17, 0x20, 0x10, 0xCF, 0xFE, 0x0D, 0x02, 0x71, 0x0C, 0xFF, 0xF9,
  0x0D, 0x01, 0x60, 0x9F, 0xFF, 0xB0, 0xB5, 0x03, 0xFB, 0x84, 0xE9, 0x87, 0x9D, 0xFB, 0x05, 0x40,
  0xCF, 0xA0, 0x76, 0x05, 0x0E, 0xF9, 0x0D, 0x30, 0x3F, 0xA0, 0x57, 0x10, 0x3F, 0xA0, 0x52, 0x09,
  0xF9, 0x0A, 0x73, 0x09, 0xF9, 0x0A, 0x20, 0xDF, 0x90, 0x27, 0x30, 0x1F, 0x98, 0x1E, 0x02, 0xF9,
  0x0C, 0x75, 0x0C, 0xF9, 0x02, 0x04, 0xF9, 0x08, 0x75, 0x08, 0xF9, 0x05, 0x06, 0xF9, 0x06, 0x75,
  0x06, 0xF9, 0x07, 0x08, 0xF9, 0x04, 0x75, 0x04, 0xF9, 0x00, 0x8F, 0x90, 0x37, 0x50, 0x3F, 0x90,
  0x08, 0xF9, 0x03, 0x75, 0x03, 0xF9, 0x00, 0x8F, 0x90, 0x47, 0x50, 0x4F, 0x90, 0x80, 0x7F, 0x90,
  0x67, 0x50, 0x6F, 0x90, 0x70, 0x5F, 0x90, 0x87, 0x50, 0x8F, 0x90, 0x40, 0x2F, 0x90, 0xC7, 0x50,
  0xCF, 0x98, 0x12, 0x0E, 0xF9, 0x02, 0x73, 0x01, 0xF9, 0x0D, 0x20, 0x9F, 0x90, 0xA7, 0x30, 0x9F,
  0x90, 0x92, 0x04, 0xFA, 0x05, 0x71, 0x04, 0xFA, 0x03, 0x30, 0xCF, 0xA0, 0x76, 0x05, 0x0E, 0xF9,
  0x0C, 0x40, 0x4F, 0xB8, 0x4E, 0x97, 0x79, 0xDF, 0xB0, 0x45, 0x0A, 0xFF, 0xFB, 0x0A, 0x70, 0xDF,
  0xFF, 0x90, 0xD0, 0x17, 0x01, 0x0D, 0xFF, 0xE0, 0xD0, 0x27, 0x20, 0x10, 0xBF, 0xFC, 0x0B, 0x01,
  0x75, 0x06, 0x0D, 0xFF, 0x0E, 0x06, 0x77, 0x20, 0x50, 0xAF, 0xB0, 0xB0, 0x67, 0x77, 0x86, 0x25,
  0x67, 0x76, 0x53, 0x75,
  // "Ŏ" (U+014E)
  0x78, 0x46, 0x77, 0x77, 0x17, 0x28, 0x45, 0x77, 0x77, 0x17, 0x60, 0xCC, 0x04, 0x72, 0x0E, 0xC0,
  0x27, 0x60, 0xAC, 0x0C, 0x71, 0x07, 0xD7, 0x70, 0x6D, 0x86, 0xD7, 0x21, 0x02, 0x5B, 0xD0, 0xB7,
  0x70, 0x1F, 0xFC, 0x05, 0x77, 0x10, 0x9F, 0xFA, 0x0C, 0x77, 0x20, 0x10, 0xDF, 0xF0, 0xE0, 0x27,
  0x73, 0x02, 0x0D, 0xFD, 0x0E, 0x03, 0x77, 0x60, 0x9F, 0xB0, 0xA0, 0x17, 0x77, 0x18, 0x90, 0x17,
  0xBD, 0xEF, 0xDB, 0x72, 0x80, 0x9F, 0x30, 0x86, 0x35, 0x67, 0x76, 0x53, 0x77, 0x72, 0x81, 0x5B,
  0xEF, 0x98, 0x1E, 0xB5, 0x77, 0x40, 0x60, 0xDF, 0xF0, 0xE0, 0x67, 0x71, 0x0A, 0xFF, 0xC0, 0xA0,
  0x17, 0x40, 0x10, 0xCF, 0xFE, 0x0C, 0x01, 0x73, 0x0B, 0xFF, 0xF9, 0x0B, 0x72, 0x07, 0xFF, 0xFB,
  0x07, 0x70, 0x2F, 0xB8, 0x4E, 0xA8, 0x8A, 0xEF, 0xA0, 0xE0, 0x16, 0x09, 0xFA, 0x08, 0x60, 0x8F,
  0xA0, 0x95, 0x01, 0xFA, 0x07, 0x71, 0x06, 0xFA, 0x01, 0x40, 0x7F, 0x90, 0xB7, 0x30, 0xBF, 0x90,
  0x64, 0x0C, 0xF9, 0x03, 0x73, 0x03, 0xF9, 0x0C, 0x30, 0x1F, 0x90, 0xD7, 0x50, 0xDF, 0x90, 0x12,
  0x05, 0xF9, 0x08, 0x75, 0x08, 0xF9, 0x05, 0x20, 0x8F, 0x90, 0x57, 0x50, 0x4F, 0x90, 0x82, 0x0B,
  0xF9, 0x01, 0x75, 0x01, 0xF9, 0x0B, 0x20, 0xDF, 0x97, 0x7F, 0x90, 0xD2, 0xF9, 0x0D, 0x77, 0x0D,
  0xF9, 0x10, 0x1F, 0x90, 0xB7, 0x70, 0xBF, 0x91, 0x02, 0xF9, 0x0A, 0x77, 0x0B, 0xF9, 0x00, 0x2F,
  0x90, 0xA7, 0x70, 0xAF, 0x90, 0x20, 0x3F, 0x90, 0x97, 0x70, 0x9F, 0x90, 0x20, 0x3F, 0x90, 0x97,
  0x70, 0xAF, 0x90, 0x02, 0xF9, 0x0A, 0x77, 0x0A, 0xF9, 0x00, 0x2F, 0x90, 0xA7, 0x70, 0xBF, 0x90,
  0x20, 0x1F, 0x90, 0xB7, 0x70, 0xBF, 0x92, 0xF9, 0x0D, 0x77, 0x0D, 0xF9, 0x20, 0xDF, 0x0E, 0x77,
  0xF9, 0x0D, 0x20, 0xBF, 0x90, 0x17, 0x50, 0x1F, 0x90, 0xB2, 0x08, 0xF9, 0x04, 0x75, 0x05, 0xF9,
  0x08, 0x20, 0x5F, 0x90, 0x87, 0x50, 0x8F, 0x90, 0x52, 0x01, 0xF9, 0x0D, 0x75, 0x0D, 0xF9, 0x01,
  0x30, 0xCF, 0x90, 0x37, 0x30, 0x3F, 0x90, 0xC4, 0x07, 0xF9, 0x0B, 0x73, 0x0B, 0xF9, 0x07, 0x40,
  0x1F, 0xA0, 0x67, 0x10, 0x6F, 0xA0, 0x15, 0x09, 0xFA, 0x08, 0x60, 0x8F, 0xA0, 0x96, 0x02, 0xFB,
  0x84, 0xE9, 0x77, 0x9E, 0xFB, 0x01, 0x70, 0x7F, 0xFF, 0xB0, 0x77, 0x20, 0xBF, 0xFF, 0x90, 0xB7,
  0x30, 0x10, 0xCF, 0xFE, 0x0C, 0x01, 0x74, 0x01, 0x0B, 0xFF, 0xC0, 0xB0, 0x17, 0x70, 0x60, 0xEF,
  0xF0, 0xE0, 0x67, 0x74, 0x05, 0x0B, 0xFB, 0x0B, 0x05, 0x77, 0x72, 0x86, 0x35, 0x67, 0x76, 0x53,
  0x76,
  // "ŏ" (U+014F)
  0x68, 0x46, 0x77, 0x77, 0x17, 0x28, 0x45, 0x77, 0x77, 0x17, 0x40, 0xCC, 0x04, 0x72, 0x0E, 0xC0,
  0x27, 0x40, 0xAC, 0x0C, 0x71, 0x07, 0xD7, 0x50, 0x6D, 0x86, 0xD7, 0x21, 0x02, 0x5B, 0xD0, 0xB7,
  0x50, 0x1F, 0xFC, 0x05, 0x76, 0x09, 0xFF, 0xA0, 0xC7, 0x70, 0x10, 0xDF, 0xF0, 0xE0, 0x27, 0x71,
  0x02, 0x0D, 0xFD, 0x0E, 0x03, 0x77, 0x40, 0x9F, 0xB0, 0xA0, 0x17, 0x76, 0x89, 0x01, 0x7B, 0xDE,
  0xFD, 0xB7, 0x28, 0x09, 0xE3, 0x08, 0x62, 0x46, 0x77, 0x65, 0x37, 0x77, 0x81, 0x49, 0xEF, 0xA0,
  0xB0, 0x67, 0x72, 0x04, 0x0C, 0xFF, 0x0E, 0x06, 0x76, 0x09, 0xFF, 0xC0, 0xC0, 0x17, 0x20, 0x10,
  0xCF, 0xFE, 0x0D, 0x02, 0x71, 0x0C, 0xFF, 0xF9, 0x0D, 0x01, 0x60, 0x9F, 0xFF, 0xB0, 0xB5, 0x03,
  0xFB, 0x84, 0xE9, 0x87, 0x9D, 0xFB, 0x05, 0x40, 0xCF, 0xA0, 0x76, 0x05, 0x0E, 0xF9, 0x0D, 0x30,
  0x3F, 0xA0, 0x57, 0x10, 0x3F, 0xA0, 0x52, 0x09, 0xF9, 0x0A, 0x73, 0x09, 0xF9, 0x0A, 0x20, 0xDF,
  0x90, 0x27, 0x30, 0x1F, 0x98, 0x1E, 0x02, 0xF9, 0x0C, 0x75, 0x0C, 0xF9, 0x02, 0x04, 0xF9, 0x08,
  0x75, 0x08, 0xF9, 0x05, 0x06, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x07, 0x08, 0xF9, 0x04, 0x75, 0x04,
  0xF9, 0x00, 0x8F, 0x90, 0x37, 0x50, 0x3F, 0x90, 0x08, 0xF9, 0x03, 0x75, 0x03, 0xF9, 0x00, 0x8F,
  0x90, 0x47, 0x50, 0x4F, 0x90, 0x80, 0x7F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x70, 0x5F, 0x90, 0x87,
  0x50, 0x8F, 0x90, 0x40, 0x2F, 0x90, 0xC7, 0x50, 0xCF, 0x98, 0x12, 0x0E, 0xF9, 0x02, 0x73, 0x01,
  0xF9, 0x0D, 0x20, 0x9F, 0x90, 0xA7, 0x30, 0x9F, 0x90, 0x92, 0x04, 0xFA, 0x05, 0x71, 0x04, 0xFA,
  0x03, 0x30, 0xCF, 0xA0, 0x76, 0x05, 0x0E, 0xF9, 0x0C, 0x40, 0x4F, 0xB8, 0x4E, 0x97, 0x79, 0xDF,
  0xB0, 0x45, 0x0A, 0xFF, 0xFB, 0x0A, 0x70, 0xDF, 0xFF, 0x90, 0xD0, 0x17, 0x01, 0x0D, 0xFF, 0xE0,
  0xD0, 0x27, 0x20, 0x10, 0xBF, 0xFC, 0x0B, 0x01, 0x75, 0x06, 0x0D, 0xFF, 0x0E, 0x06, 0x77, 0x20,
  0x50, 0xAF, 0xB0, 0xB0, 0x67, 0x77, 0x86, 0x25, 0x67, 0x76, 0x53, 0x75,
  // "Ő" (U+0150)
  0x73, 0x03, 0xF9, 0x20, 0x8F, 0x0B, 0x77, 0x0B, 0xF8, 0x27, 0x01, 0xEF, 0x03, 0x76, 0x04, 0xF0,
  0xB2, 0x08, 0xF0, 0x77, 0x70, 0xCE, 0x82, 0xD1, 0x01, 0xF0, 0xA7, 0x70, 0x6E, 0x0D, 0x01, 0x20,
  0xAE, 0x0B, 0x77, 0x10, 0xED, 0x0E, 0x02, 0x20, 0x3E, 0x0B, 0x77, 0x10, 0x8D, 0x0E, 0x02, 0x30,
  0xCD, 0x0B, 0x77, 0x10, 0x2D, 0x0D, 0x02, 0x30, 0x6D, 0x0B, 0x77, 0x20, 0xAC, 0x0C, 0x01, 0x40,
  0xEC, 0x0A, 0x77, 0x20, 0x1C, 0x0A, 0x50, 0x5C, 0x08, 0x80, 0x9F, 0x30, 0x86, 0x35, 0x67, 0x76,
  0x53, 0x77, 0x72, 0x81, 0x5B, 0xEF, 0x98, 0x1E, 0xB5, 0x77, 0x40, 0x60, 0xDF, 0xF0, 0xE0, 0x67,
  0x71, 0x0A, 0xFF, 0xC0, 0xA0, 0x17, 0x40, 0x10, 0xCF, 0xFE, 0x0C, 0x01, 0x73, 0x0B, 0xFF, 0xF9,
  0x0B, 0x72, 0x07, 0xFF, 0xFB, 0x07, 0x70, 0x2F, 0xB8, 0x4E, 0xA8, 0x8A, 0xEF, 0xA0, 0xE0, 0x16,
  0x09, 0xFA, 0x08, 0x60, 0x8F, 0xA0, 0x95, 0x01, 0xFA, 0x07, 0x71, 0x06, 0xFA, 0x01, 0x40, 0x7F,
  0x90, 0xB7, 0x30, 0xBF, 0x90, 0x64, 0x0C, 0xF9, 0x03, 0x73, 0x03, 0xF9, 0x0C, 0x30, 0x1F, 0x90,
  0xD7, 0x50, 0xDF, 0x90, 0x12, 0x05, 0xF9, 0x08, 0x75, 0x08, 0xF9, 0x05, 0x20, 0x8F, 0x90, 0x57,
  0x50, 0x4F, 0x90, 0x82, 0x0B, 0xF9, 0x01, 0x75, 0x01, 0xF9, 0x0B, 0x20, 0xDF, 0x97, 0x7F, 0x90,
  0xD2, 0xF9, 0x0D, 0x77, 0x0D, 0xF9, 0x10, 0x1F, 0x90, 0xB7, 0x70, 0xBF, 0x91, 0x02, 0xF9, 0x0A,
  0x77, 0x0B, 0xF9, 0x00, 0x2F, 0x90, 0xA7, 0x70, 0xAF, 0x90, 0x20, 0x3F, 0x90, 0x97, 0x70, 0x9F,
  0x90, 0x20, 0x3F, 0x90, 0x97, 0x70, 0xAF, 0x90, 0x02, 0xF9, 0x0A, 0x77, 0x0A, 0xF9, 0x00, 0x2F,
  0x90, 0xA7, 0x70, 0xBF, 0x90, 0x20, 0x1F, 0x90, 0xB7, 0x70, 0xBF, 0x92, 0xF9, 0x0D, 0x77, 0x0D,
  0xF9, 0x20, 0xDF, 0x0E, 0x77, 0xF9, 0x0D, 0x20, 0xBF, 0x90, 0x17, 0x50, 0x1F, 0x90, 0xB2, 0x08,
  0xF9, 0x04, 0x75, 0x05, 0xF9, 0x08, 0x20, 0x5F, 0x90, 0x87, 0x50, 0x8F, 0x90, 0x52, 0x01, 0xF9,
  0x0D, 0x75, 0x0D, 0xF9, 0x01, 0x30, 0xCF, 0x90, 0x37, 0x30, 0x3F, 0x90, 0xC4, 0x07, 0xF9, 0x0B,
  0x73, 0x0B, 0xF9, 0x07, 0x40, 0x1F, 0xA0, 0x67, 0x10, 0x6F, 0xA0, 0x15, 0x09, 0xFA, 0x08, 0x60,
  0x8F, 0xA0, 0x96, 0x02, 0xFB, 0x84, 0xE9, 0x77, 0x9E, 0xFB, 0x01, 0x70, 0x7F, 0xFF, 0xB0, 0x77,
  0x20, 0xBF, 0xFF, 0x90, 0xB7, 0x30, 0x10, 0xCF, 0xFE, 0x0C, 0x01, 0x74, 0x01, 0x0B, 0xFF, 0xC0,
  0xB0, 0x17, 0x70, 0x60, 0xEF, 0xF0, 0xE0, 0x67, 0x74, 0x05, 0x0B, 0xFB, 0x0B, 0x05, 0x77, 0x72,
  0x86, 0x35, 0x67, 0x76, 0x53, 0x76,
  // "ő" (U+0151)
  0x72, 0x03, 0xF9, 0x20, 0x8F, 0x0B, 0x75, 0x0B, 0xF8, 0x27, 0x01, 0xEF, 0x03, 0x74, 0x04, 0xF0,
  0xB2, 0x08, 0xF0, 0x77, 0x50, 0xCE, 0x82, 0xD1, 0x01, 0xF0, 0xA7, 0x50, 0x6E, 0x0D, 0x01, 0x20,
  0xAE, 0x0B, 0x76, 0x0E, 0xD0, 0xE0, 0x22, 0x03, 0xE0, 0xB7, 0x60, 0x8D, 0x0E, 0x02, 0x30, 0xCD,
  0x0B, 0x76, 0x02, 0xD0, 0xD0, 0x23, 0x06, 0xD0, 0xB7, 0x70, 0xAC, 0x0C, 0x01, 0x40, 0xEC, 0x0A,
  0x77, 0x01, 0xC0, 0xA5, 0x05, 0xC0, 0x88, 0x09, 0xE3, 0x08, 0x62, 0x46, 0x77, 0x65, 0x37, 0x77,
  0x81, 0x49, 0xEF, 0xA0, 0xB0, 0x67, 0x72, 0x04, 0x0C, 0xFF, 0x0E, 0x06, 0x76, 0x09, 0xFF, 0xC0,
  0xC0, 0x17, 0x20, 0x10, 0xCF, 0xFE, 0x0D, 0x02, 0x71, 0x0C, 0xFF, 0xF9, 0x0D, 0x01, 0x60, 0x9F,
  0xFF, 0xB0, 0xB5, 0x03, 0xFB, 0x84, 0xE9, 0x87, 0x9D, 0xFB, 0x05, 0x40, 0xCF, 0xA0, 0x76, 0x05,
  0x0E, 0xF9, 0x0D, 0x30, 0x3F, 0xA0, 0x57, 0x10, 0x3F, 0xA0, 0x52, 0x09, 0xF9, 0x0A, 0x73, 0x09,
  0xF9, 0x0A, 0x20, 0xDF, 0x90, 0x27, 0x30, 0x1F, 0x98, 0x1E, 0x02, 0xF9, 0x0C, 0x75, 0x0C, 0xF9,
  0x02, 0x04, 0xF9, 0x08, 0x75, 0x08, 0xF9, 0x05, 0x06, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x07, 0x08,
  0xF9, 0x04, 0x75, 0x04, 0xF9, 0x00, 0x8F, 0x90, 0x37, 0x50, 0x3F, 0x90, 0x08, 0xF9, 0x03, 0x75,
  0x03, 0xF9, 0x00, 0x8F, 0x90, 0x47, 0x50, 0x4F, 0x90, 0x80, 0x7F, 0x90, 0x67, 0x50, 0x6F, 0x90,
  0x70, 0x5F, 0x90, 0x87, 0x50, 0x8F, 0x90, 0x40, 0x2F, 0x90, 0xC7, 0x50, 0xCF, 0x98, 0x12, 0x0E,
  0xF9, 0x02, 0x73, 0x01, 0xF9, 0x0D, 0x20, 0x9F, 0x90, 0xA7, 0x30, 0x9F, 0x90, 0x92, 0x04, 0xFA,
  0x05, 0x71, 0x04, 0xFA, 0x03, 0x30, 0xCF, 0xA0, 0x76, 0x05, 0x0E, 0xF9, 0x0C, 0x40, 0x4F, 0xB8,
  0x4E, 0x97, 0x79, 0xDF, 0xB0, 0x45, 0x0A, 0xFF, 0xFB, 0x0A, 0x70, 0xDF, 0xFF, 0x90, 0xD0, 0x17,
  0x01, 0x0D, 0xFF, 0xE0, 0xD0, 0x27, 0x20, 0x10, 0xBF, 0xFC, 0x0B, 0x01, 0x75, 0x06, 0x0D, 0xFF,
  0x0E, 0x06, 0x77, 0x20, 0x50, 0xAF, 0xB0, 0xB0, 0x67, 0x77, 0x86, 0x25, 0x67, 0x76, 0x53, 0x75,
  // "Œ" (U+0152)
  0x74, 0x86, 0x35, 0x67, 0x77, 0x51, 0x77, 0x72, 0x81, 0x29, 0xEF, 0xFF, 0x90, 0xC7, 0x08, 0xFF,
  0xFC, 0x0C, 0x60, 0xBF, 0xFF, 0xD0, 0xC5, 0x0B, 0xFF, 0xFE, 0x0C, 0x40, 0x7F, 0xFF, 0xF0, 0xC3,
  0x02, 0xFF, 0xFF, 0x90, 0xC3, 0x0A, 0xFA, 0x83, 0xC8, 0x79, 0xEF, 0x98, 0x03, 0xE0, 0xB2, 0x01,
  0xFA, 0x07, 0x40, 0x9F, 0x09, 0x73, 0x07, 0xF9, 0x09, 0x50, 0x9F, 0x09, 0x73, 0x0C, 0xF0, 0xE0,
  0x15, 0x09, 0xF0, 0x97, 0x20, 0x1F, 0x90, 0x96, 0x09, 0xF0, 0x97, 0x20, 0x4F, 0x90, 0x46, 0x09,
  0xF0, 0x97, 0x20, 0x7F, 0x97, 0x09, 0xF0, 0x97, 0x20, 0xAF, 0x0D, 0x70, 0x9F, 0x09, 0x72, 0x0C,
  0xF0, 0xA7, 0x09, 0xF0, 0x97, 0x20, 0xEF, 0x09, 0x70, 0x9F, 0x09, 0x72, 0xF9, 0x07, 0x70, 0x9F,
  0xF8, 0x1B, 0x01, 0xF9, 0x06, 0x70, 0x9F, 0xF8, 0x1B, 0x02, 0xF9, 0x05, 0x70, 0x9F, 0xF8, 0x1B,
  0x02, 0xF9, 0x05, 0x70, 0x9F, 0xF8, 0x1B, 0x03, 0xF9, 0x05, 0x70, 0x9F, 0xF8, 0x1B, 0x02, 0xF9,
  0x05, 0x70, 0x9F, 0xF8, 0x1B, 0x02, 0xF9, 0x05, 0x70, 0x9F, 0x98, 0x02, 0xE8, 0x1A, 0x02, 0xF9,
  0x05, 0x70, 0x9F, 0x09, 0x71, 0x01, 0xF9, 0x06, 0x70, 0x9F, 0x09, 0x72, 0xF9, 0x07, 0x70, 0x9F,
  0x09, 0x72, 0x0E, 0xF0, 0x87, 0x09, 0xF0, 0x97, 0x20, 0xCF, 0x09, 0x70, 0x9F, 0x09, 0x72, 0x0A,
  0xF0, 0xC7, 0x09, 0xF0, 0x97, 0x20, 0x8F, 0x0E, 0x70, 0x9F, 0x09, 0x72, 0x05, 0xF9, 0x02, 0x60,
  0x9F, 0x09, 0x72, 0x01, 0xF9, 0x06, 0x60, 0x9F, 0x09, 0x73, 0x0D, 0xF0, 0xC6, 0x09, 0xF0, 0x97,
  0x30, 0x8F, 0x90, 0x45, 0x09, 0xF0, 0x97, 0x30, 0x2F, 0x90, 0xE0, 0x34, 0x09, 0xF0, 0x97, 0x40,
  0xBF, 0xA8, 0x2B, 0x88, 0xBF, 0xA8, 0x03, 0xE0, 0xB3, 0x03, 0xFF, 0xFF, 0x90, 0xC4, 0x09, 0xFF,
  0xFF, 0x0C, 0x50, 0xDF, 0xFF, 0xE0, 0xC5, 0x01, 0x0D, 0xFF, 0xFD, 0x0C, 0x60, 0x10, 0xAF, 0xFF,
  0xC0, 0xC7, 0x10, 0x40, 0xBF, 0xFF, 0xA0, 0xC7, 0x48, 0x53, 0x67, 0x76, 0x53, 0x77, 0x20,
  // "œ" (U+0153)
  0x78, 0x41, 0x46, 0x76, 0x47, 0x38, 0x34, 0x77, 0x52, 0x75, 0x02, 0x0A, 0xE0, 0xE0, 0x86, 0x08,
  0x0E, 0xD0, 0xC0, 0x47, 0x20, 0x5F, 0xB0, 0xD0, 0x12, 0x01, 0x0C, 0xFA, 0x08, 0x70, 0x5F, 0xD0,
  0xD2, 0x0C, 0xFC, 0x06, 0x50, 0x10, 0xEF, 0xE0, 0x90, 0x7F, 0xE0, 0x24, 0x09, 0xFF, 0xFF, 0x90,
  0x93, 0x01, 0xF8, 0x1C, 0x8C, 0xFC, 0x82, 0xE9, 0x9E, 0xE0, 0x12, 0x07, 0xE0, 0xB3, 0x09, 0xFA,
  0x0E, 0x02, 0x20, 0x4E, 0x06, 0x20, 0xCE, 0x02, 0x40, 0xEF, 0x90, 0x54, 0x0B, 0xD8, 0x1A, 0x01,
  0xE0, 0xD5, 0x09, 0xF0, 0xE5, 0x06, 0xD8, 0x1E, 0x05, 0xE0, 0x95, 0x04, 0xF0, 0xA5, 0x03, 0xE0,
  0x10, 0x7E, 0x07, 0x50, 0x1F, 0x07, 0x50, 0x2E, 0x03, 0x0A, 0xE0, 0x56, 0x0E, 0xE0, 0x66, 0xE0,
  0x40, 0xBE, 0x04, 0x60, 0xDE, 0x05, 0x6E, 0x05, 0x0C, 0xE0, 0x36, 0x0C, 0xFF, 0xD0, 0x60, 0xDE,
  0x02, 0x60, 0xBF, 0xFD, 0x06, 0x0E, 0xE0, 0x26, 0x0B, 0xFF, 0xD0, 0x60, 0xEE, 0x02, 0x60, 0xBF,
  0xFD, 0x06, 0x0D, 0xE0, 0x26, 0x0B, 0xFF, 0xD0, 0x60, 0xCE, 0x03, 0x60, 0xCE, 0x05, 0x76, 0x0B,
  0xE0, 0x46, 0x0D, 0xE0, 0x57, 0x60, 0x9E, 0x05, 0x60, 0xEE, 0x07, 0x76, 0x07, 0xE0, 0x75, 0x01,
  0xF0, 0x97, 0x60, 0x4E, 0x09, 0x50, 0x4F, 0x0D, 0x77, 0xE0, 0xD5, 0x09, 0xF9, 0x03, 0x76, 0x0B,
  0xE0, 0x34, 0x0E, 0xF9, 0x0C, 0x72, 0x02, 0x05, 0x20, 0x6E, 0x0B, 0x30, 0x9F, 0xB0, 0xA0, 0x15,
  0x82, 0x4A, 0xF8, 0x20, 0x10, 0xEE, 0x81, 0xC8, 0xCF, 0xE8, 0x3A, 0x88, 0xAE, 0xB0, 0x83, 0x08,
  0xFF, 0x90, 0xEF, 0xF0, 0x84, 0x0D, 0xFE, 0x0A, 0x06, 0xFF, 0x08, 0x40, 0x30, 0xEF, 0xC8, 0x2D,
  0x10, 0xAF, 0xE0, 0x85, 0x03, 0x0E, 0xFA, 0x0C, 0x01, 0x30, 0xBF, 0xC0, 0xD0, 0x36, 0x01, 0x09,
  0xE0, 0xE0, 0x76, 0x07, 0x0E, 0xF0, 0xA0, 0x57, 0x48, 0x34, 0x67, 0x64, 0x73, 0x84, 0x36, 0x77,
  0x53, 0x60,
  // "Ŕ" (U+0154)
  0x77, 0x10, 0x68, 0x04, 0x70, 0x67, 0x76, 0x04, 0xFA, 0x05, 0x77, 0x60, 0xDF, 0x90, 0x67, 0x76,
  0x08, 0xF9, 0x06, 0x77, 0x60, 0x3F, 0x90, 0x57, 0x77, 0x0D, 0xF0, 0x47, 0x77, 0x09, 0xE0, 0xE0,
  0x47, 0x77, 0x05, 0xE0, 0xE0, 0x37, 0x77, 0x02, 0x0E, 0xD0, 0xC0, 0x17, 0x77, 0x10, 0x9D, 0x0A,
  0x80, 0xA8, 0x70, 0x03, 0xFD, 0x84, 0xED, 0xCA, 0x73, 0x75, 0x03, 0xFF, 0xC8, 0x1E, 0x82, 0x72,
  0x03, 0xFF, 0xF0, 0x87, 0x10, 0x3F, 0xFF, 0x90, 0xD0, 0x16, 0x03, 0xFF, 0xFA, 0x0D, 0x01, 0x50,
  0x3F, 0xFF, 0xB0, 0xC5, 0x03, 0xFA, 0x00, 0xEF, 0xF0, 0x54, 0x03, 0xF9, 0x07, 0x48, 0x13, 0x6C,
  0xFA, 0x0D, 0x40, 0x3F, 0x90, 0x77, 0x07, 0xFA, 0x03, 0x30, 0x3F, 0x90, 0x77, 0x10, 0x9F, 0x90,
  0x73, 0x03, 0xF9, 0x07, 0x71, 0x03, 0xF9, 0x0A, 0x30, 0x3F, 0x90, 0x77, 0x2F, 0x90, 0xB3, 0x03,
  0xF9, 0x07, 0x72, 0x0E, 0xF0, 0xD3, 0x03, 0xF9, 0x07, 0x72, 0xF9, 0x0C, 0x30, 0x3F, 0x90, 0x77,
  0x10, 0x1F, 0x90, 0xB3, 0x03, 0xF9, 0x07, 0x71, 0x06, 0xF9, 0x08, 0x30, 0x3F, 0x90, 0x77, 0x10,
  0xDF, 0x90, 0x53, 0x03, 0xF9, 0x07, 0x60, 0x10, 0xBF, 0x90, 0xE4, 0x03, 0xF9, 0x07, 0x38, 0x21,
  0x38, 0xEF, 0xA0, 0x94, 0x03, 0xFF, 0xFB, 0x0E, 0x01, 0x40, 0x3F, 0xFF, 0xB0, 0x45, 0x03, 0xFF,
  0xFA, 0x05, 0x60, 0x3F, 0xFF, 0x0E, 0x04, 0x70, 0x3F, 0xFE, 0x09, 0x01, 0x71, 0x03, 0xFF, 0xD0,
  0xC7, 0x30, 0x3F, 0xA0, 0xFE, 0xF9, 0x06, 0x72, 0x03, 0xF9, 0x07, 0x30, 0xBF, 0x0E, 0x01, 0x71,
  0x03, 0xF9, 0x07, 0x30, 0x3F, 0x90, 0x97, 0x10, 0x3F, 0x90, 0x74, 0x0A, 0xF9, 0x02, 0x70, 0x3F,
  0x90, 0x74, 0x02, 0xF9, 0x0B, 0x70, 0x3F, 0x90, 0x75, 0x08, 0xF9, 0x05, 0x60, 0x3F, 0x90, 0x75,
  0x01, 0x0E, 0xF0, 0xD6, 0x03, 0xF9, 0x07, 0x60, 0x6F, 0x90, 0x85, 0x03, 0xF9, 0x07, 0x70, 0xDF,
  0x90, 0x24, 0x03, 0xF9, 0x07, 0x70, 0x5F, 0x90, 0xA4, 0x03, 0xF9, 0x07, 0x71, 0x0B, 0xF9, 0x04,
  0x30, 0x3F, 0x90, 0x77, 0x10, 0x3F, 0x90, 0xD3, 0x03, 0xF9, 0x07, 0x72, 0x0A, 0xF9, 0x07, 0x20,
  0x3F, 0x90, 0x77, 0x20, 0x1F, 0x98, 0x2E, 0x10, 0x3F, 0x90, 0x77, 0x30, 0x8F, 0x98, 0x19, 0x03,
  0xF9, 0x07, 0x74, 0x0E, 0xF9, 0x00, 0x3F, 0x90, 0x77, 0x40, 0x6F, 0x90, 0xC0,
  // "ŕ" (U+0155)
  0x77, 0x50, 0x68, 0x04, 0x70, 0x67, 0x77, 0x10, 0x4F, 0xA0, 0x57, 0x77, 0x10, 0xDF, 0x90, 0x67,
  0x77, 0x10, 0x8F, 0x90, 0x67, 0x77, 0x10, 0x3F, 0x90, 0x57, 0x77, 0x20, 0xDF, 0x04, 0x77, 0x72,
  0x09, 0xE0, 0xE0, 0x47, 0x77, 0x20, 0x5E, 0x0E, 0x03, 0x77, 0x72, 0x02, 0x0E, 0xD0, 0xC0, 0x17,
  0x77, 0x30, 0x9D, 0x0A, 0x80, 0xA8, 0x40, 0x85, 0x35, 0x77, 0x65, 0x34, 0x0E, 0xFD, 0x0A, 0x58,
  0x11, 0x8E, 0xF9, 0x09, 0x20, 0xEF, 0xD0, 0xE4, 0x05, 0x0E, 0xFB, 0x0A, 0x20, 0xEF, 0xE0, 0x22,
  0x07, 0xFD, 0x05, 0x20, 0xEF, 0xE8, 0x16, 0x06, 0xFE, 0x01, 0x20, 0xEF, 0xE0, 0x90, 0x2F, 0xE0,
  0xC3, 0x0E, 0xFE, 0x0E, 0x0D, 0xFE, 0x07, 0x48, 0x43, 0x57, 0x9B, 0xDF, 0xFF, 0x90, 0x37, 0x3F,
  0xF8, 0x6C, 0x98, 0x89, 0xCF, 0xD7, 0x4F, 0xD0, 0x90, 0x17, 0x03, 0x74, 0xFC, 0x05, 0x77, 0x7F,
  0xB0, 0x77, 0x77, 0x1F, 0xA0, 0xD7, 0x77, 0x2F, 0xA0, 0x67, 0x77, 0x2F, 0xA0, 0x17, 0x77, 0x2F,
  0x90, 0xD7, 0x77, 0x3F, 0x90, 0xB7, 0x77, 0x3F, 0x90, 0xA7, 0x77, 0x3F, 0x90, 0xA7, 0x77, 0x3F,
  0x90, 0xA7, 0x77, 0x3F, 0x90, 0xA7, 0x77, 0x3F, 0x90, 0xA7, 0x77, 0x3F, 0x90, 0xA7, 0x77, 0x3F,
  0x90, 0xA7, 0x77, 0x3F, 0x90, 0xA7, 0x77, 0x3F, 0x90, 0xA7, 0x75, 0x83, 0x14, 0x8B, 0xEF, 0xA8,
  0x2D, 0xA7, 0x37, 0x48, 0x22, 0x7A, 0xEF, 0xFD, 0x82, 0xD9, 0x61, 0x60, 0x8F, 0xFF, 0xC0, 0x46,
  0x08, 0xFF, 0xFC, 0x04, 0x60, 0x8F, 0xFF, 0xC0, 0x46, 0x08, 0xFF, 0xFC, 0x04, 0x60, 0x8F, 0xFF,
  0xC0, 0x46,
  // "Ŗ" (U+0156)
  0x03, 0xFD, 0x84, 0xED, 0xCA, 0x73, 0x75, 0x03, 0xFF, 0xC8, 0x1E, 0x82, 0x72, 0x03, 0xFF, 0xF0,
  0x87, 0x10, 0x3F, 0xFF, 0x90, 0xD0, 0x16, 0x03, 0xFF, 0xFA, 0x0D, 0x01, 0x50, 0x3F, 0xFF, 0xB0,
  0xC5, 0x03, 0xFA, 0x00, 0xEF, 0xF0, 0x54, 0x03, 0xF9, 0x07, 0x48, 0x13, 0x6C, 0xFA, 0x0D, 0x40,
  0x3F, 0x90, 0x77, 0x07, 0xFA, 0x03, 0x30, 0x3F, 0x90, 0x77, 0x10, 0x9F, 0x90, 0x73, 0x03, 0xF9,
  0x07, 0x71, 0x03, 0xF9, 0x0A, 0x30, 0x3F, 0x90, 0x77, 0x2F, 0x90, 0xB3, 0x03, 0xF9, 0x07, 0x72,
  0x0E, 0xF0, 0xD3, 0x03, 0xF9, 0x07, 0x72, 0xF9, 0x0C, 0x30, 0x3F, 0x90, 0x77, 0x10, 0x1F, 0x90,
  0xB3, 0x03, 0xF9, 0x07, 0x71, 0x06, 0xF9, 0x08, 0x30, 0x3F, 0x90, 0x77, 0x10, 0xDF, 0x90, 0x53,
  0x03, 0xF9, 0x07, 0x60, 0x10, 0xBF, 0x90, 0xE4, 0x03, 0xF9, 0x07, 0x38, 0x21, 0x38, 0xEF, 0xA0,
  0x94, 0x03, 0xFF, 0xFB, 0x0E, 0x01, 0x40, 0x3F, 0xFF, 0xB0, 0x45, 0x03, 0xFF, 0xFA, 0x05, 0x60,
  0x3F, 0xFF, 0x0E, 0x04, 0x70, 0x3F, 0xFE, 0x09, 0x01, 0x71, 0x03, 0xFF, 0xD0, 0xC7, 0x30, 0x3F,
  0xA0, 0xFE, 0xF9, 0x06, 0x72, 0x03, 0xF9, 0x07, 0x30, 0xBF, 0x0E, 0x01, 0x71, 0x03, 0xF9, 0x07,
  0x30, 0x3F, 0x90, 0x97, 0x10, 0x3F, 0x90, 0x74, 0x0A, 0xF9, 0x02, 0x70, 0x3F, 0x90, 0x74, 0x02,
  0xF9, 0x0B, 0x70, 0x3F, 0x90, 0x75, 0x08, 0xF9, 0x05, 0x60, 0x3F, 0x90, 0x75, 0x01, 0x0E, 0xF0,
  0xD6, 0x03, 0xF9, 0x07, 0x60, 0x6F, 0x90, 0x85, 0x03, 0xF9, 0x07, 0x70, 0xDF, 0x90, 0x24, 0x03,
  0xF9, 0x07, 0x70, 0x5F, 0x90, 0xA4, 0x03, 0xF9, 0x07, 0x71, 0x0B, 0xF9, 0x04, 0x30, 0x3F, 0x90,
  0x77, 0x10, 0x3F, 0x90, 0xD3, 0x03, 0xF9, 0x07, 0x72, 0x0A, 0xF9, 0x07, 0x20, 0x3F, 0x90, 0x77,
  0x20, 0x1F, 0x98, 0x2E, 0x10, 0x3F, 0x90, 0x77, 0x30, 0x8F, 0x98, 0x19, 0x03, 0xF9, 0x07, 0x74,
  0x0E, 0xF9, 0x00, 0x3F, 0x90, 0x77, 0x40, 0x6F, 0x90, 0xC8, 0x09, 0xC4, 0x00, 0x2F, 0x0D, 0x77,
  0x71, 0x04, 0xF0, 0x87, 0x77, 0x10, 0x7F, 0x01, 0x77, 0x71, 0x0A, 0xE0, 0x97, 0x77, 0x20, 0xDE,
  0x02, 0x77, 0x71, 0x01, 0xE0, 0x97, 0x77, 0x20, 0x4E, 0x01, 0x77, 0x72, 0x07, 0xD0, 0x87, 0x77,
  0x30, 0xBC, 0x0D, 0x77, 0x74, 0x0E, 0xC0, 0x57, 0x71,
  // "ŗ" (U+0157)
  0x77, 0x73, 0x85, 0x35, 0x77, 0x65, 0x34, 0x0E, 0xFD, 0x0A, 0x58, 0x11, 0x8E, 0xF9, 0x09, 0x20,
  0xEF, 0xD0, 0xE4, 0x05, 0x0E, 0xFB, 0x0A, 0x20, 0xEF, 0xE0, 0x22, 0x07, 0xFD, 0x05, 0x20, 0xEF,
  0xE8, 0x16, 0x06, 0xFE, 0x01, 0x20, 0xEF, 0xE0, 0x90, 0x2F, 0xE0, 0xC3, 0x0E, 0xFE, 0x0E, 0x0D,
  0xFE, 0x07, 0x48, 0x43, 0x57, 0x9B, 0xDF, 0xFF, 0x90, 0x37, 0x3F, 0xF8, 0x6C, 0x98, 0x89, 0xCF,
  0xD7, 0x4F, 0xD0, 0x90, 0x17, 0x03, 0x74, 0xFC, 0x05, 0x77, 0x7F, 0xB0, 0x77, 0x77, 0x1F, 0xA0,
  0xD7, 0x77, 0x2F, 0xA0, 0x67, 0x77, 0x2F, 0xA0, 0x17, 0x77, 0x2F, 0x90, 0xD7, 0x77, 0x3F, 0x90,
  0xB7, 0x77, 0x3F, 0x90, 0xA7, 0x77, 0x3F, 0x90, 0xA7, 0x77, 0x3F, 0x90, 0xA7, 0x77, 0x3F, 0x90,
  0xA7, 0x77, 0x3F, 0x90, 0xA7, 0x77, 0x3F, 0x90, 0xA7, 0x77, 0x3F, 0x90, 0xA7, 0x77, 0x3F, 0x90,
  0xA7, 0x77, 0x3F, 0x90, 0xA7, 0x75, 0x83, 0x14, 0x8B, 0xEF, 0xA8, 0x2D, 0xA7, 0x37, 0x48, 0x22,
  0x7A, 0xEF, 0xFD, 0x82, 0xD9, 0x61, 0x60, 0x8F, 0xFF, 0xC0, 0x46, 0x08, 0xFF, 0xFC, 0x04, 0x60,
  0x8F, 0xFF, 0xC0, 0x46, 0x08, 0xFF, 0xFC, 0x04, 0x60, 0x8F, 0xFF, 0xC0, 0x48, 0x09, 0xD6, 0x00,
  0x2F, 0x0D, 0x77, 0x73, 0x04, 0xF0, 0x87, 0x77, 0x30, 0x7F, 0x01, 0x77, 0x73, 0x0A, 0xE0, 0x97,
  0x77, 0x40, 0xDE, 0x02, 0x77, 0x73, 0x01, 0xE0, 0x97, 0x77, 0x40, 0x4E, 0x01, 0x77, 0x74, 0x07,
  0xD0, 0x87, 0x77, 0x50, 0xBC, 0x0D, 0x77, 0x76, 0x0E, 0xC0, 0x57, 0x75,
  // "Ř" (U+0158)
  0x38, 0x01, 0x70, 0x57, 0x30, 0x58, 0x01, 0x77, 0x20, 0xBD, 0x09, 0x71, 0x09, 0xD0, 0xB7, 0x30,
  0xCD, 0x0C, 0x01, 0x40, 0x20, 0xCD, 0x0D, 0x01, 0x73, 0x01, 0x0E, 0xD0, 0xD0, 0x22, 0x03, 0x0E,
  0xD0, 0xE0, 0x27, 0x50, 0x4E, 0x82, 0xE2, 0x3E, 0xE0, 0x47, 0x70, 0x7E, 0x0D, 0x0E, 0xE0, 0x87,
  0x72, 0x0B, 0xFD, 0x0B, 0x77, 0x30, 0x10, 0xEF, 0xB0, 0xE0, 0x17, 0x74, 0x05, 0xFB, 0x05, 0x77,
  0x60, 0xAF, 0x90, 0xA8, 0x0A, 0x84, 0x00, 0x3F, 0xD8, 0x4E, 0xDC, 0xA7, 0x37, 0x50, 0x3F, 0xFC,
  0x81, 0xE8, 0x27, 0x20, 0x3F, 0xFF, 0x08, 0x71, 0x03, 0xFF, 0xF9, 0x0D, 0x01, 0x60, 0x3F, 0xFF,
  0xA0, 0xD0, 0x15, 0x03, 0xFF, 0xFB, 0x0C, 0x50, 0x3F, 0xA0, 0x0E, 0xFF, 0x05, 0x40, 0x3F, 0x90,
  0x74, 0x81, 0x36, 0xCF, 0xA0, 0xD4, 0x03, 0xF9, 0x07, 0x70, 0x7F, 0xA0, 0x33, 0x03, 0xF9, 0x07,
  0x71, 0x09, 0xF9, 0x07, 0x30, 0x3F, 0x90, 0x77, 0x10, 0x3F, 0x90, 0xA3, 0x03, 0xF9, 0x07, 0x72,
  0xF9, 0x0B, 0x30, 0x3F, 0x90, 0x77, 0x20, 0xEF, 0x0D, 0x30, 0x3F, 0x90, 0x77, 0x2F, 0x90, 0xC3,
  0x03, 0xF9, 0x07, 0x71, 0x01, 0xF9, 0x0B, 0x30, 0x3F, 0x90, 0x77, 0x10, 0x6F, 0x90, 0x83, 0x03,
  0xF9, 0x07, 0x71, 0x0D, 0xF9, 0x05, 0x30, 0x3F, 0x90, 0x76, 0x01, 0x0B, 0xF9, 0x0E, 0x40, 0x3F,
  0x90, 0x73, 0x82, 0x13, 0x8E, 0xFA, 0x09, 0x40, 0x3F, 0xFF, 0xB0, 0xE0, 0x14, 0x03, 0xFF, 0xFB,
  0x04, 0x50, 0x3F, 0xFF, 0xA0, 0x56, 0x03, 0xFF, 0xF0, 0xE0, 0x47, 0x03, 0xFF, 0xE0, 0x90, 0x17,
  0x10, 0x3F, 0xFD, 0x0C, 0x73, 0x03, 0xFA, 0x0F, 0xEF, 0x90, 0x67, 0x20, 0x3F, 0x90, 0x73, 0x0B,
  0xF0, 0xE0, 0x17, 0x10, 0x3F, 0x90, 0x73, 0x03, 0xF9, 0x09, 0x71, 0x03, 0xF9, 0x07, 0x40, 0xAF,
  0x90, 0x27, 0x03, 0xF9, 0x07, 0x40, 0x2F, 0x90, 0xB7, 0x03, 0xF9, 0x07, 0x50, 0x8F, 0x90, 0x56,
  0x03, 0xF9, 0x07, 0x50, 0x10, 0xEF, 0x0D, 0x60, 0x3F, 0x90, 0x76, 0x06, 0xF9, 0x08, 0x50, 0x3F,
  0x90, 0x77, 0x0D, 0xF9, 0x02, 0x40, 0x3F, 0x90, 0x77, 0x05, 0xF9, 0x0A, 0x40, 0x3F, 0x90, 0x77,
  0x10, 0xBF, 0x90, 0x43, 0x03, 0xF9, 0x07, 0x71, 0x03, 0xF9, 0x0D, 0x30, 0x3F, 0x90, 0x77, 0x20,
  0xAF, 0x90, 0x72, 0x03, 0xF9, 0x07, 0x72, 0x01, 0xF9, 0x82, 0xE1, 0x03, 0xF9, 0x07, 0x73, 0x08,
  0xF9, 0x81, 0x90, 0x3F, 0x90, 0x77, 0x40, 0xEF, 0x90, 0x03, 0xF9, 0x07, 0x74, 0x06, 0xF9, 0x0C,
  // "ř" (U+0159)
  0x78, 0x01, 0x70, 0x57, 0x30, 0x58, 0x01, 0x77, 0x40, 0xBD, 0x09, 0x71, 0x09, 0xD0, 0xB7, 0x50,
  0xCD, 0x0C, 0x01, 0x40, 0x20, 0xCD, 0x0D, 0x01, 0x75, 0x01, 0x0E, 0xD0, 0xD0, 0x22, 0x03, 0x0E,
  0xD0, 0xE0, 0x27, 0x70, 0x4E, 0x82, 0xE2, 0x3E, 0xE0, 0x47, 0x72, 0x07, 0xE0, 0xD0, 0xEE, 0x08,
  0x77, 0x40, 0xBF, 0xD0, 0xB7, 0x75, 0x01, 0x0E, 0xFB, 0x0E, 0x01, 0x77, 0x60, 0x5F, 0xB0, 0x57,
  0x77, 0x10, 0xAF, 0x90, 0xA8, 0x0A, 0x81, 0x08, 0x53, 0x57, 0x76, 0x53, 0x40, 0xEF, 0xD0, 0xA5,
  0x81, 0x18, 0xEF, 0x90, 0x92, 0x0E, 0xFD, 0x0E, 0x40, 0x50, 0xEF, 0xB0, 0xA2, 0x0E, 0xFE, 0x02,
  0x20, 0x7F, 0xD0, 0x52, 0x0E, 0xFE, 0x81, 0x60, 0x6F, 0xE0, 0x12, 0x0E, 0xFE, 0x09, 0x02, 0xFE,
  0x0C, 0x30, 0xEF, 0xE0, 0xE0, 0xDF, 0xE0, 0x74, 0x84, 0x35, 0x79, 0xBD, 0xFF, 0xF9, 0x03, 0x73,
  0xFF, 0x86, 0xC9, 0x88, 0x9C, 0xFD, 0x74, 0xFD, 0x09, 0x01, 0x70, 0x37, 0x4F, 0xC0, 0x57, 0x77,
  0xFB, 0x07, 0x77, 0x71, 0xFA, 0x0D, 0x77, 0x72, 0xFA, 0x06, 0x77, 0x72, 0xFA, 0x01, 0x77, 0x72,
  0xF9, 0x0D, 0x77, 0x73, 0xF9, 0x0B, 0x77, 0x73, 0xF9, 0x0A, 0x77, 0x73, 0xF9, 0x0A, 0x77, 0x73,
  0xF9, 0x0A, 0x77, 0x73, 0xF9, 0x0A, 0x77, 0x73, 0xF9, 0x0A, 0x77, 0x73, 0xF9, 0x0A, 0x77, 0x73,
  0xF9, 0x0A, 0x77, 0x73, 0xF9, 0x0A, 0x77, 0x73, 0xF9, 0x0A, 0x77, 0x58, 0x31, 0x48, 0xBE, 0xFA,
  0x82, 0xDA, 0x73, 0x74, 0x82, 0x27, 0xAE, 0xFF, 0xD8, 0x2D, 0x96, 0x16, 0x08, 0xFF, 0xFC, 0x04,
  0x60, 0x8F, 0xFF, 0xC0, 0x46, 0x08, 0xFF, 0xFC, 0x04, 0x60, 0x8F, 0xFF, 0xC0, 0x46, 0x08, 0xFF,
  0xFC, 0x04, 0x60,
  // "Ś" (U+015A)
  0x77, 0x20, 0x68, 0x04, 0x70, 0x67, 0x74, 0x04, 0xFA, 0x05, 0x77, 0x40, 0xDF, 0x90, 0x67, 0x74,
  0x08, 0xF9, 0x06, 0x77, 0x40, 0x3F, 0x90, 0x57, 0x75, 0x0D, 0xF0, 0x47, 0x75, 0x09, 0xE0, 0xE0,
  0x47, 0x75, 0x05, 0xE0, 0xE0, 0x37, 0x75, 0x02, 0x0E, 0xD0, 0xC0, 0x17, 0x76, 0x09, 0xD0, 0xA8,
  0x09, 0xD2, 0x08, 0x73, 0x56, 0x77, 0x65, 0x42, 0x77, 0x28, 0x12, 0x7C, 0xFC, 0x82, 0xDA, 0x62,
  0x72, 0x01, 0x0A, 0xFF, 0xC0, 0xC0, 0x66, 0x05, 0x0E, 0xFF, 0xF0, 0xB4, 0x06, 0xFF, 0xFA, 0x06,
  0x30, 0x3F, 0xFF, 0xA0, 0xE4, 0x0C, 0xFF, 0xFA, 0x08, 0x30, 0x3F, 0xB8, 0x6E, 0xA7, 0x78, 0x9C,
  0xEE, 0x02, 0x30, 0x8F, 0xA0, 0x77, 0x18, 0x13, 0x8D, 0xA0, 0xB4, 0x0B, 0xF9, 0x08, 0x75, 0x81,
  0x4A, 0x54, 0x0D, 0xF9, 0x02, 0x77, 0x50, 0xEF, 0x0E, 0x77, 0x60, 0xEF, 0x97, 0x76, 0x0C, 0xF9,
  0x02, 0x77, 0x50, 0xAF, 0x90, 0xA7, 0x75, 0x05, 0xFA, 0x08, 0x77, 0x50, 0xEF, 0xA0, 0xC0, 0x37,
  0x73, 0x07, 0xFC, 0x0B, 0x03, 0x77, 0x20, 0xBF, 0xD0, 0xB0, 0x37, 0x70, 0x10, 0xDF, 0xE0, 0xB0,
  0x37, 0x60, 0x10, 0xCF, 0xF0, 0xA0, 0x27, 0x60, 0xAF, 0xF9, 0x08, 0x76, 0x05, 0x0E, 0xFF, 0x0D,
  0x03, 0x75, 0x01, 0x09, 0xFF, 0x90, 0x57, 0x60, 0x20, 0xBF, 0xF0, 0x57, 0x70, 0x30, 0xBF, 0xE0,
  0x27, 0x71, 0x03, 0x0B, 0xFC, 0x0B, 0x77, 0x30, 0x40, 0xCF, 0xB0, 0x27, 0x74, 0x0A, 0xFA, 0x06,
  0x77, 0x50, 0xBF, 0x90, 0x97, 0x75, 0x05, 0xF9, 0x0A, 0x77, 0x50, 0x3F, 0x90, 0xA7, 0x75, 0x04,
  0xF9, 0x81, 0x96, 0x27, 0x73, 0x07, 0xF9, 0x83, 0x7C, 0xFA, 0x47, 0x70, 0x10, 0xEF, 0x90, 0x40,
  0xCB, 0x82, 0xE9, 0x41, 0x72, 0x05, 0x0D, 0xF9, 0x81, 0xE0, 0xCF, 0x87, 0xDA, 0x98, 0x77, 0x8B,
  0xEF, 0xB8, 0x18, 0x0C, 0xFF, 0xFC, 0x82, 0xE1, 0x0C, 0xFF, 0xFC, 0x04, 0x20, 0xCF, 0xFF, 0xB0,
  0x53, 0x0C, 0xFF, 0xF9, 0x0D, 0x03, 0x48, 0x12, 0x8E, 0xFF, 0xC0, 0xD0, 0x77, 0x28, 0x23, 0x7B,
  0xEF, 0xC8, 0x1D, 0x94, 0x77, 0x18, 0x91, 0x13, 0x56, 0x77, 0x76, 0x53, 0x17, 0x40,
  // "ś" (U+015B)
  0x77, 0x10, 0x68, 0x04, 0x70, 0x67, 0x73, 0x04, 0xFA, 0x05, 0x77, 0x30, 0xDF, 0x90, 0x67, 0x73,
  0x08, 0xF9, 0x06, 0x77, 0x30, 0x3F, 0x90, 0x57, 0x74, 0x0D, 0xF0, 0x47, 0x74, 0x09, 0xE0, 0xE0,
  0x47, 0x74, 0x05, 0xE0, 0xE0, 0x37, 0x74, 0x02, 0x0E, 0xD0, 0xC0, 0x17, 0x75, 0x09, 0xD0, 0xA8,
  0x09, 0xC6, 0x08, 0x73, 0x45, 0x67, 0x66, 0x53, 0x77, 0x18, 0x12, 0x8B, 0xFC, 0x82, 0xEA, 0x63,
  0x71, 0x02, 0x0A, 0xFF, 0xC8, 0x1D, 0x82, 0x40, 0x40, 0xEF, 0xFF, 0x0E, 0x30, 0x3F, 0xFF, 0xA0,
  0x83, 0x0D, 0xFF, 0xFA, 0x02, 0x20, 0x5F, 0xFF, 0xA0, 0xA3, 0x0A, 0xFA, 0x86, 0xC8, 0x77, 0x89,
  0xBD, 0xE0, 0x43, 0x0D, 0xF9, 0x04, 0x71, 0x84, 0x15, 0x8D, 0xFD, 0x40, 0xEF, 0x0E, 0x76, 0x03,
  0x04, 0x40, 0xEF, 0x90, 0x27, 0x74, 0x0C, 0xF9, 0x0D, 0x03, 0x77, 0x30, 0x9F, 0xB8, 0x1C, 0x61,
  0x77, 0x03, 0xFE, 0x0A, 0x05, 0x76, 0x08, 0xFF, 0x81, 0xE9, 0x37, 0x40, 0xAF, 0xFA, 0x0C, 0x04,
  0x73, 0x07, 0xFF, 0xB0, 0xB0, 0x27, 0x20, 0x20, 0xAF, 0xFB, 0x05, 0x73, 0x81, 0x29, 0xEF, 0xF9,
  0x04, 0x75, 0x06, 0x0C, 0xFE, 0x0E, 0x01, 0x76, 0x81, 0x39, 0xEF, 0xC0, 0x87, 0x72, 0x05, 0x0C,
  0xFA, 0x0D, 0x77, 0x40, 0x7F, 0xA0, 0x17, 0x74, 0x0D, 0xF9, 0x83, 0x23, 0xD7, 0x27, 0x70, 0xCF,
  0x90, 0x20, 0x3B, 0x82, 0xC8, 0x41, 0x72, 0x05, 0xFA, 0x10, 0x3F, 0x87, 0xDB, 0x98, 0x77, 0x89,
  0xDF, 0xA8, 0x1E, 0x03, 0xFF, 0xFC, 0x81, 0x80, 0x3F, 0xFF, 0xC8, 0x12, 0x03, 0xFF, 0xFB, 0x06,
  0x20, 0x3F, 0xFF, 0xA0, 0x63, 0x02, 0x0D, 0xFF, 0xE0, 0xB0, 0x36, 0x82, 0x37, 0xBE, 0xFE, 0x81,
  0xB7, 0x27, 0x58, 0x92, 0x13, 0x46, 0x67, 0x77, 0x65, 0x41, 0x73,
  // "Ŝ" (U+015C)
  0x73, 0x02, 0x80, 0x47, 0x06, 0x77, 0x50, 0xCF, 0xA0, 0x47, 0x73, 0x07, 0xFB, 0x0D, 0x77, 0x20,
  0x3F, 0xD0, 0x97, 0x70, 0x10, 0xDF, 0xE0, 0x57, 0x60, 0xAE, 0x0A, 0x05, 0xE0, 0xE0, 0x27, 0x40,
  0x7E, 0x0A, 0x20, 0x5E, 0x0D, 0x01, 0x72, 0x04, 0xE0, 0x94, 0x04, 0x0E, 0xD0, 0xB7, 0x10, 0x30,
  0xED, 0x07, 0x60, 0x30, 0xDD, 0x08, 0x70, 0xCC, 0x0E, 0x04, 0x71, 0x01, 0x0B, 0xD0, 0x28, 0x09,
  0xC0, 0x08, 0x73, 0x56, 0x77, 0x65, 0x42, 0x77, 0x28, 0x12, 0x7C, 0xFC, 0x82, 0xDA, 0x62, 0x72,
  0x01, 0x0A, 0xFF, 0xC0, 0xC0, 0x66, 0x05, 0x0E, 0xFF, 0xF0, 0xB4, 0x06, 0xFF, 0xFA, 0x06, 0x30,
  0x3F, 0xFF, 0xA0, 0xE4, 0x0C, 0xFF, 0xFA, 0x08, 0x30, 0x3F, 0xB8, 0x6E, 0xA7, 0x78, 0x9C, 0xEE,
  0x02, 0x30, 0x8F, 0xA0, 0x77, 0x18, 0x13, 0x8D, 0xA0, 0xB4, 0x0B, 0xF9, 0x08, 0x75, 0x81, 0x4A,
  0x54, 0x0D, 0xF9, 0x02, 0x77, 0x50, 0xEF, 0x0E, 0x77, 0x60, 0xEF, 0x97, 0x76, 0x0C, 0xF9, 0x02,
  0x77, 0x50, 0xAF, 0x90, 0xA7, 0x75, 0x05, 0xFA, 0x08, 0x77, 0x50, 0xEF, 0xA0, 0xC0, 0x37, 0x73,
  0x07, 0xFC, 0x0B, 0x03, 0x77, 0x20, 0xBF, 0xD0, 0xB0, 0x37, 0x70, 0x10, 0xDF, 0xE0, 0xB0, 0x37,
  0x60, 0x10, 0xCF, 0xF0, 0xA0, 0x27, 0x60, 0xAF, 0xF9, 0x08, 0x76, 0x05, 0x0E, 0xFF, 0x0D, 0x03,
  0x75, 0x01, 0x09, 0xFF, 0x90, 0x57, 0x60, 0x20, 0xBF, 0xF0, 0x57, 0x70, 0x30, 0xBF, 0xE0, 0x27,
  0x71, 0x03, 0x0B, 0xFC, 0x0B, 0x77, 0x30, 0x40, 0xCF, 0xB0, 0x27, 0x74, 0x0A, 0xFA, 0x06, 0x77,
  0x50, 0xBF, 0x90, 0x97, 0x75, 0x05, 0xF9, 0x0A, 0x77, 0x50, 0x3F, 0x90, 0xA7, 0x75, 0x04, 0xF9,
  0x81, 0x96, 0x27, 0x73, 0x07, 0xF9, 0x83, 0x7C, 0xFA, 0x47, 0x70, 0x10, 0xEF, 0x90, 0x40, 0xCB,
  0x82, 0xE9, 0x41, 0x72, 0x05, 0x0D, 0xF9, 0x81, 0xE0, 0xCF, 0x87, 0xDA, 0x98, 0x77, 0x8B, 0xEF,
  0xB8, 0x18, 0x0C, 0xFF, 0xFC, 0x82, 0xE1, 0x0C, 0xFF, 0xFC, 0x04, 0x20, 0xCF, 0xFF, 0xB0, 0x53,
  0x0C, 0xFF, 0xF9, 0x0D, 0x03, 0x48, 0x12, 0x8E, 0xFF, 0xC0, 0xD0, 0x77, 0x28, 0x23, 0x7B, 0xEF,
  0xC8, 0x1D, 0x94, 0x77, 0x18, 0x91, 0x13, 0x56, 0x77, 0x76, 0x53, 0x17, 0x40,
  // "ŝ" (U+015D)
  0x72, 0x02, 0x80, 0x47, 0x06, 0x77, 0x40, 0xCF, 0xA0, 0x47, 0x72, 0x07, 0xFB, 0x0D, 0x77, 0x10,
  0x3F, 0xD0, 0x97, 0x60, 0x10, 0xDF, 0xE0, 0x57, 0x50, 0xAE, 0x0A, 0x05, 0xE0, 0xE0, 0x27, 0x30,
  0x7E, 0x0A, 0x20, 0x5E, 0x0D, 0x01, 0x71, 0x04, 0xE0, 0x94, 0x04, 0x0E, 0xD0, 0xB7, 0x03, 0x0E,
  0xD0, 0x76, 0x03, 0x0D, 0xD0, 0x86, 0x0C, 0xC0, 0xE0, 0x47, 0x10, 0x10, 0xBD, 0x02, 0x80, 0x9B,
  0x40, 0x87, 0x34, 0x56, 0x76, 0x65, 0x37, 0x71, 0x81, 0x28, 0xBF, 0xC8, 0x2E, 0xA6, 0x37, 0x10,
  0x20, 0xAF, 0xFC, 0x81, 0xD8, 0x24, 0x04, 0x0E, 0xFF, 0xF0, 0xE3, 0x03, 0xFF, 0xFA, 0x08, 0x30,
  0xDF, 0xFF, 0xA0, 0x22, 0x05, 0xFF, 0xFA, 0x0A, 0x30, 0xAF, 0xA8, 0x6C, 0x87, 0x78, 0x9B, 0xDE,
  0x04, 0x30, 0xDF, 0x90, 0x47, 0x18, 0x41, 0x58, 0xDF, 0xD4, 0x0E, 0xF0, 0xE7, 0x60, 0x30, 0x44,
  0x0E, 0xF9, 0x02, 0x77, 0x40, 0xCF, 0x90, 0xD0, 0x37, 0x73, 0x09, 0xFB, 0x81, 0xC6, 0x17, 0x70,
  0x3F, 0xE0, 0xA0, 0x57, 0x60, 0x8F, 0xF8, 0x1E, 0x93, 0x74, 0x0A, 0xFF, 0xA0, 0xC0, 0x47, 0x30,
  0x7F, 0xFB, 0x0B, 0x02, 0x72, 0x02, 0x0A, 0xFF, 0xB0, 0x57, 0x38, 0x12, 0x9E, 0xFF, 0x90, 0x47,
  0x50, 0x60, 0xCF, 0xE0, 0xE0, 0x17, 0x68, 0x13, 0x9E, 0xFC, 0x08, 0x77, 0x20, 0x50, 0xCF, 0xA0,
  0xD7, 0x74, 0x07, 0xFA, 0x01, 0x77, 0x40, 0xDF, 0x98, 0x32, 0x3D, 0x72, 0x77, 0x0C, 0xF9, 0x02,
  0x03, 0xB8, 0x2C, 0x84, 0x17, 0x20, 0x5F, 0xA1, 0x03, 0xF8, 0x7D, 0xB9, 0x87, 0x78, 0x9D, 0xFA,
  0x81, 0xE0, 0x3F, 0xFF, 0xC8, 0x18, 0x03, 0xFF, 0xFC, 0x81, 0x20, 0x3F, 0xFF, 0xB0, 0x62, 0x03,
  0xFF, 0xFA, 0x06, 0x30, 0x20, 0xDF, 0xFE, 0x0B, 0x03, 0x68, 0x23, 0x7B, 0xEF, 0xE8, 0x1B, 0x72,
  0x75, 0x89, 0x21, 0x34, 0x66, 0x77, 0x76, 0x54, 0x17, 0x30,
  // "Ş" (U+015E)
  0x74, 0x87, 0x35, 0x67, 0x76, 0x54, 0x27, 0x72, 0x81, 0x27, 0xCF, 0xC8, 0x2D, 0xA6, 0x27, 0x20,
  0x10, 0xAF, 0xFC, 0x0C, 0x06, 0x60, 0x50, 0xEF, 0xFF, 0x0B, 0x40, 0x6F, 0xFF, 0xA0, 0x63, 0x03,
  0xFF, 0xFA, 0x0E, 0x40, 0xCF, 0xFF, 0xA0, 0x83, 0x03, 0xFB, 0x86, 0xEA, 0x77, 0x89, 0xCE, 0xE0,
  0x23, 0x08, 0xFA, 0x07, 0x71, 0x81, 0x38, 0xDA, 0x0B, 0x40, 0xBF, 0x90, 0x87, 0x58, 0x14, 0xA5,
  0x40, 0xDF, 0x90, 0x27, 0x75, 0x0E, 0xF0, 0xE7, 0x76, 0x0E, 0xF9, 0x77, 0x60, 0xCF, 0x90, 0x27,
  0x75, 0x0A, 0xF9, 0x0A, 0x77, 0x50, 0x5F, 0xA0, 0x87, 0x75, 0x0E, 0xFA, 0x0C, 0x03, 0x77, 0x30,
  0x7F, 0xC0, 0xB0, 0x37, 0x72, 0x0B, 0xFD, 0x0B, 0x03, 0x77, 0x01, 0x0D, 0xFE, 0x0B, 0x03, 0x76,
  0x01, 0x0C, 0xFF, 0x0A, 0x02, 0x76, 0x0A, 0xFF, 0x90, 0x87, 0x60, 0x50, 0xEF, 0xF0, 0xD0, 0x37,
  0x50, 0x10, 0x9F, 0xF9, 0x05, 0x76, 0x02, 0x0B, 0xFF, 0x05, 0x77, 0x03, 0x0B, 0xFE, 0x02, 0x77,
  0x10, 0x30, 0xBF, 0xC0, 0xB7, 0x73, 0x04, 0x0C, 0xFB, 0x02, 0x77, 0x40, 0xAF, 0xA0, 0x67, 0x75,
  0x0B, 0xF9, 0x09, 0x77, 0x50, 0x5F, 0x90, 0xA7, 0x75, 0x03, 0xF9, 0x0A, 0x77, 0x50, 0x4F, 0x98,
  0x19, 0x62, 0x77, 0x30, 0x7F, 0x98, 0x37, 0xCF, 0xA4, 0x77, 0x01, 0x0E, 0xF9, 0x04, 0x0C, 0xB8,
  0x2E, 0x94, 0x17, 0x20, 0x50, 0xDF, 0x98, 0x1E, 0x0C, 0xF8, 0x7D, 0xA9, 0x87, 0x78, 0xBE, 0xFB,
  0x81, 0x80, 0xCF, 0xFF, 0xC8, 0x2E, 0x10, 0xCF, 0xFF, 0xC0, 0x42, 0x0C, 0xFF, 0xFB, 0x05, 0x30,
  0xCF, 0xFF, 0x90, 0xD0, 0x34, 0x81, 0x28, 0xEF, 0xFC, 0x0D, 0x07, 0x72, 0x82, 0x37, 0xBE, 0xFC,
  0x81, 0xD9, 0x47, 0x71, 0x83, 0x13, 0x56, 0xEC, 0x05, 0x01, 0x77, 0x71, 0x0D, 0xB0, 0xB7, 0x77,
  0x20, 0x4D, 0x0A, 0x03, 0x77, 0x70, 0xBF, 0x08, 0x77, 0x60, 0xC0, 0xEF, 0x08, 0x77, 0x70, 0x40,
  0xCE, 0x01, 0x77, 0x71, 0x0E, 0xD0, 0x67, 0x77, 0x10, 0xBD, 0x07, 0x77, 0x71, 0x0E, 0xD0, 0x77,
  0x72, 0x05, 0x02, 0x20, 0x30, 0xBE, 0x05, 0x77, 0x10, 0x1F, 0xC0, 0xE7, 0x72, 0x01, 0xFC, 0x05,
  0x77, 0x20, 0x1F, 0xA0, 0xE0, 0x57, 0x74, 0x89, 0x09, 0xCE, 0xEF, 0xED, 0xA6, 0x17, 0x40,
  // "ş" (U+015F)
  0x73, 0x87, 0x34, 0x56, 0x76, 0x65, 0x37, 0x71, 0x81, 0x28, 0xBF, 0xC8, 0x2E, 0xA6, 0x37, 0x10,
  0x20, 0xAF, 0xFC, 0x81, 0xD8, 0x24, 0x04, 0x0E, 0xFF, 0xF0, 0xE3, 0x03, 0xFF, 0xFA, 0x08, 0x30,
  0xDF, 0xFF, 0xA0, 0x22, 0x05, 0xFF, 0xFA, 0x0A, 0x30, 0xAF, 0xA8, 0x6C, 0x87, 0x78, 0x9B, 0xDE,
  0x04, 0x30, 0xDF, 0x90, 0x47, 0x18, 0x41, 0x58, 0xDF, 0xD4, 0x0E, 0xF0, 0xE7, 0x60, 0x30, 0x44,
  0x0E, 0xF9, 0x02, 0x77, 0x40, 0xCF, 0x90, 0xD0, 0x37, 0x73, 0x09, 0xFB, 0x81, 0xC6, 0x17, 0x70,
  0x3F, 0xE0, 0xA0, 0x57, 0x60, 0x8F, 0xF8, 0x1E, 0x93, 0x74, 0x0A, 0xFF, 0xA0, 0xC0, 0x47, 0x30,
  0x7F, 0xFB, 0x0B, 0x02, 0x72, 0x02, 0x0A, 0xFF, 0xB0, 0x57, 0x38, 0x12, 0x9E, 0xFF, 0x90, 0x47,
  0x50, 0x60, 0xCF, 0xE0, 0xE0, 0x17, 0x68, 0x13, 0x9E, 0xFC, 0x08, 0x77, 0x20, 0x50, 0xCF, 0xA0,
  0xD7, 0x74, 0x07, 0xFA, 0x01, 0x77, 0x40, 0xDF, 0x98, 0x32, 0x3D, 0x72, 0x77, 0x0C, 0xF9, 0x02,
  0x03, 0xB8, 0x2C, 0x84, 0x17, 0x20, 0x5F, 0xA1, 0x03, 0xF8, 0x7D, 0xB9, 0x87, 0x78, 0x9D, 0xFA,
  0x81, 0xE0, 0x3F, 0xFF, 0xC8, 0x18, 0x03, 0xFF, 0xFC, 0x81, 0x20, 0x3F, 0xFF, 0xB0, 0x62, 0x03,
  0xFF, 0xFA, 0x06, 0x30, 0x20, 0xDF, 0xFE, 0x0B, 0x03, 0x68, 0x23, 0x7B, 0xEF, 0xE8, 0x1B, 0x72,
  0x75, 0x84, 0x13, 0x46, 0x6E, 0xC0, 0x50, 0x17, 0x77, 0x0D, 0xB0, 0xB7, 0x77, 0x10, 0x4D, 0x0A,
  0x03, 0x77, 0x60, 0xBF, 0x08, 0x77, 0x50, 0xC0, 0xEF, 0x08, 0x77, 0x60, 0x40, 0xCE, 0x01, 0x77,
  0x70, 0xED, 0x06, 0x77, 0x70, 0xBD, 0x07, 0x77, 0x70, 0xED, 0x07, 0x77, 0x10, 0x50, 0x22, 0x03,
  0x0B, 0xE0, 0x57, 0x70, 0x1F, 0xC0, 0xE7, 0x71, 0x01, 0xFC, 0x05, 0x77, 0x10, 0x1F, 0xA0, 0xE0,
  0x57, 0x73, 0x89, 0x09, 0xCE, 0xEF, 0xED, 0xA6, 0x17, 0x30,
  // "Š" (U+0160)
  0x48, 0x01, 0x70, 0x57, 0x30, 0x58, 0x01, 0x77, 0x0B, 0xD0, 0x97, 0x10, 0x9D, 0x0B, 0x71, 0x0C,
  0xD0, 0xC0, 0x14, 0x02, 0x0C, 0xD0, 0xD0, 0x17, 0x10, 0x10, 0xED, 0x0D, 0x02, 0x20, 0x30, 0xED,
  0x0E, 0x02, 0x73, 0x04, 0xE8, 0x2E, 0x23, 0xEE, 0x04, 0x75, 0x07, 0xE0, 0xD0, 0xEE, 0x08, 0x77,
  0x0B, 0xFD, 0x0B, 0x77, 0x10, 0x10, 0xEF, 0xB0, 0xE0, 0x17, 0x72, 0x05, 0xFB, 0x05, 0x77, 0x40,
  0xAF, 0x90, 0xA8, 0x09, 0xC7, 0x08, 0x73, 0x56, 0x77, 0x65, 0x42, 0x77, 0x28, 0x12, 0x7C, 0xFC,
  0x82, 0xDA, 0x62, 0x72, 0x01, 0x0A, 0xFF, 0xC0, 0xC0, 0x66, 0x05, 0x0E, 0xFF, 0xF0, 0xB4, 0x06,
  0xFF, 0xFA, 0x06, 0x30, 0x3F, 0xFF, 0xA0, 0xE4, 0x0C, 0xFF, 0xFA, 0x08, 0x30, 0x3F, 0xB8, 0x6E,
  0xA7, 0x78, 0x9C, 0xEE, 0x02, 0x30, 0x8F, 0xA0, 0x77, 0x18, 0x13, 0x8D, 0xA0, 0xB4, 0x0B, 0xF9,
  0x08, 0x75, 0x81, 0x4A, 0x54, 0x0D, 0xF9, 0x02, 0x77, 0x50, 0xEF, 0x0E, 0x77, 0x60, 0xEF, 0x97,
  0x76, 0x0C, 0xF9, 0x02, 0x77, 0x50, 0xAF, 0x90, 0xA7, 0x75, 0x05, 0xFA, 0x08, 0x77, 0x50, 0xEF,
  0xA0, 0xC0, 0x37, 0x73, 0x07, 0xFC, 0x0B, 0x03, 0x77, 0x20, 0xBF, 0xD0, 0xB0, 0x37, 0x70, 0x10,
  0xDF, 0xE0, 0xB0, 0x37, 0x60, 0x10, 0xCF, 0xF0, 0xA0, 0x27, 0x60, 0xAF, 0xF9, 0x08, 0x76, 0x05,
  0x0E, 0xFF, 0x0D, 0x03, 0x75, 0x01, 0x09, 0xFF, 0x90, 0x57, 0x60, 0x20, 0xBF, 0xF0, 0x57, 0x70,
  0x30, 0xBF, 0xE0, 0x27, 0x71, 0x03, 0x0B, 0xFC, 0x0B, 0x77, 0x30, 0x40, 0xCF, 0xB0, 0x27, 0x74,
  0x0A, 0xFA, 0x06, 0x77, 0x50, 0xBF, 0x90, 0x97, 0x75, 0x05, 0xF9, 0x0A, 0x77, 0x50, 0x3F, 0x90,
  0xA7, 0x75, 0x04, 0xF9, 0x81, 0x96, 0x27, 0x73, 0x07, 0xF9, 0x83, 0x7C, 0xFA, 0x47, 0x70, 0x10,
  0xEF, 0x90, 0x40, 0xCB, 0x82, 0xE9, 0x41, 0x72, 0x05, 0x0D, 0xF9, 0x81, 0xE0, 0xCF, 0x87, 0xDA,
  0x98, 0x77, 0x8B, 0xEF, 0xB8, 0x18, 0x0C, 0xFF, 0xFC, 0x82, 0xE1, 0x0C, 0xFF, 0xFC, 0x04, 0x20,
  0xCF, 0xFF, 0xB0, 0x53, 0x0C, 0xFF, 0xF9, 0x0D, 0x03, 0x48, 0x12, 0x8E, 0xFF, 0xC0, 0xD0, 0x77,
  0x28, 0x23, 0x7B, 0xEF, 0xC8, 0x1D, 0x94, 0x77, 0x18, 0x91, 0x13, 0x56, 0x77, 0x76, 0x53, 0x17,
  0x40,
  // "š" (U+0161)
  0x38, 0x01, 0x70, 0x57, 0x30, 0x58, 0x01, 0x76, 0x0B, 0xD0, 0x97, 0x10, 0x9D, 0x0B, 0x70, 0xCD,
  0x0C, 0x01, 0x40, 0x20, 0xCD, 0x0D, 0x01, 0x70, 0x10, 0xED, 0x0D, 0x02, 0x20, 0x30, 0xED, 0x0E,
  0x02, 0x72, 0x04, 0xE8, 0x2E, 0x23, 0xEE, 0x04, 0x74, 0x07, 0xE0, 0xD0, 0xEE, 0x08, 0x76, 0x0B,
  0xFD, 0x0B, 0x77, 0x01, 0x0E, 0xFB, 0x0E, 0x01, 0x77, 0x10, 0x5F, 0xB0, 0x57, 0x73, 0x0A, 0xF9,
  0x0A, 0x80, 0x9C, 0x30, 0x87, 0x34, 0x56, 0x76, 0x65, 0x37, 0x71, 0x81, 0x28, 0xBF, 0xC8, 0x2E,
  0xA6, 0x37, 0x10, 0x20, 0xAF, 0xFC, 0x81, 0xD8, 0x24, 0x04, 0x0E, 0xFF, 0xF0, 0xE3, 0x03, 0xFF,
  0xFA, 0x08, 0x30, 0xDF, 0xFF, 0xA0, 0x22, 0x05, 0xFF, 0xFA, 0x0A, 0x30, 0xAF, 0xA8, 0x6C, 0x87,
  0x78, 0x9B, 0xDE, 0x04, 0x30, 0xDF, 0x90, 0x47, 0x18, 0x41, 0x58, 0xDF, 0xD4, 0x0E, 0xF0, 0xE7,
  0x60, 0x30, 0x44, 0x0E, 0xF9, 0x02, 0x77, 0x40, 0xCF, 0x90, 0xD0, 0x37, 0x73, 0x09, 0xFB, 0x81,
  0xC6, 0x17, 0x70, 0x3F, 0xE0, 0xA0, 0x57, 0x60, 0x8F, 0xF8, 0x1E, 0x93, 0x74, 0x0A, 0xFF, 0xA0,
  0xC0, 0x47, 0x30, 0x7F, 0xFB, 0x0B, 0x02, 0x72, 0x02, 0x0A, 0xFF, 0xB0, 0x57, 0x38, 0x12, 0x9E,
  0xFF, 0x90, 0x47, 0x50, 0x60, 0xCF, 0xE0, 0xE0, 0x17, 0x68, 0x13, 0x9E, 0xFC, 0x08, 0x77, 0x20,
  0x50, 0xCF, 0xA0, 0xD7, 0x74, 0x07, 0xFA, 0x01, 0x77, 0x40, 0xDF, 0x98, 0x32, 0x3D, 0x72, 0x77,
  0x0C, 0xF9, 0x02, 0x03, 0xB8, 0x2C, 0x84, 0x17, 0x20, 0x5F, 0xA1, 0x03, 0xF8, 0x7D, 0xB9, 0x87,
  0x78, 0x9D, 0xFA, 0x81, 0xE0, 0x3F, 0xFF, 0xC8, 0x18, 0x03, 0xFF, 0xFC, 0x81, 0x20, 0x3F, 0xFF,
  0xB0, 0x62, 0x03, 0xFF, 0xFA, 0x06, 0x30, 0x20, 0xDF, 0xFE, 0x0B, 0x03, 0x68, 0x23, 0x7B, 0xEF,
  0xE8, 0x1B, 0x72, 0x75, 0x89, 0x21, 0x34, 0x66, 0x77, 0x76, 0x54, 0x17, 0x30,
  // "Ţ" (U+0162)
  0x03, 0xFF, 0xFF, 0xC0, 0x03, 0xFF, 0xFF, 0xC0, 0x03, 0xFF, 0xFF, 0xC0, 0x03, 0xFF, 0xFF, 0xC0,
  0x03, 0xFF, 0xFF, 0xC0, 0x03, 0xFF, 0xFF, 0xC0, 0x03, 0x80, 0x7E, 0xFB, 0x80, 0x7E, 0x03, 0x75,
  0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05,
  0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9,
  0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04,
  0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77,
  0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73,
  0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05,
  0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9,
  0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04,
  0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77,
  0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73,
  0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x75, 0x07,
  0xC0, 0x17, 0x77, 0x70, 0xDB, 0x0B, 0x77, 0x77, 0x04, 0xD0, 0xA0, 0x37, 0x77, 0x50, 0xBF, 0x08,
  0x77, 0x74, 0x0C, 0x0E, 0xF0, 0x87, 0x77, 0x50, 0x40, 0xCE, 0x01, 0x77, 0x76, 0x0E, 0xD0, 0x67,
  0x77, 0x60, 0xBD, 0x07, 0x77, 0x76, 0x0E, 0xD0, 0x77, 0x77, 0x05, 0x02, 0x20, 0x30, 0xBE, 0x05,
  0x77, 0x60, 0x1F, 0xC0, 0xE7, 0x77, 0x01, 0xFC, 0x05, 0x77, 0x70, 0x1F, 0xA0, 0xE0, 0x57, 0x77,
  0x28, 0x90, 0x9C, 0xEE, 0xFE, 0xDA, 0x61, 0x76,
  // "ţ" (U+0163)
  0x72, 0x02, 0x80, 0x27, 0x02, 0x77, 0x70, 0x6E, 0x05, 0x77, 0x70, 0x8E, 0x05, 0x77, 0x70, 0xBE,
  0x05, 0x77, 0x70, 0xEE, 0x05, 0x77, 0x60, 0x1F, 0x05, 0x77, 0x60, 0x3F, 0x05, 0x77, 0x60, 0x6F,
  0x05, 0x77, 0x60, 0x9F, 0x05, 0x77, 0x28, 0x22, 0x69, 0xDF, 0xFE, 0x83, 0xA3, 0x7B, 0xEF, 0xFF,
  0xB0, 0xA0, 0xCF, 0xFF, 0xE0, 0xA0, 0xCF, 0xFF, 0xE0, 0xA0, 0xCF, 0xFF, 0xE0, 0xA0, 0xCF, 0xFF,
  0xE0, 0xA0, 0xC8, 0x02, 0xEF, 0xB8, 0x07, 0xE0, 0xA7, 0x04, 0xF9, 0x05, 0x77, 0x50, 0x4F, 0x90,
  0x57, 0x75, 0x04, 0xF9, 0x05, 0x77, 0x50, 0x4F, 0x90, 0x57, 0x75, 0x04, 0xF9, 0x05, 0x77, 0x50,
  0x4F, 0x90, 0x57, 0x75, 0x04, 0xF9, 0x05, 0x77, 0x50, 0x4F, 0x90, 0x57, 0x75, 0x04, 0xF9, 0x05,
  0x77, 0x50, 0x4F, 0x90, 0x57, 0x75, 0x04, 0xF9, 0x05, 0x77, 0x50, 0x4F, 0x90, 0x57, 0x75, 0x04,
  0xF9, 0x05, 0x77, 0x50, 0x4F, 0x90, 0x67, 0x75, 0x04, 0xF9, 0x07, 0x77, 0x50, 0x3F, 0x90, 0xA7,
  0x75, 0x01, 0xFA, 0x02, 0x77, 0x50, 0xEF, 0x90, 0xD0, 0x37, 0x10, 0x10, 0x37, 0x10, 0xAF, 0xB8,
  0x6C, 0x97, 0x78, 0x9B, 0xEA, 0x71, 0x05, 0xFF, 0xE7, 0x20, 0xCF, 0xFD, 0x72, 0x03, 0xFF, 0xD7,
  0x30, 0x5F, 0xFC, 0x74, 0x02, 0x0C, 0xFF, 0xA7, 0x68, 0x14, 0xAE, 0xFB, 0x81, 0xDA, 0x57, 0x72,
  0x09, 0xC8, 0x38, 0x65, 0x31, 0x77, 0x50, 0xDB, 0x0B, 0x77, 0x72, 0x04, 0xD0, 0xA0, 0x37, 0x77,
  0x0B, 0xF0, 0x87, 0x76, 0x0C, 0x0E, 0xF0, 0x87, 0x77, 0x04, 0x0C, 0xE0, 0x17, 0x77, 0x10, 0xED,
  0x06, 0x77, 0x71, 0x0B, 0xD0, 0x77, 0x77, 0x10, 0xED, 0x07, 0x77, 0x20, 0x50, 0x22, 0x03, 0x0B,
  0xE0, 0x57, 0x71, 0x01, 0xFC, 0x0E, 0x77, 0x20, 0x1F, 0xC0, 0x57, 0x72, 0x01, 0xFA, 0x0E, 0x05,
  0x77, 0x48, 0x90, 0x9C, 0xEE, 0xFE, 0xDA, 0x61, 0x60,
  // "Ť" (U+0164)
  0x68, 0x01, 0x70, 0x57, 0x30, 0x58, 0x01, 0x77, 0x50, 0xBD, 0x09, 0x71, 0x09, 0xD0, 0xB7, 0x60,
  0xCD, 0x0C, 0x01, 0x40, 0x20, 0xCD, 0x0D, 0x01, 0x76, 0x01, 0x0E, 0xD0, 0xD0, 0x22, 0x03, 0x0E,
  0xD0, 0xE0, 0x27, 0x71, 0x04, 0xE8, 0x2E, 0x23, 0xEE, 0x04, 0x77, 0x30, 0x7E, 0x0D, 0x0E, 0xE0,
  0x87, 0x75, 0x0B, 0xFD, 0x0B, 0x77, 0x60, 0x10, 0xEF, 0xB0, 0xE0, 0x17, 0x77, 0x05, 0xFB, 0x05,
  0x77, 0x72, 0x0A, 0xF9, 0x0A, 0x80, 0xAA, 0x00, 0x03, 0xFF, 0xFF, 0xC0, 0x03, 0xFF, 0xFF, 0xC0,
  0x03, 0xFF, 0xFF, 0xC0, 0x03, 0xFF, 0xFF, 0xC0, 0x03, 0xFF, 0xFF, 0xC0, 0x03, 0xFF, 0xFF, 0xC0,
  0x03, 0x80, 0x7E, 0xFB, 0x80, 0x7E, 0x03, 0x75, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04,
  0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77,
  0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73,
  0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05,
  0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9,
  0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04,
  0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77,
  0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73,
  0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05,
  0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9,
  0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04,
  0x77, 0x73, 0x05, 0xF9, 0x04, 0x75,
  // "ť" (U+0165)
  0x77, 0x72, 0x0A, 0xF0, 0x57, 0x77, 0x20, 0xCE, 0x0E, 0x77, 0x73, 0xF0, 0x87, 0x77, 0x20, 0x2F,
  0x01, 0x77, 0x72, 0x05, 0xE0, 0x97, 0x40, 0x18, 0x02, 0x60, 0x25, 0x08, 0xE0, 0x27, 0x40, 0x5E,
  0x05, 0x50, 0xCD, 0x09, 0x75, 0x08, 0xE0, 0x55, 0xD0, 0xE0, 0x17, 0x50, 0xBE, 0x05, 0x40, 0x3D,
  0x07, 0x76, 0x0D, 0xE0, 0x54, 0x06, 0xC0, 0xD7, 0x60, 0x1F, 0x05, 0x77, 0x72, 0x03, 0xF0, 0x57,
  0x77, 0x20, 0x6F, 0x05, 0x77, 0x72, 0x09, 0xF0, 0x57, 0x75, 0x82, 0x26, 0x9D, 0xFF, 0xE0, 0xA3,
  0x82, 0x37, 0xBE, 0xFF, 0xFB, 0x0A, 0x30, 0xCF, 0xFF, 0xE0, 0xA3, 0x0C, 0xFF, 0xFE, 0x0A, 0x30,
  0xCF, 0xFF, 0xE0, 0xA3, 0x0C, 0xFF, 0xFE, 0x0A, 0x30, 0xC8, 0x02, 0xEF, 0xB8, 0x07, 0xE0, 0xA7,
  0x30, 0x4F, 0x90, 0x57, 0x77, 0x10, 0x4F, 0x90, 0x57, 0x77, 0x10, 0x4F, 0x90, 0x57, 0x77, 0x10,
  0x4F, 0x90, 0x57, 0x77, 0x10, 0x4F, 0x90, 0x57, 0x77, 0x10, 0x4F, 0x90, 0x57, 0x77, 0x10, 0x4F,
  0x90, 0x57, 0x77, 0x10, 0x4F, 0x90, 0x57, 0x77, 0x10, 0x4F, 0x90, 0x57, 0x77, 0x10, 0x4F, 0x90,
  0x57, 0x77, 0x10, 0x4F, 0x90, 0x57, 0x77, 0x10, 0x4F, 0x90, 0x57, 0x77, 0x10, 0x4F, 0x90, 0x57,
  0x77, 0x10, 0x4F, 0x90, 0x67, 0x77, 0x10, 0x4F, 0x90, 0x77, 0x77, 0x10, 0x3F, 0x90, 0xA7, 0x77,
  0x10, 0x1F, 0xA0, 0x27, 0x77, 0x10, 0xEF, 0x90, 0xD0, 0x37, 0x10, 0x10, 0x37, 0x40, 0xAF, 0xB8,
  0x6C, 0x97, 0x78, 0x9B, 0xEA, 0x74, 0x05, 0xFF, 0xE7, 0x50, 0xCF, 0xFD, 0x75, 0x03, 0xFF, 0xD7,
  0x60, 0x5F, 0xFC, 0x77, 0x02, 0x0C, 0xFF, 0xA7, 0x72, 0x81, 0x4A, 0xEF, 0xB8, 0x1D, 0xA5, 0x77,
  0x58, 0x90, 0x24, 0x66, 0x77, 0x65, 0x31, 0x60,
  // "Ŧ" (U+0166)
  0x03, 0xFF, 0xFF, 0xC0, 0x03, 0xFF, 0xFF, 0xC0, 0x03, 0xFF, 0xFF, 0xC0, 0x03, 0xFF, 0xFF, 0xC0,
  0x03, 0xFF, 0xFF, 0xC0, 0x03, 0xFF, 0xFF, 0xC0, 0x03, 0x80, 0x7E, 0xFB, 0x80, 0x7E, 0x03, 0x75,
  0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05,
  0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9,
  0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04,
  0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x30, 0xB8, 0x02, 0xEF, 0xB8, 0x02, 0xE0, 0xB7, 0x30, 0xBF,
  0xFF, 0x90, 0xB7, 0x30, 0xBF, 0xFF, 0x90, 0xB7, 0x30, 0xBF, 0xFF, 0x90, 0xB7, 0x30, 0xBF, 0xFF,
  0x90, 0xB7, 0x30, 0xBF, 0xFF, 0x90, 0xB7, 0x30, 0xBF, 0xFF, 0x90, 0xB7, 0x73, 0x05, 0xF9, 0x04,
  0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77,
  0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73,
  0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05,
  0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9,
  0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04, 0x77, 0x73, 0x05, 0xF9, 0x04,
  0x75,
  // "ŧ" (U+0167)
  0x72, 0x02, 0x80, 0x27, 0x02, 0x77, 0x70, 0x6E, 0x05, 0x77, 0x70, 0x8E, 0x05, 0x77, 0x70, 0xBE,
  0x05, 0x77, 0x70, 0xEE, 0x05, 0x77, 0x60, 0x1F, 0x05, 0x77, 0x60, 0x3F, 0x05, 0x77, 0x60, 0x6F,
  0x05, 0x77, 0x60, 0x9F, 0x05, 0x77, 0x28, 0x22, 0x69, 0xDF, 0xFE, 0x83, 0xA3, 0x7B, 0xEF, 0xFF,
  0xB0, 0xA0, 0xCF, 0xFF, 0xE0, 0xA0, 0xCF, 0xFF, 0xE0, 0xA0, 0xCF, 0xFF, 0xE0, 0xA0, 0xCF, 0xFF,
  0xE0, 0xA0, 0xC8, 0x02, 0xEF, 0xB8, 0x07, 0xE0, 0xA7, 0x04, 0xF9, 0x05, 0x77, 0x50, 0x4F, 0x90,
  0x57, 0x75, 0x04, 0xF9, 0x05, 0x77, 0x50, 0x4F, 0x90, 0x57, 0x50, 0xCF, 0xFF, 0xF0, 0xCF, 0xFF,
  0xF0, 0xCF, 0xFF, 0xF0, 0xCF, 0xFF, 0xF0, 0xCF, 0xFF, 0xF0, 0xCF, 0xFF, 0xF7, 0x04, 0xF9, 0x05,
  0x77, 0x50, 0x4F, 0x90, 0x57, 0x75, 0x04, 0xF9, 0x05, 0x77, 0x50, 0x4F, 0x90, 0x67, 0x75, 0x03,
  0xF9, 0x07, 0x77, 0x50, 0x2F, 0x90, 0xB7, 0x75, 0x01, 0xFA, 0x03, 0x77, 0x50, 0xDF, 0x90, 0xE0,
  0x47, 0x10, 0x10, 0x47, 0x10, 0x9F, 0xB8, 0x6D, 0x97, 0x78, 0xAC, 0xEA, 0x71, 0x04, 0xFF, 0xE7,
  0x20, 0xBF, 0xFD, 0x72, 0x02, 0x0E, 0xFF, 0xC7, 0x30, 0x40, 0xEF, 0xFB, 0x74, 0x02, 0x0B, 0xFF,
  0xA7, 0x68, 0x13, 0x9E, 0xFB, 0x81, 0xDA, 0x57, 0x72, 0x89, 0x01, 0x46, 0x67, 0x76, 0x53, 0x13,
  // "Ũ" (U+0168)
  0x71, 0x85, 0x4B, 0xEE, 0xD9, 0x37, 0x01, 0xC0, 0x57, 0x40, 0x9F, 0x0C, 0x04, 0x50, 0x6C, 0x03,
  0x73, 0x06, 0xFB, 0x84, 0xC6, 0x20, 0x3E, 0xC0, 0x17, 0x30, 0xEF, 0xFD, 0x0D, 0x73, 0x06, 0xFF,
  0xE0, 0x87, 0x30, 0xCF, 0xFE, 0x01, 0x73, 0xC8, 0x4D, 0x30, 0x27, 0xDF, 0xB0, 0x67, 0x30, 0x3C,
  0x05, 0x50, 0x50, 0xCF, 0x08, 0x74, 0x05, 0xC7, 0x18, 0x54, 0x9D, 0xEE, 0xA4, 0x80, 0xA8, 0x40,
  0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06,
  0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9,
  0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90,
  0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F,
  0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9,
  0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06,
  0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F,
  0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50,
  0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04,
  0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75,
  0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00,
  0x4F, 0x90, 0x67, 0x50, 0x7F, 0x90, 0x40, 0x3F, 0x90, 0x77, 0x50, 0x7F, 0x90, 0x30, 0x2F, 0x90,
  0x97, 0x50, 0x9F, 0x90, 0x20, 0x1F, 0x90, 0xC7, 0x50, 0xCF, 0x98, 0x11, 0x0E, 0xF9, 0x01, 0x73,
  0x01, 0xF9, 0x0D, 0x20, 0xAF, 0x90, 0x67, 0x30, 0x6F, 0x90, 0x92, 0x06, 0xF9, 0x0E, 0x02, 0x71,
  0x01, 0x0E, 0xF9, 0x06, 0x20, 0x1F, 0xA0, 0xD0, 0x46, 0x03, 0x0D, 0xF9, 0x0E, 0x40, 0x9F, 0xB8,
  0x4D, 0x97, 0x79, 0xCF, 0xB0, 0x74, 0x02, 0x0E, 0xFF, 0xFB, 0x0D, 0x01, 0x50, 0x5F, 0xFF, 0xB0,
  0x37, 0x07, 0xFF, 0xF9, 0x06, 0x72, 0x05, 0x0E, 0xFF, 0xC0, 0xE0, 0x47, 0x40, 0x20, 0xAF, 0xFA,
  0x09, 0x01, 0x77, 0x81, 0x28, 0xCF, 0xB8, 0x1C, 0x81, 0x77, 0x68, 0x63, 0x56, 0x77, 0x65, 0x37,
  0x50,
  // "ũ" (U+0169)
  0x78, 0x54, 0xBE, 0xED, 0x93, 0x70, 0x1C, 0x05, 0x72, 0x09, 0xF0, 0xC0, 0x45, 0x06, 0xC0, 0x37,
  0x10, 0x6F, 0xB8, 0x4C, 0x62, 0x03, 0xEC, 0x01, 0x71, 0x0E, 0xFF, 0xD0, 0xD7, 0x10, 0x6F, 0xFE,
  0x08, 0x71, 0x0C, 0xFF, 0xE0, 0x17, 0x1C, 0x84, 0xD3, 0x02, 0x7D, 0xFB, 0x06, 0x71, 0x03, 0xC0,
  0x55, 0x05, 0x0C, 0xF0, 0x87, 0x20, 0x5C, 0x71, 0x85, 0x49, 0xDE, 0xEA, 0x48, 0x09, 0xF3, 0x0F,
  0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90,
  0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7,
  0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F,
  0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90,
  0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF,
  0x90, 0xA7, 0x40, 0x1F, 0x90, 0xAF, 0x90, 0xA7, 0x40, 0x1F, 0x90, 0xAF, 0x90, 0xA7, 0x40, 0x3F,
  0x90, 0xAF, 0x90, 0xB7, 0x40, 0x6F, 0x90, 0xAF, 0x90, 0xC7, 0x40, 0x8F, 0x90, 0xA0, 0xEF, 0x97,
  0x40, 0xDF, 0x90, 0xA0, 0xDF, 0x90, 0x47, 0x20, 0x4F, 0xA0, 0xA0, 0xCF, 0x90, 0xB7, 0x10, 0x10,
  0xDF, 0xA0, 0xA0, 0x9F, 0xA0, 0x86, 0x03, 0x0C, 0xFB, 0x0A, 0x05, 0xFB, 0x84, 0xD9, 0x77, 0x8C,
  0xFD, 0x81, 0xA0, 0xEF, 0xFF, 0xE8, 0x1A, 0x07, 0xFF, 0xD0, 0xEF, 0x0A, 0x20, 0xCF, 0xFB, 0x0A,
  0x02, 0xF0, 0xA2, 0x02, 0x0D, 0xFF, 0x90, 0xB2, 0x0C, 0xE0, 0xA3, 0x01, 0x0B, 0xFD, 0x0E, 0x07,
  0x30, 0x6E, 0x0A, 0x50, 0x40, 0xBF, 0x98, 0x1D, 0x81, 0x40, 0x1E, 0x0A, 0x71, 0x85, 0x45, 0x77,
  0x64, 0x17, 0x71,
  // "Ū" (U+016A)
  0x60, 0x1F, 0xFC, 0x01, 0x75, 0x01, 0xFF, 0xC0, 0x17, 0x50, 0x1F, 0xFC, 0x01, 0x75, 0x01, 0xFF,
  0xC0, 0x17, 0x50, 0x1F, 0xFC, 0x01, 0x75, 0x01, 0xFF, 0xC0, 0x18, 0x0A, 0xC2, 0x00, 0x4F, 0x90,
  0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F,
  0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9,
  0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06,
  0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F,
  0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50,
  0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04,
  0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75,
  0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00,
  0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67,
  0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90,
  0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06,
  0x75, 0x07, 0xF9, 0x04, 0x03, 0xF9, 0x07, 0x75, 0x07, 0xF9, 0x03, 0x02, 0xF9, 0x09, 0x75, 0x09,
  0xF9, 0x02, 0x01, 0xF9, 0x0C, 0x75, 0x0C, 0xF9, 0x81, 0x10, 0xEF, 0x90, 0x17, 0x30, 0x1F, 0x90,
  0xD2, 0x0A, 0xF9, 0x06, 0x73, 0x06, 0xF9, 0x09, 0x20, 0x6F, 0x90, 0xE0, 0x27, 0x10, 0x10, 0xEF,
  0x90, 0x62, 0x01, 0xFA, 0x0D, 0x04, 0x60, 0x30, 0xDF, 0x90, 0xE4, 0x09, 0xFB, 0x84, 0xD9, 0x77,
  0x9C, 0xFB, 0x07, 0x40, 0x20, 0xEF, 0xFF, 0xB0, 0xD0, 0x15, 0x05, 0xFF, 0xFB, 0x03, 0x70, 0x7F,
  0xFF, 0x90, 0x67, 0x20, 0x50, 0xEF, 0xFC, 0x0E, 0x04, 0x74, 0x02, 0x0A, 0xFF, 0xA0, 0x90, 0x17,
  0x78, 0x12, 0x8C, 0xFB, 0x81, 0xC8, 0x17, 0x76, 0x86, 0x35, 0x67, 0x76, 0x53, 0x75,
  // "ū" (U+016B)
  0x50, 0x1F, 0xFC, 0x01, 0x73, 0x01, 0xFF, 0xC0, 0x17, 0x30, 0x1F, 0xFC, 0x01, 0x73, 0x01, 0xFF,
  0xC0, 0x17, 0x30, 0x1F, 0xFC, 0x01, 0x73, 0x01, 0xFF, 0xC0, 0x18, 0x0A, 0xA7, 0x0F, 0x90, 0xA7,
  0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F,
  0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90,
  0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF,
  0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90,
  0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7,
  0x40, 0x1F, 0x90, 0xAF, 0x90, 0xA7, 0x40, 0x1F, 0x90, 0xAF, 0x90, 0xA7, 0x40, 0x3F, 0x90, 0xAF,
  0x90, 0xB7, 0x40, 0x6F, 0x90, 0xAF, 0x90, 0xC7, 0x40, 0x8F, 0x90, 0xA0, 0xEF, 0x97, 0x40, 0xDF,
  0x90, 0xA0, 0xDF, 0x90, 0x47, 0x20, 0x4F, 0xA0, 0xA0, 0xCF, 0x90, 0xB7, 0x10, 0x10, 0xDF, 0xA0,
  0xA0, 0x9F, 0xA0, 0x86, 0x03, 0x0C, 0xFB, 0x0A, 0x05, 0xFB, 0x84, 0xD9, 0x77, 0x8C, 0xFD, 0x81,
  0xA0, 0xEF, 0xFF, 0xE8, 0x1A, 0x07, 0xFF, 0xD0, 0xEF, 0x0A, 0x20, 0xCF, 0xFB, 0x0A, 0x02, 0xF0,
  0xA2, 0x02, 0x0D, 0xFF, 0x90, 0xB2, 0x0C, 0xE0, 0xA3, 0x01, 0x0B, 0xFD, 0x0E, 0x07, 0x30, 0x6E,
  0x0A, 0x50, 0x40, 0xBF, 0x98, 0x1D, 0x81, 0x40, 0x1E, 0x0A, 0x71, 0x85, 0x45, 0x77, 0x64, 0x17,
  0x71,
  // "Ŭ" (U+016C)
  0x68, 0x46, 0x77, 0x77, 0x17, 0x28, 0x45, 0x77, 0x77, 0x17, 0x40, 0xCC, 0x04, 0x72, 0x0E, 0xC0,
  0x27, 0x40, 0xAC, 0x0C, 0x71, 0x07, 0xD7, 0x50, 0x6D, 0x86, 0xD7, 0x21, 0x02, 0x5B, 0xD0, 0xB7,
  0x50, 0x1F, 0xFC, 0x05, 0x76, 0x09, 0xFF, 0xA0, 0xC7, 0x70, 0x10, 0xDF, 0xF0, 0xE0, 0x27, 0x71,
  0x02, 0x0D, 0xFD, 0x0E, 0x03, 0x77, 0x40, 0x9F, 0xB0, 0xA0, 0x17, 0x76, 0x89, 0x01, 0x7B, 0xDE,
  0xFD, 0xB7, 0x28, 0x0A, 0x87, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75,
  0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00,
  0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67,
  0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90,
  0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06,
  0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9,
  0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90,
  0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F,
  0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9,
  0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06,
  0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F,
  0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x07, 0xF9, 0x04, 0x03, 0xF9, 0x07, 0x75,
  0x07, 0xF9, 0x03, 0x02, 0xF9, 0x09, 0x75, 0x09, 0xF9, 0x02, 0x01, 0xF9, 0x0C, 0x75, 0x0C, 0xF9,
  0x81, 0x10, 0xEF, 0x90, 0x17, 0x30, 0x1F, 0x90, 0xD2, 0x0A, 0xF9, 0x06, 0x73, 0x06, 0xF9, 0x09,
  0x20, 0x6F, 0x90, 0xE0, 0x27, 0x10, 0x10, 0xEF, 0x90, 0x62, 0x01, 0xFA, 0x0D, 0x04, 0x60, 0x30,
  0xDF, 0x90, 0xE4, 0x09, 0xFB, 0x84, 0xD9, 0x77, 0x9C, 0xFB, 0x07, 0x40, 0x20, 0xEF, 0xFF, 0xB0,
  0xD0, 0x15, 0x05, 0xFF, 0xFB, 0x03, 0x70, 0x7F, 0xFF, 0x90, 0x67, 0x20, 0x50, 0xEF, 0xFC, 0x0E,
  0x04, 0x74, 0x02, 0x0A, 0xFF, 0xA0, 0x90, 0x17, 0x78, 0x12, 0x8C, 0xFB, 0x81, 0xC8, 0x17, 0x76,
  0x86, 0x35, 0x67, 0x76, 0x53, 0x75,
  // "ŭ" (U+016D)
  0x58, 0x46, 0x77, 0x77, 0x17, 0x28, 0x45, 0x77, 0x77, 0x17, 0x20, 0xCC, 0x04, 0x72, 0x0E, 0xC0,
  0x27, 0x20, 0xAC, 0x0C, 0x71, 0x07, 0xD7, 0x30, 0x6D, 0x86, 0xD7, 0x21, 0x02, 0x5B, 0xD0, 0xB7,
  0x30, 0x1F, 0xFC, 0x05, 0x74, 0x09, 0xFF, 0xA0, 0xC7, 0x50, 0x10, 0xDF, 0xF0, 0xE0, 0x27, 0x60,
  0x20, 0xDF, 0xD0, 0xE0, 0x37, 0x72, 0x09, 0xFB, 0x0A, 0x01, 0x77, 0x48, 0x90, 0x17, 0xBD, 0xEF,
  0xDB, 0x72, 0x80, 0x9F, 0x60, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9,
  0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A,
  0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75,
  0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9,
  0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A,
  0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x74, 0x01, 0xF9, 0x0A, 0xF9, 0x0A, 0x74, 0x01, 0xF9,
  0x0A, 0xF9, 0x0A, 0x74, 0x03, 0xF9, 0x0A, 0xF9, 0x0B, 0x74, 0x06, 0xF9, 0x0A, 0xF9, 0x0C, 0x74,
  0x08, 0xF9, 0x0A, 0x0E, 0xF9, 0x74, 0x0D, 0xF9, 0x0A, 0x0D, 0xF9, 0x04, 0x72, 0x04, 0xFA, 0x0A,
  0x0C, 0xF9, 0x0B, 0x71, 0x01, 0x0D, 0xFA, 0x0A, 0x09, 0xFA, 0x08, 0x60, 0x30, 0xCF, 0xB0, 0xA0,
  0x5F, 0xB8, 0x4D, 0x97, 0x78, 0xCF, 0xD8, 0x1A, 0x0E, 0xFF, 0xFE, 0x81, 0xA0, 0x7F, 0xFD, 0x0E,
  0xF0, 0xA2, 0x0C, 0xFF, 0xB0, 0xA0, 0x2F, 0x0A, 0x20, 0x20, 0xDF, 0xF9, 0x0B, 0x20, 0xCE, 0x0A,
  0x30, 0x10, 0xBF, 0xD0, 0xE0, 0x73, 0x06, 0xE0, 0xA5, 0x04, 0x0B, 0xF9, 0x81, 0xD8, 0x14, 0x01,
  0xE0, 0xA7, 0x18, 0x54, 0x57, 0x76, 0x41, 0x77, 0x10,
  // "Ů" (U+016E)
  0x75, 0x86, 0x4A, 0xDF, 0xEC, 0x82, 0x77, 0x72, 0x0A, 0xF9, 0x07, 0x77, 0x70, 0xBF, 0xB0, 0x87,
  0x75, 0x06, 0xFD, 0x04, 0x77, 0x40, 0xCC, 0x82, 0x61, 0x18, 0xC0, 0xB7, 0x73, 0x01, 0xC0, 0x74,
  0x0A, 0xC7, 0x73, 0x02, 0xC0, 0x34, 0x05, 0xC0, 0x17, 0x72, 0x02, 0xC0, 0x34, 0x05, 0xC0, 0x17,
  0x72, 0x01, 0xC0, 0x74, 0x0A, 0xB0, 0xE7, 0x74, 0x0C, 0xB8, 0x3E, 0x51, 0x18, 0xC0, 0xB7, 0x74,
  0x06, 0xFD, 0x04, 0x77, 0x50, 0xBF, 0xB0, 0x87, 0x77, 0x0A, 0xF9, 0x08, 0x77, 0x72, 0x86, 0x4A,
  0xDF, 0xED, 0x92, 0x80, 0xA9, 0x00, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67,
  0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90,
  0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06,
  0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9,
  0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90,
  0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F,
  0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9,
  0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06,
  0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F,
  0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50,
  0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04,
  0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x7F, 0x90, 0x40, 0x3F, 0x90, 0x77,
  0x50, 0x7F, 0x90, 0x30, 0x2F, 0x90, 0x97, 0x50, 0x9F, 0x90, 0x20, 0x1F, 0x90, 0xC7, 0x50, 0xCF,
  0x98, 0x11, 0x0E, 0xF9, 0x01, 0x73, 0x01, 0xF9, 0x0D, 0x20, 0xAF, 0x90, 0x67, 0x30, 0x6F, 0x90,
  0x92, 0x06, 0xF9, 0x0E, 0x02, 0x71, 0x01, 0x0E, 0xF9, 0x06, 0x20, 0x1F, 0xA0, 0xD0, 0x46, 0x03,
  0x0D, 0xF9, 0x0E, 0x40, 0x9F, 0xB8, 0x4D, 0x97, 0x79, 0xCF, 0xB0, 0x74, 0x02, 0x0E, 0xFF, 0xFB,
  0x0D, 0x01, 0x50, 0x5F, 0xFF, 0xB0, 0x37, 0x07, 0xFF, 0xF9, 0x06, 0x72, 0x05, 0x0E, 0xFF, 0xC0,
  0xE0, 0x47, 0x40, 0x20, 0xAF, 0xFA, 0x09, 0x01, 0x77, 0x81, 0x28, 0xCF, 0xB8, 0x1C, 0x81, 0x77,
  0x68, 0x63, 0x56, 0x77, 0x65, 0x37, 0x50,
  // "ů" (U+016F)
  0x74, 0x86, 0x4A, 0xDF, 0xEC, 0x82, 0x77, 0x70, 0xAF, 0x90, 0x77, 0x75, 0x0B, 0xFB, 0x08, 0x77,
  0x30, 0x6F, 0xD0, 0x47, 0x72, 0x0C, 0xC8, 0x26, 0x11, 0x8C, 0x0B, 0x77, 0x10, 0x1C, 0x07, 0x40,
  0xAC, 0x77, 0x10, 0x2C, 0x03, 0x40, 0x5C, 0x01, 0x77, 0x02, 0xC0, 0x34, 0x05, 0xC0, 0x17, 0x70,
  0x1C, 0x07, 0x40, 0xAB, 0x0E, 0x77, 0x20, 0xCB, 0x83, 0xE5, 0x11, 0x8C, 0x0B, 0x77, 0x20, 0x6F,
  0xD0, 0x47, 0x73, 0x0B, 0xFB, 0x08, 0x77, 0x50, 0xAF, 0x90, 0x87, 0x77, 0x86, 0x4A, 0xDF, 0xED,
  0x92, 0x80, 0x9F, 0x70, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A,
  0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75,
  0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9,
  0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A,
  0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9,
  0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x74, 0x01, 0xF9, 0x0A, 0xF9, 0x0A, 0x74, 0x01, 0xF9, 0x0A,
  0xF9, 0x0A, 0x74, 0x03, 0xF9, 0x0A, 0xF9, 0x0B, 0x74, 0x06, 0xF9, 0x0A, 0xF9, 0x0C, 0x74, 0x08,
  0xF9, 0x0A, 0x0E, 0xF9, 0x74, 0x0D, 0xF9, 0x0A, 0x0D, 0xF9, 0x04, 0x72, 0x04, 0xFA, 0x0A, 0x0C,
  0xF9, 0x0B, 0x71, 0x01, 0x0D, 0xFA, 0x0A, 0x09, 0xFA, 0x08, 0x60, 0x30, 0xCF, 0xB0, 0xA0, 0x5F,
  0xB8, 0x4D, 0x97, 0x78, 0xCF, 0xD8, 0x1A, 0x0E, 0xFF, 0xFE, 0x81, 0xA0, 0x7F, 0xFD, 0x0E, 0xF0,
  0xA2, 0x0C, 0xFF, 0xB0, 0xA0, 0x2F, 0x0A, 0x20, 0x20, 0xDF, 0xF9, 0x0B, 0x20, 0xCE, 0x0A, 0x30,
  0x10, 0xBF, 0xD0, 0xE0, 0x73, 0x06, 0xE0, 0xA5, 0x04, 0x0B, 0xF9, 0x81, 0xD8, 0x14, 0x01, 0xE0,
  0xA7, 0x18, 0x54, 0x57, 0x76, 0x41, 0x77, 0x10,
  // "Ű" (U+0170)
  0x72, 0x03, 0xF9, 0x20, 0x8F, 0x0B, 0x75, 0x0B, 0xF8, 0x27, 0x01, 0xEF, 0x03, 0x74, 0x04, 0xF0,
  0xB2, 0x08, 0xF0, 0x77, 0x50, 0xCE, 0x82, 0xD1, 0x01, 0xF0, 0xA7, 0x50, 0x6E, 0x0D, 0x01, 0x20,
  0xAE, 0x0B, 0x76, 0x0E, 0xD0, 0xE0, 0x22, 0x03, 0xE0, 0xB7, 0x60, 0x8D, 0x0E, 0x02, 0x30, 0xCD,
  0x0B, 0x76, 0x02, 0xD0, 0xD0, 0x23, 0x06, 0xD0, 0xB7, 0x70, 0xAC, 0x0C, 0x01, 0x40, 0xEC, 0x0A,
  0x77, 0x01, 0xC0, 0xA5, 0x05, 0xC0, 0x88, 0x0A, 0x87, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90,
  0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06,
  0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9,
  0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90,
  0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F,
  0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9,
  0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06,
  0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F,
  0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50,
  0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04,
  0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75,
  0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x07, 0xF9, 0x04,
  0x03, 0xF9, 0x07, 0x75, 0x07, 0xF9, 0x03, 0x02, 0xF9, 0x09, 0x75, 0x09, 0xF9, 0x02, 0x01, 0xF9,
  0x0C, 0x75, 0x0C, 0xF9, 0x81, 0x10, 0xEF, 0x90, 0x17, 0x30, 0x1F, 0x90, 0xD2, 0x0A, 0xF9, 0x06,
  0x73, 0x06, 0xF9, 0x09, 0x20, 0x6F, 0x90, 0xE0, 0x27, 0x10, 0x10, 0xEF, 0x90, 0x62, 0x01, 0xFA,
  0x0D, 0x04, 0x60, 0x30, 0xDF, 0x90, 0xE4, 0x09, 0xFB, 0x84, 0xD9, 0x77, 0x9C, 0xFB, 0x07, 0x40,
  0x20, 0xEF, 0xFF, 0xB0, 0xD0, 0x15, 0x05, 0xFF, 0xFB, 0x03, 0x70, 0x7F, 0xFF, 0x90, 0x67, 0x20,
  0x50, 0xEF, 0xFC, 0x0E, 0x04, 0x74, 0x02, 0x0A, 0xFF, 0xA0, 0x90, 0x17, 0x78, 0x12, 0x8C, 0xFB,
  0x81, 0xC8, 0x17, 0x76, 0x86, 0x35, 0x67, 0x76, 0x53, 0x75,
  // "ű" (U+0171)
  0x71, 0x03, 0xF9, 0x20, 0x8F, 0x0B, 0x73, 0x0B, 0xF8, 0x27, 0x01, 0xEF, 0x03, 0x72, 0x04, 0xF0,
  0xB2, 0x08, 0xF0, 0x77, 0x30, 0xCE, 0x82, 0xD1, 0x01, 0xF0, 0xA7, 0x30, 0x6E, 0x0D, 0x01, 0x20,
  0xAE, 0x0B, 0x74, 0x0E, 0xD0, 0xE0, 0x22, 0x03, 0xE0, 0xB7, 0x40, 0x8D, 0x0E, 0x02, 0x30, 0xCD,
  0x0B, 0x74, 0x02, 0xD0, 0xD0, 0x23, 0x06, 0xD0, 0xB7, 0x50, 0xAC, 0x0C, 0x01, 0x40, 0xEC, 0x0A,
  0x75, 0x01, 0xC0, 0xA5, 0x05, 0xC0, 0x88, 0x09, 0xF6, 0x0F, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90,
  0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7,
  0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F,
  0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90,
  0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF,
  0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x5F, 0x90, 0xAF, 0x90, 0xA7, 0x40, 0x1F, 0x90, 0xAF,
  0x90, 0xA7, 0x40, 0x1F, 0x90, 0xAF, 0x90, 0xA7, 0x40, 0x3F, 0x90, 0xAF, 0x90, 0xB7, 0x40, 0x6F,
  0x90, 0xAF, 0x90, 0xC7, 0x40, 0x8F, 0x90, 0xA0, 0xEF, 0x97, 0x40, 0xDF, 0x90, 0xA0, 0xDF, 0x90,
  0x47, 0x20, 0x4F, 0xA0, 0xA0, 0xCF, 0x90, 0xB7, 0x10, 0x10, 0xDF, 0xA0, 0xA0, 0x9F, 0xA0, 0x86,
  0x03, 0x0C, 0xFB, 0x0A, 0x05, 0xFB, 0x84, 0xD9, 0x77, 0x8C, 0xFD, 0x81, 0xA0, 0xEF, 0xFF, 0xE8,
  0x1A, 0x07, 0xFF, 0xD0, 0xEF, 0x0A, 0x20, 0xCF, 0xFB, 0x0A, 0x02, 0xF0, 0xA2, 0x02, 0x0D, 0xFF,
  0x90, 0xB2, 0x0C, 0xE0, 0xA3, 0x01, 0x0B, 0xFD, 0x0E, 0x07, 0x30, 0x6E, 0x0A, 0x50, 0x40, 0xBF,
  0x98, 0x1D, 0x81, 0x40, 0x1E, 0x0A, 0x71, 0x85, 0x45, 0x77, 0x64, 0x17, 0x71,
  // "Ų" (U+0172)
  0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06,
  0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9,
  0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90,
  0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F,
  0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9,
  0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06,
  0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F,
  0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50,
  0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04,
  0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75,
  0x06, 0xF9, 0x00, 0x4F, 0x90, 0x67, 0x50, 0x6F, 0x90, 0x04, 0xF9, 0x06, 0x75, 0x06, 0xF9, 0x00,
  0x4F, 0x90, 0x67, 0x50, 0x7F, 0x90, 0x40, 0x3F, 0x90, 0x77, 0x50, 0x7F, 0x90, 0x40, 0x2F, 0x90,
  0x97, 0x50, 0x9F, 0x90, 0x30, 0x1F, 0x90, 0xC7, 0x50, 0xCF, 0x98, 0x11, 0x0E, 0xF9, 0x01, 0x73,
  0x01, 0xF9, 0x0E, 0x20, 0xBF, 0x90, 0x67, 0x30, 0x6F, 0x90, 0xB2, 0x07, 0xF9, 0x0E, 0x02, 0x71,
  0x01, 0x0E, 0xF9, 0x07, 0x20, 0x2F, 0xA0, 0xD0, 0x46, 0x03, 0x0D, 0xFA, 0x02, 0x30, 0xAF, 0xB8,
  0x4D, 0x97, 0x79, 0xCF, 0xB0, 0xA4, 0x03, 0xFF, 0xFD, 0x02, 0x50, 0x7F, 0xFF, 0xB0, 0x77, 0x0B,
  0xFF, 0xF9, 0x09, 0x72, 0x09, 0xFF, 0xE0, 0x87, 0x40, 0x50, 0xDF, 0xFA, 0x0D, 0x04, 0x77, 0x81,
  0x5A, 0xEF, 0xC0, 0xE0, 0x77, 0x75, 0x82, 0x35, 0x69, 0xE0, 0xB0, 0x27, 0x77, 0x10, 0x40, 0xED,
  0x07, 0x77, 0x72, 0x03, 0xE0, 0x57, 0x77, 0x30, 0xDD, 0x05, 0x77, 0x73, 0x06, 0xD0, 0x97, 0x77,
  0x40, 0xCD, 0x02, 0x77, 0x74, 0xE7, 0x77, 0x40, 0x1E, 0x02, 0x77, 0x73, 0x01, 0xE8, 0x3B, 0x20,
  0x15, 0x77, 0x70, 0xEF, 0xB0, 0x17, 0x76, 0x08, 0xFB, 0x01, 0x77, 0x60, 0x10, 0xDF, 0xA0, 0x17,
  0x77, 0x02, 0x0C, 0xF9, 0x01, 0x77, 0x72, 0x86, 0x5A, 0xDF, 0xED, 0xB8, 0x73,
  // "ų" (U+0173)
  0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9,
  0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A,
  0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75,
  0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9,
  0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A,
  0xF9, 0x0A, 0x74, 0x01, 0xF9, 0x0A, 0xF9, 0x0A, 0x74, 0x01, 0xF9, 0x0A, 0xF9, 0x0A, 0x74, 0x03,
  0xF9, 0x0A, 0xF9, 0x0B, 0x74, 0x06, 0xF9, 0x0A, 0xF9, 0x0C, 0x74, 0x08, 0xF9, 0x0A, 0x0E, 0xF9,
  0x74, 0x0D, 0xF9, 0x0A, 0x0D, 0xF9, 0x04, 0x72, 0x04, 0xFA, 0x0A, 0x0C, 0xF9, 0x0B, 0x71, 0x01,
  0x0D, 0xFA, 0x0A, 0x09, 0xFA, 0x08, 0x60, 0x30, 0xCF, 0xB0, 0xA0, 0x5F, 0xB8, 0x4D, 0x97, 0x78,
  0xCF, 0xD8, 0x1A, 0x0E, 0xFF, 0xFE, 0x81, 0xA0, 0x7F, 0xFD, 0x0E, 0xF0, 0xA2, 0x0C, 0xFF, 0xB0,
  0xA0, 0x2F, 0x0A, 0x20, 0x20, 0xDF, 0xF9, 0x0B, 0x20, 0xCE, 0x0A, 0x30, 0x10, 0xBF, 0xD0, 0xE0,
  0x73, 0x06, 0xE0, 0xA5, 0x04, 0x0B, 0xF9, 0x81, 0xD8, 0x14, 0x01, 0xE0, 0xA7, 0x18, 0x54, 0x57,
  0x76, 0x41, 0x70, 0x30, 0xEC, 0x03, 0x77, 0x71, 0x04, 0xD0, 0x57, 0x77, 0x10, 0x3D, 0x07, 0x77,
  0x72, 0x0D, 0xC0, 0xC7, 0x77, 0x20, 0x7D, 0x04, 0x77, 0x72, 0x0D, 0xD7, 0x77, 0x20, 0x2D, 0x0D,
  0x77, 0x72, 0x03, 0xE7, 0x77, 0x20, 0x3E, 0x83, 0xA1, 0x02, 0x57, 0x75, 0xFC, 0x77, 0x50, 0xAF,
  0xB7, 0x75, 0x02, 0x0E, 0xFA, 0x77, 0x60, 0x30, 0xEF, 0x97, 0x77, 0x18, 0x16, 0xBE, 0xA8, 0x1D,
  0xB7,
  // "Ŵ" (U+0174)
  0x76, 0x02, 0x80, 0x47, 0x06, 0x77, 0x75, 0x0C, 0xFA, 0x04, 0x77, 0x73, 0x07, 0xFB, 0x0D, 0x77,
  0x72, 0x03, 0xFD, 0x09, 0x77, 0x70, 0x10, 0xDF, 0xE0, 0x57, 0x76, 0x0A, 0xE0, 0xA0, 0x5E, 0x0E,
  0x02, 0x77, 0x40, 0x7E, 0x0A, 0x20, 0x5E, 0x0D, 0x01, 0x77, 0x20, 0x4E, 0x09, 0x40, 0x40, 0xED,
  0x0B, 0x77, 0x10, 0x30, 0xED, 0x07, 0x60, 0x30, 0xDD, 0x08, 0x77, 0x0C, 0xC0, 0xE0, 0x47, 0x10,
  0x10, 0xBD, 0x02, 0x80, 0xAA, 0x20, 0x05, 0xF0, 0x37, 0x74, 0x03, 0xF0, 0x50, 0x4F, 0x04, 0x77,
  0x40, 0x4F, 0x04, 0x03, 0xF0, 0x67, 0x74, 0x05, 0xF0, 0x30, 0x2F, 0x07, 0x77, 0x40, 0x6F, 0x02,
  0x01, 0xF0, 0x97, 0x74, 0x07, 0xF0, 0x11, 0xF0, 0xA7, 0x74, 0x08, 0xF2, 0x0E, 0xE0, 0xC7, 0x74,
  0x0A, 0xE0, 0xE2, 0x0D, 0xE0, 0xD7, 0x74, 0x0B, 0xE0, 0xD2, 0x0B, 0xF7, 0x74, 0x0C, 0xE0, 0xC2,
  0x0A, 0xF0, 0x17, 0x73, 0x0D, 0xE0, 0xB2, 0x09, 0xF0, 0x23, 0x02, 0xF9, 0x04, 0x40, 0xEE, 0x0A,
  0x20, 0x8F, 0x03, 0x30, 0x4F, 0x90, 0x64, 0xF0, 0x92, 0x07, 0xF0, 0x53, 0x07, 0xF9, 0x09, 0x30,
  0x1F, 0x07, 0x20, 0x5F, 0x06, 0x30, 0x9F, 0x90, 0xB3, 0x02, 0xF0, 0x62, 0x04, 0xF0, 0x73, 0x0C,
  0xF9, 0x0D, 0x30, 0x3F, 0x05, 0x20, 0x3F, 0x08, 0x30, 0xEF, 0xA3, 0x04, 0xF0, 0x42, 0x02, 0xF0,
  0x92, 0x01, 0xFB, 0x03, 0x20, 0x5F, 0x03, 0x20, 0x1F, 0x0A, 0x20, 0x4F, 0xB0, 0x52, 0x06, 0xF0,
  0x23, 0xF0, 0xB2, 0x06, 0xD0, 0xEC, 0x07, 0x20, 0x7F, 0x01, 0x30, 0xEE, 0x0B, 0x20, 0x9C, 0x0C,
  0x0A, 0xC0, 0xA2, 0x08, 0xF4, 0x0D, 0xE0, 0xC2, 0x0B, 0xC0, 0xA0, 0x8C, 0x0C, 0x20, 0x9E, 0x0E,
  0x40, 0xCE, 0x0D, 0x20, 0xEC, 0x08, 0x06, 0xC0, 0xE2, 0x0A, 0xE0, 0xD4, 0x0A, 0xE8, 0x1D, 0x01,
  0xD0, 0x60, 0x4D, 0x81, 0x10, 0xAE, 0x0C, 0x40, 0x9E, 0x81, 0xD0, 0x3D, 0x04, 0x02, 0xD8, 0x14,
  0x0B, 0xE0, 0xB4, 0x08, 0xE8, 0x1D, 0x05, 0xD0, 0x21, 0xD8, 0x16, 0x0B, 0xE0, 0xA4, 0x07, 0xE8,
  0x1D, 0x07, 0xD2, 0x0D, 0xC8, 0x19, 0x0B, 0xE0, 0x94, 0x06, 0xE8, 0x1E, 0x0A, 0xC0, 0xC2, 0x0B,
  0xC8, 0x1B, 0x0A, 0xE0, 0x74, 0x05, 0xE8, 0x1E, 0x0C, 0xC0, 0xA2, 0x09, 0xC8, 0x1E, 0x0A, 0xE0,
  0x64, 0x03, 0xE8, 0x1E, 0x0E, 0xC0, 0x72, 0x07, 0xD0, 0x10, 0xAE, 0x05, 0x40, 0x2E, 0x0E, 0x01,
  0xD0, 0x52, 0x04, 0xD0, 0x40, 0x9E, 0x04, 0x40, 0x1E, 0x0E, 0x03, 0xD0, 0x32, 0x02, 0xD0, 0x60,
  0x9E, 0x03, 0x5E, 0x0D, 0x05, 0xD4, 0xD0, 0x90, 0x8E, 0x02, 0x50, 0xED, 0x0D, 0x07, 0xC0, 0xD4,
  0x0D, 0xC0, 0xB0, 0x8E, 0x01, 0x50, 0xDD, 0x0D, 0x09, 0xC0, 0xB4, 0x0A, 0xC0, 0xE0, 0x7E, 0x60,
  0xCD, 0x0C, 0x0B, 0xC0, 0x94, 0x08, 0xD0, 0x8D, 0x0E, 0x60, 0xBF, 0xC0, 0x64, 0x06, 0xFC, 0x0D,
  0x60, 0x9F, 0xC0, 0x44, 0x03, 0xFC, 0x0C, 0x60, 0x8F, 0xC0, 0x24, 0x01, 0xFC, 0x0B, 0x60, 0x7F,
  0xC6, 0x0E, 0xFB, 0x0A, 0x60, 0x6F, 0xB0, 0xC6, 0x0C, 0xFB, 0x09, 0x60, 0x5F, 0xB0, 0xA6, 0x09,
  0xFB, 0x07, 0x60, 0x4F, 0xB0, 0x86, 0x07, 0xFB, 0x06, 0x30,
  // "ŵ" (U+0175)
  0x76, 0x02, 0x80, 0x47, 0x06, 0x77, 0x75, 0x0C, 0xFA, 0x04, 0x77, 0x73, 0x07, 0xFB, 0x0D, 0x77,
  0x72, 0x03, 0xFD, 0x09, 0x77, 0x70, 0x10, 0xDF, 0xE0, 0x57, 0x76, 0x0A, 0xE0, 0xA0, 0x5E, 0x0E,
  0x02, 0x77, 0x40, 0x7E, 0x0A, 0x20, 0x5E, 0x0D, 0x01, 0x77, 0x20, 0x4E, 0x09, 0x40, 0x40, 0xED,
  0x0B, 0x77, 0x10, 0x30, 0xED, 0x07, 0x60, 0x30, 0xDD, 0x08, 0x77, 0x0C, 0xC0, 0xE0, 0x47, 0x10,
  0x10, 0xBD, 0x02, 0x80, 0xAA, 0x20, 0x0B, 0xF0, 0x27, 0x75, 0xF0, 0xC0, 0x9F, 0x03, 0x77, 0x40,
  0x1F, 0x0A, 0x07, 0xF0, 0x47, 0x74, 0x02, 0xF0, 0x70, 0x4F, 0x06, 0x77, 0x40, 0x3F, 0x05, 0x02,
  0xF0, 0x75, 0x0B, 0xE0, 0xD5, 0x05, 0xF0, 0x31, 0xF0, 0x95, 0x0E, 0xF0, 0x14, 0x06, 0xF8, 0x11,
  0x0D, 0xE0, 0xA4, 0x02, 0xF9, 0x04, 0x40, 0x8E, 0x0E, 0x20, 0xBE, 0x0C, 0x40, 0x5F, 0x90, 0x74,
  0x09, 0xE0, 0xC2, 0x09, 0xE0, 0xD4, 0x08, 0xF9, 0x0A, 0x40, 0xAE, 0x0A, 0x20, 0x6E, 0x0E, 0x40,
  0xBF, 0x90, 0xD4, 0x0C, 0xE0, 0x72, 0x04, 0xF4, 0x0E, 0xFA, 0x01, 0x30, 0xDE, 0x05, 0x20, 0x2F,
  0x02, 0x20, 0x2F, 0xB0, 0x43, 0xF0, 0x33, 0xF0, 0x32, 0x05, 0xFB, 0x07, 0x20, 0x1F, 0x01, 0x30,
  0xDE, 0x05, 0x20, 0x8C, 0x00, 0xDC, 0x0A, 0x20, 0x2E, 0x0E, 0x40, 0xBE, 0x06, 0x20, 0xBC, 0x00,
  0xBC, 0x0D, 0x20, 0x4E, 0x0C, 0x40, 0x9E, 0x07, 0x20, 0xEC, 0x00, 0x8D, 0x81, 0x10, 0x5E, 0x09,
  0x40, 0x6E, 0x81, 0x90, 0x2D, 0x00, 0x6D, 0x81, 0x40, 0x6E, 0x07, 0x40, 0x4E, 0x81, 0xA0, 0x5D,
  0x00, 0x3D, 0x81, 0x70, 0x7E, 0x05, 0x40, 0x2E, 0x81, 0xC0, 0x7D, 0x00, 0x1D, 0x81, 0x90, 0x9E,
  0x03, 0x5E, 0x81, 0xD0, 0xAC, 0x0E, 0x20, 0xEC, 0x81, 0xC0, 0xAE, 0x01, 0x50, 0xDE, 0x10, 0xCC,
  0x0B, 0x20, 0xBC, 0x81, 0xE0, 0xBD, 0x0E, 0x60, 0xBE, 0x01, 0x0E, 0xC0, 0x82, 0x08, 0xD0, 0x10,
  0xCD, 0x0C, 0x60, 0x8E, 0x04, 0xD0, 0x52, 0x05, 0xD0, 0x40, 0xED, 0x09, 0x60, 0x6E, 0x07, 0xD0,
  0x22, 0x02, 0xD0, 0x7E, 0x07, 0x60, 0x4E, 0x0C, 0xC0, 0xE4, 0xD0, 0xCE, 0x05, 0x60, 0x2F, 0xC0,
  0xC4, 0x0C, 0xFC, 0x03, 0x7F, 0xC0, 0x94, 0x09, 0xFC, 0x71, 0x0D, 0xFB, 0x06, 0x40, 0x7F, 0xB0,
  0xE7, 0x10, 0xBF, 0xB0, 0x34, 0x04, 0xFB, 0x0B, 0x71, 0x08, 0xFB, 0x50, 0x1F, 0xB0, 0x97, 0x10,
  0x6F, 0xA0, 0xD6, 0x0E, 0xFA, 0x07, 0x71, 0x04, 0xFA, 0x0A, 0x60, 0xBF, 0xA0, 0x54,
  // "Ŷ" (U+0176)
  0x75, 0x02, 0x80, 0x47, 0x06, 0x77, 0x73, 0x0C, 0xFA, 0x04, 0x77, 0x71, 0x07, 0xFB, 0x0D, 0x77,
  0x70, 0x3F, 0xD0, 0x97, 0x75, 0x01, 0x0D, 0xFE, 0x05, 0x77, 0x40, 0xAE, 0x0A, 0x05, 0xE0, 0xE0,
  0x27, 0x72, 0x07, 0xE0, 0xA2, 0x05, 0xE0, 0xD0, 0x17, 0x70, 0x4E, 0x09, 0x40, 0x40, 0xED, 0x0B,
  0x76, 0x03, 0x0E, 0xD0, 0x76, 0x03, 0x0D, 0xD0, 0x87, 0x50, 0xCC, 0x0E, 0x04, 0x71, 0x01, 0x0B,
  0xD0, 0x28, 0x0A, 0x91, 0x00, 0x8F, 0x90, 0x97, 0x70, 0x8F, 0x90, 0x80, 0x1F, 0x90, 0xE7, 0x70,
  0xEF, 0x98, 0x11, 0x09, 0xF9, 0x06, 0x75, 0x05, 0xF9, 0x09, 0x20, 0x1F, 0x90, 0xD7, 0x50, 0xCF,
  0x90, 0x23, 0x09, 0xF9, 0x04, 0x73, 0x03, 0xF9, 0x09, 0x40, 0x2F, 0x90, 0xB7, 0x30, 0xAF, 0x90,
  0x25, 0x0A, 0xF9, 0x02, 0x71, 0x01, 0xF9, 0x0A, 0x60, 0x2F, 0x90, 0x97, 0x10, 0x7F, 0x90, 0x27,
  0x0A, 0xF0, 0xE7, 0x10, 0xDF, 0x0A, 0x71, 0x03, 0xF9, 0x06, 0x60, 0x5F, 0x90, 0x37, 0x20, 0xBF,
  0x0D, 0x60, 0xBF, 0x0B, 0x73, 0x03, 0xF9, 0x04, 0x40, 0x3F, 0x90, 0x47, 0x40, 0xBF, 0x0B, 0x40,
  0x9F, 0x0C, 0x75, 0x04, 0xF9, 0x02, 0x20, 0x1F, 0x90, 0x47, 0x60, 0xCF, 0x08, 0x20, 0x7F, 0x0C,
  0x77, 0x04, 0xF0, 0xE2, 0x0D, 0xF0, 0x57, 0x71, 0x0C, 0xF0, 0x60, 0x4F, 0x0D, 0x77, 0x20, 0x5F,
  0x0D, 0x0B, 0xF0, 0x57, 0x73, 0x0D, 0xFF, 0x0D, 0x77, 0x40, 0x5F, 0xF0, 0x67, 0x75, 0x0D, 0xFD,
  0x0D, 0x77, 0x60, 0x6F, 0xD0, 0x67, 0x77, 0x0D, 0xFB, 0x0E, 0x77, 0x71, 0x06, 0xFB, 0x07, 0x77,
  0x72, 0x0E, 0xF9, 0x0E, 0x77, 0x73, 0x07, 0xF9, 0x08, 0x77, 0x73, 0x04, 0xF9, 0x05, 0x77, 0x73,
  0x04, 0xF9, 0x05, 0x77, 0x73, 0x04, 0xF9, 0x05, 0x77, 0x73, 0x04, 0xF9, 0x05, 0x77, 0x73, 0x04,
  0xF9, 0x05, 0x77, 0x73, 0x04, 0xF9, 0x05, 0x77, 0x73, 0x04, 0xF9, 0x05, 0x77, 0x73, 0x04, 0xF9,
  0x05, 0x77, 0x73, 0x04, 0xF9, 0x05, 0x77, 0x73, 0x04, 0xF9, 0x05, 0x77, 0x73, 0x04, 0xF9, 0x05,
  0x77, 0x73, 0x04, 0xF9, 0x05, 0x77, 0x73, 0x04, 0xF9, 0x05, 0x77, 0x73, 0x04, 0xF9, 0x05, 0x77,
  0x73, 0x04, 0xF9, 0x05, 0x77, 0x73, 0x04, 0xF9, 0x05, 0x75,
  // "ŷ" (U+0177)
  0x75, 0x02, 0x80, 0x47, 0x06, 0x77, 0x73, 0x0C, 0xFA, 0x04, 0x77, 0x71, 0x07, 0xFB, 0x0D, 0x77,
  0x70, 0x3F, 0xD0, 0x97, 0x75, 0x01, 0x0D, 0xFE, 0x05, 0x77, 0x40, 0xAE, 0x0A, 0x05, 0xE0, 0xE0,
  0x27, 0x72, 0x07, 0xE0, 0xA2, 0x05, 0xE0, 0xD0, 0x17, 0x70, 0x4E, 0x09, 0x40, 0x40, 0xED, 0x0B,
  0x76, 0x03, 0x0E, 0xD0, 0x76, 0x03, 0x0D, 0xD0, 0x87, 0x50, 0xCC, 0x0E, 0x04, 0x71, 0x01, 0x0B,
  0xD0, 0x28, 0x0A, 0x91, 0x00, 0x9F, 0x90, 0xD7, 0x70, 0xBF, 0x90, 0x90, 0x3F, 0xA0, 0x37, 0x6F,
  0xA8, 0x13, 0x0C, 0xF9, 0x08, 0x75, 0x04, 0xF9, 0x0D, 0x20, 0x5F, 0x90, 0xD7, 0x50, 0x9F, 0x90,
  0x73, 0x0E, 0xF9, 0x03, 0x74, 0x0E, 0xF9, 0x01, 0x30, 0x8F, 0x90, 0x87, 0x30, 0x3F, 0x90, 0xB4,
  0x02, 0xF9, 0x0D, 0x73, 0x08, 0xF9, 0x05, 0x50, 0xBF, 0x90, 0x37, 0x20, 0xCF, 0x0E, 0x60, 0x5F,
  0x90, 0x97, 0x10, 0x2F, 0x90, 0x97, 0x0E, 0xF0, 0xE7, 0x10, 0x6F, 0x90, 0x37, 0x08, 0xF9, 0x04,
  0x70, 0xBF, 0x0D, 0x71, 0x02, 0xF9, 0x09, 0x7F, 0x90, 0x77, 0x20, 0xBF, 0x0E, 0x60, 0x5F, 0x90,
  0x17, 0x20, 0x5F, 0x90, 0x45, 0x09, 0xF0, 0xB7, 0x40, 0xEF, 0x09, 0x50, 0xEF, 0x05, 0x74, 0x08,
  0xF0, 0xE4, 0x03, 0xF0, 0xE7, 0x50, 0x2F, 0x90, 0x43, 0x08, 0xF0, 0x97, 0x60, 0xBF, 0x0A, 0x30,
  0xDF, 0x03, 0x76, 0x04, 0xF0, 0xE2, 0x02, 0xF0, 0xD7, 0x71, 0x0D, 0xF8, 0x14, 0x06, 0xF0, 0x77,
  0x71, 0x07, 0xF8, 0x18, 0x0B, 0xF0, 0x17, 0x71, 0x01, 0xF8, 0x1C, 0x0E, 0xE0, 0xB7, 0x73, 0x0A,
  0xF0, 0x3F, 0x05, 0x77, 0x30, 0x4F, 0x09, 0xE0, 0xE7, 0x75, 0x0D, 0xFE, 0x09, 0x77, 0x50, 0x7F,
  0xE0, 0x37, 0x75, 0x01, 0xFD, 0x0D, 0x77, 0x70, 0xAF, 0xC0, 0x77, 0x77, 0x04, 0xFC, 0x01, 0x77,
  0x71, 0x0D, 0xFA, 0x0B, 0x77, 0x72, 0x07, 0xFA, 0x05, 0x77, 0x72, 0x01, 0xF9, 0x0E, 0x77, 0x73,
  0x01, 0xF9, 0x09, 0x77, 0x73, 0x07, 0xF9, 0x03, 0x77, 0x73, 0x0D, 0xF0, 0xC7, 0x77, 0x30, 0x6F,
  0x90, 0x67, 0x77, 0x20, 0x10, 0xEF, 0x0E, 0x77, 0x72, 0x01, 0x0C, 0xF9, 0x06, 0x77, 0x20, 0x10,
  0x23, 0x81, 0x27, 0xEF, 0x90, 0xD7, 0x73, 0x07, 0xFF, 0x90, 0x47, 0x73, 0x07, 0xFF, 0x09, 0x77,
  0x40, 0x7F, 0xE0, 0xC7, 0x75, 0x07, 0xFD, 0x0C, 0x01, 0x77, 0x50, 0x7F, 0xC0, 0xA7, 0x77, 0x07,
  0xFA, 0x0C, 0x05, 0x77, 0x71, 0x89, 0x04, 0xBD, 0xEF, 0xED, 0xC8, 0x47, 0x77, 0x10,
  // "Ÿ" (U+0178)
  0x78, 0x43, 0xBE, 0xFC, 0x57, 0x18, 0x43, 0xBE, 0xFC, 0x67, 0x60, 0x4E, 0x08, 0x60, 0x4E, 0x09,
  0x75, 0x0D, 0xF0, 0x25, 0x0D, 0xF0, 0x27, 0x30, 0x1F, 0x90, 0x64, 0x01, 0xF9, 0x06, 0x73, 0x02,
  0xF9, 0x07, 0x40, 0x2F, 0x90, 0x77, 0x30, 0x1F, 0x90, 0x54, 0x01, 0xF9, 0x06, 0x74, 0x0C, 0xF0,
  0x15, 0x0C, 0xF0, 0x27, 0x40, 0x4E, 0x07, 0x60, 0x3E, 0x08, 0x76, 0x84, 0x3B, 0xEF, 0xC5, 0x71,
  0x84, 0x3B, 0xEF, 0xC5, 0x80, 0xA9, 0x30, 0x08, 0xF9, 0x09, 0x77, 0x08, 0xF9, 0x08, 0x01, 0xF9,
  0x0E, 0x77, 0x0E, 0xF9, 0x81, 0x10, 0x9F, 0x90, 0x67, 0x50, 0x5F, 0x90, 0x92, 0x01, 0xF9, 0x0D,
  0x75, 0x0C, 0xF9, 0x02, 0x30, 0x9F, 0x90, 0x47, 0x30, 0x3F, 0x90, 0x94, 0x02, 0xF9, 0x0B, 0x73,
  0x0A, 0xF9, 0x02, 0x50, 0xAF, 0x90, 0x27, 0x10, 0x1F, 0x90, 0xA6, 0x02, 0xF9, 0x09, 0x71, 0x07,
  0xF9, 0x02, 0x70, 0xAF, 0x0E, 0x71, 0x0D, 0xF0, 0xA7, 0x10, 0x3F, 0x90, 0x66, 0x05, 0xF9, 0x03,
  0x72, 0x0B, 0xF0, 0xD6, 0x0B, 0xF0, 0xB7, 0x30, 0x3F, 0x90, 0x44, 0x03, 0xF9, 0x04, 0x74, 0x0B,
  0xF0, 0xB4, 0x09, 0xF0, 0xC7, 0x50, 0x4F, 0x90, 0x22, 0x01, 0xF9, 0x04, 0x76, 0x0C, 0xF0, 0x82,
  0x07, 0xF0, 0xC7, 0x70, 0x4F, 0x0E, 0x20, 0xDF, 0x05, 0x77, 0x10, 0xCF, 0x06, 0x04, 0xF0, 0xD7,
  0x72, 0x05, 0xF0, 0xD0, 0xBF, 0x05, 0x77, 0x30, 0xDF, 0xF0, 0xD7, 0x74, 0x05, 0xFF, 0x06, 0x77,
  0x50, 0xDF, 0xD0, 0xD7, 0x76, 0x06, 0xFD, 0x06, 0x77, 0x70, 0xDF, 0xB0, 0xE7, 0x77, 0x10, 0x6F,
  0xB0, 0x77, 0x77, 0x20, 0xEF, 0x90, 0xE7, 0x77, 0x30, 0x7F, 0x90, 0x87, 0x77, 0x30, 0x4F, 0x90,
  0x57, 0x77, 0x30, 0x4F, 0x90, 0x57, 0x77, 0x30, 0x4F, 0x90, 0x57, 0x77, 0x30, 0x4F, 0x90, 0x57,
  0x77, 0x30, 0x4F, 0x90, 0x57, 0x77, 0x30, 0x4F, 0x90, 0x57, 0x77, 0x30, 0x4F, 0x90, 0x57, 0x77,
  0x30, 0x4F, 0x90, 0x57, 0x77, 0x30, 0x4F, 0x90, 0x57, 0x77, 0x30, 0x4F, 0x90, 0x57, 0x77, 0x30,
  0x4F, 0x90, 0x57, 0x77, 0x30, 0x4F, 0x90, 0x57, 0x77, 0x30, 0x4F, 0x90, 0x57, 0x77, 0x30, 0x4F,
  0x90, 0x57, 0x77, 0x30, 0x4F, 0x90, 0x57, 0x77, 0x30, 0x4F, 0x90, 0x57, 0x50,
  // "Ź" (U+0179)
  0x77, 0x20, 0x68, 0x04, 0x70, 0x67, 0x73, 0x04, 0xFA, 0x05, 0x77, 0x30, 0xDF, 0x90, 0x67, 0x73,
  0x08, 0xF9, 0x06, 0x77, 0x30, 0x3F, 0x90, 0x57, 0x74, 0x0D, 0xF0, 0x47, 0x74, 0x09, 0xE0, 0xE0,
  0x47, 0x74, 0x05, 0xE0, 0xE0, 0x37, 0x74, 0x02, 0x0E, 0xD0, 0xC0, 0x17, 0x75, 0x09, 0xD0, 0xA8,
  0x09, 0xF1, 0x00, 0xAF, 0xFF, 0xB0, 0xA2, 0x0A, 0xFF, 0xFB, 0x0A, 0x20, 0xAF, 0xFF, 0xB0, 0xA2,
  0x0A, 0xFF, 0xFB, 0x0A, 0x20, 0xAF, 0xFF, 0xB0, 0xA2, 0x0A, 0xFF, 0xFB, 0x09, 0x20, 0xA8, 0x09,
  0x3E, 0xFA, 0x02, 0x77, 0x30, 0x5F, 0x90, 0x87, 0x74, 0x0D, 0xF0, 0xE7, 0x74, 0x08, 0xF9, 0x05,
  0x77, 0x30, 0x1F, 0x90, 0xC7, 0x74, 0x0A, 0xF9, 0x03, 0x77, 0x30, 0x3F, 0x90, 0x97, 0x74, 0x0C,
  0xF0, 0xE0, 0x17, 0x73, 0x06, 0xF9, 0x06, 0x77, 0x30, 0x10, 0xEF, 0x0C, 0x77, 0x40, 0x8F, 0x90,
  0x37, 0x73, 0x02, 0xF9, 0x0A, 0x77, 0x40, 0xBF, 0x0E, 0x01, 0x77, 0x30, 0x4F, 0x90, 0x77, 0x74,
  0x0D, 0xF0, 0xD7, 0x74, 0x07, 0xF9, 0x04, 0x77, 0x30, 0x10, 0xEF, 0x0B, 0x77, 0x40, 0x9F, 0x90,
  0x27, 0x73, 0x03, 0xF9, 0x08, 0x77, 0x40, 0xBF, 0x0E, 0x77, 0x40, 0x5F, 0x90, 0x57, 0x74, 0x0D,
  0xF0, 0xC7, 0x74, 0x07, 0xF9, 0x03, 0x77, 0x30, 0x10, 0xEF, 0x09, 0x77, 0x40, 0xAF, 0x0E, 0x01,
  0x77, 0x30, 0x3F, 0x90, 0x67, 0x74, 0x0C, 0xF0, 0xC7, 0x74, 0x06, 0xF9, 0x03, 0x77, 0x40, 0xEF,
  0x0A, 0x77, 0x40, 0x8F, 0xA8, 0x09, 0x4E, 0x0B, 0x01, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C,
  0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C,
  // "ź" (U+017A)
  0x77, 0x20, 0x68, 0x04, 0x70, 0x67, 0x75, 0x04, 0xFA, 0x05, 0x77, 0x50, 0xDF, 0x90, 0x67, 0x75,
  0x08, 0xF9, 0x06, 0x77, 0x50, 0x3F, 0x90, 0x57, 0x76, 0x0D, 0xF0, 0x47, 0x76, 0x09, 0xE0, 0xE0,
  0x47, 0x76, 0x05, 0xE0, 0xE0, 0x37, 0x76, 0x02, 0x0E, 0xD0, 0xC0, 0x17, 0x77, 0x09, 0xD0, 0xA8,
  0x0A, 0x82, 0x00, 0x3F, 0xFF, 0xD0, 0x82, 0x03, 0xFF, 0xFD, 0x08, 0x20, 0x3F, 0xFF, 0xD0, 0x82,
  0x03, 0xFF, 0xFD, 0x08, 0x20, 0x3F, 0xFF, 0xD0, 0x82, 0x03, 0xFF, 0xFD, 0x08, 0x20, 0x38, 0x09,
  0x3E, 0xFB, 0x0E, 0x02, 0x77, 0x40, 0xCF, 0xA0, 0x37, 0x74, 0x0B, 0xFA, 0x05, 0x77, 0x40, 0x8F,
  0xA0, 0x77, 0x74, 0x06, 0xFA, 0x09, 0x77, 0x40, 0x4F, 0xA0, 0xB7, 0x74, 0x02, 0x0E, 0xF9, 0x0C,
  0x77, 0x40, 0x10, 0xDF, 0x90, 0xD0, 0x17, 0x74, 0x0B, 0xF9, 0x0E, 0x02, 0x77, 0x40, 0x9F, 0xA0,
  0x47, 0x74, 0x07, 0xFA, 0x06, 0x77, 0x40, 0x5F, 0xA0, 0x87, 0x74, 0x03, 0x0E, 0xF9, 0x0A, 0x77,
  0x40, 0x10, 0xEF, 0x90, 0xC7, 0x75, 0x0C, 0xF9, 0x0D, 0x01, 0x77, 0x40, 0xAF, 0x90, 0xE0, 0x27,
  0x74, 0x08, 0xFA, 0x03, 0x77, 0x40, 0x6F, 0xA0, 0x57, 0x74, 0x04, 0xFA, 0x07, 0x77, 0x40, 0x20,
  0xEF, 0xA8, 0x09, 0x5E, 0x81, 0x10, 0xDF, 0xFF, 0xE0, 0x01, 0xFF, 0xFF, 0x00, 0x1F, 0xFF, 0xF0,
  0x01, 0xFF, 0xFF, 0x00, 0x1F, 0xFF, 0xF0, 0x01, 0xFF, 0xFF, 0x01,
  // "Ż" (U+017B)
  0x74, 0x81, 0x29, 0xDA, 0x81, 0xD9, 0x27, 0x75, 0x03, 0x0E, 0xE0, 0xE0, 0x37, 0x74, 0x0D, 0xF9,
  0x0C, 0x77, 0x30, 0x2F, 0xB0, 0x17, 0x72, 0x04, 0xFB, 0x03, 0x77, 0x20, 0x4F, 0xB0, 0x37, 0x72,
  0x02, 0xFB, 0x01, 0x77, 0x30, 0xDF, 0x90, 0xB7, 0x74, 0x04, 0xF0, 0xE0, 0x27, 0x75, 0x81, 0x29,
  0xDA, 0x81, 0xD8, 0x18, 0x09, 0xE7, 0x00, 0xAF, 0xFF, 0xB0, 0xA2, 0x0A, 0xFF, 0xFB, 0x0A, 0x20,
  0xAF, 0xFF, 0xB0, 0xA2, 0x0A, 0xFF, 0xFB, 0x0A, 0x20, 0xAF, 0xFF, 0xB0, 0xA2, 0x0A, 0xFF, 0xFB,
  0x09, 0x20, 0xA8, 0x09, 0x3E, 0xFA, 0x02, 0x77, 0x30, 0x5F, 0x90, 0x87, 0x74, 0x0D, 0xF0, 0xE7,
  0x74, 0x08, 0xF9, 0x05, 0x77, 0x30, 0x1F, 0x90, 0xC7, 0x74, 0x0A, 0xF9, 0x03, 0x77, 0x30, 0x3F,
  0x90, 0x97, 0x74, 0x0C, 0xF0, 0xE0, 0x17, 0x73, 0x06, 0xF9, 0x06, 0x77, 0x30, 0x10, 0xEF, 0x0C,
  0x77, 0x40, 0x8F, 0x90, 0x37, 0x73, 0x02, 0xF9, 0x0A, 0x77, 0x40, 0xBF, 0x0E, 0x01, 0x77, 0x30,
  0x4F, 0x90, 0x77, 0x74, 0x0D, 0xF0, 0xD7, 0x74, 0x07, 0xF9, 0x04, 0x77, 0x30, 0x10, 0xEF, 0x0B,
  0x77, 0x40, 0x9F, 0x90, 0x27, 0x73, 0x03, 0xF9, 0x08, 0x77, 0x40, 0xBF, 0x0E, 0x77, 0x40, 0x5F,
  0x90, 0x57, 0x74, 0x0D, 0xF0, 0xC7, 0x74, 0x07, 0xF9, 0x03, 0x77, 0x30, 0x10, 0xEF, 0x09, 0x77,
  0x40, 0xAF, 0x0E, 0x01, 0x77, 0x30, 0x3F, 0x90, 0x67, 0x74, 0x0C, 0xF0, 0xC7, 0x74, 0x06, 0xF9,
  0x03, 0x77, 0x40, 0xEF, 0x0A, 0x77, 0x40, 0x8F, 0xA8, 0x09, 0x4E, 0x0B, 0x01, 0xFF, 0xFD, 0x0C,
  0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C, 0x03, 0xFF, 0xFD, 0x0C,
  0x03, 0xFF, 0xFD, 0x0C,
  // "ż" (U+017C)
  0x74, 0x81, 0x29, 0xDA, 0x81, 0xD9, 0x27, 0x77, 0x03, 0x0E, 0xE0, 0xE0, 0x37, 0x76, 0x0D, 0xF9,
  0x0C, 0x77, 0x50, 0x2F, 0xB0, 0x17, 0x74, 0x04, 0xFB, 0x03, 0x77, 0x40, 0x4F, 0xB0, 0x37, 0x74,
  0x02, 0xFB, 0x01, 0x77, 0x50, 0xDF, 0x90, 0xB7, 0x76, 0x04, 0xF0, 0xE0, 0x27, 0x77, 0x81, 0x29,
  0xDA, 0x81, 0xD8, 0x18, 0x0A, 0x80, 0x00, 0x3F, 0xFF, 0xD0, 0x82, 0x03, 0xFF, 0xFD, 0x08, 0x20,
  0x3F, 0xFF, 0xD0, 0x82, 0x03, 0xFF, 0xFD, 0x08, 0x20, 0x3F, 0xFF, 0xD0, 0x82, 0x03, 0xFF, 0xFD,
  0x08, 0x20, 0x38, 0x09, 0x3E, 0xFB, 0x0E, 0x02, 0x77, 0x40, 0xCF, 0xA0, 0x37, 0x74, 0x0B, 0xFA,
  0x05, 0x77, 0x40, 0x8F, 0xA0, 0x77, 0x74, 0x06, 0xFA, 0x09, 0x77, 0x40, 0x4F, 0xA0, 0xB7, 0x74,
  0x02, 0x0E, 0xF9, 0x0C, 0x77, 0x40, 0x10, 0xDF, 0x90, 0xD0, 0x17, 0x74, 0x0B, 0xF9, 0x0E, 0x02,
  0x77, 0x40, 0x9F, 0xA0, 0x47, 0x74, 0x07, 0xFA, 0x06, 0x77, 0x40, 0x5F, 0xA0, 0x87, 0x74, 0x03,
  0x0E, 0xF9, 0x0A, 0x77, 0x40, 0x10, 0xEF, 0x90, 0xC7, 0x75, 0x0C, 0xF9, 0x0D, 0x01, 0x77, 0x40,
  0xAF, 0x90, 0xE0, 0x27, 0x74, 0x08, 0xFA, 0x03, 0x77, 0x40, 0x6F, 0xA0, 0x57, 0x74, 0x04, 0xFA,
  0x07, 0x77, 0x40, 0x20, 0xEF, 0xA8, 0x09, 0x5E, 0x81, 0x10, 0xDF, 0xFF, 0xE0, 0x01, 0xFF, 0xFF,
  0x00, 0x1F, 0xFF, 0xF0, 0x01, 0xFF, 0xFF, 0x00, 0x1F, 0xFF, 0xF0, 0x01, 0xFF, 0xFF, 0x01,
  // "Ž" (U+017D)
  0x48, 0x01, 0x70, 0x57, 0x30, 0x58, 0x01, 0x76, 0x0B, 0xD0, 0x97, 0x10, 0x9D, 0x0B, 0x70, 0xCD,
  0x0C, 0x01, 0x40, 0x20, 0xCD, 0x0D, 0x01, 0x70, 0x10, 0xED, 0x0D, 0x02, 0x20, 0x30, 0xED, 0x0E,
  0x02, 0x72, 0x04, 0xE8, 0x2E, 0x23, 0xEE, 0x04, 0x74, 0x07, 0xE0, 0xD0, 0xEE, 0x08, 0x76, 0x0B,
  0xFD, 0x0B, 0x77, 0x01, 0x0E, 0xFB, 0x0E, 0x01, 0x77, 0x10, 0x5F, 0xB0, 0x57, 0x73, 0x0A, 0xF9,
  0x0A, 0x80, 0x9E, 0x60, 0x0A, 0xFF, 0xFB, 0x0A, 0x20, 0xAF, 0xFF, 0xB0, 0xA2, 0x0A, 0xFF, 0xFB,
  0x0A, 0x20, 0xAF, 0xFF, 0xB0, 0xA2, 0x0A, 0xFF, 0xFB, 0x0A, 0x20, 0xAF, 0xFF, 0xB0, 0x92, 0x0A,
  0x80, 0x93, 0xEF, 0xA0, 0x27, 0x73, 0x05, 0xF9, 0x08, 0x77, 0x40, 0xDF, 0x0E, 0x77, 0x40, 0x8F,
  0x90, 0x57, 0x73, 0x01, 0xF9, 0x0C, 0x77, 0x40, 0xAF, 0x90, 0x37, 0x73, 0x03, 0xF9, 0x09, 0x77,
  0x40, 0xCF, 0x0E, 0x01, 0x77, 0x30, 0x6F, 0x90, 0x67, 0x73, 0x01, 0x0E, 0xF0, 0xC7, 0x74, 0x08,
  0xF9, 0x03, 0x77, 0x30, 0x2F, 0x90, 0xA7, 0x74, 0x0B, 0xF0, 0xE0, 0x17, 0x73, 0x04, 0xF9, 0x07,
  0x77, 0x40, 0xDF, 0x0D, 0x77, 0x40, 0x7F, 0x90, 0x47, 0x73, 0x01, 0x0E, 0xF0, 0xB7, 0x74, 0x09,
  0xF9, 0x02, 0x77, 0x30, 0x3F, 0x90, 0x87, 0x74, 0x0B, 0xF0, 0xE7, 0x74, 0x05, 0xF9, 0x05, 0x77,
  0x40, 0xDF, 0x0C, 0x77, 0x40, 0x7F, 0x90, 0x37, 0x73, 0x01, 0x0E, 0xF0, 0x97, 0x74, 0x0A, 0xF0,
  0xE0, 0x17, 0x73, 0x03, 0xF9, 0x06, 0x77, 0x40, 0xCF, 0x0C, 0x77, 0x40, 0x6F, 0x90, 0x37, 0x74,
  0x0E, 0xF0, 0xA7, 0x74, 0x08, 0xFA, 0x80, 0x94, 0xE0, 0xB0, 0x1F, 0xFF, 0xD0, 0xC0, 0x3F, 0xFF,
  0xD0, 0xC0, 0x3F, 0xFF, 0xD0, 0xC0, 0x3F, 0xFF, 0xD0, 0xC0, 0x3F, 0xFF, 0xD0, 0xC0, 0x3F, 0xFF,
  0xD0, 0xC0,
  // "ž" (U+017E)
  0x48, 0x01, 0x70, 0x57, 0x30, 0x58, 0x01, 0x77, 0x10, 0xBD, 0x09, 0x71, 0x09, 0xD0, 0xB7, 0x20,
  0xCD, 0x0C, 0x01, 0x40, 0x20, 0xCD, 0x0D, 0x01, 0x72, 0x01, 0x0E, 0xD0, 0xD0, 0x22, 0x03, 0x0E,
  0xD0, 0xE0, 0x27, 0x40, 0x4E, 0x82, 0xE2, 0x3E, 0xE0, 0x47, 0x60, 0x7E, 0x0D, 0x0E, 0xE0, 0x87,
  0x71, 0x0B, 0xFD, 0x0B, 0x77, 0x20, 0x10, 0xEF, 0xB0, 0xE0, 0x17, 0x73, 0x05, 0xFB, 0x05, 0x77,
  0x50, 0xAF, 0x90, 0xA8, 0x09, 0xF7, 0x00, 0x3F, 0xFF, 0xD0, 0x82, 0x03, 0xFF, 0xFD, 0x08, 0x20,
  0x3F, 0xFF, 0xD0, 0x82, 0x03, 0xFF, 0xFD, 0x08, 0x20, 0x3F, 0xFF, 0xD0, 0x82, 0x03, 0xFF, 0xFD,
  0x08, 0x20, 0x38, 0x09, 0x3E, 0xFB, 0x0E, 0x02, 0x77, 0x40, 0xCF, 0xA0, 0x37, 0x74, 0x0B, 0xFA,
  0x05, 0x77, 0x40, 0x8F, 0xA0, 0x77, 0x74, 0x06, 0xFA, 0x09, 0x77, 0x40, 0x4F, 0xA0, 0xB7, 0x74,
  0x02, 0x0E, 0xF9, 0x0C, 0x77, 0x40, 0x10, 0xDF, 0x90, 0xD0, 0x17, 0x74, 0x0B, 0xF9, 0x0E, 0x02,
  0x77, 0x40, 0x9F, 0xA0, 0x47, 0x74, 0x07, 0xFA, 0x06, 0x77, 0x40, 0x5F, 0xA0, 0x87, 0x74, 0x03,
  0x0E, 0xF9, 0x0A, 0x77, 0x40, 0x10, 0xEF, 0x90, 0xC7, 0x75, 0x0C, 0xF9, 0x0D, 0x01, 0x77, 0x40,
  0xAF, 0x90, 0xE0, 0x27, 0x74, 0x08, 0xFA, 0x03, 0x77, 0x40, 0x6F, 0xA0, 0x57, 0x74, 0x04, 0xFA,
  0x07, 0x77, 0x40, 0x20, 0xEF, 0xA8, 0x09, 0x5E, 0x81, 0x10, 0xDF, 0xFF, 0xE0, 0x01, 0xFF, 0xFF,
  0x00, 0x1F, 0xFF, 0xF0, 0x01, 0xFF, 0xFF, 0x00, 0x1F, 0xFF, 0xF0, 0x01, 0xFF, 0xFF, 0x01,
  // "ſ" (U+017F)
  0x68, 0x93, 0x15, 0x9C, 0xDE, 0xFE, 0xEC, 0xA7, 0x36, 0x02, 0x0A, 0xFE, 0x0D, 0x02, 0x30, 0x40,
  0xEF, 0xF0, 0xE3, 0x02, 0xFF, 0xA0, 0xA3, 0x0C, 0xFF, 0xA0, 0x52, 0x04, 0xFF, 0xB0, 0x12, 0x09,
  0xFF, 0xA0, 0xB3, 0x0C, 0xF9, 0x0D, 0x05, 0x38, 0x23, 0x7D, 0x73, 0x0E, 0xF9, 0x02, 0x74, 0xF9,
  0x0B, 0x75, 0xF9, 0x09, 0x74, 0x01, 0xF9, 0x08, 0x74, 0x01, 0xF9, 0x08, 0x74, 0x01, 0xF9, 0x08,
  0x74, 0x01, 0xF9, 0x08, 0x74, 0x01, 0xF9, 0x08, 0x74, 0x01, 0xF9, 0x08, 0x74, 0x01, 0xF9, 0x08,
  0x74, 0x01, 0xF9, 0x08, 0x74, 0x01, 0xF9, 0x08, 0x74, 0x01, 0xF9, 0x08, 0x74, 0x01, 0xF9, 0x08,
  0x74, 0x01, 0xF9, 0x08, 0x74, 0x01, 0xF9, 0x08, 0x74, 0x01, 0xF9, 0x08, 0x74, 0x01, 0xF9, 0x08,
  0x74, 0x01, 0xF9, 0x08, 0x74, 0x01, 0xF9, 0x08, 0x74, 0x01, 0xF9, 0x08, 0x74, 0x01, 0xF9, 0x08,
  0x74, 0x01, 0xF9, 0x08, 0x74, 0x01, 0xF9, 0x08, 0x74, 0x01, 0xF9, 0x08, 0x74, 0x01, 0xF9, 0x08,
  0x74, 0x01, 0xF9, 0x08, 0x74, 0x01, 0xF9, 0x08, 0x74, 0x01, 0xF9, 0x08, 0x74, 0x01, 0xF9, 0x08,
  0x74, 0x01, 0xF9, 0x08, 0x74, 0x01, 0xF9, 0x08, 0x74, 0x01, 0xF9, 0x08, 0x74, 0x01, 0xF9, 0x08,
  0x74, 0x01, 0xF9, 0x08, 0x74, 0x01, 0xF9, 0x08, 0x74, 0x01, 0xF9, 0x08, 0x74,
  // "Ω" (U+03A9)
  0x77, 0x86, 0x35, 0x67, 0x76, 0x42, 0x77, 0x74, 0x81, 0x5A, 0xEF, 0x98, 0x1E, 0x94, 0x77, 0x60,
  0x50, 0xDF, 0xF0, 0xC0, 0x37, 0x73, 0x09, 0xFF, 0xC0, 0x77, 0x71, 0x0B, 0xFF, 0xE0, 0x97, 0x60,
  0xAF, 0xFF, 0x90, 0x87, 0x40, 0x7F, 0xFF, 0xB0, 0x57, 0x20, 0x10, 0xEF, 0xA8, 0x4E, 0x98, 0x89,
  0xEF, 0xA0, 0xD7, 0x20, 0x9F, 0xA0, 0x66, 0x05, 0x0E, 0xF9, 0x07, 0x71, 0x0E, 0xF9, 0x03, 0x71,
  0x03, 0xF9, 0x0D, 0x70, 0x5F, 0x90, 0x77, 0x30, 0x6F, 0x90, 0x36, 0x0A, 0xF0, 0xE7, 0x50, 0xEF,
  0x08, 0x60, 0xEF, 0x09, 0x75, 0x08, 0xF0, 0xC5, 0x01, 0xF9, 0x04, 0x75, 0x03, 0xF9, 0x50, 0x4F,
  0x90, 0x17, 0x6F, 0x90, 0x24, 0x06, 0xF0, 0xE7, 0x70, 0xDF, 0x04, 0x40, 0x7F, 0x0C, 0x77, 0x0B,
  0xF0, 0x54, 0x08, 0xF0, 0xA7, 0x70, 0x9F, 0x06, 0x40, 0x8F, 0x09, 0x77, 0x08, 0xF0, 0x74, 0x09,
  0xF0, 0x97, 0x70, 0x8F, 0x07, 0x40, 0x8F, 0x08, 0x77, 0x07, 0xF0, 0x64, 0x07, 0xF0, 0x97, 0x70,
  0x8F, 0x06, 0x40, 0x6F, 0x09, 0x77, 0x08, 0xF0, 0x54, 0x05, 0xF0, 0xA7, 0x70, 0x9F, 0x03, 0x40,
  0x3F, 0x0B, 0x77, 0x0B, 0xF0, 0x15, 0xF0, 0xC7, 0x70, 0xCE, 0x0E, 0x60, 0xCF, 0x77, 0x0E, 0xE0,
  0xB6, 0x09, 0xF0, 0x27, 0x50, 0x2F, 0x07, 0x60, 0x4F, 0x05, 0x75, 0x05, 0xF0, 0x27, 0x0E, 0xE0,
  0x87, 0x50, 0x9E, 0x0C, 0x71, 0x08, 0xE0, 0xD7, 0x50, 0xEE, 0x06, 0x71, 0x01, 0xF0, 0x37, 0x30,
  0x4E, 0x0E, 0x73, 0x08, 0xE0, 0x97, 0x30, 0xBE, 0x06, 0x74, 0x0E, 0xE0, 0x27, 0x10, 0x4E, 0x0C,
  0x75, 0x04, 0xE0, 0xB7, 0x10, 0xDD, 0x0E, 0x02, 0x76, 0x06, 0xE0, 0x86, 0x0A, 0xE0, 0x47, 0x71,
  0x06, 0xE0, 0x64, 0x08, 0xD0, 0xE0, 0x37, 0x10, 0x1F, 0xF0, 0xA4, 0x0C, 0xFF, 0x00, 0x1F, 0xF0,
  0xA4, 0x0C, 0xFF, 0x00, 0x1F, 0xF0, 0xA4, 0x0C, 0xFF, 0x00, 0x1F, 0xF0, 0xA4, 0x0C, 0xFF, 0x00,
  0x1F, 0xF0, 0xA4, 0x0C, 0xFF, 0x00, 0x1F, 0xF0, 0xA4, 0x0C, 0xFF, 0x00, 0x1F, 0xF0, 0x94, 0x0B,
  0xFF, 0x01,
  // "μ" (U+03BC)
  0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9,
  0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A,
  0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75,
  0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9,
  0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x75, 0xF9, 0x0A,
  0xF9, 0x0A, 0x75, 0xF9, 0x0A, 0xF9, 0x0A, 0x74, 0x01, 0xF9, 0x0A, 0xF9, 0x0A, 0x74, 0x02, 0xF9,
  0x0A, 0xF9, 0x0B, 0x74, 0x05, 0xF9, 0x0A, 0xF9, 0x0C, 0x74, 0x07, 0xF9, 0x0A, 0xF9, 0x0E, 0x74,
  0x0B, 0xF9, 0x0A, 0xFA, 0x02, 0x72, 0x01, 0xFA, 0x0A, 0xFA, 0x07, 0x72, 0x09, 0xFA, 0x0A, 0xFA,
  0x0E, 0x02, 0x70, 0x7F, 0xB0, 0xAF, 0xB8, 0x1E, 0x61, 0x28, 0x11, 0x4B, 0xFC, 0x0A, 0xFF, 0xFF,
  0x90, 0xAF, 0xFF, 0xF9, 0x0A, 0xFF, 0xE0, 0xD0, 0x6F, 0x0A, 0xFF, 0xD8, 0x2E, 0x30, 0xDE, 0x0A,
  0xFF, 0xC0, 0xD0, 0x32, 0x07, 0xE0, 0xAF, 0xFA, 0x0E, 0x07, 0x40, 0x1E, 0x0A, 0xF9, 0x0E, 0x0D,
  0xA8, 0x2E, 0xC9, 0x57, 0x7F, 0x90, 0xA7, 0x77, 0xF9, 0x0A, 0x77, 0x7F, 0x90, 0xA7, 0x77, 0xF9,
  0x0A, 0x77, 0x7F, 0x90, 0xA7, 0x77, 0xF9, 0x0A, 0x77, 0x7F, 0x90, 0xA7, 0x77, 0xF9, 0x0A, 0x77,
  0x7F, 0x90, 0xA7, 0x77, 0xF9, 0x0A, 0x77, 0x7F, 0x90, 0xA7, 0x77, 0xF9, 0x0A, 0x77, 0x7F, 0x90,
  0xA7, 0x77,
  // "π" (U+03C0)
  0x40, 0x40, 0xDF, 0xFF, 0xF9, 0x08, 0x20, 0x20, 0xBF, 0xFF, 0xFB, 0x81, 0x80, 0x7F, 0xFF, 0xFD,
  0x08, 0x07, 0xFF, 0xFF, 0xE0, 0x08, 0xFF, 0xFF, 0xE0, 0x08, 0xFF, 0xFF, 0xE0, 0x80, 0x7F, 0xFF,
  0xFE, 0x07, 0x60, 0x9F, 0x09, 0x50, 0x3F, 0x97, 0x60, 0x9F, 0x09, 0x50, 0x3F, 0x97, 0x60, 0x9F,
  0x09, 0x50, 0x3F, 0x97, 0x60, 0x9F, 0x09, 0x50, 0x3F, 0x97, 0x60, 0x9F, 0x09, 0x50, 0x3F, 0x97,
  0x60, 0x9F, 0x09, 0x50, 0x3F, 0x97, 0x60, 0x9F, 0x09, 0x50, 0x3F, 0x97, 0x60, 0x9F, 0x09, 0x50,
  0x3F, 0x97, 0x60, 0x9F, 0x09, 0x50, 0x3F, 0x97, 0x60, 0x9F, 0x09, 0x50, 0x3F, 0x97, 0x60, 0x9F,
  0x09, 0x50, 0x3F, 0x97, 0x60, 0x9F, 0x09, 0x50, 0x3F, 0x97, 0x60, 0x9F, 0x09, 0x50, 0x3F, 0x97,
  0x60, 0x9F, 0x09, 0x50, 0x3F, 0x97, 0x60, 0x9F, 0x09, 0x50, 0x3F, 0x97, 0x60, 0x9F, 0x09, 0x50,
  0x3F, 0x97, 0x60, 0x9F, 0x09, 0x50, 0x3F, 0x97, 0x60, 0x9F, 0x09, 0x50, 0x3F, 0x90, 0x47, 0x50,
  0x9F, 0x09, 0x50, 0x2F, 0x90, 0xD0, 0x42, 0x81, 0x27, 0x56, 0x09, 0xF0, 0x96, 0xFF, 0x07, 0x60,
  0x9F, 0x09, 0x60, 0xCF, 0xE0, 0x76, 0x09, 0xF0, 0x96, 0x06, 0xFE, 0x07, 0x60, 0x9F, 0x09, 0x70,
  0xEF, 0xD0, 0x76, 0x09, 0xF0, 0x97, 0x03, 0xFD, 0x07, 0x60, 0x9F, 0x09, 0x71, 0x03, 0x0D, 0xFA,
  0x0D, 0x03, 0x60, 0x38, 0x03, 0x60, 0x47, 0x38, 0x75, 0xAD, 0xEF, 0xEC, 0x84, 0x20,
  // "–" (U+2013)
  0x80, 0xA4, 0xE8, 0x0A, 0x94, 0xF0,
  // "—" (U+2014)
  0x80, 0xC0, 0xE8, 0x0B, 0xA4, 0xF0,
  // "€" (U+20AC)
  0x77, 0x28, 0x93, 0x47, 0xBC, 0xDE, 0xFE, 0xDB, 0x85, 0x17, 0x73, 0x81, 0x39, 0xEF, 0xE0, 0xB0,
  0x67, 0x60, 0x10, 0xBF, 0xFC, 0x0E, 0x03, 0x73, 0x06, 0x0E, 0xFF, 0xD0, 0xE7, 0x30, 0x8F, 0xFF,
  0x07, 0x72, 0x09, 0xFF, 0xF9, 0x01, 0x71, 0x06, 0xFF, 0xF9, 0x09, 0x71, 0x02, 0x0E, 0xFA, 0x82,
  0xD7, 0x31, 0x38, 0x22, 0x59, 0xEA, 0x02, 0x71, 0x0B, 0xFA, 0x07, 0x74, 0x03, 0x06, 0x71, 0x02,
  0xFA, 0x04, 0x77, 0x71, 0x09, 0xF9, 0x06, 0x77, 0x72, 0x0E, 0xF0, 0xC7, 0x77, 0x20, 0x3F, 0x90,
  0x57, 0x77, 0x20, 0x7F, 0x90, 0x17, 0x75, 0x08, 0xFF, 0xFB, 0x71, 0x08, 0xFF, 0xFB, 0x71, 0x08,
  0xFF, 0xFB, 0x71, 0x08, 0xFF, 0xFB, 0x71, 0x08, 0xFF, 0xFB, 0x75, 0xF9, 0x07, 0x77, 0x72, 0x01,
  0xF9, 0x07, 0x77, 0x72, 0x01, 0xF9, 0x07, 0x77, 0x73, 0xF9, 0x07, 0x77, 0x60, 0x8F, 0xFF, 0xB7,
  0x10, 0x8F, 0xFF, 0xB7, 0x10, 0x8F, 0xFF, 0xB7, 0x10, 0x8F, 0xFF, 0xB7, 0x10, 0x8F, 0xFF, 0xB7,
  0x50, 0x5F, 0x90, 0x27, 0x77, 0x20, 0x1F, 0x90, 0x67, 0x77, 0x30, 0xCF, 0x0C, 0x77, 0x73, 0x07,
  0xF9, 0x05, 0x77, 0x72, 0x01, 0xF9, 0x0E, 0x02, 0x77, 0x72, 0x0A, 0xF9, 0x0D, 0x02, 0x77, 0x71,
  0x02, 0xFB, 0x08, 0x02, 0x71, 0x82, 0x15, 0xBB, 0x72, 0x07, 0xFC, 0x86, 0xC9, 0x87, 0x78, 0xAD,
  0xB0, 0xB7, 0x30, 0xBF, 0xFF, 0x0B, 0x74, 0x0B, 0xFF, 0xE0, 0xB7, 0x50, 0xBF, 0xFD, 0x0B, 0x76,
  0x07, 0xFF, 0xC0, 0xB7, 0x70, 0x20, 0xAF, 0xFA, 0x0B, 0x77, 0x28, 0x21, 0x7B, 0xEF, 0xA8, 0x1E,
  0xA5, 0x77, 0x78, 0x73, 0x56, 0x77, 0x66, 0x42, 0x60,
  // "₿" (U+20BF)
  0x78, 0x00, 0x74, 0x83, 0x37, 0x77, 0x47, 0x72, 0x01, 0xB0, 0xE4, 0x07, 0xB0, 0x87, 0x72, 0x01,
  0xB0, 0xE4, 0x07, 0xB0, 0x87, 0x72, 0x01, 0xB0, 0xE4, 0x07, 0xB0, 0x87, 0x72, 0x01, 0xB0, 0xE4,
  0x07, 0xB0, 0x87, 0x72, 0x01, 0xB0, 0xE4, 0x07, 0xB0, 0x87, 0x72, 0x01, 0xB0, 0xE4, 0x07, 0xB0,
  0x87, 0x30, 0x3F, 0xFC, 0x81, 0xB5, 0x17, 0x10, 0x3F, 0xFF, 0x0C, 0x06, 0x60, 0x3F, 0xFF, 0xA0,
  0xD0, 0x34, 0x03, 0xFF, 0xFC, 0x05, 0x30, 0x3F, 0xFF, 0xC0, 0xE0, 0x22, 0x03, 0xFF, 0xFD, 0x0B,
  0x20, 0x3F, 0x98, 0x01, 0xEF, 0xF8, 0x12, 0x03, 0xF0, 0xE7, 0x81, 0x37, 0xEF, 0xA8, 0x16, 0x03,
  0xF0, 0xE7, 0x20, 0x20, 0xEF, 0x98, 0x19, 0x03, 0xF0, 0xE7, 0x30, 0x7F, 0x98, 0x1A, 0x03, 0xF0,
  0xE7, 0x30, 0x3F, 0x98, 0x1A, 0x03, 0xF0, 0xE7, 0x30, 0x2F, 0x98, 0x19, 0x03, 0xF0, 0xE7, 0x30,
  0x3F, 0x98, 0x16, 0x03, 0xF0, 0xE7, 0x30, 0x7F, 0x98, 0x13, 0x03, 0xF0, 0xE7, 0x20, 0x20, 0xEF,
  0x0C, 0x20, 0x3F, 0x0E, 0x68, 0x21, 0x37, 0xEF, 0x90, 0x42, 0x03, 0xFF, 0xFC, 0x09, 0x30, 0x3F,
  0xFF, 0xB0, 0x94, 0x03, 0xFF, 0xF9, 0x0B, 0x04, 0x50, 0x3F, 0xFF, 0x0A, 0x03, 0x60, 0x3F, 0xFF,
  0xA0, 0xC0, 0x34, 0x03, 0xFF, 0xFC, 0x07, 0x30, 0x3F, 0x98, 0x02, 0xEF, 0xD0, 0x72, 0x03, 0xF0,
  0xE7, 0x81, 0x25, 0xCF, 0xA8, 0x13, 0x03, 0xF0, 0xE7, 0x30, 0xBF, 0x98, 0x1B, 0x03, 0xF0, 0xE7,
  0x30, 0x1F, 0xA0, 0x10, 0x3F, 0x0E, 0x74, 0x0B, 0xF9, 0x04, 0x03, 0xF0, 0xE7, 0x40, 0x8F, 0x90,
  0x70, 0x3F, 0x0E, 0x74, 0x07, 0xF9, 0x08, 0x03, 0xF0, 0xE7, 0x40, 0x7F, 0x90, 0x80, 0x3F, 0x0E,
  0x74, 0x09, 0xF9, 0x08, 0x03, 0xF0, 0xE7, 0x40, 0xCF, 0x90, 0x60, 0x3F, 0x0E, 0x73, 0x03, 0xFA,
  0x04, 0x03, 0xF0, 0xE7, 0x30, 0xCF, 0xA1, 0x03, 0xF0, 0xE7, 0x81, 0x15, 0xDF, 0xA8, 0x1A, 0x03,
  0xF9, 0x80, 0x2E, 0xFE, 0x81, 0x40, 0x3F, 0xFF, 0xD0, 0xA2, 0x03, 0xFF, 0xFC, 0x0D, 0x01, 0x20,
  0x3F, 0xFF, 0xB0, 0xD0, 0x23, 0x03, 0xFF, 0xFA, 0x0A, 0x01, 0x40, 0x3F, 0xFF, 0x0B, 0x04, 0x60,
  0x3F, 0xFC, 0x81, 0xC6, 0x27, 0x70, 0x1B, 0x0E, 0x40, 0x7B, 0x08, 0x77, 0x20, 0x1B, 0x0E, 0x40,
  0x7B, 0x08, 0x77, 0x20, 0x1B, 0x0E, 0x40, 0x7B, 0x08, 0x77, 0x20, 0x1B, 0x0E, 0x40, 0x7B, 0x08,
  0x77, 0x20, 0x1B, 0x0E, 0x40, 0x7B, 0x08, 0x77, 0x20, 0x1B, 0x0E, 0x40, 0x7B, 0x07, 0x73,
  // "‘" (U+2018)
  0x50, 0xBD, 0x08, 0x40, 0x2E, 0x04, 0x40, 0x9E, 0x01, 0x40, 0xED, 0x0D, 0x40, 0x6E, 0x0A, 0x40,
  0xCE, 0x06, 0x30, 0x2F, 0x03, 0x30, 0x8F, 0x40, 0xDE, 0x0D, 0x30, 0x3F, 0x0A, 0x30, 0x8F, 0x07,
  0x30, 0xDF, 0x04, 0x20, 0x2F, 0x90, 0x12, 0x07, 0xF0, 0xE3, 0x08, 0xF0, 0xC3,
  // "’" (U+2019)
  0x30, 0x8F, 0x0E, 0x01, 0x30, 0xAF, 0x0E, 0x40, 0xDF, 0x0A, 0x4F, 0x90, 0x63, 0x03, 0xF9, 0x01,
  0x30, 0x5F, 0x0B, 0x40, 0x8F, 0x06, 0x40, 0xBF, 0x01, 0x40, 0xEE, 0x0A, 0x40, 0x2F, 0x04, 0x40,
  0x6E, 0x0D, 0x50, 0x9E, 0x07, 0x50, 0xDE, 0x01, 0x40, 0x1E, 0x0A, 0x50, 0x4E, 0x03, 0x50,
  // "‚" (U+201A)
  0x30, 0x3F, 0x90, 0x53, 0x05, 0xF9, 0x04, 0x30, 0x8F, 0x94, 0x0B, 0xF0, 0xB4, 0x0D, 0xF0, 0x74,
  0xF9, 0x03, 0x30, 0x3F, 0x0D, 0x40, 0x6F, 0x09, 0x40, 0x9F, 0x04, 0x40, 0xCE, 0x0E, 0x50, 0xEE,
  0x09, 0x40, 0x2F, 0x04, 0x40, 0x5E, 0x0D, 0x50, 0x8E, 0x08, 0x50, 0xBE, 0x02, 0x5E, 0x0B, 0x50,
  0x3E, 0x04, 0x50,
  // "‛" (U+201B)
  0x08, 0xF0, 0xC3, 0x07, 0xF0, 0xE3, 0x02, 0xF9, 0x01, 0x30, 0xDF, 0x04, 0x30, 0x8F, 0x07, 0x30,
  0x3F, 0x0A, 0x40, 0xDE, 0x0C, 0x40, 0x8F, 0x40, 0x2F, 0x03, 0x40, 0xCE, 0x06, 0x40, 0x6E, 0x09,
  0x50, 0xED, 0x0D, 0x50, 0x9E, 0x01, 0x40, 0x2E, 0x04, 0x50, 0xBD, 0x08,
  // "“" (U+201C)
  0x50, 0xBD, 0x08, 0x70, 0xBD, 0x08, 0x40, 0x2E, 0x04, 0x60, 0x2E, 0x04, 0x40, 0x9E, 0x01, 0x60,
  0x9E, 0x01, 0x40, 0xED, 0x0D, 0x70, 0xED, 0x0D, 0x40, 0x6E, 0x0A, 0x60, 0x6E, 0x0A, 0x40, 0xCE,
  0x06, 0x60, 0xCE, 0x06, 0x30, 0x2F, 0x03, 0x50, 0x2F, 0x03, 0x30, 0x8F, 0x60, 0x8F, 0x40, 0xDE,
  0x0D, 0x60, 0xDE, 0x0D, 0x30, 0x3F, 0x0A, 0x50, 0x3F, 0x0A, 0x30, 0x8F, 0x07, 0x50, 0x8F, 0x07,
  0x30, 0xDF, 0x04, 0x50, 0xDF, 0x04, 0x20, 0x2F, 0x90, 0x14, 0x02, 0xF9, 0x01, 0x20, 0x7F, 0x0E,
  0x50, 0x7F, 0x0E, 0x30, 0x8F, 0x0C, 0x50, 0x8F, 0x0C, 0x30,
  // "”" (U+201D)
  0x30, 0xCF, 0x08, 0x50, 0xCF, 0x08, 0x30, 0xEF, 0x07, 0x50, 0xEF, 0x07, 0x20, 0x1F, 0x90, 0x24,
  0x01, 0xF9, 0x02, 0x20, 0x4F, 0x0D, 0x50, 0x4F, 0x0D, 0x30, 0x7F, 0x08, 0x50, 0x7F, 0x08, 0x30,
  0xAF, 0x03, 0x50, 0xAF, 0x03, 0x30, 0xDE, 0x0D, 0x60, 0xDE, 0x0D, 0x4F, 0x08, 0x6F, 0x08, 0x30,
  0x3F, 0x02, 0x50, 0x3F, 0x02, 0x30, 0x7E, 0x0C, 0x60, 0x7E, 0x0C, 0x40, 0xAE, 0x06, 0x60, 0xAE,
  0x06, 0x40, 0xDD, 0x0E, 0x70, 0xDD, 0x0E, 0x40, 0x1E, 0x09, 0x60, 0x1E, 0x09, 0x40, 0x4E, 0x02,
  0x60, 0x4E, 0x02, 0x40, 0x8D, 0x0B, 0x70, 0x8D, 0x0B, 0x50,
  // "„" (U+201E)
  0x30, 0x3F, 0x90, 0x53, 0x03, 0xF9, 0x05, 0x30, 0x5F, 0x90, 0x43, 0x05, 0xF9, 0x04, 0x30, 0x8F,
  0x94, 0x08, 0xF9, 0x40, 0xBF, 0x0B, 0x40, 0xBF, 0x0B, 0x40, 0xDF, 0x07, 0x40, 0xDF, 0x07, 0x4F,
  0x90, 0x34, 0xF9, 0x03, 0x30, 0x3F, 0x0D, 0x40, 0x3F, 0x0D, 0x40, 0x6F, 0x09, 0x40, 0x6F, 0x09,
  0x40, 0x9F, 0x04, 0x40, 0x9F, 0x04, 0x40, 0xCE, 0x0E, 0x50, 0xCE, 0x0E, 0x50, 0xEE, 0x09, 0x50,
  0xEE, 0x09, 0x40, 0x2F, 0x04, 0x40, 0x2F, 0x04, 0x40, 0x5E, 0x0D, 0x50, 0x5E, 0x0D, 0x50, 0x8E,
  0x08, 0x50, 0x8E, 0x08, 0x50, 0xBE, 0x02, 0x50, 0xBE, 0x02, 0x5E, 0x0B, 0x6E, 0x0B, 0x50, 0x3E,
  0x04, 0x50, 0x3E, 0x04, 0x50,
  // "‟" (U+201F)
  0x08, 0xF0, 0xC5, 0x08, 0xF0, 0xC3, 0x07, 0xF0, 0xE5, 0x07, 0xF0, 0xE3, 0x02, 0xF9, 0x01, 0x40,
  0x2F, 0x90, 0x13, 0x0D, 0xF0, 0x45, 0x0D, 0xF0, 0x43, 0x08, 0xF0, 0x75, 0x08, 0xF0, 0x73, 0x03,
  0xF0, 0xA5, 0x03, 0xF0, 0xA4, 0x0D, 0xE0, 0xC6, 0x0D, 0xE0, 0xC4, 0x08, 0xF6, 0x08, 0xF4, 0x02,
  0xF0, 0x35, 0x02, 0xF0, 0x34, 0x0C, 0xE0, 0x66, 0x0C, 0xE0, 0x64, 0x06, 0xE0, 0x96, 0x06, 0xE0,
  0x95, 0x0E, 0xD0, 0xD7, 0x0E, 0xD0, 0xD5, 0x09, 0xE0, 0x16, 0x09, 0xE0, 0x14, 0x02, 0xE0, 0x46,
  0x02, 0xE0, 0x45, 0x0B, 0xD0, 0x87, 0x0B, 0xD0, 0x80,
  // "†" (U+2020)
  0x70, 0x3F, 0x09, 0x77, 0x10, 0x1F, 0x07, 0x77, 0x20, 0xEE, 0x05, 0x77, 0x20, 0xCE, 0x03, 0x77,
  0x20, 0xBE, 0x01, 0x77, 0x20, 0x9D, 0x0E, 0x77, 0x30, 0x7D, 0x0C, 0x77, 0x30, 0x5D, 0x0A, 0x77,
  0x30, 0x3D, 0x08, 0x77, 0x30, 0x1D, 0x06, 0x77, 0x40, 0xEC, 0x04, 0x72, 0x81, 0x43, 0x26, 0x0C,
  0xC0, 0x25, 0x83, 0x12, 0x34, 0xDB, 0x84, 0xED, 0xBA, 0x8D, 0xC8, 0x39, 0x9B, 0xCD, 0xC0, 0xC0,
  0xDF, 0xFF, 0x90, 0xC0, 0xDF, 0xFF, 0x90, 0xC0, 0xDF, 0xFF, 0x90, 0xC0, 0xDF, 0xFF, 0x90, 0xC0,
  0xDB, 0x84, 0xEC, 0xB9, 0x8D, 0xC8, 0x48, 0x9A, 0xCD, 0xEB, 0x82, 0xC4, 0x31, 0x60, 0xBC, 0x01,
  0x68, 0x12, 0x33, 0x72, 0x0C, 0xC0, 0x27, 0x74, 0x0D, 0xC0, 0x37, 0x74, 0x0E, 0xC0, 0x47, 0x74,
  0xD0, 0x57, 0x74, 0xD0, 0x67, 0x73, 0x01, 0xD0, 0x77, 0x73, 0x02, 0xD0, 0x77, 0x73, 0x03, 0xD0,
  0x87, 0x73, 0x04, 0xD0, 0x97, 0x73, 0x05, 0xD0, 0xA7, 0x73, 0x06, 0xD0, 0xB7, 0x73, 0x06, 0xD0,
  0xC7, 0x73, 0x07, 0xD0, 0xD7, 0x73, 0x08, 0xD0, 0xE7, 0x73, 0x09, 0xE7, 0x73, 0x0A, 0xE7, 0x73,
  0x0B, 0xE0, 0x17, 0x72, 0x0C, 0xE0, 0x27, 0x72, 0x0D, 0xE0, 0x37, 0x72, 0x0D, 0xE0, 0x47, 0x72,
  0x0E, 0xE0, 0x57, 0x72, 0xF0, 0x67, 0x71, 0x01, 0xF0, 0x77, 0x71, 0x01, 0xF0, 0x77, 0x71, 0x02,
  0xF0, 0x87, 0x71, 0x03, 0xF0, 0x97, 0x10,
  // "‡" (U+2021)
  0x72, 0x0E, 0xE0, 0xD7, 0x74, 0x0C, 0xE0, 0xB7, 0x74, 0x0A, 0xE0, 0x97, 0x74, 0x08, 0xE0, 0x77,
  0x74, 0x05, 0xE0, 0x47, 0x74, 0x03, 0xE0, 0x27, 0x74, 0x01, 0xE7, 0x76, 0x0E, 0xC0, 0xD7, 0x76,
  0x0C, 0xC0, 0xB7, 0x76, 0x0A, 0xC0, 0x97, 0x38, 0x41, 0x75, 0x43, 0x14, 0x08, 0xC0, 0x74, 0x85,
  0x13, 0x46, 0x71, 0x2E, 0x82, 0xED, 0xBC, 0xC8, 0x2C, 0xBD, 0xEE, 0x01, 0x02, 0xFF, 0xFB, 0x01,
  0x02, 0xFF, 0xFB, 0x01, 0x02, 0xFF, 0xFB, 0x01, 0x02, 0xFF, 0xFB, 0x01, 0x02, 0xA8, 0x6E, 0xDB,
  0xA9, 0x76, 0xAC, 0x86, 0x96, 0x79, 0xAB, 0xDE, 0xA8, 0x11, 0x01, 0x71, 0x0A, 0xC0, 0x97, 0x10,
  0x17, 0x40, 0xDC, 0x0C, 0x77, 0x50, 0x1E, 0x77, 0x50, 0x5E, 0x04, 0x77, 0x40, 0x8E, 0x07, 0x77,
  0x40, 0xBE, 0x0A, 0x77, 0x40, 0x9E, 0x08, 0x77, 0x40, 0x5E, 0x04, 0x77, 0x40, 0x2E, 0x01, 0x77,
  0x50, 0xEC, 0x0E, 0x77, 0x60, 0xBC, 0x0A, 0x73, 0x85, 0x18, 0x75, 0x42, 0x13, 0x08, 0xC0, 0x73,
  0x86, 0x12, 0x45, 0x78, 0x12, 0xF8, 0x1E, 0xCD, 0xC8, 0x1D, 0xCE, 0xF0, 0x10, 0x2F, 0xFF, 0xB0,
  0x10, 0x2F, 0xFF, 0xB0, 0x10, 0x2F, 0xFF, 0xB0, 0x10, 0x2F, 0xFF, 0xB8, 0x92, 0x12, 0xFE, 0xDC,
  0xA9, 0x76, 0x59, 0xC8, 0x68, 0x56, 0x89, 0xAC, 0xDA, 0x01, 0x73, 0x09, 0xC0, 0x87, 0x76, 0x0B,
  0xC0, 0xA7, 0x76, 0x0D, 0xC0, 0xC7, 0x76, 0xE7, 0x75, 0x03, 0xE0, 0x27, 0x74, 0x05, 0xE0, 0x47,
  0x74, 0x07, 0xE0, 0x67, 0x74, 0x0A, 0xE0, 0x97, 0x74, 0x0C, 0xE0, 0xB7, 0x74, 0x0E, 0xE0, 0xD7,
  0x20,
  // "•" (U+2022)
  0x58, 0x65, 0xAD, 0xEE, 0xDA, 0x57, 0x10, 0x30, 0xDF, 0x90, 0xC0, 0x35, 0x04, 0xFD, 0x03, 0x30,
  0x10, 0xEF, 0xD0, 0xE3, 0x07, 0xFF, 0x07, 0x20, 0xCF, 0xF0, 0xC2, 0xFF, 0xA1, 0x01, 0xFF, 0xA0,
  0x10, 0x2F, 0xFA, 0x00, 0x2F, 0xFA, 0x02, 0x01, 0xFF, 0xA0, 0x11, 0xFF, 0xA2, 0x0C, 0xFF, 0x0B,
  0x20, 0x7F, 0xF0, 0x63, 0x0E, 0xFD, 0x0D, 0x40, 0x3F, 0xC0, 0xE0, 0x35, 0x03, 0x0D, 0xF9, 0x0C,
  0x02, 0x71, 0x86, 0x5A, 0xDE, 0xED, 0xA4, 0x50,
  // "…" (U+2026)
  0x38, 0x42, 0x57, 0x75, 0x16, 0x84, 0x25, 0x77, 0x51, 0x68, 0x42, 0x57, 0x75, 0x15, 0x0A, 0xE0,
  0x84, 0x0A, 0xE0, 0x84, 0x0A, 0xE0, 0x83, 0x0A, 0xF9, 0x08, 0x20, 0xAF, 0x90, 0x82, 0x0A, 0xF9,
  0x81, 0x80, 0x2F, 0xB0, 0x10, 0x2F, 0xB0, 0x10, 0x2F, 0xB0, 0x10, 0x5F, 0xB0, 0x40, 0x5F, 0xB0,
  0x40, 0x5F, 0xB0, 0x40, 0x6F, 0xB0, 0x50, 0x6F, 0xB0, 0x50, 0x6F, 0xB0, 0x05, 0xFB, 0x04, 0x05,
  0xFB, 0x04, 0x05, 0xFB, 0x04, 0x01, 0xFA, 0x81, 0xE1, 0x1F, 0xA8, 0x1E, 0x11, 0xFA, 0x82, 0xE1,
  0x09, 0xF9, 0x07, 0x20, 0x9F, 0x90, 0x72, 0x09, 0xF9, 0x07, 0x30, 0x8D, 0x0E, 0x07, 0x40, 0x8D,
  0x0E, 0x07, 0x40, 0x8D, 0x0E, 0x07, 0x58, 0x41, 0x57, 0x75, 0x16, 0x84, 0x15, 0x77, 0x51, 0x68,
  0x41, 0x57, 0x75, 0x13,
  // "‰" (U+2030)
  0x48, 0x32, 0x57, 0x63, 0x77, 0x76, 0x01, 0x0B, 0xD0, 0xC0, 0x37, 0x77, 0x30, 0x10, 0xDF, 0x0E,
  0x03, 0x77, 0x72, 0x0A, 0xFA, 0x0D, 0x77, 0x71, 0x02, 0xFC, 0x06, 0x77, 0x70, 0x7C, 0x81, 0xE9,
  0xDC, 0x0B, 0x77, 0x70, 0xAC, 0x81, 0x60, 0x2C, 0x0E, 0x77, 0x70, 0xCC, 0x01, 0x20, 0xDC, 0x01,
  0x77, 0x60, 0xDC, 0x30, 0xCC, 0x02, 0x77, 0x60, 0xEC, 0x30, 0xCC, 0x03, 0x77, 0x60, 0xDC, 0x30,
  0xCC, 0x02, 0x77, 0x60, 0xBC, 0x03, 0x20, 0xEC, 0x70, 0x58, 0x02, 0xA0, 0x36, 0x08, 0xC8, 0x1B,
  0x17, 0xC0, 0xD5, 0x01, 0x0A, 0xD0, 0xD0, 0x37, 0x04, 0xFC, 0x09, 0x40, 0x30, 0xDD, 0x09, 0x73,
  0x0D, 0xFB, 0x03, 0x30, 0x8D, 0x0E, 0x05, 0x74, 0x04, 0xFA, 0x09, 0x20, 0x20, 0xCD, 0x0C, 0x02,
  0x76, 0x06, 0xF0, 0xB2, 0x05, 0x0E, 0xD0, 0x77, 0x72, 0x89, 0x03, 0x9D, 0xFE, 0xB5, 0x01, 0xAD,
  0x0D, 0x03, 0x77, 0x73, 0x03, 0x0D, 0xD0, 0xA7, 0x77, 0x40, 0x7D, 0x0E, 0x05, 0x77, 0x73, 0x02,
  0x0C, 0xD0, 0xC0, 0x27, 0x77, 0x30, 0x50, 0xED, 0x07, 0x77, 0x74, 0x0A, 0xD0, 0xD0, 0x37, 0x77,
  0x30, 0x30, 0xDD, 0x0A, 0x01, 0x77, 0x73, 0x07, 0xD0, 0xE0, 0x57, 0x77, 0x30, 0x20, 0xCD, 0x89,
  0x0C, 0x20, 0x5B, 0xEF, 0xD8, 0x17, 0x85, 0x5B, 0xEF, 0xD9, 0x23, 0x80, 0x31, 0x20, 0xBE, 0x0E,
  0x04, 0x50, 0xBE, 0x0E, 0x04, 0x73, 0x0A, 0xF9, 0x0E, 0x02, 0x30, 0x9F, 0xA0, 0x27, 0x10, 0x3F,
  0xB0, 0xB2, 0x02, 0xFB, 0x0B, 0x71, 0x09, 0xFC, 0x81, 0x20, 0x8F, 0xC0, 0x27, 0x0D, 0xC8, 0x17,
  0x1B, 0xC8, 0x17, 0x0D, 0xC8, 0x17, 0x1B, 0xC0, 0x76, 0x01, 0xC0, 0xE2, 0x04, 0xC0, 0xA1, 0xC0,
  0xE2, 0x04, 0xC0, 0xA6, 0x02, 0xC0, 0xC2, 0x02, 0xC0, 0xC0, 0x2C, 0x0C, 0x20, 0x2C, 0x0C, 0x60,
  0x3C, 0x0B, 0x20, 0x1C, 0x0D, 0x02, 0xC0, 0xB2, 0x01, 0xC0, 0xD6, 0x03, 0xC0, 0xB2, 0x01, 0xC0,
  0xD0, 0x3C, 0x0B, 0x20, 0x1C, 0x0E, 0x60, 0x3C, 0x0B, 0x20, 0x2C, 0x0C, 0x02, 0xC0, 0xB2, 0x01,
  0xC0, 0xD6, 0x01, 0xC0, 0xD2, 0x03, 0xC0, 0xB0, 0x1C, 0x0D, 0x20, 0x3C, 0x0B, 0x70, 0xEC, 0x81,
  0x20, 0x7C, 0x81, 0x80, 0xDC, 0x81, 0x20, 0x7C, 0x09, 0x70, 0xAC, 0x81, 0xD9, 0xEC, 0x81, 0x40,
  0xAC, 0x81, 0xD9, 0xEC, 0x05, 0x70, 0x5F, 0xB0, 0xE2, 0x04, 0xFB, 0x0E, 0x72, 0x0C, 0xFA, 0x07,
  0x30, 0xCF, 0xA0, 0x77, 0x20, 0x30, 0xEF, 0x0B, 0x40, 0x20, 0xEF, 0x0C, 0x74, 0x03, 0x0C, 0xD0,
  0x96, 0x02, 0x0C, 0xD0, 0x97, 0x78, 0x33, 0x67, 0x51, 0x72, 0x83, 0x36, 0x75, 0x14,
  // "‹" (U+2039)
  0x73, 0x81, 0x1B, 0x47, 0x71, 0x0C, 0xA0, 0xB0, 0x37, 0x50, 0xAD, 0x0A, 0x01, 0x72, 0x07, 0xF9,
  0x02, 0x70, 0x4F, 0x90, 0x97, 0x02, 0x0E, 0xF0, 0xB7, 0x01, 0x0D, 0xF0, 0xD0, 0x17, 0x0B, 0xF9,
  0x03, 0x70, 0x8F, 0x90, 0x67, 0x05, 0xF9, 0x09, 0x70, 0x3F, 0x90, 0xB7, 0x01, 0x0D, 0xF0, 0xD0,
  0x17, 0x0C, 0xF9, 0x03, 0x70, 0x6F, 0x90, 0x77, 0x10, 0x20, 0xEF, 0x0D, 0x01, 0x71, 0x04, 0xF9,
  0x0B, 0x72, 0x06, 0xF9, 0x09, 0x72, 0x09, 0xF9, 0x06, 0x72, 0x0B, 0xF9, 0x03, 0x71, 0x01, 0x0D,
  0xF0, 0xD0, 0x17, 0x10, 0x30, 0xEF, 0x0B, 0x72, 0x05, 0xF9, 0x09, 0x72, 0x07, 0xF9, 0x06, 0x72,
  0x0A, 0xF9, 0x02, 0x72, 0x0C, 0xD0, 0xD0, 0x57, 0x30, 0x10, 0xEA, 0x0E, 0x07, 0x76, 0x82, 0x3E,
  0x81, 0x40,
  // "›" (U+203A)
  0x48, 0x21, 0x8E, 0x37, 0x60, 0x70, 0xEA, 0x0E, 0x01, 0x73, 0x05, 0x0D, 0xD0, 0xC7, 0x20, 0x2F,
  0x90, 0xA7, 0x20, 0x6F, 0x90, 0x77, 0x20, 0x9F, 0x90, 0x57, 0x20, 0xBF, 0x0E, 0x02, 0x71, 0x01,
  0x0D, 0xF0, 0xD0, 0x17, 0x10, 0x3F, 0x90, 0xB7, 0x20, 0x6F, 0x90, 0x97, 0x20, 0x9F, 0x90, 0x67,
  0x20, 0xBF, 0x90, 0x47, 0x10, 0x10, 0xDF, 0x0E, 0x02, 0x71, 0x07, 0xF9, 0x06, 0x70, 0x3F, 0x90,
  0xC7, 0x01, 0x0D, 0xF0, 0xD0, 0x17, 0x0B, 0xF9, 0x03, 0x70, 0x9F, 0x90, 0x57, 0x06, 0xF9, 0x08,
  0x70, 0x3F, 0x90, 0xB7, 0x01, 0x0D, 0xF0, 0xD0, 0x17, 0x0B, 0xF0, 0xE0, 0x27, 0x09, 0xF9, 0x04,
  0x70, 0x2F, 0x90, 0x77, 0x20, 0x20, 0xAD, 0x0A, 0x75, 0x03, 0x0B, 0xA0, 0xC7, 0x71, 0x81, 0x4B,
  0x17, 0x30,
  // "⁄" (U+2044)
  0x77, 0x30, 0x9D, 0x0C, 0x77, 0x20, 0x1E, 0x05, 0x77, 0x20, 0x7D, 0x0E, 0x77, 0x30, 0xDD, 0x08,
  0x77, 0x20, 0x4E, 0x02, 0x77, 0x20, 0xBD, 0x0A, 0x77, 0x20, 0x2E, 0x04, 0x77, 0x20, 0x8D, 0x0D,
  0x77, 0x30, 0xED, 0x07, 0x77, 0x20, 0x6E, 0x01, 0x77, 0x20, 0xCD, 0x09, 0x77, 0x20, 0x3E, 0x03,
  0x77, 0x20, 0xAD, 0x0C, 0x77, 0x20, 0x1E, 0x05, 0x77, 0x20, 0x7D, 0x0E, 0x77, 0x30, 0xDD, 0x08,
  0x77, 0x20, 0x5E, 0x01, 0x77, 0x20, 0xBD, 0x0A, 0x77, 0x20, 0x2E, 0x04, 0x77, 0x20, 0x9D, 0x0D,
  0x77, 0x30, 0xED, 0x06, 0x77, 0x20, 0x6D, 0x0E, 0x01, 0x77, 0x20, 0xDD, 0x09, 0x77, 0x20, 0x4E,
  0x03, 0x77, 0x20, 0xAD, 0x0C, 0x77, 0x20, 0x1E, 0x05, 0x77, 0x20, 0x7D, 0x0E, 0x77, 0x30, 0xED,
  0x08, 0x77, 0x20, 0x5E, 0x01, 0x77, 0x20, 0xBD, 0x0A, 0x77, 0x20, 0x2E, 0x04, 0x77, 0x20, 0x9D,
  0x0D, 0x77, 0x20, 0x10, 0xED, 0x06, 0x77, 0x20, 0x6D, 0x0E, 0x01, 0x77, 0x20, 0xDD, 0x09, 0x77,
  0x20, 0x4E, 0x03, 0x77, 0x20, 0xAD, 0x0C, 0x77, 0x20, 0x1E, 0x05, 0x77, 0x20, 0x8D, 0x0E, 0x77,
  0x30, 0xED, 0x08, 0x77, 0x20, 0x5E, 0x01, 0x77, 0x20, 0xCD, 0x0A, 0x77, 0x30,
  // "™" (U+2122)
  0xFF, 0x81, 0xB0, 0x9D, 0x0D, 0x60, 0x6F, 0xFE, 0x81, 0xB0, 0x9E, 0x02, 0x50, 0xBF, 0xFE, 0x81,
  0xB0, 0x9E, 0x07, 0x40, 0x1F, 0xFF, 0x81, 0xB0, 0x9E, 0x0C, 0x40, 0x6F, 0x50, 0x8B, 0x0D, 0x60,
  0x9F, 0x01, 0x30, 0xBF, 0x50, 0x8B, 0x0D, 0x60, 0x9B, 0x09, 0xB0, 0x62, 0x01, 0xB0, 0x9C, 0x50,
  0x8B, 0x0D, 0x60, 0x9B, 0x07, 0x0D, 0xA0, 0xB2, 0x06, 0xA0, 0xE0, 0x5C, 0x50, 0x8B, 0x0D, 0x60,
  0x9B, 0x00, 0x8B, 0x81, 0x10, 0xCA, 0x0A, 0x06, 0xC5, 0x08, 0xB0, 0xD6, 0x09, 0xB0, 0x80, 0x3B,
  0x05, 0x01, 0xB0, 0x40, 0x6C, 0x50, 0x8B, 0x0D, 0x60, 0x9B, 0x81, 0x90, 0xEA, 0x0A, 0x07, 0xA8,
  0x1E, 0x06, 0xC5, 0x08, 0xB0, 0xD6, 0x09, 0xB8, 0x19, 0x09, 0xA0, 0xE0, 0xCA, 0x81, 0x90, 0x6C,
  0x50, 0x8B, 0x0D, 0x60, 0x9B, 0x81, 0x90, 0x4E, 0x81, 0x40, 0x6C, 0x50, 0x8B, 0x0D, 0x60, 0x9B,
  0x09, 0x20, 0xEC, 0x0E, 0x20, 0x6C, 0x50, 0x8B, 0x0D, 0x60, 0x9B, 0x09, 0x20, 0xAC, 0x09, 0x20,
  0x6C, 0x50, 0x8B, 0x0D, 0x60, 0x9B, 0x09, 0x20, 0x5C, 0x04, 0x20, 0x6C, 0x50, 0x8B, 0x0D, 0x60,
  0x9B, 0x09, 0x20, 0x18, 0x00, 0xC3, 0x06, 0xC5, 0x08, 0xB0, 0xD6, 0x09, 0xB0, 0x97, 0x30, 0x6C,
  0x50, 0x8B, 0x0D, 0x60, 0x9B, 0x09, 0x73, 0x06, 0xC5, 0x08, 0xB0, 0xD6, 0x09, 0xB0, 0x97, 0x30,
  0x6C, 0x50, 0x8B, 0x0D, 0x60, 0x9B, 0x09, 0x73, 0x06, 0xC5, 0x08, 0xB0, 0xC6, 0x09, 0xB0, 0x87,
  0x30, 0x6C,
  // "⅒" (U+2152)
  0x71, 0x05, 0x0E, 0xC8, 0x09, 0x85, 0x00, 0x10, 0xAE, 0x77, 0x71, 0x09, 0xD0, 0xC8, 0x0C, 0x70,
  0x04, 0x0D, 0xF7, 0x77, 0x01, 0xE0, 0x58, 0x0C, 0x60, 0x09, 0xFA, 0x77, 0x70, 0x7D, 0x0E, 0x80,
  0xC5, 0x00, 0x30, 0xDF, 0xB7, 0x77, 0x0D, 0xD0, 0x88, 0x0C, 0x40, 0x08, 0xFD, 0x77, 0x60, 0x4E,
  0x02, 0x80, 0xC3, 0x00, 0x10, 0xEF, 0xD7, 0x76, 0x0B, 0xD0, 0xA8, 0x0C, 0x50, 0x05, 0xD0, 0x70,
  0x9D, 0x77, 0x50, 0x2E, 0x04, 0x80, 0xC6, 0x00, 0xBA, 0x82, 0xC2, 0x09, 0xD7, 0x75, 0x08, 0xD0,
  0xD8, 0x0C, 0x70, 0x81, 0x2E, 0x73, 0x0A, 0xD7, 0x75, 0x0E, 0xD0, 0x78, 0x0D, 0x50, 0x0A, 0xD7,
  0x74, 0x06, 0xE0, 0x18, 0x0D, 0x50, 0x0B, 0xD7, 0x74, 0x0C, 0xD0, 0x98, 0x0D, 0x60, 0x0B, 0xD7,
  0x73, 0x03, 0xE0, 0x38, 0x0D, 0x60, 0x0B, 0xD7, 0x73, 0x0A, 0xD0, 0xC8, 0x0D, 0x70, 0x0B, 0xD7,
  0x72, 0x01, 0xE0, 0x58, 0x0D, 0x70, 0x0B, 0xD7, 0x72, 0x07, 0xD0, 0xE8, 0x0E, 0x00, 0x0B, 0xD7,
  0x72, 0x0D, 0xD0, 0x88, 0x0E, 0x00, 0x0B, 0xD7, 0x71, 0x05, 0xE0, 0x17, 0x20, 0x50, 0xEC, 0x76,
  0x89, 0x03, 0x8C, 0xDF, 0xED, 0xA5, 0x17, 0x70, 0xBD, 0x77, 0x10, 0xBD, 0x0A, 0x71, 0x01, 0x0A,
  0xE7, 0x40, 0x10, 0xAF, 0xA0, 0xE0, 0x67, 0x60, 0xBD, 0x77, 0x02, 0xE0, 0x47, 0x04, 0x0D, 0xF7,
  0x30, 0x20, 0xEF, 0xD0, 0xA7, 0x50, 0xBD, 0x77, 0x09, 0xD0, 0xD7, 0x09, 0xFA, 0x72, 0x01, 0x0D,
  0xFF, 0x0A, 0x71, 0x82, 0x23, 0x4C, 0xD8, 0x26, 0x43, 0x17, 0x30, 0xED, 0x06, 0x50, 0x30, 0xDF,
  0xB7, 0x20, 0x8F, 0xFA, 0x05, 0x40, 0x90, 0xEF, 0xF9, 0x0C, 0x70, 0x6D, 0x0E, 0x01, 0x40, 0x8F,
  0xD7, 0x10, 0x1E, 0x84, 0xD5, 0x11, 0x4C, 0xD0, 0xD4, 0x0B, 0xFF, 0xA0, 0xE7, 0x0D, 0xD0, 0x94,
  0x01, 0x0E, 0xFD, 0x71, 0x07, 0xD0, 0xD0, 0x15, 0x0C, 0xD0, 0x53, 0x0B, 0xFF, 0xA0, 0xE6, 0x04,
  0xE0, 0x35, 0x05, 0xD0, 0x70, 0x9D, 0x71, 0x0C, 0xD0, 0x56, 0x03, 0xD0, 0xA3, 0x0B, 0xFF, 0xA0,
  0xE6, 0x0A, 0xD0, 0xC7, 0x0B, 0xA8, 0x2C, 0x20, 0x9D, 0x71, 0xD0, 0xE7, 0x10, 0xCC, 0x0E, 0x77,
  0x75, 0x01, 0xE0, 0x57, 0x81, 0x2E, 0x73, 0x0A, 0xD7, 0x03, 0xD0, 0xB7, 0x10, 0x7D, 0x02, 0x77,
  0x74, 0x07, 0xD0, 0xE7, 0x70, 0xAD, 0x70, 0x5D, 0x08, 0x71, 0x05, 0xD0, 0x47, 0x77, 0x40, 0xED,
  0x08, 0x77, 0x0B, 0xD7, 0x06, 0xD0, 0x67, 0x10, 0x3D, 0x05, 0x77, 0x73, 0x05, 0xE0, 0x17, 0x70,
  0xBD, 0x70, 0x7D, 0x06, 0x71, 0x02, 0xD0, 0x67, 0x77, 0x30, 0xBD, 0x0A, 0x77, 0x10, 0xBD, 0x70,
  0x7D, 0x05, 0x71, 0x02, 0xD0, 0x77, 0x77, 0x20, 0x2E, 0x04, 0x77, 0x10, 0xBD, 0x70, 0x6D, 0x06,
  0x71, 0x02, 0xD0, 0x67, 0x77, 0x20, 0x9D, 0x0D, 0x77, 0x20, 0xBD, 0x70, 0x5D, 0x07, 0x71, 0x03,
  0xD0, 0x67, 0x77, 0x10, 0x10, 0xED, 0x06, 0x77, 0x20, 0xBD, 0x70, 0x4D, 0x08, 0x71, 0x05, 0xD0,
  0x47, 0x77, 0x10, 0x6D, 0x0E, 0x01, 0x77, 0x20, 0xBD, 0x70, 0x1D, 0x0B, 0x71, 0x08, 0xD0, 0x27,
  0x77, 0x10, 0xDD, 0x09, 0x77, 0x30, 0xBD, 0x71, 0x0E, 0xC0, 0xE7, 0x10, 0xCC, 0x0E, 0x77, 0x71,
  0x04, 0xE0, 0x37, 0x73, 0x0B, 0xD7, 0x10, 0xAD, 0x05, 0x60, 0x3D, 0x0B, 0x77, 0x71, 0x0A, 0xD0,
  0xC7, 0x74, 0x0B, 0xD7, 0x10, 0x5D, 0x0D, 0x01, 0x50, 0xCD, 0x05, 0x77, 0x70, 0x1E, 0x05, 0x77,
  0x18, 0x22, 0x34, 0xCD, 0x82, 0x64, 0x31, 0x50, 0xED, 0x84, 0xD5, 0x11, 0x5C, 0xD0, 0xE7, 0x77,
  0x10, 0x8D, 0x0E, 0x76, 0x09, 0x0E, 0xFF, 0x90, 0xC3, 0x05, 0xFF, 0xA0, 0x67, 0x77, 0x10, 0xED,
  0x08, 0x76, 0x0B, 0xFF, 0xA0, 0xE4, 0x0B, 0xFF, 0x0C, 0x77, 0x71, 0x05, 0xE0, 0x17, 0x60, 0xBF,
  0xFA, 0x0E, 0x50, 0xBF, 0xD0, 0xC0, 0x17, 0x77, 0x10, 0xCD, 0x0A, 0x77, 0x0B, 0xFF, 0xA0, 0xE6,
  0x07, 0xFB, 0x08, 0x80, 0x98, 0x20, 0x89, 0x01, 0x6B, 0xDE, 0xED, 0xB7, 0x26,
  // "∂" (U+2202)
  0x74, 0x83, 0x37, 0xAD, 0xEA, 0x82, 0xEC, 0x94, 0x77, 0x28, 0x12, 0x9E, 0xFC, 0x0D, 0x05, 0x76,
  0x0A, 0xFF, 0xA0, 0xA7, 0x5F, 0xFC, 0x0C, 0x74, 0xFF, 0xD0, 0xA7, 0x3F, 0xFE, 0x04, 0x72, 0xFF,
  0xE0, 0xC7, 0x2C, 0x86, 0xC6, 0x31, 0x02, 0x6D, 0xFA, 0x04, 0x71, 0xA0, 0xA0, 0x27, 0x10, 0xAF,
  0x90, 0x97, 0x10, 0xC0, 0x37, 0x40, 0xCF, 0x0E, 0x77, 0x70, 0x3F, 0x90, 0x37, 0x77, 0x0C, 0xF0,
  0x57, 0x77, 0x08, 0xF0, 0x77, 0x38, 0x73, 0x8B, 0xDE, 0xFD, 0xB6, 0x20, 0x6F, 0x09, 0x71, 0x04,
  0x0C, 0xFA, 0x81, 0xD3, 0x5F, 0x0A, 0x70, 0x8F, 0xD0, 0xE0, 0x8F, 0x0B, 0x60, 0xBF, 0xFF, 0x90,
  0xC5, 0x0B, 0xFF, 0xFA, 0x0C, 0x40, 0x9F, 0xFF, 0xB0, 0xB3, 0x04, 0xFB, 0x83, 0xB7, 0x79, 0xEF,
  0xB0, 0xA3, 0x0C, 0xF9, 0x0E, 0x04, 0x50, 0x9F, 0xA0, 0x92, 0x05, 0xF9, 0x0E, 0x02, 0x70, 0xBF,
  0x90, 0x72, 0x0D, 0xF9, 0x04, 0x71, 0x04, 0xF9, 0x81, 0x50, 0x3F, 0x90, 0xA7, 0x20, 0x4F, 0x98,
  0x13, 0x08, 0xF9, 0x02, 0x72, 0x07, 0xF9, 0x81, 0x10, 0xEF, 0x0C, 0x73, 0x0A, 0xF8, 0x1D, 0x02,
  0xF9, 0x06, 0x73, 0x0E, 0xF8, 0x19, 0x05, 0xF9, 0x02, 0x72, 0x04, 0xF9, 0x81, 0x60, 0x8F, 0x0E,
  0x73, 0x09, 0xF9, 0x81, 0x10, 0xAF, 0x0B, 0x73, 0x0E, 0xF0, 0xC2, 0x0B, 0xF0, 0x97, 0x20, 0x4F,
  0x90, 0x62, 0x0D, 0xF0, 0x87, 0x20, 0xBF, 0x90, 0x12, 0x0D, 0xF0, 0x87, 0x10, 0x4F, 0x90, 0x93,
  0x0C, 0xF0, 0x97, 0x10, 0xDF, 0x90, 0x23, 0x0A, 0xF0, 0xB7, 0x09, 0xF9, 0x0A, 0x40, 0x7F, 0x90,
  0x25, 0x08, 0xF9, 0x0E, 0x01, 0x40, 0x3F, 0x90, 0xC0, 0x22, 0x03, 0x0B, 0xFA, 0x06, 0x60, 0xDF,
  0xA0, 0x0E, 0xFB, 0x0B, 0x70, 0x7F, 0xFE, 0x0D, 0x01, 0x71, 0x0D, 0xFF, 0xC0, 0xD0, 0x17, 0x20,
  0x3F, 0xFB, 0x0C, 0x01, 0x74, 0x05, 0x0E, 0xFF, 0x08, 0x77, 0x02, 0x0C, 0xFC, 0x0A, 0x02, 0x77,
  0x38, 0x23, 0x8B, 0xEA, 0x83, 0xEC, 0xA6, 0x17, 0x60,
  // "∆" (U+2206)
  0x76, 0xFB, 0x01, 0x77, 0x73, 0x05, 0xFB, 0x06, 0x77, 0x73, 0x0A, 0xFB, 0x0B, 0x77, 0x73, 0x0E,
  0xFC, 0x01, 0x77, 0x71, 0x05, 0xFD, 0x06, 0x77, 0x71, 0x0A, 0xFD, 0x0B, 0x77, 0x71, 0x0E, 0xFE,
  0x01, 0x77, 0x60, 0x5F, 0xF0, 0x57, 0x76, 0x0A, 0xE0, 0x0C, 0xE0, 0xA7, 0x76, 0x0E, 0xE0, 0x08,
  0xF7, 0x75, 0x04, 0xF0, 0x04, 0xF0, 0x57, 0x74, 0x09, 0xF2, 0xF0, 0xA7, 0x74, 0x0E, 0xE0, 0xB2,
  0x0B, 0xE0, 0xE7, 0x73, 0x04, 0xF0, 0x62, 0x06, 0xF0, 0x57, 0x72, 0x09, 0xF0, 0x22, 0x02, 0xF0,
  0xA7, 0x72, 0x0E, 0xE0, 0xC4, 0x0C, 0xE0, 0xE7, 0x71, 0x04, 0xF0, 0x84, 0x08, 0xF0, 0x47, 0x70,
  0x9F, 0x03, 0x40, 0x3F, 0x09, 0x77, 0x0E, 0xE0, 0xE6, 0x0D, 0xE0, 0xE7, 0x60, 0x4F, 0x09, 0x60,
  0x9F, 0x04, 0x75, 0x09, 0xF0, 0x46, 0x04, 0xF0, 0x97, 0x50, 0xEE, 0x0E, 0x71, 0x0E, 0xE0, 0xE7,
  0x40, 0x3F, 0x0A, 0x71, 0x0A, 0xF0, 0x47, 0x30, 0x8F, 0x05, 0x71, 0x05, 0xF0, 0x97, 0x30, 0xDF,
  0x01, 0x71, 0x01, 0xF0, 0xD7, 0x20, 0x3F, 0x0B, 0x73, 0x0B, 0xF0, 0x37, 0x10, 0x8F, 0x07, 0x73,
  0x06, 0xF0, 0x87, 0x10, 0xDF, 0x02, 0x73, 0x01, 0xF0, 0xD7, 0x03, 0xF0, 0xD7, 0x50, 0xCF, 0x03,
  0x60, 0x8F, 0x08, 0x75, 0x07, 0xF0, 0x86, 0x0D, 0xF0, 0x37, 0x50, 0x3F, 0x0D, 0x50, 0x3F, 0x0E,
  0x77, 0x0D, 0xF0, 0x34, 0x08, 0xF0, 0x97, 0x70, 0x8F, 0x08, 0x40, 0xDF, 0x05, 0x77, 0x04, 0xF0,
  0xD3, 0x02, 0xF9, 0x77, 0x20, 0xEF, 0x02, 0x20, 0x8F, 0x0B, 0x77, 0x20, 0xAF, 0x07, 0x20, 0xDF,
  0xFF, 0xFC, 0x81, 0xC0, 0x2F, 0xFF, 0xFE, 0x02, 0x06, 0xFF, 0xFF, 0xE0, 0x06, 0xFF, 0xFF, 0xE0,
  0x06, 0xFF, 0xFF, 0xE0, 0x06, 0xFF, 0xFF, 0xE0, 0x06, 0xFF, 0xFF, 0xE0, 0x60,
  // "√" (U+221A)
  0x77, 0x77, 0x08, 0xE0, 0x67, 0x77, 0x70, 0xCE, 0x01, 0x77, 0x76, 0x01, 0xE0, 0xB7, 0x77, 0x70,
  0x6E, 0x06, 0x77, 0x77, 0x0B, 0xE0, 0x27, 0x77, 0x7E, 0x0C, 0x77, 0x77, 0x05, 0xE0, 0x77, 0x77,
  0x70, 0xAE, 0x02, 0x77, 0x77, 0x0E, 0xD0, 0xD7, 0x77, 0x70, 0x4E, 0x08, 0x77, 0x77, 0x08, 0xE0,
  0x37, 0x77, 0x70, 0xDD, 0x0E, 0x77, 0x77, 0x02, 0xE0, 0x97, 0x77, 0x70, 0x7E, 0x04, 0x77, 0x77,
  0x0C, 0xD0, 0xE7, 0x77, 0x70, 0x1E, 0x0A, 0x77, 0x77, 0x06, 0xE0, 0x57, 0x77, 0x70, 0xBE, 0x01,
  0x77, 0x77, 0xE0, 0xB7, 0x77, 0x70, 0x5E, 0x06, 0x77, 0x77, 0x09, 0xE0, 0x17, 0x77, 0x70, 0xED,
  0x0C, 0x77, 0x77, 0x03, 0xE0, 0x77, 0x02, 0x80, 0x5E, 0x06, 0x73, 0x08, 0xE0, 0x27, 0x02, 0xFA,
  0x0C, 0x73, 0x0D, 0xD0, 0xD7, 0x10, 0x2F, 0xB0, 0x27, 0x10, 0x2E, 0x08, 0x71, 0x02, 0xFB, 0x08,
  0x71, 0x07, 0xE0, 0x37, 0x10, 0x2F, 0xB0, 0xD7, 0x10, 0xBD, 0x0D, 0x72, 0x02, 0xFC, 0x03, 0x60,
  0x1E, 0x09, 0x72, 0x02, 0xFC, 0x09, 0x60, 0x5E, 0x04, 0x77, 0x10, 0xCD, 0x0E, 0x60, 0xAD, 0x0E,
  0x77, 0x20, 0x6E, 0x05, 0x50, 0xED, 0x09, 0x77, 0x20, 0x1E, 0x0A, 0x40, 0x4E, 0x05, 0x77, 0x30,
  0xAE, 0x01, 0x30, 0x9E, 0x77, 0x40, 0x4E, 0x06, 0x30, 0xED, 0x0A, 0x77, 0x50, 0xDD, 0x0C, 0x20,
  0x3E, 0x06, 0x77, 0x50, 0x8E, 0x81, 0x20, 0x8E, 0x01, 0x77, 0x50, 0x2E, 0x81, 0x70, 0xCD, 0x0B,
  0x77, 0x70, 0xCD, 0x0D, 0x02, 0xE0, 0x67, 0x77, 0x06, 0xE0, 0xAE, 0x02, 0x77, 0x71, 0x0E, 0xFC,
  0x0C, 0x77, 0x72, 0x0A, 0xFC, 0x07, 0x77, 0x72, 0x04, 0xFC, 0x02, 0x77, 0x73, 0x0D, 0xFA, 0x0D,
  0x77, 0x74, 0x08, 0xFA, 0x08, 0x77, 0x74, 0x02, 0xFA, 0x03, 0x77, 0x75, 0x0B, 0xF0, 0xE7, 0x77,
  0x60, 0x5F, 0x09, 0x77, 0x77, 0x0E, 0xE0, 0x47, 0x77, 0x70, 0x9D, 0x0E, 0x77, 0x77, 0x10, 0x3D,
  0x0A, 0x77, 0x20,
  // "∞" (U+221E)
  0x68, 0x53, 0x79, 0xA8, 0x51, 0x73, 0x85, 0x16, 0x9A, 0x97, 0x37, 0x30, 0x20, 0xCE, 0x0E, 0x08,
  0x71, 0x07, 0x0E, 0xE0, 0xC0, 0x37, 0x03, 0x0E, 0xFA, 0x0C, 0x01, 0x50, 0xBF, 0xB0, 0x45, 0x02,
  0xFD, 0x0D, 0x03, 0x30, 0xCF, 0xD0, 0x34, 0x0C, 0xFE, 0x82, 0xE2, 0x0B, 0xFE, 0x0D, 0x30, 0x5F,
  0xF9, 0x0E, 0x0A, 0xFF, 0x90, 0x52, 0x0C, 0xD8, 0x3D, 0x30, 0x29, 0xFD, 0x83, 0x71, 0x04, 0xED,
  0x0B, 0x2E, 0x03, 0x40, 0x6F, 0xB0, 0x54, 0x04, 0xE1, 0x03, 0xD0, 0xB6, 0x07, 0xF9, 0x07, 0x60,
  0xCD, 0x02, 0x04, 0xD0, 0x87, 0x0B, 0xE0, 0xA7, 0x09, 0xD0, 0x30, 0x4D, 0x08, 0x70, 0x6E, 0x07,
  0x70, 0x9D, 0x00, 0x3D, 0x0A, 0x60, 0x20, 0xEF, 0x03, 0x60, 0xBD, 0x02, 0x01, 0xE0, 0x14, 0x01,
  0x0D, 0xF9, 0x0D, 0x01, 0x40, 0x2E, 0x20, 0xDD, 0x0A, 0x30, 0x30, 0xDF, 0xB0, 0xD0, 0x32, 0x01,
  0x0C, 0xD0, 0xC2, 0x08, 0xE8, 0x1E, 0xCD, 0xFF, 0x0D, 0x0C, 0xF0, 0x62, 0x01, 0xFF, 0x90, 0x30,
  0xBF, 0xF0, 0xD4, 0x06, 0xFE, 0x82, 0x40, 0x1D, 0xFE, 0x04, 0x50, 0x9F, 0xB0, 0xE0, 0x43, 0x01,
  0x0D, 0xFC, 0x06, 0x70, 0x60, 0xEF, 0x0D, 0x03, 0x50, 0x10, 0xBF, 0x90, 0xE0, 0x47, 0x28, 0x61,
  0x7B, 0xEF, 0xEB, 0x67, 0x28, 0x15, 0xAD, 0xA8, 0x1E, 0xB6, 0x60,
  // "≈" (U+2248)
  0x38, 0x23, 0x8C, 0xEA, 0x83, 0xED, 0xA7, 0x27, 0x78, 0x34, 0x50, 0x1A, 0xFC, 0x81, 0xD8, 0x37,
  0x28, 0x41, 0x9F, 0x73, 0xEF, 0xF9, 0x82, 0xE9, 0x52, 0x28, 0x11, 0x49, 0xB0, 0x70, 0x8F, 0xFF,
  0xF0, 0x70, 0x8F, 0xFF, 0xF0, 0x70, 0x8F, 0xFF, 0xF0, 0x70, 0x8A, 0x82, 0xE9, 0x42, 0x28, 0x22,
  0x59, 0xEF, 0xF9, 0x84, 0xE3, 0x8F, 0x91, 0x72, 0x81, 0x39, 0xEF, 0xC8, 0x3A, 0x10, 0x74, 0x77,
  0x89, 0x13, 0x8B, 0xDE, 0xFE, 0xDB, 0x72, 0x80, 0xF7, 0x08, 0x16, 0xAD, 0xA8, 0x2E, 0xC9, 0x47,
  0x71, 0x02, 0x05, 0x20, 0x40, 0xDF, 0xA8, 0x1D, 0x71, 0x74, 0x83, 0x2D, 0x70, 0x6F, 0xF0, 0x90,
  0x37, 0x18, 0x35, 0xEF, 0x75, 0xFF, 0xB8, 0x1D, 0x73, 0x28, 0x12, 0x6C, 0xB0, 0x70, 0x8F, 0xFF,
  0xF0, 0x70, 0x8F, 0xFF, 0xF0, 0x70, 0x8B, 0x81, 0xB5, 0x12, 0x81, 0x37, 0xCF, 0xFB, 0x83, 0x48,
  0xFE, 0x57, 0x10, 0x30, 0xAF, 0xF8, 0x35, 0x08, 0xD2, 0x74, 0x81, 0x28, 0xEF, 0xA0, 0xD0, 0x32,
  0x06, 0x02, 0x77, 0x18, 0x75, 0x9D, 0xEF, 0xED, 0x95, 0x40,
  // "≠" (U+2260)
  0x77, 0x30, 0xA0, 0x67, 0x77, 0x40, 0x3A, 0x81, 0xE9, 0x37, 0x77, 0x10, 0x9D, 0x0D, 0x05, 0x77,
  0x60, 0xEE, 0x05, 0x77, 0x50, 0x5E, 0x0E, 0x77, 0x60, 0xBE, 0x09, 0x77, 0x50, 0x1F, 0x03, 0x77,
  0x50, 0x7E, 0x0D, 0x60, 0xCF, 0xFF, 0xD0, 0x0C, 0xFF, 0xFD, 0x00, 0xCF, 0xFF, 0xD0, 0x0C, 0xFF,
  0xFD, 0x00, 0xCF, 0xFF, 0xD0, 0x0C, 0xFF, 0xFD, 0x00, 0xCF, 0xFF, 0xD0, 0xC8, 0x07, 0x20, 0x9E,
  0x0C, 0x80, 0x52, 0x74, 0x0C, 0xE0, 0x67, 0x75, 0x02, 0xF0, 0x17, 0x75, 0x08, 0xE0, 0xB7, 0x76,
  0x0D, 0xE0, 0x57, 0x38, 0x05, 0x20, 0x5F, 0x03, 0x80, 0x62, 0x0C, 0xFF, 0xFD, 0x00, 0xCF, 0xFF,
  0xD0, 0x0C, 0xFF, 0xFD, 0x00, 0xCF, 0xFF, 0xD0, 0x0C, 0xFF, 0xFD, 0x00, 0xCF, 0xFF, 0xD0, 0x0C,
  0xFF, 0xFD, 0x0C, 0x60, 0x5E, 0x0E, 0x77, 0x60, 0xAE, 0x09, 0x77, 0x50, 0x1F, 0x03, 0x77, 0x50,
  0x6E, 0x0D, 0x77, 0x60, 0xCE, 0x07, 0x77, 0x68, 0x11, 0x6C, 0xC0, 0x17, 0x77, 0x28, 0x22, 0x8E,
  0xB7, 0x77, 0x60, 0x17, 0x72,
  // "≤" (U+2264)
  0x77, 0x76, 0x81, 0x18, 0x77, 0x77, 0x48, 0x31, 0x8E, 0xF7, 0x77, 0x72, 0x81, 0x18, 0xEB, 0x07,
  0x77, 0x78, 0x11, 0x8E, 0xD0, 0x77, 0x75, 0x81, 0x18, 0xEF, 0x07, 0x77, 0x38, 0x11, 0x8E, 0xFA,
  0x07, 0x77, 0x18, 0x11, 0x8E, 0xFC, 0x06, 0x76, 0x81, 0x18, 0xEF, 0xC0, 0xA0, 0x37, 0x58, 0x11,
  0x8E, 0xFC, 0x09, 0x02, 0x75, 0x81, 0x18, 0xEF, 0xB8, 0x1E, 0x81, 0x75, 0x81, 0x18, 0xEF, 0xB0,
  0xE0, 0x77, 0x68, 0x11, 0x8E, 0xFB, 0x0D, 0x06, 0x76, 0x81, 0x18, 0xEF, 0xB0, 0xC0, 0x57, 0x68,
  0x11, 0x8E, 0xFB, 0x0B, 0x04, 0x77, 0x04, 0x0E, 0xFB, 0x0A, 0x03, 0x77, 0x20, 0x7F, 0xA0, 0x90,
  0x27, 0x74, 0x07, 0xF9, 0x0B, 0x04, 0x77, 0x50, 0x7F, 0xB8, 0x1D, 0x71, 0x77, 0x20, 0x40, 0xEF,
  0xD0, 0x90, 0x37, 0x72, 0x06, 0x0D, 0xFD, 0x0C, 0x06, 0x77, 0x20, 0x40, 0xBF, 0xD8, 0x1E, 0x82,
  0x77, 0x10, 0x20, 0x9F, 0xE0, 0xB0, 0x57, 0x71, 0x81, 0x17, 0xEF, 0xD8, 0x1E, 0x71, 0x77, 0x10,
  0x50, 0xCF, 0xE0, 0xA0, 0x47, 0x71, 0x03, 0x0A, 0xFE, 0x0D, 0x04, 0x77, 0x18, 0x12, 0x9E, 0xFC,
  0x07, 0x77, 0x38, 0x11, 0x7D, 0xFA, 0x07, 0x77, 0x60, 0x50, 0xCF, 0x07, 0x77, 0x71, 0x03, 0x0A,
  0xD0, 0x77, 0x77, 0x38, 0x11, 0x8E, 0xA0, 0x77, 0x77, 0x68, 0x16, 0xD7, 0x77, 0x77, 0x10, 0x01,
  0x80, 0xB0, 0x20, 0x10, 0x7F, 0xFF, 0xF0, 0x07, 0xFF, 0xFF, 0x00, 0x7F, 0xFF, 0xF0, 0x07, 0xFF,
  0xFF, 0x00, 0x7F, 0xFF, 0xF0, 0x07, 0xFF, 0xFF, 0x07,
  // "≥" (U+2265)
  0x81, 0x78, 0x17, 0x77, 0x68, 0x38, 0xFE, 0x81, 0x77, 0x74, 0x08, 0xB8, 0x1E, 0x81, 0x77, 0x72,
  0x08, 0xD8, 0x1E, 0x81, 0x77, 0x70, 0x8F, 0x81, 0xE8, 0x17, 0x75, 0x08, 0xFA, 0x81, 0xE8, 0x17,
  0x73, 0x06, 0xFC, 0x81, 0xE8, 0x17, 0x72, 0x03, 0x0A, 0xFC, 0x81, 0xE8, 0x17, 0x72, 0x02, 0x09,
  0xFC, 0x81, 0xE8, 0x17, 0x72, 0x81, 0x18, 0xEF, 0xB8, 0x1E, 0x81, 0x77, 0x30, 0x70, 0xEF, 0xB8,
  0x1E, 0x81, 0x77, 0x30, 0x60, 0xDF, 0xB8, 0x1E, 0x81, 0x77, 0x30, 0x50, 0xCF, 0xB8, 0x1E, 0x81,
  0x77, 0x30, 0x40, 0xBF, 0xB8, 0x1E, 0x81, 0x77, 0x30, 0x30, 0xAF, 0xB0, 0xE0, 0x47, 0x74, 0x02,
  0x09, 0xFA, 0x07, 0x77, 0x50, 0x40, 0xBF, 0x90, 0x77, 0x72, 0x81, 0x17, 0xDF, 0xB0, 0x77, 0x70,
  0x30, 0x9F, 0xD0, 0xE0, 0x47, 0x50, 0x60, 0xCF, 0xD0, 0xD0, 0x67, 0x48, 0x12, 0x8E, 0xFD, 0x0B,
  0x04, 0x74, 0x05, 0x0B, 0xFE, 0x09, 0x02, 0x73, 0x81, 0x17, 0xEF, 0xD8, 0x1E, 0x71, 0x73, 0x04,
  0x0A, 0xFE, 0x0C, 0x05, 0x74, 0x04, 0x0D, 0xFE, 0x0A, 0x03, 0x76, 0x08, 0xFC, 0x81, 0xE9, 0x27,
  0x71, 0x08, 0xFA, 0x81, 0xD7, 0x17, 0x73, 0x08, 0xF0, 0xC0, 0x57, 0x76, 0x08, 0xD0, 0xA0, 0x37,
  0x77, 0x10, 0x8A, 0x81, 0xE8, 0x17, 0x77, 0x38, 0x18, 0xD6, 0x77, 0x76, 0x01, 0x77, 0x77, 0x10,
  0x18, 0x0B, 0x02, 0x01, 0x08, 0xFF, 0xFF, 0x07, 0x08, 0xFF, 0xFF, 0x07, 0x08, 0xFF, 0xFF, 0x07,
  0x08, 0xFF, 0xFF, 0x07, 0x08, 0xFF, 0xFF, 0x07, 0x08, 0xFF, 0xFF, 0x07,
};

const Font& font_NotoSansMono_Bold_60() {
  static SmoothFont font(font_NotoSansMono_Bold_60_data);
  return font;
}

}  // namespace roo_display
