#include "27.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSans-CondensedItalic (Noto Sans Condensed Italic)
// Generated on Thu Mar 30 22:28:55 CEST 2023
static const uint8_t font_NotoSans_CondensedItalic_27_data[] PROGMEM = {
  
  // Header
  0x01, 0x01, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x09, 0xCC,
  0xF9, 0xFA, 0x19, 0x1C, 0x15, 0xFA, 0x08, 0x03, 0x1A, 0x06, 0x06, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x00, 0x01, 0x06, 0x14, 0x07, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x02, 0x0E, 0x0A, 0x14, 0x0A, 0x00, 0x36, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x0D, 0x14, 0x0D, 0x00, 0x5A, // "#" (U+0023)
  0x00, 0x24, 0x00, 0x00, 0x0B, 0x15, 0x0C, 0x00, 0xC7, // "$" (U+0024)
  0x00, 0x25, 0x01, 0x01, 0x10, 0x14, 0x12, 0x01, 0x26, // "%" (U+0025)
  0x00, 0x26, 0x00, 0x01, 0x0C, 0x14, 0x0E, 0x01, 0xBF, // "&" (U+0026)
  0x00, 0x27, 0x02, 0x0E, 0x06, 0x14, 0x05, 0x02, 0x2E, // "'" (U+0027)
  0x00, 0x28, 0x00, 0xFD, 0x08, 0x14, 0x07, 0x02, 0x43, // "(" (U+0028)
  0x00, 0x29, 0xFE, 0xFD, 0x06, 0x14, 0x07, 0x02, 0x8B, // ")" (U+0029)
  0x00, 0x2A, 0x02, 0x0B, 0x0C, 0x15, 0x0B, 0x02, 0xD2, // "*" (U+002A)
  0x00, 0x2B, 0x01, 0x04, 0x0C, 0x10, 0x0D, 0x03, 0x00, // "+" (U+002B)
  0x00, 0x2C, 0xFF, 0xFD, 0x03, 0x03, 0x06, 0x03, 0x31, // "," (U+002C)
  0x00, 0x2D, 0x00, 0x07, 0x06, 0x08, 0x07, 0x03, 0x44, // "-" (U+002D)
  0x00, 0x2E, 0x00, 0x01, 0x03, 0x03, 0x06, 0x03, 0x4B, // "." (U+002E)
  0x00, 0x2F, 0xFE, 0x01, 0x0B, 0x14, 0x09, 0x03, 0x53, // "/" (U+002F)
  0x00, 0x30, 0x00, 0x01, 0x0B, 0x14, 0x0C, 0x03, 0x9C, // "0" (U+0030)
  0x00, 0x31, 0x03, 0x01, 0x0A, 0x14, 0x0C, 0x04, 0x04, // "1" (U+0031)
  0x00, 0x32, 0xFF, 0x01, 0x0B, 0x14, 0x0C, 0x04, 0x44, // "2" (U+0032)
  0x00, 0x33, 0xFF, 0x01, 0x0B, 0x14, 0x0C, 0x04, 0x97, // "3" (U+0033)
  0x00, 0x34, 0xFF, 0x01, 0x0B, 0x14, 0x0C, 0x04, 0xEE, // "4" (U+0034)
  0x00, 0x35, 0x00, 0x01, 0x0B, 0x14, 0x0C, 0x05, 0x45, // "5" (U+0035)
  0x00, 0x36, 0x01, 0x01, 0x0C, 0x14, 0x0C, 0x05, 0x98, // "6" (U+0036)
  0x00, 0x37, 0x01, 0x01, 0x0C, 0x14, 0x0C, 0x05, 0xFF, // "7" (U+0037)
  0x00, 0x38, 0x00, 0x01, 0x0B, 0x14, 0x0C, 0x06, 0x49, // "8" (U+0038)
  0x00, 0x39, 0x00, 0x01, 0x0B, 0x14, 0x0C, 0x06, 0xB0, // "9" (U+0039)
  0x00, 0x3A, 0x00, 0x01, 0x05, 0x0F, 0x06, 0x07, 0x12, // ":" (U+003A)
  0x00, 0x3B, 0xFE, 0xFE, 0x05, 0x0F, 0x06, 0x07, 0x28, // ";" (U+003B)
  0x00, 0x3C, 0x01, 0x04, 0x0C, 0x10, 0x0D, 0x07, 0x49, // "<" (U+003C)
  0x00, 0x3D, 0x01, 0x07, 0x0B, 0x0E, 0x0D, 0x07, 0x84, // "=" (U+003D)
  0x00, 0x3E, 0x01, 0x04, 0x0C, 0x10, 0x0D, 0x07, 0x91, // ">" (U+003E)
  0x00, 0x3F, 0x01, 0x01, 0x09, 0x14, 0x09, 0x07, 0xC9, // "?" (U+003F)
  0x00, 0x40, 0x00, 0xFF, 0x11, 0x14, 0x12, 0x08, 0x07, // "@" (U+0040)
  0x00, 0x41, 0xFE, 0x01, 0x0A, 0x14, 0x0C, 0x08, 0xB8, // "A" (U+0041)
  0x00, 0x42, 0x00, 0x01, 0x0C, 0x14, 0x0D, 0x09, 0x18, // "B" (U+0042)
  0x00, 0x43, 0x01, 0x01, 0x0D, 0x14, 0x0C, 0x09, 0x8D, // "C" (U+0043)
  0x00, 0x44, 0x00, 0x01, 0x0D, 0x14, 0x0E, 0x09, 0xE0, // "D" (U+0044)
  0x00, 0x45, 0x00, 0x01, 0x0C, 0x14, 0x0B, 0x0A, 0x57, // "E" (U+0045)
  0x00, 0x46, 0x00, 0x01, 0x0C, 0x14, 0x0A, 0x0A, 0xA0, // "F" (U+0046)
  0x00, 0x47, 0x01, 0x01, 0x0E, 0x14, 0x0F, 0x0A, 0xE9, // "G" (U+0047)
  0x00, 0x48, 0x00, 0x01, 0x0E, 0x14, 0x0F, 0x0B, 0x51, // "H" (U+0048)
  0x00, 0x49, 0xFF, 0x01, 0x09, 0x14, 0x08, 0x0B, 0xC3, // "I" (U+0049)
  0x00, 0x4A, 0xFC, 0xFC, 0x06, 0x14, 0x06, 0x0C, 0x08, // "J" (U+004A)
  0x00, 0x4B, 0x00, 0x01, 0x0E, 0x14, 0x0C, 0x0C, 0x5D, // "K" (U+004B)
  0x00, 0x4C, 0x00, 0x01, 0x08, 0x14, 0x0A, 0x0C, 0xD1, // "L" (U+004C)
  0x00, 0x4D, 0x00, 0x01, 0x13, 0x14, 0x13, 0x0D, 0x0D, // "M" (U+004D)
  0x00, 0x4E, 0x00, 0x01, 0x0F, 0x14, 0x0F, 0x0D, 0xBD, // "N" (U+004E)
  0x00, 0x4F, 0x01, 0x01, 0x0E, 0x14, 0x0F, 0x0E, 0x46, // "O" (U+004F)
  0x00, 0x50, 0x00, 0x01, 0x0C, 0x14, 0x0C, 0x0E, 0xB4, // "P" (U+0050)
  0x00, 0x51, 0x01, 0xFC, 0x0E, 0x14, 0x0F, 0x0F, 0x15, // "Q" (U+0051)
  0x00, 0x52, 0x00, 0x01, 0x0C, 0x14, 0x0D, 0x0F, 0x94, // "R" (U+0052)
  0x00, 0x53, 0xFF, 0x01, 0x0B, 0x14, 0x0B, 0x10, 0x07, // "S" (U+0053)
  0x00, 0x54, 0x02, 0x01, 0x0C, 0x14, 0x0B, 0x10, 0x5F, // "T" (U+0054)
  0x00, 0x55, 0x01, 0x01, 0x0E, 0x14, 0x0E, 0x10, 0x9E, // "U" (U+0055)
  0x00, 0x56, 0x02, 0x01, 0x0E, 0x14, 0x0C, 0x11, 0x0F, // "V" (U+0056)
  0x00, 0x57, 0x02, 0x01, 0x15, 0x14, 0x13, 0x11, 0x75, // "W" (U+0057)
  0x00, 0x58, 0xFE, 0x01, 0x0D, 0x14, 0x0B, 0x12, 0x1C, // "X" (U+0058)
  0x00, 0x59, 0x02, 0x01, 0x0C, 0x14, 0x0B, 0x12, 0x85, // "Y" (U+0059)
  0x00, 0x5A, 0xFF, 0x01, 0x0B, 0x14, 0x0B, 0x12, 0xD7, // "Z" (U+005A)
  0x00, 0x5B, 0xFF, 0xFD, 0x09, 0x14, 0x08, 0x13, 0x24, // "[" (U+005B)
  0x00, 0x5C, 0x02, 0x01, 0x07, 0x14, 0x09, 0x13, 0x75, // "\" (U+005C)
  0x00, 0x5D, 0xFE, 0xFD, 0x08, 0x14, 0x08, 0x13, 0xAB, // "]" (U+005D)
  0x00, 0x5E, 0x00, 0x0A, 0x0B, 0x14, 0x0C, 0x13, 0xFC, // "^" (U+005E)
  0x00, 0x5F, 0xFD, 0xFD, 0x06, 0xFE, 0x09, 0x14, 0x31, // "_" (U+005F)
  0x00, 0x60, 0x04, 0x12, 0x07, 0x16, 0x07, 0x14, 0x38, // "`" (U+0060)
  0x00, 0x61, 0x00, 0x01, 0x0C, 0x0F, 0x0D, 0x14, 0x45, // "a" (U+0061)
  0x00, 0x62, 0x00, 0x01, 0x0B, 0x15, 0x0D, 0x14, 0x9B, // "b" (U+0062)
  0x00, 0x63, 0x00, 0x01, 0x0A, 0x0F, 0x0A, 0x15, 0x05, // "c" (U+0063)
  0x00, 0x64, 0x00, 0x01, 0x0D, 0x15, 0x0D, 0x15, 0x3F, // "d" (U+0064)
  0x00, 0x65, 0x00, 0x01, 0x0A, 0x0F, 0x0B, 0x15, 0xAE, // "e" (U+0065)
  0x00, 0x66, 0xFC, 0xFB, 0x09, 0x15, 0x07, 0x15, 0xF5, // "f" (U+0066)
  0x00, 0x67, 0xFF, 0xFB, 0x0C, 0x0F, 0x0D, 0x16, 0x5D, // "g" (U+0067)
  0x00, 0x68, 0x00, 0x01, 0x0B, 0x15, 0x0C, 0x16, 0xD2, // "h" (U+0068)
  0x00, 0x69, 0x00, 0x01, 0x06, 0x15, 0x06, 0x17, 0x3E, // "i" (U+0069)
  0x00, 0x6A, 0xFC, 0xFB, 0x06, 0x15, 0x06, 0x17, 0x73, // "j" (U+006A)
  0x00, 0x6B, 0x00, 0x01, 0x0B, 0x15, 0x0B, 0x17, 0xC5, // "k" (U+006B)
  0x00, 0x6C, 0x00, 0x01, 0x06, 0x15, 0x06, 0x18, 0x28, // "l" (U+006C)
  0x00, 0x6D, 0x00, 0x01, 0x11, 0x0F, 0x13, 0x18, 0x65, // "m" (U+006D)
  0x00, 0x6E, 0x00, 0x01, 0x0B, 0x0F, 0x0C, 0x18, 0xE8, // "n" (U+006E)
  0x00, 0x6F, 0x00, 0x01, 0x0B, 0x0F, 0x0C, 0x19, 0x42, // "o" (U+006F)
  0x00, 0x70, 0xFF, 0xFB, 0x0B, 0x0F, 0x0D, 0x19, 0x92, // "p" (U+0070)
  0x00, 0x71, 0x00, 0xFB, 0x0C, 0x0F, 0x0D, 0x1A, 0x01, // "q" (U+0071)
  0x00, 0x72, 0x00, 0x01, 0x09, 0x0F, 0x08, 0x1A, 0x6D, // "r" (U+0072)
  0x00, 0x73, 0xFF, 0x01, 0x09, 0x0F, 0x09, 0x1A, 0x9F, // "s" (U+0073)
  0x00, 0x74, 0x01, 0x01, 0x07, 0x13, 0x07, 0x1A, 0xDE, // "t" (U+0074)
  0x00, 0x75, 0x01, 0x01, 0x0C, 0x0F, 0x0D, 0x1B, 0x17, // "u" (U+0075)
  0x00, 0x76, 0x01, 0x01, 0x0B, 0x0F, 0x0A, 0x1B, 0x6E, // "v" (U+0076)
  0x00, 0x77, 0x01, 0x01, 0x11, 0x0F, 0x10, 0x1B, 0xB6, // "w" (U+0077)
  0x00, 0x78, 0xFF, 0x01, 0x0B, 0x0F, 0x0A, 0x1C, 0x32, // "x" (U+0078)
  0x00, 0x79, 0xFD, 0xFB, 0x0B, 0x0F, 0x0A, 0x1C, 0x7F, // "y" (U+0079)
  0x00, 0x7A, 0xFF, 0x01, 0x09, 0x0F, 0x09, 0x1C, 0xE2, // "z" (U+007A)
  0x00, 0x7B, 0x00, 0xFD, 0x0A, 0x14, 0x09, 0x1D, 0x16, // "{" (U+007B)
  0x00, 0x7C, 0x04, 0xFB, 0x06, 0x15, 0x0B, 0x1D, 0x65, // "|" (U+007C)
  0x00, 0x7D, 0xFE, 0xFD, 0x08, 0x14, 0x09, 0x1D, 0x90, // "}" (U+007D)
  0x00, 0x7E, 0x01, 0x09, 0x0C, 0x0C, 0x0D, 0x1D, 0xDF, // "~" (U+007E)
  0x00, 0xA1, 0xFF, 0xFC, 0x06, 0x0F, 0x07, 0x1D, 0xF6, // "¡" (U+00A1)
  0x00, 0xA2, 0x02, 0x01, 0x0B, 0x14, 0x0C, 0x1E, 0x2A, // "¢" (U+00A2)
  0x00, 0xA3, 0xFF, 0x01, 0x0C, 0x14, 0x0C, 0x1E, 0x6E, // "£" (U+00A3)
  0x00, 0xA4, 0x01, 0x04, 0x0C, 0x10, 0x0E, 0x1E, 0xBD, // "¤" (U+00A4)
  0x00, 0xA5, 0x00, 0x01, 0x0D, 0x14, 0x0C, 0x1F, 0x03, // "¥" (U+00A5)
  0x00, 0xA6, 0x04, 0xFB, 0x06, 0x15, 0x0B, 0x1F, 0x63, // "¦" (U+00A6)
  0x00, 0xA7, 0x00, 0x01, 0x0A, 0x15, 0x0A, 0x1F, 0x86, // "§" (U+00A7)
  0x00, 0xA8, 0x05, 0x12, 0x0B, 0x14, 0x0D, 0x1F, 0xE6, // "¨" (U+00A8)
  0x00, 0xA9, 0x01, 0x01, 0x15, 0x14, 0x16, 0x1F, 0xF3, // "©" (U+00A9)
  0x00, 0xAA, 0x01, 0x0B, 0x09, 0x14, 0x08, 0x20, 0x9E, // "ª" (U+00AA)
  0x00, 0xAB, 0x01, 0x02, 0x0B, 0x0D, 0x0C, 0x20, 0xCD, // "«" (U+00AB)
  0x00, 0xAC, 0x01, 0x04, 0x0B, 0x0B, 0x0D, 0x21, 0x0C, // "¬" (U+00AC)
  0x00, 0xAE, 0x01, 0x01, 0x15, 0x14, 0x16, 0x21, 0x21, // "®" (U+00AE)
  0x00, 0xAF, 0x02, 0x16, 0x0D, 0x17, 0x0B, 0x21, 0xD3, // "¯" (U+00AF)
  0x00, 0xB0, 0x01, 0x0D, 0x08, 0x14, 0x0A, 0x21, 0xDA, // "°" (U+00B0)
  0x00, 0xB1, 0x01, 0x01, 0x0C, 0x11, 0x0D, 0x21, 0xFA, // "±" (U+00B1)
  0x00, 0xB2, 0x01, 0x0C, 0x09, 0x17, 0x08, 0x22, 0x34, // "²" (U+00B2)
  0x00, 0xB3, 0x01, 0x0C, 0x09, 0x17, 0x08, 0x22, 0x5F, // "³" (U+00B3)
  0x00, 0xB4, 0x03, 0x12, 0x08, 0x16, 0x07, 0x22, 0x8E, // "´" (U+00B4)
  0x00, 0xB5, 0xFF, 0xFB, 0x0C, 0x0F, 0x0D, 0x22, 0x9E, // "µ" (U+00B5)
  0x00, 0xB6, 0x02, 0xFD, 0x0C, 0x15, 0x0E, 0x23, 0x0B, // "¶" (U+00B6)
  0x00, 0xB7, 0x01, 0x09, 0x04, 0x0B, 0x06, 0x23, 0x7F, // "·" (U+00B7)
  0x00, 0xB8, 0xFD, 0xFA, 0x02, 0x01, 0x05, 0x23, 0x87, // "¸" (U+00B8)
  0x00, 0xB9, 0x03, 0x0C, 0x08, 0x17, 0x08, 0x23, 0x9D, // "¹" (U+00B9)
  0x00, 0xBA, 0x02, 0x0B, 0x08, 0x14, 0x08, 0x23, 0xC1, // "º" (U+00BA)
  0x00, 0xBB, 0x00, 0x02, 0x0A, 0x0D, 0x0C, 0x23, 0xE4, // "»" (U+00BB)
  0x00, 0xBC, 0x01, 0x01, 0x11, 0x14, 0x12, 0x24, 0x27, // "¼" (U+00BC)
  0x00, 0xBD, 0x01, 0x01, 0x12, 0x14, 0x14, 0x24, 0xB6, // "½" (U+00BD)
  0x00, 0xBE, 0x00, 0x01, 0x12, 0x14, 0x13, 0x25, 0x3F, // "¾" (U+00BE)
  0x00, 0xBF, 0xFF, 0xFB, 0x07, 0x0E, 0x09, 0x25, 0xD7, // "¿" (U+00BF)
  0x00, 0xC0, 0xFE, 0x01, 0x0A, 0x1B, 0x0C, 0x26, 0x15, // "À" (U+00C0)
  0x00, 0xC1, 0xFE, 0x01, 0x0C, 0x1B, 0x0C, 0x26, 0x87, // "Á" (U+00C1)
  0x00, 0xC2, 0xFE, 0x01, 0x0C, 0x1B, 0x0C, 0x27, 0x02, // "Â" (U+00C2)
  0x00, 0xC3, 0xFE, 0x01, 0x0D, 0x1A, 0x0C, 0x27, 0x81, // "Ã" (U+00C3)
  0x00, 0xC4, 0xFE, 0x01, 0x0C, 0x19, 0x0C, 0x28, 0x01, // "Ä" (U+00C4)
  0x00, 0xC5, 0xFE, 0x01, 0x0B, 0x1C, 0x0C, 0x28, 0x7A, // "Å" (U+00C5)
  0x00, 0xC6, 0xFE, 0x01, 0x12, 0x14, 0x11, 0x28, 0xFC, // "Æ" (U+00C6)
  0x00, 0xC7, 0x01, 0xFA, 0x0D, 0x14, 0x0C, 0x29, 0x74, // "Ç" (U+00C7)
  0x00, 0xC8, 0x00, 0x01, 0x0C, 0x1B, 0x0B, 0x29, 0xE2, // "È" (U+00C8)
  0x00, 0xC9, 0x00, 0x01, 0x0C, 0x1B, 0x0B, 0x2A, 0x3D, // "É" (U+00C9)
  0x00, 0xCA, 0x00, 0x01, 0x0C, 0x1B, 0x0B, 0x2A, 0x9B, // "Ê" (U+00CA)
  0x00, 0xCB, 0x00, 0x01, 0x0C, 0x19, 0x0B, 0x2A, 0xFC, // "Ë" (U+00CB)
  0x00, 0xCC, 0xFF, 0x01, 0x09, 0x1B, 0x08, 0x2B, 0x56, // "Ì" (U+00CC)
  0x00, 0xCD, 0xFF, 0x01, 0x0A, 0x1B, 0x08, 0x2B, 0xAD, // "Í" (U+00CD)
  0x00, 0xCE, 0xFF, 0x01, 0x0A, 0x1B, 0x08, 0x2C, 0x09, // "Î" (U+00CE)
  0x00, 0xCF, 0xFF, 0x01, 0x09, 0x19, 0x08, 0x2C, 0x68, // "Ï" (U+00CF)
  0x00, 0xD0, 0x00, 0x01, 0x0D, 0x14, 0x0E, 0x2C, 0xBE, // "Ð" (U+00D0)
  0x00, 0xD1, 0x00, 0x01, 0x0F, 0x1A, 0x0F, 0x2D, 0x36, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x01, 0x01, 0x0E, 0x1B, 0x0F, 0x2D, 0xD8, // "Ò" (U+00D2)
  0x00, 0xD3, 0x01, 0x01, 0x0E, 0x1B, 0x0F, 0x2E, 0x59, // "Ó" (U+00D3)
  0x00, 0xD4, 0x01, 0x01, 0x0E, 0x1B, 0x0F, 0x2E, 0xDC, // "Ô" (U+00D4)
  0x00, 0xD5, 0x01, 0x01, 0x0E, 0x1A, 0x0F, 0x2F, 0x63, // "Õ" (U+00D5)
  0x00, 0xD6, 0x01, 0x01, 0x0E, 0x19, 0x0F, 0x2F, 0xEA, // "Ö" (U+00D6)
  0x00, 0xD7, 0x01, 0x05, 0x0B, 0x0F, 0x0D, 0x30, 0x6A, // "×" (U+00D7)
  0x00, 0xD8, 0x00, 0x00, 0x0F, 0x15, 0x0F, 0x30, 0xA0, // "Ø" (U+00D8)
  0x00, 0xD9, 0x01, 0x01, 0x0E, 0x1B, 0x0E, 0x31, 0x34, // "Ù" (U+00D9)
  0x00, 0xDA, 0x01, 0x01, 0x0E, 0x1B, 0x0E, 0x31, 0xB7, // "Ú" (U+00DA)
  0x00, 0xDB, 0x01, 0x01, 0x0E, 0x1B, 0x0E, 0x32, 0x3D, // "Û" (U+00DB)
  0x00, 0xDC, 0x01, 0x01, 0x0E, 0x19, 0x0E, 0x32, 0xC7, // "Ü" (U+00DC)
  0x00, 0xDD, 0x02, 0x01, 0x0C, 0x1B, 0x0B, 0x33, 0x49, // "Ý" (U+00DD)
  0x00, 0xDE, 0x00, 0x01, 0x0B, 0x14, 0x0C, 0x33, 0xAE, // "Þ" (U+00DE)
  0x00, 0xDF, 0xFC, 0xFB, 0x0C, 0x15, 0x0D, 0x34, 0x0B, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x01, 0x0C, 0x16, 0x0D, 0x34, 0xA1, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x0C, 0x16, 0x0D, 0x35, 0x09, // "á" (U+00E1)
  0x00, 0xE2, 0x00, 0x01, 0x0C, 0x16, 0x0D, 0x35, 0x74, // "â" (U+00E2)
  0x00, 0xE3, 0x00, 0x01, 0x0C, 0x15, 0x0D, 0x35, 0xE2, // "ã" (U+00E3)
  0x00, 0xE4, 0x00, 0x01, 0x0C, 0x14, 0x0D, 0x36, 0x50, // "ä" (U+00E4)
  0x00, 0xE5, 0x00, 0x01, 0x0C, 0x17, 0x0D, 0x36, 0xB7, // "å" (U+00E5)
  0x00, 0xE6, 0x00, 0x01, 0x11, 0x0F, 0x12, 0x37, 0x2A, // "æ" (U+00E6)
  0x00, 0xE7, 0x00, 0xFA, 0x0A, 0x0F, 0x0A, 0x37, 0xA6, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x01, 0x0A, 0x16, 0x0B, 0x37, 0xF8, // "è" (U+00E8)
  0x00, 0xE9, 0x00, 0x01, 0x0B, 0x16, 0x0B, 0x38, 0x51, // "é" (U+00E9)
  0x00, 0xEA, 0x00, 0x01, 0x0B, 0x16, 0x0B, 0x38, 0xAE, // "ê" (U+00EA)
  0x00, 0xEB, 0x00, 0x01, 0x0B, 0x14, 0x0B, 0x39, 0x0E, // "ë" (U+00EB)
  0x00, 0xEC, 0x00, 0x01, 0x05, 0x16, 0x06, 0x39, 0x68, // "ì" (U+00EC)
  0x00, 0xED, 0x00, 0x01, 0x08, 0x16, 0x06, 0x39, 0xA3, // "í" (U+00ED)
  0x00, 0xEE, 0x00, 0x01, 0x08, 0x16, 0x06, 0x39, 0xE1, // "î" (U+00EE)
  0x00, 0xEF, 0x00, 0x01, 0x08, 0x14, 0x06, 0x3A, 0x23, // "ï" (U+00EF)
  0x00, 0xF0, 0x00, 0x01, 0x0B, 0x15, 0x0C, 0x3A, 0x5F, // "ð" (U+00F0)
  0x00, 0xF1, 0x00, 0x01, 0x0C, 0x15, 0x0C, 0x3A, 0xCB, // "ñ" (U+00F1)
  0x00, 0xF2, 0x00, 0x01, 0x0B, 0x16, 0x0C, 0x3B, 0x3D, // "ò" (U+00F2)
  0x00, 0xF3, 0x00, 0x01, 0x0B, 0x16, 0x0C, 0x3B, 0x9F, // "ó" (U+00F3)
  0x00, 0xF4, 0x00, 0x01, 0x0B, 0x16, 0x0C, 0x3C, 0x03, // "ô" (U+00F4)
  0x00, 0xF5, 0x00, 0x01, 0x0C, 0x15, 0x0C, 0x3C, 0x6A, // "õ" (U+00F5)
  0x00, 0xF6, 0x00, 0x01, 0x0B, 0x14, 0x0C, 0x3C, 0xD6, // "ö" (U+00F6)
  0x00, 0xF7, 0x01, 0x04, 0x0C, 0x10, 0x0D, 0x3D, 0x37, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x00, 0x0C, 0x10, 0x0C, 0x3D, 0x55, // "ø" (U+00F8)
  0x00, 0xF9, 0x01, 0x01, 0x0C, 0x16, 0x0D, 0x3D, 0xB9, // "ù" (U+00F9)
  0x00, 0xFA, 0x01, 0x01, 0x0C, 0x16, 0x0D, 0x3E, 0x22, // "ú" (U+00FA)
  0x00, 0xFB, 0x01, 0x01, 0x0C, 0x16, 0x0D, 0x3E, 0x8D, // "û" (U+00FB)
  0x00, 0xFC, 0x01, 0x01, 0x0C, 0x14, 0x0D, 0x3E, 0xFB, // "ü" (U+00FC)
  0x00, 0xFD, 0xFD, 0xFB, 0x0B, 0x16, 0x0A, 0x3F, 0x63, // "ý" (U+00FD)
  0x00, 0xFE, 0xFF, 0xFB, 0x0B, 0x15, 0x0D, 0x3F, 0xDB, // "þ" (U+00FE)
  0x00, 0xFF, 0xFD, 0xFB, 0x0B, 0x14, 0x0A, 0x40, 0x5D, // "ÿ" (U+00FF)
  0x01, 0x00, 0xFE, 0x01, 0x0B, 0x18, 0x0C, 0x40, 0xD2, // "Ā" (U+0100)
  0x01, 0x01, 0x00, 0x01, 0x0C, 0x13, 0x0D, 0x41, 0x3E, // "ā" (U+0101)
  0x01, 0x02, 0xFE, 0x01, 0x0C, 0x1A, 0x0C, 0x41, 0x9C, // "Ă" (U+0102)
  0x01, 0x03, 0x00, 0x01, 0x0C, 0x15, 0x0D, 0x42, 0x19, // "ă" (U+0103)
  0x01, 0x04, 0xFE, 0xFB, 0x0A, 0x14, 0x0C, 0x42, 0x86, // "Ą" (U+0104)
  0x01, 0x05, 0x00, 0xFB, 0x0C, 0x0F, 0x0D, 0x42, 0xFC, // "ą" (U+0105)
  0x01, 0x06, 0x01, 0x01, 0x0D, 0x1B, 0x0C, 0x43, 0x67, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x01, 0x0A, 0x16, 0x0A, 0x43, 0xCF, // "ć" (U+0107)
  0x01, 0x08, 0x01, 0x01, 0x0D, 0x1B, 0x0C, 0x44, 0x1C, // "Ĉ" (U+0108)
  0x01, 0x09, 0x00, 0x01, 0x0B, 0x16, 0x0A, 0x44, 0x88, // "ĉ" (U+0109)
  0x01, 0x0A, 0x01, 0x01, 0x0D, 0x19, 0x0C, 0x44, 0xDB, // "Ċ" (U+010A)
  0x01, 0x0B, 0x00, 0x01, 0x0A, 0x14, 0x0A, 0x45, 0x3A, // "ċ" (U+010B)
  0x01, 0x0C, 0x01, 0x01, 0x0E, 0x1B, 0x0C, 0x45, 0x7F, // "Č" (U+010C)
  0x01, 0x0D, 0x00, 0x01, 0x0B, 0x16, 0x0A, 0x45, 0xEA, // "č" (U+010D)
  0x01, 0x0E, 0x00, 0x01, 0x0D, 0x1B, 0x0E, 0x46, 0x3D, // "Ď" (U+010E)
  0x01, 0x0F, 0x00, 0x01, 0x11, 0x15, 0x0E, 0x46, 0xCC, // "ď" (U+010F)
  0x01, 0x10, 0x00, 0x01, 0x0D, 0x14, 0x0E, 0x47, 0x49, // "Đ" (U+0110)
  0x01, 0x11, 0x00, 0x01, 0x0E, 0x15, 0x0D, 0x47, 0xC1, // "đ" (U+0111)
  0x01, 0x12, 0x00, 0x01, 0x0C, 0x18, 0x0B, 0x48, 0x31, // "Ē" (U+0112)
  0x01, 0x13, 0x00, 0x01, 0x0A, 0x13, 0x0B, 0x48, 0x82, // "ē" (U+0113)
  0x01, 0x14, 0x00, 0x01, 0x0C, 0x1A, 0x0B, 0x48, 0xD1, // "Ĕ" (U+0114)
  0x01, 0x15, 0x00, 0x01, 0x0B, 0x15, 0x0B, 0x49, 0x31, // "ĕ" (U+0115)
  0x01, 0x16, 0x00, 0x01, 0x0C, 0x18, 0x0B, 0x49, 0x91, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x01, 0x0A, 0x14, 0x0B, 0x49, 0xE4, // "ė" (U+0117)
  0x01, 0x18, 0x00, 0xFB, 0x0C, 0x14, 0x0B, 0x4A, 0x35, // "Ę" (U+0118)
  0x01, 0x19, 0x00, 0xFB, 0x0A, 0x0F, 0x0B, 0x4A, 0x93, // "ę" (U+0119)
  0x01, 0x1A, 0x00, 0x01, 0x0C, 0x1B, 0x0B, 0x4A, 0xEE, // "Ě" (U+011A)
  0x01, 0x1B, 0x00, 0x01, 0x0B, 0x16, 0x0B, 0x4B, 0x4F, // "ě" (U+011B)
  0x01, 0x1C, 0x01, 0x01, 0x0E, 0x1B, 0x0F, 0x4B, 0xB0, // "Ĝ" (U+011C)
  0x01, 0x1D, 0xFF, 0xFB, 0x0C, 0x16, 0x0D, 0x4C, 0x31, // "ĝ" (U+011D)
  0x01, 0x1E, 0x01, 0x01, 0x0E, 0x1A, 0x0F, 0x4C, 0xBF, // "Ğ" (U+011E)
  0x01, 0x1F, 0xFF, 0xFB, 0x0C, 0x15, 0x0D, 0x4D, 0x3E, // "ğ" (U+011F)
  0x01, 0x20, 0x01, 0x01, 0x0E, 0x19, 0x0F, 0x4D, 0xCB, // "Ġ" (U+0120)
  0x01, 0x21, 0xFF, 0xFB, 0x0C, 0x14, 0x0D, 0x4E, 0x3E, // "ġ" (U+0121)
  0x01, 0x22, 0x01, 0xFB, 0x0E, 0x14, 0x0F, 0x4E, 0xBE, // "Ģ" (U+0122)
  0x01, 0x23, 0xFF, 0xFB, 0x0C, 0x16, 0x0D, 0x4F, 0x38, // "ģ" (U+0123)
  0x01, 0x24, 0x00, 0x01, 0x0E, 0x1B, 0x0F, 0x4F, 0xC0, // "Ĥ" (U+0124)
  0x01, 0x25, 0x00, 0x01, 0x0B, 0x1C, 0x0C, 0x50, 0x4B, // "ĥ" (U+0125)
  0x01, 0x26, 0x00, 0x01, 0x10, 0x14, 0x0F, 0x50, 0xCE, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x0B, 0x15, 0x0C, 0x51, 0x40, // "ħ" (U+0127)
  0x01, 0x28, 0xFF, 0x01, 0x0B, 0x1A, 0x08, 0x51, 0xB0, // "Ĩ" (U+0128)
  0x01, 0x29, 0x00, 0x01, 0x09, 0x15, 0x06, 0x52, 0x11, // "ĩ" (U+0129)
  0x01, 0x2A, 0xFF, 0x01, 0x09, 0x18, 0x08, 0x52, 0x54, // "Ī" (U+012A)
  0x01, 0x2B, 0x00, 0x01, 0x07, 0x13, 0x06, 0x52, 0xA1, // "ī" (U+012B)
  0x01, 0x2C, 0xFF, 0x01, 0x0A, 0x1A, 0x08, 0x52, 0xD4, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x00, 0x01, 0x08, 0x15, 0x06, 0x53, 0x33, // "ĭ" (U+012D)
  0x01, 0x2E, 0xFF, 0xFB, 0x09, 0x14, 0x08, 0x53, 0x73, // "Į" (U+012E)
  0x01, 0x2F, 0xFD, 0xFB, 0x06, 0x15, 0x06, 0x53, 0xCC, // "į" (U+012F)
  0x01, 0x30, 0xFF, 0x01, 0x09, 0x19, 0x08, 0x54, 0x14, // "İ" (U+0130)
  0x01, 0x31, 0x00, 0x01, 0x05, 0x0F, 0x06, 0x54, 0x63, // "ı" (U+0131)
  0x01, 0x32, 0xFF, 0xFC, 0x0E, 0x14, 0x0E, 0x54, 0x8F, // "Ĳ" (U+0132)
  0x01, 0x33, 0x00, 0xFB, 0x0C, 0x15, 0x0B, 0x55, 0x1F, // "ĳ" (U+0133)
  0x01, 0x34, 0xFC, 0xFC, 0x09, 0x1B, 0x06, 0x55, 0x9F, // "Ĵ" (U+0134)
  0x01, 0x35, 0xFC, 0xFB, 0x08, 0x16, 0x06, 0x56, 0x12, // "ĵ" (U+0135)
  0x01, 0x36, 0x00, 0xFB, 0x0E, 0x14, 0x0C, 0x56, 0x75, // "Ķ" (U+0136)
  0x01, 0x37, 0x00, 0xFB, 0x0B, 0x15, 0x0B, 0x56, 0xFC, // "ķ" (U+0137)
  0x01, 0x38, 0x00, 0x01, 0x0B, 0x0F, 0x0B, 0x57, 0x71, // "ĸ" (U+0138)
  0x01, 0x39, 0x00, 0x01, 0x0B, 0x1B, 0x0A, 0x57, 0xC0, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x00, 0x01, 0x09, 0x1C, 0x06, 0x58, 0x1A, // "ĺ" (U+013A)
  0x01, 0x3B, 0x00, 0xFB, 0x08, 0x14, 0x0A, 0x58, 0x69, // "Ļ" (U+013B)
  0x01, 0x3C, 0xFF, 0xFB, 0x06, 0x15, 0x06, 0x58, 0xB4, // "ļ" (U+013C)
  0x01, 0x3D, 0x00, 0x01, 0x0B, 0x14, 0x0A, 0x59, 0x00, // "Ľ" (U+013D)
  0x01, 0x3E, 0x00, 0x01, 0x0A, 0x15, 0x07, 0x59, 0x4F, // "ľ" (U+013E)
  0x01, 0x3F, 0x00, 0x01, 0x09, 0x14, 0x0A, 0x59, 0x9B, // "Ŀ" (U+013F)
  0x01, 0x40, 0x00, 0x01, 0x07, 0x15, 0x08, 0x59, 0xDF, // "ŀ" (U+0140)
  0x01, 0x41, 0xFF, 0x01, 0x08, 0x14, 0x0A, 0x5A, 0x1F, // "Ł" (U+0141)
  0x01, 0x42, 0x00, 0x01, 0x07, 0x15, 0x06, 0x5A, 0x61, // "ł" (U+0142)
  0x01, 0x43, 0x00, 0x01, 0x0F, 0x1B, 0x0F, 0x5A, 0xA3, // "Ń" (U+0143)
  0x01, 0x44, 0x00, 0x01, 0x0C, 0x16, 0x0C, 0x5B, 0x41, // "ń" (U+0144)
  0x01, 0x45, 0x00, 0xFB, 0x0F, 0x14, 0x0F, 0x5B, 0xB0, // "Ņ" (U+0145)
  0x01, 0x46, 0x00, 0xFB, 0x0B, 0x0F, 0x0C, 0x5C, 0x4B, // "ņ" (U+0146)
  0x01, 0x47, 0x00, 0x01, 0x0F, 0x1B, 0x0F, 0x5C, 0xB7, // "Ň" (U+0147)
  0x01, 0x48, 0x00, 0x01, 0x0B, 0x16, 0x0C, 0x5D, 0x59, // "ň" (U+0148)
  0x01, 0x49, 0x00, 0x01, 0x0C, 0x14, 0x0E, 0x5D, 0xCA, // "ŉ" (U+0149)
  0x01, 0x4A, 0x00, 0xFC, 0x0F, 0x14, 0x0F, 0x5E, 0x39, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x00, 0xFB, 0x0B, 0x0F, 0x0C, 0x5E, 0xD7, // "ŋ" (U+014B)
  0x01, 0x4C, 0x01, 0x01, 0x0E, 0x18, 0x0F, 0x5F, 0x45, // "Ō" (U+014C)
  0x01, 0x4D, 0x00, 0x01, 0x0B, 0x13, 0x0C, 0x5F, 0xBC, // "ō" (U+014D)
  0x01, 0x4E, 0x01, 0x01, 0x0E, 0x1A, 0x0F, 0x60, 0x14, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x00, 0x01, 0x0B, 0x15, 0x0C, 0x60, 0x9A, // "ŏ" (U+014F)
  0x01, 0x50, 0x01, 0x01, 0x10, 0x1A, 0x0F, 0x61, 0x01, // "Ő" (U+0150)
  0x01, 0x51, 0x00, 0x01, 0x0E, 0x15, 0x0C, 0x61, 0x93, // "ő" (U+0151)
  0x01, 0x52, 0x01, 0x01, 0x12, 0x14, 0x12, 0x61, 0xFF, // "Œ" (U+0152)
  0x01, 0x53, 0x00, 0x01, 0x12, 0x0F, 0x13, 0x62, 0x7B, // "œ" (U+0153)
  0x01, 0x54, 0x00, 0x01, 0x0D, 0x1B, 0x0D, 0x62, 0xF9, // "Ŕ" (U+0154)
  0x01, 0x55, 0x00, 0x01, 0x0A, 0x16, 0x08, 0x63, 0x81, // "ŕ" (U+0155)
  0x01, 0x56, 0x00, 0xFB, 0x0C, 0x14, 0x0D, 0x63, 0xC9, // "Ŗ" (U+0156)
  0x01, 0x57, 0xFF, 0xFB, 0x09, 0x0F, 0x08, 0x64, 0x4E, // "ŗ" (U+0157)
  0x01, 0x58, 0x00, 0x01, 0x0C, 0x1B, 0x0D, 0x64, 0x95, // "Ř" (U+0158)
  0x01, 0x59, 0x00, 0x01, 0x0A, 0x16, 0x08, 0x65, 0x20, // "ř" (U+0159)
  0x01, 0x5A, 0xFF, 0x01, 0x0C, 0x1B, 0x0B, 0x65, 0x6C, // "Ś" (U+015A)
  0x01, 0x5B, 0xFF, 0x01, 0x0A, 0x16, 0x09, 0x65, 0xD9, // "ś" (U+015B)
  0x01, 0x5C, 0xFF, 0x01, 0x0B, 0x1B, 0x0B, 0x66, 0x2C, // "Ŝ" (U+015C)
  0x01, 0x5D, 0xFF, 0x01, 0x0A, 0x16, 0x09, 0x66, 0x9C, // "ŝ" (U+015D)
  0x01, 0x5E, 0xFF, 0xFA, 0x0B, 0x14, 0x0B, 0x66, 0xF2, // "Ş" (U+015E)
  0x01, 0x5F, 0xFF, 0xFA, 0x09, 0x0F, 0x09, 0x67, 0x64, // "ş" (U+015F)
  0x01, 0x60, 0xFF, 0x01, 0x0C, 0x1B, 0x0B, 0x67, 0xBC, // "Š" (U+0160)
  0x01, 0x61, 0xFF, 0x01, 0x0A, 0x16, 0x09, 0x68, 0x2C, // "š" (U+0161)
  0x01, 0x62, 0xFF, 0xFA, 0x0C, 0x14, 0x0B, 0x68, 0x83, // "Ţ" (U+0162)
  0x01, 0x63, 0xFF, 0xFA, 0x07, 0x13, 0x07, 0x68, 0xDF, // "ţ" (U+0163)
  0x01, 0x64, 0x02, 0x01, 0x0C, 0x1B, 0x0B, 0x69, 0x31, // "Ť" (U+0164)
  0x01, 0x65, 0x01, 0x01, 0x0A, 0x15, 0x07, 0x69, 0x87, // "ť" (U+0165)
  0x01, 0x66, 0x01, 0x01, 0x0C, 0x14, 0x0B, 0x69, 0xCD, // "Ŧ" (U+0166)
  0x01, 0x67, 0x00, 0x01, 0x07, 0x13, 0x07, 0x6A, 0x16, // "ŧ" (U+0167)
  0x01, 0x68, 0x01, 0x01, 0x0E, 0x1A, 0x0E, 0x6A, 0x55, // "Ũ" (U+0168)
  0x01, 0x69, 0x01, 0x01, 0x0C, 0x15, 0x0D, 0x6A, 0xDE, // "ũ" (U+0169)
  0x01, 0x6A, 0x01, 0x01, 0x0E, 0x18, 0x0E, 0x6B, 0x4D, // "Ū" (U+016A)
  0x01, 0x6B, 0x01, 0x01, 0x0C, 0x13, 0x0D, 0x6B, 0xC6, // "ū" (U+016B)
  0x01, 0x6C, 0x01, 0x01, 0x0E, 0x1A, 0x0E, 0x6C, 0x25, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x01, 0x01, 0x0C, 0x15, 0x0D, 0x6C, 0xAD, // "ŭ" (U+016D)
  0x01, 0x6E, 0x01, 0x01, 0x0E, 0x1C, 0x0E, 0x6D, 0x1A, // "Ů" (U+016E)
  0x01, 0x6F, 0x01, 0x01, 0x0C, 0x17, 0x0D, 0x6D, 0xA9, // "ů" (U+016F)
  0x01, 0x70, 0x01, 0x01, 0x10, 0x1A, 0x0E, 0x6E, 0x1B, // "Ű" (U+0170)
  0x01, 0x71, 0x01, 0x01, 0x0E, 0x15, 0x0D, 0x6E, 0xA5, // "ű" (U+0171)
  0x01, 0x72, 0x01, 0xFB, 0x0E, 0x14, 0x0E, 0x6F, 0x13, // "Ų" (U+0172)
  0x01, 0x73, 0x01, 0xFB, 0x0C, 0x0F, 0x0D, 0x6F, 0x9A, // "ų" (U+0173)
  0x01, 0x74, 0x02, 0x01, 0x15, 0x1B, 0x13, 0x70, 0x06, // "Ŵ" (U+0174)
  0x01, 0x75, 0x01, 0x01, 0x11, 0x16, 0x10, 0x70, 0xC8, // "ŵ" (U+0175)
  0x01, 0x76, 0x02, 0x01, 0x0C, 0x1B, 0x0B, 0x71, 0x5E, // "Ŷ" (U+0176)
  0x01, 0x77, 0xFD, 0xFB, 0x0B, 0x16, 0x0A, 0x71, 0xC7, // "ŷ" (U+0177)
  0x01, 0x78, 0x02, 0x01, 0x0C, 0x19, 0x0B, 0x72, 0x43, // "Ÿ" (U+0178)
  0x01, 0x79, 0xFF, 0x01, 0x0C, 0x1B, 0x0B, 0x72, 0xA6, // "Ź" (U+0179)
  0x01, 0x7A, 0xFF, 0x01, 0x0A, 0x16, 0x09, 0x73, 0x08, // "ź" (U+017A)
  0x01, 0x7B, 0xFF, 0x01, 0x0B, 0x19, 0x0B, 0x73, 0x56, // "Ż" (U+017B)
  0x01, 0x7C, 0xFF, 0x01, 0x09, 0x14, 0x09, 0x73, 0xAE, // "ż" (U+017C)
  0x01, 0x7D, 0xFF, 0x01, 0x0B, 0x1B, 0x0B, 0x73, 0xEC, // "Ž" (U+017D)
  0x01, 0x7E, 0xFF, 0x01, 0x0A, 0x16, 0x09, 0x74, 0x51, // "ž" (U+017E)
  0x01, 0x7F, 0xFC, 0xFB, 0x09, 0x15, 0x06, 0x74, 0xA2, // "ſ" (U+017F)
  0x03, 0xA9, 0xFF, 0x01, 0x0E, 0x14, 0x0F, 0x75, 0x05, // "Ω" (U+03A9)
  0x03, 0xBC, 0xFF, 0xFB, 0x0C, 0x0F, 0x0D, 0x75, 0x81, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x01, 0x0D, 0x0F, 0x0D, 0x75, 0xEE, // "π" (U+03C0)
  0x20, 0x13, 0x00, 0x07, 0x0B, 0x08, 0x0C, 0x76, 0x47, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x07, 0x17, 0x08, 0x19, 0x76, 0x4E, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x01, 0x0D, 0x14, 0x0C, 0x76, 0x55, // "€" (U+20AC)
  0x20, 0xBF, 0x00, 0xFE, 0x0B, 0x17, 0x0C, 0x76, 0xAB, // "₿" (U+20BF)
  0x20, 0x18, 0x01, 0x0E, 0x06, 0x14, 0x05, 0x77, 0x33, // "‘" (U+2018)
  0x20, 0x19, 0x01, 0x0E, 0x06, 0x14, 0x05, 0x77, 0x49, // "’" (U+2019)
  0x20, 0x1A, 0xFE, 0xFD, 0x03, 0x03, 0x06, 0x77, 0x5F, // "‚" (U+201A)
  0x20, 0x1B, 0x02, 0x0E, 0x04, 0x14, 0x05, 0x77, 0x75, // "‛" (U+201B)
  0x20, 0x1C, 0x01, 0x0E, 0x0A, 0x14, 0x09, 0x77, 0x81, // "“" (U+201C)
  0x20, 0x1D, 0x01, 0x0E, 0x0A, 0x14, 0x09, 0x77, 0xA7, // "”" (U+201D)
  0x20, 0x1E, 0xFE, 0xFD, 0x07, 0x03, 0x0A, 0x77, 0xCE, // "„" (U+201E)
  0x20, 0x1F, 0x02, 0x0E, 0x09, 0x14, 0x09, 0x77, 0xF5, // "‟" (U+201F)
  0x20, 0x20, 0x02, 0x01, 0x0B, 0x15, 0x0B, 0x78, 0x13, // "†" (U+2020)
  0x20, 0x21, 0x00, 0x01, 0x0B, 0x15, 0x0B, 0x78, 0x56, // "‡" (U+2021)
  0x20, 0x22, 0x02, 0x07, 0x08, 0x0D, 0x0A, 0x78, 0xAA, // "•" (U+2022)
  0x20, 0x26, 0x00, 0x01, 0x0F, 0x03, 0x12, 0x78, 0xC0, // "…" (U+2026)
  0x20, 0x30, 0x01, 0x01, 0x18, 0x14, 0x1A, 0x78, 0xDB, // "‰" (U+2030)
  0x20, 0x39, 0x01, 0x02, 0x06, 0x0D, 0x07, 0x79, 0xAD, // "‹" (U+2039)
  0x20, 0x3A, 0x00, 0x02, 0x05, 0x0D, 0x07, 0x79, 0xCE, // "›" (U+203A)
  0x20, 0x44, 0xF9, 0x01, 0x09, 0x14, 0x03, 0x79, 0xF0, // "⁄" (U+2044)
  0x21, 0x22, 0x00, 0x0B, 0x10, 0x13, 0x12, 0x7A, 0x37, // "™" (U+2122)
  0x21, 0x52, 0x01, 0x01, 0x19, 0x14, 0x1A, 0x7A, 0x8D, // "⅒" (U+2152)
  0xFB, 0x01, 0xFC, 0xFB, 0x0D, 0x15, 0x0D, 0x7B, 0x52, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0xFC, 0xFB, 0x0D, 0x15, 0x0D, 0x7B, 0xEC, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x02, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0x61, 0x01, // "a (U+0022 U+0061)
  0x00, 0x22, 0x00, 0x63, 0x02, // "c (U+0022 U+0063)
  0x00, 0x22, 0x00, 0x64, 0x02, // "d (U+0022 U+0064)
  0x00, 0x22, 0x00, 0x65, 0x02, // "e (U+0022 U+0065)
  0x00, 0x22, 0x00, 0x67, 0x01, // "g (U+0022 U+0067)
  0x00, 0x22, 0x00, 0x6D, 0x01, // "m (U+0022 U+006D)
  0x00, 0x22, 0x00, 0x6E, 0x01, // "n (U+0022 U+006E)
  0x00, 0x22, 0x00, 0x6F, 0x02, // "o (U+0022 U+006F)
  0x00, 0x22, 0x00, 0x70, 0x01, // "p (U+0022 U+0070)
  0x00, 0x22, 0x00, 0x71, 0x02, // "q (U+0022 U+0071)
  0x00, 0x22, 0x00, 0x72, 0x01, // "r (U+0022 U+0072)
  0x00, 0x22, 0x00, 0x73, 0x01, // "s (U+0022 U+0073)
  0x00, 0x22, 0x00, 0x75, 0x01, // "u (U+0022 U+0075)
  0x00, 0x22, 0x00, 0xC0, 0x02, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x02, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x02, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x02, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x02, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x02, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xE0, 0x02, // "à (U+0022 U+00E0)
  0x00, 0x22, 0x00, 0xE1, 0x01, // "á (U+0022 U+00E1)
  0x00, 0x22, 0x00, 0xE2, 0x01, // "â (U+0022 U+00E2)
  0x00, 0x22, 0x00, 0xE3, 0x01, // "ã (U+0022 U+00E3)
  0x00, 0x22, 0x00, 0xE4, 0x01, // "ä (U+0022 U+00E4)
  0x00, 0x22, 0x00, 0xE5, 0x01, // "å (U+0022 U+00E5)
  0x00, 0x22, 0x00, 0xE6, 0x01, // "æ (U+0022 U+00E6)
  0x00, 0x22, 0x00, 0xE7, 0x02, // "ç (U+0022 U+00E7)
  0x00, 0x22, 0x00, 0xE8, 0x02, // "è (U+0022 U+00E8)
  0x00, 0x22, 0x00, 0xE9, 0x02, // "é (U+0022 U+00E9)
  0x00, 0x22, 0x00, 0xEA, 0x02, // "ê (U+0022 U+00EA)
  0x00, 0x22, 0x00, 0xEB, 0x02, // "ë (U+0022 U+00EB)
  0x00, 0x22, 0x00, 0xF1, 0x01, // "ñ (U+0022 U+00F1)
  0x00, 0x22, 0x00, 0xF2, 0x02, // "ò (U+0022 U+00F2)
  0x00, 0x22, 0x00, 0xF3, 0x02, // "ó (U+0022 U+00F3)
  0x00, 0x22, 0x00, 0xF4, 0x02, // "ô (U+0022 U+00F4)
  0x00, 0x22, 0x00, 0xF5, 0x02, // "õ (U+0022 U+00F5)
  0x00, 0x22, 0x00, 0xF6, 0x02, // "ö (U+0022 U+00F6)
  0x00, 0x22, 0x00, 0xF8, 0x02, // "ø (U+0022 U+00F8)
  0x00, 0x22, 0x00, 0xF9, 0x01, // "ù (U+0022 U+00F9)
  0x00, 0x22, 0x00, 0xFA, 0x01, // "ú (U+0022 U+00FA)
  0x00, 0x22, 0x00, 0xFB, 0x01, // "û (U+0022 U+00FB)
  0x00, 0x22, 0x00, 0xFC, 0x01, // "ü (U+0022 U+00FC)
  0x00, 0x22, 0x01, 0x00, 0x02, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x01, 0x01, // "ā (U+0022 U+0101)
  0x00, 0x22, 0x01, 0x02, 0x02, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x03, 0x01, // "ă (U+0022 U+0103)
  0x00, 0x22, 0x01, 0x04, 0x02, // "Ą (U+0022 U+0104)
  0x00, 0x22, 0x01, 0x05, 0x01, // "ą (U+0022 U+0105)
  0x00, 0x22, 0x01, 0x07, 0x02, // "ć (U+0022 U+0107)
  0x00, 0x22, 0x01, 0x09, 0x02, // "ĉ (U+0022 U+0109)
  0x00, 0x22, 0x01, 0x0B, 0x02, // "ċ (U+0022 U+010B)
  0x00, 0x22, 0x01, 0x0D, 0x02, // "č (U+0022 U+010D)
  0x00, 0x22, 0x01, 0x0F, 0x02, // "ď (U+0022 U+010F)
  0x00, 0x22, 0x01, 0x11, 0x02, // "đ (U+0022 U+0111)
  0x00, 0x22, 0x01, 0x13, 0x02, // "ē (U+0022 U+0113)
  0x00, 0x22, 0x01, 0x15, 0x02, // "ĕ (U+0022 U+0115)
  0x00, 0x22, 0x01, 0x17, 0x02, // "ė (U+0022 U+0117)
  0x00, 0x22, 0x01, 0x19, 0x02, // "ę (U+0022 U+0119)
  0x00, 0x22, 0x01, 0x1B, 0x02, // "ě (U+0022 U+011B)
  0x00, 0x22, 0x01, 0x1D, 0x01, // "ĝ (U+0022 U+011D)
  0x00, 0x22, 0x01, 0x1F, 0x01, // "ğ (U+0022 U+011F)
  0x00, 0x22, 0x01, 0x21, 0x01, // "ġ (U+0022 U+0121)
  0x00, 0x22, 0x01, 0x23, 0x01, // "ģ (U+0022 U+0123)
  0x00, 0x22, 0x01, 0x38, 0x01, // "ĸ (U+0022 U+0138)
  0x00, 0x22, 0x01, 0x44, 0x01, // "ń (U+0022 U+0144)
  0x00, 0x22, 0x01, 0x46, 0x01, // "ņ (U+0022 U+0146)
  0x00, 0x22, 0x01, 0x48, 0x01, // "ň (U+0022 U+0148)
  0x00, 0x22, 0x01, 0x4B, 0x01, // "ŋ (U+0022 U+014B)
  0x00, 0x22, 0x01, 0x4D, 0x02, // "ō (U+0022 U+014D)
  0x00, 0x22, 0x01, 0x4F, 0x02, // "ŏ (U+0022 U+014F)
  0x00, 0x22, 0x01, 0x51, 0x02, // "ő (U+0022 U+0151)
  0x00, 0x22, 0x01, 0x53, 0x02, // "œ (U+0022 U+0153)
  0x00, 0x22, 0x01, 0x55, 0x01, // "ŕ (U+0022 U+0155)
  0x00, 0x22, 0x01, 0x57, 0x01, // "ŗ (U+0022 U+0157)
  0x00, 0x22, 0x01, 0x5B, 0x01, // "ś (U+0022 U+015B)
  0x00, 0x22, 0x01, 0x5D, 0x01, // "ŝ (U+0022 U+015D)
  0x00, 0x22, 0x01, 0x5F, 0x01, // "ş (U+0022 U+015F)
  0x00, 0x22, 0x01, 0x61, 0x01, // "š (U+0022 U+0161)
  0x00, 0x22, 0x01, 0x69, 0x01, // "ũ (U+0022 U+0169)
  0x00, 0x22, 0x01, 0x6B, 0x01, // "ū (U+0022 U+016B)
  0x00, 0x22, 0x01, 0x6D, 0x01, // "ŭ (U+0022 U+016D)
  0x00, 0x22, 0x01, 0x6F, 0x01, // "ů (U+0022 U+016F)
  0x00, 0x22, 0x01, 0x71, 0x01, // "ű (U+0022 U+0171)
  0x00, 0x22, 0x01, 0x73, 0x01, // "ų (U+0022 U+0173)
  0x00, 0x26, 0x00, 0x54, 0x01, // &T (U+0026 U+0054)
  0x00, 0x26, 0x00, 0x56, 0x01, // &V (U+0026 U+0056)
  0x00, 0x26, 0x00, 0x57, 0x01, // &W (U+0026 U+0057)
  0x00, 0x26, 0x00, 0x59, 0x01, // &Y (U+0026 U+0059)
  0x00, 0x26, 0x00, 0xDD, 0x01, // &Ý (U+0026 U+00DD)
  0x00, 0x26, 0x01, 0x62, 0x01, // &Ţ (U+0026 U+0162)
  0x00, 0x26, 0x01, 0x64, 0x01, // &Ť (U+0026 U+0164)
  0x00, 0x26, 0x01, 0x66, 0x01, // &Ŧ (U+0026 U+0166)
  0x00, 0x26, 0x01, 0x74, 0x01, // &Ŵ (U+0026 U+0174)
  0x00, 0x26, 0x01, 0x76, 0x01, // &Ŷ (U+0026 U+0176)
  0x00, 0x26, 0x01, 0x78, 0x01, // &Ÿ (U+0026 U+0178)
  0x00, 0x27, 0x00, 0x41, 0x02, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0x61, 0x01, // 'a (U+0027 U+0061)
  0x00, 0x27, 0x00, 0x63, 0x02, // 'c (U+0027 U+0063)
  0x00, 0x27, 0x00, 0x64, 0x02, // 'd (U+0027 U+0064)
  0x00, 0x27, 0x00, 0x65, 0x02, // 'e (U+0027 U+0065)
  0x00, 0x27, 0x00, 0x67, 0x01, // 'g (U+0027 U+0067)
  0x00, 0x27, 0x00, 0x6D, 0x01, // 'm (U+0027 U+006D)
  0x00, 0x27, 0x00, 0x6E, 0x01, // 'n (U+0027 U+006E)
  0x00, 0x27, 0x00, 0x6F, 0x02, // 'o (U+0027 U+006F)
  0x00, 0x27, 0x00, 0x70, 0x01, // 'p (U+0027 U+0070)
  0x00, 0x27, 0x00, 0x71, 0x02, // 'q (U+0027 U+0071)
  0x00, 0x27, 0x00, 0x72, 0x01, // 'r (U+0027 U+0072)
  0x00, 0x27, 0x00, 0x73, 0x01, // 's (U+0027 U+0073)
  0x00, 0x27, 0x00, 0x75, 0x01, // 'u (U+0027 U+0075)
  0x00, 0x27, 0x00, 0xC0, 0x02, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x02, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x02, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x02, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x02, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x02, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xE0, 0x02, // 'à (U+0027 U+00E0)
  0x00, 0x27, 0x00, 0xE1, 0x01, // 'á (U+0027 U+00E1)
  0x00, 0x27, 0x00, 0xE2, 0x01, // 'â (U+0027 U+00E2)
  0x00, 0x27, 0x00, 0xE3, 0x01, // 'ã (U+0027 U+00E3)
  0x00, 0x27, 0x00, 0xE4, 0x01, // 'ä (U+0027 U+00E4)
  0x00, 0x27, 0x00, 0xE5, 0x01, // 'å (U+0027 U+00E5)
  0x00, 0x27, 0x00, 0xE6, 0x01, // 'æ (U+0027 U+00E6)
  0x00, 0x27, 0x00, 0xE7, 0x02, // 'ç (U+0027 U+00E7)
  0x00, 0x27, 0x00, 0xE8, 0x02, // 'è (U+0027 U+00E8)
  0x00, 0x27, 0x00, 0xE9, 0x02, // 'é (U+0027 U+00E9)
  0x00, 0x27, 0x00, 0xEA, 0x02, // 'ê (U+0027 U+00EA)
  0x00, 0x27, 0x00, 0xEB, 0x02, // 'ë (U+0027 U+00EB)
  0x00, 0x27, 0x00, 0xF1, 0x01, // 'ñ (U+0027 U+00F1)
  0x00, 0x27, 0x00, 0xF2, 0x02, // 'ò (U+0027 U+00F2)
  0x00, 0x27, 0x00, 0xF3, 0x02, // 'ó (U+0027 U+00F3)
  0x00, 0x27, 0x00, 0xF4, 0x02, // 'ô (U+0027 U+00F4)
  0x00, 0x27, 0x00, 0xF5, 0x02, // 'õ (U+0027 U+00F5)
  0x00, 0x27, 0x00, 0xF6, 0x02, // 'ö (U+0027 U+00F6)
  0x00, 0x27, 0x00, 0xF8, 0x02, // 'ø (U+0027 U+00F8)
  0x00, 0x27, 0x00, 0xF9, 0x01, // 'ù (U+0027 U+00F9)
  0x00, 0x27, 0x00, 0xFA, 0x01, // 'ú (U+0027 U+00FA)
  0x00, 0x27, 0x00, 0xFB, 0x01, // 'û (U+0027 U+00FB)
  0x00, 0x27, 0x00, 0xFC, 0x01, // 'ü (U+0027 U+00FC)
  0x00, 0x27, 0x01, 0x00, 0x02, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x01, 0x01, // 'ā (U+0027 U+0101)
  0x00, 0x27, 0x01, 0x02, 0x02, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x03, 0x01, // 'ă (U+0027 U+0103)
  0x00, 0x27, 0x01, 0x04, 0x02, // 'Ą (U+0027 U+0104)
  0x00, 0x27, 0x01, 0x05, 0x01, // 'ą (U+0027 U+0105)
  0x00, 0x27, 0x01, 0x07, 0x02, // 'ć (U+0027 U+0107)
  0x00, 0x27, 0x01, 0x09, 0x02, // 'ĉ (U+0027 U+0109)
  0x00, 0x27, 0x01, 0x0B, 0x02, // 'ċ (U+0027 U+010B)
  0x00, 0x27, 0x01, 0x0D, 0x02, // 'č (U+0027 U+010D)
  0x00, 0x27, 0x01, 0x0F, 0x02, // 'ď (U+0027 U+010F)
  0x00, 0x27, 0x01, 0x11, 0x02, // 'đ (U+0027 U+0111)
  0x00, 0x27, 0x01, 0x13, 0x02, // 'ē (U+0027 U+0113)
  0x00, 0x27, 0x01, 0x15, 0x02, // 'ĕ (U+0027 U+0115)
  0x00, 0x27, 0x01, 0x17, 0x02, // 'ė (U+0027 U+0117)
  0x00, 0x27, 0x01, 0x19, 0x02, // 'ę (U+0027 U+0119)
  0x00, 0x27, 0x01, 0x1B, 0x02, // 'ě (U+0027 U+011B)
  0x00, 0x27, 0x01, 0x1D, 0x01, // 'ĝ (U+0027 U+011D)
  0x00, 0x27, 0x01, 0x1F, 0x01, // 'ğ (U+0027 U+011F)
  0x00, 0x27, 0x01, 0x21, 0x01, // 'ġ (U+0027 U+0121)
  0x00, 0x27, 0x01, 0x23, 0x01, // 'ģ (U+0027 U+0123)
  0x00, 0x27, 0x01, 0x38, 0x01, // 'ĸ (U+0027 U+0138)
  0x00, 0x27, 0x01, 0x44, 0x01, // 'ń (U+0027 U+0144)
  0x00, 0x27, 0x01, 0x46, 0x01, // 'ņ (U+0027 U+0146)
  0x00, 0x27, 0x01, 0x48, 0x01, // 'ň (U+0027 U+0148)
  0x00, 0x27, 0x01, 0x4B, 0x01, // 'ŋ (U+0027 U+014B)
  0x00, 0x27, 0x01, 0x4D, 0x02, // 'ō (U+0027 U+014D)
  0x00, 0x27, 0x01, 0x4F, 0x02, // 'ŏ (U+0027 U+014F)
  0x00, 0x27, 0x01, 0x51, 0x02, // 'ő (U+0027 U+0151)
  0x00, 0x27, 0x01, 0x53, 0x02, // 'œ (U+0027 U+0153)
  0x00, 0x27, 0x01, 0x55, 0x01, // 'ŕ (U+0027 U+0155)
  0x00, 0x27, 0x01, 0x57, 0x01, // 'ŗ (U+0027 U+0157)
  0x00, 0x27, 0x01, 0x5B, 0x01, // 'ś (U+0027 U+015B)
  0x00, 0x27, 0x01, 0x5D, 0x01, // 'ŝ (U+0027 U+015D)
  0x00, 0x27, 0x01, 0x5F, 0x01, // 'ş (U+0027 U+015F)
  0x00, 0x27, 0x01, 0x61, 0x01, // 'š (U+0027 U+0161)
  0x00, 0x27, 0x01, 0x69, 0x01, // 'ũ (U+0027 U+0169)
  0x00, 0x27, 0x01, 0x6B, 0x01, // 'ū (U+0027 U+016B)
  0x00, 0x27, 0x01, 0x6D, 0x01, // 'ŭ (U+0027 U+016D)
  0x00, 0x27, 0x01, 0x6F, 0x01, // 'ů (U+0027 U+016F)
  0x00, 0x27, 0x01, 0x71, 0x01, // 'ű (U+0027 U+0171)
  0x00, 0x27, 0x01, 0x73, 0x01, // 'ų (U+0027 U+0173)
  0x00, 0x2C, 0x00, 0x43, 0x01, // ,C (U+002C U+0043)
  0x00, 0x2C, 0x00, 0x47, 0x01, // ,G (U+002C U+0047)
  0x00, 0x2C, 0x00, 0x4F, 0x01, // ,O (U+002C U+004F)
  0x00, 0x2C, 0x00, 0x51, 0x01, // ,Q (U+002C U+0051)
  0x00, 0x2C, 0x00, 0x54, 0x02, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x56, 0x01, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x01, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x01, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0xC7, 0x01, // ,Ç (U+002C U+00C7)
  0x00, 0x2C, 0x00, 0xD2, 0x01, // ,Ò (U+002C U+00D2)
  0x00, 0x2C, 0x00, 0xD3, 0x01, // ,Ó (U+002C U+00D3)
  0x00, 0x2C, 0x00, 0xD4, 0x01, // ,Ô (U+002C U+00D4)
  0x00, 0x2C, 0x00, 0xD5, 0x01, // ,Õ (U+002C U+00D5)
  0x00, 0x2C, 0x00, 0xD6, 0x01, // ,Ö (U+002C U+00D6)
  0x00, 0x2C, 0x00, 0xD8, 0x01, // ,Ø (U+002C U+00D8)
  0x00, 0x2C, 0x00, 0xDD, 0x01, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x01, 0x06, 0x01, // ,Ć (U+002C U+0106)
  0x00, 0x2C, 0x01, 0x08, 0x01, // ,Ĉ (U+002C U+0108)
  0x00, 0x2C, 0x01, 0x0A, 0x01, // ,Ċ (U+002C U+010A)
  0x00, 0x2C, 0x01, 0x0C, 0x01, // ,Č (U+002C U+010C)
  0x00, 0x2C, 0x01, 0x1C, 0x01, // ,Ĝ (U+002C U+011C)
  0x00, 0x2C, 0x01, 0x1E, 0x01, // ,Ğ (U+002C U+011E)
  0x00, 0x2C, 0x01, 0x20, 0x01, // ,Ġ (U+002C U+0120)
  0x00, 0x2C, 0x01, 0x22, 0x01, // ,Ģ (U+002C U+0122)
  0x00, 0x2C, 0x01, 0x4C, 0x01, // ,Ō (U+002C U+014C)
  0x00, 0x2C, 0x01, 0x4E, 0x01, // ,Ŏ (U+002C U+014E)
  0x00, 0x2C, 0x01, 0x50, 0x01, // ,Ő (U+002C U+0150)
  0x00, 0x2C, 0x01, 0x52, 0x01, // ,Œ (U+002C U+0152)
  0x00, 0x2C, 0x01, 0x62, 0x02, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x02, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x02, // ,Ŧ (U+002C U+0166)
  0x00, 0x2C, 0x01, 0x74, 0x01, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x76, 0x01, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x78, 0x01, // ,Ÿ (U+002C U+0178)
  0x00, 0x2D, 0x00, 0x54, 0x01, // -T (U+002D U+0054)
  0x00, 0x2D, 0x01, 0x62, 0x01, // -Ţ (U+002D U+0162)
  0x00, 0x2D, 0x01, 0x64, 0x01, // -Ť (U+002D U+0164)
  0x00, 0x2D, 0x01, 0x66, 0x01, // -Ŧ (U+002D U+0166)
  0x00, 0x2E, 0x00, 0x43, 0x01, // .C (U+002E U+0043)
  0x00, 0x2E, 0x00, 0x47, 0x01, // .G (U+002E U+0047)
  0x00, 0x2E, 0x00, 0x4F, 0x01, // .O (U+002E U+004F)
  0x00, 0x2E, 0x00, 0x51, 0x01, // .Q (U+002E U+0051)
  0x00, 0x2E, 0x00, 0x54, 0x02, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x56, 0x01, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x01, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x01, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0xC7, 0x01, // .Ç (U+002E U+00C7)
  0x00, 0x2E, 0x00, 0xD2, 0x01, // .Ò (U+002E U+00D2)
  0x00, 0x2E, 0x00, 0xD3, 0x01, // .Ó (U+002E U+00D3)
  0x00, 0x2E, 0x00, 0xD4, 0x01, // .Ô (U+002E U+00D4)
  0x00, 0x2E, 0x00, 0xD5, 0x01, // .Õ (U+002E U+00D5)
  0x00, 0x2E, 0x00, 0xD6, 0x01, // .Ö (U+002E U+00D6)
  0x00, 0x2E, 0x00, 0xD8, 0x01, // .Ø (U+002E U+00D8)
  0x00, 0x2E, 0x00, 0xDD, 0x01, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x01, 0x06, 0x01, // .Ć (U+002E U+0106)
  0x00, 0x2E, 0x01, 0x08, 0x01, // .Ĉ (U+002E U+0108)
  0x00, 0x2E, 0x01, 0x0A, 0x01, // .Ċ (U+002E U+010A)
  0x00, 0x2E, 0x01, 0x0C, 0x01, // .Č (U+002E U+010C)
  0x00, 0x2E, 0x01, 0x1C, 0x01, // .Ĝ (U+002E U+011C)
  0x00, 0x2E, 0x01, 0x1E, 0x01, // .Ğ (U+002E U+011E)
  0x00, 0x2E, 0x01, 0x20, 0x01, // .Ġ (U+002E U+0120)
  0x00, 0x2E, 0x01, 0x22, 0x01, // .Ģ (U+002E U+0122)
  0x00, 0x2E, 0x01, 0x4C, 0x01, // .Ō (U+002E U+014C)
  0x00, 0x2E, 0x01, 0x4E, 0x01, // .Ŏ (U+002E U+014E)
  0x00, 0x2E, 0x01, 0x50, 0x01, // .Ő (U+002E U+0150)
  0x00, 0x2E, 0x01, 0x52, 0x01, // .Œ (U+002E U+0152)
  0x00, 0x2E, 0x01, 0x62, 0x02, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x02, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x02, // .Ŧ (U+002E U+0166)
  0x00, 0x2E, 0x01, 0x74, 0x01, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x76, 0x01, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x78, 0x01, // .Ÿ (U+002E U+0178)
  0x00, 0x30, 0x20, 0x44, 0x04, // 0⁄ (U+0030 U+2044)
  0x00, 0x31, 0x20, 0x44, 0x04, // 1⁄ (U+0031 U+2044)
  0x00, 0x32, 0x20, 0x44, 0x04, // 2⁄ (U+0032 U+2044)
  0x00, 0x33, 0x20, 0x44, 0x04, // 3⁄ (U+0033 U+2044)
  0x00, 0x34, 0x20, 0x44, 0x04, // 4⁄ (U+0034 U+2044)
  0x00, 0x35, 0x20, 0x44, 0x04, // 5⁄ (U+0035 U+2044)
  0x00, 0x36, 0x20, 0x44, 0x04, // 6⁄ (U+0036 U+2044)
  0x00, 0x37, 0x20, 0x44, 0x04, // 7⁄ (U+0037 U+2044)
  0x00, 0x38, 0x20, 0x44, 0x04, // 8⁄ (U+0038 U+2044)
  0x00, 0x39, 0x20, 0x44, 0x04, // 9⁄ (U+0039 U+2044)
  0x00, 0x41, 0x00, 0x22, 0x02, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x02, // A' (U+0041 U+0027)
  0x00, 0x41, 0x00, 0x54, 0x01, // AT (U+0041 U+0054)
  0x00, 0x41, 0x00, 0x59, 0x01, // AY (U+0041 U+0059)
  0x00, 0x41, 0x00, 0xDD, 0x01, // AÝ (U+0041 U+00DD)
  0x00, 0x41, 0x01, 0x62, 0x01, // AŢ (U+0041 U+0162)
  0x00, 0x41, 0x01, 0x64, 0x01, // AŤ (U+0041 U+0164)
  0x00, 0x41, 0x01, 0x66, 0x01, // AŦ (U+0041 U+0166)
  0x00, 0x41, 0x01, 0x76, 0x01, // AŶ (U+0041 U+0176)
  0x00, 0x41, 0x01, 0x78, 0x01, // AŸ (U+0041 U+0178)
  0x00, 0x41, 0x20, 0x19, 0x02, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1D, 0x02, // A” (U+0041 U+201D)
  0x00, 0x43, 0x00, 0x43, 0x01, // CC (U+0043 U+0043)
  0x00, 0x43, 0x00, 0x47, 0x01, // CG (U+0043 U+0047)
  0x00, 0x43, 0x00, 0x4F, 0x01, // CO (U+0043 U+004F)
  0x00, 0x43, 0x00, 0x51, 0x01, // CQ (U+0043 U+0051)
  0x00, 0x43, 0x00, 0xAB, 0x01, // C« (U+0043 U+00AB)
  0x00, 0x43, 0x00, 0xC7, 0x01, // CÇ (U+0043 U+00C7)
  0x00, 0x43, 0x00, 0xD2, 0x01, // CÒ (U+0043 U+00D2)
  0x00, 0x43, 0x00, 0xD3, 0x01, // CÓ (U+0043 U+00D3)
  0x00, 0x43, 0x00, 0xD4, 0x01, // CÔ (U+0043 U+00D4)
  0x00, 0x43, 0x00, 0xD5, 0x01, // CÕ (U+0043 U+00D5)
  0x00, 0x43, 0x00, 0xD6, 0x01, // CÖ (U+0043 U+00D6)
  0x00, 0x43, 0x00, 0xD8, 0x01, // CØ (U+0043 U+00D8)
  0x00, 0x43, 0x01, 0x06, 0x01, // CĆ (U+0043 U+0106)
  0x00, 0x43, 0x01, 0x08, 0x01, // CĈ (U+0043 U+0108)
  0x00, 0x43, 0x01, 0x0A, 0x01, // CĊ (U+0043 U+010A)
  0x00, 0x43, 0x01, 0x0C, 0x01, // CČ (U+0043 U+010C)
  0x00, 0x43, 0x01, 0x1C, 0x01, // CĜ (U+0043 U+011C)
  0x00, 0x43, 0x01, 0x1E, 0x01, // CĞ (U+0043 U+011E)
  0x00, 0x43, 0x01, 0x20, 0x01, // CĠ (U+0043 U+0120)
  0x00, 0x43, 0x01, 0x22, 0x01, // CĢ (U+0043 U+0122)
  0x00, 0x43, 0x01, 0x4C, 0x01, // CŌ (U+0043 U+014C)
  0x00, 0x43, 0x01, 0x4E, 0x01, // CŎ (U+0043 U+014E)
  0x00, 0x43, 0x01, 0x50, 0x01, // CŐ (U+0043 U+0150)
  0x00, 0x43, 0x01, 0x52, 0x01, // CŒ (U+0043 U+0152)
  0x00, 0x43, 0x20, 0x39, 0x01, // C‹ (U+0043 U+2039)
  0x00, 0x44, 0x00, 0x2C, 0x01, // D, (U+0044 U+002C)
  0x00, 0x44, 0x00, 0x2E, 0x01, // D. (U+0044 U+002E)
  0x00, 0x44, 0x00, 0x54, 0x01, // DT (U+0044 U+0054)
  0x00, 0x44, 0x01, 0x62, 0x01, // DŢ (U+0044 U+0162)
  0x00, 0x44, 0x01, 0x64, 0x01, // DŤ (U+0044 U+0164)
  0x00, 0x44, 0x01, 0x66, 0x01, // DŦ (U+0044 U+0166)
  0x00, 0x44, 0x20, 0x1A, 0x01, // D‚ (U+0044 U+201A)
  0x00, 0x44, 0x20, 0x1E, 0x01, // D„ (U+0044 U+201E)
  0x00, 0x44, 0x20, 0x26, 0x01, // D… (U+0044 U+2026)
  0x00, 0x46, 0x00, 0x2C, 0x02, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x02, // F. (U+0046 U+002E)
  0x00, 0x46, 0x20, 0x1A, 0x02, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x02, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x02, // F… (U+0046 U+2026)
  0x00, 0x4B, 0x00, 0xAB, 0x01, // K« (U+004B U+00AB)
  0x00, 0x4B, 0x20, 0x39, 0x01, // K‹ (U+004B U+2039)
  0x00, 0x4C, 0x00, 0x22, 0x02, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x02, // L' (U+004C U+0027)
  0x00, 0x4C, 0x00, 0x43, 0x01, // LC (U+004C U+0043)
  0x00, 0x4C, 0x00, 0x47, 0x01, // LG (U+004C U+0047)
  0x00, 0x4C, 0x00, 0x4F, 0x01, // LO (U+004C U+004F)
  0x00, 0x4C, 0x00, 0x51, 0x01, // LQ (U+004C U+0051)
  0x00, 0x4C, 0x00, 0x54, 0x01, // LT (U+004C U+0054)
  0x00, 0x4C, 0x00, 0x56, 0x01, // LV (U+004C U+0056)
  0x00, 0x4C, 0x00, 0x57, 0x01, // LW (U+004C U+0057)
  0x00, 0x4C, 0x00, 0x59, 0x01, // LY (U+004C U+0059)
  0x00, 0x4C, 0x00, 0xAB, 0x01, // L« (U+004C U+00AB)
  0x00, 0x4C, 0x00, 0xC7, 0x01, // LÇ (U+004C U+00C7)
  0x00, 0x4C, 0x00, 0xD2, 0x01, // LÒ (U+004C U+00D2)
  0x00, 0x4C, 0x00, 0xD3, 0x01, // LÓ (U+004C U+00D3)
  0x00, 0x4C, 0x00, 0xD4, 0x01, // LÔ (U+004C U+00D4)
  0x00, 0x4C, 0x00, 0xD5, 0x01, // LÕ (U+004C U+00D5)
  0x00, 0x4C, 0x00, 0xD6, 0x01, // LÖ (U+004C U+00D6)
  0x00, 0x4C, 0x00, 0xD8, 0x01, // LØ (U+004C U+00D8)
  0x00, 0x4C, 0x00, 0xDD, 0x01, // LÝ (U+004C U+00DD)
  0x00, 0x4C, 0x01, 0x06, 0x01, // LĆ (U+004C U+0106)
  0x00, 0x4C, 0x01, 0x08, 0x01, // LĈ (U+004C U+0108)
  0x00, 0x4C, 0x01, 0x0A, 0x01, // LĊ (U+004C U+010A)
  0x00, 0x4C, 0x01, 0x0C, 0x01, // LČ (U+004C U+010C)
  0x00, 0x4C, 0x01, 0x1C, 0x01, // LĜ (U+004C U+011C)
  0x00, 0x4C, 0x01, 0x1E, 0x01, // LĞ (U+004C U+011E)
  0x00, 0x4C, 0x01, 0x20, 0x01, // LĠ (U+004C U+0120)
  0x00, 0x4C, 0x01, 0x22, 0x01, // LĢ (U+004C U+0122)
  0x00, 0x4C, 0x01, 0x4C, 0x01, // LŌ (U+004C U+014C)
  0x00, 0x4C, 0x01, 0x4E, 0x01, // LŎ (U+004C U+014E)
  0x00, 0x4C, 0x01, 0x50, 0x01, // LŐ (U+004C U+0150)
  0x00, 0x4C, 0x01, 0x52, 0x01, // LŒ (U+004C U+0152)
  0x00, 0x4C, 0x01, 0x62, 0x01, // LŢ (U+004C U+0162)
  0x00, 0x4C, 0x01, 0x64, 0x01, // LŤ (U+004C U+0164)
  0x00, 0x4C, 0x01, 0x66, 0x01, // LŦ (U+004C U+0166)
  0x00, 0x4C, 0x01, 0x74, 0x01, // LŴ (U+004C U+0174)
  0x00, 0x4C, 0x01, 0x76, 0x01, // LŶ (U+004C U+0176)
  0x00, 0x4C, 0x01, 0x78, 0x01, // LŸ (U+004C U+0178)
  0x00, 0x4C, 0x20, 0x19, 0x02, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1D, 0x02, // L” (U+004C U+201D)
  0x00, 0x4C, 0x20, 0x39, 0x01, // L‹ (U+004C U+2039)
  0x00, 0x4F, 0x00, 0x2C, 0x01, // O, (U+004F U+002C)
  0x00, 0x4F, 0x00, 0x2E, 0x01, // O. (U+004F U+002E)
  0x00, 0x4F, 0x00, 0x54, 0x01, // OT (U+004F U+0054)
  0x00, 0x4F, 0x01, 0x62, 0x01, // OŢ (U+004F U+0162)
  0x00, 0x4F, 0x01, 0x64, 0x01, // OŤ (U+004F U+0164)
  0x00, 0x4F, 0x01, 0x66, 0x01, // OŦ (U+004F U+0166)
  0x00, 0x4F, 0x20, 0x1A, 0x01, // O‚ (U+004F U+201A)
  0x00, 0x4F, 0x20, 0x1E, 0x01, // O„ (U+004F U+201E)
  0x00, 0x4F, 0x20, 0x26, 0x01, // O… (U+004F U+2026)
  0x00, 0x50, 0x00, 0x2C, 0x04, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x04, // P. (U+0050 U+002E)
  0x00, 0x50, 0x00, 0x41, 0x01, // PA (U+0050 U+0041)
  0x00, 0x50, 0x00, 0x58, 0x01, // PX (U+0050 U+0058)
  0x00, 0x50, 0x00, 0xC0, 0x01, // PÀ (U+0050 U+00C0)
  0x00, 0x50, 0x00, 0xC1, 0x01, // PÁ (U+0050 U+00C1)
  0x00, 0x50, 0x00, 0xC2, 0x01, // PÂ (U+0050 U+00C2)
  0x00, 0x50, 0x00, 0xC3, 0x01, // PÃ (U+0050 U+00C3)
  0x00, 0x50, 0x00, 0xC4, 0x01, // PÄ (U+0050 U+00C4)
  0x00, 0x50, 0x00, 0xC5, 0x01, // PÅ (U+0050 U+00C5)
  0x00, 0x50, 0x01, 0x00, 0x01, // PĀ (U+0050 U+0100)
  0x00, 0x50, 0x01, 0x02, 0x01, // PĂ (U+0050 U+0102)
  0x00, 0x50, 0x01, 0x04, 0x01, // PĄ (U+0050 U+0104)
  0x00, 0x50, 0x20, 0x1A, 0x04, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x04, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x04, // P… (U+0050 U+2026)
  0x00, 0x51, 0x00, 0x2C, 0x01, // Q, (U+0051 U+002C)
  0x00, 0x51, 0x00, 0x2E, 0x01, // Q. (U+0051 U+002E)
  0x00, 0x51, 0x00, 0x54, 0x01, // QT (U+0051 U+0054)
  0x00, 0x51, 0x01, 0x62, 0x01, // QŢ (U+0051 U+0162)
  0x00, 0x51, 0x01, 0x64, 0x01, // QŤ (U+0051 U+0164)
  0x00, 0x51, 0x01, 0x66, 0x01, // QŦ (U+0051 U+0166)
  0x00, 0x51, 0x20, 0x1A, 0x01, // Q‚ (U+0051 U+201A)
  0x00, 0x51, 0x20, 0x1E, 0x01, // Q„ (U+0051 U+201E)
  0x00, 0x51, 0x20, 0x26, 0x01, // Q… (U+0051 U+2026)
  0x00, 0x54, 0x00, 0x2C, 0x02, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2D, 0x01, // T- (U+0054 U+002D)
  0x00, 0x54, 0x00, 0x2E, 0x02, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0x41, 0x01, // TA (U+0054 U+0041)
  0x00, 0x54, 0x00, 0x61, 0x01, // Ta (U+0054 U+0061)
  0x00, 0x54, 0x00, 0x63, 0x01, // Tc (U+0054 U+0063)
  0x00, 0x54, 0x00, 0x64, 0x01, // Td (U+0054 U+0064)
  0x00, 0x54, 0x00, 0x65, 0x01, // Te (U+0054 U+0065)
  0x00, 0x54, 0x00, 0x67, 0x01, // Tg (U+0054 U+0067)
  0x00, 0x54, 0x00, 0x6D, 0x01, // Tm (U+0054 U+006D)
  0x00, 0x54, 0x00, 0x6E, 0x01, // Tn (U+0054 U+006E)
  0x00, 0x54, 0x00, 0x6F, 0x01, // To (U+0054 U+006F)
  0x00, 0x54, 0x00, 0x70, 0x01, // Tp (U+0054 U+0070)
  0x00, 0x54, 0x00, 0x71, 0x01, // Tq (U+0054 U+0071)
  0x00, 0x54, 0x00, 0x72, 0x01, // Tr (U+0054 U+0072)
  0x00, 0x54, 0x00, 0x73, 0x01, // Ts (U+0054 U+0073)
  0x00, 0x54, 0x00, 0x75, 0x01, // Tu (U+0054 U+0075)
  0x00, 0x54, 0x00, 0x76, 0x01, // Tv (U+0054 U+0076)
  0x00, 0x54, 0x00, 0x77, 0x01, // Tw (U+0054 U+0077)
  0x00, 0x54, 0x00, 0x79, 0x01, // Ty (U+0054 U+0079)
  0x00, 0x54, 0x00, 0x7A, 0x01, // Tz (U+0054 U+007A)
  0x00, 0x54, 0x00, 0xAB, 0x01, // T« (U+0054 U+00AB)
  0x00, 0x54, 0x00, 0xBB, 0x01, // T» (U+0054 U+00BB)
  0x00, 0x54, 0x00, 0xC0, 0x01, // TÀ (U+0054 U+00C0)
  0x00, 0x54, 0x00, 0xC1, 0x01, // TÁ (U+0054 U+00C1)
  0x00, 0x54, 0x00, 0xC2, 0x01, // TÂ (U+0054 U+00C2)
  0x00, 0x54, 0x00, 0xC3, 0x01, // TÃ (U+0054 U+00C3)
  0x00, 0x54, 0x00, 0xC4, 0x01, // TÄ (U+0054 U+00C4)
  0x00, 0x54, 0x00, 0xC5, 0x01, // TÅ (U+0054 U+00C5)
  0x00, 0x54, 0x00, 0xE0, 0x01, // Tà (U+0054 U+00E0)
  0x00, 0x54, 0x00, 0xE1, 0x01, // Tá (U+0054 U+00E1)
  0x00, 0x54, 0x00, 0xE2, 0x01, // Tâ (U+0054 U+00E2)
  0x00, 0x54, 0x00, 0xE3, 0x01, // Tã (U+0054 U+00E3)
  0x00, 0x54, 0x00, 0xE4, 0x01, // Tä (U+0054 U+00E4)
  0x00, 0x54, 0x00, 0xE5, 0x01, // Tå (U+0054 U+00E5)
  0x00, 0x54, 0x00, 0xE6, 0x01, // Tæ (U+0054 U+00E6)
  0x00, 0x54, 0x00, 0xE7, 0x01, // Tç (U+0054 U+00E7)
  0x00, 0x54, 0x00, 0xE8, 0x01, // Tè (U+0054 U+00E8)
  0x00, 0x54, 0x00, 0xE9, 0x01, // Té (U+0054 U+00E9)
  0x00, 0x54, 0x00, 0xEA, 0x01, // Tê (U+0054 U+00EA)
  0x00, 0x54, 0x00, 0xEB, 0x01, // Të (U+0054 U+00EB)
  0x00, 0x54, 0x00, 0xF1, 0x01, // Tñ (U+0054 U+00F1)
  0x00, 0x54, 0x00, 0xF2, 0x01, // Tò (U+0054 U+00F2)
  0x00, 0x54, 0x00, 0xF3, 0x01, // Tó (U+0054 U+00F3)
  0x00, 0x54, 0x00, 0xF4, 0x01, // Tô (U+0054 U+00F4)
  0x00, 0x54, 0x00, 0xF5, 0x01, // Tõ (U+0054 U+00F5)
  0x00, 0x54, 0x00, 0xF6, 0x01, // Tö (U+0054 U+00F6)
  0x00, 0x54, 0x00, 0xF8, 0x01, // Tø (U+0054 U+00F8)
  0x00, 0x54, 0x00, 0xF9, 0x01, // Tù (U+0054 U+00F9)
  0x00, 0x54, 0x00, 0xFA, 0x01, // Tú (U+0054 U+00FA)
  0x00, 0x54, 0x00, 0xFB, 0x01, // Tû (U+0054 U+00FB)
  0x00, 0x54, 0x00, 0xFC, 0x01, // Tü (U+0054 U+00FC)
  0x00, 0x54, 0x00, 0xFD, 0x01, // Tý (U+0054 U+00FD)
  0x00, 0x54, 0x00, 0xFF, 0x01, // Tÿ (U+0054 U+00FF)
  0x00, 0x54, 0x01, 0x00, 0x01, // TĀ (U+0054 U+0100)
  0x00, 0x54, 0x01, 0x01, 0x01, // Tā (U+0054 U+0101)
  0x00, 0x54, 0x01, 0x02, 0x01, // TĂ (U+0054 U+0102)
  0x00, 0x54, 0x01, 0x03, 0x01, // Tă (U+0054 U+0103)
  0x00, 0x54, 0x01, 0x04, 0x01, // TĄ (U+0054 U+0104)
  0x00, 0x54, 0x01, 0x05, 0x01, // Tą (U+0054 U+0105)
  0x00, 0x54, 0x01, 0x07, 0x01, // Tć (U+0054 U+0107)
  0x00, 0x54, 0x01, 0x09, 0x01, // Tĉ (U+0054 U+0109)
  0x00, 0x54, 0x01, 0x0B, 0x01, // Tċ (U+0054 U+010B)
  0x00, 0x54, 0x01, 0x0D, 0x01, // Tč (U+0054 U+010D)
  0x00, 0x54, 0x01, 0x0F, 0x01, // Tď (U+0054 U+010F)
  0x00, 0x54, 0x01, 0x11, 0x01, // Tđ (U+0054 U+0111)
  0x00, 0x54, 0x01, 0x13, 0x01, // Tē (U+0054 U+0113)
  0x00, 0x54, 0x01, 0x15, 0x01, // Tĕ (U+0054 U+0115)
  0x00, 0x54, 0x01, 0x17, 0x01, // Tė (U+0054 U+0117)
  0x00, 0x54, 0x01, 0x19, 0x01, // Tę (U+0054 U+0119)
  0x00, 0x54, 0x01, 0x1B, 0x01, // Tě (U+0054 U+011B)
  0x00, 0x54, 0x01, 0x1D, 0x01, // Tĝ (U+0054 U+011D)
  0x00, 0x54, 0x01, 0x1F, 0x01, // Tğ (U+0054 U+011F)
  0x00, 0x54, 0x01, 0x21, 0x01, // Tġ (U+0054 U+0121)
  0x00, 0x54, 0x01, 0x23, 0x01, // Tģ (U+0054 U+0123)
  0x00, 0x54, 0x01, 0x38, 0x01, // Tĸ (U+0054 U+0138)
  0x00, 0x54, 0x01, 0x44, 0x01, // Tń (U+0054 U+0144)
  0x00, 0x54, 0x01, 0x46, 0x01, // Tņ (U+0054 U+0146)
  0x00, 0x54, 0x01, 0x48, 0x01, // Tň (U+0054 U+0148)
  0x00, 0x54, 0x01, 0x4B, 0x01, // Tŋ (U+0054 U+014B)
  0x00, 0x54, 0x01, 0x4D, 0x01, // Tō (U+0054 U+014D)
  0x00, 0x54, 0x01, 0x4F, 0x01, // Tŏ (U+0054 U+014F)
  0x00, 0x54, 0x01, 0x51, 0x01, // Tő (U+0054 U+0151)
  0x00, 0x54, 0x01, 0x53, 0x01, // Tœ (U+0054 U+0153)
  0x00, 0x54, 0x01, 0x55, 0x01, // Tŕ (U+0054 U+0155)
  0x00, 0x54, 0x01, 0x57, 0x01, // Tŗ (U+0054 U+0157)
  0x00, 0x54, 0x01, 0x5B, 0x01, // Tś (U+0054 U+015B)
  0x00, 0x54, 0x01, 0x5D, 0x01, // Tŝ (U+0054 U+015D)
  0x00, 0x54, 0x01, 0x5F, 0x01, // Tş (U+0054 U+015F)
  0x00, 0x54, 0x01, 0x61, 0x01, // Tš (U+0054 U+0161)
  0x00, 0x54, 0x01, 0x69, 0x01, // Tũ (U+0054 U+0169)
  0x00, 0x54, 0x01, 0x6B, 0x01, // Tū (U+0054 U+016B)
  0x00, 0x54, 0x01, 0x6D, 0x01, // Tŭ (U+0054 U+016D)
  0x00, 0x54, 0x01, 0x6F, 0x01, // Tů (U+0054 U+016F)
  0x00, 0x54, 0x01, 0x71, 0x01, // Tű (U+0054 U+0171)
  0x00, 0x54, 0x01, 0x73, 0x01, // Tų (U+0054 U+0173)
  0x00, 0x54, 0x01, 0x75, 0x01, // Tŵ (U+0054 U+0175)
  0x00, 0x54, 0x01, 0x77, 0x01, // Tŷ (U+0054 U+0177)
  0x00, 0x54, 0x01, 0x7A, 0x01, // Tź (U+0054 U+017A)
  0x00, 0x54, 0x01, 0x7C, 0x01, // Tż (U+0054 U+017C)
  0x00, 0x54, 0x01, 0x7E, 0x01, // Tž (U+0054 U+017E)
  0x00, 0x54, 0x20, 0x13, 0x01, // T– (U+0054 U+2013)
  0x00, 0x54, 0x20, 0x14, 0x01, // T— (U+0054 U+2014)
  0x00, 0x54, 0x20, 0x1A, 0x02, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x02, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x02, // T… (U+0054 U+2026)
  0x00, 0x54, 0x20, 0x39, 0x01, // T‹ (U+0054 U+2039)
  0x00, 0x54, 0x20, 0x3A, 0x01, // T› (U+0054 U+203A)
  0x00, 0x55, 0x00, 0x2C, 0x01, // U, (U+0055 U+002C)
  0x00, 0x55, 0x00, 0x2E, 0x01, // U. (U+0055 U+002E)
  0x00, 0x55, 0x20, 0x1A, 0x01, // U‚ (U+0055 U+201A)
  0x00, 0x55, 0x20, 0x1E, 0x01, // U„ (U+0055 U+201E)
  0x00, 0x55, 0x20, 0x26, 0x01, // U… (U+0055 U+2026)
  0x00, 0x56, 0x00, 0x2C, 0x01, // V, (U+0056 U+002C)
  0x00, 0x56, 0x00, 0x2E, 0x01, // V. (U+0056 U+002E)
  0x00, 0x56, 0x00, 0x61, 0x01, // Va (U+0056 U+0061)
  0x00, 0x56, 0x00, 0x63, 0x01, // Vc (U+0056 U+0063)
  0x00, 0x56, 0x00, 0x64, 0x01, // Vd (U+0056 U+0064)
  0x00, 0x56, 0x00, 0x65, 0x01, // Ve (U+0056 U+0065)
  0x00, 0x56, 0x00, 0x6F, 0x01, // Vo (U+0056 U+006F)
  0x00, 0x56, 0x00, 0x71, 0x01, // Vq (U+0056 U+0071)
  0x00, 0x56, 0x00, 0xAB, 0x01, // V« (U+0056 U+00AB)
  0x00, 0x56, 0x00, 0xBB, 0x01, // V» (U+0056 U+00BB)
  0x00, 0x56, 0x00, 0xE0, 0x01, // Và (U+0056 U+00E0)
  0x00, 0x56, 0x00, 0xE1, 0x01, // Vá (U+0056 U+00E1)
  0x00, 0x56, 0x00, 0xE2, 0x01, // Vâ (U+0056 U+00E2)
  0x00, 0x56, 0x00, 0xE3, 0x01, // Vã (U+0056 U+00E3)
  0x00, 0x56, 0x00, 0xE4, 0x01, // Vä (U+0056 U+00E4)
  0x00, 0x56, 0x00, 0xE5, 0x01, // Vå (U+0056 U+00E5)
  0x00, 0x56, 0x00, 0xE6, 0x01, // Væ (U+0056 U+00E6)
  0x00, 0x56, 0x00, 0xE7, 0x01, // Vç (U+0056 U+00E7)
  0x00, 0x56, 0x00, 0xE8, 0x01, // Vè (U+0056 U+00E8)
  0x00, 0x56, 0x00, 0xE9, 0x01, // Vé (U+0056 U+00E9)
  0x00, 0x56, 0x00, 0xEA, 0x01, // Vê (U+0056 U+00EA)
  0x00, 0x56, 0x00, 0xEB, 0x01, // Vë (U+0056 U+00EB)
  0x00, 0x56, 0x00, 0xF2, 0x01, // Vò (U+0056 U+00F2)
  0x00, 0x56, 0x00, 0xF3, 0x01, // Vó (U+0056 U+00F3)
  0x00, 0x56, 0x00, 0xF4, 0x01, // Vô (U+0056 U+00F4)
  0x00, 0x56, 0x00, 0xF5, 0x01, // Võ (U+0056 U+00F5)
  0x00, 0x56, 0x00, 0xF6, 0x01, // Vö (U+0056 U+00F6)
  0x00, 0x56, 0x00, 0xF8, 0x01, // Vø (U+0056 U+00F8)
  0x00, 0x56, 0x01, 0x01, 0x01, // Vā (U+0056 U+0101)
  0x00, 0x56, 0x01, 0x03, 0x01, // Vă (U+0056 U+0103)
  0x00, 0x56, 0x01, 0x05, 0x01, // Vą (U+0056 U+0105)
  0x00, 0x56, 0x01, 0x07, 0x01, // Vć (U+0056 U+0107)
  0x00, 0x56, 0x01, 0x09, 0x01, // Vĉ (U+0056 U+0109)
  0x00, 0x56, 0x01, 0x0B, 0x01, // Vċ (U+0056 U+010B)
  0x00, 0x56, 0x01, 0x0D, 0x01, // Vč (U+0056 U+010D)
  0x00, 0x56, 0x01, 0x0F, 0x01, // Vď (U+0056 U+010F)
  0x00, 0x56, 0x01, 0x11, 0x01, // Vđ (U+0056 U+0111)
  0x00, 0x56, 0x01, 0x13, 0x01, // Vē (U+0056 U+0113)
  0x00, 0x56, 0x01, 0x15, 0x01, // Vĕ (U+0056 U+0115)
  0x00, 0x56, 0x01, 0x17, 0x01, // Vė (U+0056 U+0117)
  0x00, 0x56, 0x01, 0x19, 0x01, // Vę (U+0056 U+0119)
  0x00, 0x56, 0x01, 0x1B, 0x01, // Vě (U+0056 U+011B)
  0x00, 0x56, 0x01, 0x4D, 0x01, // Vō (U+0056 U+014D)
  0x00, 0x56, 0x01, 0x4F, 0x01, // Vŏ (U+0056 U+014F)
  0x00, 0x56, 0x01, 0x51, 0x01, // Vő (U+0056 U+0151)
  0x00, 0x56, 0x01, 0x53, 0x01, // Vœ (U+0056 U+0153)
  0x00, 0x56, 0x20, 0x1A, 0x01, // V‚ (U+0056 U+201A)
  0x00, 0x56, 0x20, 0x1E, 0x01, // V„ (U+0056 U+201E)
  0x00, 0x56, 0x20, 0x26, 0x01, // V… (U+0056 U+2026)
  0x00, 0x56, 0x20, 0x39, 0x01, // V‹ (U+0056 U+2039)
  0x00, 0x56, 0x20, 0x3A, 0x01, // V› (U+0056 U+203A)
  0x00, 0x57, 0x00, 0x2C, 0x01, // W, (U+0057 U+002C)
  0x00, 0x57, 0x00, 0x2E, 0x01, // W. (U+0057 U+002E)
  0x00, 0x57, 0x00, 0x61, 0x01, // Wa (U+0057 U+0061)
  0x00, 0x57, 0x00, 0x63, 0x01, // Wc (U+0057 U+0063)
  0x00, 0x57, 0x00, 0x64, 0x01, // Wd (U+0057 U+0064)
  0x00, 0x57, 0x00, 0x65, 0x01, // We (U+0057 U+0065)
  0x00, 0x57, 0x00, 0x6F, 0x01, // Wo (U+0057 U+006F)
  0x00, 0x57, 0x00, 0x71, 0x01, // Wq (U+0057 U+0071)
  0x00, 0x57, 0x00, 0xAB, 0x01, // W« (U+0057 U+00AB)
  0x00, 0x57, 0x00, 0xBB, 0x01, // W» (U+0057 U+00BB)
  0x00, 0x57, 0x00, 0xE0, 0x01, // Wà (U+0057 U+00E0)
  0x00, 0x57, 0x00, 0xE1, 0x01, // Wá (U+0057 U+00E1)
  0x00, 0x57, 0x00, 0xE2, 0x01, // Wâ (U+0057 U+00E2)
  0x00, 0x57, 0x00, 0xE3, 0x01, // Wã (U+0057 U+00E3)
  0x00, 0x57, 0x00, 0xE4, 0x01, // Wä (U+0057 U+00E4)
  0x00, 0x57, 0x00, 0xE5, 0x01, // Wå (U+0057 U+00E5)
  0x00, 0x57, 0x00, 0xE6, 0x01, // Wæ (U+0057 U+00E6)
  0x00, 0x57, 0x00, 0xE7, 0x01, // Wç (U+0057 U+00E7)
  0x00, 0x57, 0x00, 0xE8, 0x01, // Wè (U+0057 U+00E8)
  0x00, 0x57, 0x00, 0xE9, 0x01, // Wé (U+0057 U+00E9)
  0x00, 0x57, 0x00, 0xEA, 0x01, // Wê (U+0057 U+00EA)
  0x00, 0x57, 0x00, 0xEB, 0x01, // Wë (U+0057 U+00EB)
  0x00, 0x57, 0x00, 0xF2, 0x01, // Wò (U+0057 U+00F2)
  0x00, 0x57, 0x00, 0xF3, 0x01, // Wó (U+0057 U+00F3)
  0x00, 0x57, 0x00, 0xF4, 0x01, // Wô (U+0057 U+00F4)
  0x00, 0x57, 0x00, 0xF5, 0x01, // Wõ (U+0057 U+00F5)
  0x00, 0x57, 0x00, 0xF6, 0x01, // Wö (U+0057 U+00F6)
  0x00, 0x57, 0x00, 0xF8, 0x01, // Wø (U+0057 U+00F8)
  0x00, 0x57, 0x01, 0x01, 0x01, // Wā (U+0057 U+0101)
  0x00, 0x57, 0x01, 0x03, 0x01, // Wă (U+0057 U+0103)
  0x00, 0x57, 0x01, 0x05, 0x01, // Wą (U+0057 U+0105)
  0x00, 0x57, 0x01, 0x07, 0x01, // Wć (U+0057 U+0107)
  0x00, 0x57, 0x01, 0x09, 0x01, // Wĉ (U+0057 U+0109)
  0x00, 0x57, 0x01, 0x0B, 0x01, // Wċ (U+0057 U+010B)
  0x00, 0x57, 0x01, 0x0D, 0x01, // Wč (U+0057 U+010D)
  0x00, 0x57, 0x01, 0x0F, 0x01, // Wď (U+0057 U+010F)
  0x00, 0x57, 0x01, 0x11, 0x01, // Wđ (U+0057 U+0111)
  0x00, 0x57, 0x01, 0x13, 0x01, // Wē (U+0057 U+0113)
  0x00, 0x57, 0x01, 0x15, 0x01, // Wĕ (U+0057 U+0115)
  0x00, 0x57, 0x01, 0x17, 0x01, // Wė (U+0057 U+0117)
  0x00, 0x57, 0x01, 0x19, 0x01, // Wę (U+0057 U+0119)
  0x00, 0x57, 0x01, 0x1B, 0x01, // Wě (U+0057 U+011B)
  0x00, 0x57, 0x01, 0x4D, 0x01, // Wō (U+0057 U+014D)
  0x00, 0x57, 0x01, 0x4F, 0x01, // Wŏ (U+0057 U+014F)
  0x00, 0x57, 0x01, 0x51, 0x01, // Wő (U+0057 U+0151)
  0x00, 0x57, 0x01, 0x53, 0x01, // Wœ (U+0057 U+0153)
  0x00, 0x57, 0x20, 0x1A, 0x01, // W‚ (U+0057 U+201A)
  0x00, 0x57, 0x20, 0x1E, 0x01, // W„ (U+0057 U+201E)
  0x00, 0x57, 0x20, 0x26, 0x01, // W… (U+0057 U+2026)
  0x00, 0x57, 0x20, 0x39, 0x01, // W‹ (U+0057 U+2039)
  0x00, 0x57, 0x20, 0x3A, 0x01, // W› (U+0057 U+203A)
  0x00, 0x58, 0x00, 0xAB, 0x01, // X« (U+0058 U+00AB)
  0x00, 0x58, 0x20, 0x39, 0x01, // X‹ (U+0058 U+2039)
  0x00, 0x59, 0x00, 0x26, 0x01, // Y& (U+0059 U+0026)
  0x00, 0x59, 0x00, 0x2C, 0x02, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x02, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x00, 0x41, 0x01, // YA (U+0059 U+0041)
  0x00, 0x59, 0x00, 0x61, 0x01, // Ya (U+0059 U+0061)
  0x00, 0x59, 0x00, 0x63, 0x01, // Yc (U+0059 U+0063)
  0x00, 0x59, 0x00, 0x64, 0x01, // Yd (U+0059 U+0064)
  0x00, 0x59, 0x00, 0x65, 0x01, // Ye (U+0059 U+0065)
  0x00, 0x59, 0x00, 0x67, 0x01, // Yg (U+0059 U+0067)
  0x00, 0x59, 0x00, 0x6D, 0x01, // Ym (U+0059 U+006D)
  0x00, 0x59, 0x00, 0x6E, 0x01, // Yn (U+0059 U+006E)
  0x00, 0x59, 0x00, 0x6F, 0x01, // Yo (U+0059 U+006F)
  0x00, 0x59, 0x00, 0x70, 0x01, // Yp (U+0059 U+0070)
  0x00, 0x59, 0x00, 0x71, 0x01, // Yq (U+0059 U+0071)
  0x00, 0x59, 0x00, 0x72, 0x01, // Yr (U+0059 U+0072)
  0x00, 0x59, 0x00, 0x73, 0x01, // Ys (U+0059 U+0073)
  0x00, 0x59, 0x00, 0x75, 0x01, // Yu (U+0059 U+0075)
  0x00, 0x59, 0x00, 0x7A, 0x01, // Yz (U+0059 U+007A)
  0x00, 0x59, 0x00, 0xAB, 0x01, // Y« (U+0059 U+00AB)
  0x00, 0x59, 0x00, 0xBB, 0x01, // Y» (U+0059 U+00BB)
  0x00, 0x59, 0x00, 0xC0, 0x01, // YÀ (U+0059 U+00C0)
  0x00, 0x59, 0x00, 0xC1, 0x01, // YÁ (U+0059 U+00C1)
  0x00, 0x59, 0x00, 0xC2, 0x01, // YÂ (U+0059 U+00C2)
  0x00, 0x59, 0x00, 0xC3, 0x01, // YÃ (U+0059 U+00C3)
  0x00, 0x59, 0x00, 0xC4, 0x01, // YÄ (U+0059 U+00C4)
  0x00, 0x59, 0x00, 0xC5, 0x01, // YÅ (U+0059 U+00C5)
  0x00, 0x59, 0x00, 0xC6, 0x01, // YÆ (U+0059 U+00C6)
  0x00, 0x59, 0x00, 0xE0, 0x01, // Yà (U+0059 U+00E0)
  0x00, 0x59, 0x00, 0xE1, 0x01, // Yá (U+0059 U+00E1)
  0x00, 0x59, 0x00, 0xE2, 0x01, // Yâ (U+0059 U+00E2)
  0x00, 0x59, 0x00, 0xE3, 0x01, // Yã (U+0059 U+00E3)
  0x00, 0x59, 0x00, 0xE4, 0x01, // Yä (U+0059 U+00E4)
  0x00, 0x59, 0x00, 0xE5, 0x01, // Yå (U+0059 U+00E5)
  0x00, 0x59, 0x00, 0xE6, 0x01, // Yæ (U+0059 U+00E6)
  0x00, 0x59, 0x00, 0xE7, 0x01, // Yç (U+0059 U+00E7)
  0x00, 0x59, 0x00, 0xE8, 0x01, // Yè (U+0059 U+00E8)
  0x00, 0x59, 0x00, 0xE9, 0x01, // Yé (U+0059 U+00E9)
  0x00, 0x59, 0x00, 0xEA, 0x01, // Yê (U+0059 U+00EA)
  0x00, 0x59, 0x00, 0xEB, 0x01, // Yë (U+0059 U+00EB)
  0x00, 0x59, 0x00, 0xF1, 0x01, // Yñ (U+0059 U+00F1)
  0x00, 0x59, 0x00, 0xF2, 0x01, // Yò (U+0059 U+00F2)
  0x00, 0x59, 0x00, 0xF3, 0x01, // Yó (U+0059 U+00F3)
  0x00, 0x59, 0x00, 0xF4, 0x01, // Yô (U+0059 U+00F4)
  0x00, 0x59, 0x00, 0xF5, 0x01, // Yõ (U+0059 U+00F5)
  0x00, 0x59, 0x00, 0xF6, 0x01, // Yö (U+0059 U+00F6)
  0x00, 0x59, 0x00, 0xF8, 0x01, // Yø (U+0059 U+00F8)
  0x00, 0x59, 0x00, 0xF9, 0x01, // Yù (U+0059 U+00F9)
  0x00, 0x59, 0x00, 0xFA, 0x01, // Yú (U+0059 U+00FA)
  0x00, 0x59, 0x00, 0xFB, 0x01, // Yû (U+0059 U+00FB)
  0x00, 0x59, 0x00, 0xFC, 0x01, // Yü (U+0059 U+00FC)
  0x00, 0x59, 0x01, 0x00, 0x01, // YĀ (U+0059 U+0100)
  0x00, 0x59, 0x01, 0x01, 0x01, // Yā (U+0059 U+0101)
  0x00, 0x59, 0x01, 0x02, 0x01, // YĂ (U+0059 U+0102)
  0x00, 0x59, 0x01, 0x03, 0x01, // Yă (U+0059 U+0103)
  0x00, 0x59, 0x01, 0x04, 0x01, // YĄ (U+0059 U+0104)
  0x00, 0x59, 0x01, 0x05, 0x01, // Yą (U+0059 U+0105)
  0x00, 0x59, 0x01, 0x07, 0x01, // Yć (U+0059 U+0107)
  0x00, 0x59, 0x01, 0x09, 0x01, // Yĉ (U+0059 U+0109)
  0x00, 0x59, 0x01, 0x0B, 0x01, // Yċ (U+0059 U+010B)
  0x00, 0x59, 0x01, 0x0D, 0x01, // Yč (U+0059 U+010D)
  0x00, 0x59, 0x01, 0x0F, 0x01, // Yď (U+0059 U+010F)
  0x00, 0x59, 0x01, 0x11, 0x01, // Yđ (U+0059 U+0111)
  0x00, 0x59, 0x01, 0x13, 0x01, // Yē (U+0059 U+0113)
  0x00, 0x59, 0x01, 0x15, 0x01, // Yĕ (U+0059 U+0115)
  0x00, 0x59, 0x01, 0x17, 0x01, // Yė (U+0059 U+0117)
  0x00, 0x59, 0x01, 0x19, 0x01, // Yę (U+0059 U+0119)
  0x00, 0x59, 0x01, 0x1B, 0x01, // Yě (U+0059 U+011B)
  0x00, 0x59, 0x01, 0x1D, 0x01, // Yĝ (U+0059 U+011D)
  0x00, 0x59, 0x01, 0x1F, 0x01, // Yğ (U+0059 U+011F)
  0x00, 0x59, 0x01, 0x21, 0x01, // Yġ (U+0059 U+0121)
  0x00, 0x59, 0x01, 0x23, 0x01, // Yģ (U+0059 U+0123)
  0x00, 0x59, 0x01, 0x38, 0x01, // Yĸ (U+0059 U+0138)
  0x00, 0x59, 0x01, 0x44, 0x01, // Yń (U+0059 U+0144)
  0x00, 0x59, 0x01, 0x46, 0x01, // Yņ (U+0059 U+0146)
  0x00, 0x59, 0x01, 0x48, 0x01, // Yň (U+0059 U+0148)
  0x00, 0x59, 0x01, 0x4B, 0x01, // Yŋ (U+0059 U+014B)
  0x00, 0x59, 0x01, 0x4D, 0x01, // Yō (U+0059 U+014D)
  0x00, 0x59, 0x01, 0x4F, 0x01, // Yŏ (U+0059 U+014F)
  0x00, 0x59, 0x01, 0x51, 0x01, // Yő (U+0059 U+0151)
  0x00, 0x59, 0x01, 0x53, 0x01, // Yœ (U+0059 U+0153)
  0x00, 0x59, 0x01, 0x55, 0x01, // Yŕ (U+0059 U+0155)
  0x00, 0x59, 0x01, 0x57, 0x01, // Yŗ (U+0059 U+0157)
  0x00, 0x59, 0x01, 0x5B, 0x01, // Yś (U+0059 U+015B)
  0x00, 0x59, 0x01, 0x5D, 0x01, // Yŝ (U+0059 U+015D)
  0x00, 0x59, 0x01, 0x5F, 0x01, // Yş (U+0059 U+015F)
  0x00, 0x59, 0x01, 0x61, 0x01, // Yš (U+0059 U+0161)
  0x00, 0x59, 0x01, 0x69, 0x01, // Yũ (U+0059 U+0169)
  0x00, 0x59, 0x01, 0x6B, 0x01, // Yū (U+0059 U+016B)
  0x00, 0x59, 0x01, 0x6D, 0x01, // Yŭ (U+0059 U+016D)
  0x00, 0x59, 0x01, 0x6F, 0x01, // Yů (U+0059 U+016F)
  0x00, 0x59, 0x01, 0x71, 0x01, // Yű (U+0059 U+0171)
  0x00, 0x59, 0x01, 0x73, 0x01, // Yų (U+0059 U+0173)
  0x00, 0x59, 0x01, 0x7A, 0x01, // Yź (U+0059 U+017A)
  0x00, 0x59, 0x01, 0x7C, 0x01, // Yż (U+0059 U+017C)
  0x00, 0x59, 0x01, 0x7E, 0x01, // Yž (U+0059 U+017E)
  0x00, 0x59, 0x20, 0x1A, 0x02, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x02, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x02, // Y… (U+0059 U+2026)
  0x00, 0x59, 0x20, 0x39, 0x01, // Y‹ (U+0059 U+2039)
  0x00, 0x59, 0x20, 0x3A, 0x01, // Y› (U+0059 U+203A)
  0x00, 0x5A, 0x00, 0x26, 0x01, // Z& (U+005A U+0026)
  0x00, 0x76, 0x00, 0x2C, 0x01, // v, (U+0076 U+002C)
  0x00, 0x76, 0x00, 0x2E, 0x01, // v. (U+0076 U+002E)
  0x00, 0x76, 0x20, 0x1A, 0x01, // v‚ (U+0076 U+201A)
  0x00, 0x76, 0x20, 0x1E, 0x01, // v„ (U+0076 U+201E)
  0x00, 0x76, 0x20, 0x26, 0x01, // v… (U+0076 U+2026)
  0x00, 0x77, 0x00, 0x2C, 0x01, // w, (U+0077 U+002C)
  0x00, 0x77, 0x00, 0x2E, 0x01, // w. (U+0077 U+002E)
  0x00, 0x77, 0x20, 0x1A, 0x01, // w‚ (U+0077 U+201A)
  0x00, 0x77, 0x20, 0x1E, 0x01, // w„ (U+0077 U+201E)
  0x00, 0x77, 0x20, 0x26, 0x01, // w… (U+0077 U+2026)
  0x00, 0x79, 0x00, 0x2C, 0x01, // y, (U+0079 U+002C)
  0x00, 0x79, 0x00, 0x2E, 0x01, // y. (U+0079 U+002E)
  0x00, 0x79, 0x20, 0x1A, 0x01, // y‚ (U+0079 U+201A)
  0x00, 0x79, 0x20, 0x1E, 0x01, // y„ (U+0079 U+201E)
  0x00, 0x79, 0x20, 0x26, 0x01, // y… (U+0079 U+2026)
  0x00, 0xA1, 0x00, 0x54, 0x01, // ¡T (U+00A1 U+0054)
  0x00, 0xA1, 0x01, 0x62, 0x01, // ¡Ţ (U+00A1 U+0162)
  0x00, 0xA1, 0x01, 0x64, 0x01, // ¡Ť (U+00A1 U+0164)
  0x00, 0xA1, 0x01, 0x66, 0x01, // ¡Ŧ (U+00A1 U+0166)
  0x00, 0xAB, 0x00, 0x54, 0x01, // «T (U+00AB U+0054)
  0x00, 0xAB, 0x00, 0x56, 0x01, // «V (U+00AB U+0056)
  0x00, 0xAB, 0x00, 0x57, 0x01, // «W (U+00AB U+0057)
  0x00, 0xAB, 0x00, 0x59, 0x01, // «Y (U+00AB U+0059)
  0x00, 0xAB, 0x00, 0xDD, 0x01, // «Ý (U+00AB U+00DD)
  0x00, 0xAB, 0x01, 0x62, 0x01, // «Ţ (U+00AB U+0162)
  0x00, 0xAB, 0x01, 0x64, 0x01, // «Ť (U+00AB U+0164)
  0x00, 0xAB, 0x01, 0x66, 0x01, // «Ŧ (U+00AB U+0166)
  0x00, 0xAB, 0x01, 0x74, 0x01, // «Ŵ (U+00AB U+0174)
  0x00, 0xAB, 0x01, 0x76, 0x01, // «Ŷ (U+00AB U+0176)
  0x00, 0xAB, 0x01, 0x78, 0x01, // «Ÿ (U+00AB U+0178)
  0x00, 0xBB, 0x00, 0x54, 0x01, // »T (U+00BB U+0054)
  0x00, 0xBB, 0x00, 0x56, 0x01, // »V (U+00BB U+0056)
  0x00, 0xBB, 0x00, 0x57, 0x01, // »W (U+00BB U+0057)
  0x00, 0xBB, 0x00, 0x59, 0x01, // »Y (U+00BB U+0059)
  0x00, 0xBB, 0x00, 0xDD, 0x01, // »Ý (U+00BB U+00DD)
  0x00, 0xBB, 0x01, 0x62, 0x01, // »Ţ (U+00BB U+0162)
  0x00, 0xBB, 0x01, 0x64, 0x01, // »Ť (U+00BB U+0164)
  0x00, 0xBB, 0x01, 0x66, 0x01, // »Ŧ (U+00BB U+0166)
  0x00, 0xBB, 0x01, 0x74, 0x01, // »Ŵ (U+00BB U+0174)
  0x00, 0xBB, 0x01, 0x76, 0x01, // »Ŷ (U+00BB U+0176)
  0x00, 0xBB, 0x01, 0x78, 0x01, // »Ÿ (U+00BB U+0178)
  0x00, 0xBF, 0x00, 0x54, 0x01, // ¿T (U+00BF U+0054)
  0x00, 0xBF, 0x01, 0x62, 0x01, // ¿Ţ (U+00BF U+0162)
  0x00, 0xBF, 0x01, 0x64, 0x01, // ¿Ť (U+00BF U+0164)
  0x00, 0xBF, 0x01, 0x66, 0x01, // ¿Ŧ (U+00BF U+0166)
  0x00, 0xC0, 0x00, 0x22, 0x02, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x02, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x00, 0x54, 0x01, // ÀT (U+00C0 U+0054)
  0x00, 0xC0, 0x00, 0x59, 0x01, // ÀY (U+00C0 U+0059)
  0x00, 0xC0, 0x00, 0xDD, 0x01, // ÀÝ (U+00C0 U+00DD)
  0x00, 0xC0, 0x01, 0x62, 0x01, // ÀŢ (U+00C0 U+0162)
  0x00, 0xC0, 0x01, 0x64, 0x01, // ÀŤ (U+00C0 U+0164)
  0x00, 0xC0, 0x01, 0x66, 0x01, // ÀŦ (U+00C0 U+0166)
  0x00, 0xC0, 0x01, 0x76, 0x01, // ÀŶ (U+00C0 U+0176)
  0x00, 0xC0, 0x01, 0x78, 0x01, // ÀŸ (U+00C0 U+0178)
  0x00, 0xC0, 0x20, 0x19, 0x02, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1D, 0x02, // À” (U+00C0 U+201D)
  0x00, 0xC1, 0x00, 0x22, 0x02, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x02, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x00, 0x54, 0x01, // ÁT (U+00C1 U+0054)
  0x00, 0xC1, 0x00, 0x59, 0x01, // ÁY (U+00C1 U+0059)
  0x00, 0xC1, 0x00, 0xDD, 0x01, // ÁÝ (U+00C1 U+00DD)
  0x00, 0xC1, 0x01, 0x62, 0x01, // ÁŢ (U+00C1 U+0162)
  0x00, 0xC1, 0x01, 0x64, 0x01, // ÁŤ (U+00C1 U+0164)
  0x00, 0xC1, 0x01, 0x66, 0x01, // ÁŦ (U+00C1 U+0166)
  0x00, 0xC1, 0x01, 0x76, 0x01, // ÁŶ (U+00C1 U+0176)
  0x00, 0xC1, 0x01, 0x78, 0x01, // ÁŸ (U+00C1 U+0178)
  0x00, 0xC1, 0x20, 0x19, 0x02, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1D, 0x02, // Á” (U+00C1 U+201D)
  0x00, 0xC2, 0x00, 0x22, 0x02, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x02, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x00, 0x54, 0x01, // ÂT (U+00C2 U+0054)
  0x00, 0xC2, 0x00, 0x59, 0x01, // ÂY (U+00C2 U+0059)
  0x00, 0xC2, 0x00, 0xDD, 0x01, // ÂÝ (U+00C2 U+00DD)
  0x00, 0xC2, 0x01, 0x62, 0x01, // ÂŢ (U+00C2 U+0162)
  0x00, 0xC2, 0x01, 0x64, 0x01, // ÂŤ (U+00C2 U+0164)
  0x00, 0xC2, 0x01, 0x66, 0x01, // ÂŦ (U+00C2 U+0166)
  0x00, 0xC2, 0x01, 0x76, 0x01, // ÂŶ (U+00C2 U+0176)
  0x00, 0xC2, 0x01, 0x78, 0x01, // ÂŸ (U+00C2 U+0178)
  0x00, 0xC2, 0x20, 0x19, 0x02, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1D, 0x02, // Â” (U+00C2 U+201D)
  0x00, 0xC3, 0x00, 0x22, 0x02, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x02, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x00, 0x54, 0x01, // ÃT (U+00C3 U+0054)
  0x00, 0xC3, 0x00, 0x59, 0x01, // ÃY (U+00C3 U+0059)
  0x00, 0xC3, 0x00, 0xDD, 0x01, // ÃÝ (U+00C3 U+00DD)
  0x00, 0xC3, 0x01, 0x62, 0x01, // ÃŢ (U+00C3 U+0162)
  0x00, 0xC3, 0x01, 0x64, 0x01, // ÃŤ (U+00C3 U+0164)
  0x00, 0xC3, 0x01, 0x66, 0x01, // ÃŦ (U+00C3 U+0166)
  0x00, 0xC3, 0x01, 0x76, 0x01, // ÃŶ (U+00C3 U+0176)
  0x00, 0xC3, 0x01, 0x78, 0x01, // ÃŸ (U+00C3 U+0178)
  0x00, 0xC3, 0x20, 0x19, 0x02, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1D, 0x02, // Ã” (U+00C3 U+201D)
  0x00, 0xC4, 0x00, 0x22, 0x02, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x02, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x00, 0x54, 0x01, // ÄT (U+00C4 U+0054)
  0x00, 0xC4, 0x00, 0x59, 0x01, // ÄY (U+00C4 U+0059)
  0x00, 0xC4, 0x00, 0xDD, 0x01, // ÄÝ (U+00C4 U+00DD)
  0x00, 0xC4, 0x01, 0x62, 0x01, // ÄŢ (U+00C4 U+0162)
  0x00, 0xC4, 0x01, 0x64, 0x01, // ÄŤ (U+00C4 U+0164)
  0x00, 0xC4, 0x01, 0x66, 0x01, // ÄŦ (U+00C4 U+0166)
  0x00, 0xC4, 0x01, 0x76, 0x01, // ÄŶ (U+00C4 U+0176)
  0x00, 0xC4, 0x01, 0x78, 0x01, // ÄŸ (U+00C4 U+0178)
  0x00, 0xC4, 0x20, 0x19, 0x02, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1D, 0x02, // Ä” (U+00C4 U+201D)
  0x00, 0xC5, 0x00, 0x22, 0x02, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x02, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x00, 0x54, 0x01, // ÅT (U+00C5 U+0054)
  0x00, 0xC5, 0x00, 0x59, 0x01, // ÅY (U+00C5 U+0059)
  0x00, 0xC5, 0x00, 0xDD, 0x01, // ÅÝ (U+00C5 U+00DD)
  0x00, 0xC5, 0x01, 0x62, 0x01, // ÅŢ (U+00C5 U+0162)
  0x00, 0xC5, 0x01, 0x64, 0x01, // ÅŤ (U+00C5 U+0164)
  0x00, 0xC5, 0x01, 0x66, 0x01, // ÅŦ (U+00C5 U+0166)
  0x00, 0xC5, 0x01, 0x76, 0x01, // ÅŶ (U+00C5 U+0176)
  0x00, 0xC5, 0x01, 0x78, 0x01, // ÅŸ (U+00C5 U+0178)
  0x00, 0xC5, 0x20, 0x19, 0x02, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1D, 0x02, // Å” (U+00C5 U+201D)
  0x00, 0xC7, 0x00, 0x43, 0x01, // ÇC (U+00C7 U+0043)
  0x00, 0xC7, 0x00, 0x47, 0x01, // ÇG (U+00C7 U+0047)
  0x00, 0xC7, 0x00, 0x4F, 0x01, // ÇO (U+00C7 U+004F)
  0x00, 0xC7, 0x00, 0x51, 0x01, // ÇQ (U+00C7 U+0051)
  0x00, 0xC7, 0x00, 0xAB, 0x01, // Ç« (U+00C7 U+00AB)
  0x00, 0xC7, 0x00, 0xC7, 0x01, // ÇÇ (U+00C7 U+00C7)
  0x00, 0xC7, 0x00, 0xD2, 0x01, // ÇÒ (U+00C7 U+00D2)
  0x00, 0xC7, 0x00, 0xD3, 0x01, // ÇÓ (U+00C7 U+00D3)
  0x00, 0xC7, 0x00, 0xD4, 0x01, // ÇÔ (U+00C7 U+00D4)
  0x00, 0xC7, 0x00, 0xD5, 0x01, // ÇÕ (U+00C7 U+00D5)
  0x00, 0xC7, 0x00, 0xD6, 0x01, // ÇÖ (U+00C7 U+00D6)
  0x00, 0xC7, 0x00, 0xD8, 0x01, // ÇØ (U+00C7 U+00D8)
  0x00, 0xC7, 0x01, 0x06, 0x01, // ÇĆ (U+00C7 U+0106)
  0x00, 0xC7, 0x01, 0x08, 0x01, // ÇĈ (U+00C7 U+0108)
  0x00, 0xC7, 0x01, 0x0A, 0x01, // ÇĊ (U+00C7 U+010A)
  0x00, 0xC7, 0x01, 0x0C, 0x01, // ÇČ (U+00C7 U+010C)
  0x00, 0xC7, 0x01, 0x1C, 0x01, // ÇĜ (U+00C7 U+011C)
  0x00, 0xC7, 0x01, 0x1E, 0x01, // ÇĞ (U+00C7 U+011E)
  0x00, 0xC7, 0x01, 0x20, 0x01, // ÇĠ (U+00C7 U+0120)
  0x00, 0xC7, 0x01, 0x22, 0x01, // ÇĢ (U+00C7 U+0122)
  0x00, 0xC7, 0x01, 0x4C, 0x01, // ÇŌ (U+00C7 U+014C)
  0x00, 0xC7, 0x01, 0x4E, 0x01, // ÇŎ (U+00C7 U+014E)
  0x00, 0xC7, 0x01, 0x50, 0x01, // ÇŐ (U+00C7 U+0150)
  0x00, 0xC7, 0x01, 0x52, 0x01, // ÇŒ (U+00C7 U+0152)
  0x00, 0xC7, 0x20, 0x39, 0x01, // Ç‹ (U+00C7 U+2039)
  0x00, 0xD0, 0x00, 0x2C, 0x01, // Ð, (U+00D0 U+002C)
  0x00, 0xD0, 0x00, 0x2E, 0x01, // Ð. (U+00D0 U+002E)
  0x00, 0xD0, 0x00, 0x54, 0x01, // ÐT (U+00D0 U+0054)
  0x00, 0xD0, 0x01, 0x62, 0x01, // ÐŢ (U+00D0 U+0162)
  0x00, 0xD0, 0x01, 0x64, 0x01, // ÐŤ (U+00D0 U+0164)
  0x00, 0xD0, 0x01, 0x66, 0x01, // ÐŦ (U+00D0 U+0166)
  0x00, 0xD0, 0x20, 0x1A, 0x01, // Ð‚ (U+00D0 U+201A)
  0x00, 0xD0, 0x20, 0x1E, 0x01, // Ð„ (U+00D0 U+201E)
  0x00, 0xD0, 0x20, 0x26, 0x01, // Ð… (U+00D0 U+2026)
  0x00, 0xD2, 0x00, 0x2C, 0x01, // Ò, (U+00D2 U+002C)
  0x00, 0xD2, 0x00, 0x2E, 0x01, // Ò. (U+00D2 U+002E)
  0x00, 0xD2, 0x00, 0x54, 0x01, // ÒT (U+00D2 U+0054)
  0x00, 0xD2, 0x01, 0x62, 0x01, // ÒŢ (U+00D2 U+0162)
  0x00, 0xD2, 0x01, 0x64, 0x01, // ÒŤ (U+00D2 U+0164)
  0x00, 0xD2, 0x01, 0x66, 0x01, // ÒŦ (U+00D2 U+0166)
  0x00, 0xD2, 0x20, 0x1A, 0x01, // Ò‚ (U+00D2 U+201A)
  0x00, 0xD2, 0x20, 0x1E, 0x01, // Ò„ (U+00D2 U+201E)
  0x00, 0xD2, 0x20, 0x26, 0x01, // Ò… (U+00D2 U+2026)
  0x00, 0xD3, 0x00, 0x2C, 0x01, // Ó, (U+00D3 U+002C)
  0x00, 0xD3, 0x00, 0x2E, 0x01, // Ó. (U+00D3 U+002E)
  0x00, 0xD3, 0x00, 0x54, 0x01, // ÓT (U+00D3 U+0054)
  0x00, 0xD3, 0x01, 0x62, 0x01, // ÓŢ (U+00D3 U+0162)
  0x00, 0xD3, 0x01, 0x64, 0x01, // ÓŤ (U+00D3 U+0164)
  0x00, 0xD3, 0x01, 0x66, 0x01, // ÓŦ (U+00D3 U+0166)
  0x00, 0xD3, 0x20, 0x1A, 0x01, // Ó‚ (U+00D3 U+201A)
  0x00, 0xD3, 0x20, 0x1E, 0x01, // Ó„ (U+00D3 U+201E)
  0x00, 0xD3, 0x20, 0x26, 0x01, // Ó… (U+00D3 U+2026)
  0x00, 0xD4, 0x00, 0x2C, 0x01, // Ô, (U+00D4 U+002C)
  0x00, 0xD4, 0x00, 0x2E, 0x01, // Ô. (U+00D4 U+002E)
  0x00, 0xD4, 0x00, 0x54, 0x01, // ÔT (U+00D4 U+0054)
  0x00, 0xD4, 0x01, 0x62, 0x01, // ÔŢ (U+00D4 U+0162)
  0x00, 0xD4, 0x01, 0x64, 0x01, // ÔŤ (U+00D4 U+0164)
  0x00, 0xD4, 0x01, 0x66, 0x01, // ÔŦ (U+00D4 U+0166)
  0x00, 0xD4, 0x20, 0x1A, 0x01, // Ô‚ (U+00D4 U+201A)
  0x00, 0xD4, 0x20, 0x1E, 0x01, // Ô„ (U+00D4 U+201E)
  0x00, 0xD4, 0x20, 0x26, 0x01, // Ô… (U+00D4 U+2026)
  0x00, 0xD5, 0x00, 0x2C, 0x01, // Õ, (U+00D5 U+002C)
  0x00, 0xD5, 0x00, 0x2E, 0x01, // Õ. (U+00D5 U+002E)
  0x00, 0xD5, 0x00, 0x54, 0x01, // ÕT (U+00D5 U+0054)
  0x00, 0xD5, 0x01, 0x62, 0x01, // ÕŢ (U+00D5 U+0162)
  0x00, 0xD5, 0x01, 0x64, 0x01, // ÕŤ (U+00D5 U+0164)
  0x00, 0xD5, 0x01, 0x66, 0x01, // ÕŦ (U+00D5 U+0166)
  0x00, 0xD5, 0x20, 0x1A, 0x01, // Õ‚ (U+00D5 U+201A)
  0x00, 0xD5, 0x20, 0x1E, 0x01, // Õ„ (U+00D5 U+201E)
  0x00, 0xD5, 0x20, 0x26, 0x01, // Õ… (U+00D5 U+2026)
  0x00, 0xD6, 0x00, 0x2C, 0x01, // Ö, (U+00D6 U+002C)
  0x00, 0xD6, 0x00, 0x2E, 0x01, // Ö. (U+00D6 U+002E)
  0x00, 0xD6, 0x00, 0x54, 0x01, // ÖT (U+00D6 U+0054)
  0x00, 0xD6, 0x01, 0x62, 0x01, // ÖŢ (U+00D6 U+0162)
  0x00, 0xD6, 0x01, 0x64, 0x01, // ÖŤ (U+00D6 U+0164)
  0x00, 0xD6, 0x01, 0x66, 0x01, // ÖŦ (U+00D6 U+0166)
  0x00, 0xD6, 0x20, 0x1A, 0x01, // Ö‚ (U+00D6 U+201A)
  0x00, 0xD6, 0x20, 0x1E, 0x01, // Ö„ (U+00D6 U+201E)
  0x00, 0xD6, 0x20, 0x26, 0x01, // Ö… (U+00D6 U+2026)
  0x00, 0xD8, 0x00, 0x2C, 0x01, // Ø, (U+00D8 U+002C)
  0x00, 0xD8, 0x00, 0x2E, 0x01, // Ø. (U+00D8 U+002E)
  0x00, 0xD8, 0x00, 0x54, 0x01, // ØT (U+00D8 U+0054)
  0x00, 0xD8, 0x01, 0x62, 0x01, // ØŢ (U+00D8 U+0162)
  0x00, 0xD8, 0x01, 0x64, 0x01, // ØŤ (U+00D8 U+0164)
  0x00, 0xD8, 0x01, 0x66, 0x01, // ØŦ (U+00D8 U+0166)
  0x00, 0xD8, 0x20, 0x1A, 0x01, // Ø‚ (U+00D8 U+201A)
  0x00, 0xD8, 0x20, 0x1E, 0x01, // Ø„ (U+00D8 U+201E)
  0x00, 0xD8, 0x20, 0x26, 0x01, // Ø… (U+00D8 U+2026)
  0x00, 0xD9, 0x00, 0x2C, 0x01, // Ù, (U+00D9 U+002C)
  0x00, 0xD9, 0x00, 0x2E, 0x01, // Ù. (U+00D9 U+002E)
  0x00, 0xD9, 0x20, 0x1A, 0x01, // Ù‚ (U+00D9 U+201A)
  0x00, 0xD9, 0x20, 0x1E, 0x01, // Ù„ (U+00D9 U+201E)
  0x00, 0xD9, 0x20, 0x26, 0x01, // Ù… (U+00D9 U+2026)
  0x00, 0xDA, 0x00, 0x2C, 0x01, // Ú, (U+00DA U+002C)
  0x00, 0xDA, 0x00, 0x2E, 0x01, // Ú. (U+00DA U+002E)
  0x00, 0xDA, 0x20, 0x1A, 0x01, // Ú‚ (U+00DA U+201A)
  0x00, 0xDA, 0x20, 0x1E, 0x01, // Ú„ (U+00DA U+201E)
  0x00, 0xDA, 0x20, 0x26, 0x01, // Ú… (U+00DA U+2026)
  0x00, 0xDB, 0x00, 0x2C, 0x01, // Û, (U+00DB U+002C)
  0x00, 0xDB, 0x00, 0x2E, 0x01, // Û. (U+00DB U+002E)
  0x00, 0xDB, 0x20, 0x1A, 0x01, // Û‚ (U+00DB U+201A)
  0x00, 0xDB, 0x20, 0x1E, 0x01, // Û„ (U+00DB U+201E)
  0x00, 0xDB, 0x20, 0x26, 0x01, // Û… (U+00DB U+2026)
  0x00, 0xDC, 0x00, 0x2C, 0x01, // Ü, (U+00DC U+002C)
  0x00, 0xDC, 0x00, 0x2E, 0x01, // Ü. (U+00DC U+002E)
  0x00, 0xDC, 0x20, 0x1A, 0x01, // Ü‚ (U+00DC U+201A)
  0x00, 0xDC, 0x20, 0x1E, 0x01, // Ü„ (U+00DC U+201E)
  0x00, 0xDC, 0x20, 0x26, 0x01, // Ü… (U+00DC U+2026)
  0x00, 0xDD, 0x00, 0x26, 0x01, // Ý& (U+00DD U+0026)
  0x00, 0xDD, 0x00, 0x2C, 0x02, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x02, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x00, 0x41, 0x01, // ÝA (U+00DD U+0041)
  0x00, 0xDD, 0x00, 0x61, 0x01, // Ýa (U+00DD U+0061)
  0x00, 0xDD, 0x00, 0x63, 0x01, // Ýc (U+00DD U+0063)
  0x00, 0xDD, 0x00, 0x64, 0x01, // Ýd (U+00DD U+0064)
  0x00, 0xDD, 0x00, 0x65, 0x01, // Ýe (U+00DD U+0065)
  0x00, 0xDD, 0x00, 0x67, 0x01, // Ýg (U+00DD U+0067)
  0x00, 0xDD, 0x00, 0x6D, 0x01, // Ým (U+00DD U+006D)
  0x00, 0xDD, 0x00, 0x6E, 0x01, // Ýn (U+00DD U+006E)
  0x00, 0xDD, 0x00, 0x6F, 0x01, // Ýo (U+00DD U+006F)
  0x00, 0xDD, 0x00, 0x70, 0x01, // Ýp (U+00DD U+0070)
  0x00, 0xDD, 0x00, 0x71, 0x01, // Ýq (U+00DD U+0071)
  0x00, 0xDD, 0x00, 0x72, 0x01, // Ýr (U+00DD U+0072)
  0x00, 0xDD, 0x00, 0x73, 0x01, // Ýs (U+00DD U+0073)
  0x00, 0xDD, 0x00, 0x75, 0x01, // Ýu (U+00DD U+0075)
  0x00, 0xDD, 0x00, 0x7A, 0x01, // Ýz (U+00DD U+007A)
  0x00, 0xDD, 0x00, 0xAB, 0x01, // Ý« (U+00DD U+00AB)
  0x00, 0xDD, 0x00, 0xBB, 0x01, // Ý» (U+00DD U+00BB)
  0x00, 0xDD, 0x00, 0xC0, 0x01, // ÝÀ (U+00DD U+00C0)
  0x00, 0xDD, 0x00, 0xC1, 0x01, // ÝÁ (U+00DD U+00C1)
  0x00, 0xDD, 0x00, 0xC2, 0x01, // ÝÂ (U+00DD U+00C2)
  0x00, 0xDD, 0x00, 0xC3, 0x01, // ÝÃ (U+00DD U+00C3)
  0x00, 0xDD, 0x00, 0xC4, 0x01, // ÝÄ (U+00DD U+00C4)
  0x00, 0xDD, 0x00, 0xC5, 0x01, // ÝÅ (U+00DD U+00C5)
  0x00, 0xDD, 0x00, 0xC6, 0x01, // ÝÆ (U+00DD U+00C6)
  0x00, 0xDD, 0x00, 0xE0, 0x01, // Ýà (U+00DD U+00E0)
  0x00, 0xDD, 0x00, 0xE1, 0x01, // Ýá (U+00DD U+00E1)
  0x00, 0xDD, 0x00, 0xE2, 0x01, // Ýâ (U+00DD U+00E2)
  0x00, 0xDD, 0x00, 0xE3, 0x01, // Ýã (U+00DD U+00E3)
  0x00, 0xDD, 0x00, 0xE4, 0x01, // Ýä (U+00DD U+00E4)
  0x00, 0xDD, 0x00, 0xE5, 0x01, // Ýå (U+00DD U+00E5)
  0x00, 0xDD, 0x00, 0xE6, 0x01, // Ýæ (U+00DD U+00E6)
  0x00, 0xDD, 0x00, 0xE7, 0x01, // Ýç (U+00DD U+00E7)
  0x00, 0xDD, 0x00, 0xE8, 0x01, // Ýè (U+00DD U+00E8)
  0x00, 0xDD, 0x00, 0xE9, 0x01, // Ýé (U+00DD U+00E9)
  0x00, 0xDD, 0x00, 0xEA, 0x01, // Ýê (U+00DD U+00EA)
  0x00, 0xDD, 0x00, 0xEB, 0x01, // Ýë (U+00DD U+00EB)
  0x00, 0xDD, 0x00, 0xF1, 0x01, // Ýñ (U+00DD U+00F1)
  0x00, 0xDD, 0x00, 0xF2, 0x01, // Ýò (U+00DD U+00F2)
  0x00, 0xDD, 0x00, 0xF3, 0x01, // Ýó (U+00DD U+00F3)
  0x00, 0xDD, 0x00, 0xF4, 0x01, // Ýô (U+00DD U+00F4)
  0x00, 0xDD, 0x00, 0xF5, 0x01, // Ýõ (U+00DD U+00F5)
  0x00, 0xDD, 0x00, 0xF6, 0x01, // Ýö (U+00DD U+00F6)
  0x00, 0xDD, 0x00, 0xF8, 0x01, // Ýø (U+00DD U+00F8)
  0x00, 0xDD, 0x00, 0xF9, 0x01, // Ýù (U+00DD U+00F9)
  0x00, 0xDD, 0x00, 0xFA, 0x01, // Ýú (U+00DD U+00FA)
  0x00, 0xDD, 0x00, 0xFB, 0x01, // Ýû (U+00DD U+00FB)
  0x00, 0xDD, 0x00, 0xFC, 0x01, // Ýü (U+00DD U+00FC)
  0x00, 0xDD, 0x01, 0x00, 0x01, // ÝĀ (U+00DD U+0100)
  0x00, 0xDD, 0x01, 0x01, 0x01, // Ýā (U+00DD U+0101)
  0x00, 0xDD, 0x01, 0x02, 0x01, // ÝĂ (U+00DD U+0102)
  0x00, 0xDD, 0x01, 0x03, 0x01, // Ýă (U+00DD U+0103)
  0x00, 0xDD, 0x01, 0x04, 0x01, // ÝĄ (U+00DD U+0104)
  0x00, 0xDD, 0x01, 0x05, 0x01, // Ýą (U+00DD U+0105)
  0x00, 0xDD, 0x01, 0x07, 0x01, // Ýć (U+00DD U+0107)
  0x00, 0xDD, 0x01, 0x09, 0x01, // Ýĉ (U+00DD U+0109)
  0x00, 0xDD, 0x01, 0x0B, 0x01, // Ýċ (U+00DD U+010B)
  0x00, 0xDD, 0x01, 0x0D, 0x01, // Ýč (U+00DD U+010D)
  0x00, 0xDD, 0x01, 0x0F, 0x01, // Ýď (U+00DD U+010F)
  0x00, 0xDD, 0x01, 0x11, 0x01, // Ýđ (U+00DD U+0111)
  0x00, 0xDD, 0x01, 0x13, 0x01, // Ýē (U+00DD U+0113)
  0x00, 0xDD, 0x01, 0x15, 0x01, // Ýĕ (U+00DD U+0115)
  0x00, 0xDD, 0x01, 0x17, 0x01, // Ýė (U+00DD U+0117)
  0x00, 0xDD, 0x01, 0x19, 0x01, // Ýę (U+00DD U+0119)
  0x00, 0xDD, 0x01, 0x1B, 0x01, // Ýě (U+00DD U+011B)
  0x00, 0xDD, 0x01, 0x1D, 0x01, // Ýĝ (U+00DD U+011D)
  0x00, 0xDD, 0x01, 0x1F, 0x01, // Ýğ (U+00DD U+011F)
  0x00, 0xDD, 0x01, 0x21, 0x01, // Ýġ (U+00DD U+0121)
  0x00, 0xDD, 0x01, 0x23, 0x01, // Ýģ (U+00DD U+0123)
  0x00, 0xDD, 0x01, 0x38, 0x01, // Ýĸ (U+00DD U+0138)
  0x00, 0xDD, 0x01, 0x44, 0x01, // Ýń (U+00DD U+0144)
  0x00, 0xDD, 0x01, 0x46, 0x01, // Ýņ (U+00DD U+0146)
  0x00, 0xDD, 0x01, 0x48, 0x01, // Ýň (U+00DD U+0148)
  0x00, 0xDD, 0x01, 0x4B, 0x01, // Ýŋ (U+00DD U+014B)
  0x00, 0xDD, 0x01, 0x4D, 0x01, // Ýō (U+00DD U+014D)
  0x00, 0xDD, 0x01, 0x4F, 0x01, // Ýŏ (U+00DD U+014F)
  0x00, 0xDD, 0x01, 0x51, 0x01, // Ýő (U+00DD U+0151)
  0x00, 0xDD, 0x01, 0x53, 0x01, // Ýœ (U+00DD U+0153)
  0x00, 0xDD, 0x01, 0x55, 0x01, // Ýŕ (U+00DD U+0155)
  0x00, 0xDD, 0x01, 0x57, 0x01, // Ýŗ (U+00DD U+0157)
  0x00, 0xDD, 0x01, 0x5B, 0x01, // Ýś (U+00DD U+015B)
  0x00, 0xDD, 0x01, 0x5D, 0x01, // Ýŝ (U+00DD U+015D)
  0x00, 0xDD, 0x01, 0x5F, 0x01, // Ýş (U+00DD U+015F)
  0x00, 0xDD, 0x01, 0x61, 0x01, // Ýš (U+00DD U+0161)
  0x00, 0xDD, 0x01, 0x69, 0x01, // Ýũ (U+00DD U+0169)
  0x00, 0xDD, 0x01, 0x6B, 0x01, // Ýū (U+00DD U+016B)
  0x00, 0xDD, 0x01, 0x6D, 0x01, // Ýŭ (U+00DD U+016D)
  0x00, 0xDD, 0x01, 0x6F, 0x01, // Ýů (U+00DD U+016F)
  0x00, 0xDD, 0x01, 0x71, 0x01, // Ýű (U+00DD U+0171)
  0x00, 0xDD, 0x01, 0x73, 0x01, // Ýų (U+00DD U+0173)
  0x00, 0xDD, 0x01, 0x7A, 0x01, // Ýź (U+00DD U+017A)
  0x00, 0xDD, 0x01, 0x7C, 0x01, // Ýż (U+00DD U+017C)
  0x00, 0xDD, 0x01, 0x7E, 0x01, // Ýž (U+00DD U+017E)
  0x00, 0xDD, 0x20, 0x1A, 0x02, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x02, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x02, // Ý… (U+00DD U+2026)
  0x00, 0xDD, 0x20, 0x39, 0x01, // Ý‹ (U+00DD U+2039)
  0x00, 0xDD, 0x20, 0x3A, 0x01, // Ý› (U+00DD U+203A)
  0x00, 0xDE, 0x00, 0x2C, 0x04, // Þ, (U+00DE U+002C)
  0x00, 0xDE, 0x00, 0x2E, 0x04, // Þ. (U+00DE U+002E)
  0x00, 0xDE, 0x00, 0x41, 0x01, // ÞA (U+00DE U+0041)
  0x00, 0xDE, 0x00, 0x58, 0x01, // ÞX (U+00DE U+0058)
  0x00, 0xDE, 0x00, 0xC0, 0x01, // ÞÀ (U+00DE U+00C0)
  0x00, 0xDE, 0x00, 0xC1, 0x01, // ÞÁ (U+00DE U+00C1)
  0x00, 0xDE, 0x00, 0xC2, 0x01, // ÞÂ (U+00DE U+00C2)
  0x00, 0xDE, 0x00, 0xC3, 0x01, // ÞÃ (U+00DE U+00C3)
  0x00, 0xDE, 0x00, 0xC4, 0x01, // ÞÄ (U+00DE U+00C4)
  0x00, 0xDE, 0x00, 0xC5, 0x01, // ÞÅ (U+00DE U+00C5)
  0x00, 0xDE, 0x01, 0x00, 0x01, // ÞĀ (U+00DE U+0100)
  0x00, 0xDE, 0x01, 0x02, 0x01, // ÞĂ (U+00DE U+0102)
  0x00, 0xDE, 0x01, 0x04, 0x01, // ÞĄ (U+00DE U+0104)
  0x00, 0xDE, 0x20, 0x1A, 0x04, // Þ‚ (U+00DE U+201A)
  0x00, 0xDE, 0x20, 0x1E, 0x04, // Þ„ (U+00DE U+201E)
  0x00, 0xDE, 0x20, 0x26, 0x04, // Þ… (U+00DE U+2026)
  0x00, 0xFD, 0x00, 0x2C, 0x01, // ý, (U+00FD U+002C)
  0x00, 0xFD, 0x00, 0x2E, 0x01, // ý. (U+00FD U+002E)
  0x00, 0xFD, 0x20, 0x1A, 0x01, // ý‚ (U+00FD U+201A)
  0x00, 0xFD, 0x20, 0x1E, 0x01, // ý„ (U+00FD U+201E)
  0x00, 0xFD, 0x20, 0x26, 0x01, // ý… (U+00FD U+2026)
  0x00, 0xFF, 0x00, 0x2C, 0x01, // ÿ, (U+00FF U+002C)
  0x00, 0xFF, 0x00, 0x2E, 0x01, // ÿ. (U+00FF U+002E)
  0x00, 0xFF, 0x20, 0x1A, 0x01, // ÿ‚ (U+00FF U+201A)
  0x00, 0xFF, 0x20, 0x1E, 0x01, // ÿ„ (U+00FF U+201E)
  0x00, 0xFF, 0x20, 0x26, 0x01, // ÿ… (U+00FF U+2026)
  0x01, 0x00, 0x00, 0x22, 0x02, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x02, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x00, 0x54, 0x01, // ĀT (U+0100 U+0054)
  0x01, 0x00, 0x00, 0x59, 0x01, // ĀY (U+0100 U+0059)
  0x01, 0x00, 0x00, 0xDD, 0x01, // ĀÝ (U+0100 U+00DD)
  0x01, 0x00, 0x01, 0x62, 0x01, // ĀŢ (U+0100 U+0162)
  0x01, 0x00, 0x01, 0x64, 0x01, // ĀŤ (U+0100 U+0164)
  0x01, 0x00, 0x01, 0x66, 0x01, // ĀŦ (U+0100 U+0166)
  0x01, 0x00, 0x01, 0x76, 0x01, // ĀŶ (U+0100 U+0176)
  0x01, 0x00, 0x01, 0x78, 0x01, // ĀŸ (U+0100 U+0178)
  0x01, 0x00, 0x20, 0x19, 0x02, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1D, 0x02, // Ā” (U+0100 U+201D)
  0x01, 0x02, 0x00, 0x22, 0x02, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x02, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x00, 0x54, 0x01, // ĂT (U+0102 U+0054)
  0x01, 0x02, 0x00, 0x59, 0x01, // ĂY (U+0102 U+0059)
  0x01, 0x02, 0x00, 0xDD, 0x01, // ĂÝ (U+0102 U+00DD)
  0x01, 0x02, 0x01, 0x62, 0x01, // ĂŢ (U+0102 U+0162)
  0x01, 0x02, 0x01, 0x64, 0x01, // ĂŤ (U+0102 U+0164)
  0x01, 0x02, 0x01, 0x66, 0x01, // ĂŦ (U+0102 U+0166)
  0x01, 0x02, 0x01, 0x76, 0x01, // ĂŶ (U+0102 U+0176)
  0x01, 0x02, 0x01, 0x78, 0x01, // ĂŸ (U+0102 U+0178)
  0x01, 0x02, 0x20, 0x19, 0x02, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1D, 0x02, // Ă” (U+0102 U+201D)
  0x01, 0x04, 0x00, 0x22, 0x02, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x02, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x00, 0x54, 0x01, // ĄT (U+0104 U+0054)
  0x01, 0x04, 0x00, 0x59, 0x01, // ĄY (U+0104 U+0059)
  0x01, 0x04, 0x00, 0xDD, 0x01, // ĄÝ (U+0104 U+00DD)
  0x01, 0x04, 0x01, 0x62, 0x01, // ĄŢ (U+0104 U+0162)
  0x01, 0x04, 0x01, 0x64, 0x01, // ĄŤ (U+0104 U+0164)
  0x01, 0x04, 0x01, 0x66, 0x01, // ĄŦ (U+0104 U+0166)
  0x01, 0x04, 0x01, 0x76, 0x01, // ĄŶ (U+0104 U+0176)
  0x01, 0x04, 0x01, 0x78, 0x01, // ĄŸ (U+0104 U+0178)
  0x01, 0x04, 0x20, 0x19, 0x02, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1D, 0x02, // Ą” (U+0104 U+201D)
  0x01, 0x06, 0x00, 0x43, 0x01, // ĆC (U+0106 U+0043)
  0x01, 0x06, 0x00, 0x47, 0x01, // ĆG (U+0106 U+0047)
  0x01, 0x06, 0x00, 0x4F, 0x01, // ĆO (U+0106 U+004F)
  0x01, 0x06, 0x00, 0x51, 0x01, // ĆQ (U+0106 U+0051)
  0x01, 0x06, 0x00, 0xAB, 0x01, // Ć« (U+0106 U+00AB)
  0x01, 0x06, 0x00, 0xC7, 0x01, // ĆÇ (U+0106 U+00C7)
  0x01, 0x06, 0x00, 0xD2, 0x01, // ĆÒ (U+0106 U+00D2)
  0x01, 0x06, 0x00, 0xD3, 0x01, // ĆÓ (U+0106 U+00D3)
  0x01, 0x06, 0x00, 0xD4, 0x01, // ĆÔ (U+0106 U+00D4)
  0x01, 0x06, 0x00, 0xD5, 0x01, // ĆÕ (U+0106 U+00D5)
  0x01, 0x06, 0x00, 0xD6, 0x01, // ĆÖ (U+0106 U+00D6)
  0x01, 0x06, 0x00, 0xD8, 0x01, // ĆØ (U+0106 U+00D8)
  0x01, 0x06, 0x01, 0x06, 0x01, // ĆĆ (U+0106 U+0106)
  0x01, 0x06, 0x01, 0x08, 0x01, // ĆĈ (U+0106 U+0108)
  0x01, 0x06, 0x01, 0x0A, 0x01, // ĆĊ (U+0106 U+010A)
  0x01, 0x06, 0x01, 0x0C, 0x01, // ĆČ (U+0106 U+010C)
  0x01, 0x06, 0x01, 0x1C, 0x01, // ĆĜ (U+0106 U+011C)
  0x01, 0x06, 0x01, 0x1E, 0x01, // ĆĞ (U+0106 U+011E)
  0x01, 0x06, 0x01, 0x20, 0x01, // ĆĠ (U+0106 U+0120)
  0x01, 0x06, 0x01, 0x22, 0x01, // ĆĢ (U+0106 U+0122)
  0x01, 0x06, 0x01, 0x4C, 0x01, // ĆŌ (U+0106 U+014C)
  0x01, 0x06, 0x01, 0x4E, 0x01, // ĆŎ (U+0106 U+014E)
  0x01, 0x06, 0x01, 0x50, 0x01, // ĆŐ (U+0106 U+0150)
  0x01, 0x06, 0x01, 0x52, 0x01, // ĆŒ (U+0106 U+0152)
  0x01, 0x06, 0x20, 0x39, 0x01, // Ć‹ (U+0106 U+2039)
  0x01, 0x08, 0x00, 0x43, 0x01, // ĈC (U+0108 U+0043)
  0x01, 0x08, 0x00, 0x47, 0x01, // ĈG (U+0108 U+0047)
  0x01, 0x08, 0x00, 0x4F, 0x01, // ĈO (U+0108 U+004F)
  0x01, 0x08, 0x00, 0x51, 0x01, // ĈQ (U+0108 U+0051)
  0x01, 0x08, 0x00, 0xAB, 0x01, // Ĉ« (U+0108 U+00AB)
  0x01, 0x08, 0x00, 0xC7, 0x01, // ĈÇ (U+0108 U+00C7)
  0x01, 0x08, 0x00, 0xD2, 0x01, // ĈÒ (U+0108 U+00D2)
  0x01, 0x08, 0x00, 0xD3, 0x01, // ĈÓ (U+0108 U+00D3)
  0x01, 0x08, 0x00, 0xD4, 0x01, // ĈÔ (U+0108 U+00D4)
  0x01, 0x08, 0x00, 0xD5, 0x01, // ĈÕ (U+0108 U+00D5)
  0x01, 0x08, 0x00, 0xD6, 0x01, // ĈÖ (U+0108 U+00D6)
  0x01, 0x08, 0x00, 0xD8, 0x01, // ĈØ (U+0108 U+00D8)
  0x01, 0x08, 0x01, 0x06, 0x01, // ĈĆ (U+0108 U+0106)
  0x01, 0x08, 0x01, 0x08, 0x01, // ĈĈ (U+0108 U+0108)
  0x01, 0x08, 0x01, 0x0A, 0x01, // ĈĊ (U+0108 U+010A)
  0x01, 0x08, 0x01, 0x0C, 0x01, // ĈČ (U+0108 U+010C)
  0x01, 0x08, 0x01, 0x1C, 0x01, // ĈĜ (U+0108 U+011C)
  0x01, 0x08, 0x01, 0x1E, 0x01, // ĈĞ (U+0108 U+011E)
  0x01, 0x08, 0x01, 0x20, 0x01, // ĈĠ (U+0108 U+0120)
  0x01, 0x08, 0x01, 0x22, 0x01, // ĈĢ (U+0108 U+0122)
  0x01, 0x08, 0x01, 0x4C, 0x01, // ĈŌ (U+0108 U+014C)
  0x01, 0x08, 0x01, 0x4E, 0x01, // ĈŎ (U+0108 U+014E)
  0x01, 0x08, 0x01, 0x50, 0x01, // ĈŐ (U+0108 U+0150)
  0x01, 0x08, 0x01, 0x52, 0x01, // ĈŒ (U+0108 U+0152)
  0x01, 0x08, 0x20, 0x39, 0x01, // Ĉ‹ (U+0108 U+2039)
  0x01, 0x0A, 0x00, 0x43, 0x01, // ĊC (U+010A U+0043)
  0x01, 0x0A, 0x00, 0x47, 0x01, // ĊG (U+010A U+0047)
  0x01, 0x0A, 0x00, 0x4F, 0x01, // ĊO (U+010A U+004F)
  0x01, 0x0A, 0x00, 0x51, 0x01, // ĊQ (U+010A U+0051)
  0x01, 0x0A, 0x00, 0xAB, 0x01, // Ċ« (U+010A U+00AB)
  0x01, 0x0A, 0x00, 0xC7, 0x01, // ĊÇ (U+010A U+00C7)
  0x01, 0x0A, 0x00, 0xD2, 0x01, // ĊÒ (U+010A U+00D2)
  0x01, 0x0A, 0x00, 0xD3, 0x01, // ĊÓ (U+010A U+00D3)
  0x01, 0x0A, 0x00, 0xD4, 0x01, // ĊÔ (U+010A U+00D4)
  0x01, 0x0A, 0x00, 0xD5, 0x01, // ĊÕ (U+010A U+00D5)
  0x01, 0x0A, 0x00, 0xD6, 0x01, // ĊÖ (U+010A U+00D6)
  0x01, 0x0A, 0x00, 0xD8, 0x01, // ĊØ (U+010A U+00D8)
  0x01, 0x0A, 0x01, 0x06, 0x01, // ĊĆ (U+010A U+0106)
  0x01, 0x0A, 0x01, 0x08, 0x01, // ĊĈ (U+010A U+0108)
  0x01, 0x0A, 0x01, 0x0A, 0x01, // ĊĊ (U+010A U+010A)
  0x01, 0x0A, 0x01, 0x0C, 0x01, // ĊČ (U+010A U+010C)
  0x01, 0x0A, 0x01, 0x1C, 0x01, // ĊĜ (U+010A U+011C)
  0x01, 0x0A, 0x01, 0x1E, 0x01, // ĊĞ (U+010A U+011E)
  0x01, 0x0A, 0x01, 0x20, 0x01, // ĊĠ (U+010A U+0120)
  0x01, 0x0A, 0x01, 0x22, 0x01, // ĊĢ (U+010A U+0122)
  0x01, 0x0A, 0x01, 0x4C, 0x01, // ĊŌ (U+010A U+014C)
  0x01, 0x0A, 0x01, 0x4E, 0x01, // ĊŎ (U+010A U+014E)
  0x01, 0x0A, 0x01, 0x50, 0x01, // ĊŐ (U+010A U+0150)
  0x01, 0x0A, 0x01, 0x52, 0x01, // ĊŒ (U+010A U+0152)
  0x01, 0x0A, 0x20, 0x39, 0x01, // Ċ‹ (U+010A U+2039)
  0x01, 0x0C, 0x00, 0x43, 0x01, // ČC (U+010C U+0043)
  0x01, 0x0C, 0x00, 0x47, 0x01, // ČG (U+010C U+0047)
  0x01, 0x0C, 0x00, 0x4F, 0x01, // ČO (U+010C U+004F)
  0x01, 0x0C, 0x00, 0x51, 0x01, // ČQ (U+010C U+0051)
  0x01, 0x0C, 0x00, 0xAB, 0x01, // Č« (U+010C U+00AB)
  0x01, 0x0C, 0x00, 0xC7, 0x01, // ČÇ (U+010C U+00C7)
  0x01, 0x0C, 0x00, 0xD2, 0x01, // ČÒ (U+010C U+00D2)
  0x01, 0x0C, 0x00, 0xD3, 0x01, // ČÓ (U+010C U+00D3)
  0x01, 0x0C, 0x00, 0xD4, 0x01, // ČÔ (U+010C U+00D4)
  0x01, 0x0C, 0x00, 0xD5, 0x01, // ČÕ (U+010C U+00D5)
  0x01, 0x0C, 0x00, 0xD6, 0x01, // ČÖ (U+010C U+00D6)
  0x01, 0x0C, 0x00, 0xD8, 0x01, // ČØ (U+010C U+00D8)
  0x01, 0x0C, 0x01, 0x06, 0x01, // ČĆ (U+010C U+0106)
  0x01, 0x0C, 0x01, 0x08, 0x01, // ČĈ (U+010C U+0108)
  0x01, 0x0C, 0x01, 0x0A, 0x01, // ČĊ (U+010C U+010A)
  0x01, 0x0C, 0x01, 0x0C, 0x01, // ČČ (U+010C U+010C)
  0x01, 0x0C, 0x01, 0x1C, 0x01, // ČĜ (U+010C U+011C)
  0x01, 0x0C, 0x01, 0x1E, 0x01, // ČĞ (U+010C U+011E)
  0x01, 0x0C, 0x01, 0x20, 0x01, // ČĠ (U+010C U+0120)
  0x01, 0x0C, 0x01, 0x22, 0x01, // ČĢ (U+010C U+0122)
  0x01, 0x0C, 0x01, 0x4C, 0x01, // ČŌ (U+010C U+014C)
  0x01, 0x0C, 0x01, 0x4E, 0x01, // ČŎ (U+010C U+014E)
  0x01, 0x0C, 0x01, 0x50, 0x01, // ČŐ (U+010C U+0150)
  0x01, 0x0C, 0x01, 0x52, 0x01, // ČŒ (U+010C U+0152)
  0x01, 0x0C, 0x20, 0x39, 0x01, // Č‹ (U+010C U+2039)
  0x01, 0x0E, 0x00, 0x2C, 0x01, // Ď, (U+010E U+002C)
  0x01, 0x0E, 0x00, 0x2E, 0x01, // Ď. (U+010E U+002E)
  0x01, 0x0E, 0x00, 0x54, 0x01, // ĎT (U+010E U+0054)
  0x01, 0x0E, 0x01, 0x62, 0x01, // ĎŢ (U+010E U+0162)
  0x01, 0x0E, 0x01, 0x64, 0x01, // ĎŤ (U+010E U+0164)
  0x01, 0x0E, 0x01, 0x66, 0x01, // ĎŦ (U+010E U+0166)
  0x01, 0x0E, 0x20, 0x1A, 0x01, // Ď‚ (U+010E U+201A)
  0x01, 0x0E, 0x20, 0x1E, 0x01, // Ď„ (U+010E U+201E)
  0x01, 0x0E, 0x20, 0x26, 0x01, // Ď… (U+010E U+2026)
  0x01, 0x10, 0x00, 0x2C, 0x01, // Đ, (U+0110 U+002C)
  0x01, 0x10, 0x00, 0x2E, 0x01, // Đ. (U+0110 U+002E)
  0x01, 0x10, 0x00, 0x54, 0x01, // ĐT (U+0110 U+0054)
  0x01, 0x10, 0x01, 0x62, 0x01, // ĐŢ (U+0110 U+0162)
  0x01, 0x10, 0x01, 0x64, 0x01, // ĐŤ (U+0110 U+0164)
  0x01, 0x10, 0x01, 0x66, 0x01, // ĐŦ (U+0110 U+0166)
  0x01, 0x10, 0x20, 0x1A, 0x01, // Đ‚ (U+0110 U+201A)
  0x01, 0x10, 0x20, 0x1E, 0x01, // Đ„ (U+0110 U+201E)
  0x01, 0x10, 0x20, 0x26, 0x01, // Đ… (U+0110 U+2026)
  0x01, 0x36, 0x00, 0xAB, 0x01, // Ķ« (U+0136 U+00AB)
  0x01, 0x36, 0x20, 0x39, 0x01, // Ķ‹ (U+0136 U+2039)
  0x01, 0x39, 0x00, 0x22, 0x02, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x02, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x00, 0x43, 0x01, // ĹC (U+0139 U+0043)
  0x01, 0x39, 0x00, 0x47, 0x01, // ĹG (U+0139 U+0047)
  0x01, 0x39, 0x00, 0x4F, 0x01, // ĹO (U+0139 U+004F)
  0x01, 0x39, 0x00, 0x51, 0x01, // ĹQ (U+0139 U+0051)
  0x01, 0x39, 0x00, 0x54, 0x01, // ĹT (U+0139 U+0054)
  0x01, 0x39, 0x00, 0x56, 0x01, // ĹV (U+0139 U+0056)
  0x01, 0x39, 0x00, 0x57, 0x01, // ĹW (U+0139 U+0057)
  0x01, 0x39, 0x00, 0x59, 0x01, // ĹY (U+0139 U+0059)
  0x01, 0x39, 0x00, 0xAB, 0x01, // Ĺ« (U+0139 U+00AB)
  0x01, 0x39, 0x00, 0xC7, 0x01, // ĹÇ (U+0139 U+00C7)
  0x01, 0x39, 0x00, 0xD2, 0x01, // ĹÒ (U+0139 U+00D2)
  0x01, 0x39, 0x00, 0xD3, 0x01, // ĹÓ (U+0139 U+00D3)
  0x01, 0x39, 0x00, 0xD4, 0x01, // ĹÔ (U+0139 U+00D4)
  0x01, 0x39, 0x00, 0xD5, 0x01, // ĹÕ (U+0139 U+00D5)
  0x01, 0x39, 0x00, 0xD6, 0x01, // ĹÖ (U+0139 U+00D6)
  0x01, 0x39, 0x00, 0xD8, 0x01, // ĹØ (U+0139 U+00D8)
  0x01, 0x39, 0x00, 0xDD, 0x01, // ĹÝ (U+0139 U+00DD)
  0x01, 0x39, 0x01, 0x06, 0x01, // ĹĆ (U+0139 U+0106)
  0x01, 0x39, 0x01, 0x08, 0x01, // ĹĈ (U+0139 U+0108)
  0x01, 0x39, 0x01, 0x0A, 0x01, // ĹĊ (U+0139 U+010A)
  0x01, 0x39, 0x01, 0x0C, 0x01, // ĹČ (U+0139 U+010C)
  0x01, 0x39, 0x01, 0x1C, 0x01, // ĹĜ (U+0139 U+011C)
  0x01, 0x39, 0x01, 0x1E, 0x01, // ĹĞ (U+0139 U+011E)
  0x01, 0x39, 0x01, 0x20, 0x01, // ĹĠ (U+0139 U+0120)
  0x01, 0x39, 0x01, 0x22, 0x01, // ĹĢ (U+0139 U+0122)
  0x01, 0x39, 0x01, 0x4C, 0x01, // ĹŌ (U+0139 U+014C)
  0x01, 0x39, 0x01, 0x4E, 0x01, // ĹŎ (U+0139 U+014E)
  0x01, 0x39, 0x01, 0x50, 0x01, // ĹŐ (U+0139 U+0150)
  0x01, 0x39, 0x01, 0x52, 0x01, // ĹŒ (U+0139 U+0152)
  0x01, 0x39, 0x01, 0x62, 0x01, // ĹŢ (U+0139 U+0162)
  0x01, 0x39, 0x01, 0x64, 0x01, // ĹŤ (U+0139 U+0164)
  0x01, 0x39, 0x01, 0x66, 0x01, // ĹŦ (U+0139 U+0166)
  0x01, 0x39, 0x01, 0x74, 0x01, // ĹŴ (U+0139 U+0174)
  0x01, 0x39, 0x01, 0x76, 0x01, // ĹŶ (U+0139 U+0176)
  0x01, 0x39, 0x01, 0x78, 0x01, // ĹŸ (U+0139 U+0178)
  0x01, 0x39, 0x20, 0x19, 0x02, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1D, 0x02, // Ĺ” (U+0139 U+201D)
  0x01, 0x39, 0x20, 0x39, 0x01, // Ĺ‹ (U+0139 U+2039)
  0x01, 0x3B, 0x00, 0x22, 0x02, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x02, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x00, 0x43, 0x01, // ĻC (U+013B U+0043)
  0x01, 0x3B, 0x00, 0x47, 0x01, // ĻG (U+013B U+0047)
  0x01, 0x3B, 0x00, 0x4F, 0x01, // ĻO (U+013B U+004F)
  0x01, 0x3B, 0x00, 0x51, 0x01, // ĻQ (U+013B U+0051)
  0x01, 0x3B, 0x00, 0x54, 0x01, // ĻT (U+013B U+0054)
  0x01, 0x3B, 0x00, 0x56, 0x01, // ĻV (U+013B U+0056)
  0x01, 0x3B, 0x00, 0x57, 0x01, // ĻW (U+013B U+0057)
  0x01, 0x3B, 0x00, 0x59, 0x01, // ĻY (U+013B U+0059)
  0x01, 0x3B, 0x00, 0xAB, 0x01, // Ļ« (U+013B U+00AB)
  0x01, 0x3B, 0x00, 0xC7, 0x01, // ĻÇ (U+013B U+00C7)
  0x01, 0x3B, 0x00, 0xD2, 0x01, // ĻÒ (U+013B U+00D2)
  0x01, 0x3B, 0x00, 0xD3, 0x01, // ĻÓ (U+013B U+00D3)
  0x01, 0x3B, 0x00, 0xD4, 0x01, // ĻÔ (U+013B U+00D4)
  0x01, 0x3B, 0x00, 0xD5, 0x01, // ĻÕ (U+013B U+00D5)
  0x01, 0x3B, 0x00, 0xD6, 0x01, // ĻÖ (U+013B U+00D6)
  0x01, 0x3B, 0x00, 0xD8, 0x01, // ĻØ (U+013B U+00D8)
  0x01, 0x3B, 0x00, 0xDD, 0x01, // ĻÝ (U+013B U+00DD)
  0x01, 0x3B, 0x01, 0x06, 0x01, // ĻĆ (U+013B U+0106)
  0x01, 0x3B, 0x01, 0x08, 0x01, // ĻĈ (U+013B U+0108)
  0x01, 0x3B, 0x01, 0x0A, 0x01, // ĻĊ (U+013B U+010A)
  0x01, 0x3B, 0x01, 0x0C, 0x01, // ĻČ (U+013B U+010C)
  0x01, 0x3B, 0x01, 0x1C, 0x01, // ĻĜ (U+013B U+011C)
  0x01, 0x3B, 0x01, 0x1E, 0x01, // ĻĞ (U+013B U+011E)
  0x01, 0x3B, 0x01, 0x20, 0x01, // ĻĠ (U+013B U+0120)
  0x01, 0x3B, 0x01, 0x22, 0x01, // ĻĢ (U+013B U+0122)
  0x01, 0x3B, 0x01, 0x4C, 0x01, // ĻŌ (U+013B U+014C)
  0x01, 0x3B, 0x01, 0x4E, 0x01, // ĻŎ (U+013B U+014E)
  0x01, 0x3B, 0x01, 0x50, 0x01, // ĻŐ (U+013B U+0150)
  0x01, 0x3B, 0x01, 0x52, 0x01, // ĻŒ (U+013B U+0152)
  0x01, 0x3B, 0x01, 0x62, 0x01, // ĻŢ (U+013B U+0162)
  0x01, 0x3B, 0x01, 0x64, 0x01, // ĻŤ (U+013B U+0164)
  0x01, 0x3B, 0x01, 0x66, 0x01, // ĻŦ (U+013B U+0166)
  0x01, 0x3B, 0x01, 0x74, 0x01, // ĻŴ (U+013B U+0174)
  0x01, 0x3B, 0x01, 0x76, 0x01, // ĻŶ (U+013B U+0176)
  0x01, 0x3B, 0x01, 0x78, 0x01, // ĻŸ (U+013B U+0178)
  0x01, 0x3B, 0x20, 0x19, 0x02, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1D, 0x02, // Ļ” (U+013B U+201D)
  0x01, 0x3B, 0x20, 0x39, 0x01, // Ļ‹ (U+013B U+2039)
  0x01, 0x3D, 0x00, 0x22, 0x02, // Ľ" (U+013D U+0022)
  0x01, 0x3D, 0x00, 0x27, 0x02, // Ľ' (U+013D U+0027)
  0x01, 0x3D, 0x00, 0x43, 0x01, // ĽC (U+013D U+0043)
  0x01, 0x3D, 0x00, 0x47, 0x01, // ĽG (U+013D U+0047)
  0x01, 0x3D, 0x00, 0x4F, 0x01, // ĽO (U+013D U+004F)
  0x01, 0x3D, 0x00, 0x51, 0x01, // ĽQ (U+013D U+0051)
  0x01, 0x3D, 0x00, 0x54, 0x01, // ĽT (U+013D U+0054)
  0x01, 0x3D, 0x00, 0x56, 0x01, // ĽV (U+013D U+0056)
  0x01, 0x3D, 0x00, 0x57, 0x01, // ĽW (U+013D U+0057)
  0x01, 0x3D, 0x00, 0x59, 0x01, // ĽY (U+013D U+0059)
  0x01, 0x3D, 0x00, 0xAB, 0x01, // Ľ« (U+013D U+00AB)
  0x01, 0x3D, 0x00, 0xC7, 0x01, // ĽÇ (U+013D U+00C7)
  0x01, 0x3D, 0x00, 0xD2, 0x01, // ĽÒ (U+013D U+00D2)
  0x01, 0x3D, 0x00, 0xD3, 0x01, // ĽÓ (U+013D U+00D3)
  0x01, 0x3D, 0x00, 0xD4, 0x01, // ĽÔ (U+013D U+00D4)
  0x01, 0x3D, 0x00, 0xD5, 0x01, // ĽÕ (U+013D U+00D5)
  0x01, 0x3D, 0x00, 0xD6, 0x01, // ĽÖ (U+013D U+00D6)
  0x01, 0x3D, 0x00, 0xD8, 0x01, // ĽØ (U+013D U+00D8)
  0x01, 0x3D, 0x00, 0xDD, 0x01, // ĽÝ (U+013D U+00DD)
  0x01, 0x3D, 0x01, 0x06, 0x01, // ĽĆ (U+013D U+0106)
  0x01, 0x3D, 0x01, 0x08, 0x01, // ĽĈ (U+013D U+0108)
  0x01, 0x3D, 0x01, 0x0A, 0x01, // ĽĊ (U+013D U+010A)
  0x01, 0x3D, 0x01, 0x0C, 0x01, // ĽČ (U+013D U+010C)
  0x01, 0x3D, 0x01, 0x1C, 0x01, // ĽĜ (U+013D U+011C)
  0x01, 0x3D, 0x01, 0x1E, 0x01, // ĽĞ (U+013D U+011E)
  0x01, 0x3D, 0x01, 0x20, 0x01, // ĽĠ (U+013D U+0120)
  0x01, 0x3D, 0x01, 0x22, 0x01, // ĽĢ (U+013D U+0122)
  0x01, 0x3D, 0x01, 0x4C, 0x01, // ĽŌ (U+013D U+014C)
  0x01, 0x3D, 0x01, 0x4E, 0x01, // ĽŎ (U+013D U+014E)
  0x01, 0x3D, 0x01, 0x50, 0x01, // ĽŐ (U+013D U+0150)
  0x01, 0x3D, 0x01, 0x52, 0x01, // ĽŒ (U+013D U+0152)
  0x01, 0x3D, 0x01, 0x62, 0x01, // ĽŢ (U+013D U+0162)
  0x01, 0x3D, 0x01, 0x64, 0x01, // ĽŤ (U+013D U+0164)
  0x01, 0x3D, 0x01, 0x66, 0x01, // ĽŦ (U+013D U+0166)
  0x01, 0x3D, 0x01, 0x74, 0x01, // ĽŴ (U+013D U+0174)
  0x01, 0x3D, 0x01, 0x76, 0x01, // ĽŶ (U+013D U+0176)
  0x01, 0x3D, 0x01, 0x78, 0x01, // ĽŸ (U+013D U+0178)
  0x01, 0x3D, 0x20, 0x19, 0x02, // Ľ’ (U+013D U+2019)
  0x01, 0x3D, 0x20, 0x1D, 0x02, // Ľ” (U+013D U+201D)
  0x01, 0x3D, 0x20, 0x39, 0x01, // Ľ‹ (U+013D U+2039)
  0x01, 0x3F, 0x00, 0x22, 0x02, // Ŀ" (U+013F U+0022)
  0x01, 0x3F, 0x00, 0x27, 0x02, // Ŀ' (U+013F U+0027)
  0x01, 0x3F, 0x00, 0x43, 0x01, // ĿC (U+013F U+0043)
  0x01, 0x3F, 0x00, 0x47, 0x01, // ĿG (U+013F U+0047)
  0x01, 0x3F, 0x00, 0x4F, 0x01, // ĿO (U+013F U+004F)
  0x01, 0x3F, 0x00, 0x51, 0x01, // ĿQ (U+013F U+0051)
  0x01, 0x3F, 0x00, 0x54, 0x01, // ĿT (U+013F U+0054)
  0x01, 0x3F, 0x00, 0x56, 0x01, // ĿV (U+013F U+0056)
  0x01, 0x3F, 0x00, 0x57, 0x01, // ĿW (U+013F U+0057)
  0x01, 0x3F, 0x00, 0x59, 0x01, // ĿY (U+013F U+0059)
  0x01, 0x3F, 0x00, 0xAB, 0x01, // Ŀ« (U+013F U+00AB)
  0x01, 0x3F, 0x00, 0xC7, 0x01, // ĿÇ (U+013F U+00C7)
  0x01, 0x3F, 0x00, 0xD2, 0x01, // ĿÒ (U+013F U+00D2)
  0x01, 0x3F, 0x00, 0xD3, 0x01, // ĿÓ (U+013F U+00D3)
  0x01, 0x3F, 0x00, 0xD4, 0x01, // ĿÔ (U+013F U+00D4)
  0x01, 0x3F, 0x00, 0xD5, 0x01, // ĿÕ (U+013F U+00D5)
  0x01, 0x3F, 0x00, 0xD6, 0x01, // ĿÖ (U+013F U+00D6)
  0x01, 0x3F, 0x00, 0xD8, 0x01, // ĿØ (U+013F U+00D8)
  0x01, 0x3F, 0x00, 0xDD, 0x01, // ĿÝ (U+013F U+00DD)
  0x01, 0x3F, 0x01, 0x06, 0x01, // ĿĆ (U+013F U+0106)
  0x01, 0x3F, 0x01, 0x08, 0x01, // ĿĈ (U+013F U+0108)
  0x01, 0x3F, 0x01, 0x0A, 0x01, // ĿĊ (U+013F U+010A)
  0x01, 0x3F, 0x01, 0x0C, 0x01, // ĿČ (U+013F U+010C)
  0x01, 0x3F, 0x01, 0x1C, 0x01, // ĿĜ (U+013F U+011C)
  0x01, 0x3F, 0x01, 0x1E, 0x01, // ĿĞ (U+013F U+011E)
  0x01, 0x3F, 0x01, 0x20, 0x01, // ĿĠ (U+013F U+0120)
  0x01, 0x3F, 0x01, 0x22, 0x01, // ĿĢ (U+013F U+0122)
  0x01, 0x3F, 0x01, 0x4C, 0x01, // ĿŌ (U+013F U+014C)
  0x01, 0x3F, 0x01, 0x4E, 0x01, // ĿŎ (U+013F U+014E)
  0x01, 0x3F, 0x01, 0x50, 0x01, // ĿŐ (U+013F U+0150)
  0x01, 0x3F, 0x01, 0x52, 0x01, // ĿŒ (U+013F U+0152)
  0x01, 0x3F, 0x01, 0x62, 0x01, // ĿŢ (U+013F U+0162)
  0x01, 0x3F, 0x01, 0x64, 0x01, // ĿŤ (U+013F U+0164)
  0x01, 0x3F, 0x01, 0x66, 0x01, // ĿŦ (U+013F U+0166)
  0x01, 0x3F, 0x01, 0x74, 0x01, // ĿŴ (U+013F U+0174)
  0x01, 0x3F, 0x01, 0x76, 0x01, // ĿŶ (U+013F U+0176)
  0x01, 0x3F, 0x01, 0x78, 0x01, // ĿŸ (U+013F U+0178)
  0x01, 0x3F, 0x20, 0x19, 0x02, // Ŀ’ (U+013F U+2019)
  0x01, 0x3F, 0x20, 0x1D, 0x02, // Ŀ” (U+013F U+201D)
  0x01, 0x3F, 0x20, 0x39, 0x01, // Ŀ‹ (U+013F U+2039)
  0x01, 0x41, 0x00, 0x22, 0x02, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x02, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x00, 0x43, 0x01, // ŁC (U+0141 U+0043)
  0x01, 0x41, 0x00, 0x47, 0x01, // ŁG (U+0141 U+0047)
  0x01, 0x41, 0x00, 0x4F, 0x01, // ŁO (U+0141 U+004F)
  0x01, 0x41, 0x00, 0x51, 0x01, // ŁQ (U+0141 U+0051)
  0x01, 0x41, 0x00, 0x54, 0x01, // ŁT (U+0141 U+0054)
  0x01, 0x41, 0x00, 0x56, 0x01, // ŁV (U+0141 U+0056)
  0x01, 0x41, 0x00, 0x57, 0x01, // ŁW (U+0141 U+0057)
  0x01, 0x41, 0x00, 0x59, 0x01, // ŁY (U+0141 U+0059)
  0x01, 0x41, 0x00, 0xAB, 0x01, // Ł« (U+0141 U+00AB)
  0x01, 0x41, 0x00, 0xC7, 0x01, // ŁÇ (U+0141 U+00C7)
  0x01, 0x41, 0x00, 0xD2, 0x01, // ŁÒ (U+0141 U+00D2)
  0x01, 0x41, 0x00, 0xD3, 0x01, // ŁÓ (U+0141 U+00D3)
  0x01, 0x41, 0x00, 0xD4, 0x01, // ŁÔ (U+0141 U+00D4)
  0x01, 0x41, 0x00, 0xD5, 0x01, // ŁÕ (U+0141 U+00D5)
  0x01, 0x41, 0x00, 0xD6, 0x01, // ŁÖ (U+0141 U+00D6)
  0x01, 0x41, 0x00, 0xD8, 0x01, // ŁØ (U+0141 U+00D8)
  0x01, 0x41, 0x00, 0xDD, 0x01, // ŁÝ (U+0141 U+00DD)
  0x01, 0x41, 0x01, 0x06, 0x01, // ŁĆ (U+0141 U+0106)
  0x01, 0x41, 0x01, 0x08, 0x01, // ŁĈ (U+0141 U+0108)
  0x01, 0x41, 0x01, 0x0A, 0x01, // ŁĊ (U+0141 U+010A)
  0x01, 0x41, 0x01, 0x0C, 0x01, // ŁČ (U+0141 U+010C)
  0x01, 0x41, 0x01, 0x1C, 0x01, // ŁĜ (U+0141 U+011C)
  0x01, 0x41, 0x01, 0x1E, 0x01, // ŁĞ (U+0141 U+011E)
  0x01, 0x41, 0x01, 0x20, 0x01, // ŁĠ (U+0141 U+0120)
  0x01, 0x41, 0x01, 0x22, 0x01, // ŁĢ (U+0141 U+0122)
  0x01, 0x41, 0x01, 0x4C, 0x01, // ŁŌ (U+0141 U+014C)
  0x01, 0x41, 0x01, 0x4E, 0x01, // ŁŎ (U+0141 U+014E)
  0x01, 0x41, 0x01, 0x50, 0x01, // ŁŐ (U+0141 U+0150)
  0x01, 0x41, 0x01, 0x52, 0x01, // ŁŒ (U+0141 U+0152)
  0x01, 0x41, 0x01, 0x62, 0x01, // ŁŢ (U+0141 U+0162)
  0x01, 0x41, 0x01, 0x64, 0x01, // ŁŤ (U+0141 U+0164)
  0x01, 0x41, 0x01, 0x66, 0x01, // ŁŦ (U+0141 U+0166)
  0x01, 0x41, 0x01, 0x74, 0x01, // ŁŴ (U+0141 U+0174)
  0x01, 0x41, 0x01, 0x76, 0x01, // ŁŶ (U+0141 U+0176)
  0x01, 0x41, 0x01, 0x78, 0x01, // ŁŸ (U+0141 U+0178)
  0x01, 0x41, 0x20, 0x19, 0x02, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1D, 0x02, // Ł” (U+0141 U+201D)
  0x01, 0x41, 0x20, 0x39, 0x01, // Ł‹ (U+0141 U+2039)
  0x01, 0x4C, 0x00, 0x2C, 0x01, // Ō, (U+014C U+002C)
  0x01, 0x4C, 0x00, 0x2E, 0x01, // Ō. (U+014C U+002E)
  0x01, 0x4C, 0x00, 0x54, 0x01, // ŌT (U+014C U+0054)
  0x01, 0x4C, 0x01, 0x62, 0x01, // ŌŢ (U+014C U+0162)
  0x01, 0x4C, 0x01, 0x64, 0x01, // ŌŤ (U+014C U+0164)
  0x01, 0x4C, 0x01, 0x66, 0x01, // ŌŦ (U+014C U+0166)
  0x01, 0x4C, 0x20, 0x1A, 0x01, // Ō‚ (U+014C U+201A)
  0x01, 0x4C, 0x20, 0x1E, 0x01, // Ō„ (U+014C U+201E)
  0x01, 0x4C, 0x20, 0x26, 0x01, // Ō… (U+014C U+2026)
  0x01, 0x4E, 0x00, 0x2C, 0x01, // Ŏ, (U+014E U+002C)
  0x01, 0x4E, 0x00, 0x2E, 0x01, // Ŏ. (U+014E U+002E)
  0x01, 0x4E, 0x00, 0x54, 0x01, // ŎT (U+014E U+0054)
  0x01, 0x4E, 0x01, 0x62, 0x01, // ŎŢ (U+014E U+0162)
  0x01, 0x4E, 0x01, 0x64, 0x01, // ŎŤ (U+014E U+0164)
  0x01, 0x4E, 0x01, 0x66, 0x01, // ŎŦ (U+014E U+0166)
  0x01, 0x4E, 0x20, 0x1A, 0x01, // Ŏ‚ (U+014E U+201A)
  0x01, 0x4E, 0x20, 0x1E, 0x01, // Ŏ„ (U+014E U+201E)
  0x01, 0x4E, 0x20, 0x26, 0x01, // Ŏ… (U+014E U+2026)
  0x01, 0x50, 0x00, 0x2C, 0x01, // Ő, (U+0150 U+002C)
  0x01, 0x50, 0x00, 0x2E, 0x01, // Ő. (U+0150 U+002E)
  0x01, 0x50, 0x00, 0x54, 0x01, // ŐT (U+0150 U+0054)
  0x01, 0x50, 0x01, 0x62, 0x01, // ŐŢ (U+0150 U+0162)
  0x01, 0x50, 0x01, 0x64, 0x01, // ŐŤ (U+0150 U+0164)
  0x01, 0x50, 0x01, 0x66, 0x01, // ŐŦ (U+0150 U+0166)
  0x01, 0x50, 0x20, 0x1A, 0x01, // Ő‚ (U+0150 U+201A)
  0x01, 0x50, 0x20, 0x1E, 0x01, // Ő„ (U+0150 U+201E)
  0x01, 0x50, 0x20, 0x26, 0x01, // Ő… (U+0150 U+2026)
  0x01, 0x62, 0x00, 0x2C, 0x02, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2D, 0x01, // Ţ- (U+0162 U+002D)
  0x01, 0x62, 0x00, 0x2E, 0x02, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0x41, 0x01, // ŢA (U+0162 U+0041)
  0x01, 0x62, 0x00, 0x61, 0x01, // Ţa (U+0162 U+0061)
  0x01, 0x62, 0x00, 0x63, 0x01, // Ţc (U+0162 U+0063)
  0x01, 0x62, 0x00, 0x64, 0x01, // Ţd (U+0162 U+0064)
  0x01, 0x62, 0x00, 0x65, 0x01, // Ţe (U+0162 U+0065)
  0x01, 0x62, 0x00, 0x67, 0x01, // Ţg (U+0162 U+0067)
  0x01, 0x62, 0x00, 0x6D, 0x01, // Ţm (U+0162 U+006D)
  0x01, 0x62, 0x00, 0x6E, 0x01, // Ţn (U+0162 U+006E)
  0x01, 0x62, 0x00, 0x6F, 0x01, // Ţo (U+0162 U+006F)
  0x01, 0x62, 0x00, 0x70, 0x01, // Ţp (U+0162 U+0070)
  0x01, 0x62, 0x00, 0x71, 0x01, // Ţq (U+0162 U+0071)
  0x01, 0x62, 0x00, 0x72, 0x01, // Ţr (U+0162 U+0072)
  0x01, 0x62, 0x00, 0x73, 0x01, // Ţs (U+0162 U+0073)
  0x01, 0x62, 0x00, 0x75, 0x01, // Ţu (U+0162 U+0075)
  0x01, 0x62, 0x00, 0x76, 0x01, // Ţv (U+0162 U+0076)
  0x01, 0x62, 0x00, 0x77, 0x01, // Ţw (U+0162 U+0077)
  0x01, 0x62, 0x00, 0x79, 0x01, // Ţy (U+0162 U+0079)
  0x01, 0x62, 0x00, 0x7A, 0x01, // Ţz (U+0162 U+007A)
  0x01, 0x62, 0x00, 0xAB, 0x01, // Ţ« (U+0162 U+00AB)
  0x01, 0x62, 0x00, 0xBB, 0x01, // Ţ» (U+0162 U+00BB)
  0x01, 0x62, 0x00, 0xC0, 0x01, // ŢÀ (U+0162 U+00C0)
  0x01, 0x62, 0x00, 0xC1, 0x01, // ŢÁ (U+0162 U+00C1)
  0x01, 0x62, 0x00, 0xC2, 0x01, // ŢÂ (U+0162 U+00C2)
  0x01, 0x62, 0x00, 0xC3, 0x01, // ŢÃ (U+0162 U+00C3)
  0x01, 0x62, 0x00, 0xC4, 0x01, // ŢÄ (U+0162 U+00C4)
  0x01, 0x62, 0x00, 0xC5, 0x01, // ŢÅ (U+0162 U+00C5)
  0x01, 0x62, 0x00, 0xE0, 0x01, // Ţà (U+0162 U+00E0)
  0x01, 0x62, 0x00, 0xE1, 0x01, // Ţá (U+0162 U+00E1)
  0x01, 0x62, 0x00, 0xE2, 0x01, // Ţâ (U+0162 U+00E2)
  0x01, 0x62, 0x00, 0xE3, 0x01, // Ţã (U+0162 U+00E3)
  0x01, 0x62, 0x00, 0xE4, 0x01, // Ţä (U+0162 U+00E4)
  0x01, 0x62, 0x00, 0xE5, 0x01, // Ţå (U+0162 U+00E5)
  0x01, 0x62, 0x00, 0xE6, 0x01, // Ţæ (U+0162 U+00E6)
  0x01, 0x62, 0x00, 0xE7, 0x01, // Ţç (U+0162 U+00E7)
  0x01, 0x62, 0x00, 0xE8, 0x01, // Ţè (U+0162 U+00E8)
  0x01, 0x62, 0x00, 0xE9, 0x01, // Ţé (U+0162 U+00E9)
  0x01, 0x62, 0x00, 0xEA, 0x01, // Ţê (U+0162 U+00EA)
  0x01, 0x62, 0x00, 0xEB, 0x01, // Ţë (U+0162 U+00EB)
  0x01, 0x62, 0x00, 0xF1, 0x01, // Ţñ (U+0162 U+00F1)
  0x01, 0x62, 0x00, 0xF2, 0x01, // Ţò (U+0162 U+00F2)
  0x01, 0x62, 0x00, 0xF3, 0x01, // Ţó (U+0162 U+00F3)
  0x01, 0x62, 0x00, 0xF4, 0x01, // Ţô (U+0162 U+00F4)
  0x01, 0x62, 0x00, 0xF5, 0x01, // Ţõ (U+0162 U+00F5)
  0x01, 0x62, 0x00, 0xF6, 0x01, // Ţö (U+0162 U+00F6)
  0x01, 0x62, 0x00, 0xF8, 0x01, // Ţø (U+0162 U+00F8)
  0x01, 0x62, 0x00, 0xF9, 0x01, // Ţù (U+0162 U+00F9)
  0x01, 0x62, 0x00, 0xFA, 0x01, // Ţú (U+0162 U+00FA)
  0x01, 0x62, 0x00, 0xFB, 0x01, // Ţû (U+0162 U+00FB)
  0x01, 0x62, 0x00, 0xFC, 0x01, // Ţü (U+0162 U+00FC)
  0x01, 0x62, 0x00, 0xFD, 0x01, // Ţý (U+0162 U+00FD)
  0x01, 0x62, 0x00, 0xFF, 0x01, // Ţÿ (U+0162 U+00FF)
  0x01, 0x62, 0x01, 0x00, 0x01, // ŢĀ (U+0162 U+0100)
  0x01, 0x62, 0x01, 0x01, 0x01, // Ţā (U+0162 U+0101)
  0x01, 0x62, 0x01, 0x02, 0x01, // ŢĂ (U+0162 U+0102)
  0x01, 0x62, 0x01, 0x03, 0x01, // Ţă (U+0162 U+0103)
  0x01, 0x62, 0x01, 0x04, 0x01, // ŢĄ (U+0162 U+0104)
  0x01, 0x62, 0x01, 0x05, 0x01, // Ţą (U+0162 U+0105)
  0x01, 0x62, 0x01, 0x07, 0x01, // Ţć (U+0162 U+0107)
  0x01, 0x62, 0x01, 0x09, 0x01, // Ţĉ (U+0162 U+0109)
  0x01, 0x62, 0x01, 0x0B, 0x01, // Ţċ (U+0162 U+010B)
  0x01, 0x62, 0x01, 0x0D, 0x01, // Ţč (U+0162 U+010D)
  0x01, 0x62, 0x01, 0x0F, 0x01, // Ţď (U+0162 U+010F)
  0x01, 0x62, 0x01, 0x11, 0x01, // Ţđ (U+0162 U+0111)
  0x01, 0x62, 0x01, 0x13, 0x01, // Ţē (U+0162 U+0113)
  0x01, 0x62, 0x01, 0x15, 0x01, // Ţĕ (U+0162 U+0115)
  0x01, 0x62, 0x01, 0x17, 0x01, // Ţė (U+0162 U+0117)
  0x01, 0x62, 0x01, 0x19, 0x01, // Ţę (U+0162 U+0119)
  0x01, 0x62, 0x01, 0x1B, 0x01, // Ţě (U+0162 U+011B)
  0x01, 0x62, 0x01, 0x1D, 0x01, // Ţĝ (U+0162 U+011D)
  0x01, 0x62, 0x01, 0x1F, 0x01, // Ţğ (U+0162 U+011F)
  0x01, 0x62, 0x01, 0x21, 0x01, // Ţġ (U+0162 U+0121)
  0x01, 0x62, 0x01, 0x23, 0x01, // Ţģ (U+0162 U+0123)
  0x01, 0x62, 0x01, 0x38, 0x01, // Ţĸ (U+0162 U+0138)
  0x01, 0x62, 0x01, 0x44, 0x01, // Ţń (U+0162 U+0144)
  0x01, 0x62, 0x01, 0x46, 0x01, // Ţņ (U+0162 U+0146)
  0x01, 0x62, 0x01, 0x48, 0x01, // Ţň (U+0162 U+0148)
  0x01, 0x62, 0x01, 0x4B, 0x01, // Ţŋ (U+0162 U+014B)
  0x01, 0x62, 0x01, 0x4D, 0x01, // Ţō (U+0162 U+014D)
  0x01, 0x62, 0x01, 0x4F, 0x01, // Ţŏ (U+0162 U+014F)
  0x01, 0x62, 0x01, 0x51, 0x01, // Ţő (U+0162 U+0151)
  0x01, 0x62, 0x01, 0x53, 0x01, // Ţœ (U+0162 U+0153)
  0x01, 0x62, 0x01, 0x55, 0x01, // Ţŕ (U+0162 U+0155)
  0x01, 0x62, 0x01, 0x57, 0x01, // Ţŗ (U+0162 U+0157)
  0x01, 0x62, 0x01, 0x5B, 0x01, // Ţś (U+0162 U+015B)
  0x01, 0x62, 0x01, 0x5D, 0x01, // Ţŝ (U+0162 U+015D)
  0x01, 0x62, 0x01, 0x5F, 0x01, // Ţş (U+0162 U+015F)
  0x01, 0x62, 0x01, 0x61, 0x01, // Ţš (U+0162 U+0161)
  0x01, 0x62, 0x01, 0x69, 0x01, // Ţũ (U+0162 U+0169)
  0x01, 0x62, 0x01, 0x6B, 0x01, // Ţū (U+0162 U+016B)
  0x01, 0x62, 0x01, 0x6D, 0x01, // Ţŭ (U+0162 U+016D)
  0x01, 0x62, 0x01, 0x6F, 0x01, // Ţů (U+0162 U+016F)
  0x01, 0x62, 0x01, 0x71, 0x01, // Ţű (U+0162 U+0171)
  0x01, 0x62, 0x01, 0x73, 0x01, // Ţų (U+0162 U+0173)
  0x01, 0x62, 0x01, 0x75, 0x01, // Ţŵ (U+0162 U+0175)
  0x01, 0x62, 0x01, 0x77, 0x01, // Ţŷ (U+0162 U+0177)
  0x01, 0x62, 0x01, 0x7A, 0x01, // Ţź (U+0162 U+017A)
  0x01, 0x62, 0x01, 0x7C, 0x01, // Ţż (U+0162 U+017C)
  0x01, 0x62, 0x01, 0x7E, 0x01, // Ţž (U+0162 U+017E)
  0x01, 0x62, 0x20, 0x13, 0x01, // Ţ– (U+0162 U+2013)
  0x01, 0x62, 0x20, 0x14, 0x01, // Ţ— (U+0162 U+2014)
  0x01, 0x62, 0x20, 0x1A, 0x02, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x02, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x02, // Ţ… (U+0162 U+2026)
  0x01, 0x62, 0x20, 0x39, 0x01, // Ţ‹ (U+0162 U+2039)
  0x01, 0x62, 0x20, 0x3A, 0x01, // Ţ› (U+0162 U+203A)
  0x01, 0x64, 0x00, 0x2C, 0x02, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2D, 0x01, // Ť- (U+0164 U+002D)
  0x01, 0x64, 0x00, 0x2E, 0x02, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0x41, 0x01, // ŤA (U+0164 U+0041)
  0x01, 0x64, 0x00, 0x61, 0x01, // Ťa (U+0164 U+0061)
  0x01, 0x64, 0x00, 0x63, 0x01, // Ťc (U+0164 U+0063)
  0x01, 0x64, 0x00, 0x64, 0x01, // Ťd (U+0164 U+0064)
  0x01, 0x64, 0x00, 0x65, 0x01, // Ťe (U+0164 U+0065)
  0x01, 0x64, 0x00, 0x67, 0x01, // Ťg (U+0164 U+0067)
  0x01, 0x64, 0x00, 0x6D, 0x01, // Ťm (U+0164 U+006D)
  0x01, 0x64, 0x00, 0x6E, 0x01, // Ťn (U+0164 U+006E)
  0x01, 0x64, 0x00, 0x6F, 0x01, // Ťo (U+0164 U+006F)
  0x01, 0x64, 0x00, 0x70, 0x01, // Ťp (U+0164 U+0070)
  0x01, 0x64, 0x00, 0x71, 0x01, // Ťq (U+0164 U+0071)
  0x01, 0x64, 0x00, 0x72, 0x01, // Ťr (U+0164 U+0072)
  0x01, 0x64, 0x00, 0x73, 0x01, // Ťs (U+0164 U+0073)
  0x01, 0x64, 0x00, 0x75, 0x01, // Ťu (U+0164 U+0075)
  0x01, 0x64, 0x00, 0x76, 0x01, // Ťv (U+0164 U+0076)
  0x01, 0x64, 0x00, 0x77, 0x01, // Ťw (U+0164 U+0077)
  0x01, 0x64, 0x00, 0x79, 0x01, // Ťy (U+0164 U+0079)
  0x01, 0x64, 0x00, 0x7A, 0x01, // Ťz (U+0164 U+007A)
  0x01, 0x64, 0x00, 0xAB, 0x01, // Ť« (U+0164 U+00AB)
  0x01, 0x64, 0x00, 0xBB, 0x01, // Ť» (U+0164 U+00BB)
  0x01, 0x64, 0x00, 0xC0, 0x01, // ŤÀ (U+0164 U+00C0)
  0x01, 0x64, 0x00, 0xC1, 0x01, // ŤÁ (U+0164 U+00C1)
  0x01, 0x64, 0x00, 0xC2, 0x01, // ŤÂ (U+0164 U+00C2)
  0x01, 0x64, 0x00, 0xC3, 0x01, // ŤÃ (U+0164 U+00C3)
  0x01, 0x64, 0x00, 0xC4, 0x01, // ŤÄ (U+0164 U+00C4)
  0x01, 0x64, 0x00, 0xC5, 0x01, // ŤÅ (U+0164 U+00C5)
  0x01, 0x64, 0x00, 0xE0, 0x01, // Ťà (U+0164 U+00E0)
  0x01, 0x64, 0x00, 0xE1, 0x01, // Ťá (U+0164 U+00E1)
  0x01, 0x64, 0x00, 0xE2, 0x01, // Ťâ (U+0164 U+00E2)
  0x01, 0x64, 0x00, 0xE3, 0x01, // Ťã (U+0164 U+00E3)
  0x01, 0x64, 0x00, 0xE4, 0x01, // Ťä (U+0164 U+00E4)
  0x01, 0x64, 0x00, 0xE5, 0x01, // Ťå (U+0164 U+00E5)
  0x01, 0x64, 0x00, 0xE6, 0x01, // Ťæ (U+0164 U+00E6)
  0x01, 0x64, 0x00, 0xE7, 0x01, // Ťç (U+0164 U+00E7)
  0x01, 0x64, 0x00, 0xE8, 0x01, // Ťè (U+0164 U+00E8)
  0x01, 0x64, 0x00, 0xE9, 0x01, // Ťé (U+0164 U+00E9)
  0x01, 0x64, 0x00, 0xEA, 0x01, // Ťê (U+0164 U+00EA)
  0x01, 0x64, 0x00, 0xEB, 0x01, // Ťë (U+0164 U+00EB)
  0x01, 0x64, 0x00, 0xF1, 0x01, // Ťñ (U+0164 U+00F1)
  0x01, 0x64, 0x00, 0xF2, 0x01, // Ťò (U+0164 U+00F2)
  0x01, 0x64, 0x00, 0xF3, 0x01, // Ťó (U+0164 U+00F3)
  0x01, 0x64, 0x00, 0xF4, 0x01, // Ťô (U+0164 U+00F4)
  0x01, 0x64, 0x00, 0xF5, 0x01, // Ťõ (U+0164 U+00F5)
  0x01, 0x64, 0x00, 0xF6, 0x01, // Ťö (U+0164 U+00F6)
  0x01, 0x64, 0x00, 0xF8, 0x01, // Ťø (U+0164 U+00F8)
  0x01, 0x64, 0x00, 0xF9, 0x01, // Ťù (U+0164 U+00F9)
  0x01, 0x64, 0x00, 0xFA, 0x01, // Ťú (U+0164 U+00FA)
  0x01, 0x64, 0x00, 0xFB, 0x01, // Ťû (U+0164 U+00FB)
  0x01, 0x64, 0x00, 0xFC, 0x01, // Ťü (U+0164 U+00FC)
  0x01, 0x64, 0x00, 0xFD, 0x01, // Ťý (U+0164 U+00FD)
  0x01, 0x64, 0x00, 0xFF, 0x01, // Ťÿ (U+0164 U+00FF)
  0x01, 0x64, 0x01, 0x00, 0x01, // ŤĀ (U+0164 U+0100)
  0x01, 0x64, 0x01, 0x01, 0x01, // Ťā (U+0164 U+0101)
  0x01, 0x64, 0x01, 0x02, 0x01, // ŤĂ (U+0164 U+0102)
  0x01, 0x64, 0x01, 0x03, 0x01, // Ťă (U+0164 U+0103)
  0x01, 0x64, 0x01, 0x04, 0x01, // ŤĄ (U+0164 U+0104)
  0x01, 0x64, 0x01, 0x05, 0x01, // Ťą (U+0164 U+0105)
  0x01, 0x64, 0x01, 0x07, 0x01, // Ťć (U+0164 U+0107)
  0x01, 0x64, 0x01, 0x09, 0x01, // Ťĉ (U+0164 U+0109)
  0x01, 0x64, 0x01, 0x0B, 0x01, // Ťċ (U+0164 U+010B)
  0x01, 0x64, 0x01, 0x0D, 0x01, // Ťč (U+0164 U+010D)
  0x01, 0x64, 0x01, 0x0F, 0x01, // Ťď (U+0164 U+010F)
  0x01, 0x64, 0x01, 0x11, 0x01, // Ťđ (U+0164 U+0111)
  0x01, 0x64, 0x01, 0x13, 0x01, // Ťē (U+0164 U+0113)
  0x01, 0x64, 0x01, 0x15, 0x01, // Ťĕ (U+0164 U+0115)
  0x01, 0x64, 0x01, 0x17, 0x01, // Ťė (U+0164 U+0117)
  0x01, 0x64, 0x01, 0x19, 0x01, // Ťę (U+0164 U+0119)
  0x01, 0x64, 0x01, 0x1B, 0x01, // Ťě (U+0164 U+011B)
  0x01, 0x64, 0x01, 0x1D, 0x01, // Ťĝ (U+0164 U+011D)
  0x01, 0x64, 0x01, 0x1F, 0x01, // Ťğ (U+0164 U+011F)
  0x01, 0x64, 0x01, 0x21, 0x01, // Ťġ (U+0164 U+0121)
  0x01, 0x64, 0x01, 0x23, 0x01, // Ťģ (U+0164 U+0123)
  0x01, 0x64, 0x01, 0x38, 0x01, // Ťĸ (U+0164 U+0138)
  0x01, 0x64, 0x01, 0x44, 0x01, // Ťń (U+0164 U+0144)
  0x01, 0x64, 0x01, 0x46, 0x01, // Ťņ (U+0164 U+0146)
  0x01, 0x64, 0x01, 0x48, 0x01, // Ťň (U+0164 U+0148)
  0x01, 0x64, 0x01, 0x4B, 0x01, // Ťŋ (U+0164 U+014B)
  0x01, 0x64, 0x01, 0x4D, 0x01, // Ťō (U+0164 U+014D)
  0x01, 0x64, 0x01, 0x4F, 0x01, // Ťŏ (U+0164 U+014F)
  0x01, 0x64, 0x01, 0x51, 0x01, // Ťő (U+0164 U+0151)
  0x01, 0x64, 0x01, 0x53, 0x01, // Ťœ (U+0164 U+0153)
  0x01, 0x64, 0x01, 0x55, 0x01, // Ťŕ (U+0164 U+0155)
  0x01, 0x64, 0x01, 0x57, 0x01, // Ťŗ (U+0164 U+0157)
  0x01, 0x64, 0x01, 0x5B, 0x01, // Ťś (U+0164 U+015B)
  0x01, 0x64, 0x01, 0x5D, 0x01, // Ťŝ (U+0164 U+015D)
  0x01, 0x64, 0x01, 0x5F, 0x01, // Ťş (U+0164 U+015F)
  0x01, 0x64, 0x01, 0x61, 0x01, // Ťš (U+0164 U+0161)
  0x01, 0x64, 0x01, 0x69, 0x01, // Ťũ (U+0164 U+0169)
  0x01, 0x64, 0x01, 0x6B, 0x01, // Ťū (U+0164 U+016B)
  0x01, 0x64, 0x01, 0x6D, 0x01, // Ťŭ (U+0164 U+016D)
  0x01, 0x64, 0x01, 0x6F, 0x01, // Ťů (U+0164 U+016F)
  0x01, 0x64, 0x01, 0x71, 0x01, // Ťű (U+0164 U+0171)
  0x01, 0x64, 0x01, 0x73, 0x01, // Ťų (U+0164 U+0173)
  0x01, 0x64, 0x01, 0x75, 0x01, // Ťŵ (U+0164 U+0175)
  0x01, 0x64, 0x01, 0x77, 0x01, // Ťŷ (U+0164 U+0177)
  0x01, 0x64, 0x01, 0x7A, 0x01, // Ťź (U+0164 U+017A)
  0x01, 0x64, 0x01, 0x7C, 0x01, // Ťż (U+0164 U+017C)
  0x01, 0x64, 0x01, 0x7E, 0x01, // Ťž (U+0164 U+017E)
  0x01, 0x64, 0x20, 0x13, 0x01, // Ť– (U+0164 U+2013)
  0x01, 0x64, 0x20, 0x14, 0x01, // Ť— (U+0164 U+2014)
  0x01, 0x64, 0x20, 0x1A, 0x02, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x02, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x02, // Ť… (U+0164 U+2026)
  0x01, 0x64, 0x20, 0x39, 0x01, // Ť‹ (U+0164 U+2039)
  0x01, 0x64, 0x20, 0x3A, 0x01, // Ť› (U+0164 U+203A)
  0x01, 0x66, 0x00, 0x2C, 0x02, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2D, 0x01, // Ŧ- (U+0166 U+002D)
  0x01, 0x66, 0x00, 0x2E, 0x02, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0x41, 0x01, // ŦA (U+0166 U+0041)
  0x01, 0x66, 0x00, 0x61, 0x01, // Ŧa (U+0166 U+0061)
  0x01, 0x66, 0x00, 0x63, 0x01, // Ŧc (U+0166 U+0063)
  0x01, 0x66, 0x00, 0x64, 0x01, // Ŧd (U+0166 U+0064)
  0x01, 0x66, 0x00, 0x65, 0x01, // Ŧe (U+0166 U+0065)
  0x01, 0x66, 0x00, 0x67, 0x01, // Ŧg (U+0166 U+0067)
  0x01, 0x66, 0x00, 0x6D, 0x01, // Ŧm (U+0166 U+006D)
  0x01, 0x66, 0x00, 0x6E, 0x01, // Ŧn (U+0166 U+006E)
  0x01, 0x66, 0x00, 0x6F, 0x01, // Ŧo (U+0166 U+006F)
  0x01, 0x66, 0x00, 0x70, 0x01, // Ŧp (U+0166 U+0070)
  0x01, 0x66, 0x00, 0x71, 0x01, // Ŧq (U+0166 U+0071)
  0x01, 0x66, 0x00, 0x72, 0x01, // Ŧr (U+0166 U+0072)
  0x01, 0x66, 0x00, 0x73, 0x01, // Ŧs (U+0166 U+0073)
  0x01, 0x66, 0x00, 0x75, 0x01, // Ŧu (U+0166 U+0075)
  0x01, 0x66, 0x00, 0x76, 0x01, // Ŧv (U+0166 U+0076)
  0x01, 0x66, 0x00, 0x77, 0x01, // Ŧw (U+0166 U+0077)
  0x01, 0x66, 0x00, 0x79, 0x01, // Ŧy (U+0166 U+0079)
  0x01, 0x66, 0x00, 0x7A, 0x01, // Ŧz (U+0166 U+007A)
  0x01, 0x66, 0x00, 0xAB, 0x01, // Ŧ« (U+0166 U+00AB)
  0x01, 0x66, 0x00, 0xBB, 0x01, // Ŧ» (U+0166 U+00BB)
  0x01, 0x66, 0x00, 0xC0, 0x01, // ŦÀ (U+0166 U+00C0)
  0x01, 0x66, 0x00, 0xC1, 0x01, // ŦÁ (U+0166 U+00C1)
  0x01, 0x66, 0x00, 0xC2, 0x01, // ŦÂ (U+0166 U+00C2)
  0x01, 0x66, 0x00, 0xC3, 0x01, // ŦÃ (U+0166 U+00C3)
  0x01, 0x66, 0x00, 0xC4, 0x01, // ŦÄ (U+0166 U+00C4)
  0x01, 0x66, 0x00, 0xC5, 0x01, // ŦÅ (U+0166 U+00C5)
  0x01, 0x66, 0x00, 0xE0, 0x01, // Ŧà (U+0166 U+00E0)
  0x01, 0x66, 0x00, 0xE1, 0x01, // Ŧá (U+0166 U+00E1)
  0x01, 0x66, 0x00, 0xE2, 0x01, // Ŧâ (U+0166 U+00E2)
  0x01, 0x66, 0x00, 0xE3, 0x01, // Ŧã (U+0166 U+00E3)
  0x01, 0x66, 0x00, 0xE4, 0x01, // Ŧä (U+0166 U+00E4)
  0x01, 0x66, 0x00, 0xE5, 0x01, // Ŧå (U+0166 U+00E5)
  0x01, 0x66, 0x00, 0xE6, 0x01, // Ŧæ (U+0166 U+00E6)
  0x01, 0x66, 0x00, 0xE7, 0x01, // Ŧç (U+0166 U+00E7)
  0x01, 0x66, 0x00, 0xE8, 0x01, // Ŧè (U+0166 U+00E8)
  0x01, 0x66, 0x00, 0xE9, 0x01, // Ŧé (U+0166 U+00E9)
  0x01, 0x66, 0x00, 0xEA, 0x01, // Ŧê (U+0166 U+00EA)
  0x01, 0x66, 0x00, 0xEB, 0x01, // Ŧë (U+0166 U+00EB)
  0x01, 0x66, 0x00, 0xF1, 0x01, // Ŧñ (U+0166 U+00F1)
  0x01, 0x66, 0x00, 0xF2, 0x01, // Ŧò (U+0166 U+00F2)
  0x01, 0x66, 0x00, 0xF3, 0x01, // Ŧó (U+0166 U+00F3)
  0x01, 0x66, 0x00, 0xF4, 0x01, // Ŧô (U+0166 U+00F4)
  0x01, 0x66, 0x00, 0xF5, 0x01, // Ŧõ (U+0166 U+00F5)
  0x01, 0x66, 0x00, 0xF6, 0x01, // Ŧö (U+0166 U+00F6)
  0x01, 0x66, 0x00, 0xF8, 0x01, // Ŧø (U+0166 U+00F8)
  0x01, 0x66, 0x00, 0xF9, 0x01, // Ŧù (U+0166 U+00F9)
  0x01, 0x66, 0x00, 0xFA, 0x01, // Ŧú (U+0166 U+00FA)
  0x01, 0x66, 0x00, 0xFB, 0x01, // Ŧû (U+0166 U+00FB)
  0x01, 0x66, 0x00, 0xFC, 0x01, // Ŧü (U+0166 U+00FC)
  0x01, 0x66, 0x00, 0xFD, 0x01, // Ŧý (U+0166 U+00FD)
  0x01, 0x66, 0x00, 0xFF, 0x01, // Ŧÿ (U+0166 U+00FF)
  0x01, 0x66, 0x01, 0x00, 0x01, // ŦĀ (U+0166 U+0100)
  0x01, 0x66, 0x01, 0x01, 0x01, // Ŧā (U+0166 U+0101)
  0x01, 0x66, 0x01, 0x02, 0x01, // ŦĂ (U+0166 U+0102)
  0x01, 0x66, 0x01, 0x03, 0x01, // Ŧă (U+0166 U+0103)
  0x01, 0x66, 0x01, 0x04, 0x01, // ŦĄ (U+0166 U+0104)
  0x01, 0x66, 0x01, 0x05, 0x01, // Ŧą (U+0166 U+0105)
  0x01, 0x66, 0x01, 0x07, 0x01, // Ŧć (U+0166 U+0107)
  0x01, 0x66, 0x01, 0x09, 0x01, // Ŧĉ (U+0166 U+0109)
  0x01, 0x66, 0x01, 0x0B, 0x01, // Ŧċ (U+0166 U+010B)
  0x01, 0x66, 0x01, 0x0D, 0x01, // Ŧč (U+0166 U+010D)
  0x01, 0x66, 0x01, 0x0F, 0x01, // Ŧď (U+0166 U+010F)
  0x01, 0x66, 0x01, 0x11, 0x01, // Ŧđ (U+0166 U+0111)
  0x01, 0x66, 0x01, 0x13, 0x01, // Ŧē (U+0166 U+0113)
  0x01, 0x66, 0x01, 0x15, 0x01, // Ŧĕ (U+0166 U+0115)
  0x01, 0x66, 0x01, 0x17, 0x01, // Ŧė (U+0166 U+0117)
  0x01, 0x66, 0x01, 0x19, 0x01, // Ŧę (U+0166 U+0119)
  0x01, 0x66, 0x01, 0x1B, 0x01, // Ŧě (U+0166 U+011B)
  0x01, 0x66, 0x01, 0x1D, 0x01, // Ŧĝ (U+0166 U+011D)
  0x01, 0x66, 0x01, 0x1F, 0x01, // Ŧğ (U+0166 U+011F)
  0x01, 0x66, 0x01, 0x21, 0x01, // Ŧġ (U+0166 U+0121)
  0x01, 0x66, 0x01, 0x23, 0x01, // Ŧģ (U+0166 U+0123)
  0x01, 0x66, 0x01, 0x38, 0x01, // Ŧĸ (U+0166 U+0138)
  0x01, 0x66, 0x01, 0x44, 0x01, // Ŧń (U+0166 U+0144)
  0x01, 0x66, 0x01, 0x46, 0x01, // Ŧņ (U+0166 U+0146)
  0x01, 0x66, 0x01, 0x48, 0x01, // Ŧň (U+0166 U+0148)
  0x01, 0x66, 0x01, 0x4B, 0x01, // Ŧŋ (U+0166 U+014B)
  0x01, 0x66, 0x01, 0x4D, 0x01, // Ŧō (U+0166 U+014D)
  0x01, 0x66, 0x01, 0x4F, 0x01, // Ŧŏ (U+0166 U+014F)
  0x01, 0x66, 0x01, 0x51, 0x01, // Ŧő (U+0166 U+0151)
  0x01, 0x66, 0x01, 0x53, 0x01, // Ŧœ (U+0166 U+0153)
  0x01, 0x66, 0x01, 0x55, 0x01, // Ŧŕ (U+0166 U+0155)
  0x01, 0x66, 0x01, 0x57, 0x01, // Ŧŗ (U+0166 U+0157)
  0x01, 0x66, 0x01, 0x5B, 0x01, // Ŧś (U+0166 U+015B)
  0x01, 0x66, 0x01, 0x5D, 0x01, // Ŧŝ (U+0166 U+015D)
  0x01, 0x66, 0x01, 0x5F, 0x01, // Ŧş (U+0166 U+015F)
  0x01, 0x66, 0x01, 0x61, 0x01, // Ŧš (U+0166 U+0161)
  0x01, 0x66, 0x01, 0x69, 0x01, // Ŧũ (U+0166 U+0169)
  0x01, 0x66, 0x01, 0x6B, 0x01, // Ŧū (U+0166 U+016B)
  0x01, 0x66, 0x01, 0x6D, 0x01, // Ŧŭ (U+0166 U+016D)
  0x01, 0x66, 0x01, 0x6F, 0x01, // Ŧů (U+0166 U+016F)
  0x01, 0x66, 0x01, 0x71, 0x01, // Ŧű (U+0166 U+0171)
  0x01, 0x66, 0x01, 0x73, 0x01, // Ŧų (U+0166 U+0173)
  0x01, 0x66, 0x01, 0x75, 0x01, // Ŧŵ (U+0166 U+0175)
  0x01, 0x66, 0x01, 0x77, 0x01, // Ŧŷ (U+0166 U+0177)
  0x01, 0x66, 0x01, 0x7A, 0x01, // Ŧź (U+0166 U+017A)
  0x01, 0x66, 0x01, 0x7C, 0x01, // Ŧż (U+0166 U+017C)
  0x01, 0x66, 0x01, 0x7E, 0x01, // Ŧž (U+0166 U+017E)
  0x01, 0x66, 0x20, 0x13, 0x01, // Ŧ– (U+0166 U+2013)
  0x01, 0x66, 0x20, 0x14, 0x01, // Ŧ— (U+0166 U+2014)
  0x01, 0x66, 0x20, 0x1A, 0x02, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x02, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x02, // Ŧ… (U+0166 U+2026)
  0x01, 0x66, 0x20, 0x39, 0x01, // Ŧ‹ (U+0166 U+2039)
  0x01, 0x66, 0x20, 0x3A, 0x01, // Ŧ› (U+0166 U+203A)
  0x01, 0x68, 0x00, 0x2C, 0x01, // Ũ, (U+0168 U+002C)
  0x01, 0x68, 0x00, 0x2E, 0x01, // Ũ. (U+0168 U+002E)
  0x01, 0x68, 0x20, 0x1A, 0x01, // Ũ‚ (U+0168 U+201A)
  0x01, 0x68, 0x20, 0x1E, 0x01, // Ũ„ (U+0168 U+201E)
  0x01, 0x68, 0x20, 0x26, 0x01, // Ũ… (U+0168 U+2026)
  0x01, 0x6A, 0x00, 0x2C, 0x01, // Ū, (U+016A U+002C)
  0x01, 0x6A, 0x00, 0x2E, 0x01, // Ū. (U+016A U+002E)
  0x01, 0x6A, 0x20, 0x1A, 0x01, // Ū‚ (U+016A U+201A)
  0x01, 0x6A, 0x20, 0x1E, 0x01, // Ū„ (U+016A U+201E)
  0x01, 0x6A, 0x20, 0x26, 0x01, // Ū… (U+016A U+2026)
  0x01, 0x6C, 0x00, 0x2C, 0x01, // Ŭ, (U+016C U+002C)
  0x01, 0x6C, 0x00, 0x2E, 0x01, // Ŭ. (U+016C U+002E)
  0x01, 0x6C, 0x20, 0x1A, 0x01, // Ŭ‚ (U+016C U+201A)
  0x01, 0x6C, 0x20, 0x1E, 0x01, // Ŭ„ (U+016C U+201E)
  0x01, 0x6C, 0x20, 0x26, 0x01, // Ŭ… (U+016C U+2026)
  0x01, 0x6E, 0x00, 0x2C, 0x01, // Ů, (U+016E U+002C)
  0x01, 0x6E, 0x00, 0x2E, 0x01, // Ů. (U+016E U+002E)
  0x01, 0x6E, 0x20, 0x1A, 0x01, // Ů‚ (U+016E U+201A)
  0x01, 0x6E, 0x20, 0x1E, 0x01, // Ů„ (U+016E U+201E)
  0x01, 0x6E, 0x20, 0x26, 0x01, // Ů… (U+016E U+2026)
  0x01, 0x70, 0x00, 0x2C, 0x01, // Ű, (U+0170 U+002C)
  0x01, 0x70, 0x00, 0x2E, 0x01, // Ű. (U+0170 U+002E)
  0x01, 0x70, 0x20, 0x1A, 0x01, // Ű‚ (U+0170 U+201A)
  0x01, 0x70, 0x20, 0x1E, 0x01, // Ű„ (U+0170 U+201E)
  0x01, 0x70, 0x20, 0x26, 0x01, // Ű… (U+0170 U+2026)
  0x01, 0x72, 0x00, 0x2C, 0x01, // Ų, (U+0172 U+002C)
  0x01, 0x72, 0x00, 0x2E, 0x01, // Ų. (U+0172 U+002E)
  0x01, 0x72, 0x20, 0x1A, 0x01, // Ų‚ (U+0172 U+201A)
  0x01, 0x72, 0x20, 0x1E, 0x01, // Ų„ (U+0172 U+201E)
  0x01, 0x72, 0x20, 0x26, 0x01, // Ų… (U+0172 U+2026)
  0x01, 0x74, 0x00, 0x2C, 0x01, // Ŵ, (U+0174 U+002C)
  0x01, 0x74, 0x00, 0x2E, 0x01, // Ŵ. (U+0174 U+002E)
  0x01, 0x74, 0x00, 0x61, 0x01, // Ŵa (U+0174 U+0061)
  0x01, 0x74, 0x00, 0x63, 0x01, // Ŵc (U+0174 U+0063)
  0x01, 0x74, 0x00, 0x64, 0x01, // Ŵd (U+0174 U+0064)
  0x01, 0x74, 0x00, 0x65, 0x01, // Ŵe (U+0174 U+0065)
  0x01, 0x74, 0x00, 0x6F, 0x01, // Ŵo (U+0174 U+006F)
  0x01, 0x74, 0x00, 0x71, 0x01, // Ŵq (U+0174 U+0071)
  0x01, 0x74, 0x00, 0xAB, 0x01, // Ŵ« (U+0174 U+00AB)
  0x01, 0x74, 0x00, 0xBB, 0x01, // Ŵ» (U+0174 U+00BB)
  0x01, 0x74, 0x00, 0xE0, 0x01, // Ŵà (U+0174 U+00E0)
  0x01, 0x74, 0x00, 0xE1, 0x01, // Ŵá (U+0174 U+00E1)
  0x01, 0x74, 0x00, 0xE2, 0x01, // Ŵâ (U+0174 U+00E2)
  0x01, 0x74, 0x00, 0xE3, 0x01, // Ŵã (U+0174 U+00E3)
  0x01, 0x74, 0x00, 0xE4, 0x01, // Ŵä (U+0174 U+00E4)
  0x01, 0x74, 0x00, 0xE5, 0x01, // Ŵå (U+0174 U+00E5)
  0x01, 0x74, 0x00, 0xE6, 0x01, // Ŵæ (U+0174 U+00E6)
  0x01, 0x74, 0x00, 0xE7, 0x01, // Ŵç (U+0174 U+00E7)
  0x01, 0x74, 0x00, 0xE8, 0x01, // Ŵè (U+0174 U+00E8)
  0x01, 0x74, 0x00, 0xE9, 0x01, // Ŵé (U+0174 U+00E9)
  0x01, 0x74, 0x00, 0xEA, 0x01, // Ŵê (U+0174 U+00EA)
  0x01, 0x74, 0x00, 0xEB, 0x01, // Ŵë (U+0174 U+00EB)
  0x01, 0x74, 0x00, 0xF2, 0x01, // Ŵò (U+0174 U+00F2)
  0x01, 0x74, 0x00, 0xF3, 0x01, // Ŵó (U+0174 U+00F3)
  0x01, 0x74, 0x00, 0xF4, 0x01, // Ŵô (U+0174 U+00F4)
  0x01, 0x74, 0x00, 0xF5, 0x01, // Ŵõ (U+0174 U+00F5)
  0x01, 0x74, 0x00, 0xF6, 0x01, // Ŵö (U+0174 U+00F6)
  0x01, 0x74, 0x00, 0xF8, 0x01, // Ŵø (U+0174 U+00F8)
  0x01, 0x74, 0x01, 0x01, 0x01, // Ŵā (U+0174 U+0101)
  0x01, 0x74, 0x01, 0x03, 0x01, // Ŵă (U+0174 U+0103)
  0x01, 0x74, 0x01, 0x05, 0x01, // Ŵą (U+0174 U+0105)
  0x01, 0x74, 0x01, 0x07, 0x01, // Ŵć (U+0174 U+0107)
  0x01, 0x74, 0x01, 0x09, 0x01, // Ŵĉ (U+0174 U+0109)
  0x01, 0x74, 0x01, 0x0B, 0x01, // Ŵċ (U+0174 U+010B)
  0x01, 0x74, 0x01, 0x0D, 0x01, // Ŵč (U+0174 U+010D)
  0x01, 0x74, 0x01, 0x0F, 0x01, // Ŵď (U+0174 U+010F)
  0x01, 0x74, 0x01, 0x11, 0x01, // Ŵđ (U+0174 U+0111)
  0x01, 0x74, 0x01, 0x13, 0x01, // Ŵē (U+0174 U+0113)
  0x01, 0x74, 0x01, 0x15, 0x01, // Ŵĕ (U+0174 U+0115)
  0x01, 0x74, 0x01, 0x17, 0x01, // Ŵė (U+0174 U+0117)
  0x01, 0x74, 0x01, 0x19, 0x01, // Ŵę (U+0174 U+0119)
  0x01, 0x74, 0x01, 0x1B, 0x01, // Ŵě (U+0174 U+011B)
  0x01, 0x74, 0x01, 0x4D, 0x01, // Ŵō (U+0174 U+014D)
  0x01, 0x74, 0x01, 0x4F, 0x01, // Ŵŏ (U+0174 U+014F)
  0x01, 0x74, 0x01, 0x51, 0x01, // Ŵő (U+0174 U+0151)
  0x01, 0x74, 0x01, 0x53, 0x01, // Ŵœ (U+0174 U+0153)
  0x01, 0x74, 0x20, 0x1A, 0x01, // Ŵ‚ (U+0174 U+201A)
  0x01, 0x74, 0x20, 0x1E, 0x01, // Ŵ„ (U+0174 U+201E)
  0x01, 0x74, 0x20, 0x26, 0x01, // Ŵ… (U+0174 U+2026)
  0x01, 0x74, 0x20, 0x39, 0x01, // Ŵ‹ (U+0174 U+2039)
  0x01, 0x74, 0x20, 0x3A, 0x01, // Ŵ› (U+0174 U+203A)
  0x01, 0x75, 0x00, 0x2C, 0x01, // ŵ, (U+0175 U+002C)
  0x01, 0x75, 0x00, 0x2E, 0x01, // ŵ. (U+0175 U+002E)
  0x01, 0x75, 0x20, 0x1A, 0x01, // ŵ‚ (U+0175 U+201A)
  0x01, 0x75, 0x20, 0x1E, 0x01, // ŵ„ (U+0175 U+201E)
  0x01, 0x75, 0x20, 0x26, 0x01, // ŵ… (U+0175 U+2026)
  0x01, 0x76, 0x00, 0x26, 0x01, // Ŷ& (U+0176 U+0026)
  0x01, 0x76, 0x00, 0x2C, 0x02, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x02, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x00, 0x41, 0x01, // ŶA (U+0176 U+0041)
  0x01, 0x76, 0x00, 0x61, 0x01, // Ŷa (U+0176 U+0061)
  0x01, 0x76, 0x00, 0x63, 0x01, // Ŷc (U+0176 U+0063)
  0x01, 0x76, 0x00, 0x64, 0x01, // Ŷd (U+0176 U+0064)
  0x01, 0x76, 0x00, 0x65, 0x01, // Ŷe (U+0176 U+0065)
  0x01, 0x76, 0x00, 0x67, 0x01, // Ŷg (U+0176 U+0067)
  0x01, 0x76, 0x00, 0x6D, 0x01, // Ŷm (U+0176 U+006D)
  0x01, 0x76, 0x00, 0x6E, 0x01, // Ŷn (U+0176 U+006E)
  0x01, 0x76, 0x00, 0x6F, 0x01, // Ŷo (U+0176 U+006F)
  0x01, 0x76, 0x00, 0x70, 0x01, // Ŷp (U+0176 U+0070)
  0x01, 0x76, 0x00, 0x71, 0x01, // Ŷq (U+0176 U+0071)
  0x01, 0x76, 0x00, 0x72, 0x01, // Ŷr (U+0176 U+0072)
  0x01, 0x76, 0x00, 0x73, 0x01, // Ŷs (U+0176 U+0073)
  0x01, 0x76, 0x00, 0x75, 0x01, // Ŷu (U+0176 U+0075)
  0x01, 0x76, 0x00, 0x7A, 0x01, // Ŷz (U+0176 U+007A)
  0x01, 0x76, 0x00, 0xAB, 0x01, // Ŷ« (U+0176 U+00AB)
  0x01, 0x76, 0x00, 0xBB, 0x01, // Ŷ» (U+0176 U+00BB)
  0x01, 0x76, 0x00, 0xC0, 0x01, // ŶÀ (U+0176 U+00C0)
  0x01, 0x76, 0x00, 0xC1, 0x01, // ŶÁ (U+0176 U+00C1)
  0x01, 0x76, 0x00, 0xC2, 0x01, // ŶÂ (U+0176 U+00C2)
  0x01, 0x76, 0x00, 0xC3, 0x01, // ŶÃ (U+0176 U+00C3)
  0x01, 0x76, 0x00, 0xC4, 0x01, // ŶÄ (U+0176 U+00C4)
  0x01, 0x76, 0x00, 0xC5, 0x01, // ŶÅ (U+0176 U+00C5)
  0x01, 0x76, 0x00, 0xC6, 0x01, // ŶÆ (U+0176 U+00C6)
  0x01, 0x76, 0x00, 0xE0, 0x01, // Ŷà (U+0176 U+00E0)
  0x01, 0x76, 0x00, 0xE1, 0x01, // Ŷá (U+0176 U+00E1)
  0x01, 0x76, 0x00, 0xE2, 0x01, // Ŷâ (U+0176 U+00E2)
  0x01, 0x76, 0x00, 0xE3, 0x01, // Ŷã (U+0176 U+00E3)
  0x01, 0x76, 0x00, 0xE4, 0x01, // Ŷä (U+0176 U+00E4)
  0x01, 0x76, 0x00, 0xE5, 0x01, // Ŷå (U+0176 U+00E5)
  0x01, 0x76, 0x00, 0xE6, 0x01, // Ŷæ (U+0176 U+00E6)
  0x01, 0x76, 0x00, 0xE7, 0x01, // Ŷç (U+0176 U+00E7)
  0x01, 0x76, 0x00, 0xE8, 0x01, // Ŷè (U+0176 U+00E8)
  0x01, 0x76, 0x00, 0xE9, 0x01, // Ŷé (U+0176 U+00E9)
  0x01, 0x76, 0x00, 0xEA, 0x01, // Ŷê (U+0176 U+00EA)
  0x01, 0x76, 0x00, 0xEB, 0x01, // Ŷë (U+0176 U+00EB)
  0x01, 0x76, 0x00, 0xF1, 0x01, // Ŷñ (U+0176 U+00F1)
  0x01, 0x76, 0x00, 0xF2, 0x01, // Ŷò (U+0176 U+00F2)
  0x01, 0x76, 0x00, 0xF3, 0x01, // Ŷó (U+0176 U+00F3)
  0x01, 0x76, 0x00, 0xF4, 0x01, // Ŷô (U+0176 U+00F4)
  0x01, 0x76, 0x00, 0xF5, 0x01, // Ŷõ (U+0176 U+00F5)
  0x01, 0x76, 0x00, 0xF6, 0x01, // Ŷö (U+0176 U+00F6)
  0x01, 0x76, 0x00, 0xF8, 0x01, // Ŷø (U+0176 U+00F8)
  0x01, 0x76, 0x00, 0xF9, 0x01, // Ŷù (U+0176 U+00F9)
  0x01, 0x76, 0x00, 0xFA, 0x01, // Ŷú (U+0176 U+00FA)
  0x01, 0x76, 0x00, 0xFB, 0x01, // Ŷû (U+0176 U+00FB)
  0x01, 0x76, 0x00, 0xFC, 0x01, // Ŷü (U+0176 U+00FC)
  0x01, 0x76, 0x01, 0x00, 0x01, // ŶĀ (U+0176 U+0100)
  0x01, 0x76, 0x01, 0x01, 0x01, // Ŷā (U+0176 U+0101)
  0x01, 0x76, 0x01, 0x02, 0x01, // ŶĂ (U+0176 U+0102)
  0x01, 0x76, 0x01, 0x03, 0x01, // Ŷă (U+0176 U+0103)
  0x01, 0x76, 0x01, 0x04, 0x01, // ŶĄ (U+0176 U+0104)
  0x01, 0x76, 0x01, 0x05, 0x01, // Ŷą (U+0176 U+0105)
  0x01, 0x76, 0x01, 0x07, 0x01, // Ŷć (U+0176 U+0107)
  0x01, 0x76, 0x01, 0x09, 0x01, // Ŷĉ (U+0176 U+0109)
  0x01, 0x76, 0x01, 0x0B, 0x01, // Ŷċ (U+0176 U+010B)
  0x01, 0x76, 0x01, 0x0D, 0x01, // Ŷč (U+0176 U+010D)
  0x01, 0x76, 0x01, 0x0F, 0x01, // Ŷď (U+0176 U+010F)
  0x01, 0x76, 0x01, 0x11, 0x01, // Ŷđ (U+0176 U+0111)
  0x01, 0x76, 0x01, 0x13, 0x01, // Ŷē (U+0176 U+0113)
  0x01, 0x76, 0x01, 0x15, 0x01, // Ŷĕ (U+0176 U+0115)
  0x01, 0x76, 0x01, 0x17, 0x01, // Ŷė (U+0176 U+0117)
  0x01, 0x76, 0x01, 0x19, 0x01, // Ŷę (U+0176 U+0119)
  0x01, 0x76, 0x01, 0x1B, 0x01, // Ŷě (U+0176 U+011B)
  0x01, 0x76, 0x01, 0x1D, 0x01, // Ŷĝ (U+0176 U+011D)
  0x01, 0x76, 0x01, 0x1F, 0x01, // Ŷğ (U+0176 U+011F)
  0x01, 0x76, 0x01, 0x21, 0x01, // Ŷġ (U+0176 U+0121)
  0x01, 0x76, 0x01, 0x23, 0x01, // Ŷģ (U+0176 U+0123)
  0x01, 0x76, 0x01, 0x38, 0x01, // Ŷĸ (U+0176 U+0138)
  0x01, 0x76, 0x01, 0x44, 0x01, // Ŷń (U+0176 U+0144)
  0x01, 0x76, 0x01, 0x46, 0x01, // Ŷņ (U+0176 U+0146)
  0x01, 0x76, 0x01, 0x48, 0x01, // Ŷň (U+0176 U+0148)
  0x01, 0x76, 0x01, 0x4B, 0x01, // Ŷŋ (U+0176 U+014B)
  0x01, 0x76, 0x01, 0x4D, 0x01, // Ŷō (U+0176 U+014D)
  0x01, 0x76, 0x01, 0x4F, 0x01, // Ŷŏ (U+0176 U+014F)
  0x01, 0x76, 0x01, 0x51, 0x01, // Ŷő (U+0176 U+0151)
  0x01, 0x76, 0x01, 0x53, 0x01, // Ŷœ (U+0176 U+0153)
  0x01, 0x76, 0x01, 0x55, 0x01, // Ŷŕ (U+0176 U+0155)
  0x01, 0x76, 0x01, 0x57, 0x01, // Ŷŗ (U+0176 U+0157)
  0x01, 0x76, 0x01, 0x5B, 0x01, // Ŷś (U+0176 U+015B)
  0x01, 0x76, 0x01, 0x5D, 0x01, // Ŷŝ (U+0176 U+015D)
  0x01, 0x76, 0x01, 0x5F, 0x01, // Ŷş (U+0176 U+015F)
  0x01, 0x76, 0x01, 0x61, 0x01, // Ŷš (U+0176 U+0161)
  0x01, 0x76, 0x01, 0x69, 0x01, // Ŷũ (U+0176 U+0169)
  0x01, 0x76, 0x01, 0x6B, 0x01, // Ŷū (U+0176 U+016B)
  0x01, 0x76, 0x01, 0x6D, 0x01, // Ŷŭ (U+0176 U+016D)
  0x01, 0x76, 0x01, 0x6F, 0x01, // Ŷů (U+0176 U+016F)
  0x01, 0x76, 0x01, 0x71, 0x01, // Ŷű (U+0176 U+0171)
  0x01, 0x76, 0x01, 0x73, 0x01, // Ŷų (U+0176 U+0173)
  0x01, 0x76, 0x01, 0x7A, 0x01, // Ŷź (U+0176 U+017A)
  0x01, 0x76, 0x01, 0x7C, 0x01, // Ŷż (U+0176 U+017C)
  0x01, 0x76, 0x01, 0x7E, 0x01, // Ŷž (U+0176 U+017E)
  0x01, 0x76, 0x20, 0x1A, 0x02, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x02, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x02, // Ŷ… (U+0176 U+2026)
  0x01, 0x76, 0x20, 0x39, 0x01, // Ŷ‹ (U+0176 U+2039)
  0x01, 0x76, 0x20, 0x3A, 0x01, // Ŷ› (U+0176 U+203A)
  0x01, 0x77, 0x00, 0x2C, 0x01, // ŷ, (U+0177 U+002C)
  0x01, 0x77, 0x00, 0x2E, 0x01, // ŷ. (U+0177 U+002E)
  0x01, 0x77, 0x20, 0x1A, 0x01, // ŷ‚ (U+0177 U+201A)
  0x01, 0x77, 0x20, 0x1E, 0x01, // ŷ„ (U+0177 U+201E)
  0x01, 0x77, 0x20, 0x26, 0x01, // ŷ… (U+0177 U+2026)
  0x01, 0x78, 0x00, 0x26, 0x01, // Ÿ& (U+0178 U+0026)
  0x01, 0x78, 0x00, 0x2C, 0x02, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x02, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x00, 0x41, 0x01, // ŸA (U+0178 U+0041)
  0x01, 0x78, 0x00, 0x61, 0x01, // Ÿa (U+0178 U+0061)
  0x01, 0x78, 0x00, 0x63, 0x01, // Ÿc (U+0178 U+0063)
  0x01, 0x78, 0x00, 0x64, 0x01, // Ÿd (U+0178 U+0064)
  0x01, 0x78, 0x00, 0x65, 0x01, // Ÿe (U+0178 U+0065)
  0x01, 0x78, 0x00, 0x67, 0x01, // Ÿg (U+0178 U+0067)
  0x01, 0x78, 0x00, 0x6D, 0x01, // Ÿm (U+0178 U+006D)
  0x01, 0x78, 0x00, 0x6E, 0x01, // Ÿn (U+0178 U+006E)
  0x01, 0x78, 0x00, 0x6F, 0x01, // Ÿo (U+0178 U+006F)
  0x01, 0x78, 0x00, 0x70, 0x01, // Ÿp (U+0178 U+0070)
  0x01, 0x78, 0x00, 0x71, 0x01, // Ÿq (U+0178 U+0071)
  0x01, 0x78, 0x00, 0x72, 0x01, // Ÿr (U+0178 U+0072)
  0x01, 0x78, 0x00, 0x73, 0x01, // Ÿs (U+0178 U+0073)
  0x01, 0x78, 0x00, 0x75, 0x01, // Ÿu (U+0178 U+0075)
  0x01, 0x78, 0x00, 0x7A, 0x01, // Ÿz (U+0178 U+007A)
  0x01, 0x78, 0x00, 0xAB, 0x01, // Ÿ« (U+0178 U+00AB)
  0x01, 0x78, 0x00, 0xBB, 0x01, // Ÿ» (U+0178 U+00BB)
  0x01, 0x78, 0x00, 0xC0, 0x01, // ŸÀ (U+0178 U+00C0)
  0x01, 0x78, 0x00, 0xC1, 0x01, // ŸÁ (U+0178 U+00C1)
  0x01, 0x78, 0x00, 0xC2, 0x01, // ŸÂ (U+0178 U+00C2)
  0x01, 0x78, 0x00, 0xC3, 0x01, // ŸÃ (U+0178 U+00C3)
  0x01, 0x78, 0x00, 0xC4, 0x01, // ŸÄ (U+0178 U+00C4)
  0x01, 0x78, 0x00, 0xC5, 0x01, // ŸÅ (U+0178 U+00C5)
  0x01, 0x78, 0x00, 0xC6, 0x01, // ŸÆ (U+0178 U+00C6)
  0x01, 0x78, 0x00, 0xE0, 0x01, // Ÿà (U+0178 U+00E0)
  0x01, 0x78, 0x00, 0xE1, 0x01, // Ÿá (U+0178 U+00E1)
  0x01, 0x78, 0x00, 0xE2, 0x01, // Ÿâ (U+0178 U+00E2)
  0x01, 0x78, 0x00, 0xE3, 0x01, // Ÿã (U+0178 U+00E3)
  0x01, 0x78, 0x00, 0xE4, 0x01, // Ÿä (U+0178 U+00E4)
  0x01, 0x78, 0x00, 0xE5, 0x01, // Ÿå (U+0178 U+00E5)
  0x01, 0x78, 0x00, 0xE6, 0x01, // Ÿæ (U+0178 U+00E6)
  0x01, 0x78, 0x00, 0xE7, 0x01, // Ÿç (U+0178 U+00E7)
  0x01, 0x78, 0x00, 0xE8, 0x01, // Ÿè (U+0178 U+00E8)
  0x01, 0x78, 0x00, 0xE9, 0x01, // Ÿé (U+0178 U+00E9)
  0x01, 0x78, 0x00, 0xEA, 0x01, // Ÿê (U+0178 U+00EA)
  0x01, 0x78, 0x00, 0xEB, 0x01, // Ÿë (U+0178 U+00EB)
  0x01, 0x78, 0x00, 0xF1, 0x01, // Ÿñ (U+0178 U+00F1)
  0x01, 0x78, 0x00, 0xF2, 0x01, // Ÿò (U+0178 U+00F2)
  0x01, 0x78, 0x00, 0xF3, 0x01, // Ÿó (U+0178 U+00F3)
  0x01, 0x78, 0x00, 0xF4, 0x01, // Ÿô (U+0178 U+00F4)
  0x01, 0x78, 0x00, 0xF5, 0x01, // Ÿõ (U+0178 U+00F5)
  0x01, 0x78, 0x00, 0xF6, 0x01, // Ÿö (U+0178 U+00F6)
  0x01, 0x78, 0x00, 0xF8, 0x01, // Ÿø (U+0178 U+00F8)
  0x01, 0x78, 0x00, 0xF9, 0x01, // Ÿù (U+0178 U+00F9)
  0x01, 0x78, 0x00, 0xFA, 0x01, // Ÿú (U+0178 U+00FA)
  0x01, 0x78, 0x00, 0xFB, 0x01, // Ÿû (U+0178 U+00FB)
  0x01, 0x78, 0x00, 0xFC, 0x01, // Ÿü (U+0178 U+00FC)
  0x01, 0x78, 0x01, 0x00, 0x01, // ŸĀ (U+0178 U+0100)
  0x01, 0x78, 0x01, 0x01, 0x01, // Ÿā (U+0178 U+0101)
  0x01, 0x78, 0x01, 0x02, 0x01, // ŸĂ (U+0178 U+0102)
  0x01, 0x78, 0x01, 0x03, 0x01, // Ÿă (U+0178 U+0103)
  0x01, 0x78, 0x01, 0x04, 0x01, // ŸĄ (U+0178 U+0104)
  0x01, 0x78, 0x01, 0x05, 0x01, // Ÿą (U+0178 U+0105)
  0x01, 0x78, 0x01, 0x07, 0x01, // Ÿć (U+0178 U+0107)
  0x01, 0x78, 0x01, 0x09, 0x01, // Ÿĉ (U+0178 U+0109)
  0x01, 0x78, 0x01, 0x0B, 0x01, // Ÿċ (U+0178 U+010B)
  0x01, 0x78, 0x01, 0x0D, 0x01, // Ÿč (U+0178 U+010D)
  0x01, 0x78, 0x01, 0x0F, 0x01, // Ÿď (U+0178 U+010F)
  0x01, 0x78, 0x01, 0x11, 0x01, // Ÿđ (U+0178 U+0111)
  0x01, 0x78, 0x01, 0x13, 0x01, // Ÿē (U+0178 U+0113)
  0x01, 0x78, 0x01, 0x15, 0x01, // Ÿĕ (U+0178 U+0115)
  0x01, 0x78, 0x01, 0x17, 0x01, // Ÿė (U+0178 U+0117)
  0x01, 0x78, 0x01, 0x19, 0x01, // Ÿę (U+0178 U+0119)
  0x01, 0x78, 0x01, 0x1B, 0x01, // Ÿě (U+0178 U+011B)
  0x01, 0x78, 0x01, 0x1D, 0x01, // Ÿĝ (U+0178 U+011D)
  0x01, 0x78, 0x01, 0x1F, 0x01, // Ÿğ (U+0178 U+011F)
  0x01, 0x78, 0x01, 0x21, 0x01, // Ÿġ (U+0178 U+0121)
  0x01, 0x78, 0x01, 0x23, 0x01, // Ÿģ (U+0178 U+0123)
  0x01, 0x78, 0x01, 0x38, 0x01, // Ÿĸ (U+0178 U+0138)
  0x01, 0x78, 0x01, 0x44, 0x01, // Ÿń (U+0178 U+0144)
  0x01, 0x78, 0x01, 0x46, 0x01, // Ÿņ (U+0178 U+0146)
  0x01, 0x78, 0x01, 0x48, 0x01, // Ÿň (U+0178 U+0148)
  0x01, 0x78, 0x01, 0x4B, 0x01, // Ÿŋ (U+0178 U+014B)
  0x01, 0x78, 0x01, 0x4D, 0x01, // Ÿō (U+0178 U+014D)
  0x01, 0x78, 0x01, 0x4F, 0x01, // Ÿŏ (U+0178 U+014F)
  0x01, 0x78, 0x01, 0x51, 0x01, // Ÿő (U+0178 U+0151)
  0x01, 0x78, 0x01, 0x53, 0x01, // Ÿœ (U+0178 U+0153)
  0x01, 0x78, 0x01, 0x55, 0x01, // Ÿŕ (U+0178 U+0155)
  0x01, 0x78, 0x01, 0x57, 0x01, // Ÿŗ (U+0178 U+0157)
  0x01, 0x78, 0x01, 0x5B, 0x01, // Ÿś (U+0178 U+015B)
  0x01, 0x78, 0x01, 0x5D, 0x01, // Ÿŝ (U+0178 U+015D)
  0x01, 0x78, 0x01, 0x5F, 0x01, // Ÿş (U+0178 U+015F)
  0x01, 0x78, 0x01, 0x61, 0x01, // Ÿš (U+0178 U+0161)
  0x01, 0x78, 0x01, 0x69, 0x01, // Ÿũ (U+0178 U+0169)
  0x01, 0x78, 0x01, 0x6B, 0x01, // Ÿū (U+0178 U+016B)
  0x01, 0x78, 0x01, 0x6D, 0x01, // Ÿŭ (U+0178 U+016D)
  0x01, 0x78, 0x01, 0x6F, 0x01, // Ÿů (U+0178 U+016F)
  0x01, 0x78, 0x01, 0x71, 0x01, // Ÿű (U+0178 U+0171)
  0x01, 0x78, 0x01, 0x73, 0x01, // Ÿų (U+0178 U+0173)
  0x01, 0x78, 0x01, 0x7A, 0x01, // Ÿź (U+0178 U+017A)
  0x01, 0x78, 0x01, 0x7C, 0x01, // Ÿż (U+0178 U+017C)
  0x01, 0x78, 0x01, 0x7E, 0x01, // Ÿž (U+0178 U+017E)
  0x01, 0x78, 0x20, 0x1A, 0x02, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x02, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x02, // Ÿ… (U+0178 U+2026)
  0x01, 0x78, 0x20, 0x39, 0x01, // Ÿ‹ (U+0178 U+2039)
  0x01, 0x78, 0x20, 0x3A, 0x01, // Ÿ› (U+0178 U+203A)
  0x01, 0x79, 0x00, 0x26, 0x01, // Ź& (U+0179 U+0026)
  0x01, 0x7B, 0x00, 0x26, 0x01, // Ż& (U+017B U+0026)
  0x01, 0x7D, 0x00, 0x26, 0x01, // Ž& (U+017D U+0026)
  0x20, 0x13, 0x00, 0x54, 0x01, // –T (U+2013 U+0054)
  0x20, 0x13, 0x01, 0x62, 0x01, // –Ţ (U+2013 U+0162)
  0x20, 0x13, 0x01, 0x64, 0x01, // –Ť (U+2013 U+0164)
  0x20, 0x13, 0x01, 0x66, 0x01, // –Ŧ (U+2013 U+0166)
  0x20, 0x14, 0x00, 0x54, 0x01, // —T (U+2014 U+0054)
  0x20, 0x14, 0x01, 0x62, 0x01, // —Ţ (U+2014 U+0162)
  0x20, 0x14, 0x01, 0x64, 0x01, // —Ť (U+2014 U+0164)
  0x20, 0x14, 0x01, 0x66, 0x01, // —Ŧ (U+2014 U+0166)
  0x20, 0x18, 0x00, 0x41, 0x02, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0x61, 0x01, // ‘a (U+2018 U+0061)
  0x20, 0x18, 0x00, 0x63, 0x02, // ‘c (U+2018 U+0063)
  0x20, 0x18, 0x00, 0x64, 0x02, // ‘d (U+2018 U+0064)
  0x20, 0x18, 0x00, 0x65, 0x02, // ‘e (U+2018 U+0065)
  0x20, 0x18, 0x00, 0x67, 0x01, // ‘g (U+2018 U+0067)
  0x20, 0x18, 0x00, 0x6D, 0x01, // ‘m (U+2018 U+006D)
  0x20, 0x18, 0x00, 0x6E, 0x01, // ‘n (U+2018 U+006E)
  0x20, 0x18, 0x00, 0x6F, 0x02, // ‘o (U+2018 U+006F)
  0x20, 0x18, 0x00, 0x70, 0x01, // ‘p (U+2018 U+0070)
  0x20, 0x18, 0x00, 0x71, 0x02, // ‘q (U+2018 U+0071)
  0x20, 0x18, 0x00, 0x72, 0x01, // ‘r (U+2018 U+0072)
  0x20, 0x18, 0x00, 0x73, 0x01, // ‘s (U+2018 U+0073)
  0x20, 0x18, 0x00, 0x75, 0x01, // ‘u (U+2018 U+0075)
  0x20, 0x18, 0x00, 0xC0, 0x02, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x02, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x02, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x02, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x02, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x02, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xE0, 0x02, // ‘à (U+2018 U+00E0)
  0x20, 0x18, 0x00, 0xE1, 0x01, // ‘á (U+2018 U+00E1)
  0x20, 0x18, 0x00, 0xE2, 0x01, // ‘â (U+2018 U+00E2)
  0x20, 0x18, 0x00, 0xE3, 0x01, // ‘ã (U+2018 U+00E3)
  0x20, 0x18, 0x00, 0xE4, 0x01, // ‘ä (U+2018 U+00E4)
  0x20, 0x18, 0x00, 0xE5, 0x01, // ‘å (U+2018 U+00E5)
  0x20, 0x18, 0x00, 0xE6, 0x01, // ‘æ (U+2018 U+00E6)
  0x20, 0x18, 0x00, 0xE7, 0x02, // ‘ç (U+2018 U+00E7)
  0x20, 0x18, 0x00, 0xE8, 0x02, // ‘è (U+2018 U+00E8)
  0x20, 0x18, 0x00, 0xE9, 0x02, // ‘é (U+2018 U+00E9)
  0x20, 0x18, 0x00, 0xEA, 0x02, // ‘ê (U+2018 U+00EA)
  0x20, 0x18, 0x00, 0xEB, 0x02, // ‘ë (U+2018 U+00EB)
  0x20, 0x18, 0x00, 0xF1, 0x01, // ‘ñ (U+2018 U+00F1)
  0x20, 0x18, 0x00, 0xF2, 0x02, // ‘ò (U+2018 U+00F2)
  0x20, 0x18, 0x00, 0xF3, 0x02, // ‘ó (U+2018 U+00F3)
  0x20, 0x18, 0x00, 0xF4, 0x02, // ‘ô (U+2018 U+00F4)
  0x20, 0x18, 0x00, 0xF5, 0x02, // ‘õ (U+2018 U+00F5)
  0x20, 0x18, 0x00, 0xF6, 0x02, // ‘ö (U+2018 U+00F6)
  0x20, 0x18, 0x00, 0xF8, 0x02, // ‘ø (U+2018 U+00F8)
  0x20, 0x18, 0x00, 0xF9, 0x01, // ‘ù (U+2018 U+00F9)
  0x20, 0x18, 0x00, 0xFA, 0x01, // ‘ú (U+2018 U+00FA)
  0x20, 0x18, 0x00, 0xFB, 0x01, // ‘û (U+2018 U+00FB)
  0x20, 0x18, 0x00, 0xFC, 0x01, // ‘ü (U+2018 U+00FC)
  0x20, 0x18, 0x01, 0x00, 0x02, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x01, 0x01, // ‘ā (U+2018 U+0101)
  0x20, 0x18, 0x01, 0x02, 0x02, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x03, 0x01, // ‘ă (U+2018 U+0103)
  0x20, 0x18, 0x01, 0x04, 0x02, // ‘Ą (U+2018 U+0104)
  0x20, 0x18, 0x01, 0x05, 0x01, // ‘ą (U+2018 U+0105)
  0x20, 0x18, 0x01, 0x07, 0x02, // ‘ć (U+2018 U+0107)
  0x20, 0x18, 0x01, 0x09, 0x02, // ‘ĉ (U+2018 U+0109)
  0x20, 0x18, 0x01, 0x0B, 0x02, // ‘ċ (U+2018 U+010B)
  0x20, 0x18, 0x01, 0x0D, 0x02, // ‘č (U+2018 U+010D)
  0x20, 0x18, 0x01, 0x0F, 0x02, // ‘ď (U+2018 U+010F)
  0x20, 0x18, 0x01, 0x11, 0x02, // ‘đ (U+2018 U+0111)
  0x20, 0x18, 0x01, 0x13, 0x02, // ‘ē (U+2018 U+0113)
  0x20, 0x18, 0x01, 0x15, 0x02, // ‘ĕ (U+2018 U+0115)
  0x20, 0x18, 0x01, 0x17, 0x02, // ‘ė (U+2018 U+0117)
  0x20, 0x18, 0x01, 0x19, 0x02, // ‘ę (U+2018 U+0119)
  0x20, 0x18, 0x01, 0x1B, 0x02, // ‘ě (U+2018 U+011B)
  0x20, 0x18, 0x01, 0x1D, 0x01, // ‘ĝ (U+2018 U+011D)
  0x20, 0x18, 0x01, 0x1F, 0x01, // ‘ğ (U+2018 U+011F)
  0x20, 0x18, 0x01, 0x21, 0x01, // ‘ġ (U+2018 U+0121)
  0x20, 0x18, 0x01, 0x23, 0x01, // ‘ģ (U+2018 U+0123)
  0x20, 0x18, 0x01, 0x38, 0x01, // ‘ĸ (U+2018 U+0138)
  0x20, 0x18, 0x01, 0x44, 0x01, // ‘ń (U+2018 U+0144)
  0x20, 0x18, 0x01, 0x46, 0x01, // ‘ņ (U+2018 U+0146)
  0x20, 0x18, 0x01, 0x48, 0x01, // ‘ň (U+2018 U+0148)
  0x20, 0x18, 0x01, 0x4B, 0x01, // ‘ŋ (U+2018 U+014B)
  0x20, 0x18, 0x01, 0x4D, 0x02, // ‘ō (U+2018 U+014D)
  0x20, 0x18, 0x01, 0x4F, 0x02, // ‘ŏ (U+2018 U+014F)
  0x20, 0x18, 0x01, 0x51, 0x02, // ‘ő (U+2018 U+0151)
  0x20, 0x18, 0x01, 0x53, 0x02, // ‘œ (U+2018 U+0153)
  0x20, 0x18, 0x01, 0x55, 0x01, // ‘ŕ (U+2018 U+0155)
  0x20, 0x18, 0x01, 0x57, 0x01, // ‘ŗ (U+2018 U+0157)
  0x20, 0x18, 0x01, 0x5B, 0x01, // ‘ś (U+2018 U+015B)
  0x20, 0x18, 0x01, 0x5D, 0x01, // ‘ŝ (U+2018 U+015D)
  0x20, 0x18, 0x01, 0x5F, 0x01, // ‘ş (U+2018 U+015F)
  0x20, 0x18, 0x01, 0x61, 0x01, // ‘š (U+2018 U+0161)
  0x20, 0x18, 0x01, 0x69, 0x01, // ‘ũ (U+2018 U+0169)
  0x20, 0x18, 0x01, 0x6B, 0x01, // ‘ū (U+2018 U+016B)
  0x20, 0x18, 0x01, 0x6D, 0x01, // ‘ŭ (U+2018 U+016D)
  0x20, 0x18, 0x01, 0x6F, 0x01, // ‘ů (U+2018 U+016F)
  0x20, 0x18, 0x01, 0x71, 0x01, // ‘ű (U+2018 U+0171)
  0x20, 0x18, 0x01, 0x73, 0x01, // ‘ų (U+2018 U+0173)
  0x20, 0x19, 0x00, 0x41, 0x02, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0x61, 0x01, // ’a (U+2019 U+0061)
  0x20, 0x19, 0x00, 0x63, 0x02, // ’c (U+2019 U+0063)
  0x20, 0x19, 0x00, 0x64, 0x02, // ’d (U+2019 U+0064)
  0x20, 0x19, 0x00, 0x65, 0x02, // ’e (U+2019 U+0065)
  0x20, 0x19, 0x00, 0x67, 0x01, // ’g (U+2019 U+0067)
  0x20, 0x19, 0x00, 0x6D, 0x01, // ’m (U+2019 U+006D)
  0x20, 0x19, 0x00, 0x6E, 0x01, // ’n (U+2019 U+006E)
  0x20, 0x19, 0x00, 0x6F, 0x02, // ’o (U+2019 U+006F)
  0x20, 0x19, 0x00, 0x70, 0x01, // ’p (U+2019 U+0070)
  0x20, 0x19, 0x00, 0x71, 0x02, // ’q (U+2019 U+0071)
  0x20, 0x19, 0x00, 0x72, 0x01, // ’r (U+2019 U+0072)
  0x20, 0x19, 0x00, 0x73, 0x01, // ’s (U+2019 U+0073)
  0x20, 0x19, 0x00, 0x75, 0x01, // ’u (U+2019 U+0075)
  0x20, 0x19, 0x00, 0xC0, 0x02, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x02, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x02, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x02, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x02, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x02, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xE0, 0x02, // ’à (U+2019 U+00E0)
  0x20, 0x19, 0x00, 0xE1, 0x01, // ’á (U+2019 U+00E1)
  0x20, 0x19, 0x00, 0xE2, 0x01, // ’â (U+2019 U+00E2)
  0x20, 0x19, 0x00, 0xE3, 0x01, // ’ã (U+2019 U+00E3)
  0x20, 0x19, 0x00, 0xE4, 0x01, // ’ä (U+2019 U+00E4)
  0x20, 0x19, 0x00, 0xE5, 0x01, // ’å (U+2019 U+00E5)
  0x20, 0x19, 0x00, 0xE6, 0x01, // ’æ (U+2019 U+00E6)
  0x20, 0x19, 0x00, 0xE7, 0x02, // ’ç (U+2019 U+00E7)
  0x20, 0x19, 0x00, 0xE8, 0x02, // ’è (U+2019 U+00E8)
  0x20, 0x19, 0x00, 0xE9, 0x02, // ’é (U+2019 U+00E9)
  0x20, 0x19, 0x00, 0xEA, 0x02, // ’ê (U+2019 U+00EA)
  0x20, 0x19, 0x00, 0xEB, 0x02, // ’ë (U+2019 U+00EB)
  0x20, 0x19, 0x00, 0xF1, 0x01, // ’ñ (U+2019 U+00F1)
  0x20, 0x19, 0x00, 0xF2, 0x02, // ’ò (U+2019 U+00F2)
  0x20, 0x19, 0x00, 0xF3, 0x02, // ’ó (U+2019 U+00F3)
  0x20, 0x19, 0x00, 0xF4, 0x02, // ’ô (U+2019 U+00F4)
  0x20, 0x19, 0x00, 0xF5, 0x02, // ’õ (U+2019 U+00F5)
  0x20, 0x19, 0x00, 0xF6, 0x02, // ’ö (U+2019 U+00F6)
  0x20, 0x19, 0x00, 0xF8, 0x02, // ’ø (U+2019 U+00F8)
  0x20, 0x19, 0x00, 0xF9, 0x01, // ’ù (U+2019 U+00F9)
  0x20, 0x19, 0x00, 0xFA, 0x01, // ’ú (U+2019 U+00FA)
  0x20, 0x19, 0x00, 0xFB, 0x01, // ’û (U+2019 U+00FB)
  0x20, 0x19, 0x00, 0xFC, 0x01, // ’ü (U+2019 U+00FC)
  0x20, 0x19, 0x01, 0x00, 0x02, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x01, 0x01, // ’ā (U+2019 U+0101)
  0x20, 0x19, 0x01, 0x02, 0x02, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x03, 0x01, // ’ă (U+2019 U+0103)
  0x20, 0x19, 0x01, 0x04, 0x02, // ’Ą (U+2019 U+0104)
  0x20, 0x19, 0x01, 0x05, 0x01, // ’ą (U+2019 U+0105)
  0x20, 0x19, 0x01, 0x07, 0x02, // ’ć (U+2019 U+0107)
  0x20, 0x19, 0x01, 0x09, 0x02, // ’ĉ (U+2019 U+0109)
  0x20, 0x19, 0x01, 0x0B, 0x02, // ’ċ (U+2019 U+010B)
  0x20, 0x19, 0x01, 0x0D, 0x02, // ’č (U+2019 U+010D)
  0x20, 0x19, 0x01, 0x0F, 0x02, // ’ď (U+2019 U+010F)
  0x20, 0x19, 0x01, 0x11, 0x02, // ’đ (U+2019 U+0111)
  0x20, 0x19, 0x01, 0x13, 0x02, // ’ē (U+2019 U+0113)
  0x20, 0x19, 0x01, 0x15, 0x02, // ’ĕ (U+2019 U+0115)
  0x20, 0x19, 0x01, 0x17, 0x02, // ’ė (U+2019 U+0117)
  0x20, 0x19, 0x01, 0x19, 0x02, // ’ę (U+2019 U+0119)
  0x20, 0x19, 0x01, 0x1B, 0x02, // ’ě (U+2019 U+011B)
  0x20, 0x19, 0x01, 0x1D, 0x01, // ’ĝ (U+2019 U+011D)
  0x20, 0x19, 0x01, 0x1F, 0x01, // ’ğ (U+2019 U+011F)
  0x20, 0x19, 0x01, 0x21, 0x01, // ’ġ (U+2019 U+0121)
  0x20, 0x19, 0x01, 0x23, 0x01, // ’ģ (U+2019 U+0123)
  0x20, 0x19, 0x01, 0x38, 0x01, // ’ĸ (U+2019 U+0138)
  0x20, 0x19, 0x01, 0x44, 0x01, // ’ń (U+2019 U+0144)
  0x20, 0x19, 0x01, 0x46, 0x01, // ’ņ (U+2019 U+0146)
  0x20, 0x19, 0x01, 0x48, 0x01, // ’ň (U+2019 U+0148)
  0x20, 0x19, 0x01, 0x4B, 0x01, // ’ŋ (U+2019 U+014B)
  0x20, 0x19, 0x01, 0x4D, 0x02, // ’ō (U+2019 U+014D)
  0x20, 0x19, 0x01, 0x4F, 0x02, // ’ŏ (U+2019 U+014F)
  0x20, 0x19, 0x01, 0x51, 0x02, // ’ő (U+2019 U+0151)
  0x20, 0x19, 0x01, 0x53, 0x02, // ’œ (U+2019 U+0153)
  0x20, 0x19, 0x01, 0x55, 0x01, // ’ŕ (U+2019 U+0155)
  0x20, 0x19, 0x01, 0x57, 0x01, // ’ŗ (U+2019 U+0157)
  0x20, 0x19, 0x01, 0x5B, 0x01, // ’ś (U+2019 U+015B)
  0x20, 0x19, 0x01, 0x5D, 0x01, // ’ŝ (U+2019 U+015D)
  0x20, 0x19, 0x01, 0x5F, 0x01, // ’ş (U+2019 U+015F)
  0x20, 0x19, 0x01, 0x61, 0x01, // ’š (U+2019 U+0161)
  0x20, 0x19, 0x01, 0x69, 0x01, // ’ũ (U+2019 U+0169)
  0x20, 0x19, 0x01, 0x6B, 0x01, // ’ū (U+2019 U+016B)
  0x20, 0x19, 0x01, 0x6D, 0x01, // ’ŭ (U+2019 U+016D)
  0x20, 0x19, 0x01, 0x6F, 0x01, // ’ů (U+2019 U+016F)
  0x20, 0x19, 0x01, 0x71, 0x01, // ’ű (U+2019 U+0171)
  0x20, 0x19, 0x01, 0x73, 0x01, // ’ų (U+2019 U+0173)
  0x20, 0x1A, 0x00, 0x43, 0x01, // ‚C (U+201A U+0043)
  0x20, 0x1A, 0x00, 0x47, 0x01, // ‚G (U+201A U+0047)
  0x20, 0x1A, 0x00, 0x4F, 0x01, // ‚O (U+201A U+004F)
  0x20, 0x1A, 0x00, 0x51, 0x01, // ‚Q (U+201A U+0051)
  0x20, 0x1A, 0x00, 0x54, 0x02, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x56, 0x01, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x01, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x01, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0xC7, 0x01, // ‚Ç (U+201A U+00C7)
  0x20, 0x1A, 0x00, 0xD2, 0x01, // ‚Ò (U+201A U+00D2)
  0x20, 0x1A, 0x00, 0xD3, 0x01, // ‚Ó (U+201A U+00D3)
  0x20, 0x1A, 0x00, 0xD4, 0x01, // ‚Ô (U+201A U+00D4)
  0x20, 0x1A, 0x00, 0xD5, 0x01, // ‚Õ (U+201A U+00D5)
  0x20, 0x1A, 0x00, 0xD6, 0x01, // ‚Ö (U+201A U+00D6)
  0x20, 0x1A, 0x00, 0xD8, 0x01, // ‚Ø (U+201A U+00D8)
  0x20, 0x1A, 0x00, 0xDD, 0x01, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x01, 0x06, 0x01, // ‚Ć (U+201A U+0106)
  0x20, 0x1A, 0x01, 0x08, 0x01, // ‚Ĉ (U+201A U+0108)
  0x20, 0x1A, 0x01, 0x0A, 0x01, // ‚Ċ (U+201A U+010A)
  0x20, 0x1A, 0x01, 0x0C, 0x01, // ‚Č (U+201A U+010C)
  0x20, 0x1A, 0x01, 0x1C, 0x01, // ‚Ĝ (U+201A U+011C)
  0x20, 0x1A, 0x01, 0x1E, 0x01, // ‚Ğ (U+201A U+011E)
  0x20, 0x1A, 0x01, 0x20, 0x01, // ‚Ġ (U+201A U+0120)
  0x20, 0x1A, 0x01, 0x22, 0x01, // ‚Ģ (U+201A U+0122)
  0x20, 0x1A, 0x01, 0x4C, 0x01, // ‚Ō (U+201A U+014C)
  0x20, 0x1A, 0x01, 0x4E, 0x01, // ‚Ŏ (U+201A U+014E)
  0x20, 0x1A, 0x01, 0x50, 0x01, // ‚Ő (U+201A U+0150)
  0x20, 0x1A, 0x01, 0x52, 0x01, // ‚Œ (U+201A U+0152)
  0x20, 0x1A, 0x01, 0x62, 0x02, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x02, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x02, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1A, 0x01, 0x74, 0x01, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x76, 0x01, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x78, 0x01, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x02, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0x61, 0x01, // “a (U+201C U+0061)
  0x20, 0x1C, 0x00, 0x63, 0x02, // “c (U+201C U+0063)
  0x20, 0x1C, 0x00, 0x64, 0x02, // “d (U+201C U+0064)
  0x20, 0x1C, 0x00, 0x65, 0x02, // “e (U+201C U+0065)
  0x20, 0x1C, 0x00, 0x67, 0x01, // “g (U+201C U+0067)
  0x20, 0x1C, 0x00, 0x6D, 0x01, // “m (U+201C U+006D)
  0x20, 0x1C, 0x00, 0x6E, 0x01, // “n (U+201C U+006E)
  0x20, 0x1C, 0x00, 0x6F, 0x02, // “o (U+201C U+006F)
  0x20, 0x1C, 0x00, 0x70, 0x01, // “p (U+201C U+0070)
  0x20, 0x1C, 0x00, 0x71, 0x02, // “q (U+201C U+0071)
  0x20, 0x1C, 0x00, 0x72, 0x01, // “r (U+201C U+0072)
  0x20, 0x1C, 0x00, 0x73, 0x01, // “s (U+201C U+0073)
  0x20, 0x1C, 0x00, 0x75, 0x01, // “u (U+201C U+0075)
  0x20, 0x1C, 0x00, 0xC0, 0x02, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x02, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x02, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x02, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x02, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x02, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xE0, 0x02, // “à (U+201C U+00E0)
  0x20, 0x1C, 0x00, 0xE1, 0x01, // “á (U+201C U+00E1)
  0x20, 0x1C, 0x00, 0xE2, 0x01, // “â (U+201C U+00E2)
  0x20, 0x1C, 0x00, 0xE3, 0x01, // “ã (U+201C U+00E3)
  0x20, 0x1C, 0x00, 0xE4, 0x01, // “ä (U+201C U+00E4)
  0x20, 0x1C, 0x00, 0xE5, 0x01, // “å (U+201C U+00E5)
  0x20, 0x1C, 0x00, 0xE6, 0x01, // “æ (U+201C U+00E6)
  0x20, 0x1C, 0x00, 0xE7, 0x02, // “ç (U+201C U+00E7)
  0x20, 0x1C, 0x00, 0xE8, 0x02, // “è (U+201C U+00E8)
  0x20, 0x1C, 0x00, 0xE9, 0x02, // “é (U+201C U+00E9)
  0x20, 0x1C, 0x00, 0xEA, 0x02, // “ê (U+201C U+00EA)
  0x20, 0x1C, 0x00, 0xEB, 0x02, // “ë (U+201C U+00EB)
  0x20, 0x1C, 0x00, 0xF1, 0x01, // “ñ (U+201C U+00F1)
  0x20, 0x1C, 0x00, 0xF2, 0x02, // “ò (U+201C U+00F2)
  0x20, 0x1C, 0x00, 0xF3, 0x02, // “ó (U+201C U+00F3)
  0x20, 0x1C, 0x00, 0xF4, 0x02, // “ô (U+201C U+00F4)
  0x20, 0x1C, 0x00, 0xF5, 0x02, // “õ (U+201C U+00F5)
  0x20, 0x1C, 0x00, 0xF6, 0x02, // “ö (U+201C U+00F6)
  0x20, 0x1C, 0x00, 0xF8, 0x02, // “ø (U+201C U+00F8)
  0x20, 0x1C, 0x00, 0xF9, 0x01, // “ù (U+201C U+00F9)
  0x20, 0x1C, 0x00, 0xFA, 0x01, // “ú (U+201C U+00FA)
  0x20, 0x1C, 0x00, 0xFB, 0x01, // “û (U+201C U+00FB)
  0x20, 0x1C, 0x00, 0xFC, 0x01, // “ü (U+201C U+00FC)
  0x20, 0x1C, 0x01, 0x00, 0x02, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x01, 0x01, // “ā (U+201C U+0101)
  0x20, 0x1C, 0x01, 0x02, 0x02, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x03, 0x01, // “ă (U+201C U+0103)
  0x20, 0x1C, 0x01, 0x04, 0x02, // “Ą (U+201C U+0104)
  0x20, 0x1C, 0x01, 0x05, 0x01, // “ą (U+201C U+0105)
  0x20, 0x1C, 0x01, 0x07, 0x02, // “ć (U+201C U+0107)
  0x20, 0x1C, 0x01, 0x09, 0x02, // “ĉ (U+201C U+0109)
  0x20, 0x1C, 0x01, 0x0B, 0x02, // “ċ (U+201C U+010B)
  0x20, 0x1C, 0x01, 0x0D, 0x02, // “č (U+201C U+010D)
  0x20, 0x1C, 0x01, 0x0F, 0x02, // “ď (U+201C U+010F)
  0x20, 0x1C, 0x01, 0x11, 0x02, // “đ (U+201C U+0111)
  0x20, 0x1C, 0x01, 0x13, 0x02, // “ē (U+201C U+0113)
  0x20, 0x1C, 0x01, 0x15, 0x02, // “ĕ (U+201C U+0115)
  0x20, 0x1C, 0x01, 0x17, 0x02, // “ė (U+201C U+0117)
  0x20, 0x1C, 0x01, 0x19, 0x02, // “ę (U+201C U+0119)
  0x20, 0x1C, 0x01, 0x1B, 0x02, // “ě (U+201C U+011B)
  0x20, 0x1C, 0x01, 0x1D, 0x01, // “ĝ (U+201C U+011D)
  0x20, 0x1C, 0x01, 0x1F, 0x01, // “ğ (U+201C U+011F)
  0x20, 0x1C, 0x01, 0x21, 0x01, // “ġ (U+201C U+0121)
  0x20, 0x1C, 0x01, 0x23, 0x01, // “ģ (U+201C U+0123)
  0x20, 0x1C, 0x01, 0x38, 0x01, // “ĸ (U+201C U+0138)
  0x20, 0x1C, 0x01, 0x44, 0x01, // “ń (U+201C U+0144)
  0x20, 0x1C, 0x01, 0x46, 0x01, // “ņ (U+201C U+0146)
  0x20, 0x1C, 0x01, 0x48, 0x01, // “ň (U+201C U+0148)
  0x20, 0x1C, 0x01, 0x4B, 0x01, // “ŋ (U+201C U+014B)
  0x20, 0x1C, 0x01, 0x4D, 0x02, // “ō (U+201C U+014D)
  0x20, 0x1C, 0x01, 0x4F, 0x02, // “ŏ (U+201C U+014F)
  0x20, 0x1C, 0x01, 0x51, 0x02, // “ő (U+201C U+0151)
  0x20, 0x1C, 0x01, 0x53, 0x02, // “œ (U+201C U+0153)
  0x20, 0x1C, 0x01, 0x55, 0x01, // “ŕ (U+201C U+0155)
  0x20, 0x1C, 0x01, 0x57, 0x01, // “ŗ (U+201C U+0157)
  0x20, 0x1C, 0x01, 0x5B, 0x01, // “ś (U+201C U+015B)
  0x20, 0x1C, 0x01, 0x5D, 0x01, // “ŝ (U+201C U+015D)
  0x20, 0x1C, 0x01, 0x5F, 0x01, // “ş (U+201C U+015F)
  0x20, 0x1C, 0x01, 0x61, 0x01, // “š (U+201C U+0161)
  0x20, 0x1C, 0x01, 0x69, 0x01, // “ũ (U+201C U+0169)
  0x20, 0x1C, 0x01, 0x6B, 0x01, // “ū (U+201C U+016B)
  0x20, 0x1C, 0x01, 0x6D, 0x01, // “ŭ (U+201C U+016D)
  0x20, 0x1C, 0x01, 0x6F, 0x01, // “ů (U+201C U+016F)
  0x20, 0x1C, 0x01, 0x71, 0x01, // “ű (U+201C U+0171)
  0x20, 0x1C, 0x01, 0x73, 0x01, // “ų (U+201C U+0173)
  0x20, 0x1D, 0x00, 0x41, 0x02, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0x61, 0x01, // ”a (U+201D U+0061)
  0x20, 0x1D, 0x00, 0x63, 0x02, // ”c (U+201D U+0063)
  0x20, 0x1D, 0x00, 0x64, 0x02, // ”d (U+201D U+0064)
  0x20, 0x1D, 0x00, 0x65, 0x02, // ”e (U+201D U+0065)
  0x20, 0x1D, 0x00, 0x67, 0x01, // ”g (U+201D U+0067)
  0x20, 0x1D, 0x00, 0x6D, 0x01, // ”m (U+201D U+006D)
  0x20, 0x1D, 0x00, 0x6E, 0x01, // ”n (U+201D U+006E)
  0x20, 0x1D, 0x00, 0x6F, 0x02, // ”o (U+201D U+006F)
  0x20, 0x1D, 0x00, 0x70, 0x01, // ”p (U+201D U+0070)
  0x20, 0x1D, 0x00, 0x71, 0x02, // ”q (U+201D U+0071)
  0x20, 0x1D, 0x00, 0x72, 0x01, // ”r (U+201D U+0072)
  0x20, 0x1D, 0x00, 0x73, 0x01, // ”s (U+201D U+0073)
  0x20, 0x1D, 0x00, 0x75, 0x01, // ”u (U+201D U+0075)
  0x20, 0x1D, 0x00, 0xC0, 0x02, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x02, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x02, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x02, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x02, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x02, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xE0, 0x02, // ”à (U+201D U+00E0)
  0x20, 0x1D, 0x00, 0xE1, 0x01, // ”á (U+201D U+00E1)
  0x20, 0x1D, 0x00, 0xE2, 0x01, // ”â (U+201D U+00E2)
  0x20, 0x1D, 0x00, 0xE3, 0x01, // ”ã (U+201D U+00E3)
  0x20, 0x1D, 0x00, 0xE4, 0x01, // ”ä (U+201D U+00E4)
  0x20, 0x1D, 0x00, 0xE5, 0x01, // ”å (U+201D U+00E5)
  0x20, 0x1D, 0x00, 0xE6, 0x01, // ”æ (U+201D U+00E6)
  0x20, 0x1D, 0x00, 0xE7, 0x02, // ”ç (U+201D U+00E7)
  0x20, 0x1D, 0x00, 0xE8, 0x02, // ”è (U+201D U+00E8)
  0x20, 0x1D, 0x00, 0xE9, 0x02, // ”é (U+201D U+00E9)
  0x20, 0x1D, 0x00, 0xEA, 0x02, // ”ê (U+201D U+00EA)
  0x20, 0x1D, 0x00, 0xEB, 0x02, // ”ë (U+201D U+00EB)
  0x20, 0x1D, 0x00, 0xF1, 0x01, // ”ñ (U+201D U+00F1)
  0x20, 0x1D, 0x00, 0xF2, 0x02, // ”ò (U+201D U+00F2)
  0x20, 0x1D, 0x00, 0xF3, 0x02, // ”ó (U+201D U+00F3)
  0x20, 0x1D, 0x00, 0xF4, 0x02, // ”ô (U+201D U+00F4)
  0x20, 0x1D, 0x00, 0xF5, 0x02, // ”õ (U+201D U+00F5)
  0x20, 0x1D, 0x00, 0xF6, 0x02, // ”ö (U+201D U+00F6)
  0x20, 0x1D, 0x00, 0xF8, 0x02, // ”ø (U+201D U+00F8)
  0x20, 0x1D, 0x00, 0xF9, 0x01, // ”ù (U+201D U+00F9)
  0x20, 0x1D, 0x00, 0xFA, 0x01, // ”ú (U+201D U+00FA)
  0x20, 0x1D, 0x00, 0xFB, 0x01, // ”û (U+201D U+00FB)
  0x20, 0x1D, 0x00, 0xFC, 0x01, // ”ü (U+201D U+00FC)
  0x20, 0x1D, 0x01, 0x00, 0x02, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x01, 0x01, // ”ā (U+201D U+0101)
  0x20, 0x1D, 0x01, 0x02, 0x02, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x03, 0x01, // ”ă (U+201D U+0103)
  0x20, 0x1D, 0x01, 0x04, 0x02, // ”Ą (U+201D U+0104)
  0x20, 0x1D, 0x01, 0x05, 0x01, // ”ą (U+201D U+0105)
  0x20, 0x1D, 0x01, 0x07, 0x02, // ”ć (U+201D U+0107)
  0x20, 0x1D, 0x01, 0x09, 0x02, // ”ĉ (U+201D U+0109)
  0x20, 0x1D, 0x01, 0x0B, 0x02, // ”ċ (U+201D U+010B)
  0x20, 0x1D, 0x01, 0x0D, 0x02, // ”č (U+201D U+010D)
  0x20, 0x1D, 0x01, 0x0F, 0x02, // ”ď (U+201D U+010F)
  0x20, 0x1D, 0x01, 0x11, 0x02, // ”đ (U+201D U+0111)
  0x20, 0x1D, 0x01, 0x13, 0x02, // ”ē (U+201D U+0113)
  0x20, 0x1D, 0x01, 0x15, 0x02, // ”ĕ (U+201D U+0115)
  0x20, 0x1D, 0x01, 0x17, 0x02, // ”ė (U+201D U+0117)
  0x20, 0x1D, 0x01, 0x19, 0x02, // ”ę (U+201D U+0119)
  0x20, 0x1D, 0x01, 0x1B, 0x02, // ”ě (U+201D U+011B)
  0x20, 0x1D, 0x01, 0x1D, 0x01, // ”ĝ (U+201D U+011D)
  0x20, 0x1D, 0x01, 0x1F, 0x01, // ”ğ (U+201D U+011F)
  0x20, 0x1D, 0x01, 0x21, 0x01, // ”ġ (U+201D U+0121)
  0x20, 0x1D, 0x01, 0x23, 0x01, // ”ģ (U+201D U+0123)
  0x20, 0x1D, 0x01, 0x38, 0x01, // ”ĸ (U+201D U+0138)
  0x20, 0x1D, 0x01, 0x44, 0x01, // ”ń (U+201D U+0144)
  0x20, 0x1D, 0x01, 0x46, 0x01, // ”ņ (U+201D U+0146)
  0x20, 0x1D, 0x01, 0x48, 0x01, // ”ň (U+201D U+0148)
  0x20, 0x1D, 0x01, 0x4B, 0x01, // ”ŋ (U+201D U+014B)
  0x20, 0x1D, 0x01, 0x4D, 0x02, // ”ō (U+201D U+014D)
  0x20, 0x1D, 0x01, 0x4F, 0x02, // ”ŏ (U+201D U+014F)
  0x20, 0x1D, 0x01, 0x51, 0x02, // ”ő (U+201D U+0151)
  0x20, 0x1D, 0x01, 0x53, 0x02, // ”œ (U+201D U+0153)
  0x20, 0x1D, 0x01, 0x55, 0x01, // ”ŕ (U+201D U+0155)
  0x20, 0x1D, 0x01, 0x57, 0x01, // ”ŗ (U+201D U+0157)
  0x20, 0x1D, 0x01, 0x5B, 0x01, // ”ś (U+201D U+015B)
  0x20, 0x1D, 0x01, 0x5D, 0x01, // ”ŝ (U+201D U+015D)
  0x20, 0x1D, 0x01, 0x5F, 0x01, // ”ş (U+201D U+015F)
  0x20, 0x1D, 0x01, 0x61, 0x01, // ”š (U+201D U+0161)
  0x20, 0x1D, 0x01, 0x69, 0x01, // ”ũ (U+201D U+0169)
  0x20, 0x1D, 0x01, 0x6B, 0x01, // ”ū (U+201D U+016B)
  0x20, 0x1D, 0x01, 0x6D, 0x01, // ”ŭ (U+201D U+016D)
  0x20, 0x1D, 0x01, 0x6F, 0x01, // ”ů (U+201D U+016F)
  0x20, 0x1D, 0x01, 0x71, 0x01, // ”ű (U+201D U+0171)
  0x20, 0x1D, 0x01, 0x73, 0x01, // ”ų (U+201D U+0173)
  0x20, 0x1E, 0x00, 0x43, 0x01, // „C (U+201E U+0043)
  0x20, 0x1E, 0x00, 0x47, 0x01, // „G (U+201E U+0047)
  0x20, 0x1E, 0x00, 0x4F, 0x01, // „O (U+201E U+004F)
  0x20, 0x1E, 0x00, 0x51, 0x01, // „Q (U+201E U+0051)
  0x20, 0x1E, 0x00, 0x54, 0x02, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x56, 0x01, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x01, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x01, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0xC7, 0x01, // „Ç (U+201E U+00C7)
  0x20, 0x1E, 0x00, 0xD2, 0x01, // „Ò (U+201E U+00D2)
  0x20, 0x1E, 0x00, 0xD3, 0x01, // „Ó (U+201E U+00D3)
  0x20, 0x1E, 0x00, 0xD4, 0x01, // „Ô (U+201E U+00D4)
  0x20, 0x1E, 0x00, 0xD5, 0x01, // „Õ (U+201E U+00D5)
  0x20, 0x1E, 0x00, 0xD6, 0x01, // „Ö (U+201E U+00D6)
  0x20, 0x1E, 0x00, 0xD8, 0x01, // „Ø (U+201E U+00D8)
  0x20, 0x1E, 0x00, 0xDD, 0x01, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x01, 0x06, 0x01, // „Ć (U+201E U+0106)
  0x20, 0x1E, 0x01, 0x08, 0x01, // „Ĉ (U+201E U+0108)
  0x20, 0x1E, 0x01, 0x0A, 0x01, // „Ċ (U+201E U+010A)
  0x20, 0x1E, 0x01, 0x0C, 0x01, // „Č (U+201E U+010C)
  0x20, 0x1E, 0x01, 0x1C, 0x01, // „Ĝ (U+201E U+011C)
  0x20, 0x1E, 0x01, 0x1E, 0x01, // „Ğ (U+201E U+011E)
  0x20, 0x1E, 0x01, 0x20, 0x01, // „Ġ (U+201E U+0120)
  0x20, 0x1E, 0x01, 0x22, 0x01, // „Ģ (U+201E U+0122)
  0x20, 0x1E, 0x01, 0x4C, 0x01, // „Ō (U+201E U+014C)
  0x20, 0x1E, 0x01, 0x4E, 0x01, // „Ŏ (U+201E U+014E)
  0x20, 0x1E, 0x01, 0x50, 0x01, // „Ő (U+201E U+0150)
  0x20, 0x1E, 0x01, 0x52, 0x01, // „Œ (U+201E U+0152)
  0x20, 0x1E, 0x01, 0x62, 0x02, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x02, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x02, // „Ŧ (U+201E U+0166)
  0x20, 0x1E, 0x01, 0x74, 0x01, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x76, 0x01, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x78, 0x01, // „Ÿ (U+201E U+0178)
  0x20, 0x39, 0x00, 0x54, 0x01, // ‹T (U+2039 U+0054)
  0x20, 0x39, 0x00, 0x56, 0x01, // ‹V (U+2039 U+0056)
  0x20, 0x39, 0x00, 0x57, 0x01, // ‹W (U+2039 U+0057)
  0x20, 0x39, 0x00, 0x59, 0x01, // ‹Y (U+2039 U+0059)
  0x20, 0x39, 0x00, 0xDD, 0x01, // ‹Ý (U+2039 U+00DD)
  0x20, 0x39, 0x01, 0x62, 0x01, // ‹Ţ (U+2039 U+0162)
  0x20, 0x39, 0x01, 0x64, 0x01, // ‹Ť (U+2039 U+0164)
  0x20, 0x39, 0x01, 0x66, 0x01, // ‹Ŧ (U+2039 U+0166)
  0x20, 0x39, 0x01, 0x74, 0x01, // ‹Ŵ (U+2039 U+0174)
  0x20, 0x39, 0x01, 0x76, 0x01, // ‹Ŷ (U+2039 U+0176)
  0x20, 0x39, 0x01, 0x78, 0x01, // ‹Ÿ (U+2039 U+0178)
  0x20, 0x3A, 0x00, 0x54, 0x01, // ›T (U+203A U+0054)
  0x20, 0x3A, 0x00, 0x56, 0x01, // ›V (U+203A U+0056)
  0x20, 0x3A, 0x00, 0x57, 0x01, // ›W (U+203A U+0057)
  0x20, 0x3A, 0x00, 0x59, 0x01, // ›Y (U+203A U+0059)
  0x20, 0x3A, 0x00, 0xDD, 0x01, // ›Ý (U+203A U+00DD)
  0x20, 0x3A, 0x01, 0x62, 0x01, // ›Ţ (U+203A U+0162)
  0x20, 0x3A, 0x01, 0x64, 0x01, // ›Ť (U+203A U+0164)
  0x20, 0x3A, 0x01, 0x66, 0x01, // ›Ŧ (U+203A U+0166)
  0x20, 0x3A, 0x01, 0x74, 0x01, // ›Ŵ (U+203A U+0174)
  0x20, 0x3A, 0x01, 0x76, 0x01, // ›Ŷ (U+203A U+0176)
  0x20, 0x3A, 0x01, 0x78, 0x01, // ›Ÿ (U+203A U+0178)
  0x20, 0x44, 0x00, 0x30, 0x04, // ⁄0 (U+2044 U+0030)
  0x20, 0x44, 0x00, 0x31, 0x04, // ⁄1 (U+2044 U+0031)
  0x20, 0x44, 0x00, 0x32, 0x04, // ⁄2 (U+2044 U+0032)
  0x20, 0x44, 0x00, 0x33, 0x04, // ⁄3 (U+2044 U+0033)
  0x20, 0x44, 0x00, 0x34, 0x04, // ⁄4 (U+2044 U+0034)
  0x20, 0x44, 0x00, 0x35, 0x04, // ⁄5 (U+2044 U+0035)
  0x20, 0x44, 0x00, 0x36, 0x04, // ⁄6 (U+2044 U+0036)
  0x20, 0x44, 0x00, 0x37, 0x04, // ⁄7 (U+2044 U+0037)
  0x20, 0x44, 0x00, 0x38, 0x04, // ⁄8 (U+2044 U+0038)
  0x20, 0x44, 0x00, 0x39, 0x04, // ⁄9 (U+2044 U+0039)
  
  // Glyph data
  // "!" (U+0021)
  0x48, 0x1B, 0xFD, 0x48, 0x1D, 0xF9, 0x30, 0x1A, 0x05, 0x30, 0x3A, 0x02, 0x38, 0x16, 0xFE, 0x48,
  0x19, 0xFA, 0x48, 0x1C, 0xF6, 0x48, 0x1E, 0xF3, 0x38, 0x12, 0xFE, 0x48, 0x14, 0xFB, 0x48, 0x17,
  0xF7, 0x48, 0x1A, 0xF4, 0x40, 0xD9, 0x59, 0x0C, 0x48, 0x11, 0x95, 0x77, 0x38, 0x22, 0xCE, 0x23,
  0x09, 0xA0, 0x43, 0x81, 0x6E, 0xA4,
  // """ (U+0022)
  0x10, 0x4A, 0x01, 0x1A, 0x85, 0x50, 0x6F, 0xC0, 0x2A, 0x87, 0x10, 0x8F, 0x80, 0x4F, 0xC2, 0x85,
  0xBF, 0x30, 0x7F, 0x72, 0x0D, 0x0E, 0x28, 0x19, 0xF3, 0x29, 0x0B, 0x20, 0xB0, 0xE2, 0x81, 0x2F,
  0x62, 0x0E, 0x0A, 0x20,
  // "#" (U+0023)
  0x68, 0x16, 0xF5, 0x20, 0xC0, 0xD7, 0x85, 0xAF, 0x10, 0x1F, 0x97, 0x0E, 0x0B, 0x28, 0x16, 0xF4,
  0x68, 0x13, 0xF7, 0x20, 0xA9, 0x78, 0x18, 0xF3, 0x20, 0xE0, 0xB7, 0x0C, 0x0E, 0x28, 0x13, 0xF7,
  0x40, 0xCF, 0xB0, 0xA2, 0x89, 0x2A, 0xBD, 0xFC, 0xBB, 0xFE, 0xBB, 0x64, 0x0B, 0x92, 0x81, 0x2F,
  0x87, 0x90, 0xA2, 0x81, 0x7F, 0x36, 0x81, 0x5F, 0x52, 0x0C, 0x0D, 0x78, 0x5A, 0xF1, 0x01, 0xF9,
  0x48, 0x17, 0xDD, 0xA8, 0x5D, 0xDE, 0xFE, 0xDC, 0x20, 0xAF, 0xB0, 0xC4, 0x81, 0x8F, 0x22, 0x0E,
  0x0B, 0x70, 0xC0, 0xD2, 0x81, 0x3F, 0x66, 0x81, 0x1F, 0x92, 0x81, 0x8F, 0x26, 0x81, 0x6F, 0x42,
  0x00, 0xD7, 0x0A, 0x0E, 0x28, 0x12, 0xF8, 0x70, 0xE0, 0xB2, 0x81, 0x6F, 0x46,
  // "$" (U+0024)
  0x78, 0x13, 0xF1, 0x72, 0x07, 0x0D, 0x71, 0x85, 0x48, 0xDE, 0xA7, 0x13, 0x01, 0x0B, 0xE0, 0xC3,
  0x87, 0xCF, 0x93, 0xF3, 0x3B, 0x42, 0x83, 0x3F, 0xC0, 0x49, 0x68, 0x46, 0xF9, 0x07, 0xC6, 0x84,
  0x5F, 0xB0, 0xB8, 0x60, 0x2A, 0x81, 0x6E, 0x57, 0x08, 0xB0, 0x37, 0x10, 0x7A, 0x0D, 0x03, 0x71,
  0x09, 0xA0, 0xE0, 0x37, 0x83, 0xC7, 0xAF, 0xB7, 0x90, 0x40, 0x1A, 0x68, 0x33, 0xF1, 0x0E, 0x96,
  0x84, 0x6D, 0x03, 0xFE, 0x28, 0x90, 0x87, 0x20, 0xAA, 0x2C, 0xF8, 0x20, 0xAA, 0x0E, 0xC0, 0xB3,
  0x81, 0x39, 0xDB, 0x0C, 0x06, 0x78, 0x14, 0xF1, 0x72, 0x07, 0x0C, 0x73, 0x0A, 0x09, 0x70,
  // "%" (U+0025)
  0x38, 0x25, 0xDE, 0x95, 0x81, 0x4F, 0x73, 0x05, 0xC0, 0x54, 0x0D, 0x0E, 0x48, 0x4E, 0xE2, 0x3F,
  0x93, 0x81, 0x6F, 0x53, 0x81, 0x6F, 0x62, 0x90, 0xA2, 0x81, 0x1E, 0xC4, 0x0C, 0x92, 0x81, 0x1F,
  0x92, 0x81, 0x8F, 0x44, 0x90, 0xB2, 0x85, 0x4F, 0x70, 0x2F, 0xA4, 0x81, 0x3F, 0x82, 0x85, 0x7F,
  0x40, 0xAF, 0x24, 0x81, 0x5F, 0x52, 0x84, 0xCF, 0x04, 0xF8, 0x58, 0xB7, 0x6F, 0x40, 0x2F, 0x90,
  0xCE, 0x13, 0xCE, 0xB1, 0x5F, 0x70, 0xBF, 0x36, 0xF6, 0x2E, 0xEB, 0xF9, 0x2A, 0x8A, 0x7E, 0xF9,
  0x0E, 0xD0, 0xBE, 0x10, 0xDD, 0x06, 0xEE, 0x80, 0x8F, 0x42, 0xF8, 0x20, 0xC9, 0x58, 0x52, 0xFB,
  0x08, 0xF3, 0x20, 0x0D, 0x58, 0x4A, 0xF2, 0x0C, 0xE3, 0x90, 0xB4, 0x81, 0x3F, 0x92, 0x90, 0xB2,
  0x81, 0x4F, 0x74, 0x85, 0xCE, 0x10, 0x1F, 0x92, 0x81, 0x8F, 0x43, 0x81, 0x5F, 0x72, 0x81, 0x2F,
  0x82, 0x0E, 0x0D, 0x40, 0x0D, 0x38, 0x51, 0xFB, 0x08, 0xF7, 0x38, 0x17, 0xF5, 0x48, 0x3D, 0xFE,
  0xFC, 0x38, 0x11, 0xEC, 0x58, 0x33, 0xDE, 0xA1, 0x20,
  // "&" (U+0026)
  0x58, 0x42, 0xAE, 0xE9, 0x16, 0x82, 0x1E, 0xFE, 0xA0, 0xA6, 0x83, 0x9F, 0x90, 0x3A, 0x68, 0x1E,
  0xF1, 0x2A, 0x01, 0x48, 0x12, 0xFD, 0x20, 0x1A, 0x58, 0x13, 0xFD, 0x28, 0x17, 0xFB, 0x58, 0x62,
  0xFE, 0x02, 0xEF, 0x46, 0xA8, 0x26, 0xDF, 0x87, 0x0B, 0xB0, 0xA7, 0x10, 0x9A, 0x09, 0x70, 0x10,
  0xAB, 0x05, 0x78, 0x4C, 0xFB, 0x9F, 0xC2, 0x87, 0x4F, 0xD0, 0xBF, 0xB0, 0x1A, 0x87, 0x40, 0xAF,
  0x74, 0xFE, 0x12, 0x89, 0x09, 0xFB, 0x3F, 0xE0, 0xAF, 0x83, 0x02, 0xA8, 0x5D, 0xF6, 0x0C, 0xF6,
  0x40, 0xAA, 0x0B, 0x28, 0x1C, 0xF6, 0x40, 0x9A, 0x04, 0x28, 0x5A, 0xFD, 0x10, 0x1B, 0xB0, 0xA2,
  0x03, 0xB0, 0xEA, 0x0A, 0x04, 0xA0, 0x22, 0x84, 0x3B, 0xFE, 0xB5, 0x28, 0x1D, 0xF9, 0x10,
  // "'" (U+0027)
  0x10, 0x2A, 0x83, 0x20, 0x5F, 0xD2, 0x81, 0x7F, 0x92, 0x81, 0x9F, 0x52, 0x81, 0xCF, 0x12, 0x0E,
  0x0C, 0x28, 0x11, 0xF8, 0x20,
  // "(" (U+0028)
  0x68, 0x14, 0xFA, 0x58, 0x12, 0xED, 0x68, 0x1C, 0xF3, 0x58, 0x18, 0xF9, 0x58, 0x22, 0xFE, 0x15,
  0x81, 0xAF, 0x75, 0x82, 0x1F, 0xE1, 0x58, 0x18, 0xF9, 0x68, 0x1E, 0xF3, 0x58, 0x14, 0xFD, 0x68,
  0x18, 0xF8, 0x68, 0x1C, 0xF5, 0x68, 0x1E, 0xF1, 0x50, 0x1A, 0x68, 0x13, 0xFD, 0x68, 0x14, 0xFC,
  0x68, 0x14, 0xFB, 0x68, 0x14, 0xFC, 0x68, 0x13, 0xFC, 0x68, 0x11, 0xFE, 0x78, 0x1E, 0xF1, 0x68,
  0x1A, 0xF4, 0x68, 0x16, 0xF7, 0x70, 0xE0, 0xC5,
  // ")" (U+0029)
  0x50, 0xC0, 0xE7, 0x81, 0x7F, 0x66, 0x81, 0x4F, 0xA6, 0x81, 0x1F, 0xE7, 0x81, 0xEF, 0x16, 0x81,
  0xDF, 0x36, 0x81, 0xCF, 0x46, 0x81, 0xCF, 0x56, 0x81, 0xCF, 0x46, 0x81, 0xDF, 0x36, 0xA0, 0x25,
  0x02, 0xA6, 0x81, 0x5F, 0xC6, 0x81, 0x8F, 0x86, 0x81, 0xDF, 0x45, 0x81, 0x3F, 0xE6, 0x81, 0x8F,
  0x96, 0x81, 0xEF, 0x25, 0x81, 0x7F, 0xA5, 0x82, 0x1E, 0xF2, 0x58, 0x18, 0xF8, 0x58, 0x13, 0xFD,
  0x68, 0x1D, 0xE3, 0x58, 0x19, 0xF5, 0x60,
  // "*" (U+002A)
  0x58, 0x19, 0x71, 0x71, 0xA5, 0x03, 0x39, 0x0B, 0x58, 0x4E, 0xC5, 0x1F, 0x74, 0x01, 0x0C, 0xA8,
  0x4D, 0xF9, 0x9B, 0xE3, 0x01, 0x06, 0xE0, 0x13, 0x82, 0xAF, 0xEA, 0x68, 0x4A, 0xF8, 0x8F, 0x34,
  0x85, 0x8F, 0xC0, 0x3F, 0xB5, 0x0A, 0x02, 0x28, 0x1D, 0xE2, 0x71, 0x03, 0x01, 0x30,
  // "+" (U+002B)
  0x48, 0x13, 0xFA, 0x72, 0x81, 0x3F, 0xA7, 0x28, 0x13, 0xFA, 0x72, 0x81, 0x3F, 0xA7, 0x28, 0x13,
  0xFA, 0x72, 0x81, 0x3F, 0xA5, 0x0A, 0xFB, 0x89, 0x31, 0x9D, 0xDD, 0xEF, 0xED, 0xDD, 0xD1, 0x48,
  0x13, 0xFA, 0x72, 0x81, 0x3F, 0xA7, 0x28, 0x13, 0xFA, 0x72, 0x81, 0x3F, 0xA7, 0x28, 0x13, 0xFA,
  0x50,
  // "," (U+002C)
  0x28, 0x15, 0x75, 0x2A, 0x83, 0x50, 0x5F, 0xD2, 0x85, 0xBF, 0x60, 0x2F, 0xD2, 0x81, 0x8F, 0x52,
  0x0E, 0x0B, 0x30,
  // "-" (U+002D)
  0x02, 0x80, 0x1D, 0x09, 0x06, 0xD0, 0x70,
  // "." (U+002E)
  0x83, 0x2C, 0xE2, 0x8A, 0x82, 0x46, 0xEA, 0x10,
  // "/" (U+002F)
  0x73, 0x82, 0x1F, 0xE1, 0x73, 0x81, 0x9F, 0x87, 0x38, 0x22, 0xFE, 0x17, 0x38, 0x1A, 0xF7, 0x73,
  0x81, 0x2F, 0xE7, 0x48, 0x1A, 0xF6, 0x73, 0x81, 0x3F, 0xD7, 0x48, 0x1B, 0xF5, 0x73, 0x81, 0x4F,
  0xD7, 0x48, 0x1C, 0xF5, 0x73, 0x81, 0x5F, 0xC7, 0x48, 0x1C, 0xF4, 0x73, 0x81, 0x5F, 0xB7, 0x48,
  0x1D, 0xF3, 0x73, 0x81, 0x6F, 0xA7, 0x48, 0x1D, 0xF2, 0x73, 0x81, 0x7F, 0xA7, 0x48, 0x1E, 0xF2,
  0x73, 0x81, 0x7F, 0x97, 0x38, 0x21, 0xEF, 0x17, 0x30,
  // "0" (U+0030)
  0x58, 0x41, 0x9E, 0xEB, 0x25, 0x02, 0x0D, 0xC0, 0xD5, 0x86, 0xCF, 0xA0, 0x1E, 0xF5, 0x38, 0x17,
  0xFC, 0x38, 0x19, 0xF8, 0x38, 0x1E, 0xF4, 0x38, 0x17, 0xFA, 0x28, 0x16, 0xFD, 0x48, 0x17, 0xFA,
  0x28, 0x1B, 0xF7, 0x48, 0x18, 0xF9, 0x2A, 0x03, 0x48, 0x5A, 0xF8, 0x04, 0xFE, 0x58, 0x5C, 0xF6,
  0x08, 0xFB, 0x58, 0x5E, 0xF3, 0x0A, 0xF8, 0x40, 0x2A, 0x83, 0x10, 0xDF, 0x54, 0x81, 0x5F, 0xD2,
  0xA0, 0x34, 0x83, 0x9F, 0x90, 0x1A, 0x01, 0x48, 0x3D, 0xF4, 0x02, 0xA4, 0x81, 0x4F, 0xE2, 0x01,
  0xA0, 0x13, 0x81, 0xAF, 0x93, 0xA0, 0x32, 0x02, 0xA0, 0x13, 0x86, 0xCF, 0xA0, 0x2D, 0xF7, 0x40,
  0x4A, 0x0E, 0xA0, 0xA6, 0x83, 0x6D, 0xFD, 0x65,
  // "1" (U+0031)
  0x40, 0x5A, 0x02, 0x30, 0x7A, 0x0E, 0x30, 0xAB, 0x8A, 0x2B, 0x01, 0xCF, 0xDA, 0xF8, 0x0A, 0xFB,
  0x1C, 0xF5, 0x02, 0x92, 0xA0, 0x24, 0x81, 0x3F, 0xE5, 0x81, 0x7F, 0xB5, 0x81, 0xAF, 0x85, 0x81,
  0xDF, 0x54, 0x01, 0xA0, 0x24, 0x81, 0x4F, 0xE5, 0x81, 0x7F, 0xB5, 0x81, 0xAF, 0x85, 0x81, 0xDF,
  0x44, 0x01, 0xA0, 0x14, 0x81, 0x4F, 0xE5, 0x81, 0x8F, 0xA5, 0x81, 0xBF, 0x75, 0x81, 0xEF, 0x44,
  // "2" (U+0032)
  0x58, 0x52, 0x9D, 0xFE, 0x91, 0x50, 0x7B, 0x0E, 0xA0, 0xD5, 0x81, 0x8F, 0x72, 0x05, 0xA0, 0x64,
  0x01, 0x03, 0x48, 0x1B, 0xF9, 0x73, 0x81, 0x9F, 0xA7, 0x38, 0x1B, 0xF8, 0x73, 0x81, 0xEF, 0x47,
  0x28, 0x16, 0xFE, 0x72, 0x82, 0x1E, 0xF6, 0x72, 0x81, 0xAF, 0xC7, 0x28, 0x27, 0xFE, 0x27, 0x10,
  0x4A, 0x05, 0x71, 0x82, 0x3E, 0xF7, 0x71, 0x82, 0x2E, 0xF9, 0x71, 0x82, 0x1D, 0xFA, 0x72, 0x81,
  0xCF, 0xC7, 0x28, 0x2B, 0xFD, 0x17, 0x18, 0x29, 0xFE, 0x17, 0x10, 0x4A, 0x0E, 0x80, 0x2D, 0x02,
  0x20, 0x7F, 0xA3,
  // "3" (U+0033)
  0x58, 0x54, 0xAD, 0xFE, 0x91, 0x50, 0x9B, 0x0E, 0xA0, 0xD0, 0x14, 0x81, 0x7D, 0x52, 0x04, 0xA0,
  0x74, 0x01, 0x58, 0x1A, 0xFA, 0x73, 0x81, 0x9F, 0xA7, 0x38, 0x1A, 0xF8, 0x72, 0x01, 0xA0, 0x37,
  0x28, 0x1A, 0xFB, 0x71, 0x83, 0x4B, 0xFC, 0x15, 0x03, 0xB0, 0xC0, 0x67, 0x06, 0x0E, 0xA0, 0xE0,
  0x67, 0x30, 0x6A, 0x05, 0x73, 0x81, 0x9F, 0xC7, 0x30, 0x5A, 0x73, 0x81, 0x5F, 0xE7, 0x38, 0x18,
  0xFB, 0x72, 0x82, 0x1E, 0xF6, 0x28, 0x12, 0xA4, 0x38, 0x24, 0xDF, 0xC3, 0x02, 0xB0, 0x0E, 0xA0,
  0xC0, 0x14, 0x85, 0x6B, 0xEF, 0xEB, 0x65,
  // "4" (U+0034)
  0x72, 0x82, 0x1E, 0xFA, 0x72, 0x0A, 0xA0, 0x77, 0x10, 0x4B, 0x04, 0x78, 0x41, 0xDC, 0xEF, 0x17,
  0x83, 0x9F, 0x6F, 0xD7, 0x84, 0x4F, 0xA6, 0xFA, 0x78, 0x4D, 0xE1, 0x9F, 0x76, 0x85, 0x9F, 0x60,
  0xCF, 0x45, 0x81, 0x4F, 0xB2, 0xA0, 0x15, 0x85, 0xDE, 0x20, 0x3F, 0xD5, 0x81, 0x9F, 0x62, 0x81,
  0x7F, 0xA4, 0x81, 0x3F, 0xB3, 0x81, 0xAF, 0x74, 0x81, 0xDF, 0x23, 0x81, 0xDF, 0x43, 0x81, 0x8F,
  0x73, 0x01, 0xA0, 0x13, 0xFC, 0x10, 0x3F, 0xB0, 0xC7, 0x18, 0x1A, 0xF6, 0x73, 0x81, 0xEF, 0x37,
  0x28, 0x12, 0xFE, 0x73, 0x81, 0x6F, 0xB4,
  // "5" (U+0035)
  0x40, 0x9E, 0x0C, 0x40, 0xD9, 0x80, 0x1D, 0x07, 0x38, 0x11, 0xFE, 0x72, 0x81, 0x5F, 0xA7, 0x28,
  0x19, 0xF6, 0x72, 0x81, 0xDF, 0x27, 0x18, 0x12, 0xFD, 0x72, 0x81, 0x6F, 0x97, 0x28, 0x5A, 0xFE,
  0xEF, 0xC5, 0x50, 0xCA, 0x0E, 0xB0, 0x74, 0x02, 0x04, 0x28, 0x32, 0xDF, 0xE1, 0x71, 0x03, 0xA0,
  0x47, 0x2A, 0x06, 0x72, 0x81, 0xEF, 0x57, 0x10, 0x1A, 0x03, 0x71, 0x81, 0x5F, 0xE7, 0x18, 0x21,
  0xDF, 0x82, 0x0B, 0x04, 0x38, 0x24, 0xDF, 0xD3, 0x0E, 0xA0, 0xEB, 0x0D, 0x02, 0x38, 0x56, 0xBD,
  0xFE, 0xB6, 0x50,
  // "6" (U+0036)
  0x68, 0x46, 0xCE, 0xFD, 0x24, 0x01, 0x0C, 0xA0, 0xFE, 0x48, 0x31, 0xDF, 0xA2, 0x20, 0x14, 0x81,
  0xCF, 0x77, 0x18, 0x17, 0xFA, 0x72, 0x81, 0xEF, 0x27, 0x18, 0x16, 0xFA, 0x72, 0x86, 0xCF, 0x44,
  0xBD, 0xB3, 0x38, 0x21, 0xFE, 0x8C, 0x0E, 0x01, 0x28, 0x90, 0x5F, 0xEE, 0x50, 0x4E, 0xF7, 0x20,
  0x9A, 0x03, 0x38, 0x19, 0xFA, 0x28, 0x1B, 0xFA, 0x48, 0x16, 0xFC, 0x28, 0x1D, 0xF5, 0x48, 0x17,
  0xFB, 0x2A, 0x03, 0x48, 0x19, 0xF9, 0x2A, 0x02, 0x48, 0x1C, 0xF6, 0x2A, 0x02, 0x30, 0x1A, 0x02,
  0x28, 0x1D, 0xF5, 0x38, 0x19, 0xFB, 0x38, 0x49, 0xFC, 0x10, 0x6A, 0x03, 0x30, 0x10, 0xEA, 0x0E,
  0xA0, 0x65, 0x84, 0x3B, 0xEE, 0xB3, 0x50,
  // "7" (U+0037)
  0x10, 0x1F, 0xA8, 0x1A, 0x03, 0x80, 0x3D, 0xA0, 0x77, 0x10, 0x3A, 0x01, 0x71, 0x81, 0xAF, 0x97,
  0x10, 0x2A, 0x02, 0x71, 0x81, 0xAF, 0x97, 0x10, 0x2A, 0x02, 0x71, 0x81, 0xAF, 0xA7, 0x10, 0x2A,
  0x02, 0x71, 0x81, 0x9F, 0xA7, 0x10, 0x2A, 0x03, 0x71, 0x81, 0x9F, 0xA7, 0x10, 0x1A, 0x03, 0x71,
  0x81, 0x9F, 0xB7, 0x10, 0x1A, 0x03, 0x71, 0x81, 0x8F, 0xB7, 0x18, 0x21, 0xEF, 0x47, 0x18, 0x18,
  0xFC, 0x71, 0x82, 0x1E, 0xF4, 0x71, 0x81, 0x8F, 0xC7, 0x20,
  // "8" (U+0038)
  0x58, 0x45, 0xCE, 0xEC, 0x45, 0x0A, 0xA0, 0xEB, 0x04, 0x38, 0x76, 0xFE, 0x40, 0x1B, 0xFC, 0x38,
  0x1C, 0xF6, 0x30, 0x4A, 0x3A, 0x02, 0x30, 0x3A, 0x3A, 0x01, 0x38, 0x16, 0xFC, 0x38, 0x1E, 0xF5,
  0x28, 0x21, 0xDF, 0x53, 0x86, 0x8F, 0xC0, 0x2C, 0xF9, 0x48, 0x21, 0xDF, 0xCA, 0x08, 0x60, 0x8B,
  0x04, 0x58, 0x51, 0xBF, 0xED, 0xFB, 0x48, 0x72, 0xDF, 0x90, 0x2E, 0xF7, 0x38, 0x1D, 0xF8, 0x38,
  0x15, 0xFE, 0x28, 0x15, 0xFD, 0x5A, 0x83, 0x30, 0x9F, 0x85, 0x85, 0xDF, 0x40, 0xBF, 0x75, 0x85,
  0xEF, 0x30, 0xAF, 0xA4, 0x81, 0x5F, 0xE2, 0x06, 0xA0, 0x52, 0x82, 0x4E, 0xF7, 0x30, 0xCA, 0x00,
  0xEA, 0x0A, 0x58, 0x48, 0xDF, 0xEB, 0x54,
  // "9" (U+0039)
  0x58, 0x36, 0xCE, 0xD8, 0x60, 0xBA, 0x0E, 0xA0, 0x94, 0x84, 0x8F, 0xD2, 0x06, 0xA0, 0x22, 0x02,
  0xA0, 0x23, 0x81, 0xDF, 0x62, 0x81, 0x8F, 0xA4, 0x81, 0xAF, 0x82, 0x81, 0xDF, 0x54, 0x83, 0x9F,
  0x80, 0x1A, 0x01, 0x48, 0x3A, 0xF7, 0x03, 0xA5, 0x83, 0xDF, 0x60, 0x3A, 0x40, 0x3A, 0x81, 0x40,
  0x1A, 0x01, 0x30, 0xBA, 0x02, 0x28, 0x4D, 0xFA, 0x11, 0x9A, 0x0E, 0x30, 0x7C, 0x82, 0xE8, 0xFA,
  0x48, 0x67, 0xCD, 0x91, 0xAF, 0x67, 0x2A, 0x01, 0x71, 0x81, 0x7F, 0x97, 0x18, 0x21, 0xEF, 0x17,
  0x18, 0x1B, 0xF7, 0x30, 0x23, 0x82, 0x3C, 0xFB, 0x48, 0x2A, 0xFE, 0xEA, 0x0B, 0x58, 0x47, 0xEF,
  0xEC, 0x66,
  // ":" (U+003A)
  0x38, 0x1B, 0xE5, 0x20, 0x5A, 0x07, 0x28, 0x23, 0xEC, 0x18, 0x0E, 0x20, 0x82, 0x3D, 0xD1, 0x20,
  0xBA, 0x02, 0x28, 0x18, 0xE8, 0x30,
  // ";" (U+003B)
  0x58, 0x1A, 0xE6, 0x40, 0x4A, 0x09, 0x48, 0x22, 0xED, 0x28, 0x0F, 0x70, 0x81, 0x9A, 0x54, 0x03,
  0xA0, 0x24, 0x81, 0x8F, 0xA5, 0x81, 0xDF, 0x34, 0x81, 0x4F, 0xB5, 0x81, 0xBF, 0x24, 0x81, 0x2F,
  0x95,
  // "<" (U+003C)
  0x72, 0x81, 0x18, 0x17, 0x18, 0x27, 0xEF, 0x16, 0x06, 0x0E, 0xA0, 0x95, 0x06, 0x0D, 0xA0, 0x90,
  0x14, 0x05, 0x0D, 0xA0, 0x90, 0x14, 0x04, 0x0C, 0xA0, 0x90, 0x16, 0x0A, 0xA0, 0x57, 0x10, 0x30,
  0xBA, 0x0B, 0x03, 0x71, 0x03, 0x0B, 0xA0, 0xB0, 0x47, 0x10, 0x30, 0xBA, 0x0C, 0x04, 0x71, 0x03,
  0x0B, 0xA0, 0xC0, 0x17, 0x18, 0x24, 0xBF, 0x17, 0x30, 0x40, 0x10,
  // "=" (U+003D)
  0x08, 0x80, 0x6D, 0x09, 0xFB, 0x80, 0xD0, 0x00, 0x88, 0x06, 0xD0, 0x9F, 0xB0,
  // ">" (U+003E)
  0x06, 0x03, 0x73, 0x82, 0xAF, 0xB3, 0x71, 0x04, 0x0D, 0xA0, 0xA0, 0x27, 0x10, 0x50, 0xDA, 0x09,
  0x02, 0x71, 0x05, 0x0D, 0xA0, 0x90, 0x17, 0x18, 0x35, 0xDF, 0xE8, 0x71, 0x01, 0x0C, 0xA0, 0x25,
  0x84, 0x17, 0xEF, 0xE7, 0x48, 0x41, 0x8E, 0xFE, 0x74, 0x01, 0x09, 0xA0, 0xE0, 0x75, 0x07, 0xA0,
  0xE0, 0x77, 0x81, 0xAE, 0x77, 0x20, 0x47, 0x40,
  // "?" (U+003F)
  0x28, 0x45, 0xBE, 0xEC, 0x52, 0x07, 0xA0, 0xEB, 0x83, 0x40, 0x3C, 0x32, 0x81, 0xBF, 0xB6, 0x81,
  0x5F, 0xD6, 0x81, 0x5F, 0xC6, 0x81, 0x8F, 0x95, 0x82, 0x1E, 0xF3, 0x58, 0x1B, 0xF9, 0x58, 0x1A,
  0xFC, 0x58, 0x28, 0xFD, 0x14, 0x82, 0x4F, 0xD1, 0x58, 0x1C, 0xF3, 0x58, 0x13, 0xF9, 0x68, 0x18,
  0xF3, 0x60, 0x70, 0xA7, 0x77, 0x38, 0x17, 0xEA, 0x6A, 0x0C, 0x68, 0x1C, 0xE4, 0x60,
  // "@" (U+0040)
  0x71, 0x85, 0x5A, 0xDF, 0xDB, 0x47, 0x20, 0x30, 0xDA, 0x00, 0xEB, 0x08, 0x70, 0x5A, 0x08, 0x02,
  0x38, 0x25, 0xDF, 0x55, 0x82, 0x4F, 0xE3, 0x68, 0x12, 0xED, 0x48, 0x22, 0xEE, 0x27, 0x18, 0x19,
  0xF2, 0x38, 0x1A, 0xF4, 0x28, 0x90, 0x3B, 0xED, 0xA3, 0x05, 0xF6, 0x28, 0x13, 0xFA, 0x20, 0x4A,
  0x0E, 0xA8, 0x35, 0x03, 0xF7, 0x28, 0xA2, 0xAF, 0x20, 0x2E, 0xD3, 0x09, 0xF1, 0x02, 0xF7, 0x01,
  0xFB, 0x28, 0x1A, 0xF3, 0x20, 0x0D, 0x28, 0x91, 0x4F, 0x60, 0x5F, 0x50, 0x1F, 0xB2, 0x81, 0x1F,
  0x92, 0x89, 0x16, 0xF4, 0x09, 0xF1, 0x06, 0xF6, 0x28, 0x15, 0xF5, 0x28, 0x49, 0xF1, 0x0C, 0xD2,
  0x81, 0xAF, 0x12, 0x81, 0xAF, 0x22, 0x00, 0xD2, 0x0E, 0x0B, 0x20, 0xC9, 0x30, 0x0E, 0x28, 0x13,
  0xF8, 0x29, 0x0A, 0x20, 0xD0, 0xE2, 0x81, 0x7F, 0xB2, 0x85, 0xAF, 0x20, 0x1F, 0x92, 0x89, 0x1C,
  0xF3, 0x3E, 0xCD, 0x16, 0xF9, 0x28, 0x11, 0xFA, 0x20, 0x8B, 0x09, 0x06, 0xB0, 0xC4, 0x0E, 0x0D,
  0x38, 0x19, 0xD8, 0x28, 0x29, 0xD9, 0x14, 0x81, 0xBF, 0x27, 0x71, 0x81, 0x5F, 0xB7, 0x72, 0x82,
  0xCF, 0xB3, 0x38, 0x11, 0x54, 0x71, 0x01, 0x0D, 0xB0, 0xEB, 0x07, 0x73, 0x85, 0x6C, 0xEF, 0xDA,
  0x47,
  // "A" (U+0041)
  0x71, 0x02, 0xA0, 0xC7, 0x20, 0x8A, 0x0D, 0x72, 0x82, 0xEE, 0xFD, 0x71, 0x83, 0x6F, 0x9F, 0xE7,
  0x18, 0x1D, 0xF3, 0xA7, 0x81, 0x5F, 0xC1, 0xA7, 0x81, 0xBF, 0x61, 0xA6, 0x03, 0xA0, 0x11, 0xA0,
  0x15, 0x81, 0xAF, 0x92, 0x81, 0xEF, 0x14, 0x01, 0xA0, 0x32, 0x81, 0xEF, 0x24, 0x81, 0x8F, 0xD3,
  0x81, 0xEF, 0x34, 0x81, 0xEF, 0x73, 0x81, 0xEF, 0x33, 0x06, 0xF9, 0x04, 0x30, 0xDF, 0x90, 0x42,
  0x04, 0xA0, 0x34, 0x81, 0xEF, 0x52, 0x81, 0xBF, 0xC5, 0x83, 0xDF, 0x60, 0x2A, 0x05, 0x58, 0x5D,
  0xF6, 0x09, 0xFD, 0x68, 0x5C, 0xF7, 0x1E, 0xF6, 0x68, 0x4B, 0xF7, 0x7F, 0xE7, 0x81, 0xBF, 0x80,
  // "B" (U+0042)
  0x40, 0xAC, 0x81, 0xD9, 0x25, 0x83, 0xDF, 0xED, 0xEA, 0x0E, 0x03, 0x30, 0x1A, 0x01, 0x28, 0x23,
  0xEF, 0xB3, 0x81, 0x4F, 0xE4, 0x07, 0xA3, 0x81, 0x7F, 0xB4, 0x05, 0xA3, 0x81, 0xBF, 0x84, 0x81,
  0x6F, 0xD3, 0x81, 0xEF, 0x54, 0x81, 0xAF, 0xA2, 0x01, 0xA0, 0x23, 0x03, 0xA0, 0x32, 0x05, 0xA2,
  0x83, 0x15, 0xEF, 0x83, 0x08, 0xE0, 0xC0, 0x54, 0x83, 0xBF, 0xED, 0xEA, 0x0C, 0x03, 0x48, 0x1E,
  0xF5, 0x28, 0x21, 0x9F, 0xE3, 0x02, 0xA0, 0x24, 0x81, 0xEF, 0x62, 0x81, 0x5F, 0xE5, 0x81, 0xBF,
  0x82, 0x81, 0x8F, 0xB5, 0x81, 0xCF, 0x72, 0x81, 0xBF, 0x84, 0x01, 0xA0, 0x52, 0x81, 0xEF, 0x44,
  0x81, 0x8F, 0xE2, 0x02, 0xA0, 0x12, 0x01, 0x08, 0xA0, 0x62, 0x05, 0xA8, 0x1D, 0xDE, 0xB0, 0x83,
  0x08, 0xC8, 0x2E, 0xD9, 0x34,
  // "C" (U+0043)
  0x68, 0x55, 0xBE, 0xED, 0x93, 0x40, 0x20, 0xCB, 0x0E, 0xA0, 0x73, 0x83, 0x1D, 0xFD, 0x42, 0x02,
  0x09, 0x48, 0x2C, 0xFC, 0x17, 0x18, 0x26, 0xFE, 0x27, 0x28, 0x1E, 0xF7, 0x72, 0x81, 0x5F, 0xE7,
  0x38, 0x1B, 0xF9, 0x73, 0xA0, 0x57, 0x20, 0x4A, 0x01, 0x72, 0x81, 0x7F, 0xD7, 0x38, 0x19, 0xFB,
  0x73, 0x81, 0xAF, 0x97, 0x38, 0x1B, 0xF9, 0x73, 0x81, 0xAF, 0xA7, 0x38, 0x18, 0xFC, 0x73, 0x04,
  0xA0, 0x37, 0x38, 0x2D, 0xFD, 0x22, 0x02, 0x06, 0x50, 0x30, 0xEA, 0x0E, 0xA0, 0xD6, 0x85, 0x2A,
  0xEF, 0xEB, 0x64,
  // "D" (U+0044)
  0x40, 0xAB, 0x81, 0xEC, 0x77, 0x82, 0xDF, 0xED, 0xB0, 0xD0, 0x14, 0x01, 0xA0, 0x12, 0x82, 0x5E,
  0xFB, 0x48, 0x14, 0xFE, 0x40, 0x5A, 0x03, 0x38, 0x17, 0xFB, 0x58, 0x1E, 0xF7, 0x38, 0x1B, 0xF7,
  0x58, 0x1C, 0xF9, 0x38, 0x1E, 0xF4, 0x58, 0x1B, 0xF9, 0x20, 0x1A, 0x01, 0x58, 0x1B, 0xF9, 0x28,
  0x15, 0xFE, 0x68, 0x1C, 0xF8, 0x28, 0x18, 0xFA, 0x6A, 0x06, 0x28, 0x1B, 0xF7, 0x50, 0x2A, 0x03,
  0x28, 0x1E, 0xF4, 0x50, 0x6A, 0x20, 0x2A, 0x01, 0x58, 0x1A, 0xFB, 0x28, 0x15, 0xFD, 0x50, 0x1A,
  0x05, 0x28, 0x18, 0xFA, 0x58, 0x18, 0xFE, 0x38, 0x1B, 0xF7, 0x40, 0x3A, 0x06, 0x38, 0x1E, 0xF4,
  0x38, 0x22, 0xDF, 0xB3, 0x02, 0xA0, 0x12, 0x83, 0x6E, 0xFC, 0x13, 0x05, 0xA0, 0xD0, 0xEB, 0x0A,
  0x01, 0x40, 0x8B, 0x82, 0xED, 0x93, 0x60,
  // "E" (U+0045)
  0x40, 0xAF, 0x01, 0x48, 0x6D, 0xFE, 0xDD, 0xDD, 0xC4, 0x01, 0xA0, 0x17, 0x28, 0x14, 0xFE, 0x73,
  0x81, 0x7F, 0xB7, 0x38, 0x1B, 0xF8, 0x73, 0x81, 0xEF, 0x57, 0x20, 0x1A, 0x02, 0x72, 0x05, 0xA7,
  0x30, 0x8F, 0x58, 0x6B, 0xFE, 0xDD, 0xDD, 0xB5, 0x81, 0xEF, 0x57, 0x20, 0x2A, 0x02, 0x72, 0x81,
  0x5F, 0xE7, 0x38, 0x18, 0xFB, 0x73, 0x81, 0xBF, 0x87, 0x38, 0x1E, 0xF4, 0x72, 0x02, 0xA0, 0x17,
  0x20, 0x5A, 0x80, 0x1D, 0x06, 0x40, 0x8F, 0x04, 0x40,
  // "F" (U+0046)
  0x40, 0xAF, 0x02, 0x48, 0x6D, 0xFE, 0xDD, 0xDD, 0xC4, 0x01, 0xA0, 0x17, 0x28, 0x14, 0xFE, 0x73,
  0x81, 0x7F, 0xB7, 0x38, 0x1B, 0xF8, 0x73, 0x81, 0xEF, 0x57, 0x20, 0x1A, 0x03, 0x72, 0x05, 0xA7,
  0x38, 0x18, 0xFD, 0x73, 0x0B, 0xE0, 0xD5, 0x86, 0xEF, 0xED, 0xDD, 0xD9, 0x40, 0x2A, 0x02, 0x72,
  0x81, 0x5F, 0xE7, 0x38, 0x18, 0xFB, 0x73, 0x81, 0xBF, 0x87, 0x38, 0x1E, 0xF4, 0x72, 0x02, 0xA0,
  0x17, 0x28, 0x15, 0xFD, 0x73, 0x81, 0x8F, 0xA7, 0x30,
  // "G" (U+0047)
  0x68, 0x64, 0xAE, 0xFE, 0xC7, 0x14, 0x01, 0x0A, 0xB0, 0xEB, 0x0D, 0x38, 0x31, 0xDF, 0xE6, 0x38,
  0x14, 0xB5, 0x38, 0x2B, 0xFD, 0x27, 0x20, 0x6A, 0x02, 0x72, 0x82, 0x1E, 0xF8, 0x73, 0x82, 0x6F,
  0xE1, 0x73, 0x81, 0xCF, 0x97, 0x30, 0x1A, 0x04, 0x73, 0x04, 0xA4, 0x89, 0x05, 0xDD, 0xDD, 0x80,
  0x7F, 0xD4, 0x09, 0xC8, 0x36, 0x09, 0xFB, 0x7A, 0x83, 0x30, 0xAF, 0xA6, 0x03, 0xA2, 0x81, 0xBF,
  0x96, 0x81, 0x6F, 0xC2, 0x81, 0xAF, 0xA6, 0x81, 0x9F, 0x92, 0x81, 0x8F, 0xD6, 0x81, 0xCF, 0x62,
  0x04, 0xA0, 0x45, 0xA0, 0x23, 0x82, 0xCF, 0xE4, 0x38, 0x15, 0xFE, 0x40, 0x20, 0xDA, 0x00, 0xEB,
  0x0C, 0x58, 0x71, 0x8C, 0xEE, 0xDB, 0x61, 0x30,
  // "H" (U+0048)
  0x48, 0x1A, 0xF8, 0x50, 0x3A, 0x48, 0x1D, 0xF5, 0x58, 0x16, 0xFC, 0x30, 0x1A, 0x02, 0x58, 0x19,
  0xF9, 0x38, 0x14, 0xFE, 0x68, 0x1C, 0xF5, 0x38, 0x17, 0xFB, 0x6A, 0x02, 0x38, 0x1A, 0xF8, 0x58,
  0x13, 0xFE, 0x48, 0x1E, 0xF5, 0x58, 0x16, 0xFB, 0x30, 0x1A, 0x02, 0x58, 0x19, 0xF8, 0x30, 0x4A,
  0x01, 0x58, 0x1C, 0xF5, 0x30, 0x8F, 0xB0, 0x23, 0x0B, 0xFA, 0x0E, 0x48, 0x1E, 0xF5, 0x58, 0x16,
  0xFB, 0x30, 0x2A, 0x02, 0x58, 0x1A, 0xF8, 0x38, 0x15, 0xFE, 0x68, 0x1D, 0xF4, 0x38, 0x18, 0xFB,
  0x50, 0x1A, 0x01, 0x38, 0x1B, 0xF8, 0x58, 0x14, 0xFE, 0x48, 0x1E, 0xF4, 0x58, 0x17, 0xFA, 0x30,
  0x2A, 0x01, 0x58, 0x1A, 0xF7, 0x38, 0x15, 0xFD, 0x68, 0x1E, 0xF4, 0x38, 0x18, 0xFA, 0x50, 0x1A,
  0x01, 0x30,
  // "I" (U+0049)
  0x30, 0x2E, 0x03, 0x38, 0x11, 0x8D, 0xA0, 0x90, 0x66, 0x81, 0x7F, 0xB7, 0x18, 0x1A, 0xF8, 0x71,
  0x81, 0xDF, 0x57, 0x01, 0xA0, 0x27, 0x81, 0x4F, 0xE7, 0x18, 0x17, 0xFB, 0x71, 0x81, 0xAF, 0x87,
  0x18, 0x1D, 0xF5, 0x70, 0x1A, 0x02, 0x78, 0x14, 0xFE, 0x71, 0x81, 0x7F, 0xB7, 0x18, 0x1B, 0xF8,
  0x71, 0x81, 0xEF, 0x57, 0x01, 0xA0, 0x17, 0x81, 0x5F, 0xE7, 0x18, 0x18, 0xFB, 0x68, 0x55, 0x9E,
  0xFD, 0x82, 0x4E, 0x05, 0x40,
  // "J" (U+004A)
  0x71, 0x81, 0xAF, 0x87, 0x18, 0x1D, 0xF5, 0x70, 0x1A, 0x02, 0x78, 0x14, 0xFE, 0x71, 0x81, 0x7F,
  0xB7, 0x18, 0x1B, 0xF8, 0x71, 0x81, 0xEF, 0x47, 0x01, 0xA0, 0x17, 0x81, 0x5F, 0xE7, 0x18, 0x18,
  0xFA, 0x71, 0x81, 0xBF, 0x77, 0x18, 0x1E, 0xF4, 0x70, 0x2A, 0x01, 0x78, 0x15, 0xFD, 0x71, 0x81,
  0x8F, 0xA7, 0x18, 0x1B, 0xF6, 0x71, 0x81, 0xEF, 0x37, 0x02, 0xA7, 0x18, 0x15, 0xFC, 0x71, 0x81,
  0x9F, 0x97, 0x18, 0x1D, 0xF5, 0x70, 0x3A, 0x01, 0x48, 0x42, 0x02, 0xDF, 0xA5, 0x0C, 0xB0, 0xD0,
  0x15, 0x83, 0xBD, 0xC8, 0x16,
  // "K" (U+004B)
  0x48, 0x1A, 0xF8, 0x48, 0x26, 0xFE, 0x24, 0x81, 0xDF, 0x53, 0x03, 0xA0, 0x54, 0x01, 0xA0, 0x12,
  0x82, 0x1D, 0xF9, 0x58, 0x14, 0xFE, 0x38, 0x1A, 0xFC, 0x68, 0x17, 0xFB, 0x28, 0x27, 0xFE, 0x26,
  0x83, 0xBF, 0x70, 0x3A, 0x05, 0x78, 0x5E, 0xF4, 0x1D, 0xF9, 0x70, 0x1A, 0x82, 0x1B, 0xFC, 0x71,
  0x85, 0x5F, 0xD6, 0xFE, 0x27, 0x18, 0x48, 0xFD, 0xEF, 0xC7, 0x20, 0xBA, 0x0E, 0xA0, 0x17, 0x18,
  0x5E, 0xFD, 0x2E, 0xF5, 0x70, 0x2A, 0x83, 0x20, 0xBF, 0x97, 0x81, 0x5F, 0xD2, 0x81, 0x7F, 0xD7,
  0x81, 0x8F, 0xA2, 0x03, 0xA0, 0x26, 0x81, 0xBF, 0x73, 0x81, 0xEF, 0x66, 0x81, 0xEF, 0x43, 0x81,
  0xAF, 0xA5, 0x02, 0xA0, 0x13, 0x81, 0x7F, 0xE5, 0x81, 0x5F, 0xD4, 0x03, 0xA0, 0x34, 0x81, 0x8F,
  0xA5, 0x81, 0xEF, 0x74,
  // "L" (U+004C)
  0x48, 0x1A, 0xF8, 0x68, 0x1D, 0xF5, 0x50, 0x1A, 0x02, 0x58, 0x14, 0xFE, 0x68, 0x17, 0xFB, 0x68,
  0x1B, 0xF8, 0x68, 0x1E, 0xF4, 0x50, 0x1A, 0x01, 0x58, 0x15, 0xFE, 0x68, 0x18, 0xFA, 0x68, 0x1B,
  0xF7, 0x68, 0x1E, 0xF4, 0x50, 0x2A, 0x01, 0x58, 0x15, 0xFD, 0x68, 0x18, 0xFA, 0x68, 0x1B, 0xF7,
  0x68, 0x1E, 0xF4, 0x50, 0x2A, 0x01, 0x50, 0x5F, 0x06, 0x08, 0xF0, 0x30,
  // "M" (U+004D)
  0x40, 0xAA, 0x08, 0x70, 0x2B, 0x06, 0x40, 0xDA, 0x09, 0x70, 0x9B, 0x03, 0x30, 0x1B, 0x0A, 0x60,
  0x1C, 0x48, 0x34, 0xFE, 0xFB, 0x68, 0x38, 0xFE, 0xFC, 0x48, 0x37, 0xFB, 0xFC, 0x68, 0x3E, 0xFB,
  0xF9, 0x48, 0x3B, 0xF7, 0xFD, 0x58, 0x46, 0xFA, 0xCF, 0x54, 0x83, 0xEF, 0x3F, 0xE5, 0x81, 0xDF,
  0x3A, 0x02, 0x30, 0x1A, 0x1A, 0x48, 0x45, 0xFB, 0x3F, 0xE4, 0x83, 0x5F, 0xC0, 0xE9, 0x48, 0x4C,
  0xF4, 0x6F, 0xB4, 0x85, 0x8F, 0x90, 0xDF, 0x12, 0x85, 0x4F, 0xC0, 0xAF, 0x84, 0x85, 0xBF, 0x60,
  0xCF, 0x22, 0x85, 0xBF, 0x50, 0xDF, 0x54, 0x89, 0x3E, 0xF2, 0x0B, 0xF3, 0x03, 0xFD, 0x01, 0xA0,
  0x23, 0x81, 0x2F, 0xE2, 0x89, 0x1A, 0xF4, 0x0A, 0xF6, 0x04, 0xFE, 0x48, 0x15, 0xFB, 0x28, 0x49,
  0xF5, 0x2F, 0xE2, 0x81, 0x7F, 0xB4, 0x81, 0x8F, 0x82, 0x84, 0x8F, 0x69, 0xF7, 0x28, 0x1A, 0xF8,
  0x48, 0x1B, 0xF5, 0x28, 0x37, 0xF8, 0xEE, 0x38, 0x1D, 0xF5, 0x48, 0x1E, 0xF2, 0x28, 0x36, 0xFE,
  0xF8, 0x20, 0x1A, 0x02, 0x38, 0x12, 0xFE, 0x30, 0x5B, 0x01, 0x28, 0x14, 0xFE, 0x48, 0x15, 0xFB,
  0x30, 0x4A, 0x09, 0x38, 0x18, 0xFB, 0x48, 0x18, 0xF8, 0x30, 0x3A, 0x02, 0x38, 0x1B, 0xF8, 0x40,
  // "N" (U+004E)
  0x40, 0xAA, 0x01, 0x58, 0x15, 0xFC, 0x40, 0xDA, 0x04, 0x58, 0x18, 0xF9, 0x30, 0x1B, 0x08, 0x58,
  0x1B, 0xF6, 0x30, 0x4B, 0x0B, 0x58, 0x1E, 0xF2, 0x38, 0x37, 0xF9, 0xFE, 0x48, 0x12, 0xFE, 0x48,
  0x4B, 0xF5, 0xEF, 0x23, 0x81, 0x5F, 0xC4, 0x84, 0xEF, 0x2A, 0xF6, 0x38, 0x19, 0xF8, 0x30, 0x1A,
  0x18, 0x17, 0xF9, 0x38, 0x1C, 0xF5, 0x38, 0x55, 0xFC, 0x03, 0xFC, 0x3A, 0x02, 0x38, 0x18, 0xF9,
  0x2A, 0x28, 0x13, 0xFE, 0x48, 0x1B, 0xF6, 0x28, 0x5C, 0xF4, 0x06, 0xFB, 0x48, 0x1E, 0xF3, 0x28,
  0x59, 0xF7, 0x09, 0xF8, 0x30, 0x2A, 0x38, 0x55, 0xFA, 0x0C, 0xF5, 0x38, 0x15, 0xFC, 0x38, 0x52,
  0xFE, 0x0E, 0xF2, 0x38, 0x18, 0xF9, 0x48, 0x3E, 0xF4, 0xFE, 0x48, 0x1B, 0xF5, 0x48, 0x3B, 0xFA,
  0xFB, 0x48, 0x1E, 0xF2, 0x40, 0x7B, 0x07, 0x38, 0x12, 0xFE, 0x50, 0x4B, 0x04, 0x38, 0x15, 0xFB,
  0x6B, 0x01, 0x38, 0x18, 0xF8, 0x68, 0x1C, 0xFD, 0x40,
  // "O" (U+004F)
  0x58, 0x51, 0x8D, 0xEE, 0xA3, 0x60, 0x40, 0xEA, 0x0E, 0xB0, 0x44, 0x89, 0x03, 0xEF, 0x91, 0x01,
  0xBF, 0xE4, 0x81, 0xDF, 0x94, 0x01, 0xA0, 0x52, 0x81, 0x8F, 0xD6, 0x86, 0xCF, 0x80, 0x1E, 0xF6,
  0x68, 0x6A, 0xFA, 0x07, 0xFE, 0x16, 0x85, 0xAF, 0xA0, 0xCF, 0x97, 0x82, 0xBF, 0x91, 0xA0, 0x57,
  0x82, 0xDF, 0x84, 0xA0, 0x27, 0x84, 0xEF, 0x67, 0xFE, 0x70, 0x3A, 0x82, 0x39, 0xFB, 0x78, 0x56,
  0xFE, 0x0B, 0xFA, 0x78, 0x5A, 0xFA, 0x0B, 0xF9, 0x78, 0x5E, 0xF5, 0x0B, 0xF9, 0x68, 0x16, 0xFE,
  0x28, 0x19, 0xFB, 0x68, 0x1D, 0xF7, 0x20, 0x6A, 0x01, 0x48, 0x19, 0xFD, 0x38, 0x61, 0xEF, 0xB1,
  0x01, 0xAA, 0x03, 0x40, 0x5B, 0x0E, 0xA0, 0xE0, 0x46, 0x85, 0x3B, 0xEF, 0xD8, 0x15,
  // "P" (U+0050)
  0x40, 0xAB, 0x81, 0xEC, 0x56, 0x82, 0xDF, 0xEE, 0xB0, 0x84, 0x01, 0xA8, 0x21, 0x01, 0x9A, 0x02,
  0x38, 0x14, 0xFE, 0x48, 0x1E, 0xF7, 0x38, 0x17, 0xFA, 0x48, 0x1C, 0xF8, 0x38, 0x1B, 0xF7, 0x48,
  0x1C, 0xF7, 0x38, 0x1E, 0xF4, 0x48, 0x1E, 0xF5, 0x20, 0x1A, 0x01, 0x30, 0x4A, 0x01, 0x28, 0x15,
  0xFD, 0x48, 0x1C, 0xFA, 0x38, 0x18, 0xFA, 0x28, 0x33, 0xCF, 0xE1, 0x38, 0x2B, 0xFE, 0xDB, 0x0D,
  0x02, 0x40, 0xEB, 0x81, 0xDB, 0x65, 0x02, 0xA7, 0x38, 0x15, 0xFD, 0x73, 0x81, 0x8F, 0xA7, 0x38,
  0x1B, 0xF7, 0x73, 0x81, 0xEF, 0x37, 0x20, 0x2A, 0x01, 0x72, 0x81, 0x5F, 0xD7, 0x38, 0x18, 0xFA,
  0x73,
  // "Q" (U+0051)
  0x58, 0x51, 0x7D, 0xEE, 0xA3, 0x60, 0x30, 0xEA, 0x0E, 0xB0, 0x44, 0x89, 0x03, 0xEF, 0x91, 0x01,
  0xBF, 0xE4, 0x81, 0xDF, 0x94, 0x01, 0xA0, 0x52, 0x81, 0x8F, 0xD6, 0x86, 0xCF, 0x80, 0x1E, 0xF6,
  0x68, 0x6A, 0xFA, 0x06, 0xFE, 0x16, 0x85, 0xAF, 0xA0, 0xCF, 0x97, 0x82, 0xBF, 0x91, 0xA0, 0x57,
  0x82, 0xDF, 0x84, 0xA0, 0x27, 0x84, 0xEF, 0x67, 0xFE, 0x70, 0x3A, 0x82, 0x39, 0xFB, 0x70, 0x6A,
  0x18, 0x1B, 0xFA, 0x78, 0x5A, 0xFB, 0x0B, 0xF9, 0x78, 0x5E, 0xF6, 0x0B, 0xF9, 0x68, 0x66, 0xFE,
  0x10, 0x9F, 0xB6, 0x81, 0xDF, 0x82, 0x06, 0xA0, 0x14, 0x82, 0x9F, 0xE1, 0x28, 0x61, 0xEF, 0xB1,
  0x01, 0xAA, 0x04, 0x40, 0x6B, 0x0E, 0xB0, 0x56, 0x81, 0x5B, 0xEA, 0x0D, 0x02, 0x73, 0x04, 0xA0,
  0x17, 0x48, 0x1E, 0xF8, 0x74, 0x81, 0x8F, 0xE7, 0x40, 0x2A, 0x06, 0x74, 0x81, 0x67, 0x54,
  // "R" (U+0052)
  0x40, 0xAB, 0x81, 0xEB, 0x56, 0x82, 0xDF, 0xEE, 0xB0, 0x84, 0x01, 0xA8, 0x21, 0x01, 0xAA, 0x03,
  0x38, 0x14, 0xFE, 0x48, 0x1E, 0xF7, 0x38, 0x17, 0xFB, 0x48, 0x1C, 0xF9, 0x38, 0x1B, 0xF8, 0x48,
  0x1C, 0xF8, 0x38, 0x1E, 0xF5, 0x48, 0x1E, 0xF6, 0x20, 0x1A, 0x02, 0x30, 0x3A, 0x02, 0x28, 0x15,
  0xFE, 0x48, 0x1C, 0xFB, 0x38, 0x18, 0xFB, 0x20, 0x30, 0xBA, 0x02, 0x30, 0xBE, 0x0E, 0x04, 0x48,
  0x2E, 0xFE, 0xDA, 0x09, 0x50, 0x2A, 0x83, 0x20, 0x9F, 0x95, 0x81, 0x5F, 0xE2, 0x81, 0x5F, 0xD5,
  0x81, 0x8F, 0xB2, 0x02, 0xA0, 0x24, 0x81, 0xBF, 0x73, 0x81, 0xEF, 0x64, 0x81, 0xEF, 0x43, 0x81,
  0xAF, 0xA3, 0x02, 0xA0, 0x13, 0x81, 0x7F, 0xE3, 0x81, 0x5F, 0xD4, 0x03, 0xA0, 0x22, 0x81, 0x8F,
  0xA5, 0xA0, 0x62,
  // "S" (U+0053)
  0x68, 0x57, 0xCE, 0xFD, 0x94, 0x40, 0x20, 0xDA, 0x00, 0xEA, 0x0A, 0x48, 0x2C, 0xFD, 0x32, 0x81,
  0x3A, 0x23, 0x82, 0x5F, 0xE2, 0x72, 0x81, 0x8F, 0xB7, 0x38, 0x1A, 0xFA, 0x73, 0x81, 0x9F, 0xD7,
  0x30, 0x6A, 0x08, 0x73, 0x0D, 0xA0, 0x77, 0x20, 0x20, 0xEA, 0x07, 0x72, 0x03, 0x0E, 0xA0, 0x67,
  0x20, 0x20, 0xEA, 0x01, 0x72, 0x04, 0xA0, 0x77, 0x38, 0x1C, 0xF9, 0x73, 0x81, 0xAF, 0xA7, 0x38,
  0x1C, 0xF8, 0x72, 0x02, 0xA0, 0x42, 0x81, 0x1B, 0x43, 0x82, 0x5D, 0xFB, 0x30, 0x3B, 0x0E, 0xB0,
  0xC0, 0x13, 0x86, 0x18, 0xCE, 0xFE, 0xC6, 0x50,
  // "T" (U+0054)
  0x07, 0xFA, 0x00, 0x90, 0xFD, 0xA8, 0x3E, 0xDD, 0xD5, 0x4A, 0x03, 0x70, 0x3A, 0x71, 0x81, 0x6F,
  0xD7, 0x18, 0x19, 0xFA, 0x71, 0x81, 0xCF, 0x67, 0x1A, 0x03, 0x70, 0x3A, 0x71, 0x81, 0x6F, 0xD7,
  0x18, 0x19, 0xF9, 0x71, 0x81, 0xCF, 0x67, 0x1A, 0x03, 0x70, 0x3A, 0x71, 0x81, 0x6F, 0xC7, 0x18,
  0x19, 0xF9, 0x71, 0x81, 0xCF, 0x67, 0x1A, 0x03, 0x70, 0x3A, 0x71, 0x81, 0x6F, 0xC7, 0x10,
  // "U" (U+0055)
  0x38, 0x1D, 0xF5, 0x58, 0x15, 0xFD, 0x3A, 0x02, 0x58, 0x18, 0xFA, 0x28, 0x14, 0xFE, 0x68, 0x1C,
  0xF7, 0x28, 0x17, 0xFB, 0x68, 0x1E, 0xF3, 0x28, 0x1A, 0xF8, 0x50, 0x3A, 0x38, 0x1D, 0xF5, 0x58,
  0x16, 0xFC, 0x20, 0x1A, 0x02, 0x58, 0x19, 0xF9, 0x28, 0x14, 0xFE, 0x68, 0x1C, 0xF6, 0x28, 0x18,
  0xFB, 0x6A, 0x03, 0x28, 0x1B, 0xF7, 0x50, 0x3A, 0x38, 0x1E, 0xF4, 0x58, 0x17, 0xFC, 0x20, 0x2A,
  0x01, 0x58, 0x1A, 0xF8, 0x28, 0x15, 0xFD, 0x68, 0x1D, 0xF5, 0x28, 0x18, 0xFA, 0x50, 0x1A, 0x02,
  0x28, 0x1A, 0xF8, 0x58, 0x15, 0xFD, 0x38, 0x1B, 0xF8, 0x58, 0x1B, 0xF9, 0x38, 0x19, 0xFB, 0x40,
  0x3A, 0x02, 0x30, 0x5A, 0x85, 0x71, 0x15, 0xEF, 0x95, 0x0C, 0xE0, 0xB7, 0x84, 0x8D, 0xFE, 0xB6,
  0x60,
  // "V" (U+0056)
  0x81, 0x9F, 0xA6, 0x03, 0xA8, 0x22, 0x8F, 0xA6, 0x85, 0xAF, 0xB0, 0x8F, 0xA5, 0x01, 0xA8, 0x34,
  0x07, 0xFB, 0x58, 0x17, 0xFD, 0x28, 0x17, 0xFB, 0x58, 0x1E, 0xF6, 0x28, 0x16, 0xFB, 0x48, 0x15,
  0xFE, 0x38, 0x16, 0xFC, 0x48, 0x1C, 0xF8, 0x38, 0x15, 0xFC, 0x30, 0x3A, 0x01, 0x38, 0x15, 0xFC,
  0x38, 0x19, 0xFA, 0x48, 0x14, 0xFD, 0x20, 0x1A, 0x03, 0x48, 0x14, 0xFD, 0x28, 0x17, 0xFB, 0x58,
  0x13, 0xFD, 0x28, 0x1D, 0xF5, 0x58, 0x52, 0xFE, 0x05, 0xFD, 0x68, 0x52, 0xFE, 0x0B, 0xF7, 0x68,
  0x41, 0xFE, 0x2F, 0xE7, 0x84, 0x1F, 0xE8, 0xF8, 0x71, 0x98, 0x2D, 0xDF, 0x27, 0x1B, 0x0A, 0x72,
  0xB0, 0x37, 0x28, 0x1E, 0xFC, 0x72,
  // "W" (U+0057)
  0x81, 0x7F, 0xA5, 0x04, 0xA5, 0x01, 0xA8, 0x24, 0x7F, 0xA5, 0x0A, 0xA5, 0x85, 0x6F, 0xD0, 0x7F,
  0xA4, 0x01, 0xB5, 0x85, 0xCF, 0x70, 0x7F, 0xA4, 0x07, 0xB4, 0x03, 0xA8, 0x31, 0x07, 0xFA, 0x48,
  0x1D, 0xFD, 0x94, 0x81, 0x9F, 0xA2, 0x81, 0x7F, 0x93, 0x82, 0x3F, 0xAD, 0x94, 0x81, 0xEF, 0x42,
  0x81, 0x7F, 0x93, 0x82, 0x9F, 0x4D, 0x93, 0x81, 0x5F, 0xD3, 0x81, 0x8F, 0x92, 0x83, 0x1F, 0xD0,
  0xD9, 0x38, 0x1B, 0xF7, 0x38, 0x18, 0xF9, 0x28, 0x36, 0xF7, 0x0D, 0x92, 0x02, 0xA0, 0x13, 0x81,
  0x8F, 0x92, 0x84, 0xCF, 0x10, 0xEE, 0x28, 0x18, 0xFA, 0x48, 0x58, 0xF9, 0x03, 0xFB, 0x20, 0x0E,
  0x28, 0x1D, 0xF4, 0x48, 0x58, 0xF8, 0x09, 0xF5, 0x28, 0x4E, 0xE0, 0x4F, 0xD5, 0x84, 0x8F, 0x80,
  0xEE, 0x38, 0x4E, 0xE0, 0xAF, 0x75, 0x84, 0x8F, 0x86, 0xF8, 0x38, 0x1E, 0xD1, 0xA0, 0x15, 0x84,
  0x8F, 0x7C, 0xF2, 0x39, 0x82, 0xD6, 0xFA, 0x68, 0x38, 0xF8, 0xFB, 0x49, 0x82, 0xDB, 0xF4, 0x68,
  0x38, 0xFD, 0xF5, 0x49, 0x81, 0xEF, 0xD7, 0x08, 0xA0, 0xE5, 0xB0, 0x77, 0x08, 0xA0, 0x85, 0xB0,
  0x17, 0x08, 0xA0, 0x25, 0xA0, 0xA7, 0x10,
  // "X" (U+0058)
  0x58, 0x1E, 0xF5, 0x48, 0x26, 0xFE, 0x15, 0x81, 0xBF, 0x74, 0x81, 0xEF, 0x56, 0x81, 0x8F, 0xA3,
  0x81, 0x8F, 0xB7, 0x81, 0x5F, 0xD2, 0x02, 0xA0, 0x27, 0x02, 0xA2, 0x81, 0xAF, 0x87, 0x28, 0x4E,
  0xF3, 0x3F, 0xE7, 0x38, 0x4B, 0xF6, 0xCF, 0x57, 0x38, 0x38, 0xFD, 0xFB, 0x74, 0x04, 0xB0, 0x27,
  0x40, 0x3A, 0x09, 0x75, 0x0B, 0xA0, 0x87, 0x40, 0x5B, 0x0B, 0x74, 0x83, 0xDF, 0x7F, 0xE7, 0x38,
  0x18, 0xFB, 0x1A, 0x02, 0x71, 0x02, 0xA8, 0x32, 0x0D, 0xF5, 0x71, 0x81, 0xCF, 0x82, 0x81, 0xAF,
  0x87, 0x81, 0x6F, 0xD3, 0x81, 0x7F, 0xB6, 0x82, 0x1E, 0xF5, 0x38, 0x15, 0xFE, 0x68, 0x19, 0xFB,
  0x40, 0x2A, 0x02, 0x40, 0x3A, 0x02, 0x5A, 0x05, 0x40,
  // "Y" (U+0059)
  0x81, 0x9F, 0xA5, 0x84, 0x7F, 0xE6, 0xFC, 0x58, 0x4E, 0xF6, 0x4F, 0xE4, 0x83, 0x7F, 0xD0, 0x2A,
  0x01, 0x28, 0x21, 0xEF, 0x42, 0xA0, 0x32, 0x81, 0x8F, 0xB3, 0x83, 0xDF, 0x40, 0x1A, 0x03, 0x38,
  0x5B, 0xF6, 0x09, 0xF9, 0x48, 0x28, 0xF8, 0x2A, 0x01, 0x48, 0x46, 0xFA, 0x9F, 0x85, 0x83, 0x4F,
  0xEF, 0xE6, 0x01, 0xB0, 0x67, 0xA0, 0xD7, 0x18, 0x1D, 0xF6, 0x70, 0x1A, 0x02, 0x78, 0x14, 0xFE,
  0x71, 0x81, 0x7F, 0xB7, 0x18, 0x1A, 0xF8, 0x71, 0x81, 0xDF, 0x57, 0x01, 0xA0, 0x27, 0x81, 0x4F,
  0xE7, 0x10,
  // "Z" (U+005A)
  0x40, 0xBF, 0x94, 0x0C, 0x80, 0x1D, 0xA0, 0xD7, 0x20, 0x3A, 0x06, 0x72, 0x81, 0xCF, 0xC7, 0x20,
  0x6A, 0x03, 0x71, 0x82, 0x1E, 0xF9, 0x72, 0x82, 0x8F, 0xE1, 0x71, 0x02, 0xA0, 0x67, 0x28, 0x1B,
  0xFC, 0x72, 0x05, 0xA0, 0x37, 0x28, 0x1D, 0xF9, 0x72, 0x82, 0x8F, 0xE1, 0x71, 0x02, 0xA0, 0x77,
  0x28, 0x1B, 0xFC, 0x72, 0x04, 0xA0, 0x47, 0x28, 0x1D, 0xFA, 0x72, 0x82, 0x7F, 0xE1, 0x71, 0x82,
  0x1E, 0xF7, 0x72, 0x08, 0xA0, 0xE8, 0x01, 0xD0, 0x83, 0x0B, 0xF9, 0x06, 0x30,
  // "[" (U+005B)
  0x50, 0x9C, 0x07, 0x58, 0x4D, 0xFD, 0xDD, 0x45, 0x90, 0xE7, 0x18, 0x14, 0xFB, 0x71, 0x81, 0x7F,
  0x87, 0x18, 0x1A, 0xF5, 0x71, 0x81, 0xDF, 0x27, 0x81, 0x1F, 0xE7, 0x18, 0x14, 0xFB, 0x71, 0x81,
  0x8F, 0x77, 0x18, 0x1B, 0xF4, 0x71, 0x81, 0xEF, 0x17, 0x81, 0x2F, 0xD7, 0x18, 0x15, 0xFA, 0x71,
  0x81, 0x9F, 0x67, 0x18, 0x1C, 0xF3, 0x71, 0xA7, 0x18, 0x13, 0xFC, 0x71, 0x81, 0x6F, 0x97, 0x18,
  0x1A, 0xF6, 0x71, 0x81, 0xDF, 0x27, 0x81, 0x1F, 0xE7, 0x10, 0x4A, 0x81, 0xDD, 0xB5, 0x07, 0xC0,
  0xA5,
  // "\" (U+005C)
  0x81, 0x2F, 0xD4, 0xA4, 0x81, 0xEF, 0x13, 0x81, 0xCF, 0x33, 0x81, 0xAF, 0x53, 0x81, 0x8F, 0x73,
  0x81, 0x6F, 0x93, 0x81, 0x4F, 0xB3, 0x81, 0x2F, 0xD4, 0xA4, 0x81, 0xDF, 0x13, 0x81, 0xBF, 0x33,
  0x81, 0x9F, 0x53, 0x81, 0x7F, 0x73, 0x81, 0x6F, 0x93, 0x81, 0x4F, 0xB3, 0x81, 0x2F, 0xD4, 0xA4,
  0x81, 0xDF, 0x23, 0x81, 0xBF, 0x40,
  // "]" (U+005D)
  0x50, 0xDC, 0x03, 0x40, 0x10, 0xFD, 0xA7, 0x18, 0x13, 0xFC, 0x71, 0x81, 0x6F, 0x97, 0x18, 0x1A,
  0xF6, 0x71, 0x81, 0xDF, 0x27, 0x81, 0x1F, 0xE7, 0x18, 0x14, 0xFB, 0x71, 0x81, 0x7F, 0x87, 0x18,
  0x1A, 0xF5, 0x71, 0x81, 0xEF, 0x17, 0x81, 0x1F, 0xE7, 0x18, 0x15, 0xFA, 0x71, 0x81, 0x8F, 0x77,
  0x18, 0x1B, 0xF4, 0x71, 0x81, 0xEF, 0x17, 0x81, 0x2F, 0xD7, 0x18, 0x16, 0xF9, 0x71, 0x81, 0x9F,
  0x67, 0x18, 0x1C, 0xF3, 0x71, 0xA7, 0x18, 0x13, 0xFC, 0x58, 0x47, 0xDD, 0xEF, 0x95, 0x0B, 0xC0,
  0x55,
  // "^" (U+005E)
  0x68, 0x1A, 0xF2, 0x71, 0x03, 0xA0, 0x77, 0x10, 0xCA, 0x0D, 0x78, 0x45, 0xF9, 0xCF, 0x36, 0x84,
  0xDF, 0x17, 0xF8, 0x58, 0x56, 0xF8, 0x01, 0xFD, 0x48, 0x21, 0xEE, 0x12, 0x81, 0xBF, 0x33, 0x81,
  0x8F, 0x73, 0x81, 0x6F, 0x92, 0x81, 0x2F, 0xD4, 0x81, 0x1F, 0xE2, 0x81, 0xAF, 0x65, 0x84, 0xAF,
  0x43, 0xFD, 0x68, 0x15, 0xF9,
  // "_" (U+005F)
  0x01, 0x80, 0x4D, 0x0B, 0x04, 0xF9, 0x0A,
  // "`" (U+0060)
  0x89, 0x15, 0x52, 0x0B, 0xFA, 0x03, 0xFE, 0x28, 0x19, 0xF5, 0x20, 0xD0, 0xB0,
  // "a" (U+0061)
  0x48, 0x71, 0x9E, 0xE8, 0x08, 0xF4, 0x30, 0x20, 0xEA, 0x84, 0xEF, 0x6C, 0xF1, 0x38, 0x7D, 0xFC,
  0x10, 0x7E, 0xFD, 0x38, 0x27, 0xFE, 0x13, 0xA0, 0xA3, 0x81, 0xDF, 0x64, 0x81, 0xEF, 0x72, 0x04,
  0xA5, 0xA0, 0x42, 0x81, 0x9F, 0xB4, 0x01, 0xA3, 0x81, 0xCF, 0x74, 0x81, 0x4F, 0xD3, 0x81, 0xEF,
  0x44, 0x81, 0x8F, 0xA3, 0xA0, 0x24, 0x81, 0xEF, 0x62, 0x02, 0xA0, 0x13, 0x05, 0xA0, 0x32, 0x01,
  0xA0, 0x23, 0x0D, 0xA4, 0x87, 0xEF, 0x90, 0x1B, 0xDF, 0xC4, 0x07, 0xA8, 0x4E, 0xFC, 0x5F, 0x95,
  0x86, 0x9E, 0xE9, 0x15, 0xF6, 0x30,
  // "b" (U+0062)
  0x48, 0x18, 0xF9, 0x72, 0x81, 0xBF, 0x67, 0x28, 0x1E, 0xF3, 0x71, 0x02, 0xA7, 0x28, 0x15, 0xFC,
  0x72, 0x81, 0x8F, 0x97, 0x28, 0x6C, 0xF5, 0x3B, 0xED, 0x44, 0xA8, 0x16, 0xEE, 0xB0, 0x12, 0x03,
  0xA8, 0x5E, 0x70, 0x1D, 0xF8, 0x20, 0x6A, 0x08, 0x38, 0x18, 0xFA, 0x28, 0x19, 0xFE, 0x48, 0x17,
  0xFB, 0x28, 0x1C, 0xF8, 0x48, 0x18, 0xFA, 0x2A, 0x02, 0x48, 0x5A, 0xF8, 0x03, 0xFE, 0x58, 0x5D,
  0xF6, 0x06, 0xFA, 0x40, 0x2A, 0x83, 0x30, 0xAF, 0x84, 0x81, 0x7F, 0xE2, 0x81, 0xDF, 0x74, 0x83,
  0xCF, 0x80, 0x1A, 0x08, 0x30, 0x5A, 0x89, 0x21, 0x04, 0xFE, 0xE2, 0x04, 0xEF, 0x72, 0x84, 0x7F,
  0x6D, 0xFE, 0xA0, 0xA3, 0x86, 0xAF, 0x12, 0xCE, 0xD6, 0x40,
  // "c" (U+0063)
  0x58, 0x48, 0xDF, 0xDA, 0x13, 0x01, 0x0D, 0xA8, 0x1E, 0xFE, 0x48, 0x5C, 0xFB, 0x20, 0x14, 0x38,
  0x17, 0xFD, 0x71, 0x81, 0xEF, 0x47, 0x81, 0x5F, 0xD7, 0x18, 0x19, 0xF9, 0x71, 0x81, 0xDF, 0x57,
  0x1A, 0x03, 0x70, 0x1A, 0x01, 0x70, 0x1A, 0x01, 0x71, 0xA0, 0x47, 0x18, 0x5C, 0xFC, 0x10, 0x16,
  0x40, 0x4B, 0x81, 0xEF, 0xD5, 0x84, 0x4C, 0xFE, 0xB5, 0x30,
  // "d" (U+0064)
  0x74, 0x81, 0x9F, 0x87, 0x48, 0x1C, 0xF5, 0x74, 0xA0, 0x27, 0x38, 0x13, 0xFE, 0x74, 0x81, 0x6F,
  0xB7, 0x48, 0x19, 0xF8, 0x58, 0x72, 0xAE, 0xE8, 0x0C, 0xF4, 0x40, 0x20, 0xEA, 0x84, 0xEF, 0x7E,
  0xF1, 0x48, 0x7D, 0xFB, 0x10, 0x6E, 0xFD, 0x48, 0x27, 0xFE, 0x13, 0x81, 0xEF, 0xA4, 0x81, 0xEF,
  0x74, 0x81, 0xDF, 0x73, 0x04, 0xA0, 0x14, 0x81, 0xEF, 0x43, 0x81, 0x8F, 0xB4, 0x01, 0xA0, 0x13,
  0x81, 0xCF, 0x74, 0x81, 0x5F, 0xD4, 0x81, 0xEF, 0x44, 0x81, 0x9F, 0xA4, 0xA0, 0x24, 0x81, 0xEF,
  0x63, 0x02, 0xA0, 0x13, 0x06, 0xA0, 0x33, 0x01, 0xA0, 0x22, 0x01, 0x0D, 0xA5, 0x87, 0xEF, 0x90,
  0x1B, 0xDF, 0xC5, 0x08, 0xA8, 0x4E, 0xFC, 0x5F, 0x96, 0x86, 0x9E, 0xE9, 0x06, 0xF6, 0x40,
  // "e" (U+0065)
  0x48, 0x41, 0x8D, 0xED, 0x64, 0x02, 0x0D, 0xA0, 0xEA, 0x04, 0x38, 0x1C, 0xF9, 0x28, 0x19, 0xF9,
  0x28, 0x18, 0xFB, 0x38, 0x66, 0xF9, 0x01, 0xEF, 0x23, 0x85, 0xCF, 0x60, 0x5F, 0xB2, 0x82, 0x4C,
  0xFD, 0x28, 0x2A, 0xFE, 0xEB, 0x0C, 0x01, 0x20, 0xDA, 0x82, 0xED, 0xA5, 0x4A, 0x02, 0x70, 0x1A,
  0x71, 0x02, 0xA0, 0x17, 0x1A, 0x04, 0x71, 0x82, 0xCF, 0xD2, 0x20, 0x40, 0x73, 0x03, 0xB0, 0xEA,
  0x0A, 0x48, 0x53, 0xBE, 0xED, 0x82, 0x20,
  // "f" (U+0066)
  0x72, 0x83, 0x2B, 0xEE, 0xB7, 0x10, 0x10, 0xEA, 0x0E, 0x0A, 0x71, 0x84, 0x7F, 0xC1, 0x01, 0x71,
  0x81, 0xDF, 0x57, 0x30, 0x1A, 0x01, 0x73, 0x81, 0x5F, 0xC7, 0x28, 0x12, 0x8E, 0xB0, 0xE7, 0x08,
  0x0D, 0xA8, 0x1E, 0xDA, 0x72, 0x81, 0xEF, 0x37, 0x30, 0x2A, 0x74, 0x81, 0x6F, 0xC7, 0x48, 0x19,
  0xF8, 0x74, 0x81, 0xCF, 0x57, 0x4A, 0x02, 0x73, 0x81, 0x4F, 0xE7, 0x48, 0x17, 0xFA, 0x74, 0x81,
  0xAF, 0x77, 0x48, 0x1D, 0xF4, 0x73, 0x01, 0xA0, 0x17, 0x38, 0x15, 0xFD, 0x74, 0x81, 0x8F, 0x97,
  0x48, 0x1B, 0xF6, 0x74, 0xA0, 0x27, 0x38, 0x14, 0xFE, 0x74, 0x81, 0xBF, 0x87, 0x10, 0x30, 0xEA,
  0x0E, 0x01, 0x71, 0x83, 0x3E, 0xEB, 0x37, 0x20,
  // "g" (U+0067)
  0x58, 0x71, 0x9E, 0xE9, 0x08, 0xF4, 0x40, 0x20, 0xDA, 0x84, 0xEF, 0x7C, 0xF1, 0x48, 0x7C, 0xFC,
  0x10, 0x6E, 0xFD, 0x48, 0x27, 0xFE, 0x13, 0x81, 0xEF, 0xA4, 0x81, 0xDF, 0x74, 0x81, 0xEF, 0x63,
  0x04, 0xA0, 0x14, 0xA0, 0x33, 0x81, 0x8F, 0xB4, 0x02, 0xA4, 0x81, 0xCF, 0x74, 0x81, 0x5F, 0xC4,
  0x81, 0xEF, 0x44, 0x81, 0x9F, 0x94, 0xA0, 0x23, 0x82, 0x1E, 0xF6, 0x30, 0x1A, 0x01, 0x30, 0x7A,
  0x02, 0x30, 0x1A, 0x02, 0x28, 0x21, 0xEF, 0xE5, 0x87, 0xEF, 0x90, 0x1C, 0xEF, 0xB5, 0x08, 0xA8,
  0x4E, 0xFD, 0x9F, 0x86, 0x86, 0x9E, 0xE9, 0x1B, 0xF5, 0x74, 0xA0, 0x17, 0x38, 0x15, 0xFD, 0x74,
  0x81, 0xCF, 0x74, 0x81, 0x28, 0x22, 0x83, 0x2A, 0xFE, 0x14, 0x03, 0xA0, 0x0E, 0xA0, 0xE0, 0x36,
  0x85, 0x7B, 0xEF, 0xD9, 0x26,
  // "h" (U+0068)
  0x48, 0x18, 0xF9, 0x72, 0x81, 0xBF, 0x67, 0x28, 0x1E, 0xF3, 0x71, 0x02, 0xA7, 0x28, 0x15, 0xFC,
  0x72, 0x81, 0x8F, 0x97, 0x28, 0x6C, 0xF5, 0x4C, 0xED, 0x44, 0xA8, 0x17, 0xFE, 0xB0, 0x22, 0x03,
  0xA8, 0x5E, 0x50, 0x1E, 0xF5, 0x20, 0x6A, 0x06, 0x38, 0x1C, 0xF6, 0x28, 0x19, 0xFD, 0x48, 0x1D,
  0xF4, 0x28, 0x1C, 0xF7, 0x4A, 0x02, 0x2A, 0x03, 0x38, 0x13, 0xFE, 0x28, 0x13, 0xFE, 0x48, 0x16,
  0xFB, 0x28, 0x16, 0xFB, 0x48, 0x1A, 0xF8, 0x28, 0x1A, 0xF8, 0x48, 0x1D, 0xF5, 0x28, 0x1D, 0xF5,
  0x30, 0x1A, 0x81, 0x10, 0x1A, 0x02, 0x38, 0x14, 0xFE, 0x28, 0x14, 0xFE, 0x48, 0x17, 0xFA, 0x28,
  0x17, 0xFB, 0x48, 0x1A, 0xF7, 0x28, 0x1A, 0xF7, 0x48, 0x1D, 0xF4, 0x20,
  // "i" (U+0069)
  0x48, 0x18, 0xE5, 0x4A, 0x07, 0x48, 0x1D, 0xD1, 0x77, 0x73, 0x81, 0xCF, 0x54, 0xA0, 0x23, 0x81,
  0x3F, 0xE4, 0x81, 0x6F, 0xB4, 0x81, 0x9F, 0x84, 0x81, 0xCF, 0x54, 0xA0, 0x13, 0x81, 0x3F, 0xE4,
  0x81, 0x7F, 0xB4, 0x81, 0xAF, 0x74, 0x81, 0xDF, 0x43, 0x01, 0xA0, 0x13, 0x81, 0x4F, 0xD4, 0x81,
  0x7F, 0xA4, 0x81, 0xAF, 0x74,
  // "j" (U+006A)
  0x71, 0x81, 0x8E, 0x57, 0x1A, 0x07, 0x71, 0x81, 0xDD, 0x18, 0x0C, 0x40, 0x81, 0xCF, 0x57, 0x1A,
  0x02, 0x78, 0x13, 0xFE, 0x71, 0x81, 0x6F, 0xB7, 0x18, 0x1A, 0xF7, 0x71, 0x81, 0xDF, 0x47, 0x01,
  0xA0, 0x17, 0x81, 0x4F, 0xD7, 0x18, 0x17, 0xFA, 0x71, 0x81, 0xAF, 0x67, 0x18, 0x1E, 0xF3, 0x70,
  0x1A, 0x71, 0x81, 0x5F, 0xC7, 0x18, 0x18, 0xF9, 0x71, 0x81, 0xBF, 0x57, 0x18, 0x1E, 0xF2, 0x78,
  0x12, 0xFE, 0x71, 0x81, 0x7F, 0xA7, 0x82, 0x1E, 0xF5, 0x50, 0x70, 0xEA, 0x0C, 0x68, 0x35, 0xEE,
  0xA1, 0x60,
  // "k" (U+006B)
  0x48, 0x17, 0xF9, 0x72, 0x81, 0xBF, 0x67, 0x28, 0x1E, 0xF3, 0x71, 0x02, 0xA7, 0x28, 0x15, 0xFC,
  0x72, 0x81, 0x8F, 0x97, 0x28, 0x1B, 0xF6, 0x38, 0x1D, 0xF7, 0x38, 0x1E, 0xF2, 0x28, 0x1A, 0xFB,
  0x38, 0x12, 0xFE, 0x28, 0x27, 0xFD, 0x13, 0x86, 0x6F, 0xB0, 0x4F, 0xE2, 0x48, 0x59, 0xF8, 0x1E,
  0xF5, 0x58, 0x4C, 0xF4, 0xCF, 0x86, 0xA0, 0xAA, 0x01, 0x50, 0x3D, 0x05, 0x50, 0x6A, 0x82, 0x9A,
  0xF9, 0x58, 0x59, 0xFA, 0x06, 0xFC, 0x58, 0x3D, 0xF4, 0x02, 0xA0, 0x14, 0xA0, 0x12, 0x81, 0xEF,
  0x53, 0x81, 0x4F, 0xD3, 0x81, 0xAF, 0x93, 0x81, 0x7F, 0xA3, 0x81, 0x7F, 0xD3, 0x81, 0xAF, 0x73,
  0x03, 0xA0, 0x12,
  // "l" (U+006C)
  0x48, 0x17, 0xF9, 0x48, 0x1B, 0xF6, 0x48, 0x1E, 0xF3, 0x30, 0x2A, 0x48, 0x15, 0xFC, 0x48, 0x18,
  0xF9, 0x48, 0x1B, 0xF6, 0x48, 0x1E, 0xF2, 0x38, 0x12, 0xFE, 0x48, 0x16, 0xFB, 0x48, 0x19, 0xF8,
  0x48, 0x1C, 0xF5, 0x4A, 0x02, 0x38, 0x13, 0xFE, 0x48, 0x16, 0xFB, 0x48, 0x19, 0xF8, 0x48, 0x1D,
  0xF4, 0x4A, 0x01, 0x38, 0x14, 0xFD, 0x48, 0x17, 0xFA, 0x48, 0x1A, 0xF7, 0x40,
  // "m" (U+006D)
  0x38, 0x94, 0xCF, 0x04, 0xCE, 0xC3, 0x01, 0xAE, 0xE8, 0x49, 0x82, 0xD6, 0xFE, 0xA8, 0x3D, 0x2E,
  0xFE, 0xA0, 0x52, 0x85, 0x3F, 0xEE, 0x40, 0x4A, 0x0E, 0x09, 0x28, 0x1B, 0xF9, 0x20, 0x6A, 0x06,
  0x3A, 0x0C, 0x38, 0x18, 0xFA, 0x28, 0x19, 0xFD, 0x30, 0x1A, 0x05, 0x38, 0x19, 0xF8, 0x28, 0x1C,
  0xF7, 0x38, 0x13, 0xFE, 0x48, 0x1C, 0xF5, 0x2A, 0x03, 0x38, 0x17, 0xFA, 0x4A, 0x83, 0x20, 0x3F,
  0xE4, 0x81, 0xAF, 0x73, 0x81, 0x3F, 0xE2, 0x81, 0x7F, 0xB4, 0x81, 0xDF, 0x43, 0x81, 0x6F, 0xB2,
  0x81, 0xAF, 0x83, 0x01, 0xA0, 0x13, 0x81, 0x9F, 0x82, 0x81, 0xDF, 0x53, 0x81, 0x4F, 0xD4, 0x83,
  0xDF, 0x40, 0x1A, 0x01, 0x38, 0x17, 0xFA, 0x4A, 0x83, 0x10, 0x4F, 0xE4, 0x81, 0xAF, 0x73, 0x81,
  0x3F, 0xE2, 0x81, 0x7F, 0xB4, 0x81, 0xEF, 0x33, 0x81, 0x7F, 0xA2, 0x81, 0xAF, 0x73, 0x01, 0xA4,
  0x81, 0xAF, 0x72,
  // "n" (U+006E)
  0x38, 0x6D, 0xF0, 0x4C, 0xED, 0x54, 0x98, 0x2E, 0x6F, 0xEB, 0x02, 0x28, 0x90, 0x3F, 0xEE, 0x50,
  0x1E, 0xF6, 0x20, 0x7A, 0x06, 0x38, 0x1C, 0xF7, 0x28, 0x1A, 0xFD, 0x48, 0x1D, 0xF5, 0x28, 0x1D,
  0xF7, 0x30, 0x1A, 0x81, 0x20, 0x1A, 0x03, 0x30, 0x4A, 0x28, 0x14, 0xFE, 0x48, 0x17, 0xFC, 0x28,
  0x17, 0xFB, 0x48, 0x1A, 0xF8, 0x28, 0x1A, 0xF8, 0x48, 0x1D, 0xF5, 0x28, 0x1E, 0xF5, 0x30, 0x1A,
  0x81, 0x20, 0x1A, 0x02, 0x38, 0x14, 0xFE, 0x28, 0x15, 0xFE, 0x48, 0x17, 0xFB, 0x28, 0x18, 0xFB,
  0x48, 0x1B, 0xF7, 0x28, 0x1B, 0xF7, 0x48, 0x1E, 0xF4, 0x20,
  // "o" (U+006F)
  0x48, 0x41, 0x9D, 0xFD, 0x65, 0x02, 0x0D, 0xA0, 0xEA, 0x07, 0x48, 0x6D, 0xFA, 0x10, 0x8F, 0xE3,
  0x81, 0x8F, 0xC4, 0x81, 0xEF, 0x42, 0x81, 0xEF, 0x44, 0x85, 0xDF, 0x50, 0x5F, 0xE5, 0x85, 0xDF,
  0x50, 0x9F, 0x95, 0x85, 0xEF, 0x40, 0xDF, 0x54, 0x01, 0xA0, 0x11, 0xA0, 0x34, 0x83, 0x5F, 0xE0,
  0x1A, 0x01, 0x48, 0x3A, 0xF9, 0x01, 0xA0, 0x13, 0x82, 0x1E, 0xF4, 0x2A, 0x03, 0x38, 0x19, 0xFC,
  0x38, 0x1B, 0xFB, 0x20, 0x7A, 0x03, 0x30, 0x3B, 0x0E, 0xA0, 0x55, 0x84, 0x4B, 0xFE, 0xA3, 0x40,
  // "p" (U+0070)
  0x48, 0x6C, 0xF0, 0x3B, 0xED, 0x55, 0x98, 0x2E, 0x3E, 0xEB, 0x02, 0x38, 0x90, 0x3F, 0xED, 0x70,
  0x1D, 0xF8, 0x30, 0x6A, 0x09, 0x38, 0x18, 0xFB, 0x30, 0x9A, 0x01, 0x38, 0x17, 0xFB, 0x38, 0x1D,
  0xF9, 0x48, 0x17, 0xFA, 0x20, 0x1A, 0x03, 0x48, 0x19, 0xF8, 0x28, 0x14, 0xFE, 0x58, 0x1C, 0xF6,
  0x28, 0x17, 0xFB, 0x40, 0x1A, 0x02, 0x28, 0x1A, 0xF9, 0x48, 0x16, 0xFD, 0x38, 0x1D, 0xF7, 0x48,
  0x1C, 0xF8, 0x20, 0x1A, 0x09, 0x38, 0x25, 0xFE, 0x12, 0x04, 0xA8, 0x5E, 0x20, 0x4E, 0xF7, 0x38,
  0x48, 0xF9, 0xDF, 0xEA, 0x0A, 0x48, 0x6B, 0xF6, 0x2B, 0xED, 0x75, 0x81, 0xEF, 0x37, 0x20, 0x2A,
  0x73, 0x81, 0x5F, 0xC7, 0x38, 0x18, 0xF9, 0x73, 0x81, 0xBF, 0x57, 0x38, 0x1E, 0xF2, 0x73,
  // "q" (U+0071)
  0x48, 0x71, 0x9E, 0xE9, 0x08, 0xF4, 0x30, 0x20, 0xEA, 0x84, 0xEF, 0x7C, 0xF1, 0x38, 0x7D, 0xFB,
  0x10, 0x7E, 0xFD, 0x38, 0x27, 0xFD, 0x13, 0x81, 0xEF, 0xA3, 0x81, 0xDF, 0x64, 0x81, 0xEF, 0x62,
  0x81, 0x4F, 0xE5, 0xA0, 0x32, 0x81, 0x8F, 0xA4, 0x01, 0xA3, 0x81, 0xCF, 0x64, 0x81, 0x5F, 0xC3,
  0xA0, 0x44, 0x81, 0x9F, 0x93, 0xA0, 0x24, 0x81, 0xEF, 0x62, 0x02, 0xA0, 0x13, 0x06, 0xA0, 0x22,
  0x01, 0xA0, 0x22, 0x82, 0x1E, 0xFE, 0x48, 0x7E, 0xF9, 0x01, 0xCE, 0xFB, 0x40, 0x8A, 0x84, 0xEF,
  0xD9, 0xF8, 0x58, 0x69, 0xEE, 0x91, 0xCF, 0x57, 0x3A, 0x01, 0x72, 0x81, 0x3F, 0xE7, 0x38, 0x17,
  0xFA, 0x73, 0x81, 0xAF, 0x77, 0x38, 0x1D, 0xF4, 0x72, 0x01, 0xA0, 0x14,
  // "r" (U+0072)
  0x38, 0x5C, 0xE0, 0x5D, 0xF6, 0x39, 0x84, 0xC6, 0xFE, 0xF2, 0x28, 0x33, 0xFD, 0xE5, 0x50, 0x6A,
  0x06, 0x68, 0x19, 0xFD, 0x78, 0x1C, 0xF7, 0x7A, 0x03, 0x68, 0x13, 0xFE, 0x78, 0x17, 0xFB, 0x78,
  0x1A, 0xF7, 0x78, 0x1D, 0xF4, 0x60, 0x1A, 0x01, 0x68, 0x14, 0xFE, 0x78, 0x17, 0xFB, 0x78, 0x1A,
  0xF7, 0x70,
  // "s" (U+0073)
  0x48, 0x55, 0xCF, 0xEC, 0x81, 0x30, 0x7A, 0x00, 0xEA, 0x05, 0x20, 0x1A, 0x06, 0x20, 0x30, 0x93,
  0x81, 0x5F, 0xD7, 0x18, 0x15, 0xFD, 0x71, 0x02, 0xA0, 0x67, 0x10, 0x9A, 0x06, 0x71, 0x0A, 0xA0,
  0x77, 0x10, 0x9A, 0x04, 0x71, 0x81, 0xCF, 0xA7, 0x18, 0x17, 0xFC, 0x71, 0x81, 0x9F, 0xB2, 0x81,
  0x28, 0x22, 0x82, 0x4E, 0xF7, 0x20, 0x2A, 0x00, 0xEA, 0x0C, 0x48, 0x48, 0xCE, 0xFD, 0x84,
  // "t" (U+0074)
  0x38, 0x12, 0x71, 0x40, 0xA9, 0x48, 0x11, 0xFC, 0x48, 0x16, 0xF9, 0x20, 0x20, 0xAC, 0x81, 0xE7,
  0xDA, 0x85, 0xDD, 0xA0, 0x3F, 0xE4, 0x81, 0x6F, 0xB4, 0x81, 0x9F, 0x84, 0x81, 0xCF, 0x54, 0xA0,
  0x23, 0x81, 0x3F, 0xE4, 0x81, 0x7F, 0xB4, 0x81, 0xAF, 0x74, 0x81, 0xDF, 0x44, 0xA0, 0x14, 0xA0,
  0x34, 0x0D, 0xA0, 0xE0, 0x72, 0x83, 0x3C, 0xFD, 0x52,
  // "u" (U+0075)
  0x28, 0x1D, 0xF4, 0x30, 0x1A, 0x81, 0x10, 0x1A, 0x01, 0x38, 0x14, 0xFD, 0x28, 0x14, 0xFD, 0x48,
  0x17, 0xFA, 0x28, 0x18, 0xFA, 0x48, 0x1B, 0xF7, 0x28, 0x1B, 0xF7, 0x48, 0x1E, 0xF3, 0x28, 0x1E,
  0xF3, 0x30, 0x2A, 0x20, 0x2A, 0x48, 0x15, 0xFD, 0x28, 0x15, 0xFC, 0x48, 0x18, 0xF9, 0x28, 0x18,
  0xF9, 0x48, 0x1C, 0xF6, 0x28, 0x1B, 0xF6, 0x30, 0x1A, 0x03, 0x28, 0x1E, 0xF3, 0x30, 0x7A, 0x3A,
  0x02, 0x28, 0x21, 0xEF, 0xC3, 0xA8, 0x56, 0x02, 0xDE, 0xF9, 0x30, 0xBA, 0x84, 0xEF, 0xB8, 0xF6,
  0x38, 0x71, 0xAE, 0xD8, 0x09, 0xF3, 0x30,
  // "v" (U+0076)
  0x81, 0x7F, 0xA4, 0x85, 0x1E, 0xF3, 0x6F, 0xB4, 0x85, 0x7F, 0xC0, 0x5F, 0xB4, 0x85, 0xEF, 0x50,
  0x5F, 0xB3, 0x81, 0x6F, 0xD2, 0x81, 0x4F, 0xC3, 0x81, 0xCF, 0x62, 0x81, 0x3F, 0xC2, 0x81, 0x4F,
  0xE3, 0x81, 0x3F, 0xD2, 0x81, 0xBF, 0x83, 0x83, 0x2F, 0xD0, 0x3A, 0x01, 0x38, 0x51, 0xFD, 0x0A,
  0xF9, 0x48, 0x21, 0xFE, 0x1A, 0x02, 0x59, 0x82, 0xE7, 0xFB, 0x69, 0x82, 0xED, 0xF4, 0x60, 0xEA,
  0x0C, 0x70, 0xEA, 0x05, 0x78, 0x1D, 0xFE, 0x70,
  // "w" (U+0077)
  0x81, 0x5F, 0xB4, 0x81, 0xEF, 0xA3, 0x01, 0xA8, 0x22, 0x5F, 0xB3, 0x05, 0xA0, 0xA3, 0x85, 0x7F,
  0xB0, 0x5F, 0xB3, 0x0B, 0xA0, 0xA3, 0x85, 0xDF, 0x40, 0x5F, 0xB2, 0x83, 0x2F, 0xBF, 0xA2, 0x81,
  0x3F, 0xD2, 0x81, 0x5F, 0xB2, 0x83, 0x8F, 0x6F, 0x92, 0x81, 0x9F, 0x72, 0x81, 0x5F, 0xB2, 0x83,
  0xED, 0x2F, 0x92, 0x81, 0xEF, 0x12, 0x89, 0x45, 0xFA, 0x05, 0xF7, 0x2F, 0x90, 0x6F, 0xA3, 0x89,
  0x45, 0xFA, 0x0B, 0xF1, 0x3F, 0x90, 0xCF, 0x43, 0x89, 0x35, 0xFA, 0x2F, 0xA0, 0x3F, 0x92, 0xFD,
  0x48, 0x93, 0x5F, 0x98, 0xF4, 0x03, 0xF8, 0x8F, 0x74, 0x83, 0x5F, 0x9D, 0xD2, 0x84, 0x3F, 0x8D,
  0xF1, 0x48, 0x35, 0xFC, 0xF8, 0x28, 0x34, 0xFB, 0xFA, 0x50, 0x5B, 0x02, 0x20, 0x4B, 0x04, 0x50,
  0x5A, 0x0B, 0x30, 0x4A, 0x0D, 0x60, 0x5A, 0x05, 0x30, 0x4A, 0x07, 0x60,
  // "x" (U+0078)
  0x38, 0x1C, 0xF6, 0x38, 0x26, 0xFE, 0x13, 0x81, 0x8F, 0xA2, 0x82, 0x1E, 0xF5, 0x48, 0x14, 0xFD,
  0x28, 0x19, 0xFA, 0x6A, 0x83, 0x13, 0xFE, 0x16, 0x84, 0xBF, 0x5D, 0xF5, 0x78, 0x37, 0xFE, 0xFA,
  0x71, 0x03, 0xA0, 0xE0, 0x17, 0x10, 0x3A, 0x08, 0x72, 0x0C, 0xA0, 0xB7, 0x18, 0x38, 0xFB, 0xFE,
  0x78, 0x53, 0xFE, 0x1D, 0xF4, 0x68, 0x5C, 0xF6, 0x09, 0xF8, 0x58, 0x17, 0xFC, 0x28, 0x15, 0xFC,
  0x40, 0x2A, 0x02, 0x20, 0x2A, 0x01, 0x38, 0x1C, 0xF8, 0x48, 0x1D, 0xF5, 0x30,
  // "y" (U+0079)
  0x48, 0x15, 0xFC, 0x58, 0x1D, 0xF5, 0x48, 0x14, 0xFD, 0x48, 0x15, 0xFD, 0x58, 0x13, 0xFD, 0x48,
  0x1C, 0xF6, 0x58, 0x12, 0xFE, 0x38, 0x14, 0xFE, 0x68, 0x11, 0xFE, 0x38, 0x1B, 0xF7, 0x7A, 0x28,
  0x12, 0xFE, 0x71, 0xA2, 0x81, 0x9F, 0x87, 0x18, 0x2E, 0xF1, 0x1A, 0x01, 0x71, 0x84, 0xDF, 0x18,
  0xF9, 0x72, 0x84, 0xCF, 0x2E, 0xF2, 0x72, 0x83, 0xBF, 0x7F, 0x97, 0x38, 0x3A, 0xFC, 0xF2, 0x73,
  0x09, 0xA0, 0xA7, 0x40, 0x8A, 0x03, 0x74, 0x81, 0x8F, 0xB7, 0x58, 0x1D, 0xF4, 0x74, 0x81, 0x5F,
  0xC7, 0x58, 0x1D, 0xF5, 0x74, 0x81, 0xAF, 0xB7, 0x20, 0x60, 0xEA, 0x0E, 0x01, 0x72, 0x83, 0x6E,
  0xEB, 0x27, 0x30,
  // "z" (U+007A)
  0x30, 0x8E, 0x05, 0x38, 0x3A, 0xDD, 0xDE, 0xA0, 0x27, 0x81, 0xAF, 0x97, 0x82, 0x4F, 0xE1, 0x78,
  0x1D, 0xF5, 0x78, 0x18, 0xFB, 0x70, 0x2A, 0x02, 0x78, 0x1B, 0xF8, 0x78, 0x16, 0xFD, 0x78, 0x21,
  0xEF, 0x47, 0x81, 0x9F, 0xA7, 0x82, 0x3F, 0xE1, 0x78, 0x1D, 0xF6, 0x70, 0x6A, 0x80, 0x0D, 0x0C,
  0x30, 0xAE, 0x0B, 0x30,
  // "{" (U+007B)
  0x78, 0x27, 0xCE, 0x76, 0x0B, 0xB0, 0x45, 0x82, 0x5F, 0xE4, 0x78, 0x19, 0xF8, 0x71, 0x81, 0xDF,
  0x37, 0x01, 0xA7, 0x18, 0x14, 0xFC, 0x71, 0x81, 0x7F, 0x97, 0x18, 0x1B, 0xF6, 0x70, 0x2A, 0x01,
  0x58, 0x31, 0x4D, 0xF8, 0x50, 0x2A, 0x0D, 0x07, 0x60, 0x5A, 0x0B, 0x02, 0x71, 0x81, 0x8F, 0xC7,
  0x10, 0x2A, 0x71, 0x81, 0x3F, 0xE7, 0x18, 0x15, 0xFB, 0x71, 0x81, 0x9F, 0x77, 0x18, 0x1C, 0xF4,
  0x71, 0xA0, 0x17, 0x01, 0xA7, 0x2A, 0x05, 0x71, 0x0B, 0xA0, 0xD7, 0x82, 0x19, 0xDD, 0x50,
  // "|" (U+007C)
  0x89, 0x97, 0x2F, 0xC2, 0xFC, 0x2F, 0xC2, 0xFC, 0x2F, 0xC2, 0xFC, 0x2F, 0xC2, 0xFC, 0x2F, 0xC2,
  0xFC, 0x2F, 0xC2, 0xFC, 0x2F, 0xC2, 0xFC, 0x2F, 0xC2, 0xFC, 0x2F, 0xC2, 0xFC, 0x2F, 0xC2, 0xFC,
  0x2F, 0xC2, 0xFC, 0x2F, 0xC2, 0xFC, 0x2F, 0xC2, 0xFC, 0x2F, 0xC0,
  // "}" (U+007D)
  0x58, 0x2B, 0xEA, 0x17, 0x0D, 0xA0, 0xB7, 0x10, 0x6A, 0x01, 0x71, 0xA0, 0x17, 0x01, 0xA7, 0x18,
  0x14, 0xFC, 0x71, 0x81, 0x7F, 0x97, 0x18, 0x1B, 0xF5, 0x71, 0x81, 0xDF, 0x27, 0x1A, 0x02, 0x71,
  0x81, 0xBF, 0x97, 0x10, 0x20, 0xBA, 0x05, 0x60, 0x60, 0xCA, 0x03, 0x58, 0x38, 0xFD, 0x41, 0x50,
  0x1A, 0x02, 0x78, 0x15, 0xFB, 0x71, 0x81, 0x9F, 0x87, 0x18, 0x1C, 0xF4, 0x71, 0xA0, 0x17, 0x81,
  0x3F, 0xD7, 0x18, 0x18, 0xFA, 0x70, 0x5A, 0x05, 0x50, 0x5B, 0x0B, 0x68, 0x26, 0xEC, 0x77,
  // "~" (U+007E)
  0x18, 0x35, 0xCD, 0x92, 0x48, 0x13, 0x26, 0xD8, 0x92, 0xA3, 0x05, 0xE2, 0xAA, 0x11, 0x7E, 0xC8,
  0x1D, 0x16, 0x48, 0x41, 0x8D, 0xEB, 0x21,
  // "¡" (U+00A1)
  0x48, 0x14, 0xED, 0x50, 0xBA, 0x01, 0x48, 0x19, 0xE7, 0x77, 0x68, 0x11, 0xB6, 0x58, 0x14, 0xF6,
  0x58, 0x18, 0xF3, 0x58, 0x1C, 0xF1, 0x59, 0x0D, 0x58, 0x14, 0xFB, 0x58, 0x18, 0xF8, 0x58, 0x1B,
  0xF5, 0x5A, 0x02, 0x40, 0x4A, 0x58, 0x17, 0xFC, 0x58, 0x1B, 0xF9, 0x5A, 0x07, 0x40, 0x3A, 0x04,
  0x48, 0x23, 0x77, 0x14,
  // "¢" (U+00A2)
  0x60, 0x0B, 0x71, 0x0E, 0x08, 0x68, 0x44, 0xAF, 0xD8, 0x23, 0x09, 0xD0, 0x32, 0x85, 0x8F, 0xE5,
  0x02, 0x72, 0x03, 0xA0, 0x36, 0x81, 0xAF, 0x96, 0x01, 0xA0, 0x36, 0x81, 0x6F, 0xD7, 0x81, 0xAF,
  0x97, 0x81, 0xCF, 0x67, 0x81, 0xEF, 0x47, 0x81, 0xEF, 0x47, 0x81, 0xDF, 0x67, 0x85, 0x9F, 0xD2,
  0x01, 0x63, 0x02, 0x0E, 0xA0, 0xEA, 0x01, 0x38, 0x43, 0xCF, 0xEC, 0x75, 0x81, 0x5F, 0x37, 0x07,
  0x97, 0x10, 0xA0, 0xD6,
  // "£" (U+00A3)
  0x78, 0x51, 0x9E, 0xFD, 0x92, 0x60, 0x10, 0xDA, 0x0E, 0xA0, 0x96, 0x86, 0xAF, 0xC1, 0x01, 0x91,
  0x50, 0x1A, 0x02, 0x73, 0x81, 0x6F, 0xC7, 0x48, 0x19, 0xF8, 0x74, 0x81, 0xCF, 0x57, 0x4A, 0x02,
  0x73, 0x81, 0x3F, 0xE7, 0x28, 0x16, 0xDE, 0xA0, 0xFD, 0x03, 0x50, 0xAF, 0x01, 0x78, 0x1D, 0xF5,
  0x74, 0xA0, 0x27, 0x38, 0x13, 0xFE, 0x74, 0x81, 0x7F, 0xB7, 0x48, 0x1C, 0xF6, 0x73, 0x81, 0x4F,
  0xE7, 0x38, 0x24, 0xEE, 0x37, 0x20, 0x3A, 0x0E, 0x80, 0x2D, 0x07, 0x30, 0x6F, 0xA0, 0x53,
  // "¤" (U+00A4)
  0x10, 0x60, 0x17, 0x89, 0x64, 0x32, 0xFC, 0x18, 0xDF, 0xC5, 0x3E, 0xC0, 0x7C, 0x0E, 0xB0, 0xE0,
  0x22, 0x81, 0xCF, 0x82, 0x82, 0x2B, 0xF8, 0x28, 0x13, 0xF8, 0x50, 0xC0, 0xD2, 0x81, 0x7F, 0x15,
  0x83, 0x6F, 0x30, 0x99, 0x68, 0x54, 0xF5, 0x07, 0xF2, 0x58, 0x56, 0xF3, 0x02, 0xF9, 0x50, 0x0D,
  0x38, 0x7C, 0xF9, 0x20, 0x3C, 0xF8, 0x28, 0x18, 0xFE, 0xD8, 0x97, 0xEF, 0x32, 0xFB, 0x06, 0xCD,
  0xA3, 0x2E, 0xC0, 0x57, 0x10, 0x02,
  // "¥" (U+00A5)
  0x38, 0x1C, 0xF6, 0x48, 0x24, 0xFE, 0x13, 0x81, 0xAF, 0x74, 0x81, 0xBF, 0x74, 0x81, 0x8F, 0x93,
  0x81, 0x3F, 0xE5, 0x81, 0x6F, 0xA3, 0x81, 0xBF, 0x75, 0x81, 0x4F, 0xB2, 0x81, 0x3F, 0xE6, 0x81,
  0x2F, 0xD2, 0x81, 0xAF, 0x67, 0x98, 0x3E, 0x02, 0xFD, 0x71, 0x84, 0xEF, 0x0A, 0xF6, 0x71, 0x83,
  0xCF, 0x4F, 0xD7, 0x28, 0x3A, 0xFD, 0xF5, 0x72, 0x08, 0xA0, 0xD7, 0x01, 0xF9, 0x01, 0x48, 0x72,
  0xAA, 0xCF, 0xEA, 0xA9, 0x71, 0x81, 0x8F, 0x97, 0x48, 0x1B, 0xF6, 0x71, 0x0E, 0xF0, 0x44, 0x82,
  0x1D, 0xDE, 0xA0, 0xFD, 0x01, 0x78, 0x15, 0xFC, 0x74, 0x81, 0x8F, 0x97, 0x48, 0x1C, 0xF5, 0x71,
  // "¦" (U+00A6)
  0x8B, 0x42, 0xFC, 0x2F, 0xC2, 0xFC, 0x2F, 0xC2, 0xFC, 0x2F, 0xC2, 0xFC, 0x2F, 0xC2, 0xFC, 0x2F,
  0xC7, 0x77, 0x8B, 0x42, 0xFC, 0x2F, 0xC2, 0xFC, 0x2F, 0xC2, 0xFC, 0x2F, 0xC2, 0xFC, 0x2F, 0xC2,
  0xFC, 0x2F, 0xC0,
  // "§" (U+00A7)
  0x48, 0x51, 0x9D, 0xFE, 0xA4, 0x30, 0x10, 0xDA, 0x0E, 0xA0, 0xD3, 0x82, 0x8F, 0xC2, 0x20, 0x60,
  0x53, 0x81, 0xCF, 0x47, 0x18, 0x1C, 0xF4, 0x71, 0x82, 0x8F, 0xD1, 0x71, 0x82, 0xDF, 0xE6, 0x68,
  0x19, 0xFC, 0xA0, 0x94, 0x86, 0xAF, 0x50, 0x4E, 0xF5, 0x28, 0x12, 0xFB, 0x38, 0x17, 0xF9, 0x28,
  0x14, 0xFA, 0x38, 0x15, 0xF8, 0x20, 0x2A, 0x03, 0x28, 0x1A, 0xF4, 0x38, 0x5B, 0xFE, 0x67, 0xF9,
  0x50, 0xAB, 0x08, 0x78, 0x26, 0xEF, 0x87, 0x10, 0x3A, 0x01, 0x71, 0x81, 0xDF, 0x37, 0x82, 0x1E,
  0xF1, 0x28, 0x6B, 0x51, 0x03, 0xBF, 0xB3, 0x0D, 0xD0, 0xD0, 0x23, 0x85, 0x39, 0xCD, 0xC8, 0x14,
  // "¨" (U+00A8)
  0x89, 0x65, 0xC2, 0x02, 0xB6, 0xDF, 0x50, 0x9F, 0xAB, 0xC2, 0x81, 0x7E, 0x30,
  // "©" (U+00A9)
  0x68, 0x75, 0x9D, 0xEF, 0xDB, 0x61, 0x73, 0x04, 0x0D, 0xB0, 0x0E, 0xB0, 0xE0, 0x77, 0x10, 0x7A,
  0x0A, 0x04, 0x48, 0x42, 0x7E, 0xFB, 0x15, 0x82, 0x6F, 0xD3, 0x71, 0x82, 0x1A, 0xFC, 0x48, 0x22,
  0xFD, 0x12, 0x85, 0x19, 0xDF, 0xDB, 0x52, 0x81, 0x8F, 0x83, 0x81, 0xBF, 0x32, 0x02, 0x0E, 0xA0,
  0xEA, 0x0C, 0x38, 0x5B, 0xF1, 0x01, 0xF8, 0x38, 0x2D, 0xFA, 0x12, 0x00, 0x43, 0x85, 0x2F, 0x70,
  0x6F, 0x22, 0x81, 0x5F, 0xD7, 0x38, 0x3C, 0xC0, 0x8E, 0x38, 0x19, 0xF7, 0x73, 0x83, 0x8F, 0x0A,
  0xD3, 0x81, 0xAF, 0x57, 0x38, 0x37, 0xF1, 0xAD, 0x38, 0x1A, 0xF4, 0x73, 0x83, 0x7F, 0x18, 0xE3,
  0x81, 0x9F, 0x67, 0x38, 0x48, 0xF0, 0x6F, 0x22, 0x81, 0x5F, 0xC7, 0x38, 0x4C, 0xC0, 0x1F, 0x83,
  0x82, 0xEF, 0x91, 0x20, 0x20, 0x33, 0x81, 0x2F, 0x72, 0x81, 0xAF, 0x32, 0x04, 0xB0, 0xEA, 0x09,
  0x38, 0x1B, 0xF2, 0x28, 0x22, 0xFD, 0x12, 0x85, 0x29, 0xDF, 0xDA, 0x32, 0x81, 0x8F, 0x84, 0x82,
  0x6F, 0xD3, 0x72, 0x81, 0xAF, 0xC6, 0x07, 0xA0, 0xA0, 0x44, 0x84, 0x27, 0xEF, 0xC1, 0x70, 0x40,
  0xDB, 0x00, 0xEC, 0x08, 0x74, 0x87, 0x59, 0xDE, 0xFD, 0xB7, 0x16,
  // "ª" (U+00AA)
  0x38, 0x49, 0xEE, 0x5D, 0x62, 0x82, 0xAD, 0x35, 0xA8, 0x33, 0x04, 0xF4, 0x20, 0xD9, 0x20, 0xA0,
  0xD3, 0x0D, 0x0C, 0x20, 0xE0, 0x93, 0x98, 0x39, 0x01, 0xF8, 0x28, 0x13, 0xF6, 0x29, 0x08, 0x28,
  0x19, 0xF3, 0x28, 0x2D, 0xC0, 0x5A, 0x38, 0x44, 0xEF, 0xC8, 0xC5, 0x82, 0x10, 0x11, 0x20,
  // "«" (U+00AB)
  0x40, 0x54, 0x05, 0x48, 0x16, 0xFA, 0x28, 0x18, 0xF7, 0x28, 0x64, 0xFD, 0x10, 0x6F, 0xC2, 0x8A,
  0x13, 0xFE, 0x30, 0x4F, 0xE2, 0x02, 0xEF, 0x50, 0x3E, 0xF4, 0x28, 0x6E, 0xF7, 0x01, 0xDF, 0x73,
  0x83, 0xDF, 0x60, 0x1A, 0x04, 0x38, 0x15, 0xFD, 0x28, 0x18, 0xFA, 0x48, 0x3D, 0xF3, 0x01, 0xA0,
  0x13, 0x81, 0x6F, 0x92, 0x81, 0x9F, 0x74, 0x00, 0xD2, 0x81, 0x1F, 0xB4, 0x02, 0x40, 0x33,
  // "¬" (U+00AC)
  0x09, 0x80, 0x6D, 0x0A, 0xFB, 0x72, 0x0E, 0x97, 0x20, 0xE9, 0x72, 0x0E, 0x97, 0x20, 0xE9, 0x72,
  0x0E, 0x97, 0x20, 0x60, 0x70,
  // "®" (U+00AE)
  0x68, 0x75, 0x9D, 0xEF, 0xDB, 0x61, 0x73, 0x04, 0x0D, 0xB0, 0x0E, 0xB0, 0xE0, 0x77, 0x10, 0x7A,
  0x0A, 0x04, 0x48, 0x42, 0x7E, 0xFB, 0x15, 0x82, 0x6F, 0xD3, 0x71, 0x82, 0x1A, 0xFC, 0x48, 0x42,
  0xFD, 0x10, 0x6B, 0x81, 0xEC, 0x73, 0x81, 0x8F, 0x83, 0x81, 0xBF, 0x32, 0x83, 0x6F, 0xED, 0xEA,
  0x09, 0x38, 0x5B, 0xF1, 0x01, 0xF8, 0x38, 0x16, 0xF8, 0x20, 0x6A, 0x38, 0x52, 0xF7, 0x06, 0xF2,
  0x38, 0x16, 0xF8, 0x3A, 0x48, 0x3C, 0xC0, 0x8E, 0x48, 0x16, 0xF8, 0x28, 0x17, 0xFD, 0x48, 0x38,
  0xF0, 0xAD, 0x48, 0x26, 0xFE, 0xDB, 0x05, 0x48, 0x37, 0xF1, 0xAD, 0x40, 0x6D, 0x05, 0x58, 0x37,
  0xF1, 0x8E, 0x48, 0x56, 0xF8, 0x06, 0xFB, 0x58, 0x48, 0xF0, 0x6F, 0x23, 0x81, 0x6F, 0x82, 0x81,
  0xDF, 0x34, 0x84, 0xCC, 0x01, 0xF8, 0x38, 0x16, 0xF8, 0x28, 0x15, 0xFC, 0x38, 0x12, 0xF7, 0x28,
  0x1A, 0xF3, 0x28, 0x16, 0xF8, 0x38, 0x1C, 0xF5, 0x28, 0x1B, 0xF2, 0x28, 0x62, 0xFD, 0x10, 0x27,
  0x43, 0x85, 0x37, 0x50, 0x8F, 0x84, 0x82, 0x6F, 0xD3, 0x72, 0x81, 0xAF, 0xC6, 0x07, 0xA0, 0xA0,
  0x44, 0x84, 0x27, 0xEF, 0xC1, 0x70, 0x40, 0xDB, 0x00, 0xEC, 0x08, 0x74, 0x87, 0x59, 0xDE, 0xFD,
  0xB7, 0x16,
  // "¯" (U+00AF)
  0x02, 0x80, 0x6D, 0x08, 0x05, 0xFB, 0x06,
  // "°" (U+00B0)
  0x28, 0x38, 0xCD, 0xA3, 0x20, 0xCD, 0x89, 0x03, 0x6F, 0xA1, 0x05, 0xFC, 0xA9, 0x48, 0x1A, 0xFA,
  0x94, 0x83, 0x9F, 0x7F, 0x82, 0x83, 0x3E, 0xD1, 0xDA, 0x0E, 0xA8, 0x64, 0x01, 0xAE, 0xFC, 0x41,
  // "±" (U+00B1)
  0x48, 0x13, 0xFA, 0x72, 0x81, 0x3F, 0xA7, 0x28, 0x13, 0xFA, 0x72, 0x81, 0x3F, 0xA7, 0x28, 0x13,
  0xFA, 0x72, 0x81, 0x3F, 0xA5, 0x0A, 0xFB, 0x89, 0x31, 0x9D, 0xDD, 0xEF, 0xED, 0xDD, 0xD1, 0x48,
  0x13, 0xFA, 0x72, 0x81, 0x3F, 0xA7, 0x28, 0x13, 0xFA, 0x72, 0x81, 0x3F, 0xA7, 0x28, 0x13, 0xFA,
  0x77, 0x77, 0x10, 0x98, 0x06, 0xD0, 0x10, 0xAF, 0xB0, 0x10,
  // "²" (U+00B2)
  0x38, 0x37, 0xDF, 0xC4, 0x38, 0x47, 0xFB, 0x9F, 0xE3, 0x01, 0x04, 0x28, 0x19, 0xF3, 0x68, 0x19,
  0xF1, 0x60, 0xE0, 0xC6, 0x81, 0xAF, 0x35, 0x81, 0x8F, 0x75, 0x81, 0x7F, 0x85, 0x81, 0x7F, 0x85,
  0x81, 0x7F, 0x75, 0x81, 0x5F, 0xE8, 0x00, 0x82, 0x0A, 0xD0, 0xB2,
  // "³" (U+00B3)
  0x28, 0x41, 0x8D, 0xFC, 0x33, 0x84, 0x8E, 0xA9, 0xFE, 0x30, 0x01, 0x28, 0x19, 0xF2, 0x68, 0x1A,
  0xF1, 0x48, 0x21, 0x6F, 0x84, 0xA0, 0xE0, 0x54, 0x83, 0x18, 0xBF, 0xA7, 0x81, 0x9F, 0x36, 0x83,
  0x7F, 0x40, 0x14, 0x89, 0x1C, 0xF1, 0x08, 0xDA, 0x9D, 0xF8, 0x28, 0x43, 0xBE, 0xFC, 0x63,
  // "´" (U+00B4)
  0x38, 0x17, 0x74, 0x28, 0x94, 0x8F, 0xD1, 0x04, 0xFE, 0x20, 0x1E, 0xE2, 0x28, 0x1B, 0xD2, 0x30,
  // "µ" (U+00B5)
  0x48, 0x1D, 0xF4, 0x4A, 0x01, 0x4A, 0x01, 0x38, 0x13, 0xFD, 0x48, 0x14, 0xFE, 0x48, 0x17, 0xFA,
  0x48, 0x17, 0xFA, 0x48, 0x1A, 0xF7, 0x48, 0x1A, 0xF7, 0x48, 0x1D, 0xF4, 0x48, 0x1D, 0xF4, 0x30,
  0x1A, 0x01, 0x30, 0x1A, 0x01, 0x38, 0x14, 0xFD, 0x48, 0x14, 0xFD, 0x48, 0x17, 0xFA, 0x48, 0x18,
  0xFA, 0x48, 0x1B, 0xF7, 0x48, 0x1B, 0xF7, 0x30, 0x1A, 0x04, 0x48, 0x1E, 0xF4, 0x30, 0x6A, 0x01,
  0x30, 0x2A, 0x03, 0x28, 0x21, 0xEF, 0xD4, 0x05, 0xA8, 0x58, 0x02, 0xCE, 0xFA, 0x40, 0x9D, 0x82,
  0xD8, 0xF7, 0x48, 0x90, 0xCF, 0x8D, 0xEA, 0x18, 0xF3, 0x4A, 0x02, 0x73, 0x81, 0x3F, 0xE7, 0x48,
  0x16, 0xFB, 0x74, 0x81, 0x9F, 0x87, 0x48, 0x1D, 0xF4, 0x74, 0xA0, 0x17, 0x40,
  // "¶" (U+00B6)
  0x28, 0x14, 0xBE, 0xD8, 0x16, 0x05, 0xD8, 0x4D, 0xDF, 0x60, 0xEC, 0x84, 0xD0, 0x1F, 0x64, 0xD8,
  0x4D, 0x01, 0xF6, 0x8D, 0x84, 0xD0, 0x1F, 0x6A, 0xD8, 0x4D, 0x01, 0xF6, 0xAD, 0x84, 0xD0, 0x1F,
  0x6A, 0xD8, 0x4D, 0x01, 0xF6, 0x8D, 0x84, 0xD0, 0x1F, 0x65, 0xD8, 0x4D, 0x01, 0xF6, 0x1D, 0x85,
  0xD0, 0x1F, 0x60, 0x8C, 0x83, 0xD0, 0x1F, 0x62, 0x87, 0x8E, 0xFE, 0xD0, 0x1F, 0x65, 0x84, 0x9D,
  0x01, 0xF6, 0x58, 0x49, 0xD0, 0x1F, 0x65, 0x84, 0x9D, 0x01, 0xF6, 0x58, 0x49, 0xD0, 0x1F, 0x65,
  0x84, 0x9D, 0x01, 0xF6, 0x58, 0x49, 0xD0, 0x1F, 0x65, 0x84, 0x9D, 0x01, 0xF6, 0x58, 0x49, 0xD0,
  0x1F, 0x65, 0x84, 0x9D, 0x01, 0xF6, 0x58, 0x49, 0xD0, 0x1F, 0x65, 0x84, 0x9D, 0x01, 0xF6, 0x50,
  0x30, 0x52, 0x05, 0x02,
  // "·" (U+00B7)
  0x83, 0x2C, 0xE2, 0x8A, 0x82, 0x46, 0xEA, 0x10,
  // "¸" (U+00B8)
  0x40, 0x24, 0x0B, 0x09, 0x38, 0x25, 0xFB, 0x23, 0x81, 0x2E, 0xC4, 0x87, 0xDE, 0x09, 0x9D, 0xFA,
  0x1B, 0x84, 0xC1, 0x02, 0x42, 0x20,
  // "¹" (U+00B9)
  0x38, 0x13, 0x73, 0x20, 0x7A, 0x89, 0x24, 0x1B, 0xFE, 0xF1, 0x8E, 0x4D, 0xD2, 0x82, 0x11, 0xF9,
  0x38, 0x14, 0xF6, 0x38, 0x18, 0xF3, 0x30, 0xB9, 0x40, 0xE0, 0xB3, 0x81, 0x2F, 0x83, 0x81, 0x6F,
  0x53, 0x81, 0x9F, 0x12,
  // "º" (U+00BA)
  0x28, 0x28, 0xDE, 0x92, 0x87, 0xAD, 0x45, 0xF7, 0x4F, 0x42, 0x82, 0xCB, 0xAD, 0x38, 0x2B, 0xCD,
  0xA3, 0x82, 0xDA, 0xF9, 0x39, 0x81, 0x8E, 0x92, 0x89, 0x25, 0xF3, 0xBD, 0x12, 0xD9, 0x02, 0xDA,
  0x09, 0x40, 0x14,
  // "»" (U+00BB)
  0x20, 0x03, 0x30, 0x40, 0x23, 0x81, 0x1F, 0xD2, 0x81, 0x4F, 0xB4, 0x81, 0xBF, 0x52, 0x81, 0xDF,
  0x33, 0x81, 0x4F, 0xC2, 0x81, 0x7F, 0xA4, 0x83, 0xDF, 0x50, 0x1A, 0x02, 0x38, 0x18, 0xFC, 0x28,
  0x1A, 0xFA, 0x38, 0x6D, 0xF8, 0x01, 0xDF, 0x82, 0x81, 0xAF, 0xA2, 0x81, 0xBF, 0xA2, 0x81, 0x7F,
  0xC2, 0x81, 0x9F, 0xB2, 0x86, 0x4F, 0xD1, 0x06, 0xFC, 0x38, 0x1B, 0xE2, 0x28, 0x1D, 0xD1, 0x40,
  0x23, 0x00, 0x14,
  // "¼" (U+00BC)
  0x77, 0x81, 0x7F, 0x64, 0x81, 0x37, 0x36, 0x81, 0x2F, 0xB4, 0x07, 0xA0, 0x46, 0x81, 0xDE, 0x12,
  0x84, 0x1B, 0xFE, 0xF1, 0x58, 0x19, 0xF4, 0x38, 0x38, 0xE4, 0xDD, 0x58, 0x14, 0xF9, 0x58, 0x21,
  0x1F, 0x94, 0x81, 0x1E, 0xD7, 0x81, 0x4F, 0x64, 0x81, 0xBF, 0x37, 0x81, 0x8F, 0x33, 0x81, 0x6F,
  0x77, 0x10, 0xB9, 0x38, 0x12, 0xFB, 0x38, 0x17, 0xA2, 0x30, 0xE0, 0xB3, 0x81, 0xCE, 0x12, 0x05,
  0xA0, 0x12, 0x81, 0x2F, 0x82, 0x81, 0x9F, 0x52, 0x82, 0x2E, 0xFD, 0x38, 0x56, 0xF5, 0x04, 0xF9,
  0x38, 0x2C, 0xAF, 0x93, 0x84, 0x9F, 0x11, 0xED, 0x38, 0x39, 0xD4, 0xF6, 0x68, 0x1B, 0xF3, 0x28,
  0x45, 0xF3, 0x7F, 0x25, 0x81, 0x6F, 0x72, 0x84, 0x2E, 0x60, 0xAE, 0x58, 0x12, 0xFB, 0x38, 0x5C,
  0xC3, 0x3E, 0xC3, 0x48, 0x1C, 0xE1, 0x20, 0x5E, 0x0E, 0x38, 0x18, 0xF5, 0x38, 0x62, 0x55, 0x58,
  0xF8, 0x42, 0x81, 0x4F, 0x97, 0x18, 0x18, 0xF2, 0x28, 0x11, 0xED, 0x72, 0x09, 0x0B, 0x30,
  // "½" (U+00BD)
  0x77, 0x81, 0x7F, 0x65, 0x81, 0x37, 0x36, 0x81, 0x2F, 0xB5, 0x07, 0xA0, 0x46, 0x81, 0xDE, 0x13,
  0x84, 0x1B, 0xFE, 0xF1, 0x58, 0x19, 0xF4, 0x48, 0x38, 0xE4, 0xDD, 0x58, 0x14, 0xF9, 0x68, 0x21,
  0x1F, 0x94, 0x81, 0x1E, 0xD7, 0x18, 0x14, 0xF6, 0x48, 0x1B, 0xF3, 0x71, 0x81, 0x8F, 0x33, 0x81,
  0x6F, 0x77, 0x20, 0xB9, 0x38, 0x72, 0xFB, 0x07, 0xDF, 0xC4, 0x40, 0xE0, 0xB3, 0x87, 0xCE, 0x17,
  0xFB, 0x9F, 0xE3, 0x81, 0x2F, 0x82, 0x84, 0x9F, 0x50, 0x14, 0x28, 0x19, 0xF3, 0x28, 0x56, 0xF5,
  0x04, 0xF9, 0x68, 0x19, 0xF1, 0x28, 0x49, 0xF1, 0x1E, 0xD7, 0x0E, 0x0C, 0x68, 0x1B, 0xF3, 0x68,
  0x1A, 0xF3, 0x58, 0x16, 0xF7, 0x68, 0x18, 0xF7, 0x58, 0x12, 0xFB, 0x68, 0x17, 0xF8, 0x68, 0x1C,
  0xE1, 0x58, 0x17, 0xF8, 0x68, 0x18, 0xF5, 0x58, 0x17, 0xF7, 0x68, 0x14, 0xF9, 0x58, 0x15, 0xFE,
  0x80, 0x08, 0x28, 0x11, 0xED, 0x60, 0xAD, 0x0B, 0x20,
  // "¾" (U+00BE)
  0x77, 0x28, 0x17, 0xF6, 0x28, 0x41, 0x8D, 0xFC, 0x37, 0x81, 0x2F, 0xB3, 0x84, 0x8E, 0xA9, 0xFE,
  0x78, 0x1D, 0xE1, 0x30, 0x01, 0x28, 0x19, 0xF2, 0x58, 0x19, 0xF4, 0x71, 0x81, 0xAF, 0x14, 0x81,
  0x4F, 0x97, 0x82, 0x16, 0xF8, 0x48, 0x11, 0xED, 0x7A, 0x0E, 0x05, 0x58, 0x1B, 0xF3, 0x68, 0x31,
  0x8B, 0xFA, 0x48, 0x16, 0xF7, 0x73, 0x81, 0x9F, 0x32, 0x81, 0x2F, 0xB3, 0x81, 0x7A, 0x25, 0x81,
  0x7F, 0x42, 0x81, 0xCE, 0x12, 0x05, 0xA0, 0x01, 0x48, 0x5C, 0xF1, 0x09, 0xF5, 0x28, 0x96, 0x2E,
  0xFD, 0x08, 0xDA, 0x9D, 0xF8, 0x04, 0xF9, 0x38, 0x95, 0xCA, 0xF9, 0x03, 0xBE, 0xFC, 0x60, 0x1E,
  0xD3, 0x83, 0x9D, 0x4F, 0x67, 0x18, 0x1B, 0xF3, 0x28, 0x45, 0xF3, 0x7F, 0x27, 0x81, 0x6F, 0x72,
  0x84, 0x2E, 0x60, 0xAE, 0x78, 0x12, 0xFB, 0x38, 0x5C, 0xC3, 0x3E, 0xC3, 0x68, 0x1C, 0xE1, 0x20,
  0x5E, 0x0E, 0x58, 0x18, 0xF5, 0x38, 0x62, 0x55, 0x58, 0xF8, 0x44, 0x81, 0x4F, 0x97, 0x18, 0x18,
  0xF2, 0x48, 0x11, 0xED, 0x72, 0x09, 0x0B, 0x30,
  // "¿" (U+00BF)
  0x68, 0x14, 0xEC, 0x60, 0xCA, 0x68, 0x1A, 0xE7, 0x77, 0x73, 0x0A, 0x07, 0x68, 0x13, 0xF8, 0x68,
  0x19, 0xF3, 0x58, 0x13, 0xFC, 0x58, 0x21, 0xDF, 0x44, 0x82, 0x1D, 0xF8, 0x58, 0x1C, 0xFA, 0x58,
  0x19, 0xFB, 0x58, 0x23, 0xFE, 0x15, 0x81, 0x9F, 0x86, 0x81, 0xCF, 0x56, 0x81, 0xDF, 0x56, 0x81,
  0xBF, 0xB2, 0x83, 0x3B, 0x30, 0x5B, 0x0E, 0xA0, 0x72, 0x84, 0x5C, 0xEE, 0xB5, 0x20,
  // "À" (U+00C0)
  0x71, 0x81, 0x55, 0x27, 0x38, 0x1B, 0xFA, 0x73, 0x81, 0x3F, 0xE7, 0x48, 0x19, 0xF5, 0x74, 0x0D,
  0x0B, 0x77, 0x77, 0x70, 0x2A, 0x0C, 0x72, 0x08, 0xA0, 0xD7, 0x28, 0x2E, 0xEF, 0xD7, 0x18, 0x36,
  0xF9, 0xFE, 0x71, 0x81, 0xDF, 0x3A, 0x78, 0x15, 0xFC, 0x1A, 0x78, 0x1B, 0xF6, 0x1A, 0x60, 0x3A,
  0x01, 0x1A, 0x01, 0x58, 0x1A, 0xF9, 0x28, 0x1E, 0xF1, 0x40, 0x1A, 0x03, 0x28, 0x1E, 0xF2, 0x48,
  0x18, 0xFD, 0x38, 0x1E, 0xF3, 0x48, 0x1E, 0xF7, 0x38, 0x1E, 0xF3, 0x30, 0x6F, 0x90, 0x43, 0x0D,
  0xF9, 0x04, 0x20, 0x4A, 0x03, 0x48, 0x1E, 0xF5, 0x28, 0x1B, 0xFC, 0x58, 0x3D, 0xF6, 0x02, 0xA0,
  0x55, 0x85, 0xDF, 0x60, 0x9F, 0xD6, 0x85, 0xCF, 0x71, 0xEF, 0x66, 0x84, 0xBF, 0x77, 0xFE, 0x78,
  0x1B, 0xF8,
  // "Á" (U+00C1)
  0x75, 0x81, 0x77, 0x47, 0x48, 0x28, 0xFD, 0x17, 0x38, 0x24, 0xFE, 0x27, 0x38, 0x21, 0xEE, 0x27,
  0x48, 0x1B, 0xD2, 0x80, 0xC5, 0x00, 0x2A, 0x0C, 0x74, 0x08, 0xA0, 0xD7, 0x48, 0x2E, 0xEF, 0xD7,
  0x38, 0x36, 0xF9, 0xFE, 0x73, 0x81, 0xDF, 0x3A, 0x72, 0x81, 0x5F, 0xC1, 0xA7, 0x28, 0x1B, 0xF6,
  0x1A, 0x71, 0x03, 0xA0, 0x11, 0xA0, 0x17, 0x81, 0xAF, 0x92, 0x81, 0xEF, 0x16, 0x01, 0xA0, 0x32,
  0x81, 0xEF, 0x26, 0x81, 0x8F, 0xD3, 0x81, 0xEF, 0x36, 0x81, 0xEF, 0x73, 0x81, 0xEF, 0x35, 0x06,
  0xF9, 0x04, 0x50, 0xDF, 0x90, 0x44, 0x04, 0xA0, 0x34, 0x81, 0xEF, 0x54, 0x81, 0xBF, 0xC5, 0x81,
  0xDF, 0x63, 0x02, 0xA0, 0x55, 0x81, 0xDF, 0x63, 0x81, 0x9F, 0xD6, 0x81, 0xCF, 0x72, 0x82, 0x1E,
  0xF6, 0x68, 0x1B, 0xF7, 0x28, 0x17, 0xFE, 0x78, 0x1B, 0xF8, 0x20,
  // "Â" (U+00C2)
  0x73, 0x81, 0x57, 0x47, 0x40, 0x3A, 0x0C, 0x73, 0x84, 0x1E, 0xEC, 0xF2, 0x72, 0x84, 0xCD, 0x23,
  0xF9, 0x71, 0x81, 0xBC, 0x12, 0x81, 0x7F, 0x18, 0x0C, 0x20, 0x02, 0xA0, 0xC7, 0x40, 0x8A, 0x0D,
  0x74, 0x82, 0xEE, 0xFD, 0x73, 0x83, 0x6F, 0x9F, 0xE7, 0x38, 0x1D, 0xF3, 0xA7, 0x28, 0x15, 0xFC,
  0x1A, 0x72, 0x81, 0xBF, 0x61, 0xA7, 0x10, 0x3A, 0x01, 0x1A, 0x01, 0x78, 0x1A, 0xF9, 0x28, 0x1E,
  0xF1, 0x60, 0x1A, 0x03, 0x28, 0x1E, 0xF2, 0x68, 0x18, 0xFD, 0x38, 0x1E, 0xF3, 0x68, 0x1E, 0xF7,
  0x38, 0x1E, 0xF3, 0x50, 0x6F, 0x90, 0x45, 0x0D, 0xF9, 0x04, 0x40, 0x4A, 0x03, 0x48, 0x1E, 0xF5,
  0x48, 0x1B, 0xFC, 0x58, 0x1D, 0xF6, 0x30, 0x2A, 0x05, 0x58, 0x1D, 0xF6, 0x38, 0x19, 0xFD, 0x68,
  0x1C, 0xF7, 0x28, 0x21, 0xEF, 0x66, 0x81, 0xBF, 0x72, 0x81, 0x7F, 0xE7, 0x81, 0xBF, 0x82,
  // "Ã" (U+00C3)
  0x71, 0x82, 0x5C, 0xB1, 0x20, 0xC0, 0x77, 0x02, 0xB8, 0x3D, 0x34, 0xF4, 0x78, 0x29, 0xD1, 0x6B,
  0x0D, 0x71, 0x0D, 0x08, 0x28, 0x25, 0xED, 0x38, 0x0C, 0x50, 0x02, 0xA0, 0xC7, 0x50, 0x8A, 0x0D,
  0x75, 0x82, 0xEE, 0xFD, 0x74, 0x83, 0x6F, 0x9F, 0xE7, 0x48, 0x1D, 0xF3, 0xA7, 0x38, 0x15, 0xFC,
  0x1A, 0x73, 0x81, 0xBF, 0x61, 0xA7, 0x20, 0x3A, 0x01, 0x1A, 0x01, 0x71, 0x81, 0xAF, 0x92, 0x81,
  0xEF, 0x17, 0x01, 0xA0, 0x32, 0x81, 0xEF, 0x27, 0x81, 0x8F, 0xD3, 0x81, 0xEF, 0x37, 0x81, 0xEF,
  0x73, 0x81, 0xEF, 0x36, 0x06, 0xF9, 0x04, 0x60, 0xDF, 0x90, 0x45, 0x04, 0xA0, 0x34, 0x81, 0xEF,
  0x55, 0x81, 0xBF, 0xC5, 0x81, 0xDF, 0x64, 0x02, 0xA0, 0x55, 0x81, 0xDF, 0x64, 0x81, 0x9F, 0xD6,
  0x81, 0xCF, 0x73, 0x82, 0x1E, 0xF6, 0x68, 0x1B, 0xF7, 0x38, 0x17, 0xFE, 0x78, 0x1B, 0xF8, 0x30,
  // "Ä" (U+00C4)
  0x71, 0x85, 0x5C, 0x20, 0x2B, 0x67, 0x18, 0x5D, 0xF5, 0x09, 0xFA, 0x71, 0x0B, 0x0C, 0x28, 0x17,
  0xE3, 0x80, 0xC2, 0x00, 0x2A, 0x0C, 0x74, 0x08, 0xA0, 0xD7, 0x48, 0x2E, 0xEF, 0xD7, 0x38, 0x36,
  0xF9, 0xFE, 0x73, 0x81, 0xDF, 0x3A, 0x72, 0x81, 0x5F, 0xC1, 0xA7, 0x28, 0x1B, 0xF6, 0x1A, 0x71,
  0x03, 0xA0, 0x11, 0xA0, 0x17, 0x81, 0xAF, 0x92, 0x81, 0xEF, 0x16, 0x01, 0xA0, 0x32, 0x81, 0xEF,
  0x26, 0x81, 0x8F, 0xD3, 0x81, 0xEF, 0x36, 0x81, 0xEF, 0x73, 0x81, 0xEF, 0x35, 0x06, 0xF9, 0x04,
  0x50, 0xDF, 0x90, 0x44, 0x04, 0xA0, 0x34, 0x81, 0xEF, 0x54, 0x81, 0xBF, 0xC5, 0x81, 0xDF, 0x63,
  0x02, 0xA0, 0x55, 0x81, 0xDF, 0x63, 0x81, 0x9F, 0xD6, 0x81, 0xCF, 0x72, 0x82, 0x1E, 0xF6, 0x68,
  0x1B, 0xF7, 0x28, 0x17, 0xFE, 0x78, 0x1B, 0xF8, 0x20,
  // "Å" (U+00C5)
  0x71, 0x83, 0x3C, 0xEB, 0x27, 0x28, 0x3D, 0x93, 0x9D, 0x71, 0x03, 0x92, 0x81, 0x1F, 0x37, 0x85,
  0x3F, 0x40, 0x5F, 0x37, 0x18, 0x3E, 0xFE, 0xFD, 0x72, 0x83, 0x3C, 0xEC, 0x28, 0x0C, 0x10, 0x02,
  0xA0, 0xC7, 0x30, 0x8A, 0x0D, 0x73, 0x82, 0xEE, 0xFD, 0x72, 0x83, 0x6F, 0x9F, 0xE7, 0x28, 0x1D,
  0xF3, 0xA7, 0x18, 0x15, 0xFC, 0x1A, 0x71, 0x81, 0xBF, 0x61, 0xA7, 0x03, 0xA0, 0x11, 0xA0, 0x16,
  0x81, 0xAF, 0x92, 0x81, 0xEF, 0x15, 0x01, 0xA0, 0x32, 0x81, 0xEF, 0x25, 0x81, 0x8F, 0xD3, 0x81,
  0xEF, 0x35, 0x81, 0xEF, 0x73, 0x81, 0xEF, 0x34, 0x06, 0xF9, 0x04, 0x40, 0xDF, 0x90, 0x43, 0x04,
  0xA0, 0x34, 0x81, 0xEF, 0x53, 0x81, 0xBF, 0xC5, 0x81, 0xDF, 0x62, 0x02, 0xA0, 0x55, 0x81, 0xDF,
  0x62, 0x81, 0x9F, 0xD6, 0x86, 0xCF, 0x70, 0x1E, 0xF6, 0x68, 0x5B, 0xF7, 0x07, 0xFE, 0x78, 0x1B,
  0xF8, 0x10,
  // "Æ" (U+00C6)
  0x73, 0x0D, 0xFA, 0x03, 0x72, 0x81, 0x5F, 0xEA, 0x0E, 0x80, 0x1D, 0x73, 0x81, 0xDF, 0x4A, 0x03,
  0x77, 0x82, 0x6F, 0xB3, 0xA7, 0x71, 0x84, 0xDF, 0x46, 0xFC, 0x77, 0x85, 0x6F, 0xD0, 0x9F, 0x97,
  0x78, 0x5D, 0xF5, 0x0C, 0xF7, 0x76, 0x81, 0x6F, 0xD2, 0xA0, 0x47, 0x68, 0x3D, 0xF7, 0x02, 0xA0,
  0x17, 0x58, 0x16, 0xFE, 0x20, 0x5F, 0x01, 0x78, 0x1D, 0xF8, 0x28, 0x68, 0xFE, 0xDD, 0xDD, 0xC7,
  0x06, 0xA0, 0x12, 0x81, 0xBF, 0x67, 0x50, 0xEF, 0x03, 0x74, 0x07, 0xA0, 0xFD, 0x0E, 0xA7, 0x58,
  0x1E, 0xF7, 0x38, 0x16, 0xFC, 0x74, 0x82, 0x7F, 0xE1, 0x38, 0x19, 0xF9, 0x74, 0x81, 0xEF, 0x74,
  0x81, 0xDF, 0x67, 0x38, 0x17, 0xFE, 0x40, 0x1A, 0x03, 0x73, 0x81, 0xEF, 0x74, 0x04, 0xA8, 0x01,
  0xD0, 0x74, 0x81, 0x7F, 0xE5, 0x07, 0xF0, 0x54,
  // "Ç" (U+00C7)
  0x68, 0x55, 0xBE, 0xED, 0x93, 0x40, 0x20, 0xCB, 0x0E, 0xA0, 0x73, 0x83, 0x1D, 0xFD, 0x42, 0x02,
  0x09, 0x48, 0x2C, 0xFC, 0x17, 0x18, 0x26, 0xFE, 0x27, 0x28, 0x1E, 0xF7, 0x72, 0x81, 0x5F, 0xE7,
  0x38, 0x1B, 0xF9, 0x73, 0xA0, 0x57, 0x20, 0x4A, 0x01, 0x72, 0x81, 0x7F, 0xD7, 0x38, 0x19, 0xFB,
  0x73, 0x81, 0xAF, 0x97, 0x38, 0x1B, 0xF9, 0x73, 0x81, 0xAF, 0xA7, 0x38, 0x18, 0xFC, 0x73, 0x04,
  0xA0, 0x37, 0x38, 0x2D, 0xFD, 0x22, 0x02, 0x06, 0x50, 0x30, 0xEA, 0x0E, 0xA0, 0xD6, 0x02, 0x0A,
  0xA8, 0x1E, 0xB6, 0x71, 0x0B, 0x09, 0x73, 0x82, 0x5F, 0xB2, 0x73, 0x81, 0x2E, 0xC7, 0x40, 0xD0,
  0xE7, 0x18, 0x39, 0x9D, 0xFA, 0x70, 0x1B, 0x0C, 0x01, 0x71, 0x81, 0x24, 0x27, 0x10,
  // "È" (U+00C8)
  0x68, 0x15, 0x52, 0x73, 0x81, 0xBF, 0xA7, 0x38, 0x13, 0xFE, 0x74, 0x81, 0x9F, 0x57, 0x40, 0xD0,
  0xB7, 0x77, 0x75, 0x0A, 0xF0, 0x14, 0x86, 0xDF, 0xED, 0xDD, 0xDC, 0x40, 0x1A, 0x01, 0x72, 0x81,
  0x4F, 0xE7, 0x38, 0x17, 0xFB, 0x73, 0x81, 0xBF, 0x87, 0x38, 0x1E, 0xF5, 0x72, 0x01, 0xA0, 0x27,
  0x20, 0x5A, 0x73, 0x08, 0xF5, 0x86, 0xBF, 0xED, 0xDD, 0xDB, 0x58, 0x1E, 0xF5, 0x72, 0x02, 0xA0,
  0x27, 0x28, 0x15, 0xFE, 0x73, 0x81, 0x8F, 0xB7, 0x38, 0x1B, 0xF8, 0x73, 0x81, 0xEF, 0x47, 0x20,
  0x2A, 0x01, 0x72, 0x05, 0xA8, 0x01, 0xD0, 0x64, 0x08, 0xF0, 0x44,
  // "É" (U+00C9)
  0x73, 0x81, 0x77, 0x47, 0x28, 0x28, 0xFD, 0x17, 0x18, 0x24, 0xFE, 0x27, 0x18, 0x21, 0xEE, 0x27,
  0x28, 0x1B, 0xD2, 0x77, 0x77, 0x50, 0xAF, 0x01, 0x48, 0x6D, 0xFE, 0xDD, 0xDD, 0xC4, 0x01, 0xA0,
  0x17, 0x28, 0x14, 0xFE, 0x73, 0x81, 0x7F, 0xB7, 0x38, 0x1B, 0xF8, 0x73, 0x81, 0xEF, 0x57, 0x20,
  0x1A, 0x02, 0x72, 0x05, 0xA7, 0x30, 0x8F, 0x58, 0x6B, 0xFE, 0xDD, 0xDD, 0xB5, 0x81, 0xEF, 0x57,
  0x20, 0x2A, 0x02, 0x72, 0x81, 0x5F, 0xE7, 0x38, 0x18, 0xFB, 0x73, 0x81, 0xBF, 0x87, 0x38, 0x1E,
  0xF4, 0x72, 0x02, 0xA0, 0x17, 0x20, 0x5A, 0x80, 0x1D, 0x06, 0x40, 0x8F, 0x04, 0x40,
  // "Ê" (U+00CA)
  0x71, 0x81, 0x57, 0x47, 0x20, 0x3A, 0x0C, 0x71, 0x84, 0x1E, 0xEC, 0xF2, 0x78, 0x4C, 0xD2, 0x3F,
  0x96, 0x81, 0xBC, 0x12, 0x81, 0x7F, 0x17, 0x77, 0x72, 0x0A, 0xF0, 0x14, 0x86, 0xDF, 0xED, 0xDD,
  0xDC, 0x40, 0x1A, 0x01, 0x72, 0x81, 0x4F, 0xE7, 0x38, 0x17, 0xFB, 0x73, 0x81, 0xBF, 0x87, 0x38,
  0x1E, 0xF5, 0x72, 0x01, 0xA0, 0x27, 0x20, 0x5A, 0x73, 0x08, 0xF5, 0x86, 0xBF, 0xED, 0xDD, 0xDB,
  0x58, 0x1E, 0xF5, 0x72, 0x02, 0xA0, 0x27, 0x28, 0x15, 0xFE, 0x73, 0x81, 0x8F, 0xB7, 0x38, 0x1B,
  0xF8, 0x73, 0x81, 0xEF, 0x47, 0x20, 0x2A, 0x01, 0x72, 0x05, 0xA8, 0x01, 0xD0, 0x64, 0x08, 0xF0,
  0x44,
  // "Ë" (U+00CB)
  0x58, 0x55, 0xC2, 0x02, 0xB6, 0x68, 0x5D, 0xF5, 0x09, 0xFA, 0x60, 0xB0, 0xC2, 0x81, 0x7E, 0x37,
  0x77, 0x73, 0x0A, 0xF0, 0x14, 0x86, 0xDF, 0xED, 0xDD, 0xDC, 0x40, 0x1A, 0x01, 0x72, 0x81, 0x4F,
  0xE7, 0x38, 0x17, 0xFB, 0x73, 0x81, 0xBF, 0x87, 0x38, 0x1E, 0xF5, 0x72, 0x01, 0xA0, 0x27, 0x20,
  0x5A, 0x73, 0x08, 0xF5, 0x86, 0xBF, 0xED, 0xDD, 0xDB, 0x58, 0x1E, 0xF5, 0x72, 0x02, 0xA0, 0x27,
  0x28, 0x15, 0xFE, 0x73, 0x81, 0x8F, 0xB7, 0x38, 0x1B, 0xF8, 0x73, 0x81, 0xEF, 0x47, 0x20, 0x2A,
  0x01, 0x72, 0x05, 0xA8, 0x01, 0xD0, 0x64, 0x08, 0xF0, 0x44,
  // "Ì" (U+00CC)
  0x58, 0x15, 0x52, 0x71, 0x81, 0xBF, 0xA7, 0x18, 0x13, 0xFE, 0x72, 0x81, 0x9F, 0x57, 0x20, 0xD0,
  0xB7, 0x77, 0x60, 0x2E, 0x03, 0x38, 0x11, 0x8D, 0xA0, 0x90, 0x66, 0x81, 0x7F, 0xB7, 0x18, 0x1A,
  0xF8, 0x71, 0x81, 0xDF, 0x57, 0x01, 0xA0, 0x27, 0x81, 0x4F, 0xE7, 0x18, 0x17, 0xFB, 0x71, 0x81,
  0xAF, 0x87, 0x18, 0x1D, 0xF5, 0x70, 0x1A, 0x02, 0x78, 0x14, 0xFE, 0x71, 0x81, 0x7F, 0xB7, 0x18,
  0x1B, 0xF8, 0x71, 0x81, 0xEF, 0x57, 0x01, 0xA0, 0x17, 0x81, 0x5F, 0xE7, 0x18, 0x18, 0xFB, 0x68,
  0x55, 0x9E, 0xFD, 0x82, 0x4E, 0x05, 0x40,
  // "Í" (U+00CD)
  0x72, 0x81, 0x77, 0x47, 0x18, 0x28, 0xFD, 0x17, 0x82, 0x4F, 0xE2, 0x78, 0x21, 0xEE, 0x27, 0x18,
  0x1B, 0xD2, 0x77, 0x77, 0x20, 0x2E, 0x03, 0x48, 0x11, 0x8D, 0xA0, 0x90, 0x67, 0x81, 0x7F, 0xB7,
  0x28, 0x1A, 0xF8, 0x72, 0x81, 0xDF, 0x57, 0x10, 0x1A, 0x02, 0x71, 0x81, 0x4F, 0xE7, 0x28, 0x17,
  0xFB, 0x72, 0x81, 0xAF, 0x87, 0x28, 0x1D, 0xF5, 0x71, 0x01, 0xA0, 0x27, 0x18, 0x14, 0xFE, 0x72,
  0x81, 0x7F, 0xB7, 0x28, 0x1B, 0xF8, 0x72, 0x81, 0xEF, 0x57, 0x10, 0x1A, 0x01, 0x71, 0x81, 0x5F,
  0xE7, 0x28, 0x18, 0xFB, 0x78, 0x55, 0x9E, 0xFD, 0x82, 0x5E, 0x05, 0x50,
  // "Î" (U+00CE)
  0x78, 0x15, 0x74, 0x71, 0x03, 0xA0, 0xC7, 0x84, 0x1E, 0xEC, 0xF2, 0x68, 0x4C, 0xD2, 0x3F, 0x95,
  0x81, 0xBC, 0x12, 0x81, 0x7F, 0x17, 0x77, 0x60, 0x2E, 0x03, 0x48, 0x11, 0x8D, 0xA0, 0x90, 0x67,
  0x81, 0x7F, 0xB7, 0x28, 0x1A, 0xF8, 0x72, 0x81, 0xDF, 0x57, 0x10, 0x1A, 0x02, 0x71, 0x81, 0x4F,
  0xE7, 0x28, 0x17, 0xFB, 0x72, 0x81, 0xAF, 0x87, 0x28, 0x1D, 0xF5, 0x71, 0x01, 0xA0, 0x27, 0x18,
  0x14, 0xFE, 0x72, 0x81, 0x7F, 0xB7, 0x28, 0x1B, 0xF8, 0x72, 0x81, 0xEF, 0x57, 0x10, 0x1A, 0x01,
  0x71, 0x81, 0x5F, 0xE7, 0x28, 0x18, 0xFB, 0x78, 0x55, 0x9E, 0xFD, 0x82, 0x5E, 0x05, 0x50,
  // "Ï" (U+00CF)
  0x48, 0x55, 0xC2, 0x02, 0xB6, 0x48, 0x5D, 0xF5, 0x09, 0xFA, 0x40, 0xB0, 0xC2, 0x81, 0x7E, 0x37,
  0x77, 0x40, 0x2E, 0x03, 0x38, 0x11, 0x8D, 0xA0, 0x90, 0x66, 0x81, 0x7F, 0xB7, 0x18, 0x1A, 0xF8,
  0x71, 0x81, 0xDF, 0x57, 0x01, 0xA0, 0x27, 0x81, 0x4F, 0xE7, 0x18, 0x17, 0xFB, 0x71, 0x81, 0xAF,
  0x87, 0x18, 0x1D, 0xF5, 0x70, 0x1A, 0x02, 0x78, 0x14, 0xFE, 0x71, 0x81, 0x7F, 0xB7, 0x18, 0x1B,
  0xF8, 0x71, 0x81, 0xEF, 0x57, 0x01, 0xA0, 0x17, 0x81, 0x5F, 0xE7, 0x18, 0x18, 0xFB, 0x68, 0x55,
  0x9E, 0xFD, 0x82, 0x4E, 0x05, 0x40,
  // "Ð" (U+00D0)
  0x40, 0xAB, 0x81, 0xEC, 0x77, 0x82, 0xDF, 0xED, 0xB0, 0xD0, 0x14, 0x01, 0xA0, 0x12, 0x82, 0x5E,
  0xFB, 0x48, 0x14, 0xFE, 0x40, 0x5A, 0x03, 0x38, 0x17, 0xFB, 0x58, 0x1E, 0xF7, 0x38, 0x1A, 0xF8,
  0x58, 0x1C, 0xF9, 0x38, 0x1E, 0xF5, 0x58, 0x1B, 0xF9, 0x20, 0x1A, 0x01, 0x58, 0x1C, 0xF9, 0x28,
  0x14, 0xFE, 0x68, 0x1D, 0xF8, 0x1E, 0x09, 0x3A, 0x81, 0x62, 0xDA, 0x82, 0xED, 0xD5, 0x20, 0x2A,
  0x03, 0x28, 0x1E, 0xF4, 0x50, 0x6A, 0x20, 0x1A, 0x01, 0x58, 0x1A, 0xFB, 0x28, 0x15, 0xFD, 0x50,
  0x1A, 0x05, 0x28, 0x18, 0xFA, 0x58, 0x18, 0xFE, 0x38, 0x1B, 0xF7, 0x40, 0x3A, 0x06, 0x38, 0x1E,
  0xF4, 0x38, 0x22, 0xDF, 0xB3, 0x02, 0xA8, 0x61, 0x01, 0x6E, 0xFC, 0x13, 0x05, 0xA0, 0xD0, 0xEB,
  0x0A, 0x01, 0x40, 0x8B, 0x82, 0xED, 0x93, 0x60,
  // "Ñ" (U+00D1)
  0x78, 0x25, 0xCB, 0x12, 0x0C, 0x07, 0x70, 0x2B, 0x83, 0xD3, 0x4F, 0x47, 0x82, 0x9D, 0x16, 0xB0,
  0xD7, 0x10, 0xD0, 0x82, 0x82, 0x5E, 0xD3, 0x80, 0xC2, 0x00, 0xAA, 0x01, 0x58, 0x15, 0xFC, 0x40,
  0xDA, 0x04, 0x58, 0x18, 0xF9, 0x30, 0x1B, 0x08, 0x58, 0x1B, 0xF6, 0x30, 0x4B, 0x0B, 0x58, 0x1E,
  0xF2, 0x38, 0x37, 0xF9, 0xFE, 0x48, 0x12, 0xFE, 0x48, 0x4B, 0xF5, 0xEF, 0x23, 0x81, 0x5F, 0xC4,
  0x84, 0xEF, 0x2A, 0xF6, 0x38, 0x19, 0xF8, 0x30, 0x1A, 0x18, 0x17, 0xF9, 0x38, 0x1C, 0xF5, 0x38,
  0x55, 0xFC, 0x03, 0xFC, 0x3A, 0x02, 0x38, 0x18, 0xF9, 0x2A, 0x28, 0x13, 0xFE, 0x48, 0x1B, 0xF6,
  0x28, 0x5C, 0xF4, 0x06, 0xFB, 0x48, 0x1E, 0xF3, 0x28, 0x59, 0xF7, 0x09, 0xF8, 0x30, 0x2A, 0x38,
  0x55, 0xFA, 0x0C, 0xF5, 0x38, 0x15, 0xFC, 0x38, 0x52, 0xFE, 0x0E, 0xF2, 0x38, 0x18, 0xF9, 0x48,
  0x3E, 0xF4, 0xFE, 0x48, 0x1B, 0xF5, 0x48, 0x3B, 0xFA, 0xFB, 0x48, 0x1E, 0xF2, 0x40, 0x7B, 0x07,
  0x38, 0x12, 0xFE, 0x50, 0x4B, 0x04, 0x38, 0x15, 0xFB, 0x6B, 0x01, 0x38, 0x18, 0xF8, 0x68, 0x1C,
  0xFD, 0x40,
  // "Ò" (U+00D2)
  0x78, 0x15, 0x52, 0x74, 0x81, 0xBF, 0xA7, 0x48, 0x13, 0xFE, 0x75, 0x81, 0x9F, 0x57, 0x50, 0xD0,
  0xB8, 0x0C, 0x00, 0x85, 0x18, 0xDE, 0xEA, 0x36, 0x04, 0x0E, 0xA0, 0xEB, 0x04, 0x48, 0x90, 0x3E,
  0xF9, 0x10, 0x1B, 0xFE, 0x48, 0x1D, 0xF9, 0x40, 0x1A, 0x05, 0x28, 0x18, 0xFD, 0x68, 0x6C, 0xF8,
  0x01, 0xEF, 0x66, 0x86, 0xAF, 0xA0, 0x7F, 0xE1, 0x68, 0x5A, 0xFA, 0x0C, 0xF9, 0x78, 0x2B, 0xF9,
  0x1A, 0x05, 0x78, 0x2D, 0xF8, 0x4A, 0x02, 0x78, 0x4E, 0xF6, 0x7F, 0xE7, 0x03, 0xA8, 0x23, 0x9F,
  0xB7, 0x85, 0x6F, 0xE0, 0xBF, 0xA7, 0x85, 0xAF, 0xA0, 0xBF, 0x97, 0x85, 0xEF, 0x50, 0xBF, 0x96,
  0x81, 0x6F, 0xE2, 0x81, 0x9F, 0xB6, 0x81, 0xDF, 0x72, 0x06, 0xA0, 0x14, 0x81, 0x9F, 0xD3, 0x86,
  0x1E, 0xFB, 0x10, 0x1A, 0xA0, 0x34, 0x05, 0xB0, 0xEA, 0x0E, 0x04, 0x68, 0x53, 0xBE, 0xFD, 0x81,
  0x50,
  // "Ó" (U+00D3)
  0x74, 0x81, 0x77, 0x47, 0x38, 0x28, 0xFD, 0x17, 0x28, 0x24, 0xFE, 0x27, 0x28, 0x21, 0xEE, 0x27,
  0x38, 0x1B, 0xD2, 0x80, 0xC0, 0x08, 0x51, 0x8D, 0xEE, 0xA3, 0x60, 0x40, 0xEA, 0x0E, 0xB0, 0x44,
  0x89, 0x03, 0xEF, 0x91, 0x01, 0xBF, 0xE4, 0x81, 0xDF, 0x94, 0x01, 0xA0, 0x52, 0x81, 0x8F, 0xD6,
  0x86, 0xCF, 0x80, 0x1E, 0xF6, 0x68, 0x6A, 0xFA, 0x07, 0xFE, 0x16, 0x85, 0xAF, 0xA0, 0xCF, 0x97,
  0x82, 0xBF, 0x91, 0xA0, 0x57, 0x82, 0xDF, 0x84, 0xA0, 0x27, 0x84, 0xEF, 0x67, 0xFE, 0x70, 0x3A,
  0x82, 0x39, 0xFB, 0x78, 0x56, 0xFE, 0x0B, 0xFA, 0x78, 0x5A, 0xFA, 0x0B, 0xF9, 0x78, 0x5E, 0xF5,
  0x0B, 0xF9, 0x68, 0x16, 0xFE, 0x28, 0x19, 0xFB, 0x68, 0x1D, 0xF7, 0x20, 0x6A, 0x01, 0x48, 0x19,
  0xFD, 0x38, 0x61, 0xEF, 0xB1, 0x01, 0xAA, 0x03, 0x40, 0x5B, 0x0E, 0xA0, 0xE0, 0x46, 0x85, 0x3B,
  0xEF, 0xD8, 0x15,
  // "Ô" (U+00D4)
  0x71, 0x81, 0x57, 0x47, 0x30, 0x3A, 0x0C, 0x72, 0x84, 0x1E, 0xEC, 0xF2, 0x71, 0x84, 0xCD, 0x23,
  0xF9, 0x78, 0x1B, 0xC1, 0x28, 0x17, 0xF1, 0x77, 0x77, 0x68, 0x51, 0x8D, 0xEE, 0xA3, 0x60, 0x40,
  0xEA, 0x0E, 0xB0, 0x44, 0x89, 0x03, 0xEF, 0x91, 0x01, 0xBF, 0xE4, 0x81, 0xDF, 0x94, 0x01, 0xA0,
  0x52, 0x81, 0x8F, 0xD6, 0x86, 0xCF, 0x80, 0x1E, 0xF6, 0x68, 0x6A, 0xFA, 0x07, 0xFE, 0x16, 0x85,
  0xAF, 0xA0, 0xCF, 0x97, 0x82, 0xBF, 0x91, 0xA0, 0x57, 0x82, 0xDF, 0x84, 0xA0, 0x27, 0x84, 0xEF,
  0x67, 0xFE, 0x70, 0x3A, 0x82, 0x39, 0xFB, 0x78, 0x56, 0xFE, 0x0B, 0xFA, 0x78, 0x5A, 0xFA, 0x0B,
  0xF9, 0x78, 0x5E, 0xF5, 0x0B, 0xF9, 0x68, 0x16, 0xFE, 0x28, 0x19, 0xFB, 0x68, 0x1D, 0xF7, 0x20,
  0x6A, 0x01, 0x48, 0x19, 0xFD, 0x38, 0x61, 0xEF, 0xB1, 0x01, 0xAA, 0x03, 0x40, 0x5B, 0x0E, 0xA0,
  0xE0, 0x46, 0x85, 0x3B, 0xEF, 0xD8, 0x15,
  // "Õ" (U+00D5)
  0x68, 0x25, 0xCB, 0x12, 0x0C, 0x07, 0x50, 0x2B, 0x83, 0xD3, 0x4F, 0x45, 0x82, 0x9D, 0x16, 0xB0,
  0xD6, 0x0D, 0x08, 0x28, 0x25, 0xED, 0x37, 0x77, 0x76, 0x85, 0x18, 0xDE, 0xEA, 0x36, 0x04, 0x0E,
  0xA0, 0xEB, 0x04, 0x48, 0x90, 0x3E, 0xF9, 0x10, 0x1B, 0xFE, 0x48, 0x1D, 0xF9, 0x40, 0x1A, 0x05,
  0x28, 0x18, 0xFD, 0x68, 0x6C, 0xF8, 0x01, 0xEF, 0x66, 0x86, 0xAF, 0xA0, 0x7F, 0xE1, 0x68, 0x5A,
  0xFA, 0x0C, 0xF9, 0x78, 0x2B, 0xF9, 0x1A, 0x05, 0x78, 0x2D, 0xF8, 0x4A, 0x02, 0x78, 0x4E, 0xF6,
  0x7F, 0xE7, 0x03, 0xA8, 0x23, 0x9F, 0xB7, 0x85, 0x6F, 0xE0, 0xBF, 0xA7, 0x85, 0xAF, 0xA0, 0xBF,
  0x97, 0x85, 0xEF, 0x50, 0xBF, 0x96, 0x81, 0x6F, 0xE2, 0x81, 0x9F, 0xB6, 0x81, 0xDF, 0x72, 0x06,
  0xA0, 0x14, 0x81, 0x9F, 0xD3, 0x86, 0x1E, 0xFB, 0x10, 0x1A, 0xA0, 0x34, 0x05, 0xB0, 0xEA, 0x0E,
  0x04, 0x68, 0x53, 0xBE, 0xFD, 0x81, 0x50,
  // "Ö" (U+00D6)
  0x68, 0x55, 0xC2, 0x02, 0xB6, 0x78, 0x5D, 0xF5, 0x09, 0xFA, 0x70, 0xB0, 0xC2, 0x81, 0x7E, 0x37,
  0x77, 0x76, 0x85, 0x18, 0xDE, 0xEA, 0x36, 0x04, 0x0E, 0xA0, 0xEB, 0x04, 0x48, 0x90, 0x3E, 0xF9,
  0x10, 0x1B, 0xFE, 0x48, 0x1D, 0xF9, 0x40, 0x1A, 0x05, 0x28, 0x18, 0xFD, 0x68, 0x6C, 0xF8, 0x01,
  0xEF, 0x66, 0x86, 0xAF, 0xA0, 0x7F, 0xE1, 0x68, 0x5A, 0xFA, 0x0C, 0xF9, 0x78, 0x2B, 0xF9, 0x1A,
  0x05, 0x78, 0x2D, 0xF8, 0x4A, 0x02, 0x78, 0x4E, 0xF6, 0x7F, 0xE7, 0x03, 0xA8, 0x23, 0x9F, 0xB7,
  0x85, 0x6F, 0xE0, 0xBF, 0xA7, 0x85, 0xAF, 0xA0, 0xBF, 0x97, 0x85, 0xEF, 0x50, 0xBF, 0x96, 0x81,
  0x6F, 0xE2, 0x81, 0x9F, 0xB6, 0x81, 0xDF, 0x72, 0x06, 0xA0, 0x14, 0x81, 0x9F, 0xD3, 0x86, 0x1E,
  0xFB, 0x10, 0x1A, 0xA0, 0x34, 0x05, 0xB0, 0xEA, 0x0E, 0x04, 0x68, 0x53, 0xBE, 0xFD, 0x81, 0x50,
  // "×" (U+00D7)
  0x10, 0x60, 0x26, 0x84, 0x71, 0x4F, 0xD2, 0x48, 0x69, 0xFB, 0x08, 0xFD, 0x22, 0x82, 0x9F, 0xD1,
  0x28, 0x68, 0xFD, 0x29, 0xFD, 0x14, 0x08, 0xB0, 0xD0, 0x16, 0x0C, 0xA0, 0x46, 0x84, 0x9F, 0xEF,
  0xD2, 0x48, 0x69, 0xFD, 0x19, 0xFD, 0x22, 0x82, 0x9F, 0xD1, 0x28, 0x69, 0xFD, 0x24, 0xFD, 0x14,
  0x84, 0x8F, 0xA0, 0x51, 0x60, 0x61,
  // "Ø" (U+00D8)
  0x77, 0x09, 0x02, 0x68, 0x90, 0x17, 0xCE, 0xEA, 0x37, 0xF7, 0x50, 0x30, 0xEA, 0x0E, 0xC0, 0xB5,
  0x86, 0x3E, 0xFA, 0x10, 0x2C, 0xA0, 0x25, 0x81, 0xDF, 0x94, 0x07, 0xA0, 0x44, 0x81, 0x8F, 0xD4,
  0x02, 0xB0, 0x84, 0x81, 0xEF, 0x64, 0x83, 0xCE, 0xDF, 0x93, 0x81, 0x6F, 0xE4, 0x84, 0x7F, 0x5A,
  0xFA, 0x38, 0x1B, 0xF9, 0x38, 0x53, 0xFA, 0x0B, 0xF9, 0x20, 0x1A, 0x05, 0x38, 0x5C, 0xE1, 0x0D,
  0xF8, 0x20, 0x4A, 0x01, 0x28, 0x18, 0xF5, 0x2A, 0x06, 0x28, 0x17, 0xFD, 0x28, 0x13, 0xFA, 0x20,
  0x2A, 0x03, 0x28, 0x19, 0xFC, 0x28, 0x1D, 0xE1, 0x20, 0x6A, 0x38, 0x5B, 0xFA, 0x09, 0xF5, 0x38,
  0x1A, 0xFA, 0x38, 0x4B, 0xFA, 0x4F, 0xA4, 0x81, 0xEF, 0x53, 0x84, 0xAF, 0xCD, 0xD1, 0x38, 0x16,
  0xFE, 0x40, 0x9B, 0x04, 0x48, 0x1D, 0xF7, 0x40, 0x5A, 0x09, 0x48, 0x19, 0xFD, 0x50, 0x1A, 0x83,
  0xB1, 0x01, 0x9A, 0x03, 0x50, 0x8C, 0x0E, 0xA0, 0xE0, 0x45, 0x89, 0x04, 0xF9, 0x3A, 0xEF, 0xD8,
  0x16, 0x04, 0x0B, 0x77,
  // "Ù" (U+00D9)
  0x78, 0x15, 0x52, 0x74, 0x81, 0xBF, 0xA7, 0x48, 0x13, 0xFE, 0x75, 0x81, 0x9F, 0x57, 0x50, 0xD0,
  0xB7, 0x77, 0x76, 0x81, 0xDF, 0x55, 0x81, 0x5F, 0xD3, 0xA0, 0x25, 0x81, 0x8F, 0xA2, 0x81, 0x4F,
  0xE6, 0x81, 0xCF, 0x72, 0x81, 0x7F, 0xB6, 0x81, 0xEF, 0x32, 0x81, 0xAF, 0x85, 0x03, 0xA3, 0x81,
  0xDF, 0x55, 0x81, 0x6F, 0xC2, 0x01, 0xA0, 0x25, 0x81, 0x9F, 0x92, 0x81, 0x4F, 0xE6, 0x81, 0xCF,
  0x62, 0x81, 0x8F, 0xB6, 0xA0, 0x32, 0x81, 0xBF, 0x75, 0x03, 0xA3, 0x81, 0xEF, 0x45, 0x81, 0x7F,
  0xC2, 0x02, 0xA0, 0x15, 0x81, 0xAF, 0x82, 0x81, 0x5F, 0xD6, 0x81, 0xDF, 0x52, 0x81, 0x8F, 0xA5,
  0x01, 0xA0, 0x22, 0x81, 0xAF, 0x85, 0x81, 0x5F, 0xD3, 0x81, 0xBF, 0x85, 0x81, 0xBF, 0x93, 0x81,
  0x9F, 0xB4, 0x03, 0xA0, 0x23, 0x05, 0xA8, 0x57, 0x11, 0x5E, 0xF9, 0x50, 0xCE, 0x0B, 0x78, 0x48,
  0xDF, 0xEB, 0x66,
  // "Ú" (U+00DA)
  0x74, 0x81, 0x77, 0x47, 0x38, 0x28, 0xFD, 0x17, 0x28, 0x24, 0xFE, 0x27, 0x28, 0x21, 0xEE, 0x27,
  0x38, 0x1B, 0xD2, 0x77, 0x77, 0x68, 0x1D, 0xF5, 0x58, 0x15, 0xFD, 0x3A, 0x02, 0x58, 0x18, 0xFA,
  0x28, 0x14, 0xFE, 0x68, 0x1C, 0xF7, 0x28, 0x17, 0xFB, 0x68, 0x1E, 0xF3, 0x28, 0x1A, 0xF8, 0x50,
  0x3A, 0x38, 0x1D, 0xF5, 0x58, 0x16, 0xFC, 0x20, 0x1A, 0x02, 0x58, 0x19, 0xF9, 0x28, 0x14, 0xFE,
  0x68, 0x1C, 0xF6, 0x28, 0x18, 0xFB, 0x6A, 0x03, 0x28, 0x1B, 0xF7, 0x50, 0x3A, 0x38, 0x1E, 0xF4,
  0x58, 0x17, 0xFC, 0x20, 0x2A, 0x01, 0x58, 0x1A, 0xF8, 0x28, 0x15, 0xFD, 0x68, 0x1D, 0xF5, 0x28,
  0x18, 0xFA, 0x50, 0x1A, 0x02, 0x28, 0x1A, 0xF8, 0x58, 0x15, 0xFD, 0x38, 0x1B, 0xF8, 0x58, 0x1B,
  0xF9, 0x38, 0x19, 0xFB, 0x40, 0x3A, 0x02, 0x30, 0x5A, 0x85, 0x71, 0x15, 0xEF, 0x95, 0x0C, 0xE0,
  0xB7, 0x84, 0x8D, 0xFE, 0xB6, 0x60,
  // "Û" (U+00DB)
  0x71, 0x81, 0x57, 0x47, 0x30, 0x3A, 0x0C, 0x72, 0x84, 0x1E, 0xEC, 0xF2, 0x71, 0x84, 0xCD, 0x23,
  0xF9, 0x78, 0x1B, 0xC1, 0x28, 0x17, 0xF1, 0x77, 0x77, 0x48, 0x1D, 0xF5, 0x58, 0x15, 0xFD, 0x3A,
  0x02, 0x58, 0x18, 0xFA, 0x28, 0x14, 0xFE, 0x68, 0x1C, 0xF7, 0x28, 0x17, 0xFB, 0x68, 0x1E, 0xF3,
  0x28, 0x1A, 0xF8, 0x50, 0x3A, 0x38, 0x1D, 0xF5, 0x58, 0x16, 0xFC, 0x20, 0x1A, 0x02, 0x58, 0x19,
  0xF9, 0x28, 0x14, 0xFE, 0x68, 0x1C, 0xF6, 0x28, 0x18, 0xFB, 0x6A, 0x03, 0x28, 0x1B, 0xF7, 0x50,
  0x3A, 0x38, 0x1E, 0xF4, 0x58, 0x17, 0xFC, 0x20, 0x2A, 0x01, 0x58, 0x1A, 0xF8, 0x28, 0x15, 0xFD,
  0x68, 0x1D, 0xF5, 0x28, 0x18, 0xFA, 0x50, 0x1A, 0x02, 0x28, 0x1A, 0xF8, 0x58, 0x15, 0xFD, 0x38,
  0x1B, 0xF8, 0x58, 0x1B, 0xF9, 0x38, 0x19, 0xFB, 0x40, 0x3A, 0x02, 0x30, 0x5A, 0x85, 0x71, 0x15,
  0xEF, 0x95, 0x0C, 0xE0, 0xB7, 0x84, 0x8D, 0xFE, 0xB6, 0x60,
  // "Ü" (U+00DC)
  0x68, 0x55, 0xC2, 0x02, 0xB6, 0x78, 0x5D, 0xF5, 0x09, 0xFA, 0x70, 0xB0, 0xC2, 0x81, 0x7E, 0x37,
  0x77, 0x74, 0x81, 0xDF, 0x55, 0x81, 0x5F, 0xD3, 0xA0, 0x25, 0x81, 0x8F, 0xA2, 0x81, 0x4F, 0xE6,
  0x81, 0xCF, 0x72, 0x81, 0x7F, 0xB6, 0x81, 0xEF, 0x32, 0x81, 0xAF, 0x85, 0x03, 0xA3, 0x81, 0xDF,
  0x55, 0x81, 0x6F, 0xC2, 0x01, 0xA0, 0x25, 0x81, 0x9F, 0x92, 0x81, 0x4F, 0xE6, 0x81, 0xCF, 0x62,
  0x81, 0x8F, 0xB6, 0xA0, 0x32, 0x81, 0xBF, 0x75, 0x03, 0xA3, 0x81, 0xEF, 0x45, 0x81, 0x7F, 0xC2,
  0x02, 0xA0, 0x15, 0x81, 0xAF, 0x82, 0x81, 0x5F, 0xD6, 0x81, 0xDF, 0x52, 0x81, 0x8F, 0xA5, 0x01,
  0xA0, 0x22, 0x81, 0xAF, 0x85, 0x81, 0x5F, 0xD3, 0x81, 0xBF, 0x85, 0x81, 0xBF, 0x93, 0x81, 0x9F,
  0xB4, 0x03, 0xA0, 0x23, 0x05, 0xA8, 0x57, 0x11, 0x5E, 0xF9, 0x50, 0xCE, 0x0B, 0x78, 0x48, 0xDF,
  0xEB, 0x66,
  // "Ý" (U+00DD)
  0x71, 0x81, 0x77, 0x47, 0x82, 0x8F, 0xD1, 0x68, 0x24, 0xFE, 0x26, 0x82, 0x1E, 0xE2, 0x78, 0x1B,
  0xD2, 0x77, 0x74, 0x81, 0x9F, 0xA5, 0x84, 0x7F, 0xE6, 0xFC, 0x58, 0x4E, 0xF6, 0x4F, 0xE4, 0x83,
  0x7F, 0xD0, 0x2A, 0x01, 0x28, 0x21, 0xEF, 0x42, 0xA0, 0x32, 0x81, 0x8F, 0xB3, 0x83, 0xDF, 0x40,
  0x1A, 0x03, 0x38, 0x5B, 0xF6, 0x09, 0xF9, 0x48, 0x28, 0xF8, 0x2A, 0x01, 0x48, 0x46, 0xFA, 0x9F,
  0x85, 0x83, 0x4F, 0xEF, 0xE6, 0x01, 0xB0, 0x67, 0xA0, 0xD7, 0x18, 0x1D, 0xF6, 0x70, 0x1A, 0x02,
  0x78, 0x14, 0xFE, 0x71, 0x81, 0x7F, 0xB7, 0x18, 0x1A, 0xF8, 0x71, 0x81, 0xDF, 0x57, 0x01, 0xA0,
  0x27, 0x81, 0x4F, 0xE7, 0x10,
  // "Þ" (U+00DE)
  0x48, 0x1A, 0xF8, 0x72, 0x81, 0xDF, 0x57, 0x10, 0x1A, 0x03, 0x71, 0x04, 0xA0, 0x17, 0x10, 0x7C,
  0x81, 0xD8, 0x14, 0x0B, 0xE0, 0xD4, 0x84, 0xEF, 0x60, 0x17, 0xA0, 0x72, 0x01, 0xA0, 0x33, 0x81,
  0xAF, 0xC2, 0x05, 0xA4, 0x81, 0x7F, 0xD2, 0x81, 0x8F, 0xC4, 0x81, 0x7F, 0xB2, 0x81, 0xBF, 0x94,
  0x81, 0xAF, 0x92, 0x81, 0xEF, 0x54, 0x83, 0xEF, 0x40, 0x2A, 0x02, 0x38, 0x19, 0xFD, 0x28, 0x15,
  0xFE, 0x20, 0x30, 0xBA, 0x03, 0x20, 0x8E, 0x0E, 0x03, 0x38, 0x5B, 0xFE, 0xDC, 0xA6, 0x58, 0x1E,
  0xF4, 0x71, 0x02, 0xA0, 0x17, 0x18, 0x15, 0xFD, 0x72, 0x81, 0x8F, 0xA7, 0x20,
  // "ß" (U+00DF)
  0x72, 0x85, 0x18, 0xDF, 0xD8, 0x17, 0x20, 0x10, 0xDA, 0x0E, 0xA0, 0xB7, 0x28, 0x4A, 0xFC, 0x10,
  0x3A, 0x02, 0x70, 0x2A, 0x02, 0x38, 0x1E, 0xF4, 0x78, 0x16, 0xFB, 0x30, 0x1A, 0x01, 0x78, 0x1A,
  0xF7, 0x38, 0x19, 0xFA, 0x71, 0x81, 0xDF, 0x42, 0x82, 0x8F, 0xD1, 0x70, 0x1A, 0x84, 0x10, 0x7F,
  0xE2, 0x71, 0x86, 0x5F, 0xD0, 0x3F, 0xE2, 0x72, 0x85, 0x8F, 0x90, 0xAF, 0x77, 0x38, 0x5B, 0xF6,
  0x0C, 0xF6, 0x73, 0x85, 0xEF, 0x30, 0xAF, 0xC7, 0x20, 0x2A, 0x20, 0x3A, 0x06, 0x71, 0x81, 0x6F,
  0xC3, 0x82, 0x8F, 0xE1, 0x78, 0x19, 0xF8, 0x48, 0x1D, 0xF9, 0x78, 0x1C, 0xF5, 0x48, 0x16, 0xFE,
  0x7A, 0x02, 0x48, 0x14, 0xFE, 0x68, 0x14, 0xFE, 0x58, 0x17, 0xFD, 0x68, 0x37, 0xFB, 0x35, 0x28,
  0x23, 0xEF, 0x76, 0x82, 0xAF, 0x76, 0xA0, 0xEA, 0x0C, 0x78, 0x7E, 0xF4, 0x3B, 0xEF, 0xD8, 0x70,
  0x1A, 0x01, 0x76, 0x81, 0x5F, 0xD7, 0x78, 0x19, 0xF8, 0x76, 0x03, 0xA0, 0x37, 0x40, 0x80, 0xEA,
  0x0B, 0x75, 0x82, 0x7E, 0xE9, 0x76,
  // "à" (U+00E0)
  0x68, 0x15, 0x52, 0x73, 0x81, 0xBF, 0xA7, 0x38, 0x13, 0xFE, 0x74, 0x81, 0x9F, 0x57, 0x40, 0xD0,
  0xB7, 0x77, 0x75, 0x87, 0x19, 0xEE, 0x80, 0x8F, 0x43, 0x02, 0x0E, 0xA8, 0x4E, 0xF6, 0xCF, 0x13,
  0x87, 0xDF, 0xC1, 0x07, 0xEF, 0xD3, 0x82, 0x7F, 0xE1, 0x3A, 0x0A, 0x38, 0x1D, 0xF6, 0x48, 0x1E,
  0xF7, 0x20, 0x4A, 0x5A, 0x04, 0x28, 0x19, 0xFB, 0x40, 0x1A, 0x38, 0x1C, 0xF7, 0x48, 0x14, 0xFD,
  0x38, 0x1E, 0xF4, 0x48, 0x18, 0xFA, 0x3A, 0x02, 0x48, 0x1E, 0xF6, 0x20, 0x2A, 0x01, 0x30, 0x5A,
  0x03, 0x20, 0x1A, 0x02, 0x30, 0xDA, 0x48, 0x7E, 0xF9, 0x01, 0xBD, 0xFC, 0x40, 0x7A, 0x84, 0xEF,
  0xC5, 0xF9, 0x58, 0x69, 0xEE, 0x91, 0x5F, 0x63,
  // "á" (U+00E1)
  0x73, 0x81, 0x77, 0x47, 0x28, 0x28, 0xFD, 0x17, 0x18, 0x24, 0xFE, 0x27, 0x18, 0x21, 0xEE, 0x27,
  0x28, 0x1B, 0xD2, 0x77, 0x77, 0x58, 0x71, 0x9E, 0xE8, 0x08, 0xF4, 0x30, 0x20, 0xEA, 0x84, 0xEF,
  0x6C, 0xF1, 0x38, 0x7D, 0xFC, 0x10, 0x7E, 0xFD, 0x38, 0x27, 0xFE, 0x13, 0xA0, 0xA3, 0x81, 0xDF,
  0x64, 0x81, 0xEF, 0x72, 0x04, 0xA5, 0xA0, 0x42, 0x81, 0x9F, 0xB4, 0x01, 0xA3, 0x81, 0xCF, 0x74,
  0x81, 0x4F, 0xD3, 0x81, 0xEF, 0x44, 0x81, 0x8F, 0xA3, 0xA0, 0x24, 0x81, 0xEF, 0x62, 0x02, 0xA0,
  0x13, 0x05, 0xA0, 0x32, 0x01, 0xA0, 0x23, 0x0D, 0xA4, 0x87, 0xEF, 0x90, 0x1B, 0xDF, 0xC4, 0x07,
  0xA8, 0x4E, 0xFC, 0x5F, 0x95, 0x86, 0x9E, 0xE9, 0x15, 0xF6, 0x30,
  // "â" (U+00E2)
  0x78, 0x15, 0x74, 0x72, 0x03, 0xA0, 0xC7, 0x18, 0x41, 0xEE, 0xCF, 0x27, 0x84, 0xCD, 0x23, 0xF9,
  0x68, 0x1B, 0xC1, 0x28, 0x17, 0xF1, 0x77, 0x77, 0x38, 0x71, 0x9E, 0xE8, 0x08, 0xF4, 0x30, 0x20,
  0xEA, 0x84, 0xEF, 0x6C, 0xF1, 0x38, 0x7D, 0xFC, 0x10, 0x7E, 0xFD, 0x38, 0x27, 0xFE, 0x13, 0xA0,
  0xA3, 0x81, 0xDF, 0x64, 0x81, 0xEF, 0x72, 0x04, 0xA5, 0xA0, 0x42, 0x81, 0x9F, 0xB4, 0x01, 0xA3,
  0x81, 0xCF, 0x74, 0x81, 0x4F, 0xD3, 0x81, 0xEF, 0x44, 0x81, 0x8F, 0xA3, 0xA0, 0x24, 0x81, 0xEF,
  0x62, 0x02, 0xA0, 0x13, 0x05, 0xA0, 0x32, 0x01, 0xA0, 0x23, 0x0D, 0xA4, 0x87, 0xEF, 0x90, 0x1B,
  0xDF, 0xC4, 0x07, 0xA8, 0x4E, 0xFC, 0x5F, 0x95, 0x86, 0x9E, 0xE9, 0x15, 0xF6, 0x30,
  // "ã" (U+00E3)
  0x58, 0x25, 0xCB, 0x12, 0x0C, 0x07, 0x40, 0x2B, 0x83, 0xD3, 0x4F, 0x44, 0x82, 0x9D, 0x16, 0xB0,
  0xD5, 0x0D, 0x08, 0x28, 0x25, 0xED, 0x37, 0x77, 0x73, 0x87, 0x19, 0xEE, 0x80, 0x8F, 0x43, 0x02,
  0x0E, 0xA8, 0x4E, 0xF6, 0xCF, 0x13, 0x87, 0xDF, 0xC1, 0x07, 0xEF, 0xD3, 0x82, 0x7F, 0xE1, 0x3A,
  0x0A, 0x38, 0x1D, 0xF6, 0x48, 0x1E, 0xF7, 0x20, 0x4A, 0x5A, 0x04, 0x28, 0x19, 0xFB, 0x40, 0x1A,
  0x38, 0x1C, 0xF7, 0x48, 0x14, 0xFD, 0x38, 0x1E, 0xF4, 0x48, 0x18, 0xFA, 0x3A, 0x02, 0x48, 0x1E,
  0xF6, 0x20, 0x2A, 0x01, 0x30, 0x5A, 0x03, 0x20, 0x1A, 0x02, 0x30, 0xDA, 0x48, 0x7E, 0xF9, 0x01,
  0xBD, 0xFC, 0x40, 0x7A, 0x84, 0xEF, 0xC5, 0xF9, 0x58, 0x69, 0xEE, 0x91, 0x5F, 0x63,
  // "ä" (U+00E4)
  0x58, 0x55, 0xC2, 0x02, 0xB6, 0x68, 0x5D, 0xF5, 0x09, 0xFA, 0x60, 0xB0, 0xC2, 0x81, 0x7E, 0x37,
  0x77, 0x73, 0x87, 0x19, 0xEE, 0x80, 0x8F, 0x43, 0x02, 0x0E, 0xA8, 0x4E, 0xF6, 0xCF, 0x13, 0x87,
  0xDF, 0xC1, 0x07, 0xEF, 0xD3, 0x82, 0x7F, 0xE1, 0x3A, 0x0A, 0x38, 0x1D, 0xF6, 0x48, 0x1E, 0xF7,
  0x20, 0x4A, 0x5A, 0x04, 0x28, 0x19, 0xFB, 0x40, 0x1A, 0x38, 0x1C, 0xF7, 0x48, 0x14, 0xFD, 0x38,
  0x1E, 0xF4, 0x48, 0x18, 0xFA, 0x3A, 0x02, 0x48, 0x1E, 0xF6, 0x20, 0x2A, 0x01, 0x30, 0x5A, 0x03,
  0x20, 0x1A, 0x02, 0x30, 0xDA, 0x48, 0x7E, 0xF9, 0x01, 0xBD, 0xFC, 0x40, 0x7A, 0x84, 0xEF, 0xC5,
  0xF9, 0x58, 0x69, 0xEE, 0x91, 0x5F, 0x63,
  // "å" (U+00E5)
  0x68, 0x33, 0xCE, 0xB2, 0x71, 0x83, 0xD9, 0x39, 0xD7, 0x03, 0x92, 0x81, 0x1F, 0x36, 0x85, 0x3F,
  0x40, 0x5F, 0x37, 0x83, 0xEF, 0xEF, 0xD7, 0x18, 0x33, 0xCE, 0xC2, 0x77, 0x77, 0x48, 0x71, 0x9E,
  0xE8, 0x08, 0xF4, 0x30, 0x20, 0xEA, 0x84, 0xEF, 0x6C, 0xF1, 0x38, 0x7D, 0xFC, 0x10, 0x7E, 0xFD,
  0x38, 0x27, 0xFE, 0x13, 0xA0, 0xA3, 0x81, 0xDF, 0x64, 0x81, 0xEF, 0x72, 0x04, 0xA5, 0xA0, 0x42,
  0x81, 0x9F, 0xB4, 0x01, 0xA3, 0x81, 0xCF, 0x74, 0x81, 0x4F, 0xD3, 0x81, 0xEF, 0x44, 0x81, 0x8F,
  0xA3, 0xA0, 0x24, 0x81, 0xEF, 0x62, 0x02, 0xA0, 0x13, 0x05, 0xA0, 0x32, 0x01, 0xA0, 0x23, 0x0D,
  0xA4, 0x87, 0xEF, 0x90, 0x1B, 0xDF, 0xC4, 0x07, 0xA8, 0x4E, 0xFC, 0x5F, 0x95, 0x86, 0x9E, 0xE9,
  0x15, 0xF6, 0x30,
  // "æ" (U+00E6)
  0x48, 0x93, 0x19, 0xEE, 0x70, 0xDA, 0x2A, 0xED, 0x84, 0x02, 0x0D, 0xA8, 0x6E, 0xF6, 0xFA, 0xEF,
  0xEA, 0x07, 0x38, 0x4C, 0xFC, 0x10, 0xAB, 0x84, 0xB1, 0x06, 0xFC, 0x28, 0x27, 0xFE, 0x12, 0x03,
  0xA0, 0xD3, 0x81, 0x3F, 0xC2, 0x81, 0xDF, 0x63, 0x03, 0xA0, 0x53, 0x83, 0x9F, 0x90, 0x4A, 0x01,
  0x38, 0x14, 0xFE, 0x28, 0x72, 0x9F, 0xE2, 0x09, 0xFB, 0x48, 0x36, 0xFE, 0xCD, 0xA0, 0xD0, 0x32,
  0x81, 0xCF, 0x64, 0x09, 0xA8, 0x2E, 0xDA, 0x64, 0xA0, 0x34, 0x81, 0xDF, 0x47, 0x01, 0xA0, 0x23,
  0x02, 0xA0, 0x27, 0x02, 0xA0, 0x13, 0x08, 0xA0, 0x37, 0x01, 0xA0, 0x22, 0x02, 0xB0, 0x77, 0x18,
  0x5E, 0xF8, 0x02, 0xDD, 0xA0, 0xE0, 0x32, 0x03, 0x09, 0x30, 0x8A, 0x84, 0xEF, 0xA9, 0xF8, 0xA8,
  0x2E, 0xEF, 0xD4, 0x89, 0x49, 0xED, 0x70, 0xAD, 0x08, 0xDF, 0xD9, 0x32,
  // "ç" (U+00E7)
  0x58, 0x48, 0xDF, 0xDA, 0x13, 0x01, 0x0D, 0xA8, 0x1E, 0xFE, 0x48, 0x5C, 0xFB, 0x20, 0x14, 0x38,
  0x17, 0xFD, 0x71, 0x81, 0xEF, 0x47, 0x81, 0x5F, 0xD7, 0x18, 0x19, 0xF9, 0x71, 0x81, 0xDF, 0x57,
  0x1A, 0x03, 0x70, 0x1A, 0x01, 0x70, 0x1A, 0x01, 0x71, 0xA0, 0x47, 0x18, 0x5C, 0xFC, 0x10, 0x16,
  0x40, 0x4B, 0x81, 0xEF, 0xD5, 0x84, 0x4D, 0xFE, 0xB5, 0x60, 0xB0, 0x97, 0x18, 0x25, 0xFB, 0x27,
  0x18, 0x12, 0xEC, 0x72, 0x0D, 0x0E, 0x68, 0x39, 0x9D, 0xFA, 0x50, 0x1B, 0x0C, 0x01, 0x68, 0x12,
  0x42, 0x70,
  // "è" (U+00E8)
  0x58, 0x15, 0x52, 0x71, 0x81, 0xBF, 0xA7, 0x18, 0x13, 0xFE, 0x72, 0x81, 0x9F, 0x57, 0x20, 0xD0,
  0xB7, 0x77, 0x78, 0x41, 0x8D, 0xED, 0x64, 0x02, 0x0D, 0xA0, 0xEA, 0x04, 0x38, 0x1C, 0xF9, 0x28,
  0x19, 0xF9, 0x28, 0x18, 0xFB, 0x38, 0x66, 0xF9, 0x01, 0xEF, 0x23, 0x85, 0xCF, 0x60, 0x5F, 0xB2,
  0x82, 0x4C, 0xFD, 0x28, 0x2A, 0xFE, 0xEB, 0x0C, 0x01, 0x20, 0xDA, 0x82, 0xED, 0xA5, 0x4A, 0x02,
  0x70, 0x1A, 0x71, 0x02, 0xA0, 0x17, 0x1A, 0x04, 0x71, 0x82, 0xCF, 0xD2, 0x20, 0x40, 0x73, 0x03,
  0xB0, 0xEA, 0x0A, 0x48, 0x53, 0xBE, 0xED, 0x82, 0x20,
  // "é" (U+00E9)
  0x72, 0x81, 0x77, 0x47, 0x18, 0x28, 0xFD, 0x17, 0x82, 0x4F, 0xE2, 0x78, 0x21, 0xEE, 0x27, 0x18,
  0x1B, 0xD2, 0x77, 0x77, 0x38, 0x41, 0x8D, 0xED, 0x65, 0x02, 0x0D, 0xA0, 0xEA, 0x04, 0x48, 0x1C,
  0xF9, 0x28, 0x19, 0xF9, 0x38, 0x18, 0xFB, 0x38, 0x16, 0xF9, 0x28, 0x21, 0xEF, 0x23, 0x81, 0xCF,
  0x62, 0x81, 0x5F, 0xB2, 0x82, 0x4C, 0xFD, 0x38, 0x2A, 0xFE, 0xEB, 0x0C, 0x01, 0x30, 0xDA, 0x82,
  0xED, 0xA5, 0x5A, 0x02, 0x71, 0x01, 0xA7, 0x20, 0x2A, 0x01, 0x72, 0xA0, 0x47, 0x28, 0x2C, 0xFD,
  0x22, 0x04, 0x07, 0x40, 0x3B, 0x0E, 0xA0, 0xA5, 0x85, 0x3B, 0xEE, 0xD8, 0x23,
  // "ê" (U+00EA)
  0x78, 0x15, 0x74, 0x71, 0x03, 0xA0, 0xC7, 0x84, 0x1E, 0xEC, 0xF2, 0x68, 0x4C, 0xD2, 0x3F, 0x95,
  0x81, 0xBC, 0x12, 0x81, 0x7F, 0x17, 0x77, 0x78, 0x41, 0x8D, 0xED, 0x65, 0x02, 0x0D, 0xA0, 0xEA,
  0x04, 0x48, 0x1C, 0xF9, 0x28, 0x19, 0xF9, 0x38, 0x18, 0xFB, 0x38, 0x16, 0xF9, 0x28, 0x21, 0xEF,
  0x23, 0x81, 0xCF, 0x62, 0x81, 0x5F, 0xB2, 0x82, 0x4C, 0xFD, 0x38, 0x2A, 0xFE, 0xEB, 0x0C, 0x01,
  0x30, 0xDA, 0x82, 0xED, 0xA5, 0x5A, 0x02, 0x71, 0x01, 0xA7, 0x20, 0x2A, 0x01, 0x72, 0xA0, 0x47,
  0x28, 0x2C, 0xFD, 0x22, 0x04, 0x07, 0x40, 0x3B, 0x0E, 0xA0, 0xA5, 0x85, 0x3B, 0xEE, 0xD8, 0x23,
  // "ë" (U+00EB)
  0x58, 0x55, 0xC2, 0x02, 0xB6, 0x58, 0x5D, 0xF5, 0x09, 0xFA, 0x50, 0xB0, 0xC2, 0x81, 0x7E, 0x37,
  0x77, 0x78, 0x41, 0x8D, 0xED, 0x65, 0x02, 0x0D, 0xA0, 0xEA, 0x04, 0x48, 0x1C, 0xF9, 0x28, 0x19,
  0xF9, 0x38, 0x18, 0xFB, 0x38, 0x16, 0xF9, 0x28, 0x21, 0xEF, 0x23, 0x81, 0xCF, 0x62, 0x81, 0x5F,
  0xB2, 0x82, 0x4C, 0xFD, 0x38, 0x2A, 0xFE, 0xEB, 0x0C, 0x01, 0x30, 0xDA, 0x82, 0xED, 0xA5, 0x5A,
  0x02, 0x71, 0x01, 0xA7, 0x20, 0x2A, 0x01, 0x72, 0xA0, 0x47, 0x28, 0x2C, 0xFD, 0x22, 0x04, 0x07,
  0x40, 0x3B, 0x0E, 0xA0, 0xA5, 0x85, 0x3B, 0xEE, 0xD8, 0x23,
  // "ì" (U+00EC)
  0x28, 0x15, 0x52, 0x38, 0x1B, 0xFA, 0x38, 0x13, 0xFE, 0x48, 0x19, 0xF5, 0x40, 0xD0, 0xB7, 0x71,
  0x81, 0xCF, 0x53, 0xA0, 0x22, 0x81, 0x3F, 0xE3, 0x81, 0x6F, 0xB3, 0x81, 0x9F, 0x83, 0x81, 0xCF,
  0x53, 0xA0, 0x12, 0x81, 0x3F, 0xE3, 0x81, 0x7F, 0xB3, 0x81, 0xAF, 0x73, 0x81, 0xDF, 0x42, 0x01,
  0xA0, 0x12, 0x81, 0x4F, 0xD3, 0x81, 0x7F, 0xA3, 0x81, 0xAF, 0x73,
  // "í" (U+00ED)
  0x68, 0x17, 0x74, 0x58, 0x28, 0xFD, 0x14, 0x82, 0x4F, 0xE2, 0x48, 0x21, 0xEE, 0x25, 0x81, 0xBD,
  0x27, 0x77, 0x38, 0x1C, 0xF5, 0x6A, 0x02, 0x58, 0x13, 0xFE, 0x68, 0x16, 0xFB, 0x68, 0x19, 0xF8,
  0x68, 0x1C, 0xF5, 0x6A, 0x01, 0x58, 0x13, 0xFE, 0x68, 0x17, 0xFB, 0x68, 0x1A, 0xF7, 0x68, 0x1D,
  0xF4, 0x50, 0x1A, 0x01, 0x58, 0x14, 0xFD, 0x68, 0x17, 0xFA, 0x68, 0x1A, 0xF7, 0x60,
  // "î" (U+00EE)
  0x48, 0x15, 0x74, 0x50, 0x3A, 0x0C, 0x48, 0x41, 0xEE, 0xCF, 0x23, 0x84, 0xCD, 0x23, 0xF9, 0x28,
  0x1B, 0xC1, 0x28, 0x17, 0xF1, 0x77, 0x78, 0x1C, 0xF5, 0x6A, 0x02, 0x58, 0x13, 0xFE, 0x68, 0x16,
  0xFB, 0x68, 0x19, 0xF8, 0x68, 0x1C, 0xF5, 0x6A, 0x01, 0x58, 0x13, 0xFE, 0x68, 0x17, 0xFB, 0x68,
  0x1A, 0xF7, 0x68, 0x1D, 0xF4, 0x50, 0x1A, 0x01, 0x58, 0x14, 0xFD, 0x68, 0x17, 0xFA, 0x68, 0x1A,
  0xF7, 0x60,
  // "ï" (U+00EF)
  0x28, 0x55, 0xC2, 0x02, 0xB6, 0x28, 0x5D, 0xF5, 0x09, 0xFA, 0x20, 0xB0, 0xC2, 0x81, 0x7E, 0x37,
  0x77, 0x81, 0xCF, 0x56, 0xA0, 0x25, 0x81, 0x3F, 0xE6, 0x81, 0x6F, 0xB6, 0x81, 0x9F, 0x86, 0x81,
  0xCF, 0x56, 0xA0, 0x15, 0x81, 0x3F, 0xE6, 0x81, 0x7F, 0xB6, 0x81, 0xAF, 0x76, 0x81, 0xDF, 0x45,
  0x01, 0xA0, 0x15, 0x81, 0x4F, 0xD6, 0x81, 0x7F, 0xA6, 0x81, 0xAF, 0x76,
  // "ð" (U+00F0)
  0x58, 0x16, 0xB1, 0x20, 0x50, 0x75, 0x85, 0xBF, 0xD4, 0xBF, 0xA6, 0x09, 0xA0, 0xD0, 0x46, 0x04,
  0x0D, 0xA0, 0xA6, 0x85, 0xAF, 0xB4, 0xEF, 0x35, 0x00, 0x52, 0x81, 0x7F, 0x97, 0x28, 0x12, 0xFD,
  0x73, 0x81, 0xEF, 0x14, 0x86, 0x7D, 0xEC, 0x3C, 0xF3, 0x20, 0x10, 0xCA, 0x84, 0xEF, 0xDC, 0xF3,
  0x28, 0x5A, 0xFD, 0x20, 0x2D, 0xA8, 0x43, 0x04, 0xFE, 0x13, 0x07, 0xA8, 0x31, 0x0B, 0xF8, 0x40,
  0x5A, 0x2A, 0x03, 0x48, 0x56, 0xFD, 0x03, 0xFE, 0x58, 0x58, 0xFA, 0x06, 0xFD, 0x58, 0x5C, 0xF6,
  0x06, 0xFC, 0x40, 0x2A, 0x83, 0x10, 0x5F, 0xD4, 0x81, 0xAF, 0x92, 0x02, 0xA0, 0x62, 0x82, 0x8F,
  0xE1, 0x30, 0x9A, 0x0E, 0xA0, 0xE0, 0x35, 0x84, 0x7D, 0xFD, 0x92, 0x40,
  // "ñ" (U+00F1)
  0x58, 0x25, 0xCB, 0x12, 0x0C, 0x07, 0x40, 0x2B, 0x83, 0xD3, 0x4F, 0x44, 0x82, 0x9D, 0x16, 0xB0,
  0xD5, 0x0D, 0x08, 0x28, 0x25, 0xED, 0x37, 0x77, 0x72, 0x86, 0xDF, 0x04, 0xCE, 0xD5, 0x59, 0x82,
  0xE6, 0xFE, 0xB0, 0x23, 0x89, 0x03, 0xFE, 0xE5, 0x01, 0xEF, 0x63, 0x07, 0xA0, 0x63, 0x81, 0xCF,
  0x73, 0x81, 0xAF, 0xD4, 0x81, 0xDF, 0x53, 0x81, 0xDF, 0x73, 0x01, 0xA0, 0x22, 0x01, 0xA0, 0x33,
  0x04, 0xA3, 0x81, 0x4F, 0xE4, 0x81, 0x7F, 0xC3, 0x81, 0x7F, 0xB4, 0x81, 0xAF, 0x83, 0x81, 0xAF,
  0x84, 0x81, 0xDF, 0x53, 0x81, 0xEF, 0x53, 0x01, 0xA0, 0x22, 0x01, 0xA0, 0x23, 0x81, 0x4F, 0xE3,
  0x81, 0x5F, 0xE4, 0x81, 0x7F, 0xB3, 0x81, 0x8F, 0xB4, 0x81, 0xBF, 0x73, 0x81, 0xBF, 0x74, 0x81,
  0xEF, 0x43,
  // "ò" (U+00F2)
  0x58, 0x15, 0x52, 0x72, 0x81, 0xBF, 0xA7, 0x28, 0x13, 0xFE, 0x73, 0x81, 0x9F, 0x57, 0x30, 0xD0,
  0xB7, 0x77, 0x73, 0x84, 0x19, 0xDF, 0xD6, 0x50, 0x20, 0xDA, 0x0E, 0xA0, 0x74, 0x86, 0xDF, 0xA1,
  0x08, 0xFE, 0x38, 0x18, 0xFC, 0x48, 0x1E, 0xF4, 0x28, 0x1E, 0xF4, 0x48, 0x5D, 0xF5, 0x05, 0xFE,
  0x58, 0x5D, 0xF5, 0x09, 0xF9, 0x58, 0x5E, 0xF4, 0x0D, 0xF5, 0x40, 0x1A, 0x01, 0x1A, 0x03, 0x48,
  0x35, 0xFE, 0x01, 0xA0, 0x14, 0x83, 0xAF, 0x90, 0x1A, 0x01, 0x38, 0x21, 0xEF, 0x42, 0xA0, 0x33,
  0x81, 0x9F, 0xC3, 0x81, 0xBF, 0xB2, 0x07, 0xA0, 0x33, 0x03, 0xB0, 0xEA, 0x05, 0x58, 0x44, 0xBF,
  0xEA, 0x34,
  // "ó" (U+00F3)
  0x72, 0x81, 0x77, 0x47, 0x18, 0x28, 0xFD, 0x17, 0x82, 0x4F, 0xE2, 0x78, 0x21, 0xEE, 0x27, 0x18,
  0x1B, 0xD2, 0x77, 0x77, 0x38, 0x41, 0x9D, 0xFD, 0x65, 0x02, 0x0D, 0xA0, 0xEA, 0x07, 0x48, 0x6D,
  0xFA, 0x10, 0x8F, 0xE3, 0x81, 0x8F, 0xC4, 0x81, 0xEF, 0x42, 0x81, 0xEF, 0x44, 0x85, 0xDF, 0x50,
  0x5F, 0xE5, 0x85, 0xDF, 0x50, 0x9F, 0x95, 0x85, 0xEF, 0x40, 0xDF, 0x54, 0x01, 0xA0, 0x11, 0xA0,
  0x34, 0x83, 0x5F, 0xE0, 0x1A, 0x01, 0x48, 0x3A, 0xF9, 0x01, 0xA0, 0x13, 0x82, 0x1E, 0xF4, 0x2A,
  0x03, 0x38, 0x19, 0xFC, 0x38, 0x1B, 0xFB, 0x20, 0x7A, 0x03, 0x30, 0x3B, 0x0E, 0xA0, 0x55, 0x84,
  0x4B, 0xFE, 0xA3, 0x40,
  // "ô" (U+00F4)
  0x78, 0x15, 0x74, 0x71, 0x03, 0xA0, 0xC7, 0x84, 0x1E, 0xEC, 0xF2, 0x68, 0x4C, 0xD2, 0x3F, 0x95,
  0x81, 0xBC, 0x12, 0x81, 0x7F, 0x17, 0x77, 0x78, 0x41, 0x9D, 0xFD, 0x65, 0x02, 0x0D, 0xA0, 0xEA,
  0x07, 0x48, 0x6D, 0xFA, 0x10, 0x8F, 0xE3, 0x81, 0x8F, 0xC4, 0x81, 0xEF, 0x42, 0x81, 0xEF, 0x44,
  0x85, 0xDF, 0x50, 0x5F, 0xE5, 0x85, 0xDF, 0x50, 0x9F, 0x95, 0x85, 0xEF, 0x40, 0xDF, 0x54, 0x01,
  0xA0, 0x11, 0xA0, 0x34, 0x83, 0x5F, 0xE0, 0x1A, 0x01, 0x48, 0x3A, 0xF9, 0x01, 0xA0, 0x13, 0x82,
  0x1E, 0xF4, 0x2A, 0x03, 0x38, 0x19, 0xFC, 0x38, 0x1B, 0xFB, 0x20, 0x7A, 0x03, 0x30, 0x3B, 0x0E,
  0xA0, 0x55, 0x84, 0x4B, 0xFE, 0xA3, 0x40,
  // "õ" (U+00F5)
  0x58, 0x25, 0xCB, 0x12, 0x0C, 0x07, 0x40, 0x2B, 0x83, 0xD3, 0x4F, 0x44, 0x82, 0x9D, 0x16, 0xB0,
  0xD5, 0x0D, 0x08, 0x28, 0x25, 0xED, 0x37, 0x77, 0x73, 0x84, 0x19, 0xDF, 0xD6, 0x60, 0x20, 0xDA,
  0x0E, 0xA0, 0x75, 0x86, 0xDF, 0xA1, 0x08, 0xFE, 0x48, 0x18, 0xFC, 0x48, 0x1E, 0xF4, 0x38, 0x1E,
  0xF4, 0x48, 0x1D, 0xF5, 0x28, 0x15, 0xFE, 0x58, 0x1D, 0xF5, 0x28, 0x19, 0xF9, 0x58, 0x1E, 0xF4,
  0x28, 0x1D, 0xF5, 0x40, 0x1A, 0x01, 0x2A, 0x03, 0x48, 0x15, 0xFE, 0x20, 0x1A, 0x01, 0x48, 0x1A,
  0xF9, 0x20, 0x1A, 0x01, 0x38, 0x21, 0xEF, 0x43, 0xA0, 0x33, 0x81, 0x9F, 0xC4, 0x81, 0xBF, 0xB2,
  0x07, 0xA0, 0x34, 0x03, 0xB0, 0xEA, 0x05, 0x68, 0x44, 0xBF, 0xEA, 0x35,
  // "ö" (U+00F6)
  0x58, 0x55, 0xC2, 0x02, 0xB6, 0x58, 0x5D, 0xF5, 0x09, 0xFA, 0x50, 0xB0, 0xC2, 0x81, 0x7E, 0x37,
  0x77, 0x78, 0x41, 0x9D, 0xFD, 0x65, 0x02, 0x0D, 0xA0, 0xEA, 0x07, 0x48, 0x6D, 0xFA, 0x10, 0x8F,
  0xE3, 0x81, 0x8F, 0xC4, 0x81, 0xEF, 0x42, 0x81, 0xEF, 0x44, 0x85, 0xDF, 0x50, 0x5F, 0xE5, 0x85,
  0xDF, 0x50, 0x9F, 0x95, 0x85, 0xEF, 0x40, 0xDF, 0x54, 0x01, 0xA0, 0x11, 0xA0, 0x34, 0x83, 0x5F,
  0xE0, 0x1A, 0x01, 0x48, 0x3A, 0xF9, 0x01, 0xA0, 0x13, 0x82, 0x1E, 0xF4, 0x2A, 0x03, 0x38, 0x19,
  0xFC, 0x38, 0x1B, 0xFB, 0x20, 0x7A, 0x03, 0x30, 0x3B, 0x0E, 0xA0, 0x55, 0x84, 0x4B, 0xFE, 0xA3,
  0x40,
  // "÷" (U+00F7)
  0x48, 0x15, 0xEB, 0x72, 0x0A, 0xA7, 0x28, 0x15, 0xEB, 0x77, 0x77, 0x10, 0x98, 0x06, 0xD0, 0x10,
  0xAF, 0xB0, 0x18, 0x0C, 0x40, 0x81, 0x5E, 0xB7, 0x20, 0xAA, 0x72, 0x81, 0x5E, 0xB5,
  // "ø" (U+00F8)
  0x73, 0x81, 0x3A, 0x14, 0x86, 0x19, 0xDE, 0xC4, 0xCD, 0x40, 0x20, 0xDA, 0x0E, 0xB0, 0x34, 0x86,
  0xDF, 0xA1, 0x08, 0xFE, 0x48, 0x17, 0xFC, 0x30, 0xCA, 0x03, 0x38, 0x1E, 0xF3, 0x28, 0x37, 0xED,
  0xF5, 0x28, 0x14, 0xFD, 0x28, 0x43, 0xF5, 0xCF, 0x52, 0x81, 0x9F, 0x82, 0x84, 0xDA, 0x0D, 0xF3,
  0x28, 0x5D, 0xF4, 0x08, 0xE1, 0x1A, 0x01, 0x2A, 0x86, 0x23, 0xF4, 0x04, 0xFE, 0x20, 0x1A, 0x81,
  0x1D, 0x92, 0x81, 0x9F, 0x92, 0x01, 0xA0, 0x90, 0xD3, 0x81, 0xEF, 0x33, 0xB0, 0x32, 0x81, 0x8F,
  0xC4, 0x81, 0xAF, 0xD2, 0x07, 0xA0, 0x34, 0x0C, 0xB0, 0xEA, 0x05, 0x48, 0x67, 0xF7, 0xBE, 0xEA,
  0x35, 0x00, 0xA7, 0x40,
  // "ù" (U+00F9)
  0x58, 0x15, 0x52, 0x72, 0x81, 0xBF, 0xA7, 0x28, 0x13, 0xFE, 0x73, 0x81, 0x9F, 0x57, 0x30, 0xD0,
  0xB7, 0x77, 0x71, 0x81, 0xDF, 0x43, 0x01, 0xA8, 0x11, 0x01, 0xA0, 0x13, 0x81, 0x4F, 0xD2, 0x81,
  0x4F, 0xD4, 0x81, 0x7F, 0xA2, 0x81, 0x8F, 0xA4, 0x81, 0xBF, 0x72, 0x81, 0xBF, 0x74, 0x81, 0xEF,
  0x32, 0x81, 0xEF, 0x33, 0x02, 0xA2, 0x02, 0xA4, 0x81, 0x5F, 0xD2, 0x81, 0x5F, 0xC4, 0x81, 0x8F,
  0x92, 0x81, 0x8F, 0x94, 0x81, 0xCF, 0x62, 0x81, 0xBF, 0x63, 0x01, 0xA0, 0x32, 0x81, 0xEF, 0x33,
  0x07, 0xA3, 0xA0, 0x22, 0x82, 0x1E, 0xFC, 0x3A, 0x85, 0x60, 0x2D, 0xEF, 0x93, 0x0B, 0xA8, 0x4E,
  0xFB, 0x8F, 0x63, 0x87, 0x1A, 0xED, 0x80, 0x9F, 0x33,
  // "ú" (U+00FA)
  0x72, 0x81, 0x77, 0x47, 0x18, 0x28, 0xFD, 0x17, 0x82, 0x4F, 0xE2, 0x78, 0x21, 0xEE, 0x27, 0x18,
  0x1B, 0xD2, 0x77, 0x77, 0x18, 0x1D, 0xF4, 0x30, 0x1A, 0x81, 0x10, 0x1A, 0x01, 0x38, 0x14, 0xFD,
  0x28, 0x14, 0xFD, 0x48, 0x17, 0xFA, 0x28, 0x18, 0xFA, 0x48, 0x1B, 0xF7, 0x28, 0x1B, 0xF7, 0x48,
  0x1E, 0xF3, 0x28, 0x1E, 0xF3, 0x30, 0x2A, 0x20, 0x2A, 0x48, 0x15, 0xFD, 0x28, 0x15, 0xFC, 0x48,
  0x18, 0xF9, 0x28, 0x18, 0xF9, 0x48, 0x1C, 0xF6, 0x28, 0x1B, 0xF6, 0x30, 0x1A, 0x03, 0x28, 0x1E,
  0xF3, 0x30, 0x7A, 0x3A, 0x02, 0x28, 0x21, 0xEF, 0xC3, 0xA8, 0x56, 0x02, 0xDE, 0xF9, 0x30, 0xBA,
  0x84, 0xEF, 0xB8, 0xF6, 0x38, 0x71, 0xAE, 0xD8, 0x09, 0xF3, 0x30,
  // "û" (U+00FB)
  0x68, 0x15, 0x74, 0x71, 0x03, 0xA0, 0xC7, 0x84, 0x1E, 0xEC, 0xF2, 0x68, 0x4C, 0xD2, 0x3F, 0x95,
  0x81, 0xBC, 0x12, 0x81, 0x7F, 0x17, 0x77, 0x68, 0x1D, 0xF4, 0x30, 0x1A, 0x81, 0x10, 0x1A, 0x01,
  0x38, 0x14, 0xFD, 0x28, 0x14, 0xFD, 0x48, 0x17, 0xFA, 0x28, 0x18, 0xFA, 0x48, 0x1B, 0xF7, 0x28,
  0x1B, 0xF7, 0x48, 0x1E, 0xF3, 0x28, 0x1E, 0xF3, 0x30, 0x2A, 0x20, 0x2A, 0x48, 0x15, 0xFD, 0x28,
  0x15, 0xFC, 0x48, 0x18, 0xF9, 0x28, 0x18, 0xF9, 0x48, 0x1C, 0xF6, 0x28, 0x1B, 0xF6, 0x30, 0x1A,
  0x03, 0x28, 0x1E, 0xF3, 0x30, 0x7A, 0x3A, 0x02, 0x28, 0x21, 0xEF, 0xC3, 0xA8, 0x56, 0x02, 0xDE,
  0xF9, 0x30, 0xBA, 0x84, 0xEF, 0xB8, 0xF6, 0x38, 0x71, 0xAE, 0xD8, 0x09, 0xF3, 0x30,
  // "ü" (U+00FC)
  0x48, 0x55, 0xC2, 0x02, 0xB6, 0x58, 0x5D, 0xF5, 0x09, 0xFA, 0x50, 0xB0, 0xC2, 0x81, 0x7E, 0x37,
  0x77, 0x68, 0x1D, 0xF4, 0x30, 0x1A, 0x81, 0x10, 0x1A, 0x01, 0x38, 0x14, 0xFD, 0x28, 0x14, 0xFD,
  0x48, 0x17, 0xFA, 0x28, 0x18, 0xFA, 0x48, 0x1B, 0xF7, 0x28, 0x1B, 0xF7, 0x48, 0x1E, 0xF3, 0x28,
  0x1E, 0xF3, 0x30, 0x2A, 0x20, 0x2A, 0x48, 0x15, 0xFD, 0x28, 0x15, 0xFC, 0x48, 0x18, 0xF9, 0x28,
  0x18, 0xF9, 0x48, 0x1C, 0xF6, 0x28, 0x1B, 0xF6, 0x30, 0x1A, 0x03, 0x28, 0x1E, 0xF3, 0x30, 0x7A,
  0x3A, 0x02, 0x28, 0x21, 0xEF, 0xC3, 0xA8, 0x56, 0x02, 0xDE, 0xF9, 0x30, 0xBA, 0x84, 0xEF, 0xB8,
  0xF6, 0x38, 0x71, 0xAE, 0xD8, 0x09, 0xF3, 0x30,
  // "ý" (U+00FD)
  0x74, 0x81, 0x77, 0x47, 0x48, 0x28, 0xFD, 0x17, 0x38, 0x24, 0xFE, 0x27, 0x38, 0x21, 0xEE, 0x27,
  0x48, 0x1B, 0xD2, 0x80, 0xC2, 0x08, 0x15, 0xFC, 0x58, 0x1D, 0xF5, 0x48, 0x14, 0xFD, 0x48, 0x15,
  0xFD, 0x58, 0x13, 0xFD, 0x48, 0x1C, 0xF6, 0x58, 0x12, 0xFE, 0x38, 0x14, 0xFE, 0x68, 0x11, 0xFE,
  0x38, 0x1B, 0xF7, 0x7A, 0x28, 0x12, 0xFE, 0x71, 0xA2, 0x81, 0x9F, 0x87, 0x18, 0x2E, 0xF1, 0x1A,
  0x01, 0x71, 0x84, 0xDF, 0x18, 0xF9, 0x72, 0x84, 0xCF, 0x2E, 0xF2, 0x72, 0x83, 0xBF, 0x7F, 0x97,
  0x38, 0x3A, 0xFC, 0xF2, 0x73, 0x09, 0xA0, 0xA7, 0x40, 0x8A, 0x03, 0x74, 0x81, 0x8F, 0xB7, 0x58,
  0x1D, 0xF4, 0x74, 0x81, 0x5F, 0xC7, 0x58, 0x1D, 0xF5, 0x74, 0x81, 0xAF, 0xB7, 0x20, 0x60, 0xEA,
  0x0E, 0x01, 0x72, 0x83, 0x6E, 0xEB, 0x27, 0x30,
  // "þ" (U+00FE)
  0x58, 0x17, 0xFA, 0x73, 0x81, 0xBF, 0x67, 0x38, 0x1E, 0xF3, 0x72, 0x02, 0xA7, 0x38, 0x15, 0xFC,
  0x73, 0x81, 0x8F, 0x97, 0x38, 0x6C, 0xF6, 0x2B, 0xED, 0x55, 0x83, 0xEF, 0x6E, 0xEB, 0x02, 0x30,
  0x3A, 0x85, 0xD7, 0x01, 0xDF, 0x83, 0x06, 0xA0, 0x83, 0x81, 0x8F, 0xB3, 0x81, 0x9F, 0xE4, 0x81,
  0x7F, 0xB3, 0x81, 0xCF, 0x84, 0x81, 0x8F, 0xA3, 0xA0, 0x34, 0x81, 0x9F, 0x82, 0x81, 0x3F, 0xE5,
  0x81, 0xDF, 0x62, 0x81, 0x7F, 0xA4, 0x01, 0xA0, 0x22, 0x81, 0xAF, 0x84, 0x81, 0x6F, 0xD3, 0x81,
  0xDF, 0x74, 0x81, 0xCF, 0x82, 0x01, 0xA0, 0x93, 0x82, 0x5F, 0xE1, 0x20, 0x4A, 0x85, 0xE2, 0x04,
  0xEF, 0x73, 0x84, 0x7F, 0x9D, 0xFE, 0xA0, 0xA4, 0x86, 0xBF, 0x62, 0xBE, 0xD7, 0x58, 0x1E, 0xF3,
  0x72, 0x02, 0xA7, 0x38, 0x15, 0xFC, 0x73, 0x81, 0x8F, 0x97, 0x38, 0x1B, 0xF5, 0x73, 0x81, 0xEF,
  0x27, 0x30,
  // "ÿ" (U+00FF)
  0x78, 0x55, 0xC2, 0x02, 0xB6, 0x71, 0x85, 0xDF, 0x50, 0x9F, 0xA7, 0x10, 0xB0, 0xC2, 0x81, 0x7E,
  0x37, 0x77, 0x77, 0x81, 0x5F, 0xC5, 0x81, 0xDF, 0x54, 0x81, 0x4F, 0xD4, 0x81, 0x5F, 0xD5, 0x81,
  0x3F, 0xD4, 0x81, 0xCF, 0x65, 0x81, 0x2F, 0xE3, 0x81, 0x4F, 0xE6, 0x81, 0x1F, 0xE3, 0x81, 0xBF,
  0x77, 0xA2, 0x81, 0x2F, 0xE7, 0x1A, 0x28, 0x19, 0xF8, 0x71, 0x82, 0xEF, 0x11, 0xA0, 0x17, 0x18,
  0x4D, 0xF1, 0x8F, 0x97, 0x28, 0x4C, 0xF2, 0xEF, 0x27, 0x28, 0x3B, 0xF7, 0xF9, 0x73, 0x83, 0xAF,
  0xCF, 0x27, 0x30, 0x9A, 0x0A, 0x74, 0x08, 0xA0, 0x37, 0x48, 0x18, 0xFB, 0x75, 0x81, 0xDF, 0x47,
  0x48, 0x15, 0xFC, 0x75, 0x81, 0xDF, 0x57, 0x48, 0x1A, 0xFB, 0x72, 0x06, 0x0E, 0xA0, 0xE0, 0x17,
  0x28, 0x36, 0xEE, 0xB2, 0x73,
  // "Ā" (U+0100)
  0x70, 0x98, 0x02, 0xD7, 0x0D, 0xD0, 0xD8, 0x0C, 0x00, 0x02, 0xA0, 0xC7, 0x30, 0x8A, 0x0D, 0x73,
  0x82, 0xEE, 0xFD, 0x72, 0x83, 0x6F, 0x9F, 0xE7, 0x28, 0x1D, 0xF3, 0xA7, 0x18, 0x15, 0xFC, 0x1A,
  0x71, 0x81, 0xBF, 0x61, 0xA7, 0x03, 0xA0, 0x11, 0xA0, 0x16, 0x81, 0xAF, 0x92, 0x81, 0xEF, 0x15,
  0x01, 0xA0, 0x32, 0x81, 0xEF, 0x25, 0x81, 0x8F, 0xD3, 0x81, 0xEF, 0x35, 0x81, 0xEF, 0x73, 0x81,
  0xEF, 0x34, 0x06, 0xF9, 0x04, 0x40, 0xDF, 0x90, 0x43, 0x04, 0xA0, 0x34, 0x81, 0xEF, 0x53, 0x81,
  0xBF, 0xC5, 0x81, 0xDF, 0x62, 0x02, 0xA0, 0x55, 0x81, 0xDF, 0x62, 0x81, 0x9F, 0xD6, 0x86, 0xCF,
  0x70, 0x1E, 0xF6, 0x68, 0x5B, 0xF7, 0x07, 0xFE, 0x78, 0x1B, 0xF8, 0x10,
  // "ā" (U+0101)
  0x50, 0x98, 0x02, 0xD6, 0x0D, 0xD0, 0xD7, 0x77, 0x73, 0x87, 0x19, 0xEE, 0x80, 0x8F, 0x43, 0x02,
  0x0E, 0xA8, 0x4E, 0xF6, 0xCF, 0x13, 0x87, 0xDF, 0xC1, 0x07, 0xEF, 0xD3, 0x82, 0x7F, 0xE1, 0x3A,
  0x0A, 0x38, 0x1D, 0xF6, 0x48, 0x1E, 0xF7, 0x20, 0x4A, 0x5A, 0x04, 0x28, 0x19, 0xFB, 0x40, 0x1A,
  0x38, 0x1C, 0xF7, 0x48, 0x14, 0xFD, 0x38, 0x1E, 0xF4, 0x48, 0x18, 0xFA, 0x3A, 0x02, 0x48, 0x1E,
  0xF6, 0x20, 0x2A, 0x01, 0x30, 0x5A, 0x03, 0x20, 0x1A, 0x02, 0x30, 0xDA, 0x48, 0x7E, 0xF9, 0x01,
  0xBD, 0xFC, 0x40, 0x7A, 0x84, 0xEF, 0xC5, 0xF9, 0x58, 0x69, 0xEE, 0x91, 0x5F, 0x63,
  // "Ă" (U+0102)
  0x78, 0x11, 0x71, 0x28, 0x11, 0x72, 0x78, 0x13, 0xF7, 0x28, 0x19, 0xF1, 0x78, 0x21, 0xEF, 0xEA,
  0x08, 0x72, 0x83, 0x4C, 0xED, 0x78, 0x0C, 0x40, 0x02, 0xA0, 0xC7, 0x40, 0x8A, 0x0D, 0x74, 0x82,
  0xEE, 0xFD, 0x73, 0x83, 0x6F, 0x9F, 0xE7, 0x38, 0x1D, 0xF3, 0xA7, 0x28, 0x15, 0xFC, 0x1A, 0x72,
  0x81, 0xBF, 0x61, 0xA7, 0x10, 0x3A, 0x01, 0x1A, 0x01, 0x78, 0x1A, 0xF9, 0x28, 0x1E, 0xF1, 0x60,
  0x1A, 0x03, 0x28, 0x1E, 0xF2, 0x68, 0x18, 0xFD, 0x38, 0x1E, 0xF3, 0x68, 0x1E, 0xF7, 0x38, 0x1E,
  0xF3, 0x50, 0x6F, 0x90, 0x45, 0x0D, 0xF9, 0x04, 0x40, 0x4A, 0x03, 0x48, 0x1E, 0xF5, 0x48, 0x1B,
  0xFC, 0x58, 0x1D, 0xF6, 0x30, 0x2A, 0x05, 0x58, 0x1D, 0xF6, 0x38, 0x19, 0xFD, 0x68, 0x1C, 0xF7,
  0x28, 0x21, 0xEF, 0x66, 0x81, 0xBF, 0x72, 0x81, 0x7F, 0xE7, 0x81, 0xBF, 0x82,
  // "ă" (U+0103)
  0x58, 0x11, 0x71, 0x28, 0x11, 0x72, 0x58, 0x13, 0xF7, 0x28, 0x19, 0xF1, 0x58, 0x21, 0xEF, 0xEA,
  0x08, 0x78, 0x34, 0xCE, 0xD7, 0x77, 0x77, 0x48, 0x71, 0x9E, 0xE8, 0x08, 0xF4, 0x30, 0x20, 0xEA,
  0x84, 0xEF, 0x6C, 0xF1, 0x38, 0x7D, 0xFC, 0x10, 0x7E, 0xFD, 0x38, 0x27, 0xFE, 0x13, 0xA0, 0xA3,
  0x81, 0xDF, 0x64, 0x81, 0xEF, 0x72, 0x04, 0xA5, 0xA0, 0x42, 0x81, 0x9F, 0xB4, 0x01, 0xA3, 0x81,
  0xCF, 0x74, 0x81, 0x4F, 0xD3, 0x81, 0xEF, 0x44, 0x81, 0x8F, 0xA3, 0xA0, 0x24, 0x81, 0xEF, 0x62,
  0x02, 0xA0, 0x13, 0x05, 0xA0, 0x32, 0x01, 0xA0, 0x23, 0x0D, 0xA4, 0x87, 0xEF, 0x90, 0x1B, 0xDF,
  0xC4, 0x07, 0xA8, 0x4E, 0xFC, 0x5F, 0x95, 0x86, 0x9E, 0xE9, 0x15, 0xF6, 0x30,
  // "Ą" (U+0104)
  0x71, 0x02, 0xA0, 0xC7, 0x20, 0x8A, 0x0D, 0x72, 0x82, 0xEE, 0xFD, 0x71, 0x83, 0x6F, 0x9F, 0xE7,
  0x18, 0x1D, 0xF3, 0xA7, 0x81, 0x5F, 0xC1, 0xA7, 0x81, 0xBF, 0x61, 0xA6, 0x03, 0xA0, 0x11, 0xA0,
  0x15, 0x81, 0xAF, 0x92, 0x81, 0xEF, 0x14, 0x01, 0xA0, 0x32, 0x81, 0xEF, 0x24, 0x81, 0x8F, 0xD3,
  0x81, 0xEF, 0x34, 0x81, 0xEF, 0x73, 0x81, 0xEF, 0x33, 0x06, 0xF9, 0x04, 0x30, 0xDF, 0x90, 0x42,
  0x04, 0xA0, 0x34, 0x81, 0xEF, 0x52, 0x81, 0xBF, 0xC5, 0x83, 0xDF, 0x60, 0x2A, 0x05, 0x58, 0x5D,
  0xF6, 0x09, 0xFD, 0x68, 0x5C, 0xF7, 0x1E, 0xF6, 0x68, 0x4B, 0xF7, 0x7F, 0xE7, 0x81, 0xBF, 0x87,
  0x28, 0x13, 0xD6, 0x72, 0x81, 0x3E, 0x77, 0x30, 0x0D, 0x73, 0x81, 0x2F, 0xC7, 0x30, 0x2A, 0x0E,
  0x07, 0x72, 0x82, 0x8E, 0xE4, 0x10,
  // "ą" (U+0105)
  0x48, 0x71, 0x9E, 0xE8, 0x08, 0xF4, 0x30, 0x20, 0xEA, 0x84, 0xEF, 0x6C, 0xF1, 0x38, 0x7D, 0xFC,
  0x10, 0x7E, 0xFD, 0x38, 0x27, 0xFE, 0x13, 0xA0, 0xA3, 0x81, 0xDF, 0x64, 0x81, 0xEF, 0x72, 0x04,
  0xA5, 0xA0, 0x42, 0x81, 0x9F, 0xB4, 0x01, 0xA3, 0x81, 0xCF, 0x74, 0x81, 0x4F, 0xD3, 0x81, 0xEF,
  0x44, 0x81, 0x8F, 0xA3, 0xA0, 0x24, 0x81, 0xEF, 0x62, 0x02, 0xA0, 0x13, 0x05, 0xA0, 0x32, 0x01,
  0xA0, 0x23, 0x0D, 0xA4, 0x87, 0xEF, 0x90, 0x1B, 0xDF, 0xC4, 0x07, 0xA8, 0x4E, 0xFC, 0x5F, 0x95,
  0x86, 0x9E, 0xE9, 0x15, 0xF6, 0x72, 0x81, 0x3D, 0x67, 0x28, 0x13, 0xE7, 0x73, 0x00, 0xD7, 0x38,
  0x12, 0xFC, 0x73, 0x02, 0xA0, 0xE0, 0x77, 0x28, 0x28, 0xEE, 0x44,
  // "Ć" (U+0106)
  0x73, 0x81, 0x77, 0x47, 0x28, 0x28, 0xFD, 0x17, 0x18, 0x24, 0xFE, 0x27, 0x18, 0x21, 0xEE, 0x27,
  0x28, 0x1B, 0xD2, 0x77, 0x77, 0x78, 0x55, 0xBE, 0xED, 0x93, 0x40, 0x20, 0xCB, 0x0E, 0xA0, 0x73,
  0x83, 0x1D, 0xFD, 0x42, 0x02, 0x09, 0x48, 0x2C, 0xFC, 0x17, 0x18, 0x26, 0xFE, 0x27, 0x28, 0x1E,
  0xF7, 0x72, 0x81, 0x5F, 0xE7, 0x38, 0x1B, 0xF9, 0x73, 0xA0, 0x57, 0x20, 0x4A, 0x01, 0x72, 0x81,
  0x7F, 0xD7, 0x38, 0x19, 0xFB, 0x73, 0x81, 0xAF, 0x97, 0x38, 0x1B, 0xF9, 0x73, 0x81, 0xAF, 0xA7,
  0x38, 0x18, 0xFC, 0x73, 0x04, 0xA0, 0x37, 0x38, 0x2D, 0xFD, 0x22, 0x02, 0x06, 0x50, 0x30, 0xEA,
  0x0E, 0xA0, 0xD6, 0x85, 0x2A, 0xEF, 0xEB, 0x64,
  // "ć" (U+0107)
  0x71, 0x81, 0x77, 0x47, 0x82, 0x8F, 0xD1, 0x68, 0x24, 0xFE, 0x26, 0x82, 0x1E, 0xE2, 0x78, 0x1B,
  0xD2, 0x77, 0x77, 0x28, 0x48, 0xDF, 0xDA, 0x13, 0x01, 0x0D, 0xA8, 0x1E, 0xFE, 0x48, 0x5C, 0xFB,
  0x20, 0x14, 0x38, 0x17, 0xFD, 0x71, 0x81, 0xEF, 0x47, 0x81, 0x5F, 0xD7, 0x18, 0x19, 0xF9, 0x71,
  0x81, 0xDF, 0x57, 0x1A, 0x03, 0x70, 0x1A, 0x01, 0x70, 0x1A, 0x01, 0x71, 0xA0, 0x47, 0x18, 0x5C,
  0xFC, 0x10, 0x16, 0x40, 0x4B, 0x81, 0xEF, 0xD5, 0x84, 0x4C, 0xFE, 0xB5, 0x30,
  // "Ĉ" (U+0108)
  0x71, 0x81, 0x57, 0x47, 0x20, 0x3A, 0x0C, 0x71, 0x84, 0x1E, 0xEC, 0xF2, 0x78, 0x4C, 0xD2, 0x3F,
  0x96, 0x81, 0xBC, 0x12, 0x81, 0x7F, 0x17, 0x77, 0x74, 0x85, 0x5B, 0xEE, 0xD9, 0x34, 0x02, 0x0C,
  0xB0, 0xEA, 0x07, 0x38, 0x31, 0xDF, 0xD4, 0x20, 0x20, 0x94, 0x82, 0xCF, 0xC1, 0x71, 0x82, 0x6F,
  0xE2, 0x72, 0x81, 0xEF, 0x77, 0x28, 0x15, 0xFE, 0x73, 0x81, 0xBF, 0x97, 0x3A, 0x05, 0x72, 0x04,
  0xA0, 0x17, 0x28, 0x17, 0xFD, 0x73, 0x81, 0x9F, 0xB7, 0x38, 0x1A, 0xF9, 0x73, 0x81, 0xBF, 0x97,
  0x38, 0x1A, 0xFA, 0x73, 0x81, 0x8F, 0xC7, 0x30, 0x4A, 0x03, 0x73, 0x82, 0xDF, 0xD2, 0x20, 0x20,
  0x65, 0x03, 0x0E, 0xA0, 0xEA, 0x0D, 0x68, 0x52, 0xAE, 0xFE, 0xB6, 0x40,
  // "ĉ" (U+0109)
  0x78, 0x15, 0x74, 0x71, 0x03, 0xA0, 0xC7, 0x84, 0x1E, 0xEC, 0xF2, 0x68, 0x4C, 0xD2, 0x3F, 0x95,
  0x81, 0xBC, 0x12, 0x81, 0x7F, 0x17, 0x77, 0x71, 0x84, 0x8D, 0xFD, 0xA1, 0x40, 0x10, 0xDA, 0x81,
  0xEF, 0xE5, 0x85, 0xCF, 0xB2, 0x01, 0x44, 0x81, 0x7F, 0xD7, 0x28, 0x1E, 0xF4, 0x71, 0x81, 0x5F,
  0xD7, 0x28, 0x19, 0xF9, 0x72, 0x81, 0xDF, 0x57, 0x2A, 0x03, 0x71, 0x01, 0xA0, 0x17, 0x10, 0x1A,
  0x01, 0x72, 0xA0, 0x47, 0x28, 0x5C, 0xFC, 0x10, 0x16, 0x50, 0x4B, 0x81, 0xEF, 0xD6, 0x84, 0x4C,
  0xFE, 0xB5, 0x40,
  // "Ċ" (U+010A)
  0x71, 0x81, 0x2D, 0xC7, 0x30, 0x8A, 0x73, 0x81, 0x5E, 0x87, 0x77, 0x76, 0x85, 0x5B, 0xEE, 0xD9,
  0x34, 0x02, 0x0C, 0xB0, 0xEA, 0x07, 0x38, 0x31, 0xDF, 0xD4, 0x20, 0x20, 0x94, 0x82, 0xCF, 0xC1,
  0x71, 0x82, 0x6F, 0xE2, 0x72, 0x81, 0xEF, 0x77, 0x28, 0x15, 0xFE, 0x73, 0x81, 0xBF, 0x97, 0x3A,
  0x05, 0x72, 0x04, 0xA0, 0x17, 0x28, 0x17, 0xFD, 0x73, 0x81, 0x9F, 0xB7, 0x38, 0x1A, 0xF9, 0x73,
  0x81, 0xBF, 0x97, 0x38, 0x1A, 0xFA, 0x73, 0x81, 0x8F, 0xC7, 0x30, 0x4A, 0x03, 0x73, 0x82, 0xDF,
  0xD2, 0x20, 0x20, 0x65, 0x03, 0x0E, 0xA0, 0xEA, 0x0D, 0x68, 0x52, 0xAE, 0xFE, 0xB6, 0x40,
  // "ċ" (U+010B)
  0x68, 0x12, 0xDC, 0x71, 0x08, 0xA7, 0x18, 0x15, 0xE8, 0x77, 0x77, 0x18, 0x48, 0xDF, 0xDA, 0x13,
  0x01, 0x0D, 0xA8, 0x1E, 0xFE, 0x48, 0x5C, 0xFB, 0x20, 0x14, 0x38, 0x17, 0xFD, 0x71, 0x81, 0xEF,
  0x47, 0x81, 0x5F, 0xD7, 0x18, 0x19, 0xF9, 0x71, 0x81, 0xDF, 0x57, 0x1A, 0x03, 0x70, 0x1A, 0x01,
  0x70, 0x1A, 0x01, 0x71, 0xA0, 0x47, 0x18, 0x5C, 0xFC, 0x10, 0x16, 0x40, 0x4B, 0x81, 0xEF, 0xD5,
  0x84, 0x4C, 0xFE, 0xB5, 0x30,
  // "Č" (U+010C)
  0x70, 0x70, 0x33, 0x04, 0x07, 0x70, 0xB0, 0xD2, 0x81, 0x7F, 0x57, 0x84, 0x5F, 0x87, 0xF7, 0x72,
  0x0E, 0xA0, 0xA7, 0x38, 0x18, 0xFD, 0x80, 0xC1, 0x08, 0x55, 0xBE, 0xED, 0x93, 0x50, 0x20, 0xCB,
  0x0E, 0xA0, 0x74, 0x83, 0x1D, 0xFD, 0x42, 0x02, 0x09, 0x58, 0x2C, 0xFC, 0x17, 0x28, 0x26, 0xFE,
  0x27, 0x38, 0x1E, 0xF7, 0x73, 0x81, 0x5F, 0xE7, 0x48, 0x1B, 0xF9, 0x74, 0xA0, 0x57, 0x30, 0x4A,
  0x01, 0x73, 0x81, 0x7F, 0xD7, 0x48, 0x19, 0xFB, 0x74, 0x81, 0xAF, 0x97, 0x48, 0x1B, 0xF9, 0x74,
  0x81, 0xAF, 0xA7, 0x48, 0x18, 0xFC, 0x74, 0x04, 0xA0, 0x37, 0x48, 0x2D, 0xFD, 0x22, 0x02, 0x06,
  0x60, 0x30, 0xEA, 0x0E, 0xA0, 0xD7, 0x85, 0x2A, 0xEF, 0xEB, 0x65,
  // "č" (U+010D)
  0x50, 0x70, 0x33, 0x04, 0x07, 0x50, 0xB0, 0xD2, 0x81, 0x7F, 0x55, 0x84, 0x5F, 0x87, 0xF7, 0x70,
  0xEA, 0x0A, 0x71, 0x81, 0x8F, 0xD7, 0x77, 0x74, 0x84, 0x8D, 0xFD, 0xA1, 0x40, 0x10, 0xDA, 0x81,
  0xEF, 0xE5, 0x85, 0xCF, 0xB2, 0x01, 0x44, 0x81, 0x7F, 0xD7, 0x28, 0x1E, 0xF4, 0x71, 0x81, 0x5F,
  0xD7, 0x28, 0x19, 0xF9, 0x72, 0x81, 0xDF, 0x57, 0x2A, 0x03, 0x71, 0x01, 0xA0, 0x17, 0x10, 0x1A,
  0x01, 0x72, 0xA0, 0x47, 0x28, 0x5C, 0xFC, 0x10, 0x16, 0x50, 0x4B, 0x81, 0xEF, 0xD6, 0x84, 0x4C,
  0xFE, 0xB5, 0x40,
  // "Ď" (U+010E)
  0x70, 0x70, 0x33, 0x04, 0x07, 0x70, 0xB0, 0xD2, 0x81, 0x7F, 0x57, 0x84, 0x5F, 0x87, 0xF7, 0x72,
  0x0E, 0xA0, 0xA7, 0x38, 0x18, 0xFD, 0x77, 0x77, 0x70, 0xAB, 0x81, 0xEC, 0x77, 0x82, 0xDF, 0xED,
  0xB0, 0xD0, 0x14, 0x01, 0xA0, 0x12, 0x82, 0x5E, 0xFB, 0x48, 0x14, 0xFE, 0x40, 0x5A, 0x03, 0x38,
  0x17, 0xFB, 0x58, 0x1E, 0xF7, 0x38, 0x1B, 0xF7, 0x58, 0x1C, 0xF9, 0x38, 0x1E, 0xF4, 0x58, 0x1B,
  0xF9, 0x20, 0x1A, 0x01, 0x58, 0x1B, 0xF9, 0x28, 0x15, 0xFE, 0x68, 0x1C, 0xF8, 0x28, 0x18, 0xFA,
  0x6A, 0x06, 0x28, 0x1B, 0xF7, 0x50, 0x2A, 0x03, 0x28, 0x1E, 0xF4, 0x50, 0x6A, 0x20, 0x2A, 0x01,
  0x58, 0x1A, 0xFB, 0x28, 0x15, 0xFD, 0x50, 0x1A, 0x05, 0x28, 0x18, 0xFA, 0x58, 0x18, 0xFE, 0x38,
  0x1B, 0xF7, 0x40, 0x3A, 0x06, 0x38, 0x1E, 0xF4, 0x38, 0x22, 0xDF, 0xB3, 0x02, 0xA0, 0x12, 0x83,
  0x6E, 0xFC, 0x13, 0x05, 0xA0, 0xD0, 0xEB, 0x0A, 0x01, 0x40, 0x8B, 0x82, 0xED, 0x93, 0x60,
  // "ď" (U+010F)
  0x74, 0x85, 0x9F, 0x80, 0xCF, 0x67, 0x48, 0x4C, 0xF5, 0x1F, 0xE7, 0x5A, 0x82, 0x27, 0xF5, 0x74,
  0x84, 0x3F, 0xE0, 0xDB, 0x75, 0x84, 0x6F, 0xB1, 0x71, 0x75, 0x81, 0x9F, 0x87, 0x28, 0x72, 0xAE,
  0xE8, 0x0C, 0xF4, 0x71, 0x02, 0x0E, 0xA8, 0x4E, 0xF7, 0xEF, 0x17, 0x18, 0x7D, 0xFB, 0x10, 0x6E,
  0xFD, 0x71, 0x82, 0x7F, 0xE1, 0x38, 0x1E, 0xFA, 0x71, 0x81, 0xEF, 0x74, 0x81, 0xDF, 0x77, 0x04,
  0xA0, 0x14, 0x81, 0xEF, 0x47, 0x81, 0x8F, 0xB4, 0x01, 0xA0, 0x17, 0x81, 0xCF, 0x74, 0x81, 0x5F,
  0xD7, 0x18, 0x1E, 0xF4, 0x48, 0x19, 0xFA, 0x71, 0xA0, 0x24, 0x81, 0xEF, 0x67, 0x02, 0xA0, 0x13,
  0x06, 0xA0, 0x37, 0x01, 0xA0, 0x22, 0x01, 0x0D, 0xA7, 0x28, 0x7E, 0xF9, 0x01, 0xBD, 0xFC, 0x72,
  0x08, 0xA8, 0x4E, 0xFC, 0x5F, 0x97, 0x38, 0x69, 0xEE, 0x90, 0x6F, 0x67, 0x10,
  // "Đ" (U+0110)
  0x40, 0xAB, 0x81, 0xEC, 0x77, 0x82, 0xDF, 0xED, 0xB0, 0xD0, 0x14, 0x01, 0xA0, 0x12, 0x82, 0x5E,
  0xFB, 0x48, 0x14, 0xFE, 0x40, 0x5A, 0x03, 0x38, 0x17, 0xFB, 0x58, 0x1E, 0xF7, 0x38, 0x1A, 0xF8,
  0x58, 0x1C, 0xF9, 0x38, 0x1E, 0xF5, 0x58, 0x1B, 0xF9, 0x20, 0x1A, 0x01, 0x58, 0x1C, 0xF9, 0x28,
  0x14, 0xFE, 0x68, 0x1D, 0xF8, 0x1E, 0x09, 0x3A, 0x81, 0x62, 0xDA, 0x82, 0xED, 0xD5, 0x20, 0x2A,
  0x03, 0x28, 0x1E, 0xF4, 0x50, 0x6A, 0x20, 0x1A, 0x01, 0x58, 0x1A, 0xFB, 0x28, 0x15, 0xFD, 0x50,
  0x1A, 0x05, 0x28, 0x18, 0xFA, 0x58, 0x18, 0xFE, 0x38, 0x1B, 0xF7, 0x40, 0x3A, 0x06, 0x38, 0x1E,
  0xF4, 0x38, 0x22, 0xDF, 0xB3, 0x02, 0xA8, 0x61, 0x01, 0x6E, 0xFC, 0x13, 0x05, 0xA0, 0xD0, 0xEB,
  0x0A, 0x01, 0x40, 0x8B, 0x82, 0xED, 0x93, 0x60,
  // "đ" (U+0111)
  0x74, 0x81, 0x9F, 0x87, 0x58, 0x1C, 0xF5, 0x71, 0x03, 0x0F, 0xAA, 0x0B, 0x08, 0x70, 0x7E, 0x09,
  0x73, 0x81, 0x7F, 0xA7, 0x58, 0x19, 0xF7, 0x68, 0x72, 0xAE, 0xE8, 0x0C, 0xF4, 0x50, 0x20, 0xEA,
  0x84, 0xEF, 0x7E, 0xF1, 0x58, 0x4D, 0xFB, 0x10, 0x6A, 0x0D, 0x58, 0x27, 0xFD, 0x13, 0x81, 0xEF,
  0xA5, 0x81, 0xEF, 0x64, 0x81, 0xDF, 0x74, 0x81, 0x4F, 0xE5, 0x81, 0xEF, 0x44, 0x81, 0x8F, 0xA4,
  0x01, 0xA5, 0x81, 0xCF, 0x74, 0x81, 0x5F, 0xD5, 0xA0, 0x44, 0x81, 0x9F, 0x95, 0xA0, 0x24, 0x81,
  0xEF, 0x64, 0x02, 0xA0, 0x13, 0x06, 0xA0, 0x34, 0x01, 0xA0, 0x22, 0x01, 0x0D, 0xA6, 0x87, 0xEF,
  0x90, 0x1B, 0xDF, 0xC6, 0x07, 0xA8, 0x4E, 0xFC, 0x5F, 0x97, 0x86, 0x9E, 0xE9, 0x06, 0xF6, 0x50,
  // "Ē" (U+0112)
  0x50, 0x98, 0x02, 0xD6, 0x0D, 0xD0, 0xD7, 0x77, 0x73, 0x0A, 0xF0, 0x14, 0x86, 0xDF, 0xED, 0xDD,
  0xDC, 0x40, 0x1A, 0x01, 0x72, 0x81, 0x4F, 0xE7, 0x38, 0x17, 0xFB, 0x73, 0x81, 0xBF, 0x87, 0x38,
  0x1E, 0xF5, 0x72, 0x01, 0xA0, 0x27, 0x20, 0x5A, 0x73, 0x08, 0xF5, 0x86, 0xBF, 0xED, 0xDD, 0xDB,
  0x58, 0x1E, 0xF5, 0x72, 0x02, 0xA0, 0x27, 0x28, 0x15, 0xFE, 0x73, 0x81, 0x8F, 0xB7, 0x38, 0x1B,
  0xF8, 0x73, 0x81, 0xEF, 0x47, 0x20, 0x2A, 0x01, 0x72, 0x05, 0xA8, 0x01, 0xD0, 0x64, 0x08, 0xF0,
  0x44,
  // "ē" (U+0113)
  0x40, 0x98, 0x02, 0xD4, 0x0D, 0xD0, 0xD7, 0x77, 0x58, 0x41, 0x8D, 0xED, 0x64, 0x02, 0x0D, 0xA0,
  0xEA, 0x04, 0x38, 0x1C, 0xF9, 0x28, 0x19, 0xF9, 0x28, 0x18, 0xFB, 0x38, 0x66, 0xF9, 0x01, 0xEF,
  0x23, 0x85, 0xCF, 0x60, 0x5F, 0xB2, 0x82, 0x4C, 0xFD, 0x28, 0x2A, 0xFE, 0xEB, 0x0C, 0x01, 0x20,
  0xDA, 0x82, 0xED, 0xA5, 0x4A, 0x02, 0x70, 0x1A, 0x71, 0x02, 0xA0, 0x17, 0x1A, 0x04, 0x71, 0x82,
  0xCF, 0xD2, 0x20, 0x40, 0x73, 0x03, 0xB0, 0xEA, 0x0A, 0x48, 0x53, 0xBE, 0xED, 0x82, 0x20,
  // "Ĕ" (U+0114)
  0x58, 0x11, 0x71, 0x28, 0x11, 0x72, 0x58, 0x13, 0xF7, 0x28, 0x19, 0xF1, 0x58, 0x21, 0xEF, 0xEA,
  0x08, 0x78, 0x34, 0xCE, 0xD7, 0x77, 0x77, 0x40, 0xAF, 0x01, 0x48, 0x6D, 0xFE, 0xDD, 0xDD, 0xC4,
  0x01, 0xA0, 0x17, 0x28, 0x14, 0xFE, 0x73, 0x81, 0x7F, 0xB7, 0x38, 0x1B, 0xF8, 0x73, 0x81, 0xEF,
  0x57, 0x20, 0x1A, 0x02, 0x72, 0x05, 0xA7, 0x30, 0x8F, 0x58, 0x6B, 0xFE, 0xDD, 0xDD, 0xB5, 0x81,
  0xEF, 0x57, 0x20, 0x2A, 0x02, 0x72, 0x81, 0x5F, 0xE7, 0x38, 0x18, 0xFB, 0x73, 0x81, 0xBF, 0x87,
  0x38, 0x1E, 0xF4, 0x72, 0x02, 0xA0, 0x17, 0x20, 0x5A, 0x80, 0x1D, 0x06, 0x40, 0x8F, 0x04, 0x40,
  // "ĕ" (U+0115)
  0x48, 0x11, 0x71, 0x28, 0x11, 0x72, 0x48, 0x13, 0xF7, 0x28, 0x19, 0xF1, 0x48, 0x21, 0xEF, 0xEA,
  0x08, 0x68, 0x34, 0xCE, 0xD7, 0x77, 0x77, 0x28, 0x41, 0x8D, 0xED, 0x65, 0x02, 0x0D, 0xA0, 0xEA,
  0x04, 0x48, 0x1C, 0xF9, 0x28, 0x19, 0xF9, 0x38, 0x18, 0xFB, 0x38, 0x16, 0xF9, 0x28, 0x21, 0xEF,
  0x23, 0x81, 0xCF, 0x62, 0x81, 0x5F, 0xB2, 0x82, 0x4C, 0xFD, 0x38, 0x2A, 0xFE, 0xEB, 0x0C, 0x01,
  0x30, 0xDA, 0x82, 0xED, 0xA5, 0x5A, 0x02, 0x71, 0x01, 0xA7, 0x20, 0x2A, 0x01, 0x72, 0xA0, 0x47,
  0x28, 0x2C, 0xFD, 0x22, 0x04, 0x07, 0x40, 0x3B, 0x0E, 0xA0, 0xA5, 0x85, 0x3B, 0xEE, 0xD8, 0x23,
  // "Ė" (U+0116)
  0x78, 0x12, 0xDC, 0x73, 0x08, 0xA7, 0x38, 0x15, 0xE8, 0x77, 0x60, 0xAF, 0x01, 0x48, 0x6D, 0xFE,
  0xDD, 0xDD, 0xC4, 0x01, 0xA0, 0x17, 0x28, 0x14, 0xFE, 0x73, 0x81, 0x7F, 0xB7, 0x38, 0x1B, 0xF8,
  0x73, 0x81, 0xEF, 0x57, 0x20, 0x1A, 0x02, 0x72, 0x05, 0xA7, 0x30, 0x8F, 0x58, 0x6B, 0xFE, 0xDD,
  0xDD, 0xB5, 0x81, 0xEF, 0x57, 0x20, 0x2A, 0x02, 0x72, 0x81, 0x5F, 0xE7, 0x38, 0x18, 0xFB, 0x73,
  0x81, 0xBF, 0x87, 0x38, 0x1E, 0xF4, 0x72, 0x02, 0xA0, 0x17, 0x20, 0x5A, 0x80, 0x1D, 0x06, 0x40,
  0x8F, 0x04, 0x40,
  // "ė" (U+0117)
  0x78, 0x12, 0xDC, 0x71, 0x08, 0xA7, 0x18, 0x15, 0xE8, 0x77, 0x76, 0x84, 0x18, 0xDE, 0xD6, 0x40,
  0x20, 0xDA, 0x0E, 0xA0, 0x43, 0x81, 0xCF, 0x92, 0x81, 0x9F, 0x92, 0x81, 0x8F, 0xB3, 0x86, 0x6F,
  0x90, 0x1E, 0xF2, 0x38, 0x5C, 0xF6, 0x05, 0xFB, 0x28, 0x24, 0xCF, 0xD2, 0x82, 0xAF, 0xEE, 0xB0,
  0xC0, 0x12, 0x0D, 0xA8, 0x2E, 0xDA, 0x54, 0xA0, 0x27, 0x01, 0xA7, 0x10, 0x2A, 0x01, 0x71, 0xA0,
  0x47, 0x18, 0x2C, 0xFD, 0x22, 0x04, 0x07, 0x30, 0x3B, 0x0E, 0xA0, 0xA4, 0x85, 0x3B, 0xEE, 0xD8,
  0x22,
  // "Ę" (U+0118)
  0x40, 0xAF, 0x01, 0x48, 0x6D, 0xFE, 0xDD, 0xDD, 0xC4, 0x01, 0xA0, 0x17, 0x28, 0x14, 0xFE, 0x73,
  0x81, 0x7F, 0xB7, 0x38, 0x1B, 0xF8, 0x73, 0x81, 0xEF, 0x57, 0x20, 0x1A, 0x02, 0x72, 0x05, 0xA7,
  0x30, 0x8F, 0x58, 0x6B, 0xFE, 0xDD, 0xDD, 0xB5, 0x81, 0xEF, 0x57, 0x20, 0x2A, 0x02, 0x72, 0x81,
  0x5F, 0xE7, 0x38, 0x18, 0xFB, 0x73, 0x81, 0xBF, 0x87, 0x38, 0x1E, 0xF4, 0x72, 0x02, 0xA0, 0x17,
  0x20, 0x5A, 0x80, 0x1D, 0x06, 0x40, 0x8F, 0x04, 0x71, 0x81, 0x3D, 0x67, 0x28, 0x13, 0xE7, 0x73,
  0x00, 0xD7, 0x38, 0x12, 0xFC, 0x73, 0x02, 0xA0, 0xE0, 0x77, 0x28, 0x28, 0xEE, 0x46,
  // "ę" (U+0119)
  0x48, 0x41, 0x8D, 0xED, 0x64, 0x02, 0x0D, 0xA0, 0xEA, 0x04, 0x38, 0x1C, 0xF9, 0x28, 0x19, 0xF9,
  0x28, 0x18, 0xFB, 0x38, 0x66, 0xF9, 0x01, 0xEF, 0x23, 0x85, 0xCF, 0x60, 0x5F, 0xB2, 0x82, 0x4C,
  0xFD, 0x28, 0x2A, 0xFE, 0xEB, 0x0C, 0x01, 0x20, 0xDA, 0x82, 0xED, 0xA5, 0x4A, 0x02, 0x70, 0x1A,
  0x71, 0x02, 0xA0, 0x17, 0x1A, 0x04, 0x71, 0x82, 0xCF, 0xD2, 0x20, 0x40, 0x73, 0x03, 0xB0, 0xEA,
  0x0A, 0x48, 0x13, 0xBE, 0xA0, 0xD0, 0x27, 0x81, 0xBD, 0x17, 0x81, 0x8F, 0x37, 0x81, 0x1F, 0xC7,
  0x18, 0x13, 0xFC, 0x71, 0x01, 0xB0, 0x67, 0x82, 0x6C, 0xC3, 0x30,
  // "Ě" (U+011A)
  0x60, 0x70, 0x33, 0x04, 0x07, 0x60, 0xB0, 0xD2, 0x81, 0x7F, 0x56, 0x84, 0x5F, 0x87, 0xF7, 0x71,
  0x0E, 0xA0, 0xA7, 0x28, 0x18, 0xFD, 0x77, 0x77, 0x50, 0xAF, 0x01, 0x48, 0x6D, 0xFE, 0xDD, 0xDD,
  0xC4, 0x01, 0xA0, 0x17, 0x28, 0x14, 0xFE, 0x73, 0x81, 0x7F, 0xB7, 0x38, 0x1B, 0xF8, 0x73, 0x81,
  0xEF, 0x57, 0x20, 0x1A, 0x02, 0x72, 0x05, 0xA7, 0x30, 0x8F, 0x58, 0x6B, 0xFE, 0xDD, 0xDD, 0xB5,
  0x81, 0xEF, 0x57, 0x20, 0x2A, 0x02, 0x72, 0x81, 0x5F, 0xE7, 0x38, 0x18, 0xFB, 0x73, 0x81, 0xBF,
  0x87, 0x38, 0x1E, 0xF4, 0x72, 0x02, 0xA0, 0x17, 0x20, 0x5A, 0x80, 0x1D, 0x06, 0x40, 0x8F, 0x04,
  0x40,
  // "ě" (U+011B)
  0x50, 0x70, 0x33, 0x04, 0x07, 0x50, 0xB0, 0xD2, 0x81, 0x7F, 0x55, 0x84, 0x5F, 0x87, 0xF7, 0x70,
  0xEA, 0x0A, 0x71, 0x81, 0x8F, 0xD7, 0x77, 0x73, 0x84, 0x18, 0xDE, 0xD6, 0x50, 0x20, 0xDA, 0x0E,
  0xA0, 0x44, 0x81, 0xCF, 0x92, 0x81, 0x9F, 0x93, 0x81, 0x8F, 0xB3, 0x81, 0x6F, 0x92, 0x82, 0x1E,
  0xF2, 0x38, 0x1C, 0xF6, 0x28, 0x15, 0xFB, 0x28, 0x24, 0xCF, 0xD3, 0x82, 0xAF, 0xEE, 0xB0, 0xC0,
  0x13, 0x0D, 0xA8, 0x2E, 0xDA, 0x55, 0xA0, 0x27, 0x10, 0x1A, 0x72, 0x02, 0xA0, 0x17, 0x2A, 0x04,
  0x72, 0x82, 0xCF, 0xD2, 0x20, 0x40, 0x74, 0x03, 0xB0, 0xEA, 0x0A, 0x58, 0x53, 0xBE, 0xED, 0x82,
  0x30,
  // "Ĝ" (U+011C)
  0x72, 0x81, 0x57, 0x47, 0x30, 0x3A, 0x0C, 0x72, 0x84, 0x1E, 0xEC, 0xF2, 0x71, 0x84, 0xCD, 0x23,
  0xF9, 0x78, 0x1B, 0xC1, 0x28, 0x17, 0xF1, 0x77, 0x77, 0x68, 0x64, 0xAE, 0xFE, 0xC7, 0x14, 0x01,
  0x0A, 0xB0, 0xEB, 0x0D, 0x38, 0x31, 0xDF, 0xE6, 0x38, 0x14, 0xB5, 0x38, 0x2B, 0xFD, 0x27, 0x20,
  0x6A, 0x02, 0x72, 0x82, 0x1E, 0xF8, 0x73, 0x82, 0x6F, 0xE1, 0x73, 0x81, 0xCF, 0x97, 0x30, 0x1A,
  0x04, 0x73, 0x04, 0xA4, 0x89, 0x05, 0xDD, 0xDD, 0x80, 0x7F, 0xD4, 0x09, 0xC8, 0x36, 0x09, 0xFB,
  0x7A, 0x83, 0x30, 0xAF, 0xA6, 0x03, 0xA2, 0x81, 0xBF, 0x96, 0x81, 0x6F, 0xC2, 0x81, 0xAF, 0xA6,
  0x81, 0x9F, 0x92, 0x81, 0x8F, 0xD6, 0x81, 0xCF, 0x62, 0x04, 0xA0, 0x45, 0xA0, 0x23, 0x82, 0xCF,
  0xE4, 0x38, 0x15, 0xFE, 0x40, 0x20, 0xDA, 0x00, 0xEB, 0x0C, 0x58, 0x71, 0x8C, 0xEE, 0xDB, 0x61,
  0x30,
  // "ĝ" (U+011D)
  0x71, 0x81, 0x57, 0x47, 0x30, 0x3A, 0x0C, 0x72, 0x84, 0x1E, 0xEC, 0xF2, 0x71, 0x84, 0xCD, 0x23,
  0xF9, 0x78, 0x1B, 0xC1, 0x28, 0x17, 0xF1, 0x77, 0x77, 0x68, 0x71, 0x9E, 0xE9, 0x08, 0xF4, 0x40,
  0x20, 0xDA, 0x84, 0xEF, 0x7C, 0xF1, 0x48, 0x7C, 0xFC, 0x10, 0x6E, 0xFD, 0x48, 0x27, 0xFE, 0x13,
  0x81, 0xEF, 0xA4, 0x81, 0xDF, 0x74, 0x81, 0xEF, 0x63, 0x04, 0xA0, 0x14, 0xA0, 0x33, 0x81, 0x8F,
  0xB4, 0x02, 0xA4, 0x81, 0xCF, 0x74, 0x81, 0x5F, 0xC4, 0x81, 0xEF, 0x44, 0x81, 0x9F, 0x94, 0xA0,
  0x23, 0x82, 0x1E, 0xF6, 0x30, 0x1A, 0x01, 0x30, 0x7A, 0x02, 0x30, 0x1A, 0x02, 0x28, 0x21, 0xEF,
  0xE5, 0x87, 0xEF, 0x90, 0x1C, 0xEF, 0xB5, 0x08, 0xA8, 0x4E, 0xFD, 0x9F, 0x86, 0x86, 0x9E, 0xE9,
  0x1B, 0xF5, 0x74, 0xA0, 0x17, 0x38, 0x15, 0xFD, 0x74, 0x81, 0xCF, 0x74, 0x81, 0x28, 0x22, 0x83,
  0x2A, 0xFE, 0x14, 0x03, 0xA0, 0x0E, 0xA0, 0xE0, 0x36, 0x85, 0x7B, 0xEF, 0xD9, 0x26,
  // "Ğ" (U+011E)
  0x68, 0x11, 0x71, 0x28, 0x11, 0x72, 0x68, 0x13, 0xF7, 0x28, 0x19, 0xF1, 0x68, 0x21, 0xEF, 0xEA,
  0x08, 0x71, 0x83, 0x4C, 0xED, 0x78, 0x0C, 0x00, 0x86, 0x4A, 0xEF, 0xEC, 0x71, 0x40, 0x10, 0xAB,
  0x0E, 0xB0, 0xD3, 0x83, 0x1D, 0xFE, 0x63, 0x81, 0x4B, 0x53, 0x82, 0xBF, 0xD2, 0x72, 0x06, 0xA0,
  0x27, 0x28, 0x21, 0xEF, 0x87, 0x38, 0x26, 0xFE, 0x17, 0x38, 0x1C, 0xF9, 0x73, 0x01, 0xA0, 0x47,
  0x30, 0x4A, 0x48, 0x90, 0x5D, 0xDD, 0xD8, 0x07, 0xFD, 0x40, 0x9C, 0x83, 0x60, 0x9F, 0xB7, 0xA8,
  0x33, 0x0A, 0xFA, 0x60, 0x3A, 0x28, 0x1B, 0xF9, 0x68, 0x16, 0xFC, 0x28, 0x1A, 0xFA, 0x68, 0x19,
  0xF9, 0x28, 0x18, 0xFD, 0x68, 0x1C, 0xF6, 0x20, 0x4A, 0x04, 0x5A, 0x02, 0x38, 0x2C, 0xFE, 0x43,
  0x81, 0x5F, 0xE4, 0x02, 0x0D, 0xA0, 0x0E, 0xB0, 0xC5, 0x87, 0x18, 0xCE, 0xED, 0xB6, 0x13,
  // "ğ" (U+011F)
  0x58, 0x11, 0x71, 0x28, 0x11, 0x72, 0x68, 0x13, 0xF7, 0x28, 0x19, 0xF1, 0x68, 0x21, 0xEF, 0xEA,
  0x08, 0x71, 0x83, 0x4C, 0xED, 0x78, 0x0C, 0x00, 0x87, 0x19, 0xEE, 0x90, 0x8F, 0x44, 0x02, 0x0D,
  0xA8, 0x4E, 0xF7, 0xCF, 0x14, 0x87, 0xCF, 0xC1, 0x06, 0xEF, 0xD4, 0x82, 0x7F, 0xE1, 0x38, 0x1E,
  0xFA, 0x48, 0x1D, 0xF7, 0x48, 0x1E, 0xF6, 0x30, 0x4A, 0x01, 0x4A, 0x03, 0x38, 0x18, 0xFB, 0x40,
  0x2A, 0x48, 0x1C, 0xF7, 0x48, 0x15, 0xFC, 0x48, 0x1E, 0xF4, 0x48, 0x19, 0xF9, 0x4A, 0x02, 0x38,
  0x21, 0xEF, 0x63, 0x01, 0xA0, 0x13, 0x07, 0xA0, 0x23, 0x01, 0xA0, 0x22, 0x82, 0x1E, 0xFE, 0x58,
  0x7E, 0xF9, 0x01, 0xCE, 0xFB, 0x50, 0x8A, 0x84, 0xEF, 0xD9, 0xF8, 0x68, 0x69, 0xEE, 0x91, 0xBF,
  0x57, 0x4A, 0x01, 0x73, 0x81, 0x5F, 0xD7, 0x48, 0x1C, 0xF7, 0x48, 0x12, 0x82, 0x28, 0x32, 0xAF,
  0xE1, 0x40, 0x3A, 0x00, 0xEA, 0x0E, 0x03, 0x68, 0x57, 0xBE, 0xFD, 0x92, 0x60,
  // "Ġ" (U+0120)
  0x72, 0x81, 0x2D, 0xC7, 0x40, 0x8A, 0x74, 0x81, 0x5E, 0x88, 0x0C, 0x00, 0x86, 0x4A, 0xEF, 0xEC,
  0x71, 0x40, 0x10, 0xAB, 0x0E, 0xB0, 0xD3, 0x83, 0x1D, 0xFE, 0x63, 0x81, 0x4B, 0x53, 0x82, 0xBF,
  0xD2, 0x72, 0x06, 0xA0, 0x27, 0x28, 0x21, 0xEF, 0x87, 0x38, 0x26, 0xFE, 0x17, 0x38, 0x1C, 0xF9,
  0x73, 0x01, 0xA0, 0x47, 0x30, 0x4A, 0x48, 0x90, 0x5D, 0xDD, 0xD8, 0x07, 0xFD, 0x40, 0x9C, 0x83,
  0x60, 0x9F, 0xB7, 0xA8, 0x33, 0x0A, 0xFA, 0x60, 0x3A, 0x28, 0x1B, 0xF9, 0x68, 0x16, 0xFC, 0x28,
  0x1A, 0xFA, 0x68, 0x19, 0xF9, 0x28, 0x18, 0xFD, 0x68, 0x1C, 0xF6, 0x20, 0x4A, 0x04, 0x5A, 0x02,
  0x38, 0x2C, 0xFE, 0x43, 0x81, 0x5F, 0xE4, 0x02, 0x0D, 0xA0, 0x0E, 0xB0, 0xC5, 0x87, 0x18, 0xCE,
  0xED, 0xB6, 0x13,
  // "ġ" (U+0121)
  0x78, 0x12, 0xDC, 0x74, 0x08, 0xA7, 0x48, 0x15, 0xE8, 0x80, 0xC1, 0x08, 0x71, 0x9E, 0xE9, 0x08,
  0xF4, 0x40, 0x20, 0xDA, 0x84, 0xEF, 0x7C, 0xF1, 0x48, 0x7C, 0xFC, 0x10, 0x6E, 0xFD, 0x48, 0x27,
  0xFE, 0x13, 0x81, 0xEF, 0xA4, 0x81, 0xDF, 0x74, 0x81, 0xEF, 0x63, 0x04, 0xA0, 0x14, 0xA0, 0x33,
  0x81, 0x8F, 0xB4, 0x02, 0xA4, 0x81, 0xCF, 0x74, 0x81, 0x5F, 0xC4, 0x81, 0xEF, 0x44, 0x81, 0x9F,
  0x94, 0xA0, 0x23, 0x82, 0x1E, 0xF6, 0x30, 0x1A, 0x01, 0x30, 0x7A, 0x02, 0x30, 0x1A, 0x02, 0x28,
  0x21, 0xEF, 0xE5, 0x87, 0xEF, 0x90, 0x1C, 0xEF, 0xB5, 0x08, 0xA8, 0x4E, 0xFD, 0x9F, 0x86, 0x86,
  0x9E, 0xE9, 0x1B, 0xF5, 0x74, 0xA0, 0x17, 0x38, 0x15, 0xFD, 0x74, 0x81, 0xCF, 0x74, 0x81, 0x28,
  0x22, 0x83, 0x2A, 0xFE, 0x14, 0x03, 0xA0, 0x0E, 0xA0, 0xE0, 0x36, 0x85, 0x7B, 0xEF, 0xD9, 0x26,
  // "Ģ" (U+0122)
  0x68, 0x64, 0xAE, 0xFE, 0xC7, 0x14, 0x01, 0x0A, 0xB0, 0xEB, 0x0D, 0x38, 0x31, 0xDF, 0xE6, 0x38,
  0x14, 0xB5, 0x38, 0x2B, 0xFD, 0x27, 0x20, 0x6A, 0x02, 0x72, 0x82, 0x1E, 0xF8, 0x73, 0x82, 0x6F,
  0xE1, 0x73, 0x81, 0xCF, 0x97, 0x30, 0x1A, 0x04, 0x73, 0x04, 0xA4, 0x89, 0x05, 0xDD, 0xDD, 0x80,
  0x7F, 0xD4, 0x09, 0xC8, 0x36, 0x09, 0xFB, 0x7A, 0x83, 0x30, 0xAF, 0xA6, 0x03, 0xA2, 0x81, 0xBF,
  0x96, 0x81, 0x6F, 0xC2, 0x81, 0xAF, 0xA6, 0x81, 0x9F, 0x92, 0x81, 0x8F, 0xD6, 0x81, 0xCF, 0x62,
  0x04, 0xA0, 0x45, 0xA0, 0x23, 0x82, 0xCF, 0xE4, 0x38, 0x15, 0xFE, 0x40, 0x20, 0xDA, 0x00, 0xEB,
  0x0C, 0x58, 0x71, 0x8C, 0xEE, 0xDB, 0x61, 0x77, 0x78, 0x11, 0x77, 0x74, 0x81, 0x7F, 0xB7, 0x48,
  0x1D, 0xF2, 0x73, 0x81, 0x6F, 0x67, 0x40, 0xD0, 0xA7, 0x20,
  // "ģ" (U+0123)
  0x73, 0x06, 0x04, 0x74, 0x81, 0x6F, 0x37, 0x38, 0x12, 0xFB, 0x74, 0x81, 0xBF, 0x47, 0x38, 0x13,
  0xFD, 0x80, 0xC1, 0x08, 0x71, 0x9E, 0xE9, 0x08, 0xF4, 0x40, 0x20, 0xDA, 0x84, 0xEF, 0x7C, 0xF1,
  0x48, 0x7C, 0xFC, 0x10, 0x6E, 0xFD, 0x48, 0x27, 0xFE, 0x13, 0x81, 0xEF, 0xA4, 0x81, 0xDF, 0x74,
  0x81, 0xEF, 0x63, 0x04, 0xA0, 0x14, 0xA0, 0x33, 0x81, 0x8F, 0xB4, 0x02, 0xA4, 0x81, 0xCF, 0x74,
  0x81, 0x5F, 0xC4, 0x81, 0xEF, 0x44, 0x81, 0x9F, 0x94, 0xA0, 0x23, 0x82, 0x1E, 0xF6, 0x30, 0x1A,
  0x01, 0x30, 0x7A, 0x02, 0x30, 0x1A, 0x02, 0x28, 0x21, 0xEF, 0xE5, 0x87, 0xEF, 0x90, 0x1C, 0xEF,
  0xB5, 0x08, 0xA8, 0x4E, 0xFD, 0x9F, 0x86, 0x86, 0x9E, 0xE9, 0x1B, 0xF5, 0x74, 0xA0, 0x17, 0x38,
  0x15, 0xFD, 0x74, 0x81, 0xCF, 0x74, 0x81, 0x28, 0x22, 0x83, 0x2A, 0xFE, 0x14, 0x03, 0xA0, 0x0E,
  0xA0, 0xE0, 0x36, 0x85, 0x7B, 0xEF, 0xD9, 0x26,
  // "Ĥ" (U+0124)
  0x72, 0x81, 0x57, 0x47, 0x40, 0x3A, 0x0C, 0x73, 0x84, 0x1E, 0xEC, 0xF2, 0x72, 0x84, 0xCD, 0x23,
  0xF9, 0x71, 0x81, 0xBC, 0x12, 0x81, 0x7F, 0x17, 0x77, 0x77, 0x81, 0xAF, 0x85, 0x03, 0xA4, 0x81,
  0xDF, 0x55, 0x81, 0x6F, 0xC3, 0x01, 0xA0, 0x25, 0x81, 0x9F, 0x93, 0x81, 0x4F, 0xE6, 0x81, 0xCF,
  0x53, 0x81, 0x7F, 0xB6, 0xA0, 0x23, 0x81, 0xAF, 0x85, 0x81, 0x3F, 0xE4, 0x81, 0xEF, 0x55, 0x81,
  0x6F, 0xB3, 0x01, 0xA0, 0x25, 0x81, 0x9F, 0x83, 0x04, 0xA0, 0x15, 0x81, 0xCF, 0x53, 0x08, 0xFB,
  0x02, 0x30, 0xBF, 0xA0, 0xE4, 0x81, 0xEF, 0x55, 0x81, 0x6F, 0xB3, 0x02, 0xA0, 0x25, 0x81, 0xAF,
  0x83, 0x81, 0x5F, 0xE6, 0x81, 0xDF, 0x43, 0x81, 0x8F, 0xB5, 0x01, 0xA0, 0x13, 0x81, 0xBF, 0x85,
  0x81, 0x4F, 0xE4, 0x81, 0xEF, 0x45, 0x81, 0x7F, 0xA3, 0x02, 0xA0, 0x15, 0x81, 0xAF, 0x73, 0x81,
  0x5F, 0xD6, 0x81, 0xEF, 0x43, 0x81, 0x8F, 0xA5, 0x01, 0xA0, 0x13,
  // "ĥ" (U+0125)
  0x58, 0x15, 0x74, 0x71, 0x03, 0xA0, 0xC7, 0x84, 0x1E, 0xEC, 0xF2, 0x68, 0x4C, 0xD2, 0x3F, 0x95,
  0x81, 0xBC, 0x12, 0x81, 0x7F, 0x17, 0x77, 0x72, 0x81, 0x8F, 0x97, 0x28, 0x1B, 0xF6, 0x72, 0x81,
  0xEF, 0x37, 0x10, 0x2A, 0x72, 0x81, 0x5F, 0xC7, 0x28, 0x18, 0xF9, 0x72, 0x86, 0xCF, 0x54, 0xCE,
  0xD4, 0x4A, 0x81, 0x7F, 0xEB, 0x02, 0x20, 0x3A, 0x85, 0xE5, 0x01, 0xEF, 0x52, 0x06, 0xA0, 0x63,
  0x81, 0xCF, 0x62, 0x81, 0x9F, 0xD4, 0x81, 0xDF, 0x42, 0x81, 0xCF, 0x74, 0xA0, 0x22, 0xA0, 0x33,
  0x81, 0x3F, 0xE2, 0x81, 0x3F, 0xE4, 0x81, 0x6F, 0xB2, 0x81, 0x6F, 0xB4, 0x81, 0xAF, 0x82, 0x81,
  0xAF, 0x84, 0x81, 0xDF, 0x52, 0x81, 0xDF, 0x53, 0x01, 0xA8, 0x11, 0x01, 0xA0, 0x23, 0x81, 0x4F,
  0xE2, 0x81, 0x4F, 0xE4, 0x81, 0x7F, 0xA2, 0x81, 0x7F, 0xB4, 0x81, 0xAF, 0x72, 0x81, 0xAF, 0x74,
  0x81, 0xDF, 0x42,
  // "Ħ" (U+0126)
  0x48, 0x1A, 0xF8, 0x50, 0x4A, 0x68, 0x1D, 0xF5, 0x58, 0x16, 0xFC, 0x6A, 0x03, 0x58, 0x19, 0xFA,
  0x50, 0x3A, 0x68, 0x1C, 0xF7, 0x30, 0x5F, 0xF8, 0x53, 0x06, 0xCE, 0xFE, 0x80, 0x1C, 0x0D, 0xA0,
  0x0C, 0x48, 0x1C, 0xF6, 0x58, 0x15, 0xFD, 0x6A, 0x03, 0x58, 0x19, 0xFA, 0x50, 0x3A, 0x68, 0x1C,
  0xF6, 0x50, 0x6F, 0xB0, 0x35, 0x81, 0xAF, 0xE8, 0x01, 0xD0, 0xEA, 0x68, 0x1D, 0xF5, 0x58, 0x17,
  0xFC, 0x50, 0x1A, 0x02, 0x58, 0x1A, 0xF9, 0x58, 0x14, 0xFE, 0x68, 0x1D, 0xF5, 0x58, 0x17, 0xFB,
  0x50, 0x1A, 0x02, 0x58, 0x1B, 0xF7, 0x58, 0x14, 0xFE, 0x68, 0x1E, 0xF4, 0x58, 0x17, 0xFB, 0x50,
  0x2A, 0x01, 0x58, 0x1B, 0xF8, 0x58, 0x15, 0xFD, 0x68, 0x1E, 0xF4, 0x58, 0x18, 0xFA, 0x50, 0x2A,
  0x01, 0x50,
  // "ħ" (U+0127)
  0x48, 0x18, 0xF9, 0x72, 0x81, 0xCF, 0x67, 0x08, 0x0A, 0xA8, 0x2C, 0xAA, 0x24, 0x0E, 0xE0, 0x15,
  0x81, 0x6F, 0xB7, 0x28, 0x19, 0xF8, 0x72, 0x86, 0xCF, 0x44, 0xCE, 0xC4, 0x4A, 0x81, 0x7F, 0xEA,
  0x0E, 0x01, 0x28, 0x90, 0x3F, 0xEE, 0x50, 0x1E, 0xF5, 0x20, 0x6A, 0x05, 0x38, 0x1C, 0xF5, 0x28,
  0x19, 0xFC, 0x48, 0x1D, 0xF4, 0x28, 0x1C, 0xF6, 0x4A, 0x01, 0x2A, 0x02, 0x38, 0x13, 0xFE, 0x28,
  0x13, 0xFE, 0x48, 0x17, 0xFB, 0x28, 0x16, 0xFB, 0x48, 0x1A, 0xF8, 0x28, 0x1A, 0xF8, 0x48, 0x1D,
  0xF4, 0x28, 0x1D, 0xF4, 0x30, 0x1A, 0x81, 0x10, 0x1A, 0x01, 0x38, 0x14, 0xFE, 0x28, 0x14, 0xFE,
  0x48, 0x17, 0xFA, 0x28, 0x17, 0xFB, 0x48, 0x1A, 0xF7, 0x28, 0x1A, 0xF7, 0x48, 0x1D, 0xF4, 0x20,
  // "Ĩ" (U+0128)
  0x58, 0x25, 0xCB, 0x12, 0x0C, 0x07, 0x40, 0x2B, 0x83, 0xD3, 0x4F, 0x44, 0x82, 0x9D, 0x16, 0xB0,
  0xD5, 0x0D, 0x08, 0x28, 0x25, 0xED, 0x37, 0x77, 0x72, 0x02, 0xE0, 0x35, 0x81, 0x18, 0xDA, 0x09,
  0x06, 0x71, 0x81, 0x7F, 0xB7, 0x38, 0x1A, 0xF8, 0x73, 0x81, 0xDF, 0x57, 0x20, 0x1A, 0x02, 0x72,
  0x81, 0x4F, 0xE7, 0x38, 0x17, 0xFB, 0x73, 0x81, 0xAF, 0x87, 0x38, 0x1D, 0xF5, 0x72, 0x01, 0xA0,
  0x27, 0x28, 0x14, 0xFE, 0x73, 0x81, 0x7F, 0xB7, 0x38, 0x1B, 0xF8, 0x73, 0x81, 0xEF, 0x57, 0x20,
  0x1A, 0x01, 0x72, 0x81, 0x5F, 0xE7, 0x38, 0x18, 0xFB, 0x71, 0x85, 0x59, 0xEF, 0xD8, 0x26, 0xE0,
  0x56,
  // "ĩ" (U+0129)
  0x28, 0x25, 0xCB, 0x12, 0x82, 0xC7, 0x02, 0xB8, 0x90, 0xD3, 0x4F, 0x40, 0x9D, 0x16, 0xB0, 0xD2,
  0x0D, 0x08, 0x28, 0x25, 0xED, 0x37, 0x77, 0x38, 0x1C, 0xF5, 0x7A, 0x02, 0x68, 0x13, 0xFE, 0x78,
  0x16, 0xFB, 0x78, 0x19, 0xF8, 0x78, 0x1C, 0xF5, 0x7A, 0x01, 0x68, 0x13, 0xFE, 0x78, 0x17, 0xFB,
  0x78, 0x1A, 0xF7, 0x78, 0x1D, 0xF4, 0x60, 0x1A, 0x01, 0x68, 0x14, 0xFD, 0x78, 0x17, 0xFA, 0x78,
  0x1A, 0xF7, 0x70,
  // "Ī" (U+012A)
  0x40, 0x98, 0x02, 0xD4, 0x0D, 0xD0, 0xD7, 0x77, 0x40, 0x2E, 0x03, 0x38, 0x11, 0x8D, 0xA0, 0x90,
  0x66, 0x81, 0x7F, 0xB7, 0x18, 0x1A, 0xF8, 0x71, 0x81, 0xDF, 0x57, 0x01, 0xA0, 0x27, 0x81, 0x4F,
  0xE7, 0x18, 0x17, 0xFB, 0x71, 0x81, 0xAF, 0x87, 0x18, 0x1D, 0xF5, 0x70, 0x1A, 0x02, 0x78, 0x14,
  0xFE, 0x71, 0x81, 0x7F, 0xB7, 0x18, 0x1B, 0xF8, 0x71, 0x81, 0xEF, 0x57, 0x01, 0xA0, 0x17, 0x81,
  0x5F, 0xE7, 0x18, 0x18, 0xFB, 0x68, 0x55, 0x9E, 0xFD, 0x82, 0x4E, 0x05, 0x40,
  // "ī" (U+012B)
  0x10, 0x98, 0x02, 0xD1, 0x0D, 0xD0, 0xD7, 0x75, 0x81, 0xCF, 0x55, 0xA0, 0x24, 0x81, 0x3F, 0xE5,
  0x81, 0x6F, 0xB5, 0x81, 0x9F, 0x85, 0x81, 0xCF, 0x55, 0xA0, 0x14, 0x81, 0x3F, 0xE5, 0x81, 0x7F,
  0xB5, 0x81, 0xAF, 0x75, 0x81, 0xDF, 0x44, 0x01, 0xA0, 0x14, 0x81, 0x4F, 0xD5, 0x81, 0x7F, 0xA5,
  0x81, 0xAF, 0x75,
  // "Ĭ" (U+012C)
  0x48, 0x11, 0x71, 0x28, 0x11, 0x72, 0x48, 0x13, 0xF7, 0x28, 0x19, 0xF1, 0x48, 0x21, 0xEF, 0xEA,
  0x08, 0x68, 0x34, 0xCE, 0xD7, 0x77, 0x77, 0x10, 0x2E, 0x03, 0x48, 0x11, 0x8D, 0xA0, 0x90, 0x67,
  0x81, 0x7F, 0xB7, 0x28, 0x1A, 0xF8, 0x72, 0x81, 0xDF, 0x57, 0x10, 0x1A, 0x02, 0x71, 0x81, 0x4F,
  0xE7, 0x28, 0x17, 0xFB, 0x72, 0x81, 0xAF, 0x87, 0x28, 0x1D, 0xF5, 0x71, 0x01, 0xA0, 0x27, 0x18,
  0x14, 0xFE, 0x72, 0x81, 0x7F, 0xB7, 0x28, 0x1B, 0xF8, 0x72, 0x81, 0xEF, 0x57, 0x10, 0x1A, 0x01,
  0x71, 0x81, 0x5F, 0xE7, 0x28, 0x18, 0xFB, 0x78, 0x55, 0x9E, 0xFD, 0x82, 0x5E, 0x05, 0x50,
  // "ĭ" (U+012D)
  0x18, 0x11, 0x71, 0x28, 0x51, 0x72, 0x03, 0xF7, 0x28, 0x69, 0xF1, 0x01, 0xEF, 0xEA, 0x08, 0x38,
  0x34, 0xCE, 0xD7, 0x77, 0x72, 0x81, 0xCF, 0x56, 0xA0, 0x25, 0x81, 0x3F, 0xE6, 0x81, 0x6F, 0xB6,
  0x81, 0x9F, 0x86, 0x81, 0xCF, 0x56, 0xA0, 0x15, 0x81, 0x3F, 0xE6, 0x81, 0x7F, 0xB6, 0x81, 0xAF,
  0x76, 0x81, 0xDF, 0x45, 0x01, 0xA0, 0x15, 0x81, 0x4F, 0xD6, 0x81, 0x7F, 0xA6, 0x81, 0xAF, 0x76,
  // "Į" (U+012E)
  0x30, 0x2E, 0x03, 0x38, 0x11, 0x8D, 0xA0, 0x90, 0x66, 0x81, 0x7F, 0xB7, 0x18, 0x1A, 0xF8, 0x71,
  0x81, 0xDF, 0x57, 0x01, 0xA0, 0x27, 0x81, 0x4F, 0xE7, 0x18, 0x17, 0xFB, 0x71, 0x81, 0xAF, 0x87,
  0x18, 0x1D, 0xF5, 0x70, 0x1A, 0x02, 0x78, 0x14, 0xFE, 0x71, 0x81, 0x7F, 0xB7, 0x18, 0x1B, 0xF8,
  0x71, 0x81, 0xEF, 0x57, 0x01, 0xA0, 0x17, 0x81, 0x5F, 0xE7, 0x18, 0x18, 0xFB, 0x68, 0x55, 0x9E,
  0xFD, 0x82, 0x4E, 0x05, 0x68, 0x13, 0xD6, 0x78, 0x13, 0xE7, 0x71, 0x00, 0xD7, 0x18, 0x12, 0xFC,
  0x71, 0x02, 0xA0, 0xE0, 0x77, 0x82, 0x8E, 0xE4, 0x60,
  // "į" (U+012F)
  0x78, 0x18, 0xE5, 0x7A, 0x07, 0x78, 0x1D, 0xD1, 0x80, 0xC0, 0x08, 0x1C, 0xF5, 0x7A, 0x02, 0x68,
  0x13, 0xFE, 0x78, 0x16, 0xFB, 0x78, 0x19, 0xF8, 0x78, 0x1C, 0xF5, 0x7A, 0x01, 0x68, 0x13, 0xFE,
  0x78, 0x17, 0xFB, 0x78, 0x1A, 0xF7, 0x78, 0x1D, 0xF4, 0x60, 0x1A, 0x01, 0x68, 0x14, 0xFD, 0x78,
  0x17, 0xFA, 0x78, 0x1A, 0xF7, 0x68, 0x13, 0xD6, 0x68, 0x13, 0xE7, 0x70, 0x0D, 0x78, 0x12, 0xFC,
  0x70, 0x2A, 0x0E, 0x07, 0x68, 0x28, 0xEE, 0x45,
  // "İ" (U+0130)
  0x68, 0x12, 0xDC, 0x71, 0x08, 0xA7, 0x18, 0x15, 0xE8, 0x77, 0x76, 0x02, 0xE0, 0x33, 0x81, 0x18,
  0xDA, 0x09, 0x06, 0x68, 0x17, 0xFB, 0x71, 0x81, 0xAF, 0x87, 0x18, 0x1D, 0xF5, 0x70, 0x1A, 0x02,
  0x78, 0x14, 0xFE, 0x71, 0x81, 0x7F, 0xB7, 0x18, 0x1A, 0xF8, 0x71, 0x81, 0xDF, 0x57, 0x01, 0xA0,
  0x27, 0x81, 0x4F, 0xE7, 0x18, 0x17, 0xFB, 0x71, 0x81, 0xBF, 0x87, 0x18, 0x1E, 0xF5, 0x70, 0x1A,
  0x01, 0x78, 0x15, 0xFE, 0x71, 0x81, 0x8F, 0xB6, 0x85, 0x59, 0xEF, 0xD8, 0x24, 0xE0, 0x54,
  // "ı" (U+0131)
  0x38, 0x1C, 0xF5, 0x3A, 0x02, 0x28, 0x13, 0xFE, 0x38, 0x16, 0xFB, 0x38, 0x19, 0xF8, 0x38, 0x1C,
  0xF5, 0x3A, 0x01, 0x28, 0x13, 0xFE, 0x38, 0x17, 0xFB, 0x38, 0x1A, 0xF7, 0x38, 0x1D, 0xF4, 0x20,
  0x1A, 0x01, 0x28, 0x14, 0xFD, 0x38, 0x17, 0xFA, 0x38, 0x1A, 0xF7, 0x30,
  // "Ĳ" (U+0132)
  0x30, 0x2E, 0x03, 0x28, 0x1A, 0xF8, 0x38, 0x11, 0x8D, 0xA0, 0x90, 0x63, 0x81, 0xDF, 0x55, 0x81,
  0x7F, 0xB4, 0x01, 0xA0, 0x25, 0x81, 0xAF, 0x84, 0x81, 0x4F, 0xE6, 0x81, 0xDF, 0x54, 0x81, 0x7F,
  0xB5, 0x01, 0xA0, 0x24, 0x81, 0xBF, 0x85, 0x81, 0x4F, 0xE5, 0x81, 0xEF, 0x45, 0x81, 0x7F, 0xB4,
  0x01, 0xA0, 0x15, 0x81, 0xAF, 0x84, 0x81, 0x5F, 0xE6, 0x81, 0xDF, 0x54, 0x81, 0x8F, 0xA5, 0x01,
  0xA0, 0x24, 0x81, 0xBF, 0x75, 0x81, 0x4F, 0xE5, 0x81, 0xEF, 0x45, 0x81, 0x7F, 0xB4, 0x02, 0xA0,
  0x15, 0x81, 0xBF, 0x84, 0x81, 0x5F, 0xD6, 0x81, 0xEF, 0x54, 0x81, 0x8F, 0xA5, 0x01, 0xA0, 0x14,
  0x81, 0xBF, 0x65, 0x81, 0x5F, 0xE5, 0x81, 0xEF, 0x35, 0x81, 0x8F, 0xB4, 0x02, 0xA4, 0x85, 0x59,
  0xEF, 0xD8, 0x22, 0x81, 0x5F, 0xC4, 0xE0, 0x52, 0x81, 0x9F, 0x97, 0x68, 0x1D, 0xF5, 0x75, 0x03,
  0xA0, 0x17, 0x28, 0x42, 0x02, 0xDF, 0xA7, 0x30, 0xCB, 0x0D, 0x01, 0x73, 0x83, 0xBD, 0xC8, 0x16,
  // "ĳ" (U+0133)
  0x48, 0x18, 0xE5, 0x38, 0x18, 0xE5, 0x4A, 0x07, 0x3A, 0x07, 0x48, 0x1D, 0xD1, 0x38, 0x1D, 0xD1,
  0x80, 0xC6, 0x08, 0x1C, 0xF5, 0x38, 0x1C, 0xF5, 0x4A, 0x02, 0x3A, 0x02, 0x38, 0x13, 0xFE, 0x38,
  0x13, 0xFE, 0x48, 0x16, 0xFB, 0x38, 0x16, 0xFB, 0x48, 0x19, 0xF8, 0x38, 0x1A, 0xF7, 0x48, 0x1C,
  0xF5, 0x38, 0x1D, 0xF4, 0x4A, 0x01, 0x20, 0x1A, 0x01, 0x38, 0x13, 0xFE, 0x38, 0x14, 0xFD, 0x48,
  0x17, 0xFB, 0x38, 0x17, 0xFA, 0x48, 0x1A, 0xF7, 0x38, 0x1A, 0xF6, 0x48, 0x1D, 0xF4, 0x38, 0x1E,
  0xF3, 0x30, 0x1A, 0x01, 0x20, 0x1A, 0x48, 0x14, 0xFD, 0x38, 0x15, 0xFC, 0x48, 0x17, 0xFA, 0x38,
  0x18, 0xF9, 0x48, 0x1A, 0xF7, 0x38, 0x1B, 0xF5, 0x73, 0x81, 0xEF, 0x27, 0x28, 0x12, 0xFE, 0x73,
  0x81, 0x7F, 0xA7, 0x28, 0x21, 0xEF, 0x57, 0x07, 0x0E, 0xA0, 0xC7, 0x18, 0x35, 0xEE, 0xA1, 0x60,
  // "Ĵ" (U+0134)
  0x72, 0x81, 0x57, 0x47, 0x30, 0x3A, 0x0C, 0x72, 0x84, 0x1E, 0xEC, 0xF2, 0x71, 0x84, 0xCD, 0x23,
  0xF9, 0x78, 0x1B, 0xC1, 0x28, 0x17, 0xF1, 0x80, 0xC0, 0x08, 0x1A, 0xF8, 0x74, 0x81, 0xDF, 0x57,
  0x30, 0x1A, 0x02, 0x73, 0x81, 0x4F, 0xE7, 0x48, 0x17, 0xFB, 0x74, 0x81, 0xBF, 0x87, 0x48, 0x1E,
  0xF4, 0x73, 0x01, 0xA0, 0x17, 0x38, 0x15, 0xFE, 0x74, 0x81, 0x8F, 0xA7, 0x48, 0x1B, 0xF7, 0x74,
  0x81, 0xEF, 0x47, 0x30, 0x2A, 0x01, 0x73, 0x81, 0x5F, 0xD7, 0x48, 0x18, 0xFA, 0x74, 0x81, 0xBF,
  0x67, 0x48, 0x1E, 0xF3, 0x73, 0x02, 0xA7, 0x48, 0x15, 0xFC, 0x74, 0x81, 0x9F, 0x97, 0x48, 0x1D,
  0xF5, 0x73, 0x03, 0xA0, 0x17, 0x84, 0x20, 0x2D, 0xFA, 0x71, 0x0C, 0xB0, 0xD0, 0x17, 0x18, 0x3B,
  0xDC, 0x81, 0x72,
  // "ĵ" (U+0135)
  0x71, 0x81, 0x57, 0x47, 0x20, 0x3A, 0x0C, 0x71, 0x84, 0x1E, 0xEC, 0xF2, 0x78, 0x4C, 0xD2, 0x3F,
  0x96, 0x81, 0xBC, 0x12, 0x81, 0x7F, 0x17, 0x77, 0x75, 0x81, 0xCF, 0x57, 0x3A, 0x02, 0x72, 0x81,
  0x3F, 0xE7, 0x38, 0x16, 0xFB, 0x73, 0x81, 0xAF, 0x77, 0x38, 0x1D, 0xF4, 0x72, 0x01, 0xA0, 0x17,
  0x28, 0x14, 0xFD, 0x73, 0x81, 0x7F, 0xA7, 0x38, 0x1A, 0xF6, 0x73, 0x81, 0xEF, 0x37, 0x20, 0x1A,
  0x73, 0x81, 0x5F, 0xC7, 0x38, 0x18, 0xF9, 0x73, 0x81, 0xBF, 0x57, 0x38, 0x1E, 0xF2, 0x72, 0x81,
  0x2F, 0xE7, 0x38, 0x17, 0xFA, 0x72, 0x82, 0x1E, 0xF5, 0x70, 0x70, 0xEA, 0x0C, 0x71, 0x83, 0x5E,
  0xEA, 0x17, 0x10,
  // "Ķ" (U+0136)
  0x48, 0x1A, 0xF8, 0x48, 0x26, 0xFE, 0x24, 0x81, 0xDF, 0x53, 0x03, 0xA0, 0x54, 0x01, 0xA0, 0x12,
  0x82, 0x1D, 0xF9, 0x58, 0x14, 0xFE, 0x38, 0x1A, 0xFC, 0x68, 0x17, 0xFB, 0x28, 0x27, 0xFE, 0x26,
  0x83, 0xBF, 0x70, 0x3A, 0x05, 0x78, 0x5E, 0xF4, 0x1D, 0xF9, 0x70, 0x1A, 0x82, 0x1B, 0xFC, 0x71,
  0x85, 0x5F, 0xD6, 0xFE, 0x27, 0x18, 0x48, 0xFD, 0xEF, 0xC7, 0x20, 0xBA, 0x0E, 0xA0, 0x17, 0x18,
  0x5E, 0xFD, 0x2E, 0xF5, 0x70, 0x2A, 0x83, 0x20, 0xBF, 0x97, 0x81, 0x5F, 0xD2, 0x81, 0x7F, 0xD7,
  0x81, 0x8F, 0xA2, 0x03, 0xA0, 0x26, 0x81, 0xBF, 0x73, 0x81, 0xEF, 0x66, 0x81, 0xEF, 0x43, 0x81,
  0xAF, 0xA5, 0x02, 0xA0, 0x13, 0x81, 0x7F, 0xE5, 0x81, 0x5F, 0xD4, 0x03, 0xA0, 0x34, 0x81, 0x8F,
  0xA5, 0x81, 0xEF, 0x77, 0x77, 0x18, 0x11, 0x77, 0x75, 0x81, 0x7F, 0xB7, 0x58, 0x1D, 0xF2, 0x74,
  0x81, 0x6F, 0x67, 0x50, 0xD0, 0xA7, 0x40,
  // "ķ" (U+0137)
  0x48, 0x17, 0xF9, 0x72, 0x81, 0xBF, 0x67, 0x28, 0x1E, 0xF3, 0x71, 0x02, 0xA7, 0x28, 0x15, 0xFC,
  0x72, 0x81, 0x8F, 0x97, 0x28, 0x1B, 0xF6, 0x38, 0x1D, 0xF7, 0x38, 0x1E, 0xF2, 0x28, 0x1A, 0xFB,
  0x38, 0x12, 0xFE, 0x28, 0x27, 0xFD, 0x13, 0x86, 0x6F, 0xB0, 0x4F, 0xE2, 0x48, 0x59, 0xF8, 0x1E,
  0xF5, 0x58, 0x4C, 0xF4, 0xCF, 0x86, 0xA0, 0xAA, 0x01, 0x50, 0x3D, 0x05, 0x50, 0x6A, 0x82, 0x9A,
  0xF9, 0x58, 0x59, 0xFA, 0x06, 0xFC, 0x58, 0x3D, 0xF4, 0x02, 0xA0, 0x14, 0xA0, 0x12, 0x81, 0xEF,
  0x53, 0x81, 0x4F, 0xD3, 0x81, 0xAF, 0x93, 0x81, 0x7F, 0xA3, 0x81, 0x7F, 0xD3, 0x81, 0xAF, 0x73,
  0x03, 0xA0, 0x17, 0x72, 0x81, 0x17, 0x77, 0x28, 0x17, 0xFB, 0x72, 0x81, 0xDF, 0x27, 0x18, 0x16,
  0xF6, 0x72, 0x0D, 0x0A, 0x72,
  // "ĸ" (U+0138)
  0x38, 0x1C, 0xF5, 0x38, 0x1D, 0xF7, 0x3A, 0x02, 0x28, 0x1A, 0xFB, 0x38, 0x13, 0xFE, 0x28, 0x27,
  0xFD, 0x13, 0x86, 0x6F, 0xB0, 0x4F, 0xE2, 0x48, 0x59, 0xF7, 0x1E, 0xF5, 0x58, 0x4C, 0xF4, 0xCF,
  0x86, 0xA0, 0xAA, 0x01, 0x50, 0x3D, 0x05, 0x50, 0x7A, 0x82, 0x9A, 0xF9, 0x58, 0x5A, 0xFA, 0x06,
  0xFC, 0x58, 0x3D, 0xF4, 0x02, 0xA0, 0x13, 0x01, 0xA0, 0x12, 0x81, 0xEF, 0x53, 0x81, 0x4F, 0xD3,
  0x81, 0xAF, 0x93, 0x81, 0x7F, 0xA3, 0x81, 0x7F, 0xD3, 0x81, 0xAF, 0x73, 0x03, 0xA0, 0x12,
  // "Ĺ" (U+0139)
  0x72, 0x81, 0x77, 0x47, 0x18, 0x28, 0xFD, 0x17, 0x82, 0x4F, 0xE2, 0x78, 0x21, 0xEE, 0x27, 0x18,
  0x1B, 0xD2, 0x77, 0x77, 0x38, 0x1A, 0xF8, 0x72, 0x81, 0xDF, 0x57, 0x10, 0x1A, 0x02, 0x71, 0x81,
  0x4F, 0xE7, 0x28, 0x17, 0xFB, 0x72, 0x81, 0xBF, 0x87, 0x28, 0x1E, 0xF4, 0x71, 0x01, 0xA0, 0x17,
  0x18, 0x15, 0xFE, 0x72, 0x81, 0x8F, 0xA7, 0x28, 0x1B, 0xF7, 0x72, 0x81, 0xEF, 0x47, 0x10, 0x2A,
  0x01, 0x71, 0x81, 0x5F, 0xD7, 0x28, 0x18, 0xFA, 0x72, 0x81, 0xBF, 0x77, 0x28, 0x1E, 0xF4, 0x71,
  0x02, 0xA0, 0x17, 0x10, 0x5F, 0x06, 0x30, 0x8F, 0x03, 0x30,
  // "ĺ" (U+013A)
  0x78, 0x17, 0x74, 0x68, 0x28, 0xFD, 0x15, 0x82, 0x4F, 0xE2, 0x58, 0x21, 0xEE, 0x26, 0x81, 0xBD,
  0x27, 0x77, 0x68, 0x17, 0xF9, 0x78, 0x1B, 0xF6, 0x78, 0x1E, 0xF3, 0x60, 0x2A, 0x78, 0x15, 0xFC,
  0x78, 0x18, 0xF9, 0x78, 0x1B, 0xF6, 0x78, 0x1E, 0xF2, 0x68, 0x12, 0xFE, 0x78, 0x16, 0xFB, 0x78,
  0x19, 0xF8, 0x78, 0x1C, 0xF5, 0x7A, 0x02, 0x68, 0x13, 0xFE, 0x78, 0x16, 0xFB, 0x78, 0x19, 0xF8,
  0x78, 0x1D, 0xF4, 0x7A, 0x01, 0x68, 0x14, 0xFD, 0x78, 0x17, 0xFA, 0x78, 0x1A, 0xF7, 0x70,
  // "Ļ" (U+013B)
  0x48, 0x1A, 0xF8, 0x68, 0x1D, 0xF5, 0x50, 0x1A, 0x02, 0x58, 0x14, 0xFE, 0x68, 0x17, 0xFB, 0x68,
  0x1B, 0xF8, 0x68, 0x1E, 0xF4, 0x50, 0x1A, 0x01, 0x58, 0x15, 0xFE, 0x68, 0x18, 0xFA, 0x68, 0x1B,
  0xF7, 0x68, 0x1E, 0xF4, 0x50, 0x2A, 0x01, 0x58, 0x15, 0xFD, 0x68, 0x18, 0xFA, 0x68, 0x1B, 0xF7,
  0x68, 0x1E, 0xF4, 0x50, 0x2A, 0x01, 0x50, 0x5F, 0x06, 0x08, 0xF0, 0x37, 0x48, 0x11, 0x77, 0x68,
  0x17, 0xFB, 0x68, 0x1D, 0xF2, 0x58, 0x16, 0xF6, 0x60, 0xD0, 0xA6,
  // "ļ" (U+013C)
  0x58, 0x17, 0xF9, 0x58, 0x1B, 0xF6, 0x58, 0x1E, 0xF3, 0x40, 0x2A, 0x58, 0x15, 0xFC, 0x58, 0x18,
  0xF9, 0x58, 0x1B, 0xF6, 0x58, 0x1E, 0xF2, 0x48, 0x12, 0xFE, 0x58, 0x16, 0xFB, 0x58, 0x19, 0xF8,
  0x58, 0x1C, 0xF5, 0x5A, 0x02, 0x48, 0x13, 0xFE, 0x58, 0x16, 0xFB, 0x58, 0x19, 0xF8, 0x58, 0x1D,
  0xF4, 0x5A, 0x01, 0x48, 0x14, 0xFD, 0x58, 0x17, 0xFA, 0x58, 0x1A, 0xF7, 0x76, 0x81, 0x17, 0x75,
  0x81, 0x7F, 0xB5, 0x81, 0xDF, 0x24, 0x81, 0x6F, 0x65, 0x0D, 0x0A, 0x60,
  // "Ľ" (U+013D)
  0x48, 0x1A, 0xF8, 0x28, 0x1C, 0xF6, 0x48, 0x5D, 0xF5, 0x01, 0xFE, 0x40, 0x1A, 0x83, 0x20, 0x7F,
  0x54, 0x81, 0x4F, 0xE2, 0x0D, 0x0B, 0x58, 0x57, 0xFB, 0x01, 0x71, 0x58, 0x1B, 0xF8, 0x72, 0x81,
  0xEF, 0x47, 0x10, 0x1A, 0x01, 0x71, 0x81, 0x5F, 0xE7, 0x28, 0x18, 0xFA, 0x72, 0x81, 0xBF, 0x77,
  0x28, 0x1E, 0xF4, 0x71, 0x02, 0xA0, 0x17, 0x18, 0x15, 0xFD, 0x72, 0x81, 0x8F, 0xA7, 0x28, 0x1B,
  0xF7, 0x72, 0x81, 0xEF, 0x47, 0x10, 0x2A, 0x01, 0x71, 0x05, 0xF0, 0x63, 0x08, 0xF0, 0x33,
  // "ľ" (U+013E)
  0x48, 0x57, 0xF9, 0x0C, 0xF6, 0x48, 0x4B, 0xF6, 0x1F, 0xE5, 0x84, 0xEF, 0x37, 0xF5, 0x40, 0x2A,
  0x10, 0xD0, 0xB5, 0x84, 0x5F, 0xC1, 0x71, 0x58, 0x18, 0xF9, 0x71, 0x81, 0xBF, 0x67, 0x18, 0x1E,
  0xF2, 0x78, 0x12, 0xFE, 0x71, 0x81, 0x6F, 0xB7, 0x18, 0x19, 0xF8, 0x71, 0x81, 0xCF, 0x57, 0x1A,
  0x02, 0x78, 0x13, 0xFE, 0x71, 0x81, 0x6F, 0xB7, 0x18, 0x19, 0xF8, 0x71, 0x81, 0xDF, 0x47, 0x1A,
  0x01, 0x78, 0x14, 0xFD, 0x71, 0x81, 0x7F, 0xA7, 0x18, 0x1A, 0xF7, 0x71,
  // "Ŀ" (U+013F)
  0x48, 0x1A, 0xF8, 0x78, 0x1D, 0xF5, 0x60, 0x1A, 0x02, 0x68, 0x14, 0xFE, 0x78, 0x17, 0xFB, 0x78,
  0x1B, 0xF8, 0x78, 0x1E, 0xF4, 0x60, 0x1A, 0x01, 0x68, 0x15, 0xFE, 0x78, 0x18, 0xFA, 0x28, 0x12,
  0xDC, 0x28, 0x1B, 0xF7, 0x20, 0x8A, 0x28, 0x1E, 0xF4, 0x28, 0x35, 0xE8, 0x02, 0xA0, 0x16, 0x81,
  0x5F, 0xD7, 0x81, 0x8F, 0xA7, 0x81, 0xBF, 0x77, 0x81, 0xEF, 0x46, 0x02, 0xA0, 0x16, 0x05, 0xF8,
  0x16, 0x08, 0xF0, 0x31,
  // "ŀ" (U+0140)
  0x48, 0x17, 0xF9, 0x58, 0x1B, 0xF6, 0x58, 0x1E, 0xF3, 0x40, 0x2A, 0x58, 0x15, 0xFC, 0x58, 0x18,
  0xF9, 0x58, 0x1B, 0xF6, 0x58, 0x1E, 0xF2, 0x48, 0x12, 0xFE, 0x58, 0x16, 0xFB, 0x58, 0x49, 0xF8,
  0x2D, 0xC2, 0x82, 0xCF, 0x58, 0xA2, 0xA8, 0x62, 0x5E, 0x80, 0x3F, 0xE5, 0x81, 0x6F, 0xB5, 0x81,
  0x9F, 0x85, 0x81, 0xDF, 0x45, 0xA0, 0x14, 0x81, 0x4F, 0xD5, 0x81, 0x7F, 0xA5, 0x81, 0xAF, 0x75,
  // "Ł" (U+0141)
  0x58, 0x18, 0xFA, 0x78, 0x1C, 0xF7, 0x78, 0x1E, 0xF4, 0x60, 0x2A, 0x01, 0x68, 0x15, 0xFD, 0x78,
  0x19, 0xFA, 0x78, 0x1C, 0xF7, 0x7A, 0x81, 0x33, 0xB4, 0x02, 0xA0, 0xAA, 0x04, 0x30, 0x6B, 0x0C,
  0x02, 0x38, 0x31, 0xBF, 0xE6, 0x40, 0x60, 0xEA, 0x06, 0x48, 0x12, 0xFE, 0xA0, 0x35, 0x05, 0x04,
  0xA7, 0x81, 0x6F, 0xC7, 0x81, 0x9F, 0x97, 0x81, 0xCF, 0x67, 0xA0, 0x36, 0x03, 0xF8, 0x18, 0x06,
  0xF0, 0x50,
  // "ł" (U+0142)
  0x48, 0x16, 0xFC, 0x58, 0x19, 0xF9, 0x58, 0x1C, 0xF5, 0x5A, 0x02, 0x48, 0x13, 0xFE, 0x58, 0x16,
  0xFB, 0x58, 0x19, 0xF8, 0x58, 0x1D, 0xF5, 0x5A, 0x81, 0x5B, 0x12, 0x04, 0xC8, 0x24, 0x01, 0xAA,
  0x83, 0xA1, 0x06, 0xEA, 0x08, 0x38, 0x3C, 0xDE, 0xF4, 0x30, 0x20, 0x1A, 0x01, 0x48, 0x14, 0xFD,
  0x58, 0x17, 0xFA, 0x58, 0x1A, 0xF7, 0x58, 0x1D, 0xF3, 0x40, 0x1A, 0x58, 0x14, 0xFC, 0x58, 0x18,
  0xF9, 0x50,
  // "Ń" (U+0143)
  0x75, 0x81, 0x77, 0x47, 0x58, 0x28, 0xFD, 0x17, 0x48, 0x24, 0xFE, 0x27, 0x48, 0x21, 0xEE, 0x27,
  0x58, 0x1B, 0xD2, 0x80, 0xC4, 0x00, 0xAA, 0x01, 0x58, 0x15, 0xFC, 0x40, 0xDA, 0x04, 0x58, 0x18,
  0xF9, 0x30, 0x1B, 0x08, 0x58, 0x1B, 0xF6, 0x30, 0x4B, 0x0B, 0x58, 0x1E, 0xF2, 0x38, 0x37, 0xF9,
  0xFE, 0x48, 0x12, 0xFE, 0x48, 0x4B, 0xF5, 0xEF, 0x23, 0x81, 0x5F, 0xC4, 0x84, 0xEF, 0x2A, 0xF6,
  0x38, 0x19, 0xF8, 0x30, 0x1A, 0x18, 0x17, 0xF9, 0x38, 0x1C, 0xF5, 0x38, 0x55, 0xFC, 0x03, 0xFC,
  0x3A, 0x02, 0x38, 0x18, 0xF9, 0x2A, 0x28, 0x13, 0xFE, 0x48, 0x1B, 0xF6, 0x28, 0x5C, 0xF4, 0x06,
  0xFB, 0x48, 0x1E, 0xF3, 0x28, 0x59, 0xF7, 0x09, 0xF8, 0x30, 0x2A, 0x38, 0x55, 0xFA, 0x0C, 0xF5,
  0x38, 0x15, 0xFC, 0x38, 0x52, 0xFE, 0x0E, 0xF2, 0x38, 0x18, 0xF9, 0x48, 0x3E, 0xF4, 0xFE, 0x48,
  0x1B, 0xF5, 0x48, 0x3B, 0xFA, 0xFB, 0x48, 0x1E, 0xF2, 0x40, 0x7B, 0x07, 0x38, 0x12, 0xFE, 0x50,
  0x4B, 0x04, 0x38, 0x15, 0xFB, 0x6B, 0x01, 0x38, 0x18, 0xF8, 0x68, 0x1C, 0xFD, 0x40,
  // "ń" (U+0144)
  0x73, 0x81, 0x77, 0x47, 0x28, 0x28, 0xFD, 0x17, 0x18, 0x24, 0xFE, 0x27, 0x18, 0x21, 0xEE, 0x27,
  0x28, 0x1B, 0xD2, 0x77, 0x77, 0x48, 0x6D, 0xF0, 0x4C, 0xED, 0x55, 0x98, 0x2E, 0x6F, 0xEB, 0x02,
  0x38, 0x90, 0x3F, 0xEE, 0x50, 0x1E, 0xF6, 0x30, 0x7A, 0x06, 0x38, 0x1C, 0xF7, 0x38, 0x1A, 0xFD,
  0x48, 0x1D, 0xF5, 0x38, 0x1D, 0xF7, 0x30, 0x1A, 0x02, 0x20, 0x1A, 0x03, 0x30, 0x4A, 0x38, 0x14,
  0xFE, 0x48, 0x17, 0xFC, 0x38, 0x17, 0xFB, 0x48, 0x1A, 0xF8, 0x38, 0x1A, 0xF8, 0x48, 0x1D, 0xF5,
  0x38, 0x1E, 0xF5, 0x30, 0x1A, 0x02, 0x20, 0x1A, 0x02, 0x38, 0x14, 0xFE, 0x38, 0x15, 0xFE, 0x48,
  0x17, 0xFB, 0x38, 0x18, 0xFB, 0x48, 0x1B, 0xF7, 0x38, 0x1B, 0xF7, 0x48, 0x1E, 0xF4, 0x30,
  // "Ņ" (U+0145)
  0x40, 0xAA, 0x01, 0x58, 0x15, 0xFC, 0x40, 0xDA, 0x04, 0x58, 0x18, 0xF9, 0x30, 0x1B, 0x08, 0x58,
  0x1B, 0xF6, 0x30, 0x4B, 0x0B, 0x58, 0x1E, 0xF2, 0x38, 0x37, 0xF9, 0xFE, 0x48, 0x12, 0xFE, 0x48,
  0x4B, 0xF5, 0xEF, 0x23, 0x81, 0x5F, 0xC4, 0x84, 0xEF, 0x2A, 0xF6, 0x38, 0x19, 0xF8, 0x30, 0x1A,
  0x18, 0x17, 0xF9, 0x38, 0x1C, 0xF5, 0x38, 0x55, 0xFC, 0x03, 0xFC, 0x3A, 0x02, 0x38, 0x18, 0xF9,
  0x2A, 0x28, 0x13, 0xFE, 0x48, 0x1B, 0xF6, 0x28, 0x5C, 0xF4, 0x06, 0xFB, 0x48, 0x1E, 0xF3, 0x28,
  0x59, 0xF7, 0x09, 0xF8, 0x30, 0x2A, 0x38, 0x55, 0xFA, 0x0C, 0xF5, 0x38, 0x15, 0xFC, 0x38, 0x52,
  0xFE, 0x0E, 0xF2, 0x38, 0x18, 0xF9, 0x48, 0x3E, 0xF4, 0xFE, 0x48, 0x1B, 0xF5, 0x48, 0x3B, 0xFA,
  0xFB, 0x48, 0x1E, 0xF2, 0x40, 0x7B, 0x07, 0x38, 0x12, 0xFE, 0x50, 0x4B, 0x04, 0x38, 0x15, 0xFB,
  0x6B, 0x01, 0x38, 0x18, 0xF8, 0x68, 0x1C, 0xFD, 0x77, 0x73, 0x81, 0x17, 0x77, 0x68, 0x17, 0xFB,
  0x76, 0x81, 0xDF, 0x27, 0x58, 0x16, 0xF6, 0x76, 0x0D, 0x0A, 0x74,
  // "ņ" (U+0146)
  0x38, 0x6D, 0xF0, 0x4C, 0xED, 0x54, 0x98, 0x2E, 0x6F, 0xEB, 0x02, 0x28, 0x90, 0x3F, 0xEE, 0x50,
  0x1E, 0xF6, 0x20, 0x7A, 0x06, 0x38, 0x1C, 0xF7, 0x28, 0x1A, 0xFD, 0x48, 0x1D, 0xF5, 0x28, 0x1D,
  0xF7, 0x30, 0x1A, 0x81, 0x20, 0x1A, 0x03, 0x30, 0x4A, 0x28, 0x14, 0xFE, 0x48, 0x17, 0xFC, 0x28,
  0x17, 0xFB, 0x48, 0x1A, 0xF8, 0x28, 0x1A, 0xF8, 0x48, 0x1D, 0xF5, 0x28, 0x1E, 0xF5, 0x30, 0x1A,
  0x81, 0x20, 0x1A, 0x02, 0x38, 0x14, 0xFE, 0x28, 0x15, 0xFE, 0x48, 0x17, 0xFB, 0x28, 0x18, 0xFB,
  0x48, 0x1B, 0xF7, 0x28, 0x1B, 0xF7, 0x48, 0x1E, 0xF4, 0x77, 0x38, 0x11, 0x77, 0x72, 0x81, 0x7F,
  0xB7, 0x28, 0x1D, 0xF2, 0x71, 0x81, 0x6F, 0x67, 0x20, 0xD0, 0xA7, 0x10,
  // "Ň" (U+0147)
  0x71, 0x07, 0x03, 0x30, 0x40, 0x77, 0x20, 0xB0, 0xD2, 0x81, 0x7F, 0x57, 0x28, 0x45, 0xF8, 0x7F,
  0x77, 0x40, 0xEA, 0x0A, 0x75, 0x81, 0x8F, 0xD8, 0x0C, 0x40, 0x0A, 0xA0, 0x15, 0x81, 0x5F, 0xC4,
  0x0D, 0xA0, 0x45, 0x81, 0x8F, 0x93, 0x01, 0xB0, 0x85, 0x81, 0xBF, 0x63, 0x04, 0xB0, 0xB5, 0x81,
  0xEF, 0x23, 0x83, 0x7F, 0x9F, 0xE4, 0x81, 0x2F, 0xE4, 0x84, 0xBF, 0x5E, 0xF2, 0x38, 0x15, 0xFC,
  0x48, 0x4E, 0xF2, 0xAF, 0x63, 0x81, 0x9F, 0x83, 0x01, 0xA1, 0x81, 0x7F, 0x93, 0x81, 0xCF, 0x53,
  0x85, 0x5F, 0xC0, 0x3F, 0xC3, 0xA0, 0x23, 0x81, 0x8F, 0x92, 0xA2, 0x81, 0x3F, 0xE4, 0x81, 0xBF,
  0x62, 0x85, 0xCF, 0x40, 0x6F, 0xB4, 0x81, 0xEF, 0x32, 0x85, 0x9F, 0x70, 0x9F, 0x83, 0x02, 0xA3,
  0x85, 0x5F, 0xA0, 0xCF, 0x53, 0x81, 0x5F, 0xC3, 0x85, 0x2F, 0xE0, 0xEF, 0x23, 0x81, 0x8F, 0x94,
  0x83, 0xEF, 0x4F, 0xE4, 0x81, 0xBF, 0x54, 0x83, 0xBF, 0xAF, 0xB4, 0x81, 0xEF, 0x24, 0x07, 0xB0,
  0x73, 0x81, 0x2F, 0xE5, 0x04, 0xB0, 0x43, 0x81, 0x5F, 0xB6, 0xB0, 0x13, 0x81, 0x8F, 0x86, 0x81,
  0xCF, 0xD4,
  // "ň" (U+0148)
  0x50, 0x70, 0x33, 0x04, 0x07, 0x50, 0xB0, 0xD2, 0x81, 0x7F, 0x55, 0x84, 0x5F, 0x87, 0xF7, 0x70,
  0xEA, 0x0A, 0x71, 0x81, 0x8F, 0xD7, 0x77, 0x72, 0x86, 0xDF, 0x04, 0xCE, 0xD5, 0x49, 0x82, 0xE6,
  0xFE, 0xB0, 0x22, 0x89, 0x03, 0xFE, 0xE5, 0x01, 0xEF, 0x62, 0x07, 0xA0, 0x63, 0x81, 0xCF, 0x72,
  0x81, 0xAF, 0xD4, 0x81, 0xDF, 0x52, 0x81, 0xDF, 0x73, 0x01, 0xA8, 0x12, 0x01, 0xA0, 0x33, 0x04,
  0xA2, 0x81, 0x4F, 0xE4, 0x81, 0x7F, 0xC2, 0x81, 0x7F, 0xB4, 0x81, 0xAF, 0x82, 0x81, 0xAF, 0x84,
  0x81, 0xDF, 0x52, 0x81, 0xEF, 0x53, 0x01, 0xA8, 0x12, 0x01, 0xA0, 0x23, 0x81, 0x4F, 0xE2, 0x81,
  0x5F, 0xE4, 0x81, 0x7F, 0xB2, 0x81, 0x8F, 0xB4, 0x81, 0xBF, 0x72, 0x81, 0xBF, 0x74, 0x81, 0xEF,
  0x42,
  // "ŉ" (U+0149)
  0x20, 0x2A, 0x04, 0x72, 0x81, 0x7F, 0xD7, 0x38, 0x1D, 0xF5, 0x72, 0x81, 0x3F, 0xD7, 0x38, 0x1A,
  0xF5, 0x72, 0x8A, 0x41, 0xFB, 0x0D, 0xF0, 0x4C, 0xED, 0x50, 0x37, 0x20, 0xFE, 0x6F, 0xEB, 0x02,
  0x38, 0x90, 0x3F, 0xEE, 0x50, 0x1E, 0xF6, 0x30, 0x7A, 0x06, 0x38, 0x1C, 0xF7, 0x38, 0x1A, 0xFD,
  0x48, 0x1D, 0xF5, 0x38, 0x1D, 0xF7, 0x30, 0x1A, 0x02, 0x20, 0x1A, 0x03, 0x30, 0x4A, 0x38, 0x14,
  0xFE, 0x48, 0x17, 0xFC, 0x38, 0x17, 0xFB, 0x48, 0x1A, 0xF8, 0x38, 0x1A, 0xF8, 0x48, 0x1D, 0xF5,
  0x38, 0x1E, 0xF5, 0x30, 0x1A, 0x02, 0x20, 0x1A, 0x02, 0x38, 0x14, 0xFE, 0x38, 0x15, 0xFE, 0x48,
  0x17, 0xFB, 0x38, 0x18, 0xFB, 0x48, 0x1B, 0xF7, 0x38, 0x1B, 0xF7, 0x48, 0x1E, 0xF4, 0x20,
  // "Ŋ" (U+014A)
  0x40, 0xAA, 0x01, 0x58, 0x15, 0xFC, 0x40, 0xDA, 0x05, 0x58, 0x19, 0xF9, 0x30, 0x1B, 0x08, 0x58,
  0x1C, 0xF5, 0x38, 0x34, 0xFE, 0xFC, 0x5A, 0x02, 0x38, 0x17, 0xF9, 0xA4, 0x81, 0x3F, 0xE4, 0x84,
  0xBF, 0x5C, 0xF3, 0x38, 0x16, 0xFB, 0x48, 0x4E, 0xF2, 0x9F, 0x73, 0x81, 0x9F, 0x83, 0x01, 0xA1,
  0x81, 0x5F, 0xA3, 0x81, 0xCF, 0x53, 0x85, 0x5F, 0xC0, 0x2F, 0xE3, 0xA0, 0x23, 0x81, 0x8F, 0x92,
  0x85, 0xDF, 0x20, 0x3F, 0xE4, 0x81, 0xBF, 0x52, 0x85, 0xAF, 0x50, 0x6F, 0xB4, 0x81, 0xEF, 0x22,
  0x85, 0x6F, 0x90, 0x9F, 0x73, 0x81, 0x2F, 0xE3, 0x85, 0x3F, 0xC0, 0xCF, 0x43, 0x81, 0x5F, 0xB4,
  0xA0, 0x1A, 0x01, 0x38, 0x18, 0xF8, 0x48, 0x3B, 0xF6, 0xFD, 0x48, 0x1B, 0xF5, 0x48, 0x38, 0xFC,
  0xFA, 0x48, 0x1E, 0xF2, 0x40, 0x4B, 0x07, 0x38, 0x12, 0xFE, 0x50, 0x1B, 0x04, 0x38, 0x15, 0xFB,
  0x60, 0xDA, 0x01, 0x38, 0x18, 0xF8, 0x68, 0x19, 0xFD, 0x76, 0x81, 0x8F, 0x97, 0x68, 0x1D, 0xF4,
  0x75, 0x81, 0x8F, 0xD7, 0x38, 0x18, 0xEE, 0xA0, 0x47, 0x38, 0x39, 0xEE, 0xB4, 0x60,
  // "ŋ" (U+014B)
  0x38, 0x6C, 0xF0, 0x4C, 0xEC, 0x54, 0x98, 0x2D, 0x5F, 0xEB, 0x02, 0x28, 0x90, 0x3F, 0xEE, 0x50,
  0x1E, 0xF6, 0x20, 0x6A, 0x06, 0x38, 0x1B, 0xF6, 0x28, 0x19, 0xFD, 0x48, 0x1D, 0xF4, 0x28, 0x1C,
  0xF7, 0x30, 0x1A, 0x01, 0x2A, 0x02, 0x38, 0x14, 0xFE, 0x28, 0x13, 0xFE, 0x48, 0x17, 0xFA, 0x28,
  0x17, 0xFB, 0x48, 0x1A, 0xF7, 0x28, 0x1A, 0xF8, 0x48, 0x1E, 0xF4, 0x28, 0x1D, 0xF5, 0x30, 0x1A,
  0x20, 0x1A, 0x01, 0x38, 0x15, 0xFC, 0x28, 0x14, 0xFE, 0x48, 0x18, 0xF9, 0x28, 0x17, 0xFB, 0x48,
  0x1B, 0xF6, 0x28, 0x1A, 0xF7, 0x48, 0x1E, 0xF2, 0x71, 0x81, 0x2F, 0xE7, 0x28, 0x16, 0xFB, 0x72,
  0x81, 0xAF, 0x77, 0x10, 0x3A, 0x02, 0x60, 0xA0, 0xEA, 0x0A, 0x78, 0x29, 0xFE, 0x95,
  // "Ō" (U+014C)
  0x60, 0x98, 0x02, 0xD7, 0x0D, 0xD0, 0xD7, 0x77, 0x76, 0x85, 0x18, 0xDE, 0xEA, 0x36, 0x04, 0x0E,
  0xA0, 0xEB, 0x04, 0x48, 0x90, 0x3E, 0xF9, 0x10, 0x1B, 0xFE, 0x48, 0x1D, 0xF9, 0x40, 0x1A, 0x05,
  0x28, 0x18, 0xFD, 0x68, 0x6C, 0xF8, 0x01, 0xEF, 0x66, 0x86, 0xAF, 0xA0, 0x7F, 0xE1, 0x68, 0x5A,
  0xFA, 0x0C, 0xF9, 0x78, 0x2B, 0xF9, 0x1A, 0x05, 0x78, 0x2D, 0xF8, 0x4A, 0x02, 0x78, 0x4E, 0xF6,
  0x7F, 0xE7, 0x03, 0xA8, 0x23, 0x9F, 0xB7, 0x85, 0x6F, 0xE0, 0xBF, 0xA7, 0x85, 0xAF, 0xA0, 0xBF,
  0x97, 0x85, 0xEF, 0x50, 0xBF, 0x96, 0x81, 0x6F, 0xE2, 0x81, 0x9F, 0xB6, 0x81, 0xDF, 0x72, 0x06,
  0xA0, 0x14, 0x81, 0x9F, 0xD3, 0x86, 0x1E, 0xFB, 0x10, 0x1A, 0xA0, 0x34, 0x05, 0xB0, 0xEA, 0x0E,
  0x04, 0x68, 0x53, 0xBE, 0xFD, 0x81, 0x50,
  // "ō" (U+014D)
  0x40, 0x98, 0x02, 0xD5, 0x0D, 0xD0, 0xD7, 0x77, 0x71, 0x84, 0x19, 0xDF, 0xD6, 0x50, 0x20, 0xDA,
  0x0E, 0xA0, 0x74, 0x86, 0xDF, 0xA1, 0x08, 0xFE, 0x38, 0x18, 0xFC, 0x48, 0x1E, 0xF4, 0x28, 0x1E,
  0xF4, 0x48, 0x5D, 0xF5, 0x05, 0xFE, 0x58, 0x5D, 0xF5, 0x09, 0xF9, 0x58, 0x5E, 0xF4, 0x0D, 0xF5,
  0x40, 0x1A, 0x01, 0x1A, 0x03, 0x48, 0x35, 0xFE, 0x01, 0xA0, 0x14, 0x83, 0xAF, 0x90, 0x1A, 0x01,
  0x38, 0x21, 0xEF, 0x42, 0xA0, 0x33, 0x81, 0x9F, 0xC3, 0x81, 0xBF, 0xB2, 0x07, 0xA0, 0x33, 0x03,
  0xB0, 0xEA, 0x05, 0x58, 0x44, 0xBF, 0xEA, 0x34,
  // "Ŏ" (U+014E)
  0x68, 0x11, 0x71, 0x28, 0x11, 0x72, 0x68, 0x13, 0xF7, 0x28, 0x19, 0xF1, 0x68, 0x21, 0xEF, 0xEA,
  0x08, 0x71, 0x83, 0x4C, 0xED, 0x77, 0x77, 0x77, 0x85, 0x18, 0xDE, 0xEA, 0x36, 0x04, 0x0E, 0xA0,
  0xEB, 0x04, 0x48, 0x90, 0x3E, 0xF9, 0x10, 0x1B, 0xFE, 0x48, 0x1D, 0xF9, 0x40, 0x1A, 0x05, 0x28,
  0x18, 0xFD, 0x68, 0x6C, 0xF8, 0x01, 0xEF, 0x66, 0x86, 0xAF, 0xA0, 0x7F, 0xE1, 0x68, 0x5A, 0xFA,
  0x0C, 0xF9, 0x78, 0x2B, 0xF9, 0x1A, 0x05, 0x78, 0x2D, 0xF8, 0x4A, 0x02, 0x78, 0x4E, 0xF6, 0x7F,
  0xE7, 0x03, 0xA8, 0x23, 0x9F, 0xB7, 0x85, 0x6F, 0xE0, 0xBF, 0xA7, 0x85, 0xAF, 0xA0, 0xBF, 0x97,
  0x85, 0xEF, 0x50, 0xBF, 0x96, 0x81, 0x6F, 0xE2, 0x81, 0x9F, 0xB6, 0x81, 0xDF, 0x72, 0x06, 0xA0,
  0x14, 0x81, 0x9F, 0xD3, 0x86, 0x1E, 0xFB, 0x10, 0x1A, 0xA0, 0x34, 0x05, 0xB0, 0xEA, 0x0E, 0x04,
  0x68, 0x53, 0xBE, 0xFD, 0x81, 0x50,
  // "ŏ" (U+014F)
  0x48, 0x11, 0x71, 0x28, 0x11, 0x72, 0x48, 0x13, 0xF7, 0x28, 0x19, 0xF1, 0x48, 0x21, 0xEF, 0xEA,
  0x08, 0x68, 0x34, 0xCE, 0xD7, 0x77, 0x77, 0x28, 0x41, 0x9D, 0xFD, 0x65, 0x02, 0x0D, 0xA0, 0xEA,
  0x07, 0x48, 0x6D, 0xFA, 0x10, 0x8F, 0xE3, 0x81, 0x8F, 0xC4, 0x81, 0xEF, 0x42, 0x81, 0xEF, 0x44,
  0x85, 0xDF, 0x50, 0x5F, 0xE5, 0x85, 0xDF, 0x50, 0x9F, 0x95, 0x85, 0xEF, 0x40, 0xDF, 0x54, 0x01,
  0xA0, 0x11, 0xA0, 0x34, 0x83, 0x5F, 0xE0, 0x1A, 0x01, 0x48, 0x3A, 0xF9, 0x01, 0xA0, 0x13, 0x82,
  0x1E, 0xF4, 0x2A, 0x03, 0x38, 0x19, 0xFC, 0x38, 0x1B, 0xFB, 0x20, 0x7A, 0x03, 0x30, 0x3B, 0x0E,
  0xA0, 0x55, 0x84, 0x4B, 0xFE, 0xA3, 0x40,
  // "Ő" (U+0150)
  0x71, 0x83, 0x5F, 0xE1, 0x3A, 0x03, 0x78, 0x62, 0xEE, 0x20, 0xDF, 0x47, 0x18, 0x5D, 0xD2, 0x0A,
  0xE4, 0x71, 0x85, 0xBB, 0x10, 0x8D, 0x28, 0x0C, 0x40, 0x85, 0x18, 0xDE, 0xEA, 0x37, 0x10, 0x40,
  0xEA, 0x0E, 0xB0, 0x46, 0x89, 0x03, 0xEF, 0x91, 0x01, 0xBF, 0xE6, 0x81, 0xDF, 0x94, 0x01, 0xA0,
  0x54, 0x81, 0x8F, 0xD6, 0x81, 0xCF, 0x83, 0x82, 0x1E, 0xF6, 0x68, 0x1A, 0xFA, 0x38, 0x27, 0xFE,
  0x16, 0x81, 0xAF, 0xA3, 0x81, 0xCF, 0x97, 0x81, 0xBF, 0x92, 0x01, 0xA0, 0x57, 0x81, 0xDF, 0x82,
  0x04, 0xA0, 0x27, 0x81, 0xEF, 0x62, 0x81, 0x7F, 0xE7, 0x03, 0xA0, 0x32, 0x81, 0x9F, 0xB7, 0x81,
  0x6F, 0xE3, 0x81, 0xBF, 0xA7, 0x81, 0xAF, 0xA3, 0x81, 0xBF, 0x97, 0x81, 0xEF, 0x53, 0x81, 0xBF,
  0x96, 0x81, 0x6F, 0xE4, 0x81, 0x9F, 0xB6, 0x81, 0xDF, 0x74, 0x06, 0xA0, 0x14, 0x81, 0x9F, 0xD5,
  0x86, 0x1E, 0xFB, 0x10, 0x1A, 0xA0, 0x36, 0x05, 0xB0, 0xEA, 0x0E, 0x04, 0x71, 0x85, 0x3B, 0xEF,
  0xD8, 0x17,
  // "ő" (U+0151)
  0x78, 0x35, 0xFE, 0x13, 0xA0, 0x36, 0x86, 0x2E, 0xE2, 0x0D, 0xF4, 0x78, 0x5D, 0xD2, 0x0A, 0xE4,
  0x78, 0x5B, 0xB1, 0x08, 0xD2, 0x80, 0xC1, 0x08, 0x41, 0x9D, 0xFD, 0x67, 0x10, 0x20, 0xDA, 0x0E,
  0xA0, 0x77, 0x86, 0xDF, 0xA1, 0x08, 0xFE, 0x68, 0x18, 0xFC, 0x48, 0x1E, 0xF4, 0x58, 0x1E, 0xF4,
  0x48, 0x1D, 0xF5, 0x48, 0x15, 0xFE, 0x58, 0x1D, 0xF5, 0x48, 0x19, 0xF9, 0x58, 0x1E, 0xF4, 0x48,
  0x1D, 0xF5, 0x40, 0x1A, 0x01, 0x4A, 0x03, 0x48, 0x15, 0xFE, 0x40, 0x1A, 0x01, 0x48, 0x1A, 0xF9,
  0x40, 0x1A, 0x01, 0x38, 0x21, 0xEF, 0x45, 0xA0, 0x33, 0x81, 0x9F, 0xC6, 0x81, 0xBF, 0xB2, 0x07,
  0xA0, 0x36, 0x03, 0xB0, 0xEA, 0x05, 0x71, 0x84, 0x4B, 0xFE, 0xA3, 0x70,
  // "Œ" (U+0152)
  0x58, 0x12, 0x8D, 0xFB, 0x40, 0x50, 0xEA, 0x0E, 0x0D, 0xA8, 0x4E, 0xDD, 0xDD, 0xB3, 0x04, 0xA8,
  0x29, 0x10, 0x3A, 0x71, 0x82, 0x1E, 0xF9, 0x38, 0x16, 0xFC, 0x71, 0x81, 0x9F, 0xD4, 0x81, 0x9F,
  0x97, 0x01, 0xA0, 0x54, 0x81, 0xCF, 0x77, 0x81, 0x7F, 0xD5, 0xA0, 0x47, 0x81, 0xCF, 0x84, 0x03,
  0xA0, 0x16, 0x01, 0xA0, 0x44, 0x81, 0x6F, 0xD7, 0x04, 0xA0, 0x14, 0x09, 0xE0, 0xE2, 0x81, 0x7F,
  0xD5, 0x86, 0xDF, 0xED, 0xDD, 0xD9, 0x28, 0x19, 0xFB, 0x5A, 0x04, 0x78, 0x1B, 0xFA, 0x40, 0x3A,
  0x71, 0x81, 0xBF, 0x94, 0x81, 0x7F, 0xD7, 0x18, 0x1B, 0xF9, 0x48, 0x1A, 0xF9, 0x71, 0x81, 0x9F,
  0xB4, 0x81, 0xDF, 0x67, 0x10, 0x6A, 0x01, 0x3A, 0x03, 0x71, 0x85, 0x1E, 0xFC, 0x20, 0x4A, 0x73,
  0x05, 0xB0, 0xEB, 0x80, 0x1D, 0x05, 0x58, 0x13, 0xAE, 0xFA, 0x02, 0x30,
  // "œ" (U+0153)
  0x48, 0x41, 0x9D, 0xEC, 0x42, 0x84, 0x19, 0xDE, 0xB3, 0x40, 0x20, 0xDA, 0x0E, 0xA8, 0x12, 0x2D,
  0xA8, 0x2E, 0xFE, 0x13, 0x89, 0x1D, 0xFA, 0x10, 0x7F, 0x9D, 0xF6, 0x28, 0x1C, 0xF5, 0x28, 0x17,
  0xFC, 0x40, 0xEA, 0x06, 0x38, 0x1A, 0xF5, 0x28, 0x1E, 0xF4, 0x48, 0x1D, 0xFC, 0x38, 0x61, 0xEF,
  0x20, 0x5F, 0xE5, 0x87, 0xDF, 0x60, 0x16, 0xDF, 0x92, 0x81, 0x9F, 0x95, 0x82, 0xEF, 0xEE, 0xB0,
  0x93, 0x81, 0xDF, 0x54, 0x01, 0xB8, 0x2E, 0xC9, 0x34, 0xA0, 0x24, 0x81, 0x5F, 0xD7, 0x10, 0x1A,
  0x01, 0x48, 0x19, 0xFC, 0x71, 0x01, 0xA0, 0x13, 0x82, 0x1E, 0xFC, 0x72, 0xA0, 0x33, 0x09, 0xA0,
  0xE0, 0x17, 0x18, 0x1C, 0xFB, 0x28, 0x47, 0xFB, 0xAF, 0xA2, 0x81, 0x16, 0x43, 0x04, 0xD8, 0x1D,
  0x13, 0xB0, 0xEA, 0x06, 0x48, 0x44, 0xCF, 0xD9, 0x12, 0x85, 0x3B, 0xEE, 0xC6, 0x12,
  // "Ŕ" (U+0154)
  0x74, 0x81, 0x77, 0x47, 0x38, 0x28, 0xFD, 0x17, 0x28, 0x24, 0xFE, 0x27, 0x28, 0x21, 0xEE, 0x27,
  0x38, 0x1B, 0xD2, 0x77, 0x77, 0x70, 0xAB, 0x81, 0xEB, 0x57, 0x82, 0xDF, 0xEE, 0xB0, 0x85, 0x01,
  0xA8, 0x21, 0x01, 0xAA, 0x03, 0x48, 0x14, 0xFE, 0x48, 0x1E, 0xF7, 0x48, 0x17, 0xFB, 0x48, 0x1C,
  0xF9, 0x48, 0x1B, 0xF8, 0x48, 0x1C, 0xF8, 0x48, 0x1E, 0xF5, 0x48, 0x1E, 0xF6, 0x30, 0x1A, 0x02,
  0x30, 0x3A, 0x02, 0x38, 0x15, 0xFE, 0x48, 0x1C, 0xFB, 0x48, 0x18, 0xFB, 0x20, 0x30, 0xBA, 0x02,
  0x40, 0xBE, 0x0E, 0x04, 0x58, 0x2E, 0xFE, 0xDA, 0x09, 0x60, 0x2A, 0x83, 0x20, 0x9F, 0x96, 0x81,
  0x5F, 0xE2, 0x81, 0x5F, 0xD6, 0x81, 0x8F, 0xB2, 0x02, 0xA0, 0x25, 0x81, 0xBF, 0x73, 0x81, 0xEF,
  0x65, 0x81, 0xEF, 0x43, 0x81, 0xAF, 0xA4, 0x02, 0xA0, 0x13, 0x81, 0x7F, 0xE4, 0x81, 0x5F, 0xD4,
  0x03, 0xA0, 0x23, 0x81, 0x8F, 0xA5, 0xA0, 0x63,
  // "ŕ" (U+0155)
  0x71, 0x81, 0x77, 0x47, 0x82, 0x8F, 0xD1, 0x68, 0x24, 0xFE, 0x26, 0x82, 0x1E, 0xE2, 0x78, 0x1B,
  0xD2, 0x77, 0x77, 0x85, 0xCE, 0x05, 0xDF, 0x64, 0x98, 0x4C, 0x6F, 0xEF, 0x23, 0x83, 0x3F, 0xDE,
  0x56, 0x06, 0xA0, 0x67, 0x81, 0x9F, 0xD7, 0x18, 0x1C, 0xF7, 0x71, 0xA0, 0x37, 0x81, 0x3F, 0xE7,
  0x18, 0x17, 0xFB, 0x71, 0x81, 0xAF, 0x77, 0x18, 0x1D, 0xF4, 0x70, 0x1A, 0x01, 0x78, 0x14, 0xFE,
  0x71, 0x81, 0x7F, 0xB7, 0x18, 0x1A, 0xF7, 0x71,
  // "Ŗ" (U+0156)
  0x40, 0xAB, 0x81, 0xEB, 0x56, 0x82, 0xDF, 0xEE, 0xB0, 0x84, 0x01, 0xA8, 0x21, 0x01, 0xAA, 0x03,
  0x38, 0x14, 0xFE, 0x48, 0x1E, 0xF7, 0x38, 0x17, 0xFB, 0x48, 0x1C, 0xF9, 0x38, 0x1B, 0xF8, 0x48,
  0x1C, 0xF8, 0x38, 0x1E, 0xF5, 0x48, 0x1E, 0xF6, 0x20, 0x1A, 0x02, 0x30, 0x3A, 0x02, 0x28, 0x15,
  0xFE, 0x48, 0x1C, 0xFB, 0x38, 0x18, 0xFB, 0x20, 0x30, 0xBA, 0x02, 0x30, 0xBE, 0x0E, 0x04, 0x48,
  0x2E, 0xFE, 0xDA, 0x09, 0x50, 0x2A, 0x83, 0x20, 0x9F, 0x95, 0x81, 0x5F, 0xE2, 0x81, 0x5F, 0xD5,
  0x81, 0x8F, 0xB2, 0x02, 0xA0, 0x24, 0x81, 0xBF, 0x73, 0x81, 0xEF, 0x64, 0x81, 0xEF, 0x43, 0x81,
  0xAF, 0xA3, 0x02, 0xA0, 0x13, 0x81, 0x7F, 0xE3, 0x81, 0x5F, 0xD4, 0x03, 0xA0, 0x22, 0x81, 0x8F,
  0xA5, 0xA0, 0x67, 0x74, 0x81, 0x17, 0x77, 0x38, 0x17, 0xFB, 0x73, 0x81, 0xDF, 0x27, 0x28, 0x16,
  0xF6, 0x73, 0x0D, 0x0A, 0x72,
  // "ŗ" (U+0157)
  0x48, 0x5C, 0xE0, 0x5D, 0xF6, 0x49, 0x84, 0xC6, 0xFE, 0xF2, 0x38, 0x33, 0xFD, 0xE5, 0x60, 0x6A,
  0x06, 0x78, 0x19, 0xFD, 0x71, 0x81, 0xCF, 0x77, 0x1A, 0x03, 0x78, 0x13, 0xFE, 0x71, 0x81, 0x7F,
  0xB7, 0x18, 0x1A, 0xF7, 0x71, 0x81, 0xDF, 0x47, 0x01, 0xA0, 0x17, 0x81, 0x4F, 0xE7, 0x18, 0x17,
  0xFB, 0x71, 0x81, 0xAF, 0x77, 0x75, 0x81, 0x17, 0x77, 0x18, 0x17, 0xFB, 0x71, 0x81, 0xDF, 0x27,
  0x81, 0x6F, 0x67, 0x10, 0xD0, 0xA7, 0x20,
  // "Ř" (U+0158)
  0x60, 0x70, 0x33, 0x04, 0x07, 0x60, 0xB0, 0xD2, 0x81, 0x7F, 0x56, 0x84, 0x5F, 0x87, 0xF7, 0x71,
  0x0E, 0xA0, 0xA7, 0x28, 0x18, 0xFD, 0x77, 0x77, 0x50, 0xAB, 0x81, 0xEB, 0x56, 0x82, 0xDF, 0xEE,
  0xB0, 0x84, 0x01, 0xA8, 0x21, 0x01, 0xAA, 0x03, 0x38, 0x14, 0xFE, 0x48, 0x1E, 0xF7, 0x38, 0x17,
  0xFB, 0x48, 0x1C, 0xF9, 0x38, 0x1B, 0xF8, 0x48, 0x1C, 0xF8, 0x38, 0x1E, 0xF5, 0x48, 0x1E, 0xF6,
  0x20, 0x1A, 0x02, 0x30, 0x3A, 0x02, 0x28, 0x15, 0xFE, 0x48, 0x1C, 0xFB, 0x38, 0x18, 0xFB, 0x20,
  0x30, 0xBA, 0x02, 0x30, 0xBE, 0x0E, 0x04, 0x48, 0x2E, 0xFE, 0xDA, 0x09, 0x50, 0x2A, 0x83, 0x20,
  0x9F, 0x95, 0x81, 0x5F, 0xE2, 0x81, 0x5F, 0xD5, 0x81, 0x8F, 0xB2, 0x02, 0xA0, 0x24, 0x81, 0xBF,
  0x73, 0x81, 0xEF, 0x64, 0x81, 0xEF, 0x43, 0x81, 0xAF, 0xA3, 0x02, 0xA0, 0x13, 0x81, 0x7F, 0xE3,
  0x81, 0x5F, 0xD4, 0x03, 0xA0, 0x22, 0x81, 0x8F, 0xA5, 0xA0, 0x62,
  // "ř" (U+0159)
  0x40, 0x70, 0x33, 0x04, 0x07, 0x40, 0xB0, 0xD2, 0x81, 0x7F, 0x54, 0x84, 0x5F, 0x87, 0xF7, 0x60,
  0xEA, 0x0A, 0x78, 0x18, 0xFD, 0x77, 0x77, 0x85, 0xCE, 0x05, 0xDF, 0x64, 0x98, 0x4C, 0x6F, 0xEF,
  0x23, 0x83, 0x3F, 0xDE, 0x56, 0x06, 0xA0, 0x67, 0x81, 0x9F, 0xD7, 0x18, 0x1C, 0xF7, 0x71, 0xA0,
  0x37, 0x81, 0x3F, 0xE7, 0x18, 0x17, 0xFB, 0x71, 0x81, 0xAF, 0x77, 0x18, 0x1D, 0xF4, 0x70, 0x1A,
  0x01, 0x78, 0x14, 0xFE, 0x71, 0x81, 0x7F, 0xB7, 0x18, 0x1A, 0xF7, 0x71,
  // "Ś" (U+015A)
  0x74, 0x81, 0x77, 0x47, 0x38, 0x28, 0xFD, 0x17, 0x28, 0x24, 0xFE, 0x27, 0x28, 0x21, 0xEE, 0x27,
  0x38, 0x1B, 0xD2, 0x80, 0xC1, 0x08, 0x57, 0xCE, 0xFD, 0x94, 0x50, 0x20, 0xDA, 0x00, 0xEA, 0x0A,
  0x58, 0x2C, 0xFD, 0x32, 0x81, 0x3A, 0x24, 0x82, 0x5F, 0xE2, 0x73, 0x81, 0x8F, 0xB7, 0x48, 0x1A,
  0xFA, 0x74, 0x81, 0x9F, 0xD7, 0x40, 0x6A, 0x08, 0x74, 0x0D, 0xA0, 0x77, 0x30, 0x20, 0xEA, 0x07,
  0x73, 0x03, 0x0E, 0xA0, 0x67, 0x30, 0x20, 0xEA, 0x01, 0x73, 0x04, 0xA0, 0x77, 0x48, 0x1C, 0xF9,
  0x74, 0x81, 0xAF, 0xA7, 0x48, 0x1C, 0xF8, 0x73, 0x02, 0xA0, 0x43, 0x81, 0x1B, 0x43, 0x82, 0x5D,
  0xFB, 0x40, 0x3B, 0x0E, 0xB0, 0xC0, 0x14, 0x86, 0x18, 0xCE, 0xFE, 0xC6, 0x60,
  // "ś" (U+015B)
  0x72, 0x81, 0x77, 0x47, 0x18, 0x28, 0xFD, 0x17, 0x82, 0x4F, 0xE2, 0x78, 0x21, 0xEE, 0x27, 0x18,
  0x1B, 0xD2, 0x77, 0x77, 0x38, 0x55, 0xCF, 0xEC, 0x81, 0x40, 0x7A, 0x00, 0xEA, 0x05, 0x30, 0x1A,
  0x06, 0x20, 0x30, 0x94, 0x81, 0x5F, 0xD7, 0x28, 0x15, 0xFD, 0x72, 0x02, 0xA0, 0x67, 0x20, 0x9A,
  0x06, 0x72, 0x0A, 0xA0, 0x77, 0x20, 0x9A, 0x04, 0x72, 0x81, 0xCF, 0xA7, 0x28, 0x17, 0xFC, 0x72,
  0x81, 0x9F, 0xB3, 0x81, 0x28, 0x22, 0x82, 0x4E, 0xF7, 0x30, 0x2A, 0x00, 0xEA, 0x0C, 0x58, 0x48,
  0xCE, 0xFD, 0x85,
  // "Ŝ" (U+015C)
  0x71, 0x81, 0x57, 0x47, 0x20, 0x3A, 0x0C, 0x71, 0x84, 0x1E, 0xEC, 0xF2, 0x78, 0x4C, 0xD2, 0x3F,
  0x96, 0x81, 0xBC, 0x12, 0x81, 0x7F, 0x17, 0x77, 0x74, 0x85, 0x7C, 0xEF, 0xD9, 0x44, 0x02, 0x0D,
  0xA0, 0x0E, 0xA0, 0xA4, 0x82, 0xCF, 0xD3, 0x28, 0x13, 0xA2, 0x38, 0x25, 0xFE, 0x27, 0x28, 0x18,
  0xFB, 0x73, 0x81, 0xAF, 0xA7, 0x38, 0x19, 0xFD, 0x73, 0x06, 0xA0, 0x87, 0x30, 0xDA, 0x07, 0x72,
  0x02, 0x0E, 0xA0, 0x77, 0x20, 0x30, 0xEA, 0x06, 0x72, 0x02, 0x0E, 0xA0, 0x17, 0x20, 0x4A, 0x07,
  0x73, 0x81, 0xCF, 0x97, 0x38, 0x1A, 0xFA, 0x73, 0x81, 0xCF, 0x87, 0x20, 0x2A, 0x04, 0x28, 0x11,
  0xB4, 0x38, 0x25, 0xDF, 0xB3, 0x03, 0xB0, 0xEB, 0x0C, 0x01, 0x38, 0x61, 0x8C, 0xEF, 0xEC, 0x65,
  // "ŝ" (U+015D)
  0x78, 0x15, 0x74, 0x71, 0x03, 0xA0, 0xC7, 0x84, 0x1E, 0xEC, 0xF2, 0x68, 0x4C, 0xD2, 0x3F, 0x95,
  0x81, 0xBC, 0x12, 0x81, 0x7F, 0x17, 0x77, 0x78, 0x55, 0xCF, 0xEC, 0x81, 0x40, 0x7A, 0x00, 0xEA,
  0x05, 0x30, 0x1A, 0x06, 0x20, 0x30, 0x94, 0x81, 0x5F, 0xD7, 0x28, 0x15, 0xFD, 0x72, 0x02, 0xA0,
  0x67, 0x20, 0x9A, 0x06, 0x72, 0x0A, 0xA0, 0x77, 0x20, 0x9A, 0x04, 0x72, 0x81, 0xCF, 0xA7, 0x28,
  0x17, 0xFC, 0x72, 0x81, 0x9F, 0xB3, 0x81, 0x28, 0x22, 0x82, 0x4E, 0xF7, 0x30, 0x2A, 0x00, 0xEA,
  0x0C, 0x58, 0x48, 0xCE, 0xFD, 0x85,
  // "Ş" (U+015E)
  0x68, 0x57, 0xCE, 0xFD, 0x94, 0x40, 0x20, 0xDA, 0x00, 0xEA, 0x0A, 0x48, 0x2C, 0xFD, 0x32, 0x81,
  0x3A, 0x23, 0x82, 0x5F, 0xE2, 0x72, 0x81, 0x8F, 0xB7, 0x38, 0x1A, 0xFA, 0x73, 0x81, 0x9F, 0xD7,
  0x30, 0x6A, 0x08, 0x73, 0x0D, 0xA0, 0x77, 0x20, 0x20, 0xEA, 0x07, 0x72, 0x03, 0x0E, 0xA0, 0x67,
  0x20, 0x20, 0xEA, 0x01, 0x72, 0x04, 0xA0, 0x77, 0x38, 0x1C, 0xF9, 0x73, 0x81, 0xAF, 0xA7, 0x38,
  0x1C, 0xF8, 0x72, 0x02, 0xA0, 0x42, 0x81, 0x1B, 0x43, 0x82, 0x5D, 0xFB, 0x30, 0x3B, 0x0E, 0xB0,
  0xC0, 0x13, 0x82, 0x18, 0xCE, 0xA0, 0xC0, 0x67, 0x20, 0xB0, 0x97, 0x38, 0x25, 0xFB, 0x27, 0x38,
  0x12, 0xEC, 0x74, 0x0D, 0x0E, 0x71, 0x83, 0x99, 0xDF, 0xA7, 0x01, 0xB0, 0xC0, 0x17, 0x18, 0x12,
  0x42, 0x71,
  // "ş" (U+015F)
  0x48, 0x55, 0xCF, 0xEC, 0x81, 0x30, 0x7A, 0x00, 0xEA, 0x05, 0x20, 0x1A, 0x06, 0x20, 0x30, 0x93,
  0x81, 0x5F, 0xD7, 0x18, 0x15, 0xFD, 0x71, 0x02, 0xA0, 0x67, 0x10, 0x9A, 0x06, 0x71, 0x0A, 0xA0,
  0x77, 0x10, 0x9A, 0x04, 0x71, 0x81, 0xCF, 0xA7, 0x18, 0x17, 0xFC, 0x71, 0x81, 0x9F, 0xB2, 0x81,
  0x28, 0x22, 0x82, 0x4E, 0xF7, 0x20, 0x2A, 0x00, 0xEA, 0x0C, 0x40, 0x80, 0xCA, 0x0D, 0x08, 0x70,
  0xB0, 0x97, 0x18, 0x25, 0xFB, 0x27, 0x18, 0x12, 0xEC, 0x72, 0x0D, 0x0E, 0x68, 0x39, 0x9D, 0xFA,
  0x50, 0x1B, 0x0C, 0x01, 0x68, 0x12, 0x42, 0x70,
  // "Š" (U+0160)
  0x70, 0x70, 0x33, 0x04, 0x07, 0x70, 0xB0, 0xD2, 0x81, 0x7F, 0x57, 0x84, 0x5F, 0x87, 0xF7, 0x72,
  0x0E, 0xA0, 0xA7, 0x38, 0x18, 0xFD, 0x80, 0xC1, 0x08, 0x57, 0xCE, 0xFD, 0x94, 0x50, 0x20, 0xDA,
  0x00, 0xEA, 0x0A, 0x58, 0x2C, 0xFD, 0x32, 0x81, 0x3A, 0x24, 0x82, 0x5F, 0xE2, 0x73, 0x81, 0x8F,
  0xB7, 0x48, 0x1A, 0xFA, 0x74, 0x81, 0x9F, 0xD7, 0x40, 0x6A, 0x08, 0x74, 0x0D, 0xA0, 0x77, 0x30,
  0x20, 0xEA, 0x07, 0x73, 0x03, 0x0E, 0xA0, 0x67, 0x30, 0x20, 0xEA, 0x01, 0x73, 0x04, 0xA0, 0x77,
  0x48, 0x1C, 0xF9, 0x74, 0x81, 0xAF, 0xA7, 0x48, 0x1C, 0xF8, 0x73, 0x02, 0xA0, 0x43, 0x81, 0x1B,
  0x43, 0x82, 0x5D, 0xFB, 0x40, 0x3B, 0x0E, 0xB0, 0xC0, 0x14, 0x86, 0x18, 0xCE, 0xFE, 0xC6, 0x60,
  // "š" (U+0161)
  0x50, 0x70, 0x33, 0x04, 0x07, 0x50, 0xB0, 0xD2, 0x81, 0x7F, 0x55, 0x84, 0x5F, 0x87, 0xF7, 0x70,
  0xEA, 0x0A, 0x71, 0x81, 0x8F, 0xD7, 0x77, 0x73, 0x85, 0x5C, 0xFE, 0xC8, 0x14, 0x07, 0xA0, 0x0E,
  0xA0, 0x53, 0x01, 0xA0, 0x62, 0x03, 0x09, 0x48, 0x15, 0xFD, 0x72, 0x81, 0x5F, 0xD7, 0x20, 0x2A,
  0x06, 0x72, 0x09, 0xA0, 0x67, 0x20, 0xAA, 0x07, 0x72, 0x09, 0xA0, 0x47, 0x28, 0x1C, 0xFA, 0x72,
  0x81, 0x7F, 0xC7, 0x28, 0x19, 0xFB, 0x38, 0x12, 0x82, 0x28, 0x24, 0xEF, 0x73, 0x02, 0xA0, 0x0E,
  0xA0, 0xC5, 0x84, 0x8C, 0xEF, 0xD8, 0x50,
  // "Ţ" (U+0162)
  0x30, 0x7F, 0xA0, 0x93, 0x09, 0x0F, 0xDA, 0x83, 0xED, 0xDD, 0x57, 0xA0, 0x37, 0x30, 0x3A, 0x74,
  0x81, 0x6F, 0xD7, 0x48, 0x19, 0xFA, 0x74, 0x81, 0xCF, 0x67, 0x4A, 0x03, 0x73, 0x03, 0xA7, 0x48,
  0x16, 0xFD, 0x74, 0x81, 0x9F, 0x97, 0x48, 0x1C, 0xF6, 0x74, 0xA0, 0x37, 0x30, 0x3A, 0x74, 0x81,
  0x6F, 0xC7, 0x48, 0x19, 0xF9, 0x74, 0x81, 0xCF, 0x67, 0x4A, 0x03, 0x73, 0x03, 0xA7, 0x48, 0x17,
  0xFC, 0x74, 0x0B, 0x09, 0x74, 0x82, 0x5F, 0xB2, 0x74, 0x81, 0x2E, 0xC7, 0x50, 0xD0, 0xE7, 0x28,
  0x39, 0x9D, 0xFA, 0x71, 0x01, 0xB0, 0xC0, 0x17, 0x28, 0x12, 0x42, 0x73,
  // "ţ" (U+0163)
  0x58, 0x12, 0x71, 0x60, 0xA9, 0x68, 0x11, 0xFC, 0x68, 0x16, 0xF9, 0x40, 0x20, 0xAC, 0x0E, 0x20,
  0x70, 0xDA, 0x81, 0xDD, 0xA3, 0x81, 0x3F, 0xE6, 0x81, 0x6F, 0xB6, 0x81, 0x9F, 0x86, 0x81, 0xCF,
  0x56, 0xA0, 0x25, 0x81, 0x3F, 0xE6, 0x81, 0x7F, 0xB6, 0x81, 0xAF, 0x76, 0x81, 0xDF, 0x46, 0xA0,
  0x16, 0xA0, 0x36, 0x0D, 0xA0, 0xE0, 0x74, 0x83, 0x3D, 0xFD, 0x55, 0x0B, 0x09, 0x68, 0x25, 0xFB,
  0x26, 0x81, 0x2E, 0xC7, 0x0D, 0x0E, 0x48, 0x39, 0x9D, 0xFA, 0x30, 0x1B, 0x0C, 0x01, 0x48, 0x12,
  0x42, 0x50,
  // "Ť" (U+0164)
  0x30, 0x70, 0x33, 0x04, 0x07, 0x40, 0xB0, 0xD2, 0x81, 0x7F, 0x54, 0x84, 0x5F, 0x87, 0xF7, 0x60,
  0xEA, 0x0A, 0x78, 0x18, 0xFD, 0x77, 0x75, 0x07, 0xFA, 0x00, 0x90, 0xFD, 0xA8, 0x3E, 0xDD, 0xD5,
  0x4A, 0x03, 0x70, 0x3A, 0x71, 0x81, 0x6F, 0xD7, 0x18, 0x19, 0xFA, 0x71, 0x81, 0xCF, 0x67, 0x1A,
  0x03, 0x70, 0x3A, 0x71, 0x81, 0x6F, 0xD7, 0x18, 0x19, 0xF9, 0x71, 0x81, 0xCF, 0x67, 0x1A, 0x03,
  0x70, 0x3A, 0x71, 0x81, 0x6F, 0xC7, 0x18, 0x19, 0xF9, 0x71, 0x81, 0xCF, 0x67, 0x1A, 0x03, 0x70,
  0x3A, 0x71, 0x81, 0x6F, 0xC7, 0x10,
  // "ť" (U+0165)
  0x78, 0x1C, 0xF6, 0x68, 0x11, 0xFE, 0x48, 0x42, 0x71, 0x7F, 0x54, 0x83, 0xAF, 0x0D, 0xB4, 0x84,
  0x1F, 0xC1, 0x71, 0x48, 0x16, 0xF9, 0x50, 0x20, 0xAC, 0x0E, 0x30, 0x70, 0xDA, 0x81, 0xDD, 0xA4,
  0x81, 0x3F, 0xE7, 0x81, 0x6F, 0xB7, 0x81, 0x9F, 0x87, 0x81, 0xCF, 0x57, 0xA0, 0x26, 0x81, 0x3F,
  0xE7, 0x81, 0x7F, 0xB7, 0x81, 0xAF, 0x77, 0x81, 0xDF, 0x47, 0xA0, 0x17, 0xA0, 0x37, 0x0D, 0xA0,
  0xE0, 0x75, 0x83, 0x3C, 0xFD, 0x55,
  // "Ŧ" (U+0166)
  0x10, 0x6F, 0xA8, 0x19, 0x09, 0x0F, 0xDA, 0x83, 0xED, 0xDD, 0x55, 0xA0, 0x37, 0x10, 0x2A, 0x01,
  0x71, 0x81, 0x5F, 0xD7, 0x28, 0x18, 0xFA, 0x72, 0x81, 0xBF, 0x77, 0x28, 0x1E, 0xF4, 0x71, 0x02,
  0xA0, 0x15, 0x02, 0xF0, 0xC3, 0x87, 0x4D, 0xDE, 0xFE, 0xDD, 0x86, 0x81, 0xBF, 0x77, 0x28, 0x1E,
  0xF4, 0x71, 0x02, 0xA0, 0x17, 0x18, 0x15, 0xFD, 0x72, 0x81, 0x9F, 0xA7, 0x28, 0x1C, 0xF7, 0x72,
  0xA0, 0x47, 0x10, 0x3A, 0x72, 0x81, 0x6F, 0xD7, 0x10,
  // "ŧ" (U+0167)
  0x48, 0x12, 0x71, 0x50, 0xA0, 0xE5, 0x81, 0x1F, 0xB5, 0x81, 0x6F, 0x83, 0x02, 0x0A, 0xC8, 0x2E,
  0x07, 0xDA, 0x81, 0xDD, 0xA2, 0x81, 0x3F, 0xE5, 0x81, 0x6F, 0xB5, 0x81, 0xAF, 0x73, 0x05, 0x0D,
  0xA8, 0x3E, 0xDA, 0x09, 0xD0, 0x82, 0x81, 0x4F, 0xE5, 0x81, 0x7F, 0xA5, 0x81, 0xAF, 0x75, 0x81,
  0xDF, 0x45, 0xA0, 0x14, 0x01, 0xA0, 0x35, 0x0D, 0xA0, 0xE0, 0x73, 0x83, 0x3C, 0xFD, 0x52,
  // "Ũ" (U+0168)
  0x68, 0x25, 0xCB, 0x12, 0x0C, 0x07, 0x50, 0x2B, 0x83, 0xD3, 0x4F, 0x45, 0x82, 0x9D, 0x16, 0xB0,
  0xD6, 0x0D, 0x08, 0x28, 0x25, 0xED, 0x37, 0x77, 0x74, 0x81, 0xDF, 0x55, 0x81, 0x5F, 0xD3, 0xA0,
  0x25, 0x81, 0x8F, 0xA2, 0x81, 0x4F, 0xE6, 0x81, 0xCF, 0x72, 0x81, 0x7F, 0xB6, 0x81, 0xEF, 0x32,
  0x81, 0xAF, 0x85, 0x03, 0xA3, 0x81, 0xDF, 0x55, 0x81, 0x6F, 0xC2, 0x01, 0xA0, 0x25, 0x81, 0x9F,
  0x92, 0x81, 0x4F, 0xE6, 0x81, 0xCF, 0x62, 0x81, 0x8F, 0xB6, 0xA0, 0x32, 0x81, 0xBF, 0x75, 0x03,
  0xA3, 0x81, 0xEF, 0x45, 0x81, 0x7F, 0xC2, 0x02, 0xA0, 0x15, 0x81, 0xAF, 0x82, 0x81, 0x5F, 0xD6,
  0x81, 0xDF, 0x52, 0x81, 0x8F, 0xA5, 0x01, 0xA0, 0x22, 0x81, 0xAF, 0x85, 0x81, 0x5F, 0xD3, 0x81,
  0xBF, 0x85, 0x81, 0xBF, 0x93, 0x81, 0x9F, 0xB4, 0x03, 0xA0, 0x23, 0x05, 0xA8, 0x57, 0x11, 0x5E,
  0xF9, 0x50, 0xCE, 0x0B, 0x78, 0x48, 0xDF, 0xEB, 0x66,
  // "ũ" (U+0169)
  0x48, 0x25, 0xCB, 0x12, 0x0C, 0x07, 0x30, 0x2B, 0x83, 0xD3, 0x4F, 0x43, 0x82, 0x9D, 0x16, 0xB0,
  0xD4, 0x0D, 0x08, 0x28, 0x25, 0xED, 0x37, 0x77, 0x68, 0x1D, 0xF4, 0x30, 0x1A, 0x81, 0x10, 0x1A,
  0x01, 0x38, 0x14, 0xFD, 0x28, 0x14, 0xFD, 0x48, 0x17, 0xFA, 0x28, 0x18, 0xFA, 0x48, 0x1B, 0xF7,
  0x28, 0x1B, 0xF7, 0x48, 0x1E, 0xF3, 0x28, 0x1E, 0xF3, 0x30, 0x2A, 0x20, 0x2A, 0x48, 0x15, 0xFD,
  0x28, 0x15, 0xFC, 0x48, 0x18, 0xF9, 0x28, 0x18, 0xF9, 0x48, 0x1C, 0xF6, 0x28, 0x1B, 0xF6, 0x30,
  0x1A, 0x03, 0x28, 0x1E, 0xF3, 0x30, 0x7A, 0x3A, 0x02, 0x28, 0x21, 0xEF, 0xC3, 0xA8, 0x56, 0x02,
  0xDE, 0xF9, 0x30, 0xBA, 0x84, 0xEF, 0xB8, 0xF6, 0x38, 0x71, 0xAE, 0xD8, 0x09, 0xF3, 0x30,
  // "Ū" (U+016A)
  0x50, 0x98, 0x02, 0xD7, 0x0D, 0xD0, 0xD7, 0x77, 0x75, 0x81, 0xDF, 0x55, 0x81, 0x5F, 0xD3, 0xA0,
  0x25, 0x81, 0x8F, 0xA2, 0x81, 0x4F, 0xE6, 0x81, 0xCF, 0x72, 0x81, 0x7F, 0xB6, 0x81, 0xEF, 0x32,
  0x81, 0xAF, 0x85, 0x03, 0xA3, 0x81, 0xDF, 0x55, 0x81, 0x6F, 0xC2, 0x01, 0xA0, 0x25, 0x81, 0x9F,
  0x92, 0x81, 0x4F, 0xE6, 0x81, 0xCF, 0x62, 0x81, 0x8F, 0xB6, 0xA0, 0x32, 0x81, 0xBF, 0x75, 0x03,
  0xA3, 0x81, 0xEF, 0x45, 0x81, 0x7F, 0xC2, 0x02, 0xA0, 0x15, 0x81, 0xAF, 0x82, 0x81, 0x5F, 0xD6,
  0x81, 0xDF, 0x52, 0x81, 0x8F, 0xA5, 0x01, 0xA0, 0x22, 0x81, 0xAF, 0x85, 0x81, 0x5F, 0xD3, 0x81,
  0xBF, 0x85, 0x81, 0xBF, 0x93, 0x81, 0x9F, 0xB4, 0x03, 0xA0, 0x23, 0x05, 0xA8, 0x57, 0x11, 0x5E,
  0xF9, 0x50, 0xCE, 0x0B, 0x78, 0x48, 0xDF, 0xEB, 0x66,
  // "ū" (U+016B)
  0x40, 0x98, 0x02, 0xD5, 0x0D, 0xD0, 0xD7, 0x77, 0x68, 0x1D, 0xF4, 0x30, 0x1A, 0x81, 0x10, 0x1A,
  0x01, 0x38, 0x14, 0xFD, 0x28, 0x14, 0xFD, 0x48, 0x17, 0xFA, 0x28, 0x18, 0xFA, 0x48, 0x1B, 0xF7,
  0x28, 0x1B, 0xF7, 0x48, 0x1E, 0xF3, 0x28, 0x1E, 0xF3, 0x30, 0x2A, 0x20, 0x2A, 0x48, 0x15, 0xFD,
  0x28, 0x15, 0xFC, 0x48, 0x18, 0xF9, 0x28, 0x18, 0xF9, 0x48, 0x1C, 0xF6, 0x28, 0x1B, 0xF6, 0x30,
  0x1A, 0x03, 0x28, 0x1E, 0xF3, 0x30, 0x7A, 0x3A, 0x02, 0x28, 0x21, 0xEF, 0xC3, 0xA8, 0x56, 0x02,
  0xDE, 0xF9, 0x30, 0xBA, 0x84, 0xEF, 0xB8, 0xF6, 0x38, 0x71, 0xAE, 0xD8, 0x09, 0xF3, 0x30,
  // "Ŭ" (U+016C)
  0x58, 0x11, 0x71, 0x28, 0x11, 0x72, 0x68, 0x13, 0xF7, 0x28, 0x19, 0xF1, 0x68, 0x21, 0xEF, 0xEA,
  0x08, 0x71, 0x83, 0x4C, 0xED, 0x77, 0x77, 0x76, 0x81, 0xDF, 0x55, 0x81, 0x5F, 0xD3, 0xA0, 0x25,
  0x81, 0x8F, 0xA2, 0x81, 0x4F, 0xE6, 0x81, 0xCF, 0x72, 0x81, 0x7F, 0xB6, 0x81, 0xEF, 0x32, 0x81,
  0xAF, 0x85, 0x03, 0xA3, 0x81, 0xDF, 0x55, 0x81, 0x6F, 0xC2, 0x01, 0xA0, 0x25, 0x81, 0x9F, 0x92,
  0x81, 0x4F, 0xE6, 0x81, 0xCF, 0x62, 0x81, 0x8F, 0xB6, 0xA0, 0x32, 0x81, 0xBF, 0x75, 0x03, 0xA3,
  0x81, 0xEF, 0x45, 0x81, 0x7F, 0xC2, 0x02, 0xA0, 0x15, 0x81, 0xAF, 0x82, 0x81, 0x5F, 0xD6, 0x81,
  0xDF, 0x52, 0x81, 0x8F, 0xA5, 0x01, 0xA0, 0x22, 0x81, 0xAF, 0x85, 0x81, 0x5F, 0xD3, 0x81, 0xBF,
  0x85, 0x81, 0xBF, 0x93, 0x81, 0x9F, 0xB4, 0x03, 0xA0, 0x23, 0x05, 0xA8, 0x57, 0x11, 0x5E, 0xF9,
  0x50, 0xCE, 0x0B, 0x78, 0x48, 0xDF, 0xEB, 0x66,
  // "ŭ" (U+016D)
  0x48, 0x11, 0x71, 0x28, 0x11, 0x72, 0x48, 0x13, 0xF7, 0x28, 0x19, 0xF1, 0x48, 0x21, 0xEF, 0xEA,
  0x08, 0x68, 0x34, 0xCE, 0xD7, 0x77, 0x77, 0x81, 0xDF, 0x43, 0x01, 0xA8, 0x11, 0x01, 0xA0, 0x13,
  0x81, 0x4F, 0xD2, 0x81, 0x4F, 0xD4, 0x81, 0x7F, 0xA2, 0x81, 0x8F, 0xA4, 0x81, 0xBF, 0x72, 0x81,
  0xBF, 0x74, 0x81, 0xEF, 0x32, 0x81, 0xEF, 0x33, 0x02, 0xA2, 0x02, 0xA4, 0x81, 0x5F, 0xD2, 0x81,
  0x5F, 0xC4, 0x81, 0x8F, 0x92, 0x81, 0x8F, 0x94, 0x81, 0xCF, 0x62, 0x81, 0xBF, 0x63, 0x01, 0xA0,
  0x32, 0x81, 0xEF, 0x33, 0x07, 0xA3, 0xA0, 0x22, 0x82, 0x1E, 0xFC, 0x3A, 0x85, 0x60, 0x2D, 0xEF,
  0x93, 0x0B, 0xA8, 0x4E, 0xFB, 0x8F, 0x63, 0x87, 0x1A, 0xED, 0x80, 0x9F, 0x33,
  // "Ů" (U+016E)
  0x78, 0x33, 0xCE, 0xB2, 0x72, 0x83, 0xD9, 0x39, 0xD7, 0x10, 0x39, 0x28, 0x11, 0xF3, 0x78, 0x53,
  0xF4, 0x05, 0xF3, 0x71, 0x83, 0xEF, 0xEF, 0xD7, 0x28, 0x33, 0xCE, 0xC2, 0x77, 0x77, 0x58, 0x1D,
  0xF5, 0x58, 0x15, 0xFD, 0x3A, 0x02, 0x58, 0x18, 0xFA, 0x28, 0x14, 0xFE, 0x68, 0x1C, 0xF7, 0x28,
  0x17, 0xFB, 0x68, 0x1E, 0xF3, 0x28, 0x1A, 0xF8, 0x50, 0x3A, 0x38, 0x1D, 0xF5, 0x58, 0x16, 0xFC,
  0x20, 0x1A, 0x02, 0x58, 0x19, 0xF9, 0x28, 0x14, 0xFE, 0x68, 0x1C, 0xF6, 0x28, 0x18, 0xFB, 0x6A,
  0x03, 0x28, 0x1B, 0xF7, 0x50, 0x3A, 0x38, 0x1E, 0xF4, 0x58, 0x17, 0xFC, 0x20, 0x2A, 0x01, 0x58,
  0x1A, 0xF8, 0x28, 0x15, 0xFD, 0x68, 0x1D, 0xF5, 0x28, 0x18, 0xFA, 0x50, 0x1A, 0x02, 0x28, 0x1A,
  0xF8, 0x58, 0x15, 0xFD, 0x38, 0x1B, 0xF8, 0x58, 0x1B, 0xF9, 0x38, 0x19, 0xFB, 0x40, 0x3A, 0x02,
  0x30, 0x5A, 0x85, 0x71, 0x15, 0xEF, 0x95, 0x0C, 0xE0, 0xB7, 0x84, 0x8D, 0xFE, 0xB6, 0x60,
  // "ů" (U+016F)
  0x58, 0x33, 0xCE, 0xB2, 0x78, 0x3D, 0x93, 0x9D, 0x60, 0x39, 0x28, 0x11, 0xF3, 0x58, 0x53, 0xF4,
  0x05, 0xF3, 0x68, 0x3E, 0xFE, 0xFD, 0x78, 0x33, 0xCE, 0xC2, 0x77, 0x77, 0x81, 0xDF, 0x43, 0x01,
  0xA8, 0x11, 0x01, 0xA0, 0x13, 0x81, 0x4F, 0xD2, 0x81, 0x4F, 0xD4, 0x81, 0x7F, 0xA2, 0x81, 0x8F,
  0xA4, 0x81, 0xBF, 0x72, 0x81, 0xBF, 0x74, 0x81, 0xEF, 0x32, 0x81, 0xEF, 0x33, 0x02, 0xA2, 0x02,
  0xA4, 0x81, 0x5F, 0xD2, 0x81, 0x5F, 0xC4, 0x81, 0x8F, 0x92, 0x81, 0x8F, 0x94, 0x81, 0xCF, 0x62,
  0x81, 0xBF, 0x63, 0x01, 0xA0, 0x32, 0x81, 0xEF, 0x33, 0x07, 0xA3, 0xA0, 0x22, 0x82, 0x1E, 0xFC,
  0x3A, 0x85, 0x60, 0x2D, 0xEF, 0x93, 0x0B, 0xA8, 0x4E, 0xFB, 0x8F, 0x63, 0x87, 0x1A, 0xED, 0x80,
  0x9F, 0x33,
  // "Ű" (U+0170)
  0x71, 0x83, 0x5F, 0xE1, 0x3A, 0x03, 0x78, 0x62, 0xEE, 0x20, 0xDF, 0x47, 0x18, 0x5D, 0xD2, 0x0A,
  0xE4, 0x71, 0x85, 0xBB, 0x10, 0x8D, 0x28, 0x0C, 0x20, 0x81, 0xDF, 0x55, 0x81, 0x5F, 0xD5, 0xA0,
  0x25, 0x81, 0x8F, 0xA4, 0x81, 0x4F, 0xE6, 0x81, 0xCF, 0x74, 0x81, 0x7F, 0xB6, 0x81, 0xEF, 0x34,
  0x81, 0xAF, 0x85, 0x03, 0xA5, 0x81, 0xDF, 0x55, 0x81, 0x6F, 0xC4, 0x01, 0xA0, 0x25, 0x81, 0x9F,
  0x94, 0x81, 0x4F, 0xE6, 0x81, 0xCF, 0x64, 0x81, 0x8F, 0xB6, 0xA0, 0x34, 0x81, 0xBF, 0x75, 0x03,
  0xA5, 0x81, 0xEF, 0x45, 0x81, 0x7F, 0xC4, 0x02, 0xA0, 0x15, 0x81, 0xAF, 0x84, 0x81, 0x5F, 0xD6,
  0x81, 0xDF, 0x54, 0x81, 0x8F, 0xA5, 0x01, 0xA0, 0x24, 0x81, 0xAF, 0x85, 0x81, 0x5F, 0xD5, 0x81,
  0xBF, 0x85, 0x81, 0xBF, 0x95, 0x81, 0x9F, 0xB4, 0x03, 0xA0, 0x25, 0x05, 0xA8, 0x57, 0x11, 0x5E,
  0xF9, 0x70, 0xCE, 0x0B, 0x72, 0x84, 0x8D, 0xFE, 0xB6, 0x71,
  // "ű" (U+0171)
  0x68, 0x35, 0xFE, 0x13, 0xA0, 0x35, 0x86, 0x2E, 0xE2, 0x0D, 0xF4, 0x68, 0x5D, 0xD2, 0x0A, 0xE4,
  0x68, 0x5B, 0xB1, 0x08, 0xD2, 0x77, 0x77, 0x58, 0x1D, 0xF4, 0x30, 0x1A, 0x01, 0x30, 0x1A, 0x01,
  0x38, 0x14, 0xFD, 0x48, 0x14, 0xFD, 0x48, 0x17, 0xFA, 0x48, 0x18, 0xFA, 0x48, 0x1B, 0xF7, 0x48,
  0x1B, 0xF7, 0x48, 0x1E, 0xF3, 0x48, 0x1E, 0xF3, 0x30, 0x2A, 0x40, 0x2A, 0x48, 0x15, 0xFD, 0x48,
  0x15, 0xFC, 0x48, 0x18, 0xF9, 0x48, 0x18, 0xF9, 0x48, 0x1C, 0xF6, 0x48, 0x1B, 0xF6, 0x30, 0x1A,
  0x03, 0x48, 0x1E, 0xF3, 0x30, 0x7A, 0x5A, 0x02, 0x28, 0x21, 0xEF, 0xC5, 0xA8, 0x56, 0x02, 0xDE,
  0xF9, 0x50, 0xBA, 0x84, 0xEF, 0xB8, 0xF6, 0x58, 0x71, 0xAE, 0xD8, 0x09, 0xF3, 0x50,
  // "Ų" (U+0172)
  0x38, 0x1D, 0xF5, 0x58, 0x15, 0xFD, 0x3A, 0x02, 0x58, 0x18, 0xFA, 0x28, 0x14, 0xFE, 0x68, 0x1C,
  0xF7, 0x28, 0x17, 0xFB, 0x68, 0x1E, 0xF3, 0x28, 0x1A, 0xF8, 0x50, 0x3A, 0x38, 0x1D, 0xF5, 0x58,
  0x16, 0xFC, 0x20, 0x1A, 0x02, 0x58, 0x19, 0xF9, 0x28, 0x14, 0xFE, 0x68, 0x1C, 0xF6, 0x28, 0x18,
  0xFB, 0x6A, 0x03, 0x28, 0x1B, 0xF7, 0x50, 0x3A, 0x38, 0x1E, 0xF4, 0x58, 0x17, 0xFC, 0x20, 0x2A,
  0x01, 0x58, 0x1A, 0xF8, 0x28, 0x15, 0xFD, 0x68, 0x1D, 0xF5, 0x28, 0x18, 0xFA, 0x50, 0x1A, 0x02,
  0x28, 0x1A, 0xF8, 0x58, 0x15, 0xFD, 0x38, 0x1B, 0xF8, 0x58, 0x1B, 0xF9, 0x38, 0x19, 0xFB, 0x40,
  0x3A, 0x02, 0x30, 0x5A, 0x85, 0x71, 0x15, 0xEF, 0x95, 0x0C, 0xE0, 0xB7, 0x84, 0x8D, 0xFE, 0xB6,
  0x72, 0x81, 0x3D, 0x67, 0x38, 0x13, 0xE7, 0x74, 0x00, 0xD7, 0x48, 0x12, 0xFC, 0x74, 0x02, 0xA0,
  0xE0, 0x77, 0x38, 0x28, 0xEE, 0x47, 0x10,
  // "ų" (U+0173)
  0x28, 0x1D, 0xF4, 0x30, 0x1A, 0x81, 0x10, 0x1A, 0x01, 0x38, 0x14, 0xFD, 0x28, 0x14, 0xFD, 0x48,
  0x17, 0xFA, 0x28, 0x18, 0xFA, 0x48, 0x1B, 0xF7, 0x28, 0x1B, 0xF7, 0x48, 0x1E, 0xF3, 0x28, 0x1E,
  0xF3, 0x30, 0x2A, 0x20, 0x2A, 0x48, 0x15, 0xFD, 0x28, 0x15, 0xFC, 0x48, 0x18, 0xF9, 0x28, 0x18,
  0xF9, 0x48, 0x1C, 0xF6, 0x28, 0x1B, 0xF6, 0x30, 0x1A, 0x03, 0x28, 0x1E, 0xF3, 0x30, 0x7A, 0x3A,
  0x02, 0x28, 0x21, 0xEF, 0xC3, 0xA8, 0x56, 0x02, 0xDE, 0xF9, 0x30, 0xBA, 0x84, 0xEF, 0xB8, 0xF6,
  0x38, 0x71, 0xAE, 0xD8, 0x09, 0xF3, 0x71, 0x81, 0x3D, 0x67, 0x18, 0x13, 0xE7, 0x72, 0x00, 0xD7,
  0x28, 0x12, 0xFC, 0x72, 0x02, 0xA0, 0xE0, 0x77, 0x18, 0x28, 0xEE, 0x44,
  // "Ŵ" (U+0174)
  0x72, 0x81, 0x57, 0x47, 0x72, 0x03, 0xA0, 0xC7, 0x71, 0x84, 0x1E, 0xEC, 0xF2, 0x77, 0x84, 0xCD,
  0x23, 0xF9, 0x76, 0x81, 0xBC, 0x12, 0x81, 0x7F, 0x18, 0x0D, 0x20, 0x81, 0x7F, 0xA5, 0x04, 0xA5,
  0x01, 0xA8, 0x24, 0x7F, 0xA5, 0x0A, 0xA5, 0x85, 0x6F, 0xD0, 0x7F, 0xA4, 0x01, 0xB5, 0x85, 0xCF,
  0x70, 0x7F, 0xA4, 0x07, 0xB4, 0x03, 0xA8, 0x31, 0x07, 0xFA, 0x48, 0x1D, 0xFD, 0x94, 0x81, 0x9F,
  0xA2, 0x81, 0x7F, 0x93, 0x82, 0x3F, 0xAD, 0x94, 0x81, 0xEF, 0x42, 0x81, 0x7F, 0x93, 0x82, 0x9F,
  0x4D, 0x93, 0x81, 0x5F, 0xD3, 0x81, 0x8F, 0x92, 0x83, 0x1F, 0xD0, 0xD9, 0x38, 0x1B, 0xF7, 0x38,
  0x18, 0xF9, 0x28, 0x36, 0xF7, 0x0D, 0x92, 0x02, 0xA0, 0x13, 0x81, 0x8F, 0x92, 0x84, 0xCF, 0x10,
  0xEE, 0x28, 0x18, 0xFA, 0x48, 0x58, 0xF9, 0x03, 0xFB, 0x20, 0x0E, 0x28, 0x1D, 0xF4, 0x48, 0x58,
  0xF8, 0x09, 0xF5, 0x28, 0x4E, 0xE0, 0x4F, 0xD5, 0x84, 0x8F, 0x80, 0xEE, 0x38, 0x4E, 0xE0, 0xAF,
  0x75, 0x84, 0x8F, 0x86, 0xF8, 0x38, 0x1E, 0xD1, 0xA0, 0x15, 0x84, 0x8F, 0x7C, 0xF2, 0x39, 0x82,
  0xD6, 0xFA, 0x68, 0x38, 0xF8, 0xFB, 0x49, 0x82, 0xDB, 0xF4, 0x68, 0x38, 0xFD, 0xF5, 0x49, 0x81,
  0xEF, 0xD7, 0x08, 0xA0, 0xE5, 0xB0, 0x77, 0x08, 0xA0, 0x85, 0xB0, 0x17, 0x08, 0xA0, 0x25, 0xA0,
  0xA7, 0x10,
  // "ŵ" (U+0175)
  0x71, 0x81, 0x57, 0x47, 0x60, 0x3A, 0x0C, 0x75, 0x84, 0x1E, 0xEC, 0xF2, 0x74, 0x84, 0xCD, 0x23,
  0xF9, 0x73, 0x81, 0xBC, 0x12, 0x81, 0x7F, 0x18, 0x0C, 0x20, 0x81, 0x5F, 0xB4, 0x81, 0xEF, 0xA3,
  0x01, 0xA8, 0x22, 0x5F, 0xB3, 0x05, 0xA0, 0xA3, 0x85, 0x7F, 0xB0, 0x5F, 0xB3, 0x0B, 0xA0, 0xA3,
  0x85, 0xDF, 0x40, 0x5F, 0xB2, 0x83, 0x2F, 0xBF, 0xA2, 0x81, 0x3F, 0xD2, 0x81, 0x5F, 0xB2, 0x83,
  0x8F, 0x6F, 0x92, 0x81, 0x9F, 0x72, 0x81, 0x5F, 0xB2, 0x83, 0xED, 0x2F, 0x92, 0x81, 0xEF, 0x12,
  0x89, 0x45, 0xFA, 0x05, 0xF7, 0x2F, 0x90, 0x6F, 0xA3, 0x89, 0x45, 0xFA, 0x0B, 0xF1, 0x3F, 0x90,
  0xCF, 0x43, 0x89, 0x35, 0xFA, 0x2F, 0xA0, 0x3F, 0x92, 0xFD, 0x48, 0x93, 0x5F, 0x98, 0xF4, 0x03,
  0xF8, 0x8F, 0x74, 0x83, 0x5F, 0x9D, 0xD2, 0x84, 0x3F, 0x8D, 0xF1, 0x48, 0x35, 0xFC, 0xF8, 0x28,
  0x34, 0xFB, 0xFA, 0x50, 0x5B, 0x02, 0x20, 0x4B, 0x04, 0x50, 0x5A, 0x0B, 0x30, 0x4A, 0x0D, 0x60,
  0x5A, 0x05, 0x30, 0x4A, 0x07, 0x60,
  // "Ŷ" (U+0176)
  0x58, 0x15, 0x74, 0x70, 0x3A, 0x0C, 0x68, 0x41, 0xEE, 0xCF, 0x25, 0x84, 0xCD, 0x23, 0xF9, 0x48,
  0x1B, 0xC1, 0x28, 0x17, 0xF1, 0x77, 0x72, 0x81, 0x9F, 0xA5, 0x84, 0x7F, 0xE6, 0xFC, 0x58, 0x4E,
  0xF6, 0x4F, 0xE4, 0x83, 0x7F, 0xD0, 0x2A, 0x01, 0x28, 0x21, 0xEF, 0x42, 0xA0, 0x32, 0x81, 0x8F,
  0xB3, 0x83, 0xDF, 0x40, 0x1A, 0x03, 0x38, 0x5B, 0xF6, 0x09, 0xF9, 0x48, 0x28, 0xF8, 0x2A, 0x01,
  0x48, 0x46, 0xFA, 0x9F, 0x85, 0x83, 0x4F, 0xEF, 0xE6, 0x01, 0xB0, 0x67, 0xA0, 0xD7, 0x18, 0x1D,
  0xF6, 0x70, 0x1A, 0x02, 0x78, 0x14, 0xFE, 0x71, 0x81, 0x7F, 0xB7, 0x18, 0x1A, 0xF8, 0x71, 0x81,
  0xDF, 0x57, 0x01, 0xA0, 0x27, 0x81, 0x4F, 0xE7, 0x10,
  // "ŷ" (U+0177)
  0x72, 0x81, 0x57, 0x47, 0x40, 0x3A, 0x0C, 0x73, 0x84, 0x1E, 0xEC, 0xF2, 0x72, 0x84, 0xCD, 0x23,
  0xF9, 0x71, 0x81, 0xBC, 0x12, 0x81, 0x7F, 0x17, 0x77, 0x77, 0x81, 0x5F, 0xC5, 0x81, 0xDF, 0x54,
  0x81, 0x4F, 0xD4, 0x81, 0x5F, 0xD5, 0x81, 0x3F, 0xD4, 0x81, 0xCF, 0x65, 0x81, 0x2F, 0xE3, 0x81,
  0x4F, 0xE6, 0x81, 0x1F, 0xE3, 0x81, 0xBF, 0x77, 0xA2, 0x81, 0x2F, 0xE7, 0x1A, 0x28, 0x19, 0xF8,
  0x71, 0x82, 0xEF, 0x11, 0xA0, 0x17, 0x18, 0x4D, 0xF1, 0x8F, 0x97, 0x28, 0x4C, 0xF2, 0xEF, 0x27,
  0x28, 0x3B, 0xF7, 0xF9, 0x73, 0x83, 0xAF, 0xCF, 0x27, 0x30, 0x9A, 0x0A, 0x74, 0x08, 0xA0, 0x37,
  0x48, 0x18, 0xFB, 0x75, 0x81, 0xDF, 0x47, 0x48, 0x15, 0xFC, 0x75, 0x81, 0xDF, 0x57, 0x48, 0x1A,
  0xFB, 0x72, 0x06, 0x0E, 0xA0, 0xE0, 0x17, 0x28, 0x36, 0xEE, 0xB2, 0x73,
  // "Ÿ" (U+0178)
  0x38, 0x55, 0xC2, 0x02, 0xB6, 0x48, 0x5D, 0xF5, 0x09, 0xFA, 0x40, 0xB0, 0xC2, 0x81, 0x7E, 0x37,
  0x77, 0x28, 0x19, 0xFA, 0x58, 0x47, 0xFE, 0x6F, 0xC5, 0x84, 0xEF, 0x64, 0xFE, 0x48, 0x37, 0xFD,
  0x02, 0xA0, 0x12, 0x82, 0x1E, 0xF4, 0x2A, 0x03, 0x28, 0x18, 0xFB, 0x38, 0x3D, 0xF4, 0x01, 0xA0,
  0x33, 0x85, 0xBF, 0x60, 0x9F, 0x94, 0x82, 0x8F, 0x82, 0xA0, 0x14, 0x84, 0x6F, 0xA9, 0xF8, 0x58,
  0x34, 0xFE, 0xFE, 0x60, 0x1B, 0x06, 0x7A, 0x0D, 0x71, 0x81, 0xDF, 0x67, 0x01, 0xA0, 0x27, 0x81,
  0x4F, 0xE7, 0x18, 0x17, 0xFB, 0x71, 0x81, 0xAF, 0x87, 0x18, 0x1D, 0xF5, 0x70, 0x1A, 0x02, 0x78,
  0x14, 0xFE, 0x71,
  // "Ź" (U+0179)
  0x74, 0x81, 0x77, 0x47, 0x38, 0x28, 0xFD, 0x17, 0x28, 0x24, 0xFE, 0x27, 0x28, 0x21, 0xEE, 0x27,
  0x38, 0x1B, 0xD2, 0x77, 0x77, 0x70, 0xBF, 0x95, 0x0C, 0x80, 0x1D, 0xA0, 0xD7, 0x30, 0x3A, 0x06,
  0x73, 0x81, 0xCF, 0xC7, 0x30, 0x6A, 0x03, 0x72, 0x82, 0x1E, 0xF9, 0x73, 0x82, 0x8F, 0xE1, 0x72,
  0x02, 0xA0, 0x67, 0x38, 0x1B, 0xFC, 0x73, 0x05, 0xA0, 0x37, 0x38, 0x1D, 0xF9, 0x73, 0x82, 0x8F,
  0xE1, 0x72, 0x02, 0xA0, 0x77, 0x38, 0x1B, 0xFC, 0x73, 0x04, 0xA0, 0x47, 0x38, 0x1D, 0xFA, 0x73,
  0x82, 0x7F, 0xE1, 0x72, 0x82, 0x1E, 0xF7, 0x73, 0x08, 0xA0, 0xE8, 0x01, 0xD0, 0x84, 0x0B, 0xF9,
  0x06, 0x40,
  // "ź" (U+017A)
  0x72, 0x81, 0x77, 0x47, 0x18, 0x28, 0xFD, 0x17, 0x82, 0x4F, 0xE2, 0x78, 0x21, 0xEE, 0x27, 0x18,
  0x1B, 0xD2, 0x77, 0x77, 0x20, 0x8E, 0x05, 0x48, 0x3A, 0xDD, 0xDE, 0xA0, 0x27, 0x18, 0x1A, 0xF9,
  0x71, 0x82, 0x4F, 0xE1, 0x71, 0x81, 0xDF, 0x57, 0x18, 0x18, 0xFB, 0x71, 0x02, 0xA0, 0x27, 0x18,
  0x1B, 0xF8, 0x71, 0x81, 0x6F, 0xD7, 0x18, 0x21, 0xEF, 0x47, 0x18, 0x19, 0xFA, 0x71, 0x82, 0x3F,
  0xE1, 0x71, 0x81, 0xDF, 0x67, 0x10, 0x6A, 0x80, 0x0D, 0x0C, 0x40, 0xAE, 0x0B, 0x40,
  // "Ż" (U+017B)
  0x71, 0x81, 0x2D, 0xC7, 0x30, 0x8A, 0x73, 0x81, 0x5E, 0x87, 0x77, 0x74, 0x0B, 0xF9, 0x40, 0xC8,
  0x01, 0xDA, 0x0D, 0x72, 0x03, 0xA0, 0x67, 0x28, 0x1C, 0xFC, 0x72, 0x06, 0xA0, 0x37, 0x18, 0x21,
  0xEF, 0x97, 0x28, 0x28, 0xFE, 0x17, 0x10, 0x2A, 0x06, 0x72, 0x81, 0xBF, 0xC7, 0x20, 0x5A, 0x03,
  0x72, 0x81, 0xDF, 0x97, 0x28, 0x28, 0xFE, 0x17, 0x10, 0x2A, 0x07, 0x72, 0x81, 0xBF, 0xC7, 0x20,
  0x4A, 0x04, 0x72, 0x81, 0xDF, 0xA7, 0x28, 0x27, 0xFE, 0x17, 0x18, 0x21, 0xEF, 0x77, 0x20, 0x8A,
  0x0E, 0x80, 0x1D, 0x08, 0x30, 0xBF, 0x90, 0x63,
  // "ż" (U+017C)
  0x68, 0x12, 0xDC, 0x71, 0x08, 0xA7, 0x18, 0x15, 0xE8, 0x77, 0x76, 0x08, 0xE0, 0x53, 0x83, 0xAD,
  0xDD, 0xEA, 0x02, 0x78, 0x1A, 0xF9, 0x78, 0x24, 0xFE, 0x17, 0x81, 0xDF, 0x57, 0x81, 0x8F, 0xB7,
  0x02, 0xA0, 0x27, 0x81, 0xBF, 0x87, 0x81, 0x6F, 0xD7, 0x82, 0x1E, 0xF4, 0x78, 0x19, 0xFA, 0x78,
  0x23, 0xFE, 0x17, 0x81, 0xDF, 0x67, 0x06, 0xA8, 0x00, 0xD0, 0xC3, 0x0A, 0xE0, 0xB3,
  // "Ž" (U+017D)
  0x60, 0x70, 0x33, 0x04, 0x07, 0x60, 0xB0, 0xD2, 0x81, 0x7F, 0x56, 0x84, 0x5F, 0x87, 0xF7, 0x71,
  0x0E, 0xA0, 0xA7, 0x28, 0x18, 0xFD, 0x77, 0x77, 0x50, 0xBF, 0x94, 0x0C, 0x80, 0x1D, 0xA0, 0xD7,
  0x20, 0x3A, 0x06, 0x72, 0x81, 0xCF, 0xC7, 0x20, 0x6A, 0x03, 0x71, 0x82, 0x1E, 0xF9, 0x72, 0x82,
  0x8F, 0xE1, 0x71, 0x02, 0xA0, 0x67, 0x28, 0x1B, 0xFC, 0x72, 0x05, 0xA0, 0x37, 0x28, 0x1D, 0xF9,
  0x72, 0x82, 0x8F, 0xE1, 0x71, 0x02, 0xA0, 0x77, 0x28, 0x1B, 0xFC, 0x72, 0x04, 0xA0, 0x47, 0x28,
  0x1D, 0xFA, 0x72, 0x82, 0x7F, 0xE1, 0x71, 0x82, 0x1E, 0xF7, 0x72, 0x08, 0xA0, 0xE8, 0x01, 0xD0,
  0x83, 0x0B, 0xF9, 0x06, 0x30,
  // "ž" (U+017E)
  0x50, 0x70, 0x33, 0x04, 0x07, 0x50, 0xB0, 0xD2, 0x81, 0x7F, 0x55, 0x84, 0x5F, 0x87, 0xF7, 0x70,
  0xEA, 0x0A, 0x71, 0x81, 0x8F, 0xD7, 0x77, 0x72, 0x08, 0xE0, 0x54, 0x83, 0xAD, 0xDD, 0xEA, 0x02,
  0x71, 0x81, 0xAF, 0x97, 0x18, 0x24, 0xFE, 0x17, 0x18, 0x1D, 0xF5, 0x71, 0x81, 0x8F, 0xB7, 0x10,
  0x2A, 0x02, 0x71, 0x81, 0xBF, 0x87, 0x18, 0x16, 0xFD, 0x71, 0x82, 0x1E, 0xF4, 0x71, 0x81, 0x9F,
  0xA7, 0x18, 0x23, 0xFE, 0x17, 0x18, 0x1D, 0xF6, 0x71, 0x06, 0xA8, 0x00, 0xD0, 0xC4, 0x0A, 0xE0,
  0xB4,
  // "ſ" (U+017F)
  0x72, 0x83, 0x5C, 0xFE, 0x87, 0x10, 0x3A, 0x81, 0xEF, 0x77, 0x18, 0x4B, 0xFA, 0x01, 0x17, 0x01,
  0xA0, 0x17, 0x38, 0x15, 0xFC, 0x74, 0x81, 0x9F, 0x97, 0x48, 0x1C, 0xF5, 0x74, 0xA0, 0x27, 0x38,
  0x13, 0xFE, 0x74, 0x81, 0x7F, 0xB7, 0x48, 0x1A, 0xF7, 0x74, 0x81, 0xDF, 0x47, 0x30, 0x1A, 0x01,
  0x73, 0x81, 0x5F, 0xD7, 0x48, 0x18, 0xFA, 0x74, 0x81, 0xBF, 0x67, 0x48, 0x1E, 0xF3, 0x73, 0x02,
  0xA7, 0x48, 0x16, 0xFC, 0x74, 0x81, 0x9F, 0x97, 0x48, 0x1C, 0xF5, 0x74, 0xA0, 0x27, 0x38, 0x14,
  0xFE, 0x74, 0x81, 0x8F, 0x97, 0x38, 0x22, 0xEF, 0x47, 0x10, 0x80, 0xEA, 0x0B, 0x72, 0x83, 0x6E,
  0xEA, 0x17, 0x20,
  // "Ω" (U+03A9)
  0x78, 0x52, 0x9D, 0xFD, 0xA3, 0x71, 0x05, 0xB0, 0xEB, 0x05, 0x60, 0x5A, 0x86, 0x81, 0x01, 0xAF,
  0xE1, 0x48, 0x22, 0xEF, 0x74, 0x82, 0x1E, 0xF7, 0x48, 0x1A, 0xFB, 0x68, 0x1A, 0xFB, 0x30, 0x3A,
  0x04, 0x68, 0x18, 0xFC, 0x38, 0x18, 0xFD, 0x78, 0x17, 0xFD, 0x38, 0x1D, 0xF8, 0x78, 0x18, 0xFC,
  0x20, 0x2A, 0x04, 0x78, 0x1A, 0xFA, 0x20, 0x5A, 0x71, 0x81, 0xDF, 0x72, 0x81, 0x6F, 0xD7, 0x01,
  0xA0, 0x42, 0x81, 0x7F, 0xC7, 0x81, 0x6F, 0xE3, 0x81, 0x8F, 0xB7, 0x81, 0xBF, 0x93, 0x81, 0x7F,
  0xC6, 0x03, 0xA0, 0x23, 0x81, 0x4F, 0xD6, 0x81, 0xBF, 0x94, 0x01, 0xA0, 0x14, 0x82, 0x6F, 0xE1,
  0x58, 0x1A, 0xF6, 0x38, 0x22, 0xEF, 0x46, 0x81, 0x2F, 0xD2, 0x82, 0x2E, 0xF5, 0x40, 0x60, 0xFD,
  0xA8, 0x15, 0x0C, 0xA0, 0xFD, 0x81, 0x40, 0xAD, 0x01, 0x1E, 0x02, 0x10,
  // "μ" (U+03BC)
  0x48, 0x1D, 0xF4, 0x4A, 0x01, 0x4A, 0x01, 0x38, 0x13, 0xFD, 0x48, 0x14, 0xFE, 0x48, 0x17, 0xFA,
  0x48, 0x17, 0xFA, 0x48, 0x1A, 0xF7, 0x48, 0x1A, 0xF7, 0x48, 0x1D, 0xF4, 0x48, 0x1D, 0xF4, 0x30,
  0x1A, 0x01, 0x30, 0x1A, 0x01, 0x38, 0x14, 0xFD, 0x48, 0x14, 0xFD, 0x48, 0x17, 0xFA, 0x48, 0x18,
  0xFA, 0x48, 0x1B, 0xF7, 0x48, 0x1B, 0xF7, 0x30, 0x1A, 0x04, 0x48, 0x1E, 0xF4, 0x30, 0x6A, 0x01,
  0x30, 0x2A, 0x03, 0x28, 0x21, 0xEF, 0xD4, 0x05, 0xA8, 0x58, 0x02, 0xCE, 0xFA, 0x40, 0x9D, 0x82,
  0xD8, 0xF7, 0x48, 0x90, 0xCF, 0x8D, 0xEA, 0x18, 0xF3, 0x4A, 0x02, 0x73, 0x81, 0x3F, 0xE7, 0x48,
  0x16, 0xFB, 0x74, 0x81, 0x9F, 0x87, 0x48, 0x1D, 0xF4, 0x74, 0xA0, 0x17, 0x40,
  // "π" (U+03C0)
  0x10, 0x20, 0xAF, 0xB8, 0x2B, 0x0B, 0xDA, 0x0E, 0x0F, 0xDA, 0x81, 0xED, 0x73, 0x81, 0xCF, 0x53,
  0x81, 0xEF, 0x35, 0xA0, 0x12, 0x02, 0xA5, 0x81, 0x3F, 0xE3, 0x81, 0x5F, 0xC5, 0x81, 0x7F, 0xB3,
  0x81, 0x8F, 0x95, 0x81, 0xAF, 0x73, 0x81, 0xBF, 0x65, 0x81, 0xDF, 0x43, 0x81, 0xEF, 0x34, 0x01,
  0xA0, 0x12, 0x02, 0xA5, 0x81, 0x4F, 0xD3, 0x81, 0x6F, 0xC5, 0x81, 0x7F, 0xA3, 0x81, 0x9F, 0x85,
  0x81, 0xAF, 0x73, 0x81, 0xBF, 0x65, 0x81, 0xDF, 0x43, 0x81, 0xDF, 0x64, 0x01, 0xA0, 0x13, 0x0B,
  0xA0, 0xE3, 0x81, 0x4F, 0xD4, 0x82, 0x3C, 0xFC, 0x30,
  // "–" (U+2013)
  0x18, 0x06, 0xD0, 0x70, 0x3F, 0xB0, 0x50,
  // "—" (U+2014)
  0x18, 0x0A, 0x3D, 0x03, 0xFF, 0xF9, 0x0C,
  // "€" (U+20AC)
  0x78, 0x54, 0xBE, 0xEC, 0x71, 0x60, 0xAB, 0x0E, 0xA0, 0x25, 0x82, 0xAF, 0xD4, 0x20, 0x30, 0x65,
  0x82, 0x6F, 0xE2, 0x73, 0x81, 0xDF, 0x57, 0x38, 0x16, 0xFD, 0x74, 0x81, 0xCF, 0x67, 0x20, 0x90,
  0xDA, 0x83, 0xED, 0xDD, 0x85, 0x0D, 0xF0, 0x76, 0x81, 0x8F, 0xA7, 0x48, 0x1B, 0xF7, 0x72, 0x07,
  0x0D, 0xA8, 0x3E, 0xDD, 0xD3, 0x50, 0xAF, 0x01, 0x78, 0x1E, 0xF3, 0x74, 0x81, 0xDF, 0x47, 0x48,
  0x1C, 0xF6, 0x74, 0x81, 0x9F, 0xA7, 0x40, 0x4A, 0x05, 0x20, 0x20, 0x47, 0x0B, 0xA8, 0x2E, 0xEF,
  0xB7, 0x18, 0x48, 0xDF, 0xDB, 0x54,
  // "₿" (U+20BF)
  0x68, 0x31, 0x71, 0x36, 0x78, 0x35, 0xE0, 0x9A, 0x78, 0x38, 0xB0, 0xD6, 0x50, 0xAB, 0x81, 0xEF,
  0x55, 0x82, 0xDF, 0xEE, 0xB0, 0x33, 0x01, 0xA8, 0x41, 0x02, 0xDF, 0xB3, 0x81, 0x4F, 0xE3, 0x07,
  0xA3, 0x81, 0x7F, 0xB3, 0x05, 0xA3, 0x81, 0xBF, 0x83, 0x81, 0x7F, 0xD3, 0x81, 0xEF, 0x53, 0x81,
  0xAF, 0xA2, 0x01, 0xA0, 0x22, 0x02, 0xA0, 0x42, 0x05, 0xA2, 0x82, 0x4D, 0xFA, 0x30, 0x8D, 0x0E,
  0x07, 0x48, 0x2B, 0xFE, 0xDA, 0x0D, 0x04, 0x48, 0x1E, 0xF5, 0x28, 0x28, 0xFE, 0x12, 0x02, 0xA0,
  0x23, 0x81, 0xEF, 0x62, 0x81, 0x5F, 0xE4, 0x81, 0xBF, 0x82, 0x81, 0x8F, 0xB4, 0x81, 0xDF, 0x72,
  0x81, 0xBF, 0x83, 0x01, 0xA0, 0x52, 0x81, 0xEF, 0x43, 0x81, 0x8F, 0xE2, 0x02, 0xA0, 0x12, 0x06,
  0xA0, 0x62, 0x05, 0xA0, 0xD0, 0xEB, 0x07, 0x30, 0x8D, 0x09, 0x02, 0x68, 0x3D, 0x52, 0xF1, 0x68,
  0x32, 0xF2, 0x6D, 0x78, 0x32, 0x70, 0x45, 0x60,
  // "‘" (U+2018)
  0x38, 0x17, 0xF3, 0x28, 0x11, 0xEC, 0x38, 0x1A, 0xF6, 0x28, 0x12, 0xFE, 0x38, 0x1A, 0xF9, 0x20,
  0x2A, 0x03, 0x28, 0x13, 0x77, 0x30,
  // "’" (U+2019)
  0x20, 0x2A, 0x04, 0x28, 0x17, 0xFD, 0x38, 0x1D, 0xF5, 0x28, 0x13, 0xFD, 0x38, 0x1A, 0xF5, 0x28,
  0x11, 0xFB, 0x38, 0x13, 0x72, 0x30,
  // "‚" (U+201A)
  0x38, 0x16, 0x74, 0x20, 0x1A, 0x05, 0x28, 0x16, 0xFD, 0x38, 0x1C, 0xF5, 0x28, 0x13, 0xFD, 0x38,
  0x19, 0xF4, 0x28, 0x11, 0xFB, 0x30,
  // "‛" (U+201B)
  0x05, 0xA8, 0x97, 0x4F, 0xE3, 0xFE, 0x2F, 0xE0, 0xFE, 0x0D, 0xE0, 0xB9,
  // "“" (U+201C)
  0x38, 0x56, 0xF4, 0x01, 0xEB, 0x28, 0x11, 0xED, 0x28, 0x18, 0xF5, 0x28, 0x58, 0xF7, 0x01, 0xFE,
  0x38, 0x5E, 0xF2, 0x08, 0xF8, 0x28, 0x67, 0xFB, 0x01, 0xEF, 0x32, 0x85, 0xDF, 0x60, 0x7F, 0xD2,
  0x04, 0xA8, 0x31, 0x0D, 0xF8, 0x20,
  // "”" (U+201D)
  0x20, 0x2A, 0x83, 0x30, 0xBF, 0xA2, 0x83, 0x7F, 0xD0, 0x1A, 0x04, 0x28, 0x5C, 0xF6, 0x06, 0xFD,
  0x28, 0x12, 0xFE, 0x28, 0x1B, 0xF6, 0x28, 0x58, 0xF7, 0x02, 0xFD, 0x30, 0xE0, 0xD2, 0x81, 0x8F,
  0x52, 0x81, 0x5F, 0x62, 0x0E, 0x0C, 0x30,
  // "„" (U+201E)
  0x20, 0x3A, 0x83, 0x20, 0xDF, 0x82, 0x83, 0x8F, 0xB0, 0x2A, 0x02, 0x28, 0x5D, 0xF4, 0x08, 0xFB,
  0x28, 0x14, 0xFD, 0x28, 0x1D, 0xF4, 0x28, 0x5A, 0xF5, 0x03, 0xFB, 0x28, 0x11, 0xFC, 0x28, 0x19,
  0xF3, 0x28, 0x56, 0xF4, 0x01, 0xEB, 0x30,
  // "‟" (U+201F)
  0x04, 0xA0, 0x11, 0xA0, 0x40, 0x3A, 0x2A, 0x04, 0x02, 0xA2, 0x82, 0xEF, 0x41, 0xA2, 0x83, 0xCF,
  0x30, 0xE9, 0x28, 0xA1, 0xAF, 0x40, 0xBF, 0x10, 0x8F, 0x40, 0x9F, 0x10, 0x5F, 0x50,
  // "†" (U+2020)
  0x5A, 0x04, 0x60, 0x1A, 0x78, 0x13, 0xFB, 0x78, 0x15, 0xF6, 0x78, 0x17, 0xF2, 0x38, 0x91, 0x17,
  0x54, 0xAE, 0x45, 0x63, 0x4F, 0x98, 0x91, 0x43, 0x76, 0x5F, 0x95, 0x68, 0x13, 0x81, 0x3F, 0x47,
  0x81, 0x7F, 0x17, 0x0B, 0x0E, 0x71, 0x0E, 0x0B, 0x78, 0x13, 0xF8, 0x78, 0x17, 0xF6, 0x78, 0x1B,
  0xF3, 0x70, 0xE9, 0x78, 0x13, 0xFD, 0x78, 0x16, 0xFA, 0x78, 0x1A, 0xF7, 0x78, 0x1E, 0xF5, 0x60,
  0x2A, 0x02, 0x60,
  // "‡" (U+2021)
  0x7A, 0x05, 0x71, 0x01, 0xA7, 0x28, 0x13, 0xFB, 0x72, 0x81, 0x4F, 0x67, 0x28, 0x16, 0xF2, 0x58,
  0x90, 0x2E, 0xDC, 0xDF, 0xBC, 0xE8, 0x28, 0x90, 0x5F, 0xDC, 0xFE, 0xDE, 0xF5, 0x58, 0x11, 0xF7,
  0x72, 0x81, 0x5F, 0x67, 0x28, 0x1A, 0xF4, 0x72, 0x81, 0xEF, 0x27, 0x18, 0x11, 0xFD, 0x72, 0x81,
  0x3F, 0x87, 0x28, 0x15, 0xF4, 0x68, 0x7D, 0xCB, 0xCF, 0xAB, 0xC8, 0x20, 0x4A, 0x82, 0xDE, 0xED,
  0xA0, 0x66, 0x0E, 0x09, 0x20, 0x16, 0x81, 0x3F, 0x77, 0x28, 0x18, 0xF5, 0x72, 0x81, 0xDF, 0x37,
  0x10, 0x2A, 0x02, 0x60,
  // "•" (U+2022)
  0x18, 0x57, 0xDE, 0xB3, 0x07, 0xC8, 0x1E, 0x0C, 0xD0, 0x40, 0xDD, 0x06, 0x0C, 0xD0, 0x40, 0x6C,
  0x0D, 0x28, 0x37, 0xDE, 0xB2, 0x10,
  // "…" (U+2026)
  0x82, 0x2C, 0xE2, 0x28, 0x22, 0xCE, 0x22, 0x83, 0x2C, 0xE2, 0x8A, 0x04, 0x20, 0x8A, 0x04, 0x20,
  0x8A, 0x82, 0x46, 0xEA, 0x38, 0x16, 0xEA, 0x38, 0x16, 0xEA, 0x10,
  // "‰" (U+2030)
  0x38, 0x25, 0xDE, 0x95, 0x81, 0x4F, 0x77, 0x40, 0x5C, 0x05, 0x40, 0xD0, 0xE7, 0x58, 0x4E, 0xE2,
  0x3F, 0x93, 0x81, 0x6F, 0x57, 0x48, 0x16, 0xF6, 0x29, 0x0A, 0x28, 0x11, 0xEC, 0x75, 0x0C, 0x92,
  0x81, 0x1F, 0x92, 0x81, 0x8F, 0x47, 0x59, 0x0B, 0x28, 0x54, 0xF7, 0x02, 0xFA, 0x75, 0x81, 0x3F,
  0x82, 0x85, 0x7F, 0x40, 0xAF, 0x27, 0x58, 0x15, 0xF5, 0x28, 0x4C, 0xF0, 0x4F, 0x87, 0x68, 0x96,
  0x6F, 0x40, 0x2F, 0x90, 0xCE, 0x13, 0xCE, 0xB1, 0x38, 0xA3, 0x6D, 0xE8, 0x05, 0xF7, 0x0B, 0xF3,
  0x6F, 0x62, 0xEE, 0xBF, 0x92, 0x85, 0x7F, 0xCD, 0xF4, 0x2A, 0x8B, 0x7E, 0xF9, 0x0E, 0xD0, 0xBE,
  0x10, 0xDD, 0x01, 0xFB, 0x03, 0xF8, 0x06, 0xEE, 0x80, 0x8F, 0x42, 0xF8, 0x28, 0x90, 0xCF, 0x07,
  0xF3, 0x01, 0xF9, 0x58, 0x52, 0xFB, 0x08, 0xF3, 0x28, 0x3D, 0xD0, 0xDD, 0x28, 0x13, 0xF8, 0x58,
  0x4A, 0xF2, 0x0C, 0xE3, 0x98, 0x2B, 0x1F, 0x92, 0x81, 0x5F, 0x64, 0x81, 0x3F, 0x92, 0x90, 0xB2,
  0x84, 0x4F, 0x75, 0xF6, 0x28, 0x19, 0xF2, 0x48, 0x5C, 0xE1, 0x01, 0xF9, 0x28, 0x48, 0xF4, 0x6F,
  0x42, 0x0D, 0x0E, 0x48, 0x15, 0xF7, 0x28, 0x12, 0xF8, 0x28, 0x90, 0xED, 0x07, 0xF3, 0x03, 0xF8,
  0x40, 0x0D, 0x38, 0x95, 0x1F, 0xB0, 0x8F, 0x70, 0x6F, 0x60, 0xCF, 0x23, 0x81, 0x7F, 0x54, 0x83,
  0xDF, 0xEF, 0xC2, 0x03, 0xA8, 0x1E, 0xF7, 0x38, 0x11, 0xEC, 0x58, 0x33, 0xDE, 0xA1, 0x38, 0x27,
  0xED, 0x73,
  // "‹" (U+2039)
  0x40, 0x54, 0x81, 0x6F, 0xA2, 0x89, 0x44, 0xFD, 0x10, 0x3E, 0xE3, 0x02, 0xEF, 0x52, 0x81, 0xDF,
  0x83, 0x81, 0xDF, 0x63, 0x81, 0x6F, 0xC4, 0x81, 0xDF, 0x33, 0x81, 0x6F, 0x94, 0x00, 0xD4, 0x02,
  0x30,
  // "›" (U+203A)
  0x20, 0x03, 0x38, 0x11, 0xFD, 0x48, 0x1B, 0xF5, 0x38, 0x14, 0xFC, 0x48, 0x1D, 0xF5, 0x38, 0x17,
  0xFC, 0x38, 0x1C, 0xFA, 0x28, 0x19, 0xFB, 0x28, 0x77, 0xFC, 0x10, 0x4F, 0xD1, 0x28, 0x1B, 0xE2,
  0x40, 0x24,
  // "⁄" (U+2044)
  0x77, 0x81, 0x7F, 0x67, 0x68, 0x12, 0xFB, 0x77, 0x81, 0xDE, 0x17, 0x68, 0x19, 0xF4, 0x76, 0x81,
  0x4F, 0x97, 0x68, 0x11, 0xED, 0x77, 0x81, 0xBF, 0x37, 0x68, 0x16, 0xF7, 0x76, 0x81, 0x2F, 0xB7,
  0x78, 0x1C, 0xE1, 0x76, 0x81, 0x9F, 0x57, 0x68, 0x14, 0xF9, 0x76, 0x81, 0x1E, 0xD7, 0x78, 0x1B,
  0xF3, 0x76, 0x81, 0x6F, 0x77, 0x68, 0x12, 0xFB, 0x77, 0x81, 0xCE, 0x17, 0x68, 0x18, 0xF5, 0x76,
  0x81, 0x4F, 0x97, 0x68, 0x11, 0xED, 0x77,
  // "™" (U+2122)
  0x09, 0xD8, 0x2B, 0x6F, 0xE4, 0x81, 0xAF, 0x82, 0x81, 0x2F, 0x42, 0x06, 0xA0, 0x42, 0x01, 0xA0,
  0x82, 0x81, 0x2F, 0x42, 0x82, 0x6E, 0xB9, 0x28, 0x25, 0xCD, 0x82, 0x81, 0x2F, 0x42, 0x82, 0x6F,
  0x6E, 0x28, 0x2B, 0x7E, 0x82, 0x81, 0x2F, 0x42, 0x89, 0x06, 0xF1, 0xF4, 0x1F, 0x2E, 0x82, 0x81,
  0x2F, 0x42, 0x89, 0x06, 0xF0, 0xB9, 0x6C, 0x0E, 0x82, 0x81, 0x2F, 0x42, 0x89, 0x06, 0xF0, 0x6E,
  0xB6, 0x0E, 0x82, 0x81, 0x2F, 0x42, 0x82, 0x6F, 0x01, 0xA8, 0x21, 0x0E, 0x82, 0x81, 0x2F, 0x42,
  0x05, 0x92, 0x00, 0xB2, 0x0D, 0x08,
  // "⅒" (U+2152)
  0x48, 0x13, 0x73, 0x78, 0x17, 0xF6, 0x74, 0x07, 0xA0, 0x46, 0x81, 0x2F, 0xB7, 0x38, 0x41, 0xBF,
  0xEF, 0x16, 0x81, 0xDE, 0x17, 0x38, 0x38, 0xE4, 0xDD, 0x68, 0x19, 0xF4, 0x75, 0x82, 0x11, 0xF9,
  0x58, 0x14, 0xF9, 0x77, 0x81, 0x4F, 0x64, 0x81, 0x1E, 0xD7, 0x71, 0x81, 0x8F, 0x34, 0x81, 0xBF,
  0x37, 0x71, 0x0B, 0x94, 0x81, 0x6F, 0x77, 0x72, 0x0E, 0x0B, 0x38, 0x12, 0xFB, 0x38, 0x13, 0x73,
  0x28, 0x31, 0xAE, 0xD6, 0x38, 0x12, 0xF8, 0x38, 0x1C, 0xE1, 0x20, 0x7A, 0x04, 0x28, 0x4D, 0xF9,
  0xDF, 0x32, 0x81, 0x6F, 0x52, 0x8A, 0x09, 0xF5, 0x01, 0xBF, 0xEF, 0x10, 0x8F, 0x50, 0x5F, 0x72,
  0x85, 0x9F, 0x10, 0x4F, 0x92, 0x83, 0x8E, 0x4D, 0xD2, 0x0E, 0x0C, 0x28, 0x13, 0xF8, 0x58, 0x11,
  0xED, 0x48, 0x61, 0x1F, 0x90, 0x5F, 0x72, 0x81, 0x4F, 0x75, 0x81, 0xBF, 0x35, 0x85, 0x4F, 0x60,
  0x9F, 0x32, 0x81, 0x6F, 0x54, 0x81, 0x6F, 0x76, 0x83, 0x8F, 0x30, 0xC9, 0x38, 0x19, 0xF3, 0x38,
  0x12, 0xFB, 0x70, 0xB9, 0x20, 0xD0, 0xE3, 0x0D, 0x0E, 0x48, 0x1C, 0xE1, 0x70, 0xE0, 0xB2, 0x0E,
  0x0C, 0x28, 0x13, 0xF9, 0x38, 0x18, 0xF5, 0x78, 0x12, 0xF8, 0x20, 0xD0, 0xE2, 0x81, 0xBF, 0x22,
  0x81, 0x4F, 0x97, 0x18, 0x16, 0xF5, 0x28, 0x48, 0xFB, 0xCF, 0x72, 0x81, 0x1E, 0xD7, 0x28, 0x19,
  0xF1, 0x38, 0x2A, 0xED, 0x63,
  // "ﬁ" (U+FB01)
  0x72, 0x87, 0x2B, 0xEE, 0xB0, 0x8E, 0x57, 0x10, 0x10, 0xEA, 0x0E, 0x0A, 0x1A, 0x07, 0x71, 0x89,
  0x07, 0xFC, 0x10, 0x10, 0xDD, 0x17, 0x18, 0x1D, 0xF5, 0x77, 0x01, 0xA0, 0x17, 0x78, 0x15, 0xFC,
  0x76, 0x81, 0x28, 0xEB, 0x0E, 0x28, 0x1C, 0xF5, 0x60, 0x80, 0xDA, 0x81, 0xED, 0xA2, 0xA0, 0x27,
  0x18, 0x1E, 0xF3, 0x38, 0x13, 0xFE, 0x71, 0x02, 0xA4, 0x81, 0x6F, 0xB7, 0x18, 0x16, 0xFC, 0x48,
  0x19, 0xF8, 0x71, 0x81, 0x9F, 0x84, 0x81, 0xCF, 0x57, 0x18, 0x1C, 0xF5, 0x4A, 0x01, 0x71, 0xA0,
  0x23, 0x81, 0x3F, 0xE7, 0x18, 0x14, 0xFE, 0x48, 0x17, 0xFB, 0x71, 0x81, 0x7F, 0xA4, 0x81, 0xAF,
  0x77, 0x18, 0x1A, 0xF7, 0x48, 0x1D, 0xF4, 0x71, 0x81, 0xDF, 0x43, 0x01, 0xA0, 0x17, 0x01, 0xA0,
  0x13, 0x81, 0x4F, 0xD7, 0x18, 0x15, 0xFD, 0x48, 0x17, 0xFA, 0x71, 0x81, 0x8F, 0x94, 0x81, 0xAF,
  0x77, 0x18, 0x1B, 0xF6, 0x77, 0x1A, 0x02, 0x77, 0x81, 0x4F, 0xE7, 0x71, 0x81, 0xBF, 0x87, 0x50,
  0x30, 0xEA, 0x0E, 0x01, 0x75, 0x83, 0x3E, 0xEB, 0x37, 0x60,
  // "ﬂ" (U+FB02)
  0x72, 0x87, 0x2B, 0xEE, 0xB0, 0x7F, 0x97, 0x10, 0x10, 0xEA, 0x84, 0xEA, 0x0B, 0xF6, 0x71, 0x89,
  0x07, 0xFC, 0x10, 0x10, 0xEF, 0x37, 0x18, 0x1D, 0xF5, 0x30, 0x2A, 0x71, 0x01, 0xA0, 0x13, 0x81,
  0x5F, 0xC7, 0x18, 0x15, 0xFC, 0x48, 0x18, 0xF9, 0x68, 0x12, 0x8E, 0xB0, 0xE2, 0x81, 0xBF, 0x66,
  0x08, 0x0D, 0xA8, 0x1E, 0xDA, 0x28, 0x1E, 0xF2, 0x71, 0x81, 0xEF, 0x33, 0x81, 0x2F, 0xE7, 0x10,
  0x2A, 0x48, 0x16, 0xFB, 0x71, 0x81, 0x6F, 0xC4, 0x81, 0x9F, 0x87, 0x18, 0x19, 0xF8, 0x48, 0x1C,
  0xF5, 0x71, 0x81, 0xCF, 0x54, 0xA0, 0x27, 0x1A, 0x02, 0x38, 0x13, 0xFE, 0x71, 0x81, 0x4F, 0xE4,
  0x81, 0x6F, 0xB7, 0x18, 0x17, 0xFA, 0x48, 0x19, 0xF8, 0x71, 0x81, 0xAF, 0x74, 0x81, 0xDF, 0x47,
  0x18, 0x1D, 0xF4, 0x4A, 0x01, 0x70, 0x1A, 0x01, 0x38, 0x14, 0xFD, 0x71, 0x81, 0x5F, 0xD4, 0x81,
  0x7F, 0xA7, 0x18, 0x18, 0xF9, 0x48, 0x1A, 0xF7, 0x71, 0x81, 0xBF, 0x67, 0x71, 0xA0, 0x27, 0x78,
  0x14, 0xFE, 0x77, 0x18, 0x1B, 0xF8, 0x75, 0x03, 0x0E, 0xA0, 0xE0, 0x17, 0x58, 0x33, 0xEE, 0xB3,
  0x76,
};

const Font& font_NotoSans_CondensedItalic_27() {
  static SmoothFont font(font_NotoSans_CondensedItalic_27_data);
  return font;
}

}  // namespace roo_display
