#include "8.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSans-CondensedBold (Noto Sans Condensed Bold)
// Generated on Thu Mar 30 22:28:37 CEST 2023
static const uint8_t font_NotoSans_CondensedBold_8_data[] PROGMEM = {
  
  // Header
  0x01, 0x01, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x00, 0x24,
  0xFE, 0xFE, 0x08, 0x09, 0x07, 0xFE, 0x03, 0x01, 0x09, 0x03, 0x02, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x00, 0x01, 0x01, 0x06, 0x02, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x00, 0x04, 0x03, 0x06, 0x04, 0x00, 0x08, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x04, 0x06, 0x04, 0x00, 0x10, // "#" (U+0023)
  0x00, 0x24, 0x00, 0x01, 0x03, 0x07, 0x04, 0x00, 0x20, // "$" (U+0024)
  0x00, 0x25, 0x00, 0x01, 0x06, 0x06, 0x06, 0x00, 0x31, // "%" (U+0025)
  0x00, 0x26, 0x00, 0x01, 0x04, 0x06, 0x05, 0x00, 0x4A, // "&" (U+0026)
  0x00, 0x27, 0x00, 0x04, 0x01, 0x06, 0x02, 0x00, 0x5B, // "'" (U+0027)
  0x00, 0x28, 0x00, 0x00, 0x02, 0x06, 0x03, 0x00, 0x5F, // "(" (U+0028)
  0x00, 0x29, 0x00, 0x00, 0x02, 0x06, 0x03, 0x00, 0x6C, // ")" (U+0029)
  0x00, 0x2A, 0x00, 0x04, 0x03, 0x07, 0x04, 0x00, 0x79, // "*" (U+002A)
  0x00, 0x2B, 0x00, 0x02, 0x03, 0x05, 0x04, 0x00, 0x83, // "+" (U+002B)
  0x00, 0x2C, 0x00, 0x00, 0x01, 0x02, 0x02, 0x00, 0x8D, // "," (U+002C)
  0x00, 0x2D, 0x00, 0x02, 0x02, 0x03, 0x02, 0x00, 0x91, // "-" (U+002D)
  0x00, 0x2E, 0x00, 0x01, 0x01, 0x01, 0x02, 0x00, 0x95, // "." (U+002E)
  0x00, 0x2F, 0x00, 0x01, 0x02, 0x06, 0x03, 0x00, 0x97, // "/" (U+002F)
  0x00, 0x30, 0x00, 0x01, 0x03, 0x06, 0x04, 0x00, 0xA1, // "0" (U+0030)
  0x00, 0x31, 0x00, 0x01, 0x02, 0x06, 0x04, 0x00, 0xAF, // "1" (U+0031)
  0x00, 0x32, 0x00, 0x01, 0x03, 0x06, 0x04, 0x00, 0xBA, // "2" (U+0032)
  0x00, 0x33, 0x00, 0x01, 0x03, 0x06, 0x04, 0x00, 0xC8, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x01, 0x03, 0x06, 0x04, 0x00, 0xD6, // "4" (U+0034)
  0x00, 0x35, 0x00, 0x01, 0x03, 0x06, 0x04, 0x00, 0xE4, // "5" (U+0035)
  0x00, 0x36, 0x00, 0x01, 0x03, 0x06, 0x04, 0x00, 0xF2, // "6" (U+0036)
  0x00, 0x37, 0x00, 0x01, 0x03, 0x06, 0x04, 0x01, 0x00, // "7" (U+0037)
  0x00, 0x38, 0x00, 0x01, 0x03, 0x06, 0x04, 0x01, 0x0E, // "8" (U+0038)
  0x00, 0x39, 0x00, 0x01, 0x03, 0x06, 0x04, 0x01, 0x1C, // "9" (U+0039)
  0x00, 0x3A, 0x00, 0x01, 0x01, 0x05, 0x02, 0x01, 0x2A, // ":" (U+003A)
  0x00, 0x3B, 0x00, 0x00, 0x01, 0x05, 0x02, 0x01, 0x2F, // ";" (U+003B)
  0x00, 0x3C, 0x00, 0x02, 0x03, 0x05, 0x04, 0x01, 0x36, // "<" (U+003C)
  0x00, 0x3D, 0x00, 0x02, 0x03, 0x05, 0x04, 0x01, 0x3F, // "=" (U+003D)
  0x00, 0x3E, 0x00, 0x02, 0x03, 0x05, 0x04, 0x01, 0x49, // ">" (U+003E)
  0x00, 0x3F, 0x00, 0x01, 0x02, 0x06, 0x03, 0x01, 0x53, // "?" (U+003F)
  0x00, 0x40, 0x00, 0x00, 0x05, 0x06, 0x06, 0x01, 0x5E, // "@" (U+0040)
  0x00, 0x41, 0x00, 0x01, 0x04, 0x06, 0x05, 0x01, 0x75, // "A" (U+0041)
  0x00, 0x42, 0x00, 0x01, 0x04, 0x06, 0x05, 0x01, 0x86, // "B" (U+0042)
  0x00, 0x43, 0x00, 0x01, 0x03, 0x06, 0x04, 0x01, 0x97, // "C" (U+0043)
  0x00, 0x44, 0x00, 0x01, 0x04, 0x06, 0x05, 0x01, 0xA5, // "D" (U+0044)
  0x00, 0x45, 0x00, 0x01, 0x03, 0x06, 0x04, 0x01, 0xB6, // "E" (U+0045)
  0x00, 0x46, 0x00, 0x01, 0x03, 0x06, 0x04, 0x01, 0xC4, // "F" (U+0046)
  0x00, 0x47, 0x00, 0x01, 0x04, 0x06, 0x05, 0x01, 0xD2, // "G" (U+0047)
  0x00, 0x48, 0x00, 0x01, 0x04, 0x06, 0x05, 0x01, 0xE3, // "H" (U+0048)
  0x00, 0x49, 0x00, 0x01, 0x02, 0x06, 0x03, 0x01, 0xF4, // "I" (U+0049)
  0x00, 0x4A, 0xFF, 0xFF, 0x01, 0x06, 0x02, 0x01, 0xFF, // "J" (U+004A)
  0x00, 0x4B, 0x00, 0x01, 0x04, 0x06, 0x04, 0x02, 0x0D, // "K" (U+004B)
  0x00, 0x4C, 0x00, 0x01, 0x03, 0x06, 0x04, 0x02, 0x1E, // "L" (U+004C)
  0x00, 0x4D, 0x00, 0x01, 0x05, 0x06, 0x07, 0x02, 0x2D, // "M" (U+004D)
  0x00, 0x4E, 0x00, 0x01, 0x04, 0x06, 0x05, 0x02, 0x41, // "N" (U+004E)
  0x00, 0x4F, 0x00, 0x01, 0x04, 0x06, 0x05, 0x02, 0x52, // "O" (U+004F)
  0x00, 0x50, 0x00, 0x01, 0x03, 0x06, 0x04, 0x02, 0x63, // "P" (U+0050)
  0x00, 0x51, 0x00, 0xFF, 0x04, 0x06, 0x05, 0x02, 0x71, // "Q" (U+0051)
  0x00, 0x52, 0x00, 0x01, 0x04, 0x06, 0x04, 0x02, 0x87, // "R" (U+0052)
  0x00, 0x53, 0x00, 0x01, 0x03, 0x06, 0x04, 0x02, 0x99, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x03, 0x06, 0x04, 0x02, 0xA8, // "T" (U+0054)
  0x00, 0x55, 0x00, 0x01, 0x04, 0x06, 0x05, 0x02, 0xB7, // "U" (U+0055)
  0x00, 0x56, 0x00, 0x01, 0x04, 0x06, 0x04, 0x02, 0xC8, // "V" (U+0056)
  0x00, 0x57, 0x00, 0x01, 0x06, 0x06, 0x07, 0x02, 0xD9, // "W" (U+0057)
  0x00, 0x58, 0x00, 0x01, 0x03, 0x06, 0x04, 0x02, 0xF0, // "X" (U+0058)
  0x00, 0x59, 0x00, 0x01, 0x03, 0x06, 0x04, 0x02, 0xFF, // "Y" (U+0059)
  0x00, 0x5A, 0x00, 0x01, 0x03, 0x06, 0x04, 0x03, 0x0E, // "Z" (U+005A)
  0x00, 0x5B, 0x00, 0xFE, 0x02, 0x06, 0x03, 0x03, 0x1C, // "[" (U+005B)
  0x00, 0x5C, 0x00, 0x01, 0x02, 0x06, 0x03, 0x03, 0x2B, // "\" (U+005C)
  0x00, 0x5D, 0x00, 0xFE, 0x01, 0x06, 0x03, 0x03, 0x36, // "]" (U+005D)
  0x00, 0x5E, 0x00, 0x03, 0x03, 0x06, 0x04, 0x03, 0x41, // "^" (U+005E)
  0x00, 0x5F, 0x00, 0xFF, 0x03, 0x00, 0x04, 0x03, 0x4B, // "_" (U+005F)
  0x00, 0x60, 0x00, 0x06, 0x02, 0x07, 0x03, 0x03, 0x50, // "`" (U+0060)
  0x00, 0x61, 0x00, 0x01, 0x03, 0x05, 0x04, 0x03, 0x54, // "a" (U+0061)
  0x00, 0x62, 0x00, 0x01, 0x03, 0x07, 0x04, 0x03, 0x60, // "b" (U+0062)
  0x00, 0x63, 0x00, 0x01, 0x03, 0x05, 0x03, 0x03, 0x71, // "c" (U+0063)
  0x00, 0x64, 0x00, 0x01, 0x03, 0x07, 0x04, 0x03, 0x7D, // "d" (U+0064)
  0x00, 0x65, 0x00, 0x01, 0x03, 0x05, 0x04, 0x03, 0x8D, // "e" (U+0065)
  0x00, 0x66, 0x00, 0x01, 0x02, 0x07, 0x03, 0x03, 0x99, // "f" (U+0066)
  0x00, 0x67, 0x00, 0xFF, 0x03, 0x05, 0x04, 0x03, 0xA5, // "g" (U+0067)
  0x00, 0x68, 0x00, 0x01, 0x03, 0x07, 0x04, 0x03, 0xB5, // "h" (U+0068)
  0x00, 0x69, 0x00, 0x01, 0x01, 0x07, 0x02, 0x03, 0xC6, // "i" (U+0069)
  0x00, 0x6A, 0xFF, 0xFF, 0x01, 0x07, 0x02, 0x03, 0xCF, // "j" (U+006A)
  0x00, 0x6B, 0x00, 0x01, 0x03, 0x07, 0x04, 0x03, 0xDE, // "k" (U+006B)
  0x00, 0x6C, 0x00, 0x01, 0x01, 0x07, 0x02, 0x03, 0xEF, // "l" (U+006C)
  0x00, 0x6D, 0x00, 0x01, 0x06, 0x05, 0x07, 0x03, 0xF8, // "m" (U+006D)
  0x00, 0x6E, 0x00, 0x01, 0x03, 0x05, 0x04, 0x04, 0x0B, // "n" (U+006E)
  0x00, 0x6F, 0x00, 0x01, 0x03, 0x05, 0x04, 0x04, 0x17, // "o" (U+006F)
  0x00, 0x70, 0x00, 0xFF, 0x03, 0x05, 0x04, 0x04, 0x23, // "p" (U+0070)
  0x00, 0x71, 0x00, 0xFF, 0x03, 0x05, 0x04, 0x04, 0x33, // "q" (U+0071)
  0x00, 0x72, 0x00, 0x01, 0x02, 0x05, 0x03, 0x04, 0x44, // "r" (U+0072)
  0x00, 0x73, 0x00, 0x01, 0x02, 0x05, 0x03, 0x04, 0x4D, // "s" (U+0073)
  0x00, 0x74, 0x00, 0x01, 0x02, 0x06, 0x03, 0x04, 0x56, // "t" (U+0074)
  0x00, 0x75, 0x00, 0x01, 0x03, 0x05, 0x04, 0x04, 0x61, // "u" (U+0075)
  0x00, 0x76, 0x00, 0x01, 0x03, 0x05, 0x04, 0x04, 0x6D, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x01, 0x05, 0x05, 0x06, 0x04, 0x79, // "w" (U+0077)
  0x00, 0x78, 0x00, 0x01, 0x03, 0x05, 0x04, 0x04, 0x8A, // "x" (U+0078)
  0x00, 0x79, 0x00, 0xFF, 0x03, 0x05, 0x04, 0x04, 0x96, // "y" (U+0079)
  0x00, 0x7A, 0x00, 0x01, 0x02, 0x05, 0x03, 0x04, 0xA6, // "z" (U+007A)
  0x00, 0x7B, 0x00, 0xFF, 0x02, 0x06, 0x03, 0x04, 0xAF, // "{" (U+007B)
  0x00, 0x7C, 0x01, 0xFF, 0x02, 0x07, 0x04, 0x04, 0xBD, // "|" (U+007C)
  0x00, 0x7D, 0x00, 0xFF, 0x02, 0x06, 0x03, 0x04, 0xC8, // "}" (U+007D)
  0x00, 0x7E, 0x00, 0x03, 0x03, 0x04, 0x04, 0x04, 0xD6, // "~" (U+007E)
  0x00, 0xA1, 0x00, 0x00, 0x01, 0x05, 0x02, 0x04, 0xDB, // "¡" (U+00A1)
  0x00, 0xA2, 0x00, 0x01, 0x03, 0x06, 0x04, 0x04, 0xE3, // "¢" (U+00A2)
  0x00, 0xA3, 0x00, 0x01, 0x03, 0x06, 0x04, 0x04, 0xF1, // "£" (U+00A3)
  0x00, 0xA4, 0x00, 0x01, 0x03, 0x06, 0x04, 0x04, 0xFF, // "¤" (U+00A4)
  0x00, 0xA5, 0x00, 0x01, 0x03, 0x06, 0x04, 0x05, 0x0C, // "¥" (U+00A5)
  0x00, 0xA6, 0x01, 0xFF, 0x02, 0x07, 0x04, 0x05, 0x1A, // "¦" (U+00A6)
  0x00, 0xA7, 0x00, 0x01, 0x02, 0x07, 0x03, 0x05, 0x24, // "§" (U+00A7)
  0x00, 0xA8, 0x00, 0x07, 0x03, 0x07, 0x04, 0x05, 0x30, // "¨" (U+00A8)
  0x00, 0xA9, 0x00, 0x01, 0x06, 0x07, 0x07, 0x05, 0x33, // "©" (U+00A9)
  0x00, 0xAA, 0x00, 0x04, 0x02, 0x06, 0x03, 0x05, 0x4F, // "ª" (U+00AA)
  0x00, 0xAB, 0x00, 0x01, 0x03, 0x04, 0x04, 0x05, 0x55, // "«" (U+00AB)
  0x00, 0xAC, 0x00, 0x02, 0x03, 0x04, 0x04, 0x05, 0x5F, // "¬" (U+00AC)
  0x00, 0xAE, 0x00, 0x01, 0x06, 0x07, 0x07, 0x05, 0x67, // "®" (U+00AE)
  0x00, 0xAF, 0x00, 0x07, 0x03, 0x08, 0x04, 0x05, 0x82, // "¯" (U+00AF)
  0x00, 0xB0, 0x00, 0x05, 0x02, 0x07, 0x03, 0x05, 0x87, // "°" (U+00B0)
  0x00, 0xB1, 0x00, 0x01, 0x03, 0x06, 0x04, 0x05, 0x8D, // "±" (U+00B1)
  0x00, 0xB2, 0x00, 0x04, 0x02, 0x07, 0x03, 0x05, 0x9A, // "²" (U+00B2)
  0x00, 0xB3, 0x00, 0x04, 0x02, 0x07, 0x03, 0x05, 0xA2, // "³" (U+00B3)
  0x00, 0xB4, 0x00, 0x06, 0x01, 0x07, 0x03, 0x05, 0xAA, // "´" (U+00B4)
  0x00, 0xB5, 0x00, 0xFF, 0x03, 0x05, 0x04, 0x05, 0xAD, // "µ" (U+00B5)
  0x00, 0xB6, 0x00, 0x00, 0x03, 0x07, 0x04, 0x05, 0xBD, // "¶" (U+00B6)
  0x00, 0xB7, 0x00, 0x03, 0x01, 0x03, 0x02, 0x05, 0xCF, // "·" (U+00B7)
  0x00, 0xB8, 0xFF, 0xFF, 0x01, 0x01, 0x01, 0x05, 0xD1, // "¸" (U+00B8)
  0x00, 0xB9, 0x00, 0x04, 0x02, 0x06, 0x03, 0x05, 0xD7, // "¹" (U+00B9)
  0x00, 0xBA, 0x00, 0x04, 0x02, 0x06, 0x03, 0x05, 0xDD, // "º" (U+00BA)
  0x00, 0xBB, 0x00, 0x01, 0x03, 0x04, 0x04, 0x05, 0xE3, // "»" (U+00BB)
  0x00, 0xBC, 0x00, 0x01, 0x06, 0x07, 0x06, 0x05, 0xED, // "¼" (U+00BC)
  0x00, 0xBD, 0x00, 0x00, 0x06, 0x06, 0x07, 0x06, 0x08, // "½" (U+00BD)
  0x00, 0xBE, 0x00, 0x01, 0x06, 0x07, 0x07, 0x06, 0x24, // "¾" (U+00BE)
  0x00, 0xBF, 0x00, 0xFF, 0x02, 0x04, 0x03, 0x06, 0x40, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x04, 0x08, 0x05, 0x06, 0x4B, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x04, 0x08, 0x05, 0x06, 0x62, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x01, 0x04, 0x08, 0x05, 0x06, 0x77, // "Â" (U+00C2)
  0x00, 0xC3, 0x00, 0x01, 0x04, 0x08, 0x05, 0x06, 0x8E, // "Ã" (U+00C3)
  0x00, 0xC4, 0x00, 0x01, 0x04, 0x08, 0x05, 0x06, 0xA5, // "Ä" (U+00C4)
  0x00, 0xC5, 0x00, 0x01, 0x04, 0x07, 0x05, 0x06, 0xB9, // "Å" (U+00C5)
  0x00, 0xC6, 0x00, 0x01, 0x05, 0x06, 0x06, 0x06, 0xCC, // "Æ" (U+00C6)
  0x00, 0xC7, 0x00, 0xFF, 0x03, 0x06, 0x04, 0x06, 0xE0, // "Ç" (U+00C7)
  0x00, 0xC8, 0x00, 0x01, 0x03, 0x08, 0x04, 0x06, 0xF3, // "È" (U+00C8)
  0x00, 0xC9, 0x00, 0x01, 0x03, 0x08, 0x04, 0x07, 0x06, // "É" (U+00C9)
  0x00, 0xCA, 0x00, 0x01, 0x03, 0x08, 0x04, 0x07, 0x19, // "Ê" (U+00CA)
  0x00, 0xCB, 0x00, 0x01, 0x03, 0x08, 0x04, 0x07, 0x2C, // "Ë" (U+00CB)
  0x00, 0xCC, 0x00, 0x01, 0x02, 0x08, 0x03, 0x07, 0x3E, // "Ì" (U+00CC)
  0x00, 0xCD, 0x00, 0x01, 0x02, 0x08, 0x03, 0x07, 0x4C, // "Í" (U+00CD)
  0x00, 0xCE, 0x00, 0x01, 0x02, 0x08, 0x03, 0x07, 0x5A, // "Î" (U+00CE)
  0x00, 0xCF, 0xFF, 0x01, 0x02, 0x08, 0x03, 0x07, 0x68, // "Ï" (U+00CF)
  0x00, 0xD0, 0x00, 0x01, 0x04, 0x06, 0x05, 0x07, 0x7A, // "Ð" (U+00D0)
  0x00, 0xD1, 0x00, 0x01, 0x04, 0x08, 0x05, 0x07, 0x8B, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x00, 0x01, 0x04, 0x08, 0x05, 0x07, 0xA1, // "Ò" (U+00D2)
  0x00, 0xD3, 0x00, 0x01, 0x04, 0x08, 0x05, 0x07, 0xB7, // "Ó" (U+00D3)
  0x00, 0xD4, 0x00, 0x01, 0x04, 0x08, 0x05, 0x07, 0xCC, // "Ô" (U+00D4)
  0x00, 0xD5, 0x00, 0x01, 0x04, 0x08, 0x05, 0x07, 0xE2, // "Õ" (U+00D5)
  0x00, 0xD6, 0x00, 0x01, 0x04, 0x08, 0x05, 0x07, 0xF8, // "Ö" (U+00D6)
  0x00, 0xD7, 0x00, 0x02, 0x03, 0x05, 0x04, 0x08, 0x0C, // "×" (U+00D7)
  0x00, 0xD8, 0x00, 0x00, 0x04, 0x07, 0x05, 0x08, 0x16, // "Ø" (U+00D8)
  0x00, 0xD9, 0x00, 0x01, 0x04, 0x08, 0x05, 0x08, 0x29, // "Ù" (U+00D9)
  0x00, 0xDA, 0x00, 0x01, 0x04, 0x08, 0x05, 0x08, 0x3F, // "Ú" (U+00DA)
  0x00, 0xDB, 0x00, 0x01, 0x04, 0x08, 0x05, 0x08, 0x54, // "Û" (U+00DB)
  0x00, 0xDC, 0x00, 0x01, 0x04, 0x08, 0x05, 0x08, 0x6A, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x01, 0x03, 0x08, 0x04, 0x08, 0x7E, // "Ý" (U+00DD)
  0x00, 0xDE, 0x00, 0x01, 0x03, 0x06, 0x04, 0x08, 0x91, // "Þ" (U+00DE)
  0x00, 0xDF, 0x00, 0x01, 0x04, 0x07, 0x05, 0x08, 0x9F, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x01, 0x03, 0x07, 0x04, 0x08, 0xB2, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x03, 0x07, 0x04, 0x08, 0xC2, // "á" (U+00E1)
  0x00, 0xE2, 0x00, 0x01, 0x03, 0x07, 0x04, 0x08, 0xD2, // "â" (U+00E2)
  0x00, 0xE3, 0x00, 0x01, 0x03, 0x07, 0x04, 0x08, 0xE2, // "ã" (U+00E3)
  0x00, 0xE4, 0x00, 0x01, 0x03, 0x07, 0x04, 0x08, 0xF2, // "ä" (U+00E4)
  0x00, 0xE5, 0x00, 0x01, 0x03, 0x07, 0x04, 0x09, 0x01, // "å" (U+00E5)
  0x00, 0xE6, 0x00, 0x01, 0x05, 0x05, 0x06, 0x09, 0x11, // "æ" (U+00E6)
  0x00, 0xE7, 0x00, 0xFF, 0x03, 0x05, 0x03, 0x09, 0x22, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x01, 0x03, 0x07, 0x04, 0x09, 0x33, // "è" (U+00E8)
  0x00, 0xE9, 0x00, 0x01, 0x03, 0x07, 0x04, 0x09, 0x43, // "é" (U+00E9)
  0x00, 0xEA, 0x00, 0x01, 0x03, 0x07, 0x04, 0x09, 0x53, // "ê" (U+00EA)
  0x00, 0xEB, 0x00, 0x01, 0x03, 0x07, 0x04, 0x09, 0x63, // "ë" (U+00EB)
  0x00, 0xEC, 0xFF, 0x01, 0x01, 0x07, 0x02, 0x09, 0x72, // "ì" (U+00EC)
  0x00, 0xED, 0x00, 0x01, 0x01, 0x07, 0x02, 0x09, 0x7E, // "í" (U+00ED)
  0x00, 0xEE, 0xFF, 0x01, 0x01, 0x07, 0x02, 0x09, 0x87, // "î" (U+00EE)
  0x00, 0xEF, 0xFF, 0x01, 0x02, 0x07, 0x02, 0x09, 0x93, // "ï" (U+00EF)
  0x00, 0xF0, 0x00, 0x01, 0x03, 0x08, 0x04, 0x09, 0xA3, // "ð" (U+00F0)
  0x00, 0xF1, 0x00, 0x01, 0x04, 0x07, 0x04, 0x09, 0xB5, // "ñ" (U+00F1)
  0x00, 0xF2, 0x00, 0x01, 0x03, 0x07, 0x04, 0x09, 0xC8, // "ò" (U+00F2)
  0x00, 0xF3, 0x00, 0x01, 0x03, 0x07, 0x04, 0x09, 0xD8, // "ó" (U+00F3)
  0x00, 0xF4, 0x00, 0x01, 0x03, 0x07, 0x04, 0x09, 0xE8, // "ô" (U+00F4)
  0x00, 0xF5, 0x00, 0x01, 0x03, 0x07, 0x04, 0x09, 0xF8, // "õ" (U+00F5)
  0x00, 0xF6, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0A, 0x08, // "ö" (U+00F6)
  0x00, 0xF7, 0x00, 0x02, 0x03, 0x05, 0x04, 0x0A, 0x17, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x00, 0x03, 0x06, 0x04, 0x0A, 0x21, // "ø" (U+00F8)
  0x00, 0xF9, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0A, 0x2F, // "ù" (U+00F9)
  0x00, 0xFA, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0A, 0x3F, // "ú" (U+00FA)
  0x00, 0xFB, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0A, 0x4F, // "û" (U+00FB)
  0x00, 0xFC, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0A, 0x5E, // "ü" (U+00FC)
  0x00, 0xFD, 0x00, 0xFF, 0x03, 0x07, 0x04, 0x0A, 0x6D, // "ý" (U+00FD)
  0x00, 0xFE, 0x00, 0xFF, 0x03, 0x07, 0x04, 0x0A, 0x81, // "þ" (U+00FE)
  0x00, 0xFF, 0x00, 0xFF, 0x03, 0x07, 0x04, 0x0A, 0x96, // "ÿ" (U+00FF)
  0x01, 0x00, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0A, 0xA9, // "Ā" (U+0100)
  0x01, 0x01, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0A, 0xBF, // "ā" (U+0101)
  0x01, 0x02, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0A, 0xCF, // "Ă" (U+0102)
  0x01, 0x03, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0A, 0xE6, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0xFF, 0x04, 0x06, 0x05, 0x0A, 0xF6, // "Ą" (U+0104)
  0x01, 0x05, 0x00, 0xFF, 0x03, 0x05, 0x04, 0x0B, 0x0C, // "ą" (U+0105)
  0x01, 0x06, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0B, 0x1D, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x01, 0x03, 0x07, 0x03, 0x0B, 0x2F, // "ć" (U+0107)
  0x01, 0x08, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0B, 0x40, // "Ĉ" (U+0108)
  0x01, 0x09, 0x00, 0x01, 0x03, 0x07, 0x03, 0x0B, 0x52, // "ĉ" (U+0109)
  0x01, 0x0A, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0B, 0x62, // "Ċ" (U+010A)
  0x01, 0x0B, 0x00, 0x01, 0x03, 0x07, 0x03, 0x0B, 0x73, // "ċ" (U+010B)
  0x01, 0x0C, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0B, 0x82, // "Č" (U+010C)
  0x01, 0x0D, 0x00, 0x01, 0x03, 0x07, 0x03, 0x0B, 0x95, // "č" (U+010D)
  0x01, 0x0E, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0B, 0xA5, // "Ď" (U+010E)
  0x01, 0x0F, 0x00, 0x01, 0x05, 0x07, 0x04, 0x0B, 0xBB, // "ď" (U+010F)
  0x01, 0x10, 0x00, 0x01, 0x04, 0x06, 0x05, 0x0B, 0xD3, // "Đ" (U+0110)
  0x01, 0x11, 0x00, 0x01, 0x04, 0x07, 0x04, 0x0B, 0xE4, // "đ" (U+0111)
  0x01, 0x12, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0B, 0xF7, // "Ē" (U+0112)
  0x01, 0x13, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0C, 0x0A, // "ē" (U+0113)
  0x01, 0x14, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0C, 0x1A, // "Ĕ" (U+0114)
  0x01, 0x15, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0C, 0x2D, // "ĕ" (U+0115)
  0x01, 0x16, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0C, 0x3D, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0C, 0x4E, // "ė" (U+0117)
  0x01, 0x18, 0x00, 0xFF, 0x03, 0x06, 0x04, 0x0C, 0x5D, // "Ę" (U+0118)
  0x01, 0x19, 0x00, 0xFF, 0x03, 0x05, 0x04, 0x0C, 0x70, // "ę" (U+0119)
  0x01, 0x1A, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0C, 0x80, // "Ě" (U+011A)
  0x01, 0x1B, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0C, 0x93, // "ě" (U+011B)
  0x01, 0x1C, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0C, 0xA3, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x00, 0xFF, 0x03, 0x07, 0x04, 0x0C, 0xB9, // "ĝ" (U+011D)
  0x01, 0x1E, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0C, 0xCC, // "Ğ" (U+011E)
  0x01, 0x1F, 0x00, 0xFF, 0x03, 0x07, 0x04, 0x0C, 0xE3, // "ğ" (U+011F)
  0x01, 0x20, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0C, 0xF7, // "Ġ" (U+0120)
  0x01, 0x21, 0x00, 0xFF, 0x03, 0x07, 0x04, 0x0D, 0x0A, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0xFF, 0x04, 0x06, 0x05, 0x0D, 0x1D, // "Ģ" (U+0122)
  0x01, 0x23, 0x00, 0xFF, 0x03, 0x07, 0x04, 0x0D, 0x31, // "ģ" (U+0123)
  0x01, 0x24, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0D, 0x44, // "Ĥ" (U+0124)
  0x01, 0x25, 0xFF, 0x01, 0x03, 0x09, 0x04, 0x0D, 0x5A, // "ĥ" (U+0125)
  0x01, 0x26, 0x00, 0x01, 0x05, 0x06, 0x05, 0x0D, 0x73, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0D, 0x87, // "ħ" (U+0127)
  0x01, 0x28, 0x00, 0x01, 0x03, 0x08, 0x03, 0x0D, 0x97, // "Ĩ" (U+0128)
  0x01, 0x29, 0xFF, 0x01, 0x02, 0x07, 0x02, 0x0D, 0xAB, // "ĩ" (U+0129)
  0x01, 0x2A, 0x00, 0x01, 0x02, 0x08, 0x03, 0x0D, 0xBD, // "Ī" (U+012A)
  0x01, 0x2B, 0x00, 0x01, 0x02, 0x07, 0x02, 0x0D, 0xCB, // "ī" (U+012B)
  0x01, 0x2C, 0x00, 0x01, 0x02, 0x08, 0x03, 0x0D, 0xD7, // "Ĭ" (U+012C)
  0x01, 0x2D, 0xFF, 0x01, 0x01, 0x07, 0x02, 0x0D, 0xE5, // "ĭ" (U+012D)
  0x01, 0x2E, 0x00, 0xFF, 0x02, 0x06, 0x03, 0x0D, 0xF1, // "Į" (U+012E)
  0x01, 0x2F, 0x00, 0xFF, 0x01, 0x07, 0x02, 0x0D, 0xFF, // "į" (U+012F)
  0x01, 0x30, 0x00, 0x01, 0x02, 0x08, 0x03, 0x0E, 0x0A, // "İ" (U+0130)
  0x01, 0x31, 0x00, 0x01, 0x01, 0x05, 0x02, 0x0E, 0x18, // "ı" (U+0131)
  0x01, 0x32, 0x00, 0xFF, 0x04, 0x06, 0x05, 0x0E, 0x1F, // "Ĳ" (U+0132)
  0x01, 0x33, 0x00, 0xFF, 0x03, 0x07, 0x04, 0x0E, 0x35, // "ĳ" (U+0133)
  0x01, 0x34, 0xFF, 0xFF, 0x01, 0x08, 0x02, 0x0E, 0x49, // "Ĵ" (U+0134)
  0x01, 0x35, 0xFF, 0xFF, 0x01, 0x07, 0x02, 0x0E, 0x5A, // "ĵ" (U+0135)
  0x01, 0x36, 0x00, 0xFF, 0x04, 0x06, 0x04, 0x0E, 0x69, // "Ķ" (U+0136)
  0x01, 0x37, 0x00, 0xFF, 0x03, 0x07, 0x04, 0x0E, 0x7D, // "ķ" (U+0137)
  0x01, 0x38, 0x00, 0x01, 0x03, 0x05, 0x04, 0x0E, 0x91, // "ĸ" (U+0138)
  0x01, 0x39, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0E, 0x9D, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x00, 0x01, 0x01, 0x09, 0x02, 0x0E, 0xB0, // "ĺ" (U+013A)
  0x01, 0x3B, 0x00, 0xFF, 0x03, 0x06, 0x04, 0x0E, 0xBB, // "Ļ" (U+013B)
  0x01, 0x3C, 0x00, 0xFF, 0x01, 0x07, 0x02, 0x0E, 0xCD, // "ļ" (U+013C)
  0x01, 0x3D, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0E, 0xD8, // "Ľ" (U+013D)
  0x01, 0x3E, 0x00, 0x01, 0x03, 0x07, 0x02, 0x0E, 0xE9, // "ľ" (U+013E)
  0x01, 0x3F, 0x00, 0x01, 0x03, 0x06, 0x04, 0x0E, 0xFA, // "Ŀ" (U+013F)
  0x01, 0x40, 0x00, 0x01, 0x03, 0x07, 0x03, 0x0F, 0x09, // "ŀ" (U+0140)
  0x01, 0x41, 0x00, 0x01, 0x03, 0x06, 0x04, 0x0F, 0x1A, // "Ł" (U+0141)
  0x01, 0x42, 0x00, 0x01, 0x02, 0x07, 0x02, 0x0F, 0x29, // "ł" (U+0142)
  0x01, 0x43, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0F, 0x35, // "Ń" (U+0143)
  0x01, 0x44, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0F, 0x4A, // "ń" (U+0144)
  0x01, 0x45, 0x00, 0xFF, 0x04, 0x06, 0x05, 0x0F, 0x5A, // "Ņ" (U+0145)
  0x01, 0x46, 0x00, 0xFF, 0x03, 0x05, 0x04, 0x0F, 0x6E, // "ņ" (U+0146)
  0x01, 0x47, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0F, 0x7D, // "Ň" (U+0147)
  0x01, 0x48, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0F, 0x93, // "ň" (U+0148)
  0x01, 0x49, 0x00, 0x01, 0x04, 0x06, 0x05, 0x0F, 0xA3, // "ŉ" (U+0149)
  0x01, 0x4A, 0x00, 0xFE, 0x04, 0x06, 0x05, 0x0F, 0xB4, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x00, 0xFF, 0x03, 0x05, 0x04, 0x0F, 0xCC, // "ŋ" (U+014B)
  0x01, 0x4C, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0F, 0xDD, // "Ō" (U+014C)
  0x01, 0x4D, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0F, 0xF3, // "ō" (U+014D)
  0x01, 0x4E, 0x00, 0x01, 0x04, 0x08, 0x05, 0x10, 0x03, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x00, 0x01, 0x03, 0x07, 0x04, 0x10, 0x1A, // "ŏ" (U+014F)
  0x01, 0x50, 0x00, 0x01, 0x04, 0x08, 0x05, 0x10, 0x2A, // "Ő" (U+0150)
  0x01, 0x51, 0x00, 0x01, 0x04, 0x07, 0x04, 0x10, 0x3E, // "ő" (U+0151)
  0x01, 0x52, 0x00, 0x01, 0x05, 0x06, 0x06, 0x10, 0x50, // "Œ" (U+0152)
  0x01, 0x53, 0x00, 0x01, 0x06, 0x05, 0x06, 0x10, 0x63, // "œ" (U+0153)
  0x01, 0x54, 0x00, 0x01, 0x04, 0x08, 0x04, 0x10, 0x76, // "Ŕ" (U+0154)
  0x01, 0x55, 0x00, 0x01, 0x02, 0x07, 0x03, 0x10, 0x8C, // "ŕ" (U+0155)
  0x01, 0x56, 0x00, 0xFF, 0x04, 0x06, 0x04, 0x10, 0x98, // "Ŗ" (U+0156)
  0x01, 0x57, 0x00, 0xFF, 0x02, 0x05, 0x03, 0x10, 0xAD, // "ŗ" (U+0157)
  0x01, 0x58, 0x00, 0x01, 0x04, 0x08, 0x04, 0x10, 0xB9, // "Ř" (U+0158)
  0x01, 0x59, 0x00, 0x01, 0x02, 0x07, 0x03, 0x10, 0xD0, // "ř" (U+0159)
  0x01, 0x5A, 0x00, 0x01, 0x03, 0x08, 0x04, 0x10, 0xDC, // "Ś" (U+015A)
  0x01, 0x5B, 0x00, 0x01, 0x02, 0x07, 0x03, 0x10, 0xEF, // "ś" (U+015B)
  0x01, 0x5C, 0x00, 0x01, 0x03, 0x08, 0x04, 0x10, 0xFB, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x00, 0x01, 0x02, 0x07, 0x03, 0x11, 0x0E, // "ŝ" (U+015D)
  0x01, 0x5E, 0x00, 0xFF, 0x03, 0x06, 0x04, 0x11, 0x1A, // "Ş" (U+015E)
  0x01, 0x5F, 0x00, 0xFF, 0x02, 0x05, 0x03, 0x11, 0x2D, // "ş" (U+015F)
  0x01, 0x60, 0x00, 0x01, 0x03, 0x08, 0x04, 0x11, 0x39, // "Š" (U+0160)
  0x01, 0x61, 0x00, 0x01, 0x02, 0x07, 0x03, 0x11, 0x4C, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFF, 0x03, 0x06, 0x04, 0x11, 0x58, // "Ţ" (U+0162)
  0x01, 0x63, 0x00, 0xFF, 0x02, 0x06, 0x03, 0x11, 0x6C, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x03, 0x08, 0x04, 0x11, 0x7A, // "Ť" (U+0164)
  0x01, 0x65, 0x00, 0x01, 0x04, 0x07, 0x03, 0x11, 0x8E, // "ť" (U+0165)
  0x01, 0x66, 0x00, 0x01, 0x03, 0x06, 0x04, 0x11, 0xA0, // "Ŧ" (U+0166)
  0x01, 0x67, 0x00, 0x01, 0x02, 0x06, 0x03, 0x11, 0xAF, // "ŧ" (U+0167)
  0x01, 0x68, 0x00, 0x01, 0x04, 0x08, 0x05, 0x11, 0xBA, // "Ũ" (U+0168)
  0x01, 0x69, 0x00, 0x01, 0x03, 0x07, 0x04, 0x11, 0xD0, // "ũ" (U+0169)
  0x01, 0x6A, 0x00, 0x01, 0x04, 0x08, 0x05, 0x11, 0xE0, // "Ū" (U+016A)
  0x01, 0x6B, 0x00, 0x01, 0x03, 0x07, 0x04, 0x11, 0xF6, // "ū" (U+016B)
  0x01, 0x6C, 0x00, 0x01, 0x04, 0x08, 0x05, 0x12, 0x06, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x00, 0x01, 0x03, 0x07, 0x04, 0x12, 0x1C, // "ŭ" (U+016D)
  0x01, 0x6E, 0x00, 0x01, 0x04, 0x08, 0x05, 0x12, 0x2C, // "Ů" (U+016E)
  0x01, 0x6F, 0x00, 0x01, 0x03, 0x07, 0x04, 0x12, 0x42, // "ů" (U+016F)
  0x01, 0x70, 0x00, 0x01, 0x04, 0x08, 0x05, 0x12, 0x52, // "Ű" (U+0170)
  0x01, 0x71, 0x00, 0x01, 0x04, 0x07, 0x04, 0x12, 0x67, // "ű" (U+0171)
  0x01, 0x72, 0x00, 0xFF, 0x04, 0x06, 0x05, 0x12, 0x79, // "Ų" (U+0172)
  0x01, 0x73, 0x00, 0xFF, 0x03, 0x05, 0x04, 0x12, 0x8F, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x06, 0x08, 0x07, 0x12, 0xA0, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x05, 0x07, 0x06, 0x12, 0xBD, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x01, 0x03, 0x08, 0x04, 0x12, 0xD4, // "Ŷ" (U+0176)
  0x01, 0x77, 0x00, 0xFF, 0x03, 0x07, 0x04, 0x12, 0xE7, // "ŷ" (U+0177)
  0x01, 0x78, 0x00, 0x01, 0x03, 0x08, 0x04, 0x12, 0xFB, // "Ÿ" (U+0178)
  0x01, 0x79, 0x00, 0x01, 0x03, 0x08, 0x04, 0x13, 0x0D, // "Ź" (U+0179)
  0x01, 0x7A, 0x00, 0x01, 0x02, 0x07, 0x03, 0x13, 0x1F, // "ź" (U+017A)
  0x01, 0x7B, 0x00, 0x01, 0x03, 0x08, 0x04, 0x13, 0x2B, // "Ż" (U+017B)
  0x01, 0x7C, 0x00, 0x01, 0x02, 0x07, 0x03, 0x13, 0x3C, // "ż" (U+017C)
  0x01, 0x7D, 0x00, 0x01, 0x03, 0x08, 0x04, 0x13, 0x48, // "Ž" (U+017D)
  0x01, 0x7E, 0x00, 0x01, 0x02, 0x07, 0x03, 0x13, 0x5A, // "ž" (U+017E)
  0x01, 0x7F, 0x00, 0x01, 0x02, 0x07, 0x03, 0x13, 0x66, // "ſ" (U+017F)
  0x03, 0xA9, 0x00, 0x01, 0x04, 0x06, 0x05, 0x13, 0x72, // "Ω" (U+03A9)
  0x03, 0xBC, 0x00, 0xFF, 0x03, 0x05, 0x04, 0x13, 0x82, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x01, 0x04, 0x05, 0x05, 0x13, 0x92, // "π" (U+03C0)
  0x20, 0x13, 0x00, 0x02, 0x03, 0x03, 0x04, 0x13, 0xA0, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x02, 0x07, 0x03, 0x08, 0x13, 0xA5, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x01, 0x03, 0x06, 0x04, 0x13, 0xAB, // "€" (U+20AC)
  0x20, 0xBF, 0x00, 0x00, 0x03, 0x07, 0x04, 0x13, 0xB9, // "₿" (U+20BF)
  0x20, 0x18, 0x00, 0x04, 0x01, 0x06, 0x02, 0x13, 0xCC, // "‘" (U+2018)
  0x20, 0x19, 0x00, 0x04, 0x01, 0x06, 0x02, 0x13, 0xD0, // "’" (U+2019)
  0x20, 0x1A, 0x00, 0xFF, 0x01, 0x01, 0x02, 0x13, 0xD4, // "‚" (U+201A)
  0x20, 0x1B, 0x00, 0x04, 0x01, 0x06, 0x02, 0x13, 0xD8, // "‛" (U+201B)
  0x20, 0x1C, 0x00, 0x04, 0x03, 0x06, 0x04, 0x13, 0xDC, // "“" (U+201C)
  0x20, 0x1D, 0x00, 0x04, 0x03, 0x06, 0x04, 0x13, 0xE4, // "”" (U+201D)
  0x20, 0x1E, 0x00, 0xFF, 0x03, 0x01, 0x04, 0x13, 0xEC, // "„" (U+201E)
  0x20, 0x1F, 0x00, 0x04, 0x03, 0x06, 0x04, 0x13, 0xF4, // "‟" (U+201F)
  0x20, 0x20, 0x00, 0x01, 0x03, 0x07, 0x04, 0x13, 0xFC, // "†" (U+2020)
  0x20, 0x21, 0x00, 0x01, 0x03, 0x07, 0x04, 0x14, 0x0D, // "‡" (U+2021)
  0x20, 0x22, 0x00, 0x03, 0x02, 0x05, 0x03, 0x14, 0x1D, // "•" (U+2022)
  0x20, 0x26, 0x00, 0x01, 0x05, 0x01, 0x06, 0x14, 0x23, // "…" (U+2026)
  0x20, 0x30, 0x00, 0x01, 0x08, 0x06, 0x09, 0x14, 0x27, // "‰" (U+2030)
  0x20, 0x39, 0x00, 0x01, 0x02, 0x04, 0x03, 0x14, 0x44, // "‹" (U+2039)
  0x20, 0x3A, 0x00, 0x01, 0x02, 0x04, 0x03, 0x14, 0x4C, // "›" (U+203A)
  0x20, 0x44, 0xFE, 0x01, 0x02, 0x06, 0x01, 0x14, 0x54, // "⁄" (U+2044)
  0x21, 0x22, 0x00, 0x04, 0x05, 0x06, 0x06, 0x14, 0x64, // "™" (U+2122)
  0x21, 0x52, 0x00, 0x01, 0x08, 0x06, 0x09, 0x14, 0x6F, // "⅒" (U+2152)
  0xFB, 0x01, 0x00, 0x01, 0x04, 0x07, 0x05, 0x14, 0x8B, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0x00, 0x01, 0x04, 0x07, 0x05, 0x14, 0x9E, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0xC6, 0x01, // "Æ (U+0022 U+00C6)
  0x00, 0x27, 0x00, 0xC6, 0x01, // 'Æ (U+0027 U+00C6)
  0x00, 0x30, 0x20, 0x44, 0x01, // 0⁄ (U+0030 U+2044)
  0x00, 0x31, 0x20, 0x44, 0x01, // 1⁄ (U+0031 U+2044)
  0x00, 0x32, 0x20, 0x44, 0x01, // 2⁄ (U+0032 U+2044)
  0x00, 0x33, 0x20, 0x44, 0x01, // 3⁄ (U+0033 U+2044)
  0x00, 0x34, 0x20, 0x44, 0x01, // 4⁄ (U+0034 U+2044)
  0x00, 0x35, 0x20, 0x44, 0x01, // 5⁄ (U+0035 U+2044)
  0x00, 0x36, 0x20, 0x44, 0x01, // 6⁄ (U+0036 U+2044)
  0x00, 0x37, 0x20, 0x44, 0x01, // 7⁄ (U+0037 U+2044)
  0x00, 0x38, 0x20, 0x44, 0x01, // 8⁄ (U+0038 U+2044)
  0x00, 0x39, 0x20, 0x44, 0x01, // 9⁄ (U+0039 U+2044)
  0x00, 0x50, 0x00, 0x2C, 0x01, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x01, // P. (U+0050 U+002E)
  0x00, 0x50, 0x20, 0x1A, 0x01, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x01, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x01, // P… (U+0050 U+2026)
  0x00, 0xDE, 0x00, 0x2C, 0x01, // Þ, (U+00DE U+002C)
  0x00, 0xDE, 0x00, 0x2E, 0x01, // Þ. (U+00DE U+002E)
  0x00, 0xDE, 0x20, 0x1A, 0x01, // Þ‚ (U+00DE U+201A)
  0x00, 0xDE, 0x20, 0x1E, 0x01, // Þ„ (U+00DE U+201E)
  0x00, 0xDE, 0x20, 0x26, 0x01, // Þ… (U+00DE U+2026)
  0x20, 0x18, 0x00, 0xC6, 0x01, // ‘Æ (U+2018 U+00C6)
  0x20, 0x19, 0x00, 0xC6, 0x01, // ’Æ (U+2019 U+00C6)
  0x20, 0x1C, 0x00, 0xC6, 0x01, // “Æ (U+201C U+00C6)
  0x20, 0x1D, 0x00, 0xC6, 0x01, // ”Æ (U+201D U+00C6)
  0x20, 0x44, 0x00, 0x30, 0x01, // ⁄0 (U+2044 U+0030)
  0x20, 0x44, 0x00, 0x31, 0x01, // ⁄1 (U+2044 U+0031)
  0x20, 0x44, 0x00, 0x32, 0x01, // ⁄2 (U+2044 U+0032)
  0x20, 0x44, 0x00, 0x33, 0x01, // ⁄3 (U+2044 U+0033)
  0x20, 0x44, 0x00, 0x34, 0x01, // ⁄4 (U+2044 U+0034)
  0x20, 0x44, 0x00, 0x35, 0x01, // ⁄5 (U+2044 U+0035)
  0x20, 0x44, 0x00, 0x36, 0x01, // ⁄6 (U+2044 U+0036)
  0x20, 0x44, 0x00, 0x37, 0x01, // ⁄7 (U+2044 U+0037)
  0x20, 0x44, 0x00, 0x38, 0x01, // ⁄8 (U+2044 U+0038)
  0x20, 0x44, 0x00, 0x39, 0x01, // ⁄9 (U+2044 U+0039)
  
  // Glyph data
  // "!" (U+0021)
  0x86, 0x8A, 0x79, 0x78, 0x68, 0x20, 0x60, 0x80,
  // """ (U+0022)
  0x89, 0x18, 0x7D, 0x27, 0x6C, 0x11, 0x01, 0x10,
  // "#" (U+0023)
  0x18, 0xB1, 0x95, 0xA0, 0x8F, 0xEE, 0x30, 0xC7, 0x50, 0xBF, 0xEE, 0x03, 0xAB, 0x20, 0x48, 0xC2,
  // "$" (U+0024)
  0x18, 0x90, 0x77, 0x17, 0xDB, 0x58, 0xC4, 0x28, 0x69, 0xE3, 0x23, 0xA9, 0x8A, 0x82, 0x40, 0x44,
  0x10,
  // "%" (U+0025)
  0x83, 0x5E, 0x32, 0xA2, 0x83, 0xB7, 0x98, 0x42, 0x89, 0x4B, 0x69, 0xCA, 0xA0, 0x6F, 0xA8, 0xBA,
  0x22, 0x89, 0x1B, 0x2B, 0xA2, 0x03, 0x90, 0xBC, 0x10,
  // "&" (U+0026)
  0x8B, 0x41, 0xCE, 0x30, 0x4C, 0x97, 0x01, 0xED, 0x20, 0x6B, 0xD8, 0xAB, 0x78, 0xF4, 0x5E, 0xDB,
  0xA0,
  // "'" (U+0027)
  0x83, 0x87, 0x76, 0x11,
  // "(" (U+0028)
  0x18, 0x96, 0xB2, 0x4A, 0x08, 0x70, 0x96, 0x08, 0x70, 0x4B, 0x20, 0xC0, 0x20,
  // ")" (U+0029)
  0x83, 0x85, 0x02, 0xD2, 0x89, 0x3E, 0x10, 0xC3, 0x0E, 0x12, 0xD0, 0x95, 0x10,
  // "*" (U+002A)
  0x18, 0x95, 0x85, 0x0A, 0xDC, 0x71, 0xDC, 0x02, 0x57, 0x10,
  // "+" (U+002B)
  0x18, 0x94, 0x66, 0x0A, 0xEE, 0xA1, 0x77, 0x10, 0x66, 0x10,
  // "," (U+002C)
  0x84, 0x11, 0x78, 0xA4,
  // "-" (U+002D)
  0x83, 0xAE, 0x31, 0x11,
  // "." (U+002E)
  0x06, 0x08,
  // "/" (U+002F)
  0x28, 0x95, 0xD0, 0x4A, 0x0A, 0x41, 0xD0, 0x69, 0x0B, 0x31,
  // "0" (U+0030)
  0x8A, 0x62, 0xDD, 0x18, 0x99, 0x7A, 0x66, 0xAA, 0x66, 0xA8, 0x99, 0x82, 0xDD, 0x20,
  // "1" (U+0031)
  0x18, 0x96, 0x6F, 0x5D, 0xF0, 0x3F, 0x01, 0xF0, 0x1F, 0x01, 0x90,
  // "2" (U+0032)
  0x86, 0x5E, 0xD2, 0x32, 0xB7, 0x28, 0x91, 0xC5, 0x07, 0xB0, 0x3D, 0x10, 0xBA, 0x09,
  // "3" (U+0033)
  0x8A, 0x66, 0xED, 0x31, 0x1B, 0x70, 0xED, 0x10, 0x1B, 0x83, 0x0A, 0x99, 0xFC, 0x20,
  // "4" (U+0034)
  0x18, 0xA5, 0x1E, 0x40, 0x8F, 0x41, 0xDC, 0x48, 0x5C, 0x4D, 0xEF, 0xD1, 0x1C, 0x50,
  // "5" (U+0035)
  0x05, 0xA8, 0x14, 0x68, 0x28, 0x96, 0x7E, 0xC2, 0x12, 0xB8, 0x20, 0xA8, 0x7F, 0xC2,
  // "6" (U+0036)
  0x18, 0xA5, 0xAF, 0x66, 0xB1, 0x09, 0xBD, 0x3A, 0x98, 0xA8, 0x98, 0xA2, 0xDD, 0x30,
  // "7" (U+0037)
  0x0B, 0xA0, 0xB2, 0x09, 0x07, 0x28, 0x3E, 0x20, 0x5C, 0x28, 0x4A, 0x60, 0x1F, 0x11,
  // "8" (U+0038)
  0x8A, 0x63, 0xDD, 0x38, 0x99, 0x73, 0xDD, 0x25, 0xCC, 0x5A, 0x77, 0xA5, 0xEE, 0x40,
  // "9" (U+0039)
  0x8A, 0x53, 0xDC, 0x1A, 0x79, 0x8A, 0x78, 0xA5, 0xFD, 0x90, 0x1B, 0x56, 0xF9, 0x10,
  // ":" (U+003A)
  0x06, 0x08, 0x60, 0x60, 0x80,
  // ";" (U+003B)
  0x06, 0x08, 0x48, 0x41, 0x17, 0x8A, 0x40,
  // "<" (U+003C)
  0x28, 0x73, 0x73, 0xBA, 0x37, 0xD6, 0x28, 0x11, 0x79,
  // "=" (U+003D)
  0x89, 0x2A, 0xEE, 0xA1, 0x11, 0x1A, 0xEE, 0xA8, 0x00, 0x10,
  // ">" (U+003E)
  0x07, 0x03, 0x28, 0x91, 0x3A, 0xB3, 0x06, 0xD7, 0x97, 0x11,
  // "?" (U+003F)
  0x89, 0x7A, 0xE9, 0x21, 0xF0, 0x6B, 0x0E, 0x10, 0x30, 0x2C, 0x10,
  // "@" (U+0040)
  0x18, 0xC0, 0x4D, 0xE9, 0x02, 0xDD, 0xFD, 0x87, 0x8B, 0x76, 0xC9, 0x69, 0x85, 0xB8, 0x4D, 0xAE,
  0x64, 0xB1, 0x02, 0x28, 0x28, 0xEF, 0x81,
  // "A" (U+0041)
  0x18, 0x18, 0xF2, 0x28, 0xA6, 0xCA, 0x60, 0x1D, 0x4A, 0x05, 0xFE, 0xE0, 0x98, 0x2D, 0x3D, 0x40,
  0xA7,
  // "B" (U+0042)
  0x06, 0xA8, 0x6A, 0x06, 0xB3, 0xF0, 0x6A, 0x89, 0x39, 0x06, 0xB3, 0xF1, 0x6B, 0x2F, 0x26, 0xA0,
  0x91,
  // "C" (U+0043)
  0x18, 0x79, 0xEB, 0x5D, 0x12, 0x89, 0x20, 0x80, 0x92, 0x86, 0x5D, 0x12, 0x0A, 0xEB,
  // "D" (U+0044)
  0x8B, 0x36, 0xFE, 0x80, 0x6B, 0x2E, 0x46, 0xA0, 0xA7, 0x6A, 0x0A, 0x76, 0xB2, 0xE3, 0x6F, 0xE7,
  0x10,
  // "E" (U+0045)
  0x06, 0xA8, 0x15, 0x6B, 0x28, 0x90, 0x6F, 0xE3, 0x6B, 0x10, 0x6B, 0x20, 0x6A, 0x05,
  // "F" (U+0046)
  0x06, 0xA8, 0x15, 0x6B, 0x28, 0x90, 0x6F, 0xE3, 0x6B, 0x10, 0x6A, 0x20, 0x60, 0xA2,
  // "G" (U+0047)
  0x18, 0xB3, 0x8E, 0xE3, 0x5E, 0x21, 0x08, 0x96, 0xE6, 0x89, 0x0A, 0x75, 0xD1, 0xA7, 0x09, 0xEE,
  0x50,
  // "H" (U+0048)
  0x8B, 0x46, 0xA0, 0x97, 0x6A, 0x09, 0x76, 0xFE, 0xF7, 0x6B, 0x1A, 0x76, 0xA0, 0x97, 0x6A, 0x09,
  0x70,
  // "I" (U+0049)
  0x8A, 0x0A, 0xF7, 0x2E, 0x02, 0xE0, 0x2E, 0x02, 0xE0, 0x9F, 0x60,
  // "J" (U+004A)
  0x18, 0xA5, 0x6A, 0x06, 0xA0, 0x6A, 0x06, 0xA0, 0x6A, 0x06, 0xA0, 0x8A, 0x7F, 0x50,
  // "K" (U+004B)
  0x8B, 0x46, 0xA1, 0xE3, 0x6A, 0x99, 0x06, 0xDF, 0x10, 0x6E, 0xE4, 0x06, 0xA7, 0xB0, 0x6A, 0x0E,
  0x30,
  // "L" (U+004C)
  0x06, 0x0A, 0x20, 0x60, 0xA2, 0x06, 0x0A, 0x20, 0x60, 0xA2, 0x83, 0x6B, 0x10, 0x6A, 0x07,
  // "M" (U+004D)
  0x8C, 0x16, 0xF3, 0x0A, 0xF6, 0xF8, 0x0D, 0xF6, 0xBC, 0x3B, 0xF6, 0x9D, 0x87, 0xF6, 0x99, 0xF3,
  0xF6, 0x95, 0xD1, 0x90,
  // "N" (U+004E)
  0x8B, 0x46, 0xF2, 0x2D, 0x6F, 0x92, 0xD6, 0xAE, 0x4D, 0x69, 0x9A, 0xD6, 0x92, 0xFD, 0x69, 0x0B,
  0xD0,
  // "O" (U+004F)
  0x18, 0xB3, 0xAE, 0xC1, 0x5D, 0x1A, 0x98, 0x90, 0x5B, 0x89, 0x05, 0xB5, 0xD1, 0xA9, 0x0A, 0xFC,
  0x10,
  // "P" (U+0050)
  0x89, 0x36, 0xFE, 0x66, 0xB5, 0xD6, 0xA4, 0xD6, 0xA8, 0x16, 0x6B, 0x20, 0x60, 0xA2,
  // "Q" (U+0051)
  0x18, 0xB3, 0xAE, 0xB1, 0x5D, 0x1A, 0x98, 0x90, 0x5C, 0x89, 0x05, 0xC5, 0xD1, 0xA9, 0x0A, 0xFE,
  0x12, 0x81, 0x1E, 0x23, 0x05, 0x04,
  // "R" (U+0052)
  0x89, 0x16, 0xFE, 0x80, 0x6B, 0x5E, 0x06, 0xA8, 0x97, 0x70, 0x6B, 0xB6, 0x06, 0xA5, 0xC0, 0x6A,
  0x0E, 0x30,
  // "S" (U+0053)
  0x89, 0x13, 0xDE, 0x49, 0x81, 0x16, 0xE5, 0x28, 0x91, 0x5E, 0x43, 0x1B, 0x69, 0xFC, 0x10,
  // "T" (U+0054)
  0x0D, 0xA8, 0x2A, 0x0A, 0x72, 0x0A, 0x07, 0x20, 0xA0, 0x72, 0x0A, 0x07, 0x20, 0xA0, 0x71,
  // "U" (U+0055)
  0x8B, 0x37, 0xA0, 0xA6, 0x7A, 0x0A, 0x67, 0xA0, 0xA6, 0x7A, 0x0A, 0x65, 0xC2, 0xD5, 0x0B, 0xEB,
  0x10,
  // "V" (U+0056)
  0x8A, 0x1D, 0x40, 0xD4, 0x97, 0x1F, 0x05, 0xB5, 0xC0, 0x1E, 0x87, 0x28, 0x1C, 0xD3, 0x20, 0x80,
  0xE2,
  // "W" (U+0057)
  0x8C, 0x0D, 0x34, 0xE0, 0x88, 0xA6, 0x7F, 0x1B, 0x57, 0x9A, 0xC5, 0xE2, 0x4B, 0xD6, 0x9E, 0x01,
  0xEC, 0x2E, 0xB2, 0x83, 0xD9, 0x0E, 0x81,
  // "X" (U+0058)
  0x89, 0x1A, 0x74, 0xD3, 0xDA, 0x60, 0xBE, 0x28, 0x91, 0xCE, 0x14, 0xDA, 0x7B, 0x63, 0xE0,
  // "Y" (U+0059)
  0x89, 0x5C, 0x53, 0xE6, 0xB9, 0x80, 0xEE, 0x20, 0x9B, 0x20, 0x70, 0x92, 0x07, 0x09, 0x10,
  // "Z" (U+005A)
  0x0B, 0xA0, 0x82, 0x83, 0xE3, 0x07, 0xA2, 0x83, 0xE3, 0x07, 0xA2, 0x0C, 0xA0, 0x90,
  // "[" (U+005B)
  0x8B, 0x08, 0xF5, 0x87, 0x08, 0x70, 0x87, 0x08, 0x70, 0x87, 0x08, 0x70, 0x8E, 0x40, 0x11,
  // "\" (U+005C)
  0x86, 0xB3, 0x06, 0x80, 0x1D, 0x28, 0x3A, 0x40, 0x5A, 0x20, 0xD0,
  // "]" (U+005D)
  0x8A, 0x0C, 0xF0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xEB, 0xF1, 0x10,
  // "^" (U+005E)
  0x10, 0x60, 0x82, 0x89, 0x1C, 0xD0, 0x4A, 0x76, 0xA4, 0x1C,
  // "_" (U+005F)
  0x0F, 0xE0, 0x90, 0xF1, 0x10,
  // "`" (U+0060)
  0x84, 0x45, 0x01, 0xC1,
  // "a" (U+0061)
  0x8A, 0x23, 0xDE, 0x30, 0x29, 0x84, 0xDE, 0x8A, 0x8A, 0x86, 0xEA, 0x80,
  // "b" (U+0062)
  0x07, 0x09, 0x20, 0x70, 0x82, 0x8A, 0x27, 0xCE, 0x77, 0xB4, 0xD7, 0x91, 0xF7, 0xB4, 0xD7, 0xBE,
  0x70,
  // "c" (U+0063)
  0x89, 0x01, 0xCE, 0x18, 0x91, 0x0A, 0x62, 0x86, 0x89, 0x10, 0x2D, 0xE1,
  // "d" (U+0064)
  0x20, 0x40, 0xC2, 0x8A, 0x44, 0xC2, 0xEB, 0xC8, 0x96, 0xCA, 0x63, 0xC8, 0x96, 0xC2, 0xEA, 0xC0,
  // "e" (U+0065)
  0x8A, 0x22, 0xDD, 0x28, 0x87, 0x8A, 0xEE, 0xA8, 0xA2, 0x21, 0xCF, 0x50,
  // "f" (U+0066)
  0x8A, 0x21, 0xDA, 0x5C, 0x0C, 0xF8, 0x5B, 0x05, 0xB0, 0x5B, 0x05, 0xB1,
  // "g" (U+0067)
  0x8B, 0x22, 0xEA, 0xC8, 0x96, 0xCA, 0x63, 0xC9, 0x96, 0xC3, 0xEB, 0xC1, 0x17, 0xA5, 0xED, 0x30,
  // "h" (U+0068)
  0x07, 0x09, 0x20, 0x70, 0x82, 0x8A, 0x27, 0xCE, 0x77, 0xB4, 0xD7, 0x92, 0xD7, 0x92, 0xD7, 0x92,
  0xD0,
  // "i" (U+0069)
  0x06, 0x07, 0x28, 0x90, 0x79, 0x79, 0x79, 0x79, 0x79,
  // "j" (U+006A)
  0x10, 0x60, 0x74, 0x8A, 0x27, 0x90, 0x79, 0x07, 0x90, 0x79, 0x07, 0x90, 0x98, 0x4E, 0x40,
  // "k" (U+006B)
  0x07, 0x09, 0x20, 0x70, 0x92, 0x8A, 0x27, 0x96, 0xB7, 0x9E, 0x27, 0xFE, 0x07, 0xAB, 0x67, 0x94,
  0xD0,
  // "l" (U+006C)
  0x89, 0x47, 0x97, 0x97, 0x97, 0x97, 0x97, 0x97, 0x90,
  // "m" (U+006D)
  0x8C, 0x17, 0x9E, 0x6D, 0xA0, 0x7B, 0x5E, 0x3F, 0x07, 0x94, 0xC0, 0xF1, 0x79, 0x4C, 0x0F, 0x17,
  0x94, 0xC0, 0xF1,
  // "n" (U+006E)
  0x8A, 0x27, 0xBE, 0x77, 0xB5, 0xD7, 0x92, 0xD7, 0x92, 0xD7, 0x92, 0xD0,
  // "o" (U+006F)
  0x8A, 0x21, 0xDE, 0x38, 0x96, 0xBA, 0x63, 0xD8, 0x96, 0xB1, 0xDE, 0x30,
  // "p" (U+0070)
  0x8A, 0x47, 0xAE, 0x77, 0xB4, 0xD7, 0x91, 0xF7, 0xB4, 0xD7, 0xCE, 0x77, 0x82, 0x07, 0x09, 0x20,
  // "q" (U+0071)
  0x8A, 0x22, 0xEA, 0xC8, 0x96, 0xCA, 0x63, 0xC9, 0x96, 0xC2, 0xEB, 0xC2, 0x04, 0x0C, 0x20, 0x40,
  0xC0,
  // "r" (U+0072)
  0x89, 0x47, 0xAC, 0x7C, 0x07, 0x90, 0x79, 0x07, 0x91,
  // "s" (U+0073)
  0x89, 0x55, 0xEB, 0xA8, 0x23, 0xE8, 0x23, 0xF9, 0xF9,
  // "t" (U+0074)
  0x8A, 0x02, 0xA0, 0xBF, 0x96, 0xA0, 0x6A, 0x06, 0xB0, 0x2E, 0x90,
  // "u" (U+0075)
  0x8A, 0x28, 0x93, 0xD8, 0x93, 0xD8, 0x93, 0xD7, 0xA5, 0xD2, 0xEA, 0xD0,
  // "v" (U+0076)
  0x89, 0x5D, 0x36, 0xA9, 0x79, 0x65, 0xAD, 0x21, 0xDD, 0x20, 0xC0, 0x91,
  // "w" (U+0077)
  0x8B, 0x3D, 0x3B, 0xA5, 0xB9, 0x6C, 0xC8, 0x86, 0xAB, 0xCA, 0x43, 0xE8, 0xAE, 0x10, 0xF5, 0x8D,
  0x10,
  // "x" (U+0078)
  0x8A, 0x2A, 0x7A, 0x73, 0xDE, 0x10, 0xDB, 0x04, 0xDE, 0x1B, 0x69, 0x80,
  // "y" (U+0079)
  0x89, 0x5D, 0x46, 0xA8, 0x89, 0x64, 0xBD, 0x20, 0xED, 0x28, 0x7A, 0x90, 0x1C, 0x50, 0xAB, 0x20,
  // "z" (U+007A)
  0x89, 0x3B, 0xFE, 0x07, 0x90, 0xE2, 0x7A, 0x0C, 0xA0,
  // "{" (U+007B)
  0x18, 0x93, 0x9B, 0x0E, 0x21, 0xF0, 0xC9, 0x03, 0xE2, 0x0E, 0x28, 0x3E, 0x10, 0xAB,
  // "|" (U+007C)
  0x8A, 0x09, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x40,
  // "}" (U+007D)
  0x83, 0xB9, 0x02, 0xE2, 0x98, 0x95, 0x10, 0xAC, 0x0E, 0x30, 0xE0, 0x1E, 0x0B, 0x91,
  // "~" (U+007E)
  0x82, 0xAE, 0xEA, 0x80, 0x01,
  // "¡" (U+00A1)
  0x06, 0x08, 0x28, 0x66, 0x87, 0x87, 0x98, 0xA0,
  // "¢" (U+00A2)
  0x18, 0x7C, 0xF4, 0x5C, 0x10, 0x79, 0x20, 0x60, 0xB2, 0x85, 0x1E, 0xD5, 0x01, 0x81,
  // "£" (U+00A3)
  0x18, 0x97, 0xAE, 0x61, 0xF1, 0x09, 0xFE, 0x22, 0xF1, 0x04, 0xC2, 0x09, 0xA0, 0xB0,
  // "¤" (U+00A4)
  0x38, 0xA0, 0x16, 0xDD, 0xC3, 0x93, 0x93, 0x81, 0xA6, 0xEE, 0xB1, 0x20, 0x10,
  // "¥" (U+00A5)
  0x8A, 0x5B, 0x66, 0xB5, 0xBB, 0x50, 0xEE, 0x06, 0xEE, 0x57, 0xEE, 0x60, 0x98, 0x10,
  // "¦" (U+00A6)
  0x86, 0x94, 0x94, 0x94, 0x94, 0x48, 0x49, 0x49, 0x49, 0x40,
  // "§" (U+00A7)
  0x8A, 0x34, 0xEC, 0x88, 0x24, 0xE8, 0x85, 0xC2, 0xCC, 0x21, 0xE7, 0xEA,
  // "¨" (U+00A8)
  0x82, 0x1A, 0x83,
  // "©" (U+00A9)
  0x18, 0x22, 0x88, 0x72, 0x89, 0x71, 0x98, 0xD8, 0x80, 0x73, 0xC2, 0x17, 0x18, 0x39, 0x28, 0x35,
  0x37, 0x3B, 0x28, 0x67, 0x11, 0x9A, 0xF8, 0x82, 0x82, 0x28, 0x86, 0x20,
  // "ª" (U+00AA)
  0x87, 0x5B, 0x48, 0xA6, 0x78, 0x50,
  // "«" (U+00AB)
  0x18, 0x95, 0xB2, 0xB8, 0x9B, 0x74, 0xC7, 0xA0, 0x51, 0x60,
  // "¬" (U+00AC)
  0x86, 0xAE, 0xEA, 0x11, 0x3A, 0x20, 0x10, 0x60,
  // "®" (U+00AE)
  0x18, 0x22, 0x88, 0x72, 0x8C, 0x01, 0x9D, 0xD6, 0x80, 0x71, 0xC6, 0x77, 0x18, 0x0D, 0xF3, 0x53,
  0x71, 0xC8, 0x47, 0x11, 0x95, 0x17, 0x82, 0x82, 0x28, 0x86, 0x20,
  // "¯" (U+00AF)
  0x0F, 0xE0, 0xC8, 0x00, 0x10,
  // "°" (U+00B0)
  0x87, 0x4D, 0x5A, 0x3B, 0x6F, 0x70,
  // "±" (U+00B1)
  0x10, 0x06, 0x28, 0x91, 0x66, 0x0A, 0xEE, 0xA1, 0x77, 0x14, 0x0B, 0xA0, 0xB0,
  // "²" (U+00B2)
  0x89, 0x27, 0xB2, 0x08, 0x43, 0xA0, 0xAC, 0x50,
  // "³" (U+00B3)
  0x89, 0x27, 0xB2, 0x17, 0x42, 0xD2, 0x7B, 0x30,
  // "´" (U+00B4)
  0x81, 0x4A, 0x11,
  // "µ" (U+00B5)
  0x8A, 0x47, 0x93, 0xD7, 0x93, 0xD7, 0x93, 0xD7, 0xA6, 0xD7, 0xEB, 0xD7, 0x82, 0x07, 0x09, 0x20,
  // "¶" (U+00B6)
  0x8A, 0x22, 0xEF, 0xC8, 0xFA, 0x99, 0xFA, 0x97, 0xFA, 0x91, 0x89, 0x92, 0x00, 0x92, 0x00, 0x92,
  0x00, 0x90,
  // "·" (U+00B7)
  0x06, 0x08,
  // "¸" (U+00B8)
  0x10, 0x12, 0x83, 0xA4, 0x1C, 0x30,
  // "¹" (U+00B9)
  0x87, 0x4E, 0x11, 0xB1, 0x0B, 0x10,
  // "º" (U+00BA)
  0x87, 0x7B, 0x4B, 0x38, 0x5B, 0x30,
  // "»" (U+00BB)
  0x89, 0x67, 0x69, 0x31, 0xE6, 0xD4, 0xC7, 0xA4, 0x25, 0x10,
  // "¼" (U+00BC)
  0x03, 0x0E, 0x20, 0xC2, 0x83, 0x5D, 0x05, 0x73, 0x83, 0xC0, 0xC1, 0x52, 0x83, 0xC4, 0x86, 0xD3,
  0x82, 0xB2, 0xAD, 0x28, 0x73, 0x93, 0xDF, 0x40, 0x21, 0x20, 0x41,
  // "½" (U+00BD)
  0x83, 0x5E, 0x01, 0xC2, 0x83, 0x2C, 0x07, 0x53, 0x89, 0x3C, 0x0C, 0x9B, 0x10, 0xC7, 0x62, 0xA1,
  0x28, 0x2C, 0x05, 0x72, 0x86, 0x67, 0x0E, 0xE4, 0x01, 0x20, 0x01, 0x10,
  // "¾" (U+00BE)
  0x89, 0x26, 0xD3, 0x0B, 0x10, 0x3F, 0x24, 0x92, 0x89, 0x31, 0x76, 0xB2, 0x80, 0xAE, 0x7A, 0x6E,
  0x38, 0x95, 0xA3, 0xAD, 0x10, 0x2B, 0x2D, 0xF5, 0x02, 0x22, 0x04, 0x10,
  // "¿" (U+00BF)
  0x18, 0x97, 0xC2, 0x03, 0x01, 0xE0, 0xC6, 0x0F, 0x12, 0x9E, 0xA0,
  // "À" (U+00C0)
  0x10, 0x40, 0x53, 0x81, 0x1C, 0x12, 0x81, 0x8F, 0x22, 0x8A, 0x6C, 0xA6, 0x01, 0xD4, 0xA0, 0x5F,
  0xEE, 0x09, 0x82, 0xD3, 0xD4, 0x0A, 0x70,
  // "Á" (U+00C1)
  0x10, 0x40, 0xA3, 0x01, 0x48, 0x18, 0xF2, 0x28, 0xA6, 0xCA, 0x60, 0x1D, 0x4A, 0x05, 0xFE, 0xE0,
  0x98, 0x2D, 0x3D, 0x40, 0xA7,
  // "Â" (U+00C2)
  0x20, 0x70, 0x22, 0x81, 0x69, 0xB2, 0x81, 0x8F, 0x22, 0x8A, 0x6C, 0xA6, 0x01, 0xD4, 0xA0, 0x5F,
  0xEE, 0x09, 0x82, 0xD3, 0xD4, 0x0A, 0x70,
  // "Ã" (U+00C3)
  0x18, 0x65, 0xA8, 0x10, 0x85, 0xB2, 0x81, 0x8F, 0x22, 0x8A, 0x6C, 0xA6, 0x01, 0xD4, 0xA0, 0x5F,
  0xEE, 0x09, 0x82, 0xD3, 0xD4, 0x0A, 0x70,
  // "Ä" (U+00C4)
  0x82, 0x1A, 0x83, 0x78, 0x18, 0xF2, 0x28, 0xA6, 0xCA, 0x60, 0x1D, 0x4A, 0x05, 0xFE, 0xE0, 0x98,
  0x2D, 0x3D, 0x40, 0xA7,
  // "Å" (U+00C5)
  0x10, 0x50, 0x93, 0xA0, 0x42, 0x8A, 0x6C, 0xB6, 0x01, 0xD4, 0xA0, 0x5F, 0xEE, 0x09, 0x82, 0xD3,
  0xD4, 0x0A, 0x70,
  // "Æ" (U+00C6)
  0x10, 0x3B, 0x84, 0xC0, 0x88, 0xF1, 0x28, 0xA1, 0xD2, 0xFE, 0x93, 0xFE, 0xF2, 0x08, 0x81, 0xF1,
  0x0D, 0x41, 0xA0, 0xC0,
  // "Ç" (U+00C7)
  0x18, 0x79, 0xEB, 0x5D, 0x12, 0x89, 0x20, 0x80, 0x92, 0x86, 0x5D, 0x12, 0x0A, 0xFB, 0x28, 0x4A,
  0x40, 0x1C, 0x30,
  // "È" (U+00C8)
  0x04, 0x05, 0x28, 0x31, 0xC1, 0x06, 0xA8, 0x15, 0x6B, 0x28, 0x90, 0x6F, 0xE3, 0x6B, 0x10, 0x6B,
  0x20, 0x6A, 0x05,
  // "É" (U+00C9)
  0x10, 0x40, 0xA2, 0x01, 0x20, 0x6A, 0x81, 0x56, 0xB2, 0x89, 0x06, 0xFE, 0x36, 0xB1, 0x06, 0xB2,
  0x06, 0xA0, 0x50,
  // "Ê" (U+00CA)
  0x18, 0x67, 0x20, 0x69, 0xB0, 0x6A, 0x81, 0x56, 0xB2, 0x89, 0x06, 0xFE, 0x36, 0xB1, 0x06, 0xB2,
  0x06, 0xA0, 0x50,
  // "Ë" (U+00CB)
  0x82, 0x1A, 0x83, 0x40, 0x6A, 0x81, 0x56, 0xB2, 0x89, 0x06, 0xFE, 0x36, 0xB1, 0x06, 0xB2, 0x06,
  0xA0, 0x50,
  // "Ì" (U+00CC)
  0x8A, 0x64, 0x50, 0x1C, 0x1A, 0xF7, 0x2E, 0x02, 0xE0, 0x2E, 0x02, 0xE0, 0x9F, 0x60,
  // "Í" (U+00CD)
  0x18, 0xA5, 0x4A, 0x01, 0x0A, 0xF7, 0x2E, 0x02, 0xE0, 0x2E, 0x02, 0xE0, 0x9F, 0x60,
  // "Î" (U+00CE)
  0x18, 0xA5, 0x72, 0x69, 0xBA, 0xF7, 0x2E, 0x02, 0xE0, 0x2E, 0x02, 0xE0, 0x9F, 0x60,
  // "Ï" (U+00CF)
  0x82, 0x1A, 0x83, 0x58, 0x4A, 0xF7, 0x02, 0xE2, 0x02, 0x0E, 0x20, 0x20, 0xE2, 0x02, 0x0E, 0x28,
  0x19, 0xF6,
  // "Ð" (U+00D0)
  0x8B, 0x36, 0xFE, 0x80, 0x6B, 0x2E, 0x4D, 0xF6, 0xA7, 0x7B, 0x0A, 0x76, 0xB2, 0xE3, 0x6F, 0xE7,
  0x10,
  // "Ñ" (U+00D1)
  0x18, 0xC5, 0x5A, 0x81, 0x08, 0x5B, 0x06, 0xF2, 0x2D, 0x6F, 0x92, 0xD6, 0xAE, 0x4D, 0x69, 0x9A,
  0xD6, 0x92, 0xFD, 0x69, 0x0B, 0xD0,
  // "Ò" (U+00D2)
  0x10, 0x40, 0x53, 0x81, 0x1C, 0x12, 0x8B, 0x3A, 0xEC, 0x15, 0xD1, 0xA9, 0x89, 0x05, 0xB8, 0x90,
  0x5B, 0x5D, 0x1A, 0x90, 0xAF, 0xC1,
  // "Ó" (U+00D3)
  0x20, 0x40, 0xA3, 0x01, 0x38, 0xB3, 0xAE, 0xC1, 0x5D, 0x1A, 0x98, 0x90, 0x5B, 0x89, 0x05, 0xB5,
  0xD1, 0xA9, 0x0A, 0xFC, 0x10,
  // "Ô" (U+00D4)
  0x20, 0x70, 0x22, 0x81, 0x69, 0xB2, 0x8B, 0x3A, 0xEC, 0x15, 0xD1, 0xA9, 0x89, 0x05, 0xB8, 0x90,
  0x5B, 0x5D, 0x1A, 0x90, 0xAF, 0xC1,
  // "Õ" (U+00D5)
  0x18, 0x65, 0xA8, 0x10, 0x85, 0xB2, 0x8B, 0x3A, 0xEC, 0x15, 0xD1, 0xA9, 0x89, 0x05, 0xB8, 0x90,
  0x5B, 0x5D, 0x1A, 0x90, 0xAF, 0xC1,
  // "Ö" (U+00D6)
  0x18, 0x21, 0xA8, 0x36, 0x8B, 0x3A, 0xEC, 0x15, 0xD1, 0xA9, 0x89, 0x05, 0xB8, 0x90, 0x5B, 0x5D,
  0x1A, 0x90, 0xAF, 0xC1,
  // "×" (U+00D7)
  0x89, 0x62, 0x11, 0x24, 0xCC, 0x41, 0xCC, 0x15, 0x44, 0x50,
  // "Ø" (U+00D8)
  0x48, 0xB7, 0x10, 0xAE, 0xD5, 0x5D, 0x1E, 0x88, 0x86, 0xAC, 0x8A, 0xA5, 0xC5, 0xF4, 0xA9, 0x1E,
  0xEB, 0x10, 0x13,
  // "Ù" (U+00D9)
  0x10, 0x40, 0x53, 0x8B, 0x71, 0xC1, 0x07, 0xA0, 0xA6, 0x7A, 0x0A, 0x67, 0xA0, 0xA6, 0x7A, 0x0A,
  0x65, 0xC2, 0xD5, 0x0B, 0xEB, 0x10,
  // "Ú" (U+00DA)
  0x20, 0x40, 0xA3, 0x01, 0x28, 0xB3, 0x7A, 0x0A, 0x67, 0xA0, 0xA6, 0x7A, 0x0A, 0x67, 0xA0, 0xA6,
  0x5C, 0x2D, 0x50, 0xBE, 0xB1,
  // "Û" (U+00DB)
  0x20, 0x70, 0x22, 0x8B, 0x76, 0x9B, 0x07, 0xA0, 0xA6, 0x7A, 0x0A, 0x67, 0xA0, 0xA6, 0x7A, 0x0A,
  0x65, 0xC2, 0xD5, 0x0B, 0xEB, 0x10,
  // "Ü" (U+00DC)
  0x82, 0x1A, 0x83, 0x68, 0xB3, 0x7A, 0x0A, 0x67, 0xA0, 0xA6, 0x7A, 0x0A, 0x67, 0xA0, 0xA6, 0x5C,
  0x2D, 0x50, 0xBE, 0xB1,
  // "Ý" (U+00DD)
  0x10, 0x40, 0xA2, 0x01, 0x28, 0x95, 0xC5, 0x3E, 0x6B, 0x98, 0x0E, 0xE2, 0x09, 0xB2, 0x07, 0x09,
  0x20, 0x70, 0x91,
  // "Þ" (U+00DE)
  0x06, 0x0A, 0x28, 0x93, 0x6F, 0xD5, 0x6B, 0x6D, 0x6A, 0x4D, 0x6A, 0x81, 0x66, 0xB2,
  // "ß" (U+00DF)
  0x8C, 0x11, 0xCE, 0x80, 0x6B, 0x3F, 0x07, 0x97, 0xA0, 0x79, 0xD5, 0x07, 0x95, 0xE2, 0x79, 0x1B,
  0x67, 0x9E, 0xD2,
  // "à" (U+00E0)
  0x04, 0x05, 0x28, 0xA6, 0x1C, 0x10, 0x3D, 0xE3, 0x02, 0x98, 0x4D, 0xE8, 0xA8, 0xA8, 0x6E, 0xA8,
  // "á" (U+00E1)
  0x10, 0x40, 0xA2, 0x01, 0x28, 0xA2, 0x3D, 0xE3, 0x02, 0x98, 0x4D, 0xE8, 0xA8, 0xA8, 0x6E, 0xA8,
  // "â" (U+00E2)
  0x18, 0xB1, 0x72, 0x06, 0x9B, 0x03, 0xDE, 0x30, 0x29, 0x84, 0xDE, 0x8A, 0x8A, 0x86, 0xEA, 0x80,
  // "ã" (U+00E3)
  0x8B, 0x25, 0xA8, 0x18, 0x5B, 0x03, 0xDE, 0x30, 0x29, 0x84, 0xDE, 0x8A, 0x8A, 0x86, 0xEA, 0x80,
  // "ä" (U+00E4)
  0x82, 0x1A, 0x83, 0x48, 0xA2, 0x3D, 0xE3, 0x02, 0x98, 0x4D, 0xE8, 0xA8, 0xA8, 0x6E, 0xA8,
  // "å" (U+00E5)
  0x10, 0x50, 0x92, 0x8A, 0x58, 0xE1, 0x3D, 0xE3, 0x02, 0x98, 0x4D, 0xE8, 0xA8, 0xA8, 0x6E, 0xA8,
  // "æ" (U+00E6)
  0x8B, 0x43, 0xDD, 0xBE, 0x30, 0x2A, 0xA5, 0xA4, 0xDE, 0xEE, 0xCA, 0x8A, 0xB2, 0x26, 0xE7, 0xAF,
  0x70,
  // "ç" (U+00E7)
  0x89, 0x01, 0xCE, 0x18, 0x91, 0x0A, 0x62, 0x89, 0x58, 0x91, 0x02, 0xEE, 0x10, 0xA4, 0x01, 0xC3,
  0x10,
  // "è" (U+00E8)
  0x04, 0x05, 0x28, 0xA6, 0x1C, 0x10, 0x2D, 0xD2, 0x88, 0x78, 0xAE, 0xEA, 0x8A, 0x22, 0x1C, 0xF5,
  // "é" (U+00E9)
  0x10, 0x40, 0xA2, 0x01, 0x28, 0xA2, 0x2D, 0xD2, 0x88, 0x78, 0xAE, 0xEA, 0x8A, 0x22, 0x1C, 0xF5,
  // "ê" (U+00EA)
  0x18, 0xB1, 0x72, 0x06, 0x9B, 0x02, 0xDD, 0x28, 0x87, 0x8A, 0xEE, 0xA8, 0xA2, 0x21, 0xCF, 0x50,
  // "ë" (U+00EB)
  0x82, 0x1A, 0x83, 0x48, 0xA2, 0x2D, 0xD2, 0x88, 0x78, 0xAE, 0xEA, 0x8A, 0x22, 0x1C, 0xF5,
  // "ì" (U+00EC)
  0x8A, 0x34, 0x50, 0x1C, 0x10, 0x79, 0x07, 0x90, 0x79, 0x07, 0x90, 0x79,
  // "í" (U+00ED)
  0x89, 0x44, 0xA1, 0x07, 0x97, 0x97, 0x97, 0x97, 0x90,
  // "î" (U+00EE)
  0x18, 0xA2, 0x72, 0x69, 0xB0, 0x79, 0x07, 0x90, 0x79, 0x07, 0x90, 0x79,
  // "ï" (U+00EF)
  0x82, 0x1A, 0x83, 0x50, 0x70, 0x92, 0x07, 0x09, 0x20, 0x70, 0x92, 0x07, 0x09, 0x20, 0x70, 0x91,
  // "ð" (U+00F0)
  0x18, 0xB5, 0x22, 0x10, 0x9E, 0x10, 0x6B, 0x41, 0xCD, 0xA8, 0xA7, 0xDA, 0x63, 0xD8, 0x96, 0xB1,
  0xDD, 0x30,
  // "ñ" (U+00F1)
  0x18, 0xB7, 0x5A, 0x81, 0x08, 0x5B, 0x07, 0xBE, 0x70, 0x7B, 0x5D, 0x07, 0x92, 0xD0, 0x79, 0x2D,
  0x07, 0x92, 0xD1,
  // "ò" (U+00F2)
  0x10, 0x40, 0x52, 0x8A, 0x51, 0xC1, 0x1D, 0xE3, 0x89, 0x6B, 0xA6, 0x3D, 0x89, 0x6B, 0x1D, 0xE3,
  // "ó" (U+00F3)
  0x10, 0x40, 0xA2, 0x01, 0x28, 0xA2, 0x1D, 0xE3, 0x89, 0x6B, 0xA6, 0x3D, 0x89, 0x6B, 0x1D, 0xE3,
  // "ô" (U+00F4)
  0x18, 0xB1, 0x72, 0x06, 0x9B, 0x01, 0xDE, 0x38, 0x96, 0xBA, 0x63, 0xD8, 0x96, 0xB1, 0xDE, 0x30,
  // "õ" (U+00F5)
  0x8B, 0x25, 0xA8, 0x18, 0x5B, 0x01, 0xDE, 0x38, 0x96, 0xBA, 0x63, 0xD8, 0x96, 0xB1, 0xDE, 0x30,
  // "ö" (U+00F6)
  0x82, 0x1A, 0x83, 0x48, 0xA2, 0x1D, 0xE3, 0x89, 0x6B, 0xA6, 0x3D, 0x89, 0x6B, 0x1D, 0xE3,
  // "÷" (U+00F7)
  0x18, 0x94, 0x56, 0x0A, 0xEE, 0xA1, 0x11, 0x10, 0x56, 0x10,
  // "ø" (U+00F8)
  0x38, 0xA5, 0x11, 0xCE, 0x88, 0x8B, 0xBA, 0x99, 0xD8, 0xE6, 0xB4, 0xEE, 0x31, 0x12,
  // "ù" (U+00F9)
  0x10, 0x40, 0x52, 0x8A, 0x51, 0xC1, 0x89, 0x3D, 0x89, 0x3D, 0x89, 0x3D, 0x7A, 0x5D, 0x2E, 0xAD,
  // "ú" (U+00FA)
  0x10, 0x40, 0xA2, 0x01, 0x28, 0xA2, 0x89, 0x3D, 0x89, 0x3D, 0x89, 0x3D, 0x7A, 0x5D, 0x2E, 0xAD,
  // "û" (U+00FB)
  0x28, 0xB0, 0x72, 0x06, 0x9B, 0x89, 0x3D, 0x89, 0x3D, 0x89, 0x3D, 0x7A, 0x5D, 0x2E, 0xAD,
  // "ü" (U+00FC)
  0x82, 0x1A, 0x83, 0x48, 0xA2, 0x89, 0x3D, 0x89, 0x3D, 0x89, 0x3D, 0x7A, 0x5D, 0x2E, 0xAD,
  // "ý" (U+00FD)
  0x10, 0x40, 0xA2, 0x01, 0x28, 0x95, 0xD4, 0x6A, 0x88, 0x96, 0x4B, 0xD2, 0x0E, 0xD2, 0x87, 0xA9,
  0x01, 0xC5, 0x0A, 0xB2,
  // "þ" (U+00FE)
  0x07, 0x09, 0x20, 0x70, 0x82, 0x8A, 0x47, 0xCE, 0x77, 0xB4, 0xD7, 0x91, 0xF7, 0xB4, 0xD7, 0xCE,
  0x77, 0x92, 0x07, 0x09, 0x20,
  // "ÿ" (U+00FF)
  0x82, 0x1A, 0x83, 0x48, 0x95, 0xD4, 0x6A, 0x88, 0x96, 0x4B, 0xD2, 0x0E, 0xD2, 0x87, 0xA9, 0x01,
  0xC5, 0x0A, 0xB2,
  // "Ā" (U+0100)
  0x18, 0x19, 0xE9, 0x20, 0x01, 0x38, 0x18, 0xF2, 0x28, 0xA6, 0xCA, 0x60, 0x1D, 0x4A, 0x05, 0xFE,
  0xE0, 0x98, 0x2D, 0x3D, 0x40, 0xA7,
  // "ā" (U+0101)
  0x18, 0xB1, 0x9E, 0x90, 0x11, 0x03, 0xDE, 0x30, 0x29, 0x84, 0xDE, 0x8A, 0x8A, 0x86, 0xEA, 0x80,
  // "Ă" (U+0102)
  0x18, 0x14, 0x04, 0x28, 0x16, 0xF8, 0x28, 0x18, 0xF2, 0x28, 0xA6, 0xCA, 0x60, 0x1D, 0x4A, 0x05,
  0xFE, 0xE0, 0x98, 0x2D, 0x3D, 0x40, 0xA7,
  // "ă" (U+0103)
  0x8B, 0x24, 0x04, 0x06, 0xF8, 0x03, 0xEE, 0x30, 0x29, 0x84, 0xDE, 0x8A, 0x8A, 0x86, 0xEA, 0x80,
  // "Ą" (U+0104)
  0x18, 0x18, 0xF2, 0x28, 0xA6, 0xCA, 0x60, 0x1D, 0x4A, 0x05, 0xFE, 0xE0, 0x98, 0x2D, 0x3D, 0x40,
  0xB9, 0x30, 0x70, 0x33, 0x08, 0x0B,
  // "ą" (U+0105)
  0x8A, 0x23, 0xDE, 0x30, 0x29, 0x84, 0xDE, 0x8A, 0x8A, 0x86, 0xEA, 0xB2, 0x07, 0x03, 0x20, 0x80,
  0xB0,
  // "Ć" (U+0106)
  0x20, 0x40, 0xA2, 0x01, 0x28, 0x79, 0xEB, 0x5D, 0x12, 0x89, 0x20, 0x80, 0x92, 0x86, 0x5D, 0x12,
  0x0A, 0xEB,
  // "ć" (U+0107)
  0x10, 0x40, 0xA2, 0x01, 0x28, 0x90, 0x1C, 0xE1, 0x89, 0x10, 0xA6, 0x28, 0x68, 0x91, 0x02, 0xDE,
  0x10,
  // "Ĉ" (U+0108)
  0x28, 0x96, 0x72, 0x06, 0x9B, 0x09, 0xEB, 0x5D, 0x12, 0x89, 0x20, 0x80, 0x92, 0x86, 0x5D, 0x12,
  0x0A, 0xEB,
  // "ĉ" (U+0109)
  0x18, 0x97, 0x72, 0x06, 0x9B, 0x01, 0xCE, 0x18, 0x91, 0x0A, 0x62, 0x86, 0x89, 0x10, 0x2D, 0xE1,
  // "Ċ" (U+010A)
  0x20, 0x80, 0x55, 0x87, 0x9E, 0xB5, 0xD1, 0x28, 0x92, 0x08, 0x09, 0x28, 0x65, 0xD1, 0x20, 0xAE,
  0xB0,
  // "ċ" (U+010B)
  0x10, 0x80, 0x55, 0x89, 0x01, 0xCE, 0x18, 0x91, 0x0A, 0x62, 0x86, 0x89, 0x10, 0x2D, 0xE1,
  // "Č" (U+010C)
  0x18, 0x97, 0x41, 0x60, 0x2E, 0x80, 0x9E, 0xB5, 0xD1, 0x28, 0x92, 0x08, 0x09, 0x28, 0x65, 0xD1,
  0x20, 0xAE, 0xB0,
  // "č" (U+010D)
  0x8A, 0x04, 0x16, 0x02, 0xE8, 0x01, 0xCE, 0x18, 0x91, 0x0A, 0x62, 0x86, 0x89, 0x10, 0x2D, 0xE1,
  // "Ď" (U+010E)
  0x18, 0x14, 0x16, 0x28, 0xB7, 0x2E, 0x80, 0x6F, 0xE8, 0x06, 0xB2, 0xE4, 0x6A, 0x0A, 0x76, 0xA0,
  0xA7, 0x6B, 0x2E, 0x36, 0xFE, 0x71,
  // "ď" (U+010F)
  0x28, 0x24, 0xCB, 0x22, 0x04, 0x0C, 0x28, 0x22, 0xEB, 0xC2, 0x82, 0x89, 0x6C, 0x28, 0x2A, 0x63,
  0xC2, 0x82, 0x89, 0x6C, 0x28, 0x22, 0xEA, 0xC2,
  // "Đ" (U+0110)
  0x8B, 0x36, 0xFE, 0x80, 0x6B, 0x2E, 0x4D, 0xF6, 0xA7, 0x7B, 0x0A, 0x76, 0xB2, 0xE3, 0x6F, 0xE7,
  0x10,
  // "đ" (U+0111)
  0x20, 0x40, 0xC2, 0x8B, 0x22, 0xEF, 0x42, 0xEB, 0xC0, 0x89, 0x6C, 0x0A, 0x63, 0xC0, 0x89, 0x6C,
  0x02, 0xEB, 0xC1,
  // "Ē" (U+0112)
  0x84, 0x9E, 0x90, 0x11, 0x20, 0x6A, 0x81, 0x56, 0xB2, 0x89, 0x06, 0xFE, 0x36, 0xB1, 0x06, 0xB2,
  0x06, 0xA0, 0x50,
  // "ē" (U+0113)
  0x18, 0xB1, 0x9E, 0x90, 0x11, 0x02, 0xDD, 0x28, 0x87, 0x8A, 0xEE, 0xA8, 0xA2, 0x21, 0xCF, 0x50,
  // "Ĕ" (U+0114)
  0x87, 0x40, 0x40, 0x6F, 0x80, 0x6A, 0x81, 0x56, 0xB2, 0x89, 0x06, 0xFE, 0x36, 0xB1, 0x06, 0xB2,
  0x06, 0xA0, 0x50,
  // "ĕ" (U+0115)
  0x8B, 0x24, 0x04, 0x06, 0xF8, 0x02, 0xDD, 0x28, 0x87, 0x8A, 0xEE, 0xA8, 0xA2, 0x21, 0xCF, 0x50,
  // "Ė" (U+0116)
  0x10, 0x80, 0x55, 0x06, 0xA8, 0x15, 0x6B, 0x28, 0x90, 0x6F, 0xE3, 0x6B, 0x10, 0x6B, 0x20, 0x6A,
  0x05,
  // "ė" (U+0117)
  0x10, 0x80, 0x55, 0x8A, 0x22, 0xDD, 0x28, 0x87, 0x8A, 0xEE, 0xA8, 0xA2, 0x21, 0xCF, 0x50,
  // "Ę" (U+0118)
  0x06, 0xA8, 0x15, 0x6B, 0x28, 0x90, 0x6F, 0xE3, 0x6B, 0x10, 0x6B, 0x20, 0x6A, 0x08, 0x20, 0x70,
  0x32, 0x08, 0x0B,
  // "ę" (U+0119)
  0x8A, 0x22, 0xDD, 0x28, 0x87, 0x8A, 0xEE, 0xA8, 0xA2, 0x21, 0xCF, 0x62, 0x0B, 0x30, 0xC0, 0x70,
  // "Ě" (U+011A)
  0x87, 0x41, 0x60, 0x2E, 0x80, 0x6A, 0x81, 0x56, 0xB2, 0x89, 0x06, 0xFE, 0x36, 0xB1, 0x06, 0xB2,
  0x06, 0xA0, 0x50,
  // "ě" (U+011B)
  0x8B, 0x24, 0x16, 0x02, 0xE8, 0x02, 0xDD, 0x28, 0x87, 0x8A, 0xEE, 0xA8, 0xA2, 0x21, 0xCF, 0x50,
  // "Ĝ" (U+011C)
  0x20, 0x70, 0x22, 0x81, 0x69, 0xB2, 0x8B, 0x38, 0xEE, 0x35, 0xE2, 0x10, 0x89, 0x6E, 0x68, 0x90,
  0xA7, 0x5D, 0x1A, 0x70, 0x9E, 0xE5,
  // "ĝ" (U+011D)
  0x28, 0xC0, 0x72, 0x06, 0x9B, 0x2E, 0xAC, 0x89, 0x6C, 0xA6, 0x3C, 0x99, 0x6C, 0x3E, 0xBC, 0x11,
  0x7A, 0x5E, 0xD3,
  // "Ğ" (U+011E)
  0x18, 0x14, 0x04, 0x28, 0x16, 0xF8, 0x28, 0xB3, 0x8F, 0xE3, 0x5E, 0x21, 0x08, 0x96, 0xE6, 0x89,
  0x0A, 0x75, 0xD1, 0xA7, 0x09, 0xEE, 0x50,
  // "ğ" (U+011F)
  0x18, 0xC1, 0x40, 0x40, 0x6F, 0x82, 0xEB, 0xC8, 0x96, 0xCA, 0x63, 0xC9, 0x96, 0xC3, 0xEB, 0xC1,
  0x17, 0xA5, 0xED, 0x30,
  // "Ġ" (U+0120)
  0x20, 0x80, 0x57, 0x8B, 0x38, 0xEE, 0x35, 0xE2, 0x10, 0x89, 0x6E, 0x68, 0x90, 0xA7, 0x5D, 0x1A,
  0x70, 0x9E, 0xE5,
  // "ġ" (U+0121)
  0x10, 0x80, 0x55, 0x8B, 0x22, 0xEA, 0xC8, 0x96, 0xCA, 0x63, 0xC9, 0x96, 0xC3, 0xEB, 0xC1, 0x17,
  0xA5, 0xED, 0x30,
  // "Ģ" (U+0122)
  0x18, 0xB3, 0x8E, 0xE3, 0x5E, 0x21, 0x08, 0x96, 0xE6, 0x89, 0x0A, 0x75, 0xD1, 0xA7, 0x09, 0xEE,
  0x57, 0x0B, 0x02, 0x10,
  // "ģ" (U+0123)
  0x10, 0xA0, 0x35, 0x8B, 0x22, 0xEA, 0xC8, 0x96, 0xCA, 0x63, 0xC9, 0x96, 0xC3, 0xEB, 0xC1, 0x17,
  0xA5, 0xED, 0x30,
  // "Ĥ" (U+0124)
  0x20, 0x70, 0x22, 0x8C, 0x06, 0x9B, 0x06, 0xA0, 0x97, 0x6A, 0x09, 0x76, 0xFE, 0xF7, 0x6B, 0x1A,
  0x76, 0xA0, 0x97, 0x6A, 0x09, 0x70,
  // "ĥ" (U+0125)
  0x10, 0x70, 0x22, 0x81, 0x69, 0xB3, 0x07, 0x09, 0x30, 0x70, 0x83, 0x8A, 0x67, 0xCE, 0x70, 0x7B,
  0x4D, 0x07, 0x92, 0xD0, 0x79, 0x2D, 0x07, 0x92, 0xD0,
  // "Ħ" (U+0126)
  0x8C, 0x1E, 0xFE, 0xFE, 0x17, 0xB1, 0xA8, 0x06, 0xFE, 0xF8, 0x06, 0xB1, 0xA8, 0x06, 0xA0, 0x98,
  0x06, 0xA0, 0x98, 0x10,
  // "ħ" (U+0127)
  0x07, 0x09, 0x28, 0xA6, 0xEF, 0x70, 0x7C, 0xE7, 0x7B, 0x5D, 0x79, 0x3D, 0x79, 0x3D, 0x79, 0x3D,
  // "Ĩ" (U+0128)
  0x89, 0x45, 0xA8, 0x18, 0x5B, 0x0A, 0xF7, 0x02, 0xE2, 0x02, 0x0E, 0x20, 0x20, 0xE2, 0x02, 0x0E,
  0x28, 0x19, 0xF6, 0x10,
  // "ĩ" (U+0129)
  0x85, 0x5A, 0x81, 0x85, 0xB2, 0x07, 0x09, 0x20, 0x70, 0x92, 0x07, 0x09, 0x20, 0x70, 0x92, 0x07,
  0x09, 0x10,
  // "Ī" (U+012A)
  0x8A, 0x69, 0xE9, 0x11, 0x0A, 0xF7, 0x2E, 0x02, 0xE0, 0x2E, 0x02, 0xE0, 0x9F, 0x60,
  // "ī" (U+012B)
  0x8A, 0x29, 0xE9, 0x11, 0x07, 0x90, 0x79, 0x07, 0x90, 0x79, 0x07, 0x91,
  // "Ĭ" (U+012C)
  0x8A, 0x64, 0x04, 0x6F, 0x8A, 0xF7, 0x2E, 0x02, 0xE0, 0x2E, 0x02, 0xE0, 0x9F, 0x60,
  // "ĭ" (U+012D)
  0x8A, 0x34, 0x04, 0x6F, 0x80, 0x89, 0x07, 0x90, 0x79, 0x07, 0x90, 0x79,
  // "Į" (U+012E)
  0x8A, 0x6A, 0xF7, 0x2E, 0x02, 0xE0, 0x2E, 0x02, 0xE0, 0x9F, 0x80, 0x73, 0x08, 0xB0,
  // "į" (U+012F)
  0x06, 0x07, 0x28, 0x94, 0x79, 0x79, 0x79, 0x79, 0x8B, 0x73, 0x8B,
  // "İ" (U+0130)
  0x10, 0x80, 0x53, 0x8A, 0x0A, 0xF7, 0x2E, 0x02, 0xE0, 0x2E, 0x02, 0xE0, 0x9F, 0x60,
  // "ı" (U+0131)
  0x89, 0x07, 0x97, 0x97, 0x97, 0x97, 0x90,
  // "Ĳ" (U+0132)
  0x8B, 0x4A, 0xF7, 0x6A, 0x2E, 0x06, 0xA2, 0xE0, 0x6A, 0x2E, 0x06, 0xA2, 0xE0, 0x6A, 0x9F, 0x66,
  0xA3, 0x08, 0x0A, 0x28, 0x17, 0xF5,
  // "ĳ" (U+0133)
  0x82, 0x67, 0x67, 0x48, 0xA2, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x28,
  0x49, 0x80, 0x4E, 0x40,
  // "Ĵ" (U+0134)
  0x18, 0xB3, 0x72, 0x69, 0xB0, 0x6A, 0x06, 0xA0, 0x6A, 0x06, 0xA0, 0x6A, 0x06, 0xA0, 0x8A, 0x7F,
  0x50,
  // "ĵ" (U+0135)
  0x18, 0xB0, 0x72, 0x69, 0xB0, 0x79, 0x07, 0x90, 0x79, 0x07, 0x90, 0x79, 0x09, 0x84, 0xE3,
  // "Ķ" (U+0136)
  0x8B, 0x46, 0xA1, 0xE3, 0x6A, 0x99, 0x06, 0xDF, 0x10, 0x6E, 0xE4, 0x06, 0xA7, 0xB0, 0x6A, 0x0E,
  0x37, 0x0B, 0x02, 0x10,
  // "ķ" (U+0137)
  0x07, 0x09, 0x20, 0x70, 0x92, 0x8A, 0x27, 0x96, 0xB7, 0x9E, 0x27, 0xFE, 0x07, 0xAB, 0x67, 0x94,
  0xD5, 0x0B, 0x02, 0x10,
  // "ĸ" (U+0138)
  0x8A, 0x27, 0x96, 0xB7, 0x9D, 0x27, 0xFE, 0x07, 0xAB, 0x67, 0x94, 0xD0,
  // "Ĺ" (U+0139)
  0x04, 0x0A, 0x20, 0x13, 0x06, 0x0A, 0x20, 0x60, 0xA2, 0x06, 0x0A, 0x20, 0x60, 0xA2, 0x83, 0x6B,
  0x10, 0x6A, 0x07,
  // "ĺ" (U+013A)
  0x8A, 0x04, 0xA1, 0x07, 0x97, 0x97, 0x97, 0x97, 0x97, 0x97, 0x90,
  // "Ļ" (U+013B)
  0x06, 0x0A, 0x20, 0x60, 0xA2, 0x06, 0x0A, 0x20, 0x60, 0xA2, 0x83, 0x6B, 0x10, 0x6A, 0x07, 0x50,
  0xB0, 0x21,
  // "ļ" (U+013C)
  0x89, 0x47, 0x97, 0x97, 0x97, 0x97, 0x97, 0x97, 0x92, 0x0B, 0x02,
  // "Ľ" (U+013D)
  0x28, 0x2B, 0x26, 0xA2, 0x06, 0x0A, 0x20, 0x60, 0xA2, 0x06, 0x0A, 0x28, 0x36, 0xB1, 0x06, 0xA0,
  0x70,
  // "ľ" (U+013E)
  0x84, 0x79, 0xB2, 0x79, 0x20, 0x70, 0x92, 0x07, 0x09, 0x20, 0x70, 0x92, 0x07, 0x09, 0x20, 0x70,
  0x92,
  // "Ŀ" (U+013F)
  0x06, 0x0A, 0x28, 0x46, 0xA8, 0x56, 0xA2, 0x06, 0x0A, 0x28, 0x36, 0xB1, 0x06, 0xA0, 0x70,
  // "ŀ" (U+0140)
  0x07, 0x09, 0x20, 0x70, 0x92, 0x84, 0x79, 0x85, 0x79, 0x20, 0x70, 0x92, 0x07, 0x09, 0x20, 0x70,
  0x92,
  // "Ł" (U+0141)
  0x05, 0x0C, 0x28, 0x90, 0x5C, 0x20, 0x5F, 0x80, 0xDC, 0x28, 0x35, 0xC1, 0x05, 0xA0, 0x80,
  // "ł" (U+0142)
  0x8A, 0x25, 0xB0, 0x5B, 0x05, 0xD1, 0x8E, 0x2D, 0xB0, 0x5B, 0x05, 0xB1,
  // "Ń" (U+0143)
  0x20, 0x40, 0xA3, 0x01, 0x28, 0xB4, 0x6F, 0x22, 0xD6, 0xF9, 0x2D, 0x6A, 0xE4, 0xD6, 0x99, 0xAD,
  0x69, 0x2F, 0xD6, 0x90, 0xBD,
  // "ń" (U+0144)
  0x10, 0x40, 0xA2, 0x01, 0x28, 0xA2, 0x7B, 0xE7, 0x7B, 0x5D, 0x79, 0x2D, 0x79, 0x2D, 0x79, 0x2D,
  // "Ņ" (U+0145)
  0x8B, 0x46, 0xF2, 0x2D, 0x6F, 0x92, 0xD6, 0xAE, 0x4D, 0x69, 0x9A, 0xD6, 0x92, 0xFD, 0x69, 0x0B,
  0xD7, 0x0B, 0x02, 0x10,
  // "ņ" (U+0146)
  0x8A, 0x27, 0xBE, 0x77, 0xB5, 0xD7, 0x92, 0xD7, 0x92, 0xD7, 0x92, 0xD5, 0x0B, 0x02, 0x10,
  // "Ň" (U+0147)
  0x18, 0x14, 0x16, 0x28, 0xC0, 0x2E, 0x80, 0x6F, 0x22, 0xD6, 0xF9, 0x2D, 0x6A, 0xE4, 0xD6, 0x99,
  0xAD, 0x69, 0x2F, 0xD6, 0x90, 0xBD,
  // "ň" (U+0148)
  0x18, 0xB1, 0x41, 0x60, 0x2E, 0x87, 0xBE, 0x77, 0xB5, 0xD7, 0x92, 0xD7, 0x92, 0xD7, 0x92, 0xD0,
  // "ŉ" (U+0149)
  0x07, 0x08, 0x38, 0xA7, 0xAC, 0xBE, 0x71, 0x7B, 0x5D, 0x07, 0x92, 0xD0, 0x79, 0x2D, 0x07, 0x92,
  0xD0,
  // "Ŋ" (U+014A)
  0x8B, 0x46, 0xF2, 0x2D, 0x6F, 0xA2, 0xD6, 0xAE, 0x6D, 0x69, 0x7D, 0xD6, 0x90, 0xED, 0x69, 0x06,
  0xD3, 0x04, 0x0C, 0x28, 0x14, 0xF7, 0x30, 0x11,
  // "ŋ" (U+014B)
  0x8A, 0x27, 0xBE, 0x77, 0xB5, 0xD7, 0x92, 0xD7, 0x92, 0xD7, 0x92, 0xD2, 0x04, 0x0D, 0x20, 0xE0,
  0x70,
  // "Ō" (U+014C)
  0x18, 0x19, 0xE9, 0x20, 0x01, 0x38, 0xB3, 0xAE, 0xC1, 0x5D, 0x1A, 0x98, 0x90, 0x5B, 0x89, 0x05,
  0xB5, 0xD1, 0xA9, 0x0A, 0xFC, 0x10,
  // "ō" (U+014D)
  0x18, 0xB1, 0x9E, 0x90, 0x11, 0x01, 0xDE, 0x38, 0x96, 0xBA, 0x63, 0xD8, 0x96, 0xB1, 0xDE, 0x30,
  // "Ŏ" (U+014E)
  0x18, 0x14, 0x04, 0x28, 0x16, 0xF8, 0x28, 0xB3, 0xAF, 0xC1, 0x5D, 0x1A, 0x98, 0x90, 0x5B, 0x89,
  0x05, 0xB5, 0xD1, 0xA9, 0x0A, 0xFC, 0x10,
  // "ŏ" (U+014F)
  0x18, 0xB1, 0x40, 0x40, 0x6F, 0x81, 0xDE, 0x38, 0x96, 0xBA, 0x63, 0xD8, 0x96, 0xB1, 0xDE, 0x30,
  // "Ő" (U+0150)
  0x18, 0x25, 0x9A, 0x16, 0x8B, 0x3A, 0xEC, 0x15, 0xD1, 0xA9, 0x89, 0x05, 0xB8, 0x90, 0x5B, 0x5D,
  0x1A, 0x90, 0xAF, 0xC1,
  // "ő" (U+0151)
  0x18, 0x25, 0x9A, 0x15, 0x8A, 0x61, 0xDE, 0x30, 0x89, 0x6B, 0x0A, 0x63, 0xD0, 0x89, 0x6B, 0x01,
  0xDE, 0x31,
  // "Œ" (U+0152)
  0x10, 0xAB, 0x8A, 0x6E, 0x5D, 0x1D, 0x30, 0x89, 0x0D, 0xEB, 0x89, 0x0D, 0x41, 0x5D, 0x1D, 0x32,
  0x0A, 0xB0, 0xE0,
  // "œ" (U+0153)
  0x8C, 0x01, 0xCD, 0x8E, 0x80, 0x89, 0x6E, 0x2E, 0x1A, 0x63, 0xFE, 0xF2, 0x89, 0x6F, 0x33, 0x01,
  0xDD, 0x8E, 0xD1,
  // "Ŕ" (U+0154)
  0x10, 0x40, 0xA3, 0x01, 0x38, 0x91, 0x6F, 0xE8, 0x06, 0xB5, 0xE0, 0x6A, 0x89, 0x77, 0x06, 0xBB,
  0x60, 0x6A, 0x5C, 0x06, 0xA0, 0xE3,
  // "ŕ" (U+0155)
  0x18, 0xA1, 0x4A, 0x01, 0x07, 0xAC, 0x7C, 0x07, 0x90, 0x79, 0x07, 0x91,
  // "Ŗ" (U+0156)
  0x89, 0x16, 0xFE, 0x80, 0x6B, 0x5E, 0x06, 0xA8, 0x97, 0x70, 0x6B, 0xB6, 0x06, 0xA5, 0xC0, 0x6A,
  0x0E, 0x37, 0x0B, 0x02, 0x10,
  // "ŗ" (U+0157)
  0x89, 0x47, 0xAC, 0x7C, 0x07, 0x90, 0x79, 0x07, 0x94, 0x0B, 0x02, 0x10,
  // "Ř" (U+0158)
  0x18, 0x14, 0x16, 0x28, 0x95, 0x2E, 0x80, 0x6F, 0xE8, 0x06, 0xB5, 0xE0, 0x6A, 0x89, 0x77, 0x06,
  0xBB, 0x60, 0x6A, 0x5C, 0x06, 0xA0, 0xE3,
  // "ř" (U+0159)
  0x8A, 0x24, 0x16, 0x2E, 0x87, 0xAC, 0x7C, 0x07, 0x90, 0x79, 0x07, 0x91,
  // "Ś" (U+015A)
  0x10, 0x40, 0xA2, 0x01, 0x28, 0x91, 0x3D, 0xE4, 0x98, 0x11, 0x6E, 0x52, 0x89, 0x15, 0xE4, 0x31,
  0xB6, 0x9F, 0xC1,
  // "ś" (U+015B)
  0x18, 0xA2, 0x4A, 0x01, 0x05, 0xEB, 0xA8, 0x23, 0xE8, 0x23, 0xF9, 0xF9,
  // "Ŝ" (U+015C)
  0x18, 0xA0, 0x72, 0x06, 0x9B, 0x03, 0xDE, 0x49, 0x81, 0x16, 0xE5, 0x28, 0x91, 0x5E, 0x43, 0x1B,
  0x69, 0xFC, 0x10,
  // "ŝ" (U+015D)
  0x18, 0xA2, 0x72, 0x69, 0xB5, 0xEB, 0xA8, 0x23, 0xE8, 0x23, 0xF9, 0xF9,
  // "Ş" (U+015E)
  0x89, 0x13, 0xDE, 0x49, 0x81, 0x16, 0xE5, 0x28, 0xA0, 0x5E, 0x43, 0x1B, 0x69, 0xFC, 0x10, 0xA4,
  0x01, 0xC3, 0x10,
  // "ş" (U+015F)
  0x8A, 0x35, 0xEB, 0xA8, 0x23, 0xE8, 0x23, 0xF9, 0xF9, 0x0A, 0x41, 0xC3,
  // "Š" (U+0160)
  0x8A, 0x14, 0x16, 0x02, 0xE8, 0x03, 0xDE, 0x49, 0x81, 0x16, 0xE5, 0x28, 0x91, 0x5E, 0x43, 0x1B,
  0x69, 0xFC, 0x10,
  // "š" (U+0161)
  0x8A, 0x34, 0x16, 0x2E, 0x85, 0xEB, 0xA8, 0x23, 0xE8, 0x23, 0xF9, 0xF9,
  // "Ţ" (U+0162)
  0x0D, 0xA8, 0x2A, 0x0A, 0x72, 0x0A, 0x07, 0x20, 0xA0, 0x72, 0x0A, 0x07, 0x20, 0xB0, 0x72, 0x84,
  0xA4, 0x01, 0xC3, 0x10,
  // "ţ" (U+0163)
  0x8A, 0x62, 0xA0, 0xBF, 0x96, 0xA0, 0x6A, 0x06, 0xB0, 0x2F, 0x90, 0xA4, 0x1C, 0x30,
  // "Ť" (U+0164)
  0x87, 0x41, 0x60, 0x2E, 0x80, 0xDA, 0x82, 0xA0, 0xA7, 0x20, 0xA0, 0x72, 0x0A, 0x07, 0x20, 0xA0,
  0x72, 0x0A, 0x07, 0x10,
  // "ť" (U+0165)
  0x38, 0x2B, 0x22, 0xA3, 0x81, 0xBF, 0x92, 0x06, 0x0A, 0x30, 0x60, 0xA3, 0x06, 0x0B, 0x38, 0x12,
  0xE9, 0x20,
  // "Ŧ" (U+0166)
  0x0D, 0xA8, 0x92, 0xA0, 0xA7, 0x06, 0xFE, 0x30, 0xA7, 0x20, 0xA0, 0x72, 0x0A, 0x07, 0x10,
  // "ŧ" (U+0167)
  0x8A, 0x02, 0xA0, 0xBF, 0x96, 0xA0, 0xCF, 0x76, 0xB1, 0x3E, 0x90,
  // "Ũ" (U+0168)
  0x18, 0xC4, 0x5A, 0x81, 0x08, 0x5B, 0x07, 0xA0, 0xA6, 0x7A, 0x0A, 0x67, 0xA0, 0xA6, 0x7A, 0x0A,
  0x65, 0xC2, 0xD5, 0x0B, 0xEB, 0x10,
  // "ũ" (U+0169)
  0x8B, 0x25, 0xA8, 0x18, 0x5B, 0x08, 0x93, 0xD8, 0x93, 0xD8, 0x93, 0xD7, 0xA5, 0xD2, 0xEA, 0xD0,
  // "Ū" (U+016A)
  0x18, 0x19, 0xE9, 0x20, 0x01, 0x28, 0xB3, 0x7A, 0x0A, 0x67, 0xA0, 0xA6, 0x7A, 0x0A, 0x67, 0xA0,
  0xA6, 0x5C, 0x2D, 0x50, 0xBE, 0xB1,
  // "ū" (U+016B)
  0x18, 0xB1, 0x9E, 0x90, 0x11, 0x08, 0x93, 0xD8, 0x93, 0xD8, 0x93, 0xD7, 0xA5, 0xD2, 0xEA, 0xD0,
  // "Ŭ" (U+016C)
  0x18, 0x14, 0x04, 0x28, 0xB7, 0x6F, 0x80, 0x7A, 0x0A, 0x67, 0xA0, 0xA6, 0x7A, 0x0A, 0x67, 0xA0,
  0xA6, 0x5C, 0x2D, 0x50, 0xBE, 0xB1,
  // "ŭ" (U+016D)
  0x18, 0xB1, 0x40, 0x40, 0x6F, 0x88, 0x93, 0xD8, 0x93, 0xD8, 0x93, 0xD7, 0xA5, 0xD2, 0xEA, 0xD0,
  // "Ů" (U+016E)
  0x10, 0x50, 0x93, 0x8B, 0x78, 0xE1, 0x07, 0xA0, 0xA6, 0x7A, 0x0A, 0x67, 0xA0, 0xA6, 0x7A, 0x0A,
  0x65, 0xC2, 0xD5, 0x0B, 0xEB, 0x10,
  // "ů" (U+016F)
  0x10, 0x50, 0x92, 0x8A, 0x58, 0xE1, 0x89, 0x3D, 0x89, 0x3D, 0x89, 0x3D, 0x7A, 0x5D, 0x2E, 0xAD,
  // "Ű" (U+0170)
  0x18, 0x25, 0x9A, 0x15, 0x8B, 0x37, 0xA0, 0xA6, 0x7A, 0x0A, 0x67, 0xA0, 0xA6, 0x7A, 0x0A, 0x65,
  0xC2, 0xD5, 0x0B, 0xEB, 0x10,
  // "ű" (U+0171)
  0x18, 0x25, 0x9A, 0x15, 0x8A, 0x68, 0x93, 0xD0, 0x89, 0x3D, 0x08, 0x93, 0xD0, 0x7A, 0x5D, 0x02,
  0xEA, 0xD1,
  // "Ų" (U+0172)
  0x8B, 0x37, 0xA0, 0xA6, 0x7A, 0x0A, 0x67, 0xA0, 0xA6, 0x7A, 0x0A, 0x65, 0xC2, 0xD4, 0x0B, 0xFB,
  0x30, 0x80, 0x33, 0x08, 0x0B, 0x10,
  // "ų" (U+0173)
  0x8A, 0x18, 0x93, 0xD8, 0x93, 0xD8, 0x93, 0xD7, 0xA5, 0xD2, 0xEB, 0x92, 0x07, 0x03, 0x20, 0x80,
  0xB0,
  // "Ŵ" (U+0174)
  0x30, 0x70, 0x24, 0x81, 0x69, 0xB2, 0x8C, 0x0D, 0x34, 0xE0, 0x88, 0xA6, 0x7F, 0x1B, 0x57, 0x9A,
  0xC5, 0xE2, 0x4B, 0xD6, 0x9E, 0x01, 0xEC, 0x2E, 0xB2, 0x83, 0xD9, 0x0E, 0x81,
  // "ŵ" (U+0175)
  0x20, 0x70, 0x23, 0x81, 0x69, 0xB2, 0x8B, 0x3D, 0x3B, 0xA5, 0xB9, 0x6C, 0xC8, 0x86, 0xAB, 0xCA,
  0x43, 0xE8, 0xAE, 0x10, 0xF5, 0x8D, 0x10,
  // "Ŷ" (U+0176)
  0x18, 0xA4, 0x72, 0x06, 0x9B, 0x0C, 0x53, 0xE6, 0xB9, 0x80, 0xEE, 0x20, 0x9B, 0x20, 0x70, 0x92,
  0x07, 0x09, 0x10,
  // "ŷ" (U+0177)
  0x18, 0xA4, 0x72, 0x06, 0x9B, 0x0D, 0x46, 0xA8, 0x89, 0x64, 0xBD, 0x20, 0xED, 0x28, 0x7A, 0x90,
  0x1C, 0x50, 0xAB, 0x20,
  // "Ÿ" (U+0178)
  0x82, 0x1A, 0x83, 0x48, 0x95, 0xC5, 0x3E, 0x6B, 0x98, 0x0E, 0xE2, 0x09, 0xB2, 0x07, 0x09, 0x20,
  0x70, 0x91,
  // "Ź" (U+0179)
  0x10, 0x40, 0xA2, 0x01, 0x20, 0xBA, 0x08, 0x28, 0x3E, 0x30, 0x7A, 0x28, 0x3E, 0x30, 0x7A, 0x20,
  0xCA, 0x09,
  // "ź" (U+017A)
  0x18, 0xA0, 0x4A, 0x01, 0x0B, 0xFE, 0x07, 0x90, 0xE2, 0x7A, 0x0C, 0xA0,
  // "Ż" (U+017B)
  0x10, 0x80, 0x55, 0x0B, 0xA0, 0x82, 0x83, 0xE3, 0x07, 0xA2, 0x83, 0xE3, 0x07, 0xA2, 0x0C, 0xA0,
  0x90,
  // "ż" (U+017C)
  0x10, 0x80, 0x53, 0x89, 0x3B, 0xFE, 0x07, 0x90, 0xE2, 0x7A, 0x0C, 0xA0,
  // "Ž" (U+017D)
  0x87, 0x41, 0x60, 0x2E, 0x80, 0xBA, 0x08, 0x28, 0x3E, 0x30, 0x7A, 0x28, 0x3E, 0x30, 0x7A, 0x20,
  0xCA, 0x09,
  // "ž" (U+017E)
  0x8A, 0x14, 0x16, 0x2E, 0x8B, 0xFE, 0x07, 0x90, 0xE2, 0x7A, 0x0C, 0xA0,
  // "ſ" (U+017F)
  0x8A, 0x22, 0xE9, 0x6B, 0x06, 0xA0, 0x6A, 0x06, 0xA0, 0x6A, 0x06, 0xA1,
  // "Ω" (U+03A9)
  0x18, 0xB1, 0xAE, 0xC2, 0x6C, 0x19, 0xA9, 0x80, 0x4C, 0x79, 0x06, 0xB1, 0xD1, 0xB3, 0xCF, 0x5A,
  // "μ" (U+03BC)
  0x8A, 0x47, 0x93, 0xD7, 0x93, 0xD7, 0x93, 0xD7, 0xA6, 0xD7, 0xEB, 0xD7, 0x82, 0x07, 0x09, 0x20,
  // "π" (U+03C0)
  0x0C, 0xB8, 0xA3, 0xB3, 0xD1, 0xF0, 0x3D, 0x1F, 0x03, 0xD1, 0xF1, 0x3D, 0x0C, 0x90,
  // "–" (U+2013)
  0x82, 0xAE, 0xEA, 0x80, 0x01,
  // "—" (U+2014)
  0x0A, 0x80, 0x2E, 0x0A, 0x80, 0x41,
  // "€" (U+20AC)
  0x18, 0xA5, 0x8E, 0x92, 0xE1, 0x1C, 0xFE, 0x0D, 0xFC, 0x03, 0xE2, 0x10, 0x8E, 0x90,
  // "₿" (U+20BF)
  0x18, 0x92, 0x77, 0x06, 0xFE, 0x46, 0xA8, 0x96, 0xA8, 0x96, 0x36, 0xA8, 0xA6, 0xA7, 0xB6, 0xFE,
  0x40, 0x66, 0x10,
  // "‘" (U+2018)
  0x83, 0x58, 0xA6, 0x11,
  // "’" (U+2019)
  0x83, 0x78, 0xA4, 0x11,
  // "‚" (U+201A)
  0x83, 0x78, 0xA4, 0x11,
  // "‛" (U+201B)
  0x84, 0xA5, 0x68, 0x01,
  // "“" (U+201C)
  0x89, 0x15, 0x8A, 0x4A, 0x6E, 0x11, 0x02, 0x10,
  // "”" (U+201D)
  0x89, 0x18, 0x8C, 0x3A, 0x4E, 0x01, 0x01, 0x10,
  // "„" (U+201E)
  0x89, 0x18, 0x8C, 0x3A, 0x4E, 0x01, 0x01, 0x10,
  // "‟" (U+201F)
  0x89, 0x1A, 0x6F, 0x16, 0x8B, 0x30, 0x11, 0x10,
  // "†" (U+2020)
  0x18, 0x94, 0x86, 0x01, 0x75, 0x17, 0xDD, 0x60, 0x64, 0x20, 0x70, 0x52, 0x07, 0x06, 0x20, 0x80,
  0x71,
  // "‡" (U+2021)
  0x18, 0xB0, 0x77, 0x03, 0x88, 0x26, 0xBB, 0x50, 0x76, 0x05, 0xAA, 0x43, 0x99, 0x30, 0x77, 0x10,
  // "•" (U+2022)
  0x87, 0x5E, 0x69, 0xFA, 0x3C, 0x40,
  // "…" (U+2026)
  0x84, 0x68, 0x68, 0x68,
  // "‰" (U+2030)
  0x83, 0x5E, 0x32, 0xA4, 0x83, 0xB7, 0x98, 0x44, 0x8A, 0x0B, 0x69, 0xCA, 0xA1, 0xC7, 0x6F, 0xA8,
  0xBA, 0x87, 0xD2, 0x89, 0x6B, 0x2B, 0xA8, 0x8D, 0x03, 0x90, 0xBC, 0x1D, 0x80,
  // "‹" (U+2039)
  0x18, 0x5B, 0x18, 0x90, 0x4C, 0x20, 0x50, 0x10,
  // "›" (U+203A)
  0x89, 0x17, 0x60, 0x1E, 0x24, 0xC0, 0x42, 0x10,
  // "⁄" (U+2044)
  0x30, 0xB0, 0x12, 0x04, 0x09, 0x30, 0xB0, 0x12, 0x04, 0x09, 0x30, 0xB0, 0x22, 0x03, 0x09, 0x30,
  // "™" (U+2122)
  0x8A, 0x09, 0xA8, 0x39, 0x23, 0x69, 0x9C, 0x33, 0x47, 0x75, 0x20,
  // "⅒" (U+2152)
  0x40, 0xB0, 0x13, 0x83, 0x4E, 0x14, 0x94, 0x8A, 0x01, 0xB1, 0xB1, 0x05, 0xC2, 0x0B, 0x59, 0x4E,
  0xD5, 0x82, 0x89, 0x0B, 0x21, 0xBD, 0x58, 0x03, 0x92, 0x82, 0xB6, 0xC3,
  // "ﬁ" (U+FB01)
  0x85, 0x1D, 0xA6, 0x75, 0xC3, 0x8A, 0x7C, 0xF8, 0x79, 0x5B, 0x07, 0x95, 0xB0, 0x79, 0x5B, 0x07,
  0x95, 0xB0, 0x79,
  // "ﬂ" (U+FB02)
  0x8C, 0x11, 0xDA, 0x79, 0x5C, 0x07, 0x9C, 0xF8, 0x79, 0x5B, 0x07, 0x95, 0xB0, 0x79, 0x5B, 0x07,
  0x95, 0xB0, 0x79,
};

const Font& font_NotoSans_CondensedBold_8() {
  static SmoothFont font(font_NotoSans_CondensedBold_8_data);
  return font;
}

}  // namespace roo_display
