#include "18.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSans-Bold (Noto Sans Bold)
// Generated on Thu Mar 30 22:28:09 CEST 2023
static const uint8_t font_NotoSans_Bold_18_data[] PROGMEM = {
  
  // Header
  0x01, 0x01, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x07, 0x9D,
  0xFC, 0xFC, 0x16, 0x12, 0x0E, 0xFC, 0x05, 0x02, 0x17, 0x06, 0x05, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x01, 0x01, 0x04, 0x0D, 0x05, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x01, 0x09, 0x07, 0x0D, 0x09, 0x00, 0x1C, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x0B, 0x0D, 0x0C, 0x00, 0x30, // "#" (U+0023)
  0x00, 0x24, 0x00, 0x00, 0x09, 0x0E, 0x0A, 0x00, 0x6B, // "$" (U+0024)
  0x00, 0x25, 0x00, 0x01, 0x0F, 0x0D, 0x10, 0x00, 0xAC, // "%" (U+0025)
  0x00, 0x26, 0x00, 0x01, 0x0D, 0x0D, 0x0E, 0x01, 0x10, // "&" (U+0026)
  0x00, 0x27, 0x01, 0x09, 0x03, 0x0D, 0x05, 0x01, 0x5B, // "'" (U+0027)
  0x00, 0x28, 0x00, 0xFE, 0x05, 0x0D, 0x06, 0x01, 0x64, // "(" (U+0028)
  0x00, 0x29, 0x00, 0xFE, 0x05, 0x0D, 0x06, 0x01, 0x94, // ")" (U+0029)
  0x00, 0x2A, 0x00, 0x06, 0x09, 0x0E, 0x0A, 0x01, 0xC3, // "*" (U+002A)
  0x00, 0x2B, 0x00, 0x03, 0x09, 0x0B, 0x0A, 0x01, 0xEC, // "+" (U+002B)
  0x00, 0x2C, 0x00, 0xFF, 0x03, 0x02, 0x05, 0x02, 0x0A, // "," (U+002C)
  0x00, 0x2D, 0x00, 0x05, 0x05, 0x07, 0x06, 0x02, 0x14, // "-" (U+002D)
  0x00, 0x2E, 0x01, 0x01, 0x04, 0x03, 0x05, 0x02, 0x1D, // "." (U+002E)
  0x00, 0x2F, 0x00, 0x01, 0x07, 0x0D, 0x07, 0x02, 0x25, // "/" (U+002F)
  0x00, 0x30, 0x00, 0x01, 0x09, 0x0D, 0x0A, 0x02, 0x4D, // "0" (U+0030)
  0x00, 0x31, 0x01, 0x01, 0x07, 0x0D, 0x0A, 0x02, 0x8F, // "1" (U+0031)
  0x00, 0x32, 0x00, 0x01, 0x09, 0x0D, 0x0A, 0x02, 0xB8, // "2" (U+0032)
  0x00, 0x33, 0x00, 0x01, 0x09, 0x0D, 0x0A, 0x02, 0xE9, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x01, 0x09, 0x0D, 0x0A, 0x03, 0x20, // "4" (U+0034)
  0x00, 0x35, 0x00, 0x01, 0x09, 0x0D, 0x0A, 0x03, 0x55, // "5" (U+0035)
  0x00, 0x36, 0x00, 0x01, 0x09, 0x0D, 0x0A, 0x03, 0x87, // "6" (U+0036)
  0x00, 0x37, 0x00, 0x01, 0x09, 0x0D, 0x0A, 0x03, 0xC5, // "7" (U+0037)
  0x00, 0x38, 0x00, 0x01, 0x09, 0x0D, 0x0A, 0x03, 0xEF, // "8" (U+0038)
  0x00, 0x39, 0x00, 0x01, 0x09, 0x0D, 0x0A, 0x04, 0x2F, // "9" (U+0039)
  0x00, 0x3A, 0x01, 0x01, 0x04, 0x0A, 0x05, 0x04, 0x6D, // ":" (U+003A)
  0x00, 0x3B, 0x00, 0xFF, 0x04, 0x0A, 0x05, 0x04, 0x7D, // ";" (U+003B)
  0x00, 0x3C, 0x00, 0x03, 0x09, 0x0C, 0x0A, 0x04, 0x93, // "<" (U+003C)
  0x00, 0x3D, 0x00, 0x05, 0x09, 0x0A, 0x0A, 0x04, 0xBC, // "=" (U+003D)
  0x00, 0x3E, 0x00, 0x03, 0x09, 0x0B, 0x0A, 0x04, 0xCF, // ">" (U+003E)
  0x00, 0x3F, 0x00, 0x01, 0x08, 0x0D, 0x09, 0x04, 0xF5, // "?" (U+003F)
  0x00, 0x40, 0x01, 0xFF, 0x0F, 0x0D, 0x10, 0x05, 0x20, // "@" (U+0040)
  0x00, 0x41, 0x00, 0x01, 0x0C, 0x0D, 0x0C, 0x05, 0x87, // "A" (U+0041)
  0x00, 0x42, 0x01, 0x01, 0x0B, 0x0D, 0x0C, 0x05, 0xC6, // "B" (U+0042)
  0x00, 0x43, 0x01, 0x01, 0x0A, 0x0D, 0x0B, 0x06, 0x07, // "C" (U+0043)
  0x00, 0x44, 0x01, 0x01, 0x0C, 0x0D, 0x0D, 0x06, 0x38, // "D" (U+0044)
  0x00, 0x45, 0x01, 0x01, 0x08, 0x0D, 0x0A, 0x06, 0x7F, // "E" (U+0045)
  0x00, 0x46, 0x01, 0x01, 0x08, 0x0D, 0x0A, 0x06, 0xA4, // "F" (U+0046)
  0x00, 0x47, 0x01, 0x01, 0x0B, 0x0D, 0x0D, 0x06, 0xCA, // "G" (U+0047)
  0x00, 0x48, 0x01, 0x01, 0x0C, 0x0D, 0x0E, 0x07, 0x0B, // "H" (U+0048)
  0x00, 0x49, 0x00, 0x01, 0x06, 0x0D, 0x07, 0x07, 0x4F, // "I" (U+0049)
  0x00, 0x4A, 0xFE, 0xFD, 0x04, 0x0D, 0x06, 0x07, 0x77, // "J" (U+004A)
  0x00, 0x4B, 0x01, 0x01, 0x0B, 0x0D, 0x0C, 0x07, 0xAA, // "K" (U+004B)
  0x00, 0x4C, 0x01, 0x01, 0x09, 0x0D, 0x0A, 0x07, 0xF1, // "L" (U+004C)
  0x00, 0x4D, 0x01, 0x01, 0x0F, 0x0D, 0x11, 0x08, 0x19, // "M" (U+004D)
  0x00, 0x4E, 0x01, 0x01, 0x0C, 0x0D, 0x0F, 0x08, 0x74, // "N" (U+004E)
  0x00, 0x4F, 0x01, 0x01, 0x0D, 0x0D, 0x0E, 0x08, 0xB7, // "O" (U+004F)
  0x00, 0x50, 0x01, 0x01, 0x0A, 0x0D, 0x0B, 0x08, 0xFE, // "P" (U+0050)
  0x00, 0x51, 0x01, 0xFE, 0x0D, 0x0D, 0x0E, 0x09, 0x34, // "Q" (U+0051)
  0x00, 0x52, 0x01, 0x01, 0x0B, 0x0D, 0x0C, 0x09, 0x87, // "R" (U+0052)
  0x00, 0x53, 0x00, 0x01, 0x09, 0x0D, 0x0A, 0x09, 0xCB, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x0A, 0x0D, 0x0A, 0x09, 0xFE, // "T" (U+0054)
  0x00, 0x55, 0x01, 0x01, 0x0C, 0x0D, 0x0E, 0x0A, 0x28, // "U" (U+0055)
  0x00, 0x56, 0x00, 0x01, 0x0B, 0x0D, 0x0C, 0x0A, 0x6E, // "V" (U+0056)
  0x00, 0x57, 0x00, 0x01, 0x11, 0x0D, 0x11, 0x0A, 0xB1, // "W" (U+0057)
  0x00, 0x58, 0x00, 0x01, 0x0B, 0x0D, 0x0C, 0x0B, 0x1D, // "X" (U+0058)
  0x00, 0x59, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x0B, 0x5F, // "Y" (U+0059)
  0x00, 0x5A, 0x00, 0x01, 0x09, 0x0D, 0x0A, 0x0B, 0x93, // "Z" (U+005A)
  0x00, 0x5B, 0x01, 0xFD, 0x05, 0x0D, 0x06, 0x0B, 0xBF, // "[" (U+005B)
  0x00, 0x5C, 0x00, 0x01, 0x07, 0x0D, 0x07, 0x0B, 0xEF, // "\" (U+005C)
  0x00, 0x5D, 0x00, 0xFD, 0x04, 0x0D, 0x06, 0x0C, 0x16, // "]" (U+005D)
  0x00, 0x5E, 0x00, 0x06, 0x09, 0x0E, 0x0A, 0x0C, 0x47, // "^" (U+005E)
  0x00, 0x5F, 0x00, 0xFD, 0x07, 0xFE, 0x07, 0x0C, 0x6F, // "_" (U+005F)
  0x00, 0x60, 0x00, 0x0C, 0x05, 0x0E, 0x07, 0x0C, 0x74, // "`" (U+0060)
  0x00, 0x61, 0x00, 0x01, 0x09, 0x0A, 0x0B, 0x0C, 0x7E, // "a" (U+0061)
  0x00, 0x62, 0x01, 0x01, 0x0A, 0x0E, 0x0B, 0x0C, 0xAD, // "b" (U+0062)
  0x00, 0x63, 0x00, 0x01, 0x08, 0x0A, 0x09, 0x0C, 0xEE, // "c" (U+0063)
  0x00, 0x64, 0x00, 0x01, 0x09, 0x0E, 0x0B, 0x0D, 0x13, // "d" (U+0064)
  0x00, 0x65, 0x00, 0x01, 0x09, 0x0A, 0x0B, 0x0D, 0x47, // "e" (U+0065)
  0x00, 0x66, 0x00, 0x01, 0x07, 0x0E, 0x07, 0x0D, 0x72, // "f" (U+0066)
  0x00, 0x67, 0x00, 0xFD, 0x09, 0x0A, 0x0B, 0x0D, 0xA3, // "g" (U+0067)
  0x00, 0x68, 0x01, 0x01, 0x0A, 0x0E, 0x0C, 0x0D, 0xE1, // "h" (U+0068)
  0x00, 0x69, 0x01, 0x01, 0x04, 0x0E, 0x05, 0x0E, 0x24, // "i" (U+0069)
  0x00, 0x6A, 0xFE, 0xFD, 0x04, 0x0E, 0x05, 0x0E, 0x44, // "j" (U+006A)
  0x00, 0x6B, 0x01, 0x01, 0x0A, 0x0E, 0x0B, 0x0E, 0x78, // "k" (U+006B)
  0x00, 0x6C, 0x01, 0x01, 0x04, 0x0E, 0x05, 0x0E, 0xB8, // "l" (U+006C)
  0x00, 0x6D, 0x01, 0x01, 0x10, 0x0A, 0x12, 0x0E, 0xDB, // "m" (U+006D)
  0x00, 0x6E, 0x01, 0x01, 0x0A, 0x0A, 0x0C, 0x0F, 0x2D, // "n" (U+006E)
  0x00, 0x6F, 0x00, 0x01, 0x0A, 0x0A, 0x0B, 0x0F, 0x64, // "o" (U+006F)
  0x00, 0x70, 0x01, 0xFD, 0x0A, 0x0A, 0x0B, 0x0F, 0x99, // "p" (U+0070)
  0x00, 0x71, 0x00, 0xFD, 0x09, 0x0A, 0x0B, 0x0F, 0xDC, // "q" (U+0071)
  0x00, 0x72, 0x01, 0x01, 0x07, 0x0A, 0x08, 0x10, 0x11, // "r" (U+0072)
  0x00, 0x73, 0x00, 0x01, 0x08, 0x0A, 0x09, 0x10, 0x33, // "s" (U+0073)
  0x00, 0x74, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x10, 0x5D, // "t" (U+0074)
  0x00, 0x75, 0x01, 0x01, 0x0A, 0x0A, 0x0C, 0x10, 0x87, // "u" (U+0075)
  0x00, 0x76, 0x00, 0x01, 0x0A, 0x0A, 0x0A, 0x10, 0xB8, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x01, 0x0F, 0x0A, 0x0F, 0x10, 0xE9, // "w" (U+0077)
  0x00, 0x78, 0x00, 0x01, 0x0A, 0x0A, 0x0A, 0x11, 0x37, // "x" (U+0078)
  0x00, 0x79, 0x00, 0xFD, 0x0A, 0x0A, 0x0A, 0x11, 0x6A, // "y" (U+0079)
  0x00, 0x7A, 0x00, 0x01, 0x08, 0x0A, 0x09, 0x11, 0xA9, // "z" (U+007A)
  0x00, 0x7B, 0x00, 0xFE, 0x06, 0x0D, 0x07, 0x11, 0xCA, // "{" (U+007B)
  0x00, 0x7C, 0x04, 0xFD, 0x05, 0x0E, 0x0A, 0x12, 0x01, // "|" (U+007C)
  0x00, 0x7D, 0x00, 0xFE, 0x06, 0x0D, 0x07, 0x12, 0x15, // "}" (U+007D)
  0x00, 0x7E, 0x00, 0x06, 0x09, 0x08, 0x0A, 0x12, 0x4B, // "~" (U+007E)
  0x00, 0xA1, 0x01, 0xFE, 0x04, 0x0A, 0x05, 0x12, 0x5A, // "¡" (U+00A1)
  0x00, 0xA2, 0x01, 0x01, 0x08, 0x0D, 0x0A, 0x12, 0x75, // "¢" (U+00A2)
  0x00, 0xA3, 0x00, 0x01, 0x09, 0x0D, 0x0A, 0x12, 0x9E, // "£" (U+00A3)
  0x00, 0xA4, 0x01, 0x03, 0x09, 0x0B, 0x0A, 0x12, 0xCD, // "¤" (U+00A4)
  0x00, 0xA5, 0x00, 0x01, 0x09, 0x0D, 0x0A, 0x12, 0xF6, // "¥" (U+00A5)
  0x00, 0xA6, 0x04, 0xFD, 0x05, 0x0E, 0x0A, 0x13, 0x2D, // "¦" (U+00A6)
  0x00, 0xA7, 0x00, 0x01, 0x07, 0x0E, 0x09, 0x13, 0x3F, // "§" (U+00A7)
  0x00, 0xA8, 0x02, 0x0C, 0x08, 0x0E, 0x0B, 0x13, 0x75, // "¨" (U+00A8)
  0x00, 0xA9, 0x00, 0x01, 0x0E, 0x0D, 0x0F, 0x13, 0x81, // "©" (U+00A9)
  0x00, 0xAA, 0x00, 0x07, 0x06, 0x0D, 0x07, 0x13, 0xDA, // "ª" (U+00AA)
  0x00, 0xAB, 0x00, 0x02, 0x0A, 0x09, 0x0B, 0x13, 0xF6, // "«" (U+00AB)
  0x00, 0xAC, 0x00, 0x03, 0x09, 0x08, 0x0A, 0x14, 0x23, // "¬" (U+00AC)
  0x00, 0xAE, 0x00, 0x01, 0x0E, 0x0D, 0x0F, 0x14, 0x36, // "®" (U+00AE)
  0x00, 0xAF, 0x00, 0x0F, 0x08, 0x11, 0x09, 0x14, 0x98, // "¯" (U+00AF)
  0x00, 0xB0, 0x00, 0x08, 0x06, 0x0E, 0x08, 0x14, 0x9C, // "°" (U+00B0)
  0x00, 0xB1, 0x00, 0x01, 0x09, 0x0B, 0x0A, 0x14, 0xB4, // "±" (U+00B1)
  0x00, 0xB2, 0x00, 0x08, 0x06, 0x0F, 0x07, 0x14, 0xDB, // "²" (U+00B2)
  0x00, 0xB3, 0x00, 0x08, 0x05, 0x0F, 0x07, 0x14, 0xF7, // "³" (U+00B3)
  0x00, 0xB4, 0x00, 0x0C, 0x05, 0x0E, 0x07, 0x15, 0x12, // "´" (U+00B4)
  0x00, 0xB5, 0x01, 0xFD, 0x0A, 0x0A, 0x0C, 0x15, 0x1C, // "µ" (U+00B5)
  0x00, 0xB6, 0x01, 0xFE, 0x0A, 0x0E, 0x0C, 0x15, 0x5E, // "¶" (U+00B6)
  0x00, 0xB7, 0x01, 0x06, 0x04, 0x08, 0x05, 0x15, 0xA3, // "·" (U+00B7)
  0x00, 0xB8, 0xFF, 0xFC, 0x03, 0x01, 0x04, 0x15, 0xAB, // "¸" (U+00B8)
  0x00, 0xB9, 0x01, 0x08, 0x05, 0x0F, 0x07, 0x15, 0xBD, // "¹" (U+00B9)
  0x00, 0xBA, 0x00, 0x07, 0x06, 0x0D, 0x07, 0x15, 0xD5, // "º" (U+00BA)
  0x00, 0xBB, 0x01, 0x02, 0x0A, 0x09, 0x0B, 0x15, 0xEE, // "»" (U+00BB)
  0x00, 0xBC, 0x00, 0x01, 0x0E, 0x0D, 0x0F, 0x16, 0x19, // "¼" (U+00BC)
  0x00, 0xBD, 0x00, 0x01, 0x0F, 0x0D, 0x10, 0x16, 0x72, // "½" (U+00BD)
  0x00, 0xBE, 0x00, 0x01, 0x0E, 0x0E, 0x0F, 0x16, 0xCC, // "¾" (U+00BE)
  0x00, 0xBF, 0x00, 0xFE, 0x08, 0x0A, 0x09, 0x17, 0x28, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x0C, 0x11, 0x0C, 0x17, 0x54, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x0C, 0x11, 0x0C, 0x17, 0xA0, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x01, 0x0C, 0x11, 0x0C, 0x17, 0xEB, // "Â" (U+00C2)
  0x00, 0xC3, 0x00, 0x01, 0x0C, 0x11, 0x0C, 0x18, 0x39, // "Ã" (U+00C3)
  0x00, 0xC4, 0x00, 0x01, 0x0C, 0x11, 0x0C, 0x18, 0x87, // "Ä" (U+00C4)
  0x00, 0xC5, 0x00, 0x01, 0x0C, 0x10, 0x0C, 0x18, 0xD4, // "Å" (U+00C5)
  0x00, 0xC6, 0x00, 0x01, 0x10, 0x0D, 0x11, 0x19, 0x1F, // "Æ" (U+00C6)
  0x00, 0xC7, 0x01, 0xFC, 0x0A, 0x0D, 0x0B, 0x19, 0x69, // "Ç" (U+00C7)
  0x00, 0xC8, 0x01, 0x01, 0x08, 0x11, 0x0A, 0x19, 0xAD, // "È" (U+00C8)
  0x00, 0xC9, 0x01, 0x01, 0x08, 0x11, 0x0A, 0x19, 0xDD, // "É" (U+00C9)
  0x00, 0xCA, 0x01, 0x01, 0x09, 0x11, 0x0A, 0x1A, 0x0C, // "Ê" (U+00CA)
  0x00, 0xCB, 0x01, 0x01, 0x08, 0x11, 0x0A, 0x1A, 0x44, // "Ë" (U+00CB)
  0x00, 0xCC, 0xFF, 0x01, 0x06, 0x11, 0x07, 0x1A, 0x76, // "Ì" (U+00CC)
  0x00, 0xCD, 0x00, 0x01, 0x06, 0x11, 0x07, 0x1A, 0xAA, // "Í" (U+00CD)
  0x00, 0xCE, 0xFF, 0x01, 0x07, 0x11, 0x07, 0x1A, 0xDC, // "Î" (U+00CE)
  0x00, 0xCF, 0x00, 0x01, 0x06, 0x11, 0x07, 0x1B, 0x15, // "Ï" (U+00CF)
  0x00, 0xD0, 0x00, 0x01, 0x0C, 0x0D, 0x0D, 0x1B, 0x49, // "Ð" (U+00D0)
  0x00, 0xD1, 0x01, 0x01, 0x0C, 0x11, 0x0F, 0x1B, 0x94, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x01, 0x01, 0x0D, 0x11, 0x0E, 0x1B, 0xE5, // "Ò" (U+00D2)
  0x00, 0xD3, 0x01, 0x01, 0x0D, 0x11, 0x0E, 0x1C, 0x38, // "Ó" (U+00D3)
  0x00, 0xD4, 0x01, 0x01, 0x0D, 0x11, 0x0E, 0x1C, 0x8A, // "Ô" (U+00D4)
  0x00, 0xD5, 0x01, 0x01, 0x0D, 0x11, 0x0E, 0x1C, 0xE0, // "Õ" (U+00D5)
  0x00, 0xD6, 0x01, 0x01, 0x0D, 0x11, 0x0E, 0x1D, 0x35, // "Ö" (U+00D6)
  0x00, 0xD7, 0x01, 0x03, 0x08, 0x0B, 0x0A, 0x1D, 0x8A, // "×" (U+00D7)
  0x00, 0xD8, 0x01, 0x00, 0x0D, 0x0E, 0x0E, 0x1D, 0xB0, // "Ø" (U+00D8)
  0x00, 0xD9, 0x01, 0x01, 0x0C, 0x11, 0x0E, 0x1E, 0x0A, // "Ù" (U+00D9)
  0x00, 0xDA, 0x01, 0x01, 0x0C, 0x11, 0x0E, 0x1E, 0x5D, // "Ú" (U+00DA)
  0x00, 0xDB, 0x01, 0x01, 0x0C, 0x11, 0x0E, 0x1E, 0xAE, // "Û" (U+00DB)
  0x00, 0xDC, 0x01, 0x01, 0x0C, 0x11, 0x0E, 0x1F, 0x03, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x01, 0x0A, 0x11, 0x0B, 0x1F, 0x57, // "Ý" (U+00DD)
  0x00, 0xDE, 0x01, 0x01, 0x0A, 0x0D, 0x0B, 0x1F, 0x96, // "Þ" (U+00DE)
  0x00, 0xDF, 0x01, 0x01, 0x0C, 0x0E, 0x0D, 0x1F, 0xCC, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x01, 0x09, 0x0E, 0x0B, 0x20, 0x1E, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x09, 0x0E, 0x0B, 0x20, 0x59, // "á" (U+00E1)
  0x00, 0xE2, 0x00, 0x01, 0x09, 0x0E, 0x0B, 0x20, 0x93, // "â" (U+00E2)
  0x00, 0xE3, 0x00, 0x01, 0x09, 0x0E, 0x0B, 0x20, 0xD1, // "ã" (U+00E3)
  0x00, 0xE4, 0x00, 0x01, 0x09, 0x0E, 0x0B, 0x21, 0x0E, // "ä" (U+00E4)
  0x00, 0xE5, 0x00, 0x01, 0x09, 0x0F, 0x0B, 0x21, 0x4B, // "å" (U+00E5)
  0x00, 0xE6, 0x00, 0x01, 0x0F, 0x0A, 0x11, 0x21, 0x8A, // "æ" (U+00E6)
  0x00, 0xE7, 0x00, 0xFC, 0x08, 0x0A, 0x09, 0x21, 0xCE, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x01, 0x09, 0x0E, 0x0B, 0x22, 0x05, // "è" (U+00E8)
  0x00, 0xE9, 0x00, 0x01, 0x09, 0x0E, 0x0B, 0x22, 0x3C, // "é" (U+00E9)
  0x00, 0xEA, 0x00, 0x01, 0x09, 0x0E, 0x0B, 0x22, 0x72, // "ê" (U+00EA)
  0x00, 0xEB, 0x00, 0x01, 0x09, 0x0E, 0x0B, 0x22, 0xAC, // "ë" (U+00EB)
  0x00, 0xEC, 0xFF, 0x01, 0x04, 0x0E, 0x05, 0x22, 0xE5, // "ì" (U+00EC)
  0x00, 0xED, 0x00, 0x01, 0x05, 0x0E, 0x05, 0x23, 0x0E, // "í" (U+00ED)
  0x00, 0xEE, 0xFE, 0x01, 0x06, 0x0E, 0x05, 0x23, 0x36, // "î" (U+00EE)
  0x00, 0xEF, 0xFF, 0x01, 0x05, 0x0E, 0x05, 0x23, 0x63, // "ï" (U+00EF)
  0x00, 0xF0, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x23, 0x8E, // "ð" (U+00F0)
  0x00, 0xF1, 0x01, 0x01, 0x0A, 0x0E, 0x0C, 0x23, 0xD5, // "ñ" (U+00F1)
  0x00, 0xF2, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x24, 0x1B, // "ò" (U+00F2)
  0x00, 0xF3, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x24, 0x5C, // "ó" (U+00F3)
  0x00, 0xF4, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x24, 0x9C, // "ô" (U+00F4)
  0x00, 0xF5, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x24, 0xE0, // "õ" (U+00F5)
  0x00, 0xF6, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x25, 0x24, // "ö" (U+00F6)
  0x00, 0xF7, 0x00, 0x03, 0x09, 0x0A, 0x0A, 0x25, 0x67, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x00, 0x0A, 0x0B, 0x0B, 0x25, 0x7E, // "ø" (U+00F8)
  0x00, 0xF9, 0x01, 0x01, 0x0A, 0x0E, 0x0C, 0x25, 0xB9, // "ù" (U+00F9)
  0x00, 0xFA, 0x01, 0x01, 0x0A, 0x0E, 0x0C, 0x25, 0xF6, // "ú" (U+00FA)
  0x00, 0xFB, 0x01, 0x01, 0x0A, 0x0E, 0x0C, 0x26, 0x31, // "û" (U+00FB)
  0x00, 0xFC, 0x01, 0x01, 0x0A, 0x0E, 0x0C, 0x26, 0x71, // "ü" (U+00FC)
  0x00, 0xFD, 0x00, 0xFD, 0x0A, 0x0E, 0x0A, 0x26, 0xB0, // "ý" (U+00FD)
  0x00, 0xFE, 0x01, 0xFD, 0x0A, 0x0E, 0x0B, 0x26, 0xFA, // "þ" (U+00FE)
  0x00, 0xFF, 0x00, 0xFD, 0x0A, 0x0E, 0x0A, 0x27, 0x47, // "ÿ" (U+00FF)
  0x01, 0x00, 0x00, 0x01, 0x0C, 0x11, 0x0C, 0x27, 0x94, // "Ā" (U+0100)
  0x01, 0x01, 0x00, 0x01, 0x09, 0x0E, 0x0B, 0x27, 0xDE, // "ā" (U+0101)
  0x01, 0x02, 0x00, 0x01, 0x0C, 0x11, 0x0C, 0x28, 0x17, // "Ă" (U+0102)
  0x01, 0x03, 0x00, 0x01, 0x09, 0x0E, 0x0B, 0x28, 0x65, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0xFD, 0x0C, 0x0D, 0x0C, 0x28, 0xA3, // "Ą" (U+0104)
  0x01, 0x05, 0x00, 0xFD, 0x09, 0x0A, 0x0B, 0x28, 0xF1, // "ą" (U+0105)
  0x01, 0x06, 0x01, 0x01, 0x0A, 0x11, 0x0B, 0x29, 0x2D, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x29, 0x69, // "ć" (U+0107)
  0x01, 0x08, 0x01, 0x01, 0x0A, 0x11, 0x0B, 0x29, 0x98, // "Ĉ" (U+0108)
  0x01, 0x09, 0x00, 0x01, 0x09, 0x0E, 0x09, 0x29, 0xD8, // "ĉ" (U+0109)
  0x01, 0x0A, 0x01, 0x01, 0x0A, 0x11, 0x0B, 0x2A, 0x0D, // "Ċ" (U+010A)
  0x01, 0x0B, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x2A, 0x47, // "ċ" (U+010B)
  0x01, 0x0C, 0x01, 0x01, 0x0A, 0x11, 0x0B, 0x2A, 0x74, // "Č" (U+010C)
  0x01, 0x0D, 0x00, 0x01, 0x09, 0x0E, 0x09, 0x2A, 0xB4, // "č" (U+010D)
  0x01, 0x0E, 0x01, 0x01, 0x0C, 0x11, 0x0D, 0x2A, 0xE9, // "Ď" (U+010E)
  0x01, 0x0F, 0x00, 0x01, 0x0D, 0x0E, 0x0B, 0x2B, 0x40, // "ď" (U+010F)
  0x01, 0x10, 0x00, 0x01, 0x0C, 0x0D, 0x0D, 0x2B, 0x7F, // "Đ" (U+0110)
  0x01, 0x11, 0x00, 0x01, 0x0B, 0x0E, 0x0C, 0x2B, 0xCA, // "đ" (U+0111)
  0x01, 0x12, 0x01, 0x01, 0x08, 0x11, 0x0A, 0x2C, 0x05, // "Ē" (U+0112)
  0x01, 0x13, 0x00, 0x01, 0x09, 0x0E, 0x0B, 0x2C, 0x34, // "ē" (U+0113)
  0x01, 0x14, 0x01, 0x01, 0x08, 0x11, 0x0A, 0x2C, 0x69, // "Ĕ" (U+0114)
  0x01, 0x15, 0x00, 0x01, 0x09, 0x0E, 0x0B, 0x2C, 0x9B, // "ĕ" (U+0115)
  0x01, 0x16, 0x01, 0x01, 0x08, 0x11, 0x0A, 0x2C, 0xD5, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x01, 0x09, 0x0E, 0x0B, 0x2D, 0x03, // "ė" (U+0117)
  0x01, 0x18, 0x01, 0xFD, 0x09, 0x0D, 0x0A, 0x2D, 0x37, // "Ę" (U+0118)
  0x01, 0x19, 0x00, 0xFD, 0x09, 0x0A, 0x0B, 0x2D, 0x6D, // "ę" (U+0119)
  0x01, 0x1A, 0x01, 0x01, 0x09, 0x11, 0x0A, 0x2D, 0xA5, // "Ě" (U+011A)
  0x01, 0x1B, 0x00, 0x01, 0x09, 0x0E, 0x0B, 0x2D, 0xDC, // "ě" (U+011B)
  0x01, 0x1C, 0x01, 0x01, 0x0B, 0x11, 0x0D, 0x2E, 0x16, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x00, 0xFD, 0x09, 0x0E, 0x0B, 0x2E, 0x65, // "ĝ" (U+011D)
  0x01, 0x1E, 0x01, 0x01, 0x0B, 0x11, 0x0D, 0x2E, 0xB2, // "Ğ" (U+011E)
  0x01, 0x1F, 0x00, 0xFD, 0x09, 0x0E, 0x0B, 0x2F, 0x02, // "ğ" (U+011F)
  0x01, 0x20, 0x01, 0x01, 0x0B, 0x11, 0x0D, 0x2F, 0x4F, // "Ġ" (U+0120)
  0x01, 0x21, 0x00, 0xFD, 0x09, 0x0E, 0x0B, 0x2F, 0x99, // "ġ" (U+0121)
  0x01, 0x22, 0x01, 0xFD, 0x0B, 0x0D, 0x0D, 0x2F, 0xE0, // "Ģ" (U+0122)
  0x01, 0x23, 0x00, 0xFD, 0x09, 0x0E, 0x0B, 0x30, 0x2C, // "ģ" (U+0123)
  0x01, 0x24, 0x01, 0x01, 0x0C, 0x11, 0x0E, 0x30, 0x74, // "Ĥ" (U+0124)
  0x01, 0x25, 0xFE, 0x01, 0x0A, 0x12, 0x0C, 0x30, 0xC7, // "ĥ" (U+0125)
  0x01, 0x26, 0x00, 0x01, 0x0D, 0x0D, 0x0E, 0x31, 0x1F, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x0A, 0x0E, 0x0C, 0x31, 0x65, // "ħ" (U+0127)
  0x01, 0x28, 0xFF, 0x01, 0x06, 0x11, 0x07, 0x31, 0xAA, // "Ĩ" (U+0128)
  0x01, 0x29, 0xFE, 0x01, 0x05, 0x0E, 0x05, 0x31, 0xE0, // "ĩ" (U+0129)
  0x01, 0x2A, 0x00, 0x01, 0x06, 0x11, 0x07, 0x32, 0x0B, // "Ī" (U+012A)
  0x01, 0x2B, 0xFF, 0x01, 0x05, 0x0E, 0x05, 0x32, 0x3C, // "ī" (U+012B)
  0x01, 0x2C, 0xFF, 0x01, 0x06, 0x11, 0x07, 0x32, 0x64, // "Ĭ" (U+012C)
  0x01, 0x2D, 0xFF, 0x01, 0x06, 0x0E, 0x05, 0x32, 0x9B, // "ĭ" (U+012D)
  0x01, 0x2E, 0x00, 0xFD, 0x06, 0x0D, 0x07, 0x32, 0xC7, // "Į" (U+012E)
  0x01, 0x2F, 0x00, 0xFD, 0x04, 0x0E, 0x05, 0x32, 0xFC, // "į" (U+012F)
  0x01, 0x30, 0x00, 0x01, 0x06, 0x11, 0x07, 0x33, 0x2D, // "İ" (U+0130)
  0x01, 0x31, 0x01, 0x01, 0x04, 0x0A, 0x05, 0x33, 0x5E, // "ı" (U+0131)
  0x01, 0x32, 0x00, 0xFD, 0x0B, 0x0D, 0x0D, 0x33, 0x77, // "Ĳ" (U+0132)
  0x01, 0x33, 0x01, 0xFD, 0x09, 0x0E, 0x0B, 0x33, 0xD1, // "ĳ" (U+0133)
  0x01, 0x34, 0xFE, 0xFD, 0x06, 0x11, 0x06, 0x34, 0x24, // "Ĵ" (U+0134)
  0x01, 0x35, 0xFE, 0xFD, 0x06, 0x0E, 0x05, 0x34, 0x66, // "ĵ" (U+0135)
  0x01, 0x36, 0x01, 0xFD, 0x0B, 0x0D, 0x0C, 0x34, 0xA1, // "Ķ" (U+0136)
  0x01, 0x37, 0x01, 0xFD, 0x0A, 0x0E, 0x0B, 0x34, 0xF3, // "ķ" (U+0137)
  0x01, 0x38, 0x01, 0x01, 0x0A, 0x0A, 0x0B, 0x35, 0x3C, // "ĸ" (U+0138)
  0x01, 0x39, 0x01, 0x01, 0x09, 0x11, 0x0A, 0x35, 0x71, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x00, 0x01, 0x05, 0x12, 0x05, 0x35, 0xA4, // "ĺ" (U+013A)
  0x01, 0x3B, 0x01, 0xFD, 0x09, 0x0D, 0x0A, 0x35, 0xD8, // "Ļ" (U+013B)
  0x01, 0x3C, 0x01, 0xFD, 0x04, 0x0E, 0x05, 0x36, 0x09, // "ļ" (U+013C)
  0x01, 0x3D, 0x01, 0x01, 0x09, 0x0D, 0x0A, 0x36, 0x34, // "Ľ" (U+013D)
  0x01, 0x3E, 0x01, 0x01, 0x07, 0x0E, 0x05, 0x36, 0x62, // "ľ" (U+013E)
  0x01, 0x3F, 0x01, 0x01, 0x09, 0x0D, 0x0A, 0x36, 0x8F, // "Ŀ" (U+013F)
  0x01, 0x40, 0x01, 0x01, 0x07, 0x0E, 0x07, 0x36, 0xBD, // "ŀ" (U+0140)
  0x01, 0x41, 0x00, 0x01, 0x09, 0x0D, 0x0A, 0x36, 0xEA, // "Ł" (U+0141)
  0x01, 0x42, 0x00, 0x01, 0x05, 0x0E, 0x05, 0x37, 0x18, // "ł" (U+0142)
  0x01, 0x43, 0x01, 0x01, 0x0C, 0x11, 0x0F, 0x37, 0x43, // "Ń" (U+0143)
  0x01, 0x44, 0x01, 0x01, 0x0A, 0x0E, 0x0C, 0x37, 0x91, // "ń" (U+0144)
  0x01, 0x45, 0x01, 0xFD, 0x0C, 0x0D, 0x0F, 0x37, 0xD3, // "Ņ" (U+0145)
  0x01, 0x46, 0x01, 0xFD, 0x0A, 0x0A, 0x0C, 0x38, 0x21, // "ņ" (U+0146)
  0x01, 0x47, 0x01, 0x01, 0x0C, 0x11, 0x0F, 0x38, 0x63, // "Ň" (U+0147)
  0x01, 0x48, 0x01, 0x01, 0x0A, 0x0E, 0x0C, 0x38, 0xB5, // "ň" (U+0148)
  0x01, 0x49, 0x00, 0x01, 0x0C, 0x0D, 0x0E, 0x38, 0xFB, // "ŉ" (U+0149)
  0x01, 0x4A, 0x01, 0xFD, 0x0C, 0x0D, 0x0F, 0x39, 0x43, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x01, 0xFD, 0x0A, 0x0A, 0x0C, 0x39, 0x91, // "ŋ" (U+014B)
  0x01, 0x4C, 0x01, 0x01, 0x0D, 0x11, 0x0E, 0x39, 0xD6, // "Ō" (U+014C)
  0x01, 0x4D, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x3A, 0x27, // "ō" (U+014D)
  0x01, 0x4E, 0x01, 0x01, 0x0D, 0x11, 0x0E, 0x3A, 0x67, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x3A, 0xBD, // "ŏ" (U+014F)
  0x01, 0x50, 0x01, 0x01, 0x0D, 0x11, 0x0E, 0x3B, 0x01, // "Ő" (U+0150)
  0x01, 0x51, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x3B, 0x58, // "ő" (U+0151)
  0x01, 0x52, 0x01, 0x01, 0x10, 0x0D, 0x12, 0x3B, 0x9D, // "Œ" (U+0152)
  0x01, 0x53, 0x00, 0x01, 0x10, 0x0A, 0x12, 0x3B, 0xED, // "œ" (U+0153)
  0x01, 0x54, 0x01, 0x01, 0x0B, 0x11, 0x0C, 0x3C, 0x38, // "Ŕ" (U+0154)
  0x01, 0x55, 0x01, 0x01, 0x07, 0x0E, 0x08, 0x3C, 0x87, // "ŕ" (U+0155)
  0x01, 0x56, 0x01, 0xFD, 0x0B, 0x0D, 0x0C, 0x3C, 0xB3, // "Ŗ" (U+0156)
  0x01, 0x57, 0x01, 0xFD, 0x07, 0x0A, 0x08, 0x3D, 0x01, // "ŗ" (U+0157)
  0x01, 0x58, 0x01, 0x01, 0x0B, 0x11, 0x0C, 0x3D, 0x2D, // "Ř" (U+0158)
  0x01, 0x59, 0x00, 0x01, 0x08, 0x0E, 0x08, 0x3D, 0x80, // "ř" (U+0159)
  0x01, 0x5A, 0x00, 0x01, 0x09, 0x11, 0x0A, 0x3D, 0xB2, // "Ś" (U+015A)
  0x01, 0x5B, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x3D, 0xF0, // "ś" (U+015B)
  0x01, 0x5C, 0x00, 0x01, 0x09, 0x11, 0x0A, 0x3E, 0x24, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x3E, 0x66, // "ŝ" (U+015D)
  0x01, 0x5E, 0x00, 0xFC, 0x09, 0x0D, 0x0A, 0x3E, 0x9F, // "Ş" (U+015E)
  0x01, 0x5F, 0x00, 0xFC, 0x08, 0x0A, 0x09, 0x3E, 0xE5, // "ş" (U+015F)
  0x01, 0x60, 0x00, 0x01, 0x09, 0x11, 0x0A, 0x3F, 0x21, // "Š" (U+0160)
  0x01, 0x61, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x3F, 0x63, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFC, 0x0A, 0x0D, 0x0A, 0x3F, 0x9B, // "Ţ" (U+0162)
  0x01, 0x63, 0x00, 0xFC, 0x07, 0x0C, 0x08, 0x3F, 0xD8, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x0A, 0x11, 0x0A, 0x40, 0x15, // "Ť" (U+0164)
  0x01, 0x65, 0x00, 0x01, 0x0A, 0x0E, 0x08, 0x40, 0x4E, // "ť" (U+0165)
  0x01, 0x66, 0x00, 0x01, 0x0A, 0x0D, 0x0A, 0x40, 0x86, // "Ŧ" (U+0166)
  0x01, 0x67, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x40, 0xB3, // "ŧ" (U+0167)
  0x01, 0x68, 0x01, 0x01, 0x0C, 0x11, 0x0E, 0x40, 0xDE, // "Ũ" (U+0168)
  0x01, 0x69, 0x01, 0x01, 0x0A, 0x0E, 0x0C, 0x41, 0x33, // "ũ" (U+0169)
  0x01, 0x6A, 0x01, 0x01, 0x0C, 0x11, 0x0E, 0x41, 0x72, // "Ū" (U+016A)
  0x01, 0x6B, 0x01, 0x01, 0x0A, 0x0E, 0x0C, 0x41, 0xC3, // "ū" (U+016B)
  0x01, 0x6C, 0x01, 0x01, 0x0C, 0x11, 0x0E, 0x41, 0xFE, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x01, 0x01, 0x0A, 0x0E, 0x0C, 0x42, 0x53, // "ŭ" (U+016D)
  0x01, 0x6E, 0x01, 0x01, 0x0C, 0x12, 0x0E, 0x42, 0x93, // "Ů" (U+016E)
  0x01, 0x6F, 0x01, 0x01, 0x0A, 0x0F, 0x0C, 0x42, 0xEA, // "ů" (U+016F)
  0x01, 0x70, 0x01, 0x01, 0x0C, 0x11, 0x0E, 0x43, 0x2B, // "Ű" (U+0170)
  0x01, 0x71, 0x01, 0x01, 0x0B, 0x0E, 0x0C, 0x43, 0x81, // "ű" (U+0171)
  0x01, 0x72, 0x01, 0xFD, 0x0C, 0x0D, 0x0E, 0x43, 0xC6, // "Ų" (U+0172)
  0x01, 0x73, 0x01, 0xFD, 0x0A, 0x0A, 0x0C, 0x44, 0x19, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x11, 0x11, 0x11, 0x44, 0x56, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x0F, 0x0E, 0x0F, 0x44, 0xD3, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x01, 0x0A, 0x11, 0x0B, 0x45, 0x32, // "Ŷ" (U+0176)
  0x01, 0x77, 0x00, 0xFD, 0x0A, 0x0E, 0x0A, 0x45, 0x75, // "ŷ" (U+0177)
  0x01, 0x78, 0x00, 0x01, 0x0A, 0x11, 0x0B, 0x45, 0xC3, // "Ÿ" (U+0178)
  0x01, 0x79, 0x00, 0x01, 0x09, 0x11, 0x0A, 0x46, 0x05, // "Ź" (U+0179)
  0x01, 0x7A, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x46, 0x3B, // "ź" (U+017A)
  0x01, 0x7B, 0x00, 0x01, 0x09, 0x11, 0x0A, 0x46, 0x66, // "Ż" (U+017B)
  0x01, 0x7C, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x46, 0x9B, // "ż" (U+017C)
  0x01, 0x7D, 0x00, 0x01, 0x09, 0x11, 0x0A, 0x46, 0xC5, // "Ž" (U+017D)
  0x01, 0x7E, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x47, 0x00, // "ž" (U+017E)
  0x01, 0x7F, 0x01, 0x01, 0x07, 0x0E, 0x07, 0x47, 0x2F, // "ſ" (U+017F)
  0x03, 0xA9, 0x00, 0x01, 0x0D, 0x0D, 0x0E, 0x47, 0x5B, // "Ω" (U+03A9)
  0x03, 0xBC, 0x01, 0xFD, 0x0A, 0x0A, 0x0C, 0x47, 0xA5, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x01, 0x0C, 0x0A, 0x0D, 0x47, 0xE7, // "π" (U+03C0)
  0x20, 0x13, 0x00, 0x05, 0x08, 0x07, 0x09, 0x48, 0x21, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x05, 0x11, 0x07, 0x12, 0x48, 0x29, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x01, 0x09, 0x0D, 0x0A, 0x48, 0x33, // "€" (U+20AC)
  0x20, 0xBF, 0x01, 0xFF, 0x09, 0x0F, 0x0A, 0x48, 0x68, // "₿" (U+20BF)
  0x20, 0x18, 0x00, 0x0A, 0x03, 0x0D, 0x04, 0x48, 0xB2, // "‘" (U+2018)
  0x20, 0x19, 0x00, 0x0A, 0x03, 0x0D, 0x04, 0x48, 0xBC, // "’" (U+2019)
  0x20, 0x1A, 0x00, 0xFF, 0x03, 0x02, 0x05, 0x48, 0xC5, // "‚" (U+201A)
  0x20, 0x1B, 0x00, 0x0A, 0x03, 0x0D, 0x04, 0x48, 0xCE, // "‛" (U+201B)
  0x20, 0x1C, 0x00, 0x0A, 0x07, 0x0D, 0x08, 0x48, 0xD8, // "“" (U+201C)
  0x20, 0x1D, 0x00, 0x0A, 0x07, 0x0D, 0x08, 0x48, 0xEA, // "”" (U+201D)
  0x20, 0x1E, 0x00, 0xFF, 0x07, 0x02, 0x09, 0x48, 0xFC, // "„" (U+201E)
  0x20, 0x1F, 0x00, 0x0A, 0x07, 0x0D, 0x08, 0x49, 0x0E, // "‟" (U+201F)
  0x20, 0x20, 0x01, 0x01, 0x08, 0x0E, 0x09, 0x49, 0x21, // "†" (U+2020)
  0x20, 0x21, 0x01, 0x01, 0x08, 0x0E, 0x09, 0x49, 0x4F, // "‡" (U+2021)
  0x20, 0x22, 0x00, 0x05, 0x05, 0x0A, 0x07, 0x49, 0x7F, // "•" (U+2022)
  0x20, 0x26, 0x01, 0x01, 0x0E, 0x03, 0x0F, 0x49, 0x91, // "…" (U+2026)
  0x20, 0x30, 0x00, 0x01, 0x16, 0x0D, 0x17, 0x49, 0xAB, // "‰" (U+2030)
  0x20, 0x39, 0x00, 0x02, 0x05, 0x09, 0x07, 0x4A, 0x2E, // "‹" (U+2039)
  0x20, 0x3A, 0x01, 0x02, 0x05, 0x09, 0x07, 0x4A, 0x47, // "›" (U+203A)
  0x20, 0x44, 0xFC, 0x01, 0x05, 0x0D, 0x02, 0x4A, 0x5E, // "⁄" (U+2044)
  0x21, 0x22, 0x00, 0x07, 0x0C, 0x0D, 0x0E, 0x4A, 0x86, // "™" (U+2122)
  0x21, 0x52, 0x01, 0x01, 0x14, 0x0D, 0x15, 0x4A, 0xBA, // "⅒" (U+2152)
  0xFB, 0x01, 0x00, 0x01, 0x0B, 0x0E, 0x0C, 0x4B, 0x2E, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0x00, 0x01, 0x0B, 0x0E, 0x0C, 0x4B, 0x81, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x01, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0x61, 0x01, // "a (U+0022 U+0061)
  0x00, 0x22, 0x00, 0x63, 0x01, // "c (U+0022 U+0063)
  0x00, 0x22, 0x00, 0x64, 0x01, // "d (U+0022 U+0064)
  0x00, 0x22, 0x00, 0x65, 0x01, // "e (U+0022 U+0065)
  0x00, 0x22, 0x00, 0x67, 0x01, // "g (U+0022 U+0067)
  0x00, 0x22, 0x00, 0x6D, 0x01, // "m (U+0022 U+006D)
  0x00, 0x22, 0x00, 0x6E, 0x01, // "n (U+0022 U+006E)
  0x00, 0x22, 0x00, 0x6F, 0x01, // "o (U+0022 U+006F)
  0x00, 0x22, 0x00, 0x70, 0x01, // "p (U+0022 U+0070)
  0x00, 0x22, 0x00, 0x71, 0x01, // "q (U+0022 U+0071)
  0x00, 0x22, 0x00, 0x72, 0x01, // "r (U+0022 U+0072)
  0x00, 0x22, 0x00, 0x73, 0x01, // "s (U+0022 U+0073)
  0x00, 0x22, 0x00, 0x75, 0x01, // "u (U+0022 U+0075)
  0x00, 0x22, 0x00, 0xC0, 0x01, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x01, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x01, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x01, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x01, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x01, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xC6, 0x01, // "Æ (U+0022 U+00C6)
  0x00, 0x22, 0x00, 0xE0, 0x01, // "à (U+0022 U+00E0)
  0x00, 0x22, 0x00, 0xE1, 0x01, // "á (U+0022 U+00E1)
  0x00, 0x22, 0x00, 0xE2, 0x01, // "â (U+0022 U+00E2)
  0x00, 0x22, 0x00, 0xE3, 0x01, // "ã (U+0022 U+00E3)
  0x00, 0x22, 0x00, 0xE4, 0x01, // "ä (U+0022 U+00E4)
  0x00, 0x22, 0x00, 0xE5, 0x01, // "å (U+0022 U+00E5)
  0x00, 0x22, 0x00, 0xE6, 0x01, // "æ (U+0022 U+00E6)
  0x00, 0x22, 0x00, 0xE7, 0x01, // "ç (U+0022 U+00E7)
  0x00, 0x22, 0x00, 0xE8, 0x01, // "è (U+0022 U+00E8)
  0x00, 0x22, 0x00, 0xE9, 0x01, // "é (U+0022 U+00E9)
  0x00, 0x22, 0x00, 0xEA, 0x01, // "ê (U+0022 U+00EA)
  0x00, 0x22, 0x00, 0xEB, 0x01, // "ë (U+0022 U+00EB)
  0x00, 0x22, 0x00, 0xF2, 0x01, // "ò (U+0022 U+00F2)
  0x00, 0x22, 0x00, 0xF3, 0x01, // "ó (U+0022 U+00F3)
  0x00, 0x22, 0x00, 0xF4, 0x01, // "ô (U+0022 U+00F4)
  0x00, 0x22, 0x00, 0xF5, 0x01, // "õ (U+0022 U+00F5)
  0x00, 0x22, 0x00, 0xF6, 0x01, // "ö (U+0022 U+00F6)
  0x00, 0x22, 0x00, 0xF8, 0x01, // "ø (U+0022 U+00F8)
  0x00, 0x22, 0x00, 0xF9, 0x01, // "ù (U+0022 U+00F9)
  0x00, 0x22, 0x00, 0xFA, 0x01, // "ú (U+0022 U+00FA)
  0x00, 0x22, 0x00, 0xFB, 0x01, // "û (U+0022 U+00FB)
  0x00, 0x22, 0x00, 0xFC, 0x01, // "ü (U+0022 U+00FC)
  0x00, 0x22, 0x01, 0x00, 0x01, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x01, 0x01, // "ā (U+0022 U+0101)
  0x00, 0x22, 0x01, 0x02, 0x01, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x03, 0x01, // "ă (U+0022 U+0103)
  0x00, 0x22, 0x01, 0x04, 0x01, // "Ą (U+0022 U+0104)
  0x00, 0x22, 0x01, 0x05, 0x01, // "ą (U+0022 U+0105)
  0x00, 0x22, 0x01, 0x07, 0x01, // "ć (U+0022 U+0107)
  0x00, 0x22, 0x01, 0x09, 0x01, // "ĉ (U+0022 U+0109)
  0x00, 0x22, 0x01, 0x0B, 0x01, // "ċ (U+0022 U+010B)
  0x00, 0x22, 0x01, 0x0D, 0x01, // "č (U+0022 U+010D)
  0x00, 0x22, 0x01, 0x0F, 0x01, // "ď (U+0022 U+010F)
  0x00, 0x22, 0x01, 0x11, 0x01, // "đ (U+0022 U+0111)
  0x00, 0x22, 0x01, 0x13, 0x01, // "ē (U+0022 U+0113)
  0x00, 0x22, 0x01, 0x15, 0x01, // "ĕ (U+0022 U+0115)
  0x00, 0x22, 0x01, 0x17, 0x01, // "ė (U+0022 U+0117)
  0x00, 0x22, 0x01, 0x19, 0x01, // "ę (U+0022 U+0119)
  0x00, 0x22, 0x01, 0x1B, 0x01, // "ě (U+0022 U+011B)
  0x00, 0x22, 0x01, 0x1D, 0x01, // "ĝ (U+0022 U+011D)
  0x00, 0x22, 0x01, 0x1F, 0x01, // "ğ (U+0022 U+011F)
  0x00, 0x22, 0x01, 0x21, 0x01, // "ġ (U+0022 U+0121)
  0x00, 0x22, 0x01, 0x23, 0x01, // "ģ (U+0022 U+0123)
  0x00, 0x22, 0x01, 0x38, 0x01, // "ĸ (U+0022 U+0138)
  0x00, 0x22, 0x01, 0x44, 0x01, // "ń (U+0022 U+0144)
  0x00, 0x22, 0x01, 0x46, 0x01, // "ņ (U+0022 U+0146)
  0x00, 0x22, 0x01, 0x4B, 0x01, // "ŋ (U+0022 U+014B)
  0x00, 0x22, 0x01, 0x4D, 0x01, // "ō (U+0022 U+014D)
  0x00, 0x22, 0x01, 0x4F, 0x01, // "ŏ (U+0022 U+014F)
  0x00, 0x22, 0x01, 0x51, 0x01, // "ő (U+0022 U+0151)
  0x00, 0x22, 0x01, 0x53, 0x01, // "œ (U+0022 U+0153)
  0x00, 0x22, 0x01, 0x55, 0x01, // "ŕ (U+0022 U+0155)
  0x00, 0x22, 0x01, 0x57, 0x01, // "ŗ (U+0022 U+0157)
  0x00, 0x22, 0x01, 0x5B, 0x01, // "ś (U+0022 U+015B)
  0x00, 0x22, 0x01, 0x5F, 0x01, // "ş (U+0022 U+015F)
  0x00, 0x22, 0x01, 0x69, 0x01, // "ũ (U+0022 U+0169)
  0x00, 0x22, 0x01, 0x6B, 0x01, // "ū (U+0022 U+016B)
  0x00, 0x22, 0x01, 0x6D, 0x01, // "ŭ (U+0022 U+016D)
  0x00, 0x22, 0x01, 0x6F, 0x01, // "ů (U+0022 U+016F)
  0x00, 0x22, 0x01, 0x71, 0x01, // "ű (U+0022 U+0171)
  0x00, 0x22, 0x01, 0x73, 0x01, // "ų (U+0022 U+0173)
  0x00, 0x26, 0x00, 0x54, 0x01, // &T (U+0026 U+0054)
  0x00, 0x26, 0x00, 0x59, 0x01, // &Y (U+0026 U+0059)
  0x00, 0x26, 0x00, 0xDD, 0x01, // &Ý (U+0026 U+00DD)
  0x00, 0x26, 0x01, 0x62, 0x01, // &Ţ (U+0026 U+0162)
  0x00, 0x26, 0x01, 0x64, 0x01, // &Ť (U+0026 U+0164)
  0x00, 0x26, 0x01, 0x66, 0x01, // &Ŧ (U+0026 U+0166)
  0x00, 0x26, 0x01, 0x76, 0x01, // &Ŷ (U+0026 U+0176)
  0x00, 0x26, 0x01, 0x78, 0x01, // &Ÿ (U+0026 U+0178)
  0x00, 0x27, 0x00, 0x41, 0x01, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0x61, 0x01, // 'a (U+0027 U+0061)
  0x00, 0x27, 0x00, 0x63, 0x01, // 'c (U+0027 U+0063)
  0x00, 0x27, 0x00, 0x64, 0x01, // 'd (U+0027 U+0064)
  0x00, 0x27, 0x00, 0x65, 0x01, // 'e (U+0027 U+0065)
  0x00, 0x27, 0x00, 0x67, 0x01, // 'g (U+0027 U+0067)
  0x00, 0x27, 0x00, 0x6D, 0x01, // 'm (U+0027 U+006D)
  0x00, 0x27, 0x00, 0x6E, 0x01, // 'n (U+0027 U+006E)
  0x00, 0x27, 0x00, 0x6F, 0x01, // 'o (U+0027 U+006F)
  0x00, 0x27, 0x00, 0x70, 0x01, // 'p (U+0027 U+0070)
  0x00, 0x27, 0x00, 0x71, 0x01, // 'q (U+0027 U+0071)
  0x00, 0x27, 0x00, 0x72, 0x01, // 'r (U+0027 U+0072)
  0x00, 0x27, 0x00, 0x73, 0x01, // 's (U+0027 U+0073)
  0x00, 0x27, 0x00, 0x75, 0x01, // 'u (U+0027 U+0075)
  0x00, 0x27, 0x00, 0xC0, 0x01, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x01, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x01, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x01, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x01, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x01, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xC6, 0x01, // 'Æ (U+0027 U+00C6)
  0x00, 0x27, 0x00, 0xE0, 0x01, // 'à (U+0027 U+00E0)
  0x00, 0x27, 0x00, 0xE1, 0x01, // 'á (U+0027 U+00E1)
  0x00, 0x27, 0x00, 0xE2, 0x01, // 'â (U+0027 U+00E2)
  0x00, 0x27, 0x00, 0xE3, 0x01, // 'ã (U+0027 U+00E3)
  0x00, 0x27, 0x00, 0xE4, 0x01, // 'ä (U+0027 U+00E4)
  0x00, 0x27, 0x00, 0xE5, 0x01, // 'å (U+0027 U+00E5)
  0x00, 0x27, 0x00, 0xE6, 0x01, // 'æ (U+0027 U+00E6)
  0x00, 0x27, 0x00, 0xE7, 0x01, // 'ç (U+0027 U+00E7)
  0x00, 0x27, 0x00, 0xE8, 0x01, // 'è (U+0027 U+00E8)
  0x00, 0x27, 0x00, 0xE9, 0x01, // 'é (U+0027 U+00E9)
  0x00, 0x27, 0x00, 0xEA, 0x01, // 'ê (U+0027 U+00EA)
  0x00, 0x27, 0x00, 0xEB, 0x01, // 'ë (U+0027 U+00EB)
  0x00, 0x27, 0x00, 0xF2, 0x01, // 'ò (U+0027 U+00F2)
  0x00, 0x27, 0x00, 0xF3, 0x01, // 'ó (U+0027 U+00F3)
  0x00, 0x27, 0x00, 0xF4, 0x01, // 'ô (U+0027 U+00F4)
  0x00, 0x27, 0x00, 0xF5, 0x01, // 'õ (U+0027 U+00F5)
  0x00, 0x27, 0x00, 0xF6, 0x01, // 'ö (U+0027 U+00F6)
  0x00, 0x27, 0x00, 0xF8, 0x01, // 'ø (U+0027 U+00F8)
  0x00, 0x27, 0x00, 0xF9, 0x01, // 'ù (U+0027 U+00F9)
  0x00, 0x27, 0x00, 0xFA, 0x01, // 'ú (U+0027 U+00FA)
  0x00, 0x27, 0x00, 0xFB, 0x01, // 'û (U+0027 U+00FB)
  0x00, 0x27, 0x00, 0xFC, 0x01, // 'ü (U+0027 U+00FC)
  0x00, 0x27, 0x01, 0x00, 0x01, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x01, 0x01, // 'ā (U+0027 U+0101)
  0x00, 0x27, 0x01, 0x02, 0x01, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x03, 0x01, // 'ă (U+0027 U+0103)
  0x00, 0x27, 0x01, 0x04, 0x01, // 'Ą (U+0027 U+0104)
  0x00, 0x27, 0x01, 0x05, 0x01, // 'ą (U+0027 U+0105)
  0x00, 0x27, 0x01, 0x07, 0x01, // 'ć (U+0027 U+0107)
  0x00, 0x27, 0x01, 0x09, 0x01, // 'ĉ (U+0027 U+0109)
  0x00, 0x27, 0x01, 0x0B, 0x01, // 'ċ (U+0027 U+010B)
  0x00, 0x27, 0x01, 0x0D, 0x01, // 'č (U+0027 U+010D)
  0x00, 0x27, 0x01, 0x0F, 0x01, // 'ď (U+0027 U+010F)
  0x00, 0x27, 0x01, 0x11, 0x01, // 'đ (U+0027 U+0111)
  0x00, 0x27, 0x01, 0x13, 0x01, // 'ē (U+0027 U+0113)
  0x00, 0x27, 0x01, 0x15, 0x01, // 'ĕ (U+0027 U+0115)
  0x00, 0x27, 0x01, 0x17, 0x01, // 'ė (U+0027 U+0117)
  0x00, 0x27, 0x01, 0x19, 0x01, // 'ę (U+0027 U+0119)
  0x00, 0x27, 0x01, 0x1B, 0x01, // 'ě (U+0027 U+011B)
  0x00, 0x27, 0x01, 0x1D, 0x01, // 'ĝ (U+0027 U+011D)
  0x00, 0x27, 0x01, 0x1F, 0x01, // 'ğ (U+0027 U+011F)
  0x00, 0x27, 0x01, 0x21, 0x01, // 'ġ (U+0027 U+0121)
  0x00, 0x27, 0x01, 0x23, 0x01, // 'ģ (U+0027 U+0123)
  0x00, 0x27, 0x01, 0x38, 0x01, // 'ĸ (U+0027 U+0138)
  0x00, 0x27, 0x01, 0x44, 0x01, // 'ń (U+0027 U+0144)
  0x00, 0x27, 0x01, 0x46, 0x01, // 'ņ (U+0027 U+0146)
  0x00, 0x27, 0x01, 0x4B, 0x01, // 'ŋ (U+0027 U+014B)
  0x00, 0x27, 0x01, 0x4D, 0x01, // 'ō (U+0027 U+014D)
  0x00, 0x27, 0x01, 0x4F, 0x01, // 'ŏ (U+0027 U+014F)
  0x00, 0x27, 0x01, 0x51, 0x01, // 'ő (U+0027 U+0151)
  0x00, 0x27, 0x01, 0x53, 0x01, // 'œ (U+0027 U+0153)
  0x00, 0x27, 0x01, 0x55, 0x01, // 'ŕ (U+0027 U+0155)
  0x00, 0x27, 0x01, 0x57, 0x01, // 'ŗ (U+0027 U+0157)
  0x00, 0x27, 0x01, 0x5B, 0x01, // 'ś (U+0027 U+015B)
  0x00, 0x27, 0x01, 0x5F, 0x01, // 'ş (U+0027 U+015F)
  0x00, 0x27, 0x01, 0x69, 0x01, // 'ũ (U+0027 U+0169)
  0x00, 0x27, 0x01, 0x6B, 0x01, // 'ū (U+0027 U+016B)
  0x00, 0x27, 0x01, 0x6D, 0x01, // 'ŭ (U+0027 U+016D)
  0x00, 0x27, 0x01, 0x6F, 0x01, // 'ů (U+0027 U+016F)
  0x00, 0x27, 0x01, 0x71, 0x01, // 'ű (U+0027 U+0171)
  0x00, 0x27, 0x01, 0x73, 0x01, // 'ų (U+0027 U+0173)
  0x00, 0x2C, 0x00, 0x43, 0x01, // ,C (U+002C U+0043)
  0x00, 0x2C, 0x00, 0x47, 0x01, // ,G (U+002C U+0047)
  0x00, 0x2C, 0x00, 0x4F, 0x01, // ,O (U+002C U+004F)
  0x00, 0x2C, 0x00, 0x51, 0x01, // ,Q (U+002C U+0051)
  0x00, 0x2C, 0x00, 0x54, 0x01, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x56, 0x01, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x01, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x01, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0xC7, 0x01, // ,Ç (U+002C U+00C7)
  0x00, 0x2C, 0x00, 0xD2, 0x01, // ,Ò (U+002C U+00D2)
  0x00, 0x2C, 0x00, 0xD3, 0x01, // ,Ó (U+002C U+00D3)
  0x00, 0x2C, 0x00, 0xD4, 0x01, // ,Ô (U+002C U+00D4)
  0x00, 0x2C, 0x00, 0xD5, 0x01, // ,Õ (U+002C U+00D5)
  0x00, 0x2C, 0x00, 0xD6, 0x01, // ,Ö (U+002C U+00D6)
  0x00, 0x2C, 0x00, 0xD8, 0x01, // ,Ø (U+002C U+00D8)
  0x00, 0x2C, 0x00, 0xDD, 0x01, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x01, 0x06, 0x01, // ,Ć (U+002C U+0106)
  0x00, 0x2C, 0x01, 0x08, 0x01, // ,Ĉ (U+002C U+0108)
  0x00, 0x2C, 0x01, 0x0A, 0x01, // ,Ċ (U+002C U+010A)
  0x00, 0x2C, 0x01, 0x0C, 0x01, // ,Č (U+002C U+010C)
  0x00, 0x2C, 0x01, 0x1C, 0x01, // ,Ĝ (U+002C U+011C)
  0x00, 0x2C, 0x01, 0x1E, 0x01, // ,Ğ (U+002C U+011E)
  0x00, 0x2C, 0x01, 0x20, 0x01, // ,Ġ (U+002C U+0120)
  0x00, 0x2C, 0x01, 0x22, 0x01, // ,Ģ (U+002C U+0122)
  0x00, 0x2C, 0x01, 0x4C, 0x01, // ,Ō (U+002C U+014C)
  0x00, 0x2C, 0x01, 0x4E, 0x01, // ,Ŏ (U+002C U+014E)
  0x00, 0x2C, 0x01, 0x50, 0x01, // ,Ő (U+002C U+0150)
  0x00, 0x2C, 0x01, 0x52, 0x01, // ,Œ (U+002C U+0152)
  0x00, 0x2C, 0x01, 0x62, 0x01, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x01, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x01, // ,Ŧ (U+002C U+0166)
  0x00, 0x2C, 0x01, 0x74, 0x01, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x76, 0x01, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x78, 0x01, // ,Ÿ (U+002C U+0178)
  0x00, 0x2D, 0x00, 0x54, 0x01, // -T (U+002D U+0054)
  0x00, 0x2D, 0x01, 0x62, 0x01, // -Ţ (U+002D U+0162)
  0x00, 0x2D, 0x01, 0x64, 0x01, // -Ť (U+002D U+0164)
  0x00, 0x2D, 0x01, 0x66, 0x01, // -Ŧ (U+002D U+0166)
  0x00, 0x2E, 0x00, 0x43, 0x01, // .C (U+002E U+0043)
  0x00, 0x2E, 0x00, 0x47, 0x01, // .G (U+002E U+0047)
  0x00, 0x2E, 0x00, 0x4F, 0x01, // .O (U+002E U+004F)
  0x00, 0x2E, 0x00, 0x51, 0x01, // .Q (U+002E U+0051)
  0x00, 0x2E, 0x00, 0x54, 0x01, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x56, 0x01, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x01, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x01, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0xC7, 0x01, // .Ç (U+002E U+00C7)
  0x00, 0x2E, 0x00, 0xD2, 0x01, // .Ò (U+002E U+00D2)
  0x00, 0x2E, 0x00, 0xD3, 0x01, // .Ó (U+002E U+00D3)
  0x00, 0x2E, 0x00, 0xD4, 0x01, // .Ô (U+002E U+00D4)
  0x00, 0x2E, 0x00, 0xD5, 0x01, // .Õ (U+002E U+00D5)
  0x00, 0x2E, 0x00, 0xD6, 0x01, // .Ö (U+002E U+00D6)
  0x00, 0x2E, 0x00, 0xD8, 0x01, // .Ø (U+002E U+00D8)
  0x00, 0x2E, 0x00, 0xDD, 0x01, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x01, 0x06, 0x01, // .Ć (U+002E U+0106)
  0x00, 0x2E, 0x01, 0x08, 0x01, // .Ĉ (U+002E U+0108)
  0x00, 0x2E, 0x01, 0x0A, 0x01, // .Ċ (U+002E U+010A)
  0x00, 0x2E, 0x01, 0x0C, 0x01, // .Č (U+002E U+010C)
  0x00, 0x2E, 0x01, 0x1C, 0x01, // .Ĝ (U+002E U+011C)
  0x00, 0x2E, 0x01, 0x1E, 0x01, // .Ğ (U+002E U+011E)
  0x00, 0x2E, 0x01, 0x20, 0x01, // .Ġ (U+002E U+0120)
  0x00, 0x2E, 0x01, 0x22, 0x01, // .Ģ (U+002E U+0122)
  0x00, 0x2E, 0x01, 0x4C, 0x01, // .Ō (U+002E U+014C)
  0x00, 0x2E, 0x01, 0x4E, 0x01, // .Ŏ (U+002E U+014E)
  0x00, 0x2E, 0x01, 0x50, 0x01, // .Ő (U+002E U+0150)
  0x00, 0x2E, 0x01, 0x52, 0x01, // .Œ (U+002E U+0152)
  0x00, 0x2E, 0x01, 0x62, 0x01, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x01, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x01, // .Ŧ (U+002E U+0166)
  0x00, 0x2E, 0x01, 0x74, 0x01, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x76, 0x01, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x78, 0x01, // .Ÿ (U+002E U+0178)
  0x00, 0x30, 0x20, 0x44, 0x03, // 0⁄ (U+0030 U+2044)
  0x00, 0x31, 0x20, 0x44, 0x03, // 1⁄ (U+0031 U+2044)
  0x00, 0x32, 0x20, 0x44, 0x03, // 2⁄ (U+0032 U+2044)
  0x00, 0x33, 0x20, 0x44, 0x03, // 3⁄ (U+0033 U+2044)
  0x00, 0x34, 0x20, 0x44, 0x03, // 4⁄ (U+0034 U+2044)
  0x00, 0x35, 0x20, 0x44, 0x03, // 5⁄ (U+0035 U+2044)
  0x00, 0x36, 0x20, 0x44, 0x03, // 6⁄ (U+0036 U+2044)
  0x00, 0x37, 0x20, 0x44, 0x03, // 7⁄ (U+0037 U+2044)
  0x00, 0x38, 0x20, 0x44, 0x03, // 8⁄ (U+0038 U+2044)
  0x00, 0x39, 0x20, 0x44, 0x03, // 9⁄ (U+0039 U+2044)
  0x00, 0x41, 0x00, 0x22, 0x01, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x01, // A' (U+0041 U+0027)
  0x00, 0x41, 0x00, 0x54, 0x01, // AT (U+0041 U+0054)
  0x00, 0x41, 0x00, 0x56, 0x01, // AV (U+0041 U+0056)
  0x00, 0x41, 0x00, 0x57, 0x01, // AW (U+0041 U+0057)
  0x00, 0x41, 0x00, 0x59, 0x01, // AY (U+0041 U+0059)
  0x00, 0x41, 0x00, 0xDD, 0x01, // AÝ (U+0041 U+00DD)
  0x00, 0x41, 0x01, 0x62, 0x01, // AŢ (U+0041 U+0162)
  0x00, 0x41, 0x01, 0x64, 0x01, // AŤ (U+0041 U+0164)
  0x00, 0x41, 0x01, 0x66, 0x01, // AŦ (U+0041 U+0166)
  0x00, 0x41, 0x01, 0x74, 0x01, // AŴ (U+0041 U+0174)
  0x00, 0x41, 0x01, 0x76, 0x01, // AŶ (U+0041 U+0176)
  0x00, 0x41, 0x01, 0x78, 0x01, // AŸ (U+0041 U+0178)
  0x00, 0x41, 0x20, 0x19, 0x01, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1D, 0x01, // A” (U+0041 U+201D)
  0x00, 0x44, 0x00, 0x2C, 0x01, // D, (U+0044 U+002C)
  0x00, 0x44, 0x00, 0x2E, 0x01, // D. (U+0044 U+002E)
  0x00, 0x44, 0x00, 0x54, 0x01, // DT (U+0044 U+0054)
  0x00, 0x44, 0x01, 0x62, 0x01, // DŢ (U+0044 U+0162)
  0x00, 0x44, 0x01, 0x64, 0x01, // DŤ (U+0044 U+0164)
  0x00, 0x44, 0x01, 0x66, 0x01, // DŦ (U+0044 U+0166)
  0x00, 0x44, 0x20, 0x1A, 0x01, // D‚ (U+0044 U+201A)
  0x00, 0x44, 0x20, 0x1E, 0x01, // D„ (U+0044 U+201E)
  0x00, 0x44, 0x20, 0x26, 0x01, // D… (U+0044 U+2026)
  0x00, 0x46, 0x00, 0x2C, 0x01, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x01, // F. (U+0046 U+002E)
  0x00, 0x46, 0x20, 0x1A, 0x01, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x01, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x01, // F… (U+0046 U+2026)
  0x00, 0x4C, 0x00, 0x22, 0x01, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x01, // L' (U+004C U+0027)
  0x00, 0x4C, 0x00, 0x59, 0x01, // LY (U+004C U+0059)
  0x00, 0x4C, 0x00, 0xDD, 0x01, // LÝ (U+004C U+00DD)
  0x00, 0x4C, 0x01, 0x76, 0x01, // LŶ (U+004C U+0176)
  0x00, 0x4C, 0x01, 0x78, 0x01, // LŸ (U+004C U+0178)
  0x00, 0x4C, 0x20, 0x19, 0x01, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1D, 0x01, // L” (U+004C U+201D)
  0x00, 0x4F, 0x00, 0x2C, 0x01, // O, (U+004F U+002C)
  0x00, 0x4F, 0x00, 0x2E, 0x01, // O. (U+004F U+002E)
  0x00, 0x4F, 0x00, 0x54, 0x01, // OT (U+004F U+0054)
  0x00, 0x4F, 0x01, 0x62, 0x01, // OŢ (U+004F U+0162)
  0x00, 0x4F, 0x01, 0x64, 0x01, // OŤ (U+004F U+0164)
  0x00, 0x4F, 0x01, 0x66, 0x01, // OŦ (U+004F U+0166)
  0x00, 0x4F, 0x20, 0x1A, 0x01, // O‚ (U+004F U+201A)
  0x00, 0x4F, 0x20, 0x1E, 0x01, // O„ (U+004F U+201E)
  0x00, 0x4F, 0x20, 0x26, 0x01, // O… (U+004F U+2026)
  0x00, 0x50, 0x00, 0x2C, 0x02, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x02, // P. (U+0050 U+002E)
  0x00, 0x50, 0x00, 0x41, 0x01, // PA (U+0050 U+0041)
  0x00, 0x50, 0x00, 0xC0, 0x01, // PÀ (U+0050 U+00C0)
  0x00, 0x50, 0x00, 0xC1, 0x01, // PÁ (U+0050 U+00C1)
  0x00, 0x50, 0x00, 0xC2, 0x01, // PÂ (U+0050 U+00C2)
  0x00, 0x50, 0x00, 0xC3, 0x01, // PÃ (U+0050 U+00C3)
  0x00, 0x50, 0x00, 0xC4, 0x01, // PÄ (U+0050 U+00C4)
  0x00, 0x50, 0x00, 0xC5, 0x01, // PÅ (U+0050 U+00C5)
  0x00, 0x50, 0x00, 0xC6, 0x01, // PÆ (U+0050 U+00C6)
  0x00, 0x50, 0x01, 0x00, 0x01, // PĀ (U+0050 U+0100)
  0x00, 0x50, 0x01, 0x02, 0x01, // PĂ (U+0050 U+0102)
  0x00, 0x50, 0x01, 0x04, 0x01, // PĄ (U+0050 U+0104)
  0x00, 0x50, 0x20, 0x1A, 0x02, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x02, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x02, // P… (U+0050 U+2026)
  0x00, 0x51, 0x00, 0x2C, 0x01, // Q, (U+0051 U+002C)
  0x00, 0x51, 0x00, 0x2E, 0x01, // Q. (U+0051 U+002E)
  0x00, 0x51, 0x00, 0x54, 0x01, // QT (U+0051 U+0054)
  0x00, 0x51, 0x01, 0x62, 0x01, // QŢ (U+0051 U+0162)
  0x00, 0x51, 0x01, 0x64, 0x01, // QŤ (U+0051 U+0164)
  0x00, 0x51, 0x01, 0x66, 0x01, // QŦ (U+0051 U+0166)
  0x00, 0x51, 0x20, 0x1A, 0x01, // Q‚ (U+0051 U+201A)
  0x00, 0x51, 0x20, 0x1E, 0x01, // Q„ (U+0051 U+201E)
  0x00, 0x51, 0x20, 0x26, 0x01, // Q… (U+0051 U+2026)
  0x00, 0x54, 0x00, 0x2C, 0x01, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2D, 0x01, // T- (U+0054 U+002D)
  0x00, 0x54, 0x00, 0x2E, 0x01, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0x41, 0x01, // TA (U+0054 U+0041)
  0x00, 0x54, 0x00, 0x61, 0x01, // Ta (U+0054 U+0061)
  0x00, 0x54, 0x00, 0x63, 0x01, // Tc (U+0054 U+0063)
  0x00, 0x54, 0x00, 0x64, 0x01, // Td (U+0054 U+0064)
  0x00, 0x54, 0x00, 0x65, 0x01, // Te (U+0054 U+0065)
  0x00, 0x54, 0x00, 0x67, 0x01, // Tg (U+0054 U+0067)
  0x00, 0x54, 0x00, 0x6D, 0x01, // Tm (U+0054 U+006D)
  0x00, 0x54, 0x00, 0x6E, 0x01, // Tn (U+0054 U+006E)
  0x00, 0x54, 0x00, 0x6F, 0x01, // To (U+0054 U+006F)
  0x00, 0x54, 0x00, 0x70, 0x01, // Tp (U+0054 U+0070)
  0x00, 0x54, 0x00, 0x71, 0x01, // Tq (U+0054 U+0071)
  0x00, 0x54, 0x00, 0x72, 0x01, // Tr (U+0054 U+0072)
  0x00, 0x54, 0x00, 0x73, 0x01, // Ts (U+0054 U+0073)
  0x00, 0x54, 0x00, 0x75, 0x01, // Tu (U+0054 U+0075)
  0x00, 0x54, 0x00, 0x7A, 0x01, // Tz (U+0054 U+007A)
  0x00, 0x54, 0x00, 0xAB, 0x01, // T« (U+0054 U+00AB)
  0x00, 0x54, 0x00, 0xBB, 0x01, // T» (U+0054 U+00BB)
  0x00, 0x54, 0x00, 0xC0, 0x01, // TÀ (U+0054 U+00C0)
  0x00, 0x54, 0x00, 0xC1, 0x01, // TÁ (U+0054 U+00C1)
  0x00, 0x54, 0x00, 0xC2, 0x01, // TÂ (U+0054 U+00C2)
  0x00, 0x54, 0x00, 0xC3, 0x01, // TÃ (U+0054 U+00C3)
  0x00, 0x54, 0x00, 0xC4, 0x01, // TÄ (U+0054 U+00C4)
  0x00, 0x54, 0x00, 0xC5, 0x01, // TÅ (U+0054 U+00C5)
  0x00, 0x54, 0x00, 0xE0, 0x01, // Tà (U+0054 U+00E0)
  0x00, 0x54, 0x00, 0xE1, 0x01, // Tá (U+0054 U+00E1)
  0x00, 0x54, 0x00, 0xE2, 0x01, // Tâ (U+0054 U+00E2)
  0x00, 0x54, 0x00, 0xE3, 0x01, // Tã (U+0054 U+00E3)
  0x00, 0x54, 0x00, 0xE4, 0x01, // Tä (U+0054 U+00E4)
  0x00, 0x54, 0x00, 0xE5, 0x01, // Tå (U+0054 U+00E5)
  0x00, 0x54, 0x00, 0xE6, 0x01, // Tæ (U+0054 U+00E6)
  0x00, 0x54, 0x00, 0xE7, 0x01, // Tç (U+0054 U+00E7)
  0x00, 0x54, 0x00, 0xE8, 0x01, // Tè (U+0054 U+00E8)
  0x00, 0x54, 0x00, 0xE9, 0x01, // Té (U+0054 U+00E9)
  0x00, 0x54, 0x00, 0xEA, 0x01, // Tê (U+0054 U+00EA)
  0x00, 0x54, 0x00, 0xEB, 0x01, // Të (U+0054 U+00EB)
  0x00, 0x54, 0x00, 0xF2, 0x01, // Tò (U+0054 U+00F2)
  0x00, 0x54, 0x00, 0xF3, 0x01, // Tó (U+0054 U+00F3)
  0x00, 0x54, 0x00, 0xF4, 0x01, // Tô (U+0054 U+00F4)
  0x00, 0x54, 0x00, 0xF5, 0x01, // Tõ (U+0054 U+00F5)
  0x00, 0x54, 0x00, 0xF6, 0x01, // Tö (U+0054 U+00F6)
  0x00, 0x54, 0x00, 0xF8, 0x01, // Tø (U+0054 U+00F8)
  0x00, 0x54, 0x00, 0xF9, 0x01, // Tù (U+0054 U+00F9)
  0x00, 0x54, 0x00, 0xFA, 0x01, // Tú (U+0054 U+00FA)
  0x00, 0x54, 0x00, 0xFB, 0x01, // Tû (U+0054 U+00FB)
  0x00, 0x54, 0x00, 0xFC, 0x01, // Tü (U+0054 U+00FC)
  0x00, 0x54, 0x01, 0x00, 0x01, // TĀ (U+0054 U+0100)
  0x00, 0x54, 0x01, 0x01, 0x01, // Tā (U+0054 U+0101)
  0x00, 0x54, 0x01, 0x02, 0x01, // TĂ (U+0054 U+0102)
  0x00, 0x54, 0x01, 0x03, 0x01, // Tă (U+0054 U+0103)
  0x00, 0x54, 0x01, 0x04, 0x01, // TĄ (U+0054 U+0104)
  0x00, 0x54, 0x01, 0x05, 0x01, // Tą (U+0054 U+0105)
  0x00, 0x54, 0x01, 0x07, 0x01, // Tć (U+0054 U+0107)
  0x00, 0x54, 0x01, 0x09, 0x01, // Tĉ (U+0054 U+0109)
  0x00, 0x54, 0x01, 0x0B, 0x01, // Tċ (U+0054 U+010B)
  0x00, 0x54, 0x01, 0x0D, 0x01, // Tč (U+0054 U+010D)
  0x00, 0x54, 0x01, 0x0F, 0x01, // Tď (U+0054 U+010F)
  0x00, 0x54, 0x01, 0x11, 0x01, // Tđ (U+0054 U+0111)
  0x00, 0x54, 0x01, 0x13, 0x01, // Tē (U+0054 U+0113)
  0x00, 0x54, 0x01, 0x15, 0x01, // Tĕ (U+0054 U+0115)
  0x00, 0x54, 0x01, 0x17, 0x01, // Tė (U+0054 U+0117)
  0x00, 0x54, 0x01, 0x19, 0x01, // Tę (U+0054 U+0119)
  0x00, 0x54, 0x01, 0x1B, 0x01, // Tě (U+0054 U+011B)
  0x00, 0x54, 0x01, 0x1D, 0x01, // Tĝ (U+0054 U+011D)
  0x00, 0x54, 0x01, 0x1F, 0x01, // Tğ (U+0054 U+011F)
  0x00, 0x54, 0x01, 0x21, 0x01, // Tġ (U+0054 U+0121)
  0x00, 0x54, 0x01, 0x23, 0x01, // Tģ (U+0054 U+0123)
  0x00, 0x54, 0x01, 0x38, 0x01, // Tĸ (U+0054 U+0138)
  0x00, 0x54, 0x01, 0x44, 0x01, // Tń (U+0054 U+0144)
  0x00, 0x54, 0x01, 0x46, 0x01, // Tņ (U+0054 U+0146)
  0x00, 0x54, 0x01, 0x4B, 0x01, // Tŋ (U+0054 U+014B)
  0x00, 0x54, 0x01, 0x4D, 0x01, // Tō (U+0054 U+014D)
  0x00, 0x54, 0x01, 0x4F, 0x01, // Tŏ (U+0054 U+014F)
  0x00, 0x54, 0x01, 0x51, 0x01, // Tő (U+0054 U+0151)
  0x00, 0x54, 0x01, 0x53, 0x01, // Tœ (U+0054 U+0153)
  0x00, 0x54, 0x01, 0x55, 0x01, // Tŕ (U+0054 U+0155)
  0x00, 0x54, 0x01, 0x57, 0x01, // Tŗ (U+0054 U+0157)
  0x00, 0x54, 0x01, 0x5B, 0x01, // Tś (U+0054 U+015B)
  0x00, 0x54, 0x01, 0x5F, 0x01, // Tş (U+0054 U+015F)
  0x00, 0x54, 0x01, 0x69, 0x01, // Tũ (U+0054 U+0169)
  0x00, 0x54, 0x01, 0x6B, 0x01, // Tū (U+0054 U+016B)
  0x00, 0x54, 0x01, 0x6D, 0x01, // Tŭ (U+0054 U+016D)
  0x00, 0x54, 0x01, 0x6F, 0x01, // Tů (U+0054 U+016F)
  0x00, 0x54, 0x01, 0x71, 0x01, // Tű (U+0054 U+0171)
  0x00, 0x54, 0x01, 0x73, 0x01, // Tų (U+0054 U+0173)
  0x00, 0x54, 0x01, 0x7A, 0x01, // Tź (U+0054 U+017A)
  0x00, 0x54, 0x01, 0x7C, 0x01, // Tż (U+0054 U+017C)
  0x00, 0x54, 0x01, 0x7E, 0x01, // Tž (U+0054 U+017E)
  0x00, 0x54, 0x20, 0x13, 0x01, // T– (U+0054 U+2013)
  0x00, 0x54, 0x20, 0x14, 0x01, // T— (U+0054 U+2014)
  0x00, 0x54, 0x20, 0x1A, 0x01, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x01, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x01, // T… (U+0054 U+2026)
  0x00, 0x54, 0x20, 0x39, 0x01, // T‹ (U+0054 U+2039)
  0x00, 0x54, 0x20, 0x3A, 0x01, // T› (U+0054 U+203A)
  0x00, 0x56, 0x00, 0x2C, 0x01, // V, (U+0056 U+002C)
  0x00, 0x56, 0x00, 0x2E, 0x01, // V. (U+0056 U+002E)
  0x00, 0x56, 0x00, 0x41, 0x01, // VA (U+0056 U+0041)
  0x00, 0x56, 0x00, 0xAB, 0x01, // V« (U+0056 U+00AB)
  0x00, 0x56, 0x00, 0xC0, 0x01, // VÀ (U+0056 U+00C0)
  0x00, 0x56, 0x00, 0xC1, 0x01, // VÁ (U+0056 U+00C1)
  0x00, 0x56, 0x00, 0xC2, 0x01, // VÂ (U+0056 U+00C2)
  0x00, 0x56, 0x00, 0xC3, 0x01, // VÃ (U+0056 U+00C3)
  0x00, 0x56, 0x00, 0xC4, 0x01, // VÄ (U+0056 U+00C4)
  0x00, 0x56, 0x00, 0xC5, 0x01, // VÅ (U+0056 U+00C5)
  0x00, 0x56, 0x01, 0x00, 0x01, // VĀ (U+0056 U+0100)
  0x00, 0x56, 0x01, 0x02, 0x01, // VĂ (U+0056 U+0102)
  0x00, 0x56, 0x01, 0x04, 0x01, // VĄ (U+0056 U+0104)
  0x00, 0x56, 0x20, 0x1A, 0x01, // V‚ (U+0056 U+201A)
  0x00, 0x56, 0x20, 0x1E, 0x01, // V„ (U+0056 U+201E)
  0x00, 0x56, 0x20, 0x26, 0x01, // V… (U+0056 U+2026)
  0x00, 0x56, 0x20, 0x39, 0x01, // V‹ (U+0056 U+2039)
  0x00, 0x57, 0x00, 0x2C, 0x01, // W, (U+0057 U+002C)
  0x00, 0x57, 0x00, 0x2E, 0x01, // W. (U+0057 U+002E)
  0x00, 0x57, 0x00, 0x41, 0x01, // WA (U+0057 U+0041)
  0x00, 0x57, 0x00, 0xAB, 0x01, // W« (U+0057 U+00AB)
  0x00, 0x57, 0x00, 0xC0, 0x01, // WÀ (U+0057 U+00C0)
  0x00, 0x57, 0x00, 0xC1, 0x01, // WÁ (U+0057 U+00C1)
  0x00, 0x57, 0x00, 0xC2, 0x01, // WÂ (U+0057 U+00C2)
  0x00, 0x57, 0x00, 0xC3, 0x01, // WÃ (U+0057 U+00C3)
  0x00, 0x57, 0x00, 0xC4, 0x01, // WÄ (U+0057 U+00C4)
  0x00, 0x57, 0x00, 0xC5, 0x01, // WÅ (U+0057 U+00C5)
  0x00, 0x57, 0x01, 0x00, 0x01, // WĀ (U+0057 U+0100)
  0x00, 0x57, 0x01, 0x02, 0x01, // WĂ (U+0057 U+0102)
  0x00, 0x57, 0x01, 0x04, 0x01, // WĄ (U+0057 U+0104)
  0x00, 0x57, 0x20, 0x1A, 0x01, // W‚ (U+0057 U+201A)
  0x00, 0x57, 0x20, 0x1E, 0x01, // W„ (U+0057 U+201E)
  0x00, 0x57, 0x20, 0x26, 0x01, // W… (U+0057 U+2026)
  0x00, 0x57, 0x20, 0x39, 0x01, // W‹ (U+0057 U+2039)
  0x00, 0x59, 0x00, 0x26, 0x01, // Y& (U+0059 U+0026)
  0x00, 0x59, 0x00, 0x2C, 0x01, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x01, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x00, 0x41, 0x01, // YA (U+0059 U+0041)
  0x00, 0x59, 0x00, 0x61, 0x01, // Ya (U+0059 U+0061)
  0x00, 0x59, 0x00, 0x63, 0x01, // Yc (U+0059 U+0063)
  0x00, 0x59, 0x00, 0x64, 0x01, // Yd (U+0059 U+0064)
  0x00, 0x59, 0x00, 0x65, 0x01, // Ye (U+0059 U+0065)
  0x00, 0x59, 0x00, 0x67, 0x01, // Yg (U+0059 U+0067)
  0x00, 0x59, 0x00, 0x6D, 0x01, // Ym (U+0059 U+006D)
  0x00, 0x59, 0x00, 0x6E, 0x01, // Yn (U+0059 U+006E)
  0x00, 0x59, 0x00, 0x6F, 0x01, // Yo (U+0059 U+006F)
  0x00, 0x59, 0x00, 0x70, 0x01, // Yp (U+0059 U+0070)
  0x00, 0x59, 0x00, 0x71, 0x01, // Yq (U+0059 U+0071)
  0x00, 0x59, 0x00, 0x72, 0x01, // Yr (U+0059 U+0072)
  0x00, 0x59, 0x00, 0x73, 0x01, // Ys (U+0059 U+0073)
  0x00, 0x59, 0x00, 0x75, 0x01, // Yu (U+0059 U+0075)
  0x00, 0x59, 0x00, 0xAB, 0x01, // Y« (U+0059 U+00AB)
  0x00, 0x59, 0x00, 0xBB, 0x01, // Y» (U+0059 U+00BB)
  0x00, 0x59, 0x00, 0xC0, 0x01, // YÀ (U+0059 U+00C0)
  0x00, 0x59, 0x00, 0xC1, 0x01, // YÁ (U+0059 U+00C1)
  0x00, 0x59, 0x00, 0xC2, 0x01, // YÂ (U+0059 U+00C2)
  0x00, 0x59, 0x00, 0xC3, 0x01, // YÃ (U+0059 U+00C3)
  0x00, 0x59, 0x00, 0xC4, 0x01, // YÄ (U+0059 U+00C4)
  0x00, 0x59, 0x00, 0xC5, 0x01, // YÅ (U+0059 U+00C5)
  0x00, 0x59, 0x00, 0xE0, 0x01, // Yà (U+0059 U+00E0)
  0x00, 0x59, 0x00, 0xE1, 0x01, // Yá (U+0059 U+00E1)
  0x00, 0x59, 0x00, 0xE2, 0x01, // Yâ (U+0059 U+00E2)
  0x00, 0x59, 0x00, 0xE3, 0x01, // Yã (U+0059 U+00E3)
  0x00, 0x59, 0x00, 0xE4, 0x01, // Yä (U+0059 U+00E4)
  0x00, 0x59, 0x00, 0xE5, 0x01, // Yå (U+0059 U+00E5)
  0x00, 0x59, 0x00, 0xE6, 0x01, // Yæ (U+0059 U+00E6)
  0x00, 0x59, 0x00, 0xE7, 0x01, // Yç (U+0059 U+00E7)
  0x00, 0x59, 0x00, 0xE8, 0x01, // Yè (U+0059 U+00E8)
  0x00, 0x59, 0x00, 0xE9, 0x01, // Yé (U+0059 U+00E9)
  0x00, 0x59, 0x00, 0xEA, 0x01, // Yê (U+0059 U+00EA)
  0x00, 0x59, 0x00, 0xEB, 0x01, // Yë (U+0059 U+00EB)
  0x00, 0x59, 0x00, 0xF2, 0x01, // Yò (U+0059 U+00F2)
  0x00, 0x59, 0x00, 0xF3, 0x01, // Yó (U+0059 U+00F3)
  0x00, 0x59, 0x00, 0xF4, 0x01, // Yô (U+0059 U+00F4)
  0x00, 0x59, 0x00, 0xF5, 0x01, // Yõ (U+0059 U+00F5)
  0x00, 0x59, 0x00, 0xF6, 0x01, // Yö (U+0059 U+00F6)
  0x00, 0x59, 0x00, 0xF8, 0x01, // Yø (U+0059 U+00F8)
  0x00, 0x59, 0x00, 0xF9, 0x01, // Yù (U+0059 U+00F9)
  0x00, 0x59, 0x00, 0xFA, 0x01, // Yú (U+0059 U+00FA)
  0x00, 0x59, 0x00, 0xFB, 0x01, // Yû (U+0059 U+00FB)
  0x00, 0x59, 0x00, 0xFC, 0x01, // Yü (U+0059 U+00FC)
  0x00, 0x59, 0x01, 0x00, 0x01, // YĀ (U+0059 U+0100)
  0x00, 0x59, 0x01, 0x01, 0x01, // Yā (U+0059 U+0101)
  0x00, 0x59, 0x01, 0x02, 0x01, // YĂ (U+0059 U+0102)
  0x00, 0x59, 0x01, 0x03, 0x01, // Yă (U+0059 U+0103)
  0x00, 0x59, 0x01, 0x04, 0x01, // YĄ (U+0059 U+0104)
  0x00, 0x59, 0x01, 0x05, 0x01, // Yą (U+0059 U+0105)
  0x00, 0x59, 0x01, 0x07, 0x01, // Yć (U+0059 U+0107)
  0x00, 0x59, 0x01, 0x09, 0x01, // Yĉ (U+0059 U+0109)
  0x00, 0x59, 0x01, 0x0B, 0x01, // Yċ (U+0059 U+010B)
  0x00, 0x59, 0x01, 0x0D, 0x01, // Yč (U+0059 U+010D)
  0x00, 0x59, 0x01, 0x0F, 0x01, // Yď (U+0059 U+010F)
  0x00, 0x59, 0x01, 0x11, 0x01, // Yđ (U+0059 U+0111)
  0x00, 0x59, 0x01, 0x13, 0x01, // Yē (U+0059 U+0113)
  0x00, 0x59, 0x01, 0x15, 0x01, // Yĕ (U+0059 U+0115)
  0x00, 0x59, 0x01, 0x17, 0x01, // Yė (U+0059 U+0117)
  0x00, 0x59, 0x01, 0x19, 0x01, // Yę (U+0059 U+0119)
  0x00, 0x59, 0x01, 0x1B, 0x01, // Yě (U+0059 U+011B)
  0x00, 0x59, 0x01, 0x1D, 0x01, // Yĝ (U+0059 U+011D)
  0x00, 0x59, 0x01, 0x1F, 0x01, // Yğ (U+0059 U+011F)
  0x00, 0x59, 0x01, 0x21, 0x01, // Yġ (U+0059 U+0121)
  0x00, 0x59, 0x01, 0x23, 0x01, // Yģ (U+0059 U+0123)
  0x00, 0x59, 0x01, 0x38, 0x01, // Yĸ (U+0059 U+0138)
  0x00, 0x59, 0x01, 0x44, 0x01, // Yń (U+0059 U+0144)
  0x00, 0x59, 0x01, 0x46, 0x01, // Yņ (U+0059 U+0146)
  0x00, 0x59, 0x01, 0x4B, 0x01, // Yŋ (U+0059 U+014B)
  0x00, 0x59, 0x01, 0x4D, 0x01, // Yō (U+0059 U+014D)
  0x00, 0x59, 0x01, 0x4F, 0x01, // Yŏ (U+0059 U+014F)
  0x00, 0x59, 0x01, 0x51, 0x01, // Yő (U+0059 U+0151)
  0x00, 0x59, 0x01, 0x53, 0x01, // Yœ (U+0059 U+0153)
  0x00, 0x59, 0x01, 0x55, 0x01, // Yŕ (U+0059 U+0155)
  0x00, 0x59, 0x01, 0x57, 0x01, // Yŗ (U+0059 U+0157)
  0x00, 0x59, 0x01, 0x5B, 0x01, // Yś (U+0059 U+015B)
  0x00, 0x59, 0x01, 0x5F, 0x01, // Yş (U+0059 U+015F)
  0x00, 0x59, 0x01, 0x69, 0x01, // Yũ (U+0059 U+0169)
  0x00, 0x59, 0x01, 0x6B, 0x01, // Yū (U+0059 U+016B)
  0x00, 0x59, 0x01, 0x6D, 0x01, // Yŭ (U+0059 U+016D)
  0x00, 0x59, 0x01, 0x6F, 0x01, // Yů (U+0059 U+016F)
  0x00, 0x59, 0x01, 0x71, 0x01, // Yű (U+0059 U+0171)
  0x00, 0x59, 0x01, 0x73, 0x01, // Yų (U+0059 U+0173)
  0x00, 0x59, 0x20, 0x1A, 0x01, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x01, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x01, // Y… (U+0059 U+2026)
  0x00, 0x59, 0x20, 0x39, 0x01, // Y‹ (U+0059 U+2039)
  0x00, 0x59, 0x20, 0x3A, 0x01, // Y› (U+0059 U+203A)
  0x00, 0x72, 0x00, 0x2C, 0x02, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x02, // r. (U+0072 U+002E)
  0x00, 0x72, 0x20, 0x1A, 0x02, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x02, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x02, // r… (U+0072 U+2026)
  0x00, 0x76, 0x00, 0x2C, 0x01, // v, (U+0076 U+002C)
  0x00, 0x76, 0x00, 0x2E, 0x01, // v. (U+0076 U+002E)
  0x00, 0x76, 0x20, 0x1A, 0x01, // v‚ (U+0076 U+201A)
  0x00, 0x76, 0x20, 0x1E, 0x01, // v„ (U+0076 U+201E)
  0x00, 0x76, 0x20, 0x26, 0x01, // v… (U+0076 U+2026)
  0x00, 0x77, 0x00, 0x2C, 0x01, // w, (U+0077 U+002C)
  0x00, 0x77, 0x00, 0x2E, 0x01, // w. (U+0077 U+002E)
  0x00, 0x77, 0x20, 0x1A, 0x01, // w‚ (U+0077 U+201A)
  0x00, 0x77, 0x20, 0x1E, 0x01, // w„ (U+0077 U+201E)
  0x00, 0x77, 0x20, 0x26, 0x01, // w… (U+0077 U+2026)
  0x00, 0x79, 0x00, 0x2C, 0x01, // y, (U+0079 U+002C)
  0x00, 0x79, 0x00, 0x2E, 0x01, // y. (U+0079 U+002E)
  0x00, 0x79, 0x20, 0x1A, 0x01, // y‚ (U+0079 U+201A)
  0x00, 0x79, 0x20, 0x1E, 0x01, // y„ (U+0079 U+201E)
  0x00, 0x79, 0x20, 0x26, 0x01, // y… (U+0079 U+2026)
  0x00, 0xA1, 0x00, 0x59, 0x01, // ¡Y (U+00A1 U+0059)
  0x00, 0xA1, 0x00, 0xDD, 0x01, // ¡Ý (U+00A1 U+00DD)
  0x00, 0xA1, 0x01, 0x76, 0x01, // ¡Ŷ (U+00A1 U+0176)
  0x00, 0xA1, 0x01, 0x78, 0x01, // ¡Ÿ (U+00A1 U+0178)
  0x00, 0xAB, 0x00, 0x54, 0x01, // «T (U+00AB U+0054)
  0x00, 0xAB, 0x00, 0x59, 0x01, // «Y (U+00AB U+0059)
  0x00, 0xAB, 0x00, 0xDD, 0x01, // «Ý (U+00AB U+00DD)
  0x00, 0xAB, 0x01, 0x62, 0x01, // «Ţ (U+00AB U+0162)
  0x00, 0xAB, 0x01, 0x64, 0x01, // «Ť (U+00AB U+0164)
  0x00, 0xAB, 0x01, 0x66, 0x01, // «Ŧ (U+00AB U+0166)
  0x00, 0xAB, 0x01, 0x76, 0x01, // «Ŷ (U+00AB U+0176)
  0x00, 0xAB, 0x01, 0x78, 0x01, // «Ÿ (U+00AB U+0178)
  0x00, 0xBB, 0x00, 0x54, 0x01, // »T (U+00BB U+0054)
  0x00, 0xBB, 0x00, 0x56, 0x01, // »V (U+00BB U+0056)
  0x00, 0xBB, 0x00, 0x57, 0x01, // »W (U+00BB U+0057)
  0x00, 0xBB, 0x00, 0x59, 0x01, // »Y (U+00BB U+0059)
  0x00, 0xBB, 0x00, 0xDD, 0x01, // »Ý (U+00BB U+00DD)
  0x00, 0xBB, 0x01, 0x62, 0x01, // »Ţ (U+00BB U+0162)
  0x00, 0xBB, 0x01, 0x64, 0x01, // »Ť (U+00BB U+0164)
  0x00, 0xBB, 0x01, 0x66, 0x01, // »Ŧ (U+00BB U+0166)
  0x00, 0xBB, 0x01, 0x74, 0x01, // »Ŵ (U+00BB U+0174)
  0x00, 0xBB, 0x01, 0x76, 0x01, // »Ŷ (U+00BB U+0176)
  0x00, 0xBB, 0x01, 0x78, 0x01, // »Ÿ (U+00BB U+0178)
  0x00, 0xBF, 0x00, 0x54, 0x01, // ¿T (U+00BF U+0054)
  0x00, 0xBF, 0x00, 0x56, 0x01, // ¿V (U+00BF U+0056)
  0x00, 0xBF, 0x00, 0x57, 0x01, // ¿W (U+00BF U+0057)
  0x00, 0xBF, 0x00, 0x59, 0x01, // ¿Y (U+00BF U+0059)
  0x00, 0xBF, 0x00, 0xDD, 0x01, // ¿Ý (U+00BF U+00DD)
  0x00, 0xBF, 0x01, 0x62, 0x01, // ¿Ţ (U+00BF U+0162)
  0x00, 0xBF, 0x01, 0x64, 0x01, // ¿Ť (U+00BF U+0164)
  0x00, 0xBF, 0x01, 0x66, 0x01, // ¿Ŧ (U+00BF U+0166)
  0x00, 0xBF, 0x01, 0x74, 0x01, // ¿Ŵ (U+00BF U+0174)
  0x00, 0xBF, 0x01, 0x76, 0x01, // ¿Ŷ (U+00BF U+0176)
  0x00, 0xBF, 0x01, 0x78, 0x01, // ¿Ÿ (U+00BF U+0178)
  0x00, 0xC0, 0x00, 0x22, 0x01, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x01, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x00, 0x54, 0x01, // ÀT (U+00C0 U+0054)
  0x00, 0xC0, 0x00, 0x56, 0x01, // ÀV (U+00C0 U+0056)
  0x00, 0xC0, 0x00, 0x57, 0x01, // ÀW (U+00C0 U+0057)
  0x00, 0xC0, 0x00, 0x59, 0x01, // ÀY (U+00C0 U+0059)
  0x00, 0xC0, 0x00, 0xDD, 0x01, // ÀÝ (U+00C0 U+00DD)
  0x00, 0xC0, 0x01, 0x62, 0x01, // ÀŢ (U+00C0 U+0162)
  0x00, 0xC0, 0x01, 0x64, 0x01, // ÀŤ (U+00C0 U+0164)
  0x00, 0xC0, 0x01, 0x66, 0x01, // ÀŦ (U+00C0 U+0166)
  0x00, 0xC0, 0x01, 0x74, 0x01, // ÀŴ (U+00C0 U+0174)
  0x00, 0xC0, 0x01, 0x76, 0x01, // ÀŶ (U+00C0 U+0176)
  0x00, 0xC0, 0x01, 0x78, 0x01, // ÀŸ (U+00C0 U+0178)
  0x00, 0xC0, 0x20, 0x19, 0x01, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1D, 0x01, // À” (U+00C0 U+201D)
  0x00, 0xC1, 0x00, 0x22, 0x01, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x01, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x00, 0x54, 0x01, // ÁT (U+00C1 U+0054)
  0x00, 0xC1, 0x00, 0x56, 0x01, // ÁV (U+00C1 U+0056)
  0x00, 0xC1, 0x00, 0x57, 0x01, // ÁW (U+00C1 U+0057)
  0x00, 0xC1, 0x00, 0x59, 0x01, // ÁY (U+00C1 U+0059)
  0x00, 0xC1, 0x00, 0xDD, 0x01, // ÁÝ (U+00C1 U+00DD)
  0x00, 0xC1, 0x01, 0x62, 0x01, // ÁŢ (U+00C1 U+0162)
  0x00, 0xC1, 0x01, 0x64, 0x01, // ÁŤ (U+00C1 U+0164)
  0x00, 0xC1, 0x01, 0x66, 0x01, // ÁŦ (U+00C1 U+0166)
  0x00, 0xC1, 0x01, 0x74, 0x01, // ÁŴ (U+00C1 U+0174)
  0x00, 0xC1, 0x01, 0x76, 0x01, // ÁŶ (U+00C1 U+0176)
  0x00, 0xC1, 0x01, 0x78, 0x01, // ÁŸ (U+00C1 U+0178)
  0x00, 0xC1, 0x20, 0x19, 0x01, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1D, 0x01, // Á” (U+00C1 U+201D)
  0x00, 0xC2, 0x00, 0x22, 0x01, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x01, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x00, 0x54, 0x01, // ÂT (U+00C2 U+0054)
  0x00, 0xC2, 0x00, 0x56, 0x01, // ÂV (U+00C2 U+0056)
  0x00, 0xC2, 0x00, 0x57, 0x01, // ÂW (U+00C2 U+0057)
  0x00, 0xC2, 0x00, 0x59, 0x01, // ÂY (U+00C2 U+0059)
  0x00, 0xC2, 0x00, 0xDD, 0x01, // ÂÝ (U+00C2 U+00DD)
  0x00, 0xC2, 0x01, 0x62, 0x01, // ÂŢ (U+00C2 U+0162)
  0x00, 0xC2, 0x01, 0x64, 0x01, // ÂŤ (U+00C2 U+0164)
  0x00, 0xC2, 0x01, 0x66, 0x01, // ÂŦ (U+00C2 U+0166)
  0x00, 0xC2, 0x01, 0x74, 0x01, // ÂŴ (U+00C2 U+0174)
  0x00, 0xC2, 0x01, 0x76, 0x01, // ÂŶ (U+00C2 U+0176)
  0x00, 0xC2, 0x01, 0x78, 0x01, // ÂŸ (U+00C2 U+0178)
  0x00, 0xC2, 0x20, 0x19, 0x01, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1D, 0x01, // Â” (U+00C2 U+201D)
  0x00, 0xC3, 0x00, 0x22, 0x01, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x01, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x00, 0x54, 0x01, // ÃT (U+00C3 U+0054)
  0x00, 0xC3, 0x00, 0x56, 0x01, // ÃV (U+00C3 U+0056)
  0x00, 0xC3, 0x00, 0x57, 0x01, // ÃW (U+00C3 U+0057)
  0x00, 0xC3, 0x00, 0x59, 0x01, // ÃY (U+00C3 U+0059)
  0x00, 0xC3, 0x00, 0xDD, 0x01, // ÃÝ (U+00C3 U+00DD)
  0x00, 0xC3, 0x01, 0x62, 0x01, // ÃŢ (U+00C3 U+0162)
  0x00, 0xC3, 0x01, 0x64, 0x01, // ÃŤ (U+00C3 U+0164)
  0x00, 0xC3, 0x01, 0x66, 0x01, // ÃŦ (U+00C3 U+0166)
  0x00, 0xC3, 0x01, 0x74, 0x01, // ÃŴ (U+00C3 U+0174)
  0x00, 0xC3, 0x01, 0x76, 0x01, // ÃŶ (U+00C3 U+0176)
  0x00, 0xC3, 0x01, 0x78, 0x01, // ÃŸ (U+00C3 U+0178)
  0x00, 0xC3, 0x20, 0x19, 0x01, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1D, 0x01, // Ã” (U+00C3 U+201D)
  0x00, 0xC4, 0x00, 0x22, 0x01, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x01, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x00, 0x54, 0x01, // ÄT (U+00C4 U+0054)
  0x00, 0xC4, 0x00, 0x56, 0x01, // ÄV (U+00C4 U+0056)
  0x00, 0xC4, 0x00, 0x57, 0x01, // ÄW (U+00C4 U+0057)
  0x00, 0xC4, 0x00, 0x59, 0x01, // ÄY (U+00C4 U+0059)
  0x00, 0xC4, 0x00, 0xDD, 0x01, // ÄÝ (U+00C4 U+00DD)
  0x00, 0xC4, 0x01, 0x62, 0x01, // ÄŢ (U+00C4 U+0162)
  0x00, 0xC4, 0x01, 0x64, 0x01, // ÄŤ (U+00C4 U+0164)
  0x00, 0xC4, 0x01, 0x66, 0x01, // ÄŦ (U+00C4 U+0166)
  0x00, 0xC4, 0x01, 0x74, 0x01, // ÄŴ (U+00C4 U+0174)
  0x00, 0xC4, 0x01, 0x76, 0x01, // ÄŶ (U+00C4 U+0176)
  0x00, 0xC4, 0x01, 0x78, 0x01, // ÄŸ (U+00C4 U+0178)
  0x00, 0xC4, 0x20, 0x19, 0x01, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1D, 0x01, // Ä” (U+00C4 U+201D)
  0x00, 0xC5, 0x00, 0x22, 0x01, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x01, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x00, 0x54, 0x01, // ÅT (U+00C5 U+0054)
  0x00, 0xC5, 0x00, 0x56, 0x01, // ÅV (U+00C5 U+0056)
  0x00, 0xC5, 0x00, 0x57, 0x01, // ÅW (U+00C5 U+0057)
  0x00, 0xC5, 0x00, 0x59, 0x01, // ÅY (U+00C5 U+0059)
  0x00, 0xC5, 0x00, 0xDD, 0x01, // ÅÝ (U+00C5 U+00DD)
  0x00, 0xC5, 0x01, 0x62, 0x01, // ÅŢ (U+00C5 U+0162)
  0x00, 0xC5, 0x01, 0x64, 0x01, // ÅŤ (U+00C5 U+0164)
  0x00, 0xC5, 0x01, 0x66, 0x01, // ÅŦ (U+00C5 U+0166)
  0x00, 0xC5, 0x01, 0x74, 0x01, // ÅŴ (U+00C5 U+0174)
  0x00, 0xC5, 0x01, 0x76, 0x01, // ÅŶ (U+00C5 U+0176)
  0x00, 0xC5, 0x01, 0x78, 0x01, // ÅŸ (U+00C5 U+0178)
  0x00, 0xC5, 0x20, 0x19, 0x01, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1D, 0x01, // Å” (U+00C5 U+201D)
  0x00, 0xD0, 0x00, 0x2C, 0x01, // Ð, (U+00D0 U+002C)
  0x00, 0xD0, 0x00, 0x2E, 0x01, // Ð. (U+00D0 U+002E)
  0x00, 0xD0, 0x00, 0x54, 0x01, // ÐT (U+00D0 U+0054)
  0x00, 0xD0, 0x01, 0x62, 0x01, // ÐŢ (U+00D0 U+0162)
  0x00, 0xD0, 0x01, 0x64, 0x01, // ÐŤ (U+00D0 U+0164)
  0x00, 0xD0, 0x01, 0x66, 0x01, // ÐŦ (U+00D0 U+0166)
  0x00, 0xD0, 0x20, 0x1A, 0x01, // Ð‚ (U+00D0 U+201A)
  0x00, 0xD0, 0x20, 0x1E, 0x01, // Ð„ (U+00D0 U+201E)
  0x00, 0xD0, 0x20, 0x26, 0x01, // Ð… (U+00D0 U+2026)
  0x00, 0xD2, 0x00, 0x2C, 0x01, // Ò, (U+00D2 U+002C)
  0x00, 0xD2, 0x00, 0x2E, 0x01, // Ò. (U+00D2 U+002E)
  0x00, 0xD2, 0x00, 0x54, 0x01, // ÒT (U+00D2 U+0054)
  0x00, 0xD2, 0x01, 0x62, 0x01, // ÒŢ (U+00D2 U+0162)
  0x00, 0xD2, 0x01, 0x64, 0x01, // ÒŤ (U+00D2 U+0164)
  0x00, 0xD2, 0x01, 0x66, 0x01, // ÒŦ (U+00D2 U+0166)
  0x00, 0xD2, 0x20, 0x1A, 0x01, // Ò‚ (U+00D2 U+201A)
  0x00, 0xD2, 0x20, 0x1E, 0x01, // Ò„ (U+00D2 U+201E)
  0x00, 0xD2, 0x20, 0x26, 0x01, // Ò… (U+00D2 U+2026)
  0x00, 0xD3, 0x00, 0x2C, 0x01, // Ó, (U+00D3 U+002C)
  0x00, 0xD3, 0x00, 0x2E, 0x01, // Ó. (U+00D3 U+002E)
  0x00, 0xD3, 0x00, 0x54, 0x01, // ÓT (U+00D3 U+0054)
  0x00, 0xD3, 0x01, 0x62, 0x01, // ÓŢ (U+00D3 U+0162)
  0x00, 0xD3, 0x01, 0x64, 0x01, // ÓŤ (U+00D3 U+0164)
  0x00, 0xD3, 0x01, 0x66, 0x01, // ÓŦ (U+00D3 U+0166)
  0x00, 0xD3, 0x20, 0x1A, 0x01, // Ó‚ (U+00D3 U+201A)
  0x00, 0xD3, 0x20, 0x1E, 0x01, // Ó„ (U+00D3 U+201E)
  0x00, 0xD3, 0x20, 0x26, 0x01, // Ó… (U+00D3 U+2026)
  0x00, 0xD4, 0x00, 0x2C, 0x01, // Ô, (U+00D4 U+002C)
  0x00, 0xD4, 0x00, 0x2E, 0x01, // Ô. (U+00D4 U+002E)
  0x00, 0xD4, 0x00, 0x54, 0x01, // ÔT (U+00D4 U+0054)
  0x00, 0xD4, 0x01, 0x62, 0x01, // ÔŢ (U+00D4 U+0162)
  0x00, 0xD4, 0x01, 0x64, 0x01, // ÔŤ (U+00D4 U+0164)
  0x00, 0xD4, 0x01, 0x66, 0x01, // ÔŦ (U+00D4 U+0166)
  0x00, 0xD4, 0x20, 0x1A, 0x01, // Ô‚ (U+00D4 U+201A)
  0x00, 0xD4, 0x20, 0x1E, 0x01, // Ô„ (U+00D4 U+201E)
  0x00, 0xD4, 0x20, 0x26, 0x01, // Ô… (U+00D4 U+2026)
  0x00, 0xD5, 0x00, 0x2C, 0x01, // Õ, (U+00D5 U+002C)
  0x00, 0xD5, 0x00, 0x2E, 0x01, // Õ. (U+00D5 U+002E)
  0x00, 0xD5, 0x00, 0x54, 0x01, // ÕT (U+00D5 U+0054)
  0x00, 0xD5, 0x01, 0x62, 0x01, // ÕŢ (U+00D5 U+0162)
  0x00, 0xD5, 0x01, 0x64, 0x01, // ÕŤ (U+00D5 U+0164)
  0x00, 0xD5, 0x01, 0x66, 0x01, // ÕŦ (U+00D5 U+0166)
  0x00, 0xD5, 0x20, 0x1A, 0x01, // Õ‚ (U+00D5 U+201A)
  0x00, 0xD5, 0x20, 0x1E, 0x01, // Õ„ (U+00D5 U+201E)
  0x00, 0xD5, 0x20, 0x26, 0x01, // Õ… (U+00D5 U+2026)
  0x00, 0xD6, 0x00, 0x2C, 0x01, // Ö, (U+00D6 U+002C)
  0x00, 0xD6, 0x00, 0x2E, 0x01, // Ö. (U+00D6 U+002E)
  0x00, 0xD6, 0x00, 0x54, 0x01, // ÖT (U+00D6 U+0054)
  0x00, 0xD6, 0x01, 0x62, 0x01, // ÖŢ (U+00D6 U+0162)
  0x00, 0xD6, 0x01, 0x64, 0x01, // ÖŤ (U+00D6 U+0164)
  0x00, 0xD6, 0x01, 0x66, 0x01, // ÖŦ (U+00D6 U+0166)
  0x00, 0xD6, 0x20, 0x1A, 0x01, // Ö‚ (U+00D6 U+201A)
  0x00, 0xD6, 0x20, 0x1E, 0x01, // Ö„ (U+00D6 U+201E)
  0x00, 0xD6, 0x20, 0x26, 0x01, // Ö… (U+00D6 U+2026)
  0x00, 0xD8, 0x00, 0x2C, 0x01, // Ø, (U+00D8 U+002C)
  0x00, 0xD8, 0x00, 0x2E, 0x01, // Ø. (U+00D8 U+002E)
  0x00, 0xD8, 0x00, 0x54, 0x01, // ØT (U+00D8 U+0054)
  0x00, 0xD8, 0x01, 0x62, 0x01, // ØŢ (U+00D8 U+0162)
  0x00, 0xD8, 0x01, 0x64, 0x01, // ØŤ (U+00D8 U+0164)
  0x00, 0xD8, 0x01, 0x66, 0x01, // ØŦ (U+00D8 U+0166)
  0x00, 0xD8, 0x20, 0x1A, 0x01, // Ø‚ (U+00D8 U+201A)
  0x00, 0xD8, 0x20, 0x1E, 0x01, // Ø„ (U+00D8 U+201E)
  0x00, 0xD8, 0x20, 0x26, 0x01, // Ø… (U+00D8 U+2026)
  0x00, 0xDD, 0x00, 0x26, 0x01, // Ý& (U+00DD U+0026)
  0x00, 0xDD, 0x00, 0x2C, 0x01, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x01, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x00, 0x41, 0x01, // ÝA (U+00DD U+0041)
  0x00, 0xDD, 0x00, 0x61, 0x01, // Ýa (U+00DD U+0061)
  0x00, 0xDD, 0x00, 0x63, 0x01, // Ýc (U+00DD U+0063)
  0x00, 0xDD, 0x00, 0x64, 0x01, // Ýd (U+00DD U+0064)
  0x00, 0xDD, 0x00, 0x65, 0x01, // Ýe (U+00DD U+0065)
  0x00, 0xDD, 0x00, 0x67, 0x01, // Ýg (U+00DD U+0067)
  0x00, 0xDD, 0x00, 0x6D, 0x01, // Ým (U+00DD U+006D)
  0x00, 0xDD, 0x00, 0x6E, 0x01, // Ýn (U+00DD U+006E)
  0x00, 0xDD, 0x00, 0x6F, 0x01, // Ýo (U+00DD U+006F)
  0x00, 0xDD, 0x00, 0x70, 0x01, // Ýp (U+00DD U+0070)
  0x00, 0xDD, 0x00, 0x71, 0x01, // Ýq (U+00DD U+0071)
  0x00, 0xDD, 0x00, 0x72, 0x01, // Ýr (U+00DD U+0072)
  0x00, 0xDD, 0x00, 0x73, 0x01, // Ýs (U+00DD U+0073)
  0x00, 0xDD, 0x00, 0x75, 0x01, // Ýu (U+00DD U+0075)
  0x00, 0xDD, 0x00, 0xAB, 0x01, // Ý« (U+00DD U+00AB)
  0x00, 0xDD, 0x00, 0xBB, 0x01, // Ý» (U+00DD U+00BB)
  0x00, 0xDD, 0x00, 0xC0, 0x01, // ÝÀ (U+00DD U+00C0)
  0x00, 0xDD, 0x00, 0xC1, 0x01, // ÝÁ (U+00DD U+00C1)
  0x00, 0xDD, 0x00, 0xC2, 0x01, // ÝÂ (U+00DD U+00C2)
  0x00, 0xDD, 0x00, 0xC3, 0x01, // ÝÃ (U+00DD U+00C3)
  0x00, 0xDD, 0x00, 0xC4, 0x01, // ÝÄ (U+00DD U+00C4)
  0x00, 0xDD, 0x00, 0xC5, 0x01, // ÝÅ (U+00DD U+00C5)
  0x00, 0xDD, 0x00, 0xE0, 0x01, // Ýà (U+00DD U+00E0)
  0x00, 0xDD, 0x00, 0xE1, 0x01, // Ýá (U+00DD U+00E1)
  0x00, 0xDD, 0x00, 0xE2, 0x01, // Ýâ (U+00DD U+00E2)
  0x00, 0xDD, 0x00, 0xE3, 0x01, // Ýã (U+00DD U+00E3)
  0x00, 0xDD, 0x00, 0xE4, 0x01, // Ýä (U+00DD U+00E4)
  0x00, 0xDD, 0x00, 0xE5, 0x01, // Ýå (U+00DD U+00E5)
  0x00, 0xDD, 0x00, 0xE6, 0x01, // Ýæ (U+00DD U+00E6)
  0x00, 0xDD, 0x00, 0xE7, 0x01, // Ýç (U+00DD U+00E7)
  0x00, 0xDD, 0x00, 0xE8, 0x01, // Ýè (U+00DD U+00E8)
  0x00, 0xDD, 0x00, 0xE9, 0x01, // Ýé (U+00DD U+00E9)
  0x00, 0xDD, 0x00, 0xEA, 0x01, // Ýê (U+00DD U+00EA)
  0x00, 0xDD, 0x00, 0xEB, 0x01, // Ýë (U+00DD U+00EB)
  0x00, 0xDD, 0x00, 0xF2, 0x01, // Ýò (U+00DD U+00F2)
  0x00, 0xDD, 0x00, 0xF3, 0x01, // Ýó (U+00DD U+00F3)
  0x00, 0xDD, 0x00, 0xF4, 0x01, // Ýô (U+00DD U+00F4)
  0x00, 0xDD, 0x00, 0xF5, 0x01, // Ýõ (U+00DD U+00F5)
  0x00, 0xDD, 0x00, 0xF6, 0x01, // Ýö (U+00DD U+00F6)
  0x00, 0xDD, 0x00, 0xF8, 0x01, // Ýø (U+00DD U+00F8)
  0x00, 0xDD, 0x00, 0xF9, 0x01, // Ýù (U+00DD U+00F9)
  0x00, 0xDD, 0x00, 0xFA, 0x01, // Ýú (U+00DD U+00FA)
  0x00, 0xDD, 0x00, 0xFB, 0x01, // Ýû (U+00DD U+00FB)
  0x00, 0xDD, 0x00, 0xFC, 0x01, // Ýü (U+00DD U+00FC)
  0x00, 0xDD, 0x01, 0x00, 0x01, // ÝĀ (U+00DD U+0100)
  0x00, 0xDD, 0x01, 0x01, 0x01, // Ýā (U+00DD U+0101)
  0x00, 0xDD, 0x01, 0x02, 0x01, // ÝĂ (U+00DD U+0102)
  0x00, 0xDD, 0x01, 0x03, 0x01, // Ýă (U+00DD U+0103)
  0x00, 0xDD, 0x01, 0x04, 0x01, // ÝĄ (U+00DD U+0104)
  0x00, 0xDD, 0x01, 0x05, 0x01, // Ýą (U+00DD U+0105)
  0x00, 0xDD, 0x01, 0x07, 0x01, // Ýć (U+00DD U+0107)
  0x00, 0xDD, 0x01, 0x09, 0x01, // Ýĉ (U+00DD U+0109)
  0x00, 0xDD, 0x01, 0x0B, 0x01, // Ýċ (U+00DD U+010B)
  0x00, 0xDD, 0x01, 0x0D, 0x01, // Ýč (U+00DD U+010D)
  0x00, 0xDD, 0x01, 0x0F, 0x01, // Ýď (U+00DD U+010F)
  0x00, 0xDD, 0x01, 0x11, 0x01, // Ýđ (U+00DD U+0111)
  0x00, 0xDD, 0x01, 0x13, 0x01, // Ýē (U+00DD U+0113)
  0x00, 0xDD, 0x01, 0x15, 0x01, // Ýĕ (U+00DD U+0115)
  0x00, 0xDD, 0x01, 0x17, 0x01, // Ýė (U+00DD U+0117)
  0x00, 0xDD, 0x01, 0x19, 0x01, // Ýę (U+00DD U+0119)
  0x00, 0xDD, 0x01, 0x1B, 0x01, // Ýě (U+00DD U+011B)
  0x00, 0xDD, 0x01, 0x1D, 0x01, // Ýĝ (U+00DD U+011D)
  0x00, 0xDD, 0x01, 0x1F, 0x01, // Ýğ (U+00DD U+011F)
  0x00, 0xDD, 0x01, 0x21, 0x01, // Ýġ (U+00DD U+0121)
  0x00, 0xDD, 0x01, 0x23, 0x01, // Ýģ (U+00DD U+0123)
  0x00, 0xDD, 0x01, 0x38, 0x01, // Ýĸ (U+00DD U+0138)
  0x00, 0xDD, 0x01, 0x44, 0x01, // Ýń (U+00DD U+0144)
  0x00, 0xDD, 0x01, 0x46, 0x01, // Ýņ (U+00DD U+0146)
  0x00, 0xDD, 0x01, 0x4B, 0x01, // Ýŋ (U+00DD U+014B)
  0x00, 0xDD, 0x01, 0x4D, 0x01, // Ýō (U+00DD U+014D)
  0x00, 0xDD, 0x01, 0x4F, 0x01, // Ýŏ (U+00DD U+014F)
  0x00, 0xDD, 0x01, 0x51, 0x01, // Ýő (U+00DD U+0151)
  0x00, 0xDD, 0x01, 0x53, 0x01, // Ýœ (U+00DD U+0153)
  0x00, 0xDD, 0x01, 0x55, 0x01, // Ýŕ (U+00DD U+0155)
  0x00, 0xDD, 0x01, 0x57, 0x01, // Ýŗ (U+00DD U+0157)
  0x00, 0xDD, 0x01, 0x5B, 0x01, // Ýś (U+00DD U+015B)
  0x00, 0xDD, 0x01, 0x5F, 0x01, // Ýş (U+00DD U+015F)
  0x00, 0xDD, 0x01, 0x69, 0x01, // Ýũ (U+00DD U+0169)
  0x00, 0xDD, 0x01, 0x6B, 0x01, // Ýū (U+00DD U+016B)
  0x00, 0xDD, 0x01, 0x6D, 0x01, // Ýŭ (U+00DD U+016D)
  0x00, 0xDD, 0x01, 0x6F, 0x01, // Ýů (U+00DD U+016F)
  0x00, 0xDD, 0x01, 0x71, 0x01, // Ýű (U+00DD U+0171)
  0x00, 0xDD, 0x01, 0x73, 0x01, // Ýų (U+00DD U+0173)
  0x00, 0xDD, 0x20, 0x1A, 0x01, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x01, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x01, // Ý… (U+00DD U+2026)
  0x00, 0xDD, 0x20, 0x39, 0x01, // Ý‹ (U+00DD U+2039)
  0x00, 0xDD, 0x20, 0x3A, 0x01, // Ý› (U+00DD U+203A)
  0x00, 0xDE, 0x00, 0x2C, 0x02, // Þ, (U+00DE U+002C)
  0x00, 0xDE, 0x00, 0x2E, 0x02, // Þ. (U+00DE U+002E)
  0x00, 0xDE, 0x00, 0x41, 0x01, // ÞA (U+00DE U+0041)
  0x00, 0xDE, 0x00, 0xC0, 0x01, // ÞÀ (U+00DE U+00C0)
  0x00, 0xDE, 0x00, 0xC1, 0x01, // ÞÁ (U+00DE U+00C1)
  0x00, 0xDE, 0x00, 0xC2, 0x01, // ÞÂ (U+00DE U+00C2)
  0x00, 0xDE, 0x00, 0xC3, 0x01, // ÞÃ (U+00DE U+00C3)
  0x00, 0xDE, 0x00, 0xC4, 0x01, // ÞÄ (U+00DE U+00C4)
  0x00, 0xDE, 0x00, 0xC5, 0x01, // ÞÅ (U+00DE U+00C5)
  0x00, 0xDE, 0x00, 0xC6, 0x01, // ÞÆ (U+00DE U+00C6)
  0x00, 0xDE, 0x01, 0x00, 0x01, // ÞĀ (U+00DE U+0100)
  0x00, 0xDE, 0x01, 0x02, 0x01, // ÞĂ (U+00DE U+0102)
  0x00, 0xDE, 0x01, 0x04, 0x01, // ÞĄ (U+00DE U+0104)
  0x00, 0xDE, 0x20, 0x1A, 0x02, // Þ‚ (U+00DE U+201A)
  0x00, 0xDE, 0x20, 0x1E, 0x02, // Þ„ (U+00DE U+201E)
  0x00, 0xDE, 0x20, 0x26, 0x02, // Þ… (U+00DE U+2026)
  0x00, 0xFD, 0x00, 0x2C, 0x01, // ý, (U+00FD U+002C)
  0x00, 0xFD, 0x00, 0x2E, 0x01, // ý. (U+00FD U+002E)
  0x00, 0xFD, 0x20, 0x1A, 0x01, // ý‚ (U+00FD U+201A)
  0x00, 0xFD, 0x20, 0x1E, 0x01, // ý„ (U+00FD U+201E)
  0x00, 0xFD, 0x20, 0x26, 0x01, // ý… (U+00FD U+2026)
  0x00, 0xFF, 0x00, 0x2C, 0x01, // ÿ, (U+00FF U+002C)
  0x00, 0xFF, 0x00, 0x2E, 0x01, // ÿ. (U+00FF U+002E)
  0x00, 0xFF, 0x20, 0x1A, 0x01, // ÿ‚ (U+00FF U+201A)
  0x00, 0xFF, 0x20, 0x1E, 0x01, // ÿ„ (U+00FF U+201E)
  0x00, 0xFF, 0x20, 0x26, 0x01, // ÿ… (U+00FF U+2026)
  0x01, 0x00, 0x00, 0x22, 0x01, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x01, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x00, 0x54, 0x01, // ĀT (U+0100 U+0054)
  0x01, 0x00, 0x00, 0x56, 0x01, // ĀV (U+0100 U+0056)
  0x01, 0x00, 0x00, 0x57, 0x01, // ĀW (U+0100 U+0057)
  0x01, 0x00, 0x00, 0x59, 0x01, // ĀY (U+0100 U+0059)
  0x01, 0x00, 0x00, 0xDD, 0x01, // ĀÝ (U+0100 U+00DD)
  0x01, 0x00, 0x01, 0x62, 0x01, // ĀŢ (U+0100 U+0162)
  0x01, 0x00, 0x01, 0x64, 0x01, // ĀŤ (U+0100 U+0164)
  0x01, 0x00, 0x01, 0x66, 0x01, // ĀŦ (U+0100 U+0166)
  0x01, 0x00, 0x01, 0x74, 0x01, // ĀŴ (U+0100 U+0174)
  0x01, 0x00, 0x01, 0x76, 0x01, // ĀŶ (U+0100 U+0176)
  0x01, 0x00, 0x01, 0x78, 0x01, // ĀŸ (U+0100 U+0178)
  0x01, 0x00, 0x20, 0x19, 0x01, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1D, 0x01, // Ā” (U+0100 U+201D)
  0x01, 0x02, 0x00, 0x22, 0x01, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x01, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x00, 0x54, 0x01, // ĂT (U+0102 U+0054)
  0x01, 0x02, 0x00, 0x56, 0x01, // ĂV (U+0102 U+0056)
  0x01, 0x02, 0x00, 0x57, 0x01, // ĂW (U+0102 U+0057)
  0x01, 0x02, 0x00, 0x59, 0x01, // ĂY (U+0102 U+0059)
  0x01, 0x02, 0x00, 0xDD, 0x01, // ĂÝ (U+0102 U+00DD)
  0x01, 0x02, 0x01, 0x62, 0x01, // ĂŢ (U+0102 U+0162)
  0x01, 0x02, 0x01, 0x64, 0x01, // ĂŤ (U+0102 U+0164)
  0x01, 0x02, 0x01, 0x66, 0x01, // ĂŦ (U+0102 U+0166)
  0x01, 0x02, 0x01, 0x74, 0x01, // ĂŴ (U+0102 U+0174)
  0x01, 0x02, 0x01, 0x76, 0x01, // ĂŶ (U+0102 U+0176)
  0x01, 0x02, 0x01, 0x78, 0x01, // ĂŸ (U+0102 U+0178)
  0x01, 0x02, 0x20, 0x19, 0x01, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1D, 0x01, // Ă” (U+0102 U+201D)
  0x01, 0x04, 0x00, 0x22, 0x01, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x01, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x00, 0x54, 0x01, // ĄT (U+0104 U+0054)
  0x01, 0x04, 0x00, 0x56, 0x01, // ĄV (U+0104 U+0056)
  0x01, 0x04, 0x00, 0x57, 0x01, // ĄW (U+0104 U+0057)
  0x01, 0x04, 0x00, 0x59, 0x01, // ĄY (U+0104 U+0059)
  0x01, 0x04, 0x00, 0xDD, 0x01, // ĄÝ (U+0104 U+00DD)
  0x01, 0x04, 0x01, 0x62, 0x01, // ĄŢ (U+0104 U+0162)
  0x01, 0x04, 0x01, 0x64, 0x01, // ĄŤ (U+0104 U+0164)
  0x01, 0x04, 0x01, 0x66, 0x01, // ĄŦ (U+0104 U+0166)
  0x01, 0x04, 0x01, 0x74, 0x01, // ĄŴ (U+0104 U+0174)
  0x01, 0x04, 0x01, 0x76, 0x01, // ĄŶ (U+0104 U+0176)
  0x01, 0x04, 0x01, 0x78, 0x01, // ĄŸ (U+0104 U+0178)
  0x01, 0x04, 0x20, 0x19, 0x01, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1D, 0x01, // Ą” (U+0104 U+201D)
  0x01, 0x0E, 0x00, 0x2C, 0x01, // Ď, (U+010E U+002C)
  0x01, 0x0E, 0x00, 0x2E, 0x01, // Ď. (U+010E U+002E)
  0x01, 0x0E, 0x00, 0x54, 0x01, // ĎT (U+010E U+0054)
  0x01, 0x0E, 0x01, 0x62, 0x01, // ĎŢ (U+010E U+0162)
  0x01, 0x0E, 0x01, 0x64, 0x01, // ĎŤ (U+010E U+0164)
  0x01, 0x0E, 0x01, 0x66, 0x01, // ĎŦ (U+010E U+0166)
  0x01, 0x0E, 0x20, 0x1A, 0x01, // Ď‚ (U+010E U+201A)
  0x01, 0x0E, 0x20, 0x1E, 0x01, // Ď„ (U+010E U+201E)
  0x01, 0x0E, 0x20, 0x26, 0x01, // Ď… (U+010E U+2026)
  0x01, 0x10, 0x00, 0x2C, 0x01, // Đ, (U+0110 U+002C)
  0x01, 0x10, 0x00, 0x2E, 0x01, // Đ. (U+0110 U+002E)
  0x01, 0x10, 0x00, 0x54, 0x01, // ĐT (U+0110 U+0054)
  0x01, 0x10, 0x01, 0x62, 0x01, // ĐŢ (U+0110 U+0162)
  0x01, 0x10, 0x01, 0x64, 0x01, // ĐŤ (U+0110 U+0164)
  0x01, 0x10, 0x01, 0x66, 0x01, // ĐŦ (U+0110 U+0166)
  0x01, 0x10, 0x20, 0x1A, 0x01, // Đ‚ (U+0110 U+201A)
  0x01, 0x10, 0x20, 0x1E, 0x01, // Đ„ (U+0110 U+201E)
  0x01, 0x10, 0x20, 0x26, 0x01, // Đ… (U+0110 U+2026)
  0x01, 0x39, 0x00, 0x22, 0x01, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x01, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x00, 0x59, 0x01, // ĹY (U+0139 U+0059)
  0x01, 0x39, 0x00, 0xDD, 0x01, // ĹÝ (U+0139 U+00DD)
  0x01, 0x39, 0x01, 0x76, 0x01, // ĹŶ (U+0139 U+0176)
  0x01, 0x39, 0x01, 0x78, 0x01, // ĹŸ (U+0139 U+0178)
  0x01, 0x39, 0x20, 0x19, 0x01, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1D, 0x01, // Ĺ” (U+0139 U+201D)
  0x01, 0x3B, 0x00, 0x22, 0x01, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x01, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x00, 0x59, 0x01, // ĻY (U+013B U+0059)
  0x01, 0x3B, 0x00, 0xDD, 0x01, // ĻÝ (U+013B U+00DD)
  0x01, 0x3B, 0x01, 0x76, 0x01, // ĻŶ (U+013B U+0176)
  0x01, 0x3B, 0x01, 0x78, 0x01, // ĻŸ (U+013B U+0178)
  0x01, 0x3B, 0x20, 0x19, 0x01, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1D, 0x01, // Ļ” (U+013B U+201D)
  0x01, 0x3D, 0x00, 0x22, 0x01, // Ľ" (U+013D U+0022)
  0x01, 0x3D, 0x00, 0x27, 0x01, // Ľ' (U+013D U+0027)
  0x01, 0x3D, 0x00, 0x59, 0x01, // ĽY (U+013D U+0059)
  0x01, 0x3D, 0x00, 0xDD, 0x01, // ĽÝ (U+013D U+00DD)
  0x01, 0x3D, 0x01, 0x76, 0x01, // ĽŶ (U+013D U+0176)
  0x01, 0x3D, 0x01, 0x78, 0x01, // ĽŸ (U+013D U+0178)
  0x01, 0x3D, 0x20, 0x19, 0x01, // Ľ’ (U+013D U+2019)
  0x01, 0x3D, 0x20, 0x1D, 0x01, // Ľ” (U+013D U+201D)
  0x01, 0x3F, 0x00, 0x22, 0x01, // Ŀ" (U+013F U+0022)
  0x01, 0x3F, 0x00, 0x27, 0x01, // Ŀ' (U+013F U+0027)
  0x01, 0x3F, 0x00, 0x59, 0x01, // ĿY (U+013F U+0059)
  0x01, 0x3F, 0x00, 0xDD, 0x01, // ĿÝ (U+013F U+00DD)
  0x01, 0x3F, 0x01, 0x76, 0x01, // ĿŶ (U+013F U+0176)
  0x01, 0x3F, 0x01, 0x78, 0x01, // ĿŸ (U+013F U+0178)
  0x01, 0x3F, 0x20, 0x19, 0x01, // Ŀ’ (U+013F U+2019)
  0x01, 0x3F, 0x20, 0x1D, 0x01, // Ŀ” (U+013F U+201D)
  0x01, 0x41, 0x00, 0x22, 0x01, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x01, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x00, 0x59, 0x01, // ŁY (U+0141 U+0059)
  0x01, 0x41, 0x00, 0xDD, 0x01, // ŁÝ (U+0141 U+00DD)
  0x01, 0x41, 0x01, 0x76, 0x01, // ŁŶ (U+0141 U+0176)
  0x01, 0x41, 0x01, 0x78, 0x01, // ŁŸ (U+0141 U+0178)
  0x01, 0x41, 0x20, 0x19, 0x01, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1D, 0x01, // Ł” (U+0141 U+201D)
  0x01, 0x4C, 0x00, 0x2C, 0x01, // Ō, (U+014C U+002C)
  0x01, 0x4C, 0x00, 0x2E, 0x01, // Ō. (U+014C U+002E)
  0x01, 0x4C, 0x00, 0x54, 0x01, // ŌT (U+014C U+0054)
  0x01, 0x4C, 0x01, 0x62, 0x01, // ŌŢ (U+014C U+0162)
  0x01, 0x4C, 0x01, 0x64, 0x01, // ŌŤ (U+014C U+0164)
  0x01, 0x4C, 0x01, 0x66, 0x01, // ŌŦ (U+014C U+0166)
  0x01, 0x4C, 0x20, 0x1A, 0x01, // Ō‚ (U+014C U+201A)
  0x01, 0x4C, 0x20, 0x1E, 0x01, // Ō„ (U+014C U+201E)
  0x01, 0x4C, 0x20, 0x26, 0x01, // Ō… (U+014C U+2026)
  0x01, 0x4E, 0x00, 0x2C, 0x01, // Ŏ, (U+014E U+002C)
  0x01, 0x4E, 0x00, 0x2E, 0x01, // Ŏ. (U+014E U+002E)
  0x01, 0x4E, 0x00, 0x54, 0x01, // ŎT (U+014E U+0054)
  0x01, 0x4E, 0x01, 0x62, 0x01, // ŎŢ (U+014E U+0162)
  0x01, 0x4E, 0x01, 0x64, 0x01, // ŎŤ (U+014E U+0164)
  0x01, 0x4E, 0x01, 0x66, 0x01, // ŎŦ (U+014E U+0166)
  0x01, 0x4E, 0x20, 0x1A, 0x01, // Ŏ‚ (U+014E U+201A)
  0x01, 0x4E, 0x20, 0x1E, 0x01, // Ŏ„ (U+014E U+201E)
  0x01, 0x4E, 0x20, 0x26, 0x01, // Ŏ… (U+014E U+2026)
  0x01, 0x50, 0x00, 0x2C, 0x01, // Ő, (U+0150 U+002C)
  0x01, 0x50, 0x00, 0x2E, 0x01, // Ő. (U+0150 U+002E)
  0x01, 0x50, 0x00, 0x54, 0x01, // ŐT (U+0150 U+0054)
  0x01, 0x50, 0x01, 0x62, 0x01, // ŐŢ (U+0150 U+0162)
  0x01, 0x50, 0x01, 0x64, 0x01, // ŐŤ (U+0150 U+0164)
  0x01, 0x50, 0x01, 0x66, 0x01, // ŐŦ (U+0150 U+0166)
  0x01, 0x50, 0x20, 0x1A, 0x01, // Ő‚ (U+0150 U+201A)
  0x01, 0x50, 0x20, 0x1E, 0x01, // Ő„ (U+0150 U+201E)
  0x01, 0x50, 0x20, 0x26, 0x01, // Ő… (U+0150 U+2026)
  0x01, 0x55, 0x00, 0x2C, 0x02, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x02, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x20, 0x1A, 0x02, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x02, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x02, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x02, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x02, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x20, 0x1A, 0x02, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x02, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x02, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x02, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x02, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x20, 0x1A, 0x02, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x02, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x02, // ř… (U+0159 U+2026)
  0x01, 0x62, 0x00, 0x2C, 0x01, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2D, 0x01, // Ţ- (U+0162 U+002D)
  0x01, 0x62, 0x00, 0x2E, 0x01, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0x41, 0x01, // ŢA (U+0162 U+0041)
  0x01, 0x62, 0x00, 0x61, 0x01, // Ţa (U+0162 U+0061)
  0x01, 0x62, 0x00, 0x63, 0x01, // Ţc (U+0162 U+0063)
  0x01, 0x62, 0x00, 0x64, 0x01, // Ţd (U+0162 U+0064)
  0x01, 0x62, 0x00, 0x65, 0x01, // Ţe (U+0162 U+0065)
  0x01, 0x62, 0x00, 0x67, 0x01, // Ţg (U+0162 U+0067)
  0x01, 0x62, 0x00, 0x6D, 0x01, // Ţm (U+0162 U+006D)
  0x01, 0x62, 0x00, 0x6E, 0x01, // Ţn (U+0162 U+006E)
  0x01, 0x62, 0x00, 0x6F, 0x01, // Ţo (U+0162 U+006F)
  0x01, 0x62, 0x00, 0x70, 0x01, // Ţp (U+0162 U+0070)
  0x01, 0x62, 0x00, 0x71, 0x01, // Ţq (U+0162 U+0071)
  0x01, 0x62, 0x00, 0x72, 0x01, // Ţr (U+0162 U+0072)
  0x01, 0x62, 0x00, 0x73, 0x01, // Ţs (U+0162 U+0073)
  0x01, 0x62, 0x00, 0x75, 0x01, // Ţu (U+0162 U+0075)
  0x01, 0x62, 0x00, 0x7A, 0x01, // Ţz (U+0162 U+007A)
  0x01, 0x62, 0x00, 0xAB, 0x01, // Ţ« (U+0162 U+00AB)
  0x01, 0x62, 0x00, 0xBB, 0x01, // Ţ» (U+0162 U+00BB)
  0x01, 0x62, 0x00, 0xC0, 0x01, // ŢÀ (U+0162 U+00C0)
  0x01, 0x62, 0x00, 0xC1, 0x01, // ŢÁ (U+0162 U+00C1)
  0x01, 0x62, 0x00, 0xC2, 0x01, // ŢÂ (U+0162 U+00C2)
  0x01, 0x62, 0x00, 0xC3, 0x01, // ŢÃ (U+0162 U+00C3)
  0x01, 0x62, 0x00, 0xC4, 0x01, // ŢÄ (U+0162 U+00C4)
  0x01, 0x62, 0x00, 0xC5, 0x01, // ŢÅ (U+0162 U+00C5)
  0x01, 0x62, 0x00, 0xE0, 0x01, // Ţà (U+0162 U+00E0)
  0x01, 0x62, 0x00, 0xE1, 0x01, // Ţá (U+0162 U+00E1)
  0x01, 0x62, 0x00, 0xE2, 0x01, // Ţâ (U+0162 U+00E2)
  0x01, 0x62, 0x00, 0xE3, 0x01, // Ţã (U+0162 U+00E3)
  0x01, 0x62, 0x00, 0xE4, 0x01, // Ţä (U+0162 U+00E4)
  0x01, 0x62, 0x00, 0xE5, 0x01, // Ţå (U+0162 U+00E5)
  0x01, 0x62, 0x00, 0xE6, 0x01, // Ţæ (U+0162 U+00E6)
  0x01, 0x62, 0x00, 0xE7, 0x01, // Ţç (U+0162 U+00E7)
  0x01, 0x62, 0x00, 0xE8, 0x01, // Ţè (U+0162 U+00E8)
  0x01, 0x62, 0x00, 0xE9, 0x01, // Ţé (U+0162 U+00E9)
  0x01, 0x62, 0x00, 0xEA, 0x01, // Ţê (U+0162 U+00EA)
  0x01, 0x62, 0x00, 0xEB, 0x01, // Ţë (U+0162 U+00EB)
  0x01, 0x62, 0x00, 0xF2, 0x01, // Ţò (U+0162 U+00F2)
  0x01, 0x62, 0x00, 0xF3, 0x01, // Ţó (U+0162 U+00F3)
  0x01, 0x62, 0x00, 0xF4, 0x01, // Ţô (U+0162 U+00F4)
  0x01, 0x62, 0x00, 0xF5, 0x01, // Ţõ (U+0162 U+00F5)
  0x01, 0x62, 0x00, 0xF6, 0x01, // Ţö (U+0162 U+00F6)
  0x01, 0x62, 0x00, 0xF8, 0x01, // Ţø (U+0162 U+00F8)
  0x01, 0x62, 0x00, 0xF9, 0x01, // Ţù (U+0162 U+00F9)
  0x01, 0x62, 0x00, 0xFA, 0x01, // Ţú (U+0162 U+00FA)
  0x01, 0x62, 0x00, 0xFB, 0x01, // Ţû (U+0162 U+00FB)
  0x01, 0x62, 0x00, 0xFC, 0x01, // Ţü (U+0162 U+00FC)
  0x01, 0x62, 0x01, 0x00, 0x01, // ŢĀ (U+0162 U+0100)
  0x01, 0x62, 0x01, 0x01, 0x01, // Ţā (U+0162 U+0101)
  0x01, 0x62, 0x01, 0x02, 0x01, // ŢĂ (U+0162 U+0102)
  0x01, 0x62, 0x01, 0x03, 0x01, // Ţă (U+0162 U+0103)
  0x01, 0x62, 0x01, 0x04, 0x01, // ŢĄ (U+0162 U+0104)
  0x01, 0x62, 0x01, 0x05, 0x01, // Ţą (U+0162 U+0105)
  0x01, 0x62, 0x01, 0x07, 0x01, // Ţć (U+0162 U+0107)
  0x01, 0x62, 0x01, 0x09, 0x01, // Ţĉ (U+0162 U+0109)
  0x01, 0x62, 0x01, 0x0B, 0x01, // Ţċ (U+0162 U+010B)
  0x01, 0x62, 0x01, 0x0D, 0x01, // Ţč (U+0162 U+010D)
  0x01, 0x62, 0x01, 0x0F, 0x01, // Ţď (U+0162 U+010F)
  0x01, 0x62, 0x01, 0x11, 0x01, // Ţđ (U+0162 U+0111)
  0x01, 0x62, 0x01, 0x13, 0x01, // Ţē (U+0162 U+0113)
  0x01, 0x62, 0x01, 0x15, 0x01, // Ţĕ (U+0162 U+0115)
  0x01, 0x62, 0x01, 0x17, 0x01, // Ţė (U+0162 U+0117)
  0x01, 0x62, 0x01, 0x19, 0x01, // Ţę (U+0162 U+0119)
  0x01, 0x62, 0x01, 0x1B, 0x01, // Ţě (U+0162 U+011B)
  0x01, 0x62, 0x01, 0x1D, 0x01, // Ţĝ (U+0162 U+011D)
  0x01, 0x62, 0x01, 0x1F, 0x01, // Ţğ (U+0162 U+011F)
  0x01, 0x62, 0x01, 0x21, 0x01, // Ţġ (U+0162 U+0121)
  0x01, 0x62, 0x01, 0x23, 0x01, // Ţģ (U+0162 U+0123)
  0x01, 0x62, 0x01, 0x38, 0x01, // Ţĸ (U+0162 U+0138)
  0x01, 0x62, 0x01, 0x44, 0x01, // Ţń (U+0162 U+0144)
  0x01, 0x62, 0x01, 0x46, 0x01, // Ţņ (U+0162 U+0146)
  0x01, 0x62, 0x01, 0x4B, 0x01, // Ţŋ (U+0162 U+014B)
  0x01, 0x62, 0x01, 0x4D, 0x01, // Ţō (U+0162 U+014D)
  0x01, 0x62, 0x01, 0x4F, 0x01, // Ţŏ (U+0162 U+014F)
  0x01, 0x62, 0x01, 0x51, 0x01, // Ţő (U+0162 U+0151)
  0x01, 0x62, 0x01, 0x53, 0x01, // Ţœ (U+0162 U+0153)
  0x01, 0x62, 0x01, 0x55, 0x01, // Ţŕ (U+0162 U+0155)
  0x01, 0x62, 0x01, 0x57, 0x01, // Ţŗ (U+0162 U+0157)
  0x01, 0x62, 0x01, 0x5B, 0x01, // Ţś (U+0162 U+015B)
  0x01, 0x62, 0x01, 0x5F, 0x01, // Ţş (U+0162 U+015F)
  0x01, 0x62, 0x01, 0x69, 0x01, // Ţũ (U+0162 U+0169)
  0x01, 0x62, 0x01, 0x6B, 0x01, // Ţū (U+0162 U+016B)
  0x01, 0x62, 0x01, 0x6D, 0x01, // Ţŭ (U+0162 U+016D)
  0x01, 0x62, 0x01, 0x6F, 0x01, // Ţů (U+0162 U+016F)
  0x01, 0x62, 0x01, 0x71, 0x01, // Ţű (U+0162 U+0171)
  0x01, 0x62, 0x01, 0x73, 0x01, // Ţų (U+0162 U+0173)
  0x01, 0x62, 0x01, 0x7A, 0x01, // Ţź (U+0162 U+017A)
  0x01, 0x62, 0x01, 0x7C, 0x01, // Ţż (U+0162 U+017C)
  0x01, 0x62, 0x01, 0x7E, 0x01, // Ţž (U+0162 U+017E)
  0x01, 0x62, 0x20, 0x13, 0x01, // Ţ– (U+0162 U+2013)
  0x01, 0x62, 0x20, 0x14, 0x01, // Ţ— (U+0162 U+2014)
  0x01, 0x62, 0x20, 0x1A, 0x01, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x01, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x01, // Ţ… (U+0162 U+2026)
  0x01, 0x62, 0x20, 0x39, 0x01, // Ţ‹ (U+0162 U+2039)
  0x01, 0x62, 0x20, 0x3A, 0x01, // Ţ› (U+0162 U+203A)
  0x01, 0x64, 0x00, 0x2C, 0x01, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2D, 0x01, // Ť- (U+0164 U+002D)
  0x01, 0x64, 0x00, 0x2E, 0x01, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0x41, 0x01, // ŤA (U+0164 U+0041)
  0x01, 0x64, 0x00, 0x61, 0x01, // Ťa (U+0164 U+0061)
  0x01, 0x64, 0x00, 0x63, 0x01, // Ťc (U+0164 U+0063)
  0x01, 0x64, 0x00, 0x64, 0x01, // Ťd (U+0164 U+0064)
  0x01, 0x64, 0x00, 0x65, 0x01, // Ťe (U+0164 U+0065)
  0x01, 0x64, 0x00, 0x67, 0x01, // Ťg (U+0164 U+0067)
  0x01, 0x64, 0x00, 0x6D, 0x01, // Ťm (U+0164 U+006D)
  0x01, 0x64, 0x00, 0x6E, 0x01, // Ťn (U+0164 U+006E)
  0x01, 0x64, 0x00, 0x6F, 0x01, // Ťo (U+0164 U+006F)
  0x01, 0x64, 0x00, 0x70, 0x01, // Ťp (U+0164 U+0070)
  0x01, 0x64, 0x00, 0x71, 0x01, // Ťq (U+0164 U+0071)
  0x01, 0x64, 0x00, 0x72, 0x01, // Ťr (U+0164 U+0072)
  0x01, 0x64, 0x00, 0x73, 0x01, // Ťs (U+0164 U+0073)
  0x01, 0x64, 0x00, 0x75, 0x01, // Ťu (U+0164 U+0075)
  0x01, 0x64, 0x00, 0x7A, 0x01, // Ťz (U+0164 U+007A)
  0x01, 0x64, 0x00, 0xAB, 0x01, // Ť« (U+0164 U+00AB)
  0x01, 0x64, 0x00, 0xBB, 0x01, // Ť» (U+0164 U+00BB)
  0x01, 0x64, 0x00, 0xC0, 0x01, // ŤÀ (U+0164 U+00C0)
  0x01, 0x64, 0x00, 0xC1, 0x01, // ŤÁ (U+0164 U+00C1)
  0x01, 0x64, 0x00, 0xC2, 0x01, // ŤÂ (U+0164 U+00C2)
  0x01, 0x64, 0x00, 0xC3, 0x01, // ŤÃ (U+0164 U+00C3)
  0x01, 0x64, 0x00, 0xC4, 0x01, // ŤÄ (U+0164 U+00C4)
  0x01, 0x64, 0x00, 0xC5, 0x01, // ŤÅ (U+0164 U+00C5)
  0x01, 0x64, 0x00, 0xE0, 0x01, // Ťà (U+0164 U+00E0)
  0x01, 0x64, 0x00, 0xE1, 0x01, // Ťá (U+0164 U+00E1)
  0x01, 0x64, 0x00, 0xE2, 0x01, // Ťâ (U+0164 U+00E2)
  0x01, 0x64, 0x00, 0xE3, 0x01, // Ťã (U+0164 U+00E3)
  0x01, 0x64, 0x00, 0xE4, 0x01, // Ťä (U+0164 U+00E4)
  0x01, 0x64, 0x00, 0xE5, 0x01, // Ťå (U+0164 U+00E5)
  0x01, 0x64, 0x00, 0xE6, 0x01, // Ťæ (U+0164 U+00E6)
  0x01, 0x64, 0x00, 0xE7, 0x01, // Ťç (U+0164 U+00E7)
  0x01, 0x64, 0x00, 0xE8, 0x01, // Ťè (U+0164 U+00E8)
  0x01, 0x64, 0x00, 0xE9, 0x01, // Ťé (U+0164 U+00E9)
  0x01, 0x64, 0x00, 0xEA, 0x01, // Ťê (U+0164 U+00EA)
  0x01, 0x64, 0x00, 0xEB, 0x01, // Ťë (U+0164 U+00EB)
  0x01, 0x64, 0x00, 0xF2, 0x01, // Ťò (U+0164 U+00F2)
  0x01, 0x64, 0x00, 0xF3, 0x01, // Ťó (U+0164 U+00F3)
  0x01, 0x64, 0x00, 0xF4, 0x01, // Ťô (U+0164 U+00F4)
  0x01, 0x64, 0x00, 0xF5, 0x01, // Ťõ (U+0164 U+00F5)
  0x01, 0x64, 0x00, 0xF6, 0x01, // Ťö (U+0164 U+00F6)
  0x01, 0x64, 0x00, 0xF8, 0x01, // Ťø (U+0164 U+00F8)
  0x01, 0x64, 0x00, 0xF9, 0x01, // Ťù (U+0164 U+00F9)
  0x01, 0x64, 0x00, 0xFA, 0x01, // Ťú (U+0164 U+00FA)
  0x01, 0x64, 0x00, 0xFB, 0x01, // Ťû (U+0164 U+00FB)
  0x01, 0x64, 0x00, 0xFC, 0x01, // Ťü (U+0164 U+00FC)
  0x01, 0x64, 0x01, 0x00, 0x01, // ŤĀ (U+0164 U+0100)
  0x01, 0x64, 0x01, 0x01, 0x01, // Ťā (U+0164 U+0101)
  0x01, 0x64, 0x01, 0x02, 0x01, // ŤĂ (U+0164 U+0102)
  0x01, 0x64, 0x01, 0x03, 0x01, // Ťă (U+0164 U+0103)
  0x01, 0x64, 0x01, 0x04, 0x01, // ŤĄ (U+0164 U+0104)
  0x01, 0x64, 0x01, 0x05, 0x01, // Ťą (U+0164 U+0105)
  0x01, 0x64, 0x01, 0x07, 0x01, // Ťć (U+0164 U+0107)
  0x01, 0x64, 0x01, 0x09, 0x01, // Ťĉ (U+0164 U+0109)
  0x01, 0x64, 0x01, 0x0B, 0x01, // Ťċ (U+0164 U+010B)
  0x01, 0x64, 0x01, 0x0D, 0x01, // Ťč (U+0164 U+010D)
  0x01, 0x64, 0x01, 0x0F, 0x01, // Ťď (U+0164 U+010F)
  0x01, 0x64, 0x01, 0x11, 0x01, // Ťđ (U+0164 U+0111)
  0x01, 0x64, 0x01, 0x13, 0x01, // Ťē (U+0164 U+0113)
  0x01, 0x64, 0x01, 0x15, 0x01, // Ťĕ (U+0164 U+0115)
  0x01, 0x64, 0x01, 0x17, 0x01, // Ťė (U+0164 U+0117)
  0x01, 0x64, 0x01, 0x19, 0x01, // Ťę (U+0164 U+0119)
  0x01, 0x64, 0x01, 0x1B, 0x01, // Ťě (U+0164 U+011B)
  0x01, 0x64, 0x01, 0x1D, 0x01, // Ťĝ (U+0164 U+011D)
  0x01, 0x64, 0x01, 0x1F, 0x01, // Ťğ (U+0164 U+011F)
  0x01, 0x64, 0x01, 0x21, 0x01, // Ťġ (U+0164 U+0121)
  0x01, 0x64, 0x01, 0x23, 0x01, // Ťģ (U+0164 U+0123)
  0x01, 0x64, 0x01, 0x38, 0x01, // Ťĸ (U+0164 U+0138)
  0x01, 0x64, 0x01, 0x44, 0x01, // Ťń (U+0164 U+0144)
  0x01, 0x64, 0x01, 0x46, 0x01, // Ťņ (U+0164 U+0146)
  0x01, 0x64, 0x01, 0x4B, 0x01, // Ťŋ (U+0164 U+014B)
  0x01, 0x64, 0x01, 0x4D, 0x01, // Ťō (U+0164 U+014D)
  0x01, 0x64, 0x01, 0x4F, 0x01, // Ťŏ (U+0164 U+014F)
  0x01, 0x64, 0x01, 0x51, 0x01, // Ťő (U+0164 U+0151)
  0x01, 0x64, 0x01, 0x53, 0x01, // Ťœ (U+0164 U+0153)
  0x01, 0x64, 0x01, 0x55, 0x01, // Ťŕ (U+0164 U+0155)
  0x01, 0x64, 0x01, 0x57, 0x01, // Ťŗ (U+0164 U+0157)
  0x01, 0x64, 0x01, 0x5B, 0x01, // Ťś (U+0164 U+015B)
  0x01, 0x64, 0x01, 0x5F, 0x01, // Ťş (U+0164 U+015F)
  0x01, 0x64, 0x01, 0x69, 0x01, // Ťũ (U+0164 U+0169)
  0x01, 0x64, 0x01, 0x6B, 0x01, // Ťū (U+0164 U+016B)
  0x01, 0x64, 0x01, 0x6D, 0x01, // Ťŭ (U+0164 U+016D)
  0x01, 0x64, 0x01, 0x6F, 0x01, // Ťů (U+0164 U+016F)
  0x01, 0x64, 0x01, 0x71, 0x01, // Ťű (U+0164 U+0171)
  0x01, 0x64, 0x01, 0x73, 0x01, // Ťų (U+0164 U+0173)
  0x01, 0x64, 0x01, 0x7A, 0x01, // Ťź (U+0164 U+017A)
  0x01, 0x64, 0x01, 0x7C, 0x01, // Ťż (U+0164 U+017C)
  0x01, 0x64, 0x01, 0x7E, 0x01, // Ťž (U+0164 U+017E)
  0x01, 0x64, 0x20, 0x13, 0x01, // Ť– (U+0164 U+2013)
  0x01, 0x64, 0x20, 0x14, 0x01, // Ť— (U+0164 U+2014)
  0x01, 0x64, 0x20, 0x1A, 0x01, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x01, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x01, // Ť… (U+0164 U+2026)
  0x01, 0x64, 0x20, 0x39, 0x01, // Ť‹ (U+0164 U+2039)
  0x01, 0x64, 0x20, 0x3A, 0x01, // Ť› (U+0164 U+203A)
  0x01, 0x66, 0x00, 0x2C, 0x01, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2D, 0x01, // Ŧ- (U+0166 U+002D)
  0x01, 0x66, 0x00, 0x2E, 0x01, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0x41, 0x01, // ŦA (U+0166 U+0041)
  0x01, 0x66, 0x00, 0x61, 0x01, // Ŧa (U+0166 U+0061)
  0x01, 0x66, 0x00, 0x63, 0x01, // Ŧc (U+0166 U+0063)
  0x01, 0x66, 0x00, 0x64, 0x01, // Ŧd (U+0166 U+0064)
  0x01, 0x66, 0x00, 0x65, 0x01, // Ŧe (U+0166 U+0065)
  0x01, 0x66, 0x00, 0x67, 0x01, // Ŧg (U+0166 U+0067)
  0x01, 0x66, 0x00, 0x6D, 0x01, // Ŧm (U+0166 U+006D)
  0x01, 0x66, 0x00, 0x6E, 0x01, // Ŧn (U+0166 U+006E)
  0x01, 0x66, 0x00, 0x6F, 0x01, // Ŧo (U+0166 U+006F)
  0x01, 0x66, 0x00, 0x70, 0x01, // Ŧp (U+0166 U+0070)
  0x01, 0x66, 0x00, 0x71, 0x01, // Ŧq (U+0166 U+0071)
  0x01, 0x66, 0x00, 0x72, 0x01, // Ŧr (U+0166 U+0072)
  0x01, 0x66, 0x00, 0x73, 0x01, // Ŧs (U+0166 U+0073)
  0x01, 0x66, 0x00, 0x75, 0x01, // Ŧu (U+0166 U+0075)
  0x01, 0x66, 0x00, 0x7A, 0x01, // Ŧz (U+0166 U+007A)
  0x01, 0x66, 0x00, 0xAB, 0x01, // Ŧ« (U+0166 U+00AB)
  0x01, 0x66, 0x00, 0xBB, 0x01, // Ŧ» (U+0166 U+00BB)
  0x01, 0x66, 0x00, 0xC0, 0x01, // ŦÀ (U+0166 U+00C0)
  0x01, 0x66, 0x00, 0xC1, 0x01, // ŦÁ (U+0166 U+00C1)
  0x01, 0x66, 0x00, 0xC2, 0x01, // ŦÂ (U+0166 U+00C2)
  0x01, 0x66, 0x00, 0xC3, 0x01, // ŦÃ (U+0166 U+00C3)
  0x01, 0x66, 0x00, 0xC4, 0x01, // ŦÄ (U+0166 U+00C4)
  0x01, 0x66, 0x00, 0xC5, 0x01, // ŦÅ (U+0166 U+00C5)
  0x01, 0x66, 0x00, 0xE0, 0x01, // Ŧà (U+0166 U+00E0)
  0x01, 0x66, 0x00, 0xE1, 0x01, // Ŧá (U+0166 U+00E1)
  0x01, 0x66, 0x00, 0xE2, 0x01, // Ŧâ (U+0166 U+00E2)
  0x01, 0x66, 0x00, 0xE3, 0x01, // Ŧã (U+0166 U+00E3)
  0x01, 0x66, 0x00, 0xE4, 0x01, // Ŧä (U+0166 U+00E4)
  0x01, 0x66, 0x00, 0xE5, 0x01, // Ŧå (U+0166 U+00E5)
  0x01, 0x66, 0x00, 0xE6, 0x01, // Ŧæ (U+0166 U+00E6)
  0x01, 0x66, 0x00, 0xE7, 0x01, // Ŧç (U+0166 U+00E7)
  0x01, 0x66, 0x00, 0xE8, 0x01, // Ŧè (U+0166 U+00E8)
  0x01, 0x66, 0x00, 0xE9, 0x01, // Ŧé (U+0166 U+00E9)
  0x01, 0x66, 0x00, 0xEA, 0x01, // Ŧê (U+0166 U+00EA)
  0x01, 0x66, 0x00, 0xEB, 0x01, // Ŧë (U+0166 U+00EB)
  0x01, 0x66, 0x00, 0xF2, 0x01, // Ŧò (U+0166 U+00F2)
  0x01, 0x66, 0x00, 0xF3, 0x01, // Ŧó (U+0166 U+00F3)
  0x01, 0x66, 0x00, 0xF4, 0x01, // Ŧô (U+0166 U+00F4)
  0x01, 0x66, 0x00, 0xF5, 0x01, // Ŧõ (U+0166 U+00F5)
  0x01, 0x66, 0x00, 0xF6, 0x01, // Ŧö (U+0166 U+00F6)
  0x01, 0x66, 0x00, 0xF8, 0x01, // Ŧø (U+0166 U+00F8)
  0x01, 0x66, 0x00, 0xF9, 0x01, // Ŧù (U+0166 U+00F9)
  0x01, 0x66, 0x00, 0xFA, 0x01, // Ŧú (U+0166 U+00FA)
  0x01, 0x66, 0x00, 0xFB, 0x01, // Ŧû (U+0166 U+00FB)
  0x01, 0x66, 0x00, 0xFC, 0x01, // Ŧü (U+0166 U+00FC)
  0x01, 0x66, 0x01, 0x00, 0x01, // ŦĀ (U+0166 U+0100)
  0x01, 0x66, 0x01, 0x01, 0x01, // Ŧā (U+0166 U+0101)
  0x01, 0x66, 0x01, 0x02, 0x01, // ŦĂ (U+0166 U+0102)
  0x01, 0x66, 0x01, 0x03, 0x01, // Ŧă (U+0166 U+0103)
  0x01, 0x66, 0x01, 0x04, 0x01, // ŦĄ (U+0166 U+0104)
  0x01, 0x66, 0x01, 0x05, 0x01, // Ŧą (U+0166 U+0105)
  0x01, 0x66, 0x01, 0x07, 0x01, // Ŧć (U+0166 U+0107)
  0x01, 0x66, 0x01, 0x09, 0x01, // Ŧĉ (U+0166 U+0109)
  0x01, 0x66, 0x01, 0x0B, 0x01, // Ŧċ (U+0166 U+010B)
  0x01, 0x66, 0x01, 0x0D, 0x01, // Ŧč (U+0166 U+010D)
  0x01, 0x66, 0x01, 0x0F, 0x01, // Ŧď (U+0166 U+010F)
  0x01, 0x66, 0x01, 0x11, 0x01, // Ŧđ (U+0166 U+0111)
  0x01, 0x66, 0x01, 0x13, 0x01, // Ŧē (U+0166 U+0113)
  0x01, 0x66, 0x01, 0x15, 0x01, // Ŧĕ (U+0166 U+0115)
  0x01, 0x66, 0x01, 0x17, 0x01, // Ŧė (U+0166 U+0117)
  0x01, 0x66, 0x01, 0x19, 0x01, // Ŧę (U+0166 U+0119)
  0x01, 0x66, 0x01, 0x1B, 0x01, // Ŧě (U+0166 U+011B)
  0x01, 0x66, 0x01, 0x1D, 0x01, // Ŧĝ (U+0166 U+011D)
  0x01, 0x66, 0x01, 0x1F, 0x01, // Ŧğ (U+0166 U+011F)
  0x01, 0x66, 0x01, 0x21, 0x01, // Ŧġ (U+0166 U+0121)
  0x01, 0x66, 0x01, 0x23, 0x01, // Ŧģ (U+0166 U+0123)
  0x01, 0x66, 0x01, 0x38, 0x01, // Ŧĸ (U+0166 U+0138)
  0x01, 0x66, 0x01, 0x44, 0x01, // Ŧń (U+0166 U+0144)
  0x01, 0x66, 0x01, 0x46, 0x01, // Ŧņ (U+0166 U+0146)
  0x01, 0x66, 0x01, 0x4B, 0x01, // Ŧŋ (U+0166 U+014B)
  0x01, 0x66, 0x01, 0x4D, 0x01, // Ŧō (U+0166 U+014D)
  0x01, 0x66, 0x01, 0x4F, 0x01, // Ŧŏ (U+0166 U+014F)
  0x01, 0x66, 0x01, 0x51, 0x01, // Ŧő (U+0166 U+0151)
  0x01, 0x66, 0x01, 0x53, 0x01, // Ŧœ (U+0166 U+0153)
  0x01, 0x66, 0x01, 0x55, 0x01, // Ŧŕ (U+0166 U+0155)
  0x01, 0x66, 0x01, 0x57, 0x01, // Ŧŗ (U+0166 U+0157)
  0x01, 0x66, 0x01, 0x5B, 0x01, // Ŧś (U+0166 U+015B)
  0x01, 0x66, 0x01, 0x5F, 0x01, // Ŧş (U+0166 U+015F)
  0x01, 0x66, 0x01, 0x69, 0x01, // Ŧũ (U+0166 U+0169)
  0x01, 0x66, 0x01, 0x6B, 0x01, // Ŧū (U+0166 U+016B)
  0x01, 0x66, 0x01, 0x6D, 0x01, // Ŧŭ (U+0166 U+016D)
  0x01, 0x66, 0x01, 0x6F, 0x01, // Ŧů (U+0166 U+016F)
  0x01, 0x66, 0x01, 0x71, 0x01, // Ŧű (U+0166 U+0171)
  0x01, 0x66, 0x01, 0x73, 0x01, // Ŧų (U+0166 U+0173)
  0x01, 0x66, 0x01, 0x7A, 0x01, // Ŧź (U+0166 U+017A)
  0x01, 0x66, 0x01, 0x7C, 0x01, // Ŧż (U+0166 U+017C)
  0x01, 0x66, 0x01, 0x7E, 0x01, // Ŧž (U+0166 U+017E)
  0x01, 0x66, 0x20, 0x13, 0x01, // Ŧ– (U+0166 U+2013)
  0x01, 0x66, 0x20, 0x14, 0x01, // Ŧ— (U+0166 U+2014)
  0x01, 0x66, 0x20, 0x1A, 0x01, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x01, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x01, // Ŧ… (U+0166 U+2026)
  0x01, 0x66, 0x20, 0x39, 0x01, // Ŧ‹ (U+0166 U+2039)
  0x01, 0x66, 0x20, 0x3A, 0x01, // Ŧ› (U+0166 U+203A)
  0x01, 0x74, 0x00, 0x2C, 0x01, // Ŵ, (U+0174 U+002C)
  0x01, 0x74, 0x00, 0x2E, 0x01, // Ŵ. (U+0174 U+002E)
  0x01, 0x74, 0x00, 0x41, 0x01, // ŴA (U+0174 U+0041)
  0x01, 0x74, 0x00, 0xAB, 0x01, // Ŵ« (U+0174 U+00AB)
  0x01, 0x74, 0x00, 0xC0, 0x01, // ŴÀ (U+0174 U+00C0)
  0x01, 0x74, 0x00, 0xC1, 0x01, // ŴÁ (U+0174 U+00C1)
  0x01, 0x74, 0x00, 0xC2, 0x01, // ŴÂ (U+0174 U+00C2)
  0x01, 0x74, 0x00, 0xC3, 0x01, // ŴÃ (U+0174 U+00C3)
  0x01, 0x74, 0x00, 0xC4, 0x01, // ŴÄ (U+0174 U+00C4)
  0x01, 0x74, 0x00, 0xC5, 0x01, // ŴÅ (U+0174 U+00C5)
  0x01, 0x74, 0x01, 0x00, 0x01, // ŴĀ (U+0174 U+0100)
  0x01, 0x74, 0x01, 0x02, 0x01, // ŴĂ (U+0174 U+0102)
  0x01, 0x74, 0x01, 0x04, 0x01, // ŴĄ (U+0174 U+0104)
  0x01, 0x74, 0x20, 0x1A, 0x01, // Ŵ‚ (U+0174 U+201A)
  0x01, 0x74, 0x20, 0x1E, 0x01, // Ŵ„ (U+0174 U+201E)
  0x01, 0x74, 0x20, 0x26, 0x01, // Ŵ… (U+0174 U+2026)
  0x01, 0x74, 0x20, 0x39, 0x01, // Ŵ‹ (U+0174 U+2039)
  0x01, 0x75, 0x00, 0x2C, 0x01, // ŵ, (U+0175 U+002C)
  0x01, 0x75, 0x00, 0x2E, 0x01, // ŵ. (U+0175 U+002E)
  0x01, 0x75, 0x20, 0x1A, 0x01, // ŵ‚ (U+0175 U+201A)
  0x01, 0x75, 0x20, 0x1E, 0x01, // ŵ„ (U+0175 U+201E)
  0x01, 0x75, 0x20, 0x26, 0x01, // ŵ… (U+0175 U+2026)
  0x01, 0x76, 0x00, 0x26, 0x01, // Ŷ& (U+0176 U+0026)
  0x01, 0x76, 0x00, 0x2C, 0x01, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x01, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x00, 0x41, 0x01, // ŶA (U+0176 U+0041)
  0x01, 0x76, 0x00, 0x61, 0x01, // Ŷa (U+0176 U+0061)
  0x01, 0x76, 0x00, 0x63, 0x01, // Ŷc (U+0176 U+0063)
  0x01, 0x76, 0x00, 0x64, 0x01, // Ŷd (U+0176 U+0064)
  0x01, 0x76, 0x00, 0x65, 0x01, // Ŷe (U+0176 U+0065)
  0x01, 0x76, 0x00, 0x67, 0x01, // Ŷg (U+0176 U+0067)
  0x01, 0x76, 0x00, 0x6D, 0x01, // Ŷm (U+0176 U+006D)
  0x01, 0x76, 0x00, 0x6E, 0x01, // Ŷn (U+0176 U+006E)
  0x01, 0x76, 0x00, 0x6F, 0x01, // Ŷo (U+0176 U+006F)
  0x01, 0x76, 0x00, 0x70, 0x01, // Ŷp (U+0176 U+0070)
  0x01, 0x76, 0x00, 0x71, 0x01, // Ŷq (U+0176 U+0071)
  0x01, 0x76, 0x00, 0x72, 0x01, // Ŷr (U+0176 U+0072)
  0x01, 0x76, 0x00, 0x73, 0x01, // Ŷs (U+0176 U+0073)
  0x01, 0x76, 0x00, 0x75, 0x01, // Ŷu (U+0176 U+0075)
  0x01, 0x76, 0x00, 0xAB, 0x01, // Ŷ« (U+0176 U+00AB)
  0x01, 0x76, 0x00, 0xBB, 0x01, // Ŷ» (U+0176 U+00BB)
  0x01, 0x76, 0x00, 0xC0, 0x01, // ŶÀ (U+0176 U+00C0)
  0x01, 0x76, 0x00, 0xC1, 0x01, // ŶÁ (U+0176 U+00C1)
  0x01, 0x76, 0x00, 0xC2, 0x01, // ŶÂ (U+0176 U+00C2)
  0x01, 0x76, 0x00, 0xC3, 0x01, // ŶÃ (U+0176 U+00C3)
  0x01, 0x76, 0x00, 0xC4, 0x01, // ŶÄ (U+0176 U+00C4)
  0x01, 0x76, 0x00, 0xC5, 0x01, // ŶÅ (U+0176 U+00C5)
  0x01, 0x76, 0x00, 0xE0, 0x01, // Ŷà (U+0176 U+00E0)
  0x01, 0x76, 0x00, 0xE1, 0x01, // Ŷá (U+0176 U+00E1)
  0x01, 0x76, 0x00, 0xE2, 0x01, // Ŷâ (U+0176 U+00E2)
  0x01, 0x76, 0x00, 0xE3, 0x01, // Ŷã (U+0176 U+00E3)
  0x01, 0x76, 0x00, 0xE4, 0x01, // Ŷä (U+0176 U+00E4)
  0x01, 0x76, 0x00, 0xE5, 0x01, // Ŷå (U+0176 U+00E5)
  0x01, 0x76, 0x00, 0xE6, 0x01, // Ŷæ (U+0176 U+00E6)
  0x01, 0x76, 0x00, 0xE7, 0x01, // Ŷç (U+0176 U+00E7)
  0x01, 0x76, 0x00, 0xE8, 0x01, // Ŷè (U+0176 U+00E8)
  0x01, 0x76, 0x00, 0xE9, 0x01, // Ŷé (U+0176 U+00E9)
  0x01, 0x76, 0x00, 0xEA, 0x01, // Ŷê (U+0176 U+00EA)
  0x01, 0x76, 0x00, 0xEB, 0x01, // Ŷë (U+0176 U+00EB)
  0x01, 0x76, 0x00, 0xF2, 0x01, // Ŷò (U+0176 U+00F2)
  0x01, 0x76, 0x00, 0xF3, 0x01, // Ŷó (U+0176 U+00F3)
  0x01, 0x76, 0x00, 0xF4, 0x01, // Ŷô (U+0176 U+00F4)
  0x01, 0x76, 0x00, 0xF5, 0x01, // Ŷõ (U+0176 U+00F5)
  0x01, 0x76, 0x00, 0xF6, 0x01, // Ŷö (U+0176 U+00F6)
  0x01, 0x76, 0x00, 0xF8, 0x01, // Ŷø (U+0176 U+00F8)
  0x01, 0x76, 0x00, 0xF9, 0x01, // Ŷù (U+0176 U+00F9)
  0x01, 0x76, 0x00, 0xFA, 0x01, // Ŷú (U+0176 U+00FA)
  0x01, 0x76, 0x00, 0xFB, 0x01, // Ŷû (U+0176 U+00FB)
  0x01, 0x76, 0x00, 0xFC, 0x01, // Ŷü (U+0176 U+00FC)
  0x01, 0x76, 0x01, 0x00, 0x01, // ŶĀ (U+0176 U+0100)
  0x01, 0x76, 0x01, 0x01, 0x01, // Ŷā (U+0176 U+0101)
  0x01, 0x76, 0x01, 0x02, 0x01, // ŶĂ (U+0176 U+0102)
  0x01, 0x76, 0x01, 0x03, 0x01, // Ŷă (U+0176 U+0103)
  0x01, 0x76, 0x01, 0x04, 0x01, // ŶĄ (U+0176 U+0104)
  0x01, 0x76, 0x01, 0x05, 0x01, // Ŷą (U+0176 U+0105)
  0x01, 0x76, 0x01, 0x07, 0x01, // Ŷć (U+0176 U+0107)
  0x01, 0x76, 0x01, 0x09, 0x01, // Ŷĉ (U+0176 U+0109)
  0x01, 0x76, 0x01, 0x0B, 0x01, // Ŷċ (U+0176 U+010B)
  0x01, 0x76, 0x01, 0x0D, 0x01, // Ŷč (U+0176 U+010D)
  0x01, 0x76, 0x01, 0x0F, 0x01, // Ŷď (U+0176 U+010F)
  0x01, 0x76, 0x01, 0x11, 0x01, // Ŷđ (U+0176 U+0111)
  0x01, 0x76, 0x01, 0x13, 0x01, // Ŷē (U+0176 U+0113)
  0x01, 0x76, 0x01, 0x15, 0x01, // Ŷĕ (U+0176 U+0115)
  0x01, 0x76, 0x01, 0x17, 0x01, // Ŷė (U+0176 U+0117)
  0x01, 0x76, 0x01, 0x19, 0x01, // Ŷę (U+0176 U+0119)
  0x01, 0x76, 0x01, 0x1B, 0x01, // Ŷě (U+0176 U+011B)
  0x01, 0x76, 0x01, 0x1D, 0x01, // Ŷĝ (U+0176 U+011D)
  0x01, 0x76, 0x01, 0x1F, 0x01, // Ŷğ (U+0176 U+011F)
  0x01, 0x76, 0x01, 0x21, 0x01, // Ŷġ (U+0176 U+0121)
  0x01, 0x76, 0x01, 0x23, 0x01, // Ŷģ (U+0176 U+0123)
  0x01, 0x76, 0x01, 0x38, 0x01, // Ŷĸ (U+0176 U+0138)
  0x01, 0x76, 0x01, 0x44, 0x01, // Ŷń (U+0176 U+0144)
  0x01, 0x76, 0x01, 0x46, 0x01, // Ŷņ (U+0176 U+0146)
  0x01, 0x76, 0x01, 0x4B, 0x01, // Ŷŋ (U+0176 U+014B)
  0x01, 0x76, 0x01, 0x4D, 0x01, // Ŷō (U+0176 U+014D)
  0x01, 0x76, 0x01, 0x4F, 0x01, // Ŷŏ (U+0176 U+014F)
  0x01, 0x76, 0x01, 0x51, 0x01, // Ŷő (U+0176 U+0151)
  0x01, 0x76, 0x01, 0x53, 0x01, // Ŷœ (U+0176 U+0153)
  0x01, 0x76, 0x01, 0x55, 0x01, // Ŷŕ (U+0176 U+0155)
  0x01, 0x76, 0x01, 0x57, 0x01, // Ŷŗ (U+0176 U+0157)
  0x01, 0x76, 0x01, 0x5B, 0x01, // Ŷś (U+0176 U+015B)
  0x01, 0x76, 0x01, 0x5F, 0x01, // Ŷş (U+0176 U+015F)
  0x01, 0x76, 0x01, 0x69, 0x01, // Ŷũ (U+0176 U+0169)
  0x01, 0x76, 0x01, 0x6B, 0x01, // Ŷū (U+0176 U+016B)
  0x01, 0x76, 0x01, 0x6D, 0x01, // Ŷŭ (U+0176 U+016D)
  0x01, 0x76, 0x01, 0x6F, 0x01, // Ŷů (U+0176 U+016F)
  0x01, 0x76, 0x01, 0x71, 0x01, // Ŷű (U+0176 U+0171)
  0x01, 0x76, 0x01, 0x73, 0x01, // Ŷų (U+0176 U+0173)
  0x01, 0x76, 0x20, 0x1A, 0x01, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x01, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x01, // Ŷ… (U+0176 U+2026)
  0x01, 0x76, 0x20, 0x39, 0x01, // Ŷ‹ (U+0176 U+2039)
  0x01, 0x76, 0x20, 0x3A, 0x01, // Ŷ› (U+0176 U+203A)
  0x01, 0x77, 0x00, 0x2C, 0x01, // ŷ, (U+0177 U+002C)
  0x01, 0x77, 0x00, 0x2E, 0x01, // ŷ. (U+0177 U+002E)
  0x01, 0x77, 0x20, 0x1A, 0x01, // ŷ‚ (U+0177 U+201A)
  0x01, 0x77, 0x20, 0x1E, 0x01, // ŷ„ (U+0177 U+201E)
  0x01, 0x77, 0x20, 0x26, 0x01, // ŷ… (U+0177 U+2026)
  0x01, 0x78, 0x00, 0x26, 0x01, // Ÿ& (U+0178 U+0026)
  0x01, 0x78, 0x00, 0x2C, 0x01, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x01, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x00, 0x41, 0x01, // ŸA (U+0178 U+0041)
  0x01, 0x78, 0x00, 0x61, 0x01, // Ÿa (U+0178 U+0061)
  0x01, 0x78, 0x00, 0x63, 0x01, // Ÿc (U+0178 U+0063)
  0x01, 0x78, 0x00, 0x64, 0x01, // Ÿd (U+0178 U+0064)
  0x01, 0x78, 0x00, 0x65, 0x01, // Ÿe (U+0178 U+0065)
  0x01, 0x78, 0x00, 0x67, 0x01, // Ÿg (U+0178 U+0067)
  0x01, 0x78, 0x00, 0x6D, 0x01, // Ÿm (U+0178 U+006D)
  0x01, 0x78, 0x00, 0x6E, 0x01, // Ÿn (U+0178 U+006E)
  0x01, 0x78, 0x00, 0x6F, 0x01, // Ÿo (U+0178 U+006F)
  0x01, 0x78, 0x00, 0x70, 0x01, // Ÿp (U+0178 U+0070)
  0x01, 0x78, 0x00, 0x71, 0x01, // Ÿq (U+0178 U+0071)
  0x01, 0x78, 0x00, 0x72, 0x01, // Ÿr (U+0178 U+0072)
  0x01, 0x78, 0x00, 0x73, 0x01, // Ÿs (U+0178 U+0073)
  0x01, 0x78, 0x00, 0x75, 0x01, // Ÿu (U+0178 U+0075)
  0x01, 0x78, 0x00, 0xAB, 0x01, // Ÿ« (U+0178 U+00AB)
  0x01, 0x78, 0x00, 0xBB, 0x01, // Ÿ» (U+0178 U+00BB)
  0x01, 0x78, 0x00, 0xC0, 0x01, // ŸÀ (U+0178 U+00C0)
  0x01, 0x78, 0x00, 0xC1, 0x01, // ŸÁ (U+0178 U+00C1)
  0x01, 0x78, 0x00, 0xC2, 0x01, // ŸÂ (U+0178 U+00C2)
  0x01, 0x78, 0x00, 0xC3, 0x01, // ŸÃ (U+0178 U+00C3)
  0x01, 0x78, 0x00, 0xC4, 0x01, // ŸÄ (U+0178 U+00C4)
  0x01, 0x78, 0x00, 0xC5, 0x01, // ŸÅ (U+0178 U+00C5)
  0x01, 0x78, 0x00, 0xE0, 0x01, // Ÿà (U+0178 U+00E0)
  0x01, 0x78, 0x00, 0xE1, 0x01, // Ÿá (U+0178 U+00E1)
  0x01, 0x78, 0x00, 0xE2, 0x01, // Ÿâ (U+0178 U+00E2)
  0x01, 0x78, 0x00, 0xE3, 0x01, // Ÿã (U+0178 U+00E3)
  0x01, 0x78, 0x00, 0xE4, 0x01, // Ÿä (U+0178 U+00E4)
  0x01, 0x78, 0x00, 0xE5, 0x01, // Ÿå (U+0178 U+00E5)
  0x01, 0x78, 0x00, 0xE6, 0x01, // Ÿæ (U+0178 U+00E6)
  0x01, 0x78, 0x00, 0xE7, 0x01, // Ÿç (U+0178 U+00E7)
  0x01, 0x78, 0x00, 0xE8, 0x01, // Ÿè (U+0178 U+00E8)
  0x01, 0x78, 0x00, 0xE9, 0x01, // Ÿé (U+0178 U+00E9)
  0x01, 0x78, 0x00, 0xEA, 0x01, // Ÿê (U+0178 U+00EA)
  0x01, 0x78, 0x00, 0xEB, 0x01, // Ÿë (U+0178 U+00EB)
  0x01, 0x78, 0x00, 0xF2, 0x01, // Ÿò (U+0178 U+00F2)
  0x01, 0x78, 0x00, 0xF3, 0x01, // Ÿó (U+0178 U+00F3)
  0x01, 0x78, 0x00, 0xF4, 0x01, // Ÿô (U+0178 U+00F4)
  0x01, 0x78, 0x00, 0xF5, 0x01, // Ÿõ (U+0178 U+00F5)
  0x01, 0x78, 0x00, 0xF6, 0x01, // Ÿö (U+0178 U+00F6)
  0x01, 0x78, 0x00, 0xF8, 0x01, // Ÿø (U+0178 U+00F8)
  0x01, 0x78, 0x00, 0xF9, 0x01, // Ÿù (U+0178 U+00F9)
  0x01, 0x78, 0x00, 0xFA, 0x01, // Ÿú (U+0178 U+00FA)
  0x01, 0x78, 0x00, 0xFB, 0x01, // Ÿû (U+0178 U+00FB)
  0x01, 0x78, 0x00, 0xFC, 0x01, // Ÿü (U+0178 U+00FC)
  0x01, 0x78, 0x01, 0x00, 0x01, // ŸĀ (U+0178 U+0100)
  0x01, 0x78, 0x01, 0x01, 0x01, // Ÿā (U+0178 U+0101)
  0x01, 0x78, 0x01, 0x02, 0x01, // ŸĂ (U+0178 U+0102)
  0x01, 0x78, 0x01, 0x03, 0x01, // Ÿă (U+0178 U+0103)
  0x01, 0x78, 0x01, 0x04, 0x01, // ŸĄ (U+0178 U+0104)
  0x01, 0x78, 0x01, 0x05, 0x01, // Ÿą (U+0178 U+0105)
  0x01, 0x78, 0x01, 0x07, 0x01, // Ÿć (U+0178 U+0107)
  0x01, 0x78, 0x01, 0x09, 0x01, // Ÿĉ (U+0178 U+0109)
  0x01, 0x78, 0x01, 0x0B, 0x01, // Ÿċ (U+0178 U+010B)
  0x01, 0x78, 0x01, 0x0D, 0x01, // Ÿč (U+0178 U+010D)
  0x01, 0x78, 0x01, 0x0F, 0x01, // Ÿď (U+0178 U+010F)
  0x01, 0x78, 0x01, 0x11, 0x01, // Ÿđ (U+0178 U+0111)
  0x01, 0x78, 0x01, 0x13, 0x01, // Ÿē (U+0178 U+0113)
  0x01, 0x78, 0x01, 0x15, 0x01, // Ÿĕ (U+0178 U+0115)
  0x01, 0x78, 0x01, 0x17, 0x01, // Ÿė (U+0178 U+0117)
  0x01, 0x78, 0x01, 0x19, 0x01, // Ÿę (U+0178 U+0119)
  0x01, 0x78, 0x01, 0x1B, 0x01, // Ÿě (U+0178 U+011B)
  0x01, 0x78, 0x01, 0x1D, 0x01, // Ÿĝ (U+0178 U+011D)
  0x01, 0x78, 0x01, 0x1F, 0x01, // Ÿğ (U+0178 U+011F)
  0x01, 0x78, 0x01, 0x21, 0x01, // Ÿġ (U+0178 U+0121)
  0x01, 0x78, 0x01, 0x23, 0x01, // Ÿģ (U+0178 U+0123)
  0x01, 0x78, 0x01, 0x38, 0x01, // Ÿĸ (U+0178 U+0138)
  0x01, 0x78, 0x01, 0x44, 0x01, // Ÿń (U+0178 U+0144)
  0x01, 0x78, 0x01, 0x46, 0x01, // Ÿņ (U+0178 U+0146)
  0x01, 0x78, 0x01, 0x4B, 0x01, // Ÿŋ (U+0178 U+014B)
  0x01, 0x78, 0x01, 0x4D, 0x01, // Ÿō (U+0178 U+014D)
  0x01, 0x78, 0x01, 0x4F, 0x01, // Ÿŏ (U+0178 U+014F)
  0x01, 0x78, 0x01, 0x51, 0x01, // Ÿő (U+0178 U+0151)
  0x01, 0x78, 0x01, 0x53, 0x01, // Ÿœ (U+0178 U+0153)
  0x01, 0x78, 0x01, 0x55, 0x01, // Ÿŕ (U+0178 U+0155)
  0x01, 0x78, 0x01, 0x57, 0x01, // Ÿŗ (U+0178 U+0157)
  0x01, 0x78, 0x01, 0x5B, 0x01, // Ÿś (U+0178 U+015B)
  0x01, 0x78, 0x01, 0x5F, 0x01, // Ÿş (U+0178 U+015F)
  0x01, 0x78, 0x01, 0x69, 0x01, // Ÿũ (U+0178 U+0169)
  0x01, 0x78, 0x01, 0x6B, 0x01, // Ÿū (U+0178 U+016B)
  0x01, 0x78, 0x01, 0x6D, 0x01, // Ÿŭ (U+0178 U+016D)
  0x01, 0x78, 0x01, 0x6F, 0x01, // Ÿů (U+0178 U+016F)
  0x01, 0x78, 0x01, 0x71, 0x01, // Ÿű (U+0178 U+0171)
  0x01, 0x78, 0x01, 0x73, 0x01, // Ÿų (U+0178 U+0173)
  0x01, 0x78, 0x20, 0x1A, 0x01, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x01, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x01, // Ÿ… (U+0178 U+2026)
  0x01, 0x78, 0x20, 0x39, 0x01, // Ÿ‹ (U+0178 U+2039)
  0x01, 0x78, 0x20, 0x3A, 0x01, // Ÿ› (U+0178 U+203A)
  0x20, 0x13, 0x00, 0x54, 0x01, // –T (U+2013 U+0054)
  0x20, 0x13, 0x01, 0x62, 0x01, // –Ţ (U+2013 U+0162)
  0x20, 0x13, 0x01, 0x64, 0x01, // –Ť (U+2013 U+0164)
  0x20, 0x13, 0x01, 0x66, 0x01, // –Ŧ (U+2013 U+0166)
  0x20, 0x14, 0x00, 0x54, 0x01, // —T (U+2014 U+0054)
  0x20, 0x14, 0x01, 0x62, 0x01, // —Ţ (U+2014 U+0162)
  0x20, 0x14, 0x01, 0x64, 0x01, // —Ť (U+2014 U+0164)
  0x20, 0x14, 0x01, 0x66, 0x01, // —Ŧ (U+2014 U+0166)
  0x20, 0x18, 0x00, 0x41, 0x01, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0x61, 0x01, // ‘a (U+2018 U+0061)
  0x20, 0x18, 0x00, 0x63, 0x01, // ‘c (U+2018 U+0063)
  0x20, 0x18, 0x00, 0x64, 0x01, // ‘d (U+2018 U+0064)
  0x20, 0x18, 0x00, 0x65, 0x01, // ‘e (U+2018 U+0065)
  0x20, 0x18, 0x00, 0x67, 0x01, // ‘g (U+2018 U+0067)
  0x20, 0x18, 0x00, 0x6D, 0x01, // ‘m (U+2018 U+006D)
  0x20, 0x18, 0x00, 0x6E, 0x01, // ‘n (U+2018 U+006E)
  0x20, 0x18, 0x00, 0x6F, 0x01, // ‘o (U+2018 U+006F)
  0x20, 0x18, 0x00, 0x70, 0x01, // ‘p (U+2018 U+0070)
  0x20, 0x18, 0x00, 0x71, 0x01, // ‘q (U+2018 U+0071)
  0x20, 0x18, 0x00, 0x72, 0x01, // ‘r (U+2018 U+0072)
  0x20, 0x18, 0x00, 0x73, 0x01, // ‘s (U+2018 U+0073)
  0x20, 0x18, 0x00, 0x75, 0x01, // ‘u (U+2018 U+0075)
  0x20, 0x18, 0x00, 0xC0, 0x01, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x01, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x01, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x01, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x01, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x01, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xC6, 0x01, // ‘Æ (U+2018 U+00C6)
  0x20, 0x18, 0x00, 0xE0, 0x01, // ‘à (U+2018 U+00E0)
  0x20, 0x18, 0x00, 0xE1, 0x01, // ‘á (U+2018 U+00E1)
  0x20, 0x18, 0x00, 0xE2, 0x01, // ‘â (U+2018 U+00E2)
  0x20, 0x18, 0x00, 0xE3, 0x01, // ‘ã (U+2018 U+00E3)
  0x20, 0x18, 0x00, 0xE4, 0x01, // ‘ä (U+2018 U+00E4)
  0x20, 0x18, 0x00, 0xE5, 0x01, // ‘å (U+2018 U+00E5)
  0x20, 0x18, 0x00, 0xE6, 0x01, // ‘æ (U+2018 U+00E6)
  0x20, 0x18, 0x00, 0xE7, 0x01, // ‘ç (U+2018 U+00E7)
  0x20, 0x18, 0x00, 0xE8, 0x01, // ‘è (U+2018 U+00E8)
  0x20, 0x18, 0x00, 0xE9, 0x01, // ‘é (U+2018 U+00E9)
  0x20, 0x18, 0x00, 0xEA, 0x01, // ‘ê (U+2018 U+00EA)
  0x20, 0x18, 0x00, 0xEB, 0x01, // ‘ë (U+2018 U+00EB)
  0x20, 0x18, 0x00, 0xF2, 0x01, // ‘ò (U+2018 U+00F2)
  0x20, 0x18, 0x00, 0xF3, 0x01, // ‘ó (U+2018 U+00F3)
  0x20, 0x18, 0x00, 0xF4, 0x01, // ‘ô (U+2018 U+00F4)
  0x20, 0x18, 0x00, 0xF5, 0x01, // ‘õ (U+2018 U+00F5)
  0x20, 0x18, 0x00, 0xF6, 0x01, // ‘ö (U+2018 U+00F6)
  0x20, 0x18, 0x00, 0xF8, 0x01, // ‘ø (U+2018 U+00F8)
  0x20, 0x18, 0x00, 0xF9, 0x01, // ‘ù (U+2018 U+00F9)
  0x20, 0x18, 0x00, 0xFA, 0x01, // ‘ú (U+2018 U+00FA)
  0x20, 0x18, 0x00, 0xFB, 0x01, // ‘û (U+2018 U+00FB)
  0x20, 0x18, 0x00, 0xFC, 0x01, // ‘ü (U+2018 U+00FC)
  0x20, 0x18, 0x01, 0x00, 0x01, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x01, 0x01, // ‘ā (U+2018 U+0101)
  0x20, 0x18, 0x01, 0x02, 0x01, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x03, 0x01, // ‘ă (U+2018 U+0103)
  0x20, 0x18, 0x01, 0x04, 0x01, // ‘Ą (U+2018 U+0104)
  0x20, 0x18, 0x01, 0x05, 0x01, // ‘ą (U+2018 U+0105)
  0x20, 0x18, 0x01, 0x07, 0x01, // ‘ć (U+2018 U+0107)
  0x20, 0x18, 0x01, 0x09, 0x01, // ‘ĉ (U+2018 U+0109)
  0x20, 0x18, 0x01, 0x0B, 0x01, // ‘ċ (U+2018 U+010B)
  0x20, 0x18, 0x01, 0x0D, 0x01, // ‘č (U+2018 U+010D)
  0x20, 0x18, 0x01, 0x0F, 0x01, // ‘ď (U+2018 U+010F)
  0x20, 0x18, 0x01, 0x11, 0x01, // ‘đ (U+2018 U+0111)
  0x20, 0x18, 0x01, 0x13, 0x01, // ‘ē (U+2018 U+0113)
  0x20, 0x18, 0x01, 0x15, 0x01, // ‘ĕ (U+2018 U+0115)
  0x20, 0x18, 0x01, 0x17, 0x01, // ‘ė (U+2018 U+0117)
  0x20, 0x18, 0x01, 0x19, 0x01, // ‘ę (U+2018 U+0119)
  0x20, 0x18, 0x01, 0x1B, 0x01, // ‘ě (U+2018 U+011B)
  0x20, 0x18, 0x01, 0x1D, 0x01, // ‘ĝ (U+2018 U+011D)
  0x20, 0x18, 0x01, 0x1F, 0x01, // ‘ğ (U+2018 U+011F)
  0x20, 0x18, 0x01, 0x21, 0x01, // ‘ġ (U+2018 U+0121)
  0x20, 0x18, 0x01, 0x23, 0x01, // ‘ģ (U+2018 U+0123)
  0x20, 0x18, 0x01, 0x38, 0x01, // ‘ĸ (U+2018 U+0138)
  0x20, 0x18, 0x01, 0x44, 0x01, // ‘ń (U+2018 U+0144)
  0x20, 0x18, 0x01, 0x46, 0x01, // ‘ņ (U+2018 U+0146)
  0x20, 0x18, 0x01, 0x4B, 0x01, // ‘ŋ (U+2018 U+014B)
  0x20, 0x18, 0x01, 0x4D, 0x01, // ‘ō (U+2018 U+014D)
  0x20, 0x18, 0x01, 0x4F, 0x01, // ‘ŏ (U+2018 U+014F)
  0x20, 0x18, 0x01, 0x51, 0x01, // ‘ő (U+2018 U+0151)
  0x20, 0x18, 0x01, 0x53, 0x01, // ‘œ (U+2018 U+0153)
  0x20, 0x18, 0x01, 0x55, 0x01, // ‘ŕ (U+2018 U+0155)
  0x20, 0x18, 0x01, 0x57, 0x01, // ‘ŗ (U+2018 U+0157)
  0x20, 0x18, 0x01, 0x5B, 0x01, // ‘ś (U+2018 U+015B)
  0x20, 0x18, 0x01, 0x5F, 0x01, // ‘ş (U+2018 U+015F)
  0x20, 0x18, 0x01, 0x69, 0x01, // ‘ũ (U+2018 U+0169)
  0x20, 0x18, 0x01, 0x6B, 0x01, // ‘ū (U+2018 U+016B)
  0x20, 0x18, 0x01, 0x6D, 0x01, // ‘ŭ (U+2018 U+016D)
  0x20, 0x18, 0x01, 0x6F, 0x01, // ‘ů (U+2018 U+016F)
  0x20, 0x18, 0x01, 0x71, 0x01, // ‘ű (U+2018 U+0171)
  0x20, 0x18, 0x01, 0x73, 0x01, // ‘ų (U+2018 U+0173)
  0x20, 0x19, 0x00, 0x41, 0x01, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0x61, 0x01, // ’a (U+2019 U+0061)
  0x20, 0x19, 0x00, 0x63, 0x01, // ’c (U+2019 U+0063)
  0x20, 0x19, 0x00, 0x64, 0x01, // ’d (U+2019 U+0064)
  0x20, 0x19, 0x00, 0x65, 0x01, // ’e (U+2019 U+0065)
  0x20, 0x19, 0x00, 0x67, 0x01, // ’g (U+2019 U+0067)
  0x20, 0x19, 0x00, 0x6D, 0x01, // ’m (U+2019 U+006D)
  0x20, 0x19, 0x00, 0x6E, 0x01, // ’n (U+2019 U+006E)
  0x20, 0x19, 0x00, 0x6F, 0x01, // ’o (U+2019 U+006F)
  0x20, 0x19, 0x00, 0x70, 0x01, // ’p (U+2019 U+0070)
  0x20, 0x19, 0x00, 0x71, 0x01, // ’q (U+2019 U+0071)
  0x20, 0x19, 0x00, 0x72, 0x01, // ’r (U+2019 U+0072)
  0x20, 0x19, 0x00, 0x73, 0x01, // ’s (U+2019 U+0073)
  0x20, 0x19, 0x00, 0x75, 0x01, // ’u (U+2019 U+0075)
  0x20, 0x19, 0x00, 0xC0, 0x01, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x01, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x01, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x01, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x01, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x01, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xC6, 0x01, // ’Æ (U+2019 U+00C6)
  0x20, 0x19, 0x00, 0xE0, 0x01, // ’à (U+2019 U+00E0)
  0x20, 0x19, 0x00, 0xE1, 0x01, // ’á (U+2019 U+00E1)
  0x20, 0x19, 0x00, 0xE2, 0x01, // ’â (U+2019 U+00E2)
  0x20, 0x19, 0x00, 0xE3, 0x01, // ’ã (U+2019 U+00E3)
  0x20, 0x19, 0x00, 0xE4, 0x01, // ’ä (U+2019 U+00E4)
  0x20, 0x19, 0x00, 0xE5, 0x01, // ’å (U+2019 U+00E5)
  0x20, 0x19, 0x00, 0xE6, 0x01, // ’æ (U+2019 U+00E6)
  0x20, 0x19, 0x00, 0xE7, 0x01, // ’ç (U+2019 U+00E7)
  0x20, 0x19, 0x00, 0xE8, 0x01, // ’è (U+2019 U+00E8)
  0x20, 0x19, 0x00, 0xE9, 0x01, // ’é (U+2019 U+00E9)
  0x20, 0x19, 0x00, 0xEA, 0x01, // ’ê (U+2019 U+00EA)
  0x20, 0x19, 0x00, 0xEB, 0x01, // ’ë (U+2019 U+00EB)
  0x20, 0x19, 0x00, 0xF2, 0x01, // ’ò (U+2019 U+00F2)
  0x20, 0x19, 0x00, 0xF3, 0x01, // ’ó (U+2019 U+00F3)
  0x20, 0x19, 0x00, 0xF4, 0x01, // ’ô (U+2019 U+00F4)
  0x20, 0x19, 0x00, 0xF5, 0x01, // ’õ (U+2019 U+00F5)
  0x20, 0x19, 0x00, 0xF6, 0x01, // ’ö (U+2019 U+00F6)
  0x20, 0x19, 0x00, 0xF8, 0x01, // ’ø (U+2019 U+00F8)
  0x20, 0x19, 0x00, 0xF9, 0x01, // ’ù (U+2019 U+00F9)
  0x20, 0x19, 0x00, 0xFA, 0x01, // ’ú (U+2019 U+00FA)
  0x20, 0x19, 0x00, 0xFB, 0x01, // ’û (U+2019 U+00FB)
  0x20, 0x19, 0x00, 0xFC, 0x01, // ’ü (U+2019 U+00FC)
  0x20, 0x19, 0x01, 0x00, 0x01, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x01, 0x01, // ’ā (U+2019 U+0101)
  0x20, 0x19, 0x01, 0x02, 0x01, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x03, 0x01, // ’ă (U+2019 U+0103)
  0x20, 0x19, 0x01, 0x04, 0x01, // ’Ą (U+2019 U+0104)
  0x20, 0x19, 0x01, 0x05, 0x01, // ’ą (U+2019 U+0105)
  0x20, 0x19, 0x01, 0x07, 0x01, // ’ć (U+2019 U+0107)
  0x20, 0x19, 0x01, 0x09, 0x01, // ’ĉ (U+2019 U+0109)
  0x20, 0x19, 0x01, 0x0B, 0x01, // ’ċ (U+2019 U+010B)
  0x20, 0x19, 0x01, 0x0D, 0x01, // ’č (U+2019 U+010D)
  0x20, 0x19, 0x01, 0x0F, 0x01, // ’ď (U+2019 U+010F)
  0x20, 0x19, 0x01, 0x11, 0x01, // ’đ (U+2019 U+0111)
  0x20, 0x19, 0x01, 0x13, 0x01, // ’ē (U+2019 U+0113)
  0x20, 0x19, 0x01, 0x15, 0x01, // ’ĕ (U+2019 U+0115)
  0x20, 0x19, 0x01, 0x17, 0x01, // ’ė (U+2019 U+0117)
  0x20, 0x19, 0x01, 0x19, 0x01, // ’ę (U+2019 U+0119)
  0x20, 0x19, 0x01, 0x1B, 0x01, // ’ě (U+2019 U+011B)
  0x20, 0x19, 0x01, 0x1D, 0x01, // ’ĝ (U+2019 U+011D)
  0x20, 0x19, 0x01, 0x1F, 0x01, // ’ğ (U+2019 U+011F)
  0x20, 0x19, 0x01, 0x21, 0x01, // ’ġ (U+2019 U+0121)
  0x20, 0x19, 0x01, 0x23, 0x01, // ’ģ (U+2019 U+0123)
  0x20, 0x19, 0x01, 0x38, 0x01, // ’ĸ (U+2019 U+0138)
  0x20, 0x19, 0x01, 0x44, 0x01, // ’ń (U+2019 U+0144)
  0x20, 0x19, 0x01, 0x46, 0x01, // ’ņ (U+2019 U+0146)
  0x20, 0x19, 0x01, 0x4B, 0x01, // ’ŋ (U+2019 U+014B)
  0x20, 0x19, 0x01, 0x4D, 0x01, // ’ō (U+2019 U+014D)
  0x20, 0x19, 0x01, 0x4F, 0x01, // ’ŏ (U+2019 U+014F)
  0x20, 0x19, 0x01, 0x51, 0x01, // ’ő (U+2019 U+0151)
  0x20, 0x19, 0x01, 0x53, 0x01, // ’œ (U+2019 U+0153)
  0x20, 0x19, 0x01, 0x55, 0x01, // ’ŕ (U+2019 U+0155)
  0x20, 0x19, 0x01, 0x57, 0x01, // ’ŗ (U+2019 U+0157)
  0x20, 0x19, 0x01, 0x5B, 0x01, // ’ś (U+2019 U+015B)
  0x20, 0x19, 0x01, 0x5F, 0x01, // ’ş (U+2019 U+015F)
  0x20, 0x19, 0x01, 0x69, 0x01, // ’ũ (U+2019 U+0169)
  0x20, 0x19, 0x01, 0x6B, 0x01, // ’ū (U+2019 U+016B)
  0x20, 0x19, 0x01, 0x6D, 0x01, // ’ŭ (U+2019 U+016D)
  0x20, 0x19, 0x01, 0x6F, 0x01, // ’ů (U+2019 U+016F)
  0x20, 0x19, 0x01, 0x71, 0x01, // ’ű (U+2019 U+0171)
  0x20, 0x19, 0x01, 0x73, 0x01, // ’ų (U+2019 U+0173)
  0x20, 0x1A, 0x00, 0x43, 0x01, // ‚C (U+201A U+0043)
  0x20, 0x1A, 0x00, 0x47, 0x01, // ‚G (U+201A U+0047)
  0x20, 0x1A, 0x00, 0x4F, 0x01, // ‚O (U+201A U+004F)
  0x20, 0x1A, 0x00, 0x51, 0x01, // ‚Q (U+201A U+0051)
  0x20, 0x1A, 0x00, 0x54, 0x01, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x56, 0x01, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x01, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x01, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0xC7, 0x01, // ‚Ç (U+201A U+00C7)
  0x20, 0x1A, 0x00, 0xD2, 0x01, // ‚Ò (U+201A U+00D2)
  0x20, 0x1A, 0x00, 0xD3, 0x01, // ‚Ó (U+201A U+00D3)
  0x20, 0x1A, 0x00, 0xD4, 0x01, // ‚Ô (U+201A U+00D4)
  0x20, 0x1A, 0x00, 0xD5, 0x01, // ‚Õ (U+201A U+00D5)
  0x20, 0x1A, 0x00, 0xD6, 0x01, // ‚Ö (U+201A U+00D6)
  0x20, 0x1A, 0x00, 0xD8, 0x01, // ‚Ø (U+201A U+00D8)
  0x20, 0x1A, 0x00, 0xDD, 0x01, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x01, 0x06, 0x01, // ‚Ć (U+201A U+0106)
  0x20, 0x1A, 0x01, 0x08, 0x01, // ‚Ĉ (U+201A U+0108)
  0x20, 0x1A, 0x01, 0x0A, 0x01, // ‚Ċ (U+201A U+010A)
  0x20, 0x1A, 0x01, 0x0C, 0x01, // ‚Č (U+201A U+010C)
  0x20, 0x1A, 0x01, 0x1C, 0x01, // ‚Ĝ (U+201A U+011C)
  0x20, 0x1A, 0x01, 0x1E, 0x01, // ‚Ğ (U+201A U+011E)
  0x20, 0x1A, 0x01, 0x20, 0x01, // ‚Ġ (U+201A U+0120)
  0x20, 0x1A, 0x01, 0x22, 0x01, // ‚Ģ (U+201A U+0122)
  0x20, 0x1A, 0x01, 0x4C, 0x01, // ‚Ō (U+201A U+014C)
  0x20, 0x1A, 0x01, 0x4E, 0x01, // ‚Ŏ (U+201A U+014E)
  0x20, 0x1A, 0x01, 0x50, 0x01, // ‚Ő (U+201A U+0150)
  0x20, 0x1A, 0x01, 0x52, 0x01, // ‚Œ (U+201A U+0152)
  0x20, 0x1A, 0x01, 0x62, 0x01, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x01, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x01, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1A, 0x01, 0x74, 0x01, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x76, 0x01, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x78, 0x01, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x01, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0x61, 0x01, // “a (U+201C U+0061)
  0x20, 0x1C, 0x00, 0x63, 0x01, // “c (U+201C U+0063)
  0x20, 0x1C, 0x00, 0x64, 0x01, // “d (U+201C U+0064)
  0x20, 0x1C, 0x00, 0x65, 0x01, // “e (U+201C U+0065)
  0x20, 0x1C, 0x00, 0x67, 0x01, // “g (U+201C U+0067)
  0x20, 0x1C, 0x00, 0x6D, 0x01, // “m (U+201C U+006D)
  0x20, 0x1C, 0x00, 0x6E, 0x01, // “n (U+201C U+006E)
  0x20, 0x1C, 0x00, 0x6F, 0x01, // “o (U+201C U+006F)
  0x20, 0x1C, 0x00, 0x70, 0x01, // “p (U+201C U+0070)
  0x20, 0x1C, 0x00, 0x71, 0x01, // “q (U+201C U+0071)
  0x20, 0x1C, 0x00, 0x72, 0x01, // “r (U+201C U+0072)
  0x20, 0x1C, 0x00, 0x73, 0x01, // “s (U+201C U+0073)
  0x20, 0x1C, 0x00, 0x75, 0x01, // “u (U+201C U+0075)
  0x20, 0x1C, 0x00, 0xC0, 0x01, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x01, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x01, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x01, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x01, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x01, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xC6, 0x01, // “Æ (U+201C U+00C6)
  0x20, 0x1C, 0x00, 0xE0, 0x01, // “à (U+201C U+00E0)
  0x20, 0x1C, 0x00, 0xE1, 0x01, // “á (U+201C U+00E1)
  0x20, 0x1C, 0x00, 0xE2, 0x01, // “â (U+201C U+00E2)
  0x20, 0x1C, 0x00, 0xE3, 0x01, // “ã (U+201C U+00E3)
  0x20, 0x1C, 0x00, 0xE4, 0x01, // “ä (U+201C U+00E4)
  0x20, 0x1C, 0x00, 0xE5, 0x01, // “å (U+201C U+00E5)
  0x20, 0x1C, 0x00, 0xE6, 0x01, // “æ (U+201C U+00E6)
  0x20, 0x1C, 0x00, 0xE7, 0x01, // “ç (U+201C U+00E7)
  0x20, 0x1C, 0x00, 0xE8, 0x01, // “è (U+201C U+00E8)
  0x20, 0x1C, 0x00, 0xE9, 0x01, // “é (U+201C U+00E9)
  0x20, 0x1C, 0x00, 0xEA, 0x01, // “ê (U+201C U+00EA)
  0x20, 0x1C, 0x00, 0xEB, 0x01, // “ë (U+201C U+00EB)
  0x20, 0x1C, 0x00, 0xF2, 0x01, // “ò (U+201C U+00F2)
  0x20, 0x1C, 0x00, 0xF3, 0x01, // “ó (U+201C U+00F3)
  0x20, 0x1C, 0x00, 0xF4, 0x01, // “ô (U+201C U+00F4)
  0x20, 0x1C, 0x00, 0xF5, 0x01, // “õ (U+201C U+00F5)
  0x20, 0x1C, 0x00, 0xF6, 0x01, // “ö (U+201C U+00F6)
  0x20, 0x1C, 0x00, 0xF8, 0x01, // “ø (U+201C U+00F8)
  0x20, 0x1C, 0x00, 0xF9, 0x01, // “ù (U+201C U+00F9)
  0x20, 0x1C, 0x00, 0xFA, 0x01, // “ú (U+201C U+00FA)
  0x20, 0x1C, 0x00, 0xFB, 0x01, // “û (U+201C U+00FB)
  0x20, 0x1C, 0x00, 0xFC, 0x01, // “ü (U+201C U+00FC)
  0x20, 0x1C, 0x01, 0x00, 0x01, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x01, 0x01, // “ā (U+201C U+0101)
  0x20, 0x1C, 0x01, 0x02, 0x01, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x03, 0x01, // “ă (U+201C U+0103)
  0x20, 0x1C, 0x01, 0x04, 0x01, // “Ą (U+201C U+0104)
  0x20, 0x1C, 0x01, 0x05, 0x01, // “ą (U+201C U+0105)
  0x20, 0x1C, 0x01, 0x07, 0x01, // “ć (U+201C U+0107)
  0x20, 0x1C, 0x01, 0x09, 0x01, // “ĉ (U+201C U+0109)
  0x20, 0x1C, 0x01, 0x0B, 0x01, // “ċ (U+201C U+010B)
  0x20, 0x1C, 0x01, 0x0D, 0x01, // “č (U+201C U+010D)
  0x20, 0x1C, 0x01, 0x0F, 0x01, // “ď (U+201C U+010F)
  0x20, 0x1C, 0x01, 0x11, 0x01, // “đ (U+201C U+0111)
  0x20, 0x1C, 0x01, 0x13, 0x01, // “ē (U+201C U+0113)
  0x20, 0x1C, 0x01, 0x15, 0x01, // “ĕ (U+201C U+0115)
  0x20, 0x1C, 0x01, 0x17, 0x01, // “ė (U+201C U+0117)
  0x20, 0x1C, 0x01, 0x19, 0x01, // “ę (U+201C U+0119)
  0x20, 0x1C, 0x01, 0x1B, 0x01, // “ě (U+201C U+011B)
  0x20, 0x1C, 0x01, 0x1D, 0x01, // “ĝ (U+201C U+011D)
  0x20, 0x1C, 0x01, 0x1F, 0x01, // “ğ (U+201C U+011F)
  0x20, 0x1C, 0x01, 0x21, 0x01, // “ġ (U+201C U+0121)
  0x20, 0x1C, 0x01, 0x23, 0x01, // “ģ (U+201C U+0123)
  0x20, 0x1C, 0x01, 0x38, 0x01, // “ĸ (U+201C U+0138)
  0x20, 0x1C, 0x01, 0x44, 0x01, // “ń (U+201C U+0144)
  0x20, 0x1C, 0x01, 0x46, 0x01, // “ņ (U+201C U+0146)
  0x20, 0x1C, 0x01, 0x4B, 0x01, // “ŋ (U+201C U+014B)
  0x20, 0x1C, 0x01, 0x4D, 0x01, // “ō (U+201C U+014D)
  0x20, 0x1C, 0x01, 0x4F, 0x01, // “ŏ (U+201C U+014F)
  0x20, 0x1C, 0x01, 0x51, 0x01, // “ő (U+201C U+0151)
  0x20, 0x1C, 0x01, 0x53, 0x01, // “œ (U+201C U+0153)
  0x20, 0x1C, 0x01, 0x55, 0x01, // “ŕ (U+201C U+0155)
  0x20, 0x1C, 0x01, 0x57, 0x01, // “ŗ (U+201C U+0157)
  0x20, 0x1C, 0x01, 0x5B, 0x01, // “ś (U+201C U+015B)
  0x20, 0x1C, 0x01, 0x5F, 0x01, // “ş (U+201C U+015F)
  0x20, 0x1C, 0x01, 0x69, 0x01, // “ũ (U+201C U+0169)
  0x20, 0x1C, 0x01, 0x6B, 0x01, // “ū (U+201C U+016B)
  0x20, 0x1C, 0x01, 0x6D, 0x01, // “ŭ (U+201C U+016D)
  0x20, 0x1C, 0x01, 0x6F, 0x01, // “ů (U+201C U+016F)
  0x20, 0x1C, 0x01, 0x71, 0x01, // “ű (U+201C U+0171)
  0x20, 0x1C, 0x01, 0x73, 0x01, // “ų (U+201C U+0173)
  0x20, 0x1D, 0x00, 0x41, 0x01, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0x61, 0x01, // ”a (U+201D U+0061)
  0x20, 0x1D, 0x00, 0x63, 0x01, // ”c (U+201D U+0063)
  0x20, 0x1D, 0x00, 0x64, 0x01, // ”d (U+201D U+0064)
  0x20, 0x1D, 0x00, 0x65, 0x01, // ”e (U+201D U+0065)
  0x20, 0x1D, 0x00, 0x67, 0x01, // ”g (U+201D U+0067)
  0x20, 0x1D, 0x00, 0x6D, 0x01, // ”m (U+201D U+006D)
  0x20, 0x1D, 0x00, 0x6E, 0x01, // ”n (U+201D U+006E)
  0x20, 0x1D, 0x00, 0x6F, 0x01, // ”o (U+201D U+006F)
  0x20, 0x1D, 0x00, 0x70, 0x01, // ”p (U+201D U+0070)
  0x20, 0x1D, 0x00, 0x71, 0x01, // ”q (U+201D U+0071)
  0x20, 0x1D, 0x00, 0x72, 0x01, // ”r (U+201D U+0072)
  0x20, 0x1D, 0x00, 0x73, 0x01, // ”s (U+201D U+0073)
  0x20, 0x1D, 0x00, 0x75, 0x01, // ”u (U+201D U+0075)
  0x20, 0x1D, 0x00, 0xC0, 0x01, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x01, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x01, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x01, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x01, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x01, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xC6, 0x01, // ”Æ (U+201D U+00C6)
  0x20, 0x1D, 0x00, 0xE0, 0x01, // ”à (U+201D U+00E0)
  0x20, 0x1D, 0x00, 0xE1, 0x01, // ”á (U+201D U+00E1)
  0x20, 0x1D, 0x00, 0xE2, 0x01, // ”â (U+201D U+00E2)
  0x20, 0x1D, 0x00, 0xE3, 0x01, // ”ã (U+201D U+00E3)
  0x20, 0x1D, 0x00, 0xE4, 0x01, // ”ä (U+201D U+00E4)
  0x20, 0x1D, 0x00, 0xE5, 0x01, // ”å (U+201D U+00E5)
  0x20, 0x1D, 0x00, 0xE6, 0x01, // ”æ (U+201D U+00E6)
  0x20, 0x1D, 0x00, 0xE7, 0x01, // ”ç (U+201D U+00E7)
  0x20, 0x1D, 0x00, 0xE8, 0x01, // ”è (U+201D U+00E8)
  0x20, 0x1D, 0x00, 0xE9, 0x01, // ”é (U+201D U+00E9)
  0x20, 0x1D, 0x00, 0xEA, 0x01, // ”ê (U+201D U+00EA)
  0x20, 0x1D, 0x00, 0xEB, 0x01, // ”ë (U+201D U+00EB)
  0x20, 0x1D, 0x00, 0xF2, 0x01, // ”ò (U+201D U+00F2)
  0x20, 0x1D, 0x00, 0xF3, 0x01, // ”ó (U+201D U+00F3)
  0x20, 0x1D, 0x00, 0xF4, 0x01, // ”ô (U+201D U+00F4)
  0x20, 0x1D, 0x00, 0xF5, 0x01, // ”õ (U+201D U+00F5)
  0x20, 0x1D, 0x00, 0xF6, 0x01, // ”ö (U+201D U+00F6)
  0x20, 0x1D, 0x00, 0xF8, 0x01, // ”ø (U+201D U+00F8)
  0x20, 0x1D, 0x00, 0xF9, 0x01, // ”ù (U+201D U+00F9)
  0x20, 0x1D, 0x00, 0xFA, 0x01, // ”ú (U+201D U+00FA)
  0x20, 0x1D, 0x00, 0xFB, 0x01, // ”û (U+201D U+00FB)
  0x20, 0x1D, 0x00, 0xFC, 0x01, // ”ü (U+201D U+00FC)
  0x20, 0x1D, 0x01, 0x00, 0x01, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x01, 0x01, // ”ā (U+201D U+0101)
  0x20, 0x1D, 0x01, 0x02, 0x01, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x03, 0x01, // ”ă (U+201D U+0103)
  0x20, 0x1D, 0x01, 0x04, 0x01, // ”Ą (U+201D U+0104)
  0x20, 0x1D, 0x01, 0x05, 0x01, // ”ą (U+201D U+0105)
  0x20, 0x1D, 0x01, 0x07, 0x01, // ”ć (U+201D U+0107)
  0x20, 0x1D, 0x01, 0x09, 0x01, // ”ĉ (U+201D U+0109)
  0x20, 0x1D, 0x01, 0x0B, 0x01, // ”ċ (U+201D U+010B)
  0x20, 0x1D, 0x01, 0x0D, 0x01, // ”č (U+201D U+010D)
  0x20, 0x1D, 0x01, 0x0F, 0x01, // ”ď (U+201D U+010F)
  0x20, 0x1D, 0x01, 0x11, 0x01, // ”đ (U+201D U+0111)
  0x20, 0x1D, 0x01, 0x13, 0x01, // ”ē (U+201D U+0113)
  0x20, 0x1D, 0x01, 0x15, 0x01, // ”ĕ (U+201D U+0115)
  0x20, 0x1D, 0x01, 0x17, 0x01, // ”ė (U+201D U+0117)
  0x20, 0x1D, 0x01, 0x19, 0x01, // ”ę (U+201D U+0119)
  0x20, 0x1D, 0x01, 0x1B, 0x01, // ”ě (U+201D U+011B)
  0x20, 0x1D, 0x01, 0x1D, 0x01, // ”ĝ (U+201D U+011D)
  0x20, 0x1D, 0x01, 0x1F, 0x01, // ”ğ (U+201D U+011F)
  0x20, 0x1D, 0x01, 0x21, 0x01, // ”ġ (U+201D U+0121)
  0x20, 0x1D, 0x01, 0x23, 0x01, // ”ģ (U+201D U+0123)
  0x20, 0x1D, 0x01, 0x38, 0x01, // ”ĸ (U+201D U+0138)
  0x20, 0x1D, 0x01, 0x44, 0x01, // ”ń (U+201D U+0144)
  0x20, 0x1D, 0x01, 0x46, 0x01, // ”ņ (U+201D U+0146)
  0x20, 0x1D, 0x01, 0x4B, 0x01, // ”ŋ (U+201D U+014B)
  0x20, 0x1D, 0x01, 0x4D, 0x01, // ”ō (U+201D U+014D)
  0x20, 0x1D, 0x01, 0x4F, 0x01, // ”ŏ (U+201D U+014F)
  0x20, 0x1D, 0x01, 0x51, 0x01, // ”ő (U+201D U+0151)
  0x20, 0x1D, 0x01, 0x53, 0x01, // ”œ (U+201D U+0153)
  0x20, 0x1D, 0x01, 0x55, 0x01, // ”ŕ (U+201D U+0155)
  0x20, 0x1D, 0x01, 0x57, 0x01, // ”ŗ (U+201D U+0157)
  0x20, 0x1D, 0x01, 0x5B, 0x01, // ”ś (U+201D U+015B)
  0x20, 0x1D, 0x01, 0x5F, 0x01, // ”ş (U+201D U+015F)
  0x20, 0x1D, 0x01, 0x69, 0x01, // ”ũ (U+201D U+0169)
  0x20, 0x1D, 0x01, 0x6B, 0x01, // ”ū (U+201D U+016B)
  0x20, 0x1D, 0x01, 0x6D, 0x01, // ”ŭ (U+201D U+016D)
  0x20, 0x1D, 0x01, 0x6F, 0x01, // ”ů (U+201D U+016F)
  0x20, 0x1D, 0x01, 0x71, 0x01, // ”ű (U+201D U+0171)
  0x20, 0x1D, 0x01, 0x73, 0x01, // ”ų (U+201D U+0173)
  0x20, 0x1E, 0x00, 0x43, 0x01, // „C (U+201E U+0043)
  0x20, 0x1E, 0x00, 0x47, 0x01, // „G (U+201E U+0047)
  0x20, 0x1E, 0x00, 0x4F, 0x01, // „O (U+201E U+004F)
  0x20, 0x1E, 0x00, 0x51, 0x01, // „Q (U+201E U+0051)
  0x20, 0x1E, 0x00, 0x54, 0x01, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x56, 0x01, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x01, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x01, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0xC7, 0x01, // „Ç (U+201E U+00C7)
  0x20, 0x1E, 0x00, 0xD2, 0x01, // „Ò (U+201E U+00D2)
  0x20, 0x1E, 0x00, 0xD3, 0x01, // „Ó (U+201E U+00D3)
  0x20, 0x1E, 0x00, 0xD4, 0x01, // „Ô (U+201E U+00D4)
  0x20, 0x1E, 0x00, 0xD5, 0x01, // „Õ (U+201E U+00D5)
  0x20, 0x1E, 0x00, 0xD6, 0x01, // „Ö (U+201E U+00D6)
  0x20, 0x1E, 0x00, 0xD8, 0x01, // „Ø (U+201E U+00D8)
  0x20, 0x1E, 0x00, 0xDD, 0x01, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x01, 0x06, 0x01, // „Ć (U+201E U+0106)
  0x20, 0x1E, 0x01, 0x08, 0x01, // „Ĉ (U+201E U+0108)
  0x20, 0x1E, 0x01, 0x0A, 0x01, // „Ċ (U+201E U+010A)
  0x20, 0x1E, 0x01, 0x0C, 0x01, // „Č (U+201E U+010C)
  0x20, 0x1E, 0x01, 0x1C, 0x01, // „Ĝ (U+201E U+011C)
  0x20, 0x1E, 0x01, 0x1E, 0x01, // „Ğ (U+201E U+011E)
  0x20, 0x1E, 0x01, 0x20, 0x01, // „Ġ (U+201E U+0120)
  0x20, 0x1E, 0x01, 0x22, 0x01, // „Ģ (U+201E U+0122)
  0x20, 0x1E, 0x01, 0x4C, 0x01, // „Ō (U+201E U+014C)
  0x20, 0x1E, 0x01, 0x4E, 0x01, // „Ŏ (U+201E U+014E)
  0x20, 0x1E, 0x01, 0x50, 0x01, // „Ő (U+201E U+0150)
  0x20, 0x1E, 0x01, 0x52, 0x01, // „Œ (U+201E U+0152)
  0x20, 0x1E, 0x01, 0x62, 0x01, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x01, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x01, // „Ŧ (U+201E U+0166)
  0x20, 0x1E, 0x01, 0x74, 0x01, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x76, 0x01, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x78, 0x01, // „Ÿ (U+201E U+0178)
  0x20, 0x39, 0x00, 0x54, 0x01, // ‹T (U+2039 U+0054)
  0x20, 0x39, 0x00, 0x59, 0x01, // ‹Y (U+2039 U+0059)
  0x20, 0x39, 0x00, 0xDD, 0x01, // ‹Ý (U+2039 U+00DD)
  0x20, 0x39, 0x01, 0x62, 0x01, // ‹Ţ (U+2039 U+0162)
  0x20, 0x39, 0x01, 0x64, 0x01, // ‹Ť (U+2039 U+0164)
  0x20, 0x39, 0x01, 0x66, 0x01, // ‹Ŧ (U+2039 U+0166)
  0x20, 0x39, 0x01, 0x76, 0x01, // ‹Ŷ (U+2039 U+0176)
  0x20, 0x39, 0x01, 0x78, 0x01, // ‹Ÿ (U+2039 U+0178)
  0x20, 0x3A, 0x00, 0x54, 0x01, // ›T (U+203A U+0054)
  0x20, 0x3A, 0x00, 0x56, 0x01, // ›V (U+203A U+0056)
  0x20, 0x3A, 0x00, 0x57, 0x01, // ›W (U+203A U+0057)
  0x20, 0x3A, 0x00, 0x59, 0x01, // ›Y (U+203A U+0059)
  0x20, 0x3A, 0x00, 0xDD, 0x01, // ›Ý (U+203A U+00DD)
  0x20, 0x3A, 0x01, 0x62, 0x01, // ›Ţ (U+203A U+0162)
  0x20, 0x3A, 0x01, 0x64, 0x01, // ›Ť (U+203A U+0164)
  0x20, 0x3A, 0x01, 0x66, 0x01, // ›Ŧ (U+203A U+0166)
  0x20, 0x3A, 0x01, 0x74, 0x01, // ›Ŵ (U+203A U+0174)
  0x20, 0x3A, 0x01, 0x76, 0x01, // ›Ŷ (U+203A U+0176)
  0x20, 0x3A, 0x01, 0x78, 0x01, // ›Ÿ (U+203A U+0178)
  0x20, 0x44, 0x00, 0x30, 0x03, // ⁄0 (U+2044 U+0030)
  0x20, 0x44, 0x00, 0x31, 0x03, // ⁄1 (U+2044 U+0031)
  0x20, 0x44, 0x00, 0x32, 0x03, // ⁄2 (U+2044 U+0032)
  0x20, 0x44, 0x00, 0x33, 0x03, // ⁄3 (U+2044 U+0033)
  0x20, 0x44, 0x00, 0x34, 0x03, // ⁄4 (U+2044 U+0034)
  0x20, 0x44, 0x00, 0x35, 0x03, // ⁄5 (U+2044 U+0035)
  0x20, 0x44, 0x00, 0x36, 0x03, // ⁄6 (U+2044 U+0036)
  0x20, 0x44, 0x00, 0x37, 0x03, // ⁄7 (U+2044 U+0037)
  0x20, 0x44, 0x00, 0x38, 0x03, // ⁄8 (U+2044 U+0038)
  0x20, 0x44, 0x00, 0x39, 0x03, // ⁄9 (U+2044 U+0039)
  
  // Glyph data
  // "!" (U+0021)
  0x0E, 0xA0, 0x10, 0xDA, 0x10, 0xCA, 0x18, 0xA5, 0xBF, 0xE0, 0xBF, 0xD0, 0xAF, 0xC0, 0x9F, 0xC0,
  0x8F, 0xB0, 0x7F, 0xA5, 0x83, 0x8E, 0xA0, 0xEA, 0x82, 0x18, 0xEA, 0x10,
  // """ (U+0022)
  0x82, 0xCF, 0x91, 0xA8, 0x24, 0xBF, 0x81, 0xA8, 0xA2, 0x3A, 0xF6, 0x0E, 0xF2, 0x9F, 0x50, 0xDF,
  0x17, 0xF4, 0x0C, 0x91,
  // "#" (U+0023)
  0x48, 0x4D, 0xF1, 0x2F, 0xB6, 0x98, 0x3E, 0x05, 0xF8, 0x58, 0x53, 0xFB, 0x08, 0xF5, 0x38, 0x90,
  0x22, 0x7F, 0x92, 0xBF, 0x52, 0x2F, 0xB0, 0x31, 0xFB, 0x03, 0x38, 0x4D, 0xF0, 0x3F, 0xA5, 0x85,
  0x1F, 0xC0, 0x6F, 0x73, 0x09, 0xFA, 0x81, 0x90, 0x9F, 0xA8, 0x93, 0x90, 0x12, 0xAF, 0x62, 0xFE,
  0x22, 0x13, 0x84, 0xCF, 0x13, 0xFA, 0x69, 0x83, 0xD0, 0x7F, 0x74,
  // "$" (U+0024)
  0x40, 0x70, 0xB6, 0x85, 0x16, 0xBE, 0x86, 0x12, 0x05, 0x0E, 0xE8, 0x13, 0x0E, 0xA8, 0x5D, 0xEB,
  0xED, 0x03, 0xA8, 0x17, 0x7B, 0x28, 0x12, 0x01, 0xA8, 0x1D, 0xAB, 0x50, 0x7B, 0x0E, 0x06, 0x50,
  0x40, 0xCB, 0x0E, 0x05, 0x50, 0x80, 0xEB, 0x03, 0x48, 0x17, 0xB4, 0xA8, 0x68, 0x2A, 0x51, 0x7C,
  0x5A, 0x07, 0x03, 0xF8, 0x3E, 0x11, 0xAE, 0xB8, 0x1E, 0xB2, 0x48, 0x11, 0x8C, 0x71, 0x07, 0x0B,
  0x40,
  // "%" (U+0025)
  0x18, 0x33, 0xCF, 0xD4, 0x48, 0x1A, 0xF6, 0x40, 0xDC, 0x01, 0x28, 0x13, 0xFD, 0x40, 0x3A, 0x82,
  0x4D, 0xF7, 0x28, 0x1B, 0xF5, 0x48, 0x91, 0x5F, 0xC0, 0x9F, 0x90, 0x4F, 0xC5, 0x89, 0x16, 0xFC,
  0x08, 0xF9, 0x0D, 0xF3, 0x58, 0x95, 0x4F, 0xE1, 0xCF, 0x76, 0xFA, 0x3C, 0xFD, 0x42, 0x0E, 0xC8,
  0x33, 0xEF, 0x2D, 0xC8, 0x21, 0x04, 0xEA, 0x83, 0x77, 0xF9, 0x4A, 0x82, 0x4D, 0xF7, 0x38, 0x93,
  0x20, 0x1E, 0xE1, 0x6F, 0xC0, 0x9F, 0x95, 0x89, 0x19, 0xF7, 0x05, 0xFC, 0x09, 0xF9, 0x48, 0x12,
  0xFE, 0x20, 0x3A, 0x82, 0x4D, 0xF7, 0x48, 0x1B, 0xF6, 0x30, 0xDC, 0x01, 0x38, 0x13, 0xFD, 0x48,
  0x32, 0xCF, 0xD5, 0x10,
  // "&" (U+0026)
  0x38, 0x48, 0xDF, 0xE9, 0x17, 0x0B, 0xD0, 0xC6, 0x01, 0xA8, 0x1A, 0x39, 0xA0, 0x25, 0x01, 0xA8,
  0x16, 0x06, 0xA7, 0x85, 0xCF, 0xD6, 0xEF, 0x97, 0x03, 0xC0, 0x97, 0x01, 0x0C, 0xB0, 0xD0, 0x12,
  0x81, 0xEF, 0xC2, 0x0C, 0xA0, 0xAA, 0x81, 0xC1, 0x5A, 0x81, 0x60, 0x2A, 0x81, 0xB0, 0x4A, 0x85,
  0xDC, 0xFE, 0x10, 0x3A, 0x09, 0x20, 0x4C, 0x06, 0x20, 0x1B, 0x82, 0x62, 0x4C, 0xB0, 0x23, 0x08,
  0xFA, 0x0D, 0x02, 0x38, 0x64, 0xBD, 0xFE, 0xA4, 0x5A, 0x0D, 0x01,
  // "'" (U+0027)
  0x89, 0x5C, 0xF9, 0xBF, 0x8A, 0xF6, 0x9F, 0x57, 0xF4,
  // "(" (U+0028)
  0x28, 0x21, 0xEF, 0x42, 0x81, 0x9F, 0xA2, 0x02, 0xA0, 0x32, 0x81, 0x8F, 0xC3, 0x81, 0xCF, 0x83,
  0xA0, 0x42, 0x02, 0xA0, 0x22, 0x03, 0xA0, 0x12, 0x03, 0xA0, 0x12, 0x02, 0xA0, 0x22, 0x01, 0xA0,
  0x43, 0x81, 0xDF, 0x83, 0x81, 0x8F, 0xC3, 0x02, 0xA0, 0x33, 0x81, 0xAF, 0xA3, 0x82, 0x1E, 0xF3,
  // ")" (U+0029)
  0x82, 0x2F, 0xE1, 0x38, 0x18, 0xFB, 0x30, 0x1A, 0x03, 0x38, 0x1B, 0xF9, 0x38, 0x16, 0xFE, 0x30,
  0x3A, 0x01, 0x20, 0x1A, 0x04, 0x3A, 0x05, 0x3A, 0x05, 0x20, 0x1A, 0x04, 0x20, 0x3A, 0x02, 0x28,
  0x16, 0xFE, 0x38, 0x1A, 0xFA, 0x20, 0x1A, 0x03, 0x28, 0x18, 0xFB, 0x28, 0x22, 0xFE, 0x22,
  // "*" (U+002A)
  0x30, 0x3A, 0x78, 0x11, 0xFD, 0x48, 0x91, 0x17, 0x30, 0xFB, 0x04, 0x80, 0x4A, 0x82, 0xEF, 0xEE,
  0xA8, 0x31, 0x39, 0xAD, 0xA8, 0x2C, 0xA9, 0x12, 0x83, 0x1E, 0xEF, 0xC5, 0x84, 0xBF, 0x7B, 0xF8,
  0x38, 0x52, 0xCF, 0x13, 0xFB, 0x50, 0x32, 0x03, 0x30,
  // "+" (U+002B)
  0x48, 0x1C, 0xF1, 0x78, 0x1C, 0xF1, 0x78, 0x1C, 0xF1, 0x40, 0xF2, 0x85, 0xDF, 0x32, 0x21, 0x3F,
  0x90, 0x70, 0x3F, 0x90, 0x74, 0x81, 0xCF, 0x17, 0x81, 0xCF, 0x17, 0x81, 0xCF, 0x13,
  // "," (U+002C)
  0x18, 0x6A, 0xFD, 0x0D, 0xF8, 0x1A, 0x82, 0x24, 0xFB, 0x10,
  // "-" (U+002D)
  0x85, 0x12, 0x22, 0x20, 0x7C, 0x03, 0x07, 0xC0, 0x30,
  // "." (U+002E)
  0x83, 0x8E, 0xA0, 0xEA, 0x82, 0x18, 0xEA, 0x10,
  // "/" (U+002F)
  0x40, 0x4A, 0x02, 0x48, 0x1A, 0xFC, 0x58, 0x1E, 0xF6, 0x40, 0x5A, 0x01, 0x48, 0x1B, 0xFA, 0x40,
  0x1A, 0x05, 0x48, 0x17, 0xFE, 0x58, 0x1D, 0xF9, 0x40, 0x3A, 0x03, 0x48, 0x19, 0xFD, 0x58, 0x1E,
  0xF7, 0x40, 0x5A, 0x01, 0x48, 0x1A, 0xFB, 0x50,
  // "0" (U+0030)
  0x28, 0x43, 0xAE, 0xEC, 0x43, 0x02, 0x0E, 0xD0, 0x52, 0x0A, 0xA8, 0x35, 0x3D, 0xFD, 0x2A, 0x0A,
  0x20, 0x6A, 0x04, 0x03, 0xA0, 0x72, 0x03, 0xA0, 0x70, 0x4A, 0x05, 0x20, 0x1A, 0x08, 0x05, 0xA0,
  0x52, 0x01, 0xA0, 0x90, 0x4A, 0x05, 0x20, 0x1A, 0x08, 0x03, 0xA0, 0x72, 0x02, 0xA0, 0x71, 0xA0,
  0xA2, 0x06, 0xA8, 0x14, 0x0A, 0xA8, 0x35, 0x3D, 0xFE, 0x20, 0x20, 0xED, 0x06, 0x38, 0x42, 0xAE,
  0xEC, 0x52,
  // "1" (U+0031)
  0x30, 0x6A, 0x06, 0x20, 0x9B, 0x81, 0x61, 0xBC, 0x06, 0x0A, 0xA0, 0x8A, 0x83, 0x62, 0xC3, 0x4A,
  0x06, 0x30, 0x4A, 0x06, 0x30, 0x4A, 0x06, 0x30, 0x4A, 0x06, 0x30, 0x4A, 0x06, 0x30, 0x4A, 0x06,
  0x30, 0x4A, 0x06, 0x30, 0x4A, 0x06, 0x30, 0x4A, 0x06,
  // "2" (U+0032)
  0x28, 0x46, 0xCE, 0xFD, 0x72, 0x01, 0x0C, 0xE0, 0x92, 0x84, 0xAF, 0x93, 0x3C, 0xA0, 0x22, 0x03,
  0x30, 0x6A, 0x04, 0x60, 0x7A, 0x03, 0x58, 0x21, 0xEF, 0xD6, 0x0B, 0xA0, 0x55, 0x0A, 0xA0, 0x75,
  0x09, 0xA0, 0x85, 0x08, 0xA0, 0x85, 0x08, 0xA8, 0x59, 0x22, 0x22, 0x13, 0xF9, 0x0A, 0x04, 0xF9,
  0x0A,
  // "3" (U+0033)
  0x18, 0x53, 0x9D, 0xFE, 0xC7, 0x20, 0x10, 0xEE, 0x0B, 0x28, 0x46, 0xB5, 0x24, 0xDA, 0x02, 0x60,
  0x8A, 0x01, 0x58, 0x23, 0xDF, 0xA3, 0x05, 0xB0, 0xE0, 0x74, 0x05, 0xB8, 0x1E, 0xB3, 0x48, 0x22,
  0x35, 0xDA, 0x02, 0x60, 0x5A, 0x07, 0x60, 0x6A, 0x86, 0x74, 0xB5, 0x33, 0x5E, 0xA0, 0x04, 0xF8,
  0x90, 0x90, 0x18, 0xCE, 0xFE, 0xB5, 0x20,
  // "4" (U+0034)
  0x50, 0x6A, 0x06, 0x50, 0x20, 0xEA, 0x06, 0x50, 0xBB, 0x06, 0x48, 0x17, 0xFB, 0xA0, 0x63, 0x82,
  0x2F, 0xE4, 0xA0, 0x63, 0x82, 0xCF, 0x53, 0xA0, 0x62, 0x83, 0x7F, 0xA0, 0x3A, 0x86, 0x60, 0x3F,
  0xE1, 0x03, 0xA8, 0x16, 0x0A, 0xFA, 0x0A, 0xFA, 0x84, 0x12, 0x22, 0x25, 0xA0, 0x80, 0x25, 0x03,
  0xA0, 0x66, 0x03, 0xA0, 0x61,
  // "5" (U+0035)
  0x10, 0x6E, 0x09, 0x20, 0x7E, 0x09, 0x20, 0x8A, 0x80, 0x02, 0x01, 0x28, 0x19, 0xFD, 0x78, 0x3A,
  0xFC, 0x12, 0x50, 0xCD, 0x0A, 0x01, 0x20, 0xBE, 0x0C, 0x38, 0x33, 0x10, 0x3C, 0xA0, 0x46, 0x05,
  0xA0, 0x66, 0x06, 0xA8, 0x65, 0x1A, 0x63, 0x25, 0xEA, 0x00, 0x1F, 0x07, 0x28, 0x58, 0xCE, 0xFE,
  0xB4, 0x20,
  // "6" (U+0036)
  0x38, 0x42, 0x9D, 0xEF, 0xB3, 0x06, 0xD0, 0xC2, 0x03, 0xA8, 0x3D, 0x63, 0x23, 0x28, 0x2A, 0xFD,
  0x16, 0x84, 0xEF, 0x70, 0x11, 0x30, 0x3A, 0x05, 0x0C, 0xA8, 0x2D, 0x40, 0x4A, 0x0E, 0xC8, 0x1E,
  0x25, 0xA8, 0x2D, 0x30, 0x7A, 0x07, 0x04, 0xA0, 0x63, 0xA0, 0xA0, 0x1A, 0x08, 0x3A, 0x81, 0x90,
  0xBA, 0x81, 0x53, 0xAA, 0x82, 0x50, 0x2E, 0xD0, 0xC3, 0x84, 0x19, 0xEF, 0xD8, 0x20,
  // "7" (U+0037)
  0x08, 0xF9, 0x0A, 0x08, 0xF9, 0x0A, 0x01, 0x80, 0x12, 0x07, 0xA0, 0x56, 0x81, 0xCF, 0xD6, 0x03,
  0xA0, 0x76, 0x0A, 0xA0, 0x15, 0x01, 0xA0, 0x96, 0x08, 0xA0, 0x26, 0x81, 0xEF, 0xB6, 0x06, 0xA0,
  0x56, 0x81, 0xDF, 0xD6, 0x05, 0xA0, 0x76, 0x0C, 0xA0, 0x14,
  // "8" (U+0038)
  0x28, 0x45, 0xBE, 0xFC, 0x73, 0x07, 0xE0, 0xB2, 0x84, 0xDF, 0xD4, 0x3B, 0xA8, 0x32, 0x0E, 0xF9,
  0x20, 0x5A, 0x89, 0x02, 0x09, 0xFE, 0x42, 0xCF, 0xD3, 0x0B, 0xC0, 0xC0, 0x23, 0x06, 0xC0, 0x73,
  0x08, 0xA0, 0x90, 0x8A, 0x81, 0xA0, 0x2A, 0x07, 0x20, 0x4A, 0x06, 0x05, 0xA0, 0x33, 0x82, 0xEF,
  0x93, 0xA8, 0x2B, 0x33, 0x8A, 0x81, 0x70, 0xBE, 0x0D, 0x01, 0x28, 0x56, 0xCE, 0xFD, 0x81, 0x10,
  // "9" (U+0039)
  0x28, 0x45, 0xCE, 0xEB, 0x43, 0x08, 0xE8, 0x15, 0x01, 0xA8, 0x6C, 0x44, 0xDF, 0xE1, 0x5A, 0x04,
  0x20, 0x4A, 0x00, 0x5A, 0x03, 0x20, 0x1A, 0x08, 0x03, 0xA8, 0x2A, 0x11, 0xAA, 0x81, 0x90, 0xCC,
  0x85, 0xEE, 0xF8, 0x02, 0xCA, 0x83, 0xE4, 0xEF, 0x73, 0x82, 0x11, 0x02, 0xA0, 0x46, 0x81, 0xAF,
  0xE2, 0x83, 0x23, 0x35, 0xBA, 0x07, 0x20, 0x8D, 0x0A, 0x30, 0x7A, 0x81, 0xEA, 0x53,
  // ":" (U+003A)
  0x83, 0x8E, 0xA0, 0xEA, 0x82, 0x18, 0xEA, 0x77, 0x38, 0x38, 0xEA, 0x0E, 0xA8, 0x21, 0x8E, 0xA1,
  // ";" (U+003B)
  0x18, 0x18, 0xEA, 0x20, 0xEA, 0x83, 0x10, 0x8E, 0xA7, 0x77, 0x68, 0x1A, 0xFD, 0x28, 0x3D, 0xF8,
  0x01, 0xA8, 0x32, 0x04, 0xFB, 0x20,
  // "<" (U+003C)
  0x72, 0x01, 0x78, 0x13, 0xB7, 0x50, 0x30, 0xBA, 0x07, 0x30, 0x30, 0xBA, 0x0C, 0x05, 0x20, 0x30,
  0xBA, 0x0B, 0x03, 0x30, 0x3A, 0x0D, 0x03, 0x50, 0x10, 0xAA, 0x81, 0xE8, 0x15, 0x81, 0x28, 0xEA,
  0x0B, 0x04, 0x60, 0x70, 0xDA, 0x07, 0x78, 0x15, 0xC7,
  // "=" (U+003D)
  0x18, 0x04, 0x20, 0x10, 0x3F, 0x90, 0x70, 0x3F, 0x90, 0x71, 0x80, 0x42, 0x01, 0x03, 0xF9, 0x07,
  0x03, 0xF9, 0x07,
  // ">" (U+003E)
  0x81, 0x3D, 0x67, 0x03, 0xA0, 0xD0, 0x66, 0x03, 0x0A, 0xA0, 0xD0, 0x66, 0x84, 0x29, 0xEF, 0xD6,
  0x60, 0x10, 0xBA, 0x07, 0x40, 0x60, 0xCA, 0x84, 0xC3, 0x02, 0x9E, 0xA0, 0xA0, 0x32, 0x03, 0xA8,
  0x1E, 0x82, 0x48, 0x23, 0xD7, 0x16,
  // "?" (U+003F)
  0x85, 0x17, 0xCE, 0xEC, 0x62, 0x0B, 0xE8, 0x69, 0x04, 0xD6, 0x33, 0xBA, 0x01, 0x50, 0x7A, 0x01,
  0x48, 0x22, 0xDF, 0xC4, 0x83, 0x4E, 0xFD, 0x23, 0x02, 0xA0, 0xB5, 0x81, 0x7F, 0xD6, 0x81, 0x48,
  0x67, 0x71, 0x81, 0x6E, 0xB6, 0x0C, 0xA0, 0x25, 0x81, 0x7E, 0xB4,
  // "@" (U+0040)
  0x48, 0x55, 0xBD, 0xFE, 0xB6, 0x60, 0x20, 0xDF, 0x0D, 0x02, 0x38, 0x93, 0x2E, 0xFD, 0x74, 0x23,
  0x7D, 0xFD, 0x12, 0x8A, 0x1D, 0xFA, 0x18, 0xDF, 0xDA, 0x5B, 0xF9, 0x05, 0xFC, 0x0C, 0xD8, 0xB0,
  0x91, 0xFE, 0x0B, 0xF4, 0x6F, 0xE5, 0x28, 0xF8, 0x0C, 0xF2, 0xEF, 0x0A, 0xF6, 0x28, 0x93, 0x7F,
  0x70, 0xBF, 0x3F, 0xD0, 0xBF, 0x42, 0x89, 0x5A, 0xF6, 0x0D, 0xF1, 0xFD, 0x09, 0xFB, 0x35, 0xA8,
  0x7A, 0x5F, 0xD0, 0xEF, 0x03, 0xC0, 0x0D, 0xB8, 0x95, 0x60, 0xBF, 0x50, 0x5D, 0xFC, 0x24, 0xDE,
  0x72, 0x82, 0x5F, 0xE2, 0x75, 0x89, 0x1B, 0xFE, 0x94, 0x23, 0x58, 0xC2, 0x40, 0x10, 0xAF, 0x90,
  0x26, 0x86, 0x4A, 0xDE, 0xFD, 0x93, 0x40,
  // "A" (U+0041)
  0x40, 0xAB, 0x72, 0x0E, 0xB0, 0x57, 0x05, 0xA8, 0x1B, 0xFB, 0x78, 0x2A, 0xFC, 0x6A, 0x01, 0x50,
  0x1A, 0x08, 0x01, 0xA0, 0x65, 0x06, 0xA8, 0x33, 0x0C, 0xFC, 0x58, 0x1B, 0xFE, 0x20, 0x7A, 0x02,
  0x30, 0x1A, 0x82, 0xB4, 0x46, 0xA0, 0x73, 0x06, 0xF9, 0x0D, 0x30, 0xCF, 0xA8, 0x13, 0x02, 0xA0,
  0xB4, 0x04, 0xA8, 0x18, 0x07, 0xA0, 0x65, 0x83, 0xEF, 0xD0, 0xCA, 0x01, 0x50, 0xAA, 0x03,
  // "B" (U+0042)
  0x05, 0xC8, 0x2E, 0xDA, 0x32, 0x05, 0xF9, 0x81, 0x50, 0x5A, 0x82, 0x62, 0x39, 0xA8, 0x1B, 0x05,
  0xA0, 0x53, 0xA8, 0x1B, 0x05, 0xA0, 0x52, 0x06, 0xA8, 0x18, 0x05, 0xF0, 0xA2, 0x05, 0xF8, 0x2A,
  0x20, 0x5A, 0x82, 0x62, 0x37, 0xA8, 0x1C, 0x05, 0xA0, 0x53, 0x0B, 0xA0, 0x10, 0x5A, 0x05, 0x30,
  0xCA, 0x01, 0x05, 0xA8, 0x26, 0x23, 0x7A, 0x81, 0xD0, 0x5F, 0x98, 0x15, 0x05, 0xD8, 0x1E, 0xA3,
  0x20,
  // "C" (U+0043)
  0x38, 0x90, 0x7C, 0xEE, 0xC9, 0x30, 0x2D, 0xE8, 0x18, 0x0C, 0xA8, 0x59, 0x33, 0x6C, 0x25, 0xA0,
  0x96, 0x0A, 0xA0, 0x26, 0x0D, 0xA7, 0x81, 0xEF, 0xD7, 0x81, 0xDF, 0xE7, 0x0B, 0xA0, 0x16, 0x07,
  0xA0, 0x86, 0x01, 0x0E, 0xA8, 0x78, 0x33, 0x59, 0x40, 0x4E, 0xE0, 0x52, 0x86, 0x29, 0xDE, 0xED,
  0x92,
  // "D" (U+0044)
  0x05, 0xC8, 0x2E, 0xC7, 0x13, 0x05, 0xF0, 0xE0, 0x42, 0x05, 0xA8, 0x26, 0x23, 0x7A, 0x82, 0xE2,
  0x05, 0xA0, 0x53, 0x04, 0xA8, 0x1A, 0x05, 0xA0, 0x54, 0x0C, 0xA0, 0x10, 0x5A, 0x05, 0x40, 0x9A,
  0x02, 0x05, 0xA0, 0x54, 0x08, 0xA0, 0x30, 0x5A, 0x05, 0x40, 0x9A, 0x03, 0x05, 0xA0, 0x54, 0x0D,
  0xA1, 0x05, 0xA0, 0x53, 0x05, 0xA8, 0x1A, 0x05, 0xA8, 0x26, 0x23, 0x8A, 0x82, 0xE2, 0x05, 0xF0,
  0xE0, 0x42, 0x05, 0xC8, 0x2E, 0xB7, 0x13,
  // "E" (U+0045)
  0x05, 0xF0, 0x5F, 0x05, 0xA8, 0x46, 0x22, 0x22, 0x5A, 0x05, 0x40, 0x5A, 0x05, 0x40, 0x5E, 0x0A,
  0x05, 0xE0, 0xA0, 0x5A, 0x84, 0x62, 0x22, 0x15, 0xA0, 0x54, 0x05, 0xA0, 0x54, 0x05, 0xA8, 0x46,
  0x22, 0x22, 0x5F, 0x05, 0xF0,
  // "F" (U+0046)
  0x05, 0xF0, 0x5F, 0x05, 0xA8, 0x46, 0x22, 0x22, 0x5A, 0x04, 0x40, 0x5A, 0x04, 0x40, 0x5A, 0x84,
  0x62, 0x22, 0x15, 0xE0, 0xA0, 0x5E, 0x0A, 0x05, 0xA0, 0x44, 0x05, 0xA0, 0x44, 0x05, 0xA0, 0x44,
  0x05, 0xA0, 0x44, 0x05, 0xA0, 0x44,
  // "G" (U+0047)
  0x38, 0x91, 0x5A, 0xDF, 0xEC, 0x82, 0x01, 0xBF, 0x81, 0x40, 0xBA, 0x86, 0xC5, 0x34, 0x7A, 0x05,
  0xA0, 0xC7, 0x0A, 0xA0, 0x37, 0x81, 0xDF, 0xE2, 0x87, 0x12, 0x22, 0x21, 0xEF, 0xD2, 0x07, 0xC8,
  0x29, 0xDF, 0xE2, 0x07, 0xC0, 0x90, 0xBA, 0x01, 0x30, 0x1A, 0x09, 0x07, 0xA0, 0x93, 0x01, 0xA8,
  0x19, 0x1E, 0xA8, 0x29, 0x32, 0x4A, 0x82, 0x90, 0x3E, 0xF0, 0x92, 0x87, 0x18, 0xDE, 0xFE, 0xC8,
  0x30,
  // "H" (U+0048)
  0x05, 0xA0, 0x54, 0x08, 0xA0, 0x20, 0x5A, 0x05, 0x40, 0x8A, 0x02, 0x05, 0xA0, 0x54, 0x08, 0xA0,
  0x20, 0x5A, 0x05, 0x40, 0x8A, 0x02, 0x05, 0xA0, 0x54, 0x08, 0xA0, 0x20, 0x5F, 0xB0, 0x20, 0x5F,
  0xB0, 0x20, 0x5A, 0x84, 0x62, 0x22, 0x29, 0xA0, 0x20, 0x5A, 0x05, 0x40, 0x8A, 0x02, 0x05, 0xA0,
  0x54, 0x08, 0xA0, 0x20, 0x5A, 0x05, 0x40, 0x8A, 0x02, 0x05, 0xA0, 0x54, 0x08, 0xA0, 0x20, 0x5A,
  0x05, 0x40, 0x8A, 0x02,
  // "I" (U+0049)
  0x06, 0xD0, 0x60, 0x5D, 0x85, 0x50, 0x2E, 0xFE, 0x23, 0x81, 0xDF, 0xD4, 0x81, 0xDF, 0xD4, 0x81,
  0xDF, 0xD4, 0x81, 0xDF, 0xD4, 0x81, 0xDF, 0xD4, 0x81, 0xDF, 0xD4, 0x81, 0xDF, 0xD4, 0x81, 0xDF,
  0xD2, 0x04, 0x0E, 0xB8, 0x1E, 0x46, 0xD0, 0x60,
  // "J" (U+004A)
  0x30, 0x5A, 0x05, 0x30, 0x5A, 0x05, 0x30, 0x5A, 0x05, 0x30, 0x5A, 0x05, 0x30, 0x5A, 0x05, 0x30,
  0x5A, 0x05, 0x30, 0x5A, 0x05, 0x30, 0x5A, 0x05, 0x30, 0x5A, 0x05, 0x30, 0x5A, 0x05, 0x30, 0x5A,
  0x05, 0x30, 0x5A, 0x05, 0x30, 0x6A, 0x04, 0x20, 0x10, 0xCA, 0x01, 0x05, 0xC8, 0x1A, 0x05, 0xB0,
  0x93, 0x00, 0x14,
  // "K" (U+004B)
  0x05, 0xA0, 0x53, 0x07, 0xA0, 0x80, 0x5A, 0x05, 0x20, 0x4A, 0x81, 0xB0, 0x5A, 0x87, 0x50, 0x1E,
  0xFE, 0x10, 0x5A, 0x81, 0x50, 0xCA, 0x03, 0x20, 0x5A, 0x05, 0x09, 0xA0, 0x73, 0x05, 0xA0, 0x9A,
  0x0B, 0x40, 0x5D, 0x0C, 0x40, 0x5B, 0x0C, 0xA0, 0x73, 0x05, 0xA8, 0x17, 0x0D, 0xA0, 0x22, 0x05,
  0xA8, 0x15, 0x05, 0xA0, 0xB2, 0x05, 0xA0, 0x52, 0x0A, 0xA8, 0x15, 0x05, 0xA0, 0x52, 0x84, 0x1E,
  0xFE, 0x15, 0xA0, 0x53, 0x07, 0xA0, 0x90,
  // "L" (U+004C)
  0x05, 0xA0, 0x55, 0x05, 0xA0, 0x55, 0x05, 0xA0, 0x55, 0x05, 0xA0, 0x55, 0x05, 0xA0, 0x55, 0x05,
  0xA0, 0x55, 0x05, 0xA0, 0x55, 0x05, 0xA0, 0x55, 0x05, 0xA0, 0x55, 0x05, 0xA0, 0x55, 0x05, 0xA8,
  0x57, 0x33, 0x33, 0x25, 0xF0, 0x80, 0x5F, 0x08,
  // "M" (U+004D)
  0x05, 0xB0, 0x75, 0x08, 0xB0, 0x05, 0xB0, 0xC5, 0x0D, 0xB0, 0x05, 0xC0, 0x13, 0x02, 0xC8, 0x55,
  0x5F, 0xED, 0xF6, 0x38, 0x17, 0xFC, 0xA8, 0x55, 0x5F, 0xE8, 0xFA, 0x38, 0x1C, 0xF7, 0xA0, 0x05,
  0xA0, 0x4A, 0x20, 0x2A, 0x03, 0xA0, 0x05, 0xA1, 0x86, 0xEF, 0x40, 0x7F, 0xA2, 0xA0, 0x05, 0xA1,
  0x86, 0x9F, 0x90, 0xCF, 0x52, 0xA0, 0x05, 0xA1, 0x82, 0x5F, 0xE1, 0xA0, 0x10, 0x2A, 0x00, 0x5A,
  0x2A, 0x83, 0xAF, 0xB0, 0x2A, 0x00, 0x5A, 0x20, 0xBB, 0x81, 0x50, 0x2A, 0x00, 0x5A, 0x20, 0x6B,
  0x81, 0x10, 0x2A, 0x00, 0x5A, 0x20, 0x1A, 0x0B, 0x20, 0x2A, 0x05,
  // "N" (U+004E)
  0x05, 0xB0, 0x54, 0x06, 0xA0, 0x5B, 0x0D, 0x40, 0x6A, 0x05, 0xC0, 0x73, 0x06, 0xA8, 0x55, 0xFE,
  0xDF, 0xE1, 0x20, 0x6A, 0x82, 0x5F, 0xE5, 0xA0, 0x92, 0x06, 0xA0, 0x5A, 0x10, 0xBA, 0x81, 0x30,
  0x6A, 0x05, 0xA1, 0x03, 0xA8, 0x1B, 0x06, 0xA0, 0x5A, 0x20, 0x9A, 0x00, 0x5A, 0x05, 0xA2, 0x83,
  0x1E, 0xFD, 0x5A, 0x05, 0xA3, 0x07, 0xA0, 0xCA, 0x05, 0xA4, 0x0D, 0xC0, 0x5A, 0x40, 0x4C, 0x05,
  0xA5, 0x0B, 0xB0,
  // "O" (U+004F)
  0x28, 0x61, 0x7C, 0xEE, 0xD9, 0x34, 0x03, 0x0E, 0xF0, 0x63, 0x0D, 0xA8, 0x39, 0x32, 0x6E, 0xA8,
  0x14, 0x06, 0xA0, 0x94, 0x04, 0xA8, 0x1B, 0x0B, 0xA0, 0x25, 0x0D, 0xA0, 0x10, 0xDA, 0x60, 0xAA,
  0x82, 0x2E, 0xFE, 0x60, 0x9A, 0x04, 0x0D, 0xA6, 0x0A, 0xA0, 0x20, 0xBA, 0x03, 0x50, 0xDA, 0x01,
  0x06, 0xA0, 0x94, 0x04, 0xA0, 0xB2, 0x0D, 0xA8, 0x39, 0x32, 0x6E, 0xA0, 0x32, 0x03, 0x0D, 0xF0,
  0x64, 0x86, 0x17, 0xCE, 0xED, 0x93, 0x30,
  // "P" (U+0050)
  0x05, 0xC8, 0x1E, 0xC7, 0x20, 0x5F, 0x81, 0xA0, 0x5A, 0x82, 0x62, 0x4D, 0xA0, 0x30, 0x5A, 0x05,
  0x20, 0x5A, 0x07, 0x05, 0xA0, 0x52, 0x05, 0xA0, 0x60, 0x5A, 0x82, 0x50, 0x3D, 0xA0, 0x30, 0x5F,
  0x81, 0xA0, 0x5D, 0x0D, 0x07, 0x20, 0x5A, 0x81, 0x62, 0x14, 0x05, 0xA0, 0x56, 0x05, 0xA0, 0x56,
  0x05, 0xA0, 0x56, 0x05, 0xA0, 0x56,
  // "Q" (U+0051)
  0x28, 0x61, 0x7C, 0xEE, 0xD9, 0x34, 0x03, 0x0E, 0xF0, 0x63, 0x0D, 0xA8, 0x39, 0x32, 0x6E, 0xA8,
  0x14, 0x06, 0xA0, 0x94, 0x04, 0xA8, 0x1B, 0x0B, 0xA0, 0x25, 0x0D, 0xA0, 0x10, 0xDA, 0x60, 0xAA,
  0x82, 0x2E, 0xFE, 0x60, 0x9A, 0x03, 0x0D, 0xA6, 0x0A, 0xA0, 0x20, 0xBA, 0x03, 0x50, 0xDA, 0x01,
  0x06, 0xA0, 0x94, 0x04, 0xA0, 0xB2, 0x0D, 0xA8, 0x39, 0x32, 0x6E, 0xA0, 0x42, 0x03, 0x0D, 0xF0,
  0x74, 0x82, 0x17, 0xCE, 0xB0, 0x67, 0x20, 0x4A, 0x0D, 0x01, 0x72, 0x07, 0xA0, 0xC0, 0x17, 0x20,
  0xAA, 0x0B, 0x10,
  // "R" (U+0052)
  0x05, 0xC8, 0x1E, 0xB6, 0x30, 0x5F, 0x0B, 0x20, 0x5A, 0x82, 0x62, 0x5D, 0xA8, 0x14, 0x05, 0xA0,
  0x52, 0x05, 0xA8, 0x17, 0x05, 0xA0, 0x52, 0x05, 0xA8, 0x16, 0x05, 0xA8, 0x76, 0x25, 0xDF, 0xE1,
  0x05, 0xE0, 0xE0, 0x52, 0x05, 0xE0, 0x53, 0x05, 0xA8, 0x35, 0x0D, 0xFC, 0x30, 0x5A, 0x81, 0x50,
  0x4A, 0x08, 0x20, 0x5A, 0x05, 0x20, 0xAA, 0x81, 0x30, 0x5A, 0x05, 0x28, 0x41, 0xEF, 0xD0, 0x5A,
  0x05, 0x30, 0x6A, 0x08,
  // "S" (U+0053)
  0x28, 0x53, 0xAD, 0xED, 0xA5, 0x20, 0x5E, 0x0D, 0x28, 0x6D, 0xFE, 0x43, 0x5B, 0x72, 0xA0, 0xA7,
  0x0E, 0xA0, 0x56, 0x06, 0xB0, 0xC0, 0x45, 0x07, 0xC0, 0xB0, 0x14, 0x02, 0x09, 0xB0, 0xA6, 0x03,
  0x0D, 0xA0, 0x16, 0x08, 0xA8, 0x92, 0x22, 0xE8, 0x42, 0x4D, 0xFE, 0x02, 0xF0, 0x62, 0x85, 0x7C,
  0xEF, 0xEB, 0x42,
  // "T" (U+0054)
  0x09, 0xFA, 0x01, 0x09, 0xFA, 0x83, 0x11, 0x22, 0x4A, 0x09, 0x0F, 0x24, 0x02, 0xA0, 0x87, 0x02,
  0xA0, 0x87, 0x02, 0xA0, 0x87, 0x02, 0xA0, 0x87, 0x02, 0xA0, 0x87, 0x02, 0xA0, 0x87, 0x02, 0xA0,
  0x87, 0x02, 0xA0, 0x87, 0x02, 0xA0, 0x87, 0x02, 0xA0, 0x84,
  // "U" (U+0055)
  0x07, 0xA0, 0x34, 0x09, 0xA0, 0x10, 0x7A, 0x03, 0x40, 0x9A, 0x01, 0x07, 0xA0, 0x34, 0x09, 0xA0,
  0x10, 0x7A, 0x03, 0x40, 0x9A, 0x01, 0x07, 0xA0, 0x34, 0x09, 0xA0, 0x10, 0x7A, 0x03, 0x40, 0x9A,
  0x01, 0x07, 0xA0, 0x34, 0x09, 0xA0, 0x10, 0x7A, 0x03, 0x40, 0x9A, 0x01, 0x06, 0xA0, 0x54, 0x0B,
  0xA1, 0x04, 0xA0, 0x94, 0x81, 0xEF, 0xE2, 0x0E, 0xA8, 0x29, 0x55, 0xCA, 0x08, 0x20, 0x4F, 0x0C,
  0x48, 0x53, 0xAD, 0xFE, 0xC7, 0x30,
  // "V" (U+0056)
  0x81, 0xCF, 0xD5, 0x03, 0xA0, 0x80, 0x7A, 0x03, 0x40, 0x8A, 0x03, 0x02, 0xA0, 0x84, 0x81, 0xCF,
  0xD2, 0x81, 0xCF, 0xD3, 0x02, 0xA0, 0x82, 0x07, 0xA0, 0x22, 0x07, 0xA0, 0x22, 0x02, 0xA0, 0x72,
  0x81, 0xCF, 0xD4, 0x83, 0xCF, 0xC0, 0x1A, 0x07, 0x40, 0x7A, 0x01, 0x06, 0xA0, 0x24, 0x02, 0xA8,
  0x25, 0xAF, 0xD6, 0x84, 0xCF, 0x9E, 0xF7, 0x68, 0x17, 0xFE, 0xA0, 0x26, 0x02, 0xB0, 0xC7, 0x10,
  0xCA, 0x07, 0x40,
  // "W" (U+0057)
  0x81, 0xDF, 0xC4, 0x0B, 0xA0, 0x13, 0x06, 0xA0, 0x40, 0x9A, 0x40, 0xEA, 0x05, 0x30, 0x9A, 0x10,
  0x5A, 0x03, 0x20, 0x3B, 0x09, 0x38, 0x3D, 0xFC, 0x01, 0xA0, 0x72, 0x83, 0x7F, 0xEF, 0xD2, 0x01,
  0xA0, 0x82, 0x81, 0xDF, 0xB2, 0x81, 0xBF, 0x8A, 0x81, 0x20, 0x4A, 0x04, 0x28, 0x19, 0xFE, 0x28,
  0x6E, 0xF4, 0xDF, 0x60, 0x8A, 0x30, 0x5A, 0x02, 0x03, 0xA1, 0x85, 0xAF, 0xA0, 0xCF, 0xB3, 0x01,
  0xA8, 0x66, 0x7F, 0xC0, 0x6F, 0xE1, 0xA0, 0x74, 0x86, 0xDF, 0x9B, 0xF8, 0x02, 0xA0, 0x4A, 0x04,
  0x48, 0x49, 0xFC, 0xDF, 0x42, 0x81, 0xDF, 0xAA, 0x58, 0x15, 0xFE, 0xA3, 0x83, 0x9F, 0xEF, 0xB5,
  0x01, 0xB0, 0xB3, 0x05, 0xB0, 0x76, 0x0D, 0xA0, 0x73, 0x01, 0xB0, 0x33,
  // "X" (U+0058)
  0x06, 0xA0, 0x84, 0x08, 0xA8, 0x16, 0x0C, 0xA0, 0x22, 0x01, 0xA0, 0xB2, 0x02, 0xA0, 0xB2, 0x0A,
  0xA0, 0x23, 0x08, 0xA0, 0x40, 0x3A, 0x08, 0x58, 0x4D, 0xFD, 0xCF, 0xD6, 0x04, 0xC0, 0x47, 0x0D,
  0xA0, 0xC7, 0x07, 0xC0, 0x55, 0x86, 0x2E, 0xFA, 0xDF, 0xE1, 0x48, 0x3B, 0xFE, 0x14, 0xA0, 0xA3,
  0x06, 0xA0, 0x72, 0x0A, 0xA8, 0x45, 0x01, 0xEF, 0xC3, 0x84, 0x1E, 0xFE, 0x1A, 0xA0, 0x34, 0x06,
  0xA0, 0xA0,
  // "Y" (U+0059)
  0x0B, 0xA0, 0x34, 0x82, 0xEF, 0xE3, 0xA0, 0xA3, 0x07, 0xA8, 0x16, 0x0A, 0xA0, 0x32, 0x81, 0xEF,
  0xD2, 0x02, 0xA8, 0x1B, 0x07, 0xA0, 0x53, 0x09, 0xA8, 0x24, 0xEF, 0xC4, 0x01, 0xA0, 0xEA, 0x04,
  0x50, 0x8B, 0x0B, 0x60, 0x10, 0xEA, 0x03, 0x70, 0xBA, 0x71, 0x0B, 0xA7, 0x10, 0xBA, 0x71, 0x0B,
  0xA7, 0x10, 0xBA, 0x40,
  // "Z" (U+005A)
  0x06, 0xF9, 0x0C, 0x06, 0xF9, 0x0C, 0x01, 0x80, 0x12, 0x0B, 0xA0, 0x45, 0x04, 0xA0, 0x95, 0x82,
  0x1E, 0xFD, 0x60, 0xAA, 0x04, 0x50, 0x5A, 0x09, 0x58, 0x21, 0xEF, 0xD6, 0x0A, 0xA0, 0x35, 0x05,
  0xA0, 0x85, 0x83, 0x1E, 0xFE, 0x38, 0x01, 0x20, 0x8F, 0xA0, 0x8F, 0xA0,
  // "[" (U+005B)
  0x0B, 0xB0, 0x80, 0xBB, 0x87, 0x8B, 0xF9, 0x21, 0xBF, 0x82, 0x81, 0xBF, 0x82, 0x81, 0xBF, 0x82,
  0x81, 0xBF, 0x82, 0x81, 0xBF, 0x82, 0x81, 0xBF, 0x82, 0x81, 0xBF, 0x82, 0x81, 0xBF, 0x82, 0x81,
  0xBF, 0x82, 0x81, 0xBF, 0x82, 0x81, 0xBF, 0x82, 0x0B, 0xB0, 0x80, 0xBB, 0x84, 0x81, 0x22, 0x21,
  // "\" (U+005C)
  0x81, 0xBF, 0xB5, 0x05, 0xA0, 0x15, 0x81, 0xEF, 0x75, 0x81, 0x9F, 0xC5, 0x03, 0xA0, 0x25, 0x81,
  0xDF, 0x85, 0x81, 0x7F, 0xE5, 0x02, 0xA0, 0x45, 0x81, 0xBF, 0xA5, 0x06, 0xA0, 0x14, 0x01, 0xA0,
  0x65, 0x81, 0xAF, 0xC5, 0x04, 0xA0, 0x20,
  // "]" (U+005D)
  0x08, 0xB0, 0xA0, 0x8B, 0x84, 0xA1, 0x2A, 0xFA, 0x28, 0x19, 0xFA, 0x28, 0x19, 0xFA, 0x28, 0x19,
  0xFA, 0x28, 0x19, 0xFA, 0x28, 0x19, 0xFA, 0x28, 0x19, 0xFA, 0x28, 0x19, 0xFA, 0x28, 0x19, 0xFA,
  0x28, 0x19, 0xFA, 0x28, 0x19, 0xFA, 0x28, 0x29, 0xFA, 0x8B, 0x0A, 0x08, 0xB8, 0x4A, 0x12, 0x22,
  0x10,
  // "^" (U+005E)
  0x40, 0x60, 0x57, 0x82, 0x2F, 0xE1, 0x60, 0xAA, 0x08, 0x58, 0x41, 0xFD, 0xDE, 0x14, 0x84, 0x8F,
  0x66, 0xF8, 0x40, 0x0E, 0x28, 0x1E, 0xF1, 0x28, 0x17, 0xF8, 0x28, 0x17, 0xF9, 0x28, 0x1D, 0xF2,
  0x38, 0x4E, 0xF2, 0x5F, 0xA4, 0x81, 0x7F, 0x90,
  // "_" (U+005F)
  0xF0, 0x68, 0x03, 0x20, 0x10,
  // "`" (U+0060)
  0x83, 0x1D, 0xFE, 0x12, 0x82, 0x1C, 0xFB, 0x48, 0x19, 0xF8,
  // "a" (U+0061)
  0x28, 0x55, 0xBE, 0xFD, 0x92, 0x20, 0x1E, 0x0E, 0x01, 0x28, 0x37, 0x74, 0x39, 0xA0, 0x66, 0x02,
  0xA8, 0x37, 0x01, 0x8D, 0xD8, 0x18, 0x0D, 0xF0, 0x80, 0x3A, 0x82, 0xD4, 0x24, 0xA0, 0x80, 0x2A,
  0x82, 0xB3, 0x3A, 0xA8, 0x18, 0x0D, 0xC8, 0x94, 0xDD, 0xF8, 0x02, 0xBE, 0xEA, 0x17, 0xF8,
  // "b" (U+0062)
  0x09, 0xA0, 0x16, 0x09, 0xA0, 0x16, 0x09, 0xA0, 0x16, 0x09, 0xA0, 0x16, 0x09, 0xA8, 0x32, 0xBE,
  0xE9, 0x20, 0x9A, 0x0D, 0xC8, 0x1A, 0x09, 0xA8, 0x2C, 0x34, 0xDA, 0x03, 0x09, 0xA0, 0x42, 0x06,
  0xA0, 0x60, 0x9A, 0x01, 0x20, 0x3A, 0x08, 0x09, 0xA0, 0x22, 0x03, 0xA0, 0x80, 0x9A, 0x04, 0x20,
  0x6A, 0x06, 0x09, 0xA8, 0x2C, 0x44, 0xDA, 0x02, 0x09, 0xF8, 0x90, 0xA0, 0x9F, 0xA4, 0xCF, 0xE8,
  0x20,
  // "c" (U+0063)
  0x28, 0x90, 0x19, 0xDF, 0xDB, 0x40, 0x2E, 0xD8, 0x15, 0x0A, 0xA8, 0x28, 0x34, 0x92, 0xA0, 0xC5,
  0x02, 0xA0, 0x95, 0x02, 0xA0, 0x96, 0xA0, 0xC6, 0x0C, 0xA8, 0x58, 0x34, 0x85, 0x03, 0xE0, 0x62,
  0x85, 0x3A, 0xEF, 0xEA, 0x20,
  // "d" (U+0064)
  0x70, 0xAA, 0x70, 0xAA, 0x70, 0xAA, 0x70, 0xAA, 0x28, 0x44, 0xCF, 0xD6, 0x9A, 0x10, 0x4D, 0x0D,
  0xA1, 0x0C, 0xA8, 0x17, 0x37, 0xB1, 0xA0, 0xC3, 0x0B, 0xA0, 0x2A, 0x09, 0x30, 0x8A, 0x02, 0xA0,
  0x93, 0x08, 0xA1, 0xA0, 0xB3, 0x0B, 0xA1, 0x0C, 0xA8, 0x17, 0x36, 0xB1, 0x04, 0xD0, 0xCA, 0x28,
  0x45, 0xCF, 0xD5, 0x3A,
  // "e" (U+0065)
  0x28, 0x51, 0x9D, 0xFD, 0x81, 0x20, 0x20, 0xED, 0x0C, 0x20, 0xAA, 0x81, 0x63, 0x6A, 0x07, 0x1A,
  0x86, 0xB2, 0x22, 0xCF, 0xB2, 0xF9, 0x0D, 0x02, 0xF9, 0x0D, 0x1A, 0x0A, 0x70, 0xAA, 0x87, 0x73,
  0x34, 0x83, 0x01, 0xDE, 0x04, 0x28, 0x11, 0x8D, 0xA8, 0x1D, 0x81,
  // "f" (U+0066)
  0x28, 0x41, 0xAE, 0xFD, 0x72, 0x0C, 0xC8, 0x16, 0x01, 0xA8, 0x4C, 0x34, 0x10, 0x2A, 0x08, 0x30,
  0x30, 0xCC, 0x81, 0xD0, 0x9D, 0x82, 0xD0, 0x14, 0xA8, 0x19, 0x22, 0x20, 0x2A, 0x08, 0x40, 0x2A,
  0x08, 0x40, 0x2A, 0x08, 0x40, 0x2A, 0x08, 0x40, 0x2A, 0x08, 0x40, 0x2A, 0x08, 0x40, 0x2A, 0x08,
  0x30,
  // "g" (U+0067)
  0x28, 0x44, 0xCF, 0xD6, 0x5A, 0x10, 0x4D, 0x0D, 0xA1, 0x0C, 0xA8, 0x17, 0x37, 0xB1, 0xA0, 0xC3,
  0x0B, 0xA0, 0x2A, 0x09, 0x30, 0x8A, 0x02, 0xA0, 0x93, 0x08, 0xA1, 0xA0, 0xC3, 0x0A, 0xA1, 0x0C,
  0xA8, 0x17, 0x36, 0xB1, 0x04, 0xD0, 0xDA, 0x28, 0x45, 0xDF, 0xD5, 0xAA, 0x78, 0x90, 0xCF, 0xE0,
  0x67, 0x43, 0x38, 0xA8, 0x1A, 0x09, 0xE8, 0x4E, 0x20, 0x4A, 0xDA, 0x81, 0xD9, 0x21,
  // "h" (U+0068)
  0x09, 0xA0, 0x16, 0x09, 0xA0, 0x16, 0x09, 0xA0, 0x16, 0x09, 0xA0, 0x16, 0x09, 0xA8, 0x62, 0xAE,
  0xEA, 0x20, 0x9A, 0x0D, 0xC8, 0x1E, 0x09, 0xA8, 0x2D, 0x43, 0xCA, 0x05, 0x09, 0xA0, 0x52, 0x04,
  0xA0, 0x70, 0x9A, 0x02, 0x20, 0x3A, 0x07, 0x09, 0xA0, 0x12, 0x03, 0xA0, 0x70, 0x9A, 0x01, 0x20,
  0x3A, 0x07, 0x09, 0xA0, 0x12, 0x03, 0xA0, 0x70, 0x9A, 0x01, 0x20, 0x3A, 0x07, 0x09, 0xA0, 0x12,
  0x03, 0xA0, 0x70,
  // "i" (U+0069)
  0x89, 0x06, 0xEC, 0x18, 0xFE, 0x10, 0x16, 0x09, 0xA0, 0x10, 0x9A, 0x01, 0x09, 0xA0, 0x10, 0x9A,
  0x01, 0x09, 0xA0, 0x10, 0x9A, 0x01, 0x09, 0xA0, 0x10, 0x9A, 0x01, 0x09, 0xA0, 0x10, 0x9A, 0x01,
  // "j" (U+006A)
  0x38, 0x26, 0xEC, 0x13, 0x82, 0x8F, 0xE1, 0x40, 0x17, 0x50, 0x9A, 0x01, 0x30, 0x9A, 0x01, 0x30,
  0x9A, 0x01, 0x30, 0x9A, 0x01, 0x30, 0x9A, 0x01, 0x30, 0x9A, 0x01, 0x30, 0x9A, 0x01, 0x30, 0x9A,
  0x01, 0x30, 0x9A, 0x01, 0x30, 0x9A, 0x01, 0x30, 0x9A, 0x83, 0x10, 0x33, 0xDA, 0x10, 0x2C, 0x85,
  0xA0, 0x2E, 0xFE, 0x92,
  // "k" (U+006B)
  0x09, 0xA0, 0x16, 0x09, 0xA0, 0x16, 0x09, 0xA0, 0x16, 0x09, 0xA0, 0x16, 0x09, 0xA0, 0x12, 0x08,
  0xA0, 0x70, 0x9A, 0x81, 0x10, 0x7A, 0x81, 0x80, 0x9A, 0x01, 0x05, 0xA0, 0xA2, 0x09, 0xA0, 0x4A,
  0x0B, 0x30, 0x9A, 0x0D, 0xA0, 0x33, 0x09, 0xD0, 0xC3, 0x09, 0xA0, 0x80, 0x6A, 0x09, 0x20, 0x9A,
  0x81, 0x10, 0xAA, 0x81, 0x50, 0x9A, 0x86, 0x10, 0x1E, 0xFE, 0x19, 0xA0, 0x12, 0x04, 0xA0, 0xB0,
  // "l" (U+006C)
  0x09, 0xA0, 0x10, 0x9A, 0x01, 0x09, 0xA0, 0x10, 0x9A, 0x01, 0x09, 0xA0, 0x10, 0x9A, 0x01, 0x09,
  0xA0, 0x10, 0x9A, 0x01, 0x09, 0xA0, 0x10, 0x9A, 0x01, 0x09, 0xA0, 0x10, 0x9A, 0x01, 0x09, 0xA0,
  0x10, 0x9A, 0x01,
  // "m" (U+006D)
  0x89, 0x79, 0xF9, 0x6C, 0xEE, 0xB4, 0x5C, 0xEE, 0xA2, 0x09, 0xFE, 0x81, 0xD0, 0x9A, 0x82, 0xD4,
  0x4E, 0xA8, 0x2E, 0x53, 0xDA, 0x03, 0x09, 0xA0, 0x52, 0x08, 0xA0, 0x62, 0x07, 0xA0, 0x40, 0x9A,
  0x02, 0x20, 0x7A, 0x03, 0x20, 0x5A, 0x05, 0x09, 0xA0, 0x12, 0x07, 0xA0, 0x32, 0x05, 0xA0, 0x50,
  0x9A, 0x01, 0x20, 0x7A, 0x03, 0x20, 0x5A, 0x05, 0x09, 0xA0, 0x12, 0x07, 0xA0, 0x32, 0x05, 0xA0,
  0x50, 0x9A, 0x01, 0x20, 0x7A, 0x03, 0x20, 0x5A, 0x05, 0x09, 0xA0, 0x12, 0x07, 0xA0, 0x32, 0x05,
  0xA0, 0x50,
  // "n" (U+006E)
  0x89, 0x49, 0xF8, 0x3B, 0xEE, 0xA2, 0x09, 0xFD, 0xEC, 0x81, 0xE1, 0x9A, 0x82, 0xD4, 0x3C, 0xA0,
  0x50, 0x9A, 0x05, 0x20, 0x4A, 0x07, 0x09, 0xA0, 0x22, 0x03, 0xA0, 0x70, 0x9A, 0x01, 0x20, 0x3A,
  0x07, 0x09, 0xA0, 0x12, 0x03, 0xA0, 0x70, 0x9A, 0x01, 0x20, 0x3A, 0x07, 0x09, 0xA0, 0x12, 0x03,
  0xA0, 0x70, 0x9A, 0x01, 0x20, 0x3A, 0x07,
  // "o" (U+006F)
  0x28, 0x51, 0x9D, 0xFD, 0x92, 0x30, 0x20, 0xED, 0x0E, 0x02, 0x20, 0xAA, 0x81, 0x73, 0x6A, 0x0C,
  0x2A, 0x0B, 0x30, 0x9A, 0x00, 0x2A, 0x09, 0x30, 0x7A, 0x04, 0x02, 0xA0, 0x93, 0x07, 0xA0, 0x41,
  0xA0, 0xC3, 0x0A, 0xA8, 0x12, 0x09, 0xA8, 0x17, 0x36, 0xA0, 0xC2, 0x01, 0x0D, 0xD0, 0xE0, 0x33,
  0x85, 0x18, 0xDF, 0xEA, 0x22,
  // "p" (U+0070)
  0x86, 0x9F, 0xA1, 0xBE, 0xE9, 0x28, 0x29, 0xFE, 0xDC, 0x81, 0xA0, 0x9A, 0x82, 0xC3, 0x4D, 0xA0,
  0x30, 0x9A, 0x04, 0x20, 0x5A, 0x06, 0x09, 0xA0, 0x12, 0x03, 0xA0, 0x80, 0x9A, 0x02, 0x20, 0x3A,
  0x08, 0x09, 0xA0, 0x42, 0x05, 0xA0, 0x60, 0x9A, 0x82, 0xC4, 0x4D, 0xA0, 0x20, 0x9A, 0x0E, 0xC8,
  0x19, 0x09, 0xA8, 0x33, 0xBF, 0xE8, 0x20, 0x9A, 0x01, 0x60, 0x9A, 0x01, 0x60, 0x9A, 0x01, 0x60,
  0x9A, 0x01, 0x60,
  // "q" (U+0071)
  0x28, 0x44, 0xCF, 0xD6, 0x5A, 0x10, 0x4D, 0x0D, 0xA1, 0x0C, 0xA8, 0x17, 0x37, 0xB1, 0xA0, 0xC3,
  0x0B, 0xA0, 0x2A, 0x09, 0x30, 0x8A, 0x02, 0xA0, 0x93, 0x08, 0xA0, 0x1A, 0x0C, 0x30, 0xAA, 0x10,
  0xCA, 0x81, 0x73, 0x6B, 0x10, 0x4D, 0x0D, 0xA2, 0x84, 0x5D, 0xFD, 0x5A, 0xA7, 0x0A, 0xA7, 0x0A,
  0xA7, 0x0A, 0xA7, 0x0A, 0xA0,
  // "r" (U+0072)
  0x89, 0x19, 0xF8, 0x1A, 0xEB, 0x9F, 0xDD, 0xA0, 0xA0, 0x9A, 0x83, 0xE7, 0x31, 0x9A, 0x05, 0x30,
  0x9A, 0x01, 0x30, 0x9A, 0x01, 0x30, 0x9A, 0x01, 0x30, 0x9A, 0x01, 0x30, 0x9A, 0x01, 0x30, 0x9A,
  0x01, 0x30,
  // "s" (U+0073)
  0x18, 0x51, 0x9D, 0xFE, 0xB6, 0x20, 0xDD, 0x81, 0xD0, 0x2A, 0x85, 0xA2, 0x48, 0x60, 0x1A, 0x0D,
  0x04, 0x50, 0x6B, 0x0D, 0x06, 0x48, 0x11, 0x8E, 0xA0, 0xB6, 0x0A, 0xA8, 0x52, 0x2A, 0x63, 0x2A,
  0xA0, 0x30, 0x2E, 0x83, 0xC0, 0x19, 0xDA, 0x81, 0xD9, 0x11,
  // "t" (U+0074)
  0x28, 0x18, 0xF5, 0x58, 0x1D, 0xF5, 0x30, 0x20, 0xBD, 0x01, 0x09, 0xE8, 0x11, 0x16, 0xA8, 0x17,
  0x22, 0x20, 0x4A, 0x05, 0x40, 0x4A, 0x05, 0x40, 0x4A, 0x05, 0x40, 0x4A, 0x05, 0x40, 0x3A, 0x82,
  0xA2, 0x31, 0x20, 0xEC, 0x03, 0x28, 0x43, 0xCF, 0xEC, 0x20,
  // "u" (U+0075)
  0x0A, 0xA3, 0x04, 0xA0, 0x60, 0xAA, 0x30, 0x4A, 0x06, 0x0A, 0xA3, 0x04, 0xA0, 0x60, 0xAA, 0x30,
  0x4A, 0x06, 0x0A, 0xA3, 0x04, 0xA0, 0x60, 0xAA, 0x30, 0x5A, 0x06, 0x0A, 0xA0, 0x12, 0x07, 0xA0,
  0x60, 0x8A, 0x82, 0x80, 0x3D, 0xA0, 0x60, 0x3D, 0x0E, 0xA8, 0x91, 0x60, 0x4B, 0xEE, 0xA2, 0xBF,
  0x60,
  // "v" (U+0076)
  0x81, 0xCF, 0xE4, 0x0B, 0xA0, 0x10, 0x6A, 0x04, 0x20, 0x1A, 0x81, 0xA0, 0x1A, 0x09, 0x20, 0x6A,
  0x04, 0x28, 0x1A, 0xFE, 0x28, 0x1B, 0xFE, 0x30, 0x4A, 0x04, 0x01, 0xA0, 0x84, 0x82, 0xEF, 0x95,
  0xA0, 0x24, 0x84, 0x8F, 0xDA, 0xFC, 0x50, 0x2A, 0x81, 0xDF, 0x66, 0x0C, 0xB0, 0x16, 0x06, 0xA0,
  0xA4,
  // "w" (U+0077)
  0x81, 0xAF, 0xE3, 0x0D, 0xA0, 0x42, 0x08, 0xA0, 0x10, 0x6A, 0x81, 0x30, 0x2B, 0x08, 0x28, 0x3C,
  0xFC, 0x01, 0xA8, 0x77, 0x05, 0xFB, 0xFC, 0x01, 0xA0, 0x82, 0x89, 0x1D, 0xFB, 0x09, 0xF5, 0xEF,
  0x05, 0xA0, 0x32, 0x08, 0xA1, 0x87, 0xDF, 0x1B, 0xF4, 0x8F, 0xE3, 0x04, 0xA8, 0x90, 0x4F, 0xD0,
  0x7F, 0x7C, 0xFA, 0x4A, 0x85, 0x9F, 0xA0, 0x4F, 0xAA, 0x06, 0x48, 0x3B, 0xFD, 0xF6, 0x29, 0x0D,
  0xA0, 0x14, 0x07, 0xB0, 0x22, 0x0D, 0xA0, 0xC5, 0x02, 0xA0, 0xE3, 0x09, 0xA0, 0x83,
  // "x" (U+0078)
  0x06, 0xA0, 0x92, 0x02, 0xA0, 0xC2, 0x0B, 0xA8, 0x13, 0x0C, 0xA0, 0x32, 0x02, 0xA0, 0xC0, 0x6A,
  0x08, 0x40, 0x7C, 0x0D, 0x60, 0xCB, 0x03, 0x50, 0x10, 0xEB, 0x05, 0x50, 0x9A, 0x82, 0xEF, 0xE1,
  0x30, 0x4A, 0x0A, 0x03, 0xA0, 0xA3, 0x84, 0xDF, 0xE1, 0x0A, 0xA8, 0x15, 0x09, 0xA0, 0x62, 0x83,
  0x1E, 0xFE, 0x10,
  // "y" (U+0079)
  0x0C, 0xA0, 0x13, 0x0C, 0xA0, 0x10, 0x6A, 0x06, 0x20, 0x2A, 0x0A, 0x28, 0x1E, 0xFC, 0x20, 0x7A,
  0x04, 0x20, 0x9A, 0x83, 0x10, 0xCF, 0xD3, 0x02, 0xA0, 0x70, 0x2A, 0x08, 0x48, 0x2C, 0xFC, 0x7A,
  0x02, 0x40, 0x5A, 0x81, 0xBF, 0xB6, 0x0E, 0xB0, 0x66, 0x08, 0xA0, 0xE7, 0x03, 0xA0, 0x97, 0x06,
  0xA0, 0x34, 0x84, 0x12, 0x5E, 0xFC, 0x50, 0x6B, 0x0E, 0x03, 0x58, 0x35, 0xFE, 0xA3, 0x60,
  // "z" (U+007A)
  0x03, 0xF0, 0x10, 0x3F, 0x84, 0x10, 0x22, 0x25, 0xA0, 0x94, 0x82, 0x1D, 0xFC, 0x58, 0x2A, 0xFE,
  0x24, 0x06, 0xA0, 0x54, 0x02, 0xA0, 0xA5, 0x87, 0xDF, 0xE3, 0x22, 0x20, 0x7F, 0x03, 0x08, 0xF0,
  0x30,
  // "{" (U+007B)
  0x38, 0x27, 0xCE, 0x52, 0x04, 0xB0, 0x52, 0x07, 0xA0, 0x50, 0x12, 0x81, 0x7F, 0xD4, 0x81, 0x7F,
  0xD4, 0x81, 0x8F, 0xD3, 0x82, 0x3D, 0xFB, 0x20, 0xBA, 0x0C, 0x03, 0x20, 0xBA, 0x0A, 0x02, 0x28,
  0x32, 0x5E, 0xFB, 0x48, 0x18, 0xFD, 0x48, 0x17, 0xFD, 0x48, 0x17, 0xFD, 0x40, 0x7A, 0x05, 0x01,
  0x20, 0x4B, 0x05, 0x38, 0x27, 0xDE, 0x50,
  // "|" (U+007C)
  0x98, 0xC1, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF,
  0xEF, 0xEF, 0xEF, 0xE0,
  // "}" (U+007D)
  0x82, 0x4E, 0xD8, 0x30, 0x4B, 0x06, 0x38, 0x24, 0xEF, 0x84, 0x81, 0xBF, 0x94, 0x81, 0xBF, 0x94,
  0x81, 0xBF, 0x94, 0x82, 0xAF, 0xE3, 0x30, 0x20, 0xCA, 0x0C, 0x28, 0x31, 0x9E, 0xFC, 0x28, 0x39,
  0xFE, 0x62, 0x28, 0x1B, 0xF9, 0x48, 0x1B, 0xF9, 0x48, 0x1B, 0xF9, 0x38, 0x24, 0xEF, 0x82, 0x04,
  0xB0, 0x62, 0x82, 0x4F, 0xD8, 0x30,
  // "~" (U+007E)
  0x89, 0x11, 0x9E, 0xEC, 0x84, 0x37, 0x63, 0xF9, 0x89, 0x17, 0x39, 0x33, 0x7B, 0xEE, 0xB2,
  // "¡" (U+00A1)
  0x83, 0x8E, 0xA0, 0xEA, 0x82, 0x18, 0xEA, 0x58, 0xB3, 0x8F, 0xA0, 0x9F, 0xA0, 0xAF, 0xB0, 0xAF,
  0xC0, 0xBF, 0xD0, 0xCF, 0xD0, 0xDF, 0xE0, 0xDA, 0x10, 0xEA, 0x10,
  // "¢" (U+00A2)
  0x49, 0x08, 0x58, 0x24, 0xFA, 0x42, 0x03, 0x0D, 0xC8, 0x1E, 0x1E, 0xD0, 0xB0, 0x7A, 0x84, 0xA1,
  0x04, 0x3A, 0xA0, 0x24, 0x0B, 0xA5, 0x0A, 0xA0, 0x24, 0x06, 0xA8, 0x5A, 0x10, 0x25, 0x0D, 0xD8,
  0x3D, 0x01, 0x9E, 0xB0, 0x94, 0x90, 0x86, 0x90, 0x82,
  // "£" (U+00A3)
  0x38, 0x53, 0xBE, 0xED, 0x93, 0x20, 0x3E, 0x03, 0x20, 0x9A, 0x82, 0x73, 0x58, 0x30, 0xAA, 0x78,
  0x1A, 0xFE, 0x50, 0x4F, 0x81, 0x30, 0x4F, 0x03, 0x28, 0x22, 0xBF, 0xE0, 0xF2, 0x48, 0x1B, 0xFE,
  0x78, 0x1D, 0xFB, 0x68, 0x28, 0xFE, 0x48, 0x01, 0x20, 0x4F, 0x90, 0xE0, 0x4F, 0x90, 0xE0,
  // "¤" (U+00A4)
  0x10, 0x54, 0x89, 0x33, 0x20, 0xBF, 0x9D, 0xE9, 0xEE, 0x16, 0xE8, 0x94, 0x90, 0x1F, 0xE4, 0x3B,
  0xF5, 0x04, 0xF8, 0x28, 0x94, 0x3F, 0x90, 0x2F, 0xD2, 0x19, 0xF6, 0x03, 0xE8, 0x37, 0x0B, 0xFC,
  0xA8, 0x92, 0xCF, 0xE1, 0x17, 0x01, 0x10, 0x54, 0x10,
  // "¥" (U+00A5)
  0x0B, 0xA0, 0x13, 0x82, 0xBF, 0xE3, 0xA0, 0x72, 0x03, 0xA8, 0x37, 0x0B, 0xFD, 0x28, 0x1A, 0xFE,
  0x20, 0x4A, 0x05, 0x01, 0xA0, 0x83, 0x85, 0xCF, 0xC8, 0xFE, 0x13, 0x05, 0xA8, 0x1E, 0xF8, 0x50,
  0xDB, 0x01, 0x30, 0x4E, 0x08, 0x20, 0x4E, 0x08, 0x20, 0x4E, 0x08, 0x20, 0x4E, 0x08, 0x30, 0x20,
  0x4A, 0x81, 0x72, 0x14, 0x01, 0xA0, 0x63,
  // "¦" (U+00A6)
  0x98, 0x93, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xE7, 0x19, 0x89, 0x3E, 0xFE, 0xFE, 0xFE, 0xFE,
  0xFE, 0xFE,
  // "§" (U+00A7)
  0x28, 0x67, 0xDF, 0xE9, 0x20, 0x8D, 0x89, 0x39, 0x0D, 0xF7, 0x24, 0x93, 0x0C, 0xF9, 0x58, 0x42,
  0xEF, 0xE9, 0x12, 0x8B, 0x56, 0xFB, 0xCF, 0xE3, 0x0D, 0xF1, 0x07, 0xFB, 0x0C, 0xF9, 0x03, 0xFC,
  0x03, 0xDF, 0xED, 0xF4, 0x30, 0x50, 0xCA, 0x04, 0x58, 0x92, 0x7F, 0xC0, 0xB6, 0x33, 0xAF, 0xC1,
  0xE8, 0x66, 0x05, 0xCE, 0xEC, 0x51,
  // "¨" (U+00A8)
  0x10, 0x13, 0x89, 0x61, 0x06, 0xFB, 0x0D, 0xF5, 0x4E, 0x90, 0xBE, 0x40,
  // "©" (U+00A9)
  0x48, 0x54, 0xAE, 0xFD, 0xA4, 0x78, 0x7A, 0xD6, 0x10, 0x16, 0xDA, 0x58, 0x91, 0xBB, 0x03, 0xBE,
  0xEA, 0x1C, 0xB3, 0x89, 0x35, 0xD0, 0x2F, 0xA3, 0x46, 0x01, 0xE5, 0x28, 0x3C, 0x70, 0x9E, 0x60,
  0x80, 0xB2, 0x98, 0x23, 0x0D, 0xA6, 0x87, 0x4F, 0x01, 0xF2, 0x0C, 0xA6, 0x87, 0x3F, 0x10, 0xF3,
  0x0A, 0xC6, 0x04, 0x92, 0x87, 0xC7, 0x04, 0xF7, 0x01, 0x32, 0x08, 0x0C, 0x20, 0x60, 0xD2, 0x07,
  0x0E, 0xA8, 0x39, 0x01, 0xE6, 0x30, 0xC0, 0xA3, 0x84, 0x21, 0x01, 0xBB, 0x48, 0x91, 0x1B, 0xD5,
  0x10, 0x16, 0xDB, 0x16, 0x85, 0x5B, 0xEF, 0xEB, 0x54,
  // "ª" (U+00AA)
  0x18, 0x39, 0xDF, 0xD4, 0x28, 0x37, 0x55, 0xDE, 0x20, 0xA0, 0xEB, 0x89, 0x71, 0x7F, 0x93, 0xBF,
  0x18, 0xF6, 0x3E, 0xF1, 0x2E, 0xA8, 0x19, 0xF1, 0x28, 0x23, 0x10, 0x31,
  // "«" (U+00AB)
  0x38, 0x57, 0xB3, 0x01, 0xC6, 0x30, 0x4A, 0x89, 0x68, 0x0C, 0xFD, 0x10, 0x2E, 0xFA, 0x09, 0xFE,
  0x32, 0x83, 0xDF, 0xD0, 0x6A, 0x05, 0x28, 0x41, 0xEF, 0xC0, 0x8A, 0x04, 0x30, 0x3A, 0x84, 0x90,
  0xBF, 0xE1, 0x30, 0x6A, 0x83, 0x61, 0xDF, 0xC4, 0x86, 0x8D, 0x50, 0x2E, 0x91,
  // "¬" (U+00AC)
  0x18, 0x04, 0x20, 0x10, 0x3F, 0x90, 0x70, 0x3F, 0x90, 0x77, 0x81, 0x6F, 0x77, 0x81, 0x6F, 0x77,
  0x81, 0x6F, 0x70,
  // "®" (U+00AE)
  0x48, 0x54, 0xAE, 0xFD, 0xA4, 0x78, 0x7A, 0xD6, 0x10, 0x16, 0xDA, 0x58, 0x1B, 0xB1, 0xA8, 0x4E,
  0xC4, 0x1C, 0xB3, 0x89, 0x35, 0xD0, 0x1F, 0x73, 0xAE, 0x01, 0xE5, 0x28, 0x93, 0xC7, 0x01, 0xF6,
  0x05, 0xF2, 0x08, 0xB2, 0x98, 0x63, 0x01, 0xF6, 0x0A, 0xE2, 0x86, 0x4F, 0x01, 0xF2, 0x01, 0xB0,
  0xE0, 0x32, 0x89, 0x33, 0xF1, 0x0F, 0x30, 0x1F, 0x76, 0xF3, 0x20, 0x49, 0x28, 0x7C, 0x70, 0x1F,
  0x60, 0xCB, 0x20, 0x80, 0xC2, 0x89, 0x36, 0xD0, 0x1F, 0x60, 0x4F, 0x51, 0xE6, 0x38, 0x3C, 0xA1,
  0x62, 0x28, 0x25, 0x5B, 0xB4, 0x89, 0x11, 0xBD, 0x51, 0x01, 0x6D, 0xB1, 0x68, 0x55, 0xBE, 0xFE,
  0xB5, 0x40,
  // "¯" (U+00AF)
  0x80, 0x52, 0xFF, 0xC0,
  // "°" (U+00B0)
  0x30, 0x01, 0x30, 0x30, 0xDA, 0x82, 0xB1, 0x0E, 0xC8, 0x97, 0x93, 0xFB, 0x12, 0xEE, 0x3F, 0xC3,
  0x5E, 0xE0, 0xDC, 0x85, 0x80, 0x2B, 0xEE, 0x81,
  // "±" (U+00B1)
  0x48, 0x1C, 0xF1, 0x78, 0x1C, 0xF1, 0x78, 0x1C, 0xF1, 0x30, 0x3F, 0x90, 0x70, 0x3F, 0x98, 0x91,
  0x70, 0x22, 0x2D, 0xF3, 0x22, 0x14, 0x81, 0xCF, 0x17, 0x81, 0xCF, 0x14, 0x0F, 0x28, 0x5D, 0xF3,
  0x22, 0x13, 0xF9, 0x07, 0x03, 0xF9, 0x07,
  // "²" (U+00B2)
  0x18, 0x92, 0x7D, 0xEC, 0x20, 0x4F, 0xEE, 0xFC, 0x28, 0x35, 0x03, 0xFE, 0x48, 0x18, 0xF9, 0x38,
  0x17, 0xFC, 0x38, 0x17, 0xFB, 0x30, 0x6A, 0x83, 0xDC, 0xC2, 0x8D, 0x02,
  // "³" (U+00B3)
  0x18, 0xA1, 0x7D, 0xEB, 0x22, 0xFE, 0xEF, 0xB0, 0x20, 0x3F, 0xB0, 0x4A, 0x87, 0xB1, 0x03, 0xCE,
  0xF8, 0x23, 0x89, 0x4E, 0xF7, 0xFD, 0xDF, 0xD2, 0xBE, 0xEB, 0x30,
  // "´" (U+00B4)
  0x20, 0x8A, 0x81, 0x70, 0x4A, 0x84, 0x60, 0x1E, 0xE3, 0x20,
  // "µ" (U+00B5)
  0x09, 0xA0, 0x12, 0x03, 0xA0, 0x70, 0x9A, 0x01, 0x20, 0x3A, 0x07, 0x09, 0xA0, 0x12, 0x03, 0xA0,
  0x70, 0x9A, 0x01, 0x20, 0x3A, 0x07, 0x09, 0xA0, 0x12, 0x03, 0xA0, 0x70, 0x9A, 0x01, 0x20, 0x4A,
  0x07, 0x09, 0xA0, 0x32, 0x07, 0xA0, 0x70, 0x9A, 0x82, 0xB3, 0x5E, 0xA0, 0x70, 0x9D, 0x83, 0xEE,
  0xF7, 0x9A, 0x86, 0xAE, 0xD3, 0xAF, 0x79, 0xA0, 0x16, 0x09, 0xA0, 0x16, 0x09, 0xA0, 0x16, 0x09,
  0xA0, 0x16,
  // "¶" (U+00B6)
  0x18, 0x14, 0xBE, 0xD0, 0x04, 0xF9, 0x04, 0x0B, 0xD8, 0x37, 0x4F, 0x4E, 0xD8, 0x25, 0x2F, 0x4E,
  0x83, 0x52, 0xF4, 0xED, 0x83, 0x52, 0xF4, 0xCD, 0x83, 0x52, 0xF4, 0x6D, 0x84, 0x52, 0xF4, 0x09,
  0xC8, 0x25, 0x2F, 0x42, 0x86, 0x12, 0x2F, 0x52, 0xF4, 0x59, 0x82, 0x52, 0xF4, 0x59, 0x82, 0x52,
  0xF4, 0x59, 0x82, 0x52, 0xF4, 0x59, 0x82, 0x52, 0xF4, 0x59, 0x82, 0x52, 0xF4, 0x59, 0x82, 0x52,
  0xF4, 0x50, 0x22, 0x02, 0x10,
  // "·" (U+00B7)
  0x83, 0x8E, 0xA0, 0xEA, 0x82, 0x18, 0xEA, 0x10,
  // "¸" (U+00B8)
  0x20, 0x20, 0x12, 0x81, 0x8F, 0x82, 0x89, 0x05, 0xDF, 0x71, 0x29, 0xF9, 0x5A, 0x84, 0xE3, 0x14,
  0x41, 0x10,
  // "¹" (U+00B9)
  0x18, 0x33, 0xEF, 0x15, 0xB8, 0x91, 0x1D, 0xBE, 0xF1, 0x10, 0xEF, 0x12, 0x81, 0xEF, 0x12, 0x81,
  0xEF, 0x12, 0x81, 0xEF, 0x12, 0x81, 0xEF, 0x10,
  // "º" (U+00BA)
  0x18, 0xC2, 0x4C, 0xEC, 0x30, 0x2F, 0xC5, 0xCE, 0x16, 0xF5, 0x06, 0xF5, 0x6F, 0x40, 0x5F, 0x63,
  0xFA, 0x1A, 0xF3, 0x07, 0xB0, 0x73, 0x81, 0x13, 0x12,
  // "»" (U+00BB)
  0x85, 0x6D, 0x20, 0x2A, 0x83, 0x83, 0xDF, 0xC0, 0x6A, 0x05, 0x28, 0x72, 0xEF, 0xA0, 0x9F, 0xE2,
  0x20, 0x4A, 0x86, 0x80, 0xCF, 0xD1, 0x03, 0xA8, 0x92, 0xA0, 0xBF, 0xE2, 0x1D, 0xFC, 0x08, 0xA8,
  0x54, 0x0B, 0xFE, 0x15, 0xA0, 0x72, 0x85, 0x8E, 0x30, 0x4D, 0x93,
  // "¼" (U+00BC)
  0x28, 0x18, 0xFB, 0x48, 0x15, 0xFB, 0x30, 0x10, 0xBA, 0x0B, 0x48, 0x1D, 0xF3, 0x38, 0x33, 0xD8,
  0xFB, 0x38, 0x16, 0xFA, 0x68, 0x15, 0xFB, 0x38, 0x1E, 0xF2, 0x68, 0x15, 0xFB, 0x28, 0x18, 0xF8,
  0x78, 0x92, 0x5F, 0xB0, 0x1E, 0xE1, 0x0B, 0xFA, 0x38, 0x75, 0xFB, 0x09, 0xF7, 0x06, 0xA0, 0xA3,
  0x89, 0x25, 0xFB, 0x2F, 0xD0, 0x2E, 0xDF, 0xA6, 0x87, 0xBF, 0x50, 0xBC, 0x6F, 0xA5, 0x89, 0x14,
  0xFC, 0x07, 0xF4, 0x7F, 0xB1, 0x48, 0x3C, 0xF4, 0x0C, 0xD0, 0xC3, 0x81, 0x5F, 0xB2, 0x85, 0x35,
  0x59, 0xFC, 0x33, 0x81, 0xDF, 0x25, 0x81, 0x6F, 0xA1,
  // "½" (U+00BD)
  0x28, 0x18, 0xFB, 0x48, 0x15, 0xFB, 0x40, 0x10, 0xBA, 0x0B, 0x48, 0x1D, 0xF3, 0x48, 0x34, 0xE9,
  0xFB, 0x38, 0x16, 0xFA, 0x78, 0x15, 0xFB, 0x38, 0x1E, 0xF2, 0x78, 0x15, 0xFB, 0x28, 0x18, 0xF8,
  0x71, 0x89, 0x35, 0xFB, 0x01, 0xEE, 0x28, 0xEE, 0xB2, 0x38, 0x93, 0x5F, 0xB0, 0x9F, 0x76, 0xFD,
  0xDF, 0xB3, 0x84, 0x5F, 0xB2, 0xFD, 0x28, 0x36, 0x04, 0xFC, 0x68, 0x1B, 0xF5, 0x48, 0x1B, 0xF5,
  0x58, 0x14, 0xFC, 0x48, 0x1B, 0xF7, 0x68, 0x1C, 0xF4, 0x28, 0x41, 0xCF, 0x82, 0x24, 0x81, 0x5F,
  0xB3, 0x09, 0xD0, 0x13, 0x81, 0xDF, 0x23, 0x09, 0xD0, 0x10,
  // "¾" (U+00BE)
  0x30, 0x26, 0x81, 0x12, 0x13, 0x09, 0xB0, 0x74, 0x81, 0xCF, 0x43, 0x82, 0xA8, 0x6E, 0x93, 0x81,
  0x5F, 0xB6, 0x81, 0x1D, 0xD3, 0x81, 0xDF, 0x35, 0xA0, 0xD0, 0x22, 0x81, 0x6F, 0xA6, 0x87, 0x24,
  0xED, 0x10, 0xEF, 0x27, 0x18, 0xA4, 0x9F, 0x57, 0xF9, 0x07, 0xFE, 0x03, 0xC4, 0x3D, 0xF4, 0xEE,
  0x12, 0xA8, 0x2E, 0x02, 0xEB, 0x87, 0x99, 0xF8, 0x0C, 0xEF, 0xE3, 0x89, 0x23, 0x42, 0x2F, 0xE0,
  0x7F, 0x6F, 0xE6, 0x89, 0x0A, 0xF6, 0x3F, 0x84, 0xFE, 0x24, 0x83, 0x3F, 0xD0, 0x7E, 0x48, 0x6B,
  0xF5, 0x02, 0x55, 0x6A, 0x05, 0x38, 0x14, 0xFC, 0x58, 0x12, 0xFE, 0x10,
  // "¿" (U+00BF)
  0x48, 0x1B, 0xE6, 0x50, 0x2A, 0x0C, 0x68, 0x1B, 0xE6, 0x77, 0x18, 0x16, 0x84, 0x68, 0x1D, 0xF7,
  0x40, 0x10, 0xAA, 0x02, 0x38, 0x32, 0xDF, 0xE4, 0x48, 0x2C, 0xFD, 0x24, 0x01, 0xA0, 0x65, 0x01,
  0xA8, 0x6B, 0x33, 0x6D, 0x40, 0xAE, 0x0B, 0x28, 0x57, 0xCE, 0xEC, 0x71,
  // "À" (U+00C0)
  0x28, 0x31, 0xDF, 0xE1, 0x72, 0x82, 0x1C, 0xFB, 0x74, 0x81, 0x9F, 0x87, 0x77, 0x10, 0xAB, 0x72,
  0x0E, 0xB0, 0x57, 0x05, 0xA8, 0x1B, 0xFB, 0x78, 0x2A, 0xFC, 0x6A, 0x01, 0x50, 0x1A, 0x08, 0x01,
  0xA0, 0x65, 0x06, 0xA8, 0x33, 0x0C, 0xFC, 0x58, 0x1B, 0xFE, 0x20, 0x7A, 0x02, 0x30, 0x1A, 0x82,
  0xB4, 0x46, 0xA0, 0x73, 0x06, 0xF9, 0x0D, 0x30, 0xCF, 0xA8, 0x13, 0x02, 0xA0, 0xB4, 0x04, 0xA8,
  0x18, 0x07, 0xA0, 0x65, 0x83, 0xEF, 0xD0, 0xCA, 0x01, 0x50, 0xAA, 0x03,
  // "Á" (U+00C1)
  0x60, 0x8A, 0x07, 0x71, 0x04, 0xA0, 0x67, 0x18, 0x21, 0xEE, 0x37, 0x77, 0x10, 0xAB, 0x72, 0x0E,
  0xB0, 0x57, 0x05, 0xA8, 0x1B, 0xFB, 0x78, 0x2A, 0xFC, 0x6A, 0x01, 0x50, 0x1A, 0x08, 0x01, 0xA0,
  0x65, 0x06, 0xA8, 0x33, 0x0C, 0xFC, 0x58, 0x1B, 0xFE, 0x20, 0x7A, 0x02, 0x30, 0x1A, 0x82, 0xB4,
  0x46, 0xA0, 0x73, 0x06, 0xF9, 0x0D, 0x30, 0xCF, 0xA8, 0x13, 0x02, 0xA0, 0xB4, 0x04, 0xA8, 0x18,
  0x07, 0xA0, 0x65, 0x83, 0xEF, 0xD0, 0xCA, 0x01, 0x50, 0xAA, 0x03,
  // "Â" (U+00C2)
  0x40, 0x5B, 0x07, 0x78, 0x23, 0xEF, 0x9A, 0x03, 0x58, 0x71, 0xDE, 0x40, 0x4D, 0xE2, 0x77, 0x50,
  0xAB, 0x72, 0x0E, 0xB0, 0x57, 0x05, 0xA8, 0x1B, 0xFB, 0x78, 0x2A, 0xFC, 0x6A, 0x01, 0x50, 0x1A,
  0x08, 0x01, 0xA0, 0x65, 0x06, 0xA8, 0x33, 0x0C, 0xFC, 0x58, 0x1B, 0xFE, 0x20, 0x7A, 0x02, 0x30,
  0x1A, 0x82, 0xB4, 0x46, 0xA0, 0x73, 0x06, 0xF9, 0x0D, 0x30, 0xCF, 0xA8, 0x13, 0x02, 0xA0, 0xB4,
  0x04, 0xA8, 0x18, 0x07, 0xA0, 0x65, 0x83, 0xEF, 0xD0, 0xCA, 0x01, 0x50, 0xAA, 0x03,
  // "Ã" (U+00C3)
  0x38, 0x53, 0xDE, 0x83, 0xAE, 0x60, 0xDD, 0x09, 0x58, 0x62, 0xF6, 0x4A, 0xEB, 0x17, 0x76, 0x0A,
  0xB7, 0x20, 0xEB, 0x05, 0x70, 0x5A, 0x81, 0xBF, 0xB7, 0x82, 0xAF, 0xC6, 0xA0, 0x15, 0x01, 0xA0,
  0x80, 0x1A, 0x06, 0x50, 0x6A, 0x83, 0x30, 0xCF, 0xC5, 0x81, 0xBF, 0xE2, 0x07, 0xA0, 0x23, 0x01,
  0xA8, 0x2B, 0x44, 0x6A, 0x07, 0x30, 0x6F, 0x90, 0xD3, 0x0C, 0xFA, 0x81, 0x30, 0x2A, 0x0B, 0x40,
  0x4A, 0x81, 0x80, 0x7A, 0x06, 0x58, 0x3E, 0xFD, 0x0C, 0xA0, 0x15, 0x0A, 0xA0, 0x30,
  // "Ä" (U+00C4)
  0x40, 0x13, 0x01, 0x78, 0x56, 0xFB, 0x0D, 0xF5, 0x68, 0x54, 0xE9, 0x0B, 0xE4, 0x77, 0x60, 0xAB,
  0x72, 0x0E, 0xB0, 0x57, 0x05, 0xA8, 0x1B, 0xFB, 0x78, 0x2A, 0xFC, 0x6A, 0x01, 0x50, 0x1A, 0x08,
  0x01, 0xA0, 0x65, 0x06, 0xA8, 0x33, 0x0C, 0xFC, 0x58, 0x1B, 0xFE, 0x20, 0x7A, 0x02, 0x30, 0x1A,
  0x82, 0xB4, 0x46, 0xA0, 0x73, 0x06, 0xF9, 0x0D, 0x30, 0xCF, 0xA8, 0x13, 0x02, 0xA0, 0xB4, 0x04,
  0xA8, 0x18, 0x07, 0xA0, 0x65, 0x83, 0xEF, 0xD0, 0xCA, 0x01, 0x50, 0xAA, 0x03,
  // "Å" (U+00C5)
  0x48, 0x28, 0xED, 0x57, 0x18, 0x22, 0xF3, 0x79, 0x71, 0x82, 0x2F, 0x37, 0x97, 0x2C, 0x72, 0x0E,
  0xB0, 0x57, 0x05, 0xA8, 0x1B, 0xFB, 0x78, 0x2A, 0xFC, 0x6A, 0x01, 0x50, 0x1A, 0x08, 0x01, 0xA0,
  0x65, 0x06, 0xA8, 0x33, 0x0C, 0xFC, 0x58, 0x1B, 0xFE, 0x20, 0x7A, 0x02, 0x30, 0x1A, 0x82, 0xB4,
  0x46, 0xA0, 0x73, 0x06, 0xF9, 0x0D, 0x30, 0xCF, 0xA8, 0x13, 0x02, 0xA0, 0xB4, 0x04, 0xA8, 0x18,
  0x07, 0xA0, 0x65, 0x83, 0xEF, 0xD0, 0xCA, 0x01, 0x50, 0xAA, 0x03,
  // "Æ" (U+00C6)
  0x50, 0x7F, 0xB0, 0x15, 0x0D, 0xFB, 0x01, 0x40, 0x5A, 0x04, 0x0A, 0xA0, 0x48, 0x00, 0x25, 0x83,
  0xCF, 0xB0, 0x9A, 0x01, 0x71, 0x03, 0xA8, 0x15, 0x09, 0xA0, 0x17, 0x18, 0x1A, 0xFE, 0x20, 0x9E,
  0x0B, 0x30, 0x2A, 0x09, 0x20, 0x9E, 0x0B, 0x30, 0x8A, 0x82, 0x52, 0x2A, 0xA8, 0x34, 0x22, 0x21,
  0x30, 0xEF, 0x90, 0x16, 0x07, 0xFA, 0x01, 0x68, 0x1D, 0xFD, 0x40, 0x9A, 0x85, 0x42, 0x22, 0x20,
  0x5A, 0x06, 0x40, 0x9F, 0x82, 0x1C, 0xFE, 0x50, 0x9F, 0x01,
  // "Ç" (U+00C7)
  0x38, 0x90, 0x7C, 0xEE, 0xC9, 0x30, 0x2D, 0xE8, 0x18, 0x0C, 0xA8, 0x59, 0x33, 0x6C, 0x25, 0xA0,
  0x96, 0x0A, 0xA0, 0x26, 0x0D, 0xA7, 0x81, 0xEF, 0xD7, 0x81, 0xDF, 0xE7, 0x0B, 0xA0, 0x16, 0x07,
  0xA0, 0x86, 0x01, 0x0E, 0xA8, 0x78, 0x33, 0x59, 0x40, 0x4E, 0xE0, 0x52, 0x81, 0x29, 0xDA, 0x81,
  0xD9, 0x24, 0x81, 0x8F, 0x87, 0x82, 0x5D, 0xF7, 0x58, 0x31, 0x29, 0xF9, 0x50, 0x5A, 0x0E, 0x03,
  0x58, 0x21, 0x44, 0x13,
  // "È" (U+00C8)
  0x83, 0x1D, 0xFE, 0x14, 0x82, 0x1C, 0xFB, 0x68, 0x19, 0xF8, 0x73, 0x05, 0xF0, 0x5F, 0x05, 0xA8,
  0x46, 0x22, 0x22, 0x5A, 0x05, 0x40, 0x5A, 0x05, 0x40, 0x5E, 0x0A, 0x05, 0xE0, 0xA0, 0x5A, 0x84,
  0x62, 0x22, 0x15, 0xA0, 0x54, 0x05, 0xA0, 0x54, 0x05, 0xA8, 0x46, 0x22, 0x22, 0x5F, 0x05, 0xF0,
  // "É" (U+00C9)
  0x40, 0x8A, 0x07, 0x30, 0x4A, 0x06, 0x38, 0x21, 0xEE, 0x37, 0x30, 0x5F, 0x05, 0xF0, 0x5A, 0x84,
  0x62, 0x22, 0x25, 0xA0, 0x54, 0x05, 0xA0, 0x54, 0x05, 0xE0, 0xA0, 0x5E, 0x0A, 0x05, 0xA8, 0x46,
  0x22, 0x21, 0x5A, 0x05, 0x40, 0x5A, 0x05, 0x40, 0x5A, 0x84, 0x62, 0x22, 0x25, 0xF0, 0x5F,
  // "Ê" (U+00CA)
  0x20, 0x5B, 0x07, 0x38, 0x23, 0xEF, 0x9A, 0x89, 0x13, 0x01, 0xDE, 0x40, 0x4D, 0xE2, 0x72, 0x05,
  0xF1, 0x05, 0xF1, 0x05, 0xA8, 0x56, 0x22, 0x22, 0x05, 0xA0, 0x55, 0x05, 0xA0, 0x55, 0x05, 0xE8,
  0x1A, 0x05, 0xE8, 0x1A, 0x05, 0xA8, 0x56, 0x22, 0x21, 0x05, 0xA0, 0x55, 0x05, 0xA0, 0x55, 0x05,
  0xA8, 0x56, 0x22, 0x22, 0x05, 0xF1, 0x05, 0xF1,
  // "Ë" (U+00CB)
  0x20, 0x13, 0x01, 0x28, 0x95, 0x6F, 0xB0, 0xDF, 0x50, 0x4E, 0x90, 0xBE, 0x47, 0x10, 0x5F, 0x05,
  0xF0, 0x5A, 0x84, 0x62, 0x22, 0x25, 0xA0, 0x54, 0x05, 0xA0, 0x54, 0x05, 0xE0, 0xA0, 0x5E, 0x0A,
  0x05, 0xA8, 0x46, 0x22, 0x21, 0x5A, 0x05, 0x40, 0x5A, 0x05, 0x40, 0x5A, 0x84, 0x62, 0x22, 0x25,
  0xF0, 0x5F,
  // "Ì" (U+00CC)
  0x83, 0x1D, 0xFE, 0x14, 0x82, 0x1C, 0xFB, 0x68, 0x19, 0xF8, 0x74, 0x06, 0xD8, 0x16, 0x05, 0xD0,
  0x52, 0x83, 0x2E, 0xFE, 0x24, 0x81, 0xDF, 0xD5, 0x81, 0xDF, 0xD5, 0x81, 0xDF, 0xD5, 0x81, 0xDF,
  0xD5, 0x81, 0xDF, 0xD5, 0x81, 0xDF, 0xD5, 0x81, 0xDF, 0xD5, 0x81, 0xDF, 0xD3, 0x04, 0x0E, 0xB8,
  0x2E, 0x40, 0x6D, 0x06,
  // "Í" (U+00CD)
  0x30, 0x8A, 0x07, 0x20, 0x4A, 0x06, 0x28, 0x21, 0xEE, 0x37, 0x20, 0x6D, 0x06, 0x05, 0xD8, 0x55,
  0x02, 0xEF, 0xE2, 0x38, 0x1D, 0xFD, 0x48, 0x1D, 0xFD, 0x48, 0x1D, 0xFD, 0x48, 0x1D, 0xFD, 0x48,
  0x1D, 0xFD, 0x48, 0x1D, 0xFD, 0x48, 0x1D, 0xFD, 0x48, 0x1D, 0xFD, 0x20, 0x40, 0xEB, 0x81, 0xE4,
  0x6D, 0x06,
  // "Î" (U+00CE)
  0x20, 0x5B, 0x07, 0x38, 0x23, 0xEF, 0x9A, 0x89, 0x13, 0x01, 0xDE, 0x40, 0x4D, 0xE2, 0x73, 0x06,
  0xD0, 0x62, 0x05, 0xD0, 0x53, 0x83, 0x2E, 0xFE, 0x25, 0x81, 0xDF, 0xD6, 0x81, 0xDF, 0xD6, 0x81,
  0xDF, 0xD6, 0x81, 0xDF, 0xD6, 0x81, 0xDF, 0xD6, 0x81, 0xDF, 0xD6, 0x81, 0xDF, 0xD6, 0x81, 0xDF,
  0xD4, 0x04, 0x0E, 0xB0, 0xE0, 0x42, 0x06, 0xD0, 0x61,
  // "Ï" (U+00CF)
  0x10, 0x13, 0x89, 0x61, 0x06, 0xFB, 0x0D, 0xF5, 0x4E, 0x90, 0xBE, 0x47, 0x06, 0xD0, 0x60, 0x5D,
  0x85, 0x50, 0x2E, 0xFE, 0x23, 0x81, 0xDF, 0xD4, 0x81, 0xDF, 0xD4, 0x81, 0xDF, 0xD4, 0x81, 0xDF,
  0xD4, 0x81, 0xDF, 0xD4, 0x81, 0xDF, 0xD4, 0x81, 0xDF, 0xD4, 0x81, 0xDF, 0xD2, 0x04, 0x0E, 0xB8,
  0x1E, 0x46, 0xD0, 0x60,
  // "Ð" (U+00D0)
  0x10, 0x5C, 0x82, 0xEC, 0x71, 0x40, 0x5F, 0x0E, 0x04, 0x30, 0x5A, 0x82, 0x62, 0x37, 0xA0, 0xE0,
  0x22, 0x05, 0xA0, 0x53, 0x04, 0xA0, 0xA2, 0x05, 0xA0, 0x54, 0x0C, 0xA8, 0x11, 0x17, 0xA8, 0x16,
  0x21, 0x20, 0x9A, 0x02, 0x09, 0xD0, 0x62, 0x08, 0xA0, 0x30, 0x9D, 0x06, 0x20, 0x9A, 0x81, 0x30,
  0x5A, 0x05, 0x40, 0xDA, 0x20, 0x5A, 0x05, 0x30, 0x5A, 0x0A, 0x20, 0x5A, 0x82, 0x62, 0x49, 0xA0,
  0xE0, 0x22, 0x05, 0xF0, 0xE0, 0x43, 0x05, 0xC8, 0x2E, 0xB7, 0x13,
  // "Ñ" (U+00D1)
  0x38, 0x53, 0xDE, 0x83, 0xAE, 0x50, 0xDD, 0x09, 0x48, 0x62, 0xF6, 0x4A, 0xEB, 0x17, 0x70, 0x5B,
  0x05, 0x40, 0x6A, 0x05, 0xB0, 0xD4, 0x06, 0xA0, 0x5C, 0x07, 0x30, 0x6A, 0x85, 0x5F, 0xED, 0xFE,
  0x12, 0x06, 0xA8, 0x25, 0xFE, 0x5A, 0x09, 0x20, 0x6A, 0x05, 0xA1, 0x0B, 0xA8, 0x13, 0x06, 0xA0,
  0x5A, 0x10, 0x3A, 0x81, 0xB0, 0x6A, 0x05, 0xA2, 0x09, 0xA0, 0x05, 0xA0, 0x5A, 0x28, 0x31, 0xEF,
  0xD5, 0xA0, 0x5A, 0x30, 0x7A, 0x0C, 0xA0, 0x5A, 0x40, 0xDC, 0x05, 0xA4, 0x04, 0xC0, 0x5A, 0x50,
  0xBB,
  // "Ò" (U+00D2)
  0x28, 0x31, 0xDF, 0xE1, 0x72, 0x82, 0x1C, 0xFB, 0x74, 0x81, 0x9F, 0x87, 0x76, 0x86, 0x17, 0xCE,
  0xED, 0x93, 0x40, 0x30, 0xEF, 0x06, 0x30, 0xDA, 0x83, 0x93, 0x26, 0xEA, 0x81, 0x40, 0x6A, 0x09,
  0x40, 0x4A, 0x81, 0xB0, 0xBA, 0x02, 0x50, 0xDA, 0x01, 0x0D, 0xA6, 0x0A, 0xA8, 0x22, 0xEF, 0xE6,
  0x09, 0xA0, 0x40, 0xDA, 0x60, 0xAA, 0x02, 0x0B, 0xA0, 0x35, 0x0D, 0xA0, 0x10, 0x6A, 0x09, 0x40,
  0x4A, 0x0B, 0x20, 0xDA, 0x83, 0x93, 0x26, 0xEA, 0x03, 0x20, 0x30, 0xDF, 0x06, 0x48, 0x61, 0x7C,
  0xEE, 0xD9, 0x33,
  // "Ó" (U+00D3)
  0x60, 0x8A, 0x07, 0x71, 0x04, 0xA0, 0x67, 0x18, 0x21, 0xEE, 0x37, 0x76, 0x86, 0x17, 0xCE, 0xED,
  0x93, 0x40, 0x30, 0xEF, 0x06, 0x30, 0xDA, 0x83, 0x93, 0x26, 0xEA, 0x81, 0x40, 0x6A, 0x09, 0x40,
  0x4A, 0x81, 0xB0, 0xBA, 0x02, 0x50, 0xDA, 0x01, 0x0D, 0xA6, 0x0A, 0xA8, 0x22, 0xEF, 0xE6, 0x09,
  0xA0, 0x40, 0xDA, 0x60, 0xAA, 0x02, 0x0B, 0xA0, 0x35, 0x0D, 0xA0, 0x10, 0x6A, 0x09, 0x40, 0x4A,
  0x0B, 0x20, 0xDA, 0x83, 0x93, 0x26, 0xEA, 0x03, 0x20, 0x30, 0xDF, 0x06, 0x48, 0x61, 0x7C, 0xEE,
  0xD9, 0x33,
  // "Ô" (U+00D4)
  0x40, 0x5B, 0x07, 0x78, 0x23, 0xEF, 0x9A, 0x03, 0x58, 0x71, 0xDE, 0x40, 0x4D, 0xE2, 0x77, 0x38,
  0x61, 0x7C, 0xEE, 0xD9, 0x34, 0x03, 0x0E, 0xF0, 0x63, 0x0D, 0xA8, 0x39, 0x32, 0x6E, 0xA8, 0x14,
  0x06, 0xA0, 0x94, 0x04, 0xA8, 0x1B, 0x0B, 0xA0, 0x25, 0x0D, 0xA0, 0x10, 0xDA, 0x60, 0xAA, 0x82,
  0x2E, 0xFE, 0x60, 0x9A, 0x04, 0x0D, 0xA6, 0x0A, 0xA0, 0x20, 0xBA, 0x03, 0x50, 0xDA, 0x01, 0x06,
  0xA0, 0x94, 0x04, 0xA0, 0xB2, 0x0D, 0xA8, 0x39, 0x32, 0x6E, 0xA0, 0x32, 0x03, 0x0D, 0xF0, 0x64,
  0x86, 0x17, 0xCE, 0xED, 0x93, 0x30,
  // "Õ" (U+00D5)
  0x38, 0x53, 0xDE, 0x83, 0xAE, 0x60, 0xDD, 0x09, 0x58, 0x62, 0xF6, 0x4A, 0xEB, 0x17, 0x74, 0x86,
  0x17, 0xCE, 0xED, 0x93, 0x40, 0x30, 0xEF, 0x06, 0x30, 0xDA, 0x83, 0x93, 0x26, 0xEA, 0x81, 0x40,
  0x6A, 0x09, 0x40, 0x4A, 0x81, 0xB0, 0xBA, 0x02, 0x50, 0xDA, 0x01, 0x0D, 0xA6, 0x0A, 0xA8, 0x22,
  0xEF, 0xE6, 0x09, 0xA0, 0x40, 0xDA, 0x60, 0xAA, 0x02, 0x0B, 0xA0, 0x35, 0x0D, 0xA0, 0x10, 0x6A,
  0x09, 0x40, 0x4A, 0x0B, 0x20, 0xDA, 0x83, 0x93, 0x26, 0xEA, 0x03, 0x20, 0x30, 0xDF, 0x06, 0x48,
  0x61, 0x7C, 0xEE, 0xD9, 0x33,
  // "Ö" (U+00D6)
  0x40, 0x13, 0x01, 0x78, 0x56, 0xFB, 0x0D, 0xF5, 0x68, 0x54, 0xE9, 0x0B, 0xE4, 0x77, 0x48, 0x61,
  0x7C, 0xEE, 0xD9, 0x34, 0x03, 0x0E, 0xF0, 0x63, 0x0D, 0xA8, 0x39, 0x32, 0x6E, 0xA8, 0x14, 0x06,
  0xA0, 0x94, 0x04, 0xA8, 0x1B, 0x0B, 0xA0, 0x25, 0x0D, 0xA0, 0x10, 0xDA, 0x60, 0xAA, 0x82, 0x2E,
  0xFE, 0x60, 0x9A, 0x04, 0x0D, 0xA6, 0x0A, 0xA0, 0x20, 0xBA, 0x03, 0x50, 0xDA, 0x01, 0x06, 0xA0,
  0x94, 0x04, 0xA0, 0xB2, 0x0D, 0xA8, 0x39, 0x32, 0x6E, 0xA0, 0x32, 0x03, 0x0D, 0xF0, 0x64, 0x86,
  0x17, 0xCE, 0xED, 0x93, 0x30,
  // "×" (U+00D7)
  0x10, 0x14, 0x83, 0x10, 0x5F, 0x52, 0x82, 0x2E, 0xA5, 0xA8, 0x55, 0x2E, 0xF9, 0x05, 0xA8, 0x1E,
  0xF9, 0x30, 0x7A, 0x0B, 0x30, 0x20, 0xEB, 0x85, 0x50, 0x2E, 0xF9, 0x6A, 0x82, 0x48, 0xF9, 0x28,
  0x35, 0xFC, 0x05, 0x40, 0x40, 0x10,
  // "Ø" (U+00D8)
  0x72, 0x01, 0x02, 0x48, 0x90, 0x17, 0xCE, 0xFD, 0x9B, 0xF1, 0x20, 0x30, 0xDF, 0x0B, 0x30, 0xDA,
  0x82, 0x93, 0x38, 0xB8, 0x14, 0x06, 0xA0, 0x93, 0x0C, 0xB8, 0x1C, 0x0B, 0xA0, 0x22, 0x82, 0x7F,
  0x8D, 0xA0, 0x10, 0xDA, 0x28, 0x32, 0xFD, 0x0A, 0xA8, 0x23, 0xEF, 0xE2, 0x83, 0xCF, 0x30, 0x9A,
  0x04, 0x0D, 0xA1, 0x81, 0x7F, 0x82, 0x0A, 0xA0, 0x20, 0xBA, 0x81, 0x5F, 0xD3, 0x0D, 0xA0, 0x10,
  0x7C, 0x03, 0x20, 0x4A, 0x82, 0xB0, 0x1E, 0xA8, 0x3D, 0x32, 0x6E, 0xA0, 0x32, 0x06, 0xF9, 0x06,
  0x38, 0x7B, 0xF9, 0xCE, 0xED, 0x93, 0x40, 0x10, 0x57, 0x30,
  // "Ù" (U+00D9)
  0x28, 0x31, 0xDF, 0xE1, 0x71, 0x82, 0x1C, 0xFB, 0x73, 0x81, 0x9F, 0x87, 0x72, 0x07, 0xA0, 0x34,
  0x09, 0xA0, 0x10, 0x7A, 0x03, 0x40, 0x9A, 0x01, 0x07, 0xA0, 0x34, 0x09, 0xA0, 0x10, 0x7A, 0x03,
  0x40, 0x9A, 0x01, 0x07, 0xA0, 0x34, 0x09, 0xA0, 0x10, 0x7A, 0x03, 0x40, 0x9A, 0x01, 0x07, 0xA0,
  0x34, 0x09, 0xA0, 0x10, 0x7A, 0x03, 0x40, 0x9A, 0x01, 0x06, 0xA0, 0x54, 0x0B, 0xA1, 0x04, 0xA0,
  0x94, 0x81, 0xEF, 0xE2, 0x0E, 0xA8, 0x29, 0x55, 0xCA, 0x08, 0x20, 0x4F, 0x0C, 0x48, 0x53, 0xAD,
  0xFE, 0xC7, 0x30,
  // "Ú" (U+00DA)
  0x50, 0x8A, 0x07, 0x70, 0x4A, 0x06, 0x78, 0x21, 0xEE, 0x37, 0x73, 0x07, 0xA0, 0x34, 0x09, 0xA0,
  0x10, 0x7A, 0x03, 0x40, 0x9A, 0x01, 0x07, 0xA0, 0x34, 0x09, 0xA0, 0x10, 0x7A, 0x03, 0x40, 0x9A,
  0x01, 0x07, 0xA0, 0x34, 0x09, 0xA0, 0x10, 0x7A, 0x03, 0x40, 0x9A, 0x01, 0x07, 0xA0, 0x34, 0x09,
  0xA0, 0x10, 0x7A, 0x03, 0x40, 0x9A, 0x01, 0x06, 0xA0, 0x54, 0x0B, 0xA1, 0x04, 0xA0, 0x94, 0x81,
  0xEF, 0xE2, 0x0E, 0xA8, 0x29, 0x55, 0xCA, 0x08, 0x20, 0x4F, 0x0C, 0x48, 0x53, 0xAD, 0xFE, 0xC7,
  0x30,
  // "Û" (U+00DB)
  0x30, 0x5B, 0x07, 0x68, 0x23, 0xEF, 0x9A, 0x03, 0x48, 0x71, 0xDE, 0x40, 0x4D, 0xE2, 0x77, 0x07,
  0xA0, 0x34, 0x09, 0xA0, 0x10, 0x7A, 0x03, 0x40, 0x9A, 0x01, 0x07, 0xA0, 0x34, 0x09, 0xA0, 0x10,
  0x7A, 0x03, 0x40, 0x9A, 0x01, 0x07, 0xA0, 0x34, 0x09, 0xA0, 0x10, 0x7A, 0x03, 0x40, 0x9A, 0x01,
  0x07, 0xA0, 0x34, 0x09, 0xA0, 0x10, 0x7A, 0x03, 0x40, 0x9A, 0x01, 0x06, 0xA0, 0x54, 0x0B, 0xA1,
  0x04, 0xA0, 0x94, 0x81, 0xEF, 0xE2, 0x0E, 0xA8, 0x29, 0x55, 0xCA, 0x08, 0x20, 0x4F, 0x0C, 0x48,
  0x53, 0xAD, 0xFE, 0xC7, 0x30,
  // "Ü" (U+00DC)
  0x30, 0x13, 0x01, 0x68, 0x56, 0xFB, 0x0D, 0xF5, 0x58, 0x54, 0xE9, 0x0B, 0xE4, 0x77, 0x10, 0x7A,
  0x03, 0x40, 0x9A, 0x01, 0x07, 0xA0, 0x34, 0x09, 0xA0, 0x10, 0x7A, 0x03, 0x40, 0x9A, 0x01, 0x07,
  0xA0, 0x34, 0x09, 0xA0, 0x10, 0x7A, 0x03, 0x40, 0x9A, 0x01, 0x07, 0xA0, 0x34, 0x09, 0xA0, 0x10,
  0x7A, 0x03, 0x40, 0x9A, 0x01, 0x07, 0xA0, 0x34, 0x09, 0xA0, 0x10, 0x6A, 0x05, 0x40, 0xBA, 0x10,
  0x4A, 0x09, 0x48, 0x1E, 0xFE, 0x20, 0xEA, 0x82, 0x95, 0x5C, 0xA0, 0x82, 0x04, 0xF0, 0xC4, 0x85,
  0x3A, 0xDF, 0xEC, 0x73,
  // "Ý" (U+00DD)
  0x50, 0x8A, 0x07, 0x60, 0x4A, 0x06, 0x68, 0x21, 0xEE, 0x37, 0x71, 0x0B, 0xA0, 0x34, 0x82, 0xEF,
  0xE3, 0xA0, 0xA3, 0x07, 0xA8, 0x16, 0x0A, 0xA0, 0x32, 0x81, 0xEF, 0xD2, 0x02, 0xA8, 0x1B, 0x07,
  0xA0, 0x53, 0x09, 0xA8, 0x24, 0xEF, 0xC4, 0x01, 0xA0, 0xEA, 0x04, 0x50, 0x8B, 0x0B, 0x60, 0x10,
  0xEA, 0x03, 0x70, 0xBA, 0x71, 0x0B, 0xA7, 0x10, 0xBA, 0x71, 0x0B, 0xA7, 0x10, 0xBA, 0x40,
  // "Þ" (U+00DE)
  0x05, 0xA0, 0x56, 0x05, 0xA0, 0x56, 0x05, 0xC8, 0x1E, 0xC7, 0x20, 0x5F, 0x81, 0xA0, 0x5A, 0x82,
  0x62, 0x5D, 0xA0, 0x30, 0x5A, 0x05, 0x20, 0x5A, 0x07, 0x05, 0xA0, 0x52, 0x05, 0xA0, 0x60, 0x5A,
  0x82, 0x50, 0x3C, 0xA0, 0x30, 0x5F, 0x81, 0xB0, 0x5D, 0x0E, 0x08, 0x20, 0x5A, 0x81, 0x62, 0x14,
  0x05, 0xA0, 0x56, 0x05, 0xA0, 0x56,
  // "ß" (U+00DF)
  0x28, 0x56, 0xBE, 0xFD, 0xA4, 0x40, 0xBF, 0x07, 0x20, 0x5A, 0x82, 0xC4, 0x37, 0xA0, 0xE2, 0x08,
  0xA0, 0x23, 0x81, 0xDF, 0xD2, 0x09, 0xA0, 0x12, 0x07, 0xA0, 0x52, 0x09, 0xA8, 0x11, 0x09, 0xA0,
  0x53, 0x09, 0xA0, 0x01, 0xA0, 0x84, 0x09, 0xA8, 0x11, 0x1E, 0xA0, 0x73, 0x09, 0xA8, 0x21, 0x04,
  0xDA, 0x82, 0xC1, 0x09, 0xA0, 0x13, 0x09, 0xA8, 0x1C, 0x09, 0xA0, 0x14, 0x0A, 0xA0, 0x10, 0x9A,
  0x84, 0x16, 0x63, 0x3D, 0xA0, 0x10, 0x9A, 0x01, 0x08, 0xD8, 0x1B, 0x09, 0xA8, 0x51, 0x4C, 0xEE,
  0xD8, 0x20,
  // "à" (U+00E0)
  0x18, 0x31, 0xDF, 0xE1, 0x68, 0x21, 0xCF, 0xB7, 0x18, 0x19, 0xF8, 0x77, 0x18, 0x55, 0xBE, 0xFD,
  0x92, 0x20, 0x1E, 0x0E, 0x01, 0x28, 0x37, 0x74, 0x39, 0xA0, 0x66, 0x02, 0xA8, 0x37, 0x01, 0x8D,
  0xD8, 0x18, 0x0D, 0xF0, 0x80, 0x3A, 0x82, 0xD4, 0x24, 0xA0, 0x80, 0x2A, 0x82, 0xB3, 0x3A, 0xA8,
  0x18, 0x0D, 0xC8, 0x94, 0xDD, 0xF8, 0x02, 0xBE, 0xEA, 0x17, 0xF8,
  // "á" (U+00E1)
  0x50, 0x8A, 0x07, 0x50, 0x4A, 0x06, 0x58, 0x21, 0xEE, 0x37, 0x71, 0x85, 0x5B, 0xEF, 0xD9, 0x22,
  0x01, 0xE0, 0xE0, 0x12, 0x83, 0x77, 0x43, 0x9A, 0x06, 0x60, 0x2A, 0x83, 0x70, 0x18, 0xDD, 0x81,
  0x80, 0xDF, 0x08, 0x03, 0xA8, 0x2D, 0x42, 0x4A, 0x08, 0x02, 0xA8, 0x2B, 0x33, 0xAA, 0x81, 0x80,
  0xDC, 0x89, 0x4D, 0xDF, 0x80, 0x2B, 0xEE, 0xA1, 0x7F, 0x80,
  // "â" (U+00E2)
  0x30, 0x5B, 0x07, 0x48, 0x23, 0xEF, 0x9A, 0x03, 0x28, 0x71, 0xDE, 0x40, 0x4D, 0xE2, 0x75, 0x85,
  0x5B, 0xEF, 0xD9, 0x22, 0x01, 0xE0, 0xE0, 0x12, 0x83, 0x77, 0x43, 0x9A, 0x06, 0x60, 0x2A, 0x83,
  0x70, 0x18, 0xDD, 0x81, 0x80, 0xDF, 0x08, 0x03, 0xA8, 0x2D, 0x42, 0x4A, 0x08, 0x02, 0xA8, 0x2B,
  0x33, 0xAA, 0x81, 0x80, 0xDC, 0x89, 0x4D, 0xDF, 0x80, 0x2B, 0xEE, 0xA1, 0x7F, 0x80,
  // "ã" (U+00E3)
  0x28, 0x53, 0xDE, 0x83, 0xAE, 0x30, 0xDD, 0x09, 0x28, 0x62, 0xF6, 0x4A, 0xEB, 0x17, 0x68, 0x55,
  0xBE, 0xFD, 0x92, 0x20, 0x1E, 0x0E, 0x01, 0x28, 0x37, 0x74, 0x39, 0xA0, 0x66, 0x02, 0xA8, 0x37,
  0x01, 0x8D, 0xD8, 0x18, 0x0D, 0xF0, 0x80, 0x3A, 0x82, 0xD4, 0x24, 0xA0, 0x80, 0x2A, 0x82, 0xB3,
  0x3A, 0xA8, 0x18, 0x0D, 0xC8, 0x94, 0xDD, 0xF8, 0x02, 0xBE, 0xEA, 0x17, 0xF8,
  // "ä" (U+00E4)
  0x30, 0x13, 0x01, 0x48, 0x56, 0xFB, 0x0D, 0xF5, 0x38, 0x54, 0xE9, 0x0B, 0xE4, 0x76, 0x85, 0x5B,
  0xEF, 0xD9, 0x22, 0x01, 0xE0, 0xE0, 0x12, 0x83, 0x77, 0x43, 0x9A, 0x06, 0x60, 0x2A, 0x83, 0x70,
  0x18, 0xDD, 0x81, 0x80, 0xDF, 0x08, 0x03, 0xA8, 0x2D, 0x42, 0x4A, 0x08, 0x02, 0xA8, 0x2B, 0x33,
  0xAA, 0x81, 0x80, 0xDC, 0x89, 0x4D, 0xDF, 0x80, 0x2B, 0xEE, 0xA1, 0x7F, 0x80,
  // "å" (U+00E5)
  0x48, 0x28, 0xED, 0x55, 0x82, 0x2F, 0x37, 0x95, 0x82, 0x2F, 0x37, 0x96, 0x82, 0x8E, 0xD5, 0x77,
  0x85, 0x5B, 0xEF, 0xD9, 0x22, 0x01, 0xE0, 0xE0, 0x12, 0x83, 0x77, 0x43, 0x9A, 0x06, 0x60, 0x2A,
  0x83, 0x70, 0x18, 0xDD, 0x81, 0x80, 0xDF, 0x08, 0x03, 0xA8, 0x2D, 0x42, 0x4A, 0x08, 0x02, 0xA8,
  0x2B, 0x33, 0xAA, 0x81, 0x80, 0xDC, 0x89, 0x4D, 0xDF, 0x80, 0x2B, 0xEE, 0xA1, 0x7F, 0x80,
  // "æ" (U+00E6)
  0x28, 0x92, 0x5B, 0xDF, 0xD7, 0x08, 0xDF, 0xD8, 0x30, 0x1E, 0x0E, 0xD0, 0xB3, 0x83, 0x76, 0x33,
  0xAA, 0x82, 0xE5, 0x37, 0xA0, 0x54, 0x81, 0x22, 0x6A, 0x89, 0x09, 0x22, 0x2D, 0xF9, 0x02, 0xBF,
  0xD8, 0x1B, 0x0D, 0xFE, 0x0B, 0x03, 0xA8, 0x2C, 0x20, 0x5A, 0x07, 0x60, 0x2A, 0x82, 0xB3, 0x4C,
  0xA8, 0x7E, 0x63, 0x35, 0x81, 0x0D, 0xD0, 0x70, 0xBE, 0x86, 0x20, 0x2B, 0xEF, 0xC4, 0x20, 0x70,
  0xDA, 0x0D, 0x08, 0x10,
  // "ç" (U+00E7)
  0x28, 0x90, 0x19, 0xDF, 0xDB, 0x40, 0x2E, 0xD8, 0x15, 0x0A, 0xA8, 0x28, 0x34, 0x92, 0xA0, 0xC5,
  0x02, 0xA0, 0x95, 0x02, 0xA0, 0x96, 0xA0, 0xC6, 0x0C, 0xA8, 0x58, 0x34, 0x85, 0x03, 0xE0, 0x62,
  0x03, 0x0A, 0xB0, 0xA0, 0x24, 0x81, 0x8F, 0x86, 0x82, 0x5D, 0xF7, 0x48, 0x31, 0x29, 0xF9, 0x40,
  0x5A, 0x0E, 0x03, 0x48, 0x21, 0x44, 0x12,
  // "è" (U+00E8)
  0x18, 0x31, 0xDF, 0xE1, 0x68, 0x21, 0xCF, 0xB7, 0x18, 0x19, 0xF8, 0x77, 0x18, 0x51, 0x9D, 0xFD,
  0x81, 0x20, 0x20, 0xED, 0x0C, 0x20, 0xAA, 0x81, 0x63, 0x6A, 0x07, 0x1A, 0x86, 0xB2, 0x22, 0xCF,
  0xB2, 0xF9, 0x0D, 0x02, 0xF9, 0x0D, 0x1A, 0x0A, 0x70, 0xAA, 0x87, 0x73, 0x34, 0x83, 0x01, 0xDE,
  0x04, 0x28, 0x11, 0x8D, 0xA8, 0x1D, 0x81,
  // "é" (U+00E9)
  0x50, 0x8A, 0x07, 0x50, 0x4A, 0x06, 0x58, 0x21, 0xEE, 0x37, 0x71, 0x85, 0x19, 0xDF, 0xD8, 0x12,
  0x02, 0x0E, 0xD0, 0xC2, 0x0A, 0xA8, 0x16, 0x36, 0xA0, 0x71, 0xA8, 0x6B, 0x22, 0x2C, 0xFB, 0x2F,
  0x90, 0xD0, 0x2F, 0x90, 0xD1, 0xA0, 0xA7, 0x0A, 0xA8, 0x77, 0x33, 0x48, 0x30, 0x1D, 0xE0, 0x42,
  0x81, 0x18, 0xDA, 0x81, 0xD8, 0x10,
  // "ê" (U+00EA)
  0x30, 0x5B, 0x07, 0x48, 0x23, 0xEF, 0x9A, 0x03, 0x28, 0x71, 0xDE, 0x40, 0x4D, 0xE2, 0x75, 0x85,
  0x19, 0xDF, 0xD8, 0x12, 0x02, 0x0E, 0xD0, 0xC2, 0x0A, 0xA8, 0x16, 0x36, 0xA0, 0x71, 0xA8, 0x6B,
  0x22, 0x2C, 0xFB, 0x2F, 0x90, 0xD0, 0x2F, 0x90, 0xD1, 0xA0, 0xA7, 0x0A, 0xA8, 0x77, 0x33, 0x48,
  0x30, 0x1D, 0xE0, 0x42, 0x81, 0x18, 0xDA, 0x81, 0xD8, 0x10,
  // "ë" (U+00EB)
  0x30, 0x13, 0x01, 0x48, 0x56, 0xFB, 0x0D, 0xF5, 0x38, 0x54, 0xE9, 0x0B, 0xE4, 0x76, 0x85, 0x19,
  0xDF, 0xD8, 0x12, 0x02, 0x0E, 0xD0, 0xC2, 0x0A, 0xA8, 0x16, 0x36, 0xA0, 0x71, 0xA8, 0x6B, 0x22,
  0x2C, 0xFB, 0x2F, 0x90, 0xD0, 0x2F, 0x90, 0xD1, 0xA0, 0xA7, 0x0A, 0xA8, 0x77, 0x33, 0x48, 0x30,
  0x1D, 0xE0, 0x42, 0x81, 0x18, 0xDA, 0x81, 0xD8, 0x10,
  // "ì" (U+00EC)
  0x83, 0x1D, 0xFE, 0x12, 0x82, 0x1C, 0xFB, 0x48, 0x19, 0xF8, 0x71, 0x09, 0xA0, 0x12, 0x09, 0xA0,
  0x12, 0x09, 0xA0, 0x12, 0x09, 0xA0, 0x12, 0x09, 0xA0, 0x12, 0x09, 0xA0, 0x12, 0x09, 0xA0, 0x12,
  0x09, 0xA0, 0x12, 0x09, 0xA0, 0x12, 0x09, 0xA0, 0x10,
  // "í" (U+00ED)
  0x20, 0x8A, 0x81, 0x70, 0x4A, 0x84, 0x60, 0x1E, 0xE3, 0x72, 0x09, 0xA0, 0x12, 0x09, 0xA0, 0x12,
  0x09, 0xA0, 0x12, 0x09, 0xA0, 0x12, 0x09, 0xA0, 0x12, 0x09, 0xA0, 0x12, 0x09, 0xA0, 0x12, 0x09,
  0xA0, 0x12, 0x09, 0xA0, 0x12, 0x09, 0xA0, 0x11,
  // "î" (U+00EE)
  0x20, 0x5B, 0x07, 0x38, 0x23, 0xEF, 0x9A, 0x89, 0x13, 0x01, 0xDE, 0x40, 0x4D, 0xE2, 0x75, 0x09,
  0xA0, 0x15, 0x09, 0xA0, 0x15, 0x09, 0xA0, 0x15, 0x09, 0xA0, 0x15, 0x09, 0xA0, 0x15, 0x09, 0xA0,
  0x15, 0x09, 0xA0, 0x15, 0x09, 0xA0, 0x15, 0x09, 0xA0, 0x15, 0x09, 0xA0, 0x12,
  // "ï" (U+00EF)
  0x10, 0x13, 0x89, 0x61, 0x06, 0xFB, 0x0D, 0xF5, 0x4E, 0x90, 0xBE, 0x47, 0x20, 0x9A, 0x01, 0x30,
  0x9A, 0x01, 0x30, 0x9A, 0x01, 0x30, 0x9A, 0x01, 0x30, 0x9A, 0x01, 0x30, 0x9A, 0x01, 0x30, 0x9A,
  0x01, 0x30, 0x9A, 0x01, 0x30, 0x9A, 0x01, 0x30, 0x9A, 0x01, 0x10,
  // "ð" (U+00F0)
  0x38, 0x44, 0xC3, 0x08, 0x95, 0x09, 0xA8, 0x1E, 0xFB, 0x50, 0x10, 0xDA, 0x0E, 0x68, 0x4C, 0xF9,
  0xEF, 0xB5, 0x82, 0x33, 0x04, 0xA0, 0x53, 0x86, 0x3B, 0xEF, 0xBC, 0xFC, 0x20, 0x4F, 0x98, 0x11,
  0x0C, 0xA8, 0x26, 0x35, 0xEA, 0x03, 0x01, 0xA0, 0xA3, 0x08, 0xA0, 0x40, 0x2A, 0x08, 0x30, 0x6A,
  0x04, 0x01, 0xA0, 0xB3, 0x09, 0xA8, 0x11, 0x0B, 0xA8, 0x17, 0x36, 0xA0, 0xB2, 0x02, 0x0E, 0xD0,
  0xE0, 0x23, 0x85, 0x29, 0xDF, 0xE9, 0x22,
  // "ñ" (U+00F1)
  0x28, 0x53, 0xDE, 0x83, 0xAE, 0x30, 0xDD, 0x09, 0x28, 0x62, 0xF6, 0x4A, 0xEB, 0x17, 0x48, 0x94,
  0x9F, 0x83, 0xBE, 0xEA, 0x20, 0x9F, 0xDE, 0xC8, 0x1E, 0x19, 0xA8, 0x2D, 0x43, 0xCA, 0x05, 0x09,
  0xA0, 0x52, 0x04, 0xA0, 0x70, 0x9A, 0x02, 0x20, 0x3A, 0x07, 0x09, 0xA0, 0x12, 0x03, 0xA0, 0x70,
  0x9A, 0x01, 0x20, 0x3A, 0x07, 0x09, 0xA0, 0x12, 0x03, 0xA0, 0x70, 0x9A, 0x01, 0x20, 0x3A, 0x07,
  0x09, 0xA0, 0x12, 0x03, 0xA0, 0x70,
  // "ò" (U+00F2)
  0x18, 0x31, 0xDF, 0xE1, 0x78, 0x21, 0xCF, 0xB7, 0x28, 0x19, 0xF8, 0x77, 0x38, 0x51, 0x9D, 0xFD,
  0x92, 0x30, 0x20, 0xED, 0x0E, 0x02, 0x20, 0xAA, 0x81, 0x73, 0x6A, 0x0C, 0x2A, 0x0B, 0x30, 0x9A,
  0x00, 0x2A, 0x09, 0x30, 0x7A, 0x04, 0x02, 0xA0, 0x93, 0x07, 0xA0, 0x41, 0xA0, 0xC3, 0x0A, 0xA8,
  0x12, 0x09, 0xA8, 0x17, 0x36, 0xA0, 0xC2, 0x01, 0x0D, 0xD0, 0xE0, 0x33, 0x85, 0x18, 0xDF, 0xEA,
  0x22,
  // "ó" (U+00F3)
  0x50, 0x8A, 0x07, 0x60, 0x4A, 0x06, 0x68, 0x21, 0xEE, 0x37, 0x73, 0x85, 0x19, 0xDF, 0xD9, 0x23,
  0x02, 0x0E, 0xD0, 0xE0, 0x22, 0x0A, 0xA8, 0x17, 0x36, 0xA0, 0xC2, 0xA0, 0xB3, 0x09, 0xA0, 0x02,
  0xA0, 0x93, 0x07, 0xA0, 0x40, 0x2A, 0x09, 0x30, 0x7A, 0x04, 0x1A, 0x0C, 0x30, 0xAA, 0x81, 0x20,
  0x9A, 0x81, 0x73, 0x6A, 0x0C, 0x20, 0x10, 0xDD, 0x0E, 0x03, 0x38, 0x51, 0x8D, 0xFE, 0xA2, 0x20,
  // "ô" (U+00F4)
  0x30, 0x5B, 0x07, 0x58, 0x23, 0xEF, 0x9A, 0x03, 0x38, 0x71, 0xDE, 0x40, 0x4D, 0xE2, 0x77, 0x85,
  0x19, 0xDF, 0xD9, 0x23, 0x02, 0x0E, 0xD0, 0xE0, 0x22, 0x0A, 0xA8, 0x17, 0x36, 0xA0, 0xC2, 0xA0,
  0xB3, 0x09, 0xA0, 0x02, 0xA0, 0x93, 0x07, 0xA0, 0x40, 0x2A, 0x09, 0x30, 0x7A, 0x04, 0x1A, 0x0C,
  0x30, 0xAA, 0x81, 0x20, 0x9A, 0x81, 0x73, 0x6A, 0x0C, 0x20, 0x10, 0xDD, 0x0E, 0x03, 0x38, 0x51,
  0x8D, 0xFE, 0xA2, 0x20,
  // "õ" (U+00F5)
  0x28, 0x53, 0xDE, 0x83, 0xAE, 0x40, 0xDD, 0x09, 0x38, 0x62, 0xF6, 0x4A, 0xEB, 0x17, 0x71, 0x85,
  0x19, 0xDF, 0xD9, 0x23, 0x02, 0x0E, 0xD0, 0xE0, 0x22, 0x0A, 0xA8, 0x17, 0x36, 0xA0, 0xC2, 0xA0,
  0xB3, 0x09, 0xA0, 0x02, 0xA0, 0x93, 0x07, 0xA0, 0x40, 0x2A, 0x09, 0x30, 0x7A, 0x04, 0x1A, 0x0C,
  0x30, 0xAA, 0x81, 0x20, 0x9A, 0x81, 0x73, 0x6A, 0x0C, 0x20, 0x10, 0xDD, 0x0E, 0x03, 0x38, 0x51,
  0x8D, 0xFE, 0xA2, 0x20,
  // "ö" (U+00F6)
  0x30, 0x13, 0x01, 0x58, 0x56, 0xFB, 0x0D, 0xF5, 0x48, 0x54, 0xE9, 0x0B, 0xE4, 0x77, 0x18, 0x51,
  0x9D, 0xFD, 0x92, 0x30, 0x20, 0xED, 0x0E, 0x02, 0x20, 0xAA, 0x81, 0x73, 0x6A, 0x0C, 0x2A, 0x0B,
  0x30, 0x9A, 0x00, 0x2A, 0x09, 0x30, 0x7A, 0x04, 0x02, 0xA0, 0x93, 0x07, 0xA0, 0x41, 0xA0, 0xC3,
  0x0A, 0xA8, 0x12, 0x09, 0xA8, 0x17, 0x36, 0xA0, 0xC2, 0x01, 0x0D, 0xD0, 0xE0, 0x33, 0x85, 0x18,
  0xDF, 0xEA, 0x22,
  // "÷" (U+00F7)
  0x48, 0x1E, 0xF3, 0x78, 0x1C, 0xD2, 0x48, 0x04, 0x20, 0x10, 0x3F, 0x90, 0x70, 0x3F, 0x90, 0x77,
  0x78, 0x1E, 0xF3, 0x78, 0x1C, 0xD2, 0x30,
  // "ø" (U+00F8)
  0x71, 0x01, 0x48, 0x61, 0x9D, 0xFD, 0xAE, 0x42, 0x02, 0x0E, 0xE0, 0x42, 0x0A, 0xA8, 0x17, 0x3C,
  0xA0, 0xC2, 0xA8, 0x1C, 0x04, 0xC0, 0x02, 0xA8, 0x39, 0x1E, 0xE8, 0xA0, 0x40, 0x2A, 0x83, 0x8A,
  0xF4, 0x7A, 0x04, 0x1A, 0x83, 0xEF, 0x90, 0xAA, 0x81, 0x20, 0xAA, 0x81, 0xE3, 0x6A, 0x0C, 0x20,
  0x1E, 0x0E, 0x03, 0x28, 0x63, 0xFC, 0xDF, 0xEA, 0x24, 0x03, 0x71,
  // "ù" (U+00F9)
  0x18, 0x31, 0xDF, 0xE1, 0x68, 0x21, 0xCF, 0xB7, 0x18, 0x19, 0xF8, 0x76, 0x0A, 0xA3, 0x04, 0xA0,
  0x60, 0xAA, 0x30, 0x4A, 0x06, 0x0A, 0xA3, 0x04, 0xA0, 0x60, 0xAA, 0x30, 0x4A, 0x06, 0x0A, 0xA3,
  0x04, 0xA0, 0x60, 0xAA, 0x30, 0x5A, 0x06, 0x0A, 0xA0, 0x12, 0x07, 0xA0, 0x60, 0x8A, 0x82, 0x80,
  0x3D, 0xA0, 0x60, 0x3D, 0x0E, 0xA8, 0x91, 0x60, 0x4B, 0xEE, 0xA2, 0xBF, 0x60,
  // "ú" (U+00FA)
  0x50, 0x8A, 0x07, 0x50, 0x4A, 0x06, 0x58, 0x21, 0xEE, 0x37, 0x60, 0xAA, 0x30, 0x4A, 0x06, 0x0A,
  0xA3, 0x04, 0xA0, 0x60, 0xAA, 0x30, 0x4A, 0x06, 0x0A, 0xA3, 0x04, 0xA0, 0x60, 0xAA, 0x30, 0x4A,
  0x06, 0x0A, 0xA3, 0x05, 0xA0, 0x60, 0xAA, 0x01, 0x20, 0x7A, 0x06, 0x08, 0xA8, 0x28, 0x03, 0xDA,
  0x06, 0x03, 0xD0, 0xEA, 0x89, 0x16, 0x04, 0xBE, 0xEA, 0x2B, 0xF6,
  // "û" (U+00FB)
  0x20, 0x5B, 0x07, 0x48, 0x23, 0xEF, 0x9A, 0x03, 0x28, 0x71, 0xDE, 0x40, 0x4D, 0xE2, 0x74, 0x0A,
  0xA3, 0x04, 0xA0, 0x60, 0xAA, 0x30, 0x4A, 0x06, 0x0A, 0xA3, 0x04, 0xA0, 0x60, 0xAA, 0x30, 0x4A,
  0x06, 0x0A, 0xA3, 0x04, 0xA0, 0x60, 0xAA, 0x30, 0x5A, 0x06, 0x0A, 0xA0, 0x12, 0x07, 0xA0, 0x60,
  0x8A, 0x82, 0x80, 0x3D, 0xA0, 0x60, 0x3D, 0x0E, 0xA8, 0x91, 0x60, 0x4B, 0xEE, 0xA2, 0xBF, 0x60,
  // "ü" (U+00FC)
  0x20, 0x13, 0x01, 0x48, 0x56, 0xFB, 0x0D, 0xF5, 0x38, 0x54, 0xE9, 0x0B, 0xE4, 0x75, 0x0A, 0xA3,
  0x04, 0xA0, 0x60, 0xAA, 0x30, 0x4A, 0x06, 0x0A, 0xA3, 0x04, 0xA0, 0x60, 0xAA, 0x30, 0x4A, 0x06,
  0x0A, 0xA3, 0x04, 0xA0, 0x60, 0xAA, 0x30, 0x5A, 0x06, 0x0A, 0xA0, 0x12, 0x07, 0xA0, 0x60, 0x8A,
  0x82, 0x80, 0x3D, 0xA0, 0x60, 0x3D, 0x0E, 0xA8, 0x91, 0x60, 0x4B, 0xEE, 0xA2, 0xBF, 0x60,
  // "ý" (U+00FD)
  0x50, 0x8A, 0x07, 0x60, 0x4A, 0x06, 0x68, 0x21, 0xEE, 0x37, 0x71, 0x0C, 0xA0, 0x13, 0x0C, 0xA0,
  0x10, 0x6A, 0x06, 0x20, 0x2A, 0x0A, 0x28, 0x1E, 0xFC, 0x20, 0x7A, 0x04, 0x20, 0x9A, 0x83, 0x10,
  0xCF, 0xD3, 0x02, 0xA0, 0x70, 0x2A, 0x08, 0x48, 0x2C, 0xFC, 0x7A, 0x02, 0x40, 0x5A, 0x81, 0xBF,
  0xB6, 0x0E, 0xB0, 0x66, 0x08, 0xA0, 0xE7, 0x03, 0xA0, 0x97, 0x06, 0xA0, 0x34, 0x84, 0x12, 0x5E,
  0xFC, 0x50, 0x6B, 0x0E, 0x03, 0x58, 0x35, 0xFE, 0xA3, 0x60,
  // "þ" (U+00FE)
  0x09, 0xA0, 0x16, 0x09, 0xA0, 0x16, 0x09, 0xA0, 0x16, 0x09, 0xA0, 0x16, 0x09, 0xA8, 0x32, 0xBE,
  0xE9, 0x20, 0x9A, 0x0D, 0xC8, 0x1A, 0x09, 0xA8, 0x2C, 0x34, 0xDA, 0x03, 0x09, 0xA0, 0x42, 0x05,
  0xA0, 0x60, 0x9A, 0x01, 0x20, 0x3A, 0x08, 0x09, 0xA0, 0x22, 0x03, 0xA0, 0x80, 0x9A, 0x04, 0x20,
  0x5A, 0x06, 0x09, 0xA8, 0x2C, 0x44, 0xDA, 0x02, 0x09, 0xF8, 0x1A, 0x09, 0xA8, 0x34, 0xBF, 0xE8,
  0x20, 0x9A, 0x01, 0x60, 0x9A, 0x01, 0x60, 0x9A, 0x01, 0x60, 0x9A, 0x01, 0x60,
  // "ÿ" (U+00FF)
  0x30, 0x13, 0x01, 0x58, 0x56, 0xFB, 0x0D, 0xF5, 0x48, 0x54, 0xE9, 0x0B, 0xE4, 0x76, 0x0C, 0xA0,
  0x13, 0x0C, 0xA0, 0x10, 0x6A, 0x06, 0x20, 0x2A, 0x0A, 0x28, 0x1E, 0xFC, 0x20, 0x7A, 0x04, 0x20,
  0x9A, 0x83, 0x10, 0xCF, 0xD3, 0x02, 0xA0, 0x70, 0x2A, 0x08, 0x48, 0x2C, 0xFC, 0x7A, 0x02, 0x40,
  0x5A, 0x81, 0xBF, 0xB6, 0x0E, 0xB0, 0x66, 0x08, 0xA0, 0xE7, 0x03, 0xA0, 0x97, 0x06, 0xA0, 0x34,
  0x84, 0x12, 0x5E, 0xFC, 0x50, 0x6B, 0x0E, 0x03, 0x58, 0x35, 0xFE, 0xA3, 0x60,
  // "Ā" (U+0100)
  0x48, 0x01, 0x20, 0x16, 0x04, 0xD0, 0xA6, 0x04, 0xD0, 0xA7, 0x76, 0x0A, 0xB7, 0x20, 0xEB, 0x05,
  0x70, 0x5A, 0x81, 0xBF, 0xB7, 0x82, 0xAF, 0xC6, 0xA0, 0x15, 0x01, 0xA0, 0x80, 0x1A, 0x06, 0x50,
  0x6A, 0x83, 0x30, 0xCF, 0xC5, 0x81, 0xBF, 0xE2, 0x07, 0xA0, 0x23, 0x01, 0xA8, 0x2B, 0x44, 0x6A,
  0x07, 0x30, 0x6F, 0x90, 0xD3, 0x0C, 0xFA, 0x81, 0x30, 0x2A, 0x0B, 0x40, 0x4A, 0x81, 0x80, 0x7A,
  0x06, 0x58, 0x3E, 0xFD, 0x0C, 0xA0, 0x15, 0x0A, 0xA0, 0x30,
  // "ā" (U+0101)
  0x38, 0x01, 0x20, 0x13, 0x04, 0xD0, 0xA3, 0x04, 0xD0, 0xA7, 0x68, 0x55, 0xBE, 0xFD, 0x92, 0x20,
  0x1E, 0x0E, 0x01, 0x28, 0x37, 0x74, 0x39, 0xA0, 0x66, 0x02, 0xA8, 0x37, 0x01, 0x8D, 0xD8, 0x18,
  0x0D, 0xF0, 0x80, 0x3A, 0x82, 0xD4, 0x24, 0xA0, 0x80, 0x2A, 0x82, 0xB3, 0x3A, 0xA8, 0x18, 0x0D,
  0xC8, 0x94, 0xDD, 0xF8, 0x02, 0xBE, 0xEA, 0x17, 0xF8,
  // "Ă" (U+0102)
  0x28, 0x62, 0xF9, 0x32, 0x6F, 0x76, 0x0C, 0xC0, 0xE0, 0x26, 0x84, 0x19, 0xEE, 0xB3, 0x77, 0x70,
  0xAB, 0x72, 0x0E, 0xB0, 0x57, 0x05, 0xA8, 0x1B, 0xFB, 0x78, 0x2A, 0xFC, 0x6A, 0x01, 0x50, 0x1A,
  0x08, 0x01, 0xA0, 0x65, 0x06, 0xA8, 0x33, 0x0C, 0xFC, 0x58, 0x1B, 0xFE, 0x20, 0x7A, 0x02, 0x30,
  0x1A, 0x82, 0xB4, 0x46, 0xA0, 0x73, 0x06, 0xF9, 0x0D, 0x30, 0xCF, 0xA8, 0x13, 0x02, 0xA0, 0xB4,
  0x04, 0xA8, 0x18, 0x07, 0xA0, 0x65, 0x83, 0xEF, 0xD0, 0xCA, 0x01, 0x50, 0xAA, 0x03,
  // "ă" (U+0103)
  0x18, 0x62, 0xF9, 0x32, 0x6F, 0x73, 0x0C, 0xC0, 0xE0, 0x23, 0x84, 0x19, 0xEE, 0xB3, 0x77, 0x85,
  0x5B, 0xEF, 0xD9, 0x22, 0x01, 0xE0, 0xE0, 0x12, 0x83, 0x77, 0x43, 0x9A, 0x06, 0x60, 0x2A, 0x83,
  0x70, 0x18, 0xDD, 0x81, 0x80, 0xDF, 0x08, 0x03, 0xA8, 0x2D, 0x42, 0x4A, 0x08, 0x02, 0xA8, 0x2B,
  0x33, 0xAA, 0x81, 0x80, 0xDC, 0x89, 0x4D, 0xDF, 0x80, 0x2B, 0xEE, 0xA1, 0x7F, 0x80,
  // "Ą" (U+0104)
  0x40, 0xAB, 0x72, 0x0E, 0xB0, 0x57, 0x05, 0xA8, 0x1B, 0xFB, 0x78, 0x2A, 0xFC, 0x6A, 0x01, 0x50,
  0x1A, 0x08, 0x01, 0xA0, 0x65, 0x06, 0xA8, 0x33, 0x0C, 0xFC, 0x58, 0x1B, 0xFE, 0x20, 0x7A, 0x02,
  0x30, 0x1A, 0x82, 0xB4, 0x46, 0xA0, 0x73, 0x06, 0xF9, 0x0D, 0x30, 0xCF, 0xA8, 0x13, 0x02, 0xA0,
  0xB4, 0x04, 0xA8, 0x18, 0x07, 0xA0, 0x65, 0x83, 0xEF, 0xE0, 0xCA, 0x01, 0x50, 0xDA, 0x03, 0x72,
  0x0D, 0x0B, 0x73, 0x83, 0x3F, 0xB3, 0x17, 0x10, 0x2B, 0x04, 0x72, 0x82, 0x7E, 0xE3,
  // "ą" (U+0105)
  0x28, 0x55, 0xBE, 0xFD, 0x92, 0x20, 0x1E, 0x0E, 0x01, 0x28, 0x37, 0x74, 0x39, 0xA0, 0x66, 0x02,
  0xA8, 0x37, 0x01, 0x8D, 0xD8, 0x18, 0x0D, 0xF0, 0x80, 0x3A, 0x82, 0xD4, 0x24, 0xA0, 0x80, 0x2A,
  0x82, 0xB3, 0x3A, 0xA8, 0x18, 0x0D, 0xC8, 0x91, 0xDE, 0xF8, 0x02, 0xBE, 0xEA, 0x5A, 0x08, 0x60,
  0xD0, 0xB7, 0x83, 0x3F, 0xB3, 0x15, 0x02, 0xB0, 0x46, 0x82, 0x7E, 0xE3,
  // "Ć" (U+0106)
  0x50, 0x8A, 0x07, 0x50, 0x4A, 0x06, 0x58, 0x21, 0xEE, 0x37, 0x72, 0x89, 0x07, 0xCE, 0xEC, 0x93,
  0x02, 0xDE, 0x81, 0x80, 0xCA, 0x85, 0x93, 0x36, 0xC2, 0x5A, 0x09, 0x60, 0xAA, 0x02, 0x60, 0xDA,
  0x78, 0x1E, 0xFD, 0x78, 0x1D, 0xFE, 0x70, 0xBA, 0x01, 0x60, 0x7A, 0x08, 0x60, 0x10, 0xEA, 0x87,
  0x83, 0x35, 0x94, 0x04, 0xEE, 0x05, 0x28, 0x62, 0x9D, 0xEE, 0xD9, 0x20,
  // "ć" (U+0107)
  0x50, 0x8A, 0x07, 0x40, 0x4A, 0x06, 0x48, 0x21, 0xEE, 0x37, 0x68, 0x90, 0x19, 0xDF, 0xDB, 0x40,
  0x2E, 0xD8, 0x15, 0x0A, 0xA8, 0x28, 0x34, 0x92, 0xA0, 0xC5, 0x02, 0xA0, 0x95, 0x02, 0xA0, 0x96,
  0xA0, 0xC6, 0x0C, 0xA8, 0x58, 0x34, 0x85, 0x03, 0xE0, 0x62, 0x85, 0x3A, 0xEF, 0xEA, 0x20,
  // "Ĉ" (U+0108)
  0x30, 0x5B, 0x07, 0x48, 0x23, 0xEF, 0x9A, 0x03, 0x28, 0x71, 0xDE, 0x40, 0x4D, 0xE2, 0x76, 0x89,
  0x07, 0xCE, 0xEC, 0x93, 0x02, 0xDE, 0x81, 0x80, 0xCA, 0x85, 0x93, 0x36, 0xC2, 0x5A, 0x09, 0x60,
  0xAA, 0x02, 0x60, 0xDA, 0x78, 0x1E, 0xFD, 0x78, 0x1D, 0xFE, 0x70, 0xBA, 0x01, 0x60, 0x7A, 0x08,
  0x60, 0x10, 0xEA, 0x87, 0x83, 0x35, 0x94, 0x04, 0xEE, 0x05, 0x28, 0x62, 0x9D, 0xEE, 0xD9, 0x20,
  // "ĉ" (U+0109)
  0x30, 0x5B, 0x07, 0x48, 0x23, 0xEF, 0x9A, 0x03, 0x28, 0x71, 0xDE, 0x40, 0x4D, 0xE2, 0x75, 0x85,
  0x19, 0xDF, 0xDB, 0x42, 0x02, 0x0E, 0xD0, 0x52, 0x0A, 0xA8, 0x28, 0x34, 0x93, 0xA0, 0xC6, 0x02,
  0xA0, 0x96, 0x02, 0xA0, 0x97, 0xA0, 0xC7, 0x0C, 0xA8, 0x38, 0x34, 0x85, 0x20, 0x3E, 0x06, 0x38,
  0x53, 0xAE, 0xFE, 0xA2, 0x10,
  // "Ċ" (U+010A)
  0x60, 0x17, 0x02, 0xA0, 0x76, 0x82, 0x1D, 0xE5, 0x77, 0x18, 0x90, 0x7C, 0xEE, 0xC9, 0x30, 0x2D,
  0xE8, 0x18, 0x0C, 0xA8, 0x59, 0x33, 0x6C, 0x25, 0xA0, 0x96, 0x0A, 0xA0, 0x26, 0x0D, 0xA7, 0x81,
  0xEF, 0xD7, 0x81, 0xDF, 0xE7, 0x0B, 0xA0, 0x16, 0x07, 0xA0, 0x86, 0x01, 0x0E, 0xA8, 0x78, 0x33,
  0x59, 0x40, 0x4E, 0xE0, 0x52, 0x86, 0x29, 0xDE, 0xED, 0x92,
  // "ċ" (U+010B)
  0x50, 0x16, 0x02, 0xA0, 0x75, 0x82, 0x1D, 0xE5, 0x76, 0x89, 0x01, 0x9D, 0xFD, 0xB4, 0x02, 0xED,
  0x81, 0x50, 0xAA, 0x82, 0x83, 0x49, 0x2A, 0x0C, 0x50, 0x2A, 0x09, 0x50, 0x2A, 0x09, 0x6A, 0x0C,
  0x60, 0xCA, 0x85, 0x83, 0x48, 0x50, 0x3E, 0x06, 0x28, 0x53, 0xAE, 0xFE, 0xA2,
  // "Č" (U+010C)
  0x18, 0x71, 0xEE, 0x40, 0x3D, 0xE2, 0x28, 0x23, 0xEF, 0x9A, 0x04, 0x40, 0x6B, 0x07, 0x77, 0x18,
  0x90, 0x7C, 0xEE, 0xC9, 0x30, 0x2D, 0xE8, 0x18, 0x0C, 0xA8, 0x59, 0x33, 0x6C, 0x25, 0xA0, 0x96,
  0x0A, 0xA0, 0x26, 0x0D, 0xA7, 0x81, 0xEF, 0xD7, 0x81, 0xDF, 0xE7, 0x0B, 0xA0, 0x16, 0x07, 0xA0,
  0x86, 0x01, 0x0E, 0xA8, 0x78, 0x33, 0x59, 0x40, 0x4E, 0xE0, 0x52, 0x86, 0x29, 0xDE, 0xED, 0x92,
  // "č" (U+010D)
  0x18, 0x71, 0xEE, 0x40, 0x3D, 0xE2, 0x28, 0x23, 0xEF, 0x9A, 0x04, 0x40, 0x6B, 0x07, 0x77, 0x85,
  0x19, 0xDF, 0xDB, 0x42, 0x02, 0x0E, 0xD0, 0x52, 0x0A, 0xA8, 0x28, 0x34, 0x93, 0xA0, 0xC6, 0x02,
  0xA0, 0x96, 0x02, 0xA0, 0x97, 0xA0, 0xC7, 0x0C, 0xA8, 0x38, 0x34, 0x85, 0x20, 0x3E, 0x06, 0x38,
  0x53, 0xAE, 0xFE, 0xA2, 0x10,
  // "Ď" (U+010E)
  0x18, 0x71, 0xEE, 0x40, 0x3D, 0xE2, 0x48, 0x23, 0xEF, 0x9A, 0x04, 0x60, 0x6B, 0x07, 0x77, 0x20,
  0x5C, 0x82, 0xEC, 0x71, 0x30, 0x5F, 0x0E, 0x04, 0x20, 0x5A, 0x82, 0x62, 0x37, 0xA8, 0x2E, 0x20,
  0x5A, 0x05, 0x30, 0x4A, 0x81, 0xA0, 0x5A, 0x05, 0x40, 0xCA, 0x01, 0x05, 0xA0, 0x54, 0x09, 0xA0,
  0x20, 0x5A, 0x05, 0x40, 0x8A, 0x03, 0x05, 0xA0, 0x54, 0x09, 0xA0, 0x30, 0x5A, 0x05, 0x40, 0xDA,
  0x10, 0x5A, 0x05, 0x30, 0x5A, 0x81, 0xA0, 0x5A, 0x82, 0x62, 0x38, 0xA8, 0x2E, 0x20, 0x5F, 0x0E,
  0x04, 0x20, 0x5C, 0x82, 0xEB, 0x71, 0x30,
  // "ď" (U+010F)
  0x70, 0xAA, 0x18, 0x1E, 0xF7, 0x70, 0xAA, 0x81, 0x2F, 0xE7, 0x10, 0xAA, 0x81, 0x4D, 0x57, 0x10,
  0xAA, 0x68, 0x44, 0xCF, 0xD6, 0x9A, 0x50, 0x4D, 0x0D, 0xA5, 0x0C, 0xA8, 0x17, 0x37, 0xB5, 0xA0,
  0xC3, 0x0B, 0xA4, 0x02, 0xA0, 0x93, 0x08, 0xA4, 0x02, 0xA0, 0x93, 0x08, 0xA5, 0xA0, 0xB3, 0x0B,
  0xA5, 0x0C, 0xA8, 0x17, 0x36, 0xB5, 0x04, 0xD0, 0xCA, 0x68, 0x45, 0xCF, 0xD5, 0x3A, 0x40,
  // "Đ" (U+0110)
  0x10, 0x5C, 0x82, 0xEC, 0x71, 0x40, 0x5F, 0x0E, 0x04, 0x30, 0x5A, 0x82, 0x62, 0x37, 0xA0, 0xE0,
  0x22, 0x05, 0xA0, 0x53, 0x04, 0xA0, 0xA2, 0x05, 0xA0, 0x54, 0x0C, 0xA8, 0x11, 0x17, 0xA8, 0x16,
  0x21, 0x20, 0x9A, 0x02, 0x09, 0xD0, 0x62, 0x08, 0xA0, 0x30, 0x9D, 0x06, 0x20, 0x9A, 0x81, 0x30,
  0x5A, 0x05, 0x40, 0xDA, 0x20, 0x5A, 0x05, 0x30, 0x5A, 0x0A, 0x20, 0x5A, 0x82, 0x62, 0x49, 0xA0,
  0xE0, 0x22, 0x05, 0xF0, 0xE0, 0x43, 0x05, 0xC8, 0x2E, 0xB7, 0x13,
  // "đ" (U+0111)
  0x48, 0x21, 0x22, 0xBA, 0x02, 0x50, 0x7E, 0x05, 0x40, 0x7E, 0x05, 0x70, 0xAA, 0x48, 0x44, 0xCF,
  0xD6, 0x9A, 0x30, 0x4D, 0x0D, 0xA3, 0x0C, 0xA8, 0x17, 0x37, 0xB3, 0xA0, 0xC3, 0x0B, 0xA2, 0x02,
  0xA0, 0x93, 0x08, 0xA2, 0x02, 0xA0, 0x93, 0x08, 0xA3, 0xA0, 0xB3, 0x0A, 0xA3, 0x0C, 0xA8, 0x17,
  0x36, 0xB3, 0x04, 0xD0, 0xCA, 0x48, 0x45, 0xCF, 0xD5, 0x3A, 0x20,
  // "Ē" (U+0112)
  0x28, 0x01, 0x28, 0x11, 0x04, 0xD8, 0x1A, 0x04, 0xD0, 0xA7, 0x10, 0x5F, 0x05, 0xF0, 0x5A, 0x84,
  0x62, 0x22, 0x25, 0xA0, 0x54, 0x05, 0xA0, 0x54, 0x05, 0xE0, 0xA0, 0x5E, 0x0A, 0x05, 0xA8, 0x46,
  0x22, 0x21, 0x5A, 0x05, 0x40, 0x5A, 0x05, 0x40, 0x5A, 0x84, 0x62, 0x22, 0x25, 0xF0, 0x5F,
  // "ē" (U+0113)
  0x38, 0x01, 0x20, 0x13, 0x04, 0xD0, 0xA3, 0x04, 0xD0, 0xA7, 0x68, 0x51, 0x9D, 0xFD, 0x81, 0x20,
  0x20, 0xED, 0x0C, 0x20, 0xAA, 0x81, 0x63, 0x6A, 0x07, 0x1A, 0x86, 0xB2, 0x22, 0xCF, 0xB2, 0xF9,
  0x0D, 0x02, 0xF9, 0x0D, 0x1A, 0x0A, 0x70, 0xAA, 0x87, 0x73, 0x34, 0x83, 0x01, 0xDE, 0x04, 0x28,
  0x11, 0x8D, 0xA8, 0x1D, 0x81,
  // "Ĕ" (U+0114)
  0x89, 0x02, 0xF9, 0x32, 0x6F, 0x70, 0xCC, 0x87, 0xE2, 0x01, 0x9E, 0xEB, 0x37, 0x20, 0x5F, 0x05,
  0xF0, 0x5A, 0x84, 0x62, 0x22, 0x25, 0xA0, 0x54, 0x05, 0xA0, 0x54, 0x05, 0xE0, 0xA0, 0x5E, 0x0A,
  0x05, 0xA8, 0x46, 0x22, 0x21, 0x5A, 0x05, 0x40, 0x5A, 0x05, 0x40, 0x5A, 0x84, 0x62, 0x22, 0x25,
  0xF0, 0x5F,
  // "ĕ" (U+0115)
  0x18, 0x62, 0xF9, 0x32, 0x6F, 0x73, 0x0C, 0xC0, 0xE0, 0x23, 0x84, 0x19, 0xEE, 0xB3, 0x77, 0x85,
  0x19, 0xDF, 0xD8, 0x12, 0x02, 0x0E, 0xD0, 0xC2, 0x0A, 0xA8, 0x16, 0x36, 0xA0, 0x71, 0xA8, 0x6B,
  0x22, 0x2C, 0xFB, 0x2F, 0x90, 0xD0, 0x2F, 0x90, 0xD1, 0xA0, 0xA7, 0x0A, 0xA8, 0x77, 0x33, 0x48,
  0x30, 0x1D, 0xE0, 0x42, 0x81, 0x18, 0xDA, 0x81, 0xD8, 0x10,
  // "Ė" (U+0116)
  0x40, 0x15, 0x02, 0xA0, 0x74, 0x82, 0x1D, 0xE5, 0x73, 0x05, 0xF0, 0x5F, 0x05, 0xA8, 0x46, 0x22,
  0x22, 0x5A, 0x05, 0x40, 0x5A, 0x05, 0x40, 0x5E, 0x0A, 0x05, 0xE0, 0xA0, 0x5A, 0x84, 0x62, 0x22,
  0x15, 0xA0, 0x54, 0x05, 0xA0, 0x54, 0x05, 0xA8, 0x46, 0x22, 0x22, 0x5F, 0x05, 0xF0,
  // "ė" (U+0117)
  0x50, 0x17, 0x02, 0xA0, 0x76, 0x82, 0x1D, 0xE5, 0x77, 0x18, 0x51, 0x9D, 0xFD, 0x81, 0x20, 0x20,
  0xED, 0x0C, 0x20, 0xAA, 0x81, 0x63, 0x6A, 0x07, 0x1A, 0x86, 0xB2, 0x22, 0xCF, 0xB2, 0xF9, 0x0D,
  0x02, 0xF9, 0x0D, 0x1A, 0x0A, 0x70, 0xAA, 0x87, 0x73, 0x34, 0x83, 0x01, 0xDE, 0x04, 0x28, 0x11,
  0x8D, 0xA8, 0x1D, 0x81,
  // "Ę" (U+0118)
  0x05, 0xF1, 0x05, 0xF1, 0x05, 0xA8, 0x56, 0x22, 0x22, 0x05, 0xA0, 0x55, 0x05, 0xA0, 0x55, 0x05,
  0xE8, 0x1A, 0x05, 0xE8, 0x1A, 0x05, 0xA8, 0x56, 0x22, 0x21, 0x05, 0xA0, 0x55, 0x05, 0xA0, 0x55,
  0x05, 0xA8, 0x56, 0x22, 0x22, 0x05, 0xF1, 0x05, 0xF6, 0x0D, 0x0B, 0x68, 0x33, 0xFB, 0x31, 0x40,
  0x2B, 0x04, 0x58, 0x27, 0xEE, 0x30,
  // "ę" (U+0119)
  0x28, 0x41, 0x9D, 0xFD, 0x83, 0x02, 0x0E, 0xD0, 0xC2, 0x0A, 0xA8, 0x17, 0x37, 0xA0, 0x61, 0xA0,
  0xA3, 0x82, 0xBF, 0xB2, 0xF9, 0x0D, 0x02, 0xF9, 0x0D, 0x1A, 0x0A, 0x80, 0x22, 0x10, 0xAA, 0x87,
  0x73, 0x34, 0x73, 0x01, 0xDE, 0x04, 0x28, 0x11, 0x8D, 0xB0, 0xC0, 0x16, 0x09, 0x0C, 0x78, 0x24,
  0xF9, 0x26, 0x05, 0xB0, 0x26, 0x82, 0x9E, 0xE1,
  // "Ě" (U+011A)
  0x89, 0x41, 0xEE, 0x40, 0x3D, 0xE2, 0x03, 0xEF, 0x9A, 0x04, 0x30, 0x6B, 0x07, 0x74, 0x05, 0xF1,
  0x05, 0xF1, 0x05, 0xA8, 0x56, 0x22, 0x22, 0x05, 0xA0, 0x55, 0x05, 0xA0, 0x55, 0x05, 0xE8, 0x1A,
  0x05, 0xE8, 0x1A, 0x05, 0xA8, 0x56, 0x22, 0x21, 0x05, 0xA0, 0x55, 0x05, 0xA0, 0x55, 0x05, 0xA8,
  0x56, 0x22, 0x22, 0x05, 0xF1, 0x05, 0xF1,
  // "ě" (U+011B)
  0x18, 0x71, 0xEE, 0x40, 0x3D, 0xE2, 0x28, 0x23, 0xEF, 0x9A, 0x04, 0x40, 0x6B, 0x07, 0x77, 0x85,
  0x19, 0xDF, 0xD8, 0x12, 0x02, 0x0E, 0xD0, 0xC2, 0x0A, 0xA8, 0x16, 0x36, 0xA0, 0x71, 0xA8, 0x6B,
  0x22, 0x2C, 0xFB, 0x2F, 0x90, 0xD0, 0x2F, 0x90, 0xD1, 0xA0, 0xA7, 0x0A, 0xA8, 0x77, 0x33, 0x48,
  0x30, 0x1D, 0xE0, 0x42, 0x81, 0x18, 0xDA, 0x81, 0xD8, 0x10,
  // "Ĝ" (U+011C)
  0x40, 0x5B, 0x07, 0x58, 0x23, 0xEF, 0x9A, 0x03, 0x38, 0x71, 0xDE, 0x40, 0x4D, 0xE2, 0x77, 0x89,
  0x15, 0xAD, 0xFE, 0xC8, 0x20, 0x1B, 0xF8, 0x14, 0x0B, 0xA8, 0x6C, 0x53, 0x47, 0xA0, 0x5A, 0x0C,
  0x70, 0xAA, 0x03, 0x78, 0x1D, 0xFE, 0x28, 0x71, 0x22, 0x22, 0x1E, 0xFD, 0x20, 0x7C, 0x82, 0x9D,
  0xFE, 0x20, 0x7C, 0x09, 0x0B, 0xA0, 0x13, 0x01, 0xA0, 0x90, 0x7A, 0x09, 0x30, 0x1A, 0x81, 0x91,
  0xEA, 0x82, 0x93, 0x24, 0xA8, 0x29, 0x03, 0xEF, 0x09, 0x28, 0x71, 0x8D, 0xEF, 0xEC, 0x83,
  // "ĝ" (U+011D)
  0x30, 0x5B, 0x07, 0x48, 0x23, 0xEF, 0x9A, 0x03, 0x28, 0x71, 0xDE, 0x40, 0x4D, 0xE2, 0x75, 0x84,
  0x4C, 0xFD, 0x65, 0xA1, 0x04, 0xD0, 0xDA, 0x10, 0xCA, 0x81, 0x73, 0x7B, 0x1A, 0x0C, 0x30, 0xBA,
  0x02, 0xA0, 0x93, 0x08, 0xA0, 0x2A, 0x09, 0x30, 0x8A, 0x1A, 0x0C, 0x30, 0xAA, 0x10, 0xCA, 0x81,
  0x73, 0x6B, 0x10, 0x4D, 0x0D, 0xA2, 0x84, 0x5D, 0xFD, 0x5A, 0xA7, 0x89, 0x0C, 0xFE, 0x06, 0x74,
  0x33, 0x8A, 0x81, 0xA0, 0x9E, 0x84, 0xE2, 0x04, 0xAD, 0xA8, 0x1D, 0x92, 0x10,
  // "Ğ" (U+011E)
  0x28, 0x62, 0xF9, 0x32, 0x6F, 0x74, 0x0C, 0xC0, 0xE0, 0x24, 0x84, 0x19, 0xEE, 0xB3, 0x77, 0x28,
  0x91, 0x5A, 0xDF, 0xEC, 0x82, 0x01, 0xBF, 0x81, 0x40, 0xBA, 0x86, 0xC5, 0x34, 0x7A, 0x05, 0xA0,
  0xC7, 0x0A, 0xA0, 0x37, 0x81, 0xDF, 0xE2, 0x87, 0x12, 0x22, 0x21, 0xEF, 0xD2, 0x07, 0xC8, 0x29,
  0xDF, 0xE2, 0x07, 0xC0, 0x90, 0xBA, 0x01, 0x30, 0x1A, 0x09, 0x07, 0xA0, 0x93, 0x01, 0xA8, 0x19,
  0x1E, 0xA8, 0x29, 0x32, 0x4A, 0x82, 0x90, 0x3E, 0xF0, 0x92, 0x87, 0x18, 0xDE, 0xFE, 0xC8, 0x30,
  // "ğ" (U+011F)
  0x28, 0x62, 0xF9, 0x32, 0x6F, 0x73, 0x0C, 0xC0, 0xE0, 0x23, 0x84, 0x19, 0xEE, 0xB3, 0x76, 0x84,
  0x4C, 0xFD, 0x65, 0xA1, 0x04, 0xD0, 0xDA, 0x10, 0xCA, 0x81, 0x73, 0x7B, 0x1A, 0x0C, 0x30, 0xBA,
  0x02, 0xA0, 0x93, 0x08, 0xA0, 0x2A, 0x09, 0x30, 0x8A, 0x1A, 0x0C, 0x30, 0xAA, 0x10, 0xCA, 0x81,
  0x73, 0x6B, 0x10, 0x4D, 0x0D, 0xA2, 0x84, 0x5D, 0xFD, 0x5A, 0xA7, 0x89, 0x0C, 0xFE, 0x06, 0x74,
  0x33, 0x8A, 0x81, 0xA0, 0x9E, 0x84, 0xE2, 0x04, 0xAD, 0xA8, 0x1D, 0x92, 0x10,
  // "Ġ" (U+0120)
  0x60, 0x17, 0x10, 0x2A, 0x07, 0x78, 0x21, 0xDE, 0x57, 0x73, 0x89, 0x15, 0xAD, 0xFE, 0xC8, 0x20,
  0x1B, 0xF8, 0x14, 0x0B, 0xA8, 0x6C, 0x53, 0x47, 0xA0, 0x5A, 0x0C, 0x70, 0xAA, 0x03, 0x78, 0x1D,
  0xFE, 0x28, 0x71, 0x22, 0x22, 0x1E, 0xFD, 0x20, 0x7C, 0x82, 0x9D, 0xFE, 0x20, 0x7C, 0x09, 0x0B,
  0xA0, 0x13, 0x01, 0xA0, 0x90, 0x7A, 0x09, 0x30, 0x1A, 0x81, 0x91, 0xEA, 0x82, 0x93, 0x24, 0xA8,
  0x29, 0x03, 0xEF, 0x09, 0x28, 0x71, 0x8D, 0xEF, 0xEC, 0x83,
  // "ġ" (U+0121)
  0x60, 0x17, 0x02, 0xA0, 0x76, 0x82, 0x1D, 0xE5, 0x77, 0x84, 0x4C, 0xFD, 0x65, 0xA1, 0x04, 0xD0,
  0xDA, 0x10, 0xCA, 0x81, 0x73, 0x7B, 0x1A, 0x0C, 0x30, 0xBA, 0x02, 0xA0, 0x93, 0x08, 0xA0, 0x2A,
  0x09, 0x30, 0x8A, 0x1A, 0x0C, 0x30, 0xAA, 0x10, 0xCA, 0x81, 0x73, 0x6B, 0x10, 0x4D, 0x0D, 0xA2,
  0x84, 0x5D, 0xFD, 0x5A, 0xA7, 0x89, 0x0C, 0xFE, 0x06, 0x74, 0x33, 0x8A, 0x81, 0xA0, 0x9E, 0x84,
  0xE2, 0x04, 0xAD, 0xA8, 0x1D, 0x92, 0x10,
  // "Ģ" (U+0122)
  0x38, 0x91, 0x5A, 0xDF, 0xEC, 0x82, 0x01, 0xBF, 0x81, 0x40, 0xBA, 0x86, 0xC5, 0x34, 0x7A, 0x05,
  0xA0, 0xC7, 0x0A, 0xA0, 0x37, 0x81, 0xDF, 0xE2, 0x87, 0x12, 0x22, 0x21, 0xEF, 0xD2, 0x07, 0xC8,
  0x29, 0xDF, 0xE2, 0x07, 0xC0, 0x90, 0xBA, 0x01, 0x30, 0x1A, 0x09, 0x07, 0xA0, 0x93, 0x01, 0xA8,
  0x19, 0x1E, 0xA8, 0x29, 0x32, 0x4A, 0x82, 0x90, 0x3E, 0xF0, 0x92, 0x87, 0x18, 0xDE, 0xFE, 0xC8,
  0x37, 0x72, 0x81, 0xDD, 0x57, 0x81, 0x3F, 0xE7, 0x18, 0x16, 0xF5, 0x40,
  // "ģ" (U+0123)
  0x50, 0xC0, 0xE7, 0x81, 0x5F, 0xB7, 0x81, 0xBD, 0x87, 0x71, 0x84, 0x4C, 0xFD, 0x65, 0xA1, 0x04,
  0xD0, 0xDA, 0x10, 0xCA, 0x81, 0x73, 0x7B, 0x1A, 0x0C, 0x30, 0xBA, 0x02, 0xA0, 0x93, 0x08, 0xA0,
  0x2A, 0x09, 0x30, 0x8A, 0x1A, 0x0C, 0x30, 0xAA, 0x10, 0xCA, 0x81, 0x73, 0x6B, 0x10, 0x4D, 0x0D,
  0xA2, 0x84, 0x5D, 0xFD, 0x5A, 0xA7, 0x89, 0x0C, 0xFE, 0x06, 0x74, 0x33, 0x8A, 0x81, 0xA0, 0x9E,
  0x84, 0xE2, 0x04, 0xAD, 0xA8, 0x1D, 0x92, 0x10,
  // "Ĥ" (U+0124)
  0x30, 0x5B, 0x07, 0x68, 0x23, 0xEF, 0x9A, 0x03, 0x48, 0x71, 0xDE, 0x40, 0x4D, 0xE2, 0x77, 0x05,
  0xA0, 0x54, 0x08, 0xA0, 0x20, 0x5A, 0x05, 0x40, 0x8A, 0x02, 0x05, 0xA0, 0x54, 0x08, 0xA0, 0x20,
  0x5A, 0x05, 0x40, 0x8A, 0x02, 0x05, 0xA0, 0x54, 0x08, 0xA0, 0x20, 0x5F, 0xB0, 0x20, 0x5F, 0xB0,
  0x20, 0x5A, 0x84, 0x62, 0x22, 0x29, 0xA0, 0x20, 0x5A, 0x05, 0x40, 0x8A, 0x02, 0x05, 0xA0, 0x54,
  0x08, 0xA0, 0x20, 0x5A, 0x05, 0x40, 0x8A, 0x02, 0x05, 0xA0, 0x54, 0x08, 0xA0, 0x20, 0x5A, 0x05,
  0x40, 0x8A, 0x02,
  // "ĥ" (U+0125)
  0x20, 0x5B, 0x07, 0x78, 0x23, 0xEF, 0x9A, 0x03, 0x58, 0x71, 0xDE, 0x40, 0x4D, 0xE2, 0x77, 0x60,
  0x9A, 0x01, 0x72, 0x09, 0xA0, 0x17, 0x20, 0x9A, 0x01, 0x72, 0x09, 0xA0, 0x17, 0x20, 0x9A, 0x84,
  0x2A, 0xEE, 0xA2, 0x40, 0x9A, 0x0D, 0xC0, 0xE4, 0x09, 0xA8, 0x2D, 0x43, 0xCA, 0x05, 0x30, 0x9A,
  0x05, 0x20, 0x4A, 0x07, 0x30, 0x9A, 0x02, 0x20, 0x3A, 0x07, 0x30, 0x9A, 0x01, 0x20, 0x3A, 0x07,
  0x30, 0x9A, 0x01, 0x20, 0x3A, 0x07, 0x30, 0x9A, 0x01, 0x20, 0x3A, 0x07, 0x30, 0x9A, 0x01, 0x20,
  0x3A, 0x07, 0x30, 0x9A, 0x01, 0x20, 0x3A, 0x07,
  // "Ħ" (U+0126)
  0x10, 0x5A, 0x05, 0x40, 0x8A, 0x82, 0x20, 0x27, 0xA8, 0x46, 0x22, 0x22, 0x9A, 0x04, 0x01, 0xFE,
  0x0B, 0xFE, 0x81, 0xB0, 0x5A, 0x05, 0x40, 0x8A, 0x02, 0x20, 0x5F, 0xB0, 0x22, 0x05, 0xFB, 0x02,
  0x20, 0x5A, 0x84, 0x62, 0x22, 0x29, 0xA0, 0x22, 0x05, 0xA0, 0x54, 0x08, 0xA0, 0x22, 0x05, 0xA0,
  0x54, 0x08, 0xA0, 0x22, 0x05, 0xA0, 0x54, 0x08, 0xA0, 0x22, 0x05, 0xA0, 0x54, 0x08, 0xA0, 0x22,
  0x05, 0xA0, 0x54, 0x08, 0xA0, 0x21,
  // "ħ" (U+0127)
  0x10, 0x9A, 0x01, 0x70, 0x9A, 0x01, 0x6E, 0x0D, 0x4E, 0x0D, 0x50, 0x9A, 0x84, 0x19, 0xEE, 0xA2,
  0x20, 0x9A, 0x09, 0xC0, 0xD2, 0x09, 0xA8, 0x2E, 0x53, 0xCA, 0x81, 0x50, 0x9A, 0x06, 0x20, 0x5A,
  0x81, 0x60, 0x9A, 0x02, 0x20, 0x3A, 0x81, 0x70, 0x9A, 0x01, 0x20, 0x3A, 0x81, 0x70, 0x9A, 0x01,
  0x20, 0x3A, 0x81, 0x70, 0x9A, 0x01, 0x20, 0x3A, 0x81, 0x70, 0x9A, 0x01, 0x20, 0x3A, 0x81, 0x70,
  0x9A, 0x01, 0x20, 0x3A, 0x07,
  // "Ĩ" (U+0128)
  0x18, 0x73, 0xDE, 0x83, 0xAE, 0x0D, 0xD8, 0x79, 0x2F, 0x64, 0xAE, 0xB1, 0x72, 0x06, 0xD8, 0x16,
  0x05, 0xD0, 0x52, 0x83, 0x2E, 0xFE, 0x24, 0x81, 0xDF, 0xD5, 0x81, 0xDF, 0xD5, 0x81, 0xDF, 0xD5,
  0x81, 0xDF, 0xD5, 0x81, 0xDF, 0xD5, 0x81, 0xDF, 0xD5, 0x81, 0xDF, 0xD5, 0x81, 0xDF, 0xD3, 0x04,
  0x0E, 0xB8, 0x2E, 0x40, 0x6D, 0x06,
  // "ĩ" (U+0129)
  0x18, 0x73, 0xDE, 0x83, 0xAE, 0x0D, 0xD8, 0x79, 0x2F, 0x64, 0xAE, 0xB1, 0x74, 0x09, 0xA0, 0x14,
  0x09, 0xA0, 0x14, 0x09, 0xA0, 0x14, 0x09, 0xA0, 0x14, 0x09, 0xA0, 0x14, 0x09, 0xA0, 0x14, 0x09,
  0xA0, 0x14, 0x09, 0xA0, 0x14, 0x09, 0xA0, 0x14, 0x09, 0xA0, 0x11,
  // "Ī" (U+012A)
  0x18, 0x01, 0x20, 0x10, 0x4D, 0x0A, 0x04, 0xD0, 0xA7, 0x06, 0xD0, 0x60, 0x5D, 0x85, 0x50, 0x2E,
  0xFE, 0x23, 0x81, 0xDF, 0xD4, 0x81, 0xDF, 0xD4, 0x81, 0xDF, 0xD4, 0x81, 0xDF, 0xD4, 0x81, 0xDF,
  0xD4, 0x81, 0xDF, 0xD4, 0x81, 0xDF, 0xD4, 0x81, 0xDF, 0xD2, 0x04, 0x0E, 0xB8, 0x1E, 0x46, 0xD0,
  0x60,
  // "ī" (U+012B)
  0x18, 0x01, 0x20, 0x10, 0x4D, 0x0A, 0x04, 0xD0, 0xA7, 0x20, 0x9A, 0x01, 0x30, 0x9A, 0x01, 0x30,
  0x9A, 0x01, 0x30, 0x9A, 0x01, 0x30, 0x9A, 0x01, 0x30, 0x9A, 0x01, 0x30, 0x9A, 0x01, 0x30, 0x9A,
  0x01, 0x30, 0x9A, 0x01, 0x30, 0x9A, 0x01, 0x10,
  // "Ĭ" (U+012C)
  0x89, 0x02, 0xF9, 0x32, 0x6F, 0x70, 0xCC, 0x87, 0xE2, 0x01, 0x9E, 0xEB, 0x37, 0x30, 0x6D, 0x81,
  0x60, 0x5D, 0x05, 0x28, 0x32, 0xEF, 0xE2, 0x48, 0x1D, 0xFD, 0x58, 0x1D, 0xFD, 0x58, 0x1D, 0xFD,
  0x58, 0x1D, 0xFD, 0x58, 0x1D, 0xFD, 0x58, 0x1D, 0xFD, 0x58, 0x1D, 0xFD, 0x58, 0x1D, 0xFD, 0x30,
  0x40, 0xEB, 0x82, 0xE4, 0x06, 0xD0, 0x60,
  // "ĭ" (U+012D)
  0x89, 0x02, 0xF9, 0x32, 0x6F, 0x70, 0xCC, 0x87, 0xE2, 0x01, 0x9E, 0xEB, 0x37, 0x40, 0x9A, 0x01,
  0x40, 0x9A, 0x01, 0x40, 0x9A, 0x01, 0x40, 0x9A, 0x01, 0x40, 0x9A, 0x01, 0x40, 0x9A, 0x01, 0x40,
  0x9A, 0x01, 0x40, 0x9A, 0x01, 0x40, 0x9A, 0x01, 0x40, 0x9A, 0x01, 0x20,
  // "Į" (U+012E)
  0x06, 0xD0, 0x60, 0x5D, 0x85, 0x50, 0x2E, 0xFE, 0x23, 0x81, 0xDF, 0xD4, 0x81, 0xDF, 0xD4, 0x81,
  0xDF, 0xD4, 0x81, 0xDF, 0xD4, 0x81, 0xDF, 0xD4, 0x81, 0xDF, 0xD4, 0x81, 0xDF, 0xD4, 0x81, 0xDF,
  0xD2, 0x04, 0x0E, 0xB8, 0x1E, 0x46, 0xD0, 0x63, 0x0D, 0x0B, 0x48, 0x33, 0xFB, 0x31, 0x20, 0x2B,
  0x04, 0x38, 0x27, 0xEE, 0x30,
  // "į" (U+012F)
  0x18, 0x76, 0xEC, 0x10, 0x8F, 0xE1, 0x20, 0x17, 0x10, 0x9A, 0x81, 0x10, 0x9A, 0x81, 0x10, 0x9A,
  0x81, 0x10, 0x9A, 0x81, 0x10, 0x9A, 0x81, 0x10, 0x9A, 0x81, 0x10, 0x9A, 0x81, 0x10, 0x9A, 0x81,
  0x10, 0x9A, 0x81, 0x10, 0xCA, 0x82, 0x10, 0xDB, 0x28, 0x43, 0xFB, 0x31, 0x2B, 0x84, 0x40, 0x7E,
  0xE3,
  // "İ" (U+0130)
  0x30, 0x14, 0x02, 0xA0, 0x73, 0x82, 0x1D, 0xE5, 0x72, 0x06, 0xD0, 0x60, 0x5D, 0x85, 0x50, 0x2E,
  0xFE, 0x23, 0x81, 0xDF, 0xD4, 0x81, 0xDF, 0xD4, 0x81, 0xDF, 0xD4, 0x81, 0xDF, 0xD4, 0x81, 0xDF,
  0xD4, 0x81, 0xDF, 0xD4, 0x81, 0xDF, 0xD4, 0x81, 0xDF, 0xD2, 0x04, 0x0E, 0xB8, 0x1E, 0x46, 0xD0,
  0x60,
  // "ı" (U+0131)
  0x09, 0xA0, 0x10, 0x9A, 0x01, 0x09, 0xA0, 0x10, 0x9A, 0x01, 0x09, 0xA0, 0x10, 0x9A, 0x01, 0x09,
  0xA0, 0x10, 0x9A, 0x01, 0x09, 0xA0, 0x10, 0x9A, 0x01,
  // "Ĳ" (U+0132)
  0x06, 0xD8, 0x16, 0x05, 0xA0, 0x05, 0xD8, 0x15, 0x05, 0xA8, 0x55, 0x02, 0xEF, 0xE2, 0x20, 0x5A,
  0x05, 0x28, 0x1D, 0xFD, 0x30, 0x5A, 0x05, 0x28, 0x1D, 0xFD, 0x30, 0x5A, 0x05, 0x28, 0x1D, 0xFD,
  0x30, 0x5A, 0x05, 0x28, 0x1D, 0xFD, 0x30, 0x5A, 0x05, 0x28, 0x1D, 0xFD, 0x30, 0x5A, 0x05, 0x28,
  0x1D, 0xFD, 0x30, 0x5A, 0x05, 0x28, 0x1D, 0xFD, 0x30, 0x5A, 0x05, 0x28, 0x1D, 0xFD, 0x30, 0x5A,
  0x81, 0x54, 0xEB, 0x82, 0xE4, 0x05, 0xA0, 0x50, 0x6D, 0x81, 0x60, 0x6A, 0x04, 0x70, 0x10, 0xCA,
  0x01, 0x50, 0x5C, 0x0A, 0x60, 0x5B, 0x09, 0x71, 0x00, 0x14,
  // "ĳ" (U+0133)
  0x8A, 0x26, 0xEC, 0x10, 0x6E, 0xC1, 0x8F, 0xE1, 0x08, 0xFE, 0x10, 0x14, 0x01, 0x74, 0x09, 0xA8,
  0x11, 0x09, 0xA0, 0x10, 0x9A, 0x81, 0x10, 0x9A, 0x01, 0x09, 0xA8, 0x11, 0x09, 0xA0, 0x10, 0x9A,
  0x81, 0x10, 0x9A, 0x01, 0x09, 0xA8, 0x11, 0x09, 0xA0, 0x10, 0x9A, 0x81, 0x10, 0x9A, 0x01, 0x09,
  0xA8, 0x11, 0x09, 0xA0, 0x10, 0x9A, 0x81, 0x10, 0x9A, 0x01, 0x09, 0xA8, 0x11, 0x09, 0xA0, 0x10,
  0x9A, 0x81, 0x10, 0x9A, 0x01, 0x50, 0x9A, 0x01, 0x38, 0x13, 0x3D, 0xA3, 0x02, 0xC0, 0xA3, 0x83,
  0x2E, 0xFE, 0x92,
  // "Ĵ" (U+0134)
  0x20, 0x5B, 0x07, 0x38, 0x23, 0xEF, 0x9A, 0x89, 0x13, 0x01, 0xDE, 0x40, 0x4D, 0xE2, 0x75, 0x05,
  0xA0, 0x55, 0x05, 0xA0, 0x55, 0x05, 0xA0, 0x55, 0x05, 0xA0, 0x55, 0x05, 0xA0, 0x55, 0x05, 0xA0,
  0x55, 0x05, 0xA0, 0x55, 0x05, 0xA0, 0x55, 0x05, 0xA0, 0x55, 0x05, 0xA0, 0x55, 0x05, 0xA0, 0x55,
  0x05, 0xA0, 0x55, 0x06, 0xA0, 0x44, 0x01, 0x0C, 0xA0, 0x12, 0x05, 0xC0, 0xA3, 0x05, 0xB0, 0x95,
  0x00, 0x16,
  // "ĵ" (U+0135)
  0x20, 0x5B, 0x07, 0x38, 0x23, 0xEF, 0x9A, 0x89, 0x13, 0x01, 0xDE, 0x40, 0x4D, 0xE2, 0x75, 0x09,
  0xA0, 0x15, 0x09, 0xA0, 0x15, 0x09, 0xA0, 0x15, 0x09, 0xA0, 0x15, 0x09, 0xA0, 0x15, 0x09, 0xA0,
  0x15, 0x09, 0xA0, 0x15, 0x09, 0xA0, 0x15, 0x09, 0xA0, 0x15, 0x09, 0xA0, 0x15, 0x09, 0xA0, 0x13,
  0x81, 0x33, 0xDA, 0x30, 0x2C, 0x0A, 0x38, 0x32, 0xEF, 0xE9, 0x40,
  // "Ķ" (U+0136)
  0x05, 0xA0, 0x53, 0x07, 0xA0, 0x80, 0x5A, 0x05, 0x20, 0x4A, 0x81, 0xB0, 0x5A, 0x87, 0x50, 0x1E,
  0xFE, 0x10, 0x5A, 0x81, 0x50, 0xCA, 0x03, 0x20, 0x5A, 0x05, 0x09, 0xA0, 0x73, 0x05, 0xA0, 0x9A,
  0x0B, 0x40, 0x5D, 0x0C, 0x40, 0x5B, 0x0C, 0xA0, 0x73, 0x05, 0xA8, 0x17, 0x0D, 0xA0, 0x22, 0x05,
  0xA8, 0x15, 0x05, 0xA0, 0xB2, 0x05, 0xA0, 0x52, 0x0A, 0xA8, 0x15, 0x05, 0xA0, 0x52, 0x84, 0x1E,
  0xFE, 0x15, 0xA0, 0x53, 0x07, 0xA0, 0x97, 0x71, 0x81, 0xAD, 0x87, 0x18, 0x1E, 0xF2, 0x78, 0x12,
  0xF9, 0x50,
  // "ķ" (U+0137)
  0x09, 0xA0, 0x16, 0x09, 0xA0, 0x16, 0x09, 0xA0, 0x16, 0x09, 0xA0, 0x16, 0x09, 0xA0, 0x12, 0x08,
  0xA0, 0x70, 0x9A, 0x81, 0x10, 0x7A, 0x81, 0x80, 0x9A, 0x01, 0x05, 0xA0, 0xA2, 0x09, 0xA0, 0x4A,
  0x0B, 0x30, 0x9A, 0x0D, 0xA0, 0x33, 0x09, 0xD0, 0xC3, 0x09, 0xA0, 0x80, 0x6A, 0x09, 0x20, 0x9A,
  0x81, 0x10, 0xAA, 0x81, 0x50, 0x9A, 0x86, 0x10, 0x1E, 0xFE, 0x19, 0xA0, 0x12, 0x04, 0xA0, 0xB7,
  0x68, 0x16, 0xDC, 0x78, 0x19, 0xF7, 0x70, 0x0D, 0x50,
  // "ĸ" (U+0138)
  0x09, 0xA0, 0x12, 0x05, 0xA0, 0x70, 0x9A, 0x81, 0x10, 0x3A, 0x81, 0xA0, 0x9A, 0x83, 0x11, 0xEF,
  0xC2, 0x09, 0xA8, 0x31, 0xCF, 0xD1, 0x20, 0x9A, 0x0B, 0xA0, 0x43, 0x09, 0xD0, 0xB3, 0x09, 0xA0,
  0xB0, 0x8A, 0x07, 0x20, 0x9A, 0x81, 0x10, 0xBA, 0x81, 0x40, 0x9A, 0x86, 0x10, 0x1E, 0xFE, 0x19,
  0xA0, 0x12, 0x04, 0xA0, 0xB0,
  // "Ĺ" (U+0139)
  0x20, 0x8A, 0x07, 0x40, 0x4A, 0x06, 0x48, 0x21, 0xEE, 0x37, 0x70, 0x5A, 0x05, 0x50, 0x5A, 0x05,
  0x50, 0x5A, 0x05, 0x50, 0x5A, 0x05, 0x50, 0x5A, 0x05, 0x50, 0x5A, 0x05, 0x50, 0x5A, 0x05, 0x50,
  0x5A, 0x05, 0x50, 0x5A, 0x05, 0x50, 0x5A, 0x05, 0x50, 0x5A, 0x85, 0x73, 0x33, 0x32, 0x5F, 0x08,
  0x05, 0xF0, 0x80,
  // "ĺ" (U+013A)
  0x20, 0x8A, 0x81, 0x70, 0x4A, 0x84, 0x60, 0x1E, 0xE3, 0x72, 0x09, 0xA0, 0x12, 0x09, 0xA0, 0x12,
  0x09, 0xA0, 0x12, 0x09, 0xA0, 0x12, 0x09, 0xA0, 0x12, 0x09, 0xA0, 0x12, 0x09, 0xA0, 0x12, 0x09,
  0xA0, 0x12, 0x09, 0xA0, 0x12, 0x09, 0xA0, 0x12, 0x09, 0xA0, 0x12, 0x09, 0xA0, 0x12, 0x09, 0xA0,
  0x12, 0x09, 0xA0, 0x11,
  // "Ļ" (U+013B)
  0x05, 0xA0, 0x55, 0x05, 0xA0, 0x55, 0x05, 0xA0, 0x55, 0x05, 0xA0, 0x55, 0x05, 0xA0, 0x55, 0x05,
  0xA0, 0x55, 0x05, 0xA0, 0x55, 0x05, 0xA0, 0x55, 0x05, 0xA0, 0x55, 0x05, 0xA0, 0x55, 0x05, 0xA8,
  0x57, 0x33, 0x33, 0x25, 0xF0, 0x80, 0x5F, 0x08, 0x75, 0x81, 0x6D, 0xC6, 0x81, 0xAF, 0x76, 0x00,
  0xD4,
  // "ļ" (U+013C)
  0x09, 0xA0, 0x10, 0x9A, 0x01, 0x09, 0xA0, 0x10, 0x9A, 0x01, 0x09, 0xA0, 0x10, 0x9A, 0x01, 0x09,
  0xA0, 0x10, 0x9A, 0x01, 0x09, 0xA0, 0x10, 0x9A, 0x01, 0x09, 0xA0, 0x10, 0x9A, 0x01, 0x09, 0xA0,
  0x10, 0x9A, 0x01, 0x48, 0x91, 0x4D, 0xD1, 0x7F, 0xA0, 0xAF, 0x21,
  // "Ľ" (U+013D)
  0x05, 0xA0, 0x52, 0x82, 0x7F, 0xD5, 0xA0, 0x52, 0x82, 0xAF, 0x65, 0xA0, 0x52, 0x82, 0xCB, 0x05,
  0xA0, 0x55, 0x05, 0xA0, 0x55, 0x05, 0xA0, 0x55, 0x05, 0xA0, 0x55, 0x05, 0xA0, 0x55, 0x05, 0xA0,
  0x55, 0x05, 0xA0, 0x55, 0x05, 0xA8, 0x57, 0x33, 0x33, 0x25, 0xF0, 0x80, 0x5F, 0x08,
  // "ľ" (U+013E)
  0x09, 0xA0, 0x1A, 0x06, 0x09, 0xA8, 0x33, 0xFE, 0x09, 0xA8, 0x36, 0xD5, 0x09, 0xA0, 0x13, 0x09,
  0xA0, 0x13, 0x09, 0xA0, 0x13, 0x09, 0xA0, 0x13, 0x09, 0xA0, 0x13, 0x09, 0xA0, 0x13, 0x09, 0xA0,
  0x13, 0x09, 0xA0, 0x13, 0x09, 0xA0, 0x13, 0x09, 0xA0, 0x13, 0x09, 0xA0, 0x13,
  // "Ŀ" (U+013F)
  0x05, 0xA0, 0x55, 0x05, 0xA0, 0x55, 0x05, 0xA0, 0x55, 0x05, 0xA0, 0x55, 0x05, 0xA0, 0x53, 0x81,
  0x10, 0x5A, 0x81, 0x50, 0x2A, 0x07, 0x05, 0xA8, 0x55, 0x01, 0xDE, 0x55, 0xA0, 0x55, 0x05, 0xA0,
  0x55, 0x05, 0xA0, 0x55, 0x05, 0xA8, 0x57, 0x33, 0x33, 0x25, 0xF0, 0x80, 0x5F, 0x08,
  // "ŀ" (U+0140)
  0x09, 0xA0, 0x13, 0x09, 0xA0, 0x13, 0x09, 0xA0, 0x13, 0x09, 0xA0, 0x13, 0x09, 0xA0, 0x13, 0x09,
  0xA0, 0x13, 0x09, 0xA8, 0x31, 0x01, 0x09, 0xA0, 0x3A, 0x07, 0x09, 0xA8, 0x33, 0xDE, 0x59, 0xA0,
  0x13, 0x09, 0xA0, 0x13, 0x09, 0xA0, 0x13, 0x09, 0xA0, 0x13, 0x09, 0xA0, 0x13,
  // "Ł" (U+0141)
  0x10, 0x5A, 0x05, 0x60, 0x5A, 0x05, 0x60, 0x5A, 0x05, 0x60, 0x5A, 0x05, 0x60, 0x5A, 0x0A, 0x0C,
  0x50, 0x5C, 0x06, 0x30, 0x10, 0xAA, 0x0D, 0x05, 0x40, 0xBB, 0x05, 0x50, 0x40, 0xEA, 0x05, 0x60,
  0x5A, 0x05, 0x60, 0x5A, 0x86, 0x73, 0x33, 0x32, 0x05, 0xF8, 0x18, 0x05, 0xF0, 0x80,
  // "ł" (U+0142)
  0x10, 0x9A, 0x01, 0x20, 0x9A, 0x01, 0x20, 0x9A, 0x01, 0x20, 0x9A, 0x01, 0x20, 0x9A, 0x01, 0x20,
  0x9A, 0x08, 0x20, 0x9B, 0x81, 0x61, 0xCA, 0x81, 0xC3, 0xEB, 0x82, 0x10, 0x8E, 0xA0, 0x12, 0x09,
  0xA0, 0x12, 0x09, 0xA0, 0x12, 0x09, 0xA0, 0x12, 0x09, 0xA0, 0x11,
  // "Ń" (U+0143)
  0x60, 0x8A, 0x07, 0x70, 0x4A, 0x06, 0x78, 0x21, 0xEE, 0x37, 0x72, 0x05, 0xB0, 0x54, 0x06, 0xA0,
  0x5B, 0x0D, 0x40, 0x6A, 0x05, 0xC0, 0x73, 0x06, 0xA8, 0x55, 0xFE, 0xDF, 0xE1, 0x20, 0x6A, 0x82,
  0x5F, 0xE5, 0xA0, 0x92, 0x06, 0xA0, 0x5A, 0x10, 0xBA, 0x81, 0x30, 0x6A, 0x05, 0xA1, 0x03, 0xA8,
  0x1B, 0x06, 0xA0, 0x5A, 0x20, 0x9A, 0x00, 0x5A, 0x05, 0xA2, 0x83, 0x1E, 0xFD, 0x5A, 0x05, 0xA3,
  0x07, 0xA0, 0xCA, 0x05, 0xA4, 0x0D, 0xC0, 0x5A, 0x40, 0x4C, 0x05, 0xA5, 0x0B, 0xB0,
  // "ń" (U+0144)
  0x50, 0x8A, 0x07, 0x50, 0x4A, 0x06, 0x58, 0x21, 0xEE, 0x37, 0x68, 0x94, 0x9F, 0x83, 0xBE, 0xEA,
  0x20, 0x9F, 0xDE, 0xC8, 0x1E, 0x19, 0xA8, 0x2D, 0x43, 0xCA, 0x05, 0x09, 0xA0, 0x52, 0x04, 0xA0,
  0x70, 0x9A, 0x02, 0x20, 0x3A, 0x07, 0x09, 0xA0, 0x12, 0x03, 0xA0, 0x70, 0x9A, 0x01, 0x20, 0x3A,
  0x07, 0x09, 0xA0, 0x12, 0x03, 0xA0, 0x70, 0x9A, 0x01, 0x20, 0x3A, 0x07, 0x09, 0xA0, 0x12, 0x03,
  0xA0, 0x70,
  // "Ņ" (U+0145)
  0x05, 0xB0, 0x54, 0x06, 0xA0, 0x5B, 0x0D, 0x40, 0x6A, 0x05, 0xC0, 0x73, 0x06, 0xA8, 0x55, 0xFE,
  0xDF, 0xE1, 0x20, 0x6A, 0x82, 0x5F, 0xE5, 0xA0, 0x92, 0x06, 0xA0, 0x5A, 0x10, 0xBA, 0x81, 0x30,
  0x6A, 0x05, 0xA1, 0x03, 0xA8, 0x1B, 0x06, 0xA0, 0x5A, 0x20, 0x9A, 0x00, 0x5A, 0x05, 0xA2, 0x83,
  0x1E, 0xFD, 0x5A, 0x05, 0xA3, 0x07, 0xA0, 0xCA, 0x05, 0xA4, 0x0D, 0xC0, 0x5A, 0x40, 0x4C, 0x05,
  0xA5, 0x0B, 0xB7, 0x73, 0x81, 0x9D, 0x97, 0x28, 0x1D, 0xF3, 0x71, 0x81, 0x1F, 0xA5,
  // "ņ" (U+0146)
  0x89, 0x49, 0xF8, 0x3B, 0xEE, 0xA2, 0x09, 0xFD, 0xEC, 0x81, 0xE1, 0x9A, 0x82, 0xD4, 0x3C, 0xA0,
  0x50, 0x9A, 0x05, 0x20, 0x4A, 0x07, 0x09, 0xA0, 0x22, 0x03, 0xA0, 0x70, 0x9A, 0x01, 0x20, 0x3A,
  0x07, 0x09, 0xA0, 0x12, 0x03, 0xA0, 0x70, 0x9A, 0x01, 0x20, 0x3A, 0x07, 0x09, 0xA0, 0x12, 0x03,
  0xA0, 0x70, 0x9A, 0x01, 0x20, 0x3A, 0x07, 0x76, 0x82, 0x1D, 0xD4, 0x68, 0x14, 0xFC, 0x78, 0x18,
  0xF4, 0x40,
  // "Ň" (U+0147)
  0x28, 0x71, 0xEE, 0x40, 0x3D, 0xE2, 0x48, 0x23, 0xEF, 0x9A, 0x04, 0x60, 0x6B, 0x07, 0x77, 0x10,
  0x5B, 0x05, 0x40, 0x6A, 0x05, 0xB0, 0xD4, 0x06, 0xA0, 0x5C, 0x07, 0x30, 0x6A, 0x85, 0x5F, 0xED,
  0xFE, 0x12, 0x06, 0xA8, 0x25, 0xFE, 0x5A, 0x09, 0x20, 0x6A, 0x05, 0xA1, 0x0B, 0xA8, 0x13, 0x06,
  0xA0, 0x5A, 0x10, 0x3A, 0x81, 0xB0, 0x6A, 0x05, 0xA2, 0x09, 0xA0, 0x05, 0xA0, 0x5A, 0x28, 0x31,
  0xEF, 0xD5, 0xA0, 0x5A, 0x30, 0x7A, 0x0C, 0xA0, 0x5A, 0x40, 0xDC, 0x05, 0xA4, 0x04, 0xC0, 0x5A,
  0x50, 0xBB,
  // "ň" (U+0148)
  0x87, 0x1E, 0xE4, 0x03, 0xDE, 0x22, 0x82, 0x3E, 0xF9, 0xA0, 0x44, 0x06, 0xB0, 0x77, 0x68, 0x94,
  0x9F, 0x83, 0xBE, 0xEA, 0x20, 0x9F, 0xDE, 0xC8, 0x1E, 0x19, 0xA8, 0x2D, 0x43, 0xCA, 0x05, 0x09,
  0xA0, 0x52, 0x04, 0xA0, 0x70, 0x9A, 0x02, 0x20, 0x3A, 0x07, 0x09, 0xA0, 0x12, 0x03, 0xA0, 0x70,
  0x9A, 0x01, 0x20, 0x3A, 0x07, 0x09, 0xA0, 0x12, 0x03, 0xA0, 0x70, 0x9A, 0x01, 0x20, 0x3A, 0x07,
  0x09, 0xA0, 0x12, 0x03, 0xA0, 0x70,
  // "ŉ" (U+0149)
  0x1A, 0x08, 0x72, 0x03, 0xA0, 0x37, 0x28, 0x16, 0xFC, 0x73, 0x89, 0x2A, 0xF5, 0x9F, 0x83, 0xBE,
  0xEA, 0x24, 0x82, 0x9F, 0xDE, 0xC0, 0xE0, 0x13, 0x09, 0xA8, 0x2D, 0x43, 0xCA, 0x05, 0x30, 0x9A,
  0x05, 0x20, 0x4A, 0x07, 0x30, 0x9A, 0x02, 0x20, 0x3A, 0x07, 0x30, 0x9A, 0x01, 0x20, 0x3A, 0x07,
  0x30, 0x9A, 0x01, 0x20, 0x3A, 0x07, 0x30, 0x9A, 0x01, 0x20, 0x3A, 0x07, 0x30, 0x9A, 0x01, 0x20,
  0x3A, 0x07, 0x30, 0x9A, 0x01, 0x20, 0x3A, 0x07,
  // "Ŋ" (U+014A)
  0x05, 0xB0, 0x64, 0x06, 0xA0, 0x5B, 0x0E, 0x02, 0x30, 0x6A, 0x05, 0xC0, 0xC3, 0x06, 0xA8, 0x25,
  0xFE, 0xDA, 0x07, 0x20, 0x6A, 0x82, 0x5F, 0xE3, 0xB8, 0x13, 0x06, 0xA0, 0x5A, 0x10, 0x8A, 0x81,
  0xC0, 0x6A, 0x05, 0xA2, 0x0C, 0xA0, 0x80, 0x5A, 0x05, 0xA2, 0x02, 0xB0, 0x9A, 0x05, 0xA3, 0x06,
  0xD0, 0x5A, 0x40, 0xBC, 0x05, 0xA4, 0x01, 0x0E, 0xB0, 0x5A, 0x50, 0x5B, 0x05, 0xA6, 0x0A, 0xA7,
  0x20, 0x7A, 0x68, 0x43, 0x24, 0xDF, 0xC6, 0x0C, 0xC0, 0x56, 0x83, 0xAF, 0xEB, 0x41,
  // "ŋ" (U+014B)
  0x89, 0x19, 0xF9, 0x5C, 0xEE, 0xA2, 0x09, 0xF8, 0x1E, 0x19, 0xA8, 0x2D, 0x43, 0xBA, 0x05, 0x09,
  0xA0, 0x52, 0x04, 0xA0, 0x70, 0x9A, 0x02, 0x20, 0x3A, 0x07, 0x09, 0xA0, 0x12, 0x03, 0xA0, 0x70,
  0x9A, 0x01, 0x20, 0x3A, 0x07, 0x09, 0xA0, 0x12, 0x03, 0xA0, 0x70, 0x9A, 0x01, 0x20, 0x3A, 0x07,
  0x09, 0xA0, 0x12, 0x03, 0xA0, 0x76, 0x03, 0xA0, 0x74, 0x81, 0x12, 0x9A, 0x06, 0x40, 0x5C, 0x01,
  0x48, 0x34, 0xEF, 0xC4, 0x10,
  // "Ō" (U+014C)
  0x38, 0x01, 0x20, 0x16, 0x04, 0xD0, 0xA6, 0x04, 0xD0, 0xA7, 0x75, 0x86, 0x17, 0xCE, 0xED, 0x93,
  0x40, 0x30, 0xEF, 0x06, 0x30, 0xDA, 0x83, 0x93, 0x26, 0xEA, 0x81, 0x40, 0x6A, 0x09, 0x40, 0x4A,
  0x81, 0xB0, 0xBA, 0x02, 0x50, 0xDA, 0x01, 0x0D, 0xA6, 0x0A, 0xA8, 0x22, 0xEF, 0xE6, 0x09, 0xA0,
  0x40, 0xDA, 0x60, 0xAA, 0x02, 0x0B, 0xA0, 0x35, 0x0D, 0xA0, 0x10, 0x6A, 0x09, 0x40, 0x4A, 0x0B,
  0x20, 0xDA, 0x83, 0x93, 0x26, 0xEA, 0x03, 0x20, 0x30, 0xDF, 0x06, 0x48, 0x61, 0x7C, 0xEE, 0xD9,
  0x33,
  // "ō" (U+014D)
  0x38, 0x01, 0x20, 0x14, 0x04, 0xD0, 0xA4, 0x04, 0xD0, 0xA7, 0x71, 0x85, 0x19, 0xDF, 0xD9, 0x23,
  0x02, 0x0E, 0xD0, 0xE0, 0x22, 0x0A, 0xA8, 0x17, 0x36, 0xA0, 0xC2, 0xA0, 0xB3, 0x09, 0xA0, 0x02,
  0xA0, 0x93, 0x07, 0xA0, 0x40, 0x2A, 0x09, 0x30, 0x7A, 0x04, 0x1A, 0x0C, 0x30, 0xAA, 0x81, 0x20,
  0x9A, 0x81, 0x73, 0x6A, 0x0C, 0x20, 0x10, 0xDD, 0x0E, 0x03, 0x38, 0x51, 0x8D, 0xFE, 0xA2, 0x20,
  // "Ŏ" (U+014E)
  0x28, 0x62, 0xF9, 0x32, 0x6F, 0x76, 0x0C, 0xC0, 0xE0, 0x26, 0x84, 0x19, 0xEE, 0xB3, 0x77, 0x58,
  0x61, 0x7C, 0xEE, 0xD9, 0x34, 0x03, 0x0E, 0xF0, 0x63, 0x0D, 0xA8, 0x39, 0x32, 0x6E, 0xA8, 0x14,
  0x06, 0xA0, 0x94, 0x04, 0xA8, 0x1B, 0x0B, 0xA0, 0x25, 0x0D, 0xA0, 0x10, 0xDA, 0x60, 0xAA, 0x82,
  0x2E, 0xFE, 0x60, 0x9A, 0x04, 0x0D, 0xA6, 0x0A, 0xA0, 0x20, 0xBA, 0x03, 0x50, 0xDA, 0x01, 0x06,
  0xA0, 0x94, 0x04, 0xA0, 0xB2, 0x0D, 0xA8, 0x39, 0x32, 0x6E, 0xA0, 0x32, 0x03, 0x0D, 0xF0, 0x64,
  0x86, 0x17, 0xCE, 0xED, 0x93, 0x30,
  // "ŏ" (U+014F)
  0x18, 0x62, 0xF9, 0x32, 0x6F, 0x74, 0x0C, 0xC0, 0xE0, 0x24, 0x84, 0x19, 0xEE, 0xB3, 0x77, 0x28,
  0x51, 0x9D, 0xFD, 0x92, 0x30, 0x20, 0xED, 0x0E, 0x02, 0x20, 0xAA, 0x81, 0x73, 0x6A, 0x0C, 0x2A,
  0x0B, 0x30, 0x9A, 0x00, 0x2A, 0x09, 0x30, 0x7A, 0x04, 0x02, 0xA0, 0x93, 0x07, 0xA0, 0x41, 0xA0,
  0xC3, 0x0A, 0xA8, 0x12, 0x09, 0xA8, 0x17, 0x36, 0xA0, 0xC2, 0x01, 0x0D, 0xD0, 0xE0, 0x33, 0x85,
  0x18, 0xDF, 0xEA, 0x22,
  // "Ő" (U+0150)
  0x58, 0x5B, 0xDB, 0x4D, 0xD4, 0x58, 0x56, 0xFD, 0x2D, 0xF6, 0x58, 0x51, 0xEB, 0x19, 0xE4, 0x77,
  0x48, 0x61, 0x7C, 0xEE, 0xD9, 0x34, 0x03, 0x0E, 0xF0, 0x63, 0x0D, 0xA8, 0x39, 0x32, 0x6E, 0xA8,
  0x14, 0x06, 0xA0, 0x94, 0x04, 0xA8, 0x1B, 0x0B, 0xA0, 0x25, 0x0D, 0xA0, 0x10, 0xDA, 0x60, 0xAA,
  0x82, 0x2E, 0xFE, 0x60, 0x9A, 0x04, 0x0D, 0xA6, 0x0A, 0xA0, 0x20, 0xBA, 0x03, 0x50, 0xDA, 0x01,
  0x06, 0xA0, 0x94, 0x04, 0xA0, 0xB2, 0x0D, 0xA8, 0x39, 0x32, 0x6E, 0xA0, 0x32, 0x03, 0x0D, 0xF0,
  0x64, 0x86, 0x17, 0xCE, 0xED, 0x93, 0x30,
  // "ő" (U+0151)
  0x48, 0x5B, 0xDB, 0x4D, 0xD4, 0x38, 0x56, 0xFD, 0x2D, 0xF6, 0x38, 0x51, 0xEB, 0x19, 0xE4, 0x77,
  0x18, 0x51, 0x9D, 0xFD, 0x92, 0x30, 0x20, 0xED, 0x0E, 0x02, 0x20, 0xAA, 0x81, 0x73, 0x6A, 0x0C,
  0x2A, 0x0B, 0x30, 0x9A, 0x00, 0x2A, 0x09, 0x30, 0x7A, 0x04, 0x02, 0xA0, 0x93, 0x07, 0xA0, 0x41,
  0xA0, 0xC3, 0x0A, 0xA8, 0x12, 0x09, 0xA8, 0x17, 0x36, 0xA0, 0xC2, 0x01, 0x0D, 0xD0, 0xE0, 0x33,
  0x85, 0x18, 0xDF, 0xEA, 0x22,
  // "Œ" (U+0152)
  0x28, 0x22, 0x8D, 0xEF, 0xA8, 0x27, 0x04, 0xEF, 0xD8, 0x17, 0x1E, 0xA8, 0x27, 0x33, 0x7A, 0x85,
  0x92, 0x22, 0x21, 0x7A, 0x08, 0x30, 0x3A, 0x07, 0x50, 0xBA, 0x01, 0x30, 0x3A, 0x07, 0x58, 0x1D,
  0xFE, 0x40, 0x3F, 0x82, 0x1E, 0xFD, 0x40, 0x3F, 0x82, 0x1D, 0xFE, 0x40, 0x3A, 0x85, 0x92, 0x22,
  0x20, 0xBA, 0x01, 0x30, 0x3A, 0x07, 0x50, 0x7A, 0x07, 0x30, 0x3A, 0x07, 0x50, 0x10, 0xEA, 0x82,
  0x72, 0x27, 0xA8, 0x79, 0x22, 0x22, 0x10, 0x4E, 0xFD, 0x07, 0x28, 0x22, 0x9D, 0xEF, 0xA0, 0x70,
  // "œ" (U+0153)
  0x28, 0x93, 0x19, 0xDF, 0xD8, 0x01, 0x9E, 0xFD, 0x83, 0x02, 0x0E, 0xD0, 0xC0, 0xDD, 0x0C, 0x20,
  0xBA, 0x81, 0x73, 0x6B, 0x82, 0xE5, 0x37, 0xA0, 0x61, 0xA0, 0xB3, 0x09, 0xA8, 0x68, 0x22, 0x2C,
  0xFB, 0x2A, 0x09, 0x30, 0x7F, 0x90, 0xC0, 0x2A, 0x09, 0x30, 0x7F, 0x90, 0xC1, 0xA0, 0xC3, 0x0A,
  0xA0, 0x67, 0x09, 0xA8, 0x17, 0x36, 0xB8, 0x90, 0xE6, 0x33, 0x48, 0x20, 0x1D, 0xD0, 0x0D, 0xE0,
  0x42, 0x89, 0x01, 0x8D, 0xFE, 0x91, 0x18, 0xDA, 0x81, 0xD8, 0x10,
  // "Ŕ" (U+0154)
  0x50, 0x8A, 0x07, 0x60, 0x4A, 0x06, 0x68, 0x21, 0xEE, 0x37, 0x71, 0x05, 0xC8, 0x1E, 0xB6, 0x30,
  0x5F, 0x0B, 0x20, 0x5A, 0x82, 0x62, 0x5D, 0xA8, 0x14, 0x05, 0xA0, 0x52, 0x05, 0xA8, 0x17, 0x05,
  0xA0, 0x52, 0x05, 0xA8, 0x16, 0x05, 0xA8, 0x76, 0x25, 0xDF, 0xE1, 0x05, 0xE0, 0xE0, 0x52, 0x05,
  0xE0, 0x53, 0x05, 0xA8, 0x35, 0x0D, 0xFC, 0x30, 0x5A, 0x81, 0x50, 0x4A, 0x08, 0x20, 0x5A, 0x05,
  0x20, 0xAA, 0x81, 0x30, 0x5A, 0x05, 0x28, 0x41, 0xEF, 0xD0, 0x5A, 0x05, 0x30, 0x6A, 0x08,
  // "ŕ" (U+0155)
  0x30, 0x8A, 0x07, 0x20, 0x4A, 0x06, 0x28, 0x21, 0xEE, 0x37, 0x28, 0x91, 0x9F, 0x81, 0xAE, 0xB9,
  0xFD, 0xDA, 0x0A, 0x09, 0xA8, 0x3E, 0x73, 0x19, 0xA0, 0x53, 0x09, 0xA0, 0x13, 0x09, 0xA0, 0x13,
  0x09, 0xA0, 0x13, 0x09, 0xA0, 0x13, 0x09, 0xA0, 0x13, 0x09, 0xA0, 0x13,
  // "Ŗ" (U+0156)
  0x05, 0xC8, 0x1E, 0xB6, 0x30, 0x5F, 0x0A, 0x20, 0x5A, 0x82, 0x62, 0x5D, 0xA8, 0x13, 0x05, 0xA0,
  0x52, 0x05, 0xA8, 0x17, 0x05, 0xA0, 0x52, 0x05, 0xA8, 0x16, 0x05, 0xA8, 0x25, 0x03, 0xCA, 0x81,
  0x20, 0x5F, 0x06, 0x20, 0x5E, 0x05, 0x30, 0x5A, 0x83, 0x62, 0xEF, 0xB3, 0x05, 0xA8, 0x15, 0x05,
  0xA0, 0x72, 0x05, 0xA0, 0x52, 0x0B, 0xA8, 0x12, 0x05, 0xA0, 0x52, 0x84, 0x2E, 0xFC, 0x05, 0xA0,
  0x53, 0x07, 0xA0, 0x87, 0x71, 0x81, 0x8D, 0xB7, 0x18, 0x1C, 0xF5, 0x71, 0x90, 0xC5,
  // "ŗ" (U+0157)
  0x89, 0x19, 0xF8, 0x1A, 0xEB, 0x9F, 0xDD, 0xA0, 0xA0, 0x9A, 0x83, 0xE7, 0x31, 0x9A, 0x05, 0x30,
  0x9A, 0x01, 0x30, 0x9A, 0x01, 0x30, 0x9A, 0x01, 0x30, 0x9A, 0x01, 0x30, 0x9A, 0x01, 0x30, 0x9A,
  0x01, 0x73, 0x82, 0x3D, 0xD2, 0x38, 0x16, 0xFB, 0x48, 0x19, 0xF2, 0x40,
  // "Ř" (U+0158)
  0x18, 0x71, 0xEE, 0x40, 0x3D, 0xE2, 0x38, 0x23, 0xEF, 0x9A, 0x04, 0x50, 0x6B, 0x07, 0x77, 0x05,
  0xC8, 0x1E, 0xB6, 0x30, 0x5F, 0x0B, 0x20, 0x5A, 0x82, 0x62, 0x5D, 0xA8, 0x14, 0x05, 0xA0, 0x52,
  0x05, 0xA8, 0x17, 0x05, 0xA0, 0x52, 0x05, 0xA8, 0x16, 0x05, 0xA8, 0x76, 0x25, 0xDF, 0xE1, 0x05,
  0xE0, 0xE0, 0x52, 0x05, 0xE0, 0x53, 0x05, 0xA8, 0x35, 0x0D, 0xFC, 0x30, 0x5A, 0x81, 0x50, 0x4A,
  0x08, 0x20, 0x5A, 0x05, 0x20, 0xAA, 0x81, 0x30, 0x5A, 0x05, 0x28, 0x41, 0xEF, 0xD0, 0x5A, 0x05,
  0x30, 0x6A, 0x08,
  // "ř" (U+0159)
  0x89, 0x41, 0xEE, 0x40, 0x3D, 0xE2, 0x03, 0xEF, 0x9A, 0x04, 0x30, 0x6B, 0x07, 0x75, 0x85, 0x9F,
  0x81, 0xAE, 0xB2, 0x82, 0x9F, 0xDD, 0xA0, 0xA2, 0x09, 0xA8, 0x2E, 0x73, 0x12, 0x09, 0xA0, 0x55,
  0x09, 0xA0, 0x15, 0x09, 0xA0, 0x15, 0x09, 0xA0, 0x15, 0x09, 0xA0, 0x15, 0x09, 0xA0, 0x15, 0x09,
  0xA0, 0x14,
  // "Ś" (U+015A)
  0x50, 0x8A, 0x07, 0x50, 0x4A, 0x06, 0x58, 0x21, 0xEE, 0x37, 0x71, 0x85, 0x3A, 0xDE, 0xDA, 0x52,
  0x05, 0xE0, 0xD2, 0x86, 0xDF, 0xE4, 0x35, 0xB7, 0x2A, 0x0A, 0x70, 0xEA, 0x05, 0x60, 0x6B, 0x0C,
  0x04, 0x50, 0x7C, 0x0B, 0x01, 0x40, 0x20, 0x9B, 0x0A, 0x60, 0x30, 0xDA, 0x01, 0x60, 0x8A, 0x89,
  0x22, 0x2E, 0x84, 0x24, 0xDF, 0xE0, 0x2F, 0x06, 0x28, 0x57, 0xCE, 0xFE, 0xB4, 0x20,
  // "ś" (U+015B)
  0x40, 0x8A, 0x07, 0x40, 0x4A, 0x06, 0x48, 0x21, 0xEE, 0x37, 0x68, 0x51, 0x9D, 0xFE, 0xB6, 0x20,
  0xDD, 0x81, 0xD0, 0x2A, 0x85, 0xA2, 0x48, 0x60, 0x1A, 0x0D, 0x04, 0x50, 0x6B, 0x0D, 0x06, 0x48,
  0x11, 0x8E, 0xA0, 0xB6, 0x0A, 0xA8, 0x52, 0x2A, 0x63, 0x2A, 0xA0, 0x30, 0x2E, 0x83, 0xC0, 0x19,
  0xDA, 0x81, 0xD9, 0x11,
  // "Ŝ" (U+015C)
  0x30, 0x5B, 0x07, 0x48, 0x23, 0xEF, 0x9A, 0x03, 0x28, 0x71, 0xDE, 0x40, 0x4D, 0xE2, 0x75, 0x85,
  0x3A, 0xDE, 0xDA, 0x52, 0x05, 0xE0, 0xD2, 0x86, 0xDF, 0xE4, 0x35, 0xB7, 0x2A, 0x0A, 0x70, 0xEA,
  0x05, 0x60, 0x6B, 0x0C, 0x04, 0x50, 0x7C, 0x0B, 0x01, 0x40, 0x20, 0x9B, 0x0A, 0x60, 0x30, 0xDA,
  0x01, 0x60, 0x8A, 0x89, 0x22, 0x2E, 0x84, 0x24, 0xDF, 0xE0, 0x2F, 0x06, 0x28, 0x57, 0xCE, 0xFE,
  0xB4, 0x20,
  // "ŝ" (U+015D)
  0x20, 0x5B, 0x07, 0x38, 0x23, 0xEF, 0x9A, 0x89, 0x13, 0x01, 0xDE, 0x40, 0x4D, 0xE2, 0x73, 0x85,
  0x19, 0xDF, 0xEB, 0x62, 0x0D, 0xD8, 0x1D, 0x02, 0xA8, 0x5A, 0x24, 0x86, 0x01, 0xA0, 0xD0, 0x45,
  0x06, 0xB0, 0xD0, 0x64, 0x81, 0x18, 0xEA, 0x0B, 0x60, 0xAA, 0x85, 0x22, 0xA6, 0x32, 0xAA, 0x03,
  0x02, 0xE8, 0x3C, 0x01, 0x9D, 0xA8, 0x1D, 0x91, 0x10,
  // "Ş" (U+015E)
  0x28, 0x53, 0xAD, 0xED, 0xA5, 0x20, 0x5E, 0x0D, 0x28, 0x6D, 0xFE, 0x43, 0x5B, 0x72, 0xA0, 0xA7,
  0x0E, 0xA0, 0x56, 0x06, 0xB0, 0xC0, 0x45, 0x07, 0xC0, 0xB0, 0x14, 0x02, 0x09, 0xB0, 0xA6, 0x03,
  0x0D, 0xA0, 0x16, 0x08, 0xA8, 0x92, 0x22, 0xE8, 0x42, 0x4D, 0xFE, 0x02, 0xF0, 0x62, 0x81, 0x7C,
  0xEA, 0x0B, 0x04, 0x58, 0x18, 0xF8, 0x78, 0x25, 0xDF, 0x75, 0x83, 0x12, 0x9F, 0x95, 0x05, 0xA0,
  0xE0, 0x35, 0x82, 0x14, 0x41, 0x40,
  // "ş" (U+015F)
  0x18, 0x51, 0x9D, 0xFE, 0xB6, 0x20, 0xDD, 0x81, 0xD0, 0x2A, 0x85, 0xA2, 0x48, 0x60, 0x1A, 0x0D,
  0x04, 0x50, 0x6B, 0x0D, 0x06, 0x48, 0x11, 0x8E, 0xA0, 0xB6, 0x0A, 0xA8, 0x52, 0x2A, 0x63, 0x2A,
  0xA0, 0x30, 0x2E, 0x83, 0xC0, 0x19, 0xDA, 0x81, 0xE9, 0x14, 0x81, 0x8F, 0x86, 0x82, 0x5D, 0xF7,
  0x48, 0x31, 0x29, 0xF9, 0x40, 0x5A, 0x0E, 0x03, 0x48, 0x21, 0x44, 0x13,
  // "Š" (U+0160)
  0x18, 0x71, 0xEE, 0x40, 0x3D, 0xE2, 0x28, 0x23, 0xEF, 0x9A, 0x04, 0x40, 0x6B, 0x07, 0x77, 0x85,
  0x3A, 0xDE, 0xDA, 0x52, 0x05, 0xE0, 0xD2, 0x86, 0xDF, 0xE4, 0x35, 0xB7, 0x2A, 0x0A, 0x70, 0xEA,
  0x05, 0x60, 0x6B, 0x0C, 0x04, 0x50, 0x7C, 0x0B, 0x01, 0x40, 0x20, 0x9B, 0x0A, 0x60, 0x30, 0xDA,
  0x01, 0x60, 0x8A, 0x89, 0x22, 0x2E, 0x84, 0x24, 0xDF, 0xE0, 0x2F, 0x06, 0x28, 0x57, 0xCE, 0xFE,
  0xB4, 0x20,
  // "š" (U+0161)
  0x89, 0x41, 0xEE, 0x40, 0x3D, 0xE2, 0x03, 0xEF, 0x9A, 0x04, 0x30, 0x6B, 0x07, 0x75, 0x85, 0x19,
  0xDF, 0xEB, 0x62, 0x0D, 0xD8, 0x1D, 0x02, 0xA8, 0x5A, 0x24, 0x86, 0x01, 0xA0, 0xD0, 0x45, 0x06,
  0xB0, 0xD0, 0x64, 0x81, 0x18, 0xEA, 0x0B, 0x60, 0xAA, 0x85, 0x22, 0xA6, 0x32, 0xAA, 0x03, 0x02,
  0xE8, 0x3C, 0x01, 0x9D, 0xA8, 0x1D, 0x91, 0x10,
  // "Ţ" (U+0162)
  0x09, 0xFA, 0x01, 0x09, 0xFA, 0x83, 0x11, 0x22, 0x4A, 0x09, 0x0F, 0x24, 0x02, 0xA0, 0x87, 0x02,
  0xA0, 0x87, 0x02, 0xA0, 0x87, 0x02, 0xA0, 0x87, 0x02, 0xA0, 0x87, 0x02, 0xA0, 0x87, 0x02, 0xA0,
  0x87, 0x02, 0xA0, 0x87, 0x02, 0xA0, 0x87, 0x02, 0xA0, 0x97, 0x18, 0x18, 0xF8, 0x71, 0x82, 0x5D,
  0xF7, 0x68, 0x31, 0x29, 0xF9, 0x60, 0x5A, 0x0E, 0x03, 0x68, 0x21, 0x44, 0x14,
  // "ţ" (U+0163)
  0x28, 0x18, 0xF5, 0x58, 0x1D, 0xF5, 0x30, 0x20, 0xBD, 0x01, 0x09, 0xE8, 0x11, 0x16, 0xA8, 0x17,
  0x22, 0x20, 0x4A, 0x05, 0x40, 0x4A, 0x05, 0x40, 0x4A, 0x05, 0x40, 0x4A, 0x05, 0x40, 0x3A, 0x82,
  0xA2, 0x31, 0x20, 0xEC, 0x03, 0x20, 0x30, 0xDA, 0x0C, 0x02, 0x38, 0x18, 0xF8, 0x58, 0x25, 0xDF,
  0x73, 0x83, 0x12, 0x9F, 0x93, 0x05, 0xA0, 0xE0, 0x33, 0x82, 0x14, 0x41, 0x20,
  // "Ť" (U+0164)
  0x18, 0x71, 0xEE, 0x40, 0x3D, 0xE2, 0x38, 0x23, 0xEF, 0x9A, 0x04, 0x50, 0x6B, 0x07, 0x77, 0x09,
  0xFA, 0x01, 0x09, 0xFA, 0x83, 0x11, 0x22, 0x4A, 0x09, 0x0F, 0x24, 0x02, 0xA0, 0x87, 0x02, 0xA0,
  0x87, 0x02, 0xA0, 0x87, 0x02, 0xA0, 0x87, 0x02, 0xA0, 0x87, 0x02, 0xA0, 0x87, 0x02, 0xA0, 0x87,
  0x02, 0xA0, 0x87, 0x02, 0xA0, 0x87, 0x02, 0xA0, 0x84,
  // "ť" (U+0165)
  0x70, 0x4A, 0x01, 0x28, 0x11, 0x31, 0x28, 0x17, 0xF9, 0x38, 0x19, 0xF5, 0x28, 0x19, 0xD1, 0x38,
  0x1E, 0xF5, 0x60, 0x20, 0xBD, 0x01, 0x30, 0x9E, 0x01, 0x30, 0x10, 0x6A, 0x81, 0x72, 0x25, 0x04,
  0xA0, 0x57, 0x04, 0xA0, 0x57, 0x04, 0xA0, 0x57, 0x04, 0xA0, 0x57, 0x03, 0xA8, 0x2A, 0x23, 0x15,
  0x0E, 0xC0, 0x35, 0x84, 0x3C, 0xFE, 0xC2, 0x30,
  // "Ŧ" (U+0166)
  0x09, 0xFA, 0x01, 0x09, 0xFA, 0x83, 0x11, 0x22, 0x4A, 0x09, 0x0F, 0x24, 0x02, 0xA0, 0x87, 0x02,
  0xA0, 0x86, 0x02, 0x04, 0xA8, 0x19, 0x21, 0x30, 0x5E, 0x0B, 0x30, 0x5E, 0x0B, 0x50, 0x2A, 0x08,
  0x70, 0x2A, 0x08, 0x70, 0x2A, 0x08, 0x70, 0x2A, 0x08, 0x70, 0x2A, 0x08, 0x40,
  // "ŧ" (U+0167)
  0x28, 0x18, 0xF5, 0x58, 0x1D, 0xF5, 0x30, 0x20, 0xBD, 0x01, 0x09, 0xE8, 0x11, 0x16, 0xA8, 0x17,
  0x22, 0x20, 0x4A, 0x05, 0x30, 0x6D, 0x81, 0xC0, 0x6D, 0x82, 0xC0, 0x16, 0xA8, 0x17, 0x22, 0x20,
  0x4A, 0x84, 0x92, 0x31, 0x01, 0xD0, 0x32, 0x84, 0x5C, 0xEE, 0xC2,
  // "Ũ" (U+0168)
  0x28, 0x53, 0xDE, 0x83, 0xAE, 0x50, 0xDD, 0x09, 0x48, 0x62, 0xF6, 0x4A, 0xEB, 0x17, 0x71, 0x07,
  0xA0, 0x34, 0x09, 0xA0, 0x10, 0x7A, 0x03, 0x40, 0x9A, 0x01, 0x07, 0xA0, 0x34, 0x09, 0xA0, 0x10,
  0x7A, 0x03, 0x40, 0x9A, 0x01, 0x07, 0xA0, 0x34, 0x09, 0xA0, 0x10, 0x7A, 0x03, 0x40, 0x9A, 0x01,
  0x07, 0xA0, 0x34, 0x09, 0xA0, 0x10, 0x7A, 0x03, 0x40, 0x9A, 0x01, 0x06, 0xA0, 0x54, 0x0B, 0xA1,
  0x04, 0xA0, 0x94, 0x81, 0xEF, 0xE2, 0x0E, 0xA8, 0x29, 0x55, 0xCA, 0x08, 0x20, 0x4F, 0x0C, 0x48,
  0x53, 0xAD, 0xFE, 0xC7, 0x30,
  // "ũ" (U+0169)
  0x28, 0x53, 0xDE, 0x83, 0xAE, 0x30, 0xDD, 0x09, 0x28, 0x62, 0xF6, 0x4A, 0xEB, 0x17, 0x40, 0xAA,
  0x30, 0x4A, 0x06, 0x0A, 0xA3, 0x04, 0xA0, 0x60, 0xAA, 0x30, 0x4A, 0x06, 0x0A, 0xA3, 0x04, 0xA0,
  0x60, 0xAA, 0x30, 0x4A, 0x06, 0x0A, 0xA3, 0x05, 0xA0, 0x60, 0xAA, 0x01, 0x20, 0x7A, 0x06, 0x08,
  0xA8, 0x28, 0x03, 0xDA, 0x06, 0x03, 0xD0, 0xEA, 0x89, 0x16, 0x04, 0xBE, 0xEA, 0x2B, 0xF6,
  // "Ū" (U+016A)
  0x38, 0x01, 0x20, 0x15, 0x04, 0xD0, 0xA5, 0x04, 0xD0, 0xA7, 0x71, 0x07, 0xA0, 0x34, 0x09, 0xA0,
  0x10, 0x7A, 0x03, 0x40, 0x9A, 0x01, 0x07, 0xA0, 0x34, 0x09, 0xA0, 0x10, 0x7A, 0x03, 0x40, 0x9A,
  0x01, 0x07, 0xA0, 0x34, 0x09, 0xA0, 0x10, 0x7A, 0x03, 0x40, 0x9A, 0x01, 0x07, 0xA0, 0x34, 0x09,
  0xA0, 0x10, 0x7A, 0x03, 0x40, 0x9A, 0x01, 0x06, 0xA0, 0x54, 0x0B, 0xA1, 0x04, 0xA0, 0x94, 0x81,
  0xEF, 0xE2, 0x0E, 0xA8, 0x29, 0x55, 0xCA, 0x08, 0x20, 0x4F, 0x0C, 0x48, 0x53, 0xAD, 0xFE, 0xC7,
  0x30,
  // "ū" (U+016B)
  0x28, 0x01, 0x20, 0x13, 0x04, 0xD0, 0xA3, 0x04, 0xD0, 0xA7, 0x50, 0xAA, 0x30, 0x4A, 0x06, 0x0A,
  0xA3, 0x04, 0xA0, 0x60, 0xAA, 0x30, 0x4A, 0x06, 0x0A, 0xA3, 0x04, 0xA0, 0x60, 0xAA, 0x30, 0x4A,
  0x06, 0x0A, 0xA3, 0x05, 0xA0, 0x60, 0xAA, 0x01, 0x20, 0x7A, 0x06, 0x08, 0xA8, 0x28, 0x03, 0xDA,
  0x06, 0x03, 0xD0, 0xEA, 0x89, 0x16, 0x04, 0xBE, 0xEA, 0x2B, 0xF6,
  // "Ŭ" (U+016C)
  0x28, 0x62, 0xF9, 0x32, 0x6F, 0x75, 0x0C, 0xC0, 0xE0, 0x25, 0x84, 0x19, 0xEE, 0xB3, 0x77, 0x10,
  0x7A, 0x03, 0x40, 0x9A, 0x01, 0x07, 0xA0, 0x34, 0x09, 0xA0, 0x10, 0x7A, 0x03, 0x40, 0x9A, 0x01,
  0x07, 0xA0, 0x34, 0x09, 0xA0, 0x10, 0x7A, 0x03, 0x40, 0x9A, 0x01, 0x07, 0xA0, 0x34, 0x09, 0xA0,
  0x10, 0x7A, 0x03, 0x40, 0x9A, 0x01, 0x07, 0xA0, 0x34, 0x09, 0xA0, 0x10, 0x6A, 0x05, 0x40, 0xBA,
  0x10, 0x4A, 0x09, 0x48, 0x1E, 0xFE, 0x20, 0xEA, 0x82, 0x95, 0x5C, 0xA0, 0x82, 0x04, 0xF0, 0xC4,
  0x85, 0x3A, 0xDF, 0xEC, 0x73,
  // "ŭ" (U+016D)
  0x18, 0x62, 0xF9, 0x32, 0x6F, 0x73, 0x0C, 0xC0, 0xE0, 0x23, 0x84, 0x19, 0xEE, 0xB3, 0x75, 0x0A,
  0xA3, 0x04, 0xA0, 0x60, 0xAA, 0x30, 0x4A, 0x06, 0x0A, 0xA3, 0x04, 0xA0, 0x60, 0xAA, 0x30, 0x4A,
  0x06, 0x0A, 0xA3, 0x04, 0xA0, 0x60, 0xAA, 0x30, 0x5A, 0x06, 0x0A, 0xA0, 0x12, 0x07, 0xA0, 0x60,
  0x8A, 0x82, 0x80, 0x3D, 0xA0, 0x60, 0x3D, 0x0E, 0xA8, 0x91, 0x60, 0x4B, 0xEE, 0xA2, 0xBF, 0x60,
  // "Ů" (U+016E)
  0x48, 0x28, 0xED, 0x57, 0x82, 0x2F, 0x37, 0x97, 0x82, 0x2F, 0x37, 0x97, 0x18, 0x28, 0xED, 0x57,
  0x72, 0x07, 0xA0, 0x34, 0x09, 0xA0, 0x10, 0x7A, 0x03, 0x40, 0x9A, 0x01, 0x07, 0xA0, 0x34, 0x09,
  0xA0, 0x10, 0x7A, 0x03, 0x40, 0x9A, 0x01, 0x07, 0xA0, 0x34, 0x09, 0xA0, 0x10, 0x7A, 0x03, 0x40,
  0x9A, 0x01, 0x07, 0xA0, 0x34, 0x09, 0xA0, 0x10, 0x7A, 0x03, 0x40, 0x9A, 0x01, 0x06, 0xA0, 0x54,
  0x0B, 0xA1, 0x04, 0xA0, 0x94, 0x81, 0xEF, 0xE2, 0x0E, 0xA8, 0x29, 0x55, 0xCA, 0x08, 0x20, 0x4F,
  0x0C, 0x48, 0x53, 0xAD, 0xFE, 0xC7, 0x30,
  // "ů" (U+016F)
  0x38, 0x28, 0xED, 0x55, 0x82, 0x2F, 0x37, 0x95, 0x82, 0x2F, 0x37, 0x96, 0x82, 0x8E, 0xD5, 0x76,
  0x0A, 0xA3, 0x04, 0xA0, 0x60, 0xAA, 0x30, 0x4A, 0x06, 0x0A, 0xA3, 0x04, 0xA0, 0x60, 0xAA, 0x30,
  0x4A, 0x06, 0x0A, 0xA3, 0x04, 0xA0, 0x60, 0xAA, 0x30, 0x5A, 0x06, 0x0A, 0xA0, 0x12, 0x07, 0xA0,
  0x60, 0x8A, 0x82, 0x80, 0x3D, 0xA0, 0x60, 0x3D, 0x0E, 0xA8, 0x91, 0x60, 0x4B, 0xEE, 0xA2, 0xBF,
  0x60,
  // "Ű" (U+0170)
  0x58, 0x5B, 0xDB, 0x4D, 0xD4, 0x48, 0x56, 0xFD, 0x2D, 0xF6, 0x48, 0x51, 0xEB, 0x19, 0xE4, 0x77,
  0x07, 0xA0, 0x34, 0x09, 0xA0, 0x10, 0x7A, 0x03, 0x40, 0x9A, 0x01, 0x07, 0xA0, 0x34, 0x09, 0xA0,
  0x10, 0x7A, 0x03, 0x40, 0x9A, 0x01, 0x07, 0xA0, 0x34, 0x09, 0xA0, 0x10, 0x7A, 0x03, 0x40, 0x9A,
  0x01, 0x07, 0xA0, 0x34, 0x09, 0xA0, 0x10, 0x7A, 0x03, 0x40, 0x9A, 0x01, 0x06, 0xA0, 0x54, 0x0B,
  0xA1, 0x04, 0xA0, 0x94, 0x81, 0xEF, 0xE2, 0x0E, 0xA8, 0x29, 0x55, 0xCA, 0x08, 0x20, 0x4F, 0x0C,
  0x48, 0x53, 0xAD, 0xFE, 0xC7, 0x30,
  // "ű" (U+0171)
  0x48, 0x5B, 0xDB, 0x4D, 0xD4, 0x38, 0x56, 0xFD, 0x2D, 0xF6, 0x38, 0x51, 0xEB, 0x19, 0xE4, 0x76,
  0x0A, 0xA3, 0x04, 0xA8, 0x16, 0x0A, 0xA3, 0x04, 0xA8, 0x16, 0x0A, 0xA3, 0x04, 0xA8, 0x16, 0x0A,
  0xA3, 0x04, 0xA8, 0x16, 0x0A, 0xA3, 0x04, 0xA8, 0x16, 0x0A, 0xA3, 0x05, 0xA8, 0x16, 0x0A, 0xA0,
  0x12, 0x07, 0xA8, 0x16, 0x08, 0xA8, 0x28, 0x03, 0xDA, 0x81, 0x60, 0x3D, 0x0E, 0xA0, 0x62, 0x87,
  0x4B, 0xEE, 0xA2, 0xBF, 0x61,
  // "Ų" (U+0172)
  0x07, 0xA0, 0x34, 0x09, 0xA0, 0x10, 0x7A, 0x03, 0x40, 0x9A, 0x01, 0x07, 0xA0, 0x34, 0x09, 0xA0,
  0x10, 0x7A, 0x03, 0x40, 0x9A, 0x01, 0x07, 0xA0, 0x34, 0x09, 0xA0, 0x10, 0x7A, 0x03, 0x40, 0x9A,
  0x01, 0x07, 0xA0, 0x34, 0x09, 0xA0, 0x10, 0x7A, 0x03, 0x40, 0x9A, 0x01, 0x06, 0xA0, 0x54, 0x0B,
  0xA1, 0x04, 0xA0, 0x94, 0x81, 0xEF, 0xC2, 0x0E, 0xA8, 0x29, 0x55, 0xCA, 0x04, 0x20, 0x4F, 0x05,
  0x48, 0x13, 0xAD, 0xB0, 0x57, 0x20, 0x90, 0xD7, 0x39, 0x81, 0xD3, 0x17, 0x1B, 0x06, 0x71, 0x82,
  0x6E, 0xE5, 0x20,
  // "ų" (U+0173)
  0x0A, 0xA3, 0x04, 0xA0, 0x60, 0xAA, 0x30, 0x4A, 0x06, 0x0A, 0xA3, 0x04, 0xA0, 0x60, 0xAA, 0x30,
  0x4A, 0x06, 0x0A, 0xA3, 0x04, 0xA0, 0x60, 0xAA, 0x30, 0x5A, 0x06, 0x0A, 0xA0, 0x12, 0x07, 0xA0,
  0x60, 0x8A, 0x82, 0x80, 0x3D, 0xA0, 0x60, 0x3D, 0x0E, 0xA8, 0x66, 0x04, 0xBE, 0xEA, 0x5A, 0x06,
  0x60, 0xD0, 0xB7, 0x83, 0x3F, 0xB3, 0x15, 0x02, 0xB0, 0x46, 0x82, 0x7E, 0xE3,
  // "Ŵ" (U+0174)
  0x60, 0x5B, 0x07, 0x75, 0x82, 0x3E, 0xF9, 0xA0, 0x37, 0x38, 0x71, 0xDE, 0x40, 0x4D, 0xE2, 0x77,
  0x72, 0x81, 0xDF, 0xC4, 0x0B, 0xA0, 0x13, 0x06, 0xA0, 0x40, 0x9A, 0x40, 0xEA, 0x05, 0x30, 0x9A,
  0x10, 0x5A, 0x03, 0x20, 0x3B, 0x09, 0x38, 0x3D, 0xFC, 0x01, 0xA0, 0x72, 0x83, 0x7F, 0xEF, 0xD2,
  0x01, 0xA0, 0x82, 0x81, 0xDF, 0xB2, 0x81, 0xBF, 0x8A, 0x81, 0x20, 0x4A, 0x04, 0x28, 0x19, 0xFE,
  0x28, 0x6E, 0xF4, 0xDF, 0x60, 0x8A, 0x30, 0x5A, 0x02, 0x03, 0xA1, 0x85, 0xAF, 0xA0, 0xCF, 0xB3,
  0x01, 0xA8, 0x66, 0x7F, 0xC0, 0x6F, 0xE1, 0xA0, 0x74, 0x86, 0xDF, 0x9B, 0xF8, 0x02, 0xA0, 0x4A,
  0x04, 0x48, 0x49, 0xFC, 0xDF, 0x42, 0x81, 0xDF, 0xAA, 0x58, 0x15, 0xFE, 0xA3, 0x83, 0x9F, 0xEF,
  0xB5, 0x01, 0xB0, 0xB3, 0x05, 0xB0, 0x76, 0x0D, 0xA0, 0x73, 0x01, 0xB0, 0x33,
  // "ŵ" (U+0175)
  0x50, 0x5B, 0x07, 0x73, 0x82, 0x3E, 0xF9, 0xA0, 0x37, 0x18, 0x71, 0xDE, 0x40, 0x4D, 0xE2, 0x77,
  0x68, 0x1A, 0xFE, 0x30, 0xDA, 0x04, 0x20, 0x8A, 0x01, 0x06, 0xA8, 0x13, 0x02, 0xB0, 0x82, 0x83,
  0xCF, 0xC0, 0x1A, 0x87, 0x70, 0x5F, 0xBF, 0xC0, 0x1A, 0x08, 0x28, 0x91, 0xDF, 0xB0, 0x9F, 0x5E,
  0xF0, 0x5A, 0x03, 0x20, 0x8A, 0x18, 0x7D, 0xF1, 0xBF, 0x48, 0xFE, 0x30, 0x4A, 0x89, 0x04, 0xFD,
  0x07, 0xF7, 0xCF, 0xA4, 0xA8, 0x59, 0xFA, 0x04, 0xFA, 0xA0, 0x64, 0x83, 0xBF, 0xDF, 0x62, 0x90,
  0xDA, 0x01, 0x40, 0x7B, 0x02, 0x20, 0xDA, 0x0C, 0x50, 0x2A, 0x0E, 0x30, 0x9A, 0x08, 0x30,
  // "Ŷ" (U+0176)
  0x30, 0x5B, 0x07, 0x58, 0x23, 0xEF, 0x9A, 0x03, 0x38, 0x71, 0xDE, 0x40, 0x4D, 0xE2, 0x75, 0x0B,
  0xA0, 0x34, 0x82, 0xEF, 0xE3, 0xA0, 0xA3, 0x07, 0xA8, 0x16, 0x0A, 0xA0, 0x32, 0x81, 0xEF, 0xD2,
  0x02, 0xA8, 0x1B, 0x07, 0xA0, 0x53, 0x09, 0xA8, 0x24, 0xEF, 0xC4, 0x01, 0xA0, 0xEA, 0x04, 0x50,
  0x8B, 0x0B, 0x60, 0x10, 0xEA, 0x03, 0x70, 0xBA, 0x71, 0x0B, 0xA7, 0x10, 0xBA, 0x71, 0x0B, 0xA7,
  0x10, 0xBA, 0x40,
  // "ŷ" (U+0177)
  0x30, 0x5B, 0x07, 0x58, 0x23, 0xEF, 0x9A, 0x03, 0x38, 0x71, 0xDE, 0x40, 0x4D, 0xE2, 0x75, 0x0C,
  0xA0, 0x13, 0x0C, 0xA0, 0x10, 0x6A, 0x06, 0x20, 0x2A, 0x0A, 0x28, 0x1E, 0xFC, 0x20, 0x7A, 0x04,
  0x20, 0x9A, 0x83, 0x10, 0xCF, 0xD3, 0x02, 0xA0, 0x70, 0x2A, 0x08, 0x48, 0x2C, 0xFC, 0x7A, 0x02,
  0x40, 0x5A, 0x81, 0xBF, 0xB6, 0x0E, 0xB0, 0x66, 0x08, 0xA0, 0xE7, 0x03, 0xA0, 0x97, 0x06, 0xA0,
  0x34, 0x84, 0x12, 0x5E, 0xFC, 0x50, 0x6B, 0x0E, 0x03, 0x58, 0x35, 0xFE, 0xA3, 0x60,
  // "Ÿ" (U+0178)
  0x30, 0x13, 0x01, 0x58, 0x56, 0xFB, 0x0D, 0xF5, 0x48, 0x54, 0xE9, 0x0B, 0xE4, 0x76, 0x0B, 0xA0,
  0x34, 0x82, 0xEF, 0xE3, 0xA0, 0xA3, 0x07, 0xA8, 0x16, 0x0A, 0xA0, 0x32, 0x81, 0xEF, 0xD2, 0x02,
  0xA8, 0x1B, 0x07, 0xA0, 0x53, 0x09, 0xA8, 0x24, 0xEF, 0xC4, 0x01, 0xA0, 0xEA, 0x04, 0x50, 0x8B,
  0x0B, 0x60, 0x10, 0xEA, 0x03, 0x70, 0xBA, 0x71, 0x0B, 0xA7, 0x10, 0xBA, 0x71, 0x0B, 0xA7, 0x10,
  0xBA, 0x40,
  // "Ź" (U+0179)
  0x50, 0x8A, 0x07, 0x50, 0x4A, 0x06, 0x58, 0x21, 0xEE, 0x37, 0x60, 0x6F, 0x90, 0xC0, 0x6F, 0x90,
  0xC0, 0x18, 0x01, 0x20, 0xBA, 0x04, 0x50, 0x4A, 0x09, 0x58, 0x21, 0xEF, 0xD6, 0x0A, 0xA0, 0x45,
  0x05, 0xA0, 0x95, 0x82, 0x1E, 0xFD, 0x60, 0xAA, 0x03, 0x50, 0x5A, 0x08, 0x58, 0x31, 0xEF, 0xE3,
  0x80, 0x12, 0x08, 0xFA, 0x08, 0xFA,
  // "ź" (U+017A)
  0x40, 0x8A, 0x07, 0x40, 0x4A, 0x06, 0x48, 0x21, 0xEE, 0x37, 0x50, 0x3F, 0x01, 0x03, 0xF8, 0x41,
  0x02, 0x22, 0x5A, 0x09, 0x48, 0x21, 0xDF, 0xC5, 0x82, 0xAF, 0xE2, 0x40, 0x6A, 0x05, 0x40, 0x2A,
  0x0A, 0x58, 0x7D, 0xFE, 0x32, 0x22, 0x07, 0xF0, 0x30, 0x8F, 0x03,
  // "Ż" (U+017B)
  0x50, 0x17, 0x02, 0xA0, 0x76, 0x82, 0x1D, 0xE5, 0x76, 0x06, 0xF9, 0x0C, 0x06, 0xF9, 0x0C, 0x01,
  0x80, 0x12, 0x0B, 0xA0, 0x45, 0x04, 0xA0, 0x95, 0x82, 0x1E, 0xFD, 0x60, 0xAA, 0x04, 0x50, 0x5A,
  0x09, 0x58, 0x21, 0xEF, 0xD6, 0x0A, 0xA0, 0x35, 0x05, 0xA0, 0x85, 0x83, 0x1E, 0xFE, 0x38, 0x01,
  0x20, 0x8F, 0xA0, 0x8F, 0xA0,
  // "ż" (U+017C)
  0x40, 0x16, 0x02, 0xA0, 0x75, 0x82, 0x1D, 0xE5, 0x75, 0x03, 0xF0, 0x10, 0x3F, 0x84, 0x10, 0x22,
  0x25, 0xA0, 0x94, 0x82, 0x1D, 0xFC, 0x58, 0x2A, 0xFE, 0x24, 0x06, 0xA0, 0x54, 0x02, 0xA0, 0xA5,
  0x87, 0xDF, 0xE3, 0x22, 0x20, 0x7F, 0x03, 0x08, 0xF0, 0x30,
  // "Ž" (U+017D)
  0x18, 0x71, 0xEE, 0x40, 0x3D, 0xE2, 0x28, 0x23, 0xEF, 0x9A, 0x04, 0x40, 0x6B, 0x07, 0x75, 0x06,
  0xF9, 0x0C, 0x06, 0xF9, 0x0C, 0x01, 0x80, 0x12, 0x0B, 0xA0, 0x45, 0x04, 0xA0, 0x95, 0x82, 0x1E,
  0xFD, 0x60, 0xAA, 0x04, 0x50, 0x5A, 0x09, 0x58, 0x21, 0xEF, 0xD6, 0x0A, 0xA0, 0x35, 0x05, 0xA0,
  0x85, 0x83, 0x1E, 0xFE, 0x38, 0x01, 0x20, 0x8F, 0xA0, 0x8F, 0xA0,
  // "ž" (U+017E)
  0x89, 0x41, 0xEE, 0x40, 0x3D, 0xE2, 0x03, 0xEF, 0x9A, 0x04, 0x30, 0x6B, 0x07, 0x74, 0x03, 0xF0,
  0x10, 0x3F, 0x84, 0x10, 0x22, 0x25, 0xA0, 0x94, 0x82, 0x1D, 0xFC, 0x58, 0x2A, 0xFE, 0x24, 0x06,
  0xA0, 0x54, 0x02, 0xA0, 0xA5, 0x87, 0xDF, 0xE3, 0x22, 0x20, 0x7F, 0x03, 0x08, 0xF0, 0x30,
  // "ſ" (U+017F)
  0x18, 0x55, 0xCF, 0xEC, 0x23, 0xC8, 0x1E, 0x08, 0xA8, 0x37, 0x34, 0x09, 0xA0, 0x13, 0x09, 0xA0,
  0x13, 0x09, 0xA0, 0x13, 0x09, 0xA0, 0x13, 0x09, 0xA0, 0x13, 0x09, 0xA0, 0x13, 0x09, 0xA0, 0x13,
  0x09, 0xA0, 0x13, 0x09, 0xA0, 0x13, 0x09, 0xA0, 0x13, 0x09, 0xA0, 0x13,
  // "Ω" (U+03A9)
  0x38, 0x62, 0x8C, 0xEE, 0xD9, 0x35, 0x05, 0x0E, 0xF0, 0x73, 0x03, 0xB8, 0x38, 0x43, 0x7E, 0xA0,
  0x52, 0x0A, 0xA0, 0x64, 0x04, 0xA0, 0xC2, 0x81, 0xEF, 0xE6, 0x0C, 0xA0, 0x11, 0xA0, 0xC6, 0x0A,
  0xA8, 0x32, 0x0E, 0xFC, 0x60, 0xAA, 0x83, 0x10, 0xBF, 0xE6, 0x81, 0xCF, 0xD2, 0x05, 0xA0, 0x34,
  0x01, 0xA0, 0x73, 0x81, 0xAF, 0xB4, 0x81, 0xAF, 0xC2, 0x84, 0x12, 0x2B, 0xFB, 0x28, 0x5A, 0xFD,
  0x32, 0x18, 0xD0, 0x11, 0xD0, 0xA0, 0x8D, 0x01, 0x1D, 0x0A,
  // "μ" (U+03BC)
  0x09, 0xA0, 0x12, 0x03, 0xA0, 0x70, 0x9A, 0x01, 0x20, 0x3A, 0x07, 0x09, 0xA0, 0x12, 0x03, 0xA0,
  0x70, 0x9A, 0x01, 0x20, 0x3A, 0x07, 0x09, 0xA0, 0x12, 0x03, 0xA0, 0x70, 0x9A, 0x01, 0x20, 0x4A,
  0x07, 0x09, 0xA0, 0x32, 0x07, 0xA0, 0x70, 0x9A, 0x82, 0xB3, 0x5E, 0xA0, 0x70, 0x9D, 0x83, 0xEE,
  0xF7, 0x9A, 0x86, 0xAE, 0xD3, 0xAF, 0x79, 0xA0, 0x16, 0x09, 0xA0, 0x16, 0x09, 0xA0, 0x16, 0x09,
  0xA0, 0x16,
  // "π" (U+03C0)
  0x03, 0x0C, 0xFB, 0x0A, 0x0C, 0xFC, 0x87, 0xA1, 0x2C, 0xFE, 0x22, 0x3A, 0x81, 0xA2, 0x12, 0x81,
  0xBF, 0xE2, 0x01, 0xA0, 0x94, 0x81, 0xBF, 0xE2, 0x01, 0xA0, 0x94, 0x81, 0xBF, 0xE2, 0x01, 0xA0,
  0x94, 0x81, 0xBF, 0xE2, 0x01, 0xA0, 0x94, 0x81, 0xBF, 0xE3, 0xA8, 0x1C, 0x33, 0x28, 0x1B, 0xFE,
  0x30, 0xCB, 0x08, 0x28, 0x1B, 0xFE, 0x38, 0x32, 0xCE, 0xD5,
  // "–" (U+2013)
  0x18, 0x03, 0x21, 0x04, 0xF0, 0x04, 0xF0, 0x40,
  // "—" (U+2014)
  0x18, 0x09, 0x42, 0x10, 0x4F, 0xFA, 0x00, 0x4F, 0xFA, 0x04,
  // "€" (U+20AC)
  0x48, 0x46, 0xCE, 0xEC, 0x83, 0x0B, 0xD0, 0xC2, 0x08, 0xA8, 0x3A, 0x33, 0x64, 0x28, 0x1E, 0xFB,
  0x50, 0x30, 0xAA, 0x0B, 0x0F, 0x82, 0x06, 0xE0, 0xE3, 0x06, 0xA0, 0x35, 0x06, 0xE0, 0x52, 0x03,
  0x09, 0xA8, 0x2B, 0x88, 0x34, 0x81, 0xEF, 0xB7, 0x08, 0xA8, 0x3A, 0x32, 0x55, 0x30, 0xBD, 0x09,
  0x48, 0x46, 0xCE, 0xED, 0x60,
  // "₿" (U+20BF)
  0x28, 0x24, 0x51, 0x75, 0x83, 0x8A, 0x1F, 0x12, 0x05, 0xB8, 0x4E, 0xF8, 0x10, 0x5E, 0x81, 0xD0,
  0x5A, 0x81, 0x63, 0xCA, 0x04, 0x05, 0xA8, 0x15, 0x06, 0xA0, 0x05, 0xA8, 0x15, 0x1B, 0xA0, 0x20,
  0x5E, 0x81, 0x80, 0x5E, 0x81, 0x90, 0x5A, 0x81, 0x63, 0xAA, 0x06, 0x05, 0xA8, 0x15, 0x02, 0xA0,
  0xA0, 0x5A, 0x81, 0x50, 0x3A, 0x0A, 0x05, 0xA8, 0x16, 0x3A, 0xA0, 0x70, 0x5E, 0x81, 0xD1, 0x5D,
  0x09, 0x01, 0x38, 0x38, 0xA1, 0xF1, 0x48, 0x23, 0x50, 0x73,
  // "‘" (U+2018)
  0x18, 0x67, 0xF8, 0x0D, 0xF5, 0x4A, 0x82, 0x1A, 0xFE, 0x10,
  // "’" (U+2019)
  0x1A, 0x08, 0x03, 0xA8, 0x63, 0x6F, 0xC0, 0xAF, 0x51,
  // "‚" (U+201A)
  0x1A, 0x08, 0x03, 0xA8, 0x63, 0x6F, 0xC0, 0xAF, 0x51,
  // "‛" (U+201B)
  0x83, 0xAF, 0xE0, 0x4A, 0x87, 0x10, 0xDF, 0x50, 0x7F, 0x80,
  // "“" (U+201C)
  0x18, 0x96, 0x7F, 0x80, 0x5F, 0xA0, 0xDF, 0x50, 0xCF, 0x64, 0xA0, 0x10, 0x3A, 0x84, 0x3A, 0xFE,
  0x08, 0xA1,
  // "”" (U+201D)
  0x1A, 0x84, 0x80, 0xDF, 0xA3, 0xA0, 0x30, 0x1A, 0x89, 0x65, 0x6F, 0xC0, 0x4F, 0xE0, 0xAF, 0x50,
  0x8F, 0x71,
  // "„" (U+201E)
  0x1A, 0x84, 0x80, 0xDF, 0xA3, 0xA0, 0x30, 0x1A, 0x89, 0x65, 0x6F, 0xC0, 0x4F, 0xE0, 0xAF, 0x50,
  0x8F, 0x71,
  // "‟" (U+201F)
  0x83, 0xAF, 0xE0, 0x8A, 0x10, 0x4A, 0x01, 0x03, 0xA8, 0x97, 0x30, 0xDF, 0x50, 0xCF, 0x60, 0x7F,
  0x80, 0x5F, 0xA0,
  // "†" (U+2020)
  0x28, 0x19, 0xFB, 0x58, 0x17, 0xF9, 0x58, 0x15, 0xF7, 0x38, 0x75, 0x46, 0xF7, 0x45, 0x1E, 0xE8,
  0x73, 0x99, 0x9F, 0xA8, 0xA2, 0x28, 0x13, 0xF5, 0x58, 0x14, 0xF6, 0x58, 0x15, 0xF7, 0x58, 0x16,
  0xF8, 0x58, 0x17, 0xF9, 0x58, 0x18, 0xF9, 0x58, 0x19, 0xFA, 0x58, 0x1A, 0xFB, 0x30,
  // "‡" (U+2021)
  0x28, 0x17, 0xFC, 0x58, 0x15, 0xFA, 0x58, 0x13, 0xF7, 0x38, 0x6B, 0xA9, 0xFB, 0x9B, 0x3F, 0x87,
  0x44, 0x34, 0xF8, 0x24, 0x12, 0x81, 0x6F, 0xA5, 0x81, 0x6F, 0xA3, 0x86, 0x31, 0x3F, 0x71, 0x21,
  0xF8, 0x74, 0xDB, 0xBF, 0xCB, 0xD4, 0x28, 0x13, 0xF7, 0x58, 0x15, 0xFA, 0x58, 0x17, 0xFC, 0x30,
  // "•" (U+2022)
  0x18, 0x53, 0xCF, 0xB1, 0x0D, 0xB0, 0x90, 0x1C, 0x0D, 0x01, 0xC8, 0x1C, 0x0D, 0xB8, 0x59, 0x03,
  0xCE, 0xA1,
  // "…" (U+2026)
  0x81, 0x8E, 0xA2, 0x81, 0x8E, 0xA2, 0x83, 0x8E, 0xA0, 0xEA, 0x81, 0x10, 0xEA, 0x81, 0x10, 0xEA,
  0x82, 0x18, 0xEA, 0x28, 0x18, 0xEA, 0x28, 0x18, 0xEA, 0x10,
  // "‰" (U+2030)
  0x18, 0x33, 0xCF, 0xD4, 0x48, 0x1A, 0xF6, 0x74, 0x0D, 0xC0, 0x12, 0x81, 0x3F, 0xD7, 0x40, 0x3A,
  0x82, 0x4D, 0xF7, 0x28, 0x1B, 0xF5, 0x74, 0x89, 0x15, 0xFC, 0x09, 0xF9, 0x04, 0xFC, 0x75, 0x89,
  0x16, 0xFC, 0x08, 0xF9, 0x0D, 0xF3, 0x75, 0x89, 0x54, 0xFE, 0x1C, 0xF7, 0x6F, 0xA3, 0xCF, 0xD4,
  0x28, 0x35, 0xDF, 0xC3, 0x20, 0xEC, 0x83, 0x3E, 0xF2, 0xDC, 0x00, 0x1C, 0x0D, 0x20, 0x40, 0xEA,
  0x83, 0x77, 0xF9, 0x4A, 0x89, 0x14, 0xDF, 0x76, 0xFD, 0x4E, 0xF4, 0x38, 0xA2, 0x20, 0x1E, 0xE1,
  0x6F, 0xC0, 0x9F, 0x98, 0xFA, 0x0B, 0xF6, 0x58, 0xA0, 0x9F, 0x70, 0x5F, 0xC0, 0x9F, 0x98, 0xF9,
  0x0B, 0xF6, 0x48, 0x12, 0xFE, 0x20, 0x3A, 0x89, 0x14, 0xDF, 0x76, 0xFD, 0x3E, 0xF4, 0x48, 0x1B,
  0xF6, 0x30, 0xDC, 0x81, 0x11, 0xEB, 0x0E, 0x48, 0x13, 0xFD, 0x48, 0x32, 0xCF, 0xD5, 0x28, 0x34,
  0xDF, 0xC3, 0x10,
  // "‹" (U+2039)
  0x38, 0x17, 0xB3, 0x20, 0x4A, 0x84, 0x80, 0x2E, 0xFA, 0x28, 0x1D, 0xFD, 0x28, 0x21, 0xEF, 0xC3,
  0x03, 0xA0, 0x93, 0x06, 0xA0, 0x63, 0x81, 0x8D, 0x50,
  // "›" (U+203A)
  0x81, 0x6D, 0x22, 0x81, 0xDF, 0xC2, 0x82, 0x2E, 0xFA, 0x20, 0x4A, 0x81, 0x80, 0x3A, 0x89, 0x4A,
  0x1D, 0xFC, 0x0B, 0xFE, 0x10, 0x8E, 0x32,
  // "⁄" (U+2044)
  0x78, 0x19, 0xF7, 0x68, 0x12, 0xFE, 0x78, 0x1A, 0xF6, 0x68, 0x13, 0xFD, 0x78, 0x1C, 0xF4, 0x68,
  0x15, 0xFB, 0x78, 0x1D, 0xF3, 0x68, 0x16, 0xFA, 0x78, 0x1E, 0xF2, 0x68, 0x18, 0xF8, 0x68, 0x21,
  0xFE, 0x16, 0x81, 0x9F, 0x76, 0x81, 0x2F, 0xD7,
  // "™" (U+2122)
  0x0A, 0xC8, 0x13, 0xFB, 0x28, 0x13, 0xF9, 0x28, 0x91, 0xD4, 0x02, 0xEE, 0x10, 0x8E, 0x92, 0x89,
  0x1D, 0x40, 0x2E, 0xB6, 0x0D, 0x99, 0x28, 0x91, 0xD4, 0x02, 0xE5, 0xB3, 0xB8, 0x92, 0x89, 0x1D,
  0x40, 0x2E, 0x0E, 0xA5, 0x89, 0x28, 0x91, 0xD4, 0x02, 0xE0, 0xAE, 0x08, 0x92, 0x89, 0x16, 0x10,
  0x16, 0x03, 0x50, 0x34,
  // "⅒" (U+2152)
  0x18, 0x23, 0xEF, 0x14, 0x81, 0x9F, 0x77, 0x10, 0x5B, 0x01, 0x38, 0x12, 0xFE, 0x72, 0x83, 0xDB,
  0xEF, 0x13, 0x81, 0xAF, 0x67, 0x28, 0x31, 0x0E, 0xF1, 0x28, 0x13, 0xFD, 0x75, 0x81, 0xEF, 0x12,
  0x81, 0xCF, 0x47, 0x58, 0x97, 0xEF, 0x10, 0x5F, 0xB3, 0xEF, 0x10, 0x5D, 0xFC, 0x33, 0x85, 0xEF,
  0x10, 0xDF, 0x9B, 0x00, 0x1A, 0x81, 0xEF, 0xD3, 0x8A, 0x0E, 0xF1, 0x6F, 0xAD, 0xBE, 0xF1, 0x7F,
  0xC0, 0xEF, 0x45, 0x89, 0x5E, 0xF2, 0x10, 0xEF, 0x19, 0xF9, 0x0C, 0xF6, 0x48, 0x18, 0xF8, 0x38,
  0x90, 0xEF, 0x19, 0xF9, 0x0C, 0xF6, 0x38, 0x21, 0xFE, 0x13, 0x89, 0x0E, 0xF1, 0x7F, 0xC0, 0xEF,
  0x43, 0x81, 0x9F, 0x74, 0x82, 0xEF, 0x11, 0xA8, 0x1E, 0xFD, 0x38, 0x12, 0xFD, 0x58, 0x7E, 0xF1,
  0x04, 0xDF, 0xC3, 0x10,
  // "ﬁ" (U+FB01)
  0x28, 0x90, 0x1A, 0xEF, 0xD7, 0x6E, 0xC1, 0x20, 0xCC, 0x85, 0x68, 0xFE, 0x10, 0x1A, 0x84, 0xC3,
  0x41, 0x01, 0x30, 0x2A, 0x08, 0x70, 0x30, 0xCC, 0x81, 0xD0, 0x9A, 0x01, 0x09, 0xD8, 0x1D, 0x09,
  0xA8, 0x11, 0x14, 0xA8, 0x39, 0x22, 0x09, 0xA8, 0x11, 0x02, 0xA0, 0x83, 0x09, 0xA8, 0x11, 0x02,
  0xA0, 0x83, 0x09, 0xA8, 0x11, 0x02, 0xA0, 0x83, 0x09, 0xA8, 0x11, 0x02, 0xA0, 0x83, 0x09, 0xA8,
  0x11, 0x02, 0xA0, 0x83, 0x09, 0xA8, 0x11, 0x02, 0xA0, 0x83, 0x09, 0xA8, 0x11, 0x02, 0xA0, 0x83,
  0x09, 0xA0, 0x10,
  // "ﬂ" (U+FB02)
  0x28, 0x51, 0xAE, 0xFD, 0x79, 0xA0, 0x12, 0x0C, 0xC0, 0x60, 0x9A, 0x81, 0x10, 0x1A, 0x83, 0xC3,
  0x41, 0x9A, 0x81, 0x10, 0x2A, 0x08, 0x30, 0x9A, 0x81, 0x13, 0xCC, 0x81, 0xD0, 0x9A, 0x01, 0x09,
  0xD8, 0x1D, 0x09, 0xA8, 0x11, 0x14, 0xA8, 0x39, 0x22, 0x09, 0xA8, 0x11, 0x02, 0xA0, 0x83, 0x09,
  0xA8, 0x11, 0x02, 0xA0, 0x83, 0x09, 0xA8, 0x11, 0x02, 0xA0, 0x83, 0x09, 0xA8, 0x11, 0x02, 0xA0,
  0x83, 0x09, 0xA8, 0x11, 0x02, 0xA0, 0x83, 0x09, 0xA8, 0x11, 0x02, 0xA0, 0x83, 0x09, 0xA8, 0x11,
  0x02, 0xA0, 0x83, 0x09, 0xA0, 0x10,
};

const Font& font_NotoSans_Bold_18() {
  static SmoothFont font(font_NotoSans_Bold_18_data);
  return font;
}

}  // namespace roo_display
