#include "8.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSansMono-Regular (Noto Sans Mono Regular)
// Generated on Sun Mar 06 15:49:58 CET 2022
static const uint8_t font_NotoSansMono_Regular_8_data[] PROGMEM = {
  
  // Header
  0x01, 0x01, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x5D, 0x00, 0x00,
  0xFE, 0xFE, 0x0C, 0x0A, 0x07, 0xFE, 0x04, 0x00, 0x0E, 0x04, 0x05, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x02, 0x01, 0x02, 0x07, 0x05, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x01, 0x05, 0x03, 0x07, 0x05, 0x00, 0x05, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x04, 0x07, 0x05, 0x00, 0x0A, // "#" (U+0023)
  0x00, 0x24, 0x00, 0x00, 0x04, 0x07, 0x05, 0x00, 0x1D, // "$" (U+0024)
  0x00, 0x25, 0x00, 0x01, 0x04, 0x07, 0x05, 0x00, 0x32, // "%" (U+0025)
  0x00, 0x26, 0x00, 0x01, 0x04, 0x07, 0x05, 0x00, 0x46, // "&" (U+0026)
  0x00, 0x27, 0x02, 0x05, 0x02, 0x07, 0x05, 0x00, 0x5A, // "'" (U+0027)
  0x00, 0x28, 0x01, 0x00, 0x03, 0x07, 0x05, 0x00, 0x5D, // "(" (U+0028)
  0x00, 0x29, 0x01, 0xFE, 0x03, 0x05, 0x05, 0x00, 0x6B, // ")" (U+0029)
  0x00, 0x2A, 0x00, 0x04, 0x03, 0x07, 0x05, 0x00, 0x79, // "*" (U+002A)
  0x00, 0x2B, 0x00, 0x02, 0x04, 0x05, 0x05, 0x00, 0x82, // "+" (U+002B)
  0x00, 0x2C, 0x01, 0x00, 0x02, 0x02, 0x05, 0x00, 0x8B, // "," (U+002C)
  0x00, 0x2D, 0x01, 0x03, 0x03, 0x03, 0x05, 0x00, 0x8F, // "-" (U+002D)
  0x00, 0x2E, 0x02, 0x01, 0x02, 0x01, 0x05, 0x00, 0x92, // "." (U+002E)
  0x00, 0x2F, 0x01, 0x01, 0x03, 0x07, 0x05, 0x00, 0x93, // "/" (U+002F)
  0x00, 0x30, 0x00, 0x01, 0x04, 0x07, 0x05, 0x00, 0x9E, // "0" (U+0030)
  0x00, 0x31, 0x00, 0x01, 0x04, 0x07, 0x05, 0x00, 0xB1, // "1" (U+0031)
  0x00, 0x32, 0x00, 0x01, 0x04, 0x07, 0x05, 0x00, 0xC0, // "2" (U+0032)
  0x00, 0x33, 0x00, 0x01, 0x04, 0x07, 0x05, 0x00, 0xD4, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x01, 0x04, 0x07, 0x05, 0x00, 0xE6, // "4" (U+0034)
  0x00, 0x35, 0x00, 0x01, 0x04, 0x07, 0x05, 0x00, 0xFA, // "5" (U+0035)
  0x00, 0x36, 0x00, 0x01, 0x04, 0x07, 0x05, 0x01, 0x0C, // "6" (U+0036)
  0x00, 0x37, 0x00, 0x01, 0x04, 0x07, 0x05, 0x01, 0x1F, // "7" (U+0037)
  0x00, 0x38, 0x00, 0x01, 0x04, 0x07, 0x05, 0x01, 0x2F, // "8" (U+0038)
  0x00, 0x39, 0x00, 0x01, 0x04, 0x07, 0x05, 0x01, 0x43, // "9" (U+0039)
  0x00, 0x3A, 0x02, 0x01, 0x02, 0x05, 0x05, 0x01, 0x56, // ":" (U+003A)
  0x00, 0x3B, 0x01, 0x00, 0x02, 0x05, 0x05, 0x01, 0x59, // ";" (U+003B)
  0x00, 0x3C, 0x01, 0x02, 0x04, 0x05, 0x05, 0x01, 0x5F, // "<" (U+003C)
  0x00, 0x3D, 0x00, 0x03, 0x04, 0x05, 0x05, 0x01, 0x68, // "=" (U+003D)
  0x00, 0x3E, 0x00, 0x02, 0x03, 0x05, 0x05, 0x01, 0x70, // ">" (U+003E)
  0x00, 0x3F, 0x00, 0x01, 0x03, 0x07, 0x05, 0x01, 0x7A, // "?" (U+003F)
  0x00, 0x40, 0x00, 0x00, 0x04, 0x07, 0x05, 0x01, 0x8A, // "@" (U+0040)
  0x00, 0x41, 0x00, 0x01, 0x04, 0x07, 0x05, 0x01, 0x9F, // "A" (U+0041)
  0x00, 0x42, 0x00, 0x01, 0x04, 0x07, 0x05, 0x01, 0xB4, // "B" (U+0042)
  0x00, 0x43, 0x00, 0x01, 0x04, 0x07, 0x05, 0x01, 0xC7, // "C" (U+0043)
  0x00, 0x44, 0x00, 0x01, 0x04, 0x07, 0x05, 0x01, 0xD8, // "D" (U+0044)
  0x00, 0x45, 0x00, 0x01, 0x04, 0x07, 0x05, 0x01, 0xEB, // "E" (U+0045)
  0x00, 0x46, 0x00, 0x01, 0x04, 0x07, 0x05, 0x01, 0xFE, // "F" (U+0046)
  0x00, 0x47, 0x00, 0x01, 0x04, 0x07, 0x05, 0x02, 0x10, // "G" (U+0047)
  0x00, 0x48, 0x00, 0x01, 0x04, 0x07, 0x05, 0x02, 0x23, // "H" (U+0048)
  0x00, 0x49, 0x00, 0x01, 0x03, 0x07, 0x05, 0x02, 0x36, // "I" (U+0049)
  0x00, 0x4A, 0x00, 0x01, 0x03, 0x07, 0x05, 0x02, 0x44, // "J" (U+004A)
  0x00, 0x4B, 0x00, 0x01, 0x04, 0x07, 0x05, 0x02, 0x50, // "K" (U+004B)
  0x00, 0x4C, 0x00, 0x01, 0x04, 0x07, 0x05, 0x02, 0x65, // "L" (U+004C)
  0x00, 0x4D, 0x00, 0x01, 0x04, 0x07, 0x05, 0x02, 0x78, // "M" (U+004D)
  0x00, 0x4E, 0x00, 0x01, 0x04, 0x07, 0x05, 0x02, 0x8B, // "N" (U+004E)
  0x00, 0x4F, 0x00, 0x01, 0x04, 0x07, 0x05, 0x02, 0x9E, // "O" (U+004F)
  0x00, 0x50, 0x00, 0x01, 0x04, 0x07, 0x05, 0x02, 0xB1, // "P" (U+0050)
  0x00, 0x51, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x02, 0xC3, // "Q" (U+0051)
  0x00, 0x52, 0x00, 0x01, 0x04, 0x07, 0x05, 0x02, 0xDA, // "R" (U+0052)
  0x00, 0x53, 0x00, 0x01, 0x04, 0x07, 0x05, 0x02, 0xED, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x04, 0x07, 0x05, 0x02, 0xFF, // "T" (U+0054)
  0x00, 0x55, 0x00, 0x01, 0x04, 0x07, 0x05, 0x03, 0x0C, // "U" (U+0055)
  0x00, 0x56, 0x00, 0x01, 0x04, 0x07, 0x05, 0x03, 0x1F, // "V" (U+0056)
  0x00, 0x57, 0x00, 0x01, 0x04, 0x07, 0x05, 0x03, 0x34, // "W" (U+0057)
  0x00, 0x58, 0x00, 0x01, 0x04, 0x07, 0x05, 0x03, 0x48, // "X" (U+0058)
  0x00, 0x59, 0x00, 0x01, 0x04, 0x07, 0x05, 0x03, 0x5C, // "Y" (U+0059)
  0x00, 0x5A, 0x00, 0x01, 0x03, 0x07, 0x05, 0x03, 0x6D, // "Z" (U+005A)
  0x00, 0x5B, 0x01, 0x00, 0x03, 0x07, 0x05, 0x03, 0x7E, // "[" (U+005B)
  0x00, 0x5C, 0x01, 0x01, 0x03, 0x07, 0x05, 0x03, 0x8C, // "\" (U+005C)
  0x00, 0x5D, 0x01, 0xFF, 0x03, 0x06, 0x05, 0x03, 0x98, // "]" (U+005D)
  0x00, 0x5E, 0x00, 0x03, 0x04, 0x06, 0x05, 0x03, 0xA6, // "^" (U+005E)
  0x00, 0x5F, 0x00, 0xFF, 0x04, 0xFF, 0x05, 0x03, 0xB2, // "_" (U+005F)
  0x00, 0x60, 0x01, 0x07, 0x02, 0x08, 0x05, 0x03, 0xB5, // "`" (U+0060)
  0x00, 0x61, 0x00, 0x01, 0x04, 0x05, 0x05, 0x03, 0xB8, // "a" (U+0061)
  0x00, 0x62, 0x00, 0x01, 0x04, 0x07, 0x05, 0x03, 0xC6, // "b" (U+0062)
  0x00, 0x63, 0x00, 0x01, 0x03, 0x05, 0x05, 0x03, 0xD8, // "c" (U+0063)
  0x00, 0x64, 0x00, 0x01, 0x04, 0x07, 0x05, 0x03, 0xE4, // "d" (U+0064)
  0x00, 0x65, 0x00, 0x01, 0x04, 0x05, 0x05, 0x03, 0xF6, // "e" (U+0065)
  0x00, 0x66, 0x00, 0x01, 0x04, 0x07, 0x05, 0x04, 0x04, // "f" (U+0066)
  0x00, 0x67, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x04, 0x16, // "g" (U+0067)
  0x00, 0x68, 0x00, 0x01, 0x04, 0x07, 0x05, 0x04, 0x29, // "h" (U+0068)
  0x00, 0x69, 0x00, 0x01, 0x04, 0x07, 0x05, 0x04, 0x3B, // "i" (U+0069)
  0x00, 0x6A, 0x00, 0xFF, 0x03, 0x07, 0x05, 0x04, 0x48, // "j" (U+006A)
  0x00, 0x6B, 0x00, 0x01, 0x04, 0x07, 0x05, 0x04, 0x5C, // "k" (U+006B)
  0x00, 0x6C, 0x00, 0x01, 0x04, 0x07, 0x05, 0x04, 0x70, // "l" (U+006C)
  0x00, 0x6D, 0x00, 0x01, 0x04, 0x05, 0x05, 0x04, 0x7E, // "m" (U+006D)
  0x00, 0x6E, 0x00, 0x01, 0x04, 0x05, 0x05, 0x04, 0x8C, // "n" (U+006E)
  0x00, 0x6F, 0x00, 0x01, 0x04, 0x05, 0x05, 0x04, 0x9A, // "o" (U+006F)
  0x00, 0x70, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x04, 0xA8, // "p" (U+0070)
  0x00, 0x71, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x04, 0xBA, // "q" (U+0071)
  0x00, 0x72, 0x00, 0x01, 0x04, 0x05, 0x05, 0x04, 0xCD, // "r" (U+0072)
  0x00, 0x73, 0x00, 0x01, 0x03, 0x05, 0x05, 0x04, 0xDB, // "s" (U+0073)
  0x00, 0x74, 0x00, 0x01, 0x04, 0x07, 0x05, 0x04, 0xE6, // "t" (U+0074)
  0x00, 0x75, 0x00, 0x01, 0x04, 0x05, 0x05, 0x04, 0xF9, // "u" (U+0075)
  0x00, 0x76, 0x00, 0x01, 0x04, 0x05, 0x05, 0x05, 0x07, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x01, 0x04, 0x05, 0x05, 0x05, 0x16, // "w" (U+0077)
  0x00, 0x78, 0x00, 0x01, 0x04, 0x05, 0x05, 0x05, 0x24, // "x" (U+0078)
  0x00, 0x79, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x05, 0x32, // "y" (U+0079)
  0x00, 0x7A, 0x00, 0x01, 0x03, 0x05, 0x05, 0x05, 0x45, // "z" (U+007A)
  0x00, 0x7B, 0x01, 0x00, 0x03, 0x07, 0x05, 0x05, 0x51, // "{" (U+007B)
  0x00, 0x7C, 0x02, 0xFF, 0x02, 0x07, 0x05, 0x05, 0x5F, // "|" (U+007C)
  0x00, 0x7D, 0x01, 0xFE, 0x03, 0x05, 0x05, 0x05, 0x61, // "}" (U+007D)
  0x00, 0x7E, 0x00, 0x03, 0x04, 0x04, 0x05, 0x05, 0x6F, // "~" (U+007E)
  0x00, 0xA1, 0x02, 0xFE, 0x02, 0x04, 0x05, 0x05, 0x75, // "¡" (U+00A1)
  0x00, 0xA2, 0x00, 0x01, 0x03, 0x07, 0x05, 0x05, 0x7A, // "¢" (U+00A2)
  0x00, 0xA3, 0x00, 0x01, 0x04, 0x07, 0x05, 0x05, 0x8A, // "£" (U+00A3)
  0x00, 0xA4, 0x00, 0x02, 0x04, 0x05, 0x05, 0x05, 0x9F, // "¤" (U+00A4)
  0x00, 0xA5, 0x00, 0x01, 0x04, 0x07, 0x05, 0x05, 0xAB, // "¥" (U+00A5)
  0x00, 0xA6, 0x02, 0xFF, 0x02, 0x07, 0x05, 0x05, 0xBE, // "¦" (U+00A6)
  0x00, 0xA7, 0x00, 0x01, 0x03, 0x07, 0x05, 0x05, 0xC2, // "§" (U+00A7)
  0x00, 0xA8, 0x01, 0x07, 0x03, 0x07, 0x05, 0x05, 0xD2, // "¨" (U+00A8)
  0x00, 0xA9, 0x00, 0x02, 0x04, 0x06, 0x05, 0x05, 0xD5, // "©" (U+00A9)
  0x00, 0xAA, 0x01, 0x04, 0x03, 0x06, 0x05, 0x05, 0xE4, // "ª" (U+00AA)
  0x00, 0xAB, 0x00, 0x01, 0x03, 0x04, 0x05, 0x05, 0xEA, // "«" (U+00AB)
  0x00, 0xAC, 0x00, 0x02, 0x04, 0x04, 0x05, 0x05, 0xF4, // "¬" (U+00AC)
  0x00, 0xAE, 0x00, 0x02, 0x04, 0x06, 0x05, 0x05, 0xFC, // "®" (U+00AE)
  0x00, 0xAF, 0x01, 0x06, 0x03, 0x06, 0x05, 0x06, 0x0A, // "¯" (U+00AF)
  0x00, 0xB0, 0x01, 0x05, 0x03, 0x07, 0x05, 0x06, 0x0D, // "°" (U+00B0)
  0x00, 0xB1, 0x00, 0x01, 0x04, 0x05, 0x05, 0x06, 0x13, // "±" (U+00B1)
  0x00, 0xB2, 0x01, 0x04, 0x03, 0x07, 0x05, 0x06, 0x20, // "²" (U+00B2)
  0x00, 0xB3, 0x01, 0x04, 0x03, 0x07, 0x05, 0x06, 0x28, // "³" (U+00B3)
  0x00, 0xB4, 0x02, 0x07, 0x03, 0x08, 0x05, 0x06, 0x30, // "´" (U+00B4)
  0x00, 0xB5, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x06, 0x33, // "µ" (U+00B5)
  0x00, 0xB6, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x06, 0x45, // "¶" (U+00B6)
  0x00, 0xB7, 0x02, 0x03, 0x02, 0x03, 0x05, 0x06, 0x60, // "·" (U+00B7)
  0x00, 0xB8, 0x01, 0xFF, 0x02, 0x01, 0x05, 0x06, 0x61, // "¸" (U+00B8)
  0x00, 0xB9, 0x01, 0x04, 0x03, 0x07, 0x05, 0x06, 0x65, // "¹" (U+00B9)
  0x00, 0xBA, 0x01, 0x04, 0x03, 0x06, 0x05, 0x06, 0x6D, // "º" (U+00BA)
  0x00, 0xBB, 0x01, 0x01, 0x04, 0x04, 0x05, 0x06, 0x73, // "»" (U+00BB)
  0x00, 0xBC, 0x00, 0x00, 0x04, 0x06, 0x05, 0x06, 0x7D, // "¼" (U+00BC)
  0x00, 0xBD, 0x00, 0x01, 0x04, 0x07, 0x05, 0x06, 0x91, // "½" (U+00BD)
  0x00, 0xBE, 0x00, 0x00, 0x04, 0x06, 0x05, 0x06, 0xA5, // "¾" (U+00BE)
  0x00, 0xBF, 0x01, 0xFE, 0x04, 0x04, 0x05, 0x06, 0xB9, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x04, 0x09, 0x05, 0x06, 0xC9, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x04, 0x09, 0x05, 0x06, 0xE1, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x01, 0x04, 0x09, 0x05, 0x06, 0xF9, // "Â" (U+00C2)
  0x00, 0xC3, 0x00, 0x01, 0x04, 0x07, 0x05, 0x07, 0x12, // "Ã" (U+00C3)
  0x00, 0xC4, 0x00, 0x01, 0x04, 0x08, 0x05, 0x07, 0x27, // "Ä" (U+00C4)
  0x00, 0xC5, 0x00, 0x01, 0x04, 0x08, 0x05, 0x07, 0x3F, // "Å" (U+00C5)
  0x00, 0xC6, 0x00, 0x01, 0x04, 0x07, 0x05, 0x07, 0x57, // "Æ" (U+00C6)
  0x00, 0xC7, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x07, 0x6B, // "Ç" (U+00C7)
  0x00, 0xC8, 0x00, 0x01, 0x04, 0x09, 0x05, 0x07, 0x81, // "È" (U+00C8)
  0x00, 0xC9, 0x00, 0x01, 0x04, 0x09, 0x05, 0x07, 0x97, // "É" (U+00C9)
  0x00, 0xCA, 0x00, 0x01, 0x04, 0x09, 0x05, 0x07, 0xAE, // "Ê" (U+00CA)
  0x00, 0xCB, 0x00, 0x01, 0x04, 0x08, 0x05, 0x07, 0xC5, // "Ë" (U+00CB)
  0x00, 0xCC, 0x00, 0x01, 0x03, 0x09, 0x05, 0x07, 0xDB, // "Ì" (U+00CC)
  0x00, 0xCD, 0x00, 0x01, 0x03, 0x09, 0x05, 0x07, 0xEC, // "Í" (U+00CD)
  0x00, 0xCE, 0x00, 0x01, 0x03, 0x09, 0x05, 0x07, 0xFD, // "Î" (U+00CE)
  0x00, 0xCF, 0x00, 0x01, 0x03, 0x08, 0x05, 0x08, 0x0E, // "Ï" (U+00CF)
  0x00, 0xD0, 0x00, 0x01, 0x04, 0x07, 0x05, 0x08, 0x1E, // "Ð" (U+00D0)
  0x00, 0xD1, 0x00, 0x01, 0x04, 0x07, 0x05, 0x08, 0x31, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x00, 0x01, 0x04, 0x09, 0x05, 0x08, 0x44, // "Ò" (U+00D2)
  0x00, 0xD3, 0x00, 0x01, 0x04, 0x09, 0x05, 0x08, 0x5A, // "Ó" (U+00D3)
  0x00, 0xD4, 0x00, 0x01, 0x04, 0x09, 0x05, 0x08, 0x71, // "Ô" (U+00D4)
  0x00, 0xD5, 0x00, 0x01, 0x04, 0x07, 0x05, 0x08, 0x89, // "Õ" (U+00D5)
  0x00, 0xD6, 0x00, 0x01, 0x04, 0x08, 0x05, 0x08, 0x9B, // "Ö" (U+00D6)
  0x00, 0xD7, 0x00, 0x02, 0x03, 0x05, 0x05, 0x08, 0xB1, // "×" (U+00D7)
  0x00, 0xD8, 0x00, 0x01, 0x04, 0x07, 0x05, 0x08, 0xBB, // "Ø" (U+00D8)
  0x00, 0xD9, 0x00, 0x01, 0x04, 0x09, 0x05, 0x08, 0xCE, // "Ù" (U+00D9)
  0x00, 0xDA, 0x00, 0x01, 0x04, 0x09, 0x05, 0x08, 0xE5, // "Ú" (U+00DA)
  0x00, 0xDB, 0x00, 0x01, 0x04, 0x09, 0x05, 0x08, 0xFC, // "Û" (U+00DB)
  0x00, 0xDC, 0x00, 0x01, 0x04, 0x08, 0x05, 0x09, 0x13, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x01, 0x04, 0x09, 0x05, 0x09, 0x29, // "Ý" (U+00DD)
  0x00, 0xDE, 0x00, 0x01, 0x04, 0x07, 0x05, 0x09, 0x3E, // "Þ" (U+00DE)
  0x00, 0xDF, 0x00, 0x01, 0x04, 0x07, 0x05, 0x09, 0x50, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x01, 0x04, 0x08, 0x05, 0x09, 0x63, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x04, 0x08, 0x05, 0x09, 0x74, // "á" (U+00E1)
  0x00, 0xE2, 0x00, 0x01, 0x04, 0x08, 0x05, 0x09, 0x86, // "â" (U+00E2)
  0x00, 0xE3, 0x00, 0x01, 0x04, 0x06, 0x05, 0x09, 0x98, // "ã" (U+00E3)
  0x00, 0xE4, 0x00, 0x01, 0x04, 0x07, 0x05, 0x09, 0xA9, // "ä" (U+00E4)
  0x00, 0xE5, 0x00, 0x01, 0x04, 0x07, 0x05, 0x09, 0xBA, // "å" (U+00E5)
  0x00, 0xE6, 0x00, 0x01, 0x04, 0x05, 0x05, 0x09, 0xCE, // "æ" (U+00E6)
  0x00, 0xE7, 0x00, 0xFF, 0x03, 0x05, 0x05, 0x09, 0xDD, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x01, 0x04, 0x08, 0x05, 0x09, 0xED, // "è" (U+00E8)
  0x00, 0xE9, 0x00, 0x01, 0x04, 0x08, 0x05, 0x09, 0xFE, // "é" (U+00E9)
  0x00, 0xEA, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0A, 0x10, // "ê" (U+00EA)
  0x00, 0xEB, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x22, // "ë" (U+00EB)
  0x00, 0xEC, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0A, 0x33, // "ì" (U+00EC)
  0x00, 0xED, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0A, 0x42, // "í" (U+00ED)
  0x00, 0xEE, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0A, 0x51, // "î" (U+00EE)
  0x00, 0xEF, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x61, // "ï" (U+00EF)
  0x00, 0xF0, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0A, 0x70, // "ð" (U+00F0)
  0x00, 0xF1, 0x00, 0x01, 0x04, 0x06, 0x05, 0x0A, 0x87, // "ñ" (U+00F1)
  0x00, 0xF2, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0A, 0x97, // "ò" (U+00F2)
  0x00, 0xF3, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0A, 0xA9, // "ó" (U+00F3)
  0x00, 0xF4, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0A, 0xBB, // "ô" (U+00F4)
  0x00, 0xF5, 0x00, 0x01, 0x04, 0x06, 0x05, 0x0A, 0xCE, // "õ" (U+00F5)
  0x00, 0xF6, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0A, 0xDF, // "ö" (U+00F6)
  0x00, 0xF7, 0x00, 0x02, 0x04, 0x05, 0x05, 0x0A, 0xF0, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x01, 0x04, 0x05, 0x05, 0x0A, 0xF8, // "ø" (U+00F8)
  0x00, 0xF9, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0B, 0x06, // "ù" (U+00F9)
  0x00, 0xFA, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0B, 0x18, // "ú" (U+00FA)
  0x00, 0xFB, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0B, 0x2A, // "û" (U+00FB)
  0x00, 0xFC, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0B, 0x3D, // "ü" (U+00FC)
  0x00, 0xFD, 0x00, 0xFF, 0x04, 0x08, 0x05, 0x0B, 0x4F, // "ý" (U+00FD)
  0x00, 0xFE, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0B, 0x66, // "þ" (U+00FE)
  0x00, 0xFF, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0B, 0x7C, // "ÿ" (U+00FF)
  0x01, 0x00, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0B, 0x93, // "Ā" (U+0100)
  0x01, 0x01, 0x00, 0x01, 0x04, 0x06, 0x05, 0x0B, 0xA8, // "ā" (U+0101)
  0x01, 0x02, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0B, 0xB9, // "Ă" (U+0102)
  0x01, 0x03, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0B, 0xD1, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0B, 0xE5, // "Ą" (U+0104)
  0x01, 0x05, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x0B, 0xFF, // "ą" (U+0105)
  0x01, 0x06, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0C, 0x12, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0C, 0x27, // "ć" (U+0107)
  0x01, 0x08, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0C, 0x38, // "Ĉ" (U+0108)
  0x01, 0x09, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0C, 0x4D, // "ĉ" (U+0109)
  0x01, 0x0A, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0C, 0x5F, // "Ċ" (U+010A)
  0x01, 0x0B, 0x00, 0x01, 0x03, 0x07, 0x05, 0x0C, 0x72, // "ċ" (U+010B)
  0x01, 0x0C, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0C, 0x80, // "Č" (U+010C)
  0x01, 0x0D, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0C, 0x97, // "č" (U+010D)
  0x01, 0x0E, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0C, 0xAA, // "Ď" (U+010E)
  0x01, 0x0F, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0C, 0xC3, // "ď" (U+010F)
  0x01, 0x10, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0C, 0xD5, // "Đ" (U+0110)
  0x01, 0x11, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0C, 0xE8, // "đ" (U+0111)
  0x01, 0x12, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0C, 0xFB, // "Ē" (U+0112)
  0x01, 0x13, 0x00, 0x01, 0x04, 0x06, 0x05, 0x0D, 0x0D, // "ē" (U+0113)
  0x01, 0x14, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0D, 0x1E, // "Ĕ" (U+0114)
  0x01, 0x15, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0D, 0x33, // "ĕ" (U+0115)
  0x01, 0x16, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0D, 0x47, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0D, 0x5C, // "ė" (U+0117)
  0x01, 0x18, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0D, 0x6C, // "Ę" (U+0118)
  0x01, 0x19, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x0D, 0x84, // "ę" (U+0119)
  0x01, 0x1A, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0D, 0x97, // "Ě" (U+011A)
  0x01, 0x1B, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0D, 0xB0, // "ě" (U+011B)
  0x01, 0x1C, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0D, 0xC4, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x00, 0xFF, 0x04, 0x08, 0x05, 0x0D, 0xDB, // "ĝ" (U+011D)
  0x01, 0x1E, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0D, 0xF3, // "Ğ" (U+011E)
  0x01, 0x1F, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0E, 0x09, // "ğ" (U+011F)
  0x01, 0x20, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0E, 0x22, // "Ġ" (U+0120)
  0x01, 0x21, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0E, 0x37, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0xFE, 0x04, 0x07, 0x05, 0x0E, 0x4C, // "Ģ" (U+0122)
  0x01, 0x23, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0E, 0x64, // "ģ" (U+0123)
  0x01, 0x24, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0E, 0x7A, // "Ĥ" (U+0124)
  0x01, 0x25, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x0E, 0x91, // "ĥ" (U+0125)
  0x01, 0x26, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0E, 0xA8, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0E, 0xBB, // "ħ" (U+0127)
  0x01, 0x28, 0x00, 0x01, 0x03, 0x07, 0x05, 0x0E, 0xCE, // "Ĩ" (U+0128)
  0x01, 0x29, 0x00, 0x01, 0x04, 0x06, 0x05, 0x0E, 0xDA, // "ĩ" (U+0129)
  0x01, 0x2A, 0x00, 0x01, 0x03, 0x07, 0x05, 0x0E, 0xE8, // "Ī" (U+012A)
  0x01, 0x2B, 0x00, 0x01, 0x04, 0x06, 0x05, 0x0E, 0xF4, // "ī" (U+012B)
  0x01, 0x2C, 0x00, 0x01, 0x03, 0x08, 0x05, 0x0F, 0x02, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0F, 0x12, // "ĭ" (U+012D)
  0x01, 0x2E, 0x00, 0xFF, 0x03, 0x07, 0x05, 0x0F, 0x23, // "Į" (U+012E)
  0x01, 0x2F, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0F, 0x36, // "į" (U+012F)
  0x01, 0x30, 0x00, 0x01, 0x03, 0x08, 0x05, 0x0F, 0x49, // "İ" (U+0130)
  0x01, 0x31, 0x00, 0x01, 0x04, 0x05, 0x05, 0x0F, 0x58, // "ı" (U+0131)
  0x01, 0x32, 0x00, 0x01, 0x03, 0x07, 0x05, 0x0F, 0x63, // "Ĳ" (U+0132)
  0x01, 0x33, 0x00, 0xFF, 0x03, 0x07, 0x05, 0x0F, 0x73, // "ĳ" (U+0133)
  0x01, 0x34, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0F, 0x86, // "Ĵ" (U+0134)
  0x01, 0x35, 0x00, 0xFF, 0x04, 0x08, 0x05, 0x0F, 0x98, // "ĵ" (U+0135)
  0x01, 0x36, 0x00, 0xFE, 0x04, 0x07, 0x05, 0x0F, 0xAF, // "Ķ" (U+0136)
  0x01, 0x37, 0x00, 0xFE, 0x04, 0x07, 0x05, 0x0F, 0xC8, // "ķ" (U+0137)
  0x01, 0x38, 0x00, 0x01, 0x04, 0x05, 0x05, 0x0F, 0xE1, // "ĸ" (U+0138)
  0x01, 0x39, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0F, 0xF0, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x10, 0x07, // "ĺ" (U+013A)
  0x01, 0x3B, 0x00, 0xFE, 0x04, 0x07, 0x05, 0x10, 0x19, // "Ļ" (U+013B)
  0x01, 0x3C, 0x00, 0xFE, 0x04, 0x07, 0x05, 0x10, 0x30, // "ļ" (U+013C)
  0x01, 0x3D, 0x00, 0x01, 0x04, 0x07, 0x05, 0x10, 0x43, // "Ľ" (U+013D)
  0x01, 0x3E, 0x00, 0x01, 0x04, 0x07, 0x05, 0x10, 0x56, // "ľ" (U+013E)
  0x01, 0x3F, 0x00, 0x01, 0x04, 0x07, 0x05, 0x10, 0x66, // "Ŀ" (U+013F)
  0x01, 0x40, 0x00, 0x01, 0x04, 0x07, 0x05, 0x10, 0x79, // "ŀ" (U+0140)
  0x01, 0x41, 0x00, 0x01, 0x04, 0x07, 0x05, 0x10, 0x89, // "Ł" (U+0141)
  0x01, 0x42, 0x00, 0x01, 0x04, 0x07, 0x05, 0x10, 0x98, // "ł" (U+0142)
  0x01, 0x43, 0x00, 0x01, 0x04, 0x09, 0x05, 0x10, 0xA9, // "Ń" (U+0143)
  0x01, 0x44, 0x00, 0x01, 0x04, 0x08, 0x05, 0x10, 0xC0, // "ń" (U+0144)
  0x01, 0x45, 0x00, 0xFE, 0x04, 0x07, 0x05, 0x10, 0xD2, // "Ņ" (U+0145)
  0x01, 0x46, 0x00, 0xFE, 0x04, 0x05, 0x05, 0x10, 0xEA, // "ņ" (U+0146)
  0x01, 0x47, 0x00, 0x01, 0x04, 0x09, 0x05, 0x10, 0xFD, // "Ň" (U+0147)
  0x01, 0x48, 0x00, 0x01, 0x04, 0x08, 0x05, 0x11, 0x16, // "ň" (U+0148)
  0x01, 0x49, 0xFF, 0x01, 0x04, 0x07, 0x05, 0x11, 0x2B, // "ŉ" (U+0149)
  0x01, 0x4A, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x11, 0x41, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x11, 0x5A, // "ŋ" (U+014B)
  0x01, 0x4C, 0x00, 0x01, 0x04, 0x07, 0x05, 0x11, 0x6E, // "Ō" (U+014C)
  0x01, 0x4D, 0x00, 0x01, 0x04, 0x06, 0x05, 0x11, 0x80, // "ō" (U+014D)
  0x01, 0x4E, 0x00, 0x01, 0x04, 0x08, 0x05, 0x11, 0x91, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x00, 0x01, 0x04, 0x07, 0x05, 0x11, 0xA7, // "ŏ" (U+014F)
  0x01, 0x50, 0x00, 0x01, 0x04, 0x08, 0x05, 0x11, 0xBB, // "Ő" (U+0150)
  0x01, 0x51, 0x00, 0x01, 0x04, 0x07, 0x05, 0x11, 0xD1, // "ő" (U+0151)
  0x01, 0x52, 0x00, 0x01, 0x04, 0x07, 0x05, 0x11, 0xE3, // "Œ" (U+0152)
  0x01, 0x53, 0x00, 0x01, 0x04, 0x05, 0x05, 0x11, 0xF6, // "œ" (U+0153)
  0x01, 0x54, 0x00, 0x01, 0x04, 0x09, 0x05, 0x12, 0x05, // "Ŕ" (U+0154)
  0x01, 0x55, 0x00, 0x01, 0x04, 0x08, 0x05, 0x12, 0x1C, // "ŕ" (U+0155)
  0x01, 0x56, 0x00, 0xFE, 0x04, 0x07, 0x05, 0x12, 0x2E, // "Ŗ" (U+0156)
  0x01, 0x57, 0x00, 0xFE, 0x04, 0x05, 0x05, 0x12, 0x46, // "ŗ" (U+0157)
  0x01, 0x58, 0x00, 0x01, 0x04, 0x09, 0x05, 0x12, 0x58, // "Ř" (U+0158)
  0x01, 0x59, 0x00, 0x01, 0x04, 0x08, 0x05, 0x12, 0x71, // "ř" (U+0159)
  0x01, 0x5A, 0x00, 0x01, 0x04, 0x09, 0x05, 0x12, 0x86, // "Ś" (U+015A)
  0x01, 0x5B, 0x00, 0x01, 0x03, 0x08, 0x05, 0x12, 0x9B, // "ś" (U+015B)
  0x01, 0x5C, 0x00, 0x01, 0x04, 0x09, 0x05, 0x12, 0xAA, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x00, 0x01, 0x03, 0x08, 0x05, 0x12, 0xC0, // "ŝ" (U+015D)
  0x01, 0x5E, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x12, 0xD0, // "Ş" (U+015E)
  0x01, 0x5F, 0x00, 0xFF, 0x03, 0x05, 0x05, 0x12, 0xE6, // "ş" (U+015F)
  0x01, 0x60, 0x00, 0x01, 0x04, 0x09, 0x05, 0x12, 0xF6, // "Š" (U+0160)
  0x01, 0x61, 0x00, 0x01, 0x03, 0x08, 0x05, 0x13, 0x0D, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x13, 0x1D, // "Ţ" (U+0162)
  0x01, 0x63, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x13, 0x2E, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x04, 0x09, 0x05, 0x13, 0x45, // "Ť" (U+0164)
  0x01, 0x65, 0x00, 0x01, 0x04, 0x07, 0x05, 0x13, 0x58, // "ť" (U+0165)
  0x01, 0x66, 0x00, 0x01, 0x04, 0x07, 0x05, 0x13, 0x6C, // "Ŧ" (U+0166)
  0x01, 0x67, 0x00, 0x01, 0x04, 0x07, 0x05, 0x13, 0x7B, // "ŧ" (U+0167)
  0x01, 0x68, 0x00, 0x01, 0x04, 0x07, 0x05, 0x13, 0x8E, // "Ũ" (U+0168)
  0x01, 0x69, 0x00, 0x01, 0x04, 0x06, 0x05, 0x13, 0xA1, // "ũ" (U+0169)
  0x01, 0x6A, 0x00, 0x01, 0x04, 0x07, 0x05, 0x13, 0xB2, // "Ū" (U+016A)
  0x01, 0x6B, 0x00, 0x01, 0x04, 0x06, 0x05, 0x13, 0xC5, // "ū" (U+016B)
  0x01, 0x6C, 0x00, 0x01, 0x04, 0x08, 0x05, 0x13, 0xD6, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x00, 0x01, 0x04, 0x07, 0x05, 0x13, 0xEC, // "ŭ" (U+016D)
  0x01, 0x6E, 0x00, 0x01, 0x04, 0x08, 0x05, 0x14, 0x00, // "Ů" (U+016E)
  0x01, 0x6F, 0x00, 0x01, 0x04, 0x07, 0x05, 0x14, 0x16, // "ů" (U+016F)
  0x01, 0x70, 0x00, 0x01, 0x04, 0x08, 0x05, 0x14, 0x2A, // "Ű" (U+0170)
  0x01, 0x71, 0x00, 0x01, 0x04, 0x07, 0x05, 0x14, 0x40, // "ű" (U+0171)
  0x01, 0x72, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x14, 0x53, // "Ų" (U+0172)
  0x01, 0x73, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x14, 0x6B, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x04, 0x09, 0x05, 0x14, 0x7F, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x04, 0x08, 0x05, 0x14, 0x97, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x01, 0x04, 0x09, 0x05, 0x14, 0xAA, // "Ŷ" (U+0176)
  0x01, 0x77, 0x00, 0xFF, 0x04, 0x08, 0x05, 0x14, 0xBF, // "ŷ" (U+0177)
  0x01, 0x78, 0x00, 0x01, 0x04, 0x08, 0x05, 0x14, 0xD7, // "Ÿ" (U+0178)
  0x01, 0x79, 0x00, 0x01, 0x04, 0x09, 0x05, 0x14, 0xEB, // "Ź" (U+0179)
  0x01, 0x7A, 0x00, 0x01, 0x03, 0x08, 0x05, 0x15, 0x00, // "ź" (U+017A)
  0x01, 0x7B, 0x00, 0x01, 0x03, 0x08, 0x05, 0x15, 0x10, // "Ż" (U+017B)
  0x01, 0x7C, 0x00, 0x01, 0x03, 0x07, 0x05, 0x15, 0x22, // "ż" (U+017C)
  0x01, 0x7D, 0x00, 0x01, 0x04, 0x09, 0x05, 0x15, 0x30, // "Ž" (U+017D)
  0x01, 0x7E, 0x00, 0x01, 0x03, 0x08, 0x05, 0x15, 0x47, // "ž" (U+017E)
  0x01, 0x7F, 0x01, 0x01, 0x04, 0x07, 0x05, 0x15, 0x59, // "ſ" (U+017F)
  0x03, 0xA9, 0x00, 0x01, 0x04, 0x07, 0x05, 0x15, 0x6A, // "Ω" (U+03A9)
  0x03, 0xBC, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x15, 0x7D, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x01, 0x04, 0x05, 0x05, 0x15, 0x8F, // "π" (U+03C0)
  0x20, 0x13, 0x00, 0x03, 0x03, 0x03, 0x05, 0x15, 0x9E, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x03, 0x04, 0x03, 0x05, 0x15, 0xA1, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x01, 0x04, 0x07, 0x05, 0x15, 0xA4, // "€" (U+20AC)
  0x20, 0xBF, 0x00, 0x00, 0x04, 0x08, 0x05, 0x15, 0xB8, // "₿" (U+20BF)
  0x20, 0x18, 0x02, 0x05, 0x02, 0x07, 0x05, 0x15, 0xD1, // "‘" (U+2018)
  0x20, 0x19, 0x01, 0x06, 0x02, 0x07, 0x05, 0x15, 0xD4, // "’" (U+2019)
  0x20, 0x1A, 0x01, 0x00, 0x02, 0x02, 0x05, 0x15, 0xD7, // "‚" (U+201A)
  0x20, 0x1B, 0x01, 0x05, 0x02, 0x07, 0x05, 0x15, 0xDB, // "‛" (U+201B)
  0x20, 0x1C, 0x01, 0x05, 0x03, 0x07, 0x05, 0x15, 0xDF, // "“" (U+201C)
  0x20, 0x1D, 0x01, 0x03, 0x03, 0x05, 0x05, 0x15, 0xE5, // "”" (U+201D)
  0x20, 0x1E, 0x00, 0x00, 0x03, 0x02, 0x05, 0x15, 0xEB, // "„" (U+201E)
  0x20, 0x1F, 0x01, 0x03, 0x03, 0x05, 0x05, 0x15, 0xF3, // "‟" (U+201F)
  0x20, 0x20, 0x00, 0x01, 0x03, 0x07, 0x05, 0x15, 0xF9, // "†" (U+2020)
  0x20, 0x21, 0x00, 0x01, 0x03, 0x07, 0x05, 0x16, 0x06, // "‡" (U+2021)
  0x20, 0x22, 0x01, 0x03, 0x03, 0x04, 0x05, 0x16, 0x16, // "•" (U+2022)
  0x20, 0x26, 0x00, 0x01, 0x04, 0x01, 0x05, 0x16, 0x1A, // "…" (U+2026)
  0x20, 0x30, 0x00, 0x01, 0x04, 0x07, 0x05, 0x16, 0x1E, // "‰" (U+2030)
  0x20, 0x39, 0x01, 0x01, 0x03, 0x04, 0x05, 0x16, 0x31, // "‹" (U+2039)
  0x20, 0x3A, 0x01, 0x01, 0x03, 0x04, 0x05, 0x16, 0x39, // "›" (U+203A)
  0x20, 0x44, 0xFE, 0x01, 0x01, 0x07, 0x00, 0x16, 0x41, // "⁄" (U+2044)
  0x21, 0x22, 0xFF, 0x03, 0x04, 0x06, 0x05, 0x16, 0x4F, // "™" (U+2122)
  0x21, 0x52, 0x02, 0x01, 0x0C, 0x07, 0x0E, 0x16, 0x5D, // "⅒" (U+2152)
  0x22, 0x02, 0x00, 0x01, 0x04, 0x06, 0x05, 0x16, 0x80, // "∂" (U+2202)
  0x22, 0x06, 0x00, 0x01, 0x04, 0x07, 0x05, 0x16, 0x91, // "∆" (U+2206)
  0x22, 0x1A, 0x00, 0x01, 0x04, 0x08, 0x05, 0x16, 0xA5, // "√" (U+221A)
  0x22, 0x1E, 0x00, 0x02, 0x04, 0x04, 0x05, 0x16, 0xB9, // "∞" (U+221E)
  0x22, 0x48, 0x00, 0x03, 0x04, 0x05, 0x05, 0x16, 0xC2, // "≈" (U+2248)
  0x22, 0x60, 0x00, 0x02, 0x04, 0x05, 0x05, 0x16, 0xCA, // "≠" (U+2260)
  0x22, 0x64, 0x00, 0x01, 0x04, 0x06, 0x05, 0x16, 0xD4, // "≤" (U+2264)
  0x22, 0x65, 0x00, 0x01, 0x04, 0x06, 0x05, 0x16, 0xE2, // "≥" (U+2265)
  
  // Kerning pairs
  
  // Glyph data
  // "!" (U+0021)
  0x85, 0xCC, 0xBA, 0xA0, 0x80,
  // """ (U+0022)
  0x85, 0xA3, 0x78, 0x16, 0x12,
  // "#" (U+0023)
  0x18, 0x12, 0x68, 0x28, 0xB1, 0x53, 0x80, 0x6D, 0xBD, 0x70, 0x81, 0x70, 0x9D, 0xCC, 0x40, 0x86,
  0x20, 0x16, 0x82,
  // "$" (U+0024)
  0x18, 0x92, 0x19, 0x10, 0x2C, 0xB8, 0x04, 0x67, 0x38, 0x1B, 0xB1, 0x30, 0xA0, 0xB3, 0x85, 0x7A,
  0x12, 0xBD, 0x63, 0x03, 0x20,
  // "%" (U+0025)
  0x8A, 0x08, 0xB0, 0x90, 0x95, 0x57, 0x09, 0x6B, 0x10, 0x7A, 0x93, 0x89, 0x45, 0x7B, 0x50, 0x97,
  0x29, 0x27, 0x3C, 0x70,
  // "&" (U+0026)
  0x10, 0x0B, 0x28, 0x22, 0x78, 0x22, 0x09, 0x0B, 0x30, 0xC0, 0x62, 0x89, 0x56, 0x7A, 0x73, 0xA1,
  0x4D, 0x04, 0xCA, 0x94,
  // "'" (U+0027)
  0x81, 0xA8, 0x10,
  // "(" (U+0028)
  0x18, 0x96, 0x72, 0x0A, 0x03, 0x70, 0x55, 0x05, 0x50, 0x47, 0x20, 0xA2, 0x07, 0x02,
  // ")" (U+0029)
  0x02, 0x07, 0x20, 0xA2, 0x89, 0x67, 0x30, 0x55, 0x05, 0x50, 0x73, 0x0A, 0x02, 0x71,
  // "*" (U+002A)
  0x28, 0x94, 0x80, 0x28, 0xA9, 0x04, 0xC2, 0x06, 0x15,
  // "+" (U+002B)
  0x20, 0x92, 0x83, 0x4B, 0xDB, 0x12, 0x09, 0x40, 0x92,
  // "," (U+002C)
  0x18, 0x32, 0x0C, 0x37,
  // "-" (U+002D)
  0x81, 0x9B, 0x60,
  // "." (U+002E)
  0x08,
  // "/" (U+002F)
  0x28, 0x97, 0xA0, 0x45, 0x09, 0x10, 0xA0, 0x46, 0x08, 0x10, 0xA2,
  // "0" (U+0030)
  0x18, 0xB7, 0xAB, 0x70, 0x47, 0x1E, 0x07, 0x37, 0x93, 0x73, 0xA5, 0x46, 0xB3, 0x63, 0x3B, 0x0A,
  0x10, 0x9B, 0x71,
  // "1" (U+0031)
  0x10, 0x60, 0xE2, 0x81, 0x17, 0xA4, 0x0A, 0x40, 0xA4, 0x0A, 0x40, 0xA3, 0x82, 0x8D, 0x91,
  // "2" (U+0032)
  0x82, 0x1B, 0xB7, 0x28, 0x11, 0x0B, 0x40, 0xB3, 0x03, 0x09, 0x28, 0x11, 0xB1, 0x20, 0xA0, 0x32,
  0x83, 0x6E, 0xBB, 0x40,
  // "3" (U+0033)
  0x82, 0x2B, 0xB7, 0x28, 0x11, 0x0C, 0x40, 0xB2, 0x81, 0x6D, 0x64, 0x0A, 0x01, 0x38, 0x4A, 0x14,
  0xBB, 0x71,
  // "4" (U+0034)
  0x20, 0x70, 0x83, 0x0B, 0x08, 0x28, 0x16, 0x68, 0x28, 0x94, 0xA2, 0x80, 0x46, 0x18, 0x07, 0xBB,
  0xD4, 0x20, 0x10, 0x81,
  // "5" (U+0035)
  0x18, 0x4D, 0xB9, 0x01, 0x83, 0x02, 0x07, 0x38, 0x22, 0xDB, 0x54, 0x0B, 0x01, 0x38, 0x4A, 0x13,
  0xBC, 0x71,
  // "6" (U+0036)
  0x18, 0x45, 0xCA, 0x01, 0xB3, 0x00, 0x53, 0x8A, 0x17, 0x8B, 0x90, 0x76, 0x08, 0x34, 0x60, 0x73,
  0x09, 0xB9, 0x10,
  // "7" (U+0037)
  0x83, 0x6B, 0xBD, 0x43, 0x09, 0x40, 0xA3, 0x00, 0x53, 0x0A, 0x30, 0x10, 0xA3, 0x06, 0x05, 0x20,
  // "8" (U+0038)
  0x18, 0x93, 0xAB, 0x80, 0x37, 0x0A, 0x01, 0xC8, 0xB2, 0x8A, 0x09, 0xD5, 0x04, 0x70, 0xA1, 0x65,
  0x08, 0x21, 0xBB, 0x81,
  // "9" (U+0039)
  0x18, 0xA6, 0xAC, 0x70, 0x55, 0x0A, 0x17, 0x30, 0x64, 0x56, 0x0A, 0x40, 0x9B, 0xA2, 0x30, 0xA2,
  0x81, 0xBB, 0x31,
  // ":" (U+003A)
  0x08, 0x30, 0x80,
  // ";" (U+003B)
  0x10, 0x85, 0x83, 0x20, 0xC3, 0x70,
  // "<" (U+003C)
  0x28, 0x66, 0x24, 0x93, 0x0A, 0x63, 0x81, 0x39, 0x20,
  // "=" (U+003D)
  0x83, 0x5B, 0xBB, 0x25, 0x83, 0x5B, 0xBB, 0x20,
  // ">" (U+003E)
  0x02, 0x06, 0x38, 0x13, 0x94, 0x28, 0x36, 0xA2, 0x93, 0x10,
  // "?" (U+003F)
  0x82, 0x1C, 0xB7, 0x30, 0xA3, 0x0A, 0x20, 0x60, 0x82, 0x0A, 0x20, 0x10, 0x32, 0x02, 0x06, 0x10,
  // "@" (U+0040)
  0x18, 0xB5, 0x9B, 0x90, 0x64, 0x05, 0x58, 0x4C, 0x78, 0x89, 0x17, 0x88, 0x93, 0x78, 0x96, 0xA9,
  0x36, 0x54, 0x81, 0x8B, 0x91,
  // "A" (U+0041)
  0x10, 0x10, 0xE3, 0x81, 0x6C, 0x22, 0x81, 0x94, 0x62, 0x89, 0x5A, 0x0A, 0x02, 0xDB, 0xD0, 0x74,
  0x07, 0x3A, 0x20, 0x30, 0x70,
  // "B" (U+0042)
  0x8C, 0x03, 0xDB, 0x90, 0x36, 0x09, 0x23, 0x60, 0xA1, 0x3D, 0xC9, 0x03, 0x60, 0x83, 0x36, 0x07,
  0x43, 0xDB, 0xA1,
  // "C" (U+0043)
  0x18, 0x46, 0xCB, 0x31, 0xB3, 0x00, 0x53, 0x06, 0x04, 0x30, 0x05, 0x30, 0x20, 0xA4, 0x82, 0x6C,
  0xB1,
  // "D" (U+0044)
  0x8C, 0x06, 0xCC, 0x50, 0x64, 0x0B, 0x16, 0x40, 0x65, 0x64, 0x05, 0x66, 0x40, 0x64, 0x64, 0x0B,
  0x16, 0xCB, 0x41,
  // "E" (U+0045)
  0x85, 0x3D, 0xBB, 0x13, 0x73, 0x03, 0x07, 0x38, 0x53, 0xDB, 0xB0, 0x37, 0x30, 0x30, 0x73, 0x83,
  0x3D, 0xBB, 0x10,
  // "F" (U+0046)
  0x85, 0x3D, 0xBB, 0x13, 0x73, 0x03, 0x07, 0x38, 0x53, 0xDB, 0xB0, 0x37, 0x30, 0x30, 0x73, 0x03,
  0x07, 0x30,
  // "G" (U+0047)
  0x18, 0x47, 0xBB, 0x03, 0x93, 0x08, 0x03, 0x38, 0xA2, 0x91, 0x5C, 0x38, 0x30, 0x73, 0x48, 0x07,
  0x30, 0x9B, 0xC2,
  // "H" (U+0048)
  0x8C, 0x16, 0x40, 0x73, 0x64, 0x07, 0x36, 0x40, 0x73, 0x6C, 0xBD, 0x36, 0x40, 0x73, 0x64, 0x07,
  0x36, 0x40, 0x73,
  // "I" (U+0049)
  0x82, 0x1B, 0xE9, 0x20, 0xB3, 0x0B, 0x30, 0xB3, 0x0B, 0x38, 0x4B, 0x01, 0xAE, 0x90,
  // "J" (U+004A)
  0x30, 0xB3, 0x0B, 0x30, 0xB3, 0x0B, 0x30, 0xB2, 0x84, 0x29, 0x2B, 0xC3,
  // "K" (U+004B)
  0x89, 0x36, 0x40, 0xB1, 0x64, 0x66, 0x06, 0x5B, 0x28, 0x16, 0xC9, 0x28, 0x95, 0x67, 0xA1, 0x06,
  0x43, 0x90, 0x64, 0x0A, 0x20,
  // "L" (U+004C)
  0x01, 0x09, 0x30, 0x10, 0x93, 0x01, 0x09, 0x30, 0x10, 0x93, 0x01, 0x09, 0x30, 0x10, 0x93, 0x83,
  0x1E, 0xBB, 0x10,
  // "M" (U+004D)
  0x8C, 0x19, 0x80, 0xB6, 0x9A, 0x0D, 0x69, 0xA3, 0xA6, 0x96, 0xA6, 0x69, 0x3E, 0x46, 0x91, 0x34,
  0x69, 0x10, 0x46,
  // "N" (U+004E)
  0x8C, 0x16, 0xA0, 0x73, 0x6C, 0x17, 0x36, 0x76, 0x73, 0x63, 0x97, 0x36, 0x38, 0x83, 0x63, 0x2D,
  0x36, 0x30, 0xC3,
  // "O" (U+004F)
  0x18, 0xB7, 0xAC, 0x80, 0x56, 0x09, 0x28, 0x20, 0x55, 0x91, 0x04, 0x68, 0x20, 0x55, 0x56, 0x09,
  0x20, 0xAC, 0x81,
  // "P" (U+0050)
  0x8B, 0x13, 0xDB, 0xA0, 0x37, 0x08, 0x33, 0x70, 0x64, 0x37, 0x0A, 0x23, 0xDB, 0x70, 0x37, 0x30,
  0x30, 0x73,
  // "Q" (U+0051)
  0x18, 0xB7, 0xAC, 0x80, 0x56, 0x09, 0x28, 0x20, 0x55, 0x91, 0x04, 0x68, 0x20, 0x55, 0x56, 0x09,
  0x20, 0xAC, 0xA4, 0x0B, 0x40, 0x40, 0x10,
  // "R" (U+0052)
  0x8C, 0x13, 0xDB, 0x80, 0x37, 0x0B, 0x03, 0x70, 0xB0, 0x3D, 0xD5, 0x03, 0x75, 0x60, 0x37, 0x0B,
  0x03, 0x70, 0x75,
  // "S" (U+0053)
  0x18, 0x49, 0xCB, 0x02, 0x94, 0x0B, 0x01, 0x38, 0x14, 0xC5, 0x40, 0xB0, 0x13, 0x84, 0x92, 0x3C,
  0xB9, 0x10,
  // "T" (U+0054)
  0x83, 0x7B, 0xEB, 0x52, 0x0B, 0x40, 0xB4, 0x0B, 0x40, 0xB4, 0x0B, 0x40, 0xB2,
  // "U" (U+0055)
  0x8C, 0x06, 0x40, 0x73, 0x64, 0x07, 0x36, 0x40, 0x73, 0x64, 0x07, 0x36, 0x40, 0x73, 0x47, 0x0A,
  0x10, 0xBC, 0x81,
  // "V" (U+0056)
  0x89, 0x4A, 0x10, 0x47, 0x64, 0x07, 0x32, 0x80, 0xA2, 0x81, 0xA0, 0xA2, 0x81, 0x94, 0x62, 0x81,
  0x5B, 0x22, 0x01, 0x0E, 0x20,
  // "W" (U+0057)
  0x0A, 0x28, 0x11, 0x89, 0x28, 0xB1, 0x27, 0x81, 0xC3, 0x67, 0x5B, 0x54, 0x69, 0x59, 0x34, 0xB1,
  0xD2, 0x3A, 0x0D, 0x10,
  // "X" (U+0058)
  0x87, 0x56, 0x09, 0x20, 0xA1, 0x92, 0x81, 0x5B, 0x32, 0x01, 0x0D, 0x38, 0x17, 0x94, 0x28, 0x7A,
  0x0A, 0x07, 0x40, 0x74,
  // "Y" (U+0059)
  0x87, 0x84, 0x06, 0x41, 0x90, 0xA2, 0x81, 0xA3, 0x72, 0x81, 0x4D, 0x13, 0x0B, 0x40, 0xA4, 0x0A,
  0x20,
  // "Z" (U+005A)
  0x18, 0x1B, 0xBE, 0x20, 0x10, 0x92, 0x07, 0x03, 0x20, 0xA2, 0x06, 0x05, 0x20, 0xA2, 0x82, 0x3D,
  0xBB,
  // "[" (U+005B)
  0x8A, 0x61, 0xE8, 0x19, 0x01, 0x90, 0x19, 0x01, 0x90, 0x19, 0x01, 0x90, 0x1C, 0x80,
  // "\" (U+005C)
  0x0A, 0x28, 0x35, 0x40, 0x19, 0x20, 0xA2, 0x83, 0x63, 0x01, 0x82, 0x0A,
  // "]" (U+005D)
  0x8A, 0x68, 0xC1, 0x09, 0x10, 0x91, 0x09, 0x10, 0x91, 0x09, 0x10, 0x91, 0x8E, 0x10,
  // "^" (U+005E)
  0x10, 0x10, 0xB3, 0x81, 0x77, 0x32, 0x87, 0x80, 0x90, 0x53, 0x06, 0x20,
  // "_" (U+005F)
  0x80, 0x0B, 0x09,
  // "`" (U+0060)
  0x82, 0x33, 0x09,
  // "a" (U+0061)
  0x18, 0x1B, 0xC9, 0x48, 0x97, 0xA0, 0x1A, 0xBD, 0x16, 0x50, 0xA1, 0x2C, 0xAA, 0x10,
  // "b" (U+0062)
  0x00, 0x53, 0x00, 0x53, 0x8A, 0x65, 0xAB, 0x90, 0x58, 0x08, 0x35, 0x50, 0x65, 0x58, 0x08, 0x35,
  0x9B, 0x91,
  // "c" (U+0063)
  0x18, 0x38, 0xBB, 0x29, 0x20, 0x40, 0x62, 0x02, 0x09, 0x38, 0x18, 0xBB,
  // "d" (U+0064)
  0x30, 0x80, 0x23, 0x8B, 0x18, 0x21, 0xBB, 0xB2, 0x65, 0x0B, 0x28, 0x30, 0x82, 0x65, 0x0B, 0x21,
  0xBB, 0xA2,
  // "e" (U+0065)
  0x18, 0x96, 0xAB, 0x80, 0x57, 0x08, 0x27, 0xCB, 0xC4, 0x56, 0x48, 0x29, 0xBB, 0x10,
  // "f" (U+0066)
  0x28, 0x1A, 0xB5, 0x20, 0xA2, 0x86, 0x4B, 0xEB, 0x30, 0x19, 0x30, 0x10, 0x93, 0x01, 0x09, 0x30,
  0x10, 0x92,
  // "g" (U+0067)
  0x10, 0xFB, 0x8A, 0x32, 0x65, 0x0A, 0x28, 0x30, 0x72, 0x65, 0x0A, 0x21, 0xBB, 0xB2, 0x38, 0x4A,
  0x13, 0xBB, 0x81,
  // "h" (U+0068)
  0x00, 0x53, 0x00, 0x53, 0x8A, 0x75, 0x9B, 0xA0, 0x58, 0x09, 0x25, 0x50, 0x83, 0x55, 0x08, 0x35,
  0x50, 0x83,
  // "i" (U+0069)
  0x20, 0x87, 0x81, 0x2A, 0xD4, 0x0B, 0x40, 0xB4, 0x0B, 0x28, 0x33, 0x9E, 0x92,
  // "j" (U+006A)
  0x20, 0x70, 0x15, 0x81, 0x8D, 0x22, 0x08, 0x02, 0x20, 0x80, 0x22, 0x08, 0x02, 0x20, 0x80, 0x22,
  0x83, 0x92, 0x6B, 0xA1,
  // "k" (U+006B)
  0x02, 0x08, 0x30, 0x20, 0x83, 0x89, 0x32, 0x80, 0xB2, 0x28, 0x84, 0x02, 0xCD, 0x28, 0x90, 0x2A,
  0x39, 0x02, 0x80, 0x83,
  // "l" (U+006C)
  0x81, 0x3B, 0xD4, 0x0B, 0x40, 0xB4, 0x0B, 0x40, 0xB4, 0x0B, 0x28, 0x33, 0x9D, 0x92,
  // "m" (U+006D)
  0x8A, 0x78, 0xA9, 0xC2, 0x92, 0xC4, 0x59, 0x0A, 0x36, 0x90, 0x93, 0x69, 0x09, 0x36,
  // "n" (U+006E)
  0x8A, 0x75, 0x9B, 0xB0, 0x58, 0x09, 0x25, 0x50, 0x83, 0x55, 0x08, 0x35, 0x50, 0x83,
  // "o" (U+006F)
  0x18, 0xA5, 0xBB, 0x80, 0x65, 0x09, 0x38, 0x20, 0x65, 0x65, 0x09, 0x30, 0xBC, 0x91,
  // "p" (U+0070)
  0x8B, 0x15, 0x9B, 0x90, 0x57, 0x08, 0x35, 0x50, 0x65, 0x58, 0x08, 0x35, 0xAB, 0xA0, 0x55, 0x30,
  0x05, 0x30,
  // "q" (U+0071)
  0x8A, 0x71, 0xBB, 0xA2, 0x65, 0x0B, 0x28, 0x30, 0x82, 0x65, 0x0B, 0x21, 0xBB, 0xB2, 0x30, 0x80,
  0x23, 0x08, 0x02,
  // "r" (U+0072)
  0x86, 0x4C, 0x9C, 0x60, 0x3C, 0x30, 0x30, 0x83, 0x03, 0x08, 0x28, 0x24, 0xAC, 0x61,
  // "s" (U+0073)
  0x18, 0x3A, 0xB9, 0x0B, 0x38, 0x14, 0xA4, 0x38, 0x3B, 0x1C, 0xB8,
  // "t" (U+0074)
  0x10, 0x02, 0x30, 0x05, 0x28, 0x25, 0xDD, 0xB2, 0x06, 0x05, 0x30, 0x60, 0x53, 0x05, 0x06, 0x38,
  0x21, 0xBB, 0x10,
  // "u" (U+0075)
  0x8A, 0x76, 0x40, 0x82, 0x64, 0x08, 0x26, 0x40, 0x82, 0x56, 0x0B, 0x21, 0xCB, 0xA2,
  // "v" (U+0076)
  0x87, 0x73, 0x07, 0x42, 0x80, 0xA2, 0x81, 0xA1, 0x92, 0x81, 0x87, 0x42, 0x03, 0x0E, 0x20,
  // "w" (U+0077)
  0x0A, 0x38, 0xA2, 0x9A, 0x2D, 0x27, 0x87, 0xA7, 0x56, 0xB3, 0xC2, 0x4B, 0x0E, 0x10,
  // "x" (U+0078)
  0x87, 0x38, 0x0A, 0x10, 0x98, 0x62, 0x02, 0x0E, 0x38, 0x7A, 0x67, 0x05, 0x70, 0xA2,
  // "y" (U+0079)
  0x87, 0x73, 0x07, 0x41, 0x90, 0xA2, 0x81, 0xA1, 0x92, 0x81, 0x59, 0x43, 0x0D, 0x30, 0x20, 0x92,
  0x81, 0x5C, 0x22,
  // "z" (U+007A)
  0x82, 0x1B, 0xBE, 0x28, 0x34, 0x70, 0x1A, 0x28, 0x59, 0x20, 0x3E, 0xBB,
  // "{" (U+007B)
  0x18, 0x27, 0x80, 0xB2, 0x0A, 0x28, 0x2A, 0x0C, 0x52, 0x0B, 0x20, 0xB2, 0x07, 0x08,
  // "|" (U+007C)
  0x80, 0x59,
  // "}" (U+007D)
  0x08, 0x07, 0x20, 0xB2, 0x0B, 0x28, 0x25, 0xC0, 0xA2, 0x0A, 0x28, 0x2B, 0x08, 0x71,
  // "~" (U+007E)
  0x87, 0x19, 0x44, 0x14, 0x16, 0x71,
  // "¡" (U+00A1)
  0x85, 0x80, 0xAA, 0xBC, 0xC0,
  // "¢" (U+00A2)
  0x20, 0x82, 0x83, 0x6D, 0xB1, 0xA2, 0x04, 0x07, 0x20, 0x20, 0xA3, 0x81, 0x6D, 0xB2, 0x08, 0x10,
  // "£" (U+00A3)
  0x18, 0x12, 0xCB, 0x20, 0x70, 0x33, 0x08, 0x02, 0x28, 0x22, 0xDC, 0x62, 0x08, 0x02, 0x30, 0x90,
  0x12, 0x83, 0x3E, 0xBB, 0x20,
  // "¤" (U+00A4)
  0x8A, 0x23, 0xCB, 0xB1, 0x17, 0x08, 0x01, 0x70, 0x90, 0x3B, 0xBC, 0x10,
  // "¥" (U+00A5)
  0x87, 0x83, 0x06, 0x52, 0x80, 0xA2, 0x81, 0xA2, 0x82, 0x89, 0x36, 0xB2, 0x01, 0xCE, 0xA0, 0x1B,
  0xEA, 0x30, 0xA2,
  // "¦" (U+00A6)
  0x0F, 0x93, 0x0F, 0x90,
  // "§" (U+00A7)
  0x18, 0x3A, 0xB8, 0x0B, 0x38, 0x91, 0x9A, 0x50, 0xA0, 0x90, 0x4B, 0x83, 0x83, 0xA1, 0xBB, 0x70,
  // "¨" (U+00A8)
  0x81, 0x70, 0x60,
  // "©" (U+00A9)
  0x18, 0x91, 0x67, 0x50, 0x54, 0x74, 0x36, 0x72, 0x89, 0x06, 0x55, 0x74, 0x30, 0x67, 0x41,
  // "ª" (U+00AA)
  0x87, 0x37, 0x47, 0x66, 0x45, 0x40,
  // "«" (U+00AB)
  0x18, 0x95, 0x34, 0x71, 0xA7, 0x40, 0xA5, 0x70, 0x13, 0x40,
  // "¬" (U+00AC)
  0x83, 0x4B, 0xBC, 0x13, 0x07, 0x01, 0x30, 0x21,
  // "®" (U+00AE)
  0x18, 0xA5, 0x67, 0x50, 0x55, 0x75, 0x36, 0x4A, 0x16, 0x55, 0x37, 0x30, 0x67, 0x41,
  // "¯" (U+00AF)
  0x81, 0x9B, 0x60,
  // "°" (U+00B0)
  0x87, 0x48, 0x28, 0x07, 0x49, 0x20,
  // "±" (U+00B1)
  0x20, 0x92, 0x83, 0x4B, 0xDB, 0x12, 0x09, 0x40, 0x92, 0x83, 0x4B, 0xBB, 0x10,
  // "²" (U+00B2)
  0x89, 0x24, 0x73, 0x02, 0x61, 0x80, 0x88, 0x50,
  // "³" (U+00B3)
  0x89, 0x23, 0x73, 0x2A, 0x30, 0x17, 0x68, 0x20,
  // "´" (U+00B4)
  0x81, 0x33, 0x91,
  // "µ" (U+00B5)
  0x8B, 0x16, 0x40, 0x82, 0x64, 0x08, 0x26, 0x40, 0x82, 0x66, 0x0B, 0x26, 0xEB, 0xA2, 0x64, 0x30,
  0x60, 0x43,
  // "¶" (U+00B6)
  0x84, 0x2D, 0xFC, 0x47, 0xA8, 0x12, 0x49, 0xA8, 0x12, 0x47, 0xA8, 0x52, 0x41, 0x9C, 0x24, 0x28,
  0x16, 0x24, 0x28, 0x16, 0x24, 0x28, 0x16, 0x24, 0x28, 0x11, 0x01,
  // "·" (U+00B7)
  0x08,
  // "¸" (U+00B8)
  0x18, 0x31, 0x09, 0x38,
  // "¹" (U+00B9)
  0x83, 0x48, 0x01, 0x72, 0x83, 0x80, 0x39, 0x40,
  // "º" (U+00BA)
  0x87, 0x67, 0x48, 0x07, 0x47, 0x20,
  // "»" (U+00BB)
  0x89, 0x54, 0x31, 0x07, 0x5A, 0x04, 0x7A, 0x17, 0x43, 0x10,
  // "¼" (U+00BC)
  0x89, 0x48, 0x60, 0x80, 0x16, 0x17, 0x05, 0x88, 0x12, 0x8A, 0x01, 0x89, 0x20, 0x74, 0xA2, 0x08,
  0x6A, 0x61, 0x10, 0x11,
  // "½" (U+00BD)
  0x89, 0x48, 0x60, 0x80, 0x16, 0x18, 0x06, 0xA7, 0x23, 0x8A, 0x0B, 0x93, 0x05, 0x41, 0x60, 0x90,
  0x81, 0x25, 0x3A, 0x50,
  // "¾" (U+00BE)
  0x89, 0x45, 0x80, 0x60, 0x3B, 0x18, 0x06, 0x87, 0x23, 0x89, 0x78, 0xA2, 0x07, 0x5A, 0x20, 0x86,
  0xA6, 0x11, 0x01, 0x10,
  // "¿" (U+00BF)
  0x10, 0x60, 0x22, 0x03, 0x01, 0x20, 0xA2, 0x08, 0x06, 0x20, 0xA3, 0x0A, 0x38, 0x27, 0xBB, 0x10,
  // "À" (U+00C0)
  0x00, 0x34, 0x09, 0x40, 0x10, 0xE3, 0x81, 0x6C, 0x22, 0x81, 0x94, 0x62, 0x89, 0x5A, 0x0A, 0x02,
  0xDB, 0xD0, 0x74, 0x07, 0x3A, 0x20, 0x30, 0x70,
  // "Á" (U+00C1)
  0x20, 0x03, 0x30, 0x93, 0x01, 0x0E, 0x38, 0x16, 0xC2, 0x28, 0x19, 0x46, 0x28, 0x95, 0xA0, 0xA0,
  0x2D, 0xBD, 0x07, 0x40, 0x73, 0xA2, 0x03, 0x07,
  // "Â" (U+00C2)
  0x20, 0x63, 0x81, 0x86, 0x62, 0x01, 0x0E, 0x38, 0x16, 0xC2, 0x28, 0x19, 0x46, 0x28, 0x95, 0xA0,
  0xA0, 0x2D, 0xBD, 0x07, 0x40, 0x73, 0xA2, 0x03, 0x07,
  // "Ã" (U+00C3)
  0x18, 0x1A, 0xF6, 0x28, 0x16, 0xC2, 0x28, 0x19, 0x46, 0x28, 0x95, 0xA0, 0xA0, 0x2D, 0xBD, 0x07,
  0x40, 0x73, 0xA2, 0x03, 0x07,
  // "Ä" (U+00C4)
  0x18, 0x17, 0x06, 0x20, 0x10, 0xE3, 0x81, 0x6C, 0x22, 0x81, 0x94, 0x62, 0x89, 0x5A, 0x0A, 0x02,
  0xDB, 0xD0, 0x74, 0x07, 0x3A, 0x20, 0x30, 0x70,
  // "Å" (U+00C5)
  0x18, 0x13, 0x71, 0x28, 0x15, 0xF1, 0x28, 0x16, 0xC2, 0x28, 0x19, 0x46, 0x28, 0x95, 0xA0, 0xA0,
  0x2D, 0xBD, 0x07, 0x40, 0x73, 0xA2, 0x03, 0x07,
  // "Æ" (U+00C6)
  0x18, 0x59, 0xEB, 0x40, 0xAA, 0x30, 0x90, 0xA2, 0x86, 0x37, 0xBB, 0x26, 0xCD, 0x28, 0x18, 0x1A,
  0x28, 0x3A, 0x0B, 0xB4,
  // "Ç" (U+00C7)
  0x18, 0x46, 0xCB, 0x31, 0xB3, 0x00, 0x53, 0x06, 0x04, 0x30, 0x05, 0x30, 0x20, 0xA4, 0x82, 0x6C,
  0xD1, 0x30, 0x93, 0x03, 0x08, 0x10,
  // "È" (U+00C8)
  0x00, 0x34, 0x09, 0x38, 0x53, 0xDB, 0xB1, 0x37, 0x30, 0x30, 0x73, 0x85, 0x3D, 0xBB, 0x03, 0x73,
  0x03, 0x07, 0x38, 0x33, 0xDB, 0xB1,
  // "É" (U+00C9)
  0x20, 0x03, 0x30, 0x92, 0x85, 0x3D, 0xBB, 0x13, 0x73, 0x03, 0x07, 0x38, 0x53, 0xDB, 0xB0, 0x37,
  0x30, 0x30, 0x73, 0x83, 0x3D, 0xBB, 0x10,
  // "Ê" (U+00CA)
  0x20, 0x63, 0x89, 0x18, 0x66, 0x03, 0xDB, 0xB1, 0x37, 0x30, 0x30, 0x73, 0x85, 0x3D, 0xBB, 0x03,
  0x73, 0x03, 0x07, 0x38, 0x33, 0xDB, 0xB1,
  // "Ë" (U+00CB)
  0x18, 0x91, 0x70, 0x60, 0x3D, 0xBB, 0x13, 0x73, 0x03, 0x07, 0x38, 0x53, 0xDB, 0xB0, 0x37, 0x30,
  0x30, 0x73, 0x83, 0x3D, 0xBB, 0x10,
  // "Ì" (U+00CC)
  0x00, 0x33, 0x09, 0x28, 0x21, 0xBE, 0x92, 0x0B, 0x30, 0xB3, 0x0B, 0x30, 0xB3, 0x84, 0xB0, 0x1A,
  0xE9,
  // "Í" (U+00CD)
  0x20, 0x03, 0x28, 0x49, 0x01, 0xBE, 0x92, 0x0B, 0x30, 0xB3, 0x0B, 0x30, 0xB3, 0x84, 0xB0, 0x1A,
  0xE9,
  // "Î" (U+00CE)
  0x20, 0x62, 0x85, 0x86, 0x61, 0xBE, 0x92, 0x0B, 0x30, 0xB3, 0x0B, 0x30, 0xB3, 0x84, 0xB0, 0x1A,
  0xE9,
  // "Ï" (U+00CF)
  0x18, 0x57, 0x06, 0x1B, 0xE9, 0x20, 0xB3, 0x0B, 0x30, 0xB3, 0x0B, 0x38, 0x4B, 0x01, 0xAE, 0x90,
  // "Ð" (U+00D0)
  0x8C, 0x05, 0xDC, 0x60, 0x55, 0x0B, 0x25, 0x50, 0x56, 0xDD, 0x43, 0x75, 0x50, 0x56, 0x55, 0x0B,
  0x15, 0xDB, 0x51,
  // "Ñ" (U+00D1)
  0x8C, 0x16, 0xFB, 0xD3, 0x6C, 0x17, 0x36, 0x76, 0x73, 0x63, 0x97, 0x36, 0x38, 0x83, 0x63, 0x2D,
  0x36, 0x30, 0xC3,
  // "Ò" (U+00D2)
  0x00, 0x34, 0x09, 0x48, 0xB7, 0xAC, 0x80, 0x56, 0x09, 0x28, 0x20, 0x55, 0x91, 0x04, 0x68, 0x20,
  0x55, 0x56, 0x09, 0x20, 0xAC, 0x81,
  // "Ó" (U+00D3)
  0x20, 0x03, 0x30, 0x93, 0x8B, 0x7A, 0xC8, 0x05, 0x60, 0x92, 0x82, 0x05, 0x59, 0x10, 0x46, 0x82,
  0x05, 0x55, 0x60, 0x92, 0x0A, 0xC8, 0x10,
  // "Ô" (U+00D4)
  0x20, 0x63, 0x81, 0x86, 0x62, 0x8B, 0x7A, 0xC8, 0x05, 0x60, 0x92, 0x82, 0x05, 0x59, 0x10, 0x46,
  0x82, 0x05, 0x55, 0x60, 0x92, 0x0A, 0xC8, 0x10,
  // "Õ" (U+00D5)
  0x1B, 0x18, 0xB3, 0x56, 0x09, 0x28, 0x20, 0x55, 0x91, 0x04, 0x68, 0x20, 0x55, 0x56, 0x09, 0x20,
  0xAC, 0x81,
  // "Ö" (U+00D6)
  0x18, 0x17, 0x06, 0x28, 0xB7, 0xAC, 0x80, 0x56, 0x09, 0x28, 0x20, 0x55, 0x91, 0x04, 0x68, 0x20,
  0x55, 0x56, 0x09, 0x20, 0xAC, 0x81,
  // "×" (U+00D7)
  0x89, 0x61, 0x20, 0x40, 0x97, 0x70, 0x5C, 0x31, 0x70, 0x80,
  // "Ø" (U+00D8)
  0x18, 0xB7, 0xAC, 0xC3, 0x56, 0x0E, 0x18, 0x26, 0xA5, 0x91, 0xA4, 0x68, 0x84, 0x55, 0x5C, 0x09,
  0x25, 0xCC, 0x81,
  // "Ù" (U+00D9)
  0x00, 0x34, 0x09, 0x38, 0xC0, 0x64, 0x07, 0x36, 0x40, 0x73, 0x64, 0x07, 0x36, 0x40, 0x73, 0x64,
  0x07, 0x34, 0x70, 0xA1, 0x0B, 0xC8, 0x10,
  // "Ú" (U+00DA)
  0x20, 0x03, 0x30, 0x92, 0x8C, 0x06, 0x40, 0x73, 0x64, 0x07, 0x36, 0x40, 0x73, 0x64, 0x07, 0x36,
  0x40, 0x73, 0x47, 0x0A, 0x10, 0xBC, 0x81,
  // "Û" (U+00DB)
  0x20, 0x63, 0x8C, 0x48, 0x66, 0x06, 0x40, 0x73, 0x64, 0x07, 0x36, 0x40, 0x73, 0x64, 0x07, 0x36,
  0x40, 0x73, 0x47, 0x0A, 0x10, 0xBC, 0x81,
  // "Ü" (U+00DC)
  0x18, 0xC4, 0x70, 0x60, 0x64, 0x07, 0x36, 0x40, 0x73, 0x64, 0x07, 0x36, 0x40, 0x73, 0x64, 0x07,
  0x34, 0x70, 0xA1, 0x0B, 0xC8, 0x10,
  // "Ý" (U+00DD)
  0x20, 0x03, 0x30, 0x92, 0x87, 0x84, 0x06, 0x41, 0x90, 0xA2, 0x81, 0xA3, 0x72, 0x81, 0x4D, 0x13,
  0x0B, 0x40, 0xA4, 0x0A, 0x20,
  // "Þ" (U+00DE)
  0x03, 0x07, 0x30, 0x30, 0x73, 0x8A, 0x43, 0xDB, 0x90, 0x37, 0x08, 0x43, 0x70, 0x83, 0x3D, 0xB8,
  0x03, 0x73,
  // "ß" (U+00DF)
  0x8C, 0x11, 0xBC, 0xA0, 0x55, 0x0B, 0x06, 0x45, 0x70, 0x64, 0x92, 0x06, 0x40, 0xA3, 0x64, 0x02,
  0x86, 0x5B, 0xC4,
  // "à" (U+00E0)
  0x00, 0x34, 0x09, 0x72, 0x81, 0xBC, 0x94, 0x89, 0x7A, 0x01, 0xAB, 0xD1, 0x65, 0x0A, 0x12, 0xCA,
  0xA1,
  // "á" (U+00E1)
  0x20, 0x03, 0x30, 0x97, 0x18, 0x1B, 0xC9, 0x48, 0x97, 0xA0, 0x1A, 0xBD, 0x16, 0x50, 0xA1, 0x2C,
  0xAA, 0x10,
  // "â" (U+00E2)
  0x20, 0x63, 0x81, 0x86, 0x67, 0x81, 0xBC, 0x94, 0x89, 0x7A, 0x01, 0xAB, 0xD1, 0x65, 0x0A, 0x12,
  0xCA, 0xA1,
  // "ã" (U+00E3)
  0x18, 0x19, 0xB6, 0x28, 0x1B, 0xC9, 0x48, 0x97, 0xA0, 0x1A, 0xBD, 0x16, 0x50, 0xA1, 0x2C, 0xAA,
  0x10,
  // "ä" (U+00E4)
  0x18, 0x17, 0x06, 0x78, 0x1B, 0xC9, 0x48, 0x97, 0xA0, 0x1A, 0xBD, 0x16, 0x50, 0xA1, 0x2C, 0xAA,
  0x10,
  // "å" (U+00E5)
  0x18, 0x13, 0x71, 0x28, 0x13, 0x71, 0x28, 0x1B, 0xC9, 0x48, 0x97, 0xA0, 0x1A, 0xBD, 0x16, 0x50,
  0xA1, 0x2C, 0xAA, 0x10,
  // "æ" (U+00E6)
  0x83, 0x5C, 0x8C, 0x32, 0x89, 0x1B, 0x18, 0x6C, 0xEB, 0x8A, 0x0C, 0x28, 0x38, 0xB7, 0xB6,
  // "ç" (U+00E7)
  0x18, 0x38, 0xBB, 0x29, 0x20, 0x40, 0x62, 0x02, 0x09, 0x38, 0x18, 0xBD, 0x30, 0x92, 0x03, 0x08,
  // "è" (U+00E8)
  0x00, 0x34, 0x09, 0x72, 0x89, 0x6A, 0xB8, 0x05, 0x70, 0x82, 0x7C, 0xBC, 0x45, 0x64, 0x82, 0x9B,
  0xB1,
  // "é" (U+00E9)
  0x20, 0x03, 0x30, 0x97, 0x18, 0x96, 0xAB, 0x80, 0x57, 0x08, 0x27, 0xCB, 0xC4, 0x56, 0x48, 0x29,
  0xBB, 0x10,
  // "ê" (U+00EA)
  0x20, 0x63, 0x81, 0x86, 0x67, 0x89, 0x6A, 0xB8, 0x05, 0x70, 0x82, 0x7C, 0xBC, 0x45, 0x64, 0x82,
  0x9B, 0xB1,
  // "ë" (U+00EB)
  0x18, 0x17, 0x06, 0x78, 0x96, 0xAB, 0x80, 0x57, 0x08, 0x27, 0xCB, 0xC4, 0x56, 0x48, 0x29, 0xBB,
  0x10,
  // "ì" (U+00EC)
  0x00, 0x34, 0x09, 0x71, 0x81, 0x2A, 0xD4, 0x0B, 0x40, 0xB4, 0x0B, 0x28, 0x33, 0x9E, 0x92,
  // "í" (U+00ED)
  0x20, 0x03, 0x30, 0x97, 0x81, 0x2A, 0xD4, 0x0B, 0x40, 0xB4, 0x0B, 0x28, 0x33, 0x9E, 0x92,
  // "î" (U+00EE)
  0x20, 0x63, 0x81, 0x86, 0x66, 0x81, 0x2A, 0xD4, 0x0B, 0x40, 0xB4, 0x0B, 0x28, 0x33, 0x9E, 0x92,
  // "ï" (U+00EF)
  0x18, 0x17, 0x06, 0x68, 0x12, 0xAD, 0x40, 0xB4, 0x0B, 0x40, 0xB2, 0x83, 0x39, 0xE9, 0x20,
  // "ð" (U+00F0)
  0x18, 0x13, 0x14, 0x28, 0x13, 0xE6, 0x28, 0x14, 0x29, 0x28, 0xA5, 0x9B, 0xC1, 0x56, 0x09, 0x48,
  0x20, 0x65, 0x55, 0x08, 0x20, 0xAB, 0x81,
  // "ñ" (U+00F1)
  0x28, 0xB2, 0x9B, 0x65, 0x9B, 0xB0, 0x58, 0x09, 0x25, 0x50, 0x83, 0x55, 0x08, 0x35, 0x50, 0x83,
  // "ò" (U+00F2)
  0x00, 0x34, 0x09, 0x72, 0x8A, 0x5B, 0xB8, 0x06, 0x50, 0x93, 0x82, 0x06, 0x56, 0x50, 0x93, 0x0B,
  0xC9, 0x10,
  // "ó" (U+00F3)
  0x20, 0x03, 0x30, 0x97, 0x18, 0xA5, 0xBB, 0x80, 0x65, 0x09, 0x38, 0x20, 0x65, 0x65, 0x09, 0x30,
  0xBC, 0x91,
  // "ô" (U+00F4)
  0x20, 0x63, 0x81, 0x86, 0x67, 0x8A, 0x5B, 0xB8, 0x06, 0x50, 0x93, 0x82, 0x06, 0x56, 0x50, 0x93,
  0x0B, 0xC9, 0x10,
  // "õ" (U+00F5)
  0x18, 0x19, 0xB6, 0x28, 0xA5, 0xBB, 0x80, 0x65, 0x09, 0x38, 0x20, 0x65, 0x65, 0x09, 0x30, 0xBC,
  0x91,
  // "ö" (U+00F6)
  0x18, 0x17, 0x06, 0x78, 0xA5, 0xBB, 0x80, 0x65, 0x09, 0x38, 0x20, 0x65, 0x65, 0x09, 0x30, 0xBC,
  0x91,
  // "÷" (U+00F7)
  0x20, 0x72, 0x83, 0x4B, 0xBB, 0x17, 0x07, 0x20,
  // "ø" (U+00F8)
  0x18, 0xA5, 0xBB, 0xC1, 0x65, 0x3D, 0x28, 0x39, 0x65, 0x5C, 0x29, 0x33, 0xDC, 0x91,
  // "ù" (U+00F9)
  0x00, 0x34, 0x09, 0x71, 0x8A, 0x76, 0x40, 0x82, 0x64, 0x08, 0x26, 0x40, 0x82, 0x56, 0x0B, 0x21,
  0xCB, 0xA2,
  // "ú" (U+00FA)
  0x20, 0x03, 0x30, 0x97, 0x8A, 0x76, 0x40, 0x82, 0x64, 0x08, 0x26, 0x40, 0x82, 0x56, 0x0B, 0x21,
  0xCB, 0xA2,
  // "û" (U+00FB)
  0x20, 0x63, 0x81, 0x86, 0x66, 0x8A, 0x76, 0x40, 0x82, 0x64, 0x08, 0x26, 0x40, 0x82, 0x56, 0x0B,
  0x21, 0xCB, 0xA2,
  // "ü" (U+00FC)
  0x18, 0x17, 0x06, 0x68, 0xA7, 0x64, 0x08, 0x26, 0x40, 0x82, 0x64, 0x08, 0x25, 0x60, 0xB2, 0x1C,
  0xBA, 0x20,
  // "ý" (U+00FD)
  0x20, 0x03, 0x30, 0x97, 0x87, 0x73, 0x07, 0x41, 0x90, 0xA2, 0x81, 0xA1, 0x92, 0x81, 0x59, 0x43,
  0x0D, 0x30, 0x20, 0x92, 0x81, 0x5C, 0x22,
  // "þ" (U+00FE)
  0x00, 0x53, 0x00, 0x53, 0x8B, 0x15, 0xAB, 0x90, 0x57, 0x08, 0x35, 0x50, 0x65, 0x58, 0x08, 0x35,
  0xAB, 0xA0, 0x55, 0x30, 0x05, 0x30,
  // "ÿ" (U+00FF)
  0x18, 0x17, 0x06, 0x68, 0x77, 0x30, 0x74, 0x19, 0x0A, 0x28, 0x1A, 0x19, 0x28, 0x15, 0x94, 0x30,
  0xD3, 0x02, 0x09, 0x28, 0x15, 0xC2, 0x20,
  // "Ā" (U+0100)
  0x18, 0x1A, 0xF6, 0x28, 0x16, 0xC2, 0x28, 0x19, 0x46, 0x28, 0x95, 0xA0, 0xA0, 0x2D, 0xBD, 0x07,
  0x40, 0x73, 0xA2, 0x03, 0x07,
  // "ā" (U+0101)
  0x18, 0x19, 0xB6, 0x28, 0x1B, 0xC9, 0x48, 0x97, 0xA0, 0x1A, 0xBD, 0x16, 0x50, 0xA1, 0x2C, 0xAA,
  0x10,
  // "Ă" (U+0102)
  0x18, 0x11, 0x01, 0x28, 0x18, 0xF4, 0x28, 0x16, 0xC2, 0x28, 0x19, 0x46, 0x28, 0x95, 0xA0, 0xA0,
  0x2D, 0xBD, 0x07, 0x40, 0x73, 0xA2, 0x03, 0x07,
  // "ă" (U+0103)
  0x18, 0x11, 0x01, 0x28, 0x16, 0x94, 0x28, 0x1B, 0xC9, 0x48, 0x97, 0xA0, 0x1A, 0xBD, 0x16, 0x50,
  0xA1, 0x2C, 0xAA, 0x10,
  // "Ą" (U+0104)
  0x10, 0x10, 0xE3, 0x81, 0x6C, 0x22, 0x81, 0x94, 0x62, 0x89, 0x5A, 0x0A, 0x02, 0xDB, 0xD0, 0x74,
  0x07, 0x3A, 0x20, 0x30, 0xA3, 0x01, 0x06, 0x30, 0x10, 0x90,
  // "ą" (U+0105)
  0x18, 0x1B, 0xC9, 0x48, 0x97, 0xA0, 0x1A, 0xBD, 0x16, 0x50, 0xA1, 0x2C, 0xAD, 0x12, 0x01, 0x06,
  0x30, 0x10, 0x91,
  // "Ć" (U+0106)
  0x30, 0x03, 0x30, 0x92, 0x84, 0x6C, 0xB3, 0x1B, 0x30, 0x05, 0x30, 0x60, 0x43, 0x00, 0x53, 0x02,
  0x0A, 0x48, 0x26, 0xCB, 0x10,
  // "ć" (U+0107)
  0x30, 0x03, 0x30, 0x97, 0x84, 0x8B, 0xB0, 0x29, 0x30, 0x40, 0x63, 0x02, 0x09, 0x48, 0x18, 0xBB,
  0x10,
  // "Ĉ" (U+0108)
  0x30, 0x63, 0x89, 0x08, 0x66, 0x06, 0xCB, 0x31, 0xB3, 0x00, 0x53, 0x06, 0x04, 0x30, 0x05, 0x30,
  0x20, 0xA4, 0x82, 0x6C, 0xB1,
  // "ĉ" (U+0109)
  0x30, 0x63, 0x81, 0x86, 0x66, 0x84, 0x8B, 0xB0, 0x29, 0x30, 0x40, 0x63, 0x02, 0x09, 0x48, 0x18,
  0xBB, 0x10,
  // "Ċ" (U+010A)
  0x30, 0x82, 0x84, 0x6C, 0xB3, 0x1B, 0x30, 0x05, 0x30, 0x60, 0x43, 0x00, 0x53, 0x02, 0x0A, 0x48,
  0x26, 0xCB, 0x10,
  // "ċ" (U+010B)
  0x30, 0x85, 0x83, 0x8B, 0xB2, 0x92, 0x04, 0x06, 0x20, 0x20, 0x93, 0x81, 0x8B, 0xB0,
  // "Č" (U+010C)
  0x28, 0x15, 0x04, 0x28, 0x90, 0x4C, 0x10, 0x6C, 0xB3, 0x1B, 0x30, 0x05, 0x30, 0x60, 0x43, 0x00,
  0x53, 0x02, 0x0A, 0x48, 0x26, 0xCB, 0x10,
  // "č" (U+010D)
  0x28, 0x15, 0x04, 0x28, 0x14, 0xC1, 0x68, 0x48, 0xBB, 0x02, 0x93, 0x04, 0x06, 0x30, 0x20, 0x94,
  0x81, 0x8B, 0xB1,
  // "Ď" (U+010E)
  0x18, 0x15, 0x04, 0x28, 0xC4, 0x4C, 0x10, 0x6C, 0xC5, 0x06, 0x40, 0xB1, 0x64, 0x06, 0x56, 0x40,
  0x56, 0x64, 0x06, 0x46, 0x40, 0xB1, 0x6C, 0xB4, 0x10,
  // "ď" (U+010F)
  0x30, 0xB0, 0x83, 0x8B, 0x0B, 0x12, 0xCA, 0xB0, 0x84, 0x1C, 0x09, 0x10, 0xB0, 0x83, 0x1C, 0x02,
  0xCA, 0xA1,
  // "Đ" (U+0110)
  0x8C, 0x05, 0xDC, 0x60, 0x55, 0x0B, 0x25, 0x50, 0x56, 0xDD, 0x43, 0x75, 0x50, 0x56, 0x55, 0x0B,
  0x15, 0xDB, 0x51,
  // "đ" (U+0111)
  0x30, 0x80, 0x22, 0x8B, 0x2B, 0xD9, 0x1B, 0xBB, 0x26, 0x50, 0xB2, 0x83, 0x08, 0x26, 0x50, 0xB2,
  0x1B, 0xBA, 0x20,
  // "Ē" (U+0112)
  0x03, 0xB8, 0x11, 0x37, 0x30, 0x30, 0x73, 0x85, 0x3D, 0xBB, 0x03, 0x73, 0x03, 0x07, 0x38, 0x33,
  0xDB, 0xB1,
  // "ē" (U+0113)
  0x18, 0x19, 0xB6, 0x28, 0x96, 0xAB, 0x80, 0x57, 0x08, 0x27, 0xCB, 0xC4, 0x56, 0x48, 0x29, 0xBB,
  0x10,
  // "Ĕ" (U+0114)
  0x18, 0x31, 0x01, 0x03, 0xB8, 0x11, 0x37, 0x30, 0x30, 0x73, 0x85, 0x3D, 0xBB, 0x03, 0x73, 0x03,
  0x07, 0x38, 0x33, 0xDB, 0xB1,
  // "ĕ" (U+0115)
  0x18, 0x11, 0x01, 0x28, 0x16, 0x94, 0x28, 0x96, 0xAB, 0x80, 0x57, 0x08, 0x27, 0xCB, 0xC4, 0x56,
  0x48, 0x29, 0xBB, 0x10,
  // "Ė" (U+0116)
  0x20, 0x82, 0x85, 0x3D, 0xBB, 0x13, 0x73, 0x03, 0x07, 0x38, 0x53, 0xDB, 0xB0, 0x37, 0x30, 0x30,
  0x73, 0x83, 0x3D, 0xBB, 0x10,
  // "ė" (U+0117)
  0x20, 0x87, 0x18, 0x96, 0xAB, 0x80, 0x57, 0x08, 0x27, 0xCB, 0xC4, 0x56, 0x48, 0x29, 0xBB, 0x10,
  // "Ę" (U+0118)
  0x85, 0x3D, 0xBB, 0x13, 0x73, 0x03, 0x07, 0x38, 0x53, 0xDB, 0xB0, 0x37, 0x30, 0x30, 0x73, 0x83,
  0x3D, 0xBE, 0x12, 0x01, 0x06, 0x30, 0x10, 0x91,
  // "ę" (U+0119)
  0x18, 0x96, 0xAB, 0x80, 0x57, 0x08, 0x27, 0xCB, 0xC4, 0x56, 0x48, 0x29, 0xBD, 0x12, 0x01, 0x06,
  0x30, 0x20, 0xC1,
  // "Ě" (U+011A)
  0x18, 0x15, 0x04, 0x28, 0x91, 0x4C, 0x10, 0x3D, 0xBB, 0x13, 0x73, 0x03, 0x07, 0x38, 0x53, 0xDB,
  0xB0, 0x37, 0x30, 0x30, 0x73, 0x83, 0x3D, 0xBB, 0x10,
  // "ě" (U+011B)
  0x18, 0x15, 0x04, 0x28, 0x14, 0xC1, 0x78, 0x96, 0xAB, 0x80, 0x57, 0x08, 0x27, 0xCB, 0xC4, 0x56,
  0x48, 0x29, 0xBB, 0x10,
  // "Ĝ" (U+011C)
  0x30, 0x63, 0x89, 0x08, 0x66, 0x07, 0xBB, 0x03, 0x93, 0x08, 0x03, 0x38, 0xA2, 0x91, 0x5C, 0x38,
  0x30, 0x73, 0x48, 0x07, 0x30, 0x9B, 0xC2,
  // "ĝ" (U+011D)
  0x20, 0x63, 0x81, 0x86, 0x67, 0x0F, 0xB8, 0xA3, 0x26, 0x50, 0xA2, 0x83, 0x07, 0x26, 0x50, 0xA2,
  0x1B, 0xBB, 0x23, 0x84, 0xA1, 0x3B, 0xB8, 0x10,
  // "Ğ" (U+011E)
  0x28, 0x31, 0x01, 0x07, 0xA8, 0x14, 0x39, 0x30, 0x80, 0x33, 0x8A, 0x29, 0x15, 0xC3, 0x83, 0x07,
  0x34, 0x80, 0x73, 0x09, 0xBC, 0x20,
  // "ğ" (U+011F)
  0x18, 0x11, 0x01, 0x28, 0x16, 0x94, 0x20, 0xFB, 0x8A, 0x32, 0x65, 0x0A, 0x28, 0x30, 0x72, 0x65,
  0x0A, 0x21, 0xBB, 0xB2, 0x38, 0x4A, 0x13, 0xBB, 0x81,
  // "Ġ" (U+0120)
  0x30, 0x82, 0x84, 0x7B, 0xB0, 0x39, 0x30, 0x80, 0x33, 0x8A, 0x29, 0x15, 0xC3, 0x83, 0x07, 0x34,
  0x80, 0x73, 0x09, 0xBC, 0x20,
  // "ġ" (U+0121)
  0x20, 0x87, 0x10, 0xFB, 0x8A, 0x32, 0x65, 0x0A, 0x28, 0x30, 0x72, 0x65, 0x0A, 0x21, 0xBB, 0xB2,
  0x38, 0x4A, 0x13, 0xBB, 0x81,
  // "Ģ" (U+0122)
  0x18, 0x47, 0xBB, 0x03, 0x93, 0x08, 0x03, 0x38, 0xA2, 0x91, 0x5C, 0x38, 0x30, 0x73, 0x48, 0x07,
  0x30, 0x9B, 0xC2, 0x70, 0x60, 0x23, 0x01, 0x20,
  // "ģ" (U+0123)
  0x20, 0x84, 0x01, 0x30, 0xFB, 0x8A, 0x32, 0x65, 0x0A, 0x28, 0x30, 0x72, 0x65, 0x0A, 0x21, 0xBB,
  0xB2, 0x38, 0x4A, 0x13, 0xBB, 0x81,
  // "Ĥ" (U+0124)
  0x20, 0x63, 0x8C, 0x58, 0x66, 0x06, 0x40, 0x73, 0x64, 0x07, 0x36, 0x40, 0x73, 0x6C, 0xBD, 0x36,
  0x40, 0x73, 0x64, 0x07, 0x36, 0x40, 0x73,
  // "ĥ" (U+0125)
  0x10, 0x63, 0x81, 0x86, 0x67, 0x00, 0x53, 0x00, 0x53, 0x8A, 0x75, 0x9B, 0xA0, 0x58, 0x09, 0x25,
  0x50, 0x83, 0x55, 0x08, 0x35, 0x50, 0x83,
  // "Ħ" (U+0126)
  0x8C, 0x16, 0x40, 0x73, 0xDC, 0xBD, 0xA6, 0x40, 0x73, 0x6C, 0xBD, 0x36, 0x40, 0x73, 0x64, 0x07,
  0x36, 0x40, 0x73,
  // "ħ" (U+0127)
  0x00, 0x53, 0x81, 0xDD, 0x82, 0x8A, 0x75, 0x9B, 0xA0, 0x58, 0x09, 0x25, 0x50, 0x83, 0x55, 0x08,
  0x35, 0x50, 0x83,
  // "Ĩ" (U+0128)
  0x01, 0xB2, 0x0B, 0x30, 0xB3, 0x0B, 0x30, 0xB3, 0x84, 0xB0, 0x1A, 0xE9,
  // "ĩ" (U+0129)
  0x18, 0x59, 0xB6, 0x02, 0xAD, 0x40, 0xB4, 0x0B, 0x40, 0xB2, 0x83, 0x39, 0xE9, 0x20,
  // "Ī" (U+012A)
  0x01, 0xB2, 0x0B, 0x30, 0xB3, 0x0B, 0x30, 0xB3, 0x84, 0xB0, 0x1A, 0xE9,
  // "ī" (U+012B)
  0x18, 0x59, 0xB6, 0x02, 0xAD, 0x40, 0xB4, 0x0B, 0x40, 0xB2, 0x83, 0x39, 0xE9, 0x20,
  // "Ĭ" (U+012C)
  0x18, 0x21, 0x01, 0x1A, 0x0E, 0x20, 0xB3, 0x0B, 0x30, 0xB3, 0x0B, 0x38, 0x4B, 0x01, 0xAE, 0x90,
  // "ĭ" (U+012D)
  0x18, 0x11, 0x01, 0x28, 0x56, 0x94, 0x02, 0xAD, 0x40, 0xB4, 0x0B, 0x40, 0xB2, 0x83, 0x39, 0xE9,
  0x20,
  // "Į" (U+012E)
  0x82, 0x1B, 0xE9, 0x20, 0xB3, 0x0B, 0x30, 0xB3, 0x0B, 0x38, 0x4B, 0x01, 0xAE, 0xB2, 0x01, 0x06,
  0x20, 0x10, 0x90,
  // "į" (U+012F)
  0x20, 0x87, 0x81, 0x2A, 0xD4, 0x0B, 0x40, 0xB4, 0x0B, 0x28, 0x33, 0x9E, 0xC2, 0x20, 0x10, 0x63,
  0x01, 0x09, 0x10,
  // "İ" (U+0130)
  0x28, 0x48, 0x01, 0xBE, 0x92, 0x0B, 0x30, 0xB3, 0x0B, 0x30, 0xB3, 0x84, 0xB0, 0x1A, 0xE9,
  // "ı" (U+0131)
  0x81, 0x2A, 0xD4, 0x0B, 0x40, 0xB4, 0x0B, 0x28, 0x33, 0x9E, 0x92,
  // "Ĳ" (U+0132)
  0x8A, 0x23, 0x80, 0xB3, 0x80, 0xB3, 0x80, 0xB3, 0x80, 0xB3, 0x80, 0xB3, 0x83, 0xB2, 0xBC, 0x50,
  // "ĳ" (U+0133)
  0x82, 0x17, 0x08, 0x48, 0xA2, 0x1A, 0x0B, 0x1A, 0x0B, 0x1A, 0x0B, 0x1A, 0x0B, 0x1A, 0x0B, 0x38,
  0x3B, 0x0B, 0xC6,
  // "Ĵ" (U+0134)
  0x30, 0x63, 0x81, 0x86, 0x63, 0x0B, 0x40, 0xB4, 0x0B, 0x40, 0xB4, 0x0B, 0x38, 0x52, 0x90, 0x2B,
  0xC3, 0x10,
  // "ĵ" (U+0135)
  0x30, 0x63, 0x81, 0x86, 0x66, 0x81, 0x8D, 0x23, 0x08, 0x02, 0x30, 0x80, 0x23, 0x08, 0x02, 0x30,
  0x80, 0x23, 0x84, 0x92, 0x06, 0xBA, 0x20,
  // "Ķ" (U+0136)
  0x89, 0x36, 0x40, 0xB1, 0x64, 0x66, 0x06, 0x5B, 0x28, 0x16, 0xC9, 0x28, 0x95, 0x67, 0xA1, 0x06,
  0x43, 0x90, 0x64, 0x0A, 0x26, 0x06, 0x02, 0x30, 0x13,
  // "ķ" (U+0137)
  0x02, 0x08, 0x30, 0x20, 0x83, 0x89, 0x32, 0x80, 0xB2, 0x28, 0x84, 0x02, 0xCD, 0x28, 0x90, 0x2A,
  0x39, 0x02, 0x80, 0x83, 0x70, 0x60, 0x23, 0x01, 0x20,
  // "ĸ" (U+0138)
  0x89, 0x32, 0x80, 0xB2, 0x28, 0x84, 0x02, 0xCD, 0x28, 0x90, 0x2A, 0x39, 0x02, 0x80, 0x83,
  // "Ĺ" (U+0139)
  0x10, 0x03, 0x30, 0x93, 0x01, 0x09, 0x30, 0x10, 0x93, 0x01, 0x09, 0x30, 0x10, 0x93, 0x01, 0x09,
  0x30, 0x10, 0x93, 0x83, 0x1E, 0xBB, 0x10,
  // "ĺ" (U+013A)
  0x20, 0x03, 0x30, 0x97, 0x81, 0x3B, 0xD4, 0x0B, 0x40, 0xB4, 0x0B, 0x40, 0xB4, 0x0B, 0x28, 0x33,
  0x9D, 0x92,
  // "Ļ" (U+013B)
  0x01, 0x09, 0x30, 0x10, 0x93, 0x01, 0x09, 0x30, 0x10, 0x93, 0x01, 0x09, 0x30, 0x10, 0x93, 0x83,
  0x1E, 0xBB, 0x17, 0x06, 0x02, 0x30, 0x12,
  // "ļ" (U+013C)
  0x81, 0x3B, 0xD4, 0x0B, 0x40, 0xB4, 0x0B, 0x40, 0xB4, 0x0B, 0x28, 0x33, 0x9D, 0x92, 0x70, 0x60,
  0x23, 0x01, 0x20,
  // "Ľ" (U+013D)
  0x89, 0x21, 0x90, 0x90, 0x19, 0x01, 0x01, 0x93, 0x01, 0x09, 0x30, 0x10, 0x93, 0x01, 0x09, 0x38,
  0x31, 0xEB, 0xB1,
  // "ľ" (U+013E)
  0x83, 0x3B, 0xD4, 0x42, 0x0B, 0x01, 0x30, 0xB4, 0x0B, 0x40, 0xB4, 0x0B, 0x28, 0x33, 0xAE, 0xA2,
  // "Ŀ" (U+013F)
  0x01, 0x09, 0x30, 0x10, 0x93, 0x01, 0x09, 0x30, 0x10, 0x93, 0x85, 0x19, 0x08, 0x01, 0x93, 0x83,
  0x1E, 0xBB, 0x10,
  // "ŀ" (U+0140)
  0x81, 0x3B, 0xD4, 0x0B, 0x40, 0xB4, 0x81, 0xB0, 0x82, 0x0B, 0x40, 0xB2, 0x83, 0x39, 0xD9, 0x20,
  // "Ł" (U+0141)
  0x10, 0xB4, 0x0B, 0x40, 0xB0, 0x23, 0x0C, 0x0A, 0x20, 0x50, 0xD4, 0x0B, 0x40, 0xFB, 0x05,
  // "ł" (U+0142)
  0x81, 0x3B, 0xD4, 0x0B, 0x40, 0xB0, 0x23, 0x0D, 0x06, 0x20, 0x70, 0xC4, 0x0B, 0x28, 0x33, 0x9D,
  0x92,
  // "Ń" (U+0143)
  0x20, 0x03, 0x30, 0x92, 0x8C, 0x16, 0xA0, 0x73, 0x6C, 0x17, 0x36, 0x76, 0x73, 0x63, 0x97, 0x36,
  0x38, 0x83, 0x63, 0x2D, 0x36, 0x30, 0xC3,
  // "ń" (U+0144)
  0x30, 0x03, 0x30, 0x96, 0x8A, 0x75, 0x9B, 0xB0, 0x58, 0x09, 0x25, 0x50, 0x83, 0x55, 0x08, 0x35,
  0x50, 0x83,
  // "Ņ" (U+0145)
  0x8C, 0x16, 0xA0, 0x73, 0x6C, 0x17, 0x36, 0x76, 0x73, 0x63, 0x97, 0x36, 0x38, 0x83, 0x63, 0x2D,
  0x36, 0x30, 0xC3, 0x60, 0x60, 0x23, 0x01, 0x30,
  // "ņ" (U+0146)
  0x8A, 0x75, 0x9B, 0xB0, 0x58, 0x09, 0x25, 0x50, 0x83, 0x55, 0x08, 0x35, 0x50, 0x83, 0x60, 0x60,
  0x23, 0x01, 0x30,
  // "Ň" (U+0147)
  0x18, 0x15, 0x04, 0x28, 0xC5, 0x4C, 0x10, 0x6A, 0x07, 0x36, 0xC1, 0x73, 0x67, 0x67, 0x36, 0x39,
  0x73, 0x63, 0x88, 0x36, 0x32, 0xD3, 0x63, 0x0C, 0x30,
  // "ň" (U+0148)
  0x28, 0x15, 0x04, 0x28, 0x14, 0xC1, 0x58, 0xA7, 0x59, 0xBB, 0x05, 0x80, 0x92, 0x55, 0x08, 0x35,
  0x50, 0x83, 0x55, 0x08, 0x30,
  // "ŉ" (U+0149)
  0x01, 0x0B, 0x40, 0x40, 0x65, 0x82, 0x4B, 0x28, 0x28, 0xA5, 0x38, 0x08, 0x20, 0x37, 0x08, 0x30,
  0x37, 0x08, 0x30, 0x37, 0x08, 0x30,
  // "Ŋ" (U+014A)
  0x8C, 0x16, 0xA0, 0x73, 0x6C, 0x17, 0x36, 0x76, 0x73, 0x63, 0x97, 0x36, 0x38, 0x83, 0x63, 0x2D,
  0x36, 0x30, 0xC3, 0x30, 0x80, 0x22, 0x0A, 0x09, 0x10,
  // "ŋ" (U+014B)
  0x8A, 0x75, 0x9B, 0xB0, 0x58, 0x09, 0x25, 0x50, 0x83, 0x55, 0x08, 0x35, 0x50, 0x83, 0x30, 0x80,
  0x32, 0x06, 0x0C, 0x10,
  // "Ō" (U+014C)
  0x1B, 0x18, 0xB3, 0x56, 0x09, 0x28, 0x20, 0x55, 0x91, 0x04, 0x68, 0x20, 0x55, 0x56, 0x09, 0x20,
  0xAC, 0x81,
  // "ō" (U+014D)
  0x18, 0x19, 0xB6, 0x28, 0xA5, 0xBB, 0x80, 0x65, 0x09, 0x38, 0x20, 0x65, 0x65, 0x09, 0x30, 0xBC,
  0x91,
  // "Ŏ" (U+014E)
  0x18, 0x11, 0x01, 0x2A, 0x8B, 0x5C, 0x05, 0x60, 0x92, 0x82, 0x05, 0x59, 0x10, 0x46, 0x82, 0x05,
  0x55, 0x60, 0x92, 0x0A, 0xC8, 0x10,
  // "ŏ" (U+014F)
  0x18, 0x11, 0x01, 0x28, 0x16, 0x94, 0x28, 0xA5, 0xBB, 0x80, 0x65, 0x09, 0x38, 0x20, 0x65, 0x65,
  0x09, 0x30, 0xBC, 0x91,
  // "Ő" (U+0150)
  0x81, 0x56, 0x92, 0x8C, 0x01, 0xBC, 0x80, 0x56, 0x09, 0x28, 0x20, 0x55, 0x91, 0x04, 0x68, 0x20,
  0x55, 0x56, 0x09, 0x20, 0xAC, 0x81,
  // "ő" (U+0151)
  0x81, 0x56, 0x92, 0x01, 0x58, 0xA5, 0xBB, 0x80, 0x65, 0x09, 0x38, 0x20, 0x65, 0x65, 0x09, 0x30,
  0xBC, 0x91,
  // "Œ" (U+0152)
  0x8C, 0x11, 0xBD, 0xC6, 0x74, 0x82, 0x09, 0x18, 0x20, 0xA1, 0x8C, 0x49, 0x18, 0x20, 0x74, 0x82,
  0x01, 0xCD, 0xC6,
  // "œ" (U+0153)
  0x8A, 0x05, 0xC7, 0xC3, 0xA0, 0xC0, 0x89, 0x0B, 0xB8, 0x90, 0xC2, 0x83, 0x4C, 0x7B, 0x50,
  // "Ŕ" (U+0154)
  0x20, 0x03, 0x30, 0x92, 0x8C, 0x13, 0xDB, 0x80, 0x37, 0x0B, 0x03, 0x70, 0xB0, 0x3D, 0xD5, 0x03,
  0x75, 0x60, 0x37, 0x0B, 0x03, 0x70, 0x75,
  // "ŕ" (U+0155)
  0x30, 0x03, 0x30, 0x96, 0x86, 0x4C, 0x9C, 0x60, 0x3C, 0x30, 0x30, 0x83, 0x03, 0x08, 0x28, 0x24,
  0xAC, 0x61,
  // "Ŗ" (U+0156)
  0x8C, 0x13, 0xDB, 0x80, 0x37, 0x0B, 0x03, 0x70, 0xB0, 0x3D, 0xD5, 0x03, 0x75, 0x60, 0x37, 0x0B,
  0x03, 0x70, 0x75, 0x70, 0x60, 0x23, 0x01, 0x20,
  // "ŗ" (U+0157)
  0x86, 0x4C, 0x9C, 0x60, 0x3C, 0x30, 0x30, 0x83, 0x03, 0x08, 0x28, 0x24, 0xAC, 0x67, 0x06, 0x02,
  0x30, 0x13,
  // "Ř" (U+0158)
  0x18, 0x15, 0x04, 0x28, 0xC5, 0x4C, 0x10, 0x3D, 0xB8, 0x03, 0x70, 0xB0, 0x37, 0x0B, 0x03, 0xDD,
  0x50, 0x37, 0x56, 0x03, 0x70, 0xB0, 0x37, 0x07, 0x50,
  // "ř" (U+0159)
  0x28, 0x15, 0x04, 0x28, 0x14, 0xC1, 0x58, 0x64, 0xC9, 0xC6, 0x03, 0xC3, 0x03, 0x08, 0x30, 0x30,
  0x82, 0x82, 0x4A, 0xC6, 0x10,
  // "Ś" (U+015A)
  0x30, 0x03, 0x30, 0x92, 0x84, 0x9C, 0xB0, 0x29, 0x40, 0xB0, 0x13, 0x81, 0x4C, 0x54, 0x0B, 0x01,
  0x38, 0x49, 0x23, 0xCB, 0x91,
  // "ś" (U+015B)
  0x20, 0x03, 0x20, 0x96, 0x83, 0xAB, 0x90, 0xB3, 0x81, 0x4A, 0x43, 0x83, 0xB1, 0xCB, 0x80,
  // "Ŝ" (U+015C)
  0x30, 0x63, 0x89, 0x08, 0x66, 0x09, 0xCB, 0x02, 0x94, 0x0B, 0x01, 0x38, 0x14, 0xC5, 0x40, 0xB0,
  0x13, 0x84, 0x92, 0x3C, 0xB9, 0x10,
  // "ŝ" (U+015D)
  0x20, 0x62, 0x81, 0x86, 0x65, 0x83, 0xAB, 0x90, 0xB3, 0x81, 0x4A, 0x43, 0x83, 0xB1, 0xCB, 0x80,
  // "Ş" (U+015E)
  0x18, 0x49, 0xCB, 0x02, 0x94, 0x0B, 0x01, 0x38, 0x14, 0xC5, 0x40, 0xB0, 0x13, 0x84, 0x92, 0x3C,
  0xD9, 0x30, 0x93, 0x03, 0x08, 0x20,
  // "ş" (U+015F)
  0x18, 0x3A, 0xB9, 0x0B, 0x38, 0x14, 0xA4, 0x38, 0x3B, 0x1C, 0xD8, 0x20, 0x92, 0x03, 0x08, 0x10,
  // "Š" (U+0160)
  0x28, 0x15, 0x04, 0x28, 0x90, 0x4C, 0x10, 0x9C, 0xB0, 0x29, 0x40, 0xB0, 0x13, 0x81, 0x4C, 0x54,
  0x0B, 0x01, 0x38, 0x49, 0x23, 0xCB, 0x91,
  // "š" (U+0161)
  0x18, 0x55, 0x04, 0x04, 0xC1, 0x58, 0x3A, 0xB9, 0x0B, 0x38, 0x14, 0xA4, 0x38, 0x3B, 0x1C, 0xB8,
  // "Ţ" (U+0162)
  0x83, 0x7B, 0xEB, 0x52, 0x0B, 0x40, 0xB4, 0x0B, 0x40, 0xB4, 0x0B, 0x40, 0xD4, 0x09, 0x30, 0x30,
  0x82,
  // "ţ" (U+0163)
  0x10, 0x02, 0x30, 0x05, 0x28, 0x25, 0xDD, 0xB2, 0x06, 0x05, 0x30, 0x60, 0x53, 0x05, 0x06, 0x38,
  0x21, 0xBD, 0x13, 0x09, 0x30, 0x30, 0x81,
  // "Ť" (U+0164)
  0x18, 0x15, 0x04, 0x28, 0x74, 0xC1, 0x07, 0xBE, 0xB5, 0x20, 0xB4, 0x0B, 0x40, 0xB4, 0x0B, 0x40,
  0xB4, 0x0B, 0x20,
  // "ť" (U+0165)
  0x18, 0x11, 0x19, 0x28, 0x65, 0x51, 0x05, 0xDD, 0xB2, 0x06, 0x05, 0x30, 0x60, 0x53, 0x05, 0x06,
  0x38, 0x21, 0xBB, 0x10,
  // "Ŧ" (U+0166)
  0x83, 0x7B, 0xEB, 0x52, 0x0B, 0x40, 0xB2, 0x82, 0x1B, 0xEB, 0x30, 0xB4, 0x0B, 0x40, 0xB2,
  // "ŧ" (U+0167)
  0x10, 0x02, 0x30, 0x05, 0x28, 0x25, 0xDD, 0xB2, 0x06, 0x05, 0x28, 0x66, 0xDD, 0xB1, 0x05, 0x53,
  0x82, 0x2C, 0xB1,
  // "Ũ" (U+0168)
  0x8C, 0x06, 0xDB, 0xE3, 0x64, 0x07, 0x36, 0x40, 0x73, 0x64, 0x07, 0x36, 0x40, 0x73, 0x47, 0x0A,
  0x10, 0xBC, 0x81,
  // "ũ" (U+0169)
  0x18, 0xB3, 0x9B, 0x60, 0x64, 0x08, 0x26, 0x40, 0x82, 0x64, 0x08, 0x25, 0x60, 0xB2, 0x1C, 0xBA,
  0x20,
  // "Ū" (U+016A)
  0x8C, 0x06, 0xDB, 0xE3, 0x64, 0x07, 0x36, 0x40, 0x73, 0x64, 0x07, 0x36, 0x40, 0x73, 0x47, 0x0A,
  0x10, 0xBC, 0x81,
  // "ū" (U+016B)
  0x18, 0xB3, 0x9B, 0x60, 0x64, 0x08, 0x26, 0x40, 0x82, 0x64, 0x08, 0x25, 0x60, 0xB2, 0x1C, 0xBA,
  0x20,
  // "Ŭ" (U+016C)
  0x18, 0xC4, 0x10, 0x10, 0x6A, 0x9B, 0x36, 0x40, 0x73, 0x64, 0x07, 0x36, 0x40, 0x73, 0x64, 0x07,
  0x34, 0x70, 0xA1, 0x0B, 0xC8, 0x10,
  // "ŭ" (U+016D)
  0x18, 0x11, 0x01, 0x28, 0xB3, 0x69, 0x40, 0x64, 0x08, 0x26, 0x40, 0x82, 0x64, 0x08, 0x25, 0x60,
  0xB2, 0x1C, 0xBA, 0x20,
  // "Ů" (U+016E)
  0x18, 0xC4, 0x37, 0x10, 0x67, 0x78, 0x36, 0x40, 0x73, 0x64, 0x07, 0x36, 0x40, 0x73, 0x64, 0x07,
  0x34, 0x70, 0xA1, 0x0B, 0xC8, 0x10,
  // "ů" (U+016F)
  0x18, 0x13, 0x71, 0x28, 0xB3, 0x37, 0x10, 0x64, 0x08, 0x26, 0x40, 0x82, 0x64, 0x08, 0x25, 0x60,
  0xB2, 0x1C, 0xBA, 0x20,
  // "Ű" (U+0170)
  0x81, 0x56, 0x92, 0x8C, 0x08, 0x50, 0x73, 0x64, 0x07, 0x36, 0x40, 0x73, 0x64, 0x07, 0x36, 0x40,
  0x73, 0x47, 0x0A, 0x10, 0xBC, 0x81,
  // "ű" (U+0171)
  0x81, 0x56, 0x92, 0x01, 0x48, 0xA7, 0x64, 0x08, 0x26, 0x40, 0x82, 0x64, 0x08, 0x25, 0x60, 0xB2,
  0x1C, 0xBA, 0x20,
  // "Ų" (U+0172)
  0x8B, 0x36, 0x40, 0x73, 0x64, 0x07, 0x36, 0x40, 0x73, 0x64, 0x07, 0x36, 0x40, 0x73, 0x47, 0x0A,
  0x28, 0x1B, 0xC6, 0x30, 0x74, 0x0C, 0x01, 0x10,
  // "ų" (U+0173)
  0x8A, 0x76, 0x40, 0x82, 0x64, 0x08, 0x26, 0x40, 0x82, 0x56, 0x0B, 0x21, 0xCB, 0xD2, 0x20, 0x10,
  0x63, 0x01, 0x09, 0x10,
  // "Ŵ" (U+0174)
  0x20, 0x63, 0x83, 0x86, 0x60, 0xA2, 0x81, 0x18, 0x92, 0x8B, 0x12, 0x78, 0x1C, 0x36, 0x75, 0xB5,
  0x46, 0x95, 0x93, 0x4B, 0x1D, 0x23, 0xA0, 0xD1,
  // "ŵ" (U+0175)
  0x20, 0x63, 0x81, 0x86, 0x66, 0x0A, 0x38, 0xA2, 0x9A, 0x2D, 0x27, 0x87, 0xA7, 0x56, 0xB3, 0xC2,
  0x4B, 0x0E, 0x10,
  // "Ŷ" (U+0176)
  0x20, 0x63, 0x89, 0x38, 0x66, 0x08, 0x40, 0x64, 0x19, 0x0A, 0x28, 0x1A, 0x37, 0x28, 0x14, 0xD1,
  0x30, 0xB4, 0x0A, 0x40, 0xA2,
  // "ŷ" (U+0177)
  0x20, 0x63, 0x81, 0x86, 0x66, 0x87, 0x73, 0x07, 0x41, 0x90, 0xA2, 0x81, 0xA1, 0x92, 0x81, 0x59,
  0x43, 0x0D, 0x30, 0x20, 0x92, 0x81, 0x5C, 0x22,
  // "Ÿ" (U+0178)
  0x18, 0x93, 0x70, 0x60, 0x84, 0x06, 0x41, 0x90, 0xA2, 0x81, 0xA3, 0x72, 0x81, 0x4D, 0x13, 0x0B,
  0x40, 0xA4, 0x0A, 0x20,
  // "Ź" (U+0179)
  0x30, 0x03, 0x30, 0x92, 0x81, 0xBB, 0xE3, 0x01, 0x09, 0x30, 0x70, 0x33, 0x0A, 0x30, 0x60, 0x53,
  0x0A, 0x38, 0x23, 0xDB, 0xB1,
  // "ź" (U+017A)
  0x20, 0x03, 0x20, 0x95, 0x82, 0x1B, 0xBE, 0x28, 0x34, 0x70, 0x1A, 0x28, 0x59, 0x20, 0x3E, 0xBB,
  // "Ż" (U+017B)
  0x38, 0x38, 0x0B, 0xBE, 0x20, 0x10, 0x92, 0x07, 0x03, 0x20, 0xA2, 0x06, 0x05, 0x20, 0xA2, 0x82,
  0x3D, 0xBB,
  // "ż" (U+017C)
  0x20, 0x85, 0x82, 0x1B, 0xBE, 0x28, 0x34, 0x70, 0x1A, 0x28, 0x59, 0x20, 0x3E, 0xBB,
  // "Ž" (U+017D)
  0x28, 0x15, 0x04, 0x28, 0x54, 0xC1, 0x0B, 0xBE, 0x30, 0x10, 0x93, 0x07, 0x03, 0x30, 0xA3, 0x06,
  0x05, 0x30, 0xA3, 0x82, 0x3D, 0xBB, 0x10,
  // "ž" (U+017E)
  0x18, 0x55, 0x04, 0x04, 0xC1, 0x48, 0x21, 0xBB, 0xE2, 0x83, 0x47, 0x01, 0xA2, 0x85, 0x92, 0x03,
  0xEB, 0xB0,
  // "ſ" (U+017F)
  0x18, 0x3B, 0xB3, 0x38, 0x20, 0x30, 0x72, 0x03, 0x07, 0x20, 0x30, 0x72, 0x03, 0x07, 0x20, 0x30,
  0x72,
  // "Ω" (U+03A9)
  0x18, 0xC0, 0xAB, 0x80, 0x57, 0x0A, 0x28, 0x20, 0x65, 0x82, 0x05, 0x56, 0x40, 0x73, 0x28, 0x09,
  0x09, 0xE2, 0xE7,
  // "μ" (U+03BC)
  0x8B, 0x16, 0x40, 0x82, 0x64, 0x08, 0x26, 0x40, 0x82, 0x66, 0x0B, 0x26, 0xEB, 0xA2, 0x64, 0x30,
  0x60, 0x43,
  // "π" (U+03C0)
  0x87, 0x6E, 0xBE, 0x50, 0xA0, 0xA2, 0x81, 0xA0, 0xA2, 0x81, 0xA0, 0xA2, 0x82, 0xA0, 0xC4,
  // "–" (U+2013)
  0x02, 0x0F, 0xB0,
  // "—" (U+2014)
  0x80, 0x0B, 0x09,
  // "€" (U+20AC)
  0x18, 0x91, 0x1B, 0xC5, 0x09, 0x20, 0x10, 0xA3, 0x87, 0x6D, 0x95, 0x06, 0xD9, 0x52, 0x0B, 0x01,
  0x38, 0x22, 0xCB, 0x50,
  // "₿" (U+20BF)
  0x18, 0xC4, 0x75, 0x10, 0x3D, 0xC9, 0x03, 0x60, 0x92, 0x36, 0x0A, 0x13, 0xDC, 0x90, 0x36, 0x08,
  0x33, 0x60, 0x74, 0x3D, 0xCB, 0x28, 0x16, 0x51, 0x10,
  // "‘" (U+2018)
  0x81, 0x9A, 0x10,
  // "’" (U+2019)
  0x18, 0x1C, 0x27,
  // "‚" (U+201A)
  0x18, 0x32, 0x0C, 0x37,
  // "‛" (U+201B)
  0x84, 0x1A, 0x09, 0x01,
  // "“" (U+201C)
  0x87, 0x90, 0x9A, 0x0A, 0x10, 0x10,
  // "”" (U+201D)
  0x87, 0x10, 0x1A, 0x0A, 0x90, 0x90,
  // "„" (U+201E)
  0x18, 0x91, 0x20, 0x20, 0xC0, 0xC3, 0x73, 0x70,
  // "‟" (U+201F)
  0x87, 0x10, 0x1A, 0x0A, 0x90, 0x90,
  // "†" (U+2020)
  0x20, 0xA2, 0x85, 0x28, 0x21, 0x7A, 0x72, 0x07, 0x30, 0x93, 0x0A, 0x30, 0xB1,
  // "‡" (U+2021)
  0x28, 0x90, 0xA0, 0x15, 0xA5, 0x14, 0xA5, 0x20, 0xA2, 0x85, 0x49, 0x41, 0x5A, 0x52, 0x0A, 0x10,
  // "•" (U+2022)
  0x84, 0x5F, 0x24, 0xD2,
  // "…" (U+2026)
  0x83, 0x80, 0x80, 0x80,
  // "‰" (U+2030)
  0x00, 0x93, 0x00, 0x93, 0x86, 0x78, 0x58, 0x02, 0x93, 0x28, 0x95, 0x1A, 0x6A, 0x50, 0x8B, 0x79,
  0x0B, 0x7B, 0x60,
  // "‹" (U+2039)
  0x18, 0x55, 0x13, 0x70, 0x29, 0x20, 0x30, 0x10,
  // "›" (U+203A)
  0x01, 0x03, 0x28, 0x59, 0x20, 0x73, 0x15, 0x10,
  // "⁄" (U+2044)
  0x20, 0x40, 0x52, 0x08, 0x30, 0x92, 0x00, 0x42, 0x09, 0x30, 0x82, 0x05, 0x04, 0x20,
  // "™" (U+2122)
  0x8A, 0x31, 0xDC, 0xB2, 0xA0, 0x42, 0xB7, 0x90, 0x42, 0x8B, 0x80, 0x21, 0x0F, 0x30,
  // "⅒" (U+2152)
  0x40, 0x40, 0x55, 0x04, 0x08, 0x20, 0x86, 0x01, 0x07, 0x20, 0x97, 0x8A, 0x38, 0x04, 0x44, 0x80,
  0x47, 0x33, 0x94, 0x90, 0x17, 0x08, 0x08, 0x30, 0x82, 0x83, 0x80, 0x80, 0x82, 0x87, 0x54, 0x03,
  0x94, 0x47, 0x30,
  // "∂" (U+2202)
  0x18, 0x16, 0xE9, 0x28, 0xA5, 0x10, 0xC1, 0x0A, 0xEB, 0x26, 0x70, 0xB0, 0x83, 0x3A, 0x04, 0xEC,
  0x21,
  // "∆" (U+2206)
  0x10, 0x10, 0xD3, 0x81, 0x6C, 0x22, 0x81, 0xA4, 0x72, 0x8A, 0x1A, 0x0A, 0x04, 0x60, 0xA1, 0x82,
  0x05, 0x5C, 0xAA, 0xB9,
  // "√" (U+221A)
  0x40, 0x43, 0x01, 0x07, 0x30, 0x60, 0x23, 0x84, 0x90, 0xA5, 0x08, 0x28, 0x19, 0x53, 0x20, 0x80,
  0x93, 0x03, 0x09, 0x20,
  // "∞" (U+221E)
  0x89, 0x58, 0xD3, 0xE6, 0xA3, 0xC2, 0x99, 0xD4, 0xE6,
  // "≈" (U+2248)
  0x83, 0x5B, 0xBB, 0x35, 0x83, 0x5B, 0xBB, 0x30,
  // "≠" (U+2260)
  0x28, 0x95, 0x36, 0x05, 0xDE, 0xD3, 0x5E, 0xED, 0x30, 0x93,
  // "≤" (U+2264)
  0x40, 0x12, 0x84, 0x49, 0x32, 0xA4, 0x38, 0x15, 0x85, 0x48, 0x53, 0x43, 0xDD, 0xD6,
  // "≥" (U+2265)
  0x01, 0x48, 0x13, 0x94, 0x48, 0x90, 0x4A, 0x20, 0x58, 0x50, 0x43, 0x38, 0x36, 0xDD, 0xD3,
};

const Font& font_NotoSansMono_Regular_8() {
  static SmoothFont font(font_NotoSansMono_Regular_8_data);
  return font;
}

}  // namespace roo_display
